-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_57
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_57`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_57` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_57`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=4106 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1235,2010,'',0,'24','1','57','PURCHASES','','2017-04-27 14:41:16',5,0.00,0.00,'','139','2017-04-27 14:41:16','139',0,1),(1236,2011,'',0,'24','1','57','AGO CONSUMPTION','','2017-04-27 14:43:51',5,0.00,0.00,'','139','2017-04-27 14:43:51','139',0,1),(1237,2012,'',0,'24','1','57','WEIGHT AND MEASURE','','2017-04-27 14:44:12',5,0.00,0.00,'','139','2017-04-27 14:44:12','139',0,1),(1238,2013,'',0,'24','1','57','ELECTRICITY AND WATER BILLS','','2017-04-27 14:44:33',5,0.00,0.00,'','139','2017-04-27 14:44:33','139',0,1),(1239,2014,'',0,'24','1','57','FUELING AND REPAIR OF OFFICIAL','','2017-04-27 14:44:52',5,0.00,0.00,'','139','2017-04-27 14:44:52','139',0,1),(1240,2015,'',0,'24','1','57','PRINTING AND STATIONARY','','2017-04-27 14:45:13',5,0.00,0.00,'','139','2017-04-27 14:45:13','139',0,1),(1241,2016,'',0,'24','1','57','PUMP AND GENERATOR REPAIRS','','2017-04-27 15:16:45',5,0.00,0.00,'','139','2017-04-27 15:16:45','139',0,1),(1242,2017,'',0,'24','1','57','STATION REPAIRS AND MAINTENANC','','2017-04-27 15:21:15',5,0.00,0.00,'','139','2017-04-27 15:21:15','139',0,1),(1243,2018,'',0,'24','1','57','PUBLIC RELATION','','2017-04-27 15:22:22',5,0.00,0.00,'','139','2017-04-27 15:22:22','139',0,1),(1244,2019,'',0,'24','1','57','COMPUTER AND INTERNET SUB','','2017-04-27 15:22:59',5,0.00,0.00,'','139','2017-04-27 15:22:59','139',0,1),(1245,2020,'',0,'24','1','57','DISCOUNT ALLOWED','','2017-04-27 15:23:21',5,0.00,0.00,'','139','2017-04-27 15:23:21','139',0,1),(1246,2021,'',0,'24','1','57','SALARIES AND WAGES','','2017-04-27 15:23:57',5,0.00,0.00,'','139','2017-04-27 15:23:57','139',0,1),(1247,2022,'',0,'24','1','57','TRANSPORT FARE','','2017-04-27 15:24:36',5,0.00,0.00,'','139','2017-04-27 15:24:36','139',0,1),(1248,2023,'',0,'24','1','57','OTHER OPERATING EXPENSES','','2017-04-27 15:25:16',5,0.00,0.00,'','139','2017-04-27 15:25:16','139',0,1),(1249,2024,'',0,'24','1','57','STAFF RENT','','2017-04-27 15:25:39',5,0.00,0.00,'','139','2017-04-27 15:25:39','139',0,1),(1250,2025,'',0,'24','1','57','STAFF TRAINING AND ACCOMODATIO','','2017-04-27 15:26:00',5,0.00,0.00,'','139','2017-04-27 15:26:00','139',0,1),(1251,2026,'',0,'24','1','57','MEDICAL EXPENSES','','2017-04-27 15:26:23',5,0.00,0.00,'','139','2017-04-27 15:26:23','139',0,1),(1252,2027,'',0,'24','1','57','CLEANING AND SANITARY','','2017-04-27 15:26:50',5,0.00,0.00,'','139','2017-04-27 15:26:50','139',0,1),(1253,2028,'',0,'20','1','57','SALES','','2017-04-27 15:27:14',5,0.00,0.00,'','139','2017-04-27 15:27:14','139',0,1),(1254,2029,'',0,'2','1','57','ZENITH BANK 1011595101 SURPLUS','','2017-04-27 15:27:40',5,0.00,0.00,'','139','2017-04-27 15:27:40','139',0,1),(1255,2030,'',0,'6.1','1','57','CASH','','2017-04-27 15:27:59',5,0.00,0.00,'','139','2017-04-27 15:27:59','139',0,1),(1256,2031,'',0,'5','1','57','INVENTORY VALUE ADJUSTMENT','','2017-04-27 15:28:20',5,0.00,0.00,'','139','2017-04-27 15:28:20','139',0,1),(1301,2032,'',0,'2','1','57','UNITY BANK 0050787096','','2017-05-02 16:06:50',5,0.00,0.00,'','139','2021-11-09 19:54:05','178',0,1),(3865,400686,'',0,'2','1','57','E-BILLS 0027617164','','2021-11-21 15:04:06',5,0.00,0.00,'','202','2021-11-21 15:04:06','202',0,0),(4067,400739,'',0,'2','1','57','AAR EBILLS 1004717261','AAR 5635','2022-01-04 13:38:52',5,0.00,0.00,'','202','2022-01-04 13:38:52','202',0,0),(4102,400749,'',0,'2','1','57','SANI LIMAN/MUHAMMAD SULE','','2022-01-24 12:20:32',5,0.00,0.00,'','202','2022-01-24 12:20:32','202',0,0),(4103,400750,'',0,'2','1','57','ZENITH 1017823123','','2022-03-03 11:24:43',5,0.00,0.00,'','202','2022-03-03 11:24:43','202',0,0),(4104,400751,'',0,'2','1','57','CASH IMPREST','','2022-04-05 14:43:23',5,0.00,0.00,'','202','2022-04-05 14:43:23','202',0,0),(4105,2028,'',0,'24','1','57','RETAILS OPERATING EXPENSES','','2022-04-05 14:43:42',5,0.00,0.00,'','202','2022-04-05 14:43:42','202',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=82353 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (82253,'1','57','0000-00-00','2022-01-13 12:46:00',10,'202','','0000-00-00 00:00:00','202','2022-01-13 12:46:41'),(82342,'1','57','0000-00-00','2022-02-11 12:57:03',10,'716','','0000-00-00 00:00:00','202','2022-03-14 10:58:18'),(82347,'1','57','0000-00-00','2022-03-05 11:46:22',10,'716','','0000-00-00 00:00:00','202','2022-03-07 13:53:58'),(82348,'1','57','0000-00-00','2022-03-13 06:11:29',10,'716','','0000-00-00 00:00:00','202','2022-04-04 13:25:28'),(82352,'1','57','0000-00-00','2022-04-25 21:30:36',0,'716','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=174111 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (173695,'1','57','82253','76','supplier',0.00,'AGO WEEKLY CONSUMPTION ',35500.00,'2022-01-13'),(173696,'1','57','82253','1236','24',35500.00,'AGO WEEKLY CONSUMPTION ',0.00,'2022-01-13'),(174067,'1','57','82342','1236','24',39390.00,'AGO CONSUMING FOR 7 DAY101 at 390 ',0.00,'2022-02-10'),(174069,'1','57','82342','76','supplier',0.00,'AGO CONSUMING FOR 7 DAY101 at 390 ',39390.00,'2022-02-10'),(174084,'1','57','82347','1236','24',46000.00,'AGO CONSUMPTION 100',0.00,'2022-03-03'),(174085,'1','57','82347','76','supplier',0.00,'AGO CONSUMPTION 100',46000.00,'2022-03-03'),(174086,'1','57','82348','1236','24',60000.00,'Ago consultant 100',0.00,'2022-03-11'),(174087,'1','57','82348','76','supplier',0.00,'Ago consultant 100',60000.00,'2022-03-13'),(174088,'1','57','82348','1236','24',70000.00,'Ago consultant 100',0.00,'2022-03-27'),(174089,'1','57','82348','76','supplier',0.00,'Ago consultant 100',70000.00,'2022-03-27'),(174096,'1','57','82352','76','supplier',66500.00,'Ago consultant 100',0.00,'2022-04-25'),(174097,'1','57','82352','1236','24',80000.00,'Ago consultant 100 ',0.00,'2022-09-02'),(174098,'1','57','82352','76','supplier',0.00,'Ago consultant 100 ',80000.00,'2022-09-02'),(174099,'1','57','82352','1236','24',0.00,'Ago consultant 100 ',80000.00,'2022-09-12'),(174100,'1','57','82352','76','supplier',80000.00,'Ago consultant 100 ',0.00,'2022-09-12'),(174101,'1','57','82352','1236','24',80000.00,'Ago consultant 100 ',0.00,'2022-09-12'),(174102,'1','57','82352','76','supplier',0.00,'Ago consultant 100 ',80000.00,'2022-09-12'),(174103,'1','57','82352','1236','24',80000.00,'Ago consultant 100 ',0.00,'2022-09-12'),(174104,'1','57','82352','76','supplier',0.00,'Ago consultant 100 ',80000.00,'2022-09-12'),(174105,'1','57','82352','1236','24',0.00,'Ago consultant 100 ',80000.00,'2022-09-23'),(174106,'1','57','82352','76','supplier',80000.00,'Ago consultant 100 ',0.00,'2022-09-23'),(174107,'1','57','82352','1236','24',0.00,'Ago consultant 100 ',80000.00,'2022-10-05'),(174108,'1','57','82352','76','supplier',80000.00,'Ago consultant 100 ',0.00,'2022-10-05'),(174109,'1','57','82352','1236','24',43000.00,'Ago consultant 50',0.00,'2022-11-16'),(174110,'1','57','82352','76','supplier',0.00,'Ago consultant 50',43000.00,'2022-11-16');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=47257 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
INSERT INTO `accounts_vouchers` VALUES (46550,'1','57','2021-11-18','240575','1255',0.00,'2021-11-21 19:32:34',0,'716','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(46551,'1','57','2021-11-19','240579','1255',0.00,'2021-11-21 19:36:44',0,'716','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(46552,'1','57','2021-11-20','240584','1255',0.00,'2021-11-21 19:42:50',0,'716','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47081,'1','57','2021-12-29','249671','1255',0.00,'2021-12-29 09:18:33',0,'716','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47151,'1','57','2022-01-05','','1255',0.00,'2022-01-05 10:31:19',0,'716','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47225,'1','57','2022-01-12','253287','1255',0.00,'2022-01-13 10:40:15',0,'716','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47250,'1','57','2022-01-14','253613','1255',0.00,'2022-01-14 16:19:28',0,'716','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47256,'1','57','2022-02-26','257210','1255',0.00,'2022-02-27 20:09:30',0,'716','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=86824 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
INSERT INTO `accounts_vouchers_items` VALUES (84716,'1','57',46550,1236,'AGO COMSUPTION 15 LITRES @350',5250.00),(84717,'1','57',46551,1236,'16 LTS OF AGO FOR GENERATOR @350',5600.00),(84718,'1','57',46552,1236,'AGO COMSUPTION 112  LITRES  @350 FOR  ONE WEAK FROM sat to sat.',39200.00),(86356,'1','57',47081,1236,'AGO CONSUMPTION FOR 5 DAYS',22400.00),(86498,'1','57',47151,1236,'AGO CONSUMPTION FROM 28 DECTO 4 JAN 101.5 LTR@350 SHIFT ID 251179',35525.00),(86771,'1','57',47225,1236,'AGO CONSUMPTION FOR 7days from 4 jan to 12 jan 101.5litres@350',35525.00),(86822,'1','57',47250,1236,'AGO CONSUMPTION FROM 4janTO14jan 130.5ltr-@350 shift id 253613',45675.00),(86823,'1','57',47256,1236,'Ago CONSUMING 100  AT  415  For 7 dey firom 18 February 25',41500.00);
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','57','NIGERIA POLICE FORCE(ELECTION)','CP YUSUF ','08071785115','dopstransport@gmail.com','FCT','FCT','NIGERIA POLICE FORCE HEAD QUARTER','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 17:48:15',5,'974','2023-02-21 17:48:15','974');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18571 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','57',17788,'445',787.60,70.00,'2021-11-26','','2021-11-26 11:11:39','202','202',2021,'202','2021-11-26 11:11:39',5),('1','57',17798,'445',70.00,1600.00,'2021-11-27','','2021-11-27 10:09:13','202','202',2021,'202','2021-11-27 10:09:13',5),('1','57',18446,'447',395.00,1300.00,'2022-01-15','','2022-01-15 17:37:57','202','202',2022,'202','2022-01-15 17:37:57',5),('1','57',18447,'445',743.52,400.00,'2022-01-15','','2022-01-15 17:38:19','202','202',2022,'202','2022-01-15 17:38:19',5),('1','57',18564,'447',764.25,1400.00,'2022-01-26','','2022-01-26 11:16:20','202','202',2022,'202','2022-01-26 11:16:20',5),('1','57',18565,'468',0.00,400.00,'2022-02-11','','2022-02-11 12:29:50','202','202',2022,'202','2022-02-11 12:29:50',5),('1','57',18566,'468',400.00,700.00,'2022-03-12','','2022-03-12 11:05:45','202','202',2022,'202','2022-03-12 11:05:45',5),('1','57',18567,'468',700.00,400.00,'2022-03-12','','2022-03-12 13:57:00','202','202',2022,'202','2022-03-12 13:57:00',5),('1','57',18568,'447',26.42,326.00,'2022-03-12','','2022-03-12 13:57:23','202','202',2022,'202','2022-03-12 13:57:23',5),('1','57',18569,'445',400.00,300.00,'2022-06-07','','2022-06-07 11:22:39','202','202',2022,'202','2022-06-07 11:22:39',5),('1','57',18570,'447',16.71,200.00,'2022-06-07','','2022-06-07 11:23:20','202','202',2022,'202','2022-06-07 11:23:20',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1240 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','57','445',1190,'5','PUMP 1',797508.90,'DISPENSING PMS','',NULL,NULL,'',5,'2021-11-15 11:00:07','178'),('1','57','445',1191,'5','PUMP 2',82132.79,'DISPENSING PMS','',NULL,NULL,'',5,'2021-11-15 11:00:28','178'),('1','57','446',1192,'5','PUMP 3',109021.93,'DISPENSING PMS','',NULL,NULL,'',5,'2021-11-15 11:00:58','178'),('1','57','446',1193,'5','PUMP 4',741483.38,'DISPENSING PMS','',NULL,NULL,'',5,'2021-11-15 11:01:42','178'),('1','57','447',1198,'5','AGO PUMP 1',416415.90,'DISPENSING AGO','',NULL,NULL,'',5,'2021-11-15 11:02:17','178'),('1','57','468',1239,'5','AGO PUMP 2',589933.53,'DISPENSING AGO','',NULL,NULL,'',5,'2021-11-15 11:02:48','178');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=339 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (337,'1','57','1192','446','TANK SWAP','2021-11-09 19:31:40',0,'178'),(338,'1','57','1193','446','TANK SWAP','2021-11-09 19:32:05',0,'178');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257493 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','57',240528,'MORNING SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'716',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','57',240535,'MORNING SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'716',73585.05,73585.05,'716','2021-11-21 11:36:41','202','2021-11-21 13:48:23',10,0),('1','57',240575,'AFTERNOON SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'716',173713.65,173713.65,'716','2021-11-21 13:58:32','202','2021-11-21 14:00:25',10,0),('1','57',240579,'MORNING SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'716',701971.05,701971.05,'716','2021-11-21 14:12:25','202','2021-11-21 14:14:38',10,0),('1','57',240582,'AFTERNOON SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'716',219829.50,219829.50,'716','2021-11-21 14:22:19','202','2021-11-21 14:24:08',10,0),('1','57',240584,'MORNING SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'716',322345.65,322345.65,'716','2021-11-21 14:33:39','202','2021-11-21 14:35:16',10,0),('1','57',240585,'AFTERNOON SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'716',242853.60,242853.60,'716','2021-11-21 14:44:44','202','2021-11-21 14:46:49',10,0),('1','57',240586,'MORNING SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'716',589873.35,589873.35,'716','2021-11-21 15:08:55','202','2021-11-21 15:13:51',10,0),('1','57',240592,'AFTERNOON SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'716',364988.25,364988.25,'716','2021-11-22 09:40:44','202','2021-11-22 12:57:07',10,0),('1','57',240812,'MORNING SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'716',379830.00,379830.00,'716','2021-11-22 14:38:30','202','2021-11-22 16:02:07',10,0),('1','57',240876,'AFTERNOON SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'716',368702.40,368702.40,'716','2021-11-23 09:49:05','202','2021-11-23 11:22:31',10,0),('1','57',241137,'MORNING SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'716',397029.60,397029.60,'716','2021-11-23 14:50:00','202','2021-11-24 09:18:04',10,0),('1','57',241326,'AFTERNOON SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'716',308637.45,308637.45,'716','2021-11-24 09:44:50','202','2021-11-24 18:16:19',10,0),('1','57',241419,'MORNING SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'716',329135.40,329135.40,'716','2021-11-24 18:21:32','202','2021-11-24 18:24:28',10,0),('1','57',241422,'AFTERNOON  SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'716',347551.05,347551.05,'716','2021-11-25 09:17:46','202','2021-11-25 11:42:43',10,0),('1','57',241662,'MORNING SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'716',141319.20,141319.20,'716','2021-11-27 15:26:22','202','2021-11-29 10:28:50',10,0),('1','57',242540,'AFTERNOON','2021-11-25','2021-11-25 00:00:00',NULL,'716',0.00,0.00,'716','2021-11-29 10:39:59','202','2021-12-01 09:54:17',10,0),('1','57',244179,'MORNING SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-06 12:56:40','202','2021-12-06 13:26:47',10,0),('1','57',244249,'AFTERNOON SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-06 20:44:51','202','2021-12-07 09:44:46',10,0),('1','57',244392,'MORNING SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-07 11:18:11','202','2021-12-07 18:01:19',10,0),('1','57',244676,'AFTERNOON SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-08 16:26:10','202','2021-12-08 17:38:15',10,0),('1','57',244691,'MORNING SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-08 18:36:58','202','2021-12-09 10:04:13',10,0),('1','57',244940,'AFTERNOON SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-09 20:46:15','202','2021-12-13 08:48:12',10,0),('1','57',245833,'MORNING SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 15:16:32','202','2021-12-13 15:18:01',10,0),('1','57',245835,'AFTERNOON SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 15:19:08','202','2021-12-13 15:20:00',10,0),('1','57',245836,'MORNING SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 15:21:18','202','2021-12-13 15:22:14',10,0),('1','57',245839,'AFTERNOON SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 15:23:24','202','2021-12-13 15:26:35',10,0),('1','57',245841,'MORNING SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 15:27:50','202','2021-12-13 15:28:46',10,0),('1','57',245842,'AFTERNOON SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 15:29:52','202','2021-12-13 15:30:38',10,0),('1','57',245843,'MORNING SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 15:31:33','202','2021-12-13 15:32:40',10,0),('1','57',245845,'AFTERNOON SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 15:34:14','202','2021-12-13 15:35:04',10,0),('1','57',245846,'MORNING SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 15:36:10','202','2021-12-13 15:37:59',10,0),('1','57',245848,'AFTERNOON SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 15:39:14','202','2021-12-13 15:40:27',10,0),('1','57',245850,'MORNING SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 15:42:11','202','2021-12-13 15:43:07',10,0),('1','57',245851,'AFTERNOON SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 15:44:39','202','2021-12-13 15:45:29',10,0),('1','57',245852,'MORNING SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 15:47:01','202','2021-12-13 15:47:55',10,0),('1','57',245853,'AFTERNOON SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 15:49:02','202','2021-12-13 15:49:49',10,0),('1','57',245854,'MORNING SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 15:50:42','202','2021-12-13 15:51:21',10,0),('1','57',245855,'AFTERNOON SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 15:52:44','202','2021-12-13 15:56:32',10,0),('1','57',245856,'MORNING SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 15:57:55','202','2021-12-13 15:58:52',10,0),('1','57',245857,'AFTERNOON SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 15:59:50','202','2021-12-13 16:00:29',10,0),('1','57',245859,'MORNING SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 16:02:08','202','2021-12-13 16:03:06',10,0),('1','57',245860,'AFTERNOON SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 16:04:10','202','2021-12-13 16:05:22',10,0),('1','57',245861,'MORNING SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 16:06:23','202','2021-12-13 16:07:10',10,0),('1','57',245862,'AFTERNOON SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 16:08:36','202','2021-12-13 16:09:25',10,0),('1','57',245864,'MORNING SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 16:10:35','202','2021-12-13 16:11:31',10,0),('1','57',245865,'AFTERNOON SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 16:12:35','202','2021-12-13 16:13:55',10,0),('1','57',245867,'MORNING SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 16:15:18','202','2021-12-13 16:16:18',10,0),('1','57',245868,'AFTERNOON SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 16:17:32','202','2021-12-13 16:18:45',10,0),('1','57',245869,'MORNING SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 16:20:20','202','2021-12-13 16:21:05',10,0),('1','57',245870,'AFTERNOON SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 16:22:16','202','2021-12-13 16:23:50',10,0),('1','57',245871,'MORNING SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 16:25:04','202','2021-12-13 16:25:59',10,0),('1','57',245872,'AFTERNOON SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-13 16:26:56','202','2021-12-16 15:36:18',10,0),('1','57',247028,'MORNING SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-18 10:52:16','202','2021-12-18 10:59:40',10,0),('1','57',247030,'AFTERNOON SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-18 11:02:59','202','2021-12-18 11:03:10',10,0),('1','57',247031,'MORNING SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-18 11:04:51','202','2021-12-18 11:10:45',10,0),('1','57',247032,'AFTERNOON SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-18 11:11:54','202','2021-12-18 11:12:30',10,0),('1','57',247034,'MORNING SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-18 11:13:30','202','2021-12-18 11:14:42',10,0),('1','57',247035,'AFTERNOON SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-18 11:15:43','202','2021-12-18 11:17:09',10,0),('1','57',247036,'MORNING SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-18 11:18:11','202','2021-12-18 11:19:47',10,0),('1','57',247038,'AFTERNOON SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-18 11:20:56','202','2021-12-18 11:22:07',10,0),('1','57',247039,'MORNING SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-18 11:24:28','202','2021-12-18 11:25:57',10,0),('1','57',247040,'AFTERNOON SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-18 11:27:01','202','2021-12-24 16:43:23',10,0),('1','57',248554,'MORNING SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-24 16:46:02','202','2021-12-24 16:46:18',10,0),('1','57',248555,'AFTERNOON SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-24 16:48:17','202','2021-12-24 16:48:25',10,0),('1','57',248556,'MORNING SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-24 16:49:28','202','2021-12-24 16:50:21',10,0),('1','57',248557,'AFTERNOON SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-24 16:51:11','202','2021-12-24 16:51:34',10,0),('1','57',248559,'MORNING SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-24 16:52:45','202','2021-12-24 16:52:59',10,0),('1','57',248560,'AFTERNOON SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-24 16:54:48','202','2021-12-24 16:55:43',10,0),('1','57',248562,'MORNING SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-24 16:57:01','202','2021-12-24 17:04:38',10,0),('1','57',248566,'AFTERNOON SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-24 17:06:25','202','2021-12-24 17:08:09',10,0),('1','57',248567,'MORNING SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-24 17:09:34','202','2021-12-24 17:10:08',10,0),('1','57',248568,'AFTERNOON SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-24 17:11:13','202','2021-12-24 17:12:09',10,0),('1','57',248569,'MORNING SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-24 17:13:04','202','2021-12-24 17:13:42',10,0),('1','57',248603,'AFTERNOON SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'716',1228489.50,1228489.50,'716','2021-12-25 12:51:29','202','2021-12-27 13:56:38',10,0),('1','57',249475,'MORNING SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'716',209965.00,209965.00,'716','2021-12-28 13:16:45','202','2021-12-29 08:57:20',10,0),('1','57',249671,'AFTERNOON SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'716',622713.00,622713.00,'716','2021-12-29 09:03:41','202','2021-12-29 09:06:38',10,0),('1','57',249679,'MORNING SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'716',32550.00,32550.00,'716','2021-12-29 09:28:34','202','2021-12-29 09:31:29',10,0),('1','57',249683,'AFTERNOON SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'716',1419999.00,1419999.00,'716','2021-12-29 09:34:47','202','2021-12-29 09:35:44',10,0),('1','57',249685,'MORNING SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'716',517107.50,517107.50,'716','2021-12-29 09:40:00','202','2021-12-29 09:45:28',10,0),('1','57',249691,'AFTERNOON SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'716',1133272.00,1133272.00,'716','2021-12-29 09:48:34','202','2021-12-29 09:50:31',10,0),('1','57',249694,'MORNING SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'716',31451.00,31451.00,'716','2021-12-29 09:54:29','202','2021-12-29 09:56:33',10,0),('1','57',249695,'AFTERNOON SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'716',822286.50,822286.50,'716','2021-12-29 09:58:31','202','2021-12-29 09:59:12',10,0),('1','57',249697,'MORNING SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-30 13:35:50','202','2021-12-30 13:37:28',10,0),('1','57',249996,'AFTERNOON SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-30 13:39:04','202','2021-12-30 13:41:07',10,0),('1','57',249999,'MORNING SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'716',0.00,0.00,'716','2021-12-30 13:42:43','202','2021-12-30 13:44:34',10,0),('1','57',250001,'AFTERNOON SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'716',578900.00,578900.00,'716','2021-12-31 10:46:43','202','2021-12-31 10:58:04',10,0),('1','57',250248,'MORNING SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'716',314867.00,314867.00,'716','2022-01-01 11:35:39','202','2022-01-01 13:10:28',10,0),('1','57',250461,'AFTERNOON SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'716',213150.00,213150.00,'716','2022-01-01 13:24:55','202','2022-01-01 13:29:06',10,0),('1','57',250471,'MORNING SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'716',5288.50,5288.50,'716','2022-01-04 10:49:17','202','2022-01-04 10:50:18',10,0),('1','57',251114,'AFTERNOON SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'716',334911.50,334911.50,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','57',251124,'AFTERNOON SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'716',334911.50,334911.50,'716','2022-01-04 11:47:47','202','2022-01-04 12:17:02',10,0),('1','57',251139,'MORNING SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'716',344900.50,344900.50,'716','2022-01-04 12:57:02','202','2022-01-04 13:03:24',10,0),('1','57',251157,'AFTERNOON','2022-01-02','2022-01-02 00:00:00',NULL,'716',325360.00,325360.00,'716','2022-01-04 14:14:32','202','2022-01-04 14:15:17',10,0),('1','57',251172,'MORNING SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'716',493202.50,493202.50,'716','2022-01-04 14:19:05','202','2022-01-04 14:19:42',10,0),('1','57',251173,'AFTERNOON SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'716',362845.00,362845.00,'716','2022-01-04 14:23:19','202','2022-01-04 14:24:33',10,0),('1','57',251177,'MORNING SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'716',368672.50,368672.50,'716','2022-01-04 14:29:00','202','2022-01-04 14:30:34',10,0),('1','57',251179,'AFTERNOON SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'716',259486.50,259486.50,'716','2022-01-05 09:51:09','202','2022-01-05 09:56:16',10,0),('1','57',251348,'MORNING SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'716',224304.50,224304.50,'716','2022-01-05 15:31:17','202','2022-01-05 19:03:05',10,0),('1','57',251480,'AFTERNOON SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'716',175000.00,175000.00,'716','2022-01-06 10:10:00','202','2022-01-07 11:45:43',10,0),('1','57',251852,'MORNING SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'716',168595.00,168595.00,'716','2022-01-07 12:00:36','202','2022-01-07 12:42:00',10,0),('1','57',251862,'AFTERNOON SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'716',384048.00,384048.00,'716','2022-01-07 12:59:15','202','2022-01-07 17:54:13',10,0),('1','57',251962,'MORNING SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'716',65667.00,65667.00,'716','2022-01-07 22:33:05','202','2022-01-09 19:27:20',10,0),('1','57',252568,'AFTERNOON SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'716',423405.50,423405.50,'716','2022-01-10 11:00:54','202','2022-01-10 11:10:06',10,0),('1','57',252572,'MORNING SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'716',418775.00,418775.00,'716','2022-01-10 11:24:47','202','2022-01-10 11:29:38',10,0),('1','57',252576,'AFTERNOON SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'716',122475.50,122475.50,'716','2022-01-10 11:33:35','202','2022-01-10 11:43:10',10,0),('1','57',252581,'AFTERNOON SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'716',702198.00,702198.00,'716','2022-01-10 11:48:59','202','2022-01-10 11:50:17',10,0),('1','57',252584,'AFTERNOON SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'716',703290.00,703290.00,'716','2022-01-10 12:04:02','202','2022-01-10 12:34:50',10,0),('1','57',252805,'MORNING SHIFT ','2022-01-10','2022-01-10 00:00:00',NULL,'716',532129.50,532129.50,'716','2022-01-11 10:32:19','202','2022-01-11 10:33:40',10,0),('1','57',252807,'AFTERNOON SHIFT ','2022-01-10','2022-01-10 00:00:00',NULL,'716',212051.00,212051.00,'716','2022-01-11 10:39:22','202','2022-01-11 10:44:10',10,0),('1','57',252897,'MORNING SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'716',76979.00,76979.00,'716','2022-01-11 17:37:15','202','2022-01-11 18:54:42',10,0),('1','57',252932,'AFTERNOON SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'716',556608.50,556608.50,'716','2022-01-12 08:24:46','202','2022-01-12 09:56:02',10,0),('1','57',253188,'MORNING SHIFT ','2022-01-12','2022-01-12 00:00:00',NULL,'716',291389.00,291389.00,'716','2022-01-12 22:50:08','202','2022-01-13 10:13:31',10,0),('1','57',253287,'AFTERNOON SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'716',551460.00,551460.00,'716','2022-01-13 10:27:14','202','2022-01-13 10:44:05',10,0),('1','57',253299,'MORNING SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'716',350000.00,350000.00,'716','2022-01-13 15:38:57','202','2022-01-13 15:47:40',10,0),('1','57',253408,'AFTERNOON SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'716',333900.00,333900.00,'716','2022-01-13 21:43:21','202','2022-01-14 09:49:06',10,0),('1','57',253613,'MORNING SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'716',208257.00,208257.00,'716','2022-01-14 14:53:24','202','2022-01-14 15:08:23',10,0),('1','57',253635,'AFTERNOON SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'716',191800.00,191800.00,'716','2022-01-14 23:06:11','202','2022-01-15 10:45:22',10,0),('1','57',253813,'MORNING SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'716',199500.00,199500.00,'716','2022-01-15 18:45:41','202','2022-01-15 21:08:58',10,0),('1','57',253921,'AFTERNOON SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'716',218718.50,218718.50,'716','2022-01-15 21:59:29','202','2022-01-16 16:11:00',10,0),('1','57',254107,'MORNING SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'716',0.00,0.00,'716','2022-01-16 17:34:48','202','2022-01-16 19:47:06',10,0),('1','57',254261,'AFTERNOON SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'716',0.00,0.00,'716','2022-01-17 09:28:09','202','2022-01-17 09:46:34',10,0),('1','57',254309,'MORNING SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'716',0.00,0.00,'716','2022-01-17 13:04:08','202','2022-01-17 14:50:04',10,0),('1','57',254367,'AFTERNOON SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'716',0.00,0.00,'716','2022-01-18 06:52:34','202','2022-01-18 10:18:19',10,0),('1','57',254550,'MONING SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'716',0.00,0.00,'716','2022-01-18 11:36:37','202','2022-01-18 15:09:57',10,0),('1','57',254660,'AFTERNOON SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'716',771018.50,771018.50,'716','2022-01-19 11:01:30','202','2022-01-19 11:10:54',10,0),('1','57',254866,'MORNING SHIFT ','2022-01-19','2022-01-19 00:00:00',NULL,'716',162277.50,162277.50,'716','2022-01-19 16:10:22','202','2022-01-19 17:08:41',10,0),('1','57',254912,'AFTERNOON SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'716',158200.00,158200.00,'716','2022-01-20 09:39:33','202','2022-01-20 10:08:28',10,0),('1','57',255105,'MORNING SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'716',591941.00,591941.00,'716','2022-01-20 15:39:19','202','2022-01-20 15:43:43',10,0),('1','57',255117,'AFTERNOON','2022-01-20','2022-01-20 00:00:00',NULL,'716',1113262.50,1113262.50,'716','2022-01-21 09:06:28','202','2022-01-21 09:46:58',10,0),('1','57',255308,'MORNING SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'716',218552.20,218552.20,'716','2022-01-21 16:06:06','202','2022-01-21 16:36:38',10,0),('1','57',255536,'AFTERNOON SHIFT ','2022-01-21','2022-01-21 00:00:00',NULL,'716',350676.10,350676.10,'716','2022-01-22 10:37:51','202','2022-01-22 10:46:30',10,0),('1','57',255626,'MORNING SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'716',375018.45,375018.45,'716','2022-01-22 16:31:40','202','2022-01-22 17:18:34',10,0),('1','57',255681,'AFTERNOON SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'716',448152.00,448152.00,'716','2022-01-23 09:43:39','202','2022-01-23 13:40:01',10,0),('1','57',255864,'MORNING SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'716',6269.30,6269.30,'716','2022-01-23 17:06:27','202','2022-01-23 17:18:58',10,0),('1','57',255914,'AFTERNOON SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'716',1972813.10,1972813.10,'716','2022-01-24 09:09:12','202','2022-01-24 09:47:04',10,0),('1','57',256112,'MORNING SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'716',400688.50,400688.50,'716','2022-01-24 16:34:29','202','2022-01-24 16:49:53',10,0),('1','57',256122,'AFTERNOON SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'716',257176.20,257176.20,'716','2022-01-25 09:59:08','202','2022-01-25 14:09:02',10,0),('1','57',256400,'MORNING SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'716',355401.15,360406.80,'716','2022-01-26 11:22:02','202','2022-01-26 11:26:49',10,0),('1','57',256613,'AFTERNOON','2022-01-25','2022-01-25 00:00:00',NULL,'716',0.00,0.00,'716','2022-01-26 14:42:39','202','2022-01-26 17:03:02',10,0),('1','57',256652,'MORNING SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'716',0.00,0.00,'716','2022-01-26 18:01:44','202','2022-01-27 10:41:44',10,0),('1','57',256847,'MORNING SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'716',0.00,0.00,'716','2022-01-27 14:58:38','202','2022-01-28 16:24:28',10,0),('1','57',257145,'MORNING SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'716',0.00,0.00,'716','2022-01-28 16:32:47','202','2022-01-29 11:59:15',10,0),('1','57',257146,'AFTERNOON','2022-01-31','2022-01-31 00:00:00',NULL,'716',0.00,0.00,'716','2022-01-31 16:53:15','202','2022-01-31 16:59:06',10,0),('1','57',257147,'AFTERNOON','2022-01-29','2022-01-29 00:00:00',NULL,'716',0.00,0.00,'716','2022-01-31 17:03:38','202','2022-01-31 17:05:34',10,0),('1','57',257148,'MORNING SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'716',0.00,0.00,'716','2022-01-31 17:06:57','202','2022-01-31 17:09:30',10,0),('1','57',257149,'AFTERNOON','2022-01-30','2022-01-30 00:00:00',NULL,'716',0.00,0.00,'716','2022-01-31 17:11:07','202','2022-01-31 17:12:06',10,0),('1','57',257150,'AFTERNOON','2022-01-28','2022-01-28 00:00:00',NULL,'716',0.00,0.00,'716','2022-01-31 17:15:36','202','2022-01-31 17:16:55',10,0),('1','57',257151,'MORNING SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'716',0.00,0.00,'716','2022-01-31 17:18:03','202','2022-01-31 17:19:08',10,0),('1','57',257152,'AFTERNOON','2022-02-01','2022-02-01 00:00:00',NULL,'716',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','57',257153,'MORNING SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'716',0.00,0.00,'716','2022-02-02 16:44:52','202','2022-02-02 16:45:39',10,0),('1','57',257154,'AFTERNOON','2022-02-01','2022-02-01 00:00:00',NULL,'716',0.00,0.00,'716','2022-02-02 16:47:19','202','2022-02-02 16:49:38',10,0),('1','57',257155,'MORNING SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'716',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','57',257156,'MORNING SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'716',0.00,0.00,'716','2022-02-02 16:54:34','202','2022-02-02 16:55:15',10,0),('1','57',257157,'AFTERNOON','2022-02-02','2022-02-02 00:00:00',NULL,'716',0.00,0.00,'716','2022-02-02 16:57:10','202','2022-02-02 16:57:54',10,0),('1','57',257158,'MORNING SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'716',0.00,0.00,'716','2022-02-03 07:18:19','202','2022-02-03 14:08:10',10,0),('1','57',257159,'MORNING SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'716',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','57',257160,'MORNING SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'716',668972.00,650644.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','57',257161,'AFTERNOON','2022-02-03','2022-02-03 00:00:00',NULL,'716',668972.00,668972.00,'716','2022-02-04 12:53:32','202','2022-02-04 15:07:30',10,0),('1','57',257162,'MORNING SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'716',1129678.65,1098728.55,'716','2022-02-04 15:46:49','202','2022-02-04 15:49:18',10,0),('1','57',257163,'AFTERNOON SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'716',508196.80,508196.80,'716','2022-02-05 07:45:55','202','2022-02-05 20:52:11',10,0),('1','57',257164,'MORNING SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'716',694138.40,694138.40,'716','2022-02-06 09:12:42','202','2022-02-06 09:14:33',10,0),('1','57',257165,'AFTERNOON','2022-02-05','2022-02-05 00:00:00',NULL,'716',428203.00,428203.00,'716','2022-02-06 09:22:08','202','2022-02-06 09:26:37',10,0),('1','57',257166,'MORNING SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'716',235102.20,235102.20,'716','2022-02-06 20:20:27','202','2022-02-07 11:03:15',10,0),('1','57',257167,'AFTERNOON','2022-02-06','2022-02-06 00:00:00',NULL,'716',698200.60,698200.60,'716','2022-02-07 11:18:57','202','2022-02-07 11:22:55',10,0),('1','57',257168,'MORNING SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'716',543430.40,543430.40,'716','2022-02-07 17:29:08','202','2022-02-07 17:37:59',10,0),('1','57',257169,'AFTERNOON','2022-02-07','2022-02-07 00:00:00',NULL,'716',696863.00,696863.00,'716','2022-02-07 22:44:51','202','2022-02-08 09:48:17',10,0),('1','57',257170,'MORNING SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'716',370948.40,370948.40,'716','2022-02-08 16:05:08','202','2022-02-09 08:51:10',10,0),('1','57',257171,'AFTERNOON','2022-02-08','2022-02-08 00:00:00',NULL,'716',1653919.60,1653919.60,'716','2022-02-09 09:03:29','202','2022-02-09 11:15:52',10,0),('1','57',257172,'MORNING SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'716',0.00,0.00,'716','2022-02-10 14:09:17','202','2022-02-11 10:59:10',10,0),('1','57',257173,'AFTERNOON','2022-02-09','2022-02-09 00:00:00',NULL,'716',0.00,0.00,'716','2022-02-11 11:18:46','202','2022-02-11 11:27:28',10,0),('1','57',257174,'MORNING SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'716',0.00,0.00,'716','2022-02-11 11:34:23','202','2022-02-11 11:36:55',10,0),('1','57',257175,'AFTERNOON','2022-02-10','2022-02-10 00:00:00',NULL,'716',1257660.30,1257660.30,'716','2022-02-11 11:43:34','202','2022-02-11 12:21:07',10,0),('1','57',257176,'MORNING SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'716',363698.40,363698.40,'716','2022-02-11 16:28:59','202','2022-02-12 11:49:16',10,0),('1','57',257177,'AFTERNOON','2022-02-11','2022-02-11 00:00:00',NULL,'716',612296.10,612296.10,'716','2022-02-12 11:53:20','202','2022-02-12 11:56:40',10,0),('1','57',257178,'MORNING SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'716',246027.60,246027.60,'716','2022-02-12 14:40:15','202','2022-02-13 21:21:20',10,0),('1','57',257179,'AFTERNOON','2022-02-12','2022-02-12 00:00:00',NULL,'716',520884.00,520884.00,'716','2022-02-13 23:00:14','202','2022-02-14 12:28:26',10,0),('1','57',257180,'MORNING SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'716',110000.00,110000.00,'716','2022-02-14 12:39:09','202','2022-02-14 12:43:40',10,0),('1','57',257181,'AFTERNOON','2022-02-13','2022-02-13 00:00:00',NULL,'716',1299148.00,1299148.00,'716','2022-02-14 12:46:33','202','2022-02-14 12:57:36',10,0),('1','57',257182,'MORNING SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'716',481696.00,481696.00,'716','2022-02-14 18:23:55','202','2022-02-15 10:49:30',10,0),('1','57',257183,'AFTERNOON','2022-02-14','2022-02-14 00:00:00',NULL,'716',398304.00,398304.00,'716','2022-02-15 11:23:28','202','2022-02-15 11:38:16',10,0),('1','57',257184,'MORNING SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'716',173292.00,173292.00,'716','2022-02-15 15:50:07','202','2022-02-15 18:19:58',10,0),('1','57',257185,'AFTERNOON','2022-02-15','2022-02-15 00:00:00',NULL,'716',546848.00,546848.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','57',257186,'AFTERNOON','2022-02-15','2022-02-15 00:00:00',NULL,'716',546848.00,560519.20,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','57',257187,'AFTERNOON','2022-02-16','2022-02-16 00:00:00',NULL,'716',546848.00,560519.20,'716','2022-02-16 13:41:40','202','2022-02-16 13:54:49',10,0),('1','57',257188,'MORNING SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'716',406832.00,417002.80,'716','2022-02-16 15:56:32','202','2022-02-17 10:56:52',10,0),('1','57',257189,'AFTERNOON','2022-02-16','2022-02-16 00:00:00',NULL,'716',730676.00,748942.90,'716','2022-02-17 11:13:55','202','2022-02-17 11:34:26',10,0),('1','57',257190,'MORNING SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'716',1072.00,1072.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','57',257191,'MORNING SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'716',1072.00,1072.00,'716','2022-02-18 12:00:59','202','2022-02-18 12:09:47',10,0),('1','57',257192,'AFTERNOON','2022-02-17','2022-02-17 00:00:00',NULL,'716',187607.80,187607.80,'716','2022-02-18 12:24:55','202','2022-02-18 12:34:14',10,0),('1','57',257193,'MORNING SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'716',179145.40,179145.40,'716','2022-02-18 20:33:29','202','2022-02-19 10:38:40',10,0),('1','57',257194,'AFTERNOON','2022-02-18','2022-02-18 00:00:00',NULL,'716',213261.50,213261.50,'716','2022-02-19 10:47:22','202','2022-02-19 10:48:42',10,0),('1','57',257195,'MORNING SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'716',881090.00,881090.00,'716','2022-02-19 15:03:10','202','2022-02-19 20:58:35',10,0),('1','57',257196,'AFTERNOON','2022-02-19','2022-02-19 00:00:00',NULL,'716',83020.90,83020.90,'716','2022-02-19 22:31:52','202','2022-02-20 19:31:22',10,0),('1','57',257197,'MORNING SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'716',1701.50,1701.50,'716','2022-02-20 20:23:34','202','2022-02-21 10:29:56',10,0),('1','57',257198,'AFTERNOON','2022-02-20','2022-02-20 00:00:00',NULL,'716',653966.40,653966.40,'716','2022-02-21 11:13:47','202','2022-02-21 13:50:46',10,0),('1','57',257199,'MORNING SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'716',791611.60,791611.60,'716','2022-02-21 15:51:42','202','2022-02-21 17:29:59',10,0),('1','57',257200,'AFTERNOON','2022-02-21','2022-02-21 00:00:00',NULL,'716',391140.00,391140.00,'716','2022-02-22 10:34:01','202','2022-02-22 10:46:52',10,0),('1','57',257201,'MORNING SHIFT','2022-02-22','2022-02-22 21:10:18','2022-02-23 21:10:18','716',22718.10,22718.10,'716','2022-02-22 21:11:21','202','2022-02-23 10:34:45',10,0),('1','57',257202,'AFTERNOON','2022-02-22','2022-02-23 10:47:47','2022-02-24 10:47:47','716',822902.80,822902.80,'716','2022-02-23 10:48:36','202','2022-02-23 11:33:26',10,0),('1','57',257203,'MORNING SHIFT','2022-02-23','2022-02-23 11:42:31','2022-02-24 11:42:31','716',992474.70,992474.70,'716','2022-02-23 17:57:04','202','2022-02-23 23:00:04',10,0),('1','57',257204,'AFTERNOON','2022-02-23','2022-02-23 23:02:09','2022-02-24 23:02:09','716',453037.70,453037.70,'716','2022-02-23 23:03:11','202','2022-02-24 10:22:56',10,0),('1','57',257205,'MORNING SHIFT','2022-02-24','2022-02-24 13:22:45','2022-02-25 13:22:45','716',1482154.10,1482154.10,'716','2022-02-24 17:09:32','202','2022-02-25 11:01:13',10,0),('1','57',257206,'AFTERNOON','2022-02-24','2022-02-25 11:10:03','2022-02-26 11:10:03','716',322149.30,322149.30,'716','2022-02-25 11:10:57','202','2022-02-25 11:15:36',10,0),('1','57',257207,'MORNING SHIFT','2022-02-25','2022-02-25 15:06:53','2022-02-26 15:06:53','716',729980.40,729980.40,'716','2022-02-25 15:09:16','202','2022-02-25 15:10:58',10,0),('1','57',257208,'AFTERNOON','2022-02-25','2022-02-26 06:26:01','2022-02-27 06:26:01','716',46088.10,46088.10,'716','2022-02-26 07:31:24','202','2022-02-26 16:55:10',10,0),('1','57',257209,'MORNING SHIFT','2022-02-26','2022-02-26 17:01:19','2022-02-27 17:01:19','716',577563.80,577563.80,'716','2022-02-26 17:02:16','202','2022-02-27 09:35:36',10,0),('1','57',257210,'AFTERNOON','2022-02-26','2022-02-27 12:45:52','2022-02-28 12:45:52','716',311266.60,311266.60,'716','2022-02-27 12:46:47','202','2022-02-28 10:25:00',10,0),('1','57',257211,'MORNING SHIFT','2022-02-27','2022-02-28 10:37:14','2022-03-01 10:37:14','716',1077377.35,1077377.35,'716','2022-02-28 10:38:20','202','2022-02-28 10:47:48',10,0),('1','57',257212,'AFTERNOON SHIFT','2022-02-27','2022-02-28 14:15:13','2022-03-01 14:15:13','716',1460800.00,1460800.00,'716','2022-02-28 14:18:18','202','2022-02-28 14:20:36',10,0),('1','57',257213,'MORNING SHIFT','2022-02-28','2022-02-28 14:26:57','2022-03-01 14:26:57','716',715389.45,715389.45,'716','2022-02-28 15:05:07','202','2022-02-28 15:18:13',10,0),('1','57',257214,'AFTERNOON SHIFT','2022-02-28','2022-02-28 16:18:26','2022-03-01 16:18:26','716',249020.75,249020.75,'716','2022-03-01 18:01:31','202','2022-03-01 18:09:48',10,0),('1','57',257215,'MORNING SHIFT','2022-03-01','2022-03-01 18:12:03','2022-03-02 18:12:03','716',423432.80,423432.80,'716','2022-03-01 18:13:41','202','2022-03-01 18:17:12',10,0),('1','57',257216,'AFTERNOON SHIFT','2022-03-01','2022-03-01 18:18:00','2022-03-02 18:18:00','716',1148305.00,1148305.00,'716','2022-03-02 17:26:43','202','2022-03-02 17:41:59',10,0),('1','57',257217,'MORNING SHIFT','2022-03-02','2022-03-03 21:45:38','2022-03-04 21:45:38','716',0.00,0.00,'716','2022-03-03 21:46:06','202','2022-03-03 22:11:33',10,0),('1','57',257218,'AFTERNOON SHIFT','2022-03-02','2022-03-04 09:01:36','2022-03-05 09:01:36','716',0.00,0.00,'716','2022-03-04 09:02:18','202','2022-03-04 09:14:26',10,0),('1','57',257219,'MORNING SHIFT','2022-03-03','2022-03-04 09:27:08','2022-03-05 09:27:08','716',0.00,0.00,'716','2022-03-04 12:43:51','202','2022-03-04 12:45:13',10,0),('1','57',257220,'AFTERNOON','2022-03-03','2022-03-04 12:45:46','2022-03-05 12:45:46','716',484433.70,484433.70,'716','2022-03-04 12:46:23','202','2022-03-04 13:44:12',10,0),('1','57',257221,'morning shift','2022-03-04','2022-03-04 16:06:57','2022-03-05 16:06:57','716',938161.10,938161.10,'716','2022-03-04 16:07:53','202','2022-03-04 16:26:37',10,0),('1','57',257222,'afternoon shift no 1','2022-03-04','2022-03-04 16:51:16','2022-03-05 16:51:16','716',452622.30,452622.30,'716','2022-03-04 16:52:01','202','2022-03-05 09:48:06',10,0),('1','57',257223,'afternoon shift no 2','2022-03-04','2022-03-05 10:17:33','2022-03-06 10:17:33','716',435983.40,435983.40,'716','2022-03-05 10:18:41','202','2022-03-05 11:56:44',10,0),('1','57',257224,'morning shift','2022-03-05','2022-03-05 14:27:23','2022-03-06 14:27:23','716',2051581.60,2051581.60,'716','2022-03-05 15:42:47','202','2022-03-07 02:14:47',10,0),('1','57',257225,'afternoon shift ','2022-03-05','2022-03-07 07:05:32','2022-03-08 07:05:32','716',249535.00,249535.00,'716','2022-03-07 07:07:07','202','2022-03-07 08:25:20',10,0),('1','57',257226,'morning shift','2022-03-06','2022-03-07 08:31:06','2022-03-08 08:31:06','716',1056040.00,1056040.00,'716','2022-03-07 08:32:47','202','2022-03-07 08:35:22',10,0),('1','57',257227,'afternoon shift ','2022-03-07','2022-03-07 08:42:23','2022-03-08 08:42:23','716',0.00,0.00,'716','2022-03-07 11:18:19','202','2022-03-07 11:19:51',10,0),('1','57',257228,'afternoon shift ','2022-03-06','2022-03-07 11:24:28','2022-03-08 11:24:28','716',910005.00,910005.00,'716','2022-03-07 11:25:59','202','2022-03-07 11:27:11',10,0),('1','57',257229,'morning shift','2022-03-07','2022-03-07 11:28:37','2022-03-08 11:28:37','716',1000000.00,1000000.00,'716','2022-03-07 16:35:10','202','2022-03-07 17:01:15',10,0),('1','57',257230,'morning shift','2022-03-07','2022-03-07 18:29:48','2022-03-08 18:29:48','716',1000.00,1000.00,'716','2022-03-08 10:56:30','202','2022-03-08 14:18:04',10,0),('1','57',257231,'morning shift','2022-03-08','2022-03-08 15:47:38','2022-03-09 15:47:38','716',1001640.00,1001640.00,'716','2022-03-08 15:48:28','202','2022-03-09 08:33:21',10,0),('1','57',257232,'afternoon shift ','2022-03-08','2022-03-09 08:44:13','2022-03-10 08:44:13','716',121212.00,121212.00,'716','2022-03-09 08:45:04','202','2022-03-09 10:20:21',10,0),('1','57',257233,'morning shift','2022-03-09','2022-03-10 09:52:52','2022-03-11 09:52:52','716',300.00,300.00,'716','2022-03-10 09:59:38','202','2022-03-10 10:44:36',10,0),('1','57',257234,'afternoon shift ','2022-03-09','2022-03-10 11:12:56','2022-03-11 11:12:56','716',300.00,300.00,'716','2022-03-10 16:41:12','202','2022-03-10 16:44:14',10,0),('1','57',257235,'morning shift','2022-03-10','2022-03-10 16:46:17','2022-03-11 16:46:17','716',934944.00,934944.00,'716','2022-03-10 16:47:15','202','2022-03-10 16:50:52',10,0),('1','57',257236,'afternoon shift ','2022-03-10','2022-03-11 09:12:04','2022-03-12 09:12:04','716',1503498.00,1503498.00,'716','2022-03-11 09:13:04','202','2022-03-11 11:44:56',10,0),('1','57',257237,'morning shift','2022-03-11','2022-03-11 15:34:57','2022-03-12 15:34:57','716',301194.00,301194.00,'716','2022-03-11 18:32:59','202','2022-03-11 21:21:53',10,0),('1','57',257238,'afternoon shift ','2022-03-11','2022-03-12 08:10:09','2022-03-13 08:10:09','716',139200.00,139200.00,'716','2022-03-12 14:05:28','202','2022-03-12 22:18:04',10,0),('1','57',257239,'afternoon shift ','2022-03-13','2022-03-13 22:20:54','2022-03-14 22:20:54','716',0.00,0.00,'716','2022-03-24 20:12:30','202','2022-03-28 08:12:18',10,0),('1','57',257240,'afternoon shift ','2022-03-27','2022-03-28 10:40:13','2022-03-29 10:40:13','716',288904.00,288904.00,'716','2022-03-28 10:42:18','202','2022-03-28 10:44:02',10,0),('1','57',257241,'morning shift','2022-03-28','2022-03-28 11:05:05','2022-03-29 11:05:05','716',708099.00,708099.00,'716','2022-03-28 16:16:42','202','2022-03-28 20:24:40',10,0),('1','57',257242,'afternoon shift ','2022-03-28','2022-03-29 06:09:14','2022-03-30 06:09:14','716',17997.00,17997.00,'716','2022-03-29 11:04:47','202','2022-03-29 11:37:17',10,0),('1','57',257243,'morning shift','2022-03-29','2022-03-29 12:10:45','2022-03-30 12:10:45','716',217203.00,217203.00,'716','2022-03-29 17:17:57','202','2022-03-29 18:25:01',10,0),('1','57',257244,'afternoon shift ','2022-03-29','2022-03-30 09:08:14','2022-03-31 09:08:14','716',224497.00,224497.00,'716','2022-03-30 09:09:06','202','2022-03-30 09:38:58',10,0),('1','57',257245,'morning shift','2022-03-30','2022-03-30 15:38:25','2022-03-31 15:38:25','716',18893.00,18893.00,'716','2022-03-30 15:39:41','202','2022-03-31 09:39:41',10,0),('1','57',257246,'afternoon shift ','2022-03-30','2022-03-31 10:19:50','2022-04-01 10:19:50','716',0.00,0.00,'716','2022-03-31 10:22:08','202','2022-03-31 11:20:11',10,0),('1','57',257247,'morning shift','2022-03-31','2022-03-31 15:46:40','2022-04-01 15:46:40','716',6993.00,6993.00,'716','2022-03-31 17:18:34','202','2022-04-01 10:34:17',10,0),('1','57',257248,'afternoon shift ','2022-04-01','2022-04-01 10:39:45','2022-04-02 10:39:45','716',21000.00,21000.00,'716','2022-04-01 10:40:25','202','2022-04-01 11:10:18',10,0),('1','57',257249,'morning shift','2022-04-01','2022-04-01 17:38:00','2022-04-02 17:38:00','716',9205.00,9205.00,'716','2022-04-01 17:39:20','202','2022-04-02 12:30:30',10,0),('1','57',257250,'afternoon shift ','2022-04-01','2022-04-02 12:43:22','2022-04-03 12:43:22','716',65422.00,65422.00,'716','2022-04-02 12:44:24','202','2022-04-02 23:01:04',10,0),('1','57',257251,'morning shift','2022-04-02','2022-04-02 23:07:36','2022-04-03 23:07:36','716',78407.00,78407.00,'716','2022-04-02 23:08:30','202','2022-04-02 23:10:48',10,0),('1','57',257252,'afternoon shift ','2022-04-02','2022-04-02 23:12:11','2022-04-03 23:12:11','716',1700181.00,1700181.00,'716','2022-04-02 23:12:53','202','2022-04-02 23:15:17',10,0),('1','57',257253,'morning shift','2022-04-03','2022-04-04 08:43:25','2022-04-05 08:43:25','716',4998.00,4998.00,'716','2022-04-04 08:44:19','202','2022-04-04 09:33:10',10,0),('1','57',257254,'afternoon shift ','2022-04-03','2022-04-04 09:37:08','2022-04-05 09:37:08','716',6720.00,6720.00,'716','2022-04-04 09:37:53','202','2022-04-04 11:00:42',10,0),('1','57',257255,'morning shift','2022-04-04','2022-04-04 17:11:24','2022-04-05 17:11:24','716',64792.00,64792.00,'716','2022-04-04 17:12:22','202','2022-04-05 09:59:59',10,0),('1','57',257256,'afternoon shift ','2022-04-04','2022-04-05 11:15:30','2022-04-06 11:15:30','716',34496.00,34496.00,'716','2022-04-05 11:16:13','202','2022-04-05 11:29:40',10,0),('1','57',257257,'morning shift','2022-04-05','2022-04-05 17:42:24','2022-04-06 17:42:24','716',42000.00,42000.00,'716','2022-04-05 17:43:22','202','2022-04-05 22:42:40',10,0),('1','57',257258,'afternoon shift ','2022-04-05','2022-04-06 07:54:06','2022-04-07 07:54:06','716',0.00,0.00,'716','2022-04-06 07:54:41','202','2022-04-06 09:21:10',10,0),('1','57',257259,'afternoon shift on','2022-04-05','2022-04-06 09:23:20','2022-04-07 09:23:20','716',30303.00,30303.00,'716','2022-04-06 09:24:04','202','2022-04-06 14:51:53',10,0),('1','57',257260,'morning shift','2022-04-06','2022-04-07 09:45:09','2022-04-08 09:45:09','716',18613.00,18613.00,'716','2022-04-07 09:46:14','202','2022-04-07 10:00:08',10,0),('1','57',257261,'afternoon shift ','2022-04-06','2022-04-07 10:59:55','2022-04-08 10:59:55','716',840.00,840.00,'716','2022-04-07 11:01:33','202','2022-04-07 11:15:29',10,0),('1','57',257262,'morning shift','2022-04-07','2022-04-08 09:19:59','2022-04-09 09:19:59','716',0.00,0.00,'716','2022-04-08 09:22:43','202','2022-04-08 10:07:49',10,0),('1','57',257263,'afternoon shift ','2022-04-07','2022-04-08 10:14:29','2022-04-09 10:14:29','716',2184.00,2184.00,'716','2022-04-08 10:17:11','202','2022-04-08 11:34:56',10,0),('1','57',257264,'morning shift','2022-04-08','2022-04-09 12:23:31','2022-04-10 12:23:31','716',0.00,0.00,'716','2022-04-09 12:23:52','202','2022-04-09 12:25:55',10,0),('1','57',257265,'afternoon shift ','2022-04-09','2022-04-09 12:39:22','2022-04-10 12:39:22','716',86576.00,86576.00,'716','2022-04-09 12:41:57','202','2022-04-09 16:48:23',10,0),('1','57',257266,'morning shift','2022-04-09','2022-04-10 13:42:34','2022-04-11 13:42:34','716',0.00,0.00,'716','2022-04-10 13:42:57','202','2022-04-11 09:52:15',10,0),('1','57',257267,'afternoon shift ','2022-04-08','2022-04-11 09:58:20','2022-04-12 09:58:20','716',9401.00,9401.00,'716','2022-04-11 09:59:00','202','2022-04-11 10:16:49',10,0),('1','57',257268,'morning shift','2022-04-10','2022-04-11 10:17:46','2022-04-12 10:17:46','716',0.00,0.00,'716','2022-04-11 10:18:06','202','2022-04-11 10:21:24',10,0),('1','57',257269,'afternoon shift ','2022-04-10','2022-04-11 10:26:18','2022-04-12 10:26:18','716',590947.00,590947.00,'716','2022-04-11 10:27:05','202','2022-04-11 10:37:15',10,0),('1','57',257270,'morning shift','2022-04-11','2022-04-11 16:02:30','2022-04-12 16:02:30','716',234500.00,234500.00,'716','2022-04-11 16:03:15','202','2022-04-12 09:28:51',10,0),('1','57',257271,'afternoon shift ','2022-04-11','2022-04-12 10:15:15','2022-04-13 10:15:15','716',151998.00,151998.00,'716','2022-04-12 10:16:12','202','2022-04-12 10:55:57',10,0),('1','57',257272,'morning shift','2022-04-12','2022-04-12 13:33:22','2022-04-13 13:33:22','716',377300.00,377300.00,'716','2022-04-12 14:53:23','202','2022-04-13 09:09:03',10,0),('1','57',257273,'afternoon shift ','2022-04-12','2022-04-13 12:06:22','2022-04-14 12:06:22','716',382305.00,382305.00,'716','2022-04-13 12:08:15','202','2022-04-13 13:23:15',10,0),('1','57',257274,'morning shift','2022-04-13','2022-04-14 10:26:36','2022-04-15 10:26:36','716',0.00,0.00,'716','2022-04-14 10:27:04','202','2022-04-14 10:30:49',10,0),('1','57',257275,'afternoon shift ','2022-04-13','2022-04-14 10:44:49','2022-04-15 10:44:49','716',3948.00,3948.00,'716','2022-04-14 10:49:35','202','2022-04-14 11:43:56',10,0),('1','57',257276,'morning shift','2022-04-14','2022-04-14 16:21:22','2022-04-15 16:21:22','716',37737.00,37737.00,'716','2022-04-14 16:27:21','202','2022-04-14 18:03:27',10,0),('1','57',257277,'afternoon shift ','2022-04-14','2022-04-15 09:22:12','2022-04-16 09:22:12','716',0.00,0.00,'716','2022-04-15 09:22:37','202','2022-04-15 11:21:49',10,0),('1','57',257278,'morning shift','2022-04-15','2022-04-15 15:42:20','2022-04-16 15:42:20','716',3801.00,3801.00,'716','2022-04-15 15:43:09','202','2022-04-16 11:49:03',10,0),('1','57',257279,'afternoon shift ','2022-04-15','2022-04-16 12:05:01','2022-04-17 12:05:01','716',88403.00,88403.00,'716','2022-04-16 12:05:55','202','2022-04-16 13:55:15',10,0),('1','57',257280,'morning shift','2022-04-16','2022-04-17 07:40:56','2022-04-18 07:40:56','716',2898.00,2898.00,'716','2022-04-17 07:41:37','202','2022-04-17 17:44:05',10,0),('1','57',257281,'afternoon shift ','2022-04-16','2022-04-17 17:48:42','2022-04-18 17:48:42','716',708498.00,708498.00,'716','2022-04-17 20:22:43','202','2022-04-18 08:17:57',10,0),('1','57',257282,'morning shift','2022-04-17','2022-04-18 08:28:26','2022-04-19 08:28:26','716',688800.00,688800.00,'716','2022-04-18 08:29:20','202','2022-04-18 09:31:34',10,0),('1','57',257283,'afternoon shift ','2022-04-17','2022-04-18 11:31:14','2022-04-19 11:31:14','716',2800.00,2800.00,'716','2022-04-18 11:32:20','202','2022-04-18 14:53:28',10,0),('1','57',257284,'morning shift','2022-04-18','2022-04-19 04:33:46','2022-04-20 04:33:46','716',0.00,0.00,'716','2022-04-19 04:34:12','202','2022-04-19 21:09:55',10,0),('1','57',257285,'afternoon shift ','2022-04-18','2022-04-19 21:12:49','2022-04-20 21:12:49','716',43400.00,43400.00,'716','2022-04-19 21:13:42','202','2022-04-19 21:23:30',10,0),('1','57',257286,'morning shift','2022-04-19','2022-04-19 21:25:46','2022-04-20 21:25:46','716',140000.00,140000.00,'716','2022-04-19 21:26:33','202','2022-04-19 21:27:46',10,0),('1','57',257287,'afternoon shift ','2022-04-19','2022-04-20 08:05:21','2022-04-21 08:05:21','716',239260.00,239260.00,'716','2022-04-20 08:06:11','202','2022-04-20 11:21:48',10,0),('1','57',257288,'morning shift','2022-04-20','2022-04-20 13:41:05','2022-04-21 13:41:05','716',332500.00,332500.00,'716','2022-04-20 14:31:47','202','2022-04-21 04:50:49',10,0),('1','57',257289,'afternoon shift ','2022-04-20','2022-04-21 09:57:13','2022-04-22 09:57:13','716',199466.75,199466.75,'716','2022-04-21 09:58:07','202','2022-04-21 12:44:39',10,0),('1','57',257290,'morning shift','2022-04-21','2022-04-21 15:16:25','2022-04-22 15:16:25','716',493928.75,493928.75,'716','2022-04-21 15:17:10','202','2022-04-22 10:32:52',10,0),('1','57',257291,'afternoon shift ','2022-04-21','2022-04-22 10:35:43','2022-04-23 10:35:43','716',954667.35,954667.35,'716','2022-04-22 10:44:30','202','2022-04-22 15:42:31',10,0),('1','57',257292,'morning shift','2022-04-22','2022-04-22 16:11:54','2022-04-23 16:11:54','716',368443.25,368443.25,'716','2022-04-22 16:12:45','202','2022-04-23 08:21:31',10,0),('1','57',257293,'afternoon shift ','2022-04-22','2022-04-23 11:42:54','2022-04-24 11:42:54','716',320503.40,320503.40,'716','2022-04-23 11:44:08','202','2022-04-23 12:08:58',10,0),('1','57',257294,'morning shift','2022-04-23','2022-04-23 20:31:26','2022-04-24 20:31:26','716',0.00,0.00,'716','2022-04-23 20:31:51','202','2022-04-24 16:50:59',10,0),('1','57',257295,'afternoon shift ','2022-04-23','2022-04-24 17:50:01','2022-04-25 17:50:01','716',245398.30,245398.30,'716','2022-04-24 17:51:08','202','2022-04-24 21:22:11',10,0),('1','57',257296,'morning shift','2022-04-24','2022-04-24 22:04:05','2022-04-25 22:04:05','716',0.00,0.00,'716','2022-04-24 22:04:29','202','2022-04-25 11:26:07',10,0),('1','57',257297,'afternoon shift ','2022-04-24','2022-04-25 13:02:21','2022-04-26 13:02:21','716',568189.30,568189.30,'716','2022-04-25 13:03:33','202','2022-04-25 20:57:31',10,0),('1','57',257298,'morning shift','2022-04-25','2022-04-25 21:19:30','2022-04-26 21:19:30','716',581123.55,581123.55,'716','2022-04-25 21:24:49','202','2022-04-25 22:42:15',10,0),('1','57',257299,'afternoon shift ','2022-04-25','2022-04-26 09:55:24','2022-04-27 09:55:24','716',305574.15,305574.15,'716','2022-04-26 10:20:02','202','2022-04-26 10:34:01',10,0),('1','57',257300,'morning shift','2022-04-26','2022-04-26 10:42:33','2022-04-27 10:42:33','716',0.00,0.00,'716','2022-05-16 09:29:50','202','2022-09-02 17:55:05',10,0),('1','57',257301,'MORNING SHIFT','2022-09-02','2022-09-02 18:08:14','2022-09-03 18:08:14','716',134192.00,134192.00,'716','2022-09-02 18:12:04','202','2022-09-03 14:02:17',10,0),('1','57',257302,'AFTERNOON','2022-09-02','2022-09-03 16:16:24','2022-09-04 16:16:24','716',482984.00,482984.00,'716','2022-09-03 16:46:40','202','2022-09-03 20:21:34',10,0),('1','57',257303,'Morning','2022-09-03','2022-09-03 20:23:37','2022-09-04 20:23:37','716',0.00,0.00,'716','2022-09-03 20:25:23','202','2022-09-04 05:49:40',10,0),('1','57',257304,'AFTERNOON','2022-09-03','2022-09-04 11:41:46','2022-09-05 11:41:46','716',57597.95,57597.95,'716','2022-09-05 08:45:26','202','2022-09-05 09:43:17',10,0),('1','57',257305,'AFTERNOON','2022-09-04','2022-09-05 09:54:25','2022-09-06 09:54:25','716',127300.20,127300.20,'716','2022-09-05 10:00:29','202','2022-09-05 21:28:33',10,0),('1','57',257306,'Morning','2022-09-05','2022-09-05 22:27:17','2022-09-06 22:27:17','716',112156.60,112156.60,'716','2022-09-05 22:40:44','202','2022-09-06 12:42:21',10,0),('1','57',257307,'AFTERNOON','2022-09-05','2022-09-06 13:22:29','2022-09-07 13:22:29','716',609361.20,609361.20,'716','2022-09-06 14:09:43','202','2022-09-06 16:02:26',10,0),('1','57',257308,'Morning','2022-09-06','2022-09-06 16:34:02','2022-09-07 16:34:02','716',564177.10,564177.10,'716','2022-09-06 16:38:27','202','2022-09-07 15:51:36',10,0),('1','57',257309,'AFTERNOON','2022-09-06','2022-09-07 16:36:58','2022-09-08 16:36:58','716',93111.40,93111.40,'716','2022-09-07 17:35:12','202','2022-09-08 13:07:31',10,0),('1','57',257310,'Morning','2022-09-07','2022-09-08 13:45:41','2022-09-09 13:45:41','716',100891.70,100891.70,'716','2022-09-08 13:50:18','202','2022-09-08 14:23:01',10,0),('1','57',257311,'AFTERNOON','2022-09-07','2022-09-08 14:39:23','2022-09-09 14:39:23','716',620517.30,620517.30,'716','2022-09-08 14:45:09','202','2022-09-08 17:45:21',10,0),('1','57',257312,'Morning','2022-09-08','2022-09-08 19:23:19','2022-09-09 19:23:19','716',438508.40,438508.40,'716','2022-09-09 07:31:23','202','2022-09-09 17:31:23',10,0),('1','57',257313,'AFTERNOON','2022-09-08','2022-09-09 19:32:02','2022-09-10 19:32:02','716',566731.50,566731.50,'716','2022-09-10 07:14:03','202','2022-09-10 07:30:41',10,0),('1','57',257314,'Morning','2022-09-09','2022-09-10 08:01:38','2022-09-11 08:01:38','716',40223.10,40223.10,'716','2022-09-10 08:04:27','202','2022-09-10 15:05:41',10,0),('1','57',257315,'AFTERNOON','2022-09-09','2022-09-10 15:37:03','2022-09-11 15:37:03','716',595553.30,595553.30,'716','2022-09-10 22:12:13','202','2022-09-10 22:19:29',10,0),('1','57',257316,'Morning','2022-09-10','2022-09-11 06:52:22','2022-09-12 06:52:22','716',832749.90,832749.90,'716','2022-09-11 06:55:34','202','2022-09-11 12:30:40',10,0),('1','57',257317,'AFTERNOON','2022-09-10','2022-09-11 19:26:36','2022-09-12 19:26:36','716',133739.20,133739.20,'716','2022-09-11 19:28:07','202','2022-09-11 19:59:54',10,0),('1','57',257318,'Morning','2022-09-11','2022-09-11 20:57:02','2022-09-12 20:57:02','716',158297.10,158297.10,'716','2022-09-11 21:20:26','202','2022-09-12 08:13:44',10,0),('1','57',257319,'AFTERNOON','2022-09-11','2022-09-12 10:31:12','2022-09-13 10:31:12','716',725377.80,725377.80,'716','2022-09-12 10:34:12','202','2022-09-12 11:50:07',10,0),('1','57',257320,'Morning','2022-09-12','2022-09-12 12:31:35','2022-09-13 12:31:35','716',227011.50,227011.50,'716','2022-09-12 15:04:20','202','2022-09-13 11:56:19',10,0),('1','57',257321,'AFTERNOON','2022-09-12','2022-09-13 11:59:46','2022-09-14 11:59:46','716',472237.80,472237.80,'716','2022-09-13 12:06:38','202','2022-09-13 14:28:05',10,0),('1','57',257322,'Morning','2022-09-13','2022-09-13 16:38:53','2022-09-14 16:38:53','716',155801.40,155801.40,'716','2022-09-14 07:15:19','202','2022-09-14 11:23:58',10,0),('1','57',257323,'AFTERNOON','2022-09-13','2022-09-14 11:59:37','2022-09-15 11:59:37','716',444798.90,444798.90,'716','2022-09-14 12:05:43','202','2022-09-14 16:20:03',10,0),('1','57',257324,'Morning','2022-09-14','2022-09-14 21:38:17','2022-09-15 21:38:17','716',104278.90,104278.90,'716','2022-09-15 07:09:12','202','2022-09-15 11:54:11',10,0),('1','57',257325,'AFTERNOON','2022-09-14','2022-09-15 11:59:45','2022-09-16 11:59:45','716',290667.30,290667.30,'716','2022-09-15 12:04:13','202','2022-09-15 16:48:25',10,0),('1','57',257326,'Morning','2022-09-15','2022-09-15 20:48:14','2022-09-16 20:48:14','716',246912.90,246912.90,'716','2022-09-15 20:51:58','202','2022-09-16 12:53:37',10,0),('1','57',257327,'AFTERNOON','2022-09-15','2022-09-16 14:27:32','2022-09-17 14:27:32','716',88506.10,88506.10,'716','2022-09-16 14:40:22','202','2022-09-16 15:18:06',10,0),('1','57',257328,'Morning','2022-09-16','2022-09-16 16:44:25','2022-09-17 16:44:25','716',560524.80,560524.80,'716','2022-09-16 16:48:41','202','2022-09-17 12:05:32',10,0),('1','57',257329,'AFTERNOON','2022-09-16','2022-09-17 12:32:01','2022-09-18 12:32:01','716',507181.30,507181.30,'716','2022-09-17 12:36:59','202','2022-09-18 08:23:02',10,0),('1','57',257330,'Morning','2022-09-17','2022-09-18 08:34:25','2022-09-19 08:34:25','716',535177.10,535177.10,'716','2022-09-18 08:37:42','202','2022-09-18 09:35:31',10,0),('1','57',257331,'AFTERNOON','2022-09-17','2022-09-18 15:07:04','2022-09-19 15:07:04','716',569172.00,569172.00,'716','2022-09-18 15:13:04','202','2022-09-19 08:05:29',10,0),('1','57',257332,'Morning','2022-09-18','2022-09-19 11:29:50','2022-09-20 11:29:50','716',337056.90,337056.90,'716','2022-09-19 11:37:04','202','2022-09-19 12:02:56',10,0),('1','57',257333,'AFTERNOON','2022-09-18','2022-09-19 12:05:47','2022-09-20 12:05:47','716',61758.30,61758.30,'716','2022-09-19 12:11:34','202','2022-09-19 12:13:26',10,0),('1','57',257334,'Morning','2022-09-19','2022-09-19 15:02:21','2022-09-20 15:02:21','716',541686.50,541686.50,'716','2022-09-19 15:07:43','202','2022-09-20 00:06:14',10,0),('1','57',257335,'AFTERNOON','2022-09-19','2022-09-20 05:56:04','2022-09-21 05:56:04','716',112303.50,112303.50,'716','2022-09-20 06:51:49','202','2022-09-20 09:48:27',10,0),('1','57',257336,'Morning','2022-09-20','2022-09-20 10:12:53','2022-09-21 10:12:53','716',244123.40,244123.40,'716','2022-09-20 15:42:12','202','2022-09-21 10:19:52',10,0),('1','57',257337,'AFTERNOON','2022-09-20','2022-09-21 10:32:03','2022-09-22 10:32:03','716',120662.60,120662.60,'716','2022-09-21 10:38:58','202','2022-09-21 11:12:05',10,0),('1','57',257338,'Morning','2022-09-21','2022-09-21 16:45:08','2022-09-22 16:45:08','716',274606.20,274606.20,'716','2022-09-21 16:48:22','202','2022-09-22 11:29:43',10,0),('1','57',257339,'AFTERNOON','2022-09-21','2022-09-22 11:41:39','2022-09-23 11:41:39','716',506668.80,506668.80,'716','2022-09-22 11:45:59','202','2022-09-22 12:00:19',10,0),('1','57',257340,'Morning','2022-09-22','2022-09-22 18:08:08','2022-09-23 18:08:08','716',452836.70,452836.70,'716','2022-09-23 08:23:23','202','2022-09-23 11:07:41',10,0),('1','57',257341,'AFTERNOON','2022-09-22','2022-09-23 11:32:36','2022-09-24 11:32:36','716',419247.60,419247.60,'716','2022-09-23 11:34:57','202','2022-09-23 11:45:14',10,0),('1','57',257342,'Morning','2022-09-23','2022-09-23 15:54:26','2022-09-24 15:54:26','716',309502.70,309502.70,'716','2022-09-23 20:46:17','202','2022-09-24 21:45:49',10,0),('1','57',257343,'AFTERNOON','2022-09-23','2022-09-25 09:58:24','2022-09-26 09:58:24','716',390816.80,390816.80,'716','2022-09-25 10:00:50','202','2022-09-25 10:20:59',10,0),('1','57',257344,'AFTERNOON','2022-09-14','2022-09-25 12:18:59','2022-09-26 12:18:59','716',0.00,0.00,'716','2022-09-25 12:48:30','202','2022-09-25 12:50:05',10,0),('1','57',257345,'AFTERNOON','2022-09-24','2022-09-25 13:32:07','2022-09-26 13:32:07','716',0.00,0.00,'716','2022-09-25 13:59:28','202','2022-09-25 14:00:54',10,0),('1','57',257346,'Morning','2022-09-24','2022-09-25 14:02:13','2022-09-26 14:02:13','716',469721.80,469721.80,'716','2022-09-25 14:04:50','202','2022-09-25 14:06:23',10,0),('1','57',257347,'AFTERNOON','2022-09-24','2022-09-25 14:07:53','2022-09-26 14:07:53','716',59010.20,59010.20,'716','2022-09-25 14:09:33','202','2022-09-25 14:11:12',10,0),('1','57',257348,'Morning','2022-09-25','2022-09-25 18:12:58','2022-09-26 18:12:58','716',288549.20,288549.20,'716','2022-09-25 18:15:43','202','2022-09-26 11:44:37',10,0),('1','57',257349,'AFTERNOON','2022-09-25','2022-09-26 11:49:22','2022-09-27 11:49:22','716',182548.20,182548.20,'716','2022-09-26 11:56:02','202','2022-09-26 11:56:43',10,0),('1','57',257350,'Morning','2022-09-26','2022-09-26 16:50:15','2022-09-27 16:50:15','716',78912.70,78912.70,'716','2022-09-26 16:55:12','202','2022-09-27 10:34:44',10,0),('1','57',257351,'AFTERNOON','2022-09-26','2022-09-27 11:25:12','2022-09-28 11:25:12','716',167372.90,167372.90,'716','2022-09-27 11:26:54','202','2022-09-27 11:29:14',10,0),('1','57',257352,'Morning','2022-09-27','2022-09-27 17:56:38','2022-09-28 17:56:38','716',159292.20,159292.20,'716','2022-09-27 17:57:46','202','2022-09-28 11:19:09',10,0),('1','57',257353,'AFTERNOON','2022-09-27','2022-09-28 12:31:14','2022-09-29 12:31:14','716',94331.20,94331.20,'716','2022-09-28 12:47:07','202','2022-09-28 13:19:10',10,0),('1','57',257354,'Morning','2022-09-28','2022-09-28 15:29:01','2022-09-29 15:29:01','716',230312.30,230312.30,'716','2022-09-28 15:34:07','202','2022-09-28 15:38:14',10,0),('1','57',257355,'AFTERNOON','2022-09-28','2022-09-29 09:45:31','2022-09-30 09:45:31','716',151067.10,151067.10,'716','2022-09-29 09:49:51','202','2022-09-29 12:21:46',10,0),('1','57',257356,'Morning','2022-09-29','2022-09-29 15:18:38','2022-09-30 15:18:38','716',132576.30,132576.30,'716','2022-09-30 06:52:17','202','2022-09-30 07:40:32',10,0),('1','57',257357,'AFTERNOON','2022-09-29','2022-09-30 08:09:22','2022-10-01 08:09:22','716',94074.70,94074.70,'716','2022-09-30 10:15:48','202','2022-09-30 12:12:47',10,0),('1','57',257358,'Morning','2022-09-30','2022-09-30 15:01:15','2022-10-01 15:01:15','716',108911.80,108911.80,'716','2022-09-30 15:02:25','202','2022-09-30 16:18:58',10,0),('1','57',257359,'AFTERNOON','2022-10-01','2022-10-01 11:35:16','2022-10-02 11:35:16','716',207081.00,207081.00,'716','2022-10-01 12:05:36','202','2022-10-02 15:23:58',10,0),('1','57',257360,'AFTERNOON','2022-10-01','2022-10-02 15:29:52','2022-10-03 15:29:52','716',76752.40,76752.40,'716','2022-10-02 19:26:38','202','2022-10-02 19:54:00',10,0),('1','57',257361,'Morning','2022-10-01','2022-10-02 20:49:07','2022-10-03 20:49:07','716',180950.30,180950.30,'716','2022-10-02 20:50:11','202','2022-10-03 15:37:28',10,0),('1','57',257362,'Morning','2022-10-02','2022-10-03 15:40:18','2022-10-04 15:40:18','716',88674.90,88674.90,'716','2022-10-03 15:41:43','202','2022-10-03 17:52:58',10,0),('1','57',257363,'AFTERNOON','2022-10-02','2022-10-03 17:58:06','2022-10-04 17:58:06','716',149412.20,149412.20,'716','2022-10-03 17:59:16','202','2022-10-03 18:00:22',10,0),('1','57',257364,'Morning','2022-10-03','2022-10-03 18:08:49','2022-10-04 18:08:49','716',98929.20,98929.20,'716','2022-10-03 18:18:28','202','2022-10-03 18:20:03',10,0),('1','57',257365,'AFTERNOON','2022-10-03','2022-10-04 11:11:54','2022-10-05 11:11:54','716',198683.00,198683.00,'716','2022-10-04 11:14:56','202','2022-10-04 14:16:24',10,0),('1','57',257366,'Morning','2022-10-04','2022-10-04 15:16:35','2022-10-05 15:16:35','716',144956.70,144956.70,'716','2022-10-05 10:47:10','202','2022-10-05 11:27:16',10,0),('1','57',257367,'AFTERNOON','2022-10-04','2022-10-05 11:55:23','2022-10-06 11:55:23','716',186243.70,186243.70,'716','2022-10-05 12:25:28','202','2022-10-05 12:28:02',10,0),('1','57',257368,'Morning','2022-10-05','2022-10-05 14:47:26','2022-10-06 14:47:26','716',157922.30,157922.30,'716','2022-10-05 15:32:15','202','2022-10-06 11:42:34',10,0),('1','57',257369,'AFTERNOON','2022-10-05','2022-10-06 12:28:59','2022-10-07 12:28:59','716',174627.10,174627.10,'716','2022-10-06 12:30:20','202','2022-10-07 09:38:36',10,0),('1','57',257370,'Morning','2022-10-06','2022-10-07 10:08:35','2022-10-08 10:08:35','716',86558.30,86558.30,'716','2022-10-07 10:11:37','202','2022-10-07 10:28:39',10,0),('1','57',257371,'AFTERNOON','2022-10-06','2022-10-07 10:35:12','2022-10-08 10:35:12','716',160388.50,160388.50,'716','2022-10-07 10:36:55','202','2022-10-07 11:43:54',10,0),('1','57',257372,'Morning','2022-10-07','2022-10-07 12:27:31','2022-10-08 12:27:31','716',79239.50,79239.50,'716','2022-10-07 20:07:02','202','2022-10-07 20:19:03',10,0),('1','57',257373,'AFTERNOON','2022-10-07','2022-10-08 09:18:33','2022-10-09 09:18:33','716',344572.60,344572.60,'716','2022-10-08 09:19:34','202','2022-10-08 09:46:45',10,0),('1','57',257374,'Morning','2022-10-08','2022-10-09 21:04:11','2022-10-10 21:04:11','716',81764.60,81764.60,'716','2022-10-09 21:05:53','202','2022-10-09 21:54:25',10,0),('1','57',257375,'AFTERNOON','2022-10-08','2022-10-10 09:33:27','2022-10-11 09:33:27','716',37901.20,37901.20,'716','2022-10-10 09:45:35','202','2022-10-11 11:55:51',10,0),('1','57',257376,'Morning','2022-10-09','2022-10-11 12:18:49','2022-10-12 12:18:49','716',0.00,0.00,'716','2022-10-11 12:19:11','202','2022-11-16 08:26:04',10,0),('1','57',257377,'AFTERNOON','2022-11-15','2022-11-16 09:28:54','2022-11-17 09:28:54','716',824483.80,824483.80,'716','2022-11-16 09:36:22','202','2022-11-16 15:57:54',10,0),('1','57',257378,'Morning','2022-11-16','2022-11-16 16:01:27','2022-11-17 16:01:27','716',1455486.20,1455486.20,'716','2022-11-16 16:02:45','202','2022-11-17 01:07:32',10,0),('1','57',257379,'AFTERNOON','2022-11-16','2022-11-17 07:26:39','2022-11-18 07:26:39','716',175767.90,175767.90,'716','2022-11-17 10:34:12','202','2022-11-17 15:05:11',10,0),('1','57',257380,'Morning','2022-11-17','2022-11-17 15:17:40','2022-11-18 15:17:40','716',410561.20,410561.20,'716','2022-11-17 15:18:51','202','2022-11-17 15:23:39',10,0),('1','57',257381,'AFTERNOON','2022-11-17','2022-11-18 10:44:07','2022-11-19 10:44:07','716',766504.55,766504.55,'716','2022-11-18 10:46:11','202','2022-11-18 11:25:02',10,0),('1','57',257382,'Morning','2022-11-18','2022-11-18 21:23:25','2022-11-19 21:23:25','716',105898.80,105898.80,'716','2022-11-18 21:26:20','202','2022-11-21 00:10:52',10,0),('1','57',257383,'AFTERNOON','2022-11-18','2022-11-21 06:26:43','2022-11-22 06:26:43','716',0.00,0.00,'716','2023-01-06 10:14:00','202','2023-01-06 10:15:21',10,0),('1','57',257384,'AFTERNOON','2023-01-04','2023-01-06 10:17:58','2023-01-07 10:17:58','716',855663.80,855663.80,'716','2023-01-06 10:19:04','202','2023-01-06 10:28:21',10,0),('1','57',257385,'Morning','2023-01-05','2023-01-06 10:34:55','2023-01-07 10:34:55','716',623000.00,623000.00,'716','2023-01-06 10:35:49','202','2023-01-06 17:34:13',10,0),('1','57',257386,'Morning','2023-01-06','2023-01-07 07:23:47','2023-01-08 07:23:47','716',692250.90,692250.90,'716','2023-01-07 07:26:03','202','2023-01-08 09:40:56',10,0),('1','57',257387,'AFTERNOON','2023-01-06','2023-01-08 18:01:46','2023-01-09 18:01:46','716',122419.50,122419.50,'716','2023-01-08 18:03:02','202','2023-01-08 19:01:41',10,0),('1','57',257388,'Morning','2023-01-07','2023-01-08 19:45:25','2023-01-09 19:45:25','716',71200.00,71200.00,'716','2023-01-08 20:19:24','202','2023-01-09 03:49:20',10,0),('1','57',257389,'AFTERNOON','2023-01-07','2023-01-09 09:42:24','2023-01-10 09:42:24','716',11596.70,11596.70,'716','2023-01-09 09:43:30','202','2023-01-09 11:45:58',10,0),('1','57',257390,'Morning','2023-01-08','2023-01-09 12:42:09','2023-01-10 12:42:09','716',720650.80,720650.80,'716','2023-01-09 12:43:03','202','2023-01-10 10:50:51',10,0),('1','57',257391,'Morning','2023-01-08','2023-01-10 20:07:17','2023-01-11 20:07:17','716',66750.00,66750.00,'716','2023-01-10 20:39:04','202','2023-01-10 20:42:51',10,0),('1','57',257392,'Morning','2023-01-09','2023-01-10 20:46:10','2023-01-11 20:46:10','716',437604.10,437604.10,'716','2023-01-10 20:48:03','202','2023-01-10 20:51:36',10,0),('1','57',257393,'AFTERNOON','2023-01-09','2023-01-10 20:53:09','2023-01-11 20:53:09','716',160200.00,160200.00,'716','2023-01-10 20:54:33','202','2023-01-10 21:01:42',10,0),('1','57',257394,'Morning','2023-01-10','2023-01-10 21:08:09','2023-01-11 21:08:09','716',759116.60,759116.60,'716','2023-01-10 21:09:12','202','2023-01-10 21:13:01',10,0),('1','57',257395,'AFTERNOON','2023-01-10','2023-01-11 10:17:35','2023-01-12 10:17:35','716',464802.50,464802.50,'716','2023-01-11 11:09:08','202','2023-01-11 11:24:03',10,0),('1','57',257396,'Morning','2023-01-11','2023-01-11 21:57:12','2023-01-12 21:57:12','716',279566.80,279566.80,'716','2023-01-11 21:58:11','974','2023-01-12 07:30:50',10,0),('1','57',257397,'AFTERNOON','2023-01-11','2023-01-12 12:51:23','2023-01-13 12:51:23','716',58401.80,58401.80,'716','2023-01-12 12:52:10','202','2023-01-12 19:56:03',10,0),('1','57',257398,'Morning','2023-01-12','2023-01-13 09:09:00','2023-01-14 09:09:00','716',182636.90,182636.90,'716','2023-01-13 09:09:56','202','2023-01-13 17:17:14',10,0),('1','57',257399,'AFTERNOON','2023-01-12','2023-01-13 17:26:36','2023-01-14 17:26:36','716',86614.80,86614.80,'716','2023-01-13 17:28:32','202','2023-01-14 10:31:29',10,0),('1','57',257400,'Morning','2023-01-13','2023-01-14 10:45:03','2023-01-15 10:45:03','716',884927.00,884927.00,'716','2023-01-14 10:46:10','202','2023-01-14 10:48:29',10,0),('1','57',257401,'AFTERNOON','2023-01-13','2023-01-14 10:51:57','2023-01-15 10:51:57','716',2002.50,2002.50,'716','2023-01-14 10:52:55','974','2023-01-15 07:48:07',10,0),('1','57',257402,'Morning','2023-01-14','2023-01-15 12:50:32','2023-01-16 12:50:32','716',178996.80,178996.80,'716','2023-01-15 12:51:36','202','2023-01-15 13:26:08',10,0),('1','57',257403,'AFTERNOON','2023-01-14','2023-01-16 13:36:22','2023-01-17 13:36:22','716',44500.00,44500.00,'716','2023-01-16 13:37:49','202','2023-01-16 13:54:22',10,0),('1','57',257404,'Morning','2023-01-15','2023-01-16 14:00:58','2023-01-17 14:00:58','716',277199.40,277199.40,'716','2023-01-16 14:02:15','202','2023-01-16 14:08:21',10,0),('1','57',257405,'AFTERNOON','2023-01-15','2023-01-16 14:48:43','2023-01-17 14:48:43','716',1456271.40,1456271.40,'716','2023-01-16 14:50:20','202','2023-01-17 09:45:40',10,0),('1','57',257406,'Morning','2023-01-16','2023-01-17 11:47:01','2023-01-18 11:47:01','716',326505.40,326505.40,'716','2023-01-17 11:47:47','974','2023-01-17 12:59:46',10,0),('1','57',257407,'AFTERNOON','2023-01-16','2023-01-17 13:08:28','2023-01-18 13:08:28','716',179424.00,179424.00,'716','2023-01-17 13:09:30','202','2023-01-18 09:20:43',10,0),('1','57',257408,'Morning','2023-01-17','2023-01-18 15:33:01','2023-01-19 15:33:01','716',165682.40,165682.40,'716','2023-01-18 15:34:24','202','2023-01-19 08:43:24',10,0),('1','57',257409,'AFTERNOON','2023-01-17','2023-01-19 10:06:40','2023-01-20 10:06:40','716',259710.90,259710.90,'716','2023-01-19 10:07:47','202','2023-01-19 11:23:13',10,0),('1','57',257410,'Morning','2023-01-18','2023-01-19 12:29:41','2023-01-20 12:29:41','716',1195136.50,1195136.50,'716','2023-01-19 12:31:18','974','2023-01-19 14:45:30',10,0),('1','57',257411,'AFTERNOON','2023-01-18','2023-01-19 22:04:01','2023-01-20 22:04:01','716',50649.90,50649.90,'716','2023-01-19 22:20:09','974','2023-01-20 08:52:30',10,0),('1','57',257412,'Morning','2023-01-19','2023-01-20 12:47:10','2023-01-21 12:47:10','716',168103.20,168103.20,'716','2023-01-20 12:47:51','974','2023-01-20 12:51:06',10,0),('1','57',257413,'AFTERNOON','2023-01-19','2023-01-20 12:52:46','2023-01-21 12:52:46','716',493852.10,493852.10,'716','2023-01-20 12:53:41','974','2023-01-20 13:00:04',10,0),('1','57',257414,'Morning','2023-01-20','2023-01-20 15:24:04','2023-01-21 15:24:04','716',270364.20,270364.20,'716','2023-01-20 15:25:02','974','2023-01-21 17:46:54',10,0),('1','57',257415,'AFTERNOON','2023-01-20','2023-01-21 18:22:50','2023-01-22 18:22:50','716',282156.70,282156.70,'716','2023-01-21 18:23:47','974','2023-01-22 09:55:48',10,0),('1','57',257416,'Morning','2023-01-21','2023-01-22 13:08:40','2023-01-23 13:08:40','716',1134216.00,1134216.00,'716','2023-01-22 13:09:50','974','2023-01-22 18:33:41',10,0),('1','57',257417,'AFTERNOON','2023-01-21','2023-01-23 10:28:21','2023-01-24 10:28:21','716',104681.80,104681.80,'716','2023-01-23 10:29:15','974','2023-01-23 10:51:47',10,0),('1','57',257418,'Morning','2023-01-22','2023-01-23 11:20:33','2023-01-24 11:20:33','716',669458.00,669458.00,'716','2023-01-23 11:21:18','974','2023-01-24 14:16:07',10,0),('1','57',257419,'AFTERNOON','2023-01-23','2023-01-24 15:51:27','2023-01-25 15:51:27','716',789198.60,789198.60,'716','2023-01-24 15:52:04','974','2023-01-24 19:08:43',10,0),('1','57',257420,'Morning','2023-01-23','2023-01-25 08:20:59','2023-01-26 08:20:59','716',304210.90,304210.90,'716','2023-01-25 08:22:03','974','2023-01-25 09:54:01',10,0),('1','57',257421,'AFTERNOON','2023-01-23','2023-01-25 13:41:56','2023-01-26 13:41:56','716',478481.80,478481.80,'716','2023-01-25 13:42:57','974','2023-01-25 13:55:11',10,0),('1','57',257422,'Morning','2023-01-24','2023-01-25 13:59:30','2023-01-26 13:59:30','716',511367.30,511367.30,'716','2023-01-25 14:00:59','974','2023-01-25 20:33:01',10,0),('1','57',257423,'AFTERNOON','2023-01-24','2023-01-27 09:05:20','2023-01-28 09:05:20','716',357201.50,357201.50,'716','2023-01-27 09:07:05','974','2023-01-27 10:48:24',10,0),('1','57',257424,'Morning','2023-01-25','2023-01-27 11:29:25','2023-01-28 11:29:25','716',286615.60,286615.60,'716','2023-01-27 11:31:03','974','2023-01-27 12:01:11',10,0),('1','57',257425,'AFTERNOON','2023-01-25','2023-01-27 12:10:31','2023-01-28 12:10:31','716',312603.60,312603.60,'716','2023-01-27 23:02:08','974','2023-01-27 23:39:31',10,0),('1','57',257426,'Morning','2023-01-26','2023-01-29 15:20:36','2023-01-30 15:20:36','716',321895.20,321895.20,'716','2023-01-29 15:21:44','974','2023-01-29 15:22:53',10,0),('1','57',257427,'AFTERNOON','2023-01-26','2023-01-29 17:35:10','2023-01-30 17:35:10','716',47214.50,47214.50,'716','2023-01-29 17:35:55','974','2023-01-29 22:54:23',10,0),('1','57',257428,'Morning','2023-01-27','2023-01-30 07:52:36','2023-01-31 07:52:36','716',235654.20,235654.20,'716','2023-01-30 07:53:35','974','2023-01-30 09:14:59',10,0),('1','57',257429,'AFTERNOON','2023-01-27','2023-01-30 09:25:32','2023-01-31 09:25:32','716',487328.40,487328.40,'716','2023-01-30 09:26:40','974','2023-01-30 09:27:29',10,0),('1','57',257430,'AFTERNOON','2023-01-28','2023-01-30 09:36:18','2023-01-31 09:36:18','716',22250.00,22250.00,'716','2023-01-30 09:38:48','974','2023-01-30 09:42:05',10,0),('1','57',257431,'Morning','2023-01-28','2023-01-30 10:11:36','2023-01-31 10:11:36','716',1397.30,1397.30,'716','2023-01-30 10:13:25','974','2023-01-30 10:15:43',10,0),('1','57',257432,'Morning','2023-01-29','2023-01-30 10:17:03','2023-01-31 10:17:03','716',29183.10,29183.10,'716','2023-01-30 10:19:45','974','2023-01-30 10:21:28',10,0),('1','57',257433,'AFTERNOON','2023-01-29','2023-01-30 10:24:12','2023-01-31 10:24:12','716',77483.40,77483.40,'716','2023-01-30 18:51:08','974','2023-01-30 18:53:25',10,0),('1','57',257434,'Morning','2023-01-30','2023-01-31 09:26:39','2023-02-01 09:26:39','716',287613.30,287613.30,'716','2023-01-31 09:58:37','974','2023-01-31 17:16:11',10,0),('1','57',257435,'AFTERNOON','2023-01-30','2023-01-31 20:19:24','2023-02-01 20:19:24','716',933031.50,933031.50,'716','2023-01-31 20:20:22','974','2023-01-31 20:24:05',10,0),('1','57',257436,'Morning','2023-01-31','2023-01-31 20:26:30','2023-02-01 20:26:30','716',787750.20,787750.20,'716','2023-01-31 20:27:47','974','2023-01-31 20:40:24',10,0),('1','57',257437,'AFTERNOON','2023-01-31','2023-01-31 20:45:10','2023-02-01 20:45:10','716',0.00,0.00,'716','2023-02-01 11:44:29','974','2023-02-01 22:48:27',10,0),('1','57',257438,'AFTERNOON','2023-02-02','2023-02-02 20:32:14','2023-02-03 20:32:14','716',23411.70,23411.70,'716','2023-02-02 20:34:32','974','2023-02-04 21:48:38',10,0),('1','57',257439,'Morning','2023-02-02','2023-02-04 21:56:16','2023-02-05 21:56:16','716',101972.70,101972.70,'716','2023-02-04 21:57:12','974','2023-02-04 22:10:39',10,0),('1','57',257440,'Morning','2023-02-03','2023-02-04 22:19:58','2023-02-05 22:19:58','716',319359.60,319359.60,'716','2023-02-04 22:21:08','974','2023-02-04 22:42:19',10,0),('1','57',257441,'AFTERNOON','2023-02-03','2023-02-05 16:49:44','2023-02-06 16:49:44','716',0.00,0.00,'716','2023-02-05 16:50:29','974','2023-02-05 16:56:42',10,0),('1','57',257442,'Morning','2023-02-04','2023-02-05 18:20:59','2023-02-06 18:20:59','716',51504.00,51504.00,'716','2023-02-05 18:21:51','974','2023-02-05 20:11:54',10,0),('1','57',257443,'AFTERNOON','2023-02-04','2023-02-05 21:15:52','2023-02-06 21:15:52','716',605145.90,605145.90,'716','2023-02-05 21:17:46','974','2023-02-06 22:30:13',10,0),('1','57',257444,'Morning','2023-02-05','2023-02-08 08:49:38','2023-02-09 08:49:38','716',828996.90,828996.90,'716','2023-02-08 08:50:37','974','2023-02-08 08:54:57',10,0),('1','57',257445,'AFTERNOON','2023-02-05','2023-02-08 08:56:46','2023-02-09 08:56:46','716',1670930.70,1670930.70,'716','2023-02-08 08:57:52','974','2023-02-08 09:05:49',10,0),('1','57',257446,'Morning','2023-02-06','2023-02-08 09:08:50','2023-02-09 09:08:50','716',70600.50,70600.50,'716','2023-02-08 09:09:36','974','2023-02-08 09:11:30',10,0),('1','57',257447,'AFTERNOON','2023-02-06','2023-02-08 09:13:23','2023-02-09 09:13:23','716',356700.00,356700.00,'716','2023-02-08 09:14:19','974','2023-02-08 09:21:32',10,0),('1','57',257448,'Morning','2023-02-07','2023-02-08 09:26:59','2023-02-09 09:26:59','716',64197.30,64197.30,'716','2023-02-08 09:27:49','974','2023-02-08 09:28:50',10,0),('1','57',257449,'AFTERNOON','2023-02-07','2023-02-08 09:31:13','2023-02-09 09:31:13','716',0.00,0.00,'716','2023-02-08 09:33:34','974','2023-02-08 09:38:26',10,0),('1','57',257450,'Morning','2023-02-08','2023-02-08 18:52:36','2023-02-09 18:52:36','716',135502.50,135502.50,'716','2023-02-09 10:03:13','974','2023-02-09 15:39:59',10,0),('1','57',257451,'AFTERNOON','2023-02-08','2023-02-10 10:42:16','2023-02-11 10:42:16','716',88583.40,88583.40,'716','2023-02-10 10:42:54','974','2023-02-10 13:59:51',10,0),('1','57',257452,'Morning','2023-02-09','2023-02-10 19:43:44','2023-02-11 19:43:44','716',40246.20,40246.20,'716','2023-02-10 19:44:42','974','2023-02-10 19:46:52',10,0),('1','57',257453,'AFTERNOON','2023-02-09','2023-02-10 19:48:50','2023-02-11 19:48:50','716',6246.60,6246.60,'716','2023-02-10 19:49:41','974','2023-02-10 19:50:34',10,0),('1','57',257454,'Morning','2023-02-10','2023-02-10 19:52:23','2023-02-11 19:52:23','716',665410.80,665410.80,'716','2023-02-10 19:53:12','974','2023-02-10 19:56:43',10,0),('1','57',257455,'AFTERNOON','2023-02-10','2023-02-11 08:51:39','2023-02-12 08:51:39','716',34608.60,34608.60,'716','2023-02-11 08:52:21','974','2023-02-12 19:04:14',10,0),('1','57',257456,'Morning','2023-02-11','2023-02-12 19:31:52','2023-02-13 19:31:52','716',1246040.10,1246040.10,'716','2023-02-12 19:33:46','974','2023-02-12 19:38:11',10,0),('1','57',257457,'AFTERNOON','2023-02-11','2023-02-13 11:46:27','2023-02-14 11:46:27','716',36592.20,36592.20,'716','2023-02-13 11:47:17','974','2023-02-13 21:06:54',10,0),('1','57',257458,'Morning','2023-02-12','2023-02-14 08:46:05','2023-02-15 08:46:05','716',904399.80,904399.80,'716','2023-02-14 08:47:15','974','2023-02-14 11:44:17',10,0),('1','57',257459,'AFTERNOON','2023-02-12','2023-02-14 14:27:57','2023-02-15 14:27:57','716',14407.20,14407.20,'716','2023-02-14 14:28:37','974','2023-02-14 20:34:05',10,0),('1','57',257460,'Morning','2023-02-13','2023-02-14 21:34:12','2023-02-15 21:34:12','716',178471.80,178471.80,'716','2023-02-14 21:35:05','974','2023-02-15 10:37:12',10,0),('1','57',257461,'AFTERNOON','2023-02-13','2023-02-15 10:43:04','2023-02-16 10:43:04','716',90854.10,90854.10,'716','2023-02-15 10:44:09','974','2023-02-15 21:54:30',10,0),('1','57',257462,'Morning','2023-02-14','2023-02-15 22:19:40','2023-02-16 22:19:40','716',23707.50,23707.50,'716','2023-02-15 22:20:39','974','2023-02-15 22:24:10',10,0),('1','57',257463,'AFTERNOON','2023-02-14','2023-02-15 22:26:40','2023-02-16 22:26:40','716',0.00,0.00,'716','2023-02-15 22:27:12','974','2023-02-15 22:28:52',10,0),('1','57',257464,'Morning','2023-02-15','2023-02-15 22:33:18','2023-02-16 22:33:18','716',50503.50,50503.50,'716','2023-02-15 22:34:09','974','2023-02-15 22:35:12',10,0),('1','57',257465,'AFTERNOON','2023-02-15','2023-02-15 22:37:59','2023-02-16 22:37:59','716',96700.50,96700.50,'716','2023-02-15 22:38:38','974','2023-02-15 22:41:20',10,0),('1','57',257466,'Morning','2023-02-16','2023-02-17 11:37:11','2023-02-18 11:37:11','716',0.00,0.00,'716','2023-02-17 11:38:41','974','2023-02-17 11:40:37',10,0),('1','57',257467,'AFTERNOON','2023-02-16','2023-02-17 17:44:49','2023-02-18 17:44:49','716',461848.20,461848.20,'716','2023-02-17 17:45:41','974','2023-02-17 18:48:14',10,0),('1','57',257468,'Morning','2023-02-17','2023-02-17 22:23:51','2023-02-18 22:23:51','716',129838.80,129838.80,'716','2023-02-17 22:24:49','974','2023-02-17 22:26:01',10,0),('1','57',257469,'AFTERNOON','2023-02-17','2023-02-18 21:28:02','2023-02-19 21:28:02','716',20610.30,20610.30,'716','2023-02-18 21:29:05','974','2023-02-18 21:31:28',10,0),('1','57',257470,'Morning','2023-02-18','2023-02-18 21:32:45','2023-02-19 21:32:45','716',157165.50,157165.50,'716','2023-02-18 21:33:28','974','2023-02-18 21:35:00',10,0),('1','57',257471,'Morning','2023-02-18','2023-02-20 11:28:17','2023-02-21 11:28:17','716',0.00,0.00,'716','2023-02-20 11:37:05','974','2023-02-21 10:55:29',10,0),('1','57',257472,'AFTERNOON','2023-02-18','2023-02-21 11:58:21','2023-02-22 11:58:21','716',10944.60,10944.60,'716','2023-02-21 11:59:16','974','2023-02-21 12:00:24',10,0),('1','57',257473,'Morning','2023-02-19','2023-02-21 12:01:43','2023-02-22 12:01:43','716',248350.20,248350.20,'716','2023-02-21 12:02:33','974','2023-02-21 12:07:52',10,0),('1','57',257474,'AFTERNOON','2023-02-19','2023-02-21 12:08:57','2023-02-22 12:08:57','716',62909.70,62909.70,'716','2023-02-21 12:10:00','974','2023-02-21 15:01:03',10,0),('1','57',257475,'Morning','2023-02-20','2023-02-21 15:04:24','2023-02-22 15:04:24','716',260634.60,260634.60,'716','2023-02-21 15:05:33','974','2023-02-21 15:06:48',10,0),('1','57',257476,'AFTERNOON','2023-02-20','2023-02-21 15:11:42','2023-02-22 15:11:42','716',258050.70,258050.70,'716','2023-02-21 15:13:21','974','2023-02-21 16:11:04',10,0),('1','57',257477,'Morning','2023-02-21','2023-02-21 22:57:41','2023-02-22 22:57:41','716',90737.50,90737.50,'716','2023-02-21 23:01:40','974','2023-02-22 19:14:05',10,0),('1','57',257478,'AFTERNOON','2023-02-21','2023-02-22 22:25:28','2023-02-23 22:25:28','716',495499.00,495499.00,'716','2023-02-22 22:26:30','974','2023-02-23 12:10:44',10,0),('1','57',257479,'Morning','2023-02-22','2023-02-23 20:32:13','2023-02-24 20:32:13','716',182274.00,182274.00,'716','2023-02-23 20:33:26','974','2023-02-23 20:54:54',10,0),('1','57',257480,'AFTERNOON','2023-02-22','2023-02-23 21:06:26','2023-02-24 21:06:26','716',289697.00,289697.00,'716','2023-02-23 21:07:19','974','2023-02-23 21:14:00',10,0),('1','57',257481,'Morning','2023-02-23','2023-02-23 21:26:33','2023-02-24 21:26:33','716',14541.60,14541.60,'716','2023-02-23 21:27:19','974','2023-02-23 21:29:04',10,0),('1','57',257482,'AFTERNOON','2023-02-23','2023-02-23 22:16:54','2023-02-24 22:16:54','716',606688.50,606688.50,'716','2023-02-23 22:17:34','974','2023-02-23 22:19:49',10,0),('1','57',257483,'Morning','2023-02-24','2023-02-25 19:19:51','2023-02-26 19:19:51','716',49069.60,49069.60,'716','2023-02-25 19:20:52','974','2023-02-25 19:22:16',10,0),('1','57',257484,'AFTERNOON','2023-02-24','2023-02-26 22:07:00','2023-02-27 22:07:00','716',109966.70,109966.70,'716','2023-02-26 22:08:04','974','2023-02-26 22:26:50',10,0),('1','57',257485,'Morning','2023-02-25','2023-02-27 16:55:44','2023-02-28 16:55:44','716',0.00,0.00,'716','2023-02-27 16:56:24','974','2023-02-27 17:16:25',10,0),('1','57',257486,'Morning','2023-02-26','2023-02-28 11:44:31','2023-03-01 11:44:31','716',524186.50,524186.50,'716','2023-02-28 11:46:25','974','2023-02-28 13:07:08',10,0),('1','57',257487,'AFTERNOON','2023-02-26','2023-02-28 13:50:59','2023-03-01 13:50:59','716',114540.00,114540.00,'716','2023-02-28 13:51:57','974','2023-02-28 14:16:31',10,0),('1','57',257488,'Morning','2023-02-27','2023-02-28 15:31:07','2023-03-01 15:31:07','716',269708.50,269708.50,'716','2023-02-28 15:32:04','974','2023-03-01 14:29:27',10,0),('1','57',257489,'AFTERNOON','2023-02-27','2023-03-01 19:10:44','2023-03-02 19:10:44','716',352086.00,352086.00,'716','2023-03-01 19:11:34','974','2023-03-01 19:29:34',10,0),('1','57',257490,'Morning','2023-02-28','2023-03-01 19:45:22','2023-03-02 19:45:22','716',876438.50,876438.50,'716','2023-03-01 19:46:59','974','2023-03-01 20:12:21',10,0),('1','57',257491,'AFTERNOON','2023-02-28','2023-03-02 10:45:25','2023-03-03 10:45:25','716',189439.20,189439.20,'716','2023-03-02 10:46:23','974','2023-03-03 11:59:12',10,0),('1','57',257492,'Morning','2023-03-01','2023-03-08 10:46:14','2023-03-09 10:46:14','716',120333.40,120333.40,'716','2023-03-08 10:47:15','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4899706 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','57','445','240528',4612621,'1190','173',766125.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','240528',4612622,'1191','173',48137.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','240528',4612623,'1192','173',98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','240528',4612624,'1193','173',732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','240528',4612625,'1198','174',182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','240528',4612626,'1239','174',589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','240535',4612704,'1190','173',766125.75,766396.74,270.99,44713.35,0.00,0.00,0.00,0.00,0.00),('1','57','445','240535',4612705,'1191','173',48137.35,48312.33,174.98,28871.70,0.00,0.00,0.00,0.00,0.00),('1','57','446','240535',4612706,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','240535',4612707,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','240535',4612708,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','240535',4612709,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','240575',4613386,'1190','173',766396.74,766802.69,405.95,66981.75,0.00,0.00,0.00,0.00,0.00),('1','57','445','240575',4613387,'1191','173',48312.33,48959.19,646.86,106731.90,0.00,0.00,0.00,0.00,0.00),('1','57','446','240575',4613388,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','240575',4613389,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','240575',4613390,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','240575',4613391,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','240579',4613435,'1190','173',766802.69,768298.01,1495.32,246727.80,0.00,0.00,0.00,0.00,0.00),('1','57','445','240579',4613436,'1191','173',48959.19,51718.24,2759.05,455243.25,0.00,0.00,0.00,0.00,0.00),('1','57','446','240579',4613437,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','240579',4613438,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','240579',4613439,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','240579',4613440,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','240582',4613516,'1190','173',768298.01,769152.83,854.82,141045.30,0.00,0.00,0.00,0.00,0.00),('1','57','445','240582',4613517,'1191','173',51718.24,52195.72,477.48,78784.20,0.00,0.00,0.00,0.00,0.00),('1','57','446','240582',4613518,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','240582',4613519,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','240582',4613520,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','240582',4613521,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','240584',4613550,'1190','173',769152.83,770262.91,1110.08,183163.20,0.00,0.00,0.00,0.00,0.00),('1','57','445','240584',4613551,'1191','173',52195.72,53039.25,843.53,139182.45,0.00,0.00,0.00,0.00,0.00),('1','57','446','240584',4613552,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','240584',4613553,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','240584',4613554,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','240584',4613555,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','240585',4613556,'1190','173',770262.91,771119.13,856.22,141276.30,0.00,0.00,0.00,0.00,0.00),('1','57','445','240585',4613557,'1191','173',53039.25,53654.87,615.62,101577.30,0.00,0.00,0.00,0.00,0.00),('1','57','446','240585',4613558,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','240585',4613559,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','240585',4613560,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','240585',4613561,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','240586',4613562,'1190','173',771119.13,772491.57,1372.44,226452.60,0.00,0.00,0.00,0.00,0.00),('1','57','445','240586',4613563,'1191','173',53654.87,55857.42,2202.55,363420.75,0.00,0.00,0.00,0.00,0.00),('1','57','446','240586',4613564,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','240586',4613565,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','240586',4613566,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','240586',4613567,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','240592',4613657,'1190','173',772491.57,773673.56,1181.99,195028.35,0.00,0.00,0.00,0.00,0.00),('1','57','445','240592',4613658,'1191','173',55857.42,56887.48,1030.06,169959.90,0.00,0.00,0.00,0.00,0.00),('1','57','446','240592',4613659,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','240592',4613660,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','240592',4613661,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','240592',4613662,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','240812',4616965,'1190','173',773673.56,774793.35,1119.79,184765.35,0.00,0.00,0.00,0.00,0.00),('1','57','445','240812',4616966,'1191','173',56887.48,58069.69,1182.21,195064.65,0.00,0.00,0.00,0.00,0.00),('1','57','446','240812',4616967,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','240812',4616968,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','240812',4616969,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','240812',4616970,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','240876',4618255,'1190','173',774793.35,776061.80,1268.45,209294.25,0.00,0.00,0.00,0.00,0.00),('1','57','445','240876',4618256,'1191','173',58069.69,59035.80,966.11,159408.15,0.00,0.00,0.00,0.00,0.00),('1','57','446','240876',4618257,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','240876',4618258,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','240876',4618259,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','240876',4618260,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','241137',4622944,'1190','173',776061.80,777350.88,1289.08,212698.20,0.00,0.00,0.00,0.00,0.00),('1','57','445','241137',4622945,'1191','173',59035.80,60152.96,1117.16,184331.40,0.00,0.00,0.00,0.00,0.00),('1','57','446','241137',4622946,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','241137',4622947,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','241137',4622948,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','241137',4622949,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','241326',4626177,'1190','173',777350.88,778217.05,866.17,142918.05,0.00,0.00,0.00,0.00,0.00),('1','57','445','241326',4626178,'1191','173',60152.96,61157.32,1004.36,165719.40,0.00,0.00,0.00,0.00,0.00),('1','57','446','241326',4626179,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','241326',4626180,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','241326',4626181,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','241326',4626182,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','241419',4627900,'1190','173',778217.05,779337.06,1120.01,184801.65,0.00,0.00,0.00,0.00,0.00),('1','57','445','241419',4627901,'1191','173',61157.32,62032.07,874.75,144333.75,0.00,0.00,0.00,0.00,0.00),('1','57','446','241419',4627902,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','241419',4627903,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','241419',4627904,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','241419',4627905,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','241422',4627946,'1190','173',779337.06,780581.81,1244.75,205383.75,0.00,0.00,0.00,0.00,0.00),('1','57','445','241422',4627947,'1191','173',62032.07,62893.69,861.62,142167.30,0.00,0.00,0.00,0.00,0.00),('1','57','446','241422',4627948,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','241422',4627949,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','241422',4627950,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','241422',4627951,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','241662',4631983,'1190','173',780581.81,781046.87,465.06,76734.90,0.00,0.00,0.00,0.00,0.00),('1','57','445','241662',4631984,'1191','173',62893.69,63285.11,391.42,64584.30,0.00,0.00,0.00,0.00,0.00),('1','57','446','241662',4631985,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','241662',4631986,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','241662',4631987,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','241662',4631988,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','242540',4647464,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','242540',4647465,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','242540',4647466,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','242540',4647467,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','242540',4647468,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','242540',4647469,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','244179',4675784,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','244179',4675785,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','244179',4675786,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','244179',4675787,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','244179',4675788,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','244179',4675789,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','244249',4677212,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','244249',4677213,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','244249',4677214,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','244249',4677215,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','244249',4677216,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','244249',4677217,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','244392',4679606,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','244392',4679607,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','244392',4679608,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','244392',4679609,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','244392',4679610,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','244392',4679611,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','244676',4684554,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','244676',4684555,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','244676',4684556,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','244676',4684557,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','244676',4684558,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','244676',4684559,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','244691',4684829,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','244691',4684830,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','244691',4684831,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','244691',4684832,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','244691',4684833,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','244691',4684834,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','244940',4689232,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','244940',4689233,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','244940',4689234,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','244940',4689235,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','244940',4689236,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','244940',4689237,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245833',4704577,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245833',4704578,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245833',4704579,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245833',4704580,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245833',4704581,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245833',4704582,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245835',4704603,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245835',4704604,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245835',4704605,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245835',4704606,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245835',4704607,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245835',4704608,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245836',4704609,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245836',4704610,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245836',4704611,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245836',4704612,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245836',4704613,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245836',4704614,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245839',4704655,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245839',4704656,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245839',4704657,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245839',4704658,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245839',4704659,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245839',4704660,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245841',4704687,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245841',4704688,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245841',4704689,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245841',4704690,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245841',4704691,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245841',4704692,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245842',4704693,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245842',4704694,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245842',4704695,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245842',4704696,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245842',4704697,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245842',4704698,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245843',4704699,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245843',4704700,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245843',4704701,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245843',4704702,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245843',4704703,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245843',4704704,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245845',4704722,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245845',4704723,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245845',4704724,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245845',4704725,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245845',4704726,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245845',4704727,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245846',4704728,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245846',4704729,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245846',4704730,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245846',4704731,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245846',4704732,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245846',4704733,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245848',4704741,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245848',4704742,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245848',4704743,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245848',4704744,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245848',4704745,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245848',4704746,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245850',4704767,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245850',4704768,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245850',4704769,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245850',4704770,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245850',4704771,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245850',4704772,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245851',4704773,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245851',4704774,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245851',4704775,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245851',4704776,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245851',4704777,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245851',4704778,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245852',4704779,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245852',4704780,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245852',4704781,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245852',4704782,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245852',4704783,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245852',4704784,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245853',4704785,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245853',4704786,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245853',4704787,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245853',4704788,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245853',4704789,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245853',4704790,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245854',4704791,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245854',4704792,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245854',4704793,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245854',4704794,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245854',4704795,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245854',4704796,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245855',4704797,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245855',4704798,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245855',4704799,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245855',4704800,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245855',4704801,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245855',4704802,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245856',4704803,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245856',4704804,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245856',4704805,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245856',4704806,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245856',4704807,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245856',4704808,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245857',4704809,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245857',4704810,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245857',4704811,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245857',4704812,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245857',4704813,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245857',4704814,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245859',4704819,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245859',4704820,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245859',4704821,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245859',4704822,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245859',4704823,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245859',4704824,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245860',4704825,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245860',4704826,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245860',4704827,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245860',4704828,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245860',4704829,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245860',4704830,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245861',4704831,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245861',4704832,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245861',4704833,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245861',4704834,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245861',4704835,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245861',4704836,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245862',4704837,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245862',4704838,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245862',4704839,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245862',4704840,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245862',4704841,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245862',4704842,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245864',4704871,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245864',4704872,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245864',4704873,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245864',4704874,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245864',4704875,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245864',4704876,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245865',4704877,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245865',4704878,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245865',4704879,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245865',4704880,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245865',4704881,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245865',4704882,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245867',4704899,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245867',4704900,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245867',4704901,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245867',4704902,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245867',4704903,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245867',4704904,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245868',4704905,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245868',4704906,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245868',4704907,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245868',4704908,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245868',4704909,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245868',4704910,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245869',4704911,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245869',4704912,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245869',4704913,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245869',4704914,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245869',4704915,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245869',4704916,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245870',4704917,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245870',4704918,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245870',4704919,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245870',4704920,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245870',4704921,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245870',4704922,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245871',4704923,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245871',4704924,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245871',4704925,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245871',4704926,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245871',4704927,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245871',4704928,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245872',4704929,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','245872',4704930,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245872',4704931,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','245872',4704932,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','245872',4704933,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','245872',4704934,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','247028',4724486,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','247028',4724487,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','247028',4724488,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','247028',4724489,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','247028',4724490,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','247028',4724491,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','247030',4724526,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','247030',4724527,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','247030',4724528,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','247030',4724529,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','247030',4724530,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','247030',4724531,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','247031',4724532,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','247031',4724533,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','247031',4724534,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','247031',4724535,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','247031',4724536,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','247031',4724537,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','247032',4724538,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','247032',4724539,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','247032',4724540,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','247032',4724541,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','247032',4724542,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','247032',4724543,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','247034',4724546,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','247034',4724547,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','247034',4724548,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','247034',4724549,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','247034',4724550,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','247034',4724551,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','247035',4724552,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','247035',4724553,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','247035',4724554,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','247035',4724555,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','247035',4724556,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','247035',4724557,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','247036',4724558,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','247036',4724559,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','247036',4724560,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','247036',4724561,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','247036',4724562,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','247036',4724563,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','247038',4724618,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','247038',4724619,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','247038',4724620,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','247038',4724621,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','247038',4724622,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','247038',4724623,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','247039',4724624,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','247039',4724625,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','247039',4724626,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','247039',4724627,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','247039',4724628,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','247039',4724629,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','247040',4724630,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','247040',4724631,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','247040',4724632,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','247040',4724633,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','247040',4724634,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','247040',4724635,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248554',4750709,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248554',4750710,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248554',4750711,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248554',4750712,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','248554',4750713,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','248554',4750714,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248555',4750715,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248555',4750716,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248555',4750717,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248555',4750718,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','248555',4750719,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','248555',4750720,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248556',4750721,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248556',4750722,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248556',4750723,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248556',4750724,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','248556',4750725,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','248556',4750726,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248557',4750727,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248557',4750728,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248557',4750729,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248557',4750730,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','248557',4750731,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','248557',4750732,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248559',4750734,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248559',4750735,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248559',4750736,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248559',4750737,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','248559',4750738,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','248559',4750739,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248560',4750740,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248560',4750741,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248560',4750742,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248560',4750743,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','248560',4750744,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','248560',4750745,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248562',4750761,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248562',4750762,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248562',4750763,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248562',4750764,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','248562',4750765,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','248562',4750766,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248566',4750791,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248566',4750792,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248566',4750793,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248566',4750794,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','248566',4750795,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','248566',4750796,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248567',4750797,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248567',4750798,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248567',4750799,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248567',4750800,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','248567',4750801,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','248567',4750802,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248568',4750803,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248568',4750804,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248568',4750805,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248568',4750806,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','248568',4750807,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','248568',4750808,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248569',4750809,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248569',4750810,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248569',4750811,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248569',4750812,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','248569',4750813,'1198','174',182398.60,182398.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','248569',4750814,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248603',4751461,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','248603',4751462,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248603',4751463,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','248603',4751464,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','248603',4751465,'1198','174',182398.60,185908.57,3509.97,1228489.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','248603',4751466,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','249475',4766207,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','249475',4766208,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','249475',4766209,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','249475',4766210,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','249475',4766211,'1198','174',185908.57,186508.47,599.90,209965.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','249475',4766212,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','249671',4769351,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','249671',4769352,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','249671',4769353,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','249671',4769354,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','249671',4769355,'1198','174',186508.47,188287.65,1779.18,622713.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','249671',4769356,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','249679',4769463,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','249679',4769464,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','249679',4769465,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','249679',4769466,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','249679',4769467,'1198','174',188287.65,188380.65,93.00,32550.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','249679',4769468,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','249683',4769512,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','249683',4769513,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','249683',4769514,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','249683',4769515,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','249683',4769516,'1198','174',188380.65,192437.79,4057.14,1419999.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','249683',4769517,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','249685',4769526,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','249685',4769527,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','249685',4769528,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','249685',4769529,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','249685',4769530,'1198','174',192437.79,193915.24,1477.45,517107.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','249685',4769531,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','249691',4769626,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','249691',4769627,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','249691',4769628,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','249691',4769629,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','249691',4769630,'1198','174',193915.24,197153.16,3237.92,1133272.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','249691',4769631,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','249694',4769658,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','249694',4769659,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','249694',4769660,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','249694',4769661,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','249694',4769662,'1198','174',197153.16,197243.02,89.86,31451.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','249694',4769663,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','249695',4769664,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','249695',4769665,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','249695',4769666,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','249695',4769667,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','249695',4769668,'1198','174',197243.02,199592.41,2349.39,822286.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','249695',4769669,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','249697',4769676,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','249697',4769677,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','249697',4769678,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','249697',4769679,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','249697',4769680,'1198','174',199592.41,199592.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','249697',4769681,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','249996',4775025,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','249996',4775026,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','249996',4775027,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','249996',4775028,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','249996',4775029,'1198','174',199592.41,199592.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','249996',4775030,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','249999',4775077,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','249999',4775078,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','249999',4775079,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','249999',4775080,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','249999',4775081,'1198','174',199592.41,199592.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','249999',4775082,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','250001',4775106,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','250001',4775107,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','250001',4775108,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','250001',4775109,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','250001',4775110,'1198','174',199592.41,201246.41,1654.00,578900.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','250001',4775111,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','250248',4779130,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','250248',4779131,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','250248',4779132,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','250248',4779133,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','250248',4779134,'1198','174',201246.41,202146.03,899.62,314867.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','250248',4779135,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','250461',4782537,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','250461',4782538,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','250461',4782539,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','250461',4782540,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','250461',4782541,'1198','174',202146.03,202755.03,609.00,213150.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','250461',4782542,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','250471',4782743,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','250471',4782744,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','250471',4782745,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','250471',4782746,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','250471',4782747,'1198','174',202755.03,202770.14,15.11,5288.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','250471',4782748,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251114',4793994,'1190','173',781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251114',4793995,'1191','173',63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251114',4793996,'1192','173',98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251114',4793997,'1193','173',732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','251114',4793998,'1198','174',202770.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','251114',4793999,'1239','174',589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251124',4794164,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251124',4794165,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251124',4794166,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251124',4794167,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','251124',4794168,'1198','174',202770.14,203727.03,956.89,334911.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','251124',4794169,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251139',4794473,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251139',4794474,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251139',4794475,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251139',4794476,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','251139',4794477,'1198','174',203727.03,204712.46,985.43,344900.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','251139',4794478,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251157',4794813,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251157',4794814,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251157',4794815,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251157',4794816,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','251157',4794817,'1198','174',204712.46,205642.06,929.60,325360.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','251157',4794818,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251172',4795116,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251172',4795117,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251172',4795118,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251172',4795119,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','251172',4795120,'1198','174',205642.06,207051.21,1409.15,493202.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','251172',4795121,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251173',4795122,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251173',4795123,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251173',4795124,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251173',4795125,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','251173',4795126,'1198','174',207051.21,208087.91,1036.70,362845.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','251173',4795127,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251177',4795230,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251177',4795231,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251177',4795232,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251177',4795233,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','251177',4795234,'1198','174',208087.91,209141.26,1053.35,368672.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','251177',4795235,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251179',4795258,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251179',4795259,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251179',4795260,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251179',4795261,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','251179',4795262,'1198','174',209141.26,209882.65,741.39,259486.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','251179',4795263,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251348',4798079,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251348',4798080,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251348',4798081,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251348',4798082,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','251348',4798083,'1198','174',209882.65,210523.52,640.87,224304.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','251348',4798084,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251480',4800490,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251480',4800491,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251480',4800492,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251480',4800493,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','251480',4800494,'1198','174',210523.52,211023.52,500.00,175000.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','251480',4800495,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251852',4806773,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251852',4806774,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251852',4806775,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251852',4806776,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','251852',4806777,'1198','174',211023.52,211505.22,481.70,168595.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','251852',4806778,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251862',4806954,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251862',4806955,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251862',4806956,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251862',4806957,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','251862',4806958,'1198','174',211505.22,212602.50,1097.28,384048.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','251862',4806959,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251962',4808877,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','251962',4808878,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251962',4808879,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','251962',4808880,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','251962',4808881,'1198','174',212602.50,212790.12,187.62,65667.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','251962',4808882,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','252568',4819544,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','252568',4819545,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','252568',4819546,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','252568',4819547,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','252568',4819548,'1198','174',212790.12,213999.85,1209.73,423405.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','252568',4819549,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','252572',4819578,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','252572',4819579,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','252572',4819580,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','252572',4819581,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','252572',4819582,'1198','174',213999.85,215196.35,1196.50,418775.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','252572',4819583,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','252576',4819632,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','252576',4819633,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','252576',4819634,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','252576',4819635,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','252576',4819636,'1198','174',215196.35,215546.28,349.93,122475.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','252576',4819637,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','252581',4819715,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','252581',4819716,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','252581',4819717,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','252581',4819718,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','252581',4819719,'1198','174',215546.28,217552.56,2006.28,702198.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','252581',4819720,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','252584',4819743,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','252584',4819744,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','252584',4819745,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','252584',4819746,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','252584',4819747,'1198','174',217552.56,219561.96,2009.40,703290.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','252584',4819748,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','252805',4823421,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','252805',4823422,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','252805',4823423,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','252805',4823424,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','252805',4823425,'1198','174',219561.96,221082.33,1520.37,532129.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','252805',4823426,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','252807',4823429,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','252807',4823430,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','252807',4823431,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','252807',4823432,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','252807',4823433,'1198','174',221082.33,221688.19,605.86,212051.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','252807',4823434,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','252897',4824965,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','252897',4824966,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','252897',4824967,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','252897',4824968,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','252897',4824969,'1198','174',221688.19,221908.13,219.94,76979.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','252897',4824970,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','252932',4825646,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','252932',4825647,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','252932',4825648,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','252932',4825649,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','252932',4825650,'1198','174',221908.13,223498.44,1590.31,556608.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','252932',4825651,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','253188',4830055,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','253188',4830056,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','253188',4830057,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','253188',4830058,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','253188',4830059,'1198','174',223498.44,224330.98,832.54,291389.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','253188',4830060,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','253287',4831500,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','253287',4831501,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','253287',4831502,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','253287',4831503,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','253287',4831504,'1198','174',224330.98,225906.58,1575.60,551460.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','253287',4831505,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','253299',4831672,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','253299',4831673,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','253299',4831674,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','253299',4831675,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','253299',4831676,'1198','174',225906.58,226906.58,1000.00,350000.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','253299',4831677,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','253408',4833601,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','253408',4833602,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','253408',4833603,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','253408',4833604,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','253408',4833605,'1198','174',226906.58,227860.58,954.00,333900.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','253408',4833606,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','253613',4837148,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','253613',4837149,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','253613',4837150,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','253613',4837151,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','253613',4837152,'1198','174',227860.58,228455.60,595.02,208257.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','253613',4837153,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','253635',4837517,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','253635',4837518,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','253635',4837519,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','253635',4837520,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','253635',4837521,'1198','174',228455.60,229003.60,548.00,191800.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','253635',4837522,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','253813',4840563,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','253813',4840564,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','253813',4840565,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','253813',4840566,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','253813',4840567,'1198','174',229003.60,229573.60,570.00,199500.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','253813',4840568,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','253921',4842679,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','253921',4842680,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','253921',4842681,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','253921',4842682,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','253921',4842683,'1198','174',229573.60,230198.51,624.91,218718.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','253921',4842684,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','254107',4845835,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','254107',4845836,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','254107',4845837,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','254107',4845838,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','254107',4845839,'1198','174',230198.51,230198.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','254107',4845840,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','254261',4848356,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','254261',4848357,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','254261',4848358,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','254261',4848359,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','254261',4848360,'1198','174',230198.51,230198.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','254261',4848361,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','254309',4849364,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','254309',4849365,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','254309',4849366,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','254309',4849367,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','254309',4849368,'1198','174',230198.51,230198.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','254309',4849369,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','254367',4850374,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','254367',4850375,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','254367',4850376,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','254367',4850377,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','254367',4850378,'1198','174',230198.51,230198.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','254367',4850379,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','254550',4853422,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','254550',4853423,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','254550',4853424,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','254550',4853425,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','254550',4853426,'1198','174',230198.51,230198.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','254550',4853427,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','254660',4855534,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','254660',4855535,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','254660',4855536,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','254660',4855537,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','254660',4855538,'1198','174',230198.51,232401.42,2202.91,771018.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','254660',4855539,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','254866',4858927,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','254866',4858928,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','254866',4858929,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','254866',4858930,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','254866',4858931,'1198','174',232401.42,232865.07,463.65,162277.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','254866',4858932,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','254912',4859869,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','254912',4859870,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','254912',4859871,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','254912',4859872,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','254912',4859873,'1198','174',232865.07,233317.07,452.00,158200.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','254912',4859874,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','255105',4863077,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','255105',4863078,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','255105',4863079,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','255105',4863080,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','255105',4863081,'1198','174',233317.07,235008.33,1691.26,591941.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','255105',4863082,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','255117',4863286,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','255117',4863287,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','255117',4863288,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','255117',4863289,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','255117',4863290,'1198','174',235008.33,238189.08,3180.75,1113262.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','255117',4863291,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','255308',4866681,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','255308',4866682,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','255308',4866683,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','255308',4866684,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','255308',4866685,'1198','174',238189.08,238804.72,615.64,218552.20,0.00,0.00,0.00,0.00,0.00),('1','57','468','255308',4866686,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','255536',4870068,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','255536',4870069,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','255536',4870070,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','255536',4870071,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','255536',4870072,'1198','174',238804.72,239792.54,987.82,350676.10,0.00,0.00,0.00,0.00,0.00),('1','57','468','255536',4870073,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','255626',4871760,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','255626',4871761,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','255626',4871762,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','255626',4871763,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','255626',4871764,'1198','174',239792.54,240848.93,1056.39,375018.45,0.00,0.00,0.00,0.00,0.00),('1','57','468','255626',4871765,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','255681',4872897,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','255681',4872898,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','255681',4872899,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','255681',4872900,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','255681',4872901,'1198','174',240848.93,242111.33,1262.40,448152.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','255681',4872902,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','255864',4875733,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','255864',4875734,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','255864',4875735,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','255864',4875736,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','255864',4875737,'1198','174',242111.33,242128.99,17.66,6269.30,0.00,0.00,0.00,0.00,0.00),('1','57','468','255864',4875738,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','255914',4876652,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','255914',4876653,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','255914',4876654,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','255914',4876655,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','255914',4876656,'1198','174',242128.99,247686.21,5557.22,1972813.10,0.00,0.00,0.00,0.00,0.00),('1','57','468','255914',4876657,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','256112',4879906,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','256112',4879907,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','256112',4879908,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','256112',4879909,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','256112',4879910,'1198','174',247686.21,248814.91,1128.70,400688.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','256112',4879911,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','256122',4880055,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','256122',4880056,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','256122',4880057,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','256122',4880058,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','256122',4880059,'1198','174',248814.91,249539.35,724.44,257176.20,0.00,0.00,0.00,0.00,0.00),('1','57','468','256122',4880060,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','256400',4884649,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','256400',4884650,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','256400',4884651,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','256400',4884652,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','256400',4884653,'1198','174',249539.35,250540.48,1001.13,360406.80,0.00,0.00,0.00,0.00,0.00),('1','57','468','256400',4884654,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','256613',4888180,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','256613',4888181,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','256613',4888182,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','256613',4888183,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','256613',4888184,'1198','174',250540.48,250540.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','256613',4888185,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','256652',4888894,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','256652',4888895,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','256652',4888896,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','256652',4888897,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','256652',4888898,'1198','174',250540.48,250540.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','256652',4888899,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','256847',4892119,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','256847',4892120,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','256847',4892121,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','256847',4892122,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','256847',4892123,'1198','174',250540.48,250540.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','256847',4892124,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257145',4897618,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257145',4897619,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257145',4897620,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257145',4897621,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257145',4897622,'1198','174',250540.48,250540.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257145',4897623,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257146',4897624,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257146',4897625,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257146',4897626,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257146',4897627,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257146',4897628,'1198','174',250540.48,250540.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257146',4897629,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257147',4897630,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257147',4897631,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257147',4897632,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257147',4897633,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257147',4897634,'1198','174',250540.48,250540.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257147',4897635,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257148',4897636,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257148',4897637,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257148',4897638,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257148',4897639,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257148',4897640,'1198','174',250540.48,250540.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257148',4897641,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257149',4897642,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257149',4897643,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257149',4897644,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257149',4897645,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257149',4897646,'1198','174',250540.48,250540.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257149',4897647,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257150',4897648,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257150',4897649,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257150',4897650,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257150',4897651,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257150',4897652,'1198','174',250540.48,250540.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257150',4897653,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257151',4897654,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257151',4897655,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257151',4897656,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257151',4897657,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257151',4897658,'1198','174',250540.48,250540.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257151',4897659,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257152',4897660,'1190','173',781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257152',4897661,'1191','173',63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257152',4897662,'1192','173',98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257152',4897663,'1193','173',732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257152',4897664,'1198','174',250540.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257152',4897665,'1239','174',589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257153',4897666,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257153',4897667,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257153',4897668,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257153',4897669,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257153',4897670,'1198','174',250540.48,250540.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257153',4897671,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257154',4897672,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257154',4897673,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257154',4897674,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257154',4897675,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257154',4897676,'1198','174',250540.48,250540.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257154',4897677,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257155',4897678,'1190','173',781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257155',4897679,'1191','173',63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257155',4897680,'1192','173',98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257155',4897681,'1193','173',732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257155',4897682,'1198','174',250540.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257155',4897683,'1239','174',589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257156',4897684,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257156',4897685,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257156',4897686,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257156',4897687,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257156',4897688,'1198','174',250540.48,250540.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257156',4897689,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257157',4897690,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257157',4897691,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257157',4897692,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257157',4897693,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257157',4897694,'1198','174',250540.48,250540.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257157',4897695,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257158',4897696,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257158',4897697,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257158',4897698,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257158',4897699,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257158',4897700,'1198','174',250540.48,250540.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257158',4897701,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257159',4897702,'1190','173',781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257159',4897703,'1191','173',63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257159',4897704,'1192','173',98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257159',4897705,'1193','173',732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257159',4897706,'1198','174',250540.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257159',4897707,'1239','174',589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257160',4897708,'1190','173',781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257160',4897709,'1191','173',63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257160',4897710,'1192','173',98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257160',4897711,'1193','173',732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257160',4897712,'1198','174',250540.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257160',4897713,'1239','174',589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257161',4897714,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257161',4897715,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257161',4897716,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257161',4897717,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257161',4897718,'1198','174',250540.48,252373.28,1832.80,668972.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257161',4897719,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257162',4897720,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257162',4897721,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257162',4897722,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257162',4897723,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257162',4897724,'1198','174',252373.28,255468.29,3095.01,1098728.55,0.00,0.00,0.00,0.00,0.00),('1','57','468','257162',4897725,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257163',4897726,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257163',4897727,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257163',4897728,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257163',4897729,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257163',4897730,'1198','174',255468.29,256805.65,1337.36,508196.80,0.00,0.00,0.00,0.00,0.00),('1','57','468','257163',4897731,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257164',4897732,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257164',4897733,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257164',4897734,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257164',4897735,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257164',4897736,'1198','174',256805.65,258632.33,1826.68,694138.40,0.00,0.00,0.00,0.00,0.00),('1','57','468','257164',4897737,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257165',4897738,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257165',4897739,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257165',4897740,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257165',4897741,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257165',4897742,'1198','174',258632.33,259759.18,1126.85,428203.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257165',4897743,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257166',4897744,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257166',4897745,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257166',4897746,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257166',4897747,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257166',4897748,'1198','174',259759.18,260377.87,618.69,235102.20,0.00,0.00,0.00,0.00,0.00),('1','57','468','257166',4897749,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257167',4897750,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257167',4897751,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257167',4897752,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257167',4897753,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257167',4897754,'1198','174',260377.87,262215.24,1837.37,698200.60,0.00,0.00,0.00,0.00,0.00),('1','57','468','257167',4897755,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257168',4897756,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257168',4897757,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257168',4897758,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257168',4897759,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257168',4897760,'1198','174',262215.24,263645.32,1430.08,543430.40,0.00,0.00,0.00,0.00,0.00),('1','57','468','257168',4897761,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257169',4897762,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257169',4897763,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257169',4897764,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257169',4897765,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257169',4897766,'1198','174',263645.32,265479.17,1833.85,696863.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257169',4897767,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257170',4897768,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257170',4897769,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257170',4897770,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257170',4897771,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257170',4897772,'1198','174',265479.17,266455.35,976.18,370948.40,0.00,0.00,0.00,0.00,0.00),('1','57','468','257170',4897773,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257171',4897774,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257171',4897775,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257171',4897776,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257171',4897777,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257171',4897778,'1198','174',266455.35,270807.77,4352.42,1653919.60,0.00,0.00,0.00,0.00,0.00),('1','57','468','257171',4897779,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257172',4897780,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257172',4897781,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257172',4897782,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257172',4897783,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257172',4897784,'1198','174',270807.77,270807.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257172',4897785,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257173',4897786,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257173',4897787,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257173',4897788,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257173',4897789,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257173',4897790,'1198','174',270807.77,270807.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257173',4897791,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257174',4897792,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257174',4897793,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257174',4897794,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257174',4897795,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257174',4897796,'1198','174',270807.77,270807.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257174',4897797,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257175',4897798,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257175',4897799,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257175',4897800,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257175',4897801,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257175',4897802,'1198','174',270807.77,274032.54,3224.77,1257660.30,0.00,0.00,0.00,0.00,0.00),('1','57','468','257175',4897803,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257176',4897804,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257176',4897805,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257176',4897806,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257176',4897807,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257176',4897808,'1198','174',274032.54,274965.10,932.56,363698.40,0.00,0.00,0.00,0.00,0.00),('1','57','468','257176',4897809,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257177',4897810,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257177',4897811,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257177',4897812,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257177',4897813,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257177',4897814,'1198','174',274965.10,276535.09,1569.99,612296.10,0.00,0.00,0.00,0.00,0.00),('1','57','468','257177',4897815,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257178',4897816,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257178',4897817,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257178',4897818,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257178',4897819,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257178',4897820,'1198','174',276535.09,277165.93,630.84,246027.60,0.00,0.00,0.00,0.00,0.00),('1','57','468','257178',4897821,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257179',4897822,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257179',4897823,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257179',4897824,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257179',4897825,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257179',4897826,'1198','174',277165.93,278468.14,1302.21,520884.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257179',4897827,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257180',4897828,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257180',4897829,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257180',4897830,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257180',4897831,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257180',4897832,'1198','174',278468.14,278743.14,275.00,110000.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257180',4897833,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257181',4897834,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257181',4897835,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257181',4897836,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257181',4897837,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257181',4897838,'1198','174',278743.14,281991.01,3247.87,1299148.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257181',4897839,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257182',4897840,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257182',4897841,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257182',4897842,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257182',4897843,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257182',4897844,'1198','174',281991.01,283195.25,1204.24,481696.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257182',4897845,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257183',4897846,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257183',4897847,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257183',4897848,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257183',4897849,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257183',4897850,'1198','174',283195.25,284191.01,995.76,398304.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257183',4897851,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257184',4897852,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257184',4897853,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257184',4897854,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257184',4897855,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257184',4897856,'1198','174',284191.01,284624.24,433.23,173292.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257184',4897857,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257185',4897858,'1190','173',781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257185',4897859,'1191','173',63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257185',4897860,'1192','173',98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257185',4897861,'1193','173',732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257185',4897862,'1198','174',284624.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257185',4897863,'1239','174',589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257186',4897864,'1190','173',781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257186',4897865,'1191','173',63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257186',4897866,'1192','173',98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257186',4897867,'1193','173',732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257186',4897868,'1198','174',284624.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257186',4897869,'1239','174',589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257187',4897870,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257187',4897871,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257187',4897872,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257187',4897873,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257187',4897874,'1198','174',284624.24,285991.36,1367.12,560519.20,0.00,0.00,0.00,0.00,0.00),('1','57','468','257187',4897875,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257188',4897876,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257188',4897877,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257188',4897878,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257188',4897879,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257188',4897880,'1198','174',285991.36,287008.44,1017.08,417002.80,0.00,0.00,0.00,0.00,0.00),('1','57','468','257188',4897881,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257189',4897882,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257189',4897883,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257189',4897884,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257189',4897885,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257189',4897886,'1198','174',287008.44,288835.13,1826.69,748942.90,0.00,0.00,0.00,0.00,0.00),('1','57','468','257189',4897887,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257190',4897888,'1190','173',781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257190',4897889,'1191','173',63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257190',4897890,'1192','173',98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257190',4897891,'1193','173',732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257190',4897892,'1198','174',288835.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257190',4897893,'1239','174',589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257191',4897894,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257191',4897895,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257191',4897896,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257191',4897897,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257191',4897898,'1198','174',288835.13,288837.81,2.68,1072.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257191',4897899,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257192',4897900,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257192',4897901,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257192',4897902,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257192',4897903,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257192',4897904,'1198','174',288837.81,289295.39,457.58,187607.80,0.00,0.00,0.00,0.00,0.00),('1','57','468','257192',4897905,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257193',4897906,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257193',4897907,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257193',4897908,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257193',4897909,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257193',4897910,'1198','174',289295.39,289732.33,436.94,179145.40,0.00,0.00,0.00,0.00,0.00),('1','57','468','257193',4897911,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257194',4897912,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257194',4897913,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257194',4897914,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257194',4897915,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257194',4897916,'1198','174',289732.33,290252.48,520.15,213261.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','257194',4897917,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257195',4897918,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257195',4897919,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257195',4897920,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257195',4897921,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257195',4897922,'1198','174',290252.48,292401.48,2149.00,881090.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257195',4897923,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257196',4897924,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257196',4897925,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257196',4897926,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257196',4897927,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257196',4897928,'1198','174',292401.48,292603.97,202.49,83020.90,0.00,0.00,0.00,0.00,0.00),('1','57','468','257196',4897929,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257197',4897930,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257197',4897931,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257197',4897932,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257197',4897933,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257197',4897934,'1198','174',292603.97,292608.12,4.15,1701.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','257197',4897935,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257198',4897936,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257198',4897937,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257198',4897938,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257198',4897939,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257198',4897940,'1198','174',292608.12,294203.16,1595.04,653966.40,0.00,0.00,0.00,0.00,0.00),('1','57','468','257198',4897941,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257199',4897942,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257199',4897943,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257199',4897944,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257199',4897945,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257199',4897946,'1198','174',294203.16,296133.92,1930.76,791611.60,0.00,0.00,0.00,0.00,0.00),('1','57','468','257199',4897947,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257200',4897948,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257200',4897949,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257200',4897950,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257200',4897951,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257200',4897952,'1198','174',296133.92,297087.92,954.00,391140.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257200',4897953,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257201',4897954,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257201',4897955,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257201',4897956,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257201',4897957,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257201',4897958,'1198','174',297087.92,297143.33,55.41,22718.10,0.00,0.00,0.00,0.00,0.00),('1','57','468','257201',4897959,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257202',4897960,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257202',4897961,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257202',4897962,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257202',4897963,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257202',4897964,'1198','174',297143.33,299150.41,2007.08,822902.80,0.00,0.00,0.00,0.00,0.00),('1','57','468','257202',4897965,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257203',4897966,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257203',4897967,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257203',4897968,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257203',4897969,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257203',4897970,'1198','174',299150.41,301571.08,2420.67,992474.70,0.00,0.00,0.00,0.00,0.00),('1','57','468','257203',4897971,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257204',4897972,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257204',4897973,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257204',4897974,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257204',4897975,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257204',4897976,'1198','174',301571.08,302676.05,1104.97,453037.70,0.00,0.00,0.00,0.00,0.00),('1','57','468','257204',4897977,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257205',4897978,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257205',4897979,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257205',4897980,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257205',4897981,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257205',4897982,'1198','174',302676.05,306291.06,3615.01,1482154.10,0.00,0.00,0.00,0.00,0.00),('1','57','468','257205',4897983,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257206',4897984,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257206',4897985,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257206',4897986,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257206',4897987,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257206',4897988,'1198','174',306291.06,307076.79,785.73,322149.30,0.00,0.00,0.00,0.00,0.00),('1','57','468','257206',4897989,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257207',4897990,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257207',4897991,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257207',4897992,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257207',4897993,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257207',4897994,'1198','174',307076.79,308857.23,1780.44,729980.40,0.00,0.00,0.00,0.00,0.00),('1','57','468','257207',4897995,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257208',4897996,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257208',4897997,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257208',4897998,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257208',4897999,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257208',4898000,'1198','174',308857.23,308969.64,112.41,46088.10,0.00,0.00,0.00,0.00,0.00),('1','57','468','257208',4898001,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257209',4898002,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257209',4898003,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257209',4898004,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257209',4898005,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257209',4898006,'1198','174',308969.64,310361.36,1391.72,577563.80,0.00,0.00,0.00,0.00,0.00),('1','57','468','257209',4898007,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257210',4898008,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257210',4898009,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257210',4898010,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257210',4898011,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257210',4898012,'1198','174',310361.36,311111.40,750.04,311266.60,0.00,0.00,0.00,0.00,0.00),('1','57','468','257210',4898013,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257211',4898014,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257211',4898015,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257211',4898016,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257211',4898017,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257211',4898018,'1198','174',311111.40,313707.49,2596.09,1077377.35,0.00,0.00,0.00,0.00,0.00),('1','57','468','257211',4898019,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257212',4898020,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257212',4898021,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257212',4898022,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257212',4898023,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257212',4898024,'1198','174',313707.49,317227.49,3520.00,1460800.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257212',4898025,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257213',4898026,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257213',4898027,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257213',4898028,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257213',4898029,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257213',4898030,'1198','174',317227.49,318951.32,1723.83,715389.45,0.00,0.00,0.00,0.00,0.00),('1','57','468','257213',4898031,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257214',4898032,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257214',4898033,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257214',4898034,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257214',4898035,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257214',4898036,'1198','174',318951.32,319551.37,600.05,249020.75,0.00,0.00,0.00,0.00,0.00),('1','57','468','257214',4898037,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257215',4898038,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257215',4898039,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257215',4898040,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257215',4898041,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257215',4898042,'1198','174',319551.37,320571.69,1020.32,423432.80,0.00,0.00,0.00,0.00,0.00),('1','57','468','257215',4898043,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257216',4898044,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257216',4898045,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257216',4898046,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257216',4898047,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257216',4898048,'1198','174',320571.69,323338.69,2767.00,1148305.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257216',4898049,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257217',4898050,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257217',4898051,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257217',4898052,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257217',4898053,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257217',4898054,'1198','174',323338.69,323338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257217',4898055,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257218',4898056,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257218',4898057,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257218',4898058,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257218',4898059,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257218',4898060,'1198','174',323338.69,323338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257218',4898061,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257219',4898062,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257219',4898063,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257219',4898064,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257219',4898065,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257219',4898066,'1198','174',323338.69,323338.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257219',4898067,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257220',4898068,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257220',4898069,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257220',4898070,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257220',4898071,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257220',4898072,'1198','174',323338.69,324465.28,1126.59,484433.70,0.00,0.00,0.00,0.00,0.00),('1','57','468','257220',4898073,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257221',4898074,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257221',4898075,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257221',4898076,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257221',4898077,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257221',4898078,'1198','174',324465.28,326647.05,2181.77,938161.10,0.00,0.00,0.00,0.00,0.00),('1','57','468','257221',4898079,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257222',4898080,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257222',4898081,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257222',4898082,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257222',4898083,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257222',4898084,'1198','174',326647.05,327699.66,1052.61,452622.30,0.00,0.00,0.00,0.00,0.00),('1','57','468','257222',4898085,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257223',4898086,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257223',4898087,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257223',4898088,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257223',4898089,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257223',4898090,'1198','174',327699.66,328647.45,947.79,435983.40,0.00,0.00,0.00,0.00,0.00),('1','57','468','257223',4898091,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257224',4898092,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257224',4898093,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257224',4898094,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257224',4898095,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257224',4898096,'1198','174',328647.45,333107.41,4459.96,2051581.60,0.00,0.00,0.00,0.00,0.00),('1','57','468','257224',4898097,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257225',4898098,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257225',4898099,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257225',4898100,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257225',4898101,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257225',4898102,'1198','174',333107.41,333606.48,499.07,249535.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257225',4898103,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257226',4898104,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257226',4898105,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257226',4898106,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257226',4898107,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257226',4898108,'1198','174',333606.48,335718.56,2112.08,1056040.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257226',4898109,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257227',4898110,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257227',4898111,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257227',4898112,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257227',4898113,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257227',4898114,'1198','174',335718.56,335718.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257227',4898115,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257228',4898116,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257228',4898117,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257228',4898118,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257228',4898119,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257228',4898120,'1198','174',335718.56,337538.57,1820.01,910005.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257228',4898121,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257229',4898122,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257229',4898123,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257229',4898124,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257229',4898125,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257229',4898126,'1198','174',337538.57,339538.57,2000.00,1000000.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257229',4898127,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257230',4898128,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257230',4898129,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257230',4898130,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257230',4898131,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257230',4898132,'1198','174',339538.57,339540.57,2.00,1000.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257230',4898133,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257231',4898134,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257231',4898135,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257231',4898136,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257231',4898137,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257231',4898138,'1198','174',339540.57,341543.85,2003.28,1001640.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257231',4898139,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257232',4898140,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257232',4898141,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257232',4898142,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257232',4898143,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257232',4898144,'1198','174',341543.85,341745.87,202.02,121212.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257232',4898145,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257233',4898146,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257233',4898147,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257233',4898148,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257233',4898149,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257233',4898150,'1198','174',341745.87,341746.37,0.50,300.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257233',4898151,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257234',4898152,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257234',4898153,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257234',4898154,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257234',4898155,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257234',4898156,'1198','174',341746.37,341746.87,0.50,300.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257234',4898157,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257235',4898158,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257235',4898159,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257235',4898160,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257235',4898161,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257235',4898162,'1198','174',341746.87,343305.11,1558.24,934944.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257235',4898163,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257236',4898164,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257236',4898165,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257236',4898166,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257236',4898167,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257236',4898168,'1198','174',343305.11,345810.94,2505.83,1503498.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257236',4898169,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257237',4898170,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257237',4898171,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257237',4898172,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257237',4898173,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257237',4898174,'1198','174',345810.94,346312.93,501.99,301194.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257237',4898175,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257238',4898176,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257238',4898177,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257238',4898178,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257238',4898179,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257238',4898180,'1198','174',346312.93,346544.93,232.00,139200.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257238',4898181,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257239',4898182,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257239',4898183,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257239',4898184,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257239',4898185,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257239',4898186,'1198','174',346544.93,346544.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257239',4898187,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257240',4898188,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257240',4898189,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257240',4898190,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257240',4898191,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257240',4898192,'1198','174',346544.93,346957.65,412.72,288904.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257240',4898193,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257241',4898194,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257241',4898195,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257241',4898196,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257241',4898197,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257241',4898198,'1198','174',346957.65,347969.22,1011.57,708099.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257241',4898199,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257242',4898200,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257242',4898201,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257242',4898202,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257242',4898203,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257242',4898204,'1198','174',347969.22,347994.93,25.71,17997.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257242',4898205,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257243',4898206,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257243',4898207,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257243',4898208,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257243',4898209,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257243',4898210,'1198','174',347994.93,348305.22,310.29,217203.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257243',4898211,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257244',4898212,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257244',4898213,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257244',4898214,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257244',4898215,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257244',4898216,'1198','174',348305.22,348625.93,320.71,224497.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257244',4898217,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257245',4898218,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257245',4898219,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257245',4898220,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257245',4898221,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257245',4898222,'1198','174',348625.93,348652.92,26.99,18893.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257245',4898223,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257246',4898224,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257246',4898225,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257246',4898226,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257246',4898227,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257246',4898228,'1198','174',348652.92,348652.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257246',4898229,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257247',4898230,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257247',4898231,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257247',4898232,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257247',4898233,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257247',4898234,'1198','174',348652.92,348662.91,9.99,6993.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257247',4898235,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257248',4898236,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257248',4898237,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257248',4898238,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257248',4898239,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257248',4898240,'1198','174',348662.91,348692.91,30.00,21000.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257248',4898241,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257249',4898242,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257249',4898243,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257249',4898244,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257249',4898245,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257249',4898246,'1198','174',348692.91,348706.06,13.15,9205.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257249',4898247,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257250',4898248,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257250',4898249,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257250',4898250,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257250',4898251,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257250',4898252,'1198','174',348706.06,348799.52,93.46,65422.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257250',4898253,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257251',4898254,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257251',4898255,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257251',4898256,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257251',4898257,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257251',4898258,'1198','174',348799.52,348911.53,112.01,78407.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257251',4898259,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257252',4898260,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257252',4898261,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257252',4898262,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257252',4898263,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257252',4898264,'1198','174',348911.53,351340.36,2428.83,1700181.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257252',4898265,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257253',4898266,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257253',4898267,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257253',4898268,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257253',4898269,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257253',4898270,'1198','174',351340.36,351347.50,7.14,4998.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257253',4898271,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257254',4898272,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257254',4898273,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257254',4898274,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257254',4898275,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257254',4898276,'1198','174',351347.50,351357.10,9.60,6720.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257254',4898277,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257255',4898278,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257255',4898279,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257255',4898280,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257255',4898281,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257255',4898282,'1198','174',351357.10,351449.66,92.56,64792.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257255',4898283,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257256',4898284,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257256',4898285,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257256',4898286,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257256',4898287,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257256',4898288,'1198','174',351449.66,351498.94,49.28,34496.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257256',4898289,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257257',4898290,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257257',4898291,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257257',4898292,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257257',4898293,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257257',4898294,'1198','174',351498.94,351558.94,60.00,42000.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257257',4898295,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257258',4898296,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257258',4898297,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257258',4898298,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257258',4898299,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257258',4898300,'1198','174',351558.94,351558.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257258',4898301,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257259',4898302,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257259',4898303,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257259',4898304,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257259',4898305,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257259',4898306,'1198','174',351558.94,351602.23,43.29,30303.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257259',4898307,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257260',4898308,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257260',4898309,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257260',4898310,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257260',4898311,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257260',4898312,'1198','174',351602.23,351628.82,26.59,18613.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257260',4898313,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257261',4898314,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257261',4898315,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257261',4898316,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257261',4898317,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257261',4898318,'1198','174',351628.82,351630.02,1.20,840.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257261',4898319,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257262',4898320,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257262',4898321,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257262',4898322,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257262',4898323,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257262',4898324,'1198','174',351630.02,351630.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257262',4898325,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257263',4898326,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257263',4898327,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257263',4898328,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257263',4898329,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257263',4898330,'1198','174',351630.02,351633.14,3.12,2184.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257263',4898331,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257264',4898332,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257264',4898333,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257264',4898334,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257264',4898335,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257264',4898336,'1198','174',351633.14,351633.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257264',4898337,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257265',4898338,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257265',4898339,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257265',4898340,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257265',4898341,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257265',4898342,'1198','174',351633.14,351756.82,123.68,86576.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257265',4898343,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257266',4898344,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257266',4898345,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257266',4898346,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257266',4898347,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257266',4898348,'1198','174',351756.82,351756.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257266',4898349,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257267',4898350,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257267',4898351,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257267',4898352,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257267',4898353,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257267',4898354,'1198','174',351756.82,351770.25,13.43,9401.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257267',4898355,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257268',4898356,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257268',4898357,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257268',4898358,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257268',4898359,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257268',4898360,'1198','174',351770.25,351770.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257268',4898361,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257269',4898362,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257269',4898363,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257269',4898364,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257269',4898365,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257269',4898366,'1198','174',351770.25,352614.46,844.21,590947.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257269',4898367,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257270',4898368,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257270',4898369,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257270',4898370,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257270',4898371,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257270',4898372,'1198','174',352614.46,352949.46,335.00,234500.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257270',4898373,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257271',4898374,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257271',4898375,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257271',4898376,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257271',4898377,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257271',4898378,'1198','174',352949.46,353166.60,217.14,151998.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257271',4898379,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257272',4898380,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257272',4898381,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257272',4898382,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257272',4898383,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257272',4898384,'1198','174',353166.60,353705.60,539.00,377300.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257272',4898385,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257273',4898386,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257273',4898387,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257273',4898388,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257273',4898389,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257273',4898390,'1198','174',353705.60,354251.75,546.15,382305.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257273',4898391,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257274',4898392,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257274',4898393,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257274',4898394,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257274',4898395,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257274',4898396,'1198','174',354251.75,354251.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257274',4898397,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257275',4898398,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257275',4898399,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257275',4898400,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257275',4898401,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257275',4898402,'1198','174',354251.75,354257.39,5.64,3948.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257275',4898403,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257276',4898404,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257276',4898405,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257276',4898406,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257276',4898407,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257276',4898408,'1198','174',354257.39,354311.30,53.91,37737.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257276',4898409,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257277',4898410,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257277',4898411,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257277',4898412,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257277',4898413,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257277',4898414,'1198','174',354311.30,354311.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257277',4898415,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257278',4898416,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257278',4898417,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257278',4898418,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257278',4898419,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257278',4898420,'1198','174',354311.30,354316.73,5.43,3801.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257278',4898421,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257279',4898422,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257279',4898423,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257279',4898424,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257279',4898425,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257279',4898426,'1198','174',354316.73,354443.02,126.29,88403.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257279',4898427,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257280',4898428,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257280',4898429,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257280',4898430,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257280',4898431,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257280',4898432,'1198','174',354443.02,354447.16,4.14,2898.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257280',4898433,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257281',4898434,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257281',4898435,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257281',4898436,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257281',4898437,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257281',4898438,'1198','174',354447.16,355459.30,1012.14,708498.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257281',4898439,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257282',4898440,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257282',4898441,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257282',4898442,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257282',4898443,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257282',4898444,'1198','174',355459.30,356443.30,984.00,688800.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257282',4898445,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257283',4898446,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257283',4898447,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257283',4898448,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257283',4898449,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257283',4898450,'1198','174',356443.30,356447.30,4.00,2800.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257283',4898451,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257284',4898452,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257284',4898453,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257284',4898454,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257284',4898455,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257284',4898456,'1198','174',356447.30,356447.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257284',4898457,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257285',4898458,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257285',4898459,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257285',4898460,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257285',4898461,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257285',4898462,'1198','174',356447.30,356509.30,62.00,43400.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257285',4898463,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257286',4898464,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257286',4898465,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257286',4898466,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257286',4898467,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257286',4898468,'1198','174',356509.30,356709.30,200.00,140000.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257286',4898469,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257287',4898470,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257287',4898471,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257287',4898472,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257287',4898473,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257287',4898474,'1198','174',356709.30,357051.10,341.80,239260.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257287',4898475,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257288',4898476,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257288',4898477,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257288',4898478,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257288',4898479,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257288',4898480,'1198','174',357051.10,357551.10,500.00,332500.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257288',4898481,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257289',4898482,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257289',4898483,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257289',4898484,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257289',4898485,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257289',4898486,'1198','174',357551.10,357851.05,299.95,199466.75,0.00,0.00,0.00,0.00,0.00),('1','57','468','257289',4898487,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257290',4898488,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257290',4898489,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257290',4898490,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257290',4898491,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257290',4898492,'1198','174',357851.05,358593.80,742.75,493928.75,0.00,0.00,0.00,0.00,0.00),('1','57','468','257290',4898493,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257291',4898494,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257291',4898495,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257291',4898496,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257291',4898497,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257291',4898498,'1198','174',358593.80,360029.39,1435.59,954667.35,0.00,0.00,0.00,0.00,0.00),('1','57','468','257291',4898499,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257292',4898500,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257292',4898501,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257292',4898502,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257292',4898503,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257292',4898504,'1198','174',360029.39,360583.44,554.05,368443.25,0.00,0.00,0.00,0.00,0.00),('1','57','468','257292',4898505,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257293',4898506,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257293',4898507,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257293',4898508,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257293',4898509,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257293',4898510,'1198','174',360583.44,361065.40,481.96,320503.40,0.00,0.00,0.00,0.00,0.00),('1','57','468','257293',4898511,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257294',4898512,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257294',4898513,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257294',4898514,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257294',4898515,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257294',4898516,'1198','174',361065.40,361065.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257294',4898517,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257295',4898518,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257295',4898519,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257295',4898520,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257295',4898521,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257295',4898522,'1198','174',361065.40,361434.42,369.02,245398.30,0.00,0.00,0.00,0.00,0.00),('1','57','468','257295',4898523,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257296',4898524,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257296',4898525,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257296',4898526,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257296',4898527,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257296',4898528,'1198','174',361434.42,361434.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257296',4898529,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257297',4898530,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257297',4898531,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257297',4898532,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257297',4898533,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257297',4898534,'1198','174',361434.42,362288.84,854.42,568189.30,0.00,0.00,0.00,0.00,0.00),('1','57','468','257297',4898535,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257298',4898536,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257298',4898537,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257298',4898538,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257298',4898539,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257298',4898540,'1198','174',362288.84,363162.71,873.87,581123.55,0.00,0.00,0.00,0.00,0.00),('1','57','468','257298',4898541,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257299',4898542,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257299',4898543,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257299',4898544,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257299',4898545,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257299',4898546,'1198','174',363162.71,363622.22,459.51,305574.15,0.00,0.00,0.00,0.00,0.00),('1','57','468','257299',4898547,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257300',4898548,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257300',4898549,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257300',4898550,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257300',4898551,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257300',4898552,'1198','174',363622.22,363622.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257300',4898553,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257301',4898554,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257301',4898555,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257301',4898556,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257301',4898557,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257301',4898558,'1198','174',363622.22,363789.96,167.74,134192.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257301',4898559,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257302',4898560,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257302',4898561,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257302',4898562,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257302',4898563,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257302',4898564,'1198','174',363789.96,364393.69,603.73,482984.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257302',4898565,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257303',4898566,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257303',4898567,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257303',4898568,'1192','173',98164.60,98164.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257303',4898569,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257303',4898570,'1198','174',364393.69,364393.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257303',4898571,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257304',4898572,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257304',4898573,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257304',4898574,'1192','173',98164.60,98376.43,78.63,12973.95,0.00,0.00,133.20,0.00,0.00),('1','57','446','257304',4898575,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257304',4898576,'1198','174',364393.69,364543.07,55.78,44624.00,0.00,0.00,93.60,0.00,0.00),('1','57','468','257304',4898577,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257305',4898578,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257305',4898579,'1191','173',63285.11,63285.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257305',4898580,'1192','173',98376.43,98573.21,196.78,37388.20,0.00,0.00,0.00,0.00,0.00),('1','57','446','257305',4898581,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257305',4898582,'1198','174',364543.07,364655.46,112.39,89912.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257305',4898583,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257306',4898584,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257306',4898585,'1191','173',63285.11,63426.43,141.32,26850.80,0.00,0.00,0.00,0.00,0.00),('1','57','446','257306',4898586,'1192','173',98573.21,98717.43,144.22,27401.80,0.00,0.00,0.00,0.00,0.00),('1','57','446','257306',4898587,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257306',4898588,'1198','174',364655.46,364727.84,72.38,57904.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257306',4898589,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257307',4898590,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257307',4898591,'1191','173',63426.43,63426.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257307',4898592,'1192','173',98717.43,98934.91,217.48,41321.20,0.00,0.00,0.00,0.00,0.00),('1','57','446','257307',4898593,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257307',4898594,'1198','174',364727.84,365437.89,710.05,568040.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257307',4898595,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257308',4898596,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257308',4898597,'1191','173',63426.43,63612.31,185.88,35317.20,0.00,0.00,0.00,0.00,0.00),('1','57','446','257308',4898598,'1192','173',98934.91,99110.72,175.81,33403.90,0.00,0.00,0.00,0.00,0.00),('1','57','446','257308',4898599,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257308',4898600,'1198','174',365437.89,366057.21,619.32,495456.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257308',4898601,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257309',4898602,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257309',4898603,'1191','173',63612.31,63612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257309',4898604,'1192','173',99110.72,99259.18,148.46,28207.40,0.00,0.00,0.00,0.00,0.00),('1','57','446','257309',4898605,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257309',4898606,'1198','174',366057.21,366138.34,81.13,64904.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257309',4898607,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257310',4898608,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257310',4898609,'1191','173',63612.31,63738.15,125.84,23909.60,0.00,0.00,0.00,0.00,0.00),('1','57','446','257310',4898610,'1192','173',99259.18,99400.77,141.59,26902.10,0.00,0.00,0.00,0.00,0.00),('1','57','446','257310',4898611,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257310',4898612,'1198','174',366138.34,366200.94,62.60,50080.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257310',4898613,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257311',4898614,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257311',4898615,'1191','173',63738.15,63738.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257311',4898616,'1192','173',99400.77,99640.04,239.27,45461.30,0.00,0.00,0.00,0.00,0.00),('1','57','446','257311',4898617,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257311',4898618,'1198','174',366200.94,366919.76,718.82,575056.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257311',4898619,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257312',4898620,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257312',4898621,'1191','173',63738.15,63824.40,86.25,16387.50,0.00,0.00,0.00,0.00,0.00),('1','57','446','257312',4898622,'1192','173',99640.04,99724.55,84.51,16056.90,0.00,0.00,0.00,0.00,0.00),('1','57','446','257312',4898623,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257312',4898624,'1198','174',366919.76,367427.34,507.58,406064.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257312',4898625,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257313',4898626,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257313',4898627,'1191','173',63824.40,63824.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257313',4898628,'1192','173',99724.55,99945.20,220.65,41923.50,0.00,0.00,0.00,0.00,0.00),('1','57','446','257313',4898629,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257313',4898630,'1198','174',367427.34,368083.35,656.01,524808.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257313',4898631,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257314',4898632,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257314',4898633,'1191','173',63824.40,63870.55,46.15,8768.50,0.00,0.00,0.00,0.00,0.00),('1','57','446','257314',4898634,'1192','173',99945.20,100052.94,107.74,20470.60,0.00,0.00,0.00,0.00,0.00),('1','57','446','257314',4898635,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257314',4898636,'1198','174',368083.35,368097.08,13.73,10984.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257314',4898637,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257315',4898638,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257315',4898639,'1191','173',63870.55,63870.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257315',4898640,'1192','173',100052.94,100116.61,63.67,12097.30,0.00,0.00,0.00,0.00,0.00),('1','57','446','257315',4898641,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257315',4898642,'1198','174',368097.08,368826.40,729.32,583456.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257315',4898643,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257316',4898644,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257316',4898645,'1191','173',63870.55,63870.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257316',4898646,'1192','173',100116.61,100305.82,189.21,35949.90,0.00,0.00,0.00,0.00,0.00),('1','57','446','257316',4898647,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257316',4898648,'1198','174',368826.40,369822.40,996.00,796800.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257316',4898649,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257317',4898650,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257317',4898651,'1191','173',63870.55,63870.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257317',4898652,'1192','173',100305.82,100662.30,356.48,67731.20,0.00,0.00,0.00,0.00,0.00),('1','57','446','257317',4898653,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257317',4898654,'1198','174',369822.40,369904.91,82.51,66008.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257317',4898655,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257318',4898656,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257318',4898657,'1191','173',63870.55,63870.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257318',4898658,'1192','173',100662.30,101231.19,568.89,108089.10,0.00,0.00,0.00,0.00,0.00),('1','57','446','257318',4898659,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257318',4898660,'1198','174',369904.91,369967.67,62.76,50208.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257318',4898661,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257319',4898662,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257319',4898663,'1191','173',63870.55,64029.55,159.00,30210.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257319',4898664,'1192','173',101231.19,101773.21,542.02,102983.80,0.00,0.00,0.00,0.00,0.00),('1','57','446','257319',4898665,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257319',4898666,'1198','174',369967.67,370707.90,740.23,592184.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257319',4898667,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257320',4898668,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257320',4898669,'1191','173',64029.55,64230.14,200.59,38112.10,0.00,0.00,0.00,0.00,0.00),('1','57','446','257320',4898670,'1192','173',101773.21,101925.27,152.06,28891.40,0.00,0.00,0.00,0.00,0.00),('1','57','446','257320',4898671,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257320',4898672,'1198','174',370707.90,370907.91,200.01,160008.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257320',4898673,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257321',4898674,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257321',4898675,'1191','173',64230.14,64230.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257321',4898676,'1192','173',101925.27,102290.69,365.42,69429.80,0.00,0.00,0.00,0.00,0.00),('1','57','446','257321',4898677,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257321',4898678,'1198','174',370907.91,371411.42,503.51,402808.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257321',4898679,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257322',4898680,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257322',4898681,'1191','173',64230.14,64384.66,154.52,29358.80,0.00,0.00,0.00,0.00,0.00),('1','57','446','257322',4898682,'1192','173',102290.69,102495.63,204.94,38938.60,0.00,0.00,0.00,0.00,0.00),('1','57','446','257322',4898683,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257322',4898684,'1198','174',371411.42,371520.80,109.38,87504.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257322',4898685,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257323',4898686,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257323',4898687,'1191','173',64384.66,64384.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257323',4898688,'1192','173',102495.63,102720.34,224.71,42694.90,0.00,0.00,0.00,0.00,0.00),('1','57','446','257323',4898689,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257323',4898690,'1198','174',371520.80,372023.43,502.63,402104.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257323',4898691,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257324',4898692,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257324',4898693,'1191','173',64384.66,64537.00,152.34,28944.60,0.00,0.00,0.00,0.00,0.00),('1','57','446','257324',4898694,'1192','173',102720.34,102906.31,185.97,35334.30,0.00,0.00,0.00,0.00,0.00),('1','57','446','257324',4898695,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257324',4898696,'1198','174',372023.43,372073.43,50.00,40000.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257324',4898697,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257325',4898698,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257325',4898699,'1191','173',64537.00,64537.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257325',4898700,'1192','173',102906.31,103149.78,243.47,46259.30,0.00,0.00,0.00,0.00,0.00),('1','57','446','257325',4898701,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257325',4898702,'1198','174',372073.43,372378.94,305.51,244408.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257325',4898703,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257326',4898704,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257326',4898705,'1191','173',64537.00,64816.63,279.63,53129.70,0.00,0.00,0.00,0.00,0.00),('1','57','446','257326',4898706,'1192','173',103149.78,103315.46,165.68,31479.20,0.00,0.00,0.00,0.00,0.00),('1','57','446','257326',4898707,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257326',4898708,'1198','174',372378.94,372581.82,202.88,162304.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257326',4898709,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257327',4898710,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257327',4898711,'1191','173',64816.63,64914.66,98.03,18625.70,0.00,0.00,0.00,0.00,0.00),('1','57','446','257327',4898712,'1192','173',103315.46,103569.82,254.36,48328.40,0.00,0.00,0.00,0.00,0.00),('1','57','446','257327',4898713,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257327',4898714,'1198','174',372581.82,372608.76,26.94,21552.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257327',4898715,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257328',4898716,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257328',4898717,'1191','173',64914.66,65035.47,120.81,22953.90,0.00,0.00,0.00,0.00,0.00),('1','57','446','257328',4898718,'1192','173',103569.82,103710.13,140.31,26658.90,0.00,0.00,0.00,0.00,0.00),('1','57','446','257328',4898719,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257328',4898720,'1198','174',372608.76,373247.40,638.64,510912.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257328',4898721,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257329',4898722,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257329',4898723,'1191','173',65035.47,65035.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257329',4898724,'1192','173',103710.13,103911.00,200.87,38165.30,0.00,0.00,0.00,0.00,0.00),('1','57','446','257329',4898725,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257329',4898726,'1198','174',373247.40,373833.67,586.27,469016.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257329',4898727,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257330',4898728,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257330',4898729,'1191','173',65035.47,65178.85,143.38,27242.20,0.00,0.00,0.00,0.00,0.00),('1','57','446','257330',4898730,'1192','173',103911.00,104052.51,141.51,26886.90,0.00,0.00,0.00,0.00,0.00),('1','57','446','257330',4898731,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257330',4898732,'1198','174',373833.67,374434.98,601.31,481048.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257330',4898733,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257331',4898734,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257331',4898735,'1191','173',65178.85,65178.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257331',4898736,'1192','173',104052.51,104326.51,274.00,52060.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257331',4898737,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257331',4898738,'1198','174',374434.98,375081.37,646.39,517112.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257331',4898739,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257332',4898740,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257332',4898741,'1191','173',65178.85,65376.16,197.31,37488.90,0.00,0.00,0.00,0.00,0.00),('1','57','446','257332',4898742,'1192','173',104326.51,104513.71,187.20,35568.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257332',4898743,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257332',4898744,'1198','174',375081.37,375411.37,330.00,264000.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257332',4898745,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257333',4898746,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257333',4898747,'1191','173',65376.16,65525.40,149.24,28355.60,0.00,0.00,0.00,0.00,0.00),('1','57','446','257333',4898748,'1192','173',104513.71,104675.24,161.53,30690.70,0.00,0.00,0.00,0.00,0.00),('1','57','446','257333',4898749,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257333',4898750,'1198','174',375411.37,375414.76,3.39,2712.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257333',4898751,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257334',4898752,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257334',4898753,'1191','173',65525.40,65640.59,115.19,21886.10,0.00,0.00,0.00,0.00,0.00),('1','57','446','257334',4898754,'1192','173',104675.24,104838.40,163.16,31000.40,0.00,0.00,0.00,0.00,0.00),('1','57','446','257334',4898755,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257334',4898756,'1198','174',375414.76,376025.76,611.00,488800.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257334',4898757,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257335',4898758,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257335',4898759,'1191','173',65640.59,65844.08,203.49,38663.10,0.00,0.00,0.00,0.00,0.00),('1','57','446','257335',4898760,'1192','173',104838.40,104997.56,159.16,30240.40,0.00,0.00,0.00,0.00,0.00),('1','57','446','257335',4898761,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257335',4898762,'1198','174',376025.76,376080.01,54.25,43400.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257335',4898763,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257336',4898764,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257336',4898765,'1191','173',65844.08,66102.95,258.87,49185.30,0.00,0.00,0.00,0.00,0.00),('1','57','446','257336',4898766,'1192','173',104997.56,105361.95,364.39,69234.10,0.00,0.00,0.00,0.00,0.00),('1','57','446','257336',4898767,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257336',4898768,'1198','174',376080.01,376237.14,157.13,125704.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257336',4898769,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257337',4898770,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257337',4898771,'1191','173',66102.95,66296.29,193.34,36734.60,0.00,0.00,0.00,0.00,0.00),('1','57','446','257337',4898772,'1192','173',105361.95,105531.55,169.60,32224.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257337',4898773,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257337',4898774,'1198','174',376237.14,376301.77,64.63,51704.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257337',4898775,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257338',4898776,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257338',4898777,'1191','173',66296.29,66558.23,261.94,49768.60,0.00,0.00,0.00,0.00,0.00),('1','57','446','257338',4898778,'1192','173',105531.55,105862.19,330.64,62821.60,0.00,0.00,0.00,0.00,0.00),('1','57','446','257338',4898779,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257338',4898780,'1198','174',376301.77,376504.29,202.52,162016.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257338',4898781,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257339',4898782,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257339',4898783,'1191','173',66558.23,66772.65,214.42,40739.80,0.00,0.00,0.00,0.00,0.00),('1','57','446','257339',4898784,'1192','173',105862.19,106180.09,317.90,60401.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257339',4898785,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257339',4898786,'1198','174',376504.29,377011.20,506.91,405528.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257339',4898787,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257340',4898788,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257340',4898789,'1191','173',66772.65,66960.08,187.43,35611.70,0.00,0.00,0.00,0.00,0.00),('1','57','446','257340',4898790,'1192','173',106180.09,106363.59,183.50,34865.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257340',4898791,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257340',4898792,'1198','174',377011.20,377489.15,477.95,382360.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257340',4898793,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257341',4898794,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257341',4898795,'1191','173',66960.08,68909.15,1949.07,370323.30,0.00,0.00,0.00,0.00,0.00),('1','57','446','257341',4898796,'1192','173',106363.59,106490.56,126.97,24124.30,0.00,0.00,0.00,0.00,0.00),('1','57','446','257341',4898797,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257341',4898798,'1198','174',377489.15,377520.15,31.00,24800.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257341',4898799,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257342',4898800,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257342',4898801,'1191','173',68909.15,69331.42,422.27,80231.30,0.00,0.00,0.00,0.00,0.00),('1','57','446','257342',4898802,'1192','173',106490.56,106644.62,154.06,29271.40,0.00,0.00,0.00,0.00,0.00),('1','57','446','257342',4898803,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257342',4898804,'1198','174',377520.15,377770.15,250.00,200000.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257342',4898805,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257343',4898806,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257343',4898807,'1191','173',69331.42,69460.33,128.91,24492.90,0.00,0.00,0.00,0.00,0.00),('1','57','446','257343',4898808,'1192','173',106644.62,106808.43,163.81,31123.90,0.00,0.00,0.00,0.00,0.00),('1','57','446','257343',4898809,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257343',4898810,'1198','174',377770.15,378189.15,419.00,335200.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257343',4898811,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257344',4898812,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257344',4898813,'1191','173',69460.33,69460.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257344',4898814,'1192','173',106808.43,106808.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257344',4898815,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257344',4898816,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257344',4898817,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257345',4898818,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257345',4898819,'1191','173',69460.33,69460.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257345',4898820,'1192','173',106808.43,106808.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257345',4898821,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257345',4898822,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257345',4898823,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257346',4898824,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257346',4898825,'1191','173',69460.33,71746.04,2285.71,434284.90,0.00,0.00,0.00,0.00,0.00),('1','57','446','257346',4898826,'1192','173',106808.43,106994.94,186.51,35436.90,0.00,0.00,0.00,0.00,0.00),('1','57','446','257346',4898827,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257346',4898828,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257346',4898829,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257347',4898830,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257347',4898831,'1191','173',71746.04,71877.78,131.74,25030.60,0.00,0.00,0.00,0.00,0.00),('1','57','446','257347',4898832,'1192','173',106994.94,107173.78,178.84,33979.60,0.00,0.00,0.00,0.00,0.00),('1','57','446','257347',4898833,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257347',4898834,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257347',4898835,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257348',4898836,'1190','173',781046.87,781046.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257348',4898837,'1191','173',71877.78,72057.36,179.58,34120.20,0.00,0.00,0.00,0.00,0.00),('1','57','446','257348',4898838,'1192','173',107173.78,108512.88,1339.10,254429.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257348',4898839,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257348',4898840,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257348',4898841,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257349',4898842,'1190','173',781046.87,781472.65,425.78,80898.20,0.00,0.00,0.00,0.00,0.00),('1','57','445','257349',4898843,'1191','173',72057.36,72583.31,525.95,99930.50,0.00,0.00,0.00,0.00,0.00),('1','57','446','257349',4898844,'1192','173',108512.88,108521.93,9.05,1719.50,0.00,0.00,0.00,0.00,0.00),('1','57','446','257349',4898845,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257349',4898846,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257349',4898847,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257350',4898848,'1190','173',781472.65,781692.28,219.63,41729.70,0.00,0.00,0.00,0.00,0.00),('1','57','445','257350',4898849,'1191','173',72583.31,72779.01,195.70,37183.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257350',4898850,'1192','173',108521.93,108521.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257350',4898851,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257350',4898852,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257350',4898853,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257351',4898854,'1190','173',781692.28,782404.04,711.76,135234.40,0.00,0.00,0.00,0.00,0.00),('1','57','445','257351',4898855,'1191','173',72779.01,72948.16,169.15,32138.50,0.00,0.00,0.00,0.00,0.00),('1','57','446','257351',4898856,'1192','173',108521.93,108521.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257351',4898857,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257351',4898858,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257351',4898859,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257352',4898860,'1190','173',782404.04,782777.19,373.15,70898.50,0.00,0.00,0.00,0.00,0.00),('1','57','445','257352',4898861,'1191','173',72948.16,73413.39,465.23,88393.70,0.00,0.00,0.00,0.00,0.00),('1','57','446','257352',4898862,'1192','173',108521.93,108521.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257352',4898863,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257352',4898864,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257352',4898865,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257353',4898866,'1190','173',782777.19,782978.75,201.56,38296.40,0.00,0.00,0.00,0.00,0.00),('1','57','445','257353',4898867,'1191','173',73413.39,73708.31,294.92,56034.80,0.00,0.00,0.00,0.00,0.00),('1','57','446','257353',4898868,'1192','173',108521.93,108521.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257353',4898869,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257353',4898870,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257353',4898871,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257354',4898872,'1190','173',782978.75,783369.44,390.69,74231.10,0.00,0.00,0.00,0.00,0.00),('1','57','445','257354',4898873,'1191','173',73708.31,74029.79,321.48,61081.20,0.00,0.00,0.00,0.00,0.00),('1','57','446','257354',4898874,'1192','173',108521.93,109021.93,500.00,95000.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257354',4898875,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257354',4898876,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257354',4898877,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257355',4898878,'1190','173',783369.44,783811.82,442.38,84052.20,0.00,0.00,0.00,0.00,0.00),('1','57','445','257355',4898879,'1191','173',74029.79,74382.50,352.71,67014.90,0.00,0.00,0.00,0.00,0.00),('1','57','446','257355',4898880,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257355',4898881,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257355',4898882,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257355',4898883,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257356',4898884,'1190','173',783811.82,784276.42,454.60,86374.00,0.00,0.00,10.00,0.00,0.00),('1','57','445','257356',4898885,'1191','173',74382.50,74635.67,243.17,46202.30,0.00,0.00,10.00,0.00,0.00),('1','57','446','257356',4898886,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257356',4898887,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257356',4898888,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257356',4898889,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257357',4898890,'1190','173',784276.42,784585.53,309.11,58730.90,0.00,0.00,0.00,0.00,0.00),('1','57','445','257357',4898891,'1191','173',74635.67,74821.69,186.02,35343.80,0.00,0.00,0.00,0.00,0.00),('1','57','446','257357',4898892,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257357',4898893,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257357',4898894,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257357',4898895,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257358',4898896,'1190','173',784585.53,784940.40,354.87,67425.30,0.00,0.00,0.00,0.00,0.00),('1','57','445','257358',4898897,'1191','173',74821.69,75040.04,218.35,41486.50,0.00,0.00,0.00,0.00,0.00),('1','57','446','257358',4898898,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257358',4898899,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257358',4898900,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257358',4898901,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257359',4898902,'1190','173',784940.40,785522.37,581.97,110574.30,0.00,0.00,0.00,0.00,0.00),('1','57','445','257359',4898903,'1191','173',75040.04,75547.97,507.93,96506.70,0.00,0.00,0.00,0.00,0.00),('1','57','446','257359',4898904,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257359',4898905,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257359',4898906,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257359',4898907,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257360',4898908,'1190','173',785522.37,785744.24,221.87,42155.30,0.00,0.00,0.00,0.00,0.00),('1','57','445','257360',4898909,'1191','173',75547.97,75730.06,182.09,34597.10,0.00,0.00,0.00,0.00,0.00),('1','57','446','257360',4898910,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257360',4898911,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257360',4898912,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257360',4898913,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257361',4898914,'1190','173',785744.24,786312.31,568.07,107933.30,0.00,0.00,0.00,0.00,0.00),('1','57','445','257361',4898915,'1191','173',75730.06,76114.36,384.30,73017.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257361',4898916,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257361',4898917,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257361',4898918,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257361',4898919,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257362',4898920,'1190','173',786312.31,786652.69,340.38,64672.20,0.00,0.00,0.00,0.00,0.00),('1','57','445','257362',4898921,'1191','173',76114.36,76240.69,126.33,24002.70,0.00,0.00,0.00,0.00,0.00),('1','57','446','257362',4898922,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257362',4898923,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257362',4898924,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257362',4898925,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257363',4898926,'1190','173',786652.69,787047.47,394.78,75008.20,0.00,0.00,0.00,0.00,0.00),('1','57','445','257363',4898927,'1191','173',76240.69,76632.29,391.60,74404.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257363',4898928,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257363',4898929,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257363',4898930,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257363',4898931,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257364',4898932,'1190','173',787047.47,787355.51,308.04,58527.60,0.00,0.00,0.00,0.00,0.00),('1','57','445','257364',4898933,'1191','173',76632.29,76844.93,212.64,40401.60,0.00,0.00,0.00,0.00,0.00),('1','57','446','257364',4898934,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257364',4898935,'1193','173',732915.37,732915.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257364',4898936,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257364',4898937,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257365',4898938,'1190','173',787355.51,787480.31,124.80,23712.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257365',4898939,'1191','173',76844.93,76901.37,56.44,10723.60,0.00,0.00,0.00,0.00,0.00),('1','57','446','257365',4898940,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257365',4898941,'1193','173',732915.37,733779.83,864.46,164247.40,0.00,0.00,0.00,0.00,0.00),('1','57','447','257365',4898942,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257365',4898943,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257366',4898944,'1190','173',787480.31,787480.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257366',4898945,'1191','173',76901.37,76901.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257366',4898946,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257366',4898947,'1193','173',733779.83,734542.76,762.93,144956.70,0.00,0.00,0.00,0.00,0.00),('1','57','447','257366',4898948,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257366',4898949,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257367',4898950,'1190','173',787480.31,787480.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257367',4898951,'1191','173',76901.37,76901.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257367',4898952,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257367',4898953,'1193','173',734542.76,735522.99,980.23,186243.70,0.00,0.00,0.00,0.00,0.00),('1','57','447','257367',4898954,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257367',4898955,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257368',4898956,'1190','173',787480.31,787480.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257368',4898957,'1191','173',76901.37,76901.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257368',4898958,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257368',4898959,'1193','173',735522.99,736354.16,831.17,157922.30,0.00,0.00,0.00,0.00,0.00),('1','57','447','257368',4898960,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257368',4898961,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257369',4898962,'1190','173',787480.31,787480.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257369',4898963,'1191','173',76901.37,76901.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257369',4898964,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257369',4898965,'1193','173',736354.16,737273.25,919.09,174627.10,0.00,0.00,0.00,0.00,0.00),('1','57','447','257369',4898966,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257369',4898967,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257370',4898968,'1190','173',787480.31,787480.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257370',4898969,'1191','173',76901.37,76901.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257370',4898970,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257370',4898971,'1193','173',737273.25,737728.82,455.57,86558.30,0.00,0.00,0.00,0.00,0.00),('1','57','447','257370',4898972,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257370',4898973,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257371',4898974,'1190','173',787480.31,787480.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257371',4898975,'1191','173',76901.37,76901.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257371',4898976,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257371',4898977,'1193','173',737728.82,738622.97,844.15,160388.50,0.00,0.00,50.00,0.00,0.00),('1','57','447','257371',4898978,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257371',4898979,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257372',4898980,'1190','173',787480.31,787480.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257372',4898981,'1191','173',76901.37,76901.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257372',4898982,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257372',4898983,'1193','173',738622.97,739040.02,417.05,79239.50,0.00,0.00,0.00,0.00,0.00),('1','57','447','257372',4898984,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257372',4898985,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257373',4898986,'1190','173',787480.31,787480.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257373',4898987,'1191','173',76901.37,76901.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257373',4898988,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257373',4898989,'1193','173',739040.02,740853.56,1813.54,344572.60,0.00,0.00,0.00,0.00,0.00),('1','57','447','257373',4898990,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257373',4898991,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257374',4898992,'1190','173',787480.31,787480.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257374',4898993,'1191','173',76901.37,76901.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257374',4898994,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257374',4898995,'1193','173',740853.56,741283.90,430.34,81764.60,0.00,0.00,0.00,0.00,0.00),('1','57','447','257374',4898996,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257374',4898997,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257375',4898998,'1190','173',787480.31,787480.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257375',4898999,'1191','173',76901.37,76901.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257375',4899000,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257375',4899001,'1193','173',741283.90,741483.38,199.48,37901.20,0.00,0.00,0.00,0.00,0.00),('1','57','447','257375',4899002,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257375',4899003,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257376',4899004,'1190','173',787480.31,787480.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257376',4899005,'1191','173',76901.37,76901.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257376',4899006,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257376',4899007,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257376',4899008,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257376',4899009,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257377',4899010,'1190','173',787480.31,788161.45,681.14,166879.30,0.00,0.00,0.00,0.00,0.00),('1','57','445','257377',4899011,'1191','173',76901.37,79585.47,2684.10,657604.50,0.00,0.00,0.00,0.00,0.00),('1','57','446','257377',4899012,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257377',4899013,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257377',4899014,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257377',4899015,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257378',4899016,'1190','173',788161.45,793388.00,5226.55,1280504.75,0.00,0.00,0.00,0.00,0.00),('1','57','445','257378',4899017,'1191','173',79585.47,80299.68,714.21,174981.45,0.00,0.00,0.00,0.00,0.00),('1','57','446','257378',4899018,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257378',4899019,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257378',4899020,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257378',4899021,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257379',4899022,'1190','173',793388.00,793748.93,360.93,88427.85,0.00,0.00,0.00,0.00,0.00),('1','57','445','257379',4899023,'1191','173',80299.68,80656.17,356.49,87340.05,0.00,0.00,0.00,0.00,0.00),('1','57','446','257379',4899024,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257379',4899025,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257379',4899026,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257379',4899027,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257380',4899028,'1190','173',793748.93,794664.50,915.57,224314.65,0.00,0.00,0.00,0.00,0.00),('1','57','445','257380',4899029,'1191','173',80656.17,81416.36,760.19,186246.55,0.00,0.00,0.00,0.00,0.00),('1','57','446','257380',4899030,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257380',4899031,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257380',4899032,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257380',4899033,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257381',4899034,'1190','173',794664.50,797241.84,2577.34,631448.30,0.00,0.00,0.00,0.00,0.00),('1','57','445','257381',4899035,'1191','173',81416.36,81967.61,551.25,135056.25,0.00,0.00,0.00,0.00,0.00),('1','57','446','257381',4899036,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257381',4899037,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257381',4899038,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257381',4899039,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257382',4899040,'1190','173',797241.84,797508.90,267.06,65429.70,0.00,0.00,0.00,0.00,0.00),('1','57','445','257382',4899041,'1191','173',81967.61,82132.79,165.18,40469.10,0.00,0.00,0.00,0.00,0.00),('1','57','446','257382',4899042,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257382',4899043,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257382',4899044,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257382',4899045,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257383',4899046,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257383',4899047,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257383',4899048,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257383',4899049,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257383',4899050,'1198','174',378189.15,378189.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257383',4899051,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257384',4899052,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257384',4899053,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257384',4899054,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257384',4899055,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257384',4899056,'1198','174',378189.15,379150.57,961.42,855663.80,0.00,0.00,0.00,0.00,0.00),('1','57','468','257384',4899057,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257385',4899058,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257385',4899059,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257385',4899060,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257385',4899061,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257385',4899062,'1198','174',379150.57,379850.57,700.00,623000.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257385',4899063,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257386',4899064,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257386',4899065,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257386',4899066,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257386',4899067,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257386',4899068,'1198','174',379850.57,380628.38,777.81,692250.90,0.00,0.00,0.00,0.00,0.00),('1','57','468','257386',4899069,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257387',4899070,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257387',4899071,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257387',4899072,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257387',4899073,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257387',4899074,'1198','174',380628.38,380765.93,137.55,122419.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','257387',4899075,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257388',4899076,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257388',4899077,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257388',4899078,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257388',4899079,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257388',4899080,'1198','174',380765.93,380845.93,80.00,71200.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257388',4899081,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257389',4899082,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257389',4899083,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257389',4899084,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257389',4899085,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257389',4899086,'1198','174',380845.93,380858.96,13.03,11596.70,0.00,0.00,0.00,0.00,0.00),('1','57','468','257389',4899087,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257390',4899088,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257390',4899089,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257390',4899090,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257390',4899091,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257390',4899092,'1198','174',380858.96,381668.68,809.72,720650.80,0.00,0.00,0.00,0.00,0.00),('1','57','468','257390',4899093,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257391',4899094,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257391',4899095,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257391',4899096,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257391',4899097,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257391',4899098,'1198','174',381668.68,381743.68,75.00,66750.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257391',4899099,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257392',4899100,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257392',4899101,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257392',4899102,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257392',4899103,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257392',4899104,'1198','174',381743.68,382235.37,491.69,437604.10,0.00,0.00,0.00,0.00,0.00),('1','57','468','257392',4899105,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257393',4899106,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257393',4899107,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257393',4899108,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257393',4899109,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257393',4899110,'1198','174',382235.37,382415.37,180.00,160200.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257393',4899111,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257394',4899112,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257394',4899113,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257394',4899114,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257394',4899115,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257394',4899116,'1198','174',382415.37,383268.31,852.94,759116.60,0.00,0.00,0.00,0.00,0.00),('1','57','468','257394',4899117,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257395',4899118,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257395',4899119,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257395',4899120,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257395',4899121,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257395',4899122,'1198','174',383268.31,383790.56,522.25,464802.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','257395',4899123,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257396',4899124,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257396',4899125,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257396',4899126,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257396',4899127,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257396',4899128,'1198','174',383790.56,384104.68,314.12,279566.80,0.00,0.00,0.00,0.00,0.00),('1','57','468','257396',4899129,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257397',4899130,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257397',4899131,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257397',4899132,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257397',4899133,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257397',4899134,'1198','174',384104.68,384170.30,65.62,58401.80,0.00,0.00,0.00,0.00,0.00),('1','57','468','257397',4899135,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257398',4899136,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257398',4899137,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257398',4899138,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257398',4899139,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257398',4899140,'1198','174',384170.30,384375.51,205.21,182636.90,0.00,0.00,0.00,0.00,0.00),('1','57','468','257398',4899141,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257399',4899142,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257399',4899143,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257399',4899144,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257399',4899145,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257399',4899146,'1198','174',384375.51,384472.83,97.32,86614.80,0.00,0.00,0.00,0.00,0.00),('1','57','468','257399',4899147,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257400',4899148,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257400',4899149,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257400',4899150,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257400',4899151,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257400',4899152,'1198','174',384472.83,385467.13,994.30,884927.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257400',4899153,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257401',4899154,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257401',4899155,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257401',4899156,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257401',4899157,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257401',4899158,'1198','174',385467.13,385469.38,2.25,2002.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','257401',4899159,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257402',4899160,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257402',4899161,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257402',4899162,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257402',4899163,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257402',4899164,'1198','174',385469.38,385670.50,201.12,178996.80,0.00,0.00,0.00,0.00,0.00),('1','57','468','257402',4899165,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257403',4899166,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257403',4899167,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257403',4899168,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257403',4899169,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257403',4899170,'1198','174',385670.50,385720.50,50.00,44500.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257403',4899171,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257404',4899172,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257404',4899173,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257404',4899174,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257404',4899175,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257404',4899176,'1198','174',385720.50,386031.96,311.46,277199.40,0.00,0.00,0.00,0.00,0.00),('1','57','468','257404',4899177,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257405',4899178,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257405',4899179,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257405',4899180,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257405',4899181,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257405',4899182,'1198','174',386031.96,387668.22,1636.26,1456271.40,0.00,0.00,0.00,0.00,0.00),('1','57','468','257405',4899183,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257406',4899184,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257406',4899185,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257406',4899186,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257406',4899187,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257406',4899188,'1198','174',387668.22,388035.08,366.86,326505.40,0.00,0.00,0.00,0.00,0.00),('1','57','468','257406',4899189,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257407',4899190,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257407',4899191,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257407',4899192,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257407',4899193,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257407',4899194,'1198','174',388035.08,388236.68,201.60,179424.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257407',4899195,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257408',4899196,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257408',4899197,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257408',4899198,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257408',4899199,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257408',4899200,'1198','174',388236.68,388422.84,186.16,165682.40,0.00,0.00,0.00,0.00,0.00),('1','57','468','257408',4899201,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257409',4899202,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257409',4899203,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257409',4899204,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257409',4899205,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257409',4899206,'1198','174',388422.84,388714.65,291.81,259710.90,0.00,0.00,0.00,0.00,0.00),('1','57','468','257409',4899207,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257410',4899208,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257410',4899209,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257410',4899210,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257410',4899211,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257410',4899212,'1198','174',388714.65,390057.50,1342.85,1195136.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','257410',4899213,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257411',4899214,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257411',4899215,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257411',4899216,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257411',4899217,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257411',4899218,'1198','174',390057.50,390114.41,56.91,50649.90,0.00,0.00,0.00,0.00,0.00),('1','57','468','257411',4899219,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257412',4899220,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257412',4899221,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257412',4899222,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257412',4899223,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257412',4899224,'1198','174',390114.41,390303.29,188.88,168103.20,0.00,0.00,0.00,0.00,0.00),('1','57','468','257412',4899225,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257413',4899226,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257413',4899227,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257413',4899228,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257413',4899229,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257413',4899230,'1198','174',390303.29,390858.18,554.89,493852.10,0.00,0.00,0.00,0.00,0.00),('1','57','468','257413',4899231,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257414',4899232,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257414',4899233,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257414',4899234,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257414',4899235,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257414',4899236,'1198','174',390858.18,391161.96,303.78,270364.20,0.00,0.00,0.00,0.00,0.00),('1','57','468','257414',4899237,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257415',4899238,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257415',4899239,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257415',4899240,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257415',4899241,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257415',4899242,'1198','174',391161.96,391478.99,317.03,282156.70,0.00,0.00,0.00,0.00,0.00),('1','57','468','257415',4899243,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257416',4899244,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257416',4899245,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257416',4899246,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257416',4899247,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257416',4899248,'1198','174',391478.99,392753.39,1274.40,1134216.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257416',4899249,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257417',4899250,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257417',4899251,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257417',4899252,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257417',4899253,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257417',4899254,'1198','174',392753.39,392871.01,117.62,104681.80,0.00,0.00,0.00,0.00,0.00),('1','57','468','257417',4899255,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257418',4899256,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257418',4899257,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257418',4899258,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257418',4899259,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257418',4899260,'1198','174',392871.01,393623.21,752.20,669458.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257418',4899261,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257419',4899262,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257419',4899263,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257419',4899264,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257419',4899265,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257419',4899266,'1198','174',393623.21,394509.95,886.74,789198.60,0.00,0.00,0.00,0.00,0.00),('1','57','468','257419',4899267,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257420',4899268,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257420',4899269,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257420',4899270,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257420',4899271,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257420',4899272,'1198','174',394509.95,394851.76,341.81,304210.90,0.00,0.00,0.00,0.00,0.00),('1','57','468','257420',4899273,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257421',4899274,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257421',4899275,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257421',4899276,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257421',4899277,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257421',4899278,'1198','174',394851.76,395389.38,537.62,478481.80,0.00,0.00,0.00,0.00,0.00),('1','57','468','257421',4899279,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257422',4899280,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257422',4899281,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257422',4899282,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257422',4899283,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257422',4899284,'1198','174',395389.38,395963.95,574.57,511367.30,0.00,0.00,0.00,0.00,0.00),('1','57','468','257422',4899285,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257423',4899286,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257423',4899287,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257423',4899288,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257423',4899289,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257423',4899290,'1198','174',395963.95,396365.30,401.35,357201.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','257423',4899291,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257424',4899292,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257424',4899293,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257424',4899294,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257424',4899295,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257424',4899296,'1198','174',396365.30,396687.34,322.04,286615.60,0.00,0.00,0.00,0.00,0.00),('1','57','468','257424',4899297,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257425',4899298,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257425',4899299,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257425',4899300,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257425',4899301,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257425',4899302,'1198','174',396687.34,397038.58,351.24,312603.60,0.00,0.00,0.00,0.00,0.00),('1','57','468','257425',4899303,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257426',4899304,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257426',4899305,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257426',4899306,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257426',4899307,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257426',4899308,'1198','174',397038.58,397400.26,361.68,321895.20,0.00,0.00,0.00,0.00,0.00),('1','57','468','257426',4899309,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257427',4899310,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257427',4899311,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257427',4899312,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257427',4899313,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257427',4899314,'1198','174',397400.26,397453.31,53.05,47214.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','257427',4899315,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257428',4899316,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257428',4899317,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257428',4899318,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257428',4899319,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257428',4899320,'1198','174',397453.31,397718.09,264.78,235654.20,0.00,0.00,0.00,0.00,0.00),('1','57','468','257428',4899321,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257429',4899322,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257429',4899323,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257429',4899324,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257429',4899325,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257429',4899326,'1198','174',397718.09,398265.65,547.56,487328.40,0.00,0.00,0.00,0.00,0.00),('1','57','468','257429',4899327,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257430',4899328,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257430',4899329,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257430',4899330,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257430',4899331,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257430',4899332,'1198','174',398265.65,398290.65,25.00,22250.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257430',4899333,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257431',4899334,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257431',4899335,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257431',4899336,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257431',4899337,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257431',4899338,'1198','174',398290.65,398292.22,1.57,1397.30,0.00,0.00,0.00,0.00,0.00),('1','57','468','257431',4899339,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257432',4899340,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257432',4899341,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257432',4899342,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257432',4899343,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257432',4899344,'1198','174',398292.22,398325.01,32.79,29183.10,0.00,0.00,0.00,0.00,0.00),('1','57','468','257432',4899345,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257433',4899346,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257433',4899347,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257433',4899348,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257433',4899349,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257433',4899350,'1198','174',398325.01,398412.07,87.06,77483.40,0.00,0.00,0.00,0.00,0.00),('1','57','468','257433',4899351,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257434',4899352,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257434',4899353,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257434',4899354,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257434',4899355,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257434',4899356,'1198','174',398412.07,398742.66,330.59,287613.30,0.00,0.00,0.00,0.00,0.00),('1','57','468','257434',4899357,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257435',4899358,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257435',4899359,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257435',4899360,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257435',4899361,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257435',4899362,'1198','174',398742.66,399815.11,1072.45,933031.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','257435',4899363,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257436',4899364,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257436',4899365,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257436',4899366,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257436',4899367,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257436',4899368,'1198','174',399815.11,400720.57,905.46,787750.20,0.00,0.00,0.00,0.00,0.00),('1','57','468','257436',4899369,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257437',4899370,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257437',4899371,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257437',4899372,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257437',4899373,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257437',4899374,'1198','174',400720.57,400720.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257437',4899375,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257438',4899376,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257438',4899377,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257438',4899378,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257438',4899379,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257438',4899380,'1198','174',400720.57,400747.48,26.91,23411.70,0.00,0.00,0.00,0.00,0.00),('1','57','468','257438',4899381,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257439',4899382,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257439',4899383,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257439',4899384,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257439',4899385,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257439',4899386,'1198','174',400747.48,400864.69,117.21,101972.70,0.00,0.00,0.00,0.00,0.00),('1','57','468','257439',4899387,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257440',4899388,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257440',4899389,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257440',4899390,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257440',4899391,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257440',4899392,'1198','174',400864.69,401231.77,367.08,319359.60,0.00,0.00,0.00,0.00,0.00),('1','57','468','257440',4899393,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257441',4899394,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257441',4899395,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257441',4899396,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257441',4899397,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257441',4899398,'1198','174',401231.77,401231.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257441',4899399,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257442',4899400,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257442',4899401,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257442',4899402,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257442',4899403,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257442',4899404,'1198','174',401231.77,401290.97,59.20,51504.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257442',4899405,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257443',4899406,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257443',4899407,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257443',4899408,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257443',4899409,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257443',4899410,'1198','174',401290.97,401986.54,695.57,605145.90,0.00,0.00,0.00,0.00,0.00),('1','57','468','257443',4899411,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257444',4899412,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257444',4899413,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257444',4899414,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257444',4899415,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257444',4899416,'1198','174',401986.54,402939.41,952.87,828996.90,0.00,0.00,0.00,0.00,0.00),('1','57','468','257444',4899417,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257445',4899418,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257445',4899419,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257445',4899420,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257445',4899421,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257445',4899422,'1198','174',402939.41,404860.02,1920.61,1670930.70,0.00,0.00,0.00,0.00,0.00),('1','57','468','257445',4899423,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257446',4899424,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257446',4899425,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257446',4899426,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257446',4899427,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257446',4899428,'1198','174',404860.02,404941.17,81.15,70600.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','257446',4899429,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257447',4899430,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257447',4899431,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257447',4899432,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257447',4899433,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257447',4899434,'1198','174',404941.17,405351.17,410.00,356700.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257447',4899435,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257448',4899436,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257448',4899437,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257448',4899438,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257448',4899439,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257448',4899440,'1198','174',405351.17,405424.96,73.79,64197.30,0.00,0.00,0.00,0.00,0.00),('1','57','468','257448',4899441,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257449',4899442,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257449',4899443,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257449',4899444,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257449',4899445,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257449',4899446,'1198','174',405424.96,405424.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257449',4899447,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257450',4899448,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257450',4899449,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257450',4899450,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257450',4899451,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257450',4899452,'1198','174',405424.96,405580.71,155.75,135502.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','257450',4899453,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257451',4899454,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257451',4899455,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257451',4899456,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257451',4899457,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257451',4899458,'1198','174',405580.71,405682.53,101.82,88583.40,0.00,0.00,0.00,0.00,0.00),('1','57','468','257451',4899459,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257452',4899460,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257452',4899461,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257452',4899462,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257452',4899463,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257452',4899464,'1198','174',405682.53,405728.79,46.26,40246.20,0.00,0.00,0.00,0.00,0.00),('1','57','468','257452',4899465,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257453',4899466,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257453',4899467,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257453',4899468,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257453',4899469,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257453',4899470,'1198','174',405728.79,405735.97,7.18,6246.60,0.00,0.00,0.00,0.00,0.00),('1','57','468','257453',4899471,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257454',4899472,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257454',4899473,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257454',4899474,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257454',4899475,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257454',4899476,'1198','174',405735.97,406500.81,764.84,665410.80,0.00,0.00,0.00,0.00,0.00),('1','57','468','257454',4899477,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257455',4899478,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257455',4899479,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257455',4899480,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257455',4899481,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257455',4899482,'1198','174',406500.81,406540.59,39.78,34608.60,0.00,0.00,0.00,0.00,0.00),('1','57','468','257455',4899483,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257456',4899484,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257456',4899485,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257456',4899486,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257456',4899487,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257456',4899488,'1198','174',406540.59,407972.82,1432.23,1246040.10,0.00,0.00,0.00,0.00,0.00),('1','57','468','257456',4899489,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257457',4899490,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257457',4899491,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257457',4899492,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257457',4899493,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257457',4899494,'1198','174',407972.82,408014.88,42.06,36592.20,0.00,0.00,0.00,0.00,0.00),('1','57','468','257457',4899495,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257458',4899496,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257458',4899497,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257458',4899498,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257458',4899499,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257458',4899500,'1198','174',408014.88,409054.42,1039.54,904399.80,0.00,0.00,0.00,0.00,0.00),('1','57','468','257458',4899501,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257459',4899502,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257459',4899503,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257459',4899504,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257459',4899505,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257459',4899506,'1198','174',409054.42,409070.98,16.56,14407.20,0.00,0.00,0.00,0.00,0.00),('1','57','468','257459',4899507,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257460',4899508,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257460',4899509,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257460',4899510,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257460',4899511,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257460',4899512,'1198','174',409070.98,409276.12,205.14,178471.80,0.00,0.00,0.00,0.00,0.00),('1','57','468','257460',4899513,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257461',4899514,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257461',4899515,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257461',4899516,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257461',4899517,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257461',4899518,'1198','174',409276.12,409380.55,104.43,90854.10,0.00,0.00,0.00,0.00,0.00),('1','57','468','257461',4899519,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257462',4899520,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257462',4899521,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257462',4899522,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257462',4899523,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257462',4899524,'1198','174',409380.55,409407.80,27.25,23707.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','257462',4899525,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257463',4899526,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257463',4899527,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257463',4899528,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257463',4899529,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257463',4899530,'1198','174',409407.80,409407.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257463',4899531,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257464',4899532,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257464',4899533,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257464',4899534,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257464',4899535,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257464',4899536,'1198','174',409407.80,409465.85,58.05,50503.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','257464',4899537,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257465',4899538,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257465',4899539,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257465',4899540,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257465',4899541,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257465',4899542,'1198','174',409465.85,409577.00,111.15,96700.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','257465',4899543,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257466',4899544,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257466',4899545,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257466',4899546,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257466',4899547,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257466',4899548,'1198','174',409577.00,409577.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257466',4899549,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257467',4899550,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257467',4899551,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257467',4899552,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257467',4899553,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257467',4899554,'1198','174',409577.00,410107.86,530.86,461848.20,0.00,0.00,0.00,0.00,0.00),('1','57','468','257467',4899555,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257468',4899556,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257468',4899557,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257468',4899558,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257468',4899559,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257468',4899560,'1198','174',410107.86,410257.10,149.24,129838.80,0.00,0.00,0.00,0.00,0.00),('1','57','468','257468',4899561,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257469',4899562,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257469',4899563,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257469',4899564,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257469',4899565,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257469',4899566,'1198','174',410257.10,410280.79,23.69,20610.30,0.00,0.00,0.00,0.00,0.00),('1','57','468','257469',4899567,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257470',4899568,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257470',4899569,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257470',4899570,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257470',4899571,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257470',4899572,'1198','174',410280.79,410461.44,180.65,157165.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','257470',4899573,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257471',4899574,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257471',4899575,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257471',4899576,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257471',4899577,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257471',4899578,'1198','174',410461.44,410461.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257471',4899579,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257472',4899580,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257472',4899581,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257472',4899582,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257472',4899583,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257472',4899584,'1198','174',410461.44,410474.02,12.58,10944.60,0.00,0.00,0.00,0.00,0.00),('1','57','468','257472',4899585,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257473',4899586,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257473',4899587,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257473',4899588,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257473',4899589,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257473',4899590,'1198','174',410474.02,410759.48,285.46,248350.20,0.00,0.00,0.00,0.00,0.00),('1','57','468','257473',4899591,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257474',4899592,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257474',4899593,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257474',4899594,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257474',4899595,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257474',4899596,'1198','174',410759.48,410831.79,72.31,62909.70,0.00,0.00,0.00,0.00,0.00),('1','57','468','257474',4899597,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257475',4899598,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257475',4899599,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257475',4899600,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257475',4899601,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257475',4899602,'1198','174',410831.79,411131.37,299.58,260634.60,0.00,0.00,0.00,0.00,0.00),('1','57','468','257475',4899603,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257476',4899604,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257476',4899605,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257476',4899606,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257476',4899607,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257476',4899608,'1198','174',411131.37,411427.98,296.61,258050.70,0.00,0.00,0.00,0.00,0.00),('1','57','468','257476',4899609,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257477',4899610,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257477',4899611,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257477',4899612,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257477',4899613,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257477',4899614,'1198','174',411427.98,411534.73,106.75,90737.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','257477',4899615,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257478',4899616,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257478',4899617,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257478',4899618,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257478',4899619,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257478',4899620,'1198','174',411534.73,412117.67,582.94,495499.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257478',4899621,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257479',4899622,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257479',4899623,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257479',4899624,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257479',4899625,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257479',4899626,'1198','174',412117.67,412332.11,214.44,182274.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257479',4899627,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257480',4899628,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257480',4899629,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257480',4899630,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257480',4899631,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257480',4899632,'1198','174',412332.11,412672.93,340.82,289697.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257480',4899633,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257481',4899634,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257481',4899635,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257481',4899636,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257481',4899637,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257481',4899638,'1198','174',412672.93,412690.45,17.52,14541.60,0.00,0.00,0.00,0.00,0.00),('1','57','468','257481',4899639,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257482',4899640,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257482',4899641,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257482',4899642,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257482',4899643,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257482',4899644,'1198','174',412690.45,413421.40,730.95,606688.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','257482',4899645,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257483',4899646,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257483',4899647,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257483',4899648,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257483',4899649,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257483',4899650,'1198','174',413421.40,413480.52,59.12,49069.60,0.00,0.00,0.00,0.00,0.00),('1','57','468','257483',4899651,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257484',4899652,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257484',4899653,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257484',4899654,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257484',4899655,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257484',4899656,'1198','174',413480.52,413613.01,132.49,109966.70,0.00,0.00,0.00,0.00,0.00),('1','57','468','257484',4899657,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257485',4899658,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257485',4899659,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257485',4899660,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257485',4899661,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257485',4899662,'1198','174',413613.01,413613.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257485',4899663,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257486',4899664,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257486',4899665,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257486',4899666,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257486',4899667,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257486',4899668,'1198','174',413613.01,414244.56,631.55,524186.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','257486',4899669,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257487',4899670,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257487',4899671,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257487',4899672,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257487',4899673,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257487',4899674,'1198','174',414244.56,414382.56,138.00,114540.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257487',4899675,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257488',4899676,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257488',4899677,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257488',4899678,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257488',4899679,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257488',4899680,'1198','174',414382.56,414707.51,324.95,269708.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','257488',4899681,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257489',4899682,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257489',4899683,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257489',4899684,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257489',4899685,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257489',4899686,'1198','174',414707.51,415131.71,424.20,352086.00,0.00,0.00,0.00,0.00,0.00),('1','57','468','257489',4899687,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257490',4899688,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257490',4899689,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257490',4899690,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257490',4899691,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257490',4899692,'1198','174',415131.71,416187.66,1055.95,876438.50,0.00,0.00,0.00,0.00,0.00),('1','57','468','257490',4899693,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257491',4899694,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257491',4899695,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257491',4899696,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257491',4899697,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257491',4899698,'1198','174',416187.66,416415.90,228.24,189439.20,0.00,0.00,0.00,0.00,0.00),('1','57','468','257491',4899699,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257492',4899700,'1190','173',797508.90,797508.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','445','257492',4899701,'1191','173',82132.79,82132.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257492',4899702,'1192','173',109021.93,109021.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','446','257492',4899703,'1193','173',741483.38,741483.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','57','447','257492',4899704,'1198','174',416415.90,416560.88,144.98,120333.40,0.00,0.00,0.00,0.00,0.00),('1','57','468','257492',4899705,'1239','174',589933.53,589933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=729764 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','57','240528','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,685764),('1','57','240528','174',190.00,185.00,0.00,0.00,0.00,0.00,0.00,685765),('1','57','240528','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,685766),('1','57','240535','173',165.00,165.00,445.97,0.00,0.00,0.00,0.00,685782),('1','57','240535','174',190.00,185.00,0.00,0.00,0.00,0.00,0.00,685783),('1','57','240535','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,685784),('1','57','240575','173',165.00,165.00,1052.81,0.00,0.00,0.00,0.00,685890),('1','57','240575','174',190.00,185.00,0.00,0.00,0.00,0.00,0.00,685891),('1','57','240575','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,685892),('1','57','240579','173',165.00,165.00,4254.37,0.00,0.00,0.00,0.00,685902),('1','57','240579','174',190.00,185.00,0.00,0.00,0.00,0.00,0.00,685903),('1','57','240579','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,685904),('1','57','240582','173',165.00,165.00,1332.30,0.00,0.00,0.00,0.00,685911),('1','57','240582','174',190.00,185.00,0.00,0.00,0.00,0.00,0.00,685912),('1','57','240582','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,685913),('1','57','240584','173',165.00,165.00,1953.61,0.00,0.00,0.00,0.00,685917),('1','57','240584','174',190.00,185.00,0.00,0.00,0.00,0.00,0.00,685918),('1','57','240584','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,685919),('1','57','240585','173',165.00,165.00,1471.84,0.00,0.00,0.00,0.00,685920),('1','57','240585','174',190.00,185.00,0.00,0.00,0.00,0.00,0.00,685921),('1','57','240585','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,685922),('1','57','240586','173',165.00,165.00,3574.99,0.00,0.00,0.00,0.00,685923),('1','57','240586','174',190.00,185.00,0.00,0.00,0.00,0.00,0.00,685924),('1','57','240586','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,685925),('1','57','240592','173',165.00,165.00,2212.05,0.00,0.00,0.00,0.00,685941),('1','57','240592','174',190.00,185.00,0.00,0.00,0.00,0.00,0.00,685942),('1','57','240592','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,685943),('1','57','240812','173',165.00,165.00,2302.00,0.00,0.00,0.00,0.00,686459),('1','57','240812','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,686460),('1','57','240812','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,686461),('1','57','240876','173',165.00,165.00,2234.56,0.00,0.00,0.00,0.00,686653),('1','57','240876','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,686654),('1','57','240876','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,686655),('1','57','241137','173',165.00,165.00,2406.24,0.00,0.00,0.00,0.00,687344),('1','57','241137','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,687345),('1','57','241137','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,687346),('1','57','241326','173',165.00,165.00,1870.53,0.00,0.00,0.00,0.00,687830),('1','57','241326','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,687831),('1','57','241326','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,687832),('1','57','241419','173',165.00,165.00,1994.76,0.00,0.00,0.00,0.00,688095),('1','57','241419','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,688096),('1','57','241419','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,688097),('1','57','241422','173',165.00,165.00,2106.37,0.00,0.00,0.00,0.00,688104),('1','57','241422','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,688105),('1','57','241422','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,688106),('1','57','241662','173',165.00,165.00,856.48,0.00,0.00,0.00,0.00,688735),('1','57','241662','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,688736),('1','57','241662','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,688737),('1','57','242540','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691004),('1','57','242540','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,691005),('1','57','242540','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,691006),('1','57','244179','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695264),('1','57','244179','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,695265),('1','57','244179','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,695266),('1','57','244249','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695466),('1','57','244249','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,695467),('1','57','244249','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,695468),('1','57','244392','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695819),('1','57','244392','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,695820),('1','57','244392','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,695821),('1','57','244676','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,696567),('1','57','244676','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,696568),('1','57','244676','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,696569),('1','57','244691','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,696608),('1','57','244691','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,696609),('1','57','244691','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,696610),('1','57','244940','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,697264),('1','57','244940','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,697265),('1','57','244940','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,697266),('1','57','245833','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699551),('1','57','245833','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699552),('1','57','245833','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699553),('1','57','245835','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699556),('1','57','245835','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699557),('1','57','245835','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699558),('1','57','245836','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699559),('1','57','245836','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699560),('1','57','245836','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699561),('1','57','245839','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699568),('1','57','245839','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699569),('1','57','245839','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699570),('1','57','245841','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699573),('1','57','245841','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699574),('1','57','245841','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699575),('1','57','245842','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699576),('1','57','245842','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699577),('1','57','245842','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699578),('1','57','245843','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699579),('1','57','245843','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699580),('1','57','245843','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699581),('1','57','245845','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699585),('1','57','245845','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699586),('1','57','245845','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699587),('1','57','245846','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699588),('1','57','245846','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699589),('1','57','245846','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699590),('1','57','245848','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699595),('1','57','245848','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699596),('1','57','245848','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699597),('1','57','245850','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699601),('1','57','245850','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699602),('1','57','245850','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699603),('1','57','245851','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699604),('1','57','245851','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699605),('1','57','245851','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699606),('1','57','245852','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699607),('1','57','245852','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699608),('1','57','245852','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699609),('1','57','245853','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699610),('1','57','245853','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699611),('1','57','245853','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699612),('1','57','245854','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699613),('1','57','245854','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699614),('1','57','245854','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699615),('1','57','245855','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699616),('1','57','245855','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699617),('1','57','245855','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699618),('1','57','245856','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699619),('1','57','245856','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699620),('1','57','245856','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699621),('1','57','245857','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699622),('1','57','245857','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699623),('1','57','245857','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699624),('1','57','245859','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699626),('1','57','245859','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699627),('1','57','245859','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699628),('1','57','245860','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699629),('1','57','245860','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699630),('1','57','245860','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699631),('1','57','245861','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699632),('1','57','245861','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699633),('1','57','245861','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699634),('1','57','245862','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699635),('1','57','245862','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699636),('1','57','245862','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699637),('1','57','245864','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699641),('1','57','245864','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699642),('1','57','245864','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699643),('1','57','245865','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699644),('1','57','245865','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699645),('1','57','245865','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699646),('1','57','245867','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699650),('1','57','245867','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699651),('1','57','245867','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699652),('1','57','245868','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699653),('1','57','245868','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699654),('1','57','245868','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699655),('1','57','245869','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699656),('1','57','245869','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699657),('1','57','245869','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699658),('1','57','245870','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699659),('1','57','245870','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699660),('1','57','245870','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699661),('1','57','245871','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699662),('1','57','245871','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699663),('1','57','245871','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699664),('1','57','245872','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699665),('1','57','245872','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,699666),('1','57','245872','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,699667),('1','57','247028','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702653),('1','57','247028','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,702654),('1','57','247028','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,702655),('1','57','247030','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702658),('1','57','247030','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,702659),('1','57','247030','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,702660),('1','57','247031','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702661),('1','57','247031','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,702662),('1','57','247031','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,702663),('1','57','247032','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702664),('1','57','247032','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,702665),('1','57','247032','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,702666),('1','57','247034','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702668),('1','57','247034','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,702669),('1','57','247034','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,702670),('1','57','247035','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702671),('1','57','247035','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,702672),('1','57','247035','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,702673),('1','57','247036','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702674),('1','57','247036','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,702675),('1','57','247036','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,702676),('1','57','247038','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702680),('1','57','247038','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,702681),('1','57','247038','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,702682),('1','57','247039','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702683),('1','57','247039','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,702684),('1','57','247039','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,702685),('1','57','247040','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702686),('1','57','247040','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,702687),('1','57','247040','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,702688),('1','57','248554','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706607),('1','57','248554','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,706608),('1','57','248554','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,706609),('1','57','248555','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706610),('1','57','248555','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,706611),('1','57','248555','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,706612),('1','57','248556','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706613),('1','57','248556','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,706614),('1','57','248556','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,706615),('1','57','248557','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706616),('1','57','248557','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,706617),('1','57','248557','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,706618),('1','57','248559','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706620),('1','57','248559','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,706621),('1','57','248559','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,706622),('1','57','248560','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706623),('1','57','248560','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,706624),('1','57','248560','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,706625),('1','57','248562','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706628),('1','57','248562','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,706629),('1','57','248562','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,706630),('1','57','248566','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706638),('1','57','248566','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,706639),('1','57','248566','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,706640),('1','57','248567','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706641),('1','57','248567','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,706642),('1','57','248567','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,706643),('1','57','248568','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706644),('1','57','248568','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,706645),('1','57','248568','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,706646),('1','57','248569','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706647),('1','57','248569','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,706648),('1','57','248569','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,706649),('1','57','248603','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706743),('1','57','248603','174',350.00,350.00,3509.97,0.00,0.00,0.00,0.00,706744),('1','57','248603','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,706745),('1','57','249475','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,708962),('1','57','249475','174',350.00,350.00,599.90,0.00,0.00,0.00,0.00,708963),('1','57','249475','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,708964),('1','57','249671','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709458),('1','57','249671','174',350.00,350.00,1779.18,0.00,0.00,0.00,0.00,709459),('1','57','249671','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,709460),('1','57','249679','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709479),('1','57','249679','174',350.00,350.00,93.00,0.00,0.00,0.00,0.00,709480),('1','57','249679','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,709481),('1','57','249683','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709491),('1','57','249683','174',350.00,350.00,4057.14,0.00,0.00,0.00,0.00,709492),('1','57','249683','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,709493),('1','57','249685','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709497),('1','57','249685','174',350.00,350.00,1477.45,0.00,0.00,0.00,0.00,709498),('1','57','249685','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,709499),('1','57','249691','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709514),('1','57','249691','174',350.00,350.00,3237.92,0.00,0.00,0.00,0.00,709515),('1','57','249691','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,709516),('1','57','249694','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709523),('1','57','249694','174',350.00,350.00,89.86,0.00,0.00,0.00,0.00,709524),('1','57','249694','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,709525),('1','57','249695','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709526),('1','57','249695','174',350.00,350.00,2349.39,0.00,0.00,0.00,0.00,709527),('1','57','249695','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,709528),('1','57','249697','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709532),('1','57','249697','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,709533),('1','57','249697','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,709534),('1','57','249996','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710308),('1','57','249996','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,710309),('1','57','249996','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,710310),('1','57','249999','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710317),('1','57','249999','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,710318),('1','57','249999','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,710319),('1','57','250001','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710323),('1','57','250001','174',350.00,350.00,1654.00,0.00,0.00,0.00,0.00,710324),('1','57','250001','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,710325),('1','57','250248','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710947),('1','57','250248','174',350.00,350.00,899.62,0.00,0.00,0.00,0.00,710948),('1','57','250248','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,710949),('1','57','250461','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711480),('1','57','250461','174',350.00,350.00,609.00,0.00,0.00,0.00,0.00,711481),('1','57','250461','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,711482),('1','57','250471','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711507),('1','57','250471','174',350.00,350.00,15.11,0.00,0.00,0.00,0.00,711508),('1','57','250471','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,711509),('1','57','251114','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,713159),('1','57','251114','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,713160),('1','57','251114','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,713161),('1','57','251124','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,713188),('1','57','251124','174',350.00,350.00,956.89,0.00,0.00,0.00,0.00,713189),('1','57','251124','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,713190),('1','57','251139','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,713230),('1','57','251139','174',350.00,350.00,985.43,0.00,0.00,0.00,0.00,713231),('1','57','251139','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,713232),('1','57','251157','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,713279),('1','57','251157','174',350.00,350.00,929.60,0.00,0.00,0.00,0.00,713280),('1','57','251157','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,713281),('1','57','251172','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,713321),('1','57','251172','174',350.00,350.00,1409.15,0.00,0.00,0.00,0.00,713322),('1','57','251172','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,713323),('1','57','251173','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,713324),('1','57','251173','174',350.00,350.00,1036.70,0.00,0.00,0.00,0.00,713325),('1','57','251173','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,713326),('1','57','251177','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,713336),('1','57','251177','174',350.00,350.00,1053.35,0.00,0.00,0.00,0.00,713337),('1','57','251177','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,713338),('1','57','251179','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,713342),('1','57','251179','174',350.00,350.00,741.39,0.00,0.00,0.00,0.00,713343),('1','57','251179','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,713344),('1','57','251348','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,713777),('1','57','251348','174',350.00,350.00,640.87,0.00,0.00,0.00,0.00,713778),('1','57','251348','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,713779),('1','57','251480','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,714146),('1','57','251480','174',350.00,350.00,500.00,0.00,0.00,0.00,0.00,714147),('1','57','251480','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,714148),('1','57','251852','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,715098),('1','57','251852','174',350.00,350.00,481.70,0.00,0.00,0.00,0.00,715099),('1','57','251852','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,715100),('1','57','251862','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,715121),('1','57','251862','174',350.00,350.00,1097.28,0.00,0.00,0.00,0.00,715122),('1','57','251862','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,715123),('1','57','251962','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,715406),('1','57','251962','174',350.00,350.00,187.62,0.00,0.00,0.00,0.00,715407),('1','57','251962','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,715408),('1','57','252568','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,716958),('1','57','252568','174',350.00,350.00,1209.73,0.00,0.00,0.00,0.00,716959),('1','57','252568','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,716960),('1','57','252572','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,716969),('1','57','252572','174',350.00,350.00,1196.50,0.00,0.00,0.00,0.00,716970),('1','57','252572','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,716971),('1','57','252576','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,716981),('1','57','252576','174',350.00,350.00,349.93,0.00,0.00,0.00,0.00,716982),('1','57','252576','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,716983),('1','57','252581','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,716994),('1','57','252581','174',350.00,350.00,2006.28,0.00,0.00,0.00,0.00,716995),('1','57','252581','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,716996),('1','57','252584','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,717003),('1','57','252584','174',350.00,350.00,2009.40,0.00,0.00,0.00,0.00,717004),('1','57','252584','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,717005),('1','57','252805','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,717570),('1','57','252805','174',350.00,350.00,1520.37,0.00,0.00,0.00,0.00,717571),('1','57','252805','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,717572),('1','57','252807','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,717574),('1','57','252807','174',350.00,350.00,605.86,0.00,0.00,0.00,0.00,717575),('1','57','252807','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,717576),('1','57','252897','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,717824),('1','57','252897','174',350.00,350.00,219.94,0.00,0.00,0.00,0.00,717825),('1','57','252897','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,717826),('1','57','252932','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,717923),('1','57','252932','174',350.00,350.00,1590.31,0.00,0.00,0.00,0.00,717924),('1','57','252932','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,717925),('1','57','253188','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718601),('1','57','253188','174',350.00,350.00,832.54,0.00,0.00,0.00,0.00,718602),('1','57','253188','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,718603),('1','57','253287','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718829),('1','57','253287','174',350.00,350.00,1575.60,0.00,0.00,0.00,0.00,718830),('1','57','253287','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,718831),('1','57','253299','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718865),('1','57','253299','174',350.00,350.00,1000.00,0.00,0.00,0.00,0.00,718866),('1','57','253299','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,718867),('1','57','253408','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,719159),('1','57','253408','174',350.00,350.00,954.00,0.00,0.00,0.00,0.00,719160),('1','57','253408','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,719161),('1','57','253613','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,719690),('1','57','253613','174',350.00,350.00,595.02,0.00,0.00,0.00,0.00,719691),('1','57','253613','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,719692),('1','57','253635','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,719746),('1','57','253635','174',350.00,350.00,548.00,0.00,0.00,0.00,0.00,719747),('1','57','253635','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,719748),('1','57','253813','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,720196),('1','57','253813','174',350.00,350.00,570.00,0.00,0.00,0.00,0.00,720197),('1','57','253813','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,720198),('1','57','253921','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,720500),('1','57','253921','174',350.00,350.00,624.91,0.00,0.00,0.00,0.00,720501),('1','57','253921','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,720502),('1','57','254107','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,720973),('1','57','254107','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,720974),('1','57','254107','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,720975),('1','57','254261','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721353),('1','57','254261','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,721354),('1','57','254261','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,721355),('1','57','254309','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721488),('1','57','254309','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,721489),('1','57','254309','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,721490),('1','57','254367','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721645),('1','57','254367','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,721646),('1','57','254367','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,721647),('1','57','254550','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722100),('1','57','254550','174',350.00,350.00,0.00,0.00,0.00,0.00,0.00,722101),('1','57','254550','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,722102),('1','57','254660','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722398),('1','57','254660','174',350.00,350.00,2202.91,0.00,0.00,0.00,0.00,722399),('1','57','254660','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,722400),('1','57','254866','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722916),('1','57','254866','174',350.00,350.00,463.65,0.00,0.00,0.00,0.00,722917),('1','57','254866','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,722918),('1','57','254912','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,723041),('1','57','254912','174',350.00,350.00,452.00,0.00,0.00,0.00,0.00,723042),('1','57','254912','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,723043),('1','57','255105','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,723529),('1','57','255105','174',350.00,350.00,1691.26,0.00,0.00,0.00,0.00,723530),('1','57','255105','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,723531),('1','57','255117','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,723557),('1','57','255117','174',350.00,350.00,3180.75,0.00,0.00,0.00,0.00,723558),('1','57','255117','175',190.00,190.00,0.00,0.00,0.00,0.00,0.00,723559),('1','57','255308','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724034),('1','57','255308','174',355.00,355.00,615.64,0.00,0.00,0.00,0.00,724035),('1','57','255308','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,724036),('1','57','255536','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724579),('1','57','255536','174',355.00,355.00,987.82,0.00,0.00,0.00,0.00,724580),('1','57','255536','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,724581),('1','57','255626','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724816),('1','57','255626','174',355.00,355.00,1056.39,0.00,0.00,0.00,0.00,724817),('1','57','255626','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,724818),('1','57','255681','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724965),('1','57','255681','174',355.00,355.00,1262.40,0.00,0.00,0.00,0.00,724966),('1','57','255681','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,724967),('1','57','255864','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725429),('1','57','255864','174',355.00,355.00,17.66,0.00,0.00,0.00,0.00,725430),('1','57','255864','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,725431),('1','57','255914','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725563),('1','57','255914','174',355.00,355.00,5557.22,0.00,0.00,0.00,0.00,725564),('1','57','255914','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,725565),('1','57','256112','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,726053),('1','57','256112','174',355.00,355.00,1128.70,0.00,0.00,0.00,0.00,726054),('1','57','256112','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,726055),('1','57','256122','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,726080),('1','57','256122','174',355.00,355.00,724.44,0.00,0.00,0.00,0.00,726081),('1','57','256122','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,726082),('1','57','256400','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,726785),('1','57','256400','174',355.00,360.00,1001.13,0.00,0.00,0.00,0.00,726786),('1','57','256400','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,726787),('1','57','256613','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727327),('1','57','256613','174',355.00,360.00,0.00,0.00,0.00,0.00,0.00,727328),('1','57','256613','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,727329),('1','57','256652','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727437),('1','57','256652','174',355.00,360.00,0.00,0.00,0.00,0.00,0.00,727438),('1','57','256652','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,727439),('1','57','256847','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727935),('1','57','256847','174',355.00,360.00,0.00,0.00,0.00,0.00,0.00,727936),('1','57','256847','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,727937),('1','57','257145','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728720),('1','57','257145','174',355.00,360.00,0.00,0.00,0.00,0.00,0.00,728721),('1','57','257145','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728722),('1','57','257146','174',355.00,365.00,0.00,0.00,0.00,0.00,0.00,728723),('1','57','257146','175',150.00,15.00,0.00,0.00,0.00,0.00,0.00,728724),('1','57','257146','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728725),('1','57','257147','174',355.00,360.00,0.00,0.00,0.00,0.00,0.00,728726),('1','57','257147','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728727),('1','57','257147','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728728),('1','57','257148','174',355.00,355.00,0.00,0.00,0.00,0.00,0.00,728729),('1','57','257148','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728730),('1','57','257148','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728731),('1','57','257149','174',355.00,355.00,0.00,0.00,0.00,0.00,0.00,728732),('1','57','257149','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728733),('1','57','257149','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728734),('1','57','257150','174',355.00,355.00,0.00,0.00,0.00,0.00,0.00,728735),('1','57','257150','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728736),('1','57','257150','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728737),('1','57','257151','174',355.00,355.00,0.00,0.00,0.00,0.00,0.00,728738),('1','57','257151','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728739),('1','57','257151','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728740),('1','57','257152','174',355.00,355.00,0.00,0.00,0.00,0.00,0.00,728741),('1','57','257152','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728742),('1','57','257152','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728743),('1','57','257153','174',355.00,355.00,0.00,0.00,0.00,0.00,0.00,728744),('1','57','257153','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728745),('1','57','257153','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728746),('1','57','257154','174',355.00,355.00,0.00,0.00,0.00,0.00,0.00,728747),('1','57','257154','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728748),('1','57','257154','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728749),('1','57','257155','174',355.00,355.00,0.00,0.00,0.00,0.00,0.00,728750),('1','57','257155','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728751),('1','57','257155','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728752),('1','57','257156','174',355.00,355.00,0.00,0.00,0.00,0.00,0.00,728753),('1','57','257156','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728754),('1','57','257156','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728755),('1','57','257157','174',355.00,355.00,0.00,0.00,0.00,0.00,0.00,728756),('1','57','257157','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728757),('1','57','257157','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728758),('1','57','257158','174',355.00,355.00,0.00,0.00,0.00,0.00,0.00,728759),('1','57','257158','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728760),('1','57','257158','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728761),('1','57','257159','174',355.00,355.00,0.00,0.00,0.00,0.00,0.00,728762),('1','57','257159','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728763),('1','57','257159','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728764),('1','57','257160','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728765),('1','57','257160','174',365.00,355.00,0.00,0.00,0.00,0.00,0.00,728766),('1','57','257160','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728767),('1','57','257161','174',365.00,365.00,1832.80,0.00,0.00,0.00,0.00,728768),('1','57','257161','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728769),('1','57','257161','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728770),('1','57','257162','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728771),('1','57','257162','174',365.00,355.00,3095.01,0.00,0.00,0.00,0.00,728772),('1','57','257162','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728773),('1','57','257163','174',380.00,380.00,1337.36,0.00,0.00,0.00,0.00,728774),('1','57','257163','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728775),('1','57','257163','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728776),('1','57','257164','174',380.00,380.00,1826.68,0.00,0.00,0.00,0.00,728777),('1','57','257164','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728778),('1','57','257164','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728779),('1','57','257165','174',380.00,380.00,1126.85,0.00,0.00,0.00,0.00,728780),('1','57','257165','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728781),('1','57','257165','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728782),('1','57','257166','174',380.00,380.00,618.69,0.00,0.00,0.00,0.00,728783),('1','57','257166','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728784),('1','57','257166','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728785),('1','57','257167','174',380.00,380.00,1837.37,0.00,0.00,0.00,0.00,728786),('1','57','257167','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728787),('1','57','257167','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728788),('1','57','257168','174',380.00,380.00,1430.08,0.00,0.00,0.00,0.00,728789),('1','57','257168','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728790),('1','57','257168','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728791),('1','57','257169','174',380.00,380.00,1833.85,0.00,0.00,0.00,0.00,728792),('1','57','257169','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728793),('1','57','257169','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728794),('1','57','257170','174',380.00,380.00,976.18,0.00,0.00,0.00,0.00,728795),('1','57','257170','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728796),('1','57','257170','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728797),('1','57','257171','174',380.00,380.00,4352.42,0.00,0.00,0.00,0.00,728798),('1','57','257171','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728799),('1','57','257171','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728800),('1','57','257172','174',390.00,390.00,0.00,0.00,0.00,0.00,0.00,728801),('1','57','257172','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728802),('1','57','257172','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728803),('1','57','257173','174',390.00,390.00,0.00,0.00,0.00,0.00,0.00,728804),('1','57','257173','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728805),('1','57','257173','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728806),('1','57','257174','174',390.00,390.00,0.00,0.00,0.00,0.00,0.00,728807),('1','57','257174','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728808),('1','57','257174','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728809),('1','57','257175','174',390.00,390.00,3224.77,0.00,0.00,0.00,0.00,728810),('1','57','257175','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728811),('1','57','257175','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728812),('1','57','257176','174',390.00,390.00,932.56,0.00,0.00,0.00,0.00,728813),('1','57','257176','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728814),('1','57','257176','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728815),('1','57','257177','174',390.00,390.00,1569.99,0.00,0.00,0.00,0.00,728816),('1','57','257177','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728817),('1','57','257177','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728818),('1','57','257178','174',390.00,390.00,630.84,0.00,0.00,0.00,0.00,728819),('1','57','257178','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728820),('1','57','257178','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728821),('1','57','257179','174',400.00,400.00,1302.21,0.00,0.00,0.00,0.00,728822),('1','57','257179','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728823),('1','57','257179','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728824),('1','57','257180','174',400.00,400.00,275.00,0.00,0.00,0.00,0.00,728825),('1','57','257180','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728826),('1','57','257180','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728827),('1','57','257181','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728828),('1','57','257181','174',400.00,400.00,3247.87,0.00,0.00,0.00,0.00,728829),('1','57','257181','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728830),('1','57','257182','174',400.00,400.00,1204.24,0.00,0.00,0.00,0.00,728831),('1','57','257182','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728832),('1','57','257182','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728833),('1','57','257183','174',400.00,400.00,995.76,0.00,0.00,0.00,0.00,728834),('1','57','257183','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728835),('1','57','257183','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728836),('1','57','257184','174',400.00,400.00,433.23,0.00,0.00,0.00,0.00,728837),('1','57','257184','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728838),('1','57','257184','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728839),('1','57','257185','174',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728840),('1','57','257185','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728841),('1','57','257185','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728842),('1','57','257186','174',400.00,410.00,0.00,0.00,0.00,0.00,0.00,728843),('1','57','257186','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728844),('1','57','257186','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728845),('1','57','257187','174',400.00,410.00,1367.12,0.00,0.00,0.00,0.00,728846),('1','57','257187','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728847),('1','57','257187','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728848),('1','57','257188','174',400.00,410.00,1017.08,0.00,0.00,0.00,0.00,728849),('1','57','257188','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728850),('1','57','257188','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728851),('1','57','257189','174',400.00,410.00,1826.69,0.00,0.00,0.00,0.00,728852),('1','57','257189','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728853),('1','57','257189','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728854),('1','57','257190','174',400.00,400.00,0.00,0.00,0.00,0.00,0.00,728855),('1','57','257190','175',150.00,150.00,0.00,0.00,0.00,0.00,0.00,728856),('1','57','257190','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728857),('1','57','257191','174',400.00,400.00,2.68,0.00,0.00,0.00,0.00,728858),('1','57','257191','175',410.00,410.00,0.00,0.00,0.00,0.00,0.00,728859),('1','57','257191','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728860),('1','57','257192','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728861),('1','57','257192','174',410.00,410.00,457.58,0.00,0.00,0.00,0.00,728862),('1','57','257192','175',410.00,410.00,0.00,0.00,0.00,0.00,0.00,728863),('1','57','257193','174',410.00,410.00,436.94,0.00,0.00,0.00,0.00,728864),('1','57','257193','175',410.00,410.00,0.00,0.00,0.00,0.00,0.00,728865),('1','57','257193','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728866),('1','57','257194','174',410.00,410.00,520.15,0.00,0.00,0.00,0.00,728867),('1','57','257194','175',410.00,410.00,0.00,0.00,0.00,0.00,0.00,728868),('1','57','257194','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728869),('1','57','257195','174',410.00,410.00,2149.00,0.00,0.00,0.00,0.00,728870),('1','57','257195','175',410.00,410.00,0.00,0.00,0.00,0.00,0.00,728871),('1','57','257195','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728872),('1','57','257196','174',410.00,410.00,202.49,0.00,0.00,0.00,0.00,728873),('1','57','257196','175',410.00,410.00,0.00,0.00,0.00,0.00,0.00,728874),('1','57','257196','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728875),('1','57','257197','174',410.00,410.00,4.15,0.00,0.00,0.00,0.00,728876),('1','57','257197','175',410.00,410.00,0.00,0.00,0.00,0.00,0.00,728877),('1','57','257197','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728878),('1','57','257198','174',410.00,410.00,1595.04,0.00,0.00,0.00,0.00,728879),('1','57','257198','175',410.00,410.00,0.00,0.00,0.00,0.00,0.00,728880),('1','57','257198','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728881),('1','57','257199','174',410.00,410.00,1930.76,0.00,0.00,0.00,0.00,728882),('1','57','257199','175',410.00,410.00,0.00,0.00,0.00,0.00,0.00,728883),('1','57','257199','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728884),('1','57','257200','174',410.00,410.00,954.00,0.00,0.00,0.00,0.00,728885),('1','57','257200','175',410.00,410.00,0.00,0.00,0.00,0.00,0.00,728886),('1','57','257200','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728887),('1','57','257201','174',410.00,410.00,55.41,0.00,0.00,0.00,0.00,728888),('1','57','257201','175',410.00,410.00,0.00,0.00,0.00,0.00,0.00,728889),('1','57','257201','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728890),('1','57','257202','174',410.00,410.00,2007.08,0.00,0.00,0.00,0.00,728891),('1','57','257202','175',410.00,410.00,0.00,0.00,0.00,0.00,0.00,728892),('1','57','257202','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728893),('1','57','257203','174',410.00,410.00,2420.67,0.00,0.00,0.00,0.00,728894),('1','57','257203','175',410.00,410.00,0.00,0.00,0.00,0.00,0.00,728895),('1','57','257203','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728896),('1','57','257204','174',410.00,410.00,1104.97,0.00,0.00,0.00,0.00,728897),('1','57','257204','175',410.00,410.00,0.00,0.00,0.00,0.00,0.00,728898),('1','57','257204','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728899),('1','57','257205','174',410.00,410.00,3615.01,0.00,0.00,0.00,0.00,728900),('1','57','257205','175',410.00,410.00,0.00,0.00,0.00,0.00,0.00,728901),('1','57','257205','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728902),('1','57','257206','174',410.00,410.00,785.73,0.00,0.00,0.00,0.00,728903),('1','57','257206','175',410.00,410.00,0.00,0.00,0.00,0.00,0.00,728904),('1','57','257206','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728905),('1','57','257207','174',410.00,410.00,1780.44,0.00,0.00,0.00,0.00,728906),('1','57','257207','175',410.00,410.00,0.00,0.00,0.00,0.00,0.00,728907),('1','57','257207','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728908),('1','57','257208','174',410.00,410.00,112.41,0.00,0.00,0.00,0.00,728909),('1','57','257208','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728910),('1','57','257208','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728911),('1','57','257209','174',415.00,415.00,1391.72,0.00,0.00,0.00,0.00,728912),('1','57','257209','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728913),('1','57','257209','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728914),('1','57','257210','174',415.00,415.00,750.04,0.00,0.00,0.00,0.00,728915),('1','57','257210','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728916),('1','57','257210','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728917),('1','57','257211','174',415.00,415.00,2596.09,0.00,0.00,0.00,0.00,728918),('1','57','257211','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728919),('1','57','257211','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728920),('1','57','257212','174',415.00,415.00,3520.00,0.00,0.00,0.00,0.00,728921),('1','57','257212','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728922),('1','57','257212','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728923),('1','57','257213','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728924),('1','57','257213','174',415.00,415.00,1723.83,0.00,0.00,0.00,0.00,728925),('1','57','257213','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728926),('1','57','257214','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728927),('1','57','257214','174',415.00,415.00,600.05,0.00,0.00,0.00,0.00,728928),('1','57','257214','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728929),('1','57','257215','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728930),('1','57','257215','174',415.00,415.00,1020.32,0.00,0.00,0.00,0.00,728931),('1','57','257215','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728932),('1','57','257216','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728933),('1','57','257216','174',415.00,415.00,2767.00,0.00,0.00,0.00,0.00,728934),('1','57','257216','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728935),('1','57','257217','174',430.00,430.00,0.00,0.00,0.00,0.00,0.00,728936),('1','57','257217','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728937),('1','57','257217','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728938),('1','57','257218','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728939),('1','57','257218','174',430.00,430.00,0.00,0.00,0.00,0.00,0.00,728940),('1','57','257218','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728941),('1','57','257219','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728942),('1','57','257219','174',430.00,430.00,0.00,0.00,0.00,0.00,0.00,728943),('1','57','257219','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728944),('1','57','257220','174',430.00,430.00,1126.59,0.00,0.00,0.00,0.00,728945),('1','57','257220','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728946),('1','57','257220','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728947),('1','57','257221','174',430.00,430.00,2181.77,0.00,0.00,0.00,0.00,728948),('1','57','257221','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728949),('1','57','257221','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728950),('1','57','257222','174',430.00,430.00,1052.61,0.00,0.00,0.00,0.00,728951),('1','57','257222','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728952),('1','57','257222','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728953),('1','57','257223','174',460.00,460.00,947.79,0.00,0.00,0.00,0.00,728954),('1','57','257223','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728955),('1','57','257223','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728956),('1','57','257224','174',460.00,460.00,4459.96,0.00,0.00,0.00,0.00,728957),('1','57','257224','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728958),('1','57','257224','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728959),('1','57','257225','174',500.00,500.00,499.07,0.00,0.00,0.00,0.00,728960),('1','57','257225','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728961),('1','57','257225','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728962),('1','57','257226','174',500.00,500.00,2112.08,0.00,0.00,0.00,0.00,728963),('1','57','257226','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728964),('1','57','257226','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728965),('1','57','257227','174',500.00,500.00,0.00,0.00,0.00,0.00,0.00,728966),('1','57','257227','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728967),('1','57','257227','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728968),('1','57','257228','174',500.00,500.00,1820.01,0.00,0.00,0.00,0.00,728969),('1','57','257228','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728970),('1','57','257228','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728971),('1','57','257229','174',500.00,500.00,2000.00,0.00,0.00,0.00,0.00,728972),('1','57','257229','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728973),('1','57','257229','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728974),('1','57','257230','174',500.00,500.00,2.00,0.00,0.00,0.00,0.00,728975),('1','57','257230','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728976),('1','57','257230','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728977),('1','57','257231','174',500.00,500.00,2003.28,0.00,0.00,0.00,0.00,728978),('1','57','257231','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728979),('1','57','257231','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728980),('1','57','257232','174',600.00,600.00,202.02,0.00,0.00,0.00,0.00,728981),('1','57','257232','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728982),('1','57','257232','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728983),('1','57','257233','174',600.00,600.00,0.50,0.00,0.00,0.00,0.00,728984),('1','57','257233','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728985),('1','57','257233','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728986),('1','57','257234','174',600.00,600.00,0.50,0.00,0.00,0.00,0.00,728987),('1','57','257234','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728988),('1','57','257234','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728989),('1','57','257235','174',600.00,600.00,1558.24,0.00,0.00,0.00,0.00,728990),('1','57','257235','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728991),('1','57','257235','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728992),('1','57','257236','174',600.00,600.00,2505.83,0.00,0.00,0.00,0.00,728993),('1','57','257236','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728994),('1','57','257236','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728995),('1','57','257237','174',600.00,600.00,501.99,0.00,0.00,0.00,0.00,728996),('1','57','257237','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,728997),('1','57','257237','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728998),('1','57','257238','174',600.00,600.00,232.00,0.00,0.00,0.00,0.00,728999),('1','57','257238','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729000),('1','57','257238','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729001),('1','57','257239','174',600.00,600.00,0.00,0.00,0.00,0.00,0.00,729002),('1','57','257239','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729003),('1','57','257239','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729004),('1','57','257240','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729005),('1','57','257240','174',700.00,700.00,412.72,0.00,0.00,0.00,0.00,729006),('1','57','257240','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729007),('1','57','257241','174',700.00,700.00,1011.57,0.00,0.00,0.00,0.00,729008),('1','57','257241','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729009),('1','57','257241','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729010),('1','57','257242','174',700.00,700.00,25.71,0.00,0.00,0.00,0.00,729011),('1','57','257242','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729012),('1','57','257242','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729013),('1','57','257243','174',700.00,700.00,310.29,0.00,0.00,0.00,0.00,729014),('1','57','257243','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729015),('1','57','257243','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729016),('1','57','257244','174',700.00,700.00,320.71,0.00,0.00,0.00,0.00,729017),('1','57','257244','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729018),('1','57','257244','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729019),('1','57','257245','174',700.00,700.00,26.99,0.00,0.00,0.00,0.00,729020),('1','57','257245','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729021),('1','57','257245','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729022),('1','57','257246','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729023),('1','57','257246','174',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729024),('1','57','257246','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729025),('1','57','257247','174',700.00,700.00,9.99,0.00,0.00,0.00,0.00,729026),('1','57','257247','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729027),('1','57','257247','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729028),('1','57','257248','174',700.00,700.00,30.00,0.00,0.00,0.00,0.00,729029),('1','57','257248','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729030),('1','57','257248','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729031),('1','57','257249','174',700.00,700.00,13.15,0.00,0.00,0.00,0.00,729032),('1','57','257249','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729033),('1','57','257249','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729034),('1','57','257250','174',700.00,700.00,93.46,0.00,0.00,0.00,0.00,729035),('1','57','257250','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729036),('1','57','257250','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729037),('1','57','257251','174',700.00,700.00,112.01,0.00,0.00,0.00,0.00,729038),('1','57','257251','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729039),('1','57','257251','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729040),('1','57','257252','174',700.00,700.00,2428.83,0.00,0.00,0.00,0.00,729041),('1','57','257252','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729042),('1','57','257252','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729043),('1','57','257253','174',700.00,700.00,7.14,0.00,0.00,0.00,0.00,729044),('1','57','257253','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729045),('1','57','257253','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729046),('1','57','257254','174',700.00,700.00,9.60,0.00,0.00,0.00,0.00,729047),('1','57','257254','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729048),('1','57','257254','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729049),('1','57','257255','174',700.00,700.00,92.56,0.00,0.00,0.00,0.00,729050),('1','57','257255','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729051),('1','57','257255','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729052),('1','57','257256','174',700.00,700.00,49.28,0.00,0.00,0.00,0.00,729053),('1','57','257256','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729054),('1','57','257256','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729055),('1','57','257257','174',700.00,700.00,60.00,0.00,0.00,0.00,0.00,729056),('1','57','257257','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729057),('1','57','257257','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729058),('1','57','257258','174',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729059),('1','57','257258','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729060),('1','57','257258','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729061),('1','57','257259','174',700.00,700.00,43.29,0.00,0.00,0.00,0.00,729062),('1','57','257259','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729063),('1','57','257259','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729064),('1','57','257260','174',700.00,700.00,26.59,0.00,0.00,0.00,0.00,729065),('1','57','257260','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729066),('1','57','257260','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729067),('1','57','257261','174',700.00,700.00,1.20,0.00,0.00,0.00,0.00,729068),('1','57','257261','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729069),('1','57','257261','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729070),('1','57','257262','174',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729071),('1','57','257262','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729072),('1','57','257262','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729073),('1','57','257263','174',700.00,700.00,3.12,0.00,0.00,0.00,0.00,729074),('1','57','257263','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729075),('1','57','257263','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729076),('1','57','257264','174',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729077),('1','57','257264','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729078),('1','57','257264','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729079),('1','57','257265','174',700.00,700.00,123.68,0.00,0.00,0.00,0.00,729080),('1','57','257265','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729081),('1','57','257265','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729082),('1','57','257266','174',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729083),('1','57','257266','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729084),('1','57','257266','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729085),('1','57','257267','174',700.00,700.00,13.43,0.00,0.00,0.00,0.00,729086),('1','57','257267','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729087),('1','57','257267','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729088),('1','57','257268','174',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729089),('1','57','257268','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729090),('1','57','257268','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729091),('1','57','257269','174',700.00,700.00,844.21,0.00,0.00,0.00,0.00,729092),('1','57','257269','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729093),('1','57','257269','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729094),('1','57','257270','174',700.00,700.00,335.00,0.00,0.00,0.00,0.00,729095),('1','57','257270','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729096),('1','57','257270','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729097),('1','57','257271','174',700.00,700.00,217.14,0.00,0.00,0.00,0.00,729098),('1','57','257271','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729099),('1','57','257271','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729100),('1','57','257272','174',700.00,700.00,539.00,0.00,0.00,0.00,0.00,729101),('1','57','257272','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729102),('1','57','257272','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729103),('1','57','257273','174',700.00,700.00,546.15,0.00,0.00,0.00,0.00,729104),('1','57','257273','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729105),('1','57','257273','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729106),('1','57','257274','174',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729107),('1','57','257274','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729108),('1','57','257274','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729109),('1','57','257275','174',700.00,700.00,5.64,0.00,0.00,0.00,0.00,729110),('1','57','257275','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729111),('1','57','257275','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729112),('1','57','257276','174',700.00,700.00,53.91,0.00,0.00,0.00,0.00,729113),('1','57','257276','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729114),('1','57','257276','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729115),('1','57','257277','174',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729116),('1','57','257277','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729117),('1','57','257277','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729118),('1','57','257278','174',700.00,700.00,5.43,0.00,0.00,0.00,0.00,729119),('1','57','257278','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729120),('1','57','257278','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729121),('1','57','257279','174',700.00,700.00,126.29,0.00,0.00,0.00,0.00,729122),('1','57','257279','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729123),('1','57','257279','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729124),('1','57','257280','174',700.00,700.00,4.14,0.00,0.00,0.00,0.00,729125),('1','57','257280','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729126),('1','57','257280','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729127),('1','57','257281','174',700.00,700.00,1012.14,0.00,0.00,0.00,0.00,729128),('1','57','257281','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729129),('1','57','257281','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729130),('1','57','257282','174',700.00,700.00,984.00,0.00,0.00,0.00,0.00,729131),('1','57','257282','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729132),('1','57','257282','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729133),('1','57','257283','174',700.00,700.00,4.00,0.00,0.00,0.00,0.00,729134),('1','57','257283','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729135),('1','57','257283','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729136),('1','57','257284','174',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729137),('1','57','257284','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729138),('1','57','257284','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729139),('1','57','257285','174',700.00,700.00,62.00,0.00,0.00,0.00,0.00,729140),('1','57','257285','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729141),('1','57','257285','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729142),('1','57','257286','174',700.00,700.00,200.00,0.00,0.00,0.00,0.00,729143),('1','57','257286','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729144),('1','57','257286','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729145),('1','57','257287','174',700.00,700.00,341.80,0.00,0.00,0.00,0.00,729146),('1','57','257287','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729147),('1','57','257287','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729148),('1','57','257288','174',665.00,665.00,500.00,0.00,0.00,0.00,0.00,729149),('1','57','257288','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729150),('1','57','257288','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729151),('1','57','257289','174',665.00,665.00,299.95,0.00,0.00,0.00,0.00,729152),('1','57','257289','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729153),('1','57','257289','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729154),('1','57','257290','174',665.00,665.00,742.75,0.00,0.00,0.00,0.00,729155),('1','57','257290','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729156),('1','57','257290','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729157),('1','57','257291','174',665.00,665.00,1435.59,0.00,0.00,0.00,0.00,729158),('1','57','257291','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729159),('1','57','257291','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729160),('1','57','257292','174',665.00,665.00,554.05,0.00,0.00,0.00,0.00,729161),('1','57','257292','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729162),('1','57','257292','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729163),('1','57','257293','174',665.00,665.00,481.96,0.00,0.00,0.00,0.00,729164),('1','57','257293','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729165),('1','57','257293','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729166),('1','57','257294','174',665.00,665.00,0.00,0.00,0.00,0.00,0.00,729167),('1','57','257294','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729168),('1','57','257294','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729169),('1','57','257295','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729170),('1','57','257295','174',665.00,665.00,369.02,0.00,0.00,0.00,0.00,729171),('1','57','257295','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729172),('1','57','257296','174',665.00,665.00,0.00,0.00,0.00,0.00,0.00,729173),('1','57','257296','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729174),('1','57','257296','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729175),('1','57','257297','174',665.00,665.00,854.42,0.00,0.00,0.00,0.00,729176),('1','57','257297','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729177),('1','57','257297','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729178),('1','57','257298','174',665.00,665.00,873.87,0.00,0.00,0.00,0.00,729179),('1','57','257298','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729180),('1','57','257298','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729181),('1','57','257299','174',665.00,665.00,459.51,0.00,0.00,0.00,0.00,729182),('1','57','257299','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729183),('1','57','257299','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729184),('1','57','257300','174',665.00,665.00,0.00,0.00,0.00,0.00,0.00,729185),('1','57','257300','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729186),('1','57','257300','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729187),('1','57','257301','174',800.00,800.00,167.74,0.00,0.00,0.00,0.00,729188),('1','57','257301','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729189),('1','57','257301','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729190),('1','57','257302','174',800.00,800.00,603.73,0.00,0.00,0.00,0.00,729191),('1','57','257302','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729192),('1','57','257302','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729193),('1','57','257303','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729194),('1','57','257303','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729195),('1','57','257303','173',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729196),('1','57','257304','173',165.00,165.00,78.63,0.00,0.00,0.00,0.00,729197),('1','57','257304','174',800.00,800.00,55.78,0.00,0.00,0.00,0.00,729198),('1','57','257304','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729199),('1','57','257305','173',190.00,190.00,196.78,0.00,0.00,0.00,0.00,729200),('1','57','257305','174',800.00,800.00,112.39,0.00,0.00,0.00,0.00,729201),('1','57','257305','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729202),('1','57','257306','174',800.00,800.00,72.38,0.00,0.00,0.00,0.00,729203),('1','57','257306','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729204),('1','57','257306','173',190.00,190.00,285.54,0.00,0.00,0.00,0.00,729205),('1','57','257307','174',800.00,800.00,710.05,0.00,0.00,0.00,0.00,729206),('1','57','257307','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729207),('1','57','257307','173',190.00,190.00,217.48,0.00,0.00,0.00,0.00,729208),('1','57','257308','173',190.00,190.00,361.69,0.00,0.00,0.00,0.00,729209),('1','57','257308','174',800.00,800.00,619.32,0.00,0.00,0.00,0.00,729210),('1','57','257308','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729211),('1','57','257309','173',190.00,190.00,148.46,0.00,0.00,0.00,0.00,729212),('1','57','257309','174',800.00,800.00,81.13,0.00,0.00,0.00,0.00,729213),('1','57','257309','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729214),('1','57','257310','174',800.00,800.00,62.60,0.00,0.00,0.00,0.00,729215),('1','57','257310','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729216),('1','57','257310','173',190.00,190.00,267.43,0.00,0.00,0.00,0.00,729217),('1','57','257311','173',190.00,190.00,239.27,0.00,0.00,0.00,0.00,729218),('1','57','257311','174',800.00,800.00,718.82,0.00,0.00,0.00,0.00,729219),('1','57','257311','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729220),('1','57','257312','174',800.00,800.00,507.58,0.00,0.00,0.00,0.00,729221),('1','57','257312','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729222),('1','57','257312','173',190.00,190.00,170.76,0.00,0.00,0.00,0.00,729223),('1','57','257313','174',800.00,800.00,656.01,0.00,0.00,0.00,0.00,729224),('1','57','257313','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729225),('1','57','257313','173',190.00,190.00,220.65,0.00,0.00,0.00,0.00,729226),('1','57','257314','173',190.00,190.00,153.89,0.00,0.00,0.00,0.00,729227),('1','57','257314','174',800.00,800.00,13.73,0.00,0.00,0.00,0.00,729228),('1','57','257314','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729229),('1','57','257315','174',800.00,800.00,729.32,0.00,0.00,0.00,0.00,729230),('1','57','257315','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729231),('1','57','257315','173',190.00,190.00,63.67,0.00,0.00,0.00,0.00,729232),('1','57','257316','174',800.00,800.00,996.00,0.00,0.00,0.00,0.00,729233),('1','57','257316','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729234),('1','57','257316','173',190.00,190.00,189.21,0.00,0.00,0.00,0.00,729235),('1','57','257317','174',800.00,800.00,82.51,0.00,0.00,0.00,0.00,729236),('1','57','257317','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729237),('1','57','257317','173',190.00,190.00,356.48,0.00,0.00,0.00,0.00,729238),('1','57','257318','174',800.00,800.00,62.76,0.00,0.00,0.00,0.00,729239),('1','57','257318','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729240),('1','57','257318','173',190.00,190.00,568.89,0.00,0.00,0.00,0.00,729241),('1','57','257319','174',800.00,800.00,740.23,0.00,0.00,0.00,0.00,729242),('1','57','257319','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729243),('1','57','257319','173',190.00,190.00,701.02,0.00,0.00,0.00,0.00,729244),('1','57','257320','174',800.00,800.00,200.01,0.00,0.00,0.00,0.00,729245),('1','57','257320','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729246),('1','57','257320','173',190.00,190.00,352.65,0.00,0.00,0.00,0.00,729247),('1','57','257321','174',800.00,800.00,503.51,0.00,0.00,0.00,0.00,729248),('1','57','257321','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729249),('1','57','257321','173',190.00,190.00,365.42,0.00,0.00,0.00,0.00,729250),('1','57','257322','174',800.00,800.00,109.38,0.00,0.00,0.00,0.00,729251),('1','57','257322','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729252),('1','57','257322','173',190.00,190.00,359.46,0.00,0.00,0.00,0.00,729253),('1','57','257323','174',800.00,800.00,502.63,0.00,0.00,0.00,0.00,729254),('1','57','257323','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729255),('1','57','257323','173',190.00,190.00,224.71,0.00,0.00,0.00,0.00,729256),('1','57','257324','174',800.00,800.00,50.00,0.00,0.00,0.00,0.00,729257),('1','57','257324','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729258),('1','57','257324','173',190.00,190.00,338.31,0.00,0.00,0.00,0.00,729259),('1','57','257325','174',800.00,800.00,305.51,0.00,0.00,0.00,0.00,729260),('1','57','257325','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729261),('1','57','257325','173',190.00,190.00,243.47,0.00,0.00,0.00,0.00,729262),('1','57','257326','174',800.00,800.00,202.88,0.00,0.00,0.00,0.00,729263),('1','57','257326','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729264),('1','57','257326','173',190.00,190.00,445.31,0.00,0.00,0.00,0.00,729265),('1','57','257327','174',800.00,800.00,26.94,0.00,0.00,0.00,0.00,729266),('1','57','257327','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729267),('1','57','257327','173',190.00,190.00,352.39,0.00,0.00,0.00,0.00,729268),('1','57','257328','173',190.00,190.00,261.12,0.00,0.00,0.00,0.00,729269),('1','57','257328','174',800.00,800.00,638.64,0.00,0.00,0.00,0.00,729270),('1','57','257328','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729271),('1','57','257329','174',800.00,800.00,586.27,0.00,0.00,0.00,0.00,729272),('1','57','257329','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729273),('1','57','257329','173',190.00,190.00,200.87,0.00,0.00,0.00,0.00,729274),('1','57','257330','174',800.00,800.00,601.31,0.00,0.00,0.00,0.00,729275),('1','57','257330','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729276),('1','57','257330','173',190.00,190.00,284.89,0.00,0.00,0.00,0.00,729277),('1','57','257331','173',190.00,190.00,274.00,0.00,0.00,0.00,0.00,729278),('1','57','257331','174',800.00,800.00,646.39,0.00,0.00,0.00,0.00,729279),('1','57','257331','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729280),('1','57','257332','174',800.00,800.00,330.00,0.00,0.00,0.00,0.00,729281),('1','57','257332','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729282),('1','57','257332','173',190.00,190.00,384.51,0.00,0.00,0.00,0.00,729283),('1','57','257333','174',800.00,800.00,3.39,0.00,0.00,0.00,0.00,729284),('1','57','257333','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729285),('1','57','257333','173',190.00,190.00,310.77,0.00,0.00,0.00,0.00,729286),('1','57','257334','173',190.00,190.00,278.35,0.00,0.00,0.00,0.00,729287),('1','57','257334','174',800.00,800.00,611.00,0.00,0.00,0.00,0.00,729288),('1','57','257334','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729289),('1','57','257335','174',800.00,800.00,54.25,0.00,0.00,0.00,0.00,729290),('1','57','257335','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729291),('1','57','257335','173',190.00,190.00,362.65,0.00,0.00,0.00,0.00,729292),('1','57','257336','174',800.00,800.00,157.13,0.00,0.00,0.00,0.00,729293),('1','57','257336','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729294),('1','57','257336','173',190.00,190.00,623.26,0.00,0.00,0.00,0.00,729295),('1','57','257337','174',800.00,800.00,64.63,0.00,0.00,0.00,0.00,729296),('1','57','257337','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729297),('1','57','257337','173',190.00,190.00,362.94,0.00,0.00,0.00,0.00,729298),('1','57','257338','173',190.00,190.00,592.58,0.00,0.00,0.00,0.00,729299),('1','57','257338','174',800.00,800.00,202.52,0.00,0.00,0.00,0.00,729300),('1','57','257338','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729301),('1','57','257339','174',800.00,800.00,506.91,0.00,0.00,0.00,0.00,729302),('1','57','257339','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729303),('1','57','257339','173',190.00,190.00,532.32,0.00,0.00,0.00,0.00,729304),('1','57','257340','173',190.00,190.00,370.93,0.00,0.00,0.00,0.00,729305),('1','57','257340','174',800.00,800.00,477.95,0.00,0.00,0.00,0.00,729306),('1','57','257340','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729307),('1','57','257341','173',190.00,190.00,2076.04,0.00,0.00,0.00,0.00,729308),('1','57','257341','174',800.00,800.00,31.00,0.00,0.00,0.00,0.00,729309),('1','57','257341','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729310),('1','57','257342','173',190.00,190.00,576.33,0.00,0.00,0.00,0.00,729311),('1','57','257342','174',800.00,800.00,250.00,0.00,0.00,0.00,0.00,729312),('1','57','257342','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729313),('1','57','257343','174',800.00,800.00,419.00,0.00,0.00,0.00,0.00,729314),('1','57','257343','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729315),('1','57','257343','173',190.00,190.00,292.72,0.00,0.00,0.00,0.00,729316),('1','57','257344','173',190.00,190.00,0.00,0.00,0.00,0.00,0.00,729317),('1','57','257344','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729318),('1','57','257344','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729319),('1','57','257345','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729320),('1','57','257345','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729321),('1','57','257345','173',190.00,190.00,0.00,0.00,0.00,0.00,0.00,729322),('1','57','257346','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729323),('1','57','257346','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729324),('1','57','257346','173',190.00,190.00,2472.22,0.00,0.00,0.00,0.00,729325),('1','57','257347','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729326),('1','57','257347','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729327),('1','57','257347','173',190.00,190.00,310.58,0.00,0.00,0.00,0.00,729328),('1','57','257348','173',190.00,190.00,1518.68,0.00,0.00,0.00,0.00,729329),('1','57','257348','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729330),('1','57','257348','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729331),('1','57','257349','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729332),('1','57','257349','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729333),('1','57','257349','173',190.00,190.00,960.78,0.00,0.00,0.00,0.00,729334),('1','57','257350','173',190.00,190.00,415.33,0.00,0.00,0.00,0.00,729335),('1','57','257350','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729336),('1','57','257350','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729337),('1','57','257351','173',190.00,190.00,880.91,0.00,0.00,0.00,0.00,729338),('1','57','257351','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729339),('1','57','257351','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729340),('1','57','257352','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729341),('1','57','257352','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729342),('1','57','257352','173',190.00,190.00,838.38,0.00,0.00,0.00,0.00,729343),('1','57','257353','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729344),('1','57','257353','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729345),('1','57','257353','173',190.00,190.00,496.48,0.00,0.00,0.00,0.00,729346),('1','57','257354','173',190.00,190.00,1212.17,0.00,0.00,0.00,0.00,729347),('1','57','257354','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729348),('1','57','257354','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729349),('1','57','257355','173',190.00,190.00,795.09,0.00,0.00,0.00,0.00,729350),('1','57','257355','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729351),('1','57','257355','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729352),('1','57','257356','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729353),('1','57','257356','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729354),('1','57','257356','173',190.00,190.00,697.77,0.00,0.00,0.00,0.00,729355),('1','57','257357','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729356),('1','57','257357','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729357),('1','57','257357','173',190.00,190.00,495.13,0.00,0.00,0.00,0.00,729358),('1','57','257358','173',190.00,190.00,573.22,0.00,0.00,0.00,0.00,729359),('1','57','257358','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729360),('1','57','257358','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729361),('1','57','257359','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729362),('1','57','257359','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729363),('1','57','257359','173',190.00,190.00,1089.90,0.00,0.00,0.00,0.00,729364),('1','57','257360','173',190.00,190.00,403.96,0.00,0.00,0.00,0.00,729365),('1','57','257360','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729366),('1','57','257360','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729367),('1','57','257361','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729368),('1','57','257361','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729369),('1','57','257361','173',190.00,190.00,952.37,0.00,0.00,0.00,0.00,729370),('1','57','257362','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729371),('1','57','257362','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729372),('1','57','257362','173',190.00,190.00,466.71,0.00,0.00,0.00,0.00,729373),('1','57','257363','173',190.00,190.00,786.38,0.00,0.00,0.00,0.00,729374),('1','57','257363','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729375),('1','57','257363','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729376),('1','57','257364','173',190.00,190.00,520.68,0.00,0.00,0.00,0.00,729377),('1','57','257364','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729378),('1','57','257364','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729379),('1','57','257365','173',190.00,190.00,1045.70,0.00,0.00,0.00,0.00,729380),('1','57','257365','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729381),('1','57','257365','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729382),('1','57','257366','173',190.00,190.00,762.93,0.00,0.00,0.00,0.00,729383),('1','57','257366','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729384),('1','57','257366','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729385),('1','57','257367','173',190.00,190.00,980.23,0.00,0.00,0.00,0.00,729386),('1','57','257367','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729387),('1','57','257367','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729388),('1','57','257368','173',190.00,190.00,831.17,0.00,0.00,0.00,0.00,729389),('1','57','257368','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729390),('1','57','257368','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729391),('1','57','257369','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729392),('1','57','257369','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729393),('1','57','257369','173',190.00,190.00,919.09,0.00,0.00,0.00,0.00,729394),('1','57','257370','173',190.00,190.00,455.57,0.00,0.00,0.00,0.00,729395),('1','57','257370','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729396),('1','57','257370','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729397),('1','57','257371','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729398),('1','57','257371','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729399),('1','57','257371','173',190.00,190.00,844.15,0.00,0.00,0.00,0.00,729400),('1','57','257372','173',190.00,190.00,417.05,0.00,0.00,0.00,0.00,729401),('1','57','257372','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729402),('1','57','257372','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729403),('1','57','257373','173',190.00,190.00,1813.54,0.00,0.00,0.00,0.00,729404),('1','57','257373','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729405),('1','57','257373','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729406),('1','57','257374','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729407),('1','57','257374','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729408),('1','57','257374','173',190.00,190.00,430.34,0.00,0.00,0.00,0.00,729409),('1','57','257375','173',190.00,190.00,199.48,0.00,0.00,0.00,0.00,729410),('1','57','257375','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729411),('1','57','257375','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729412),('1','57','257376','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729413),('1','57','257376','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729414),('1','57','257376','173',190.00,190.00,0.00,0.00,0.00,0.00,0.00,729415),('1','57','257377','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729416),('1','57','257377','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729417),('1','57','257377','173',245.00,245.00,3365.24,0.00,0.00,0.00,0.00,729418),('1','57','257378','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729419),('1','57','257378','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729420),('1','57','257378','173',245.00,245.00,5940.76,0.00,0.00,0.00,0.00,729421),('1','57','257379','173',245.00,245.00,717.42,0.00,0.00,0.00,0.00,729422),('1','57','257379','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729423),('1','57','257379','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729424),('1','57','257380','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729425),('1','57','257380','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729426),('1','57','257380','173',245.00,245.00,1675.76,0.00,0.00,0.00,0.00,729427),('1','57','257381','173',245.00,245.00,3128.59,0.00,0.00,0.00,0.00,729428),('1','57','257381','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729429),('1','57','257381','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729430),('1','57','257382','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729431),('1','57','257382','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729432),('1','57','257382','173',245.00,245.00,432.24,0.00,0.00,0.00,0.00,729433),('1','57','257383','174',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729434),('1','57','257383','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729435),('1','57','257383','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729436),('1','57','257384','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729437),('1','57','257384','174',890.00,890.00,961.42,0.00,0.00,0.00,0.00,729438),('1','57','257384','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729439),('1','57','257385','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729440),('1','57','257385','174',890.00,890.00,700.00,0.00,0.00,0.00,0.00,729441),('1','57','257385','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729442),('1','57','257386','174',890.00,890.00,777.81,0.00,0.00,0.00,0.00,729443),('1','57','257386','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729444),('1','57','257386','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729445),('1','57','257387','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729446),('1','57','257387','174',890.00,890.00,137.55,0.00,0.00,0.00,0.00,729447),('1','57','257387','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729448),('1','57','257388','174',890.00,890.00,80.00,0.00,0.00,0.00,0.00,729449),('1','57','257388','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729450),('1','57','257388','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729451),('1','57','257389','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729452),('1','57','257389','174',890.00,890.00,13.03,0.00,0.00,0.00,0.00,729453),('1','57','257389','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729454),('1','57','257390','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729455),('1','57','257390','174',890.00,890.00,809.72,0.00,0.00,0.00,0.00,729456),('1','57','257390','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729457),('1','57','257391','174',890.00,890.00,75.00,0.00,0.00,0.00,0.00,729458),('1','57','257391','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729459),('1','57','257391','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729460),('1','57','257392','174',890.00,890.00,491.69,0.00,0.00,0.00,0.00,729461),('1','57','257392','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729462),('1','57','257392','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729463),('1','57','257393','174',890.00,890.00,180.00,0.00,0.00,0.00,0.00,729464),('1','57','257393','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729465),('1','57','257393','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729466),('1','57','257394','174',890.00,890.00,852.94,0.00,0.00,0.00,0.00,729467),('1','57','257394','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729468),('1','57','257394','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729469),('1','57','257395','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729470),('1','57','257395','174',890.00,890.00,522.25,0.00,0.00,0.00,0.00,729471),('1','57','257395','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729472),('1','57','257396','174',890.00,890.00,314.12,0.00,0.00,0.00,0.00,729473),('1','57','257396','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729474),('1','57','257396','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729475),('1','57','257397','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729476),('1','57','257397','174',890.00,890.00,65.62,0.00,0.00,0.00,0.00,729477),('1','57','257397','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729478),('1','57','257398','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729479),('1','57','257398','174',890.00,890.00,205.21,0.00,0.00,0.00,0.00,729480),('1','57','257398','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729481),('1','57','257399','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729482),('1','57','257399','174',890.00,890.00,97.32,0.00,0.00,0.00,0.00,729483),('1','57','257399','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729484),('1','57','257400','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729485),('1','57','257400','174',890.00,890.00,994.30,0.00,0.00,0.00,0.00,729486),('1','57','257400','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729487),('1','57','257401','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729488),('1','57','257401','174',890.00,890.00,2.25,0.00,0.00,0.00,0.00,729489),('1','57','257401','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729490),('1','57','257402','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729491),('1','57','257402','174',890.00,890.00,201.12,0.00,0.00,0.00,0.00,729492),('1','57','257402','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729493),('1','57','257403','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729494),('1','57','257403','174',890.00,890.00,50.00,0.00,0.00,0.00,0.00,729495),('1','57','257403','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729496),('1','57','257404','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729497),('1','57','257404','174',890.00,890.00,311.46,0.00,0.00,0.00,0.00,729498),('1','57','257404','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729499),('1','57','257405','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729500),('1','57','257405','174',890.00,890.00,1636.26,0.00,0.00,0.00,0.00,729501),('1','57','257405','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729502),('1','57','257406','174',890.00,890.00,366.86,0.00,0.00,0.00,0.00,729503),('1','57','257406','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729504),('1','57','257406','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729505),('1','57','257407','174',890.00,890.00,201.60,0.00,0.00,0.00,0.00,729506),('1','57','257407','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729507),('1','57','257407','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729508),('1','57','257408','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729509),('1','57','257408','174',890.00,890.00,186.16,0.00,0.00,0.00,0.00,729510),('1','57','257408','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729511),('1','57','257409','174',890.00,890.00,291.81,0.00,0.00,0.00,0.00,729512),('1','57','257409','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729513),('1','57','257409','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729514),('1','57','257410','174',890.00,890.00,1342.85,0.00,0.00,0.00,0.00,729515),('1','57','257410','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729516),('1','57','257410','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729517),('1','57','257411','174',890.00,890.00,56.91,0.00,0.00,0.00,0.00,729518),('1','57','257411','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729519),('1','57','257411','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729520),('1','57','257412','174',890.00,890.00,188.88,0.00,0.00,0.00,0.00,729521),('1','57','257412','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729522),('1','57','257412','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729523),('1','57','257413','174',890.00,890.00,554.89,0.00,0.00,0.00,0.00,729524),('1','57','257413','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729525),('1','57','257413','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729526),('1','57','257414','174',890.00,890.00,303.78,0.00,0.00,0.00,0.00,729527),('1','57','257414','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729528),('1','57','257414','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729529),('1','57','257415','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729530),('1','57','257415','174',890.00,890.00,317.03,0.00,0.00,0.00,0.00,729531),('1','57','257415','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729532),('1','57','257416','174',890.00,890.00,1274.40,0.00,0.00,0.00,0.00,729533),('1','57','257416','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729534),('1','57','257416','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729535),('1','57','257417','174',890.00,890.00,117.62,0.00,0.00,0.00,0.00,729536),('1','57','257417','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729537),('1','57','257417','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729538),('1','57','257418','174',890.00,890.00,752.20,0.00,0.00,0.00,0.00,729539),('1','57','257418','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729540),('1','57','257418','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729541),('1','57','257419','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729542),('1','57','257419','174',890.00,890.00,886.74,0.00,0.00,0.00,0.00,729543),('1','57','257419','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729544),('1','57','257420','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729545),('1','57','257420','174',890.00,890.00,341.81,0.00,0.00,0.00,0.00,729546),('1','57','257420','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729547),('1','57','257421','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729548),('1','57','257421','174',890.00,890.00,537.62,0.00,0.00,0.00,0.00,729549),('1','57','257421','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729550),('1','57','257422','174',890.00,890.00,574.57,0.00,0.00,0.00,0.00,729551),('1','57','257422','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729552),('1','57','257422','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729553),('1','57','257423','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729554),('1','57','257423','174',890.00,890.00,401.35,0.00,0.00,0.00,0.00,729555),('1','57','257423','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729556),('1','57','257424','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729557),('1','57','257424','174',890.00,890.00,322.04,0.00,0.00,0.00,0.00,729558),('1','57','257424','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729559),('1','57','257425','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729560),('1','57','257425','174',890.00,890.00,351.24,0.00,0.00,0.00,0.00,729561),('1','57','257425','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729562),('1','57','257426','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729563),('1','57','257426','174',890.00,890.00,361.68,0.00,0.00,0.00,0.00,729564),('1','57','257426','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729565),('1','57','257427','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729566),('1','57','257427','174',890.00,890.00,53.05,0.00,0.00,0.00,0.00,729567),('1','57','257427','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729568),('1','57','257428','174',890.00,890.00,264.78,0.00,0.00,0.00,0.00,729569),('1','57','257428','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729570),('1','57','257428','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729571),('1','57','257429','174',890.00,890.00,547.56,0.00,0.00,0.00,0.00,729572),('1','57','257429','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729573),('1','57','257429','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729574),('1','57','257430','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729575),('1','57','257430','174',890.00,890.00,25.00,0.00,0.00,0.00,0.00,729576),('1','57','257430','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729577),('1','57','257431','174',890.00,890.00,1.57,0.00,0.00,0.00,0.00,729578),('1','57','257431','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729579),('1','57','257431','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729580),('1','57','257432','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729581),('1','57','257432','174',890.00,890.00,32.79,0.00,0.00,0.00,0.00,729582),('1','57','257432','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729583),('1','57','257433','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729584),('1','57','257433','174',890.00,890.00,87.06,0.00,0.00,0.00,0.00,729585),('1','57','257433','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729586),('1','57','257434','174',870.00,870.00,330.59,0.00,0.00,0.00,0.00,729587),('1','57','257434','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729588),('1','57','257434','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729589),('1','57','257435','174',870.00,870.00,1072.45,0.00,0.00,0.00,0.00,729590),('1','57','257435','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729591),('1','57','257435','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729592),('1','57','257436','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729593),('1','57','257436','174',870.00,870.00,905.46,0.00,0.00,0.00,0.00,729594),('1','57','257436','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729595),('1','57','257437','174',870.00,870.00,0.00,0.00,0.00,0.00,0.00,729596),('1','57','257437','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729597),('1','57','257437','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729598),('1','57','257438','174',870.00,870.00,26.91,0.00,0.00,0.00,0.00,729599),('1','57','257438','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729600),('1','57','257438','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729601),('1','57','257439','174',870.00,870.00,117.21,0.00,0.00,0.00,0.00,729602),('1','57','257439','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729603),('1','57','257439','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729604),('1','57','257440','174',870.00,870.00,367.08,0.00,0.00,0.00,0.00,729605),('1','57','257440','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729606),('1','57','257440','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729607),('1','57','257441','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729608),('1','57','257441','174',870.00,870.00,0.00,0.00,0.00,0.00,0.00,729609),('1','57','257441','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729610),('1','57','257442','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729611),('1','57','257442','174',870.00,870.00,59.20,0.00,0.00,0.00,0.00,729612),('1','57','257442','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729613),('1','57','257443','174',870.00,870.00,695.57,0.00,0.00,0.00,0.00,729614),('1','57','257443','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729615),('1','57','257443','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729616),('1','57','257444','174',870.00,870.00,952.87,0.00,0.00,0.00,0.00,729617),('1','57','257444','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729618),('1','57','257444','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729619),('1','57','257445','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729620),('1','57','257445','174',870.00,870.00,1920.61,0.00,0.00,0.00,0.00,729621),('1','57','257445','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729622),('1','57','257446','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729623),('1','57','257446','174',870.00,870.00,81.15,0.00,0.00,0.00,0.00,729624),('1','57','257446','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729625),('1','57','257447','174',870.00,870.00,410.00,0.00,0.00,0.00,0.00,729626),('1','57','257447','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729627),('1','57','257447','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729628),('1','57','257448','174',870.00,870.00,73.79,0.00,0.00,0.00,0.00,729629),('1','57','257448','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729630),('1','57','257448','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729631),('1','57','257449','174',870.00,870.00,0.00,0.00,0.00,0.00,0.00,729632),('1','57','257449','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729633),('1','57','257449','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729634),('1','57','257450','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729635),('1','57','257450','174',870.00,870.00,155.75,0.00,0.00,0.00,0.00,729636),('1','57','257450','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729637),('1','57','257451','174',870.00,870.00,101.82,0.00,0.00,0.00,0.00,729638),('1','57','257451','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729639),('1','57','257451','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729640),('1','57','257452','174',870.00,870.00,46.26,0.00,0.00,0.00,0.00,729641),('1','57','257452','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729642),('1','57','257452','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729643),('1','57','257453','174',870.00,870.00,7.18,0.00,0.00,0.00,0.00,729644),('1','57','257453','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729645),('1','57','257453','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729646),('1','57','257454','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729647),('1','57','257454','174',870.00,870.00,764.84,0.00,0.00,0.00,0.00,729648),('1','57','257454','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729649),('1','57','257455','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729650),('1','57','257455','174',870.00,870.00,39.78,0.00,0.00,0.00,0.00,729651),('1','57','257455','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729652),('1','57','257456','174',870.00,870.00,1432.23,0.00,0.00,0.00,0.00,729653),('1','57','257456','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729654),('1','57','257456','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729655),('1','57','257457','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729656),('1','57','257457','174',870.00,870.00,42.06,0.00,0.00,0.00,0.00,729657),('1','57','257457','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729658),('1','57','257458','174',870.00,870.00,1039.54,0.00,0.00,0.00,0.00,729659),('1','57','257458','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729660),('1','57','257458','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729661),('1','57','257459','174',870.00,870.00,16.56,0.00,0.00,0.00,0.00,729662),('1','57','257459','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729663),('1','57','257459','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729664),('1','57','257460','174',870.00,870.00,205.14,0.00,0.00,0.00,0.00,729665),('1','57','257460','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729666),('1','57','257460','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729667),('1','57','257461','174',870.00,870.00,104.43,0.00,0.00,0.00,0.00,729668),('1','57','257461','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729669),('1','57','257461','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729670),('1','57','257462','174',870.00,870.00,27.25,0.00,0.00,0.00,0.00,729671),('1','57','257462','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729672),('1','57','257462','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729673),('1','57','257463','174',870.00,870.00,0.00,0.00,0.00,0.00,0.00,729674),('1','57','257463','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729675),('1','57','257463','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729676),('1','57','257464','174',870.00,870.00,58.05,0.00,0.00,0.00,0.00,729677),('1','57','257464','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729678),('1','57','257464','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729679),('1','57','257465','174',870.00,870.00,111.15,0.00,0.00,0.00,0.00,729680),('1','57','257465','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729681),('1','57','257465','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729682),('1','57','257466','174',870.00,870.00,0.00,0.00,0.00,0.00,0.00,729683),('1','57','257466','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729684),('1','57','257466','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729685),('1','57','257467','174',870.00,870.00,530.86,0.00,0.00,0.00,0.00,729686),('1','57','257467','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729687),('1','57','257467','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729688),('1','57','257468','174',870.00,870.00,149.24,0.00,0.00,0.00,0.00,729689),('1','57','257468','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729690),('1','57','257468','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729691),('1','57','257469','174',870.00,870.00,23.69,0.00,0.00,0.00,0.00,729692),('1','57','257469','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729693),('1','57','257469','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729694),('1','57','257470','174',870.00,870.00,180.65,0.00,0.00,0.00,0.00,729695),('1','57','257470','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729696),('1','57','257470','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729697),('1','57','257471','174',870.00,870.00,0.00,0.00,0.00,0.00,0.00,729698),('1','57','257471','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729699),('1','57','257471','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729700),('1','57','257472','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729701),('1','57','257472','174',870.00,870.00,12.58,0.00,0.00,0.00,0.00,729702),('1','57','257472','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729703),('1','57','257473','174',870.00,870.00,285.46,0.00,0.00,0.00,0.00,729704),('1','57','257473','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729705),('1','57','257473','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729706),('1','57','257474','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729707),('1','57','257474','174',870.00,870.00,72.31,0.00,0.00,0.00,0.00,729708),('1','57','257474','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729709),('1','57','257475','174',870.00,870.00,299.58,0.00,0.00,0.00,0.00,729710),('1','57','257475','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729711),('1','57','257475','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729712),('1','57','257476','174',870.00,870.00,296.61,0.00,0.00,0.00,0.00,729713),('1','57','257476','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729714),('1','57','257476','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729715),('1','57','257477','174',850.00,850.00,106.75,0.00,0.00,0.00,0.00,729716),('1','57','257477','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729717),('1','57','257477','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729718),('1','57','257478','174',850.00,850.00,582.94,0.00,0.00,0.00,0.00,729719),('1','57','257478','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729720),('1','57','257478','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729721),('1','57','257479','174',850.00,850.00,214.44,0.00,0.00,0.00,0.00,729722),('1','57','257479','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729723),('1','57','257479','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729724),('1','57','257480','174',850.00,850.00,340.82,0.00,0.00,0.00,0.00,729725),('1','57','257480','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729726),('1','57','257480','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729727),('1','57','257481','174',830.00,830.00,17.52,0.00,0.00,0.00,0.00,729728),('1','57','257481','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729729),('1','57','257481','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729730),('1','57','257482','174',830.00,830.00,730.95,0.00,0.00,0.00,0.00,729731),('1','57','257482','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729732),('1','57','257482','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729733),('1','57','257483','174',830.00,830.00,59.12,0.00,0.00,0.00,0.00,729734),('1','57','257483','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729735),('1','57','257483','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729736),('1','57','257484','174',830.00,830.00,132.49,0.00,0.00,0.00,0.00,729737),('1','57','257484','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729738),('1','57','257484','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729739),('1','57','257485','174',830.00,830.00,0.00,0.00,0.00,0.00,0.00,729740),('1','57','257485','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729741),('1','57','257485','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729742),('1','57','257486','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729743),('1','57','257486','174',830.00,830.00,631.55,0.00,0.00,0.00,0.00,729744),('1','57','257486','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729745),('1','57','257487','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729746),('1','57','257487','174',830.00,830.00,138.00,0.00,0.00,0.00,0.00,729747),('1','57','257487','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729748),('1','57','257488','174',830.00,830.00,324.95,0.00,0.00,0.00,0.00,729749),('1','57','257488','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729750),('1','57','257488','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729751),('1','57','257489','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729752),('1','57','257489','174',830.00,830.00,424.20,0.00,0.00,0.00,0.00,729753),('1','57','257489','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729754),('1','57','257490','174',830.00,830.00,1055.95,0.00,0.00,0.00,0.00,729755),('1','57','257490','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729756),('1','57','257490','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729757),('1','57','257491','174',830.00,830.00,228.24,0.00,0.00,0.00,0.00,729758),('1','57','257491','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729759),('1','57','257491','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729760),('1','57','257492','173',245.00,245.00,0.00,0.00,0.00,0.00,0.00,729761),('1','57','257492','174',830.00,830.00,144.98,0.00,0.00,0.00,0.00,729762),('1','57','257492','175',415.00,415.00,0.00,0.00,0.00,0.00,0.00,729763);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB AUTO_INCREMENT=31692 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
INSERT INTO `depots_shifts_stocklevels` VALUES (31690,'1','57','242540','2021-11-29 10:39:02','716','174',350.00,700.00,245000.00),(31691,'1','57','242540','2021-11-29 10:39:34','716','173',165.00,700.00,115500.00);
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=183 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',181,'57','PMS TANKS','TANKS CONTAINING PETROL.'),('1',182,'57','AGO TANK ','TANK CONTAINING DIESEL.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=469 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','57','181',445,0,'173','PMS TANK 1',33000.00,1.00,0.00,'CONTAINING PMS','139','2017-04-25 16:10:17','2021-11-09 19:31:02','178',5,1),('1','57','181',446,0,'173','PMS TANK 2',40000.00,1.00,0.00,'CONTAINING PMS','139','2017-04-25 16:11:44','2017-04-25 16:11:44','139',5,1),('1','57','182',447,0,'174','AGO TANK ',40000.00,1.00,0.00,'CONTAINING AGO','139','2017-04-25 16:13:14','2017-04-25 16:13:14','139',5,1),('1','57','',468,0,'174','AGO TANK 2',40000.00,1.00,0.00,'CONTAINING AGO','139','2017-04-28 09:54:14','2017-05-03 13:55:41','139',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','57',468,400.00,'2023-03-08 10:46:14'),(2,'1','57',447,499.92,'2023-03-08 10:46:14'),(3,'1','57',446,757.86,'2023-03-08 10:46:14'),(4,'1','57',445,460.29,'2023-03-08 10:46:14');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2614649 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2371675,'1','57',NULL,174,'Purchased from A.A RANO NIGERIA LIMITED',0.00,5950000.00,17000.00,0.00,0.00,'2021-12-25 11:53:58','',''),(2384602,'1','57','447',174,'Sale Id shift 248603',0.00,0.00,0.00,3509.97,0.00,'2021-12-27 13:56:38','',''),(2384603,'1','57',NULL,174,'Sale Id shift 248603',1228489.50,0.00,0.00,0.00,0.00,'2021-12-27 13:56:38','',''),(2394815,'1','57','447',174,'Sale Id shift 249475',0.00,0.00,0.00,599.90,0.00,'2021-12-29 08:57:20','',''),(2394816,'1','57',NULL,174,'Sale Id shift 249475',209965.00,0.00,0.00,0.00,0.00,'2021-12-29 08:57:20','',''),(2394871,'1','57','447',174,'Sale Id shift 249671',0.00,0.00,0.00,1779.18,0.00,'2021-12-29 09:06:38','',''),(2394872,'1','57',NULL,174,'Sale Id shift 249671',622713.00,0.00,0.00,0.00,0.00,'2021-12-29 09:06:38','',''),(2395142,'1','57','447',174,'Sale Id shift 249679',0.00,0.00,0.00,93.00,0.00,'2021-12-29 09:31:29','',''),(2395143,'1','57',NULL,174,'Sale Id shift 249679',32550.00,0.00,0.00,0.00,0.00,'2021-12-29 09:31:29','',''),(2395182,'1','57','447',174,'Sale Id shift 249683',0.00,0.00,0.00,4057.14,0.00,'2021-12-29 09:35:44','',''),(2395183,'1','57',NULL,174,'Sale Id shift 249683',1419999.00,0.00,0.00,0.00,0.00,'2021-12-29 09:35:44','',''),(2395253,'1','57','447',174,'Sale Id shift 249685',0.00,0.00,0.00,1477.45,0.00,'2021-12-29 09:45:28','',''),(2395254,'1','57',NULL,174,'Sale Id shift 249685',517107.50,0.00,0.00,0.00,0.00,'2021-12-29 09:45:28','',''),(2395309,'1','57','447',174,'Sale Id shift 249691',0.00,0.00,0.00,3237.92,0.00,'2021-12-29 09:50:31','',''),(2395310,'1','57',NULL,174,'Sale Id shift 249691',1133272.00,0.00,0.00,0.00,0.00,'2021-12-29 09:50:31','',''),(2395372,'1','57','447',174,'Sale Id shift 249694',0.00,0.00,0.00,89.86,0.00,'2021-12-29 09:56:33','',''),(2395373,'1','57',NULL,174,'Sale Id shift 249694',31451.00,0.00,0.00,0.00,0.00,'2021-12-29 09:56:33','',''),(2395391,'1','57','447',174,'Sale Id shift 249695',0.00,0.00,0.00,2349.39,0.00,'2021-12-29 09:59:12','',''),(2395392,'1','57',NULL,174,'Sale Id shift 249695',822286.50,0.00,0.00,0.00,0.00,'2021-12-29 09:59:12','',''),(2404525,'1','57',NULL,174,'Purchased from A.A RANO NIGERIA LIMITED',0.00,10500000.00,30000.00,0.00,0.00,'2021-12-30 13:51:35','',''),(2408489,'1','57',NULL,174,'Reception corrector for bridging 129233',0.00,0.00,0.00,30000.00,0.00,'2021-12-31 08:15:06','',''),(2408490,'1','57','447',174,'Received from bridging 129233',0.00,0.00,30000.00,0.00,0.00,'2021-12-31 08:15:06','',''),(2408511,'1','57',NULL,174,'Reception corrector for bridging 128723',0.00,0.00,0.00,17000.00,0.00,'2021-12-31 08:17:00','',''),(2408512,'1','57','447',174,'Received from bridging 128723',0.00,0.00,17000.00,0.00,0.00,'2021-12-31 08:17:00','',''),(2410187,'1','57','447',174,'Sale Id shift 250001',0.00,0.00,0.00,1654.00,0.00,'2021-12-31 10:58:04','',''),(2410188,'1','57',NULL,174,'Sale Id shift 250001',578900.00,0.00,0.00,0.00,0.00,'2021-12-31 10:58:04','',''),(2418335,'1','57','447',174,'Sale Id shift 250248',0.00,0.00,0.00,899.62,0.00,'2022-01-01 13:10:28','',''),(2418336,'1','57',NULL,174,'Sale Id shift 250248',314867.00,0.00,0.00,0.00,0.00,'2022-01-01 13:10:28','',''),(2418469,'1','57','447',174,'Sale Id shift 250461',0.00,0.00,0.00,609.00,0.00,'2022-01-01 13:29:06','',''),(2418470,'1','57',NULL,174,'Sale Id shift 250461',213150.00,0.00,0.00,0.00,0.00,'2022-01-01 13:29:06','',''),(2435596,'1','57','447',174,'Sale Id shift 250471',0.00,0.00,0.00,15.11,0.00,'2022-01-04 10:50:18','',''),(2435597,'1','57',NULL,174,'Sale Id shift 250471',5288.50,0.00,0.00,0.00,0.00,'2022-01-04 10:50:18','',''),(2436477,'1','57','447',174,'Sale Id shift 251124',0.00,0.00,0.00,956.89,0.00,'2022-01-04 12:17:02','',''),(2436478,'1','57',NULL,174,'Sale Id shift 251124',334911.50,0.00,0.00,0.00,0.00,'2022-01-04 12:17:02','',''),(2436890,'1','57','447',174,'Sale Id shift 251139',0.00,0.00,0.00,985.43,0.00,'2022-01-04 13:03:24','',''),(2436891,'1','57',NULL,174,'Sale Id shift 251139',344900.50,0.00,0.00,0.00,0.00,'2022-01-04 13:03:24','',''),(2437736,'1','57','447',174,'Sale Id shift 251157',0.00,0.00,0.00,929.60,0.00,'2022-01-04 14:15:17','',''),(2437737,'1','57',NULL,174,'Sale Id shift 251157',325360.00,0.00,0.00,0.00,0.00,'2022-01-04 14:15:17','',''),(2437784,'1','57','447',174,'Sale Id shift 251172',0.00,0.00,0.00,1409.15,0.00,'2022-01-04 14:19:42','',''),(2437785,'1','57',NULL,174,'Sale Id shift 251172',493202.50,0.00,0.00,0.00,0.00,'2022-01-04 14:19:42','',''),(2437843,'1','57','447',174,'Sale Id shift 251173',0.00,0.00,0.00,1036.70,0.00,'2022-01-04 14:24:33','',''),(2437844,'1','57',NULL,174,'Sale Id shift 251173',362845.00,0.00,0.00,0.00,0.00,'2022-01-04 14:24:33','',''),(2437909,'1','57','447',174,'Sale Id shift 251177',0.00,0.00,0.00,1053.35,0.00,'2022-01-04 14:30:34','',''),(2437910,'1','57',NULL,174,'Sale Id shift 251177',368672.50,0.00,0.00,0.00,0.00,'2022-01-04 14:30:34','',''),(2441917,'1','57','447',174,'Sale Id shift 251179',0.00,0.00,0.00,741.39,0.00,'2022-01-05 09:56:16','',''),(2441918,'1','57',NULL,174,'Sale Id shift 251179',259486.50,0.00,0.00,0.00,0.00,'2022-01-05 09:56:16','',''),(2447589,'1','57','447',174,'Sale Id shift 251348',0.00,0.00,0.00,640.87,0.00,'2022-01-05 19:03:05','',''),(2447590,'1','57',NULL,174,'Sale Id shift 251348',224304.50,0.00,0.00,0.00,0.00,'2022-01-05 19:03:05','',''),(2458570,'1','57','447',174,'Sale Id shift 251480',0.00,0.00,0.00,500.00,0.00,'2022-01-07 11:45:44','',''),(2458571,'1','57',NULL,174,'Sale Id shift 251480',175000.00,0.00,0.00,0.00,0.00,'2022-01-07 11:45:44','',''),(2459058,'1','57','447',174,'Sale Id shift 251852',0.00,0.00,0.00,481.70,0.00,'2022-01-07 12:42:00','',''),(2459059,'1','57',NULL,174,'Sale Id shift 251852',168595.00,0.00,0.00,0.00,0.00,'2022-01-07 12:42:00','',''),(2462125,'1','57','447',174,'Sale Id shift 251862',0.00,0.00,0.00,1097.28,0.00,'2022-01-07 17:54:13','',''),(2462126,'1','57',NULL,174,'Sale Id shift 251862',384048.00,0.00,0.00,0.00,0.00,'2022-01-07 17:54:13','',''),(2478863,'1','57','447',174,'Sale Id shift 251962',0.00,0.00,0.00,187.62,0.00,'2022-01-09 19:27:20','',''),(2478864,'1','57',NULL,174,'Sale Id shift 251962',65667.00,0.00,0.00,0.00,0.00,'2022-01-09 19:27:20','',''),(2481574,'1','57','447',174,'Sale Id shift 252568',0.00,0.00,0.00,1209.73,0.00,'2022-01-10 11:10:06','',''),(2481575,'1','57',NULL,174,'Sale Id shift 252568',423405.50,0.00,0.00,0.00,0.00,'2022-01-10 11:10:06','',''),(2481733,'1','57','447',174,'Sale Id shift 252572',0.00,0.00,0.00,1196.50,0.00,'2022-01-10 11:29:38','',''),(2481734,'1','57',NULL,174,'Sale Id shift 252572',418775.00,0.00,0.00,0.00,0.00,'2022-01-10 11:29:38','',''),(2481839,'1','57','447',174,'Sale Id shift 252576',0.00,0.00,0.00,349.93,0.00,'2022-01-10 11:43:10','',''),(2481840,'1','57',NULL,174,'Sale Id shift 252576',122475.50,0.00,0.00,0.00,0.00,'2022-01-10 11:43:10','',''),(2481897,'1','57','447',174,'Sale Id shift 252581',0.00,0.00,0.00,2006.28,0.00,'2022-01-10 11:50:17','',''),(2481898,'1','57',NULL,174,'Sale Id shift 252581',702198.00,0.00,0.00,0.00,0.00,'2022-01-10 11:50:17','',''),(2482394,'1','57','447',174,'Sale Id shift 252584',0.00,0.00,0.00,2009.40,0.00,'2022-01-10 12:34:50','',''),(2482395,'1','57',NULL,174,'Sale Id shift 252584',703290.00,0.00,0.00,0.00,0.00,'2022-01-10 12:34:50','',''),(2488376,'1','57','447',174,'Sale Id shift 252805',0.00,0.00,0.00,1520.37,0.00,'2022-01-11 10:33:40','',''),(2488377,'1','57',NULL,174,'Sale Id shift 252805',532129.50,0.00,0.00,0.00,0.00,'2022-01-11 10:33:40','',''),(2488472,'1','57','447',174,'Sale Id shift 252807',0.00,0.00,0.00,605.86,0.00,'2022-01-11 10:44:10','',''),(2488473,'1','57',NULL,174,'Sale Id shift 252807',212051.00,0.00,0.00,0.00,0.00,'2022-01-11 10:44:10','',''),(2493271,'1','57','447',174,'Sale Id shift 252897',0.00,0.00,0.00,219.94,0.00,'2022-01-11 18:54:42','',''),(2493272,'1','57',NULL,174,'Sale Id shift 252897',76979.00,0.00,0.00,0.00,0.00,'2022-01-11 18:54:42','',''),(2495683,'1','57','447',174,'Sale Id shift 252932',0.00,0.00,0.00,1590.31,0.00,'2022-01-12 09:56:02','',''),(2495684,'1','57',NULL,174,'Sale Id shift 252932',556608.50,0.00,0.00,0.00,0.00,'2022-01-12 09:56:02','',''),(2503461,'1','57','447',174,'Sale Id shift 253188',0.00,0.00,0.00,832.54,0.00,'2022-01-13 10:13:31','',''),(2503462,'1','57',NULL,174,'Sale Id shift 253188',291389.00,0.00,0.00,0.00,0.00,'2022-01-13 10:13:31','',''),(2503839,'1','57','447',174,'Sale Id shift 253287',0.00,0.00,0.00,1575.60,0.00,'2022-01-13 10:44:05','',''),(2503840,'1','57',NULL,174,'Sale Id shift 253287',551460.00,0.00,0.00,0.00,0.00,'2022-01-13 10:44:05','',''),(2506871,'1','57','447',174,'Sale Id shift 253299',0.00,0.00,0.00,1000.00,0.00,'2022-01-13 15:47:40','',''),(2506872,'1','57',NULL,174,'Sale Id shift 253299',350000.00,0.00,0.00,0.00,0.00,'2022-01-13 15:47:40','',''),(2510953,'1','57','447',174,'Sale Id shift 253408',0.00,0.00,0.00,954.00,0.00,'2022-01-14 09:49:06','',''),(2510954,'1','57',NULL,174,'Sale Id shift 253408',333900.00,0.00,0.00,0.00,0.00,'2022-01-14 09:49:06','',''),(2513753,'1','57','447',174,'Sale Id shift 253613',0.00,0.00,0.00,595.02,0.00,'2022-01-14 15:08:23','',''),(2513754,'1','57',NULL,174,'Sale Id shift 253613',208257.00,0.00,0.00,0.00,0.00,'2022-01-14 15:08:23','',''),(2519209,'1','57','447',174,'Sale Id shift 253635',0.00,0.00,0.00,548.00,0.00,'2022-01-15 10:45:22','',''),(2519210,'1','57',NULL,174,'Sale Id shift 253635',191800.00,0.00,0.00,0.00,0.00,'2022-01-15 10:45:22','',''),(2524337,'1','57','447',0,'Tank level zero out for dipping',0.00,0.00,0.00,395.00,0.00,'2022-01-15 17:37:57','',''),(2524338,'1','57','447',0,'Inventory adjustment from tank dipping to 1300',0.00,0.00,1300.00,0.00,0.00,'2022-01-15 17:37:57','',''),(2524343,'1','57','445',0,'Tank level zero out for dipping',0.00,0.00,0.00,743.52,0.00,'2022-01-15 17:38:19','',''),(2524344,'1','57','445',0,'Inventory adjustment from tank dipping to 400',0.00,0.00,400.00,0.00,0.00,'2022-01-15 17:38:19','',''),(2525425,'1','57','447',174,'Sale Id shift 253813',0.00,0.00,0.00,570.00,0.00,'2022-01-15 21:08:58','',''),(2525426,'1','57',NULL,174,'Sale Id shift 253813',199500.00,0.00,0.00,0.00,0.00,'2022-01-15 21:08:58','',''),(2531690,'1','57','447',174,'Sale Id shift 253921',0.00,0.00,0.00,624.91,0.00,'2022-01-16 16:11:00','',''),(2531691,'1','57',NULL,174,'Sale Id shift 253921',218718.50,0.00,0.00,0.00,0.00,'2022-01-16 16:11:00','',''),(2550561,'1','57',NULL,174,'Purchased from A.A RANO NIGERIA LIMITED',0.00,7000000.00,20000.00,0.00,0.00,'2022-01-19 10:42:37','',''),(2550724,'1','57',NULL,174,'Reception corrector for bridging 131379',0.00,0.00,0.00,20000.00,0.00,'2022-01-19 10:57:48','',''),(2550725,'1','57','447',174,'Received from bridging 131379',0.00,0.00,20000.00,0.00,0.00,'2022-01-19 10:57:48','',''),(2550862,'1','57','447',174,'Sale Id shift 254660',0.00,0.00,0.00,2202.91,0.00,'2022-01-19 11:10:54','',''),(2550863,'1','57',NULL,174,'Sale Id shift 254660',771018.50,0.00,0.00,0.00,0.00,'2022-01-19 11:10:54','',''),(2554550,'1','57','447',174,'Sale Id shift 254866',0.00,0.00,0.00,463.65,0.00,'2022-01-19 17:08:41','',''),(2554551,'1','57',NULL,174,'Sale Id shift 254866',162277.50,0.00,0.00,0.00,0.00,'2022-01-19 17:08:41','',''),(2557956,'1','57','447',174,'Sale Id shift 254912',0.00,0.00,0.00,452.00,0.00,'2022-01-20 10:08:28','',''),(2557957,'1','57',NULL,174,'Sale Id shift 254912',158200.00,0.00,0.00,0.00,0.00,'2022-01-20 10:08:28','',''),(2561567,'1','57','447',174,'Sale Id shift 255105',0.00,0.00,0.00,1691.26,0.00,'2022-01-20 15:43:43','',''),(2561568,'1','57',NULL,174,'Sale Id shift 255105',591941.00,0.00,0.00,0.00,0.00,'2022-01-20 15:43:43','',''),(2566095,'1','57','447',174,'Sale Id shift 255117',0.00,0.00,0.00,3180.75,0.00,'2022-01-21 09:46:58','',''),(2566096,'1','57',NULL,174,'Sale Id shift 255117',1113262.50,0.00,0.00,0.00,0.00,'2022-01-21 09:46:58','',''),(2570484,'1','57','447',174,'Sale Id shift 255308',0.00,0.00,0.00,615.64,0.00,'2022-01-21 16:36:38','',''),(2570485,'1','57',NULL,174,'Sale Id shift 255308',218552.20,0.00,0.00,0.00,0.00,'2022-01-21 16:36:38','',''),(2575094,'1','57','447',174,'Sale Id shift 255536',0.00,0.00,0.00,987.82,0.00,'2022-01-22 10:46:30','',''),(2575095,'1','57',NULL,174,'Sale Id shift 255536',350676.10,0.00,0.00,0.00,0.00,'2022-01-22 10:46:30','',''),(2580133,'1','57','447',174,'Sale Id shift 255626',0.00,0.00,0.00,1056.39,0.00,'2022-01-22 17:18:34','',''),(2580134,'1','57',NULL,174,'Sale Id shift 255626',375018.45,0.00,0.00,0.00,0.00,'2022-01-22 17:18:34','',''),(2585934,'1','57','447',174,'Sale Id shift 255681',0.00,0.00,0.00,1262.40,0.00,'2022-01-23 13:40:01','',''),(2585935,'1','57',NULL,174,'Sale Id shift 255681',448152.00,0.00,0.00,0.00,0.00,'2022-01-23 13:40:01','',''),(2588513,'1','57','447',174,'Sale Id shift 255864',0.00,0.00,0.00,17.66,0.00,'2022-01-23 17:18:58','',''),(2588514,'1','57',NULL,174,'Sale Id shift 255864',6269.30,0.00,0.00,0.00,0.00,'2022-01-23 17:18:58','',''),(2591302,'1','57','447',174,'Sale Id shift 255914',0.00,0.00,0.00,5557.22,0.00,'2022-01-24 09:47:04','',''),(2591303,'1','57',NULL,174,'Sale Id shift 255914',1972813.10,0.00,0.00,0.00,0.00,'2022-01-24 09:47:04','',''),(2595272,'1','57','447',174,'Sale Id shift 256112',0.00,0.00,0.00,1128.70,0.00,'2022-01-24 16:49:53','',''),(2595273,'1','57',NULL,174,'Sale Id shift 256112',400688.50,0.00,0.00,0.00,0.00,'2022-01-24 16:49:53','',''),(2601218,'1','57','447',174,'Sale Id shift 256122',0.00,0.00,0.00,724.44,0.00,'2022-01-25 14:09:02','',''),(2601219,'1','57',NULL,174,'Sale Id shift 256122',257176.20,0.00,0.00,0.00,0.00,'2022-01-25 14:09:02','',''),(2608081,'1','57','447',0,'Tank level zero out for dipping',0.00,0.00,0.00,764.25,0.00,'2022-01-26 11:16:20','',''),(2608082,'1','57','447',0,'Inventory adjustment from tank dipping to 1400',0.00,0.00,1400.00,0.00,0.00,'2022-01-26 11:16:20','',''),(2608176,'1','57','447',174,'Sale Id shift 256400',0.00,0.00,0.00,1001.13,0.00,'2022-01-26 11:26:49','',''),(2608177,'1','57',NULL,174,'Sale Id shift 256400',355401.15,0.00,0.00,0.00,0.00,'2022-01-26 11:26:49','',''),(2612770,'1','57',NULL,174,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2612960,'1','57',NULL,175,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613012,'1','57',NULL,173,'Balance from closing inventory values 2021-11-31 23:59:59',4961365.20,4950000.00,60000.00,60068.88,0.00,'2021-11-30 23:59:59','',''),(2613208,'1','57','446',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613376,'1','57','447',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613811,'1','57','468',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613878,'1','57','445',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,31670.00,30926.48,0.00,'2021-11-30 23:59:59','',''),(2613879,'1','57',NULL,174,'Purchased from A.A RANO NIGERIA LIMITED',0.00,7300000.00,20000.00,0.00,0.00,'2022-02-04 09:29:10','',''),(2613880,'1','57',NULL,174,'Reception corrector for bridging 131380',0.00,0.00,0.00,20000.00,0.00,'2022-02-04 10:17:40','',''),(2613881,'1','57','447',174,'Received from bridging 131380',0.00,0.00,20000.00,0.00,0.00,'2022-02-04 10:17:40','',''),(2613882,'1','57','447',174,'Sale Id shift 257161',0.00,0.00,0.00,1832.80,0.00,'2022-02-04 15:07:30','',''),(2613883,'1','57',NULL,174,'Sale Id shift 257161',668972.00,0.00,0.00,0.00,0.00,'2022-02-04 15:07:30','',''),(2613884,'1','57','447',174,'Sale Id shift 257162',0.00,0.00,0.00,3095.01,0.00,'2022-02-04 15:49:18','',''),(2613885,'1','57',NULL,174,'Sale Id shift 257162',1129678.65,0.00,0.00,0.00,0.00,'2022-02-04 15:49:18','',''),(2613886,'1','57','447',174,'Sale Id shift 257163',0.00,0.00,0.00,1337.36,0.00,'2022-02-05 20:52:11','',''),(2613887,'1','57',NULL,174,'Sale Id shift 257163',508196.80,0.00,0.00,0.00,0.00,'2022-02-05 20:52:11','',''),(2613888,'1','57','447',174,'Sale Id shift 257164',0.00,0.00,0.00,1826.68,0.00,'2022-02-06 09:14:33','',''),(2613889,'1','57',NULL,174,'Sale Id shift 257164',694138.40,0.00,0.00,0.00,0.00,'2022-02-06 09:14:33','',''),(2613890,'1','57','447',174,'Sale Id shift 257165',0.00,0.00,0.00,1126.85,0.00,'2022-02-06 09:26:37','',''),(2613891,'1','57',NULL,174,'Sale Id shift 257165',428203.00,0.00,0.00,0.00,0.00,'2022-02-06 09:26:37','',''),(2613892,'1','57','447',174,'Sale Id shift 257166',0.00,0.00,0.00,618.69,0.00,'2022-02-07 11:03:15','',''),(2613893,'1','57',NULL,174,'Sale Id shift 257166',235102.20,0.00,0.00,0.00,0.00,'2022-02-07 11:03:15','',''),(2613894,'1','57','447',174,'Sale Id shift 257167',0.00,0.00,0.00,1837.37,0.00,'2022-02-07 11:22:55','',''),(2613895,'1','57',NULL,174,'Sale Id shift 257167',698200.60,0.00,0.00,0.00,0.00,'2022-02-07 11:22:55','',''),(2613896,'1','57','447',174,'Sale Id shift 257168',0.00,0.00,0.00,1430.08,0.00,'2022-02-07 17:37:59','',''),(2613897,'1','57',NULL,174,'Sale Id shift 257168',543430.40,0.00,0.00,0.00,0.00,'2022-02-07 17:37:59','',''),(2613898,'1','57','447',174,'Sale Id shift 257169',0.00,0.00,0.00,1833.85,0.00,'2022-02-08 09:48:17','',''),(2613899,'1','57',NULL,174,'Sale Id shift 257169',696863.00,0.00,0.00,0.00,0.00,'2022-02-08 09:48:17','',''),(2613900,'1','57','447',174,'Sale Id shift 257170',0.00,0.00,0.00,976.18,0.00,'2022-02-09 08:51:10','',''),(2613901,'1','57',NULL,174,'Sale Id shift 257170',370948.40,0.00,0.00,0.00,0.00,'2022-02-09 08:51:10','',''),(2613902,'1','57','447',174,'Sale Id shift 257171',0.00,0.00,0.00,4352.42,0.00,'2022-02-09 11:15:52','',''),(2613903,'1','57',NULL,174,'Sale Id shift 257171',1653919.60,0.00,0.00,0.00,0.00,'2022-02-09 11:15:52','',''),(2613904,'1','57',NULL,174,'Purchased from A.A RANO NIGERIA LIMITED',0.00,12636000.00,32400.00,0.00,0.00,'2022-02-10 11:45:20','',''),(2613905,'1','57',NULL,174,'Reception corrector for bridging 131381',0.00,0.00,0.00,32400.00,0.00,'2022-02-10 14:06:51','',''),(2613906,'1','57','447',174,'Received from bridging 131381',0.00,0.00,32400.00,0.00,0.00,'2022-02-10 14:06:51','',''),(2613907,'1','57','447',174,'Sale Id shift 257175',0.00,0.00,0.00,3224.77,0.00,'2022-02-11 12:21:07','',''),(2613908,'1','57',NULL,174,'Sale Id shift 257175',1257660.30,0.00,0.00,0.00,0.00,'2022-02-11 12:21:07','',''),(2613909,'1','57','468',0,'Tank level zero out for dipping',0.00,0.00,0.00,0.00,0.00,'2022-02-11 12:29:50','',''),(2613910,'1','57','468',0,'Inventory adjustment from tank dipping to 400',0.00,0.00,400.00,0.00,0.00,'2022-02-11 12:29:50','',''),(2613911,'1','57','447',174,'Sale Id shift 257176',0.00,0.00,0.00,932.56,0.00,'2022-02-12 11:49:16','',''),(2613912,'1','57',NULL,174,'Sale Id shift 257176',363698.40,0.00,0.00,0.00,0.00,'2022-02-12 11:49:16','',''),(2613913,'1','57','447',174,'Sale Id shift 257177',0.00,0.00,0.00,1569.99,0.00,'2022-02-12 11:56:40','',''),(2613914,'1','57',NULL,174,'Sale Id shift 257177',612296.10,0.00,0.00,0.00,0.00,'2022-02-12 11:56:40','',''),(2613915,'1','57','447',174,'Sale Id shift 257178',0.00,0.00,0.00,630.84,0.00,'2022-02-13 21:21:20','',''),(2613916,'1','57',NULL,174,'Sale Id shift 257178',246027.60,0.00,0.00,0.00,0.00,'2022-02-13 21:21:20','',''),(2613917,'1','57','447',174,'Sale Id shift 257179',0.00,0.00,0.00,1302.21,0.00,'2022-02-14 12:28:26','',''),(2613918,'1','57',NULL,174,'Sale Id shift 257179',520884.00,0.00,0.00,0.00,0.00,'2022-02-14 12:28:26','',''),(2613919,'1','57','447',174,'Sale Id shift 257180',0.00,0.00,0.00,275.00,0.00,'2022-02-14 12:43:40','',''),(2613920,'1','57',NULL,174,'Sale Id shift 257180',110000.00,0.00,0.00,0.00,0.00,'2022-02-14 12:43:40','',''),(2613921,'1','57','447',174,'Sale Id shift 257181',0.00,0.00,0.00,3247.87,0.00,'2022-02-14 12:57:36','',''),(2613922,'1','57',NULL,174,'Sale Id shift 257181',1299148.00,0.00,0.00,0.00,0.00,'2022-02-14 12:57:36','',''),(2613923,'1','57','447',174,'Sale Id shift 257182',0.00,0.00,0.00,1204.24,0.00,'2022-02-15 10:49:30','',''),(2613924,'1','57',NULL,174,'Sale Id shift 257182',481696.00,0.00,0.00,0.00,0.00,'2022-02-15 10:49:30','',''),(2613925,'1','57','447',174,'Sale Id shift 257183',0.00,0.00,0.00,995.76,0.00,'2022-02-15 11:38:16','',''),(2613926,'1','57',NULL,174,'Sale Id shift 257183',398304.00,0.00,0.00,0.00,0.00,'2022-02-15 11:38:16','',''),(2613927,'1','57','447',174,'Sale Id shift 257184',0.00,0.00,0.00,433.23,0.00,'2022-02-15 18:19:58','',''),(2613928,'1','57',NULL,174,'Sale Id shift 257184',173292.00,0.00,0.00,0.00,0.00,'2022-02-15 18:19:58','',''),(2613929,'1','57','447',174,'Sale Id shift 257187',0.00,0.00,0.00,1367.12,0.00,'2022-02-16 13:54:49','',''),(2613930,'1','57',NULL,174,'Sale Id shift 257187',546848.00,0.00,0.00,0.00,0.00,'2022-02-16 13:54:49','',''),(2613931,'1','57','447',174,'Sale Id shift 257188',0.00,0.00,0.00,1017.08,0.00,'2022-02-17 10:56:52','',''),(2613932,'1','57',NULL,174,'Sale Id shift 257188',406832.00,0.00,0.00,0.00,0.00,'2022-02-17 10:56:52','',''),(2613933,'1','57','447',174,'Sale Id shift 257189',0.00,0.00,0.00,1826.69,0.00,'2022-02-17 11:34:26','',''),(2613934,'1','57',NULL,174,'Sale Id shift 257189',730676.00,0.00,0.00,0.00,0.00,'2022-02-17 11:34:26','',''),(2613935,'1','57','447',174,'Sale Id shift 257191',0.00,0.00,0.00,2.68,0.00,'2022-02-18 12:09:47','',''),(2613936,'1','57',NULL,174,'Sale Id shift 257191',1072.00,0.00,0.00,0.00,0.00,'2022-02-18 12:09:47','',''),(2613937,'1','57','447',174,'Sale Id shift 257192',0.00,0.00,0.00,457.58,0.00,'2022-02-18 12:34:14','',''),(2613938,'1','57',NULL,174,'Sale Id shift 257192',187607.80,0.00,0.00,0.00,0.00,'2022-02-18 12:34:14','',''),(2613939,'1','57','447',174,'Sale Id shift 257193',0.00,0.00,0.00,436.94,0.00,'2022-02-19 10:38:40','',''),(2613940,'1','57',NULL,174,'Sale Id shift 257193',179145.40,0.00,0.00,0.00,0.00,'2022-02-19 10:38:40','',''),(2613941,'1','57','447',174,'Sale Id shift 257194',0.00,0.00,0.00,520.15,0.00,'2022-02-19 10:48:42','',''),(2613942,'1','57',NULL,174,'Sale Id shift 257194',213261.50,0.00,0.00,0.00,0.00,'2022-02-19 10:48:42','',''),(2613943,'1','57','447',174,'Sale Id shift 257195',0.00,0.00,0.00,2149.00,0.00,'2022-02-19 20:58:35','',''),(2613944,'1','57',NULL,174,'Sale Id shift 257195',881090.00,0.00,0.00,0.00,0.00,'2022-02-19 20:58:35','',''),(2613945,'1','57','447',174,'Sale Id shift 257196',0.00,0.00,0.00,202.49,0.00,'2022-02-20 19:31:22','',''),(2613946,'1','57',NULL,174,'Sale Id shift 257196',83020.90,0.00,0.00,0.00,0.00,'2022-02-20 19:31:22','',''),(2613947,'1','57','447',174,'Sale Id shift 257197',0.00,0.00,0.00,4.15,0.00,'2022-02-21 10:29:56','',''),(2613948,'1','57',NULL,174,'Sale Id shift 257197',1701.50,0.00,0.00,0.00,0.00,'2022-02-21 10:29:56','',''),(2613949,'1','57','447',174,'Sale Id shift 257198',0.00,0.00,0.00,1595.04,0.00,'2022-02-21 13:50:46','',''),(2613950,'1','57',NULL,174,'Sale Id shift 257198',653966.40,0.00,0.00,0.00,0.00,'2022-02-21 13:50:46','',''),(2613951,'1','57','447',174,'Sale Id shift 257199',0.00,0.00,0.00,1930.76,0.00,'2022-02-21 17:29:59','',''),(2613952,'1','57',NULL,174,'Sale Id shift 257199',791611.60,0.00,0.00,0.00,0.00,'2022-02-21 17:29:59','',''),(2613953,'1','57','447',174,'Sale Id shift 257200',0.00,0.00,0.00,954.00,0.00,'2022-02-22 10:46:52','',''),(2613954,'1','57',NULL,174,'Sale Id shift 257200',391140.00,0.00,0.00,0.00,0.00,'2022-02-22 10:46:52','',''),(2613955,'1','57','447',174,'Sale Id shift 257201',0.00,0.00,0.00,55.41,0.00,'2022-02-23 10:34:45','',''),(2613956,'1','57',NULL,174,'Sale Id shift 257201',22718.10,0.00,0.00,0.00,0.00,'2022-02-23 10:34:45','',''),(2613957,'1','57','447',174,'Sale Id shift 257202',0.00,0.00,0.00,2007.08,0.00,'2022-02-23 11:33:26','',''),(2613958,'1','57',NULL,174,'Sale Id shift 257202',822902.80,0.00,0.00,0.00,0.00,'2022-02-23 11:33:26','',''),(2613959,'1','57','447',174,'Sale Id shift 257203',0.00,0.00,0.00,2420.67,0.00,'2022-02-23 23:00:04','',''),(2613960,'1','57',NULL,174,'Sale Id shift 257203',992474.70,0.00,0.00,0.00,0.00,'2022-02-23 23:00:04','',''),(2613961,'1','57','447',174,'Sale Id shift 257204',0.00,0.00,0.00,1104.97,0.00,'2022-02-24 10:22:56','',''),(2613962,'1','57',NULL,174,'Sale Id shift 257204',453037.70,0.00,0.00,0.00,0.00,'2022-02-24 10:22:56','',''),(2613963,'1','57',NULL,174,'Purchased from A.A RANO NIGERIA LIMITED',0.00,8200000.00,20000.00,0.00,0.00,'2022-02-24 12:54:27','',''),(2613964,'1','57',NULL,174,'Reception corrector for bridging 131382',0.00,0.00,0.00,20000.00,0.00,'2022-02-24 17:06:06','',''),(2613965,'1','57','447',174,'Received from bridging 131382',0.00,0.00,20000.00,0.00,0.00,'2022-02-24 17:06:06','',''),(2613966,'1','57','447',174,'Sale Id shift 257205',0.00,0.00,0.00,3615.01,0.00,'2022-02-25 11:01:13','',''),(2613967,'1','57',NULL,174,'Sale Id shift 257205',1482154.10,0.00,0.00,0.00,0.00,'2022-02-25 11:01:13','',''),(2613968,'1','57','447',174,'Sale Id shift 257206',0.00,0.00,0.00,785.73,0.00,'2022-02-25 11:15:36','',''),(2613969,'1','57',NULL,174,'Sale Id shift 257206',322149.30,0.00,0.00,0.00,0.00,'2022-02-25 11:15:36','',''),(2613970,'1','57','447',174,'Sale Id shift 257207',0.00,0.00,0.00,1780.44,0.00,'2022-02-25 15:10:58','',''),(2613971,'1','57',NULL,174,'Sale Id shift 257207',729980.40,0.00,0.00,0.00,0.00,'2022-02-25 15:10:58','',''),(2613972,'1','57','447',174,'Sale Id shift 257208',0.00,0.00,0.00,112.41,0.00,'2022-02-26 16:55:10','',''),(2613973,'1','57',NULL,174,'Sale Id shift 257208',46088.10,0.00,0.00,0.00,0.00,'2022-02-26 16:55:10','',''),(2613974,'1','57','447',174,'Sale Id shift 257209',0.00,0.00,0.00,1391.72,0.00,'2022-02-27 09:35:36','',''),(2613975,'1','57',NULL,174,'Sale Id shift 257209',577563.80,0.00,0.00,0.00,0.00,'2022-02-27 09:35:36','',''),(2613976,'1','57','447',174,'Sale Id shift 257210',0.00,0.00,0.00,750.04,0.00,'2022-02-28 10:25:00','',''),(2613977,'1','57',NULL,174,'Sale Id shift 257210',311266.60,0.00,0.00,0.00,0.00,'2022-02-28 10:25:00','',''),(2613978,'1','57','447',174,'Sale Id shift 257211',0.00,0.00,0.00,2596.09,0.00,'2022-02-28 10:47:48','',''),(2613979,'1','57',NULL,174,'Sale Id shift 257211',1077377.35,0.00,0.00,0.00,0.00,'2022-02-28 10:47:48','',''),(2613980,'1','57','447',174,'Sale Id shift 257212',0.00,0.00,0.00,3520.00,0.00,'2022-02-28 14:20:36','',''),(2613981,'1','57',NULL,174,'Sale Id shift 257212',1460800.00,0.00,0.00,0.00,0.00,'2022-02-28 14:20:36','',''),(2613982,'1','57','447',174,'Sale Id shift 257213',0.00,0.00,0.00,1723.83,0.00,'2022-02-28 15:18:13','',''),(2613983,'1','57',NULL,174,'Sale Id shift 257213',715389.45,0.00,0.00,0.00,0.00,'2022-02-28 15:18:13','',''),(2613984,'1','57','447',174,'Sale Id shift 257214',0.00,0.00,0.00,600.05,0.00,'2022-03-01 18:09:48','',''),(2613985,'1','57',NULL,174,'Sale Id shift 257214',249020.75,0.00,0.00,0.00,0.00,'2022-03-01 18:09:48','',''),(2613986,'1','57','447',174,'Sale Id shift 257215',0.00,0.00,0.00,1020.32,0.00,'2022-03-01 18:17:12','',''),(2613987,'1','57',NULL,174,'Sale Id shift 257215',423432.80,0.00,0.00,0.00,0.00,'2022-03-01 18:17:12','',''),(2613988,'1','57','447',174,'Sale Id shift 257216',0.00,0.00,0.00,2767.00,0.00,'2022-03-02 17:41:59','',''),(2613989,'1','57',NULL,174,'Sale Id shift 257216',1148305.00,0.00,0.00,0.00,0.00,'2022-03-02 17:41:59','',''),(2613990,'1','57',NULL,174,'Purchased from A.A RANO NIGERIA LIMITED',0.00,9890000.00,23000.00,0.00,0.00,'2022-03-03 22:12:21','',''),(2613991,'1','57',NULL,174,'Reception corrector for bridging 131383',0.00,0.00,0.00,23000.00,0.00,'2022-03-04 09:11:15','',''),(2613992,'1','57','447',174,'Received from bridging 131383',0.00,0.00,23000.00,0.00,0.00,'2022-03-04 09:11:15','',''),(2613993,'1','57','447',174,'Sale Id shift 257220',0.00,0.00,0.00,1126.59,0.00,'2022-03-04 13:44:12','',''),(2613994,'1','57',NULL,174,'Sale Id shift 257220',484433.70,0.00,0.00,0.00,0.00,'2022-03-04 13:44:12','',''),(2613995,'1','57','447',174,'Sale Id shift 257221',0.00,0.00,0.00,2181.77,0.00,'2022-03-04 16:26:37','',''),(2613996,'1','57',NULL,174,'Sale Id shift 257221',938161.10,0.00,0.00,0.00,0.00,'2022-03-04 16:26:37','',''),(2613997,'1','57','447',174,'Sale Id shift 257222',0.00,0.00,0.00,1052.61,0.00,'2022-03-05 09:48:06','',''),(2613998,'1','57',NULL,174,'Sale Id shift 257222',452622.30,0.00,0.00,0.00,0.00,'2022-03-05 09:48:06','',''),(2613999,'1','57','447',174,'Sale Id shift 257223',0.00,0.00,0.00,947.79,0.00,'2022-03-05 11:56:44','',''),(2614000,'1','57',NULL,174,'Sale Id shift 257223',435983.40,0.00,0.00,0.00,0.00,'2022-03-05 11:56:44','',''),(2614001,'1','57','447',174,'Sale Id shift 257224',0.00,0.00,0.00,4459.96,0.00,'2022-03-07 02:14:47','',''),(2614002,'1','57',NULL,174,'Sale Id shift 257224',2051581.60,0.00,0.00,0.00,0.00,'2022-03-07 02:14:47','',''),(2614003,'1','57','447',174,'Sale Id shift 257225',0.00,0.00,0.00,499.07,0.00,'2022-03-07 08:25:20','',''),(2614004,'1','57',NULL,174,'Sale Id shift 257225',249535.00,0.00,0.00,0.00,0.00,'2022-03-07 08:25:20','',''),(2614005,'1','57','447',174,'Sale Id shift 257226',0.00,0.00,0.00,2112.08,0.00,'2022-03-07 08:35:22','',''),(2614006,'1','57',NULL,174,'Sale Id shift 257226',1056040.00,0.00,0.00,0.00,0.00,'2022-03-07 08:35:22','',''),(2614007,'1','57','447',174,'Sale Id shift 257228',0.00,0.00,0.00,1820.01,0.00,'2022-03-07 11:27:11','',''),(2614008,'1','57',NULL,174,'Sale Id shift 257228',910005.00,0.00,0.00,0.00,0.00,'2022-03-07 11:27:11','',''),(2614009,'1','57','447',174,'Sale Id shift 257229',0.00,0.00,0.00,2000.00,0.00,'2022-03-07 17:01:15','',''),(2614010,'1','57',NULL,174,'Sale Id shift 257229',1000000.00,0.00,0.00,0.00,0.00,'2022-03-07 17:01:15','',''),(2614011,'1','57','447',174,'Sale Id shift 257230',0.00,0.00,0.00,2.00,0.00,'2022-03-08 14:18:04','',''),(2614012,'1','57',NULL,174,'Sale Id shift 257230',1000.00,0.00,0.00,0.00,0.00,'2022-03-08 14:18:04','',''),(2614013,'1','57','447',174,'Sale Id shift 257231',0.00,0.00,0.00,2003.28,0.00,'2022-03-09 08:33:21','',''),(2614014,'1','57',NULL,174,'Sale Id shift 257231',1001640.00,0.00,0.00,0.00,0.00,'2022-03-09 08:33:21','',''),(2614015,'1','57','447',174,'Sale Id shift 257232',0.00,0.00,0.00,202.02,0.00,'2022-03-09 10:20:21','',''),(2614016,'1','57',NULL,174,'Sale Id shift 257232',121212.00,0.00,0.00,0.00,0.00,'2022-03-09 10:20:21','',''),(2614017,'1','57','447',174,'Sale Id shift 257233',0.00,0.00,0.00,0.50,0.00,'2022-03-10 10:44:36','',''),(2614018,'1','57',NULL,174,'Sale Id shift 257233',300.00,0.00,0.00,0.00,0.00,'2022-03-10 10:44:36','',''),(2614019,'1','57','447',174,'Sale Id shift 257234',0.00,0.00,0.00,0.50,0.00,'2022-03-10 16:44:14','',''),(2614020,'1','57',NULL,174,'Sale Id shift 257234',300.00,0.00,0.00,0.00,0.00,'2022-03-10 16:44:14','',''),(2614021,'1','57','447',174,'Sale Id shift 257235',0.00,0.00,0.00,1558.24,0.00,'2022-03-10 16:50:52','',''),(2614022,'1','57',NULL,174,'Sale Id shift 257235',934944.00,0.00,0.00,0.00,0.00,'2022-03-10 16:50:52','',''),(2614023,'1','57','447',174,'Sale Id shift 257236',0.00,0.00,0.00,2505.83,0.00,'2022-03-11 11:44:56','',''),(2614024,'1','57',NULL,174,'Sale Id shift 257236',1503498.00,0.00,0.00,0.00,0.00,'2022-03-11 11:44:56','',''),(2614025,'1','57','447',174,'Sale Id shift 257237',0.00,0.00,0.00,501.99,0.00,'2022-03-11 21:21:53','',''),(2614026,'1','57',NULL,174,'Sale Id shift 257237',301194.00,0.00,0.00,0.00,0.00,'2022-03-11 21:21:53','',''),(2614027,'1','57','468',0,'Tank level zero out for dipping',0.00,0.00,0.00,400.00,0.00,'2022-03-12 11:05:45','',''),(2614028,'1','57','468',0,'Inventory adjustment from tank dipping to 700',0.00,0.00,700.00,0.00,0.00,'2022-03-12 11:05:45','',''),(2614029,'1','57','468',0,'Tank level zero out for dipping',0.00,0.00,0.00,700.00,0.00,'2022-03-12 13:57:00','',''),(2614030,'1','57','468',0,'Inventory adjustment from tank dipping to 400',0.00,0.00,400.00,0.00,0.00,'2022-03-12 13:57:00','',''),(2614031,'1','57','447',0,'Tank level zero out for dipping',0.00,0.00,0.00,26.42,0.00,'2022-03-12 13:57:23','',''),(2614032,'1','57','447',0,'Inventory adjustment from tank dipping to 326',0.00,0.00,326.00,0.00,0.00,'2022-03-12 13:57:23','',''),(2614033,'1','57','447',174,'Sale Id shift 257238',0.00,0.00,0.00,232.00,0.00,'2022-03-12 22:18:04','',''),(2614034,'1','57',NULL,174,'Sale Id shift 257238',139200.00,0.00,0.00,0.00,0.00,'2022-03-12 22:18:04','',''),(2614035,'1','57',NULL,174,'Purchased from A.A RANO NIGERIA LIMITED',0.00,11900000.00,17000.00,0.00,0.00,'2022-03-27 17:59:48','',''),(2614036,'1','57',NULL,174,'Reception corrector for bridging 131384',0.00,0.00,0.00,17000.00,0.00,'2022-03-28 10:11:39','',''),(2614037,'1','57','447',174,'Received from bridging 131384',0.00,0.00,17000.00,0.00,0.00,'2022-03-28 10:11:39','',''),(2614038,'1','57','447',174,'Sale Id shift 257240',0.00,0.00,0.00,412.72,0.00,'2022-03-28 10:44:02','',''),(2614039,'1','57',NULL,174,'Sale Id shift 257240',288904.00,0.00,0.00,0.00,0.00,'2022-03-28 10:44:02','',''),(2614040,'1','57','447',174,'Sale Id shift 257241',0.00,0.00,0.00,1011.57,0.00,'2022-03-28 20:24:40','',''),(2614041,'1','57',NULL,174,'Sale Id shift 257241',708099.00,0.00,0.00,0.00,0.00,'2022-03-28 20:24:40','',''),(2614042,'1','57','447',174,'Sale Id shift 257242',0.00,0.00,0.00,25.71,0.00,'2022-03-29 11:37:17','',''),(2614043,'1','57',NULL,174,'Sale Id shift 257242',17997.00,0.00,0.00,0.00,0.00,'2022-03-29 11:37:17','',''),(2614044,'1','57','447',174,'Sale Id shift 257243',0.00,0.00,0.00,310.29,0.00,'2022-03-29 18:25:01','',''),(2614045,'1','57',NULL,174,'Sale Id shift 257243',217203.00,0.00,0.00,0.00,0.00,'2022-03-29 18:25:01','',''),(2614046,'1','57','447',174,'Sale Id shift 257244',0.00,0.00,0.00,320.71,0.00,'2022-03-30 09:38:58','',''),(2614047,'1','57',NULL,174,'Sale Id shift 257244',224497.00,0.00,0.00,0.00,0.00,'2022-03-30 09:38:58','',''),(2614048,'1','57','447',174,'Sale Id shift 257245',0.00,0.00,0.00,26.99,0.00,'2022-03-31 09:39:41','',''),(2614049,'1','57',NULL,174,'Sale Id shift 257245',18893.00,0.00,0.00,0.00,0.00,'2022-03-31 09:39:41','',''),(2614050,'1','57','447',174,'Sale Id shift 257247',0.00,0.00,0.00,9.99,0.00,'2022-04-01 10:34:18','',''),(2614051,'1','57',NULL,174,'Sale Id shift 257247',6993.00,0.00,0.00,0.00,0.00,'2022-04-01 10:34:18','',''),(2614052,'1','57','447',174,'Sale Id shift 257248',0.00,0.00,0.00,30.00,0.00,'2022-04-01 11:10:18','',''),(2614053,'1','57',NULL,174,'Sale Id shift 257248',21000.00,0.00,0.00,0.00,0.00,'2022-04-01 11:10:18','',''),(2614054,'1','57','447',174,'Sale Id shift 257249',0.00,0.00,0.00,13.15,0.00,'2022-04-02 12:30:30','',''),(2614055,'1','57',NULL,174,'Sale Id shift 257249',9205.00,0.00,0.00,0.00,0.00,'2022-04-02 12:30:30','',''),(2614056,'1','57','447',174,'Sale Id shift 257250',0.00,0.00,0.00,93.46,0.00,'2022-04-02 23:01:04','',''),(2614057,'1','57',NULL,174,'Sale Id shift 257250',65422.00,0.00,0.00,0.00,0.00,'2022-04-02 23:01:04','',''),(2614058,'1','57','447',174,'Sale Id shift 257251',0.00,0.00,0.00,112.01,0.00,'2022-04-02 23:10:48','',''),(2614059,'1','57',NULL,174,'Sale Id shift 257251',78407.00,0.00,0.00,0.00,0.00,'2022-04-02 23:10:48','',''),(2614060,'1','57','447',174,'Sale Id shift 257252',0.00,0.00,0.00,2428.83,0.00,'2022-04-02 23:15:17','',''),(2614061,'1','57',NULL,174,'Sale Id shift 257252',1700181.00,0.00,0.00,0.00,0.00,'2022-04-02 23:15:17','',''),(2614062,'1','57','447',174,'Sale Id shift 257253',0.00,0.00,0.00,7.14,0.00,'2022-04-04 09:33:10','',''),(2614063,'1','57',NULL,174,'Sale Id shift 257253',4998.00,0.00,0.00,0.00,0.00,'2022-04-04 09:33:10','',''),(2614064,'1','57','447',174,'Sale Id shift 257254',0.00,0.00,0.00,9.60,0.00,'2022-04-04 11:00:42','',''),(2614065,'1','57',NULL,174,'Sale Id shift 257254',6720.00,0.00,0.00,0.00,0.00,'2022-04-04 11:00:42','',''),(2614066,'1','57','447',174,'Sale Id shift 257255',0.00,0.00,0.00,92.56,0.00,'2022-04-05 09:59:59','',''),(2614067,'1','57',NULL,174,'Sale Id shift 257255',64792.00,0.00,0.00,0.00,0.00,'2022-04-05 09:59:59','',''),(2614068,'1','57','447',174,'Sale Id shift 257256',0.00,0.00,0.00,49.28,0.00,'2022-04-05 11:29:40','',''),(2614069,'1','57',NULL,174,'Sale Id shift 257256',34496.00,0.00,0.00,0.00,0.00,'2022-04-05 11:29:40','',''),(2614070,'1','57','447',174,'Sale Id shift 257257',0.00,0.00,0.00,60.00,0.00,'2022-04-05 22:42:40','',''),(2614071,'1','57',NULL,174,'Sale Id shift 257257',42000.00,0.00,0.00,0.00,0.00,'2022-04-05 22:42:40','',''),(2614072,'1','57','447',174,'Sale Id shift 257259',0.00,0.00,0.00,43.29,0.00,'2022-04-06 14:51:53','',''),(2614073,'1','57',NULL,174,'Sale Id shift 257259',30303.00,0.00,0.00,0.00,0.00,'2022-04-06 14:51:53','',''),(2614074,'1','57','447',174,'Sale Id shift 257260',0.00,0.00,0.00,26.59,0.00,'2022-04-07 10:00:08','',''),(2614075,'1','57',NULL,174,'Sale Id shift 257260',18613.00,0.00,0.00,0.00,0.00,'2022-04-07 10:00:08','',''),(2614076,'1','57','447',174,'Sale Id shift 257261',0.00,0.00,0.00,1.20,0.00,'2022-04-07 11:15:29','',''),(2614077,'1','57',NULL,174,'Sale Id shift 257261',840.00,0.00,0.00,0.00,0.00,'2022-04-07 11:15:29','',''),(2614078,'1','57','447',174,'Sale Id shift 257263',0.00,0.00,0.00,3.12,0.00,'2022-04-08 11:34:56','',''),(2614079,'1','57',NULL,174,'Sale Id shift 257263',2184.00,0.00,0.00,0.00,0.00,'2022-04-08 11:34:56','',''),(2614080,'1','57','447',174,'Sale Id shift 257265',0.00,0.00,0.00,123.68,0.00,'2022-04-09 16:48:23','',''),(2614081,'1','57',NULL,174,'Sale Id shift 257265',86576.00,0.00,0.00,0.00,0.00,'2022-04-09 16:48:23','',''),(2614082,'1','57','447',174,'Sale Id shift 257267',0.00,0.00,0.00,13.43,0.00,'2022-04-11 10:16:49','',''),(2614083,'1','57',NULL,174,'Sale Id shift 257267',9401.00,0.00,0.00,0.00,0.00,'2022-04-11 10:16:49','',''),(2614084,'1','57','447',174,'Sale Id shift 257269',0.00,0.00,0.00,844.21,0.00,'2022-04-11 10:37:15','',''),(2614085,'1','57',NULL,174,'Sale Id shift 257269',590947.00,0.00,0.00,0.00,0.00,'2022-04-11 10:37:15','',''),(2614086,'1','57','447',174,'Sale Id shift 257270',0.00,0.00,0.00,335.00,0.00,'2022-04-12 09:28:51','',''),(2614087,'1','57',NULL,174,'Sale Id shift 257270',234500.00,0.00,0.00,0.00,0.00,'2022-04-12 09:28:51','',''),(2614088,'1','57','447',174,'Sale Id shift 257271',0.00,0.00,0.00,217.14,0.00,'2022-04-12 10:55:57','',''),(2614089,'1','57',NULL,174,'Sale Id shift 257271',151998.00,0.00,0.00,0.00,0.00,'2022-04-12 10:55:57','',''),(2614090,'1','57','447',174,'Sale Id shift 257272',0.00,0.00,0.00,539.00,0.00,'2022-04-13 09:09:03','',''),(2614091,'1','57',NULL,174,'Sale Id shift 257272',377300.00,0.00,0.00,0.00,0.00,'2022-04-13 09:09:03','',''),(2614092,'1','57','447',174,'Sale Id shift 257273',0.00,0.00,0.00,546.15,0.00,'2022-04-13 13:23:15','',''),(2614093,'1','57',NULL,174,'Sale Id shift 257273',382305.00,0.00,0.00,0.00,0.00,'2022-04-13 13:23:15','',''),(2614094,'1','57','447',174,'Sale Id shift 257275',0.00,0.00,0.00,5.64,0.00,'2022-04-14 11:43:56','',''),(2614095,'1','57',NULL,174,'Sale Id shift 257275',3948.00,0.00,0.00,0.00,0.00,'2022-04-14 11:43:56','',''),(2614096,'1','57','447',174,'Sale Id shift 257276',0.00,0.00,0.00,53.91,0.00,'2022-04-14 18:03:27','',''),(2614097,'1','57',NULL,174,'Sale Id shift 257276',37737.00,0.00,0.00,0.00,0.00,'2022-04-14 18:03:27','',''),(2614098,'1','57','447',174,'Sale Id shift 257278',0.00,0.00,0.00,5.43,0.00,'2022-04-16 11:49:03','',''),(2614099,'1','57',NULL,174,'Sale Id shift 257278',3801.00,0.00,0.00,0.00,0.00,'2022-04-16 11:49:03','',''),(2614100,'1','57','447',174,'Sale Id shift 257279',0.00,0.00,0.00,126.29,0.00,'2022-04-16 13:55:15','',''),(2614101,'1','57',NULL,174,'Sale Id shift 257279',88403.00,0.00,0.00,0.00,0.00,'2022-04-16 13:55:15','',''),(2614102,'1','57','447',174,'Sale Id shift 257280',0.00,0.00,0.00,4.14,0.00,'2022-04-17 17:44:05','',''),(2614103,'1','57',NULL,174,'Sale Id shift 257280',2898.00,0.00,0.00,0.00,0.00,'2022-04-17 17:44:05','',''),(2614104,'1','57','447',174,'Sale Id shift 257281',0.00,0.00,0.00,1012.14,0.00,'2022-04-18 08:17:57','',''),(2614105,'1','57',NULL,174,'Sale Id shift 257281',708498.00,0.00,0.00,0.00,0.00,'2022-04-18 08:17:57','',''),(2614106,'1','57','447',174,'Sale Id shift 257282',0.00,0.00,0.00,984.00,0.00,'2022-04-18 09:31:34','',''),(2614107,'1','57',NULL,174,'Sale Id shift 257282',688800.00,0.00,0.00,0.00,0.00,'2022-04-18 09:31:34','',''),(2614108,'1','57','447',174,'Sale Id shift 257283',0.00,0.00,0.00,4.00,0.00,'2022-04-18 14:53:28','',''),(2614109,'1','57',NULL,174,'Sale Id shift 257283',2800.00,0.00,0.00,0.00,0.00,'2022-04-18 14:53:28','',''),(2614110,'1','57','447',174,'Sale Id shift 257285',0.00,0.00,0.00,62.00,0.00,'2022-04-19 21:23:30','',''),(2614111,'1','57',NULL,174,'Sale Id shift 257285',43400.00,0.00,0.00,0.00,0.00,'2022-04-19 21:23:30','',''),(2614112,'1','57','447',174,'Sale Id shift 257286',0.00,0.00,0.00,200.00,0.00,'2022-04-19 21:27:46','',''),(2614113,'1','57',NULL,174,'Sale Id shift 257286',140000.00,0.00,0.00,0.00,0.00,'2022-04-19 21:27:46','',''),(2614114,'1','57','447',174,'Sale Id shift 257287',0.00,0.00,0.00,341.80,0.00,'2022-04-20 11:21:48','',''),(2614115,'1','57',NULL,174,'Sale Id shift 257287',239260.00,0.00,0.00,0.00,0.00,'2022-04-20 11:21:48','',''),(2614116,'1','57','447',174,'Sale Id shift 257288',0.00,0.00,0.00,500.00,0.00,'2022-04-21 04:50:49','',''),(2614117,'1','57',NULL,174,'Sale Id shift 257288',332500.00,0.00,0.00,0.00,0.00,'2022-04-21 04:50:49','',''),(2614118,'1','57','447',174,'Sale Id shift 257289',0.00,0.00,0.00,299.95,0.00,'2022-04-21 12:44:39','',''),(2614119,'1','57',NULL,174,'Sale Id shift 257289',199466.75,0.00,0.00,0.00,0.00,'2022-04-21 12:44:39','',''),(2614120,'1','57','447',174,'Sale Id shift 257290',0.00,0.00,0.00,742.75,0.00,'2022-04-22 10:32:52','',''),(2614121,'1','57',NULL,174,'Sale Id shift 257290',493928.75,0.00,0.00,0.00,0.00,'2022-04-22 10:32:52','',''),(2614122,'1','57','447',174,'Sale Id shift 257291',0.00,0.00,0.00,1435.59,0.00,'2022-04-22 15:42:31','',''),(2614123,'1','57',NULL,174,'Sale Id shift 257291',954667.35,0.00,0.00,0.00,0.00,'2022-04-22 15:42:31','',''),(2614124,'1','57','447',174,'Sale Id shift 257292',0.00,0.00,0.00,554.05,0.00,'2022-04-23 08:21:31','',''),(2614125,'1','57',NULL,174,'Sale Id shift 257292',368443.25,0.00,0.00,0.00,0.00,'2022-04-23 08:21:31','',''),(2614126,'1','57','447',174,'Sale Id shift 257293',0.00,0.00,0.00,481.96,0.00,'2022-04-23 12:08:58','',''),(2614127,'1','57',NULL,174,'Sale Id shift 257293',320503.40,0.00,0.00,0.00,0.00,'2022-04-23 12:08:58','',''),(2614128,'1','57','447',174,'Sale Id shift 257295',0.00,0.00,0.00,369.02,0.00,'2022-04-24 21:22:11','',''),(2614129,'1','57',NULL,174,'Sale Id shift 257295',245398.30,0.00,0.00,0.00,0.00,'2022-04-24 21:22:11','',''),(2614130,'1','57','447',174,'Sale Id shift 257297',0.00,0.00,0.00,854.42,0.00,'2022-04-25 20:57:31','',''),(2614131,'1','57',NULL,174,'Sale Id shift 257297',568189.30,0.00,0.00,0.00,0.00,'2022-04-25 20:57:31','',''),(2614132,'1','57','447',174,'Sale Id shift 257298',0.00,0.00,0.00,873.87,0.00,'2022-04-25 22:42:15','',''),(2614133,'1','57',NULL,174,'Sale Id shift 257298',581123.55,0.00,0.00,0.00,0.00,'2022-04-25 22:42:15','',''),(2614134,'1','57','447',174,'Sale Id shift 257299',0.00,0.00,0.00,459.51,0.00,'2022-04-26 10:34:01','',''),(2614135,'1','57',NULL,174,'Sale Id shift 257299',305574.15,0.00,0.00,0.00,0.00,'2022-04-26 10:34:01','',''),(2614136,'1','57','445',0,'Tank level zero out for dipping',0.00,0.00,0.00,400.00,0.00,'2022-06-07 11:22:39','',''),(2614137,'1','57','445',0,'Inventory adjustment from tank dipping to 300',0.00,0.00,300.00,0.00,0.00,'2022-06-07 11:22:39','',''),(2614138,'1','57','447',0,'Tank level zero out for dipping',0.00,0.00,0.00,16.71,0.00,'2022-06-07 11:23:20','',''),(2614139,'1','57','447',0,'Inventory adjustment from tank dipping to 200',0.00,0.00,200.00,0.00,0.00,'2022-06-07 11:23:20','',''),(2614140,'1','57',NULL,174,'Purchased from A.A RANO NIGERIA LIMITED',0.00,11600000.00,14500.00,0.00,0.00,'2022-09-02 17:53:37','',''),(2614141,'1','57',NULL,174,'Reception corrector for bridging 131386',0.00,0.00,0.00,14500.00,0.00,'2022-09-02 18:00:23','',''),(2614142,'1','57','447',174,'Received from bridging 131386',0.00,0.00,14500.00,0.00,0.00,'2022-09-02 18:00:23','',''),(2614143,'1','57','447',174,'Sale Id shift 257301',0.00,0.00,0.00,167.74,0.00,'2022-09-03 14:02:17','',''),(2614144,'1','57',NULL,174,'Sale Id shift 257301',134192.00,0.00,0.00,0.00,0.00,'2022-09-03 14:02:17','',''),(2614145,'1','57','447',174,'Sale Id shift 257302',0.00,0.00,0.00,603.73,0.00,'2022-09-03 20:21:34','',''),(2614146,'1','57',NULL,174,'Sale Id shift 257302',482984.00,0.00,0.00,0.00,0.00,'2022-09-03 20:21:34','',''),(2614147,'1','57',NULL,173,'Purchased from A.A RANO NIGERIA LIMITED',0.00,7647500.00,40250.00,0.00,0.00,'2022-09-04 15:41:50','',''),(2614148,'1','57',NULL,173,'Reception corrector for bridging 131388',0.00,0.00,0.00,20000.00,0.00,'2022-09-05 08:15:19','',''),(2614149,'1','57','446',173,'Received from bridging 131388',0.00,0.00,20000.00,0.00,0.00,'2022-09-05 08:15:19','',''),(2614150,'1','57',NULL,173,'Reception corrector for bridging 131387',0.00,0.00,0.00,20250.00,0.00,'2022-09-05 08:16:10','',''),(2614151,'1','57','445',173,'Received from bridging 131387',0.00,0.00,20250.00,0.00,0.00,'2022-09-05 08:16:10','',''),(2614152,'1','57','446',173,'Sale Id shift 257304',0.00,0.00,0.00,78.63,0.00,'2022-09-05 09:43:17','',''),(2614153,'1','57','447',174,'Sale Id shift 257304',0.00,0.00,0.00,55.78,0.00,'2022-09-05 09:43:17','',''),(2614154,'1','57',NULL,173,'Sale Id shift 257304',12973.95,0.00,0.00,0.00,0.00,'2022-09-05 09:43:17','',''),(2614155,'1','57',NULL,174,'Sale Id shift 257304',44624.00,0.00,0.00,0.00,0.00,'2022-09-05 09:43:17','',''),(2614156,'1','57','446',173,'Sale Id shift 257305',0.00,0.00,0.00,196.78,0.00,'2022-09-05 21:28:33','',''),(2614157,'1','57','447',174,'Sale Id shift 257305',0.00,0.00,0.00,112.39,0.00,'2022-09-05 21:28:33','',''),(2614158,'1','57',NULL,173,'Sale Id shift 257305',37388.20,0.00,0.00,0.00,0.00,'2022-09-05 21:28:33','',''),(2614159,'1','57',NULL,174,'Sale Id shift 257305',89912.00,0.00,0.00,0.00,0.00,'2022-09-05 21:28:33','',''),(2614160,'1','57','445',173,'Sale Id shift 257306',0.00,0.00,0.00,141.32,0.00,'2022-09-06 12:42:21','',''),(2614161,'1','57','446',173,'Sale Id shift 257306',0.00,0.00,0.00,144.22,0.00,'2022-09-06 12:42:21','',''),(2614162,'1','57','447',174,'Sale Id shift 257306',0.00,0.00,0.00,72.38,0.00,'2022-09-06 12:42:21','',''),(2614163,'1','57',NULL,174,'Sale Id shift 257306',57904.00,0.00,0.00,0.00,0.00,'2022-09-06 12:42:21','',''),(2614164,'1','57',NULL,173,'Sale Id shift 257306',54252.60,0.00,0.00,0.00,0.00,'2022-09-06 12:42:21','',''),(2614165,'1','57','446',173,'Sale Id shift 257307',0.00,0.00,0.00,217.48,0.00,'2022-09-06 16:02:26','',''),(2614166,'1','57','447',174,'Sale Id shift 257307',0.00,0.00,0.00,710.05,0.00,'2022-09-06 16:02:26','',''),(2614167,'1','57',NULL,174,'Sale Id shift 257307',568040.00,0.00,0.00,0.00,0.00,'2022-09-06 16:02:26','',''),(2614168,'1','57',NULL,173,'Sale Id shift 257307',41321.20,0.00,0.00,0.00,0.00,'2022-09-06 16:02:26','',''),(2614169,'1','57','445',173,'Sale Id shift 257308',0.00,0.00,0.00,185.88,0.00,'2022-09-07 15:51:36','',''),(2614170,'1','57','446',173,'Sale Id shift 257308',0.00,0.00,0.00,175.81,0.00,'2022-09-07 15:51:36','',''),(2614171,'1','57','447',174,'Sale Id shift 257308',0.00,0.00,0.00,619.32,0.00,'2022-09-07 15:51:36','',''),(2614172,'1','57',NULL,173,'Sale Id shift 257308',68721.10,0.00,0.00,0.00,0.00,'2022-09-07 15:51:36','',''),(2614173,'1','57',NULL,174,'Sale Id shift 257308',495456.00,0.00,0.00,0.00,0.00,'2022-09-07 15:51:36','',''),(2614174,'1','57','446',173,'Sale Id shift 257309',0.00,0.00,0.00,148.46,0.00,'2022-09-08 13:07:31','',''),(2614175,'1','57','447',174,'Sale Id shift 257309',0.00,0.00,0.00,81.13,0.00,'2022-09-08 13:07:31','',''),(2614176,'1','57',NULL,173,'Sale Id shift 257309',28207.40,0.00,0.00,0.00,0.00,'2022-09-08 13:07:31','',''),(2614177,'1','57',NULL,174,'Sale Id shift 257309',64904.00,0.00,0.00,0.00,0.00,'2022-09-08 13:07:31','',''),(2614178,'1','57','445',173,'Sale Id shift 257310',0.00,0.00,0.00,125.84,0.00,'2022-09-08 14:23:01','',''),(2614179,'1','57','446',173,'Sale Id shift 257310',0.00,0.00,0.00,141.59,0.00,'2022-09-08 14:23:01','',''),(2614180,'1','57','447',174,'Sale Id shift 257310',0.00,0.00,0.00,62.60,0.00,'2022-09-08 14:23:01','',''),(2614181,'1','57',NULL,174,'Sale Id shift 257310',50080.00,0.00,0.00,0.00,0.00,'2022-09-08 14:23:01','',''),(2614182,'1','57',NULL,173,'Sale Id shift 257310',50811.70,0.00,0.00,0.00,0.00,'2022-09-08 14:23:01','',''),(2614183,'1','57','446',173,'Sale Id shift 257311',0.00,0.00,0.00,239.27,0.00,'2022-09-08 17:45:21','',''),(2614184,'1','57','447',174,'Sale Id shift 257311',0.00,0.00,0.00,718.82,0.00,'2022-09-08 17:45:21','',''),(2614185,'1','57',NULL,173,'Sale Id shift 257311',45461.30,0.00,0.00,0.00,0.00,'2022-09-08 17:45:21','',''),(2614186,'1','57',NULL,174,'Sale Id shift 257311',575056.00,0.00,0.00,0.00,0.00,'2022-09-08 17:45:21','',''),(2614187,'1','57','445',173,'Sale Id shift 257312',0.00,0.00,0.00,86.25,0.00,'2022-09-09 17:31:23','',''),(2614188,'1','57','446',173,'Sale Id shift 257312',0.00,0.00,0.00,84.51,0.00,'2022-09-09 17:31:23','',''),(2614189,'1','57','447',174,'Sale Id shift 257312',0.00,0.00,0.00,507.58,0.00,'2022-09-09 17:31:23','',''),(2614190,'1','57',NULL,174,'Sale Id shift 257312',406064.00,0.00,0.00,0.00,0.00,'2022-09-09 17:31:23','',''),(2614191,'1','57',NULL,173,'Sale Id shift 257312',32444.40,0.00,0.00,0.00,0.00,'2022-09-09 17:31:23','',''),(2614192,'1','57','446',173,'Sale Id shift 257313',0.00,0.00,0.00,220.65,0.00,'2022-09-10 07:30:41','',''),(2614193,'1','57','447',174,'Sale Id shift 257313',0.00,0.00,0.00,656.01,0.00,'2022-09-10 07:30:41','',''),(2614194,'1','57',NULL,174,'Sale Id shift 257313',524808.00,0.00,0.00,0.00,0.00,'2022-09-10 07:30:41','',''),(2614195,'1','57',NULL,173,'Sale Id shift 257313',41923.50,0.00,0.00,0.00,0.00,'2022-09-10 07:30:41','',''),(2614196,'1','57','445',173,'Sale Id shift 257314',0.00,0.00,0.00,46.15,0.00,'2022-09-10 15:05:41','',''),(2614197,'1','57','446',173,'Sale Id shift 257314',0.00,0.00,0.00,107.74,0.00,'2022-09-10 15:05:41','',''),(2614198,'1','57','447',174,'Sale Id shift 257314',0.00,0.00,0.00,13.73,0.00,'2022-09-10 15:05:41','',''),(2614199,'1','57',NULL,173,'Sale Id shift 257314',29239.10,0.00,0.00,0.00,0.00,'2022-09-10 15:05:41','',''),(2614200,'1','57',NULL,174,'Sale Id shift 257314',10984.00,0.00,0.00,0.00,0.00,'2022-09-10 15:05:41','',''),(2614201,'1','57','446',173,'Sale Id shift 257315',0.00,0.00,0.00,63.67,0.00,'2022-09-10 22:19:29','',''),(2614202,'1','57','447',174,'Sale Id shift 257315',0.00,0.00,0.00,729.32,0.00,'2022-09-10 22:19:29','',''),(2614203,'1','57',NULL,174,'Sale Id shift 257315',583456.00,0.00,0.00,0.00,0.00,'2022-09-10 22:19:29','',''),(2614204,'1','57',NULL,173,'Sale Id shift 257315',12097.30,0.00,0.00,0.00,0.00,'2022-09-10 22:19:29','',''),(2614205,'1','57','446',173,'Sale Id shift 257316',0.00,0.00,0.00,189.21,0.00,'2022-09-11 12:30:40','',''),(2614206,'1','57','447',174,'Sale Id shift 257316',0.00,0.00,0.00,996.00,0.00,'2022-09-11 12:30:40','',''),(2614207,'1','57',NULL,174,'Sale Id shift 257316',796800.00,0.00,0.00,0.00,0.00,'2022-09-11 12:30:40','',''),(2614208,'1','57',NULL,173,'Sale Id shift 257316',35949.90,0.00,0.00,0.00,0.00,'2022-09-11 12:30:40','',''),(2614209,'1','57','446',173,'Sale Id shift 257317',0.00,0.00,0.00,356.48,0.00,'2022-09-11 19:59:54','',''),(2614210,'1','57','447',174,'Sale Id shift 257317',0.00,0.00,0.00,82.51,0.00,'2022-09-11 19:59:54','',''),(2614211,'1','57',NULL,174,'Sale Id shift 257317',66008.00,0.00,0.00,0.00,0.00,'2022-09-11 19:59:54','',''),(2614212,'1','57',NULL,173,'Sale Id shift 257317',67731.20,0.00,0.00,0.00,0.00,'2022-09-11 19:59:54','',''),(2614213,'1','57','446',173,'Sale Id shift 257318',0.00,0.00,0.00,568.89,0.00,'2022-09-12 08:13:44','',''),(2614214,'1','57','447',174,'Sale Id shift 257318',0.00,0.00,0.00,62.76,0.00,'2022-09-12 08:13:44','',''),(2614215,'1','57',NULL,174,'Sale Id shift 257318',50208.00,0.00,0.00,0.00,0.00,'2022-09-12 08:13:44','',''),(2614216,'1','57',NULL,173,'Sale Id shift 257318',108089.10,0.00,0.00,0.00,0.00,'2022-09-12 08:13:44','',''),(2614217,'1','57','445',173,'Sale Id shift 257319',0.00,0.00,0.00,159.00,0.00,'2022-09-12 11:50:07','',''),(2614218,'1','57','446',173,'Sale Id shift 257319',0.00,0.00,0.00,542.02,0.00,'2022-09-12 11:50:07','',''),(2614219,'1','57','447',174,'Sale Id shift 257319',0.00,0.00,0.00,740.23,0.00,'2022-09-12 11:50:07','',''),(2614220,'1','57',NULL,174,'Sale Id shift 257319',592184.00,0.00,0.00,0.00,0.00,'2022-09-12 11:50:07','',''),(2614221,'1','57',NULL,173,'Sale Id shift 257319',133193.80,0.00,0.00,0.00,0.00,'2022-09-12 11:50:07','',''),(2614222,'1','57','445',173,'Sale Id shift 257320',0.00,0.00,0.00,200.59,0.00,'2022-09-13 11:56:19','',''),(2614223,'1','57','446',173,'Sale Id shift 257320',0.00,0.00,0.00,152.06,0.00,'2022-09-13 11:56:19','',''),(2614224,'1','57','447',174,'Sale Id shift 257320',0.00,0.00,0.00,200.01,0.00,'2022-09-13 11:56:19','',''),(2614225,'1','57',NULL,174,'Sale Id shift 257320',160008.00,0.00,0.00,0.00,0.00,'2022-09-13 11:56:19','',''),(2614226,'1','57',NULL,173,'Sale Id shift 257320',67003.50,0.00,0.00,0.00,0.00,'2022-09-13 11:56:19','',''),(2614227,'1','57','446',173,'Sale Id shift 257321',0.00,0.00,0.00,365.42,0.00,'2022-09-13 14:28:05','',''),(2614228,'1','57','447',174,'Sale Id shift 257321',0.00,0.00,0.00,503.51,0.00,'2022-09-13 14:28:05','',''),(2614229,'1','57',NULL,174,'Sale Id shift 257321',402808.00,0.00,0.00,0.00,0.00,'2022-09-13 14:28:05','',''),(2614230,'1','57',NULL,173,'Sale Id shift 257321',69429.80,0.00,0.00,0.00,0.00,'2022-09-13 14:28:05','',''),(2614231,'1','57','445',173,'Sale Id shift 257322',0.00,0.00,0.00,154.52,0.00,'2022-09-14 11:23:58','',''),(2614232,'1','57','446',173,'Sale Id shift 257322',0.00,0.00,0.00,204.94,0.00,'2022-09-14 11:23:58','',''),(2614233,'1','57','447',174,'Sale Id shift 257322',0.00,0.00,0.00,109.38,0.00,'2022-09-14 11:23:58','',''),(2614234,'1','57',NULL,174,'Sale Id shift 257322',87504.00,0.00,0.00,0.00,0.00,'2022-09-14 11:23:58','',''),(2614235,'1','57',NULL,173,'Sale Id shift 257322',68297.40,0.00,0.00,0.00,0.00,'2022-09-14 11:23:58','',''),(2614236,'1','57','446',173,'Sale Id shift 257323',0.00,0.00,0.00,224.71,0.00,'2022-09-14 16:20:03','',''),(2614237,'1','57','447',174,'Sale Id shift 257323',0.00,0.00,0.00,502.63,0.00,'2022-09-14 16:20:03','',''),(2614238,'1','57',NULL,174,'Sale Id shift 257323',402104.00,0.00,0.00,0.00,0.00,'2022-09-14 16:20:03','',''),(2614239,'1','57',NULL,173,'Sale Id shift 257323',42694.90,0.00,0.00,0.00,0.00,'2022-09-14 16:20:03','',''),(2614240,'1','57','445',173,'Sale Id shift 257324',0.00,0.00,0.00,152.34,0.00,'2022-09-15 11:54:11','',''),(2614241,'1','57','446',173,'Sale Id shift 257324',0.00,0.00,0.00,185.97,0.00,'2022-09-15 11:54:11','',''),(2614242,'1','57','447',174,'Sale Id shift 257324',0.00,0.00,0.00,50.00,0.00,'2022-09-15 11:54:11','',''),(2614243,'1','57',NULL,174,'Sale Id shift 257324',40000.00,0.00,0.00,0.00,0.00,'2022-09-15 11:54:11','',''),(2614244,'1','57',NULL,173,'Sale Id shift 257324',64278.90,0.00,0.00,0.00,0.00,'2022-09-15 11:54:11','',''),(2614245,'1','57','446',173,'Sale Id shift 257325',0.00,0.00,0.00,243.47,0.00,'2022-09-15 16:48:25','',''),(2614246,'1','57','447',174,'Sale Id shift 257325',0.00,0.00,0.00,305.51,0.00,'2022-09-15 16:48:25','',''),(2614247,'1','57',NULL,174,'Sale Id shift 257325',244408.00,0.00,0.00,0.00,0.00,'2022-09-15 16:48:25','',''),(2614248,'1','57',NULL,173,'Sale Id shift 257325',46259.30,0.00,0.00,0.00,0.00,'2022-09-15 16:48:25','',''),(2614249,'1','57','445',173,'Sale Id shift 257326',0.00,0.00,0.00,279.63,0.00,'2022-09-16 12:53:37','',''),(2614250,'1','57','446',173,'Sale Id shift 257326',0.00,0.00,0.00,165.68,0.00,'2022-09-16 12:53:37','',''),(2614251,'1','57','447',174,'Sale Id shift 257326',0.00,0.00,0.00,202.88,0.00,'2022-09-16 12:53:37','',''),(2614252,'1','57',NULL,174,'Sale Id shift 257326',162304.00,0.00,0.00,0.00,0.00,'2022-09-16 12:53:37','',''),(2614253,'1','57',NULL,173,'Sale Id shift 257326',84608.90,0.00,0.00,0.00,0.00,'2022-09-16 12:53:37','',''),(2614254,'1','57','445',173,'Sale Id shift 257327',0.00,0.00,0.00,98.03,0.00,'2022-09-16 15:18:06','',''),(2614255,'1','57','446',173,'Sale Id shift 257327',0.00,0.00,0.00,254.36,0.00,'2022-09-16 15:18:06','',''),(2614256,'1','57','447',174,'Sale Id shift 257327',0.00,0.00,0.00,26.94,0.00,'2022-09-16 15:18:06','',''),(2614257,'1','57',NULL,174,'Sale Id shift 257327',21552.00,0.00,0.00,0.00,0.00,'2022-09-16 15:18:06','',''),(2614258,'1','57',NULL,173,'Sale Id shift 257327',66954.10,0.00,0.00,0.00,0.00,'2022-09-16 15:18:06','',''),(2614259,'1','57','445',173,'Sale Id shift 257328',0.00,0.00,0.00,120.81,0.00,'2022-09-17 12:05:32','',''),(2614260,'1','57','446',173,'Sale Id shift 257328',0.00,0.00,0.00,140.31,0.00,'2022-09-17 12:05:32','',''),(2614261,'1','57','447',174,'Sale Id shift 257328',0.00,0.00,0.00,638.64,0.00,'2022-09-17 12:05:32','',''),(2614262,'1','57',NULL,173,'Sale Id shift 257328',49612.80,0.00,0.00,0.00,0.00,'2022-09-17 12:05:32','',''),(2614263,'1','57',NULL,174,'Sale Id shift 257328',510912.00,0.00,0.00,0.00,0.00,'2022-09-17 12:05:32','',''),(2614264,'1','57','446',173,'Sale Id shift 257329',0.00,0.00,0.00,200.87,0.00,'2022-09-18 08:23:02','',''),(2614265,'1','57','447',174,'Sale Id shift 257329',0.00,0.00,0.00,586.27,0.00,'2022-09-18 08:23:02','',''),(2614266,'1','57',NULL,174,'Sale Id shift 257329',469016.00,0.00,0.00,0.00,0.00,'2022-09-18 08:23:02','',''),(2614267,'1','57',NULL,173,'Sale Id shift 257329',38165.30,0.00,0.00,0.00,0.00,'2022-09-18 08:23:02','',''),(2614268,'1','57','445',173,'Sale Id shift 257330',0.00,0.00,0.00,143.38,0.00,'2022-09-18 09:35:31','',''),(2614269,'1','57','446',173,'Sale Id shift 257330',0.00,0.00,0.00,141.51,0.00,'2022-09-18 09:35:31','',''),(2614270,'1','57','447',174,'Sale Id shift 257330',0.00,0.00,0.00,601.31,0.00,'2022-09-18 09:35:31','',''),(2614271,'1','57',NULL,174,'Sale Id shift 257330',481048.00,0.00,0.00,0.00,0.00,'2022-09-18 09:35:31','',''),(2614272,'1','57',NULL,173,'Sale Id shift 257330',54129.10,0.00,0.00,0.00,0.00,'2022-09-18 09:35:31','',''),(2614273,'1','57','446',173,'Sale Id shift 257331',0.00,0.00,0.00,274.00,0.00,'2022-09-19 08:05:29','',''),(2614274,'1','57','447',174,'Sale Id shift 257331',0.00,0.00,0.00,646.39,0.00,'2022-09-19 08:05:29','',''),(2614275,'1','57',NULL,173,'Sale Id shift 257331',52060.00,0.00,0.00,0.00,0.00,'2022-09-19 08:05:29','',''),(2614276,'1','57',NULL,174,'Sale Id shift 257331',517112.00,0.00,0.00,0.00,0.00,'2022-09-19 08:05:29','',''),(2614277,'1','57','445',173,'Sale Id shift 257332',0.00,0.00,0.00,197.31,0.00,'2022-09-19 12:02:56','',''),(2614278,'1','57','446',173,'Sale Id shift 257332',0.00,0.00,0.00,187.20,0.00,'2022-09-19 12:02:56','',''),(2614279,'1','57','447',174,'Sale Id shift 257332',0.00,0.00,0.00,330.00,0.00,'2022-09-19 12:02:56','',''),(2614280,'1','57',NULL,174,'Sale Id shift 257332',264000.00,0.00,0.00,0.00,0.00,'2022-09-19 12:02:56','',''),(2614281,'1','57',NULL,173,'Sale Id shift 257332',73056.90,0.00,0.00,0.00,0.00,'2022-09-19 12:02:56','',''),(2614282,'1','57','445',173,'Sale Id shift 257333',0.00,0.00,0.00,149.24,0.00,'2022-09-19 12:13:26','',''),(2614283,'1','57','446',173,'Sale Id shift 257333',0.00,0.00,0.00,161.53,0.00,'2022-09-19 12:13:26','',''),(2614284,'1','57','447',174,'Sale Id shift 257333',0.00,0.00,0.00,3.39,0.00,'2022-09-19 12:13:26','',''),(2614285,'1','57',NULL,174,'Sale Id shift 257333',2712.00,0.00,0.00,0.00,0.00,'2022-09-19 12:13:26','',''),(2614286,'1','57',NULL,173,'Sale Id shift 257333',59046.30,0.00,0.00,0.00,0.00,'2022-09-19 12:13:26','',''),(2614287,'1','57','445',173,'Sale Id shift 257334',0.00,0.00,0.00,115.19,0.00,'2022-09-20 00:06:14','',''),(2614288,'1','57','446',173,'Sale Id shift 257334',0.00,0.00,0.00,163.16,0.00,'2022-09-20 00:06:14','',''),(2614289,'1','57','447',174,'Sale Id shift 257334',0.00,0.00,0.00,611.00,0.00,'2022-09-20 00:06:14','',''),(2614290,'1','57',NULL,173,'Sale Id shift 257334',52886.50,0.00,0.00,0.00,0.00,'2022-09-20 00:06:14','',''),(2614291,'1','57',NULL,174,'Sale Id shift 257334',488800.00,0.00,0.00,0.00,0.00,'2022-09-20 00:06:14','',''),(2614292,'1','57','445',173,'Sale Id shift 257335',0.00,0.00,0.00,203.49,0.00,'2022-09-20 09:48:27','',''),(2614293,'1','57','446',173,'Sale Id shift 257335',0.00,0.00,0.00,159.16,0.00,'2022-09-20 09:48:27','',''),(2614294,'1','57','447',174,'Sale Id shift 257335',0.00,0.00,0.00,54.25,0.00,'2022-09-20 09:48:27','',''),(2614295,'1','57',NULL,174,'Sale Id shift 257335',43400.00,0.00,0.00,0.00,0.00,'2022-09-20 09:48:27','',''),(2614296,'1','57',NULL,173,'Sale Id shift 257335',68903.50,0.00,0.00,0.00,0.00,'2022-09-20 09:48:27','',''),(2614297,'1','57','445',173,'Sale Id shift 257336',0.00,0.00,0.00,258.87,0.00,'2022-09-21 10:19:52','',''),(2614298,'1','57','446',173,'Sale Id shift 257336',0.00,0.00,0.00,364.39,0.00,'2022-09-21 10:19:52','',''),(2614299,'1','57','447',174,'Sale Id shift 257336',0.00,0.00,0.00,157.13,0.00,'2022-09-21 10:19:52','',''),(2614300,'1','57',NULL,174,'Sale Id shift 257336',125704.00,0.00,0.00,0.00,0.00,'2022-09-21 10:19:52','',''),(2614301,'1','57',NULL,173,'Sale Id shift 257336',118419.40,0.00,0.00,0.00,0.00,'2022-09-21 10:19:52','',''),(2614302,'1','57','445',173,'Sale Id shift 257337',0.00,0.00,0.00,193.34,0.00,'2022-09-21 11:12:05','',''),(2614303,'1','57','446',173,'Sale Id shift 257337',0.00,0.00,0.00,169.60,0.00,'2022-09-21 11:12:05','',''),(2614304,'1','57','447',174,'Sale Id shift 257337',0.00,0.00,0.00,64.63,0.00,'2022-09-21 11:12:05','',''),(2614305,'1','57',NULL,174,'Sale Id shift 257337',51704.00,0.00,0.00,0.00,0.00,'2022-09-21 11:12:05','',''),(2614306,'1','57',NULL,173,'Sale Id shift 257337',68958.60,0.00,0.00,0.00,0.00,'2022-09-21 11:12:05','',''),(2614307,'1','57','445',173,'Sale Id shift 257338',0.00,0.00,0.00,261.94,0.00,'2022-09-22 11:29:43','',''),(2614308,'1','57','446',173,'Sale Id shift 257338',0.00,0.00,0.00,330.64,0.00,'2022-09-22 11:29:43','',''),(2614309,'1','57','447',174,'Sale Id shift 257338',0.00,0.00,0.00,202.52,0.00,'2022-09-22 11:29:43','',''),(2614310,'1','57',NULL,173,'Sale Id shift 257338',112590.20,0.00,0.00,0.00,0.00,'2022-09-22 11:29:43','',''),(2614311,'1','57',NULL,174,'Sale Id shift 257338',162016.00,0.00,0.00,0.00,0.00,'2022-09-22 11:29:43','',''),(2614312,'1','57','445',173,'Sale Id shift 257339',0.00,0.00,0.00,214.42,0.00,'2022-09-22 12:00:19','',''),(2614313,'1','57','446',173,'Sale Id shift 257339',0.00,0.00,0.00,317.90,0.00,'2022-09-22 12:00:19','',''),(2614314,'1','57','447',174,'Sale Id shift 257339',0.00,0.00,0.00,506.91,0.00,'2022-09-22 12:00:19','',''),(2614315,'1','57',NULL,174,'Sale Id shift 257339',405528.00,0.00,0.00,0.00,0.00,'2022-09-22 12:00:19','',''),(2614316,'1','57',NULL,173,'Sale Id shift 257339',101140.80,0.00,0.00,0.00,0.00,'2022-09-22 12:00:19','',''),(2614317,'1','57','445',173,'Sale Id shift 257340',0.00,0.00,0.00,187.43,0.00,'2022-09-23 11:07:41','',''),(2614318,'1','57','446',173,'Sale Id shift 257340',0.00,0.00,0.00,183.50,0.00,'2022-09-23 11:07:41','',''),(2614319,'1','57','447',174,'Sale Id shift 257340',0.00,0.00,0.00,477.95,0.00,'2022-09-23 11:07:41','',''),(2614320,'1','57',NULL,173,'Sale Id shift 257340',70476.70,0.00,0.00,0.00,0.00,'2022-09-23 11:07:41','',''),(2614321,'1','57',NULL,174,'Sale Id shift 257340',382360.00,0.00,0.00,0.00,0.00,'2022-09-23 11:07:41','',''),(2614322,'1','57','445',173,'Sale Id shift 257341',0.00,0.00,0.00,1949.07,0.00,'2022-09-23 11:45:14','',''),(2614323,'1','57','446',173,'Sale Id shift 257341',0.00,0.00,0.00,126.97,0.00,'2022-09-23 11:45:14','',''),(2614324,'1','57','447',174,'Sale Id shift 257341',0.00,0.00,0.00,31.00,0.00,'2022-09-23 11:45:14','',''),(2614325,'1','57',NULL,173,'Sale Id shift 257341',394447.60,0.00,0.00,0.00,0.00,'2022-09-23 11:45:14','',''),(2614326,'1','57',NULL,174,'Sale Id shift 257341',24800.00,0.00,0.00,0.00,0.00,'2022-09-23 11:45:14','',''),(2614327,'1','57','445',173,'Sale Id shift 257342',0.00,0.00,0.00,422.27,0.00,'2022-09-24 21:45:49','',''),(2614328,'1','57','446',173,'Sale Id shift 257342',0.00,0.00,0.00,154.06,0.00,'2022-09-24 21:45:49','',''),(2614329,'1','57','447',174,'Sale Id shift 257342',0.00,0.00,0.00,250.00,0.00,'2022-09-24 21:45:49','',''),(2614330,'1','57',NULL,173,'Sale Id shift 257342',109502.70,0.00,0.00,0.00,0.00,'2022-09-24 21:45:49','',''),(2614331,'1','57',NULL,174,'Sale Id shift 257342',200000.00,0.00,0.00,0.00,0.00,'2022-09-24 21:45:50','',''),(2614332,'1','57','445',173,'Sale Id shift 257343',0.00,0.00,0.00,128.91,0.00,'2022-09-25 10:20:59','',''),(2614333,'1','57','446',173,'Sale Id shift 257343',0.00,0.00,0.00,163.81,0.00,'2022-09-25 10:20:59','',''),(2614334,'1','57','447',174,'Sale Id shift 257343',0.00,0.00,0.00,419.00,0.00,'2022-09-25 10:20:59','',''),(2614335,'1','57',NULL,174,'Sale Id shift 257343',335200.00,0.00,0.00,0.00,0.00,'2022-09-25 10:20:59','',''),(2614336,'1','57',NULL,173,'Sale Id shift 257343',55616.80,0.00,0.00,0.00,0.00,'2022-09-25 10:20:59','',''),(2614337,'1','57','445',173,'Sale Id shift 257346',0.00,0.00,0.00,2285.71,0.00,'2022-09-25 14:06:23','',''),(2614338,'1','57','446',173,'Sale Id shift 257346',0.00,0.00,0.00,186.51,0.00,'2022-09-25 14:06:23','',''),(2614339,'1','57',NULL,173,'Sale Id shift 257346',469721.80,0.00,0.00,0.00,0.00,'2022-09-25 14:06:23','',''),(2614340,'1','57','445',173,'Sale Id shift 257347',0.00,0.00,0.00,131.74,0.00,'2022-09-25 14:11:12','',''),(2614341,'1','57','446',173,'Sale Id shift 257347',0.00,0.00,0.00,178.84,0.00,'2022-09-25 14:11:12','',''),(2614342,'1','57',NULL,173,'Sale Id shift 257347',59010.20,0.00,0.00,0.00,0.00,'2022-09-25 14:11:12','',''),(2614343,'1','57','445',173,'Sale Id shift 257348',0.00,0.00,0.00,179.58,0.00,'2022-09-26 11:44:37','',''),(2614344,'1','57','446',173,'Sale Id shift 257348',0.00,0.00,0.00,1339.10,0.00,'2022-09-26 11:44:37','',''),(2614345,'1','57',NULL,173,'Sale Id shift 257348',288549.20,0.00,0.00,0.00,0.00,'2022-09-26 11:44:37','',''),(2614346,'1','57','445',173,'Sale Id shift 257349',0.00,0.00,0.00,425.78,0.00,'2022-09-26 11:56:43','',''),(2614347,'1','57','445',173,'Sale Id shift 257349',0.00,0.00,0.00,525.95,0.00,'2022-09-26 11:56:43','',''),(2614348,'1','57','446',173,'Sale Id shift 257349',0.00,0.00,0.00,9.05,0.00,'2022-09-26 11:56:43','',''),(2614349,'1','57',NULL,173,'Sale Id shift 257349',182548.20,0.00,0.00,0.00,0.00,'2022-09-26 11:56:43','',''),(2614350,'1','57','445',173,'Sale Id shift 257350',0.00,0.00,0.00,219.63,0.00,'2022-09-27 10:34:44','',''),(2614351,'1','57','445',173,'Sale Id shift 257350',0.00,0.00,0.00,195.70,0.00,'2022-09-27 10:34:44','',''),(2614352,'1','57',NULL,173,'Sale Id shift 257350',78912.70,0.00,0.00,0.00,0.00,'2022-09-27 10:34:44','',''),(2614353,'1','57','445',173,'Sale Id shift 257351',0.00,0.00,0.00,711.76,0.00,'2022-09-27 11:29:14','',''),(2614354,'1','57','445',173,'Sale Id shift 257351',0.00,0.00,0.00,169.15,0.00,'2022-09-27 11:29:14','',''),(2614355,'1','57',NULL,173,'Sale Id shift 257351',167372.90,0.00,0.00,0.00,0.00,'2022-09-27 11:29:14','',''),(2614356,'1','57','445',173,'Sale Id shift 257352',0.00,0.00,0.00,373.15,0.00,'2022-09-28 11:19:09','',''),(2614357,'1','57','445',173,'Sale Id shift 257352',0.00,0.00,0.00,465.23,0.00,'2022-09-28 11:19:09','',''),(2614358,'1','57',NULL,173,'Sale Id shift 257352',159292.20,0.00,0.00,0.00,0.00,'2022-09-28 11:19:09','',''),(2614359,'1','57','445',173,'Sale Id shift 257353',0.00,0.00,0.00,201.56,0.00,'2022-09-28 13:19:10','',''),(2614360,'1','57','445',173,'Sale Id shift 257353',0.00,0.00,0.00,294.92,0.00,'2022-09-28 13:19:10','',''),(2614361,'1','57',NULL,173,'Sale Id shift 257353',94331.20,0.00,0.00,0.00,0.00,'2022-09-28 13:19:10','',''),(2614362,'1','57','445',173,'Sale Id shift 257354',0.00,0.00,0.00,390.69,0.00,'2022-09-28 15:38:14','',''),(2614363,'1','57','445',173,'Sale Id shift 257354',0.00,0.00,0.00,321.48,0.00,'2022-09-28 15:38:14','',''),(2614364,'1','57','446',173,'Sale Id shift 257354',0.00,0.00,0.00,500.00,0.00,'2022-09-28 15:38:14','',''),(2614365,'1','57',NULL,173,'Sale Id shift 257354',230312.30,0.00,0.00,0.00,0.00,'2022-09-28 15:38:14','',''),(2614366,'1','57','445',173,'Sale Id shift 257355',0.00,0.00,0.00,442.38,0.00,'2022-09-29 12:21:46','',''),(2614367,'1','57','445',173,'Sale Id shift 257355',0.00,0.00,0.00,352.71,0.00,'2022-09-29 12:21:46','',''),(2614368,'1','57',NULL,173,'Sale Id shift 257355',151067.10,0.00,0.00,0.00,0.00,'2022-09-29 12:21:46','',''),(2614369,'1','57','445',173,'Sale Id shift 257356',0.00,0.00,0.00,454.60,0.00,'2022-09-30 07:40:32','',''),(2614370,'1','57','445',173,'Sale Id shift 257356',0.00,0.00,0.00,243.17,0.00,'2022-09-30 07:40:32','',''),(2614371,'1','57',NULL,173,'Sale Id shift 257356',132576.30,0.00,0.00,0.00,0.00,'2022-09-30 07:40:32','',''),(2614372,'1','57','445',173,'Sale Id shift 257357',0.00,0.00,0.00,309.11,0.00,'2022-09-30 12:12:47','',''),(2614373,'1','57','445',173,'Sale Id shift 257357',0.00,0.00,0.00,186.02,0.00,'2022-09-30 12:12:47','',''),(2614374,'1','57',NULL,173,'Sale Id shift 257357',94074.70,0.00,0.00,0.00,0.00,'2022-09-30 12:12:47','',''),(2614375,'1','57','445',173,'Sale Id shift 257358',0.00,0.00,0.00,354.87,0.00,'2022-09-30 16:18:58','',''),(2614376,'1','57','445',173,'Sale Id shift 257358',0.00,0.00,0.00,218.35,0.00,'2022-09-30 16:18:58','',''),(2614377,'1','57',NULL,173,'Sale Id shift 257358',108911.80,0.00,0.00,0.00,0.00,'2022-09-30 16:18:58','',''),(2614378,'1','57','445',173,'Sale Id shift 257359',0.00,0.00,0.00,581.97,0.00,'2022-10-02 15:23:58','',''),(2614379,'1','57','445',173,'Sale Id shift 257359',0.00,0.00,0.00,507.93,0.00,'2022-10-02 15:23:58','',''),(2614380,'1','57',NULL,173,'Sale Id shift 257359',207081.00,0.00,0.00,0.00,0.00,'2022-10-02 15:23:58','',''),(2614381,'1','57','445',173,'Sale Id shift 257360',0.00,0.00,0.00,221.87,0.00,'2022-10-02 19:54:00','',''),(2614382,'1','57','445',173,'Sale Id shift 257360',0.00,0.00,0.00,182.09,0.00,'2022-10-02 19:54:00','',''),(2614383,'1','57',NULL,173,'Sale Id shift 257360',76752.40,0.00,0.00,0.00,0.00,'2022-10-02 19:54:00','',''),(2614384,'1','57','445',173,'Sale Id shift 257361',0.00,0.00,0.00,568.07,0.00,'2022-10-03 15:37:28','',''),(2614385,'1','57','445',173,'Sale Id shift 257361',0.00,0.00,0.00,384.30,0.00,'2022-10-03 15:37:28','',''),(2614386,'1','57',NULL,173,'Sale Id shift 257361',180950.30,0.00,0.00,0.00,0.00,'2022-10-03 15:37:28','',''),(2614387,'1','57','445',173,'Sale Id shift 257362',0.00,0.00,0.00,340.38,0.00,'2022-10-03 17:52:58','',''),(2614388,'1','57','445',173,'Sale Id shift 257362',0.00,0.00,0.00,126.33,0.00,'2022-10-03 17:52:58','',''),(2614389,'1','57',NULL,173,'Sale Id shift 257362',88674.90,0.00,0.00,0.00,0.00,'2022-10-03 17:52:58','',''),(2614390,'1','57','445',173,'Sale Id shift 257363',0.00,0.00,0.00,394.78,0.00,'2022-10-03 18:00:22','',''),(2614391,'1','57','445',173,'Sale Id shift 257363',0.00,0.00,0.00,391.60,0.00,'2022-10-03 18:00:22','',''),(2614392,'1','57',NULL,173,'Sale Id shift 257363',149412.20,0.00,0.00,0.00,0.00,'2022-10-03 18:00:22','',''),(2614393,'1','57','445',173,'Sale Id shift 257364',0.00,0.00,0.00,308.04,0.00,'2022-10-03 18:20:03','',''),(2614394,'1','57','445',173,'Sale Id shift 257364',0.00,0.00,0.00,212.64,0.00,'2022-10-03 18:20:03','',''),(2614395,'1','57',NULL,173,'Sale Id shift 257364',98929.20,0.00,0.00,0.00,0.00,'2022-10-03 18:20:03','',''),(2614396,'1','57','445',173,'Sale Id shift 257365',0.00,0.00,0.00,124.80,0.00,'2022-10-04 14:16:24','',''),(2614397,'1','57','445',173,'Sale Id shift 257365',0.00,0.00,0.00,56.44,0.00,'2022-10-04 14:16:24','',''),(2614398,'1','57','446',173,'Sale Id shift 257365',0.00,0.00,0.00,864.46,0.00,'2022-10-04 14:16:24','',''),(2614399,'1','57',NULL,173,'Sale Id shift 257365',198683.00,0.00,0.00,0.00,0.00,'2022-10-04 14:16:24','',''),(2614400,'1','57','446',173,'Sale Id shift 257366',0.00,0.00,0.00,762.93,0.00,'2022-10-05 11:27:16','',''),(2614401,'1','57',NULL,173,'Sale Id shift 257366',144956.70,0.00,0.00,0.00,0.00,'2022-10-05 11:27:16','',''),(2614402,'1','57','446',173,'Sale Id shift 257367',0.00,0.00,0.00,980.23,0.00,'2022-10-05 12:28:02','',''),(2614403,'1','57',NULL,173,'Sale Id shift 257367',186243.70,0.00,0.00,0.00,0.00,'2022-10-05 12:28:02','',''),(2614404,'1','57','446',173,'Sale Id shift 257368',0.00,0.00,0.00,831.17,0.00,'2022-10-06 11:42:34','',''),(2614405,'1','57',NULL,173,'Sale Id shift 257368',157922.30,0.00,0.00,0.00,0.00,'2022-10-06 11:42:34','',''),(2614406,'1','57','446',173,'Sale Id shift 257369',0.00,0.00,0.00,919.09,0.00,'2022-10-07 09:38:36','',''),(2614407,'1','57',NULL,173,'Sale Id shift 257369',174627.10,0.00,0.00,0.00,0.00,'2022-10-07 09:38:36','',''),(2614408,'1','57','446',173,'Sale Id shift 257370',0.00,0.00,0.00,455.57,0.00,'2022-10-07 10:28:39','',''),(2614409,'1','57',NULL,173,'Sale Id shift 257370',86558.30,0.00,0.00,0.00,0.00,'2022-10-07 10:28:39','',''),(2614410,'1','57','446',173,'Sale Id shift 257371',0.00,0.00,0.00,844.15,0.00,'2022-10-07 11:43:54','',''),(2614411,'1','57',NULL,173,'Sale Id shift 257371',160388.50,0.00,0.00,0.00,0.00,'2022-10-07 11:43:54','',''),(2614412,'1','57','446',173,'Sale Id shift 257372',0.00,0.00,0.00,417.05,0.00,'2022-10-07 20:19:03','',''),(2614413,'1','57',NULL,173,'Sale Id shift 257372',79239.50,0.00,0.00,0.00,0.00,'2022-10-07 20:19:03','',''),(2614414,'1','57','446',173,'Sale Id shift 257373',0.00,0.00,0.00,1813.54,0.00,'2022-10-08 09:46:45','',''),(2614415,'1','57',NULL,173,'Sale Id shift 257373',344572.60,0.00,0.00,0.00,0.00,'2022-10-08 09:46:45','',''),(2614416,'1','57','446',173,'Sale Id shift 257374',0.00,0.00,0.00,430.34,0.00,'2022-10-09 21:54:25','',''),(2614417,'1','57',NULL,173,'Sale Id shift 257374',81764.60,0.00,0.00,0.00,0.00,'2022-10-09 21:54:25','',''),(2614418,'1','57','446',173,'Sale Id shift 257375',0.00,0.00,0.00,199.48,0.00,'2022-10-11 11:55:51','',''),(2614419,'1','57',NULL,173,'Sale Id shift 257375',37901.20,0.00,0.00,0.00,0.00,'2022-10-11 11:55:51','',''),(2614420,'1','57',NULL,173,'Purchased from A.A RANO NIGERIA LIMITED',0.00,3724000.00,15200.00,0.00,0.00,'2022-11-15 15:59:51','',''),(2614421,'1','57',NULL,173,'Reception corrector for bridging 131390',0.00,0.00,0.00,15200.00,0.00,'2022-11-15 16:57:16','',''),(2614422,'1','57','445',173,'Received from bridging 131390',0.00,0.00,15200.00,0.00,0.00,'2022-11-15 16:57:16','',''),(2614423,'1','57','445',173,'Sale Id shift 257377',0.00,0.00,0.00,681.14,0.00,'2022-11-16 15:57:54','',''),(2614424,'1','57','445',173,'Sale Id shift 257377',0.00,0.00,0.00,2684.10,0.00,'2022-11-16 15:57:54','',''),(2614425,'1','57',NULL,173,'Sale Id shift 257377',824483.80,0.00,0.00,0.00,0.00,'2022-11-16 15:57:54','',''),(2614426,'1','57','445',173,'Sale Id shift 257378',0.00,0.00,0.00,5226.55,0.00,'2022-11-17 01:07:32','',''),(2614427,'1','57','445',173,'Sale Id shift 257378',0.00,0.00,0.00,714.21,0.00,'2022-11-17 01:07:32','',''),(2614428,'1','57',NULL,173,'Sale Id shift 257378',1455486.20,0.00,0.00,0.00,0.00,'2022-11-17 01:07:32','',''),(2614429,'1','57','445',173,'Sale Id shift 257379',0.00,0.00,0.00,360.93,0.00,'2022-11-17 15:05:11','',''),(2614430,'1','57','445',173,'Sale Id shift 257379',0.00,0.00,0.00,356.49,0.00,'2022-11-17 15:05:11','',''),(2614431,'1','57',NULL,173,'Sale Id shift 257379',175767.90,0.00,0.00,0.00,0.00,'2022-11-17 15:05:11','',''),(2614432,'1','57','445',173,'Sale Id shift 257380',0.00,0.00,0.00,915.57,0.00,'2022-11-17 15:23:39','',''),(2614433,'1','57','445',173,'Sale Id shift 257380',0.00,0.00,0.00,760.19,0.00,'2022-11-17 15:23:39','',''),(2614434,'1','57',NULL,173,'Sale Id shift 257380',410561.20,0.00,0.00,0.00,0.00,'2022-11-17 15:23:39','',''),(2614435,'1','57','445',173,'Sale Id shift 257381',0.00,0.00,0.00,2577.34,0.00,'2022-11-18 11:25:02','',''),(2614436,'1','57','445',173,'Sale Id shift 257381',0.00,0.00,0.00,551.25,0.00,'2022-11-18 11:25:02','',''),(2614437,'1','57',NULL,173,'Sale Id shift 257381',766504.55,0.00,0.00,0.00,0.00,'2022-11-18 11:25:02','',''),(2614438,'1','57','445',173,'Sale Id shift 257382',0.00,0.00,0.00,267.06,0.00,'2022-11-21 00:10:52','',''),(2614439,'1','57','445',173,'Sale Id shift 257382',0.00,0.00,0.00,165.18,0.00,'2022-11-21 00:10:52','',''),(2614440,'1','57',NULL,173,'Sale Id shift 257382',105898.80,0.00,0.00,0.00,0.00,'2022-11-21 00:10:52','',''),(2614441,'1','57',NULL,174,'Purchased from A.A RANO NIGERIA LIMITED',0.00,17800000.00,20000.00,0.00,0.00,'2023-01-04 11:55:19','',''),(2614442,'1','57',NULL,174,'Reception corrector for bridging 131391',0.00,0.00,0.00,20000.00,0.00,'2023-01-04 14:38:15','',''),(2614443,'1','57','447',174,'Received from bridging 131391',0.00,0.00,20000.00,0.00,0.00,'2023-01-04 14:38:15','',''),(2614444,'1','57','447',174,'Sale Id shift 257384',0.00,0.00,0.00,961.42,0.00,'2023-01-06 10:28:21','',''),(2614445,'1','57',NULL,174,'Sale Id shift 257384',855663.80,0.00,0.00,0.00,0.00,'2023-01-06 10:28:21','',''),(2614446,'1','57','447',174,'Sale Id shift 257385',0.00,0.00,0.00,700.00,0.00,'2023-01-06 17:34:13','',''),(2614447,'1','57',NULL,174,'Sale Id shift 257385',623000.00,0.00,0.00,0.00,0.00,'2023-01-06 17:34:13','',''),(2614448,'1','57','447',174,'Sale Id shift 257386',0.00,0.00,0.00,777.81,0.00,'2023-01-08 09:40:56','',''),(2614449,'1','57',NULL,174,'Sale Id shift 257386',692250.90,0.00,0.00,0.00,0.00,'2023-01-08 09:40:56','',''),(2614450,'1','57','447',174,'Sale Id shift 257387',0.00,0.00,0.00,137.55,0.00,'2023-01-08 19:01:41','',''),(2614451,'1','57',NULL,174,'Sale Id shift 257387',122419.50,0.00,0.00,0.00,0.00,'2023-01-08 19:01:41','',''),(2614452,'1','57','447',174,'Sale Id shift 257388',0.00,0.00,0.00,80.00,0.00,'2023-01-09 03:49:20','',''),(2614453,'1','57',NULL,174,'Sale Id shift 257388',71200.00,0.00,0.00,0.00,0.00,'2023-01-09 03:49:20','',''),(2614454,'1','57','447',174,'Sale Id shift 257389',0.00,0.00,0.00,13.03,0.00,'2023-01-09 11:45:58','',''),(2614455,'1','57',NULL,174,'Sale Id shift 257389',11596.70,0.00,0.00,0.00,0.00,'2023-01-09 11:45:58','',''),(2614456,'1','57','447',174,'Sale Id shift 257390',0.00,0.00,0.00,809.72,0.00,'2023-01-10 10:50:51','',''),(2614457,'1','57',NULL,174,'Sale Id shift 257390',720650.80,0.00,0.00,0.00,0.00,'2023-01-10 10:50:51','',''),(2614458,'1','57','447',174,'Sale Id shift 257391',0.00,0.00,0.00,75.00,0.00,'2023-01-10 20:42:51','',''),(2614459,'1','57',NULL,174,'Sale Id shift 257391',66750.00,0.00,0.00,0.00,0.00,'2023-01-10 20:42:51','',''),(2614460,'1','57','447',174,'Sale Id shift 257392',0.00,0.00,0.00,491.69,0.00,'2023-01-10 20:51:36','',''),(2614461,'1','57',NULL,174,'Sale Id shift 257392',437604.10,0.00,0.00,0.00,0.00,'2023-01-10 20:51:36','',''),(2614462,'1','57','447',174,'Sale Id shift 257393',0.00,0.00,0.00,180.00,0.00,'2023-01-10 21:01:42','',''),(2614463,'1','57',NULL,174,'Sale Id shift 257393',160200.00,0.00,0.00,0.00,0.00,'2023-01-10 21:01:42','',''),(2614464,'1','57','447',174,'Sale Id shift 257394',0.00,0.00,0.00,852.94,0.00,'2023-01-10 21:13:01','',''),(2614465,'1','57',NULL,174,'Sale Id shift 257394',759116.60,0.00,0.00,0.00,0.00,'2023-01-10 21:13:01','',''),(2614466,'1','57','447',174,'Sale Id shift 257395',0.00,0.00,0.00,522.25,0.00,'2023-01-11 11:24:03','',''),(2614467,'1','57',NULL,174,'Sale Id shift 257395',464802.50,0.00,0.00,0.00,0.00,'2023-01-11 11:24:03','',''),(2614468,'1','57','447',174,'Sale Id shift 257396',0.00,0.00,0.00,314.12,0.00,'2023-01-12 07:30:50','',''),(2614469,'1','57',NULL,174,'Sale Id shift 257396',279566.80,0.00,0.00,0.00,0.00,'2023-01-12 07:30:50','',''),(2614470,'1','57','447',174,'Sale Id shift 257397',0.00,0.00,0.00,65.62,0.00,'2023-01-12 19:56:03','',''),(2614471,'1','57',NULL,174,'Sale Id shift 257397',58401.80,0.00,0.00,0.00,0.00,'2023-01-12 19:56:03','',''),(2614472,'1','57','447',174,'Sale Id shift 257398',0.00,0.00,0.00,205.21,0.00,'2023-01-13 17:17:14','',''),(2614473,'1','57',NULL,174,'Sale Id shift 257398',182636.90,0.00,0.00,0.00,0.00,'2023-01-13 17:17:14','',''),(2614474,'1','57','447',174,'Sale Id shift 257399',0.00,0.00,0.00,97.32,0.00,'2023-01-14 10:31:29','',''),(2614475,'1','57',NULL,174,'Sale Id shift 257399',86614.80,0.00,0.00,0.00,0.00,'2023-01-14 10:31:29','',''),(2614476,'1','57','447',174,'Sale Id shift 257400',0.00,0.00,0.00,994.30,0.00,'2023-01-14 10:48:29','',''),(2614477,'1','57',NULL,174,'Sale Id shift 257400',884927.00,0.00,0.00,0.00,0.00,'2023-01-14 10:48:29','',''),(2614478,'1','57','447',174,'Sale Id shift 257401',0.00,0.00,0.00,2.25,0.00,'2023-01-15 07:48:07','',''),(2614479,'1','57',NULL,174,'Sale Id shift 257401',2002.50,0.00,0.00,0.00,0.00,'2023-01-15 07:48:07','',''),(2614480,'1','57','447',174,'Sale Id shift 257402',0.00,0.00,0.00,201.12,0.00,'2023-01-15 13:26:08','',''),(2614481,'1','57',NULL,174,'Sale Id shift 257402',178996.80,0.00,0.00,0.00,0.00,'2023-01-15 13:26:08','',''),(2614482,'1','57','447',174,'Sale Id shift 257403',0.00,0.00,0.00,50.00,0.00,'2023-01-16 13:54:22','',''),(2614483,'1','57',NULL,174,'Sale Id shift 257403',44500.00,0.00,0.00,0.00,0.00,'2023-01-16 13:54:22','',''),(2614484,'1','57','447',174,'Sale Id shift 257404',0.00,0.00,0.00,311.46,0.00,'2023-01-16 14:08:21','',''),(2614485,'1','57',NULL,174,'Sale Id shift 257404',277199.40,0.00,0.00,0.00,0.00,'2023-01-16 14:08:21','',''),(2614486,'1','57','447',174,'Sale Id shift 257405',0.00,0.00,0.00,1636.26,0.00,'2023-01-17 09:45:40','',''),(2614487,'1','57',NULL,174,'Sale Id shift 257405',1456271.40,0.00,0.00,0.00,0.00,'2023-01-17 09:45:40','',''),(2614488,'1','57','447',174,'Sale Id shift 257406',0.00,0.00,0.00,366.86,0.00,'2023-01-17 12:59:46','',''),(2614489,'1','57',NULL,174,'Sale Id shift 257406',326505.40,0.00,0.00,0.00,0.00,'2023-01-17 12:59:46','',''),(2614490,'1','57','447',174,'Sale Id shift 257407',0.00,0.00,0.00,201.60,0.00,'2023-01-18 09:20:43','',''),(2614491,'1','57',NULL,174,'Sale Id shift 257407',179424.00,0.00,0.00,0.00,0.00,'2023-01-18 09:20:43','',''),(2614492,'1','57','447',174,'Sale Id shift 257408',0.00,0.00,0.00,186.16,0.00,'2023-01-19 08:43:24','',''),(2614493,'1','57',NULL,174,'Sale Id shift 257408',165682.40,0.00,0.00,0.00,0.00,'2023-01-19 08:43:24','',''),(2614494,'1','57','447',174,'Sale Id shift 257409',0.00,0.00,0.00,291.81,0.00,'2023-01-19 11:23:13','',''),(2614495,'1','57',NULL,174,'Sale Id shift 257409',259710.90,0.00,0.00,0.00,0.00,'2023-01-19 11:23:13','',''),(2614496,'1','57','447',174,'Sale Id shift 257410',0.00,0.00,0.00,1342.85,0.00,'2023-01-19 14:45:30','',''),(2614497,'1','57',NULL,174,'Sale Id shift 257410',1195136.50,0.00,0.00,0.00,0.00,'2023-01-19 14:45:30','',''),(2614498,'1','57','447',174,'Sale Id shift 257411',0.00,0.00,0.00,56.91,0.00,'2023-01-20 08:52:30','',''),(2614499,'1','57',NULL,174,'Sale Id shift 257411',50649.90,0.00,0.00,0.00,0.00,'2023-01-20 08:52:30','',''),(2614500,'1','57','447',174,'Sale Id shift 257412',0.00,0.00,0.00,188.88,0.00,'2023-01-20 12:51:06','',''),(2614501,'1','57',NULL,174,'Sale Id shift 257412',168103.20,0.00,0.00,0.00,0.00,'2023-01-20 12:51:06','',''),(2614502,'1','57','447',174,'Sale Id shift 257413',0.00,0.00,0.00,554.89,0.00,'2023-01-20 13:00:04','',''),(2614503,'1','57',NULL,174,'Sale Id shift 257413',493852.10,0.00,0.00,0.00,0.00,'2023-01-20 13:00:04','',''),(2614504,'1','57','447',174,'Sale Id shift 257414',0.00,0.00,0.00,303.78,0.00,'2023-01-21 17:46:54','',''),(2614505,'1','57',NULL,174,'Sale Id shift 257414',270364.20,0.00,0.00,0.00,0.00,'2023-01-21 17:46:54','',''),(2614506,'1','57','447',174,'Sale Id shift 257415',0.00,0.00,0.00,317.03,0.00,'2023-01-22 09:55:48','',''),(2614507,'1','57',NULL,174,'Sale Id shift 257415',282156.70,0.00,0.00,0.00,0.00,'2023-01-22 09:55:48','',''),(2614508,'1','57','447',174,'Sale Id shift 257416',0.00,0.00,0.00,1274.40,0.00,'2023-01-22 18:33:41','',''),(2614509,'1','57',NULL,174,'Sale Id shift 257416',1134216.00,0.00,0.00,0.00,0.00,'2023-01-22 18:33:41','',''),(2614510,'1','57','447',174,'Sale Id shift 257417',0.00,0.00,0.00,117.62,0.00,'2023-01-23 10:51:47','',''),(2614511,'1','57',NULL,174,'Sale Id shift 257417',104681.80,0.00,0.00,0.00,0.00,'2023-01-23 10:51:47','',''),(2614512,'1','57','447',174,'Sale Id shift 257418',0.00,0.00,0.00,752.20,0.00,'2023-01-24 14:16:07','',''),(2614513,'1','57',NULL,174,'Sale Id shift 257418',669458.00,0.00,0.00,0.00,0.00,'2023-01-24 14:16:07','',''),(2614514,'1','57','447',174,'Sale Id shift 257419',0.00,0.00,0.00,886.74,0.00,'2023-01-24 19:08:43','',''),(2614515,'1','57',NULL,174,'Sale Id shift 257419',789198.60,0.00,0.00,0.00,0.00,'2023-01-24 19:08:43','',''),(2614516,'1','57','447',174,'Sale Id shift 257420',0.00,0.00,0.00,341.81,0.00,'2023-01-25 09:54:01','',''),(2614517,'1','57',NULL,174,'Sale Id shift 257420',304210.90,0.00,0.00,0.00,0.00,'2023-01-25 09:54:01','',''),(2614518,'1','57','447',174,'Sale Id shift 257421',0.00,0.00,0.00,537.62,0.00,'2023-01-25 13:55:12','',''),(2614519,'1','57',NULL,174,'Sale Id shift 257421',478481.80,0.00,0.00,0.00,0.00,'2023-01-25 13:55:12','',''),(2614520,'1','57','447',174,'Sale Id shift 257422',0.00,0.00,0.00,574.57,0.00,'2023-01-25 20:33:02','',''),(2614521,'1','57',NULL,174,'Sale Id shift 257422',511367.30,0.00,0.00,0.00,0.00,'2023-01-25 20:33:02','',''),(2614522,'1','57','447',174,'Sale Id shift 257423',0.00,0.00,0.00,401.35,0.00,'2023-01-27 10:48:24','',''),(2614523,'1','57',NULL,174,'Sale Id shift 257423',357201.50,0.00,0.00,0.00,0.00,'2023-01-27 10:48:24','',''),(2614524,'1','57','447',174,'Sale Id shift 257424',0.00,0.00,0.00,322.04,0.00,'2023-01-27 12:01:11','',''),(2614525,'1','57',NULL,174,'Sale Id shift 257424',286615.60,0.00,0.00,0.00,0.00,'2023-01-27 12:01:11','',''),(2614526,'1','57','447',174,'Sale Id shift 257425',0.00,0.00,0.00,351.24,0.00,'2023-01-27 23:39:31','',''),(2614527,'1','57',NULL,174,'Sale Id shift 257425',312603.60,0.00,0.00,0.00,0.00,'2023-01-27 23:39:31','',''),(2614528,'1','57','447',174,'Sale Id shift 257426',0.00,0.00,0.00,361.68,0.00,'2023-01-29 15:22:53','',''),(2614529,'1','57',NULL,174,'Sale Id shift 257426',321895.20,0.00,0.00,0.00,0.00,'2023-01-29 15:22:53','',''),(2614530,'1','57','447',174,'Sale Id shift 257427',0.00,0.00,0.00,53.05,0.00,'2023-01-29 22:54:23','',''),(2614531,'1','57',NULL,174,'Sale Id shift 257427',47214.50,0.00,0.00,0.00,0.00,'2023-01-29 22:54:23','',''),(2614532,'1','57','447',174,'Sale Id shift 257428',0.00,0.00,0.00,264.78,0.00,'2023-01-30 09:14:59','',''),(2614533,'1','57',NULL,174,'Sale Id shift 257428',235654.20,0.00,0.00,0.00,0.00,'2023-01-30 09:14:59','',''),(2614534,'1','57','447',174,'Sale Id shift 257429',0.00,0.00,0.00,547.56,0.00,'2023-01-30 09:27:29','',''),(2614535,'1','57',NULL,174,'Sale Id shift 257429',487328.40,0.00,0.00,0.00,0.00,'2023-01-30 09:27:29','',''),(2614536,'1','57','447',174,'Sale Id shift 257430',0.00,0.00,0.00,25.00,0.00,'2023-01-30 09:42:05','',''),(2614537,'1','57',NULL,174,'Sale Id shift 257430',22250.00,0.00,0.00,0.00,0.00,'2023-01-30 09:42:05','',''),(2614538,'1','57','447',174,'Sale Id shift 257431',0.00,0.00,0.00,1.57,0.00,'2023-01-30 10:15:43','',''),(2614539,'1','57',NULL,174,'Sale Id shift 257431',1397.30,0.00,0.00,0.00,0.00,'2023-01-30 10:15:43','',''),(2614540,'1','57','447',174,'Sale Id shift 257432',0.00,0.00,0.00,32.79,0.00,'2023-01-30 10:21:29','',''),(2614541,'1','57',NULL,174,'Sale Id shift 257432',29183.10,0.00,0.00,0.00,0.00,'2023-01-30 10:21:29','',''),(2614542,'1','57','447',174,'Sale Id shift 257433',0.00,0.00,0.00,87.06,0.00,'2023-01-30 18:53:25','',''),(2614543,'1','57',NULL,174,'Sale Id shift 257433',77483.40,0.00,0.00,0.00,0.00,'2023-01-30 18:53:25','',''),(2614544,'1','57',NULL,174,'Purchased from A.A RANO NIGERIA LIMITED',0.00,16465000.00,18500.00,0.00,0.00,'2023-01-30 19:33:30','',''),(2614545,'1','57',NULL,174,'Reception corrector for bridging 131392',0.00,0.00,0.00,18500.00,0.00,'2023-01-31 09:00:39','',''),(2614546,'1','57','447',174,'Received from bridging 131392',0.00,0.00,18500.00,0.00,0.00,'2023-01-31 09:00:39','',''),(2614547,'1','57','447',174,'Sale Id shift 257434',0.00,0.00,0.00,330.59,0.00,'2023-01-31 17:16:11','',''),(2614548,'1','57',NULL,174,'Sale Id shift 257434',287613.30,0.00,0.00,0.00,0.00,'2023-01-31 17:16:11','',''),(2614549,'1','57','447',174,'Sale Id shift 257435',0.00,0.00,0.00,1072.45,0.00,'2023-01-31 20:24:05','',''),(2614550,'1','57',NULL,174,'Sale Id shift 257435',933031.50,0.00,0.00,0.00,0.00,'2023-01-31 20:24:05','',''),(2614551,'1','57','447',174,'Sale Id shift 257436',0.00,0.00,0.00,905.46,0.00,'2023-01-31 20:40:24','',''),(2614552,'1','57',NULL,174,'Sale Id shift 257436',787750.20,0.00,0.00,0.00,0.00,'2023-01-31 20:40:24','',''),(2614553,'1','57','447',174,'Sale Id shift 257438',0.00,0.00,0.00,26.91,0.00,'2023-02-04 21:48:38','',''),(2614554,'1','57',NULL,174,'Sale Id shift 257438',23411.70,0.00,0.00,0.00,0.00,'2023-02-04 21:48:38','',''),(2614555,'1','57','447',174,'Sale Id shift 257439',0.00,0.00,0.00,117.21,0.00,'2023-02-04 22:10:39','',''),(2614556,'1','57',NULL,174,'Sale Id shift 257439',101972.70,0.00,0.00,0.00,0.00,'2023-02-04 22:10:39','',''),(2614557,'1','57','447',174,'Sale Id shift 257440',0.00,0.00,0.00,367.08,0.00,'2023-02-04 22:42:19','',''),(2614558,'1','57',NULL,174,'Sale Id shift 257440',319359.60,0.00,0.00,0.00,0.00,'2023-02-04 22:42:19','',''),(2614559,'1','57','447',174,'Sale Id shift 257442',0.00,0.00,0.00,59.20,0.00,'2023-02-05 20:11:54','',''),(2614560,'1','57',NULL,174,'Sale Id shift 257442',51504.00,0.00,0.00,0.00,0.00,'2023-02-05 20:11:54','',''),(2614561,'1','57','447',174,'Sale Id shift 257443',0.00,0.00,0.00,695.57,0.00,'2023-02-06 22:30:13','',''),(2614562,'1','57',NULL,174,'Sale Id shift 257443',605145.90,0.00,0.00,0.00,0.00,'2023-02-06 22:30:13','',''),(2614563,'1','57','447',174,'Sale Id shift 257444',0.00,0.00,0.00,952.87,0.00,'2023-02-08 08:54:57','',''),(2614564,'1','57',NULL,174,'Sale Id shift 257444',828996.90,0.00,0.00,0.00,0.00,'2023-02-08 08:54:57','',''),(2614565,'1','57','447',174,'Sale Id shift 257445',0.00,0.00,0.00,1920.61,0.00,'2023-02-08 09:05:49','',''),(2614566,'1','57',NULL,174,'Sale Id shift 257445',1670930.70,0.00,0.00,0.00,0.00,'2023-02-08 09:05:49','',''),(2614567,'1','57','447',174,'Sale Id shift 257446',0.00,0.00,0.00,81.15,0.00,'2023-02-08 09:11:30','',''),(2614568,'1','57',NULL,174,'Sale Id shift 257446',70600.50,0.00,0.00,0.00,0.00,'2023-02-08 09:11:30','',''),(2614569,'1','57','447',174,'Sale Id shift 257447',0.00,0.00,0.00,410.00,0.00,'2023-02-08 09:21:32','',''),(2614570,'1','57',NULL,174,'Sale Id shift 257447',356700.00,0.00,0.00,0.00,0.00,'2023-02-08 09:21:32','',''),(2614571,'1','57','447',174,'Sale Id shift 257448',0.00,0.00,0.00,73.79,0.00,'2023-02-08 09:28:50','',''),(2614572,'1','57',NULL,174,'Sale Id shift 257448',64197.30,0.00,0.00,0.00,0.00,'2023-02-08 09:28:50','',''),(2614573,'1','57','447',174,'Sale Id shift 257450',0.00,0.00,0.00,155.75,0.00,'2023-02-09 15:39:59','',''),(2614574,'1','57',NULL,174,'Sale Id shift 257450',135502.50,0.00,0.00,0.00,0.00,'2023-02-09 15:39:59','',''),(2614575,'1','57','447',174,'Sale Id shift 257451',0.00,0.00,0.00,101.82,0.00,'2023-02-10 13:59:51','',''),(2614576,'1','57',NULL,174,'Sale Id shift 257451',88583.40,0.00,0.00,0.00,0.00,'2023-02-10 13:59:51','',''),(2614577,'1','57','447',174,'Sale Id shift 257452',0.00,0.00,0.00,46.26,0.00,'2023-02-10 19:46:52','',''),(2614578,'1','57',NULL,174,'Sale Id shift 257452',40246.20,0.00,0.00,0.00,0.00,'2023-02-10 19:46:52','',''),(2614579,'1','57','447',174,'Sale Id shift 257453',0.00,0.00,0.00,7.18,0.00,'2023-02-10 19:50:34','',''),(2614580,'1','57',NULL,174,'Sale Id shift 257453',6246.60,0.00,0.00,0.00,0.00,'2023-02-10 19:50:34','',''),(2614581,'1','57','447',174,'Sale Id shift 257454',0.00,0.00,0.00,764.84,0.00,'2023-02-10 19:56:44','',''),(2614582,'1','57',NULL,174,'Sale Id shift 257454',665410.80,0.00,0.00,0.00,0.00,'2023-02-10 19:56:44','',''),(2614583,'1','57','447',174,'Sale Id shift 257455',0.00,0.00,0.00,39.78,0.00,'2023-02-12 19:04:15','',''),(2614584,'1','57',NULL,174,'Sale Id shift 257455',34608.60,0.00,0.00,0.00,0.00,'2023-02-12 19:04:15','',''),(2614585,'1','57','447',174,'Sale Id shift 257456',0.00,0.00,0.00,1432.23,0.00,'2023-02-12 19:38:11','',''),(2614586,'1','57',NULL,174,'Sale Id shift 257456',1246040.10,0.00,0.00,0.00,0.00,'2023-02-12 19:38:11','',''),(2614587,'1','57','447',174,'Sale Id shift 257457',0.00,0.00,0.00,42.06,0.00,'2023-02-13 21:06:54','',''),(2614588,'1','57',NULL,174,'Sale Id shift 257457',36592.20,0.00,0.00,0.00,0.00,'2023-02-13 21:06:54','',''),(2614589,'1','57','447',174,'Sale Id shift 257458',0.00,0.00,0.00,1039.54,0.00,'2023-02-14 11:44:17','',''),(2614590,'1','57',NULL,174,'Sale Id shift 257458',904399.80,0.00,0.00,0.00,0.00,'2023-02-14 11:44:17','',''),(2614591,'1','57','447',174,'Sale Id shift 257459',0.00,0.00,0.00,16.56,0.00,'2023-02-14 20:34:05','',''),(2614592,'1','57',NULL,174,'Sale Id shift 257459',14407.20,0.00,0.00,0.00,0.00,'2023-02-14 20:34:05','',''),(2614593,'1','57','447',174,'Sale Id shift 257460',0.00,0.00,0.00,205.14,0.00,'2023-02-15 10:37:12','',''),(2614594,'1','57',NULL,174,'Sale Id shift 257460',178471.80,0.00,0.00,0.00,0.00,'2023-02-15 10:37:12','',''),(2614595,'1','57','447',174,'Sale Id shift 257461',0.00,0.00,0.00,104.43,0.00,'2023-02-15 21:54:30','',''),(2614596,'1','57',NULL,174,'Sale Id shift 257461',90854.10,0.00,0.00,0.00,0.00,'2023-02-15 21:54:30','',''),(2614597,'1','57','447',174,'Sale Id shift 257462',0.00,0.00,0.00,27.25,0.00,'2023-02-15 22:24:10','',''),(2614598,'1','57',NULL,174,'Sale Id shift 257462',23707.50,0.00,0.00,0.00,0.00,'2023-02-15 22:24:10','',''),(2614599,'1','57','447',174,'Sale Id shift 257464',0.00,0.00,0.00,58.05,0.00,'2023-02-15 22:35:12','',''),(2614600,'1','57',NULL,174,'Sale Id shift 257464',50503.50,0.00,0.00,0.00,0.00,'2023-02-15 22:35:12','',''),(2614601,'1','57','447',174,'Sale Id shift 257465',0.00,0.00,0.00,111.15,0.00,'2023-02-15 22:41:20','',''),(2614602,'1','57',NULL,174,'Sale Id shift 257465',96700.50,0.00,0.00,0.00,0.00,'2023-02-15 22:41:20','',''),(2614603,'1','57','447',174,'Sale Id shift 257467',0.00,0.00,0.00,530.86,0.00,'2023-02-17 18:48:14','',''),(2614604,'1','57',NULL,174,'Sale Id shift 257467',461848.20,0.00,0.00,0.00,0.00,'2023-02-17 18:48:14','',''),(2614605,'1','57','447',174,'Sale Id shift 257468',0.00,0.00,0.00,149.24,0.00,'2023-02-17 22:26:01','',''),(2614606,'1','57',NULL,174,'Sale Id shift 257468',129838.80,0.00,0.00,0.00,0.00,'2023-02-17 22:26:01','',''),(2614607,'1','57','447',174,'Sale Id shift 257469',0.00,0.00,0.00,23.69,0.00,'2023-02-18 21:31:28','',''),(2614608,'1','57',NULL,174,'Sale Id shift 257469',20610.30,0.00,0.00,0.00,0.00,'2023-02-18 21:31:28','',''),(2614609,'1','57','447',174,'Sale Id shift 257470',0.00,0.00,0.00,180.65,0.00,'2023-02-18 21:35:00','',''),(2614610,'1','57',NULL,174,'Sale Id shift 257470',157165.50,0.00,0.00,0.00,0.00,'2023-02-18 21:35:00','',''),(2614611,'1','57','447',174,'Sale Id shift 257472',0.00,0.00,0.00,12.58,0.00,'2023-02-21 12:00:24','',''),(2614612,'1','57',NULL,174,'Sale Id shift 257472',10944.60,0.00,0.00,0.00,0.00,'2023-02-21 12:00:24','',''),(2614613,'1','57','447',174,'Sale Id shift 257473',0.00,0.00,0.00,285.46,0.00,'2023-02-21 12:07:52','',''),(2614614,'1','57',NULL,174,'Sale Id shift 257473',248350.20,0.00,0.00,0.00,0.00,'2023-02-21 12:07:52','',''),(2614615,'1','57','447',174,'Sale Id shift 257474',0.00,0.00,0.00,72.31,0.00,'2023-02-21 15:01:03','',''),(2614616,'1','57',NULL,174,'Sale Id shift 257474',62909.70,0.00,0.00,0.00,0.00,'2023-02-21 15:01:03','',''),(2614617,'1','57','447',174,'Sale Id shift 257475',0.00,0.00,0.00,299.58,0.00,'2023-02-21 15:06:48','',''),(2614618,'1','57',NULL,174,'Sale Id shift 257475',260634.60,0.00,0.00,0.00,0.00,'2023-02-21 15:06:48','',''),(2614619,'1','57','447',174,'Sale Id shift 257476',0.00,0.00,0.00,296.61,0.00,'2023-02-21 16:11:04','',''),(2614620,'1','57',NULL,174,'Sale Id shift 257476',258050.70,0.00,0.00,0.00,0.00,'2023-02-21 16:11:04','',''),(2614621,'1','57','447',174,'Sale Id shift 257477',0.00,0.00,0.00,106.75,0.00,'2023-02-22 19:14:05','',''),(2614622,'1','57',NULL,174,'Sale Id shift 257477',90737.50,0.00,0.00,0.00,0.00,'2023-02-22 19:14:05','',''),(2614623,'1','57','447',174,'Sale Id shift 257478',0.00,0.00,0.00,582.94,0.00,'2023-02-23 12:10:44','',''),(2614624,'1','57',NULL,174,'Sale Id shift 257478',495499.00,0.00,0.00,0.00,0.00,'2023-02-23 12:10:44','',''),(2614625,'1','57','447',174,'Sale Id shift 257479',0.00,0.00,0.00,214.44,0.00,'2023-02-23 20:54:54','',''),(2614626,'1','57',NULL,174,'Sale Id shift 257479',182274.00,0.00,0.00,0.00,0.00,'2023-02-23 20:54:54','',''),(2614627,'1','57','447',174,'Sale Id shift 257480',0.00,0.00,0.00,340.82,0.00,'2023-02-23 21:14:00','',''),(2614628,'1','57',NULL,174,'Sale Id shift 257480',289697.00,0.00,0.00,0.00,0.00,'2023-02-23 21:14:00','',''),(2614629,'1','57','447',174,'Sale Id shift 257481',0.00,0.00,0.00,17.52,0.00,'2023-02-23 21:29:04','',''),(2614630,'1','57',NULL,174,'Sale Id shift 257481',14541.60,0.00,0.00,0.00,0.00,'2023-02-23 21:29:04','',''),(2614631,'1','57','447',174,'Sale Id shift 257482',0.00,0.00,0.00,730.95,0.00,'2023-02-23 22:19:49','',''),(2614632,'1','57',NULL,174,'Sale Id shift 257482',606688.50,0.00,0.00,0.00,0.00,'2023-02-23 22:19:49','',''),(2614633,'1','57','447',174,'Sale Id shift 257483',0.00,0.00,0.00,59.12,0.00,'2023-02-25 19:22:16','',''),(2614634,'1','57',NULL,174,'Sale Id shift 257483',49069.60,0.00,0.00,0.00,0.00,'2023-02-25 19:22:16','',''),(2614635,'1','57','447',174,'Sale Id shift 257484',0.00,0.00,0.00,132.49,0.00,'2023-02-26 22:26:50','',''),(2614636,'1','57',NULL,174,'Sale Id shift 257484',109966.70,0.00,0.00,0.00,0.00,'2023-02-26 22:26:50','',''),(2614637,'1','57','447',174,'Sale Id shift 257486',0.00,0.00,0.00,631.55,0.00,'2023-02-28 13:07:08','',''),(2614638,'1','57',NULL,174,'Sale Id shift 257486',524186.50,0.00,0.00,0.00,0.00,'2023-02-28 13:07:08','',''),(2614639,'1','57','447',174,'Sale Id shift 257487',0.00,0.00,0.00,138.00,0.00,'2023-02-28 14:16:31','',''),(2614640,'1','57',NULL,174,'Sale Id shift 257487',114540.00,0.00,0.00,0.00,0.00,'2023-02-28 14:16:31','',''),(2614641,'1','57','447',174,'Sale Id shift 257488',0.00,0.00,0.00,324.95,0.00,'2023-03-01 14:29:27','',''),(2614642,'1','57',NULL,174,'Sale Id shift 257488',269708.50,0.00,0.00,0.00,0.00,'2023-03-01 14:29:27','',''),(2614643,'1','57','447',174,'Sale Id shift 257489',0.00,0.00,0.00,424.20,0.00,'2023-03-01 19:29:34','',''),(2614644,'1','57',NULL,174,'Sale Id shift 257489',352086.00,0.00,0.00,0.00,0.00,'2023-03-01 19:29:34','',''),(2614645,'1','57','447',174,'Sale Id shift 257490',0.00,0.00,0.00,1055.95,0.00,'2023-03-01 20:12:21','',''),(2614646,'1','57',NULL,174,'Sale Id shift 257490',876438.50,0.00,0.00,0.00,0.00,'2023-03-01 20:12:21','',''),(2614647,'1','57','447',174,'Sale Id shift 257491',0.00,0.00,0.00,228.24,0.00,'2023-03-03 11:59:12','',''),(2614648,'1','57',NULL,174,'Sale Id shift 257491',189439.20,0.00,0.00,0.00,0.00,'2023-03-03 11:59:12','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'1','57',175,0.00,'2023-03-08 10:46:14'),(2,'1','57',174,-1523.70,'2023-03-08 10:46:14'),(3,'1','57',173,849.27,'2023-03-08 10:46:14');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1804607 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1464069,'1','57',173,'Sale Id shift 240535',0.00,73585.05,165.00,73585.05,0.00,'2021-11-21 13:48:23'),(1464155,'1','57',173,'Sale Id shift 240575',0.00,173713.65,165.00,173713.65,0.00,'2021-11-21 14:00:25'),(1464255,'1','57',173,'Sale Id shift 240579',0.00,701971.05,165.00,701971.05,0.00,'2021-11-21 14:14:38'),(1464322,'1','57',173,'Sale Id shift 240582',0.00,219829.50,165.00,219829.50,0.00,'2021-11-21 14:24:08'),(1464393,'1','57',173,'Sale Id shift 240584',0.00,322345.65,165.00,322345.65,0.00,'2021-11-21 14:35:16'),(1464468,'1','57',173,'Sale Id shift 240585',0.00,242853.60,165.00,242853.60,0.00,'2021-11-21 14:46:49'),(1464653,'1','57',173,'Sale Id shift 240586',0.00,589873.35,165.00,589873.35,0.00,'2021-11-21 15:13:51'),(1468179,'1','57',173,'Sale Id shift 240592',0.00,364988.25,165.00,364988.25,0.00,'2021-11-22 12:57:07'),(1469618,'1','57',173,'Sale Id shift 240812',0.00,379830.00,165.00,379830.00,0.00,'2021-11-22 16:02:07'),(1472628,'1','57',173,'Sale Id shift 240876',0.00,368702.40,165.00,368702.40,0.00,'2021-11-23 11:22:31'),(1476313,'1','57',173,'Sale Id shift 241137',0.00,397029.60,165.00,397029.60,0.00,'2021-11-24 09:18:04'),(1478927,'1','57',173,'Sale Id shift 241326',0.00,308637.45,165.00,308637.45,0.00,'2021-11-24 18:16:19'),(1478931,'1','57',173,'Sale Id shift 241419',0.00,329135.40,165.00,329135.40,0.00,'2021-11-24 18:24:28'),(1481099,'1','57',173,'Sale Id shift 241422',0.00,347551.05,165.00,347551.05,0.00,'2021-11-25 11:42:43'),(1499109,'1','57',173,'Sale Id shift 241662',0.00,141319.20,165.00,141319.20,0.00,'2021-11-29 10:28:50'),(1645036,'1','57',174,'Sale Id shift 248603',0.00,1228489.50,350.00,1228489.50,0.00,'2021-12-27 13:56:38'),(1652249,'1','57',174,'Sale Id shift 249475',0.00,209965.00,350.00,209965.00,0.00,'2021-12-29 08:57:20'),(1652284,'1','57',174,'Sale Id shift 249671',0.00,622713.00,350.00,622713.00,0.00,'2021-12-29 09:06:38'),(1652454,'1','57',174,'Sale Id shift 249679',0.00,32550.00,350.00,32550.00,0.00,'2021-12-29 09:31:29'),(1652489,'1','57',174,'Sale Id shift 249683',0.00,1419999.00,350.00,1419999.00,0.00,'2021-12-29 09:35:44'),(1652548,'1','57',174,'Sale Id shift 249685',0.00,517107.50,350.00,517107.50,0.00,'2021-12-29 09:45:28'),(1652585,'1','57',174,'Sale Id shift 249691',0.00,1133272.00,350.00,1133272.00,0.00,'2021-12-29 09:50:31'),(1652635,'1','57',174,'Sale Id shift 249694',0.00,31451.00,350.00,31451.00,0.00,'2021-12-29 09:56:33'),(1652650,'1','57',174,'Sale Id shift 249695',0.00,822286.50,350.00,822286.50,0.00,'2021-12-29 09:59:12'),(1663332,'1','57',174,'Sale Id shift 250001',0.00,578900.00,350.00,578900.00,0.00,'2021-12-31 10:58:04'),(1669715,'1','57',174,'Sale Id shift 250248',0.00,314867.00,350.00,314867.00,0.00,'2022-01-01 13:10:28'),(1669839,'1','57',174,'Sale Id shift 250461',0.00,213150.00,350.00,213150.00,0.00,'2022-01-01 13:29:06'),(1683024,'1','57',174,'Sale Id shift 250471',0.00,5288.50,350.00,5288.50,0.00,'2022-01-04 10:50:18'),(1683778,'1','57',174,'Sale Id shift 251124',0.00,334911.50,350.00,334911.50,0.00,'2022-01-04 12:17:02'),(1684142,'1','57',174,'Sale Id shift 251139',0.00,344900.50,350.00,344900.50,0.00,'2022-01-04 13:03:24'),(1684756,'1','57',174,'Sale Id shift 251157',0.00,325360.00,350.00,325360.00,0.00,'2022-01-04 14:15:17'),(1684785,'1','57',174,'Sale Id shift 251172',0.00,493202.50,350.00,493202.50,0.00,'2022-01-04 14:19:42'),(1684823,'1','57',174,'Sale Id shift 251173',0.00,362845.00,350.00,362845.00,0.00,'2022-01-04 14:24:33'),(1684867,'1','57',174,'Sale Id shift 251177',0.00,368672.50,350.00,368672.50,0.00,'2022-01-04 14:30:34'),(1687492,'1','57',174,'Sale Id shift 251179',0.00,259486.50,350.00,259486.50,0.00,'2022-01-05 09:56:16'),(1691669,'1','57',174,'Sale Id shift 251348',0.00,224304.50,350.00,224304.50,0.00,'2022-01-05 19:03:05'),(1699215,'1','57',174,'Sale Id shift 251480',0.00,175000.00,350.00,175000.00,0.00,'2022-01-07 11:45:44'),(1699624,'1','57',174,'Sale Id shift 251852',0.00,168595.00,350.00,168595.00,0.00,'2022-01-07 12:42:00'),(1701866,'1','57',174,'Sale Id shift 251862',0.00,384048.00,350.00,384048.00,0.00,'2022-01-07 17:54:13'),(1713237,'1','57',174,'Sale Id shift 251962',0.00,65667.00,350.00,65667.00,0.00,'2022-01-09 19:27:20'),(1715185,'1','57',174,'Sale Id shift 252568',0.00,423405.50,350.00,423405.50,0.00,'2022-01-10 11:10:06'),(1715327,'1','57',174,'Sale Id shift 252572',0.00,418775.00,350.00,418775.00,0.00,'2022-01-10 11:29:38'),(1715426,'1','57',174,'Sale Id shift 252576',0.00,122475.50,350.00,122475.50,0.00,'2022-01-10 11:43:10'),(1715479,'1','57',174,'Sale Id shift 252581',0.00,702198.00,350.00,702198.00,0.00,'2022-01-10 11:50:17'),(1715840,'1','57',174,'Sale Id shift 252584',0.00,703290.00,350.00,703290.00,0.00,'2022-01-10 12:34:50'),(1720155,'1','57',174,'Sale Id shift 252805',0.00,532129.50,350.00,532129.50,0.00,'2022-01-11 10:33:40'),(1720236,'1','57',174,'Sale Id shift 252807',0.00,212051.00,350.00,212051.00,0.00,'2022-01-11 10:44:10'),(1723627,'1','57',174,'Sale Id shift 252897',0.00,76979.00,350.00,76979.00,0.00,'2022-01-11 18:54:42'),(1724972,'1','57',174,'Sale Id shift 252932',0.00,556608.50,350.00,556608.50,0.00,'2022-01-12 09:56:02'),(1730322,'1','57',174,'Sale Id shift 253188',0.00,291389.00,350.00,291389.00,0.00,'2022-01-13 10:13:31'),(1730613,'1','57',174,'Sale Id shift 253287',0.00,551460.00,350.00,551460.00,0.00,'2022-01-13 10:44:05'),(1732799,'1','57',174,'Sale Id shift 253299',0.00,350000.00,350.00,350000.00,0.00,'2022-01-13 15:47:40'),(1735271,'1','57',174,'Sale Id shift 253408',0.00,333900.00,350.00,333900.00,0.00,'2022-01-14 09:49:06'),(1737306,'1','57',174,'Sale Id shift 253613',0.00,208257.00,350.00,208257.00,0.00,'2022-01-14 15:08:23'),(1740658,'1','57',174,'Sale Id shift 253635',0.00,191800.00,350.00,191800.00,0.00,'2022-01-15 10:45:22'),(1744825,'1','57',174,'Sale Id shift 253813',0.00,199500.00,350.00,199500.00,0.00,'2022-01-15 21:08:58'),(1748420,'1','57',174,'Sale Id shift 253921',0.00,218718.50,350.00,218718.50,0.00,'2022-01-16 16:11:00'),(1763299,'1','57',174,'Sale Id shift 254660',0.00,771018.50,350.00,771018.50,0.00,'2022-01-19 11:10:54'),(1766386,'1','57',174,'Sale Id shift 254866',0.00,162277.50,350.00,162277.50,0.00,'2022-01-19 17:08:41'),(1768961,'1','57',174,'Sale Id shift 254912',0.00,158200.00,350.00,158200.00,0.00,'2022-01-20 10:08:28'),(1771794,'1','57',174,'Sale Id shift 255105',0.00,591941.00,350.00,591941.00,0.00,'2022-01-20 15:43:43'),(1774919,'1','57',174,'Sale Id shift 255117',0.00,1113262.50,350.00,1113262.50,0.00,'2022-01-21 09:46:58'),(1778241,'1','57',174,'Sale Id shift 255308',0.00,218552.20,355.00,218552.20,0.00,'2022-01-21 16:36:38'),(1781251,'1','57',174,'Sale Id shift 255536',0.00,350676.10,355.00,350676.10,0.00,'2022-01-22 10:46:30'),(1784922,'1','57',174,'Sale Id shift 255626',0.00,375018.45,355.00,375018.45,0.00,'2022-01-22 17:18:34'),(1788396,'1','57',174,'Sale Id shift 255681',0.00,448152.00,355.00,448152.00,0.00,'2022-01-23 13:40:01'),(1790246,'1','57',174,'Sale Id shift 255864',0.00,6269.30,355.00,6269.30,0.00,'2022-01-23 17:18:58'),(1792030,'1','57',174,'Sale Id shift 255914',0.00,1972813.10,355.00,1972813.10,0.00,'2022-01-24 09:47:04'),(1795396,'1','57',174,'Sale Id shift 256112',0.00,400688.50,355.00,400688.50,0.00,'2022-01-24 16:49:53'),(1799689,'1','57',174,'Sale Id shift 256122',0.00,257176.20,355.00,257176.20,0.00,'2022-01-25 14:09:02'),(1804270,'1','57',174,'Sale Id shift 256400',0.00,355401.15,360.00,360406.80,5005.65,'2022-01-26 11:26:49'),(1804271,'1','57',174,'Sale Id shift 257161',0.00,668972.00,365.00,668972.00,0.00,'2022-02-04 15:07:30'),(1804272,'1','57',174,'Sale Id shift 257162',0.00,1129678.65,355.00,1098728.55,-30950.10,'2022-02-04 15:49:18'),(1804273,'1','57',174,'Sale Id shift 257163',0.00,508196.80,380.00,508196.80,0.00,'2022-02-05 20:52:11'),(1804274,'1','57',174,'Sale Id shift 257164',0.00,694138.40,380.00,694138.40,0.00,'2022-02-06 09:14:33'),(1804275,'1','57',174,'Sale Id shift 257165',0.00,428203.00,380.00,428203.00,0.00,'2022-02-06 09:26:37'),(1804276,'1','57',174,'Sale Id shift 257166',0.00,235102.20,380.00,235102.20,0.00,'2022-02-07 11:03:15'),(1804277,'1','57',174,'Sale Id shift 257167',0.00,698200.60,380.00,698200.60,0.00,'2022-02-07 11:22:55'),(1804278,'1','57',174,'Sale Id shift 257168',0.00,543430.40,380.00,543430.40,0.00,'2022-02-07 17:37:59'),(1804279,'1','57',174,'Sale Id shift 257169',0.00,696863.00,380.00,696863.00,0.00,'2022-02-08 09:48:17'),(1804280,'1','57',174,'Sale Id shift 257170',0.00,370948.40,380.00,370948.40,0.00,'2022-02-09 08:51:10'),(1804281,'1','57',174,'Sale Id shift 257171',0.00,1653919.60,380.00,1653919.60,0.00,'2022-02-09 11:15:52'),(1804282,'1','57',174,'Sale Id shift 257175',0.00,1257660.30,390.00,1257660.30,0.00,'2022-02-11 12:21:07'),(1804283,'1','57',174,'Sale Id shift 257176',0.00,363698.40,390.00,363698.40,0.00,'2022-02-12 11:49:16'),(1804284,'1','57',174,'Sale Id shift 257177',0.00,612296.10,390.00,612296.10,0.00,'2022-02-12 11:56:40'),(1804285,'1','57',174,'Sale Id shift 257178',0.00,246027.60,390.00,246027.60,0.00,'2022-02-13 21:21:20'),(1804286,'1','57',174,'Sale Id shift 257179',0.00,520884.00,400.00,520884.00,0.00,'2022-02-14 12:28:26'),(1804287,'1','57',174,'Sale Id shift 257180',0.00,110000.00,400.00,110000.00,0.00,'2022-02-14 12:43:40'),(1804288,'1','57',174,'Sale Id shift 257181',0.00,1299148.00,400.00,1299148.00,0.00,'2022-02-14 12:57:36'),(1804289,'1','57',174,'Sale Id shift 257182',0.00,481696.00,400.00,481696.00,0.00,'2022-02-15 10:49:30'),(1804290,'1','57',174,'Sale Id shift 257183',0.00,398304.00,400.00,398304.00,0.00,'2022-02-15 11:38:16'),(1804291,'1','57',174,'Sale Id shift 257184',0.00,173292.00,400.00,173292.00,0.00,'2022-02-15 18:19:58'),(1804292,'1','57',174,'Sale Id shift 257187',0.00,546848.00,410.00,560519.20,13671.20,'2022-02-16 13:54:49'),(1804293,'1','57',174,'Sale Id shift 257188',0.00,406832.00,410.00,417002.80,10170.80,'2022-02-17 10:56:52'),(1804294,'1','57',174,'Sale Id shift 257189',0.00,730676.00,410.00,748942.90,18266.90,'2022-02-17 11:34:26'),(1804295,'1','57',174,'Sale Id shift 257191',0.00,1072.00,400.00,1072.00,0.00,'2022-02-18 12:09:47'),(1804296,'1','57',174,'Sale Id shift 257192',0.00,187607.80,410.00,187607.80,0.00,'2022-02-18 12:34:14'),(1804297,'1','57',174,'Sale Id shift 257193',0.00,179145.40,410.00,179145.40,0.00,'2022-02-19 10:38:40'),(1804298,'1','57',174,'Sale Id shift 257194',0.00,213261.50,410.00,213261.50,0.00,'2022-02-19 10:48:42'),(1804299,'1','57',174,'Sale Id shift 257195',0.00,881090.00,410.00,881090.00,0.00,'2022-02-19 20:58:35'),(1804300,'1','57',174,'Sale Id shift 257196',0.00,83020.90,410.00,83020.90,0.00,'2022-02-20 19:31:22'),(1804301,'1','57',174,'Sale Id shift 257197',0.00,1701.50,410.00,1701.50,0.00,'2022-02-21 10:29:56'),(1804302,'1','57',174,'Sale Id shift 257198',0.00,653966.40,410.00,653966.40,0.00,'2022-02-21 13:50:46'),(1804303,'1','57',174,'Sale Id shift 257199',0.00,791611.60,410.00,791611.60,0.00,'2022-02-21 17:29:59'),(1804304,'1','57',174,'Sale Id shift 257200',0.00,391140.00,410.00,391140.00,0.00,'2022-02-22 10:46:52'),(1804305,'1','57',174,'Sale Id shift 257201',0.00,22718.10,410.00,22718.10,0.00,'2022-02-23 10:34:45'),(1804306,'1','57',174,'Sale Id shift 257202',0.00,822902.80,410.00,822902.80,0.00,'2022-02-23 11:33:26'),(1804307,'1','57',174,'Sale Id shift 257203',0.00,992474.70,410.00,992474.70,0.00,'2022-02-23 23:00:04'),(1804308,'1','57',174,'Sale Id shift 257204',0.00,453037.70,410.00,453037.70,0.00,'2022-02-24 10:22:56'),(1804309,'1','57',174,'Sale Id shift 257205',0.00,1482154.10,410.00,1482154.10,0.00,'2022-02-25 11:01:13'),(1804310,'1','57',174,'Sale Id shift 257206',0.00,322149.30,410.00,322149.30,0.00,'2022-02-25 11:15:36'),(1804311,'1','57',174,'Sale Id shift 257207',0.00,729980.40,410.00,729980.40,0.00,'2022-02-25 15:10:58'),(1804312,'1','57',174,'Sale Id shift 257208',0.00,46088.10,410.00,46088.10,0.00,'2022-02-26 16:55:10'),(1804313,'1','57',174,'Sale Id shift 257209',0.00,577563.80,415.00,577563.80,0.00,'2022-02-27 09:35:36'),(1804314,'1','57',174,'Sale Id shift 257210',0.00,311266.60,415.00,311266.60,0.00,'2022-02-28 10:25:00'),(1804315,'1','57',174,'Sale Id shift 257211',0.00,1077377.35,415.00,1077377.35,0.00,'2022-02-28 10:47:48'),(1804316,'1','57',174,'Sale Id shift 257212',0.00,1460800.00,415.00,1460800.00,0.00,'2022-02-28 14:20:36'),(1804317,'1','57',174,'Sale Id shift 257213',0.00,715389.45,415.00,715389.45,0.00,'2022-02-28 15:18:13'),(1804318,'1','57',174,'Sale Id shift 257214',0.00,249020.75,415.00,249020.75,0.00,'2022-03-01 18:09:48'),(1804319,'1','57',174,'Sale Id shift 257215',0.00,423432.80,415.00,423432.80,0.00,'2022-03-01 18:17:12'),(1804320,'1','57',174,'Sale Id shift 257216',0.00,1148305.00,415.00,1148305.00,0.00,'2022-03-02 17:41:59'),(1804321,'1','57',174,'Sale Id shift 257220',0.00,484433.70,430.00,484433.70,0.00,'2022-03-04 13:44:12'),(1804322,'1','57',174,'Sale Id shift 257221',0.00,938161.10,430.00,938161.10,0.00,'2022-03-04 16:26:37'),(1804323,'1','57',174,'Sale Id shift 257222',0.00,452622.30,430.00,452622.30,0.00,'2022-03-05 09:48:06'),(1804324,'1','57',174,'Sale Id shift 257223',0.00,435983.40,460.00,435983.40,0.00,'2022-03-05 11:56:44'),(1804325,'1','57',174,'Sale Id shift 257224',0.00,2051581.60,460.00,2051581.60,0.00,'2022-03-07 02:14:47'),(1804326,'1','57',174,'Sale Id shift 257225',0.00,249535.00,500.00,249535.00,0.00,'2022-03-07 08:25:20'),(1804327,'1','57',174,'Sale Id shift 257226',0.00,1056040.00,500.00,1056040.00,0.00,'2022-03-07 08:35:22'),(1804328,'1','57',174,'Sale Id shift 257228',0.00,910005.00,500.00,910005.00,0.00,'2022-03-07 11:27:11'),(1804329,'1','57',174,'Sale Id shift 257229',0.00,1000000.00,500.00,1000000.00,0.00,'2022-03-07 17:01:15'),(1804330,'1','57',174,'Sale Id shift 257230',0.00,1000.00,500.00,1000.00,0.00,'2022-03-08 14:18:04'),(1804331,'1','57',174,'Sale Id shift 257231',0.00,1001640.00,500.00,1001640.00,0.00,'2022-03-09 08:33:21'),(1804332,'1','57',174,'Sale Id shift 257232',0.00,121212.00,600.00,121212.00,0.00,'2022-03-09 10:20:21'),(1804333,'1','57',174,'Sale Id shift 257233',0.00,300.00,600.00,300.00,0.00,'2022-03-10 10:44:36'),(1804334,'1','57',174,'Sale Id shift 257234',0.00,300.00,600.00,300.00,0.00,'2022-03-10 16:44:14'),(1804335,'1','57',174,'Sale Id shift 257235',0.00,934944.00,600.00,934944.00,0.00,'2022-03-10 16:50:52'),(1804336,'1','57',174,'Sale Id shift 257236',0.00,1503498.00,600.00,1503498.00,0.00,'2022-03-11 11:44:56'),(1804337,'1','57',174,'Sale Id shift 257237',0.00,301194.00,600.00,301194.00,0.00,'2022-03-11 21:21:53'),(1804338,'1','57',174,'Sale Id shift 257238',0.00,139200.00,600.00,139200.00,0.00,'2022-03-12 22:18:04'),(1804339,'1','57',174,'Sale Id shift 257240',0.00,288904.00,700.00,288904.00,0.00,'2022-03-28 10:44:02'),(1804340,'1','57',174,'Sale Id shift 257241',0.00,708099.00,700.00,708099.00,0.00,'2022-03-28 20:24:40'),(1804341,'1','57',174,'Sale Id shift 257242',0.00,17997.00,700.00,17997.00,0.00,'2022-03-29 11:37:17'),(1804342,'1','57',174,'Sale Id shift 257243',0.00,217203.00,700.00,217203.00,0.00,'2022-03-29 18:25:01'),(1804343,'1','57',174,'Sale Id shift 257244',0.00,224497.00,700.00,224497.00,0.00,'2022-03-30 09:38:58'),(1804344,'1','57',174,'Sale Id shift 257245',0.00,18893.00,700.00,18893.00,0.00,'2022-03-31 09:39:41'),(1804345,'1','57',174,'Sale Id shift 257247',0.00,6993.00,700.00,6993.00,0.00,'2022-04-01 10:34:18'),(1804346,'1','57',174,'Sale Id shift 257248',0.00,21000.00,700.00,21000.00,0.00,'2022-04-01 11:10:18'),(1804347,'1','57',174,'Sale Id shift 257249',0.00,9205.00,700.00,9205.00,0.00,'2022-04-02 12:30:30'),(1804348,'1','57',174,'Sale Id shift 257250',0.00,65422.00,700.00,65422.00,0.00,'2022-04-02 23:01:04'),(1804349,'1','57',174,'Sale Id shift 257251',0.00,78407.00,700.00,78407.00,0.00,'2022-04-02 23:10:48'),(1804350,'1','57',174,'Sale Id shift 257252',0.00,1700181.00,700.00,1700181.00,0.00,'2022-04-02 23:15:17'),(1804351,'1','57',174,'Sale Id shift 257253',0.00,4998.00,700.00,4998.00,0.00,'2022-04-04 09:33:10'),(1804352,'1','57',174,'Sale Id shift 257254',0.00,6720.00,700.00,6720.00,0.00,'2022-04-04 11:00:42'),(1804353,'1','57',174,'Sale Id shift 257255',0.00,64792.00,700.00,64792.00,0.00,'2022-04-05 09:59:59'),(1804354,'1','57',174,'Sale Id shift 257256',0.00,34496.00,700.00,34496.00,0.00,'2022-04-05 11:29:40'),(1804355,'1','57',174,'Sale Id shift 257257',0.00,42000.00,700.00,42000.00,0.00,'2022-04-05 22:42:40'),(1804356,'1','57',174,'Sale Id shift 257259',0.00,30303.00,700.00,30303.00,0.00,'2022-04-06 14:51:53'),(1804357,'1','57',174,'Sale Id shift 257260',0.00,18613.00,700.00,18613.00,0.00,'2022-04-07 10:00:08'),(1804358,'1','57',174,'Sale Id shift 257261',0.00,840.00,700.00,840.00,0.00,'2022-04-07 11:15:29'),(1804359,'1','57',174,'Sale Id shift 257263',0.00,2184.00,700.00,2184.00,0.00,'2022-04-08 11:34:56'),(1804360,'1','57',174,'Sale Id shift 257265',0.00,86576.00,700.00,86576.00,0.00,'2022-04-09 16:48:23'),(1804361,'1','57',174,'Sale Id shift 257267',0.00,9401.00,700.00,9401.00,0.00,'2022-04-11 10:16:49'),(1804362,'1','57',174,'Sale Id shift 257269',0.00,590947.00,700.00,590947.00,0.00,'2022-04-11 10:37:15'),(1804363,'1','57',174,'Sale Id shift 257270',0.00,234500.00,700.00,234500.00,0.00,'2022-04-12 09:28:51'),(1804364,'1','57',174,'Sale Id shift 257271',0.00,151998.00,700.00,151998.00,0.00,'2022-04-12 10:55:57'),(1804365,'1','57',174,'Sale Id shift 257272',0.00,377300.00,700.00,377300.00,0.00,'2022-04-13 09:09:03'),(1804366,'1','57',174,'Sale Id shift 257273',0.00,382305.00,700.00,382305.00,0.00,'2022-04-13 13:23:15'),(1804367,'1','57',174,'Sale Id shift 257275',0.00,3948.00,700.00,3948.00,0.00,'2022-04-14 11:43:56'),(1804368,'1','57',174,'Sale Id shift 257276',0.00,37737.00,700.00,37737.00,0.00,'2022-04-14 18:03:27'),(1804369,'1','57',174,'Sale Id shift 257278',0.00,3801.00,700.00,3801.00,0.00,'2022-04-16 11:49:03'),(1804370,'1','57',174,'Sale Id shift 257279',0.00,88403.00,700.00,88403.00,0.00,'2022-04-16 13:55:15'),(1804371,'1','57',174,'Sale Id shift 257280',0.00,2898.00,700.00,2898.00,0.00,'2022-04-17 17:44:05'),(1804372,'1','57',174,'Sale Id shift 257281',0.00,708498.00,700.00,708498.00,0.00,'2022-04-18 08:17:57'),(1804373,'1','57',174,'Sale Id shift 257282',0.00,688800.00,700.00,688800.00,0.00,'2022-04-18 09:31:34'),(1804374,'1','57',174,'Sale Id shift 257283',0.00,2800.00,700.00,2800.00,0.00,'2022-04-18 14:53:28'),(1804375,'1','57',174,'Sale Id shift 257285',0.00,43400.00,700.00,43400.00,0.00,'2022-04-19 21:23:30'),(1804376,'1','57',174,'Sale Id shift 257286',0.00,140000.00,700.00,140000.00,0.00,'2022-04-19 21:27:46'),(1804377,'1','57',174,'Sale Id shift 257287',0.00,239260.00,700.00,239260.00,0.00,'2022-04-20 11:21:48'),(1804378,'1','57',174,'Sale Id shift 257288',0.00,332500.00,665.00,332500.00,0.00,'2022-04-21 04:50:49'),(1804379,'1','57',174,'Sale Id shift 257289',0.00,199466.75,665.00,199466.75,0.00,'2022-04-21 12:44:39'),(1804380,'1','57',174,'Sale Id shift 257290',0.00,493928.75,665.00,493928.75,0.00,'2022-04-22 10:32:52'),(1804381,'1','57',174,'Sale Id shift 257291',0.00,954667.35,665.00,954667.35,0.00,'2022-04-22 15:42:31'),(1804382,'1','57',174,'Sale Id shift 257292',0.00,368443.25,665.00,368443.25,0.00,'2022-04-23 08:21:31'),(1804383,'1','57',174,'Sale Id shift 257293',0.00,320503.40,665.00,320503.40,0.00,'2022-04-23 12:08:58'),(1804384,'1','57',174,'Sale Id shift 257295',0.00,245398.30,665.00,245398.30,0.00,'2022-04-24 21:22:11'),(1804385,'1','57',174,'Sale Id shift 257297',0.00,568189.30,665.00,568189.30,0.00,'2022-04-25 20:57:31'),(1804386,'1','57',174,'Sale Id shift 257298',0.00,581123.55,665.00,581123.55,0.00,'2022-04-25 22:42:15'),(1804387,'1','57',174,'Sale Id shift 257299',0.00,305574.15,665.00,305574.15,0.00,'2022-04-26 10:34:01'),(1804388,'1','57',174,'Sale Id shift 257301',0.00,134192.00,800.00,134192.00,0.00,'2022-09-03 14:02:17'),(1804389,'1','57',174,'Sale Id shift 257302',0.00,482984.00,800.00,482984.00,0.00,'2022-09-03 20:21:34'),(1804390,'1','57',173,'Sale Id shift 257304',0.00,12973.95,165.00,12973.95,0.00,'2022-09-05 09:43:17'),(1804391,'1','57',174,'Sale Id shift 257304',0.00,44624.00,800.00,44624.00,0.00,'2022-09-05 09:43:17'),(1804392,'1','57',173,'Sale Id shift 257305',0.00,37388.20,190.00,37388.20,0.00,'2022-09-05 21:28:33'),(1804393,'1','57',174,'Sale Id shift 257305',0.00,89912.00,800.00,89912.00,0.00,'2022-09-05 21:28:33'),(1804394,'1','57',174,'Sale Id shift 257306',0.00,57904.00,800.00,57904.00,0.00,'2022-09-06 12:42:21'),(1804395,'1','57',173,'Sale Id shift 257306',0.00,54252.60,190.00,54252.60,0.00,'2022-09-06 12:42:21'),(1804396,'1','57',174,'Sale Id shift 257307',0.00,568040.00,800.00,568040.00,0.00,'2022-09-06 16:02:26'),(1804397,'1','57',173,'Sale Id shift 257307',0.00,41321.20,190.00,41321.20,0.00,'2022-09-06 16:02:26'),(1804398,'1','57',173,'Sale Id shift 257308',0.00,68721.10,190.00,68721.10,0.00,'2022-09-07 15:51:36'),(1804399,'1','57',174,'Sale Id shift 257308',0.00,495456.00,800.00,495456.00,0.00,'2022-09-07 15:51:36'),(1804400,'1','57',173,'Sale Id shift 257309',0.00,28207.40,190.00,28207.40,0.00,'2022-09-08 13:07:31'),(1804401,'1','57',174,'Sale Id shift 257309',0.00,64904.00,800.00,64904.00,0.00,'2022-09-08 13:07:31'),(1804402,'1','57',174,'Sale Id shift 257310',0.00,50080.00,800.00,50080.00,0.00,'2022-09-08 14:23:01'),(1804403,'1','57',173,'Sale Id shift 257310',0.00,50811.70,190.00,50811.70,0.00,'2022-09-08 14:23:01'),(1804404,'1','57',173,'Sale Id shift 257311',0.00,45461.30,190.00,45461.30,0.00,'2022-09-08 17:45:21'),(1804405,'1','57',174,'Sale Id shift 257311',0.00,575056.00,800.00,575056.00,0.00,'2022-09-08 17:45:21'),(1804406,'1','57',174,'Sale Id shift 257312',0.00,406064.00,800.00,406064.00,0.00,'2022-09-09 17:31:23'),(1804407,'1','57',173,'Sale Id shift 257312',0.00,32444.40,190.00,32444.40,0.00,'2022-09-09 17:31:23'),(1804408,'1','57',174,'Sale Id shift 257313',0.00,524808.00,800.00,524808.00,0.00,'2022-09-10 07:30:41'),(1804409,'1','57',173,'Sale Id shift 257313',0.00,41923.50,190.00,41923.50,0.00,'2022-09-10 07:30:41'),(1804410,'1','57',173,'Sale Id shift 257314',0.00,29239.10,190.00,29239.10,0.00,'2022-09-10 15:05:41'),(1804411,'1','57',174,'Sale Id shift 257314',0.00,10984.00,800.00,10984.00,0.00,'2022-09-10 15:05:41'),(1804412,'1','57',174,'Sale Id shift 257315',0.00,583456.00,800.00,583456.00,0.00,'2022-09-10 22:19:29'),(1804413,'1','57',173,'Sale Id shift 257315',0.00,12097.30,190.00,12097.30,0.00,'2022-09-10 22:19:29'),(1804414,'1','57',174,'Sale Id shift 257316',0.00,796800.00,800.00,796800.00,0.00,'2022-09-11 12:30:40'),(1804415,'1','57',173,'Sale Id shift 257316',0.00,35949.90,190.00,35949.90,0.00,'2022-09-11 12:30:40'),(1804416,'1','57',174,'Sale Id shift 257317',0.00,66008.00,800.00,66008.00,0.00,'2022-09-11 19:59:54'),(1804417,'1','57',173,'Sale Id shift 257317',0.00,67731.20,190.00,67731.20,0.00,'2022-09-11 19:59:54'),(1804418,'1','57',174,'Sale Id shift 257318',0.00,50208.00,800.00,50208.00,0.00,'2022-09-12 08:13:44'),(1804419,'1','57',173,'Sale Id shift 257318',0.00,108089.10,190.00,108089.10,0.00,'2022-09-12 08:13:44'),(1804420,'1','57',174,'Sale Id shift 257319',0.00,592184.00,800.00,592184.00,0.00,'2022-09-12 11:50:07'),(1804421,'1','57',173,'Sale Id shift 257319',0.00,133193.80,190.00,133193.80,0.00,'2022-09-12 11:50:07'),(1804422,'1','57',174,'Sale Id shift 257320',0.00,160008.00,800.00,160008.00,0.00,'2022-09-13 11:56:19'),(1804423,'1','57',173,'Sale Id shift 257320',0.00,67003.50,190.00,67003.50,0.00,'2022-09-13 11:56:19'),(1804424,'1','57',174,'Sale Id shift 257321',0.00,402808.00,800.00,402808.00,0.00,'2022-09-13 14:28:05'),(1804425,'1','57',173,'Sale Id shift 257321',0.00,69429.80,190.00,69429.80,0.00,'2022-09-13 14:28:05'),(1804426,'1','57',174,'Sale Id shift 257322',0.00,87504.00,800.00,87504.00,0.00,'2022-09-14 11:23:58'),(1804427,'1','57',173,'Sale Id shift 257322',0.00,68297.40,190.00,68297.40,0.00,'2022-09-14 11:23:58'),(1804428,'1','57',174,'Sale Id shift 257323',0.00,402104.00,800.00,402104.00,0.00,'2022-09-14 16:20:03'),(1804429,'1','57',173,'Sale Id shift 257323',0.00,42694.90,190.00,42694.90,0.00,'2022-09-14 16:20:03'),(1804430,'1','57',174,'Sale Id shift 257324',0.00,40000.00,800.00,40000.00,0.00,'2022-09-15 11:54:11'),(1804431,'1','57',173,'Sale Id shift 257324',0.00,64278.90,190.00,64278.90,0.00,'2022-09-15 11:54:11'),(1804432,'1','57',174,'Sale Id shift 257325',0.00,244408.00,800.00,244408.00,0.00,'2022-09-15 16:48:25'),(1804433,'1','57',173,'Sale Id shift 257325',0.00,46259.30,190.00,46259.30,0.00,'2022-09-15 16:48:25'),(1804434,'1','57',174,'Sale Id shift 257326',0.00,162304.00,800.00,162304.00,0.00,'2022-09-16 12:53:37'),(1804435,'1','57',173,'Sale Id shift 257326',0.00,84608.90,190.00,84608.90,0.00,'2022-09-16 12:53:37'),(1804436,'1','57',174,'Sale Id shift 257327',0.00,21552.00,800.00,21552.00,0.00,'2022-09-16 15:18:06'),(1804437,'1','57',173,'Sale Id shift 257327',0.00,66954.10,190.00,66954.10,0.00,'2022-09-16 15:18:06'),(1804438,'1','57',173,'Sale Id shift 257328',0.00,49612.80,190.00,49612.80,0.00,'2022-09-17 12:05:32'),(1804439,'1','57',174,'Sale Id shift 257328',0.00,510912.00,800.00,510912.00,0.00,'2022-09-17 12:05:32'),(1804440,'1','57',174,'Sale Id shift 257329',0.00,469016.00,800.00,469016.00,0.00,'2022-09-18 08:23:02'),(1804441,'1','57',173,'Sale Id shift 257329',0.00,38165.30,190.00,38165.30,0.00,'2022-09-18 08:23:02'),(1804442,'1','57',174,'Sale Id shift 257330',0.00,481048.00,800.00,481048.00,0.00,'2022-09-18 09:35:31'),(1804443,'1','57',173,'Sale Id shift 257330',0.00,54129.10,190.00,54129.10,0.00,'2022-09-18 09:35:31'),(1804444,'1','57',173,'Sale Id shift 257331',0.00,52060.00,190.00,52060.00,0.00,'2022-09-19 08:05:29'),(1804445,'1','57',174,'Sale Id shift 257331',0.00,517112.00,800.00,517112.00,0.00,'2022-09-19 08:05:29'),(1804446,'1','57',174,'Sale Id shift 257332',0.00,264000.00,800.00,264000.00,0.00,'2022-09-19 12:02:56'),(1804447,'1','57',173,'Sale Id shift 257332',0.00,73056.90,190.00,73056.90,0.00,'2022-09-19 12:02:56'),(1804448,'1','57',174,'Sale Id shift 257333',0.00,2712.00,800.00,2712.00,0.00,'2022-09-19 12:13:26'),(1804449,'1','57',173,'Sale Id shift 257333',0.00,59046.30,190.00,59046.30,0.00,'2022-09-19 12:13:26'),(1804450,'1','57',173,'Sale Id shift 257334',0.00,52886.50,190.00,52886.50,0.00,'2022-09-20 00:06:14'),(1804451,'1','57',174,'Sale Id shift 257334',0.00,488800.00,800.00,488800.00,0.00,'2022-09-20 00:06:14'),(1804452,'1','57',174,'Sale Id shift 257335',0.00,43400.00,800.00,43400.00,0.00,'2022-09-20 09:48:27'),(1804453,'1','57',173,'Sale Id shift 257335',0.00,68903.50,190.00,68903.50,0.00,'2022-09-20 09:48:27'),(1804454,'1','57',174,'Sale Id shift 257336',0.00,125704.00,800.00,125704.00,0.00,'2022-09-21 10:19:52'),(1804455,'1','57',173,'Sale Id shift 257336',0.00,118419.40,190.00,118419.40,0.00,'2022-09-21 10:19:52'),(1804456,'1','57',174,'Sale Id shift 257337',0.00,51704.00,800.00,51704.00,0.00,'2022-09-21 11:12:05'),(1804457,'1','57',173,'Sale Id shift 257337',0.00,68958.60,190.00,68958.60,0.00,'2022-09-21 11:12:05'),(1804458,'1','57',173,'Sale Id shift 257338',0.00,112590.20,190.00,112590.20,0.00,'2022-09-22 11:29:43'),(1804459,'1','57',174,'Sale Id shift 257338',0.00,162016.00,800.00,162016.00,0.00,'2022-09-22 11:29:43'),(1804460,'1','57',174,'Sale Id shift 257339',0.00,405528.00,800.00,405528.00,0.00,'2022-09-22 12:00:19'),(1804461,'1','57',173,'Sale Id shift 257339',0.00,101140.80,190.00,101140.80,0.00,'2022-09-22 12:00:19'),(1804462,'1','57',173,'Sale Id shift 257340',0.00,70476.70,190.00,70476.70,0.00,'2022-09-23 11:07:41'),(1804463,'1','57',174,'Sale Id shift 257340',0.00,382360.00,800.00,382360.00,0.00,'2022-09-23 11:07:41'),(1804464,'1','57',173,'Sale Id shift 257341',0.00,394447.60,190.00,394447.60,0.00,'2022-09-23 11:45:14'),(1804465,'1','57',174,'Sale Id shift 257341',0.00,24800.00,800.00,24800.00,0.00,'2022-09-23 11:45:14'),(1804466,'1','57',173,'Sale Id shift 257342',0.00,109502.70,190.00,109502.70,0.00,'2022-09-24 21:45:50'),(1804467,'1','57',174,'Sale Id shift 257342',0.00,200000.00,800.00,200000.00,0.00,'2022-09-24 21:45:50'),(1804468,'1','57',174,'Sale Id shift 257343',0.00,335200.00,800.00,335200.00,0.00,'2022-09-25 10:20:59'),(1804469,'1','57',173,'Sale Id shift 257343',0.00,55616.80,190.00,55616.80,0.00,'2022-09-25 10:20:59'),(1804470,'1','57',173,'Sale Id shift 257346',0.00,469721.80,190.00,469721.80,0.00,'2022-09-25 14:06:23'),(1804471,'1','57',173,'Sale Id shift 257347',0.00,59010.20,190.00,59010.20,0.00,'2022-09-25 14:11:12'),(1804472,'1','57',173,'Sale Id shift 257348',0.00,288549.20,190.00,288549.20,0.00,'2022-09-26 11:44:37'),(1804473,'1','57',173,'Sale Id shift 257349',0.00,182548.20,190.00,182548.20,0.00,'2022-09-26 11:56:43'),(1804474,'1','57',173,'Sale Id shift 257350',0.00,78912.70,190.00,78912.70,0.00,'2022-09-27 10:34:44'),(1804475,'1','57',173,'Sale Id shift 257351',0.00,167372.90,190.00,167372.90,0.00,'2022-09-27 11:29:14'),(1804476,'1','57',173,'Sale Id shift 257352',0.00,159292.20,190.00,159292.20,0.00,'2022-09-28 11:19:09'),(1804477,'1','57',173,'Sale Id shift 257353',0.00,94331.20,190.00,94331.20,0.00,'2022-09-28 13:19:10'),(1804478,'1','57',173,'Sale Id shift 257354',0.00,230312.30,190.00,230312.30,0.00,'2022-09-28 15:38:14'),(1804479,'1','57',173,'Sale Id shift 257355',0.00,151067.10,190.00,151067.10,0.00,'2022-09-29 12:21:46'),(1804480,'1','57',173,'Sale Id shift 257356',0.00,132576.30,190.00,132576.30,0.00,'2022-09-30 07:40:32'),(1804481,'1','57',173,'Sale Id shift 257357',0.00,94074.70,190.00,94074.70,0.00,'2022-09-30 12:12:47'),(1804482,'1','57',173,'Sale Id shift 257358',0.00,108911.80,190.00,108911.80,0.00,'2022-09-30 16:18:58'),(1804483,'1','57',173,'Sale Id shift 257359',0.00,207081.00,190.00,207081.00,0.00,'2022-10-02 15:23:58'),(1804484,'1','57',173,'Sale Id shift 257360',0.00,76752.40,190.00,76752.40,0.00,'2022-10-02 19:54:00'),(1804485,'1','57',173,'Sale Id shift 257361',0.00,180950.30,190.00,180950.30,0.00,'2022-10-03 15:37:28'),(1804486,'1','57',173,'Sale Id shift 257362',0.00,88674.90,190.00,88674.90,0.00,'2022-10-03 17:52:58'),(1804487,'1','57',173,'Sale Id shift 257363',0.00,149412.20,190.00,149412.20,0.00,'2022-10-03 18:00:22'),(1804488,'1','57',173,'Sale Id shift 257364',0.00,98929.20,190.00,98929.20,0.00,'2022-10-03 18:20:03'),(1804489,'1','57',173,'Sale Id shift 257365',0.00,198683.00,190.00,198683.00,0.00,'2022-10-04 14:16:24'),(1804490,'1','57',173,'Sale Id shift 257366',0.00,144956.70,190.00,144956.70,0.00,'2022-10-05 11:27:16'),(1804491,'1','57',173,'Sale Id shift 257367',0.00,186243.70,190.00,186243.70,0.00,'2022-10-05 12:28:02'),(1804492,'1','57',173,'Sale Id shift 257368',0.00,157922.30,190.00,157922.30,0.00,'2022-10-06 11:42:34'),(1804493,'1','57',173,'Sale Id shift 257369',0.00,174627.10,190.00,174627.10,0.00,'2022-10-07 09:38:36'),(1804494,'1','57',173,'Sale Id shift 257370',0.00,86558.30,190.00,86558.30,0.00,'2022-10-07 10:28:39'),(1804495,'1','57',173,'Sale Id shift 257371',0.00,160388.50,190.00,160388.50,0.00,'2022-10-07 11:43:54'),(1804496,'1','57',173,'Sale Id shift 257372',0.00,79239.50,190.00,79239.50,0.00,'2022-10-07 20:19:03'),(1804497,'1','57',173,'Sale Id shift 257373',0.00,344572.60,190.00,344572.60,0.00,'2022-10-08 09:46:45'),(1804498,'1','57',173,'Sale Id shift 257374',0.00,81764.60,190.00,81764.60,0.00,'2022-10-09 21:54:25'),(1804499,'1','57',173,'Sale Id shift 257375',0.00,37901.20,190.00,37901.20,0.00,'2022-10-11 11:55:51'),(1804500,'1','57',173,'Sale Id shift 257377',0.00,824483.80,245.00,824483.80,0.00,'2022-11-16 15:57:54'),(1804501,'1','57',173,'Sale Id shift 257378',0.00,1455486.20,245.00,1455486.20,0.00,'2022-11-17 01:07:32'),(1804502,'1','57',173,'Sale Id shift 257379',0.00,175767.90,245.00,175767.90,0.00,'2022-11-17 15:05:11'),(1804503,'1','57',173,'Sale Id shift 257380',0.00,410561.20,245.00,410561.20,0.00,'2022-11-17 15:23:39'),(1804504,'1','57',173,'Sale Id shift 257381',0.00,766504.55,245.00,766504.55,0.00,'2022-11-18 11:25:02'),(1804505,'1','57',173,'Sale Id shift 257382',0.00,105898.80,245.00,105898.80,0.00,'2022-11-21 00:10:52'),(1804506,'1','57',174,'Sale Id shift 257384',0.00,855663.80,890.00,855663.80,0.00,'2023-01-06 10:28:21'),(1804507,'1','57',174,'Sale Id shift 257385',0.00,623000.00,890.00,623000.00,0.00,'2023-01-06 17:34:13'),(1804508,'1','57',174,'Sale Id shift 257386',0.00,692250.90,890.00,692250.90,0.00,'2023-01-08 09:40:56'),(1804509,'1','57',174,'Sale Id shift 257387',0.00,122419.50,890.00,122419.50,0.00,'2023-01-08 19:01:41'),(1804510,'1','57',174,'Sale Id shift 257388',0.00,71200.00,890.00,71200.00,0.00,'2023-01-09 03:49:20'),(1804511,'1','57',174,'Sale Id shift 257389',0.00,11596.70,890.00,11596.70,0.00,'2023-01-09 11:45:58'),(1804512,'1','57',174,'Sale Id shift 257390',0.00,720650.80,890.00,720650.80,0.00,'2023-01-10 10:50:51'),(1804513,'1','57',174,'Sale Id shift 257391',0.00,66750.00,890.00,66750.00,0.00,'2023-01-10 20:42:51'),(1804514,'1','57',174,'Sale Id shift 257392',0.00,437604.10,890.00,437604.10,0.00,'2023-01-10 20:51:36'),(1804515,'1','57',174,'Sale Id shift 257393',0.00,160200.00,890.00,160200.00,0.00,'2023-01-10 21:01:42'),(1804516,'1','57',174,'Sale Id shift 257394',0.00,759116.60,890.00,759116.60,0.00,'2023-01-10 21:13:01'),(1804517,'1','57',174,'Sale Id shift 257395',0.00,464802.50,890.00,464802.50,0.00,'2023-01-11 11:24:03'),(1804518,'1','57',174,'Sale Id shift 257396',0.00,279566.80,890.00,279566.80,0.00,'2023-01-12 07:30:50'),(1804519,'1','57',174,'Sale Id shift 257397',0.00,58401.80,890.00,58401.80,0.00,'2023-01-12 19:56:03'),(1804520,'1','57',174,'Sale Id shift 257398',0.00,182636.90,890.00,182636.90,0.00,'2023-01-13 17:17:14'),(1804521,'1','57',174,'Sale Id shift 257399',0.00,86614.80,890.00,86614.80,0.00,'2023-01-14 10:31:29'),(1804522,'1','57',174,'Sale Id shift 257400',0.00,884927.00,890.00,884927.00,0.00,'2023-01-14 10:48:29'),(1804523,'1','57',174,'Sale Id shift 257401',0.00,2002.50,890.00,2002.50,0.00,'2023-01-15 07:48:07'),(1804524,'1','57',174,'Sale Id shift 257402',0.00,178996.80,890.00,178996.80,0.00,'2023-01-15 13:26:08'),(1804525,'1','57',174,'Sale Id shift 257403',0.00,44500.00,890.00,44500.00,0.00,'2023-01-16 13:54:22'),(1804526,'1','57',174,'Sale Id shift 257404',0.00,277199.40,890.00,277199.40,0.00,'2023-01-16 14:08:21'),(1804527,'1','57',174,'Sale Id shift 257405',0.00,1456271.40,890.00,1456271.40,0.00,'2023-01-17 09:45:40'),(1804528,'1','57',174,'Sale Id shift 257406',0.00,326505.40,890.00,326505.40,0.00,'2023-01-17 12:59:46'),(1804529,'1','57',174,'Sale Id shift 257407',0.00,179424.00,890.00,179424.00,0.00,'2023-01-18 09:20:43'),(1804530,'1','57',174,'Sale Id shift 257408',0.00,165682.40,890.00,165682.40,0.00,'2023-01-19 08:43:24'),(1804531,'1','57',174,'Sale Id shift 257409',0.00,259710.90,890.00,259710.90,0.00,'2023-01-19 11:23:13'),(1804532,'1','57',174,'Sale Id shift 257410',0.00,1195136.50,890.00,1195136.50,0.00,'2023-01-19 14:45:30'),(1804533,'1','57',174,'Sale Id shift 257411',0.00,50649.90,890.00,50649.90,0.00,'2023-01-20 08:52:30'),(1804534,'1','57',174,'Sale Id shift 257412',0.00,168103.20,890.00,168103.20,0.00,'2023-01-20 12:51:06'),(1804535,'1','57',174,'Sale Id shift 257413',0.00,493852.10,890.00,493852.10,0.00,'2023-01-20 13:00:04'),(1804536,'1','57',174,'Sale Id shift 257414',0.00,270364.20,890.00,270364.20,0.00,'2023-01-21 17:46:54'),(1804537,'1','57',174,'Sale Id shift 257415',0.00,282156.70,890.00,282156.70,0.00,'2023-01-22 09:55:48'),(1804538,'1','57',174,'Sale Id shift 257416',0.00,1134216.00,890.00,1134216.00,0.00,'2023-01-22 18:33:41'),(1804539,'1','57',174,'Sale Id shift 257417',0.00,104681.80,890.00,104681.80,0.00,'2023-01-23 10:51:47'),(1804540,'1','57',174,'Sale Id shift 257418',0.00,669458.00,890.00,669458.00,0.00,'2023-01-24 14:16:07'),(1804541,'1','57',174,'Sale Id shift 257419',0.00,789198.60,890.00,789198.60,0.00,'2023-01-24 19:08:43'),(1804542,'1','57',174,'Sale Id shift 257420',0.00,304210.90,890.00,304210.90,0.00,'2023-01-25 09:54:01'),(1804543,'1','57',174,'Sale Id shift 257421',0.00,478481.80,890.00,478481.80,0.00,'2023-01-25 13:55:12'),(1804544,'1','57',174,'Sale Id shift 257422',0.00,511367.30,890.00,511367.30,0.00,'2023-01-25 20:33:02'),(1804545,'1','57',174,'Sale Id shift 257423',0.00,357201.50,890.00,357201.50,0.00,'2023-01-27 10:48:24'),(1804546,'1','57',174,'Sale Id shift 257424',0.00,286615.60,890.00,286615.60,0.00,'2023-01-27 12:01:11'),(1804547,'1','57',174,'Sale Id shift 257425',0.00,312603.60,890.00,312603.60,0.00,'2023-01-27 23:39:31'),(1804548,'1','57',174,'Sale Id shift 257426',0.00,321895.20,890.00,321895.20,0.00,'2023-01-29 15:22:53'),(1804549,'1','57',174,'Sale Id shift 257427',0.00,47214.50,890.00,47214.50,0.00,'2023-01-29 22:54:23'),(1804550,'1','57',174,'Sale Id shift 257428',0.00,235654.20,890.00,235654.20,0.00,'2023-01-30 09:14:59'),(1804551,'1','57',174,'Sale Id shift 257429',0.00,487328.40,890.00,487328.40,0.00,'2023-01-30 09:27:29'),(1804552,'1','57',174,'Sale Id shift 257430',0.00,22250.00,890.00,22250.00,0.00,'2023-01-30 09:42:06'),(1804553,'1','57',174,'Sale Id shift 257431',0.00,1397.30,890.00,1397.30,0.00,'2023-01-30 10:15:43'),(1804554,'1','57',174,'Sale Id shift 257432',0.00,29183.10,890.00,29183.10,0.00,'2023-01-30 10:21:29'),(1804555,'1','57',174,'Sale Id shift 257433',0.00,77483.40,890.00,77483.40,0.00,'2023-01-30 18:53:25'),(1804556,'1','57',174,'Sale Id shift 257434',0.00,287613.30,870.00,287613.30,0.00,'2023-01-31 17:16:11'),(1804557,'1','57',174,'Sale Id shift 257435',0.00,933031.50,870.00,933031.50,0.00,'2023-01-31 20:24:05'),(1804558,'1','57',174,'Sale Id shift 257436',0.00,787750.20,870.00,787750.20,0.00,'2023-01-31 20:40:24'),(1804559,'1','57',174,'Sale Id shift 257438',0.00,23411.70,870.00,23411.70,0.00,'2023-02-04 21:48:38'),(1804560,'1','57',174,'Sale Id shift 257439',0.00,101972.70,870.00,101972.70,0.00,'2023-02-04 22:10:39'),(1804561,'1','57',174,'Sale Id shift 257440',0.00,319359.60,870.00,319359.60,0.00,'2023-02-04 22:42:19'),(1804562,'1','57',174,'Sale Id shift 257442',0.00,51504.00,870.00,51504.00,0.00,'2023-02-05 20:11:54'),(1804563,'1','57',174,'Sale Id shift 257443',0.00,605145.90,870.00,605145.90,0.00,'2023-02-06 22:30:13'),(1804564,'1','57',174,'Sale Id shift 257444',0.00,828996.90,870.00,828996.90,0.00,'2023-02-08 08:54:57'),(1804565,'1','57',174,'Sale Id shift 257445',0.00,1670930.70,870.00,1670930.70,0.00,'2023-02-08 09:05:49'),(1804566,'1','57',174,'Sale Id shift 257446',0.00,70600.50,870.00,70600.50,0.00,'2023-02-08 09:11:30'),(1804567,'1','57',174,'Sale Id shift 257447',0.00,356700.00,870.00,356700.00,0.00,'2023-02-08 09:21:32'),(1804568,'1','57',174,'Sale Id shift 257448',0.00,64197.30,870.00,64197.30,0.00,'2023-02-08 09:28:50'),(1804569,'1','57',174,'Sale Id shift 257450',0.00,135502.50,870.00,135502.50,0.00,'2023-02-09 15:39:59'),(1804570,'1','57',174,'Sale Id shift 257451',0.00,88583.40,870.00,88583.40,0.00,'2023-02-10 13:59:51'),(1804571,'1','57',174,'Sale Id shift 257452',0.00,40246.20,870.00,40246.20,0.00,'2023-02-10 19:46:52'),(1804572,'1','57',174,'Sale Id shift 257453',0.00,6246.60,870.00,6246.60,0.00,'2023-02-10 19:50:34'),(1804573,'1','57',174,'Sale Id shift 257454',0.00,665410.80,870.00,665410.80,0.00,'2023-02-10 19:56:44'),(1804574,'1','57',174,'Sale Id shift 257455',0.00,34608.60,870.00,34608.60,0.00,'2023-02-12 19:04:15'),(1804575,'1','57',174,'Sale Id shift 257456',0.00,1246040.10,870.00,1246040.10,0.00,'2023-02-12 19:38:11'),(1804576,'1','57',174,'Sale Id shift 257457',0.00,36592.20,870.00,36592.20,0.00,'2023-02-13 21:06:54'),(1804577,'1','57',174,'Sale Id shift 257458',0.00,904399.80,870.00,904399.80,0.00,'2023-02-14 11:44:17'),(1804578,'1','57',174,'Sale Id shift 257459',0.00,14407.20,870.00,14407.20,0.00,'2023-02-14 20:34:05'),(1804579,'1','57',174,'Sale Id shift 257460',0.00,178471.80,870.00,178471.80,0.00,'2023-02-15 10:37:12'),(1804580,'1','57',174,'Sale Id shift 257461',0.00,90854.10,870.00,90854.10,0.00,'2023-02-15 21:54:30'),(1804581,'1','57',174,'Sale Id shift 257462',0.00,23707.50,870.00,23707.50,0.00,'2023-02-15 22:24:10'),(1804582,'1','57',174,'Sale Id shift 257464',0.00,50503.50,870.00,50503.50,0.00,'2023-02-15 22:35:12'),(1804583,'1','57',174,'Sale Id shift 257465',0.00,96700.50,870.00,96700.50,0.00,'2023-02-15 22:41:20'),(1804584,'1','57',174,'Sale Id shift 257467',0.00,461848.20,870.00,461848.20,0.00,'2023-02-17 18:48:14'),(1804585,'1','57',174,'Sale Id shift 257468',0.00,129838.80,870.00,129838.80,0.00,'2023-02-17 22:26:01'),(1804586,'1','57',174,'Sale Id shift 257469',0.00,20610.30,870.00,20610.30,0.00,'2023-02-18 21:31:28'),(1804587,'1','57',174,'Sale Id shift 257470',0.00,157165.50,870.00,157165.50,0.00,'2023-02-18 21:35:00'),(1804588,'1','57',174,'Sale Id shift 257472',0.00,10944.60,870.00,10944.60,0.00,'2023-02-21 12:00:24'),(1804589,'1','57',174,'Sale Id shift 257473',0.00,248350.20,870.00,248350.20,0.00,'2023-02-21 12:07:52'),(1804590,'1','57',174,'Sale Id shift 257474',0.00,62909.70,870.00,62909.70,0.00,'2023-02-21 15:01:03'),(1804591,'1','57',174,'Sale Id shift 257475',0.00,260634.60,870.00,260634.60,0.00,'2023-02-21 15:06:48'),(1804592,'1','57',174,'Sale Id shift 257476',0.00,258050.70,870.00,258050.70,0.00,'2023-02-21 16:11:04'),(1804593,'1','57',174,'Sale Id shift 257477',0.00,90737.50,850.00,90737.50,0.00,'2023-02-22 19:14:05'),(1804594,'1','57',174,'Sale Id shift 257478',0.00,495499.00,850.00,495499.00,0.00,'2023-02-23 12:10:44'),(1804595,'1','57',174,'Sale Id shift 257479',0.00,182274.00,850.00,182274.00,0.00,'2023-02-23 20:54:54'),(1804596,'1','57',174,'Sale Id shift 257480',0.00,289697.00,850.00,289697.00,0.00,'2023-02-23 21:14:00'),(1804597,'1','57',174,'Sale Id shift 257481',0.00,14541.60,830.00,14541.60,0.00,'2023-02-23 21:29:04'),(1804598,'1','57',174,'Sale Id shift 257482',0.00,606688.50,830.00,606688.50,0.00,'2023-02-23 22:19:49'),(1804599,'1','57',174,'Sale Id shift 257483',0.00,49069.60,830.00,49069.60,0.00,'2023-02-25 19:22:16'),(1804600,'1','57',174,'Sale Id shift 257484',0.00,109966.70,830.00,109966.70,0.00,'2023-02-26 22:26:50'),(1804601,'1','57',174,'Sale Id shift 257486',0.00,524186.50,830.00,524186.50,0.00,'2023-02-28 13:07:08'),(1804602,'1','57',174,'Sale Id shift 257487',0.00,114540.00,830.00,114540.00,0.00,'2023-02-28 14:16:31'),(1804603,'1','57',174,'Sale Id shift 257488',0.00,269708.50,830.00,269708.50,0.00,'2023-03-01 14:29:27'),(1804604,'1','57',174,'Sale Id shift 257489',0.00,352086.00,830.00,352086.00,0.00,'2023-03-01 19:29:34'),(1804605,'1','57',174,'Sale Id shift 257490',0.00,876438.50,830.00,876438.50,0.00,'2023-03-01 20:12:21'),(1804606,'1','57',174,'Sale Id shift 257491',0.00,189439.20,830.00,189439.20,0.00,'2023-03-03 11:59:12');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=4942022 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('1','57',116256,'','supplier','76',0.00,3705000.00,'Purchase Id 6119 for 19,500 litters of AGO - 002 returned to A.A RANO NIGERIA LIMITED','2017-05-04 10:24:08','',''),('1','57',3766604,'','24','1249',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3766755,'','24','1238',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3766937,'','2','1254',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3767133,'','24','1241',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3767413,'','24','1237',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3767749,'','24','1252',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3768217,'','6.1','1255',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3768300,'','2','1301',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3768992,'','24','1235',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3769012,'','24','1240',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3769083,'','5','1256',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3769288,'','24','1244',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3769440,'','24','1247',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3769451,'','24','1239',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3769659,'','24','1251',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3769727,'','24','1243',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3769874,'','20','1253',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3769888,'','24','1246',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3769985,'','24','1236',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3770002,'','24','1250',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3770227,'','24','1242',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3770297,'','24','1248',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3770368,'','24','1245',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','57',3863433,'','2','1301',0.00,0.00,'Opening balance','0000-00-00 00:00:00','',''),('1','57',3863434,'','obe','obe',0.00,0.00,'Opening balance of 1301','0000-00-00 00:00:00','',''),('1','57',3863435,'','2','1301',0.00,0.00,'Opening balance','0000-00-00 00:00:00','',''),('1','57',3863436,'','obe','obe',0.00,0.00,'Opening balance of 1301','0000-00-00 00:00:00','',''),('1','57',3863437,'','2','1301',0.00,0.00,'Opening balance','0000-00-00 00:00:00','',''),('1','57',3863438,'','obe','obe',0.00,0.00,'Opening balance of 1301','0000-00-00 00:00:00','',''),('1','57',4003509,'','24','1235',0.00,4950000.00,'Purchase Id 81033 for 30,000.00 litters of Petrol - PMS from A.A RANO NIGERIA LIMITED','2021-11-21 09:50:20','',''),('1','57',4003510,'','supplier','76',4950000.00,0.00,'Purchase Id 81033 for 30,000.00 litters of Petrol - PMS from A.A RANO NIGERIA LIMITED','2021-11-21 09:50:20','',''),('1','57',4008104,'','20','1253',73585.05,0.00,'Sales from shift 240535 on 2021-11-21 13:48:23 ','2021-11-21 13:48:23','',''),('1','57',4008105,'','6.1','1255',0.00,73585.05,'Sales from shift 240535 on 2021-11-21 13:48:23 ','2021-11-21 13:48:23','',''),('1','57',4008313,'','20','1253',173713.65,0.00,'Sales from shift 240575 on 2021-11-21 14:00:25 ','2021-11-21 14:00:25','',''),('1','57',4008314,'','6.1','1255',0.00,173713.65,'Sales from shift 240575 on 2021-11-21 14:00:25 ','2021-11-21 14:00:25','',''),('1','57',4008548,'','20','1253',701971.05,0.00,'Sales from shift 240579 on 2021-11-21 14:14:38 ','2021-11-21 14:14:38','',''),('1','57',4008549,'','6.1','1255',0.00,701971.05,'Sales from shift 240579 on 2021-11-21 14:14:38 ','2021-11-21 14:14:38','',''),('1','57',4008716,'','20','1253',219829.50,0.00,'Sales from shift 240582 on 2021-11-21 14:24:08 ','2021-11-21 14:24:08','',''),('1','57',4008717,'','6.1','1255',0.00,219829.50,'Sales from shift 240582 on 2021-11-21 14:24:08 ','2021-11-21 14:24:08','',''),('1','57',4008881,'','20','1253',322345.65,0.00,'Sales from shift 240584 on 2021-11-21 14:35:16 ','2021-11-21 14:35:16','',''),('1','57',4008882,'','6.1','1255',0.00,322345.65,'Sales from shift 240584 on 2021-11-21 14:35:16 ','2021-11-21 14:35:16','',''),('1','57',4009058,'','20','1253',242853.60,0.00,'Sales from shift 240585 on 2021-11-21 14:46:49 ','2021-11-21 14:46:49','',''),('1','57',4009059,'','6.1','1255',0.00,242853.60,'Sales from shift 240585 on 2021-11-21 14:46:49 ','2021-11-21 14:46:49','',''),('1','57',4009479,'','20','1253',589873.35,0.00,'Sales from shift 240586 on 2021-11-21 15:13:51 ','2021-11-21 15:13:51','',''),('1','57',4009480,'','6.1','1255',0.00,589873.35,'Sales from shift 240586 on 2021-11-21 15:13:51 ','2021-11-21 15:13:51','',''),('1','57',4017800,'','20','1253',364988.25,0.00,'Sales from shift 240592 on 2021-11-22 12:57:07 ','2021-11-22 12:57:07','',''),('1','57',4017801,'','6.1','1255',0.00,364988.25,'Sales from shift 240592 on 2021-11-22 12:57:07 ','2021-11-22 12:57:07','',''),('1','57',4021854,'','20','1253',379830.00,0.00,'Sales from shift 240812 on 2021-11-22 16:02:07 ','2021-11-22 16:02:07','',''),('1','57',4021855,'','6.1','1255',0.00,379830.00,'Sales from shift 240812 on 2021-11-22 16:02:07 ','2021-11-22 16:02:07','',''),('1','57',4029536,'','2','3865',364885.00,0.00,'Payment Id 364501 for invoice:240592, receipt: 000 by A.A RANO NIGERIA LIMITED','2021-11-23 10:58:22','',''),('1','57',4029537,'','supplier','76',0.00,364885.00,'Payment Id 364501 for invoice:240592, receipt: 000 by A.A RANO NIGERIA LIMITED','2021-11-23 10:58:22','',''),('1','57',4029538,'','2','3865',589775.00,0.00,'Payment Id 364231 for invoice:240586, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-23 10:58:22','',''),('1','57',4029539,'','supplier','76',0.00,589775.00,'Payment Id 364231 for invoice:240586, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-23 10:58:22','',''),('1','57',4029540,'','2','3865',242755.00,0.00,'Payment Id 364230 for invoice:240585, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-23 10:58:22','',''),('1','57',4029541,'','supplier','76',0.00,242755.00,'Payment Id 364230 for invoice:240585, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-23 10:58:22','',''),('1','57',4029542,'','2','3865',283045.00,0.00,'Payment Id 364229 for invoice:240584, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-23 10:58:22','',''),('1','57',4029543,'','supplier','76',0.00,283045.00,'Payment Id 364229 for invoice:240584, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-23 10:58:22','',''),('1','57',4029544,'','2','3865',219730.00,0.00,'Payment Id 364228 for invoice:240582, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-23 10:58:22','',''),('1','57',4029545,'','supplier','76',0.00,219730.00,'Payment Id 364228 for invoice:240582, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-23 10:58:22','',''),('1','57',4029546,'','2','3865',73485.00,0.00,'Payment Id 364222 for invoice:240535, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-23 10:58:22','',''),('1','57',4029547,'','supplier','76',0.00,73485.00,'Payment Id 364222 for invoice:240535, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-23 10:58:22','',''),('1','57',4029570,'','2','3865',696270.00,0.00,'Payment Id 364226 for invoice:240579, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-23 10:59:44','',''),('1','57',4029571,'','supplier','76',0.00,696270.00,'Payment Id 364226 for invoice:240579, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-23 10:59:44','',''),('1','57',4029572,'','2','3865',168360.00,0.00,'Payment Id 364223 for invoice:240575, receipt: 000 by A.A RANO NIGERIA LIMITED','2021-11-23 10:59:44','',''),('1','57',4029573,'','supplier','76',0.00,168360.00,'Payment Id 364223 for invoice:240575, receipt: 000 by A.A RANO NIGERIA LIMITED','2021-11-23 10:59:44','',''),('1','57',4029909,'','20','1253',368702.40,0.00,'Sales from shift 240876 on 2021-11-23 11:22:31 ','2021-11-23 11:22:31','',''),('1','57',4029910,'','6.1','1255',0.00,368702.40,'Sales from shift 240876 on 2021-11-23 11:22:31 ','2021-11-23 11:22:31','',''),('1','57',4040860,'','20','1253',397029.60,0.00,'Sales from shift 241137 on 2021-11-24 09:18:04 ','2021-11-24 09:18:04','',''),('1','57',4040861,'','6.1','1255',0.00,397029.60,'Sales from shift 241137 on 2021-11-24 09:18:04 ','2021-11-24 09:18:04','',''),('1','57',4048874,'','20','1253',308637.45,0.00,'Sales from shift 241326 on 2021-11-24 18:16:19 ','2021-11-24 18:16:19','',''),('1','57',4048875,'','6.1','1255',0.00,308637.45,'Sales from shift 241326 on 2021-11-24 18:16:19 ','2021-11-24 18:16:19','',''),('1','57',4048913,'','20','1253',329135.40,0.00,'Sales from shift 241419 on 2021-11-24 18:24:28 ','2021-11-24 18:24:28','',''),('1','57',4048914,'','6.1','1255',0.00,329135.40,'Sales from shift 241419 on 2021-11-24 18:24:28 ','2021-11-24 18:24:28','',''),('1','57',4055965,'','20','1253',347551.05,0.00,'Sales from shift 241422 on 2021-11-25 11:42:43 ','2021-11-25 11:42:43','',''),('1','57',4055966,'','6.1','1255',0.00,347551.05,'Sales from shift 241422 on 2021-11-25 11:42:43 ','2021-11-25 11:42:43','',''),('1','57',4072764,'','2','3865',347550.00,0.00,'Payment Id 366431 for invoice:241422, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-26 16:21:18','',''),('1','57',4072765,'','supplier','76',0.00,347550.00,'Payment Id 366431 for invoice:241422, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-26 16:21:18','',''),('1','57',4072766,'','2','3865',329135.00,0.00,'Payment Id 366174 for invoice:241419, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-26 16:21:18','',''),('1','57',4072767,'','supplier','76',0.00,329135.00,'Payment Id 366174 for invoice:241419, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-26 16:21:18','',''),('1','57',4072768,'','2','3865',308635.00,0.00,'Payment Id 365899 for invoice:241326, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-26 16:21:18','',''),('1','57',4072769,'','supplier','76',0.00,308635.00,'Payment Id 365899 for invoice:241326, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-26 16:21:18','',''),('1','57',4072770,'','2','3865',397030.00,0.00,'Payment Id 365513 for invoice:241137, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-26 16:21:18','',''),('1','57',4072771,'','supplier','76',0.00,397030.00,'Payment Id 365513 for invoice:241137, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-26 16:21:18','',''),('1','57',4072772,'','2','3865',368700.00,0.00,'Payment Id 365216 for invoice:240876, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-26 16:21:18','',''),('1','57',4072773,'','supplier','76',0.00,368700.00,'Payment Id 365216 for invoice:240876, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-26 16:21:18','',''),('1','57',4072774,'','2','3865',379830.00,0.00,'Payment Id 364721 for invoice:240812, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-26 16:21:18','',''),('1','57',4072775,'','supplier','76',0.00,379830.00,'Payment Id 364721 for invoice:240812, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-11-26 16:21:18','',''),('1','57',4104598,'','20','1253',141319.20,0.00,'Sales from shift 241662 on 2021-11-29 10:28:50 ','2021-11-29 10:28:50','',''),('1','57',4104599,'','6.1','1255',0.00,141319.20,'Sales from shift 241662 on 2021-11-29 10:28:50 ','2021-11-29 10:28:50','',''),('1','57',4130495,'','20','1253',0.00,0.00,'Sales from shift 242540 on 2021-12-01 09:54:17 ','2021-12-01 09:54:17','',''),('1','57',4130496,'','6.1','1255',0.00,0.00,'Sales from shift 242540 on 2021-12-01 09:54:17 ','2021-12-01 09:54:17','',''),('1','57',4148306,'','2','3865',141320.00,0.00,'Payment Id 367766 for invoice:241662, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-12-02 14:11:11','',''),('1','57',4148307,'','supplier','76',0.00,141320.00,'Payment Id 367766 for invoice:241662, receipt: 00 by A.A RANO NIGERIA LIMITED','2021-12-02 14:11:11','',''),('1','57',4199220,'','20','1253',0.00,0.00,'Sales from shift 244179 on 2021-12-06 13:26:47 ','2021-12-06 13:26:47','',''),('1','57',4199221,'','6.1','1255',0.00,0.00,'Sales from shift 244179 on 2021-12-06 13:26:47 ','2021-12-06 13:26:47','',''),('1','57',4209464,'','20','1253',0.00,0.00,'Sales from shift 244249 on 2021-12-07 09:44:46 ','2021-12-07 09:44:46','',''),('1','57',4209465,'','6.1','1255',0.00,0.00,'Sales from shift 244249 on 2021-12-07 09:44:46 ','2021-12-07 09:44:46','',''),('1','57',4219344,'','20','1253',0.00,0.00,'Sales from shift 244392 on 2021-12-07 18:01:19 ','2021-12-07 18:01:19','',''),('1','57',4219345,'','6.1','1255',0.00,0.00,'Sales from shift 244392 on 2021-12-07 18:01:19 ','2021-12-07 18:01:19','',''),('1','57',4231216,'','20','1253',0.00,0.00,'Sales from shift 244676 on 2021-12-08 17:38:15 ','2021-12-08 17:38:15','',''),('1','57',4231217,'','6.1','1255',0.00,0.00,'Sales from shift 244676 on 2021-12-08 17:38:15 ','2021-12-08 17:38:15','',''),('1','57',4236863,'','20','1253',0.00,0.00,'Sales from shift 244691 on 2021-12-09 10:04:13 ','2021-12-09 10:04:13','',''),('1','57',4236864,'','6.1','1255',0.00,0.00,'Sales from shift 244691 on 2021-12-09 10:04:13 ','2021-12-09 10:04:13','',''),('1','57',4287633,'','20','1253',0.00,0.00,'Sales from shift 244940 on 2021-12-13 08:48:12 ','2021-12-13 08:48:12','',''),('1','57',4287634,'','6.1','1255',0.00,0.00,'Sales from shift 244940 on 2021-12-13 08:48:12 ','2021-12-13 08:48:12','',''),('1','57',4294836,'','20','1253',0.00,0.00,'Sales from shift 245833 on 2021-12-13 15:18:01 ','2021-12-13 15:18:01','',''),('1','57',4294837,'','6.1','1255',0.00,0.00,'Sales from shift 245833 on 2021-12-13 15:18:01 ','2021-12-13 15:18:01','',''),('1','57',4294874,'','20','1253',0.00,0.00,'Sales from shift 245835 on 2021-12-13 15:20:00 ','2021-12-13 15:20:00','',''),('1','57',4294875,'','6.1','1255',0.00,0.00,'Sales from shift 245835 on 2021-12-13 15:20:00 ','2021-12-13 15:20:00','',''),('1','57',4294922,'','20','1253',0.00,0.00,'Sales from shift 245836 on 2021-12-13 15:22:14 ','2021-12-13 15:22:14','',''),('1','57',4294923,'','6.1','1255',0.00,0.00,'Sales from shift 245836 on 2021-12-13 15:22:14 ','2021-12-13 15:22:14','',''),('1','57',4295034,'','20','1253',0.00,0.00,'Sales from shift 245839 on 2021-12-13 15:26:35 ','2021-12-13 15:26:35','',''),('1','57',4295035,'','6.1','1255',0.00,0.00,'Sales from shift 245839 on 2021-12-13 15:26:35 ','2021-12-13 15:26:35','',''),('1','57',4295090,'','20','1253',0.00,0.00,'Sales from shift 245841 on 2021-12-13 15:28:46 ','2021-12-13 15:28:46','',''),('1','57',4295091,'','6.1','1255',0.00,0.00,'Sales from shift 245841 on 2021-12-13 15:28:46 ','2021-12-13 15:28:46','',''),('1','57',4295123,'','20','1253',0.00,0.00,'Sales from shift 245842 on 2021-12-13 15:30:38 ','2021-12-13 15:30:38','',''),('1','57',4295124,'','6.1','1255',0.00,0.00,'Sales from shift 245842 on 2021-12-13 15:30:38 ','2021-12-13 15:30:38','',''),('1','57',4295201,'','20','1253',0.00,0.00,'Sales from shift 245843 on 2021-12-13 15:32:40 ','2021-12-13 15:32:40','',''),('1','57',4295202,'','6.1','1255',0.00,0.00,'Sales from shift 245843 on 2021-12-13 15:32:40 ','2021-12-13 15:32:40','',''),('1','57',4295252,'','20','1253',0.00,0.00,'Sales from shift 245845 on 2021-12-13 15:35:04 ','2021-12-13 15:35:04','',''),('1','57',4295253,'','6.1','1255',0.00,0.00,'Sales from shift 245845 on 2021-12-13 15:35:04 ','2021-12-13 15:35:04','',''),('1','57',4295335,'','20','1253',0.00,0.00,'Sales from shift 245846 on 2021-12-13 15:37:59 ','2021-12-13 15:37:59','',''),('1','57',4295336,'','6.1','1255',0.00,0.00,'Sales from shift 245846 on 2021-12-13 15:37:59 ','2021-12-13 15:37:59','',''),('1','57',4295398,'','20','1253',0.00,0.00,'Sales from shift 245848 on 2021-12-13 15:40:27 ','2021-12-13 15:40:27','',''),('1','57',4295399,'','6.1','1255',0.00,0.00,'Sales from shift 245848 on 2021-12-13 15:40:27 ','2021-12-13 15:40:27','',''),('1','57',4295486,'','20','1253',0.00,0.00,'Sales from shift 245850 on 2021-12-13 15:43:07 ','2021-12-13 15:43:07','',''),('1','57',4295487,'','6.1','1255',0.00,0.00,'Sales from shift 245850 on 2021-12-13 15:43:07 ','2021-12-13 15:43:07','',''),('1','57',4295545,'','20','1253',0.00,0.00,'Sales from shift 245851 on 2021-12-13 15:45:29 ','2021-12-13 15:45:29','',''),('1','57',4295546,'','6.1','1255',0.00,0.00,'Sales from shift 245851 on 2021-12-13 15:45:29 ','2021-12-13 15:45:29','',''),('1','57',4295669,'','20','1253',0.00,0.00,'Sales from shift 245852 on 2021-12-13 15:47:55 ','2021-12-13 15:47:55','',''),('1','57',4295670,'','6.1','1255',0.00,0.00,'Sales from shift 245852 on 2021-12-13 15:47:55 ','2021-12-13 15:47:55','',''),('1','57',4295734,'','20','1253',0.00,0.00,'Sales from shift 245853 on 2021-12-13 15:49:49 ','2021-12-13 15:49:49','',''),('1','57',4295735,'','6.1','1255',0.00,0.00,'Sales from shift 245853 on 2021-12-13 15:49:49 ','2021-12-13 15:49:49','',''),('1','57',4295777,'','20','1253',0.00,0.00,'Sales from shift 245854 on 2021-12-13 15:51:21 ','2021-12-13 15:51:21','',''),('1','57',4295778,'','6.1','1255',0.00,0.00,'Sales from shift 245854 on 2021-12-13 15:51:21 ','2021-12-13 15:51:21','',''),('1','57',4295897,'','20','1253',0.00,0.00,'Sales from shift 245855 on 2021-12-13 15:56:32 ','2021-12-13 15:56:32','',''),('1','57',4295898,'','6.1','1255',0.00,0.00,'Sales from shift 245855 on 2021-12-13 15:56:32 ','2021-12-13 15:56:32','',''),('1','57',4295979,'','20','1253',0.00,0.00,'Sales from shift 245856 on 2021-12-13 15:58:52 ','2021-12-13 15:58:52','',''),('1','57',4295980,'','6.1','1255',0.00,0.00,'Sales from shift 245856 on 2021-12-13 15:58:52 ','2021-12-13 15:58:52','',''),('1','57',4296037,'','20','1253',0.00,0.00,'Sales from shift 245857 on 2021-12-13 16:00:29 ','2021-12-13 16:00:29','',''),('1','57',4296038,'','6.1','1255',0.00,0.00,'Sales from shift 245857 on 2021-12-13 16:00:29 ','2021-12-13 16:00:29','',''),('1','57',4296104,'','20','1253',0.00,0.00,'Sales from shift 245859 on 2021-12-13 16:03:06 ','2021-12-13 16:03:06','',''),('1','57',4296105,'','6.1','1255',0.00,0.00,'Sales from shift 245859 on 2021-12-13 16:03:06 ','2021-12-13 16:03:06','',''),('1','57',4296156,'','20','1253',0.00,0.00,'Sales from shift 245860 on 2021-12-13 16:05:22 ','2021-12-13 16:05:22','',''),('1','57',4296157,'','6.1','1255',0.00,0.00,'Sales from shift 245860 on 2021-12-13 16:05:22 ','2021-12-13 16:05:22','',''),('1','57',4296196,'','20','1253',0.00,0.00,'Sales from shift 245861 on 2021-12-13 16:07:10 ','2021-12-13 16:07:10','',''),('1','57',4296197,'','6.1','1255',0.00,0.00,'Sales from shift 245861 on 2021-12-13 16:07:10 ','2021-12-13 16:07:10','',''),('1','57',4296239,'','20','1253',0.00,0.00,'Sales from shift 245862 on 2021-12-13 16:09:25 ','2021-12-13 16:09:25','',''),('1','57',4296240,'','6.1','1255',0.00,0.00,'Sales from shift 245862 on 2021-12-13 16:09:25 ','2021-12-13 16:09:25','',''),('1','57',4296283,'','20','1253',0.00,0.00,'Sales from shift 245864 on 2021-12-13 16:11:31 ','2021-12-13 16:11:31','',''),('1','57',4296284,'','6.1','1255',0.00,0.00,'Sales from shift 245864 on 2021-12-13 16:11:31 ','2021-12-13 16:11:31','',''),('1','57',4296344,'','20','1253',0.00,0.00,'Sales from shift 245865 on 2021-12-13 16:13:55 ','2021-12-13 16:13:55','',''),('1','57',4296345,'','6.1','1255',0.00,0.00,'Sales from shift 245865 on 2021-12-13 16:13:55 ','2021-12-13 16:13:55','',''),('1','57',4296396,'','20','1253',0.00,0.00,'Sales from shift 245867 on 2021-12-13 16:16:18 ','2021-12-13 16:16:18','',''),('1','57',4296397,'','6.1','1255',0.00,0.00,'Sales from shift 245867 on 2021-12-13 16:16:18 ','2021-12-13 16:16:18','',''),('1','57',4296454,'','20','1253',0.00,0.00,'Sales from shift 245868 on 2021-12-13 16:18:45 ','2021-12-13 16:18:45','',''),('1','57',4296455,'','6.1','1255',0.00,0.00,'Sales from shift 245868 on 2021-12-13 16:18:45 ','2021-12-13 16:18:45','',''),('1','57',4296515,'','20','1253',0.00,0.00,'Sales from shift 245869 on 2021-12-13 16:21:05 ','2021-12-13 16:21:05','',''),('1','57',4296516,'','6.1','1255',0.00,0.00,'Sales from shift 245869 on 2021-12-13 16:21:05 ','2021-12-13 16:21:05','',''),('1','57',4296575,'','20','1253',0.00,0.00,'Sales from shift 245870 on 2021-12-13 16:23:50 ','2021-12-13 16:23:50','',''),('1','57',4296576,'','6.1','1255',0.00,0.00,'Sales from shift 245870 on 2021-12-13 16:23:50 ','2021-12-13 16:23:50','',''),('1','57',4296614,'','20','1253',0.00,0.00,'Sales from shift 245871 on 2021-12-13 16:25:59 ','2021-12-13 16:25:59','',''),('1','57',4296615,'','6.1','1255',0.00,0.00,'Sales from shift 245871 on 2021-12-13 16:25:59 ','2021-12-13 16:25:59','',''),('1','57',4335643,'','20','1253',0.00,0.00,'Sales from shift 245872 on 2021-12-16 15:36:18 ','2021-12-16 15:36:18','',''),('1','57',4335644,'','6.1','1255',0.00,0.00,'Sales from shift 245872 on 2021-12-16 15:36:18 ','2021-12-16 15:36:18','',''),('1','57',4358426,'','20','1253',0.00,0.00,'Sales from shift 247028 on 2021-12-18 10:59:40 ','2021-12-18 10:59:40','',''),('1','57',4358427,'','6.1','1255',0.00,0.00,'Sales from shift 247028 on 2021-12-18 10:59:40 ','2021-12-18 10:59:40','',''),('1','57',4358496,'','20','1253',0.00,0.00,'Sales from shift 247030 on 2021-12-18 11:03:10 ','2021-12-18 11:03:10','',''),('1','57',4358497,'','6.1','1255',0.00,0.00,'Sales from shift 247030 on 2021-12-18 11:03:10 ','2021-12-18 11:03:10','',''),('1','57',4358687,'','20','1253',0.00,0.00,'Sales from shift 247031 on 2021-12-18 11:10:45 ','2021-12-18 11:10:45','',''),('1','57',4358688,'','6.1','1255',0.00,0.00,'Sales from shift 247031 on 2021-12-18 11:10:45 ','2021-12-18 11:10:45','',''),('1','57',4358730,'','20','1253',0.00,0.00,'Sales from shift 247032 on 2021-12-18 11:12:30 ','2021-12-18 11:12:30','',''),('1','57',4358731,'','6.1','1255',0.00,0.00,'Sales from shift 247032 on 2021-12-18 11:12:30 ','2021-12-18 11:12:30','',''),('1','57',4358778,'','20','1253',0.00,0.00,'Sales from shift 247034 on 2021-12-18 11:14:42 ','2021-12-18 11:14:42','',''),('1','57',4358779,'','6.1','1255',0.00,0.00,'Sales from shift 247034 on 2021-12-18 11:14:42 ','2021-12-18 11:14:42','',''),('1','57',4358842,'','20','1253',0.00,0.00,'Sales from shift 247035 on 2021-12-18 11:17:09 ','2021-12-18 11:17:09','',''),('1','57',4358843,'','6.1','1255',0.00,0.00,'Sales from shift 247035 on 2021-12-18 11:17:09 ','2021-12-18 11:17:09','',''),('1','57',4358904,'','20','1253',0.00,0.00,'Sales from shift 247036 on 2021-12-18 11:19:47 ','2021-12-18 11:19:47','',''),('1','57',4358905,'','6.1','1255',0.00,0.00,'Sales from shift 247036 on 2021-12-18 11:19:47 ','2021-12-18 11:19:47','',''),('1','57',4358963,'','20','1253',0.00,0.00,'Sales from shift 247038 on 2021-12-18 11:22:07 ','2021-12-18 11:22:07','',''),('1','57',4358964,'','6.1','1255',0.00,0.00,'Sales from shift 247038 on 2021-12-18 11:22:07 ','2021-12-18 11:22:07','',''),('1','57',4359057,'','20','1253',0.00,0.00,'Sales from shift 247039 on 2021-12-18 11:25:57 ','2021-12-18 11:25:57','',''),('1','57',4359058,'','6.1','1255',0.00,0.00,'Sales from shift 247039 on 2021-12-18 11:25:57 ','2021-12-18 11:25:57','',''),('1','57',4457015,'','20','1253',0.00,0.00,'Sales from shift 247040 on 2021-12-24 16:43:23 ','2021-12-24 16:43:23','',''),('1','57',4457016,'','6.1','1255',0.00,0.00,'Sales from shift 247040 on 2021-12-24 16:43:23 ','2021-12-24 16:43:23','',''),('1','57',4457107,'','20','1253',0.00,0.00,'Sales from shift 248554 on 2021-12-24 16:46:18 ','2021-12-24 16:46:18','',''),('1','57',4457108,'','6.1','1255',0.00,0.00,'Sales from shift 248554 on 2021-12-24 16:46:18 ','2021-12-24 16:46:18','',''),('1','57',4457172,'','20','1253',0.00,0.00,'Sales from shift 248555 on 2021-12-24 16:48:25 ','2021-12-24 16:48:25','',''),('1','57',4457173,'','6.1','1255',0.00,0.00,'Sales from shift 248555 on 2021-12-24 16:48:25 ','2021-12-24 16:48:25','',''),('1','57',4457224,'','20','1253',0.00,0.00,'Sales from shift 248556 on 2021-12-24 16:50:21 ','2021-12-24 16:50:21','',''),('1','57',4457225,'','6.1','1255',0.00,0.00,'Sales from shift 248556 on 2021-12-24 16:50:21 ','2021-12-24 16:50:21','',''),('1','57',4457248,'','20','1253',0.00,0.00,'Sales from shift 248557 on 2021-12-24 16:51:34 ','2021-12-24 16:51:34','',''),('1','57',4457249,'','6.1','1255',0.00,0.00,'Sales from shift 248557 on 2021-12-24 16:51:34 ','2021-12-24 16:51:34','',''),('1','57',4457276,'','20','1253',0.00,0.00,'Sales from shift 248559 on 2021-12-24 16:52:59 ','2021-12-24 16:52:59','',''),('1','57',4457277,'','6.1','1255',0.00,0.00,'Sales from shift 248559 on 2021-12-24 16:52:59 ','2021-12-24 16:52:59','',''),('1','57',4457365,'','20','1253',0.00,0.00,'Sales from shift 248560 on 2021-12-24 16:55:43 ','2021-12-24 16:55:43','',''),('1','57',4457366,'','6.1','1255',0.00,0.00,'Sales from shift 248560 on 2021-12-24 16:55:43 ','2021-12-24 16:55:43','',''),('1','57',4457646,'','20','1253',0.00,0.00,'Sales from shift 248562 on 2021-12-24 17:04:38 ','2021-12-24 17:04:38','',''),('1','57',4457647,'','6.1','1255',0.00,0.00,'Sales from shift 248562 on 2021-12-24 17:04:38 ','2021-12-24 17:04:38','',''),('1','57',4457747,'','20','1253',0.00,0.00,'Sales from shift 248566 on 2021-12-24 17:08:09 ','2021-12-24 17:08:09','',''),('1','57',4457748,'','6.1','1255',0.00,0.00,'Sales from shift 248566 on 2021-12-24 17:08:09 ','2021-12-24 17:08:09','',''),('1','57',4457813,'','20','1253',0.00,0.00,'Sales from shift 248567 on 2021-12-24 17:10:08 ','2021-12-24 17:10:08','',''),('1','57',4457814,'','6.1','1255',0.00,0.00,'Sales from shift 248567 on 2021-12-24 17:10:08 ','2021-12-24 17:10:08','',''),('1','57',4457871,'','20','1253',0.00,0.00,'Sales from shift 248568 on 2021-12-24 17:12:09 ','2021-12-24 17:12:09','',''),('1','57',4457872,'','6.1','1255',0.00,0.00,'Sales from shift 248568 on 2021-12-24 17:12:09 ','2021-12-24 17:12:09','',''),('1','57',4457918,'','20','1253',0.00,0.00,'Sales from shift 248569 on 2021-12-24 17:13:42 ','2021-12-24 17:13:42','',''),('1','57',4457919,'','6.1','1255',0.00,0.00,'Sales from shift 248569 on 2021-12-24 17:13:42 ','2021-12-24 17:13:42','',''),('1','57',4466617,'','24','1235',0.00,5950000.00,'Purchase Id 88117 for 17,000.00 litters of Diesel - AGO from A.A RANO NIGERIA LIMITED','2021-12-25 11:53:58','',''),('1','57',4466618,'','supplier','76',5950000.00,0.00,'Purchase Id 88117 for 17,000.00 litters of Diesel - AGO from A.A RANO NIGERIA LIMITED','2021-12-25 11:53:58','',''),('1','57',4488084,'','20','1253',1228489.50,0.00,'Sales from shift 248603 on 2021-12-27 13:56:38 ','2021-12-27 13:56:38','',''),('1','57',4488085,'','6.1','1255',0.00,1228489.50,'Sales from shift 248603 on 2021-12-27 13:56:38 ','2021-12-27 13:56:38','',''),('1','57',4504795,'','20','1253',209965.00,0.00,'Sales from shift 249475 on 2021-12-29 08:57:20 ','2021-12-29 08:57:20','',''),('1','57',4504796,'','6.1','1255',0.00,209965.00,'Sales from shift 249475 on 2021-12-29 08:57:20 ','2021-12-29 08:57:20','',''),('1','57',4504898,'','20','1253',622713.00,0.00,'Sales from shift 249671 on 2021-12-29 09:06:38 ','2021-12-29 09:06:38','',''),('1','57',4504899,'','6.1','1255',0.00,622713.00,'Sales from shift 249671 on 2021-12-29 09:06:38 ','2021-12-29 09:06:38','',''),('1','57',4505447,'','20','1253',32550.00,0.00,'Sales from shift 249679 on 2021-12-29 09:31:29 ','2021-12-29 09:31:29','',''),('1','57',4505448,'','6.1','1255',0.00,32550.00,'Sales from shift 249679 on 2021-12-29 09:31:29 ','2021-12-29 09:31:29','',''),('1','57',4505570,'','20','1253',1419999.00,0.00,'Sales from shift 249683 on 2021-12-29 09:35:44 ','2021-12-29 09:35:44','',''),('1','57',4505571,'','6.1','1255',0.00,1419999.00,'Sales from shift 249683 on 2021-12-29 09:35:44 ','2021-12-29 09:35:44','',''),('1','57',4505752,'','20','1253',517107.50,0.00,'Sales from shift 249685 on 2021-12-29 09:45:28 ','2021-12-29 09:45:28','',''),('1','57',4505753,'','6.1','1255',0.00,517107.50,'Sales from shift 249685 on 2021-12-29 09:45:28 ','2021-12-29 09:45:28','',''),('1','57',4505941,'','20','1253',1133272.00,0.00,'Sales from shift 249691 on 2021-12-29 09:50:31 ','2021-12-29 09:50:31','',''),('1','57',4505942,'','6.1','1255',0.00,1133272.00,'Sales from shift 249691 on 2021-12-29 09:50:31 ','2021-12-29 09:50:31','',''),('1','57',4506107,'','20','1253',31451.00,0.00,'Sales from shift 249694 on 2021-12-29 09:56:33 ','2021-12-29 09:56:33','',''),('1','57',4506108,'','6.1','1255',0.00,31451.00,'Sales from shift 249694 on 2021-12-29 09:56:33 ','2021-12-29 09:56:33','',''),('1','57',4506147,'','20','1253',822286.50,0.00,'Sales from shift 249695 on 2021-12-29 09:59:12 ','2021-12-29 09:59:12','',''),('1','57',4506148,'','6.1','1255',0.00,822286.50,'Sales from shift 249695 on 2021-12-29 09:59:12 ','2021-12-29 09:59:12','',''),('1','57',4524340,'','20','1253',0.00,0.00,'Sales from shift 249697 on 2021-12-30 13:37:28 ','2021-12-30 13:37:28','',''),('1','57',4524341,'','6.1','1255',0.00,0.00,'Sales from shift 249697 on 2021-12-30 13:37:28 ','2021-12-30 13:37:28','',''),('1','57',4524415,'','20','1253',0.00,0.00,'Sales from shift 249996 on 2021-12-30 13:41:07 ','2021-12-30 13:41:07','',''),('1','57',4524416,'','6.1','1255',0.00,0.00,'Sales from shift 249996 on 2021-12-30 13:41:07 ','2021-12-30 13:41:07','',''),('1','57',4524502,'','20','1253',0.00,0.00,'Sales from shift 249999 on 2021-12-30 13:44:34 ','2021-12-30 13:44:34','',''),('1','57',4524503,'','6.1','1255',0.00,0.00,'Sales from shift 249999 on 2021-12-30 13:44:34 ','2021-12-30 13:44:34','',''),('1','57',4524603,'','24','1235',0.00,10500000.00,'Purchase Id 88468 for 30,000.00 litters of Diesel - AGO from A.A RANO NIGERIA LIMITED','2021-12-30 13:51:35','',''),('1','57',4524604,'','supplier','76',10500000.00,0.00,'Purchase Id 88468 for 30,000.00 litters of Diesel - AGO from A.A RANO NIGERIA LIMITED','2021-12-30 13:51:35','',''),('1','57',4535137,'','20','1253',578900.00,0.00,'Sales from shift 250001 on 2021-12-31 10:58:04 ','2021-12-31 10:58:04','',''),('1','57',4535138,'','6.1','1255',0.00,578900.00,'Sales from shift 250001 on 2021-12-31 10:58:04 ','2021-12-31 10:58:04','',''),('1','57',4550266,'','20','1253',314867.00,0.00,'Sales from shift 250248 on 2022-01-01 13:10:28 ','2022-01-01 13:10:28','',''),('1','57',4550267,'','6.1','1255',0.00,314867.00,'Sales from shift 250248 on 2022-01-01 13:10:28 ','2022-01-01 13:10:28','',''),('1','57',4550524,'','20','1253',213150.00,0.00,'Sales from shift 250461 on 2022-01-01 13:29:06 ','2022-01-01 13:29:06','',''),('1','57',4550525,'','6.1','1255',0.00,213150.00,'Sales from shift 250461 on 2022-01-01 13:29:06 ','2022-01-01 13:29:06','',''),('1','57',4580273,'','20','1253',5288.50,0.00,'Sales from shift 250471 on 2022-01-04 10:50:18 ','2022-01-04 10:50:18','',''),('1','57',4580274,'','6.1','1255',0.00,5288.50,'Sales from shift 250471 on 2022-01-04 10:50:18 ','2022-01-04 10:50:18','',''),('1','57',4582102,'','20','1253',334911.50,0.00,'Sales from shift 251124 on 2022-01-04 12:17:02 ','2022-01-04 12:17:02','',''),('1','57',4582103,'','6.1','1255',0.00,334911.50,'Sales from shift 251124 on 2022-01-04 12:17:02 ','2022-01-04 12:17:02','',''),('1','57',4583008,'','20','1253',344900.50,0.00,'Sales from shift 251139 on 2022-01-04 13:03:24 ','2022-01-04 13:03:24','',''),('1','57',4583009,'','6.1','1255',0.00,344900.50,'Sales from shift 251139 on 2022-01-04 13:03:24 ','2022-01-04 13:03:24','',''),('1','57',4584648,'','20','1253',325360.00,0.00,'Sales from shift 251157 on 2022-01-04 14:15:17 ','2022-01-04 14:15:17','',''),('1','57',4584649,'','6.1','1255',0.00,325360.00,'Sales from shift 251157 on 2022-01-04 14:15:17 ','2022-01-04 14:15:17','',''),('1','57',4584716,'','20','1253',493202.50,0.00,'Sales from shift 251172 on 2022-01-04 14:19:42 ','2022-01-04 14:19:42','',''),('1','57',4584717,'','6.1','1255',0.00,493202.50,'Sales from shift 251172 on 2022-01-04 14:19:42 ','2022-01-04 14:19:42','',''),('1','57',4584804,'','20','1253',362845.00,0.00,'Sales from shift 251173 on 2022-01-04 14:24:33 ','2022-01-04 14:24:33','',''),('1','57',4584805,'','6.1','1255',0.00,362845.00,'Sales from shift 251173 on 2022-01-04 14:24:33 ','2022-01-04 14:24:33','',''),('1','57',4584935,'','20','1253',368672.50,0.00,'Sales from shift 251177 on 2022-01-04 14:30:34 ','2022-01-04 14:30:34','',''),('1','57',4584936,'','6.1','1255',0.00,368672.50,'Sales from shift 251177 on 2022-01-04 14:30:34 ','2022-01-04 14:30:34','',''),('1','57',4587300,'','2','1301',325360.00,0.00,'Payment Id 387325 for invoice:251157, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587301,'','supplier','76',0.00,325360.00,'Payment Id 387325 for invoice:251157, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587302,'','2','1301',344900.00,0.00,'Payment Id 387251 for invoice:251139, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587303,'','supplier','76',0.00,344900.00,'Payment Id 387251 for invoice:251139, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587304,'','2','1301',314865.00,0.00,'Payment Id 387179 for invoice:250248, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587305,'','supplier','76',0.00,314865.00,'Payment Id 387179 for invoice:250248, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587306,'','2','1301',822285.00,0.00,'Payment Id 384075 for invoice:249695, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587307,'','supplier','76',0.00,822285.00,'Payment Id 384075 for invoice:249695, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587308,'','2','1301',31450.00,0.00,'Payment Id 384065 for invoice:249694, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587309,'','supplier','76',0.00,31450.00,'Payment Id 384065 for invoice:249694, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587310,'','2','1301',1133270.00,0.00,'Payment Id 384059 for invoice:249691, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587311,'','supplier','76',0.00,1133270.00,'Payment Id 384059 for invoice:249691, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587312,'','2','1301',517110.00,0.00,'Payment Id 384047 for invoice:249685, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587313,'','supplier','76',0.00,517110.00,'Payment Id 384047 for invoice:249685, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587314,'','2','1301',1420000.00,0.00,'Payment Id 384044 for invoice:249683, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587315,'','supplier','76',0.00,1420000.00,'Payment Id 384044 for invoice:249683, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587316,'','2','1301',32550.00,0.00,'Payment Id 384039 for invoice:249679, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587317,'','supplier','76',0.00,32550.00,'Payment Id 384039 for invoice:249679, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587318,'','2','1301',600315.00,0.00,'Payment Id 384028 for invoice:249671, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587319,'','supplier','76',0.00,600315.00,'Payment Id 384028 for invoice:249671, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587320,'','2','1301',209965.00,0.00,'Payment Id 383720 for invoice:249475, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587321,'','supplier','76',0.00,209965.00,'Payment Id 383720 for invoice:249475, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587322,'','2','1301',1228490.00,0.00,'Payment Id 382397 for invoice:248603, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4587323,'','supplier','76',0.00,1228490.00,'Payment Id 382397 for invoice:248603, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-04 16:15:00','',''),('1','57',4591733,'','20','1253',259486.50,0.00,'Sales from shift 251179 on 2022-01-05 09:56:16 ','2022-01-05 09:56:16','',''),('1','57',4591734,'','6.1','1255',0.00,259486.50,'Sales from shift 251179 on 2022-01-05 09:56:16 ','2022-01-05 09:56:16','',''),('1','57',4603772,'','20','1253',224304.50,0.00,'Sales from shift 251348 on 2022-01-05 19:03:05 ','2022-01-05 19:03:05','',''),('1','57',4603773,'','6.1','1255',0.00,224304.50,'Sales from shift 251348 on 2022-01-05 19:03:05 ','2022-01-05 19:03:05','',''),('1','57',4603828,'','2','1301',334910.00,0.00,'Payment Id 387191 for invoice:251114, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-05 19:11:57','',''),('1','57',4603829,'','supplier','76',0.00,334910.00,'Payment Id 387191 for invoice:251114, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-05 19:11:57','',''),('1','57',4622186,'','20','1253',175000.00,0.00,'Sales from shift 251480 on 2022-01-07 11:45:43 ','2022-01-07 11:45:43','',''),('1','57',4622187,'','6.1','1255',0.00,175000.00,'Sales from shift 251480 on 2022-01-07 11:45:43 ','2022-01-07 11:45:43','',''),('1','57',4623268,'','20','1253',168595.00,0.00,'Sales from shift 251852 on 2022-01-07 12:42:00 ','2022-01-07 12:42:00','',''),('1','57',4623269,'','6.1','1255',0.00,168595.00,'Sales from shift 251852 on 2022-01-07 12:42:00 ','2022-01-07 12:42:00','',''),('1','57',4628908,'','20','1253',384048.00,0.00,'Sales from shift 251862 on 2022-01-07 17:54:13 ','2022-01-07 17:54:13','',''),('1','57',4628909,'','6.1','1255',0.00,384048.00,'Sales from shift 251862 on 2022-01-07 17:54:13 ','2022-01-07 17:54:13','',''),('1','57',4656899,'','20','1253',65667.00,0.00,'Sales from shift 251962 on 2022-01-09 19:27:20 ','2022-01-09 19:27:20','',''),('1','57',4656900,'','6.1','1255',0.00,65667.00,'Sales from shift 251962 on 2022-01-09 19:27:20 ','2022-01-09 19:27:20','',''),('1','57',4661113,'','20','1253',423405.50,0.00,'Sales from shift 252568 on 2022-01-10 11:10:06 ','2022-01-10 11:10:06','',''),('1','57',4661114,'','6.1','1255',0.00,423405.50,'Sales from shift 252568 on 2022-01-10 11:10:06 ','2022-01-10 11:10:06','',''),('1','57',4661552,'','20','1253',418775.00,0.00,'Sales from shift 252572 on 2022-01-10 11:29:38 ','2022-01-10 11:29:38','',''),('1','57',4661553,'','6.1','1255',0.00,418775.00,'Sales from shift 252572 on 2022-01-10 11:29:38 ','2022-01-10 11:29:38','',''),('1','57',4661755,'','20','1253',122475.50,0.00,'Sales from shift 252576 on 2022-01-10 11:43:10 ','2022-01-10 11:43:10','',''),('1','57',4661756,'','6.1','1255',0.00,122475.50,'Sales from shift 252576 on 2022-01-10 11:43:10 ','2022-01-10 11:43:10','',''),('1','57',4661871,'','20','1253',702198.00,0.00,'Sales from shift 252581 on 2022-01-10 11:50:17 ','2022-01-10 11:50:17','',''),('1','57',4661872,'','6.1','1255',0.00,702198.00,'Sales from shift 252581 on 2022-01-10 11:50:17 ','2022-01-10 11:50:17','',''),('1','57',4662855,'','20','1253',703290.00,0.00,'Sales from shift 252584 on 2022-01-10 12:34:50 ','2022-01-10 12:34:50','',''),('1','57',4662856,'','6.1','1255',0.00,703290.00,'Sales from shift 252584 on 2022-01-10 12:34:50 ','2022-01-10 12:34:50','',''),('1','57',4664592,'','2','4067',168585.00,0.00,'Payment Id 389029 for invoice:251852, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-10 14:06:33','',''),('1','57',4664593,'','supplier','76',0.00,168585.00,'Payment Id 389029 for invoice:251852, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-10 14:06:33','',''),('1','57',4664594,'','2','4067',175000.00,0.00,'Payment Id 388758 for invoice:251480, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-10 14:06:33','',''),('1','57',4664595,'','supplier','76',0.00,175000.00,'Payment Id 388758 for invoice:251480, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-10 14:06:33','',''),('1','57',4664596,'','2','4067',224305.00,0.00,'Payment Id 388199 for invoice:251348, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-10 14:06:33','',''),('1','57',4664597,'','supplier','76',0.00,224305.00,'Payment Id 388199 for invoice:251348, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-10 14:06:33','',''),('1','57',4664598,'','2','1301',493200.00,0.00,'Payment Id 387329 for invoice:251172, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-10 14:06:33','',''),('1','57',4664599,'','supplier','76',0.00,493200.00,'Payment Id 387329 for invoice:251172, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-10 14:06:33','',''),('1','57',4664600,'','2','1301',585200.00,0.00,'Payment Id 387170 for invoice:250001, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-10 14:06:33','',''),('1','57',4664601,'','supplier','76',0.00,585200.00,'Payment Id 387170 for invoice:250001, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-10 14:06:33','',''),('1','57',4664610,'','2','4067',223960.00,0.00,'Payment Id 387709 for invoice:251179, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-10 14:07:37','',''),('1','57',4664611,'','supplier','76',0.00,223960.00,'Payment Id 387709 for invoice:251179, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-10 14:07:37','',''),('1','57',4664612,'','2','4067',368670.00,0.00,'Payment Id 387337 for invoice:251177, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-10 14:07:37','',''),('1','57',4664613,'','supplier','76',0.00,368670.00,'Payment Id 387337 for invoice:251177, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-10 14:07:37','',''),('1','57',4664614,'','2','1301',203845.00,0.00,'Payment Id 387183 for invoice:250461, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-10 14:07:37','',''),('1','57',4664615,'','supplier','76',0.00,203845.00,'Payment Id 387183 for invoice:250461, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-10 14:07:37','',''),('1','57',4664766,'','2','1301',9305.00,0.00,'Payment Id 389081 for invoice:250471, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-10 14:14:55','',''),('1','57',4664767,'','supplier','76',0.00,9305.00,'Payment Id 389081 for invoice:250471, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-10 14:14:55','',''),('1','57',4664768,'','2','1301',362845.00,0.00,'Payment Id 387334 for invoice:251173, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-10 14:14:55','',''),('1','57',4664769,'','supplier','76',0.00,362845.00,'Payment Id 387334 for invoice:251173, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-10 14:14:55','',''),('1','57',4664770,'','2','1301',5290.00,0.00,'Payment Id 387187 for invoice:250471, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-10 14:14:55','',''),('1','57',4664771,'','supplier','76',0.00,5290.00,'Payment Id 387187 for invoice:250471, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-10 14:14:55','',''),('1','57',4674583,'','20','1253',532129.50,0.00,'Sales from shift 252805 on 2022-01-11 10:33:40 ','2022-01-11 10:33:40','',''),('1','57',4674584,'','6.1','1255',0.00,532129.50,'Sales from shift 252805 on 2022-01-11 10:33:40 ','2022-01-11 10:33:40','',''),('1','57',4674782,'','20','1253',212051.00,0.00,'Sales from shift 252807 on 2022-01-11 10:44:10 ','2022-01-11 10:44:10','',''),('1','57',4674783,'','6.1','1255',0.00,212051.00,'Sales from shift 252807 on 2022-01-11 10:44:10 ','2022-01-11 10:44:10','',''),('1','57',4678729,'','2','4067',702200.00,0.00,'Payment Id 390511 for invoice:252581, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-11 13:58:56','',''),('1','57',4678730,'','supplier','76',0.00,702200.00,'Payment Id 390511 for invoice:252581, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-11 13:58:56','',''),('1','57',4678731,'','2','4067',384050.00,0.00,'Payment Id 389076 for invoice:251862, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-11 13:58:56','',''),('1','57',4678732,'','supplier','76',0.00,384050.00,'Payment Id 389076 for invoice:251862, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-11 13:58:56','',''),('1','57',4678873,'','2','4067',65665.00,0.00,'Payment Id 390458 for invoice:251962, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-11 14:06:54','',''),('1','57',4678874,'','supplier','76',0.00,65665.00,'Payment Id 390458 for invoice:251962, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-11 14:06:54','',''),('1','57',4678877,'','2','4067',122475.00,0.00,'Payment Id 390495 for invoice:252576, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-11 14:07:08','',''),('1','57',4678878,'','supplier','76',0.00,122475.00,'Payment Id 390495 for invoice:252576, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-11 14:07:08','',''),('1','57',4678881,'','2','4067',423405.00,0.00,'Payment Id 390480 for invoice:252568, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-11 14:07:24','',''),('1','57',4678882,'','supplier','76',0.00,423405.00,'Payment Id 390480 for invoice:252568, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-11 14:07:24','',''),('1','57',4685298,'','20','1253',76979.00,0.00,'Sales from shift 252897 on 2022-01-11 18:54:42 ','2022-01-11 18:54:42','',''),('1','57',4685299,'','6.1','1255',0.00,76979.00,'Sales from shift 252897 on 2022-01-11 18:54:42 ','2022-01-11 18:54:42','',''),('1','57',4688855,'','20','1253',556608.50,0.00,'Sales from shift 252932 on 2022-01-12 09:56:02 ','2022-01-12 09:56:02','',''),('1','57',4688856,'','6.1','1255',0.00,556608.50,'Sales from shift 252932 on 2022-01-12 09:56:02 ','2022-01-12 09:56:02','',''),('1','57',4703682,'','20','1253',291389.00,0.00,'Sales from shift 253188 on 2022-01-13 10:13:31 ','2022-01-13 10:13:31','',''),('1','57',4703683,'','6.1','1255',0.00,291389.00,'Sales from shift 253188 on 2022-01-13 10:13:31 ','2022-01-13 10:13:31','',''),('1','57',4704487,'','20','1253',551460.00,0.00,'Sales from shift 253287 on 2022-01-13 10:44:05 ','2022-01-13 10:44:05','',''),('1','57',4704488,'','6.1','1255',0.00,551460.00,'Sales from shift 253287 on 2022-01-13 10:44:05 ','2022-01-13 10:44:05','',''),('1','57',4706902,'','supplier','76',0.00,35500.00,'AGO WEEKLY CONSUMPTION ','2022-01-13 00:00:00','',''),('1','57',4706903,'','24','1236',35500.00,0.00,'AGO WEEKLY CONSUMPTION ','2022-01-13 00:00:00','',''),('1','57',4707340,'','2','4067',212050.00,0.00,'Payment Id 390989 for invoice:252807, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-13 13:10:39','',''),('1','57',4707341,'','supplier','76',0.00,212050.00,'Payment Id 390989 for invoice:252807, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-13 13:10:39','',''),('1','57',4707342,'','2','4067',532130.00,0.00,'Payment Id 390976 for invoice:252805, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-13 13:10:39','',''),('1','57',4707343,'','supplier','76',0.00,532130.00,'Payment Id 390976 for invoice:252805, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-13 13:10:39','',''),('1','57',4707344,'','2','4067',703290.00,0.00,'Payment Id 390535 for invoice:252584, receipt:  by A.A RANO NIGERIA LIMITED','2022-01-13 13:10:39','',''),('1','57',4707345,'','supplier','76',0.00,703290.00,'Payment Id 390535 for invoice:252584, receipt:  by A.A RANO NIGERIA LIMITED','2022-01-13 13:10:39','',''),('1','57',4707346,'','2','4067',417725.00,0.00,'Payment Id 390492 for invoice:252572, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-13 13:10:39','',''),('1','57',4707347,'','supplier','76',0.00,417725.00,'Payment Id 390492 for invoice:252572, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-13 13:10:39','',''),('1','57',4707400,'','2','4067',76980.00,0.00,'Payment Id 391334 for invoice:252897, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-13 13:13:54','',''),('1','57',4707401,'','supplier','76',0.00,76980.00,'Payment Id 391334 for invoice:252897, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-13 13:13:54','',''),('1','57',4710218,'','20','1253',350000.00,0.00,'Sales from shift 253299 on 2022-01-13 15:47:40 ','2022-01-13 15:47:40','',''),('1','57',4710219,'','6.1','1255',0.00,350000.00,'Sales from shift 253299 on 2022-01-13 15:47:40 ','2022-01-13 15:47:40','',''),('1','57',4716949,'','20','1253',333900.00,0.00,'Sales from shift 253408 on 2022-01-14 09:49:06 ','2022-01-14 09:49:06','',''),('1','57',4716950,'','6.1','1255',0.00,333900.00,'Sales from shift 253408 on 2022-01-14 09:49:06 ','2022-01-14 09:49:06','',''),('1','57',4722059,'','2','4067',556610.00,0.00,'Payment Id 392028 for invoice:252932, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-14 14:40:54','',''),('1','57',4722060,'','supplier','76',0.00,556610.00,'Payment Id 392028 for invoice:252932, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-14 14:40:54','',''),('1','57',4722473,'','20','1253',208257.00,0.00,'Sales from shift 253613 on 2022-01-14 15:08:23 ','2022-01-14 15:08:23','',''),('1','57',4722474,'','6.1','1255',0.00,208257.00,'Sales from shift 253613 on 2022-01-14 15:08:23 ','2022-01-14 15:08:23','',''),('1','57',4732115,'','20','1253',191800.00,0.00,'Sales from shift 253635 on 2022-01-15 10:45:22 ','2022-01-15 10:45:22','',''),('1','57',4732116,'','6.1','1255',0.00,191800.00,'Sales from shift 253635 on 2022-01-15 10:45:22 ','2022-01-15 10:45:22','',''),('1','57',4743547,'','20','1253',199500.00,0.00,'Sales from shift 253813 on 2022-01-15 21:08:58 ','2022-01-15 21:08:58','',''),('1','57',4743548,'','6.1','1255',0.00,199500.00,'Sales from shift 253813 on 2022-01-15 21:08:58 ','2022-01-15 21:08:58','',''),('1','57',4753883,'','20','1253',218718.50,0.00,'Sales from shift 253921 on 2022-01-16 16:11:00 ','2022-01-16 16:11:00','',''),('1','57',4753884,'','6.1','1255',0.00,218718.50,'Sales from shift 253921 on 2022-01-16 16:11:00 ','2022-01-16 16:11:00','',''),('1','57',4757385,'','20','1253',0.00,0.00,'Sales from shift 254107 on 2022-01-16 19:47:06 ','2022-01-16 19:47:06','',''),('1','57',4757386,'','6.1','1255',0.00,0.00,'Sales from shift 254107 on 2022-01-16 19:47:06 ','2022-01-16 19:47:06','',''),('1','57',4759937,'','20','1253',0.00,0.00,'Sales from shift 254261 on 2022-01-17 09:46:34 ','2022-01-17 09:46:34','',''),('1','57',4759938,'','6.1','1255',0.00,0.00,'Sales from shift 254261 on 2022-01-17 09:46:34 ','2022-01-17 09:46:34','',''),('1','57',4764901,'','20','1253',0.00,0.00,'Sales from shift 254309 on 2022-01-17 14:50:04 ','2022-01-17 14:50:04','',''),('1','57',4764902,'','6.1','1255',0.00,0.00,'Sales from shift 254309 on 2022-01-17 14:50:04 ','2022-01-17 14:50:04','',''),('1','57',4765520,'','2','4067',291390.00,0.00,'Payment Id 392030 for invoice:253188, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-17 15:13:58','',''),('1','57',4765521,'','supplier','76',0.00,291390.00,'Payment Id 392030 for invoice:253188, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-17 15:13:58','',''),('1','57',4765537,'','2','4067',551460.00,0.00,'Payment Id 392201 for invoice:253287, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-17 15:14:53','',''),('1','57',4765538,'','supplier','76',0.00,551460.00,'Payment Id 392201 for invoice:253287, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-17 15:14:53','',''),('1','57',4768940,'','2','4067',275000.00,0.00,'Payment Id 392449 for invoice:253299, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-17 17:23:07','',''),('1','57',4768941,'','supplier','76',0.00,275000.00,'Payment Id 392449 for invoice:253299, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-17 17:23:07','',''),('1','57',4773818,'','20','1253',0.00,0.00,'Sales from shift 254367 on 2022-01-18 10:18:19 ','2022-01-18 10:18:19','',''),('1','57',4773819,'','6.1','1255',0.00,0.00,'Sales from shift 254367 on 2022-01-18 10:18:19 ','2022-01-18 10:18:19','',''),('1','57',4779853,'','20','1253',0.00,0.00,'Sales from shift 254550 on 2022-01-18 15:09:57 ','2022-01-18 15:09:57','',''),('1','57',4779854,'','6.1','1255',0.00,0.00,'Sales from shift 254550 on 2022-01-18 15:09:57 ','2022-01-18 15:09:57','',''),('1','57',4779894,'','2','4067',10000.00,0.00,'Payment Id 394688 for invoice:253613, receipt:  by A.A RANO NIGERIA LIMITED','2022-01-18 15:11:34','',''),('1','57',4779895,'','supplier','76',0.00,10000.00,'Payment Id 394688 for invoice:253613, receipt:  by A.A RANO NIGERIA LIMITED','2022-01-18 15:11:34','',''),('1','57',4779896,'','2','4067',75000.00,0.00,'Payment Id 394687 for invoice:253299, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-18 15:11:34','',''),('1','57',4779897,'','supplier','76',0.00,75000.00,'Payment Id 394687 for invoice:253299, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-18 15:11:34','',''),('1','57',4779898,'','2','4067',218720.00,0.00,'Payment Id 393802 for invoice:253921, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-18 15:11:34','',''),('1','57',4779899,'','supplier','76',0.00,218720.00,'Payment Id 393802 for invoice:253921, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-18 15:11:34','',''),('1','57',4779900,'','2','4067',191800.00,0.00,'Payment Id 393331 for invoice:253635, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-18 15:11:34','',''),('1','57',4779901,'','supplier','76',0.00,191800.00,'Payment Id 393331 for invoice:253635, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-18 15:11:34','',''),('1','57',4779902,'','2','4067',162585.00,0.00,'Payment Id 393165 for invoice:253613, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-18 15:11:34','',''),('1','57',4779903,'','supplier','76',0.00,162585.00,'Payment Id 393165 for invoice:253613, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-18 15:11:34','',''),('1','57',4779904,'','2','4067',333900.00,0.00,'Payment Id 392622 for invoice:253408, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-18 15:11:34','',''),('1','57',4779905,'','supplier','76',0.00,333900.00,'Payment Id 392622 for invoice:253408, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-18 15:11:34','',''),('1','57',4780105,'','2','4067',199500.00,0.00,'Payment Id 393801 for invoice:253813, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-18 15:21:04','',''),('1','57',4780106,'','supplier','76',0.00,199500.00,'Payment Id 393801 for invoice:253813, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-18 15:21:04','',''),('1','57',4789339,'','24','1235',0.00,7000000.00,'Purchase Id 89889 for 20,000.00 litters of Diesel - AGO from A.A RANO NIGERIA LIMITED','2022-01-19 10:42:37','',''),('1','57',4789340,'','supplier','76',7000000.00,0.00,'Purchase Id 89889 for 20,000.00 litters of Diesel - AGO from A.A RANO NIGERIA LIMITED','2022-01-19 10:42:37','',''),('1','57',4789877,'','20','1253',771018.50,0.00,'Sales from shift 254660 on 2022-01-19 11:10:54 ','2022-01-19 11:10:54','',''),('1','57',4789878,'','6.1','1255',0.00,771018.50,'Sales from shift 254660 on 2022-01-19 11:10:54 ','2022-01-19 11:10:54','',''),('1','57',4797972,'','20','1253',162277.50,0.00,'Sales from shift 254866 on 2022-01-19 17:08:41 ','2022-01-19 17:08:41','',''),('1','57',4797973,'','6.1','1255',0.00,162277.50,'Sales from shift 254866 on 2022-01-19 17:08:41 ','2022-01-19 17:08:41','',''),('1','57',4804001,'','20','1253',158200.00,0.00,'Sales from shift 254912 on 2022-01-20 10:08:28 ','2022-01-20 10:08:28','',''),('1','57',4804002,'','6.1','1255',0.00,158200.00,'Sales from shift 254912 on 2022-01-20 10:08:28 ','2022-01-20 10:08:28','',''),('1','57',4806029,'','2','4067',162277.50,0.00,'Payment Id 395874 for invoice:254866, receipt:  by A.A RANO NIGERIA LIMITED','2022-01-20 11:33:52','',''),('1','57',4806030,'','supplier','76',0.00,162277.50,'Payment Id 395874 for invoice:254866, receipt:  by A.A RANO NIGERIA LIMITED','2022-01-20 11:33:52','',''),('1','57',4806031,'','2','4067',771020.00,0.00,'Payment Id 395805 for invoice:254660, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-20 11:33:52','',''),('1','57',4806032,'','supplier','76',0.00,771020.00,'Payment Id 395805 for invoice:254660, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-20 11:33:52','',''),('1','57',4810989,'','20','1253',591941.00,0.00,'Sales from shift 255105 on 2022-01-20 15:43:43 ','2022-01-20 15:43:43','',''),('1','57',4810990,'','6.1','1255',0.00,591941.00,'Sales from shift 255105 on 2022-01-20 15:43:43 ','2022-01-20 15:43:43','',''),('1','57',4818630,'','20','1253',1113262.50,0.00,'Sales from shift 255117 on 2022-01-21 09:46:58 ','2022-01-21 09:46:58','',''),('1','57',4818631,'','6.1','1255',0.00,1113262.50,'Sales from shift 255117 on 2022-01-21 09:46:58 ','2022-01-21 09:46:58','',''),('1','57',4825102,'','2','4067',158200.00,0.00,'Payment Id 396073 for invoice:254912, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-21 15:15:32','',''),('1','57',4825103,'','supplier','76',0.00,158200.00,'Payment Id 396073 for invoice:254912, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-21 15:15:32','',''),('1','57',4827031,'','20','1253',218552.20,0.00,'Sales from shift 255308 on 2022-01-21 16:36:38 ','2022-01-21 16:36:38','',''),('1','57',4827032,'','6.1','1255',0.00,218552.20,'Sales from shift 255308 on 2022-01-21 16:36:38 ','2022-01-21 16:36:38','',''),('1','57',4835262,'','20','1253',350676.10,0.00,'Sales from shift 255536 on 2022-01-22 10:46:30 ','2022-01-22 10:46:30','',''),('1','57',4835263,'','6.1','1255',0.00,350676.10,'Sales from shift 255536 on 2022-01-22 10:46:30 ','2022-01-22 10:46:30','',''),('1','57',4844099,'','20','1253',375018.45,0.00,'Sales from shift 255626 on 2022-01-22 17:18:34 ','2022-01-22 17:18:34','',''),('1','57',4844100,'','6.1','1255',0.00,375018.45,'Sales from shift 255626 on 2022-01-22 17:18:34 ','2022-01-22 17:18:34','',''),('1','57',4854152,'','20','1253',448152.00,0.00,'Sales from shift 255681 on 2022-01-23 13:40:01 ','2022-01-23 13:40:01','',''),('1','57',4854153,'','6.1','1255',0.00,448152.00,'Sales from shift 255681 on 2022-01-23 13:40:01 ','2022-01-23 13:40:01','',''),('1','57',4858314,'','20','1253',6269.30,0.00,'Sales from shift 255864 on 2022-01-23 17:18:58 ','2022-01-23 17:18:58','',''),('1','57',4858315,'','6.1','1255',0.00,6269.30,'Sales from shift 255864 on 2022-01-23 17:18:58 ','2022-01-23 17:18:58','',''),('1','57',4862305,'','20','1253',1972813.10,0.00,'Sales from shift 255914 on 2022-01-24 09:47:04 ','2022-01-24 09:47:04','',''),('1','57',4862306,'','6.1','1255',0.00,1972813.10,'Sales from shift 255914 on 2022-01-24 09:47:04 ','2022-01-24 09:47:04','',''),('1','57',4870541,'','20','1253',400688.50,0.00,'Sales from shift 256112 on 2022-01-24 16:49:53 ','2022-01-24 16:49:53','',''),('1','57',4870542,'','6.1','1255',0.00,400688.50,'Sales from shift 256112 on 2022-01-24 16:49:53 ','2022-01-24 16:49:53','',''),('1','57',4880418,'','2','4067',1113260.00,0.00,'Payment Id 396651 for invoice:255117, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-25 12:10:00','',''),('1','57',4880419,'','supplier','76',0.00,1113260.00,'Payment Id 396651 for invoice:255117, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-25 12:10:00','',''),('1','57',4880420,'','2','4067',557640.00,0.00,'Payment Id 396331 for invoice:255105, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-25 12:10:00','',''),('1','57',4880421,'','supplier','76',0.00,557640.00,'Payment Id 396331 for invoice:255105, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-25 12:10:00','',''),('1','57',4880473,'','2','4067',1901815.00,0.00,'Payment Id 398073 for invoice:255914, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-25 12:13:28','',''),('1','57',4880474,'','supplier','76',0.00,1901815.00,'Payment Id 398073 for invoice:255914, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-25 12:13:28','',''),('1','57',4880475,'','2','4067',218550.00,0.00,'Payment Id 396884 for invoice:255308, receipt:  by A.A RANO NIGERIA LIMITED','2022-01-25 12:13:28','',''),('1','57',4880476,'','supplier','76',0.00,218550.00,'Payment Id 396884 for invoice:255308, receipt:  by A.A RANO NIGERIA LIMITED','2022-01-25 12:13:28','',''),('1','57',4880514,'','2','4067',6265.00,0.00,'Payment Id 397773 for invoice:255864, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-25 12:14:04','',''),('1','57',4880515,'','supplier','76',0.00,6265.00,'Payment Id 397773 for invoice:255864, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-25 12:14:04','',''),('1','57',4880545,'','2','4067',350670.00,0.00,'Payment Id 397130 for invoice:255536, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-25 12:15:48','',''),('1','57',4880546,'','supplier','76',0.00,350670.00,'Payment Id 397130 for invoice:255536, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-25 12:15:48','',''),('1','57',4882961,'','20','1253',257176.20,0.00,'Sales from shift 256122 on 2022-01-25 14:09:02 ','2022-01-25 14:09:02','',''),('1','57',4882962,'','6.1','1255',0.00,257176.20,'Sales from shift 256122 on 2022-01-25 14:09:02 ','2022-01-25 14:09:02','',''),('1','57',4895375,'','20','1253',360406.80,0.00,'Sales from shift 256400 on 2022-01-26 11:26:49 ','2022-01-26 11:26:49','',''),('1','57',4895376,'','6.1','1255',0.00,360406.80,'Sales from shift 256400 on 2022-01-26 11:26:49 ','2022-01-26 11:26:49','',''),('1','57',4897731,'','2','4067',448150.00,0.00,'Payment Id 397462 for invoice:255681, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-26 13:50:03','',''),('1','57',4897732,'','supplier','76',0.00,448150.00,'Payment Id 397462 for invoice:255681, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-26 13:50:03','',''),('1','57',4897733,'','2','4067',375020.00,0.00,'Payment Id 397318 for invoice:255626, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-26 13:50:03','',''),('1','57',4897734,'','supplier','76',0.00,375020.00,'Payment Id 397318 for invoice:255626, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-26 13:50:03','',''),('1','57',4897739,'','2','4067',257170.00,0.00,'Payment Id 398542 for invoice:256122, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-26 13:50:33','',''),('1','57',4897740,'','supplier','76',0.00,257170.00,'Payment Id 398542 for invoice:256122, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-26 13:50:33','',''),('1','57',4897747,'','2','4067',400680.00,0.00,'Payment Id 398322 for invoice:256112, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-26 13:51:13','',''),('1','57',4897748,'','supplier','76',0.00,400680.00,'Payment Id 398322 for invoice:256112, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-26 13:51:13','',''),('1','57',4901246,'','20','1253',0.00,0.00,'Sales from shift 256613 on 2022-01-26 17:03:02 ','2022-01-26 17:03:02','',''),('1','57',4901247,'','6.1','1255',0.00,0.00,'Sales from shift 256613 on 2022-01-26 17:03:02 ','2022-01-26 17:03:02','',''),('1','57',4908000,'','20','1253',0.00,0.00,'Sales from shift 256652 on 2022-01-27 10:41:44 ','2022-01-27 10:41:44','',''),('1','57',4908001,'','6.1','1255',0.00,0.00,'Sales from shift 256652 on 2022-01-27 10:41:44 ','2022-01-27 10:41:44','',''),('1','57',4930720,'','2','4067',126000.00,0.00,'Payment Id 399863 for invoice:256847, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-28 16:11:16','',''),('1','57',4930721,'','supplier','76',0.00,126000.00,'Payment Id 399863 for invoice:256847, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-28 16:11:16','',''),('1','57',4930722,'','2','4067',360440.00,0.00,'Payment Id 399141 for invoice:256400, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-28 16:11:16','',''),('1','57',4930723,'','supplier','76',0.00,360440.00,'Payment Id 399141 for invoice:256400, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-28 16:11:16','',''),('1','57',4930733,'','2','4067',185560.00,0.00,'Payment Id 399865 for invoice:256847, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-28 16:11:37','',''),('1','57',4930734,'','supplier','76',0.00,185560.00,'Payment Id 399865 for invoice:256847, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-28 16:11:37','',''),('1','57',4930748,'','2','4067',100000.00,0.00,'Payment Id 399867 for invoice:256847, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-28 16:11:49','',''),('1','57',4930749,'','supplier','76',0.00,100000.00,'Payment Id 399867 for invoice:256847, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-01-28 16:11:49','',''),('1','57',4931090,'','20','1253',0.00,0.00,'Sales from shift 256847 on 2022-01-28 16:24:28 ','2022-01-28 16:24:28','',''),('1','57',4931091,'','6.1','1255',0.00,0.00,'Sales from shift 256847 on 2022-01-28 16:24:28 ','2022-01-28 16:24:28','',''),('1','57',4940612,'','20','1253',0.00,0.00,'Sales from shift 257145 on 2022-01-29 11:59:15 ','2022-01-29 11:59:15','',''),('1','57',4940613,'','6.1','1255',0.00,0.00,'Sales from shift 257145 on 2022-01-29 11:59:15 ','2022-01-29 11:59:15','',''),('1','57',4940614,'','20','1253',0.00,0.00,'Sales from shift 257146 on 2022-01-31 16:59:06 ','2022-01-31 16:59:06','',''),('1','57',4940615,'','6.1','1255',0.00,0.00,'Sales from shift 257146 on 2022-01-31 16:59:06 ','2022-01-31 16:59:06','',''),('1','57',4940616,'','20','1253',0.00,0.00,'Sales from shift 257147 on 2022-01-31 17:05:34 ','2022-01-31 17:05:34','',''),('1','57',4940617,'','6.1','1255',0.00,0.00,'Sales from shift 257147 on 2022-01-31 17:05:34 ','2022-01-31 17:05:34','',''),('1','57',4940618,'','20','1253',0.00,0.00,'Sales from shift 257148 on 2022-01-31 17:09:30 ','2022-01-31 17:09:30','',''),('1','57',4940619,'','6.1','1255',0.00,0.00,'Sales from shift 257148 on 2022-01-31 17:09:30 ','2022-01-31 17:09:30','',''),('1','57',4940620,'','20','1253',0.00,0.00,'Sales from shift 257149 on 2022-01-31 17:12:06 ','2022-01-31 17:12:06','',''),('1','57',4940621,'','6.1','1255',0.00,0.00,'Sales from shift 257149 on 2022-01-31 17:12:06 ','2022-01-31 17:12:06','',''),('1','57',4940622,'','20','1253',0.00,0.00,'Sales from shift 257150 on 2022-01-31 17:16:55 ','2022-01-31 17:16:55','',''),('1','57',4940623,'','6.1','1255',0.00,0.00,'Sales from shift 257150 on 2022-01-31 17:16:55 ','2022-01-31 17:16:55','',''),('1','57',4940624,'','20','1253',0.00,0.00,'Sales from shift 257151 on 2022-01-31 17:19:08 ','2022-01-31 17:19:08','',''),('1','57',4940625,'','6.1','1255',0.00,0.00,'Sales from shift 257151 on 2022-01-31 17:19:08 ','2022-01-31 17:19:08','',''),('1','57',4940626,'','20','1253',0.00,0.00,'Sales from shift 257153 on 2022-02-02 16:45:39 ','2022-02-02 16:45:39','',''),('1','57',4940627,'','6.1','1255',0.00,0.00,'Sales from shift 257153 on 2022-02-02 16:45:39 ','2022-02-02 16:45:39','',''),('1','57',4940628,'','20','1253',0.00,0.00,'Sales from shift 257154 on 2022-02-02 16:49:38 ','2022-02-02 16:49:38','',''),('1','57',4940629,'','6.1','1255',0.00,0.00,'Sales from shift 257154 on 2022-02-02 16:49:38 ','2022-02-02 16:49:38','',''),('1','57',4940630,'','20','1253',0.00,0.00,'Sales from shift 257156 on 2022-02-02 16:55:15 ','2022-02-02 16:55:15','',''),('1','57',4940631,'','6.1','1255',0.00,0.00,'Sales from shift 257156 on 2022-02-02 16:55:15 ','2022-02-02 16:55:15','',''),('1','57',4940632,'','20','1253',0.00,0.00,'Sales from shift 257157 on 2022-02-02 16:57:54 ','2022-02-02 16:57:54','',''),('1','57',4940633,'','6.1','1255',0.00,0.00,'Sales from shift 257157 on 2022-02-02 16:57:54 ','2022-02-02 16:57:54','',''),('1','57',4940634,'','20','1253',0.00,0.00,'Sales from shift 257158 on 2022-02-03 14:08:10 ','2022-02-03 14:08:10','',''),('1','57',4940635,'','6.1','1255',0.00,0.00,'Sales from shift 257158 on 2022-02-03 14:08:10 ','2022-02-03 14:08:10','',''),('1','57',4940636,'','24','1235',0.00,7300000.00,'Purchase Id 89898 for 20,000.00 litters of Diesel - AGO from A.A RANO NIGERIA LIMITED','2022-02-04 09:29:10','',''),('1','57',4940637,'','supplier','76',7300000.00,0.00,'Purchase Id 89898 for 20,000.00 litters of Diesel - AGO from A.A RANO NIGERIA LIMITED','2022-02-04 09:29:10','',''),('1','57',4940638,'','20','1253',668972.00,0.00,'Sales from shift 257161 on 2022-02-04 15:07:30 ','2022-02-04 15:07:30','',''),('1','57',4940639,'','6.1','1255',0.00,668972.00,'Sales from shift 257161 on 2022-02-04 15:07:30 ','2022-02-04 15:07:30','',''),('1','57',4940640,'','20','1253',1098728.55,0.00,'Sales from shift 257162 on 2022-02-04 15:49:18 ','2022-02-04 15:49:18','',''),('1','57',4940641,'','6.1','1255',0.00,1098728.55,'Sales from shift 257162 on 2022-02-04 15:49:18 ','2022-02-04 15:49:18','',''),('1','57',4940642,'','20','1253',508196.80,0.00,'Sales from shift 257163 on 2022-02-05 20:52:11 ','2022-02-05 20:52:11','',''),('1','57',4940643,'','6.1','1255',0.00,508196.80,'Sales from shift 257163 on 2022-02-05 20:52:11 ','2022-02-05 20:52:11','',''),('1','57',4940644,'','20','1253',694138.40,0.00,'Sales from shift 257164 on 2022-02-06 09:14:33 ','2022-02-06 09:14:33','',''),('1','57',4940645,'','6.1','1255',0.00,694138.40,'Sales from shift 257164 on 2022-02-06 09:14:33 ','2022-02-06 09:14:33','',''),('1','57',4940646,'','20','1253',428203.00,0.00,'Sales from shift 257165 on 2022-02-06 09:26:37 ','2022-02-06 09:26:37','',''),('1','57',4940647,'','6.1','1255',0.00,428203.00,'Sales from shift 257165 on 2022-02-06 09:26:37 ','2022-02-06 09:26:37','',''),('1','57',4940648,'','20','1253',235102.20,0.00,'Sales from shift 257166 on 2022-02-07 11:03:15 ','2022-02-07 11:03:15','',''),('1','57',4940649,'','6.1','1255',0.00,235102.20,'Sales from shift 257166 on 2022-02-07 11:03:15 ','2022-02-07 11:03:15','',''),('1','57',4940650,'','20','1253',698200.60,0.00,'Sales from shift 257167 on 2022-02-07 11:22:55 ','2022-02-07 11:22:55','',''),('1','57',4940651,'','6.1','1255',0.00,698200.60,'Sales from shift 257167 on 2022-02-07 11:22:55 ','2022-02-07 11:22:55','',''),('1','57',4940652,'','2','4067',137250.00,0.00,'Payment Id 399868 for invoice:257160, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-07 15:06:09','',''),('1','57',4940653,'','supplier','76',0.00,137250.00,'Payment Id 399868 for invoice:257160, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-07 15:06:09','',''),('1','57',4940654,'','2','4067',30950.00,0.00,'Payment Id 399877 for invoice:257167, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-07 15:11:11','',''),('1','57',4940655,'','supplier','76',0.00,30950.00,'Payment Id 399877 for invoice:257167, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-07 15:11:11','',''),('1','57',4940656,'','2','4067',698200.00,0.00,'Payment Id 399876 for invoice:257166, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-07 15:11:11','',''),('1','57',4940657,'','supplier','76',0.00,698200.00,'Payment Id 399876 for invoice:257166, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-07 15:11:11','',''),('1','57',4940658,'','2','4067',235100.00,0.00,'Payment Id 399875 for invoice:257166, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-07 15:11:11','',''),('1','57',4940659,'','supplier','76',0.00,235100.00,'Payment Id 399875 for invoice:257166, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-07 15:11:11','',''),('1','57',4940660,'','2','4067',428205.00,0.00,'Payment Id 399874 for invoice:257165, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-07 15:11:11','',''),('1','57',4940661,'','supplier','76',0.00,428205.00,'Payment Id 399874 for invoice:257165, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-07 15:11:11','',''),('1','57',4940662,'','2','4067',694140.00,0.00,'Payment Id 399873 for invoice:257164, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-07 15:11:11','',''),('1','57',4940663,'','supplier','76',0.00,694140.00,'Payment Id 399873 for invoice:257164, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-07 15:11:11','',''),('1','57',4940664,'','2','4067',508195.00,0.00,'Payment Id 399872 for invoice:257163, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-07 15:11:11','',''),('1','57',4940665,'','supplier','76',0.00,508195.00,'Payment Id 399872 for invoice:257163, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-07 15:11:11','',''),('1','57',4940666,'','2','4067',1098730.00,0.00,'Payment Id 399870 for invoice:257162, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-07 15:11:11','',''),('1','57',4940667,'','supplier','76',0.00,1098730.00,'Payment Id 399870 for invoice:257162, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-07 15:11:11','',''),('1','57',4940668,'','2','4067',631925.00,0.00,'Payment Id 399869 for invoice:257161, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-07 15:11:11','',''),('1','57',4940669,'','supplier','76',0.00,631925.00,'Payment Id 399869 for invoice:257161, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-07 15:11:11','',''),('1','57',4940670,'','20','1253',543430.40,0.00,'Sales from shift 257168 on 2022-02-07 17:37:59 ','2022-02-07 17:37:59','',''),('1','57',4940671,'','6.1','1255',0.00,543430.40,'Sales from shift 257168 on 2022-02-07 17:37:59 ','2022-02-07 17:37:59','',''),('1','57',4940672,'','20','1253',696863.00,0.00,'Sales from shift 257169 on 2022-02-08 09:48:17 ','2022-02-08 09:48:17','',''),('1','57',4940673,'','6.1','1255',0.00,696863.00,'Sales from shift 257169 on 2022-02-08 09:48:17 ','2022-02-08 09:48:17','',''),('1','57',4940674,'','20','1253',370948.40,0.00,'Sales from shift 257170 on 2022-02-09 08:51:10 ','2022-02-09 08:51:10','',''),('1','57',4940675,'','6.1','1255',0.00,370948.40,'Sales from shift 257170 on 2022-02-09 08:51:10 ','2022-02-09 08:51:10','',''),('1','57',4940676,'','20','1253',1653919.60,0.00,'Sales from shift 257171 on 2022-02-09 11:15:52 ','2022-02-09 11:15:52','',''),('1','57',4940677,'','6.1','1255',0.00,1653919.60,'Sales from shift 257171 on 2022-02-09 11:15:52 ','2022-02-09 11:15:52','',''),('1','57',4940678,'','2','4067',696865.00,0.00,'Payment Id 399879 for invoice:257169, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-09 17:08:49','',''),('1','57',4940679,'','supplier','76',0.00,696865.00,'Payment Id 399879 for invoice:257169, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-09 17:08:49','',''),('1','57',4940680,'','24','1235',0.00,12636000.00,'Purchase Id 89899 for 32,400.00 litters of Diesel - AGO from A.A RANO NIGERIA LIMITED','2022-02-10 11:45:20','',''),('1','57',4940681,'','supplier','76',12636000.00,0.00,'Purchase Id 89899 for 32,400.00 litters of Diesel - AGO from A.A RANO NIGERIA LIMITED','2022-02-10 11:45:20','',''),('1','57',4940682,'','2','4067',370948.00,0.00,'Payment Id 399880 for invoice:257170, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-10 15:14:01','',''),('1','57',4940683,'','supplier','76',0.00,370948.00,'Payment Id 399880 for invoice:257170, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-10 15:14:01','',''),('1','57',4940684,'','2','4067',543430.00,0.00,'Payment Id 399878 for invoice:257168, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-10 15:14:01','',''),('1','57',4940685,'','supplier','76',0.00,543430.00,'Payment Id 399878 for invoice:257168, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-10 15:14:01','',''),('1','57',4940686,'','20','1253',0.00,0.00,'Sales from shift 257172 on 2022-02-11 10:59:10 ','2022-02-11 10:59:10','',''),('1','57',4940687,'','6.1','1255',0.00,0.00,'Sales from shift 257172 on 2022-02-11 10:59:10 ','2022-02-11 10:59:10','',''),('1','57',4940688,'','20','1253',0.00,0.00,'Sales from shift 257173 on 2022-02-11 11:27:28 ','2022-02-11 11:27:28','',''),('1','57',4940689,'','6.1','1255',0.00,0.00,'Sales from shift 257173 on 2022-02-11 11:27:28 ','2022-02-11 11:27:28','',''),('1','57',4940690,'','20','1253',0.00,0.00,'Sales from shift 257174 on 2022-02-11 11:36:55 ','2022-02-11 11:36:55','',''),('1','57',4940691,'','6.1','1255',0.00,0.00,'Sales from shift 257174 on 2022-02-11 11:36:55 ','2022-02-11 11:36:55','',''),('1','57',4940692,'','20','1253',1257660.30,0.00,'Sales from shift 257175 on 2022-02-11 12:21:07 ','2022-02-11 12:21:07','',''),('1','57',4940693,'','6.1','1255',0.00,1257660.30,'Sales from shift 257175 on 2022-02-11 12:21:07 ','2022-02-11 12:21:07','',''),('1','57',4940694,'','2','4067',1653919.60,0.00,'Payment Id 399881 for invoice:257171, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-11 16:54:59','',''),('1','57',4940695,'','supplier','76',0.00,1653919.60,'Payment Id 399881 for invoice:257171, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-11 16:54:59','',''),('1','57',4940696,'','20','1253',363698.40,0.00,'Sales from shift 257176 on 2022-02-12 11:49:16 ','2022-02-12 11:49:16','',''),('1','57',4940697,'','6.1','1255',0.00,363698.40,'Sales from shift 257176 on 2022-02-12 11:49:16 ','2022-02-12 11:49:16','',''),('1','57',4940698,'','20','1253',612296.10,0.00,'Sales from shift 257177 on 2022-02-12 11:56:40 ','2022-02-12 11:56:40','',''),('1','57',4940699,'','6.1','1255',0.00,612296.10,'Sales from shift 257177 on 2022-02-12 11:56:40 ','2022-02-12 11:56:40','',''),('1','57',4940700,'','20','1253',246027.60,0.00,'Sales from shift 257178 on 2022-02-13 21:21:20 ','2022-02-13 21:21:20','',''),('1','57',4940701,'','6.1','1255',0.00,246027.60,'Sales from shift 257178 on 2022-02-13 21:21:20 ','2022-02-13 21:21:20','',''),('1','57',4940702,'','20','1253',520884.00,0.00,'Sales from shift 257179 on 2022-02-14 12:28:26 ','2022-02-14 12:28:26','',''),('1','57',4940703,'','6.1','1255',0.00,520884.00,'Sales from shift 257179 on 2022-02-14 12:28:26 ','2022-02-14 12:28:26','',''),('1','57',4940704,'','20','1253',110000.00,0.00,'Sales from shift 257180 on 2022-02-14 12:43:40 ','2022-02-14 12:43:40','',''),('1','57',4940705,'','6.1','1255',0.00,110000.00,'Sales from shift 257180 on 2022-02-14 12:43:40 ','2022-02-14 12:43:40','',''),('1','57',4940706,'','20','1253',1299148.00,0.00,'Sales from shift 257181 on 2022-02-14 12:57:36 ','2022-02-14 12:57:36','',''),('1','57',4940707,'','6.1','1255',0.00,1299148.00,'Sales from shift 257181 on 2022-02-14 12:57:36 ','2022-02-14 12:57:36','',''),('1','57',4940708,'','20','1253',481696.00,0.00,'Sales from shift 257182 on 2022-02-15 10:49:30 ','2022-02-15 10:49:30','',''),('1','57',4940709,'','6.1','1255',0.00,481696.00,'Sales from shift 257182 on 2022-02-15 10:49:30 ','2022-02-15 10:49:30','',''),('1','57',4940710,'','2','4067',363695.00,0.00,'Payment Id 399884 for invoice:257176, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-15 11:02:50','',''),('1','57',4940711,'','supplier','76',0.00,363695.00,'Payment Id 399884 for invoice:257176, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-15 11:02:50','',''),('1','57',4940712,'','2','4067',520885.00,0.00,'Payment Id 399887 for invoice:257179, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-15 11:03:26','',''),('1','57',4940713,'','supplier','76',0.00,520885.00,'Payment Id 399887 for invoice:257179, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-15 11:03:26','',''),('1','57',4940714,'','2','4067',246030.00,0.00,'Payment Id 399886 for invoice:257178, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-15 11:03:51','',''),('1','57',4940715,'','supplier','76',0.00,246030.00,'Payment Id 399886 for invoice:257178, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-15 11:03:51','',''),('1','57',4940716,'','2','4067',110000.00,0.00,'Payment Id 399888 for invoice:257180, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-15 11:04:03','',''),('1','57',4940717,'','supplier','76',0.00,110000.00,'Payment Id 399888 for invoice:257180, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-15 11:04:03','',''),('1','57',4940718,'','2','4067',612295.00,0.00,'Payment Id 399885 for invoice:257177, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-15 11:04:34','',''),('1','57',4940719,'','supplier','76',0.00,612295.00,'Payment Id 399885 for invoice:257177, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-15 11:04:34','',''),('1','57',4940720,'','2','4067',1257660.00,0.00,'Payment Id 399883 for invoice:257175, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-15 11:08:10','',''),('1','57',4940721,'','supplier','76',0.00,1257660.00,'Payment Id 399883 for invoice:257175, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-15 11:08:10','',''),('1','57',4940722,'','20','1253',398304.00,0.00,'Sales from shift 257183 on 2022-02-15 11:38:16 ','2022-02-15 11:38:16','',''),('1','57',4940723,'','6.1','1255',0.00,398304.00,'Sales from shift 257183 on 2022-02-15 11:38:16 ','2022-02-15 11:38:16','',''),('1','57',4940724,'','20','1253',173292.00,0.00,'Sales from shift 257184 on 2022-02-15 18:19:58 ','2022-02-15 18:19:58','',''),('1','57',4940725,'','6.1','1255',0.00,173292.00,'Sales from shift 257184 on 2022-02-15 18:19:58 ','2022-02-15 18:19:58','',''),('1','57',4940726,'','20','1253',560519.20,0.00,'Sales from shift 257187 on 2022-02-16 13:54:49 ','2022-02-16 13:54:49','',''),('1','57',4940727,'','6.1','1255',0.00,560519.20,'Sales from shift 257187 on 2022-02-16 13:54:49 ','2022-02-16 13:54:49','',''),('1','57',4940728,'','2','4067',1117000.00,0.00,'Payment Id 399889 for invoice:257181, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-16 13:57:34','',''),('1','57',4940729,'','supplier','76',0.00,1117000.00,'Payment Id 399889 for invoice:257181, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-16 13:57:34','',''),('1','57',4940730,'','20','1253',417002.80,0.00,'Sales from shift 257188 on 2022-02-17 10:56:52 ','2022-02-17 10:56:52','',''),('1','57',4940731,'','6.1','1255',0.00,417002.80,'Sales from shift 257188 on 2022-02-17 10:56:52 ','2022-02-17 10:56:52','',''),('1','57',4940732,'','20','1253',748942.90,0.00,'Sales from shift 257189 on 2022-02-17 11:34:26 ','2022-02-17 11:34:26','',''),('1','57',4940733,'','6.1','1255',0.00,748942.90,'Sales from shift 257189 on 2022-02-17 11:34:26 ','2022-02-17 11:34:26','',''),('1','57',4940734,'','2','4067',398300.00,0.00,'Payment Id 399891 for invoice:257183, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-17 16:43:56','',''),('1','57',4940735,'','supplier','76',0.00,398300.00,'Payment Id 399891 for invoice:257183, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-17 16:43:56','',''),('1','57',4940736,'','20','1253',1072.00,0.00,'Sales from shift 257191 on 2022-02-18 12:09:47 ','2022-02-18 12:09:47','',''),('1','57',4940737,'','6.1','1255',0.00,1072.00,'Sales from shift 257191 on 2022-02-18 12:09:47 ','2022-02-18 12:09:47','',''),('1','57',4940738,'','20','1253',187607.80,0.00,'Sales from shift 257192 on 2022-02-18 12:34:14 ','2022-02-18 12:34:14','',''),('1','57',4940739,'','6.1','1255',0.00,187607.80,'Sales from shift 257192 on 2022-02-18 12:34:14 ','2022-02-18 12:34:14','',''),('1','57',4940740,'','2','4067',417000.00,0.00,'Payment Id 399896 for invoice:257188, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-18 15:05:11','',''),('1','57',4940741,'','supplier','76',0.00,417000.00,'Payment Id 399896 for invoice:257188, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-18 15:05:11','',''),('1','57',4940742,'','2','4067',173292.00,0.00,'Payment Id 399892 for invoice:257184, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-18 15:05:11','',''),('1','57',4940743,'','supplier','76',0.00,173292.00,'Payment Id 399892 for invoice:257184, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-18 15:05:11','',''),('1','57',4940744,'','2','4067',481700.00,0.00,'Payment Id 399890 for invoice:257182, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-18 15:05:11','',''),('1','57',4940745,'','supplier','76',0.00,481700.00,'Payment Id 399890 for invoice:257182, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-18 15:05:11','',''),('1','57',4940746,'','2','4067',182145.00,0.00,'Payment Id 399893 for invoice:257184, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-18 15:28:25','',''),('1','57',4940747,'','supplier','76',0.00,182145.00,'Payment Id 399893 for invoice:257184, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-18 15:28:25','',''),('1','57',4940748,'','20','1253',179145.40,0.00,'Sales from shift 257193 on 2022-02-19 10:38:40 ','2022-02-19 10:38:40','',''),('1','57',4940749,'','6.1','1255',0.00,179145.40,'Sales from shift 257193 on 2022-02-19 10:38:40 ','2022-02-19 10:38:40','',''),('1','57',4940750,'','20','1253',213261.50,0.00,'Sales from shift 257194 on 2022-02-19 10:48:42 ','2022-02-19 10:48:42','',''),('1','57',4940751,'','6.1','1255',0.00,213261.50,'Sales from shift 257194 on 2022-02-19 10:48:42 ','2022-02-19 10:48:42','',''),('1','57',4940752,'','20','1253',881090.00,0.00,'Sales from shift 257195 on 2022-02-19 20:58:35 ','2022-02-19 20:58:35','',''),('1','57',4940753,'','6.1','1255',0.00,881090.00,'Sales from shift 257195 on 2022-02-19 20:58:35 ','2022-02-19 20:58:35','',''),('1','57',4940754,'','20','1253',83020.90,0.00,'Sales from shift 257196 on 2022-02-20 19:31:22 ','2022-02-20 19:31:22','',''),('1','57',4940755,'','6.1','1255',0.00,83020.90,'Sales from shift 257196 on 2022-02-20 19:31:22 ','2022-02-20 19:31:22','',''),('1','57',4940756,'','20','1253',1701.50,0.00,'Sales from shift 257197 on 2022-02-21 10:29:56 ','2022-02-21 10:29:56','',''),('1','57',4940757,'','6.1','1255',0.00,1701.50,'Sales from shift 257197 on 2022-02-21 10:29:56 ','2022-02-21 10:29:56','',''),('1','57',4940758,'','20','1253',653966.40,0.00,'Sales from shift 257198 on 2022-02-21 13:50:46 ','2022-02-21 13:50:46','',''),('1','57',4940759,'','6.1','1255',0.00,653966.40,'Sales from shift 257198 on 2022-02-21 13:50:46 ','2022-02-21 13:50:46','',''),('1','57',4940760,'','2','4067',1700.00,0.00,'Payment Id 399904 for invoice:257197, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-21 16:48:56','',''),('1','57',4940761,'','supplier','76',0.00,1700.00,'Payment Id 399904 for invoice:257197, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-21 16:48:56','',''),('1','57',4940762,'','2','4067',881090.00,0.00,'Payment Id 399902 for invoice:257195, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-21 16:48:56','',''),('1','57',4940763,'','supplier','76',0.00,881090.00,'Payment Id 399902 for invoice:257195, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-21 16:48:56','',''),('1','57',4940764,'','2','4067',171850.00,0.00,'Payment Id 399901 for invoice:257194, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-21 16:48:56','',''),('1','57',4940765,'','supplier','76',0.00,171850.00,'Payment Id 399901 for invoice:257194, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-21 16:48:56','',''),('1','57',4940766,'','2','4067',179145.00,0.00,'Payment Id 399900 for invoice:257193, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-21 16:48:56','',''),('1','57',4940767,'','supplier','76',0.00,179145.00,'Payment Id 399900 for invoice:257193, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-21 16:48:56','',''),('1','57',4940768,'','2','4067',748942.00,0.00,'Payment Id 399897 for invoice:257189, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-21 16:48:56','',''),('1','57',4940769,'','supplier','76',0.00,748942.00,'Payment Id 399897 for invoice:257189, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-21 16:48:56','',''),('1','57',4940770,'','2','4067',187605.00,0.00,'Payment Id 399899 for invoice:257192, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-21 16:49:30','',''),('1','57',4940771,'','supplier','76',0.00,187605.00,'Payment Id 399899 for invoice:257192, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-21 16:49:30','',''),('1','57',4940772,'','2','4067',1095.00,0.00,'Payment Id 399898 for invoice:257190, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-21 16:50:43','',''),('1','57',4940773,'','supplier','76',0.00,1095.00,'Payment Id 399898 for invoice:257190, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-21 16:50:43','',''),('1','57',4940774,'','2','4067',83020.00,0.00,'Payment Id 399903 for invoice:257196, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-21 16:51:00','',''),('1','57',4940775,'','supplier','76',0.00,83020.00,'Payment Id 399903 for invoice:257196, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-21 16:51:00','',''),('1','57',4940776,'','20','1253',791611.60,0.00,'Sales from shift 257199 on 2022-02-21 17:29:59 ','2022-02-21 17:29:59','',''),('1','57',4940777,'','6.1','1255',0.00,791611.60,'Sales from shift 257199 on 2022-02-21 17:29:59 ','2022-02-21 17:29:59','',''),('1','57',4940778,'','20','1253',391140.00,0.00,'Sales from shift 257200 on 2022-02-22 10:46:52 ','2022-02-22 10:46:52','',''),('1','57',4940779,'','6.1','1255',0.00,391140.00,'Sales from shift 257200 on 2022-02-22 10:46:52 ','2022-02-22 10:46:52','',''),('1','57',4940780,'','2','4067',560520.00,0.00,'Payment Id 399894 for invoice:257185, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-22 11:29:40','',''),('1','57',4940781,'','supplier','76',0.00,560520.00,'Payment Id 399894 for invoice:257185, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-22 11:29:40','',''),('1','57',4940782,'','2','4067',653965.00,0.00,'Payment Id 399905 for invoice:257198, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-22 14:41:58','',''),('1','57',4940783,'','supplier','76',0.00,653965.00,'Payment Id 399905 for invoice:257198, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-22 14:41:58','',''),('1','57',4940784,'','20','1253',22718.10,0.00,'Sales from shift 257201 on 2022-02-23 10:34:45 ','2022-02-23 10:34:45','',''),('1','57',4940785,'','6.1','1255',0.00,22718.10,'Sales from shift 257201 on 2022-02-23 10:34:45 ','2022-02-23 10:34:45','',''),('1','57',4940786,'','20','1253',822902.80,0.00,'Sales from shift 257202 on 2022-02-23 11:33:26 ','2022-02-23 11:33:26','',''),('1','57',4940787,'','6.1','1255',0.00,822902.80,'Sales from shift 257202 on 2022-02-23 11:33:26 ','2022-02-23 11:33:26','',''),('1','57',4940788,'','2','4067',822900.00,0.00,'Payment Id 399909 for invoice:257201, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-23 15:31:15','',''),('1','57',4940789,'','supplier','76',0.00,822900.00,'Payment Id 399909 for invoice:257201, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-23 15:31:15','',''),('1','57',4940790,'','2','4067',391140.00,0.00,'Payment Id 399907 for invoice:257200, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-23 15:31:15','',''),('1','57',4940791,'','supplier','76',0.00,391140.00,'Payment Id 399907 for invoice:257200, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-23 15:31:15','',''),('1','57',4940792,'','2','4067',22720.00,0.00,'Payment Id 399908 for invoice:257201, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-23 15:31:31','',''),('1','57',4940793,'','supplier','76',0.00,22720.00,'Payment Id 399908 for invoice:257201, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-23 15:31:31','',''),('1','57',4940794,'','2','4067',791610.00,0.00,'Payment Id 399906 for invoice:257199, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-23 15:34:08','',''),('1','57',4940795,'','supplier','76',0.00,791610.00,'Payment Id 399906 for invoice:257199, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-23 15:34:08','',''),('1','57',4940796,'','20','1253',992474.70,0.00,'Sales from shift 257203 on 2022-02-23 23:00:04 ','2022-02-23 23:00:04','',''),('1','57',4940797,'','6.1','1255',0.00,992474.70,'Sales from shift 257203 on 2022-02-23 23:00:04 ','2022-02-23 23:00:04','',''),('1','57',4940798,'','20','1253',453037.70,0.00,'Sales from shift 257204 on 2022-02-24 10:22:56 ','2022-02-24 10:22:56','',''),('1','57',4940799,'','6.1','1255',0.00,453037.70,'Sales from shift 257204 on 2022-02-24 10:22:56 ','2022-02-24 10:22:56','',''),('1','57',4940800,'','24','1235',0.00,8200000.00,'Purchase Id 89900 for 20,000.00 litters of Diesel - AGO from A.A RANO NIGERIA LIMITED','2022-02-24 12:54:27','',''),('1','57',4940801,'','supplier','76',8200000.00,0.00,'Purchase Id 89900 for 20,000.00 litters of Diesel - AGO from A.A RANO NIGERIA LIMITED','2022-02-24 12:54:27','',''),('1','57',4940802,'','20','1253',1482154.10,0.00,'Sales from shift 257205 on 2022-02-25 11:01:13 ','2022-02-25 11:01:13','',''),('1','57',4940803,'','6.1','1255',0.00,1482154.10,'Sales from shift 257205 on 2022-02-25 11:01:13 ','2022-02-25 11:01:13','',''),('1','57',4940804,'','20','1253',322149.30,0.00,'Sales from shift 257206 on 2022-02-25 11:15:36 ','2022-02-25 11:15:36','',''),('1','57',4940805,'','6.1','1255',0.00,322149.30,'Sales from shift 257206 on 2022-02-25 11:15:36 ','2022-02-25 11:15:36','',''),('1','57',4940806,'','2','4067',1482155.00,0.00,'Payment Id 399912 for invoice:257205, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-25 11:47:07','',''),('1','57',4940807,'','supplier','76',0.00,1482155.00,'Payment Id 399912 for invoice:257205, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-25 11:47:07','',''),('1','57',4940808,'','2','4067',992475.00,0.00,'Payment Id 399910 for invoice:257203, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-25 11:50:08','',''),('1','57',4940809,'','supplier','76',0.00,992475.00,'Payment Id 399910 for invoice:257203, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-25 11:50:08','',''),('1','57',4940810,'','2','4067',453040.00,0.00,'Payment Id 399911 for invoice:257204, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-25 11:50:27','',''),('1','57',4940811,'','supplier','76',0.00,453040.00,'Payment Id 399911 for invoice:257204, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-02-25 11:50:27','',''),('1','57',4940812,'','20','1253',729980.40,0.00,'Sales from shift 257207 on 2022-02-25 15:10:58 ','2022-02-25 15:10:58','',''),('1','57',4940813,'','6.1','1255',0.00,729980.40,'Sales from shift 257207 on 2022-02-25 15:10:58 ','2022-02-25 15:10:58','',''),('1','57',4940814,'','20','1253',46088.10,0.00,'Sales from shift 257208 on 2022-02-26 16:55:10 ','2022-02-26 16:55:10','',''),('1','57',4940815,'','6.1','1255',0.00,46088.10,'Sales from shift 257208 on 2022-02-26 16:55:10 ','2022-02-26 16:55:10','',''),('1','57',4940816,'','20','1253',577563.80,0.00,'Sales from shift 257209 on 2022-02-27 09:35:36 ','2022-02-27 09:35:36','',''),('1','57',4940817,'','6.1','1255',0.00,577563.80,'Sales from shift 257209 on 2022-02-27 09:35:36 ','2022-02-27 09:35:36','',''),('1','57',4940818,'','20','1253',311266.60,0.00,'Sales from shift 257210 on 2022-02-28 10:25:00 ','2022-02-28 10:25:00','',''),('1','57',4940819,'','6.1','1255',0.00,311266.60,'Sales from shift 257210 on 2022-02-28 10:25:00 ','2022-02-28 10:25:00','',''),('1','57',4940820,'','20','1253',1077377.35,0.00,'Sales from shift 257211 on 2022-02-28 10:47:48 ','2022-02-28 10:47:48','',''),('1','57',4940821,'','6.1','1255',0.00,1077377.35,'Sales from shift 257211 on 2022-02-28 10:47:48 ','2022-02-28 10:47:48','',''),('1','57',4940822,'','20','1253',1460800.00,0.00,'Sales from shift 257212 on 2022-02-28 14:20:36 ','2022-02-28 14:20:36','',''),('1','57',4940823,'','6.1','1255',0.00,1460800.00,'Sales from shift 257212 on 2022-02-28 14:20:36 ','2022-02-28 14:20:36','',''),('1','57',4940824,'','20','1253',715389.45,0.00,'Sales from shift 257213 on 2022-02-28 15:18:13 ','2022-02-28 15:18:13','',''),('1','57',4940825,'','6.1','1255',0.00,715389.45,'Sales from shift 257213 on 2022-02-28 15:18:13 ','2022-02-28 15:18:13','',''),('1','57',4940826,'','2','4067',275350.00,0.00,'Payment Id 399913 for invoice:257206, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-01 16:54:07','',''),('1','57',4940827,'','supplier','76',0.00,275350.00,'Payment Id 399913 for invoice:257206, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-01 16:54:07','',''),('1','57',4940828,'','2','4067',729989.00,0.00,'Payment Id 399915 for invoice:257207, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-01 17:11:56','',''),('1','57',4940829,'','supplier','76',0.00,729989.00,'Payment Id 399915 for invoice:257207, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-01 17:11:56','',''),('1','57',4940830,'','2','4067',1077377.00,0.00,'Payment Id 399919 for invoice:257211, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-01 17:13:09','',''),('1','57',4940831,'','supplier','76',0.00,1077377.00,'Payment Id 399919 for invoice:257211, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-01 17:13:09','',''),('1','57',4940832,'','20','1253',249020.75,0.00,'Sales from shift 257214 on 2022-03-01 18:09:48 ','2022-03-01 18:09:48','',''),('1','57',4940833,'','6.1','1255',0.00,249020.75,'Sales from shift 257214 on 2022-03-01 18:09:48 ','2022-03-01 18:09:48','',''),('1','57',4940834,'','20','1253',423432.80,0.00,'Sales from shift 257215 on 2022-03-01 18:17:12 ','2022-03-01 18:17:12','',''),('1','57',4940835,'','6.1','1255',0.00,423432.80,'Sales from shift 257215 on 2022-03-01 18:17:12 ','2022-03-01 18:17:12','',''),('1','57',4940836,'','2','4067',269710.00,0.00,'Payment Id 399918 for invoice:257210, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-02 15:18:40','',''),('1','57',4940837,'','supplier','76',0.00,269710.00,'Payment Id 399918 for invoice:257210, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-02 15:18:40','',''),('1','57',4940838,'','2','4067',577563.00,0.00,'Payment Id 399917 for invoice:257209, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-02 15:18:40','',''),('1','57',4940839,'','supplier','76',0.00,577563.00,'Payment Id 399917 for invoice:257209, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-02 15:18:40','',''),('1','57',4940840,'','2','4067',46650.00,0.00,'Payment Id 399916 for invoice:257208, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-02 15:19:53','',''),('1','57',4940841,'','supplier','76',0.00,46650.00,'Payment Id 399916 for invoice:257208, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-02 15:19:53','',''),('1','57',4940842,'','2','4067',1458205.00,0.00,'Payment Id 399921 for invoice:257212, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-02 17:00:19','',''),('1','57',4940843,'','supplier','76',0.00,1458205.00,'Payment Id 399921 for invoice:257212, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-02 17:00:19','',''),('1','57',4940844,'','20','1253',1148305.00,0.00,'Sales from shift 257216 on 2022-03-02 17:41:59 ','2022-03-02 17:41:59','',''),('1','57',4940845,'','6.1','1255',0.00,1148305.00,'Sales from shift 257216 on 2022-03-02 17:41:59 ','2022-03-02 17:41:59','',''),('1','57',4940846,'','20','1253',0.00,0.00,'Sales from shift 257217 on 2022-03-03 22:11:33 ','2022-03-03 22:11:33','',''),('1','57',4940847,'','6.1','1255',0.00,0.00,'Sales from shift 257217 on 2022-03-03 22:11:33 ','2022-03-03 22:11:33','',''),('1','57',4940848,'','24','1235',0.00,9890000.00,'Purchase Id 89902 for 23,000.00 litters of Diesel - AGO from A.A RANO NIGERIA LIMITED','2022-03-03 22:12:21','',''),('1','57',4940849,'','supplier','76',9890000.00,0.00,'Purchase Id 89902 for 23,000.00 litters of Diesel - AGO from A.A RANO NIGERIA LIMITED','2022-03-03 22:12:21','',''),('1','57',4940850,'','20','1253',0.00,0.00,'Sales from shift 257218 on 2022-03-04 09:14:26 ','2022-03-04 09:14:26','',''),('1','57',4940851,'','6.1','1255',0.00,0.00,'Sales from shift 257218 on 2022-03-04 09:14:26 ','2022-03-04 09:14:26','',''),('1','57',4940852,'','20','1253',0.00,0.00,'Sales from shift 257219 on 2022-03-04 12:45:13 ','2022-03-04 12:45:13','',''),('1','57',4940853,'','6.1','1255',0.00,0.00,'Sales from shift 257219 on 2022-03-04 12:45:13 ','2022-03-04 12:45:13','',''),('1','57',4940854,'','20','1253',484433.70,0.00,'Sales from shift 257220 on 2022-03-04 13:44:12 ','2022-03-04 13:44:12','',''),('1','57',4940855,'','6.1','1255',0.00,484433.70,'Sales from shift 257220 on 2022-03-04 13:44:12 ','2022-03-04 13:44:12','',''),('1','57',4940856,'','2','4103',620000.00,0.00,'Payment Id 399925 for invoice:257216, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-04 15:05:56','',''),('1','57',4940857,'','supplier','76',0.00,620000.00,'Payment Id 399925 for invoice:257216, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-04 15:05:56','',''),('1','57',4940858,'','2','4067',249020.00,0.00,'Payment Id 399923 for invoice:257214, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-04 15:06:30','',''),('1','57',4940859,'','supplier','76',0.00,249020.00,'Payment Id 399923 for invoice:257214, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-04 15:06:30','',''),('1','57',4940860,'','2','4067',423390.00,0.00,'Payment Id 399924 for invoice:257215, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-04 15:07:03','',''),('1','57',4940861,'','supplier','76',0.00,423390.00,'Payment Id 399924 for invoice:257215, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-04 15:07:03','',''),('1','57',4940862,'','2','4067',717985.00,0.00,'Payment Id 399922 for invoice:257213, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-04 15:07:38','',''),('1','57',4940863,'','supplier','76',0.00,717985.00,'Payment Id 399922 for invoice:257213, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-04 15:07:38','',''),('1','57',4940864,'','2','4067',528305.00,0.00,'Payment Id 399926 for invoice:257216, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-04 15:08:50','',''),('1','57',4940865,'','supplier','76',0.00,528305.00,'Payment Id 399926 for invoice:257216, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-03-04 15:08:50','',''),('1','57',4940866,'','2','4067',484435.00,0.00,'Payment Id 399927 for invoice:257220, receipt:  by A.A RANO NIGERIA LIMITED','2022-03-04 15:13:23','',''),('1','57',4940867,'','supplier','76',0.00,484435.00,'Payment Id 399927 for invoice:257220, receipt:  by A.A RANO NIGERIA LIMITED','2022-03-04 15:13:23','',''),('1','57',4940868,'','20','1253',938161.10,0.00,'Sales from shift 257221 on 2022-03-04 16:26:37 ','2022-03-04 16:26:37','',''),('1','57',4940869,'','6.1','1255',0.00,938161.10,'Sales from shift 257221 on 2022-03-04 16:26:37 ','2022-03-04 16:26:37','',''),('1','57',4940870,'','2','4067',938160.00,0.00,'Payment Id 399928 for invoice:257221, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-04 16:28:55','',''),('1','57',4940871,'','supplier','76',0.00,938160.00,'Payment Id 399928 for invoice:257221, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-04 16:28:55','',''),('1','57',4940872,'','20','1253',452622.30,0.00,'Sales from shift 257222 on 2022-03-05 09:48:06 ','2022-03-05 09:48:06','',''),('1','57',4940873,'','6.1','1255',0.00,452622.30,'Sales from shift 257222 on 2022-03-05 09:48:06 ','2022-03-05 09:48:06','',''),('1','57',4940874,'','20','1253',435983.40,0.00,'Sales from shift 257223 on 2022-03-05 11:56:44 ','2022-03-05 11:56:44','',''),('1','57',4940875,'','6.1','1255',0.00,435983.40,'Sales from shift 257223 on 2022-03-05 11:56:44 ','2022-03-05 11:56:44','',''),('1','57',4940876,'','20','1253',2051581.60,0.00,'Sales from shift 257224 on 2022-03-07 02:14:47 ','2022-03-07 02:14:47','',''),('1','57',4940877,'','6.1','1255',0.00,2051581.60,'Sales from shift 257224 on 2022-03-07 02:14:47 ','2022-03-07 02:14:47','',''),('1','57',4940878,'','20','1253',249535.00,0.00,'Sales from shift 257225 on 2022-03-07 08:25:20 ','2022-03-07 08:25:20','',''),('1','57',4940879,'','6.1','1255',0.00,249535.00,'Sales from shift 257225 on 2022-03-07 08:25:20 ','2022-03-07 08:25:20','',''),('1','57',4940880,'','20','1253',1056040.00,0.00,'Sales from shift 257226 on 2022-03-07 08:35:22 ','2022-03-07 08:35:22','',''),('1','57',4940881,'','6.1','1255',0.00,1056040.00,'Sales from shift 257226 on 2022-03-07 08:35:22 ','2022-03-07 08:35:22','',''),('1','57',4940882,'','20','1253',0.00,0.00,'Sales from shift 257227 on 2022-03-07 11:19:51 ','2022-03-07 11:19:51','',''),('1','57',4940883,'','6.1','1255',0.00,0.00,'Sales from shift 257227 on 2022-03-07 11:19:51 ','2022-03-07 11:19:51','',''),('1','57',4940884,'','20','1253',910005.00,0.00,'Sales from shift 257228 on 2022-03-07 11:27:11 ','2022-03-07 11:27:11','',''),('1','57',4940885,'','6.1','1255',0.00,910005.00,'Sales from shift 257228 on 2022-03-07 11:27:11 ','2022-03-07 11:27:11','',''),('1','57',4940886,'','24','1236',46000.00,0.00,'AGO CONSUMPTION 100','2022-03-03 00:00:00','',''),('1','57',4940887,'','supplier','76',0.00,46000.00,'AGO CONSUMPTION 100','2022-03-03 00:00:00','',''),('1','57',4940888,'','20','1253',1000000.00,0.00,'Sales from shift 257229 on 2022-03-07 17:01:15 ','2022-03-07 17:01:15','',''),('1','57',4940889,'','6.1','1255',0.00,1000000.00,'Sales from shift 257229 on 2022-03-07 17:01:15 ','2022-03-07 17:01:15','',''),('1','57',4940890,'','2','4067',526000.00,0.00,'Payment Id 399935 for invoice:257229, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-07 17:04:20','',''),('1','57',4940891,'','supplier','76',0.00,526000.00,'Payment Id 399935 for invoice:257229, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-07 17:04:20','',''),('1','57',4940892,'','2','4067',1056040.00,0.00,'Payment Id 399933 for invoice:257226, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-07 17:04:20','',''),('1','57',4940893,'','supplier','76',0.00,1056040.00,'Payment Id 399933 for invoice:257226, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-07 17:04:20','',''),('1','57',4940894,'','2','4067',249535.00,0.00,'Payment Id 399932 for invoice:257225, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-07 17:04:20','',''),('1','57',4940895,'','supplier','76',0.00,249535.00,'Payment Id 399932 for invoice:257225, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-07 17:04:20','',''),('1','57',4940896,'','2','4067',2051581.60,0.00,'Payment Id 399931 for invoice:257224, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-07 17:04:20','',''),('1','57',4940897,'','supplier','76',0.00,2051581.60,'Payment Id 399931 for invoice:257224, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-07 17:04:20','',''),('1','57',4940898,'','2','4067',389983.00,0.00,'Payment Id 399930 for invoice:257223, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-07 17:04:20','',''),('1','57',4940899,'','supplier','76',0.00,389983.00,'Payment Id 399930 for invoice:257223, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-07 17:04:20','',''),('1','57',4940900,'','2','4067',452620.00,0.00,'Payment Id 399929 for invoice:257222, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-07 17:06:29','',''),('1','57',4940901,'','supplier','76',0.00,452620.00,'Payment Id 399929 for invoice:257222, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-07 17:06:29','',''),('1','57',4940902,'','20','1253',1000.00,0.00,'Sales from shift 257230 on 2022-03-08 14:18:04 ','2022-03-08 14:18:04','',''),('1','57',4940903,'','6.1','1255',0.00,1000.00,'Sales from shift 257230 on 2022-03-08 14:18:04 ','2022-03-08 14:18:04','',''),('1','57',4940904,'','2','4067',0.00,526000.00,'Payment Id 399935 for invoice:257229, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-08 16:04:22','',''),('1','57',4940905,'','supplier','76',526000.00,0.00,'Payment Id 399935 for invoice:257229, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-08 16:04:22','',''),('1','57',4940906,'','2','4103',526000.00,0.00,'Payment Id 399934 for invoice:257227, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-08 16:04:35','',''),('1','57',4940907,'','supplier','76',0.00,526000.00,'Payment Id 399934 for invoice:257227, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-08 16:04:35','',''),('1','57',4940908,'','20','1253',1001640.00,0.00,'Sales from shift 257231 on 2022-03-09 08:33:21 ','2022-03-09 08:33:21','',''),('1','57',4940909,'','6.1','1255',0.00,1001640.00,'Sales from shift 257231 on 2022-03-09 08:33:21 ','2022-03-09 08:33:21','',''),('1','57',4940910,'','20','1253',121212.00,0.00,'Sales from shift 257232 on 2022-03-09 10:20:21 ','2022-03-09 10:20:21','',''),('1','57',4940911,'','6.1','1255',0.00,121212.00,'Sales from shift 257232 on 2022-03-09 10:20:21 ','2022-03-09 10:20:21','',''),('1','57',4940912,'','2','4103',593000.00,0.00,'Payment Id 399939 for invoice:257230, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-09 11:43:35','',''),('1','57',4940913,'','supplier','76',0.00,593000.00,'Payment Id 399939 for invoice:257230, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-09 11:43:35','',''),('1','57',4940914,'','2','4067',407000.00,0.00,'Payment Id 399940 for invoice:257230, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-09 11:48:49','',''),('1','57',4940915,'','supplier','76',0.00,407000.00,'Payment Id 399940 for invoice:257230, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-09 11:48:49','',''),('1','57',4940916,'','2','4067',1000.00,0.00,'Payment Id 399938 for invoice:257230, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-09 11:48:49','',''),('1','57',4940917,'','supplier','76',0.00,1000.00,'Payment Id 399938 for invoice:257230, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-09 11:48:49','',''),('1','57',4940918,'','2','4067',384005.00,0.00,'Payment Id 399937 for invoice:257229, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-09 11:48:49','',''),('1','57',4940919,'','supplier','76',0.00,384005.00,'Payment Id 399937 for invoice:257229, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-09 11:48:49','',''),('1','57',4940920,'','20','1253',300.00,0.00,'Sales from shift 257233 on 2022-03-10 10:44:36 ','2022-03-10 10:44:36','',''),('1','57',4940921,'','6.1','1255',0.00,300.00,'Sales from shift 257233 on 2022-03-10 10:44:36 ','2022-03-10 10:44:36','',''),('1','57',4940922,'','20','1253',300.00,0.00,'Sales from shift 257234 on 2022-03-10 16:44:14 ','2022-03-10 16:44:14','',''),('1','57',4940923,'','6.1','1255',0.00,300.00,'Sales from shift 257234 on 2022-03-10 16:44:14 ','2022-03-10 16:44:14','',''),('1','57',4940924,'','20','1253',934944.00,0.00,'Sales from shift 257235 on 2022-03-10 16:50:52 ','2022-03-10 16:50:52','',''),('1','57',4940925,'','6.1','1255',0.00,934944.00,'Sales from shift 257235 on 2022-03-10 16:50:52 ','2022-03-10 16:50:52','',''),('1','57',4940926,'','2','4067',121215.00,0.00,'Payment Id 399942 for invoice:257232, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-10 16:52:45','',''),('1','57',4940927,'','supplier','76',0.00,121215.00,'Payment Id 399942 for invoice:257232, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-10 16:52:45','',''),('1','57',4940928,'','2','4067',1001640.00,0.00,'Payment Id 399941 for invoice:257231, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-10 16:52:45','',''),('1','57',4940929,'','supplier','76',0.00,1001640.00,'Payment Id 399941 for invoice:257231, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-10 16:52:45','',''),('1','57',4940930,'','20','1253',1503498.00,0.00,'Sales from shift 257236 on 2022-03-11 11:44:56 ','2022-03-11 11:44:56','',''),('1','57',4940931,'','6.1','1255',0.00,1503498.00,'Sales from shift 257236 on 2022-03-11 11:44:56 ','2022-03-11 11:44:56','',''),('1','57',4940932,'','2','4103',542743.00,0.00,'Payment Id 399945 for invoice:257236, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-11 16:55:45','',''),('1','57',4940933,'','supplier','76',0.00,542743.00,'Payment Id 399945 for invoice:257236, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-11 16:55:45','',''),('1','57',4940934,'','2','4067',300.00,0.00,'Payment Id 399943 for invoice:257233, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-11 16:55:45','',''),('1','57',4940935,'','supplier','76',0.00,300.00,'Payment Id 399943 for invoice:257233, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-11 16:55:45','',''),('1','57',4940936,'','2','4067',960755.00,0.00,'Payment Id 399946 for invoice:257236, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-11 16:58:34','',''),('1','57',4940937,'','supplier','76',0.00,960755.00,'Payment Id 399946 for invoice:257236, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-11 16:58:34','',''),('1','57',4940938,'','2','4067',934944.00,0.00,'Payment Id 399944 for invoice:257235, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-11 16:58:34','',''),('1','57',4940939,'','supplier','76',0.00,934944.00,'Payment Id 399944 for invoice:257235, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-11 16:58:34','',''),('1','57',4940940,'','20','1253',301194.00,0.00,'Sales from shift 257237 on 2022-03-11 21:21:53 ','2022-03-11 21:21:53','',''),('1','57',4940941,'','6.1','1255',0.00,301194.00,'Sales from shift 257237 on 2022-03-11 21:21:53 ','2022-03-11 21:21:53','',''),('1','57',4940942,'','20','1253',139200.00,0.00,'Sales from shift 257238 on 2022-03-12 22:18:04 ','2022-03-12 22:18:04','',''),('1','57',4940943,'','6.1','1255',0.00,139200.00,'Sales from shift 257238 on 2022-03-12 22:18:04 ','2022-03-12 22:18:04','',''),('1','57',4940944,'','24','1236',39390.00,0.00,'AGO CONSUMING FOR 7 DAY101 at 390 ','2022-02-10 00:00:00','',''),('1','57',4940945,'','supplier','76',0.00,39390.00,'AGO CONSUMING FOR 7 DAY101 at 390 ','2022-02-10 00:00:00','',''),('1','57',4940946,'','2','4067',79200.00,0.00,'Payment Id 399948 for invoice:257238, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-15 12:03:13','',''),('1','57',4940947,'','supplier','76',0.00,79200.00,'Payment Id 399948 for invoice:257238, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-15 12:03:13','',''),('1','57',4940948,'','2','4067',301195.00,0.00,'Payment Id 399947 for invoice:257237, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-15 12:03:13','',''),('1','57',4940949,'','supplier','76',0.00,301195.00,'Payment Id 399947 for invoice:257237, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-15 12:03:13','',''),('1','57',4940950,'','24','1235',0.00,11900000.00,'Purchase Id 89903 for 17,000.00 litters of Diesel - AGO from A.A RANO NIGERIA LIMITED','2022-03-27 17:59:48','',''),('1','57',4940951,'','supplier','76',11900000.00,0.00,'Purchase Id 89903 for 17,000.00 litters of Diesel - AGO from A.A RANO NIGERIA LIMITED','2022-03-27 17:59:48','',''),('1','57',4940952,'','20','1253',0.00,0.00,'Sales from shift 257239 on 2022-03-28 08:12:18 ','2022-03-28 08:12:18','',''),('1','57',4940953,'','6.1','1255',0.00,0.00,'Sales from shift 257239 on 2022-03-28 08:12:18 ','2022-03-28 08:12:18','',''),('1','57',4940954,'','20','1253',288904.00,0.00,'Sales from shift 257240 on 2022-03-28 10:44:02 ','2022-03-28 10:44:02','',''),('1','57',4940955,'','6.1','1255',0.00,288904.00,'Sales from shift 257240 on 2022-03-28 10:44:02 ','2022-03-28 10:44:02','',''),('1','57',4940956,'','2','4067',218900.00,0.00,'Payment Id 399949 for invoice:257240, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-28 16:24:12','',''),('1','57',4940957,'','supplier','76',0.00,218900.00,'Payment Id 399949 for invoice:257240, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-28 16:24:12','',''),('1','57',4940958,'','20','1253',708099.00,0.00,'Sales from shift 257241 on 2022-03-28 20:24:40 ','2022-03-28 20:24:40','',''),('1','57',4940959,'','6.1','1255',0.00,708099.00,'Sales from shift 257241 on 2022-03-28 20:24:40 ','2022-03-28 20:24:40','',''),('1','57',4940960,'','20','1253',17997.00,0.00,'Sales from shift 257242 on 2022-03-29 11:37:17 ','2022-03-29 11:37:17','',''),('1','57',4940961,'','6.1','1255',0.00,17997.00,'Sales from shift 257242 on 2022-03-29 11:37:17 ','2022-03-29 11:37:17','',''),('1','57',4940962,'','20','1253',217203.00,0.00,'Sales from shift 257243 on 2022-03-29 18:25:01 ','2022-03-29 18:25:01','',''),('1','57',4940963,'','6.1','1255',0.00,217203.00,'Sales from shift 257243 on 2022-03-29 18:25:01 ','2022-03-29 18:25:01','',''),('1','57',4940964,'','20','1253',224497.00,0.00,'Sales from shift 257244 on 2022-03-30 09:38:58 ','2022-03-30 09:38:58','',''),('1','57',4940965,'','6.1','1255',0.00,224497.00,'Sales from shift 257244 on 2022-03-30 09:38:58 ','2022-03-30 09:38:58','',''),('1','57',4940966,'','2','4067',376690.00,0.00,'Payment Id 399950 for invoice:257241, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-30 12:35:59','',''),('1','57',4940967,'','supplier','76',0.00,376690.00,'Payment Id 399950 for invoice:257241, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-30 12:35:59','',''),('1','57',4940968,'','2','4067',18000.00,0.00,'Payment Id 399952 for invoice:257242, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-30 12:36:37','',''),('1','57',4940969,'','supplier','76',0.00,18000.00,'Payment Id 399952 for invoice:257242, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-30 12:36:37','',''),('1','57',4940970,'','2','4067',217205.00,0.00,'Payment Id 399953 for invoice:257243, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-30 12:37:43','',''),('1','57',4940971,'','supplier','76',0.00,217205.00,'Payment Id 399953 for invoice:257243, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-30 12:37:43','',''),('1','57',4940972,'','2','4067',224495.00,0.00,'Payment Id 399954 for invoice:257244, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-30 12:38:03','',''),('1','57',4940973,'','supplier','76',0.00,224495.00,'Payment Id 399954 for invoice:257244, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-30 12:38:03','',''),('1','57',4940974,'','20','1253',18893.00,0.00,'Sales from shift 257245 on 2022-03-31 09:39:41 ','2022-03-31 09:39:41','',''),('1','57',4940975,'','6.1','1255',0.00,18893.00,'Sales from shift 257245 on 2022-03-31 09:39:41 ','2022-03-31 09:39:41','',''),('1','57',4940976,'','20','1253',0.00,0.00,'Sales from shift 257246 on 2022-03-31 11:20:11 ','2022-03-31 11:20:11','',''),('1','57',4940977,'','6.1','1255',0.00,0.00,'Sales from shift 257246 on 2022-03-31 11:20:11 ','2022-03-31 11:20:11','',''),('1','57',4940978,'','2','4067',18895.00,0.00,'Payment Id 399955 for invoice:257245, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-31 13:21:51','',''),('1','57',4940979,'','supplier','76',0.00,18895.00,'Payment Id 399955 for invoice:257245, receipt: oo by A.A RANO NIGERIA LIMITED','2022-03-31 13:21:51','',''),('1','57',4940980,'','20','1253',6993.00,0.00,'Sales from shift 257247 on 2022-04-01 10:34:17 ','2022-04-01 10:34:17','',''),('1','57',4940981,'','6.1','1255',0.00,6993.00,'Sales from shift 257247 on 2022-04-01 10:34:17 ','2022-04-01 10:34:17','',''),('1','57',4940982,'','20','1253',21000.00,0.00,'Sales from shift 257248 on 2022-04-01 11:10:18 ','2022-04-01 11:10:18','',''),('1','57',4940983,'','6.1','1255',0.00,21000.00,'Sales from shift 257248 on 2022-04-01 11:10:18 ','2022-04-01 11:10:18','',''),('1','57',4940984,'','20','1253',9205.00,0.00,'Sales from shift 257249 on 2022-04-02 12:30:30 ','2022-04-02 12:30:30','',''),('1','57',4940985,'','6.1','1255',0.00,9205.00,'Sales from shift 257249 on 2022-04-02 12:30:30 ','2022-04-02 12:30:30','',''),('1','57',4940986,'','20','1253',65422.00,0.00,'Sales from shift 257250 on 2022-04-02 23:01:04 ','2022-04-02 23:01:04','',''),('1','57',4940987,'','6.1','1255',0.00,65422.00,'Sales from shift 257250 on 2022-04-02 23:01:04 ','2022-04-02 23:01:04','',''),('1','57',4940988,'','20','1253',78407.00,0.00,'Sales from shift 257251 on 2022-04-02 23:10:48 ','2022-04-02 23:10:48','',''),('1','57',4940989,'','6.1','1255',0.00,78407.00,'Sales from shift 257251 on 2022-04-02 23:10:48 ','2022-04-02 23:10:48','',''),('1','57',4940990,'','20','1253',1700181.00,0.00,'Sales from shift 257252 on 2022-04-02 23:15:17 ','2022-04-02 23:15:17','',''),('1','57',4940991,'','6.1','1255',0.00,1700181.00,'Sales from shift 257252 on 2022-04-02 23:15:17 ','2022-04-02 23:15:17','',''),('1','57',4940992,'','20','1253',4998.00,0.00,'Sales from shift 257253 on 2022-04-04 09:33:10 ','2022-04-04 09:33:10','',''),('1','57',4940993,'','6.1','1255',0.00,4998.00,'Sales from shift 257253 on 2022-04-04 09:33:10 ','2022-04-04 09:33:10','',''),('1','57',4940994,'','20','1253',6720.00,0.00,'Sales from shift 257254 on 2022-04-04 11:00:42 ','2022-04-04 11:00:42','',''),('1','57',4940995,'','6.1','1255',0.00,6720.00,'Sales from shift 257254 on 2022-04-04 11:00:42 ','2022-04-04 11:00:42','',''),('1','57',4940996,'','24','1236',60000.00,0.00,'Ago consultant 100','2022-03-11 00:00:00','',''),('1','57',4940997,'','supplier','76',0.00,60000.00,'Ago consultant 100','2022-03-13 00:00:00','',''),('1','57',4940998,'','24','1236',70000.00,0.00,'Ago consultant 100','2022-03-27 00:00:00','',''),('1','57',4940999,'','supplier','76',0.00,70000.00,'Ago consultant 100','2022-03-27 00:00:00','',''),('1','57',4941000,'','2','4067',21000.00,0.00,'Payment Id 399957 for invoice:257248, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-04 15:24:15','',''),('1','57',4941001,'','supplier','76',0.00,21000.00,'Payment Id 399957 for invoice:257248, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-04 15:24:15','',''),('1','57',4941002,'','2','4067',6995.00,0.00,'Payment Id 399956 for invoice:257247, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-04 15:24:15','',''),('1','57',4941003,'','supplier','76',0.00,6995.00,'Payment Id 399956 for invoice:257247, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-04 15:24:15','',''),('1','57',4941004,'','20','1253',64792.00,0.00,'Sales from shift 257255 on 2022-04-05 09:59:59 ','2022-04-05 09:59:59','',''),('1','57',4941005,'','6.1','1255',0.00,64792.00,'Sales from shift 257255 on 2022-04-05 09:59:59 ','2022-04-05 09:59:59','',''),('1','57',4941006,'','20','1253',34496.00,0.00,'Sales from shift 257256 on 2022-04-05 11:29:40 ','2022-04-05 11:29:40','',''),('1','57',4941007,'','6.1','1255',0.00,34496.00,'Sales from shift 257256 on 2022-04-05 11:29:40 ','2022-04-05 11:29:40','',''),('1','57',4941008,'','2','4067',5000.00,0.00,'Payment Id 399962 for invoice:257253, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-05 11:35:09','',''),('1','57',4941009,'','supplier','76',0.00,5000.00,'Payment Id 399962 for invoice:257253, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-05 11:35:09','',''),('1','57',4941010,'','2','4067',78405.00,0.00,'Payment Id 399960 for invoice:257251, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-05 11:35:32','',''),('1','57',4941011,'','supplier','76',0.00,78405.00,'Payment Id 399960 for invoice:257251, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-05 11:35:32','',''),('1','57',4941012,'','2','4067',9205.00,0.00,'Payment Id 399958 for invoice:257249, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-05 11:35:48','',''),('1','57',4941013,'','supplier','76',0.00,9205.00,'Payment Id 399958 for invoice:257249, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-05 11:35:48','',''),('1','57',4941014,'','2','4067',65420.00,0.00,'Payment Id 399959 for invoice:257250, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-05 11:37:24','',''),('1','57',4941015,'','supplier','76',0.00,65420.00,'Payment Id 399959 for invoice:257250, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-05 11:37:24','',''),('1','57',4941016,'','2','4067',1700180.00,0.00,'Payment Id 399961 for invoice:257252, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-05 11:37:37','',''),('1','57',4941017,'','supplier','76',0.00,1700180.00,'Payment Id 399961 for invoice:257252, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-05 11:37:37','',''),('1','57',4941018,'','2','4067',6720.00,0.00,'Payment Id 399963 for invoice:257254, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-05 11:37:47','',''),('1','57',4941019,'','supplier','76',0.00,6720.00,'Payment Id 399963 for invoice:257254, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-05 11:37:47','',''),('1','57',4941020,'','20','1253',42000.00,0.00,'Sales from shift 257257 on 2022-04-05 22:42:40 ','2022-04-05 22:42:40','',''),('1','57',4941021,'','6.1','1255',0.00,42000.00,'Sales from shift 257257 on 2022-04-05 22:42:40 ','2022-04-05 22:42:40','',''),('1','57',4941022,'','20','1253',0.00,0.00,'Sales from shift 257258 on 2022-04-06 09:21:10 ','2022-04-06 09:21:10','',''),('1','57',4941023,'','6.1','1255',0.00,0.00,'Sales from shift 257258 on 2022-04-06 09:21:10 ','2022-04-06 09:21:10','',''),('1','57',4941024,'','20','1253',30303.00,0.00,'Sales from shift 257259 on 2022-04-06 14:51:53 ','2022-04-06 14:51:53','',''),('1','57',4941025,'','6.1','1255',0.00,30303.00,'Sales from shift 257259 on 2022-04-06 14:51:53 ','2022-04-06 14:51:53','',''),('1','57',4941026,'','20','1253',18613.00,0.00,'Sales from shift 257260 on 2022-04-07 10:00:08 ','2022-04-07 10:00:08','',''),('1','57',4941027,'','6.1','1255',0.00,18613.00,'Sales from shift 257260 on 2022-04-07 10:00:08 ','2022-04-07 10:00:08','',''),('1','57',4941028,'','20','1253',840.00,0.00,'Sales from shift 257261 on 2022-04-07 11:15:29 ','2022-04-07 11:15:29','',''),('1','57',4941029,'','6.1','1255',0.00,840.00,'Sales from shift 257261 on 2022-04-07 11:15:29 ','2022-04-07 11:15:29','',''),('1','57',4941030,'','2','4067',30305.00,0.00,'Payment Id 399967 for invoice:257259, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-07 13:17:59','',''),('1','57',4941031,'','supplier','76',0.00,30305.00,'Payment Id 399967 for invoice:257259, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-07 13:17:59','',''),('1','57',4941032,'','2','4067',42000.00,0.00,'Payment Id 399966 for invoice:257257, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-07 13:17:59','',''),('1','57',4941033,'','supplier','76',0.00,42000.00,'Payment Id 399966 for invoice:257257, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-07 13:17:59','',''),('1','57',4941034,'','2','4067',64510.00,0.00,'Payment Id 399964 for invoice:257255, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-07 13:19:53','',''),('1','57',4941035,'','supplier','76',0.00,64510.00,'Payment Id 399964 for invoice:257255, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-07 13:19:53','',''),('1','57',4941036,'','2','4067',34490.00,0.00,'Payment Id 399965 for invoice:257256, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-07 13:20:29','',''),('1','57',4941037,'','supplier','76',0.00,34490.00,'Payment Id 399965 for invoice:257256, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-07 13:20:29','',''),('1','57',4941038,'','20','1253',0.00,0.00,'Sales from shift 257262 on 2022-04-08 10:07:49 ','2022-04-08 10:07:49','',''),('1','57',4941039,'','6.1','1255',0.00,0.00,'Sales from shift 257262 on 2022-04-08 10:07:49 ','2022-04-08 10:07:49','',''),('1','57',4941040,'','20','1253',2184.00,0.00,'Sales from shift 257263 on 2022-04-08 11:34:56 ','2022-04-08 11:34:56','',''),('1','57',4941041,'','6.1','1255',0.00,2184.00,'Sales from shift 257263 on 2022-04-08 11:34:56 ','2022-04-08 11:34:56','',''),('1','57',4941042,'','20','1253',0.00,0.00,'Sales from shift 257264 on 2022-04-09 12:25:55 ','2022-04-09 12:25:55','',''),('1','57',4941043,'','6.1','1255',0.00,0.00,'Sales from shift 257264 on 2022-04-09 12:25:55 ','2022-04-09 12:25:55','',''),('1','57',4941044,'','20','1253',86576.00,0.00,'Sales from shift 257265 on 2022-04-09 16:48:23 ','2022-04-09 16:48:23','',''),('1','57',4941045,'','6.1','1255',0.00,86576.00,'Sales from shift 257265 on 2022-04-09 16:48:23 ','2022-04-09 16:48:23','',''),('1','57',4941046,'','20','1253',0.00,0.00,'Sales from shift 257266 on 2022-04-11 09:52:15 ','2022-04-11 09:52:15','',''),('1','57',4941047,'','6.1','1255',0.00,0.00,'Sales from shift 257266 on 2022-04-11 09:52:15 ','2022-04-11 09:52:15','',''),('1','57',4941048,'','20','1253',9401.00,0.00,'Sales from shift 257267 on 2022-04-11 10:16:49 ','2022-04-11 10:16:49','',''),('1','57',4941049,'','6.1','1255',0.00,9401.00,'Sales from shift 257267 on 2022-04-11 10:16:49 ','2022-04-11 10:16:49','',''),('1','57',4941050,'','20','1253',0.00,0.00,'Sales from shift 257268 on 2022-04-11 10:21:24 ','2022-04-11 10:21:24','',''),('1','57',4941051,'','6.1','1255',0.00,0.00,'Sales from shift 257268 on 2022-04-11 10:21:24 ','2022-04-11 10:21:24','',''),('1','57',4941052,'','20','1253',590947.00,0.00,'Sales from shift 257269 on 2022-04-11 10:37:15 ','2022-04-11 10:37:15','',''),('1','57',4941053,'','6.1','1255',0.00,590947.00,'Sales from shift 257269 on 2022-04-11 10:37:15 ','2022-04-11 10:37:15','',''),('1','57',4941054,'','2','4067',9400.00,0.00,'Payment Id 399972 for invoice:257267, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-11 17:04:09','',''),('1','57',4941055,'','supplier','76',0.00,9400.00,'Payment Id 399972 for invoice:257267, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-11 17:04:09','',''),('1','57',4941056,'','2','4067',16575.00,0.00,'Payment Id 399971 for invoice:257265, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-11 17:04:09','',''),('1','57',4941057,'','supplier','76',0.00,16575.00,'Payment Id 399971 for invoice:257265, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-11 17:04:09','',''),('1','57',4941058,'','2','4067',840.00,0.00,'Payment Id 399969 for invoice:257261, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-11 17:05:09','',''),('1','57',4941059,'','supplier','76',0.00,840.00,'Payment Id 399969 for invoice:257261, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-11 17:05:09','',''),('1','57',4941060,'','2','4067',18615.00,0.00,'Payment Id 399968 for invoice:257260, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-11 17:05:29','',''),('1','57',4941061,'','supplier','76',0.00,18615.00,'Payment Id 399968 for invoice:257260, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-11 17:05:29','',''),('1','57',4941062,'','2','4067',2185.00,0.00,'Payment Id 399970 for invoice:257263, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-11 17:05:55','',''),('1','57',4941063,'','supplier','76',0.00,2185.00,'Payment Id 399970 for invoice:257263, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-11 17:05:55','',''),('1','57',4941064,'','20','1253',234500.00,0.00,'Sales from shift 257270 on 2022-04-12 09:28:51 ','2022-04-12 09:28:51','',''),('1','57',4941065,'','6.1','1255',0.00,234500.00,'Sales from shift 257270 on 2022-04-12 09:28:51 ','2022-04-12 09:28:51','',''),('1','57',4941066,'','20','1253',151998.00,0.00,'Sales from shift 257271 on 2022-04-12 10:55:57 ','2022-04-12 10:55:57','',''),('1','57',4941067,'','6.1','1255',0.00,151998.00,'Sales from shift 257271 on 2022-04-12 10:55:57 ','2022-04-12 10:55:57','',''),('1','57',4941068,'','2','4067',151998.00,0.00,'Payment Id 399975 for invoice:257271, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-12 16:25:14','',''),('1','57',4941069,'','supplier','76',0.00,151998.00,'Payment Id 399975 for invoice:257271, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-12 16:25:14','',''),('1','57',4941070,'','2','4067',590968.00,0.00,'Payment Id 399973 for invoice:257269, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-12 16:27:43','',''),('1','57',4941071,'','supplier','76',0.00,590968.00,'Payment Id 399973 for invoice:257269, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-12 16:27:43','',''),('1','57',4941072,'','2','4067',234500.00,0.00,'Payment Id 399974 for invoice:257270, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-12 16:40:08','',''),('1','57',4941073,'','supplier','76',0.00,234500.00,'Payment Id 399974 for invoice:257270, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-12 16:40:08','',''),('1','57',4941074,'','20','1253',377300.00,0.00,'Sales from shift 257272 on 2022-04-13 09:09:03 ','2022-04-13 09:09:03','',''),('1','57',4941075,'','6.1','1255',0.00,377300.00,'Sales from shift 257272 on 2022-04-13 09:09:03 ','2022-04-13 09:09:03','',''),('1','57',4941076,'','20','1253',382305.00,0.00,'Sales from shift 257273 on 2022-04-13 13:23:15 ','2022-04-13 13:23:15','',''),('1','57',4941077,'','6.1','1255',0.00,382305.00,'Sales from shift 257273 on 2022-04-13 13:23:15 ','2022-04-13 13:23:15','',''),('1','57',4941078,'','20','1253',0.00,0.00,'Sales from shift 257274 on 2022-04-14 10:30:49 ','2022-04-14 10:30:49','',''),('1','57',4941079,'','6.1','1255',0.00,0.00,'Sales from shift 257274 on 2022-04-14 10:30:49 ','2022-04-14 10:30:49','',''),('1','57',4941080,'','20','1253',3948.00,0.00,'Sales from shift 257275 on 2022-04-14 11:43:56 ','2022-04-14 11:43:56','',''),('1','57',4941081,'','6.1','1255',0.00,3948.00,'Sales from shift 257275 on 2022-04-14 11:43:56 ','2022-04-14 11:43:56','',''),('1','57',4941082,'','2','4067',377300.00,0.00,'Payment Id 399976 for invoice:257272, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-14 18:01:35','',''),('1','57',4941083,'','supplier','76',0.00,377300.00,'Payment Id 399976 for invoice:257272, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-14 18:01:35','',''),('1','57',4941084,'','20','1253',37737.00,0.00,'Sales from shift 257276 on 2022-04-14 18:03:27 ','2022-04-14 18:03:27','',''),('1','57',4941085,'','6.1','1255',0.00,37737.00,'Sales from shift 257276 on 2022-04-14 18:03:27 ','2022-04-14 18:03:27','',''),('1','57',4941086,'','20','1253',0.00,0.00,'Sales from shift 257277 on 2022-04-15 11:21:49 ','2022-04-15 11:21:49','',''),('1','57',4941087,'','6.1','1255',0.00,0.00,'Sales from shift 257277 on 2022-04-15 11:21:49 ','2022-04-15 11:21:49','',''),('1','57',4941088,'','2','4067',288550.00,0.00,'Payment Id 399979 for invoice:257275, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-15 14:37:04','',''),('1','57',4941089,'','supplier','76',0.00,288550.00,'Payment Id 399979 for invoice:257275, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-15 14:37:04','',''),('1','57',4941090,'','2','4067',3950.00,0.00,'Payment Id 399978 for invoice:257275, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-15 14:37:04','',''),('1','57',4941091,'','supplier','76',0.00,3950.00,'Payment Id 399978 for invoice:257275, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-15 14:37:04','',''),('1','57',4941092,'','2','4103',93800.00,0.00,'Payment Id 399981 for invoice:257277, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-15 14:39:30','',''),('1','57',4941093,'','supplier','76',0.00,93800.00,'Payment Id 399981 for invoice:257277, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-15 14:39:30','',''),('1','57',4941094,'','20','1253',3801.00,0.00,'Sales from shift 257278 on 2022-04-16 11:49:03 ','2022-04-16 11:49:03','',''),('1','57',4941095,'','6.1','1255',0.00,3801.00,'Sales from shift 257278 on 2022-04-16 11:49:03 ','2022-04-16 11:49:03','',''),('1','57',4941096,'','20','1253',88403.00,0.00,'Sales from shift 257279 on 2022-04-16 13:55:15 ','2022-04-16 13:55:15','',''),('1','57',4941097,'','6.1','1255',0.00,88403.00,'Sales from shift 257279 on 2022-04-16 13:55:15 ','2022-04-16 13:55:15','',''),('1','57',4941098,'','20','1253',2898.00,0.00,'Sales from shift 257280 on 2022-04-17 17:44:05 ','2022-04-17 17:44:05','',''),('1','57',4941099,'','6.1','1255',0.00,2898.00,'Sales from shift 257280 on 2022-04-17 17:44:05 ','2022-04-17 17:44:05','',''),('1','57',4941100,'','20','1253',708498.00,0.00,'Sales from shift 257281 on 2022-04-18 08:17:57 ','2022-04-18 08:17:57','',''),('1','57',4941101,'','6.1','1255',0.00,708498.00,'Sales from shift 257281 on 2022-04-18 08:17:57 ','2022-04-18 08:17:57','',''),('1','57',4941102,'','20','1253',688800.00,0.00,'Sales from shift 257282 on 2022-04-18 09:31:34 ','2022-04-18 09:31:34','',''),('1','57',4941103,'','6.1','1255',0.00,688800.00,'Sales from shift 257282 on 2022-04-18 09:31:34 ','2022-04-18 09:31:34','',''),('1','57',4941104,'','20','1253',2800.00,0.00,'Sales from shift 257283 on 2022-04-18 14:53:28 ','2022-04-18 14:53:28','',''),('1','57',4941105,'','6.1','1255',0.00,2800.00,'Sales from shift 257283 on 2022-04-18 14:53:28 ','2022-04-18 14:53:28','',''),('1','57',4941106,'','20','1253',0.00,0.00,'Sales from shift 257284 on 2022-04-19 21:09:55 ','2022-04-19 21:09:55','',''),('1','57',4941107,'','6.1','1255',0.00,0.00,'Sales from shift 257284 on 2022-04-19 21:09:55 ','2022-04-19 21:09:55','',''),('1','57',4941108,'','20','1253',43400.00,0.00,'Sales from shift 257285 on 2022-04-19 21:23:30 ','2022-04-19 21:23:30','',''),('1','57',4941109,'','6.1','1255',0.00,43400.00,'Sales from shift 257285 on 2022-04-19 21:23:30 ','2022-04-19 21:23:30','',''),('1','57',4941110,'','20','1253',140000.00,0.00,'Sales from shift 257286 on 2022-04-19 21:27:46 ','2022-04-19 21:27:46','',''),('1','57',4941111,'','6.1','1255',0.00,140000.00,'Sales from shift 257286 on 2022-04-19 21:27:46 ','2022-04-19 21:27:46','',''),('1','57',4941112,'','20','1253',239260.00,0.00,'Sales from shift 257287 on 2022-04-20 11:21:48 ','2022-04-20 11:21:48','',''),('1','57',4941113,'','6.1','1255',0.00,239260.00,'Sales from shift 257287 on 2022-04-20 11:21:48 ','2022-04-20 11:21:48','',''),('1','57',4941114,'','2','4067',43400.00,0.00,'Payment Id 399988 for invoice:257284, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-20 13:35:13','',''),('1','57',4941115,'','supplier','76',0.00,43400.00,'Payment Id 399988 for invoice:257284, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-20 13:35:13','',''),('1','57',4941116,'','2','4067',2800.00,0.00,'Payment Id 399987 for invoice:257283, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-20 13:35:13','',''),('1','57',4941117,'','supplier','76',0.00,2800.00,'Payment Id 399987 for invoice:257283, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-20 13:35:13','',''),('1','57',4941118,'','2','4067',227298.00,0.00,'Payment Id 399986 for invoice:257282, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-20 13:35:13','',''),('1','57',4941119,'','supplier','76',0.00,227298.00,'Payment Id 399986 for invoice:257282, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-20 13:35:13','',''),('1','57',4941120,'','2','4067',2898.00,0.00,'Payment Id 399984 for invoice:257280, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-20 13:35:13','',''),('1','57',4941121,'','supplier','76',0.00,2898.00,'Payment Id 399984 for invoice:257280, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-20 13:35:13','',''),('1','57',4941122,'','2','4067',88403.00,0.00,'Payment Id 399983 for invoice:257279, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-20 13:35:13','',''),('1','57',4941123,'','supplier','76',0.00,88403.00,'Payment Id 399983 for invoice:257279, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-20 13:35:13','',''),('1','57',4941124,'','2','4067',3800.00,0.00,'Payment Id 399982 for invoice:257278, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-20 13:35:13','',''),('1','57',4941125,'','supplier','76',0.00,3800.00,'Payment Id 399982 for invoice:257278, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-20 13:35:13','',''),('1','57',4941126,'','2','4067',37737.00,0.00,'Payment Id 399980 for invoice:257276, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-20 13:35:13','',''),('1','57',4941127,'','supplier','76',0.00,37737.00,'Payment Id 399980 for invoice:257276, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-20 13:35:13','',''),('1','57',4941128,'','20','1253',332500.00,0.00,'Sales from shift 257288 on 2022-04-21 04:50:49 ','2022-04-21 04:50:49','',''),('1','57',4941129,'','6.1','1255',0.00,332500.00,'Sales from shift 257288 on 2022-04-21 04:50:49 ','2022-04-21 04:50:49','',''),('1','57',4941130,'','20','1253',199466.75,0.00,'Sales from shift 257289 on 2022-04-21 12:44:39 ','2022-04-21 12:44:39','',''),('1','57',4941131,'','6.1','1255',0.00,199466.75,'Sales from shift 257289 on 2022-04-21 12:44:39 ','2022-04-21 12:44:39','',''),('1','57',4941132,'','2','4067',239260.00,0.00,'Payment Id 399990 for invoice:257287, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-21 17:08:22','',''),('1','57',4941133,'','supplier','76',0.00,239260.00,'Payment Id 399990 for invoice:257287, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-21 17:08:22','',''),('1','57',4941134,'','2','4067',140000.00,0.00,'Payment Id 399989 for invoice:257286, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-21 17:08:22','',''),('1','57',4941135,'','supplier','76',0.00,140000.00,'Payment Id 399989 for invoice:257286, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-21 17:08:22','',''),('1','57',4941136,'','2','4067',1100000.00,0.00,'Payment Id 399985 for invoice:257281, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-21 17:08:22','',''),('1','57',4941137,'','supplier','76',0.00,1100000.00,'Payment Id 399985 for invoice:257281, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-21 17:08:22','',''),('1','57',4941138,'','20','1253',493928.75,0.00,'Sales from shift 257290 on 2022-04-22 10:32:52 ','2022-04-22 10:32:52','',''),('1','57',4941139,'','6.1','1255',0.00,493928.75,'Sales from shift 257290 on 2022-04-22 10:32:52 ','2022-04-22 10:32:52','',''),('1','57',4941140,'','2','4067',199466.00,0.00,'Payment Id 399992 for invoice:257289, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-22 13:47:01','',''),('1','57',4941141,'','supplier','76',0.00,199466.00,'Payment Id 399992 for invoice:257289, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-22 13:47:01','',''),('1','57',4941142,'','2','4067',332500.00,0.00,'Payment Id 399991 for invoice:257288, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-22 13:47:01','',''),('1','57',4941143,'','supplier','76',0.00,332500.00,'Payment Id 399991 for invoice:257288, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-22 13:47:01','',''),('1','57',4941144,'','20','1253',954667.35,0.00,'Sales from shift 257291 on 2022-04-22 15:42:31 ','2022-04-22 15:42:31','',''),('1','57',4941145,'','6.1','1255',0.00,954667.35,'Sales from shift 257291 on 2022-04-22 15:42:31 ','2022-04-22 15:42:31','',''),('1','57',4941146,'','20','1253',368443.25,0.00,'Sales from shift 257292 on 2022-04-23 08:21:31 ','2022-04-23 08:21:31','',''),('1','57',4941147,'','6.1','1255',0.00,368443.25,'Sales from shift 257292 on 2022-04-23 08:21:31 ','2022-04-23 08:21:31','',''),('1','57',4941148,'','20','1253',320503.40,0.00,'Sales from shift 257293 on 2022-04-23 12:08:58 ','2022-04-23 12:08:58','',''),('1','57',4941149,'','6.1','1255',0.00,320503.40,'Sales from shift 257293 on 2022-04-23 12:08:58 ','2022-04-23 12:08:58','',''),('1','57',4941150,'','2','4067',493983.00,0.00,'Payment Id 399993 for invoice:257290, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-23 12:11:24','',''),('1','57',4941151,'','supplier','76',0.00,493983.00,'Payment Id 399993 for invoice:257290, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-23 12:11:24','',''),('1','57',4941152,'','2','4067',954667.00,0.00,'Payment Id 399994 for invoice:257291, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-23 12:11:59','',''),('1','57',4941153,'','supplier','76',0.00,954667.00,'Payment Id 399994 for invoice:257291, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-23 12:11:59','',''),('1','57',4941154,'','20','1253',0.00,0.00,'Sales from shift 257294 on 2022-04-24 16:50:59 ','2022-04-24 16:50:59','',''),('1','57',4941155,'','6.1','1255',0.00,0.00,'Sales from shift 257294 on 2022-04-24 16:50:59 ','2022-04-24 16:50:59','',''),('1','57',4941156,'','20','1253',245398.30,0.00,'Sales from shift 257295 on 2022-04-24 21:22:11 ','2022-04-24 21:22:11','',''),('1','57',4941157,'','6.1','1255',0.00,245398.30,'Sales from shift 257295 on 2022-04-24 21:22:11 ','2022-04-24 21:22:11','',''),('1','57',4941158,'','20','1253',0.00,0.00,'Sales from shift 257296 on 2022-04-25 11:26:07 ','2022-04-25 11:26:07','',''),('1','57',4941159,'','6.1','1255',0.00,0.00,'Sales from shift 257296 on 2022-04-25 11:26:07 ','2022-04-25 11:26:07','',''),('1','57',4941160,'','20','1253',568189.30,0.00,'Sales from shift 257297 on 2022-04-25 20:57:31 ','2022-04-25 20:57:31','',''),('1','57',4941161,'','6.1','1255',0.00,568189.30,'Sales from shift 257297 on 2022-04-25 20:57:31 ','2022-04-25 20:57:31','',''),('1','57',4941162,'','20','1253',581123.55,0.00,'Sales from shift 257298 on 2022-04-25 22:42:15 ','2022-04-25 22:42:15','',''),('1','57',4941163,'','6.1','1255',0.00,581123.55,'Sales from shift 257298 on 2022-04-25 22:42:15 ','2022-04-25 22:42:15','',''),('1','57',4941164,'','20','1253',305574.15,0.00,'Sales from shift 257299 on 2022-04-26 10:34:01 ','2022-04-26 10:34:01','',''),('1','57',4941165,'','6.1','1255',0.00,305574.15,'Sales from shift 257299 on 2022-04-26 10:34:01 ','2022-04-26 10:34:01','',''),('1','57',4941166,'','2','4067',245398.00,0.00,'Payment Id 399997 for invoice:257295, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-26 11:24:32','',''),('1','57',4941167,'','supplier','76',0.00,245398.00,'Payment Id 399997 for invoice:257295, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-26 11:24:32','',''),('1','57',4941168,'','2','4067',320505.00,0.00,'Payment Id 399996 for invoice:257293, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-26 11:24:50','',''),('1','57',4941169,'','supplier','76',0.00,320505.00,'Payment Id 399996 for invoice:257293, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-26 11:24:50','',''),('1','57',4941170,'','2','4067',368445.00,0.00,'Payment Id 399995 for invoice:257292, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-26 11:25:13','',''),('1','57',4941171,'','supplier','76',0.00,368445.00,'Payment Id 399995 for invoice:257292, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-26 11:25:13','',''),('1','57',4941172,'','2','4067',200000.00,0.00,'Payment Id 400001 for invoice:257300, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-27 12:10:36','',''),('1','57',4941173,'','supplier','76',0.00,200000.00,'Payment Id 400001 for invoice:257300, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-27 12:10:36','',''),('1','57',4941174,'','2','4067',514623.00,0.00,'Payment Id 399999 for invoice:257298, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-27 12:10:36','',''),('1','57',4941175,'','supplier','76',0.00,514623.00,'Payment Id 399999 for invoice:257298, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-27 12:10:36','',''),('1','57',4941176,'','2','4067',568189.00,0.00,'Payment Id 399998 for invoice:257297, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-27 12:10:36','',''),('1','57',4941177,'','supplier','76',0.00,568189.00,'Payment Id 399998 for invoice:257297, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-27 12:10:36','',''),('1','57',4941178,'','2','4067',105570.00,0.00,'Payment Id 400000 for invoice:257299, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-28 10:48:32','',''),('1','57',4941179,'','supplier','76',0.00,105570.00,'Payment Id 400000 for invoice:257299, receipt: oo by A.A RANO NIGERIA LIMITED','2022-04-28 10:48:32','',''),('1','57',4941180,'','24','1235',0.00,11600000.00,'Purchase Id 89904 for 14,500.00 litters of Diesel - AGO from A.A RANO NIGERIA LIMITED','2022-09-02 17:53:37','',''),('1','57',4941181,'','supplier','76',11600000.00,0.00,'Purchase Id 89904 for 14,500.00 litters of Diesel - AGO from A.A RANO NIGERIA LIMITED','2022-09-02 17:53:37','',''),('1','57',4941182,'','20','1253',0.00,0.00,'Sales from shift 257300 on 2022-09-02 17:55:05 ','2022-09-02 17:55:05','',''),('1','57',4941183,'','6.1','1255',0.00,0.00,'Sales from shift 257300 on 2022-09-02 17:55:05 ','2022-09-02 17:55:05','',''),('1','57',4941184,'','20','1253',134192.00,0.00,'Sales from shift 257301 on 2022-09-03 14:02:17 ','2022-09-03 14:02:17','',''),('1','57',4941185,'','6.1','1255',0.00,134192.00,'Sales from shift 257301 on 2022-09-03 14:02:17 ','2022-09-03 14:02:17','',''),('1','57',4941186,'','20','1253',482984.00,0.00,'Sales from shift 257302 on 2022-09-03 20:21:34 ','2022-09-03 20:21:34','',''),('1','57',4941187,'','6.1','1255',0.00,482984.00,'Sales from shift 257302 on 2022-09-03 20:21:34 ','2022-09-03 20:21:34','',''),('1','57',4941188,'','20','1253',0.00,0.00,'Sales from shift 257303 on 2022-09-04 05:49:40 ','2022-09-04 05:49:40','',''),('1','57',4941189,'','6.1','1255',0.00,0.00,'Sales from shift 257303 on 2022-09-04 05:49:40 ','2022-09-04 05:49:40','',''),('1','57',4941190,'','24','1235',0.00,7647500.00,'Purchase Id 89905 for 40,250.00 litters of Petrol - PMS from A.A RANO NIGERIA LIMITED','2022-09-04 15:41:50','',''),('1','57',4941191,'','supplier','76',7647500.00,0.00,'Purchase Id 89905 for 40,250.00 litters of Petrol - PMS from A.A RANO NIGERIA LIMITED','2022-09-04 15:41:50','',''),('1','57',4941192,'','20','1253',57597.95,0.00,'Sales from shift 257304 on 2022-09-05 09:43:17 ','2022-09-05 09:43:17','',''),('1','57',4941193,'','6.1','1255',0.00,57597.95,'Sales from shift 257304 on 2022-09-05 09:43:17 ','2022-09-05 09:43:17','',''),('1','57',4941194,'','20','1253',127300.20,0.00,'Sales from shift 257305 on 2022-09-05 21:28:33 ','2022-09-05 21:28:33','',''),('1','57',4941195,'','6.1','1255',0.00,127300.20,'Sales from shift 257305 on 2022-09-05 21:28:33 ','2022-09-05 21:28:33','',''),('1','57',4941196,'','20','1253',112156.60,0.00,'Sales from shift 257306 on 2022-09-06 12:42:21 ','2022-09-06 12:42:21','',''),('1','57',4941197,'','6.1','1255',0.00,112156.60,'Sales from shift 257306 on 2022-09-06 12:42:21 ','2022-09-06 12:42:21','',''),('1','57',4941198,'','20','1253',609361.20,0.00,'Sales from shift 257307 on 2022-09-06 16:02:26 ','2022-09-06 16:02:26','',''),('1','57',4941199,'','6.1','1255',0.00,609361.20,'Sales from shift 257307 on 2022-09-06 16:02:26 ','2022-09-06 16:02:26','',''),('1','57',4941200,'','2','4067',609360.00,0.00,'Payment Id 400008 for invoice:257307, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-07 10:53:20','',''),('1','57',4941201,'','supplier','76',0.00,609360.00,'Payment Id 400008 for invoice:257307, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-07 10:53:20','',''),('1','57',4941202,'','2','4067',127300.00,0.00,'Payment Id 400007 for invoice:257305, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-07 10:53:20','',''),('1','57',4941203,'','supplier','76',0.00,127300.00,'Payment Id 400007 for invoice:257305, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-07 10:53:20','',''),('1','57',4941204,'','2','4067',57597.00,0.00,'Payment Id 400006 for invoice:257304, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-07 10:53:20','',''),('1','57',4941205,'','supplier','76',0.00,57597.00,'Payment Id 400006 for invoice:257304, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-07 10:53:20','',''),('1','57',4941206,'','2','4067',402985.00,0.00,'Payment Id 400005 for invoice:257302, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-07 10:53:20','',''),('1','57',4941207,'','supplier','76',0.00,402985.00,'Payment Id 400005 for invoice:257302, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-07 10:53:20','',''),('1','57',4941208,'','2','4067',134190.00,0.00,'Payment Id 400003 for invoice:257301, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-07 10:53:20','',''),('1','57',4941209,'','supplier','76',0.00,134190.00,'Payment Id 400003 for invoice:257301, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-07 10:53:20','',''),('1','57',4941210,'','20','1253',564177.10,0.00,'Sales from shift 257308 on 2022-09-07 15:51:36 ','2022-09-07 15:51:36','',''),('1','57',4941211,'','6.1','1255',0.00,564177.10,'Sales from shift 257308 on 2022-09-07 15:51:36 ','2022-09-07 15:51:36','',''),('1','57',4941212,'','20','1253',93111.40,0.00,'Sales from shift 257309 on 2022-09-08 13:07:31 ','2022-09-08 13:07:31','',''),('1','57',4941213,'','6.1','1255',0.00,93111.40,'Sales from shift 257309 on 2022-09-08 13:07:31 ','2022-09-08 13:07:31','',''),('1','57',4941214,'','20','1253',100891.70,0.00,'Sales from shift 257310 on 2022-09-08 14:23:01 ','2022-09-08 14:23:01','',''),('1','57',4941215,'','6.1','1255',0.00,100891.70,'Sales from shift 257310 on 2022-09-08 14:23:01 ','2022-09-08 14:23:01','',''),('1','57',4941216,'','20','1253',620517.30,0.00,'Sales from shift 257311 on 2022-09-08 17:45:21 ','2022-09-08 17:45:21','',''),('1','57',4941217,'','6.1','1255',0.00,620517.30,'Sales from shift 257311 on 2022-09-08 17:45:21 ','2022-09-08 17:45:21','',''),('1','57',4941218,'','2','4067',100890.00,0.00,'Payment Id 400012 for invoice:257310, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-09 12:52:38','',''),('1','57',4941219,'','supplier','76',0.00,100890.00,'Payment Id 400012 for invoice:257310, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-09 12:52:38','',''),('1','57',4941220,'','2','4067',112155.00,0.00,'Payment Id 400011 for invoice:257309, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-09 12:52:38','',''),('1','57',4941221,'','supplier','76',0.00,112155.00,'Payment Id 400011 for invoice:257309, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-09 12:52:38','',''),('1','57',4941222,'','2','4067',93111.40,0.00,'Payment Id 400010 for invoice:257309, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-09 12:52:38','',''),('1','57',4941223,'','supplier','76',0.00,93111.40,'Payment Id 400010 for invoice:257309, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-09 12:52:38','',''),('1','57',4941224,'','2','4067',564177.00,0.00,'Payment Id 400009 for invoice:257308, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-09 12:52:38','',''),('1','57',4941225,'','supplier','76',0.00,564177.00,'Payment Id 400009 for invoice:257308, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-09 12:52:38','',''),('1','57',4941226,'','20','1253',438508.40,0.00,'Sales from shift 257312 on 2022-09-09 17:31:23 ','2022-09-09 17:31:23','',''),('1','57',4941227,'','6.1','1255',0.00,438508.40,'Sales from shift 257312 on 2022-09-09 17:31:23 ','2022-09-09 17:31:23','',''),('1','57',4941228,'','20','1253',566731.50,0.00,'Sales from shift 257313 on 2022-09-10 07:30:41 ','2022-09-10 07:30:41','',''),('1','57',4941229,'','6.1','1255',0.00,566731.50,'Sales from shift 257313 on 2022-09-10 07:30:41 ','2022-09-10 07:30:41','',''),('1','57',4941230,'','20','1253',40223.10,0.00,'Sales from shift 257314 on 2022-09-10 15:05:41 ','2022-09-10 15:05:41','',''),('1','57',4941231,'','6.1','1255',0.00,40223.10,'Sales from shift 257314 on 2022-09-10 15:05:41 ','2022-09-10 15:05:41','',''),('1','57',4941232,'','20','1253',595553.30,0.00,'Sales from shift 257315 on 2022-09-10 22:19:29 ','2022-09-10 22:19:29','',''),('1','57',4941233,'','6.1','1255',0.00,595553.30,'Sales from shift 257315 on 2022-09-10 22:19:29 ','2022-09-10 22:19:29','',''),('1','57',4941234,'','20','1253',832749.90,0.00,'Sales from shift 257316 on 2022-09-11 12:30:40 ','2022-09-11 12:30:40','',''),('1','57',4941235,'','6.1','1255',0.00,832749.90,'Sales from shift 257316 on 2022-09-11 12:30:40 ','2022-09-11 12:30:40','',''),('1','57',4941236,'','20','1253',133739.20,0.00,'Sales from shift 257317 on 2022-09-11 19:59:54 ','2022-09-11 19:59:54','',''),('1','57',4941237,'','6.1','1255',0.00,133739.20,'Sales from shift 257317 on 2022-09-11 19:59:54 ','2022-09-11 19:59:54','',''),('1','57',4941238,'','20','1253',158297.10,0.00,'Sales from shift 257318 on 2022-09-12 08:13:44 ','2022-09-12 08:13:44','',''),('1','57',4941239,'','6.1','1255',0.00,158297.10,'Sales from shift 257318 on 2022-09-12 08:13:44 ','2022-09-12 08:13:44','',''),('1','57',4941240,'','20','1253',725377.80,0.00,'Sales from shift 257319 on 2022-09-12 11:50:07 ','2022-09-12 11:50:07','',''),('1','57',4941241,'','6.1','1255',0.00,725377.80,'Sales from shift 257319 on 2022-09-12 11:50:07 ','2022-09-12 11:50:07','',''),('1','57',4941242,'','20','1253',227011.50,0.00,'Sales from shift 257320 on 2022-09-13 11:56:19 ','2022-09-13 11:56:19','',''),('1','57',4941243,'','6.1','1255',0.00,227011.50,'Sales from shift 257320 on 2022-09-13 11:56:19 ','2022-09-13 11:56:19','',''),('1','57',4941244,'','20','1253',472237.80,0.00,'Sales from shift 257321 on 2022-09-13 14:28:05 ','2022-09-13 14:28:05','',''),('1','57',4941245,'','6.1','1255',0.00,472237.80,'Sales from shift 257321 on 2022-09-13 14:28:05 ','2022-09-13 14:28:05','',''),('1','57',4941246,'','2','4067',158297.00,0.00,'Payment Id 400020 for invoice:257318, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-13 14:58:27','',''),('1','57',4941247,'','supplier','76',0.00,158297.00,'Payment Id 400020 for invoice:257318, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-13 14:58:27','',''),('1','57',4941248,'','2','4067',133739.10,0.00,'Payment Id 400019 for invoice:257317, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-13 14:58:27','',''),('1','57',4941249,'','supplier','76',0.00,133739.10,'Payment Id 400019 for invoice:257317, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-13 14:58:27','',''),('1','57',4941250,'','2','4067',595553.30,0.00,'Payment Id 400017 for invoice:257315, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-13 14:58:27','',''),('1','57',4941251,'','supplier','76',0.00,595553.30,'Payment Id 400017 for invoice:257315, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-13 14:58:27','',''),('1','57',4941252,'','2','4067',40223.00,0.00,'Payment Id 400016 for invoice:257314, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-13 14:58:27','',''),('1','57',4941253,'','supplier','76',0.00,40223.00,'Payment Id 400016 for invoice:257314, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-13 14:58:27','',''),('1','57',4941254,'','2','4067',566794.00,0.00,'Payment Id 400015 for invoice:257313, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-13 14:58:27','',''),('1','57',4941255,'','supplier','76',0.00,566794.00,'Payment Id 400015 for invoice:257313, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-13 14:58:27','',''),('1','57',4941256,'','2','4103',438505.00,0.00,'Payment Id 400014 for invoice:257312, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-13 15:05:12','',''),('1','57',4941257,'','supplier','76',0.00,438505.00,'Payment Id 400014 for invoice:257312, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-13 15:05:12','',''),('1','57',4941258,'','2','4067',832749.90,0.00,'Payment Id 400018 for invoice:257316, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-13 15:09:27','',''),('1','57',4941259,'','supplier','76',0.00,832749.90,'Payment Id 400018 for invoice:257316, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-13 15:09:27','',''),('1','57',4941260,'','2','4067',620520.00,0.00,'Payment Id 400013 for invoice:257312, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-13 15:09:27','',''),('1','57',4941261,'','supplier','76',0.00,620520.00,'Payment Id 400013 for invoice:257312, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-13 15:09:27','',''),('1','57',4941262,'','20','1253',155801.40,0.00,'Sales from shift 257322 on 2022-09-14 11:23:58 ','2022-09-14 11:23:58','',''),('1','57',4941263,'','6.1','1255',0.00,155801.40,'Sales from shift 257322 on 2022-09-14 11:23:58 ','2022-09-14 11:23:58','',''),('1','57',4941264,'','20','1253',444798.90,0.00,'Sales from shift 257323 on 2022-09-14 16:20:03 ','2022-09-14 16:20:03','',''),('1','57',4941265,'','6.1','1255',0.00,444798.90,'Sales from shift 257323 on 2022-09-14 16:20:03 ','2022-09-14 16:20:03','',''),('1','57',4941266,'','2','4067',146701.00,0.00,'Payment Id 400022 for invoice:257320, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-14 16:39:37','',''),('1','57',4941267,'','supplier','76',0.00,146701.00,'Payment Id 400022 for invoice:257320, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-14 16:39:37','',''),('1','57',4941268,'','2','4067',725377.80,0.00,'Payment Id 400021 for invoice:257319, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-14 16:39:37','',''),('1','57',4941269,'','supplier','76',0.00,725377.80,'Payment Id 400021 for invoice:257319, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-14 16:39:37','',''),('1','57',4941270,'','2','4067',155801.00,0.00,'Payment Id 400025 for invoice:257322, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-14 16:45:09','',''),('1','57',4941271,'','supplier','76',0.00,155801.00,'Payment Id 400025 for invoice:257322, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-14 16:45:09','',''),('1','57',4941272,'','6.1','1255',80000.00,0.00,'Payment Id 400024 for invoice:257322, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-14 16:45:43','',''),('1','57',4941273,'','supplier','76',0.00,80000.00,'Payment Id 400024 for invoice:257322, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-14 16:45:43','',''),('1','57',4941274,'','20','1253',104278.90,0.00,'Sales from shift 257324 on 2022-09-15 11:54:11 ','2022-09-15 11:54:11','',''),('1','57',4941275,'','6.1','1255',0.00,104278.90,'Sales from shift 257324 on 2022-09-15 11:54:11 ','2022-09-15 11:54:11','',''),('1','57',4941276,'','2','4103',152240.00,0.00,'Payment Id 400027 for invoice:257323, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-15 16:23:04','',''),('1','57',4941277,'','supplier','76',0.00,152240.00,'Payment Id 400027 for invoice:257323, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-15 16:23:04','',''),('1','57',4941278,'','2','4067',320000.00,0.00,'Payment Id 400029 for invoice:257324, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-15 16:28:51','',''),('1','57',4941279,'','supplier','76',0.00,320000.00,'Payment Id 400029 for invoice:257324, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-15 16:28:51','',''),('1','57',4941280,'','2','4067',104278.90,0.00,'Payment Id 400028 for invoice:257324, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-15 16:28:51','',''),('1','57',4941281,'','supplier','76',0.00,104278.90,'Payment Id 400028 for invoice:257324, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-15 16:28:51','',''),('1','57',4941282,'','20','1253',290667.30,0.00,'Sales from shift 257325 on 2022-09-15 16:48:25 ','2022-09-15 16:48:25','',''),('1','57',4941283,'','6.1','1255',0.00,290667.30,'Sales from shift 257325 on 2022-09-15 16:48:25 ','2022-09-15 16:48:25','',''),('1','57',4941284,'','20','1253',246912.90,0.00,'Sales from shift 257326 on 2022-09-16 12:53:37 ','2022-09-16 12:53:37','',''),('1','57',4941285,'','6.1','1255',0.00,246912.90,'Sales from shift 257326 on 2022-09-16 12:53:37 ','2022-09-16 12:53:37','',''),('1','57',4941286,'','2','4103',440000.00,0.00,'Payment Id 400026 for invoice:257323, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-16 12:54:03','',''),('1','57',4941287,'','supplier','76',0.00,440000.00,'Payment Id 400026 for invoice:257323, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-16 12:54:03','',''),('1','57',4941288,'','20','1253',88506.10,0.00,'Sales from shift 257327 on 2022-09-16 15:18:06 ','2022-09-16 15:18:06','',''),('1','57',4941289,'','6.1','1255',0.00,88506.10,'Sales from shift 257327 on 2022-09-16 15:18:06 ','2022-09-16 15:18:06','',''),('1','57',4941290,'','2','4067',4798.00,0.00,'Payment Id 400033 for invoice:257326, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-16 15:39:52','',''),('1','57',4941291,'','supplier','76',0.00,4798.00,'Payment Id 400033 for invoice:257326, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-16 15:39:52','',''),('1','57',4941292,'','2','4067',290667.00,0.00,'Payment Id 400030 for invoice:257325, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-16 15:39:52','',''),('1','57',4941293,'','supplier','76',0.00,290667.00,'Payment Id 400030 for invoice:257325, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-16 15:39:52','',''),('1','57',4941294,'','20','1253',560524.80,0.00,'Sales from shift 257328 on 2022-09-17 12:05:32 ','2022-09-17 12:05:32','',''),('1','57',4941295,'','6.1','1255',0.00,560524.80,'Sales from shift 257328 on 2022-09-17 12:05:32 ','2022-09-17 12:05:32','',''),('1','57',4941296,'','20','1253',507181.30,0.00,'Sales from shift 257329 on 2022-09-18 08:23:02 ','2022-09-18 08:23:02','',''),('1','57',4941297,'','6.1','1255',0.00,507181.30,'Sales from shift 257329 on 2022-09-18 08:23:02 ','2022-09-18 08:23:02','',''),('1','57',4941298,'','20','1253',535177.10,0.00,'Sales from shift 257330 on 2022-09-18 09:35:31 ','2022-09-18 09:35:31','',''),('1','57',4941299,'','6.1','1255',0.00,535177.10,'Sales from shift 257330 on 2022-09-18 09:35:31 ','2022-09-18 09:35:31','',''),('1','57',4941300,'','20','1253',569172.00,0.00,'Sales from shift 257331 on 2022-09-19 08:05:29 ','2022-09-19 08:05:29','',''),('1','57',4941301,'','6.1','1255',0.00,569172.00,'Sales from shift 257331 on 2022-09-19 08:05:29 ','2022-09-19 08:05:29','',''),('1','57',4941302,'','20','1253',337056.90,0.00,'Sales from shift 257332 on 2022-09-19 12:02:56 ','2022-09-19 12:02:56','',''),('1','57',4941303,'','6.1','1255',0.00,337056.90,'Sales from shift 257332 on 2022-09-19 12:02:56 ','2022-09-19 12:02:56','',''),('1','57',4941304,'','20','1253',61758.30,0.00,'Sales from shift 257333 on 2022-09-19 12:13:26 ','2022-09-19 12:13:26','',''),('1','57',4941305,'','6.1','1255',0.00,61758.30,'Sales from shift 257333 on 2022-09-19 12:13:26 ','2022-09-19 12:13:26','',''),('1','57',4941306,'','20','1253',541686.50,0.00,'Sales from shift 257334 on 2022-09-20 00:06:14 ','2022-09-20 00:06:14','',''),('1','57',4941307,'','6.1','1255',0.00,541686.50,'Sales from shift 257334 on 2022-09-20 00:06:14 ','2022-09-20 00:06:14','',''),('1','57',4941308,'','20','1253',112303.50,0.00,'Sales from shift 257335 on 2022-09-20 09:48:27 ','2022-09-20 09:48:27','',''),('1','57',4941309,'','6.1','1255',0.00,112303.50,'Sales from shift 257335 on 2022-09-20 09:48:27 ','2022-09-20 09:48:27','',''),('1','57',4941310,'','2','4067',112303.00,0.00,'Payment Id 400042 for invoice:257335, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-20 13:32:41','',''),('1','57',4941311,'','supplier','76',0.00,112303.00,'Payment Id 400042 for invoice:257335, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-20 13:32:41','',''),('1','57',4941312,'','2','4067',61758.00,0.00,'Payment Id 400040 for invoice:257333, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-20 13:32:41','',''),('1','57',4941313,'','supplier','76',0.00,61758.00,'Payment Id 400040 for invoice:257333, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-20 13:32:41','',''),('1','57',4941314,'','2','4067',337056.00,0.00,'Payment Id 400039 for invoice:257332, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-20 13:32:41','',''),('1','57',4941315,'','supplier','76',0.00,337056.00,'Payment Id 400039 for invoice:257332, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-20 13:32:41','',''),('1','57',4941316,'','2','4067',569172.00,0.00,'Payment Id 400038 for invoice:257331, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-20 13:32:41','',''),('1','57',4941317,'','supplier','76',0.00,569172.00,'Payment Id 400038 for invoice:257331, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-20 13:32:41','',''),('1','57',4941318,'','2','4067',535177.00,0.00,'Payment Id 400037 for invoice:257330, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-20 13:32:41','',''),('1','57',4941319,'','supplier','76',0.00,535177.00,'Payment Id 400037 for invoice:257330, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-20 13:32:41','',''),('1','57',4941320,'','2','4067',88506.00,0.00,'Payment Id 400034 for invoice:257327, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-20 13:40:33','',''),('1','57',4941321,'','supplier','76',0.00,88506.00,'Payment Id 400034 for invoice:257327, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-20 13:40:33','',''),('1','57',4941322,'','2','4067',507181.00,0.00,'Payment Id 400036 for invoice:257329, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-20 13:50:14','',''),('1','57',4941323,'','supplier','76',0.00,507181.00,'Payment Id 400036 for invoice:257329, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-20 13:50:14','',''),('1','57',4941324,'','2','4067',560524.00,0.00,'Payment Id 400035 for invoice:257328, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-20 13:50:14','',''),('1','57',4941325,'','supplier','76',0.00,560524.00,'Payment Id 400035 for invoice:257328, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-20 13:50:14','',''),('1','57',4941326,'','2','4067',246912.00,0.00,'Payment Id 400031 for invoice:257326, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-20 13:51:51','',''),('1','57',4941327,'','supplier','76',0.00,246912.00,'Payment Id 400031 for invoice:257326, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-20 13:51:51','',''),('1','57',4941328,'','20','1253',244123.40,0.00,'Sales from shift 257336 on 2022-09-21 10:19:52 ','2022-09-21 10:19:52','',''),('1','57',4941329,'','6.1','1255',0.00,244123.40,'Sales from shift 257336 on 2022-09-21 10:19:52 ','2022-09-21 10:19:52','',''),('1','57',4941330,'','20','1253',120662.60,0.00,'Sales from shift 257337 on 2022-09-21 11:12:05 ','2022-09-21 11:12:05','',''),('1','57',4941331,'','6.1','1255',0.00,120662.60,'Sales from shift 257337 on 2022-09-21 11:12:05 ','2022-09-21 11:12:05','',''),('1','57',4941332,'','20','1253',274606.20,0.00,'Sales from shift 257338 on 2022-09-22 11:29:43 ','2022-09-22 11:29:43','',''),('1','57',4941333,'','6.1','1255',0.00,274606.20,'Sales from shift 257338 on 2022-09-22 11:29:43 ','2022-09-22 11:29:43','',''),('1','57',4941334,'','20','1253',506668.80,0.00,'Sales from shift 257339 on 2022-09-22 12:00:19 ','2022-09-22 12:00:19','',''),('1','57',4941335,'','6.1','1255',0.00,506668.80,'Sales from shift 257339 on 2022-09-22 12:00:19 ','2022-09-22 12:00:19','',''),('1','57',4941336,'','2','4103',120660.00,0.00,'Payment Id 400044 for invoice:257337, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-22 13:26:59','',''),('1','57',4941337,'','supplier','76',0.00,120660.00,'Payment Id 400044 for invoice:257337, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-22 13:26:59','',''),('1','57',4941338,'','2','4067',541685.00,0.00,'Payment Id 400041 for invoice:257334, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-22 13:30:18','',''),('1','57',4941339,'','supplier','76',0.00,541685.00,'Payment Id 400041 for invoice:257334, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-22 13:30:18','',''),('1','57',4941340,'','20','1253',452836.70,0.00,'Sales from shift 257340 on 2022-09-23 11:07:41 ','2022-09-23 11:07:41','',''),('1','57',4941341,'','6.1','1255',0.00,452836.70,'Sales from shift 257340 on 2022-09-23 11:07:41 ','2022-09-23 11:07:41','',''),('1','57',4941342,'','20','1253',419247.60,0.00,'Sales from shift 257341 on 2022-09-23 11:45:14 ','2022-09-23 11:45:14','',''),('1','57',4941343,'','6.1','1255',0.00,419247.60,'Sales from shift 257341 on 2022-09-23 11:45:14 ','2022-09-23 11:45:14','',''),('1','57',4941344,'','2','4067',506668.00,0.00,'Payment Id 400046 for invoice:257339, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-23 15:28:23','',''),('1','57',4941345,'','supplier','76',0.00,506668.00,'Payment Id 400046 for invoice:257339, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-23 15:28:23','',''),('1','57',4941346,'','2','4067',274606.00,0.00,'Payment Id 400045 for invoice:257338, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-23 15:28:23','',''),('1','57',4941347,'','supplier','76',0.00,274606.00,'Payment Id 400045 for invoice:257338, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-23 15:28:23','',''),('1','57',4941348,'','2','4067',244123.00,0.00,'Payment Id 400043 for invoice:257336, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-23 15:28:23','',''),('1','57',4941349,'','supplier','76',0.00,244123.00,'Payment Id 400043 for invoice:257336, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-23 15:28:23','',''),('1','57',4941350,'','2','4103',419250.00,0.00,'Payment Id 400048 for invoice:257341, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-23 15:57:34','',''),('1','57',4941351,'','supplier','76',0.00,419250.00,'Payment Id 400048 for invoice:257341, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-23 15:57:34','',''),('1','57',4941352,'','20','1253',309502.70,0.00,'Sales from shift 257342 on 2022-09-24 21:45:49 ','2022-09-24 21:45:49','',''),('1','57',4941353,'','6.1','1255',0.00,309502.70,'Sales from shift 257342 on 2022-09-24 21:45:49 ','2022-09-24 21:45:49','',''),('1','57',4941354,'','20','1253',390816.80,0.00,'Sales from shift 257343 on 2022-09-25 10:20:59 ','2022-09-25 10:20:59','',''),('1','57',4941355,'','6.1','1255',0.00,390816.80,'Sales from shift 257343 on 2022-09-25 10:20:59 ','2022-09-25 10:20:59','',''),('1','57',4941356,'','20','1253',0.00,0.00,'Sales from shift 257344 on 2022-09-25 12:50:05 ','2022-09-25 12:50:05','',''),('1','57',4941357,'','6.1','1255',0.00,0.00,'Sales from shift 257344 on 2022-09-25 12:50:05 ','2022-09-25 12:50:05','',''),('1','57',4941358,'','20','1253',0.00,0.00,'Sales from shift 257345 on 2022-09-25 14:00:54 ','2022-09-25 14:00:54','',''),('1','57',4941359,'','6.1','1255',0.00,0.00,'Sales from shift 257345 on 2022-09-25 14:00:54 ','2022-09-25 14:00:54','',''),('1','57',4941360,'','20','1253',469721.80,0.00,'Sales from shift 257346 on 2022-09-25 14:06:23 ','2022-09-25 14:06:23','',''),('1','57',4941361,'','6.1','1255',0.00,469721.80,'Sales from shift 257346 on 2022-09-25 14:06:23 ','2022-09-25 14:06:23','',''),('1','57',4941362,'','20','1253',59010.20,0.00,'Sales from shift 257347 on 2022-09-25 14:11:12 ','2022-09-25 14:11:12','',''),('1','57',4941363,'','6.1','1255',0.00,59010.20,'Sales from shift 257347 on 2022-09-25 14:11:12 ','2022-09-25 14:11:12','',''),('1','57',4941364,'','20','1253',288549.20,0.00,'Sales from shift 257348 on 2022-09-26 11:44:37 ','2022-09-26 11:44:37','',''),('1','57',4941365,'','6.1','1255',0.00,288549.20,'Sales from shift 257348 on 2022-09-26 11:44:37 ','2022-09-26 11:44:37','',''),('1','57',4941366,'','20','1253',182548.20,0.00,'Sales from shift 257349 on 2022-09-26 11:56:43 ','2022-09-26 11:56:43','',''),('1','57',4941367,'','6.1','1255',0.00,182548.20,'Sales from shift 257349 on 2022-09-26 11:56:43 ','2022-09-26 11:56:43','',''),('1','57',4941368,'','2','4067',182548.00,0.00,'Payment Id 400055 for invoice:257349, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-26 15:21:36','',''),('1','57',4941369,'','supplier','76',0.00,182548.00,'Payment Id 400055 for invoice:257349, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-26 15:21:36','',''),('1','57',4941370,'','2','4067',59010.00,0.00,'Payment Id 400053 for invoice:257347, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-26 15:21:36','',''),('1','57',4941371,'','supplier','76',0.00,59010.00,'Payment Id 400053 for invoice:257347, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-26 15:21:36','',''),('1','57',4941372,'','2','4067',310816.00,0.00,'Payment Id 400050 for invoice:257343, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-26 15:21:36','',''),('1','57',4941373,'','supplier','76',0.00,310816.00,'Payment Id 400050 for invoice:257343, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-26 15:21:36','',''),('1','57',4941374,'','2','4067',309502.00,0.00,'Payment Id 400049 for invoice:257342, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-26 15:21:36','',''),('1','57',4941375,'','supplier','76',0.00,309502.00,'Payment Id 400049 for invoice:257342, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-26 15:21:36','',''),('1','57',4941376,'','2','4103',452840.00,0.00,'Payment Id 400047 for invoice:257340, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-26 15:28:33','',''),('1','57',4941377,'','supplier','76',0.00,452840.00,'Payment Id 400047 for invoice:257340, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-26 15:28:33','',''),('1','57',4941378,'','20','1253',78912.70,0.00,'Sales from shift 257350 on 2022-09-27 10:34:44 ','2022-09-27 10:34:44','',''),('1','57',4941379,'','6.1','1255',0.00,78912.70,'Sales from shift 257350 on 2022-09-27 10:34:44 ','2022-09-27 10:34:44','',''),('1','57',4941380,'','20','1253',167372.90,0.00,'Sales from shift 257351 on 2022-09-27 11:29:14 ','2022-09-27 11:29:14','',''),('1','57',4941381,'','6.1','1255',0.00,167372.90,'Sales from shift 257351 on 2022-09-27 11:29:14 ','2022-09-27 11:29:14','',''),('1','57',4941382,'','6.1','1255',80000.00,0.00,'Payment Id 400056 for invoice:257349, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-27 15:09:05','',''),('1','57',4941383,'','supplier','76',0.00,80000.00,'Payment Id 400056 for invoice:257349, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-27 15:09:05','',''),('1','57',4941384,'','20','1253',159292.20,0.00,'Sales from shift 257352 on 2022-09-28 11:19:09 ','2022-09-28 11:19:09','',''),('1','57',4941385,'','6.1','1255',0.00,159292.20,'Sales from shift 257352 on 2022-09-28 11:19:09 ','2022-09-28 11:19:09','',''),('1','57',4941386,'','20','1253',94331.20,0.00,'Sales from shift 257353 on 2022-09-28 13:19:10 ','2022-09-28 13:19:10','',''),('1','57',4941387,'','6.1','1255',0.00,94331.20,'Sales from shift 257353 on 2022-09-28 13:19:10 ','2022-09-28 13:19:10','',''),('1','57',4941388,'','20','1253',230312.30,0.00,'Sales from shift 257354 on 2022-09-28 15:38:14 ','2022-09-28 15:38:14','',''),('1','57',4941389,'','6.1','1255',0.00,230312.30,'Sales from shift 257354 on 2022-09-28 15:38:14 ','2022-09-28 15:38:14','',''),('1','57',4941390,'','2','4067',469720.00,0.00,'Payment Id 400051 for invoice:257344, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-28 15:39:41','',''),('1','57',4941391,'','supplier','76',0.00,469720.00,'Payment Id 400051 for invoice:257344, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-28 15:39:41','',''),('1','57',4941392,'','2','4067',159292.00,0.00,'Payment Id 400059 for invoice:257352, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-28 15:40:08','',''),('1','57',4941393,'','supplier','76',0.00,159292.00,'Payment Id 400059 for invoice:257352, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-28 15:40:08','',''),('1','57',4941394,'','2','4067',167372.00,0.00,'Payment Id 400058 for invoice:257351, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-28 15:40:09','',''),('1','57',4941395,'','supplier','76',0.00,167372.00,'Payment Id 400058 for invoice:257351, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-28 15:40:09','',''),('1','57',4941396,'','2','4067',78912.00,0.00,'Payment Id 400057 for invoice:257350, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-28 15:40:09','',''),('1','57',4941397,'','supplier','76',0.00,78912.00,'Payment Id 400057 for invoice:257350, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-28 15:40:09','',''),('1','57',4941398,'','2','4067',288549.00,0.00,'Payment Id 400054 for invoice:257348, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-28 15:40:09','',''),('1','57',4941399,'','supplier','76',0.00,288549.00,'Payment Id 400054 for invoice:257348, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-28 15:40:09','',''),('1','57',4941400,'','20','1253',151067.10,0.00,'Sales from shift 257355 on 2022-09-29 12:21:46 ','2022-09-29 12:21:46','',''),('1','57',4941401,'','6.1','1255',0.00,151067.10,'Sales from shift 257355 on 2022-09-29 12:21:46 ','2022-09-29 12:21:46','',''),('1','57',4941402,'','2','4067',59931.00,0.00,'Payment Id 400060 for invoice:257353, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-29 16:22:44','',''),('1','57',4941403,'','supplier','76',0.00,59931.00,'Payment Id 400060 for invoice:257353, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-29 16:22:44','',''),('1','57',4941404,'','2','4067',230310.00,0.00,'Payment Id 400061 for invoice:257354, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-29 16:23:04','',''),('1','57',4941405,'','supplier','76',0.00,230310.00,'Payment Id 400061 for invoice:257354, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-29 16:23:04','',''),('1','57',4941406,'','2','4067',34400.00,0.00,'Payment Id 400063 for invoice:257355, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-29 16:23:23','',''),('1','57',4941407,'','supplier','76',0.00,34400.00,'Payment Id 400063 for invoice:257355, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-29 16:23:23','',''),('1','57',4941408,'','2','4067',151067.00,0.00,'Payment Id 400062 for invoice:257355, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-29 16:23:23','',''),('1','57',4941409,'','supplier','76',0.00,151067.00,'Payment Id 400062 for invoice:257355, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-29 16:23:23','',''),('1','57',4941410,'','20','1253',132576.30,0.00,'Sales from shift 257356 on 2022-09-30 07:40:32 ','2022-09-30 07:40:32','',''),('1','57',4941411,'','6.1','1255',0.00,132576.30,'Sales from shift 257356 on 2022-09-30 07:40:32 ','2022-09-30 07:40:32','',''),('1','57',4941412,'','20','1253',94074.70,0.00,'Sales from shift 257357 on 2022-09-30 12:12:47 ','2022-09-30 12:12:47','',''),('1','57',4941413,'','6.1','1255',0.00,94074.70,'Sales from shift 257357 on 2022-09-30 12:12:47 ','2022-09-30 12:12:47','',''),('1','57',4941414,'','20','1253',108911.80,0.00,'Sales from shift 257358 on 2022-09-30 16:18:58 ','2022-09-30 16:18:58','',''),('1','57',4941415,'','6.1','1255',0.00,108911.80,'Sales from shift 257358 on 2022-09-30 16:18:58 ','2022-09-30 16:18:58','',''),('1','57',4941416,'','2','4067',132460.00,0.00,'Payment Id 400065 for invoice:257357, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-30 16:28:23','',''),('1','57',4941417,'','supplier','76',0.00,132460.00,'Payment Id 400065 for invoice:257357, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-30 16:28:23','',''),('1','57',4941418,'','2','4067',94075.00,0.00,'Payment Id 400064 for invoice:257357, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-30 16:28:23','',''),('1','57',4941419,'','supplier','76',0.00,94075.00,'Payment Id 400064 for invoice:257357, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-09-30 16:28:23','',''),('1','57',4941420,'','20','1253',207081.00,0.00,'Sales from shift 257359 on 2022-10-02 15:23:58 ','2022-10-02 15:23:58','',''),('1','57',4941421,'','6.1','1255',0.00,207081.00,'Sales from shift 257359 on 2022-10-02 15:23:58 ','2022-10-02 15:23:58','',''),('1','57',4941422,'','20','1253',76752.40,0.00,'Sales from shift 257360 on 2022-10-02 19:54:00 ','2022-10-02 19:54:00','',''),('1','57',4941423,'','6.1','1255',0.00,76752.40,'Sales from shift 257360 on 2022-10-02 19:54:00 ','2022-10-02 19:54:00','',''),('1','57',4941424,'','20','1253',180950.30,0.00,'Sales from shift 257361 on 2022-10-03 15:37:28 ','2022-10-03 15:37:28','',''),('1','57',4941425,'','6.1','1255',0.00,180950.30,'Sales from shift 257361 on 2022-10-03 15:37:28 ','2022-10-03 15:37:28','',''),('1','57',4941426,'','20','1253',88674.90,0.00,'Sales from shift 257362 on 2022-10-03 17:52:58 ','2022-10-03 17:52:58','',''),('1','57',4941427,'','6.1','1255',0.00,88674.90,'Sales from shift 257362 on 2022-10-03 17:52:58 ','2022-10-03 17:52:58','',''),('1','57',4941428,'','20','1253',149412.20,0.00,'Sales from shift 257363 on 2022-10-03 18:00:22 ','2022-10-03 18:00:22','',''),('1','57',4941429,'','6.1','1255',0.00,149412.20,'Sales from shift 257363 on 2022-10-03 18:00:22 ','2022-10-03 18:00:22','',''),('1','57',4941430,'','20','1253',98929.20,0.00,'Sales from shift 257364 on 2022-10-03 18:20:03 ','2022-10-03 18:20:03','',''),('1','57',4941431,'','6.1','1255',0.00,98929.20,'Sales from shift 257364 on 2022-10-03 18:20:03 ','2022-10-03 18:20:03','',''),('1','57',4941432,'','20','1253',198683.00,0.00,'Sales from shift 257365 on 2022-10-04 14:16:24 ','2022-10-04 14:16:24','',''),('1','57',4941433,'','6.1','1255',0.00,198683.00,'Sales from shift 257365 on 2022-10-04 14:16:24 ','2022-10-04 14:16:24','',''),('1','57',4941434,'','20','1253',144956.70,0.00,'Sales from shift 257366 on 2022-10-05 11:27:16 ','2022-10-05 11:27:16','',''),('1','57',4941435,'','6.1','1255',0.00,144956.70,'Sales from shift 257366 on 2022-10-05 11:27:16 ','2022-10-05 11:27:16','',''),('1','57',4941436,'','20','1253',186243.70,0.00,'Sales from shift 257367 on 2022-10-05 12:28:02 ','2022-10-05 12:28:02','',''),('1','57',4941437,'','6.1','1255',0.00,186243.70,'Sales from shift 257367 on 2022-10-05 12:28:02 ','2022-10-05 12:28:02','',''),('1','57',4941438,'','2','4067',180950.00,0.00,'Payment Id 400069 for invoice:257361, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-05 15:41:09','',''),('1','57',4941439,'','supplier','76',0.00,180950.00,'Payment Id 400069 for invoice:257361, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-05 15:41:09','',''),('1','57',4941440,'','2','4067',76752.00,0.00,'Payment Id 400068 for invoice:257360, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-05 15:41:09','',''),('1','57',4941441,'','supplier','76',0.00,76752.00,'Payment Id 400068 for invoice:257360, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-05 15:41:09','',''),('1','57',4941442,'','2','4067',108911.00,0.00,'Payment Id 400066 for invoice:257358, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-05 15:41:09','',''),('1','57',4941443,'','supplier','76',0.00,108911.00,'Payment Id 400066 for invoice:257358, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-05 15:41:09','',''),('1','57',4941444,'','2','4103',207081.00,0.00,'Payment Id 400067 for invoice:257359, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-05 15:43:33','',''),('1','57',4941445,'','supplier','76',0.00,207081.00,'Payment Id 400067 for invoice:257359, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-05 15:43:33','',''),('1','57',4941446,'','20','1253',157922.30,0.00,'Sales from shift 257368 on 2022-10-06 11:42:34 ','2022-10-06 11:42:34','',''),('1','57',4941447,'','6.1','1255',0.00,157922.30,'Sales from shift 257368 on 2022-10-06 11:42:34 ','2022-10-06 11:42:34','',''),('1','57',4941448,'','20','1253',174627.10,0.00,'Sales from shift 257369 on 2022-10-07 09:38:36 ','2022-10-07 09:38:36','',''),('1','57',4941449,'','6.1','1255',0.00,174627.10,'Sales from shift 257369 on 2022-10-07 09:38:36 ','2022-10-07 09:38:36','',''),('1','57',4941450,'','20','1253',86558.30,0.00,'Sales from shift 257370 on 2022-10-07 10:28:39 ','2022-10-07 10:28:39','',''),('1','57',4941451,'','6.1','1255',0.00,86558.30,'Sales from shift 257370 on 2022-10-07 10:28:39 ','2022-10-07 10:28:39','',''),('1','57',4941452,'','20','1253',160388.50,0.00,'Sales from shift 257371 on 2022-10-07 11:43:54 ','2022-10-07 11:43:54','',''),('1','57',4941453,'','6.1','1255',0.00,160388.50,'Sales from shift 257371 on 2022-10-07 11:43:54 ','2022-10-07 11:43:54','',''),('1','57',4941454,'','20','1253',79239.50,0.00,'Sales from shift 257372 on 2022-10-07 20:19:03 ','2022-10-07 20:19:03','',''),('1','57',4941455,'','6.1','1255',0.00,79239.50,'Sales from shift 257372 on 2022-10-07 20:19:03 ','2022-10-07 20:19:03','',''),('1','57',4941456,'','2','4067',157922.00,0.00,'Payment Id 400079 for invoice:257368, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-08 00:47:06','',''),('1','57',4941457,'','supplier','76',0.00,157922.00,'Payment Id 400079 for invoice:257368, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-08 00:47:06','',''),('1','57',4941458,'','2','4067',186243.00,0.00,'Payment Id 400078 for invoice:257367, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-08 00:47:06','',''),('1','57',4941459,'','supplier','76',0.00,186243.00,'Payment Id 400078 for invoice:257367, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-08 00:47:06','',''),('1','57',4941460,'','2','4067',144956.00,0.00,'Payment Id 400077 for invoice:257366, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-08 00:47:06','',''),('1','57',4941461,'','supplier','76',0.00,144956.00,'Payment Id 400077 for invoice:257366, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-08 00:47:06','',''),('1','57',4941462,'','2','4067',98929.00,0.00,'Payment Id 400075 for invoice:257374, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-08 00:47:06','',''),('1','57',4941463,'','supplier','76',0.00,98929.00,'Payment Id 400075 for invoice:257374, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-08 00:47:06','',''),('1','57',4941464,'','2','4067',149412.00,0.00,'Payment Id 400074 for invoice:257363, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-08 00:47:06','',''),('1','57',4941465,'','supplier','76',0.00,149412.00,'Payment Id 400074 for invoice:257363, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-08 00:47:06','',''),('1','57',4941466,'','6.1','1255',80000.00,0.00,'Payment Id 400073 for invoice:257371, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-08 00:47:06','',''),('1','57',4941467,'','supplier','76',0.00,80000.00,'Payment Id 400073 for invoice:257371, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-08 00:47:06','',''),('1','57',4941468,'','2','4067',88675.00,0.00,'Payment Id 400080 for invoice:257362, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-08 00:50:10','',''),('1','57',4941469,'','supplier','76',0.00,88675.00,'Payment Id 400080 for invoice:257362, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-08 00:50:10','',''),('1','57',4941470,'','2','4103',94630.00,0.00,'Payment Id 400070 for invoice:257371, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-08 00:50:11','',''),('1','57',4941471,'','supplier','76',0.00,94630.00,'Payment Id 400070 for invoice:257371, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-08 00:50:11','',''),('1','57',4941472,'','2','4067',198683.00,0.00,'Payment Id 400076 for invoice:257375, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-08 00:52:59','',''),('1','57',4941473,'','supplier','76',0.00,198683.00,'Payment Id 400076 for invoice:257375, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-08 00:52:59','',''),('1','57',4941474,'','20','1253',344572.60,0.00,'Sales from shift 257373 on 2022-10-08 09:46:45 ','2022-10-08 09:46:45','',''),('1','57',4941475,'','6.1','1255',0.00,344572.60,'Sales from shift 257373 on 2022-10-08 09:46:45 ','2022-10-08 09:46:45','',''),('1','57',4941476,'','20','1253',81764.60,0.00,'Sales from shift 257374 on 2022-10-09 21:54:25 ','2022-10-09 21:54:25','',''),('1','57',4941477,'','6.1','1255',0.00,81764.60,'Sales from shift 257374 on 2022-10-09 21:54:25 ','2022-10-09 21:54:25','',''),('1','57',4941478,'','20','1253',37901.20,0.00,'Sales from shift 257375 on 2022-10-11 11:55:51 ','2022-10-11 11:55:51','',''),('1','57',4941479,'','6.1','1255',0.00,37901.20,'Sales from shift 257375 on 2022-10-11 11:55:51 ','2022-10-11 11:55:51','',''),('1','57',4941480,'','2','4103',81593.00,0.00,'Payment Id 400083 for invoice:257374, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-11 17:28:16','',''),('1','57',4941481,'','supplier','76',0.00,81593.00,'Payment Id 400083 for invoice:257374, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-11 17:28:16','',''),('1','57',4941482,'','2','4103',86568.00,0.00,'Payment Id 400071 for invoice:257370, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-11 18:12:55','',''),('1','57',4941483,'','supplier','76',0.00,86568.00,'Payment Id 400071 for invoice:257370, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-11 18:12:55','',''),('1','57',4941484,'','2','4067',160388.00,0.00,'Payment Id 400072 for invoice:257369, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-12 16:40:37','',''),('1','57',4941485,'','supplier','76',0.00,160388.00,'Payment Id 400072 for invoice:257369, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-12 16:40:37','',''),('1','57',4941486,'','2','4067',344572.00,0.00,'Payment Id 400082 for invoice:257373, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-12 16:46:46','',''),('1','57',4941487,'','supplier','76',0.00,344572.00,'Payment Id 400082 for invoice:257373, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-12 16:46:46','',''),('1','57',4941488,'','2','4067',79239.00,0.00,'Payment Id 400081 for invoice:257372, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-12 16:46:46','',''),('1','57',4941489,'','supplier','76',0.00,79239.00,'Payment Id 400081 for invoice:257372, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-12 16:46:46','',''),('1','57',4941490,'','2','4103',37900.00,0.00,'Payment Id 400084 for invoice:257375, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-13 10:47:55','',''),('1','57',4941491,'','supplier','76',0.00,37900.00,'Payment Id 400084 for invoice:257375, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-10-13 10:47:55','',''),('1','57',4941492,'','24','1235',0.00,3724000.00,'Purchase Id 89906 for 15,200.00 litters of Petrol - PMS from A.A RANO NIGERIA LIMITED','2022-11-15 15:59:51','',''),('1','57',4941493,'','supplier','76',3724000.00,0.00,'Purchase Id 89906 for 15,200.00 litters of Petrol - PMS from A.A RANO NIGERIA LIMITED','2022-11-15 15:59:51','',''),('1','57',4941494,'','20','1253',0.00,0.00,'Sales from shift 257376 on 2022-11-16 08:26:04 ','2022-11-16 08:26:04','',''),('1','57',4941495,'','6.1','1255',0.00,0.00,'Sales from shift 257376 on 2022-11-16 08:26:04 ','2022-11-16 08:26:04','',''),('1','57',4941496,'','20','1253',824483.80,0.00,'Sales from shift 257377 on 2022-11-16 15:57:54 ','2022-11-16 15:57:54','',''),('1','57',4941497,'','6.1','1255',0.00,824483.80,'Sales from shift 257377 on 2022-11-16 15:57:54 ','2022-11-16 15:57:54','',''),('1','57',4941498,'','20','1253',1455486.20,0.00,'Sales from shift 257378 on 2022-11-17 01:07:32 ','2022-11-17 01:07:32','',''),('1','57',4941499,'','6.1','1255',0.00,1455486.20,'Sales from shift 257378 on 2022-11-17 01:07:32 ','2022-11-17 01:07:32','',''),('1','57',4941500,'','20','1253',175767.90,0.00,'Sales from shift 257379 on 2022-11-17 15:05:11 ','2022-11-17 15:05:11','',''),('1','57',4941501,'','6.1','1255',0.00,175767.90,'Sales from shift 257379 on 2022-11-17 15:05:11 ','2022-11-17 15:05:11','',''),('1','57',4941502,'','20','1253',410561.20,0.00,'Sales from shift 257380 on 2022-11-17 15:23:39 ','2022-11-17 15:23:39','',''),('1','57',4941503,'','6.1','1255',0.00,410561.20,'Sales from shift 257380 on 2022-11-17 15:23:39 ','2022-11-17 15:23:39','',''),('1','57',4941504,'','20','1253',766504.55,0.00,'Sales from shift 257381 on 2022-11-18 11:25:02 ','2022-11-18 11:25:02','',''),('1','57',4941505,'','6.1','1255',0.00,766504.55,'Sales from shift 257381 on 2022-11-18 11:25:02 ','2022-11-18 11:25:02','',''),('1','57',4941506,'','20','1253',105898.80,0.00,'Sales from shift 257382 on 2022-11-21 00:10:52 ','2022-11-21 00:10:52','',''),('1','57',4941507,'','6.1','1255',0.00,105898.80,'Sales from shift 257382 on 2022-11-21 00:10:52 ','2022-11-21 00:10:52','',''),('1','57',4941508,'','6.1','1255',702184.00,0.00,'Payment Id 400086 for invoice:257377, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-11-21 11:48:45','',''),('1','57',4941509,'','supplier','76',0.00,702184.00,'Payment Id 400086 for invoice:257377, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-11-21 11:48:45','',''),('1','57',4941510,'','2','4067',122299.00,0.00,'Payment Id 400085 for invoice:257377, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-11-21 11:50:53','',''),('1','57',4941511,'','supplier','76',0.00,122299.00,'Payment Id 400085 for invoice:257377, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-11-21 11:50:53','',''),('1','57',4941512,'','2','4103',1068200.00,0.00,'Payment Id 400093 for invoice:257383, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-11-21 13:27:10','',''),('1','57',4941513,'','supplier','76',0.00,1068200.00,'Payment Id 400093 for invoice:257383, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-11-21 13:27:10','',''),('1','57',4941514,'','2','4103',1160.00,0.00,'Payment Id 400087 for invoice:257377, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-11-21 13:27:27','',''),('1','57',4941515,'','supplier','76',0.00,1160.00,'Payment Id 400087 for invoice:257377, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-11-21 13:27:27','',''),('1','57',4941516,'','2','4103',455500.00,0.00,'Payment Id 400091 for invoice:257381, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-11-21 13:33:03','',''),('1','57',4941517,'','supplier','76',0.00,455500.00,'Payment Id 400091 for invoice:257381, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-11-21 13:33:03','',''),('1','57',4941518,'','6.1','1255',43000.00,0.00,'Payment Id 400094 for invoice:257383, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-11-21 13:33:23','',''),('1','57',4941519,'','supplier','76',0.00,43000.00,'Payment Id 400094 for invoice:257383, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-11-21 13:33:23','',''),('1','57',4941520,'','2','4067',105898.00,0.00,'Payment Id 400092 for invoice:257382, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-11-22 12:10:47','',''),('1','57',4941521,'','supplier','76',0.00,105898.00,'Payment Id 400092 for invoice:257382, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-11-22 12:10:47','',''),('1','57',4941522,'','2','4067',78407.00,0.00,'Payment Id 400089 for invoice:257379, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-11-22 12:15:54','',''),('1','57',4941523,'','supplier','76',0.00,78407.00,'Payment Id 400089 for invoice:257379, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-11-22 12:15:54','',''),('1','57',4941524,'','2','4067',410560.00,0.00,'Payment Id 400090 for invoice:257380, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-11-22 12:17:01','',''),('1','57',4941525,'','supplier','76',0.00,410560.00,'Payment Id 400090 for invoice:257380, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-11-22 12:17:01','',''),('1','57',4941526,'','2','4067',343126.00,0.00,'Payment Id 400088 for invoice:257379, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-11-22 12:22:17','',''),('1','57',4941527,'','supplier','76',0.00,343126.00,'Payment Id 400088 for invoice:257379, receipt: 00 by A.A RANO NIGERIA LIMITED','2022-11-22 12:22:17','',''),('1','57',4941528,'','2','4067',311000.00,0.00,'Payment Id 400095 for invoice:257379, receipt: 257379 by A.A RANO NIGERIA LIMITED','2022-11-24 16:35:10','',''),('1','57',4941529,'','supplier','76',0.00,311000.00,'Payment Id 400095 for invoice:257379, receipt: 257379 by A.A RANO NIGERIA LIMITED','2022-11-24 16:35:10','',''),('1','57',4941530,'','2','4067',372080.00,0.00,'Payment Id 400096 for invoice:257379, receipt: 257379 by A.A RANO NIGERIA LIMITED','2022-11-24 19:03:15','',''),('1','57',4941531,'','supplier','76',0.00,372080.00,'Payment Id 400096 for invoice:257379, receipt: 257379 by A.A RANO NIGERIA LIMITED','2022-11-24 19:03:15','',''),('1','57',4941532,'','24','1235',0.00,17800000.00,'Purchase Id 89907 for 20,000.00 litters of Diesel - AGO from A.A RANO NIGERIA LIMITED','2023-01-04 11:55:19','',''),('1','57',4941533,'','supplier','76',17800000.00,0.00,'Purchase Id 89907 for 20,000.00 litters of Diesel - AGO from A.A RANO NIGERIA LIMITED','2023-01-04 11:55:19','',''),('1','57',4941534,'','20','1253',0.00,0.00,'Sales from shift 257383 on 2023-01-06 10:15:21 ','2023-01-06 10:15:21','',''),('1','57',4941535,'','6.1','1255',0.00,0.00,'Sales from shift 257383 on 2023-01-06 10:15:21 ','2023-01-06 10:15:21','',''),('1','57',4941536,'','20','1253',855663.80,0.00,'Sales from shift 257384 on 2023-01-06 10:28:21 ','2023-01-06 10:28:21','',''),('1','57',4941537,'','6.1','1255',0.00,855663.80,'Sales from shift 257384 on 2023-01-06 10:28:21 ','2023-01-06 10:28:21','',''),('1','57',4941538,'','20','1253',623000.00,0.00,'Sales from shift 257385 on 2023-01-06 17:34:13 ','2023-01-06 17:34:13','',''),('1','57',4941539,'','6.1','1255',0.00,623000.00,'Sales from shift 257385 on 2023-01-06 17:34:13 ','2023-01-06 17:34:13','',''),('1','57',4941540,'','20','1253',692250.90,0.00,'Sales from shift 257386 on 2023-01-08 09:40:56 ','2023-01-08 09:40:56','',''),('1','57',4941541,'','6.1','1255',0.00,692250.90,'Sales from shift 257386 on 2023-01-08 09:40:56 ','2023-01-08 09:40:56','',''),('1','57',4941542,'','20','1253',122419.50,0.00,'Sales from shift 257387 on 2023-01-08 19:01:41 ','2023-01-08 19:01:41','',''),('1','57',4941543,'','6.1','1255',0.00,122419.50,'Sales from shift 257387 on 2023-01-08 19:01:41 ','2023-01-08 19:01:41','',''),('1','57',4941544,'','20','1253',71200.00,0.00,'Sales from shift 257388 on 2023-01-09 03:49:20 ','2023-01-09 03:49:20','',''),('1','57',4941545,'','6.1','1255',0.00,71200.00,'Sales from shift 257388 on 2023-01-09 03:49:20 ','2023-01-09 03:49:20','',''),('1','57',4941546,'','20','1253',11596.70,0.00,'Sales from shift 257389 on 2023-01-09 11:45:58 ','2023-01-09 11:45:58','',''),('1','57',4941547,'','6.1','1255',0.00,11596.70,'Sales from shift 257389 on 2023-01-09 11:45:58 ','2023-01-09 11:45:58','',''),('1','57',4941548,'','20','1253',720650.80,0.00,'Sales from shift 257390 on 2023-01-10 10:50:51 ','2023-01-10 10:50:51','',''),('1','57',4941549,'','6.1','1255',0.00,720650.80,'Sales from shift 257390 on 2023-01-10 10:50:51 ','2023-01-10 10:50:51','',''),('1','57',4941550,'','20','1253',66750.00,0.00,'Sales from shift 257391 on 2023-01-10 20:42:51 ','2023-01-10 20:42:51','',''),('1','57',4941551,'','6.1','1255',0.00,66750.00,'Sales from shift 257391 on 2023-01-10 20:42:51 ','2023-01-10 20:42:51','',''),('1','57',4941552,'','20','1253',437604.10,0.00,'Sales from shift 257392 on 2023-01-10 20:51:36 ','2023-01-10 20:51:36','',''),('1','57',4941553,'','6.1','1255',0.00,437604.10,'Sales from shift 257392 on 2023-01-10 20:51:36 ','2023-01-10 20:51:36','',''),('1','57',4941554,'','20','1253',160200.00,0.00,'Sales from shift 257393 on 2023-01-10 21:01:42 ','2023-01-10 21:01:42','',''),('1','57',4941555,'','6.1','1255',0.00,160200.00,'Sales from shift 257393 on 2023-01-10 21:01:42 ','2023-01-10 21:01:42','',''),('1','57',4941556,'','20','1253',759116.60,0.00,'Sales from shift 257394 on 2023-01-10 21:13:01 ','2023-01-10 21:13:01','',''),('1','57',4941557,'','6.1','1255',0.00,759116.60,'Sales from shift 257394 on 2023-01-10 21:13:01 ','2023-01-10 21:13:01','',''),('1','57',4941558,'','20','1253',464802.50,0.00,'Sales from shift 257395 on 2023-01-11 11:24:03 ','2023-01-11 11:24:03','',''),('1','57',4941559,'','6.1','1255',0.00,464802.50,'Sales from shift 257395 on 2023-01-11 11:24:03 ','2023-01-11 11:24:03','',''),('1','57',4941560,'','2','4067',623000.00,0.00,'Payment Id 400100 for invoice:257385, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-01-12 06:54:37','',''),('1','57',4941561,'','supplier','76',0.00,623000.00,'Payment Id 400100 for invoice:257385, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-01-12 06:54:37','',''),('1','57',4941562,'','2','4067',11596.00,0.00,'Payment Id 400104 for invoice:257389, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-01-12 06:55:40','',''),('1','57',4941563,'','supplier','76',0.00,11596.00,'Payment Id 400104 for invoice:257389, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-01-12 06:55:40','',''),('1','57',4941564,'','2','4067',71200.00,0.00,'Payment Id 400103 for invoice:257388, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-01-12 06:55:40','',''),('1','57',4941565,'','supplier','76',0.00,71200.00,'Payment Id 400103 for invoice:257388, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-01-12 06:55:40','',''),('1','57',4941566,'','2','4067',692250.00,0.00,'Payment Id 400101 for invoice:257386, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-01-12 07:05:12','',''),('1','57',4941567,'','supplier','76',0.00,692250.00,'Payment Id 400101 for invoice:257386, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-01-12 07:05:12','',''),('1','57',4941568,'','2','4067',66750.00,0.00,'Payment Id 400106 for invoice:257391, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-01-12 07:12:12','',''),('1','57',4941569,'','supplier','76',0.00,66750.00,'Payment Id 400106 for invoice:257391, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-01-12 07:12:12','',''),('1','57',4941570,'','2','4067',122419.00,0.00,'Payment Id 400102 for invoice:257387, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-01-12 07:12:12','',''),('1','57',4941571,'','supplier','76',0.00,122419.00,'Payment Id 400102 for invoice:257387, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-01-12 07:12:12','',''),('1','57',4941572,'','20','1253',279566.80,0.00,'Sales from shift 257396 on 2023-01-12 07:30:50 ','2023-01-12 07:30:50','',''),('1','57',4941573,'','6.1','1255',0.00,279566.80,'Sales from shift 257396 on 2023-01-12 07:30:50 ','2023-01-12 07:30:50','',''),('1','57',4941574,'','20','1253',58401.80,0.00,'Sales from shift 257397 on 2023-01-12 19:56:03 ','2023-01-12 19:56:03','',''),('1','57',4941575,'','6.1','1255',0.00,58401.80,'Sales from shift 257397 on 2023-01-12 19:56:03 ','2023-01-12 19:56:03','',''),('1','57',4941576,'','20','1253',182636.90,0.00,'Sales from shift 257398 on 2023-01-13 17:17:14 ','2023-01-13 17:17:14','',''),('1','57',4941577,'','6.1','1255',0.00,182636.90,'Sales from shift 257398 on 2023-01-13 17:17:14 ','2023-01-13 17:17:14','',''),('1','57',4941578,'','20','1253',86614.80,0.00,'Sales from shift 257399 on 2023-01-14 10:31:29 ','2023-01-14 10:31:29','',''),('1','57',4941579,'','6.1','1255',0.00,86614.80,'Sales from shift 257399 on 2023-01-14 10:31:29 ','2023-01-14 10:31:29','',''),('1','57',4941580,'','20','1253',884927.00,0.00,'Sales from shift 257400 on 2023-01-14 10:48:29 ','2023-01-14 10:48:29','',''),('1','57',4941581,'','6.1','1255',0.00,884927.00,'Sales from shift 257400 on 2023-01-14 10:48:29 ','2023-01-14 10:48:29','',''),('1','57',4941582,'','20','1253',2002.50,0.00,'Sales from shift 257401 on 2023-01-15 07:48:07 ','2023-01-15 07:48:07','',''),('1','57',4941583,'','6.1','1255',0.00,2002.50,'Sales from shift 257401 on 2023-01-15 07:48:07 ','2023-01-15 07:48:07','',''),('1','57',4941584,'','20','1253',178996.80,0.00,'Sales from shift 257402 on 2023-01-15 13:26:08 ','2023-01-15 13:26:08','',''),('1','57',4941585,'','6.1','1255',0.00,178996.80,'Sales from shift 257402 on 2023-01-15 13:26:08 ','2023-01-15 13:26:08','',''),('1','57',4941586,'','20','1253',44500.00,0.00,'Sales from shift 257403 on 2023-01-16 13:54:22 ','2023-01-16 13:54:22','',''),('1','57',4941587,'','6.1','1255',0.00,44500.00,'Sales from shift 257403 on 2023-01-16 13:54:22 ','2023-01-16 13:54:22','',''),('1','57',4941588,'','20','1253',277199.40,0.00,'Sales from shift 257404 on 2023-01-16 14:08:21 ','2023-01-16 14:08:21','',''),('1','57',4941589,'','6.1','1255',0.00,277199.40,'Sales from shift 257404 on 2023-01-16 14:08:21 ','2023-01-16 14:08:21','',''),('1','57',4941590,'','20','1253',1456271.40,0.00,'Sales from shift 257405 on 2023-01-17 09:45:40 ','2023-01-17 09:45:40','',''),('1','57',4941591,'','6.1','1255',0.00,1456271.40,'Sales from shift 257405 on 2023-01-17 09:45:40 ','2023-01-17 09:45:40','',''),('1','57',4941592,'','2','4067',160200.00,0.00,'Payment Id 400127 for invoice:257393, receipt: 796659 by A.A RANO NIGERIA LIMITED','2023-01-17 12:47:16','',''),('1','57',4941593,'','supplier','76',0.00,160200.00,'Payment Id 400127 for invoice:257393, receipt: 796659 by A.A RANO NIGERIA LIMITED','2023-01-17 12:47:16','',''),('1','57',4941594,'','2','4067',182636.00,0.00,'Payment Id 400126 for invoice:257402, receipt: 482583 by A.A RANO NIGERIA LIMITED','2023-01-17 12:47:16','',''),('1','57',4941595,'','supplier','76',0.00,182636.00,'Payment Id 400126 for invoice:257402, receipt: 482583 by A.A RANO NIGERIA LIMITED','2023-01-17 12:47:16','',''),('1','57',4941596,'','2','4067',277199.00,0.00,'Payment Id 400125 for invoice:257402, receipt: 482587 by A.A RANO NIGERIA LIMITED','2023-01-17 12:47:16','',''),('1','57',4941597,'','supplier','76',0.00,277199.00,'Payment Id 400125 for invoice:257402, receipt: 482587 by A.A RANO NIGERIA LIMITED','2023-01-17 12:47:16','',''),('1','57',4941598,'','2','4067',44500.00,0.00,'Payment Id 400124 for invoice:257402, receipt: 482586 by A.A RANO NIGERIA LIMITED','2023-01-17 12:47:16','',''),('1','57',4941599,'','supplier','76',0.00,44500.00,'Payment Id 400124 for invoice:257402, receipt: 482586 by A.A RANO NIGERIA LIMITED','2023-01-17 12:47:16','',''),('1','57',4941600,'','2','4067',178966.00,0.00,'Payment Id 400123 for invoice:257402, receipt: 482585 by A.A RANO NIGERIA LIMITED','2023-01-17 12:47:16','',''),('1','57',4941601,'','supplier','76',0.00,178966.00,'Payment Id 400123 for invoice:257402, receipt: 482585 by A.A RANO NIGERIA LIMITED','2023-01-17 12:47:16','',''),('1','57',4941602,'','2','4067',2002.00,0.00,'Payment Id 400122 for invoice:257402, receipt: 482584 by A.A RANO NIGERIA LIMITED','2023-01-17 12:47:16','',''),('1','57',4941603,'','supplier','76',0.00,2002.00,'Payment Id 400122 for invoice:257402, receipt: 482584 by A.A RANO NIGERIA LIMITED','2023-01-17 12:47:16','',''),('1','57',4941604,'','2','4067',884927.00,0.00,'Payment Id 400121 for invoice:257400, receipt: 482600 by A.A RANO NIGERIA LIMITED','2023-01-17 12:47:16','',''),('1','57',4941605,'','supplier','76',0.00,884927.00,'Payment Id 400121 for invoice:257400, receipt: 482600 by A.A RANO NIGERIA LIMITED','2023-01-17 12:47:16','',''),('1','57',4941606,'','2','4067',86614.80,0.00,'Payment Id 400120 for invoice:257399, receipt: 482593 by A.A RANO NIGERIA LIMITED','2023-01-17 12:47:16','',''),('1','57',4941607,'','supplier','76',0.00,86614.80,'Payment Id 400120 for invoice:257399, receipt: 482593 by A.A RANO NIGERIA LIMITED','2023-01-17 12:47:16','',''),('1','57',4941608,'','2','4067',259116.00,0.00,'Payment Id 400119 for invoice:257401, receipt: 257401 by A.A RANO NIGERIA LIMITED','2023-01-17 12:47:16','',''),('1','57',4941609,'','supplier','76',0.00,259116.00,'Payment Id 400119 for invoice:257401, receipt: 257401 by A.A RANO NIGERIA LIMITED','2023-01-17 12:47:16','',''),('1','57',4941610,'','2','4067',45110.00,0.00,'Payment Id 400118 for invoice:257401, receipt: 257401 by A.A RANO NIGERIA LIMITED','2023-01-17 12:47:16','',''),('1','57',4941611,'','supplier','76',0.00,45110.00,'Payment Id 400118 for invoice:257401, receipt: 257401 by A.A RANO NIGERIA LIMITED','2023-01-17 12:47:16','',''),('1','57',4941612,'','2','4103',500000.00,0.00,'Payment Id 400109 for invoice:257394, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-01-17 12:49:20','',''),('1','57',4941613,'','supplier','76',0.00,500000.00,'Payment Id 400109 for invoice:257394, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-01-17 12:49:20','',''),('1','57',4941614,'','2','4103',392490.00,0.00,'Payment Id 400107 for invoice:257392, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-01-17 12:49:20','',''),('1','57',4941615,'','supplier','76',0.00,392490.00,'Payment Id 400107 for invoice:257392, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-01-17 12:49:20','',''),('1','57',4941616,'','2','4067',766665.00,0.00,'Payment Id 400098 for invoice:257384, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-01-17 12:49:20','',''),('1','57',4941617,'','supplier','76',0.00,766665.00,'Payment Id 400098 for invoice:257384, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-01-17 12:49:20','',''),('1','57',4941618,'','2','4067',220650.00,0.00,'Payment Id 400117 for invoice:257401, receipt: 256401 by A.A RANO NIGERIA LIMITED','2023-01-17 12:55:59','',''),('1','57',4941619,'','supplier','76',0.00,220650.00,'Payment Id 400117 for invoice:257401, receipt: 256401 by A.A RANO NIGERIA LIMITED','2023-01-17 12:55:59','',''),('1','57',4941620,'','2','4103',500000.00,0.00,'Payment Id 400115 for invoice:257390, receipt: 250881 by A.A RANO NIGERIA LIMITED','2023-01-17 12:55:59','',''),('1','57',4941621,'','supplier','76',0.00,500000.00,'Payment Id 400115 for invoice:257390, receipt: 250881 by A.A RANO NIGERIA LIMITED','2023-01-17 12:55:59','',''),('1','57',4941622,'','2','4067',58400.00,0.00,'Payment Id 400112 for invoice:257397, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-01-17 12:55:59','',''),('1','57',4941623,'','supplier','76',0.00,58400.00,'Payment Id 400112 for invoice:257397, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-01-17 12:55:59','',''),('1','57',4941624,'','2','4067',279566.00,0.00,'Payment Id 400111 for invoice:257396, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-01-17 12:55:59','',''),('1','57',4941625,'','supplier','76',0.00,279566.00,'Payment Id 400111 for invoice:257396, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-01-17 12:55:59','',''),('1','57',4941626,'','20','1253',326505.40,0.00,'Sales from shift 257406 on 2023-01-17 12:59:46 ','2023-01-17 12:59:46','',''),('1','57',4941627,'','6.1','1255',0.00,326505.40,'Sales from shift 257406 on 2023-01-17 12:59:46 ','2023-01-17 12:59:46','',''),('1','57',4941628,'','20','1253',179424.00,0.00,'Sales from shift 257407 on 2023-01-18 09:20:43 ','2023-01-18 09:20:43','',''),('1','57',4941629,'','6.1','1255',0.00,179424.00,'Sales from shift 257407 on 2023-01-18 09:20:43 ','2023-01-18 09:20:43','',''),('1','57',4941630,'','20','1253',165682.40,0.00,'Sales from shift 257408 on 2023-01-19 08:43:24 ','2023-01-19 08:43:24','',''),('1','57',4941631,'','6.1','1255',0.00,165682.40,'Sales from shift 257408 on 2023-01-19 08:43:24 ','2023-01-19 08:43:24','',''),('1','57',4941632,'','20','1253',259710.90,0.00,'Sales from shift 257409 on 2023-01-19 11:23:13 ','2023-01-19 11:23:13','',''),('1','57',4941633,'','6.1','1255',0.00,259710.90,'Sales from shift 257409 on 2023-01-19 11:23:13 ','2023-01-19 11:23:13','',''),('1','57',4941634,'','20','1253',1195136.50,0.00,'Sales from shift 257410 on 2023-01-19 14:45:30 ','2023-01-19 14:45:30','',''),('1','57',4941635,'','6.1','1255',0.00,1195136.50,'Sales from shift 257410 on 2023-01-19 14:45:30 ','2023-01-19 14:45:30','',''),('1','57',4941636,'','20','1253',50649.90,0.00,'Sales from shift 257411 on 2023-01-20 08:52:30 ','2023-01-20 08:52:30','',''),('1','57',4941637,'','6.1','1255',0.00,50649.90,'Sales from shift 257411 on 2023-01-20 08:52:30 ','2023-01-20 08:52:30','',''),('1','57',4941638,'','20','1253',168103.20,0.00,'Sales from shift 257412 on 2023-01-20 12:51:06 ','2023-01-20 12:51:06','',''),('1','57',4941639,'','6.1','1255',0.00,168103.20,'Sales from shift 257412 on 2023-01-20 12:51:06 ','2023-01-20 12:51:06','',''),('1','57',4941640,'','20','1253',493852.10,0.00,'Sales from shift 257413 on 2023-01-20 13:00:04 ','2023-01-20 13:00:04','',''),('1','57',4941641,'','6.1','1255',0.00,493852.10,'Sales from shift 257413 on 2023-01-20 13:00:04 ','2023-01-20 13:00:04','',''),('1','57',4941642,'','20','1253',270364.20,0.00,'Sales from shift 257414 on 2023-01-21 17:46:54 ','2023-01-21 17:46:54','',''),('1','57',4941643,'','6.1','1255',0.00,270364.20,'Sales from shift 257414 on 2023-01-21 17:46:54 ','2023-01-21 17:46:54','',''),('1','57',4941644,'','20','1253',282156.70,0.00,'Sales from shift 257415 on 2023-01-22 09:55:48 ','2023-01-22 09:55:48','',''),('1','57',4941645,'','6.1','1255',0.00,282156.70,'Sales from shift 257415 on 2023-01-22 09:55:48 ','2023-01-22 09:55:48','',''),('1','57',4941646,'','20','1253',1134216.00,0.00,'Sales from shift 257416 on 2023-01-22 18:33:41 ','2023-01-22 18:33:41','',''),('1','57',4941647,'','6.1','1255',0.00,1134216.00,'Sales from shift 257416 on 2023-01-22 18:33:41 ','2023-01-22 18:33:41','',''),('1','57',4941648,'','20','1253',104681.80,0.00,'Sales from shift 257417 on 2023-01-23 10:51:47 ','2023-01-23 10:51:47','',''),('1','57',4941649,'','6.1','1255',0.00,104681.80,'Sales from shift 257417 on 2023-01-23 10:51:47 ','2023-01-23 10:51:47','',''),('1','57',4941650,'','2','4067',0.00,372080.00,'Payment Id 400096 for invoice:257379, receipt: 257379 by A.A RANO NIGERIA LIMITED','2023-01-24 09:39:34','',''),('1','57',4941651,'','supplier','76',372080.00,0.00,'Payment Id 400096 for invoice:257379, receipt: 257379 by A.A RANO NIGERIA LIMITED','2023-01-24 09:39:34','',''),('1','57',4941652,'','20','1253',669458.00,0.00,'Sales from shift 257418 on 2023-01-24 14:16:07 ','2023-01-24 14:16:07','',''),('1','57',4941653,'','6.1','1255',0.00,669458.00,'Sales from shift 257418 on 2023-01-24 14:16:07 ','2023-01-24 14:16:07','',''),('1','57',4941654,'','20','1253',789198.60,0.00,'Sales from shift 257419 on 2023-01-24 19:08:43 ','2023-01-24 19:08:43','',''),('1','57',4941655,'','6.1','1255',0.00,789198.60,'Sales from shift 257419 on 2023-01-24 19:08:43 ','2023-01-24 19:08:43','',''),('1','57',4941656,'','20','1253',304210.90,0.00,'Sales from shift 257420 on 2023-01-25 09:54:01 ','2023-01-25 09:54:01','',''),('1','57',4941657,'','6.1','1255',0.00,304210.90,'Sales from shift 257420 on 2023-01-25 09:54:01 ','2023-01-25 09:54:01','',''),('1','57',4941658,'','2','4067',1367270.00,0.00,'Payment Id 400128 for invoice:257405, receipt: 482588 by A.A RANO NIGERIA LIMITED','2023-01-25 10:59:05','',''),('1','57',4941659,'','supplier','76',0.00,1367270.00,'Payment Id 400128 for invoice:257405, receipt: 482588 by A.A RANO NIGERIA LIMITED','2023-01-25 10:59:05','',''),('1','57',4941660,'','2','4067',168103.00,0.00,'Payment Id 400139 for invoice:257412, receipt: 399785 by A.A RANO NIGERIA LIMITED','2023-01-25 11:05:24','',''),('1','57',4941661,'','supplier','76',0.00,168103.00,'Payment Id 400139 for invoice:257412, receipt: 399785 by A.A RANO NIGERIA LIMITED','2023-01-25 11:05:24','',''),('1','57',4941662,'','2','4067',168103.00,0.00,'Payment Id 400138 for invoice:257412, receipt: 398785 by A.A RANO NIGERIA LIMITED','2023-01-25 11:05:24','',''),('1','57',4941663,'','supplier','76',0.00,168103.00,'Payment Id 400138 for invoice:257412, receipt: 398785 by A.A RANO NIGERIA LIMITED','2023-01-25 11:05:24','',''),('1','57',4941664,'','2','4067',1195136.00,0.00,'Payment Id 400137 for invoice:257410, receipt: 482228 by A.A RANO NIGERIA LIMITED','2023-01-25 11:05:24','',''),('1','57',4941665,'','supplier','76',0.00,1195136.00,'Payment Id 400137 for invoice:257410, receipt: 482228 by A.A RANO NIGERIA LIMITED','2023-01-25 11:05:24','',''),('1','57',4941666,'','2','4067',50649.00,0.00,'Payment Id 400133 for invoice:257410, receipt: 482226 by A.A RANO NIGERIA LIMITED','2023-01-25 11:05:24','',''),('1','57',4941667,'','supplier','76',0.00,50649.00,'Payment Id 400133 for invoice:257410, receipt: 482226 by A.A RANO NIGERIA LIMITED','2023-01-25 11:05:24','',''),('1','57',4941668,'','2','4067',179424.00,0.00,'Payment Id 400132 for invoice:257407, receipt: 483180 by A.A RANO NIGERIA LIMITED','2023-01-25 11:05:24','',''),('1','57',4941669,'','supplier','76',0.00,179424.00,'Payment Id 400132 for invoice:257407, receipt: 483180 by A.A RANO NIGERIA LIMITED','2023-01-25 11:05:24','',''),('1','57',4941670,'','2','4103',179424.00,0.00,'Payment Id 400131 for invoice:257406, receipt: 482180 by A.A RANO NIGERIA LIMITED','2023-01-25 11:05:24','',''),('1','57',4941671,'','supplier','76',0.00,179424.00,'Payment Id 400131 for invoice:257406, receipt: 482180 by A.A RANO NIGERIA LIMITED','2023-01-25 11:05:24','',''),('1','57',4941672,'','2','4067',259710.00,0.00,'Payment Id 400130 for invoice:257407, receipt: 482225 by A.A RANO NIGERIA LIMITED','2023-01-25 11:05:24','',''),('1','57',4941673,'','supplier','76',0.00,259710.00,'Payment Id 400130 for invoice:257407, receipt: 482225 by A.A RANO NIGERIA LIMITED','2023-01-25 11:05:24','',''),('1','57',4941674,'','2','4067',669459.00,0.00,'Payment Id 400148 for invoice:257418, receipt: 482202 by A.A RANO NIGERIA LIMITED','2023-01-25 11:12:35','',''),('1','57',4941675,'','supplier','76',0.00,669459.00,'Payment Id 400148 for invoice:257418, receipt: 482202 by A.A RANO NIGERIA LIMITED','2023-01-25 11:12:35','',''),('1','57',4941676,'','2','4067',14075.00,0.00,'Payment Id 400146 for invoice:257416, receipt: 539471 by A.A RANO NIGERIA LIMITED','2023-01-25 11:12:35','',''),('1','57',4941677,'','supplier','76',0.00,14075.00,'Payment Id 400146 for invoice:257416, receipt: 539471 by A.A RANO NIGERIA LIMITED','2023-01-25 11:12:35','',''),('1','57',4941678,'','2','4067',669459.00,0.00,'Payment Id 400145 for invoice:257416, receipt: 482201 by A.A RANO NIGERIA LIMITED','2023-01-25 11:12:35','',''),('1','57',4941679,'','supplier','76',0.00,669459.00,'Payment Id 400145 for invoice:257416, receipt: 482201 by A.A RANO NIGERIA LIMITED','2023-01-25 11:12:35','',''),('1','57',4941680,'','2','4067',1134216.00,0.00,'Payment Id 400144 for invoice:257416, receipt: 482263 by A.A RANO NIGERIA LIMITED','2023-01-25 11:12:35','',''),('1','57',4941681,'','supplier','76',0.00,1134216.00,'Payment Id 400144 for invoice:257416, receipt: 482263 by A.A RANO NIGERIA LIMITED','2023-01-25 11:12:35','',''),('1','57',4941682,'','2','4103',493852.00,0.00,'Payment Id 400142 for invoice:257413, receipt: 399789 by A.A RANO NIGERIA LIMITED','2023-01-25 11:12:35','',''),('1','57',4941683,'','supplier','76',0.00,493852.00,'Payment Id 400142 for invoice:257413, receipt: 399789 by A.A RANO NIGERIA LIMITED','2023-01-25 11:12:35','',''),('1','57',4941684,'','2','4067',493852.00,0.00,'Payment Id 400140 for invoice:257413, receipt: 398786 by A.A RANO NIGERIA LIMITED','2023-01-25 11:12:35','',''),('1','57',4941685,'','supplier','76',0.00,493852.00,'Payment Id 400140 for invoice:257413, receipt: 398786 by A.A RANO NIGERIA LIMITED','2023-01-25 11:12:35','',''),('1','57',4941686,'','2','4103',104681.00,0.00,'Payment Id 400147 for invoice:257417, receipt: 539475 by A.A RANO NIGERIA LIMITED','2023-01-25 11:43:48','',''),('1','57',4941687,'','supplier','76',0.00,104681.00,'Payment Id 400147 for invoice:257417, receipt: 539475 by A.A RANO NIGERIA LIMITED','2023-01-25 11:43:48','',''),('1','57',4941688,'','2','4103',270364.00,0.00,'Payment Id 400141 for invoice:257414, receipt: 399787 by A.A RANO NIGERIA LIMITED','2023-01-25 11:43:48','',''),('1','57',4941689,'','supplier','76',0.00,270364.00,'Payment Id 400141 for invoice:257414, receipt: 399787 by A.A RANO NIGERIA LIMITED','2023-01-25 11:43:48','',''),('1','57',4941690,'','2','4103',326505.00,0.00,'Payment Id 400136 for invoice:257410, receipt: 482224 by A.A RANO NIGERIA LIMITED','2023-01-25 11:43:48','',''),('1','57',4941691,'','supplier','76',0.00,326505.00,'Payment Id 400136 for invoice:257410, receipt: 482224 by A.A RANO NIGERIA LIMITED','2023-01-25 11:43:48','',''),('1','57',4941692,'','2','4103',3265.05,0.00,'Payment Id 400135 for invoice:257410, receipt: 482223 by A.A RANO NIGERIA LIMITED','2023-01-25 11:43:48','',''),('1','57',4941693,'','supplier','76',0.00,3265.05,'Payment Id 400135 for invoice:257410, receipt: 482223 by A.A RANO NIGERIA LIMITED','2023-01-25 11:43:48','',''),('1','57',4941694,'','2','4103',1626.82,0.00,'Payment Id 400134 for invoice:257410, receipt: 482221 by A.A RANO NIGERIA LIMITED','2023-01-25 11:43:48','',''),('1','57',4941695,'','supplier','76',0.00,1626.82,'Payment Id 400134 for invoice:257410, receipt: 482221 by A.A RANO NIGERIA LIMITED','2023-01-25 11:43:48','',''),('1','57',4941696,'','2','4103',282159.00,0.00,'Payment Id 400149 for invoice:257415, receipt: 398780 by A.A RANO NIGERIA LIMITED','2023-01-25 12:01:12','',''),('1','57',4941697,'','supplier','76',0.00,282159.00,'Payment Id 400149 for invoice:257415, receipt: 398780 by A.A RANO NIGERIA LIMITED','2023-01-25 12:01:12','',''),('1','57',4941698,'','20','1253',478481.80,0.00,'Sales from shift 257421 on 2023-01-25 13:55:11 ','2023-01-25 13:55:11','',''),('1','57',4941699,'','6.1','1255',0.00,478481.80,'Sales from shift 257421 on 2023-01-25 13:55:11 ','2023-01-25 13:55:11','',''),('1','57',4941700,'','2','4103',14075.00,0.00,'Payment Id 400154 for invoice:257420, receipt: 433979 by A.A RANO NIGERIA LIMITED','2023-01-25 16:25:55','',''),('1','57',4941701,'','supplier','76',0.00,14075.00,'Payment Id 400154 for invoice:257420, receipt: 433979 by A.A RANO NIGERIA LIMITED','2023-01-25 16:25:55','',''),('1','57',4941702,'','20','1253',511367.30,0.00,'Sales from shift 257422 on 2023-01-25 20:33:01 ','2023-01-25 20:33:01','',''),('1','57',4941703,'','6.1','1255',0.00,511367.30,'Sales from shift 257422 on 2023-01-25 20:33:01 ','2023-01-25 20:33:01','',''),('1','57',4941704,'','2','4103',289188.00,0.00,'Payment Id 400150 for invoice:257419, receipt: 433972 by A.A RANO NIGERIA LIMITED','2023-01-26 16:55:44','',''),('1','57',4941705,'','supplier','76',0.00,289188.00,'Payment Id 400150 for invoice:257419, receipt: 433972 by A.A RANO NIGERIA LIMITED','2023-01-26 16:55:44','',''),('1','57',4941706,'','2','4067',146417.00,0.00,'Payment Id 400156 for invoice:257421, receipt: 433973 by A.A RANO NIGERIA LIMITED','2023-01-26 16:59:03','',''),('1','57',4941707,'','supplier','76',0.00,146417.00,'Payment Id 400156 for invoice:257421, receipt: 433973 by A.A RANO NIGERIA LIMITED','2023-01-26 16:59:03','',''),('1','57',4941708,'','2','4067',285185.00,0.00,'Payment Id 400155 for invoice:257420, receipt: 433976 by A.A RANO NIGERIA LIMITED','2023-01-26 16:59:03','',''),('1','57',4941709,'','supplier','76',0.00,285185.00,'Payment Id 400155 for invoice:257420, receipt: 433976 by A.A RANO NIGERIA LIMITED','2023-01-26 16:59:03','',''),('1','57',4941710,'','20','1253',357201.50,0.00,'Sales from shift 257423 on 2023-01-27 10:48:24 ','2023-01-27 10:48:24','',''),('1','57',4941711,'','6.1','1255',0.00,357201.50,'Sales from shift 257423 on 2023-01-27 10:48:24 ','2023-01-27 10:48:24','',''),('1','57',4941712,'','20','1253',286615.60,0.00,'Sales from shift 257424 on 2023-01-27 12:01:11 ','2023-01-27 12:01:11','',''),('1','57',4941713,'','6.1','1255',0.00,286615.60,'Sales from shift 257424 on 2023-01-27 12:01:11 ','2023-01-27 12:01:11','',''),('1','57',4941714,'','20','1253',312603.60,0.00,'Sales from shift 257425 on 2023-01-27 23:39:31 ','2023-01-27 23:39:31','',''),('1','57',4941715,'','6.1','1255',0.00,312603.60,'Sales from shift 257425 on 2023-01-27 23:39:31 ','2023-01-27 23:39:31','',''),('1','57',4941716,'','2','4103',13500.00,0.00,'Payment Id 400158 for invoice:257418, receipt: 32222 by A.A RANO NIGERIA LIMITED','2023-01-28 15:54:45','',''),('1','57',4941717,'','supplier','76',0.00,13500.00,'Payment Id 400158 for invoice:257418, receipt: 32222 by A.A RANO NIGERIA LIMITED','2023-01-28 15:54:45','',''),('1','57',4941718,'','2','4103',332064.00,0.00,'Payment Id 400157 for invoice:257421, receipt: 433977 by A.A RANO NIGERIA LIMITED','2023-01-28 15:54:45','',''),('1','57',4941719,'','supplier','76',0.00,332064.00,'Payment Id 400157 for invoice:257421, receipt: 433977 by A.A RANO NIGERIA LIMITED','2023-01-28 15:54:45','',''),('1','57',4941720,'','20','1253',321895.20,0.00,'Sales from shift 257426 on 2023-01-29 15:22:53 ','2023-01-29 15:22:53','',''),('1','57',4941721,'','6.1','1255',0.00,321895.20,'Sales from shift 257426 on 2023-01-29 15:22:53 ','2023-01-29 15:22:53','',''),('1','57',4941722,'','20','1253',47214.50,0.00,'Sales from shift 257427 on 2023-01-29 22:54:23 ','2023-01-29 22:54:23','',''),('1','57',4941723,'','6.1','1255',0.00,47214.50,'Sales from shift 257427 on 2023-01-29 22:54:23 ','2023-01-29 22:54:23','',''),('1','57',4941724,'','20','1253',235654.20,0.00,'Sales from shift 257428 on 2023-01-30 09:14:59 ','2023-01-30 09:14:59','',''),('1','57',4941725,'','6.1','1255',0.00,235654.20,'Sales from shift 257428 on 2023-01-30 09:14:59 ','2023-01-30 09:14:59','',''),('1','57',4941726,'','20','1253',487328.40,0.00,'Sales from shift 257429 on 2023-01-30 09:27:29 ','2023-01-30 09:27:29','',''),('1','57',4941727,'','6.1','1255',0.00,487328.40,'Sales from shift 257429 on 2023-01-30 09:27:29 ','2023-01-30 09:27:29','',''),('1','57',4941728,'','20','1253',22250.00,0.00,'Sales from shift 257430 on 2023-01-30 09:42:05 ','2023-01-30 09:42:05','',''),('1','57',4941729,'','6.1','1255',0.00,22250.00,'Sales from shift 257430 on 2023-01-30 09:42:05 ','2023-01-30 09:42:05','',''),('1','57',4941730,'','20','1253',1397.30,0.00,'Sales from shift 257431 on 2023-01-30 10:15:43 ','2023-01-30 10:15:43','',''),('1','57',4941731,'','6.1','1255',0.00,1397.30,'Sales from shift 257431 on 2023-01-30 10:15:43 ','2023-01-30 10:15:43','',''),('1','57',4941732,'','20','1253',29183.10,0.00,'Sales from shift 257432 on 2023-01-30 10:21:28 ','2023-01-30 10:21:28','',''),('1','57',4941733,'','6.1','1255',0.00,29183.10,'Sales from shift 257432 on 2023-01-30 10:21:28 ','2023-01-30 10:21:28','',''),('1','57',4941734,'','2','4103',165682.00,0.00,'Payment Id 400143 for invoice:257417, receipt: 399784 by A.A RANO NIGERIA LIMITED','2023-01-30 12:18:24','',''),('1','57',4941735,'','supplier','76',0.00,165682.00,'Payment Id 400143 for invoice:257417, receipt: 399784 by A.A RANO NIGERIA LIMITED','2023-01-30 12:18:24','',''),('1','57',4941736,'','20','1253',77483.40,0.00,'Sales from shift 257433 on 2023-01-30 18:53:25 ','2023-01-30 18:53:25','',''),('1','57',4941737,'','6.1','1255',0.00,77483.40,'Sales from shift 257433 on 2023-01-30 18:53:25 ','2023-01-30 18:53:25','',''),('1','57',4941738,'','24','1235',0.00,16465000.00,'Purchase Id 89908 for 18,500.00 litters of Diesel - AGO from A.A RANO NIGERIA LIMITED','2023-01-30 19:33:30','',''),('1','57',4941739,'','supplier','76',16465000.00,0.00,'Purchase Id 89908 for 18,500.00 litters of Diesel - AGO from A.A RANO NIGERIA LIMITED','2023-01-30 19:33:30','',''),('1','57',4941740,'','2','4067',259710.00,0.00,'Payment Id 400159 for invoice:257408, receipt: 399785 by A.A RANO NIGERIA LIMITED','2023-01-31 15:00:18','',''),('1','57',4941741,'','supplier','76',0.00,259710.00,'Payment Id 400159 for invoice:257408, receipt: 399785 by A.A RANO NIGERIA LIMITED','2023-01-31 15:00:18','',''),('1','57',4941742,'','20','1253',287613.30,0.00,'Sales from shift 257434 on 2023-01-31 17:16:11 ','2023-01-31 17:16:11','',''),('1','57',4941743,'','6.1','1255',0.00,287613.30,'Sales from shift 257434 on 2023-01-31 17:16:11 ','2023-01-31 17:16:11','',''),('1','57',4941744,'','20','1253',933031.50,0.00,'Sales from shift 257435 on 2023-01-31 20:24:05 ','2023-01-31 20:24:05','',''),('1','57',4941745,'','6.1','1255',0.00,933031.50,'Sales from shift 257435 on 2023-01-31 20:24:05 ','2023-01-31 20:24:05','',''),('1','57',4941746,'','20','1253',787750.20,0.00,'Sales from shift 257436 on 2023-01-31 20:40:24 ','2023-01-31 20:40:24','',''),('1','57',4941747,'','6.1','1255',0.00,787750.20,'Sales from shift 257436 on 2023-01-31 20:40:24 ','2023-01-31 20:40:24','',''),('1','57',4941748,'','20','1253',0.00,0.00,'Sales from shift 257437 on 2023-02-01 22:48:27 ','2023-02-01 22:48:27','',''),('1','57',4941749,'','6.1','1255',0.00,0.00,'Sales from shift 257437 on 2023-02-01 22:48:27 ','2023-02-01 22:48:27','',''),('1','57',4941750,'','20','1253',23411.70,0.00,'Sales from shift 257438 on 2023-02-04 21:48:38 ','2023-02-04 21:48:38','',''),('1','57',4941751,'','6.1','1255',0.00,23411.70,'Sales from shift 257438 on 2023-02-04 21:48:38 ','2023-02-04 21:48:38','',''),('1','57',4941752,'','20','1253',101972.70,0.00,'Sales from shift 257439 on 2023-02-04 22:10:39 ','2023-02-04 22:10:39','',''),('1','57',4941753,'','6.1','1255',0.00,101972.70,'Sales from shift 257439 on 2023-02-04 22:10:39 ','2023-02-04 22:10:39','',''),('1','57',4941754,'','20','1253',319359.60,0.00,'Sales from shift 257440 on 2023-02-04 22:42:19 ','2023-02-04 22:42:19','',''),('1','57',4941755,'','6.1','1255',0.00,319359.60,'Sales from shift 257440 on 2023-02-04 22:42:19 ','2023-02-04 22:42:19','',''),('1','57',4941756,'','2','4103',223603.00,0.00,'Payment Id 400163 for invoice:257434, receipt: 539476 by A.A RANO NIGERIA LIMITED','2023-02-05 13:27:28','',''),('1','57',4941757,'','supplier','76',0.00,223603.00,'Payment Id 400163 for invoice:257434, receipt: 539476 by A.A RANO NIGERIA LIMITED','2023-02-05 13:27:28','',''),('1','57',4941758,'','2','4103',286553.00,0.00,'Payment Id 400162 for invoice:257423, receipt: 53944 by A.A RANO NIGERIA LIMITED','2023-02-05 13:27:28','',''),('1','57',4941759,'','supplier','76',0.00,286553.00,'Payment Id 400162 for invoice:257423, receipt: 53944 by A.A RANO NIGERIA LIMITED','2023-02-05 13:27:28','',''),('1','57',4941760,'','2','4103',357263.00,0.00,'Payment Id 400161 for invoice:257422, receipt: 539473 by A.A RANO NIGERIA LIMITED','2023-02-05 13:27:28','',''),('1','57',4941761,'','supplier','76',0.00,357263.00,'Payment Id 400161 for invoice:257422, receipt: 539473 by A.A RANO NIGERIA LIMITED','2023-02-05 13:27:28','',''),('1','57',4941762,'','2','4103',511367.00,0.00,'Payment Id 400160 for invoice:257421, receipt: 539472 by A.A RANO NIGERIA LIMITED','2023-02-05 13:27:28','',''),('1','57',4941763,'','supplier','76',0.00,511367.00,'Payment Id 400160 for invoice:257421, receipt: 539472 by A.A RANO NIGERIA LIMITED','2023-02-05 13:27:28','',''),('1','57',4941764,'','2','4067',500000.00,0.00,'Payment Id 400151 for invoice:257419, receipt: 433974 by A.A RANO NIGERIA LIMITED','2023-02-05 13:27:28','',''),('1','57',4941765,'','supplier','76',0.00,500000.00,'Payment Id 400151 for invoice:257419, receipt: 433974 by A.A RANO NIGERIA LIMITED','2023-02-05 13:27:28','',''),('1','57',4941766,'','6.1','1255',89000.00,0.00,'Payment Id 400129 for invoice:257405, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-02-05 13:27:28','',''),('1','57',4941767,'','supplier','76',0.00,89000.00,'Payment Id 400129 for invoice:257405, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-02-05 13:27:28','',''),('1','57',4941768,'','6.1','1255',89000.00,0.00,'Payment Id 400099 for invoice:257384, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-02-05 13:27:28','',''),('1','57',4941769,'','supplier','76',0.00,89000.00,'Payment Id 400099 for invoice:257384, receipt: 00 by A.A RANO NIGERIA LIMITED','2023-02-05 13:27:28','',''),('1','57',4941770,'','2','4103',77483.00,0.00,'Payment Id 400172 for invoice:257433, receipt: 482200 by A.A RANO NIGERIA LIMITED','2023-02-05 13:29:43','',''),('1','57',4941771,'','supplier','76',0.00,77483.00,'Payment Id 400172 for invoice:257433, receipt: 482200 by A.A RANO NIGERIA LIMITED','2023-02-05 13:29:43','',''),('1','57',4941772,'','2','4103',29183.00,0.00,'Payment Id 400171 for invoice:257432, receipt: 482209 by A.A RANO NIGERIA LIMITED','2023-02-05 13:29:43','',''),('1','57',4941773,'','supplier','76',0.00,29183.00,'Payment Id 400171 for invoice:257432, receipt: 482209 by A.A RANO NIGERIA LIMITED','2023-02-05 13:29:43','',''),('1','57',4941774,'','2','4103',1397.00,0.00,'Payment Id 400170 for invoice:257431, receipt: 482208 by A.A RANO NIGERIA LIMITED','2023-02-05 13:29:43','',''),('1','57',4941775,'','supplier','76',0.00,1397.00,'Payment Id 400170 for invoice:257431, receipt: 482208 by A.A RANO NIGERIA LIMITED','2023-02-05 13:29:43','',''),('1','57',4941776,'','2','4103',22250.00,0.00,'Payment Id 400169 for invoice:257430, receipt: 482204 by A.A RANO NIGERIA LIMITED','2023-02-05 13:29:43','',''),('1','57',4941777,'','supplier','76',0.00,22250.00,'Payment Id 400169 for invoice:257430, receipt: 482204 by A.A RANO NIGERIA LIMITED','2023-02-05 13:29:43','',''),('1','57',4941778,'','6.1','1255',89000.00,0.00,'Payment Id 400164 for invoice:257434, receipt: 539476 by A.A RANO NIGERIA LIMITED','2023-02-05 13:29:43','',''),('1','57',4941779,'','supplier','76',0.00,89000.00,'Payment Id 400164 for invoice:257434, receipt: 539476 by A.A RANO NIGERIA LIMITED','2023-02-05 13:29:43','',''),('1','57',4941780,'','20','1253',0.00,0.00,'Sales from shift 257441 on 2023-02-05 16:56:42 ','2023-02-05 16:56:42','',''),('1','57',4941781,'','6.1','1255',0.00,0.00,'Sales from shift 257441 on 2023-02-05 16:56:42 ','2023-02-05 16:56:42','',''),('1','57',4941782,'','20','1253',51504.00,0.00,'Sales from shift 257442 on 2023-02-05 20:11:54 ','2023-02-05 20:11:54','',''),('1','57',4941783,'','6.1','1255',0.00,51504.00,'Sales from shift 257442 on 2023-02-05 20:11:54 ','2023-02-05 20:11:54','',''),('1','57',4941784,'','20','1253',605145.90,0.00,'Sales from shift 257443 on 2023-02-06 22:30:13 ','2023-02-06 22:30:13','',''),('1','57',4941785,'','6.1','1255',0.00,605145.90,'Sales from shift 257443 on 2023-02-06 22:30:13 ','2023-02-06 22:30:13','',''),('1','57',4941786,'','20','1253',828996.90,0.00,'Sales from shift 257444 on 2023-02-08 08:54:57 ','2023-02-08 08:54:57','',''),('1','57',4941787,'','6.1','1255',0.00,828996.90,'Sales from shift 257444 on 2023-02-08 08:54:57 ','2023-02-08 08:54:57','',''),('1','57',4941788,'','20','1253',1670930.70,0.00,'Sales from shift 257445 on 2023-02-08 09:05:49 ','2023-02-08 09:05:49','',''),('1','57',4941789,'','6.1','1255',0.00,1670930.70,'Sales from shift 257445 on 2023-02-08 09:05:49 ','2023-02-08 09:05:49','',''),('1','57',4941790,'','20','1253',70600.50,0.00,'Sales from shift 257446 on 2023-02-08 09:11:30 ','2023-02-08 09:11:30','',''),('1','57',4941791,'','6.1','1255',0.00,70600.50,'Sales from shift 257446 on 2023-02-08 09:11:30 ','2023-02-08 09:11:30','',''),('1','57',4941792,'','20','1253',356700.00,0.00,'Sales from shift 257447 on 2023-02-08 09:21:32 ','2023-02-08 09:21:32','',''),('1','57',4941793,'','6.1','1255',0.00,356700.00,'Sales from shift 257447 on 2023-02-08 09:21:32 ','2023-02-08 09:21:32','',''),('1','57',4941794,'','20','1253',64197.30,0.00,'Sales from shift 257448 on 2023-02-08 09:28:50 ','2023-02-08 09:28:50','',''),('1','57',4941795,'','6.1','1255',0.00,64197.30,'Sales from shift 257448 on 2023-02-08 09:28:50 ','2023-02-08 09:28:50','',''),('1','57',4941796,'','20','1253',0.00,0.00,'Sales from shift 257449 on 2023-02-08 09:38:26 ','2023-02-08 09:38:26','',''),('1','57',4941797,'','6.1','1255',0.00,0.00,'Sales from shift 257449 on 2023-02-08 09:38:26 ','2023-02-08 09:38:26','',''),('1','57',4941798,'','20','1253',135502.50,0.00,'Sales from shift 257450 on 2023-02-09 15:39:59 ','2023-02-09 15:39:59','',''),('1','57',4941799,'','6.1','1255',0.00,135502.50,'Sales from shift 257450 on 2023-02-09 15:39:59 ','2023-02-09 15:39:59','',''),('1','57',4941800,'','20','1253',88583.40,0.00,'Sales from shift 257451 on 2023-02-10 13:59:51 ','2023-02-10 13:59:51','',''),('1','57',4941801,'','6.1','1255',0.00,88583.40,'Sales from shift 257451 on 2023-02-10 13:59:51 ','2023-02-10 13:59:51','',''),('1','57',4941802,'','2','4103',319359.00,0.00,'Payment Id 400180 for invoice:257440, receipt: 482218 by A.A RANO NIGERIA LIMITED','2023-02-10 14:22:19','',''),('1','57',4941803,'','supplier','76',0.00,319359.00,'Payment Id 400180 for invoice:257440, receipt: 482218 by A.A RANO NIGERIA LIMITED','2023-02-10 14:22:19','',''),('1','57',4941804,'','2','4103',101972.00,0.00,'Payment Id 400178 for invoice:257439, receipt: 482215 by A.A RANO NIGERIA LIMITED','2023-02-10 14:22:19','',''),('1','57',4941805,'','supplier','76',0.00,101972.00,'Payment Id 400178 for invoice:257439, receipt: 482215 by A.A RANO NIGERIA LIMITED','2023-02-10 14:22:19','',''),('1','57',4941806,'','2','4103',23411.00,0.00,'Payment Id 400177 for invoice:257438, receipt: 482214 by A.A RANO NIGERIA LIMITED','2023-02-10 14:22:19','',''),('1','57',4941807,'','supplier','76',0.00,23411.00,'Payment Id 400177 for invoice:257438, receipt: 482214 by A.A RANO NIGERIA LIMITED','2023-02-10 14:22:19','',''),('1','57',4941808,'','2','4103',787750.00,0.00,'Payment Id 400175 for invoice:257436, receipt: 482211 by A.A RANO NIGERIA LIMITED','2023-02-10 14:22:19','',''),('1','57',4941809,'','supplier','76',0.00,787750.00,'Payment Id 400175 for invoice:257436, receipt: 482211 by A.A RANO NIGERIA LIMITED','2023-02-10 14:22:19','',''),('1','57',4941810,'','2','4103',933031.00,0.00,'Payment Id 400174 for invoice:257435, receipt: 482210 by A.A RANO NIGERIA LIMITED','2023-02-10 14:22:19','',''),('1','57',4941811,'','supplier','76',0.00,933031.00,'Payment Id 400174 for invoice:257435, receipt: 482210 by A.A RANO NIGERIA LIMITED','2023-02-10 14:22:19','',''),('1','57',4941812,'','2','4103',287613.00,0.00,'Payment Id 400173 for invoice:257435, receipt: 482200 by A.A RANO NIGERIA LIMITED','2023-02-10 14:22:19','',''),('1','57',4941813,'','supplier','76',0.00,287613.00,'Payment Id 400173 for invoice:257435, receipt: 482200 by A.A RANO NIGERIA LIMITED','2023-02-10 14:22:19','',''),('1','57',4941814,'','2','4103',487328.00,0.00,'Payment Id 400168 for invoice:257429, receipt: 539499 by A.A RANO NIGERIA LIMITED','2023-02-10 14:22:19','',''),('1','57',4941815,'','supplier','76',0.00,487328.00,'Payment Id 400168 for invoice:257429, receipt: 539499 by A.A RANO NIGERIA LIMITED','2023-02-10 14:22:19','',''),('1','57',4941816,'','2','4103',235654.00,0.00,'Payment Id 400167 for invoice:257428, receipt: 539479 by A.A RANO NIGERIA LIMITED','2023-02-10 14:22:20','',''),('1','57',4941817,'','supplier','76',0.00,235654.00,'Payment Id 400167 for invoice:257428, receipt: 539479 by A.A RANO NIGERIA LIMITED','2023-02-10 14:22:20','',''),('1','57',4941818,'','2','4103',47214.00,0.00,'Payment Id 400166 for invoice:257436, receipt: 539478 by A.A RANO NIGERIA LIMITED','2023-02-10 14:24:11','',''),('1','57',4941819,'','supplier','76',0.00,47214.00,'Payment Id 400166 for invoice:257436, receipt: 539478 by A.A RANO NIGERIA LIMITED','2023-02-10 14:24:11','',''),('1','57',4941820,'','2','4103',321895.00,0.00,'Payment Id 400165 for invoice:257425, receipt: 539477 by A.A RANO NIGERIA LIMITED','2023-02-10 14:24:11','',''),('1','57',4941821,'','supplier','76',0.00,321895.00,'Payment Id 400165 for invoice:257425, receipt: 539477 by A.A RANO NIGERIA LIMITED','2023-02-10 14:24:11','',''),('1','57',4941822,'','2','4103',135502.00,0.00,'Payment Id 400190 for invoice:257450, receipt: 398787 by A.A RANO NIGERIA LIMITED','2023-02-10 14:27:29','',''),('1','57',4941823,'','supplier','76',0.00,135502.00,'Payment Id 400190 for invoice:257450, receipt: 398787 by A.A RANO NIGERIA LIMITED','2023-02-10 14:27:29','',''),('1','57',4941824,'','2','4103',64197.00,0.00,'Payment Id 400187 for invoice:257448, receipt: 399781 by A.A RANO NIGERIA LIMITED','2023-02-10 14:27:30','',''),('1','57',4941825,'','supplier','76',0.00,64197.00,'Payment Id 400187 for invoice:257448, receipt: 399781 by A.A RANO NIGERIA LIMITED','2023-02-10 14:27:30','',''),('1','57',4941826,'','2','4103',356700.00,0.00,'Payment Id 400186 for invoice:257447, receipt: 399780 by A.A RANO NIGERIA LIMITED','2023-02-10 14:27:30','',''),('1','57',4941827,'','supplier','76',0.00,356700.00,'Payment Id 400186 for invoice:257447, receipt: 399780 by A.A RANO NIGERIA LIMITED','2023-02-10 14:27:30','',''),('1','57',4941828,'','2','4103',70600.00,0.00,'Payment Id 400185 for invoice:257446, receipt: 399788 by A.A RANO NIGERIA LIMITED','2023-02-10 14:27:30','',''),('1','57',4941829,'','supplier','76',0.00,70600.00,'Payment Id 400185 for invoice:257446, receipt: 399788 by A.A RANO NIGERIA LIMITED','2023-02-10 14:27:30','',''),('1','57',4941830,'','2','4103',1670930.00,0.00,'Payment Id 400184 for invoice:257445, receipt: 3997877 by A.A RANO NIGERIA LIMITED','2023-02-10 14:27:30','',''),('1','57',4941831,'','supplier','76',0.00,1670930.00,'Payment Id 400184 for invoice:257445, receipt: 3997877 by A.A RANO NIGERIA LIMITED','2023-02-10 14:27:30','',''),('1','57',4941832,'','2','4103',828996.00,0.00,'Payment Id 400183 for invoice:257444, receipt: 399784 by A.A RANO NIGERIA LIMITED','2023-02-10 14:27:30','',''),('1','57',4941833,'','supplier','76',0.00,828996.00,'Payment Id 400183 for invoice:257444, receipt: 399784 by A.A RANO NIGERIA LIMITED','2023-02-10 14:27:30','',''),('1','57',4941834,'','2','4103',605145.00,0.00,'Payment Id 400182 for invoice:257443, receipt: 482212 by A.A RANO NIGERIA LIMITED','2023-02-10 14:27:30','',''),('1','57',4941835,'','supplier','76',0.00,605145.00,'Payment Id 400182 for invoice:257443, receipt: 482212 by A.A RANO NIGERIA LIMITED','2023-02-10 14:27:30','',''),('1','57',4941836,'','2','4103',51504.00,0.00,'Payment Id 400181 for invoice:257442, receipt: 482219 by A.A RANO NIGERIA LIMITED','2023-02-10 14:27:30','',''),('1','57',4941837,'','supplier','76',0.00,51504.00,'Payment Id 400181 for invoice:257442, receipt: 482219 by A.A RANO NIGERIA LIMITED','2023-02-10 14:27:30','',''),('1','57',4941838,'','20','1253',40246.20,0.00,'Sales from shift 257452 on 2023-02-10 19:46:52 ','2023-02-10 19:46:52','',''),('1','57',4941839,'','6.1','1255',0.00,40246.20,'Sales from shift 257452 on 2023-02-10 19:46:52 ','2023-02-10 19:46:52','',''),('1','57',4941840,'','20','1253',6246.60,0.00,'Sales from shift 257453 on 2023-02-10 19:50:34 ','2023-02-10 19:50:34','',''),('1','57',4941841,'','6.1','1255',0.00,6246.60,'Sales from shift 257453 on 2023-02-10 19:50:34 ','2023-02-10 19:50:34','',''),('1','57',4941842,'','20','1253',665410.80,0.00,'Sales from shift 257454 on 2023-02-10 19:56:43 ','2023-02-10 19:56:43','',''),('1','57',4941843,'','6.1','1255',0.00,665410.80,'Sales from shift 257454 on 2023-02-10 19:56:43 ','2023-02-10 19:56:43','',''),('1','57',4941844,'','20','1253',34608.60,0.00,'Sales from shift 257455 on 2023-02-12 19:04:14 ','2023-02-12 19:04:14','',''),('1','57',4941845,'','6.1','1255',0.00,34608.60,'Sales from shift 257455 on 2023-02-12 19:04:14 ','2023-02-12 19:04:14','',''),('1','57',4941846,'','20','1253',1246040.10,0.00,'Sales from shift 257456 on 2023-02-12 19:38:11 ','2023-02-12 19:38:11','',''),('1','57',4941847,'','6.1','1255',0.00,1246040.10,'Sales from shift 257456 on 2023-02-12 19:38:11 ','2023-02-12 19:38:11','',''),('1','57',4941848,'','20','1253',36592.20,0.00,'Sales from shift 257457 on 2023-02-13 21:06:54 ','2023-02-13 21:06:54','',''),('1','57',4941849,'','6.1','1255',0.00,36592.20,'Sales from shift 257457 on 2023-02-13 21:06:54 ','2023-02-13 21:06:54','',''),('1','57',4941850,'','20','1253',904399.80,0.00,'Sales from shift 257458 on 2023-02-14 11:44:17 ','2023-02-14 11:44:17','',''),('1','57',4941851,'','6.1','1255',0.00,904399.80,'Sales from shift 257458 on 2023-02-14 11:44:17 ','2023-02-14 11:44:17','',''),('1','57',4941852,'','20','1253',14407.20,0.00,'Sales from shift 257459 on 2023-02-14 20:34:05 ','2023-02-14 20:34:05','',''),('1','57',4941853,'','6.1','1255',0.00,14407.20,'Sales from shift 257459 on 2023-02-14 20:34:05 ','2023-02-14 20:34:05','',''),('1','57',4941854,'','20','1253',178471.80,0.00,'Sales from shift 257460 on 2023-02-15 10:37:12 ','2023-02-15 10:37:12','',''),('1','57',4941855,'','6.1','1255',0.00,178471.80,'Sales from shift 257460 on 2023-02-15 10:37:12 ','2023-02-15 10:37:12','',''),('1','57',4941856,'','2','4103',34608.00,0.00,'Payment Id 400196 for invoice:257455, receipt: 00585 by A.A RANO NIGERIA LIMITED','2023-02-15 11:25:02','',''),('1','57',4941857,'','supplier','76',0.00,34608.00,'Payment Id 400196 for invoice:257455, receipt: 00585 by A.A RANO NIGERIA LIMITED','2023-02-15 11:25:02','',''),('1','57',4941858,'','2','4103',578410.00,0.00,'Payment Id 400194 for invoice:257454, receipt: 005384 by A.A RANO NIGERIA LIMITED','2023-02-15 11:25:02','',''),('1','57',4941859,'','supplier','76',0.00,578410.00,'Payment Id 400194 for invoice:257454, receipt: 005384 by A.A RANO NIGERIA LIMITED','2023-02-15 11:25:02','',''),('1','57',4941860,'','2','4103',6246.00,0.00,'Payment Id 400193 for invoice:257453, receipt: 005383 by A.A RANO NIGERIA LIMITED','2023-02-15 11:25:02','',''),('1','57',4941861,'','supplier','76',0.00,6246.00,'Payment Id 400193 for invoice:257453, receipt: 005383 by A.A RANO NIGERIA LIMITED','2023-02-15 11:25:02','',''),('1','57',4941862,'','2','4103',88583.00,0.00,'Payment Id 400191 for invoice:257451, receipt: 005381 by A.A RANO NIGERIA LIMITED','2023-02-15 11:25:02','',''),('1','57',4941863,'','supplier','76',0.00,88583.00,'Payment Id 400191 for invoice:257451, receipt: 005381 by A.A RANO NIGERIA LIMITED','2023-02-15 11:25:02','',''),('1','57',4941864,'','6.1','1255',87000.00,0.00,'Payment Id 400195 for invoice:257454, receipt: 00585 by A.A RANO NIGERIA LIMITED','2023-02-15 11:26:41','',''),('1','57',4941865,'','supplier','76',0.00,87000.00,'Payment Id 400195 for invoice:257454, receipt: 00585 by A.A RANO NIGERIA LIMITED','2023-02-15 11:26:41','',''),('1','57',4941866,'','2','4103',40246.00,0.00,'Payment Id 400192 for invoice:257452, receipt: 005382 by A.A RANO NIGERIA LIMITED','2023-02-15 11:34:58','',''),('1','57',4941867,'','supplier','76',0.00,40246.00,'Payment Id 400192 for invoice:257452, receipt: 005382 by A.A RANO NIGERIA LIMITED','2023-02-15 11:34:58','',''),('1','57',4941868,'','20','1253',90854.10,0.00,'Sales from shift 257461 on 2023-02-15 21:54:30 ','2023-02-15 21:54:30','',''),('1','57',4941869,'','6.1','1255',0.00,90854.10,'Sales from shift 257461 on 2023-02-15 21:54:30 ','2023-02-15 21:54:30','',''),('1','57',4941870,'','20','1253',23707.50,0.00,'Sales from shift 257462 on 2023-02-15 22:24:10 ','2023-02-15 22:24:10','',''),('1','57',4941871,'','6.1','1255',0.00,23707.50,'Sales from shift 257462 on 2023-02-15 22:24:10 ','2023-02-15 22:24:10','',''),('1','57',4941872,'','20','1253',0.00,0.00,'Sales from shift 257463 on 2023-02-15 22:28:52 ','2023-02-15 22:28:52','',''),('1','57',4941873,'','6.1','1255',0.00,0.00,'Sales from shift 257463 on 2023-02-15 22:28:52 ','2023-02-15 22:28:52','',''),('1','57',4941874,'','20','1253',50503.50,0.00,'Sales from shift 257464 on 2023-02-15 22:35:12 ','2023-02-15 22:35:12','',''),('1','57',4941875,'','6.1','1255',0.00,50503.50,'Sales from shift 257464 on 2023-02-15 22:35:12 ','2023-02-15 22:35:12','',''),('1','57',4941876,'','20','1253',96700.50,0.00,'Sales from shift 257465 on 2023-02-15 22:41:20 ','2023-02-15 22:41:20','',''),('1','57',4941877,'','6.1','1255',0.00,96700.50,'Sales from shift 257465 on 2023-02-15 22:41:20 ','2023-02-15 22:41:20','',''),('1','57',4941878,'','20','1253',0.00,0.00,'Sales from shift 257466 on 2023-02-17 11:40:37 ','2023-02-17 11:40:37','',''),('1','57',4941879,'','6.1','1255',0.00,0.00,'Sales from shift 257466 on 2023-02-17 11:40:37 ','2023-02-17 11:40:37','',''),('1','57',4941880,'','20','1253',461848.20,0.00,'Sales from shift 257467 on 2023-02-17 18:48:14 ','2023-02-17 18:48:14','',''),('1','57',4941881,'','6.1','1255',0.00,461848.20,'Sales from shift 257467 on 2023-02-17 18:48:14 ','2023-02-17 18:48:14','',''),('1','57',4941882,'','20','1253',129838.80,0.00,'Sales from shift 257468 on 2023-02-17 22:26:01 ','2023-02-17 22:26:01','',''),('1','57',4941883,'','6.1','1255',0.00,129838.80,'Sales from shift 257468 on 2023-02-17 22:26:01 ','2023-02-17 22:26:01','',''),('1','57',4941884,'','20','1253',20610.30,0.00,'Sales from shift 257469 on 2023-02-18 21:31:28 ','2023-02-18 21:31:28','',''),('1','57',4941885,'','6.1','1255',0.00,20610.30,'Sales from shift 257469 on 2023-02-18 21:31:28 ','2023-02-18 21:31:28','',''),('1','57',4941886,'','20','1253',157165.50,0.00,'Sales from shift 257470 on 2023-02-18 21:35:00 ','2023-02-18 21:35:00','',''),('1','57',4941887,'','6.1','1255',0.00,157165.50,'Sales from shift 257470 on 2023-02-18 21:35:00 ','2023-02-18 21:35:00','',''),('1','57',4941888,'','20','1253',0.00,0.00,'Sales from shift 257471 on 2023-02-21 10:55:29 ','2023-02-21 10:55:29','',''),('1','57',4941889,'','6.1','1255',0.00,0.00,'Sales from shift 257471 on 2023-02-21 10:55:29 ','2023-02-21 10:55:29','',''),('1','57',4941890,'','20','1253',10944.60,0.00,'Sales from shift 257472 on 2023-02-21 12:00:24 ','2023-02-21 12:00:24','',''),('1','57',4941891,'','6.1','1255',0.00,10944.60,'Sales from shift 257472 on 2023-02-21 12:00:24 ','2023-02-21 12:00:24','',''),('1','57',4941892,'','20','1253',248350.20,0.00,'Sales from shift 257473 on 2023-02-21 12:07:52 ','2023-02-21 12:07:52','',''),('1','57',4941893,'','6.1','1255',0.00,248350.20,'Sales from shift 257473 on 2023-02-21 12:07:52 ','2023-02-21 12:07:52','',''),('1','57',4941894,'','20','1253',62909.70,0.00,'Sales from shift 257474 on 2023-02-21 15:01:03 ','2023-02-21 15:01:03','',''),('1','57',4941895,'','6.1','1255',0.00,62909.70,'Sales from shift 257474 on 2023-02-21 15:01:03 ','2023-02-21 15:01:03','',''),('1','57',4941896,'','20','1253',260634.60,0.00,'Sales from shift 257475 on 2023-02-21 15:06:48 ','2023-02-21 15:06:48','',''),('1','57',4941897,'','6.1','1255',0.00,260634.60,'Sales from shift 257475 on 2023-02-21 15:06:48 ','2023-02-21 15:06:48','',''),('1','57',4941898,'','20','1253',258050.70,0.00,'Sales from shift 257476 on 2023-02-21 16:11:04 ','2023-02-21 16:11:04','',''),('1','57',4941899,'','6.1','1255',0.00,258050.70,'Sales from shift 257476 on 2023-02-21 16:11:04 ','2023-02-21 16:11:04','',''),('1','57',4941900,'','20','1253',90737.50,0.00,'Sales from shift 257477 on 2023-02-22 19:14:05 ','2023-02-22 19:14:05','',''),('1','57',4941901,'','6.1','1255',0.00,90737.50,'Sales from shift 257477 on 2023-02-22 19:14:05 ','2023-02-22 19:14:05','',''),('1','57',4941902,'','20','1253',495499.00,0.00,'Sales from shift 257478 on 2023-02-23 12:10:44 ','2023-02-23 12:10:44','',''),('1','57',4941903,'','6.1','1255',0.00,495499.00,'Sales from shift 257478 on 2023-02-23 12:10:44 ','2023-02-23 12:10:44','',''),('1','57',4941904,'','20','1253',182274.00,0.00,'Sales from shift 257479 on 2023-02-23 20:54:54 ','2023-02-23 20:54:54','',''),('1','57',4941905,'','6.1','1255',0.00,182274.00,'Sales from shift 257479 on 2023-02-23 20:54:54 ','2023-02-23 20:54:54','',''),('1','57',4941906,'','20','1253',289697.00,0.00,'Sales from shift 257480 on 2023-02-23 21:14:00 ','2023-02-23 21:14:00','',''),('1','57',4941907,'','6.1','1255',0.00,289697.00,'Sales from shift 257480 on 2023-02-23 21:14:00 ','2023-02-23 21:14:00','',''),('1','57',4941908,'','20','1253',14541.60,0.00,'Sales from shift 257481 on 2023-02-23 21:29:04 ','2023-02-23 21:29:04','',''),('1','57',4941909,'','6.1','1255',0.00,14541.60,'Sales from shift 257481 on 2023-02-23 21:29:04 ','2023-02-23 21:29:04','',''),('1','57',4941910,'','20','1253',606688.50,0.00,'Sales from shift 257482 on 2023-02-23 22:19:49 ','2023-02-23 22:19:49','',''),('1','57',4941911,'','6.1','1255',0.00,606688.50,'Sales from shift 257482 on 2023-02-23 22:19:49 ','2023-02-23 22:19:49','',''),('1','57',4941912,'','20','1253',49069.60,0.00,'Sales from shift 257483 on 2023-02-25 19:22:16 ','2023-02-25 19:22:16','',''),('1','57',4941913,'','6.1','1255',0.00,49069.60,'Sales from shift 257483 on 2023-02-25 19:22:16 ','2023-02-25 19:22:16','',''),('1','57',4941914,'','20','1253',109966.70,0.00,'Sales from shift 257484 on 2023-02-26 22:26:50 ','2023-02-26 22:26:50','',''),('1','57',4941915,'','6.1','1255',0.00,109966.70,'Sales from shift 257484 on 2023-02-26 22:26:50 ','2023-02-26 22:26:50','',''),('1','57',4941916,'','2','4103',14407.00,0.00,'Payment Id 400200 for invoice:257459, receipt: 555558 by A.A RANO NIGERIA LIMITED','2023-02-27 16:45:08','',''),('1','57',4941917,'','supplier','76',0.00,14407.00,'Payment Id 400200 for invoice:257459, receipt: 555558 by A.A RANO NIGERIA LIMITED','2023-02-27 16:45:08','',''),('1','57',4941918,'','2','4103',904399.00,0.00,'Payment Id 400199 for invoice:257458, receipt: 555557 by A.A RANO NIGERIA LIMITED','2023-02-27 16:45:08','',''),('1','57',4941919,'','supplier','76',0.00,904399.00,'Payment Id 400199 for invoice:257458, receipt: 555557 by A.A RANO NIGERIA LIMITED','2023-02-27 16:45:08','',''),('1','57',4941920,'','2','4103',36592.00,0.00,'Payment Id 400198 for invoice:257457, receipt: 555556 by A.A RANO NIGERIA LIMITED','2023-02-27 16:45:08','',''),('1','57',4941921,'','supplier','76',0.00,36592.00,'Payment Id 400198 for invoice:257457, receipt: 555556 by A.A RANO NIGERIA LIMITED','2023-02-27 16:45:08','',''),('1','57',4941922,'','2','4103',1246040.00,0.00,'Payment Id 400197 for invoice:257456, receipt: 555555 by A.A RANO NIGERIA LIMITED','2023-02-27 16:45:09','',''),('1','57',4941923,'','supplier','76',0.00,1246040.00,'Payment Id 400197 for invoice:257456, receipt: 555555 by A.A RANO NIGERIA LIMITED','2023-02-27 16:45:09','',''),('1','57',4941924,'','2','4103',178471.00,0.00,'Payment Id 400201 for invoice:257460, receipt: 555559 by A.A RANO NIGERIA LIMITED','2023-02-27 16:46:05','',''),('1','57',4941925,'','supplier','76',0.00,178471.00,'Payment Id 400201 for invoice:257460, receipt: 555559 by A.A RANO NIGERIA LIMITED','2023-02-27 16:46:05','',''),('1','57',4941926,'','2','4103',461848.00,0.00,'Payment Id 400210 for invoice:257467, receipt: 539467 by A.A RANO NIGERIA LIMITED','2023-02-27 16:52:22','',''),('1','57',4941927,'','supplier','76',0.00,461848.00,'Payment Id 400210 for invoice:257467, receipt: 539467 by A.A RANO NIGERIA LIMITED','2023-02-27 16:52:22','',''),('1','57',4941928,'','2','4103',96700.00,0.00,'Payment Id 400208 for invoice:257465, receipt: 539468 by A.A RANO NIGERIA LIMITED','2023-02-27 16:52:22','',''),('1','57',4941929,'','supplier','76',0.00,96700.00,'Payment Id 400208 for invoice:257465, receipt: 539468 by A.A RANO NIGERIA LIMITED','2023-02-27 16:52:22','',''),('1','57',4941930,'','2','4103',50503.00,0.00,'Payment Id 400207 for invoice:257464, receipt: 539469 by A.A RANO NIGERIA LIMITED','2023-02-27 16:52:22','',''),('1','57',4941931,'','supplier','76',0.00,50503.00,'Payment Id 400207 for invoice:257464, receipt: 539469 by A.A RANO NIGERIA LIMITED','2023-02-27 16:52:22','',''),('1','57',4941932,'','2','4103',54264.00,0.00,'Payment Id 400205 for invoice:257460, receipt: 555567 by A.A RANO NIGERIA LIMITED','2023-02-27 16:52:22','',''),('1','57',4941933,'','supplier','76',0.00,54264.00,'Payment Id 400205 for invoice:257460, receipt: 555567 by A.A RANO NIGERIA LIMITED','2023-02-27 16:52:22','',''),('1','57',4941934,'','2','4103',23707.00,0.00,'Payment Id 400203 for invoice:257462, receipt: 555561 by A.A RANO NIGERIA LIMITED','2023-02-27 16:52:22','',''),('1','57',4941935,'','supplier','76',0.00,23707.00,'Payment Id 400203 for invoice:257462, receipt: 555561 by A.A RANO NIGERIA LIMITED','2023-02-27 16:52:22','',''),('1','57',4941936,'','2','4103',3737.00,0.00,'Payment Id 400219 for invoice:257477, receipt: 222897 by A.A RANO NIGERIA LIMITED','2023-02-27 16:58:53','',''),('1','57',4941937,'','supplier','76',0.00,3737.00,'Payment Id 400219 for invoice:257477, receipt: 222897 by A.A RANO NIGERIA LIMITED','2023-02-27 16:58:53','',''),('1','57',4941938,'','2','4103',260634.00,0.00,'Payment Id 400218 for invoice:257475, receipt: 482286 by A.A RANO NIGERIA LIMITED','2023-02-27 16:58:53','',''),('1','57',4941939,'','supplier','76',0.00,260634.00,'Payment Id 400218 for invoice:257475, receipt: 482286 by A.A RANO NIGERIA LIMITED','2023-02-27 16:58:53','',''),('1','57',4941940,'','2','4103',62909.00,0.00,'Payment Id 400217 for invoice:257474, receipt: 482275 by A.A RANO NIGERIA LIMITED','2023-02-27 16:58:54','',''),('1','57',4941941,'','supplier','76',0.00,62909.00,'Payment Id 400217 for invoice:257474, receipt: 482275 by A.A RANO NIGERIA LIMITED','2023-02-27 16:58:54','',''),('1','57',4941942,'','2','4103',248350.00,0.00,'Payment Id 400216 for invoice:257473, receipt: 482265 by A.A RANO NIGERIA LIMITED','2023-02-27 16:58:54','',''),('1','57',4941943,'','supplier','76',0.00,248350.00,'Payment Id 400216 for invoice:257473, receipt: 482265 by A.A RANO NIGERIA LIMITED','2023-02-27 16:58:54','',''),('1','57',4941944,'','2','4103',258050.00,0.00,'Payment Id 400215 for invoice:257472, receipt: 482260 by A.A RANO NIGERIA LIMITED','2023-02-27 16:58:54','',''),('1','57',4941945,'','supplier','76',0.00,258050.00,'Payment Id 400215 for invoice:257472, receipt: 482260 by A.A RANO NIGERIA LIMITED','2023-02-27 16:58:54','',''),('1','57',4941946,'','2','4103',10944.00,0.00,'Payment Id 400214 for invoice:257471, receipt: 539496 by A.A RANO NIGERIA LIMITED','2023-02-27 16:58:54','',''),('1','57',4941947,'','supplier','76',0.00,10944.00,'Payment Id 400214 for invoice:257471, receipt: 539496 by A.A RANO NIGERIA LIMITED','2023-02-27 16:58:54','',''),('1','57',4941948,'','2','4103',157165.00,0.00,'Payment Id 400213 for invoice:257470, receipt: 539497 by A.A RANO NIGERIA LIMITED','2023-02-27 16:58:54','',''),('1','57',4941949,'','supplier','76',0.00,157165.00,'Payment Id 400213 for invoice:257470, receipt: 539497 by A.A RANO NIGERIA LIMITED','2023-02-27 16:58:54','',''),('1','57',4941950,'','2','4103',20610.00,0.00,'Payment Id 400212 for invoice:257469, receipt: 539486 by A.A RANO NIGERIA LIMITED','2023-02-27 16:58:54','',''),('1','57',4941951,'','supplier','76',0.00,20610.00,'Payment Id 400212 for invoice:257469, receipt: 539486 by A.A RANO NIGERIA LIMITED','2023-02-27 16:58:54','',''),('1','57',4941952,'','2','4103',129838.00,0.00,'Payment Id 400211 for invoice:257468, receipt: 398789 by A.A RANO NIGERIA LIMITED','2023-02-27 17:14:27','',''),('1','57',4941953,'','supplier','76',0.00,129838.00,'Payment Id 400211 for invoice:257468, receipt: 398789 by A.A RANO NIGERIA LIMITED','2023-02-27 17:14:27','',''),('1','57',4941954,'','20','1253',0.00,0.00,'Sales from shift 257485 on 2023-02-27 17:16:25 ','2023-02-27 17:16:25','',''),('1','57',4941955,'','6.1','1255',0.00,0.00,'Sales from shift 257485 on 2023-02-27 17:16:25 ','2023-02-27 17:16:25','',''),('1','57',4941956,'','20','1253',524186.50,0.00,'Sales from shift 257486 on 2023-02-28 13:07:08 ','2023-02-28 13:07:08','',''),('1','57',4941957,'','6.1','1255',0.00,524186.50,'Sales from shift 257486 on 2023-02-28 13:07:08 ','2023-02-28 13:07:08','',''),('1','57',4941958,'','20','1253',114540.00,0.00,'Sales from shift 257487 on 2023-02-28 14:16:31 ','2023-02-28 14:16:31','',''),('1','57',4941959,'','6.1','1255',0.00,114540.00,'Sales from shift 257487 on 2023-02-28 14:16:31 ','2023-02-28 14:16:31','',''),('1','57',4941960,'','2','4103',109966.00,0.00,'Payment Id 400227 for invoice:257484, receipt: 399778 by A.A RANO NIGERIA LIMITED','2023-02-28 14:54:45','',''),('1','57',4941961,'','supplier','76',0.00,109966.00,'Payment Id 400227 for invoice:257484, receipt: 399778 by A.A RANO NIGERIA LIMITED','2023-02-28 14:54:45','',''),('1','57',4941962,'','2','4103',49069.00,0.00,'Payment Id 400226 for invoice:257483, receipt: 399777 by A.A RANO NIGERIA LIMITED','2023-02-28 14:54:45','',''),('1','57',4941963,'','supplier','76',0.00,49069.00,'Payment Id 400226 for invoice:257483, receipt: 399777 by A.A RANO NIGERIA LIMITED','2023-02-28 14:54:45','',''),('1','57',4941964,'','2','4103',606688.00,0.00,'Payment Id 400225 for invoice:257482, receipt: 444444 by A.A RANO NIGERIA LIMITED','2023-02-28 14:54:45','',''),('1','57',4941965,'','supplier','76',0.00,606688.00,'Payment Id 400225 for invoice:257482, receipt: 444444 by A.A RANO NIGERIA LIMITED','2023-02-28 14:54:45','',''),('1','57',4941966,'','2','4103',14541.00,0.00,'Payment Id 400224 for invoice:257481, receipt: 333333 by A.A RANO NIGERIA LIMITED','2023-02-28 14:54:45','',''),('1','57',4941967,'','supplier','76',0.00,14541.00,'Payment Id 400224 for invoice:257481, receipt: 333333 by A.A RANO NIGERIA LIMITED','2023-02-28 14:54:45','',''),('1','57',4941968,'','2','4103',289697.00,0.00,'Payment Id 400223 for invoice:257482, receipt: 22222 by A.A RANO NIGERIA LIMITED','2023-02-28 14:54:45','',''),('1','57',4941969,'','supplier','76',0.00,289697.00,'Payment Id 400223 for invoice:257482, receipt: 22222 by A.A RANO NIGERIA LIMITED','2023-02-28 14:54:45','',''),('1','57',4941970,'','2','4103',182289.00,0.00,'Payment Id 400222 for invoice:257479, receipt: 433999 by A.A RANO NIGERIA LIMITED','2023-02-28 14:54:45','',''),('1','57',4941971,'','supplier','76',0.00,182289.00,'Payment Id 400222 for invoice:257479, receipt: 433999 by A.A RANO NIGERIA LIMITED','2023-02-28 14:54:45','',''),('1','57',4941972,'','2','4103',54262.00,0.00,'Payment Id 400206 for invoice:257461, receipt: 555563 by A.A RANO NIGERIA LIMITED','2023-02-28 14:57:33','',''),('1','57',4941973,'','supplier','76',0.00,54262.00,'Payment Id 400206 for invoice:257461, receipt: 555563 by A.A RANO NIGERIA LIMITED','2023-02-28 14:57:33','',''),('1','57',4941974,'','2','4103',495499.00,0.00,'Payment Id 400221 for invoice:257478, receipt: 499973 by A.A RANO NIGERIA LIMITED','2023-02-28 15:00:52','',''),('1','57',4941975,'','supplier','76',0.00,495499.00,'Payment Id 400221 for invoice:257478, receipt: 499973 by A.A RANO NIGERIA LIMITED','2023-02-28 15:00:52','',''),('1','57',4941976,'','2','4103',114515.00,0.00,'Payment Id 400231 for invoice:257488, receipt: 483333 by A.A RANO NIGERIA LIMITED','2023-02-28 15:02:52','',''),('1','57',4941977,'','supplier','76',0.00,114515.00,'Payment Id 400231 for invoice:257488, receipt: 483333 by A.A RANO NIGERIA LIMITED','2023-02-28 15:02:52','',''),('1','57',4941978,'','2','4103',90854.00,0.00,'Payment Id 400202 for invoice:257461, receipt: 555560 by A.A RANO NIGERIA LIMITED','2023-02-28 15:14:38','',''),('1','57',4941979,'','supplier','76',0.00,90854.00,'Payment Id 400202 for invoice:257461, receipt: 555560 by A.A RANO NIGERIA LIMITED','2023-02-28 15:14:38','',''),('1','57',4941980,'','6.1','1255',87000.00,0.00,'Payment Id 400220 for invoice:257477, receipt: 222278 by A.A RANO NIGERIA LIMITED','2023-02-28 15:24:43','',''),('1','57',4941981,'','supplier','76',0.00,87000.00,'Payment Id 400220 for invoice:257477, receipt: 222278 by A.A RANO NIGERIA LIMITED','2023-02-28 15:24:43','',''),('1','57',4941982,'','2','4103',0.05,0.00,'Payment Id 400229 for invoice:257486, receipt: 482299 by A.A RANO NIGERIA LIMITED','2023-02-28 15:50:48','',''),('1','57',4941983,'','supplier','76',0.00,0.05,'Payment Id 400229 for invoice:257486, receipt: 482299 by A.A RANO NIGERIA LIMITED','2023-02-28 15:50:48','',''),('1','57',4941984,'','2','4103',0.50,0.00,'Payment Id 400228 for invoice:257485, receipt: 399799 by A.A RANO NIGERIA LIMITED','2023-02-28 15:50:48','',''),('1','57',4941985,'','supplier','76',0.00,0.50,'Payment Id 400228 for invoice:257485, receipt: 399799 by A.A RANO NIGERIA LIMITED','2023-02-28 15:50:48','',''),('1','57',4941986,'','2','4103',0.50,0.00,'Payment Id 400209 for invoice:257466, receipt: 539458 by A.A RANO NIGERIA LIMITED','2023-02-28 15:50:48','',''),('1','57',4941987,'','supplier','76',0.00,0.50,'Payment Id 400209 for invoice:257466, receipt: 539458 by A.A RANO NIGERIA LIMITED','2023-02-28 15:50:48','',''),('1','57',4941988,'','2','4103',0.05,0.00,'Payment Id 400204 for invoice:257463, receipt: 555562 by A.A RANO NIGERIA LIMITED','2023-02-28 15:50:48','',''),('1','57',4941989,'','supplier','76',0.00,0.05,'Payment Id 400204 for invoice:257463, receipt: 555562 by A.A RANO NIGERIA LIMITED','2023-02-28 15:50:48','',''),('1','57',4941990,'','2','4103',0.50,0.00,'Payment Id 400189 for invoice:257449, receipt: 399783 by A.A RANO NIGERIA LIMITED','2023-02-28 15:50:48','',''),('1','57',4941991,'','supplier','76',0.00,0.50,'Payment Id 400189 for invoice:257449, receipt: 399783 by A.A RANO NIGERIA LIMITED','2023-02-28 15:50:48','',''),('1','57',4941992,'','2','4103',0.50,0.00,'Payment Id 400188 for invoice:257449, receipt: 399782 by A.A RANO NIGERIA LIMITED','2023-02-28 15:50:48','',''),('1','57',4941993,'','supplier','76',0.00,0.50,'Payment Id 400188 for invoice:257449, receipt: 399782 by A.A RANO NIGERIA LIMITED','2023-02-28 15:50:48','',''),('1','57',4941994,'','2','4103',0.50,0.00,'Payment Id 400179 for invoice:257440, receipt: 482217 by A.A RANO NIGERIA LIMITED','2023-02-28 15:50:48','',''),('1','57',4941995,'','supplier','76',0.00,0.50,'Payment Id 400179 for invoice:257440, receipt: 482217 by A.A RANO NIGERIA LIMITED','2023-02-28 15:50:48','',''),('1','57',4941996,'','2','4103',0.50,0.00,'Payment Id 400176 for invoice:257437, receipt: 482213 by A.A RANO NIGERIA LIMITED','2023-02-28 15:50:48','',''),('1','57',4941997,'','supplier','76',0.00,0.50,'Payment Id 400176 for invoice:257437, receipt: 482213 by A.A RANO NIGERIA LIMITED','2023-02-28 15:50:48','',''),('1','57',4941998,'','20','1253',269708.50,0.00,'Sales from shift 257488 on 2023-03-01 14:29:27 ','2023-03-01 14:29:27','',''),('1','57',4941999,'','6.1','1255',0.00,269708.50,'Sales from shift 257488 on 2023-03-01 14:29:27 ','2023-03-01 14:29:27','',''),('1','57',4942000,'','20','1253',352086.00,0.00,'Sales from shift 257489 on 2023-03-01 19:29:34 ','2023-03-01 19:29:34','',''),('1','57',4942001,'','6.1','1255',0.00,352086.00,'Sales from shift 257489 on 2023-03-01 19:29:34 ','2023-03-01 19:29:34','',''),('1','57',4942002,'','20','1253',876438.50,0.00,'Sales from shift 257490 on 2023-03-01 20:12:21 ','2023-03-01 20:12:21','',''),('1','57',4942003,'','6.1','1255',0.00,876438.50,'Sales from shift 257490 on 2023-03-01 20:12:21 ','2023-03-01 20:12:21','',''),('1','57',4942004,'','2','4103',524186.00,0.00,'Payment Id 400230 for invoice:257487, receipt: 482999 by A.A RANO NIGERIA LIMITED','2023-03-02 12:21:06','',''),('1','57',4942005,'','supplier','76',0.00,524186.00,'Payment Id 400230 for invoice:257487, receipt: 482999 by A.A RANO NIGERIA LIMITED','2023-03-02 12:21:06','',''),('1','57',4942006,'','20','1253',189439.20,0.00,'Sales from shift 257491 on 2023-03-03 11:59:12 ','2023-03-03 11:59:12','',''),('1','57',4942007,'','6.1','1255',0.00,189439.20,'Sales from shift 257491 on 2023-03-03 11:59:12 ','2023-03-03 11:59:12','',''),('1','57',4942008,'','2','4103',189439.00,0.00,'Payment Id 400235 for invoice:257491, receipt: 222233 by A.A RANO NIGERIA LIMITED','2023-03-06 12:09:04','',''),('1','57',4942009,'','supplier','76',0.00,189439.00,'Payment Id 400235 for invoice:257491, receipt: 222233 by A.A RANO NIGERIA LIMITED','2023-03-06 12:09:04','',''),('1','57',4942010,'','2','4103',269708.00,0.00,'Payment Id 400234 for invoice:257488, receipt: 111111 by A.A RANO NIGERIA LIMITED','2023-03-06 12:11:09','',''),('1','57',4942011,'','supplier','76',0.00,269708.00,'Payment Id 400234 for invoice:257488, receipt: 111111 by A.A RANO NIGERIA LIMITED','2023-03-06 12:11:09','',''),('1','57',4942012,'','2','4103',352086.00,0.00,'Payment Id 400232 for invoice:257489, receipt: 888888 by A.A RANO NIGERIA LIMITED','2023-03-06 12:11:09','',''),('1','57',4942013,'','supplier','76',0.00,352086.00,'Payment Id 400232 for invoice:257489, receipt: 888888 by A.A RANO NIGERIA LIMITED','2023-03-06 12:11:09','',''),('1','57',4942014,'','2','4103',526438.00,0.00,'Payment Id 400236 for invoice:257490, receipt: 222223 by A.A RANO NIGERIA LIMITED','2023-03-08 17:36:08','',''),('1','57',4942015,'','supplier','76',0.00,526438.00,'Payment Id 400236 for invoice:257490, receipt: 222223 by A.A RANO NIGERIA LIMITED','2023-03-08 17:36:08','',''),('1','57',4942016,'','2','4103',350000.00,0.00,'Payment Id 400237 for invoice:257490, receipt: 333334 by A.A RANO NIGERIA LIMITED','2023-03-13 15:19:06','',''),('1','57',4942017,'','supplier','76',0.00,350000.00,'Payment Id 400237 for invoice:257490, receipt: 333334 by A.A RANO NIGERIA LIMITED','2023-03-13 15:19:06','',''),('1','57',4942018,'','2','4103',120333.00,0.00,'Payment Id 400238 for invoice:257492, receipt: 444445 by A.A RANO NIGERIA LIMITED','2023-03-13 15:20:14','',''),('1','57',4942019,'','supplier','76',0.00,120333.00,'Payment Id 400238 for invoice:257492, receipt: 444445 by A.A RANO NIGERIA LIMITED','2023-03-13 15:20:14','',''),('1','57',4942020,'','2','4103',876438.00,0.00,'Payment Id 400233 for invoice:257490, receipt: 888889 by A.A RANO NIGERIA LIMITED','2023-03-13 15:40:45','',''),('1','57',4942021,'','supplier','76',0.00,876438.00,'Payment Id 400233 for invoice:257490, receipt: 888889 by A.A RANO NIGERIA LIMITED','2023-03-13 15:40:45','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=176 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (173,'1','57','PMS','Petrol','Litres',1,245.00,245.00,245.00,245.00,0.00,0,'2017-04-25 16:02:20','139','139','2017-05-01 16:48:14',1),(174,'1','57','AGO','Diesel','Litres',1,830.00,830.00,830.00,830.00,0.00,0,'2017-04-25 16:02:36','139','716','2022-02-12 16:30:12',1),(175,'1','57','DPK','Kerosene','Litres',1,415.00,415.00,415.00,415.00,0.00,0,'2017-04-25 16:02:55','139','139','2017-05-02 11:16:27',1);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=17751 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (16933,'1','57',173,165.00,165.00,165.00,165.00,'','2021-11-20 13:46:23','178'),(16951,'1','57',174,350.00,350.00,350.00,350.00,'NEW PUMP OF AGO','2021-11-22 10:06:51','716'),(17720,'1','57',175,355.00,355.00,355.00,355.00,'New AGO Pump Price','2022-01-21 10:02:33','716'),(17721,'1','57',174,355.00,355.00,355.00,355.00,'NEW AGO PUMP PRICE','2022-01-21 10:06:20','716'),(17724,'1','57',175,150.00,150.00,150.00,150.00,'dpk new pump price','2022-01-21 10:12:49','716'),(17725,'1','57',174,365.00,355.00,0.00,0.00,'Cost from purchase id #89898','2022-02-04 09:29:10','202'),(17726,'1','57',174,380.00,380.00,380.00,380.00,'New ago pump price','2022-02-04 15:59:02','716'),(17727,'1','57',174,390.00,390.00,390.00,390.00,'NEW AGO PUMP PRICE ','2022-02-09 22:31:37','716'),(17728,'1','57',174,400.00,400.00,400.00,400.00,'','2022-02-12 16:34:15','716'),(17729,'1','57',175,410.00,410.00,410.00,410.00,'NEYU AGO PIRACY 1919','2022-02-18 11:56:04','716'),(17730,'1','57',175,410.00,410.00,410.00,410.00,'NEYU AGO PIRACY 1919','2022-02-18 12:12:21','716'),(17731,'1','57',175,410.00,410.00,410.00,410.00,'NEYU AGO PIRACY 1919','2022-02-18 12:14:54','716'),(17732,'1','57',175,410.00,410.00,410.00,410.00,'NEYU AGO PIRACY 1919','2022-02-18 12:16:32','716'),(17733,'1','57',174,410.00,410.00,410.00,410.00,'NEYU AGO PIRACY 1919','2022-02-18 12:21:16','716'),(17734,'1','57',175,420.00,420.00,420.00,420.00,'NEYU AGO PIRACY 1919','2022-02-25 15:15:40','716'),(17735,'1','57',175,415.00,415.00,415.00,415.00,'NEYU AGO PIRACY 1919','2022-02-25 15:24:27','716'),(17736,'1','57',174,415.00,415.00,415.00,415.00,'NEYU AGO PIRACY 1919','2022-02-26 16:59:13','716'),(17737,'1','57',174,430.00,430.00,430.00,430.00,'NEW AGO PUMP PRICE ','2022-03-03 21:43:03','716'),(17738,'1','57',174,460.00,460.00,460.00,460.00,'Neyou  firers op  ago','2022-03-04 17:17:46','716'),(17739,'1','57',174,500.00,500.00,500.00,500.00,'Neyou  firers op  ago','2022-03-05 15:49:52','716'),(17740,'1','57',174,600.00,600.00,600.00,600.00,'Neyou  firers op  ago','2022-03-08 15:51:58','716'),(17741,'1','57',174,700.00,700.00,700.00,700.00,'Neyou  firers op  ago','2022-03-27 17:47:01','716'),(17742,'1','57',174,665.00,665.00,665.00,665.00,'Neyou  firers op  ago','2022-04-20 12:06:44','716'),(17743,'1','57',174,800.00,800.00,800.00,800.00,'NEW AGO PUMP PRICE','2022-09-02 16:56:37','716'),(17744,'1','57',173,190.00,190.00,190.00,190.00,'New pomp price','2022-09-04 12:46:28','716'),(17745,'1','57',173,245.00,245.00,245.00,245.00,'New pomp price','2022-11-15 15:40:02','716'),(17746,'1','57',174,890.00,800.00,0.00,0.00,'Cost from purchase id #89907','2023-01-04 11:55:19','202'),(17747,'1','57',174,890.00,890.00,890.00,890.00,'New pomp price','2023-01-05 21:41:24','716'),(17748,'1','57',174,870.00,870.00,870.00,870.00,'New pomp price','2023-01-31 09:10:53','716'),(17749,'1','57',174,850.00,850.00,850.00,850.00,'New pomp price','2023-02-21 16:04:37','716'),(17750,'1','57',174,830.00,830.00,830.00,830.00,'New pomp price','2023-02-23 21:18:35','716');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=89909 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (81033,'1','57','2021-11-20',173,76,165.00,30000.00,0.00,0.00,4950000.00,0.00,'','52140','TRN 21 YZ','','','','2021-11-20 15:26:58',15,'PURCHASE OF PMS','716','','0000-00-00 00:00:00','202','2021-11-21 09:50:20'),(88117,'1','57','2021-12-24',174,76,350.00,17000.00,0.00,0.00,5950000.00,0.00,'','21144','TRN 630 YZ','','','','2021-12-25 11:27:08',15,'PURCHASE OF AGO ','716','','0000-00-00 00:00:00','202','2021-12-25 11:53:58'),(88468,'1','57','2021-12-30',174,76,350.00,30000.00,0.00,0.00,10500000.00,0.00,'','00','NSR 515 ZY','','','','2021-12-30 13:49:56',15,'PURCHASE OF AGO','716','','0000-00-00 00:00:00','202','2021-12-30 13:51:35'),(89889,'1','57','2022-01-18',174,76,350.00,20000.00,0.00,0.00,7000000.00,0.00,'','00','RAN 432 XA','','','','2022-01-18 20:54:14',15,'PURCHASE OF AGO','716','','0000-00-00 00:00:00','202','2022-01-19 10:42:37'),(89898,'1','57','2022-02-03',174,76,365.00,20000.00,0.00,0.00,7300000.00,0.00,'','00','Gwl 101XB','','','','2022-02-03 22:27:25',15,'PLACE Op AGO','716','','0000-00-00 00:00:00','202','2022-02-04 09:29:10'),(89899,'1','57','2022-02-10',174,76,390.00,32400.00,0.00,0.00,12636000.00,0.00,'','00','BCH 427 XA','','','','2022-02-10 11:32:22',15,'PURCHASE OP AGO','716','','0000-00-00 00:00:00','202','2022-02-10 11:45:20'),(89900,'1','57','2022-02-23',174,76,410.00,20000.00,0.00,0.00,8200000.00,0.00,'','00','Ran 436xa','','','','2022-02-24 12:52:12',15,'','716','','0000-00-00 00:00:00','202','2022-02-24 12:54:27'),(89902,'1','57','2022-03-03',174,76,430.00,23000.00,0.00,0.00,9890000.00,0.00,'','001','RAN 807 XA','','','','2022-03-03 21:44:29',15,'PURCHASE OF AGO','716','','0000-00-00 00:00:00','202','2022-03-03 22:12:21'),(89903,'1','57','2022-03-27',174,76,700.00,17000.00,0.00,0.00,11900000.00,0.00,'','','NSR195YW','','','','2022-03-27 17:49:32',15,'','716','','0000-00-00 00:00:00','202','2022-03-27 17:59:48'),(89904,'1','57','2022-08-31',174,76,800.00,14500.00,0.00,0.00,11600000.00,0.00,'','000','NSR 74 ZQ','','','','2022-09-02 17:00:04',15,'PURCHASE OF AGO','716','','0000-00-00 00:00:00','202','2022-09-02 17:53:37'),(89905,'1','57','2022-09-03',173,76,190.00,40250.00,0.00,0.00,7647500.00,0.00,'','00','ran 415 xa','','','','2022-09-04 12:51:59',15,'paces op pms ','716','','0000-00-00 00:00:00','202','2022-09-04 15:41:50'),(89906,'1','57','2022-11-11',173,76,245.00,15200.00,0.00,0.00,3724000.00,0.00,'','00','NAS 770 ZQ','','','','2022-11-15 15:54:09',15,'PURCHASE of PMS','716','','0000-00-00 00:00:00','202','2022-11-15 15:59:51'),(89907,'1','57','2023-01-03',174,76,890.00,20000.00,0.00,0.00,17800000.00,0.00,'','OO','ABJ 88 ZT','','','','2023-01-04 11:47:30',15,'Purchase op ago','716','','0000-00-00 00:00:00','202','2023-01-04 11:55:19'),(89908,'1','57','2023-01-28',174,76,890.00,18500.00,0.00,0.00,16465000.00,0.00,'','OO','RAN 888 xa','','','','2023-01-29 15:31:09',15,'Please of ago','716','','0000-00-00 00:00:00','974','2023-01-30 19:33:31');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=400239 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (364222,'1','57','2021-11-18',76,'00','','5',73485.00,'240535','','','3865','AA R 5635 AZARE','00',0.00,'2021-11-21 16:46:15',5,'PAYMENT ON ACCOUNT','716','202','2021-11-23 10:53:44','202','2021-11-23 10:58:22'),(364223,'1','57','2021-11-18',76,'000','','5',168360.00,'240575','','','3865','AA R 5635 AZARE','00',0.00,'2021-11-21 16:50:15',5,'PAYMENT ON ACCOUNT','716','202','2021-11-23 10:58:58','202','2021-11-23 10:59:44'),(364226,'1','57','2021-11-19',76,'00','','5',696270.00,'240579','','','3865','AA R 5635 AZARE','00',0.00,'2021-11-21 16:54:04',5,'PAYMENT ON ACCOUNT','716','202','2021-11-23 10:59:23','202','2021-11-23 10:59:44'),(364228,'1','57','2021-11-19',76,'00','','5',219730.00,'240582','','','3865','AA R 5635 AZARE','00',0.00,'2021-11-21 16:58:37',5,'PAYMENT 0N ACC0UNT','716','202','2021-11-23 10:54:24','202','2021-11-23 10:58:22'),(364229,'1','57','2021-11-20',76,'00','','5',283045.00,'240584','','','3865','AA R 5635 AZARE','00',0.00,'2021-11-21 17:03:18',5,'PAYMENT ON ACCOUNT','716','202','2021-11-23 10:54:49','202','2021-11-23 10:58:22'),(364230,'1','57','2021-11-20',76,'00','','5',242755.00,'240585','','','3865','AA R 5635 AZARE','00 ',0.00,'2021-11-21 17:07:48',5,'PAYMENT 0N ACCOUNT','716','202','2021-11-23 10:55:23','202','2021-11-23 10:58:22'),(364231,'1','57','2021-11-21',76,'00','','5',589775.00,'240586','','','3865','AA R 5635 AZARE','00',0.00,'2021-11-21 17:11:38',5,'PAYMENT 0N ACC0UNT','716','202','2021-11-23 10:56:02','202','2021-11-23 10:58:22'),(364501,'1','57','2021-11-21',76,'000','','5',364885.00,'240592','','','3865','AA R 5635 AZARE','00',364988.25,'2021-11-22 09:48:40',5,'PAYMENT ON ACCOUNT','716','202','2021-11-23 10:56:36','202','2021-11-23 10:58:22'),(364721,'1','57','2021-11-22',76,'00','','5',379830.00,'240812','','','3865','AA R 5635 AZARE','00',379830.00,'2021-11-22 14:50:31',5,'payment on accaunt','716','','0000-00-00 00:00:00','202','2021-11-26 16:21:18'),(365216,'1','57','2021-11-23',76,'00','','5',368700.00,'240876','','','3865','AAR5635AZARE','00',368702.40,'2021-11-23 09:56:13',5,'PAYMENT ON ACCOUNT','716','','0000-00-00 00:00:00','202','2021-11-26 16:21:18'),(365513,'1','57','2021-11-23',76,'00','','5',397030.00,'241137','','','3865','AAR5635AZARE','00',397029.60,'2021-11-23 14:52:51',5,'PAYMENT ON ACCOUNT','716','','0000-00-00 00:00:00','202','2021-11-26 16:21:18'),(365899,'1','57','2021-11-24',76,'00','','5',308635.00,'241326','','','3865','AAR 5635 AZARE','00',308637.45,'2021-11-24 09:57:15',5,'PAYMENT ON ACCOUNT','716','','0000-00-00 00:00:00','202','2021-11-26 16:21:18'),(366174,'1','57','2021-11-24',76,'00','','5',329135.00,'241419','','','3865','AAR5635AZARE','00',329135.40,'2021-11-24 18:28:57',5,'PAYMENT ON ACCOUNT ','716','','0000-00-00 00:00:00','202','2021-11-26 16:21:18'),(366431,'1','57','2021-11-25',76,'00','','5',347550.00,'241422','','','3865','AAR5635AZARE','00',347551.05,'2021-11-25 09:21:47',5,'PAYMENT ON ACCOUNT','716','','0000-00-00 00:00:00','202','2021-11-26 16:21:18'),(367766,'1','57','2021-11-27',76,'00','','5',141320.00,'241662','','','3865','AAR5635AZARE','00',141319.20,'2021-11-27 16:14:55',5,'PAYMENT ON ACCOUNT ','716','','0000-00-00 00:00:00','202','2021-12-02 14:11:11'),(382397,'1','57','2021-12-24',76,'00','','5',1228490.00,'248603','','','1301','SANI HUSEN','00',1228489.50,'2021-12-25 12:54:56',5,'PAYMENT ON ACCOUNT','716','202','2021-12-29 10:46:23','202','2022-01-04 16:15:00'),(383720,'1','57','2021-12-25',76,'00','','5',209965.00,'249475','','','1301','SANI HUSEN','00',209965.00,'2021-12-28 13:21:27',5,'PAYMENT ON ACCOUNT','716','202','2021-12-29 10:46:32','202','2022-01-04 16:15:00'),(384028,'1','57','2021-12-25',76,'00','','5',600315.00,'249671','','','1301','SANI HUSEN','00',622713.00,'2021-12-29 09:13:25',5,'PAYMENT ON ACCOUNT','716','202','2021-12-29 10:46:53','202','2022-01-04 16:15:00'),(384039,'1','57','2021-12-29',76,'00','','5',32550.00,'249679','','','1301','SANI HUSEN','00',32550.00,'2021-12-29 09:30:30',5,'PAYMENT ON ACCOUNT','716','202','2021-12-29 10:47:04','202','2022-01-04 16:15:00'),(384044,'1','57','2021-12-26',76,'00','','5',1420000.00,'249683','','','1301','SANI HUSEN','00',1419999.00,'2021-12-29 09:37:39',5,'PAYMENT ON ACCOUNT','716','202','2021-12-29 10:47:23','202','2022-01-04 16:15:00'),(384047,'1','57','2021-12-27',76,'00','','5',517110.00,'249685','','','1301','SANI HUSEN','00',517107.50,'2021-12-29 09:41:39',5,'PAYMENT ON ACCOUNT','716','202','2021-12-29 10:47:33','202','2022-01-04 16:15:00'),(384059,'1','57','2021-12-27',76,'00','','5',1133270.00,'249691','','','1301','SANI HUSEN','00',1133272.00,'2021-12-29 09:50:52',5,'PAYMENT ON ACCOUNT','716','202','2021-12-29 10:47:43','202','2022-01-04 16:15:00'),(384065,'1','57','2021-12-28',76,'00','','5',31450.00,'249694','','','1301','SANI HUSEN','00',31451.00,'2021-12-29 09:56:05',5,'PAYMENT ON ACCOUNT','716','202','2021-12-29 10:47:53','202','2022-01-04 16:15:00'),(384075,'1','57','2021-12-28',76,'00','','5',822285.00,'249695','','','1301','SANI HUSEN','00',822286.50,'2021-12-29 10:00:14',5,'PAYMENT ON ACCOUNT','716','202','2021-12-29 10:48:01','202','2022-01-04 16:15:00'),(387170,'1','57','2021-12-30',76,'00','','5',585200.00,'250001','','','1301','SANI HUSEN','00',578900.00,'2022-01-04 10:33:32',5,'PAYMENT ON ACCOUNT','716','202','2022-01-07 11:58:38','202','2022-01-10 14:06:33'),(387179,'1','57','2021-12-31',76,'00','','5',314865.00,'250248','','','1301','SANI HUSEN','00',314867.00,'2022-01-04 10:41:05',5,'PAYMENT ON ACCOUNT','716','202','2022-01-04 10:53:47','202','2022-01-04 16:15:00'),(387183,'1','57','2021-12-31',76,'00','','5',203845.00,'250461','','','1301','SANI HUSEN','00',213150.00,'2022-01-04 10:45:09',5,'PAYMENT ON ACCOUNT','716','202','2022-01-07 11:58:56','202','2022-01-10 14:07:37'),(387187,'1','57','2022-01-01',76,'00','','5',5290.00,'250471','','','1301','SANI HUSEN','00',5288.50,'2022-01-04 10:51:12',5,'PAYMENT ON ACCOUNT','716','202','2022-01-04 10:54:07','202','2022-01-10 14:14:55'),(387191,'1','57','2022-01-01',76,'00','','5',334910.00,'251114','','','1301','SANI HUSEN','00',334911.50,'2022-01-04 10:57:08',5,'PAYMENT ON ACCOUNT','716','202','2022-01-04 11:09:14','202','2022-01-05 19:11:57'),(387251,'1','57','2022-01-02',76,'00','','5',344900.00,'251139','','','1301','SANI HUSEN','00',344900.50,'2022-01-04 12:59:31',5,'PAYMENT ON ACCOUNT','716','202','2022-01-04 14:20:50','202','2022-01-04 16:15:00'),(387325,'1','57','2022-01-02',76,'00','','5',325360.00,'251157','','','1301','SANI HUSEN','00',325360.00,'2022-01-04 14:16:35',5,'PAYMENT ON ACCOUNT','716','202','2022-01-04 14:20:39','202','2022-01-04 16:15:00'),(387329,'1','57','2022-01-03',76,'00','','5',493200.00,'251172','','','1301','SANI HUSEN','00',493200.00,'2022-01-04 14:20:55',5,'PAYMENT ON ACCOUNT','716','202','2022-01-04 14:31:04','202','2022-01-10 14:06:33'),(387334,'1','57','2022-01-03',76,'00','','5',362845.00,'251173','','','1301','SANI HUSEN','00',362845.00,'2022-01-04 14:26:16',5,'PAYMENT ON ACCOUNT','716','202','2022-01-04 14:31:16','202','2022-01-10 14:14:55'),(387337,'1','57','2022-01-04',76,'00','','5',368670.00,'251177','','','4067','SANI HUSEN','00',368672.50,'2022-01-04 14:30:52',5,'PAYMENT ON ACCOUNT','716','202','2022-01-04 14:32:40','202','2022-01-10 14:07:37'),(387709,'1','57','2022-01-04',76,'00','','5',223960.00,'251179','','','4067','SANI HUSEN','00',259486.50,'2022-01-05 10:26:08',5,'PAYMENT ON ACCOUNT','716','202','2022-01-05 19:08:52','202','2022-01-10 14:07:37'),(388199,'1','57','2022-01-05',76,'00','','5',224305.00,'251348','','','4067','SANI HUSEN','00',224304.50,'2022-01-05 21:25:45',5,'PAYMENT ON ACCOUNT','716','202','2022-01-06 15:23:57','202','2022-01-10 14:06:33'),(388758,'1','57','2022-01-05',76,'00','','5',175000.00,'251480','','','4067','DA I HUSEN','00',175000.00,'2022-01-06 20:15:14',5,'PAYMENT ACCOUNT','716','202','2022-01-07 12:42:12','202','2022-01-10 14:06:33'),(389029,'1','57','2022-01-06',76,'00','','5',168585.00,'251852','','','4067','SANI HUSEN','00',168595.00,'2022-01-07 12:02:14',5,'PAYMENT ON ACCOUNT','716','202','2022-01-07 12:42:25','202','2022-01-10 14:06:33'),(389076,'1','57','2022-01-06',76,'00','','5',384050.00,'251862','','','4067','SANI HUSEN','00',384048.00,'2022-01-07 13:01:47',5,'PAYMENT ON ACCOUNT','716','202','2022-01-07 16:45:09','202','2022-01-11 13:58:56'),(389081,'1','57','2021-12-31',76,'00','','5',9305.00,'250471','','','1301','SANI HUSEN','00',9305.00,'2022-01-07 13:06:09',5,'PAYMENT ON ACCOUNT','716','202','2022-01-07 16:49:15','202','2022-01-10 14:14:55'),(390458,'1','57','2022-01-07',76,'00','','5',65665.00,'251962','','','4067','Sani Husen','00',65667.00,'2022-01-10 10:54:09',5,'PAYMENT ON ACCOUNT','716','202','2022-01-11 14:06:46','202','2022-01-11 14:06:54'),(390480,'1','57','2022-01-07',76,'00','','5',423405.00,'252568','','','4067','Sani Husen','00',423405.50,'2022-01-10 11:11:26',5,'PAYMENT ON ACCOUNT','716','202','2022-01-10 11:45:19','202','2022-01-11 14:07:24'),(390492,'1','57','2022-01-08',76,'00','','5',417725.00,'252572','','','4067','SANI HUSEN','00',418775.00,'2022-01-10 11:31:09',5,'PAYMENT ON ACCOUNT ','716','202','2022-01-12 10:52:05','202','2022-01-13 13:10:39'),(390495,'1','57','2022-01-08',76,'00','','5',122475.00,'252576','','','4067','SANI HUSEN','00',122475.50,'2022-01-10 11:34:48',5,'PAYMENT ON ACCOUNT ','716','202','2022-01-10 11:45:51','202','2022-01-11 14:07:08'),(390511,'1','57','2022-01-09',76,'00','','5',702200.00,'252581','','','4067','SANI HUSEN','00',702198.00,'2022-01-10 11:50:40',5,'PAYMENT ON ACCOUNT ','716','202','2022-01-10 12:35:48','202','2022-01-11 13:58:56'),(390535,'1','57','2022-01-09',76,'','','5',703290.00,'252584','','','4067','ÀZARE','001',703290.00,'2022-01-10 12:07:59',5,'','716','','0000-00-00 00:00:00','202','2022-01-13 13:10:39'),(390976,'1','57','2022-01-10',76,'00','','5',532130.00,'252805','','','4067','SANI HUSEN','00',532129.50,'2022-01-11 10:34:41',5,'PAYMENT ON ACCOUNT ','716','202','2022-01-11 10:44:38','202','2022-01-13 13:10:39'),(390989,'1','57','2022-01-10',76,'00','','5',212050.00,'252807','','','4067','SANI HUSEN','00',212051.00,'2022-01-11 10:40:55',5,'PAYMENT ON ACCOUNT ','716','202','2022-01-11 10:44:45','202','2022-01-13 13:10:39'),(391334,'1','57','2022-01-11',76,'00','','5',76980.00,'252897','','','4067','SANI HUSEN','00',79980.00,'2022-01-11 17:41:52',5,'PAYMENT ON ACCOUNT ','716','202','2022-01-13 13:13:47','202','2022-01-13 13:13:54'),(392028,'1','57','2022-01-11',76,'00','','5',556610.00,'252932','','','4067','SANI HUSEN','00',556608.50,'2022-01-12 22:47:49',5,'PAYMENT ON ACCOUNT ','716','202','2022-01-13 10:14:17','202','2022-01-14 14:40:54'),(392030,'1','57','2022-01-12',76,'00','','5',291390.00,'253188','','','4067','SANI HUSEN','00',291389.00,'2022-01-12 22:51:32',5,'PAYMENT ON ACCOUNT ','716','202','2022-01-13 10:13:57','202','2022-01-17 15:13:58'),(392201,'1','57','2022-01-12',76,'00','','5',551460.00,'253287','','','4067','SANI HUSEN','00',551460.00,'2022-01-13 10:29:31',5,'PAYMENT ON ACCOUNT','716','202','2022-01-17 15:14:42','202','2022-01-17 15:14:53'),(392449,'1','57','2022-01-13',76,'00','','5',275000.00,'253299','','','4067','SANI HUSEN','00',350000.00,'2022-01-13 15:43:53',5,'PAYMENT ON ACCOUNT','716','202','2022-01-17 17:15:47','202','2022-01-17 17:23:07'),(392622,'1','57','2022-01-13',76,'00','','5',333900.00,'253408','','','4067','SANI HUSEN','00',333900.00,'2022-01-13 21:59:43',5,'PAYMENT ON ACCOUNT ','716','202','2022-01-14 14:40:31','202','2022-01-18 15:11:34'),(393165,'1','57','2022-01-14',76,'00','','5',162585.00,'253613','','','4067','SANI HUSEN','00',208257.00,'2022-01-14 15:54:52',5,'PAYMENT ON ACCOUNT','716','202','2022-01-17 12:36:54','202','2022-01-18 15:11:34'),(393331,'1','57','2022-01-14',76,'00','','5',191800.00,'253635','','','4067','SANI HUSEN','00',191800.00,'2022-01-14 23:18:08',5,'PAYMENT ON ACCOUNT','716','202','2022-01-17 12:37:08','202','2022-01-18 15:11:34'),(393801,'1','57','2022-01-15',76,'00','','5',199500.00,'253813','','','4067','SANI HUSEN','00',199500.00,'2022-01-15 21:57:40',5,'PAYMENT ON ACCOUNT','716','202','2022-01-17 12:37:19','202','2022-01-18 15:21:04'),(393802,'1','57','2022-01-15',76,'00','','5',218720.00,'253921','','','4067','SANI HUSEN','00',218718.50,'2022-01-15 22:01:29',5,'PAYMENT ON ACCOUNT','716','202','2022-01-17 12:37:28','202','2022-01-18 15:11:34'),(394687,'1','57','2022-01-13',76,'00','','5',75000.00,'253299','','','4067','SANI HUSEN','00',0.00,'2022-01-17 16:16:43',5,'PAYMENT ON ACCOUNT ','716','202','2022-01-17 17:15:17','202','2022-01-18 15:11:34'),(394688,'1','57','2022-01-14',76,'','','5',10000.00,'253613','','','4067','SANI HUSEN','00',0.00,'2022-01-17 16:18:28',5,'PAYMENT ON ACCOUNT ','716','202','2022-01-17 17:15:04','202','2022-01-18 15:11:34'),(395805,'1','57','2022-01-18',76,'00','','5',771020.00,'254