-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_41
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_41`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_41` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_41`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=848 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (826,2010,'',0,'24','1','41','PURCHASES','','2017-04-10 13:53:14',5,0.00,0.00,'','96','2017-04-10 15:23:36','96',0,1),(827,2030,'',0,'6.1','1','41','CASH','','2017-04-10 13:53:36',5,0.00,0.00,'','96','2017-04-10 18:01:07','96',0,1),(828,2028,'',0,'20','1','41','SALES','','2017-04-10 13:54:14',5,0.00,0.00,'','96','2017-04-10 18:01:45','96',0,1),(829,2021,'',0,'24','1','41','SALARIES & WAGES','','2017-04-10 13:54:51',5,0.00,0.00,'','96','2017-04-10 15:23:07','96',0,1),(830,2011,'',0,'24','1','41','AGO CONSUMPTION','','2017-04-10 15:24:20',5,0.00,0.00,'','96','2017-04-10 15:24:20','96',0,1),(831,2012,'',0,'24','1','41','WEIGHT AND MEASURE','','2017-04-10 15:24:41',5,0.00,0.00,'','96','2017-04-10 15:24:41','96',0,1),(832,2013,'',0,'24','1','41','ELECTRICITY AND WATER BILLS','','2017-04-10 15:25:18',5,0.00,0.00,'','96','2017-04-10 15:25:18','96',0,1),(833,2014,'',0,'24','1','41','FUELING AND REPAIR OF OFFICIAL','','2017-04-10 15:25:44',5,0.00,0.00,'','96','2017-04-10 15:25:44','96',0,1),(834,2015,'',0,'24','1','41','PRINTING AND STATIONARY','','2017-04-10 15:26:43',5,0.00,0.00,'','96','2017-04-10 15:26:43','96',0,1),(835,2016,'',0,'24','1','41','PUMP REPAIRS & GENERATOR','','2017-04-10 17:32:24',5,0.00,0.00,'','96','2017-04-10 17:32:24','96',0,1),(836,2017,'',0,'24','1','41','STATION REPAIRS AND MAINTENANC','','2017-04-10 17:40:22',5,0.00,0.00,'','96','2017-04-10 17:40:22','96',0,1),(837,2018,'',0,'24','1','41','PUBLIC RELATION','','2017-04-10 17:40:56',5,0.00,0.00,'','96','2017-04-10 17:40:56','96',0,1),(838,2019,'',0,'24','1','41','COMPUTER AND INTERNET SUBCRIPT','','2017-04-10 17:41:21',5,0.00,0.00,'','96','2017-04-10 17:41:21','96',0,1),(839,2020,'',0,'24','1','41','DISCOUNT ALLOWED','','2017-04-10 17:41:52',5,0.00,0.00,'','96','2017-04-10 17:41:52','96',0,1),(840,2022,'',0,'24','1','41','TRANSPORT FARE','','2017-04-10 17:55:24',5,0.00,0.00,'','96','2017-04-10 17:55:24','96',0,1),(841,2023,'',0,'24','1','41','OTHER OPERATING EXPENSES','','2017-04-10 17:56:21',5,0.00,0.00,'','96','2017-04-10 17:56:21','96',0,1),(842,2024,'',0,'24','1','41','STAFF RENT','','2017-04-10 17:56:52',5,0.00,0.00,'','96','2017-04-10 17:56:52','96',0,1),(843,2025,'',0,'24','1','41','STAFF TRAINING AND ACCOMODATIO','','2017-04-10 17:57:30',5,0.00,0.00,'','96','2017-04-10 17:57:30','96',0,1),(844,2026,'',0,'24','1','41','MEDICAL EXPENSES','','2017-04-10 17:57:59',5,0.00,0.00,'','96','2017-04-10 17:57:59','96',0,1),(845,2027,'',0,'24','1','41','CLEANING AND SENITARY ITEMS','','2017-04-10 17:58:23',5,0.00,0.00,'','96','2017-04-10 17:58:23','96',0,1),(846,2029,'',0,'2','1','41','ZENITH BANK 1011595101 SURPLUS','','2017-04-10 17:58:58',5,0.00,0.00,'','96','2017-04-10 17:58:58','96',0,1),(847,2031,'',0,'5','1','41','INVENTORY VALUE ADJUSTMENT','','2017-04-10 18:00:05',5,0.00,0.00,'','96','2017-04-10 18:00:05','96',0,1);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=36099 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (13488,'1','41','0000-00-00','2017-04-13 17:31:03',5,'96','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(13813,'1','41','0000-00-00','2017-04-19 13:15:11',5,'96','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(14784,'1','41','0000-00-00','2017-04-27 10:04:20',5,'96','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(15144,'1','41','0000-00-00','2017-04-30 08:57:54',5,'96','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(16443,'1','41','0000-00-00','2017-05-09 10:55:20',5,'96','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(16444,'1','41','0000-00-00','2017-05-09 11:15:16',5,'96','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(16729,'1','41','0000-00-00','2017-05-10 15:20:01',5,'96','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(17185,'1','41','0000-00-00','2017-05-13 16:30:34',5,'96','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(18645,'1','41','0000-00-00','2017-05-23 08:19:56',5,'96','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(19587,'1','41','0000-00-00','2017-05-28 17:14:16',5,'96','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(21797,'1','41','0000-00-00','2017-06-10 10:53:57',5,'96','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(22822,'1','41','0000-00-00','2017-06-16 17:09:55',5,'96','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(23462,'1','41','0000-00-00','2017-06-20 17:06:48',5,'96','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(24045,'1','41','0000-00-00','2017-06-23 18:33:22',5,'96','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(25243,'1','41','0000-00-00','2017-07-03 12:03:56',5,'96','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(27025,'1','41','0000-00-00','2017-07-14 11:31:40',5,'96','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(29251,'1','41','0000-00-00','2017-07-29 10:32:04',5,'96','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(32503,'1','41','0000-00-00','2017-08-17 17:09:20',5,'96','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(36098,'1','41','0000-00-00','2017-09-11 15:22:28',5,'96','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=76827 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (29352,'1','41','13488','669','customer',0.00,'FEEDING ALLOWANCE TO THE FOLLOWING TRUSK:KZR 521 YA,NSR 154 ZQ,KMC 791 ZQ,KSF 930 XS,KMC 922 ZY,RAN 87 XA',85000.00,'2017-04-13'),(29353,'1','41','13488','827','6.1',85000.00,'FEEDING ALLOWANCE TO THE FOLLOWING TRUSK:KZR 521 YA,NSR 154 ZQ,KMC 791 ZQ,KSF 930 XS,KMC 922 ZY,RAN 87 XA',0.00,'2017-04-13'),(30066,'1','41','13813','669','customer',0.00,'FEEDING ALLOWANCE TO THE FOLLOWING TRUCKS:TRN 216ZG,RAN 401XA,RAN 482XA,RAN 388XA,RAN 354XA,RAN434XA,RAN 423XA,RAN 359XA,KMC 797ZQ,RAN 508XA,RAN 375XA',282000.00,'2017-04-19'),(30067,'1','41','13813','827','6.1',282000.00,'FEEDING ALLOWANCE TO THE FOLLOWING TRUCKS:TRN 216ZG,RAN 401XA,RAN 482XA,RAN 388XA,RAN 354XA,RAN434XA,RAN 423XA,RAN 359XA,KMC 797ZQ,RAN 508XA,RAN 375XA',0.00,'2017-04-19'),(32171,'1','41','14784','669','customer',0.00,'FEEDING ALLOWANCE TO THE FOLLOWING TRUCKS:RAN 430XA,RAN 399XA,RAN 376XA,RAN 450XA,RAN 379XA,XC 218ZR,APP597XL,APP 596XL,RAN 358XA,RAN 480XA,RAN 488XA,',253000.00,'2017-04-27'),(32174,'1','41','14784','827','6.1',253000.00,'FEEDING ALLOWANCE TO THE FOLLOWING TRUCKS:RAN 430XA,RAN 399XA,RAN 376XA,RAN 450XA,RAN 379XA,XC 218ZR,APP597XL,APP 596XL,RAN 358XA,RAN 480XA,RAN 488XA,',0.00,'2017-04-27'),(32985,'1','41','15144','669','customer',0.00,'FEEDING ALLOWANCE TO THE FOLLOWING TRUCKS FKG 72XT,RAN 369XA,RAN 685XA,RAN 843XA,KMC 923ZY,RAN 337XA,KSF 936XS,FKJ 69XT,KSF 930XT,RAN 820XA,FKJ 71XT,T',185000.00,'2017-04-30'),(32986,'1','41','15144','827','6.1',185000.00,'FEEDING ALLOWANCE TO THE FOLLOWING TRUCKS FKG 72XT,RAN 369XA,RAN 685XA,RAN 843XA,KMC 923ZY,RAN 337XA,KSF 936XS,FKJ 69XT,KSF 930XT,RAN 820XA,FKJ 71XT,T',0.00,'2017-04-30'),(35746,'1','41','16443','847','5',0.00,'INVENTORY ADJUSTMENT FOR AGO ON 37,500 LITRES (5)FROM 190-185 ON 3/5/17@ 2:PM ',187500.00,'2017-05-03'),(35747,'1','41','16443','49','supplier',187500.00,'INVENTORY ADJUSTMENT FOR AGO ON 37,500 LITRES (5)FROM 190-185 ON 3/5/17@2:PM',0.00,'2017-05-03'),(35748,'1','41','16444','669','customer',0.00,'FEEDING ALLOWANCE TO THE FOLLOWING TRUCKS:RAN 435XA,RAN 387XA,KSF 930XT,KMC 446 YE,FKJ 69XT,DKD 265XA,RAN 427XA,RAN 385XA,KTU 255XT,RAN 411XA,KSF 936X',309000.00,'2017-05-09'),(35749,'1','41','16444','827','6.1',309000.00,'FEEDING ALLOWANCE TO THE FOLLOWING TRUCKS:RAN 435XA,RAN 387XA,KSF 930XT,KMC 446 YE,FKJ 69XT,DKD 265XA,RAN 427XA,RAN 385XA,KTU 255XT,RAN 411XA,KSF 936X',0.00,'2017-05-09'),(36357,'1','41','16729','847','5',0.00,'INVENTORY VALUE ADJUSTMENT FOR AGO ON 37,950 LITRES FROM (185-180)BY 11:AM',189750.00,'2017-05-10'),(36359,'1','41','16729','49','supplier',189750.00,'INVENTORY VALUE ADJUSTMENT FOR AGO ON 37,950 LITRES FROM (185-180)BY 11:AM',0.00,'2017-05-10'),(37341,'1','41','17185','669','customer',0.00,'FEEDING ALLOWANCE TO THE FOLLOWING TRUCKS:RAN 380XA,RAN 435XA,RAN 394XA,TRN 416ZG,RAN 374XA,RAN 817XA,RAN 433XA,RAN 461XA,RAN 388XA,GML 606XA,RAN 400X',242000.00,'2017-05-13'),(37343,'1','41','17185','827','6.1',242000.00,'FEEDING ALLOWANCE TO THE FOLLOWING TRUCKS:RAN 380XA,RAN 435XA,RAN 394XA,TRN 416ZG,RAN 374XA,RAN 817XA,RAN 433XA,RAN 461XA,RAN 388XA,GML 606XA,RAN 400X',0.00,'2017-05-13'),(40412,'1','41','18645','49','supplier',0.00,'FEEDING ALLOWANCE TO THE FOLLOWING TRUCKS:KMC 395ZV,RAN 368XA,RAN 398XA,RAN 358XA,RAN 402XA,RAN 384XA,RAN 364XA,RAN 382XA,TRN 418ZG RAN 813XA,RAN 392X',335000.00,'2017-05-23'),(40413,'1','41','18645','669','customer',335000.00,'FEEDING ALLOWANCE TO THE FOLLOWING TRUCKS:KMC 395ZV,RAN 368XA,RAN 398XA,RAN 358XA,RAN 402XA,RAN 384XA,RAN 364XA,RAN 382XA,TRN 418ZG RAN 813XA,RAN 392X',0.00,'2017-05-23'),(42363,'1','41','19587','669','customer',0.00,'CASH IFO BUHARI MUSA B/O CEO',330000.00,'2017-05-28'),(42364,'1','41','19587','827','6.1',330000.00,'CASH IFO BUHARI MUSA B/O CEO',0.00,'2017-05-28'),(46973,'1','41','21797','669','customer',0.00,'CASH IFO BUHARI MUSA B/O CEO',656000.00,'2017-06-10'),(46974,'1','41','21797','827','6.1',656000.00,'CASH IFO BUHARI MUSA B/O CEO',0.00,'2017-06-10'),(49115,'1','41','22822','669','customer',0.00,'CASH IFO BUHARI MUSA B/O CEO',287000.00,'2017-06-16'),(49116,'1','41','22822','827','6.1',287000.00,'CASH IFO BUHARI MUSA B/O CEO',0.00,'2017-06-16'),(50448,'1','41','23462','669','customer',0.00,'CASH IFO BUHARI MUSA B/O CEO',235000.00,'2017-06-20'),(50449,'1','41','23462','827','6.1',235000.00,'CASH IFO BUHARI MUSA B/O CEO',0.00,'2017-06-20'),(51658,'1','41','24045','669','customer',0.00,'CASH IFO BUHARI MUSA B/O CEO',187000.00,'2017-06-23'),(51659,'1','41','24045','827','6.1',187000.00,'CASH IFO BUHARI MUSA B/O CEO',0.00,'2017-06-23'),(54119,'1','41','25243','669','customer',0.00,'CASH IFO BUHARI MUSA B/O CEO',424000.00,'2017-07-03'),(54121,'1','41','25243','827','6.1',424000.00,'CASH IFO BUHARI MUSA B/O CEO',0.00,'2017-07-03'),(57817,'1','41','27025','669','customer',0.00,'CASH IFO BUHARI MUSA B/O CEO',515000.00,'2017-07-14'),(57818,'1','41','27025','827','6.1',515000.00,'CASH IFO BUHARI MUSA B/O CEO',0.00,'2017-07-14'),(62478,'1','41','29251','669','customer',0.00,'CASH IFO BUHARI MUSA B/O CEO',787000.00,'2017-07-29'),(62479,'1','41','29251','827','6.1',787000.00,'CASH IFO BUHARI MUSA B/O CEO',0.00,'2017-07-29'),(69279,'1','41','32503','669','customer',0.00,'CASH IFO BUHARI MUSA B/O CEO',1258000.00,'2017-08-17'),(69281,'1','41','32503','827','6.1',1258000.00,'CASH IFO BUHARI MUSA B/O CEO',0.00,'2017-08-17'),(76825,'1','41','36098','669','customer',0.00,'CASH IFO BUHARI MUSA B/O CEO',1556000.00,'2017-09-11'),(76826,'1','41','36098','827','6.1',1556000.00,'CASH IFO BUHARI MUSA B/O CEO',0.00,'2017-09-11');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=671 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (669,'','1','41','HAULAGE SERVICES','','','','KANO','KANO','','Nigeria',0.00,0.00,0.00,'0000-00-00','2017-04-09 13:29:12',5,'96','2017-04-09 13:29:12','96'),(670,'','1','41','ATP','','','','KANO','KANO','','Nigeria',0.00,0.00,0.00,'0000-00-00','2017-04-09 13:29:43',5,'96','2017-04-09 13:29:43','96');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=835 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','41','308',833,'5','PUMP 1',1352230.00,'CONTAINING AGO',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','41','308',834,'5','PUMP 2',1591734.00,'CONTAINING AGO',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=22448 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','41',7603,'AFTERNOON SHIFT','2017-04-10','2017-04-10 00:00:00',NULL,'96',0.00,0.00,'96','2017-04-11 08:21:57','96','2017-04-11 08:22:20',10,0),('1','41',7639,'MORNING SHIFT','2017-04-11','2017-04-11 00:00:00',NULL,'96',1026000.00,1026000.00,'96','2017-04-13 16:52:02','96','2017-04-13 16:52:47',10,0),('1','41',7770,'AFTERNOON SHIFT','2017-04-13','2017-04-13 00:00:00',NULL,'96',3885500.00,3885500.00,'96','2017-04-19 13:04:49','96','2017-04-19 13:05:47',10,0),('1','41',8066,'MORNING SHIFT','2017-04-19','2017-04-19 00:00:00',NULL,'96',0.00,0.00,'96','2017-04-21 18:20:03','96','2017-04-21 18:21:21',10,0),('1','41',8228,'AFTERNOON SHIFT','2017-04-20','2017-04-20 00:00:00',NULL,'96',0.00,0.00,'96','2017-04-22 12:27:49','96','2017-04-22 12:28:53',10,0),('1','41',8266,'MORNING SHIFT','2017-04-22','2017-04-22 00:00:00',NULL,'96',0.00,0.00,'96','2017-04-25 11:11:11','96','2017-04-25 11:11:43',10,0),('1','41',8652,'AFTERNOON SHIFT','2017-04-27','2017-04-27 00:00:00',NULL,'96',3353500.00,3353500.00,'96','2017-04-27 09:53:46','96','2017-04-27 09:55:17',10,0),('1','41',8895,'MORNING SHIFT','2017-04-30','2017-04-30 00:00:00',NULL,'96',1938000.00,1938000.00,'96','2017-04-30 08:45:03','96','2017-04-30 08:45:56',10,0),('1','41',9774,'AFTERNOON SHIFT','2017-05-09','2017-05-09 00:00:00',NULL,'96',3616750.00,3616750.00,'96','2017-05-09 11:01:41','96','2017-05-09 11:02:13',10,0),('1','41',10211,'MORNING SHIFT','2017-05-13','2017-05-13 00:00:00',NULL,'96',3096000.00,3096000.00,'96','2017-05-13 16:25:22','96','2017-05-13 16:25:54',10,0),('1','41',11081,'AFTERNOON SHIFT','2017-05-23','2017-05-23 00:00:00',NULL,'96',4374000.00,4374000.00,'96','2017-05-23 08:10:52','96','2017-05-23 08:11:28',10,0),('1','41',11668,'MORNING SHIFT','2017-05-28','2017-05-28 00:00:00',NULL,'96',3946250.00,3946250.00,'96','2017-05-28 17:07:23','96','2017-05-28 17:07:50',10,0),('1','41',12953,'AFTERNOON','2017-06-10','2017-06-10 00:00:00',NULL,'96',7403500.00,7403500.00,'96','2017-06-10 10:52:23','96','2017-06-10 10:52:46',10,0),('1','41',13663,'MORNING','2017-06-16','2017-06-16 00:00:00',NULL,'96',3448500.00,3448500.00,'96','2017-06-16 17:07:15','96','2017-06-16 17:07:57',10,0),('1','41',14063,'AFTERNOON SHIFT','2017-06-20','2017-06-20 00:00:00',NULL,'96',2557500.00,2557500.00,'96','2017-06-20 17:05:04','96','2017-06-20 17:05:32',10,0),('1','41',14419,'MORNING SHIFT','2017-06-23','2017-06-23 00:00:00',NULL,'96',2032000.00,2032000.00,'96','2017-06-23 18:28:59','96','2017-06-23 18:29:20',10,0),('1','41',15294,'AFTERNOON','2017-07-03','2017-07-03 00:00:00',NULL,'96',5208000.00,5208000.00,'96','2017-07-03 12:00:56','96','2017-07-03 12:01:27',10,0),('1','41',16376,'MORNING','2017-07-14','2017-07-14 00:00:00',NULL,'96',5161600.00,5161600.00,'96','2017-07-14 11:09:21','96','2017-07-14 11:09:58',10,0),('1','41',17850,'AFTERNOON SHIFT','2017-07-29','2017-07-29 00:00:00',NULL,'96',9120000.00,9120000.00,'96','2017-07-29 10:23:23','96','2017-07-29 10:24:03',10,0),('1','41',19908,'MORNING SHIFT','2017-08-17','2017-08-17 00:00:00',NULL,'96',6931360.00,6931360.00,'96','2017-08-17 16:49:23','96','2017-08-17 16:49:43',10,0),('1','41',19911,'AFTERNOON SHIFT','2017-08-17','2017-08-17 00:00:00',NULL,'96',6292640.00,6292640.00,'96','2017-08-17 17:00:54','96','2017-08-17 17:01:26',10,0),('1','41',22441,'MORNING SHIFT','2017-09-11','2017-09-11 00:00:00',NULL,'96',3961600.00,3961600.00,'96','2017-09-11 14:40:33','96','2017-09-11 14:40:52',10,0),('1','41',22443,'AFTERNOON SHIFT','2017-09-11','2017-09-11 00:00:00',NULL,'96',2286560.00,2286560.00,'96','2017-09-11 14:47:12','96','2017-09-11 14:47:30',10,0),('1','41',22445,'MORNING SHIFT','2017-09-11','2017-09-11 00:00:00',NULL,'96',7585875.00,7585875.00,'96','2017-09-11 14:54:44','96','2017-09-11 14:55:09',10,0),('1','41',22447,'AFTERNOON SHIFT','2017-09-11','2017-09-11 00:00:00',NULL,'96',4172850.00,4172850.00,'96','2017-09-11 15:09:41','96','2017-09-11 15:10:23',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=459361 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','41','308','7603',172906,'833','109',1084895.00,1084895.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','7603',172907,'834','109',1313703.00,1313703.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','7639',173561,'833','109',1084895.00,1086204.00,1300.00,247000.00,0.00,0.00,9.00,0.00,0.00),('1','41','308','7639',173562,'834','109',1313703.00,1317803.00,4100.00,779000.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','7770',176376,'833','109',1086204.00,1092864.00,6643.00,1262170.00,0.00,0.00,17.00,0.00,0.00),('1','41','308','7770',176377,'834','109',1317803.00,1331620.00,13807.00,2623330.00,0.00,0.00,10.00,0.00,0.00),('1','41','308','8066',182740,'833','109',1092864.00,1092864.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','8066',182741,'834','109',1331620.00,1331620.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','8228',185653,'833','109',1092864.00,1092864.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','8228',185654,'834','109',1331620.00,1331620.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','8266',186324,'833','109',1092864.00,1092864.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','8266',186325,'834','109',1331620.00,1331620.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','8652',193486,'833','109',1092864.00,1106349.00,13435.00,2552650.00,0.00,0.00,50.00,0.00,0.00),('1','41','308','8652',193487,'834','109',1331620.00,1335879.00,4215.00,800850.00,0.00,0.00,44.00,0.00,0.00),('1','41','308','8895',198065,'833','109',1106349.00,1116549.00,10200.00,1938000.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','8895',198066,'834','109',1335879.00,1335879.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','9774',213467,'833','109',1116549.00,1131266.00,14697.00,2718945.00,0.00,0.00,20.00,0.00,0.00),('1','41','308','9774',213468,'834','109',1335879.00,1340747.00,4853.00,897805.00,0.00,0.00,15.00,0.00,0.00),('1','41','308','10211',222353,'833','109',1131266.00,1139701.00,8435.00,1518300.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','10211',222354,'834','109',1340747.00,1349515.00,8765.00,1577700.00,0.00,0.00,3.00,0.00,0.00),('1','41','308','11081',239208,'833','109',1139701.00,1153633.00,13902.00,2502360.00,0.00,0.00,30.00,0.00,0.00),('1','41','308','11081',239209,'834','109',1349515.00,1359919.00,10398.00,1871640.00,0.00,0.00,6.00,0.00,0.00),('1','41','308','11668',250093,'833','109',1153633.00,1164249.00,10596.00,1854300.00,0.00,0.00,20.00,0.00,0.00),('1','41','308','11668',250094,'834','109',1359919.00,1371897.00,11954.00,2091950.00,0.00,0.00,24.00,0.00,0.00),('1','41','308','12953',274897,'833','109',1164249.00,1192403.00,28134.00,4782780.00,0.00,0.00,20.00,0.00,0.00),('1','41','308','12953',274898,'834','109',1371897.00,1387322.00,15416.00,2620720.00,0.00,0.00,9.00,0.00,0.00),('1','41','308','13663',288595,'833','109',1192403.00,1207707.00,15301.00,2524665.00,0.00,0.00,3.00,0.00,0.00),('1','41','308','13663',288596,'834','109',1387322.00,1392921.00,5599.00,923835.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','14063',296080,'833','109',1207707.00,1216112.00,8345.00,1376925.00,0.00,0.00,60.00,0.00,0.00),('1','41','308','14063',296081,'834','109',1392921.00,1400136.00,7155.00,1180575.00,0.00,0.00,60.00,0.00,0.00),('1','41','308','14419',302737,'833','109',1216112.00,1221870.00,5758.00,921280.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','14419',302738,'834','109',1400136.00,1407078.00,6942.00,1110720.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','15294',319763,'833','109',1221870.00,1232116.00,10246.00,1639360.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','15294',319764,'834','109',1407078.00,1429382.00,22304.00,3568640.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','16376',341161,'833','109',1232116.00,1246241.00,14095.00,2255200.00,0.00,0.00,30.00,0.00,0.00),('1','41','308','16376',341162,'834','109',1429382.00,1447569.00,18165.00,2906400.00,0.00,0.00,22.00,0.00,0.00),('1','41','308','17850',369152,'833','109',1246241.00,1269328.00,23082.00,3693120.00,0.00,0.00,5.00,0.00,0.00),('1','41','308','17850',369153,'834','109',1447569.00,1481487.00,33918.00,5426880.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','19908',409813,'833','109',1269328.00,1312649.00,43321.00,6931360.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','19908',409814,'834','109',1481487.00,1481487.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','19911',409849,'833','109',1312649.00,1312649.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','19911',409850,'834','109',1481487.00,1520999.00,39329.00,6292640.00,0.00,0.00,183.00,0.00,0.00),('1','41','308','22441',459295,'833','109',1312649.00,1312649.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','22441',459296,'834','109',1520999.00,1545759.00,24760.00,3961600.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','22443',459325,'833','109',1312649.00,1326940.00,14291.00,2286560.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','22443',459326,'834','109',1545759.00,1545759.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','22445',459340,'833','109',1326940.00,1326940.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','22445',459341,'834','109',1545759.00,1591734.00,45975.00,7585875.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','22447',459359,'833','109',1326940.00,1352230.00,25290.00,4172850.00,0.00,0.00,0.00,0.00,0.00),('1','41','308','22447',459360,'834','109',1591734.00,1591734.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=67867 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','41','7603','109',190.00,190.00,0.00,0.00,0.00,0.00,0.00,23237),('1','41','7639','109',190.00,190.00,5400.00,0.00,0.00,0.00,0.00,23344),('1','41','7770','109',190.00,190.00,20450.00,0.00,0.00,0.00,0.00,23737),('1','41','8066','109',190.00,190.00,0.00,0.00,0.00,0.00,0.00,24630),('1','41','8228','109',190.00,190.00,0.00,0.00,0.00,0.00,0.00,25116),('1','41','8266','109',190.00,190.00,0.00,0.00,0.00,0.00,0.00,25229),('1','41','8652','109',190.00,190.00,17650.00,0.00,0.00,0.00,0.00,26388),('1','41','8895','109',190.00,190.00,10200.00,0.00,0.00,0.00,0.00,27117),('1','41','9774','109',185.00,185.00,19550.00,0.00,0.00,0.00,0.00,29761),('1','41','10211','109',180.00,180.00,17200.00,0.00,0.00,0.00,0.00,31074),('1','41','11081','109',180.00,180.00,24300.00,0.00,0.00,0.00,0.00,33691),('1','41','11668','109',175.00,175.00,22550.00,0.00,0.00,0.00,0.00,35455),('1','41','12953','109',170.00,170.00,43550.00,0.00,0.00,0.00,0.00,39322),('1','41','13663','109',165.00,165.00,20900.00,0.00,0.00,0.00,0.00,41457),('1','41','14063','109',165.00,165.00,15500.00,0.00,0.00,0.00,0.00,42659),('1','41','14419','109',160.00,160.00,12700.00,0.00,0.00,0.00,0.00,43729),('1','41','15294','109',160.00,160.00,32550.00,0.00,0.00,0.00,0.00,46362),('1','41','16376','109',160.00,160.00,32260.00,0.00,0.00,0.00,0.00,49617),('1','41','17850','109',160.00,160.00,57000.00,0.00,0.00,0.00,0.00,54051),('1','41','19908','109',160.00,160.00,43321.00,0.00,0.00,0.00,0.00,60241),('1','41','19911','109',160.00,160.00,39329.00,0.00,0.00,0.00,0.00,60248),('1','41','22441','109',160.00,160.00,24760.00,0.00,0.00,0.00,0.00,67854),('1','41','22443','109',160.00,160.00,14291.00,0.00,0.00,0.00,0.00,67858),('1','41','22445','109',165.00,165.00,45975.00,0.00,0.00,0.00,0.00,67862),('1','41','22447','109',165.00,165.00,25290.00,0.00,0.00,0.00,0.00,67866);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=120 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',119,'41','AGO TANK ','TANK CONTAINING DIESEL');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=309 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','41','119',308,0,'109','AGO TANK ',60000.00,1.00,40974.00,'CONTAINING AGO','96','2017-04-01 14:29:28','2017-04-01 14:29:28','96',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2613467 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2613053,'1','41',NULL,109,'Balance from closing inventory values 2021-11-31 23:59:59',91397985.00,95940500.00,567700.00,544726.00,0.00,'2021-11-30 23:59:59','',''),(2613466,'1','41','308',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,40974.00,0.00,0.00,'2021-11-30 23:59:59','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=64820 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (22859,'1','41',109,'Sale Id shift 7603',0.00,0.00,190.00,0.00,0.00,'2017-04-11 08:22:20'),(23246,'1','41',109,'Sale Id shift 7639',0.00,1026000.00,190.00,1026000.00,0.00,'2017-04-13 16:52:47'),(24096,'1','41',109,'Sale Id shift 7770',0.00,3885500.00,190.00,3885500.00,0.00,'2017-04-19 13:05:47'),(24535,'1','41',109,'Sale Id shift 8066',0.00,0.00,190.00,0.00,0.00,'2017-04-21 18:21:21'),(24654,'1','41',109,'Sale Id shift 8228',0.00,0.00,190.00,0.00,0.00,'2017-04-22 12:28:53'),(25280,'1','41',109,'Sale Id shift 8266',0.00,0.00,190.00,0.00,0.00,'2017-04-25 11:11:43'),(25722,'1','41',109,'Sale Id shift 8652',0.00,3353500.00,190.00,3353500.00,0.00,'2017-04-27 09:55:17'),(26357,'1','41',109,'Sale Id shift 8895',0.00,1938000.00,190.00,1938000.00,0.00,'2017-04-30 08:45:56'),(28815,'1','41',109,'Sale Id shift 9774',0.00,3616750.00,185.00,3616750.00,0.00,'2017-05-09 11:02:13'),(30047,'1','41',109,'Sale Id shift 10211',0.00,3096000.00,180.00,3096000.00,0.00,'2017-05-13 16:25:54'),(32535,'1','41',109,'Sale Id shift 11081',0.00,4374000.00,180.00,4374000.00,0.00,'2017-05-23 08:11:28'),(34160,'1','41',109,'Sale Id shift 11668',0.00,3946250.00,175.00,3946250.00,0.00,'2017-05-28 17:07:50'),(37814,'1','41',109,'Sale Id shift 12953',0.00,7403500.00,170.00,7403500.00,0.00,'2017-06-10 10:52:46'),(39827,'1','41',109,'Sale Id shift 13663',0.00,3448500.00,165.00,3448500.00,0.00,'2017-06-16 17:07:57'),(40968,'1','41',109,'Sale Id shift 14063',0.00,2557500.00,165.00,2557500.00,0.00,'2017-06-20 17:05:32'),(41963,'1','41',109,'Sale Id shift 14419',0.00,2032000.00,160.00,2032000.00,0.00,'2017-06-23 18:29:20'),(44499,'1','41',109,'Sale Id shift 15294',0.00,5208000.00,160.00,5208000.00,0.00,'2017-07-03 12:01:27'),(47608,'1','41',109,'Sale Id shift 16376',0.00,5161600.00,160.00,5161600.00,0.00,'2017-07-14 11:09:58'),(51828,'1','41',109,'Sale Id shift 17850',0.00,9120000.00,160.00,9120000.00,0.00,'2017-07-29 10:24:03'),(57666,'1','41',109,'Sale Id shift 19908',0.00,6931360.00,160.00,6931360.00,0.00,'2017-08-17 16:49:43'),(57670,'1','41',109,'Sale Id shift 19911',0.00,6292640.00,160.00,6292640.00,0.00,'2017-08-17 17:01:26'),(64807,'1','41',109,'Sale Id shift 22441',0.00,3961600.00,160.00,3961600.00,0.00,'2017-09-11 14:40:52'),(64808,'1','41',109,'Sale Id shift 22443',0.00,2286560.00,160.00,2286560.00,0.00,'2017-09-11 14:47:30'),(64815,'1','41',109,'Sale Id shift 22445',0.00,7585875.00,165.00,7585875.00,0.00,'2017-09-11 14:55:09'),(64819,'1','41',109,'Sale Id shift 22447',0.00,4172850.00,165.00,4172850.00,0.00,'2017-09-11 15:10:23');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=3770211 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('1','41',99788,'','supplier','49',3496000.00,0.00,'Purchase Id 5298 for 18,400 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-04-10 13:59:58','',''),('1','41',99944,'','obe','obe',0.00,0.00,'Opening balance of 826','0000-00-00 00:00:00','',''),('1','41',99946,'','obe','obe',0.00,0.00,'Opening balance of 829','0000-00-00 00:00:00','',''),('1','41',99948,'','obe','obe',0.00,0.00,'Opening balance of 826','0000-00-00 00:00:00','',''),('1','41',100021,'','obe','obe',0.00,0.00,'Opening balance of 827','0000-00-00 00:00:00','',''),('1','41',100023,'','obe','obe',0.00,0.00,'Opening balance of 828','0000-00-00 00:00:00','',''),('1','41',100966,'','supplier','49',2850000.00,0.00,'Purchase Id 5350 for 15,000 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-04-12 13:00:03','',''),('1','41',101918,'','customer','670',0.00,1026000.00,'Credit Sales for 5,400.00 Litres of AGO from shift 7639 on 2017-04-13 16:52:47 ','2017-04-13 16:52:47','',''),('1','41',104075,'','customer','669',0.00,3885500.00,'Credit Sales for 20,450.00 Litres of AGO from shift 7770 on 2017-04-19 13:05:47 ','2017-04-19 13:05:47','',''),('1','41',104112,'','supplier','49',4712000.00,0.00,'Purchase Id 5580 for 24,800 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-04-19 13:20:34','',''),('1','41',108690,'','supplier','49',3705000.00,0.00,'Purchase Id 5807 for 19,500 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-04-25 13:25:09','',''),('1','41',112360,'','supplier','49',2565000.00,0.00,'Purchase Id 5969 for 13,500 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-04-29 10:34:31','',''),('1','41',113302,'','customer','669',0.00,1938000.00,'Credit Sales for 10,200.00 Litres of AGO from shift 8895 on 2017-04-30 08:45:56 ','2017-04-30 08:45:56','',''),('1','41',120222,'','customer','669',0.00,3616750.00,'Credit Sales for 19,550.00 Litres of AGO from shift 9774 on 2017-05-09 11:02:13 ','2017-05-09 11:02:13','',''),('1','41',121767,'','supplier','49',3700000.00,0.00,'Purchase Id 6374 for 20,000 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-05-10 15:10:44','',''),('1','41',124879,'','customer','669',0.00,3096000.00,'Credit Sales for 17,200.00 Litres of AGO from shift 10211 on 2017-05-13 16:25:54 ','2017-05-13 16:25:54','',''),('1','41',136094,'','supplier','49',2700000.00,0.00,'Purchase Id 6823 for 15,000 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-05-23 07:55:40','',''),('1','41',136104,'','customer','669',0.00,4374000.00,'Credit Sales for 24,300.00 Litres of AGO from shift 11081 on 2017-05-23 08:11:28 ','2017-05-23 08:11:28','',''),('1','41',142752,'','supplier','49',7875000.00,0.00,'Purchase Id 7045 for 45,000 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-05-28 16:53:04','',''),('1','41',142782,'','customer','669',0.00,3946250.00,'Credit Sales for 22,550.00 Litres of AGO from shift 11668 on 2017-05-28 17:07:50 ','2017-05-28 17:07:50','',''),('1','41',147105,'','supplier','49',2362500.00,0.00,'Purchase Id 7265 for 13,500 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-06-02 17:16:20','',''),('1','41',154686,'','customer','669',0.00,7403500.00,'Credit Sales for 43,550.00 Litres of AGO from shift 12953 on 2017-06-10 10:52:46 ','2017-06-10 10:52:46','',''),('1','41',154690,'','supplier','49',3400000.00,0.00,'Purchase Id 7552 for 20,000 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-06-10 10:55:55','',''),('1','41',160800,'','supplier','49',6600000.00,0.00,'Purchase Id 7769 for 40,000 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-06-16 16:49:56','',''),('1','41',160914,'','customer','669',0.00,3448500.00,'Credit Sales for 20,900.00 Litres of AGO from shift 13663 on 2017-06-16 17:07:57 ','2017-06-16 17:07:57','',''),('1','41',167321,'','customer','669',0.00,2557500.00,'Credit Sales for 15,500.00 Litres of AGO from shift 14063 on 2017-06-20 17:05:32 ','2017-06-20 17:05:32','',''),('1','41',170726,'','customer','669',0.00,2032000.00,'Credit Sales for 12,700.00 Litres of AGO from shift 14419 on 2017-06-23 18:29:20 ','2017-06-23 18:29:20','',''),('1','41',170730,'','supplier','49',3840000.00,0.00,'Purchase Id 8078 for 24,000 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-06-23 18:31:38','',''),('1','41',176330,'','customer','669',0.00,5208000.00,'Credit Sales for 32,550.00 Litres of AGO from shift 15294 on 2017-07-03 12:01:27 ','2017-07-03 12:01:27','',''),('1','41',176342,'','supplier','49',5760000.00,0.00,'Purchase Id 8412 for 36,000 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-07-03 12:08:26','',''),('1','41',189134,'','customer','669',0.00,5161600.00,'Credit Sales for 32,260.00 Litres of AGO from shift 16376 on 2017-07-14 11:09:58 ','2017-07-14 11:09:58','',''),('1','41',189138,'','supplier','49',2160000.00,0.00,'Purchase Id 8814 for 13,500 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-07-14 11:15:05','',''),('1','41',205422,'','supplier','49',2080000.00,0.00,'Purchase Id 9423 for 13,000 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-07-29 10:12:55','',''),('1','41',205430,'','supplier','49',5440000.00,0.00,'Purchase Id 9424 for 34,000 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-07-29 10:20:00','',''),('1','41',205431,'','customer','669',0.00,9120000.00,'Credit Sales for 57,000.00 Litres of AGO from shift 17850 on 2017-07-29 10:24:03 ','2017-07-29 10:24:03','',''),('1','41',205443,'','supplier','49',3840000.00,0.00,'Purchase Id 9425 for 24,000 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-07-29 10:29:11','',''),('1','41',231128,'','customer','669',0.00,6931360.00,'Credit Sales for 43,321.00 Litres of AGO from shift 19908 on 2017-08-17 16:49:43 ','2017-08-17 16:49:43','',''),('1','41',231144,'','supplier','49',5440000.00,0.00,'Purchase Id 10173 for 34,000 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-08-17 16:52:38','',''),('1','41',231165,'','customer','669',0.00,6292640.00,'Credit Sales for 39,329.00 Litres of AGO from shift 19911 on 2017-08-17 17:01:26 ','2017-08-17 17:01:26','',''),('1','41',231169,'','supplier','49',3600000.00,0.00,'Purchase Id 10175 for 22,500 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-08-17 17:04:22','',''),('1','41',254241,'','customer','669',0.00,3961600.00,'Credit Sales for 24,760.00 Litres of AGO from shift 22441 on 2017-09-11 14:40:52 ','2017-09-11 14:40:52','',''),('1','41',254245,'','supplier','49',6400000.00,0.00,'Purchase Id 10995 for 40,000 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-09-11 14:43:09','',''),('1','41',254246,'','customer','669',0.00,2286560.00,'Credit Sales for 14,291.00 Litres of AGO from shift 22443 on 2017-09-11 14:47:30 ','2017-09-11 14:47:30','',''),('1','41',254254,'','supplier','49',3680000.00,0.00,'Purchase Id 10996 for 23,000 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-09-11 14:49:10','',''),('1','41',254257,'','customer','669',0.00,7585875.00,'Credit Sales for 45,975.00 Litres of AGO from shift 22445 on 2017-09-11 14:55:09 ','2017-09-11 14:55:09','',''),('1','41',254261,'','supplier','49',2145000.00,0.00,'Purchase Id 10997 for 13,000 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-09-11 14:56:37','',''),('1','41',254267,'','supplier','49',5527500.00,0.00,'Purchase Id 10998 for 33,500 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-09-11 15:00:38','',''),('1','41',254278,'','customer','669',0.00,4172850.00,'Credit Sales for 25,290.00 Litres of AGO from shift 22447 on 2017-09-11 15:10:23 ','2017-09-11 15:10:23','',''),('1','41',254285,'','supplier','49',2062500.00,0.00,'Purchase Id 11000 for 12,500 litters of AGO - 002 from A.A RANO NIGERIA LIMITED','2017-09-11 15:13:29','',''),('1','41',2810553,'','2','846',100000.00,0.00,'Payment Id 298031 for invoice:22447, receipt: 2589 by A.A RANO NIGERIA LIMITED','2021-07-14 16:14:36','',''),('1','41',2810554,'','supplier','49',0.00,100000.00,'Payment Id 298031 for invoice:22447, receipt: 2589 by A.A RANO NIGERIA LIMITED','2021-07-14 16:14:36','',''),('1','41',2810557,'','2','846',0.00,100000.00,'Payment Id 298031 for invoice:22447, receipt: 2589 by A.A RANO NIGERIA LIMITED','2021-07-14 16:14:55','',''),('1','41',2810558,'','supplier','49',100000.00,0.00,'Payment Id 298031 for invoice:22447, receipt: 2589 by A.A RANO NIGERIA LIMITED','2021-07-14 16:14:55','',''),('1','41',3766560,'','24','833',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','41',3766565,'','24','826',0.00,95940500.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','41',3766603,'','24','835',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','41',3766724,'','20','828',91397985.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','41',3766905,'','24','831',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','41',3767035,'','2','846',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','41',3767383,'','24','843',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','41',3767596,'','5','847',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','41',3767709,'','24','844',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','41',3767933,'','24','841',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','41',3768226,'','24','840',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','41',3768854,'','24','839',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','41',3768982,'','24','842',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','41',3769030,'','24','829',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','41',3769109,'','6.1','827',0.00,3353500.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','41',3769193,'','24','837',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','41',3769481,'','24','845',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','41',3769508,'','24','836',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','41',3769694,'','24','838',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','41',3769792,'','24','830',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','41',3770101,'','24','832',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('1','41',3770210,'','24','834',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (109,'1','41','AGO','Diesel','Litres',1,165.00,165.00,0.00,0.00,0.00,0,'2017-04-01 14:27:26','96','96','2017-04-01 14:27:26',1);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=2333 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (1386,'1','41',109,190.00,190.00,0.00,0.00,'','2017-04-10 13:17:02','96'),(1621,'1','41',109,185.00,185.00,0.00,0.00,'CHANGE OF AGO PRICE FROM 190-185','2017-05-09 10:41:52','96'),(1656,'1','41',109,180.00,180.00,0.00,0.00,'CHANGE OF AGO PRICE FROM 185-180','2017-05-10 15:22:14','96'),(1756,'1','41',109,175.00,175.00,0.00,0.00,'CHANGE OF AGO PRICE FROM 180-175','2017-05-28 16:43:51','96'),(1856,'1','41',109,170.00,170.00,0.00,0.00,'CHANGE OF AGO  PRICE FROM 175-170','2017-06-10 10:45:58','96'),(1950,'1','41',109,165.00,165.00,0.00,0.00,'CHANGE OF AGO  PRICE FROM 170-165','2017-06-16 16:44:22','96'),(2026,'1','41',109,160.00,160.00,0.00,0.00,'CHANGE OF AGO PRICE FROM 165-160','2017-06-23 17:20:18','96'),(2332,'1','41',109,165.00,165.00,0.00,0.00,'CHANGE OF AGO PRICE FROM 160-165','2017-09-11 14:51:00','96');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11001 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (5298,'1','41','2017-04-10',109,49,190.00,18400.00,0.00,0.00,3496000.00,0.00,'','2119','RAN 488 XA','','','','2017-04-10 13:58:50',15,'PURCHASE OF AGO','96','','0000-00-00 00:00:00','96','2017-04-10 13:59:58'),(5350,'1','41','2017-04-11',109,49,190.00,15000.00,0.00,0.00,2850000.00,0.00,'','2121','RAN 87 XA','','','','2017-04-12 12:58:34',15,'PURCHASE OF AGO','96','','0000-00-00 00:00:00','96','2017-04-12 13:00:03'),(5580,'1','41','2017-04-16',109,49,190.00,24800.00,0.00,0.00,4712000.00,0.00,'','2122','RAN 615 XA','','','','2017-04-19 13:19:32',15,'PURCHASE OF AGO','96','','0000-00-00 00:00:00','96','2017-04-19 13:20:34'),(5807,'1','41','2017-04-24',109,49,190.00,19500.00,0.00,0.00,3705000.00,0.00,'','2123','RAN 488 XA','','','','2017-04-25 13:23:54',15,'PURCHASE OF AGO','96','','0000-00-00 00:00:00','96','2017-04-25 13:25:09'),(5969,'1','41','2017-04-29',109,49,190.00,13500.00,0.00,0.00,2565000.00,0.00,'','2126','TRN 207 ZG','','','','2017-04-29 10:33:37',15,'PURCHASE OF AGO','96','','0000-00-00 00:00:00','96','2017-04-29 10:34:31'),(6374,'1','41','2017-05-09',109,49,185.00,20000.00,0.00,0.00,3700000.00,0.00,'','2128','RAN 380 XA','','','','2017-05-10 15:09:56',15,'PURCHASE OF AGO','96','','0000-00-00 00:00:00','96','2017-05-10 15:10:44'),(6823,'1','41','2017-05-18',109,49,180.00,15000.00,0.00,0.00,2700000.00,0.00,'','2129','NSR 141 ZD','','','','2017-05-23 07:53:58',15,'PURCHASE OF AG0','96','','0000-00-00 00:00:00','96','2017-05-23 07:55:40'),(7045,'1','41','2017-05-26',109,49,175.00,45000.00,0.00,0.00,7875000.00,0.00,'','2130','STK 20 XA','','','','2017-05-28 16:46:29',15,'PURCHASE OF AGO','96','','0000-00-00 00:00:00','96','2017-05-28 16:53:04'),(7265,'1','41','2017-06-01',109,49,175.00,13500.00,0.00,0.00,2362500.00,0.00,'','2131','RAN 591 XA','','','','2017-06-02 17:14:09',15,'PURCHASE OF AGO','96','','0000-00-00 00:00:00','96','2017-06-02 17:16:20'),(7552,'1','41','2017-06-07',109,49,170.00,20000.00,0.00,0.00,3400000.00,0.00,'','2133','RAN 387 XA','','','','2017-06-10 10:55:29',15,'PURCHASE OF AGO','96','','0000-00-00 00:00:00','96','2017-06-10 10:55:55'),(7769,'1','41','2017-06-15',109,49,165.00,40000.00,0.00,0.00,6600000.00,0.00,'','2134','GAR 120 XA','','','','2017-06-16 16:48:37',15,'PURCHASE OF AGO','96','','0000-00-00 00:00:00','96','2017-06-16 16:49:56'),(8078,'1','41','2017-06-23',109,49,160.00,24000.00,0.00,0.00,3840000.00,0.00,'','2136','RAN 462 XA','','','','2017-06-23 18:31:05',15,'PURCHASE OF AGO','96','','0000-00-00 00:00:00','96','2017-06-23 18:31:38'),(8412,'1','41','2017-07-03',109,49,160.00,36000.00,0.00,0.00,5760000.00,0.00,'','1764','RAN 462 XA','','','','2017-07-03 12:07:50',15,'PURCHASE OF AGO','96','','0000-00-00 00:00:00','96','2017-07-03 12:08:26'),(8814,'1','41','2017-07-09',109,49,160.00,13500.00,0.00,0.00,2160000.00,0.00,'','1010','RAN 842 XA','','','','2017-07-14 11:14:41',15,'PURCHASE OF AGO','96','','0000-00-00 00:00:00','96','2017-07-14 11:15:05'),(9423,'1','41','2017-07-19',109,49,160.00,13000.00,0.00,0.00,2080000.00,0.00,'','111','MGR 16 XA','','','','2017-07-29 10:11:58',15,'PURCHASE OF AGO','96','','0000-00-00 00:00:00','96','2017-07-29 10:12:55'),(9424,'1','41','2017-07-20',109,49,160.00,34000.00,0.00,0.00,5440000.00,0.00,'','122','RAN 462 XA','','','','2017-07-29 10:19:26',15,'PURCHASE OF AGO','96','','0000-00-00 00:00:00','96','2017-07-29 10:20:00'),(9425,'1','41','2017-07-28',109,49,160.00,24000.00,0.00,0.00,3840000.00,0.00,'','501','XB 248 BBR','','','','2017-07-29 10:28:44',15,'PURCHASE OF AGO','96','','0000-00-00 00:00:00','96','2017-07-29 10:29:11'),(10173,'1','41','2017-08-04',109,49,160.00,34000.00,0.00,0.00,5440000.00,0.00,'','502','KZR 735 XA','','','','2017-08-17 16:52:16',15,'PURCHASE OF AGO','96','','0000-00-00 00:00:00','96','2017-08-17 16:52:38'),(10175,'1','41','2017-08-10',109,49,160.00,22500.00,0.00,0.00,3600000.00,0.00,'','503','RAN 493 XA','','','','2017-08-17 17:03:59',15,'PURCHASE OF AGO','96','','0000-00-00 00:00:00','96','2017-08-17 17:04:22'),(10995,'1','41','2017-08-17',109,49,160.00,40000.00,0.00,0.00,6400000.00,0.00,'','504','DKA 193 ZU','','','','2017-09-11 14:42:47',15,'PURCHASE OF AGO','96','','0000-00-00 00:00:00','96','2017-09-11 14:43:09'),(10996,'1','41','2017-08-27',109,49,160.00,23000.00,0.00,0.00,3680000.00,0.00,'','505','RAN 462 XA','','','','2017-09-11 14:48:51',15,'PURCAHSE OF AGO','96','','0000-00-00 00:00:00','96','2017-09-11 14:49:10'),(10997,'1','41','2017-08-28',109,49,165.00,13000.00,0.00,0.00,2145000.00,0.00,'','506','RAN 456 XA','','','','2017-09-11 14:56:20',15,'PURCHASE OS AGO','96','','0000-00-00 00:00:00','96','2017-09-11 14:56:37'),(10998,'1','41','2017-09-03',109,49,165.00,33500.00,0.00,0.00,5527500.00,0.00,'','507','RAN 20 XA','','','','2017-09-11 14:59:55',15,'PURCHASE OF AGO','96','','0000-00-00 00:00:00','96','2017-09-11 15:00:38'),(11000,'1','41','2017-09-07',109,49,165.00,12500.00,0.00,0.00,2062500.00,0.00,'','508','XB 928 GML','','','','2017-09-11 15:13:05',15,'PURCHASE OF AGO','96','','0000-00-00 00:00:00','96','2017-09-11 15:13:29');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=298032 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (298031,'1','41','2021-07-14',49,'2589','','5',100000.00,'22447','','','846','Testing','2158',4172850.00,'2021-07-14 16:14:25',2,'','178','','0000-00-00 00:00:00','178','2021-07-14 16:14:36');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16286 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (7778,'1',5298,'41',109,49,'2017-04-10 00:00:00',NULL,18400.00,18400.00,0.00,'2119','','308','RAN 488 XA','IBRAHIM','07063442356','DISCHA',5,'2017-04-10 14:03:47','96','0000-00-00 00:00:00','','2017-04-10 14:04:13','96'),(7860,'1',5350,'41',109,49,'2017-04-12 00:00:00',NULL,15000.00,15000.00,0.00,'2121','','308','RAN 87 XA','YUSIF','07063442356','DISCHARGE OF AGO',5,'2017-04-12 13:03:42','96','0000-00-00 00:00:00','','2017-04-12 13:04:42','96'),(8209,'1',5580,'41',109,49,'2017-04-19 00:00:00',NULL,24800.00,24800.00,0.00,'2122','','308','RAN 615 XA','BABA GARBA','07063442356','DISCHARGE OF AGO',5,'2017-04-19 13:23:18','96','0000-00-00 00:00:00','','2017-04-19 13:24:14','96'),(8606,'1',5807,'41',109,49,'2017-04-25 00:00:00',NULL,19500.00,19500.00,0.00,'2123','','308','RAN 488 XA','IBRAHIM IRO','07063442356','DISCHARGE OF AGO',5,'2017-04-25 13:28:42','96','0000-00-00 00:00:00','','2017-04-25 13:29:33','96'),(8864,'1',5969,'41',109,49,'2017-04-29 00:00:00',NULL,13500.00,13500.00,0.00,'2126','','308','TRN 207 ZG','SANI IDRIS','07063442356','DISCHARGE OF AGO',5,'2017-04-29 10:37:02','96','0000-00-00 00:00:00','','2017-04-29 10:38:33','96'),(9445,'1',6374,'41',109,49,'2017-05-10 00:00:00',NULL,20000.00,20000.00,0.00,'2128','','308','RAN 380 XA','MUH,D MUSA','07063442356','DISCHARGE OF AGO',5,'2017-05-10 15:13:35','96','0000-00-00 00:00:00','','2017-05-10 15:14:40','96'),(10127,'1',6823,'41',109,49,'2017-05-23 00:00:00',NULL,15000.00,15000.00,0.00,'2129','','308','NSR 141 ZD','ABDULLAHI','07063442356','DISCHARGE OF AGO',5,'2017-05-23 07:58:32','96','0000-00-00 00:00:00','','2017-05-23 08:00:18','96'),(10461,'1',7045,'41',109,49,'2017-05-28 00:00:00',NULL,45000.00,45000.00,0.00,'2130','','308','STK 20 XA','IBRAHIM TIJANI','07063442356','DISCHARGE OF AGO',5,'2017-05-28 16:56:59','96','0000-00-00 00:00:00','','2017-05-28 17:00:03','96'),(10775,'1',7265,'41',109,49,'2017-06-02 00:00:00',NULL,13500.00,13500.00,0.00,'2131','','308','RAN 591 XA','MUHAMMED ADAMU','07063442356','DISCHARGE OF AGO',5,'2017-06-02 17:19:32','96','0000-00-00 00:00:00','','2017-06-02 17:20:22','96'),(11215,'1',7552,'41',109,49,'2017-06-10 00:00:00',NULL,2000.00,20000.00,0.00,'2133','','308','RAN 387 XA','NURA MAGAJI ','07063442356','DISCHARGE OF AGO',5,'2017-06-10 10:57:32','96','0000-00-00 00:00:00','','2017-06-10 10:58:40','96'),(11216,'1',7552,'41',109,49,'2017-06-10 00:00:00',NULL,18000.00,18000.00,0.00,'2133','','308','RAN 387 XA','NURA MAGAJI ','07063442356','DISCHARGE OF AGO',5,'2017-06-10 11:00:01','96','0000-00-00 00:00:00','','2017-06-10 11:00:22','96'),(11785,'1',7769,'41',109,49,'2017-06-20 00:00:00',NULL,40000.00,40000.00,0.00,'2443','','308','GAR 120 XA','MUH,D MUSA','07063442356','DISCHARGE OF AGO',5,'2017-06-20 17:08:34','96','0000-00-00 00:00:00','','2017-06-20 17:09:01','96'),(12026,'1',8078,'41',109,49,'2017-06-23 00:00:00',NULL,24000.00,24000.00,0.00,'2136','','308','RAN 462 XA','SHEHU','07037988745','DISCHARGE OF AGO',5,'2017-06-23 18:32:35','96','0000-00-00 00:00:00','','2017-06-23 18:32:54','96'),(13024,'1',8412,'41',109,49,'2017-07-14 00:00:00',NULL,35800.00,35800.00,0.00,'1159','','308','RAN 419 XA','MUHAMMED','07037988745','DISCHARGE OF AGO',5,'2017-07-14 11:06:03','96','0000-00-00 00:00:00','','2017-07-14 11:06:24','96'),(13025,'1',8412,'41',109,49,'2017-07-14 00:00:00',NULL,200.00,200.00,0.00,'1159','','308','RAN 462 XA','MUHAMMED','07033850073','DISCHARGE OF AGO',5,'2017-07-14 11:11:30','96','0000-00-00 00:00:00','','2017-07-14 11:11:55','96'),(13026,'1',8814,'41',109,49,'2017-07-14 00:00:00',NULL,13500.00,13500.00,0.00,'1010','','308','RAN 842 XA','NASIRU','07063328336','DISCHARGE OF AGO',5,'2017-07-14 11:15:52','96','0000-00-00 00:00:00','','2017-07-14 11:16:05','96'),(13887,'1',9423,'41',109,49,'2017-07-29 00:00:00',NULL,13000.00,13000.00,0.00,'111','','308','MGR 16 XA','YUSIF','07063442356','DISCHARGE OF AGO',5,'2017-07-29 10:14:09','96','0000-00-00 00:00:00','','2017-07-29 10:14:56','96'),(13888,'1',9424,'41',109,49,'2017-07-29 00:00:00',NULL,5500.00,5500.00,0.00,'122','','308','RAN 462 XA','SAMILA','07063442356','DISCHARGE OF AGO',5,'2017-07-29 10:20:59','96','0000-00-00 00:00:00','','2017-07-29 10:21:29','96'),(13889,'1',9424,'41',109,49,'2017-07-29 00:00:00',NULL,28500.00,28500.00,0.00,'122','','308','RAN 462 XA','SAMILA','07063442356','DISCHARGE OF AGO',5,'2017-07-29 10:25:47','96','0000-00-00 00:00:00','','2017-07-29 10:27:02','96'),(13890,'1',9425,'41',109,49,'2017-07-29 00:00:00',NULL,24000.00,24000.00,0.00,'501','','308','XB 248 BBR','SHA,AIBU INUWA','07063442356','DISCHARGE OF AGO',5,'2017-07-29 10:30:37','96','0000-00-00 00:00:00','','2017-07-29 10:31:12','96'),(15039,'1',10173,'41',109,49,'2017-08-17 00:00:00',NULL,34000.00,34000.00,0.00,'502','','308','KZR 735 XA','DAN BAJOGA','07063442356','DISCHARGE OF AGO',5,'2017-08-17 16:55:34','96','0000-00-00 00:00:00','','2017-08-17 16:55:58','96'),(15043,'1',10175,'41',109,49,'2017-08-17 00:00:00',NULL,22500.00,22500.00,0.00,'503','','308','RAN 493 XA','ALHAJI MUSA','07063442356','DISCHARGE OF AGO',5,'2017-08-17 17:05:53','96','0000-00-00 00:00:00','','2017-08-17 17:06:20','96'),(16279,'1',10995,'41',109,49,'2017-09-11 00:00:00',NULL,40000.00,40000.00,0.00,'504','','308','DKA 193 ZU','HAMISU DOGO','07063442356','DISCHARGE OF AGO',5,'2017-09-11 14:44:33','96','0000-00-00 00:00:00','','2017-09-11 14:44:49','96'),(16280,'1',10996,'41',109,49,'2017-09-11 00:00:00',NULL,23000.00,23000.00,0.00,'505','','308','RAN 462 XA','SHEHU ABDULLAHI','07063442356','DISCHARGE OF AGO',5,'2017-09-11 14:49:59','96','0000-00-00 00:00:00','','2017-09-11 14:50:19','96'),(16281,'1',10997,'41',109,49,'2017-09-11 00:00:00',NULL,13000.00,13000.00,0.00,'506','','308','RAN 456 XA','AC MUKA','07063442356','DISCHARGE OF AGO',5,'2017-09-11 14:57:34','96','0000-00-00 00:00:00','','2017-09-11 14:57:53','96'),(16282,'1',10998,'41',109,49,'2017-09-11 00:00:00',NULL,33500.00,33500.00,0.00,'507','','308','RAN 20 XA','GAMBO','07063442356','DISCHARGE OF AGO',5,'2017-09-11 15:02:42','96','0000-00-00 00:00:00','','2017-09-11 15:03:47','96'),(16285,'1',11000,'41',109,49,'2017-09-11 00:00:00',NULL,12500.00,12500.00,0.00,'508','','308','XB 928 GML','BABAJI','07063442356','DISCHARGE OF AGO',5,'2017-09-11 15:14:47','96','0000-00-00 00:00:00','','2017-09-11 15:15:03','96');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB AUTO_INCREMENT=53798 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
INSERT INTO `sales` VALUES (26977,'1','41','7639',1,'2017-04-13',109,670,190.00,190.00,5400.00,0.00,0.00,1026000.00,'1492102322','2017-04-13 16:52:02',15,0,'5400 LITRES IFO KZR 521 YANSR 154ZQKMC 791ZQKSF 930XSKMC 922ZYRAN 87XACEO APPROVED',NULL,'96','','0000-00-00 00:00:00','96','2017-04-13 16:52:47'),(27721,'1','41','7770',1,'2017-04-19',109,669,190.00,190.00,20450.00,0.00,0.00,3885500.00,'1492607089','2017-04-19 13:04:49',15,0,'IFOTRN 261 ZGRAN401 XARAN 482XARAN 388XARAN 354XARAN 434XARAN 423XARAN 359XAKMC 797ZQRAN 508XARAN 375XARAN 812XANSR 141ZDRAN 448XARAN 693XARAN 438XAGML 27 XARAN 415XAKMC 115YQRAN445XANSR 323ZXKMC 795ZQRAN 615XACEO APPROVED',NULL,'96','','0000-00-00 00:00:00','96','2017-04-19 13:05:47'),(28599,'1','41','',0,'2017-04-25',109,669,190.00,190.00,15000.00,0.00,0.00,2850000.00,'04251004','2017-04-25 10:05:36',0,0,'BULK SALE B/O CHAIRMAN',NULL,'96','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(29527,'1','41','8895',1,'2017-04-30',109,669,190.00,190.00,10200.00,0.00,0.00,1938000.00,'1493541903','2017-04-30 08:45:03',15,0,'10200 LITRES OF AGO IFOFRG 72KGRAN 369XARAN 685XARAN 843XAKMC 923ZYRAN 337XAKSF 936XSFKJ 69XTKSF 930XTRAN 820XAFKJ 71XTTRN 216ZGXB 248 BBR',NULL,'96','','0000-00-00 00:00:00','96','2017-04-30 08:45:56'),(30871,'1','41','9774',1,'2017-05-09',109,669,185.00,185.00,19550.00,0.00,0.00,3616750.00,'1494327701','2017-05-09 11:01:41',15,0,'19550 LITRES OF AGO IFORAN 435XARAN 387XAKSF 930XTKMC 446 YEFKJ 69XTDKD 265 XARAN 427 XARAN 385XAKTU 255XT.RAN 411XAKSF 936XSSTK 24XARAN 375XARAN442XARAN 806 XAFKJ 71XTRAN 355XARAN 398XARAN 604 XAKMC 349YQ',NULL,'96','','0000-00-00 00:00:00','96','2017-05-09 11:02:13'),(31786,'1','41','10211',1,'2017-05-13',109,669,180.00,180.00,17200.00,0.00,0.00,3096000.00,'1494692722','2017-05-13 16:25:22',15,0,'17200 LITRES IFORAN 380XARAN 435XARAN 394XATRN 416ZGRAN 374XARAN 817XARAN 433XARAN 641XARAN 388XAGML 606XARAN 400XARAN 684XAFKJ 72XTRAN 367XAHTA 212XARAN 401XA',NULL,'96','','0000-00-00 00:00:00','96','2017-05-13 16:25:54'),(33441,'1','41','11081',1,'2017-05-23',109,669,180.00,180.00,24300.00,0.00,0.00,4374000.00,'1495527052','2017-05-23 08:10:52',15,0,'24300 LITRES OF AGO IFO OF THE FOLLOWING TRUCKSKMC 395ZVRAN 368XARAN 398XARAN 358XARAN 402XARAN 384XARAN 364XARAN 382XATRN 418ZGRAN 813XARAN 392XARAN 588XANSR 141ZDRAN 827XARAN 690XATRR 392XARAN 376XARAN 424XARAN 443XARAN 358XATRN 416ZGFKJ 72XT',NULL,'96','','0000-00-00 00:00:00','96','2017-05-23 08:11:28'),(34521,'1','41','11668',1,'2017-05-28',109,669,175.00,175.00,22550.00,0.00,0.00,3946250.00,'1495991243','2017-05-28 17:07:23',15,0,'TRIP ALLOWANCE RAN 111 XA ABUJA TO LAGOS',NULL,'96','','0000-00-00 00:00:00','96','2017-05-28 17:07:50'),(36845,'1','41','12953',1,'2017-06-10',109,669,170.00,170.00,43550.00,0.00,0.00,7403500.00,'1497091943','2017-06-10 10:52:23',15,0,'TRIP ALLOWANCE RAN 111 XA ABUJA TO LAGOS',NULL,'96','','0000-00-00 00:00:00','96','2017-06-10 10:52:46'),(38080,'1','41','13663',1,'2017-06-16',109,669,165.00,165.00,20900.00,0.00,0.00,3448500.00,'1497632835','2017-06-16 17:07:15',15,0,'TRIP ALLOWANCE RAN 111 XA FROM ABUJA TO LAGOS',NULL,'96','','0000-00-00 00:00:00','96','2017-06-16 17:07:57'),(38668,'1','41','14063',1,'2017-06-20',109,669,165.00,165.00,15500.00,0.00,0.00,2557500.00,'1497978304','2017-06-20 17:05:04',15,0,'TRIP ALLOWANCE RAN 111 XA FROM ABUJA TO LAGOS',NULL,'96','','0000-00-00 00:00:00','96','2017-06-20 17:05:32'),(39392,'1','41','14419',1,'2017-06-23',109,669,160.00,160.00,12700.00,0.00,0.00,2032000.00,'1498242539','2017-06-23 18:28:59',15,0,'TRIP ALLOWANCE RAN 111 XA ABUJA TO LAGOS',NULL,'96','','0000-00-00 00:00:00','96','2017-06-23 18:29:20'),(40845,'1','41','15294',1,'2017-07-03',109,669,160.00,160.00,32550.00,0.00,0.00,5208000.00,'1499083256','2017-07-03 12:00:56',15,0,'TRIP ALLOWANCE RAN 111 XA FROM ABUJA TO LAGOS',NULL,'96','','0000-00-00 00:00:00','96','2017-07-03 12:01:27'),(42760,'1','41','16376',1,'2017-07-14',109,669,160.00,160.00,32260.00,0.00,0.00,5161600.00,'1500030561','2017-07-14 11:09:21',15,0,'TRIP ALLOWANCE  RAN 111 XAABUJA TO LAGOS',NULL,'96','','0000-00-00 00:00:00','96','2017-07-14 11:09:58'),(45815,'1','41','17850',1,'2017-07-29',109,669,160.00,160.00,57000.00,0.00,0.00,9120000.00,'1501323803','2017-07-29 10:23:23',15,0,'TRIP ALLOWANCE RAN 111 XA ABUJA TO LAGOS',NULL,'96','','0000-00-00 00:00:00','96','2017-07-29 10:24:03'),(49542,'1','41','19908',1,'2017-08-17',109,669,160.00,160.00,43321.00,0.00,0.00,6931360.00,'1502988563','2017-08-17 16:49:23',15,0,'TRIP ALLOWANCE RAN  111 XA ABUJA TO LADOS',NULL,'96','','0000-00-00 00:00:00','96','2017-08-17 16:49:43'),(49547,'1','41','19911',1,'2017-08-17',109,669,160.00,160.00,39329.00,0.00,0.00,6292640.00,'1502989254','2017-08-17 17:00:54',15,0,'TRIP ALLOWANCE RAN 111 XA ABUJA TO LAGOS',NULL,'96','','0000-00-00 00:00:00','96','2017-08-17 17:01:26'),(53787,'1','41','22441',1,'2017-09-11',109,669,160.00,160.00,24760.00,0.00,0.00,3961600.00,'1505140833','2017-09-11 14:40:33',15,0,'TRIP ALLOWANCE RAN 111XA ABUJA TO LAGOS',NULL,'96','','0000-00-00 00:00:00','96','2017-09-11 14:40:52'),(53788,'1','41','22443',1,'2017-09-11',109,669,160.00,160.00,14291.00,0.00,0.00,2286560.00,'1505141232','2017-09-11 14:47:12',15,0,'TRIP ALLOWANCE RAN 111 XA ABUJA TO LAGOS',NULL,'96','','0000-00-00 00:00:00','96','2017-09-11 14:47:30'),(53789,'1','41','22445',1,'2017-09-11',109,669,165.00,165.00,45975.00,0.00,0.00,7585875.00,'1505141684','2017-09-11 14:54:44',15,0,'TRIP ALLOWANCE RAN 111 XA ABUJA TO LAGOS',NULL,'96','','0000-00-00 00:00:00','96','2017-09-11 14:55:09'),(53797,'1','41','22447',1,'2017-09-11',109,669,165.00,165.00,25290.00,0.00,0.00,4172850.00,'1505142581','2017-09-11 15:09:41',15,0,'TRIP ALLOWANCE RAN 111 XA ABUJA TO LAGOS',NULL,'96','','0000-00-00 00:00:00','96','2017-09-11 15:10:23');
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB AUTO_INCREMENT=42291 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
INSERT INTO `sales_distributions` VALUES (20452,'1',26977,'',0,'41',109,670,'2017-04-13',5400.00,'','','','308','834','','','Dispensed on shift # 7639',5,'2017-04-13 16:52:47','96','0000-00-00 00:00:00','','2017-04-13 16:52:47','96'),(21051,'1',27721,'',0,'41',109,669,'2017-04-19',20450.00,'','','','308','834','','','Dispensed on shift # 7770',5,'2017-04-19 13:05:47','96','0000-00-00 00:00:00','','2017-04-19 13:05:47','96'),(22355,'1',29527,'',0,'41',109,669,'2017-04-30',10200.00,'','','','308','833','','','Dispensed on shift # 8895',5,'2017-04-30 08:45:56','96','0000-00-00 00:00:00','','2017-04-30 08:45:56','96'),(23451,'1',30871,'',0,'41',109,669,'2017-05-09',19550.00,'','','','308','833','','','Dispensed on shift # 9774',5,'2017-05-09 11:02:13','96','0000-00-00 00:00:00','','2017-05-09 11:02:13','96'),(24167,'1',31786,'',0,'41',109,669,'2017-05-13',17200.00,'','','','308','834','','','Dispensed on shift # 10211',5,'2017-05-13 16:25:54','96','0000-00-00 00:00:00','','2017-05-13 16:25:54','96'),(25526,'1',33441,'',0,'41',109,669,'2017-05-23',24300.00,'','','','308','833','','','Dispensed on shift # 11081',5,'2017-05-23 08:11:28','96','0000-00-00 00:00:00','','2017-05-23 08:11:28','96'),(26426,'1',34521,'',0,'41',109,669,'2017-05-28',22550.00,'','','','308','834','','','Dispensed on shift # 11668',5,'2017-05-28 17:07:50','96','0000-00-00 00:00:00','','2017-05-28 17:07:50','96'),(28357,'1',36845,'',0,'41',109,669,'2017-06-10',43550.00,'','','','308','833','','','Dispensed on shift # 12953',5,'2017-06-10 10:52:46','96','0000-00-00 00:00:00','','2017-06-10 10:52:46','96'),(29346,'1',38080,'',0,'41',109,669,'2017-06-16',20900.00,'','','','308','833','','','Dispensed on shift # 13663',5,'2017-06-16 17:07:57','96','0000-00-00 00:00:00','','2017-06-16 17:07:57','96'),(29836,'1',38668,'',0,'41',109,669,'2017-06-20',15500.00,'','','','308','833','','','Dispensed on shift # 14063',5,'2017-06-20 17:05:32','96','0000-00-00 00:00:00','','2017-06-20 17:05:32','96'),(30411,'1',39392,'',0,'41',109,669,'2017-06-23',12700.00,'','','','308','834','','','Dispensed on shift # 14419',5,'2017-06-23 18:29:20','96','0000-00-00 00:00:00','','2017-06-23 18:29:20','96'),(31618,'1',40845,'',0,'41',109,669,'2017-07-03',32550.00,'','','','308','834','','','Dispensed on shift # 15294',5,'2017-07-03 12:01:27','96','0000-00-00 00:00:00','','2017-07-03 12:01:27','96'),(33316,'1',42760,'',0,'41',109,669,'2017-07-14',32260.00,'','','','308','834','','','Dispensed on shift # 16376',5,'2017-07-14 11:09:58','96','0000-00-00 00:00:00','','2017-07-14 11:09:58','96'),(35741,'1',45815,'',0,'41',109,669,'2017-07-29',57000.00,'','','','308','834','','','Dispensed on shift # 17850',5,'2017-07-29 10:24:03','96','0000-00-00 00:00:00','','2017-07-29 10:24:03','96'),(38836,'1',49542,'',0,'41',109,669,'2017-08-17',43321.00,'','','','308','833','','','Dispensed on shift # 19908',5,'2017-08-17 16:49:43','96','0000-00-00 00:00:00','','2017-08-17 16:49:43','96'),(38841,'1',49547,'',0,'41',109,669,'2017-08-17',39329.00,'','','','308','834','','','Dispensed on shift # 19911',5,'2017-08-17 17:01:26','96','0000-00-00 00:00:00','','2017-08-17 17:01:26','96'),(42285,'1',53787,'',0,'41',109,669,'2017-09-11',24760.00,'','','','308','834','','','Dispensed on shift # 22441',5,'2017-09-11 14:40:52','96','0000-00-00 00:00:00','','2017-09-11 14:40:52','96'),(42286,'1',53788,'',0,'41',109,669,'2017-09-11',14291.00,'','','','308','833','','','Dispensed on shift # 22443',5,'2017-09-11 14:47:30','96','0000-00-00 00:00:00','','2017-09-11 14:47:30','96'),(42287,'1',53789,'',0,'41',109,669,'2017-09-11',45975.00,'','','','308','834','','','Dispensed on shift # 22445',5,'2017-09-11 14:55:09','96','0000-00-00 00:00:00','','2017-09-11 14:55:09','96'),(42290,'1',53797,'',0,'41',109,669,'2017-09-11',25290.00,'','','','308','833','','','Dispensed on shift # 22447',5,'2017-09-11 15:10:23','96','0000-00-00 00:00:00','','2017-09-11 15:10:23','96');
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (49,'1','41','A.A RANO NIGERIA LIMITED','IBRAHIM USMAN BAFFA','08033685553','baffa@aaranonigeria.com','KANO','KANO','AA RANO HOUSE, HOTORO','Nigeria',0.00,0.00,'0000-00-00','2017-04-01 14:28:11',5,'96','2017-04-01 14:28:11','96');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:54:49
