-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_313
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_313`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_313` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_313`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,4000,'',0,'22','1','313','PURCHASES','','2023-01-23 11:03:37',5,0.00,0.00,'','479','2023-01-23 11:03:37','479',0,0),(2,8000,'',0,'24','1','313','PURCHASES','','2023-01-23 11:03:49',5,0.00,0.00,'','479','2023-01-23 11:03:49','479',0,0),(3,8001,'',0,'24','1','313','SALARIES & WAGES','','2023-01-23 11:04:00',5,0.00,0.00,'','479','2023-01-23 11:04:00','479',0,0),(4,7000,'',0,'20','1','313','SALES','','2023-01-23 11:04:11',5,0.00,0.00,'','479','2023-01-23 11:04:11','479',0,0),(5,500,'',0,'6.1','1','313','CASH','','2023-01-23 11:04:25',5,0.00,0.00,'','479','2023-01-23 11:04:25','479',0,0),(6,2500,'',0,'2','1','313','UNITY BANK-0024061656','','2023-01-23 11:05:00',5,0.00,0.00,'','479','2023-01-23 11:05:00','479',0,0),(7,2501,'',0,'2','1','313','UBA-0039769388','','2023-01-23 11:05:15',5,0.00,0.00,'','479','2023-01-23 11:05:15','479',0,0),(8,2502,'',0,'2','1','313','UBA YOLA-1021398099','','2023-01-23 11:05:32',5,0.00,0.00,'','479','2023-01-23 11:05:32','479',0,0),(9,2503,'',0,'2','1','313','UBA-1019882661','','2023-01-23 11:05:43',5,0.00,0.00,'','479','2023-01-23 11:05:43','479',0,0),(10,2504,'',0,'2','1','313','FID POS COLLECTION-5620141491','','2023-01-23 11:07:32',5,0.00,0.00,'','479','2023-01-23 11:07:32','479',0,0),(11,2505,'',0,'2','1','313','FB(IBAL)2023855223','','2023-01-23 11:07:44',5,0.00,0.00,'','479','2023-01-23 11:07:44','479',0,0),(12,2506,'',0,'2','1','313','DANKANO-EBILLS:ZNB1014717618','','2023-01-23 11:08:09',5,0.00,0.00,'','479','2023-01-23 11:08:09','479',0,0),(13,2507,'',0,'2','1','313','ZB(LPG)1014471475','','2023-01-23 11:08:35',5,0.00,0.00,'','479','2023-01-23 11:08:35','479',0,0),(14,2508,'',0,'2','1','313','ZNB E-BILL COLLECTION :1014717','','2023-01-23 11:08:46',5,0.00,0.00,'','479','2023-01-23 11:08:46','479',0,0),(15,2509,'',0,'2','1','313','ZNB-:POS 1015965368','','2023-01-23 11:08:56',5,0.00,0.00,'','479','2023-01-23 11:08:56','479',0,0),(16,2510,'',0,'2','1','313','E-BILLS  IBAL 1015372548','','2023-01-23 11:09:26',5,0.00,0.00,'','479','2023-01-23 11:09:26','479',0,0),(17,2511,'',0,'2','1','313','E-BILLS 1015372548','','2023-01-23 11:09:39',5,0.00,0.00,'','479','2023-01-23 11:09:39','479',0,0),(18,2512,'',0,'2','1','313','POLARIS BANK KEBBI:4091417377','','2023-01-23 11:09:56',5,0.00,0.00,'','479','2023-01-23 11:09:56','479',0,0),(19,2513,'',0,'2','1','313','TAJJ BANK CITY GATE:0001875361','','2023-01-23 11:10:05',5,0.00,0.00,'','479','2023-01-23 11:10:05','479',0,0),(20,2514,'',0,'2','1','313','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 15:36:16',5,0.00,0.00,'','792','2023-02-20 15:36:16','792',0,0),(21,2515,'',0,'2','1','313','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:56:45',5,0.00,0.00,'2023-03-15','792','2023-03-17 14:15:50','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','313','Dealer','goldie street calabar south','08068616225','yuseefrano@gmail.com','calabar','cross river','calabar','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-22 10:06:33',5,'1028','2023-02-28 09:04:02','1028'),(2,'','1','313','DAN-ENEYO ENTP.','29 Ekondo street Calabar south','08059014047','eneyodaneielefa@yahoo.com','calabar','crossriver','29 Ekondo street Calabar south','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-28 09:08:04',5,'1028','2023-02-28 09:08:04','1028'),(3,'','1','313','Rhema Gas','88 Goldie Street Calabar','09156019944','uchee1755@gmail.com','Calabar','Cross River','88 Goldie Street Calabar','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-02 10:56:02',5,'1028','2023-03-06 15:28:01','1028'),(4,'','1','313','Fortune Gas','Fortune','08063452775','masterpcollection@gmail.com','Calabar','Cross River','# 10 goldie by bedwell str. cal.','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-02 11:48:16',5,'1028','2023-03-02 11:48:16','1028'),(5,'','1','313','Peters Gas','Peter Edward Inyang','08065617213','peterw.com@gmail','calabar','Cross River','27 uwanse, by uwanse lane','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-06 10:15:23',5,'1028','2023-03-06 10:15:23','1028'),(6,'','1','313','OPERATIONAL LOSS','HAFIZ GAYA','08069129774','hafiznuralpg@gmail.com','NASARAWA','KANO ','Hotoro Nnpc depot','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-08 18:20:06',5,'1028','2023-03-08 18:22:15','1028'),(7,'','1','313','LADY P GAS','35. BASSEY DUKE STREET CALABAR','09070933600','cristopherobinna1002@gmail.com','calabar','Cross river','35. BASSEY DUKE STREET CALABAR','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-13 09:15:35',5,'1028','2023-03-13 09:15:35','1028'),(8,'','1','313','Archibest and Sons ','Kokoette Archibong','08130429800','kokoettejaekson@gmail.com','calabar','Cross River','10 Atekong street','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-13 09:29:18',5,'1028','2023-03-13 09:29:18','1028'),(9,'','1','313','Effa okon','Effa Okon Asuquo','09065741991','effaokon@gmail.com','Calabar','Cross River','103 Parliamentary Extension','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-13 10:06:19',5,'1028','2023-03-13 10:06:19','1028'),(10,'','1','313','GasMan Station','Saviour Ene','09168245897','princesaviour2018@gmail.co','calabar','Cross River','43 Egerton off watt market','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-13 10:31:30',5,'1028','2023-03-13 10:31:30','1028'),(11,'','1','313','Asu Gas','Asuquo Etim Akpandem','07063917587','akpasu83@gmail.com','calabar','Cross River','58 Marian Road Calabar','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-13 10:35:47',5,'1028','2023-03-13 10:35:47','1028'),(12,'','1','313','LYNKKIZ D Gas','Tom chino','08039445929','toasuquo@gmail.com','calabar','Cross River','#63 Old Marian off marian market','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-13 13:40:57',5,'1028','2023-03-13 13:40:57','1028'),(13,'','1','313','E3 ','Edem Ita Okon','08069527333','@gmail.com','calabar','Cross River','9 nsefik layout','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-13 13:43:09',5,'1028','2023-03-13 13:43:09','1028'),(14,'','1','313','Jay ','Jay Gas','0807176773','@gmail.com','calabar','Cross River','5 Andem Asa road wapi junction','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-13 13:46:02',5,'1028','2023-03-13 13:46:02','1028'),(15,'','1','313','Mega Gas','Joseph Ekpe Onyekachi','08038029008','@gmail.com','calabar','Cross River','#9 Eastern Highway, Calabar','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-13 13:48:14',5,'1028','2023-03-13 13:48:14','1028'),(16,'','1','313','Tomain Oil and Gas ','Okwudilli Kingsley Uzonwanne','08060899171','okwudillifoundation@yahoo.com','calabar','Cross River','64 Nelson Mandela Street, Calabar south','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-13 16:49:01',5,'1028','2023-03-13 16:49:01','1028'),(17,'','1','313','Ephraimetizer\'s Gas','Ephraim Christopher Peter','0909549161','peterephraim58@gmail.com','calabar','Cross River','25 murray street off addi street','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-14 10:29:29',5,'1028','2023-03-14 10:29:29','1028'),(18,'','1','313','Jumbo','Ejike Jumbo','07038250335','@gmail.com','calabar','Cross River','5 Atamunu ','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-20 14:05:21',5,'1028','2023-03-20 14:05:21','1028'),(19,'','1','313','chibuike','emmanuel agu','09160294760','@gmail.com','calabar','cross river','5 nyong edem street','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-20 14:23:25',5,'1028','2023-03-20 14:23:25','1028');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','313','1',1,'5','LPG NOZZLE 1',48665.55,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','313','1',2,'5','LPG NOZZLE 2',90.17,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','313','1',3,'5','LPG NOZZLE 3',59.04,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','313','1',4,'5','LPG NOZZLE 4',19.00,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','313','1',5,'5','LPG NOZZLE 5',7.00,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','313','1',6,'5','LPG NOZZLE 6',1.00,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','313',1,'DAILY SHIFT','2023-02-22','2023-02-22 09:22:22','2023-02-23 09:22:22','1028',0.00,0.00,'1028','2023-02-22 09:27:22','1028','2023-02-22 09:27:44',10,0),('1','313',2,'DAILY SHIFT','2023-02-19','2023-02-22 09:28:56','2023-02-23 09:28:56','1028',0.00,0.00,'1028','2023-02-22 10:16:53','1028','2023-02-22 10:17:13',10,0),('1','313',3,'DAILY SHIFT','2023-02-20','2023-02-22 10:19:07','2023-02-23 10:19:07','1028',0.00,0.00,'1028','2023-02-22 10:24:12','1028','2023-02-22 10:24:48',10,0),('1','313',4,'DAILY SHIFT','2023-02-22','2023-02-22 10:44:25','2023-02-23 10:44:25','1028',0.00,0.00,'1028','2023-02-22 10:46:22','1028','2023-02-22 10:46:55',10,0),('1','313',5,'DAILY SHIFT','2023-02-21','2023-02-22 10:48:04','2023-02-23 10:48:04','1028',0.00,0.00,'1028','2023-02-22 10:53:16','1028','2023-02-22 10:53:37',10,0),('1','313',6,'DAILY SHIFT','2023-02-22','2023-02-22 18:54:08','2023-02-23 18:54:08','1028',0.00,0.00,'1028','2023-02-22 18:58:58','1028','2023-02-22 18:59:23',10,0),('1','313',7,'DAILY SHIFT','2023-02-23','2023-02-23 08:14:36','2023-02-24 08:14:36','1028',0.00,0.00,'1028','2023-02-23 18:16:40','1028','2023-02-23 18:17:18',10,0),('1','313',8,'DAILY SHIFT','2023-02-24','2023-02-24 10:13:16','2023-02-25 10:13:16','1028',0.00,0.00,'1028','2023-02-24 19:21:08','1028','2023-02-24 19:21:26',10,0),('1','313',9,'DAILY SHIFT','2023-02-27','2023-02-27 07:49:12','2023-02-28 07:49:12','1028',0.00,0.00,'1028','2023-02-27 18:58:35','1028','2023-02-27 18:59:04',10,0),('1','313',10,'DAILY SHIFT','2023-02-28','2023-02-28 07:49:33','2023-03-01 07:49:33','1028',0.00,0.00,'1028','2023-02-28 18:45:45','1028','2023-02-28 18:46:23',10,0),('1','313',11,'DAILY SHIFT','2023-03-01','2023-03-01 08:21:16','2023-03-02 08:21:16','1028',0.00,0.00,'1028','2023-03-01 18:35:53','1028','2023-03-01 18:36:14',10,0),('1','313',12,'DAILY SHIFT','2023-03-02','2023-03-02 08:06:14','2023-03-03 08:06:14','1028',0.00,0.00,'1028','2023-03-02 18:59:22','1028','2023-03-02 18:59:43',10,0),('1','313',13,'DAILY SHIFT','2023-03-03','2023-03-03 10:32:27','2023-03-04 10:32:27','1028',0.00,0.00,'1028','2023-03-03 18:27:42','1028','2023-03-03 18:27:59',10,0),('1','313',14,'DAILY SHIFT','2023-03-04','2023-03-04 08:23:07','2023-03-05 08:23:07','1028',0.00,0.00,'1028','2023-03-04 18:35:56','1028','2023-03-04 18:36:21',10,0),('1','313',15,'DAILY SHIFT','2023-03-05','2023-03-05 10:28:53','2023-03-06 10:28:53','1028',0.00,0.00,'1028','2023-03-05 17:53:28','1028','2023-03-05 17:53:58',10,0),('1','313',16,'DAILY SHIFT','2023-03-06','2023-03-06 08:00:14','2023-03-07 08:00:14','1028',0.00,0.00,'1028','2023-03-06 18:38:34','1028','2023-03-06 18:39:05',10,0),('1','313',17,'DAILY SHIFT','2023-03-07','2023-03-07 08:05:54','2023-03-08 08:05:54','1028',0.00,0.00,'1028','2023-03-07 14:49:21','1028','2023-03-07 14:49:43',10,0),('1','313',18,'OPERATIONAL LOSS','2023-03-08','2023-03-08 18:13:44','2023-03-09 18:13:44','1028',0.00,0.00,'1028','2023-03-08 18:26:29','1028','2023-03-08 18:26:51',10,0),('1','313',19,'DAILY SHIFT','2023-03-09','2023-03-09 08:17:46','2023-03-10 08:17:46','1028',0.00,0.00,'1028','2023-03-09 18:31:57','1028','2023-03-09 18:32:27',10,0),('1','313',20,'DAILY SHIFT','2023-03-10','2023-03-10 08:02:39','2023-03-11 08:02:39','1028',0.00,0.00,'1028','2023-03-10 19:35:19','1028','2023-03-10 19:39:39',10,0),('1','313',21,'DAILY SHIFT','2023-03-11','2023-03-11 07:55:32','2023-03-12 07:55:32','1028',0.00,0.00,'1028','2023-03-11 18:39:19','1028','2023-03-11 18:40:30',10,0),('1','313',22,'DAILY SHIFT','2023-03-12','2023-03-12 10:27:45','2023-03-13 10:27:45','1028',0.00,0.00,'1028','2023-03-12 17:21:14','1028','2023-03-12 17:21:37',10,0),('1','313',23,'DAILY SHIFT','2023-03-13','2023-03-13 08:01:03','2023-03-14 08:01:03','1028',0.00,0.00,'1028','2023-03-13 19:11:50','1028','2023-03-13 19:12:14',10,0),('1','313',24,'DAILY SHIFT','2023-03-14','2023-03-14 08:13:31','2023-03-15 08:13:31','1028',0.00,0.00,'1028','2023-03-14 20:00:55','1028','2023-03-14 20:01:12',10,0),('1','313',25,'DAILY SHIFT','2023-03-15','2023-03-15 08:13:13','2023-03-16 08:13:13','1028',0.00,0.00,'1028','2023-03-15 19:03:07','1028','2023-03-15 19:03:48',10,0),('1','313',26,'DAILY SHIFT','2023-03-16','2023-03-16 08:19:44','2023-03-17 08:19:44','1028',0.00,0.00,'1028','2023-03-16 17:51:25','1028','2023-03-16 17:51:52',10,0),('1','313',27,'DAILY SHIFT','2023-03-17','2023-03-17 07:58:39','2023-03-18 07:58:39','1028',0.00,0.00,'1028','2023-03-17 20:12:18','1028','2023-03-17 20:16:01',10,0),('1','313',28,'DAILY SHIFT','2023-03-20','2023-03-20 08:06:34','2023-03-21 08:06:34','1028',0.00,0.00,'1028','2023-03-20 19:02:09','1028','2023-03-20 19:02:38',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=169 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','313','1','1',1,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','1',2,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','1',3,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','1',4,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','1',5,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','1',6,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','2',7,'1','1',0.00,812.43,0.00,0.00,812.43,562820.30,0.00,0.00,0.00),('1','313','1','2',8,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','2',9,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','2',10,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','2',11,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','2',12,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','3',13,'1','1',812.43,1691.46,0.00,0.00,879.03,605665.70,0.00,0.00,0.00),('1','313','1','3',14,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','3',15,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','3',16,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','3',17,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','3',18,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','4',19,'1','1',1691.46,1691.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','4',20,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','4',21,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','4',22,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','4',23,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','4',24,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','5',25,'1','1',1691.46,2498.84,0.00,0.00,807.38,561541.80,0.00,0.00,0.00),('1','313','1','5',26,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','5',27,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','5',28,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','5',29,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','5',30,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','6',31,'1','1',2498.84,3423.62,0.00,0.00,924.78,638660.60,0.00,0.00,0.00),('1','313','1','6',32,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','6',33,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','6',34,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','6',35,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','6',36,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','7',37,'1','1',3423.62,4237.05,0.00,0.00,813.43,569631.70,0.00,0.00,0.00),('1','313','1','7',38,'2','1',0.00,25.06,0.00,0.00,25.06,17792.60,0.00,0.00,0.00),('1','313','1','7',39,'3','1',0.00,12.00,0.00,0.00,12.00,8520.00,0.00,0.00,0.00),('1','313','1','7',40,'4','1',0.00,3.00,0.00,0.00,3.00,2130.00,0.00,0.00,0.00),('1','313','1','7',41,'5','1',0.00,6.00,0.00,0.00,6.00,4260.00,0.00,0.00,0.00),('1','313','1','7',42,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','8',43,'1','1',4237.05,6395.37,0.00,0.00,2158.32,1485204.80,0.00,0.00,0.00),('1','313','1','8',44,'2','1',25.06,38.56,0.00,0.00,13.50,9585.00,0.00,0.00,0.00),('1','313','1','8',45,'3','1',12.00,13.00,0.00,0.00,1.00,710.00,0.00,0.00,0.00),('1','313','1','8',46,'4','1',3.00,4.00,0.00,0.00,1.00,710.00,0.00,0.00,0.00),('1','313','1','8',47,'5','1',6.00,7.00,0.00,0.00,1.00,710.00,0.00,0.00,0.00),('1','313','1','8',48,'6','1',0.00,1.00,0.00,0.00,1.00,710.00,0.00,0.00,0.00),('1','313','1','9',49,'1','1',6395.37,9161.75,0.00,0.00,2766.38,1885552.20,0.00,0.00,0.00),('1','313','1','9',50,'2','1',38.56,38.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','9',51,'3','1',13.00,14.00,0.00,0.00,1.00,710.00,0.00,0.00,0.00),('1','313','1','9',52,'4','1',4.00,17.00,0.00,0.00,13.00,9230.00,0.00,0.00,0.00),('1','313','1','9',53,'5','1',7.00,7.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','9',54,'6','1',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','10',55,'1','1',9161.75,11419.47,0.00,0.00,2257.72,1543544.00,0.00,0.00,0.00),('1','313','1','10',56,'2','1',38.56,38.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','10',57,'3','1',14.00,15.00,0.00,0.00,1.00,710.00,0.00,0.00,0.00),('1','313','1','10',58,'4','1',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','10',59,'5','1',7.00,7.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','10',60,'6','1',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','11',61,'1','1',11419.47,13259.63,0.00,0.00,1840.16,1258922.00,0.00,0.00,0.00),('1','313','1','11',62,'2','1',38.56,38.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','11',63,'3','1',15.00,15.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','11',64,'4','1',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','11',65,'5','1',7.00,7.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','11',66,'6','1',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','12',67,'1','1',13259.63,14613.14,0.00,0.00,1353.51,934000.90,0.00,0.00,0.00),('1','313','1','12',68,'2','1',38.56,51.06,0.00,0.00,12.50,8875.00,0.00,0.00,0.00),('1','313','1','12',69,'3','1',15.00,15.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','12',70,'4','1',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','12',71,'5','1',7.00,7.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','12',72,'6','1',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','13',73,'1','1',14613.14,16111.61,0.00,0.00,1498.47,1031785.30,0.00,0.00,0.00),('1','313','1','13',74,'2','1',51.06,51.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','13',75,'3','1',15.00,21.00,0.00,0.00,6.00,4260.00,0.00,0.00,0.00),('1','313','1','13',76,'4','1',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','13',77,'5','1',7.00,7.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','13',78,'6','1',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','14',79,'1','1',16111.61,18853.33,0.00,0.00,2741.72,1884994.80,0.00,0.00,0.00),('1','313','1','14',80,'2','1',51.06,60.06,0.00,0.00,9.00,6390.00,0.00,0.00,0.00),('1','313','1','14',81,'3','1',21.00,37.00,0.00,0.00,16.00,11360.00,0.00,0.00,0.00),('1','313','1','14',82,'4','1',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','14',83,'5','1',7.00,7.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','14',84,'6','1',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','15',85,'1','1',18853.33,20133.26,0.00,0.00,1279.93,872779.10,0.00,0.00,0.00),('1','313','1','15',86,'2','1',60.06,63.06,0.00,0.00,3.00,2130.00,0.00,0.00,0.00),('1','313','1','15',87,'3','1',37.00,37.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','15',88,'4','1',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','15',89,'5','1',7.00,7.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','15',90,'6','1',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','16',91,'1','1',20133.26,22105.62,0.00,0.00,1972.36,1360270.00,0.00,0.00,0.00),('1','313','1','16',92,'2','1',63.06,63.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','16',93,'3','1',37.00,37.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','16',94,'4','1',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','16',95,'5','1',7.00,7.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','16',96,'6','1',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','17',97,'1','1',22105.62,23723.77,0.00,0.00,1618.15,1103904.90,0.00,0.00,0.00),('1','313','1','17',98,'2','1',63.06,68.06,0.00,0.00,5.00,3550.00,0.00,0.00,0.00),('1','313','1','17',99,'3','1',37.00,45.00,0.00,0.00,8.00,5680.00,0.00,0.00,0.00),('1','313','1','17',100,'4','1',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','17',101,'5','1',7.00,7.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','17',102,'6','1',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','18',103,'1','1',23723.77,23723.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','18',104,'2','1',68.06,68.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','18',105,'3','1',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','18',106,'4','1',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','18',107,'5','1',7.00,7.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','18',108,'6','1',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','19',109,'1','1',23723.77,26259.05,0.00,0.00,2535.28,1744968.00,0.00,0.00,0.00),('1','313','1','19',110,'2','1',68.06,68.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','19',111,'3','1',45.00,45.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','19',112,'4','1',17.00,18.00,0.00,0.00,1.00,710.00,0.00,0.00,0.00),('1','313','1','19',113,'5','1',7.00,7.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','19',114,'6','1',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','20',115,'1','1',26259.05,28255.25,0.00,0.00,1996.20,1379218.40,0.00,0.00,0.00),('1','313','1','20',116,'2','1',68.06,84.17,0.00,0.00,16.11,11438.10,0.00,0.00,0.00),('1','313','1','20',117,'3','1',45.00,52.04,0.00,0.00,7.04,4998.40,0.00,0.00,0.00),('1','313','1','20',118,'4','1',18.00,18.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','20',119,'5','1',7.00,7.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','20',120,'6','1',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','21',121,'1','1',28255.25,31697.85,0.00,0.00,3442.60,2369222.40,0.00,0.00,0.00),('1','313','1','21',122,'2','1',84.17,84.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','21',123,'3','1',52.04,59.04,0.00,0.00,7.00,4970.00,0.00,0.00,0.00),('1','313','1','21',124,'4','1',18.00,19.00,0.00,0.00,1.00,710.00,0.00,0.00,0.00),('1','313','1','21',125,'5','1',7.00,7.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','21',126,'6','1',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','22',127,'1','1',31697.85,32495.77,0.00,0.00,797.92,553750.80,0.00,0.00,0.00),('1','313','1','22',128,'2','1',84.17,86.17,0.00,0.00,2.00,1420.00,0.00,0.00,0.00),('1','313','1','22',129,'3','1',59.04,59.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','22',130,'4','1',19.00,19.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','22',131,'5','1',7.00,7.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','22',132,'6','1',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','23',133,'1','1',32495.77,35253.78,0.00,0.00,2758.01,1887913.10,0.00,0.00,0.00),('1','313','1','23',134,'2','1',86.17,87.17,0.00,0.00,1.00,710.00,0.00,0.00,0.00),('1','313','1','23',135,'3','1',59.04,59.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','23',136,'4','1',19.00,19.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','23',137,'5','1',7.00,7.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','23',138,'6','1',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','24',139,'1','1',35253.78,37502.85,0.00,0.00,2249.07,1553103.70,0.00,0.00,0.00),('1','313','1','24',140,'2','1',87.17,87.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','24',141,'3','1',59.04,59.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','24',142,'4','1',19.00,19.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','24',143,'5','1',7.00,7.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','24',144,'6','1',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','25',145,'1','1',37502.85,39646.22,0.00,0.00,2143.37,1476177.90,0.00,0.00,0.00),('1','313','1','25',146,'2','1',87.17,90.17,0.00,0.00,3.00,2130.00,0.00,0.00,0.00),('1','313','1','25',147,'3','1',59.04,59.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','25',148,'4','1',19.00,19.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','25',149,'5','1',7.00,7.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','25',150,'6','1',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','26',151,'1','1',39646.22,41447.90,0.00,0.00,1801.68,1250651.60,0.00,0.00,0.00),('1','313','1','26',152,'2','1',90.17,90.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','26',153,'3','1',59.04,59.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','26',154,'4','1',19.00,19.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','26',155,'5','1',7.00,7.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','26',156,'6','1',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','27',157,'1','1',41447.90,45201.02,0.00,0.00,3753.12,2591251.20,0.00,0.00,0.00),('1','313','1','27',158,'2','1',90.17,90.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','27',159,'3','1',59.04,59.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','27',160,'4','1',19.00,19.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','27',161,'5','1',7.00,7.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','27',162,'6','1',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','28',163,'1','1',45201.02,48665.55,0.00,0.00,3464.53,2379625.10,0.00,0.00,0.00),('1','313','1','28',164,'2','1',90.17,90.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','28',165,'3','1',59.04,59.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','28',166,'4','1',19.00,19.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','28',167,'5','1',7.00,7.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','313','1','28',168,'6','1',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','313','1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,1),('1','313','2','1',605.00,0.00,0.00,812.43,491520.15,562820.30,71300.15,2),('1','313','3','1',605.00,710.00,0.00,879.03,531813.15,605665.70,73852.55,3),('1','313','4','1',605.00,710.00,0.00,0.00,0.00,0.00,0.00,4),('1','313','5','1',605.00,710.00,0.00,807.38,488464.90,561541.80,73076.90,5),('1','313','6','1',605.00,710.00,0.00,924.78,559491.90,638660.60,79168.70,6),('1','313','7','1',605.00,710.00,0.00,859.49,519991.45,602334.30,82342.85,7),('1','313','8','1',605.00,710.00,0.00,2175.82,1316371.10,1497629.80,181258.70,8),('1','313','9','1',605.00,710.00,0.00,2780.38,1682129.90,1895492.20,213362.30,9),('1','313','10','1',605.00,710.00,0.00,2258.72,1366525.60,1544254.00,177728.40,10),('1','313','11','1',605.00,710.00,0.00,1840.16,1113296.80,1258922.00,145625.20,11),('1','313','12','1',605.00,710.00,0.00,1366.01,826436.05,942875.90,116439.85,12),('1','313','13','1',605.00,710.00,0.00,1504.47,910204.35,1036045.30,125840.95,13),('1','313','14','1',605.00,710.00,0.00,2766.72,1673865.60,1902744.80,228879.20,14),('1','313','15','1',605.00,710.00,0.00,1282.93,776172.65,874909.10,98736.45,15),('1','313','16','1',605.00,710.00,0.00,1972.36,1193277.80,1360270.00,166992.20,16),('1','313','17','1',605.00,710.00,0.00,1631.15,986845.75,1113134.90,126289.15,17),('1','313','18','1',605.00,710.00,0.00,0.00,0.00,0.00,0.00,18),('1','313','19','1',605.00,710.00,0.00,2536.28,1534449.40,1745678.00,211228.60,19),('1','313','20','1',605.00,710.00,0.00,2019.35,1221706.75,1395654.90,173948.15,20),('1','313','21','1',605.00,710.00,0.00,3450.60,2087613.00,2374902.40,287289.40,21),('1','313','22','1',605.00,710.00,0.00,799.92,483951.60,555170.80,71219.20,22),('1','313','23','1',605.00,710.00,0.00,2759.01,1669201.05,1888623.10,219422.05,23),('1','313','24','1',605.00,710.00,0.00,2249.07,1360687.35,1553103.70,192416.35,24),('1','313','25','1',605.00,710.00,0.00,2146.37,1298553.85,1478307.90,179754.05,25),('1','313','26','1',605.00,710.00,0.00,1801.68,1090016.40,1250651.60,160635.20,26),('1','313','27','1',605.00,710.00,0.00,3753.12,2270637.60,2591251.20,320613.60,27),('1','313','28','1',605.00,710.00,0.00,3464.53,2096040.65,2379625.10,283584.45,28);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'313','LPG PRODUCT ','LPG Tank.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','313','1',1,1,'1','LPG TANK ',25000.00,0.00,NULL,'TANK CONTAINING LPG PRODUCT','479','2023-01-23 10:59:23','2023-01-23 10:59:23','479',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','313',1,80.07,'2023-03-20 18:46:43');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=4674 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','313',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,15125000.00,25000.00,0.00,0.00,'2023-02-22 09:23:17','',''),(2,'1','313',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,25000.00,0.00,'2023-02-22 09:24:54','',''),(3,'1','313','1',1,'Received from bridging 1',0.00,0.00,25000.00,0.00,0.00,'2023-02-22 09:24:54','',''),(4,'1','313','1',1,'Retail Sale Id 1',377954.30,0.00,0.00,532.33,55894.65,'2023-02-22 09:49:45','',''),(5,'1','313','1',1,'Retail Sale Id 2',184866.00,0.00,0.00,280.10,15405.50,'2023-02-22 10:07:43','',''),(6,'1','313','1',1,'Retail Sale Id 3',296701.90,0.00,0.00,417.89,43878.45,'2023-02-22 10:20:29','',''),(7,'1','313','1',1,'Retail Sale Id 4',308963.80,0.00,0.00,461.14,29974.10,'2023-02-22 10:21:32','',''),(8,'1','313','1',1,'Retail Sale Id 5',365600.30,0.00,0.00,514.93,54067.65,'2023-02-22 10:49:02','',''),(9,'1','313','1',1,'Retail Sale Id 6',195941.50,0.00,0.00,292.45,19009.25,'2023-02-22 10:51:17','',''),(10,'1','313','1',1,'Retail Sale Id 7',338279.50,0.00,0.00,476.45,50027.25,'2023-02-22 18:57:11','',''),(11,'1','313','1',1,'Retail Sale Id 8',300381.10,0.00,0.00,448.33,29141.45,'2023-02-22 18:58:17','',''),(12,'1','313','1',1,'Retail Sale Id 9',1448.40,0.00,0.00,2.04,214.20,'2023-02-23 08:16:34','',''),(13,'1','313','1',1,'Retail Sale Id 10',2840.00,0.00,0.00,4.00,420.00,'2023-02-23 08:17:56','',''),(14,'1','313','1',1,'Retail Sale Id 11',1498.10,0.00,0.00,2.11,221.55,'2023-02-23 08:19:29','',''),(15,'1','313','1',1,'Retail Sale Id 12',8875.00,0.00,0.00,12.50,1312.50,'2023-02-23 08:20:48','',''),(16,'1','313','1',1,'Retail Sale Id 13',2130.00,0.00,0.00,3.00,315.00,'2023-02-23 08:21:49','',''),(17,'1','313','1',1,'Retail Sale Id 14',2151.30,0.00,0.00,3.03,318.15,'2023-02-23 08:23:23','',''),(18,'1','313','1',1,'Retail Sale Id 15',4970.00,0.00,0.00,7.00,735.00,'2023-02-23 08:24:35','',''),(19,'1','313','1',1,'Retail Sale Id 16',1448.40,0.00,0.00,2.04,214.20,'2023-02-23 08:25:44','',''),(20,'1','313','1',1,'Retail Sale Id 17',710.00,0.00,0.00,1.00,105.00,'2023-02-23 08:26:47','',''),(21,'1','313','1',1,'Retail Sale Id 18',752.60,0.00,0.00,1.06,111.30,'2023-02-23 08:28:22','',''),(22,'1','313','1',1,'Retail Sale Id 19',4998.40,0.00,0.00,7.04,739.20,'2023-02-23 08:29:50','',''),(23,'1','313','1',1,'Retail Sale Id 20',4970.00,0.00,0.00,7.00,735.00,'2023-02-23 08:31:15','',''),(24,'1','313','1',1,'Retail Sale Id 21',1448.40,0.00,0.00,2.04,214.20,'2023-02-23 08:32:20','',''),(25,'1','313','1',1,'Retail Sale Id 22',8875.00,0.00,0.00,12.50,1312.50,'2023-02-23 08:33:26','',''),(26,'1','313','1',1,'Retail Sale Id 23',1001.10,0.00,0.00,1.41,148.05,'2023-02-23 08:34:20','',''),(27,'1','313','1',1,'Retail Sale Id 24',710.00,0.00,0.00,1.00,105.00,'2023-02-23 08:35:22','',''),(28,'1','313','1',1,'Retail Sale Id 25',5680.00,0.00,0.00,8.00,840.00,'2023-02-23 08:36:51','',''),(29,'1','313','1',1,'Retail Sale Id 26',710.00,0.00,0.00,1.00,105.00,'2023-02-23 08:38:00','',''),(30,'1','313','1',1,'Retail Sale Id 27',7852.60,0.00,0.00,11.06,1161.30,'2023-02-23 08:40:05','',''),(31,'1','313','1',1,'Retail Sale Id 28',710.00,0.00,0.00,1.00,105.00,'2023-02-23 08:41:42','',''),(32,'1','313','1',1,'Retail Sale Id 29',4260.00,0.00,0.00,6.00,630.00,'2023-02-23 08:45:23','',''),(33,'1','313','1',1,'Retail Sale Id 30',1420.00,0.00,0.00,2.00,210.00,'2023-02-23 08:49:24','',''),(34,'1','313','1',1,'Retail Sale Id 31',710.00,0.00,0.00,1.00,105.00,'2023-02-23 08:53:42','',''),(35,'1','313','1',1,'Retail Sale Id 32',752.60,0.00,0.00,1.06,111.30,'2023-02-23 08:54:40','',''),(36,'1','313','1',1,'Retail Sale Id 33',710.00,0.00,0.00,1.00,105.00,'2023-02-23 08:56:10','',''),(37,'1','313','1',1,'Retail Sale Id 34',752.60,0.00,0.00,1.06,111.30,'2023-02-23 08:56:55','',''),(38,'1','313','1',1,'Retail Sale Id 35',4260.00,0.00,0.00,6.00,630.00,'2023-02-23 08:58:29','',''),(39,'1','313','1',1,'Retail Sale Id 36',1420.00,0.00,0.00,2.00,210.00,'2023-02-23 09:01:38','',''),(40,'1','313','1',1,'Retail Sale Id 37',9230.00,0.00,0.00,13.00,1365.00,'2023-02-23 09:04:12','',''),(41,'1','313','1',1,'Retail Sale Id 38',1420.00,0.00,0.00,2.00,210.00,'2023-02-23 09:06:27','',''),(42,'1','313','1',1,'Retail Sale Id 39',752.60,0.00,0.00,1.06,111.30,'2023-02-23 09:12:13','',''),(43,'1','313','1',1,'Retail Sale Id 40',2840.00,0.00,0.00,4.00,420.00,'2023-02-23 09:14:16','',''),(44,'1','313','1',1,'Retail Sale Id 41',5680.00,0.00,0.00,8.00,840.00,'2023-02-23 09:16:01','',''),(45,'1','313','1',1,'Retail Sale Id 42',2130.00,0.00,0.00,3.00,315.00,'2023-02-23 09:56:10','',''),(46,'1','313','1',1,'Retail Sale Id 43',1420.00,0.00,0.00,2.00,210.00,'2023-02-23 09:59:26','',''),(47,'1','313','1',1,'Retail Sale Id 44',6390.00,0.00,0.00,9.00,945.00,'2023-02-23 10:06:19','',''),(48,'1','313','1',1,'Retail Sale Id 45',3997.30,0.00,0.00,5.63,591.15,'2023-02-23 10:06:59','',''),(49,'1','313','1',1,'Retail Sale Id 46',32652.90,0.00,0.00,45.99,4828.95,'2023-02-23 10:09:40','',''),(50,'1','313','1',1,'Retail Sale Id 47',2151.30,0.00,0.00,3.03,318.15,'2023-02-23 10:49:29','',''),(51,'1','313','1',1,'Retail Sale Id 48',1448.40,0.00,0.00,2.04,214.20,'2023-02-23 10:50:45','',''),(52,'1','313','1',1,'Retail Sale Id 49',6390.00,0.00,0.00,9.00,945.00,'2023-02-23 10:52:04','',''),(53,'1','313','1',1,'Retail Sale Id 50',1448.40,0.00,0.00,2.04,214.20,'2023-02-23 10:52:52','',''),(54,'1','313','1',1,'Retail Sale Id 51',2130.00,0.00,0.00,3.00,315.00,'2023-02-23 10:54:27','',''),(55,'1','313','1',1,'Retail Sale Id 53',3997.30,0.00,0.00,5.63,591.15,'2023-02-23 10:55:13','',''),(56,'1','313','1',1,'Retail Sale Id 54',710.00,0.00,0.00,1.00,105.00,'2023-02-23 10:56:16','',''),(57,'1','313','1',1,'Retail Sale Id 55',752.60,0.00,0.00,1.06,111.30,'2023-02-23 10:57:53','',''),(58,'1','313','1',1,'Retail Sale Id 56',2130.00,0.00,0.00,3.00,315.00,'2023-02-23 10:58:34','',''),(59,'1','313','1',1,'Retail Sale Id 57',710.00,0.00,0.00,1.00,105.00,'2023-02-23 10:59:57','',''),(60,'1','313','1',1,'Retail Sale Id 58',2151.30,0.00,0.00,3.03,318.15,'2023-02-23 11:01:08','',''),(61,'1','313','1',1,'Retail Sale Id 59',8875.00,0.00,0.00,12.50,1312.50,'2023-02-23 11:06:01','',''),(62,'1','313','1',1,'Retail Sale Id 60',3550.00,0.00,0.00,5.00,525.00,'2023-02-23 11:11:14','',''),(63,'1','313','1',1,'Retail Sale Id 61',2130.00,0.00,0.00,3.00,315.00,'2023-02-23 11:13:02','',''),(64,'1','313','1',1,'Retail Sale Id 62',710.00,0.00,0.00,1.00,105.00,'2023-02-23 11:16:00','',''),(65,'1','313','1',1,'Retail Sale Id 63',752.60,0.00,0.00,1.06,111.30,'2023-02-23 11:16:38','',''),(66,'1','313','1',1,'Retail Sale Id 64',1420.00,0.00,0.00,2.00,210.00,'2023-02-23 11:19:07','',''),(67,'1','313','1',1,'Retail Sale Id 66',7100.00,0.00,0.00,10.00,1050.00,'2023-02-23 11:22:00','',''),(68,'1','313','1',1,'Retail Sale Id 67',1420.00,0.00,0.00,2.00,210.00,'2023-02-23 11:24:07','',''),(69,'1','313','1',1,'Retail Sale Id 68',15919.20,0.00,0.00,23.76,1544.40,'2023-02-23 11:26:08','',''),(70,'1','313','1',1,'Retail Sale Id 70',2130.00,0.00,0.00,3.00,315.00,'2023-02-23 11:29:04','',''),(71,'1','313','1',1,'Retail Sale Id 71',29949.00,0.00,0.00,44.70,2905.50,'2023-02-23 11:33:48','',''),(72,'1','313','1',1,'Retail Sale Id 72',2130.00,0.00,0.00,3.00,315.00,'2023-02-23 11:37:18','',''),(73,'1','313','1',1,'Retail Sale Id 73',3003.30,0.00,0.00,4.23,444.15,'2023-02-23 11:38:40','',''),(74,'1','313','1',1,'Retail Sale Id 74',8875.00,0.00,0.00,12.50,1312.50,'2023-02-23 11:41:11','',''),(75,'1','313','1',1,'Retail Sale Id 75',2002.20,0.00,0.00,2.82,296.10,'2023-02-23 11:42:21','',''),(76,'1','313','1',1,'Retail Sale Id 76',2130.00,0.00,0.00,3.00,315.00,'2023-02-23 11:47:21','',''),(77,'1','313','1',1,'Retail Sale Id 77',3550.00,0.00,0.00,5.00,525.00,'2023-02-23 11:56:12','',''),(78,'1','313','1',1,'Retail Sale Id 78',4970.00,0.00,0.00,7.00,735.00,'2023-02-23 12:02:55','',''),(79,'1','313','1',1,'Retail Sale Id 79',4970.00,0.00,0.00,7.00,735.00,'2023-02-23 12:12:10','',''),(80,'1','313','1',1,'Retail Sale Id 80',12395.00,0.00,0.00,18.50,1202.50,'2023-02-23 12:20:47','',''),(81,'1','313','1',1,'Retail Sale Id 81',1420.00,0.00,0.00,2.00,210.00,'2023-02-23 12:23:39','',''),(82,'1','313','1',1,'Retail Sale Id 82',2840.00,0.00,0.00,4.00,420.00,'2023-02-23 12:28:42','',''),(83,'1','313','1',1,'Retail Sale Id 83',8875.00,0.00,0.00,12.50,1312.50,'2023-02-23 12:30:24','',''),(84,'1','313','1',1,'Retail Sale Id 84',7100.00,0.00,0.00,10.00,1050.00,'2023-02-23 12:33:26','',''),(85,'1','313','1',1,'Retail Sale Id 85',1420.00,0.00,0.00,2.00,210.00,'2023-02-23 12:36:31','',''),(86,'1','313','1',1,'Retail Sale Id 86',1001.10,0.00,0.00,1.41,148.05,'2023-02-23 12:41:08','',''),(87,'1','313','1',1,'Retail Sale Id 87',8520.00,0.00,0.00,12.00,1260.00,'2023-02-23 12:43:57','',''),(88,'1','313','1',1,'Retail Sale Id 88',33500.00,0.00,0.00,50.00,3250.00,'2023-02-23 12:47:05','',''),(89,'1','313','1',1,'Retail Sale Id 90',2130.00,0.00,0.00,3.00,315.00,'2023-02-23 12:53:14','',''),(90,'1','313','1',1,'Retail Sale Id 91',8875.00,0.00,0.00,12.50,1312.50,'2023-02-23 12:58:08','',''),(91,'1','313','1',1,'Retail Sale Id 93',2130.00,0.00,0.00,3.00,315.00,'2023-02-23 13:07:38','',''),(92,'1','313','1',1,'Retail Sale Id 94',1420.00,0.00,0.00,2.00,210.00,'2023-02-23 13:09:36','',''),(93,'1','313','1',1,'Retail Sale Id 95',3003.30,0.00,0.00,4.23,444.15,'2023-02-23 13:19:26','',''),(94,'1','313','1',1,'Retail Sale Id 96',1420.00,0.00,0.00,2.00,210.00,'2023-02-23 13:21:31','',''),(95,'1','313','1',1,'Retail Sale Id 97',752.60,0.00,0.00,1.06,111.30,'2023-02-23 13:34:35','',''),(96,'1','313','1',1,'Retail Sale Id 98',752.60,0.00,0.00,1.06,111.30,'2023-02-23 13:37:43','',''),(97,'1','313','1',1,'Retail Sale Id 99',12070.00,0.00,0.00,17.00,1785.00,'2023-02-23 13:42:19','',''),(98,'1','313','1',1,'Retail Sale Id 101',1420.00,0.00,0.00,2.00,210.00,'2023-02-23 13:46:47','',''),(99,'1','313','1',1,'Retail Sale Id 102',1420.00,0.00,0.00,2.00,210.00,'2023-02-23 13:53:26','',''),(100,'1','313','1',1,'Retail Sale Id 103',3997.30,0.00,0.00,5.63,591.15,'2023-02-23 13:55:51','',''),(101,'1','313','1',1,'Retail Sale Id 104',1420.00,0.00,0.00,2.00,210.00,'2023-02-23 13:59:20','',''),(102,'1','313','1',1,'Retail Sale Id 105',8875.00,0.00,0.00,12.50,1312.50,'2023-02-23 14:02:31','',''),(103,'1','313','1',1,'Retail Sale Id 107',4302.60,0.00,0.00,6.06,636.30,'2023-02-23 14:16:47','',''),(104,'1','313','1',1,'Retail Sale Id 108',2130.00,0.00,0.00,3.00,315.00,'2023-02-23 14:18:14','',''),(105,'1','313','1',1,'Retail Sale Id 109',4650.50,0.00,0.00,6.55,687.75,'2023-02-23 14:34:40','',''),(106,'1','313','1',1,'Retail Sale Id 110',12780.00,0.00,0.00,18.00,1890.00,'2023-02-23 14:38:11','',''),(107,'1','313','1',1,'Retail Sale Id 111',4970.00,0.00,0.00,7.00,735.00,'2023-02-23 14:42:44','',''),(108,'1','313','1',1,'Retail Sale Id 112',1420.00,0.00,0.00,2.00,210.00,'2023-02-23 14:46:42','',''),(109,'1','313','1',1,'Retail Sale Id 113',710.00,0.00,0.00,1.00,105.00,'2023-02-23 14:47:44','',''),(110,'1','313','1',1,'Retail Sale Id 114',752.60,0.00,0.00,1.06,111.30,'2023-02-23 14:48:24','',''),(111,'1','313','1',1,'Retail Sale Id 115',3550.00,0.00,0.00,5.00,525.00,'2023-02-23 14:49:52','',''),(112,'1','313','1',1,'Retail Sale Id 116',1448.40,0.00,0.00,2.04,214.20,'2023-02-23 14:52:55','',''),(113,'1','313','1',1,'Retail Sale Id 117',2840.00,0.00,0.00,4.00,420.00,'2023-02-23 14:54:09','',''),(114,'1','313','1',1,'Retail Sale Id 118',1420.00,0.00,0.00,2.00,210.00,'2023-02-23 14:55:12','',''),(115,'1','313','1',1,'Retail Sale Id 119',710.00,0.00,0.00,1.00,105.00,'2023-02-23 14:56:00','',''),(116,'1','313','1',1,'Retail Sale Id 120',710.00,0.00,0.00,1.00,105.00,'2023-02-23 14:58:24','',''),(117,'1','313','1',1,'Retail Sale Id 121',2130.00,0.00,0.00,3.00,315.00,'2023-02-23 15:05:08','',''),(118,'1','313','1',1,'Retail Sale Id 122',2002.20,0.00,0.00,2.82,296.10,'2023-02-23 15:08:43','',''),(119,'1','313','1',1,'Retail Sale Id 123',4998.40,0.00,0.00,7.04,739.20,'2023-02-23 15:17:27','',''),(120,'1','313','1',1,'Retail Sale Id 124',2002.20,0.00,0.00,2.82,296.10,'2023-02-23 15:19:34','',''),(121,'1','313','1',1,'Retail Sale Id 125',4260.00,0.00,0.00,6.00,630.00,'2023-02-23 15:22:59','',''),(122,'1','313','1',1,'Retail Sale Id 126',2130.00,0.00,0.00,3.00,315.00,'2023-02-23 15:25:09','',''),(123,'1','313','1',1,'Retail Sale Id 127',5680.00,0.00,0.00,8.00,840.00,'2023-02-23 15:27:09','',''),(124,'1','313','1',1,'Retail Sale Id 128',752.60,0.00,0.00,1.06,111.30,'2023-02-23 15:29:35','',''),(125,'1','313','1',1,'Retail Sale Id 129',40622.10,0.00,0.00,60.63,3940.95,'2023-02-23 15:31:40','',''),(126,'1','313','1',1,'Retail Sale Id 130',2130.00,0.00,0.00,3.00,315.00,'2023-02-23 15:44:08','',''),(127,'1','313','1',1,'Retail Sale Id 131',2840.00,0.00,0.00,4.00,420.00,'2023-02-23 15:46:09','',''),(128,'1','313','1',1,'Retail Sale Id 132',3550.00,0.00,0.00,5.00,525.00,'2023-02-23 15:48:43','',''),(129,'1','313','1',1,'Retail Sale Id 133',1498.10,0.00,0.00,2.11,221.55,'2023-02-23 15:50:01','',''),(130,'1','313','1',1,'Retail Sale Id 134',710.00,0.00,0.00,1.00,105.00,'2023-02-23 15:51:05','',''),(131,'1','313','1',1,'Retail Sale Id 135',5680.00,0.00,0.00,8.00,840.00,'2023-02-23 15:53:50','',''),(132,'1','313','1',1,'Retail Sale Id 136',1420.00,0.00,0.00,2.00,210.00,'2023-02-23 15:56:25','',''),(133,'1','313','1',1,'Retail Sale Id 137',4260.00,0.00,0.00,6.00,630.00,'2023-02-23 15:58:31','',''),(134,'1','313','1',1,'Retail Sale Id 138',710.00,0.00,0.00,1.00,105.00,'2023-02-23 15:59:46','',''),(135,'1','313','1',1,'Retail Sale Id 139',2130.00,0.00,0.00,3.00,315.00,'2023-02-23 16:01:03','',''),(136,'1','313','1',1,'Retail Sale Id 140',3997.30,0.00,0.00,5.63,591.15,'2023-02-23 16:03:54','',''),(137,'1','313','1',1,'Retail Sale Id 141',710.00,0.00,0.00,1.00,105.00,'2023-02-23 16:14:04','',''),(138,'1','313','1',1,'Retail Sale Id 142',8903.40,0.00,0.00,12.54,1316.70,'2023-02-23 16:17:21','',''),(139,'1','313','1',1,'Retail Sale Id 143',8875.00,0.00,0.00,12.50,1312.50,'2023-02-23 16:19:07','',''),(140,'1','313','1',1,'Retail Sale Id 145',4970.00,0.00,0.00,7.00,735.00,'2023-02-23 16:24:13','',''),(141,'1','313','1',1,'Retail Sale Id 146',3550.00,0.00,0.00,5.00,525.00,'2023-02-23 16:26:05','',''),(142,'1','313','1',1,'Retail Sale Id 147',1420.00,0.00,0.00,2.00,210.00,'2023-02-23 16:28:12','',''),(143,'1','313','1',1,'Retail Sale Id 148',1498.10,0.00,0.00,2.11,221.55,'2023-02-23 16:31:02','',''),(144,'1','313','1',1,'Retail Sale Id 149',710.00,0.00,0.00,1.00,105.00,'2023-02-23 16:35:36','',''),(145,'1','313','1',1,'Retail Sale Id 150',4302.60,0.00,0.00,6.06,636.30,'2023-02-23 16:40:52','',''),(146,'1','313','1',1,'Retail Sale Id 151',2151.30,0.00,0.00,3.03,318.15,'2023-02-23 16:42:14','',''),(147,'1','313','1',1,'Retail Sale Id 152',8875.00,0.00,0.00,12.50,1312.50,'2023-02-23 16:43:54','',''),(148,'1','313','1',1,'Retail Sale Id 153',1199.90,0.00,0.00,1.69,177.45,'2023-02-23 16:48:51','',''),(149,'1','313','1',1,'Retail Sale Id 154',1420.00,0.00,0.00,2.00,210.00,'2023-02-23 16:53:25','',''),(150,'1','313','1',1,'Retail Sale Id 155',752.60,0.00,0.00,1.06,111.30,'2023-02-23 16:56:59','',''),(151,'1','313','1',1,'Retail Sale Id 156',2151.30,0.00,0.00,3.03,318.15,'2023-02-23 16:58:51','',''),(152,'1','313','1',1,'Retail Sale Id 157',2847.10,0.00,0.00,4.01,421.05,'2023-02-23 17:01:02','',''),(153,'1','313','1',1,'Retail Sale Id 158',1420.00,0.00,0.00,2.00,210.00,'2023-02-23 17:04:06','',''),(154,'1','313','1',1,'Retail Sale Id 159',7100.00,0.00,0.00,10.00,1050.00,'2023-02-23 17:05:28','',''),(155,'1','313','1',1,'Retail Sale Id 160',1420.00,0.00,0.00,2.00,210.00,'2023-02-23 17:07:22','',''),(156,'1','313','1',1,'Retail Sale Id 161',2002.20,0.00,0.00,2.82,296.10,'2023-02-23 17:08:46','',''),(157,'1','313','1',1,'Retail Sale Id 162',710.00,0.00,0.00,1.00,105.00,'2023-02-23 17:11:18','',''),(158,'1','313','1',1,'Retail Sale Id 163',4970.00,0.00,0.00,7.00,735.00,'2023-02-23 17:13:50','',''),(159,'1','313','1',1,'Return of Retail Sale Id 142',0.00,8903.40,12.54,0.00,-1316.70,'2023-02-23 17:42:39','',''),(160,'1','313','1',1,'Retail Sale Id 164',2442.40,0.00,0.00,3.44,361.20,'2023-02-23 17:43:57','',''),(161,'1','313','1',1,'Retail Sale Id 165',245896.70,0.00,0.00,367.01,23855.65,'2023-02-24 10:15:57','',''),(162,'1','313','1',1,'Retail Sale Id 166',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 10:16:30','',''),(163,'1','313','1',1,'Retail Sale Id 167',2151.30,0.00,0.00,3.03,318.15,'2023-02-24 10:18:08','',''),(164,'1','313','1',1,'Retail Sale Id 168',6390.00,0.00,0.00,9.00,945.00,'2023-02-24 10:19:14','',''),(165,'1','313','1',1,'Retail Sale Id 169',1420.00,0.00,0.00,2.00,210.00,'2023-02-24 10:19:58','',''),(166,'1','313','1',1,'Retail Sale Id 170',1420.00,0.00,0.00,2.00,210.00,'2023-02-24 10:21:12','',''),(167,'1','313','1',1,'Retail Sale Id 171',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 10:22:11','',''),(168,'1','313','1',1,'Retail Sale Id 172',688.70,0.00,0.00,0.97,101.85,'2023-02-24 10:24:02','',''),(169,'1','313','1',1,'Retail Sale Id 173',1448.40,0.00,0.00,2.04,214.20,'2023-02-24 10:25:30','',''),(170,'1','313','1',1,'Retail Sale Id 174',2151.30,0.00,0.00,3.03,318.15,'2023-02-24 10:27:14','',''),(171,'1','313','1',1,'Retail Sale Id 175',1420.00,0.00,0.00,2.00,210.00,'2023-02-24 10:28:39','',''),(172,'1','313','1',1,'Retail Sale Id 176',1420.00,0.00,0.00,2.00,210.00,'2023-02-24 10:29:24','',''),(173,'1','313','1',1,'Retail Sale Id 177',8875.00,0.00,0.00,12.50,1312.50,'2023-02-24 10:31:33','',''),(174,'1','313','1',1,'Retail Sale Id 178',2151.30,0.00,0.00,3.03,318.15,'2023-02-24 10:33:09','',''),(175,'1','313','1',1,'Retail Sale Id 179',1420.00,0.00,0.00,2.00,210.00,'2023-02-24 10:34:58','',''),(176,'1','313','1',1,'Retail Sale Id 180',710.00,0.00,0.00,1.00,105.00,'2023-02-24 10:36:33','',''),(177,'1','313','1',1,'Retail Sale Id 181',4260.00,0.00,0.00,6.00,630.00,'2023-02-24 10:37:35','',''),(178,'1','313','1',1,'Retail Sale Id 182',2840.00,0.00,0.00,4.00,420.00,'2023-02-24 10:38:40','',''),(179,'1','313','1',1,'Retail Sale Id 183',1448.40,0.00,0.00,2.04,214.20,'2023-02-24 10:40:10','',''),(180,'1','313','1',1,'Retail Sale Id 184',4998.40,0.00,0.00,7.04,739.20,'2023-02-24 10:41:23','',''),(181,'1','313','1',1,'Retail Sale Id 185',752.60,0.00,0.00,1.06,111.30,'2023-02-24 10:42:24','',''),(182,'1','313','1',1,'Retail Sale Id 186',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 10:43:27','',''),(183,'1','313','1',1,'Retail Sale Id 187',4260.00,0.00,0.00,6.00,630.00,'2023-02-24 10:46:11','',''),(184,'1','313','1',1,'Retail Sale Id 188',7100.00,0.00,0.00,10.00,1050.00,'2023-02-24 10:56:36','',''),(185,'1','313','1',1,'Retail Sale Id 189',2840.00,0.00,0.00,4.00,420.00,'2023-02-24 10:59:44','',''),(186,'1','313','1',1,'Retail Sale Id 190',1420.00,0.00,0.00,2.00,210.00,'2023-02-24 11:01:51','',''),(187,'1','313','1',1,'Retail Sale Id 191',3550.00,0.00,0.00,5.00,525.00,'2023-02-24 11:04:06','',''),(188,'1','313','1',1,'Retail Sale Id 192',4970.00,0.00,0.00,7.00,735.00,'2023-02-24 11:09:08','',''),(189,'1','313','1',1,'Retail Sale Id 193',1448.40,0.00,0.00,2.04,214.20,'2023-02-24 11:11:06','',''),(190,'1','313','1',1,'Retail Sale Id 194',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 11:12:39','',''),(191,'1','313','1',1,'Retail Sale Id 195',1420.00,0.00,0.00,2.00,210.00,'2023-02-24 11:17:21','',''),(192,'1','313','1',1,'Retail Sale Id 196',3550.00,0.00,0.00,5.00,525.00,'2023-02-24 11:18:16','',''),(193,'1','313','1',1,'Retail Sale Id 197',1448.40,0.00,0.00,2.04,214.20,'2023-02-24 11:20:04','',''),(194,'1','313','1',1,'Retail Sale Id 198',33500.00,0.00,0.00,50.00,3250.00,'2023-02-24 11:22:32','',''),(195,'1','313','1',1,'Retail Sale Id 199',2840.00,0.00,0.00,4.00,420.00,'2023-02-24 11:24:22','',''),(196,'1','313','1',1,'Retail Sale Id 200',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 11:24:56','',''),(197,'1','313','1',1,'Retail Sale Id 201',2840.00,0.00,0.00,4.00,420.00,'2023-02-24 11:28:11','',''),(198,'1','313','1',1,'Retail Sale Id 202',80400.00,0.00,0.00,120.00,7800.00,'2023-02-24 11:29:22','',''),(199,'1','313','1',1,'Retail Sale Id 203',33500.00,0.00,0.00,50.00,3250.00,'2023-02-24 11:30:57','',''),(200,'1','313','1',1,'Retail Sale Id 204',1001.10,0.00,0.00,1.41,148.05,'2023-02-24 11:31:33','',''),(201,'1','313','1',1,'Retail Sale Id 205',1420.00,0.00,0.00,2.00,210.00,'2023-02-24 11:33:43','',''),(202,'1','313','1',1,'Retail Sale Id 206',710.00,0.00,0.00,1.00,105.00,'2023-02-24 11:36:08','',''),(203,'1','313','1',1,'Retail Sale Id 207',1001.10,0.00,0.00,1.41,148.05,'2023-02-24 11:37:01','',''),(204,'1','313','1',1,'Retail Sale Id 208',1420.00,0.00,0.00,2.00,210.00,'2023-02-24 11:37:48','',''),(205,'1','313','1',1,'Retail Sale Id 209',1420.00,0.00,0.00,2.00,210.00,'2023-02-24 11:39:58','',''),(206,'1','313','1',1,'Retail Sale Id 210',3550.00,0.00,0.00,5.00,525.00,'2023-02-24 11:41:40','',''),(207,'1','313','1',1,'Retail Sale Id 211',1001.10,0.00,0.00,1.41,148.05,'2023-02-24 11:46:52','',''),(208,'1','313','1',1,'Retail Sale Id 212',710.00,0.00,0.00,1.00,105.00,'2023-02-24 11:48:46','',''),(209,'1','313','1',1,'Retail Sale Id 213',3003.30,0.00,0.00,4.23,444.15,'2023-02-24 11:50:46','',''),(210,'1','313','1',1,'Retail Sale Id 214',8875.00,0.00,0.00,12.50,1312.50,'2023-02-24 11:52:12','',''),(211,'1','313','1',1,'Retail Sale Id 215',1420.00,0.00,0.00,2.00,210.00,'2023-02-24 11:54:29','',''),(212,'1','313','1',1,'Retail Sale Id 217',3550.00,0.00,0.00,5.00,525.00,'2023-02-24 12:01:57','',''),(213,'1','313','1',1,'Retail Sale Id 218',5680.00,0.00,0.00,8.00,840.00,'2023-02-24 12:03:42','',''),(214,'1','313','1',1,'Retail Sale Id 219',1498.10,0.00,0.00,2.11,221.55,'2023-02-24 12:05:06','',''),(215,'1','313','1',1,'Retail Sale Id 220',4260.00,0.00,0.00,6.00,630.00,'2023-02-24 12:09:09','',''),(216,'1','313','1',1,'Retail Sale Id 221',3550.00,0.00,0.00,5.00,525.00,'2023-02-24 12:10:45','',''),(217,'1','313','1',1,'Retail Sale Id 222',34170.00,0.00,0.00,51.00,3315.00,'2023-02-24 12:15:01','',''),(218,'1','313','1',1,'Return of Retail Sale Id 218',0.00,5680.00,8.00,0.00,-840.00,'2023-02-24 12:16:30','',''),(219,'1','313','1',1,'Retail Sale Id 223',5545.10,0.00,0.00,7.81,820.05,'2023-02-24 12:17:47','',''),(220,'1','313','1',1,'Retail Sale Id 224',710.00,0.00,0.00,1.00,105.00,'2023-02-24 12:20:03','',''),(221,'1','313','1',1,'Retail Sale Id 225',2840.00,0.00,0.00,4.00,420.00,'2023-02-24 12:27:29','',''),(222,'1','313','1',1,'Retail Sale Id 227',3550.00,0.00,0.00,5.00,525.00,'2023-02-24 12:30:56','',''),(223,'1','313','1',1,'Retail Sale Id 228',33500.00,0.00,0.00,50.00,3250.00,'2023-02-24 12:32:52','',''),(224,'1','313','1',1,'Retail Sale Id 229',4260.00,0.00,0.00,6.00,630.00,'2023-02-24 12:34:06','',''),(225,'1','313','1',1,'Retail Sale Id 230',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 12:36:22','',''),(226,'1','313','1',1,'Retail Sale Id 231',1498.10,0.00,0.00,2.11,221.55,'2023-02-24 12:37:18','',''),(227,'1','313','1',1,'Retail Sale Id 232',2840.00,0.00,0.00,4.00,420.00,'2023-02-24 12:39:50','',''),(228,'1','313','1',1,'Retail Sale Id 233',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 12:41:15','',''),(229,'1','313','1',1,'Retail Sale Id 234',8875.00,0.00,0.00,12.50,1312.50,'2023-02-24 12:43:19','',''),(230,'1','313','1',1,'Retail Sale Id 235',710.00,0.00,0.00,1.00,105.00,'2023-02-24 12:44:05','',''),(231,'1','313','1',1,'Retail Sale Id 236',4970.00,0.00,0.00,7.00,735.00,'2023-02-24 12:46:20','',''),(232,'1','313','1',1,'Retail Sale Id 237',5680.00,0.00,0.00,8.00,840.00,'2023-02-24 12:50:55','',''),(233,'1','313','1',1,'Retail Sale Id 238',4501.40,0.00,0.00,6.34,665.70,'2023-02-24 12:53:23','',''),(234,'1','313','1',1,'Retail Sale Id 240',710.00,0.00,0.00,1.00,105.00,'2023-02-24 12:59:08','',''),(235,'1','313','1',1,'Retail Sale Id 241',2002.20,0.00,0.00,2.82,296.10,'2023-02-24 13:00:59','',''),(236,'1','313','1',1,'Retail Sale Id 242',5680.00,0.00,0.00,8.00,840.00,'2023-02-24 13:05:12','',''),(237,'1','313','1',1,'Retail Sale Id 243',3003.30,0.00,0.00,4.23,444.15,'2023-02-24 13:06:18','',''),(238,'1','313','1',1,'Retail Sale Id 244',802.30,0.00,0.00,1.13,118.65,'2023-02-24 13:07:30','',''),(239,'1','313','1',1,'Retail Sale Id 245',2002.20,0.00,0.00,2.82,296.10,'2023-02-24 13:09:12','',''),(240,'1','313','1',1,'Retail Sale Id 246',3550.00,0.00,0.00,5.00,525.00,'2023-02-24 13:12:52','',''),(241,'1','313','1',1,'Retail Sale Id 247',2151.30,0.00,0.00,3.03,318.15,'2023-02-24 13:13:54','',''),(242,'1','313','1',1,'Retail Sale Id 248',3550.00,0.00,0.00,5.00,525.00,'2023-02-24 13:15:48','',''),(243,'1','313','1',1,'Retail Sale Id 249',2847.10,0.00,0.00,4.01,421.05,'2023-02-24 13:17:14','',''),(244,'1','313','1',1,'Retail Sale Id 250',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 13:18:22','',''),(245,'1','313','1',1,'Retail Sale Id 251',4970.00,0.00,0.00,7.00,735.00,'2023-02-24 13:19:59','',''),(246,'1','313','1',1,'Return of Retail Sale Id 251',0.00,4970.00,7.00,0.00,-735.00,'2023-02-24 13:22:49','',''),(247,'1','313','1',1,'Retail Sale Id 252',8520.00,0.00,0.00,12.00,1260.00,'2023-02-24 13:23:43','',''),(248,'1','313','1',1,'Retail Sale Id 253',8520.00,0.00,0.00,12.00,1260.00,'2023-02-24 13:32:34','',''),(249,'1','313','1',1,'Retail Sale Id 254',4260.00,0.00,0.00,6.00,630.00,'2023-02-24 13:39:21','',''),(250,'1','313','1',1,'Retail Sale Id 255',5999.50,0.00,0.00,8.45,887.25,'2023-02-24 13:41:00','',''),(251,'1','313','1',1,'Retail Sale Id 256',2840.00,0.00,0.00,4.00,420.00,'2023-02-24 14:55:35','',''),(252,'1','313','1',1,'Retail Sale Id 258',802.30,0.00,0.00,1.13,118.65,'2023-02-24 14:56:31','',''),(253,'1','313','1',1,'Retail Sale Id 259',4260.00,0.00,0.00,6.00,630.00,'2023-02-24 14:57:30','',''),(254,'1','313','1',1,'Retail Sale Id 260',5680.00,0.00,0.00,8.00,840.00,'2023-02-24 14:59:42','',''),(255,'1','313','1',1,'Retail Sale Id 261',3550.00,0.00,0.00,5.00,525.00,'2023-02-24 15:01:10','',''),(256,'1','313','1',1,'Retail Sale Id 262',2840.00,0.00,0.00,4.00,420.00,'2023-02-24 15:01:58','',''),(257,'1','313','1',1,'Retail Sale Id 263',8520.00,0.00,0.00,12.00,1260.00,'2023-02-24 15:03:10','',''),(258,'1','313','1',1,'Retail Sale Id 264',8875.00,0.00,0.00,12.50,1312.50,'2023-02-24 15:04:05','',''),(259,'1','313','1',1,'Retail Sale Id 265',8520.00,0.00,0.00,12.00,1260.00,'2023-02-24 15:05:35','',''),(260,'1','313','1',1,'Retail Sale Id 266',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 15:06:38','',''),(261,'1','313','1',1,'Retail Sale Id 267',1420.00,0.00,0.00,2.00,210.00,'2023-02-24 15:07:49','',''),(262,'1','313','1',1,'Retail Sale Id 268',5268.20,0.00,0.00,7.42,779.10,'2023-02-24 15:08:49','',''),(263,'1','313','1',1,'Retail Sale Id 269',2840.00,0.00,0.00,4.00,420.00,'2023-02-24 15:10:28','',''),(264,'1','313','1',1,'Retail Sale Id 270',3550.00,0.00,0.00,5.00,525.00,'2023-02-24 15:11:12','',''),(265,'1','313','1',1,'Retail Sale Id 271',2840.00,0.00,0.00,4.00,420.00,'2023-02-24 15:13:14','',''),(266,'1','313','1',1,'Retail Sale Id 272',710.00,0.00,0.00,1.00,105.00,'2023-02-24 15:14:12','',''),(267,'1','313','1',1,'Retail Sale Id 273',2002.20,0.00,0.00,2.82,296.10,'2023-02-24 15:15:34','',''),(268,'1','313','1',1,'Retail Sale Id 274',1420.00,0.00,0.00,2.00,210.00,'2023-02-24 15:16:24','',''),(269,'1','313','1',1,'Retail Sale Id 275',710.00,0.00,0.00,1.00,105.00,'2023-02-24 15:17:38','',''),(270,'1','313','1',1,'Retail Sale Id 276',1420.00,0.00,0.00,2.00,210.00,'2023-02-24 15:20:15','',''),(271,'1','313','1',1,'Retail Sale Id 277',1420.00,0.00,0.00,2.00,210.00,'2023-02-24 15:22:21','',''),(272,'1','313','1',1,'Retail Sale Id 278',3550.00,0.00,0.00,5.00,525.00,'2023-02-24 15:24:24','',''),(273,'1','313','1',1,'Retail Sale Id 279',1448.40,0.00,0.00,2.04,214.20,'2023-02-24 15:25:26','',''),(274,'1','313','1',1,'Retail Sale Id 280',1420.00,0.00,0.00,2.00,210.00,'2023-02-24 15:26:43','',''),(275,'1','313','1',1,'Retail Sale Id 281',3003.30,0.00,0.00,4.23,444.15,'2023-02-24 15:27:12','',''),(276,'1','313','1',1,'Retail Sale Id 282',1420.00,0.00,0.00,2.00,210.00,'2023-02-24 15:29:59','',''),(277,'1','313','1',1,'Retail Sale Id 283',7810.00,0.00,0.00,11.00,1155.00,'2023-02-24 15:32:00','',''),(278,'1','313','1',1,'Retail Sale Id 284',3550.00,0.00,0.00,5.00,525.00,'2023-02-24 15:33:28','',''),(279,'1','313','1',1,'Retail Sale Id 285',1420.00,0.00,0.00,2.00,210.00,'2023-02-24 15:37:08','',''),(280,'1','313','1',1,'Retail Sale Id 286',710.00,0.00,0.00,1.00,105.00,'2023-02-24 15:37:40','',''),(281,'1','313','1',1,'Retail Sale Id 287',710.00,0.00,0.00,1.00,105.00,'2023-02-24 15:38:40','',''),(282,'1','313','1',1,'Retail Sale Id 288',83582.50,0.00,0.00,124.75,8108.75,'2023-02-24 15:39:25','',''),(283,'1','313','1',1,'Retail Sale Id 289',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 15:41:16','',''),(284,'1','313','1',1,'Retail Sale Id 290',710.00,0.00,0.00,1.00,105.00,'2023-02-24 15:43:37','',''),(285,'1','313','1',1,'Retail Sale Id 291',3550.00,0.00,0.00,5.00,525.00,'2023-02-24 15:44:34','',''),(286,'1','313','1',1,'Retail Sale Id 292',33500.00,0.00,0.00,50.00,3250.00,'2023-02-24 15:45:08','',''),(287,'1','313','1',1,'Retail Sale Id 293',1498.10,0.00,0.00,2.11,221.55,'2023-02-24 15:46:16','',''),(288,'1','313','1',1,'Retail Sale Id 294',4260.00,0.00,0.00,6.00,630.00,'2023-02-24 15:47:24','',''),(289,'1','313','1',1,'Retail Sale Id 295',802.30,0.00,0.00,1.13,118.65,'2023-02-24 15:48:22','',''),(290,'1','313','1',1,'Retail Sale Id 296',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 15:49:23','',''),(291,'1','313','1',1,'Retail Sale Id 297',38967.20,0.00,0.00,58.16,3780.40,'2023-02-24 15:53:39','',''),(292,'1','313','1',1,'Retail Sale Id 298',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 15:56:00','',''),(293,'1','313','1',1,'Retail Sale Id 299',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 15:57:58','',''),(294,'1','313','1',1,'Retail Sale Id 300',7100.00,0.00,0.00,10.00,1050.00,'2023-02-24 15:59:06','',''),(295,'1','313','1',1,'Retail Sale Id 301',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 16:00:35','',''),(296,'1','313','1',1,'Retail Sale Id 302',752.60,0.00,0.00,1.06,111.30,'2023-02-24 16:02:22','',''),(297,'1','313','1',1,'Retail Sale Id 303',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 16:03:13','',''),(298,'1','313','1',1,'Retail Sale Id 304',1420.00,0.00,0.00,2.00,210.00,'2023-02-24 16:04:12','',''),(299,'1','313','1',1,'Retail Sale Id 305',1420.00,0.00,0.00,2.00,210.00,'2023-02-24 16:05:16','',''),(300,'1','313','1',1,'Retail Sale Id 306',2201.00,0.00,0.00,3.10,325.50,'2023-02-24 16:08:06','',''),(301,'1','313','1',1,'Retail Sale Id 307',8875.00,0.00,0.00,12.50,1312.50,'2023-02-24 16:08:54','',''),(302,'1','313','1',1,'Retail Sale Id 308',710.00,0.00,0.00,1.00,105.00,'2023-02-24 16:09:51','',''),(303,'1','313','1',1,'Retail Sale Id 309',1001.10,0.00,0.00,1.41,148.05,'2023-02-24 16:11:08','',''),(304,'1','313','1',1,'Retail Sale Id 310',4260.00,0.00,0.00,6.00,630.00,'2023-02-24 16:13:37','',''),(305,'1','313','1',1,'Retail Sale Id 311',36850.00,0.00,0.00,55.00,3575.00,'2023-02-24 16:14:44','',''),(306,'1','313','1',1,'Retail Sale Id 312',710.00,0.00,0.00,1.00,105.00,'2023-02-24 16:15:49','',''),(307,'1','313','1',1,'Retail Sale Id 313',1498.10,0.00,0.00,2.11,221.55,'2023-02-24 16:16:35','',''),(308,'1','313','1',1,'Retail Sale Id 314',752.60,0.00,0.00,1.06,111.30,'2023-02-24 16:18:11','',''),(309,'1','313','1',1,'Retail Sale Id 315',2840.00,0.00,0.00,4.00,420.00,'2023-02-24 16:18:52','',''),(310,'1','313','1',1,'Retail Sale Id 316',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 16:20:13','',''),(311,'1','313','1',1,'Retail Sale Id 317',2840.00,0.00,0.00,4.00,420.00,'2023-02-24 16:21:27','',''),(312,'1','313','1',1,'Retail Sale Id 319',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 16:24:52','',''),(313,'1','313','1',1,'Retail Sale Id 320',2797.40,0.00,0.00,3.94,413.70,'2023-02-24 16:28:11','',''),(314,'1','313','1',1,'Retail Sale Id 321',1420.00,0.00,0.00,2.00,210.00,'2023-02-24 16:30:59','',''),(315,'1','313','1',1,'Retail Sale Id 322',752.60,0.00,0.00,1.06,111.30,'2023-02-24 16:32:30','',''),(316,'1','313','1',1,'Retail Sale Id 323',1420.00,0.00,0.00,2.00,210.00,'2023-02-24 16:34:03','',''),(317,'1','313','1',1,'Retail Sale Id 325',752.60,0.00,0.00,1.06,111.30,'2023-02-24 16:36:44','',''),(318,'1','313','1',1,'Retail Sale Id 326',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 16:38:28','',''),(319,'1','313','1',1,'Retail Sale Id 327',30150.00,0.00,0.00,45.00,2925.00,'2023-02-24 16:40:20','',''),(320,'1','313','1',1,'Retail Sale Id 328',1498.10,0.00,0.00,2.11,221.55,'2023-02-24 16:41:45','',''),(321,'1','313','1',1,'Retail Sale Id 329',1498.10,0.00,0.00,2.11,221.55,'2023-02-24 16:43:19','',''),(322,'1','313','1',1,'Retail Sale Id 330',1001.10,0.00,0.00,1.41,148.05,'2023-02-24 16:44:56','',''),(323,'1','313','1',1,'Retail Sale Id 331',802.30,0.00,0.00,1.13,118.65,'2023-02-24 16:46:08','',''),(324,'1','313','1',1,'Retail Sale Id 332',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 16:47:59','',''),(325,'1','313','1',1,'Retail Sale Id 333',8796.90,0.00,0.00,12.39,1300.95,'2023-02-24 16:50:23','',''),(326,'1','313','1',1,'Retail Sale Id 334',1448.40,0.00,0.00,2.04,214.20,'2023-02-24 16:51:37','',''),(327,'1','313','1',1,'Retail Sale Id 335',4260.00,0.00,0.00,6.00,630.00,'2023-02-24 16:52:43','',''),(328,'1','313','1',1,'Retail Sale Id 336',710.00,0.00,0.00,1.00,105.00,'2023-02-24 16:54:11','',''),(329,'1','313','1',1,'Retail Sale Id 337',2485.00,0.00,0.00,3.50,367.50,'2023-02-24 16:55:50','',''),(330,'1','313','1',1,'Retail Sale Id 338',1448.40,0.00,0.00,2.04,214.20,'2023-02-24 16:57:27','',''),(331,'1','313','1',1,'Retail Sale Id 339',38967.20,0.00,0.00,58.16,3780.40,'2023-02-24 16:58:51','',''),(332,'1','313','1',1,'Return of Retail Sale Id 339',0.00,38967.20,58.16,0.00,-3780.40,'2023-02-24 16:59:35','',''),(333,'1','313','1',1,'Retail Sale Id 340',1199.90,0.00,0.00,1.69,177.45,'2023-02-24 17:00:30','',''),(334,'1','313','1',1,'Retail Sale Id 341',1001.10,0.00,0.00,1.41,148.05,'2023-02-24 17:01:36','',''),(335,'1','313','1',1,'Retail Sale Id 342',1498.10,0.00,0.00,2.11,221.55,'2023-02-24 17:02:35','',''),(336,'1','313','1',1,'Retail Sale Id 343',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 17:04:42','',''),(337,'1','313','1',1,'Retail Sale Id 344',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 17:05:55','',''),(338,'1','313','1',1,'Retail Sale Id 345',752.60,0.00,0.00,1.06,111.30,'2023-02-24 17:07:16','',''),(339,'1','313','1',1,'Retail Sale Id 346',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 17:08:37','',''),(340,'1','313','1',1,'Retail Sale Id 347',710.00,0.00,0.00,1.00,105.00,'2023-02-24 17:09:35','',''),(341,'1','313','1',1,'Retail Sale Id 348',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 17:11:10','',''),(342,'1','313','1',1,'Retail Sale Id 349',1448.40,0.00,0.00,2.04,214.20,'2023-02-24 17:13:18','',''),(343,'1','313','1',1,'Retail Sale Id 350',1448.40,0.00,0.00,2.04,214.20,'2023-02-24 17:14:40','',''),(344,'1','313','1',1,'Retail Sale Id 351',752.60,0.00,0.00,1.06,111.30,'2023-02-24 17:16:51','',''),(345,'1','313','1',1,'Retail Sale Id 352',2151.30,0.00,0.00,3.03,318.15,'2023-02-24 17:18:45','',''),(346,'1','313','1',1,'Retail Sale Id 353',4998.40,0.00,0.00,7.04,739.20,'2023-02-24 17:19:49','',''),(347,'1','313','1',1,'Retail Sale Id 354',3550.00,0.00,0.00,5.00,525.00,'2023-02-24 17:21:33','',''),(348,'1','313','1',1,'Retail Sale Id 355',752.60,0.00,0.00,1.06,111.30,'2023-02-24 17:22:29','',''),(349,'1','313','1',1,'Retail Sale Id 356',2151.30,0.00,0.00,3.03,318.15,'2023-02-24 17:23:48','',''),(350,'1','313','1',1,'Retail Sale Id 357',752.60,0.00,0.00,1.06,111.30,'2023-02-24 17:25:11','',''),(351,'1','313','1',1,'Retail Sale Id 358',4998.40,0.00,0.00,7.04,739.20,'2023-02-24 17:29:51','',''),(352,'1','313','1',1,'Retail Sale Id 359',2130.00,0.00,0.00,3.00,315.00,'2023-02-24 17:33:43','',''),(353,'1','313','1',1,'Retail Sale Id 360',10813.30,0.00,0.00,15.23,1599.15,'2023-02-24 17:38:55','',''),(354,'1','313','1',1,'Return of Retail Sale Id 360',0.00,10813.30,15.23,0.00,-1599.15,'2023-02-24 17:41:27','',''),(355,'1','313','1',1,'Retail Sale Id 361',7810.00,0.00,0.00,11.00,1155.00,'2023-02-24 17:42:30','',''),(356,'1','313','1',1,'Retail Sale Id 362',3003.30,0.00,0.00,4.23,444.15,'2023-02-24 17:45:24','',''),(357,'1','313','1',1,'Retail Sale Id 363',237203.90,0.00,0.00,334.09,35079.45,'2023-02-24 17:54:19','',''),(358,'1','313','1',1,'Retail Sale Id 364',33500.00,0.00,0.00,50.00,3250.00,'2023-02-24 18:07:26','',''),(359,'1','313','1',1,'Retail Sale Id 365',3550.00,0.00,0.00,5.00,525.00,'2023-02-24 18:08:19','',''),(360,'1','313','1',1,'Retail Sale Id 366',40628.80,0.00,0.00,60.64,3941.60,'2023-02-24 18:09:43','',''),(361,'1','313','1',1,'Return of Retail Sale Id 289',0.00,2130.00,3.00,0.00,-315.00,'2023-02-24 18:11:59','',''),(362,'1','313','1',1,'Return of Retail Sale Id 260',0.00,5680.00,8.00,0.00,-840.00,'2023-02-24 18:13:39','',''),(363,'1','313','1',1,'Retail Sale Id 367',33500.00,0.00,0.00,50.00,3250.00,'2023-02-24 18:22:05','',''),(364,'1','313','1',1,'Return of Retail Sale Id 300',0.00,7100.00,10.00,0.00,-1050.00,'2023-02-24 18:42:36','',''),(365,'1','313','1',1,'Return of Retail Sale Id 254',0.00,4260.00,6.00,0.00,-630.00,'2023-02-24 18:44:19','',''),(366,'1','313','1',1,'Retail Sale Id 369',866.20,0.00,0.00,1.22,128.10,'2023-02-24 18:45:56','',''),(367,'1','313','1',1,'Return of Retail Sale Id 297',0.00,38967.20,58.16,0.00,-3780.40,'2023-02-24 18:55:58','',''),(368,'1','313','1',1,'Retail Sale Id 370',37962.20,0.00,0.00,56.66,3682.90,'2023-02-24 18:56:49','',''),(369,'1','313','1',1,'Retail Sale Id 372',3550.00,0.00,0.00,5.00,525.00,'2023-02-27 07:54:34','',''),(370,'1','313','1',1,'Retail Sale Id 373',7100.00,0.00,0.00,10.00,1050.00,'2023-02-27 07:56:12','',''),(371,'1','313','1',1,'Retail Sale Id 374',3550.00,0.00,0.00,5.00,525.00,'2023-02-27 07:57:15','',''),(372,'1','313','1',1,'Retail Sale Id 375',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 07:58:17','',''),(373,'1','313','1',1,'Retail Sale Id 376',710.00,0.00,0.00,1.00,105.00,'2023-02-27 07:59:00','',''),(374,'1','313','1',1,'Retail Sale Id 377',5680.00,0.00,0.00,8.00,840.00,'2023-02-27 08:00:12','',''),(375,'1','313','1',1,'Retail Sale Id 378',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 08:01:16','',''),(376,'1','313','1',1,'Retail Sale Id 379',80400.00,0.00,0.00,120.00,7800.00,'2023-02-27 08:02:03','',''),(377,'1','313','1',1,'Retail Sale Id 380',717.10,0.00,0.00,1.01,106.05,'2023-02-27 08:02:43','',''),(378,'1','313','1',1,'Retail Sale Id 381',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 08:03:49','',''),(379,'1','313','1',1,'Retail Sale Id 382',36850.00,0.00,0.00,55.00,3575.00,'2023-02-27 08:05:14','',''),(380,'1','313','1',1,'Retail Sale Id 383',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 08:06:26','',''),(381,'1','313','1',1,'Retail Sale Id 385',39885.10,0.00,0.00,59.53,3869.45,'2023-02-27 08:08:16','',''),(382,'1','313','1',1,'Retail Sale Id 386',3550.00,0.00,0.00,5.00,525.00,'2023-02-27 08:08:53','',''),(383,'1','313','1',1,'Retail Sale Id 388',1427.10,0.00,0.00,2.01,211.05,'2023-02-27 08:12:48','',''),(384,'1','313','1',1,'Retail Sale Id 389',41004.00,0.00,0.00,61.20,3978.00,'2023-02-27 08:14:56','',''),(385,'1','313','1',1,'Retail Sale Id 390',33500.00,0.00,0.00,50.00,3250.00,'2023-02-27 08:15:50','',''),(386,'1','313','1',1,'Retail Sale Id 391',30150.00,0.00,0.00,45.00,2925.00,'2023-02-27 08:16:59','',''),(387,'1','313','1',1,'Retail Sale Id 392',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 08:18:07','',''),(388,'1','313','1',1,'Retail Sale Id 393',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 08:19:30','',''),(389,'1','313','1',1,'Retail Sale Id 394',36850.00,0.00,0.00,55.00,3575.00,'2023-02-27 08:22:37','',''),(390,'1','313','1',1,'Retail Sale Id 395',802.30,0.00,0.00,1.13,118.65,'2023-02-27 08:25:48','',''),(391,'1','313','1',1,'Retail Sale Id 396',710.00,0.00,0.00,1.00,105.00,'2023-02-27 08:27:42','',''),(392,'1','313','1',1,'Retail Sale Id 397',4615.00,0.00,0.00,6.50,682.50,'2023-02-27 08:29:35','',''),(393,'1','313','1',1,'Retail Sale Id 398',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 08:30:44','',''),(394,'1','313','1',1,'Retail Sale Id 399',4998.40,0.00,0.00,7.04,739.20,'2023-02-27 08:31:44','',''),(395,'1','313','1',1,'Retail Sale Id 400',33500.00,0.00,0.00,50.00,3250.00,'2023-02-27 08:34:04','',''),(396,'1','313','1',1,'Retail Sale Id 401',33500.00,0.00,0.00,50.00,3250.00,'2023-02-27 08:35:29','',''),(397,'1','313','1',1,'Retail Sale Id 402',67000.00,0.00,0.00,100.00,6500.00,'2023-02-27 08:38:42','',''),(398,'1','313','1',1,'Retail Sale Id 403',9230.00,0.00,0.00,13.00,1365.00,'2023-02-27 08:40:03','',''),(399,'1','313','1',1,'Retail Sale Id 404',33500.00,0.00,0.00,50.00,3250.00,'2023-02-27 08:42:45','',''),(400,'1','313','1',1,'Retail Sale Id 405',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 08:43:55','',''),(401,'1','313','1',1,'Retail Sale Id 406',710.00,0.00,0.00,1.00,105.00,'2023-02-27 08:44:50','',''),(402,'1','313','1',1,'Retail Sale Id 407',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 08:46:14','',''),(403,'1','313','1',1,'Retail Sale Id 408',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 08:46:50','',''),(404,'1','313','1',1,'Retail Sale Id 409',2840.00,0.00,0.00,4.00,420.00,'2023-02-27 08:47:24','',''),(405,'1','313','1',1,'Retail Sale Id 410',710.00,0.00,0.00,1.00,105.00,'2023-02-27 08:48:21','',''),(406,'1','313','1',1,'Retail Sale Id 411',3550.00,0.00,0.00,5.00,525.00,'2023-02-27 08:50:16','',''),(407,'1','313','1',1,'Retail Sale Id 412',4260.00,0.00,0.00,6.00,630.00,'2023-02-27 08:52:11','',''),(408,'1','313','1',1,'Retail Sale Id 413',3550.00,0.00,0.00,5.00,525.00,'2023-02-27 08:53:30','',''),(409,'1','313','1',1,'Retail Sale Id 414',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 08:55:17','',''),(410,'1','313','1',1,'Retail Sale Id 415',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 08:56:17','',''),(411,'1','313','1',1,'Retail Sale Id 416',901.70,0.00,0.00,1.27,133.35,'2023-02-27 08:57:52','',''),(412,'1','313','1',1,'Retail Sale Id 417',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 09:01:22','',''),(413,'1','313','1',1,'Retail Sale Id 418',3550.00,0.00,0.00,5.00,525.00,'2023-02-27 09:03:26','',''),(414,'1','313','1',1,'Retail Sale Id 419',3550.00,0.00,0.00,5.00,525.00,'2023-02-27 09:05:13','',''),(415,'1','313','1',1,'Retail Sale Id 420',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 09:06:06','',''),(416,'1','313','1',1,'Retail Sale Id 421',7100.00,0.00,0.00,10.00,1050.00,'2023-02-27 09:08:11','',''),(417,'1','313','1',1,'Retail Sale Id 422',2840.00,0.00,0.00,4.00,420.00,'2023-02-27 09:09:36','',''),(418,'1','313','1',1,'Retail Sale Id 423',20100.00,0.00,0.00,30.00,1950.00,'2023-02-27 09:13:58','',''),(419,'1','313','1',1,'Retail Sale Id 424',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 09:15:35','',''),(420,'1','313','1',1,'Retail Sale Id 425',10650.00,0.00,0.00,15.00,1575.00,'2023-02-27 09:18:59','',''),(421,'1','313','1',1,'Retail Sale Id 426',4615.00,0.00,0.00,6.50,682.50,'2023-02-27 09:20:07','',''),(422,'1','313','1',1,'Retail Sale Id 427',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 09:20:56','',''),(423,'1','313','1',1,'Retail Sale Id 428',7100.00,0.00,0.00,10.00,1050.00,'2023-02-27 09:22:03','',''),(424,'1','313','1',1,'Retail Sale Id 429',4260.00,0.00,0.00,6.00,630.00,'2023-02-27 09:22:53','',''),(425,'1','313','1',1,'Retail Sale Id 430',710.00,0.00,0.00,1.00,105.00,'2023-02-27 09:25:50','',''),(426,'1','313','1',1,'Retail Sale Id 431',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 09:26:53','',''),(427,'1','313','1',1,'Retail Sale Id 432',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 09:27:46','',''),(428,'1','313','1',1,'Retail Sale Id 433',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 09:29:10','',''),(429,'1','313','1',1,'Retail Sale Id 434',33500.00,0.00,0.00,50.00,3250.00,'2023-02-27 09:31:29','',''),(430,'1','313','1',1,'Retail Sale Id 435',2840.00,0.00,0.00,4.00,420.00,'2023-02-27 09:33:22','',''),(431,'1','313','1',1,'Retail Sale Id 436',3550.00,0.00,0.00,5.00,525.00,'2023-02-27 09:34:54','',''),(432,'1','313','1',1,'Retail Sale Id 437',2840.00,0.00,0.00,4.00,420.00,'2023-02-27 09:36:44','',''),(433,'1','313','1',1,'Retail Sale Id 438',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 09:38:30','',''),(434,'1','313','1',1,'Retail Sale Id 439',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 09:42:43','',''),(435,'1','313','1',1,'Retail Sale Id 440',3550.00,0.00,0.00,5.00,525.00,'2023-02-27 09:44:18','',''),(436,'1','313','1',1,'Retail Sale Id 442',8875.00,0.00,0.00,12.50,1312.50,'2023-02-27 09:47:46','',''),(437,'1','313','1',1,'Retail Sale Id 445',4260.00,0.00,0.00,6.00,630.00,'2023-02-27 09:54:49','',''),(438,'1','313','1',1,'Retail Sale Id 446',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 09:56:15','',''),(439,'1','313','1',1,'Retail Sale Id 447',1448.40,0.00,0.00,2.04,214.20,'2023-02-27 09:58:01','',''),(440,'1','313','1',1,'Retail Sale Id 448',1001.10,0.00,0.00,1.41,148.05,'2023-02-27 09:58:59','',''),(441,'1','313','1',1,'Retail Sale Id 449',2840.00,0.00,0.00,4.00,420.00,'2023-02-27 10:00:32','',''),(442,'1','313','1',1,'Retail Sale Id 450',147400.00,0.00,0.00,220.00,14300.00,'2023-02-27 10:02:39','',''),(443,'1','313','1',1,'Retail Sale Id 451',1001.10,0.00,0.00,1.41,148.05,'2023-02-27 10:03:39','',''),(444,'1','313','1',1,'Retail Sale Id 452',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 10:04:47','',''),(445,'1','313','1',1,'Retail Sale Id 453',923.00,0.00,0.00,1.30,136.50,'2023-02-27 10:09:21','',''),(446,'1','313','1',1,'Retail Sale Id 455',201000.00,0.00,0.00,300.00,19500.00,'2023-02-27 10:12:30','',''),(447,'1','313','1',1,'Retail Sale Id 456',710.00,0.00,0.00,1.00,105.00,'2023-02-27 10:13:28','',''),(448,'1','313','1',1,'Retail Sale Id 457',31950.00,0.00,0.00,45.00,4725.00,'2023-02-27 10:15:24','',''),(449,'1','313','1',1,'Retail Sale Id 458',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 10:16:40','',''),(450,'1','313','1',1,'Retail Sale Id 460',710.00,0.00,0.00,1.00,105.00,'2023-02-27 10:19:32','',''),(451,'1','313','1',1,'Retail Sale Id 461',702.90,0.00,0.00,0.99,103.95,'2023-02-27 10:21:11','',''),(452,'1','313','1',1,'Retail Sale Id 462',3997.30,0.00,0.00,5.63,591.15,'2023-02-27 10:22:02','',''),(453,'1','313','1',1,'Retail Sale Id 463',3003.30,0.00,0.00,4.23,444.15,'2023-02-27 10:23:41','',''),(454,'1','313','1',1,'Retail Sale Id 464',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 10:26:14','',''),(455,'1','313','1',1,'Retail Sale Id 465',67000.00,0.00,0.00,100.00,6500.00,'2023-02-27 10:28:19','',''),(456,'1','313','1',1,'Retail Sale Id 466',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 10:30:36','',''),(457,'1','313','1',1,'Retail Sale Id 467',2840.00,0.00,0.00,4.00,420.00,'2023-02-27 10:32:08','',''),(458,'1','313','1',1,'Retail Sale Id 468',2840.00,0.00,0.00,4.00,420.00,'2023-02-27 10:33:46','',''),(459,'1','313','1',1,'Retail Sale Id 469',1498.10,0.00,0.00,2.11,221.55,'2023-02-27 10:38:11','',''),(460,'1','313','1',1,'Retail Sale Id 471',710.00,0.00,0.00,1.00,105.00,'2023-02-27 10:42:02','',''),(461,'1','313','1',1,'Retail Sale Id 472',4998.40,0.00,0.00,7.04,739.20,'2023-02-27 10:46:29','',''),(462,'1','313','1',1,'Retail Sale Id 473',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 10:48:18','',''),(463,'1','313','1',1,'Retail Sale Id 474',4260.00,0.00,0.00,6.00,630.00,'2023-02-27 10:51:29','',''),(464,'1','313','1',1,'Retail Sale Id 475',5325.00,0.00,0.00,7.50,787.50,'2023-02-27 10:54:15','',''),(465,'1','313','1',1,'Retail Sale Id 476',4970.00,0.00,0.00,7.00,735.00,'2023-02-27 10:59:11','',''),(466,'1','313','1',1,'Retail Sale Id 477',40200.00,0.00,0.00,60.00,3900.00,'2023-02-27 11:02:06','',''),(467,'1','313','1',1,'Retail Sale Id 478',4260.00,0.00,0.00,6.00,630.00,'2023-02-27 11:04:05','',''),(468,'1','313','1',1,'Retail Sale Id 479',40354.10,0.00,0.00,60.23,3914.95,'2023-02-27 11:06:53','',''),(469,'1','313','1',1,'Retail Sale Id 481',39978.90,0.00,0.00,59.67,3878.55,'2023-02-27 11:09:03','',''),(470,'1','313','1',1,'Retail Sale Id 482',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 11:11:02','',''),(471,'1','313','1',1,'Retail Sale Id 483',7100.00,0.00,0.00,10.00,1050.00,'2023-02-27 11:12:47','',''),(472,'1','313','1',1,'Retail Sale Id 484',40870.00,0.00,0.00,61.00,3965.00,'2023-02-27 11:14:30','',''),(473,'1','313','1',1,'Retail Sale Id 485',3550.00,0.00,0.00,5.00,525.00,'2023-02-27 11:19:06','',''),(474,'1','313','1',1,'Retail Sale Id 486',710.00,0.00,0.00,1.00,105.00,'2023-02-27 11:20:21','',''),(475,'1','313','1',1,'Retail Sale Id 487',4970.00,0.00,0.00,7.00,735.00,'2023-02-27 11:22:42','',''),(476,'1','313','1',1,'Retail Sale Id 488',40253.60,0.00,0.00,60.08,3905.20,'2023-02-27 11:24:52','',''),(477,'1','313','1',1,'Retail Sale Id 489',4260.00,0.00,0.00,6.00,630.00,'2023-02-27 11:26:32','',''),(478,'1','313','1',1,'Retail Sale Id 490',752.60,0.00,0.00,1.06,111.30,'2023-02-27 11:27:57','',''),(479,'1','313','1',1,'Retail Sale Id 491',8875.00,0.00,0.00,12.50,1312.50,'2023-02-27 11:29:26','',''),(480,'1','313','1',1,'Retail Sale Id 492',3550.00,0.00,0.00,5.00,525.00,'2023-02-27 11:31:37','',''),(481,'1','313','1',1,'Retail Sale Id 493',4260.00,0.00,0.00,6.00,630.00,'2023-02-27 11:33:02','',''),(482,'1','313','1',1,'Retail Sale Id 495',4260.00,0.00,0.00,6.00,630.00,'2023-02-27 11:38:24','',''),(483,'1','313','1',1,'Return of Retail Sale Id 484',0.00,40870.00,61.00,0.00,-3965.00,'2023-02-27 11:41:21','',''),(484,'1','313','1',1,'Return of Retail Sale Id 477',0.00,40200.00,60.00,0.00,-3900.00,'2023-02-27 11:42:05','',''),(485,'1','313','1',1,'Retail Sale Id 496',2840.00,0.00,0.00,4.00,420.00,'2023-02-27 11:46:46','',''),(486,'1','313','1',1,'Retail Sale Id 497',3550.00,0.00,0.00,5.00,525.00,'2023-02-27 11:50:07','',''),(487,'1','313','1',1,'Retail Sale Id 499',7810.00,0.00,0.00,11.00,1155.00,'2023-02-27 11:54:39','',''),(488,'1','313','1',1,'Retail Sale Id 500',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 11:55:56','',''),(489,'1','313','1',1,'Retail Sale Id 501',3003.30,0.00,0.00,4.23,444.15,'2023-02-27 12:00:16','',''),(490,'1','313','1',1,'Retail Sale Id 502',3550.00,0.00,0.00,5.00,525.00,'2023-02-27 12:01:42','',''),(491,'1','313','1',1,'Retail Sale Id 503',4970.00,0.00,0.00,7.00,735.00,'2023-02-27 12:08:33','',''),(492,'1','313','1',1,'Retail Sale Id 504',7100.00,0.00,0.00,10.00,1050.00,'2023-02-27 12:16:33','',''),(493,'1','313','1',1,'Retail Sale Id 505',3550.00,0.00,0.00,5.00,525.00,'2023-02-27 12:19:25','',''),(494,'1','313','1',1,'Retail Sale Id 506',31389.10,0.00,0.00,44.21,4642.05,'2023-02-27 12:21:01','',''),(495,'1','313','1',1,'Retail Sale Id 507',710.00,0.00,0.00,1.00,105.00,'2023-02-27 12:22:52','',''),(496,'1','313','1',1,'Retail Sale Id 509',752.60,0.00,0.00,1.06,111.30,'2023-02-27 12:26:45','',''),(497,'1','313','1',1,'Retail Sale Id 510',752.60,0.00,0.00,1.06,111.30,'2023-02-27 12:27:57','',''),(498,'1','313','1',1,'Retail Sale Id 511',752.60,0.00,0.00,1.06,111.30,'2023-02-27 12:37:25','',''),(499,'1','313','1',1,'Retail Sale Id 512',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 12:38:52','',''),(500,'1','313','1',1,'Retail Sale Id 513',3003.30,0.00,0.00,4.23,444.15,'2023-02-27 12:41:24','',''),(501,'1','313','1',1,'Retail Sale Id 514',17040.00,0.00,0.00,24.00,2520.00,'2023-02-27 12:53:25','',''),(502,'1','313','1',1,'Retail Sale Id 515',3550.00,0.00,0.00,5.00,525.00,'2023-02-27 12:56:18','',''),(503,'1','313','1',1,'Retail Sale Id 516',752.60,0.00,0.00,1.06,111.30,'2023-02-27 13:06:37','',''),(504,'1','313','1',1,'Retail Sale Id 517',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 13:16:02','',''),(505,'1','313','1',1,'Retail Sale Id 518',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 13:19:36','',''),(506,'1','313','1',1,'Retail Sale Id 519',3003.30,0.00,0.00,4.23,444.15,'2023-02-27 13:21:14','',''),(507,'1','313','1',1,'Retail Sale Id 520',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 13:24:54','',''),(508,'1','313','1',1,'Retail Sale Id 521',710.00,0.00,0.00,1.00,105.00,'2023-02-27 13:26:50','',''),(509,'1','313','1',1,'Retail Sale Id 523',752.60,0.00,0.00,1.06,111.30,'2023-02-27 13:29:12','',''),(510,'1','313','1',1,'Retail Sale Id 524',8520.00,0.00,0.00,12.00,1260.00,'2023-02-27 13:37:14','',''),(511,'1','313','1',1,'Retail Sale Id 525',603.50,0.00,0.00,0.85,89.25,'2023-02-27 13:42:34','',''),(512,'1','313','1',1,'Retail Sale Id 526',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 13:48:16','',''),(513,'1','313','1',1,'Retail Sale Id 527',33500.00,0.00,0.00,50.00,3250.00,'2023-02-27 13:49:45','',''),(514,'1','313','1',1,'Retail Sale Id 528',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 13:55:09','',''),(515,'1','313','1',1,'Retail Sale Id 529',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 13:57:57','',''),(516,'1','313','1',1,'Retail Sale Id 530',1448.40,0.00,0.00,2.04,214.20,'2023-02-27 13:59:05','',''),(517,'1','313','1',1,'Retail Sale Id 531',1448.40,0.00,0.00,2.04,214.20,'2023-02-27 13:59:58','',''),(518,'1','313','1',1,'Retail Sale Id 532',5325.00,0.00,0.00,7.50,787.50,'2023-02-27 14:08:22','',''),(519,'1','313','1',1,'Retail Sale Id 533',8875.00,0.00,0.00,12.50,1312.50,'2023-02-27 14:09:50','',''),(520,'1','313','1',1,'Retail Sale Id 534',710.00,0.00,0.00,1.00,105.00,'2023-02-27 14:10:59','',''),(521,'1','313','1',1,'Retail Sale Id 535',710.00,0.00,0.00,1.00,105.00,'2023-02-27 14:11:54','',''),(522,'1','313','1',1,'Retail Sale Id 536',3550.00,0.00,0.00,5.00,525.00,'2023-02-27 14:13:55','',''),(523,'1','313','1',1,'Retail Sale Id 538',1448.40,0.00,0.00,2.04,214.20,'2023-02-27 14:17:27','',''),(524,'1','313','1',1,'Retail Sale Id 539',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 14:21:28','',''),(525,'1','313','1',1,'Retail Sale Id 540',8875.00,0.00,0.00,12.50,1312.50,'2023-02-27 14:28:24','',''),(526,'1','313','1',1,'Retail Sale Id 541',3550.00,0.00,0.00,5.00,525.00,'2023-02-27 14:33:12','',''),(527,'1','313','1',1,'Retail Sale Id 542',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 14:34:50','',''),(528,'1','313','1',1,'Retail Sale Id 543',80400.00,0.00,0.00,120.00,7800.00,'2023-02-27 14:37:20','',''),(529,'1','313','1',1,'Retail Sale Id 544',4260.00,0.00,0.00,6.00,630.00,'2023-02-27 14:41:03','',''),(530,'1','313','1',1,'Retail Sale Id 545',710.00,0.00,0.00,1.00,105.00,'2023-02-27 14:42:50','',''),(531,'1','313','1',1,'Retail Sale Id 546',2840.00,0.00,0.00,4.00,420.00,'2023-02-27 14:44:24','',''),(532,'1','313','1',1,'Retail Sale Id 547',2840.00,0.00,0.00,4.00,420.00,'2023-02-27 14:45:49','',''),(533,'1','313','1',1,'Retail Sale Id 548',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 14:51:19','',''),(534,'1','313','1',1,'Retail Sale Id 549',7100.00,0.00,0.00,10.00,1050.00,'2023-02-27 15:02:51','',''),(535,'1','313','1',1,'Retail Sale Id 550',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 15:05:11','',''),(536,'1','313','1',1,'Retail Sale Id 551',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 15:21:32','',''),(537,'1','313','1',1,'Retail Sale Id 552',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 15:25:17','',''),(538,'1','313','1',1,'Retail Sale Id 553',2002.20,0.00,0.00,2.82,296.10,'2023-02-27 15:27:50','',''),(539,'1','313','1',1,'Retail Sale Id 554',710.00,0.00,0.00,1.00,105.00,'2023-02-27 15:29:04','',''),(540,'1','313','1',1,'Retail Sale Id 555',43550.00,0.00,0.00,65.00,4225.00,'2023-02-27 15:31:14','',''),(541,'1','313','1',1,'Retail Sale Id 556',9940.00,0.00,0.00,14.00,1470.00,'2023-02-27 15:34:43','',''),(542,'1','313','1',1,'Retail Sale Id 557',710.00,0.00,0.00,1.00,105.00,'2023-02-27 15:35:26','',''),(543,'1','313','1',1,'Retail Sale Id 558',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 15:36:54','',''),(544,'1','313','1',1,'Retail Sale Id 559',710.00,0.00,0.00,1.00,105.00,'2023-02-27 15:39:21','',''),(545,'1','313','1',1,'Retail Sale Id 560',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 15:44:22','',''),(546,'1','313','1',1,'Retail Sale Id 561',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 15:49:37','',''),(547,'1','313','1',1,'Retail Sale Id 562',2840.00,0.00,0.00,4.00,420.00,'2023-02-27 15:52:25','',''),(548,'1','313','1',1,'Retail Sale Id 564',2840.00,0.00,0.00,4.00,420.00,'2023-02-27 15:56:06','',''),(549,'1','313','1',1,'Retail Sale Id 566',752.60,0.00,0.00,1.06,111.30,'2023-02-27 16:14:09','',''),(550,'1','313','1',1,'Retail Sale Id 567',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 16:19:55','',''),(551,'1','313','1',1,'Retail Sale Id 568',2840.00,0.00,0.00,4.00,420.00,'2023-02-27 16:22:11','',''),(552,'1','313','1',1,'Retail Sale Id 569',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 16:27:51','',''),(553,'1','313','1',1,'Retail Sale Id 570',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 16:29:25','',''),(554,'1','313','1',1,'Retail Sale Id 571',3997.30,0.00,0.00,5.63,591.15,'2023-02-27 16:30:54','',''),(555,'1','313','1',1,'Retail Sale Id 572',752.60,0.00,0.00,1.06,111.30,'2023-02-27 16:32:06','',''),(556,'1','313','1',1,'Retail Sale Id 573',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 16:33:41','',''),(557,'1','313','1',1,'Retail Sale Id 574',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 16:35:48','',''),(558,'1','313','1',1,'Retail Sale Id 575',2896.80,0.00,0.00,4.08,428.40,'2023-02-27 16:38:33','',''),(559,'1','313','1',1,'Retail Sale Id 576',2840.00,0.00,0.00,4.00,420.00,'2023-02-27 16:40:25','',''),(560,'1','313','1',1,'Retail Sale Id 577',2151.30,0.00,0.00,3.03,318.15,'2023-02-27 16:41:31','',''),(561,'1','313','1',1,'Retail Sale Id 578',40066.00,0.00,0.00,59.80,3887.00,'2023-02-27 16:44:22','',''),(562,'1','313','1',1,'Return of Retail Sale Id 578',0.00,40066.00,59.80,0.00,-3887.00,'2023-02-27 16:45:09','',''),(563,'1','313','1',1,'Retail Sale Id 579',39978.90,0.00,0.00,59.67,3878.55,'2023-02-27 16:46:35','',''),(564,'1','313','1',1,'Retail Sale Id 580',33500.00,0.00,0.00,50.00,3250.00,'2023-02-27 16:49:57','',''),(565,'1','313','1',1,'Retail Sale Id 581',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 16:52:39','',''),(566,'1','313','1',1,'Retail Sale Id 582',40066.00,0.00,0.00,59.80,3887.00,'2023-02-27 16:53:43','',''),(567,'1','313','1',1,'Retail Sale Id 583',710.00,0.00,0.00,1.00,105.00,'2023-02-27 16:55:01','',''),(568,'1','313','1',1,'Retail Sale Id 585',710.00,0.00,0.00,1.00,105.00,'2023-02-27 16:56:55','',''),(569,'1','313','1',1,'Retail Sale Id 586',710.00,0.00,0.00,1.00,105.00,'2023-02-27 16:57:55','',''),(570,'1','313','1',1,'Retail Sale Id 587',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 16:59:28','',''),(571,'1','313','1',1,'Retail Sale Id 588',752.60,0.00,0.00,1.06,111.30,'2023-02-27 17:00:48','',''),(572,'1','313','1',1,'Retail Sale Id 589',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 17:02:31','',''),(573,'1','313','1',1,'Retail Sale Id 590',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 17:04:00','',''),(574,'1','313','1',1,'Retail Sale Id 591',3550.00,0.00,0.00,5.00,525.00,'2023-02-27 17:05:07','',''),(575,'1','313','1',1,'Retail Sale Id 592',4970.00,0.00,0.00,7.00,735.00,'2023-02-27 17:06:07','',''),(576,'1','313','1',1,'Return of Retail Sale Id 579',0.00,39978.90,59.67,0.00,-3878.55,'2023-02-27 17:11:48','',''),(577,'1','313','1',1,'Retail Sale Id 593',4260.00,0.00,0.00,6.00,630.00,'2023-02-27 17:14:00','',''),(578,'1','313','1',1,'Retail Sale Id 594',8875.00,0.00,0.00,12.50,1312.50,'2023-02-27 17:15:50','',''),(579,'1','313','1',1,'Retail Sale Id 595',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 17:17:19','',''),(580,'1','313','1',1,'Retail Sale Id 596',752.60,0.00,0.00,1.06,111.30,'2023-02-27 17:18:53','',''),(581,'1','313','1',1,'Retail Sale Id 597',738.40,0.00,0.00,1.04,109.20,'2023-02-27 17:20:08','',''),(582,'1','313','1',1,'Retail Sale Id 598',1001.10,0.00,0.00,1.41,148.05,'2023-02-27 17:20:53','',''),(583,'1','313','1',1,'Retail Sale Id 599',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 17:21:45','',''),(584,'1','313','1',1,'Retail Sale Id 600',4970.00,0.00,0.00,7.00,735.00,'2023-02-27 17:23:14','',''),(585,'1','313','1',1,'Retail Sale Id 601',3550.00,0.00,0.00,5.00,525.00,'2023-02-27 17:27:34','',''),(586,'1','313','1',1,'Retail Sale Id 602',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 17:28:36','',''),(587,'1','313','1',1,'Retail Sale Id 603',2002.20,0.00,0.00,2.82,296.10,'2023-02-27 17:31:36','',''),(588,'1','313','1',1,'Retail Sale Id 604',1498.10,0.00,0.00,2.11,221.55,'2023-02-27 17:33:23','',''),(589,'1','313','1',1,'Retail Sale Id 606',3500.30,0.00,0.00,4.93,517.65,'2023-02-27 17:35:45','',''),(590,'1','313','1',1,'Retail Sale Id 607',2201.00,0.00,0.00,3.10,325.50,'2023-02-27 17:37:16','',''),(591,'1','313','1',1,'Retail Sale Id 608',2151.30,0.00,0.00,3.03,318.15,'2023-02-27 17:38:18','',''),(592,'1','313','1',1,'Return of Retail Sale Id 603',0.00,2002.20,2.82,0.00,-296.10,'2023-02-27 17:39:28','',''),(593,'1','313','1',1,'Retail Sale Id 609',2499.20,0.00,0.00,3.52,369.60,'2023-02-27 17:42:41','',''),(594,'1','313','1',1,'Retail Sale Id 611',5999.50,0.00,0.00,8.45,887.25,'2023-02-27 17:48:38','',''),(595,'1','313','1',1,'Retail Sale Id 612',2130.00,0.00,0.00,3.00,315.00,'2023-02-27 17:50:42','',''),(596,'1','313','1',1,'Retail Sale Id 613',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 17:51:46','',''),(597,'1','313','1',1,'Retail Sale Id 614',1420.00,0.00,0.00,2.00,210.00,'2023-02-27 17:53:09','',''),(598,'1','313','1',1,'Return of Retail Sale Id 506',0.00,31389.10,44.21,0.00,-4642.05,'2023-02-27 18:07:58','',''),(599,'1','313','1',1,'Retail Sale Id 615',27644.20,0.00,0.00,41.26,2681.90,'2023-02-27 18:09:01','',''),(600,'1','313','1',1,'Retail Sale Id 616',1788.90,0.00,0.00,2.67,173.55,'2023-02-27 18:13:13','',''),(601,'1','313','1',1,'Retail Sale Id 617',291.10,0.00,0.00,0.41,43.05,'2023-02-27 18:17:11','',''),(602,'1','313','1',1,'Retail Sale Id 618',710.00,0.00,0.00,1.00,105.00,'2023-02-28 07:54:11','',''),(603,'1','313','1',1,'Retail Sale Id 619',752.60,0.00,0.00,1.06,111.30,'2023-02-28 07:55:22','',''),(604,'1','313','1',1,'Retail Sale Id 620',710.00,0.00,0.00,1.00,105.00,'2023-02-28 07:57:05','',''),(605,'1','313','1',1,'Retail Sale Id 621',3550.00,0.00,0.00,5.00,525.00,'2023-02-28 07:58:15','',''),(606,'1','313','1',1,'Retail Sale Id 622',710.00,0.00,0.00,1.00,105.00,'2023-02-28 08:00:16','',''),(607,'1','313','1',1,'Retail Sale Id 623',8875.00,0.00,0.00,12.50,1312.50,'2023-02-28 08:02:33','',''),(608,'1','313','1',1,'Retail Sale Id 624',10650.00,0.00,0.00,15.00,1575.00,'2023-02-28 08:04:14','',''),(609,'1','313','1',1,'Retail Sale Id 625',7100.00,0.00,0.00,10.00,1050.00,'2023-02-28 08:05:21','',''),(610,'1','313','1',1,'Retail Sale Id 626',33500.00,0.00,0.00,50.00,3250.00,'2023-02-28 08:07:13','',''),(611,'1','313','1',1,'Retail Sale Id 627',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 08:09:05','',''),(612,'1','313','1',1,'Retail Sale Id 628',39858.30,0.00,0.00,59.49,3866.85,'2023-02-28 08:11:29','',''),(613,'1','313','1',1,'Retail Sale Id 629',8875.00,0.00,0.00,12.50,1312.50,'2023-02-28 08:13:46','',''),(614,'1','313','1',1,'Retail Sale Id 630',2130.00,0.00,0.00,3.00,315.00,'2023-02-28 08:16:49','',''),(615,'1','313','1',1,'Retail Sale Id 631',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 08:19:45','',''),(616,'1','313','1',1,'Retail Sale Id 632',710.00,0.00,0.00,1.00,105.00,'2023-02-28 08:20:36','',''),(617,'1','313','1',1,'Retail Sale Id 633',3550.00,0.00,0.00,5.00,525.00,'2023-02-28 08:21:48','',''),(618,'1','313','1',1,'Retail Sale Id 634',3550.00,0.00,0.00,5.00,525.00,'2023-02-28 08:22:47','',''),(619,'1','313','1',1,'Retail Sale Id 635',80400.00,0.00,0.00,120.00,7800.00,'2023-02-28 08:25:57','',''),(620,'1','313','1',1,'Retail Sale Id 636',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 08:28:47','',''),(621,'1','313','1',1,'Retail Sale Id 637',2399.80,0.00,0.00,3.38,354.90,'2023-02-28 08:30:33','',''),(622,'1','313','1',1,'Retail Sale Id 638',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 08:31:57','',''),(623,'1','313','1',1,'Retail Sale Id 639',2151.30,0.00,0.00,3.03,318.15,'2023-02-28 08:33:55','',''),(624,'1','313','1',1,'Retail Sale Id 640',752.60,0.00,0.00,1.06,111.30,'2023-02-28 08:35:48','',''),(625,'1','313','1',1,'Retail Sale Id 641',3550.00,0.00,0.00,5.00,525.00,'2023-02-28 08:37:23','',''),(626,'1','313','1',1,'Retail Sale Id 642',134000.00,0.00,0.00,200.00,13000.00,'2023-02-28 08:46:59','',''),(627,'1','313','1',1,'Retail Sale Id 643',4260.00,0.00,0.00,6.00,630.00,'2023-02-28 08:51:38','',''),(628,'1','313','1',1,'Retail Sale Id 644',710.00,0.00,0.00,1.00,105.00,'2023-02-28 08:52:55','',''),(629,'1','313','1',1,'Retail Sale Id 645',8875.00,0.00,0.00,12.50,1312.50,'2023-02-28 08:56:34','',''),(630,'1','313','1',1,'Retail Sale Id 646',2840.00,0.00,0.00,4.00,420.00,'2023-02-28 08:58:17','',''),(631,'1','313','1',1,'Retail Sale Id 647',710.00,0.00,0.00,1.00,105.00,'2023-02-28 09:01:56','',''),(632,'1','313','1',1,'Retail Sale Id 648',5680.00,0.00,0.00,8.00,840.00,'2023-02-28 09:08:42','',''),(633,'1','313','1',1,'Retail Sale Id 649',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 09:13:14','',''),(634,'1','313','1',1,'Retail Sale Id 650',752.60,0.00,0.00,1.06,111.30,'2023-02-28 09:14:19','',''),(635,'1','313','1',1,'Retail Sale Id 651',752.60,0.00,0.00,1.06,111.30,'2023-02-28 09:15:11','',''),(636,'1','313','1',1,'Retail Sale Id 652',3550.00,0.00,0.00,5.00,525.00,'2023-02-28 09:16:36','',''),(637,'1','313','1',1,'Retail Sale Id 654',710.00,0.00,0.00,1.00,105.00,'2023-02-28 09:24:47','',''),(638,'1','313','1',1,'Retail Sale Id 655',710.00,0.00,0.00,1.00,105.00,'2023-02-28 09:25:54','',''),(639,'1','313','1',1,'Retail Sale Id 656',2130.00,0.00,0.00,3.00,315.00,'2023-02-28 09:31:20','',''),(640,'1','313','1',1,'Retail Sale Id 657',1001.10,0.00,0.00,1.41,148.05,'2023-02-28 09:32:22','',''),(641,'1','313','1',1,'Retail Sale Id 658',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 09:35:52','',''),(642,'1','313','1',1,'Retail Sale Id 659',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 09:39:52','',''),(643,'1','313','1',1,'Retail Sale Id 660',2130.00,0.00,0.00,3.00,315.00,'2023-02-28 09:41:57','',''),(644,'1','313','1',1,'Retail Sale Id 663',1448.40,0.00,0.00,2.04,214.20,'2023-02-28 09:46:57','',''),(645,'1','313','1',1,'Retail Sale Id 665',2840.00,0.00,0.00,4.00,420.00,'2023-02-28 09:48:49','',''),(646,'1','313','1',1,'Retail Sale Id 666',710.00,0.00,0.00,1.00,105.00,'2023-02-28 09:50:57','',''),(647,'1','313','1',1,'Retail Sale Id 667',4970.00,0.00,0.00,7.00,735.00,'2023-02-28 09:52:02','',''),(648,'1','313','1',1,'Retail Sale Id 668',710.00,0.00,0.00,1.00,105.00,'2023-02-28 09:53:21','',''),(649,'1','313','1',1,'Retail Sale Id 669',702.90,0.00,0.00,0.99,103.95,'2023-02-28 09:54:29','',''),(650,'1','313','1',1,'Retail Sale Id 670',710.00,0.00,0.00,1.00,105.00,'2023-02-28 09:55:30','',''),(651,'1','313','1',1,'Retail Sale Id 671',710.00,0.00,0.00,1.00,105.00,'2023-02-28 09:57:35','',''),(652,'1','313','1',1,'Retail Sale Id 672',2130.00,0.00,0.00,3.00,315.00,'2023-02-28 09:58:33','',''),(653,'1','313','1',1,'Retail Sale Id 673',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 10:01:34','',''),(654,'1','313','1',1,'Retail Sale Id 674',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 10:03:22','',''),(655,'1','313','1',1,'Retail Sale Id 675',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 10:44:54','',''),(656,'1','313','1',1,'Retail Sale Id 676',3550.00,0.00,0.00,5.00,525.00,'2023-02-28 10:46:21','',''),(657,'1','313','1',1,'Retail Sale Id 678',2840.00,0.00,0.00,4.00,420.00,'2023-02-28 10:47:49','',''),(658,'1','313','1',1,'Retail Sale Id 679',4970.00,0.00,0.00,7.00,735.00,'2023-02-28 10:49:36','',''),(659,'1','313','1',1,'Retail Sale Id 680',3003.30,0.00,0.00,4.23,444.15,'2023-02-28 10:50:57','',''),(660,'1','313','1',1,'Retail Sale Id 681',2002.20,0.00,0.00,2.82,296.10,'2023-02-28 10:51:57','',''),(661,'1','313','1',1,'Retail Sale Id 682',2002.20,0.00,0.00,2.82,296.10,'2023-02-28 10:52:45','',''),(662,'1','313','1',1,'Retail Sale Id 683',710.00,0.00,0.00,1.00,105.00,'2023-02-28 10:54:01','',''),(663,'1','313','1',1,'Retail Sale Id 684',4970.00,0.00,0.00,7.00,735.00,'2023-02-28 10:55:18','',''),(664,'1','313','1',1,'Retail Sale Id 686',7810.00,0.00,0.00,11.00,1155.00,'2023-02-28 10:57:53','',''),(665,'1','313','1',1,'Retail Sale Id 687',29500.10,0.00,0.00,44.03,2861.95,'2023-02-28 11:00:10','',''),(666,'1','313','1',1,'Retail Sale Id 688',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 11:01:35','',''),(667,'1','313','1',1,'Retail Sale Id 689',4260.00,0.00,0.00,6.00,630.00,'2023-02-28 11:02:56','',''),(668,'1','313','1',1,'Retail Sale Id 690',2499.20,0.00,0.00,3.52,369.60,'2023-02-28 11:04:07','',''),(669,'1','313','1',1,'Retail Sale Id 691',8875.00,0.00,0.00,12.50,1312.50,'2023-02-28 11:05:41','',''),(670,'1','313','1',1,'Retail Sale Id 692',752.60,0.00,0.00,1.06,111.30,'2023-02-28 11:07:11','',''),(671,'1','313','1',1,'Retail Sale Id 694',83461.90,0.00,0.00,124.57,8097.05,'2023-02-28 11:11:29','',''),(672,'1','313','1',1,'Retail Sale Id 696',8520.00,0.00,0.00,12.00,1260.00,'2023-02-28 11:18:15','',''),(673,'1','313','1',1,'Retail Sale Id 697',4970.00,0.00,0.00,7.00,735.00,'2023-02-28 11:19:29','',''),(674,'1','313','1',1,'Retail Sale Id 698',2130.00,0.00,0.00,3.00,315.00,'2023-02-28 11:22:21','',''),(675,'1','313','1',1,'Retail Sale Id 699',8875.00,0.00,0.00,12.50,1312.50,'2023-02-28 11:23:53','',''),(676,'1','313','1',1,'Retail Sale Id 700',3003.30,0.00,0.00,4.23,444.15,'2023-02-28 11:25:47','',''),(677,'1','313','1',1,'Retail Sale Id 702',4203.20,0.00,0.00,5.92,621.60,'2023-02-28 11:28:27','',''),(678,'1','313','1',1,'Retail Sale Id 703',1448.40,0.00,0.00,2.04,214.20,'2023-02-28 11:29:53','',''),(679,'1','313','1',1,'Retail Sale Id 704',1448.40,0.00,0.00,2.04,214.20,'2023-02-28 11:30:57','',''),(680,'1','313','1',1,'Retail Sale Id 705',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 11:32:59','',''),(681,'1','313','1',1,'Retail Sale Id 706',8875.00,0.00,0.00,12.50,1312.50,'2023-02-28 11:34:06','',''),(682,'1','313','1',1,'Retail Sale Id 707',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 11:35:39','',''),(683,'1','313','1',1,'Retail Sale Id 708',4970.00,0.00,0.00,7.00,735.00,'2023-02-28 11:38:31','',''),(684,'1','313','1',1,'Retail Sale Id 709',33500.00,0.00,0.00,50.00,3250.00,'2023-02-28 11:40:58','',''),(685,'1','313','1',1,'Retail Sale Id 710',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 11:42:47','',''),(686,'1','313','1',1,'Retail Sale Id 711',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 11:43:59','',''),(687,'1','313','1',1,'Retail Sale Id 712',7100.00,0.00,0.00,10.00,1050.00,'2023-02-28 11:44:48','',''),(688,'1','313','1',1,'Retail Sale Id 713',710.00,0.00,0.00,1.00,105.00,'2023-02-28 11:46:33','',''),(689,'1','313','1',1,'Retail Sale Id 714',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 11:48:03','',''),(690,'1','313','1',1,'Retail Sale Id 715',4260.00,0.00,0.00,6.00,630.00,'2023-02-28 11:49:43','',''),(691,'1','313','1',1,'Retail Sale Id 716',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 11:51:11','',''),(692,'1','313','1',1,'Retail Sale Id 717',4970.00,0.00,0.00,7.00,735.00,'2023-02-28 11:56:28','',''),(693,'1','313','1',1,'Retail Sale Id 718',2130.00,0.00,0.00,3.00,315.00,'2023-02-28 11:59:01','',''),(694,'1','313','1',1,'Retail Sale Id 719',2151.30,0.00,0.00,3.03,318.15,'2023-02-28 12:00:49','',''),(695,'1','313','1',1,'Retail Sale Id 720',710.00,0.00,0.00,1.00,105.00,'2023-02-28 12:02:04','',''),(696,'1','313','1',1,'Retail Sale Id 721',752.60,0.00,0.00,1.06,111.30,'2023-02-28 12:07:56','',''),(697,'1','313','1',1,'Retail Sale Id 722',3550.00,0.00,0.00,5.00,525.00,'2023-02-28 12:09:23','',''),(698,'1','313','1',1,'Retail Sale Id 723',3550.00,0.00,0.00,5.00,525.00,'2023-02-28 12:10:39','',''),(699,'1','313','1',1,'Retail Sale Id 724',39965.50,0.00,0.00,59.65,3877.25,'2023-02-28 12:13:21','',''),(700,'1','313','1',1,'Retail Sale Id 725',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 12:18:06','',''),(701,'1','313','1',1,'Retail Sale Id 726',40923.60,0.00,0.00,61.08,3970.20,'2023-02-28 12:32:27','',''),(702,'1','313','1',1,'Retail Sale Id 727',12425.00,0.00,0.00,17.50,1837.50,'2023-02-28 12:35:34','',''),(703,'1','313','1',1,'Retail Sale Id 728',1448.40,0.00,0.00,2.04,214.20,'2023-02-28 12:37:57','',''),(704,'1','313','1',1,'Retail Sale Id 729',752.60,0.00,0.00,1.06,111.30,'2023-02-28 12:39:06','',''),(705,'1','313','1',1,'Retail Sale Id 730',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 12:40:07','',''),(706,'1','313','1',1,'Retail Sale Id 731',1448.40,0.00,0.00,2.04,214.20,'2023-02-28 12:47:43','',''),(707,'1','313','1',1,'Retail Sale Id 732',2130.00,0.00,0.00,3.00,315.00,'2023-02-28 12:49:11','',''),(708,'1','313','1',1,'Retail Sale Id 733',6390.00,0.00,0.00,9.00,945.00,'2023-02-28 12:53:55','',''),(709,'1','313','1',1,'Retail Sale Id 734',7100.00,0.00,0.00,10.00,1050.00,'2023-02-28 12:55:30','',''),(710,'1','313','1',1,'Retail Sale Id 735',717.10,0.00,0.00,1.01,106.05,'2023-02-28 13:00:28','',''),(711,'1','313','1',1,'Retail Sale Id 736',2840.00,0.00,0.00,4.00,420.00,'2023-02-28 13:16:36','',''),(712,'1','313','1',1,'Retail Sale Id 737',2130.00,0.00,0.00,3.00,315.00,'2023-02-28 13:18:15','',''),(713,'1','313','1',1,'Return of Retail Sale Id 736',0.00,2840.00,4.00,0.00,-420.00,'2023-02-28 13:21:49','',''),(714,'1','313','1',1,'Retail Sale Id 738',710.00,0.00,0.00,1.00,105.00,'2023-02-28 13:22:35','',''),(715,'1','313','1',1,'Retail Sale Id 739',3550.00,0.00,0.00,5.00,525.00,'2023-02-28 13:32:12','',''),(716,'1','313','1',1,'Retail Sale Id 740',4998.40,0.00,0.00,7.04,739.20,'2023-02-28 13:38:58','',''),(717,'1','313','1',1,'Retail Sale Id 741',4998.40,0.00,0.00,7.04,739.20,'2023-02-28 13:40:38','',''),(718,'1','313','1',1,'Retail Sale Id 742',3003.30,0.00,0.00,4.23,444.15,'2023-02-28 13:42:34','',''),(719,'1','313','1',1,'Retail Sale Id 743',8875.00,0.00,0.00,12.50,1312.50,'2023-02-28 13:45:11','',''),(720,'1','313','1',1,'Retail Sale Id 744',8875.00,0.00,0.00,12.50,1312.50,'2023-02-28 13:46:17','',''),(721,'1','313','1',1,'Retail Sale Id 745',9230.00,0.00,0.00,13.00,1365.00,'2023-02-28 13:47:24','',''),(722,'1','313','1',1,'Retail Sale Id 746',4260.00,0.00,0.00,6.00,630.00,'2023-02-28 13:52:08','',''),(723,'1','313','1',1,'Retail Sale Id 747',2840.00,0.00,0.00,4.00,420.00,'2023-02-28 13:53:34','',''),(724,'1','313','1',1,'Retail Sale Id 748',2130.00,0.00,0.00,3.00,315.00,'2023-02-28 13:58:17','',''),(725,'1','313','1',1,'Retail Sale Id 749',710.00,0.00,0.00,1.00,105.00,'2023-02-28 14:00:13','',''),(726,'1','313','1',1,'Retail Sale Id 750',17040.00,0.00,0.00,24.00,2520.00,'2023-02-28 14:01:53','',''),(727,'1','313','1',1,'Retail Sale Id 752',2130.00,0.00,0.00,3.00,315.00,'2023-02-28 14:04:57','',''),(728,'1','313','1',1,'Retail Sale Id 753',2840.00,0.00,0.00,4.00,420.00,'2023-02-28 14:06:26','',''),(729,'1','313','1',1,'Retail Sale Id 754',5999.50,0.00,0.00,8.45,887.25,'2023-02-28 14:07:41','',''),(730,'1','313','1',1,'Retail Sale Id 755',5161.70,0.00,0.00,7.27,763.35,'2023-02-28 14:14:44','',''),(731,'1','313','1',1,'Retail Sale Id 756',752.60,0.00,0.00,1.06,111.30,'2023-02-28 14:17:20','',''),(732,'1','313','1',1,'Retail Sale Id 758',100500.00,0.00,0.00,150.00,9750.00,'2023-02-28 14:20:57','',''),(733,'1','313','1',1,'Retail Sale Id 759',702.90,0.00,0.00,0.99,103.95,'2023-02-28 14:24:40','',''),(734,'1','313','1',1,'Retail Sale Id 760',752.60,0.00,0.00,1.06,111.30,'2023-02-28 14:28:16','',''),(735,'1','313','1',1,'Return of Retail Sale Id 754',0.00,5999.50,8.45,0.00,-887.25,'2023-02-28 14:31:07','',''),(736,'1','313','1',1,'Retail Sale Id 761',2151.30,0.00,0.00,3.03,318.15,'2023-02-28 14:42:38','',''),(737,'1','313','1',1,'Retail Sale Id 762',2840.00,0.00,0.00,4.00,420.00,'2023-02-28 14:47:06','',''),(738,'1','313','1',1,'Retail Sale Id 763',1448.40,0.00,0.00,2.04,214.20,'2023-02-28 14:52:46','',''),(739,'1','313','1',1,'Retail Sale Id 764',8875.00,0.00,0.00,12.50,1312.50,'2023-02-28 14:54:12','',''),(740,'1','313','1',1,'Retail Sale Id 765',1448.40,0.00,0.00,2.04,214.20,'2023-02-28 15:08:08','',''),(741,'1','313','1',1,'Retail Sale Id 766',752.60,0.00,0.00,1.06,111.30,'2023-02-28 15:09:56','',''),(742,'1','313','1',1,'Retail Sale Id 767',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 15:12:02','',''),(743,'1','313','1',1,'Retail Sale Id 768',1448.40,0.00,0.00,2.04,214.20,'2023-02-28 15:16:14','',''),(744,'1','313','1',1,'Retail Sale Id 769',2499.20,0.00,0.00,3.52,369.60,'2023-02-28 15:18:54','',''),(745,'1','313','1',1,'Retail Sale Id 770',8520.00,0.00,0.00,12.00,1260.00,'2023-02-28 15:20:42','',''),(746,'1','313','1',1,'Retail Sale Id 771',710.00,0.00,0.00,1.00,105.00,'2023-02-28 15:21:59','',''),(747,'1','313','1',1,'Retail Sale Id 772',710.00,0.00,0.00,1.00,105.00,'2023-02-28 15:22:48','',''),(748,'1','313','1',1,'Retail Sale Id 773',2201.00,0.00,0.00,3.10,325.50,'2023-02-28 15:24:59','',''),(749,'1','313','1',1,'Retail Sale Id 774',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 15:26:15','',''),(750,'1','313','1',1,'Retail Sale Id 775',752.60,0.00,0.00,1.06,111.30,'2023-02-28 15:27:21','',''),(751,'1','313','1',1,'Retail Sale Id 776',4998.40,0.00,0.00,7.04,739.20,'2023-02-28 15:34:23','',''),(752,'1','313','1',1,'Retail Sale Id 777',710.00,0.00,0.00,1.00,105.00,'2023-02-28 15:35:24','',''),(753,'1','313','1',1,'Retail Sale Id 778',2130.00,0.00,0.00,3.00,315.00,'2023-02-28 15:49:55','',''),(754,'1','313','1',1,'Retail Sale Id 779',5680.00,0.00,0.00,8.00,840.00,'2023-02-28 15:54:40','',''),(755,'1','313','1',1,'Retail Sale Id 780',79060.00,0.00,0.00,118.00,7670.00,'2023-02-28 16:00:10','',''),(756,'1','313','1',1,'Retail Sale Id 781',4998.40,0.00,0.00,7.04,739.20,'2023-02-28 16:06:49','',''),(757,'1','313','1',1,'Retail Sale Id 782',710.00,0.00,0.00,1.00,105.00,'2023-02-28 16:08:50','',''),(758,'1','313','1',1,'Retail Sale Id 783',4998.40,0.00,0.00,7.04,739.20,'2023-02-28 16:09:52','',''),(759,'1','313','1',1,'Retail Sale Id 784',40200.00,0.00,0.00,60.00,3900.00,'2023-02-28 16:13:46','',''),(760,'1','313','1',1,'Retail Sale Id 785',7100.00,0.00,0.00,10.00,1050.00,'2023-02-28 16:15:41','',''),(761,'1','313','1',1,'Retail Sale Id 786',2002.20,0.00,0.00,2.82,296.10,'2023-02-28 16:18:03','',''),(762,'1','313','1',1,'Retail Sale Id 787',8520.00,0.00,0.00,12.00,1260.00,'2023-02-28 16:20:25','',''),(763,'1','313','1',1,'Retail Sale Id 788',2840.00,0.00,0.00,4.00,420.00,'2023-02-28 16:21:36','',''),(764,'1','313','1',1,'Retail Sale Id 789',3997.30,0.00,0.00,5.63,591.15,'2023-02-28 16:23:28','',''),(765,'1','313','1',1,'Retail Sale Id 790',4970.00,0.00,0.00,7.00,735.00,'2023-02-28 16:25:57','',''),(766,'1','313','1',1,'Retail Sale Id 791',8520.00,0.00,0.00,12.00,1260.00,'2023-02-28 16:27:25','',''),(767,'1','313','1',1,'Retail Sale Id 792',710.00,0.00,0.00,1.00,105.00,'2023-02-28 16:28:44','',''),(768,'1','313','1',1,'Retail Sale Id 793',2840.00,0.00,0.00,4.00,420.00,'2023-02-28 16:29:53','',''),(769,'1','313','1',1,'Retail Sale Id 794',4664.70,0.00,0.00,6.57,689.85,'2023-02-28 16:33:50','',''),(770,'1','313','1',1,'Retail Sale Id 795',67000.00,0.00,0.00,100.00,6500.00,'2023-02-28 16:36:25','',''),(771,'1','313','1',1,'Retail Sale Id 796',40200.00,0.00,0.00,60.00,3900.00,'2023-02-28 16:38:16','',''),(772,'1','313','1',1,'Retail Sale Id 797',4260.00,0.00,0.00,6.00,630.00,'2023-02-28 16:39:30','',''),(773,'1','313','1',1,'Retail Sale Id 798',8875.00,0.00,0.00,12.50,1312.50,'2023-02-28 16:42:13','',''),(774,'1','313','1',1,'Retail Sale Id 799',3550.00,0.00,0.00,5.00,525.00,'2023-02-28 16:44:09','',''),(775,'1','313','1',1,'Retail Sale Id 800',7000.60,0.00,0.00,9.86,1035.30,'2023-02-28 16:45:35','',''),(776,'1','313','1',1,'Retail Sale Id 801',32830.00,0.00,0.00,49.00,3185.00,'2023-02-28 16:46:48','',''),(777,'1','313','1',1,'Retail Sale Id 802',752.60,0.00,0.00,1.06,111.30,'2023-02-28 16:48:12','',''),(778,'1','313','1',1,'Retail Sale Id 803',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 16:52:18','',''),(779,'1','313','1',1,'Retail Sale Id 805',4260.00,0.00,0.00,6.00,630.00,'2023-02-28 16:59:26','',''),(780,'1','313','1',1,'Retail Sale Id 806',7000.60,0.00,0.00,9.86,1035.30,'2023-02-28 17:00:47','',''),(781,'1','313','1',1,'Retail Sale Id 807',3003.30,0.00,0.00,4.23,444.15,'2023-02-28 17:02:28','',''),(782,'1','313','1',1,'Retail Sale Id 808',2840.00,0.00,0.00,4.00,420.00,'2023-02-28 17:04:05','',''),(783,'1','313','1',1,'Retail Sale Id 809',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 17:05:08','',''),(784,'1','313','1',1,'Retail Sale Id 810',802.30,0.00,0.00,1.13,118.65,'2023-02-28 17:06:39','',''),(785,'1','313','1',1,'Retail Sale Id 811',2130.00,0.00,0.00,3.00,315.00,'2023-02-28 17:07:42','',''),(786,'1','313','1',1,'Retail Sale Id 812',4615.00,0.00,0.00,6.50,682.50,'2023-02-28 17:09:09','',''),(787,'1','313','1',1,'Retail Sale Id 813',80400.00,0.00,0.00,120.00,7800.00,'2023-02-28 17:11:35','',''),(788,'1','313','1',1,'Retail Sale Id 814',2130.00,0.00,0.00,3.00,315.00,'2023-02-28 17:13:12','',''),(789,'1','313','1',1,'Retail Sale Id 815',3550.00,0.00,0.00,5.00,525.00,'2023-02-28 17:14:28','',''),(790,'1','313','1',1,'Retail Sale Id 816',2840.00,0.00,0.00,4.00,420.00,'2023-02-28 17:18:42','',''),(791,'1','313','1',1,'Retail Sale Id 817',1420.00,0.00,0.00,2.00,210.00,'2023-02-28 17:19:35','',''),(792,'1','313','1',1,'Return of Retail Sale Id 814',0.00,2130.00,3.00,0.00,-315.00,'2023-02-28 17:21:03','',''),(793,'1','313','1',1,'Return of Retail Sale Id 800',0.00,7000.60,9.86,0.00,-1035.30,'2023-02-28 17:23:05','',''),(794,'1','313','1',1,'Retail Sale Id 818',802.30,0.00,0.00,1.13,118.65,'2023-02-28 17:24:21','',''),(795,'1','313','1',1,'Retail Sale Id 819',40434.50,0.00,0.00,60.35,3922.75,'2023-02-28 17:25:31','',''),(796,'1','313','1',1,'Retail Sale Id 820',11005.00,0.00,0.00,15.50,1627.50,'2023-02-28 17:27:29','',''),(797,'1','313','1',1,'Return of Retail Sale Id 790',0.00,4970.00,7.00,0.00,-735.00,'2023-02-28 17:29:19','',''),(798,'1','313','1',1,'Return of Retail Sale Id 785',0.00,7100.00,10.00,0.00,-1050.00,'2023-02-28 17:48:11','',''),(799,'1','313','1',1,'Retail Sale Id 821',6496.50,0.00,0.00,9.15,960.75,'2023-02-28 17:49:08','',''),(800,'1','313','1',1,'Return of Retail Sale Id 687',0.00,29500.10,44.03,0.00,-2861.95,'2023-02-28 17:52:01','',''),(801,'1','313','1',1,'Retail Sale Id 822',29339.30,0.00,0.00,43.79,2846.35,'2023-02-28 17:52:58','',''),(802,'1','313','1',1,'Retail Sale Id 823',710.00,0.00,0.00,1.00,105.00,'2023-03-01 08:23:28','',''),(803,'1','313','1',1,'Retail Sale Id 824',2840.00,0.00,0.00,4.00,420.00,'2023-03-01 08:23:56','',''),(804,'1','313','1',1,'Retail Sale Id 825',73700.00,0.00,0.00,110.00,7150.00,'2023-03-01 08:26:25','',''),(805,'1','313','1',1,'Retail Sale Id 826',40200.00,0.00,0.00,60.00,3900.00,'2023-03-01 08:28:20','',''),(806,'1','313','1',1,'Retail Sale Id 827',2840.00,0.00,0.00,4.00,420.00,'2023-03-01 08:29:53','',''),(807,'1','313','1',1,'Retail Sale Id 828',9301.00,0.00,0.00,13.10,1375.50,'2023-03-01 08:31:33','',''),(808,'1','313','1',1,'Retail Sale Id 829',1420.00,0.00,0.00,2.00,210.00,'2023-03-01 08:32:56','',''),(809,'1','313','1',1,'Retail Sale Id 830',3550.00,0.00,0.00,5.00,525.00,'2023-03-01 08:34:49','',''),(810,'1','313','1',1,'Retail Sale Id 831',11859.00,0.00,0.00,17.70,1150.50,'2023-03-01 08:36:24','',''),(811,'1','313','1',1,'Retail Sale Id 832',8875.00,0.00,0.00,12.50,1312.50,'2023-03-01 08:37:20','',''),(812,'1','313','1',1,'Retail Sale Id 833',3550.00,0.00,0.00,5.00,525.00,'2023-03-01 08:38:42','',''),(813,'1','313','1',1,'Retail Sale Id 834',4970.00,0.00,0.00,7.00,735.00,'2023-03-01 08:40:46','',''),(814,'1','313','1',1,'Retail Sale Id 835',752.60,0.00,0.00,1.06,111.30,'2023-03-01 08:42:14','',''),(815,'1','313','1',1,'Retail Sale Id 836',81994.60,0.00,0.00,122.38,7954.70,'2023-03-01 08:45:02','',''),(816,'1','313','1',1,'Retail Sale Id 837',40200.00,0.00,0.00,60.00,3900.00,'2023-03-01 08:45:47','',''),(817,'1','313','1',1,'Retail Sale Id 838',4260.00,0.00,0.00,6.00,630.00,'2023-03-01 08:46:27','',''),(818,'1','313','1',1,'Retail Sale Id 840',4970.00,0.00,0.00,7.00,735.00,'2023-03-01 08:48:47','',''),(819,'1','313','1',1,'Retail Sale Id 841',4970.00,0.00,0.00,7.00,735.00,'2023-03-01 08:49:18','',''),(820,'1','313','1',1,'Retail Sale Id 842',710.00,0.00,0.00,1.00,105.00,'2023-03-01 08:49:50','',''),(821,'1','313','1',1,'Retail Sale Id 843',8520.00,0.00,0.00,12.00,1260.00,'2023-03-01 08:51:15','',''),(822,'1','313','1',1,'Retail Sale Id 844',8520.00,0.00,0.00,12.00,1260.00,'2023-03-01 08:52:05','',''),(823,'1','313','1',1,'Retail Sale Id 845',710.00,0.00,0.00,1.00,105.00,'2023-03-01 08:52:54','',''),(824,'1','313','1',1,'Retail Sale Id 846',4998.40,0.00,0.00,7.04,739.20,'2023-03-01 08:53:30','',''),(825,'1','313','1',1,'Retail Sale Id 847',710.00,0.00,0.00,1.00,105.00,'2023-03-01 08:54:08','',''),(826,'1','313','1',1,'Retail Sale Id 848',710.00,0.00,0.00,1.00,105.00,'2023-03-01 08:54:56','',''),(827,'1','313','1',1,'Retail Sale Id 849',7810.00,0.00,0.00,11.00,1155.00,'2023-03-01 08:55:30','',''),(828,'1','313','1',1,'Retail Sale Id 850',710.00,0.00,0.00,1.00,105.00,'2023-03-01 08:56:18','',''),(829,'1','313','1',1,'Retail Sale Id 851',33500.00,0.00,0.00,50.00,3250.00,'2023-03-01 08:57:47','',''),(830,'1','313','1',1,'Retail Sale Id 852',2130.00,0.00,0.00,3.00,315.00,'2023-03-01 08:59:08','',''),(831,'1','313','1',1,'Retail Sale Id 853',8875.00,0.00,0.00,12.50,1312.50,'2023-03-01 08:59:56','',''),(832,'1','313','1',1,'Retail Sale Id 854',1498.10,0.00,0.00,2.11,221.55,'2023-03-01 09:01:24','',''),(833,'1','313','1',1,'Retail Sale Id 855',2130.00,0.00,0.00,3.00,315.00,'2023-03-01 09:02:43','',''),(834,'1','313','1',1,'Retail Sale Id 856',2151.30,0.00,0.00,3.03,318.15,'2023-03-01 09:04:36','',''),(835,'1','313','1',1,'Retail Sale Id 857',752.60,0.00,0.00,1.06,111.30,'2023-03-01 09:05:14','',''),(836,'1','313','1',1,'Retail Sale Id 858',2840.00,0.00,0.00,4.00,420.00,'2023-03-01 09:08:09','',''),(837,'1','313','1',1,'Retail Sale Id 859',2002.20,0.00,0.00,2.82,296.10,'2023-03-01 09:09:05','',''),(838,'1','313','1',1,'Retail Sale Id 860',4735.70,0.00,0.00,6.67,700.35,'2023-03-01 09:10:19','',''),(839,'1','313','1',1,'Retail Sale Id 861',3550.00,0.00,0.00,5.00,525.00,'2023-03-01 09:23:14','',''),(840,'1','313','1',1,'Retail Sale Id 862',8520.00,0.00,0.00,12.00,1260.00,'2023-03-01 09:24:29','',''),(841,'1','313','1',1,'Retail Sale Id 864',1498.10,0.00,0.00,2.11,221.55,'2023-03-01 09:26:21','',''),(842,'1','313','1',1,'Retail Sale Id 865',710.00,0.00,0.00,1.00,105.00,'2023-03-01 09:27:04','',''),(843,'1','313','1',1,'Retail Sale Id 866',40200.00,0.00,0.00,60.00,3900.00,'2023-03-01 09:30:52','',''),(844,'1','313','1',1,'Retail Sale Id 867',2840.00,0.00,0.00,4.00,420.00,'2023-03-01 09:31:53','',''),(845,'1','313','1',1,'Retail Sale Id 868',710.00,0.00,0.00,1.00,105.00,'2023-03-01 09:33:22','',''),(846,'1','313','1',1,'Retail Sale Id 869',1420.00,0.00,0.00,2.00,210.00,'2023-03-01 09:34:04','',''),(847,'1','313','1',1,'Retail Sale Id 870',2130.00,0.00,0.00,3.00,315.00,'2023-03-01 09:34:43','',''),(848,'1','313','1',1,'Retail Sale Id 871',2002.20,0.00,0.00,2.82,296.10,'2023-03-01 09:36:39','',''),(849,'1','313','1',1,'Retail Sale Id 872',4260.00,0.00,0.00,6.00,630.00,'2023-03-01 09:44:44','',''),(850,'1','313','1',1,'Retail Sale Id 873',3550.00,0.00,0.00,5.00,525.00,'2023-03-01 09:48:31','',''),(851,'1','313','1',1,'Retail Sale Id 874',3550.00,0.00,0.00,5.00,525.00,'2023-03-01 09:50:12','',''),(852,'1','313','1',1,'Retail Sale Id 875',2130.00,0.00,0.00,3.00,315.00,'2023-03-01 09:53:08','',''),(853,'1','313','1',1,'Retail Sale Id 877',4260.00,0.00,0.00,6.00,630.00,'2023-03-01 09:58:36','',''),(854,'1','313','1',1,'Retail Sale Id 878',8520.00,0.00,0.00,12.00,1260.00,'2023-03-01 09:59:25','',''),(855,'1','313','1',1,'Retail Sale Id 879',3550.00,0.00,0.00,5.00,525.00,'2023-03-01 10:02:27','',''),(856,'1','313','1',1,'Retail Sale Id 880',1420.00,0.00,0.00,2.00,210.00,'2023-03-01 10:03:47','',''),(857,'1','313','1',1,'Retail Sale Id 881',3550.00,0.00,0.00,5.00,525.00,'2023-03-01 10:05:29','',''),(858,'1','313','1',1,'Retail Sale Id 882',40200.00,0.00,0.00,60.00,3900.00,'2023-03-01 10:09:25','',''),(859,'1','313','1',1,'Retail Sale Id 885',4260.00,0.00,0.00,6.00,630.00,'2023-03-01 10:22:56','',''),(860,'1','313','1',1,'Retail Sale Id 886',1001.10,0.00,0.00,1.41,148.05,'2023-03-01 10:31:11','',''),(861,'1','313','1',1,'Retail Sale Id 887',3550.00,0.00,0.00,5.00,525.00,'2023-03-01 10:37:20','',''),(862,'1','313','1',1,'Retail Sale Id 888',3003.30,0.00,0.00,4.23,444.15,'2023-03-01 10:38:32','',''),(863,'1','313','1',1,'Retail Sale Id 889',1448.40,0.00,0.00,2.04,214.20,'2023-03-01 10:40:46','',''),(864,'1','313','1',1,'Retail Sale Id 890',2130.00,0.00,0.00,3.00,315.00,'2023-03-01 10:44:18','',''),(865,'1','313','1',1,'Retail Sale Id 891',2130.00,0.00,0.00,3.00,315.00,'2023-03-01 10:45:49','',''),(866,'1','313','1',1,'Retail Sale Id 892',100500.00,0.00,0.00,150.00,9750.00,'2023-03-01 10:54:42','',''),(867,'1','313','1',1,'Retail Sale Id 893',1420.00,0.00,0.00,2.00,210.00,'2023-03-01 10:57:16','',''),(868,'1','313','1',1,'Retail Sale Id 894',4970.00,0.00,0.00,7.00,735.00,'2023-03-01 11:06:16','',''),(869,'1','313','1',1,'Retail Sale Id 896',2499.20,0.00,0.00,3.52,369.60,'2023-03-01 11:13:22','',''),(870,'1','313','1',1,'Retail Sale Id 897',2130.00,0.00,0.00,3.00,315.00,'2023-03-01 11:21:01','',''),(871,'1','313','1',1,'Retail Sale Id 898',1448.40,0.00,0.00,2.04,214.20,'2023-03-01 11:22:22','',''),(872,'1','313','1',1,'Retail Sale Id 899',3550.00,0.00,0.00,5.00,525.00,'2023-03-01 11:24:23','',''),(873,'1','313','1',1,'Retail Sale Id 900',4970.00,0.00,0.00,7.00,735.00,'2023-03-01 11:25:22','',''),(874,'1','313','1',1,'Retail Sale Id 901',4970.00,0.00,0.00,7.00,735.00,'2023-03-01 11:27:23','',''),(875,'1','313','1',1,'Retail Sale Id 902',7810.00,0.00,0.00,11.00,1155.00,'2023-03-01 11:28:18','',''),(876,'1','313','1',1,'Retail Sale Id 903',2797.40,0.00,0.00,3.94,413.70,'2023-03-01 11:29:46','',''),(877,'1','313','1',1,'Retail Sale Id 904',33500.00,0.00,0.00,50.00,3250.00,'2023-03-01 11:31:46','',''),(878,'1','313','1',1,'Retail Sale Id 905',4970.00,0.00,0.00,7.00,735.00,'2023-03-01 11:36:38','',''),(879,'1','313','1',1,'Retail Sale Id 906',4970.00,0.00,0.00,7.00,735.00,'2023-03-01 11:38:54','',''),(880,'1','313','1',1,'Retail Sale Id 908',1448.40,0.00,0.00,2.04,214.20,'2023-03-01 11:50:16','',''),(881,'1','313','1',1,'Retail Sale Id 909',1448.40,0.00,0.00,2.04,214.20,'2023-03-01 11:51:20','',''),(882,'1','313','1',1,'Retail Sale Id 910',1001.10,0.00,0.00,1.41,148.05,'2023-03-01 11:56:22','',''),(883,'1','313','1',1,'Retail Sale Id 911',7000.60,0.00,0.00,9.86,1035.30,'2023-03-01 11:57:54','',''),(884,'1','313','1',1,'Retail Sale Id 912',1199.90,0.00,0.00,1.69,177.45,'2023-03-01 12:01:20','',''),(885,'1','313','1',1,'Retail Sale Id 913',119193.00,0.00,0.00,177.90,11563.50,'2023-03-01 12:16:20','',''),(886,'1','313','1',1,'Retail Sale Id 914',2840.00,0.00,0.00,4.00,420.00,'2023-03-01 12:19:36','',''),(887,'1','313','1',1,'Retail Sale Id 915',7100.00,0.00,0.00,10.00,1050.00,'2023-03-01 12:27:42','',''),(888,'1','313','1',1,'Retail Sale Id 916',4260.00,0.00,0.00,6.00,630.00,'2023-03-01 12:29:12','',''),(889,'1','313','1',1,'Retail Sale Id 917',4260.00,0.00,0.00,6.00,630.00,'2023-03-01 12:35:56','',''),(890,'1','313','1',1,'Retail Sale Id 918',752.60,0.00,0.00,1.06,111.30,'2023-03-01 12:46:16','',''),(891,'1','313','1',1,'Retail Sale Id 919',8875.00,0.00,0.00,12.50,1312.50,'2023-03-01 12:47:15','',''),(892,'1','313','1',1,'Retail Sale Id 920',752.60,0.00,0.00,1.06,111.30,'2023-03-01 12:52:23','',''),(893,'1','313','1',1,'Retail Sale Id 922',2130.00,0.00,0.00,3.00,315.00,'2023-03-01 13:06:00','',''),(894,'1','313','1',1,'Retail Sale Id 923',1001.10,0.00,0.00,1.41,148.05,'2023-03-01 13:08:02','',''),(895,'1','313','1',1,'Retail Sale Id 924',2840.00,0.00,0.00,4.00,420.00,'2023-03-01 13:09:20','',''),(896,'1','313','1',1,'Retail Sale Id 925',7999.80,0.00,0.00,11.94,776.10,'2023-03-01 13:15:06','',''),(897,'1','313','1',1,'Retail Sale Id 926',2847.10,0.00,0.00,4.01,421.05,'2023-03-01 13:16:15','',''),(898,'1','313','1',1,'Retail Sale Id 927',752.60,0.00,0.00,1.06,111.30,'2023-03-01 13:32:08','',''),(899,'1','313','1',1,'Retail Sale Id 928',1420.00,0.00,0.00,2.00,210.00,'2023-03-01 13:34:20','',''),(900,'1','313','1',1,'Retail Sale Id 929',40454.60,0.00,0.00,60.38,3924.70,'2023-03-01 13:48:56','',''),(901,'1','313','1',1,'Retail Sale Id 930',2130.00,0.00,0.00,3.00,315.00,'2023-03-01 13:57:09','',''),(902,'1','313','1',1,'Retail Sale Id 931',2485.00,0.00,0.00,3.50,367.50,'2023-03-01 14:01:05','',''),(903,'1','313','1',1,'Retail Sale Id 932',2130.00,0.00,0.00,3.00,315.00,'2023-03-01 14:04:03','',''),(904,'1','313','1',1,'Retail Sale Id 933',752.60,0.00,0.00,1.06,111.30,'2023-03-01 14:05:46','',''),(905,'1','313','1',1,'Retail Sale Id 934',2840.00,0.00,0.00,4.00,420.00,'2023-03-01 14:14:44','',''),(906,'1','313','1',1,'Retail Sale Id 935',2840.00,0.00,0.00,4.00,420.00,'2023-03-01 14:15:33','',''),(907,'1','313','1',1,'Retail Sale Id 936',4260.00,0.00,0.00,6.00,630.00,'2023-03-01 14:20:57','',''),(908,'1','313','1',1,'Retail Sale Id 937',3003.30,0.00,0.00,4.23,444.15,'2023-03-01 14:22:40','',''),(909,'1','313','1',1,'Retail Sale Id 938',1001.10,0.00,0.00,1.41,148.05,'2023-03-01 14:23:38','',''),(910,'1','313','1',1,'Retail Sale Id 941',12780.00,0.00,0.00,18.00,1890.00,'2023-03-01 14:50:00','',''),(911,'1','313','1',1,'Retail Sale Id 942',1420.00,0.00,0.00,2.00,210.00,'2023-03-01 14:50:54','',''),(912,'1','313','1',1,'Retail Sale Id 943',752.60,0.00,0.00,1.06,111.30,'2023-03-01 14:51:48','',''),(913,'1','313','1',1,'Retail Sale Id 944',2130.00,0.00,0.00,3.00,315.00,'2023-03-01 14:53:40','',''),(914,'1','313','1',1,'Retail Sale Id 945',7100.00,0.00,0.00,10.00,1050.00,'2023-03-01 14:58:25','',''),(915,'1','313','1',1,'Retail Sale Id 946',2130.00,0.00,0.00,3.00,315.00,'2023-03-01 14:59:49','',''),(916,'1','313','1',1,'Retail Sale Id 947',4970.00,0.00,0.00,7.00,735.00,'2023-03-01 15:06:47','',''),(917,'1','313','1',1,'Retail Sale Id 940',33500.00,0.00,0.00,50.00,3250.00,'2023-03-01 15:07:33','',''),(918,'1','313','1',1,'Retail Sale Id 948',8875.00,0.00,0.00,12.50,1312.50,'2023-03-01 15:08:17','',''),(919,'1','313','1',1,'Retail Sale Id 949',2840.00,0.00,0.00,4.00,420.00,'2023-03-01 15:08:58','',''),(920,'1','313','1',1,'Retail Sale Id 950',4260.00,0.00,0.00,6.00,630.00,'2023-03-01 15:10:55','',''),(921,'1','313','1',1,'Retail Sale Id 951',2130.00,0.00,0.00,3.00,315.00,'2023-03-01 15:15:33','',''),(922,'1','313','1',1,'Retail Sale Id 952',2840.00,0.00,0.00,4.00,420.00,'2023-03-01 15:19:22','',''),(923,'1','313','1',1,'Retail Sale Id 953',710.00,0.00,0.00,1.00,105.00,'2023-03-01 15:20:46','',''),(924,'1','313','1',1,'Retail Sale Id 954',3550.00,0.00,0.00,5.00,525.00,'2023-03-01 15:34:16','',''),(925,'1','313','1',1,'Retail Sale Id 955',2130.00,0.00,0.00,3.00,315.00,'2023-03-01 15:39:39','',''),(926,'1','313','1',1,'Retail Sale Id 956',4402.00,0.00,0.00,6.20,651.00,'2023-03-01 15:43:00','',''),(927,'1','313','1',1,'Retail Sale Id 957',8875.00,0.00,0.00,12.50,1312.50,'2023-03-01 15:44:35','',''),(928,'1','313','1',1,'Retail Sale Id 958',1420.00,0.00,0.00,2.00,210.00,'2023-03-01 15:45:36','',''),(929,'1','313','1',1,'Retail Sale Id 960',1420.00,0.00,0.00,2.00,210.00,'2023-03-01 15:52:58','',''),(930,'1','313','1',1,'Retail Sale Id 961',1420.00,0.00,0.00,2.00,210.00,'2023-03-01 15:55:42','',''),(931,'1','313','1',1,'Retail Sale Id 963',1448.40,0.00,0.00,2.04,214.20,'2023-03-01 15:57:51','',''),(932,'1','313','1',1,'Retail Sale Id 964',8875.00,0.00,0.00,12.50,1312.50,'2023-03-01 16:07:07','',''),(933,'1','313','1',1,'Retail Sale Id 965',710.00,0.00,0.00,1.00,105.00,'2023-03-01 16:10:25','',''),(934,'1','313','1',1,'Retail Sale Id 966',752.60,0.00,0.00,1.06,111.30,'2023-03-01 16:11:40','',''),(935,'1','313','1',1,'Retail Sale Id 967',3003.30,0.00,0.00,4.23,444.15,'2023-03-01 16:13:40','',''),(936,'1','313','1',1,'Retail Sale Id 968',1001.10,0.00,0.00,1.41,148.05,'2023-03-01 16:20:43','',''),(937,'1','313','1',1,'Retail Sale Id 969',1448.40,0.00,0.00,2.04,214.20,'2023-03-01 16:24:03','',''),(938,'1','313','1',1,'Retail Sale Id 970',2101.60,0.00,0.00,2.96,310.80,'2023-03-01 16:31:34','',''),(939,'1','313','1',1,'Retail Sale Id 972',2840.00,0.00,0.00,4.00,420.00,'2023-03-01 16:43:14','',''),(940,'1','313','1',1,'Retail Sale Id 973',4260.00,0.00,0.00,6.00,630.00,'2023-03-01 16:44:46','',''),(941,'1','313','1',1,'Retail Sale Id 974',2840.00,0.00,0.00,4.00,420.00,'2023-03-01 16:47:40','',''),(942,'1','313','1',1,'Retail Sale Id 976',1001.10,0.00,0.00,1.41,148.05,'2023-03-01 16:48:55','',''),(943,'1','313','1',1,'Retail Sale Id 977',2002.20,0.00,0.00,2.82,296.10,'2023-03-01 16:51:09','',''),(944,'1','313','1',1,'Retail Sale Id 978',2002.20,0.00,0.00,2.82,296.10,'2023-03-01 16:57:19','',''),(945,'1','313','1',1,'Retail Sale Id 979',4970.00,0.00,0.00,7.00,735.00,'2023-03-01 16:59:05','',''),(946,'1','313','1',1,'Retail Sale Id 980',8875.00,0.00,0.00,12.50,1312.50,'2023-03-01 17:00:48','',''),(947,'1','313','1',1,'Retail Sale Id 981',3550.00,0.00,0.00,5.00,525.00,'2023-03-01 17:02:14','',''),(948,'1','313','1',1,'Retail Sale Id 982',8520.00,0.00,0.00,12.00,1260.00,'2023-03-01 17:03:43','',''),(949,'1','313','1',1,'Retail Sale Id 983',1420.00,0.00,0.00,2.00,210.00,'2023-03-01 17:05:57','',''),(950,'1','313','1',1,'Retail Sale Id 984',8875.00,0.00,0.00,12.50,1312.50,'2023-03-01 17:06:49','',''),(951,'1','313','1',1,'Retail Sale Id 985',710.00,0.00,0.00,1.00,105.00,'2023-03-01 17:08:37','',''),(952,'1','313','1',1,'Retail Sale Id 986',1420.00,0.00,0.00,2.00,210.00,'2023-03-01 17:10:50','',''),(953,'1','313','1',1,'Retail Sale Id 987',2840.00,0.00,0.00,4.00,420.00,'2023-03-01 17:13:51','',''),(954,'1','313','1',1,'Retail Sale Id 988',1448.40,0.00,0.00,2.04,214.20,'2023-03-01 17:14:49','',''),(955,'1','313','1',1,'Retail Sale Id 989',100500.00,0.00,0.00,150.00,9750.00,'2023-03-01 17:21:35','',''),(956,'1','313','1',1,'Return of Retail Sale Id 969',0.00,1448.40,2.04,0.00,-214.20,'2023-03-01 17:43:25','',''),(957,'1','313','1',1,'Retail Sale Id 990',1050.80,0.00,0.00,1.48,155.40,'2023-03-01 17:44:15','',''),(958,'1','313','1',1,'Return of Retail Sale Id 925',0.00,7999.80,11.94,0.00,-776.10,'2023-03-01 17:51:56','',''),(959,'1','313','1',1,'Retail Sale Id 991',7658.10,0.00,0.00,11.43,742.95,'2023-03-01 17:53:01','',''),(960,'1','313','1',1,'Retail Sale Id 993',33500.00,0.00,0.00,50.00,3250.00,'2023-03-02 08:09:49','',''),(961,'1','313','1',1,'Retail Sale Id 994',752.60,0.00,0.00,1.06,111.30,'2023-03-02 08:10:34','',''),(962,'1','313','1',1,'Retail Sale Id 995',2201.00,0.00,0.00,3.10,325.50,'2023-03-02 08:11:31','',''),(963,'1','313','1',1,'Retail Sale Id 996',8875.00,0.00,0.00,12.50,1312.50,'2023-03-02 08:12:28','',''),(964,'1','313','1',1,'Retail Sale Id 997',2840.00,0.00,0.00,4.00,420.00,'2023-03-02 08:13:31','',''),(965,'1','313','1',1,'Retail Sale Id 998',1001.10,0.00,0.00,1.41,148.05,'2023-03-02 08:14:13','',''),(966,'1','313','1',1,'Retail Sale Id 999',1498.10,0.00,0.00,2.11,221.55,'2023-03-02 08:15:15','',''),(967,'1','313','1',1,'Retail Sale Id 1000',36850.00,0.00,0.00,55.00,3575.00,'2023-03-02 08:16:18','',''),(968,'1','313','1',1,'Retail Sale Id 1001',2130.00,0.00,0.00,3.00,315.00,'2023-03-02 08:17:31','',''),(969,'1','313','1',1,'Retail Sale Id 1002',2130.00,0.00,0.00,3.00,315.00,'2023-03-02 08:19:25','',''),(970,'1','313','1',1,'Retail Sale Id 1003',2513.40,0.00,0.00,3.54,371.70,'2023-03-02 08:21:15','',''),(971,'1','313','1',1,'Retail Sale Id 1004',1498.10,0.00,0.00,2.11,221.55,'2023-03-02 08:23:26','',''),(972,'1','313','1',1,'Retail Sale Id 1005',41298.80,0.00,0.00,61.64,4006.60,'2023-03-02 08:24:55','',''),(973,'1','313','1',1,'Retail Sale Id 1006',1398.70,0.00,0.00,1.97,206.85,'2023-03-02 08:26:17','',''),(974,'1','313','1',1,'Retail Sale Id 1007',1420.00,0.00,0.00,2.00,210.00,'2023-03-02 08:27:56','',''),(975,'1','313','1',1,'Retail Sale Id 1008',1420.00,0.00,0.00,2.00,210.00,'2023-03-02 08:29:00','',''),(976,'1','313','1',1,'Retail Sale Id 1009',1420.00,0.00,0.00,2.00,210.00,'2023-03-02 08:30:15','',''),(977,'1','313','1',1,'Retail Sale Id 1010',1498.10,0.00,0.00,2.11,221.55,'2023-03-02 08:31:15','',''),(978,'1','313','1',1,'Retail Sale Id 1011',2840.00,0.00,0.00,4.00,420.00,'2023-03-02 08:32:10','',''),(979,'1','313','1',1,'Retail Sale Id 1012',3003.30,0.00,0.00,4.23,444.15,'2023-03-02 08:33:06','',''),(980,'1','313','1',1,'Retail Sale Id 1013',7100.00,0.00,0.00,10.00,1050.00,'2023-03-02 08:34:15','',''),(981,'1','313','1',1,'Retail Sale Id 1014',710.00,0.00,0.00,1.00,105.00,'2023-03-02 08:35:39','',''),(982,'1','313','1',1,'Retail Sale Id 1015',3550.00,0.00,0.00,5.00,525.00,'2023-03-02 08:36:29','',''),(983,'1','313','1',1,'Retail Sale Id 1016',1498.10,0.00,0.00,2.11,221.55,'2023-03-02 08:37:55','',''),(984,'1','313','1',1,'Retail Sale Id 1017',8875.00,0.00,0.00,12.50,1312.50,'2023-03-02 08:38:49','',''),(985,'1','313','1',1,'Retail Sale Id 1018',8520.00,0.00,0.00,12.00,1260.00,'2023-03-02 08:40:31','',''),(986,'1','313','1',1,'Retail Sale Id 1019',2840.00,0.00,0.00,4.00,420.00,'2023-03-02 08:41:23','',''),(987,'1','313','1',1,'Retail Sale Id 1020',4970.00,0.00,0.00,7.00,735.00,'2023-03-02 08:42:36','',''),(988,'1','313','1',1,'Retail Sale Id 1021',40200.00,0.00,0.00,60.00,3900.00,'2023-03-02 08:43:47','',''),(989,'1','313','1',1,'Retail Sale Id 1022',2002.20,0.00,0.00,2.82,296.10,'2023-03-02 08:47:15','',''),(990,'1','313','1',1,'Retail Sale Id 1023',3003.30,0.00,0.00,4.23,444.15,'2023-03-02 08:57:54','',''),(991,'1','313','1',1,'Retail Sale Id 1024',7810.00,0.00,0.00,11.00,1155.00,'2023-03-02 09:00:09','',''),(992,'1','313','1',1,'Retail Sale Id 1025',2840.00,0.00,0.00,4.00,420.00,'2023-03-02 09:08:59','',''),(993,'1','313','1',1,'Retail Sale Id 1026',4260.00,0.00,0.00,6.00,630.00,'2023-03-02 09:09:51','',''),(994,'1','313','1',1,'Retail Sale Id 1027',2151.30,0.00,0.00,3.03,318.15,'2023-03-02 09:17:48','',''),(995,'1','313','1',1,'Retail Sale Id 1028',8875.00,0.00,0.00,12.50,1312.50,'2023-03-02 09:20:34','',''),(996,'1','313','1',1,'Retail Sale Id 1030',1100.50,0.00,0.00,1.55,162.75,'2023-03-02 09:25:02','',''),(997,'1','313','1',1,'Retail Sale Id 1031',2840.00,0.00,0.00,4.00,420.00,'2023-03-02 09:26:43','',''),(998,'1','313','1',1,'Retail Sale Id 1032',8520.00,0.00,0.00,12.00,1260.00,'2023-03-02 09:28:16','',''),(999,'1','313','1',1,'Retail Sale Id 1033',1420.00,0.00,0.00,2.00,210.00,'2023-03-02 09:28:57','',''),(1000,'1','313','1',1,'Retail Sale Id 1034',710.00,0.00,0.00,1.00,105.00,'2023-03-02 09:29:58','',''),(1001,'1','313','1',1,'Retail Sale Id 1035',2002.20,0.00,0.00,2.82,296.10,'2023-03-02 09:33:36','',''),(1002,'1','313','1',1,'Retail Sale Id 1036',710.00,0.00,0.00,1.00,105.00,'2023-03-02 09:35:32','',''),(1003,'1','313','1',1,'Retail Sale Id 1037',1420.00,0.00,0.00,2.00,210.00,'2023-03-02 09:36:53','',''),(1004,'1','313','1',1,'Retail Sale Id 1039',7100.00,0.00,0.00,10.00,1050.00,'2023-03-02 09:39:50','',''),(1005,'1','313','1',1,'Retail Sale Id 1040',33500.00,0.00,0.00,50.00,3250.00,'2023-03-02 09:41:53','',''),(1006,'1','313','1',1,'Retail Sale Id 1041',2130.00,0.00,0.00,3.00,315.00,'2023-03-02 09:47:51','',''),(1007,'1','313','1',1,'Retail Sale Id 1042',3550.00,0.00,0.00,5.00,525.00,'2023-03-02 09:51:25','',''),(1008,'1','313','1',1,'Retail Sale Id 1043',3550.00,0.00,0.00,5.00,525.00,'2023-03-02 09:52:16','',''),(1009,'1','313','1',1,'Retail Sale Id 1044',752.60,0.00,0.00,1.06,111.30,'2023-03-02 09:53:46','',''),(1010,'1','313','1',1,'Retail Sale Id 1045',53250.00,0.00,0.00,75.00,7875.00,'2023-03-02 09:56:41','',''),(1011,'1','313','1',1,'Retail Sale Id 1046',3550.00,0.00,0.00,5.00,525.00,'2023-03-02 09:59:00','',''),(1012,'1','313','1',1,'Retail Sale Id 1047',2130.00,0.00,0.00,3.00,315.00,'2023-03-02 10:01:22','',''),(1013,'1','313','1',1,'Retail Sale Id 1048',8875.00,0.00,0.00,12.50,1312.50,'2023-03-02 10:06:58','',''),(1014,'1','313','1',1,'Retail Sale Id 1049',901.70,0.00,0.00,1.27,133.35,'2023-03-02 10:10:25','',''),(1015,'1','313','1',1,'Retail Sale Id 1050',4970.00,0.00,0.00,7.00,735.00,'2023-03-02 10:18:49','',''),(1016,'1','313','1',1,'Retail Sale Id 1051',2151.30,0.00,0.00,3.03,318.15,'2023-03-02 10:21:01','',''),(1017,'1','313','1',1,'Retail Sale Id 1053',4260.00,0.00,0.00,6.00,630.00,'2023-03-02 10:22:51','',''),(1018,'1','313','1',1,'Retail Sale Id 1054',4970.00,0.00,0.00,7.00,735.00,'2023-03-02 10:23:43','',''),(1019,'1','313','1',1,'Retail Sale Id 1055',4260.00,0.00,0.00,6.00,630.00,'2023-03-02 10:26:15','',''),(1020,'1','313','1',1,'Retail Sale Id 1056',2130.00,0.00,0.00,3.00,315.00,'2023-03-02 10:29:20','',''),(1021,'1','313','1',1,'Retail Sale Id 1057',5680.00,0.00,0.00,8.00,840.00,'2023-03-02 10:35:52','',''),(1022,'1','313','1',1,'Retail Sale Id 1058',2130.00,0.00,0.00,3.00,315.00,'2023-03-02 10:38:04','',''),(1023,'1','313','1',1,'Retail Sale Id 1059',8875.00,0.00,0.00,12.50,1312.50,'2023-03-02 10:40:28','',''),(1024,'1','313','1',1,'Return of Retail Sale Id 1045',0.00,53250.00,75.00,0.00,-7875.00,'2023-03-02 10:51:06','',''),(1025,'1','313','1',1,'Retail Sale Id 1060',50250.00,0.00,0.00,75.00,4875.00,'2023-03-02 10:52:00','',''),(1026,'1','313','1',1,'Retail Sale Id 1061',33500.00,0.00,0.00,50.00,3250.00,'2023-03-02 10:56:58','',''),(1027,'1','313','1',1,'Retail Sale Id 1062',2130.00,0.00,0.00,3.00,315.00,'2023-03-02 10:58:01','',''),(1028,'1','313','1',1,'Retail Sale Id 1063',2151.30,0.00,0.00,3.03,318.15,'2023-03-02 11:07:41','',''),(1029,'1','313','1',1,'Retail Sale Id 1064',2151.30,0.00,0.00,3.03,318.15,'2023-03-02 11:08:30','',''),(1030,'1','313','1',1,'Retail Sale Id 1065',7100.00,0.00,0.00,10.00,1050.00,'2023-03-02 11:15:50','',''),(1031,'1','313','1',1,'Retail Sale Id 1066',7100.00,0.00,0.00,10.00,1050.00,'2023-03-02 11:17:03','',''),(1032,'1','313','1',1,'Retail Sale Id 1067',7100.00,0.00,0.00,10.00,1050.00,'2023-03-02 11:22:17','',''),(1033,'1','313','1',1,'Retail Sale Id 1068',33500.00,0.00,0.00,50.00,3250.00,'2023-03-02 11:24:37','',''),(1034,'1','313','1',1,'Retail Sale Id 1069',1420.00,0.00,0.00,2.00,210.00,'2023-03-02 11:26:36','',''),(1035,'1','313','1',1,'Retail Sale Id 1070',4970.00,0.00,0.00,7.00,735.00,'2023-03-02 11:30:39','',''),(1036,'1','313','1',1,'Retail Sale Id 1071',1498.10,0.00,0.00,2.11,221.55,'2023-03-02 11:33:39','',''),(1037,'1','313','1',1,'Retail Sale Id 1072',752.60,0.00,0.00,1.06,111.30,'2023-03-02 11:42:22','',''),(1038,'1','313','1',1,'Retail Sale Id 1073',710.00,0.00,0.00,1.00,105.00,'2023-03-02 11:43:24','',''),(1039,'1','313','1',1,'Retail Sale Id 1075',752.60,0.00,0.00,1.06,111.30,'2023-03-02 11:52:20','',''),(1040,'1','313','1',1,'Retail Sale Id 1076',710.00,0.00,0.00,1.00,105.00,'2023-03-02 11:56:26','',''),(1041,'1','313','1',1,'Retail Sale Id 1078',710.00,0.00,0.00,1.00,105.00,'2023-03-02 12:00:11','',''),(1042,'1','313','1',1,'Retail Sale Id 1079',4260.00,0.00,0.00,6.00,630.00,'2023-03-02 12:02:42','',''),(1043,'1','313','1',1,'Retail Sale Id 1080',4970.00,0.00,0.00,7.00,735.00,'2023-03-02 12:07:25','',''),(1044,'1','313','1',1,'Retail Sale Id 1081',6390.00,0.00,0.00,9.00,945.00,'2023-03-02 12:09:24','',''),(1045,'1','313','1',1,'Retail Sale Id 1083',4302.60,0.00,0.00,6.06,636.30,'2023-03-02 12:18:49','',''),(1046,'1','313','1',1,'Retail Sale Id 1084',7100.00,0.00,0.00,10.00,1050.00,'2023-03-02 12:20:37','',''),(1047,'1','313','1',1,'Retail Sale Id 1085',17040.00,0.00,0.00,24.00,2520.00,'2023-03-02 12:23:30','',''),(1048,'1','313','1',1,'Retail Sale Id 1087',87528.80,0.00,0.00,123.28,12944.40,'2023-03-02 18:16:49','',''),(1049,'1','313','1',1,'Retail Sale Id 1088',193194.50,0.00,0.00,288.35,18742.75,'2023-03-02 18:17:35','',''),(1050,'1','313','1',1,'Retail Sale Id 1089',67000.00,0.00,0.00,100.00,6500.00,'2023-03-02 18:18:32','',''),(1051,'1','313','1',1,'Return of Retail Sale Id 1088',0.00,193194.50,288.35,0.00,-18742.75,'2023-03-02 18:24:42','',''),(1052,'1','313','1',1,'Retail Sale Id 1090',82597.60,0.00,0.00,123.28,8013.20,'2023-03-02 18:27:45','',''),(1053,'1','313','1',1,'Return of Retail Sale Id 1087',0.00,87528.80,123.28,0.00,-12944.40,'2023-03-02 18:28:35','',''),(1054,'1','313','1',1,'Retail Sale Id 1091',204728.50,0.00,0.00,288.35,30276.75,'2023-03-02 18:29:29','',''),(1055,'1','313','1',1,'Retail Sale Id 1092',4593.70,0.00,0.00,6.47,679.35,'2023-03-02 18:34:27','',''),(1056,'1','313','1',1,'Return of Retail Sale Id 1005',0.00,41298.80,61.64,0.00,-4006.60,'2023-03-02 18:36:02','',''),(1057,'1','313','1',1,'Retail Sale Id 1093',41205.00,0.00,0.00,61.50,3997.50,'2023-03-02 18:37:15','',''),(1058,'1','313','1',1,'Retail Sale Id 1094',229950.70,0.00,0.00,343.21,22308.65,'2023-03-03 10:34:48','',''),(1059,'1','313','1',1,'Retail Sale Id 1095',3550.00,0.00,0.00,5.00,525.00,'2023-03-03 10:37:46','',''),(1060,'1','313','1',1,'Retail Sale Id 1096',1420.00,0.00,0.00,2.00,210.00,'2023-03-03 10:40:32','',''),(1061,'1','313','1',1,'Retail Sale Id 1097',1420.00,0.00,0.00,2.00,210.00,'2023-03-03 10:45:39','',''),(1062,'1','313','1',1,'Retail Sale Id 1098',752.60,0.00,0.00,1.06,111.30,'2023-03-03 10:49:37','',''),(1063,'1','313','1',1,'Retail Sale Id 1099',4260.00,0.00,0.00,6.00,630.00,'2023-03-03 10:50:54','',''),(1064,'1','313','1',1,'Retail Sale Id 1100',4260.00,0.00,0.00,6.00,630.00,'2023-03-03 10:52:34','',''),(1065,'1','313','1',1,'Retail Sale Id 1101',197848.60,0.00,0.00,278.66,29259.30,'2023-03-03 10:54:13','',''),(1066,'1','313','1',1,'Retail Sale Id 1102',2130.00,0.00,0.00,3.00,315.00,'2023-03-03 10:55:30','',''),(1067,'1','313','1',1,'Retail Sale Id 1103',710.00,0.00,0.00,1.00,105.00,'2023-03-03 10:59:55','',''),(1068,'1','313','1',1,'Retail Sale Id 1104',1775.00,0.00,0.00,2.50,262.50,'2023-03-03 11:04:15','',''),(1069,'1','313','1',1,'Retail Sale Id 1105',40200.00,0.00,0.00,60.00,3900.00,'2023-03-03 11:14:09','',''),(1070,'1','313','1',1,'Retail Sale Id 1106',4501.40,0.00,0.00,6.34,665.70,'2023-03-03 11:19:18','',''),(1071,'1','313','1',1,'Retail Sale Id 1107',1001.10,0.00,0.00,1.41,148.05,'2023-03-03 11:30:55','',''),(1072,'1','313','1',1,'Retail Sale Id 1108',40200.00,0.00,0.00,60.00,3900.00,'2023-03-03 11:33:37','',''),(1073,'1','313','1',1,'Retail Sale Id 1109',4998.40,0.00,0.00,7.04,739.20,'2023-03-03 11:34:50','',''),(1074,'1','313','1',1,'Retail Sale Id 1110',4970.00,0.00,0.00,7.00,735.00,'2023-03-03 11:35:45','',''),(1075,'1','313','1',1,'Retail Sale Id 1111',33500.00,0.00,0.00,50.00,3250.00,'2023-03-03 11:36:58','',''),(1076,'1','313','1',1,'Retail Sale Id 1112',1001.10,0.00,0.00,1.41,148.05,'2023-03-03 11:37:54','',''),(1077,'1','313','1',1,'Retail Sale Id 1113',1498.10,0.00,0.00,2.11,221.55,'2023-03-03 11:39:55','',''),(1078,'1','313','1',1,'Retail Sale Id 1114',3550.00,0.00,0.00,5.00,525.00,'2023-03-03 11:42:58','',''),(1079,'1','313','1',1,'Retail Sale Id 1115',3550.00,0.00,0.00,5.00,525.00,'2023-03-03 11:44:30','',''),(1080,'1','313','1',1,'Retail Sale Id 1116',4260.00,0.00,0.00,6.00,630.00,'2023-03-03 11:45:24','',''),(1081,'1','313','1',1,'Retail Sale Id 1117',4260.00,0.00,0.00,6.00,630.00,'2023-03-03 11:46:27','',''),(1082,'1','313','1',1,'Retail Sale Id 1118',3003.30,0.00,0.00,4.23,444.15,'2023-03-03 11:54:17','',''),(1083,'1','313','1',1,'Retail Sale Id 1119',8875.00,0.00,0.00,12.50,1312.50,'2023-03-03 11:55:54','',''),(1084,'1','313','1',1,'Retail Sale Id 1120',2840.00,0.00,0.00,4.00,420.00,'2023-03-03 11:56:43','',''),(1085,'1','313','1',1,'Retail Sale Id 1121',1420.00,0.00,0.00,2.00,210.00,'2023-03-03 12:03:25','',''),(1086,'1','313','1',1,'Retail Sale Id 1122',1420.00,0.00,0.00,2.00,210.00,'2023-03-03 12:08:46','',''),(1087,'1','313','1',1,'Retail Sale Id 1123',3550.00,0.00,0.00,5.00,525.00,'2023-03-03 12:11:45','',''),(1088,'1','313','1',1,'Retail Sale Id 1124',3550.00,0.00,0.00,5.00,525.00,'2023-03-03 12:25:23','',''),(1089,'1','313','1',1,'Retail Sale Id 1125',4260.00,0.00,0.00,6.00,630.00,'2023-03-03 12:26:52','',''),(1090,'1','313','1',1,'Retail Sale Id 1126',8001.70,0.00,0.00,11.27,1183.35,'2023-03-03 12:28:34','',''),(1091,'1','313','1',1,'Retail Sale Id 1127',8875.00,0.00,0.00,12.50,1312.50,'2023-03-03 12:31:45','',''),(1092,'1','313','1',1,'Retail Sale Id 1129',1420.00,0.00,0.00,2.00,210.00,'2023-03-03 12:45:00','',''),(1093,'1','313','1',1,'Retail Sale Id 1130',4260.00,0.00,0.00,6.00,630.00,'2023-03-03 12:50:55','',''),(1094,'1','313','1',1,'Retail Sale Id 1131',5680.00,0.00,0.00,8.00,840.00,'2023-03-03 12:53:49','',''),(1095,'1','313','1',1,'Retail Sale Id 1132',1420.00,0.00,0.00,2.00,210.00,'2023-03-03 12:54:45','',''),(1096,'1','313','1',1,'Retail Sale Id 1133',26800.00,0.00,0.00,40.00,2600.00,'2023-03-03 13:03:48','',''),(1097,'1','313','1',1,'Retail Sale Id 1134',8875.00,0.00,0.00,12.50,1312.50,'2023-03-03 13:05:30','',''),(1098,'1','313','1',1,'Retail Sale Id 1135',2130.00,0.00,0.00,3.00,315.00,'2023-03-03 13:06:56','',''),(1099,'1','313','1',1,'Retail Sale Id 1136',802.30,0.00,0.00,1.13,118.65,'2023-03-03 13:13:21','',''),(1100,'1','313','1',1,'Retail Sale Id 1137',752.60,0.00,0.00,1.06,111.30,'2023-03-03 13:15:04','',''),(1101,'1','313','1',1,'Retail Sale Id 1138',1420.00,0.00,0.00,2.00,210.00,'2023-03-03 13:25:23','',''),(1102,'1','313','1',1,'Retail Sale Id 1139',2130.00,0.00,0.00,3.00,315.00,'2023-03-03 13:35:31','',''),(1103,'1','313','1',1,'Retail Sale Id 1140',1420.00,0.00,0.00,2.00,210.00,'2023-03-03 13:38:09','',''),(1104,'1','313','1',1,'Retail Sale Id 1141',2130.00,0.00,0.00,3.00,315.00,'2023-03-03 13:46:47','',''),(1105,'1','313','1',1,'Retail Sale Id 1142',5680.00,0.00,0.00,8.00,840.00,'2023-03-03 13:52:41','',''),(1106,'1','313','1',1,'Retail Sale Id 1143',2130.00,0.00,0.00,3.00,315.00,'2023-03-03 13:54:03','',''),(1107,'1','313','1',1,'Retail Sale Id 1144',1420.00,0.00,0.00,2.00,210.00,'2023-03-03 14:18:42','',''),(1108,'1','313','1',1,'Retail Sale Id 1146',7100.00,0.00,0.00,10.00,1050.00,'2023-03-03 14:28:50','',''),(1109,'1','313','1',1,'Retail Sale Id 1147',4998.40,0.00,0.00,7.04,739.20,'2023-03-03 14:33:12','',''),(1110,'1','313','1',1,'Retail Sale Id 1149',2130.00,0.00,0.00,3.00,315.00,'2023-03-03 14:37:36','',''),(1111,'1','313','1',1,'Retail Sale Id 1150',1420.00,0.00,0.00,2.00,210.00,'2023-03-03 14:40:07','',''),(1112,'1','313','1',1,'Retail Sale Id 1151',710.00,0.00,0.00,1.00,105.00,'2023-03-03 14:41:28','',''),(1113,'1','313','1',1,'Retail Sale Id 1152',4260.00,0.00,0.00,6.00,630.00,'2023-03-03 14:45:38','',''),(1114,'1','313','1',1,'Retail Sale Id 1153',702.90,0.00,0.00,0.99,103.95,'2023-03-03 14:47:19','',''),(1115,'1','313','1',1,'Retail Sale Id 1154',2840.00,0.00,0.00,4.00,420.00,'2023-03-03 14:48:35','',''),(1116,'1','313','1',1,'Retail Sale Id 1155',2130.00,0.00,0.00,3.00,315.00,'2023-03-03 14:49:25','',''),(1117,'1','313','1',1,'Retail Sale Id 1156',4970.00,0.00,0.00,7.00,735.00,'2023-03-03 14:52:00','',''),(1118,'1','313','1',1,'Retail Sale Id 1158',752.60,0.00,0.00,1.06,111.30,'2023-03-03 14:59:32','',''),(1119,'1','313','1',1,'Retail Sale Id 1159',1001.10,0.00,0.00,1.41,148.05,'2023-03-03 15:01:33','',''),(1120,'1','313','1',1,'Retail Sale Id 1160',1420.00,0.00,0.00,2.00,210.00,'2023-03-03 15:02:34','',''),(1121,'1','313','1',1,'Retail Sale Id 1161',4600.80,0.00,0.00,6.48,680.40,'2023-03-03 15:06:36','',''),(1122,'1','313','1',1,'Retail Sale Id 1162',1633.00,0.00,0.00,2.30,241.50,'2023-03-03 15:07:22','',''),(1123,'1','313','1',1,'Retail Sale Id 1163',3550.00,0.00,0.00,5.00,525.00,'2023-03-03 15:17:50','',''),(1124,'1','313','1',1,'Retail Sale Id 1164',2130.00,0.00,0.00,3.00,315.00,'2023-03-03 15:19:27','',''),(1125,'1','313','1',1,'Retail Sale Id 1165',1001.10,0.00,0.00,1.41,148.05,'2023-03-03 15:28:37','',''),(1126,'1','313','1',1,'Retail Sale Id 1166',2151.30,0.00,0.00,3.03,318.15,'2023-03-03 15:34:00','',''),(1127,'1','313','1',1,'Retail Sale Id 1167',8875.00,0.00,0.00,12.50,1312.50,'2023-03-03 15:45:13','',''),(1128,'1','313','1',1,'Retail Sale Id 1168',33500.00,0.00,0.00,50.00,3250.00,'2023-03-03 15:47:24','',''),(1129,'1','313','1',1,'Retail Sale Id 1169',4970.00,0.00,0.00,7.00,735.00,'2023-03-03 15:48:51','',''),(1130,'1','313','1',1,'Retail Sale Id 1170',752.60,0.00,0.00,1.06,111.30,'2023-03-03 15:50:07','',''),(1131,'1','313','1',1,'Retail Sale Id 1171',33500.00,0.00,0.00,50.00,3250.00,'2023-03-03 15:51:37','',''),(1132,'1','313','1',1,'Retail Sale Id 1172',1420.00,0.00,0.00,2.00,210.00,'2023-03-03 15:53:54','',''),(1133,'1','313','1',1,'Retail Sale Id 1173',2499.20,0.00,0.00,3.52,369.60,'2023-03-03 15:54:47','',''),(1134,'1','313','1',1,'Retail Sale Id 1174',2130.00,0.00,0.00,3.00,315.00,'2023-03-03 15:56:43','',''),(1135,'1','313','1',1,'Retail Sale Id 1175',4970.00,0.00,0.00,7.00,735.00,'2023-03-03 15:59:43','',''),(1136,'1','313','1',1,'Retail Sale Id 1177',2840.00,0.00,0.00,4.00,420.00,'2023-03-03 16:02:43','',''),(1137,'1','313','1',1,'Retail Sale Id 1178',2840.00,0.00,0.00,4.00,420.00,'2023-03-03 16:04:53','',''),(1138,'1','313','1',1,'Retail Sale Id 1179',2840.00,0.00,0.00,4.00,420.00,'2023-03-03 16:06:36','',''),(1139,'1','313','1',1,'Retail Sale Id 1180',8875.00,0.00,0.00,12.50,1312.50,'2023-03-03 16:10:21','',''),(1140,'1','313','1',1,'Retail Sale Id 1181',2840.00,0.00,0.00,4.00,420.00,'2023-03-03 16:12:20','',''),(1141,'1','313','1',1,'Retail Sale Id 1182',67000.00,0.00,0.00,100.00,6500.00,'2023-03-03 16:13:31','',''),(1142,'1','313','1',1,'Retail Sale Id 1183',752.60,0.00,0.00,1.06,111.30,'2023-03-03 16:17:07','',''),(1143,'1','313','1',1,'Retail Sale Id 1184',4970.00,0.00,0.00,7.00,735.00,'2023-03-03 16:18:37','',''),(1144,'1','313','1',1,'Retail Sale Id 1185',4260.00,0.00,0.00,6.00,630.00,'2023-03-03 16:19:59','',''),(1145,'1','313','1',1,'Retail Sale Id 1186',3550.00,0.00,0.00,5.00,525.00,'2023-03-03 16:20:46','',''),(1146,'1','313','1',1,'Retail Sale Id 1187',3997.30,0.00,0.00,5.63,591.15,'2023-03-03 16:23:38','',''),(1147,'1','313','1',1,'Retail Sale Id 1188',4970.00,0.00,0.00,7.00,735.00,'2023-03-03 16:24:51','',''),(1148,'1','313','1',1,'Retail Sale Id 1189',710.00,0.00,0.00,1.00,105.00,'2023-03-03 16:27:57','',''),(1149,'1','313','1',1,'Retail Sale Id 1190',717.10,0.00,0.00,1.01,106.05,'2023-03-03 16:30:02','',''),(1150,'1','313','1',1,'Retail Sale Id 1191',2399.80,0.00,0.00,3.38,354.90,'2023-03-03 16:32:21','',''),(1151,'1','313','1',1,'Retail Sale Id 1192',1398.70,0.00,0.00,1.97,206.85,'2023-03-03 16:33:28','',''),(1152,'1','313','1',1,'Retail Sale Id 1193',2130.00,0.00,0.00,3.00,315.00,'2023-03-03 16:34:32','',''),(1153,'1','313','1',1,'Retail Sale Id 1194',2130.00,0.00,0.00,3.00,315.00,'2023-03-03 16:35:51','',''),(1154,'1','313','1',1,'Retail Sale Id 1195',752.60,0.00,0.00,1.06,111.30,'2023-03-03 16:38:19','',''),(1155,'1','313','1',1,'Retail Sale Id 1196',4970.00,0.00,0.00,7.00,735.00,'2023-03-03 16:39:53','',''),(1156,'1','313','1',1,'Retail Sale Id 1197',2847.10,0.00,0.00,4.01,421.05,'2023-03-03 16:41:51','',''),(1157,'1','313','1',1,'Retail Sale Id 1198',1420.00,0.00,0.00,2.00,210.00,'2023-03-03 16:43:10','',''),(1158,'1','313','1',1,'Retail Sale Id 1199',4260.00,0.00,0.00,6.00,630.00,'2023-03-03 16:44:41','',''),(1159,'1','313','1',1,'Retail Sale Id 1200',4260.00,0.00,0.00,6.00,630.00,'2023-03-03 16:49:20','',''),(1160,'1','313','1',1,'Retail Sale Id 1201',4260.00,0.00,0.00,6.00,630.00,'2023-03-03 16:52:08','',''),(1161,'1','313','1',1,'Retail Sale Id 1202',4970.00,0.00,0.00,7.00,735.00,'2023-03-03 16:54:47','',''),(1162,'1','313','1',1,'Retail Sale Id 1203',4970.00,0.00,0.00,7.00,735.00,'2023-03-03 16:57:49','',''),(1163,'1','313','1',1,'Retail Sale Id 1204',2130.00,0.00,0.00,3.00,315.00,'2023-03-03 16:59:29','',''),(1164,'1','313','1',1,'Retail Sale Id 1205',1420.00,0.00,0.00,2.00,210.00,'2023-03-03 17:00:42','',''),(1165,'1','313','1',1,'Return of Retail Sale Id 1191',0.00,2399.80,3.38,0.00,-354.90,'2023-03-03 17:02:14','',''),(1166,'1','313','1',1,'Return of Retail Sale Id 1113',0.00,1498.10,2.11,0.00,-221.55,'2023-03-03 17:03:55','',''),(1167,'1','313','1',1,'Retail Sale Id 1206',33500.00,0.00,0.00,50.00,3250.00,'2023-03-03 17:21:53','',''),(1168,'1','313','1',1,'Return of Retail Sale Id 1188',0.00,4970.00,7.00,0.00,-735.00,'2023-03-03 17:24:42','',''),(1169,'1','313','1',1,'Retail Sale Id 1207',3983.10,0.00,0.00,5.61,589.05,'2023-03-03 17:25:45','',''),(1170,'1','313','1',1,'Retail Sale Id 1208',1001.10,0.00,0.00,1.41,148.05,'2023-03-04 08:27:46','',''),(1171,'1','313','1',1,'Retail Sale Id 1209',1001.10,0.00,0.00,1.41,148.05,'2023-03-04 08:28:34','',''),(1172,'1','313','1',1,'Retail Sale Id 1210',4260.00,0.00,0.00,6.00,630.00,'2023-03-04 08:31:08','',''),(1173,'1','313','1',1,'Retail Sale Id 1211',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 08:32:12','',''),(1174,'1','313','1',1,'Retail Sale Id 1212',7810.00,0.00,0.00,11.00,1155.00,'2023-03-04 08:35:46','',''),(1175,'1','313','1',1,'Retail Sale Id 1213',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 08:37:55','',''),(1176,'1','313','1',1,'Retail Sale Id 1214',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 08:39:30','',''),(1177,'1','313','1',1,'Retail Sale Id 1215',4970.00,0.00,0.00,7.00,735.00,'2023-03-04 08:41:03','',''),(1178,'1','313','1',1,'Retail Sale Id 1216',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 08:42:15','',''),(1179,'1','313','1',1,'Retail Sale Id 1217',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 08:43:50','',''),(1180,'1','313','1',1,'Retail Sale Id 1218',67000.00,0.00,0.00,100.00,6500.00,'2023-03-04 08:48:07','',''),(1181,'1','313','1',1,'Retail Sale Id 1219',2151.30,0.00,0.00,3.03,318.15,'2023-03-04 08:51:55','',''),(1182,'1','313','1',1,'Retail Sale Id 1220',1448.40,0.00,0.00,2.04,214.20,'2023-03-04 08:55:17','',''),(1183,'1','313','1',1,'Retail Sale Id 1221',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 08:57:46','',''),(1184,'1','313','1',1,'Retail Sale Id 1222',2151.30,0.00,0.00,3.03,318.15,'2023-03-04 08:59:03','',''),(1185,'1','313','1',1,'Retail Sale Id 1223',7100.00,0.00,0.00,10.00,1050.00,'2023-03-04 09:00:35','',''),(1186,'1','313','1',1,'Retail Sale Id 1224',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 09:02:05','',''),(1187,'1','313','1',1,'Retail Sale Id 1225',100500.00,0.00,0.00,150.00,9750.00,'2023-03-04 09:03:52','',''),(1188,'1','313','1',1,'Retail Sale Id 1226',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 09:05:14','',''),(1189,'1','313','1',1,'Retail Sale Id 1227',2151.30,0.00,0.00,3.03,318.15,'2023-03-04 09:06:47','',''),(1190,'1','313','1',1,'Retail Sale Id 1228',1448.40,0.00,0.00,2.04,214.20,'2023-03-04 09:07:42','',''),(1191,'1','313','1',1,'Retail Sale Id 1229',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 09:08:51','',''),(1192,'1','313','1',1,'Retail Sale Id 1230',710.00,0.00,0.00,1.00,105.00,'2023-03-04 09:09:20','',''),(1193,'1','313','1',1,'Retail Sale Id 1231',752.60,0.00,0.00,1.06,111.30,'2023-03-04 09:10:35','',''),(1194,'1','313','1',1,'Retail Sale Id 1233',2151.30,0.00,0.00,3.03,318.15,'2023-03-04 09:12:47','',''),(1195,'1','313','1',1,'Retail Sale Id 1234',4260.00,0.00,0.00,6.00,630.00,'2023-03-04 09:14:14','',''),(1196,'1','313','1',1,'Retail Sale Id 1235',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 09:15:26','',''),(1197,'1','313','1',1,'Retail Sale Id 1236',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 09:16:28','',''),(1198,'1','313','1',1,'Retail Sale Id 1237',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 09:17:55','',''),(1199,'1','313','1',1,'Retail Sale Id 1238',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 09:19:58','',''),(1200,'1','313','1',1,'Retail Sale Id 1239',710.00,0.00,0.00,1.00,105.00,'2023-03-04 09:22:23','',''),(1201,'1','313','1',1,'Retail Sale Id 1240',8875.00,0.00,0.00,12.50,1312.50,'2023-03-04 09:23:24','',''),(1202,'1','313','1',1,'Retail Sale Id 1241',710.00,0.00,0.00,1.00,105.00,'2023-03-04 09:24:39','',''),(1203,'1','313','1',1,'Retail Sale Id 1242',710.00,0.00,0.00,1.00,105.00,'2023-03-04 09:27:44','',''),(1204,'1','313','1',1,'Retail Sale Id 1244',3003.30,0.00,0.00,4.23,444.15,'2023-03-04 09:31:43','',''),(1205,'1','313','1',1,'Retail Sale Id 1245',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 09:32:40','',''),(1206,'1','313','1',1,'Retail Sale Id 1246',2151.30,0.00,0.00,3.03,318.15,'2023-03-04 09:34:34','',''),(1207,'1','313','1',1,'Retail Sale Id 1247',1498.10,0.00,0.00,2.11,221.55,'2023-03-04 09:35:37','',''),(1208,'1','313','1',1,'Retail Sale Id 1248',1412.90,0.00,0.00,1.99,208.95,'2023-03-04 09:36:46','',''),(1209,'1','313','1',1,'Retail Sale Id 1249',8875.00,0.00,0.00,12.50,1312.50,'2023-03-04 09:41:27','',''),(1210,'1','313','1',1,'Retail Sale Id 1250',23450.00,0.00,0.00,35.00,2275.00,'2023-03-04 09:43:02','',''),(1211,'1','313','1',1,'Retail Sale Id 1251',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 09:45:39','',''),(1212,'1','313','1',1,'Retail Sale Id 1252',8875.00,0.00,0.00,12.50,1312.50,'2023-03-04 09:47:43','',''),(1213,'1','313','1',1,'Retail Sale Id 1253',2499.20,0.00,0.00,3.52,369.60,'2023-03-04 09:49:12','',''),(1214,'1','313','1',1,'Retail Sale Id 1254',8875.00,0.00,0.00,12.50,1312.50,'2023-03-04 09:49:48','',''),(1215,'1','313','1',1,'Retail Sale Id 1255',752.60,0.00,0.00,1.06,111.30,'2023-03-04 09:51:25','',''),(1216,'1','313','1',1,'Retail Sale Id 1256',3003.30,0.00,0.00,4.23,444.15,'2023-03-04 09:52:44','',''),(1217,'1','313','1',1,'Retail Sale Id 1257',1448.40,0.00,0.00,2.04,214.20,'2023-03-04 09:54:34','',''),(1218,'1','313','1',1,'Retail Sale Id 1258',710.00,0.00,0.00,1.00,105.00,'2023-03-04 09:55:13','',''),(1219,'1','313','1',1,'Retail Sale Id 1259',802.30,0.00,0.00,1.13,118.65,'2023-03-04 09:56:09','',''),(1220,'1','313','1',1,'Retail Sale Id 1260',4970.00,0.00,0.00,7.00,735.00,'2023-03-04 09:57:32','',''),(1221,'1','313','1',1,'Retail Sale Id 1261',710.00,0.00,0.00,1.00,105.00,'2023-03-04 10:00:43','',''),(1222,'1','313','1',1,'Retail Sale Id 1262',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 10:01:56','',''),(1223,'1','313','1',1,'Retail Sale Id 1263',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 10:03:28','',''),(1224,'1','313','1',1,'Retail Sale Id 1264',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 10:04:36','',''),(1225,'1','313','1',1,'Retail Sale Id 1265',4970.00,0.00,0.00,7.00,735.00,'2023-03-04 10:06:48','',''),(1226,'1','313','1',1,'Retail Sale Id 1266',710.00,0.00,0.00,1.00,105.00,'2023-03-04 10:08:09','',''),(1227,'1','313','1',1,'Retail Sale Id 1267',2485.00,0.00,0.00,3.50,367.50,'2023-03-04 10:09:47','',''),(1228,'1','313','1',1,'Retail Sale Id 1268',40200.00,0.00,0.00,60.00,3900.00,'2023-03-04 10:10:34','',''),(1229,'1','313','1',1,'Retail Sale Id 1269',4970.00,0.00,0.00,7.00,735.00,'2023-03-04 10:11:25','',''),(1230,'1','313','1',1,'Retail Sale Id 1270',4260.00,0.00,0.00,6.00,630.00,'2023-03-04 10:12:28','',''),(1231,'1','313','1',1,'Retail Sale Id 1271',710.00,0.00,0.00,1.00,105.00,'2023-03-04 10:16:25','',''),(1232,'1','313','1',1,'Retail Sale Id 1272',2151.30,0.00,0.00,3.03,318.15,'2023-03-04 10:17:39','',''),(1233,'1','313','1',1,'Retail Sale Id 1273',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 10:18:22','',''),(1234,'1','313','1',1,'Retail Sale Id 1274',710.00,0.00,0.00,1.00,105.00,'2023-03-04 10:19:20','',''),(1235,'1','313','1',1,'Retail Sale Id 1275',33500.00,0.00,0.00,50.00,3250.00,'2023-03-04 10:20:35','',''),(1236,'1','313','1',1,'Retail Sale Id 1276',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 10:21:15','',''),(1237,'1','313','1',1,'Retail Sale Id 1277',710.00,0.00,0.00,1.00,105.00,'2023-03-04 10:22:19','',''),(1238,'1','313','1',1,'Retail Sale Id 1278',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 10:22:55','',''),(1239,'1','313','1',1,'Retail Sale Id 1279',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 10:23:33','',''),(1240,'1','313','1',1,'Retail Sale Id 1280',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 10:25:55','',''),(1241,'1','313','1',1,'Retail Sale Id 1281',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 10:27:35','',''),(1242,'1','313','1',1,'Retail Sale Id 1282',1505.20,0.00,0.00,2.12,222.60,'2023-03-04 10:33:52','',''),(1243,'1','313','1',1,'Retail Sale Id 1283',5680.00,0.00,0.00,8.00,840.00,'2023-03-04 10:35:50','',''),(1244,'1','313','1',1,'Retail Sale Id 1284',67000.00,0.00,0.00,100.00,6500.00,'2023-03-04 10:37:22','',''),(1245,'1','313','1',1,'Retail Sale Id 1285',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 10:38:59','',''),(1246,'1','313','1',1,'Retail Sale Id 1286',4970.00,0.00,0.00,7.00,735.00,'2023-03-04 10:43:09','',''),(1247,'1','313','1',1,'Retail Sale Id 1287',3003.30,0.00,0.00,4.23,444.15,'2023-03-04 10:45:31','',''),(1248,'1','313','1',1,'Retail Sale Id 1288',5680.00,0.00,0.00,8.00,840.00,'2023-03-04 10:46:40','',''),(1249,'1','313','1',1,'Retail Sale Id 1289',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 10:49:18','',''),(1250,'1','313','1',1,'Retail Sale Id 1290',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 10:52:09','',''),(1251,'1','313','1',1,'Retail Sale Id 1291',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 10:54:54','',''),(1252,'1','313','1',1,'Retail Sale Id 1292',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 10:57:21','',''),(1253,'1','313','1',1,'Retail Sale Id 1293',752.60,0.00,0.00,1.06,111.30,'2023-03-04 10:58:12','',''),(1254,'1','313','1',1,'Retail Sale Id 1294',9230.00,0.00,0.00,13.00,1365.00,'2023-03-04 10:59:30','',''),(1255,'1','313','1',1,'Retail Sale Id 1295',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 11:02:19','',''),(1256,'1','313','1',1,'Retail Sale Id 1296',2002.20,0.00,0.00,2.82,296.10,'2023-03-04 11:03:10','',''),(1257,'1','313','1',1,'Retail Sale Id 1297',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 11:06:47','',''),(1258,'1','313','1',1,'Retail Sale Id 1298',5680.00,0.00,0.00,8.00,840.00,'2023-03-04 11:07:35','',''),(1259,'1','313','1',1,'Retail Sale Id 1299',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 11:09:56','',''),(1260,'1','313','1',1,'Retail Sale Id 1300',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 11:12:44','',''),(1261,'1','313','1',1,'Retail Sale Id 1302',4970.00,0.00,0.00,7.00,735.00,'2023-03-04 11:15:49','',''),(1262,'1','313','1',1,'Retail Sale Id 1303',710.00,0.00,0.00,1.00,105.00,'2023-03-04 11:17:18','',''),(1263,'1','313','1',1,'Retail Sale Id 1304',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 11:19:57','',''),(1264,'1','313','1',1,'Retail Sale Id 1305',3003.30,0.00,0.00,4.23,444.15,'2023-03-04 11:22:30','',''),(1265,'1','313','1',1,'Retail Sale Id 1306',8520.00,0.00,0.00,12.00,1260.00,'2023-03-04 11:24:11','',''),(1266,'1','313','1',1,'Retail Sale Id 1307',8875.00,0.00,0.00,12.50,1312.50,'2023-03-04 11:26:22','',''),(1267,'1','313','1',1,'Retail Sale Id 1308',80982.90,0.00,0.00,120.87,7856.55,'2023-03-04 11:29:01','',''),(1268,'1','313','1',1,'Retail Sale Id 1309',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 11:32:26','',''),(1269,'1','313','1',1,'Retail Sale Id 1310',33500.00,0.00,0.00,50.00,3250.00,'2023-03-04 11:34:24','',''),(1270,'1','313','1',1,'Retail Sale Id 1311',6390.00,0.00,0.00,9.00,945.00,'2023-03-04 11:38:16','',''),(1271,'1','313','1',1,'Retail Sale Id 1312',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 11:39:16','',''),(1272,'1','313','1',1,'Retail Sale Id 1314',1100.50,0.00,0.00,1.55,162.75,'2023-03-04 11:41:18','',''),(1273,'1','313','1',1,'Retail Sale Id 1315',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 11:42:56','',''),(1274,'1','313','1',1,'Retail Sale Id 1316',7100.00,0.00,0.00,10.00,1050.00,'2023-03-04 11:44:05','',''),(1275,'1','313','1',1,'Retail Sale Id 1317',9230.00,0.00,0.00,13.00,1365.00,'2023-03-04 11:47:22','',''),(1276,'1','313','1',1,'Retail Sale Id 1318',8875.00,0.00,0.00,12.50,1312.50,'2023-03-04 11:51:14','',''),(1277,'1','313','1',1,'Retail Sale Id 1319',710.00,0.00,0.00,1.00,105.00,'2023-03-04 11:53:03','',''),(1278,'1','313','1',1,'Retail Sale Id 1320',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 11:54:12','',''),(1279,'1','313','1',1,'Retail Sale Id 1321',5680.00,0.00,0.00,8.00,840.00,'2023-03-04 11:55:22','',''),(1280,'1','313','1',1,'Retail Sale Id 1322',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 11:56:35','',''),(1281,'1','313','1',1,'Retail Sale Id 1323',7100.00,0.00,0.00,10.00,1050.00,'2023-03-04 11:57:51','',''),(1282,'1','313','1',1,'Retail Sale Id 1324',33500.00,0.00,0.00,50.00,3250.00,'2023-03-04 11:59:18','',''),(1283,'1','313','1',1,'Retail Sale Id 1326',2002.20,0.00,0.00,2.82,296.10,'2023-03-04 12:01:43','',''),(1284,'1','313','1',1,'Retail Sale Id 1327',5680.00,0.00,0.00,8.00,840.00,'2023-03-04 12:02:33','',''),(1285,'1','313','1',1,'Retail Sale Id 1328',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 12:04:07','',''),(1286,'1','313','1',1,'Retail Sale Id 1329',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 12:06:00','',''),(1287,'1','313','1',1,'Retail Sale Id 1330',40200.00,0.00,0.00,60.00,3900.00,'2023-03-04 12:07:41','',''),(1288,'1','313','1',1,'Retail Sale Id 1331',2151.30,0.00,0.00,3.03,318.15,'2023-03-04 12:08:43','',''),(1289,'1','313','1',1,'Retail Sale Id 1332',2151.30,0.00,0.00,3.03,318.15,'2023-03-04 12:09:57','',''),(1290,'1','313','1',1,'Retail Sale Id 1333',40200.00,0.00,0.00,60.00,3900.00,'2023-03-04 12:11:15','',''),(1291,'1','313','1',1,'Retail Sale Id 1334',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 12:12:00','',''),(1292,'1','313','1',1,'Retail Sale Id 1335',8875.00,0.00,0.00,12.50,1312.50,'2023-03-04 12:13:19','',''),(1293,'1','313','1',1,'Retail Sale Id 1336',40200.00,0.00,0.00,60.00,3900.00,'2023-03-04 12:14:57','',''),(1294,'1','313','1',1,'Retail Sale Id 1337',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 12:16:48','',''),(1295,'1','313','1',1,'Retail Sale Id 1338',8875.00,0.00,0.00,12.50,1312.50,'2023-03-04 12:18:21','',''),(1296,'1','313','1',1,'Retail Sale Id 1339',5680.00,0.00,0.00,8.00,840.00,'2023-03-04 12:21:09','',''),(1297,'1','313','1',1,'Retail Sale Id 1340',1775.00,0.00,0.00,2.50,262.50,'2023-03-04 12:23:55','',''),(1298,'1','313','1',1,'Retail Sale Id 1341',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 12:28:30','',''),(1299,'1','313','1',1,'Retail Sale Id 1342',752.60,0.00,0.00,1.06,111.30,'2023-03-04 12:30:16','',''),(1300,'1','313','1',1,'Retail Sale Id 1343',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 12:31:02','',''),(1301,'1','313','1',1,'Retail Sale Id 1344',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 12:33:54','',''),(1302,'1','313','1',1,'Retail Sale Id 1345',2499.20,0.00,0.00,3.52,369.60,'2023-03-04 12:35:26','',''),(1303,'1','313','1',1,'Retail Sale Id 1346',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 12:36:32','',''),(1304,'1','313','1',1,'Retail Sale Id 1347',3003.30,0.00,0.00,4.23,444.15,'2023-03-04 12:39:12','',''),(1305,'1','313','1',1,'Retail Sale Id 1348',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 12:41:33','',''),(1306,'1','313','1',1,'Retail Sale Id 1349',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 12:43:50','',''),(1307,'1','313','1',1,'Retail Sale Id 1350',2151.30,0.00,0.00,3.03,318.15,'2023-03-04 12:45:23','',''),(1308,'1','313','1',1,'Retail Sale Id 1351',8875.00,0.00,0.00,12.50,1312.50,'2023-03-04 12:46:59','',''),(1309,'1','313','1',1,'Retail Sale Id 1352',4970.00,0.00,0.00,7.00,735.00,'2023-03-04 12:48:13','',''),(1310,'1','313','1',1,'Retail Sale Id 1353',4970.00,0.00,0.00,7.00,735.00,'2023-03-04 12:49:31','',''),(1311,'1','313','1',1,'Retail Sale Id 1354',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 12:50:44','',''),(1312,'1','313','1',1,'Retail Sale Id 1355',752.60,0.00,0.00,1.06,111.30,'2023-03-04 12:51:49','',''),(1313,'1','313','1',1,'Retail Sale Id 1356',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 12:52:53','',''),(1314,'1','313','1',1,'Retail Sale Id 1357',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 12:54:11','',''),(1315,'1','313','1',1,'Retail Sale Id 1358',5680.00,0.00,0.00,8.00,840.00,'2023-03-04 12:55:30','',''),(1316,'1','313','1',1,'Retail Sale Id 1359',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 12:56:42','',''),(1317,'1','313','1',1,'Retail Sale Id 1360',752.60,0.00,0.00,1.06,111.30,'2023-03-04 12:58:07','',''),(1318,'1','313','1',1,'Retail Sale Id 1361',84138.60,0.00,0.00,125.58,8162.70,'2023-03-04 13:00:48','',''),(1319,'1','313','1',1,'Retail Sale Id 1362',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 13:02:11','',''),(1320,'1','313','1',1,'Retail Sale Id 1363',752.60,0.00,0.00,1.06,111.30,'2023-03-04 13:05:17','',''),(1321,'1','313','1',1,'Retail Sale Id 1364',1448.40,0.00,0.00,2.04,214.20,'2023-03-04 13:07:54','',''),(1322,'1','313','1',1,'Retail Sale Id 1365',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 13:09:09','',''),(1323,'1','313','1',1,'Retail Sale Id 1366',1775.00,0.00,0.00,2.50,262.50,'2023-03-04 13:10:20','',''),(1324,'1','313','1',1,'Retail Sale Id 1367',7100.00,0.00,0.00,10.00,1050.00,'2023-03-04 13:11:23','',''),(1325,'1','313','1',1,'Retail Sale Id 1368',8875.00,0.00,0.00,12.50,1312.50,'2023-03-04 13:12:44','',''),(1326,'1','313','1',1,'Retail Sale Id 1369',4998.40,0.00,0.00,7.04,739.20,'2023-03-04 13:14:18','',''),(1327,'1','313','1',1,'Retail Sale Id 1370',3997.30,0.00,0.00,5.63,591.15,'2023-03-04 13:16:14','',''),(1328,'1','313','1',1,'Retail Sale Id 1371',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 13:17:41','',''),(1329,'1','313','1',1,'Retail Sale Id 1372',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 13:18:45','',''),(1330,'1','313','1',1,'Retail Sale Id 1373',14200.00,0.00,0.00,20.00,2100.00,'2023-03-04 13:19:56','',''),(1331,'1','313','1',1,'Retail Sale Id 1374',7100.00,0.00,0.00,10.00,1050.00,'2023-03-04 13:21:18','',''),(1332,'1','313','1',1,'Retail Sale Id 1375',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 13:22:35','',''),(1333,'1','313','1',1,'Retail Sale Id 1376',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 13:23:24','',''),(1334,'1','313','1',1,'Retail Sale Id 1377',40575.20,0.00,0.00,60.56,3936.40,'2023-03-04 13:25:17','',''),(1335,'1','313','1',1,'Retail Sale Id 1378',710.00,0.00,0.00,1.00,105.00,'2023-03-04 13:27:15','',''),(1336,'1','313','1',1,'Retail Sale Id 1379',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 13:28:13','',''),(1337,'1','313','1',1,'Retail Sale Id 1380',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 13:29:03','',''),(1338,'1','313','1',1,'Retail Sale Id 1381',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 13:31:09','',''),(1339,'1','313','1',1,'Retail Sale Id 1382',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 13:32:25','',''),(1340,'1','313','1',1,'Retail Sale Id 1383',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 13:34:39','',''),(1341,'1','313','1',1,'Retail Sale Id 1384',710.00,0.00,0.00,1.00,105.00,'2023-03-04 13:35:53','',''),(1342,'1','313','1',1,'Retail Sale Id 1385',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 13:37:13','',''),(1343,'1','313','1',1,'Retail Sale Id 1386',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 13:37:52','',''),(1344,'1','313','1',1,'Retail Sale Id 1387',4260.00,0.00,0.00,6.00,630.00,'2023-03-04 13:41:30','',''),(1345,'1','313','1',1,'Retail Sale Id 1388',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 13:42:22','',''),(1346,'1','313','1',1,'Retail Sale Id 1389',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 13:44:06','',''),(1347,'1','313','1',1,'Retail Sale Id 1390',4260.00,0.00,0.00,6.00,630.00,'2023-03-04 13:45:16','',''),(1348,'1','313','1',1,'Retail Sale Id 1391',4260.00,0.00,0.00,6.00,630.00,'2023-03-04 13:46:29','',''),(1349,'1','313','1',1,'Retail Sale Id 1392',2151.30,0.00,0.00,3.03,318.15,'2023-03-04 13:48:08','',''),(1350,'1','313','1',1,'Retail Sale Id 1393',4260.00,0.00,0.00,6.00,630.00,'2023-03-04 13:49:06','',''),(1351,'1','313','1',1,'Retail Sale Id 1394',4260.00,0.00,0.00,6.00,630.00,'2023-03-04 13:50:52','',''),(1352,'1','313','1',1,'Retail Sale Id 1395',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 13:52:24','',''),(1353,'1','313','1',1,'Retail Sale Id 1396',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 13:53:53','',''),(1354,'1','313','1',1,'Retail Sale Id 1397',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 13:55:16','',''),(1355,'1','313','1',1,'Retail Sale Id 1398',1498.10,0.00,0.00,2.11,221.55,'2023-03-04 13:58:47','',''),(1356,'1','313','1',1,'Retail Sale Id 1399',710.00,0.00,0.00,1.00,105.00,'2023-03-04 14:00:37','',''),(1357,'1','313','1',1,'Retail Sale Id 1400',8875.00,0.00,0.00,12.50,1312.50,'2023-03-04 14:01:26','',''),(1358,'1','313','1',1,'Retail Sale Id 1401',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 14:02:19','',''),(1359,'1','313','1',1,'Retail Sale Id 1402',33500.00,0.00,0.00,50.00,3250.00,'2023-03-04 14:03:43','',''),(1360,'1','313','1',1,'Retail Sale Id 1403',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 14:06:46','',''),(1361,'1','313','1',1,'Retail Sale Id 1404',10650.00,0.00,0.00,15.00,1575.00,'2023-03-04 14:07:47','',''),(1362,'1','313','1',1,'Retail Sale Id 1405',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 14:08:44','',''),(1363,'1','313','1',1,'Retail Sale Id 1406',7100.00,0.00,0.00,10.00,1050.00,'2023-03-04 14:09:44','',''),(1364,'1','313','1',1,'Retail Sale Id 1407',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 14:11:45','',''),(1365,'1','313','1',1,'Retail Sale Id 1408',2151.30,0.00,0.00,3.03,318.15,'2023-03-04 14:13:00','',''),(1366,'1','313','1',1,'Retail Sale Id 1409',4970.00,0.00,0.00,7.00,735.00,'2023-03-04 14:14:11','',''),(1367,'1','313','1',1,'Retail Sale Id 1410',8875.00,0.00,0.00,12.50,1312.50,'2023-03-04 14:16:03','',''),(1368,'1','313','1',1,'Retail Sale Id 1411',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 14:17:38','',''),(1369,'1','313','1',1,'Retail Sale Id 1412',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 14:20:08','',''),(1370,'1','313','1',1,'Retail Sale Id 1413',1448.40,0.00,0.00,2.04,214.20,'2023-03-04 14:21:31','',''),(1371,'1','313','1',1,'Retail Sale Id 1414',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 14:28:01','',''),(1372,'1','313','1',1,'Retail Sale Id 1415',4260.00,0.00,0.00,6.00,630.00,'2023-03-04 14:28:49','',''),(1373,'1','313','1',1,'Retail Sale Id 1416',2002.20,0.00,0.00,2.82,296.10,'2023-03-04 14:30:04','',''),(1374,'1','313','1',1,'Retail Sale Id 1417',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 14:31:39','',''),(1375,'1','313','1',1,'Retail Sale Id 1418',1448.40,0.00,0.00,2.04,214.20,'2023-03-04 14:34:52','',''),(1376,'1','313','1',1,'Retail Sale Id 1419',4970.00,0.00,0.00,7.00,735.00,'2023-03-04 14:38:29','',''),(1377,'1','313','1',1,'Retail Sale Id 1420',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 14:42:33','',''),(1378,'1','313','1',1,'Retail Sale Id 1421',2151.30,0.00,0.00,3.03,318.15,'2023-03-04 14:44:32','',''),(1379,'1','313','1',1,'Retail Sale Id 1422',8875.00,0.00,0.00,12.50,1312.50,'2023-03-04 14:47:25','',''),(1380,'1','313','1',1,'Retail Sale Id 1423',1448.40,0.00,0.00,2.04,214.20,'2023-03-04 14:49:00','',''),(1381,'1','313','1',1,'Retail Sale Id 1424',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 14:50:08','',''),(1382,'1','313','1',1,'Retail Sale Id 1425',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 14:51:45','',''),(1383,'1','313','1',1,'Retail Sale Id 1426',4260.00,0.00,0.00,6.00,630.00,'2023-03-04 14:53:11','',''),(1384,'1','313','1',1,'Retail Sale Id 1427',1065.00,0.00,0.00,1.50,157.50,'2023-03-04 14:54:40','',''),(1385,'1','313','1',1,'Retail Sale Id 1428',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 14:56:47','',''),(1386,'1','313','1',1,'Retail Sale Id 1429',4970.00,0.00,0.00,7.00,735.00,'2023-03-04 14:58:07','',''),(1387,'1','313','1',1,'Retail Sale Id 1430',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 15:02:10','',''),(1388,'1','313','1',1,'Retail Sale Id 1431',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 15:04:23','',''),(1389,'1','313','1',1,'Retail Sale Id 1432',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 15:07:36','',''),(1390,'1','313','1',1,'Retail Sale Id 1433',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 15:09:59','',''),(1391,'1','313','1',1,'Retail Sale Id 1434',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 15:11:55','',''),(1392,'1','313','1',1,'Retail Sale Id 1435',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 15:13:33','',''),(1393,'1','313','1',1,'Retail Sale Id 1436',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 15:15:38','',''),(1394,'1','313','1',1,'Retail Sale Id 1437',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 15:17:27','',''),(1395,'1','313','1',1,'Retail Sale Id 1438',40200.00,0.00,0.00,60.00,3900.00,'2023-03-04 15:18:35','',''),(1396,'1','313','1',1,'Retail Sale Id 1439',2151.30,0.00,0.00,3.03,318.15,'2023-03-04 15:20:51','',''),(1397,'1','313','1',1,'Retail Sale Id 1440',702.90,0.00,0.00,0.99,103.95,'2023-03-04 15:23:13','',''),(1398,'1','313','1',1,'Retail Sale Id 1443',4998.40,0.00,0.00,7.04,739.20,'2023-03-04 15:26:10','',''),(1399,'1','313','1',1,'Retail Sale Id 1444',7100.00,0.00,0.00,10.00,1050.00,'2023-03-04 15:28:18','',''),(1400,'1','313','1',1,'Retail Sale Id 1445',7100.00,0.00,0.00,10.00,1050.00,'2023-03-04 15:29:37','',''),(1401,'1','313','1',1,'Retail Sale Id 1446',5325.00,0.00,0.00,7.50,787.50,'2023-03-04 15:31:36','',''),(1402,'1','313','1',1,'Retail Sale Id 1447',2002.20,0.00,0.00,2.82,296.10,'2023-03-04 15:32:43','',''),(1403,'1','313','1',1,'Retail Sale Id 1448',752.60,0.00,0.00,1.06,111.30,'2023-03-04 15:33:57','',''),(1404,'1','313','1',1,'Retail Sale Id 1449',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 15:35:55','',''),(1405,'1','313','1',1,'Retail Sale Id 1451',1448.40,0.00,0.00,2.04,214.20,'2023-03-04 15:37:28','',''),(1406,'1','313','1',1,'Retail Sale Id 1452',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 15:39:57','',''),(1407,'1','313','1',1,'Retail Sale Id 1453',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 15:41:26','',''),(1408,'1','313','1',1,'Retail Sale Id 1454',7100.00,0.00,0.00,10.00,1050.00,'2023-03-04 15:44:00','',''),(1409,'1','313','1',1,'Retail Sale Id 1455',1001.10,0.00,0.00,1.41,148.05,'2023-03-04 15:45:28','',''),(1410,'1','313','1',1,'Retail Sale Id 1456',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 15:47:18','',''),(1411,'1','313','1',1,'Retail Sale Id 1458',1448.40,0.00,0.00,2.04,214.20,'2023-03-04 15:48:19','',''),(1412,'1','313','1',1,'Retail Sale Id 1459',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 15:49:35','',''),(1413,'1','313','1',1,'Retail Sale Id 1460',40200.00,0.00,0.00,60.00,3900.00,'2023-03-04 15:51:57','',''),(1414,'1','313','1',1,'Retail Sale Id 1462',2002.20,0.00,0.00,2.82,296.10,'2023-03-04 15:53:33','',''),(1415,'1','313','1',1,'Retail Sale Id 1463',710.00,0.00,0.00,1.00,105.00,'2023-03-04 15:56:24','',''),(1416,'1','313','1',1,'Retail Sale Id 1464',752.60,0.00,0.00,1.06,111.30,'2023-03-04 15:57:15','',''),(1417,'1','313','1',1,'Retail Sale Id 1465',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 15:58:27','',''),(1418,'1','313','1',1,'Retail Sale Id 1466',752.60,0.00,0.00,1.06,111.30,'2023-03-04 15:59:19','',''),(1419,'1','313','1',1,'Retail Sale Id 1467',8875.00,0.00,0.00,12.50,1312.50,'2023-03-04 16:02:09','',''),(1420,'1','313','1',1,'Retail Sale Id 1468',36850.00,0.00,0.00,55.00,3575.00,'2023-03-04 16:07:20','',''),(1421,'1','313','1',1,'Retail Sale Id 1469',752.60,0.00,0.00,1.06,111.30,'2023-03-04 16:08:47','',''),(1422,'1','313','1',1,'Retail Sale Id 1470',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 16:09:36','',''),(1423,'1','313','1',1,'Retail Sale Id 1471',8875.00,0.00,0.00,12.50,1312.50,'2023-03-04 16:11:22','',''),(1424,'1','313','1',1,'Retail Sale Id 1472',2832.90,0.00,0.00,3.99,418.95,'2023-03-04 16:12:41','',''),(1425,'1','313','1',1,'Retail Sale Id 1473',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 16:14:16','',''),(1426,'1','313','1',1,'Retail Sale Id 1474',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 16:15:52','',''),(1427,'1','313','1',1,'Retail Sale Id 1475',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 16:17:17','',''),(1428,'1','313','1',1,'Retail Sale Id 1476',9002.80,0.00,0.00,12.68,1331.40,'2023-03-04 16:18:37','',''),(1429,'1','313','1',1,'Retail Sale Id 1477',8001.70,0.00,0.00,11.27,1183.35,'2023-03-04 16:20:00','',''),(1430,'1','313','1',1,'Retail Sale Id 1478',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 16:21:09','',''),(1431,'1','313','1',1,'Retail Sale Id 1479',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 16:22:06','',''),(1432,'1','313','1',1,'Retail Sale Id 1480',8875.00,0.00,0.00,12.50,1312.50,'2023-03-04 16:23:09','',''),(1433,'1','313','1',1,'Retail Sale Id 1481',40401.00,0.00,0.00,60.30,3919.50,'2023-03-04 16:28:43','',''),(1434,'1','313','1',1,'Retail Sale Id 1482',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 16:31:04','',''),(1435,'1','313','1',1,'Retail Sale Id 1483',752.60,0.00,0.00,1.06,111.30,'2023-03-04 16:31:52','',''),(1436,'1','313','1',1,'Retail Sale Id 1484',9230.00,0.00,0.00,13.00,1365.00,'2023-03-04 16:32:28','',''),(1437,'1','313','1',1,'Retail Sale Id 1485',710.00,0.00,0.00,1.00,105.00,'2023-03-04 16:33:10','',''),(1438,'1','313','1',1,'Retail Sale Id 1486',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 16:38:19','',''),(1439,'1','313','1',1,'Retail Sale Id 1487',1498.10,0.00,0.00,2.11,221.55,'2023-03-04 16:41:48','',''),(1440,'1','313','1',1,'Retail Sale Id 1488',710.00,0.00,0.00,1.00,105.00,'2023-03-04 16:43:30','',''),(1441,'1','313','1',1,'Retail Sale Id 1489',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 16:45:06','',''),(1442,'1','313','1',1,'Retail Sale Id 1490',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 16:46:33','',''),(1443,'1','313','1',1,'Retail Sale Id 1491',17040.00,0.00,0.00,24.00,2520.00,'2023-03-04 16:48:41','',''),(1444,'1','313','1',1,'Return of Retail Sale Id 1491',0.00,17040.00,24.00,0.00,-2520.00,'2023-03-04 16:50:04','',''),(1445,'1','313','1',1,'Retail Sale Id 1492',4998.40,0.00,0.00,7.04,739.20,'2023-03-04 16:51:39','',''),(1446,'1','313','1',1,'Retail Sale Id 1493',40200.00,0.00,0.00,60.00,3900.00,'2023-03-04 16:52:52','',''),(1447,'1','313','1',1,'Retail Sale Id 1494',7100.00,0.00,0.00,10.00,1050.00,'2023-03-04 16:53:49','',''),(1448,'1','313','1',1,'Retail Sale Id 1495',8875.00,0.00,0.00,12.50,1312.50,'2023-03-04 16:55:12','',''),(1449,'1','313','1',1,'Retail Sale Id 1496',21607.50,0.00,0.00,32.25,2096.25,'2023-03-04 16:57:31','',''),(1450,'1','313','1',1,'Retail Sale Id 1497',710.00,0.00,0.00,1.00,105.00,'2023-03-04 16:58:46','',''),(1451,'1','313','1',1,'Retail Sale Id 1498',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 17:00:38','',''),(1452,'1','313','1',1,'Retail Sale Id 1499',32830.00,0.00,0.00,49.00,3185.00,'2023-03-04 17:03:17','',''),(1453,'1','313','1',1,'Retail Sale Id 1500',8520.00,0.00,0.00,12.00,1260.00,'2023-03-04 17:05:16','',''),(1454,'1','313','1',1,'Retail Sale Id 1502',1420.00,0.00,0.00,2.00,210.00,'2023-03-04 17:11:09','',''),(1455,'1','313','1',1,'Retail Sale Id 1503',710.00,0.00,0.00,1.00,105.00,'2023-03-04 17:16:09','',''),(1456,'1','313','1',1,'Retail Sale Id 1504',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 17:17:03','',''),(1457,'1','313','1',1,'Retail Sale Id 1505',2130.00,0.00,0.00,3.00,315.00,'2023-03-04 17:18:46','',''),(1458,'1','313','1',1,'Retail Sale Id 1506',3550.00,0.00,0.00,5.00,525.00,'2023-03-04 17:20:50','',''),(1459,'1','313','1',1,'Retail Sale Id 1507',752.60,0.00,0.00,1.06,111.30,'2023-03-04 17:21:37','',''),(1460,'1','313','1',1,'Retail Sale Id 1508',2840.00,0.00,0.00,4.00,420.00,'2023-03-04 17:23:02','',''),(1461,'1','313','1',1,'Retail Sale Id 1509',3003.30,0.00,0.00,4.23,444.15,'2023-03-04 17:24:32','',''),(1462,'1','313','1',1,'Return of Retail Sale Id 1373',0.00,14200.00,20.00,0.00,-2100.00,'2023-03-04 17:52:41','',''),(1463,'1','313','1',1,'Retail Sale Id 1511',13400.00,0.00,0.00,20.00,1300.00,'2023-03-04 17:53:19','',''),(1464,'1','313','1',1,'Return of Retail Sale Id 1410',0.00,8875.00,12.50,0.00,-1312.50,'2023-03-04 17:54:55','',''),(1465,'1','313','1',1,'Retail Sale Id 1512',8375.00,0.00,0.00,12.50,812.50,'2023-03-04 17:55:38','',''),(1466,'1','313','1',1,'Return of Retail Sale Id 1487',0.00,1498.10,2.11,0.00,-221.55,'2023-03-04 17:56:58','',''),(1467,'1','313','1',1,'Return of Retail Sale Id 1429',0.00,4970.00,7.00,0.00,-735.00,'2023-03-04 17:58:42','',''),(1468,'1','313','1',1,'Return of Retail Sale Id 1502',0.00,1420.00,2.00,0.00,-210.00,'2023-03-04 17:59:45','',''),(1469,'1','313','1',1,'Return of Retail Sale Id 1476',0.00,9002.80,12.68,0.00,-1331.40,'2023-03-04 18:00:55','',''),(1470,'1','313','1',1,'Retail Sale Id 1513',36600.50,0.00,0.00,51.55,5412.75,'2023-03-04 18:04:18','',''),(1471,'1','313','1',1,'Return of Retail Sale Id 1513',0.00,36600.50,51.55,0.00,-5412.75,'2023-03-04 18:17:56','',''),(1472,'1','313','1',1,'Retail Sale Id 1514',24331.70,0.00,0.00,34.27,3598.35,'2023-03-04 18:19:03','',''),(1473,'1','313','1',1,'Return of Retail Sale Id 1377',0.00,40575.20,60.56,0.00,-3936.40,'2023-03-04 18:28:51','',''),(1474,'1','313','1',1,'Retail Sale Id 1515',40307.20,0.00,0.00,60.16,3910.40,'2023-03-04 18:30:11','',''),(1475,'1','313','1',1,'Retail Sale Id 1516',802.30,0.00,0.00,1.13,118.65,'2023-03-05 10:29:28','',''),(1476,'1','313','1',1,'Retail Sale Id 1517',2002.20,0.00,0.00,2.82,296.10,'2023-03-05 10:31:01','',''),(1477,'1','313','1',1,'Retail Sale Id 1518',752.60,0.00,0.00,1.06,111.30,'2023-03-05 10:31:45','',''),(1478,'1','313','1',1,'Retail Sale Id 1519',4970.00,0.00,0.00,7.00,735.00,'2023-03-05 10:32:43','',''),(1479,'1','313','1',1,'Retail Sale Id 1520',710.00,0.00,0.00,1.00,105.00,'2023-03-05 10:34:16','',''),(1480,'1','313','1',1,'Retail Sale Id 1521',31490.00,0.00,0.00,47.00,3055.00,'2023-03-05 10:35:56','',''),(1481,'1','313','1',1,'Retail Sale Id 1522',1001.10,0.00,0.00,1.41,148.05,'2023-03-05 10:36:40','',''),(1482,'1','313','1',1,'Retail Sale Id 1523',1420.00,0.00,0.00,2.00,210.00,'2023-03-05 10:37:29','',''),(1483,'1','313','1',1,'Retail Sale Id 1524',2130.00,0.00,0.00,3.00,315.00,'2023-03-05 10:38:36','',''),(1484,'1','313','1',1,'Retail Sale Id 1525',1420.00,0.00,0.00,2.00,210.00,'2023-03-05 10:39:42','',''),(1485,'1','313','1',1,'Retail Sale Id 1526',31892.00,0.00,0.00,47.60,3094.00,'2023-03-05 10:41:31','',''),(1486,'1','313','1',1,'Retail Sale Id 1527',802.30,0.00,0.00,1.13,118.65,'2023-03-05 10:44:34','',''),(1487,'1','313','1',1,'Retail Sale Id 1528',2130.00,0.00,0.00,3.00,315.00,'2023-03-05 10:45:18','',''),(1488,'1','313','1',1,'Retail Sale Id 1529',8875.00,0.00,0.00,12.50,1312.50,'2023-03-05 10:46:24','',''),(1489,'1','313','1',1,'Retail Sale Id 1530',1420.00,0.00,0.00,2.00,210.00,'2023-03-05 10:47:40','',''),(1490,'1','313','1',1,'Retail Sale Id 1531',12780.00,0.00,0.00,18.00,1890.00,'2023-03-05 10:48:41','',''),(1491,'1','313','1',1,'Retail Sale Id 1532',3003.30,0.00,0.00,4.23,444.15,'2023-03-05 10:52:18','',''),(1492,'1','313','1',1,'Return of Retail Sale Id 1521',0.00,31490.00,47.00,0.00,-3055.00,'2023-03-05 10:53:17','',''),(1493,'1','313','1',1,'Retail Sale Id 1533',3997.30,0.00,0.00,5.63,591.15,'2023-03-05 11:03:07','',''),(1494,'1','313','1',1,'Retail Sale Id 1534',4260.00,0.00,0.00,6.00,630.00,'2023-03-05 11:05:25','',''),(1495,'1','313','1',1,'Retail Sale Id 1535',2130.00,0.00,0.00,3.00,315.00,'2023-03-05 11:06:44','',''),(1496,'1','313','1',1,'Retail Sale Id 1536',1420.00,0.00,0.00,2.00,210.00,'2023-03-05 11:10:16','',''),(1497,'1','313','1',1,'Retail Sale Id 1537',1498.10,0.00,0.00,2.11,221.55,'2023-03-05 11:14:52','',''),(1498,'1','313','1',1,'Retail Sale Id 1538',4260.00,0.00,0.00,6.00,630.00,'2023-03-05 11:16:35','',''),(1499,'1','313','1',1,'Retail Sale Id 1539',710.00,0.00,0.00,1.00,105.00,'2023-03-05 11:21:04','',''),(1500,'1','313','1',1,'Retail Sale Id 1540',40200.00,0.00,0.00,60.00,3900.00,'2023-03-05 11:27:21','',''),(1501,'1','313','1',1,'Retail Sale Id 1541',3550.00,0.00,0.00,5.00,525.00,'2023-03-05 11:29:08','',''),(1502,'1','313','1',1,'Retail Sale Id 1542',1001.10,0.00,0.00,1.41,148.05,'2023-03-05 11:30:16','',''),(1503,'1','313','1',1,'Retail Sale Id 1543',1448.40,0.00,0.00,2.04,214.20,'2023-03-05 11:32:53','',''),(1504,'1','313','1',1,'Retail Sale Id 1544',802.30,0.00,0.00,1.13,118.65,'2023-03-05 11:45:24','',''),(1505,'1','313','1',1,'Retail Sale Id 1545',1498.10,0.00,0.00,2.11,221.55,'2023-03-05 11:47:12','',''),(1506,'1','313','1',1,'Retail Sale Id 1546',8520.00,0.00,0.00,12.00,1260.00,'2023-03-05 11:54:15','',''),(1507,'1','313','1',1,'Retail Sale Id 1547',3997.30,0.00,0.00,5.63,591.15,'2023-03-05 12:01:50','',''),(1508,'1','313','1',1,'Retail Sale Id 1548',3550.00,0.00,0.00,5.00,525.00,'2023-03-05 12:07:05','',''),(1509,'1','313','1',1,'Retail Sale Id 1549',8875.00,0.00,0.00,12.50,1312.50,'2023-03-05 12:11:27','',''),(1510,'1','313','1',1,'Retail Sale Id 1550',2002.20,0.00,0.00,2.82,296.10,'2023-03-05 12:12:57','',''),(1511,'1','313','1',1,'Retail Sale Id 1551',710.00,0.00,0.00,1.00,105.00,'2023-03-05 12:14:29','',''),(1512,'1','313','1',1,'Retail Sale Id 1552',1065.00,0.00,0.00,1.50,157.50,'2023-03-05 12:29:18','',''),(1513,'1','313','1',1,'Retail Sale Id 1553',1420.00,0.00,0.00,2.00,210.00,'2023-03-05 12:31:19','',''),(1514,'1','313','1',1,'Retail Sale Id 1554',8875.00,0.00,0.00,12.50,1312.50,'2023-03-05 12:33:20','',''),(1515,'1','313','1',1,'Retail Sale Id 1555',3003.30,0.00,0.00,4.23,444.15,'2023-03-05 12:35:42','',''),(1516,'1','313','1',1,'Retail Sale Id 1556',1420.00,0.00,0.00,2.00,210.00,'2023-03-05 12:39:42','',''),(1517,'1','313','1',1,'Retail Sale Id 1557',2130.00,0.00,0.00,3.00,315.00,'2023-03-05 12:44:31','',''),(1518,'1','313','1',1,'Retail Sale Id 1558',40200.00,0.00,0.00,60.00,3900.00,'2023-03-05 12:48:34','',''),(1519,'1','313','1',1,'Retail Sale Id 1559',33500.00,0.00,0.00,50.00,3250.00,'2023-03-05 12:49:43','',''),(1520,'1','313','1',1,'Retail Sale Id 1560',1420.00,0.00,0.00,2.00,210.00,'2023-03-05 12:52:51','',''),(1521,'1','313','1',1,'Retail Sale Id 1561',1420.00,0.00,0.00,2.00,210.00,'2023-03-05 12:54:26','',''),(1522,'1','313','1',1,'Retail Sale Id 1562',4260.00,0.00,0.00,6.00,630.00,'2023-03-05 13:03:19','',''),(1523,'1','313','1',1,'Retail Sale Id 1563',3550.00,0.00,0.00,5.00,525.00,'2023-03-05 13:05:17','',''),(1524,'1','313','1',1,'Retail Sale Id 1564',802.30,0.00,0.00,1.13,118.65,'2023-03-05 13:07:02','',''),(1525,'1','313','1',1,'Retail Sale Id 1565',2840.00,0.00,0.00,4.00,420.00,'2023-03-05 13:10:11','',''),(1526,'1','313','1',1,'Retail Sale Id 1566',114596.80,0.00,0.00,171.04,11117.60,'2023-03-05 13:13:19','',''),(1527,'1','313','1',1,'Retail Sale Id 1567',1498.10,0.00,0.00,2.11,221.55,'2023-03-05 13:15:17','',''),(1528,'1','313','1',1,'Retail Sale Id 1568',4970.00,0.00,0.00,7.00,735.00,'2023-03-05 13:17:04','',''),(1529,'1','313','1',1,'Retail Sale Id 1569',2130.00,0.00,0.00,3.00,315.00,'2023-03-05 13:18:17','',''),(1530,'1','313','1',1,'Retail Sale Id 1570',160800.00,0.00,0.00,240.00,15600.00,'2023-03-05 13:30:55','',''),(1531,'1','313','1',1,'Retail Sale Id 1571',1420.00,0.00,0.00,2.00,210.00,'2023-03-05 13:32:57','',''),(1532,'1','313','1',1,'Retail Sale Id 1572',2130.00,0.00,0.00,3.00,315.00,'2023-03-05 13:33:47','',''),(1533,'1','313','1',1,'Retail Sale Id 1573',710.00,0.00,0.00,1.00,105.00,'2023-03-05 13:35:03','',''),(1534,'1','313','1',1,'Retail Sale Id 1574',2130.00,0.00,0.00,3.00,315.00,'2023-03-05 13:38:24','',''),(1535,'1','313','1',1,'Retail Sale Id 1575',6390.00,0.00,0.00,9.00,945.00,'2023-03-05 13:42:33','',''),(1536,'1','313','1',1,'Retail Sale Id 1576',40200.00,0.00,0.00,60.00,3900.00,'2023-03-05 13:44:42','',''),(1537,'1','313','1',1,'Retail Sale Id 1577',4260.00,0.00,0.00,6.00,630.00,'2023-03-05 13:46:21','',''),(1538,'1','313','1',1,'Retail Sale Id 1578',157898.90,0.00,0.00,235.67,15318.55,'2023-03-05 14:04:53','',''),(1539,'1','313','1',1,'Retail Sale Id 1579',1420.00,0.00,0.00,2.00,210.00,'2023-03-05 14:06:27','',''),(1540,'1','313','1',1,'Retail Sale Id 1580',710.00,0.00,0.00,1.00,105.00,'2023-03-05 14:07:48','',''),(1541,'1','313','1',1,'Retail Sale Id 1581',4260.00,0.00,0.00,6.00,630.00,'2023-03-05 14:09:22','',''),(1542,'1','313','1',1,'Return of Retail Sale Id 1570',0.00,160800.00,240.00,0.00,-15600.00,'2023-03-05 14:11:30','',''),(1543,'1','313','1',1,'Retail Sale Id 1582',6700.00,0.00,0.00,10.00,650.00,'2023-03-05 14:12:35','',''),(1544,'1','313','1',1,'Retail Sale Id 1583',710.00,0.00,0.00,1.00,105.00,'2023-03-05 14:14:50','',''),(1545,'1','313','1',1,'Retail Sale Id 1584',40200.00,0.00,0.00,60.00,3900.00,'2023-03-05 14:15:56','',''),(1546,'1','313','1',1,'Retail Sale Id 1585',1420.00,0.00,0.00,2.00,210.00,'2023-03-05 14:17:48','',''),(1547,'1','313','1',1,'Retail Sale Id 1586',7100.00,0.00,0.00,10.00,1050.00,'2023-03-05 14:19:04','',''),(1548,'1','313','1',1,'Retail Sale Id 1587',4260.00,0.00,0.00,6.00,630.00,'2023-03-05 14:30:44','',''),(1549,'1','313','1',1,'Retail Sale Id 1588',8520.00,0.00,0.00,12.00,1260.00,'2023-03-05 14:42:28','',''),(1550,'1','313','1',1,'Retail Sale Id 1589',710.00,0.00,0.00,1.00,105.00,'2023-03-05 14:44:17','',''),(1551,'1','313','1',1,'Retail Sale Id 1590',40200.00,0.00,0.00,60.00,3900.00,'2023-03-05 14:46:20','',''),(1552,'1','313','1',1,'Retail Sale Id 1591',752.60,0.00,0.00,1.06,111.30,'2023-03-05 14:49:43','',''),(1553,'1','313','1',1,'Retail Sale Id 1592',2130.00,0.00,0.00,3.00,315.00,'2023-03-05 14:52:29','',''),(1554,'1','313','1',1,'Retail Sale Id 1593',2002.20,0.00,0.00,2.82,296.10,'2023-03-05 14:54:12','',''),(1555,'1','313','1',1,'Retail Sale Id 1594',1902.80,0.00,0.00,2.68,281.40,'2023-03-05 14:57:25','',''),(1556,'1','313','1',1,'Retail Sale Id 1595',2840.00,0.00,0.00,4.00,420.00,'2023-03-05 14:59:02','',''),(1557,'1','313','1',1,'Retail Sale Id 1596',4260.00,0.00,0.00,6.00,630.00,'2023-03-05 15:00:34','',''),(1558,'1','313','1',1,'Retail Sale Id 1597',4260.00,0.00,0.00,6.00,630.00,'2023-03-05 15:01:56','',''),(1559,'1','313','1',1,'Retail Sale Id 1598',3550.00,0.00,0.00,5.00,525.00,'2023-03-05 15:05:44','',''),(1560,'1','313','1',1,'Retail Sale Id 1599',33500.00,0.00,0.00,50.00,3250.00,'2023-03-05 15:08:05','',''),(1561,'1','313','1',1,'Retail Sale Id 1600',4260.00,0.00,0.00,6.00,630.00,'2023-03-05 15:09:43','',''),(1562,'1','313','1',1,'Retail Sale Id 1601',3550.00,0.00,0.00,5.00,525.00,'2023-03-05 15:16:46','',''),(1563,'1','313','1',1,'Retail Sale Id 1602',1448.40,0.00,0.00,2.04,214.20,'2023-03-05 15:18:25','',''),(1564,'1','313','1',1,'Retail Sale Id 1603',752.60,0.00,0.00,1.06,111.30,'2023-03-05 15:24:40','',''),(1565,'1','313','1',1,'Retail Sale Id 1604',33500.00,0.00,0.00,50.00,3250.00,'2023-03-05 15:28:39','',''),(1566,'1','313','1',1,'Retail Sale Id 1605',1420.00,0.00,0.00,2.00,210.00,'2023-03-05 15:32:47','',''),(1567,'1','313','1',1,'Retail Sale Id 1606',2130.00,0.00,0.00,3.00,315.00,'2023-03-05 15:34:41','',''),(1568,'1','313','1',1,'Retail Sale Id 1607',752.60,0.00,0.00,1.06,111.30,'2023-03-05 15:35:55','',''),(1569,'1','313','1',1,'Retail Sale Id 1608',8875.00,0.00,0.00,12.50,1312.50,'2023-03-05 15:37:03','',''),(1570,'1','313','1',1,'Retail Sale Id 1609',2151.30,0.00,0.00,3.03,318.15,'2023-03-05 15:38:13','',''),(1571,'1','313','1',1,'Retail Sale Id 1610',1420.00,0.00,0.00,2.00,210.00,'2023-03-05 15:44:50','',''),(1572,'1','313','1',1,'Return of Retail Sale Id 1604',0.00,33500.00,50.00,0.00,-3250.00,'2023-03-05 15:46:23','',''),(1573,'1','313','1',1,'Retail Sale Id 1611',1420.00,0.00,0.00,2.00,210.00,'2023-03-05 15:57:21','',''),(1574,'1','313','1',1,'Retail Sale Id 1612',752.60,0.00,0.00,1.06,111.30,'2023-03-05 16:00:56','',''),(1575,'1','313','1',1,'Retail Sale Id 1613',752.60,0.00,0.00,1.06,111.30,'2023-03-05 16:05:45','',''),(1576,'1','313','1',1,'Retail Sale Id 1614',8875.00,0.00,0.00,12.50,1312.50,'2023-03-05 16:08:00','',''),(1577,'1','313','1',1,'Retail Sale Id 1616',23450.00,0.00,0.00,35.00,2275.00,'2023-03-05 16:14:24','',''),(1578,'1','313','1',1,'Retail Sale Id 1617',8875.00,0.00,0.00,12.50,1312.50,'2023-03-05 16:16:50','',''),(1579,'1','313','1',1,'Retail Sale Id 1618',1420.00,0.00,0.00,2.00,210.00,'2023-03-05 16:18:15','',''),(1580,'1','313','1',1,'Retail Sale Id 1619',1420.00,0.00,0.00,2.00,210.00,'2023-03-05 16:23:55','',''),(1581,'1','313','1',1,'Retail Sale Id 1620',3550.00,0.00,0.00,5.00,525.00,'2023-03-05 16:25:20','',''),(1582,'1','313','1',1,'Retail Sale Id 1621',9230.00,0.00,0.00,13.00,1365.00,'2023-03-05 16:32:14','',''),(1583,'1','313','1',1,'Retail Sale Id 1622',1001.10,0.00,0.00,1.41,148.05,'2023-03-05 16:47:45','',''),(1584,'1','313','1',1,'Retail Sale Id 1623',1498.10,0.00,0.00,2.11,221.55,'2023-03-05 16:57:48','',''),(1585,'1','313','1',1,'Return of Retail Sale Id 1572',0.00,2130.00,3.00,0.00,-315.00,'2023-03-05 17:15:12','',''),(1586,'1','313','1',1,'Retail Sale Id 1625',1867.30,0.00,0.00,2.63,276.15,'2023-03-05 17:16:01','',''),(1587,'1','313','1',1,'Return of Retail Sale Id 1559',0.00,33500.00,50.00,0.00,-3250.00,'2023-03-05 17:19:10','',''),(1588,'1','313','1',1,'Retail Sale Id 1626',33479.90,0.00,0.00,49.97,3248.05,'2023-03-05 17:19:57','',''),(1589,'1','313','1',1,'Retail Sale Id 1627',710.00,0.00,0.00,1.00,105.00,'2023-03-06 08:01:16','',''),(1590,'1','313','1',1,'Retail Sale Id 1628',752.60,0.00,0.00,1.06,111.30,'2023-03-06 08:02:12','',''),(1591,'1','313','1',1,'Retail Sale Id 1629',2840.00,0.00,0.00,4.00,420.00,'2023-03-06 08:03:36','',''),(1592,'1','313','1',1,'Retail Sale Id 1630',710.00,0.00,0.00,1.00,105.00,'2023-03-06 08:04:22','',''),(1593,'1','313','1',1,'Retail Sale Id 1631',2840.00,0.00,0.00,4.00,420.00,'2023-03-06 08:05:16','',''),(1594,'1','313','1',1,'Retail Sale Id 1632',1498.10,0.00,0.00,2.11,221.55,'2023-03-06 08:06:10','',''),(1595,'1','313','1',1,'Retail Sale Id 1633',3550.00,0.00,0.00,5.00,525.00,'2023-03-06 08:07:53','',''),(1596,'1','313','1',1,'Retail Sale Id 1634',3550.00,0.00,0.00,5.00,525.00,'2023-03-06 08:09:09','',''),(1597,'1','313','1',1,'Retail Sale Id 1635',2840.00,0.00,0.00,4.00,420.00,'2023-03-06 08:10:18','',''),(1598,'1','313','1',1,'Retail Sale Id 1637',2101.60,0.00,0.00,2.96,310.80,'2023-03-06 08:12:54','',''),(1599,'1','313','1',1,'Retail Sale Id 1638',7000.60,0.00,0.00,9.86,1035.30,'2023-03-06 08:13:57','',''),(1600,'1','313','1',1,'Retail Sale Id 1639',33500.00,0.00,0.00,50.00,3250.00,'2023-03-06 08:15:31','',''),(1601,'1','313','1',1,'Retail Sale Id 1640',10650.00,0.00,0.00,15.00,1575.00,'2023-03-06 08:16:32','',''),(1602,'1','313','1',1,'Retail Sale Id 1641',7100.00,0.00,0.00,10.00,1050.00,'2023-03-06 08:17:53','',''),(1603,'1','313','1',1,'Retail Sale Id 1642',4970.00,0.00,0.00,7.00,735.00,'2023-03-06 08:19:13','',''),(1604,'1','313','1',1,'Retail Sale Id 1643',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 08:20:56','',''),(1605,'1','313','1',1,'Retail Sale Id 1644',1448.40,0.00,0.00,2.04,214.20,'2023-03-06 08:24:26','',''),(1606,'1','313','1',1,'Retail Sale Id 1645',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 08:26:17','',''),(1607,'1','313','1',1,'Retail Sale Id 1646',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 08:27:08','',''),(1608,'1','313','1',1,'Retail Sale Id 1647',22010.00,0.00,0.00,31.00,3255.00,'2023-03-06 08:30:33','',''),(1609,'1','313','1',1,'Retail Sale Id 1648',710.00,0.00,0.00,1.00,105.00,'2023-03-06 08:30:59','',''),(1610,'1','313','1',1,'Retail Sale Id 1649',5680.00,0.00,0.00,8.00,840.00,'2023-03-06 08:33:19','',''),(1611,'1','313','1',1,'Retail Sale Id 1650',710.00,0.00,0.00,1.00,105.00,'2023-03-06 08:34:38','',''),(1612,'1','313','1',1,'Retail Sale Id 1651',4970.00,0.00,0.00,7.00,735.00,'2023-03-06 08:35:30','',''),(1613,'1','313','1',1,'Retail Sale Id 1652',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 08:37:14','',''),(1614,'1','313','1',1,'Retail Sale Id 1653',710.00,0.00,0.00,1.00,105.00,'2023-03-06 08:38:22','',''),(1615,'1','313','1',1,'Retail Sale Id 1654',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 08:44:28','',''),(1616,'1','313','1',1,'Retail Sale Id 1655',3550.00,0.00,0.00,5.00,525.00,'2023-03-06 08:45:42','',''),(1617,'1','313','1',1,'Retail Sale Id 1656',40387.60,0.00,0.00,60.28,3918.20,'2023-03-06 08:47:48','',''),(1618,'1','313','1',1,'Retail Sale Id 1657',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 08:52:06','',''),(1619,'1','313','1',1,'Retail Sale Id 1658',2485.00,0.00,0.00,3.50,367.50,'2023-03-06 08:53:49','',''),(1620,'1','313','1',1,'Retail Sale Id 1659',40200.00,0.00,0.00,60.00,3900.00,'2023-03-06 08:55:05','',''),(1621,'1','313','1',1,'Retail Sale Id 1660',3550.00,0.00,0.00,5.00,525.00,'2023-03-06 08:56:29','',''),(1622,'1','313','1',1,'Retail Sale Id 1661',3003.30,0.00,0.00,4.23,444.15,'2023-03-06 08:58:27','',''),(1623,'1','313','1',1,'Retail Sale Id 1662',752.60,0.00,0.00,1.06,111.30,'2023-03-06 08:59:57','',''),(1624,'1','313','1',1,'Retail Sale Id 1663',710.00,0.00,0.00,1.00,105.00,'2023-03-06 09:01:00','',''),(1625,'1','313','1',1,'Return of Retail Sale Id 1649',0.00,5680.00,8.00,0.00,-840.00,'2023-03-06 09:02:38','',''),(1626,'1','313','1',1,'Retail Sale Id 1664',5254.00,0.00,0.00,7.40,777.00,'2023-03-06 09:03:19','',''),(1627,'1','313','1',1,'Retail Sale Id 1665',33500.00,0.00,0.00,50.00,3250.00,'2023-03-06 09:09:50','',''),(1628,'1','313','1',1,'Retail Sale Id 1666',5680.00,0.00,0.00,8.00,840.00,'2023-03-06 09:11:13','',''),(1629,'1','313','1',1,'Retail Sale Id 1668',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 09:12:58','',''),(1630,'1','313','1',1,'Retail Sale Id 1669',80400.00,0.00,0.00,120.00,7800.00,'2023-03-06 09:14:19','',''),(1631,'1','313','1',1,'Retail Sale Id 1670',752.60,0.00,0.00,1.06,111.30,'2023-03-06 09:15:18','',''),(1632,'1','313','1',1,'Retail Sale Id 1671',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 09:16:27','',''),(1633,'1','313','1',1,'Retail Sale Id 1672',710.00,0.00,0.00,1.00,105.00,'2023-03-06 09:17:29','',''),(1634,'1','313','1',1,'Retail Sale Id 1673',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 09:18:48','',''),(1635,'1','313','1',1,'Retail Sale Id 1674',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 09:20:57','',''),(1636,'1','313','1',1,'Retail Sale Id 1675',4260.00,0.00,0.00,6.00,630.00,'2023-03-06 09:27:12','',''),(1637,'1','313','1',1,'Retail Sale Id 1676',3550.00,0.00,0.00,5.00,525.00,'2023-03-06 09:28:28','',''),(1638,'1','313','1',1,'Retail Sale Id 1677',8520.00,0.00,0.00,12.00,1260.00,'2023-03-06 09:30:06','',''),(1639,'1','313','1',1,'Retail Sale Id 1678',4970.00,0.00,0.00,7.00,735.00,'2023-03-06 09:31:39','',''),(1640,'1','313','1',1,'Retail Sale Id 1679',4260.00,0.00,0.00,6.00,630.00,'2023-03-06 09:32:52','',''),(1641,'1','313','1',1,'Retail Sale Id 1680',752.60,0.00,0.00,1.06,111.30,'2023-03-06 09:34:20','',''),(1642,'1','313','1',1,'Retail Sale Id 1681',4260.00,0.00,0.00,6.00,630.00,'2023-03-06 09:35:36','',''),(1643,'1','313','1',1,'Retail Sale Id 1682',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 09:36:52','',''),(1644,'1','313','1',1,'Retail Sale Id 1683',8875.00,0.00,0.00,12.50,1312.50,'2023-03-06 09:38:27','',''),(1645,'1','313','1',1,'Retail Sale Id 1684',4260.00,0.00,0.00,6.00,630.00,'2023-03-06 09:39:46','',''),(1646,'1','313','1',1,'Retail Sale Id 1685',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 09:42:14','',''),(1647,'1','313','1',1,'Retail Sale Id 1686',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 09:43:20','',''),(1648,'1','313','1',1,'Retail Sale Id 1687',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 09:44:43','',''),(1649,'1','313','1',1,'Retail Sale Id 1688',5680.00,0.00,0.00,8.00,840.00,'2023-03-06 09:47:46','',''),(1650,'1','313','1',1,'Retail Sale Id 1689',4970.00,0.00,0.00,7.00,735.00,'2023-03-06 09:50:47','',''),(1651,'1','313','1',1,'Retail Sale Id 1690',710.00,0.00,0.00,1.00,105.00,'2023-03-06 09:52:40','',''),(1652,'1','313','1',1,'Retail Sale Id 1691',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 09:55:34','',''),(1653,'1','313','1',1,'Retail Sale Id 1693',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 10:02:03','',''),(1654,'1','313','1',1,'Retail Sale Id 1694',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 10:03:10','',''),(1655,'1','313','1',1,'Retail Sale Id 1695',2840.00,0.00,0.00,4.00,420.00,'2023-03-06 10:04:59','',''),(1656,'1','313','1',1,'Retail Sale Id 1696',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 10:07:59','',''),(1657,'1','313','1',1,'Retail Sale Id 1697',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 10:18:01','',''),(1658,'1','313','1',1,'Retail Sale Id 1698',3997.30,0.00,0.00,5.63,591.15,'2023-03-06 10:20:19','',''),(1659,'1','313','1',1,'Retail Sale Id 1699',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 10:21:46','',''),(1660,'1','313','1',1,'Retail Sale Id 1700',2840.00,0.00,0.00,4.00,420.00,'2023-03-06 10:23:05','',''),(1661,'1','313','1',1,'Retail Sale Id 1701',39818.10,0.00,0.00,59.43,3862.95,'2023-03-06 10:26:21','',''),(1662,'1','313','1',1,'Retail Sale Id 1702',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 10:30:05','',''),(1663,'1','313','1',1,'Retail Sale Id 1703',5680.00,0.00,0.00,8.00,840.00,'2023-03-06 10:32:00','',''),(1664,'1','313','1',1,'Retail Sale Id 1704',40903.50,0.00,0.00,61.05,3968.25,'2023-03-06 10:34:31','',''),(1665,'1','313','1',1,'Retail Sale Id 1705',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 10:38:08','',''),(1666,'1','313','1',1,'Retail Sale Id 1706',1448.40,0.00,0.00,2.04,214.20,'2023-03-06 10:39:23','',''),(1667,'1','313','1',1,'Retail Sale Id 1707',710.00,0.00,0.00,1.00,105.00,'2023-03-06 10:40:48','',''),(1668,'1','313','1',1,'Retail Sale Id 1708',752.60,0.00,0.00,1.06,111.30,'2023-03-06 10:41:39','',''),(1669,'1','313','1',1,'Retail Sale Id 1709',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 10:54:26','',''),(1670,'1','313','1',1,'Retail Sale Id 1710',3550.00,0.00,0.00,5.00,525.00,'2023-03-06 11:02:13','',''),(1671,'1','313','1',1,'Retail Sale Id 1711',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 11:05:29','',''),(1672,'1','313','1',1,'Retail Sale Id 1712',4260.00,0.00,0.00,6.00,630.00,'2023-03-06 11:08:14','',''),(1673,'1','313','1',1,'Retail Sale Id 1713',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 11:11:37','',''),(1674,'1','313','1',1,'Retail Sale Id 1714',5680.00,0.00,0.00,8.00,840.00,'2023-03-06 11:13:44','',''),(1675,'1','313','1',1,'Retail Sale Id 1715',8520.00,0.00,0.00,12.00,1260.00,'2023-03-06 11:15:13','',''),(1676,'1','313','1',1,'Retail Sale Id 1716',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 11:16:16','',''),(1677,'1','313','1',1,'Retail Sale Id 1717',3550.00,0.00,0.00,5.00,525.00,'2023-03-06 11:18:32','',''),(1678,'1','313','1',1,'Retail Sale Id 1718',7100.00,0.00,0.00,10.00,1050.00,'2023-03-06 11:20:45','',''),(1679,'1','313','1',1,'Retail Sale Id 1719',4970.00,0.00,0.00,7.00,735.00,'2023-03-06 11:22:20','',''),(1680,'1','313','1',1,'Retail Sale Id 1720',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 11:23:58','',''),(1681,'1','313','1',1,'Retail Sale Id 1721',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 11:25:04','',''),(1682,'1','313','1',1,'Retail Sale Id 1722',2151.30,0.00,0.00,3.03,318.15,'2023-03-06 11:28:38','',''),(1683,'1','313','1',1,'Retail Sale Id 1723',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 11:37:34','',''),(1684,'1','313','1',1,'Retail Sale Id 1724',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 11:39:52','',''),(1685,'1','313','1',1,'Retail Sale Id 1725',710.00,0.00,0.00,1.00,105.00,'2023-03-06 11:40:54','',''),(1686,'1','313','1',1,'Retail Sale Id 1726',4020.00,0.00,0.00,6.00,390.00,'2023-03-06 11:42:12','',''),(1687,'1','313','1',1,'Retail Sale Id 1727',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 11:43:13','',''),(1688,'1','313','1',1,'Retail Sale Id 1728',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 11:49:40','',''),(1689,'1','313','1',1,'Retail Sale Id 1729',33500.00,0.00,0.00,50.00,3250.00,'2023-03-06 11:55:20','',''),(1690,'1','313','1',1,'Retail Sale Id 1730',24120.00,0.00,0.00,36.00,2340.00,'2023-03-06 11:56:57','',''),(1691,'1','313','1',1,'Return of Retail Sale Id 1730',0.00,24120.00,36.00,0.00,-2340.00,'2023-03-06 11:57:59','',''),(1692,'1','313','1',1,'Retail Sale Id 1731',23999.40,0.00,0.00,35.82,2328.30,'2023-03-06 12:00:08','',''),(1693,'1','313','1',1,'Retail Sale Id 1732',2840.00,0.00,0.00,4.00,420.00,'2023-03-06 12:04:17','',''),(1694,'1','313','1',1,'Retail Sale Id 1733',752.60,0.00,0.00,1.06,111.30,'2023-03-06 12:08:32','',''),(1695,'1','313','1',1,'Retail Sale Id 1734',3550.00,0.00,0.00,5.00,525.00,'2023-03-06 12:09:57','',''),(1696,'1','313','1',1,'Retail Sale Id 1736',4970.00,0.00,0.00,7.00,735.00,'2023-03-06 12:15:13','',''),(1697,'1','313','1',1,'Retail Sale Id 1737',5680.00,0.00,0.00,8.00,840.00,'2023-03-06 12:16:39','',''),(1698,'1','313','1',1,'Retail Sale Id 1738',3727.50,0.00,0.00,5.25,551.25,'2023-03-06 12:22:55','',''),(1699,'1','313','1',1,'Retail Sale Id 1739',1001.10,0.00,0.00,1.41,148.05,'2023-03-06 12:25:21','',''),(1700,'1','313','1',1,'Retail Sale Id 1740',41345.70,0.00,0.00,61.71,4011.15,'2023-03-06 12:27:15','',''),(1701,'1','313','1',1,'Retail Sale Id 1741',81103.50,0.00,0.00,121.05,7868.25,'2023-03-06 12:28:09','',''),(1702,'1','313','1',1,'Retail Sale Id 1743',7000.60,0.00,0.00,9.86,1035.30,'2023-03-06 12:39:00','',''),(1703,'1','313','1',1,'Retail Sale Id 1744',7100.00,0.00,0.00,10.00,1050.00,'2023-03-06 12:41:21','',''),(1704,'1','313','1',1,'Retail Sale Id 1745',2002.20,0.00,0.00,2.82,296.10,'2023-03-06 12:42:46','',''),(1705,'1','313','1',1,'Retail Sale Id 1746',2485.00,0.00,0.00,3.50,367.50,'2023-03-06 12:44:24','',''),(1706,'1','313','1',1,'Retail Sale Id 1747',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 12:46:15','',''),(1707,'1','313','1',1,'Retail Sale Id 1748',12780.00,0.00,0.00,18.00,1890.00,'2023-03-06 12:48:59','',''),(1708,'1','313','1',1,'Retail Sale Id 1749',2151.30,0.00,0.00,3.03,318.15,'2023-03-06 12:55:03','',''),(1709,'1','313','1',1,'Retail Sale Id 1750',1498.10,0.00,0.00,2.11,221.55,'2023-03-06 12:58:53','',''),(1710,'1','313','1',1,'Retail Sale Id 1751',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 13:08:47','',''),(1711,'1','313','1',1,'Retail Sale Id 1752',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 13:17:30','',''),(1712,'1','313','1',1,'Retail Sale Id 1753',4260.00,0.00,0.00,6.00,630.00,'2023-03-06 13:20:20','',''),(1713,'1','313','1',1,'Retail Sale Id 1755',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 13:22:32','',''),(1714,'1','313','1',1,'Retail Sale Id 1756',4260.00,0.00,0.00,6.00,630.00,'2023-03-06 13:23:46','',''),(1715,'1','313','1',1,'Retail Sale Id 1757',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 13:25:02','',''),(1716,'1','313','1',1,'Retail Sale Id 1758',710.00,0.00,0.00,1.00,105.00,'2023-03-06 13:27:07','',''),(1717,'1','313','1',1,'Retail Sale Id 1759',710.00,0.00,0.00,1.00,105.00,'2023-03-06 13:27:49','',''),(1718,'1','313','1',1,'Retail Sale Id 1760',8875.00,0.00,0.00,12.50,1312.50,'2023-03-06 13:28:59','',''),(1719,'1','313','1',1,'Retail Sale Id 1761',4260.00,0.00,0.00,6.00,630.00,'2023-03-06 13:30:24','',''),(1720,'1','313','1',1,'Retail Sale Id 1762',710.00,0.00,0.00,1.00,105.00,'2023-03-06 13:31:57','',''),(1721,'1','313','1',1,'Retail Sale Id 1764',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 13:40:38','',''),(1722,'1','313','1',1,'Retail Sale Id 1765',2485.00,0.00,0.00,3.50,367.50,'2023-03-06 13:53:05','',''),(1723,'1','313','1',1,'Retail Sale Id 1766',3550.00,0.00,0.00,5.00,525.00,'2023-03-06 13:56:34','',''),(1724,'1','313','1',1,'Retail Sale Id 1767',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 14:00:34','',''),(1725,'1','313','1',1,'Retail Sale Id 1768',4260.00,0.00,0.00,6.00,630.00,'2023-03-06 14:03:57','',''),(1726,'1','313','1',1,'Retail Sale Id 1769',5680.00,0.00,0.00,8.00,840.00,'2023-03-06 14:09:18','',''),(1727,'1','313','1',1,'Retail Sale Id 1771',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 14:26:17','',''),(1728,'1','313','1',1,'Retail Sale Id 1772',30525.20,0.00,0.00,45.56,2961.40,'2023-03-06 14:39:34','',''),(1729,'1','313','1',1,'Retail Sale Id 1773',3550.00,0.00,0.00,5.00,525.00,'2023-03-06 14:40:57','',''),(1730,'1','313','1',1,'Retail Sale Id 1774',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 14:42:14','',''),(1731,'1','313','1',1,'Retail Sale Id 1775',7100.00,0.00,0.00,10.00,1050.00,'2023-03-06 14:44:01','',''),(1732,'1','313','1',1,'Retail Sale Id 1776',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 14:45:17','',''),(1733,'1','313','1',1,'Retail Sale Id 1777',1498.10,0.00,0.00,2.11,221.55,'2023-03-06 14:48:15','',''),(1734,'1','313','1',1,'Retail Sale Id 1778',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 14:50:23','',''),(1735,'1','313','1',1,'Retail Sale Id 1780',17750.00,0.00,0.00,25.00,2625.00,'2023-03-06 14:51:57','',''),(1736,'1','313','1',1,'Retail Sale Id 1781',2010.00,0.00,0.00,3.00,195.00,'2023-03-06 14:53:26','',''),(1737,'1','313','1',1,'Retail Sale Id 1782',4970.00,0.00,0.00,7.00,735.00,'2023-03-06 14:54:45','',''),(1738,'1','313','1',1,'Retail Sale Id 1783',752.60,0.00,0.00,1.06,111.30,'2023-03-06 14:56:03','',''),(1739,'1','313','1',1,'Retail Sale Id 1784',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 14:58:22','',''),(1740,'1','313','1',1,'Retail Sale Id 1785',3550.00,0.00,0.00,5.00,525.00,'2023-03-06 15:00:23','',''),(1741,'1','313','1',1,'Retail Sale Id 1786',4970.00,0.00,0.00,7.00,735.00,'2023-03-06 15:06:16','',''),(1742,'1','313','1',1,'Retail Sale Id 1787',710.00,0.00,0.00,1.00,105.00,'2023-03-06 15:08:05','',''),(1743,'1','313','1',1,'Retail Sale Id 1788',710.00,0.00,0.00,1.00,105.00,'2023-03-06 15:08:52','',''),(1744,'1','313','1',1,'Retail Sale Id 1789',710.00,0.00,0.00,1.00,105.00,'2023-03-06 15:10:37','',''),(1745,'1','313','1',1,'Retail Sale Id 1790',32830.00,0.00,0.00,49.00,3185.00,'2023-03-06 15:13:09','',''),(1746,'1','313','1',1,'Retail Sale Id 1791',8875.00,0.00,0.00,12.50,1312.50,'2023-03-06 15:14:50','',''),(1747,'1','313','1',1,'Retail Sale Id 1792',4260.00,0.00,0.00,6.00,630.00,'2023-03-06 15:16:44','',''),(1748,'1','313','1',1,'Retail Sale Id 1793',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 15:17:42','',''),(1749,'1','313','1',1,'Retail Sale Id 1794',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 15:19:15','',''),(1750,'1','313','1',1,'Retail Sale Id 1795',11360.00,0.00,0.00,16.00,1680.00,'2023-03-06 15:20:15','',''),(1751,'1','313','1',1,'Retail Sale Id 1796',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 15:20:53','',''),(1752,'1','313','1',1,'Retail Sale Id 1797',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 15:21:43','',''),(1753,'1','313','1',1,'Retail Sale Id 1799',8875.00,0.00,0.00,12.50,1312.50,'2023-03-06 15:23:26','',''),(1754,'1','313','1',1,'Retail Sale Id 1800',710.00,0.00,0.00,1.00,105.00,'2023-03-06 15:24:04','',''),(1755,'1','313','1',1,'Retail Sale Id 1801',4970.00,0.00,0.00,7.00,735.00,'2023-03-06 15:26:23','',''),(1756,'1','313','1',1,'Retail Sale Id 1802',710.00,0.00,0.00,1.00,105.00,'2023-03-06 15:28:36','',''),(1757,'1','313','1',1,'Retail Sale Id 1803',33500.00,0.00,0.00,50.00,3250.00,'2023-03-06 15:29:54','',''),(1758,'1','313','1',1,'Retail Sale Id 1804',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 15:31:26','',''),(1759,'1','313','1',1,'Retail Sale Id 1805',4970.00,0.00,0.00,7.00,735.00,'2023-03-06 15:33:13','',''),(1760,'1','313','1',1,'Retail Sale Id 1806',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 15:35:42','',''),(1761,'1','313','1',1,'Retail Sale Id 1807',2840.00,0.00,0.00,4.00,420.00,'2023-03-06 15:37:49','',''),(1762,'1','313','1',1,'Retail Sale Id 1808',2840.00,0.00,0.00,4.00,420.00,'2023-03-06 15:39:04','',''),(1763,'1','313','1',1,'Retail Sale Id 1809',3550.00,0.00,0.00,5.00,525.00,'2023-03-06 15:40:02','',''),(1764,'1','313','1',1,'Retail Sale Id 1810',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 15:40:44','',''),(1765,'1','313','1',1,'Retail Sale Id 1812',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 15:41:57','',''),(1766,'1','313','1',1,'Retail Sale Id 1813',3550.00,0.00,0.00,5.00,525.00,'2023-03-06 15:44:06','',''),(1767,'1','313','1',1,'Retail Sale Id 1814',7100.00,0.00,0.00,10.00,1050.00,'2023-03-06 15:45:18','',''),(1768,'1','313','1',1,'Retail Sale Id 1815',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 15:47:32','',''),(1769,'1','313','1',1,'Retail Sale Id 1816',2840.00,0.00,0.00,4.00,420.00,'2023-03-06 15:49:08','',''),(1770,'1','313','1',1,'Retail Sale Id 1817',2840.00,0.00,0.00,4.00,420.00,'2023-03-06 15:50:50','',''),(1771,'1','313','1',1,'Retail Sale Id 1818',710.00,0.00,0.00,1.00,105.00,'2023-03-06 15:51:52','',''),(1772,'1','313','1',1,'Retail Sale Id 1819',8520.00,0.00,0.00,12.00,1260.00,'2023-03-06 15:53:10','',''),(1773,'1','313','1',1,'Retail Sale Id 1820',3550.00,0.00,0.00,5.00,525.00,'2023-03-06 15:53:52','',''),(1774,'1','313','1',1,'Retail Sale Id 1822',752.60,0.00,0.00,1.06,111.30,'2023-03-06 15:55:40','',''),(1775,'1','313','1',1,'Retail Sale Id 1824',8875.00,0.00,0.00,12.50,1312.50,'2023-03-06 15:57:17','',''),(1776,'1','313','1',1,'Retail Sale Id 1825',752.60,0.00,0.00,1.06,111.30,'2023-03-06 15:59:46','',''),(1777,'1','313','1',1,'Retail Sale Id 1826',752.60,0.00,0.00,1.06,111.30,'2023-03-06 16:01:19','',''),(1778,'1','313','1',1,'Retail Sale Id 1827',3550.00,0.00,0.00,5.00,525.00,'2023-03-06 16:02:38','',''),(1779,'1','313','1',1,'Retail Sale Id 1828',710.00,0.00,0.00,1.00,105.00,'2023-03-06 16:03:34','',''),(1780,'1','313','1',1,'Retail Sale Id 1829',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 16:04:42','',''),(1781,'1','313','1',1,'Retail Sale Id 1830',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 16:05:23','',''),(1782,'1','313','1',1,'Retail Sale Id 1831',3550.00,0.00,0.00,5.00,525.00,'2023-03-06 16:06:03','',''),(1783,'1','313','1',1,'Retail Sale Id 1832',3550.00,0.00,0.00,5.00,525.00,'2023-03-06 16:06:46','',''),(1784,'1','313','1',1,'Retail Sale Id 1833',2840.00,0.00,0.00,4.00,420.00,'2023-03-06 16:12:39','',''),(1785,'1','313','1',1,'Retail Sale Id 1834',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 16:16:22','',''),(1786,'1','313','1',1,'Retail Sale Id 1836',1498.10,0.00,0.00,2.11,221.55,'2023-03-06 16:20:18','',''),(1787,'1','313','1',1,'Retail Sale Id 1837',752.60,0.00,0.00,1.06,111.30,'2023-03-06 16:21:57','',''),(1788,'1','313','1',1,'Return of Retail Sale Id 1837',0.00,752.60,1.06,0.00,-111.30,'2023-03-06 16:22:15','',''),(1789,'1','313','1',1,'Retail Sale Id 1838',752.60,0.00,0.00,1.06,111.30,'2023-03-06 16:22:51','',''),(1790,'1','313','1',1,'Retail Sale Id 1839',1498.10,0.00,0.00,2.11,221.55,'2023-03-06 16:23:54','',''),(1791,'1','313','1',1,'Retail Sale Id 1840',4260.00,0.00,0.00,6.00,630.00,'2023-03-06 16:24:57','',''),(1792,'1','313','1',1,'Retail Sale Id 1841',802.30,0.00,0.00,1.13,118.65,'2023-03-06 16:25:57','',''),(1793,'1','313','1',1,'Retail Sale Id 1842',8875.00,0.00,0.00,12.50,1312.50,'2023-03-06 16:28:40','',''),(1794,'1','313','1',1,'Retail Sale Id 1843',7100.00,0.00,0.00,10.00,1050.00,'2023-03-06 16:30:24','',''),(1795,'1','313','1',1,'Retail Sale Id 1844',2840.00,0.00,0.00,4.00,420.00,'2023-03-06 16:31:35','',''),(1796,'1','313','1',1,'Retail Sale Id 1845',1001.10,0.00,0.00,1.41,148.05,'2023-03-06 16:32:39','',''),(1797,'1','313','1',1,'Return of Retail Sale Id 1845',0.00,1001.10,1.41,0.00,-148.05,'2023-03-06 16:33:05','',''),(1798,'1','313','1',1,'Retail Sale Id 1846',1001.10,0.00,0.00,1.41,148.05,'2023-03-06 16:33:41','',''),(1799,'1','313','1',1,'Retail Sale Id 1847',710.00,0.00,0.00,1.00,105.00,'2023-03-06 16:35:02','',''),(1800,'1','313','1',1,'Retail Sale Id 1848',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 16:36:14','',''),(1801,'1','313','1',1,'Retail Sale Id 1849',1420.00,0.00,0.00,2.00,210.00,'2023-03-06 16:37:30','',''),(1802,'1','313','1',1,'Retail Sale Id 1851',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 16:40:44','',''),(1803,'1','313','1',1,'Retail Sale Id 1852',8875.00,0.00,0.00,12.50,1312.50,'2023-03-06 16:41:55','',''),(1804,'1','313','1',1,'Retail Sale Id 1853',752.60,0.00,0.00,1.06,111.30,'2023-03-06 16:43:40','',''),(1805,'1','313','1',1,'Retail Sale Id 1854',10650.00,0.00,0.00,15.00,1575.00,'2023-03-06 16:45:07','',''),(1806,'1','313','1',1,'Retail Sale Id 1855',80400.00,0.00,0.00,120.00,7800.00,'2023-03-06 16:46:57','',''),(1807,'1','313','1',1,'Retail Sale Id 1856',6390.00,0.00,0.00,9.00,945.00,'2023-03-06 16:48:39','',''),(1808,'1','313','1',1,'Retail Sale Id 1857',10650.00,0.00,0.00,15.00,1575.00,'2023-03-06 16:50:44','',''),(1809,'1','313','1',1,'Retail Sale Id 1858',4260.00,0.00,0.00,6.00,630.00,'2023-03-06 16:53:17','',''),(1810,'1','313','1',1,'Retail Sale Id 1859',2840.00,0.00,0.00,4.00,420.00,'2023-03-06 16:55:45','',''),(1811,'1','313','1',1,'Retail Sale Id 1860',752.60,0.00,0.00,1.06,111.30,'2023-03-06 16:58:02','',''),(1812,'1','313','1',1,'Retail Sale Id 1861',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 16:59:18','',''),(1813,'1','313','1',1,'Retail Sale Id 1862',752.60,0.00,0.00,1.06,111.30,'2023-03-06 17:00:45','',''),(1814,'1','313','1',1,'Retail Sale Id 1863',717.10,0.00,0.00,1.01,106.05,'2023-03-06 17:02:03','',''),(1815,'1','313','1',1,'Retail Sale Id 1864',2130.00,0.00,0.00,3.00,315.00,'2023-03-06 17:03:13','',''),(1816,'1','313','1',1,'Retail Sale Id 1865',710.00,0.00,0.00,1.00,105.00,'2023-03-06 17:07:50','',''),(1817,'1','313','1',1,'Retail Sale Id 1866',3550.00,0.00,0.00,5.00,525.00,'2023-03-06 17:09:02','',''),(1818,'1','313','1',1,'Retail Sale Id 1867',4260.00,0.00,0.00,6.00,630.00,'2023-03-06 17:10:47','',''),(1819,'1','313','1',1,'Retail Sale Id 1868',710.00,0.00,0.00,1.00,105.00,'2023-03-06 17:12:02','',''),(1820,'1','313','1',1,'Retail Sale Id 1869',8875.00,0.00,0.00,12.50,1312.50,'2023-03-06 17:13:25','',''),(1821,'1','313','1',1,'Retail Sale Id 1870',2840.00,0.00,0.00,4.00,420.00,'2023-03-06 17:14:45','',''),(1822,'1','313','1',1,'Retail Sale Id 1871',2840.00,0.00,0.00,4.00,420.00,'2023-03-06 17:15:35','',''),(1823,'1','313','1',1,'Retail Sale Id 1872',3550.00,0.00,0.00,5.00,525.00,'2023-03-06 17:16:36','',''),(1824,'1','313','1',1,'Retail Sale Id 1874',1448.40,0.00,0.00,2.04,214.20,'2023-03-06 17:19:24','',''),(1825,'1','313','1',1,'Return of Retail Sale Id 1864',0.00,2130.00,3.00,0.00,-315.00,'2023-03-06 17:24:41','',''),(1826,'1','313','1',1,'Retail Sale Id 1875',1902.80,0.00,0.00,2.68,281.40,'2023-03-06 18:01:36','',''),(1827,'1','313','1',1,'Return of Retail Sale Id 1790',0.00,32830.00,49.00,0.00,-3185.00,'2023-03-06 18:05:56','',''),(1828,'1','313','1',1,'Retail Sale Id 1877',33004.20,0.00,0.00,49.26,3201.90,'2023-03-06 18:06:48','',''),(1829,'1','313','1',1,'Return of Retail Sale Id 1726',0.00,4020.00,6.00,0.00,-390.00,'2023-03-06 18:14:34','',''),(1830,'1','313','1',1,'Retail Sale Id 1878',3671.60,0.00,0.00,5.48,356.20,'2023-03-06 18:15:35','',''),(1831,'1','313','1',1,'Retail Sale Id 1879',12780.00,0.00,0.00,18.00,1890.00,'2023-03-07 08:54:22','',''),(1832,'1','313','1',1,'Retail Sale Id 1880',4260.00,0.00,0.00,6.00,630.00,'2023-03-07 08:56:54','',''),(1833,'1','313','1',1,'Retail Sale Id 1881',9230.00,0.00,0.00,13.00,1365.00,'2023-03-07 08:57:51','',''),(1834,'1','313','1',1,'Retail Sale Id 1882',134000.00,0.00,0.00,200.00,13000.00,'2023-03-07 09:00:03','',''),(1835,'1','313','1',1,'Retail Sale Id 1883',2130.00,0.00,0.00,3.00,315.00,'2023-03-07 09:00:43','',''),(1836,'1','313','1',1,'Retail Sale Id 1884',2130.00,0.00,0.00,3.00,315.00,'2023-03-07 09:02:01','',''),(1837,'1','313','1',1,'Retail Sale Id 1885',4970.00,0.00,0.00,7.00,735.00,'2023-03-07 09:03:11','',''),(1838,'1','313','1',1,'Retail Sale Id 1886',3550.00,0.00,0.00,5.00,525.00,'2023-03-07 09:05:33','',''),(1839,'1','313','1',1,'Retail Sale Id 1887',710.00,0.00,0.00,1.00,105.00,'2023-03-07 09:06:36','',''),(1840,'1','313','1',1,'Retail Sale Id 1888',1448.40,0.00,0.00,2.04,214.20,'2023-03-07 09:08:35','',''),(1841,'1','313','1',1,'Retail Sale Id 1889',2130.00,0.00,0.00,3.00,315.00,'2023-03-07 09:11:25','',''),(1842,'1','313','1',1,'Retail Sale Id 1890',40200.00,0.00,0.00,60.00,3900.00,'2023-03-07 09:12:20','',''),(1843,'1','313','1',1,'Retail Sale Id 1891',7810.00,0.00,0.00,11.00,1155.00,'2023-03-07 09:13:14','',''),(1844,'1','313','1',1,'Retail Sale Id 1892',2201.00,0.00,0.00,3.10,325.50,'2023-03-07 09:14:22','',''),(1845,'1','313','1',1,'Retail Sale Id 1893',2002.20,0.00,0.00,2.82,296.10,'2023-03-07 09:15:43','',''),(1846,'1','313','1',1,'Retail Sale Id 1894',2840.00,0.00,0.00,4.00,420.00,'2023-03-07 09:16:32','',''),(1847,'1','313','1',1,'Retail Sale Id 1895',2840.00,0.00,0.00,4.00,420.00,'2023-03-07 09:17:42','',''),(1848,'1','313','1',1,'Retail Sale Id 1896',752.60,0.00,0.00,1.06,111.30,'2023-03-07 09:18:57','',''),(1849,'1','313','1',1,'Retail Sale Id 1897',4970.00,0.00,0.00,7.00,735.00,'2023-03-07 09:19:34','',''),(1850,'1','313','1',1,'Retail Sale Id 1898',2151.30,0.00,0.00,3.03,318.15,'2023-03-07 09:20:48','',''),(1851,'1','313','1',1,'Retail Sale Id 1899',2002.20,0.00,0.00,2.82,296.10,'2023-03-07 09:21:43','',''),(1852,'1','313','1',1,'Retail Sale Id 1900',22994.40,0.00,0.00,34.32,2230.80,'2023-03-07 09:22:45','',''),(1853,'1','313','1',1,'Retail Sale Id 1901',752.60,0.00,0.00,1.06,111.30,'2023-03-07 09:24:04','',''),(1854,'1','313','1',1,'Retail Sale Id 1902',1420.00,0.00,0.00,2.00,210.00,'2023-03-07 09:25:29','',''),(1855,'1','313','1',1,'Retail Sale Id 1903',710.00,0.00,0.00,1.00,105.00,'2023-03-07 09:27:21','',''),(1856,'1','313','1',1,'Retail Sale Id 1904',17040.00,0.00,0.00,24.00,2520.00,'2023-03-07 09:28:25','',''),(1857,'1','313','1',1,'Retail Sale Id 1905',82410.00,0.00,0.00,123.00,7995.00,'2023-03-07 09:30:40','',''),(1858,'1','313','1',1,'Retail Sale Id 1906',2598.60,0.00,0.00,3.66,384.30,'2023-03-07 09:32:08','',''),(1859,'1','313','1',1,'Retail Sale Id 1907',40200.00,0.00,0.00,60.00,3900.00,'2023-03-07 09:33:48','',''),(1860,'1','313','1',1,'Retail Sale Id 1908',3550.00,0.00,0.00,5.00,525.00,'2023-03-07 09:34:35','',''),(1861,'1','313','1',1,'Retail Sale Id 1909',710.00,0.00,0.00,1.00,105.00,'2023-03-07 09:35:31','',''),(1862,'1','313','1',1,'Retail Sale Id 1910',33500.00,0.00,0.00,50.00,3250.00,'2023-03-07 09:36:36','',''),(1863,'1','313','1',1,'Retail Sale Id 1911',1420.00,0.00,0.00,2.00,210.00,'2023-03-07 09:37:18','',''),(1864,'1','313','1',1,'Retail Sale Id 1913',1498.10,0.00,0.00,2.11,221.55,'2023-03-07 09:38:53','',''),(1865,'1','313','1',1,'Retail Sale Id 1914',2201.00,0.00,0.00,3.10,325.50,'2023-03-07 09:39:41','',''),(1866,'1','313','1',1,'Retail Sale Id 1915',752.60,0.00,0.00,1.06,111.30,'2023-03-07 09:40:29','',''),(1867,'1','313','1',1,'Retail Sale Id 1917',8875.00,0.00,0.00,12.50,1312.50,'2023-03-07 09:41:25','',''),(1868,'1','313','1',1,'Retail Sale Id 1918',4260.00,0.00,0.00,6.00,630.00,'2023-03-07 09:42:17','',''),(1869,'1','313','1',1,'Retail Sale Id 1919',710.00,0.00,0.00,1.00,105.00,'2023-03-07 09:43:13','',''),(1870,'1','313','1',1,'Retail Sale Id 1920',2130.00,0.00,0.00,3.00,315.00,'2023-03-07 09:43:42','',''),(1871,'1','313','1',1,'Retail Sale Id 1921',3550.00,0.00,0.00,5.00,525.00,'2023-03-07 09:44:28','',''),(1872,'1','313','1',1,'Retail Sale Id 1922',752.60,0.00,0.00,1.06,111.30,'2023-03-07 09:45:01','',''),(1873,'1','313','1',1,'Retail Sale Id 1923',3550.00,0.00,0.00,5.00,525.00,'2023-03-07 09:45:38','',''),(1874,'1','313','1',1,'Retail Sale Id 1924',710.00,0.00,0.00,1.00,105.00,'2023-03-07 09:46:22','',''),(1875,'1','313','1',1,'Retail Sale Id 1925',25460.00,0.00,0.00,38.00,2470.00,'2023-03-07 09:48:02','',''),(1876,'1','313','1',1,'Retail Sale Id 1926',6390.00,0.00,0.00,9.00,945.00,'2023-03-07 09:48:51','',''),(1877,'1','313','1',1,'Retail Sale Id 1927',4260.00,0.00,0.00,6.00,630.00,'2023-03-07 09:50:12','',''),(1878,'1','313','1',1,'Retail Sale Id 1928',1420.00,0.00,0.00,2.00,210.00,'2023-03-07 09:51:09','',''),(1879,'1','313','1',1,'Retail Sale Id 1929',3550.00,0.00,0.00,5.00,525.00,'2023-03-07 09:51:52','',''),(1880,'1','313','1',1,'Retail Sale Id 1930',9940.00,0.00,0.00,14.00,1470.00,'2023-03-07 09:53:14','',''),(1881,'1','313','1',1,'Retail Sale Id 1931',3550.00,0.00,0.00,5.00,525.00,'2023-03-07 09:54:01','',''),(1882,'1','313','1',1,'Retail Sale Id 1932',3550.00,0.00,0.00,5.00,525.00,'2023-03-07 09:54:39','',''),(1883,'1','313','1',1,'Retail Sale Id 1933',1420.00,0.00,0.00,2.00,210.00,'2023-03-07 09:55:41','',''),(1884,'1','313','1',1,'Retail Sale Id 1934',2840.00,0.00,0.00,4.00,420.00,'2023-03-07 09:56:22','',''),(1885,'1','313','1',1,'Retail Sale Id 1935',3550.00,0.00,0.00,5.00,525.00,'2023-03-07 09:57:14','',''),(1886,'1','313','1',1,'Retail Sale Id 1936',3550.00,0.00,0.00,5.00,525.00,'2023-03-07 09:58:06','',''),(1887,'1','313','1',1,'Retail Sale Id 1937',1420.00,0.00,0.00,2.00,210.00,'2023-03-07 09:59:38','',''),(1888,'1','313','1',1,'Retail Sale Id 1938',1420.00,0.00,0.00,2.00,210.00,'2023-03-07 10:05:16','',''),(1889,'1','313','1',1,'Retail Sale Id 1939',2130.00,0.00,0.00,3.00,315.00,'2023-03-07 10:06:37','',''),(1890,'1','313','1',1,'Retail Sale Id 1940',2130.00,0.00,0.00,3.00,315.00,'2023-03-07 10:07:34','',''),(1891,'1','313','1',1,'Retail Sale Id 1941',80400.00,0.00,0.00,120.00,7800.00,'2023-03-07 10:08:56','',''),(1892,'1','313','1',1,'Return of Retail Sale Id 1879',0.00,12780.00,18.00,0.00,-1890.00,'2023-03-07 10:10:26','',''),(1893,'1','313','1',1,'Retail Sale Id 1942',3550.00,0.00,0.00,5.00,525.00,'2023-03-07 10:10:54','',''),(1894,'1','313','1',1,'Retail Sale Id 1943',20100.00,0.00,0.00,30.00,1950.00,'2023-03-07 10:12:39','',''),(1895,'1','313','1',1,'Retail Sale Id 1944',710.00,0.00,0.00,1.00,105.00,'2023-03-07 10:14:08','',''),(1896,'1','313','1',1,'Retail Sale Id 1945',8875.00,0.00,0.00,12.50,1312.50,'2023-03-07 10:15:14','',''),(1897,'1','313','1',1,'Retail Sale Id 1946',3550.00,0.00,0.00,5.00,525.00,'2023-03-07 10:15:54','',''),(1898,'1','313','1',1,'Retail Sale Id 1947',2840.00,0.00,0.00,4.00,420.00,'2023-03-07 10:16:57','',''),(1899,'1','313','1',1,'Retail Sale Id 1948',4260.00,0.00,0.00,6.00,630.00,'2023-03-07 10:18:04','',''),(1900,'1','313','1',1,'Retail Sale Id 1949',3550.00,0.00,0.00,5.00,525.00,'2023-03-07 10:18:52','',''),(1901,'1','313','1',1,'Retail Sale Id 1950',710.00,0.00,0.00,1.00,105.00,'2023-03-07 10:20:22','',''),(1902,'1','313','1',1,'Retail Sale Id 1951',2840.00,0.00,0.00,4.00,420.00,'2023-03-07 10:22:25','',''),(1903,'1','313','1',1,'Retail Sale Id 1952',2840.00,0.00,0.00,4.00,420.00,'2023-03-07 10:23:38','',''),(1904,'1','313','1',1,'Retail Sale Id 1954',1420.00,0.00,0.00,2.00,210.00,'2023-03-07 10:25:45','',''),(1905,'1','313','1',1,'Retail Sale Id 1955',1065.00,0.00,0.00,1.50,157.50,'2023-03-07 10:28:07','',''),(1906,'1','313','1',1,'Retail Sale Id 1956',2840.00,0.00,0.00,4.00,420.00,'2023-03-07 10:29:00','',''),(1907,'1','313','1',1,'Retail Sale Id 1957',710.00,0.00,0.00,1.00,105.00,'2023-03-07 10:30:18','',''),(1908,'1','313','1',1,'Retail Sale Id 1958',2130.00,0.00,0.00,3.00,315.00,'2023-03-07 10:31:07','',''),(1909,'1','313','1',1,'Retail Sale Id 1959',1420.00,0.00,0.00,2.00,210.00,'2023-03-07 10:32:20','',''),(1910,'1','313','1',1,'Retail Sale Id 1960',2130.00,0.00,0.00,3.00,315.00,'2023-03-07 10:34:49','',''),(1911,'1','313','1',1,'Retail Sale Id 1961',2151.30,0.00,0.00,3.03,318.15,'2023-03-07 10:38:46','',''),(1912,'1','313','1',1,'Retail Sale Id 1962',29607.30,0.00,0.00,44.19,2872.35,'2023-03-07 10:40:54','',''),(1913,'1','313','1',1,'Retail Sale Id 1963',2847.10,0.00,0.00,4.01,421.05,'2023-03-07 10:42:20','',''),(1914,'1','313','1',1,'Retail Sale Id 1964',710.00,0.00,0.00,1.00,105.00,'2023-03-07 10:44:55','',''),(1915,'1','313','1',1,'Retail Sale Id 1965',3003.30,0.00,0.00,4.23,444.15,'2023-03-07 10:49:29','',''),(1916,'1','313','1',1,'Retail Sale Id 1966',6390.00,0.00,0.00,9.00,945.00,'2023-03-07 10:53:55','',''),(1917,'1','313','1',1,'Retail Sale Id 1967',4260.00,0.00,0.00,6.00,630.00,'2023-03-07 10:57:41','',''),(1918,'1','313','1',1,'Retail Sale Id 1968',7100.00,0.00,0.00,10.00,1050.00,'2023-03-07 10:59:04','',''),(1919,'1','313','1',1,'Retail Sale Id 1969',1420.00,0.00,0.00,2.00,210.00,'2023-03-07 11:02:29','',''),(1920,'1','313','1',1,'Retail Sale Id 1970',4260.00,0.00,0.00,6.00,630.00,'2023-03-07 11:05:03','',''),(1921,'1','313','1',1,'Retail Sale Id 1971',1420.00,0.00,0.00,2.00,210.00,'2023-03-07 11:07:02','',''),(1922,'1','313','1',1,'Retail Sale Id 1972',2130.00,0.00,0.00,3.00,315.00,'2023-03-07 11:08:26','',''),(1923,'1','313','1',1,'Retail Sale Id 1973',4970.00,0.00,0.00,7.00,735.00,'2023-03-07 11:10:26','',''),(1924,'1','313','1',1,'Retail Sale Id 1974',3550.00,0.00,0.00,5.00,525.00,'2023-03-07 11:12:08','',''),(1925,'1','313','1',1,'Retail Sale Id 1975',4260.00,0.00,0.00,6.00,630.00,'2023-03-07 11:13:40','',''),(1926,'1','313','1',1,'Retail Sale Id 1976',1420.00,0.00,0.00,2.00,210.00,'2023-03-07 11:14:15','',''),(1927,'1','313','1',1,'Retail Sale Id 1977',710.00,0.00,0.00,1.00,105.00,'2023-03-07 11:15:12','',''),(1928,'1','313','1',1,'Retail Sale Id 1978',2130.00,0.00,0.00,3.00,315.00,'2023-03-07 11:19:10','',''),(1929,'1','313','1',1,'Retail Sale Id 1979',2840.00,0.00,0.00,4.00,420.00,'2023-03-07 11:21:19','',''),(1930,'1','313','1',1,'Retail Sale Id 1980',2840.00,0.00,0.00,4.00,420.00,'2023-03-07 11:22:38','',''),(1931,'1','313','1',1,'Retail Sale Id 1981',1420.00,0.00,0.00,2.00,210.00,'2023-03-07 11:23:30','',''),(1932,'1','313','1',1,'Retail Sale Id 1982',1420.00,0.00,0.00,2.00,210.00,'2023-03-07 11:24:58','',''),(1933,'1','313','1',1,'Retail Sale Id 1983',4260.00,0.00,0.00,6.00,630.00,'2023-03-07 11:26:38','',''),(1934,'1','313','1',1,'Retail Sale Id 1984',2130.00,0.00,0.00,3.00,315.00,'2023-03-07 11:30:40','',''),(1935,'1','313','1',1,'Retail Sale Id 1985',1448.40,0.00,0.00,2.04,214.20,'2023-03-07 11:33:10','',''),(1936,'1','313','1',1,'Retail Sale Id 1986',3550.00,0.00,0.00,5.00,525.00,'2023-03-07 11:34:29','',''),(1937,'1','313','1',1,'Retail Sale Id 1987',120600.00,0.00,0.00,180.00,11700.00,'2023-03-07 11:36:26','',''),(1938,'1','313','1',1,'Retail Sale Id 1988',4970.00,0.00,0.00,7.00,735.00,'2023-03-07 11:38:22','',''),(1939,'1','313','1',1,'Retail Sale Id 1989',3550.00,0.00,0.00,5.00,525.00,'2023-03-07 11:40:21','',''),(1940,'1','313','1',1,'Retail Sale Id 1990',4260.00,0.00,0.00,6.00,630.00,'2023-03-07 11:41:52','',''),(1941,'1','313','1',1,'Retail Sale Id 1991',1420.00,0.00,0.00,2.00,210.00,'2023-03-07 11:43:10','',''),(1942,'1','313','1',1,'Retail Sale Id 1992',2130.00,0.00,0.00,3.00,315.00,'2023-03-07 11:48:13','',''),(1943,'1','313','1',1,'Retail Sale Id 1993',2130.00,0.00,0.00,3.00,315.00,'2023-03-07 11:48:57','',''),(1944,'1','313','1',1,'Retail Sale Id 1994',2130.00,0.00,0.00,3.00,315.00,'2023-03-07 11:50:46','',''),(1945,'1','313','1',1,'Retail Sale Id 1995',1420.00,0.00,0.00,2.00,210.00,'2023-03-07 11:59:56','',''),(1946,'1','313','1',1,'Retail Sale Id 1996',3550.00,0.00,0.00,5.00,525.00,'2023-03-07 12:03:26','',''),(1947,'1','313','1',1,'Retail Sale Id 1997',4970.00,0.00,0.00,7.00,735.00,'2023-03-07 12:14:20','',''),(1948,'1','313','1',1,'Retail Sale Id 1998',13400.00,0.00,0.00,20.00,1300.00,'2023-03-07 12:15:40','',''),(1949,'1','313','1',1,'Retail Sale Id 1999',1065.00,0.00,0.00,1.50,157.50,'2023-03-07 12:17:01','',''),(1950,'1','313','1',1,'Retail Sale Id 2000',8520.00,0.00,0.00,12.00,1260.00,'2023-03-07 12:18:15','',''),(1951,'1','313','1',1,'Retail Sale Id 2001',710.00,0.00,0.00,1.00,105.00,'2023-03-07 12:20:08','',''),(1952,'1','313','1',1,'Retail Sale Id 2002',2840.00,0.00,0.00,4.00,420.00,'2023-03-07 12:21:17','',''),(1953,'1','313','1',1,'Retail Sale Id 2003',1420.00,0.00,0.00,2.00,210.00,'2023-03-07 12:24:34','',''),(1954,'1','313','1',1,'Retail Sale Id 2004',7810.00,0.00,0.00,11.00,1155.00,'2023-03-07 12:26:03','',''),(1955,'1','313','1',1,'Retail Sale Id 2005',4260.00,0.00,0.00,6.00,630.00,'2023-03-07 12:27:27','',''),(1956,'1','313','1',1,'Retail Sale Id 2006',1420.00,0.00,0.00,2.00,210.00,'2023-03-07 12:28:36','',''),(1957,'1','313','1',1,'Retail Sale Id 2008',33500.00,0.00,0.00,50.00,3250.00,'2023-03-07 12:31:45','',''),(1958,'1','313','1',1,'Retail Sale Id 2009',7100.00,0.00,0.00,10.00,1050.00,'2023-03-07 12:34:28','',''),(1959,'1','313','1',1,'Retail Sale Id 2010',2130.00,0.00,0.00,3.00,315.00,'2023-03-07 12:35:32','',''),(1960,'1','313','1',1,'Retail Sale Id 2011',33500.00,0.00,0.00,50.00,3250.00,'2023-03-07 12:39:19','',''),(1961,'1','313','1',1,'Retail Sale Id 2012',1420.00,0.00,0.00,2.00,210.00,'2023-03-07 12:41:20','',''),(1962,'1','313','1',1,'Retail Sale Id 2013',1001.10,0.00,0.00,1.41,148.05,'2023-03-07 12:43:52','',''),(1963,'1','313','1',1,'Retail Sale Id 2014',2130.00,0.00,0.00,3.00,315.00,'2023-03-07 12:56:43','',''),(1964,'1','313','1',1,'Retail Sale Id 2015',3550.00,0.00,0.00,5.00,525.00,'2023-03-07 12:57:50','',''),(1965,'1','313','1',1,'Retail Sale Id 2016',43255.20,0.00,0.00,64.56,4196.40,'2023-03-07 13:06:37','',''),(1966,'1','313','1',1,'Return of Retail Sale Id 1900',0.00,22994.40,34.32,0.00,-2230.80,'2023-03-07 13:30:48','',''),(1967,'1','313','1',1,'Retail Sale Id 2017',23309.30,0.00,0.00,34.79,2261.35,'2023-03-07 13:32:28','',''),(1968,'1','313','1',1,'Return of Retail Sale Id 1993',0.00,2130.00,3.00,0.00,-315.00,'2023-03-07 13:35:54','',''),(1969,'1','313','1',1,'Retail Sale Id 2018',1398.70,0.00,0.00,1.97,206.85,'2023-03-07 13:36:41','',''),(1970,'1','313','1',1,'Distributed to OPERATIONAL LOSS for sales id:1',688592.85,0.00,0.00,1138.17,0.00,'2023-03-08 18:25:27','',''),(1971,'1','313',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,15161300.00,25060.00,0.00,0.00,'2023-03-08 18:29:27','',''),(1972,'1','313',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,25000.00,0.00,'2023-03-08 18:30:38','',''),(1973,'1','313','1',1,'Received from bridging 2',0.00,0.00,25000.00,0.00,0.00,'2023-03-08 18:30:38','',''),(1974,'1','313','1',1,'Retail Sale Id 2019',8520.00,0.00,0.00,12.00,1260.00,'2023-03-09 08:27:24','',''),(1975,'1','313','1',1,'Retail Sale Id 2020',5680.00,0.00,0.00,8.00,840.00,'2023-03-09 08:28:39','',''),(1976,'1','313','1',1,'Retail Sale Id 2021',4970.00,0.00,0.00,7.00,735.00,'2023-03-09 08:30:03','',''),(1977,'1','313','1',1,'Retail Sale Id 2022',1448.40,0.00,0.00,2.04,214.20,'2023-03-09 08:33:10','',''),(1978,'1','313','1',1,'Retail Sale Id 2023',27999.30,0.00,0.00,41.79,2716.35,'2023-03-09 08:34:31','',''),(1979,'1','313','1',1,'Retail Sale Id 2024',3003.30,0.00,0.00,4.23,444.15,'2023-03-09 08:36:34','',''),(1980,'1','313','1',1,'Retail Sale Id 2025',7100.00,0.00,0.00,10.00,1050.00,'2023-03-09 08:37:54','',''),(1981,'1','313','1',1,'Retail Sale Id 2026',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 08:39:06','',''),(1982,'1','313','1',1,'Retail Sale Id 2027',710.00,0.00,0.00,1.00,105.00,'2023-03-09 08:40:02','',''),(1983,'1','313','1',1,'Retail Sale Id 2028',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 08:41:11','',''),(1984,'1','313','1',1,'Retail Sale Id 2029',1001.10,0.00,0.00,1.41,148.05,'2023-03-09 08:42:06','',''),(1985,'1','313','1',1,'Retail Sale Id 2030',752.60,0.00,0.00,1.06,111.30,'2023-03-09 08:43:14','',''),(1986,'1','313','1',1,'Retail Sale Id 2031',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 08:44:21','',''),(1987,'1','313','1',1,'Retail Sale Id 2032',6546.20,0.00,0.00,9.22,968.10,'2023-03-09 08:45:23','',''),(1988,'1','313','1',1,'Retail Sale Id 2033',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 08:47:08','',''),(1989,'1','313','1',1,'Retail Sale Id 2034',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 08:47:48','',''),(1990,'1','313','1',1,'Return of Retail Sale Id 2025',0.00,7100.00,10.00,0.00,-1050.00,'2023-03-09 08:49:08','',''),(1991,'1','313','1',1,'Retail Sale Id 2035',710.00,0.00,0.00,1.00,105.00,'2023-03-09 08:49:57','',''),(1992,'1','313','1',1,'Retail Sale Id 2036',4260.00,0.00,0.00,6.00,630.00,'2023-03-09 08:51:11','',''),(1993,'1','313','1',1,'Retail Sale Id 2038',7810.00,0.00,0.00,11.00,1155.00,'2023-03-09 08:54:05','',''),(1994,'1','313','1',1,'Retail Sale Id 2039',1001.10,0.00,0.00,1.41,148.05,'2023-03-09 08:54:57','',''),(1995,'1','313','1',1,'Retail Sale Id 2040',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 08:56:40','',''),(1996,'1','313','1',1,'Retail Sale Id 2041',38190.00,0.00,0.00,57.00,3705.00,'2023-03-09 08:57:50','',''),(1997,'1','313','1',1,'Retail Sale Id 2042',802.30,0.00,0.00,1.13,118.65,'2023-03-09 08:58:44','',''),(1998,'1','313','1',1,'Retail Sale Id 2043',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 08:59:22','',''),(1999,'1','313','1',1,'Retail Sale Id 2044',710.00,0.00,0.00,1.00,105.00,'2023-03-09 09:00:27','',''),(2000,'1','313','1',1,'Retail Sale Id 2045',2002.20,0.00,0.00,2.82,296.10,'2023-03-09 09:01:39','',''),(2001,'1','313','1',1,'Retail Sale Id 2047',5680.00,0.00,0.00,8.00,840.00,'2023-03-09 09:03:00','',''),(2002,'1','313','1',1,'Retail Sale Id 2048',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 09:03:54','',''),(2003,'1','313','1',1,'Retail Sale Id 2049',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 09:06:00','',''),(2004,'1','313','1',1,'Retail Sale Id 2050',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 09:06:44','',''),(2005,'1','313','1',1,'Retail Sale Id 2051',4948.70,0.00,0.00,6.97,731.85,'2023-03-09 09:08:42','',''),(2006,'1','313','1',1,'Retail Sale Id 2052',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 09:09:28','',''),(2007,'1','313','1',1,'Retail Sale Id 2053',4970.00,0.00,0.00,7.00,735.00,'2023-03-09 09:10:50','',''),(2008,'1','313','1',1,'Retail Sale Id 2054',42880.00,0.00,0.00,64.00,4160.00,'2023-03-09 09:11:56','',''),(2009,'1','313','1',1,'Retail Sale Id 2055',8875.00,0.00,0.00,12.50,1312.50,'2023-03-09 09:13:19','',''),(2010,'1','313','1',1,'Retail Sale Id 2056',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 09:14:15','',''),(2011,'1','313','1',1,'Retail Sale Id 2057',802.30,0.00,0.00,1.13,118.65,'2023-03-09 09:14:55','',''),(2012,'1','313','1',1,'Retail Sale Id 2058',1001.10,0.00,0.00,1.41,148.05,'2023-03-09 09:15:50','',''),(2013,'1','313','1',1,'Retail Sale Id 2059',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 09:16:42','',''),(2014,'1','313','1',1,'Retail Sale Id 2060',1498.10,0.00,0.00,2.11,221.55,'2023-03-09 09:17:50','',''),(2015,'1','313','1',1,'Retail Sale Id 2061',1001.10,0.00,0.00,1.41,148.05,'2023-03-09 09:19:04','',''),(2016,'1','313','1',1,'Retail Sale Id 2062',40200.00,0.00,0.00,60.00,3900.00,'2023-03-09 09:22:47','',''),(2017,'1','313','1',1,'Return of Retail Sale Id 2062',0.00,40200.00,60.00,0.00,-3900.00,'2023-03-09 09:23:44','',''),(2018,'1','313','1',1,'Retail Sale Id 2063',134670.00,0.00,0.00,201.00,13065.00,'2023-03-09 09:24:36','',''),(2019,'1','313','1',1,'Retail Sale Id 2064',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 09:25:43','',''),(2020,'1','313','1',1,'Retail Sale Id 2065',710.00,0.00,0.00,1.00,105.00,'2023-03-09 09:26:40','',''),(2021,'1','313','1',1,'Retail Sale Id 2066',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 09:27:29','',''),(2022,'1','313','1',1,'Retail Sale Id 2067',7100.00,0.00,0.00,10.00,1050.00,'2023-03-09 09:28:19','',''),(2023,'1','313','1',1,'Retail Sale Id 2068',1100.50,0.00,0.00,1.55,162.75,'2023-03-09 09:29:09','',''),(2024,'1','313','1',1,'Retail Sale Id 2069',3003.30,0.00,0.00,4.23,444.15,'2023-03-09 09:29:58','',''),(2025,'1','313','1',1,'Retail Sale Id 2070',710.00,0.00,0.00,1.00,105.00,'2023-03-09 09:32:20','',''),(2026,'1','313','1',1,'Retail Sale Id 2071',8875.00,0.00,0.00,12.50,1312.50,'2023-03-09 09:33:26','',''),(2027,'1','313','1',1,'Retail Sale Id 2072',710.00,0.00,0.00,1.00,105.00,'2023-03-09 09:34:16','',''),(2028,'1','313','1',1,'Retail Sale Id 2073',40200.00,0.00,0.00,60.00,3900.00,'2023-03-09 09:35:40','',''),(2029,'1','313','1',1,'Retail Sale Id 2074',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 09:40:59','',''),(2030,'1','313','1',1,'Retail Sale Id 2075',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 09:45:10','',''),(2031,'1','313','1',1,'Retail Sale Id 2076',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 09:46:36','',''),(2032,'1','313','1',1,'Retail Sale Id 2077',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 09:50:40','',''),(2033,'1','313','1',1,'Retail Sale Id 2078',4998.40,0.00,0.00,7.04,739.20,'2023-03-09 09:51:30','',''),(2034,'1','313','1',1,'Retail Sale Id 2079',2840.00,0.00,0.00,4.00,420.00,'2023-03-09 09:54:24','',''),(2035,'1','313','1',1,'Retail Sale Id 2080',710.00,0.00,0.00,1.00,105.00,'2023-03-09 09:56:09','',''),(2036,'1','313','1',1,'Retail Sale Id 2081',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 09:57:26','',''),(2037,'1','313','1',1,'Retail Sale Id 2082',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 09:58:59','',''),(2038,'1','313','1',1,'Retail Sale Id 2083',8875.00,0.00,0.00,12.50,1312.50,'2023-03-09 10:01:55','',''),(2039,'1','313','1',1,'Retail Sale Id 2084',7810.00,0.00,0.00,11.00,1155.00,'2023-03-09 10:03:59','',''),(2040,'1','313','1',1,'Retail Sale Id 2085',133805.70,0.00,0.00,199.71,12981.15,'2023-03-09 10:04:58','',''),(2041,'1','313','1',1,'Return of Retail Sale Id 2063',0.00,134670.00,201.00,0.00,-13065.00,'2023-03-09 10:05:34','',''),(2042,'1','313','1',1,'Retail Sale Id 2086',752.60,0.00,0.00,1.06,111.30,'2023-03-09 10:06:32','',''),(2043,'1','313','1',1,'Retail Sale Id 2087',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 10:08:13','',''),(2044,'1','313','1',1,'Retail Sale Id 2088',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 10:09:02','',''),(2045,'1','313','1',1,'Retail Sale Id 2089',752.60,0.00,0.00,1.06,111.30,'2023-03-09 10:10:37','',''),(2046,'1','313','1',1,'Retail Sale Id 2090',4260.00,0.00,0.00,6.00,630.00,'2023-03-09 10:12:36','',''),(2047,'1','313','1',1,'Retail Sale Id 2091',3003.30,0.00,0.00,4.23,444.15,'2023-03-09 10:14:56','',''),(2048,'1','313','1',1,'Retail Sale Id 2092',33500.00,0.00,0.00,50.00,3250.00,'2023-03-09 10:19:08','',''),(2049,'1','313','1',1,'Retail Sale Id 2093',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 10:20:52','',''),(2050,'1','313','1',1,'Retail Sale Id 2094',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 10:21:47','',''),(2051,'1','313','1',1,'Retail Sale Id 2095',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 10:24:07','',''),(2052,'1','313','1',1,'Retail Sale Id 2096',2840.00,0.00,0.00,4.00,420.00,'2023-03-09 10:24:56','',''),(2053,'1','313','1',1,'Retail Sale Id 2097',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 10:27:07','',''),(2054,'1','313','1',1,'Retail Sale Id 2098',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 10:31:10','',''),(2055,'1','313','1',1,'Retail Sale Id 2099',2840.00,0.00,0.00,4.00,420.00,'2023-03-09 10:34:49','',''),(2056,'1','313','1',1,'Retail Sale Id 2100',4260.00,0.00,0.00,6.00,630.00,'2023-03-09 10:37:42','',''),(2057,'1','313','1',1,'Retail Sale Id 2101',2840.00,0.00,0.00,4.00,420.00,'2023-03-09 10:38:32','',''),(2058,'1','313','1',1,'Retail Sale Id 2102',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 10:40:08','',''),(2059,'1','313','1',1,'Retail Sale Id 2103',4260.00,0.00,0.00,6.00,630.00,'2023-03-09 10:41:55','',''),(2060,'1','313','1',1,'Retail Sale Id 2104',1001.10,0.00,0.00,1.41,148.05,'2023-03-09 10:45:21','',''),(2061,'1','313','1',1,'Retail Sale Id 2105',2840.00,0.00,0.00,4.00,420.00,'2023-03-09 10:46:16','',''),(2062,'1','313','1',1,'Retail Sale Id 2106',4260.00,0.00,0.00,6.00,630.00,'2023-03-09 10:48:32','',''),(2063,'1','313','1',1,'Retail Sale Id 2107',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 10:49:20','',''),(2064,'1','313','1',1,'Retail Sale Id 2108',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 10:50:09','',''),(2065,'1','313','1',1,'Retail Sale Id 2109',4970.00,0.00,0.00,7.00,735.00,'2023-03-09 10:52:13','',''),(2066,'1','313','1',1,'Retail Sale Id 2110',710.00,0.00,0.00,1.00,105.00,'2023-03-09 10:53:11','',''),(2067,'1','313','1',1,'Retail Sale Id 2111',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 10:53:53','',''),(2068,'1','313','1',1,'Retail Sale Id 2112',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 10:57:39','',''),(2069,'1','313','1',1,'Retail Sale Id 2113',2499.20,0.00,0.00,3.52,369.60,'2023-03-09 10:58:47','',''),(2070,'1','313','1',1,'Retail Sale Id 2114',1498.10,0.00,0.00,2.11,221.55,'2023-03-09 10:59:54','',''),(2071,'1','313','1',1,'Retail Sale Id 2115',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 11:01:02','',''),(2072,'1','313','1',1,'Retail Sale Id 2116',6390.00,0.00,0.00,9.00,945.00,'2023-03-09 11:01:58','',''),(2073,'1','313','1',1,'Retail Sale Id 2117',710.00,0.00,0.00,1.00,105.00,'2023-03-09 11:02:43','',''),(2074,'1','313','1',1,'Retail Sale Id 2118',802.30,0.00,0.00,1.13,118.65,'2023-03-09 11:03:30','',''),(2075,'1','313','1',1,'Retail Sale Id 2119',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 11:04:18','',''),(2076,'1','313','1',1,'Retail Sale Id 2120',4260.00,0.00,0.00,6.00,630.00,'2023-03-09 11:05:02','',''),(2077,'1','313','1',1,'Retail Sale Id 2121',120600.00,0.00,0.00,180.00,11700.00,'2023-03-09 11:06:10','',''),(2078,'1','313','1',1,'Retail Sale Id 2122',4970.00,0.00,0.00,7.00,735.00,'2023-03-09 11:07:07','',''),(2079,'1','313','1',1,'Retail Sale Id 2123',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 11:07:57','',''),(2080,'1','313','1',1,'Retail Sale Id 2124',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 11:09:09','',''),(2081,'1','313','1',1,'Retail Sale Id 2125',710.00,0.00,0.00,1.00,105.00,'2023-03-09 11:10:34','',''),(2082,'1','313','1',1,'Retail Sale Id 2126',1001.10,0.00,0.00,1.41,148.05,'2023-03-09 11:11:41','',''),(2083,'1','313','1',1,'Retail Sale Id 2127',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 11:13:16','',''),(2084,'1','313','1',1,'Retail Sale Id 2128',4260.00,0.00,0.00,6.00,630.00,'2023-03-09 11:14:15','',''),(2085,'1','313','1',1,'Retail Sale Id 2130',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 11:17:10','',''),(2086,'1','313','1',1,'Retail Sale Id 2131',40200.00,0.00,0.00,60.00,3900.00,'2023-03-09 11:18:13','',''),(2087,'1','313','1',1,'Retail Sale Id 2132',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 11:18:58','',''),(2088,'1','313','1',1,'Retail Sale Id 2134',4970.00,0.00,0.00,7.00,735.00,'2023-03-09 11:24:20','',''),(2089,'1','313','1',1,'Retail Sale Id 2135',5140.40,0.00,0.00,7.24,760.20,'2023-03-09 11:28:18','',''),(2090,'1','313','1',1,'Retail Sale Id 2136',2840.00,0.00,0.00,4.00,420.00,'2023-03-09 11:30:47','',''),(2091,'1','313','1',1,'Retail Sale Id 2137',6390.00,0.00,0.00,9.00,945.00,'2023-03-09 11:31:54','',''),(2092,'1','313','1',1,'Retail Sale Id 2138',3500.30,0.00,0.00,4.93,517.65,'2023-03-09 11:33:01','',''),(2093,'1','313','1',1,'Retail Sale Id 2139',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 11:33:48','',''),(2094,'1','313','1',1,'Retail Sale Id 2140',2840.00,0.00,0.00,4.00,420.00,'2023-03-09 11:35:46','',''),(2095,'1','313','1',1,'Retail Sale Id 2141',2151.30,0.00,0.00,3.03,318.15,'2023-03-09 11:36:29','',''),(2096,'1','313','1',1,'Retail Sale Id 2142',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 11:37:09','',''),(2097,'1','313','1',1,'Retail Sale Id 2143',3003.30,0.00,0.00,4.23,444.15,'2023-03-09 11:38:06','',''),(2098,'1','313','1',1,'Retail Sale Id 2144',752.60,0.00,0.00,1.06,111.30,'2023-03-09 11:39:17','',''),(2099,'1','313','1',1,'Retail Sale Id 2145',2840.00,0.00,0.00,4.00,420.00,'2023-03-09 11:40:32','',''),(2100,'1','313','1',1,'Retail Sale Id 2146',1498.10,0.00,0.00,2.11,221.55,'2023-03-09 11:41:59','',''),(2101,'1','313','1',1,'Retail Sale Id 2147',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 11:42:50','',''),(2102,'1','313','1',1,'Retail Sale Id 2148',710.00,0.00,0.00,1.00,105.00,'2023-03-09 11:44:03','',''),(2103,'1','313','1',1,'Retail Sale Id 2149',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 11:44:51','',''),(2104,'1','313','1',1,'Retail Sale Id 2150',4998.40,0.00,0.00,7.04,739.20,'2023-03-09 11:48:32','',''),(2105,'1','313','1',1,'Retail Sale Id 2151',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 11:52:37','',''),(2106,'1','313','1',1,'Retail Sale Id 2152',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 11:54:36','',''),(2107,'1','313','1',1,'Retail Sale Id 2153',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 12:00:12','',''),(2108,'1','313','1',1,'Retail Sale Id 2154',2840.00,0.00,0.00,4.00,420.00,'2023-03-09 12:01:06','',''),(2109,'1','313','1',1,'Retail Sale Id 2155',40200.00,0.00,0.00,60.00,3900.00,'2023-03-09 12:03:15','',''),(2110,'1','313','1',1,'Retail Sale Id 2157',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 12:04:48','',''),(2111,'1','313','1',1,'Retail Sale Id 2158',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 12:05:32','',''),(2112,'1','313','1',1,'Retail Sale Id 2159',4970.00,0.00,0.00,7.00,735.00,'2023-03-09 12:06:25','',''),(2113,'1','313','1',1,'Retail Sale Id 2160',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 12:07:17','',''),(2114,'1','313','1',1,'Retail Sale Id 2161',4260.00,0.00,0.00,6.00,630.00,'2023-03-09 12:10:21','',''),(2115,'1','313','1',1,'Retail Sale Id 2162',752.60,0.00,0.00,1.06,111.30,'2023-03-09 12:12:00','',''),(2116,'1','313','1',1,'Retail Sale Id 2163',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 12:13:29','',''),(2117,'1','313','1',1,'Retail Sale Id 2164',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 12:15:12','',''),(2118,'1','313','1',1,'Retail Sale Id 2165',4970.00,0.00,0.00,7.00,735.00,'2023-03-09 12:17:41','',''),(2119,'1','313','1',1,'Retail Sale Id 2167',2101.60,0.00,0.00,2.96,310.80,'2023-03-09 12:23:25','',''),(2120,'1','313','1',1,'Retail Sale Id 2168',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 12:25:18','',''),(2121,'1','313','1',1,'Retail Sale Id 2169',8875.00,0.00,0.00,12.50,1312.50,'2023-03-09 12:28:08','',''),(2122,'1','313','1',1,'Retail Sale Id 2170',5680.00,0.00,0.00,8.00,840.00,'2023-03-09 12:30:34','',''),(2123,'1','313','1',1,'Retail Sale Id 2171',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 12:32:35','',''),(2124,'1','313','1',1,'Retail Sale Id 2172',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 12:33:55','',''),(2125,'1','313','1',1,'Retail Sale Id 2173',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 12:35:37','',''),(2126,'1','313','1',1,'Retail Sale Id 2174',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 12:37:28','',''),(2127,'1','313','1',1,'Retail Sale Id 2175',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 12:38:11','',''),(2128,'1','313','1',1,'Retail Sale Id 2176',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 12:40:13','',''),(2129,'1','313','1',1,'Retail Sale Id 2177',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 12:41:26','',''),(2130,'1','313','1',1,'Retail Sale Id 2178',710.00,0.00,0.00,1.00,105.00,'2023-03-09 12:42:38','',''),(2131,'1','313','1',1,'Retail Sale Id 2179',2002.20,0.00,0.00,2.82,296.10,'2023-03-09 12:45:43','',''),(2132,'1','313','1',1,'Retail Sale Id 2180',1498.10,0.00,0.00,2.11,221.55,'2023-03-09 12:46:35','',''),(2133,'1','313','1',1,'Retail Sale Id 2181',752.60,0.00,0.00,1.06,111.30,'2023-03-09 12:48:23','',''),(2134,'1','313','1',1,'Retail Sale Id 2182',16750.00,0.00,0.00,25.00,1625.00,'2023-03-09 12:51:15','',''),(2135,'1','313','1',1,'Retail Sale Id 2183',8875.00,0.00,0.00,12.50,1312.50,'2023-03-09 12:52:07','',''),(2136,'1','313','1',1,'Retail Sale Id 2184',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 12:53:54','',''),(2137,'1','313','1',1,'Retail Sale Id 2185',1001.10,0.00,0.00,1.41,148.05,'2023-03-09 12:58:18','',''),(2138,'1','313','1',1,'Retail Sale Id 2186',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 13:00:07','',''),(2139,'1','313','1',1,'Retail Sale Id 2187',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 13:03:42','',''),(2140,'1','313','1',1,'Retail Sale Id 2188',40200.00,0.00,0.00,60.00,3900.00,'2023-03-09 13:07:12','',''),(2141,'1','313','1',1,'Return of Retail Sale Id 2188',0.00,40200.00,60.00,0.00,-3900.00,'2023-03-09 13:07:46','',''),(2142,'1','313','1',1,'Retail Sale Id 2189',2840.00,0.00,0.00,4.00,420.00,'2023-03-09 13:09:20','',''),(2143,'1','313','1',1,'Retail Sale Id 2190',7100.00,0.00,0.00,10.00,1050.00,'2023-03-09 13:10:14','',''),(2144,'1','313','1',1,'Retail Sale Id 2191',21105.00,0.00,0.00,31.50,2047.50,'2023-03-09 13:18:19','',''),(2145,'1','313','1',1,'Retail Sale Id 2192',2840.00,0.00,0.00,4.00,420.00,'2023-03-09 13:19:10','',''),(2146,'1','313','1',1,'Retail Sale Id 2193',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 13:23:34','',''),(2147,'1','313','1',1,'Retail Sale Id 2194',710.00,0.00,0.00,1.00,105.00,'2023-03-09 13:25:54','',''),(2148,'1','313','1',1,'Retail Sale Id 2195',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 13:27:30','',''),(2149,'1','313','1',1,'Retail Sale Id 2196',816.50,0.00,0.00,1.15,120.75,'2023-03-09 13:28:42','',''),(2150,'1','313','1',1,'Retail Sale Id 2197',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 13:30:39','',''),(2151,'1','313','1',1,'Retail Sale Id 2198',2840.00,0.00,0.00,4.00,420.00,'2023-03-09 13:33:56','',''),(2152,'1','313','1',1,'Retail Sale Id 2199',4998.40,0.00,0.00,7.04,739.20,'2023-03-09 13:36:27','',''),(2153,'1','313','1',1,'Retail Sale Id 2200',1001.10,0.00,0.00,1.41,148.05,'2023-03-09 13:39:28','',''),(2154,'1','313','1',1,'Retail Sale Id 2201',2499.20,0.00,0.00,3.52,369.60,'2023-03-09 13:40:24','',''),(2155,'1','313','1',1,'Retail Sale Id 2202',8875.00,0.00,0.00,12.50,1312.50,'2023-03-09 13:41:08','',''),(2156,'1','313','1',1,'Retail Sale Id 2203',7100.00,0.00,0.00,10.00,1050.00,'2023-03-09 13:43:23','',''),(2157,'1','313','1',1,'Retail Sale Id 2204',4970.00,0.00,0.00,7.00,735.00,'2023-03-09 13:45:16','',''),(2158,'1','313','1',1,'Retail Sale Id 2205',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 13:47:36','',''),(2159,'1','313','1',1,'Retail Sale Id 2206',83703.10,0.00,0.00,124.93,8120.45,'2023-03-09 13:50:32','',''),(2160,'1','313','1',1,'Retail Sale Id 2207',1448.40,0.00,0.00,2.04,214.20,'2023-03-09 13:52:44','',''),(2161,'1','313','1',1,'Retail Sale Id 2208',109210.00,0.00,0.00,163.00,10595.00,'2023-03-09 13:54:41','',''),(2162,'1','313','1',1,'Retail Sale Id 2209',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 13:56:22','',''),(2163,'1','313','1',1,'Retail Sale Id 2210',2840.00,0.00,0.00,4.00,420.00,'2023-03-09 13:57:33','',''),(2164,'1','313','1',1,'Retail Sale Id 2211',4260.00,0.00,0.00,6.00,630.00,'2023-03-09 13:58:57','',''),(2165,'1','313','1',1,'Retail Sale Id 2212',4970.00,0.00,0.00,7.00,735.00,'2023-03-09 14:00:11','',''),(2166,'1','313','1',1,'Retail Sale Id 2213',2840.00,0.00,0.00,4.00,420.00,'2023-03-09 14:01:23','',''),(2167,'1','313','1',1,'Retail Sale Id 2214',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 14:02:06','',''),(2168,'1','313','1',1,'Retail Sale Id 2215',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 14:03:04','',''),(2169,'1','313','1',1,'Retail Sale Id 2216',710.00,0.00,0.00,1.00,105.00,'2023-03-09 14:04:43','',''),(2170,'1','313','1',1,'Retail Sale Id 2217',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 14:07:23','',''),(2171,'1','313','1',1,'Retail Sale Id 2218',9940.00,0.00,0.00,14.00,1470.00,'2023-03-09 14:12:12','',''),(2172,'1','313','1',1,'Retail Sale Id 2219',8875.00,0.00,0.00,12.50,1312.50,'2023-03-09 14:13:36','',''),(2173,'1','313','1',1,'Retail Sale Id 2220',752.60,0.00,0.00,1.06,111.30,'2023-03-09 14:15:41','',''),(2174,'1','313','1',1,'Retail Sale Id 2221',752.60,0.00,0.00,1.06,111.30,'2023-03-09 14:22:47','',''),(2175,'1','313','1',1,'Retail Sale Id 2222',8875.00,0.00,0.00,12.50,1312.50,'2023-03-09 14:25:11','',''),(2176,'1','313','1',1,'Retail Sale Id 2223',717.10,0.00,0.00,1.01,106.05,'2023-03-09 14:25:54','',''),(2177,'1','313','1',1,'Retail Sale Id 2224',2840.00,0.00,0.00,4.00,420.00,'2023-03-09 14:28:23','',''),(2178,'1','313','1',1,'Retail Sale Id 2225',7810.00,0.00,0.00,11.00,1155.00,'2023-03-09 14:33:50','',''),(2179,'1','313','1',1,'Retail Sale Id 2226',433.10,0.00,0.00,0.61,64.05,'2023-03-09 14:34:43','',''),(2180,'1','313','1',1,'Retail Sale Id 2227',40206.70,0.00,0.00,60.01,3900.65,'2023-03-09 14:36:03','',''),(2181,'1','313','1',1,'Retail Sale Id 2228',752.60,0.00,0.00,1.06,111.30,'2023-03-09 14:38:06','',''),(2182,'1','313','1',1,'Retail Sale Id 2229',1498.10,0.00,0.00,2.11,221.55,'2023-03-09 14:39:15','',''),(2183,'1','313','1',1,'Return of Retail Sale Id 2223',0.00,717.10,1.01,0.00,-106.05,'2023-03-09 14:42:47','',''),(2184,'1','313','1',1,'Retail Sale Id 2230',710.00,0.00,0.00,1.00,105.00,'2023-03-09 14:47:22','',''),(2185,'1','313','1',1,'Retail Sale Id 2231',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 14:48:39','',''),(2186,'1','313','1',1,'Retail Sale Id 2232',8875.00,0.00,0.00,12.50,1312.50,'2023-03-09 14:49:59','',''),(2187,'1','313','1',1,'Retail Sale Id 2233',710.00,0.00,0.00,1.00,105.00,'2023-03-09 14:51:27','',''),(2188,'1','313','1',1,'Retail Sale Id 2234',3003.30,0.00,0.00,4.23,444.15,'2023-03-09 14:54:34','',''),(2189,'1','313','1',1,'Retail Sale Id 2235',710.00,0.00,0.00,1.00,105.00,'2023-03-09 14:55:42','',''),(2190,'1','313','1',1,'Retail Sale Id 2236',4970.00,0.00,0.00,7.00,735.00,'2023-03-09 14:56:48','',''),(2191,'1','313','1',1,'Retail Sale Id 2237',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 14:57:58','',''),(2192,'1','313','1',1,'Retail Sale Id 2238',5680.00,0.00,0.00,8.00,840.00,'2023-03-09 14:59:41','',''),(2193,'1','313','1',1,'Retail Sale Id 2239',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 15:02:31','',''),(2194,'1','313','1',1,'Retail Sale Id 2241',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 15:11:41','',''),(2195,'1','313','1',1,'Retail Sale Id 2242',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 15:12:49','',''),(2196,'1','313','1',1,'Retail Sale Id 2243',4970.00,0.00,0.00,7.00,735.00,'2023-03-09 15:13:42','',''),(2197,'1','313','1',1,'Retail Sale Id 2244',2840.00,0.00,0.00,4.00,420.00,'2023-03-09 15:15:10','',''),(2198,'1','313','1',1,'Retail Sale Id 2245',752.60,0.00,0.00,1.06,111.30,'2023-03-09 15:17:36','',''),(2199,'1','313','1',1,'Retail Sale Id 2246',1803.40,0.00,0.00,2.54,266.70,'2023-03-09 15:18:37','',''),(2200,'1','313','1',1,'Retail Sale Id 2247',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 15:19:39','',''),(2201,'1','313','1',1,'Retail Sale Id 2248',8875.00,0.00,0.00,12.50,1312.50,'2023-03-09 15:20:43','',''),(2202,'1','313','1',1,'Retail Sale Id 2249',1398.70,0.00,0.00,1.97,206.85,'2023-03-09 15:28:19','',''),(2203,'1','313','1',1,'Retail Sale Id 2251',7100.00,0.00,0.00,10.00,1050.00,'2023-03-09 15:31:38','',''),(2204,'1','313','1',1,'Retail Sale Id 2252',4260.00,0.00,0.00,6.00,630.00,'2023-03-09 15:33:51','',''),(2205,'1','313','1',1,'Retail Sale Id 2253',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 15:35:06','',''),(2206,'1','313','1',1,'Retail Sale Id 2254',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 15:36:35','',''),(2207,'1','313',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,60.00,0.00,'2023-03-09 15:37:31','',''),(2208,'1','313','1',1,'Received from bridging 3',0.00,0.00,60.00,0.00,0.00,'2023-03-09 15:37:31','',''),(2209,'1','313','1',1,'Retail Sale Id 2255',710.00,0.00,0.00,1.00,105.00,'2023-03-09 15:38:29','',''),(2210,'1','313','1',1,'Retail Sale Id 2256',710.00,0.00,0.00,1.00,105.00,'2023-03-09 15:39:56','',''),(2211,'1','313','1',1,'Retail Sale Id 2257',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 15:40:59','',''),(2212,'1','313','1',1,'Retail Sale Id 2258',752.60,0.00,0.00,1.06,111.30,'2023-03-09 15:41:57','',''),(2213,'1','313','1',1,'Retail Sale Id 2259',7100.00,0.00,0.00,10.00,1050.00,'2023-03-09 15:42:56','',''),(2214,'1','313','1',1,'Retail Sale Id 2260',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 15:44:24','',''),(2215,'1','313','1',1,'Retail Sale Id 2261',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 15:47:08','',''),(2216,'1','313','1',1,'Retail Sale Id 2262',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 15:56:27','',''),(2217,'1','313','1',1,'Retail Sale Id 2264',710.00,0.00,0.00,1.00,105.00,'2023-03-09 15:59:20','',''),(2218,'1','313','1',1,'Retail Sale Id 2265',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 16:02:04','',''),(2219,'1','313','1',1,'Retail Sale Id 2266',35500.00,0.00,0.00,50.00,5250.00,'2023-03-09 16:03:37','',''),(2220,'1','313','1',1,'Retail Sale Id 2267',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 16:04:05','',''),(2221,'1','313','1',1,'Retail Sale Id 2268',4260.00,0.00,0.00,6.00,630.00,'2023-03-09 16:05:07','',''),(2222,'1','313','1',1,'Retail Sale Id 2269',752.60,0.00,0.00,1.06,111.30,'2023-03-09 16:06:30','',''),(2223,'1','313','1',1,'Retail Sale Id 2270',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 16:07:35','',''),(2224,'1','313','1',1,'Retail Sale Id 2271',2151.30,0.00,0.00,3.03,318.15,'2023-03-09 16:11:17','',''),(2225,'1','313','1',1,'Retail Sale Id 2272',710.00,0.00,0.00,1.00,105.00,'2023-03-09 16:12:45','',''),(2226,'1','313','1',1,'Retail Sale Id 2273',1448.40,0.00,0.00,2.04,214.20,'2023-03-09 16:16:17','',''),(2227,'1','313','1',1,'Retail Sale Id 2275',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 16:18:51','',''),(2228,'1','313','1',1,'Retail Sale Id 2276',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 16:20:11','',''),(2229,'1','313','1',1,'Retail Sale Id 2277',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 16:21:13','',''),(2230,'1','313','1',1,'Retail Sale Id 2278',8875.00,0.00,0.00,12.50,1312.50,'2023-03-09 16:22:14','',''),(2231,'1','313','1',1,'Retail Sale Id 2279',710.00,0.00,0.00,1.00,105.00,'2023-03-09 16:23:53','',''),(2232,'1','313','1',1,'Retail Sale Id 2280',2840.00,0.00,0.00,4.00,420.00,'2023-03-09 16:27:03','',''),(2233,'1','313','1',1,'Retail Sale Id 2281',3997.30,0.00,0.00,5.63,591.15,'2023-03-09 16:27:45','',''),(2234,'1','313','1',1,'Retail Sale Id 2282',2840.00,0.00,0.00,4.00,420.00,'2023-03-09 16:29:16','',''),(2235,'1','313','1',1,'Retail Sale Id 2283',33500.00,0.00,0.00,50.00,3250.00,'2023-03-09 16:31:50','',''),(2236,'1','313','1',1,'Retail Sale Id 2284',5680.00,0.00,0.00,8.00,840.00,'2023-03-09 16:35:59','',''),(2237,'1','313','1',1,'Retail Sale Id 2285',2840.00,0.00,0.00,4.00,420.00,'2023-03-09 16:36:36','',''),(2238,'1','313','1',1,'Retail Sale Id 2286',8875.00,0.00,0.00,12.50,1312.50,'2023-03-09 16:40:37','',''),(2239,'1','313','1',1,'Retail Sale Id 2287',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 16:43:37','',''),(2240,'1','313','1',1,'Retail Sale Id 2288',710.00,0.00,0.00,1.00,105.00,'2023-03-09 16:45:01','',''),(2241,'1','313','1',1,'Retail Sale Id 2289',752.60,0.00,0.00,1.06,111.30,'2023-03-09 16:46:09','',''),(2242,'1','313','1',1,'Retail Sale Id 2290',7100.00,0.00,0.00,10.00,1050.00,'2023-03-09 16:47:02','',''),(2243,'1','313','1',1,'Retail Sale Id 2291',4998.40,0.00,0.00,7.04,739.20,'2023-03-09 16:49:06','',''),(2244,'1','313','1',1,'Retail Sale Id 2292',8875.00,0.00,0.00,12.50,1312.50,'2023-03-09 16:50:11','',''),(2245,'1','313','1',1,'Retail Sale Id 2293',4970.00,0.00,0.00,7.00,735.00,'2023-03-09 16:57:03','',''),(2246,'1','313','1',1,'Retail Sale Id 2294',2840.00,0.00,0.00,4.00,420.00,'2023-03-09 16:57:54','',''),(2247,'1','313','1',1,'Retail Sale Id 2295',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 17:00:12','',''),(2248,'1','313','1',1,'Retail Sale Id 2296',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 17:01:46','',''),(2249,'1','313','1',1,'Retail Sale Id 2297',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 17:03:40','',''),(2250,'1','313','1',1,'Retail Sale Id 2298',8875.00,0.00,0.00,12.50,1312.50,'2023-03-09 17:04:45','',''),(2251,'1','313','1',1,'Retail Sale Id 2299',4260.00,0.00,0.00,6.00,630.00,'2023-03-09 17:05:33','',''),(2252,'1','313','1',1,'Retail Sale Id 2300',4970.00,0.00,0.00,7.00,735.00,'2023-03-09 17:06:45','',''),(2253,'1','313','1',1,'Retail Sale Id 2301',2840.00,0.00,0.00,4.00,420.00,'2023-03-09 17:07:55','',''),(2254,'1','313','1',1,'Retail Sale Id 2302',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 17:09:13','',''),(2255,'1','313','1',1,'Retail Sale Id 2303',3003.30,0.00,0.00,4.23,444.15,'2023-03-09 17:10:00','',''),(2256,'1','313','1',1,'Retail Sale Id 2304',9230.00,0.00,0.00,13.00,1365.00,'2023-03-09 17:13:28','',''),(2257,'1','313','1',1,'Retail Sale Id 2305',4615.00,0.00,0.00,6.50,682.50,'2023-03-09 17:14:51','',''),(2258,'1','313','1',1,'Retail Sale Id 2306',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 17:15:42','',''),(2259,'1','313','1',1,'Retail Sale Id 2307',33500.00,0.00,0.00,50.00,3250.00,'2023-03-09 17:16:55','',''),(2260,'1','313','1',1,'Retail Sale Id 2308',33500.00,0.00,0.00,50.00,3250.00,'2023-03-09 17:17:39','',''),(2261,'1','313','1',1,'Retail Sale Id 2309',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 17:18:43','',''),(2262,'1','313','1',1,'Retail Sale Id 2310',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 17:20:17','',''),(2263,'1','313','1',1,'Retail Sale Id 2311',752.60,0.00,0.00,1.06,111.30,'2023-03-09 17:22:31','',''),(2264,'1','313','1',1,'Retail Sale Id 2312',3550.00,0.00,0.00,5.00,525.00,'2023-03-09 17:26:05','',''),(2265,'1','313','1',1,'Retail Sale Id 2313',4260.00,0.00,0.00,6.00,630.00,'2023-03-09 17:28:17','',''),(2266,'1','313','1',1,'Retail Sale Id 2314',7100.00,0.00,0.00,10.00,1050.00,'2023-03-09 17:29:21','',''),(2267,'1','313','1',1,'Retail Sale Id 2315',4970.00,0.00,0.00,7.00,735.00,'2023-03-09 17:30:18','',''),(2268,'1','313','1',1,'Retail Sale Id 2316',752.60,0.00,0.00,1.06,111.30,'2023-03-09 17:31:25','',''),(2269,'1','313','1',1,'Retail Sale Id 2317',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 17:33:36','',''),(2270,'1','313','1',1,'Retail Sale Id 2319',1420.00,0.00,0.00,2.00,210.00,'2023-03-09 17:35:18','',''),(2271,'1','313','1',1,'Retail Sale Id 2320',2130.00,0.00,0.00,3.00,315.00,'2023-03-09 17:36:44','',''),(2272,'1','313','1',1,'Return of Retail Sale Id 2266',0.00,35500.00,50.00,0.00,-5250.00,'2023-03-09 17:40:33','',''),(2273,'1','313','1',1,'Retail Sale Id 2321',33500.00,0.00,0.00,50.00,3250.00,'2023-03-09 17:41:19','',''),(2274,'1','313','1',1,'Return of Retail Sale Id 2191',0.00,21105.00,31.50,0.00,-2047.50,'2023-03-09 17:56:51','',''),(2275,'1','313','1',1,'Retail Sale Id 2322',21158.60,0.00,0.00,31.58,2052.70,'2023-03-09 17:57:50','',''),(2276,'1','313','1',1,'Return of Retail Sale Id 2301',0.00,2840.00,4.00,0.00,-420.00,'2023-03-09 17:59:27','',''),(2277,'1','313','1',1,'Retail Sale Id 2323',1753.70,0.00,0.00,2.47,259.35,'2023-03-09 18:00:33','',''),(2278,'1','313','1',1,'Retail Sale Id 2324',2201.00,0.00,0.00,3.10,325.50,'2023-03-10 08:06:28','',''),(2279,'1','313','1',1,'Retail Sale Id 2325',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 08:08:01','',''),(2280,'1','313','1',1,'Retail Sale Id 2326',2840.00,0.00,0.00,4.00,420.00,'2023-03-10 08:08:44','',''),(2281,'1','313','1',1,'Retail Sale Id 2327',2151.30,0.00,0.00,3.03,318.15,'2023-03-10 08:09:55','',''),(2282,'1','313','1',1,'Retail Sale Id 2328',7100.00,0.00,0.00,10.00,1050.00,'2023-03-10 08:11:00','',''),(2283,'1','313','1',1,'Retail Sale Id 2329',19430.00,0.00,0.00,29.00,1885.00,'2023-03-10 08:12:11','',''),(2284,'1','313','1',1,'Retail Sale Id 2330',1498.10,0.00,0.00,2.11,221.55,'2023-03-10 08:13:12','',''),(2285,'1','313','1',1,'Retail Sale Id 2331',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 08:13:50','',''),(2286,'1','313','1',1,'Retail Sale Id 2332',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 08:14:27','',''),(2287,'1','313','1',1,'Retail Sale Id 2333',752.60,0.00,0.00,1.06,111.30,'2023-03-10 08:15:22','',''),(2288,'1','313','1',1,'Retail Sale Id 2334',752.60,0.00,0.00,1.06,111.30,'2023-03-10 08:16:33','',''),(2289,'1','313','1',1,'Retail Sale Id 2335',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 08:17:22','',''),(2290,'1','313','1',1,'Retail Sale Id 2336',4260.00,0.00,0.00,6.00,630.00,'2023-03-10 08:18:16','',''),(2291,'1','313','1',1,'Retail Sale Id 2337',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 08:20:00','',''),(2292,'1','313','1',1,'Retail Sale Id 2338',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 08:22:21','',''),(2293,'1','313','1',1,'Retail Sale Id 2339',36850.00,0.00,0.00,55.00,3575.00,'2023-03-10 08:23:01','',''),(2294,'1','313','1',1,'Retail Sale Id 2340',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 08:24:52','',''),(2295,'1','313','1',1,'Retail Sale Id 2341',4260.00,0.00,0.00,6.00,630.00,'2023-03-10 08:25:51','',''),(2296,'1','313','1',1,'Retail Sale Id 2342',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 08:28:13','',''),(2297,'1','313','1',1,'Retail Sale Id 2343',4970.00,0.00,0.00,7.00,735.00,'2023-03-10 08:29:07','',''),(2298,'1','313','1',1,'Retail Sale Id 2344',4260.00,0.00,0.00,6.00,630.00,'2023-03-10 08:29:53','',''),(2299,'1','313','1',1,'Retail Sale Id 2345',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 08:30:39','',''),(2300,'1','313','1',1,'Retail Sale Id 2346',4970.00,0.00,0.00,7.00,735.00,'2023-03-10 08:31:28','',''),(2301,'1','313','1',1,'Retail Sale Id 2347',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 08:33:59','',''),(2302,'1','313','1',1,'Retail Sale Id 2348',4970.00,0.00,0.00,7.00,735.00,'2023-03-10 08:35:55','',''),(2303,'1','313','1',1,'Retail Sale Id 2349',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 08:37:32','',''),(2304,'1','313','1',1,'Retail Sale Id 2350',2840.00,0.00,0.00,4.00,420.00,'2023-03-10 08:39:16','',''),(2305,'1','313','1',1,'Retail Sale Id 2351',8875.00,0.00,0.00,12.50,1312.50,'2023-03-10 08:39:53','',''),(2306,'1','313','1',1,'Retail Sale Id 2352',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 08:41:00','',''),(2307,'1','313','1',1,'Retail Sale Id 2353',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 08:45:05','',''),(2308,'1','313','1',1,'Retail Sale Id 2354',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 08:45:45','',''),(2309,'1','313','1',1,'Retail Sale Id 2355',4260.00,0.00,0.00,6.00,630.00,'2023-03-10 08:47:34','',''),(2310,'1','313','1',1,'Retail Sale Id 2356',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 08:48:19','',''),(2311,'1','313','1',1,'Retail Sale Id 2357',4970.00,0.00,0.00,7.00,735.00,'2023-03-10 08:49:35','',''),(2312,'1','313','1',1,'Retail Sale Id 2358',4970.00,0.00,0.00,7.00,735.00,'2023-03-10 08:51:27','',''),(2313,'1','313','1',1,'Retail Sale Id 2359',3003.30,0.00,0.00,4.23,444.15,'2023-03-10 08:52:18','',''),(2314,'1','313','1',1,'Retail Sale Id 2360',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 08:53:15','',''),(2315,'1','313','1',1,'Retail Sale Id 2361',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 08:53:54','',''),(2316,'1','313','1',1,'Retail Sale Id 2362',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 08:55:12','',''),(2317,'1','313','1',1,'Retail Sale Id 2363',33500.00,0.00,0.00,50.00,3250.00,'2023-03-10 08:56:01','',''),(2318,'1','313','1',1,'Retail Sale Id 2365',710.00,0.00,0.00,1.00,105.00,'2023-03-10 08:57:44','',''),(2319,'1','313','1',1,'Retail Sale Id 2366',1001.10,0.00,0.00,1.41,148.05,'2023-03-10 09:00:22','',''),(2320,'1','313','1',1,'Retail Sale Id 2368',752.60,0.00,0.00,1.06,111.30,'2023-03-10 09:07:29','',''),(2321,'1','313','1',1,'Retail Sale Id 2369',4302.60,0.00,0.00,6.06,636.30,'2023-03-10 09:09:43','',''),(2322,'1','313','1',1,'Retail Sale Id 2370',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 09:10:40','',''),(2323,'1','313','1',1,'Retail Sale Id 2371',4260.00,0.00,0.00,6.00,630.00,'2023-03-10 09:11:33','',''),(2324,'1','313','1',1,'Retail Sale Id 2372',2002.20,0.00,0.00,2.82,296.10,'2023-03-10 09:12:14','',''),(2325,'1','313','1',1,'Retail Sale Id 2373',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 09:13:44','',''),(2326,'1','313','1',1,'Retail Sale Id 2374',7100.00,0.00,0.00,10.00,1050.00,'2023-03-10 09:15:23','',''),(2327,'1','313','1',1,'Retail Sale Id 2375',1803.40,0.00,0.00,2.54,266.70,'2023-03-10 09:16:54','',''),(2328,'1','313','1',1,'Retail Sale Id 2376',3003.30,0.00,0.00,4.23,444.15,'2023-03-10 09:18:07','',''),(2329,'1','313','1',1,'Retail Sale Id 2377',8875.00,0.00,0.00,12.50,1312.50,'2023-03-10 09:20:04','',''),(2330,'1','313','1',1,'Retail Sale Id 2378',4970.00,0.00,0.00,7.00,735.00,'2023-03-10 09:21:33','',''),(2331,'1','313','1',1,'Retail Sale Id 2379',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 09:26:34','',''),(2332,'1','313','1',1,'Retail Sale Id 2380',710.00,0.00,0.00,1.00,105.00,'2023-03-10 09:27:26','',''),(2333,'1','313','1',1,'Retail Sale Id 2381',752.60,0.00,0.00,1.06,111.30,'2023-03-10 09:28:09','',''),(2334,'1','313','1',1,'Retail Sale Id 2382',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 09:28:58','',''),(2335,'1','313','1',1,'Retail Sale Id 2383',40200.00,0.00,0.00,60.00,3900.00,'2023-03-10 09:31:16','',''),(2336,'1','313','1',1,'Retail Sale Id 2384',752.60,0.00,0.00,1.06,111.30,'2023-03-10 09:32:02','',''),(2337,'1','313','1',1,'Retail Sale Id 2385',4998.40,0.00,0.00,7.04,739.20,'2023-03-10 09:34:31','',''),(2338,'1','313','1',1,'Retail Sale Id 2386',40347.40,0.00,0.00,60.22,3914.30,'2023-03-10 09:38:37','',''),(2339,'1','313','1',1,'Retail Sale Id 2387',27999.30,0.00,0.00,41.79,2716.35,'2023-03-10 09:40:09','',''),(2340,'1','313','1',1,'Retail Sale Id 2388',1498.10,0.00,0.00,2.11,221.55,'2023-03-10 09:40:55','',''),(2341,'1','313','1',1,'Retail Sale Id 2389',710.00,0.00,0.00,1.00,105.00,'2023-03-10 09:43:10','',''),(2342,'1','313','1',1,'Retail Sale Id 2390',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 09:43:53','',''),(2343,'1','313','1',1,'Retail Sale Id 2391',1441.30,0.00,0.00,2.03,213.15,'2023-03-10 09:46:49','',''),(2344,'1','313','1',1,'Retail Sale Id 2392',752.60,0.00,0.00,1.06,111.30,'2023-03-10 09:47:39','',''),(2345,'1','313','1',1,'Retail Sale Id 2393',1448.40,0.00,0.00,2.04,214.20,'2023-03-10 09:48:14','',''),(2346,'1','313','1',1,'Retail Sale Id 2394',16093.40,0.00,0.00,24.02,1561.30,'2023-03-10 09:49:07','',''),(2347,'1','313','1',1,'Retail Sale Id 2395',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 09:50:43','',''),(2348,'1','313','1',1,'Retail Sale Id 2396',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 09:52:13','',''),(2349,'1','313','1',1,'Retail Sale Id 2397',3202.10,0.00,0.00,4.51,473.55,'2023-03-10 09:53:06','',''),(2350,'1','313','1',1,'Retail Sale Id 2398',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 09:54:30','',''),(2351,'1','313','1',1,'Retail Sale Id 2399',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 09:55:45','',''),(2352,'1','313','1',1,'Retail Sale Id 2400',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 09:56:29','',''),(2353,'1','313','1',1,'Retail Sale Id 2401',4260.00,0.00,0.00,6.00,630.00,'2023-03-10 09:57:24','',''),(2354,'1','313','1',1,'Retail Sale Id 2402',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 09:58:51','',''),(2355,'1','313','1',1,'Retail Sale Id 2403',4260.00,0.00,0.00,6.00,630.00,'2023-03-10 10:05:29','',''),(2356,'1','313','1',1,'Retail Sale Id 2404',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 10:07:47','',''),(2357,'1','313','1',1,'Retail Sale Id 2405',2151.30,0.00,0.00,3.03,318.15,'2023-03-10 10:10:05','',''),(2358,'1','313','1',1,'Retail Sale Id 2406',752.60,0.00,0.00,1.06,111.30,'2023-03-10 10:11:36','',''),(2359,'1','313','1',1,'Retail Sale Id 2407',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 10:13:41','',''),(2360,'1','313','1',1,'Retail Sale Id 2408',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 10:15:00','',''),(2361,'1','313','1',1,'Retail Sale Id 2409',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 10:16:45','',''),(2362,'1','313','1',1,'Retail Sale Id 2413',3997.30,0.00,0.00,5.63,591.15,'2023-03-10 10:19:20','',''),(2363,'1','313','1',1,'Retail Sale Id 2414',8875.00,0.00,0.00,12.50,1312.50,'2023-03-10 10:19:45','',''),(2364,'1','313','1',1,'Retail Sale Id 2415',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 10:22:32','',''),(2365,'1','313','1',1,'Retail Sale Id 2416',33500.00,0.00,0.00,50.00,3250.00,'2023-03-10 10:23:28','',''),(2366,'1','313','1',1,'Retail Sale Id 2417',710.00,0.00,0.00,1.00,105.00,'2023-03-10 10:24:49','',''),(2367,'1','313','1',1,'Retail Sale Id 2418',5680.00,0.00,0.00,8.00,840.00,'2023-03-10 10:27:30','',''),(2368,'1','313','1',1,'Retail Sale Id 2419',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 10:29:36','',''),(2369,'1','313','1',1,'Retail Sale Id 2420',40843.20,0.00,0.00,60.96,3962.40,'2023-03-10 10:30:41','',''),(2370,'1','313','1',1,'Retail Sale Id 2421',12070.00,0.00,0.00,17.00,1785.00,'2023-03-10 10:32:13','',''),(2371,'1','313','1',1,'Retail Sale Id 2422',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 10:33:19','',''),(2372,'1','313','1',1,'Retail Sale Id 2423',3997.30,0.00,0.00,5.63,591.15,'2023-03-10 10:38:11','',''),(2373,'1','313','1',1,'Retail Sale Id 2424',2840.00,0.00,0.00,4.00,420.00,'2023-03-10 10:38:57','',''),(2374,'1','313','1',1,'Retail Sale Id 2425',16750.00,0.00,0.00,25.00,1625.00,'2023-03-10 10:41:19','',''),(2375,'1','313','1',1,'Retail Sale Id 2426',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 10:44:33','',''),(2376,'1','313','1',1,'Retail Sale Id 2427',7100.00,0.00,0.00,10.00,1050.00,'2023-03-10 10:45:19','',''),(2377,'1','313','1',1,'Retail Sale Id 2428',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 10:45:49','',''),(2378,'1','313','1',1,'Retail Sale Id 2429',7100.00,0.00,0.00,10.00,1050.00,'2023-03-10 10:46:46','',''),(2379,'1','313','1',1,'Retail Sale Id 2430',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 10:47:58','',''),(2380,'1','313','1',1,'Retail Sale Id 2431',2598.60,0.00,0.00,3.66,384.30,'2023-03-10 10:49:58','',''),(2381,'1','313','1',1,'Retail Sale Id 2432',1448.40,0.00,0.00,2.04,214.20,'2023-03-10 10:51:09','',''),(2382,'1','313','1',1,'Retail Sale Id 2433',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 10:52:19','',''),(2383,'1','313','1',1,'Retail Sale Id 2435',4302.60,0.00,0.00,6.06,636.30,'2023-03-10 10:55:06','',''),(2384,'1','313','1',1,'Retail Sale Id 2436',2840.00,0.00,0.00,4.00,420.00,'2023-03-10 10:55:53','',''),(2385,'1','313','1',1,'Retail Sale Id 2437',4970.00,0.00,0.00,7.00,735.00,'2023-03-10 10:57:31','',''),(2386,'1','313','1',1,'Retail Sale Id 2438',710.00,0.00,0.00,1.00,105.00,'2023-03-10 10:58:34','',''),(2387,'1','313','1',1,'Retail Sale Id 2439',4970.00,0.00,0.00,7.00,735.00,'2023-03-10 11:00:38','',''),(2388,'1','313','1',1,'Retail Sale Id 2440',9940.00,0.00,0.00,14.00,1470.00,'2023-03-10 11:06:25','',''),(2389,'1','313','1',1,'Retail Sale Id 2441',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 11:07:19','',''),(2390,'1','313','1',1,'Retail Sale Id 2442',4970.00,0.00,0.00,7.00,735.00,'2023-03-10 11:10:06','',''),(2391,'1','313','1',1,'Retail Sale Id 2443',8875.00,0.00,0.00,12.50,1312.50,'2023-03-10 11:11:18','',''),(2392,'1','313','1',1,'Retail Sale Id 2444',2151.30,0.00,0.00,3.03,318.15,'2023-03-10 11:12:17','',''),(2393,'1','313','1',1,'Retail Sale Id 2445',4260.00,0.00,0.00,6.00,630.00,'2023-03-10 11:13:02','',''),(2394,'1','313','1',1,'Retail Sale Id 2446',8520.00,0.00,0.00,12.00,1260.00,'2023-03-10 11:15:14','',''),(2395,'1','313','1',1,'Retail Sale Id 2447',40200.00,0.00,0.00,60.00,3900.00,'2023-03-10 11:17:35','',''),(2396,'1','313','1',1,'Retail Sale Id 2448',2840.00,0.00,0.00,4.00,420.00,'2023-03-10 11:18:26','',''),(2397,'1','313','1',1,'Retail Sale Id 2449',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 11:18:58','',''),(2398,'1','313','1',1,'Retail Sale Id 2450',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 11:20:56','',''),(2399,'1','313','1',1,'Retail Sale Id 2451',3003.30,0.00,0.00,4.23,444.15,'2023-03-10 11:21:32','',''),(2400,'1','313','1',1,'Retail Sale Id 2452',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 11:22:13','',''),(2401,'1','313','1',1,'Retail Sale Id 2453',4260.00,0.00,0.00,6.00,630.00,'2023-03-10 11:24:00','',''),(2402,'1','313','1',1,'Retail Sale Id 2454',4260.00,0.00,0.00,6.00,630.00,'2023-03-10 11:24:53','',''),(2403,'1','313','1',1,'Retail Sale Id 2455',2002.20,0.00,0.00,2.82,296.10,'2023-03-10 11:25:28','',''),(2404,'1','313','1',1,'Retail Sale Id 2456',1448.40,0.00,0.00,2.04,214.20,'2023-03-10 11:26:41','',''),(2405,'1','313','1',1,'Retail Sale Id 2457',2840.00,0.00,0.00,4.00,420.00,'2023-03-10 11:28:33','',''),(2406,'1','313','1',1,'Retail Sale Id 2458',1100.50,0.00,0.00,1.55,162.75,'2023-03-10 11:30:13','',''),(2407,'1','313','1',1,'Retail Sale Id 2459',752.60,0.00,0.00,1.06,111.30,'2023-03-10 11:32:42','',''),(2408,'1','313','1',1,'Retail Sale Id 2460',5680.00,0.00,0.00,8.00,840.00,'2023-03-10 11:34:56','',''),(2409,'1','313','1',1,'Retail Sale Id 2461',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 11:36:06','',''),(2410,'1','313','1',1,'Retail Sale Id 2462',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 11:38:18','',''),(2411,'1','313','1',1,'Retail Sale Id 2463',4260.00,0.00,0.00,6.00,630.00,'2023-03-10 11:39:25','',''),(2412,'1','313','1',1,'Retail Sale Id 2464',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 11:41:27','',''),(2413,'1','313','1',1,'Retail Sale Id 2465',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 11:43:16','',''),(2414,'1','313','1',1,'Retail Sale Id 2466',4260.00,0.00,0.00,6.00,630.00,'2023-03-10 11:44:55','',''),(2415,'1','313','1',1,'Retail Sale Id 2467',27999.30,0.00,0.00,41.79,2716.35,'2023-03-10 11:49:33','',''),(2416,'1','313','1',1,'Retail Sale Id 2468',29820.00,0.00,0.00,42.00,4410.00,'2023-03-10 11:51:44','',''),(2417,'1','313','1',1,'Retail Sale Id 2469',752.60,0.00,0.00,1.06,111.30,'2023-03-10 11:53:10','',''),(2418,'1','313','1',1,'Retail Sale Id 2470',3003.30,0.00,0.00,4.23,444.15,'2023-03-10 11:53:55','',''),(2419,'1','313','1',1,'Retail Sale Id 2472',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 11:57:46','',''),(2420,'1','313','1',1,'Retail Sale Id 2473',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 11:59:22','',''),(2421,'1','313','1',1,'Retail Sale Id 2474',710.00,0.00,0.00,1.00,105.00,'2023-03-10 12:00:40','',''),(2422,'1','313','1',1,'Retail Sale Id 2475',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 12:03:42','',''),(2423,'1','313','1',1,'Retail Sale Id 2476',8520.00,0.00,0.00,12.00,1260.00,'2023-03-10 12:04:59','',''),(2424,'1','313','1',1,'Retail Sale Id 2477',752.60,0.00,0.00,1.06,111.30,'2023-03-10 12:06:17','',''),(2425,'1','313','1',1,'Retail Sale Id 2478',2840.00,0.00,0.00,4.00,420.00,'2023-03-10 12:07:21','',''),(2426,'1','313','1',1,'Retail Sale Id 2479',1448.40,0.00,0.00,2.04,214.20,'2023-03-10 12:09:46','',''),(2427,'1','313','1',1,'Retail Sale Id 2480',8520.00,0.00,0.00,12.00,1260.00,'2023-03-10 12:11:19','',''),(2428,'1','313','1',1,'Retail Sale Id 2481',33500.00,0.00,0.00,50.00,3250.00,'2023-03-10 12:12:25','',''),(2429,'1','313','1',1,'Retail Sale Id 2482',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 12:13:28','',''),(2430,'1','313','1',1,'Retail Sale Id 2483',5680.00,0.00,0.00,8.00,840.00,'2023-03-10 12:15:14','',''),(2431,'1','313','1',1,'Retail Sale Id 2484',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 12:16:20','',''),(2432,'1','313','1',1,'Retail Sale Id 2485',1498.10,0.00,0.00,2.11,221.55,'2023-03-10 12:18:06','',''),(2433,'1','313','1',1,'Retail Sale Id 2486',1001.10,0.00,0.00,1.41,148.05,'2023-03-10 12:20:03','',''),(2434,'1','313','1',1,'Retail Sale Id 2487',8875.00,0.00,0.00,12.50,1312.50,'2023-03-10 12:21:51','',''),(2435,'1','313','1',1,'Return of Retail Sale Id 2437',0.00,4970.00,7.00,0.00,-735.00,'2023-03-10 12:27:37','',''),(2436,'1','313','1',1,'Retail Sale Id 2488',4607.90,0.00,0.00,6.49,681.45,'2023-03-10 12:28:18','',''),(2437,'1','313','1',1,'Retail Sale Id 2489',752.60,0.00,0.00,1.06,111.30,'2023-03-10 12:30:51','',''),(2438,'1','313','1',1,'Retail Sale Id 2490',752.60,0.00,0.00,1.06,111.30,'2023-03-10 12:31:25','',''),(2439,'1','313','1',1,'Retail Sale Id 2491',40200.00,0.00,0.00,60.00,3900.00,'2023-03-10 12:33:37','',''),(2440,'1','313','1',1,'Retail Sale Id 2492',20100.00,0.00,0.00,30.00,1950.00,'2023-03-10 12:36:10','',''),(2441,'1','313','1',1,'Retail Sale Id 2493',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 12:37:14','',''),(2442,'1','313','1',1,'Retail Sale Id 2494',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 12:42:01','',''),(2443,'1','313','1',1,'Retail Sale Id 2495',8520.00,0.00,0.00,12.00,1260.00,'2023-03-10 12:46:31','',''),(2444,'1','313','1',1,'Retail Sale Id 2496',5680.00,0.00,0.00,8.00,840.00,'2023-03-10 12:48:01','',''),(2445,'1','313','1',1,'Retail Sale Id 2497',2680.00,0.00,0.00,4.00,260.00,'2023-03-10 12:52:56','',''),(2446,'1','313','1',1,'Retail Sale Id 2498',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 12:54:21','',''),(2447,'1','313','1',1,'Retail Sale Id 2500',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 13:04:39','',''),(2448,'1','313','1',1,'Retail Sale Id 2501',4260.00,0.00,0.00,6.00,630.00,'2023-03-10 13:06:47','',''),(2449,'1','313','1',1,'Retail Sale Id 2502',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 13:08:22','',''),(2450,'1','313','1',1,'Retail Sale Id 2503',710.00,0.00,0.00,1.00,105.00,'2023-03-10 13:10:39','',''),(2451,'1','313','1',1,'Retail Sale Id 2504',710.00,0.00,0.00,1.00,105.00,'2023-03-10 13:11:53','',''),(2452,'1','313','1',1,'Retail Sale Id 2505',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 13:13:08','',''),(2453,'1','313','1',1,'Retail Sale Id 2506',2840.00,0.00,0.00,4.00,420.00,'2023-03-10 13:17:04','',''),(2454,'1','313','1',1,'Retail Sale Id 2507',100500.00,0.00,0.00,150.00,9750.00,'2023-03-10 13:18:05','',''),(2455,'1','313','1',1,'Retail Sale Id 2508',702.90,0.00,0.00,0.99,103.95,'2023-03-10 13:19:36','',''),(2456,'1','313','1',1,'Retail Sale Id 2509',2399.80,0.00,0.00,3.38,354.90,'2023-03-10 13:21:12','',''),(2457,'1','313','1',1,'Retail Sale Id 2510',67000.00,0.00,0.00,100.00,6500.00,'2023-03-10 13:22:26','',''),(2458,'1','313','1',1,'Retail Sale Id 2511',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 13:23:26','',''),(2459,'1','313','1',1,'Retail Sale Id 2512',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 13:24:39','',''),(2460,'1','313','1',1,'Return of Retail Sale Id 2507',0.00,100500.00,150.00,0.00,-9750.00,'2023-03-10 13:25:29','',''),(2461,'1','313','1',1,'Retail Sale Id 2513',752.60,0.00,0.00,1.06,111.30,'2023-03-10 13:26:25','',''),(2462,'1','313','1',1,'Retail Sale Id 2514',8875.00,0.00,0.00,12.50,1312.50,'2023-03-10 13:30:41','',''),(2463,'1','313','1',1,'Retail Sale Id 2515',8875.00,0.00,0.00,12.50,1312.50,'2023-03-10 13:37:47','',''),(2464,'1','313','1',1,'Retail Sale Id 2516',9940.00,0.00,0.00,14.00,1470.00,'2023-03-10 13:39:25','',''),(2465,'1','313','1',1,'Retail Sale Id 2517',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 13:48:17','',''),(2466,'1','313','1',1,'Retail Sale Id 2518',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 13:49:32','',''),(2467,'1','313','1',1,'Retail Sale Id 2519',1498.10,0.00,0.00,2.11,221.55,'2023-03-10 13:53:27','',''),(2468,'1','313','1',1,'Retail Sale Id 2520',7100.00,0.00,0.00,10.00,1050.00,'2023-03-10 13:56:12','',''),(2469,'1','313','1',1,'Retail Sale Id 2521',2840.00,0.00,0.00,4.00,420.00,'2023-03-10 13:58:40','',''),(2470,'1','313','1',1,'Retail Sale Id 2522',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 14:06:52','',''),(2471,'1','313','1',1,'Retail Sale Id 2523',7100.00,0.00,0.00,10.00,1050.00,'2023-03-10 14:10:34','',''),(2472,'1','313','1',1,'Retail Sale Id 2524',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 14:15:26','',''),(2473,'1','313','1',1,'Retail Sale Id 2525',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 14:24:14','',''),(2474,'1','313','1',1,'Retail Sale Id 2526',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 14:27:08','',''),(2475,'1','313','1',1,'Retail Sale Id 2527',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 14:29:07','',''),(2476,'1','313','1',1,'Retail Sale Id 2529',4970.00,0.00,0.00,7.00,735.00,'2023-03-10 14:32:24','',''),(2477,'1','313','1',1,'Retail Sale Id 2530',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 14:35:17','',''),(2478,'1','313','1',1,'Retail Sale Id 2531',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 14:40:15','',''),(2479,'1','313','1',1,'Retail Sale Id 2532',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 14:41:31','',''),(2480,'1','313','1',1,'Retail Sale Id 2534',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 14:50:33','',''),(2481,'1','313','1',1,'Retail Sale Id 2535',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 14:51:48','',''),(2482,'1','313','1',1,'Retail Sale Id 2536',3550.00,0.00,0.00,5.00,525.00,'2023-03-10 14:52:53','',''),(2483,'1','313','1',1,'Retail Sale Id 2537',17750.00,0.00,0.00,25.00,2625.00,'2023-03-10 14:54:42','',''),(2484,'1','313','1',1,'Retail Sale Id 2538',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 14:57:19','',''),(2485,'1','313','1',1,'Retail Sale Id 2539',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 14:58:53','',''),(2486,'1','313','1',1,'Retail Sale Id 2540',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 15:00:11','',''),(2487,'1','313','1',1,'Retail Sale Id 2541',710.00,0.00,0.00,1.00,105.00,'2023-03-10 15:01:59','',''),(2488,'1','313','1',1,'Retail Sale Id 2542',17750.00,0.00,0.00,25.00,2625.00,'2023-03-10 15:02:37','',''),(2489,'1','313','1',1,'Retail Sale Id 2543',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 15:03:42','',''),(2490,'1','313','1',1,'Retail Sale Id 2544',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 15:05:00','',''),(2491,'1','313','1',1,'Retail Sale Id 2545',17750.00,0.00,0.00,25.00,2625.00,'2023-03-10 15:06:24','',''),(2492,'1','313','1',1,'Retail Sale Id 2546',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 15:07:41','',''),(2493,'1','313','1',1,'Retail Sale Id 2547',5076.50,0.00,0.00,7.15,750.75,'2023-03-10 15:11:19','',''),(2494,'1','313','1',1,'Return of Retail Sale Id 2460',0.00,5680.00,8.00,0.00,-840.00,'2023-03-10 15:13:21','',''),(2495,'1','313','1',1,'Retail Sale Id 2548',7100.00,0.00,0.00,10.00,1050.00,'2023-03-10 15:14:35','',''),(2496,'1','313','1',1,'Retail Sale Id 2549',710.00,0.00,0.00,1.00,105.00,'2023-03-10 15:18:59','',''),(2497,'1','313','1',1,'Retail Sale Id 2550',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 15:22:41','',''),(2498,'1','313','1',1,'Retail Sale Id 2551',710.00,0.00,0.00,1.00,105.00,'2023-03-10 15:23:47','',''),(2499,'1','313','1',1,'Retail Sale Id 2552',10050.00,0.00,0.00,15.00,975.00,'2023-03-10 15:26:18','',''),(2500,'1','313','1',1,'Retail Sale Id 2553',752.60,0.00,0.00,1.06,111.30,'2023-03-10 15:37:02','',''),(2501,'1','313','1',1,'Retail Sale Id 2554',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 15:39:13','',''),(2502,'1','313','1',1,'Retail Sale Id 2555',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 15:40:43','',''),(2503,'1','313','1',1,'Retail Sale Id 2556',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 15:42:00','',''),(2504,'1','313','1',1,'Retail Sale Id 2557',901.70,0.00,0.00,1.27,133.35,'2023-03-10 15:42:44','',''),(2505,'1','313','1',1,'Retail Sale Id 2558',752.60,0.00,0.00,1.06,111.30,'2023-03-10 15:43:45','',''),(2506,'1','313','1',1,'Retail Sale Id 2559',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 15:45:20','',''),(2507,'1','313','1',1,'Retail Sale Id 2560',7100.00,0.00,0.00,10.00,1050.00,'2023-03-10 15:49:30','',''),(2508,'1','313','1',1,'Retail Sale Id 2561',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 15:50:38','',''),(2509,'1','313','1',1,'Retail Sale Id 2562',4260.00,0.00,0.00,6.00,630.00,'2023-03-10 15:51:50','',''),(2510,'1','313','1',1,'Retail Sale Id 2563',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 15:54:11','',''),(2511,'1','313','1',1,'Retail Sale Id 2564',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 15:55:31','',''),(2512,'1','313','1',1,'Retail Sale Id 2565',1420.00,0.00,0.00,2.00,210.00,'2023-03-10 15:58:58','',''),(2513,'1','313','1',1,'Retail Sale Id 2566',4970.00,0.00,0.00,7.00,735.00,'2023-03-10 16:00:44','',''),(2514,'1','313','1',1,'Retail Sale Id 2567',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 16:04:31','',''),(2515,'1','313','1',1,'Retail Sale Id 2568',8875.00,0.00,0.00,12.50,1312.50,'2023-03-10 16:05:39','',''),(2516,'1','313','1',1,'Retail Sale Id 2569',4970.00,0.00,0.00,7.00,735.00,'2023-03-10 16:07:02','',''),(2517,'1','313','1',1,'Retail Sale Id 2570',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 16:09:50','',''),(2518,'1','313','1',1,'Retail Sale Id 2571',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 16:14:20','',''),(2519,'1','313','1',1,'Retail Sale Id 2572',710.00,0.00,0.00,1.00,105.00,'2023-03-10 16:15:52','',''),(2520,'1','313','1',1,'Retail Sale Id 2573',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 16:17:36','',''),(2521,'1','313','1',1,'Retail Sale Id 2575',1398.70,0.00,0.00,1.97,206.85,'2023-03-10 16:23:18','',''),(2522,'1','313','1',1,'Retail Sale Id 2576',3003.30,0.00,0.00,4.23,444.15,'2023-03-10 16:24:16','',''),(2523,'1','313','1',1,'Retail Sale Id 2577',13000.10,0.00,0.00,18.31,1922.55,'2023-03-10 16:26:29','',''),(2524,'1','313','1',1,'Retail Sale Id 2578',710.00,0.00,0.00,1.00,105.00,'2023-03-10 16:31:49','',''),(2525,'1','313','1',1,'Retail Sale Id 2579',710.00,0.00,0.00,1.00,105.00,'2023-03-10 16:35:02','',''),(2526,'1','313','1',1,'Retail Sale Id 2580',4970.00,0.00,0.00,7.00,735.00,'2023-03-10 16:41:03','',''),(2527,'1','313','1',1,'Retail Sale Id 2581',710.00,0.00,0.00,1.00,105.00,'2023-03-10 16:42:20','',''),(2528,'1','313','1',1,'Retail Sale Id 2582',11360.00,0.00,0.00,16.00,1680.00,'2023-03-10 16:44:15','',''),(2529,'1','313','1',1,'Retail Sale Id 2583',23450.00,0.00,0.00,35.00,2275.00,'2023-03-10 16:47:06','',''),(2530,'1','313','1',1,'Retail Sale Id 2584',5680.00,0.00,0.00,8.00,840.00,'2023-03-10 16:49:07','',''),(2531,'1','313','1',1,'Retail Sale Id 2585',20100.00,0.00,0.00,30.00,1950.00,'2023-03-10 16:53:16','',''),(2532,'1','313','1',1,'Retail Sale Id 2588',7810.00,0.00,0.00,11.00,1155.00,'2023-03-10 16:58:49','',''),(2533,'1','313','1',1,'Return of Retail Sale Id 2588',0.00,7810.00,11.00,0.00,-1155.00,'2023-03-10 17:00:57','',''),(2534,'1','313','1',1,'Retail Sale Id 2590',4998.40,0.00,0.00,7.04,739.20,'2023-03-10 17:07:03','',''),(2535,'1','313','1',1,'Retail Sale Id 2591',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 17:09:33','',''),(2536,'1','313','1',1,'Retail Sale Id 2593',4260.00,0.00,0.00,6.00,630.00,'2023-03-10 17:11:07','',''),(2537,'1','313','1',1,'Retail Sale Id 2594',2130.00,0.00,0.00,3.00,315.00,'2023-03-10 17:13:30','',''),(2538,'1','313','1',1,'Retail Sale Id 2595',8875.00,0.00,0.00,12.50,1312.50,'2023-03-10 17:15:03','',''),(2539,'1','313','1',1,'Retail Sale Id 2596',2840.00,0.00,0.00,4.00,420.00,'2023-03-10 17:17:21','',''),(2540,'1','313','1',1,'Return of Retail Sale Id 2536',0.00,3550.00,5.00,0.00,-525.00,'2023-03-10 17:19:18','',''),(2541,'1','313','1',1,'Return of Retail Sale Id 2468',0.00,29820.00,42.00,0.00,-4410.00,'2023-03-10 17:22:33','',''),(2542,'1','313','1',1,'Return of Retail Sale Id 2577',0.00,13000.10,18.31,0.00,-1922.55,'2023-03-10 17:24:17','',''),(2543,'1','313','1',1,'Return of Retail Sale Id 2523',0.00,7100.00,10.00,0.00,-1050.00,'2023-03-10 17:25:37','',''),(2544,'1','313','1',1,'Retail Sale Id 2597',47107.70,0.00,0.00,70.31,4570.15,'2023-03-10 17:26:56','',''),(2545,'1','313','1',1,'Return of Retail Sale Id 2582',0.00,11360.00,16.00,0.00,-1680.00,'2023-03-10 17:45:09','',''),(2546,'1','313','1',1,'Return of Retail Sale Id 2547',0.00,5076.50,7.15,0.00,-750.75,'2023-03-10 17:46:46','',''),(2547,'1','313','1',1,'Retail Sale Id 2598',2563.10,0.00,0.00,3.61,379.05,'2023-03-10 17:47:29','',''),(2548,'1','313','1',1,'Retail Sale Id 2599',2840.00,0.00,0.00,4.00,420.00,'2023-03-10 18:45:44','',''),(2549,'1','313','1',1,'Retail Sale Id 2600',4260.00,0.00,0.00,6.00,630.00,'2023-03-10 18:46:46','',''),(2550,'1','313','1',1,'Return of Retail Sale Id 2599',0.00,2840.00,4.00,0.00,-420.00,'2023-03-10 19:01:58','',''),(2551,'1','313','1',1,'Retail Sale Id 2601',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 08:01:57','',''),(2552,'1','313','1',1,'Retail Sale Id 2602',4998.40,0.00,0.00,7.04,739.20,'2023-03-11 08:02:57','',''),(2553,'1','313','1',1,'Retail Sale Id 2603',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 08:04:16','',''),(2554,'1','313','1',1,'Retail Sale Id 2604',4998.40,0.00,0.00,7.04,739.20,'2023-03-11 08:06:39','',''),(2555,'1','313','1',1,'Retail Sale Id 2605',2499.20,0.00,0.00,3.52,369.60,'2023-03-11 08:07:22','',''),(2556,'1','313','1',1,'Retail Sale Id 2606',4998.40,0.00,0.00,7.04,739.20,'2023-03-11 08:09:29','',''),(2557,'1','313','1',1,'Retail Sale Id 2607',4260.00,0.00,0.00,6.00,630.00,'2023-03-11 08:10:45','',''),(2558,'1','313','1',1,'Retail Sale Id 2608',2002.20,0.00,0.00,2.82,296.10,'2023-03-11 08:11:40','',''),(2559,'1','313','1',1,'Retail Sale Id 2609',5680.00,0.00,0.00,8.00,840.00,'2023-03-11 08:12:41','',''),(2560,'1','313','1',1,'Retail Sale Id 2610',710.00,0.00,0.00,1.00,105.00,'2023-03-11 08:13:46','',''),(2561,'1','313','1',1,'Retail Sale Id 2611',8875.00,0.00,0.00,12.50,1312.50,'2023-03-11 08:14:55','',''),(2562,'1','313','1',1,'Retail Sale Id 2612',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 08:15:32','',''),(2563,'1','313','1',1,'Retail Sale Id 2613',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 08:18:23','',''),(2564,'1','313','1',1,'Retail Sale Id 2614',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 08:18:48','',''),(2565,'1','313','1',1,'Retail Sale Id 2615',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 08:19:41','',''),(2566,'1','313','1',1,'Retail Sale Id 2616',30150.00,0.00,0.00,45.00,2925.00,'2023-03-11 08:21:13','',''),(2567,'1','313','1',1,'Retail Sale Id 2617',1448.40,0.00,0.00,2.04,214.20,'2023-03-11 08:22:08','',''),(2568,'1','313','1',1,'Retail Sale Id 2618',710.00,0.00,0.00,1.00,105.00,'2023-03-11 08:23:20','',''),(2569,'1','313','1',1,'Retail Sale Id 2619',2151.30,0.00,0.00,3.03,318.15,'2023-03-11 08:24:02','',''),(2570,'1','313','1',1,'Retail Sale Id 2620',8520.00,0.00,0.00,12.00,1260.00,'2023-03-11 08:24:49','',''),(2571,'1','313','1',1,'Retail Sale Id 2621',40200.00,0.00,0.00,60.00,3900.00,'2023-03-11 08:26:07','',''),(2572,'1','313','1',1,'Retail Sale Id 2622',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 08:26:54','',''),(2573,'1','313','1',1,'Retail Sale Id 2623',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 08:27:48','',''),(2574,'1','313','1',1,'Retail Sale Id 2624',8875.00,0.00,0.00,12.50,1312.50,'2023-03-11 08:28:35','',''),(2575,'1','313','1',1,'Retail Sale Id 2625',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 08:29:19','',''),(2576,'1','313','1',1,'Retail Sale Id 2626',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 08:30:02','',''),(2577,'1','313','1',1,'Retail Sale Id 2627',40200.00,0.00,0.00,60.00,3900.00,'2023-03-11 08:30:45','',''),(2578,'1','313','1',1,'Retail Sale Id 2628',1448.40,0.00,0.00,2.04,214.20,'2023-03-11 08:31:56','',''),(2579,'1','313','1',1,'Retail Sale Id 2629',33500.00,0.00,0.00,50.00,3250.00,'2023-03-11 08:33:27','',''),(2580,'1','313','1',1,'Retail Sale Id 2630',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 08:34:51','',''),(2581,'1','313','1',1,'Retail Sale Id 2631',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 08:35:27','',''),(2582,'1','313','1',1,'Retail Sale Id 2632',710.00,0.00,0.00,1.00,105.00,'2023-03-11 08:36:47','',''),(2583,'1','313','1',1,'Retail Sale Id 2633',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 08:37:26','',''),(2584,'1','313','1',1,'Retail Sale Id 2634',710.00,0.00,0.00,1.00,105.00,'2023-03-11 08:38:15','',''),(2585,'1','313','1',1,'Retail Sale Id 2635',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 08:39:02','',''),(2586,'1','313','1',1,'Retail Sale Id 2636',2002.20,0.00,0.00,2.82,296.10,'2023-03-11 08:39:39','',''),(2587,'1','313','1',1,'Retail Sale Id 2637',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 08:41:28','',''),(2588,'1','313','1',1,'Retail Sale Id 2638',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 08:42:18','',''),(2589,'1','313','1',1,'Retail Sale Id 2639',8875.00,0.00,0.00,12.50,1312.50,'2023-03-11 08:43:20','',''),(2590,'1','313','1',1,'Retail Sale Id 2640',7100.00,0.00,0.00,10.00,1050.00,'2023-03-11 08:44:11','',''),(2591,'1','313','1',1,'Retail Sale Id 2641',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 08:45:04','',''),(2592,'1','313','1',1,'Retail Sale Id 2642',710.00,0.00,0.00,1.00,105.00,'2023-03-11 08:46:07','',''),(2593,'1','313','1',1,'Retail Sale Id 2643',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 08:47:11','',''),(2594,'1','313','1',1,'Retail Sale Id 2644',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 08:48:16','',''),(2595,'1','313','1',1,'Retail Sale Id 2645',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 08:49:57','',''),(2596,'1','313','1',1,'Retail Sale Id 2646',8520.00,0.00,0.00,12.00,1260.00,'2023-03-11 08:50:32','',''),(2597,'1','313','1',1,'Retail Sale Id 2647',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 08:51:31','',''),(2598,'1','313','1',1,'Retail Sale Id 2648',710.00,0.00,0.00,1.00,105.00,'2023-03-11 08:52:01','',''),(2599,'1','313','1',1,'Retail Sale Id 2649',1498.10,0.00,0.00,2.11,221.55,'2023-03-11 08:52:38','',''),(2600,'1','313','1',1,'Retail Sale Id 2650',8875.00,0.00,0.00,12.50,1312.50,'2023-03-11 08:53:14','',''),(2601,'1','313','1',1,'Retail Sale Id 2651',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 08:54:35','',''),(2602,'1','313','1',1,'Retail Sale Id 2652',41004.00,0.00,0.00,61.20,3978.00,'2023-03-11 08:56:23','',''),(2603,'1','313','1',1,'Retail Sale Id 2653',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 08:57:33','',''),(2604,'1','313','1',1,'Retail Sale Id 2654',5325.00,0.00,0.00,7.50,787.50,'2023-03-11 08:59:00','',''),(2605,'1','313','1',1,'Retail Sale Id 2656',23450.00,0.00,0.00,35.00,2275.00,'2023-03-11 09:03:56','',''),(2606,'1','313','1',1,'Retail Sale Id 2657',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 09:04:47','',''),(2607,'1','313','1',1,'Retail Sale Id 2658',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 09:06:07','',''),(2608,'1','313','1',1,'Retail Sale Id 2659',4260.00,0.00,0.00,6.00,630.00,'2023-03-11 09:07:01','',''),(2609,'1','313','1',1,'Retail Sale Id 2660',901.70,0.00,0.00,1.27,133.35,'2023-03-11 09:09:33','',''),(2610,'1','313','1',1,'Retail Sale Id 2661',1001.10,0.00,0.00,1.41,148.05,'2023-03-11 09:17:01','',''),(2611,'1','313','1',1,'Retail Sale Id 2662',7810.00,0.00,0.00,11.00,1155.00,'2023-03-11 09:18:48','',''),(2612,'1','313','1',1,'Retail Sale Id 2663',710.00,0.00,0.00,1.00,105.00,'2023-03-11 09:19:31','',''),(2613,'1','313','1',1,'Retail Sale Id 2664',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 09:20:42','',''),(2614,'1','313','1',1,'Retail Sale Id 2665',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 09:21:20','',''),(2615,'1','313','1',1,'Retail Sale Id 2666',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 09:22:38','',''),(2616,'1','313','1',1,'Retail Sale Id 2667',110550.00,0.00,0.00,165.00,10725.00,'2023-03-11 09:23:53','',''),(2617,'1','313','1',1,'Retail Sale Id 2669',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 09:25:15','',''),(2618,'1','313','1',1,'Retail Sale Id 2670',7100.00,0.00,0.00,10.00,1050.00,'2023-03-11 09:26:01','',''),(2619,'1','313','1',1,'Retail Sale Id 2671',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 09:27:10','',''),(2620,'1','313','1',1,'Retail Sale Id 2672',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 09:28:04','',''),(2621,'1','313','1',1,'Retail Sale Id 2673',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 09:29:31','',''),(2622,'1','313','1',1,'Retail Sale Id 2674',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 09:30:28','',''),(2623,'1','313','1',1,'Retail Sale Id 2675',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 09:31:18','',''),(2624,'1','313','1',1,'Retail Sale Id 2676',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 09:32:06','',''),(2625,'1','313','1',1,'Retail Sale Id 2677',710.00,0.00,0.00,1.00,105.00,'2023-03-11 09:33:12','',''),(2626,'1','313','1',1,'Retail Sale Id 2678',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 09:34:41','',''),(2627,'1','313','1',1,'Retail Sale Id 2679',702.90,0.00,0.00,0.99,103.95,'2023-03-11 09:35:27','',''),(2628,'1','313','1',1,'Retail Sale Id 2680',8520.00,0.00,0.00,12.00,1260.00,'2023-03-11 09:36:09','',''),(2629,'1','313','1',1,'Retail Sale Id 2681',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 09:37:56','',''),(2630,'1','313','1',1,'Retail Sale Id 2682',8875.00,0.00,0.00,12.50,1312.50,'2023-03-11 09:38:39','',''),(2631,'1','313','1',1,'Retail Sale Id 2683',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 09:39:40','',''),(2632,'1','313','1',1,'Retail Sale Id 2684',1498.10,0.00,0.00,2.11,221.55,'2023-03-11 09:40:35','',''),(2633,'1','313','1',1,'Retail Sale Id 2685',9940.00,0.00,0.00,14.00,1470.00,'2023-03-11 09:43:06','',''),(2634,'1','313','1',1,'Retail Sale Id 2686',1398.70,0.00,0.00,1.97,206.85,'2023-03-11 09:45:04','',''),(2635,'1','313','1',1,'Retail Sale Id 2687',4260.00,0.00,0.00,6.00,630.00,'2023-03-11 09:46:07','',''),(2636,'1','313','1',1,'Retail Sale Id 2688',1498.10,0.00,0.00,2.11,221.55,'2023-03-11 09:47:10','',''),(2637,'1','313','1',1,'Retail Sale Id 2689',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 09:48:16','',''),(2638,'1','313','1',1,'Retail Sale Id 2690',9002.80,0.00,0.00,12.68,1331.40,'2023-03-11 09:49:01','',''),(2639,'1','313','1',1,'Retail Sale Id 2691',8875.00,0.00,0.00,12.50,1312.50,'2023-03-11 09:49:38','',''),(2640,'1','313','1',1,'Retail Sale Id 2693',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 09:50:40','',''),(2641,'1','313','1',1,'Retail Sale Id 2694',2698.00,0.00,0.00,3.80,399.00,'2023-03-11 09:52:21','',''),(2642,'1','313','1',1,'Retail Sale Id 2695',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 09:52:58','',''),(2643,'1','313','1',1,'Retail Sale Id 2696',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 09:53:32','',''),(2644,'1','313','1',1,'Retail Sale Id 2697',8875.00,0.00,0.00,12.50,1312.50,'2023-03-11 09:54:04','',''),(2645,'1','313','1',1,'Retail Sale Id 2698',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 09:56:36','',''),(2646,'1','313','1',1,'Retail Sale Id 2699',3997.30,0.00,0.00,5.63,591.15,'2023-03-11 10:00:04','',''),(2647,'1','313','1',1,'Retail Sale Id 2700',710.00,0.00,0.00,1.00,105.00,'2023-03-11 10:03:16','',''),(2648,'1','313','1',1,'Retail Sale Id 2701',4260.00,0.00,0.00,6.00,630.00,'2023-03-11 10:04:49','',''),(2649,'1','313','1',1,'Retail Sale Id 2702',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 10:07:34','',''),(2650,'1','313','1',1,'Retail Sale Id 2703',15620.00,0.00,0.00,22.00,2310.00,'2023-03-11 10:08:25','',''),(2651,'1','313','1',1,'Retail Sale Id 2704',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 10:10:02','',''),(2652,'1','313','1',1,'Retail Sale Id 2705',3997.30,0.00,0.00,5.63,591.15,'2023-03-11 10:11:52','',''),(2653,'1','313','1',1,'Retail Sale Id 2706',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 10:13:17','',''),(2654,'1','313','1',1,'Retail Sale Id 2707',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 10:14:12','',''),(2655,'1','313','1',1,'Retail Sale Id 2708',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 10:15:48','',''),(2656,'1','313','1',1,'Retail Sale Id 2709',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 10:16:33','',''),(2657,'1','313','1',1,'Retail Sale Id 2710',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 10:18:03','',''),(2658,'1','313','1',1,'Retail Sale Id 2711',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 10:19:26','',''),(2659,'1','313','1',1,'Retail Sale Id 2712',710.00,0.00,0.00,1.00,105.00,'2023-03-11 10:20:51','',''),(2660,'1','313','1',1,'Retail Sale Id 2713',30150.00,0.00,0.00,45.00,2925.00,'2023-03-11 10:22:34','',''),(2661,'1','313','1',1,'Retail Sale Id 2714',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 10:23:36','',''),(2662,'1','313','1',1,'Retail Sale Id 2715',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 10:25:26','',''),(2663,'1','313','1',1,'Retail Sale Id 2716',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 10:26:24','',''),(2664,'1','313','1',1,'Retail Sale Id 2717',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 10:29:03','',''),(2665,'1','313','1',1,'Retail Sale Id 2718',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 10:30:32','',''),(2666,'1','313','1',1,'Retail Sale Id 2719',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 10:32:10','',''),(2667,'1','313','1',1,'Retail Sale Id 2720',1498.10,0.00,0.00,2.11,221.55,'2023-03-11 10:32:53','',''),(2668,'1','313','1',1,'Retail Sale Id 2721',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 10:34:23','',''),(2669,'1','313','1',1,'Retail Sale Id 2722',9230.00,0.00,0.00,13.00,1365.00,'2023-03-11 10:35:18','',''),(2670,'1','313','1',1,'Retail Sale Id 2723',3003.30,0.00,0.00,4.23,444.15,'2023-03-11 10:36:25','',''),(2671,'1','313','1',1,'Retail Sale Id 2724',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 10:38:52','',''),(2672,'1','313','1',1,'Retail Sale Id 2725',7000.60,0.00,0.00,9.86,1035.30,'2023-03-11 10:40:39','',''),(2673,'1','313','1',1,'Retail Sale Id 2726',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 10:41:38','',''),(2674,'1','313','1',1,'Retail Sale Id 2727',4260.00,0.00,0.00,6.00,630.00,'2023-03-11 10:43:08','',''),(2675,'1','313','1',1,'Retail Sale Id 2728',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 10:44:32','',''),(2676,'1','313','1',1,'Retail Sale Id 2729',33500.00,0.00,0.00,50.00,3250.00,'2023-03-11 10:45:26','',''),(2677,'1','313','1',1,'Retail Sale Id 2730',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 10:46:43','',''),(2678,'1','313','1',1,'Retail Sale Id 2731',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 10:48:01','',''),(2679,'1','313','1',1,'Retail Sale Id 2732',3003.30,0.00,0.00,4.23,444.15,'2023-03-11 10:48:49','',''),(2680,'1','313','1',1,'Retail Sale Id 2733',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 10:49:41','',''),(2681,'1','313','1',1,'Retail Sale Id 2734',1498.10,0.00,0.00,2.11,221.55,'2023-03-11 10:50:34','',''),(2682,'1','313','1',1,'Retail Sale Id 2735',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 10:51:30','',''),(2683,'1','313','1',1,'Retail Sale Id 2736',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 10:52:41','',''),(2684,'1','313','1',1,'Retail Sale Id 2738',752.60,0.00,0.00,1.06,111.30,'2023-03-11 10:55:37','',''),(2685,'1','313','1',1,'Retail Sale Id 2739',11390.00,0.00,0.00,17.00,1105.00,'2023-03-11 10:56:34','',''),(2686,'1','313','1',1,'Retail Sale Id 2740',6390.00,0.00,0.00,9.00,945.00,'2023-03-11 10:57:30','',''),(2687,'1','313','1',1,'Retail Sale Id 2741',2002.20,0.00,0.00,2.82,296.10,'2023-03-11 10:58:23','',''),(2688,'1','313','1',1,'Retail Sale Id 2742',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 10:59:07','',''),(2689,'1','313','1',1,'Retail Sale Id 2743',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 11:00:04','',''),(2690,'1','313','1',1,'Retail Sale Id 2744',752.60,0.00,0.00,1.06,111.30,'2023-03-11 11:01:24','',''),(2691,'1','313','1',1,'Retail Sale Id 2745',3997.30,0.00,0.00,5.63,591.15,'2023-03-11 11:02:15','',''),(2692,'1','313','1',1,'Retail Sale Id 2746',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 11:02:52','',''),(2693,'1','313','1',1,'Retail Sale Id 2747',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 11:04:06','',''),(2694,'1','313','1',1,'Retail Sale Id 2748',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 11:06:26','',''),(2695,'1','313','1',1,'Retail Sale Id 2749',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 11:07:36','',''),(2696,'1','313','1',1,'Retail Sale Id 2750',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 11:09:40','',''),(2697,'1','313','1',1,'Retail Sale Id 2751',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 11:10:37','',''),(2698,'1','313','1',1,'Retail Sale Id 2752',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 11:12:50','',''),(2699,'1','313','1',1,'Retail Sale Id 2753',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 11:13:44','',''),(2700,'1','313','1',1,'Retail Sale Id 2754',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 11:14:33','',''),(2701,'1','313','1',1,'Retail Sale Id 2755',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 11:15:20','',''),(2702,'1','313','1',1,'Retail Sale Id 2756',21105.00,0.00,0.00,31.50,2047.50,'2023-03-11 11:16:20','',''),(2703,'1','313','1',1,'Retail Sale Id 2757',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 11:17:17','',''),(2704,'1','313','1',1,'Retail Sale Id 2758',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 11:18:22','',''),(2705,'1','313','1',1,'Retail Sale Id 2759',710.00,0.00,0.00,1.00,105.00,'2023-03-11 11:19:32','',''),(2706,'1','313','1',1,'Retail Sale Id 2760',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 11:20:41','',''),(2707,'1','313','1',1,'Retail Sale Id 2762',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 11:21:35','',''),(2708,'1','313','1',1,'Retail Sale Id 2764',2002.20,0.00,0.00,2.82,296.10,'2023-03-11 11:22:35','',''),(2709,'1','313','1',1,'Retail Sale Id 2765',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 11:23:13','',''),(2710,'1','313','1',1,'Retail Sale Id 2766',4260.00,0.00,0.00,6.00,630.00,'2023-03-11 11:24:00','',''),(2711,'1','313','1',1,'Retail Sale Id 2767',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 11:25:16','',''),(2712,'1','313','1',1,'Retail Sale Id 2768',4615.00,0.00,0.00,6.50,682.50,'2023-03-11 11:26:31','',''),(2713,'1','313','1',1,'Retail Sale Id 2769',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 11:27:20','',''),(2714,'1','313','1',1,'Retail Sale Id 2770',8520.00,0.00,0.00,12.00,1260.00,'2023-03-11 11:28:40','',''),(2715,'1','313','1',1,'Retail Sale Id 2771',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 11:30:55','',''),(2716,'1','313','1',1,'Retail Sale Id 2772',4260.00,0.00,0.00,6.00,630.00,'2023-03-11 11:32:12','',''),(2717,'1','313','1',1,'Retail Sale Id 2773',710.00,0.00,0.00,1.00,105.00,'2023-03-11 11:33:10','',''),(2718,'1','313','1',1,'Retail Sale Id 2774',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 11:34:16','',''),(2719,'1','313','1',1,'Retail Sale Id 2775',710.00,0.00,0.00,1.00,105.00,'2023-03-11 11:36:00','',''),(2720,'1','313','1',1,'Retail Sale Id 2776',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 11:37:07','',''),(2721,'1','313','1',1,'Retail Sale Id 2777',100500.00,0.00,0.00,150.00,9750.00,'2023-03-11 11:40:26','',''),(2722,'1','313','1',1,'Retail Sale Id 2778',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 11:41:51','',''),(2723,'1','313','1',1,'Retail Sale Id 2780',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 11:45:03','',''),(2724,'1','313','1',1,'Retail Sale Id 2781',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 11:46:39','',''),(2725,'1','313','1',1,'Retail Sale Id 2782',9940.00,0.00,0.00,14.00,1470.00,'2023-03-11 11:48:13','',''),(2726,'1','313','1',1,'Retail Sale Id 2783',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 11:50:04','',''),(2727,'1','313','1',1,'Retail Sale Id 2784',7100.00,0.00,0.00,10.00,1050.00,'2023-03-11 11:51:43','',''),(2728,'1','313','1',1,'Retail Sale Id 2785',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 11:52:35','',''),(2729,'1','313','1',1,'Retail Sale Id 2786',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 11:53:58','',''),(2730,'1','313','1',1,'Retail Sale Id 2787',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 11:55:20','',''),(2731,'1','313','1',1,'Retail Sale Id 2788',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 11:56:17','',''),(2732,'1','313','1',1,'Retail Sale Id 2789',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 11:57:21','',''),(2733,'1','313','1',1,'Retail Sale Id 2790',8520.00,0.00,0.00,12.00,1260.00,'2023-03-11 11:58:06','',''),(2734,'1','313','1',1,'Retail Sale Id 2791',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 11:58:45','',''),(2735,'1','313','1',1,'Retail Sale Id 2792',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 11:59:46','',''),(2736,'1','313','1',1,'Retail Sale Id 2793',710.00,0.00,0.00,1.00,105.00,'2023-03-11 12:01:14','',''),(2737,'1','313','1',1,'Retail Sale Id 2794',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 12:10:05','',''),(2738,'1','313','1',1,'Retail Sale Id 2795',4260.00,0.00,0.00,6.00,630.00,'2023-03-11 12:11:52','',''),(2739,'1','313','1',1,'Retail Sale Id 2796',4260.00,0.00,0.00,6.00,630.00,'2023-03-11 12:13:01','',''),(2740,'1','313','1',1,'Retail Sale Id 2797',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 12:14:43','',''),(2741,'1','313','1',1,'Retail Sale Id 2798',15975.00,0.00,0.00,22.50,2362.50,'2023-03-11 12:24:01','',''),(2742,'1','313','1',1,'Retail Sale Id 2799',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 12:25:43','',''),(2743,'1','313','1',1,'Retail Sale Id 2800',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 12:27:07','',''),(2744,'1','313','1',1,'Retail Sale Id 2801',4260.00,0.00,0.00,6.00,630.00,'2023-03-11 12:29:28','',''),(2745,'1','313','1',1,'Retail Sale Id 2802',1001.10,0.00,0.00,1.41,148.05,'2023-03-11 12:31:00','',''),(2746,'1','313','1',1,'Retail Sale Id 2804',3003.30,0.00,0.00,4.23,444.15,'2023-03-11 12:34:01','',''),(2747,'1','313','1',1,'Retail Sale Id 2805',8875.00,0.00,0.00,12.50,1312.50,'2023-03-11 12:35:26','',''),(2748,'1','313','1',1,'Retail Sale Id 2806',8875.00,0.00,0.00,12.50,1312.50,'2023-03-11 12:37:56','',''),(2749,'1','313','1',1,'Retail Sale Id 2807',9230.00,0.00,0.00,13.00,1365.00,'2023-03-11 12:38:33','',''),(2750,'1','313','1',1,'Retail Sale Id 2808',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 12:39:40','',''),(2751,'1','313','1',1,'Retail Sale Id 2809',8520.00,0.00,0.00,12.00,1260.00,'2023-03-11 12:40:58','',''),(2752,'1','313','1',1,'Retail Sale Id 2810',39530.00,0.00,0.00,59.00,3835.00,'2023-03-11 12:43:32','',''),(2753,'1','313','1',1,'Retail Sale Id 2811',4260.00,0.00,0.00,6.00,630.00,'2023-03-11 12:45:23','',''),(2754,'1','313','1',1,'Retail Sale Id 2812',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 12:46:26','',''),(2755,'1','313','1',1,'Retail Sale Id 2813',2499.20,0.00,0.00,3.52,369.60,'2023-03-11 12:48:36','',''),(2756,'1','313','1',1,'Return of Retail Sale Id 2813',0.00,2499.20,3.52,0.00,-369.60,'2023-03-11 12:48:46','',''),(2757,'1','313','1',1,'Retail Sale Id 2814',29962.40,0.00,0.00,44.72,2906.80,'2023-03-11 12:51:12','',''),(2758,'1','313','1',1,'Retail Sale Id 2815',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 12:52:23','',''),(2759,'1','313','1',1,'Retail Sale Id 2816',39550.10,0.00,0.00,59.03,3836.95,'2023-03-11 12:55:14','',''),(2760,'1','313','1',1,'Retail Sale Id 2817',4260.00,0.00,0.00,6.00,630.00,'2023-03-11 12:56:44','',''),(2761,'1','313','1',1,'Retail Sale Id 2818',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 12:57:34','',''),(2762,'1','313','1',1,'Retail Sale Id 2819',4260.00,0.00,0.00,6.00,630.00,'2023-03-11 12:58:42','',''),(2763,'1','313','1',1,'Retail Sale Id 2820',2002.20,0.00,0.00,2.82,296.10,'2023-03-11 12:59:47','',''),(2764,'1','313','1',1,'Retail Sale Id 2822',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 13:01:37','',''),(2765,'1','313','1',1,'Retail Sale Id 2823',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 13:02:35','',''),(2766,'1','313','1',1,'Retail Sale Id 2824',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 13:03:37','',''),(2767,'1','313','1',1,'Retail Sale Id 2825',2002.20,0.00,0.00,2.82,296.10,'2023-03-11 13:04:21','',''),(2768,'1','313','1',1,'Retail Sale Id 2826',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 13:05:33','',''),(2769,'1','313','1',1,'Retail Sale Id 2827',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 13:06:48','',''),(2770,'1','313','1',1,'Retail Sale Id 2828',33500.00,0.00,0.00,50.00,3250.00,'2023-03-11 13:08:39','',''),(2771,'1','313','1',1,'Retail Sale Id 2829',4260.00,0.00,0.00,6.00,630.00,'2023-03-11 13:10:07','',''),(2772,'1','313','1',1,'Retail Sale Id 2830',8875.00,0.00,0.00,12.50,1312.50,'2023-03-11 13:11:57','',''),(2773,'1','313','1',1,'Retail Sale Id 2831',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 13:13:02','',''),(2774,'1','313','1',1,'Retail Sale Id 2832',4260.00,0.00,0.00,6.00,630.00,'2023-03-11 13:14:13','',''),(2775,'1','313','1',1,'Retail Sale Id 2833',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 13:15:18','',''),(2776,'1','313','1',1,'Retail Sale Id 2834',4615.00,0.00,0.00,6.50,682.50,'2023-03-11 13:16:21','',''),(2777,'1','313','1',1,'Retail Sale Id 2835',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 13:17:31','',''),(2778,'1','313','1',1,'Retail Sale Id 2836',8875.00,0.00,0.00,12.50,1312.50,'2023-03-11 13:18:40','',''),(2779,'1','313','1',1,'Retail Sale Id 2837',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 13:19:46','',''),(2780,'1','313','1',1,'Retail Sale Id 2838',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 13:20:51','',''),(2781,'1','313','1',1,'Retail Sale Id 2839',710.00,0.00,0.00,1.00,105.00,'2023-03-11 13:23:14','',''),(2782,'1','313','1',1,'Retail Sale Id 2840',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 13:26:33','',''),(2783,'1','313','1',1,'Retail Sale Id 2841',79060.00,0.00,0.00,118.00,7670.00,'2023-03-11 13:29:35','',''),(2784,'1','313','1',1,'Retail Sale Id 2842',710.00,0.00,0.00,1.00,105.00,'2023-03-11 13:30:32','',''),(2785,'1','313','1',1,'Retail Sale Id 2843',5680.00,0.00,0.00,8.00,840.00,'2023-03-11 13:31:37','',''),(2786,'1','313','1',1,'Retail Sale Id 2844',100500.00,0.00,0.00,150.00,9750.00,'2023-03-11 13:34:12','',''),(2787,'1','313','1',1,'Retail Sale Id 2845',1001.10,0.00,0.00,1.41,148.05,'2023-03-11 13:35:12','',''),(2788,'1','313','1',1,'Retail Sale Id 2846',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 13:36:27','',''),(2789,'1','313','1',1,'Retail Sale Id 2847',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 13:38:13','',''),(2790,'1','313','1',1,'Retail Sale Id 2848',4260.00,0.00,0.00,6.00,630.00,'2023-03-11 13:39:51','',''),(2791,'1','313','1',1,'Retail Sale Id 2849',3003.30,0.00,0.00,4.23,444.15,'2023-03-11 13:40:45','',''),(2792,'1','313','1',1,'Retail Sale Id 2850',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 13:43:56','',''),(2793,'1','313','1',1,'Retail Sale Id 2851',1001.10,0.00,0.00,1.41,148.05,'2023-03-11 13:44:57','',''),(2794,'1','313','1',1,'Retail Sale Id 2852',4998.40,0.00,0.00,7.04,739.20,'2023-03-11 13:47:07','',''),(2795,'1','313','1',1,'Return of Retail Sale Id 2843',0.00,5680.00,8.00,0.00,-840.00,'2023-03-11 13:47:44','',''),(2796,'1','313','1',1,'Retail Sale Id 2853',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 13:48:23','',''),(2797,'1','313','1',1,'Retail Sale Id 2854',710.00,0.00,0.00,1.00,105.00,'2023-03-11 13:49:23','',''),(2798,'1','313','1',1,'Retail Sale Id 2855',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 13:52:04','',''),(2799,'1','313','1',1,'Retail Sale Id 2856',4260.00,0.00,0.00,6.00,630.00,'2023-03-11 13:54:23','',''),(2800,'1','313','1',1,'Retail Sale Id 2857',1902.80,0.00,0.00,2.68,281.40,'2023-03-11 14:02:12','',''),(2801,'1','313','1',1,'Retail Sale Id 2858',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 14:04:37','',''),(2802,'1','313','1',1,'Retail Sale Id 2859',39764.50,0.00,0.00,59.35,3857.75,'2023-03-11 14:06:52','',''),(2803,'1','313','1',1,'Return of Retail Sale Id 2627',0.00,40200.00,60.00,0.00,-3900.00,'2023-03-11 14:08:11','',''),(2804,'1','313','1',1,'Retail Sale Id 2860',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 14:09:36','',''),(2805,'1','313','1',1,'Retail Sale Id 2861',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 14:11:34','',''),(2806,'1','313','1',1,'Retail Sale Id 2862',5680.00,0.00,0.00,8.00,840.00,'2023-03-11 14:14:06','',''),(2807,'1','313','1',1,'Retail Sale Id 2863',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 14:15:18','',''),(2808,'1','313','1',1,'Retail Sale Id 2864',67000.00,0.00,0.00,100.00,6500.00,'2023-03-11 14:17:16','',''),(2809,'1','313','1',1,'Retail Sale Id 2865',8875.00,0.00,0.00,12.50,1312.50,'2023-03-11 14:18:36','',''),(2810,'1','313','1',1,'Retail Sale Id 2866',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 14:22:27','',''),(2811,'1','313','1',1,'Retail Sale Id 2867',710.00,0.00,0.00,1.00,105.00,'2023-03-11 14:24:05','',''),(2812,'1','313','1',1,'Retail Sale Id 2868',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 14:25:33','',''),(2813,'1','313','1',1,'Retail Sale Id 2869',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 14:35:34','',''),(2814,'1','313','1',1,'Retail Sale Id 2870',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 14:36:15','',''),(2815,'1','313','1',1,'Retail Sale Id 2871',8875.00,0.00,0.00,12.50,1312.50,'2023-03-11 14:37:23','',''),(2816,'1','313','1',1,'Retail Sale Id 2872',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 14:38:15','',''),(2817,'1','313','1',1,'Retail Sale Id 2873',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 14:39:01','',''),(2818,'1','313','1',1,'Retail Sale Id 2874',710.00,0.00,0.00,1.00,105.00,'2023-03-11 14:40:22','',''),(2819,'1','313','1',1,'Retail Sale Id 2875',80400.00,0.00,0.00,120.00,7800.00,'2023-03-11 14:43:22','',''),(2820,'1','313','1',1,'Retail Sale Id 2876',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 14:44:38','',''),(2821,'1','313','1',1,'Retail Sale Id 2877',5680.00,0.00,0.00,8.00,840.00,'2023-03-11 14:45:25','',''),(2822,'1','313','1',1,'Retail Sale Id 2878',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 14:46:57','',''),(2823,'1','313','1',1,'Retail Sale Id 2879',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 14:49:22','',''),(2824,'1','313','1',1,'Retail Sale Id 2880',40200.00,0.00,0.00,60.00,3900.00,'2023-03-11 14:51:41','',''),(2825,'1','313','1',1,'Retail Sale Id 2881',710.00,0.00,0.00,1.00,105.00,'2023-03-11 14:52:39','',''),(2826,'1','313','1',1,'Retail Sale Id 2882',3003.30,0.00,0.00,4.23,444.15,'2023-03-11 14:55:26','',''),(2827,'1','313','1',1,'Retail Sale Id 2883',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 14:56:44','',''),(2828,'1','313','1',1,'Retail Sale Id 2884',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 14:58:15','',''),(2829,'1','313','1',1,'Retail Sale Id 2885',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 15:30:49','',''),(2830,'1','313','1',1,'Retail Sale Id 2886',39878.40,0.00,0.00,59.52,3868.80,'2023-03-11 15:34:31','',''),(2831,'1','313','1',1,'Retail Sale Id 2887',710.00,0.00,0.00,1.00,105.00,'2023-03-11 15:35:30','',''),(2832,'1','313','1',1,'Return of Retail Sale Id 2880',0.00,40200.00,60.00,0.00,-3900.00,'2023-03-11 15:36:29','',''),(2833,'1','313','1',1,'Retail Sale Id 2888',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 15:37:24','',''),(2834,'1','313','1',1,'Retail Sale Id 2889',1448.40,0.00,0.00,2.04,214.20,'2023-03-11 15:38:27','',''),(2835,'1','313','1',1,'Retail Sale Id 2890',8875.00,0.00,0.00,12.50,1312.50,'2023-03-11 15:39:06','',''),(2836,'1','313','1',1,'Retail Sale Id 2891',710.00,0.00,0.00,1.00,105.00,'2023-03-11 15:39:39','',''),(2837,'1','313','1',1,'Retail Sale Id 2892',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 15:40:54','',''),(2838,'1','313','1',1,'Retail Sale Id 2893',7497.60,0.00,0.00,10.56,1108.80,'2023-03-11 15:41:42','',''),(2839,'1','313','1',1,'Retail Sale Id 2894',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 15:43:35','',''),(2840,'1','313','1',1,'Retail Sale Id 2895',710.00,0.00,0.00,1.00,105.00,'2023-03-11 15:44:41','',''),(2841,'1','313','1',1,'Retail Sale Id 2896',710.00,0.00,0.00,1.00,105.00,'2023-03-11 15:46:08','',''),(2842,'1','313','1',1,'Retail Sale Id 2897',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 15:52:35','',''),(2843,'1','313','1',1,'Retail Sale Id 2898',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 15:53:31','',''),(2844,'1','313','1',1,'Retail Sale Id 2899',1001.10,0.00,0.00,1.41,148.05,'2023-03-11 15:54:52','',''),(2845,'1','313','1',1,'Retail Sale Id 2900',8520.00,0.00,0.00,12.00,1260.00,'2023-03-11 15:56:29','',''),(2846,'1','313','1',1,'Retail Sale Id 2901',8875.00,0.00,0.00,12.50,1312.50,'2023-03-11 15:56:58','',''),(2847,'1','313','1',1,'Retail Sale Id 2902',4260.00,0.00,0.00,6.00,630.00,'2023-03-11 16:00:13','',''),(2848,'1','313','1',1,'Retail Sale Id 2903',2101.60,0.00,0.00,2.96,310.80,'2023-03-11 16:01:38','',''),(2849,'1','313','1',1,'Retail Sale Id 2904',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 16:02:48','',''),(2850,'1','313','1',1,'Retail Sale Id 2905',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 16:03:36','',''),(2851,'1','313','1',1,'Retail Sale Id 2906',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 16:05:21','',''),(2852,'1','313','1',1,'Retail Sale Id 2907',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 16:08:34','',''),(2853,'1','313','1',1,'Retail Sale Id 2908',8875.00,0.00,0.00,12.50,1312.50,'2023-03-11 16:09:23','',''),(2854,'1','313','1',1,'Retail Sale Id 2909',26800.00,0.00,0.00,40.00,2600.00,'2023-03-11 16:11:36','',''),(2855,'1','313','1',1,'Retail Sale Id 2910',7810.00,0.00,0.00,11.00,1155.00,'2023-03-11 16:12:24','',''),(2856,'1','313','1',1,'Retail Sale Id 2911',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 16:17:11','',''),(2857,'1','313','1',1,'Retail Sale Id 2912',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 16:18:16','',''),(2858,'1','313','1',1,'Retail Sale Id 2913',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 16:20:20','',''),(2859,'1','313','1',1,'Retail Sale Id 2914',2680.00,0.00,0.00,4.00,260.00,'2023-03-11 16:21:57','',''),(2860,'1','313','1',1,'Retail Sale Id 2915',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 16:23:31','',''),(2861,'1','313','1',1,'Retail Sale Id 2916',3500.30,0.00,0.00,4.93,517.65,'2023-03-11 16:25:01','',''),(2862,'1','313','1',1,'Retail Sale Id 2917',2002.20,0.00,0.00,2.82,296.10,'2023-03-11 16:26:14','',''),(2863,'1','313','1',1,'Retail Sale Id 2918',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 16:27:39','',''),(2864,'1','313','1',1,'Retail Sale Id 2919',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 16:28:56','',''),(2865,'1','313','1',1,'Retail Sale Id 2920',7100.00,0.00,0.00,10.00,1050.00,'2023-03-11 16:29:49','',''),(2866,'1','313','1',1,'Retail Sale Id 2921',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 16:30:42','',''),(2867,'1','313','1',1,'Retail Sale Id 2922',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 16:33:30','',''),(2868,'1','313','1',1,'Retail Sale Id 2923',2002.20,0.00,0.00,2.82,296.10,'2023-03-11 16:35:17','',''),(2869,'1','313','1',1,'Retail Sale Id 2924',7100.00,0.00,0.00,10.00,1050.00,'2023-03-11 16:36:15','',''),(2870,'1','313','1',1,'Retail Sale Id 2925',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 16:37:15','',''),(2871,'1','313','1',1,'Retail Sale Id 2926',40541.70,0.00,0.00,60.51,3933.15,'2023-03-11 16:38:04','',''),(2872,'1','313','1',1,'Retail Sale Id 2927',80400.00,0.00,0.00,120.00,7800.00,'2023-03-11 16:39:05','',''),(2873,'1','313','1',1,'Retail Sale Id 2928',7100.00,0.00,0.00,10.00,1050.00,'2023-03-11 16:40:07','',''),(2874,'1','313','1',1,'Retail Sale Id 2929',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 16:40:41','',''),(2875,'1','313','1',1,'Retail Sale Id 2930',8875.00,0.00,0.00,12.50,1312.50,'2023-03-11 16:41:21','',''),(2876,'1','313','1',1,'Retail Sale Id 2931',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 16:42:27','',''),(2877,'1','313','1',1,'Retail Sale Id 2932',4970.00,0.00,0.00,7.00,735.00,'2023-03-11 16:43:49','',''),(2878,'1','313','1',1,'Retail Sale Id 2933',8875.00,0.00,0.00,12.50,1312.50,'2023-03-11 16:45:28','',''),(2879,'1','313','1',1,'Retail Sale Id 2934',710.00,0.00,0.00,1.00,105.00,'2023-03-11 16:45:57','',''),(2880,'1','313','1',1,'Retail Sale Id 2935',41540.00,0.00,0.00,62.00,4030.00,'2023-03-11 16:46:39','',''),(2881,'1','313','1',1,'Retail Sale Id 2936',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 16:47:32','',''),(2882,'1','313','1',1,'Retail Sale Id 2937',2002.20,0.00,0.00,2.82,296.10,'2023-03-11 16:48:19','',''),(2883,'1','313','1',1,'Retail Sale Id 2938',1498.10,0.00,0.00,2.11,221.55,'2023-03-11 16:49:51','',''),(2884,'1','313','1',1,'Retail Sale Id 2939',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 16:51:52','',''),(2885,'1','313','1',1,'Retail Sale Id 2940',3550.00,0.00,0.00,5.00,525.00,'2023-03-11 16:52:25','',''),(2886,'1','313','1',1,'Retail Sale Id 2941',1448.40,0.00,0.00,2.04,214.20,'2023-03-11 16:53:36','',''),(2887,'1','313','1',1,'Retail Sale Id 2942',710.00,0.00,0.00,1.00,105.00,'2023-03-11 16:54:41','',''),(2888,'1','313','1',1,'Retail Sale Id 2943',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 16:55:30','',''),(2889,'1','313','1',1,'Retail Sale Id 2944',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 16:56:04','',''),(2890,'1','313','1',1,'Retail Sale Id 2945',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 16:57:04','',''),(2891,'1','313','1',1,'Retail Sale Id 2946',1001.10,0.00,0.00,1.41,148.05,'2023-03-11 16:57:46','',''),(2892,'1','313','1',1,'Retail Sale Id 2947',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 16:58:12','',''),(2893,'1','313','1',1,'Retail Sale Id 2948',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 16:58:44','',''),(2894,'1','313','1',1,'Retail Sale Id 2949',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 16:59:24','',''),(2895,'1','313','1',1,'Retail Sale Id 2950',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 17:00:38','',''),(2896,'1','313','1',1,'Retail Sale Id 2951',710.00,0.00,0.00,1.00,105.00,'2023-03-11 17:01:12','',''),(2897,'1','313','1',1,'Retail Sale Id 2952',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 17:04:09','',''),(2898,'1','313','1',1,'Retail Sale Id 2953',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 17:07:44','',''),(2899,'1','313','1',1,'Retail Sale Id 2954',40200.00,0.00,0.00,60.00,3900.00,'2023-03-11 17:14:40','',''),(2900,'1','313','1',1,'Retail Sale Id 2955',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 17:15:13','',''),(2901,'1','313','1',1,'Retail Sale Id 2956',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 17:16:14','',''),(2902,'1','313','1',1,'Retail Sale Id 2957',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 17:17:16','',''),(2903,'1','313','1',1,'Retail Sale Id 2958',7100.00,0.00,0.00,10.00,1050.00,'2023-03-11 17:18:20','',''),(2904,'1','313','1',1,'Retail Sale Id 2959',710.00,0.00,0.00,1.00,105.00,'2023-03-11 17:20:54','',''),(2905,'1','313','1',1,'Retail Sale Id 2960',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 17:21:43','',''),(2906,'1','313','1',1,'Retail Sale Id 2961',2130.00,0.00,0.00,3.00,315.00,'2023-03-11 17:23:23','',''),(2907,'1','313','1',1,'Retail Sale Id 2962',710.00,0.00,0.00,1.00,105.00,'2023-03-11 17:27:56','',''),(2908,'1','313','1',1,'Retail Sale Id 2963',710.00,0.00,0.00,1.00,105.00,'2023-03-11 17:32:19','',''),(2909,'1','313','1',1,'Retail Sale Id 2964',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 17:33:24','',''),(2910,'1','313','1',1,'Retail Sale Id 2965',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 17:35:04','',''),(2911,'1','313','1',1,'Retail Sale Id 2966',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 17:37:25','',''),(2912,'1','313','1',1,'Retail Sale Id 2967',702.90,0.00,0.00,0.99,103.95,'2023-03-11 17:38:43','',''),(2913,'1','313','1',1,'Retail Sale Id 2968',1420.00,0.00,0.00,2.00,210.00,'2023-03-11 17:41:59','',''),(2914,'1','313','1',1,'Retail Sale Id 2969',710.00,0.00,0.00,1.00,105.00,'2023-03-11 17:42:42','',''),(2915,'1','313','1',1,'Retail Sale Id 2970',2840.00,0.00,0.00,4.00,420.00,'2023-03-11 17:46:45','',''),(2916,'1','313','1',1,'Retail Sale Id 2972',4260.00,0.00,0.00,6.00,630.00,'2023-03-11 17:50:25','',''),(2917,'1','313','1',1,'Return of Retail Sale Id 2953',0.00,2840.00,4.00,0.00,-420.00,'2023-03-11 18:07:23','',''),(2918,'1','313','1',1,'Retail Sale Id 2973',1980.90,0.00,0.00,2.79,292.95,'2023-03-11 18:08:04','',''),(2919,'1','313','1',1,'Return of Retail Sale Id 2756',0.00,21105.00,31.50,0.00,-2047.50,'2023-03-11 18:10:25','',''),(2920,'1','313','1',1,'Retail Sale Id 2974',21265.80,0.00,0.00,31.74,2063.10,'2023-03-11 18:11:12','',''),(2921,'1','313','1',1,'Return of Retail Sale Id 2713',0.00,30150.00,45.00,0.00,-2925.00,'2023-03-11 18:15:20','',''),(2922,'1','313','1',1,'Retail Sale Id 2975',29828.40,0.00,0.00,44.52,2893.80,'2023-03-11 18:16:06','',''),(2923,'1','313','1',1,'Retail Sale Id 2976',2002.20,0.00,0.00,2.82,296.10,'2023-03-12 10:29:34','',''),(2924,'1','313','1',1,'Retail Sale Id 2977',3550.00,0.00,0.00,5.00,525.00,'2023-03-12 10:30:33','',''),(2925,'1','313','1',1,'Retail Sale Id 2978',710.00,0.00,0.00,1.00,105.00,'2023-03-12 10:31:59','',''),(2926,'1','313','1',1,'Retail Sale Id 2979',1498.10,0.00,0.00,2.11,221.55,'2023-03-12 10:32:37','',''),(2927,'1','313','1',1,'Retail Sale Id 2980',2130.00,0.00,0.00,3.00,315.00,'2023-03-12 10:35:50','',''),(2928,'1','313','1',1,'Retail Sale Id 2981',3550.00,0.00,0.00,5.00,525.00,'2023-03-12 10:36:58','',''),(2929,'1','313','1',1,'Retail Sale Id 2982',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 10:39:48','',''),(2930,'1','313','1',1,'Retail Sale Id 2984',752.60,0.00,0.00,1.06,111.30,'2023-03-12 10:42:11','',''),(2931,'1','313','1',1,'Retail Sale Id 2985',2130.00,0.00,0.00,3.00,315.00,'2023-03-12 10:43:27','',''),(2932,'1','313','1',1,'Retail Sale Id 2986',8875.00,0.00,0.00,12.50,1312.50,'2023-03-12 10:46:21','',''),(2933,'1','313','1',1,'Retail Sale Id 2987',30150.00,0.00,0.00,45.00,2925.00,'2023-03-12 10:49:38','',''),(2934,'1','313','1',1,'Retail Sale Id 2988',710.00,0.00,0.00,1.00,105.00,'2023-03-12 10:50:31','',''),(2935,'1','313','1',1,'Retail Sale Id 2989',802.30,0.00,0.00,1.13,118.65,'2023-03-12 10:51:46','',''),(2936,'1','313','1',1,'Retail Sale Id 2990',29513.50,0.00,0.00,44.05,2863.25,'2023-03-12 10:58:04','',''),(2937,'1','313','1',1,'Return of Retail Sale Id 2987',0.00,30150.00,45.00,0.00,-2925.00,'2023-03-12 10:58:46','',''),(2938,'1','313','1',1,'Retail Sale Id 2991',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 11:01:50','',''),(2939,'1','313','1',1,'Retail Sale Id 2992',7100.00,0.00,0.00,10.00,1050.00,'2023-03-12 11:03:13','',''),(2940,'1','313','1',1,'Retail Sale Id 2993',710.00,0.00,0.00,1.00,105.00,'2023-03-12 11:04:22','',''),(2941,'1','313','1',1,'Retail Sale Id 2994',1001.10,0.00,0.00,1.41,148.05,'2023-03-12 11:05:32','',''),(2942,'1','313','1',1,'Retail Sale Id 2995',2840.00,0.00,0.00,4.00,420.00,'2023-03-12 11:07:48','',''),(2943,'1','313','1',1,'Retail Sale Id 2996',2130.00,0.00,0.00,3.00,315.00,'2023-03-12 11:10:26','',''),(2944,'1','313','1',1,'Retail Sale Id 2998',3003.30,0.00,0.00,4.23,444.15,'2023-03-12 11:13:08','',''),(2945,'1','313','1',1,'Retail Sale Id 2999',2499.20,0.00,0.00,3.52,369.60,'2023-03-12 11:14:02','',''),(2946,'1','313','1',1,'Retail Sale Id 3000',2130.00,0.00,0.00,3.00,315.00,'2023-03-12 11:15:22','',''),(2947,'1','313','1',1,'Retail Sale Id 3001',3550.00,0.00,0.00,5.00,525.00,'2023-03-12 11:16:38','',''),(2948,'1','313','1',1,'Retail Sale Id 3002',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 11:19:53','',''),(2949,'1','313','1',1,'Retail Sale Id 3003',1001.10,0.00,0.00,1.41,148.05,'2023-03-12 11:20:29','',''),(2950,'1','313','1',1,'Retail Sale Id 3004',2840.00,0.00,0.00,4.00,420.00,'2023-03-12 11:23:41','',''),(2951,'1','313','1',1,'Retail Sale Id 3005',31999.20,0.00,0.00,47.76,3104.40,'2023-03-12 11:29:39','',''),(2952,'1','313','1',1,'Retail Sale Id 3006',7100.00,0.00,0.00,10.00,1050.00,'2023-03-12 11:31:34','',''),(2953,'1','313','1',1,'Retail Sale Id 3008',2130.00,0.00,0.00,3.00,315.00,'2023-03-12 11:39:36','',''),(2954,'1','313','1',1,'Retail Sale Id 3009',7000.60,0.00,0.00,9.86,1035.30,'2023-03-12 11:48:45','',''),(2955,'1','313','1',1,'Retail Sale Id 3010',8875.00,0.00,0.00,12.50,1312.50,'2023-03-12 11:51:02','',''),(2956,'1','313','1',1,'Retail Sale Id 3011',1448.40,0.00,0.00,2.04,214.20,'2023-03-12 11:53:20','',''),(2957,'1','313','1',1,'Retail Sale Id 3012',3550.00,0.00,0.00,5.00,525.00,'2023-03-12 11:59:55','',''),(2958,'1','313','1',1,'Retail Sale Id 3013',4970.00,0.00,0.00,7.00,735.00,'2023-03-12 12:03:33','',''),(2959,'1','313','1',1,'Retail Sale Id 3014',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 12:04:17','',''),(2960,'1','313','1',1,'Retail Sale Id 3015',8875.00,0.00,0.00,12.50,1312.50,'2023-03-12 12:05:53','',''),(2961,'1','313','1',1,'Retail Sale Id 3016',7100.00,0.00,0.00,10.00,1050.00,'2023-03-12 12:08:51','',''),(2962,'1','313','1',1,'Retail Sale Id 3017',87100.00,0.00,0.00,130.00,8450.00,'2023-03-12 12:09:50','',''),(2963,'1','313','1',1,'Retail Sale Id 3018',4260.00,0.00,0.00,6.00,630.00,'2023-03-12 12:10:58','',''),(2964,'1','313','1',1,'Retail Sale Id 3019',2130.00,0.00,0.00,3.00,315.00,'2023-03-12 12:12:06','',''),(2965,'1','313','1',1,'Retail Sale Id 3020',1001.10,0.00,0.00,1.41,148.05,'2023-03-12 12:19:10','',''),(2966,'1','313','1',1,'Retail Sale Id 3021',710.00,0.00,0.00,1.00,105.00,'2023-03-12 12:23:25','',''),(2967,'1','313','1',1,'Retail Sale Id 3022',7100.00,0.00,0.00,10.00,1050.00,'2023-03-12 12:24:35','',''),(2968,'1','313','1',1,'Retail Sale Id 3023',8875.00,0.00,0.00,12.50,1312.50,'2023-03-12 12:26:37','',''),(2969,'1','313','1',1,'Retail Sale Id 3024',2130.00,0.00,0.00,3.00,315.00,'2023-03-12 12:28:44','',''),(2970,'1','313','1',1,'Retail Sale Id 3025',2499.20,0.00,0.00,3.52,369.60,'2023-03-12 12:30:06','',''),(2971,'1','313','1',1,'Retail Sale Id 3026',3550.00,0.00,0.00,5.00,525.00,'2023-03-12 12:32:41','',''),(2972,'1','313','1',1,'Retail Sale Id 3027',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 12:34:01','',''),(2973,'1','313','1',1,'Retail Sale Id 3028',7100.00,0.00,0.00,10.00,1050.00,'2023-03-12 12:36:30','',''),(2974,'1','313','1',1,'Retail Sale Id 3029',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 12:37:54','',''),(2975,'1','313','1',1,'Retail Sale Id 3030',3003.30,0.00,0.00,4.23,444.15,'2023-03-12 12:39:44','',''),(2976,'1','313','1',1,'Retail Sale Id 3031',4970.00,0.00,0.00,7.00,735.00,'2023-03-12 12:44:23','',''),(2977,'1','313','1',1,'Retail Sale Id 3032',710.00,0.00,0.00,1.00,105.00,'2023-03-12 12:45:00','',''),(2978,'1','313','1',1,'Retail Sale Id 3033',8875.00,0.00,0.00,12.50,1312.50,'2023-03-12 12:56:52','',''),(2979,'1','313','1',1,'Retail Sale Id 3034',3550.00,0.00,0.00,5.00,525.00,'2023-03-12 12:59:55','',''),(2980,'1','313','1',1,'Retail Sale Id 3035',40200.00,0.00,0.00,60.00,3900.00,'2023-03-12 13:01:46','',''),(2981,'1','313','1',1,'Retail Sale Id 3036',8875.00,0.00,0.00,12.50,1312.50,'2023-03-12 13:04:37','',''),(2982,'1','313','1',1,'Retail Sale Id 3037',4998.40,0.00,0.00,7.04,739.20,'2023-03-12 13:15:37','',''),(2983,'1','313','1',1,'Retail Sale Id 3038',2130.00,0.00,0.00,3.00,315.00,'2023-03-12 13:17:53','',''),(2984,'1','313','1',1,'Retail Sale Id 3039',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 13:32:31','',''),(2985,'1','313','1',1,'Retail Sale Id 3040',752.60,0.00,0.00,1.06,111.30,'2023-03-12 13:34:32','',''),(2986,'1','313','1',1,'Retail Sale Id 3041',2130.00,0.00,0.00,3.00,315.00,'2023-03-12 13:35:21','',''),(2987,'1','313','1',1,'Retail Sale Id 3042',2840.00,0.00,0.00,4.00,420.00,'2023-03-12 13:36:39','',''),(2988,'1','313','1',1,'Retail Sale Id 3043',4260.00,0.00,0.00,6.00,630.00,'2023-03-12 13:44:56','',''),(2989,'1','313','1',1,'Retail Sale Id 3044',4970.00,0.00,0.00,7.00,735.00,'2023-03-12 13:47:23','',''),(2990,'1','313','1',1,'Retail Sale Id 3045',1299.30,0.00,0.00,1.83,192.15,'2023-03-12 13:49:10','',''),(2991,'1','313','1',1,'Retail Sale Id 3046',2840.00,0.00,0.00,4.00,420.00,'2023-03-12 13:55:51','',''),(2992,'1','313','1',1,'Retail Sale Id 3047',9940.00,0.00,0.00,14.00,1470.00,'2023-03-12 14:01:05','',''),(2993,'1','313','1',1,'Retail Sale Id 3048',4970.00,0.00,0.00,7.00,735.00,'2023-03-12 14:06:56','',''),(2994,'1','313','1',1,'Retail Sale Id 3049',752.60,0.00,0.00,1.06,111.30,'2023-03-12 14:09:14','',''),(2995,'1','313','1',1,'Retail Sale Id 3050',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 14:13:57','',''),(2996,'1','313','1',1,'Retail Sale Id 3051',2130.00,0.00,0.00,3.00,315.00,'2023-03-12 14:15:13','',''),(2997,'1','313','1',1,'Retail Sale Id 3052',4970.00,0.00,0.00,7.00,735.00,'2023-03-12 14:16:54','',''),(2998,'1','313','1',1,'Retail Sale Id 3053',1001.10,0.00,0.00,1.41,148.05,'2023-03-12 14:22:53','',''),(2999,'1','313','1',1,'Retail Sale Id 3054',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 14:25:41','',''),(3000,'1','313','1',1,'Retail Sale Id 3055',2130.00,0.00,0.00,3.00,315.00,'2023-03-12 14:26:38','',''),(3001,'1','313','1',1,'Retail Sale Id 3056',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 14:28:25','',''),(3002,'1','313','1',1,'Retail Sale Id 3057',3550.00,0.00,0.00,5.00,525.00,'2023-03-12 14:32:32','',''),(3003,'1','313','1',1,'Retail Sale Id 3058',1498.10,0.00,0.00,2.11,221.55,'2023-03-12 14:33:15','',''),(3004,'1','313','1',1,'Retail Sale Id 3059',4260.00,0.00,0.00,6.00,630.00,'2023-03-12 14:34:33','',''),(3005,'1','313','1',1,'Retail Sale Id 3060',2499.20,0.00,0.00,3.52,369.60,'2023-03-12 14:36:49','',''),(3006,'1','313','1',1,'Retail Sale Id 3061',10050.00,0.00,0.00,15.00,975.00,'2023-03-12 14:39:03','',''),(3007,'1','313','1',1,'Return of Retail Sale Id 3061',0.00,10050.00,15.00,0.00,-975.00,'2023-03-12 14:39:35','',''),(3008,'1','313','1',1,'Retail Sale Id 3062',9045.00,0.00,0.00,13.50,877.50,'2023-03-12 14:40:47','',''),(3009,'1','313','1',1,'Retail Sale Id 3063',2002.20,0.00,0.00,2.82,296.10,'2023-03-12 14:49:44','',''),(3010,'1','313','1',1,'Retail Sale Id 3064',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 14:50:54','',''),(3011,'1','313','1',1,'Retail Sale Id 3065',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 14:55:48','',''),(3012,'1','313','1',1,'Retail Sale Id 3066',710.00,0.00,0.00,1.00,105.00,'2023-03-12 14:58:29','',''),(3013,'1','313','1',1,'Retail Sale Id 3068',710.00,0.00,0.00,1.00,105.00,'2023-03-12 15:02:23','',''),(3014,'1','313','1',1,'Retail Sale Id 3069',2840.00,0.00,0.00,4.00,420.00,'2023-03-12 15:04:56','',''),(3015,'1','313','1',1,'Retail Sale Id 3070',14200.00,0.00,0.00,20.00,2100.00,'2023-03-12 15:06:20','',''),(3016,'1','313','1',1,'Retail Sale Id 3071',752.60,0.00,0.00,1.06,111.30,'2023-03-12 15:07:29','',''),(3017,'1','313','1',1,'Retail Sale Id 3072',710.00,0.00,0.00,1.00,105.00,'2023-03-12 15:08:17','',''),(3018,'1','313','1',1,'Retail Sale Id 3073',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 15:09:13','',''),(3019,'1','313','1',1,'Retail Sale Id 3074',8875.00,0.00,0.00,12.50,1312.50,'2023-03-12 15:10:32','',''),(3020,'1','313','1',1,'Retail Sale Id 3075',2499.20,0.00,0.00,3.52,369.60,'2023-03-12 15:13:07','',''),(3021,'1','313','1',1,'Retail Sale Id 3076',710.00,0.00,0.00,1.00,105.00,'2023-03-12 15:15:05','',''),(3022,'1','313','1',1,'Retail Sale Id 3077',710.00,0.00,0.00,1.00,105.00,'2023-03-12 15:16:11','',''),(3023,'1','313','1',1,'Retail Sale Id 3078',4970.00,0.00,0.00,7.00,735.00,'2023-03-12 15:17:53','',''),(3024,'1','313','1',1,'Retail Sale Id 3079',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 15:20:00','',''),(3025,'1','313','1',1,'Retail Sale Id 3080',7100.00,0.00,0.00,10.00,1050.00,'2023-03-12 15:23:41','',''),(3026,'1','313','1',1,'Retail Sale Id 3081',2130.00,0.00,0.00,3.00,315.00,'2023-03-12 15:25:11','',''),(3027,'1','313','1',1,'Retail Sale Id 3082',1001.10,0.00,0.00,1.41,148.05,'2023-03-12 15:27:31','',''),(3028,'1','313','1',1,'Retail Sale Id 3083',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 15:32:24','',''),(3029,'1','313','1',1,'Retail Sale Id 3084',752.60,0.00,0.00,1.06,111.30,'2023-03-12 15:38:12','',''),(3030,'1','313','1',1,'Retail Sale Id 3085',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 15:39:29','',''),(3031,'1','313','1',1,'Retail Sale Id 3086',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 15:44:31','',''),(3032,'1','313','1',1,'Retail Sale Id 3087',7100.00,0.00,0.00,10.00,1050.00,'2023-03-12 15:46:13','',''),(3033,'1','313','1',1,'Retail Sale Id 3089',4501.40,0.00,0.00,6.34,665.70,'2023-03-12 15:47:57','',''),(3034,'1','313','1',1,'Retail Sale Id 3090',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 15:48:53','',''),(3035,'1','313','1',1,'Retail Sale Id 3091',4970.00,0.00,0.00,7.00,735.00,'2023-03-12 15:50:12','',''),(3036,'1','313','1',1,'Retail Sale Id 3092',752.60,0.00,0.00,1.06,111.30,'2023-03-12 15:52:11','',''),(3037,'1','313','1',1,'Retail Sale Id 3093',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 15:55:59','',''),(3038,'1','313','1',1,'Retail Sale Id 3094',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 16:04:31','',''),(3039,'1','313','1',1,'Retail Sale Id 3095',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 16:13:23','',''),(3040,'1','313','1',1,'Retail Sale Id 3096',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 16:14:18','',''),(3041,'1','313','1',1,'Retail Sale Id 3097',710.00,0.00,0.00,1.00,105.00,'2023-03-12 16:15:39','',''),(3042,'1','313','1',1,'Retail Sale Id 3098',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 16:17:26','',''),(3043,'1','313','1',1,'Retail Sale Id 3099',2130.00,0.00,0.00,3.00,315.00,'2023-03-12 16:20:14','',''),(3044,'1','313','1',1,'Retail Sale Id 3100',1001.10,0.00,0.00,1.41,148.05,'2023-03-12 16:21:25','',''),(3045,'1','313','1',1,'Retail Sale Id 3101',2130.00,0.00,0.00,3.00,315.00,'2023-03-12 16:26:24','',''),(3046,'1','313','1',1,'Retail Sale Id 3102',4260.00,0.00,0.00,6.00,630.00,'2023-03-12 16:31:51','',''),(3047,'1','313','1',1,'Retail Sale Id 3103',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 16:32:47','',''),(3048,'1','313','1',1,'Retail Sale Id 3104',2130.00,0.00,0.00,3.00,315.00,'2023-03-12 16:35:04','',''),(3049,'1','313','1',1,'Retail Sale Id 3105',710.00,0.00,0.00,1.00,105.00,'2023-03-12 16:37:53','',''),(3050,'1','313','1',1,'Retail Sale Id 3106',2840.00,0.00,0.00,4.00,420.00,'2023-03-12 16:44:07','',''),(3051,'1','313','1',1,'Retail Sale Id 3107',1420.00,0.00,0.00,2.00,210.00,'2023-03-12 16:45:46','',''),(3052,'1','313','1',1,'Return of Retail Sale Id 3069',0.00,2840.00,4.00,0.00,-420.00,'2023-03-12 17:02:09','',''),(3053,'1','313','1',1,'Return of Retail Sale Id 3070',0.00,14200.00,20.00,0.00,-2100.00,'2023-03-12 17:03:06','',''),(3054,'1','313','1',1,'Retail Sale Id 3108',16080.00,0.00,0.00,24.00,1560.00,'2023-03-12 17:04:04','',''),(3055,'1','313','1',1,'Return of Retail Sale Id 3091',0.00,4970.00,7.00,0.00,-735.00,'2023-03-12 17:08:17','',''),(3056,'1','313','1',1,'Retail Sale Id 3109',4011.50,0.00,0.00,5.65,593.25,'2023-03-12 17:08:53','',''),(3057,'1','313','1',1,'Retail Sale Id 3110',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 08:02:21','',''),(3058,'1','313','1',1,'Retail Sale Id 3111',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 08:03:29','',''),(3059,'1','313','1',1,'Retail Sale Id 3112',710.00,0.00,0.00,1.00,105.00,'2023-03-13 08:04:31','',''),(3060,'1','313','1',1,'Retail Sale Id 3113',4132.20,0.00,0.00,5.82,611.10,'2023-03-13 08:06:15','',''),(3061,'1','313','1',1,'Retail Sale Id 3114',752.60,0.00,0.00,1.06,111.30,'2023-03-13 08:06:48','',''),(3062,'1','313','1',1,'Retail Sale Id 3115',109993.90,0.00,0.00,164.17,10671.05,'2023-03-13 08:09:13','',''),(3063,'1','313','1',1,'Retail Sale Id 3116',8875.00,0.00,0.00,12.50,1312.50,'2023-03-13 08:09:46','',''),(3064,'1','313','1',1,'Retail Sale Id 3117',5999.50,0.00,0.00,8.45,887.25,'2023-03-13 08:10:23','',''),(3065,'1','313','1',1,'Retail Sale Id 3118',710.00,0.00,0.00,1.00,105.00,'2023-03-13 08:10:58','',''),(3066,'1','313','1',1,'Retail Sale Id 3119',4970.00,0.00,0.00,7.00,735.00,'2023-03-13 08:11:34','',''),(3067,'1','313','1',1,'Retail Sale Id 3120',3550.00,0.00,0.00,5.00,525.00,'2023-03-13 08:12:19','',''),(3068,'1','313','1',1,'Retail Sale Id 3121',4970.00,0.00,0.00,7.00,735.00,'2023-03-13 08:13:19','',''),(3069,'1','313','1',1,'Retail Sale Id 3122',1001.10,0.00,0.00,1.41,148.05,'2023-03-13 08:13:56','',''),(3070,'1','313','1',1,'Retail Sale Id 3123',4260.00,0.00,0.00,6.00,630.00,'2023-03-13 08:14:33','',''),(3071,'1','313','1',1,'Retail Sale Id 3124',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 08:14:59','',''),(3072,'1','313','1',1,'Retail Sale Id 3125',2840.00,0.00,0.00,4.00,420.00,'2023-03-13 08:15:25','',''),(3073,'1','313','1',1,'Retail Sale Id 3126',3003.30,0.00,0.00,4.23,444.15,'2023-03-13 08:16:14','',''),(3074,'1','313','1',1,'Retail Sale Id 3127',710.00,0.00,0.00,1.00,105.00,'2023-03-13 08:16:55','',''),(3075,'1','313','1',1,'Retail Sale Id 3129',7100.00,0.00,0.00,10.00,1050.00,'2023-03-13 08:17:28','',''),(3076,'1','313','1',1,'Retail Sale Id 3130',2840.00,0.00,0.00,4.00,420.00,'2023-03-13 08:18:00','',''),(3077,'1','313','1',1,'Retail Sale Id 3131',8520.00,0.00,0.00,12.00,1260.00,'2023-03-13 08:19:41','',''),(3078,'1','313','1',1,'Retail Sale Id 3132',3550.00,0.00,0.00,5.00,525.00,'2023-03-13 08:22:17','',''),(3079,'1','313','1',1,'Retail Sale Id 3133',4998.40,0.00,0.00,7.04,739.20,'2023-03-13 08:23:47','',''),(3080,'1','313','1',1,'Retail Sale Id 3134',4970.00,0.00,0.00,7.00,735.00,'2023-03-13 08:24:29','',''),(3081,'1','313','1',1,'Retail Sale Id 3136',33500.00,0.00,0.00,50.00,3250.00,'2023-03-13 08:25:27','',''),(3082,'1','313','1',1,'Retail Sale Id 3137',710.00,0.00,0.00,1.00,105.00,'2023-03-13 08:26:09','',''),(3083,'1','313','1',1,'Retail Sale Id 3138',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 08:26:43','',''),(3084,'1','313','1',1,'Retail Sale Id 3139',2840.00,0.00,0.00,4.00,420.00,'2023-03-13 08:27:20','',''),(3085,'1','313','1',1,'Retail Sale Id 3140',4260.00,0.00,0.00,6.00,630.00,'2023-03-13 08:27:50','',''),(3086,'1','313','1',1,'Retail Sale Id 3141',8520.00,0.00,0.00,12.00,1260.00,'2023-03-13 08:28:22','',''),(3087,'1','313','1',1,'Retail Sale Id 3142',4260.00,0.00,0.00,6.00,630.00,'2023-03-13 08:28:53','',''),(3088,'1','313','1',1,'Retail Sale Id 3143',8520.00,0.00,0.00,12.00,1260.00,'2023-03-13 08:29:31','',''),(3089,'1','313','1',1,'Retail Sale Id 3144',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 08:30:03','',''),(3090,'1','313','1',1,'Retail Sale Id 3145',802.30,0.00,0.00,1.13,118.65,'2023-03-13 08:31:15','',''),(3091,'1','313','1',1,'Retail Sale Id 3146',752.60,0.00,0.00,1.06,111.30,'2023-03-13 08:32:08','',''),(3092,'1','313','1',1,'Retail Sale Id 3147',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 08:32:38','',''),(3093,'1','313','1',1,'Retail Sale Id 3148',4970.00,0.00,0.00,7.00,735.00,'2023-03-13 08:33:24','',''),(3094,'1','313','1',1,'Retail Sale Id 3149',752.60,0.00,0.00,1.06,111.30,'2023-03-13 08:35:01','',''),(3095,'1','313','1',1,'Retail Sale Id 3150',4970.00,0.00,0.00,7.00,735.00,'2023-03-13 08:36:29','',''),(3096,'1','313','1',1,'Retail Sale Id 3151',4970.00,0.00,0.00,7.00,735.00,'2023-03-13 08:37:07','',''),(3097,'1','313','1',1,'Retail Sale Id 3152',40695.80,0.00,0.00,60.74,3948.10,'2023-03-13 08:38:46','',''),(3098,'1','313','1',1,'Retail Sale Id 3153',3550.00,0.00,0.00,5.00,525.00,'2023-03-13 08:39:38','',''),(3099,'1','313','1',1,'Retail Sale Id 3154',8520.00,0.00,0.00,12.00,1260.00,'2023-03-13 08:40:05','',''),(3100,'1','313','1',1,'Retail Sale Id 3155',33500.00,0.00,0.00,50.00,3250.00,'2023-03-13 08:41:03','',''),(3101,'1','313','1',1,'Retail Sale Id 3156',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 08:41:49','',''),(3102,'1','313','1',1,'Retail Sale Id 3157',2840.00,0.00,0.00,4.00,420.00,'2023-03-13 08:42:17','',''),(3103,'1','313','1',1,'Retail Sale Id 3158',7100.00,0.00,0.00,10.00,1050.00,'2023-03-13 08:43:14','',''),(3104,'1','313','1',1,'Retail Sale Id 3159',3550.00,0.00,0.00,5.00,525.00,'2023-03-13 08:43:58','',''),(3105,'1','313','1',1,'Retail Sale Id 3160',2840.00,0.00,0.00,4.00,420.00,'2023-03-13 08:45:17','',''),(3106,'1','313','1',1,'Retail Sale Id 3161',2840.00,0.00,0.00,4.00,420.00,'2023-03-13 08:47:19','',''),(3107,'1','313','1',1,'Retail Sale Id 3162',4970.00,0.00,0.00,7.00,735.00,'2023-03-13 08:48:34','',''),(3108,'1','313','1',1,'Retail Sale Id 3163',710.00,0.00,0.00,1.00,105.00,'2023-03-13 08:49:03','',''),(3109,'1','313','1',1,'Retail Sale Id 3164',3550.00,0.00,0.00,5.00,525.00,'2023-03-13 08:49:38','',''),(3110,'1','313','1',1,'Retail Sale Id 3165',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 08:50:24','',''),(3111,'1','313','1',1,'Retail Sale Id 3166',8875.00,0.00,0.00,12.50,1312.50,'2023-03-13 08:50:58','',''),(3112,'1','313','1',1,'Retail Sale Id 3167',3550.00,0.00,0.00,5.00,525.00,'2023-03-13 08:51:30','',''),(3113,'1','313','1',1,'Retail Sale Id 3168',40762.80,0.00,0.00,60.84,3954.60,'2023-03-13 08:52:34','',''),(3114,'1','313','1',1,'Retail Sale Id 3169',8875.00,0.00,0.00,12.50,1312.50,'2023-03-13 08:54:16','',''),(3115,'1','313','1',1,'Retail Sale Id 3170',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 08:55:01','',''),(3116,'1','313','1',1,'Retail Sale Id 3171',8875.00,0.00,0.00,12.50,1312.50,'2023-03-13 08:55:46','',''),(3117,'1','313','1',1,'Retail Sale Id 3172',710.00,0.00,0.00,1.00,105.00,'2023-03-13 08:56:17','',''),(3118,'1','313','1',1,'Retail Sale Id 3173',8875.00,0.00,0.00,12.50,1312.50,'2023-03-13 08:57:27','',''),(3119,'1','313','1',1,'Retail Sale Id 3174',12730.00,0.00,0.00,19.00,1235.00,'2023-03-13 08:58:36','',''),(3120,'1','313','1',1,'Retail Sale Id 3175',31240.00,0.00,0.00,44.00,4620.00,'2023-03-13 09:00:30','',''),(3121,'1','313','1',1,'Retail Sale Id 3176',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 09:01:36','',''),(3122,'1','313','1',1,'Retail Sale Id 3177',2485.00,0.00,0.00,3.50,367.50,'2023-03-13 09:02:18','',''),(3123,'1','313','1',1,'Retail Sale Id 3178',8875.00,0.00,0.00,12.50,1312.50,'2023-03-13 09:04:07','',''),(3124,'1','313','1',1,'Return of Retail Sale Id 3175',0.00,31240.00,44.00,0.00,-4620.00,'2023-03-13 09:04:34','',''),(3125,'1','313','1',1,'Retail Sale Id 3179',29480.00,0.00,0.00,44.00,2860.00,'2023-03-13 09:05:05','',''),(3126,'1','313','1',1,'Retail Sale Id 3180',710.00,0.00,0.00,1.00,105.00,'2023-03-13 09:05:50','',''),(3127,'1','313','1',1,'Retail Sale Id 3181',4970.00,0.00,0.00,7.00,735.00,'2023-03-13 09:06:49','',''),(3128,'1','313','1',1,'Retail Sale Id 3182',4260.00,0.00,0.00,6.00,630.00,'2023-03-13 09:07:21','',''),(3129,'1','313','1',1,'Retail Sale Id 3183',4260.00,0.00,0.00,6.00,630.00,'2023-03-13 09:08:06','',''),(3130,'1','313','1',1,'Retail Sale Id 3184',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 09:08:35','',''),(3131,'1','313','1',1,'Retail Sale Id 3185',752.60,0.00,0.00,1.06,111.30,'2023-03-13 09:10:06','',''),(3132,'1','313','1',1,'Retail Sale Id 3186',67000.00,0.00,0.00,100.00,6500.00,'2023-03-13 09:11:14','',''),(3133,'1','313','1',1,'Retail Sale Id 3187',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 09:11:54','',''),(3134,'1','313','1',1,'Retail Sale Id 3188',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 09:16:02','',''),(3135,'1','313','1',1,'Retail Sale Id 3189',80400.00,0.00,0.00,120.00,7800.00,'2023-03-13 09:18:38','',''),(3136,'1','313','1',1,'Retail Sale Id 3190',40200.00,0.00,0.00,60.00,3900.00,'2023-03-13 09:21:33','',''),(3137,'1','313','1',1,'Retail Sale Id 3191',1448.40,0.00,0.00,2.04,214.20,'2023-03-13 09:22:33','',''),(3138,'1','313','1',1,'Retail Sale Id 3192',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 09:24:40','',''),(3139,'1','313','1',1,'Retail Sale Id 3193',710.00,0.00,0.00,1.00,105.00,'2023-03-13 09:25:38','',''),(3140,'1','313','1',1,'Retail Sale Id 3194',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 09:29:51','',''),(3141,'1','313','1',1,'Retail Sale Id 3195',752.60,0.00,0.00,1.06,111.30,'2023-03-13 09:31:22','',''),(3142,'1','313','1',1,'Retail Sale Id 3196',5680.00,0.00,0.00,8.00,840.00,'2023-03-13 09:32:23','',''),(3143,'1','313','1',1,'Retail Sale Id 3197',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 09:34:26','',''),(3144,'1','313','1',1,'Retail Sale Id 3198',3550.00,0.00,0.00,5.00,525.00,'2023-03-13 09:36:31','',''),(3145,'1','313','1',1,'Retail Sale Id 3199',4260.00,0.00,0.00,6.00,630.00,'2023-03-13 09:37:31','',''),(3146,'1','313','1',1,'Retail Sale Id 3200',7100.00,0.00,0.00,10.00,1050.00,'2023-03-13 09:41:55','',''),(3147,'1','313','1',1,'Retail Sale Id 3201',2840.00,0.00,0.00,4.00,420.00,'2023-03-13 09:45:01','',''),(3148,'1','313','1',1,'Retail Sale Id 3202',100500.00,0.00,0.00,150.00,9750.00,'2023-03-13 09:46:26','',''),(3149,'1','313','1',1,'Retail Sale Id 3203',7810.00,0.00,0.00,11.00,1155.00,'2023-03-13 09:49:39','',''),(3150,'1','313','1',1,'Retail Sale Id 3204',11360.00,0.00,0.00,16.00,1680.00,'2023-03-13 09:50:22','',''),(3151,'1','313','1',1,'Retail Sale Id 3205',2499.20,0.00,0.00,3.52,369.60,'2023-03-13 09:51:01','',''),(3152,'1','313','1',1,'Retail Sale Id 3206',2840.00,0.00,0.00,4.00,420.00,'2023-03-13 09:51:51','',''),(3153,'1','313','1',1,'Retail Sale Id 3207',2002.20,0.00,0.00,2.82,296.10,'2023-03-13 09:52:23','',''),(3154,'1','313','1',1,'Retail Sale Id 3208',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 09:52:56','',''),(3155,'1','313','1',1,'Retail Sale Id 3209',4970.00,0.00,0.00,7.00,735.00,'2023-03-13 09:53:36','',''),(3156,'1','313','1',1,'Retail Sale Id 3210',3550.00,0.00,0.00,5.00,525.00,'2023-03-13 09:54:00','',''),(3157,'1','313','1',1,'Retail Sale Id 3211',1448.40,0.00,0.00,2.04,214.20,'2023-03-13 09:54:44','',''),(3158,'1','313','1',1,'Retail Sale Id 3212',710.00,0.00,0.00,1.00,105.00,'2023-03-13 09:55:24','',''),(3159,'1','313','1',1,'Retail Sale Id 3213',8875.00,0.00,0.00,12.50,1312.50,'2023-03-13 10:00:02','',''),(3160,'1','313','1',1,'Retail Sale Id 3214',710.00,0.00,0.00,1.00,105.00,'2023-03-13 10:00:43','',''),(3161,'1','313','1',1,'Retail Sale Id 3215',3003.30,0.00,0.00,4.23,444.15,'2023-03-13 10:01:39','',''),(3162,'1','313','1',1,'Retail Sale Id 3216',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 10:02:31','',''),(3163,'1','313','1',1,'Retail Sale Id 3217',1775.00,0.00,0.00,2.50,262.50,'2023-03-13 10:03:08','',''),(3164,'1','313','1',1,'Retail Sale Id 3218',3550.00,0.00,0.00,5.00,525.00,'2023-03-13 10:07:13','',''),(3165,'1','313','1',1,'Retail Sale Id 3219',9499.80,0.00,0.00,13.38,1404.90,'2023-03-13 10:10:52','',''),(3166,'1','313','1',1,'Retail Sale Id 3220',80400.00,0.00,0.00,120.00,7800.00,'2023-03-13 10:12:16','',''),(3167,'1','313','1',1,'Retail Sale Id 3221',3003.30,0.00,0.00,4.23,444.15,'2023-03-13 10:14:38','',''),(3168,'1','313','1',1,'Retail Sale Id 3222',3550.00,0.00,0.00,5.00,525.00,'2023-03-13 10:15:24','',''),(3169,'1','313','1',1,'Retail Sale Id 3223',119260.00,0.00,0.00,178.00,11570.00,'2023-03-13 10:16:49','',''),(3170,'1','313','1',1,'Retail Sale Id 3224',4970.00,0.00,0.00,7.00,735.00,'2023-03-13 10:18:00','',''),(3171,'1','313','1',1,'Retail Sale Id 3225',4260.00,0.00,0.00,6.00,630.00,'2023-03-13 10:19:37','',''),(3172,'1','313','1',1,'Retail Sale Id 3226',497.00,0.00,0.00,0.70,73.50,'2023-03-13 10:22:24','',''),(3173,'1','313','1',1,'Retail Sale Id 3227',710.00,0.00,0.00,1.00,105.00,'2023-03-13 10:23:45','',''),(3174,'1','313','1',1,'Retail Sale Id 3228',2847.10,0.00,0.00,4.01,421.05,'2023-03-13 10:25:00','',''),(3175,'1','313','1',1,'Retail Sale Id 3229',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 10:26:01','',''),(3176,'1','313','1',1,'Retail Sale Id 3230',2840.00,0.00,0.00,4.00,420.00,'2023-03-13 10:27:29','',''),(3177,'1','313','1',1,'Retail Sale Id 3231',8875.00,0.00,0.00,12.50,1312.50,'2023-03-13 10:31:59','',''),(3178,'1','313','1',1,'Retail Sale Id 3232',2840.00,0.00,0.00,4.00,420.00,'2023-03-13 10:32:49','',''),(3179,'1','313','1',1,'Retail Sale Id 3233',1498.10,0.00,0.00,2.11,221.55,'2023-03-13 10:37:27','',''),(3180,'1','313','1',1,'Retail Sale Id 3234',710.00,0.00,0.00,1.00,105.00,'2023-03-13 10:38:30','',''),(3181,'1','313','1',1,'Retail Sale Id 3236',1448.40,0.00,0.00,2.04,214.20,'2023-03-13 10:40:57','',''),(3182,'1','313','1',1,'Retail Sale Id 3237',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 10:42:03','',''),(3183,'1','313','1',1,'Retail Sale Id 3238',7000.60,0.00,0.00,9.86,1035.30,'2023-03-13 10:43:03','',''),(3184,'1','313','1',1,'Retail Sale Id 3239',6390.00,0.00,0.00,9.00,945.00,'2023-03-13 10:44:17','',''),(3185,'1','313','1',1,'Retail Sale Id 3240',33500.00,0.00,0.00,50.00,3250.00,'2023-03-13 10:45:53','',''),(3186,'1','313','1',1,'Retail Sale Id 3241',40200.00,0.00,0.00,60.00,3900.00,'2023-03-13 10:47:16','',''),(3187,'1','313','1',1,'Retail Sale Id 3242',3550.00,0.00,0.00,5.00,525.00,'2023-03-13 10:48:23','',''),(3188,'1','313','1',1,'Retail Sale Id 3243',4260.00,0.00,0.00,6.00,630.00,'2023-03-13 10:50:29','',''),(3189,'1','313','1',1,'Retail Sale Id 3244',3997.30,0.00,0.00,5.63,591.15,'2023-03-13 10:53:12','',''),(3190,'1','313','1',1,'Retail Sale Id 3245',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 10:58:43','',''),(3191,'1','313','1',1,'Retail Sale Id 3246',2840.00,0.00,0.00,4.00,420.00,'2023-03-13 11:00:35','',''),(3192,'1','313','1',1,'Retail Sale Id 3247',1498.10,0.00,0.00,2.11,221.55,'2023-03-13 11:03:11','',''),(3193,'1','313','1',1,'Retail Sale Id 3248',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 11:07:52','',''),(3194,'1','313','1',1,'Retail Sale Id 3249',1199.90,0.00,0.00,1.69,177.45,'2023-03-13 11:12:20','',''),(3195,'1','313','1',1,'Retail Sale Id 3250',2300.40,0.00,0.00,3.24,340.20,'2023-03-13 11:16:06','',''),(3196,'1','313','1',1,'Retail Sale Id 3251',4260.00,0.00,0.00,6.00,630.00,'2023-03-13 11:19:56','',''),(3197,'1','313','1',1,'Retail Sale Id 3252',8520.00,0.00,0.00,12.00,1260.00,'2023-03-13 11:25:25','',''),(3198,'1','313','1',1,'Retail Sale Id 3253',4970.00,0.00,0.00,7.00,735.00,'2023-03-13 11:26:13','',''),(3199,'1','313','1',1,'Retail Sale Id 3254',1448.40,0.00,0.00,2.04,214.20,'2023-03-13 11:38:02','',''),(3200,'1','313','1',1,'Retail Sale Id 3255',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 11:40:12','',''),(3201,'1','313','1',1,'Retail Sale Id 3256',4260.00,0.00,0.00,6.00,630.00,'2023-03-13 11:41:58','',''),(3202,'1','313','1',1,'Retail Sale Id 3257',8875.00,0.00,0.00,12.50,1312.50,'2023-03-13 11:44:48','',''),(3203,'1','313','1',1,'Retail Sale Id 3258',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 11:51:32','',''),(3204,'1','313','1',1,'Retail Sale Id 3259',4998.40,0.00,0.00,7.04,739.20,'2023-03-13 11:54:07','',''),(3205,'1','313','1',1,'Retail Sale Id 3260',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 11:56:20','',''),(3206,'1','313','1',1,'Retail Sale Id 3261',4260.00,0.00,0.00,6.00,630.00,'2023-03-13 11:58:17','',''),(3207,'1','313','1',1,'Retail Sale Id 3262',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 12:03:24','',''),(3208,'1','313','1',1,'Retail Sale Id 3263',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 12:10:50','',''),(3209,'1','313','1',1,'Retail Sale Id 3264',1448.40,0.00,0.00,2.04,214.20,'2023-03-13 12:11:26','',''),(3210,'1','313','1',1,'Retail Sale Id 3266',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 12:18:30','',''),(3211,'1','313','1',1,'Retail Sale Id 3267',6390.00,0.00,0.00,9.00,945.00,'2023-03-13 12:22:57','',''),(3212,'1','313','1',1,'Return of Retail Sale Id 3267',0.00,6390.00,9.00,0.00,-945.00,'2023-03-13 12:27:15','',''),(3213,'1','313','1',1,'Retail Sale Id 3268',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 12:27:53','',''),(3214,'1','313','1',1,'Retail Sale Id 3270',2840.00,0.00,0.00,4.00,420.00,'2023-03-13 12:29:55','',''),(3215,'1','313','1',1,'Retail Sale Id 3271',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 12:33:05','',''),(3216,'1','313','1',1,'Retail Sale Id 3272',40200.00,0.00,0.00,60.00,3900.00,'2023-03-13 12:34:26','',''),(3217,'1','313','1',1,'Retail Sale Id 3273',2840.00,0.00,0.00,4.00,420.00,'2023-03-13 12:36:43','',''),(3218,'1','313','1',1,'Retail Sale Id 3274',3550.00,0.00,0.00,5.00,525.00,'2023-03-13 12:38:14','',''),(3219,'1','313','1',1,'Retail Sale Id 3275',39590.30,0.00,0.00,59.09,3840.85,'2023-03-13 12:40:16','',''),(3220,'1','313','1',1,'Retail Sale Id 3276',4970.00,0.00,0.00,7.00,735.00,'2023-03-13 12:41:41','',''),(3221,'1','313','1',1,'Retail Sale Id 3277',6390.00,0.00,0.00,9.00,945.00,'2023-03-13 12:43:54','',''),(3222,'1','313','1',1,'Retail Sale Id 3278',1448.40,0.00,0.00,2.04,214.20,'2023-03-13 12:45:21','',''),(3223,'1','313','1',1,'Retail Sale Id 3279',3550.00,0.00,0.00,5.00,525.00,'2023-03-13 12:50:25','',''),(3224,'1','313','1',1,'Retail Sale Id 3280',710.00,0.00,0.00,1.00,105.00,'2023-03-13 12:52:31','',''),(3225,'1','313','1',1,'Retail Sale Id 3281',8875.00,0.00,0.00,12.50,1312.50,'2023-03-13 12:53:21','',''),(3226,'1','313','1',1,'Retail Sale Id 3282',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 12:58:01','',''),(3227,'1','313','1',1,'Retail Sale Id 3283',710.00,0.00,0.00,1.00,105.00,'2023-03-13 13:02:40','',''),(3228,'1','313','1',1,'Retail Sale Id 3284',8520.00,0.00,0.00,12.00,1260.00,'2023-03-13 13:03:32','',''),(3229,'1','313','1',1,'Retail Sale Id 3285',8875.00,0.00,0.00,12.50,1312.50,'2023-03-13 13:07:10','',''),(3230,'1','313','1',1,'Retail Sale Id 3286',2840.00,0.00,0.00,4.00,420.00,'2023-03-13 13:08:44','',''),(3231,'1','313','1',1,'Retail Sale Id 3287',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 13:11:29','',''),(3232,'1','313','1',1,'Retail Sale Id 3288',1498.10,0.00,0.00,2.11,221.55,'2023-03-13 13:12:31','',''),(3233,'1','313','1',1,'Retail Sale Id 3289',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 13:13:42','',''),(3234,'1','313','1',1,'Retail Sale Id 3290',3550.00,0.00,0.00,5.00,525.00,'2023-03-13 13:15:19','',''),(3235,'1','313','1',1,'Retail Sale Id 3291',11360.00,0.00,0.00,16.00,1680.00,'2023-03-13 13:19:27','',''),(3236,'1','313','1',1,'Retail Sale Id 3292',2840.00,0.00,0.00,4.00,420.00,'2023-03-13 13:23:12','',''),(3237,'1','313','1',1,'Retail Sale Id 3293',2840.00,0.00,0.00,4.00,420.00,'2023-03-13 13:24:18','',''),(3238,'1','313','1',1,'Retail Sale Id 3294',2840.00,0.00,0.00,4.00,420.00,'2023-03-13 13:25:45','',''),(3239,'1','313','1',1,'Retail Sale Id 3295',702.90,0.00,0.00,0.99,103.95,'2023-03-13 13:30:46','',''),(3240,'1','313','1',1,'Retail Sale Id 3296',710.00,0.00,0.00,1.00,105.00,'2023-03-13 13:35:59','',''),(3241,'1','313','1',1,'Retail Sale Id 3297',33500.00,0.00,0.00,50.00,3250.00,'2023-03-13 13:37:18','',''),(3242,'1','313','1',1,'Retail Sale Id 3298',3550.00,0.00,0.00,5.00,525.00,'2023-03-13 13:44:15','',''),(3243,'1','313','1',1,'Retail Sale Id 3299',710.00,0.00,0.00,1.00,105.00,'2023-03-13 13:50:09','',''),(3244,'1','313','1',1,'Retail Sale Id 3300',710.00,0.00,0.00,1.00,105.00,'2023-03-13 13:52:33','',''),(3245,'1','313','1',1,'Retail Sale Id 3301',4913.20,0.00,0.00,6.92,726.60,'2023-03-13 13:53:13','',''),(3246,'1','313','1',1,'Return of Retail Sale Id 3301',0.00,4913.20,6.92,0.00,-726.60,'2023-03-13 13:53:39','',''),(3247,'1','313','1',1,'Retail Sale Id 3302',4636.40,0.00,0.00,6.92,449.80,'2023-03-13 13:54:36','',''),(3248,'1','313','1',1,'Retail Sale Id 3303',7100.00,0.00,0.00,10.00,1050.00,'2023-03-13 13:57:04','',''),(3249,'1','313','1',1,'Return of Retail Sale Id 3295',0.00,702.90,0.99,0.00,-103.95,'2023-03-13 13:57:56','',''),(3250,'1','313','1',1,'Retail Sale Id 3304',8520.00,0.00,0.00,12.00,1260.00,'2023-03-13 13:59:08','',''),(3251,'1','313','1',1,'Retail Sale Id 3305',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 14:06:11','',''),(3252,'1','313','1',1,'Retail Sale Id 3306',3550.00,0.00,0.00,5.00,525.00,'2023-03-13 14:11:52','',''),(3253,'1','313','1',1,'Retail Sale Id 3307',4799.60,0.00,0.00,6.76,709.80,'2023-03-13 14:17:12','',''),(3254,'1','313','1',1,'Retail Sale Id 3310',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 14:24:03','',''),(3255,'1','313','1',1,'Retail Sale Id 3311',2840.00,0.00,0.00,4.00,420.00,'2023-03-13 14:29:53','',''),(3256,'1','313','1',1,'Retail Sale Id 3312',8875.00,0.00,0.00,12.50,1312.50,'2023-03-13 14:36:07','',''),(3257,'1','313','1',1,'Retail Sale Id 3313',710.00,0.00,0.00,1.00,105.00,'2023-03-13 14:37:48','',''),(3258,'1','313','1',1,'Retail Sale Id 3314',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 14:46:22','',''),(3259,'1','313','1',1,'Retail Sale Id 3315',802.30,0.00,0.00,1.13,118.65,'2023-03-13 14:58:15','',''),(3260,'1','313','1',1,'Retail Sale Id 3316',1448.40,0.00,0.00,2.04,214.20,'2023-03-13 15:12:42','',''),(3261,'1','313','1',1,'Retail Sale Id 3317',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 15:22:18','',''),(3262,'1','313','1',1,'Retail Sale Id 3318',2151.30,0.00,0.00,3.03,318.15,'2023-03-13 15:23:13','',''),(3263,'1','313','1',1,'Retail Sale Id 3319',2002.20,0.00,0.00,2.82,296.10,'2023-03-13 15:26:24','',''),(3264,'1','313','1',1,'Retail Sale Id 3320',702.90,0.00,0.00,0.99,103.95,'2023-03-13 15:32:59','',''),(3265,'1','313','1',1,'Retail Sale Id 3321',752.60,0.00,0.00,1.06,111.30,'2023-03-13 15:46:30','',''),(3266,'1','313','1',1,'Retail Sale Id 3322',710.00,0.00,0.00,1.00,105.00,'2023-03-13 15:47:34','',''),(3267,'1','313','1',1,'Retail Sale Id 3323',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 15:54:14','',''),(3268,'1','313','1',1,'Retail Sale Id 3324',2840.00,0.00,0.00,4.00,420.00,'2023-03-13 15:56:26','',''),(3269,'1','313','1',1,'Retail Sale Id 3325',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 16:07:13','',''),(3270,'1','313','1',1,'Retail Sale Id 3326',1448.40,0.00,0.00,2.04,214.20,'2023-03-13 16:14:39','',''),(3271,'1','313','1',1,'Retail Sale Id 3327',3550.00,0.00,0.00,5.00,525.00,'2023-03-13 16:21:42','',''),(3272,'1','313','1',1,'Retail Sale Id 3328',1050.80,0.00,0.00,1.48,155.40,'2023-03-13 16:23:54','',''),(3273,'1','313','1',1,'Retail Sale Id 3329',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 16:25:09','',''),(3274,'1','313','1',1,'Retail Sale Id 3330',710.00,0.00,0.00,1.00,105.00,'2023-03-13 16:26:01','',''),(3275,'1','313','1',1,'Retail Sale Id 3331',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 16:29:26','',''),(3276,'1','313','1',1,'Retail Sale Id 3332',1398.70,0.00,0.00,1.97,206.85,'2023-03-13 16:31:46','',''),(3277,'1','313','1',1,'Retail Sale Id 3333',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 16:32:55','',''),(3278,'1','313','1',1,'Retail Sale Id 3334',1498.10,0.00,0.00,2.11,221.55,'2023-03-13 16:33:47','',''),(3279,'1','313','1',1,'Retail Sale Id 3336',2151.30,0.00,0.00,3.03,318.15,'2023-03-13 16:40:25','',''),(3280,'1','313','1',1,'Retail Sale Id 3337',2201.00,0.00,0.00,3.10,325.50,'2023-03-13 16:42:55','',''),(3281,'1','313','1',1,'Retail Sale Id 3338',752.60,0.00,0.00,1.06,111.30,'2023-03-13 16:51:32','',''),(3282,'1','313','1',1,'Retail Sale Id 3339',2151.30,0.00,0.00,3.03,318.15,'2023-03-13 16:52:48','',''),(3283,'1','313','1',1,'Retail Sale Id 3340',8924.70,0.00,0.00,12.57,1319.85,'2023-03-13 16:53:45','',''),(3284,'1','313','1',1,'Retail Sale Id 3341',8875.00,0.00,0.00,12.50,1312.50,'2023-03-13 16:54:28','',''),(3285,'1','313','1',1,'Retail Sale Id 3342',752.60,0.00,0.00,1.06,111.30,'2023-03-13 16:55:36','',''),(3286,'1','313','1',1,'Return of Retail Sale Id 3219',0.00,9499.80,13.38,0.00,-1404.90,'2023-03-13 17:01:03','',''),(3287,'1','313','1',1,'Retail Sale Id 3343',1420.00,0.00,0.00,2.00,210.00,'2023-03-13 17:01:52','',''),(3288,'1','313','1',1,'Retail Sale Id 3344',2840.00,0.00,0.00,4.00,420.00,'2023-03-13 17:10:01','',''),(3289,'1','313','1',1,'Retail Sale Id 3345',2002.20,0.00,0.00,2.82,296.10,'2023-03-13 17:12:03','',''),(3290,'1','313','1',1,'Retail Sale Id 3346',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 17:12:52','',''),(3291,'1','313','1',1,'Retail Sale Id 3347',710.00,0.00,0.00,1.00,105.00,'2023-03-13 17:13:35','',''),(3292,'1','313','1',1,'Retail Sale Id 3348',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 17:14:04','',''),(3293,'1','313','1',1,'Retail Sale Id 3349',8875.00,0.00,0.00,12.50,1312.50,'2023-03-13 17:15:01','',''),(3294,'1','313','1',1,'Retail Sale Id 3350',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 17:15:35','',''),(3295,'1','313','1',1,'Retail Sale Id 3351',752.60,0.00,0.00,1.06,111.30,'2023-03-13 17:17:12','',''),(3296,'1','313','1',1,'Retail Sale Id 3352',3550.00,0.00,0.00,5.00,525.00,'2023-03-13 17:18:20','',''),(3297,'1','313','1',1,'Return of Retail Sale Id 3332',0.00,1398.70,1.97,0.00,-206.85,'2023-03-13 17:21:05','',''),(3298,'1','313','1',1,'Retail Sale Id 3353',710.00,0.00,0.00,1.00,105.00,'2023-03-13 17:23:59','',''),(3299,'1','313','1',1,'Retail Sale Id 3354',752.60,0.00,0.00,1.06,111.30,'2023-03-13 17:25:30','',''),(3300,'1','313','1',1,'Retail Sale Id 3355',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 17:28:34','',''),(3301,'1','313','1',1,'Retail Sale Id 3356',7810.00,0.00,0.00,11.00,1155.00,'2023-03-13 17:36:36','',''),(3302,'1','313','1',1,'Retail Sale Id 3357',2130.00,0.00,0.00,3.00,315.00,'2023-03-13 17:42:01','',''),(3303,'1','313','1',1,'Retail Sale Id 3358',83307.80,0.00,0.00,124.34,8082.10,'2023-03-13 17:44:43','',''),(3304,'1','313','1',1,'Retail Sale Id 3359',33500.00,0.00,0.00,50.00,3250.00,'2023-03-13 17:49:38','',''),(3305,'1','313','1',1,'Retail Sale Id 3360',80400.00,0.00,0.00,120.00,7800.00,'2023-03-13 17:58:10','',''),(3306,'1','313','1',1,'Retail Sale Id 3361',4260.00,0.00,0.00,6.00,630.00,'2023-03-13 18:00:32','',''),(3307,'1','313','1',1,'Return of Retail Sale Id 3340',0.00,8924.70,12.57,0.00,-1319.85,'2023-03-13 18:12:08','',''),(3308,'1','313','1',1,'Retail Sale Id 3362',6787.60,0.00,0.00,9.56,1003.80,'2023-03-13 18:12:49','',''),(3309,'1','313','1',1,'Return of Retail Sale Id 3168',0.00,40762.80,60.84,0.00,-3954.60,'2023-03-13 18:19:20','',''),(3310,'1','313','1',1,'Retail Sale Id 3363',40595.30,0.00,0.00,60.59,3938.35,'2023-03-13 18:20:19','',''),(3311,'1','313','1',1,'Retail Sale Id 3365',4260.00,0.00,0.00,6.00,630.00,'2023-03-14 08:15:24','',''),(3312,'1','313','1',1,'Retail Sale Id 3366',7100.00,0.00,0.00,10.00,1050.00,'2023-03-14 08:16:18','',''),(3313,'1','313','1',1,'Retail Sale Id 3367',36850.00,0.00,0.00,55.00,3575.00,'2023-03-14 08:17:19','',''),(3314,'1','313','1',1,'Retail Sale Id 3368',4970.00,0.00,0.00,7.00,735.00,'2023-03-14 08:18:29','',''),(3315,'1','313','1',1,'Retail Sale Id 3370',8875.00,0.00,0.00,12.50,1312.50,'2023-03-14 08:21:28','',''),(3316,'1','313','1',1,'Retail Sale Id 3371',9940.00,0.00,0.00,14.00,1470.00,'2023-03-14 08:22:05','',''),(3317,'1','313','1',1,'Retail Sale Id 3372',2130.00,0.00,0.00,3.00,315.00,'2023-03-14 08:25:58','',''),(3318,'1','313','1',1,'Retail Sale Id 3373',8520.00,0.00,0.00,12.00,1260.00,'2023-03-14 08:27:03','',''),(3319,'1','313','1',1,'Retail Sale Id 3374',2840.00,0.00,0.00,4.00,420.00,'2023-03-14 08:28:15','',''),(3320,'1','313','1',1,'Retail Sale Id 3375',2130.00,0.00,0.00,3.00,315.00,'2023-03-14 08:29:04','',''),(3321,'1','313','1',1,'Retail Sale Id 3376',1420.00,0.00,0.00,2.00,210.00,'2023-03-14 08:29:59','',''),(3322,'1','313','1',1,'Retail Sale Id 3377',1498.10,0.00,0.00,2.11,221.55,'2023-03-14 08:31:12','',''),(3323,'1','313','1',1,'Retail Sale Id 3378',2840.00,0.00,0.00,4.00,420.00,'2023-03-14 08:32:04','',''),(3324,'1','313','1',1,'Retail Sale Id 3379',3798.50,0.00,0.00,5.35,561.75,'2023-03-14 08:35:53','',''),(3325,'1','313','1',1,'Return of Retail Sale Id 3379',0.00,3798.50,5.35,0.00,-561.75,'2023-03-14 08:36:29','',''),(3326,'1','313','1',1,'Retail Sale Id 3380',3848.20,0.00,0.00,5.42,569.10,'2023-03-14 08:37:25','',''),(3327,'1','313','1',1,'Retail Sale Id 3381',3550.00,0.00,0.00,5.00,525.00,'2023-03-14 08:38:35','',''),(3328,'1','313','1',1,'Retail Sale Id 3382',2840.00,0.00,0.00,4.00,420.00,'2023-03-14 08:40:25','',''),(3329,'1','313','1',1,'Retail Sale Id 3383',1420.00,0.00,0.00,2.00,210.00,'2023-03-14 08:41:39','',''),(3330,'1','313','1',1,'Retail Sale Id 3384',4998.40,0.00,0.00,7.04,739.20,'2023-03-14 08:43:48','',''),(3331,'1','313','1',1,'Retail Sale Id 3385',3003.30,0.00,0.00,4.23,444.15,'2023-03-14 08:45:31','',''),(3332,'1','313','1',1,'Retail Sale Id 3386',4260.00,0.00,0.00,6.00,630.00,'2023-03-14 08:46:18','',''),(3333,'1','313','1',1,'Retail Sale Id 3387',2130.00,0.00,0.00,3.00,315.00,'2023-03-14 08:47:30','',''),(3334,'1','313','1',1,'Retail Sale Id 3388',20770.00,0.00,0.00,31.00,2015.00,'2023-03-14 08:49:40','',''),(3335,'1','313','1',1,'Retail Sale Id 3389',2499.20,0.00,0.00,3.52,369.60,'2023-03-14 08:50:41','',''),(3336,'1','313','1',1,'Retail Sale Id 3390',1498.10,0.00,0.00,2.11,221.55,'2023-03-14 08:51:31','',''),(3337,'1','313','1',1,'Retail Sale Id 3391',7100.00,0.00,0.00,10.00,1050.00,'2023-03-14 08:52:11','',''),(3338,'1','313','1',1,'Retail Sale Id 3393',710.00,0.00,0.00,1.00,105.00,'2023-03-14 08:55:31','',''),(3339,'1','313','1',1,'Retail Sale Id 3394',710.00,0.00,0.00,1.00,105.00,'2023-03-14 09:03:13','',''),(3340,'1','313','1',1,'Retail Sale Id 3395',7100.00,0.00,0.00,10.00,1050.00,'2023-03-14 09:05:36','',''),(3341,'1','313','1',1,'Retail Sale Id 3396',2840.00,0.00,0.00,4.00,420.00,'2023-03-14 09:07:06','',''),(3342,'1','313','1',1,'Retail Sale Id 3397',4260.00,0.00,0.00,6.00,630.00,'2023-03-14 09:08:03','',''),(3343,'1','313','1',1,'Retail Sale Id 3398',2840.00,0.00,0.00,4.00,420.00,'2023-03-14 09:09:01','',''),(3344,'1','313','1',1,'Retail Sale Id 3399',3550.00,0.00,0.00,5.00,525.00,'2023-03-14 09:10:28','',''),(3345,'1','313','1',1,'Retail Sale Id 3400',2130.00,0.00,0.00,3.00,315.00,'2023-03-14 09:12:16','',''),(3346,'1','313','1',1,'Retail Sale Id 3401',30330.90,0.00,0.00,45.27,2942.55,'2023-03-14 09:18:08','',''),(3347,'1','313','1',1,'Retail Sale Id 3402',717.10,0.00,0.00,1.01,106.05,'2023-03-14 09:20:53','',''),(3348,'1','313','1',1,'Retail Sale Id 3403',1448.40,0.00,0.00,2.04,214.20,'2023-03-14 09:22:43','',''),(3349,'1','313','1',1,'Retail Sale Id 3404',752.60,0.00,0.00,1.06,111.30,'2023-03-14 09:24:00','',''),(3350,'1','313','1',1,'Retail Sale Id 3405',4970.00,0.00,0.00,7.00,735.00,'2023-03-14 09:37:18','',''),(3351,'1','313','1',1,'Retail Sale Id 3406',1420.00,0.00,0.00,2.00,210.00,'2023-03-14 09:38:51','',''),(3352,'1','313','1',1,'Retail Sale Id 3407',1448.40,0.00,0.00,2.04,214.20,'2023-03-14 09:41:31','',''),(3353,'1','313','1',1,'Retail Sale Id 3408',35500.00,0.00,0.00,50.00,5250.00,'2023-03-14 09:42:18','',''),(3354,'1','313','1',1,'Retail Sale Id 3409',3550.00,0.00,0.00,5.00,525.00,'2023-03-14 09:43:17','',''),(3355,'1','313','1',1,'Retail Sale Id 3410',710.00,0.00,0.00,1.00,105.00,'2023-03-14 09:44:14','',''),(3356,'1','313','1',1,'Retail Sale Id 3411',4970.00,0.00,0.00,7.00,735.00,'2023-03-14 09:45:14','',''),(3357,'1','313','1',1,'Retail Sale Id 3412',7100.00,0.00,0.00,10.00,1050.00,'2023-03-14 09:46:19','',''),(3358,'1','313','1',1,'Retail Sale Id 3413',2002.20,0.00,0.00,2.82,296.10,'2023-03-14 09:48:43','',''),(3359,'1','313','1',1,'Retail Sale Id 3414',1420.00,0.00,0.00,2.00,210.00,'2023-03-14 09:49:54','',''),(3360,'1','313','1',1,'Retail Sale Id 3415',1065.00,0.00,0.00,1.50,157.50,'2023-03-14 09:51:04','',''),(3361,'1','313','1',1,'Retail Sale Id 3416',3550.00,0.00,0.00,5.00,525.00,'2023-03-14 09:51:30','',''),(3362,'1','313','1',1,'Retail Sale Id 3417',8875.00,0.00,0.00,12.50,1312.50,'2023-03-14 09:51:56','',''),(3363,'1','313','1',1,'Retail Sale Id 3418',4260.00,0.00,0.00,6.00,630.00,'2023-03-14 09:53:00','',''),(3364,'1','313','1',1,'Retail Sale Id 3419',2840.00,0.00,0.00,4.00,420.00,'2023-03-14 09:53:28','',''),(3365,'1','313','1',1,'Retail Sale Id 3420',8875.00,0.00,0.00,12.50,1312.50,'2023-03-14 09:54:48','',''),(3366,'1','313','1',1,'Retail Sale Id 3421',6035.00,0.00,0.00,8.50,892.50,'2023-03-14 09:55:52','',''),(3367,'1','313','1',1,'Retail Sale Id 3422',4260.00,0.00,0.00,6.00,630.00,'2023-03-14 09:56:26','',''),(3368,'1','313','1',1,'Retail Sale Id 3423',8875.00,0.00,0.00,12.50,1312.50,'2023-03-14 09:57:18','',''),(3369,'1','313','1',1,'Retail Sale Id 3424',7100.00,0.00,0.00,10.00,1050.00,'2023-03-14 09:57:41','',''),(3370,'1','313','1',1,'Retail Sale Id 3425',33500.00,0.00,0.00,50.00,3250.00,'2023-03-14 09:59:48','',''),(3371,'1','313','1',1,'Retail Sale Id 3426',710.00,0.00,0.00,1.00,105.00,'2023-03-14 10:00:21','',''),(3372,'1','313','1',1,'Retail Sale Id 3427',2130.00,0.00,0.00,3.00,315.00,'2023-03-14 10:00:59','',''),(3373,'1','313','1',1,'Retail Sale Id 3428',2840.00,0.00,0.00,4.00,420.00,'2023-03-14 10:03:11','',''),(3374,'1','313','1',1,'Retail Sale Id 3429',8875.00,0.00,0.00,12.50,1312.50,'2023-03-14 10:03:44','',''),(3375,'1','313','1',1,'Retail Sale Id 3430',1498.10,0.00,0.00,2.11,221.55,'2023-03-14 10:04:23','',''),(3376,'1','313','1',1,'Retail Sale Id 3431',40883.40,0.00,0.00,61.02,3966.30,'2023-03-14 10:05:45','',''),(3377,'1','313','1',1,'Retail Sale Id 3432',2840.00,0.00,0.00,4.00,420.00,'2023-03-14 10:06:29','',''),(3378,'1','313','1',1,'Retail Sale Id 3433',13845.00,0.00,0.00,19.50,2047.50,'2023-03-14 10:07:08','',''),(3379,'1','313','1',1,'Retail Sale Id 3434',8520.00,0.00,0.00,12.00,1260.00,'2023-03-14 10:07:34','',''),(3380,'1','313','1',1,'Retail Sale Id 3435',4260.00,0.00,0.00,6.00,630.00,'2023-03-14 10:08:07','',''),(3381,'1','313','1',1,'Retail Sale Id 3436',1420.00,0.00,0.00,2.00,210.00,'2023-03-14 10:08:41','',''),(3382,'1','313','1',1,'Retail Sale Id 3437',2840.00,0.00,0.00,4.00,420.00,'2023-03-14 10:09:09','',''),(3383,'1','313','1',1,'Retail Sale Id 3438',6390.00,0.00,0.00,9.00,945.00,'2023-03-14 10:09:44','',''),(3384,'1','313','1',1,'Retail Sale Id 3439',1420.00,0.00,0.00,2.00,210.00,'2023-03-14 10:12:15','',''),(3385,'1','313','1',1,'Retail Sale Id 3440',1420.00,0.00,0.00,2.00,210.00,'2023-03-14 10:13:02','',''),(3386,'1','313','1',1,'Retail Sale Id 3441',1420.00,0.00,0.00,2.00,210.00,'2023-03-14 10:13:53','',''),(3387,'1','313','1',1,'Retail Sale Id 3442',3550.00,0.00,0.00,5.00,525.00,'2023-03-14 10:14:28','',''),(3388,'1','313','1',1,'Retail Sale Id 3443',1420.00,0.00,0.00,2.00,210.00,'2023-03-14 10:14:56','',''),(3389,'1','313','1',1,'Retail Sale Id 3444',4998.40,0.00,0.00,7.04,739.20,'2023-03-14 10:15:37','',''),(3390,'1','313','1',1,'Retail Sale Id 3445',1420.00,0.00,0.00,2.00,210.00,'2023-03-14 10:16:09','',''),(3391,'1','313','1',1,'Retail Sale Id 3446',710.00,0.00,0.00,1.00,105.00,'2023-03-14 10:16:38','',''),(3392,'1','313','1',1,'Retail Sale Id 3447',4260.00,0.00,0.00,6.00,630.00,'2023-03-14 10:17:04','',''),(3393,'1','313','1',1,'Retail Sale Id 3448',14740.00,0.00,0.00,22.00,1430.00,'2023-03-14 10:17:41','',''),(3394,'1','313','1',1,'Retail Sale Id 3449',8875.00,0.00,0.00,12.50,1312.50,'2023-03-14 10:20:59','',''),(3395,'1','313','1',1,'Retail Sale Id 3450',2896.80,0.00,0.00,4.08,428.40,'2023-03-14 10:25:32','',''),(3396,'1','313','1',1,'Retail Sale Id 3451',40200.00,0.00,0.00,60.00,3900.00,'2023-03-14 10:26:41','',''),(3397,'1','313','1',1,'Retail Sale Id 3452',6390.00,0.00,0.00,9.00,945.00,'2023-03-14 10:31:00','',''),(3398,'1','313','1',1,'Retail Sale Id 3453',2840.00,0.00,0.00,4.00,420.00,'2023-03-14 10:32:22','',''),(3399,'1','313','1',1,'Retail Sale Id 3454',4260.00,0.00,0.00,6.00,630.00,'2023-03-14 10:33:37','',''),(3400,'1','313','1',1,'Retail Sale Id 3455',710.00,0.00,0.00,1.00,105.00,'2023-03-14 10:34:15','',''),(3401,'1','313','1',1,'Retail Sale Id 3456',2130.00,0.00,0.00,3.00,315.00,'2023-03-14 10:34:56','',''),(3402,'1','313','1',1,'Retail Sale Id 3457',3003.30,0.00,0.00,4.23,444.15,'2023-03-14 10:36:58','',''),(3403,'1','313','1',1,'Retail Sale Id 3458',2840.00,0.00,0.00,4.00,420.00,'2023-03-14 10:40:23','',''),(3404,'1','313','1',1,'Retail Sale Id 3459',4260.00,0.00,0.00,6.00,630.00,'2023-03-14 10:41:25','',''),(3405,'1','313','1',1,'Retail Sale Id 3460',7100.00,0.00,0.00,10.00,1050.00,'2023-03-14 10:42:03','',''),(3406,'1','313','1',1,'Retail Sale Id 3461',1420.00,0.00,0.00,2.00,210.00,'2023-03-14 10:43:34','',''),(3407,'1','313','1',1,'Retail Sale Id 3462',1420.00,0.00,0.00,2.00,210.00,'2023-03-14 10:44:54','',''),(3408,'1','313','1',1,'Retail Sale Id 3464',2847.10,0.00,0.00,4.01,421.05,'2023-03-14 10:48:06','',''),(3409,'1','313','1',1,'Retail Sale Id 3465',3550.00,0.00,0.00,5.00,525.00,'2023-03-14 10:49:14','',''),(3410,'1','313','1',1,'Retail Sale Id 3466',8875.00,0.00,0.00,12.50,1312.50,'2023-03-14 10:49:51','',''),(3411,'1','313','1',1,'Retail Sale Id 3468',15975.00,0.00,0.00,22.50,2362.50,'2023-03-14 10:56:51','',''),(3412,'1','313','1',1,'Retail Sale Id 3469',2151.30,0.00,0.00,3.03,318.15,'2023-03-14 11:02:27','',''),(3413,'1','313','1',1,'Retail Sale Id 3470',40870.00,0.00,0.00,61.00,3965.00,'2023-03-14 11:11:02','',''),(3414,'1','313','1',1,'Retail Sale Id 3471',2130.00,0.00,0.00,3.00,315.00,'2023-03-14 11:12:56','',''),(3415,'1','313','1',1,'Retail Sale Id 3473',1448.40,0.00,0.00,2.04,214.20,'2023-03-14 11:15:37','',''),(3416,'1','313','1',1,'Retail Sale Id 3474',4501.40,0.00,0.00,6.34,665.70,'2023-03-14 11:16:58','',''),(3417,'1','313','1',1,'Retail Sale Id 3475',1448.40,0.00,0.00,2.04,214.20,'2023-03-14 11:17:53','',''),(3418,'1','313','1',1,'Retail Sale Id 3476',4998.40,0.00,0.00,7.04,739.20,'2023-03-14 11:18:54','',''),(3419,'1','313','1',1,'Retail Sale Id 3477',4970.00,0.00,0.00,7.00,735.00,'2023-03-14 11:19:59','',''),(3420,'1','313','1',1,'Retail Sale Id 3478',1001.10,0.00,0.00,1.41,148.05,'2023-03-14 11:20:45','',''),(3421,'1','313','1',1,'Retail Sale Id 3479',3997.30,0.00,0.00,5.63,591.15,'2023-03-14 11:21:59','',''),(3422,'1','313','1',1,'Retail Sale Id 3481',710.00,0.00,0.00,1.00,105.00,'2023-03-14 11:22:46','',''),(3423,'1','313','1',1,'Retail Sale Id 3482',2485.00,0.00,0.00,3.50,367.50,'2023-03-14 11:23:27','',''),(3424,'1','313','1',1,'Retail Sale Id 3483',3550.00,0.00,0.00,5.00,525.00,'2023-03-14 11:24:14','',''),(3425,'1','313','1',1,'Retail Sale Id 3484',2130.00,0.00,0.00,3.00,315.00,'2023-03-14 11:24:56','',''),(3426,'1','313','1',1,'Retail Sale Id 3485',710.00,0.00,0.00,1.00,105.00,'2023-03-14 11:25:41','',''),(3427,'1','313','1',1,'Retail Sale Id 3486',8875.00,0.00,0.00,12.50,1312.50,'2023-03-14 11:26:13','',''),(3428,'1','313','1',1,'Retail Sale Id 3487',1001.10,0.00,0.00,1.41,148.05,'2023-03-14 11:32:20','',''),(3429,'1','313','1',1,'Retail Sale Id 3488',7810.00,0.00,0.00,11.00,1155.00,'2023-03-14 11:35:06','',''),(3430,'1','313','1',1,'Retail Sale Id 3489',2130.00,0.00,0.00,3.00,315.00,'2023-03-14 11:36:13','',''),(3431,'1','313','1',1,'Retail Sale Id 3490',2130.00,0.00,0.00,3.00,315.00,'2023-03-14 11:38:31','',''),(3432,'1','313','1',1,'Retail Sale Id 3491',1420.00,0.00,0.00,2.00,210.00,'2023-03-14 11:39:48','',''),(3433,'1','313','1',1,'Retail Sale Id 3492',1420.00,0.00,0.00,2.00,210.00,'2023-03-14 11:40:37','',''),(3434,'1','313','1',1,'Retail Sale Id 3493',3550.00,0.00,0.00,5.00,525.00,'2023-03-14 11:42:59','',''),(3435,'1','313','1',1,'Retail Sale Id 3494',14200.00,0.00,0.00,20.00,2100.00,'2023-03-14 11:44:25','',''),(3436,'1','313','1',1,'Retail Sale Id 3495',1001.10,0.00,0.00,1.41,148.05,'2023-03-14 11:46:04','',''),(3437,'1','313','1',1,'Retail Sale Id 3496',2130.00,0.00,0.00,3.00,315.00,'2023-03-14 11:46:43','',''),(3438,'1','313','1',1,'Retail Sale Id 3498',3550.00,0.00,0.00,5.00,525.00,'2023-03-14 11:49:57','',''),(3439,'1','313','1',1,'Retail Sale Id 3499',6390.00,0.00,0.00,9.00,945.00,'2023-03-14 11:51:12','',''),(3440,'1','313','1',1,'Retail Sale Id 3500',39556.80,0.00,0.00,59.04,3837.60,'2023-03-14 11:58:42','',''),(3441,'1','313','1',1,'Retail Sale Id 3501',4260.00,0.00,0.00,6.00,630.00,'2023-03-14 11:59:52','',''),(3442,'1','313','1',1,'Retail Sale Id 3503',3550.00,0.00,0.00,5.00,525.00,'2023-03-14 12:01:17','',''),(3443,'1','313','1',1,'Retail Sale Id 3504',2840.00,0.00,0.00,4.00,420.00,'2023-03-14 12:02:04','',''),(3444,'1','313','1',1,'Retail Sale Id 3505',2130.00,0.00,0.00,3.00,315.00,'2023-03-14 12:06:43','',''),(3445,'1','313','1',1,'Retail Sale Id 3506',16685.00,0.00,0.00,23.50,2467.50,'2023-03-14 12:10:21','',''),(3446,'1','313','1',1,'Retail Sale Id 3507',5680.00,0.00,0.00,8.00,840.00,'2023-03-14 12:17:41','',''),(3447,'1','313','1',1,'Retail Sale Id 3508',710.00,0.00,0.00,1.00,105.00,'2023-03-14 12:19:04','',''),(3448,'1','313','1',1,'Retail Sale Id 3510',3550.00,0.00,0.00,5.00,525.00,'2023-03-14 12:21:40','',''),(3449,'1','313','1',1,'Retail Sale Id 3511',8875.00,0.00,0.00,12.50,1312.50,'2023-03-14 12:23:25','',''),(3450,'1','313','1',1,'Retail Sale Id 3512',1001.10,0.00,0.00,1.41,148.05,'2023-03-14 12:25:09','',''),(3451,'1','313','1',1,'Retail Sale Id 3513',1420.00,0.00,0.00,2.00,210.00,'2023-03-14 12:27:17','',''),(3452,'1','313','1',1,'Retail Sale Id 3514',752.60,0.00,0.00,1.06,111.30,'2023-03-14 12:28:53','',''),(3453,'1','313','1',1,'Retail Sale Id 3515',4970.00,0.00,0.00,7.00,735.00,'2023-03-14 12:37:41','',''),(3454,'1','313','1',1,'Retail Sale Id 3516',1420.00,0.00,0.00,2.00,210.00,'2023-03-14 12:39:55','',''),(3455,'1','313','1',1,'Retail Sale Id 3518',110550.00,0.00,0.00,165.00,10725.00,'2023-03-14 12:47:03','',''),(3456,'1','313','1',1,'Retail Sale Id 3519',4260.00,0.00,0.00,6.00,630.00,'2023-03-14 12:47:52','',''),(3457,'1','313','1',1,'Retail Sale Id 3520',4615.00,0.00,0.00,6.50,682.50,'2023-03-14 12:48:49','',''),(3458,'1','313','1',1,'Retail Sale Id 3521',2130.00,0.00,0.00,3.00,315.00,'2023-03-14 12:50:16','',''),(3459,'1','313','1',1,'Retail Sale Id 3522',2130.00,0.00,0.00,3.00,315.00,'2023-03-14 12:54:01','',''),(3460,'1','313','1',1,'Retail Sale Id 3523',1420.00,0.00,0.00,2.00,210.00,'2023-03-14 13:05:03','',''),(3461,'1','313','1',1,'Retail Sale Id 3524',6390.00,0.00,0.00,9.00,945.00,'2023-03-14 13:06:30','',''),(3462,'1','313','1',1,'Retail Sale Id 3525',40200.00,0.00,0.00,60.00,3900.00,'2023-03-14 13:07:25','',''),(3463,'1','313','1',1,'Retail Sale Id 3526',2840.00,0.00,0.00,4.00,420.00,'2023-03-14 13:14:08','',''),(3464,'1','313','1',1,'Retail Sale Id 3527',39536.70,0.00,0.00,59.01,3835.65,'2023-03-14 13:16:36','',''),(3465,'1','313','1',1,'Retail Sale Id 3528',7000.60,0.00,0.00,9.86,1035.30,'2023-03-14 13:19:06','',''),(3466,'1','313','1',1,'Retail Sale Id 3529',8875.00,0.00,0.00,12.50,1312.50,'2023-03-14 13:21:18','',''),(3467,'1','313','1',1,'Retail Sale Id 3530',1420.00,0.00,0.00,2.00,210.00,'2023-03-14 13:22:30','',''),(3468,'1','313','1',1,'Retail Sale Id 3531',710.00,0.00,0.00,1.00,105.00,'2023-03-14 13:23:29','',''),(3469,'1','313','1',1,'Retail Sale Id 3532',3550.00,0.00,0.00,5.00,525.00,'2023-03-14 13:25:01','',''),(3470,'1','313','1',1,'Retail Sale Id 3533',1420.00,0.00,0.00,2.00,210.00,'2023-03-14 13:26:04','',''),(3471,'1','313','1',1,'Retail Sale Id 3534',2130.00,0.00,0.00,3.00,315.00,'2023-03-14 13:27:33','',''),(3472,'1','313','1',1,'Retail Sale Id 3535',710.00,0.00,0.00,1.00,105.00,'2023-03-14 13:29:13','',''),(3473,'1','313','1',1,'Retail Sale Id 3536',710.00,0.00,0.00,1.00,105.00,'2023-03-14 13:30:04','',''),(3474,'1','313','1',1,'Retail Sale Id 3537',1420.00,0.00,0.00,2.00,210.00,'2023-03-14 13:32:56','',''),(3475,'1','313','1',1,'Retail Sale Id 3538',3550.00,0.00,0.00,5.00,525.00,'2023-03-14 13:35:21','',''),(3476,'1','313','1',1,'Retail Sale Id 3539',2130.00,0.00,0.00,3.00,315.00,'2023-03-14 13:37:46','',''),(3477,'1','313','1',1,'Retail Sale Id 3541',1420.00,0.00,0.00,2.00,210.00,'2023-03-14 13:41:47','',''),(3478,'1','313','1',1,'Retail Sale Id 3542',5680.00,0.00,0.00,8.00,840.00,'2023-03-14 13:44:00','',''),(3479,'1','313','1',1,'Retail Sale Id 3543',4260.00,0.00,0.00,6.00,630.00,'2023-03-14 13:48:05','',''),(3480,'1','313','1',1,'Retail Sale Id 3544',2840.00,0.00,0.00,4.00,420.00,'2023-03-14 13:48:50','',''),(3481,'1','313','1',1,'Retail Sale Id 3546',3550.00,0.00,0.00,5.00,525.00,'2023-03-14 13:50:19','',''),(3482,'1','313','1',1,'Retail Sale Id 3547',4260.00,0.00,0.00,6.00,630.00,'2023-03-14 13:52:37','',''),(3483,'1','313','1',1,'Retail Sale Id 3549',1448.40,0.00,0.00,2.04,214.20,'2023-03-14 13:55:37','',''),(3484,'1','313','1',1,'Retail Sale Id 3550',3699.10,0.00,0.00,5.21,547.05,'2023-03-14 13:56:53','',''),(3485,'1','313','1',1,'Retail Sale Id 3551',2201.00,0.00,0.00,3.10,325.50,'2023-03-14 14:00:27','',''),(3486,'1','313','1',1,'Retail Sale Id 3552',8520.00,0.00,0.00,12.00,1260.00,'2023-03-14 14:01:36','',''),(3487,'1','313','1',1,'Retail Sale Id 3553',2840.00,0.00,0.00,4.00,420.00,'2023-03-14 14:02:59','',''),(3488,'1','313','1',1,'Retail Sale Id 3554',4970.00,0.00,0.00,7.00,735.00,'2023-03-14 14:04:52','',''),(3489,'1','313','1',1,'Retail Sale Id 3555',3550.00,0.00,0.00,5.00,525.00,'2023-03-14 14:07:27','',''),(3490,'1','313','1',1,'Retail Sale Id 3556',710.00,0.00,0.00,1.00,105.00,'2023-03-14 14:19:14','',''),(3491,'1','313','1',1,'Retail Sale Id 3557',4260.00,0.00,0.00,6.00,630.00,'2023-03-14 14:20:18','',''),(3492,'1','313','1',1,'Retail Sale Id 3558',2130.00,0.00,0.00,3.00,315.00,'2023-03-14 14:22:13','',''),(3493,'1','313','1',1,'Retail Sale Id 3559',710.00,0.00,0.00,1.00,105.00,'2023-03-14 16:51:25','',''),(3494,'1','313','1',1,'Retail Sale Id 3560',4260.00,0.00,0.00,6.00,630.00,'2023-03-14 16:54:10','',''),(3495,'1','313','1',1,'Retail Sale Id 3561',710.00,0.00,0.00,1.00,105.00,'2023-03-14 16:55:15','',''),(3496,'1','313','1',1,'Retail Sale Id 3562',3550.00,0.00,0.00,5.00,525.00,'2023-03-14 16:56:14','',''),(3497,'1','313','1',1,'Retail Sale Id 3563',2130.00,0.00,0.00,3.00,315.00,'2023-03-14 17:13:08','',''),(3498,'1','313','1',1,'Return of Retail Sale Id 3408',0.00,35500.00,50.00,0.00,-5250.00,'2023-03-14 17:35:31','',''),(3499,'1','313','1',1,'Return of Retail Sale Id 3468',0.00,15975.00,22.50,0.00,-2362.50,'2023-03-14 17:37:12','',''),(3500,'1','313','1',1,'Retail Sale Id 3564',201782.00,0.00,0.00,284.20,29841.00,'2023-03-14 17:47:36','',''),(3501,'1','313','1',1,'Retail Sale Id 3565',245072.60,0.00,0.00,365.78,23775.70,'2023-03-14 17:50:06','',''),(3502,'1','313','1',1,'Return of Retail Sale Id 3544',0.00,2840.00,4.00,0.00,-420.00,'2023-03-14 18:03:31','',''),(3503,'1','313','1',1,'Retail Sale Id 3566',2534.70,0.00,0.00,3.57,374.85,'2023-03-14 18:04:18','',''),(3504,'1','313','1',1,'Return of Retail Sale Id 3388',0.00,20770.00,31.00,0.00,-2015.00,'2023-03-14 18:06:08','',''),(3505,'1','313','1',1,'Retail Sale Id 3567',20287.60,0.00,0.00,30.28,1968.20,'2023-03-14 18:07:49','',''),(3506,'1','313','1',1,'Retail Sale Id 3568',4690.00,0.00,0.00,7.00,455.00,'2023-03-15 08:14:05','',''),(3507,'1','313','1',1,'Retail Sale Id 3569',6390.00,0.00,0.00,9.00,945.00,'2023-03-15 08:15:48','',''),(3508,'1','313','1',1,'Retail Sale Id 3570',3003.30,0.00,0.00,4.23,444.15,'2023-03-15 08:16:31','',''),(3509,'1','313','1',1,'Retail Sale Id 3571',8875.00,0.00,0.00,12.50,1312.50,'2023-03-15 08:17:50','',''),(3510,'1','313','1',1,'Retail Sale Id 3572',40200.00,0.00,0.00,60.00,3900.00,'2023-03-15 08:19:48','',''),(3511,'1','313','1',1,'Retail Sale Id 3573',4970.00,0.00,0.00,7.00,735.00,'2023-03-15 08:20:58','',''),(3512,'1','313','1',1,'Retail Sale Id 3574',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 08:22:00','',''),(3513,'1','313','1',1,'Retail Sale Id 3575',710.00,0.00,0.00,1.00,105.00,'2023-03-15 08:23:16','',''),(3514,'1','313','1',1,'Retail Sale Id 3576',33500.00,0.00,0.00,50.00,3250.00,'2023-03-15 08:24:57','',''),(3515,'1','313','1',1,'Retail Sale Id 3577',40200.00,0.00,0.00,60.00,3900.00,'2023-03-15 08:26:35','',''),(3516,'1','313','1',1,'Retail Sale Id 3578',40200.00,0.00,0.00,60.00,3900.00,'2023-03-15 08:27:27','',''),(3517,'1','313','1',1,'Retail Sale Id 3579',40870.00,0.00,0.00,61.00,3965.00,'2023-03-15 08:28:17','',''),(3518,'1','313','1',1,'Retail Sale Id 3580',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 08:30:26','',''),(3519,'1','313','1',1,'Retail Sale Id 3581',7100.00,0.00,0.00,10.00,1050.00,'2023-03-15 08:31:31','',''),(3520,'1','313','1',1,'Retail Sale Id 3582',4260.00,0.00,0.00,6.00,630.00,'2023-03-15 08:32:34','',''),(3521,'1','313','1',1,'Retail Sale Id 3583',710.00,0.00,0.00,1.00,105.00,'2023-03-15 08:33:41','',''),(3522,'1','313','1',1,'Retail Sale Id 3584',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 08:35:24','',''),(3523,'1','313','1',1,'Retail Sale Id 3585',9230.00,0.00,0.00,13.00,1365.00,'2023-03-15 08:38:23','',''),(3524,'1','313','1',1,'Retail Sale Id 3586',3003.30,0.00,0.00,4.23,444.15,'2023-03-15 08:39:32','',''),(3525,'1','313','1',1,'Retail Sale Id 3587',4970.00,0.00,0.00,7.00,735.00,'2023-03-15 08:41:26','',''),(3526,'1','313','1',1,'Retail Sale Id 3588',710.00,0.00,0.00,1.00,105.00,'2023-03-15 08:42:52','',''),(3527,'1','313','1',1,'Retail Sale Id 3589',40200.00,0.00,0.00,60.00,3900.00,'2023-03-15 08:56:25','',''),(3528,'1','313','1',1,'Retail Sale Id 3590',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 08:58:00','',''),(3529,'1','313','1',1,'Retail Sale Id 3591',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 08:58:53','',''),(3530,'1','313','1',1,'Retail Sale Id 3593',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 09:04:24','',''),(3531,'1','313','1',1,'Retail Sale Id 3594',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 09:05:46','',''),(3532,'1','313','1',1,'Retail Sale Id 3595',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 09:08:40','',''),(3533,'1','313','1',1,'Retail Sale Id 3596',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 09:10:51','',''),(3534,'1','313','1',1,'Retail Sale Id 3597',752.60,0.00,0.00,1.06,111.30,'2023-03-15 09:12:14','',''),(3535,'1','313','1',1,'Retail Sale Id 3598',6390.00,0.00,0.00,9.00,945.00,'2023-03-15 09:14:03','',''),(3536,'1','313','1',1,'Retail Sale Id 3599',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 09:14:43','',''),(3537,'1','313','1',1,'Retail Sale Id 3600',3550.00,0.00,0.00,5.00,525.00,'2023-03-15 09:18:10','',''),(3538,'1','313','1',1,'Retail Sale Id 3601',2840.00,0.00,0.00,4.00,420.00,'2023-03-15 09:21:01','',''),(3539,'1','313','1',1,'Retail Sale Id 3602',710.00,0.00,0.00,1.00,105.00,'2023-03-15 09:21:33','',''),(3540,'1','313','1',1,'Retail Sale Id 3603',4970.00,0.00,0.00,7.00,735.00,'2023-03-15 09:23:18','',''),(3541,'1','313','1',1,'Retail Sale Id 3604',3997.30,0.00,0.00,5.63,591.15,'2023-03-15 09:24:11','',''),(3542,'1','313','1',1,'Retail Sale Id 3605',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 09:26:38','',''),(3543,'1','313','1',1,'Retail Sale Id 3606',4970.00,0.00,0.00,7.00,735.00,'2023-03-15 09:28:44','',''),(3544,'1','313','1',1,'Retail Sale Id 3607',7100.00,0.00,0.00,10.00,1050.00,'2023-03-15 09:30:29','',''),(3545,'1','313','1',1,'Retail Sale Id 3608',8520.00,0.00,0.00,12.00,1260.00,'2023-03-15 09:31:37','',''),(3546,'1','313','1',1,'Retail Sale Id 3609',40200.00,0.00,0.00,60.00,3900.00,'2023-03-15 09:32:45','',''),(3547,'1','313','1',1,'Retail Sale Id 3610',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 09:33:46','',''),(3548,'1','313','1',1,'Retail Sale Id 3611',4260.00,0.00,0.00,6.00,630.00,'2023-03-15 09:36:15','',''),(3549,'1','313','1',1,'Retail Sale Id 3612',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 09:37:37','',''),(3550,'1','313','1',1,'Retail Sale Id 3613',4615.00,0.00,0.00,6.50,682.50,'2023-03-15 09:39:44','',''),(3551,'1','313','1',1,'Retail Sale Id 3614',7100.00,0.00,0.00,10.00,1050.00,'2023-03-15 09:40:35','',''),(3552,'1','313','1',1,'Retail Sale Id 3615',2840.00,0.00,0.00,4.00,420.00,'2023-03-15 09:43:29','',''),(3553,'1','313','1',1,'Retail Sale Id 3616',4970.00,0.00,0.00,7.00,735.00,'2023-03-15 09:46:29','',''),(3554,'1','313','1',1,'Retail Sale Id 3617',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 09:47:21','',''),(3555,'1','313','1',1,'Retail Sale Id 3618',2840.00,0.00,0.00,4.00,420.00,'2023-03-15 09:48:37','',''),(3556,'1','313','1',1,'Retail Sale Id 3619',4260.00,0.00,0.00,6.00,630.00,'2023-03-15 09:50:17','',''),(3557,'1','313','1',1,'Retail Sale Id 3620',16080.00,0.00,0.00,24.00,1560.00,'2023-03-15 09:51:13','',''),(3558,'1','313','1',1,'Retail Sale Id 3621',2840.00,0.00,0.00,4.00,420.00,'2023-03-15 09:52:26','',''),(3559,'1','313','1',1,'Retail Sale Id 3622',710.00,0.00,0.00,1.00,105.00,'2023-03-15 09:53:38','',''),(3560,'1','313','1',1,'Retail Sale Id 3623',1498.10,0.00,0.00,2.11,221.55,'2023-03-15 09:54:58','',''),(3561,'1','313','1',1,'Retail Sale Id 3624',8520.00,0.00,0.00,12.00,1260.00,'2023-03-15 09:55:25','',''),(3562,'1','313','1',1,'Retail Sale Id 3625',2840.00,0.00,0.00,4.00,420.00,'2023-03-15 09:57:51','',''),(3563,'1','313','1',1,'Retail Sale Id 3626',14910.00,0.00,0.00,21.00,2205.00,'2023-03-15 10:01:37','',''),(3564,'1','313','1',1,'Retail Sale Id 3627',14200.00,0.00,0.00,20.00,2100.00,'2023-03-15 10:03:41','',''),(3565,'1','313','1',1,'Return of Retail Sale Id 3627',0.00,14200.00,20.00,0.00,-2100.00,'2023-03-15 10:03:57','',''),(3566,'1','313','1',1,'Retail Sale Id 3628',2002.20,0.00,0.00,2.82,296.10,'2023-03-15 10:04:55','',''),(3567,'1','313','1',1,'Retail Sale Id 3629',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 10:06:13','',''),(3568,'1','313','1',1,'Retail Sale Id 3630',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 10:07:42','',''),(3569,'1','313','1',1,'Retail Sale Id 3631',710.00,0.00,0.00,1.00,105.00,'2023-03-15 10:09:10','',''),(3570,'1','313','1',1,'Retail Sale Id 3633',2840.00,0.00,0.00,4.00,420.00,'2023-03-15 10:11:40','',''),(3571,'1','313','1',1,'Return of Retail Sale Id 3624',0.00,8520.00,12.00,0.00,-1260.00,'2023-03-15 10:12:50','',''),(3572,'1','313','1',1,'Retail Sale Id 3634',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 10:13:59','',''),(3573,'1','313','1',1,'Retail Sale Id 3635',2840.00,0.00,0.00,4.00,420.00,'2023-03-15 10:16:00','',''),(3574,'1','313','1',1,'Return of Retail Sale Id 3635',0.00,2840.00,4.00,0.00,-420.00,'2023-03-15 10:17:14','',''),(3575,'1','313','1',1,'Retail Sale Id 3636',2705.10,0.00,0.00,3.81,400.05,'2023-03-15 10:17:47','',''),(3576,'1','313','1',1,'Retail Sale Id 3637',7100.00,0.00,0.00,10.00,1050.00,'2023-03-15 10:20:19','',''),(3577,'1','313','1',1,'Retail Sale Id 3638',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 10:21:43','',''),(3578,'1','313','1',1,'Retail Sale Id 3639',3550.00,0.00,0.00,5.00,525.00,'2023-03-15 10:23:28','',''),(3579,'1','313','1',1,'Retail Sale Id 3640',3003.30,0.00,0.00,4.23,444.15,'2023-03-15 10:24:50','',''),(3580,'1','313','1',1,'Retail Sale Id 3641',3003.30,0.00,0.00,4.23,444.15,'2023-03-15 10:26:54','',''),(3581,'1','313','1',1,'Retail Sale Id 3642',67000.00,0.00,0.00,100.00,6500.00,'2023-03-15 10:32:33','',''),(3582,'1','313','1',1,'Retail Sale Id 3643',8875.00,0.00,0.00,12.50,1312.50,'2023-03-15 10:33:26','',''),(3583,'1','313','1',1,'Retail Sale Id 3644',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 10:34:18','',''),(3584,'1','313','1',1,'Retail Sale Id 3645',3550.00,0.00,0.00,5.00,525.00,'2023-03-15 10:35:10','',''),(3585,'1','313','1',1,'Retail Sale Id 3646',4260.00,0.00,0.00,6.00,630.00,'2023-03-15 10:36:27','',''),(3586,'1','313','1',1,'Retail Sale Id 3647',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 10:37:55','',''),(3587,'1','313','1',1,'Retail Sale Id 3648',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 10:38:39','',''),(3588,'1','313','1',1,'Retail Sale Id 3649',710.00,0.00,0.00,1.00,105.00,'2023-03-15 10:40:59','',''),(3589,'1','313','1',1,'Retail Sale Id 3650',5680.00,0.00,0.00,8.00,840.00,'2023-03-15 10:41:45','',''),(3590,'1','313','1',1,'Retail Sale Id 3651',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 10:43:56','',''),(3591,'1','313','1',1,'Retail Sale Id 3652',14200.00,0.00,0.00,20.00,2100.00,'2023-03-15 10:44:58','',''),(3592,'1','313','1',1,'Retail Sale Id 3653',1775.00,0.00,0.00,2.50,262.50,'2023-03-15 10:45:54','',''),(3593,'1','313','1',1,'Retail Sale Id 3654',2840.00,0.00,0.00,4.00,420.00,'2023-03-15 10:47:06','',''),(3594,'1','313','1',1,'Retail Sale Id 3655',10295.00,0.00,0.00,14.50,1522.50,'2023-03-15 10:49:05','',''),(3595,'1','313','1',1,'Retail Sale Id 3656',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 10:50:57','',''),(3596,'1','313','1',1,'Retail Sale Id 3657',4260.00,0.00,0.00,6.00,630.00,'2023-03-15 10:52:17','',''),(3597,'1','313','1',1,'Retail Sale Id 3658',4970.00,0.00,0.00,7.00,735.00,'2023-03-15 10:53:18','',''),(3598,'1','313','1',1,'Retail Sale Id 3659',100500.00,0.00,0.00,150.00,9750.00,'2023-03-15 10:54:34','',''),(3599,'1','313','1',1,'Retail Sale Id 3660',33500.00,0.00,0.00,50.00,3250.00,'2023-03-15 11:00:26','',''),(3600,'1','313','1',1,'Retail Sale Id 3661',5680.00,0.00,0.00,8.00,840.00,'2023-03-15 11:03:02','',''),(3601,'1','313','1',1,'Retail Sale Id 3662',710.00,0.00,0.00,1.00,105.00,'2023-03-15 11:05:22','',''),(3602,'1','313','1',1,'Retail Sale Id 3664',3550.00,0.00,0.00,5.00,525.00,'2023-03-15 11:06:57','',''),(3603,'1','313','1',1,'Retail Sale Id 3665',77050.00,0.00,0.00,115.00,7475.00,'2023-03-15 11:09:08','',''),(3604,'1','313','1',1,'Retail Sale Id 3666',19525.00,0.00,0.00,27.50,2887.50,'2023-03-15 11:11:45','',''),(3605,'1','313','1',1,'Retail Sale Id 3667',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 11:14:09','',''),(3606,'1','313','1',1,'Retail Sale Id 3668',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 11:16:13','',''),(3607,'1','313','1',1,'Retail Sale Id 3669',2840.00,0.00,0.00,4.00,420.00,'2023-03-15 11:20:21','',''),(3608,'1','313','1',1,'Retail Sale Id 3670',33500.00,0.00,0.00,50.00,3250.00,'2023-03-15 11:24:51','',''),(3609,'1','313','1',1,'Retail Sale Id 3672',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 11:32:43','',''),(3610,'1','313','1',1,'Retail Sale Id 3674',8875.00,0.00,0.00,12.50,1312.50,'2023-03-15 11:36:29','',''),(3611,'1','313','1',1,'Retail Sale Id 3675',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 11:37:52','',''),(3612,'1','313','1',1,'Retail Sale Id 3676',4970.00,0.00,0.00,7.00,735.00,'2023-03-15 11:38:52','',''),(3613,'1','313','1',1,'Retail Sale Id 3677',2840.00,0.00,0.00,4.00,420.00,'2023-03-15 11:40:43','',''),(3614,'1','313','1',1,'Retail Sale Id 3678',3550.00,0.00,0.00,5.00,525.00,'2023-03-15 11:42:02','',''),(3615,'1','313','1',1,'Retail Sale Id 3679',710.00,0.00,0.00,1.00,105.00,'2023-03-15 11:44:40','',''),(3616,'1','313','1',1,'Retail Sale Id 3680',40200.00,0.00,0.00,60.00,3900.00,'2023-03-15 11:51:43','',''),(3617,'1','313','1',1,'Retail Sale Id 3681',8520.00,0.00,0.00,12.00,1260.00,'2023-03-15 11:52:47','',''),(3618,'1','313','1',1,'Retail Sale Id 3682',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 11:56:19','',''),(3619,'1','313','1',1,'Retail Sale Id 3683',26800.00,0.00,0.00,40.00,2600.00,'2023-03-15 12:04:16','',''),(3620,'1','313','1',1,'Retail Sale Id 3684',2151.30,0.00,0.00,3.03,318.15,'2023-03-15 12:06:12','',''),(3621,'1','313','1',1,'Retail Sale Id 3685',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 12:09:13','',''),(3622,'1','313','1',1,'Retail Sale Id 3686',2201.00,0.00,0.00,3.10,325.50,'2023-03-15 12:11:16','',''),(3623,'1','313','1',1,'Retail Sale Id 3688',4970.00,0.00,0.00,7.00,735.00,'2023-03-15 12:13:20','',''),(3624,'1','313','1',1,'Retail Sale Id 3689',3550.00,0.00,0.00,5.00,525.00,'2023-03-15 12:14:34','',''),(3625,'1','313','1',1,'Retail Sale Id 3690',4970.00,0.00,0.00,7.00,735.00,'2023-03-15 12:16:13','',''),(3626,'1','313','1',1,'Retail Sale Id 3691',3550.00,0.00,0.00,5.00,525.00,'2023-03-15 12:19:15','',''),(3627,'1','313','1',1,'Retail Sale Id 3692',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 12:22:28','',''),(3628,'1','313','1',1,'Retail Sale Id 3693',3195.00,0.00,0.00,4.50,472.50,'2023-03-15 12:23:12','',''),(3629,'1','313','1',1,'Return of Retail Sale Id 3693',0.00,3195.00,4.50,0.00,-472.50,'2023-03-15 12:26:45','',''),(3630,'1','313','1',1,'Retail Sale Id 3694',8875.00,0.00,0.00,12.50,1312.50,'2023-03-15 12:27:45','',''),(3631,'1','313','1',1,'Retail Sale Id 3695',2840.00,0.00,0.00,4.00,420.00,'2023-03-15 12:29:15','',''),(3632,'1','313','1',1,'Retail Sale Id 3696',8875.00,0.00,0.00,12.50,1312.50,'2023-03-15 12:35:06','',''),(3633,'1','313','1',1,'Retail Sale Id 3697',5680.00,0.00,0.00,8.00,840.00,'2023-03-15 12:42:36','',''),(3634,'1','313','1',1,'Retail Sale Id 3699',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 12:44:23','',''),(3635,'1','313','1',1,'Retail Sale Id 3700',7100.00,0.00,0.00,10.00,1050.00,'2023-03-15 12:47:09','',''),(3636,'1','313','1',1,'Retail Sale Id 3701',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 12:47:57','',''),(3637,'1','313','1',1,'Retail Sale Id 3702',4260.00,0.00,0.00,6.00,630.00,'2023-03-15 12:50:01','',''),(3638,'1','313','1',1,'Retail Sale Id 3703',710.00,0.00,0.00,1.00,105.00,'2023-03-15 12:51:10','',''),(3639,'1','313','1',1,'Retail Sale Id 3706',3550.00,0.00,0.00,5.00,525.00,'2023-03-15 12:55:32','',''),(3640,'1','313','1',1,'Retail Sale Id 3707',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 12:57:20','',''),(3641,'1','313','1',1,'Retail Sale Id 3708',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 12:59:40','',''),(3642,'1','313','1',1,'Retail Sale Id 3709',2840.00,0.00,0.00,4.00,420.00,'2023-03-15 13:01:29','',''),(3643,'1','313','1',1,'Retail Sale Id 3710',6390.00,0.00,0.00,9.00,945.00,'2023-03-15 13:02:49','',''),(3644,'1','313','1',1,'Retail Sale Id 3711',3550.00,0.00,0.00,5.00,525.00,'2023-03-15 13:07:39','',''),(3645,'1','313','1',1,'Retail Sale Id 3712',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 13:11:53','',''),(3646,'1','313','1',1,'Retail Sale Id 3713',3550.00,0.00,0.00,5.00,525.00,'2023-03-15 13:19:44','',''),(3647,'1','313','1',1,'Retail Sale Id 3714',8875.00,0.00,0.00,12.50,1312.50,'2023-03-15 13:32:37','',''),(3648,'1','313','1',1,'Retail Sale Id 3715',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 13:41:40','',''),(3649,'1','313','1',1,'Retail Sale Id 3716',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 13:54:52','',''),(3650,'1','313','1',1,'Retail Sale Id 3717',752.60,0.00,0.00,1.06,111.30,'2023-03-15 13:57:11','',''),(3651,'1','313','1',1,'Retail Sale Id 3718',5296.60,0.00,0.00,7.46,783.30,'2023-03-15 13:58:22','',''),(3652,'1','313','1',1,'Retail Sale Id 3719',17040.00,0.00,0.00,24.00,2520.00,'2023-03-15 14:00:33','',''),(3653,'1','313','1',1,'Retail Sale Id 3720',710.00,0.00,0.00,1.00,105.00,'2023-03-15 14:07:47','',''),(3654,'1','313','1',1,'Retail Sale Id 3721',7100.00,0.00,0.00,10.00,1050.00,'2023-03-15 14:08:59','',''),(3655,'1','313','1',1,'Retail Sale Id 3722',8875.00,0.00,0.00,12.50,1312.50,'2023-03-15 14:10:48','',''),(3656,'1','313','1',1,'Retail Sale Id 3723',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 14:17:03','',''),(3657,'1','313','1',1,'Retail Sale Id 3724',1065.00,0.00,0.00,1.50,157.50,'2023-03-15 14:18:21','',''),(3658,'1','313','1',1,'Retail Sale Id 3725',30150.00,0.00,0.00,45.00,2925.00,'2023-03-15 14:21:26','',''),(3659,'1','313','1',1,'Retail Sale Id 3726',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 14:22:54','',''),(3660,'1','313','1',1,'Retail Sale Id 3727',33500.00,0.00,0.00,50.00,3250.00,'2023-03-15 14:25:36','',''),(3661,'1','313','1',1,'Retail Sale Id 3728',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 14:27:22','',''),(3662,'1','313','1',1,'Retail Sale Id 3729',7100.00,0.00,0.00,10.00,1050.00,'2023-03-15 14:29:10','',''),(3663,'1','313','1',1,'Retail Sale Id 3731',1001.10,0.00,0.00,1.41,148.05,'2023-03-15 14:31:49','',''),(3664,'1','313','1',1,'Retail Sale Id 3732',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 14:32:46','',''),(3665,'1','313','1',1,'Retail Sale Id 3733',710.00,0.00,0.00,1.00,105.00,'2023-03-15 14:34:04','',''),(3666,'1','313','1',1,'Retail Sale Id 3734',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 14:35:11','',''),(3667,'1','313','1',1,'Retail Sale Id 3735',752.60,0.00,0.00,1.06,111.30,'2023-03-15 14:36:20','',''),(3668,'1','313','1',1,'Retail Sale Id 3736',2485.00,0.00,0.00,3.50,367.50,'2023-03-15 14:38:03','',''),(3669,'1','313','1',1,'Retail Sale Id 3737',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 14:39:09','',''),(3670,'1','313','1',1,'Retail Sale Id 3738',4260.00,0.00,0.00,6.00,630.00,'2023-03-15 14:39:57','',''),(3671,'1','313','1',1,'Retail Sale Id 3739',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 14:41:07','',''),(3672,'1','313','1',1,'Retail Sale Id 3740',710.00,0.00,0.00,1.00,105.00,'2023-03-15 14:42:13','',''),(3673,'1','313','1',1,'Retail Sale Id 3741',710.00,0.00,0.00,1.00,105.00,'2023-03-15 14:43:26','',''),(3674,'1','313','1',1,'Retail Sale Id 3742',4260.00,0.00,0.00,6.00,630.00,'2023-03-15 14:45:02','',''),(3675,'1','313','1',1,'Retail Sale Id 3743',752.60,0.00,0.00,1.06,111.30,'2023-03-15 14:46:47','',''),(3676,'1','313','1',1,'Retail Sale Id 3744',4970.00,0.00,0.00,7.00,735.00,'2023-03-15 14:48:01','',''),(3677,'1','313','1',1,'Retail Sale Id 3745',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 14:55:07','',''),(3678,'1','313','1',1,'Retail Sale Id 3746',8001.70,0.00,0.00,11.27,1183.35,'2023-03-15 14:58:31','',''),(3679,'1','313','1',1,'Retail Sale Id 3747',752.60,0.00,0.00,1.06,111.30,'2023-03-15 15:06:39','',''),(3680,'1','313','1',1,'Retail Sale Id 3748',8875.00,0.00,0.00,12.50,1312.50,'2023-03-15 15:07:45','',''),(3681,'1','313','1',1,'Retail Sale Id 3749',2840.00,0.00,0.00,4.00,420.00,'2023-03-15 15:09:10','',''),(3682,'1','313','1',1,'Retail Sale Id 3750',710.00,0.00,0.00,1.00,105.00,'2023-03-15 15:09:57','',''),(3683,'1','313','1',1,'Retail Sale Id 3751',752.60,0.00,0.00,1.06,111.30,'2023-03-15 15:13:22','',''),(3684,'1','313','1',1,'Retail Sale Id 3752',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 15:14:42','',''),(3685,'1','313','1',1,'Retail Sale Id 3753',2499.20,0.00,0.00,3.52,369.60,'2023-03-15 15:17:31','',''),(3686,'1','313','1',1,'Retail Sale Id 3754',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 15:18:39','',''),(3687,'1','313','1',1,'Retail Sale Id 3755',2002.20,0.00,0.00,2.82,296.10,'2023-03-15 15:19:51','',''),(3688,'1','313','1',1,'Retail Sale Id 3756',3550.00,0.00,0.00,5.00,525.00,'2023-03-15 15:20:39','',''),(3689,'1','313','1',1,'Retail Sale Id 3757',710.00,0.00,0.00,1.00,105.00,'2023-03-15 15:21:45','',''),(3690,'1','313','1',1,'Retail Sale Id 3758',1498.10,0.00,0.00,2.11,221.55,'2023-03-15 15:23:07','',''),(3691,'1','313','1',1,'Retail Sale Id 3759',4260.00,0.00,0.00,6.00,630.00,'2023-03-15 15:23:55','',''),(3692,'1','313','1',1,'Retail Sale Id 3760',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 15:25:33','',''),(3693,'1','313','1',1,'Retail Sale Id 3761',1498.10,0.00,0.00,2.11,221.55,'2023-03-15 15:26:57','',''),(3694,'1','313','1',1,'Retail Sale Id 3762',78100.00,0.00,0.00,110.00,11550.00,'2023-03-15 15:28:11','',''),(3695,'1','313','1',1,'Return of Retail Sale Id 3762',0.00,78100.00,110.00,0.00,-11550.00,'2023-03-15 15:28:50','',''),(3696,'1','313','1',1,'Retail Sale Id 3763',7100.00,0.00,0.00,10.00,1050.00,'2023-03-15 15:29:30','',''),(3697,'1','313','1',1,'Retail Sale Id 3764',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 15:31:14','',''),(3698,'1','313','1',1,'Retail Sale Id 3765',4260.00,0.00,0.00,6.00,630.00,'2023-03-15 15:32:11','',''),(3699,'1','313','1',1,'Retail Sale Id 3766',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 15:33:17','',''),(3700,'1','313','1',1,'Retail Sale Id 3767',1803.40,0.00,0.00,2.54,266.70,'2023-03-15 15:35:31','',''),(3701,'1','313','1',1,'Retail Sale Id 3768',4970.00,0.00,0.00,7.00,735.00,'2023-03-15 15:37:34','',''),(3702,'1','313','1',1,'Retail Sale Id 3769',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 15:39:11','',''),(3703,'1','313','1',1,'Retail Sale Id 3770',6390.00,0.00,0.00,9.00,945.00,'2023-03-15 15:41:06','',''),(3704,'1','313','1',1,'Retail Sale Id 3771',1001.10,0.00,0.00,1.41,148.05,'2023-03-15 15:42:16','',''),(3705,'1','313','1',1,'Retail Sale Id 3772',4970.00,0.00,0.00,7.00,735.00,'2023-03-15 15:43:15','',''),(3706,'1','313','1',1,'Retail Sale Id 3773',7810.00,0.00,0.00,11.00,1155.00,'2023-03-15 15:45:27','',''),(3707,'1','313','1',1,'Retail Sale Id 3774',3550.00,0.00,0.00,5.00,525.00,'2023-03-15 15:47:24','',''),(3708,'1','313','1',1,'Retail Sale Id 3775',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 15:49:18','',''),(3709,'1','313','1',1,'Retail Sale Id 3776',710.00,0.00,0.00,1.00,105.00,'2023-03-15 15:51:34','',''),(3710,'1','313','1',1,'Retail Sale Id 3777',752.60,0.00,0.00,1.06,111.30,'2023-03-15 15:52:40','',''),(3711,'1','313','1',1,'Retail Sale Id 3778',3997.30,0.00,0.00,5.63,591.15,'2023-03-15 15:55:01','',''),(3712,'1','313','1',1,'Retail Sale Id 3779',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 15:56:48','',''),(3713,'1','313','1',1,'Retail Sale Id 3780',12070.00,0.00,0.00,17.00,1785.00,'2023-03-15 15:57:57','',''),(3714,'1','313','1',1,'Retail Sale Id 3781',4998.40,0.00,0.00,7.04,739.20,'2023-03-15 15:59:35','',''),(3715,'1','313','1',1,'Retail Sale Id 3782',8875.00,0.00,0.00,12.50,1312.50,'2023-03-15 16:00:58','',''),(3716,'1','313','1',1,'Retail Sale Id 3783',2499.20,0.00,0.00,3.52,369.60,'2023-03-15 16:02:19','',''),(3717,'1','313','1',1,'Retail Sale Id 3784',5360.00,0.00,0.00,8.00,520.00,'2023-03-15 16:03:37','',''),(3718,'1','313','1',1,'Retail Sale Id 3785',28810.00,0.00,0.00,43.00,2795.00,'2023-03-15 16:04:32','',''),(3719,'1','313','1',1,'Retail Sale Id 3786',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 16:05:42','',''),(3720,'1','313','1',1,'Retail Sale Id 3787',1498.10,0.00,0.00,2.11,221.55,'2023-03-15 16:07:07','',''),(3721,'1','313','1',1,'Retail Sale Id 3788',1448.40,0.00,0.00,2.04,214.20,'2023-03-15 16:08:05','',''),(3722,'1','313','1',1,'Retail Sale Id 3789',8520.00,0.00,0.00,12.00,1260.00,'2023-03-15 16:09:55','',''),(3723,'1','313','1',1,'Retail Sale Id 3790',3550.00,0.00,0.00,5.00,525.00,'2023-03-15 16:11:32','',''),(3724,'1','313','1',1,'Retail Sale Id 3791',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 16:13:43','',''),(3725,'1','313','1',1,'Retail Sale Id 3792',7100.00,0.00,0.00,10.00,1050.00,'2023-03-15 16:14:28','',''),(3726,'1','313','1',1,'Retail Sale Id 3793',710.00,0.00,0.00,1.00,105.00,'2023-03-15 16:15:39','',''),(3727,'1','313','1',1,'Retail Sale Id 3794',2130.00,0.00,0.00,3.00,315.00,'2023-03-15 16:17:24','',''),(3728,'1','313','1',1,'Retail Sale Id 3795',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 16:18:56','',''),(3729,'1','313','1',1,'Retail Sale Id 3796',710.00,0.00,0.00,1.00,105.00,'2023-03-15 16:19:46','',''),(3730,'1','313','1',1,'Retail Sale Id 3797',1001.10,0.00,0.00,1.41,148.05,'2023-03-15 16:20:50','',''),(3731,'1','313','1',1,'Retail Sale Id 3798',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 16:21:30','',''),(3732,'1','313','1',1,'Retail Sale Id 3800',2840.00,0.00,0.00,4.00,420.00,'2023-03-15 16:22:57','',''),(3733,'1','313','1',1,'Retail Sale Id 3801',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 16:24:08','',''),(3734,'1','313','1',1,'Retail Sale Id 3802',17040.00,0.00,0.00,24.00,2520.00,'2023-03-15 16:26:34','',''),(3735,'1','313','1',1,'Retail Sale Id 3803',4970.00,0.00,0.00,7.00,735.00,'2023-03-15 16:28:02','',''),(3736,'1','313','1',1,'Retail Sale Id 3804',3550.00,0.00,0.00,5.00,525.00,'2023-03-15 16:29:20','',''),(3737,'1','313','1',1,'Retail Sale Id 3805',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 16:32:06','',''),(3738,'1','313','1',1,'Retail Sale Id 3806',710.00,0.00,0.00,1.00,105.00,'2023-03-15 16:34:39','',''),(3739,'1','313','1',1,'Retail Sale Id 3807',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 16:35:18','',''),(3740,'1','313','1',1,'Retail Sale Id 3808',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 16:37:03','',''),(3741,'1','313','1',1,'Retail Sale Id 3809',1001.10,0.00,0.00,1.41,148.05,'2023-03-15 16:39:19','',''),(3742,'1','313','1',1,'Retail Sale Id 3810',1420.00,0.00,0.00,2.00,210.00,'2023-03-15 16:40:15','',''),(3743,'1','313','1',1,'Retail Sale Id 3811',1498.10,0.00,0.00,2.11,221.55,'2023-03-15 17:03:23','',''),(3744,'1','313','1',1,'Retail Sale Id 3812',4970.00,0.00,0.00,7.00,735.00,'2023-03-15 17:04:28','',''),(3745,'1','313','1',1,'Retail Sale Id 3813',752.60,0.00,0.00,1.06,111.30,'2023-03-15 17:05:28','',''),(3746,'1','313','1',1,'Retail Sale Id 3814',2840.00,0.00,0.00,4.00,420.00,'2023-03-15 17:10:56','',''),(3747,'1','313','1',1,'Return of Retail Sale Id 3719',0.00,17040.00,24.00,0.00,-2520.00,'2023-03-15 17:12:39','',''),(3748,'1','313','1',1,'Return of Retail Sale Id 3802',0.00,17040.00,24.00,0.00,-2520.00,'2023-03-15 17:14:08','',''),(3749,'1','313','1',1,'Retail Sale Id 3815',32160.00,0.00,0.00,48.00,3120.00,'2023-03-15 17:15:11','',''),(3750,'1','313','1',1,'Return of Retail Sale Id 3794',0.00,2130.00,3.00,0.00,-315.00,'2023-03-15 17:21:57','',''),(3751,'1','313','1',1,'Retail Sale Id 3816',1902.80,0.00,0.00,2.68,281.40,'2023-03-15 17:22:59','',''),(3752,'1','313','1',1,'Return of Retail Sale Id 3665',0.00,77050.00,115.00,0.00,-7475.00,'2023-03-15 17:38:04','',''),(3753,'1','313','1',1,'Retail Sale Id 3817',36427.90,0.00,0.00,54.37,3534.05,'2023-03-15 17:38:53','',''),(3754,'1','313','1',1,'Retail Sale Id 3818',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 08:21:32','',''),(3755,'1','313','1',1,'Retail Sale Id 3819',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 08:22:59','',''),(3756,'1','313','1',1,'Retail Sale Id 3820',4260.00,0.00,0.00,6.00,630.00,'2023-03-16 08:23:58','',''),(3757,'1','313','1',1,'Retail Sale Id 3821',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 08:25:21','',''),(3758,'1','313','1',1,'Retail Sale Id 3822',5680.00,0.00,0.00,8.00,840.00,'2023-03-16 08:26:33','',''),(3759,'1','313','1',1,'Retail Sale Id 3823',2840.00,0.00,0.00,4.00,420.00,'2023-03-16 08:28:13','',''),(3760,'1','313','1',1,'Retail Sale Id 3824',6390.00,0.00,0.00,9.00,945.00,'2023-03-16 08:29:38','',''),(3761,'1','313','1',1,'Retail Sale Id 3825',8520.00,0.00,0.00,12.00,1260.00,'2023-03-16 08:31:07','',''),(3762,'1','313','1',1,'Retail Sale Id 3826',5680.00,0.00,0.00,8.00,840.00,'2023-03-16 08:32:13','',''),(3763,'1','313','1',1,'Retail Sale Id 3827',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 08:33:01','',''),(3764,'1','313','1',1,'Retail Sale Id 3828',3550.00,0.00,0.00,5.00,525.00,'2023-03-16 08:33:58','',''),(3765,'1','313','1',1,'Retail Sale Id 3829',710.00,0.00,0.00,1.00,105.00,'2023-03-16 08:35:17','',''),(3766,'1','313','1',1,'Retail Sale Id 3830',5680.00,0.00,0.00,8.00,840.00,'2023-03-16 08:37:25','',''),(3767,'1','313','1',1,'Retail Sale Id 3831',4260.00,0.00,0.00,6.00,630.00,'2023-03-16 08:38:07','',''),(3768,'1','313','1',1,'Retail Sale Id 3832',4970.00,0.00,0.00,7.00,735.00,'2023-03-16 08:39:10','',''),(3769,'1','313','1',1,'Retail Sale Id 3833',8520.00,0.00,0.00,12.00,1260.00,'2023-03-16 08:40:01','',''),(3770,'1','313','1',1,'Retail Sale Id 3834',41265.30,0.00,0.00,61.59,4003.35,'2023-03-16 08:43:52','',''),(3771,'1','313','1',1,'Retail Sale Id 3835',4970.00,0.00,0.00,7.00,735.00,'2023-03-16 08:44:34','',''),(3772,'1','313','1',1,'Retail Sale Id 3836',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 08:45:19','',''),(3773,'1','313','1',1,'Retail Sale Id 3837',710.00,0.00,0.00,1.00,105.00,'2023-03-16 08:46:20','',''),(3774,'1','313','1',1,'Retail Sale Id 3838',710.00,0.00,0.00,1.00,105.00,'2023-03-16 08:47:00','',''),(3775,'1','313','1',1,'Retail Sale Id 3839',3550.00,0.00,0.00,5.00,525.00,'2023-03-16 08:47:39','',''),(3776,'1','313','1',1,'Retail Sale Id 3840',4970.00,0.00,0.00,7.00,735.00,'2023-03-16 08:48:24','',''),(3777,'1','313','1',1,'Retail Sale Id 3841',2840.00,0.00,0.00,4.00,420.00,'2023-03-16 08:51:43','',''),(3778,'1','313','1',1,'Retail Sale Id 3842',710.00,0.00,0.00,1.00,105.00,'2023-03-16 08:52:15','',''),(3779,'1','313','1',1,'Retail Sale Id 3843',3550.00,0.00,0.00,5.00,525.00,'2023-03-16 08:52:46','',''),(3780,'1','313','1',1,'Retail Sale Id 3844',5680.00,0.00,0.00,8.00,840.00,'2023-03-16 08:53:47','',''),(3781,'1','313','1',1,'Return of Retail Sale Id 3844',0.00,5680.00,8.00,0.00,-840.00,'2023-03-16 08:54:31','',''),(3782,'1','313','1',1,'Retail Sale Id 3845',2840.00,0.00,0.00,4.00,420.00,'2023-03-16 08:54:58','',''),(3783,'1','313','1',1,'Retail Sale Id 3846',2840.00,0.00,0.00,4.00,420.00,'2023-03-16 08:55:29','',''),(3784,'1','313','1',1,'Retail Sale Id 3847',44020.00,0.00,0.00,62.00,6510.00,'2023-03-16 08:57:01','',''),(3785,'1','313','1',1,'Retail Sale Id 3848',67000.00,0.00,0.00,100.00,6500.00,'2023-03-16 08:58:03','',''),(3786,'1','313','1',1,'Retail Sale Id 3849',39985.60,0.00,0.00,59.68,3879.20,'2023-03-16 08:59:25','',''),(3787,'1','313','1',1,'Retail Sale Id 3850',752.60,0.00,0.00,1.06,111.30,'2023-03-16 09:00:16','',''),(3788,'1','313','1',1,'Retail Sale Id 3851',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 09:01:54','',''),(3789,'1','313','1',1,'Retail Sale Id 3852',8875.00,0.00,0.00,12.50,1312.50,'2023-03-16 09:03:03','',''),(3790,'1','313','1',1,'Retail Sale Id 3853',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 09:03:57','',''),(3791,'1','313','1',1,'Retail Sale Id 3854',7100.00,0.00,0.00,10.00,1050.00,'2023-03-16 09:04:34','',''),(3792,'1','313','1',1,'Retail Sale Id 3855',4970.00,0.00,0.00,7.00,735.00,'2023-03-16 09:05:09','',''),(3793,'1','313','1',1,'Retail Sale Id 3856',710.00,0.00,0.00,1.00,105.00,'2023-03-16 09:05:50','',''),(3794,'1','313','1',1,'Retail Sale Id 3857',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 09:06:22','',''),(3795,'1','313','1',1,'Retail Sale Id 3858',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 09:07:49','',''),(3796,'1','313','1',1,'Retail Sale Id 3859',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 09:08:26','',''),(3797,'1','313','1',1,'Retail Sale Id 3860',2151.30,0.00,0.00,3.03,318.15,'2023-03-16 09:09:51','',''),(3798,'1','313','1',1,'Retail Sale Id 3861',2151.30,0.00,0.00,3.03,318.15,'2023-03-16 09:11:21','',''),(3799,'1','313','1',1,'Retail Sale Id 3862',12730.00,0.00,0.00,19.00,1235.00,'2023-03-16 09:12:27','',''),(3800,'1','313','1',1,'Retail Sale Id 3863',2840.00,0.00,0.00,4.00,420.00,'2023-03-16 09:13:15','',''),(3801,'1','313','1',1,'Retail Sale Id 3864',3550.00,0.00,0.00,5.00,525.00,'2023-03-16 09:13:48','',''),(3802,'1','313','1',1,'Retail Sale Id 3865',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 09:14:26','',''),(3803,'1','313','1',1,'Retail Sale Id 3866',710.00,0.00,0.00,1.00,105.00,'2023-03-16 09:15:12','',''),(3804,'1','313','1',1,'Retail Sale Id 3867',8875.00,0.00,0.00,12.50,1312.50,'2023-03-16 09:15:58','',''),(3805,'1','313','1',1,'Retail Sale Id 3868',7100.00,0.00,0.00,10.00,1050.00,'2023-03-16 09:16:46','',''),(3806,'1','313','1',1,'Retail Sale Id 3869',4260.00,0.00,0.00,6.00,630.00,'2023-03-16 09:17:13','',''),(3807,'1','313','1',1,'Retail Sale Id 3870',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 09:18:09','',''),(3808,'1','313','1',1,'Retail Sale Id 3871',33500.00,0.00,0.00,50.00,3250.00,'2023-03-16 09:19:44','',''),(3809,'1','313','1',1,'Retail Sale Id 3872',3003.30,0.00,0.00,4.23,444.15,'2023-03-16 09:20:31','',''),(3810,'1','313','1',1,'Retail Sale Id 3873',2151.30,0.00,0.00,3.03,318.15,'2023-03-16 09:21:17','',''),(3811,'1','313','1',1,'Retail Sale Id 3874',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 09:22:19','',''),(3812,'1','313','1',1,'Retail Sale Id 3875',1001.10,0.00,0.00,1.41,148.05,'2023-03-16 09:23:14','',''),(3813,'1','313','1',1,'Retail Sale Id 3876',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 09:23:46','',''),(3814,'1','313','1',1,'Retail Sale Id 3877',6390.00,0.00,0.00,9.00,945.00,'2023-03-16 09:25:27','',''),(3815,'1','313','1',1,'Retail Sale Id 3878',40200.00,0.00,0.00,60.00,3900.00,'2023-03-16 09:26:38','',''),(3816,'1','313','1',1,'Retail Sale Id 3879',16330.00,0.00,0.00,23.00,2415.00,'2023-03-16 09:27:52','',''),(3817,'1','313','1',1,'Retail Sale Id 3880',710.00,0.00,0.00,1.00,105.00,'2023-03-16 09:28:49','',''),(3818,'1','313','1',1,'Retail Sale Id 3881',2840.00,0.00,0.00,4.00,420.00,'2023-03-16 09:30:17','',''),(3819,'1','313','1',1,'Retail Sale Id 3882',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 09:31:14','',''),(3820,'1','313','1',1,'Retail Sale Id 3883',8875.00,0.00,0.00,12.50,1312.50,'2023-03-16 09:32:13','',''),(3821,'1','313','1',1,'Retail Sale Id 3884',8875.00,0.00,0.00,12.50,1312.50,'2023-03-16 09:33:12','',''),(3822,'1','313','1',1,'Retail Sale Id 3885',752.60,0.00,0.00,1.06,111.30,'2023-03-16 09:34:09','',''),(3823,'1','313','1',1,'Return of Retail Sale Id 3847',0.00,44020.00,62.00,0.00,-6510.00,'2023-03-16 09:36:22','',''),(3824,'1','313','1',1,'Retail Sale Id 3886',41540.00,0.00,0.00,62.00,4030.00,'2023-03-16 09:37:07','',''),(3825,'1','313','1',1,'Retail Sale Id 3887',4260.00,0.00,0.00,6.00,630.00,'2023-03-16 09:37:50','',''),(3826,'1','313','1',1,'Retail Sale Id 3888',3003.30,0.00,0.00,4.23,444.15,'2023-03-16 09:38:29','',''),(3827,'1','313','1',1,'Retail Sale Id 3889',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 09:39:04','',''),(3828,'1','313','1',1,'Retail Sale Id 3890',710.00,0.00,0.00,1.00,105.00,'2023-03-16 09:43:41','',''),(3829,'1','313','1',1,'Retail Sale Id 3891',4970.00,0.00,0.00,7.00,735.00,'2023-03-16 09:48:45','',''),(3830,'1','313','1',1,'Retail Sale Id 3892',16750.00,0.00,0.00,25.00,1625.00,'2023-03-16 09:49:59','',''),(3831,'1','313','1',1,'Retail Sale Id 3893',710.00,0.00,0.00,1.00,105.00,'2023-03-16 09:50:44','',''),(3832,'1','313','1',1,'Retail Sale Id 3894',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 09:51:30','',''),(3833,'1','313','1',1,'Retail Sale Id 3895',1448.40,0.00,0.00,2.04,214.20,'2023-03-16 09:52:13','',''),(3834,'1','313','1',1,'Retail Sale Id 3896',710.00,0.00,0.00,1.00,105.00,'2023-03-16 09:53:07','',''),(3835,'1','313','1',1,'Retail Sale Id 3897',9230.00,0.00,0.00,13.00,1365.00,'2023-03-16 09:53:51','',''),(3836,'1','313','1',1,'Retail Sale Id 3898',3550.00,0.00,0.00,5.00,525.00,'2023-03-16 09:58:09','',''),(3837,'1','313','1',1,'Retail Sale Id 3899',4970.00,0.00,0.00,7.00,735.00,'2023-03-16 09:59:27','',''),(3838,'1','313','1',1,'Retail Sale Id 3900',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 10:00:08','',''),(3839,'1','313','1',1,'Retail Sale Id 3901',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 10:02:02','',''),(3840,'1','313','1',1,'Retail Sale Id 3902',4260.00,0.00,0.00,6.00,630.00,'2023-03-16 10:04:35','',''),(3841,'1','313','1',1,'Retail Sale Id 3903',4260.00,0.00,0.00,6.00,630.00,'2023-03-16 10:05:22','',''),(3842,'1','313','1',1,'Retail Sale Id 3904',3003.30,0.00,0.00,4.23,444.15,'2023-03-16 10:06:43','',''),(3843,'1','313','1',1,'Retail Sale Id 3905',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 10:07:14','',''),(3844,'1','313','1',1,'Retail Sale Id 3906',8875.00,0.00,0.00,12.50,1312.50,'2023-03-16 10:07:47','',''),(3845,'1','313','1',1,'Retail Sale Id 3907',1001.10,0.00,0.00,1.41,148.05,'2023-03-16 10:08:40','',''),(3846,'1','313','1',1,'Retail Sale Id 3908',2151.30,0.00,0.00,3.03,318.15,'2023-03-16 10:10:10','',''),(3847,'1','313','1',1,'Retail Sale Id 3909',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 10:11:10','',''),(3848,'1','313','1',1,'Retail Sale Id 3910',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 10:12:35','',''),(3849,'1','313','1',1,'Retail Sale Id 3911',9230.00,0.00,0.00,13.00,1365.00,'2023-03-16 10:13:24','',''),(3850,'1','313','1',1,'Retail Sale Id 3912',3997.30,0.00,0.00,5.63,591.15,'2023-03-16 10:14:25','',''),(3851,'1','313','1',1,'Retail Sale Id 3913',4260.00,0.00,0.00,6.00,630.00,'2023-03-16 10:14:52','',''),(3852,'1','313','1',1,'Retail Sale Id 3914',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 10:16:04','',''),(3853,'1','313','1',1,'Retail Sale Id 3915',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 10:16:54','',''),(3854,'1','313','1',1,'Retail Sale Id 3916',7370.00,0.00,0.00,11.00,715.00,'2023-03-16 10:20:55','',''),(3855,'1','313','1',1,'Retail Sale Id 3917',8875.00,0.00,0.00,12.50,1312.50,'2023-03-16 10:22:15','',''),(3856,'1','313','1',1,'Retail Sale Id 3918',2151.30,0.00,0.00,3.03,318.15,'2023-03-16 10:26:40','',''),(3857,'1','313','1',1,'Retail Sale Id 3919',3003.30,0.00,0.00,4.23,444.15,'2023-03-16 10:28:19','',''),(3858,'1','313','1',1,'Retail Sale Id 3921',2151.30,0.00,0.00,3.03,318.15,'2023-03-16 10:32:36','',''),(3859,'1','313','1',1,'Retail Sale Id 3922',5325.00,0.00,0.00,7.50,787.50,'2023-03-16 10:37:20','',''),(3860,'1','313','1',1,'Retail Sale Id 3923',8875.00,0.00,0.00,12.50,1312.50,'2023-03-16 10:43:58','',''),(3861,'1','313','1',1,'Retail Sale Id 3924',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 10:44:52','',''),(3862,'1','313','1',1,'Retail Sale Id 3925',3003.30,0.00,0.00,4.23,444.15,'2023-03-16 10:46:00','',''),(3863,'1','313','1',1,'Retail Sale Id 3926',4970.00,0.00,0.00,7.00,735.00,'2023-03-16 10:47:12','',''),(3864,'1','313','1',1,'Retail Sale Id 3927',2151.30,0.00,0.00,3.03,318.15,'2023-03-16 10:49:19','',''),(3865,'1','313','1',1,'Retail Sale Id 3928',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 10:50:36','',''),(3866,'1','313','1',1,'Retail Sale Id 3929',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 10:51:18','',''),(3867,'1','313','1',1,'Retail Sale Id 3930',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 10:56:50','',''),(3868,'1','313','1',1,'Retail Sale Id 3931',2499.20,0.00,0.00,3.52,369.60,'2023-03-16 10:59:17','',''),(3869,'1','313','1',1,'Retail Sale Id 3932',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 11:02:48','',''),(3870,'1','313','1',1,'Retail Sale Id 3933',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 11:04:00','',''),(3871,'1','313','1',1,'Retail Sale Id 3934',710.00,0.00,0.00,1.00,105.00,'2023-03-16 11:05:52','',''),(3872,'1','313','1',1,'Retail Sale Id 3935',802.30,0.00,0.00,1.13,118.65,'2023-03-16 11:12:37','',''),(3873,'1','313','1',1,'Retail Sale Id 3936',4260.00,0.00,0.00,6.00,630.00,'2023-03-16 11:15:13','',''),(3874,'1','313','1',1,'Retail Sale Id 3937',1498.10,0.00,0.00,2.11,221.55,'2023-03-16 11:29:11','',''),(3875,'1','313','1',1,'Retail Sale Id 3938',710.00,0.00,0.00,1.00,105.00,'2023-03-16 11:30:51','',''),(3876,'1','313','1',1,'Retail Sale Id 3939',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 11:32:22','',''),(3877,'1','313','1',1,'Retail Sale Id 3940',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 11:34:20','',''),(3878,'1','313','1',1,'Retail Sale Id 3941',1001.10,0.00,0.00,1.41,148.05,'2023-03-16 11:35:29','',''),(3879,'1','313','1',1,'Retail Sale Id 3942',8875.00,0.00,0.00,12.50,1312.50,'2023-03-16 11:37:16','',''),(3880,'1','313','1',1,'Retail Sale Id 3943',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 11:38:25','',''),(3881,'1','313','1',1,'Retail Sale Id 3944',3550.00,0.00,0.00,5.00,525.00,'2023-03-16 11:40:39','',''),(3882,'1','313','1',1,'Retail Sale Id 3945',5999.50,0.00,0.00,8.45,887.25,'2023-03-16 11:44:28','',''),(3883,'1','313','1',1,'Retail Sale Id 3946',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 11:45:32','',''),(3884,'1','313','1',1,'Retail Sale Id 3947',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 11:46:59','',''),(3885,'1','313','1',1,'Retail Sale Id 3948',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 11:53:20','',''),(3886,'1','313','1',1,'Retail Sale Id 3949',2840.00,0.00,0.00,4.00,420.00,'2023-03-16 11:56:21','',''),(3887,'1','313','1',1,'Retail Sale Id 3950',2847.10,0.00,0.00,4.01,421.05,'2023-03-16 11:57:49','',''),(3888,'1','313','1',1,'Retail Sale Id 3952',13845.00,0.00,0.00,19.50,2047.50,'2023-03-16 12:02:15','',''),(3889,'1','313','1',1,'Retail Sale Id 3953',4970.00,0.00,0.00,7.00,735.00,'2023-03-16 12:04:48','',''),(3890,'1','313','1',1,'Retail Sale Id 3954',4260.00,0.00,0.00,6.00,630.00,'2023-03-16 12:06:52','',''),(3891,'1','313','1',1,'Retail Sale Id 3956',1001.10,0.00,0.00,1.41,148.05,'2023-03-16 12:10:46','',''),(3892,'1','313','1',1,'Retail Sale Id 3957',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 12:14:36','',''),(3893,'1','313','1',1,'Retail Sale Id 3958',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 12:17:34','',''),(3894,'1','313','1',1,'Retail Sale Id 3959',3550.00,0.00,0.00,5.00,525.00,'2023-03-16 12:18:32','',''),(3895,'1','313','1',1,'Retail Sale Id 3960',4260.00,0.00,0.00,6.00,630.00,'2023-03-16 12:24:45','',''),(3896,'1','313','1',1,'Retail Sale Id 3961',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 12:25:48','',''),(3897,'1','313','1',1,'Retail Sale Id 3962',710.00,0.00,0.00,1.00,105.00,'2023-03-16 12:28:22','',''),(3898,'1','313','1',1,'Retail Sale Id 3963',3003.30,0.00,0.00,4.23,444.15,'2023-03-16 12:33:30','',''),(3899,'1','313','1',1,'Retail Sale Id 3964',3550.00,0.00,0.00,5.00,525.00,'2023-03-16 12:37:29','',''),(3900,'1','313','1',1,'Retail Sale Id 3965',2002.20,0.00,0.00,2.82,296.10,'2023-03-16 12:39:24','',''),(3901,'1','313','1',1,'Retail Sale Id 3966',2840.00,0.00,0.00,4.00,420.00,'2023-03-16 12:40:43','',''),(3902,'1','313','1',1,'Retail Sale Id 3967',4260.00,0.00,0.00,6.00,630.00,'2023-03-16 12:46:17','',''),(3903,'1','313','1',1,'Retail Sale Id 3968',710.00,0.00,0.00,1.00,105.00,'2023-03-16 12:49:42','',''),(3904,'1','313','1',1,'Retail Sale Id 3970',2840.00,0.00,0.00,4.00,420.00,'2023-03-16 12:55:18','',''),(3905,'1','313','1',1,'Retail Sale Id 3971',710.00,0.00,0.00,1.00,105.00,'2023-03-16 12:57:13','',''),(3906,'1','313','1',1,'Retail Sale Id 3972',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 12:58:53','',''),(3907,'1','313','1',1,'Retail Sale Id 3973',4970.00,0.00,0.00,7.00,735.00,'2023-03-16 13:00:59','',''),(3908,'1','313','1',1,'Retail Sale Id 3974',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 13:06:12','',''),(3909,'1','313','1',1,'Retail Sale Id 3975',3550.00,0.00,0.00,5.00,525.00,'2023-03-16 13:11:30','',''),(3910,'1','313','1',1,'Retail Sale Id 3976',1001.10,0.00,0.00,1.41,148.05,'2023-03-16 13:12:57','',''),(3911,'1','313','1',1,'Retail Sale Id 3977',4970.00,0.00,0.00,7.00,735.00,'2023-03-16 13:14:20','',''),(3912,'1','313','1',1,'Retail Sale Id 3978',4260.00,0.00,0.00,6.00,630.00,'2023-03-16 13:14:48','',''),(3913,'1','313','1',1,'Retail Sale Id 3979',2840.00,0.00,0.00,4.00,420.00,'2023-03-16 13:17:11','',''),(3914,'1','313','1',1,'Retail Sale Id 3980',3550.00,0.00,0.00,5.00,525.00,'2023-03-16 13:20:39','',''),(3915,'1','313','1',1,'Retail Sale Id 3981',1775.00,0.00,0.00,2.50,262.50,'2023-03-16 13:22:22','',''),(3916,'1','313','1',1,'Retail Sale Id 3982',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 13:25:41','',''),(3917,'1','313','1',1,'Retail Sale Id 3983',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 13:40:14','',''),(3918,'1','313','1',1,'Retail Sale Id 3984',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 13:53:46','',''),(3919,'1','313','1',1,'Retail Sale Id 3985',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 13:57:21','',''),(3920,'1','313','1',1,'Retail Sale Id 3986',3550.00,0.00,0.00,5.00,525.00,'2023-03-16 13:58:48','',''),(3921,'1','313','1',1,'Retail Sale Id 3987',3550.00,0.00,0.00,5.00,525.00,'2023-03-16 14:08:21','',''),(3922,'1','313','1',1,'Retail Sale Id 3988',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 14:12:46','',''),(3923,'1','313','1',1,'Retail Sale Id 3989',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 14:13:40','',''),(3924,'1','313','1',1,'Retail Sale Id 3990',4260.00,0.00,0.00,6.00,630.00,'2023-03-16 14:14:50','',''),(3925,'1','313','1',1,'Retail Sale Id 3991',2840.00,0.00,0.00,4.00,420.00,'2023-03-16 14:16:26','',''),(3926,'1','313','1',1,'Retail Sale Id 3992',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 14:18:47','',''),(3927,'1','313','1',1,'Retail Sale Id 3993',8520.00,0.00,0.00,12.00,1260.00,'2023-03-16 14:25:15','',''),(3928,'1','313','1',1,'Retail Sale Id 3994',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 14:26:37','',''),(3929,'1','313','1',1,'Retail Sale Id 3995',7100.00,0.00,0.00,10.00,1050.00,'2023-03-16 14:28:25','',''),(3930,'1','313','1',1,'Retail Sale Id 3996',4260.00,0.00,0.00,6.00,630.00,'2023-03-16 14:29:52','',''),(3931,'1','313','1',1,'Retail Sale Id 3997',4260.00,0.00,0.00,6.00,630.00,'2023-03-16 14:30:51','',''),(3932,'1','313','1',1,'Retail Sale Id 3998',4260.00,0.00,0.00,6.00,630.00,'2023-03-16 14:33:00','',''),(3933,'1','313','1',1,'Retail Sale Id 3999',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 14:41:09','',''),(3934,'1','313','1',1,'Retail Sale Id 4000',4260.00,0.00,0.00,6.00,630.00,'2023-03-16 14:42:36','',''),(3935,'1','313','1',1,'Retail Sale Id 4001',8875.00,0.00,0.00,12.50,1312.50,'2023-03-16 14:45:15','',''),(3936,'1','313','1',1,'Retail Sale Id 4002',3003.30,0.00,0.00,4.23,444.15,'2023-03-16 14:50:28','',''),(3937,'1','313','1',1,'Retail Sale Id 4003',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 14:51:49','',''),(3938,'1','313','1',1,'Retail Sale Id 4004',4260.00,0.00,0.00,6.00,630.00,'2023-03-16 14:58:34','',''),(3939,'1','313','1',1,'Retail Sale Id 4005',710.00,0.00,0.00,1.00,105.00,'2023-03-16 15:02:03','',''),(3940,'1','313','1',1,'Retail Sale Id 4006',4970.00,0.00,0.00,7.00,735.00,'2023-03-16 15:02:45','',''),(3941,'1','313','1',1,'Retail Sale Id 4007',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 15:04:51','',''),(3942,'1','313','1',1,'Retail Sale Id 4008',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 15:06:41','',''),(3943,'1','313','1',1,'Retail Sale Id 4009',81049.90,0.00,0.00,120.97,7863.05,'2023-03-16 15:10:15','',''),(3944,'1','313','1',1,'Retail Sale Id 4010',710.00,0.00,0.00,1.00,105.00,'2023-03-16 15:11:27','',''),(3945,'1','313','1',1,'Retail Sale Id 4011',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 15:17:42','',''),(3946,'1','313','1',1,'Retail Sale Id 4012',8520.00,0.00,0.00,12.00,1260.00,'2023-03-16 15:20:41','',''),(3947,'1','313','1',1,'Retail Sale Id 4013',26994.30,0.00,0.00,40.29,2618.85,'2023-03-16 15:25:16','',''),(3948,'1','313','1',1,'Retail Sale Id 4014',710.00,0.00,0.00,1.00,105.00,'2023-03-16 15:26:13','',''),(3949,'1','313','1',1,'Retail Sale Id 4015',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 15:27:42','',''),(3950,'1','313','1',1,'Retail Sale Id 4016',1001.10,0.00,0.00,1.41,148.05,'2023-03-16 15:35:55','',''),(3951,'1','313','1',1,'Retail Sale Id 4018',752.60,0.00,0.00,1.06,111.30,'2023-03-16 15:36:58','',''),(3952,'1','313','1',1,'Retail Sale Id 4019',8520.00,0.00,0.00,12.00,1260.00,'2023-03-16 15:38:21','',''),(3953,'1','313','1',1,'Retail Sale Id 4020',2201.00,0.00,0.00,3.10,325.50,'2023-03-16 15:40:40','',''),(3954,'1','313','1',1,'Retail Sale Id 4021',3550.00,0.00,0.00,5.00,525.00,'2023-03-16 15:41:31','',''),(3955,'1','313','1',1,'Retail Sale Id 4022',5680.00,0.00,0.00,8.00,840.00,'2023-03-16 15:42:44','',''),(3956,'1','313','1',1,'Retail Sale Id 4023',2485.00,0.00,0.00,3.50,367.50,'2023-03-16 15:44:08','',''),(3957,'1','313','1',1,'Retail Sale Id 4024',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 15:44:52','',''),(3958,'1','313','1',1,'Retail Sale Id 4025',8875.00,0.00,0.00,12.50,1312.50,'2023-03-16 15:49:44','',''),(3959,'1','313','1',1,'Retail Sale Id 4026',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 15:51:10','',''),(3960,'1','313','1',1,'Retail Sale Id 4027',3550.00,0.00,0.00,5.00,525.00,'2023-03-16 15:52:48','',''),(3961,'1','313','1',1,'Retail Sale Id 4028',4970.00,0.00,0.00,7.00,735.00,'2023-03-16 15:54:14','',''),(3962,'1','313','1',1,'Retail Sale Id 4029',6700.00,0.00,0.00,10.00,650.00,'2023-03-16 15:55:56','',''),(3963,'1','313','1',1,'Retail Sale Id 4030',4970.00,0.00,0.00,7.00,735.00,'2023-03-16 15:57:10','',''),(3964,'1','313','1',1,'Retail Sale Id 4031',10650.00,0.00,0.00,15.00,1575.00,'2023-03-16 15:59:18','',''),(3965,'1','313','1',1,'Retail Sale Id 4032',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 16:00:45','',''),(3966,'1','313','1',1,'Retail Sale Id 4033',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 16:01:38','',''),(3967,'1','313','1',1,'Retail Sale Id 4034',4970.00,0.00,0.00,7.00,735.00,'2023-03-16 16:02:46','',''),(3968,'1','313','1',1,'Retail Sale Id 4035',2151.30,0.00,0.00,3.03,318.15,'2023-03-16 16:04:43','',''),(3969,'1','313','1',1,'Retail Sale Id 4036',13135.00,0.00,0.00,18.50,1942.50,'2023-03-16 16:06:44','',''),(3970,'1','313','1',1,'Retail Sale Id 4037',29480.00,0.00,0.00,44.00,2860.00,'2023-03-16 16:11:05','',''),(3971,'1','313','1',1,'Retail Sale Id 4038',710.00,0.00,0.00,1.00,105.00,'2023-03-16 16:14:13','',''),(3972,'1','313','1',1,'Retail Sale Id 4039',2840.00,0.00,0.00,4.00,420.00,'2023-03-16 16:14:53','',''),(3973,'1','313','1',1,'Retail Sale Id 4040',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 16:16:10','',''),(3974,'1','313','1',1,'Retail Sale Id 4041',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 16:18:17','',''),(3975,'1','313','1',1,'Retail Sale Id 4042',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 16:18:58','',''),(3976,'1','313','1',1,'Retail Sale Id 4043',2840.00,0.00,0.00,4.00,420.00,'2023-03-16 16:19:35','',''),(3977,'1','313','1',1,'Retail Sale Id 4044',2840.00,0.00,0.00,4.00,420.00,'2023-03-16 16:20:40','',''),(3978,'1','313','1',1,'Retail Sale Id 4045',8875.00,0.00,0.00,12.50,1312.50,'2023-03-16 16:23:09','',''),(3979,'1','313','1',1,'Retail Sale Id 4046',2840.00,0.00,0.00,4.00,420.00,'2023-03-16 16:26:39','',''),(3980,'1','313','1',1,'Retail Sale Id 4047',1065.00,0.00,0.00,1.50,157.50,'2023-03-16 16:29:13','',''),(3981,'1','313','1',1,'Retail Sale Id 4048',710.00,0.00,0.00,1.00,105.00,'2023-03-16 16:30:27','',''),(3982,'1','313','1',1,'Retail Sale Id 4049',8875.00,0.00,0.00,12.50,1312.50,'2023-03-16 16:31:44','',''),(3983,'1','313','1',1,'Retail Sale Id 4050',710.00,0.00,0.00,1.00,105.00,'2023-03-16 16:32:53','',''),(3984,'1','313','1',1,'Retail Sale Id 4051',1065.00,0.00,0.00,1.50,157.50,'2023-03-16 16:34:04','',''),(3985,'1','313','1',1,'Retail Sale Id 4052',4260.00,0.00,0.00,6.00,630.00,'2023-03-16 16:35:35','',''),(3986,'1','313','1',1,'Retail Sale Id 4053',3550.00,0.00,0.00,5.00,525.00,'2023-03-16 16:36:41','',''),(3987,'1','313','1',1,'Retail Sale Id 4054',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 16:37:46','',''),(3988,'1','313','1',1,'Retail Sale Id 4055',2840.00,0.00,0.00,4.00,420.00,'2023-03-16 16:39:05','',''),(3989,'1','313','1',1,'Retail Sale Id 4056',710.00,0.00,0.00,1.00,105.00,'2023-03-16 16:42:17','',''),(3990,'1','313','1',1,'Retail Sale Id 4057',9940.00,0.00,0.00,14.00,1470.00,'2023-03-16 16:43:25','',''),(3991,'1','313','1',1,'Retail Sale Id 4058',1420.00,0.00,0.00,2.00,210.00,'2023-03-16 16:44:55','',''),(3992,'1','313','1',1,'Retail Sale Id 4059',1001.10,0.00,0.00,1.41,148.05,'2023-03-16 16:46:14','',''),(3993,'1','313','1',1,'Retail Sale Id 4060',710.00,0.00,0.00,1.00,105.00,'2023-03-16 16:47:58','',''),(3994,'1','313','1',1,'Retail Sale Id 4061',4998.40,0.00,0.00,7.04,739.20,'2023-03-16 16:50:03','',''),(3995,'1','313','1',1,'Retail Sale Id 4062',2101.60,0.00,0.00,2.96,310.80,'2023-03-16 16:50:59','',''),(3996,'1','313','1',1,'Retail Sale Id 4063',33500.00,0.00,0.00,50.00,3250.00,'2023-03-16 16:51:56','',''),(3997,'1','313','1',1,'Retail Sale Id 4064',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 16:52:45','',''),(3998,'1','313','1',1,'Retail Sale Id 4065',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 16:54:11','',''),(3999,'1','313','1',1,'Retail Sale Id 4066',4970.00,0.00,0.00,7.00,735.00,'2023-03-16 16:55:39','',''),(4000,'1','313','1',1,'Retail Sale Id 4067',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 16:56:48','',''),(4001,'1','313','1',1,'Retail Sale Id 4068',2130.00,0.00,0.00,3.00,315.00,'2023-03-16 16:58:56','',''),(4002,'1','313','1',1,'Retail Sale Id 4069',3550.00,0.00,0.00,5.00,525.00,'2023-03-16 17:00:06','',''),(4003,'1','313','1',1,'Return of Retail Sale Id 4052',0.00,4260.00,6.00,0.00,-630.00,'2023-03-16 17:19:55','',''),(4004,'1','313','1',1,'Retail Sale Id 4070',2797.40,0.00,0.00,3.94,413.70,'2023-03-16 17:20:39','',''),(4005,'1','313','1',1,'Retail Sale Id 4071',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 08:02:52','',''),(4006,'1','313','1',1,'Retail Sale Id 4072',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 08:04:22','',''),(4007,'1','313','1',1,'Retail Sale Id 4073',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 08:05:26','',''),(4008,'1','313','1',1,'Retail Sale Id 4074',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 08:06:20','',''),(4009,'1','313','1',1,'Retail Sale Id 4075',752.60,0.00,0.00,1.06,111.30,'2023-03-17 08:07:23','',''),(4010,'1','313','1',1,'Retail Sale Id 4076',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 08:08:15','',''),(4011,'1','313','1',1,'Retail Sale Id 4077',4970.00,0.00,0.00,7.00,735.00,'2023-03-17 08:13:37','',''),(4012,'1','313','1',1,'Retail Sale Id 4078',2002.20,0.00,0.00,2.82,296.10,'2023-03-17 08:14:53','',''),(4013,'1','313','1',1,'Retail Sale Id 4079',5680.00,0.00,0.00,8.00,840.00,'2023-03-17 08:16:08','',''),(4014,'1','313','1',1,'Retail Sale Id 4080',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 08:17:26','',''),(4015,'1','313','1',1,'Retail Sale Id 4081',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 08:18:20','',''),(4016,'1','313','1',1,'Retail Sale Id 4082',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 08:19:20','',''),(4017,'1','313','1',1,'Retail Sale Id 4083',1001.10,0.00,0.00,1.41,148.05,'2023-03-17 08:20:48','',''),(4018,'1','313','1',1,'Retail Sale Id 4084',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 08:21:46','',''),(4019,'1','313','1',1,'Retail Sale Id 4085',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 08:23:03','',''),(4020,'1','313','1',1,'Retail Sale Id 4086',1001.10,0.00,0.00,1.41,148.05,'2023-03-17 08:23:46','',''),(4021,'1','313','1',1,'Retail Sale Id 4087',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 08:24:47','',''),(4022,'1','313','1',1,'Retail Sale Id 4088',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 08:25:46','',''),(4023,'1','313','1',1,'Retail Sale Id 4089',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 08:26:49','',''),(4024,'1','313','1',1,'Retail Sale Id 4090',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 08:27:41','',''),(4025,'1','313','1',1,'Retail Sale Id 4091',22720.00,0.00,0.00,32.00,3360.00,'2023-03-17 08:29:10','',''),(4026,'1','313','1',1,'Retail Sale Id 4092',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 08:30:19','',''),(4027,'1','313','1',1,'Retail Sale Id 4093',752.60,0.00,0.00,1.06,111.30,'2023-03-17 08:31:28','',''),(4028,'1','313','1',1,'Retail Sale Id 4094',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 08:32:11','',''),(4029,'1','313','1',1,'Retail Sale Id 4095',710.00,0.00,0.00,1.00,105.00,'2023-03-17 08:32:49','',''),(4030,'1','313','1',1,'Retail Sale Id 4096',4970.00,0.00,0.00,7.00,735.00,'2023-03-17 08:34:02','',''),(4031,'1','313','1',1,'Retail Sale Id 4097',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 08:35:12','',''),(4032,'1','313','1',1,'Retail Sale Id 4098',9230.00,0.00,0.00,13.00,1365.00,'2023-03-17 08:35:51','',''),(4033,'1','313','1',1,'Retail Sale Id 4099',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 08:37:03','',''),(4034,'1','313','1',1,'Retail Sale Id 4100',4970.00,0.00,0.00,7.00,735.00,'2023-03-17 08:38:00','',''),(4035,'1','313','1',1,'Retail Sale Id 4101',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 08:39:23','',''),(4036,'1','313','1',1,'Retail Sale Id 4102',710.00,0.00,0.00,1.00,105.00,'2023-03-17 08:40:54','',''),(4037,'1','313','1',1,'Retail Sale Id 4103',1498.10,0.00,0.00,2.11,221.55,'2023-03-17 08:42:15','',''),(4038,'1','313','1',1,'Retail Sale Id 4104',40200.00,0.00,0.00,60.00,3900.00,'2023-03-17 08:43:32','',''),(4039,'1','313','1',1,'Retail Sale Id 4105',4998.40,0.00,0.00,7.04,739.20,'2023-03-17 08:44:11','',''),(4040,'1','313','1',1,'Retail Sale Id 4106',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 08:44:56','',''),(4041,'1','313','1',1,'Retail Sale Id 4107',1001.10,0.00,0.00,1.41,148.05,'2023-03-17 08:46:02','',''),(4042,'1','313','1',1,'Retail Sale Id 4108',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 08:46:53','',''),(4043,'1','313','1',1,'Retail Sale Id 4109',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 08:47:40','',''),(4044,'1','313','1',1,'Retail Sale Id 4110',8520.00,0.00,0.00,12.00,1260.00,'2023-03-17 08:49:14','',''),(4045,'1','313','1',1,'Retail Sale Id 4111',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 08:50:17','',''),(4046,'1','313','1',1,'Retail Sale Id 4112',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 08:51:35','',''),(4047,'1','313','1',1,'Retail Sale Id 4113',710.00,0.00,0.00,1.00,105.00,'2023-03-17 08:52:52','',''),(4048,'1','313','1',1,'Retail Sale Id 4114',710.00,0.00,0.00,1.00,105.00,'2023-03-17 08:53:33','',''),(4049,'1','313','1',1,'Retail Sale Id 4115',710.00,0.00,0.00,1.00,105.00,'2023-03-17 08:54:51','',''),(4050,'1','313','1',1,'Retail Sale Id 4116',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 08:55:26','',''),(4051,'1','313','1',1,'Retail Sale Id 4117',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 08:56:12','',''),(4052,'1','313','1',1,'Retail Sale Id 4118',710.00,0.00,0.00,1.00,105.00,'2023-03-17 08:57:29','',''),(4053,'1','313','1',1,'Retail Sale Id 4119',2002.20,0.00,0.00,2.82,296.10,'2023-03-17 08:58:09','',''),(4054,'1','313','1',1,'Retail Sale Id 4120',3003.30,0.00,0.00,4.23,444.15,'2023-03-17 08:58:51','',''),(4055,'1','313','1',1,'Retail Sale Id 4121',1498.10,0.00,0.00,2.11,221.55,'2023-03-17 08:59:28','',''),(4056,'1','313','1',1,'Retail Sale Id 4122',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 09:00:07','',''),(4057,'1','313','1',1,'Retail Sale Id 4123',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 09:01:06','',''),(4058,'1','313','1',1,'Retail Sale Id 4124',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 09:01:39','',''),(4059,'1','313','1',1,'Retail Sale Id 4125',2151.30,0.00,0.00,3.03,318.15,'2023-03-17 09:04:01','',''),(4060,'1','313','1',1,'Retail Sale Id 4126',7810.00,0.00,0.00,11.00,1155.00,'2023-03-17 09:04:36','',''),(4061,'1','313','1',1,'Retail Sale Id 4127',29480.00,0.00,0.00,44.00,2860.00,'2023-03-17 09:06:41','',''),(4062,'1','313','1',1,'Retail Sale Id 4128',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 09:07:24','',''),(4063,'1','313','1',1,'Retail Sale Id 4129',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 09:08:03','',''),(4064,'1','313','1',1,'Retail Sale Id 4130',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 09:09:35','',''),(4065,'1','313','1',1,'Retail Sale Id 4131',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 09:10:32','',''),(4066,'1','313','1',1,'Retail Sale Id 4132',7100.00,0.00,0.00,10.00,1050.00,'2023-03-17 09:11:40','',''),(4067,'1','313','1',1,'Retail Sale Id 4133',710.00,0.00,0.00,1.00,105.00,'2023-03-17 09:12:15','',''),(4068,'1','313','1',1,'Retail Sale Id 4134',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 09:14:20','',''),(4069,'1','313','1',1,'Retail Sale Id 4135',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 09:15:30','',''),(4070,'1','313','1',1,'Retail Sale Id 4136',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 09:16:22','',''),(4071,'1','313','1',1,'Retail Sale Id 4137',6390.00,0.00,0.00,9.00,945.00,'2023-03-17 09:18:07','',''),(4072,'1','313','1',1,'Retail Sale Id 4138',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 09:18:39','',''),(4073,'1','313','1',1,'Retail Sale Id 4139',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 09:20:08','',''),(4074,'1','313','1',1,'Retail Sale Id 4140',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 09:23:07','',''),(4075,'1','313','1',1,'Retail Sale Id 4141',1775.00,0.00,0.00,2.50,262.50,'2023-03-17 09:26:44','',''),(4076,'1','313','1',1,'Retail Sale Id 4142',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 09:27:41','',''),(4077,'1','313','1',1,'Retail Sale Id 4143',4970.00,0.00,0.00,7.00,735.00,'2023-03-17 09:29:10','',''),(4078,'1','313','1',1,'Retail Sale Id 4144',8520.00,0.00,0.00,12.00,1260.00,'2023-03-17 09:30:47','',''),(4079,'1','313','1',1,'Retail Sale Id 4145',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 09:32:00','',''),(4080,'1','313','1',1,'Retail Sale Id 4146',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 09:33:00','',''),(4081,'1','313','1',1,'Retail Sale Id 4147',717.10,0.00,0.00,1.01,106.05,'2023-03-17 09:34:35','',''),(4082,'1','313','1',1,'Retail Sale Id 4148',8520.00,0.00,0.00,12.00,1260.00,'2023-03-17 09:35:40','',''),(4083,'1','313','1',1,'Retail Sale Id 4149',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 09:36:40','',''),(4084,'1','313','1',1,'Retail Sale Id 4150',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 09:37:35','',''),(4085,'1','313','1',1,'Retail Sale Id 4151',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 09:38:49','',''),(4086,'1','313','1',1,'Retail Sale Id 4152',4970.00,0.00,0.00,7.00,735.00,'2023-03-17 09:39:53','',''),(4087,'1','313','1',1,'Retail Sale Id 4153',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 09:40:56','',''),(4088,'1','313','1',1,'Retail Sale Id 4154',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 09:41:53','',''),(4089,'1','313','1',1,'Retail Sale Id 4155',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 09:43:08','',''),(4090,'1','313','1',1,'Retail Sale Id 4156',1448.40,0.00,0.00,2.04,214.20,'2023-03-17 09:44:24','',''),(4091,'1','313','1',1,'Retail Sale Id 4157',7810.00,0.00,0.00,11.00,1155.00,'2023-03-17 09:45:25','',''),(4092,'1','313','1',1,'Retail Sale Id 4158',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 09:46:13','',''),(4093,'1','313','1',1,'Retail Sale Id 4159',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 09:47:25','',''),(4094,'1','313','1',1,'Retail Sale Id 4160',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 09:49:16','',''),(4095,'1','313','1',1,'Retail Sale Id 4161',1448.40,0.00,0.00,2.04,214.20,'2023-03-17 09:50:28','',''),(4096,'1','313','1',1,'Retail Sale Id 4162',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 09:51:28','',''),(4097,'1','313','1',1,'Retail Sale Id 4163',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 09:53:03','',''),(4098,'1','313','1',1,'Retail Sale Id 4164',7100.00,0.00,0.00,10.00,1050.00,'2023-03-17 09:54:24','',''),(4099,'1','313','1',1,'Retail Sale Id 4165',7100.00,0.00,0.00,10.00,1050.00,'2023-03-17 09:55:41','',''),(4100,'1','313','1',1,'Retail Sale Id 4166',710.00,0.00,0.00,1.00,105.00,'2023-03-17 09:56:55','',''),(4101,'1','313','1',1,'Retail Sale Id 4167',710.00,0.00,0.00,1.00,105.00,'2023-03-17 09:58:41','',''),(4102,'1','313','1',1,'Retail Sale Id 4168',9585.00,0.00,0.00,13.50,1417.50,'2023-03-17 10:00:59','',''),(4103,'1','313','1',1,'Retail Sale Id 4169',752.60,0.00,0.00,1.06,111.30,'2023-03-17 10:03:22','',''),(4104,'1','313','1',1,'Retail Sale Id 4170',40200.00,0.00,0.00,60.00,3900.00,'2023-03-17 10:06:20','',''),(4105,'1','313','1',1,'Retail Sale Id 4171',84533.90,0.00,0.00,126.17,8201.05,'2023-03-17 10:07:23','',''),(4106,'1','313','1',1,'Retail Sale Id 4172',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 10:10:32','',''),(4107,'1','313','1',1,'Retail Sale Id 4173',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 10:11:10','',''),(4108,'1','313','1',1,'Retail Sale Id 4174',408157.30,0.00,0.00,609.19,39597.35,'2023-03-17 10:13:48','',''),(4109,'1','313','1',1,'Retail Sale Id 4175',9585.00,0.00,0.00,13.50,1417.50,'2023-03-17 10:14:35','',''),(4110,'1','313','1',1,'Retail Sale Id 4176',2499.20,0.00,0.00,3.52,369.60,'2023-03-17 10:15:33','',''),(4111,'1','313','1',1,'Retail Sale Id 4178',710.00,0.00,0.00,1.00,105.00,'2023-03-17 10:18:26','',''),(4112,'1','313','1',1,'Retail Sale Id 4179',17750.00,0.00,0.00,25.00,2625.00,'2023-03-17 10:19:18','',''),(4113,'1','313','1',1,'Retail Sale Id 4180',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 10:20:12','',''),(4114,'1','313','1',1,'Retail Sale Id 4181',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 10:21:29','',''),(4115,'1','313','1',1,'Retail Sale Id 4182',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 10:22:17','',''),(4116,'1','313','1',1,'Retail Sale Id 4183',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 10:23:13','',''),(4117,'1','313','1',1,'Retail Sale Id 4184',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 10:24:13','',''),(4118,'1','313','1',1,'Retail Sale Id 4186',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 10:25:06','',''),(4119,'1','313','1',1,'Retail Sale Id 4187',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 10:26:19','',''),(4120,'1','313','1',1,'Retail Sale Id 4188',710.00,0.00,0.00,1.00,105.00,'2023-03-17 10:27:01','',''),(4121,'1','313','1',1,'Retail Sale Id 4189',4970.00,0.00,0.00,7.00,735.00,'2023-03-17 10:28:00','',''),(4122,'1','313','1',1,'Retail Sale Id 4190',710.00,0.00,0.00,1.00,105.00,'2023-03-17 10:29:03','',''),(4123,'1','313','1',1,'Retail Sale Id 4191',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 10:29:49','',''),(4124,'1','313','1',1,'Retail Sale Id 4192',20100.00,0.00,0.00,30.00,1950.00,'2023-03-17 10:31:09','',''),(4125,'1','313','1',1,'Retail Sale Id 4193',7100.00,0.00,0.00,10.00,1050.00,'2023-03-17 10:31:52','',''),(4126,'1','313','1',1,'Retail Sale Id 4194',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 10:32:24','',''),(4127,'1','313','1',1,'Retail Sale Id 4195',5680.00,0.00,0.00,8.00,840.00,'2023-03-17 10:33:32','',''),(4128,'1','313','1',1,'Retail Sale Id 4196',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 10:34:08','',''),(4129,'1','313','1',1,'Retail Sale Id 4197',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 10:34:59','',''),(4130,'1','313','1',1,'Retail Sale Id 4198',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 10:35:31','',''),(4131,'1','313','1',1,'Retail Sale Id 4199',7100.00,0.00,0.00,10.00,1050.00,'2023-03-17 10:36:26','',''),(4132,'1','313','1',1,'Retail Sale Id 4200',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 10:39:34','',''),(4133,'1','313','1',1,'Retail Sale Id 4201',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 10:41:51','',''),(4134,'1','313','1',1,'Retail Sale Id 4202',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 10:43:16','',''),(4135,'1','313','1',1,'Retail Sale Id 4203',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 10:44:53','',''),(4136,'1','313','1',1,'Retail Sale Id 4204',710.00,0.00,0.00,1.00,105.00,'2023-03-17 10:45:51','',''),(4137,'1','313','1',1,'Retail Sale Id 4206',9996.80,0.00,0.00,14.08,1478.40,'2023-03-17 10:47:30','',''),(4138,'1','313','1',1,'Retail Sale Id 4207',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 10:48:10','',''),(4139,'1','313','1',1,'Retail Sale Id 4208',7100.00,0.00,0.00,10.00,1050.00,'2023-03-17 10:48:43','',''),(4140,'1','313','1',1,'Retail Sale Id 4209',752.60,0.00,0.00,1.06,111.30,'2023-03-17 10:49:34','',''),(4141,'1','313','1',1,'Retail Sale Id 4210',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 10:50:15','',''),(4142,'1','313','1',1,'Retail Sale Id 4211',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 10:52:16','',''),(4143,'1','313','1',1,'Retail Sale Id 4212',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 10:57:03','',''),(4144,'1','313','1',1,'Retail Sale Id 4213',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 11:02:54','',''),(4145,'1','313','1',1,'Retail Sale Id 4214',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 11:04:52','',''),(4146,'1','313','1',1,'Retail Sale Id 4215',710.00,0.00,0.00,1.00,105.00,'2023-03-17 11:05:31','',''),(4147,'1','313','1',1,'Retail Sale Id 4216',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 11:06:12','',''),(4148,'1','313','1',1,'Retail Sale Id 4217',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 11:07:20','',''),(4149,'1','313','1',1,'Retail Sale Id 4218',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 11:09:38','',''),(4150,'1','313','1',1,'Retail Sale Id 4219',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 11:10:34','',''),(4151,'1','313','1',1,'Retail Sale Id 4220',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 11:12:31','',''),(4152,'1','313','1',1,'Retail Sale Id 4221',5999.50,0.00,0.00,8.45,887.25,'2023-03-17 11:15:08','',''),(4153,'1','313','1',1,'Retail Sale Id 4222',2499.20,0.00,0.00,3.52,369.60,'2023-03-17 11:17:52','',''),(4154,'1','313','1',1,'Retail Sale Id 4224',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 11:19:51','',''),(4155,'1','313','1',1,'Retail Sale Id 4225',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 11:22:50','',''),(4156,'1','313','1',1,'Retail Sale Id 4226',29480.00,0.00,0.00,44.00,2860.00,'2023-03-17 11:26:44','',''),(4157,'1','313','1',1,'Retail Sale Id 4227',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 11:31:24','',''),(4158,'1','313','1',1,'Retail Sale Id 4228',4970.00,0.00,0.00,7.00,735.00,'2023-03-17 11:34:01','',''),(4159,'1','313','1',1,'Retail Sale Id 4229',710.00,0.00,0.00,1.00,105.00,'2023-03-17 11:35:14','',''),(4160,'1','313','1',1,'Retail Sale Id 4230',710.00,0.00,0.00,1.00,105.00,'2023-03-17 11:37:30','',''),(4161,'1','313','1',1,'Retail Sale Id 4231',8520.00,0.00,0.00,12.00,1260.00,'2023-03-17 11:38:31','',''),(4162,'1','313','1',1,'Retail Sale Id 4232',2598.60,0.00,0.00,3.66,384.30,'2023-03-17 11:40:13','',''),(4163,'1','313','1',1,'Retail Sale Id 4233',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 11:41:12','',''),(4164,'1','313','1',1,'Retail Sale Id 4234',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 11:42:19','',''),(4165,'1','313','1',1,'Retail Sale Id 4235',716.90,0.00,0.00,1.07,69.55,'2023-03-17 11:44:31','',''),(4166,'1','313','1',1,'Retail Sale Id 4236',2151.30,0.00,0.00,3.03,318.15,'2023-03-17 11:45:22','',''),(4167,'1','313','1',1,'Retail Sale Id 4237',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 11:47:53','',''),(4168,'1','313','1',1,'Retail Sale Id 4238',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 11:49:39','',''),(4169,'1','313','1',1,'Retail Sale Id 4239',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 11:50:46','',''),(4170,'1','313','1',1,'Retail Sale Id 4240',710.00,0.00,0.00,1.00,105.00,'2023-03-17 11:52:02','',''),(4171,'1','313','1',1,'Retail Sale Id 4241',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 11:54:09','',''),(4172,'1','313','1',1,'Retail Sale Id 4242',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 11:54:56','',''),(4173,'1','313','1',1,'Retail Sale Id 4243',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 11:55:52','',''),(4174,'1','313','1',1,'Retail Sale Id 4244',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 11:56:54','',''),(4175,'1','313','1',1,'Retail Sale Id 4245',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 11:59:31','',''),(4176,'1','313','1',1,'Retail Sale Id 4246',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 12:00:17','',''),(4177,'1','313','1',1,'Retail Sale Id 4247',1448.40,0.00,0.00,2.04,214.20,'2023-03-17 12:01:06','',''),(4178,'1','313','1',1,'Retail Sale Id 4248',7810.00,0.00,0.00,11.00,1155.00,'2023-03-17 12:02:43','',''),(4179,'1','313','1',1,'Retail Sale Id 4249',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 12:05:09','',''),(4180,'1','313','1',1,'Retail Sale Id 4250',33500.00,0.00,0.00,50.00,3250.00,'2023-03-17 12:06:14','',''),(4181,'1','313','1',1,'Retail Sale Id 4251',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 12:07:36','',''),(4182,'1','313','1',1,'Retail Sale Id 4252',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 12:09:41','',''),(4183,'1','313','1',1,'Retail Sale Id 4253',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 12:10:46','',''),(4184,'1','313','1',1,'Retail Sale Id 4254',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 12:12:33','',''),(4185,'1','313','1',1,'Retail Sale Id 4255',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 12:13:54','',''),(4186,'1','313','1',1,'Retail Sale Id 4256',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 12:15:23','',''),(4187,'1','313','1',1,'Retail Sale Id 4257',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 12:17:04','',''),(4188,'1','313','1',1,'Retail Sale Id 4258',29995.90,0.00,0.00,44.77,2910.05,'2023-03-17 12:19:54','',''),(4189,'1','313','1',1,'Retail Sale Id 4259',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 12:21:19','',''),(4190,'1','313','1',1,'Retail Sale Id 4260',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 12:23:00','',''),(4191,'1','313','1',1,'Retail Sale Id 4261',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 12:23:42','',''),(4192,'1','313','1',1,'Retail Sale Id 4262',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 12:25:12','',''),(4193,'1','313','1',1,'Retail Sale Id 4264',26130.00,0.00,0.00,39.00,2535.00,'2023-03-17 12:31:23','',''),(4194,'1','313','1',1,'Retail Sale Id 4265',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 12:33:45','',''),(4195,'1','313','1',1,'Retail Sale Id 4266',36850.00,0.00,0.00,55.00,3575.00,'2023-03-17 12:35:01','',''),(4196,'1','313','1',1,'Retail Sale Id 4267',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 12:36:10','',''),(4197,'1','313','1',1,'Retail Sale Id 4268',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 12:37:12','',''),(4198,'1','313','1',1,'Retail Sale Id 4269',710.00,0.00,0.00,1.00,105.00,'2023-03-17 12:38:00','',''),(4199,'1','313','1',1,'Retail Sale Id 4270',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 12:38:50','',''),(4200,'1','313','1',1,'Retail Sale Id 4271',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 12:40:00','',''),(4201,'1','313','1',1,'Retail Sale Id 4272',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 12:41:36','',''),(4202,'1','313','1',1,'Retail Sale Id 4273',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 12:42:22','',''),(4203,'1','313','1',1,'Retail Sale Id 4274',1498.10,0.00,0.00,2.11,221.55,'2023-03-17 12:43:18','',''),(4204,'1','313','1',1,'Retail Sale Id 4275',2002.20,0.00,0.00,2.82,296.10,'2023-03-17 12:44:00','',''),(4205,'1','313','1',1,'Retail Sale Id 4276',9940.00,0.00,0.00,14.00,1470.00,'2023-03-17 12:47:58','',''),(4206,'1','313','1',1,'Retail Sale Id 4277',67000.00,0.00,0.00,100.00,6500.00,'2023-03-17 12:50:11','',''),(4207,'1','313','1',1,'Retail Sale Id 4278',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 12:51:58','',''),(4208,'1','313','1',1,'Retail Sale Id 4279',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 12:53:09','',''),(4209,'1','313','1',1,'Retail Sale Id 4280',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 12:55:54','',''),(4210,'1','313','1',1,'Retail Sale Id 4281',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 12:56:47','',''),(4211,'1','313','1',1,'Retail Sale Id 4282',4970.00,0.00,0.00,7.00,735.00,'2023-03-17 12:58:03','',''),(4212,'1','313','1',1,'Retail Sale Id 4283',1597.50,0.00,0.00,2.25,236.25,'2023-03-17 12:59:42','',''),(4213,'1','313','1',1,'Retail Sale Id 4284',4970.00,0.00,0.00,7.00,735.00,'2023-03-17 13:02:08','',''),(4214,'1','313','1',1,'Retail Sale Id 4285',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 13:04:10','',''),(4215,'1','313','1',1,'Retail Sale Id 4286',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 13:05:04','',''),(4216,'1','313','1',1,'Retail Sale Id 4288',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 13:07:40','',''),(4217,'1','313','1',1,'Retail Sale Id 4289',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 13:11:03','',''),(4218,'1','313','1',1,'Retail Sale Id 4290',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 13:11:56','',''),(4219,'1','313','1',1,'Retail Sale Id 4291',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 13:12:54','',''),(4220,'1','313','1',1,'Retail Sale Id 4292',7100.00,0.00,0.00,10.00,1050.00,'2023-03-17 13:15:36','',''),(4221,'1','313','1',1,'Retail Sale Id 4293',710.00,0.00,0.00,1.00,105.00,'2023-03-17 13:16:41','',''),(4222,'1','313','1',1,'Retail Sale Id 4294',7100.00,0.00,0.00,10.00,1050.00,'2023-03-17 13:18:14','',''),(4223,'1','313','1',1,'Retail Sale Id 4296',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 13:19:56','',''),(4224,'1','313','1',1,'Retail Sale Id 4297',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 13:21:06','',''),(4225,'1','313','1',1,'Retail Sale Id 4298',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 13:22:03','',''),(4226,'1','313','1',1,'Retail Sale Id 4299',710.00,0.00,0.00,1.00,105.00,'2023-03-17 13:23:08','',''),(4227,'1','313','1',1,'Retail Sale Id 4300',7810.00,0.00,0.00,11.00,1155.00,'2023-03-17 13:24:42','',''),(4228,'1','313','1',1,'Retail Sale Id 4301',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 13:25:59','',''),(4229,'1','313','1',1,'Retail Sale Id 4302',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 13:27:15','',''),(4230,'1','313','1',1,'Retail Sale Id 4303',36180.00,0.00,0.00,54.00,3510.00,'2023-03-17 13:30:42','',''),(4231,'1','313','1',1,'Retail Sale Id 4304',710.00,0.00,0.00,1.00,105.00,'2023-03-17 13:31:48','',''),(4232,'1','313','1',1,'Retail Sale Id 4306',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 13:33:46','',''),(4233,'1','313','1',1,'Retail Sale Id 4307',1448.40,0.00,0.00,2.04,214.20,'2023-03-17 13:34:59','',''),(4234,'1','313','1',1,'Retail Sale Id 4308',7100.00,0.00,0.00,10.00,1050.00,'2023-03-17 13:35:39','',''),(4235,'1','313','1',1,'Retail Sale Id 4309',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 13:36:37','',''),(4236,'1','313','1',1,'Retail Sale Id 4310',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 13:38:00','',''),(4237,'1','313','1',1,'Retail Sale Id 4311',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 13:38:31','',''),(4238,'1','313','1',1,'Retail Sale Id 4312',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 13:39:37','',''),(4239,'1','313','1',1,'Retail Sale Id 4313',6390.00,0.00,0.00,9.00,945.00,'2023-03-17 13:42:40','',''),(4240,'1','313','1',1,'Retail Sale Id 4314',752.60,0.00,0.00,1.06,111.30,'2023-03-17 13:43:33','',''),(4241,'1','313','1',1,'Retail Sale Id 4315',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 13:44:50','',''),(4242,'1','313','1',1,'Retail Sale Id 4316',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 13:56:24','',''),(4243,'1','313','1',1,'Retail Sale Id 4317',710.00,0.00,0.00,1.00,105.00,'2023-03-17 13:57:23','',''),(4244,'1','313','1',1,'Retail Sale Id 4318',710.00,0.00,0.00,1.00,105.00,'2023-03-17 13:58:09','',''),(4245,'1','313','1',1,'Retail Sale Id 4319',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 14:00:36','',''),(4246,'1','313','1',1,'Retail Sale Id 4320',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 14:01:46','',''),(4247,'1','313','1',1,'Retail Sale Id 4321',2002.20,0.00,0.00,2.82,296.10,'2023-03-17 14:03:58','',''),(4248,'1','313','1',1,'Retail Sale Id 4322',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 14:04:56','',''),(4249,'1','313','1',1,'Retail Sale Id 4323',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 14:05:51','',''),(4250,'1','313','1',1,'Retail Sale Id 4324',2847.10,0.00,0.00,4.01,421.05,'2023-03-17 14:07:11','',''),(4251,'1','313','1',1,'Retail Sale Id 4325',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 14:07:50','',''),(4252,'1','313','1',1,'Retail Sale Id 4326',2151.30,0.00,0.00,3.03,318.15,'2023-03-17 14:08:59','',''),(4253,'1','313','1',1,'Retail Sale Id 4327',1498.10,0.00,0.00,2.11,221.55,'2023-03-17 14:10:31','',''),(4254,'1','313','1',1,'Retail Sale Id 4328',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 14:12:55','',''),(4255,'1','313','1',1,'Retail Sale Id 4329',752.60,0.00,0.00,1.06,111.30,'2023-03-17 14:13:49','',''),(4256,'1','313','1',1,'Retail Sale Id 4330',1498.10,0.00,0.00,2.11,221.55,'2023-03-17 14:17:45','',''),(4257,'1','313','1',1,'Retail Sale Id 4331',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 14:19:34','',''),(4258,'1','313','1',1,'Retail Sale Id 4332',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 14:22:03','',''),(4259,'1','313','1',1,'Retail Sale Id 4333',7100.00,0.00,0.00,10.00,1050.00,'2023-03-17 14:23:55','',''),(4260,'1','313','1',1,'Retail Sale Id 4334',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 14:25:15','',''),(4261,'1','313','1',1,'Retail Sale Id 4335',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 14:26:18','',''),(4262,'1','313','1',1,'Retail Sale Id 4336',3500.30,0.00,0.00,4.93,517.65,'2023-03-17 14:27:41','',''),(4263,'1','313','1',1,'Retail Sale Id 4337',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 14:29:34','',''),(4264,'1','313','1',1,'Retail Sale Id 4338',3997.30,0.00,0.00,5.63,591.15,'2023-03-17 14:31:04','',''),(4265,'1','313','1',1,'Retail Sale Id 4339',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 14:32:06','',''),(4266,'1','313','1',1,'Retail Sale Id 4340',39530.00,0.00,0.00,59.00,3835.00,'2023-03-17 14:35:53','',''),(4267,'1','313','1',1,'Retail Sale Id 4341',1448.40,0.00,0.00,2.04,214.20,'2023-03-17 14:36:43','',''),(4268,'1','313','1',1,'Retail Sale Id 4342',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 14:38:07','',''),(4269,'1','313','1',1,'Retail Sale Id 4343',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 14:39:25','',''),(4270,'1','313','1',1,'Retail Sale Id 4344',710.00,0.00,0.00,1.00,105.00,'2023-03-17 14:40:12','',''),(4271,'1','313','1',1,'Retail Sale Id 4345',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 14:41:12','',''),(4272,'1','313','1',1,'Retail Sale Id 4346',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 14:41:53','',''),(4273,'1','313','1',1,'Retail Sale Id 4347',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 14:42:58','',''),(4274,'1','313','1',1,'Retail Sale Id 4348',9940.00,0.00,0.00,14.00,1470.00,'2023-03-17 14:44:39','',''),(4275,'1','313','1',1,'Retail Sale Id 4349',8520.00,0.00,0.00,12.00,1260.00,'2023-03-17 14:45:36','',''),(4276,'1','313','1',1,'Retail Sale Id 4350',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 14:46:25','',''),(4277,'1','313','1',1,'Retail Sale Id 4351',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 14:47:22','',''),(4278,'1','313','1',1,'Retail Sale Id 4352',7100.00,0.00,0.00,10.00,1050.00,'2023-03-17 14:48:03','',''),(4279,'1','313','1',1,'Retail Sale Id 4353',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 14:49:14','',''),(4280,'1','313','1',1,'Retail Sale Id 4354',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 14:52:03','',''),(4281,'1','313','1',1,'Retail Sale Id 4356',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 14:53:57','',''),(4282,'1','313','1',1,'Retail Sale Id 4358',7100.00,0.00,0.00,10.00,1050.00,'2023-03-17 14:57:34','',''),(4283,'1','313','1',1,'Retail Sale Id 4359',2485.00,0.00,0.00,3.50,367.50,'2023-03-17 15:00:05','',''),(4284,'1','313','1',1,'Retail Sale Id 4360',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 15:02:38','',''),(4285,'1','313','1',1,'Retail Sale Id 4362',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 15:06:57','',''),(4286,'1','313','1',1,'Retail Sale Id 4363',4970.00,0.00,0.00,7.00,735.00,'2023-03-17 15:08:16','',''),(4287,'1','313','1',1,'Retail Sale Id 4364',710.00,0.00,0.00,1.00,105.00,'2023-03-17 15:09:59','',''),(4288,'1','313','1',1,'Retail Sale Id 4366',3003.30,0.00,0.00,4.23,444.15,'2023-03-17 15:11:46','',''),(4289,'1','313','1',1,'Retail Sale Id 4367',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 15:13:07','',''),(4290,'1','313','1',1,'Retail Sale Id 4368',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 15:13:58','',''),(4291,'1','313','1',1,'Retail Sale Id 4369',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 15:14:59','',''),(4292,'1','313','1',1,'Retail Sale Id 4370',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 15:15:54','',''),(4293,'1','313','1',1,'Retail Sale Id 4372',40200.00,0.00,0.00,60.00,3900.00,'2023-03-17 15:19:02','',''),(4294,'1','313','1',1,'Retail Sale Id 4373',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 15:19:55','',''),(4295,'1','313','1',1,'Retail Sale Id 4374',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 15:20:35','',''),(4296,'1','313','1',1,'Retail Sale Id 4375',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 15:21:13','',''),(4297,'1','313','1',1,'Retail Sale Id 4377',1100.50,0.00,0.00,1.55,162.75,'2023-03-17 15:23:12','',''),(4298,'1','313','1',1,'Retail Sale Id 4378',710.00,0.00,0.00,1.00,105.00,'2023-03-17 15:23:58','',''),(4299,'1','313','1',1,'Retail Sale Id 4379',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 15:24:37','',''),(4300,'1','313','1',1,'Retail Sale Id 4380',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 15:25:22','',''),(4301,'1','313','1',1,'Retail Sale Id 4381',7100.00,0.00,0.00,10.00,1050.00,'2023-03-17 15:28:08','',''),(4302,'1','313','1',1,'Retail Sale Id 4382',4970.00,0.00,0.00,7.00,735.00,'2023-03-17 15:28:59','',''),(4303,'1','313','1',1,'Retail Sale Id 4383',7810.00,0.00,0.00,11.00,1155.00,'2023-03-17 15:30:36','',''),(4304,'1','313','1',1,'Retail Sale Id 4384',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 15:34:56','',''),(4305,'1','313','1',1,'Retail Sale Id 4385',752.60,0.00,0.00,1.06,111.30,'2023-03-17 15:38:35','',''),(4306,'1','313','1',1,'Retail Sale Id 4386',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 15:39:08','',''),(4307,'1','313','1',1,'Retail Sale Id 4387',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 15:40:18','',''),(4308,'1','313','1',1,'Retail Sale Id 4388',710.00,0.00,0.00,1.00,105.00,'2023-03-17 15:42:57','',''),(4309,'1','313','1',1,'Retail Sale Id 4389',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 15:44:08','',''),(4310,'1','313','1',1,'Retail Sale Id 4390',7810.00,0.00,0.00,11.00,1155.00,'2023-03-17 15:45:49','',''),(4311,'1','313','1',1,'Retail Sale Id 4391',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 15:46:28','',''),(4312,'1','313','1',1,'Retail Sale Id 4392',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 15:47:02','',''),(4313,'1','313','1',1,'Retail Sale Id 4393',3003.30,0.00,0.00,4.23,444.15,'2023-03-17 15:47:54','',''),(4314,'1','313','1',1,'Retail Sale Id 4394',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 15:48:39','',''),(4315,'1','313','1',1,'Retail Sale Id 4395',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 15:49:55','',''),(4316,'1','313','1',1,'Retail Sale Id 4396',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 15:50:32','',''),(4317,'1','313','1',1,'Retail Sale Id 4397',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 15:51:33','',''),(4318,'1','313','1',1,'Retail Sale Id 4398',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 15:52:41','',''),(4319,'1','313','1',1,'Retail Sale Id 4399',40200.00,0.00,0.00,60.00,3900.00,'2023-03-17 15:53:32','',''),(4320,'1','313','1',1,'Retail Sale Id 4400',1448.40,0.00,0.00,2.04,214.20,'2023-03-17 15:54:38','',''),(4321,'1','313','1',1,'Retail Sale Id 4401',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 15:55:25','',''),(4322,'1','313','1',1,'Retail Sale Id 4402',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 15:56:22','',''),(4323,'1','313','1',1,'Retail Sale Id 4403',4970.00,0.00,0.00,7.00,735.00,'2023-03-17 15:57:10','',''),(4324,'1','313','1',1,'Retail Sale Id 4404',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 15:58:03','',''),(4325,'1','313','1',1,'Retail Sale Id 4405',21299.30,0.00,0.00,31.79,2066.35,'2023-03-17 15:59:17','',''),(4326,'1','313','1',1,'Retail Sale Id 4406',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 16:00:19','',''),(4327,'1','313','1',1,'Retail Sale Id 4407',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 16:01:10','',''),(4328,'1','313','1',1,'Retail Sale Id 4408',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 16:02:06','',''),(4329,'1','313','1',1,'Retail Sale Id 4409',4998.40,0.00,0.00,7.04,739.20,'2023-03-17 16:03:09','',''),(4330,'1','313','1',1,'Retail Sale Id 4410',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 16:04:13','',''),(4331,'1','313','1',1,'Retail Sale Id 4411',710.00,0.00,0.00,1.00,105.00,'2023-03-17 16:05:33','',''),(4332,'1','313','1',1,'Retail Sale Id 4412',752.60,0.00,0.00,1.06,111.30,'2023-03-17 16:06:49','',''),(4333,'1','313','1',1,'Retail Sale Id 4413',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 16:07:27','',''),(4334,'1','313','1',1,'Retail Sale Id 4414',67000.00,0.00,0.00,100.00,6500.00,'2023-03-17 16:08:45','',''),(4335,'1','313','1',1,'Retail Sale Id 4415',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 16:09:23','',''),(4336,'1','313','1',1,'Retail Sale Id 4416',710.00,0.00,0.00,1.00,105.00,'2023-03-17 16:09:56','',''),(4337,'1','313','1',1,'Retail Sale Id 4417',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 16:10:38','',''),(4338,'1','313','1',1,'Retail Sale Id 4418',14200.00,0.00,0.00,20.00,2100.00,'2023-03-17 16:11:57','',''),(4339,'1','313','1',1,'Retail Sale Id 4419',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 16:12:41','',''),(4340,'1','313','1',1,'Retail Sale Id 4420',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 16:13:33','',''),(4341,'1','313','1',1,'Retail Sale Id 4421',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 16:14:33','',''),(4342,'1','313','1',1,'Retail Sale Id 4422',710.00,0.00,0.00,1.00,105.00,'2023-03-17 16:15:31','',''),(4343,'1','313','1',1,'Retail Sale Id 4423',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 16:16:20','',''),(4344,'1','313','1',1,'Retail Sale Id 4425',752.60,0.00,0.00,1.06,111.30,'2023-03-17 16:18:19','',''),(4345,'1','313','1',1,'Retail Sale Id 4426',7100.00,0.00,0.00,10.00,1050.00,'2023-03-17 16:18:52','',''),(4346,'1','313','1',1,'Retail Sale Id 4427',710.00,0.00,0.00,1.00,105.00,'2023-03-17 16:19:36','',''),(4347,'1','313','1',1,'Retail Sale Id 4428',4970.00,0.00,0.00,7.00,735.00,'2023-03-17 16:20:16','',''),(4348,'1','313','1',1,'Retail Sale Id 4429',710.00,0.00,0.00,1.00,105.00,'2023-03-17 16:21:01','',''),(4349,'1','313','1',1,'Retail Sale Id 4430',24790.00,0.00,0.00,37.00,2405.00,'2023-03-17 16:23:03','',''),(4350,'1','313','1',1,'Retail Sale Id 4431',710.00,0.00,0.00,1.00,105.00,'2023-03-17 16:24:25','',''),(4351,'1','313','1',1,'Retail Sale Id 4432',7100.00,0.00,0.00,10.00,1050.00,'2023-03-17 16:25:37','',''),(4352,'1','313','1',1,'Retail Sale Id 4433',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 16:26:59','',''),(4353,'1','313','1',1,'Retail Sale Id 4434',7810.00,0.00,0.00,11.00,1155.00,'2023-03-17 16:27:57','',''),(4354,'1','313','1',1,'Retail Sale Id 4435',5680.00,0.00,0.00,8.00,840.00,'2023-03-17 16:28:39','',''),(4355,'1','313','1',1,'Retail Sale Id 4436',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 16:29:25','',''),(4356,'1','313','1',1,'Retail Sale Id 4437',710.00,0.00,0.00,1.00,105.00,'2023-03-17 16:30:07','',''),(4357,'1','313','1',1,'Retail Sale Id 4438',4970.00,0.00,0.00,7.00,735.00,'2023-03-17 16:31:53','',''),(4358,'1','313','1',1,'Retail Sale Id 4439',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 16:32:37','',''),(4359,'1','313','1',1,'Retail Sale Id 4440',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 16:33:21','',''),(4360,'1','313','1',1,'Retail Sale Id 4441',4970.00,0.00,0.00,7.00,735.00,'2023-03-17 16:34:14','',''),(4361,'1','313','1',1,'Retail Sale Id 4442',710.00,0.00,0.00,1.00,105.00,'2023-03-17 16:34:58','',''),(4362,'1','313','1',1,'Retail Sale Id 4443',40200.00,0.00,0.00,60.00,3900.00,'2023-03-17 16:35:56','',''),(4363,'1','313','1',1,'Retail Sale Id 4444',5680.00,0.00,0.00,8.00,840.00,'2023-03-17 16:36:42','',''),(4364,'1','313','1',1,'Retail Sale Id 4445',752.60,0.00,0.00,1.06,111.30,'2023-03-17 16:37:35','',''),(4365,'1','313','1',1,'Retail Sale Id 4446',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 16:38:27','',''),(4366,'1','313','1',1,'Retail Sale Id 4447',1448.40,0.00,0.00,2.04,214.20,'2023-03-17 16:40:19','',''),(4367,'1','313','1',1,'Retail Sale Id 4448',9230.00,0.00,0.00,13.00,1365.00,'2023-03-17 16:41:10','',''),(4368,'1','313','1',1,'Retail Sale Id 4449',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 16:41:55','',''),(4369,'1','313','1',1,'Retail Sale Id 4450',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 16:42:57','',''),(4370,'1','313','1',1,'Retail Sale Id 4451',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 16:43:55','',''),(4371,'1','313','1',1,'Retail Sale Id 4453',33500.00,0.00,0.00,50.00,3250.00,'2023-03-17 16:45:13','',''),(4372,'1','313','1',1,'Retail Sale Id 4454',5680.00,0.00,0.00,8.00,840.00,'2023-03-17 16:45:56','',''),(4373,'1','313','1',1,'Retail Sale Id 4455',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 16:46:54','',''),(4374,'1','313','1',1,'Retail Sale Id 4456',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 16:48:04','',''),(4375,'1','313','1',1,'Retail Sale Id 4457',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 16:48:45','',''),(4376,'1','313','1',1,'Retail Sale Id 4458',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 16:49:30','',''),(4377,'1','313','1',1,'Retail Sale Id 4459',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 16:50:17','',''),(4378,'1','313','1',1,'Retail Sale Id 4460',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 16:51:09','',''),(4379,'1','313','1',1,'Retail Sale Id 4461',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 16:51:39','',''),(4380,'1','313','1',1,'Retail Sale Id 4462',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 16:52:24','',''),(4381,'1','313','1',1,'Retail Sale Id 4463',8875.00,0.00,0.00,12.50,1312.50,'2023-03-17 16:53:06','',''),(4382,'1','313','1',1,'Retail Sale Id 4464',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 16:54:16','',''),(4383,'1','313','1',1,'Retail Sale Id 4465',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 16:54:56','',''),(4384,'1','313','1',1,'Retail Sale Id 4466',7810.00,0.00,0.00,11.00,1155.00,'2023-03-17 16:56:00','',''),(4385,'1','313','1',1,'Retail Sale Id 4467',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 16:56:42','',''),(4386,'1','313','1',1,'Retail Sale Id 4468',4970.00,0.00,0.00,7.00,735.00,'2023-03-17 16:57:18','',''),(4387,'1','313','1',1,'Retail Sale Id 4469',710.00,0.00,0.00,1.00,105.00,'2023-03-17 16:57:57','',''),(4388,'1','313','1',1,'Retail Sale Id 4470',2002.20,0.00,0.00,2.82,296.10,'2023-03-17 16:58:39','',''),(4389,'1','313','1',1,'Retail Sale Id 4471',710.00,0.00,0.00,1.00,105.00,'2023-03-17 16:59:13','',''),(4390,'1','313','1',1,'Retail Sale Id 4472',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 17:00:38','',''),(4391,'1','313','1',1,'Retail Sale Id 4473',1448.40,0.00,0.00,2.04,214.20,'2023-03-17 17:01:24','',''),(4392,'1','313','1',1,'Retail Sale Id 4474',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 17:02:01','',''),(4393,'1','313','1',1,'Retail Sale Id 4475',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 17:02:47','',''),(4394,'1','313','1',1,'Retail Sale Id 4476',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 17:03:20','',''),(4395,'1','313','1',1,'Retail Sale Id 4477',7100.00,0.00,0.00,10.00,1050.00,'2023-03-17 17:04:06','',''),(4396,'1','313','1',1,'Retail Sale Id 4478',3003.30,0.00,0.00,4.23,444.15,'2023-03-17 17:04:45','',''),(4397,'1','313','1',1,'Return of Retail Sale Id 4478',0.00,3003.30,4.23,0.00,-444.15,'2023-03-17 17:05:24','',''),(4398,'1','313','1',1,'Retail Sale Id 4479',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 17:05:52','',''),(4399,'1','313','1',1,'Retail Sale Id 4480',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 17:06:30','',''),(4400,'1','313','1',1,'Retail Sale Id 4481',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 17:07:06','',''),(4401,'1','313','1',1,'Retail Sale Id 4482',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 17:07:48','',''),(4402,'1','313','1',1,'Retail Sale Id 4483',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 17:08:27','',''),(4403,'1','313','1',1,'Retail Sale Id 4484',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 17:09:08','',''),(4404,'1','313','1',1,'Retail Sale Id 4485',710.00,0.00,0.00,1.00,105.00,'2023-03-17 17:09:47','',''),(4405,'1','313','1',1,'Retail Sale Id 4486',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 17:10:35','',''),(4406,'1','313','1',1,'Retail Sale Id 4487',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 17:11:24','',''),(4407,'1','313','1',1,'Retail Sale Id 4488',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 17:12:00','',''),(4408,'1','313','1',1,'Retail Sale Id 4490',15818.80,0.00,0.00,22.28,2339.40,'2023-03-17 17:13:28','',''),(4409,'1','313','1',1,'Return of Retail Sale Id 4490',0.00,15818.80,22.28,0.00,-2339.40,'2023-03-17 17:13:51','',''),(4410,'1','313','1',1,'Retail Sale Id 4491',15975.00,0.00,0.00,22.50,2362.50,'2023-03-17 17:14:17','',''),(4411,'1','313','1',1,'Return of Retail Sale Id 4491',0.00,15975.00,22.50,0.00,-2362.50,'2023-03-17 17:15:00','',''),(4412,'1','313','1',1,'Retail Sale Id 4492',15620.00,0.00,0.00,22.00,2310.00,'2023-03-17 17:16:00','',''),(4413,'1','313','1',1,'Retail Sale Id 4493',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 17:17:00','',''),(4414,'1','313','1',1,'Retail Sale Id 4494',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 17:18:02','',''),(4415,'1','313','1',1,'Retail Sale Id 4495',2840.00,0.00,0.00,4.00,420.00,'2023-03-17 17:19:11','',''),(4416,'1','313','1',1,'Retail Sale Id 4496',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 17:20:02','',''),(4417,'1','313','1',1,'Retail Sale Id 4497',752.60,0.00,0.00,1.06,111.30,'2023-03-17 17:21:20','',''),(4418,'1','313','1',1,'Retail Sale Id 4498',1001.10,0.00,0.00,1.41,148.05,'2023-03-17 17:23:16','',''),(4419,'1','313','1',1,'Retail Sale Id 4499',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 17:24:57','',''),(4420,'1','313','1',1,'Retail Sale Id 4500',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 17:25:55','',''),(4421,'1','313','1',1,'Retail Sale Id 4501',3550.00,0.00,0.00,5.00,525.00,'2023-03-17 17:26:41','',''),(4422,'1','313','1',1,'Retail Sale Id 4502',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 17:27:40','',''),(4423,'1','313','1',1,'Retail Sale Id 4503',11323.00,0.00,0.00,16.90,1098.50,'2023-03-17 17:28:32','',''),(4424,'1','313','1',1,'Retail Sale Id 4504',4998.40,0.00,0.00,7.04,739.20,'2023-03-17 17:29:32','',''),(4425,'1','313','1',1,'Retail Sale Id 4505',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 17:32:51','',''),(4426,'1','313','1',1,'Retail Sale Id 4506',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 17:33:48','',''),(4427,'1','313','1',1,'Retail Sale Id 4507',2002.20,0.00,0.00,2.82,296.10,'2023-03-17 17:34:44','',''),(4428,'1','313','1',1,'Retail Sale Id 4508',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 17:35:52','',''),(4429,'1','313','1',1,'Retail Sale Id 4509',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 17:36:44','',''),(4430,'1','313','1',1,'Retail Sale Id 4510',4260.00,0.00,0.00,6.00,630.00,'2023-03-17 17:37:51','',''),(4431,'1','313','1',1,'Retail Sale Id 4511',710.00,0.00,0.00,1.00,105.00,'2023-03-17 17:38:45','',''),(4432,'1','313','1',1,'Retail Sale Id 4512',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 17:39:46','',''),(4433,'1','313','1',1,'Retail Sale Id 4513',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 17:40:41','',''),(4434,'1','313','1',1,'Retail Sale Id 4514',4970.00,0.00,0.00,7.00,735.00,'2023-03-17 17:42:03','',''),(4435,'1','313','1',1,'Retail Sale Id 4515',1420.00,0.00,0.00,2.00,210.00,'2023-03-17 17:44:24','',''),(4436,'1','313','1',1,'Retail Sale Id 4516',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 17:48:59','',''),(4437,'1','313','1',1,'Retail Sale Id 4517',20590.00,0.00,0.00,29.00,3045.00,'2023-03-17 17:51:16','',''),(4438,'1','313','1',1,'Return of Retail Sale Id 4168',0.00,9585.00,13.50,0.00,-1417.50,'2023-03-17 17:52:53','',''),(4439,'1','313','1',1,'Return of Retail Sale Id 4283',0.00,1597.50,2.25,0.00,-236.25,'2023-03-17 17:54:30','',''),(4440,'1','313','1',1,'Retail Sale Id 4518',2130.00,0.00,0.00,3.00,315.00,'2023-03-17 17:56:47','',''),(4441,'1','313','1',1,'Return of Retail Sale Id 4492',0.00,15620.00,22.00,0.00,-2310.00,'2023-03-17 18:17:30','',''),(4442,'1','313','1',1,'Return of Retail Sale Id 4463',0.00,8875.00,12.50,0.00,-1312.50,'2023-03-17 18:18:40','',''),(4443,'1','313','1',1,'Return of Retail Sale Id 4383',0.00,7810.00,11.00,0.00,-1155.00,'2023-03-17 18:21:09','',''),(4444,'1','313','1',1,'Return of Retail Sale Id 4367',0.00,2130.00,3.00,0.00,-315.00,'2023-03-17 18:22:36','',''),(4445,'1','313','1',1,'Retail Sale Id 4519',1185.70,0.00,0.00,1.67,175.35,'2023-03-17 18:23:22','',''),(4446,'1','313','1',1,'Retail Sale Id 4520',30150.00,0.00,0.00,45.00,2925.00,'2023-03-17 18:26:11','',''),(4447,'1','313','1',1,'Return of Retail Sale Id 4405',0.00,21299.30,31.79,0.00,-2066.35,'2023-03-17 18:29:30','',''),(4448,'1','313','1',1,'Retail Sale Id 4521',21105.00,0.00,0.00,31.50,2047.50,'2023-03-17 18:30:20','',''),(4449,'1','313','1',1,'Retail Sale Id 4522',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 08:07:28','',''),(4450,'1','313','1',1,'Retail Sale Id 4523',110550.00,0.00,0.00,165.00,10725.00,'2023-03-20 08:08:44','',''),(4451,'1','313','1',1,'Retail Sale Id 4524',36850.00,0.00,0.00,55.00,3575.00,'2023-03-20 08:11:28','',''),(4452,'1','313','1',1,'Retail Sale Id 4525',1050.80,0.00,0.00,1.48,155.40,'2023-03-20 08:12:24','',''),(4453,'1','313','1',1,'Retail Sale Id 4526',40200.00,0.00,0.00,60.00,3900.00,'2023-03-20 08:13:14','',''),(4454,'1','313','1',1,'Retail Sale Id 4527',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 08:14:35','',''),(4455,'1','313','1',1,'Retail Sale Id 4528',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 11:47:20','',''),(4456,'1','313','1',1,'Retail Sale Id 4529',3550.00,0.00,0.00,5.00,525.00,'2023-03-20 11:48:04','',''),(4457,'1','313','1',1,'Retail Sale Id 4530',4970.00,0.00,0.00,7.00,735.00,'2023-03-20 11:49:00','',''),(4458,'1','313','1',1,'Retail Sale Id 4531',10650.00,0.00,0.00,15.00,1575.00,'2023-03-20 11:51:01','',''),(4459,'1','313','1',1,'Retail Sale Id 4532',4970.00,0.00,0.00,7.00,735.00,'2023-03-20 11:52:48','',''),(4460,'1','313','1',1,'Retail Sale Id 4533',3550.00,0.00,0.00,5.00,525.00,'2023-03-20 11:53:39','',''),(4461,'1','313','1',1,'Retail Sale Id 4534',4970.00,0.00,0.00,7.00,735.00,'2023-03-20 11:54:31','',''),(4462,'1','313','1',1,'Retail Sale Id 4535',3550.00,0.00,0.00,5.00,525.00,'2023-03-20 11:56:46','',''),(4463,'1','313','1',1,'Retail Sale Id 4536',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 11:59:19','',''),(4464,'1','313','1',1,'Retail Sale Id 4537',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 12:00:25','',''),(4465,'1','313','1',1,'Retail Sale Id 4538',517930.10,0.00,0.00,773.03,50246.95,'2023-03-20 12:01:28','',''),(4466,'1','313','1',1,'Retail Sale Id 4539',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 12:02:31','',''),(4467,'1','313','1',1,'Retail Sale Id 4541',5701.30,0.00,0.00,8.03,843.15,'2023-03-20 12:05:03','',''),(4468,'1','313','1',1,'Retail Sale Id 4542',4970.00,0.00,0.00,7.00,735.00,'2023-03-20 12:07:01','',''),(4469,'1','313','1',1,'Retail Sale Id 4543',4970.00,0.00,0.00,7.00,735.00,'2023-03-20 12:08:52','',''),(4470,'1','313','1',1,'Retail Sale Id 4544',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 12:11:20','',''),(4471,'1','313','1',1,'Retail Sale Id 4545',215350.10,0.00,0.00,303.31,31847.55,'2023-03-20 12:12:07','',''),(4472,'1','313','1',1,'Retail Sale Id 4546',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 12:13:10','',''),(4473,'1','313','1',1,'Retail Sale Id 4547',2840.00,0.00,0.00,4.00,420.00,'2023-03-20 12:13:56','',''),(4474,'1','313','1',1,'Retail Sale Id 4548',3550.00,0.00,0.00,5.00,525.00,'2023-03-20 12:14:43','',''),(4475,'1','313','1',1,'Retail Sale Id 4549',5232.70,0.00,0.00,7.37,773.85,'2023-03-20 12:16:20','',''),(4476,'1','313','1',1,'Return of Retail Sale Id 4541',0.00,5701.30,8.03,0.00,-843.15,'2023-03-20 12:16:58','',''),(4477,'1','313','1',1,'Retail Sale Id 4550',4260.00,0.00,0.00,6.00,630.00,'2023-03-20 12:18:24','',''),(4478,'1','313','1',1,'Retail Sale Id 4551',2840.00,0.00,0.00,4.00,420.00,'2023-03-20 12:19:45','',''),(4479,'1','313','1',1,'Retail Sale Id 4552',67000.00,0.00,0.00,100.00,6500.00,'2023-03-20 12:20:43','',''),(4480,'1','313','1',1,'Retail Sale Id 4553',4970.00,0.00,0.00,7.00,735.00,'2023-03-20 12:21:31','',''),(4481,'1','313','1',1,'Retail Sale Id 4554',8875.00,0.00,0.00,12.50,1312.50,'2023-03-20 12:22:30','',''),(4482,'1','313','1',1,'Retail Sale Id 4555',4970.00,0.00,0.00,7.00,735.00,'2023-03-20 12:23:23','',''),(4483,'1','313','1',1,'Retail Sale Id 4556',2840.00,0.00,0.00,4.00,420.00,'2023-03-20 12:25:06','',''),(4484,'1','313','1',1,'Retail Sale Id 4557',4970.00,0.00,0.00,7.00,735.00,'2023-03-20 12:26:06','',''),(4485,'1','313','1',1,'Retail Sale Id 4559',5680.00,0.00,0.00,8.00,840.00,'2023-03-20 12:27:39','',''),(4486,'1','313','1',1,'Retail Sale Id 4561',7100.00,0.00,0.00,10.00,1050.00,'2023-03-20 12:32:05','',''),(4487,'1','313','1',1,'Retail Sale Id 4562',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 12:34:14','',''),(4488,'1','313','1',1,'Retail Sale Id 4564',2840.00,0.00,0.00,4.00,420.00,'2023-03-20 12:39:10','',''),(4489,'1','313','1',1,'Retail Sale Id 4565',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 12:41:02','',''),(4490,'1','313','1',1,'Retail Sale Id 4566',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 12:41:57','',''),(4491,'1','313','1',1,'Retail Sale Id 4567',230011.60,0.00,0.00,323.96,34015.80,'2023-03-20 12:42:43','',''),(4492,'1','313','1',1,'Retail Sale Id 4568',710.00,0.00,0.00,1.00,105.00,'2023-03-20 12:43:53','',''),(4493,'1','313','1',1,'Retail Sale Id 4569',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 12:44:52','',''),(4494,'1','313','1',1,'Retail Sale Id 4570',4970.00,0.00,0.00,7.00,735.00,'2023-03-20 12:46:02','',''),(4495,'1','313','1',1,'Retail Sale Id 4571',710.00,0.00,0.00,1.00,105.00,'2023-03-20 12:49:27','',''),(4496,'1','313','1',1,'Retail Sale Id 4572',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 12:51:39','',''),(4497,'1','313','1',1,'Retail Sale Id 4573',2840.00,0.00,0.00,4.00,420.00,'2023-03-20 12:55:23','',''),(4498,'1','313','1',1,'Retail Sale Id 4574',33500.00,0.00,0.00,50.00,3250.00,'2023-03-20 12:57:23','',''),(4499,'1','313','1',1,'Retail Sale Id 4575',710.00,0.00,0.00,1.00,105.00,'2023-03-20 12:58:13','',''),(4500,'1','313','1',1,'Retail Sale Id 4576',710.00,0.00,0.00,1.00,105.00,'2023-03-20 12:59:16','',''),(4501,'1','313','1',1,'Retail Sale Id 4577',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 13:00:10','',''),(4502,'1','313','1',1,'Retail Sale Id 4578',3550.00,0.00,0.00,5.00,525.00,'2023-03-20 13:01:16','',''),(4503,'1','313','1',1,'Retail Sale Id 4579',3550.00,0.00,0.00,5.00,525.00,'2023-03-20 13:05:16','',''),(4504,'1','313','1',1,'Retail Sale Id 4580',1001.10,0.00,0.00,1.41,148.05,'2023-03-20 13:06:00','',''),(4505,'1','313','1',1,'Retail Sale Id 4581',1001.10,0.00,0.00,1.41,148.05,'2023-03-20 13:06:37','',''),(4506,'1','313','1',1,'Retail Sale Id 4582',2840.00,0.00,0.00,4.00,420.00,'2023-03-20 13:08:29','',''),(4507,'1','313','1',1,'Retail Sale Id 4583',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 13:09:35','',''),(4508,'1','313','1',1,'Retail Sale Id 4584',4970.00,0.00,0.00,7.00,735.00,'2023-03-20 13:11:52','',''),(4509,'1','313','1',1,'Retail Sale Id 4585',4260.00,0.00,0.00,6.00,630.00,'2023-03-20 13:13:29','',''),(4510,'1','313','1',1,'Retail Sale Id 4586',3550.00,0.00,0.00,5.00,525.00,'2023-03-20 13:18:57','',''),(4511,'1','313','1',1,'Retail Sale Id 4587',81070.00,0.00,0.00,121.00,7865.00,'2023-03-20 13:20:21','',''),(4512,'1','313','1',1,'Retail Sale Id 4588',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 13:23:17','',''),(4513,'1','313','1',1,'Retail Sale Id 4589',1001.10,0.00,0.00,1.41,148.05,'2023-03-20 13:25:09','',''),(4514,'1','313','1',1,'Retail Sale Id 4590',80400.00,0.00,0.00,120.00,7800.00,'2023-03-20 13:25:54','',''),(4515,'1','313','1',1,'Retail Sale Id 4591',9940.00,0.00,0.00,14.00,1470.00,'2023-03-20 13:26:50','',''),(4516,'1','313','1',1,'Retail Sale Id 4592',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 13:27:22','',''),(4517,'1','313','1',1,'Retail Sale Id 4593',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 13:28:19','',''),(4518,'1','313','1',1,'Retail Sale Id 4594',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 13:30:22','',''),(4519,'1','313','1',1,'Retail Sale Id 4595',1001.10,0.00,0.00,1.41,148.05,'2023-03-20 13:31:12','',''),(4520,'1','313','1',1,'Retail Sale Id 4596',2151.30,0.00,0.00,3.03,318.15,'2023-03-20 13:35:08','',''),(4521,'1','313','1',1,'Retail Sale Id 4597',710.00,0.00,0.00,1.00,105.00,'2023-03-20 13:36:12','',''),(4522,'1','313','1',1,'Retail Sale Id 4598',5680.00,0.00,0.00,8.00,840.00,'2023-03-20 13:37:31','',''),(4523,'1','313','1',1,'Retail Sale Id 4600',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 13:49:15','',''),(4524,'1','313','1',1,'Retail Sale Id 4601',8520.00,0.00,0.00,12.00,1260.00,'2023-03-20 13:50:08','',''),(4525,'1','313','1',1,'Retail Sale Id 4602',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 13:50:55','',''),(4526,'1','313','1',1,'Retail Sale Id 4603',710.00,0.00,0.00,1.00,105.00,'2023-03-20 13:51:33','',''),(4527,'1','313','1',1,'Retail Sale Id 4604',3550.00,0.00,0.00,5.00,525.00,'2023-03-20 13:52:29','',''),(4528,'1','313','1',1,'Retail Sale Id 4605',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 13:53:38','',''),(4529,'1','313','1',1,'Retail Sale Id 4607',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 13:56:41','',''),(4530,'1','313','1',1,'Retail Sale Id 4608',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 13:57:40','',''),(4531,'1','313','1',1,'Retail Sale Id 4609',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 13:58:31','',''),(4532,'1','313','1',1,'Retail Sale Id 4610',13400.00,0.00,0.00,20.00,1300.00,'2023-03-20 14:00:24','',''),(4533,'1','313','1',1,'Retail Sale Id 4612',4260.00,0.00,0.00,6.00,630.00,'2023-03-20 14:02:02','',''),(4534,'1','313','1',1,'Retail Sale Id 4613',9940.00,0.00,0.00,14.00,1470.00,'2023-03-20 14:03:24','',''),(4535,'1','313','1',1,'Retail Sale Id 4614',79060.00,0.00,0.00,118.00,7670.00,'2023-03-20 14:06:17','',''),(4536,'1','313','1',1,'Retail Sale Id 4615',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 14:07:32','',''),(4537,'1','313','1',1,'Retail Sale Id 4616',3550.00,0.00,0.00,5.00,525.00,'2023-03-20 14:08:51','',''),(4538,'1','313','1',1,'Retail Sale Id 4617',33500.00,0.00,0.00,50.00,3250.00,'2023-03-20 14:10:29','',''),(4539,'1','313','1',1,'Retail Sale Id 4618',2499.20,0.00,0.00,3.52,369.60,'2023-03-20 14:11:34','',''),(4540,'1','313','1',1,'Retail Sale Id 4619',3550.00,0.00,0.00,5.00,525.00,'2023-03-20 14:12:38','',''),(4541,'1','313','1',1,'Retail Sale Id 4620',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 14:13:49','',''),(4542,'1','313','1',1,'Retail Sale Id 4621',1001.10,0.00,0.00,1.41,148.05,'2023-03-20 14:15:09','',''),(4543,'1','313','1',1,'Retail Sale Id 4622',4970.00,0.00,0.00,7.00,735.00,'2023-03-20 14:16:32','',''),(4544,'1','313','1',1,'Retail Sale Id 4623',2840.00,0.00,0.00,4.00,420.00,'2023-03-20 14:17:42','',''),(4545,'1','313','1',1,'Retail Sale Id 4624',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 14:19:03','',''),(4546,'1','313','1',1,'Retail Sale Id 4625',32830.00,0.00,0.00,49.00,3185.00,'2023-03-20 14:24:22','',''),(4547,'1','313','1',1,'Retail Sale Id 4626',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 14:25:03','',''),(4548,'1','313','1',1,'Retail Sale Id 4627',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 14:26:00','',''),(4549,'1','313','1',1,'Retail Sale Id 4628',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 14:26:38','',''),(4550,'1','313','1',1,'Retail Sale Id 4629',4970.00,0.00,0.00,7.00,735.00,'2023-03-20 14:28:33','',''),(4551,'1','313','1',1,'Retail Sale Id 4630',1001.10,0.00,0.00,1.41,148.05,'2023-03-20 14:29:46','',''),(4552,'1','313','1',1,'Retail Sale Id 4631',710.00,0.00,0.00,1.00,105.00,'2023-03-20 14:32:33','',''),(4553,'1','313','1',1,'Retail Sale Id 4632',752.60,0.00,0.00,1.06,111.30,'2023-03-20 14:34:14','',''),(4554,'1','313','1',1,'Retail Sale Id 4633',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 14:35:17','',''),(4555,'1','313','1',1,'Retail Sale Id 4634',3550.00,0.00,0.00,5.00,525.00,'2023-03-20 14:36:18','',''),(4556,'1','313','1',1,'Retail Sale Id 4635',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 14:37:30','',''),(4557,'1','313','1',1,'Retail Sale Id 4637',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 14:38:56','',''),(4558,'1','313','1',1,'Retail Sale Id 4639',4260.00,0.00,0.00,6.00,630.00,'2023-03-20 14:39:48','',''),(4559,'1','313','1',1,'Retail Sale Id 4640',1001.10,0.00,0.00,1.41,148.05,'2023-03-20 14:40:42','',''),(4560,'1','313','1',1,'Retail Sale Id 4641',4260.00,0.00,0.00,6.00,630.00,'2023-03-20 14:42:02','',''),(4561,'1','313','1',1,'Retail Sale Id 4642',752.60,0.00,0.00,1.06,111.30,'2023-03-20 14:45:29','',''),(4562,'1','313','1',1,'Retail Sale Id 4643',4260.00,0.00,0.00,6.00,630.00,'2023-03-20 14:49:33','',''),(4563,'1','313','1',1,'Retail Sale Id 4644',4970.00,0.00,0.00,7.00,735.00,'2023-03-20 14:51:55','',''),(4564,'1','313','1',1,'Retail Sale Id 4646',2151.30,0.00,0.00,3.03,318.15,'2023-03-20 14:55:13','',''),(4565,'1','313','1',1,'Retail Sale Id 4647',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 14:56:27','',''),(4566,'1','313','1',1,'Retail Sale Id 4648',44997.20,0.00,0.00,67.16,4365.40,'2023-03-20 14:59:43','',''),(4567,'1','313','1',1,'Retail Sale Id 4649',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 15:00:52','',''),(4568,'1','313','1',1,'Retail Sale Id 4650',752.60,0.00,0.00,1.06,111.30,'2023-03-20 15:02:16','',''),(4569,'1','313','1',1,'Retail Sale Id 4651',2151.30,0.00,0.00,3.03,318.15,'2023-03-20 15:03:07','',''),(4570,'1','313','1',1,'Retail Sale Id 4652',30150.00,0.00,0.00,45.00,2925.00,'2023-03-20 15:05:19','',''),(4571,'1','313','1',1,'Return of Retail Sale Id 4648',0.00,44997.20,67.16,0.00,-4365.40,'2023-03-20 15:06:36','',''),(4572,'1','313','1',1,'Retail Sale Id 4653',1001.10,0.00,0.00,1.41,148.05,'2023-03-20 15:07:52','',''),(4573,'1','313','1',1,'Retail Sale Id 4654',28997.60,0.00,0.00,43.28,2813.20,'2023-03-20 15:08:55','',''),(4574,'1','313','1',1,'Retail Sale Id 4655',3003.30,0.00,0.00,4.23,444.15,'2023-03-20 15:10:05','',''),(4575,'1','313','1',1,'Retail Sale Id 4656',3550.00,0.00,0.00,5.00,525.00,'2023-03-20 15:10:58','',''),(4576,'1','313','1',1,'Retail Sale Id 4657',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 15:11:57','',''),(4577,'1','313','1',1,'Retail Sale Id 4658',710.00,0.00,0.00,1.00,105.00,'2023-03-20 15:13:09','',''),(4578,'1','313','1',1,'Retail Sale Id 4659',4260.00,0.00,0.00,6.00,630.00,'2023-03-20 15:14:18','',''),(4579,'1','313','1',1,'Retail Sale Id 4660',4970.00,0.00,0.00,7.00,735.00,'2023-03-20 15:16:14','',''),(4580,'1','313','1',1,'Retail Sale Id 4661',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 15:16:58','',''),(4581,'1','313','1',1,'Retail Sale Id 4662',16944.30,0.00,0.00,25.29,1643.85,'2023-03-20 15:18:18','',''),(4582,'1','313','1',1,'Retail Sale Id 4663',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 15:22:19','',''),(4583,'1','313','1',1,'Retail Sale Id 4664',5680.00,0.00,0.00,8.00,840.00,'2023-03-20 15:25:49','',''),(4584,'1','313','1',1,'Retail Sale Id 4665',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 15:37:50','',''),(4585,'1','313','1',1,'Retail Sale Id 4666',4970.00,0.00,0.00,7.00,735.00,'2023-03-20 15:39:16','',''),(4586,'1','313','1',1,'Retail Sale Id 4668',8875.00,0.00,0.00,12.50,1312.50,'2023-03-20 15:43:26','',''),(4587,'1','313','1',1,'Retail Sale Id 4669',1448.40,0.00,0.00,2.04,214.20,'2023-03-20 15:44:44','',''),(4588,'1','313','1',1,'Retail Sale Id 4671',3550.00,0.00,0.00,5.00,525.00,'2023-03-20 15:46:58','',''),(4589,'1','313','1',1,'Retail Sale Id 4672',2840.00,0.00,0.00,4.00,420.00,'2023-03-20 15:48:14','',''),(4590,'1','313','1',1,'Retail Sale Id 4673',8875.00,0.00,0.00,12.50,1312.50,'2023-03-20 15:49:13','',''),(4591,'1','313','1',1,'Retail Sale Id 4674',8520.00,0.00,0.00,12.00,1260.00,'2023-03-20 15:49:56','',''),(4592,'1','313','1',1,'Retail Sale Id 4675',3550.00,0.00,0.00,5.00,525.00,'2023-03-20 15:50:35','',''),(4593,'1','313','1',1,'Retail Sale Id 4676',710.00,0.00,0.00,1.00,105.00,'2023-03-20 15:51:13','',''),(4594,'1','313','1',1,'Retail Sale Id 4677',710.00,0.00,0.00,1.00,105.00,'2023-03-20 15:51:39','',''),(4595,'1','313','1',1,'Retail Sale Id 4678',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 15:52:18','',''),(4596,'1','313','1',1,'Retail Sale Id 4679',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 15:53:03','',''),(4597,'1','313','1',1,'Retail Sale Id 4680',4970.00,0.00,0.00,7.00,735.00,'2023-03-20 15:53:41','',''),(4598,'1','313','1',1,'Retail Sale Id 4682',8875.00,0.00,0.00,12.50,1312.50,'2023-03-20 15:56:56','',''),(4599,'1','313','1',1,'Retail Sale Id 4684',18994.50,0.00,0.00,28.35,1842.75,'2023-03-20 16:02:03','',''),(4600,'1','313','1',1,'Retail Sale Id 4685',1448.40,0.00,0.00,2.04,214.20,'2023-03-20 16:03:36','',''),(4601,'1','313','1',1,'Retail Sale Id 4686',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 16:04:14','',''),(4602,'1','313','1',1,'Retail Sale Id 4687',752.60,0.00,0.00,1.06,111.30,'2023-03-20 16:05:20','',''),(4603,'1','313','1',1,'Retail Sale Id 4688',4970.00,0.00,0.00,7.00,735.00,'2023-03-20 16:06:05','',''),(4604,'1','313','1',1,'Retail Sale Id 4689',1448.40,0.00,0.00,2.04,214.20,'2023-03-20 16:07:21','',''),(4605,'1','313','1',1,'Retail Sale Id 4690',2840.00,0.00,0.00,4.00,420.00,'2023-03-20 16:08:06','',''),(4606,'1','313','1',1,'Retail Sale Id 4691',3550.00,0.00,0.00,5.00,525.00,'2023-03-20 16:09:40','',''),(4607,'1','313','1',1,'Retail Sale Id 4692',2840.00,0.00,0.00,4.00,420.00,'2023-03-20 16:10:24','',''),(4608,'1','313','1',1,'Retail Sale Id 4693',1696.90,0.00,0.00,2.39,250.95,'2023-03-20 16:11:46','',''),(4609,'1','313','1',1,'Retail Sale Id 4694',3550.00,0.00,0.00,5.00,525.00,'2023-03-20 16:12:30','',''),(4610,'1','313','1',1,'Retail Sale Id 4695',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 16:13:22','',''),(4611,'1','313','1',1,'Retail Sale Id 4696',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 16:14:24','',''),(4612,'1','313','1',1,'Retail Sale Id 4697',3550.00,0.00,0.00,5.00,525.00,'2023-03-20 16:15:11','',''),(4613,'1','313','1',1,'Retail Sale Id 4698',3550.00,0.00,0.00,5.00,525.00,'2023-03-20 16:15:56','',''),(4614,'1','313','1',1,'Retail Sale Id 4699',752.60,0.00,0.00,1.06,111.30,'2023-03-20 16:16:47','',''),(4615,'1','313','1',1,'Retail Sale Id 4700',2151.30,0.00,0.00,3.03,318.15,'2023-03-20 16:17:40','',''),(4616,'1','313','1',1,'Retail Sale Id 4701',4970.00,0.00,0.00,7.00,735.00,'2023-03-20 16:18:32','',''),(4617,'1','313','1',1,'Retail Sale Id 4702',4970.00,0.00,0.00,7.00,735.00,'2023-03-20 16:19:28','',''),(4618,'1','313','1',1,'Retail Sale Id 4703',2151.30,0.00,0.00,3.03,318.15,'2023-03-20 16:20:12','',''),(4619,'1','313','1',1,'Retail Sale Id 4704',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 16:21:01','',''),(4620,'1','313','1',1,'Retail Sale Id 4705',8520.00,0.00,0.00,12.00,1260.00,'2023-03-20 16:21:51','',''),(4621,'1','313','1',1,'Retail Sale Id 4706',2151.30,0.00,0.00,3.03,318.15,'2023-03-20 16:23:27','',''),(4622,'1','313','1',1,'Retail Sale Id 4707',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 16:24:16','',''),(4623,'1','313','1',1,'Retail Sale Id 4708',752.60,0.00,0.00,1.06,111.30,'2023-03-20 16:25:20','',''),(4624,'1','313','1',1,'Retail Sale Id 4709',1001.10,0.00,0.00,1.41,148.05,'2023-03-20 16:28:39','',''),(4625,'1','313','1',1,'Retail Sale Id 4710',3550.00,0.00,0.00,5.00,525.00,'2023-03-20 16:29:57','',''),(4626,'1','313','1',1,'Retail Sale Id 4711',710.00,0.00,0.00,1.00,105.00,'2023-03-20 16:31:23','',''),(4627,'1','313','1',1,'Retail Sale Id 4712',710.00,0.00,0.00,1.00,105.00,'2023-03-20 16:32:36','',''),(4628,'1','313','1',1,'Retail Sale Id 4713',1597.50,0.00,0.00,2.25,236.25,'2023-03-20 16:33:50','',''),(4629,'1','313','1',1,'Retail Sale Id 4714',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 16:34:26','',''),(4630,'1','313','1',1,'Retail Sale Id 4715',8520.00,0.00,0.00,12.00,1260.00,'2023-03-20 16:35:26','',''),(4631,'1','313','1',1,'Retail Sale Id 4716',8520.00,0.00,0.00,12.00,1260.00,'2023-03-20 16:36:45','',''),(4632,'1','313','1',1,'Retail Sale Id 4717',1448.40,0.00,0.00,2.04,214.20,'2023-03-20 16:39:24','',''),(4633,'1','313','1',1,'Retail Sale Id 4718',2840.00,0.00,0.00,4.00,420.00,'2023-03-20 16:41:02','',''),(4634,'1','313','1',1,'Retail Sale Id 4719',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 16:42:01','',''),(4635,'1','313','1',1,'Retail Sale Id 4720',1448.40,0.00,0.00,2.04,214.20,'2023-03-20 16:43:27','',''),(4636,'1','313','1',1,'Retail Sale Id 4721',3550.00,0.00,0.00,5.00,525.00,'2023-03-20 16:45:14','',''),(4637,'1','313','1',1,'Retail Sale Id 4722',3500.30,0.00,0.00,4.93,517.65,'2023-03-20 16:46:05','',''),(4638,'1','313','1',1,'Retail Sale Id 4723',2492.10,0.00,0.00,3.51,368.55,'2023-03-20 16:47:42','',''),(4639,'1','313','1',1,'Retail Sale Id 4724',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 16:48:31','',''),(4640,'1','313','1',1,'Retail Sale Id 4725',67000.00,0.00,0.00,100.00,6500.00,'2023-03-20 16:49:43','',''),(4641,'1','313','1',1,'Retail Sale Id 4726',710.00,0.00,0.00,1.00,105.00,'2023-03-20 16:50:54','',''),(4642,'1','313','1',1,'Retail Sale Id 4727',8710.00,0.00,0.00,13.00,845.00,'2023-03-20 16:52:12','',''),(4643,'1','313','1',1,'Retail Sale Id 4728',4260.00,0.00,0.00,6.00,630.00,'2023-03-20 16:53:20','',''),(4644,'1','313','1',1,'Retail Sale Id 4729',1001.10,0.00,0.00,1.41,148.05,'2023-03-20 16:55:23','',''),(4645,'1','313','1',1,'Retail Sale Id 4730',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 16:56:22','',''),(4646,'1','313','1',1,'Retail Sale Id 4731',3550.00,0.00,0.00,5.00,525.00,'2023-03-20 16:58:16','',''),(4647,'1','313','1',1,'Retail Sale Id 4732',752.60,0.00,0.00,1.06,111.30,'2023-03-20 16:59:37','',''),(4648,'1','313','1',1,'Retail Sale Id 4733',2002.20,0.00,0.00,2.82,296.10,'2023-03-20 17:00:27','',''),(4649,'1','313','1',1,'Retail Sale Id 4734',1065.00,0.00,0.00,1.50,157.50,'2023-03-20 17:02:18','',''),(4650,'1','313','1',1,'Retail Sale Id 4735',3550.00,0.00,0.00,5.00,525.00,'2023-03-20 17:04:04','',''),(4651,'1','313','1',1,'Retail Sale Id 4736',4970.00,0.00,0.00,7.00,735.00,'2023-03-20 17:05:26','',''),(4652,'1','313','1',1,'Retail Sale Id 4737',8875.00,0.00,0.00,12.50,1312.50,'2023-03-20 17:06:41','',''),(4653,'1','313','1',1,'Retail Sale Id 4738',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 17:08:03','',''),(4654,'1','313','1',1,'Retail Sale Id 4739',4970.00,0.00,0.00,7.00,735.00,'2023-03-20 17:08:57','',''),(4655,'1','313','1',1,'Retail Sale Id 4740',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 17:09:58','',''),(4656,'1','313','1',1,'Retail Sale Id 4741',2840.00,0.00,0.00,4.00,420.00,'2023-03-20 17:11:03','',''),(4657,'1','313','1',1,'Retail Sale Id 4742',2840.00,0.00,0.00,4.00,420.00,'2023-03-20 17:14:10','',''),(4658,'1','313','1',1,'Retail Sale Id 4743',2840.00,0.00,0.00,4.00,420.00,'2023-03-20 17:15:18','',''),(4659,'1','313','1',1,'Retail Sale Id 4744',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 17:16:59','',''),(4660,'1','313','1',1,'Retail Sale Id 4745',1448.40,0.00,0.00,2.04,214.20,'2023-03-20 17:17:47','',''),(4661,'1','313','1',1,'Retail Sale Id 4747',1448.40,0.00,0.00,2.04,214.20,'2023-03-20 17:19:16','',''),(4662,'1','313','1',1,'Retail Sale Id 4748',2151.30,0.00,0.00,3.03,318.15,'2023-03-20 17:20:08','',''),(4663,'1','313','1',1,'Retail Sale Id 4749',8520.00,0.00,0.00,12.00,1260.00,'2023-03-20 17:23:58','',''),(4664,'1','313','1',1,'Retail Sale Id 4750',11637.90,0.00,0.00,17.37,1129.05,'2023-03-20 17:25:43','',''),(4665,'1','313','1',1,'Retail Sale Id 4751',2130.00,0.00,0.00,3.00,315.00,'2023-03-20 17:26:52','',''),(4666,'1','313','1',1,'Retail Sale Id 4752',2840.00,0.00,0.00,4.00,420.00,'2023-03-20 17:30:55','',''),(4667,'1','313','1',1,'Return of Retail Sale Id 4728',0.00,4260.00,6.00,0.00,-630.00,'2023-03-20 17:32:31','',''),(4668,'1','313','1',1,'Retail Sale Id 4753',1420.00,0.00,0.00,2.00,210.00,'2023-03-20 17:34:10','',''),(4669,'1','313','1',1,'Return of Retail Sale Id 4753',0.00,1420.00,2.00,0.00,-210.00,'2023-03-20 17:35:32','',''),(4670,'1','313','1',1,'Retail Sale Id 4754',710.00,0.00,0.00,1.00,105.00,'2023-03-20 17:36:55','',''),(4671,'1','313','1',1,'Retail Sale Id 4755',2010.00,0.00,0.00,3.00,195.00,'2023-03-20 18:37:55','',''),(4672,'1','313','1',1,'Retail Sale Id 4756',32468.20,0.00,0.00,48.46,3149.90,'2023-03-20 18:42:11','',''),(4673,'1','313','1',1,'Retail Sale Id 4757',11338.70,0.00,0.00,15.97,1676.85,'2023-03-20 18:46:43','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'1','313',1,80.07,'2023-03-20 18:46:43');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4666 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'1','313',1,'Retail Sale Id 1',0.00,322059.65,710.00,377954.30,55894.65,'2023-02-22 09:49:45'),(2,'1','313',1,'Retail Sale Id 2',0.00,169460.50,660.00,184866.00,15405.50,'2023-02-22 10:07:43'),(3,'1','313',1,'Retail Sale Id 3',0.00,252823.45,710.00,296701.90,43878.45,'2023-02-22 10:20:29'),(4,'1','313',1,'Retail Sale Id 4',0.00,278989.70,670.00,308963.80,29974.10,'2023-02-22 10:21:32'),(5,'1','313',1,'Retail Sale Id 5',0.00,311532.65,710.00,365600.30,54067.65,'2023-02-22 10:49:02'),(6,'1','313',1,'Retail Sale Id 6',0.00,176932.25,670.00,195941.50,19009.25,'2023-02-22 10:51:17'),(7,'1','313',1,'Retail Sale Id 7',0.00,288252.25,710.00,338279.50,50027.25,'2023-02-22 18:57:11'),(8,'1','313',1,'Retail Sale Id 8',0.00,271239.65,670.00,300381.10,29141.45,'2023-02-22 18:58:17'),(9,'1','313',1,'Retail Sale Id 9',0.00,1234.20,710.00,1448.40,214.20,'2023-02-23 08:16:34'),(10,'1','313',1,'Retail Sale Id 10',0.00,2420.00,710.00,2840.00,420.00,'2023-02-23 08:17:56'),(11,'1','313',1,'Retail Sale Id 11',0.00,1276.55,710.00,1498.10,221.55,'2023-02-23 08:19:29'),(12,'1','313',1,'Retail Sale Id 12',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-23 08:20:48'),(13,'1','313',1,'Retail Sale Id 13',0.00,1815.00,710.00,2130.00,315.00,'2023-02-23 08:21:49'),(14,'1','313',1,'Retail Sale Id 14',0.00,1833.15,710.00,2151.30,318.15,'2023-02-23 08:23:23'),(15,'1','313',1,'Retail Sale Id 15',0.00,4235.00,710.00,4970.00,735.00,'2023-02-23 08:24:35'),(16,'1','313',1,'Retail Sale Id 16',0.00,1234.20,710.00,1448.40,214.20,'2023-02-23 08:25:44'),(17,'1','313',1,'Retail Sale Id 17',0.00,605.00,710.00,710.00,105.00,'2023-02-23 08:26:47'),(18,'1','313',1,'Retail Sale Id 18',0.00,641.30,710.00,752.60,111.30,'2023-02-23 08:28:22'),(19,'1','313',1,'Retail Sale Id 19',0.00,4259.20,710.00,4998.40,739.20,'2023-02-23 08:29:50'),(20,'1','313',1,'Retail Sale Id 20',0.00,4235.00,710.00,4970.00,735.00,'2023-02-23 08:31:15'),(21,'1','313',1,'Retail Sale Id 21',0.00,1234.20,710.00,1448.40,214.20,'2023-02-23 08:32:20'),(22,'1','313',1,'Retail Sale Id 22',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-23 08:33:26'),(23,'1','313',1,'Retail Sale Id 23',0.00,853.05,710.00,1001.10,148.05,'2023-02-23 08:34:20'),(24,'1','313',1,'Retail Sale Id 24',0.00,605.00,710.00,710.00,105.00,'2023-02-23 08:35:22'),(25,'1','313',1,'Retail Sale Id 25',0.00,4840.00,710.00,5680.00,840.00,'2023-02-23 08:36:51'),(26,'1','313',1,'Retail Sale Id 26',0.00,605.00,710.00,710.00,105.00,'2023-02-23 08:38:00'),(27,'1','313',1,'Retail Sale Id 27',0.00,6691.30,710.00,7852.60,1161.30,'2023-02-23 08:40:05'),(28,'1','313',1,'Retail Sale Id 28',0.00,605.00,710.00,710.00,105.00,'2023-02-23 08:41:42'),(29,'1','313',1,'Retail Sale Id 29',0.00,3630.00,710.00,4260.00,630.00,'2023-02-23 08:45:23'),(30,'1','313',1,'Retail Sale Id 30',0.00,1210.00,710.00,1420.00,210.00,'2023-02-23 08:49:24'),(31,'1','313',1,'Retail Sale Id 31',0.00,605.00,710.00,710.00,105.00,'2023-02-23 08:53:42'),(32,'1','313',1,'Retail Sale Id 32',0.00,641.30,710.00,752.60,111.30,'2023-02-23 08:54:40'),(33,'1','313',1,'Retail Sale Id 33',0.00,605.00,710.00,710.00,105.00,'2023-02-23 08:56:10'),(34,'1','313',1,'Retail Sale Id 34',0.00,641.30,710.00,752.60,111.30,'2023-02-23 08:56:55'),(35,'1','313',1,'Retail Sale Id 35',0.00,3630.00,710.00,4260.00,630.00,'2023-02-23 08:58:29'),(36,'1','313',1,'Retail Sale Id 36',0.00,1210.00,710.00,1420.00,210.00,'2023-02-23 09:01:38'),(37,'1','313',1,'Retail Sale Id 37',0.00,7865.00,710.00,9230.00,1365.00,'2023-02-23 09:04:12'),(38,'1','313',1,'Retail Sale Id 38',0.00,1210.00,710.00,1420.00,210.00,'2023-02-23 09:06:27'),(39,'1','313',1,'Retail Sale Id 39',0.00,641.30,710.00,752.60,111.30,'2023-02-23 09:12:13'),(40,'1','313',1,'Retail Sale Id 40',0.00,2420.00,710.00,2840.00,420.00,'2023-02-23 09:14:16'),(41,'1','313',1,'Retail Sale Id 41',0.00,4840.00,710.00,5680.00,840.00,'2023-02-23 09:16:01'),(42,'1','313',1,'Retail Sale Id 42',0.00,1815.00,710.00,2130.00,315.00,'2023-02-23 09:56:10'),(43,'1','313',1,'Retail Sale Id 43',0.00,1210.00,710.00,1420.00,210.00,'2023-02-23 09:59:26'),(44,'1','313',1,'Retail Sale Id 44',0.00,5445.00,710.00,6390.00,945.00,'2023-02-23 10:06:19'),(45,'1','313',1,'Retail Sale Id 45',0.00,3406.15,710.00,3997.30,591.15,'2023-02-23 10:06:59'),(46,'1','313',1,'Retail Sale Id 46',0.00,27823.95,710.00,32652.90,4828.95,'2023-02-23 10:09:40'),(47,'1','313',1,'Retail Sale Id 47',0.00,1833.15,710.00,2151.30,318.15,'2023-02-23 10:49:29'),(48,'1','313',1,'Retail Sale Id 48',0.00,1234.20,710.00,1448.40,214.20,'2023-02-23 10:50:45'),(49,'1','313',1,'Retail Sale Id 49',0.00,5445.00,710.00,6390.00,945.00,'2023-02-23 10:52:04'),(50,'1','313',1,'Retail Sale Id 50',0.00,1234.20,710.00,1448.40,214.20,'2023-02-23 10:52:52'),(51,'1','313',1,'Retail Sale Id 51',0.00,1815.00,710.00,2130.00,315.00,'2023-02-23 10:54:27'),(52,'1','313',1,'Retail Sale Id 53',0.00,3406.15,710.00,3997.30,591.15,'2023-02-23 10:55:13'),(53,'1','313',1,'Retail Sale Id 54',0.00,605.00,710.00,710.00,105.00,'2023-02-23 10:56:16'),(54,'1','313',1,'Retail Sale Id 55',0.00,641.30,710.00,752.60,111.30,'2023-02-23 10:57:53'),(55,'1','313',1,'Retail Sale Id 56',0.00,1815.00,710.00,2130.00,315.00,'2023-02-23 10:58:34'),(56,'1','313',1,'Retail Sale Id 57',0.00,605.00,710.00,710.00,105.00,'2023-02-23 10:59:57'),(57,'1','313',1,'Retail Sale Id 58',0.00,1833.15,710.00,2151.30,318.15,'2023-02-23 11:01:08'),(58,'1','313',1,'Retail Sale Id 59',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-23 11:06:01'),(59,'1','313',1,'Retail Sale Id 60',0.00,3025.00,710.00,3550.00,525.00,'2023-02-23 11:11:14'),(60,'1','313',1,'Retail Sale Id 61',0.00,1815.00,710.00,2130.00,315.00,'2023-02-23 11:13:02'),(61,'1','313',1,'Retail Sale Id 62',0.00,605.00,710.00,710.00,105.00,'2023-02-23 11:16:00'),(62,'1','313',1,'Retail Sale Id 63',0.00,641.30,710.00,752.60,111.30,'2023-02-23 11:16:38'),(63,'1','313',1,'Retail Sale Id 64',0.00,1210.00,710.00,1420.00,210.00,'2023-02-23 11:19:07'),(64,'1','313',1,'Retail Sale Id 66',0.00,6050.00,710.00,7100.00,1050.00,'2023-02-23 11:22:00'),(65,'1','313',1,'Retail Sale Id 67',0.00,1210.00,710.00,1420.00,210.00,'2023-02-23 11:24:07'),(66,'1','313',1,'Retail Sale Id 68',0.00,14374.80,670.00,15919.20,1544.40,'2023-02-23 11:26:08'),(67,'1','313',1,'Retail Sale Id 70',0.00,1815.00,710.00,2130.00,315.00,'2023-02-23 11:29:04'),(68,'1','313',1,'Retail Sale Id 71',0.00,27043.50,670.00,29949.00,2905.50,'2023-02-23 11:33:48'),(69,'1','313',1,'Retail Sale Id 72',0.00,1815.00,710.00,2130.00,315.00,'2023-02-23 11:37:18'),(70,'1','313',1,'Retail Sale Id 73',0.00,2559.15,710.00,3003.30,444.15,'2023-02-23 11:38:40'),(71,'1','313',1,'Retail Sale Id 74',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-23 11:41:11'),(72,'1','313',1,'Retail Sale Id 75',0.00,1706.10,710.00,2002.20,296.10,'2023-02-23 11:42:21'),(73,'1','313',1,'Retail Sale Id 76',0.00,1815.00,710.00,2130.00,315.00,'2023-02-23 11:47:21'),(74,'1','313',1,'Retail Sale Id 77',0.00,3025.00,710.00,3550.00,525.00,'2023-02-23 11:56:12'),(75,'1','313',1,'Retail Sale Id 78',0.00,4235.00,710.00,4970.00,735.00,'2023-02-23 12:02:55'),(76,'1','313',1,'Retail Sale Id 79',0.00,4235.00,710.00,4970.00,735.00,'2023-02-23 12:12:10'),(77,'1','313',1,'Retail Sale Id 80',0.00,11192.50,670.00,12395.00,1202.50,'2023-02-23 12:20:46'),(78,'1','313',1,'Retail Sale Id 81',0.00,1210.00,710.00,1420.00,210.00,'2023-02-23 12:23:39'),(79,'1','313',1,'Retail Sale Id 82',0.00,2420.00,710.00,2840.00,420.00,'2023-02-23 12:28:42'),(80,'1','313',1,'Retail Sale Id 83',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-23 12:30:24'),(81,'1','313',1,'Retail Sale Id 84',0.00,6050.00,710.00,7100.00,1050.00,'2023-02-23 12:33:26'),(82,'1','313',1,'Retail Sale Id 85',0.00,1210.00,710.00,1420.00,210.00,'2023-02-23 12:36:31'),(83,'1','313',1,'Retail Sale Id 86',0.00,853.05,710.00,1001.10,148.05,'2023-02-23 12:41:08'),(84,'1','313',1,'Retail Sale Id 87',0.00,7260.00,710.00,8520.00,1260.00,'2023-02-23 12:43:57'),(85,'1','313',1,'Retail Sale Id 88',0.00,30250.00,670.00,33500.00,3250.00,'2023-02-23 12:47:05'),(86,'1','313',1,'Retail Sale Id 90',0.00,1815.00,710.00,2130.00,315.00,'2023-02-23 12:53:14'),(87,'1','313',1,'Retail Sale Id 91',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-23 12:58:08'),(88,'1','313',1,'Retail Sale Id 93',0.00,1815.00,710.00,2130.00,315.00,'2023-02-23 13:07:38'),(89,'1','313',1,'Retail Sale Id 94',0.00,1210.00,710.00,1420.00,210.00,'2023-02-23 13:09:36'),(90,'1','313',1,'Retail Sale Id 95',0.00,2559.15,710.00,3003.30,444.15,'2023-02-23 13:19:26'),(91,'1','313',1,'Retail Sale Id 96',0.00,1210.00,710.00,1420.00,210.00,'2023-02-23 13:21:31'),(92,'1','313',1,'Retail Sale Id 97',0.00,641.30,710.00,752.60,111.30,'2023-02-23 13:34:35'),(93,'1','313',1,'Retail Sale Id 98',0.00,641.30,710.00,752.60,111.30,'2023-02-23 13:37:43'),(94,'1','313',1,'Retail Sale Id 99',0.00,10285.00,710.00,12070.00,1785.00,'2023-02-23 13:42:19'),(95,'1','313',1,'Retail Sale Id 101',0.00,1210.00,710.00,1420.00,210.00,'2023-02-23 13:46:47'),(96,'1','313',1,'Retail Sale Id 102',0.00,1210.00,710.00,1420.00,210.00,'2023-02-23 13:53:26'),(97,'1','313',1,'Retail Sale Id 103',0.00,3406.15,710.00,3997.30,591.15,'2023-02-23 13:55:51'),(98,'1','313',1,'Retail Sale Id 104',0.00,1210.00,710.00,1420.00,210.00,'2023-02-23 13:59:20'),(99,'1','313',1,'Retail Sale Id 105',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-23 14:02:31'),(100,'1','313',1,'Retail Sale Id 107',0.00,3666.30,710.00,4302.60,636.30,'2023-02-23 14:16:47'),(101,'1','313',1,'Retail Sale Id 108',0.00,1815.00,710.00,2130.00,315.00,'2023-02-23 14:18:14'),(102,'1','313',1,'Retail Sale Id 109',0.00,3962.75,710.00,4650.50,687.75,'2023-02-23 14:34:40'),(103,'1','313',1,'Retail Sale Id 110',0.00,10890.00,710.00,12780.00,1890.00,'2023-02-23 14:38:11'),(104,'1','313',1,'Retail Sale Id 111',0.00,4235.00,710.00,4970.00,735.00,'2023-02-23 14:42:44'),(105,'1','313',1,'Retail Sale Id 112',0.00,1210.00,710.00,1420.00,210.00,'2023-02-23 14:46:42'),(106,'1','313',1,'Retail Sale Id 113',0.00,605.00,710.00,710.00,105.00,'2023-02-23 14:47:44'),(107,'1','313',1,'Retail Sale Id 114',0.00,641.30,710.00,752.60,111.30,'2023-02-23 14:48:24'),(108,'1','313',1,'Retail Sale Id 115',0.00,3025.00,710.00,3550.00,525.00,'2023-02-23 14:49:52'),(109,'1','313',1,'Retail Sale Id 116',0.00,1234.20,710.00,1448.40,214.20,'2023-02-23 14:52:55'),(110,'1','313',1,'Retail Sale Id 117',0.00,2420.00,710.00,2840.00,420.00,'2023-02-23 14:54:09'),(111,'1','313',1,'Retail Sale Id 118',0.00,1210.00,710.00,1420.00,210.00,'2023-02-23 14:55:12'),(112,'1','313',1,'Retail Sale Id 119',0.00,605.00,710.00,710.00,105.00,'2023-02-23 14:56:00'),(113,'1','313',1,'Retail Sale Id 120',0.00,605.00,710.00,710.00,105.00,'2023-02-23 14:58:24'),(114,'1','313',1,'Retail Sale Id 121',0.00,1815.00,710.00,2130.00,315.00,'2023-02-23 15:05:08'),(115,'1','313',1,'Retail Sale Id 122',0.00,1706.10,710.00,2002.20,296.10,'2023-02-23 15:08:43'),(116,'1','313',1,'Retail Sale Id 123',0.00,4259.20,710.00,4998.40,739.20,'2023-02-23 15:17:27'),(117,'1','313',1,'Retail Sale Id 124',0.00,1706.10,710.00,2002.20,296.10,'2023-02-23 15:19:34'),(118,'1','313',1,'Retail Sale Id 125',0.00,3630.00,710.00,4260.00,630.00,'2023-02-23 15:22:59'),(119,'1','313',1,'Retail Sale Id 126',0.00,1815.00,710.00,2130.00,315.00,'2023-02-23 15:25:09'),(120,'1','313',1,'Retail Sale Id 127',0.00,4840.00,710.00,5680.00,840.00,'2023-02-23 15:27:09'),(121,'1','313',1,'Retail Sale Id 128',0.00,641.30,710.00,752.60,111.30,'2023-02-23 15:29:35'),(122,'1','313',1,'Retail Sale Id 129',0.00,36681.15,670.00,40622.10,3940.95,'2023-02-23 15:31:40'),(123,'1','313',1,'Retail Sale Id 130',0.00,1815.00,710.00,2130.00,315.00,'2023-02-23 15:44:08'),(124,'1','313',1,'Retail Sale Id 131',0.00,2420.00,710.00,2840.00,420.00,'2023-02-23 15:46:09'),(125,'1','313',1,'Retail Sale Id 132',0.00,3025.00,710.00,3550.00,525.00,'2023-02-23 15:48:43'),(126,'1','313',1,'Retail Sale Id 133',0.00,1276.55,710.00,1498.10,221.55,'2023-02-23 15:50:01'),(127,'1','313',1,'Retail Sale Id 134',0.00,605.00,710.00,710.00,105.00,'2023-02-23 15:51:05'),(128,'1','313',1,'Retail Sale Id 135',0.00,4840.00,710.00,5680.00,840.00,'2023-02-23 15:53:50'),(129,'1','313',1,'Retail Sale Id 136',0.00,1210.00,710.00,1420.00,210.00,'2023-02-23 15:56:25'),(130,'1','313',1,'Retail Sale Id 137',0.00,3630.00,710.00,4260.00,630.00,'2023-02-23 15:58:31'),(131,'1','313',1,'Retail Sale Id 138',0.00,605.00,710.00,710.00,105.00,'2023-02-23 15:59:46'),(132,'1','313',1,'Retail Sale Id 139',0.00,1815.00,710.00,2130.00,315.00,'2023-02-23 16:01:03'),(133,'1','313',1,'Retail Sale Id 140',0.00,3406.15,710.00,3997.30,591.15,'2023-02-23 16:03:54'),(134,'1','313',1,'Retail Sale Id 141',0.00,605.00,710.00,710.00,105.00,'2023-02-23 16:14:04'),(135,'1','313',1,'Retail Sale Id 142',0.00,7586.70,710.00,8903.40,1316.70,'2023-02-23 16:17:21'),(136,'1','313',1,'Retail Sale Id 143',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-23 16:19:07'),(137,'1','313',1,'Retail Sale Id 145',0.00,4235.00,710.00,4970.00,735.00,'2023-02-23 16:24:13'),(138,'1','313',1,'Retail Sale Id 146',0.00,3025.00,710.00,3550.00,525.00,'2023-02-23 16:26:05'),(139,'1','313',1,'Retail Sale Id 147',0.00,1210.00,710.00,1420.00,210.00,'2023-02-23 16:28:12'),(140,'1','313',1,'Retail Sale Id 148',0.00,1276.55,710.00,1498.10,221.55,'2023-02-23 16:31:02'),(141,'1','313',1,'Retail Sale Id 149',0.00,605.00,710.00,710.00,105.00,'2023-02-23 16:35:36'),(142,'1','313',1,'Retail Sale Id 150',0.00,3666.30,710.00,4302.60,636.30,'2023-02-23 16:40:52'),(143,'1','313',1,'Retail Sale Id 151',0.00,1833.15,710.00,2151.30,318.15,'2023-02-23 16:42:13'),(144,'1','313',1,'Retail Sale Id 152',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-23 16:43:54'),(145,'1','313',1,'Retail Sale Id 153',0.00,1022.45,710.00,1199.90,177.45,'2023-02-23 16:48:51'),(146,'1','313',1,'Retail Sale Id 154',0.00,1210.00,710.00,1420.00,210.00,'2023-02-23 16:53:25'),(147,'1','313',1,'Retail Sale Id 155',0.00,641.30,710.00,752.60,111.30,'2023-02-23 16:56:59'),(148,'1','313',1,'Retail Sale Id 156',0.00,1833.15,710.00,2151.30,318.15,'2023-02-23 16:58:51'),(149,'1','313',1,'Retail Sale Id 157',0.00,2426.05,710.00,2847.10,421.05,'2023-02-23 17:01:02'),(150,'1','313',1,'Retail Sale Id 158',0.00,1210.00,710.00,1420.00,210.00,'2023-02-23 17:04:06'),(151,'1','313',1,'Retail Sale Id 159',0.00,6050.00,710.00,7100.00,1050.00,'2023-02-23 17:05:28'),(152,'1','313',1,'Retail Sale Id 160',0.00,1210.00,710.00,1420.00,210.00,'2023-02-23 17:07:22'),(153,'1','313',1,'Retail Sale Id 161',0.00,1706.10,710.00,2002.20,296.10,'2023-02-23 17:08:46'),(154,'1','313',1,'Retail Sale Id 162',0.00,605.00,710.00,710.00,105.00,'2023-02-23 17:11:18'),(155,'1','313',1,'Retail Sale Id 163',0.00,4235.00,710.00,4970.00,735.00,'2023-02-23 17:13:50'),(156,'1','313',1,'Return of Retail Sale Id 142',7586.70,0.00,710.00,-8903.40,-1316.70,'2023-02-23 17:42:39'),(157,'1','313',1,'Retail Sale Id 164',0.00,2081.20,710.00,2442.40,361.20,'2023-02-23 17:43:57'),(158,'1','313',1,'Retail Sale Id 165',0.00,222041.05,670.00,245896.70,23855.65,'2023-02-24 10:15:57'),(159,'1','313',1,'Retail Sale Id 166',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 10:16:30'),(160,'1','313',1,'Retail Sale Id 167',0.00,1833.15,710.00,2151.30,318.15,'2023-02-24 10:18:08'),(161,'1','313',1,'Retail Sale Id 168',0.00,5445.00,710.00,6390.00,945.00,'2023-02-24 10:19:14'),(162,'1','313',1,'Retail Sale Id 169',0.00,1210.00,710.00,1420.00,210.00,'2023-02-24 10:19:58'),(163,'1','313',1,'Retail Sale Id 170',0.00,1210.00,710.00,1420.00,210.00,'2023-02-24 10:21:12'),(164,'1','313',1,'Retail Sale Id 171',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 10:22:11'),(165,'1','313',1,'Retail Sale Id 172',0.00,586.85,710.00,688.70,101.85,'2023-02-24 10:24:02'),(166,'1','313',1,'Retail Sale Id 173',0.00,1234.20,710.00,1448.40,214.20,'2023-02-24 10:25:30'),(167,'1','313',1,'Retail Sale Id 174',0.00,1833.15,710.00,2151.30,318.15,'2023-02-24 10:27:14'),(168,'1','313',1,'Retail Sale Id 175',0.00,1210.00,710.00,1420.00,210.00,'2023-02-24 10:28:39'),(169,'1','313',1,'Retail Sale Id 176',0.00,1210.00,710.00,1420.00,210.00,'2023-02-24 10:29:24'),(170,'1','313',1,'Retail Sale Id 177',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-24 10:31:33'),(171,'1','313',1,'Retail Sale Id 178',0.00,1833.15,710.00,2151.30,318.15,'2023-02-24 10:33:09'),(172,'1','313',1,'Retail Sale Id 179',0.00,1210.00,710.00,1420.00,210.00,'2023-02-24 10:34:58'),(173,'1','313',1,'Retail Sale Id 180',0.00,605.00,710.00,710.00,105.00,'2023-02-24 10:36:33'),(174,'1','313',1,'Retail Sale Id 181',0.00,3630.00,710.00,4260.00,630.00,'2023-02-24 10:37:35'),(175,'1','313',1,'Retail Sale Id 182',0.00,2420.00,710.00,2840.00,420.00,'2023-02-24 10:38:40'),(176,'1','313',1,'Retail Sale Id 183',0.00,1234.20,710.00,1448.40,214.20,'2023-02-24 10:40:10'),(177,'1','313',1,'Retail Sale Id 184',0.00,4259.20,710.00,4998.40,739.20,'2023-02-24 10:41:23'),(178,'1','313',1,'Retail Sale Id 185',0.00,641.30,710.00,752.60,111.30,'2023-02-24 10:42:24'),(179,'1','313',1,'Retail Sale Id 186',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 10:43:27'),(180,'1','313',1,'Retail Sale Id 187',0.00,3630.00,710.00,4260.00,630.00,'2023-02-24 10:46:11'),(181,'1','313',1,'Retail Sale Id 188',0.00,6050.00,710.00,7100.00,1050.00,'2023-02-24 10:56:36'),(182,'1','313',1,'Retail Sale Id 189',0.00,2420.00,710.00,2840.00,420.00,'2023-02-24 10:59:44'),(183,'1','313',1,'Retail Sale Id 190',0.00,1210.00,710.00,1420.00,210.00,'2023-02-24 11:01:51'),(184,'1','313',1,'Retail Sale Id 191',0.00,3025.00,710.00,3550.00,525.00,'2023-02-24 11:04:06'),(185,'1','313',1,'Retail Sale Id 192',0.00,4235.00,710.00,4970.00,735.00,'2023-02-24 11:09:08'),(186,'1','313',1,'Retail Sale Id 193',0.00,1234.20,710.00,1448.40,214.20,'2023-02-24 11:11:06'),(187,'1','313',1,'Retail Sale Id 194',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 11:12:39'),(188,'1','313',1,'Retail Sale Id 195',0.00,1210.00,710.00,1420.00,210.00,'2023-02-24 11:17:21'),(189,'1','313',1,'Retail Sale Id 196',0.00,3025.00,710.00,3550.00,525.00,'2023-02-24 11:18:16'),(190,'1','313',1,'Retail Sale Id 197',0.00,1234.20,710.00,1448.40,214.20,'2023-02-24 11:20:04'),(191,'1','313',1,'Retail Sale Id 198',0.00,30250.00,670.00,33500.00,3250.00,'2023-02-24 11:22:32'),(192,'1','313',1,'Retail Sale Id 199',0.00,2420.00,710.00,2840.00,420.00,'2023-02-24 11:24:22'),(193,'1','313',1,'Retail Sale Id 200',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 11:24:56'),(194,'1','313',1,'Retail Sale Id 201',0.00,2420.00,710.00,2840.00,420.00,'2023-02-24 11:28:11'),(195,'1','313',1,'Retail Sale Id 202',0.00,72600.00,670.00,80400.00,7800.00,'2023-02-24 11:29:22'),(196,'1','313',1,'Retail Sale Id 203',0.00,30250.00,670.00,33500.00,3250.00,'2023-02-24 11:30:57'),(197,'1','313',1,'Retail Sale Id 204',0.00,853.05,710.00,1001.10,148.05,'2023-02-24 11:31:33'),(198,'1','313',1,'Retail Sale Id 205',0.00,1210.00,710.00,1420.00,210.00,'2023-02-24 11:33:43'),(199,'1','313',1,'Retail Sale Id 206',0.00,605.00,710.00,710.00,105.00,'2023-02-24 11:36:08'),(200,'1','313',1,'Retail Sale Id 207',0.00,853.05,710.00,1001.10,148.05,'2023-02-24 11:37:01'),(201,'1','313',1,'Retail Sale Id 208',0.00,1210.00,710.00,1420.00,210.00,'2023-02-24 11:37:48'),(202,'1','313',1,'Retail Sale Id 209',0.00,1210.00,710.00,1420.00,210.00,'2023-02-24 11:39:58'),(203,'1','313',1,'Retail Sale Id 210',0.00,3025.00,710.00,3550.00,525.00,'2023-02-24 11:41:40'),(204,'1','313',1,'Retail Sale Id 211',0.00,853.05,710.00,1001.10,148.05,'2023-02-24 11:46:52'),(205,'1','313',1,'Retail Sale Id 212',0.00,605.00,710.00,710.00,105.00,'2023-02-24 11:48:46'),(206,'1','313',1,'Retail Sale Id 213',0.00,2559.15,710.00,3003.30,444.15,'2023-02-24 11:50:46'),(207,'1','313',1,'Retail Sale Id 214',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-24 11:52:12'),(208,'1','313',1,'Retail Sale Id 215',0.00,1210.00,710.00,1420.00,210.00,'2023-02-24 11:54:29'),(209,'1','313',1,'Retail Sale Id 217',0.00,3025.00,710.00,3550.00,525.00,'2023-02-24 12:01:57'),(210,'1','313',1,'Retail Sale Id 218',0.00,4840.00,710.00,5680.00,840.00,'2023-02-24 12:03:42'),(211,'1','313',1,'Retail Sale Id 219',0.00,1276.55,710.00,1498.10,221.55,'2023-02-24 12:05:06'),(212,'1','313',1,'Retail Sale Id 220',0.00,3630.00,710.00,4260.00,630.00,'2023-02-24 12:09:09'),(213,'1','313',1,'Retail Sale Id 221',0.00,3025.00,710.00,3550.00,525.00,'2023-02-24 12:10:45'),(214,'1','313',1,'Retail Sale Id 222',0.00,30855.00,670.00,34170.00,3315.00,'2023-02-24 12:15:01'),(215,'1','313',1,'Return of Retail Sale Id 218',4840.00,0.00,710.00,-5680.00,-840.00,'2023-02-24 12:16:30'),(216,'1','313',1,'Retail Sale Id 223',0.00,4725.05,710.00,5545.10,820.05,'2023-02-24 12:17:47'),(217,'1','313',1,'Retail Sale Id 224',0.00,605.00,710.00,710.00,105.00,'2023-02-24 12:20:03'),(218,'1','313',1,'Retail Sale Id 225',0.00,2420.00,710.00,2840.00,420.00,'2023-02-24 12:27:29'),(219,'1','313',1,'Retail Sale Id 227',0.00,3025.00,710.00,3550.00,525.00,'2023-02-24 12:30:56'),(220,'1','313',1,'Retail Sale Id 228',0.00,30250.00,670.00,33500.00,3250.00,'2023-02-24 12:32:52'),(221,'1','313',1,'Retail Sale Id 229',0.00,3630.00,710.00,4260.00,630.00,'2023-02-24 12:34:06'),(222,'1','313',1,'Retail Sale Id 230',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 12:36:22'),(223,'1','313',1,'Retail Sale Id 231',0.00,1276.55,710.00,1498.10,221.55,'2023-02-24 12:37:18'),(224,'1','313',1,'Retail Sale Id 232',0.00,2420.00,710.00,2840.00,420.00,'2023-02-24 12:39:50'),(225,'1','313',1,'Retail Sale Id 233',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 12:41:15'),(226,'1','313',1,'Retail Sale Id 234',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-24 12:43:19'),(227,'1','313',1,'Retail Sale Id 235',0.00,605.00,710.00,710.00,105.00,'2023-02-24 12:44:05'),(228,'1','313',1,'Retail Sale Id 236',0.00,4235.00,710.00,4970.00,735.00,'2023-02-24 12:46:20'),(229,'1','313',1,'Retail Sale Id 237',0.00,4840.00,710.00,5680.00,840.00,'2023-02-24 12:50:55'),(230,'1','313',1,'Retail Sale Id 238',0.00,3835.70,710.00,4501.40,665.70,'2023-02-24 12:53:23'),(231,'1','313',1,'Retail Sale Id 240',0.00,605.00,710.00,710.00,105.00,'2023-02-24 12:59:08'),(232,'1','313',1,'Retail Sale Id 241',0.00,1706.10,710.00,2002.20,296.10,'2023-02-24 13:00:59'),(233,'1','313',1,'Retail Sale Id 242',0.00,4840.00,710.00,5680.00,840.00,'2023-02-24 13:05:12'),(234,'1','313',1,'Retail Sale Id 243',0.00,2559.15,710.00,3003.30,444.15,'2023-02-24 13:06:18'),(235,'1','313',1,'Retail Sale Id 244',0.00,683.65,710.00,802.30,118.65,'2023-02-24 13:07:30'),(236,'1','313',1,'Retail Sale Id 245',0.00,1706.10,710.00,2002.20,296.10,'2023-02-24 13:09:12'),(237,'1','313',1,'Retail Sale Id 246',0.00,3025.00,710.00,3550.00,525.00,'2023-02-24 13:12:52'),(238,'1','313',1,'Retail Sale Id 247',0.00,1833.15,710.00,2151.30,318.15,'2023-02-24 13:13:54'),(239,'1','313',1,'Retail Sale Id 248',0.00,3025.00,710.00,3550.00,525.00,'2023-02-24 13:15:48'),(240,'1','313',1,'Retail Sale Id 249',0.00,2426.05,710.00,2847.10,421.05,'2023-02-24 13:17:14'),(241,'1','313',1,'Retail Sale Id 250',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 13:18:22'),(242,'1','313',1,'Retail Sale Id 251',0.00,4235.00,710.00,4970.00,735.00,'2023-02-24 13:19:59'),(243,'1','313',1,'Return of Retail Sale Id 251',4235.00,0.00,710.00,-4970.00,-735.00,'2023-02-24 13:22:49'),(244,'1','313',1,'Retail Sale Id 252',0.00,7260.00,710.00,8520.00,1260.00,'2023-02-24 13:23:43'),(245,'1','313',1,'Retail Sale Id 253',0.00,7260.00,710.00,8520.00,1260.00,'2023-02-24 13:32:34'),(246,'1','313',1,'Retail Sale Id 254',0.00,3630.00,710.00,4260.00,630.00,'2023-02-24 13:39:21'),(247,'1','313',1,'Retail Sale Id 255',0.00,5112.25,710.00,5999.50,887.25,'2023-02-24 13:41:00'),(248,'1','313',1,'Retail Sale Id 256',0.00,2420.00,710.00,2840.00,420.00,'2023-02-24 14:55:35'),(249,'1','313',1,'Retail Sale Id 258',0.00,683.65,710.00,802.30,118.65,'2023-02-24 14:56:31'),(250,'1','313',1,'Retail Sale Id 259',0.00,3630.00,710.00,4260.00,630.00,'2023-02-24 14:57:30'),(251,'1','313',1,'Retail Sale Id 260',0.00,4840.00,710.00,5680.00,840.00,'2023-02-24 14:59:42'),(252,'1','313',1,'Retail Sale Id 261',0.00,3025.00,710.00,3550.00,525.00,'2023-02-24 15:01:10'),(253,'1','313',1,'Retail Sale Id 262',0.00,2420.00,710.00,2840.00,420.00,'2023-02-24 15:01:58'),(254,'1','313',1,'Retail Sale Id 263',0.00,7260.00,710.00,8520.00,1260.00,'2023-02-24 15:03:10'),(255,'1','313',1,'Retail Sale Id 264',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-24 15:04:05'),(256,'1','313',1,'Retail Sale Id 265',0.00,7260.00,710.00,8520.00,1260.00,'2023-02-24 15:05:35'),(257,'1','313',1,'Retail Sale Id 266',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 15:06:38'),(258,'1','313',1,'Retail Sale Id 267',0.00,1210.00,710.00,1420.00,210.00,'2023-02-24 15:07:49'),(259,'1','313',1,'Retail Sale Id 268',0.00,4489.10,710.00,5268.20,779.10,'2023-02-24 15:08:49'),(260,'1','313',1,'Retail Sale Id 269',0.00,2420.00,710.00,2840.00,420.00,'2023-02-24 15:10:28'),(261,'1','313',1,'Retail Sale Id 270',0.00,3025.00,710.00,3550.00,525.00,'2023-02-24 15:11:12'),(262,'1','313',1,'Retail Sale Id 271',0.00,2420.00,710.00,2840.00,420.00,'2023-02-24 15:13:14'),(263,'1','313',1,'Retail Sale Id 272',0.00,605.00,710.00,710.00,105.00,'2023-02-24 15:14:12'),(264,'1','313',1,'Retail Sale Id 273',0.00,1706.10,710.00,2002.20,296.10,'2023-02-24 15:15:34'),(265,'1','313',1,'Retail Sale Id 274',0.00,1210.00,710.00,1420.00,210.00,'2023-02-24 15:16:24'),(266,'1','313',1,'Retail Sale Id 275',0.00,605.00,710.00,710.00,105.00,'2023-02-24 15:17:38'),(267,'1','313',1,'Retail Sale Id 276',0.00,1210.00,710.00,1420.00,210.00,'2023-02-24 15:20:15'),(268,'1','313',1,'Retail Sale Id 277',0.00,1210.00,710.00,1420.00,210.00,'2023-02-24 15:22:21'),(269,'1','313',1,'Retail Sale Id 278',0.00,3025.00,710.00,3550.00,525.00,'2023-02-24 15:24:24'),(270,'1','313',1,'Retail Sale Id 279',0.00,1234.20,710.00,1448.40,214.20,'2023-02-24 15:25:26'),(271,'1','313',1,'Retail Sale Id 280',0.00,1210.00,710.00,1420.00,210.00,'2023-02-24 15:26:43'),(272,'1','313',1,'Retail Sale Id 281',0.00,2559.15,710.00,3003.30,444.15,'2023-02-24 15:27:12'),(273,'1','313',1,'Retail Sale Id 282',0.00,1210.00,710.00,1420.00,210.00,'2023-02-24 15:29:59'),(274,'1','313',1,'Retail Sale Id 283',0.00,6655.00,710.00,7810.00,1155.00,'2023-02-24 15:32:00'),(275,'1','313',1,'Retail Sale Id 284',0.00,3025.00,710.00,3550.00,525.00,'2023-02-24 15:33:28'),(276,'1','313',1,'Retail Sale Id 285',0.00,1210.00,710.00,1420.00,210.00,'2023-02-24 15:37:08'),(277,'1','313',1,'Retail Sale Id 286',0.00,605.00,710.00,710.00,105.00,'2023-02-24 15:37:40'),(278,'1','313',1,'Retail Sale Id 287',0.00,605.00,710.00,710.00,105.00,'2023-02-24 15:38:40'),(279,'1','313',1,'Retail Sale Id 288',0.00,75473.75,670.00,83582.50,8108.75,'2023-02-24 15:39:25'),(280,'1','313',1,'Retail Sale Id 289',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 15:41:16'),(281,'1','313',1,'Retail Sale Id 290',0.00,605.00,710.00,710.00,105.00,'2023-02-24 15:43:37'),(282,'1','313',1,'Retail Sale Id 291',0.00,3025.00,710.00,3550.00,525.00,'2023-02-24 15:44:34'),(283,'1','313',1,'Retail Sale Id 292',0.00,30250.00,670.00,33500.00,3250.00,'2023-02-24 15:45:08'),(284,'1','313',1,'Retail Sale Id 293',0.00,1276.55,710.00,1498.10,221.55,'2023-02-24 15:46:16'),(285,'1','313',1,'Retail Sale Id 294',0.00,3630.00,710.00,4260.00,630.00,'2023-02-24 15:47:24'),(286,'1','313',1,'Retail Sale Id 295',0.00,683.65,710.00,802.30,118.65,'2023-02-24 15:48:22'),(287,'1','313',1,'Retail Sale Id 296',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 15:49:23'),(288,'1','313',1,'Retail Sale Id 297',0.00,35186.80,670.00,38967.20,3780.40,'2023-02-24 15:53:39'),(289,'1','313',1,'Retail Sale Id 298',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 15:56:00'),(290,'1','313',1,'Retail Sale Id 299',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 15:57:58'),(291,'1','313',1,'Retail Sale Id 300',0.00,6050.00,710.00,7100.00,1050.00,'2023-02-24 15:59:06'),(292,'1','313',1,'Retail Sale Id 301',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 16:00:35'),(293,'1','313',1,'Retail Sale Id 302',0.00,641.30,710.00,752.60,111.30,'2023-02-24 16:02:22'),(294,'1','313',1,'Retail Sale Id 303',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 16:03:13'),(295,'1','313',1,'Retail Sale Id 304',0.00,1210.00,710.00,1420.00,210.00,'2023-02-24 16:04:12'),(296,'1','313',1,'Retail Sale Id 305',0.00,1210.00,710.00,1420.00,210.00,'2023-02-24 16:05:16'),(297,'1','313',1,'Retail Sale Id 306',0.00,1875.50,710.00,2201.00,325.50,'2023-02-24 16:08:06'),(298,'1','313',1,'Retail Sale Id 307',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-24 16:08:54'),(299,'1','313',1,'Retail Sale Id 308',0.00,605.00,710.00,710.00,105.00,'2023-02-24 16:09:51'),(300,'1','313',1,'Retail Sale Id 309',0.00,853.05,710.00,1001.10,148.05,'2023-02-24 16:11:08'),(301,'1','313',1,'Retail Sale Id 310',0.00,3630.00,710.00,4260.00,630.00,'2023-02-24 16:13:37'),(302,'1','313',1,'Retail Sale Id 311',0.00,33275.00,670.00,36850.00,3575.00,'2023-02-24 16:14:44'),(303,'1','313',1,'Retail Sale Id 312',0.00,605.00,710.00,710.00,105.00,'2023-02-24 16:15:49'),(304,'1','313',1,'Retail Sale Id 313',0.00,1276.55,710.00,1498.10,221.55,'2023-02-24 16:16:35'),(305,'1','313',1,'Retail Sale Id 314',0.00,641.30,710.00,752.60,111.30,'2023-02-24 16:18:11'),(306,'1','313',1,'Retail Sale Id 315',0.00,2420.00,710.00,2840.00,420.00,'2023-02-24 16:18:52'),(307,'1','313',1,'Retail Sale Id 316',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 16:20:13'),(308,'1','313',1,'Retail Sale Id 317',0.00,2420.00,710.00,2840.00,420.00,'2023-02-24 16:21:27'),(309,'1','313',1,'Retail Sale Id 319',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 16:24:52'),(310,'1','313',1,'Retail Sale Id 320',0.00,2383.70,710.00,2797.40,413.70,'2023-02-24 16:28:11'),(311,'1','313',1,'Retail Sale Id 321',0.00,1210.00,710.00,1420.00,210.00,'2023-02-24 16:30:59'),(312,'1','313',1,'Retail Sale Id 322',0.00,641.30,710.00,752.60,111.30,'2023-02-24 16:32:30'),(313,'1','313',1,'Retail Sale Id 323',0.00,1210.00,710.00,1420.00,210.00,'2023-02-24 16:34:03'),(314,'1','313',1,'Retail Sale Id 325',0.00,641.30,710.00,752.60,111.30,'2023-02-24 16:36:44'),(315,'1','313',1,'Retail Sale Id 326',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 16:38:28'),(316,'1','313',1,'Retail Sale Id 327',0.00,27225.00,670.00,30150.00,2925.00,'2023-02-24 16:40:20'),(317,'1','313',1,'Retail Sale Id 328',0.00,1276.55,710.00,1498.10,221.55,'2023-02-24 16:41:45'),(318,'1','313',1,'Retail Sale Id 329',0.00,1276.55,710.00,1498.10,221.55,'2023-02-24 16:43:19'),(319,'1','313',1,'Retail Sale Id 330',0.00,853.05,710.00,1001.10,148.05,'2023-02-24 16:44:56'),(320,'1','313',1,'Retail Sale Id 331',0.00,683.65,710.00,802.30,118.65,'2023-02-24 16:46:08'),(321,'1','313',1,'Retail Sale Id 332',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 16:47:59'),(322,'1','313',1,'Retail Sale Id 333',0.00,7495.95,710.00,8796.90,1300.95,'2023-02-24 16:50:23'),(323,'1','313',1,'Retail Sale Id 334',0.00,1234.20,710.00,1448.40,214.20,'2023-02-24 16:51:37'),(324,'1','313',1,'Retail Sale Id 335',0.00,3630.00,710.00,4260.00,630.00,'2023-02-24 16:52:43'),(325,'1','313',1,'Retail Sale Id 336',0.00,605.00,710.00,710.00,105.00,'2023-02-24 16:54:11'),(326,'1','313',1,'Retail Sale Id 337',0.00,2117.50,710.00,2485.00,367.50,'2023-02-24 16:55:50'),(327,'1','313',1,'Retail Sale Id 338',0.00,1234.20,710.00,1448.40,214.20,'2023-02-24 16:57:27'),(328,'1','313',1,'Retail Sale Id 339',0.00,35186.80,670.00,38967.20,3780.40,'2023-02-24 16:58:51'),(329,'1','313',1,'Return of Retail Sale Id 339',35186.80,0.00,670.00,-38967.20,-3780.40,'2023-02-24 16:59:35'),(330,'1','313',1,'Retail Sale Id 340',0.00,1022.45,710.00,1199.90,177.45,'2023-02-24 17:00:30'),(331,'1','313',1,'Retail Sale Id 341',0.00,853.05,710.00,1001.10,148.05,'2023-02-24 17:01:36'),(332,'1','313',1,'Retail Sale Id 342',0.00,1276.55,710.00,1498.10,221.55,'2023-02-24 17:02:35'),(333,'1','313',1,'Retail Sale Id 343',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 17:04:42'),(334,'1','313',1,'Retail Sale Id 344',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 17:05:55'),(335,'1','313',1,'Retail Sale Id 345',0.00,641.30,710.00,752.60,111.30,'2023-02-24 17:07:16'),(336,'1','313',1,'Retail Sale Id 346',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 17:08:37'),(337,'1','313',1,'Retail Sale Id 347',0.00,605.00,710.00,710.00,105.00,'2023-02-24 17:09:35'),(338,'1','313',1,'Retail Sale Id 348',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 17:11:10'),(339,'1','313',1,'Retail Sale Id 349',0.00,1234.20,710.00,1448.40,214.20,'2023-02-24 17:13:18'),(340,'1','313',1,'Retail Sale Id 350',0.00,1234.20,710.00,1448.40,214.20,'2023-02-24 17:14:40'),(341,'1','313',1,'Retail Sale Id 351',0.00,641.30,710.00,752.60,111.30,'2023-02-24 17:16:51'),(342,'1','313',1,'Retail Sale Id 352',0.00,1833.15,710.00,2151.30,318.15,'2023-02-24 17:18:45'),(343,'1','313',1,'Retail Sale Id 353',0.00,4259.20,710.00,4998.40,739.20,'2023-02-24 17:19:49'),(344,'1','313',1,'Retail Sale Id 354',0.00,3025.00,710.00,3550.00,525.00,'2023-02-24 17:21:33'),(345,'1','313',1,'Retail Sale Id 355',0.00,641.30,710.00,752.60,111.30,'2023-02-24 17:22:28'),(346,'1','313',1,'Retail Sale Id 356',0.00,1833.15,710.00,2151.30,318.15,'2023-02-24 17:23:48'),(347,'1','313',1,'Retail Sale Id 357',0.00,641.30,710.00,752.60,111.30,'2023-02-24 17:25:11'),(348,'1','313',1,'Retail Sale Id 358',0.00,4259.20,710.00,4998.40,739.20,'2023-02-24 17:29:51'),(349,'1','313',1,'Retail Sale Id 359',0.00,1815.00,710.00,2130.00,315.00,'2023-02-24 17:33:43'),(350,'1','313',1,'Retail Sale Id 360',0.00,9214.15,710.00,10813.30,1599.15,'2023-02-24 17:38:55'),(351,'1','313',1,'Return of Retail Sale Id 360',9214.15,0.00,710.00,-10813.30,-1599.15,'2023-02-24 17:41:27'),(352,'1','313',1,'Retail Sale Id 361',0.00,6655.00,710.00,7810.00,1155.00,'2023-02-24 17:42:30'),(353,'1','313',1,'Retail Sale Id 362',0.00,2559.15,710.00,3003.30,444.15,'2023-02-24 17:45:24'),(354,'1','313',1,'Retail Sale Id 363',0.00,202124.45,710.00,237203.90,35079.45,'2023-02-24 17:54:19'),(355,'1','313',1,'Retail Sale Id 364',0.00,30250.00,670.00,33500.00,3250.00,'2023-02-24 18:07:26'),(356,'1','313',1,'Retail Sale Id 365',0.00,3025.00,710.00,3550.00,525.00,'2023-02-24 18:08:19'),(357,'1','313',1,'Retail Sale Id 366',0.00,36687.20,670.00,40628.80,3941.60,'2023-02-24 18:09:43'),(358,'1','313',1,'Return of Retail Sale Id 289',1815.00,0.00,710.00,-2130.00,-315.00,'2023-02-24 18:11:59'),(359,'1','313',1,'Return of Retail Sale Id 260',4840.00,0.00,710.00,-5680.00,-840.00,'2023-02-24 18:13:39'),(360,'1','313',1,'Retail Sale Id 367',0.00,30250.00,670.00,33500.00,3250.00,'2023-02-24 18:22:05'),(361,'1','313',1,'Return of Retail Sale Id 300',6050.00,0.00,710.00,-7100.00,-1050.00,'2023-02-24 18:42:36'),(362,'1','313',1,'Return of Retail Sale Id 254',3630.00,0.00,710.00,-4260.00,-630.00,'2023-02-24 18:44:19'),(363,'1','313',1,'Retail Sale Id 369',0.00,738.10,710.00,866.20,128.10,'2023-02-24 18:45:56'),(364,'1','313',1,'Return of Retail Sale Id 297',35186.80,0.00,670.00,-38967.20,-3780.40,'2023-02-24 18:55:58'),(365,'1','313',1,'Retail Sale Id 370',0.00,34279.30,670.00,37962.20,3682.90,'2023-02-24 18:56:49'),(366,'1','313',1,'Retail Sale Id 372',0.00,3025.00,710.00,3550.00,525.00,'2023-02-27 07:54:34'),(367,'1','313',1,'Retail Sale Id 373',0.00,6050.00,710.00,7100.00,1050.00,'2023-02-27 07:56:12'),(368,'1','313',1,'Retail Sale Id 374',0.00,3025.00,710.00,3550.00,525.00,'2023-02-27 07:57:15'),(369,'1','313',1,'Retail Sale Id 375',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 07:58:17'),(370,'1','313',1,'Retail Sale Id 376',0.00,605.00,710.00,710.00,105.00,'2023-02-27 07:59:00'),(371,'1','313',1,'Retail Sale Id 377',0.00,4840.00,710.00,5680.00,840.00,'2023-02-27 08:00:12'),(372,'1','313',1,'Retail Sale Id 378',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 08:01:16'),(373,'1','313',1,'Retail Sale Id 379',0.00,72600.00,670.00,80400.00,7800.00,'2023-02-27 08:02:03'),(374,'1','313',1,'Retail Sale Id 380',0.00,611.05,710.00,717.10,106.05,'2023-02-27 08:02:43'),(375,'1','313',1,'Retail Sale Id 381',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 08:03:49'),(376,'1','313',1,'Retail Sale Id 382',0.00,33275.00,670.00,36850.00,3575.00,'2023-02-27 08:05:14'),(377,'1','313',1,'Retail Sale Id 383',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 08:06:26'),(378,'1','313',1,'Retail Sale Id 385',0.00,36015.65,670.00,39885.10,3869.45,'2023-02-27 08:08:16'),(379,'1','313',1,'Retail Sale Id 386',0.00,3025.00,710.00,3550.00,525.00,'2023-02-27 08:08:53'),(380,'1','313',1,'Retail Sale Id 388',0.00,1216.05,710.00,1427.10,211.05,'2023-02-27 08:12:48'),(381,'1','313',1,'Retail Sale Id 389',0.00,37026.00,670.00,41004.00,3978.00,'2023-02-27 08:14:56'),(382,'1','313',1,'Retail Sale Id 390',0.00,30250.00,670.00,33500.00,3250.00,'2023-02-27 08:15:50'),(383,'1','313',1,'Retail Sale Id 391',0.00,27225.00,670.00,30150.00,2925.00,'2023-02-27 08:16:59'),(384,'1','313',1,'Retail Sale Id 392',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 08:18:07'),(385,'1','313',1,'Retail Sale Id 393',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 08:19:30'),(386,'1','313',1,'Retail Sale Id 394',0.00,33275.00,670.00,36850.00,3575.00,'2023-02-27 08:22:37'),(387,'1','313',1,'Retail Sale Id 395',0.00,683.65,710.00,802.30,118.65,'2023-02-27 08:25:48'),(388,'1','313',1,'Retail Sale Id 396',0.00,605.00,710.00,710.00,105.00,'2023-02-27 08:27:42'),(389,'1','313',1,'Retail Sale Id 397',0.00,3932.50,710.00,4615.00,682.50,'2023-02-27 08:29:35'),(390,'1','313',1,'Retail Sale Id 398',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 08:30:44'),(391,'1','313',1,'Retail Sale Id 399',0.00,4259.20,710.00,4998.40,739.20,'2023-02-27 08:31:44'),(392,'1','313',1,'Retail Sale Id 400',0.00,30250.00,670.00,33500.00,3250.00,'2023-02-27 08:34:04'),(393,'1','313',1,'Retail Sale Id 401',0.00,30250.00,670.00,33500.00,3250.00,'2023-02-27 08:35:29'),(394,'1','313',1,'Retail Sale Id 402',0.00,60500.00,670.00,67000.00,6500.00,'2023-02-27 08:38:42'),(395,'1','313',1,'Retail Sale Id 403',0.00,7865.00,710.00,9230.00,1365.00,'2023-02-27 08:40:03'),(396,'1','313',1,'Retail Sale Id 404',0.00,30250.00,670.00,33500.00,3250.00,'2023-02-27 08:42:45'),(397,'1','313',1,'Retail Sale Id 405',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 08:43:55'),(398,'1','313',1,'Retail Sale Id 406',0.00,605.00,710.00,710.00,105.00,'2023-02-27 08:44:50'),(399,'1','313',1,'Retail Sale Id 407',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 08:46:14'),(400,'1','313',1,'Retail Sale Id 408',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 08:46:50'),(401,'1','313',1,'Retail Sale Id 409',0.00,2420.00,710.00,2840.00,420.00,'2023-02-27 08:47:24'),(402,'1','313',1,'Retail Sale Id 410',0.00,605.00,710.00,710.00,105.00,'2023-02-27 08:48:21'),(403,'1','313',1,'Retail Sale Id 411',0.00,3025.00,710.00,3550.00,525.00,'2023-02-27 08:50:16'),(404,'1','313',1,'Retail Sale Id 412',0.00,3630.00,710.00,4260.00,630.00,'2023-02-27 08:52:11'),(405,'1','313',1,'Retail Sale Id 413',0.00,3025.00,710.00,3550.00,525.00,'2023-02-27 08:53:30'),(406,'1','313',1,'Retail Sale Id 414',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 08:55:17'),(407,'1','313',1,'Retail Sale Id 415',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 08:56:17'),(408,'1','313',1,'Retail Sale Id 416',0.00,768.35,710.00,901.70,133.35,'2023-02-27 08:57:52'),(409,'1','313',1,'Retail Sale Id 417',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 09:01:22'),(410,'1','313',1,'Retail Sale Id 418',0.00,3025.00,710.00,3550.00,525.00,'2023-02-27 09:03:26'),(411,'1','313',1,'Retail Sale Id 419',0.00,3025.00,710.00,3550.00,525.00,'2023-02-27 09:05:13'),(412,'1','313',1,'Retail Sale Id 420',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 09:06:06'),(413,'1','313',1,'Retail Sale Id 421',0.00,6050.00,710.00,7100.00,1050.00,'2023-02-27 09:08:11'),(414,'1','313',1,'Retail Sale Id 422',0.00,2420.00,710.00,2840.00,420.00,'2023-02-27 09:09:36'),(415,'1','313',1,'Retail Sale Id 423',0.00,18150.00,670.00,20100.00,1950.00,'2023-02-27 09:13:58'),(416,'1','313',1,'Retail Sale Id 424',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 09:15:35'),(417,'1','313',1,'Retail Sale Id 425',0.00,9075.00,710.00,10650.00,1575.00,'2023-02-27 09:18:59'),(418,'1','313',1,'Retail Sale Id 426',0.00,3932.50,710.00,4615.00,682.50,'2023-02-27 09:20:07'),(419,'1','313',1,'Retail Sale Id 427',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 09:20:56'),(420,'1','313',1,'Retail Sale Id 428',0.00,6050.00,710.00,7100.00,1050.00,'2023-02-27 09:22:03'),(421,'1','313',1,'Retail Sale Id 429',0.00,3630.00,710.00,4260.00,630.00,'2023-02-27 09:22:53'),(422,'1','313',1,'Retail Sale Id 430',0.00,605.00,710.00,710.00,105.00,'2023-02-27 09:25:50'),(423,'1','313',1,'Retail Sale Id 431',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 09:26:53'),(424,'1','313',1,'Retail Sale Id 432',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 09:27:46'),(425,'1','313',1,'Retail Sale Id 433',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 09:29:10'),(426,'1','313',1,'Retail Sale Id 434',0.00,30250.00,670.00,33500.00,3250.00,'2023-02-27 09:31:29'),(427,'1','313',1,'Retail Sale Id 435',0.00,2420.00,710.00,2840.00,420.00,'2023-02-27 09:33:22'),(428,'1','313',1,'Retail Sale Id 436',0.00,3025.00,710.00,3550.00,525.00,'2023-02-27 09:34:54'),(429,'1','313',1,'Retail Sale Id 437',0.00,2420.00,710.00,2840.00,420.00,'2023-02-27 09:36:44'),(430,'1','313',1,'Retail Sale Id 438',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 09:38:30'),(431,'1','313',1,'Retail Sale Id 439',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 09:42:43'),(432,'1','313',1,'Retail Sale Id 440',0.00,3025.00,710.00,3550.00,525.00,'2023-02-27 09:44:18'),(433,'1','313',1,'Retail Sale Id 442',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-27 09:47:46'),(434,'1','313',1,'Retail Sale Id 445',0.00,3630.00,710.00,4260.00,630.00,'2023-02-27 09:54:49'),(435,'1','313',1,'Retail Sale Id 446',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 09:56:15'),(436,'1','313',1,'Retail Sale Id 447',0.00,1234.20,710.00,1448.40,214.20,'2023-02-27 09:58:01'),(437,'1','313',1,'Retail Sale Id 448',0.00,853.05,710.00,1001.10,148.05,'2023-02-27 09:58:59'),(438,'1','313',1,'Retail Sale Id 449',0.00,2420.00,710.00,2840.00,420.00,'2023-02-27 10:00:32'),(439,'1','313',1,'Retail Sale Id 450',0.00,133100.00,670.00,147400.00,14300.00,'2023-02-27 10:02:39'),(440,'1','313',1,'Retail Sale Id 451',0.00,853.05,710.00,1001.10,148.05,'2023-02-27 10:03:39'),(441,'1','313',1,'Retail Sale Id 452',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 10:04:47'),(442,'1','313',1,'Retail Sale Id 453',0.00,786.50,710.00,923.00,136.50,'2023-02-27 10:09:21'),(443,'1','313',1,'Retail Sale Id 455',0.00,181500.00,670.00,201000.00,19500.00,'2023-02-27 10:12:30'),(444,'1','313',1,'Retail Sale Id 456',0.00,605.00,710.00,710.00,105.00,'2023-02-27 10:13:28'),(445,'1','313',1,'Retail Sale Id 457',0.00,27225.00,710.00,31950.00,4725.00,'2023-02-27 10:15:24'),(446,'1','313',1,'Retail Sale Id 458',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 10:16:40'),(447,'1','313',1,'Retail Sale Id 460',0.00,605.00,710.00,710.00,105.00,'2023-02-27 10:19:32'),(448,'1','313',1,'Retail Sale Id 461',0.00,598.95,710.00,702.90,103.95,'2023-02-27 10:21:11'),(449,'1','313',1,'Retail Sale Id 462',0.00,3406.15,710.00,3997.30,591.15,'2023-02-27 10:22:02'),(450,'1','313',1,'Retail Sale Id 463',0.00,2559.15,710.00,3003.30,444.15,'2023-02-27 10:23:41'),(451,'1','313',1,'Retail Sale Id 464',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 10:26:14'),(452,'1','313',1,'Retail Sale Id 465',0.00,60500.00,670.00,67000.00,6500.00,'2023-02-27 10:28:19'),(453,'1','313',1,'Retail Sale Id 466',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 10:30:36'),(454,'1','313',1,'Retail Sale Id 467',0.00,2420.00,710.00,2840.00,420.00,'2023-02-27 10:32:08'),(455,'1','313',1,'Retail Sale Id 468',0.00,2420.00,710.00,2840.00,420.00,'2023-02-27 10:33:46'),(456,'1','313',1,'Retail Sale Id 469',0.00,1276.55,710.00,1498.10,221.55,'2023-02-27 10:38:11'),(457,'1','313',1,'Retail Sale Id 471',0.00,605.00,710.00,710.00,105.00,'2023-02-27 10:42:02'),(458,'1','313',1,'Retail Sale Id 472',0.00,4259.20,710.00,4998.40,739.20,'2023-02-27 10:46:29'),(459,'1','313',1,'Retail Sale Id 473',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 10:48:18'),(460,'1','313',1,'Retail Sale Id 474',0.00,3630.00,710.00,4260.00,630.00,'2023-02-27 10:51:29'),(461,'1','313',1,'Retail Sale Id 475',0.00,4537.50,710.00,5325.00,787.50,'2023-02-27 10:54:15'),(462,'1','313',1,'Retail Sale Id 476',0.00,4235.00,710.00,4970.00,735.00,'2023-02-27 10:59:11'),(463,'1','313',1,'Retail Sale Id 477',0.00,36300.00,670.00,40200.00,3900.00,'2023-02-27 11:02:06'),(464,'1','313',1,'Retail Sale Id 478',0.00,3630.00,710.00,4260.00,630.00,'2023-02-27 11:04:05'),(465,'1','313',1,'Retail Sale Id 479',0.00,36439.15,670.00,40354.10,3914.95,'2023-02-27 11:06:53'),(466,'1','313',1,'Retail Sale Id 481',0.00,36100.35,670.00,39978.90,3878.55,'2023-02-27 11:09:03'),(467,'1','313',1,'Retail Sale Id 482',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 11:11:02'),(468,'1','313',1,'Retail Sale Id 483',0.00,6050.00,710.00,7100.00,1050.00,'2023-02-27 11:12:47'),(469,'1','313',1,'Retail Sale Id 484',0.00,36905.00,670.00,40870.00,3965.00,'2023-02-27 11:14:30'),(470,'1','313',1,'Retail Sale Id 485',0.00,3025.00,710.00,3550.00,525.00,'2023-02-27 11:19:06'),(471,'1','313',1,'Retail Sale Id 486',0.00,605.00,710.00,710.00,105.00,'2023-02-27 11:20:21'),(472,'1','313',1,'Retail Sale Id 487',0.00,4235.00,710.00,4970.00,735.00,'2023-02-27 11:22:42'),(473,'1','313',1,'Retail Sale Id 488',0.00,36348.40,670.00,40253.60,3905.20,'2023-02-27 11:24:52'),(474,'1','313',1,'Retail Sale Id 489',0.00,3630.00,710.00,4260.00,630.00,'2023-02-27 11:26:32'),(475,'1','313',1,'Retail Sale Id 490',0.00,641.30,710.00,752.60,111.30,'2023-02-27 11:27:57'),(476,'1','313',1,'Retail Sale Id 491',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-27 11:29:26'),(477,'1','313',1,'Retail Sale Id 492',0.00,3025.00,710.00,3550.00,525.00,'2023-02-27 11:31:37'),(478,'1','313',1,'Retail Sale Id 493',0.00,3630.00,710.00,4260.00,630.00,'2023-02-27 11:33:02'),(479,'1','313',1,'Retail Sale Id 495',0.00,3630.00,710.00,4260.00,630.00,'2023-02-27 11:38:24'),(480,'1','313',1,'Return of Retail Sale Id 484',36905.00,0.00,670.00,-40870.00,-3965.00,'2023-02-27 11:41:21'),(481,'1','313',1,'Return of Retail Sale Id 477',36300.00,0.00,670.00,-40200.00,-3900.00,'2023-02-27 11:42:05'),(482,'1','313',1,'Retail Sale Id 496',0.00,2420.00,710.00,2840.00,420.00,'2023-02-27 11:46:46'),(483,'1','313',1,'Retail Sale Id 497',0.00,3025.00,710.00,3550.00,525.00,'2023-02-27 11:50:07'),(484,'1','313',1,'Retail Sale Id 499',0.00,6655.00,710.00,7810.00,1155.00,'2023-02-27 11:54:39'),(485,'1','313',1,'Retail Sale Id 500',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 11:55:56'),(486,'1','313',1,'Retail Sale Id 501',0.00,2559.15,710.00,3003.30,444.15,'2023-02-27 12:00:16'),(487,'1','313',1,'Retail Sale Id 502',0.00,3025.00,710.00,3550.00,525.00,'2023-02-27 12:01:42'),(488,'1','313',1,'Retail Sale Id 503',0.00,4235.00,710.00,4970.00,735.00,'2023-02-27 12:08:33'),(489,'1','313',1,'Retail Sale Id 504',0.00,6050.00,710.00,7100.00,1050.00,'2023-02-27 12:16:33'),(490,'1','313',1,'Retail Sale Id 505',0.00,3025.00,710.00,3550.00,525.00,'2023-02-27 12:19:25'),(491,'1','313',1,'Retail Sale Id 506',0.00,26747.05,710.00,31389.10,4642.05,'2023-02-27 12:21:01'),(492,'1','313',1,'Retail Sale Id 507',0.00,605.00,710.00,710.00,105.00,'2023-02-27 12:22:52'),(493,'1','313',1,'Retail Sale Id 509',0.00,641.30,710.00,752.60,111.30,'2023-02-27 12:26:45'),(494,'1','313',1,'Retail Sale Id 510',0.00,641.30,710.00,752.60,111.30,'2023-02-27 12:27:57'),(495,'1','313',1,'Retail Sale Id 511',0.00,641.30,710.00,752.60,111.30,'2023-02-27 12:37:25'),(496,'1','313',1,'Retail Sale Id 512',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 12:38:52'),(497,'1','313',1,'Retail Sale Id 513',0.00,2559.15,710.00,3003.30,444.15,'2023-02-27 12:41:24'),(498,'1','313',1,'Retail Sale Id 514',0.00,14520.00,710.00,17040.00,2520.00,'2023-02-27 12:53:25'),(499,'1','313',1,'Retail Sale Id 515',0.00,3025.00,710.00,3550.00,525.00,'2023-02-27 12:56:18'),(500,'1','313',1,'Retail Sale Id 516',0.00,641.30,710.00,752.60,111.30,'2023-02-27 13:06:37'),(501,'1','313',1,'Retail Sale Id 517',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 13:16:02'),(502,'1','313',1,'Retail Sale Id 518',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 13:19:36'),(503,'1','313',1,'Retail Sale Id 519',0.00,2559.15,710.00,3003.30,444.15,'2023-02-27 13:21:14'),(504,'1','313',1,'Retail Sale Id 520',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 13:24:54'),(505,'1','313',1,'Retail Sale Id 521',0.00,605.00,710.00,710.00,105.00,'2023-02-27 13:26:50'),(506,'1','313',1,'Retail Sale Id 523',0.00,641.30,710.00,752.60,111.30,'2023-02-27 13:29:12'),(507,'1','313',1,'Retail Sale Id 524',0.00,7260.00,710.00,8520.00,1260.00,'2023-02-27 13:37:14'),(508,'1','313',1,'Retail Sale Id 525',0.00,514.25,710.00,603.50,89.25,'2023-02-27 13:42:34'),(509,'1','313',1,'Retail Sale Id 526',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 13:48:16'),(510,'1','313',1,'Retail Sale Id 527',0.00,30250.00,670.00,33500.00,3250.00,'2023-02-27 13:49:45'),(511,'1','313',1,'Retail Sale Id 528',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 13:55:09'),(512,'1','313',1,'Retail Sale Id 529',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 13:57:57'),(513,'1','313',1,'Retail Sale Id 530',0.00,1234.20,710.00,1448.40,214.20,'2023-02-27 13:59:05'),(514,'1','313',1,'Retail Sale Id 531',0.00,1234.20,710.00,1448.40,214.20,'2023-02-27 13:59:58'),(515,'1','313',1,'Retail Sale Id 532',0.00,4537.50,710.00,5325.00,787.50,'2023-02-27 14:08:22'),(516,'1','313',1,'Retail Sale Id 533',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-27 14:09:50'),(517,'1','313',1,'Retail Sale Id 534',0.00,605.00,710.00,710.00,105.00,'2023-02-27 14:10:59'),(518,'1','313',1,'Retail Sale Id 535',0.00,605.00,710.00,710.00,105.00,'2023-02-27 14:11:54'),(519,'1','313',1,'Retail Sale Id 536',0.00,3025.00,710.00,3550.00,525.00,'2023-02-27 14:13:55'),(520,'1','313',1,'Retail Sale Id 538',0.00,1234.20,710.00,1448.40,214.20,'2023-02-27 14:17:27'),(521,'1','313',1,'Retail Sale Id 539',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 14:21:28'),(522,'1','313',1,'Retail Sale Id 540',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-27 14:28:24'),(523,'1','313',1,'Retail Sale Id 541',0.00,3025.00,710.00,3550.00,525.00,'2023-02-27 14:33:12'),(524,'1','313',1,'Retail Sale Id 542',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 14:34:50'),(525,'1','313',1,'Retail Sale Id 543',0.00,72600.00,670.00,80400.00,7800.00,'2023-02-27 14:37:20'),(526,'1','313',1,'Retail Sale Id 544',0.00,3630.00,710.00,4260.00,630.00,'2023-02-27 14:41:03'),(527,'1','313',1,'Retail Sale Id 545',0.00,605.00,710.00,710.00,105.00,'2023-02-27 14:42:50'),(528,'1','313',1,'Retail Sale Id 546',0.00,2420.00,710.00,2840.00,420.00,'2023-02-27 14:44:24'),(529,'1','313',1,'Retail Sale Id 547',0.00,2420.00,710.00,2840.00,420.00,'2023-02-27 14:45:49'),(530,'1','313',1,'Retail Sale Id 548',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 14:51:19'),(531,'1','313',1,'Retail Sale Id 549',0.00,6050.00,710.00,7100.00,1050.00,'2023-02-27 15:02:51'),(532,'1','313',1,'Retail Sale Id 550',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 15:05:11'),(533,'1','313',1,'Retail Sale Id 551',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 15:21:32'),(534,'1','313',1,'Retail Sale Id 552',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 15:25:17'),(535,'1','313',1,'Retail Sale Id 553',0.00,1706.10,710.00,2002.20,296.10,'2023-02-27 15:27:50'),(536,'1','313',1,'Retail Sale Id 554',0.00,605.00,710.00,710.00,105.00,'2023-02-27 15:29:04'),(537,'1','313',1,'Retail Sale Id 555',0.00,39325.00,670.00,43550.00,4225.00,'2023-02-27 15:31:14'),(538,'1','313',1,'Retail Sale Id 556',0.00,8470.00,710.00,9940.00,1470.00,'2023-02-27 15:34:43'),(539,'1','313',1,'Retail Sale Id 557',0.00,605.00,710.00,710.00,105.00,'2023-02-27 15:35:26'),(540,'1','313',1,'Retail Sale Id 558',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 15:36:54'),(541,'1','313',1,'Retail Sale Id 559',0.00,605.00,710.00,710.00,105.00,'2023-02-27 15:39:21'),(542,'1','313',1,'Retail Sale Id 560',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 15:44:22'),(543,'1','313',1,'Retail Sale Id 561',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 15:49:37'),(544,'1','313',1,'Retail Sale Id 562',0.00,2420.00,710.00,2840.00,420.00,'2023-02-27 15:52:25'),(545,'1','313',1,'Retail Sale Id 564',0.00,2420.00,710.00,2840.00,420.00,'2023-02-27 15:56:06'),(546,'1','313',1,'Retail Sale Id 566',0.00,641.30,710.00,752.60,111.30,'2023-02-27 16:14:09'),(547,'1','313',1,'Retail Sale Id 567',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 16:19:55'),(548,'1','313',1,'Retail Sale Id 568',0.00,2420.00,710.00,2840.00,420.00,'2023-02-27 16:22:11'),(549,'1','313',1,'Retail Sale Id 569',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 16:27:51'),(550,'1','313',1,'Retail Sale Id 570',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 16:29:25'),(551,'1','313',1,'Retail Sale Id 571',0.00,3406.15,710.00,3997.30,591.15,'2023-02-27 16:30:54'),(552,'1','313',1,'Retail Sale Id 572',0.00,641.30,710.00,752.60,111.30,'2023-02-27 16:32:06'),(553,'1','313',1,'Retail Sale Id 573',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 16:33:41'),(554,'1','313',1,'Retail Sale Id 574',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 16:35:48'),(555,'1','313',1,'Retail Sale Id 575',0.00,2468.40,710.00,2896.80,428.40,'2023-02-27 16:38:33'),(556,'1','313',1,'Retail Sale Id 576',0.00,2420.00,710.00,2840.00,420.00,'2023-02-27 16:40:25'),(557,'1','313',1,'Retail Sale Id 577',0.00,1833.15,710.00,2151.30,318.15,'2023-02-27 16:41:31'),(558,'1','313',1,'Retail Sale Id 578',0.00,36179.00,670.00,40066.00,3887.00,'2023-02-27 16:44:22'),(559,'1','313',1,'Return of Retail Sale Id 578',36179.00,0.00,670.00,-40066.00,-3887.00,'2023-02-27 16:45:09'),(560,'1','313',1,'Retail Sale Id 579',0.00,36100.35,670.00,39978.90,3878.55,'2023-02-27 16:46:35'),(561,'1','313',1,'Retail Sale Id 580',0.00,30250.00,670.00,33500.00,3250.00,'2023-02-27 16:49:57'),(562,'1','313',1,'Retail Sale Id 581',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 16:52:39'),(563,'1','313',1,'Retail Sale Id 582',0.00,36179.00,670.00,40066.00,3887.00,'2023-02-27 16:53:43'),(564,'1','313',1,'Retail Sale Id 583',0.00,605.00,710.00,710.00,105.00,'2023-02-27 16:55:01'),(565,'1','313',1,'Retail Sale Id 585',0.00,605.00,710.00,710.00,105.00,'2023-02-27 16:56:55'),(566,'1','313',1,'Retail Sale Id 586',0.00,605.00,710.00,710.00,105.00,'2023-02-27 16:57:55'),(567,'1','313',1,'Retail Sale Id 587',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 16:59:28'),(568,'1','313',1,'Retail Sale Id 588',0.00,641.30,710.00,752.60,111.30,'2023-02-27 17:00:48'),(569,'1','313',1,'Retail Sale Id 589',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 17:02:31'),(570,'1','313',1,'Retail Sale Id 590',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 17:04:00'),(571,'1','313',1,'Retail Sale Id 591',0.00,3025.00,710.00,3550.00,525.00,'2023-02-27 17:05:07'),(572,'1','313',1,'Retail Sale Id 592',0.00,4235.00,710.00,4970.00,735.00,'2023-02-27 17:06:07'),(573,'1','313',1,'Return of Retail Sale Id 579',36100.35,0.00,670.00,-39978.90,-3878.55,'2023-02-27 17:11:48'),(574,'1','313',1,'Retail Sale Id 593',0.00,3630.00,710.00,4260.00,630.00,'2023-02-27 17:14:00'),(575,'1','313',1,'Retail Sale Id 594',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-27 17:15:50'),(576,'1','313',1,'Retail Sale Id 595',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 17:17:19'),(577,'1','313',1,'Retail Sale Id 596',0.00,641.30,710.00,752.60,111.30,'2023-02-27 17:18:53'),(578,'1','313',1,'Retail Sale Id 597',0.00,629.20,710.00,738.40,109.20,'2023-02-27 17:20:08'),(579,'1','313',1,'Retail Sale Id 598',0.00,853.05,710.00,1001.10,148.05,'2023-02-27 17:20:53'),(580,'1','313',1,'Retail Sale Id 599',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 17:21:45'),(581,'1','313',1,'Retail Sale Id 600',0.00,4235.00,710.00,4970.00,735.00,'2023-02-27 17:23:14'),(582,'1','313',1,'Retail Sale Id 601',0.00,3025.00,710.00,3550.00,525.00,'2023-02-27 17:27:34'),(583,'1','313',1,'Retail Sale Id 602',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 17:28:36'),(584,'1','313',1,'Retail Sale Id 603',0.00,1706.10,710.00,2002.20,296.10,'2023-02-27 17:31:36'),(585,'1','313',1,'Retail Sale Id 604',0.00,1276.55,710.00,1498.10,221.55,'2023-02-27 17:33:23'),(586,'1','313',1,'Retail Sale Id 606',0.00,2982.65,710.00,3500.30,517.65,'2023-02-27 17:35:45'),(587,'1','313',1,'Retail Sale Id 607',0.00,1875.50,710.00,2201.00,325.50,'2023-02-27 17:37:16'),(588,'1','313',1,'Retail Sale Id 608',0.00,1833.15,710.00,2151.30,318.15,'2023-02-27 17:38:18'),(589,'1','313',1,'Return of Retail Sale Id 603',1706.10,0.00,710.00,-2002.20,-296.10,'2023-02-27 17:39:28'),(590,'1','313',1,'Retail Sale Id 609',0.00,2129.60,710.00,2499.20,369.60,'2023-02-27 17:42:41'),(591,'1','313',1,'Retail Sale Id 611',0.00,5112.25,710.00,5999.50,887.25,'2023-02-27 17:48:38'),(592,'1','313',1,'Retail Sale Id 612',0.00,1815.00,710.00,2130.00,315.00,'2023-02-27 17:50:42'),(593,'1','313',1,'Retail Sale Id 613',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 17:51:46'),(594,'1','313',1,'Retail Sale Id 614',0.00,1210.00,710.00,1420.00,210.00,'2023-02-27 17:53:09'),(595,'1','313',1,'Return of Retail Sale Id 506',26747.05,0.00,710.00,-31389.10,-4642.05,'2023-02-27 18:07:58'),(596,'1','313',1,'Retail Sale Id 615',0.00,24962.30,670.00,27644.20,2681.90,'2023-02-27 18:09:01'),(597,'1','313',1,'Retail Sale Id 616',0.00,1615.35,670.00,1788.90,173.55,'2023-02-27 18:13:13'),(598,'1','313',1,'Retail Sale Id 617',0.00,248.05,710.00,291.10,43.05,'2023-02-27 18:17:11'),(599,'1','313',1,'Retail Sale Id 618',0.00,605.00,710.00,710.00,105.00,'2023-02-28 07:54:11'),(600,'1','313',1,'Retail Sale Id 619',0.00,641.30,710.00,752.60,111.30,'2023-02-28 07:55:22'),(601,'1','313',1,'Retail Sale Id 620',0.00,605.00,710.00,710.00,105.00,'2023-02-28 07:57:05'),(602,'1','313',1,'Retail Sale Id 621',0.00,3025.00,710.00,3550.00,525.00,'2023-02-28 07:58:15'),(603,'1','313',1,'Retail Sale Id 622',0.00,605.00,710.00,710.00,105.00,'2023-02-28 08:00:16'),(604,'1','313',1,'Retail Sale Id 623',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-28 08:02:33'),(605,'1','313',1,'Retail Sale Id 624',0.00,9075.00,710.00,10650.00,1575.00,'2023-02-28 08:04:14'),(606,'1','313',1,'Retail Sale Id 625',0.00,6050.00,710.00,7100.00,1050.00,'2023-02-28 08:05:21'),(607,'1','313',1,'Retail Sale Id 626',0.00,30250.00,670.00,33500.00,3250.00,'2023-02-28 08:07:13'),(608,'1','313',1,'Retail Sale Id 627',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 08:09:05'),(609,'1','313',1,'Retail Sale Id 628',0.00,35991.45,670.00,39858.30,3866.85,'2023-02-28 08:11:29'),(610,'1','313',1,'Retail Sale Id 629',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-28 08:13:46'),(611,'1','313',1,'Retail Sale Id 630',0.00,1815.00,710.00,2130.00,315.00,'2023-02-28 08:16:49'),(612,'1','313',1,'Retail Sale Id 631',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 08:19:45'),(613,'1','313',1,'Retail Sale Id 632',0.00,605.00,710.00,710.00,105.00,'2023-02-28 08:20:36'),(614,'1','313',1,'Retail Sale Id 633',0.00,3025.00,710.00,3550.00,525.00,'2023-02-28 08:21:48'),(615,'1','313',1,'Retail Sale Id 634',0.00,3025.00,710.00,3550.00,525.00,'2023-02-28 08:22:47'),(616,'1','313',1,'Retail Sale Id 635',0.00,72600.00,670.00,80400.00,7800.00,'2023-02-28 08:25:57'),(617,'1','313',1,'Retail Sale Id 636',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 08:28:47'),(618,'1','313',1,'Retail Sale Id 637',0.00,2044.90,710.00,2399.80,354.90,'2023-02-28 08:30:33'),(619,'1','313',1,'Retail Sale Id 638',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 08:31:57'),(620,'1','313',1,'Retail Sale Id 639',0.00,1833.15,710.00,2151.30,318.15,'2023-02-28 08:33:55'),(621,'1','313',1,'Retail Sale Id 640',0.00,641.30,710.00,752.60,111.30,'2023-02-28 08:35:48'),(622,'1','313',1,'Retail Sale Id 641',0.00,3025.00,710.00,3550.00,525.00,'2023-02-28 08:37:23'),(623,'1','313',1,'Retail Sale Id 642',0.00,121000.00,670.00,134000.00,13000.00,'2023-02-28 08:46:59'),(624,'1','313',1,'Retail Sale Id 643',0.00,3630.00,710.00,4260.00,630.00,'2023-02-28 08:51:38'),(625,'1','313',1,'Retail Sale Id 644',0.00,605.00,710.00,710.00,105.00,'2023-02-28 08:52:55'),(626,'1','313',1,'Retail Sale Id 645',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-28 08:56:34'),(627,'1','313',1,'Retail Sale Id 646',0.00,2420.00,710.00,2840.00,420.00,'2023-02-28 08:58:17'),(628,'1','313',1,'Retail Sale Id 647',0.00,605.00,710.00,710.00,105.00,'2023-02-28 09:01:56'),(629,'1','313',1,'Retail Sale Id 648',0.00,4840.00,710.00,5680.00,840.00,'2023-02-28 09:08:42'),(630,'1','313',1,'Retail Sale Id 649',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 09:13:14'),(631,'1','313',1,'Retail Sale Id 650',0.00,641.30,710.00,752.60,111.30,'2023-02-28 09:14:19'),(632,'1','313',1,'Retail Sale Id 651',0.00,641.30,710.00,752.60,111.30,'2023-02-28 09:15:11'),(633,'1','313',1,'Retail Sale Id 652',0.00,3025.00,710.00,3550.00,525.00,'2023-02-28 09:16:36'),(634,'1','313',1,'Retail Sale Id 654',0.00,605.00,710.00,710.00,105.00,'2023-02-28 09:24:47'),(635,'1','313',1,'Retail Sale Id 655',0.00,605.00,710.00,710.00,105.00,'2023-02-28 09:25:54'),(636,'1','313',1,'Retail Sale Id 656',0.00,1815.00,710.00,2130.00,315.00,'2023-02-28 09:31:20'),(637,'1','313',1,'Retail Sale Id 657',0.00,853.05,710.00,1001.10,148.05,'2023-02-28 09:32:22'),(638,'1','313',1,'Retail Sale Id 658',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 09:35:52'),(639,'1','313',1,'Retail Sale Id 659',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 09:39:52'),(640,'1','313',1,'Retail Sale Id 660',0.00,1815.00,710.00,2130.00,315.00,'2023-02-28 09:41:57'),(641,'1','313',1,'Retail Sale Id 663',0.00,1234.20,710.00,1448.40,214.20,'2023-02-28 09:46:57'),(642,'1','313',1,'Retail Sale Id 665',0.00,2420.00,710.00,2840.00,420.00,'2023-02-28 09:48:49'),(643,'1','313',1,'Retail Sale Id 666',0.00,605.00,710.00,710.00,105.00,'2023-02-28 09:50:57'),(644,'1','313',1,'Retail Sale Id 667',0.00,4235.00,710.00,4970.00,735.00,'2023-02-28 09:52:02'),(645,'1','313',1,'Retail Sale Id 668',0.00,605.00,710.00,710.00,105.00,'2023-02-28 09:53:21'),(646,'1','313',1,'Retail Sale Id 669',0.00,598.95,710.00,702.90,103.95,'2023-02-28 09:54:29'),(647,'1','313',1,'Retail Sale Id 670',0.00,605.00,710.00,710.00,105.00,'2023-02-28 09:55:30'),(648,'1','313',1,'Retail Sale Id 671',0.00,605.00,710.00,710.00,105.00,'2023-02-28 09:57:35'),(649,'1','313',1,'Retail Sale Id 672',0.00,1815.00,710.00,2130.00,315.00,'2023-02-28 09:58:33'),(650,'1','313',1,'Retail Sale Id 673',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 10:01:34'),(651,'1','313',1,'Retail Sale Id 674',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 10:03:22'),(652,'1','313',1,'Retail Sale Id 675',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 10:44:54'),(653,'1','313',1,'Retail Sale Id 676',0.00,3025.00,710.00,3550.00,525.00,'2023-02-28 10:46:21'),(654,'1','313',1,'Retail Sale Id 678',0.00,2420.00,710.00,2840.00,420.00,'2023-02-28 10:47:49'),(655,'1','313',1,'Retail Sale Id 679',0.00,4235.00,710.00,4970.00,735.00,'2023-02-28 10:49:36'),(656,'1','313',1,'Retail Sale Id 680',0.00,2559.15,710.00,3003.30,444.15,'2023-02-28 10:50:57'),(657,'1','313',1,'Retail Sale Id 681',0.00,1706.10,710.00,2002.20,296.10,'2023-02-28 10:51:57'),(658,'1','313',1,'Retail Sale Id 682',0.00,1706.10,710.00,2002.20,296.10,'2023-02-28 10:52:45'),(659,'1','313',1,'Retail Sale Id 683',0.00,605.00,710.00,710.00,105.00,'2023-02-28 10:54:01'),(660,'1','313',1,'Retail Sale Id 684',0.00,4235.00,710.00,4970.00,735.00,'2023-02-28 10:55:18'),(661,'1','313',1,'Retail Sale Id 686',0.00,6655.00,710.00,7810.00,1155.00,'2023-02-28 10:57:53'),(662,'1','313',1,'Retail Sale Id 687',0.00,26638.15,670.00,29500.10,2861.95,'2023-02-28 11:00:10'),(663,'1','313',1,'Retail Sale Id 688',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 11:01:35'),(664,'1','313',1,'Retail Sale Id 689',0.00,3630.00,710.00,4260.00,630.00,'2023-02-28 11:02:56'),(665,'1','313',1,'Retail Sale Id 690',0.00,2129.60,710.00,2499.20,369.60,'2023-02-28 11:04:07'),(666,'1','313',1,'Retail Sale Id 691',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-28 11:05:41'),(667,'1','313',1,'Retail Sale Id 692',0.00,641.30,710.00,752.60,111.30,'2023-02-28 11:07:11'),(668,'1','313',1,'Retail Sale Id 694',0.00,75364.85,670.00,83461.90,8097.05,'2023-02-28 11:11:29'),(669,'1','313',1,'Retail Sale Id 696',0.00,7260.00,710.00,8520.00,1260.00,'2023-02-28 11:18:15'),(670,'1','313',1,'Retail Sale Id 697',0.00,4235.00,710.00,4970.00,735.00,'2023-02-28 11:19:29'),(671,'1','313',1,'Retail Sale Id 698',0.00,1815.00,710.00,2130.00,315.00,'2023-02-28 11:22:21'),(672,'1','313',1,'Retail Sale Id 699',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-28 11:23:53'),(673,'1','313',1,'Retail Sale Id 700',0.00,2559.15,710.00,3003.30,444.15,'2023-02-28 11:25:47'),(674,'1','313',1,'Retail Sale Id 702',0.00,3581.60,710.00,4203.20,621.60,'2023-02-28 11:28:27'),(675,'1','313',1,'Retail Sale Id 703',0.00,1234.20,710.00,1448.40,214.20,'2023-02-28 11:29:53'),(676,'1','313',1,'Retail Sale Id 704',0.00,1234.20,710.00,1448.40,214.20,'2023-02-28 11:30:57'),(677,'1','313',1,'Retail Sale Id 705',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 11:32:59'),(678,'1','313',1,'Retail Sale Id 706',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-28 11:34:06'),(679,'1','313',1,'Retail Sale Id 707',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 11:35:39'),(680,'1','313',1,'Retail Sale Id 708',0.00,4235.00,710.00,4970.00,735.00,'2023-02-28 11:38:31'),(681,'1','313',1,'Retail Sale Id 709',0.00,30250.00,670.00,33500.00,3250.00,'2023-02-28 11:40:58'),(682,'1','313',1,'Retail Sale Id 710',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 11:42:47'),(683,'1','313',1,'Retail Sale Id 711',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 11:43:59'),(684,'1','313',1,'Retail Sale Id 712',0.00,6050.00,710.00,7100.00,1050.00,'2023-02-28 11:44:48'),(685,'1','313',1,'Retail Sale Id 713',0.00,605.00,710.00,710.00,105.00,'2023-02-28 11:46:33'),(686,'1','313',1,'Retail Sale Id 714',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 11:48:03'),(687,'1','313',1,'Retail Sale Id 715',0.00,3630.00,710.00,4260.00,630.00,'2023-02-28 11:49:43'),(688,'1','313',1,'Retail Sale Id 716',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 11:51:11'),(689,'1','313',1,'Retail Sale Id 717',0.00,4235.00,710.00,4970.00,735.00,'2023-02-28 11:56:28'),(690,'1','313',1,'Retail Sale Id 718',0.00,1815.00,710.00,2130.00,315.00,'2023-02-28 11:59:01'),(691,'1','313',1,'Retail Sale Id 719',0.00,1833.15,710.00,2151.30,318.15,'2023-02-28 12:00:49'),(692,'1','313',1,'Retail Sale Id 720',0.00,605.00,710.00,710.00,105.00,'2023-02-28 12:02:04'),(693,'1','313',1,'Retail Sale Id 721',0.00,641.30,710.00,752.60,111.30,'2023-02-28 12:07:56'),(694,'1','313',1,'Retail Sale Id 722',0.00,3025.00,710.00,3550.00,525.00,'2023-02-28 12:09:23'),(695,'1','313',1,'Retail Sale Id 723',0.00,3025.00,710.00,3550.00,525.00,'2023-02-28 12:10:39'),(696,'1','313',1,'Retail Sale Id 724',0.00,36088.25,670.00,39965.50,3877.25,'2023-02-28 12:13:21'),(697,'1','313',1,'Retail Sale Id 725',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 12:18:06'),(698,'1','313',1,'Retail Sale Id 726',0.00,36953.40,670.00,40923.60,3970.20,'2023-02-28 12:32:27'),(699,'1','313',1,'Retail Sale Id 727',0.00,10587.50,710.00,12425.00,1837.50,'2023-02-28 12:35:34'),(700,'1','313',1,'Retail Sale Id 728',0.00,1234.20,710.00,1448.40,214.20,'2023-02-28 12:37:57'),(701,'1','313',1,'Retail Sale Id 729',0.00,641.30,710.00,752.60,111.30,'2023-02-28 12:39:06'),(702,'1','313',1,'Retail Sale Id 730',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 12:40:07'),(703,'1','313',1,'Retail Sale Id 731',0.00,1234.20,710.00,1448.40,214.20,'2023-02-28 12:47:43'),(704,'1','313',1,'Retail Sale Id 732',0.00,1815.00,710.00,2130.00,315.00,'2023-02-28 12:49:11'),(705,'1','313',1,'Retail Sale Id 733',0.00,5445.00,710.00,6390.00,945.00,'2023-02-28 12:53:55'),(706,'1','313',1,'Retail Sale Id 734',0.00,6050.00,710.00,7100.00,1050.00,'2023-02-28 12:55:30'),(707,'1','313',1,'Retail Sale Id 735',0.00,611.05,710.00,717.10,106.05,'2023-02-28 13:00:28'),(708,'1','313',1,'Retail Sale Id 736',0.00,2420.00,710.00,2840.00,420.00,'2023-02-28 13:16:36'),(709,'1','313',1,'Retail Sale Id 737',0.00,1815.00,710.00,2130.00,315.00,'2023-02-28 13:18:15'),(710,'1','313',1,'Return of Retail Sale Id 736',2420.00,0.00,710.00,-2840.00,-420.00,'2023-02-28 13:21:49'),(711,'1','313',1,'Retail Sale Id 738',0.00,605.00,710.00,710.00,105.00,'2023-02-28 13:22:35'),(712,'1','313',1,'Retail Sale Id 739',0.00,3025.00,710.00,3550.00,525.00,'2023-02-28 13:32:12'),(713,'1','313',1,'Retail Sale Id 740',0.00,4259.20,710.00,4998.40,739.20,'2023-02-28 13:38:58'),(714,'1','313',1,'Retail Sale Id 741',0.00,4259.20,710.00,4998.40,739.20,'2023-02-28 13:40:38'),(715,'1','313',1,'Retail Sale Id 742',0.00,2559.15,710.00,3003.30,444.15,'2023-02-28 13:42:34'),(716,'1','313',1,'Retail Sale Id 743',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-28 13:45:11'),(717,'1','313',1,'Retail Sale Id 744',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-28 13:46:17'),(718,'1','313',1,'Retail Sale Id 745',0.00,7865.00,710.00,9230.00,1365.00,'2023-02-28 13:47:24'),(719,'1','313',1,'Retail Sale Id 746',0.00,3630.00,710.00,4260.00,630.00,'2023-02-28 13:52:08'),(720,'1','313',1,'Retail Sale Id 747',0.00,2420.00,710.00,2840.00,420.00,'2023-02-28 13:53:34'),(721,'1','313',1,'Retail Sale Id 748',0.00,1815.00,710.00,2130.00,315.00,'2023-02-28 13:58:17'),(722,'1','313',1,'Retail Sale Id 749',0.00,605.00,710.00,710.00,105.00,'2023-02-28 14:00:13'),(723,'1','313',1,'Retail Sale Id 750',0.00,14520.00,710.00,17040.00,2520.00,'2023-02-28 14:01:53'),(724,'1','313',1,'Retail Sale Id 752',0.00,1815.00,710.00,2130.00,315.00,'2023-02-28 14:04:57'),(725,'1','313',1,'Retail Sale Id 753',0.00,2420.00,710.00,2840.00,420.00,'2023-02-28 14:06:26'),(726,'1','313',1,'Retail Sale Id 754',0.00,5112.25,710.00,5999.50,887.25,'2023-02-28 14:07:41'),(727,'1','313',1,'Retail Sale Id 755',0.00,4398.35,710.00,5161.70,763.35,'2023-02-28 14:14:44'),(728,'1','313',1,'Retail Sale Id 756',0.00,641.30,710.00,752.60,111.30,'2023-02-28 14:17:20'),(729,'1','313',1,'Retail Sale Id 758',0.00,90750.00,670.00,100500.00,9750.00,'2023-02-28 14:20:57'),(730,'1','313',1,'Retail Sale Id 759',0.00,598.95,710.00,702.90,103.95,'2023-02-28 14:24:40'),(731,'1','313',1,'Retail Sale Id 760',0.00,641.30,710.00,752.60,111.30,'2023-02-28 14:28:16'),(732,'1','313',1,'Return of Retail Sale Id 754',5112.25,0.00,710.00,-5999.50,-887.25,'2023-02-28 14:31:07'),(733,'1','313',1,'Retail Sale Id 761',0.00,1833.15,710.00,2151.30,318.15,'2023-02-28 14:42:38'),(734,'1','313',1,'Retail Sale Id 762',0.00,2420.00,710.00,2840.00,420.00,'2023-02-28 14:47:06'),(735,'1','313',1,'Retail Sale Id 763',0.00,1234.20,710.00,1448.40,214.20,'2023-02-28 14:52:46'),(736,'1','313',1,'Retail Sale Id 764',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-28 14:54:12'),(737,'1','313',1,'Retail Sale Id 765',0.00,1234.20,710.00,1448.40,214.20,'2023-02-28 15:08:08'),(738,'1','313',1,'Retail Sale Id 766',0.00,641.30,710.00,752.60,111.30,'2023-02-28 15:09:56'),(739,'1','313',1,'Retail Sale Id 767',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 15:12:02'),(740,'1','313',1,'Retail Sale Id 768',0.00,1234.20,710.00,1448.40,214.20,'2023-02-28 15:16:14'),(741,'1','313',1,'Retail Sale Id 769',0.00,2129.60,710.00,2499.20,369.60,'2023-02-28 15:18:54'),(742,'1','313',1,'Retail Sale Id 770',0.00,7260.00,710.00,8520.00,1260.00,'2023-02-28 15:20:42'),(743,'1','313',1,'Retail Sale Id 771',0.00,605.00,710.00,710.00,105.00,'2023-02-28 15:21:59'),(744,'1','313',1,'Retail Sale Id 772',0.00,605.00,710.00,710.00,105.00,'2023-02-28 15:22:48'),(745,'1','313',1,'Retail Sale Id 773',0.00,1875.50,710.00,2201.00,325.50,'2023-02-28 15:24:59'),(746,'1','313',1,'Retail Sale Id 774',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 15:26:15'),(747,'1','313',1,'Retail Sale Id 775',0.00,641.30,710.00,752.60,111.30,'2023-02-28 15:27:21'),(748,'1','313',1,'Retail Sale Id 776',0.00,4259.20,710.00,4998.40,739.20,'2023-02-28 15:34:23'),(749,'1','313',1,'Retail Sale Id 777',0.00,605.00,710.00,710.00,105.00,'2023-02-28 15:35:24'),(750,'1','313',1,'Retail Sale Id 778',0.00,1815.00,710.00,2130.00,315.00,'2023-02-28 15:49:55'),(751,'1','313',1,'Retail Sale Id 779',0.00,4840.00,710.00,5680.00,840.00,'2023-02-28 15:54:40'),(752,'1','313',1,'Retail Sale Id 780',0.00,71390.00,670.00,79060.00,7670.00,'2023-02-28 16:00:10'),(753,'1','313',1,'Retail Sale Id 781',0.00,4259.20,710.00,4998.40,739.20,'2023-02-28 16:06:49'),(754,'1','313',1,'Retail Sale Id 782',0.00,605.00,710.00,710.00,105.00,'2023-02-28 16:08:50'),(755,'1','313',1,'Retail Sale Id 783',0.00,4259.20,710.00,4998.40,739.20,'2023-02-28 16:09:52'),(756,'1','313',1,'Retail Sale Id 784',0.00,36300.00,670.00,40200.00,3900.00,'2023-02-28 16:13:46'),(757,'1','313',1,'Retail Sale Id 785',0.00,6050.00,710.00,7100.00,1050.00,'2023-02-28 16:15:41'),(758,'1','313',1,'Retail Sale Id 786',0.00,1706.10,710.00,2002.20,296.10,'2023-02-28 16:18:03'),(759,'1','313',1,'Retail Sale Id 787',0.00,7260.00,710.00,8520.00,1260.00,'2023-02-28 16:20:25'),(760,'1','313',1,'Retail Sale Id 788',0.00,2420.00,710.00,2840.00,420.00,'2023-02-28 16:21:36'),(761,'1','313',1,'Retail Sale Id 789',0.00,3406.15,710.00,3997.30,591.15,'2023-02-28 16:23:28'),(762,'1','313',1,'Retail Sale Id 790',0.00,4235.00,710.00,4970.00,735.00,'2023-02-28 16:25:57'),(763,'1','313',1,'Retail Sale Id 791',0.00,7260.00,710.00,8520.00,1260.00,'2023-02-28 16:27:25'),(764,'1','313',1,'Retail Sale Id 792',0.00,605.00,710.00,710.00,105.00,'2023-02-28 16:28:44'),(765,'1','313',1,'Retail Sale Id 793',0.00,2420.00,710.00,2840.00,420.00,'2023-02-28 16:29:53'),(766,'1','313',1,'Retail Sale Id 794',0.00,3974.85,710.00,4664.70,689.85,'2023-02-28 16:33:50'),(767,'1','313',1,'Retail Sale Id 795',0.00,60500.00,670.00,67000.00,6500.00,'2023-02-28 16:36:25'),(768,'1','313',1,'Retail Sale Id 796',0.00,36300.00,670.00,40200.00,3900.00,'2023-02-28 16:38:16'),(769,'1','313',1,'Retail Sale Id 797',0.00,3630.00,710.00,4260.00,630.00,'2023-02-28 16:39:30'),(770,'1','313',1,'Retail Sale Id 798',0.00,7562.50,710.00,8875.00,1312.50,'2023-02-28 16:42:13'),(771,'1','313',1,'Retail Sale Id 799',0.00,3025.00,710.00,3550.00,525.00,'2023-02-28 16:44:09'),(772,'1','313',1,'Retail Sale Id 800',0.00,5965.30,710.00,7000.60,1035.30,'2023-02-28 16:45:35'),(773,'1','313',1,'Retail Sale Id 801',0.00,29645.00,670.00,32830.00,3185.00,'2023-02-28 16:46:48'),(774,'1','313',1,'Retail Sale Id 802',0.00,641.30,710.00,752.60,111.30,'2023-02-28 16:48:12'),(775,'1','313',1,'Retail Sale Id 803',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 16:52:18'),(776,'1','313',1,'Retail Sale Id 805',0.00,3630.00,710.00,4260.00,630.00,'2023-02-28 16:59:26'),(777,'1','313',1,'Retail Sale Id 806',0.00,5965.30,710.00,7000.60,1035.30,'2023-02-28 17:00:47'),(778,'1','313',1,'Retail Sale Id 807',0.00,2559.15,710.00,3003.30,444.15,'2023-02-28 17:02:28'),(779,'1','313',1,'Retail Sale Id 808',0.00,2420.00,710.00,2840.00,420.00,'2023-02-28 17:04:05'),(780,'1','313',1,'Retail Sale Id 809',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 17:05:08'),(781,'1','313',1,'Retail Sale Id 810',0.00,683.65,710.00,802.30,118.65,'2023-02-28 17:06:39'),(782,'1','313',1,'Retail Sale Id 811',0.00,1815.00,710.00,2130.00,315.00,'2023-02-28 17:07:42'),(783,'1','313',1,'Retail Sale Id 812',0.00,3932.50,710.00,4615.00,682.50,'2023-02-28 17:09:09'),(784,'1','313',1,'Retail Sale Id 813',0.00,72600.00,670.00,80400.00,7800.00,'2023-02-28 17:11:35'),(785,'1','313',1,'Retail Sale Id 814',0.00,1815.00,710.00,2130.00,315.00,'2023-02-28 17:13:12'),(786,'1','313',1,'Retail Sale Id 815',0.00,3025.00,710.00,3550.00,525.00,'2023-02-28 17:14:28'),(787,'1','313',1,'Retail Sale Id 816',0.00,2420.00,710.00,2840.00,420.00,'2023-02-28 17:18:42'),(788,'1','313',1,'Retail Sale Id 817',0.00,1210.00,710.00,1420.00,210.00,'2023-02-28 17:19:35'),(789,'1','313',1,'Return of Retail Sale Id 814',1815.00,0.00,710.00,-2130.00,-315.00,'2023-02-28 17:21:03'),(790,'1','313',1,'Return of Retail Sale Id 800',5965.30,0.00,710.00,-7000.60,-1035.30,'2023-02-28 17:23:05'),(791,'1','313',1,'Retail Sale Id 818',0.00,683.65,710.00,802.30,118.65,'2023-02-28 17:24:21'),(792,'1','313',1,'Retail Sale Id 819',0.00,36511.75,670.00,40434.50,3922.75,'2023-02-28 17:25:31'),(793,'1','313',1,'Retail Sale Id 820',0.00,9377.50,710.00,11005.00,1627.50,'2023-02-28 17:27:29'),(794,'1','313',1,'Return of Retail Sale Id 790',4235.00,0.00,710.00,-4970.00,-735.00,'2023-02-28 17:29:19'),(795,'1','313',1,'Return of Retail Sale Id 785',6050.00,0.00,710.00,-7100.00,-1050.00,'2023-02-28 17:48:11'),(796,'1','313',1,'Retail Sale Id 821',0.00,5535.75,710.00,6496.50,960.75,'2023-02-28 17:49:08'),(797,'1','313',1,'Return of Retail Sale Id 687',26638.15,0.00,670.00,-29500.10,-2861.95,'2023-02-28 17:52:01'),(798,'1','313',1,'Retail Sale Id 822',0.00,26492.95,670.00,29339.30,2846.35,'2023-02-28 17:52:58'),(799,'1','313',1,'Retail Sale Id 823',0.00,605.00,710.00,710.00,105.00,'2023-03-01 08:23:28'),(800,'1','313',1,'Retail Sale Id 824',0.00,2420.00,710.00,2840.00,420.00,'2023-03-01 08:23:56'),(801,'1','313',1,'Retail Sale Id 825',0.00,66550.00,670.00,73700.00,7150.00,'2023-03-01 08:26:25'),(802,'1','313',1,'Retail Sale Id 826',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-01 08:28:20'),(803,'1','313',1,'Retail Sale Id 827',0.00,2420.00,710.00,2840.00,420.00,'2023-03-01 08:29:53'),(804,'1','313',1,'Retail Sale Id 828',0.00,7925.50,710.00,9301.00,1375.50,'2023-03-01 08:31:33'),(805,'1','313',1,'Retail Sale Id 829',0.00,1210.00,710.00,1420.00,210.00,'2023-03-01 08:32:56'),(806,'1','313',1,'Retail Sale Id 830',0.00,3025.00,710.00,3550.00,525.00,'2023-03-01 08:34:49'),(807,'1','313',1,'Retail Sale Id 831',0.00,10708.50,670.00,11859.00,1150.50,'2023-03-01 08:36:24'),(808,'1','313',1,'Retail Sale Id 832',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-01 08:37:20'),(809,'1','313',1,'Retail Sale Id 833',0.00,3025.00,710.00,3550.00,525.00,'2023-03-01 08:38:42'),(810,'1','313',1,'Retail Sale Id 834',0.00,4235.00,710.00,4970.00,735.00,'2023-03-01 08:40:46'),(811,'1','313',1,'Retail Sale Id 835',0.00,641.30,710.00,752.60,111.30,'2023-03-01 08:42:14'),(812,'1','313',1,'Retail Sale Id 836',0.00,74039.90,670.00,81994.60,7954.70,'2023-03-01 08:45:02'),(813,'1','313',1,'Retail Sale Id 837',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-01 08:45:47'),(814,'1','313',1,'Retail Sale Id 838',0.00,3630.00,710.00,4260.00,630.00,'2023-03-01 08:46:27'),(815,'1','313',1,'Retail Sale Id 840',0.00,4235.00,710.00,4970.00,735.00,'2023-03-01 08:48:47'),(816,'1','313',1,'Retail Sale Id 841',0.00,4235.00,710.00,4970.00,735.00,'2023-03-01 08:49:18'),(817,'1','313',1,'Retail Sale Id 842',0.00,605.00,710.00,710.00,105.00,'2023-03-01 08:49:50'),(818,'1','313',1,'Retail Sale Id 843',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-01 08:51:15'),(819,'1','313',1,'Retail Sale Id 844',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-01 08:52:05'),(820,'1','313',1,'Retail Sale Id 845',0.00,605.00,710.00,710.00,105.00,'2023-03-01 08:52:54'),(821,'1','313',1,'Retail Sale Id 846',0.00,4259.20,710.00,4998.40,739.20,'2023-03-01 08:53:30'),(822,'1','313',1,'Retail Sale Id 847',0.00,605.00,710.00,710.00,105.00,'2023-03-01 08:54:08'),(823,'1','313',1,'Retail Sale Id 848',0.00,605.00,710.00,710.00,105.00,'2023-03-01 08:54:56'),(824,'1','313',1,'Retail Sale Id 849',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-01 08:55:30'),(825,'1','313',1,'Retail Sale Id 850',0.00,605.00,710.00,710.00,105.00,'2023-03-01 08:56:18'),(826,'1','313',1,'Retail Sale Id 851',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-01 08:57:47'),(827,'1','313',1,'Retail Sale Id 852',0.00,1815.00,710.00,2130.00,315.00,'2023-03-01 08:59:08'),(828,'1','313',1,'Retail Sale Id 853',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-01 08:59:56'),(829,'1','313',1,'Retail Sale Id 854',0.00,1276.55,710.00,1498.10,221.55,'2023-03-01 09:01:24'),(830,'1','313',1,'Retail Sale Id 855',0.00,1815.00,710.00,2130.00,315.00,'2023-03-01 09:02:43'),(831,'1','313',1,'Retail Sale Id 856',0.00,1833.15,710.00,2151.30,318.15,'2023-03-01 09:04:36'),(832,'1','313',1,'Retail Sale Id 857',0.00,641.30,710.00,752.60,111.30,'2023-03-01 09:05:14'),(833,'1','313',1,'Retail Sale Id 858',0.00,2420.00,710.00,2840.00,420.00,'2023-03-01 09:08:09'),(834,'1','313',1,'Retail Sale Id 859',0.00,1706.10,710.00,2002.20,296.10,'2023-03-01 09:09:05'),(835,'1','313',1,'Retail Sale Id 860',0.00,4035.35,710.00,4735.70,700.35,'2023-03-01 09:10:19'),(836,'1','313',1,'Retail Sale Id 861',0.00,3025.00,710.00,3550.00,525.00,'2023-03-01 09:23:14'),(837,'1','313',1,'Retail Sale Id 862',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-01 09:24:29'),(838,'1','313',1,'Retail Sale Id 864',0.00,1276.55,710.00,1498.10,221.55,'2023-03-01 09:26:21'),(839,'1','313',1,'Retail Sale Id 865',0.00,605.00,710.00,710.00,105.00,'2023-03-01 09:27:04'),(840,'1','313',1,'Retail Sale Id 866',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-01 09:30:52'),(841,'1','313',1,'Retail Sale Id 867',0.00,2420.00,710.00,2840.00,420.00,'2023-03-01 09:31:53'),(842,'1','313',1,'Retail Sale Id 868',0.00,605.00,710.00,710.00,105.00,'2023-03-01 09:33:22'),(843,'1','313',1,'Retail Sale Id 869',0.00,1210.00,710.00,1420.00,210.00,'2023-03-01 09:34:04'),(844,'1','313',1,'Retail Sale Id 870',0.00,1815.00,710.00,2130.00,315.00,'2023-03-01 09:34:43'),(845,'1','313',1,'Retail Sale Id 871',0.00,1706.10,710.00,2002.20,296.10,'2023-03-01 09:36:39'),(846,'1','313',1,'Retail Sale Id 872',0.00,3630.00,710.00,4260.00,630.00,'2023-03-01 09:44:44'),(847,'1','313',1,'Retail Sale Id 873',0.00,3025.00,710.00,3550.00,525.00,'2023-03-01 09:48:31'),(848,'1','313',1,'Retail Sale Id 874',0.00,3025.00,710.00,3550.00,525.00,'2023-03-01 09:50:12'),(849,'1','313',1,'Retail Sale Id 875',0.00,1815.00,710.00,2130.00,315.00,'2023-03-01 09:53:08'),(850,'1','313',1,'Retail Sale Id 877',0.00,3630.00,710.00,4260.00,630.00,'2023-03-01 09:58:36'),(851,'1','313',1,'Retail Sale Id 878',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-01 09:59:25'),(852,'1','313',1,'Retail Sale Id 879',0.00,3025.00,710.00,3550.00,525.00,'2023-03-01 10:02:27'),(853,'1','313',1,'Retail Sale Id 880',0.00,1210.00,710.00,1420.00,210.00,'2023-03-01 10:03:47'),(854,'1','313',1,'Retail Sale Id 881',0.00,3025.00,710.00,3550.00,525.00,'2023-03-01 10:05:29'),(855,'1','313',1,'Retail Sale Id 882',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-01 10:09:25'),(856,'1','313',1,'Retail Sale Id 885',0.00,3630.00,710.00,4260.00,630.00,'2023-03-01 10:22:56'),(857,'1','313',1,'Retail Sale Id 886',0.00,853.05,710.00,1001.10,148.05,'2023-03-01 10:31:11'),(858,'1','313',1,'Retail Sale Id 887',0.00,3025.00,710.00,3550.00,525.00,'2023-03-01 10:37:20'),(859,'1','313',1,'Retail Sale Id 888',0.00,2559.15,710.00,3003.30,444.15,'2023-03-01 10:38:32'),(860,'1','313',1,'Retail Sale Id 889',0.00,1234.20,710.00,1448.40,214.20,'2023-03-01 10:40:46'),(861,'1','313',1,'Retail Sale Id 890',0.00,1815.00,710.00,2130.00,315.00,'2023-03-01 10:44:18'),(862,'1','313',1,'Retail Sale Id 891',0.00,1815.00,710.00,2130.00,315.00,'2023-03-01 10:45:49'),(863,'1','313',1,'Retail Sale Id 892',0.00,90750.00,670.00,100500.00,9750.00,'2023-03-01 10:54:42'),(864,'1','313',1,'Retail Sale Id 893',0.00,1210.00,710.00,1420.00,210.00,'2023-03-01 10:57:16'),(865,'1','313',1,'Retail Sale Id 894',0.00,4235.00,710.00,4970.00,735.00,'2023-03-01 11:06:16'),(866,'1','313',1,'Retail Sale Id 896',0.00,2129.60,710.00,2499.20,369.60,'2023-03-01 11:13:22'),(867,'1','313',1,'Retail Sale Id 897',0.00,1815.00,710.00,2130.00,315.00,'2023-03-01 11:21:01'),(868,'1','313',1,'Retail Sale Id 898',0.00,1234.20,710.00,1448.40,214.20,'2023-03-01 11:22:22'),(869,'1','313',1,'Retail Sale Id 899',0.00,3025.00,710.00,3550.00,525.00,'2023-03-01 11:24:23'),(870,'1','313',1,'Retail Sale Id 900',0.00,4235.00,710.00,4970.00,735.00,'2023-03-01 11:25:22'),(871,'1','313',1,'Retail Sale Id 901',0.00,4235.00,710.00,4970.00,735.00,'2023-03-01 11:27:23'),(872,'1','313',1,'Retail Sale Id 902',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-01 11:28:18'),(873,'1','313',1,'Retail Sale Id 903',0.00,2383.70,710.00,2797.40,413.70,'2023-03-01 11:29:46'),(874,'1','313',1,'Retail Sale Id 904',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-01 11:31:46'),(875,'1','313',1,'Retail Sale Id 905',0.00,4235.00,710.00,4970.00,735.00,'2023-03-01 11:36:38'),(876,'1','313',1,'Retail Sale Id 906',0.00,4235.00,710.00,4970.00,735.00,'2023-03-01 11:38:54'),(877,'1','313',1,'Retail Sale Id 908',0.00,1234.20,710.00,1448.40,214.20,'2023-03-01 11:50:16'),(878,'1','313',1,'Retail Sale Id 909',0.00,1234.20,710.00,1448.40,214.20,'2023-03-01 11:51:20'),(879,'1','313',1,'Retail Sale Id 910',0.00,853.05,710.00,1001.10,148.05,'2023-03-01 11:56:22'),(880,'1','313',1,'Retail Sale Id 911',0.00,5965.30,710.00,7000.60,1035.30,'2023-03-01 11:57:54'),(881,'1','313',1,'Retail Sale Id 912',0.00,1022.45,710.00,1199.90,177.45,'2023-03-01 12:01:20'),(882,'1','313',1,'Retail Sale Id 913',0.00,107629.50,670.00,119193.00,11563.50,'2023-03-01 12:16:20'),(883,'1','313',1,'Retail Sale Id 914',0.00,2420.00,710.00,2840.00,420.00,'2023-03-01 12:19:36'),(884,'1','313',1,'Retail Sale Id 915',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-01 12:27:42'),(885,'1','313',1,'Retail Sale Id 916',0.00,3630.00,710.00,4260.00,630.00,'2023-03-01 12:29:12'),(886,'1','313',1,'Retail Sale Id 917',0.00,3630.00,710.00,4260.00,630.00,'2023-03-01 12:35:56'),(887,'1','313',1,'Retail Sale Id 918',0.00,641.30,710.00,752.60,111.30,'2023-03-01 12:46:16'),(888,'1','313',1,'Retail Sale Id 919',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-01 12:47:15'),(889,'1','313',1,'Retail Sale Id 920',0.00,641.30,710.00,752.60,111.30,'2023-03-01 12:52:23'),(890,'1','313',1,'Retail Sale Id 922',0.00,1815.00,710.00,2130.00,315.00,'2023-03-01 13:06:00'),(891,'1','313',1,'Retail Sale Id 923',0.00,853.05,710.00,1001.10,148.05,'2023-03-01 13:08:02'),(892,'1','313',1,'Retail Sale Id 924',0.00,2420.00,710.00,2840.00,420.00,'2023-03-01 13:09:20'),(893,'1','313',1,'Retail Sale Id 925',0.00,7223.70,670.00,7999.80,776.10,'2023-03-01 13:15:06'),(894,'1','313',1,'Retail Sale Id 926',0.00,2426.05,710.00,2847.10,421.05,'2023-03-01 13:16:15'),(895,'1','313',1,'Retail Sale Id 927',0.00,641.30,710.00,752.60,111.30,'2023-03-01 13:32:08'),(896,'1','313',1,'Retail Sale Id 928',0.00,1210.00,710.00,1420.00,210.00,'2023-03-01 13:34:20'),(897,'1','313',1,'Retail Sale Id 929',0.00,36529.90,670.00,40454.60,3924.70,'2023-03-01 13:48:56'),(898,'1','313',1,'Retail Sale Id 930',0.00,1815.00,710.00,2130.00,315.00,'2023-03-01 13:57:09'),(899,'1','313',1,'Retail Sale Id 931',0.00,2117.50,710.00,2485.00,367.50,'2023-03-01 14:01:05'),(900,'1','313',1,'Retail Sale Id 932',0.00,1815.00,710.00,2130.00,315.00,'2023-03-01 14:04:03'),(901,'1','313',1,'Retail Sale Id 933',0.00,641.30,710.00,752.60,111.30,'2023-03-01 14:05:46'),(902,'1','313',1,'Retail Sale Id 934',0.00,2420.00,710.00,2840.00,420.00,'2023-03-01 14:14:44'),(903,'1','313',1,'Retail Sale Id 935',0.00,2420.00,710.00,2840.00,420.00,'2023-03-01 14:15:33'),(904,'1','313',1,'Retail Sale Id 936',0.00,3630.00,710.00,4260.00,630.00,'2023-03-01 14:20:57'),(905,'1','313',1,'Retail Sale Id 937',0.00,2559.15,710.00,3003.30,444.15,'2023-03-01 14:22:40'),(906,'1','313',1,'Retail Sale Id 938',0.00,853.05,710.00,1001.10,148.05,'2023-03-01 14:23:38'),(907,'1','313',1,'Retail Sale Id 941',0.00,10890.00,710.00,12780.00,1890.00,'2023-03-01 14:50:00'),(908,'1','313',1,'Retail Sale Id 942',0.00,1210.00,710.00,1420.00,210.00,'2023-03-01 14:50:54'),(909,'1','313',1,'Retail Sale Id 943',0.00,641.30,710.00,752.60,111.30,'2023-03-01 14:51:48'),(910,'1','313',1,'Retail Sale Id 944',0.00,1815.00,710.00,2130.00,315.00,'2023-03-01 14:53:40'),(911,'1','313',1,'Retail Sale Id 945',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-01 14:58:25'),(912,'1','313',1,'Retail Sale Id 946',0.00,1815.00,710.00,2130.00,315.00,'2023-03-01 14:59:49'),(913,'1','313',1,'Retail Sale Id 947',0.00,4235.00,710.00,4970.00,735.00,'2023-03-01 15:06:47'),(914,'1','313',1,'Retail Sale Id 940',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-01 15:07:33'),(915,'1','313',1,'Retail Sale Id 948',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-01 15:08:17'),(916,'1','313',1,'Retail Sale Id 949',0.00,2420.00,710.00,2840.00,420.00,'2023-03-01 15:08:58'),(917,'1','313',1,'Retail Sale Id 950',0.00,3630.00,710.00,4260.00,630.00,'2023-03-01 15:10:55'),(918,'1','313',1,'Retail Sale Id 951',0.00,1815.00,710.00,2130.00,315.00,'2023-03-01 15:15:33'),(919,'1','313',1,'Retail Sale Id 952',0.00,2420.00,710.00,2840.00,420.00,'2023-03-01 15:19:22'),(920,'1','313',1,'Retail Sale Id 953',0.00,605.00,710.00,710.00,105.00,'2023-03-01 15:20:46'),(921,'1','313',1,'Retail Sale Id 954',0.00,3025.00,710.00,3550.00,525.00,'2023-03-01 15:34:16'),(922,'1','313',1,'Retail Sale Id 955',0.00,1815.00,710.00,2130.00,315.00,'2023-03-01 15:39:39'),(923,'1','313',1,'Retail Sale Id 956',0.00,3751.00,710.00,4402.00,651.00,'2023-03-01 15:43:00'),(924,'1','313',1,'Retail Sale Id 957',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-01 15:44:35'),(925,'1','313',1,'Retail Sale Id 958',0.00,1210.00,710.00,1420.00,210.00,'2023-03-01 15:45:36'),(926,'1','313',1,'Retail Sale Id 960',0.00,1210.00,710.00,1420.00,210.00,'2023-03-01 15:52:58'),(927,'1','313',1,'Retail Sale Id 961',0.00,1210.00,710.00,1420.00,210.00,'2023-03-01 15:55:42'),(928,'1','313',1,'Retail Sale Id 963',0.00,1234.20,710.00,1448.40,214.20,'2023-03-01 15:57:51'),(929,'1','313',1,'Retail Sale Id 964',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-01 16:07:07'),(930,'1','313',1,'Retail Sale Id 965',0.00,605.00,710.00,710.00,105.00,'2023-03-01 16:10:25'),(931,'1','313',1,'Retail Sale Id 966',0.00,641.30,710.00,752.60,111.30,'2023-03-01 16:11:40'),(932,'1','313',1,'Retail Sale Id 967',0.00,2559.15,710.00,3003.30,444.15,'2023-03-01 16:13:40'),(933,'1','313',1,'Retail Sale Id 968',0.00,853.05,710.00,1001.10,148.05,'2023-03-01 16:20:43'),(934,'1','313',1,'Retail Sale Id 969',0.00,1234.20,710.00,1448.40,214.20,'2023-03-01 16:24:03'),(935,'1','313',1,'Retail Sale Id 970',0.00,1790.80,710.00,2101.60,310.80,'2023-03-01 16:31:34'),(936,'1','313',1,'Retail Sale Id 972',0.00,2420.00,710.00,2840.00,420.00,'2023-03-01 16:43:14'),(937,'1','313',1,'Retail Sale Id 973',0.00,3630.00,710.00,4260.00,630.00,'2023-03-01 16:44:46'),(938,'1','313',1,'Retail Sale Id 974',0.00,2420.00,710.00,2840.00,420.00,'2023-03-01 16:47:40'),(939,'1','313',1,'Retail Sale Id 976',0.00,853.05,710.00,1001.10,148.05,'2023-03-01 16:48:55'),(940,'1','313',1,'Retail Sale Id 977',0.00,1706.10,710.00,2002.20,296.10,'2023-03-01 16:51:09'),(941,'1','313',1,'Retail Sale Id 978',0.00,1706.10,710.00,2002.20,296.10,'2023-03-01 16:57:19'),(942,'1','313',1,'Retail Sale Id 979',0.00,4235.00,710.00,4970.00,735.00,'2023-03-01 16:59:05'),(943,'1','313',1,'Retail Sale Id 980',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-01 17:00:48'),(944,'1','313',1,'Retail Sale Id 981',0.00,3025.00,710.00,3550.00,525.00,'2023-03-01 17:02:14'),(945,'1','313',1,'Retail Sale Id 982',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-01 17:03:43'),(946,'1','313',1,'Retail Sale Id 983',0.00,1210.00,710.00,1420.00,210.00,'2023-03-01 17:05:57'),(947,'1','313',1,'Retail Sale Id 984',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-01 17:06:49'),(948,'1','313',1,'Retail Sale Id 985',0.00,605.00,710.00,710.00,105.00,'2023-03-01 17:08:37'),(949,'1','313',1,'Retail Sale Id 986',0.00,1210.00,710.00,1420.00,210.00,'2023-03-01 17:10:50'),(950,'1','313',1,'Retail Sale Id 987',0.00,2420.00,710.00,2840.00,420.00,'2023-03-01 17:13:51'),(951,'1','313',1,'Retail Sale Id 988',0.00,1234.20,710.00,1448.40,214.20,'2023-03-01 17:14:49'),(952,'1','313',1,'Retail Sale Id 989',0.00,90750.00,670.00,100500.00,9750.00,'2023-03-01 17:21:35'),(953,'1','313',1,'Return of Retail Sale Id 969',1234.20,0.00,710.00,-1448.40,-214.20,'2023-03-01 17:43:25'),(954,'1','313',1,'Retail Sale Id 990',0.00,895.40,710.00,1050.80,155.40,'2023-03-01 17:44:15'),(955,'1','313',1,'Return of Retail Sale Id 925',7223.70,0.00,670.00,-7999.80,-776.10,'2023-03-01 17:51:56'),(956,'1','313',1,'Retail Sale Id 991',0.00,6915.15,670.00,7658.10,742.95,'2023-03-01 17:53:01'),(957,'1','313',1,'Retail Sale Id 993',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-02 08:09:49'),(958,'1','313',1,'Retail Sale Id 994',0.00,641.30,710.00,752.60,111.30,'2023-03-02 08:10:34'),(959,'1','313',1,'Retail Sale Id 995',0.00,1875.50,710.00,2201.00,325.50,'2023-03-02 08:11:31'),(960,'1','313',1,'Retail Sale Id 996',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-02 08:12:28'),(961,'1','313',1,'Retail Sale Id 997',0.00,2420.00,710.00,2840.00,420.00,'2023-03-02 08:13:31'),(962,'1','313',1,'Retail Sale Id 998',0.00,853.05,710.00,1001.10,148.05,'2023-03-02 08:14:13'),(963,'1','313',1,'Retail Sale Id 999',0.00,1276.55,710.00,1498.10,221.55,'2023-03-02 08:15:15'),(964,'1','313',1,'Retail Sale Id 1000',0.00,33275.00,670.00,36850.00,3575.00,'2023-03-02 08:16:18'),(965,'1','313',1,'Retail Sale Id 1001',0.00,1815.00,710.00,2130.00,315.00,'2023-03-02 08:17:31'),(966,'1','313',1,'Retail Sale Id 1002',0.00,1815.00,710.00,2130.00,315.00,'2023-03-02 08:19:25'),(967,'1','313',1,'Retail Sale Id 1003',0.00,2141.70,710.00,2513.40,371.70,'2023-03-02 08:21:15'),(968,'1','313',1,'Retail Sale Id 1004',0.00,1276.55,710.00,1498.10,221.55,'2023-03-02 08:23:26'),(969,'1','313',1,'Retail Sale Id 1005',0.00,37292.20,670.00,41298.80,4006.60,'2023-03-02 08:24:55'),(970,'1','313',1,'Retail Sale Id 1006',0.00,1191.85,710.00,1398.70,206.85,'2023-03-02 08:26:17'),(971,'1','313',1,'Retail Sale Id 1007',0.00,1210.00,710.00,1420.00,210.00,'2023-03-02 08:27:56'),(972,'1','313',1,'Retail Sale Id 1008',0.00,1210.00,710.00,1420.00,210.00,'2023-03-02 08:29:00'),(973,'1','313',1,'Retail Sale Id 1009',0.00,1210.00,710.00,1420.00,210.00,'2023-03-02 08:30:15'),(974,'1','313',1,'Retail Sale Id 1010',0.00,1276.55,710.00,1498.10,221.55,'2023-03-02 08:31:15'),(975,'1','313',1,'Retail Sale Id 1011',0.00,2420.00,710.00,2840.00,420.00,'2023-03-02 08:32:10'),(976,'1','313',1,'Retail Sale Id 1012',0.00,2559.15,710.00,3003.30,444.15,'2023-03-02 08:33:06'),(977,'1','313',1,'Retail Sale Id 1013',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-02 08:34:15'),(978,'1','313',1,'Retail Sale Id 1014',0.00,605.00,710.00,710.00,105.00,'2023-03-02 08:35:39'),(979,'1','313',1,'Retail Sale Id 1015',0.00,3025.00,710.00,3550.00,525.00,'2023-03-02 08:36:29'),(980,'1','313',1,'Retail Sale Id 1016',0.00,1276.55,710.00,1498.10,221.55,'2023-03-02 08:37:55'),(981,'1','313',1,'Retail Sale Id 1017',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-02 08:38:49'),(982,'1','313',1,'Retail Sale Id 1018',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-02 08:40:31'),(983,'1','313',1,'Retail Sale Id 1019',0.00,2420.00,710.00,2840.00,420.00,'2023-03-02 08:41:23'),(984,'1','313',1,'Retail Sale Id 1020',0.00,4235.00,710.00,4970.00,735.00,'2023-03-02 08:42:36'),(985,'1','313',1,'Retail Sale Id 1021',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-02 08:43:47'),(986,'1','313',1,'Retail Sale Id 1022',0.00,1706.10,710.00,2002.20,296.10,'2023-03-02 08:47:15'),(987,'1','313',1,'Retail Sale Id 1023',0.00,2559.15,710.00,3003.30,444.15,'2023-03-02 08:57:54'),(988,'1','313',1,'Retail Sale Id 1024',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-02 09:00:09'),(989,'1','313',1,'Retail Sale Id 1025',0.00,2420.00,710.00,2840.00,420.00,'2023-03-02 09:08:59'),(990,'1','313',1,'Retail Sale Id 1026',0.00,3630.00,710.00,4260.00,630.00,'2023-03-02 09:09:51'),(991,'1','313',1,'Retail Sale Id 1027',0.00,1833.15,710.00,2151.30,318.15,'2023-03-02 09:17:48'),(992,'1','313',1,'Retail Sale Id 1028',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-02 09:20:34'),(993,'1','313',1,'Retail Sale Id 1030',0.00,937.75,710.00,1100.50,162.75,'2023-03-02 09:25:02'),(994,'1','313',1,'Retail Sale Id 1031',0.00,2420.00,710.00,2840.00,420.00,'2023-03-02 09:26:43'),(995,'1','313',1,'Retail Sale Id 1032',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-02 09:28:16'),(996,'1','313',1,'Retail Sale Id 1033',0.00,1210.00,710.00,1420.00,210.00,'2023-03-02 09:28:57'),(997,'1','313',1,'Retail Sale Id 1034',0.00,605.00,710.00,710.00,105.00,'2023-03-02 09:29:58'),(998,'1','313',1,'Retail Sale Id 1035',0.00,1706.10,710.00,2002.20,296.10,'2023-03-02 09:33:36'),(999,'1','313',1,'Retail Sale Id 1036',0.00,605.00,710.00,710.00,105.00,'2023-03-02 09:35:32'),(1000,'1','313',1,'Retail Sale Id 1037',0.00,1210.00,710.00,1420.00,210.00,'2023-03-02 09:36:53'),(1001,'1','313',1,'Retail Sale Id 1039',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-02 09:39:50'),(1002,'1','313',1,'Retail Sale Id 1040',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-02 09:41:53'),(1003,'1','313',1,'Retail Sale Id 1041',0.00,1815.00,710.00,2130.00,315.00,'2023-03-02 09:47:51'),(1004,'1','313',1,'Retail Sale Id 1042',0.00,3025.00,710.00,3550.00,525.00,'2023-03-02 09:51:25'),(1005,'1','313',1,'Retail Sale Id 1043',0.00,3025.00,710.00,3550.00,525.00,'2023-03-02 09:52:16'),(1006,'1','313',1,'Retail Sale Id 1044',0.00,641.30,710.00,752.60,111.30,'2023-03-02 09:53:46'),(1007,'1','313',1,'Retail Sale Id 1045',0.00,45375.00,710.00,53250.00,7875.00,'2023-03-02 09:56:41'),(1008,'1','313',1,'Retail Sale Id 1046',0.00,3025.00,710.00,3550.00,525.00,'2023-03-02 09:59:00'),(1009,'1','313',1,'Retail Sale Id 1047',0.00,1815.00,710.00,2130.00,315.00,'2023-03-02 10:01:22'),(1010,'1','313',1,'Retail Sale Id 1048',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-02 10:06:58'),(1011,'1','313',1,'Retail Sale Id 1049',0.00,768.35,710.00,901.70,133.35,'2023-03-02 10:10:25'),(1012,'1','313',1,'Retail Sale Id 1050',0.00,4235.00,710.00,4970.00,735.00,'2023-03-02 10:18:49'),(1013,'1','313',1,'Retail Sale Id 1051',0.00,1833.15,710.00,2151.30,318.15,'2023-03-02 10:21:01'),(1014,'1','313',1,'Retail Sale Id 1053',0.00,3630.00,710.00,4260.00,630.00,'2023-03-02 10:22:51'),(1015,'1','313',1,'Retail Sale Id 1054',0.00,4235.00,710.00,4970.00,735.00,'2023-03-02 10:23:43'),(1016,'1','313',1,'Retail Sale Id 1055',0.00,3630.00,710.00,4260.00,630.00,'2023-03-02 10:26:15'),(1017,'1','313',1,'Retail Sale Id 1056',0.00,1815.00,710.00,2130.00,315.00,'2023-03-02 10:29:20'),(1018,'1','313',1,'Retail Sale Id 1057',0.00,4840.00,710.00,5680.00,840.00,'2023-03-02 10:35:52'),(1019,'1','313',1,'Retail Sale Id 1058',0.00,1815.00,710.00,2130.00,315.00,'2023-03-02 10:38:04'),(1020,'1','313',1,'Retail Sale Id 1059',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-02 10:40:28'),(1021,'1','313',1,'Return of Retail Sale Id 1045',45375.00,0.00,710.00,-53250.00,-7875.00,'2023-03-02 10:51:06'),(1022,'1','313',1,'Retail Sale Id 1060',0.00,45375.00,670.00,50250.00,4875.00,'2023-03-02 10:52:00'),(1023,'1','313',1,'Retail Sale Id 1061',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-02 10:56:58'),(1024,'1','313',1,'Retail Sale Id 1062',0.00,1815.00,710.00,2130.00,315.00,'2023-03-02 10:58:01'),(1025,'1','313',1,'Retail Sale Id 1063',0.00,1833.15,710.00,2151.30,318.15,'2023-03-02 11:07:41'),(1026,'1','313',1,'Retail Sale Id 1064',0.00,1833.15,710.00,2151.30,318.15,'2023-03-02 11:08:30'),(1027,'1','313',1,'Retail Sale Id 1065',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-02 11:15:50'),(1028,'1','313',1,'Retail Sale Id 1066',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-02 11:17:03'),(1029,'1','313',1,'Retail Sale Id 1067',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-02 11:22:17'),(1030,'1','313',1,'Retail Sale Id 1068',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-02 11:24:37'),(1031,'1','313',1,'Retail Sale Id 1069',0.00,1210.00,710.00,1420.00,210.00,'2023-03-02 11:26:36'),(1032,'1','313',1,'Retail Sale Id 1070',0.00,4235.00,710.00,4970.00,735.00,'2023-03-02 11:30:39'),(1033,'1','313',1,'Retail Sale Id 1071',0.00,1276.55,710.00,1498.10,221.55,'2023-03-02 11:33:39'),(1034,'1','313',1,'Retail Sale Id 1072',0.00,641.30,710.00,752.60,111.30,'2023-03-02 11:42:22'),(1035,'1','313',1,'Retail Sale Id 1073',0.00,605.00,710.00,710.00,105.00,'2023-03-02 11:43:24'),(1036,'1','313',1,'Retail Sale Id 1075',0.00,641.30,710.00,752.60,111.30,'2023-03-02 11:52:20'),(1037,'1','313',1,'Retail Sale Id 1076',0.00,605.00,710.00,710.00,105.00,'2023-03-02 11:56:26'),(1038,'1','313',1,'Retail Sale Id 1078',0.00,605.00,710.00,710.00,105.00,'2023-03-02 12:00:11'),(1039,'1','313',1,'Retail Sale Id 1079',0.00,3630.00,710.00,4260.00,630.00,'2023-03-02 12:02:42'),(1040,'1','313',1,'Retail Sale Id 1080',0.00,4235.00,710.00,4970.00,735.00,'2023-03-02 12:07:25'),(1041,'1','313',1,'Retail Sale Id 1081',0.00,5445.00,710.00,6390.00,945.00,'2023-03-02 12:09:24'),(1042,'1','313',1,'Retail Sale Id 1083',0.00,3666.30,710.00,4302.60,636.30,'2023-03-02 12:18:49'),(1043,'1','313',1,'Retail Sale Id 1084',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-02 12:20:37'),(1044,'1','313',1,'Retail Sale Id 1085',0.00,14520.00,710.00,17040.00,2520.00,'2023-03-02 12:23:30'),(1045,'1','313',1,'Retail Sale Id 1087',0.00,74584.40,710.00,87528.80,12944.40,'2023-03-02 18:16:49'),(1046,'1','313',1,'Retail Sale Id 1088',0.00,174451.75,670.00,193194.50,18742.75,'2023-03-02 18:17:35'),(1047,'1','313',1,'Retail Sale Id 1089',0.00,60500.00,670.00,67000.00,6500.00,'2023-03-02 18:18:32'),(1048,'1','313',1,'Return of Retail Sale Id 1088',174451.75,0.00,670.00,-193194.50,-18742.75,'2023-03-02 18:24:42'),(1049,'1','313',1,'Retail Sale Id 1090',0.00,74584.40,670.00,82597.60,8013.20,'2023-03-02 18:27:45'),(1050,'1','313',1,'Return of Retail Sale Id 1087',74584.40,0.00,710.00,-87528.80,-12944.40,'2023-03-02 18:28:35'),(1051,'1','313',1,'Retail Sale Id 1091',0.00,174451.75,710.00,204728.50,30276.75,'2023-03-02 18:29:29'),(1052,'1','313',1,'Retail Sale Id 1092',0.00,3914.35,710.00,4593.70,679.35,'2023-03-02 18:34:27'),(1053,'1','313',1,'Return of Retail Sale Id 1005',37292.20,0.00,670.00,-41298.80,-4006.60,'2023-03-02 18:36:02'),(1054,'1','313',1,'Retail Sale Id 1093',0.00,37207.50,670.00,41205.00,3997.50,'2023-03-02 18:37:15'),(1055,'1','313',1,'Retail Sale Id 1094',0.00,207642.05,670.00,229950.70,22308.65,'2023-03-03 10:34:48'),(1056,'1','313',1,'Retail Sale Id 1095',0.00,3025.00,710.00,3550.00,525.00,'2023-03-03 10:37:46'),(1057,'1','313',1,'Retail Sale Id 1096',0.00,1210.00,710.00,1420.00,210.00,'2023-03-03 10:40:32'),(1058,'1','313',1,'Retail Sale Id 1097',0.00,1210.00,710.00,1420.00,210.00,'2023-03-03 10:45:39'),(1059,'1','313',1,'Retail Sale Id 1098',0.00,641.30,710.00,752.60,111.30,'2023-03-03 10:49:37'),(1060,'1','313',1,'Retail Sale Id 1099',0.00,3630.00,710.00,4260.00,630.00,'2023-03-03 10:50:54'),(1061,'1','313',1,'Retail Sale Id 1100',0.00,3630.00,710.00,4260.00,630.00,'2023-03-03 10:52:34'),(1062,'1','313',1,'Retail Sale Id 1101',0.00,168589.30,710.00,197848.60,29259.30,'2023-03-03 10:54:13'),(1063,'1','313',1,'Retail Sale Id 1102',0.00,1815.00,710.00,2130.00,315.00,'2023-03-03 10:55:30'),(1064,'1','313',1,'Retail Sale Id 1103',0.00,605.00,710.00,710.00,105.00,'2023-03-03 10:59:55'),(1065,'1','313',1,'Retail Sale Id 1104',0.00,1512.50,710.00,1775.00,262.50,'2023-03-03 11:04:15'),(1066,'1','313',1,'Retail Sale Id 1105',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-03 11:14:09'),(1067,'1','313',1,'Retail Sale Id 1106',0.00,3835.70,710.00,4501.40,665.70,'2023-03-03 11:19:18'),(1068,'1','313',1,'Retail Sale Id 1107',0.00,853.05,710.00,1001.10,148.05,'2023-03-03 11:30:55'),(1069,'1','313',1,'Retail Sale Id 1108',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-03 11:33:37'),(1070,'1','313',1,'Retail Sale Id 1109',0.00,4259.20,710.00,4998.40,739.20,'2023-03-03 11:34:50'),(1071,'1','313',1,'Retail Sale Id 1110',0.00,4235.00,710.00,4970.00,735.00,'2023-03-03 11:35:45'),(1072,'1','313',1,'Retail Sale Id 1111',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-03 11:36:58'),(1073,'1','313',1,'Retail Sale Id 1112',0.00,853.05,710.00,1001.10,148.05,'2023-03-03 11:37:54'),(1074,'1','313',1,'Retail Sale Id 1113',0.00,1276.55,710.00,1498.10,221.55,'2023-03-03 11:39:55'),(1075,'1','313',1,'Retail Sale Id 1114',0.00,3025.00,710.00,3550.00,525.00,'2023-03-03 11:42:58'),(1076,'1','313',1,'Retail Sale Id 1115',0.00,3025.00,710.00,3550.00,525.00,'2023-03-03 11:44:30'),(1077,'1','313',1,'Retail Sale Id 1116',0.00,3630.00,710.00,4260.00,630.00,'2023-03-03 11:45:24'),(1078,'1','313',1,'Retail Sale Id 1117',0.00,3630.00,710.00,4260.00,630.00,'2023-03-03 11:46:27'),(1079,'1','313',1,'Retail Sale Id 1118',0.00,2559.15,710.00,3003.30,444.15,'2023-03-03 11:54:16'),(1080,'1','313',1,'Retail Sale Id 1119',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-03 11:55:54'),(1081,'1','313',1,'Retail Sale Id 1120',0.00,2420.00,710.00,2840.00,420.00,'2023-03-03 11:56:43'),(1082,'1','313',1,'Retail Sale Id 1121',0.00,1210.00,710.00,1420.00,210.00,'2023-03-03 12:03:25'),(1083,'1','313',1,'Retail Sale Id 1122',0.00,1210.00,710.00,1420.00,210.00,'2023-03-03 12:08:45'),(1084,'1','313',1,'Retail Sale Id 1123',0.00,3025.00,710.00,3550.00,525.00,'2023-03-03 12:11:45'),(1085,'1','313',1,'Retail Sale Id 1124',0.00,3025.00,710.00,3550.00,525.00,'2023-03-03 12:25:23'),(1086,'1','313',1,'Retail Sale Id 1125',0.00,3630.00,710.00,4260.00,630.00,'2023-03-03 12:26:52'),(1087,'1','313',1,'Retail Sale Id 1126',0.00,6818.35,710.00,8001.70,1183.35,'2023-03-03 12:28:34'),(1088,'1','313',1,'Retail Sale Id 1127',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-03 12:31:45'),(1089,'1','313',1,'Retail Sale Id 1129',0.00,1210.00,710.00,1420.00,210.00,'2023-03-03 12:45:00'),(1090,'1','313',1,'Retail Sale Id 1130',0.00,3630.00,710.00,4260.00,630.00,'2023-03-03 12:50:55'),(1091,'1','313',1,'Retail Sale Id 1131',0.00,4840.00,710.00,5680.00,840.00,'2023-03-03 12:53:49'),(1092,'1','313',1,'Retail Sale Id 1132',0.00,1210.00,710.00,1420.00,210.00,'2023-03-03 12:54:45'),(1093,'1','313',1,'Retail Sale Id 1133',0.00,24200.00,670.00,26800.00,2600.00,'2023-03-03 13:03:48'),(1094,'1','313',1,'Retail Sale Id 1134',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-03 13:05:30'),(1095,'1','313',1,'Retail Sale Id 1135',0.00,1815.00,710.00,2130.00,315.00,'2023-03-03 13:06:56'),(1096,'1','313',1,'Retail Sale Id 1136',0.00,683.65,710.00,802.30,118.65,'2023-03-03 13:13:21'),(1097,'1','313',1,'Retail Sale Id 1137',0.00,641.30,710.00,752.60,111.30,'2023-03-03 13:15:04'),(1098,'1','313',1,'Retail Sale Id 1138',0.00,1210.00,710.00,1420.00,210.00,'2023-03-03 13:25:23'),(1099,'1','313',1,'Retail Sale Id 1139',0.00,1815.00,710.00,2130.00,315.00,'2023-03-03 13:35:31'),(1100,'1','313',1,'Retail Sale Id 1140',0.00,1210.00,710.00,1420.00,210.00,'2023-03-03 13:38:09'),(1101,'1','313',1,'Retail Sale Id 1141',0.00,1815.00,710.00,2130.00,315.00,'2023-03-03 13:46:47'),(1102,'1','313',1,'Retail Sale Id 1142',0.00,4840.00,710.00,5680.00,840.00,'2023-03-03 13:52:41'),(1103,'1','313',1,'Retail Sale Id 1143',0.00,1815.00,710.00,2130.00,315.00,'2023-03-03 13:54:03'),(1104,'1','313',1,'Retail Sale Id 1144',0.00,1210.00,710.00,1420.00,210.00,'2023-03-03 14:18:42'),(1105,'1','313',1,'Retail Sale Id 1146',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-03 14:28:50'),(1106,'1','313',1,'Retail Sale Id 1147',0.00,4259.20,710.00,4998.40,739.20,'2023-03-03 14:33:12'),(1107,'1','313',1,'Retail Sale Id 1149',0.00,1815.00,710.00,2130.00,315.00,'2023-03-03 14:37:36'),(1108,'1','313',1,'Retail Sale Id 1150',0.00,1210.00,710.00,1420.00,210.00,'2023-03-03 14:40:07'),(1109,'1','313',1,'Retail Sale Id 1151',0.00,605.00,710.00,710.00,105.00,'2023-03-03 14:41:28'),(1110,'1','313',1,'Retail Sale Id 1152',0.00,3630.00,710.00,4260.00,630.00,'2023-03-03 14:45:38'),(1111,'1','313',1,'Retail Sale Id 1153',0.00,598.95,710.00,702.90,103.95,'2023-03-03 14:47:19'),(1112,'1','313',1,'Retail Sale Id 1154',0.00,2420.00,710.00,2840.00,420.00,'2023-03-03 14:48:35'),(1113,'1','313',1,'Retail Sale Id 1155',0.00,1815.00,710.00,2130.00,315.00,'2023-03-03 14:49:25'),(1114,'1','313',1,'Retail Sale Id 1156',0.00,4235.00,710.00,4970.00,735.00,'2023-03-03 14:52:00'),(1115,'1','313',1,'Retail Sale Id 1158',0.00,641.30,710.00,752.60,111.30,'2023-03-03 14:59:32'),(1116,'1','313',1,'Retail Sale Id 1159',0.00,853.05,710.00,1001.10,148.05,'2023-03-03 15:01:33'),(1117,'1','313',1,'Retail Sale Id 1160',0.00,1210.00,710.00,1420.00,210.00,'2023-03-03 15:02:33'),(1118,'1','313',1,'Retail Sale Id 1161',0.00,3920.40,710.00,4600.80,680.40,'2023-03-03 15:06:36'),(1119,'1','313',1,'Retail Sale Id 1162',0.00,1391.50,710.00,1633.00,241.50,'2023-03-03 15:07:21'),(1120,'1','313',1,'Retail Sale Id 1163',0.00,3025.00,710.00,3550.00,525.00,'2023-03-03 15:17:50'),(1121,'1','313',1,'Retail Sale Id 1164',0.00,1815.00,710.00,2130.00,315.00,'2023-03-03 15:19:27'),(1122,'1','313',1,'Retail Sale Id 1165',0.00,853.05,710.00,1001.10,148.05,'2023-03-03 15:28:37'),(1123,'1','313',1,'Retail Sale Id 1166',0.00,1833.15,710.00,2151.30,318.15,'2023-03-03 15:34:00'),(1124,'1','313',1,'Retail Sale Id 1167',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-03 15:45:13'),(1125,'1','313',1,'Retail Sale Id 1168',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-03 15:47:24'),(1126,'1','313',1,'Retail Sale Id 1169',0.00,4235.00,710.00,4970.00,735.00,'2023-03-03 15:48:51'),(1127,'1','313',1,'Retail Sale Id 1170',0.00,641.30,710.00,752.60,111.30,'2023-03-03 15:50:07'),(1128,'1','313',1,'Retail Sale Id 1171',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-03 15:51:37'),(1129,'1','313',1,'Retail Sale Id 1172',0.00,1210.00,710.00,1420.00,210.00,'2023-03-03 15:53:54'),(1130,'1','313',1,'Retail Sale Id 1173',0.00,2129.60,710.00,2499.20,369.60,'2023-03-03 15:54:47'),(1131,'1','313',1,'Retail Sale Id 1174',0.00,1815.00,710.00,2130.00,315.00,'2023-03-03 15:56:43'),(1132,'1','313',1,'Retail Sale Id 1175',0.00,4235.00,710.00,4970.00,735.00,'2023-03-03 15:59:43'),(1133,'1','313',1,'Retail Sale Id 1177',0.00,2420.00,710.00,2840.00,420.00,'2023-03-03 16:02:43'),(1134,'1','313',1,'Retail Sale Id 1178',0.00,2420.00,710.00,2840.00,420.00,'2023-03-03 16:04:53'),(1135,'1','313',1,'Retail Sale Id 1179',0.00,2420.00,710.00,2840.00,420.00,'2023-03-03 16:06:36'),(1136,'1','313',1,'Retail Sale Id 1180',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-03 16:10:21'),(1137,'1','313',1,'Retail Sale Id 1181',0.00,2420.00,710.00,2840.00,420.00,'2023-03-03 16:12:20'),(1138,'1','313',1,'Retail Sale Id 1182',0.00,60500.00,670.00,67000.00,6500.00,'2023-03-03 16:13:31'),(1139,'1','313',1,'Retail Sale Id 1183',0.00,641.30,710.00,752.60,111.30,'2023-03-03 16:17:07'),(1140,'1','313',1,'Retail Sale Id 1184',0.00,4235.00,710.00,4970.00,735.00,'2023-03-03 16:18:37'),(1141,'1','313',1,'Retail Sale Id 1185',0.00,3630.00,710.00,4260.00,630.00,'2023-03-03 16:19:59'),(1142,'1','313',1,'Retail Sale Id 1186',0.00,3025.00,710.00,3550.00,525.00,'2023-03-03 16:20:46'),(1143,'1','313',1,'Retail Sale Id 1187',0.00,3406.15,710.00,3997.30,591.15,'2023-03-03 16:23:38'),(1144,'1','313',1,'Retail Sale Id 1188',0.00,4235.00,710.00,4970.00,735.00,'2023-03-03 16:24:51'),(1145,'1','313',1,'Retail Sale Id 1189',0.00,605.00,710.00,710.00,105.00,'2023-03-03 16:27:57'),(1146,'1','313',1,'Retail Sale Id 1190',0.00,611.05,710.00,717.10,106.05,'2023-03-03 16:30:02'),(1147,'1','313',1,'Retail Sale Id 1191',0.00,2044.90,710.00,2399.80,354.90,'2023-03-03 16:32:21'),(1148,'1','313',1,'Retail Sale Id 1192',0.00,1191.85,710.00,1398.70,206.85,'2023-03-03 16:33:28'),(1149,'1','313',1,'Retail Sale Id 1193',0.00,1815.00,710.00,2130.00,315.00,'2023-03-03 16:34:32'),(1150,'1','313',1,'Retail Sale Id 1194',0.00,1815.00,710.00,2130.00,315.00,'2023-03-03 16:35:51'),(1151,'1','313',1,'Retail Sale Id 1195',0.00,641.30,710.00,752.60,111.30,'2023-03-03 16:38:19'),(1152,'1','313',1,'Retail Sale Id 1196',0.00,4235.00,710.00,4970.00,735.00,'2023-03-03 16:39:53'),(1153,'1','313',1,'Retail Sale Id 1197',0.00,2426.05,710.00,2847.10,421.05,'2023-03-03 16:41:51'),(1154,'1','313',1,'Retail Sale Id 1198',0.00,1210.00,710.00,1420.00,210.00,'2023-03-03 16:43:10'),(1155,'1','313',1,'Retail Sale Id 1199',0.00,3630.00,710.00,4260.00,630.00,'2023-03-03 16:44:41'),(1156,'1','313',1,'Retail Sale Id 1200',0.00,3630.00,710.00,4260.00,630.00,'2023-03-03 16:49:20'),(1157,'1','313',1,'Retail Sale Id 1201',0.00,3630.00,710.00,4260.00,630.00,'2023-03-03 16:52:08'),(1158,'1','313',1,'Retail Sale Id 1202',0.00,4235.00,710.00,4970.00,735.00,'2023-03-03 16:54:47'),(1159,'1','313',1,'Retail Sale Id 1203',0.00,4235.00,710.00,4970.00,735.00,'2023-03-03 16:57:49'),(1160,'1','313',1,'Retail Sale Id 1204',0.00,1815.00,710.00,2130.00,315.00,'2023-03-03 16:59:29'),(1161,'1','313',1,'Retail Sale Id 1205',0.00,1210.00,710.00,1420.00,210.00,'2023-03-03 17:00:42'),(1162,'1','313',1,'Return of Retail Sale Id 1191',2044.90,0.00,710.00,-2399.80,-354.90,'2023-03-03 17:02:14'),(1163,'1','313',1,'Return of Retail Sale Id 1113',1276.55,0.00,710.00,-1498.10,-221.55,'2023-03-03 17:03:55'),(1164,'1','313',1,'Retail Sale Id 1206',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-03 17:21:53'),(1165,'1','313',1,'Return of Retail Sale Id 1188',4235.00,0.00,710.00,-4970.00,-735.00,'2023-03-03 17:24:42'),(1166,'1','313',1,'Retail Sale Id 1207',0.00,3394.05,710.00,3983.10,589.05,'2023-03-03 17:25:45'),(1167,'1','313',1,'Retail Sale Id 1208',0.00,853.05,710.00,1001.10,148.05,'2023-03-04 08:27:46'),(1168,'1','313',1,'Retail Sale Id 1209',0.00,853.05,710.00,1001.10,148.05,'2023-03-04 08:28:34'),(1169,'1','313',1,'Retail Sale Id 1210',0.00,3630.00,710.00,4260.00,630.00,'2023-03-04 08:31:08'),(1170,'1','313',1,'Retail Sale Id 1211',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 08:32:12'),(1171,'1','313',1,'Retail Sale Id 1212',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-04 08:35:46'),(1172,'1','313',1,'Retail Sale Id 1213',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 08:37:55'),(1173,'1','313',1,'Retail Sale Id 1214',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 08:39:30'),(1174,'1','313',1,'Retail Sale Id 1215',0.00,4235.00,710.00,4970.00,735.00,'2023-03-04 08:41:03'),(1175,'1','313',1,'Retail Sale Id 1216',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 08:42:15'),(1176,'1','313',1,'Retail Sale Id 1217',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 08:43:50'),(1177,'1','313',1,'Retail Sale Id 1218',0.00,60500.00,670.00,67000.00,6500.00,'2023-03-04 08:48:07'),(1178,'1','313',1,'Retail Sale Id 1219',0.00,1833.15,710.00,2151.30,318.15,'2023-03-04 08:51:55'),(1179,'1','313',1,'Retail Sale Id 1220',0.00,1234.20,710.00,1448.40,214.20,'2023-03-04 08:55:17'),(1180,'1','313',1,'Retail Sale Id 1221',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 08:57:46'),(1181,'1','313',1,'Retail Sale Id 1222',0.00,1833.15,710.00,2151.30,318.15,'2023-03-04 08:59:03'),(1182,'1','313',1,'Retail Sale Id 1223',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-04 09:00:35'),(1183,'1','313',1,'Retail Sale Id 1224',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 09:02:05'),(1184,'1','313',1,'Retail Sale Id 1225',0.00,90750.00,670.00,100500.00,9750.00,'2023-03-04 09:03:52'),(1185,'1','313',1,'Retail Sale Id 1226',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 09:05:14'),(1186,'1','313',1,'Retail Sale Id 1227',0.00,1833.15,710.00,2151.30,318.15,'2023-03-04 09:06:47'),(1187,'1','313',1,'Retail Sale Id 1228',0.00,1234.20,710.00,1448.40,214.20,'2023-03-04 09:07:42'),(1188,'1','313',1,'Retail Sale Id 1229',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 09:08:51'),(1189,'1','313',1,'Retail Sale Id 1230',0.00,605.00,710.00,710.00,105.00,'2023-03-04 09:09:20'),(1190,'1','313',1,'Retail Sale Id 1231',0.00,641.30,710.00,752.60,111.30,'2023-03-04 09:10:35'),(1191,'1','313',1,'Retail Sale Id 1233',0.00,1833.15,710.00,2151.30,318.15,'2023-03-04 09:12:47'),(1192,'1','313',1,'Retail Sale Id 1234',0.00,3630.00,710.00,4260.00,630.00,'2023-03-04 09:14:14'),(1193,'1','313',1,'Retail Sale Id 1235',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 09:15:26'),(1194,'1','313',1,'Retail Sale Id 1236',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 09:16:28'),(1195,'1','313',1,'Retail Sale Id 1237',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 09:17:55'),(1196,'1','313',1,'Retail Sale Id 1238',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 09:19:58'),(1197,'1','313',1,'Retail Sale Id 1239',0.00,605.00,710.00,710.00,105.00,'2023-03-04 09:22:23'),(1198,'1','313',1,'Retail Sale Id 1240',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-04 09:23:24'),(1199,'1','313',1,'Retail Sale Id 1241',0.00,605.00,710.00,710.00,105.00,'2023-03-04 09:24:39'),(1200,'1','313',1,'Retail Sale Id 1242',0.00,605.00,710.00,710.00,105.00,'2023-03-04 09:27:44'),(1201,'1','313',1,'Retail Sale Id 1244',0.00,2559.15,710.00,3003.30,444.15,'2023-03-04 09:31:43'),(1202,'1','313',1,'Retail Sale Id 1245',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 09:32:40'),(1203,'1','313',1,'Retail Sale Id 1246',0.00,1833.15,710.00,2151.30,318.15,'2023-03-04 09:34:34'),(1204,'1','313',1,'Retail Sale Id 1247',0.00,1276.55,710.00,1498.10,221.55,'2023-03-04 09:35:37'),(1205,'1','313',1,'Retail Sale Id 1248',0.00,1203.95,710.00,1412.90,208.95,'2023-03-04 09:36:46'),(1206,'1','313',1,'Retail Sale Id 1249',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-04 09:41:27'),(1207,'1','313',1,'Retail Sale Id 1250',0.00,21175.00,670.00,23450.00,2275.00,'2023-03-04 09:43:02'),(1208,'1','313',1,'Retail Sale Id 1251',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 09:45:39'),(1209,'1','313',1,'Retail Sale Id 1252',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-04 09:47:43'),(1210,'1','313',1,'Retail Sale Id 1253',0.00,2129.60,710.00,2499.20,369.60,'2023-03-04 09:49:12'),(1211,'1','313',1,'Retail Sale Id 1254',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-04 09:49:48'),(1212,'1','313',1,'Retail Sale Id 1255',0.00,641.30,710.00,752.60,111.30,'2023-03-04 09:51:25'),(1213,'1','313',1,'Retail Sale Id 1256',0.00,2559.15,710.00,3003.30,444.15,'2023-03-04 09:52:44'),(1214,'1','313',1,'Retail Sale Id 1257',0.00,1234.20,710.00,1448.40,214.20,'2023-03-04 09:54:34'),(1215,'1','313',1,'Retail Sale Id 1258',0.00,605.00,710.00,710.00,105.00,'2023-03-04 09:55:13'),(1216,'1','313',1,'Retail Sale Id 1259',0.00,683.65,710.00,802.30,118.65,'2023-03-04 09:56:09'),(1217,'1','313',1,'Retail Sale Id 1260',0.00,4235.00,710.00,4970.00,735.00,'2023-03-04 09:57:32'),(1218,'1','313',1,'Retail Sale Id 1261',0.00,605.00,710.00,710.00,105.00,'2023-03-04 10:00:43'),(1219,'1','313',1,'Retail Sale Id 1262',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 10:01:56'),(1220,'1','313',1,'Retail Sale Id 1263',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 10:03:28'),(1221,'1','313',1,'Retail Sale Id 1264',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 10:04:36'),(1222,'1','313',1,'Retail Sale Id 1265',0.00,4235.00,710.00,4970.00,735.00,'2023-03-04 10:06:48'),(1223,'1','313',1,'Retail Sale Id 1266',0.00,605.00,710.00,710.00,105.00,'2023-03-04 10:08:09'),(1224,'1','313',1,'Retail Sale Id 1267',0.00,2117.50,710.00,2485.00,367.50,'2023-03-04 10:09:47'),(1225,'1','313',1,'Retail Sale Id 1268',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-04 10:10:34'),(1226,'1','313',1,'Retail Sale Id 1269',0.00,4235.00,710.00,4970.00,735.00,'2023-03-04 10:11:25'),(1227,'1','313',1,'Retail Sale Id 1270',0.00,3630.00,710.00,4260.00,630.00,'2023-03-04 10:12:28'),(1228,'1','313',1,'Retail Sale Id 1271',0.00,605.00,710.00,710.00,105.00,'2023-03-04 10:16:25'),(1229,'1','313',1,'Retail Sale Id 1272',0.00,1833.15,710.00,2151.30,318.15,'2023-03-04 10:17:39'),(1230,'1','313',1,'Retail Sale Id 1273',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 10:18:22'),(1231,'1','313',1,'Retail Sale Id 1274',0.00,605.00,710.00,710.00,105.00,'2023-03-04 10:19:20'),(1232,'1','313',1,'Retail Sale Id 1275',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-04 10:20:35'),(1233,'1','313',1,'Retail Sale Id 1276',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 10:21:15'),(1234,'1','313',1,'Retail Sale Id 1277',0.00,605.00,710.00,710.00,105.00,'2023-03-04 10:22:19'),(1235,'1','313',1,'Retail Sale Id 1278',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 10:22:55'),(1236,'1','313',1,'Retail Sale Id 1279',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 10:23:33'),(1237,'1','313',1,'Retail Sale Id 1280',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 10:25:55'),(1238,'1','313',1,'Retail Sale Id 1281',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 10:27:35'),(1239,'1','313',1,'Retail Sale Id 1282',0.00,1282.60,710.00,1505.20,222.60,'2023-03-04 10:33:52'),(1240,'1','313',1,'Retail Sale Id 1283',0.00,4840.00,710.00,5680.00,840.00,'2023-03-04 10:35:50'),(1241,'1','313',1,'Retail Sale Id 1284',0.00,60500.00,670.00,67000.00,6500.00,'2023-03-04 10:37:22'),(1242,'1','313',1,'Retail Sale Id 1285',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 10:38:59'),(1243,'1','313',1,'Retail Sale Id 1286',0.00,4235.00,710.00,4970.00,735.00,'2023-03-04 10:43:09'),(1244,'1','313',1,'Retail Sale Id 1287',0.00,2559.15,710.00,3003.30,444.15,'2023-03-04 10:45:31'),(1245,'1','313',1,'Retail Sale Id 1288',0.00,4840.00,710.00,5680.00,840.00,'2023-03-04 10:46:40'),(1246,'1','313',1,'Retail Sale Id 1289',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 10:49:18'),(1247,'1','313',1,'Retail Sale Id 1290',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 10:52:09'),(1248,'1','313',1,'Retail Sale Id 1291',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 10:54:54'),(1249,'1','313',1,'Retail Sale Id 1292',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 10:57:21'),(1250,'1','313',1,'Retail Sale Id 1293',0.00,641.30,710.00,752.60,111.30,'2023-03-04 10:58:12'),(1251,'1','313',1,'Retail Sale Id 1294',0.00,7865.00,710.00,9230.00,1365.00,'2023-03-04 10:59:30'),(1252,'1','313',1,'Retail Sale Id 1295',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 11:02:19'),(1253,'1','313',1,'Retail Sale Id 1296',0.00,1706.10,710.00,2002.20,296.10,'2023-03-04 11:03:10'),(1254,'1','313',1,'Retail Sale Id 1297',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 11:06:47'),(1255,'1','313',1,'Retail Sale Id 1298',0.00,4840.00,710.00,5680.00,840.00,'2023-03-04 11:07:35'),(1256,'1','313',1,'Retail Sale Id 1299',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 11:09:56'),(1257,'1','313',1,'Retail Sale Id 1300',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 11:12:44'),(1258,'1','313',1,'Retail Sale Id 1302',0.00,4235.00,710.00,4970.00,735.00,'2023-03-04 11:15:49'),(1259,'1','313',1,'Retail Sale Id 1303',0.00,605.00,710.00,710.00,105.00,'2023-03-04 11:17:18'),(1260,'1','313',1,'Retail Sale Id 1304',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 11:19:57'),(1261,'1','313',1,'Retail Sale Id 1305',0.00,2559.15,710.00,3003.30,444.15,'2023-03-04 11:22:30'),(1262,'1','313',1,'Retail Sale Id 1306',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-04 11:24:11'),(1263,'1','313',1,'Retail Sale Id 1307',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-04 11:26:22'),(1264,'1','313',1,'Retail Sale Id 1308',0.00,73126.35,670.00,80982.90,7856.55,'2023-03-04 11:29:01'),(1265,'1','313',1,'Retail Sale Id 1309',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 11:32:26'),(1266,'1','313',1,'Retail Sale Id 1310',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-04 11:34:24'),(1267,'1','313',1,'Retail Sale Id 1311',0.00,5445.00,710.00,6390.00,945.00,'2023-03-04 11:38:16'),(1268,'1','313',1,'Retail Sale Id 1312',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 11:39:16'),(1269,'1','313',1,'Retail Sale Id 1314',0.00,937.75,710.00,1100.50,162.75,'2023-03-04 11:41:18'),(1270,'1','313',1,'Retail Sale Id 1315',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 11:42:56'),(1271,'1','313',1,'Retail Sale Id 1316',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-04 11:44:05'),(1272,'1','313',1,'Retail Sale Id 1317',0.00,7865.00,710.00,9230.00,1365.00,'2023-03-04 11:47:22'),(1273,'1','313',1,'Retail Sale Id 1318',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-04 11:51:14'),(1274,'1','313',1,'Retail Sale Id 1319',0.00,605.00,710.00,710.00,105.00,'2023-03-04 11:53:03'),(1275,'1','313',1,'Retail Sale Id 1320',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 11:54:12'),(1276,'1','313',1,'Retail Sale Id 1321',0.00,4840.00,710.00,5680.00,840.00,'2023-03-04 11:55:22'),(1277,'1','313',1,'Retail Sale Id 1322',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 11:56:35'),(1278,'1','313',1,'Retail Sale Id 1323',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-04 11:57:51'),(1279,'1','313',1,'Retail Sale Id 1324',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-04 11:59:18'),(1280,'1','313',1,'Retail Sale Id 1326',0.00,1706.10,710.00,2002.20,296.10,'2023-03-04 12:01:43'),(1281,'1','313',1,'Retail Sale Id 1327',0.00,4840.00,710.00,5680.00,840.00,'2023-03-04 12:02:33'),(1282,'1','313',1,'Retail Sale Id 1328',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 12:04:07'),(1283,'1','313',1,'Retail Sale Id 1329',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 12:06:00'),(1284,'1','313',1,'Retail Sale Id 1330',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-04 12:07:41'),(1285,'1','313',1,'Retail Sale Id 1331',0.00,1833.15,710.00,2151.30,318.15,'2023-03-04 12:08:43'),(1286,'1','313',1,'Retail Sale Id 1332',0.00,1833.15,710.00,2151.30,318.15,'2023-03-04 12:09:57'),(1287,'1','313',1,'Retail Sale Id 1333',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-04 12:11:15'),(1288,'1','313',1,'Retail Sale Id 1334',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 12:12:00'),(1289,'1','313',1,'Retail Sale Id 1335',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-04 12:13:19'),(1290,'1','313',1,'Retail Sale Id 1336',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-04 12:14:57'),(1291,'1','313',1,'Retail Sale Id 1337',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 12:16:48'),(1292,'1','313',1,'Retail Sale Id 1338',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-04 12:18:21'),(1293,'1','313',1,'Retail Sale Id 1339',0.00,4840.00,710.00,5680.00,840.00,'2023-03-04 12:21:09'),(1294,'1','313',1,'Retail Sale Id 1340',0.00,1512.50,710.00,1775.00,262.50,'2023-03-04 12:23:55'),(1295,'1','313',1,'Retail Sale Id 1341',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 12:28:30'),(1296,'1','313',1,'Retail Sale Id 1342',0.00,641.30,710.00,752.60,111.30,'2023-03-04 12:30:16'),(1297,'1','313',1,'Retail Sale Id 1343',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 12:31:02'),(1298,'1','313',1,'Retail Sale Id 1344',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 12:33:54'),(1299,'1','313',1,'Retail Sale Id 1345',0.00,2129.60,710.00,2499.20,369.60,'2023-03-04 12:35:26'),(1300,'1','313',1,'Retail Sale Id 1346',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 12:36:32'),(1301,'1','313',1,'Retail Sale Id 1347',0.00,2559.15,710.00,3003.30,444.15,'2023-03-04 12:39:12'),(1302,'1','313',1,'Retail Sale Id 1348',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 12:41:33'),(1303,'1','313',1,'Retail Sale Id 1349',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 12:43:50'),(1304,'1','313',1,'Retail Sale Id 1350',0.00,1833.15,710.00,2151.30,318.15,'2023-03-04 12:45:23'),(1305,'1','313',1,'Retail Sale Id 1351',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-04 12:46:59'),(1306,'1','313',1,'Retail Sale Id 1352',0.00,4235.00,710.00,4970.00,735.00,'2023-03-04 12:48:13'),(1307,'1','313',1,'Retail Sale Id 1353',0.00,4235.00,710.00,4970.00,735.00,'2023-03-04 12:49:31'),(1308,'1','313',1,'Retail Sale Id 1354',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 12:50:44'),(1309,'1','313',1,'Retail Sale Id 1355',0.00,641.30,710.00,752.60,111.30,'2023-03-04 12:51:49'),(1310,'1','313',1,'Retail Sale Id 1356',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 12:52:53'),(1311,'1','313',1,'Retail Sale Id 1357',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 12:54:11'),(1312,'1','313',1,'Retail Sale Id 1358',0.00,4840.00,710.00,5680.00,840.00,'2023-03-04 12:55:30'),(1313,'1','313',1,'Retail Sale Id 1359',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 12:56:42'),(1314,'1','313',1,'Retail Sale Id 1360',0.00,641.30,710.00,752.60,111.30,'2023-03-04 12:58:07'),(1315,'1','313',1,'Retail Sale Id 1361',0.00,75975.90,670.00,84138.60,8162.70,'2023-03-04 13:00:48'),(1316,'1','313',1,'Retail Sale Id 1362',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 13:02:11'),(1317,'1','313',1,'Retail Sale Id 1363',0.00,641.30,710.00,752.60,111.30,'2023-03-04 13:05:17'),(1318,'1','313',1,'Retail Sale Id 1364',0.00,1234.20,710.00,1448.40,214.20,'2023-03-04 13:07:54'),(1319,'1','313',1,'Retail Sale Id 1365',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 13:09:09'),(1320,'1','313',1,'Retail Sale Id 1366',0.00,1512.50,710.00,1775.00,262.50,'2023-03-04 13:10:20'),(1321,'1','313',1,'Retail Sale Id 1367',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-04 13:11:23'),(1322,'1','313',1,'Retail Sale Id 1368',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-04 13:12:44'),(1323,'1','313',1,'Retail Sale Id 1369',0.00,4259.20,710.00,4998.40,739.20,'2023-03-04 13:14:18'),(1324,'1','313',1,'Retail Sale Id 1370',0.00,3406.15,710.00,3997.30,591.15,'2023-03-04 13:16:14'),(1325,'1','313',1,'Retail Sale Id 1371',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 13:17:41'),(1326,'1','313',1,'Retail Sale Id 1372',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 13:18:45'),(1327,'1','313',1,'Retail Sale Id 1373',0.00,12100.00,710.00,14200.00,2100.00,'2023-03-04 13:19:56'),(1328,'1','313',1,'Retail Sale Id 1374',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-04 13:21:18'),(1329,'1','313',1,'Retail Sale Id 1375',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 13:22:35'),(1330,'1','313',1,'Retail Sale Id 1376',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 13:23:24'),(1331,'1','313',1,'Retail Sale Id 1377',0.00,36638.80,670.00,40575.20,3936.40,'2023-03-04 13:25:17'),(1332,'1','313',1,'Retail Sale Id 1378',0.00,605.00,710.00,710.00,105.00,'2023-03-04 13:27:15'),(1333,'1','313',1,'Retail Sale Id 1379',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 13:28:13'),(1334,'1','313',1,'Retail Sale Id 1380',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 13:29:03'),(1335,'1','313',1,'Retail Sale Id 1381',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 13:31:09'),(1336,'1','313',1,'Retail Sale Id 1382',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 13:32:25'),(1337,'1','313',1,'Retail Sale Id 1383',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 13:34:39'),(1338,'1','313',1,'Retail Sale Id 1384',0.00,605.00,710.00,710.00,105.00,'2023-03-04 13:35:53'),(1339,'1','313',1,'Retail Sale Id 1385',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 13:37:13'),(1340,'1','313',1,'Retail Sale Id 1386',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 13:37:52'),(1341,'1','313',1,'Retail Sale Id 1387',0.00,3630.00,710.00,4260.00,630.00,'2023-03-04 13:41:30'),(1342,'1','313',1,'Retail Sale Id 1388',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 13:42:22'),(1343,'1','313',1,'Retail Sale Id 1389',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 13:44:06'),(1344,'1','313',1,'Retail Sale Id 1390',0.00,3630.00,710.00,4260.00,630.00,'2023-03-04 13:45:16'),(1345,'1','313',1,'Retail Sale Id 1391',0.00,3630.00,710.00,4260.00,630.00,'2023-03-04 13:46:29'),(1346,'1','313',1,'Retail Sale Id 1392',0.00,1833.15,710.00,2151.30,318.15,'2023-03-04 13:48:08'),(1347,'1','313',1,'Retail Sale Id 1393',0.00,3630.00,710.00,4260.00,630.00,'2023-03-04 13:49:06'),(1348,'1','313',1,'Retail Sale Id 1394',0.00,3630.00,710.00,4260.00,630.00,'2023-03-04 13:50:52'),(1349,'1','313',1,'Retail Sale Id 1395',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 13:52:24'),(1350,'1','313',1,'Retail Sale Id 1396',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 13:53:53'),(1351,'1','313',1,'Retail Sale Id 1397',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 13:55:16'),(1352,'1','313',1,'Retail Sale Id 1398',0.00,1276.55,710.00,1498.10,221.55,'2023-03-04 13:58:47'),(1353,'1','313',1,'Retail Sale Id 1399',0.00,605.00,710.00,710.00,105.00,'2023-03-04 14:00:37'),(1354,'1','313',1,'Retail Sale Id 1400',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-04 14:01:26'),(1355,'1','313',1,'Retail Sale Id 1401',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 14:02:19'),(1356,'1','313',1,'Retail Sale Id 1402',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-04 14:03:43'),(1357,'1','313',1,'Retail Sale Id 1403',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 14:06:46'),(1358,'1','313',1,'Retail Sale Id 1404',0.00,9075.00,710.00,10650.00,1575.00,'2023-03-04 14:07:47'),(1359,'1','313',1,'Retail Sale Id 1405',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 14:08:44'),(1360,'1','313',1,'Retail Sale Id 1406',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-04 14:09:44'),(1361,'1','313',1,'Retail Sale Id 1407',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 14:11:45'),(1362,'1','313',1,'Retail Sale Id 1408',0.00,1833.15,710.00,2151.30,318.15,'2023-03-04 14:13:00'),(1363,'1','313',1,'Retail Sale Id 1409',0.00,4235.00,710.00,4970.00,735.00,'2023-03-04 14:14:11'),(1364,'1','313',1,'Retail Sale Id 1410',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-04 14:16:03'),(1365,'1','313',1,'Retail Sale Id 1411',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 14:17:38'),(1366,'1','313',1,'Retail Sale Id 1412',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 14:20:08'),(1367,'1','313',1,'Retail Sale Id 1413',0.00,1234.20,710.00,1448.40,214.20,'2023-03-04 14:21:31'),(1368,'1','313',1,'Retail Sale Id 1414',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 14:28:01'),(1369,'1','313',1,'Retail Sale Id 1415',0.00,3630.00,710.00,4260.00,630.00,'2023-03-04 14:28:49'),(1370,'1','313',1,'Retail Sale Id 1416',0.00,1706.10,710.00,2002.20,296.10,'2023-03-04 14:30:04'),(1371,'1','313',1,'Retail Sale Id 1417',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 14:31:39'),(1372,'1','313',1,'Retail Sale Id 1418',0.00,1234.20,710.00,1448.40,214.20,'2023-03-04 14:34:52'),(1373,'1','313',1,'Retail Sale Id 1419',0.00,4235.00,710.00,4970.00,735.00,'2023-03-04 14:38:29'),(1374,'1','313',1,'Retail Sale Id 1420',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 14:42:33'),(1375,'1','313',1,'Retail Sale Id 1421',0.00,1833.15,710.00,2151.30,318.15,'2023-03-04 14:44:32'),(1376,'1','313',1,'Retail Sale Id 1422',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-04 14:47:25'),(1377,'1','313',1,'Retail Sale Id 1423',0.00,1234.20,710.00,1448.40,214.20,'2023-03-04 14:49:00'),(1378,'1','313',1,'Retail Sale Id 1424',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 14:50:08'),(1379,'1','313',1,'Retail Sale Id 1425',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 14:51:45'),(1380,'1','313',1,'Retail Sale Id 1426',0.00,3630.00,710.00,4260.00,630.00,'2023-03-04 14:53:11'),(1381,'1','313',1,'Retail Sale Id 1427',0.00,907.50,710.00,1065.00,157.50,'2023-03-04 14:54:40'),(1382,'1','313',1,'Retail Sale Id 1428',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 14:56:47'),(1383,'1','313',1,'Retail Sale Id 1429',0.00,4235.00,710.00,4970.00,735.00,'2023-03-04 14:58:07'),(1384,'1','313',1,'Retail Sale Id 1430',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 15:02:10'),(1385,'1','313',1,'Retail Sale Id 1431',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 15:04:23'),(1386,'1','313',1,'Retail Sale Id 1432',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 15:07:36'),(1387,'1','313',1,'Retail Sale Id 1433',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 15:09:59'),(1388,'1','313',1,'Retail Sale Id 1434',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 15:11:55'),(1389,'1','313',1,'Retail Sale Id 1435',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 15:13:33'),(1390,'1','313',1,'Retail Sale Id 1436',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 15:15:38'),(1391,'1','313',1,'Retail Sale Id 1437',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 15:17:27'),(1392,'1','313',1,'Retail Sale Id 1438',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-04 15:18:35'),(1393,'1','313',1,'Retail Sale Id 1439',0.00,1833.15,710.00,2151.30,318.15,'2023-03-04 15:20:51'),(1394,'1','313',1,'Retail Sale Id 1440',0.00,598.95,710.00,702.90,103.95,'2023-03-04 15:23:13'),(1395,'1','313',1,'Retail Sale Id 1443',0.00,4259.20,710.00,4998.40,739.20,'2023-03-04 15:26:10'),(1396,'1','313',1,'Retail Sale Id 1444',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-04 15:28:18'),(1397,'1','313',1,'Retail Sale Id 1445',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-04 15:29:37'),(1398,'1','313',1,'Retail Sale Id 1446',0.00,4537.50,710.00,5325.00,787.50,'2023-03-04 15:31:36'),(1399,'1','313',1,'Retail Sale Id 1447',0.00,1706.10,710.00,2002.20,296.10,'2023-03-04 15:32:43'),(1400,'1','313',1,'Retail Sale Id 1448',0.00,641.30,710.00,752.60,111.30,'2023-03-04 15:33:57'),(1401,'1','313',1,'Retail Sale Id 1449',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 15:35:55'),(1402,'1','313',1,'Retail Sale Id 1451',0.00,1234.20,710.00,1448.40,214.20,'2023-03-04 15:37:28'),(1403,'1','313',1,'Retail Sale Id 1452',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 15:39:57'),(1404,'1','313',1,'Retail Sale Id 1453',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 15:41:26'),(1405,'1','313',1,'Retail Sale Id 1454',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-04 15:44:00'),(1406,'1','313',1,'Retail Sale Id 1455',0.00,853.05,710.00,1001.10,148.05,'2023-03-04 15:45:28'),(1407,'1','313',1,'Retail Sale Id 1456',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 15:47:18'),(1408,'1','313',1,'Retail Sale Id 1458',0.00,1234.20,710.00,1448.40,214.20,'2023-03-04 15:48:19'),(1409,'1','313',1,'Retail Sale Id 1459',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 15:49:35'),(1410,'1','313',1,'Retail Sale Id 1460',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-04 15:51:57'),(1411,'1','313',1,'Retail Sale Id 1462',0.00,1706.10,710.00,2002.20,296.10,'2023-03-04 15:53:33'),(1412,'1','313',1,'Retail Sale Id 1463',0.00,605.00,710.00,710.00,105.00,'2023-03-04 15:56:24'),(1413,'1','313',1,'Retail Sale Id 1464',0.00,641.30,710.00,752.60,111.30,'2023-03-04 15:57:15'),(1414,'1','313',1,'Retail Sale Id 1465',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 15:58:27'),(1415,'1','313',1,'Retail Sale Id 1466',0.00,641.30,710.00,752.60,111.30,'2023-03-04 15:59:19'),(1416,'1','313',1,'Retail Sale Id 1467',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-04 16:02:09'),(1417,'1','313',1,'Retail Sale Id 1468',0.00,33275.00,670.00,36850.00,3575.00,'2023-03-04 16:07:20'),(1418,'1','313',1,'Retail Sale Id 1469',0.00,641.30,710.00,752.60,111.30,'2023-03-04 16:08:47'),(1419,'1','313',1,'Retail Sale Id 1470',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 16:09:36'),(1420,'1','313',1,'Retail Sale Id 1471',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-04 16:11:22'),(1421,'1','313',1,'Retail Sale Id 1472',0.00,2413.95,710.00,2832.90,418.95,'2023-03-04 16:12:41'),(1422,'1','313',1,'Retail Sale Id 1473',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 16:14:16'),(1423,'1','313',1,'Retail Sale Id 1474',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 16:15:52'),(1424,'1','313',1,'Retail Sale Id 1475',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 16:17:17'),(1425,'1','313',1,'Retail Sale Id 1476',0.00,7671.40,710.00,9002.80,1331.40,'2023-03-04 16:18:37'),(1426,'1','313',1,'Retail Sale Id 1477',0.00,6818.35,710.00,8001.70,1183.35,'2023-03-04 16:20:00'),(1427,'1','313',1,'Retail Sale Id 1478',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 16:21:09'),(1428,'1','313',1,'Retail Sale Id 1479',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 16:22:06'),(1429,'1','313',1,'Retail Sale Id 1480',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-04 16:23:09'),(1430,'1','313',1,'Retail Sale Id 1481',0.00,36481.50,670.00,40401.00,3919.50,'2023-03-04 16:28:43'),(1431,'1','313',1,'Retail Sale Id 1482',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 16:31:04'),(1432,'1','313',1,'Retail Sale Id 1483',0.00,641.30,710.00,752.60,111.30,'2023-03-04 16:31:52'),(1433,'1','313',1,'Retail Sale Id 1484',0.00,7865.00,710.00,9230.00,1365.00,'2023-03-04 16:32:28'),(1434,'1','313',1,'Retail Sale Id 1485',0.00,605.00,710.00,710.00,105.00,'2023-03-04 16:33:10'),(1435,'1','313',1,'Retail Sale Id 1486',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 16:38:19'),(1436,'1','313',1,'Retail Sale Id 1487',0.00,1276.55,710.00,1498.10,221.55,'2023-03-04 16:41:48'),(1437,'1','313',1,'Retail Sale Id 1488',0.00,605.00,710.00,710.00,105.00,'2023-03-04 16:43:30'),(1438,'1','313',1,'Retail Sale Id 1489',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 16:45:06'),(1439,'1','313',1,'Retail Sale Id 1490',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 16:46:33'),(1440,'1','313',1,'Retail Sale Id 1491',0.00,14520.00,710.00,17040.00,2520.00,'2023-03-04 16:48:41'),(1441,'1','313',1,'Return of Retail Sale Id 1491',14520.00,0.00,710.00,-17040.00,-2520.00,'2023-03-04 16:50:04'),(1442,'1','313',1,'Retail Sale Id 1492',0.00,4259.20,710.00,4998.40,739.20,'2023-03-04 16:51:39'),(1443,'1','313',1,'Retail Sale Id 1493',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-04 16:52:52'),(1444,'1','313',1,'Retail Sale Id 1494',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-04 16:53:49'),(1445,'1','313',1,'Retail Sale Id 1495',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-04 16:55:12'),(1446,'1','313',1,'Retail Sale Id 1496',0.00,19511.25,670.00,21607.50,2096.25,'2023-03-04 16:57:31'),(1447,'1','313',1,'Retail Sale Id 1497',0.00,605.00,710.00,710.00,105.00,'2023-03-04 16:58:46'),(1448,'1','313',1,'Retail Sale Id 1498',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 17:00:38'),(1449,'1','313',1,'Retail Sale Id 1499',0.00,29645.00,670.00,32830.00,3185.00,'2023-03-04 17:03:17'),(1450,'1','313',1,'Retail Sale Id 1500',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-04 17:05:16'),(1451,'1','313',1,'Retail Sale Id 1502',0.00,1210.00,710.00,1420.00,210.00,'2023-03-04 17:11:09'),(1452,'1','313',1,'Retail Sale Id 1503',0.00,605.00,710.00,710.00,105.00,'2023-03-04 17:16:09'),(1453,'1','313',1,'Retail Sale Id 1504',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 17:17:03'),(1454,'1','313',1,'Retail Sale Id 1505',0.00,1815.00,710.00,2130.00,315.00,'2023-03-04 17:18:46'),(1455,'1','313',1,'Retail Sale Id 1506',0.00,3025.00,710.00,3550.00,525.00,'2023-03-04 17:20:50'),(1456,'1','313',1,'Retail Sale Id 1507',0.00,641.30,710.00,752.60,111.30,'2023-03-04 17:21:37'),(1457,'1','313',1,'Retail Sale Id 1508',0.00,2420.00,710.00,2840.00,420.00,'2023-03-04 17:23:02'),(1458,'1','313',1,'Retail Sale Id 1509',0.00,2559.15,710.00,3003.30,444.15,'2023-03-04 17:24:32'),(1459,'1','313',1,'Return of Retail Sale Id 1373',12100.00,0.00,710.00,-14200.00,-2100.00,'2023-03-04 17:52:41'),(1460,'1','313',1,'Retail Sale Id 1511',0.00,12100.00,670.00,13400.00,1300.00,'2023-03-04 17:53:19'),(1461,'1','313',1,'Return of Retail Sale Id 1410',7562.50,0.00,710.00,-8875.00,-1312.50,'2023-03-04 17:54:55'),(1462,'1','313',1,'Retail Sale Id 1512',0.00,7562.50,670.00,8375.00,812.50,'2023-03-04 17:55:38'),(1463,'1','313',1,'Return of Retail Sale Id 1487',1276.55,0.00,710.00,-1498.10,-221.55,'2023-03-04 17:56:58'),(1464,'1','313',1,'Return of Retail Sale Id 1429',4235.00,0.00,710.00,-4970.00,-735.00,'2023-03-04 17:58:42'),(1465,'1','313',1,'Return of Retail Sale Id 1502',1210.00,0.00,710.00,-1420.00,-210.00,'2023-03-04 17:59:45'),(1466,'1','313',1,'Return of Retail Sale Id 1476',7671.40,0.00,710.00,-9002.80,-1331.40,'2023-03-04 18:00:55'),(1467,'1','313',1,'Retail Sale Id 1513',0.00,31187.75,710.00,36600.50,5412.75,'2023-03-04 18:04:18'),(1468,'1','313',1,'Return of Retail Sale Id 1513',31187.75,0.00,710.00,-36600.50,-5412.75,'2023-03-04 18:17:56'),(1469,'1','313',1,'Retail Sale Id 1514',0.00,20733.35,710.00,24331.70,3598.35,'2023-03-04 18:19:03'),(1470,'1','313',1,'Return of Retail Sale Id 1377',36638.80,0.00,670.00,-40575.20,-3936.40,'2023-03-04 18:28:51'),(1471,'1','313',1,'Retail Sale Id 1515',0.00,36396.80,670.00,40307.20,3910.40,'2023-03-04 18:30:11'),(1472,'1','313',1,'Retail Sale Id 1516',0.00,683.65,710.00,802.30,118.65,'2023-03-05 10:29:28'),(1473,'1','313',1,'Retail Sale Id 1517',0.00,1706.10,710.00,2002.20,296.10,'2023-03-05 10:31:01'),(1474,'1','313',1,'Retail Sale Id 1518',0.00,641.30,710.00,752.60,111.30,'2023-03-05 10:31:45'),(1475,'1','313',1,'Retail Sale Id 1519',0.00,4235.00,710.00,4970.00,735.00,'2023-03-05 10:32:43'),(1476,'1','313',1,'Retail Sale Id 1520',0.00,605.00,710.00,710.00,105.00,'2023-03-05 10:34:16'),(1477,'1','313',1,'Retail Sale Id 1521',0.00,28435.00,670.00,31490.00,3055.00,'2023-03-05 10:35:56'),(1478,'1','313',1,'Retail Sale Id 1522',0.00,853.05,710.00,1001.10,148.05,'2023-03-05 10:36:40'),(1479,'1','313',1,'Retail Sale Id 1523',0.00,1210.00,710.00,1420.00,210.00,'2023-03-05 10:37:29'),(1480,'1','313',1,'Retail Sale Id 1524',0.00,1815.00,710.00,2130.00,315.00,'2023-03-05 10:38:36'),(1481,'1','313',1,'Retail Sale Id 1525',0.00,1210.00,710.00,1420.00,210.00,'2023-03-05 10:39:42'),(1482,'1','313',1,'Retail Sale Id 1526',0.00,28798.00,670.00,31892.00,3094.00,'2023-03-05 10:41:31'),(1483,'1','313',1,'Retail Sale Id 1527',0.00,683.65,710.00,802.30,118.65,'2023-03-05 10:44:34'),(1484,'1','313',1,'Retail Sale Id 1528',0.00,1815.00,710.00,2130.00,315.00,'2023-03-05 10:45:18'),(1485,'1','313',1,'Retail Sale Id 1529',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-05 10:46:24'),(1486,'1','313',1,'Retail Sale Id 1530',0.00,1210.00,710.00,1420.00,210.00,'2023-03-05 10:47:40'),(1487,'1','313',1,'Retail Sale Id 1531',0.00,10890.00,710.00,12780.00,1890.00,'2023-03-05 10:48:41'),(1488,'1','313',1,'Retail Sale Id 1532',0.00,2559.15,710.00,3003.30,444.15,'2023-03-05 10:52:18'),(1489,'1','313',1,'Return of Retail Sale Id 1521',28435.00,0.00,670.00,-31490.00,-3055.00,'2023-03-05 10:53:17'),(1490,'1','313',1,'Retail Sale Id 1533',0.00,3406.15,710.00,3997.30,591.15,'2023-03-05 11:03:07'),(1491,'1','313',1,'Retail Sale Id 1534',0.00,3630.00,710.00,4260.00,630.00,'2023-03-05 11:05:25'),(1492,'1','313',1,'Retail Sale Id 1535',0.00,1815.00,710.00,2130.00,315.00,'2023-03-05 11:06:44'),(1493,'1','313',1,'Retail Sale Id 1536',0.00,1210.00,710.00,1420.00,210.00,'2023-03-05 11:10:16'),(1494,'1','313',1,'Retail Sale Id 1537',0.00,1276.55,710.00,1498.10,221.55,'2023-03-05 11:14:52'),(1495,'1','313',1,'Retail Sale Id 1538',0.00,3630.00,710.00,4260.00,630.00,'2023-03-05 11:16:35'),(1496,'1','313',1,'Retail Sale Id 1539',0.00,605.00,710.00,710.00,105.00,'2023-03-05 11:21:04'),(1497,'1','313',1,'Retail Sale Id 1540',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-05 11:27:21'),(1498,'1','313',1,'Retail Sale Id 1541',0.00,3025.00,710.00,3550.00,525.00,'2023-03-05 11:29:08'),(1499,'1','313',1,'Retail Sale Id 1542',0.00,853.05,710.00,1001.10,148.05,'2023-03-05 11:30:16'),(1500,'1','313',1,'Retail Sale Id 1543',0.00,1234.20,710.00,1448.40,214.20,'2023-03-05 11:32:53'),(1501,'1','313',1,'Retail Sale Id 1544',0.00,683.65,710.00,802.30,118.65,'2023-03-05 11:45:24'),(1502,'1','313',1,'Retail Sale Id 1545',0.00,1276.55,710.00,1498.10,221.55,'2023-03-05 11:47:12'),(1503,'1','313',1,'Retail Sale Id 1546',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-05 11:54:15'),(1504,'1','313',1,'Retail Sale Id 1547',0.00,3406.15,710.00,3997.30,591.15,'2023-03-05 12:01:50'),(1505,'1','313',1,'Retail Sale Id 1548',0.00,3025.00,710.00,3550.00,525.00,'2023-03-05 12:07:05'),(1506,'1','313',1,'Retail Sale Id 1549',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-05 12:11:27'),(1507,'1','313',1,'Retail Sale Id 1550',0.00,1706.10,710.00,2002.20,296.10,'2023-03-05 12:12:57'),(1508,'1','313',1,'Retail Sale Id 1551',0.00,605.00,710.00,710.00,105.00,'2023-03-05 12:14:29'),(1509,'1','313',1,'Retail Sale Id 1552',0.00,907.50,710.00,1065.00,157.50,'2023-03-05 12:29:18'),(1510,'1','313',1,'Retail Sale Id 1553',0.00,1210.00,710.00,1420.00,210.00,'2023-03-05 12:31:19'),(1511,'1','313',1,'Retail Sale Id 1554',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-05 12:33:20'),(1512,'1','313',1,'Retail Sale Id 1555',0.00,2559.15,710.00,3003.30,444.15,'2023-03-05 12:35:42'),(1513,'1','313',1,'Retail Sale Id 1556',0.00,1210.00,710.00,1420.00,210.00,'2023-03-05 12:39:42'),(1514,'1','313',1,'Retail Sale Id 1557',0.00,1815.00,710.00,2130.00,315.00,'2023-03-05 12:44:31'),(1515,'1','313',1,'Retail Sale Id 1558',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-05 12:48:34'),(1516,'1','313',1,'Retail Sale Id 1559',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-05 12:49:43'),(1517,'1','313',1,'Retail Sale Id 1560',0.00,1210.00,710.00,1420.00,210.00,'2023-03-05 12:52:51'),(1518,'1','313',1,'Retail Sale Id 1561',0.00,1210.00,710.00,1420.00,210.00,'2023-03-05 12:54:26'),(1519,'1','313',1,'Retail Sale Id 1562',0.00,3630.00,710.00,4260.00,630.00,'2023-03-05 13:03:19'),(1520,'1','313',1,'Retail Sale Id 1563',0.00,3025.00,710.00,3550.00,525.00,'2023-03-05 13:05:17'),(1521,'1','313',1,'Retail Sale Id 1564',0.00,683.65,710.00,802.30,118.65,'2023-03-05 13:07:02'),(1522,'1','313',1,'Retail Sale Id 1565',0.00,2420.00,710.00,2840.00,420.00,'2023-03-05 13:10:11'),(1523,'1','313',1,'Retail Sale Id 1566',0.00,103479.20,670.00,114596.80,11117.60,'2023-03-05 13:13:19'),(1524,'1','313',1,'Retail Sale Id 1567',0.00,1276.55,710.00,1498.10,221.55,'2023-03-05 13:15:17'),(1525,'1','313',1,'Retail Sale Id 1568',0.00,4235.00,710.00,4970.00,735.00,'2023-03-05 13:17:04'),(1526,'1','313',1,'Retail Sale Id 1569',0.00,1815.00,710.00,2130.00,315.00,'2023-03-05 13:18:17'),(1527,'1','313',1,'Retail Sale Id 1570',0.00,145200.00,670.00,160800.00,15600.00,'2023-03-05 13:30:55'),(1528,'1','313',1,'Retail Sale Id 1571',0.00,1210.00,710.00,1420.00,210.00,'2023-03-05 13:32:57'),(1529,'1','313',1,'Retail Sale Id 1572',0.00,1815.00,710.00,2130.00,315.00,'2023-03-05 13:33:47'),(1530,'1','313',1,'Retail Sale Id 1573',0.00,605.00,710.00,710.00,105.00,'2023-03-05 13:35:03'),(1531,'1','313',1,'Retail Sale Id 1574',0.00,1815.00,710.00,2130.00,315.00,'2023-03-05 13:38:24'),(1532,'1','313',1,'Retail Sale Id 1575',0.00,5445.00,710.00,6390.00,945.00,'2023-03-05 13:42:33'),(1533,'1','313',1,'Retail Sale Id 1576',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-05 13:44:42'),(1534,'1','313',1,'Retail Sale Id 1577',0.00,3630.00,710.00,4260.00,630.00,'2023-03-05 13:46:21'),(1535,'1','313',1,'Retail Sale Id 1578',0.00,142580.35,670.00,157898.90,15318.55,'2023-03-05 14:04:53'),(1536,'1','313',1,'Retail Sale Id 1579',0.00,1210.00,710.00,1420.00,210.00,'2023-03-05 14:06:27'),(1537,'1','313',1,'Retail Sale Id 1580',0.00,605.00,710.00,710.00,105.00,'2023-03-05 14:07:48'),(1538,'1','313',1,'Retail Sale Id 1581',0.00,3630.00,710.00,4260.00,630.00,'2023-03-05 14:09:22'),(1539,'1','313',1,'Return of Retail Sale Id 1570',145200.00,0.00,670.00,-160800.00,-15600.00,'2023-03-05 14:11:30'),(1540,'1','313',1,'Retail Sale Id 1582',0.00,6050.00,670.00,6700.00,650.00,'2023-03-05 14:12:35'),(1541,'1','313',1,'Retail Sale Id 1583',0.00,605.00,710.00,710.00,105.00,'2023-03-05 14:14:50'),(1542,'1','313',1,'Retail Sale Id 1584',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-05 14:15:56'),(1543,'1','313',1,'Retail Sale Id 1585',0.00,1210.00,710.00,1420.00,210.00,'2023-03-05 14:17:48'),(1544,'1','313',1,'Retail Sale Id 1586',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-05 14:19:04'),(1545,'1','313',1,'Retail Sale Id 1587',0.00,3630.00,710.00,4260.00,630.00,'2023-03-05 14:30:44'),(1546,'1','313',1,'Retail Sale Id 1588',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-05 14:42:28'),(1547,'1','313',1,'Retail Sale Id 1589',0.00,605.00,710.00,710.00,105.00,'2023-03-05 14:44:17'),(1548,'1','313',1,'Retail Sale Id 1590',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-05 14:46:20'),(1549,'1','313',1,'Retail Sale Id 1591',0.00,641.30,710.00,752.60,111.30,'2023-03-05 14:49:43'),(1550,'1','313',1,'Retail Sale Id 1592',0.00,1815.00,710.00,2130.00,315.00,'2023-03-05 14:52:29'),(1551,'1','313',1,'Retail Sale Id 1593',0.00,1706.10,710.00,2002.20,296.10,'2023-03-05 14:54:12'),(1552,'1','313',1,'Retail Sale Id 1594',0.00,1621.40,710.00,1902.80,281.40,'2023-03-05 14:57:25'),(1553,'1','313',1,'Retail Sale Id 1595',0.00,2420.00,710.00,2840.00,420.00,'2023-03-05 14:59:02'),(1554,'1','313',1,'Retail Sale Id 1596',0.00,3630.00,710.00,4260.00,630.00,'2023-03-05 15:00:34'),(1555,'1','313',1,'Retail Sale Id 1597',0.00,3630.00,710.00,4260.00,630.00,'2023-03-05 15:01:56'),(1556,'1','313',1,'Retail Sale Id 1598',0.00,3025.00,710.00,3550.00,525.00,'2023-03-05 15:05:44'),(1557,'1','313',1,'Retail Sale Id 1599',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-05 15:08:05'),(1558,'1','313',1,'Retail Sale Id 1600',0.00,3630.00,710.00,4260.00,630.00,'2023-03-05 15:09:43'),(1559,'1','313',1,'Retail Sale Id 1601',0.00,3025.00,710.00,3550.00,525.00,'2023-03-05 15:16:46'),(1560,'1','313',1,'Retail Sale Id 1602',0.00,1234.20,710.00,1448.40,214.20,'2023-03-05 15:18:25'),(1561,'1','313',1,'Retail Sale Id 1603',0.00,641.30,710.00,752.60,111.30,'2023-03-05 15:24:40'),(1562,'1','313',1,'Retail Sale Id 1604',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-05 15:28:39'),(1563,'1','313',1,'Retail Sale Id 1605',0.00,1210.00,710.00,1420.00,210.00,'2023-03-05 15:32:47'),(1564,'1','313',1,'Retail Sale Id 1606',0.00,1815.00,710.00,2130.00,315.00,'2023-03-05 15:34:41'),(1565,'1','313',1,'Retail Sale Id 1607',0.00,641.30,710.00,752.60,111.30,'2023-03-05 15:35:55'),(1566,'1','313',1,'Retail Sale Id 1608',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-05 15:37:03'),(1567,'1','313',1,'Retail Sale Id 1609',0.00,1833.15,710.00,2151.30,318.15,'2023-03-05 15:38:13'),(1568,'1','313',1,'Retail Sale Id 1610',0.00,1210.00,710.00,1420.00,210.00,'2023-03-05 15:44:50'),(1569,'1','313',1,'Return of Retail Sale Id 1604',30250.00,0.00,670.00,-33500.00,-3250.00,'2023-03-05 15:46:23'),(1570,'1','313',1,'Retail Sale Id 1611',0.00,1210.00,710.00,1420.00,210.00,'2023-03-05 15:57:21'),(1571,'1','313',1,'Retail Sale Id 1612',0.00,641.30,710.00,752.60,111.30,'2023-03-05 16:00:56'),(1572,'1','313',1,'Retail Sale Id 1613',0.00,641.30,710.00,752.60,111.30,'2023-03-05 16:05:45'),(1573,'1','313',1,'Retail Sale Id 1614',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-05 16:08:00'),(1574,'1','313',1,'Retail Sale Id 1616',0.00,21175.00,670.00,23450.00,2275.00,'2023-03-05 16:14:24'),(1575,'1','313',1,'Retail Sale Id 1617',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-05 16:16:50'),(1576,'1','313',1,'Retail Sale Id 1618',0.00,1210.00,710.00,1420.00,210.00,'2023-03-05 16:18:15'),(1577,'1','313',1,'Retail Sale Id 1619',0.00,1210.00,710.00,1420.00,210.00,'2023-03-05 16:23:55'),(1578,'1','313',1,'Retail Sale Id 1620',0.00,3025.00,710.00,3550.00,525.00,'2023-03-05 16:25:20'),(1579,'1','313',1,'Retail Sale Id 1621',0.00,7865.00,710.00,9230.00,1365.00,'2023-03-05 16:32:14'),(1580,'1','313',1,'Retail Sale Id 1622',0.00,853.05,710.00,1001.10,148.05,'2023-03-05 16:47:45'),(1581,'1','313',1,'Retail Sale Id 1623',0.00,1276.55,710.00,1498.10,221.55,'2023-03-05 16:57:48'),(1582,'1','313',1,'Return of Retail Sale Id 1572',1815.00,0.00,710.00,-2130.00,-315.00,'2023-03-05 17:15:12'),(1583,'1','313',1,'Retail Sale Id 1625',0.00,1591.15,710.00,1867.30,276.15,'2023-03-05 17:16:01'),(1584,'1','313',1,'Return of Retail Sale Id 1559',30250.00,0.00,670.00,-33500.00,-3250.00,'2023-03-05 17:19:10'),(1585,'1','313',1,'Retail Sale Id 1626',0.00,30231.85,670.00,33479.90,3248.05,'2023-03-05 17:19:57'),(1586,'1','313',1,'Retail Sale Id 1627',0.00,605.00,710.00,710.00,105.00,'2023-03-06 08:01:16'),(1587,'1','313',1,'Retail Sale Id 1628',0.00,641.30,710.00,752.60,111.30,'2023-03-06 08:02:12'),(1588,'1','313',1,'Retail Sale Id 1629',0.00,2420.00,710.00,2840.00,420.00,'2023-03-06 08:03:36'),(1589,'1','313',1,'Retail Sale Id 1630',0.00,605.00,710.00,710.00,105.00,'2023-03-06 08:04:22'),(1590,'1','313',1,'Retail Sale Id 1631',0.00,2420.00,710.00,2840.00,420.00,'2023-03-06 08:05:16'),(1591,'1','313',1,'Retail Sale Id 1632',0.00,1276.55,710.00,1498.10,221.55,'2023-03-06 08:06:10'),(1592,'1','313',1,'Retail Sale Id 1633',0.00,3025.00,710.00,3550.00,525.00,'2023-03-06 08:07:53'),(1593,'1','313',1,'Retail Sale Id 1634',0.00,3025.00,710.00,3550.00,525.00,'2023-03-06 08:09:09'),(1594,'1','313',1,'Retail Sale Id 1635',0.00,2420.00,710.00,2840.00,420.00,'2023-03-06 08:10:18'),(1595,'1','313',1,'Retail Sale Id 1637',0.00,1790.80,710.00,2101.60,310.80,'2023-03-06 08:12:54'),(1596,'1','313',1,'Retail Sale Id 1638',0.00,5965.30,710.00,7000.60,1035.30,'2023-03-06 08:13:57'),(1597,'1','313',1,'Retail Sale Id 1639',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-06 08:15:31'),(1598,'1','313',1,'Retail Sale Id 1640',0.00,9075.00,710.00,10650.00,1575.00,'2023-03-06 08:16:32'),(1599,'1','313',1,'Retail Sale Id 1641',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-06 08:17:53'),(1600,'1','313',1,'Retail Sale Id 1642',0.00,4235.00,710.00,4970.00,735.00,'2023-03-06 08:19:13'),(1601,'1','313',1,'Retail Sale Id 1643',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 08:20:56'),(1602,'1','313',1,'Retail Sale Id 1644',0.00,1234.20,710.00,1448.40,214.20,'2023-03-06 08:24:26'),(1603,'1','313',1,'Retail Sale Id 1645',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 08:26:17'),(1604,'1','313',1,'Retail Sale Id 1646',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 08:27:08'),(1605,'1','313',1,'Retail Sale Id 1647',0.00,18755.00,710.00,22010.00,3255.00,'2023-03-06 08:30:33'),(1606,'1','313',1,'Retail Sale Id 1648',0.00,605.00,710.00,710.00,105.00,'2023-03-06 08:30:59'),(1607,'1','313',1,'Retail Sale Id 1649',0.00,4840.00,710.00,5680.00,840.00,'2023-03-06 08:33:19'),(1608,'1','313',1,'Retail Sale Id 1650',0.00,605.00,710.00,710.00,105.00,'2023-03-06 08:34:38'),(1609,'1','313',1,'Retail Sale Id 1651',0.00,4235.00,710.00,4970.00,735.00,'2023-03-06 08:35:30'),(1610,'1','313',1,'Retail Sale Id 1652',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 08:37:14'),(1611,'1','313',1,'Retail Sale Id 1653',0.00,605.00,710.00,710.00,105.00,'2023-03-06 08:38:22'),(1612,'1','313',1,'Retail Sale Id 1654',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 08:44:28'),(1613,'1','313',1,'Retail Sale Id 1655',0.00,3025.00,710.00,3550.00,525.00,'2023-03-06 08:45:42'),(1614,'1','313',1,'Retail Sale Id 1656',0.00,36469.40,670.00,40387.60,3918.20,'2023-03-06 08:47:48'),(1615,'1','313',1,'Retail Sale Id 1657',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 08:52:06'),(1616,'1','313',1,'Retail Sale Id 1658',0.00,2117.50,710.00,2485.00,367.50,'2023-03-06 08:53:49'),(1617,'1','313',1,'Retail Sale Id 1659',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-06 08:55:05'),(1618,'1','313',1,'Retail Sale Id 1660',0.00,3025.00,710.00,3550.00,525.00,'2023-03-06 08:56:29'),(1619,'1','313',1,'Retail Sale Id 1661',0.00,2559.15,710.00,3003.30,444.15,'2023-03-06 08:58:27'),(1620,'1','313',1,'Retail Sale Id 1662',0.00,641.30,710.00,752.60,111.30,'2023-03-06 08:59:57'),(1621,'1','313',1,'Retail Sale Id 1663',0.00,605.00,710.00,710.00,105.00,'2023-03-06 09:01:00'),(1622,'1','313',1,'Return of Retail Sale Id 1649',4840.00,0.00,710.00,-5680.00,-840.00,'2023-03-06 09:02:38'),(1623,'1','313',1,'Retail Sale Id 1664',0.00,4477.00,710.00,5254.00,777.00,'2023-03-06 09:03:19'),(1624,'1','313',1,'Retail Sale Id 1665',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-06 09:09:50'),(1625,'1','313',1,'Retail Sale Id 1666',0.00,4840.00,710.00,5680.00,840.00,'2023-03-06 09:11:13'),(1626,'1','313',1,'Retail Sale Id 1668',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 09:12:58'),(1627,'1','313',1,'Retail Sale Id 1669',0.00,72600.00,670.00,80400.00,7800.00,'2023-03-06 09:14:19'),(1628,'1','313',1,'Retail Sale Id 1670',0.00,641.30,710.00,752.60,111.30,'2023-03-06 09:15:18'),(1629,'1','313',1,'Retail Sale Id 1671',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 09:16:27'),(1630,'1','313',1,'Retail Sale Id 1672',0.00,605.00,710.00,710.00,105.00,'2023-03-06 09:17:29'),(1631,'1','313',1,'Retail Sale Id 1673',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 09:18:48'),(1632,'1','313',1,'Retail Sale Id 1674',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 09:20:57'),(1633,'1','313',1,'Retail Sale Id 1675',0.00,3630.00,710.00,4260.00,630.00,'2023-03-06 09:27:12'),(1634,'1','313',1,'Retail Sale Id 1676',0.00,3025.00,710.00,3550.00,525.00,'2023-03-06 09:28:28'),(1635,'1','313',1,'Retail Sale Id 1677',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-06 09:30:06'),(1636,'1','313',1,'Retail Sale Id 1678',0.00,4235.00,710.00,4970.00,735.00,'2023-03-06 09:31:39'),(1637,'1','313',1,'Retail Sale Id 1679',0.00,3630.00,710.00,4260.00,630.00,'2023-03-06 09:32:52'),(1638,'1','313',1,'Retail Sale Id 1680',0.00,641.30,710.00,752.60,111.30,'2023-03-06 09:34:20'),(1639,'1','313',1,'Retail Sale Id 1681',0.00,3630.00,710.00,4260.00,630.00,'2023-03-06 09:35:36'),(1640,'1','313',1,'Retail Sale Id 1682',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 09:36:52'),(1641,'1','313',1,'Retail Sale Id 1683',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-06 09:38:27'),(1642,'1','313',1,'Retail Sale Id 1684',0.00,3630.00,710.00,4260.00,630.00,'2023-03-06 09:39:46'),(1643,'1','313',1,'Retail Sale Id 1685',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 09:42:14'),(1644,'1','313',1,'Retail Sale Id 1686',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 09:43:20'),(1645,'1','313',1,'Retail Sale Id 1687',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 09:44:43'),(1646,'1','313',1,'Retail Sale Id 1688',0.00,4840.00,710.00,5680.00,840.00,'2023-03-06 09:47:46'),(1647,'1','313',1,'Retail Sale Id 1689',0.00,4235.00,710.00,4970.00,735.00,'2023-03-06 09:50:47'),(1648,'1','313',1,'Retail Sale Id 1690',0.00,605.00,710.00,710.00,105.00,'2023-03-06 09:52:40'),(1649,'1','313',1,'Retail Sale Id 1691',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 09:55:34'),(1650,'1','313',1,'Retail Sale Id 1693',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 10:02:03'),(1651,'1','313',1,'Retail Sale Id 1694',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 10:03:10'),(1652,'1','313',1,'Retail Sale Id 1695',0.00,2420.00,710.00,2840.00,420.00,'2023-03-06 10:04:59'),(1653,'1','313',1,'Retail Sale Id 1696',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 10:07:59'),(1654,'1','313',1,'Retail Sale Id 1697',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 10:18:01'),(1655,'1','313',1,'Retail Sale Id 1698',0.00,3406.15,710.00,3997.30,591.15,'2023-03-06 10:20:19'),(1656,'1','313',1,'Retail Sale Id 1699',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 10:21:46'),(1657,'1','313',1,'Retail Sale Id 1700',0.00,2420.00,710.00,2840.00,420.00,'2023-03-06 10:23:05'),(1658,'1','313',1,'Retail Sale Id 1701',0.00,35955.15,670.00,39818.10,3862.95,'2023-03-06 10:26:21'),(1659,'1','313',1,'Retail Sale Id 1702',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 10:30:05'),(1660,'1','313',1,'Retail Sale Id 1703',0.00,4840.00,710.00,5680.00,840.00,'2023-03-06 10:32:00'),(1661,'1','313',1,'Retail Sale Id 1704',0.00,36935.25,670.00,40903.50,3968.25,'2023-03-06 10:34:31'),(1662,'1','313',1,'Retail Sale Id 1705',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 10:38:08'),(1663,'1','313',1,'Retail Sale Id 1706',0.00,1234.20,710.00,1448.40,214.20,'2023-03-06 10:39:23'),(1664,'1','313',1,'Retail Sale Id 1707',0.00,605.00,710.00,710.00,105.00,'2023-03-06 10:40:48'),(1665,'1','313',1,'Retail Sale Id 1708',0.00,641.30,710.00,752.60,111.30,'2023-03-06 10:41:39'),(1666,'1','313',1,'Retail Sale Id 1709',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 10:54:26'),(1667,'1','313',1,'Retail Sale Id 1710',0.00,3025.00,710.00,3550.00,525.00,'2023-03-06 11:02:13'),(1668,'1','313',1,'Retail Sale Id 1711',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 11:05:29'),(1669,'1','313',1,'Retail Sale Id 1712',0.00,3630.00,710.00,4260.00,630.00,'2023-03-06 11:08:14'),(1670,'1','313',1,'Retail Sale Id 1713',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 11:11:37'),(1671,'1','313',1,'Retail Sale Id 1714',0.00,4840.00,710.00,5680.00,840.00,'2023-03-06 11:13:44'),(1672,'1','313',1,'Retail Sale Id 1715',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-06 11:15:13'),(1673,'1','313',1,'Retail Sale Id 1716',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 11:16:16'),(1674,'1','313',1,'Retail Sale Id 1717',0.00,3025.00,710.00,3550.00,525.00,'2023-03-06 11:18:32'),(1675,'1','313',1,'Retail Sale Id 1718',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-06 11:20:45'),(1676,'1','313',1,'Retail Sale Id 1719',0.00,4235.00,710.00,4970.00,735.00,'2023-03-06 11:22:20'),(1677,'1','313',1,'Retail Sale Id 1720',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 11:23:58'),(1678,'1','313',1,'Retail Sale Id 1721',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 11:25:04'),(1679,'1','313',1,'Retail Sale Id 1722',0.00,1833.15,710.00,2151.30,318.15,'2023-03-06 11:28:38'),(1680,'1','313',1,'Retail Sale Id 1723',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 11:37:34'),(1681,'1','313',1,'Retail Sale Id 1724',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 11:39:52'),(1682,'1','313',1,'Retail Sale Id 1725',0.00,605.00,710.00,710.00,105.00,'2023-03-06 11:40:54'),(1683,'1','313',1,'Retail Sale Id 1726',0.00,3630.00,670.00,4020.00,390.00,'2023-03-06 11:42:12'),(1684,'1','313',1,'Retail Sale Id 1727',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 11:43:13'),(1685,'1','313',1,'Retail Sale Id 1728',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 11:49:40'),(1686,'1','313',1,'Retail Sale Id 1729',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-06 11:55:20'),(1687,'1','313',1,'Retail Sale Id 1730',0.00,21780.00,670.00,24120.00,2340.00,'2023-03-06 11:56:57'),(1688,'1','313',1,'Return of Retail Sale Id 1730',21780.00,0.00,670.00,-24120.00,-2340.00,'2023-03-06 11:57:59'),(1689,'1','313',1,'Retail Sale Id 1731',0.00,21671.10,670.00,23999.40,2328.30,'2023-03-06 12:00:08'),(1690,'1','313',1,'Retail Sale Id 1732',0.00,2420.00,710.00,2840.00,420.00,'2023-03-06 12:04:17'),(1691,'1','313',1,'Retail Sale Id 1733',0.00,641.30,710.00,752.60,111.30,'2023-03-06 12:08:32'),(1692,'1','313',1,'Retail Sale Id 1734',0.00,3025.00,710.00,3550.00,525.00,'2023-03-06 12:09:57'),(1693,'1','313',1,'Retail Sale Id 1736',0.00,4235.00,710.00,4970.00,735.00,'2023-03-06 12:15:13'),(1694,'1','313',1,'Retail Sale Id 1737',0.00,4840.00,710.00,5680.00,840.00,'2023-03-06 12:16:39'),(1695,'1','313',1,'Retail Sale Id 1738',0.00,3176.25,710.00,3727.50,551.25,'2023-03-06 12:22:55'),(1696,'1','313',1,'Retail Sale Id 1739',0.00,853.05,710.00,1001.10,148.05,'2023-03-06 12:25:21'),(1697,'1','313',1,'Retail Sale Id 1740',0.00,37334.55,670.00,41345.70,4011.15,'2023-03-06 12:27:15'),(1698,'1','313',1,'Retail Sale Id 1741',0.00,73235.25,670.00,81103.50,7868.25,'2023-03-06 12:28:09'),(1699,'1','313',1,'Retail Sale Id 1743',0.00,5965.30,710.00,7000.60,1035.30,'2023-03-06 12:39:00'),(1700,'1','313',1,'Retail Sale Id 1744',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-06 12:41:21'),(1701,'1','313',1,'Retail Sale Id 1745',0.00,1706.10,710.00,2002.20,296.10,'2023-03-06 12:42:46'),(1702,'1','313',1,'Retail Sale Id 1746',0.00,2117.50,710.00,2485.00,367.50,'2023-03-06 12:44:24'),(1703,'1','313',1,'Retail Sale Id 1747',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 12:46:15'),(1704,'1','313',1,'Retail Sale Id 1748',0.00,10890.00,710.00,12780.00,1890.00,'2023-03-06 12:48:59'),(1705,'1','313',1,'Retail Sale Id 1749',0.00,1833.15,710.00,2151.30,318.15,'2023-03-06 12:55:03'),(1706,'1','313',1,'Retail Sale Id 1750',0.00,1276.55,710.00,1498.10,221.55,'2023-03-06 12:58:53'),(1707,'1','313',1,'Retail Sale Id 1751',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 13:08:47'),(1708,'1','313',1,'Retail Sale Id 1752',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 13:17:30'),(1709,'1','313',1,'Retail Sale Id 1753',0.00,3630.00,710.00,4260.00,630.00,'2023-03-06 13:20:20'),(1710,'1','313',1,'Retail Sale Id 1755',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 13:22:32'),(1711,'1','313',1,'Retail Sale Id 1756',0.00,3630.00,710.00,4260.00,630.00,'2023-03-06 13:23:46'),(1712,'1','313',1,'Retail Sale Id 1757',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 13:25:02'),(1713,'1','313',1,'Retail Sale Id 1758',0.00,605.00,710.00,710.00,105.00,'2023-03-06 13:27:07'),(1714,'1','313',1,'Retail Sale Id 1759',0.00,605.00,710.00,710.00,105.00,'2023-03-06 13:27:49'),(1715,'1','313',1,'Retail Sale Id 1760',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-06 13:28:59'),(1716,'1','313',1,'Retail Sale Id 1761',0.00,3630.00,710.00,4260.00,630.00,'2023-03-06 13:30:24'),(1717,'1','313',1,'Retail Sale Id 1762',0.00,605.00,710.00,710.00,105.00,'2023-03-06 13:31:57'),(1718,'1','313',1,'Retail Sale Id 1764',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 13:40:38'),(1719,'1','313',1,'Retail Sale Id 1765',0.00,2117.50,710.00,2485.00,367.50,'2023-03-06 13:53:05'),(1720,'1','313',1,'Retail Sale Id 1766',0.00,3025.00,710.00,3550.00,525.00,'2023-03-06 13:56:34'),(1721,'1','313',1,'Retail Sale Id 1767',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 14:00:34'),(1722,'1','313',1,'Retail Sale Id 1768',0.00,3630.00,710.00,4260.00,630.00,'2023-03-06 14:03:57'),(1723,'1','313',1,'Retail Sale Id 1769',0.00,4840.00,710.00,5680.00,840.00,'2023-03-06 14:09:18'),(1724,'1','313',1,'Retail Sale Id 1771',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 14:26:17'),(1725,'1','313',1,'Retail Sale Id 1772',0.00,27563.80,670.00,30525.20,2961.40,'2023-03-06 14:39:34'),(1726,'1','313',1,'Retail Sale Id 1773',0.00,3025.00,710.00,3550.00,525.00,'2023-03-06 14:40:57'),(1727,'1','313',1,'Retail Sale Id 1774',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 14:42:14'),(1728,'1','313',1,'Retail Sale Id 1775',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-06 14:44:01'),(1729,'1','313',1,'Retail Sale Id 1776',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 14:45:17'),(1730,'1','313',1,'Retail Sale Id 1777',0.00,1276.55,710.00,1498.10,221.55,'2023-03-06 14:48:15'),(1731,'1','313',1,'Retail Sale Id 1778',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 14:50:23'),(1732,'1','313',1,'Retail Sale Id 1780',0.00,15125.00,710.00,17750.00,2625.00,'2023-03-06 14:51:57'),(1733,'1','313',1,'Retail Sale Id 1781',0.00,1815.00,670.00,2010.00,195.00,'2023-03-06 14:53:26'),(1734,'1','313',1,'Retail Sale Id 1782',0.00,4235.00,710.00,4970.00,735.00,'2023-03-06 14:54:45'),(1735,'1','313',1,'Retail Sale Id 1783',0.00,641.30,710.00,752.60,111.30,'2023-03-06 14:56:03'),(1736,'1','313',1,'Retail Sale Id 1784',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 14:58:22'),(1737,'1','313',1,'Retail Sale Id 1785',0.00,3025.00,710.00,3550.00,525.00,'2023-03-06 15:00:23'),(1738,'1','313',1,'Retail Sale Id 1786',0.00,4235.00,710.00,4970.00,735.00,'2023-03-06 15:06:16'),(1739,'1','313',1,'Retail Sale Id 1787',0.00,605.00,710.00,710.00,105.00,'2023-03-06 15:08:05'),(1740,'1','313',1,'Retail Sale Id 1788',0.00,605.00,710.00,710.00,105.00,'2023-03-06 15:08:52'),(1741,'1','313',1,'Retail Sale Id 1789',0.00,605.00,710.00,710.00,105.00,'2023-03-06 15:10:37'),(1742,'1','313',1,'Retail Sale Id 1790',0.00,29645.00,670.00,32830.00,3185.00,'2023-03-06 15:13:09'),(1743,'1','313',1,'Retail Sale Id 1791',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-06 15:14:50'),(1744,'1','313',1,'Retail Sale Id 1792',0.00,3630.00,710.00,4260.00,630.00,'2023-03-06 15:16:44'),(1745,'1','313',1,'Retail Sale Id 1793',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 15:17:42'),(1746,'1','313',1,'Retail Sale Id 1794',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 15:19:15'),(1747,'1','313',1,'Retail Sale Id 1795',0.00,9680.00,710.00,11360.00,1680.00,'2023-03-06 15:20:15'),(1748,'1','313',1,'Retail Sale Id 1796',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 15:20:53'),(1749,'1','313',1,'Retail Sale Id 1797',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 15:21:43'),(1750,'1','313',1,'Retail Sale Id 1799',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-06 15:23:26'),(1751,'1','313',1,'Retail Sale Id 1800',0.00,605.00,710.00,710.00,105.00,'2023-03-06 15:24:04'),(1752,'1','313',1,'Retail Sale Id 1801',0.00,4235.00,710.00,4970.00,735.00,'2023-03-06 15:26:23'),(1753,'1','313',1,'Retail Sale Id 1802',0.00,605.00,710.00,710.00,105.00,'2023-03-06 15:28:36'),(1754,'1','313',1,'Retail Sale Id 1803',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-06 15:29:54'),(1755,'1','313',1,'Retail Sale Id 1804',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 15:31:26'),(1756,'1','313',1,'Retail Sale Id 1805',0.00,4235.00,710.00,4970.00,735.00,'2023-03-06 15:33:13'),(1757,'1','313',1,'Retail Sale Id 1806',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 15:35:42'),(1758,'1','313',1,'Retail Sale Id 1807',0.00,2420.00,710.00,2840.00,420.00,'2023-03-06 15:37:49'),(1759,'1','313',1,'Retail Sale Id 1808',0.00,2420.00,710.00,2840.00,420.00,'2023-03-06 15:39:04'),(1760,'1','313',1,'Retail Sale Id 1809',0.00,3025.00,710.00,3550.00,525.00,'2023-03-06 15:40:02'),(1761,'1','313',1,'Retail Sale Id 1810',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 15:40:44'),(1762,'1','313',1,'Retail Sale Id 1812',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 15:41:57'),(1763,'1','313',1,'Retail Sale Id 1813',0.00,3025.00,710.00,3550.00,525.00,'2023-03-06 15:44:06'),(1764,'1','313',1,'Retail Sale Id 1814',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-06 15:45:18'),(1765,'1','313',1,'Retail Sale Id 1815',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 15:47:32'),(1766,'1','313',1,'Retail Sale Id 1816',0.00,2420.00,710.00,2840.00,420.00,'2023-03-06 15:49:08'),(1767,'1','313',1,'Retail Sale Id 1817',0.00,2420.00,710.00,2840.00,420.00,'2023-03-06 15:50:50'),(1768,'1','313',1,'Retail Sale Id 1818',0.00,605.00,710.00,710.00,105.00,'2023-03-06 15:51:52'),(1769,'1','313',1,'Retail Sale Id 1819',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-06 15:53:10'),(1770,'1','313',1,'Retail Sale Id 1820',0.00,3025.00,710.00,3550.00,525.00,'2023-03-06 15:53:52'),(1771,'1','313',1,'Retail Sale Id 1822',0.00,641.30,710.00,752.60,111.30,'2023-03-06 15:55:40'),(1772,'1','313',1,'Retail Sale Id 1824',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-06 15:57:17'),(1773,'1','313',1,'Retail Sale Id 1825',0.00,641.30,710.00,752.60,111.30,'2023-03-06 15:59:46'),(1774,'1','313',1,'Retail Sale Id 1826',0.00,641.30,710.00,752.60,111.30,'2023-03-06 16:01:19'),(1775,'1','313',1,'Retail Sale Id 1827',0.00,3025.00,710.00,3550.00,525.00,'2023-03-06 16:02:38'),(1776,'1','313',1,'Retail Sale Id 1828',0.00,605.00,710.00,710.00,105.00,'2023-03-06 16:03:33'),(1777,'1','313',1,'Retail Sale Id 1829',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 16:04:42'),(1778,'1','313',1,'Retail Sale Id 1830',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 16:05:23'),(1779,'1','313',1,'Retail Sale Id 1831',0.00,3025.00,710.00,3550.00,525.00,'2023-03-06 16:06:03'),(1780,'1','313',1,'Retail Sale Id 1832',0.00,3025.00,710.00,3550.00,525.00,'2023-03-06 16:06:46'),(1781,'1','313',1,'Retail Sale Id 1833',0.00,2420.00,710.00,2840.00,420.00,'2023-03-06 16:12:39'),(1782,'1','313',1,'Retail Sale Id 1834',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 16:16:22'),(1783,'1','313',1,'Retail Sale Id 1836',0.00,1276.55,710.00,1498.10,221.55,'2023-03-06 16:20:18'),(1784,'1','313',1,'Retail Sale Id 1837',0.00,641.30,710.00,752.60,111.30,'2023-03-06 16:21:57'),(1785,'1','313',1,'Return of Retail Sale Id 1837',641.30,0.00,710.00,-752.60,-111.30,'2023-03-06 16:22:15'),(1786,'1','313',1,'Retail Sale Id 1838',0.00,641.30,710.00,752.60,111.30,'2023-03-06 16:22:51'),(1787,'1','313',1,'Retail Sale Id 1839',0.00,1276.55,710.00,1498.10,221.55,'2023-03-06 16:23:54'),(1788,'1','313',1,'Retail Sale Id 1840',0.00,3630.00,710.00,4260.00,630.00,'2023-03-06 16:24:57'),(1789,'1','313',1,'Retail Sale Id 1841',0.00,683.65,710.00,802.30,118.65,'2023-03-06 16:25:57'),(1790,'1','313',1,'Retail Sale Id 1842',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-06 16:28:40'),(1791,'1','313',1,'Retail Sale Id 1843',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-06 16:30:24'),(1792,'1','313',1,'Retail Sale Id 1844',0.00,2420.00,710.00,2840.00,420.00,'2023-03-06 16:31:35'),(1793,'1','313',1,'Retail Sale Id 1845',0.00,853.05,710.00,1001.10,148.05,'2023-03-06 16:32:39'),(1794,'1','313',1,'Return of Retail Sale Id 1845',853.05,0.00,710.00,-1001.10,-148.05,'2023-03-06 16:33:05'),(1795,'1','313',1,'Retail Sale Id 1846',0.00,853.05,710.00,1001.10,148.05,'2023-03-06 16:33:41'),(1796,'1','313',1,'Retail Sale Id 1847',0.00,605.00,710.00,710.00,105.00,'2023-03-06 16:35:02'),(1797,'1','313',1,'Retail Sale Id 1848',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 16:36:14'),(1798,'1','313',1,'Retail Sale Id 1849',0.00,1210.00,710.00,1420.00,210.00,'2023-03-06 16:37:30'),(1799,'1','313',1,'Retail Sale Id 1851',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 16:40:44'),(1800,'1','313',1,'Retail Sale Id 1852',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-06 16:41:55'),(1801,'1','313',1,'Retail Sale Id 1853',0.00,641.30,710.00,752.60,111.30,'2023-03-06 16:43:40'),(1802,'1','313',1,'Retail Sale Id 1854',0.00,9075.00,710.00,10650.00,1575.00,'2023-03-06 16:45:07'),(1803,'1','313',1,'Retail Sale Id 1855',0.00,72600.00,670.00,80400.00,7800.00,'2023-03-06 16:46:57'),(1804,'1','313',1,'Retail Sale Id 1856',0.00,5445.00,710.00,6390.00,945.00,'2023-03-06 16:48:39'),(1805,'1','313',1,'Retail Sale Id 1857',0.00,9075.00,710.00,10650.00,1575.00,'2023-03-06 16:50:44'),(1806,'1','313',1,'Retail Sale Id 1858',0.00,3630.00,710.00,4260.00,630.00,'2023-03-06 16:53:17'),(1807,'1','313',1,'Retail Sale Id 1859',0.00,2420.00,710.00,2840.00,420.00,'2023-03-06 16:55:45'),(1808,'1','313',1,'Retail Sale Id 1860',0.00,641.30,710.00,752.60,111.30,'2023-03-06 16:58:02'),(1809,'1','313',1,'Retail Sale Id 1861',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 16:59:18'),(1810,'1','313',1,'Retail Sale Id 1862',0.00,641.30,710.00,752.60,111.30,'2023-03-06 17:00:45'),(1811,'1','313',1,'Retail Sale Id 1863',0.00,611.05,710.00,717.10,106.05,'2023-03-06 17:02:03'),(1812,'1','313',1,'Retail Sale Id 1864',0.00,1815.00,710.00,2130.00,315.00,'2023-03-06 17:03:13'),(1813,'1','313',1,'Retail Sale Id 1865',0.00,605.00,710.00,710.00,105.00,'2023-03-06 17:07:50'),(1814,'1','313',1,'Retail Sale Id 1866',0.00,3025.00,710.00,3550.00,525.00,'2023-03-06 17:09:02'),(1815,'1','313',1,'Retail Sale Id 1867',0.00,3630.00,710.00,4260.00,630.00,'2023-03-06 17:10:47'),(1816,'1','313',1,'Retail Sale Id 1868',0.00,605.00,710.00,710.00,105.00,'2023-03-06 17:12:02'),(1817,'1','313',1,'Retail Sale Id 1869',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-06 17:13:25'),(1818,'1','313',1,'Retail Sale Id 1870',0.00,2420.00,710.00,2840.00,420.00,'2023-03-06 17:14:45'),(1819,'1','313',1,'Retail Sale Id 1871',0.00,2420.00,710.00,2840.00,420.00,'2023-03-06 17:15:35'),(1820,'1','313',1,'Retail Sale Id 1872',0.00,3025.00,710.00,3550.00,525.00,'2023-03-06 17:16:36'),(1821,'1','313',1,'Retail Sale Id 1874',0.00,1234.20,710.00,1448.40,214.20,'2023-03-06 17:19:24'),(1822,'1','313',1,'Return of Retail Sale Id 1864',1815.00,0.00,710.00,-2130.00,-315.00,'2023-03-06 17:24:41'),(1823,'1','313',1,'Retail Sale Id 1875',0.00,1621.40,710.00,1902.80,281.40,'2023-03-06 18:01:36'),(1824,'1','313',1,'Return of Retail Sale Id 1790',29645.00,0.00,670.00,-32830.00,-3185.00,'2023-03-06 18:05:56'),(1825,'1','313',1,'Retail Sale Id 1877',0.00,29802.30,670.00,33004.20,3201.90,'2023-03-06 18:06:48'),(1826,'1','313',1,'Return of Retail Sale Id 1726',3630.00,0.00,670.00,-4020.00,-390.00,'2023-03-06 18:14:34'),(1827,'1','313',1,'Retail Sale Id 1878',0.00,3315.40,670.00,3671.60,356.20,'2023-03-06 18:15:35'),(1828,'1','313',1,'Retail Sale Id 1879',0.00,10890.00,710.00,12780.00,1890.00,'2023-03-07 08:54:22'),(1829,'1','313',1,'Retail Sale Id 1880',0.00,3630.00,710.00,4260.00,630.00,'2023-03-07 08:56:54'),(1830,'1','313',1,'Retail Sale Id 1881',0.00,7865.00,710.00,9230.00,1365.00,'2023-03-07 08:57:51'),(1831,'1','313',1,'Retail Sale Id 1882',0.00,121000.00,670.00,134000.00,13000.00,'2023-03-07 09:00:03'),(1832,'1','313',1,'Retail Sale Id 1883',0.00,1815.00,710.00,2130.00,315.00,'2023-03-07 09:00:43'),(1833,'1','313',1,'Retail Sale Id 1884',0.00,1815.00,710.00,2130.00,315.00,'2023-03-07 09:02:01'),(1834,'1','313',1,'Retail Sale Id 1885',0.00,4235.00,710.00,4970.00,735.00,'2023-03-07 09:03:11'),(1835,'1','313',1,'Retail Sale Id 1886',0.00,3025.00,710.00,3550.00,525.00,'2023-03-07 09:05:33'),(1836,'1','313',1,'Retail Sale Id 1887',0.00,605.00,710.00,710.00,105.00,'2023-03-07 09:06:36'),(1837,'1','313',1,'Retail Sale Id 1888',0.00,1234.20,710.00,1448.40,214.20,'2023-03-07 09:08:35'),(1838,'1','313',1,'Retail Sale Id 1889',0.00,1815.00,710.00,2130.00,315.00,'2023-03-07 09:11:25'),(1839,'1','313',1,'Retail Sale Id 1890',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-07 09:12:20'),(1840,'1','313',1,'Retail Sale Id 1891',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-07 09:13:14'),(1841,'1','313',1,'Retail Sale Id 1892',0.00,1875.50,710.00,2201.00,325.50,'2023-03-07 09:14:22'),(1842,'1','313',1,'Retail Sale Id 1893',0.00,1706.10,710.00,2002.20,296.10,'2023-03-07 09:15:43'),(1843,'1','313',1,'Retail Sale Id 1894',0.00,2420.00,710.00,2840.00,420.00,'2023-03-07 09:16:32'),(1844,'1','313',1,'Retail Sale Id 1895',0.00,2420.00,710.00,2840.00,420.00,'2023-03-07 09:17:42'),(1845,'1','313',1,'Retail Sale Id 1896',0.00,641.30,710.00,752.60,111.30,'2023-03-07 09:18:57'),(1846,'1','313',1,'Retail Sale Id 1897',0.00,4235.00,710.00,4970.00,735.00,'2023-03-07 09:19:34'),(1847,'1','313',1,'Retail Sale Id 1898',0.00,1833.15,710.00,2151.30,318.15,'2023-03-07 09:20:48'),(1848,'1','313',1,'Retail Sale Id 1899',0.00,1706.10,710.00,2002.20,296.10,'2023-03-07 09:21:43'),(1849,'1','313',1,'Retail Sale Id 1900',0.00,20763.60,670.00,22994.40,2230.80,'2023-03-07 09:22:45'),(1850,'1','313',1,'Retail Sale Id 1901',0.00,641.30,710.00,752.60,111.30,'2023-03-07 09:24:04'),(1851,'1','313',1,'Retail Sale Id 1902',0.00,1210.00,710.00,1420.00,210.00,'2023-03-07 09:25:29'),(1852,'1','313',1,'Retail Sale Id 1903',0.00,605.00,710.00,710.00,105.00,'2023-03-07 09:27:21'),(1853,'1','313',1,'Retail Sale Id 1904',0.00,14520.00,710.00,17040.00,2520.00,'2023-03-07 09:28:25'),(1854,'1','313',1,'Retail Sale Id 1905',0.00,74415.00,670.00,82410.00,7995.00,'2023-03-07 09:30:40'),(1855,'1','313',1,'Retail Sale Id 1906',0.00,2214.30,710.00,2598.60,384.30,'2023-03-07 09:32:08'),(1856,'1','313',1,'Retail Sale Id 1907',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-07 09:33:48'),(1857,'1','313',1,'Retail Sale Id 1908',0.00,3025.00,710.00,3550.00,525.00,'2023-03-07 09:34:35'),(1858,'1','313',1,'Retail Sale Id 1909',0.00,605.00,710.00,710.00,105.00,'2023-03-07 09:35:31'),(1859,'1','313',1,'Retail Sale Id 1910',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-07 09:36:36'),(1860,'1','313',1,'Retail Sale Id 1911',0.00,1210.00,710.00,1420.00,210.00,'2023-03-07 09:37:18'),(1861,'1','313',1,'Retail Sale Id 1913',0.00,1276.55,710.00,1498.10,221.55,'2023-03-07 09:38:53'),(1862,'1','313',1,'Retail Sale Id 1914',0.00,1875.50,710.00,2201.00,325.50,'2023-03-07 09:39:41'),(1863,'1','313',1,'Retail Sale Id 1915',0.00,641.30,710.00,752.60,111.30,'2023-03-07 09:40:29'),(1864,'1','313',1,'Retail Sale Id 1917',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-07 09:41:25'),(1865,'1','313',1,'Retail Sale Id 1918',0.00,3630.00,710.00,4260.00,630.00,'2023-03-07 09:42:17'),(1866,'1','313',1,'Retail Sale Id 1919',0.00,605.00,710.00,710.00,105.00,'2023-03-07 09:43:13'),(1867,'1','313',1,'Retail Sale Id 1920',0.00,1815.00,710.00,2130.00,315.00,'2023-03-07 09:43:42'),(1868,'1','313',1,'Retail Sale Id 1921',0.00,3025.00,710.00,3550.00,525.00,'2023-03-07 09:44:28'),(1869,'1','313',1,'Retail Sale Id 1922',0.00,641.30,710.00,752.60,111.30,'2023-03-07 09:45:01'),(1870,'1','313',1,'Retail Sale Id 1923',0.00,3025.00,710.00,3550.00,525.00,'2023-03-07 09:45:38'),(1871,'1','313',1,'Retail Sale Id 1924',0.00,605.00,710.00,710.00,105.00,'2023-03-07 09:46:22'),(1872,'1','313',1,'Retail Sale Id 1925',0.00,22990.00,670.00,25460.00,2470.00,'2023-03-07 09:48:02'),(1873,'1','313',1,'Retail Sale Id 1926',0.00,5445.00,710.00,6390.00,945.00,'2023-03-07 09:48:51'),(1874,'1','313',1,'Retail Sale Id 1927',0.00,3630.00,710.00,4260.00,630.00,'2023-03-07 09:50:12'),(1875,'1','313',1,'Retail Sale Id 1928',0.00,1210.00,710.00,1420.00,210.00,'2023-03-07 09:51:09'),(1876,'1','313',1,'Retail Sale Id 1929',0.00,3025.00,710.00,3550.00,525.00,'2023-03-07 09:51:52'),(1877,'1','313',1,'Retail Sale Id 1930',0.00,8470.00,710.00,9940.00,1470.00,'2023-03-07 09:53:14'),(1878,'1','313',1,'Retail Sale Id 1931',0.00,3025.00,710.00,3550.00,525.00,'2023-03-07 09:54:01'),(1879,'1','313',1,'Retail Sale Id 1932',0.00,3025.00,710.00,3550.00,525.00,'2023-03-07 09:54:39'),(1880,'1','313',1,'Retail Sale Id 1933',0.00,1210.00,710.00,1420.00,210.00,'2023-03-07 09:55:41'),(1881,'1','313',1,'Retail Sale Id 1934',0.00,2420.00,710.00,2840.00,420.00,'2023-03-07 09:56:22'),(1882,'1','313',1,'Retail Sale Id 1935',0.00,3025.00,710.00,3550.00,525.00,'2023-03-07 09:57:14'),(1883,'1','313',1,'Retail Sale Id 1936',0.00,3025.00,710.00,3550.00,525.00,'2023-03-07 09:58:06'),(1884,'1','313',1,'Retail Sale Id 1937',0.00,1210.00,710.00,1420.00,210.00,'2023-03-07 09:59:38'),(1885,'1','313',1,'Retail Sale Id 1938',0.00,1210.00,710.00,1420.00,210.00,'2023-03-07 10:05:16'),(1886,'1','313',1,'Retail Sale Id 1939',0.00,1815.00,710.00,2130.00,315.00,'2023-03-07 10:06:37'),(1887,'1','313',1,'Retail Sale Id 1940',0.00,1815.00,710.00,2130.00,315.00,'2023-03-07 10:07:34'),(1888,'1','313',1,'Retail Sale Id 1941',0.00,72600.00,670.00,80400.00,7800.00,'2023-03-07 10:08:56'),(1889,'1','313',1,'Return of Retail Sale Id 1879',10890.00,0.00,710.00,-12780.00,-1890.00,'2023-03-07 10:10:26'),(1890,'1','313',1,'Retail Sale Id 1942',0.00,3025.00,710.00,3550.00,525.00,'2023-03-07 10:10:54'),(1891,'1','313',1,'Retail Sale Id 1943',0.00,18150.00,670.00,20100.00,1950.00,'2023-03-07 10:12:39'),(1892,'1','313',1,'Retail Sale Id 1944',0.00,605.00,710.00,710.00,105.00,'2023-03-07 10:14:08'),(1893,'1','313',1,'Retail Sale Id 1945',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-07 10:15:14'),(1894,'1','313',1,'Retail Sale Id 1946',0.00,3025.00,710.00,3550.00,525.00,'2023-03-07 10:15:54'),(1895,'1','313',1,'Retail Sale Id 1947',0.00,2420.00,710.00,2840.00,420.00,'2023-03-07 10:16:57'),(1896,'1','313',1,'Retail Sale Id 1948',0.00,3630.00,710.00,4260.00,630.00,'2023-03-07 10:18:04'),(1897,'1','313',1,'Retail Sale Id 1949',0.00,3025.00,710.00,3550.00,525.00,'2023-03-07 10:18:52'),(1898,'1','313',1,'Retail Sale Id 1950',0.00,605.00,710.00,710.00,105.00,'2023-03-07 10:20:22'),(1899,'1','313',1,'Retail Sale Id 1951',0.00,2420.00,710.00,2840.00,420.00,'2023-03-07 10:22:25'),(1900,'1','313',1,'Retail Sale Id 1952',0.00,2420.00,710.00,2840.00,420.00,'2023-03-07 10:23:38'),(1901,'1','313',1,'Retail Sale Id 1954',0.00,1210.00,710.00,1420.00,210.00,'2023-03-07 10:25:45'),(1902,'1','313',1,'Retail Sale Id 1955',0.00,907.50,710.00,1065.00,157.50,'2023-03-07 10:28:07'),(1903,'1','313',1,'Retail Sale Id 1956',0.00,2420.00,710.00,2840.00,420.00,'2023-03-07 10:29:00'),(1904,'1','313',1,'Retail Sale Id 1957',0.00,605.00,710.00,710.00,105.00,'2023-03-07 10:30:18'),(1905,'1','313',1,'Retail Sale Id 1958',0.00,1815.00,710.00,2130.00,315.00,'2023-03-07 10:31:07'),(1906,'1','313',1,'Retail Sale Id 1959',0.00,1210.00,710.00,1420.00,210.00,'2023-03-07 10:32:20'),(1907,'1','313',1,'Retail Sale Id 1960',0.00,1815.00,710.00,2130.00,315.00,'2023-03-07 10:34:49'),(1908,'1','313',1,'Retail Sale Id 1961',0.00,1833.15,710.00,2151.30,318.15,'2023-03-07 10:38:46'),(1909,'1','313',1,'Retail Sale Id 1962',0.00,26734.95,670.00,29607.30,2872.35,'2023-03-07 10:40:54'),(1910,'1','313',1,'Retail Sale Id 1963',0.00,2426.05,710.00,2847.10,421.05,'2023-03-07 10:42:20'),(1911,'1','313',1,'Retail Sale Id 1964',0.00,605.00,710.00,710.00,105.00,'2023-03-07 10:44:55'),(1912,'1','313',1,'Retail Sale Id 1965',0.00,2559.15,710.00,3003.30,444.15,'2023-03-07 10:49:29'),(1913,'1','313',1,'Retail Sale Id 1966',0.00,5445.00,710.00,6390.00,945.00,'2023-03-07 10:53:55'),(1914,'1','313',1,'Retail Sale Id 1967',0.00,3630.00,710.00,4260.00,630.00,'2023-03-07 10:57:41'),(1915,'1','313',1,'Retail Sale Id 1968',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-07 10:59:04'),(1916,'1','313',1,'Retail Sale Id 1969',0.00,1210.00,710.00,1420.00,210.00,'2023-03-07 11:02:29'),(1917,'1','313',1,'Retail Sale Id 1970',0.00,3630.00,710.00,4260.00,630.00,'2023-03-07 11:05:03'),(1918,'1','313',1,'Retail Sale Id 1971',0.00,1210.00,710.00,1420.00,210.00,'2023-03-07 11:07:02'),(1919,'1','313',1,'Retail Sale Id 1972',0.00,1815.00,710.00,2130.00,315.00,'2023-03-07 11:08:26'),(1920,'1','313',1,'Retail Sale Id 1973',0.00,4235.00,710.00,4970.00,735.00,'2023-03-07 11:10:26'),(1921,'1','313',1,'Retail Sale Id 1974',0.00,3025.00,710.00,3550.00,525.00,'2023-03-07 11:12:08'),(1922,'1','313',1,'Retail Sale Id 1975',0.00,3630.00,710.00,4260.00,630.00,'2023-03-07 11:13:40'),(1923,'1','313',1,'Retail Sale Id 1976',0.00,1210.00,710.00,1420.00,210.00,'2023-03-07 11:14:15'),(1924,'1','313',1,'Retail Sale Id 1977',0.00,605.00,710.00,710.00,105.00,'2023-03-07 11:15:12'),(1925,'1','313',1,'Retail Sale Id 1978',0.00,1815.00,710.00,2130.00,315.00,'2023-03-07 11:19:10'),(1926,'1','313',1,'Retail Sale Id 1979',0.00,2420.00,710.00,2840.00,420.00,'2023-03-07 11:21:19'),(1927,'1','313',1,'Retail Sale Id 1980',0.00,2420.00,710.00,2840.00,420.00,'2023-03-07 11:22:38'),(1928,'1','313',1,'Retail Sale Id 1981',0.00,1210.00,710.00,1420.00,210.00,'2023-03-07 11:23:30'),(1929,'1','313',1,'Retail Sale Id 1982',0.00,1210.00,710.00,1420.00,210.00,'2023-03-07 11:24:58'),(1930,'1','313',1,'Retail Sale Id 1983',0.00,3630.00,710.00,4260.00,630.00,'2023-03-07 11:26:38'),(1931,'1','313',1,'Retail Sale Id 1984',0.00,1815.00,710.00,2130.00,315.00,'2023-03-07 11:30:40'),(1932,'1','313',1,'Retail Sale Id 1985',0.00,1234.20,710.00,1448.40,214.20,'2023-03-07 11:33:10'),(1933,'1','313',1,'Retail Sale Id 1986',0.00,3025.00,710.00,3550.00,525.00,'2023-03-07 11:34:29'),(1934,'1','313',1,'Retail Sale Id 1987',0.00,108900.00,670.00,120600.00,11700.00,'2023-03-07 11:36:26'),(1935,'1','313',1,'Retail Sale Id 1988',0.00,4235.00,710.00,4970.00,735.00,'2023-03-07 11:38:22'),(1936,'1','313',1,'Retail Sale Id 1989',0.00,3025.00,710.00,3550.00,525.00,'2023-03-07 11:40:21'),(1937,'1','313',1,'Retail Sale Id 1990',0.00,3630.00,710.00,4260.00,630.00,'2023-03-07 11:41:52'),(1938,'1','313',1,'Retail Sale Id 1991',0.00,1210.00,710.00,1420.00,210.00,'2023-03-07 11:43:10'),(1939,'1','313',1,'Retail Sale Id 1992',0.00,1815.00,710.00,2130.00,315.00,'2023-03-07 11:48:13'),(1940,'1','313',1,'Retail Sale Id 1993',0.00,1815.00,710.00,2130.00,315.00,'2023-03-07 11:48:57'),(1941,'1','313',1,'Retail Sale Id 1994',0.00,1815.00,710.00,2130.00,315.00,'2023-03-07 11:50:46'),(1942,'1','313',1,'Retail Sale Id 1995',0.00,1210.00,710.00,1420.00,210.00,'2023-03-07 11:59:56'),(1943,'1','313',1,'Retail Sale Id 1996',0.00,3025.00,710.00,3550.00,525.00,'2023-03-07 12:03:26'),(1944,'1','313',1,'Retail Sale Id 1997',0.00,4235.00,710.00,4970.00,735.00,'2023-03-07 12:14:20'),(1945,'1','313',1,'Retail Sale Id 1998',0.00,12100.00,670.00,13400.00,1300.00,'2023-03-07 12:15:40'),(1946,'1','313',1,'Retail Sale Id 1999',0.00,907.50,710.00,1065.00,157.50,'2023-03-07 12:17:01'),(1947,'1','313',1,'Retail Sale Id 2000',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-07 12:18:15'),(1948,'1','313',1,'Retail Sale Id 2001',0.00,605.00,710.00,710.00,105.00,'2023-03-07 12:20:08'),(1949,'1','313',1,'Retail Sale Id 2002',0.00,2420.00,710.00,2840.00,420.00,'2023-03-07 12:21:17'),(1950,'1','313',1,'Retail Sale Id 2003',0.00,1210.00,710.00,1420.00,210.00,'2023-03-07 12:24:34'),(1951,'1','313',1,'Retail Sale Id 2004',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-07 12:26:03'),(1952,'1','313',1,'Retail Sale Id 2005',0.00,3630.00,710.00,4260.00,630.00,'2023-03-07 12:27:27'),(1953,'1','313',1,'Retail Sale Id 2006',0.00,1210.00,710.00,1420.00,210.00,'2023-03-07 12:28:36'),(1954,'1','313',1,'Retail Sale Id 2008',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-07 12:31:45'),(1955,'1','313',1,'Retail Sale Id 2009',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-07 12:34:28'),(1956,'1','313',1,'Retail Sale Id 2010',0.00,1815.00,710.00,2130.00,315.00,'2023-03-07 12:35:32'),(1957,'1','313',1,'Retail Sale Id 2011',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-07 12:39:19'),(1958,'1','313',1,'Retail Sale Id 2012',0.00,1210.00,710.00,1420.00,210.00,'2023-03-07 12:41:20'),(1959,'1','313',1,'Retail Sale Id 2013',0.00,853.05,710.00,1001.10,148.05,'2023-03-07 12:43:52'),(1960,'1','313',1,'Retail Sale Id 2014',0.00,1815.00,710.00,2130.00,315.00,'2023-03-07 12:56:43'),(1961,'1','313',1,'Retail Sale Id 2015',0.00,3025.00,710.00,3550.00,525.00,'2023-03-07 12:57:50'),(1962,'1','313',1,'Retail Sale Id 2016',0.00,39058.80,670.00,43255.20,4196.40,'2023-03-07 13:06:37'),(1963,'1','313',1,'Return of Retail Sale Id 1900',20763.60,0.00,670.00,-22994.40,-2230.80,'2023-03-07 13:30:48'),(1964,'1','313',1,'Retail Sale Id 2017',0.00,21047.95,670.00,23309.30,2261.35,'2023-03-07 13:32:28'),(1965,'1','313',1,'Return of Retail Sale Id 1993',1815.00,0.00,710.00,-2130.00,-315.00,'2023-03-07 13:35:54'),(1966,'1','313',1,'Retail Sale Id 2018',0.00,1191.85,710.00,1398.70,206.85,'2023-03-07 13:36:41'),(1967,'1','313',1,'Sale Id 1',0.00,688592.85,600.00,682902.00,-5690.85,'2023-03-08 18:24:25'),(1968,'1','313',1,'Retail Sale Id 2019',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-09 08:27:24'),(1969,'1','313',1,'Retail Sale Id 2020',0.00,4840.00,710.00,5680.00,840.00,'2023-03-09 08:28:39'),(1970,'1','313',1,'Retail Sale Id 2021',0.00,4235.00,710.00,4970.00,735.00,'2023-03-09 08:30:03'),(1971,'1','313',1,'Retail Sale Id 2022',0.00,1234.20,710.00,1448.40,214.20,'2023-03-09 08:33:10'),(1972,'1','313',1,'Retail Sale Id 2023',0.00,25282.95,670.00,27999.30,2716.35,'2023-03-09 08:34:31'),(1973,'1','313',1,'Retail Sale Id 2024',0.00,2559.15,710.00,3003.30,444.15,'2023-03-09 08:36:34'),(1974,'1','313',1,'Retail Sale Id 2025',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-09 08:37:54'),(1975,'1','313',1,'Retail Sale Id 2026',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 08:39:06'),(1976,'1','313',1,'Retail Sale Id 2027',0.00,605.00,710.00,710.00,105.00,'2023-03-09 08:40:02'),(1977,'1','313',1,'Retail Sale Id 2028',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 08:41:11'),(1978,'1','313',1,'Retail Sale Id 2029',0.00,853.05,710.00,1001.10,148.05,'2023-03-09 08:42:06'),(1979,'1','313',1,'Retail Sale Id 2030',0.00,641.30,710.00,752.60,111.30,'2023-03-09 08:43:14'),(1980,'1','313',1,'Retail Sale Id 2031',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 08:44:21'),(1981,'1','313',1,'Retail Sale Id 2032',0.00,5578.10,710.00,6546.20,968.10,'2023-03-09 08:45:23'),(1982,'1','313',1,'Retail Sale Id 2033',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 08:47:08'),(1983,'1','313',1,'Retail Sale Id 2034',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 08:47:48'),(1984,'1','313',1,'Return of Retail Sale Id 2025',6050.00,0.00,710.00,-7100.00,-1050.00,'2023-03-09 08:49:08'),(1985,'1','313',1,'Retail Sale Id 2035',0.00,605.00,710.00,710.00,105.00,'2023-03-09 08:49:57'),(1986,'1','313',1,'Retail Sale Id 2036',0.00,3630.00,710.00,4260.00,630.00,'2023-03-09 08:51:11'),(1987,'1','313',1,'Retail Sale Id 2038',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-09 08:54:05'),(1988,'1','313',1,'Retail Sale Id 2039',0.00,853.05,710.00,1001.10,148.05,'2023-03-09 08:54:57'),(1989,'1','313',1,'Retail Sale Id 2040',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 08:56:40'),(1990,'1','313',1,'Retail Sale Id 2041',0.00,34485.00,670.00,38190.00,3705.00,'2023-03-09 08:57:50'),(1991,'1','313',1,'Retail Sale Id 2042',0.00,683.65,710.00,802.30,118.65,'2023-03-09 08:58:44'),(1992,'1','313',1,'Retail Sale Id 2043',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 08:59:22'),(1993,'1','313',1,'Retail Sale Id 2044',0.00,605.00,710.00,710.00,105.00,'2023-03-09 09:00:27'),(1994,'1','313',1,'Retail Sale Id 2045',0.00,1706.10,710.00,2002.20,296.10,'2023-03-09 09:01:39'),(1995,'1','313',1,'Retail Sale Id 2047',0.00,4840.00,710.00,5680.00,840.00,'2023-03-09 09:03:00'),(1996,'1','313',1,'Retail Sale Id 2048',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 09:03:54'),(1997,'1','313',1,'Retail Sale Id 2049',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 09:06:00'),(1998,'1','313',1,'Retail Sale Id 2050',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 09:06:44'),(1999,'1','313',1,'Retail Sale Id 2051',0.00,4216.85,710.00,4948.70,731.85,'2023-03-09 09:08:42'),(2000,'1','313',1,'Retail Sale Id 2052',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 09:09:28'),(2001,'1','313',1,'Retail Sale Id 2053',0.00,4235.00,710.00,4970.00,735.00,'2023-03-09 09:10:50'),(2002,'1','313',1,'Retail Sale Id 2054',0.00,38720.00,670.00,42880.00,4160.00,'2023-03-09 09:11:56'),(2003,'1','313',1,'Retail Sale Id 2055',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-09 09:13:19'),(2004,'1','313',1,'Retail Sale Id 2056',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 09:14:15'),(2005,'1','313',1,'Retail Sale Id 2057',0.00,683.65,710.00,802.30,118.65,'2023-03-09 09:14:55'),(2006,'1','313',1,'Retail Sale Id 2058',0.00,853.05,710.00,1001.10,148.05,'2023-03-09 09:15:50'),(2007,'1','313',1,'Retail Sale Id 2059',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 09:16:42'),(2008,'1','313',1,'Retail Sale Id 2060',0.00,1276.55,710.00,1498.10,221.55,'2023-03-09 09:17:50'),(2009,'1','313',1,'Retail Sale Id 2061',0.00,853.05,710.00,1001.10,148.05,'2023-03-09 09:19:04'),(2010,'1','313',1,'Retail Sale Id 2062',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-09 09:22:47'),(2011,'1','313',1,'Return of Retail Sale Id 2062',36300.00,0.00,670.00,-40200.00,-3900.00,'2023-03-09 09:23:44'),(2012,'1','313',1,'Retail Sale Id 2063',0.00,121605.00,670.00,134670.00,13065.00,'2023-03-09 09:24:36'),(2013,'1','313',1,'Retail Sale Id 2064',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 09:25:43'),(2014,'1','313',1,'Retail Sale Id 2065',0.00,605.00,710.00,710.00,105.00,'2023-03-09 09:26:40'),(2015,'1','313',1,'Retail Sale Id 2066',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 09:27:29'),(2016,'1','313',1,'Retail Sale Id 2067',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-09 09:28:19'),(2017,'1','313',1,'Retail Sale Id 2068',0.00,937.75,710.00,1100.50,162.75,'2023-03-09 09:29:09'),(2018,'1','313',1,'Retail Sale Id 2069',0.00,2559.15,710.00,3003.30,444.15,'2023-03-09 09:29:58'),(2019,'1','313',1,'Retail Sale Id 2070',0.00,605.00,710.00,710.00,105.00,'2023-03-09 09:32:20'),(2020,'1','313',1,'Retail Sale Id 2071',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-09 09:33:26'),(2021,'1','313',1,'Retail Sale Id 2072',0.00,605.00,710.00,710.00,105.00,'2023-03-09 09:34:16'),(2022,'1','313',1,'Retail Sale Id 2073',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-09 09:35:40'),(2023,'1','313',1,'Retail Sale Id 2074',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 09:40:59'),(2024,'1','313',1,'Retail Sale Id 2075',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 09:45:10'),(2025,'1','313',1,'Retail Sale Id 2076',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 09:46:36'),(2026,'1','313',1,'Retail Sale Id 2077',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 09:50:40'),(2027,'1','313',1,'Retail Sale Id 2078',0.00,4259.20,710.00,4998.40,739.20,'2023-03-09 09:51:30'),(2028,'1','313',1,'Retail Sale Id 2079',0.00,2420.00,710.00,2840.00,420.00,'2023-03-09 09:54:24'),(2029,'1','313',1,'Retail Sale Id 2080',0.00,605.00,710.00,710.00,105.00,'2023-03-09 09:56:09'),(2030,'1','313',1,'Retail Sale Id 2081',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 09:57:26'),(2031,'1','313',1,'Retail Sale Id 2082',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 09:58:59'),(2032,'1','313',1,'Retail Sale Id 2083',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-09 10:01:55'),(2033,'1','313',1,'Retail Sale Id 2084',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-09 10:03:59'),(2034,'1','313',1,'Retail Sale Id 2085',0.00,120824.55,670.00,133805.70,12981.15,'2023-03-09 10:04:58'),(2035,'1','313',1,'Return of Retail Sale Id 2063',121605.00,0.00,670.00,-134670.00,-13065.00,'2023-03-09 10:05:34'),(2036,'1','313',1,'Retail Sale Id 2086',0.00,641.30,710.00,752.60,111.30,'2023-03-09 10:06:32'),(2037,'1','313',1,'Retail Sale Id 2087',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 10:08:13'),(2038,'1','313',1,'Retail Sale Id 2088',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 10:09:02'),(2039,'1','313',1,'Retail Sale Id 2089',0.00,641.30,710.00,752.60,111.30,'2023-03-09 10:10:37'),(2040,'1','313',1,'Retail Sale Id 2090',0.00,3630.00,710.00,4260.00,630.00,'2023-03-09 10:12:36'),(2041,'1','313',1,'Retail Sale Id 2091',0.00,2559.15,710.00,3003.30,444.15,'2023-03-09 10:14:56'),(2042,'1','313',1,'Retail Sale Id 2092',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-09 10:19:08'),(2043,'1','313',1,'Retail Sale Id 2093',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 10:20:52'),(2044,'1','313',1,'Retail Sale Id 2094',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 10:21:47'),(2045,'1','313',1,'Retail Sale Id 2095',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 10:24:07'),(2046,'1','313',1,'Retail Sale Id 2096',0.00,2420.00,710.00,2840.00,420.00,'2023-03-09 10:24:56'),(2047,'1','313',1,'Retail Sale Id 2097',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 10:27:07'),(2048,'1','313',1,'Retail Sale Id 2098',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 10:31:10'),(2049,'1','313',1,'Retail Sale Id 2099',0.00,2420.00,710.00,2840.00,420.00,'2023-03-09 10:34:49'),(2050,'1','313',1,'Retail Sale Id 2100',0.00,3630.00,710.00,4260.00,630.00,'2023-03-09 10:37:42'),(2051,'1','313',1,'Retail Sale Id 2101',0.00,2420.00,710.00,2840.00,420.00,'2023-03-09 10:38:32'),(2052,'1','313',1,'Retail Sale Id 2102',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 10:40:08'),(2053,'1','313',1,'Retail Sale Id 2103',0.00,3630.00,710.00,4260.00,630.00,'2023-03-09 10:41:55'),(2054,'1','313',1,'Retail Sale Id 2104',0.00,853.05,710.00,1001.10,148.05,'2023-03-09 10:45:21'),(2055,'1','313',1,'Retail Sale Id 2105',0.00,2420.00,710.00,2840.00,420.00,'2023-03-09 10:46:16'),(2056,'1','313',1,'Retail Sale Id 2106',0.00,3630.00,710.00,4260.00,630.00,'2023-03-09 10:48:32'),(2057,'1','313',1,'Retail Sale Id 2107',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 10:49:20'),(2058,'1','313',1,'Retail Sale Id 2108',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 10:50:09'),(2059,'1','313',1,'Retail Sale Id 2109',0.00,4235.00,710.00,4970.00,735.00,'2023-03-09 10:52:13'),(2060,'1','313',1,'Retail Sale Id 2110',0.00,605.00,710.00,710.00,105.00,'2023-03-09 10:53:11'),(2061,'1','313',1,'Retail Sale Id 2111',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 10:53:53'),(2062,'1','313',1,'Retail Sale Id 2112',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 10:57:39'),(2063,'1','313',1,'Retail Sale Id 2113',0.00,2129.60,710.00,2499.20,369.60,'2023-03-09 10:58:47'),(2064,'1','313',1,'Retail Sale Id 2114',0.00,1276.55,710.00,1498.10,221.55,'2023-03-09 10:59:54'),(2065,'1','313',1,'Retail Sale Id 2115',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 11:01:02'),(2066,'1','313',1,'Retail Sale Id 2116',0.00,5445.00,710.00,6390.00,945.00,'2023-03-09 11:01:58'),(2067,'1','313',1,'Retail Sale Id 2117',0.00,605.00,710.00,710.00,105.00,'2023-03-09 11:02:43'),(2068,'1','313',1,'Retail Sale Id 2118',0.00,683.65,710.00,802.30,118.65,'2023-03-09 11:03:30'),(2069,'1','313',1,'Retail Sale Id 2119',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 11:04:18'),(2070,'1','313',1,'Retail Sale Id 2120',0.00,3630.00,710.00,4260.00,630.00,'2023-03-09 11:05:02'),(2071,'1','313',1,'Retail Sale Id 2121',0.00,108900.00,670.00,120600.00,11700.00,'2023-03-09 11:06:10'),(2072,'1','313',1,'Retail Sale Id 2122',0.00,4235.00,710.00,4970.00,735.00,'2023-03-09 11:07:07'),(2073,'1','313',1,'Retail Sale Id 2123',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 11:07:57'),(2074,'1','313',1,'Retail Sale Id 2124',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 11:09:09'),(2075,'1','313',1,'Retail Sale Id 2125',0.00,605.00,710.00,710.00,105.00,'2023-03-09 11:10:34'),(2076,'1','313',1,'Retail Sale Id 2126',0.00,853.05,710.00,1001.10,148.05,'2023-03-09 11:11:41'),(2077,'1','313',1,'Retail Sale Id 2127',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 11:13:16'),(2078,'1','313',1,'Retail Sale Id 2128',0.00,3630.00,710.00,4260.00,630.00,'2023-03-09 11:14:15'),(2079,'1','313',1,'Retail Sale Id 2130',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 11:17:10'),(2080,'1','313',1,'Retail Sale Id 2131',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-09 11:18:13'),(2081,'1','313',1,'Retail Sale Id 2132',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 11:18:58'),(2082,'1','313',1,'Retail Sale Id 2134',0.00,4235.00,710.00,4970.00,735.00,'2023-03-09 11:24:20'),(2083,'1','313',1,'Retail Sale Id 2135',0.00,4380.20,710.00,5140.40,760.20,'2023-03-09 11:28:18'),(2084,'1','313',1,'Retail Sale Id 2136',0.00,2420.00,710.00,2840.00,420.00,'2023-03-09 11:30:47'),(2085,'1','313',1,'Retail Sale Id 2137',0.00,5445.00,710.00,6390.00,945.00,'2023-03-09 11:31:54'),(2086,'1','313',1,'Retail Sale Id 2138',0.00,2982.65,710.00,3500.30,517.65,'2023-03-09 11:33:01'),(2087,'1','313',1,'Retail Sale Id 2139',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 11:33:48'),(2088,'1','313',1,'Retail Sale Id 2140',0.00,2420.00,710.00,2840.00,420.00,'2023-03-09 11:35:46'),(2089,'1','313',1,'Retail Sale Id 2141',0.00,1833.15,710.00,2151.30,318.15,'2023-03-09 11:36:29'),(2090,'1','313',1,'Retail Sale Id 2142',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 11:37:09'),(2091,'1','313',1,'Retail Sale Id 2143',0.00,2559.15,710.00,3003.30,444.15,'2023-03-09 11:38:06'),(2092,'1','313',1,'Retail Sale Id 2144',0.00,641.30,710.00,752.60,111.30,'2023-03-09 11:39:17'),(2093,'1','313',1,'Retail Sale Id 2145',0.00,2420.00,710.00,2840.00,420.00,'2023-03-09 11:40:32'),(2094,'1','313',1,'Retail Sale Id 2146',0.00,1276.55,710.00,1498.10,221.55,'2023-03-09 11:41:59'),(2095,'1','313',1,'Retail Sale Id 2147',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 11:42:50'),(2096,'1','313',1,'Retail Sale Id 2148',0.00,605.00,710.00,710.00,105.00,'2023-03-09 11:44:03'),(2097,'1','313',1,'Retail Sale Id 2149',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 11:44:51'),(2098,'1','313',1,'Retail Sale Id 2150',0.00,4259.20,710.00,4998.40,739.20,'2023-03-09 11:48:32'),(2099,'1','313',1,'Retail Sale Id 2151',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 11:52:37'),(2100,'1','313',1,'Retail Sale Id 2152',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 11:54:36'),(2101,'1','313',1,'Retail Sale Id 2153',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 12:00:12'),(2102,'1','313',1,'Retail Sale Id 2154',0.00,2420.00,710.00,2840.00,420.00,'2023-03-09 12:01:06'),(2103,'1','313',1,'Retail Sale Id 2155',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-09 12:03:15'),(2104,'1','313',1,'Retail Sale Id 2157',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 12:04:48'),(2105,'1','313',1,'Retail Sale Id 2158',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 12:05:32'),(2106,'1','313',1,'Retail Sale Id 2159',0.00,4235.00,710.00,4970.00,735.00,'2023-03-09 12:06:25'),(2107,'1','313',1,'Retail Sale Id 2160',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 12:07:17'),(2108,'1','313',1,'Retail Sale Id 2161',0.00,3630.00,710.00,4260.00,630.00,'2023-03-09 12:10:21'),(2109,'1','313',1,'Retail Sale Id 2162',0.00,641.30,710.00,752.60,111.30,'2023-03-09 12:12:00'),(2110,'1','313',1,'Retail Sale Id 2163',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 12:13:29'),(2111,'1','313',1,'Retail Sale Id 2164',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 12:15:12'),(2112,'1','313',1,'Retail Sale Id 2165',0.00,4235.00,710.00,4970.00,735.00,'2023-03-09 12:17:41'),(2113,'1','313',1,'Retail Sale Id 2167',0.00,1790.80,710.00,2101.60,310.80,'2023-03-09 12:23:25'),(2114,'1','313',1,'Retail Sale Id 2168',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 12:25:18'),(2115,'1','313',1,'Retail Sale Id 2169',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-09 12:28:08'),(2116,'1','313',1,'Retail Sale Id 2170',0.00,4840.00,710.00,5680.00,840.00,'2023-03-09 12:30:34'),(2117,'1','313',1,'Retail Sale Id 2171',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 12:32:35'),(2118,'1','313',1,'Retail Sale Id 2172',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 12:33:55'),(2119,'1','313',1,'Retail Sale Id 2173',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 12:35:37'),(2120,'1','313',1,'Retail Sale Id 2174',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 12:37:28'),(2121,'1','313',1,'Retail Sale Id 2175',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 12:38:11'),(2122,'1','313',1,'Retail Sale Id 2176',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 12:40:13'),(2123,'1','313',1,'Retail Sale Id 2177',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 12:41:26'),(2124,'1','313',1,'Retail Sale Id 2178',0.00,605.00,710.00,710.00,105.00,'2023-03-09 12:42:38'),(2125,'1','313',1,'Retail Sale Id 2179',0.00,1706.10,710.00,2002.20,296.10,'2023-03-09 12:45:43'),(2126,'1','313',1,'Retail Sale Id 2180',0.00,1276.55,710.00,1498.10,221.55,'2023-03-09 12:46:35'),(2127,'1','313',1,'Retail Sale Id 2181',0.00,641.30,710.00,752.60,111.30,'2023-03-09 12:48:23'),(2128,'1','313',1,'Retail Sale Id 2182',0.00,15125.00,670.00,16750.00,1625.00,'2023-03-09 12:51:15'),(2129,'1','313',1,'Retail Sale Id 2183',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-09 12:52:07'),(2130,'1','313',1,'Retail Sale Id 2184',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 12:53:54'),(2131,'1','313',1,'Retail Sale Id 2185',0.00,853.05,710.00,1001.10,148.05,'2023-03-09 12:58:18'),(2132,'1','313',1,'Retail Sale Id 2186',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 13:00:07'),(2133,'1','313',1,'Retail Sale Id 2187',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 13:03:42'),(2134,'1','313',1,'Retail Sale Id 2188',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-09 13:07:12'),(2135,'1','313',1,'Return of Retail Sale Id 2188',36300.00,0.00,670.00,-40200.00,-3900.00,'2023-03-09 13:07:46'),(2136,'1','313',1,'Retail Sale Id 2189',0.00,2420.00,710.00,2840.00,420.00,'2023-03-09 13:09:20'),(2137,'1','313',1,'Retail Sale Id 2190',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-09 13:10:14'),(2138,'1','313',1,'Retail Sale Id 2191',0.00,19057.50,670.00,21105.00,2047.50,'2023-03-09 13:18:19'),(2139,'1','313',1,'Retail Sale Id 2192',0.00,2420.00,710.00,2840.00,420.00,'2023-03-09 13:19:10'),(2140,'1','313',1,'Retail Sale Id 2193',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 13:23:34'),(2141,'1','313',1,'Retail Sale Id 2194',0.00,605.00,710.00,710.00,105.00,'2023-03-09 13:25:54'),(2142,'1','313',1,'Retail Sale Id 2195',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 13:27:30'),(2143,'1','313',1,'Retail Sale Id 2196',0.00,695.75,710.00,816.50,120.75,'2023-03-09 13:28:42'),(2144,'1','313',1,'Retail Sale Id 2197',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 13:30:39'),(2145,'1','313',1,'Retail Sale Id 2198',0.00,2420.00,710.00,2840.00,420.00,'2023-03-09 13:33:56'),(2146,'1','313',1,'Retail Sale Id 2199',0.00,4259.20,710.00,4998.40,739.20,'2023-03-09 13:36:27'),(2147,'1','313',1,'Retail Sale Id 2200',0.00,853.05,710.00,1001.10,148.05,'2023-03-09 13:39:28'),(2148,'1','313',1,'Retail Sale Id 2201',0.00,2129.60,710.00,2499.20,369.60,'2023-03-09 13:40:24'),(2149,'1','313',1,'Retail Sale Id 2202',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-09 13:41:08'),(2150,'1','313',1,'Retail Sale Id 2203',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-09 13:43:23'),(2151,'1','313',1,'Retail Sale Id 2204',0.00,4235.00,710.00,4970.00,735.00,'2023-03-09 13:45:16'),(2152,'1','313',1,'Retail Sale Id 2205',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 13:47:36'),(2153,'1','313',1,'Retail Sale Id 2206',0.00,75582.65,670.00,83703.10,8120.45,'2023-03-09 13:50:32'),(2154,'1','313',1,'Retail Sale Id 2207',0.00,1234.20,710.00,1448.40,214.20,'2023-03-09 13:52:44'),(2155,'1','313',1,'Retail Sale Id 2208',0.00,98615.00,670.00,109210.00,10595.00,'2023-03-09 13:54:41'),(2156,'1','313',1,'Retail Sale Id 2209',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 13:56:22'),(2157,'1','313',1,'Retail Sale Id 2210',0.00,2420.00,710.00,2840.00,420.00,'2023-03-09 13:57:33'),(2158,'1','313',1,'Retail Sale Id 2211',0.00,3630.00,710.00,4260.00,630.00,'2023-03-09 13:58:57'),(2159,'1','313',1,'Retail Sale Id 2212',0.00,4235.00,710.00,4970.00,735.00,'2023-03-09 14:00:11'),(2160,'1','313',1,'Retail Sale Id 2213',0.00,2420.00,710.00,2840.00,420.00,'2023-03-09 14:01:23'),(2161,'1','313',1,'Retail Sale Id 2214',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 14:02:06'),(2162,'1','313',1,'Retail Sale Id 2215',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 14:03:04'),(2163,'1','313',1,'Retail Sale Id 2216',0.00,605.00,710.00,710.00,105.00,'2023-03-09 14:04:43'),(2164,'1','313',1,'Retail Sale Id 2217',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 14:07:23'),(2165,'1','313',1,'Retail Sale Id 2218',0.00,8470.00,710.00,9940.00,1470.00,'2023-03-09 14:12:12'),(2166,'1','313',1,'Retail Sale Id 2219',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-09 14:13:36'),(2167,'1','313',1,'Retail Sale Id 2220',0.00,641.30,710.00,752.60,111.30,'2023-03-09 14:15:41'),(2168,'1','313',1,'Retail Sale Id 2221',0.00,641.30,710.00,752.60,111.30,'2023-03-09 14:22:47'),(2169,'1','313',1,'Retail Sale Id 2222',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-09 14:25:11'),(2170,'1','313',1,'Retail Sale Id 2223',0.00,611.05,710.00,717.10,106.05,'2023-03-09 14:25:54'),(2171,'1','313',1,'Retail Sale Id 2224',0.00,2420.00,710.00,2840.00,420.00,'2023-03-09 14:28:23'),(2172,'1','313',1,'Retail Sale Id 2225',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-09 14:33:50'),(2173,'1','313',1,'Retail Sale Id 2226',0.00,369.05,710.00,433.10,64.05,'2023-03-09 14:34:43'),(2174,'1','313',1,'Retail Sale Id 2227',0.00,36306.05,670.00,40206.70,3900.65,'2023-03-09 14:36:03'),(2175,'1','313',1,'Retail Sale Id 2228',0.00,641.30,710.00,752.60,111.30,'2023-03-09 14:38:06'),(2176,'1','313',1,'Retail Sale Id 2229',0.00,1276.55,710.00,1498.10,221.55,'2023-03-09 14:39:15'),(2177,'1','313',1,'Return of Retail Sale Id 2223',611.05,0.00,710.00,-717.10,-106.05,'2023-03-09 14:42:47'),(2178,'1','313',1,'Retail Sale Id 2230',0.00,605.00,710.00,710.00,105.00,'2023-03-09 14:47:22'),(2179,'1','313',1,'Retail Sale Id 2231',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 14:48:39'),(2180,'1','313',1,'Retail Sale Id 2232',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-09 14:49:59'),(2181,'1','313',1,'Retail Sale Id 2233',0.00,605.00,710.00,710.00,105.00,'2023-03-09 14:51:27'),(2182,'1','313',1,'Retail Sale Id 2234',0.00,2559.15,710.00,3003.30,444.15,'2023-03-09 14:54:34'),(2183,'1','313',1,'Retail Sale Id 2235',0.00,605.00,710.00,710.00,105.00,'2023-03-09 14:55:42'),(2184,'1','313',1,'Retail Sale Id 2236',0.00,4235.00,710.00,4970.00,735.00,'2023-03-09 14:56:48'),(2185,'1','313',1,'Retail Sale Id 2237',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 14:57:58'),(2186,'1','313',1,'Retail Sale Id 2238',0.00,4840.00,710.00,5680.00,840.00,'2023-03-09 14:59:41'),(2187,'1','313',1,'Retail Sale Id 2239',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 15:02:31'),(2188,'1','313',1,'Retail Sale Id 2241',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 15:11:41'),(2189,'1','313',1,'Retail Sale Id 2242',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 15:12:49'),(2190,'1','313',1,'Retail Sale Id 2243',0.00,4235.00,710.00,4970.00,735.00,'2023-03-09 15:13:42'),(2191,'1','313',1,'Retail Sale Id 2244',0.00,2420.00,710.00,2840.00,420.00,'2023-03-09 15:15:10'),(2192,'1','313',1,'Retail Sale Id 2245',0.00,641.30,710.00,752.60,111.30,'2023-03-09 15:17:36'),(2193,'1','313',1,'Retail Sale Id 2246',0.00,1536.70,710.00,1803.40,266.70,'2023-03-09 15:18:37'),(2194,'1','313',1,'Retail Sale Id 2247',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 15:19:39'),(2195,'1','313',1,'Retail Sale Id 2248',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-09 15:20:43'),(2196,'1','313',1,'Retail Sale Id 2249',0.00,1191.85,710.00,1398.70,206.85,'2023-03-09 15:28:19'),(2197,'1','313',1,'Retail Sale Id 2251',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-09 15:31:38'),(2198,'1','313',1,'Retail Sale Id 2252',0.00,3630.00,710.00,4260.00,630.00,'2023-03-09 15:33:51'),(2199,'1','313',1,'Retail Sale Id 2253',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 15:35:06'),(2200,'1','313',1,'Retail Sale Id 2254',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 15:36:35'),(2201,'1','313',1,'Retail Sale Id 2255',0.00,605.00,710.00,710.00,105.00,'2023-03-09 15:38:29'),(2202,'1','313',1,'Retail Sale Id 2256',0.00,605.00,710.00,710.00,105.00,'2023-03-09 15:39:56'),(2203,'1','313',1,'Retail Sale Id 2257',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 15:40:59'),(2204,'1','313',1,'Retail Sale Id 2258',0.00,641.30,710.00,752.60,111.30,'2023-03-09 15:41:57'),(2205,'1','313',1,'Retail Sale Id 2259',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-09 15:42:56'),(2206,'1','313',1,'Retail Sale Id 2260',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 15:44:24'),(2207,'1','313',1,'Retail Sale Id 2261',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 15:47:08'),(2208,'1','313',1,'Retail Sale Id 2262',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 15:56:27'),(2209,'1','313',1,'Retail Sale Id 2264',0.00,605.00,710.00,710.00,105.00,'2023-03-09 15:59:20'),(2210,'1','313',1,'Retail Sale Id 2265',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 16:02:04'),(2211,'1','313',1,'Retail Sale Id 2266',0.00,30250.00,710.00,35500.00,5250.00,'2023-03-09 16:03:37'),(2212,'1','313',1,'Retail Sale Id 2267',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 16:04:05'),(2213,'1','313',1,'Retail Sale Id 2268',0.00,3630.00,710.00,4260.00,630.00,'2023-03-09 16:05:06'),(2214,'1','313',1,'Retail Sale Id 2269',0.00,641.30,710.00,752.60,111.30,'2023-03-09 16:06:30'),(2215,'1','313',1,'Retail Sale Id 2270',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 16:07:35'),(2216,'1','313',1,'Retail Sale Id 2271',0.00,1833.15,710.00,2151.30,318.15,'2023-03-09 16:11:17'),(2217,'1','313',1,'Retail Sale Id 2272',0.00,605.00,710.00,710.00,105.00,'2023-03-09 16:12:45'),(2218,'1','313',1,'Retail Sale Id 2273',0.00,1234.20,710.00,1448.40,214.20,'2023-03-09 16:16:17'),(2219,'1','313',1,'Retail Sale Id 2275',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 16:18:51'),(2220,'1','313',1,'Retail Sale Id 2276',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 16:20:11'),(2221,'1','313',1,'Retail Sale Id 2277',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 16:21:13'),(2222,'1','313',1,'Retail Sale Id 2278',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-09 16:22:14'),(2223,'1','313',1,'Retail Sale Id 2279',0.00,605.00,710.00,710.00,105.00,'2023-03-09 16:23:53'),(2224,'1','313',1,'Retail Sale Id 2280',0.00,2420.00,710.00,2840.00,420.00,'2023-03-09 16:27:03'),(2225,'1','313',1,'Retail Sale Id 2281',0.00,3406.15,710.00,3997.30,591.15,'2023-03-09 16:27:45'),(2226,'1','313',1,'Retail Sale Id 2282',0.00,2420.00,710.00,2840.00,420.00,'2023-03-09 16:29:16'),(2227,'1','313',1,'Retail Sale Id 2283',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-09 16:31:50'),(2228,'1','313',1,'Retail Sale Id 2284',0.00,4840.00,710.00,5680.00,840.00,'2023-03-09 16:35:59'),(2229,'1','313',1,'Retail Sale Id 2285',0.00,2420.00,710.00,2840.00,420.00,'2023-03-09 16:36:36'),(2230,'1','313',1,'Retail Sale Id 2286',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-09 16:40:37'),(2231,'1','313',1,'Retail Sale Id 2287',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 16:43:37'),(2232,'1','313',1,'Retail Sale Id 2288',0.00,605.00,710.00,710.00,105.00,'2023-03-09 16:45:01'),(2233,'1','313',1,'Retail Sale Id 2289',0.00,641.30,710.00,752.60,111.30,'2023-03-09 16:46:09'),(2234,'1','313',1,'Retail Sale Id 2290',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-09 16:47:02'),(2235,'1','313',1,'Retail Sale Id 2291',0.00,4259.20,710.00,4998.40,739.20,'2023-03-09 16:49:06'),(2236,'1','313',1,'Retail Sale Id 2292',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-09 16:50:11'),(2237,'1','313',1,'Retail Sale Id 2293',0.00,4235.00,710.00,4970.00,735.00,'2023-03-09 16:57:03'),(2238,'1','313',1,'Retail Sale Id 2294',0.00,2420.00,710.00,2840.00,420.00,'2023-03-09 16:57:54'),(2239,'1','313',1,'Retail Sale Id 2295',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 17:00:12'),(2240,'1','313',1,'Retail Sale Id 2296',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 17:01:46'),(2241,'1','313',1,'Retail Sale Id 2297',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 17:03:40'),(2242,'1','313',1,'Retail Sale Id 2298',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-09 17:04:45'),(2243,'1','313',1,'Retail Sale Id 2299',0.00,3630.00,710.00,4260.00,630.00,'2023-03-09 17:05:33'),(2244,'1','313',1,'Retail Sale Id 2300',0.00,4235.00,710.00,4970.00,735.00,'2023-03-09 17:06:45'),(2245,'1','313',1,'Retail Sale Id 2301',0.00,2420.00,710.00,2840.00,420.00,'2023-03-09 17:07:55'),(2246,'1','313',1,'Retail Sale Id 2302',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 17:09:13'),(2247,'1','313',1,'Retail Sale Id 2303',0.00,2559.15,710.00,3003.30,444.15,'2023-03-09 17:10:00'),(2248,'1','313',1,'Retail Sale Id 2304',0.00,7865.00,710.00,9230.00,1365.00,'2023-03-09 17:13:28'),(2249,'1','313',1,'Retail Sale Id 2305',0.00,3932.50,710.00,4615.00,682.50,'2023-03-09 17:14:51'),(2250,'1','313',1,'Retail Sale Id 2306',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 17:15:42'),(2251,'1','313',1,'Retail Sale Id 2307',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-09 17:16:55'),(2252,'1','313',1,'Retail Sale Id 2308',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-09 17:17:39'),(2253,'1','313',1,'Retail Sale Id 2309',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 17:18:43'),(2254,'1','313',1,'Retail Sale Id 2310',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 17:20:17'),(2255,'1','313',1,'Retail Sale Id 2311',0.00,641.30,710.00,752.60,111.30,'2023-03-09 17:22:31'),(2256,'1','313',1,'Retail Sale Id 2312',0.00,3025.00,710.00,3550.00,525.00,'2023-03-09 17:26:05'),(2257,'1','313',1,'Retail Sale Id 2313',0.00,3630.00,710.00,4260.00,630.00,'2023-03-09 17:28:17'),(2258,'1','313',1,'Retail Sale Id 2314',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-09 17:29:21'),(2259,'1','313',1,'Retail Sale Id 2315',0.00,4235.00,710.00,4970.00,735.00,'2023-03-09 17:30:18'),(2260,'1','313',1,'Retail Sale Id 2316',0.00,641.30,710.00,752.60,111.30,'2023-03-09 17:31:25'),(2261,'1','313',1,'Retail Sale Id 2317',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 17:33:36'),(2262,'1','313',1,'Retail Sale Id 2319',0.00,1210.00,710.00,1420.00,210.00,'2023-03-09 17:35:18'),(2263,'1','313',1,'Retail Sale Id 2320',0.00,1815.00,710.00,2130.00,315.00,'2023-03-09 17:36:44'),(2264,'1','313',1,'Return of Retail Sale Id 2266',30250.00,0.00,710.00,-35500.00,-5250.00,'2023-03-09 17:40:33'),(2265,'1','313',1,'Retail Sale Id 2321',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-09 17:41:19'),(2266,'1','313',1,'Return of Retail Sale Id 2191',19057.50,0.00,670.00,-21105.00,-2047.50,'2023-03-09 17:56:51'),(2267,'1','313',1,'Retail Sale Id 2322',0.00,19105.90,670.00,21158.60,2052.70,'2023-03-09 17:57:50'),(2268,'1','313',1,'Return of Retail Sale Id 2301',2420.00,0.00,710.00,-2840.00,-420.00,'2023-03-09 17:59:27'),(2269,'1','313',1,'Retail Sale Id 2323',0.00,1494.35,710.00,1753.70,259.35,'2023-03-09 18:00:33'),(2270,'1','313',1,'Retail Sale Id 2324',0.00,1875.50,710.00,2201.00,325.50,'2023-03-10 08:06:28'),(2271,'1','313',1,'Retail Sale Id 2325',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 08:08:01'),(2272,'1','313',1,'Retail Sale Id 2326',0.00,2420.00,710.00,2840.00,420.00,'2023-03-10 08:08:44'),(2273,'1','313',1,'Retail Sale Id 2327',0.00,1833.15,710.00,2151.30,318.15,'2023-03-10 08:09:55'),(2274,'1','313',1,'Retail Sale Id 2328',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-10 08:11:00'),(2275,'1','313',1,'Retail Sale Id 2329',0.00,17545.00,670.00,19430.00,1885.00,'2023-03-10 08:12:11'),(2276,'1','313',1,'Retail Sale Id 2330',0.00,1276.55,710.00,1498.10,221.55,'2023-03-10 08:13:12'),(2277,'1','313',1,'Retail Sale Id 2331',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 08:13:50'),(2278,'1','313',1,'Retail Sale Id 2332',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 08:14:27'),(2279,'1','313',1,'Retail Sale Id 2333',0.00,641.30,710.00,752.60,111.30,'2023-03-10 08:15:22'),(2280,'1','313',1,'Retail Sale Id 2334',0.00,641.30,710.00,752.60,111.30,'2023-03-10 08:16:33'),(2281,'1','313',1,'Retail Sale Id 2335',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 08:17:22'),(2282,'1','313',1,'Retail Sale Id 2336',0.00,3630.00,710.00,4260.00,630.00,'2023-03-10 08:18:16'),(2283,'1','313',1,'Retail Sale Id 2337',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 08:20:00'),(2284,'1','313',1,'Retail Sale Id 2338',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 08:22:21'),(2285,'1','313',1,'Retail Sale Id 2339',0.00,33275.00,670.00,36850.00,3575.00,'2023-03-10 08:23:01'),(2286,'1','313',1,'Retail Sale Id 2340',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 08:24:52'),(2287,'1','313',1,'Retail Sale Id 2341',0.00,3630.00,710.00,4260.00,630.00,'2023-03-10 08:25:51'),(2288,'1','313',1,'Retail Sale Id 2342',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 08:28:13'),(2289,'1','313',1,'Retail Sale Id 2343',0.00,4235.00,710.00,4970.00,735.00,'2023-03-10 08:29:07'),(2290,'1','313',1,'Retail Sale Id 2344',0.00,3630.00,710.00,4260.00,630.00,'2023-03-10 08:29:53'),(2291,'1','313',1,'Retail Sale Id 2345',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 08:30:39'),(2292,'1','313',1,'Retail Sale Id 2346',0.00,4235.00,710.00,4970.00,735.00,'2023-03-10 08:31:28'),(2293,'1','313',1,'Retail Sale Id 2347',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 08:33:59'),(2294,'1','313',1,'Retail Sale Id 2348',0.00,4235.00,710.00,4970.00,735.00,'2023-03-10 08:35:55'),(2295,'1','313',1,'Retail Sale Id 2349',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 08:37:32'),(2296,'1','313',1,'Retail Sale Id 2350',0.00,2420.00,710.00,2840.00,420.00,'2023-03-10 08:39:16'),(2297,'1','313',1,'Retail Sale Id 2351',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-10 08:39:53'),(2298,'1','313',1,'Retail Sale Id 2352',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 08:41:00'),(2299,'1','313',1,'Retail Sale Id 2353',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 08:45:05'),(2300,'1','313',1,'Retail Sale Id 2354',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 08:45:45'),(2301,'1','313',1,'Retail Sale Id 2355',0.00,3630.00,710.00,4260.00,630.00,'2023-03-10 08:47:34'),(2302,'1','313',1,'Retail Sale Id 2356',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 08:48:19'),(2303,'1','313',1,'Retail Sale Id 2357',0.00,4235.00,710.00,4970.00,735.00,'2023-03-10 08:49:35'),(2304,'1','313',1,'Retail Sale Id 2358',0.00,4235.00,710.00,4970.00,735.00,'2023-03-10 08:51:27'),(2305,'1','313',1,'Retail Sale Id 2359',0.00,2559.15,710.00,3003.30,444.15,'2023-03-10 08:52:18'),(2306,'1','313',1,'Retail Sale Id 2360',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 08:53:15'),(2307,'1','313',1,'Retail Sale Id 2361',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 08:53:54'),(2308,'1','313',1,'Retail Sale Id 2362',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 08:55:12'),(2309,'1','313',1,'Retail Sale Id 2363',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-10 08:56:01'),(2310,'1','313',1,'Retail Sale Id 2365',0.00,605.00,710.00,710.00,105.00,'2023-03-10 08:57:44'),(2311,'1','313',1,'Retail Sale Id 2366',0.00,853.05,710.00,1001.10,148.05,'2023-03-10 09:00:22'),(2312,'1','313',1,'Retail Sale Id 2368',0.00,641.30,710.00,752.60,111.30,'2023-03-10 09:07:29'),(2313,'1','313',1,'Retail Sale Id 2369',0.00,3666.30,710.00,4302.60,636.30,'2023-03-10 09:09:43'),(2314,'1','313',1,'Retail Sale Id 2370',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 09:10:40'),(2315,'1','313',1,'Retail Sale Id 2371',0.00,3630.00,710.00,4260.00,630.00,'2023-03-10 09:11:33'),(2316,'1','313',1,'Retail Sale Id 2372',0.00,1706.10,710.00,2002.20,296.10,'2023-03-10 09:12:14'),(2317,'1','313',1,'Retail Sale Id 2373',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 09:13:44'),(2318,'1','313',1,'Retail Sale Id 2374',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-10 09:15:23'),(2319,'1','313',1,'Retail Sale Id 2375',0.00,1536.70,710.00,1803.40,266.70,'2023-03-10 09:16:54'),(2320,'1','313',1,'Retail Sale Id 2376',0.00,2559.15,710.00,3003.30,444.15,'2023-03-10 09:18:07'),(2321,'1','313',1,'Retail Sale Id 2377',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-10 09:20:04'),(2322,'1','313',1,'Retail Sale Id 2378',0.00,4235.00,710.00,4970.00,735.00,'2023-03-10 09:21:33'),(2323,'1','313',1,'Retail Sale Id 2379',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 09:26:34'),(2324,'1','313',1,'Retail Sale Id 2380',0.00,605.00,710.00,710.00,105.00,'2023-03-10 09:27:26'),(2325,'1','313',1,'Retail Sale Id 2381',0.00,641.30,710.00,752.60,111.30,'2023-03-10 09:28:09'),(2326,'1','313',1,'Retail Sale Id 2382',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 09:28:58'),(2327,'1','313',1,'Retail Sale Id 2383',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-10 09:31:16'),(2328,'1','313',1,'Retail Sale Id 2384',0.00,641.30,710.00,752.60,111.30,'2023-03-10 09:32:02'),(2329,'1','313',1,'Retail Sale Id 2385',0.00,4259.20,710.00,4998.40,739.20,'2023-03-10 09:34:31'),(2330,'1','313',1,'Retail Sale Id 2386',0.00,36433.10,670.00,40347.40,3914.30,'2023-03-10 09:38:37'),(2331,'1','313',1,'Retail Sale Id 2387',0.00,25282.95,670.00,27999.30,2716.35,'2023-03-10 09:40:09'),(2332,'1','313',1,'Retail Sale Id 2388',0.00,1276.55,710.00,1498.10,221.55,'2023-03-10 09:40:55'),(2333,'1','313',1,'Retail Sale Id 2389',0.00,605.00,710.00,710.00,105.00,'2023-03-10 09:43:10'),(2334,'1','313',1,'Retail Sale Id 2390',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 09:43:53'),(2335,'1','313',1,'Retail Sale Id 2391',0.00,1228.15,710.00,1441.30,213.15,'2023-03-10 09:46:49'),(2336,'1','313',1,'Retail Sale Id 2392',0.00,641.30,710.00,752.60,111.30,'2023-03-10 09:47:39'),(2337,'1','313',1,'Retail Sale Id 2393',0.00,1234.20,710.00,1448.40,214.20,'2023-03-10 09:48:14'),(2338,'1','313',1,'Retail Sale Id 2394',0.00,14532.10,670.00,16093.40,1561.30,'2023-03-10 09:49:07'),(2339,'1','313',1,'Retail Sale Id 2395',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 09:50:43'),(2340,'1','313',1,'Retail Sale Id 2396',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 09:52:13'),(2341,'1','313',1,'Retail Sale Id 2397',0.00,2728.55,710.00,3202.10,473.55,'2023-03-10 09:53:06'),(2342,'1','313',1,'Retail Sale Id 2398',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 09:54:30'),(2343,'1','313',1,'Retail Sale Id 2399',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 09:55:45'),(2344,'1','313',1,'Retail Sale Id 2400',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 09:56:29'),(2345,'1','313',1,'Retail Sale Id 2401',0.00,3630.00,710.00,4260.00,630.00,'2023-03-10 09:57:24'),(2346,'1','313',1,'Retail Sale Id 2402',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 09:58:51'),(2347,'1','313',1,'Retail Sale Id 2403',0.00,3630.00,710.00,4260.00,630.00,'2023-03-10 10:05:29'),(2348,'1','313',1,'Retail Sale Id 2404',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 10:07:47'),(2349,'1','313',1,'Retail Sale Id 2405',0.00,1833.15,710.00,2151.30,318.15,'2023-03-10 10:10:05'),(2350,'1','313',1,'Retail Sale Id 2406',0.00,641.30,710.00,752.60,111.30,'2023-03-10 10:11:36'),(2351,'1','313',1,'Retail Sale Id 2407',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 10:13:41'),(2352,'1','313',1,'Retail Sale Id 2408',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 10:15:00'),(2353,'1','313',1,'Retail Sale Id 2409',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 10:16:45'),(2354,'1','313',1,'Retail Sale Id 2413',0.00,3406.15,710.00,3997.30,591.15,'2023-03-10 10:19:20'),(2355,'1','313',1,'Retail Sale Id 2414',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-10 10:19:45'),(2356,'1','313',1,'Retail Sale Id 2415',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 10:22:32'),(2357,'1','313',1,'Retail Sale Id 2416',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-10 10:23:28'),(2358,'1','313',1,'Retail Sale Id 2417',0.00,605.00,710.00,710.00,105.00,'2023-03-10 10:24:49'),(2359,'1','313',1,'Retail Sale Id 2418',0.00,4840.00,710.00,5680.00,840.00,'2023-03-10 10:27:30'),(2360,'1','313',1,'Retail Sale Id 2419',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 10:29:36'),(2361,'1','313',1,'Retail Sale Id 2420',0.00,36880.80,670.00,40843.20,3962.40,'2023-03-10 10:30:41'),(2362,'1','313',1,'Retail Sale Id 2421',0.00,10285.00,710.00,12070.00,1785.00,'2023-03-10 10:32:13'),(2363,'1','313',1,'Retail Sale Id 2422',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 10:33:19'),(2364,'1','313',1,'Retail Sale Id 2423',0.00,3406.15,710.00,3997.30,591.15,'2023-03-10 10:38:11'),(2365,'1','313',1,'Retail Sale Id 2424',0.00,2420.00,710.00,2840.00,420.00,'2023-03-10 10:38:57'),(2366,'1','313',1,'Retail Sale Id 2425',0.00,15125.00,670.00,16750.00,1625.00,'2023-03-10 10:41:19'),(2367,'1','313',1,'Retail Sale Id 2426',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 10:44:33'),(2368,'1','313',1,'Retail Sale Id 2427',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-10 10:45:19'),(2369,'1','313',1,'Retail Sale Id 2428',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 10:45:49'),(2370,'1','313',1,'Retail Sale Id 2429',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-10 10:46:46'),(2371,'1','313',1,'Retail Sale Id 2430',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 10:47:58'),(2372,'1','313',1,'Retail Sale Id 2431',0.00,2214.30,710.00,2598.60,384.30,'2023-03-10 10:49:58'),(2373,'1','313',1,'Retail Sale Id 2432',0.00,1234.20,710.00,1448.40,214.20,'2023-03-10 10:51:09'),(2374,'1','313',1,'Retail Sale Id 2433',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 10:52:19'),(2375,'1','313',1,'Retail Sale Id 2435',0.00,3666.30,710.00,4302.60,636.30,'2023-03-10 10:55:06'),(2376,'1','313',1,'Retail Sale Id 2436',0.00,2420.00,710.00,2840.00,420.00,'2023-03-10 10:55:53'),(2377,'1','313',1,'Retail Sale Id 2437',0.00,4235.00,710.00,4970.00,735.00,'2023-03-10 10:57:31'),(2378,'1','313',1,'Retail Sale Id 2438',0.00,605.00,710.00,710.00,105.00,'2023-03-10 10:58:34'),(2379,'1','313',1,'Retail Sale Id 2439',0.00,4235.00,710.00,4970.00,735.00,'2023-03-10 11:00:38'),(2380,'1','313',1,'Retail Sale Id 2440',0.00,8470.00,710.00,9940.00,1470.00,'2023-03-10 11:06:25'),(2381,'1','313',1,'Retail Sale Id 2441',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 11:07:19'),(2382,'1','313',1,'Retail Sale Id 2442',0.00,4235.00,710.00,4970.00,735.00,'2023-03-10 11:10:06'),(2383,'1','313',1,'Retail Sale Id 2443',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-10 11:11:18'),(2384,'1','313',1,'Retail Sale Id 2444',0.00,1833.15,710.00,2151.30,318.15,'2023-03-10 11:12:17'),(2385,'1','313',1,'Retail Sale Id 2445',0.00,3630.00,710.00,4260.00,630.00,'2023-03-10 11:13:02'),(2386,'1','313',1,'Retail Sale Id 2446',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-10 11:15:14'),(2387,'1','313',1,'Retail Sale Id 2447',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-10 11:17:35'),(2388,'1','313',1,'Retail Sale Id 2448',0.00,2420.00,710.00,2840.00,420.00,'2023-03-10 11:18:26'),(2389,'1','313',1,'Retail Sale Id 2449',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 11:18:58'),(2390,'1','313',1,'Retail Sale Id 2450',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 11:20:56'),(2391,'1','313',1,'Retail Sale Id 2451',0.00,2559.15,710.00,3003.30,444.15,'2023-03-10 11:21:32'),(2392,'1','313',1,'Retail Sale Id 2452',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 11:22:13'),(2393,'1','313',1,'Retail Sale Id 2453',0.00,3630.00,710.00,4260.00,630.00,'2023-03-10 11:24:00'),(2394,'1','313',1,'Retail Sale Id 2454',0.00,3630.00,710.00,4260.00,630.00,'2023-03-10 11:24:53'),(2395,'1','313',1,'Retail Sale Id 2455',0.00,1706.10,710.00,2002.20,296.10,'2023-03-10 11:25:28'),(2396,'1','313',1,'Retail Sale Id 2456',0.00,1234.20,710.00,1448.40,214.20,'2023-03-10 11:26:41'),(2397,'1','313',1,'Retail Sale Id 2457',0.00,2420.00,710.00,2840.00,420.00,'2023-03-10 11:28:33'),(2398,'1','313',1,'Retail Sale Id 2458',0.00,937.75,710.00,1100.50,162.75,'2023-03-10 11:30:13'),(2399,'1','313',1,'Retail Sale Id 2459',0.00,641.30,710.00,752.60,111.30,'2023-03-10 11:32:42'),(2400,'1','313',1,'Retail Sale Id 2460',0.00,4840.00,710.00,5680.00,840.00,'2023-03-10 11:34:56'),(2401,'1','313',1,'Retail Sale Id 2461',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 11:36:06'),(2402,'1','313',1,'Retail Sale Id 2462',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 11:38:18'),(2403,'1','313',1,'Retail Sale Id 2463',0.00,3630.00,710.00,4260.00,630.00,'2023-03-10 11:39:25'),(2404,'1','313',1,'Retail Sale Id 2464',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 11:41:27'),(2405,'1','313',1,'Retail Sale Id 2465',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 11:43:16'),(2406,'1','313',1,'Retail Sale Id 2466',0.00,3630.00,710.00,4260.00,630.00,'2023-03-10 11:44:55'),(2407,'1','313',1,'Retail Sale Id 2467',0.00,25282.95,670.00,27999.30,2716.35,'2023-03-10 11:49:33'),(2408,'1','313',1,'Retail Sale Id 2468',0.00,25410.00,710.00,29820.00,4410.00,'2023-03-10 11:51:44'),(2409,'1','313',1,'Retail Sale Id 2469',0.00,641.30,710.00,752.60,111.30,'2023-03-10 11:53:10'),(2410,'1','313',1,'Retail Sale Id 2470',0.00,2559.15,710.00,3003.30,444.15,'2023-03-10 11:53:55'),(2411,'1','313',1,'Retail Sale Id 2472',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 11:57:46'),(2412,'1','313',1,'Retail Sale Id 2473',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 11:59:22'),(2413,'1','313',1,'Retail Sale Id 2474',0.00,605.00,710.00,710.00,105.00,'2023-03-10 12:00:40'),(2414,'1','313',1,'Retail Sale Id 2475',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 12:03:42'),(2415,'1','313',1,'Retail Sale Id 2476',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-10 12:04:59'),(2416,'1','313',1,'Retail Sale Id 2477',0.00,641.30,710.00,752.60,111.30,'2023-03-10 12:06:17'),(2417,'1','313',1,'Retail Sale Id 2478',0.00,2420.00,710.00,2840.00,420.00,'2023-03-10 12:07:21'),(2418,'1','313',1,'Retail Sale Id 2479',0.00,1234.20,710.00,1448.40,214.20,'2023-03-10 12:09:46'),(2419,'1','313',1,'Retail Sale Id 2480',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-10 12:11:19'),(2420,'1','313',1,'Retail Sale Id 2481',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-10 12:12:25'),(2421,'1','313',1,'Retail Sale Id 2482',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 12:13:28'),(2422,'1','313',1,'Retail Sale Id 2483',0.00,4840.00,710.00,5680.00,840.00,'2023-03-10 12:15:14'),(2423,'1','313',1,'Retail Sale Id 2484',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 12:16:20'),(2424,'1','313',1,'Retail Sale Id 2485',0.00,1276.55,710.00,1498.10,221.55,'2023-03-10 12:18:06'),(2425,'1','313',1,'Retail Sale Id 2486',0.00,853.05,710.00,1001.10,148.05,'2023-03-10 12:20:03'),(2426,'1','313',1,'Retail Sale Id 2487',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-10 12:21:51'),(2427,'1','313',1,'Return of Retail Sale Id 2437',4235.00,0.00,710.00,-4970.00,-735.00,'2023-03-10 12:27:37'),(2428,'1','313',1,'Retail Sale Id 2488',0.00,3926.45,710.00,4607.90,681.45,'2023-03-10 12:28:18'),(2429,'1','313',1,'Retail Sale Id 2489',0.00,641.30,710.00,752.60,111.30,'2023-03-10 12:30:51'),(2430,'1','313',1,'Retail Sale Id 2490',0.00,641.30,710.00,752.60,111.30,'2023-03-10 12:31:25'),(2431,'1','313',1,'Retail Sale Id 2491',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-10 12:33:37'),(2432,'1','313',1,'Retail Sale Id 2492',0.00,18150.00,670.00,20100.00,1950.00,'2023-03-10 12:36:10'),(2433,'1','313',1,'Retail Sale Id 2493',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 12:37:14'),(2434,'1','313',1,'Retail Sale Id 2494',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 12:42:01'),(2435,'1','313',1,'Retail Sale Id 2495',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-10 12:46:31'),(2436,'1','313',1,'Retail Sale Id 2496',0.00,4840.00,710.00,5680.00,840.00,'2023-03-10 12:48:01'),(2437,'1','313',1,'Retail Sale Id 2497',0.00,2420.00,670.00,2680.00,260.00,'2023-03-10 12:52:56'),(2438,'1','313',1,'Retail Sale Id 2498',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 12:54:21'),(2439,'1','313',1,'Retail Sale Id 2500',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 13:04:39'),(2440,'1','313',1,'Retail Sale Id 2501',0.00,3630.00,710.00,4260.00,630.00,'2023-03-10 13:06:47'),(2441,'1','313',1,'Retail Sale Id 2502',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 13:08:22'),(2442,'1','313',1,'Retail Sale Id 2503',0.00,605.00,710.00,710.00,105.00,'2023-03-10 13:10:39'),(2443,'1','313',1,'Retail Sale Id 2504',0.00,605.00,710.00,710.00,105.00,'2023-03-10 13:11:53'),(2444,'1','313',1,'Retail Sale Id 2505',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 13:13:08'),(2445,'1','313',1,'Retail Sale Id 2506',0.00,2420.00,710.00,2840.00,420.00,'2023-03-10 13:17:04'),(2446,'1','313',1,'Retail Sale Id 2507',0.00,90750.00,670.00,100500.00,9750.00,'2023-03-10 13:18:05'),(2447,'1','313',1,'Retail Sale Id 2508',0.00,598.95,710.00,702.90,103.95,'2023-03-10 13:19:36'),(2448,'1','313',1,'Retail Sale Id 2509',0.00,2044.90,710.00,2399.80,354.90,'2023-03-10 13:21:12'),(2449,'1','313',1,'Retail Sale Id 2510',0.00,60500.00,670.00,67000.00,6500.00,'2023-03-10 13:22:26'),(2450,'1','313',1,'Retail Sale Id 2511',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 13:23:26'),(2451,'1','313',1,'Retail Sale Id 2512',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 13:24:39'),(2452,'1','313',1,'Return of Retail Sale Id 2507',90750.00,0.00,670.00,-100500.00,-9750.00,'2023-03-10 13:25:29'),(2453,'1','313',1,'Retail Sale Id 2513',0.00,641.30,710.00,752.60,111.30,'2023-03-10 13:26:25'),(2454,'1','313',1,'Retail Sale Id 2514',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-10 13:30:41'),(2455,'1','313',1,'Retail Sale Id 2515',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-10 13:37:47'),(2456,'1','313',1,'Retail Sale Id 2516',0.00,8470.00,710.00,9940.00,1470.00,'2023-03-10 13:39:25'),(2457,'1','313',1,'Retail Sale Id 2517',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 13:48:17'),(2458,'1','313',1,'Retail Sale Id 2518',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 13:49:32'),(2459,'1','313',1,'Retail Sale Id 2519',0.00,1276.55,710.00,1498.10,221.55,'2023-03-10 13:53:27'),(2460,'1','313',1,'Retail Sale Id 2520',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-10 13:56:12'),(2461,'1','313',1,'Retail Sale Id 2521',0.00,2420.00,710.00,2840.00,420.00,'2023-03-10 13:58:40'),(2462,'1','313',1,'Retail Sale Id 2522',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 14:06:52'),(2463,'1','313',1,'Retail Sale Id 2523',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-10 14:10:34'),(2464,'1','313',1,'Retail Sale Id 2524',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 14:15:26'),(2465,'1','313',1,'Retail Sale Id 2525',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 14:24:14'),(2466,'1','313',1,'Retail Sale Id 2526',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 14:27:08'),(2467,'1','313',1,'Retail Sale Id 2527',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 14:29:07'),(2468,'1','313',1,'Retail Sale Id 2529',0.00,4235.00,710.00,4970.00,735.00,'2023-03-10 14:32:24'),(2469,'1','313',1,'Retail Sale Id 2530',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 14:35:17'),(2470,'1','313',1,'Retail Sale Id 2531',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 14:40:15'),(2471,'1','313',1,'Retail Sale Id 2532',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 14:41:31'),(2472,'1','313',1,'Retail Sale Id 2534',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 14:50:33'),(2473,'1','313',1,'Retail Sale Id 2535',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 14:51:48'),(2474,'1','313',1,'Retail Sale Id 2536',0.00,3025.00,710.00,3550.00,525.00,'2023-03-10 14:52:53'),(2475,'1','313',1,'Retail Sale Id 2537',0.00,15125.00,710.00,17750.00,2625.00,'2023-03-10 14:54:42'),(2476,'1','313',1,'Retail Sale Id 2538',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 14:57:19'),(2477,'1','313',1,'Retail Sale Id 2539',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 14:58:53'),(2478,'1','313',1,'Retail Sale Id 2540',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 15:00:11'),(2479,'1','313',1,'Retail Sale Id 2541',0.00,605.00,710.00,710.00,105.00,'2023-03-10 15:01:59'),(2480,'1','313',1,'Retail Sale Id 2542',0.00,15125.00,710.00,17750.00,2625.00,'2023-03-10 15:02:37'),(2481,'1','313',1,'Retail Sale Id 2543',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 15:03:42'),(2482,'1','313',1,'Retail Sale Id 2544',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 15:05:00'),(2483,'1','313',1,'Retail Sale Id 2545',0.00,15125.00,710.00,17750.00,2625.00,'2023-03-10 15:06:24'),(2484,'1','313',1,'Retail Sale Id 2546',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 15:07:41'),(2485,'1','313',1,'Retail Sale Id 2547',0.00,4325.75,710.00,5076.50,750.75,'2023-03-10 15:11:19'),(2486,'1','313',1,'Return of Retail Sale Id 2460',4840.00,0.00,710.00,-5680.00,-840.00,'2023-03-10 15:13:21'),(2487,'1','313',1,'Retail Sale Id 2548',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-10 15:14:35'),(2488,'1','313',1,'Retail Sale Id 2549',0.00,605.00,710.00,710.00,105.00,'2023-03-10 15:18:59'),(2489,'1','313',1,'Retail Sale Id 2550',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 15:22:41'),(2490,'1','313',1,'Retail Sale Id 2551',0.00,605.00,710.00,710.00,105.00,'2023-03-10 15:23:47'),(2491,'1','313',1,'Retail Sale Id 2552',0.00,9075.00,670.00,10050.00,975.00,'2023-03-10 15:26:18'),(2492,'1','313',1,'Retail Sale Id 2553',0.00,641.30,710.00,752.60,111.30,'2023-03-10 15:37:02'),(2493,'1','313',1,'Retail Sale Id 2554',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 15:39:13'),(2494,'1','313',1,'Retail Sale Id 2555',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 15:40:43'),(2495,'1','313',1,'Retail Sale Id 2556',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 15:42:00'),(2496,'1','313',1,'Retail Sale Id 2557',0.00,768.35,710.00,901.70,133.35,'2023-03-10 15:42:44'),(2497,'1','313',1,'Retail Sale Id 2558',0.00,641.30,710.00,752.60,111.30,'2023-03-10 15:43:45'),(2498,'1','313',1,'Retail Sale Id 2559',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 15:45:20'),(2499,'1','313',1,'Retail Sale Id 2560',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-10 15:49:30'),(2500,'1','313',1,'Retail Sale Id 2561',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 15:50:38'),(2501,'1','313',1,'Retail Sale Id 2562',0.00,3630.00,710.00,4260.00,630.00,'2023-03-10 15:51:50'),(2502,'1','313',1,'Retail Sale Id 2563',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 15:54:11'),(2503,'1','313',1,'Retail Sale Id 2564',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 15:55:31'),(2504,'1','313',1,'Retail Sale Id 2565',0.00,1210.00,710.00,1420.00,210.00,'2023-03-10 15:58:58'),(2505,'1','313',1,'Retail Sale Id 2566',0.00,4235.00,710.00,4970.00,735.00,'2023-03-10 16:00:44'),(2506,'1','313',1,'Retail Sale Id 2567',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 16:04:31'),(2507,'1','313',1,'Retail Sale Id 2568',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-10 16:05:39'),(2508,'1','313',1,'Retail Sale Id 2569',0.00,4235.00,710.00,4970.00,735.00,'2023-03-10 16:07:02'),(2509,'1','313',1,'Retail Sale Id 2570',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 16:09:50'),(2510,'1','313',1,'Retail Sale Id 2571',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 16:14:20'),(2511,'1','313',1,'Retail Sale Id 2572',0.00,605.00,710.00,710.00,105.00,'2023-03-10 16:15:52'),(2512,'1','313',1,'Retail Sale Id 2573',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 16:17:36'),(2513,'1','313',1,'Retail Sale Id 2575',0.00,1191.85,710.00,1398.70,206.85,'2023-03-10 16:23:18'),(2514,'1','313',1,'Retail Sale Id 2576',0.00,2559.15,710.00,3003.30,444.15,'2023-03-10 16:24:16'),(2515,'1','313',1,'Retail Sale Id 2577',0.00,11077.55,710.00,13000.10,1922.55,'2023-03-10 16:26:29'),(2516,'1','313',1,'Retail Sale Id 2578',0.00,605.00,710.00,710.00,105.00,'2023-03-10 16:31:49'),(2517,'1','313',1,'Retail Sale Id 2579',0.00,605.00,710.00,710.00,105.00,'2023-03-10 16:35:02'),(2518,'1','313',1,'Retail Sale Id 2580',0.00,4235.00,710.00,4970.00,735.00,'2023-03-10 16:41:03'),(2519,'1','313',1,'Retail Sale Id 2581',0.00,605.00,710.00,710.00,105.00,'2023-03-10 16:42:20'),(2520,'1','313',1,'Retail Sale Id 2582',0.00,9680.00,710.00,11360.00,1680.00,'2023-03-10 16:44:15'),(2521,'1','313',1,'Retail Sale Id 2583',0.00,21175.00,670.00,23450.00,2275.00,'2023-03-10 16:47:06'),(2522,'1','313',1,'Retail Sale Id 2584',0.00,4840.00,710.00,5680.00,840.00,'2023-03-10 16:49:07'),(2523,'1','313',1,'Retail Sale Id 2585',0.00,18150.00,670.00,20100.00,1950.00,'2023-03-10 16:53:16'),(2524,'1','313',1,'Retail Sale Id 2588',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-10 16:58:49'),(2525,'1','313',1,'Return of Retail Sale Id 2588',6655.00,0.00,710.00,-7810.00,-1155.00,'2023-03-10 17:00:57'),(2526,'1','313',1,'Retail Sale Id 2590',0.00,4259.20,710.00,4998.40,739.20,'2023-03-10 17:07:03'),(2527,'1','313',1,'Retail Sale Id 2591',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 17:09:33'),(2528,'1','313',1,'Retail Sale Id 2593',0.00,3630.00,710.00,4260.00,630.00,'2023-03-10 17:11:07'),(2529,'1','313',1,'Retail Sale Id 2594',0.00,1815.00,710.00,2130.00,315.00,'2023-03-10 17:13:30'),(2530,'1','313',1,'Retail Sale Id 2595',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-10 17:15:03'),(2531,'1','313',1,'Retail Sale Id 2596',0.00,2420.00,710.00,2840.00,420.00,'2023-03-10 17:17:21'),(2532,'1','313',1,'Return of Retail Sale Id 2536',3025.00,0.00,710.00,-3550.00,-525.00,'2023-03-10 17:19:18'),(2533,'1','313',1,'Return of Retail Sale Id 2468',25410.00,0.00,710.00,-29820.00,-4410.00,'2023-03-10 17:22:33'),(2534,'1','313',1,'Return of Retail Sale Id 2577',11077.55,0.00,710.00,-13000.10,-1922.55,'2023-03-10 17:24:17'),(2535,'1','313',1,'Return of Retail Sale Id 2523',6050.00,0.00,710.00,-7100.00,-1050.00,'2023-03-10 17:25:37'),(2536,'1','313',1,'Retail Sale Id 2597',0.00,42537.55,670.00,47107.70,4570.15,'2023-03-10 17:26:56'),(2537,'1','313',1,'Return of Retail Sale Id 2582',9680.00,0.00,710.00,-11360.00,-1680.00,'2023-03-10 17:45:09'),(2538,'1','313',1,'Return of Retail Sale Id 2547',4325.75,0.00,710.00,-5076.50,-750.75,'2023-03-10 17:46:46'),(2539,'1','313',1,'Retail Sale Id 2598',0.00,2184.05,710.00,2563.10,379.05,'2023-03-10 17:47:29'),(2540,'1','313',1,'Retail Sale Id 2599',0.00,2420.00,710.00,2840.00,420.00,'2023-03-10 18:45:44'),(2541,'1','313',1,'Retail Sale Id 2600',0.00,3630.00,710.00,4260.00,630.00,'2023-03-10 18:46:46'),(2542,'1','313',1,'Return of Retail Sale Id 2599',2420.00,0.00,710.00,-2840.00,-420.00,'2023-03-10 19:01:58'),(2543,'1','313',1,'Retail Sale Id 2601',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 08:01:57'),(2544,'1','313',1,'Retail Sale Id 2602',0.00,4259.20,710.00,4998.40,739.20,'2023-03-11 08:02:57'),(2545,'1','313',1,'Retail Sale Id 2603',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 08:04:16'),(2546,'1','313',1,'Retail Sale Id 2604',0.00,4259.20,710.00,4998.40,739.20,'2023-03-11 08:06:39'),(2547,'1','313',1,'Retail Sale Id 2605',0.00,2129.60,710.00,2499.20,369.60,'2023-03-11 08:07:22'),(2548,'1','313',1,'Retail Sale Id 2606',0.00,4259.20,710.00,4998.40,739.20,'2023-03-11 08:09:29'),(2549,'1','313',1,'Retail Sale Id 2607',0.00,3630.00,710.00,4260.00,630.00,'2023-03-11 08:10:45'),(2550,'1','313',1,'Retail Sale Id 2608',0.00,1706.10,710.00,2002.20,296.10,'2023-03-11 08:11:40'),(2551,'1','313',1,'Retail Sale Id 2609',0.00,4840.00,710.00,5680.00,840.00,'2023-03-11 08:12:41'),(2552,'1','313',1,'Retail Sale Id 2610',0.00,605.00,710.00,710.00,105.00,'2023-03-11 08:13:46'),(2553,'1','313',1,'Retail Sale Id 2611',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-11 08:14:55'),(2554,'1','313',1,'Retail Sale Id 2612',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 08:15:32'),(2555,'1','313',1,'Retail Sale Id 2613',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 08:18:23'),(2556,'1','313',1,'Retail Sale Id 2614',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 08:18:48'),(2557,'1','313',1,'Retail Sale Id 2615',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 08:19:41'),(2558,'1','313',1,'Retail Sale Id 2616',0.00,27225.00,670.00,30150.00,2925.00,'2023-03-11 08:21:13'),(2559,'1','313',1,'Retail Sale Id 2617',0.00,1234.20,710.00,1448.40,214.20,'2023-03-11 08:22:08'),(2560,'1','313',1,'Retail Sale Id 2618',0.00,605.00,710.00,710.00,105.00,'2023-03-11 08:23:20'),(2561,'1','313',1,'Retail Sale Id 2619',0.00,1833.15,710.00,2151.30,318.15,'2023-03-11 08:24:02'),(2562,'1','313',1,'Retail Sale Id 2620',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-11 08:24:49'),(2563,'1','313',1,'Retail Sale Id 2621',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-11 08:26:07'),(2564,'1','313',1,'Retail Sale Id 2622',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 08:26:54'),(2565,'1','313',1,'Retail Sale Id 2623',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 08:27:48'),(2566,'1','313',1,'Retail Sale Id 2624',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-11 08:28:35'),(2567,'1','313',1,'Retail Sale Id 2625',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 08:29:19'),(2568,'1','313',1,'Retail Sale Id 2626',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 08:30:02'),(2569,'1','313',1,'Retail Sale Id 2627',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-11 08:30:45'),(2570,'1','313',1,'Retail Sale Id 2628',0.00,1234.20,710.00,1448.40,214.20,'2023-03-11 08:31:56'),(2571,'1','313',1,'Retail Sale Id 2629',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-11 08:33:27'),(2572,'1','313',1,'Retail Sale Id 2630',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 08:34:51'),(2573,'1','313',1,'Retail Sale Id 2631',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 08:35:27'),(2574,'1','313',1,'Retail Sale Id 2632',0.00,605.00,710.00,710.00,105.00,'2023-03-11 08:36:47'),(2575,'1','313',1,'Retail Sale Id 2633',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 08:37:26'),(2576,'1','313',1,'Retail Sale Id 2634',0.00,605.00,710.00,710.00,105.00,'2023-03-11 08:38:15'),(2577,'1','313',1,'Retail Sale Id 2635',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 08:39:02'),(2578,'1','313',1,'Retail Sale Id 2636',0.00,1706.10,710.00,2002.20,296.10,'2023-03-11 08:39:39'),(2579,'1','313',1,'Retail Sale Id 2637',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 08:41:28'),(2580,'1','313',1,'Retail Sale Id 2638',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 08:42:18'),(2581,'1','313',1,'Retail Sale Id 2639',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-11 08:43:20'),(2582,'1','313',1,'Retail Sale Id 2640',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-11 08:44:11'),(2583,'1','313',1,'Retail Sale Id 2641',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 08:45:04'),(2584,'1','313',1,'Retail Sale Id 2642',0.00,605.00,710.00,710.00,105.00,'2023-03-11 08:46:07'),(2585,'1','313',1,'Retail Sale Id 2643',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 08:47:11'),(2586,'1','313',1,'Retail Sale Id 2644',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 08:48:16'),(2587,'1','313',1,'Retail Sale Id 2645',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 08:49:57'),(2588,'1','313',1,'Retail Sale Id 2646',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-11 08:50:32'),(2589,'1','313',1,'Retail Sale Id 2647',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 08:51:31'),(2590,'1','313',1,'Retail Sale Id 2648',0.00,605.00,710.00,710.00,105.00,'2023-03-11 08:52:01'),(2591,'1','313',1,'Retail Sale Id 2649',0.00,1276.55,710.00,1498.10,221.55,'2023-03-11 08:52:38'),(2592,'1','313',1,'Retail Sale Id 2650',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-11 08:53:14'),(2593,'1','313',1,'Retail Sale Id 2651',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 08:54:35'),(2594,'1','313',1,'Retail Sale Id 2652',0.00,37026.00,670.00,41004.00,3978.00,'2023-03-11 08:56:23'),(2595,'1','313',1,'Retail Sale Id 2653',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 08:57:33'),(2596,'1','313',1,'Retail Sale Id 2654',0.00,4537.50,710.00,5325.00,787.50,'2023-03-11 08:59:00'),(2597,'1','313',1,'Retail Sale Id 2656',0.00,21175.00,670.00,23450.00,2275.00,'2023-03-11 09:03:56'),(2598,'1','313',1,'Retail Sale Id 2657',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 09:04:47'),(2599,'1','313',1,'Retail Sale Id 2658',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 09:06:07'),(2600,'1','313',1,'Retail Sale Id 2659',0.00,3630.00,710.00,4260.00,630.00,'2023-03-11 09:07:01'),(2601,'1','313',1,'Retail Sale Id 2660',0.00,768.35,710.00,901.70,133.35,'2023-03-11 09:09:33'),(2602,'1','313',1,'Retail Sale Id 2661',0.00,853.05,710.00,1001.10,148.05,'2023-03-11 09:17:01'),(2603,'1','313',1,'Retail Sale Id 2662',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-11 09:18:48'),(2604,'1','313',1,'Retail Sale Id 2663',0.00,605.00,710.00,710.00,105.00,'2023-03-11 09:19:31'),(2605,'1','313',1,'Retail Sale Id 2664',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 09:20:42'),(2606,'1','313',1,'Retail Sale Id 2665',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 09:21:20'),(2607,'1','313',1,'Retail Sale Id 2666',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 09:22:38'),(2608,'1','313',1,'Retail Sale Id 2667',0.00,99825.00,670.00,110550.00,10725.00,'2023-03-11 09:23:53'),(2609,'1','313',1,'Retail Sale Id 2669',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 09:25:15'),(2610,'1','313',1,'Retail Sale Id 2670',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-11 09:26:01'),(2611,'1','313',1,'Retail Sale Id 2671',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 09:27:10'),(2612,'1','313',1,'Retail Sale Id 2672',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 09:28:04'),(2613,'1','313',1,'Retail Sale Id 2673',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 09:29:31'),(2614,'1','313',1,'Retail Sale Id 2674',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 09:30:28'),(2615,'1','313',1,'Retail Sale Id 2675',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 09:31:18'),(2616,'1','313',1,'Retail Sale Id 2676',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 09:32:06'),(2617,'1','313',1,'Retail Sale Id 2677',0.00,605.00,710.00,710.00,105.00,'2023-03-11 09:33:12'),(2618,'1','313',1,'Retail Sale Id 2678',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 09:34:41'),(2619,'1','313',1,'Retail Sale Id 2679',0.00,598.95,710.00,702.90,103.95,'2023-03-11 09:35:27'),(2620,'1','313',1,'Retail Sale Id 2680',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-11 09:36:09'),(2621,'1','313',1,'Retail Sale Id 2681',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 09:37:56'),(2622,'1','313',1,'Retail Sale Id 2682',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-11 09:38:39'),(2623,'1','313',1,'Retail Sale Id 2683',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 09:39:40'),(2624,'1','313',1,'Retail Sale Id 2684',0.00,1276.55,710.00,1498.10,221.55,'2023-03-11 09:40:35'),(2625,'1','313',1,'Retail Sale Id 2685',0.00,8470.00,710.00,9940.00,1470.00,'2023-03-11 09:43:06'),(2626,'1','313',1,'Retail Sale Id 2686',0.00,1191.85,710.00,1398.70,206.85,'2023-03-11 09:45:04'),(2627,'1','313',1,'Retail Sale Id 2687',0.00,3630.00,710.00,4260.00,630.00,'2023-03-11 09:46:07'),(2628,'1','313',1,'Retail Sale Id 2688',0.00,1276.55,710.00,1498.10,221.55,'2023-03-11 09:47:10'),(2629,'1','313',1,'Retail Sale Id 2689',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 09:48:16'),(2630,'1','313',1,'Retail Sale Id 2690',0.00,7671.40,710.00,9002.80,1331.40,'2023-03-11 09:49:01'),(2631,'1','313',1,'Retail Sale Id 2691',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-11 09:49:38'),(2632,'1','313',1,'Retail Sale Id 2693',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 09:50:40'),(2633,'1','313',1,'Retail Sale Id 2694',0.00,2299.00,710.00,2698.00,399.00,'2023-03-11 09:52:21'),(2634,'1','313',1,'Retail Sale Id 2695',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 09:52:58'),(2635,'1','313',1,'Retail Sale Id 2696',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 09:53:32'),(2636,'1','313',1,'Retail Sale Id 2697',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-11 09:54:04'),(2637,'1','313',1,'Retail Sale Id 2698',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 09:56:36'),(2638,'1','313',1,'Retail Sale Id 2699',0.00,3406.15,710.00,3997.30,591.15,'2023-03-11 10:00:04'),(2639,'1','313',1,'Retail Sale Id 2700',0.00,605.00,710.00,710.00,105.00,'2023-03-11 10:03:16'),(2640,'1','313',1,'Retail Sale Id 2701',0.00,3630.00,710.00,4260.00,630.00,'2023-03-11 10:04:49'),(2641,'1','313',1,'Retail Sale Id 2702',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 10:07:34'),(2642,'1','313',1,'Retail Sale Id 2703',0.00,13310.00,710.00,15620.00,2310.00,'2023-03-11 10:08:25'),(2643,'1','313',1,'Retail Sale Id 2704',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 10:10:02'),(2644,'1','313',1,'Retail Sale Id 2705',0.00,3406.15,710.00,3997.30,591.15,'2023-03-11 10:11:52'),(2645,'1','313',1,'Retail Sale Id 2706',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 10:13:17'),(2646,'1','313',1,'Retail Sale Id 2707',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 10:14:12'),(2647,'1','313',1,'Retail Sale Id 2708',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 10:15:48'),(2648,'1','313',1,'Retail Sale Id 2709',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 10:16:33'),(2649,'1','313',1,'Retail Sale Id 2710',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 10:18:03'),(2650,'1','313',1,'Retail Sale Id 2711',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 10:19:26'),(2651,'1','313',1,'Retail Sale Id 2712',0.00,605.00,710.00,710.00,105.00,'2023-03-11 10:20:51'),(2652,'1','313',1,'Retail Sale Id 2713',0.00,27225.00,670.00,30150.00,2925.00,'2023-03-11 10:22:34'),(2653,'1','313',1,'Retail Sale Id 2714',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 10:23:36'),(2654,'1','313',1,'Retail Sale Id 2715',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 10:25:26'),(2655,'1','313',1,'Retail Sale Id 2716',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 10:26:24'),(2656,'1','313',1,'Retail Sale Id 2717',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 10:29:03'),(2657,'1','313',1,'Retail Sale Id 2718',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 10:30:32'),(2658,'1','313',1,'Retail Sale Id 2719',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 10:32:10'),(2659,'1','313',1,'Retail Sale Id 2720',0.00,1276.55,710.00,1498.10,221.55,'2023-03-11 10:32:53'),(2660,'1','313',1,'Retail Sale Id 2721',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 10:34:23'),(2661,'1','313',1,'Retail Sale Id 2722',0.00,7865.00,710.00,9230.00,1365.00,'2023-03-11 10:35:18'),(2662,'1','313',1,'Retail Sale Id 2723',0.00,2559.15,710.00,3003.30,444.15,'2023-03-11 10:36:25'),(2663,'1','313',1,'Retail Sale Id 2724',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 10:38:52'),(2664,'1','313',1,'Retail Sale Id 2725',0.00,5965.30,710.00,7000.60,1035.30,'2023-03-11 10:40:39'),(2665,'1','313',1,'Retail Sale Id 2726',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 10:41:38'),(2666,'1','313',1,'Retail Sale Id 2727',0.00,3630.00,710.00,4260.00,630.00,'2023-03-11 10:43:08'),(2667,'1','313',1,'Retail Sale Id 2728',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 10:44:32'),(2668,'1','313',1,'Retail Sale Id 2729',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-11 10:45:26'),(2669,'1','313',1,'Retail Sale Id 2730',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 10:46:43'),(2670,'1','313',1,'Retail Sale Id 2731',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 10:48:01'),(2671,'1','313',1,'Retail Sale Id 2732',0.00,2559.15,710.00,3003.30,444.15,'2023-03-11 10:48:49'),(2672,'1','313',1,'Retail Sale Id 2733',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 10:49:41'),(2673,'1','313',1,'Retail Sale Id 2734',0.00,1276.55,710.00,1498.10,221.55,'2023-03-11 10:50:34'),(2674,'1','313',1,'Retail Sale Id 2735',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 10:51:30'),(2675,'1','313',1,'Retail Sale Id 2736',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 10:52:41'),(2676,'1','313',1,'Retail Sale Id 2738',0.00,641.30,710.00,752.60,111.30,'2023-03-11 10:55:37'),(2677,'1','313',1,'Retail Sale Id 2739',0.00,10285.00,670.00,11390.00,1105.00,'2023-03-11 10:56:34'),(2678,'1','313',1,'Retail Sale Id 2740',0.00,5445.00,710.00,6390.00,945.00,'2023-03-11 10:57:30'),(2679,'1','313',1,'Retail Sale Id 2741',0.00,1706.10,710.00,2002.20,296.10,'2023-03-11 10:58:23'),(2680,'1','313',1,'Retail Sale Id 2742',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 10:59:07'),(2681,'1','313',1,'Retail Sale Id 2743',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 11:00:04'),(2682,'1','313',1,'Retail Sale Id 2744',0.00,641.30,710.00,752.60,111.30,'2023-03-11 11:01:24'),(2683,'1','313',1,'Retail Sale Id 2745',0.00,3406.15,710.00,3997.30,591.15,'2023-03-11 11:02:15'),(2684,'1','313',1,'Retail Sale Id 2746',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 11:02:52'),(2685,'1','313',1,'Retail Sale Id 2747',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 11:04:06'),(2686,'1','313',1,'Retail Sale Id 2748',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 11:06:26'),(2687,'1','313',1,'Retail Sale Id 2749',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 11:07:36'),(2688,'1','313',1,'Retail Sale Id 2750',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 11:09:40'),(2689,'1','313',1,'Retail Sale Id 2751',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 11:10:37'),(2690,'1','313',1,'Retail Sale Id 2752',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 11:12:50'),(2691,'1','313',1,'Retail Sale Id 2753',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 11:13:44'),(2692,'1','313',1,'Retail Sale Id 2754',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 11:14:33'),(2693,'1','313',1,'Retail Sale Id 2755',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 11:15:20'),(2694,'1','313',1,'Retail Sale Id 2756',0.00,19057.50,670.00,21105.00,2047.50,'2023-03-11 11:16:20'),(2695,'1','313',1,'Retail Sale Id 2757',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 11:17:17'),(2696,'1','313',1,'Retail Sale Id 2758',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 11:18:22'),(2697,'1','313',1,'Retail Sale Id 2759',0.00,605.00,710.00,710.00,105.00,'2023-03-11 11:19:32'),(2698,'1','313',1,'Retail Sale Id 2760',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 11:20:41'),(2699,'1','313',1,'Retail Sale Id 2762',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 11:21:35'),(2700,'1','313',1,'Retail Sale Id 2764',0.00,1706.10,710.00,2002.20,296.10,'2023-03-11 11:22:35'),(2701,'1','313',1,'Retail Sale Id 2765',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 11:23:13'),(2702,'1','313',1,'Retail Sale Id 2766',0.00,3630.00,710.00,4260.00,630.00,'2023-03-11 11:24:00'),(2703,'1','313',1,'Retail Sale Id 2767',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 11:25:16'),(2704,'1','313',1,'Retail Sale Id 2768',0.00,3932.50,710.00,4615.00,682.50,'2023-03-11 11:26:31'),(2705,'1','313',1,'Retail Sale Id 2769',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 11:27:20'),(2706,'1','313',1,'Retail Sale Id 2770',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-11 11:28:40'),(2707,'1','313',1,'Retail Sale Id 2771',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 11:30:55'),(2708,'1','313',1,'Retail Sale Id 2772',0.00,3630.00,710.00,4260.00,630.00,'2023-03-11 11:32:12'),(2709,'1','313',1,'Retail Sale Id 2773',0.00,605.00,710.00,710.00,105.00,'2023-03-11 11:33:10'),(2710,'1','313',1,'Retail Sale Id 2774',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 11:34:16'),(2711,'1','313',1,'Retail Sale Id 2775',0.00,605.00,710.00,710.00,105.00,'2023-03-11 11:36:00'),(2712,'1','313',1,'Retail Sale Id 2776',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 11:37:07'),(2713,'1','313',1,'Retail Sale Id 2777',0.00,90750.00,670.00,100500.00,9750.00,'2023-03-11 11:40:26'),(2714,'1','313',1,'Retail Sale Id 2778',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 11:41:51'),(2715,'1','313',1,'Retail Sale Id 2780',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 11:45:03'),(2716,'1','313',1,'Retail Sale Id 2781',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 11:46:39'),(2717,'1','313',1,'Retail Sale Id 2782',0.00,8470.00,710.00,9940.00,1470.00,'2023-03-11 11:48:13'),(2718,'1','313',1,'Retail Sale Id 2783',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 11:50:04'),(2719,'1','313',1,'Retail Sale Id 2784',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-11 11:51:43'),(2720,'1','313',1,'Retail Sale Id 2785',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 11:52:35'),(2721,'1','313',1,'Retail Sale Id 2786',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 11:53:58'),(2722,'1','313',1,'Retail Sale Id 2787',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 11:55:20'),(2723,'1','313',1,'Retail Sale Id 2788',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 11:56:17'),(2724,'1','313',1,'Retail Sale Id 2789',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 11:57:21'),(2725,'1','313',1,'Retail Sale Id 2790',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-11 11:58:06'),(2726,'1','313',1,'Retail Sale Id 2791',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 11:58:45'),(2727,'1','313',1,'Retail Sale Id 2792',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 11:59:46'),(2728,'1','313',1,'Retail Sale Id 2793',0.00,605.00,710.00,710.00,105.00,'2023-03-11 12:01:14'),(2729,'1','313',1,'Retail Sale Id 2794',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 12:10:05'),(2730,'1','313',1,'Retail Sale Id 2795',0.00,3630.00,710.00,4260.00,630.00,'2023-03-11 12:11:52'),(2731,'1','313',1,'Retail Sale Id 2796',0.00,3630.00,710.00,4260.00,630.00,'2023-03-11 12:13:01'),(2732,'1','313',1,'Retail Sale Id 2797',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 12:14:43'),(2733,'1','313',1,'Retail Sale Id 2798',0.00,13612.50,710.00,15975.00,2362.50,'2023-03-11 12:24:01'),(2734,'1','313',1,'Retail Sale Id 2799',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 12:25:43'),(2735,'1','313',1,'Retail Sale Id 2800',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 12:27:07'),(2736,'1','313',1,'Retail Sale Id 2801',0.00,3630.00,710.00,4260.00,630.00,'2023-03-11 12:29:28'),(2737,'1','313',1,'Retail Sale Id 2802',0.00,853.05,710.00,1001.10,148.05,'2023-03-11 12:31:00'),(2738,'1','313',1,'Retail Sale Id 2804',0.00,2559.15,710.00,3003.30,444.15,'2023-03-11 12:34:01'),(2739,'1','313',1,'Retail Sale Id 2805',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-11 12:35:26'),(2740,'1','313',1,'Retail Sale Id 2806',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-11 12:37:56'),(2741,'1','313',1,'Retail Sale Id 2807',0.00,7865.00,710.00,9230.00,1365.00,'2023-03-11 12:38:33'),(2742,'1','313',1,'Retail Sale Id 2808',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 12:39:40'),(2743,'1','313',1,'Retail Sale Id 2809',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-11 12:40:58'),(2744,'1','313',1,'Retail Sale Id 2810',0.00,35695.00,670.00,39530.00,3835.00,'2023-03-11 12:43:32'),(2745,'1','313',1,'Retail Sale Id 2811',0.00,3630.00,710.00,4260.00,630.00,'2023-03-11 12:45:23'),(2746,'1','313',1,'Retail Sale Id 2812',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 12:46:26'),(2747,'1','313',1,'Retail Sale Id 2813',0.00,2129.60,710.00,2499.20,369.60,'2023-03-11 12:48:36'),(2748,'1','313',1,'Return of Retail Sale Id 2813',2129.60,0.00,710.00,-2499.20,-369.60,'2023-03-11 12:48:46'),(2749,'1','313',1,'Retail Sale Id 2814',0.00,27055.60,670.00,29962.40,2906.80,'2023-03-11 12:51:12'),(2750,'1','313',1,'Retail Sale Id 2815',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 12:52:23'),(2751,'1','313',1,'Retail Sale Id 2816',0.00,35713.15,670.00,39550.10,3836.95,'2023-03-11 12:55:14'),(2752,'1','313',1,'Retail Sale Id 2817',0.00,3630.00,710.00,4260.00,630.00,'2023-03-11 12:56:44'),(2753,'1','313',1,'Retail Sale Id 2818',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 12:57:34'),(2754,'1','313',1,'Retail Sale Id 2819',0.00,3630.00,710.00,4260.00,630.00,'2023-03-11 12:58:42'),(2755,'1','313',1,'Retail Sale Id 2820',0.00,1706.10,710.00,2002.20,296.10,'2023-03-11 12:59:47'),(2756,'1','313',1,'Retail Sale Id 2822',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 13:01:37'),(2757,'1','313',1,'Retail Sale Id 2823',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 13:02:35'),(2758,'1','313',1,'Retail Sale Id 2824',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 13:03:37'),(2759,'1','313',1,'Retail Sale Id 2825',0.00,1706.10,710.00,2002.20,296.10,'2023-03-11 13:04:21'),(2760,'1','313',1,'Retail Sale Id 2826',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 13:05:33'),(2761,'1','313',1,'Retail Sale Id 2827',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 13:06:48'),(2762,'1','313',1,'Retail Sale Id 2828',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-11 13:08:39'),(2763,'1','313',1,'Retail Sale Id 2829',0.00,3630.00,710.00,4260.00,630.00,'2023-03-11 13:10:07'),(2764,'1','313',1,'Retail Sale Id 2830',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-11 13:11:57'),(2765,'1','313',1,'Retail Sale Id 2831',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 13:13:02'),(2766,'1','313',1,'Retail Sale Id 2832',0.00,3630.00,710.00,4260.00,630.00,'2023-03-11 13:14:13'),(2767,'1','313',1,'Retail Sale Id 2833',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 13:15:18'),(2768,'1','313',1,'Retail Sale Id 2834',0.00,3932.50,710.00,4615.00,682.50,'2023-03-11 13:16:21'),(2769,'1','313',1,'Retail Sale Id 2835',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 13:17:31'),(2770,'1','313',1,'Retail Sale Id 2836',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-11 13:18:40'),(2771,'1','313',1,'Retail Sale Id 2837',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 13:19:46'),(2772,'1','313',1,'Retail Sale Id 2838',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 13:20:51'),(2773,'1','313',1,'Retail Sale Id 2839',0.00,605.00,710.00,710.00,105.00,'2023-03-11 13:23:14'),(2774,'1','313',1,'Retail Sale Id 2840',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 13:26:33'),(2775,'1','313',1,'Retail Sale Id 2841',0.00,71390.00,670.00,79060.00,7670.00,'2023-03-11 13:29:35'),(2776,'1','313',1,'Retail Sale Id 2842',0.00,605.00,710.00,710.00,105.00,'2023-03-11 13:30:32'),(2777,'1','313',1,'Retail Sale Id 2843',0.00,4840.00,710.00,5680.00,840.00,'2023-03-11 13:31:37'),(2778,'1','313',1,'Retail Sale Id 2844',0.00,90750.00,670.00,100500.00,9750.00,'2023-03-11 13:34:12'),(2779,'1','313',1,'Retail Sale Id 2845',0.00,853.05,710.00,1001.10,148.05,'2023-03-11 13:35:12'),(2780,'1','313',1,'Retail Sale Id 2846',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 13:36:27'),(2781,'1','313',1,'Retail Sale Id 2847',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 13:38:13'),(2782,'1','313',1,'Retail Sale Id 2848',0.00,3630.00,710.00,4260.00,630.00,'2023-03-11 13:39:51'),(2783,'1','313',1,'Retail Sale Id 2849',0.00,2559.15,710.00,3003.30,444.15,'2023-03-11 13:40:45'),(2784,'1','313',1,'Retail Sale Id 2850',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 13:43:56'),(2785,'1','313',1,'Retail Sale Id 2851',0.00,853.05,710.00,1001.10,148.05,'2023-03-11 13:44:57'),(2786,'1','313',1,'Retail Sale Id 2852',0.00,4259.20,710.00,4998.40,739.20,'2023-03-11 13:47:07'),(2787,'1','313',1,'Return of Retail Sale Id 2843',4840.00,0.00,710.00,-5680.00,-840.00,'2023-03-11 13:47:44'),(2788,'1','313',1,'Retail Sale Id 2853',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 13:48:23'),(2789,'1','313',1,'Retail Sale Id 2854',0.00,605.00,710.00,710.00,105.00,'2023-03-11 13:49:23'),(2790,'1','313',1,'Retail Sale Id 2855',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 13:52:04'),(2791,'1','313',1,'Retail Sale Id 2856',0.00,3630.00,710.00,4260.00,630.00,'2023-03-11 13:54:23'),(2792,'1','313',1,'Retail Sale Id 2857',0.00,1621.40,710.00,1902.80,281.40,'2023-03-11 14:02:12'),(2793,'1','313',1,'Retail Sale Id 2858',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 14:04:37'),(2794,'1','313',1,'Retail Sale Id 2859',0.00,35906.75,670.00,39764.50,3857.75,'2023-03-11 14:06:52'),(2795,'1','313',1,'Return of Retail Sale Id 2627',36300.00,0.00,670.00,-40200.00,-3900.00,'2023-03-11 14:08:11'),(2796,'1','313',1,'Retail Sale Id 2860',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 14:09:36'),(2797,'1','313',1,'Retail Sale Id 2861',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 14:11:34'),(2798,'1','313',1,'Retail Sale Id 2862',0.00,4840.00,710.00,5680.00,840.00,'2023-03-11 14:14:06'),(2799,'1','313',1,'Retail Sale Id 2863',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 14:15:18'),(2800,'1','313',1,'Retail Sale Id 2864',0.00,60500.00,670.00,67000.00,6500.00,'2023-03-11 14:17:16'),(2801,'1','313',1,'Retail Sale Id 2865',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-11 14:18:36'),(2802,'1','313',1,'Retail Sale Id 2866',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 14:22:27'),(2803,'1','313',1,'Retail Sale Id 2867',0.00,605.00,710.00,710.00,105.00,'2023-03-11 14:24:05'),(2804,'1','313',1,'Retail Sale Id 2868',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 14:25:33'),(2805,'1','313',1,'Retail Sale Id 2869',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 14:35:34'),(2806,'1','313',1,'Retail Sale Id 2870',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 14:36:15'),(2807,'1','313',1,'Retail Sale Id 2871',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-11 14:37:23'),(2808,'1','313',1,'Retail Sale Id 2872',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 14:38:15'),(2809,'1','313',1,'Retail Sale Id 2873',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 14:39:01'),(2810,'1','313',1,'Retail Sale Id 2874',0.00,605.00,710.00,710.00,105.00,'2023-03-11 14:40:22'),(2811,'1','313',1,'Retail Sale Id 2875',0.00,72600.00,670.00,80400.00,7800.00,'2023-03-11 14:43:22'),(2812,'1','313',1,'Retail Sale Id 2876',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 14:44:38'),(2813,'1','313',1,'Retail Sale Id 2877',0.00,4840.00,710.00,5680.00,840.00,'2023-03-11 14:45:25'),(2814,'1','313',1,'Retail Sale Id 2878',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 14:46:57'),(2815,'1','313',1,'Retail Sale Id 2879',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 14:49:22'),(2816,'1','313',1,'Retail Sale Id 2880',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-11 14:51:41'),(2817,'1','313',1,'Retail Sale Id 2881',0.00,605.00,710.00,710.00,105.00,'2023-03-11 14:52:39'),(2818,'1','313',1,'Retail Sale Id 2882',0.00,2559.15,710.00,3003.30,444.15,'2023-03-11 14:55:26'),(2819,'1','313',1,'Retail Sale Id 2883',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 14:56:44'),(2820,'1','313',1,'Retail Sale Id 2884',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 14:58:15'),(2821,'1','313',1,'Retail Sale Id 2885',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 15:30:49'),(2822,'1','313',1,'Retail Sale Id 2886',0.00,36009.60,670.00,39878.40,3868.80,'2023-03-11 15:34:31'),(2823,'1','313',1,'Retail Sale Id 2887',0.00,605.00,710.00,710.00,105.00,'2023-03-11 15:35:30'),(2824,'1','313',1,'Return of Retail Sale Id 2880',36300.00,0.00,670.00,-40200.00,-3900.00,'2023-03-11 15:36:29'),(2825,'1','313',1,'Retail Sale Id 2888',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 15:37:24'),(2826,'1','313',1,'Retail Sale Id 2889',0.00,1234.20,710.00,1448.40,214.20,'2023-03-11 15:38:27'),(2827,'1','313',1,'Retail Sale Id 2890',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-11 15:39:06'),(2828,'1','313',1,'Retail Sale Id 2891',0.00,605.00,710.00,710.00,105.00,'2023-03-11 15:39:39'),(2829,'1','313',1,'Retail Sale Id 2892',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 15:40:54'),(2830,'1','313',1,'Retail Sale Id 2893',0.00,6388.80,710.00,7497.60,1108.80,'2023-03-11 15:41:42'),(2831,'1','313',1,'Retail Sale Id 2894',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 15:43:35'),(2832,'1','313',1,'Retail Sale Id 2895',0.00,605.00,710.00,710.00,105.00,'2023-03-11 15:44:41'),(2833,'1','313',1,'Retail Sale Id 2896',0.00,605.00,710.00,710.00,105.00,'2023-03-11 15:46:08'),(2834,'1','313',1,'Retail Sale Id 2897',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 15:52:35'),(2835,'1','313',1,'Retail Sale Id 2898',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 15:53:31'),(2836,'1','313',1,'Retail Sale Id 2899',0.00,853.05,710.00,1001.10,148.05,'2023-03-11 15:54:52'),(2837,'1','313',1,'Retail Sale Id 2900',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-11 15:56:29'),(2838,'1','313',1,'Retail Sale Id 2901',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-11 15:56:58'),(2839,'1','313',1,'Retail Sale Id 2902',0.00,3630.00,710.00,4260.00,630.00,'2023-03-11 16:00:13'),(2840,'1','313',1,'Retail Sale Id 2903',0.00,1790.80,710.00,2101.60,310.80,'2023-03-11 16:01:38'),(2841,'1','313',1,'Retail Sale Id 2904',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 16:02:48'),(2842,'1','313',1,'Retail Sale Id 2905',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 16:03:36'),(2843,'1','313',1,'Retail Sale Id 2906',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 16:05:21'),(2844,'1','313',1,'Retail Sale Id 2907',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 16:08:34'),(2845,'1','313',1,'Retail Sale Id 2908',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-11 16:09:23'),(2846,'1','313',1,'Retail Sale Id 2909',0.00,24200.00,670.00,26800.00,2600.00,'2023-03-11 16:11:36'),(2847,'1','313',1,'Retail Sale Id 2910',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-11 16:12:24'),(2848,'1','313',1,'Retail Sale Id 2911',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 16:17:11'),(2849,'1','313',1,'Retail Sale Id 2912',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 16:18:16'),(2850,'1','313',1,'Retail Sale Id 2913',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 16:20:20'),(2851,'1','313',1,'Retail Sale Id 2914',0.00,2420.00,670.00,2680.00,260.00,'2023-03-11 16:21:57'),(2852,'1','313',1,'Retail Sale Id 2915',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 16:23:31'),(2853,'1','313',1,'Retail Sale Id 2916',0.00,2982.65,710.00,3500.30,517.65,'2023-03-11 16:25:01'),(2854,'1','313',1,'Retail Sale Id 2917',0.00,1706.10,710.00,2002.20,296.10,'2023-03-11 16:26:14'),(2855,'1','313',1,'Retail Sale Id 2918',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 16:27:39'),(2856,'1','313',1,'Retail Sale Id 2919',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 16:28:56'),(2857,'1','313',1,'Retail Sale Id 2920',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-11 16:29:49'),(2858,'1','313',1,'Retail Sale Id 2921',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 16:30:42'),(2859,'1','313',1,'Retail Sale Id 2922',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 16:33:30'),(2860,'1','313',1,'Retail Sale Id 2923',0.00,1706.10,710.00,2002.20,296.10,'2023-03-11 16:35:17'),(2861,'1','313',1,'Retail Sale Id 2924',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-11 16:36:15'),(2862,'1','313',1,'Retail Sale Id 2925',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 16:37:15'),(2863,'1','313',1,'Retail Sale Id 2926',0.00,36608.55,670.00,40541.70,3933.15,'2023-03-11 16:38:04'),(2864,'1','313',1,'Retail Sale Id 2927',0.00,72600.00,670.00,80400.00,7800.00,'2023-03-11 16:39:05'),(2865,'1','313',1,'Retail Sale Id 2928',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-11 16:40:07'),(2866,'1','313',1,'Retail Sale Id 2929',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 16:40:41'),(2867,'1','313',1,'Retail Sale Id 2930',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-11 16:41:21'),(2868,'1','313',1,'Retail Sale Id 2931',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 16:42:27'),(2869,'1','313',1,'Retail Sale Id 2932',0.00,4235.00,710.00,4970.00,735.00,'2023-03-11 16:43:49'),(2870,'1','313',1,'Retail Sale Id 2933',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-11 16:45:28'),(2871,'1','313',1,'Retail Sale Id 2934',0.00,605.00,710.00,710.00,105.00,'2023-03-11 16:45:57'),(2872,'1','313',1,'Retail Sale Id 2935',0.00,37510.00,670.00,41540.00,4030.00,'2023-03-11 16:46:39'),(2873,'1','313',1,'Retail Sale Id 2936',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 16:47:32'),(2874,'1','313',1,'Retail Sale Id 2937',0.00,1706.10,710.00,2002.20,296.10,'2023-03-11 16:48:19'),(2875,'1','313',1,'Retail Sale Id 2938',0.00,1276.55,710.00,1498.10,221.55,'2023-03-11 16:49:51'),(2876,'1','313',1,'Retail Sale Id 2939',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 16:51:52'),(2877,'1','313',1,'Retail Sale Id 2940',0.00,3025.00,710.00,3550.00,525.00,'2023-03-11 16:52:25'),(2878,'1','313',1,'Retail Sale Id 2941',0.00,1234.20,710.00,1448.40,214.20,'2023-03-11 16:53:36'),(2879,'1','313',1,'Retail Sale Id 2942',0.00,605.00,710.00,710.00,105.00,'2023-03-11 16:54:41'),(2880,'1','313',1,'Retail Sale Id 2943',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 16:55:30'),(2881,'1','313',1,'Retail Sale Id 2944',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 16:56:04'),(2882,'1','313',1,'Retail Sale Id 2945',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 16:57:04'),(2883,'1','313',1,'Retail Sale Id 2946',0.00,853.05,710.00,1001.10,148.05,'2023-03-11 16:57:46'),(2884,'1','313',1,'Retail Sale Id 2947',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 16:58:12'),(2885,'1','313',1,'Retail Sale Id 2948',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 16:58:44'),(2886,'1','313',1,'Retail Sale Id 2949',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 16:59:24'),(2887,'1','313',1,'Retail Sale Id 2950',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 17:00:38'),(2888,'1','313',1,'Retail Sale Id 2951',0.00,605.00,710.00,710.00,105.00,'2023-03-11 17:01:12'),(2889,'1','313',1,'Retail Sale Id 2952',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 17:04:09'),(2890,'1','313',1,'Retail Sale Id 2953',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 17:07:44'),(2891,'1','313',1,'Retail Sale Id 2954',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-11 17:14:40'),(2892,'1','313',1,'Retail Sale Id 2955',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 17:15:13'),(2893,'1','313',1,'Retail Sale Id 2956',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 17:16:14'),(2894,'1','313',1,'Retail Sale Id 2957',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 17:17:16'),(2895,'1','313',1,'Retail Sale Id 2958',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-11 17:18:20'),(2896,'1','313',1,'Retail Sale Id 2959',0.00,605.00,710.00,710.00,105.00,'2023-03-11 17:20:54'),(2897,'1','313',1,'Retail Sale Id 2960',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 17:21:43'),(2898,'1','313',1,'Retail Sale Id 2961',0.00,1815.00,710.00,2130.00,315.00,'2023-03-11 17:23:23'),(2899,'1','313',1,'Retail Sale Id 2962',0.00,605.00,710.00,710.00,105.00,'2023-03-11 17:27:56'),(2900,'1','313',1,'Retail Sale Id 2963',0.00,605.00,710.00,710.00,105.00,'2023-03-11 17:32:19'),(2901,'1','313',1,'Retail Sale Id 2964',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 17:33:24'),(2902,'1','313',1,'Retail Sale Id 2965',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 17:35:04'),(2903,'1','313',1,'Retail Sale Id 2966',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 17:37:25'),(2904,'1','313',1,'Retail Sale Id 2967',0.00,598.95,710.00,702.90,103.95,'2023-03-11 17:38:43'),(2905,'1','313',1,'Retail Sale Id 2968',0.00,1210.00,710.00,1420.00,210.00,'2023-03-11 17:41:59'),(2906,'1','313',1,'Retail Sale Id 2969',0.00,605.00,710.00,710.00,105.00,'2023-03-11 17:42:42'),(2907,'1','313',1,'Retail Sale Id 2970',0.00,2420.00,710.00,2840.00,420.00,'2023-03-11 17:46:45'),(2908,'1','313',1,'Retail Sale Id 2972',0.00,3630.00,710.00,4260.00,630.00,'2023-03-11 17:50:25'),(2909,'1','313',1,'Return of Retail Sale Id 2953',2420.00,0.00,710.00,-2840.00,-420.00,'2023-03-11 18:07:23'),(2910,'1','313',1,'Retail Sale Id 2973',0.00,1687.95,710.00,1980.90,292.95,'2023-03-11 18:08:04'),(2911,'1','313',1,'Return of Retail Sale Id 2756',19057.50,0.00,670.00,-21105.00,-2047.50,'2023-03-11 18:10:25'),(2912,'1','313',1,'Retail Sale Id 2974',0.00,19202.70,670.00,21265.80,2063.10,'2023-03-11 18:11:12'),(2913,'1','313',1,'Return of Retail Sale Id 2713',27225.00,0.00,670.00,-30150.00,-2925.00,'2023-03-11 18:15:20'),(2914,'1','313',1,'Retail Sale Id 2975',0.00,26934.60,670.00,29828.40,2893.80,'2023-03-11 18:16:06'),(2915,'1','313',1,'Retail Sale Id 2976',0.00,1706.10,710.00,2002.20,296.10,'2023-03-12 10:29:34'),(2916,'1','313',1,'Retail Sale Id 2977',0.00,3025.00,710.00,3550.00,525.00,'2023-03-12 10:30:33'),(2917,'1','313',1,'Retail Sale Id 2978',0.00,605.00,710.00,710.00,105.00,'2023-03-12 10:31:59'),(2918,'1','313',1,'Retail Sale Id 2979',0.00,1276.55,710.00,1498.10,221.55,'2023-03-12 10:32:37'),(2919,'1','313',1,'Retail Sale Id 2980',0.00,1815.00,710.00,2130.00,315.00,'2023-03-12 10:35:50'),(2920,'1','313',1,'Retail Sale Id 2981',0.00,3025.00,710.00,3550.00,525.00,'2023-03-12 10:36:58'),(2921,'1','313',1,'Retail Sale Id 2982',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 10:39:48'),(2922,'1','313',1,'Retail Sale Id 2984',0.00,641.30,710.00,752.60,111.30,'2023-03-12 10:42:11'),(2923,'1','313',1,'Retail Sale Id 2985',0.00,1815.00,710.00,2130.00,315.00,'2023-03-12 10:43:26'),(2924,'1','313',1,'Retail Sale Id 2986',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-12 10:46:21'),(2925,'1','313',1,'Retail Sale Id 2987',0.00,27225.00,670.00,30150.00,2925.00,'2023-03-12 10:49:38'),(2926,'1','313',1,'Retail Sale Id 2988',0.00,605.00,710.00,710.00,105.00,'2023-03-12 10:50:31'),(2927,'1','313',1,'Retail Sale Id 2989',0.00,683.65,710.00,802.30,118.65,'2023-03-12 10:51:46'),(2928,'1','313',1,'Retail Sale Id 2990',0.00,26650.25,670.00,29513.50,2863.25,'2023-03-12 10:58:04'),(2929,'1','313',1,'Return of Retail Sale Id 2987',27225.00,0.00,670.00,-30150.00,-2925.00,'2023-03-12 10:58:46'),(2930,'1','313',1,'Retail Sale Id 2991',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 11:01:50'),(2931,'1','313',1,'Retail Sale Id 2992',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-12 11:03:13'),(2932,'1','313',1,'Retail Sale Id 2993',0.00,605.00,710.00,710.00,105.00,'2023-03-12 11:04:22'),(2933,'1','313',1,'Retail Sale Id 2994',0.00,853.05,710.00,1001.10,148.05,'2023-03-12 11:05:32'),(2934,'1','313',1,'Retail Sale Id 2995',0.00,2420.00,710.00,2840.00,420.00,'2023-03-12 11:07:48'),(2935,'1','313',1,'Retail Sale Id 2996',0.00,1815.00,710.00,2130.00,315.00,'2023-03-12 11:10:26'),(2936,'1','313',1,'Retail Sale Id 2998',0.00,2559.15,710.00,3003.30,444.15,'2023-03-12 11:13:08'),(2937,'1','313',1,'Retail Sale Id 2999',0.00,2129.60,710.00,2499.20,369.60,'2023-03-12 11:14:02'),(2938,'1','313',1,'Retail Sale Id 3000',0.00,1815.00,710.00,2130.00,315.00,'2023-03-12 11:15:22'),(2939,'1','313',1,'Retail Sale Id 3001',0.00,3025.00,710.00,3550.00,525.00,'2023-03-12 11:16:38'),(2940,'1','313',1,'Retail Sale Id 3002',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 11:19:53'),(2941,'1','313',1,'Retail Sale Id 3003',0.00,853.05,710.00,1001.10,148.05,'2023-03-12 11:20:29'),(2942,'1','313',1,'Retail Sale Id 3004',0.00,2420.00,710.00,2840.00,420.00,'2023-03-12 11:23:41'),(2943,'1','313',1,'Retail Sale Id 3005',0.00,28894.80,670.00,31999.20,3104.40,'2023-03-12 11:29:39'),(2944,'1','313',1,'Retail Sale Id 3006',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-12 11:31:34'),(2945,'1','313',1,'Retail Sale Id 3008',0.00,1815.00,710.00,2130.00,315.00,'2023-03-12 11:39:36'),(2946,'1','313',1,'Retail Sale Id 3009',0.00,5965.30,710.00,7000.60,1035.30,'2023-03-12 11:48:45'),(2947,'1','313',1,'Retail Sale Id 3010',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-12 11:51:02'),(2948,'1','313',1,'Retail Sale Id 3011',0.00,1234.20,710.00,1448.40,214.20,'2023-03-12 11:53:20'),(2949,'1','313',1,'Retail Sale Id 3012',0.00,3025.00,710.00,3550.00,525.00,'2023-03-12 11:59:55'),(2950,'1','313',1,'Retail Sale Id 3013',0.00,4235.00,710.00,4970.00,735.00,'2023-03-12 12:03:33'),(2951,'1','313',1,'Retail Sale Id 3014',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 12:04:17'),(2952,'1','313',1,'Retail Sale Id 3015',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-12 12:05:53'),(2953,'1','313',1,'Retail Sale Id 3016',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-12 12:08:51'),(2954,'1','313',1,'Retail Sale Id 3017',0.00,78650.00,670.00,87100.00,8450.00,'2023-03-12 12:09:50'),(2955,'1','313',1,'Retail Sale Id 3018',0.00,3630.00,710.00,4260.00,630.00,'2023-03-12 12:10:58'),(2956,'1','313',1,'Retail Sale Id 3019',0.00,1815.00,710.00,2130.00,315.00,'2023-03-12 12:12:06'),(2957,'1','313',1,'Retail Sale Id 3020',0.00,853.05,710.00,1001.10,148.05,'2023-03-12 12:19:10'),(2958,'1','313',1,'Retail Sale Id 3021',0.00,605.00,710.00,710.00,105.00,'2023-03-12 12:23:25'),(2959,'1','313',1,'Retail Sale Id 3022',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-12 12:24:35'),(2960,'1','313',1,'Retail Sale Id 3023',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-12 12:26:37'),(2961,'1','313',1,'Retail Sale Id 3024',0.00,1815.00,710.00,2130.00,315.00,'2023-03-12 12:28:44'),(2962,'1','313',1,'Retail Sale Id 3025',0.00,2129.60,710.00,2499.20,369.60,'2023-03-12 12:30:06'),(2963,'1','313',1,'Retail Sale Id 3026',0.00,3025.00,710.00,3550.00,525.00,'2023-03-12 12:32:41'),(2964,'1','313',1,'Retail Sale Id 3027',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 12:34:01'),(2965,'1','313',1,'Retail Sale Id 3028',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-12 12:36:30'),(2966,'1','313',1,'Retail Sale Id 3029',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 12:37:54'),(2967,'1','313',1,'Retail Sale Id 3030',0.00,2559.15,710.00,3003.30,444.15,'2023-03-12 12:39:44'),(2968,'1','313',1,'Retail Sale Id 3031',0.00,4235.00,710.00,4970.00,735.00,'2023-03-12 12:44:23'),(2969,'1','313',1,'Retail Sale Id 3032',0.00,605.00,710.00,710.00,105.00,'2023-03-12 12:45:00'),(2970,'1','313',1,'Retail Sale Id 3033',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-12 12:56:52'),(2971,'1','313',1,'Retail Sale Id 3034',0.00,3025.00,710.00,3550.00,525.00,'2023-03-12 12:59:55'),(2972,'1','313',1,'Retail Sale Id 3035',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-12 13:01:46'),(2973,'1','313',1,'Retail Sale Id 3036',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-12 13:04:37'),(2974,'1','313',1,'Retail Sale Id 3037',0.00,4259.20,710.00,4998.40,739.20,'2023-03-12 13:15:37'),(2975,'1','313',1,'Retail Sale Id 3038',0.00,1815.00,710.00,2130.00,315.00,'2023-03-12 13:17:53'),(2976,'1','313',1,'Retail Sale Id 3039',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 13:32:31'),(2977,'1','313',1,'Retail Sale Id 3040',0.00,641.30,710.00,752.60,111.30,'2023-03-12 13:34:32'),(2978,'1','313',1,'Retail Sale Id 3041',0.00,1815.00,710.00,2130.00,315.00,'2023-03-12 13:35:21'),(2979,'1','313',1,'Retail Sale Id 3042',0.00,2420.00,710.00,2840.00,420.00,'2023-03-12 13:36:39'),(2980,'1','313',1,'Retail Sale Id 3043',0.00,3630.00,710.00,4260.00,630.00,'2023-03-12 13:44:56'),(2981,'1','313',1,'Retail Sale Id 3044',0.00,4235.00,710.00,4970.00,735.00,'2023-03-12 13:47:23'),(2982,'1','313',1,'Retail Sale Id 3045',0.00,1107.15,710.00,1299.30,192.15,'2023-03-12 13:49:10'),(2983,'1','313',1,'Retail Sale Id 3046',0.00,2420.00,710.00,2840.00,420.00,'2023-03-12 13:55:51'),(2984,'1','313',1,'Retail Sale Id 3047',0.00,8470.00,710.00,9940.00,1470.00,'2023-03-12 14:01:05'),(2985,'1','313',1,'Retail Sale Id 3048',0.00,4235.00,710.00,4970.00,735.00,'2023-03-12 14:06:56'),(2986,'1','313',1,'Retail Sale Id 3049',0.00,641.30,710.00,752.60,111.30,'2023-03-12 14:09:14'),(2987,'1','313',1,'Retail Sale Id 3050',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 14:13:57'),(2988,'1','313',1,'Retail Sale Id 3051',0.00,1815.00,710.00,2130.00,315.00,'2023-03-12 14:15:13'),(2989,'1','313',1,'Retail Sale Id 3052',0.00,4235.00,710.00,4970.00,735.00,'2023-03-12 14:16:54'),(2990,'1','313',1,'Retail Sale Id 3053',0.00,853.05,710.00,1001.10,148.05,'2023-03-12 14:22:53'),(2991,'1','313',1,'Retail Sale Id 3054',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 14:25:41'),(2992,'1','313',1,'Retail Sale Id 3055',0.00,1815.00,710.00,2130.00,315.00,'2023-03-12 14:26:38'),(2993,'1','313',1,'Retail Sale Id 3056',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 14:28:25'),(2994,'1','313',1,'Retail Sale Id 3057',0.00,3025.00,710.00,3550.00,525.00,'2023-03-12 14:32:32'),(2995,'1','313',1,'Retail Sale Id 3058',0.00,1276.55,710.00,1498.10,221.55,'2023-03-12 14:33:15'),(2996,'1','313',1,'Retail Sale Id 3059',0.00,3630.00,710.00,4260.00,630.00,'2023-03-12 14:34:33'),(2997,'1','313',1,'Retail Sale Id 3060',0.00,2129.60,710.00,2499.20,369.60,'2023-03-12 14:36:49'),(2998,'1','313',1,'Retail Sale Id 3061',0.00,9075.00,670.00,10050.00,975.00,'2023-03-12 14:39:03'),(2999,'1','313',1,'Return of Retail Sale Id 3061',9075.00,0.00,670.00,-10050.00,-975.00,'2023-03-12 14:39:35'),(3000,'1','313',1,'Retail Sale Id 3062',0.00,8167.50,670.00,9045.00,877.50,'2023-03-12 14:40:47'),(3001,'1','313',1,'Retail Sale Id 3063',0.00,1706.10,710.00,2002.20,296.10,'2023-03-12 14:49:44'),(3002,'1','313',1,'Retail Sale Id 3064',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 14:50:54'),(3003,'1','313',1,'Retail Sale Id 3065',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 14:55:48'),(3004,'1','313',1,'Retail Sale Id 3066',0.00,605.00,710.00,710.00,105.00,'2023-03-12 14:58:29'),(3005,'1','313',1,'Retail Sale Id 3068',0.00,605.00,710.00,710.00,105.00,'2023-03-12 15:02:23'),(3006,'1','313',1,'Retail Sale Id 3069',0.00,2420.00,710.00,2840.00,420.00,'2023-03-12 15:04:56'),(3007,'1','313',1,'Retail Sale Id 3070',0.00,12100.00,710.00,14200.00,2100.00,'2023-03-12 15:06:20'),(3008,'1','313',1,'Retail Sale Id 3071',0.00,641.30,710.00,752.60,111.30,'2023-03-12 15:07:29'),(3009,'1','313',1,'Retail Sale Id 3072',0.00,605.00,710.00,710.00,105.00,'2023-03-12 15:08:17'),(3010,'1','313',1,'Retail Sale Id 3073',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 15:09:13'),(3011,'1','313',1,'Retail Sale Id 3074',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-12 15:10:32'),(3012,'1','313',1,'Retail Sale Id 3075',0.00,2129.60,710.00,2499.20,369.60,'2023-03-12 15:13:07'),(3013,'1','313',1,'Retail Sale Id 3076',0.00,605.00,710.00,710.00,105.00,'2023-03-12 15:15:05'),(3014,'1','313',1,'Retail Sale Id 3077',0.00,605.00,710.00,710.00,105.00,'2023-03-12 15:16:11'),(3015,'1','313',1,'Retail Sale Id 3078',0.00,4235.00,710.00,4970.00,735.00,'2023-03-12 15:17:53'),(3016,'1','313',1,'Retail Sale Id 3079',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 15:20:00'),(3017,'1','313',1,'Retail Sale Id 3080',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-12 15:23:41'),(3018,'1','313',1,'Retail Sale Id 3081',0.00,1815.00,710.00,2130.00,315.00,'2023-03-12 15:25:11'),(3019,'1','313',1,'Retail Sale Id 3082',0.00,853.05,710.00,1001.10,148.05,'2023-03-12 15:27:31'),(3020,'1','313',1,'Retail Sale Id 3083',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 15:32:24'),(3021,'1','313',1,'Retail Sale Id 3084',0.00,641.30,710.00,752.60,111.30,'2023-03-12 15:38:12'),(3022,'1','313',1,'Retail Sale Id 3085',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 15:39:29'),(3023,'1','313',1,'Retail Sale Id 3086',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 15:44:31'),(3024,'1','313',1,'Retail Sale Id 3087',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-12 15:46:13'),(3025,'1','313',1,'Retail Sale Id 3089',0.00,3835.70,710.00,4501.40,665.70,'2023-03-12 15:47:57'),(3026,'1','313',1,'Retail Sale Id 3090',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 15:48:53'),(3027,'1','313',1,'Retail Sale Id 3091',0.00,4235.00,710.00,4970.00,735.00,'2023-03-12 15:50:12'),(3028,'1','313',1,'Retail Sale Id 3092',0.00,641.30,710.00,752.60,111.30,'2023-03-12 15:52:11'),(3029,'1','313',1,'Retail Sale Id 3093',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 15:55:59'),(3030,'1','313',1,'Retail Sale Id 3094',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 16:04:31'),(3031,'1','313',1,'Retail Sale Id 3095',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 16:13:23'),(3032,'1','313',1,'Retail Sale Id 3096',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 16:14:18'),(3033,'1','313',1,'Retail Sale Id 3097',0.00,605.00,710.00,710.00,105.00,'2023-03-12 16:15:39'),(3034,'1','313',1,'Retail Sale Id 3098',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 16:17:26'),(3035,'1','313',1,'Retail Sale Id 3099',0.00,1815.00,710.00,2130.00,315.00,'2023-03-12 16:20:14'),(3036,'1','313',1,'Retail Sale Id 3100',0.00,853.05,710.00,1001.10,148.05,'2023-03-12 16:21:25'),(3037,'1','313',1,'Retail Sale Id 3101',0.00,1815.00,710.00,2130.00,315.00,'2023-03-12 16:26:24'),(3038,'1','313',1,'Retail Sale Id 3102',0.00,3630.00,710.00,4260.00,630.00,'2023-03-12 16:31:51'),(3039,'1','313',1,'Retail Sale Id 3103',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 16:32:47'),(3040,'1','313',1,'Retail Sale Id 3104',0.00,1815.00,710.00,2130.00,315.00,'2023-03-12 16:35:04'),(3041,'1','313',1,'Retail Sale Id 3105',0.00,605.00,710.00,710.00,105.00,'2023-03-12 16:37:53'),(3042,'1','313',1,'Retail Sale Id 3106',0.00,2420.00,710.00,2840.00,420.00,'2023-03-12 16:44:07'),(3043,'1','313',1,'Retail Sale Id 3107',0.00,1210.00,710.00,1420.00,210.00,'2023-03-12 16:45:46'),(3044,'1','313',1,'Return of Retail Sale Id 3069',2420.00,0.00,710.00,-2840.00,-420.00,'2023-03-12 17:02:09'),(3045,'1','313',1,'Return of Retail Sale Id 3070',12100.00,0.00,710.00,-14200.00,-2100.00,'2023-03-12 17:03:06'),(3046,'1','313',1,'Retail Sale Id 3108',0.00,14520.00,670.00,16080.00,1560.00,'2023-03-12 17:04:04'),(3047,'1','313',1,'Return of Retail Sale Id 3091',4235.00,0.00,710.00,-4970.00,-735.00,'2023-03-12 17:08:17'),(3048,'1','313',1,'Retail Sale Id 3109',0.00,3418.25,710.00,4011.50,593.25,'2023-03-12 17:08:53'),(3049,'1','313',1,'Retail Sale Id 3110',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 08:02:21'),(3050,'1','313',1,'Retail Sale Id 3111',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 08:03:29'),(3051,'1','313',1,'Retail Sale Id 3112',0.00,605.00,710.00,710.00,105.00,'2023-03-13 08:04:31'),(3052,'1','313',1,'Retail Sale Id 3113',0.00,3521.10,710.00,4132.20,611.10,'2023-03-13 08:06:15'),(3053,'1','313',1,'Retail Sale Id 3114',0.00,641.30,710.00,752.60,111.30,'2023-03-13 08:06:48'),(3054,'1','313',1,'Retail Sale Id 3115',0.00,99322.85,670.00,109993.90,10671.05,'2023-03-13 08:09:13'),(3055,'1','313',1,'Retail Sale Id 3116',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-13 08:09:46'),(3056,'1','313',1,'Retail Sale Id 3117',0.00,5112.25,710.00,5999.50,887.25,'2023-03-13 08:10:23'),(3057,'1','313',1,'Retail Sale Id 3118',0.00,605.00,710.00,710.00,105.00,'2023-03-13 08:10:58'),(3058,'1','313',1,'Retail Sale Id 3119',0.00,4235.00,710.00,4970.00,735.00,'2023-03-13 08:11:34'),(3059,'1','313',1,'Retail Sale Id 3120',0.00,3025.00,710.00,3550.00,525.00,'2023-03-13 08:12:19'),(3060,'1','313',1,'Retail Sale Id 3121',0.00,4235.00,710.00,4970.00,735.00,'2023-03-13 08:13:19'),(3061,'1','313',1,'Retail Sale Id 3122',0.00,853.05,710.00,1001.10,148.05,'2023-03-13 08:13:56'),(3062,'1','313',1,'Retail Sale Id 3123',0.00,3630.00,710.00,4260.00,630.00,'2023-03-13 08:14:33'),(3063,'1','313',1,'Retail Sale Id 3124',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 08:14:59'),(3064,'1','313',1,'Retail Sale Id 3125',0.00,2420.00,710.00,2840.00,420.00,'2023-03-13 08:15:25'),(3065,'1','313',1,'Retail Sale Id 3126',0.00,2559.15,710.00,3003.30,444.15,'2023-03-13 08:16:14'),(3066,'1','313',1,'Retail Sale Id 3127',0.00,605.00,710.00,710.00,105.00,'2023-03-13 08:16:55'),(3067,'1','313',1,'Retail Sale Id 3129',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-13 08:17:28'),(3068,'1','313',1,'Retail Sale Id 3130',0.00,2420.00,710.00,2840.00,420.00,'2023-03-13 08:18:00'),(3069,'1','313',1,'Retail Sale Id 3131',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-13 08:19:41'),(3070,'1','313',1,'Retail Sale Id 3132',0.00,3025.00,710.00,3550.00,525.00,'2023-03-13 08:22:17'),(3071,'1','313',1,'Retail Sale Id 3133',0.00,4259.20,710.00,4998.40,739.20,'2023-03-13 08:23:47'),(3072,'1','313',1,'Retail Sale Id 3134',0.00,4235.00,710.00,4970.00,735.00,'2023-03-13 08:24:29'),(3073,'1','313',1,'Retail Sale Id 3136',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-13 08:25:27'),(3074,'1','313',1,'Retail Sale Id 3137',0.00,605.00,710.00,710.00,105.00,'2023-03-13 08:26:09'),(3075,'1','313',1,'Retail Sale Id 3138',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 08:26:43'),(3076,'1','313',1,'Retail Sale Id 3139',0.00,2420.00,710.00,2840.00,420.00,'2023-03-13 08:27:20'),(3077,'1','313',1,'Retail Sale Id 3140',0.00,3630.00,710.00,4260.00,630.00,'2023-03-13 08:27:50'),(3078,'1','313',1,'Retail Sale Id 3141',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-13 08:28:22'),(3079,'1','313',1,'Retail Sale Id 3142',0.00,3630.00,710.00,4260.00,630.00,'2023-03-13 08:28:53'),(3080,'1','313',1,'Retail Sale Id 3143',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-13 08:29:31'),(3081,'1','313',1,'Retail Sale Id 3144',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 08:30:03'),(3082,'1','313',1,'Retail Sale Id 3145',0.00,683.65,710.00,802.30,118.65,'2023-03-13 08:31:15'),(3083,'1','313',1,'Retail Sale Id 3146',0.00,641.30,710.00,752.60,111.30,'2023-03-13 08:32:08'),(3084,'1','313',1,'Retail Sale Id 3147',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 08:32:38'),(3085,'1','313',1,'Retail Sale Id 3148',0.00,4235.00,710.00,4970.00,735.00,'2023-03-13 08:33:24'),(3086,'1','313',1,'Retail Sale Id 3149',0.00,641.30,710.00,752.60,111.30,'2023-03-13 08:35:01'),(3087,'1','313',1,'Retail Sale Id 3150',0.00,4235.00,710.00,4970.00,735.00,'2023-03-13 08:36:29'),(3088,'1','313',1,'Retail Sale Id 3151',0.00,4235.00,710.00,4970.00,735.00,'2023-03-13 08:37:07'),(3089,'1','313',1,'Retail Sale Id 3152',0.00,36747.70,670.00,40695.80,3948.10,'2023-03-13 08:38:46'),(3090,'1','313',1,'Retail Sale Id 3153',0.00,3025.00,710.00,3550.00,525.00,'2023-03-13 08:39:38'),(3091,'1','313',1,'Retail Sale Id 3154',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-13 08:40:05'),(3092,'1','313',1,'Retail Sale Id 3155',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-13 08:41:03'),(3093,'1','313',1,'Retail Sale Id 3156',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 08:41:49'),(3094,'1','313',1,'Retail Sale Id 3157',0.00,2420.00,710.00,2840.00,420.00,'2023-03-13 08:42:17'),(3095,'1','313',1,'Retail Sale Id 3158',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-13 08:43:14'),(3096,'1','313',1,'Retail Sale Id 3159',0.00,3025.00,710.00,3550.00,525.00,'2023-03-13 08:43:58'),(3097,'1','313',1,'Retail Sale Id 3160',0.00,2420.00,710.00,2840.00,420.00,'2023-03-13 08:45:17'),(3098,'1','313',1,'Retail Sale Id 3161',0.00,2420.00,710.00,2840.00,420.00,'2023-03-13 08:47:19'),(3099,'1','313',1,'Retail Sale Id 3162',0.00,4235.00,710.00,4970.00,735.00,'2023-03-13 08:48:34'),(3100,'1','313',1,'Retail Sale Id 3163',0.00,605.00,710.00,710.00,105.00,'2023-03-13 08:49:03'),(3101,'1','313',1,'Retail Sale Id 3164',0.00,3025.00,710.00,3550.00,525.00,'2023-03-13 08:49:38'),(3102,'1','313',1,'Retail Sale Id 3165',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 08:50:24'),(3103,'1','313',1,'Retail Sale Id 3166',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-13 08:50:58'),(3104,'1','313',1,'Retail Sale Id 3167',0.00,3025.00,710.00,3550.00,525.00,'2023-03-13 08:51:30'),(3105,'1','313',1,'Retail Sale Id 3168',0.00,36808.20,670.00,40762.80,3954.60,'2023-03-13 08:52:34'),(3106,'1','313',1,'Retail Sale Id 3169',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-13 08:54:16'),(3107,'1','313',1,'Retail Sale Id 3170',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 08:55:01'),(3108,'1','313',1,'Retail Sale Id 3171',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-13 08:55:46'),(3109,'1','313',1,'Retail Sale Id 3172',0.00,605.00,710.00,710.00,105.00,'2023-03-13 08:56:17'),(3110,'1','313',1,'Retail Sale Id 3173',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-13 08:57:27'),(3111,'1','313',1,'Retail Sale Id 3174',0.00,11495.00,670.00,12730.00,1235.00,'2023-03-13 08:58:36'),(3112,'1','313',1,'Retail Sale Id 3175',0.00,26620.00,710.00,31240.00,4620.00,'2023-03-13 09:00:30'),(3113,'1','313',1,'Retail Sale Id 3176',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 09:01:36'),(3114,'1','313',1,'Retail Sale Id 3177',0.00,2117.50,710.00,2485.00,367.50,'2023-03-13 09:02:18'),(3115,'1','313',1,'Retail Sale Id 3178',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-13 09:04:06'),(3116,'1','313',1,'Return of Retail Sale Id 3175',26620.00,0.00,710.00,-31240.00,-4620.00,'2023-03-13 09:04:34'),(3117,'1','313',1,'Retail Sale Id 3179',0.00,26620.00,670.00,29480.00,2860.00,'2023-03-13 09:05:05'),(3118,'1','313',1,'Retail Sale Id 3180',0.00,605.00,710.00,710.00,105.00,'2023-03-13 09:05:50'),(3119,'1','313',1,'Retail Sale Id 3181',0.00,4235.00,710.00,4970.00,735.00,'2023-03-13 09:06:49'),(3120,'1','313',1,'Retail Sale Id 3182',0.00,3630.00,710.00,4260.00,630.00,'2023-03-13 09:07:21'),(3121,'1','313',1,'Retail Sale Id 3183',0.00,3630.00,710.00,4260.00,630.00,'2023-03-13 09:08:06'),(3122,'1','313',1,'Retail Sale Id 3184',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 09:08:35'),(3123,'1','313',1,'Retail Sale Id 3185',0.00,641.30,710.00,752.60,111.30,'2023-03-13 09:10:06'),(3124,'1','313',1,'Retail Sale Id 3186',0.00,60500.00,670.00,67000.00,6500.00,'2023-03-13 09:11:14'),(3125,'1','313',1,'Retail Sale Id 3187',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 09:11:54'),(3126,'1','313',1,'Retail Sale Id 3188',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 09:16:02'),(3127,'1','313',1,'Retail Sale Id 3189',0.00,72600.00,670.00,80400.00,7800.00,'2023-03-13 09:18:38'),(3128,'1','313',1,'Retail Sale Id 3190',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-13 09:21:33'),(3129,'1','313',1,'Retail Sale Id 3191',0.00,1234.20,710.00,1448.40,214.20,'2023-03-13 09:22:33'),(3130,'1','313',1,'Retail Sale Id 3192',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 09:24:40'),(3131,'1','313',1,'Retail Sale Id 3193',0.00,605.00,710.00,710.00,105.00,'2023-03-13 09:25:38'),(3132,'1','313',1,'Retail Sale Id 3194',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 09:29:51'),(3133,'1','313',1,'Retail Sale Id 3195',0.00,641.30,710.00,752.60,111.30,'2023-03-13 09:31:22'),(3134,'1','313',1,'Retail Sale Id 3196',0.00,4840.00,710.00,5680.00,840.00,'2023-03-13 09:32:23'),(3135,'1','313',1,'Retail Sale Id 3197',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 09:34:26'),(3136,'1','313',1,'Retail Sale Id 3198',0.00,3025.00,710.00,3550.00,525.00,'2023-03-13 09:36:31'),(3137,'1','313',1,'Retail Sale Id 3199',0.00,3630.00,710.00,4260.00,630.00,'2023-03-13 09:37:31'),(3138,'1','313',1,'Retail Sale Id 3200',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-13 09:41:55'),(3139,'1','313',1,'Retail Sale Id 3201',0.00,2420.00,710.00,2840.00,420.00,'2023-03-13 09:45:01'),(3140,'1','313',1,'Retail Sale Id 3202',0.00,90750.00,670.00,100500.00,9750.00,'2023-03-13 09:46:26'),(3141,'1','313',1,'Retail Sale Id 3203',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-13 09:49:39'),(3142,'1','313',1,'Retail Sale Id 3204',0.00,9680.00,710.00,11360.00,1680.00,'2023-03-13 09:50:22'),(3143,'1','313',1,'Retail Sale Id 3205',0.00,2129.60,710.00,2499.20,369.60,'2023-03-13 09:51:01'),(3144,'1','313',1,'Retail Sale Id 3206',0.00,2420.00,710.00,2840.00,420.00,'2023-03-13 09:51:51'),(3145,'1','313',1,'Retail Sale Id 3207',0.00,1706.10,710.00,2002.20,296.10,'2023-03-13 09:52:23'),(3146,'1','313',1,'Retail Sale Id 3208',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 09:52:56'),(3147,'1','313',1,'Retail Sale Id 3209',0.00,4235.00,710.00,4970.00,735.00,'2023-03-13 09:53:36'),(3148,'1','313',1,'Retail Sale Id 3210',0.00,3025.00,710.00,3550.00,525.00,'2023-03-13 09:54:00'),(3149,'1','313',1,'Retail Sale Id 3211',0.00,1234.20,710.00,1448.40,214.20,'2023-03-13 09:54:44'),(3150,'1','313',1,'Retail Sale Id 3212',0.00,605.00,710.00,710.00,105.00,'2023-03-13 09:55:24'),(3151,'1','313',1,'Retail Sale Id 3213',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-13 10:00:02'),(3152,'1','313',1,'Retail Sale Id 3214',0.00,605.00,710.00,710.00,105.00,'2023-03-13 10:00:43'),(3153,'1','313',1,'Retail Sale Id 3215',0.00,2559.15,710.00,3003.30,444.15,'2023-03-13 10:01:39'),(3154,'1','313',1,'Retail Sale Id 3216',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 10:02:31'),(3155,'1','313',1,'Retail Sale Id 3217',0.00,1512.50,710.00,1775.00,262.50,'2023-03-13 10:03:08'),(3156,'1','313',1,'Retail Sale Id 3218',0.00,3025.00,710.00,3550.00,525.00,'2023-03-13 10:07:13'),(3157,'1','313',1,'Retail Sale Id 3219',0.00,8094.90,710.00,9499.80,1404.90,'2023-03-13 10:10:52'),(3158,'1','313',1,'Retail Sale Id 3220',0.00,72600.00,670.00,80400.00,7800.00,'2023-03-13 10:12:16'),(3159,'1','313',1,'Retail Sale Id 3221',0.00,2559.15,710.00,3003.30,444.15,'2023-03-13 10:14:38'),(3160,'1','313',1,'Retail Sale Id 3222',0.00,3025.00,710.00,3550.00,525.00,'2023-03-13 10:15:24'),(3161,'1','313',1,'Retail Sale Id 3223',0.00,107690.00,670.00,119260.00,11570.00,'2023-03-13 10:16:49'),(3162,'1','313',1,'Retail Sale Id 3224',0.00,4235.00,710.00,4970.00,735.00,'2023-03-13 10:18:00'),(3163,'1','313',1,'Retail Sale Id 3225',0.00,3630.00,710.00,4260.00,630.00,'2023-03-13 10:19:37'),(3164,'1','313',1,'Retail Sale Id 3226',0.00,423.50,710.00,497.00,73.50,'2023-03-13 10:22:24'),(3165,'1','313',1,'Retail Sale Id 3227',0.00,605.00,710.00,710.00,105.00,'2023-03-13 10:23:45'),(3166,'1','313',1,'Retail Sale Id 3228',0.00,2426.05,710.00,2847.10,421.05,'2023-03-13 10:25:00'),(3167,'1','313',1,'Retail Sale Id 3229',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 10:26:01'),(3168,'1','313',1,'Retail Sale Id 3230',0.00,2420.00,710.00,2840.00,420.00,'2023-03-13 10:27:29'),(3169,'1','313',1,'Retail Sale Id 3231',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-13 10:31:59'),(3170,'1','313',1,'Retail Sale Id 3232',0.00,2420.00,710.00,2840.00,420.00,'2023-03-13 10:32:49'),(3171,'1','313',1,'Retail Sale Id 3233',0.00,1276.55,710.00,1498.10,221.55,'2023-03-13 10:37:27'),(3172,'1','313',1,'Retail Sale Id 3234',0.00,605.00,710.00,710.00,105.00,'2023-03-13 10:38:30'),(3173,'1','313',1,'Retail Sale Id 3236',0.00,1234.20,710.00,1448.40,214.20,'2023-03-13 10:40:57'),(3174,'1','313',1,'Retail Sale Id 3237',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 10:42:02'),(3175,'1','313',1,'Retail Sale Id 3238',0.00,5965.30,710.00,7000.60,1035.30,'2023-03-13 10:43:03'),(3176,'1','313',1,'Retail Sale Id 3239',0.00,5445.00,710.00,6390.00,945.00,'2023-03-13 10:44:17'),(3177,'1','313',1,'Retail Sale Id 3240',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-13 10:45:53'),(3178,'1','313',1,'Retail Sale Id 3241',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-13 10:47:16'),(3179,'1','313',1,'Retail Sale Id 3242',0.00,3025.00,710.00,3550.00,525.00,'2023-03-13 10:48:23'),(3180,'1','313',1,'Retail Sale Id 3243',0.00,3630.00,710.00,4260.00,630.00,'2023-03-13 10:50:29'),(3181,'1','313',1,'Retail Sale Id 3244',0.00,3406.15,710.00,3997.30,591.15,'2023-03-13 10:53:12'),(3182,'1','313',1,'Retail Sale Id 3245',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 10:58:43'),(3183,'1','313',1,'Retail Sale Id 3246',0.00,2420.00,710.00,2840.00,420.00,'2023-03-13 11:00:35'),(3184,'1','313',1,'Retail Sale Id 3247',0.00,1276.55,710.00,1498.10,221.55,'2023-03-13 11:03:11'),(3185,'1','313',1,'Retail Sale Id 3248',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 11:07:52'),(3186,'1','313',1,'Retail Sale Id 3249',0.00,1022.45,710.00,1199.90,177.45,'2023-03-13 11:12:20'),(3187,'1','313',1,'Retail Sale Id 3250',0.00,1960.20,710.00,2300.40,340.20,'2023-03-13 11:16:05'),(3188,'1','313',1,'Retail Sale Id 3251',0.00,3630.00,710.00,4260.00,630.00,'2023-03-13 11:19:56'),(3189,'1','313',1,'Retail Sale Id 3252',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-13 11:25:25'),(3190,'1','313',1,'Retail Sale Id 3253',0.00,4235.00,710.00,4970.00,735.00,'2023-03-13 11:26:13'),(3191,'1','313',1,'Retail Sale Id 3254',0.00,1234.20,710.00,1448.40,214.20,'2023-03-13 11:38:02'),(3192,'1','313',1,'Retail Sale Id 3255',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 11:40:12'),(3193,'1','313',1,'Retail Sale Id 3256',0.00,3630.00,710.00,4260.00,630.00,'2023-03-13 11:41:58'),(3194,'1','313',1,'Retail Sale Id 3257',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-13 11:44:48'),(3195,'1','313',1,'Retail Sale Id 3258',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 11:51:32'),(3196,'1','313',1,'Retail Sale Id 3259',0.00,4259.20,710.00,4998.40,739.20,'2023-03-13 11:54:07'),(3197,'1','313',1,'Retail Sale Id 3260',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 11:56:20'),(3198,'1','313',1,'Retail Sale Id 3261',0.00,3630.00,710.00,4260.00,630.00,'2023-03-13 11:58:17'),(3199,'1','313',1,'Retail Sale Id 3262',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 12:03:24'),(3200,'1','313',1,'Retail Sale Id 3263',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 12:10:50'),(3201,'1','313',1,'Retail Sale Id 3264',0.00,1234.20,710.00,1448.40,214.20,'2023-03-13 12:11:26'),(3202,'1','313',1,'Retail Sale Id 3266',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 12:18:30'),(3203,'1','313',1,'Retail Sale Id 3267',0.00,5445.00,710.00,6390.00,945.00,'2023-03-13 12:22:57'),(3204,'1','313',1,'Return of Retail Sale Id 3267',5445.00,0.00,710.00,-6390.00,-945.00,'2023-03-13 12:27:15'),(3205,'1','313',1,'Retail Sale Id 3268',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 12:27:53'),(3206,'1','313',1,'Retail Sale Id 3270',0.00,2420.00,710.00,2840.00,420.00,'2023-03-13 12:29:55'),(3207,'1','313',1,'Retail Sale Id 3271',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 12:33:05'),(3208,'1','313',1,'Retail Sale Id 3272',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-13 12:34:26'),(3209,'1','313',1,'Retail Sale Id 3273',0.00,2420.00,710.00,2840.00,420.00,'2023-03-13 12:36:43'),(3210,'1','313',1,'Retail Sale Id 3274',0.00,3025.00,710.00,3550.00,525.00,'2023-03-13 12:38:14'),(3211,'1','313',1,'Retail Sale Id 3275',0.00,35749.45,670.00,39590.30,3840.85,'2023-03-13 12:40:16'),(3212,'1','313',1,'Retail Sale Id 3276',0.00,4235.00,710.00,4970.00,735.00,'2023-03-13 12:41:41'),(3213,'1','313',1,'Retail Sale Id 3277',0.00,5445.00,710.00,6390.00,945.00,'2023-03-13 12:43:54'),(3214,'1','313',1,'Retail Sale Id 3278',0.00,1234.20,710.00,1448.40,214.20,'2023-03-13 12:45:21'),(3215,'1','313',1,'Retail Sale Id 3279',0.00,3025.00,710.00,3550.00,525.00,'2023-03-13 12:50:25'),(3216,'1','313',1,'Retail Sale Id 3280',0.00,605.00,710.00,710.00,105.00,'2023-03-13 12:52:31'),(3217,'1','313',1,'Retail Sale Id 3281',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-13 12:53:21'),(3218,'1','313',1,'Retail Sale Id 3282',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 12:58:01'),(3219,'1','313',1,'Retail Sale Id 3283',0.00,605.00,710.00,710.00,105.00,'2023-03-13 13:02:40'),(3220,'1','313',1,'Retail Sale Id 3284',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-13 13:03:32'),(3221,'1','313',1,'Retail Sale Id 3285',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-13 13:07:10'),(3222,'1','313',1,'Retail Sale Id 3286',0.00,2420.00,710.00,2840.00,420.00,'2023-03-13 13:08:44'),(3223,'1','313',1,'Retail Sale Id 3287',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 13:11:29'),(3224,'1','313',1,'Retail Sale Id 3288',0.00,1276.55,710.00,1498.10,221.55,'2023-03-13 13:12:31'),(3225,'1','313',1,'Retail Sale Id 3289',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 13:13:42'),(3226,'1','313',1,'Retail Sale Id 3290',0.00,3025.00,710.00,3550.00,525.00,'2023-03-13 13:15:19'),(3227,'1','313',1,'Retail Sale Id 3291',0.00,9680.00,710.00,11360.00,1680.00,'2023-03-13 13:19:27'),(3228,'1','313',1,'Retail Sale Id 3292',0.00,2420.00,710.00,2840.00,420.00,'2023-03-13 13:23:12'),(3229,'1','313',1,'Retail Sale Id 3293',0.00,2420.00,710.00,2840.00,420.00,'2023-03-13 13:24:18'),(3230,'1','313',1,'Retail Sale Id 3294',0.00,2420.00,710.00,2840.00,420.00,'2023-03-13 13:25:45'),(3231,'1','313',1,'Retail Sale Id 3295',0.00,598.95,710.00,702.90,103.95,'2023-03-13 13:30:46'),(3232,'1','313',1,'Retail Sale Id 3296',0.00,605.00,710.00,710.00,105.00,'2023-03-13 13:35:59'),(3233,'1','313',1,'Retail Sale Id 3297',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-13 13:37:18'),(3234,'1','313',1,'Retail Sale Id 3298',0.00,3025.00,710.00,3550.00,525.00,'2023-03-13 13:44:15'),(3235,'1','313',1,'Retail Sale Id 3299',0.00,605.00,710.00,710.00,105.00,'2023-03-13 13:50:09'),(3236,'1','313',1,'Retail Sale Id 3300',0.00,605.00,710.00,710.00,105.00,'2023-03-13 13:52:33'),(3237,'1','313',1,'Retail Sale Id 3301',0.00,4186.60,710.00,4913.20,726.60,'2023-03-13 13:53:13'),(3238,'1','313',1,'Return of Retail Sale Id 3301',4186.60,0.00,710.00,-4913.20,-726.60,'2023-03-13 13:53:39'),(3239,'1','313',1,'Retail Sale Id 3302',0.00,4186.60,670.00,4636.40,449.80,'2023-03-13 13:54:36'),(3240,'1','313',1,'Retail Sale Id 3303',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-13 13:57:04'),(3241,'1','313',1,'Return of Retail Sale Id 3295',598.95,0.00,710.00,-702.90,-103.95,'2023-03-13 13:57:56'),(3242,'1','313',1,'Retail Sale Id 3304',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-13 13:59:08'),(3243,'1','313',1,'Retail Sale Id 3305',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 14:06:11'),(3244,'1','313',1,'Retail Sale Id 3306',0.00,3025.00,710.00,3550.00,525.00,'2023-03-13 14:11:52'),(3245,'1','313',1,'Retail Sale Id 3307',0.00,4089.80,710.00,4799.60,709.80,'2023-03-13 14:17:12'),(3246,'1','313',1,'Retail Sale Id 3310',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 14:24:03'),(3247,'1','313',1,'Retail Sale Id 3311',0.00,2420.00,710.00,2840.00,420.00,'2023-03-13 14:29:53'),(3248,'1','313',1,'Retail Sale Id 3312',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-13 14:36:07'),(3249,'1','313',1,'Retail Sale Id 3313',0.00,605.00,710.00,710.00,105.00,'2023-03-13 14:37:48'),(3250,'1','313',1,'Retail Sale Id 3314',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 14:46:22'),(3251,'1','313',1,'Retail Sale Id 3315',0.00,683.65,710.00,802.30,118.65,'2023-03-13 14:58:15'),(3252,'1','313',1,'Retail Sale Id 3316',0.00,1234.20,710.00,1448.40,214.20,'2023-03-13 15:12:42'),(3253,'1','313',1,'Retail Sale Id 3317',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 15:22:18'),(3254,'1','313',1,'Retail Sale Id 3318',0.00,1833.15,710.00,2151.30,318.15,'2023-03-13 15:23:13'),(3255,'1','313',1,'Retail Sale Id 3319',0.00,1706.10,710.00,2002.20,296.10,'2023-03-13 15:26:24'),(3256,'1','313',1,'Retail Sale Id 3320',0.00,598.95,710.00,702.90,103.95,'2023-03-13 15:32:59'),(3257,'1','313',1,'Retail Sale Id 3321',0.00,641.30,710.00,752.60,111.30,'2023-03-13 15:46:30'),(3258,'1','313',1,'Retail Sale Id 3322',0.00,605.00,710.00,710.00,105.00,'2023-03-13 15:47:34'),(3259,'1','313',1,'Retail Sale Id 3323',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 15:54:14'),(3260,'1','313',1,'Retail Sale Id 3324',0.00,2420.00,710.00,2840.00,420.00,'2023-03-13 15:56:26'),(3261,'1','313',1,'Retail Sale Id 3325',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 16:07:13'),(3262,'1','313',1,'Retail Sale Id 3326',0.00,1234.20,710.00,1448.40,214.20,'2023-03-13 16:14:39'),(3263,'1','313',1,'Retail Sale Id 3327',0.00,3025.00,710.00,3550.00,525.00,'2023-03-13 16:21:42'),(3264,'1','313',1,'Retail Sale Id 3328',0.00,895.40,710.00,1050.80,155.40,'2023-03-13 16:23:54'),(3265,'1','313',1,'Retail Sale Id 3329',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 16:25:09'),(3266,'1','313',1,'Retail Sale Id 3330',0.00,605.00,710.00,710.00,105.00,'2023-03-13 16:26:01'),(3267,'1','313',1,'Retail Sale Id 3331',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 16:29:26'),(3268,'1','313',1,'Retail Sale Id 3332',0.00,1191.85,710.00,1398.70,206.85,'2023-03-13 16:31:46'),(3269,'1','313',1,'Retail Sale Id 3333',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 16:32:55'),(3270,'1','313',1,'Retail Sale Id 3334',0.00,1276.55,710.00,1498.10,221.55,'2023-03-13 16:33:47'),(3271,'1','313',1,'Retail Sale Id 3336',0.00,1833.15,710.00,2151.30,318.15,'2023-03-13 16:40:25'),(3272,'1','313',1,'Retail Sale Id 3337',0.00,1875.50,710.00,2201.00,325.50,'2023-03-13 16:42:55'),(3273,'1','313',1,'Retail Sale Id 3338',0.00,641.30,710.00,752.60,111.30,'2023-03-13 16:51:32'),(3274,'1','313',1,'Retail Sale Id 3339',0.00,1833.15,710.00,2151.30,318.15,'2023-03-13 16:52:48'),(3275,'1','313',1,'Retail Sale Id 3340',0.00,7604.85,710.00,8924.70,1319.85,'2023-03-13 16:53:45'),(3276,'1','313',1,'Retail Sale Id 3341',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-13 16:54:28'),(3277,'1','313',1,'Retail Sale Id 3342',0.00,641.30,710.00,752.60,111.30,'2023-03-13 16:55:36'),(3278,'1','313',1,'Return of Retail Sale Id 3219',8094.90,0.00,710.00,-9499.80,-1404.90,'2023-03-13 17:01:03'),(3279,'1','313',1,'Retail Sale Id 3343',0.00,1210.00,710.00,1420.00,210.00,'2023-03-13 17:01:52'),(3280,'1','313',1,'Retail Sale Id 3344',0.00,2420.00,710.00,2840.00,420.00,'2023-03-13 17:10:01'),(3281,'1','313',1,'Retail Sale Id 3345',0.00,1706.10,710.00,2002.20,296.10,'2023-03-13 17:12:03'),(3282,'1','313',1,'Retail Sale Id 3346',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 17:12:52'),(3283,'1','313',1,'Retail Sale Id 3347',0.00,605.00,710.00,710.00,105.00,'2023-03-13 17:13:35'),(3284,'1','313',1,'Retail Sale Id 3348',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 17:14:04'),(3285,'1','313',1,'Retail Sale Id 3349',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-13 17:15:01'),(3286,'1','313',1,'Retail Sale Id 3350',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 17:15:35'),(3287,'1','313',1,'Retail Sale Id 3351',0.00,641.30,710.00,752.60,111.30,'2023-03-13 17:17:12'),(3288,'1','313',1,'Retail Sale Id 3352',0.00,3025.00,710.00,3550.00,525.00,'2023-03-13 17:18:20'),(3289,'1','313',1,'Return of Retail Sale Id 3332',1191.85,0.00,710.00,-1398.70,-206.85,'2023-03-13 17:21:05'),(3290,'1','313',1,'Retail Sale Id 3353',0.00,605.00,710.00,710.00,105.00,'2023-03-13 17:23:59'),(3291,'1','313',1,'Retail Sale Id 3354',0.00,641.30,710.00,752.60,111.30,'2023-03-13 17:25:30'),(3292,'1','313',1,'Retail Sale Id 3355',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 17:28:34'),(3293,'1','313',1,'Retail Sale Id 3356',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-13 17:36:36'),(3294,'1','313',1,'Retail Sale Id 3357',0.00,1815.00,710.00,2130.00,315.00,'2023-03-13 17:42:01'),(3295,'1','313',1,'Retail Sale Id 3358',0.00,75225.70,670.00,83307.80,8082.10,'2023-03-13 17:44:43'),(3296,'1','313',1,'Retail Sale Id 3359',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-13 17:49:38'),(3297,'1','313',1,'Retail Sale Id 3360',0.00,72600.00,670.00,80400.00,7800.00,'2023-03-13 17:58:10'),(3298,'1','313',1,'Retail Sale Id 3361',0.00,3630.00,710.00,4260.00,630.00,'2023-03-13 18:00:32'),(3299,'1','313',1,'Return of Retail Sale Id 3340',7604.85,0.00,710.00,-8924.70,-1319.85,'2023-03-13 18:12:08'),(3300,'1','313',1,'Retail Sale Id 3362',0.00,5783.80,710.00,6787.60,1003.80,'2023-03-13 18:12:49'),(3301,'1','313',1,'Return of Retail Sale Id 3168',36808.20,0.00,670.00,-40762.80,-3954.60,'2023-03-13 18:19:20'),(3302,'1','313',1,'Retail Sale Id 3363',0.00,36656.95,670.00,40595.30,3938.35,'2023-03-13 18:20:19'),(3303,'1','313',1,'Retail Sale Id 3365',0.00,3630.00,710.00,4260.00,630.00,'2023-03-14 08:15:24'),(3304,'1','313',1,'Retail Sale Id 3366',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-14 08:16:18'),(3305,'1','313',1,'Retail Sale Id 3367',0.00,33275.00,670.00,36850.00,3575.00,'2023-03-14 08:17:19'),(3306,'1','313',1,'Retail Sale Id 3368',0.00,4235.00,710.00,4970.00,735.00,'2023-03-14 08:18:29'),(3307,'1','313',1,'Retail Sale Id 3370',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-14 08:21:28'),(3308,'1','313',1,'Retail Sale Id 3371',0.00,8470.00,710.00,9940.00,1470.00,'2023-03-14 08:22:05'),(3309,'1','313',1,'Retail Sale Id 3372',0.00,1815.00,710.00,2130.00,315.00,'2023-03-14 08:25:58'),(3310,'1','313',1,'Retail Sale Id 3373',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-14 08:27:03'),(3311,'1','313',1,'Retail Sale Id 3374',0.00,2420.00,710.00,2840.00,420.00,'2023-03-14 08:28:15'),(3312,'1','313',1,'Retail Sale Id 3375',0.00,1815.00,710.00,2130.00,315.00,'2023-03-14 08:29:04'),(3313,'1','313',1,'Retail Sale Id 3376',0.00,1210.00,710.00,1420.00,210.00,'2023-03-14 08:29:59'),(3314,'1','313',1,'Retail Sale Id 3377',0.00,1276.55,710.00,1498.10,221.55,'2023-03-14 08:31:12'),(3315,'1','313',1,'Retail Sale Id 3378',0.00,2420.00,710.00,2840.00,420.00,'2023-03-14 08:32:04'),(3316,'1','313',1,'Retail Sale Id 3379',0.00,3236.75,710.00,3798.50,561.75,'2023-03-14 08:35:53'),(3317,'1','313',1,'Return of Retail Sale Id 3379',3236.75,0.00,710.00,-3798.50,-561.75,'2023-03-14 08:36:29'),(3318,'1','313',1,'Retail Sale Id 3380',0.00,3279.10,710.00,3848.20,569.10,'2023-03-14 08:37:25'),(3319,'1','313',1,'Retail Sale Id 3381',0.00,3025.00,710.00,3550.00,525.00,'2023-03-14 08:38:35'),(3320,'1','313',1,'Retail Sale Id 3382',0.00,2420.00,710.00,2840.00,420.00,'2023-03-14 08:40:25'),(3321,'1','313',1,'Retail Sale Id 3383',0.00,1210.00,710.00,1420.00,210.00,'2023-03-14 08:41:39'),(3322,'1','313',1,'Retail Sale Id 3384',0.00,4259.20,710.00,4998.40,739.20,'2023-03-14 08:43:48'),(3323,'1','313',1,'Retail Sale Id 3385',0.00,2559.15,710.00,3003.30,444.15,'2023-03-14 08:45:31'),(3324,'1','313',1,'Retail Sale Id 3386',0.00,3630.00,710.00,4260.00,630.00,'2023-03-14 08:46:18'),(3325,'1','313',1,'Retail Sale Id 3387',0.00,1815.00,710.00,2130.00,315.00,'2023-03-14 08:47:30'),(3326,'1','313',1,'Retail Sale Id 3388',0.00,18755.00,670.00,20770.00,2015.00,'2023-03-14 08:49:40'),(3327,'1','313',1,'Retail Sale Id 3389',0.00,2129.60,710.00,2499.20,369.60,'2023-03-14 08:50:41'),(3328,'1','313',1,'Retail Sale Id 3390',0.00,1276.55,710.00,1498.10,221.55,'2023-03-14 08:51:31'),(3329,'1','313',1,'Retail Sale Id 3391',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-14 08:52:11'),(3330,'1','313',1,'Retail Sale Id 3393',0.00,605.00,710.00,710.00,105.00,'2023-03-14 08:55:31'),(3331,'1','313',1,'Retail Sale Id 3394',0.00,605.00,710.00,710.00,105.00,'2023-03-14 09:03:13'),(3332,'1','313',1,'Retail Sale Id 3395',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-14 09:05:36'),(3333,'1','313',1,'Retail Sale Id 3396',0.00,2420.00,710.00,2840.00,420.00,'2023-03-14 09:07:06'),(3334,'1','313',1,'Retail Sale Id 3397',0.00,3630.00,710.00,4260.00,630.00,'2023-03-14 09:08:03'),(3335,'1','313',1,'Retail Sale Id 3398',0.00,2420.00,710.00,2840.00,420.00,'2023-03-14 09:09:01'),(3336,'1','313',1,'Retail Sale Id 3399',0.00,3025.00,710.00,3550.00,525.00,'2023-03-14 09:10:28'),(3337,'1','313',1,'Retail Sale Id 3400',0.00,1815.00,710.00,2130.00,315.00,'2023-03-14 09:12:16'),(3338,'1','313',1,'Retail Sale Id 3401',0.00,27388.35,670.00,30330.90,2942.55,'2023-03-14 09:18:08'),(3339,'1','313',1,'Retail Sale Id 3402',0.00,611.05,710.00,717.10,106.05,'2023-03-14 09:20:53'),(3340,'1','313',1,'Retail Sale Id 3403',0.00,1234.20,710.00,1448.40,214.20,'2023-03-14 09:22:43'),(3341,'1','313',1,'Retail Sale Id 3404',0.00,641.30,710.00,752.60,111.30,'2023-03-14 09:24:00'),(3342,'1','313',1,'Retail Sale Id 3405',0.00,4235.00,710.00,4970.00,735.00,'2023-03-14 09:37:18'),(3343,'1','313',1,'Retail Sale Id 3406',0.00,1210.00,710.00,1420.00,210.00,'2023-03-14 09:38:51'),(3344,'1','313',1,'Retail Sale Id 3407',0.00,1234.20,710.00,1448.40,214.20,'2023-03-14 09:41:31'),(3345,'1','313',1,'Retail Sale Id 3408',0.00,30250.00,710.00,35500.00,5250.00,'2023-03-14 09:42:18'),(3346,'1','313',1,'Retail Sale Id 3409',0.00,3025.00,710.00,3550.00,525.00,'2023-03-14 09:43:17'),(3347,'1','313',1,'Retail Sale Id 3410',0.00,605.00,710.00,710.00,105.00,'2023-03-14 09:44:14'),(3348,'1','313',1,'Retail Sale Id 3411',0.00,4235.00,710.00,4970.00,735.00,'2023-03-14 09:45:14'),(3349,'1','313',1,'Retail Sale Id 3412',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-14 09:46:19'),(3350,'1','313',1,'Retail Sale Id 3413',0.00,1706.10,710.00,2002.20,296.10,'2023-03-14 09:48:43'),(3351,'1','313',1,'Retail Sale Id 3414',0.00,1210.00,710.00,1420.00,210.00,'2023-03-14 09:49:54'),(3352,'1','313',1,'Retail Sale Id 3415',0.00,907.50,710.00,1065.00,157.50,'2023-03-14 09:51:04'),(3353,'1','313',1,'Retail Sale Id 3416',0.00,3025.00,710.00,3550.00,525.00,'2023-03-14 09:51:30'),(3354,'1','313',1,'Retail Sale Id 3417',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-14 09:51:56'),(3355,'1','313',1,'Retail Sale Id 3418',0.00,3630.00,710.00,4260.00,630.00,'2023-03-14 09:53:00'),(3356,'1','313',1,'Retail Sale Id 3419',0.00,2420.00,710.00,2840.00,420.00,'2023-03-14 09:53:28'),(3357,'1','313',1,'Retail Sale Id 3420',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-14 09:54:48'),(3358,'1','313',1,'Retail Sale Id 3421',0.00,5142.50,710.00,6035.00,892.50,'2023-03-14 09:55:52'),(3359,'1','313',1,'Retail Sale Id 3422',0.00,3630.00,710.00,4260.00,630.00,'2023-03-14 09:56:26'),(3360,'1','313',1,'Retail Sale Id 3423',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-14 09:57:18'),(3361,'1','313',1,'Retail Sale Id 3424',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-14 09:57:41'),(3362,'1','313',1,'Retail Sale Id 3425',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-14 09:59:48'),(3363,'1','313',1,'Retail Sale Id 3426',0.00,605.00,710.00,710.00,105.00,'2023-03-14 10:00:21'),(3364,'1','313',1,'Retail Sale Id 3427',0.00,1815.00,710.00,2130.00,315.00,'2023-03-14 10:00:59'),(3365,'1','313',1,'Retail Sale Id 3428',0.00,2420.00,710.00,2840.00,420.00,'2023-03-14 10:03:11'),(3366,'1','313',1,'Retail Sale Id 3429',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-14 10:03:44'),(3367,'1','313',1,'Retail Sale Id 3430',0.00,1276.55,710.00,1498.10,221.55,'2023-03-14 10:04:23'),(3368,'1','313',1,'Retail Sale Id 3431',0.00,36917.10,670.00,40883.40,3966.30,'2023-03-14 10:05:45'),(3369,'1','313',1,'Retail Sale Id 3432',0.00,2420.00,710.00,2840.00,420.00,'2023-03-14 10:06:29'),(3370,'1','313',1,'Retail Sale Id 3433',0.00,11797.50,710.00,13845.00,2047.50,'2023-03-14 10:07:08'),(3371,'1','313',1,'Retail Sale Id 3434',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-14 10:07:34'),(3372,'1','313',1,'Retail Sale Id 3435',0.00,3630.00,710.00,4260.00,630.00,'2023-03-14 10:08:07'),(3373,'1','313',1,'Retail Sale Id 3436',0.00,1210.00,710.00,1420.00,210.00,'2023-03-14 10:08:41'),(3374,'1','313',1,'Retail Sale Id 3437',0.00,2420.00,710.00,2840.00,420.00,'2023-03-14 10:09:09'),(3375,'1','313',1,'Retail Sale Id 3438',0.00,5445.00,710.00,6390.00,945.00,'2023-03-14 10:09:44'),(3376,'1','313',1,'Retail Sale Id 3439',0.00,1210.00,710.00,1420.00,210.00,'2023-03-14 10:12:15'),(3377,'1','313',1,'Retail Sale Id 3440',0.00,1210.00,710.00,1420.00,210.00,'2023-03-14 10:13:02'),(3378,'1','313',1,'Retail Sale Id 3441',0.00,1210.00,710.00,1420.00,210.00,'2023-03-14 10:13:53'),(3379,'1','313',1,'Retail Sale Id 3442',0.00,3025.00,710.00,3550.00,525.00,'2023-03-14 10:14:28'),(3380,'1','313',1,'Retail Sale Id 3443',0.00,1210.00,710.00,1420.00,210.00,'2023-03-14 10:14:56'),(3381,'1','313',1,'Retail Sale Id 3444',0.00,4259.20,710.00,4998.40,739.20,'2023-03-14 10:15:37'),(3382,'1','313',1,'Retail Sale Id 3445',0.00,1210.00,710.00,1420.00,210.00,'2023-03-14 10:16:09'),(3383,'1','313',1,'Retail Sale Id 3446',0.00,605.00,710.00,710.00,105.00,'2023-03-14 10:16:38'),(3384,'1','313',1,'Retail Sale Id 3447',0.00,3630.00,710.00,4260.00,630.00,'2023-03-14 10:17:04'),(3385,'1','313',1,'Retail Sale Id 3448',0.00,13310.00,670.00,14740.00,1430.00,'2023-03-14 10:17:41'),(3386,'1','313',1,'Retail Sale Id 3449',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-14 10:20:59'),(3387,'1','313',1,'Retail Sale Id 3450',0.00,2468.40,710.00,2896.80,428.40,'2023-03-14 10:25:32'),(3388,'1','313',1,'Retail Sale Id 3451',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-14 10:26:41'),(3389,'1','313',1,'Retail Sale Id 3452',0.00,5445.00,710.00,6390.00,945.00,'2023-03-14 10:31:00'),(3390,'1','313',1,'Retail Sale Id 3453',0.00,2420.00,710.00,2840.00,420.00,'2023-03-14 10:32:22'),(3391,'1','313',1,'Retail Sale Id 3454',0.00,3630.00,710.00,4260.00,630.00,'2023-03-14 10:33:37'),(3392,'1','313',1,'Retail Sale Id 3455',0.00,605.00,710.00,710.00,105.00,'2023-03-14 10:34:15'),(3393,'1','313',1,'Retail Sale Id 3456',0.00,1815.00,710.00,2130.00,315.00,'2023-03-14 10:34:56'),(3394,'1','313',1,'Retail Sale Id 3457',0.00,2559.15,710.00,3003.30,444.15,'2023-03-14 10:36:58'),(3395,'1','313',1,'Retail Sale Id 3458',0.00,2420.00,710.00,2840.00,420.00,'2023-03-14 10:40:23'),(3396,'1','313',1,'Retail Sale Id 3459',0.00,3630.00,710.00,4260.00,630.00,'2023-03-14 10:41:25'),(3397,'1','313',1,'Retail Sale Id 3460',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-14 10:42:03'),(3398,'1','313',1,'Retail Sale Id 3461',0.00,1210.00,710.00,1420.00,210.00,'2023-03-14 10:43:34'),(3399,'1','313',1,'Retail Sale Id 3462',0.00,1210.00,710.00,1420.00,210.00,'2023-03-14 10:44:54'),(3400,'1','313',1,'Retail Sale Id 3464',0.00,2426.05,710.00,2847.10,421.05,'2023-03-14 10:48:06'),(3401,'1','313',1,'Retail Sale Id 3465',0.00,3025.00,710.00,3550.00,525.00,'2023-03-14 10:49:14'),(3402,'1','313',1,'Retail Sale Id 3466',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-14 10:49:51'),(3403,'1','313',1,'Retail Sale Id 3468',0.00,13612.50,710.00,15975.00,2362.50,'2023-03-14 10:56:51'),(3404,'1','313',1,'Retail Sale Id 3469',0.00,1833.15,710.00,2151.30,318.15,'2023-03-14 11:02:27'),(3405,'1','313',1,'Retail Sale Id 3470',0.00,36905.00,670.00,40870.00,3965.00,'2023-03-14 11:11:02'),(3406,'1','313',1,'Retail Sale Id 3471',0.00,1815.00,710.00,2130.00,315.00,'2023-03-14 11:12:56'),(3407,'1','313',1,'Retail Sale Id 3473',0.00,1234.20,710.00,1448.40,214.20,'2023-03-14 11:15:37'),(3408,'1','313',1,'Retail Sale Id 3474',0.00,3835.70,710.00,4501.40,665.70,'2023-03-14 11:16:58'),(3409,'1','313',1,'Retail Sale Id 3475',0.00,1234.20,710.00,1448.40,214.20,'2023-03-14 11:17:53'),(3410,'1','313',1,'Retail Sale Id 3476',0.00,4259.20,710.00,4998.40,739.20,'2023-03-14 11:18:54'),(3411,'1','313',1,'Retail Sale Id 3477',0.00,4235.00,710.00,4970.00,735.00,'2023-03-14 11:19:59'),(3412,'1','313',1,'Retail Sale Id 3478',0.00,853.05,710.00,1001.10,148.05,'2023-03-14 11:20:45'),(3413,'1','313',1,'Retail Sale Id 3479',0.00,3406.15,710.00,3997.30,591.15,'2023-03-14 11:21:59'),(3414,'1','313',1,'Retail Sale Id 3481',0.00,605.00,710.00,710.00,105.00,'2023-03-14 11:22:46'),(3415,'1','313',1,'Retail Sale Id 3482',0.00,2117.50,710.00,2485.00,367.50,'2023-03-14 11:23:27'),(3416,'1','313',1,'Retail Sale Id 3483',0.00,3025.00,710.00,3550.00,525.00,'2023-03-14 11:24:14'),(3417,'1','313',1,'Retail Sale Id 3484',0.00,1815.00,710.00,2130.00,315.00,'2023-03-14 11:24:56'),(3418,'1','313',1,'Retail Sale Id 3485',0.00,605.00,710.00,710.00,105.00,'2023-03-14 11:25:41'),(3419,'1','313',1,'Retail Sale Id 3486',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-14 11:26:13'),(3420,'1','313',1,'Retail Sale Id 3487',0.00,853.05,710.00,1001.10,148.05,'2023-03-14 11:32:20'),(3421,'1','313',1,'Retail Sale Id 3488',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-14 11:35:06'),(3422,'1','313',1,'Retail Sale Id 3489',0.00,1815.00,710.00,2130.00,315.00,'2023-03-14 11:36:13'),(3423,'1','313',1,'Retail Sale Id 3490',0.00,1815.00,710.00,2130.00,315.00,'2023-03-14 11:38:30'),(3424,'1','313',1,'Retail Sale Id 3491',0.00,1210.00,710.00,1420.00,210.00,'2023-03-14 11:39:48'),(3425,'1','313',1,'Retail Sale Id 3492',0.00,1210.00,710.00,1420.00,210.00,'2023-03-14 11:40:37'),(3426,'1','313',1,'Retail Sale Id 3493',0.00,3025.00,710.00,3550.00,525.00,'2023-03-14 11:42:59'),(3427,'1','313',1,'Retail Sale Id 3494',0.00,12100.00,710.00,14200.00,2100.00,'2023-03-14 11:44:25'),(3428,'1','313',1,'Retail Sale Id 3495',0.00,853.05,710.00,1001.10,148.05,'2023-03-14 11:46:04'),(3429,'1','313',1,'Retail Sale Id 3496',0.00,1815.00,710.00,2130.00,315.00,'2023-03-14 11:46:43'),(3430,'1','313',1,'Retail Sale Id 3498',0.00,3025.00,710.00,3550.00,525.00,'2023-03-14 11:49:57'),(3431,'1','313',1,'Retail Sale Id 3499',0.00,5445.00,710.00,6390.00,945.00,'2023-03-14 11:51:12'),(3432,'1','313',1,'Retail Sale Id 3500',0.00,35719.20,670.00,39556.80,3837.60,'2023-03-14 11:58:42'),(3433,'1','313',1,'Retail Sale Id 3501',0.00,3630.00,710.00,4260.00,630.00,'2023-03-14 11:59:52'),(3434,'1','313',1,'Retail Sale Id 3503',0.00,3025.00,710.00,3550.00,525.00,'2023-03-14 12:01:17'),(3435,'1','313',1,'Retail Sale Id 3504',0.00,2420.00,710.00,2840.00,420.00,'2023-03-14 12:02:04'),(3436,'1','313',1,'Retail Sale Id 3505',0.00,1815.00,710.00,2130.00,315.00,'2023-03-14 12:06:43'),(3437,'1','313',1,'Retail Sale Id 3506',0.00,14217.50,710.00,16685.00,2467.50,'2023-03-14 12:10:21'),(3438,'1','313',1,'Retail Sale Id 3507',0.00,4840.00,710.00,5680.00,840.00,'2023-03-14 12:17:41'),(3439,'1','313',1,'Retail Sale Id 3508',0.00,605.00,710.00,710.00,105.00,'2023-03-14 12:19:04'),(3440,'1','313',1,'Retail Sale Id 3510',0.00,3025.00,710.00,3550.00,525.00,'2023-03-14 12:21:40'),(3441,'1','313',1,'Retail Sale Id 3511',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-14 12:23:25'),(3442,'1','313',1,'Retail Sale Id 3512',0.00,853.05,710.00,1001.10,148.05,'2023-03-14 12:25:09'),(3443,'1','313',1,'Retail Sale Id 3513',0.00,1210.00,710.00,1420.00,210.00,'2023-03-14 12:27:17'),(3444,'1','313',1,'Retail Sale Id 3514',0.00,641.30,710.00,752.60,111.30,'2023-03-14 12:28:53'),(3445,'1','313',1,'Retail Sale Id 3515',0.00,4235.00,710.00,4970.00,735.00,'2023-03-14 12:37:41'),(3446,'1','313',1,'Retail Sale Id 3516',0.00,1210.00,710.00,1420.00,210.00,'2023-03-14 12:39:55'),(3447,'1','313',1,'Retail Sale Id 3518',0.00,99825.00,670.00,110550.00,10725.00,'2023-03-14 12:47:03'),(3448,'1','313',1,'Retail Sale Id 3519',0.00,3630.00,710.00,4260.00,630.00,'2023-03-14 12:47:52'),(3449,'1','313',1,'Retail Sale Id 3520',0.00,3932.50,710.00,4615.00,682.50,'2023-03-14 12:48:49'),(3450,'1','313',1,'Retail Sale Id 3521',0.00,1815.00,710.00,2130.00,315.00,'2023-03-14 12:50:16'),(3451,'1','313',1,'Retail Sale Id 3522',0.00,1815.00,710.00,2130.00,315.00,'2023-03-14 12:54:01'),(3452,'1','313',1,'Retail Sale Id 3523',0.00,1210.00,710.00,1420.00,210.00,'2023-03-14 13:05:03'),(3453,'1','313',1,'Retail Sale Id 3524',0.00,5445.00,710.00,6390.00,945.00,'2023-03-14 13:06:30'),(3454,'1','313',1,'Retail Sale Id 3525',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-14 13:07:25'),(3455,'1','313',1,'Retail Sale Id 3526',0.00,2420.00,710.00,2840.00,420.00,'2023-03-14 13:14:08'),(3456,'1','313',1,'Retail Sale Id 3527',0.00,35701.05,670.00,39536.70,3835.65,'2023-03-14 13:16:36'),(3457,'1','313',1,'Retail Sale Id 3528',0.00,5965.30,710.00,7000.60,1035.30,'2023-03-14 13:19:06'),(3458,'1','313',1,'Retail Sale Id 3529',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-14 13:21:18'),(3459,'1','313',1,'Retail Sale Id 3530',0.00,1210.00,710.00,1420.00,210.00,'2023-03-14 13:22:30'),(3460,'1','313',1,'Retail Sale Id 3531',0.00,605.00,710.00,710.00,105.00,'2023-03-14 13:23:29'),(3461,'1','313',1,'Retail Sale Id 3532',0.00,3025.00,710.00,3550.00,525.00,'2023-03-14 13:25:01'),(3462,'1','313',1,'Retail Sale Id 3533',0.00,1210.00,710.00,1420.00,210.00,'2023-03-14 13:26:04'),(3463,'1','313',1,'Retail Sale Id 3534',0.00,1815.00,710.00,2130.00,315.00,'2023-03-14 13:27:33'),(3464,'1','313',1,'Retail Sale Id 3535',0.00,605.00,710.00,710.00,105.00,'2023-03-14 13:29:13'),(3465,'1','313',1,'Retail Sale Id 3536',0.00,605.00,710.00,710.00,105.00,'2023-03-14 13:30:04'),(3466,'1','313',1,'Retail Sale Id 3537',0.00,1210.00,710.00,1420.00,210.00,'2023-03-14 13:32:56'),(3467,'1','313',1,'Retail Sale Id 3538',0.00,3025.00,710.00,3550.00,525.00,'2023-03-14 13:35:21'),(3468,'1','313',1,'Retail Sale Id 3539',0.00,1815.00,710.00,2130.00,315.00,'2023-03-14 13:37:46'),(3469,'1','313',1,'Retail Sale Id 3541',0.00,1210.00,710.00,1420.00,210.00,'2023-03-14 13:41:47'),(3470,'1','313',1,'Retail Sale Id 3542',0.00,4840.00,710.00,5680.00,840.00,'2023-03-14 13:44:00'),(3471,'1','313',1,'Retail Sale Id 3543',0.00,3630.00,710.00,4260.00,630.00,'2023-03-14 13:48:05'),(3472,'1','313',1,'Retail Sale Id 3544',0.00,2420.00,710.00,2840.00,420.00,'2023-03-14 13:48:50'),(3473,'1','313',1,'Retail Sale Id 3546',0.00,3025.00,710.00,3550.00,525.00,'2023-03-14 13:50:19'),(3474,'1','313',1,'Retail Sale Id 3547',0.00,3630.00,710.00,4260.00,630.00,'2023-03-14 13:52:37'),(3475,'1','313',1,'Retail Sale Id 3549',0.00,1234.20,710.00,1448.40,214.20,'2023-03-14 13:55:37'),(3476,'1','313',1,'Retail Sale Id 3550',0.00,3152.05,710.00,3699.10,547.05,'2023-03-14 13:56:53'),(3477,'1','313',1,'Retail Sale Id 3551',0.00,1875.50,710.00,2201.00,325.50,'2023-03-14 14:00:27'),(3478,'1','313',1,'Retail Sale Id 3552',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-14 14:01:36'),(3479,'1','313',1,'Retail Sale Id 3553',0.00,2420.00,710.00,2840.00,420.00,'2023-03-14 14:02:59'),(3480,'1','313',1,'Retail Sale Id 3554',0.00,4235.00,710.00,4970.00,735.00,'2023-03-14 14:04:52'),(3481,'1','313',1,'Retail Sale Id 3555',0.00,3025.00,710.00,3550.00,525.00,'2023-03-14 14:07:27'),(3482,'1','313',1,'Retail Sale Id 3556',0.00,605.00,710.00,710.00,105.00,'2023-03-14 14:19:14'),(3483,'1','313',1,'Retail Sale Id 3557',0.00,3630.00,710.00,4260.00,630.00,'2023-03-14 14:20:18'),(3484,'1','313',1,'Retail Sale Id 3558',0.00,1815.00,710.00,2130.00,315.00,'2023-03-14 14:22:13'),(3485,'1','313',1,'Retail Sale Id 3559',0.00,605.00,710.00,710.00,105.00,'2023-03-14 16:51:25'),(3486,'1','313',1,'Retail Sale Id 3560',0.00,3630.00,710.00,4260.00,630.00,'2023-03-14 16:54:10'),(3487,'1','313',1,'Retail Sale Id 3561',0.00,605.00,710.00,710.00,105.00,'2023-03-14 16:55:15'),(3488,'1','313',1,'Retail Sale Id 3562',0.00,3025.00,710.00,3550.00,525.00,'2023-03-14 16:56:14'),(3489,'1','313',1,'Retail Sale Id 3563',0.00,1815.00,710.00,2130.00,315.00,'2023-03-14 17:13:08'),(3490,'1','313',1,'Return of Retail Sale Id 3408',30250.00,0.00,710.00,-35500.00,-5250.00,'2023-03-14 17:35:31'),(3491,'1','313',1,'Return of Retail Sale Id 3468',13612.50,0.00,710.00,-15975.00,-2362.50,'2023-03-14 17:37:12'),(3492,'1','313',1,'Retail Sale Id 3564',0.00,171941.00,710.00,201782.00,29841.00,'2023-03-14 17:47:36'),(3493,'1','313',1,'Retail Sale Id 3565',0.00,221296.90,670.00,245072.60,23775.70,'2023-03-14 17:50:06'),(3494,'1','313',1,'Return of Retail Sale Id 3544',2420.00,0.00,710.00,-2840.00,-420.00,'2023-03-14 18:03:31'),(3495,'1','313',1,'Retail Sale Id 3566',0.00,2159.85,710.00,2534.70,374.85,'2023-03-14 18:04:18'),(3496,'1','313',1,'Return of Retail Sale Id 3388',18755.00,0.00,670.00,-20770.00,-2015.00,'2023-03-14 18:06:08'),(3497,'1','313',1,'Retail Sale Id 3567',0.00,18319.40,670.00,20287.60,1968.20,'2023-03-14 18:07:49'),(3498,'1','313',1,'Retail Sale Id 3568',0.00,4235.00,670.00,4690.00,455.00,'2023-03-15 08:14:05'),(3499,'1','313',1,'Retail Sale Id 3569',0.00,5445.00,710.00,6390.00,945.00,'2023-03-15 08:15:48'),(3500,'1','313',1,'Retail Sale Id 3570',0.00,2559.15,710.00,3003.30,444.15,'2023-03-15 08:16:31'),(3501,'1','313',1,'Retail Sale Id 3571',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-15 08:17:50'),(3502,'1','313',1,'Retail Sale Id 3572',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-15 08:19:48'),(3503,'1','313',1,'Retail Sale Id 3573',0.00,4235.00,710.00,4970.00,735.00,'2023-03-15 08:20:58'),(3504,'1','313',1,'Retail Sale Id 3574',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 08:22:00'),(3505,'1','313',1,'Retail Sale Id 3575',0.00,605.00,710.00,710.00,105.00,'2023-03-15 08:23:16'),(3506,'1','313',1,'Retail Sale Id 3576',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-15 08:24:57'),(3507,'1','313',1,'Retail Sale Id 3577',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-15 08:26:35'),(3508,'1','313',1,'Retail Sale Id 3578',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-15 08:27:27'),(3509,'1','313',1,'Retail Sale Id 3579',0.00,36905.00,670.00,40870.00,3965.00,'2023-03-15 08:28:17'),(3510,'1','313',1,'Retail Sale Id 3580',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 08:30:26'),(3511,'1','313',1,'Retail Sale Id 3581',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-15 08:31:31'),(3512,'1','313',1,'Retail Sale Id 3582',0.00,3630.00,710.00,4260.00,630.00,'2023-03-15 08:32:34'),(3513,'1','313',1,'Retail Sale Id 3583',0.00,605.00,710.00,710.00,105.00,'2023-03-15 08:33:41'),(3514,'1','313',1,'Retail Sale Id 3584',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 08:35:24'),(3515,'1','313',1,'Retail Sale Id 3585',0.00,7865.00,710.00,9230.00,1365.00,'2023-03-15 08:38:23'),(3516,'1','313',1,'Retail Sale Id 3586',0.00,2559.15,710.00,3003.30,444.15,'2023-03-15 08:39:32'),(3517,'1','313',1,'Retail Sale Id 3587',0.00,4235.00,710.00,4970.00,735.00,'2023-03-15 08:41:26'),(3518,'1','313',1,'Retail Sale Id 3588',0.00,605.00,710.00,710.00,105.00,'2023-03-15 08:42:52'),(3519,'1','313',1,'Retail Sale Id 3589',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-15 08:56:25'),(3520,'1','313',1,'Retail Sale Id 3590',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 08:58:00'),(3521,'1','313',1,'Retail Sale Id 3591',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 08:58:53'),(3522,'1','313',1,'Retail Sale Id 3593',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 09:04:24'),(3523,'1','313',1,'Retail Sale Id 3594',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 09:05:46'),(3524,'1','313',1,'Retail Sale Id 3595',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 09:08:40'),(3525,'1','313',1,'Retail Sale Id 3596',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 09:10:51'),(3526,'1','313',1,'Retail Sale Id 3597',0.00,641.30,710.00,752.60,111.30,'2023-03-15 09:12:14'),(3527,'1','313',1,'Retail Sale Id 3598',0.00,5445.00,710.00,6390.00,945.00,'2023-03-15 09:14:03'),(3528,'1','313',1,'Retail Sale Id 3599',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 09:14:43'),(3529,'1','313',1,'Retail Sale Id 3600',0.00,3025.00,710.00,3550.00,525.00,'2023-03-15 09:18:10'),(3530,'1','313',1,'Retail Sale Id 3601',0.00,2420.00,710.00,2840.00,420.00,'2023-03-15 09:21:01'),(3531,'1','313',1,'Retail Sale Id 3602',0.00,605.00,710.00,710.00,105.00,'2023-03-15 09:21:33'),(3532,'1','313',1,'Retail Sale Id 3603',0.00,4235.00,710.00,4970.00,735.00,'2023-03-15 09:23:18'),(3533,'1','313',1,'Retail Sale Id 3604',0.00,3406.15,710.00,3997.30,591.15,'2023-03-15 09:24:11'),(3534,'1','313',1,'Retail Sale Id 3605',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 09:26:38'),(3535,'1','313',1,'Retail Sale Id 3606',0.00,4235.00,710.00,4970.00,735.00,'2023-03-15 09:28:44'),(3536,'1','313',1,'Retail Sale Id 3607',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-15 09:30:29'),(3537,'1','313',1,'Retail Sale Id 3608',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-15 09:31:37'),(3538,'1','313',1,'Retail Sale Id 3609',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-15 09:32:45'),(3539,'1','313',1,'Retail Sale Id 3610',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 09:33:46'),(3540,'1','313',1,'Retail Sale Id 3611',0.00,3630.00,710.00,4260.00,630.00,'2023-03-15 09:36:15'),(3541,'1','313',1,'Retail Sale Id 3612',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 09:37:37'),(3542,'1','313',1,'Retail Sale Id 3613',0.00,3932.50,710.00,4615.00,682.50,'2023-03-15 09:39:44'),(3543,'1','313',1,'Retail Sale Id 3614',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-15 09:40:35'),(3544,'1','313',1,'Retail Sale Id 3615',0.00,2420.00,710.00,2840.00,420.00,'2023-03-15 09:43:29'),(3545,'1','313',1,'Retail Sale Id 3616',0.00,4235.00,710.00,4970.00,735.00,'2023-03-15 09:46:29'),(3546,'1','313',1,'Retail Sale Id 3617',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 09:47:21'),(3547,'1','313',1,'Retail Sale Id 3618',0.00,2420.00,710.00,2840.00,420.00,'2023-03-15 09:48:37'),(3548,'1','313',1,'Retail Sale Id 3619',0.00,3630.00,710.00,4260.00,630.00,'2023-03-15 09:50:17'),(3549,'1','313',1,'Retail Sale Id 3620',0.00,14520.00,670.00,16080.00,1560.00,'2023-03-15 09:51:13'),(3550,'1','313',1,'Retail Sale Id 3621',0.00,2420.00,710.00,2840.00,420.00,'2023-03-15 09:52:26'),(3551,'1','313',1,'Retail Sale Id 3622',0.00,605.00,710.00,710.00,105.00,'2023-03-15 09:53:38'),(3552,'1','313',1,'Retail Sale Id 3623',0.00,1276.55,710.00,1498.10,221.55,'2023-03-15 09:54:58'),(3553,'1','313',1,'Retail Sale Id 3624',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-15 09:55:25'),(3554,'1','313',1,'Retail Sale Id 3625',0.00,2420.00,710.00,2840.00,420.00,'2023-03-15 09:57:51'),(3555,'1','313',1,'Retail Sale Id 3626',0.00,12705.00,710.00,14910.00,2205.00,'2023-03-15 10:01:37'),(3556,'1','313',1,'Retail Sale Id 3627',0.00,12100.00,710.00,14200.00,2100.00,'2023-03-15 10:03:41'),(3557,'1','313',1,'Return of Retail Sale Id 3627',12100.00,0.00,710.00,-14200.00,-2100.00,'2023-03-15 10:03:57'),(3558,'1','313',1,'Retail Sale Id 3628',0.00,1706.10,710.00,2002.20,296.10,'2023-03-15 10:04:55'),(3559,'1','313',1,'Retail Sale Id 3629',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 10:06:13'),(3560,'1','313',1,'Retail Sale Id 3630',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 10:07:42'),(3561,'1','313',1,'Retail Sale Id 3631',0.00,605.00,710.00,710.00,105.00,'2023-03-15 10:09:10'),(3562,'1','313',1,'Retail Sale Id 3633',0.00,2420.00,710.00,2840.00,420.00,'2023-03-15 10:11:40'),(3563,'1','313',1,'Return of Retail Sale Id 3624',7260.00,0.00,710.00,-8520.00,-1260.00,'2023-03-15 10:12:50'),(3564,'1','313',1,'Retail Sale Id 3634',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 10:13:59'),(3565,'1','313',1,'Retail Sale Id 3635',0.00,2420.00,710.00,2840.00,420.00,'2023-03-15 10:16:00'),(3566,'1','313',1,'Return of Retail Sale Id 3635',2420.00,0.00,710.00,-2840.00,-420.00,'2023-03-15 10:17:14'),(3567,'1','313',1,'Retail Sale Id 3636',0.00,2305.05,710.00,2705.10,400.05,'2023-03-15 10:17:47'),(3568,'1','313',1,'Retail Sale Id 3637',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-15 10:20:19'),(3569,'1','313',1,'Retail Sale Id 3638',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 10:21:43'),(3570,'1','313',1,'Retail Sale Id 3639',0.00,3025.00,710.00,3550.00,525.00,'2023-03-15 10:23:28'),(3571,'1','313',1,'Retail Sale Id 3640',0.00,2559.15,710.00,3003.30,444.15,'2023-03-15 10:24:50'),(3572,'1','313',1,'Retail Sale Id 3641',0.00,2559.15,710.00,3003.30,444.15,'2023-03-15 10:26:54'),(3573,'1','313',1,'Retail Sale Id 3642',0.00,60500.00,670.00,67000.00,6500.00,'2023-03-15 10:32:33'),(3574,'1','313',1,'Retail Sale Id 3643',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-15 10:33:26'),(3575,'1','313',1,'Retail Sale Id 3644',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 10:34:18'),(3576,'1','313',1,'Retail Sale Id 3645',0.00,3025.00,710.00,3550.00,525.00,'2023-03-15 10:35:10'),(3577,'1','313',1,'Retail Sale Id 3646',0.00,3630.00,710.00,4260.00,630.00,'2023-03-15 10:36:27'),(3578,'1','313',1,'Retail Sale Id 3647',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 10:37:55'),(3579,'1','313',1,'Retail Sale Id 3648',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 10:38:39'),(3580,'1','313',1,'Retail Sale Id 3649',0.00,605.00,710.00,710.00,105.00,'2023-03-15 10:40:59'),(3581,'1','313',1,'Retail Sale Id 3650',0.00,4840.00,710.00,5680.00,840.00,'2023-03-15 10:41:45'),(3582,'1','313',1,'Retail Sale Id 3651',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 10:43:56'),(3583,'1','313',1,'Retail Sale Id 3652',0.00,12100.00,710.00,14200.00,2100.00,'2023-03-15 10:44:58'),(3584,'1','313',1,'Retail Sale Id 3653',0.00,1512.50,710.00,1775.00,262.50,'2023-03-15 10:45:54'),(3585,'1','313',1,'Retail Sale Id 3654',0.00,2420.00,710.00,2840.00,420.00,'2023-03-15 10:47:06'),(3586,'1','313',1,'Retail Sale Id 3655',0.00,8772.50,710.00,10295.00,1522.50,'2023-03-15 10:49:05'),(3587,'1','313',1,'Retail Sale Id 3656',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 10:50:57'),(3588,'1','313',1,'Retail Sale Id 3657',0.00,3630.00,710.00,4260.00,630.00,'2023-03-15 10:52:17'),(3589,'1','313',1,'Retail Sale Id 3658',0.00,4235.00,710.00,4970.00,735.00,'2023-03-15 10:53:18'),(3590,'1','313',1,'Retail Sale Id 3659',0.00,90750.00,670.00,100500.00,9750.00,'2023-03-15 10:54:34'),(3591,'1','313',1,'Retail Sale Id 3660',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-15 11:00:26'),(3592,'1','313',1,'Retail Sale Id 3661',0.00,4840.00,710.00,5680.00,840.00,'2023-03-15 11:03:02'),(3593,'1','313',1,'Retail Sale Id 3662',0.00,605.00,710.00,710.00,105.00,'2023-03-15 11:05:22'),(3594,'1','313',1,'Retail Sale Id 3664',0.00,3025.00,710.00,3550.00,525.00,'2023-03-15 11:06:57'),(3595,'1','313',1,'Retail Sale Id 3665',0.00,69575.00,670.00,77050.00,7475.00,'2023-03-15 11:09:08'),(3596,'1','313',1,'Retail Sale Id 3666',0.00,16637.50,710.00,19525.00,2887.50,'2023-03-15 11:11:45'),(3597,'1','313',1,'Retail Sale Id 3667',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 11:14:09'),(3598,'1','313',1,'Retail Sale Id 3668',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 11:16:13'),(3599,'1','313',1,'Retail Sale Id 3669',0.00,2420.00,710.00,2840.00,420.00,'2023-03-15 11:20:21'),(3600,'1','313',1,'Retail Sale Id 3670',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-15 11:24:51'),(3601,'1','313',1,'Retail Sale Id 3672',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 11:32:43'),(3602,'1','313',1,'Retail Sale Id 3674',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-15 11:36:29'),(3603,'1','313',1,'Retail Sale Id 3675',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 11:37:52'),(3604,'1','313',1,'Retail Sale Id 3676',0.00,4235.00,710.00,4970.00,735.00,'2023-03-15 11:38:52'),(3605,'1','313',1,'Retail Sale Id 3677',0.00,2420.00,710.00,2840.00,420.00,'2023-03-15 11:40:43'),(3606,'1','313',1,'Retail Sale Id 3678',0.00,3025.00,710.00,3550.00,525.00,'2023-03-15 11:42:02'),(3607,'1','313',1,'Retail Sale Id 3679',0.00,605.00,710.00,710.00,105.00,'2023-03-15 11:44:40'),(3608,'1','313',1,'Retail Sale Id 3680',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-15 11:51:43'),(3609,'1','313',1,'Retail Sale Id 3681',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-15 11:52:47'),(3610,'1','313',1,'Retail Sale Id 3682',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 11:56:19'),(3611,'1','313',1,'Retail Sale Id 3683',0.00,24200.00,670.00,26800.00,2600.00,'2023-03-15 12:04:16'),(3612,'1','313',1,'Retail Sale Id 3684',0.00,1833.15,710.00,2151.30,318.15,'2023-03-15 12:06:12'),(3613,'1','313',1,'Retail Sale Id 3685',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 12:09:13'),(3614,'1','313',1,'Retail Sale Id 3686',0.00,1875.50,710.00,2201.00,325.50,'2023-03-15 12:11:16'),(3615,'1','313',1,'Retail Sale Id 3688',0.00,4235.00,710.00,4970.00,735.00,'2023-03-15 12:13:20'),(3616,'1','313',1,'Retail Sale Id 3689',0.00,3025.00,710.00,3550.00,525.00,'2023-03-15 12:14:34'),(3617,'1','313',1,'Retail Sale Id 3690',0.00,4235.00,710.00,4970.00,735.00,'2023-03-15 12:16:13'),(3618,'1','313',1,'Retail Sale Id 3691',0.00,3025.00,710.00,3550.00,525.00,'2023-03-15 12:19:15'),(3619,'1','313',1,'Retail Sale Id 3692',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 12:22:28'),(3620,'1','313',1,'Retail Sale Id 3693',0.00,2722.50,710.00,3195.00,472.50,'2023-03-15 12:23:12'),(3621,'1','313',1,'Return of Retail Sale Id 3693',2722.50,0.00,710.00,-3195.00,-472.50,'2023-03-15 12:26:45'),(3622,'1','313',1,'Retail Sale Id 3694',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-15 12:27:45'),(3623,'1','313',1,'Retail Sale Id 3695',0.00,2420.00,710.00,2840.00,420.00,'2023-03-15 12:29:15'),(3624,'1','313',1,'Retail Sale Id 3696',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-15 12:35:06'),(3625,'1','313',1,'Retail Sale Id 3697',0.00,4840.00,710.00,5680.00,840.00,'2023-03-15 12:42:36'),(3626,'1','313',1,'Retail Sale Id 3699',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 12:44:23'),(3627,'1','313',1,'Retail Sale Id 3700',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-15 12:47:09'),(3628,'1','313',1,'Retail Sale Id 3701',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 12:47:57'),(3629,'1','313',1,'Retail Sale Id 3702',0.00,3630.00,710.00,4260.00,630.00,'2023-03-15 12:50:01'),(3630,'1','313',1,'Retail Sale Id 3703',0.00,605.00,710.00,710.00,105.00,'2023-03-15 12:51:10'),(3631,'1','313',1,'Retail Sale Id 3706',0.00,3025.00,710.00,3550.00,525.00,'2023-03-15 12:55:32'),(3632,'1','313',1,'Retail Sale Id 3707',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 12:57:20'),(3633,'1','313',1,'Retail Sale Id 3708',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 12:59:40'),(3634,'1','313',1,'Retail Sale Id 3709',0.00,2420.00,710.00,2840.00,420.00,'2023-03-15 13:01:29'),(3635,'1','313',1,'Retail Sale Id 3710',0.00,5445.00,710.00,6390.00,945.00,'2023-03-15 13:02:49'),(3636,'1','313',1,'Retail Sale Id 3711',0.00,3025.00,710.00,3550.00,525.00,'2023-03-15 13:07:39'),(3637,'1','313',1,'Retail Sale Id 3712',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 13:11:53'),(3638,'1','313',1,'Retail Sale Id 3713',0.00,3025.00,710.00,3550.00,525.00,'2023-03-15 13:19:44'),(3639,'1','313',1,'Retail Sale Id 3714',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-15 13:32:37'),(3640,'1','313',1,'Retail Sale Id 3715',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 13:41:40'),(3641,'1','313',1,'Retail Sale Id 3716',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 13:54:52'),(3642,'1','313',1,'Retail Sale Id 3717',0.00,641.30,710.00,752.60,111.30,'2023-03-15 13:57:11'),(3643,'1','313',1,'Retail Sale Id 3718',0.00,4513.30,710.00,5296.60,783.30,'2023-03-15 13:58:22'),(3644,'1','313',1,'Retail Sale Id 3719',0.00,14520.00,710.00,17040.00,2520.00,'2023-03-15 14:00:33'),(3645,'1','313',1,'Retail Sale Id 3720',0.00,605.00,710.00,710.00,105.00,'2023-03-15 14:07:47'),(3646,'1','313',1,'Retail Sale Id 3721',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-15 14:08:59'),(3647,'1','313',1,'Retail Sale Id 3722',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-15 14:10:48'),(3648,'1','313',1,'Retail Sale Id 3723',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 14:17:03'),(3649,'1','313',1,'Retail Sale Id 3724',0.00,907.50,710.00,1065.00,157.50,'2023-03-15 14:18:21'),(3650,'1','313',1,'Retail Sale Id 3725',0.00,27225.00,670.00,30150.00,2925.00,'2023-03-15 14:21:26'),(3651,'1','313',1,'Retail Sale Id 3726',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 14:22:54'),(3652,'1','313',1,'Retail Sale Id 3727',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-15 14:25:36'),(3653,'1','313',1,'Retail Sale Id 3728',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 14:27:22'),(3654,'1','313',1,'Retail Sale Id 3729',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-15 14:29:10'),(3655,'1','313',1,'Retail Sale Id 3731',0.00,853.05,710.00,1001.10,148.05,'2023-03-15 14:31:49'),(3656,'1','313',1,'Retail Sale Id 3732',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 14:32:46'),(3657,'1','313',1,'Retail Sale Id 3733',0.00,605.00,710.00,710.00,105.00,'2023-03-15 14:34:04'),(3658,'1','313',1,'Retail Sale Id 3734',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 14:35:11'),(3659,'1','313',1,'Retail Sale Id 3735',0.00,641.30,710.00,752.60,111.30,'2023-03-15 14:36:20'),(3660,'1','313',1,'Retail Sale Id 3736',0.00,2117.50,710.00,2485.00,367.50,'2023-03-15 14:38:03'),(3661,'1','313',1,'Retail Sale Id 3737',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 14:39:09'),(3662,'1','313',1,'Retail Sale Id 3738',0.00,3630.00,710.00,4260.00,630.00,'2023-03-15 14:39:57'),(3663,'1','313',1,'Retail Sale Id 3739',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 14:41:07'),(3664,'1','313',1,'Retail Sale Id 3740',0.00,605.00,710.00,710.00,105.00,'2023-03-15 14:42:13'),(3665,'1','313',1,'Retail Sale Id 3741',0.00,605.00,710.00,710.00,105.00,'2023-03-15 14:43:26'),(3666,'1','313',1,'Retail Sale Id 3742',0.00,3630.00,710.00,4260.00,630.00,'2023-03-15 14:45:02'),(3667,'1','313',1,'Retail Sale Id 3743',0.00,641.30,710.00,752.60,111.30,'2023-03-15 14:46:47'),(3668,'1','313',1,'Retail Sale Id 3744',0.00,4235.00,710.00,4970.00,735.00,'2023-03-15 14:48:01'),(3669,'1','313',1,'Retail Sale Id 3745',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 14:55:07'),(3670,'1','313',1,'Retail Sale Id 3746',0.00,6818.35,710.00,8001.70,1183.35,'2023-03-15 14:58:31'),(3671,'1','313',1,'Retail Sale Id 3747',0.00,641.30,710.00,752.60,111.30,'2023-03-15 15:06:39'),(3672,'1','313',1,'Retail Sale Id 3748',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-15 15:07:45'),(3673,'1','313',1,'Retail Sale Id 3749',0.00,2420.00,710.00,2840.00,420.00,'2023-03-15 15:09:10'),(3674,'1','313',1,'Retail Sale Id 3750',0.00,605.00,710.00,710.00,105.00,'2023-03-15 15:09:57'),(3675,'1','313',1,'Retail Sale Id 3751',0.00,641.30,710.00,752.60,111.30,'2023-03-15 15:13:22'),(3676,'1','313',1,'Retail Sale Id 3752',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 15:14:42'),(3677,'1','313',1,'Retail Sale Id 3753',0.00,2129.60,710.00,2499.20,369.60,'2023-03-15 15:17:31'),(3678,'1','313',1,'Retail Sale Id 3754',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 15:18:39'),(3679,'1','313',1,'Retail Sale Id 3755',0.00,1706.10,710.00,2002.20,296.10,'2023-03-15 15:19:51'),(3680,'1','313',1,'Retail Sale Id 3756',0.00,3025.00,710.00,3550.00,525.00,'2023-03-15 15:20:39'),(3681,'1','313',1,'Retail Sale Id 3757',0.00,605.00,710.00,710.00,105.00,'2023-03-15 15:21:45'),(3682,'1','313',1,'Retail Sale Id 3758',0.00,1276.55,710.00,1498.10,221.55,'2023-03-15 15:23:07'),(3683,'1','313',1,'Retail Sale Id 3759',0.00,3630.00,710.00,4260.00,630.00,'2023-03-15 15:23:55'),(3684,'1','313',1,'Retail Sale Id 3760',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 15:25:33'),(3685,'1','313',1,'Retail Sale Id 3761',0.00,1276.55,710.00,1498.10,221.55,'2023-03-15 15:26:57'),(3686,'1','313',1,'Retail Sale Id 3762',0.00,66550.00,710.00,78100.00,11550.00,'2023-03-15 15:28:11'),(3687,'1','313',1,'Return of Retail Sale Id 3762',66550.00,0.00,710.00,-78100.00,-11550.00,'2023-03-15 15:28:50'),(3688,'1','313',1,'Retail Sale Id 3763',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-15 15:29:30'),(3689,'1','313',1,'Retail Sale Id 3764',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 15:31:14'),(3690,'1','313',1,'Retail Sale Id 3765',0.00,3630.00,710.00,4260.00,630.00,'2023-03-15 15:32:11'),(3691,'1','313',1,'Retail Sale Id 3766',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 15:33:17'),(3692,'1','313',1,'Retail Sale Id 3767',0.00,1536.70,710.00,1803.40,266.70,'2023-03-15 15:35:31'),(3693,'1','313',1,'Retail Sale Id 3768',0.00,4235.00,710.00,4970.00,735.00,'2023-03-15 15:37:34'),(3694,'1','313',1,'Retail Sale Id 3769',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 15:39:11'),(3695,'1','313',1,'Retail Sale Id 3770',0.00,5445.00,710.00,6390.00,945.00,'2023-03-15 15:41:06'),(3696,'1','313',1,'Retail Sale Id 3771',0.00,853.05,710.00,1001.10,148.05,'2023-03-15 15:42:16'),(3697,'1','313',1,'Retail Sale Id 3772',0.00,4235.00,710.00,4970.00,735.00,'2023-03-15 15:43:15'),(3698,'1','313',1,'Retail Sale Id 3773',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-15 15:45:27'),(3699,'1','313',1,'Retail Sale Id 3774',0.00,3025.00,710.00,3550.00,525.00,'2023-03-15 15:47:24'),(3700,'1','313',1,'Retail Sale Id 3775',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 15:49:18'),(3701,'1','313',1,'Retail Sale Id 3776',0.00,605.00,710.00,710.00,105.00,'2023-03-15 15:51:34'),(3702,'1','313',1,'Retail Sale Id 3777',0.00,641.30,710.00,752.60,111.30,'2023-03-15 15:52:40'),(3703,'1','313',1,'Retail Sale Id 3778',0.00,3406.15,710.00,3997.30,591.15,'2023-03-15 15:55:01'),(3704,'1','313',1,'Retail Sale Id 3779',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 15:56:48'),(3705,'1','313',1,'Retail Sale Id 3780',0.00,10285.00,710.00,12070.00,1785.00,'2023-03-15 15:57:57'),(3706,'1','313',1,'Retail Sale Id 3781',0.00,4259.20,710.00,4998.40,739.20,'2023-03-15 15:59:35'),(3707,'1','313',1,'Retail Sale Id 3782',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-15 16:00:58'),(3708,'1','313',1,'Retail Sale Id 3783',0.00,2129.60,710.00,2499.20,369.60,'2023-03-15 16:02:19'),(3709,'1','313',1,'Retail Sale Id 3784',0.00,4840.00,670.00,5360.00,520.00,'2023-03-15 16:03:37'),(3710,'1','313',1,'Retail Sale Id 3785',0.00,26015.00,670.00,28810.00,2795.00,'2023-03-15 16:04:32'),(3711,'1','313',1,'Retail Sale Id 3786',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 16:05:42'),(3712,'1','313',1,'Retail Sale Id 3787',0.00,1276.55,710.00,1498.10,221.55,'2023-03-15 16:07:07'),(3713,'1','313',1,'Retail Sale Id 3788',0.00,1234.20,710.00,1448.40,214.20,'2023-03-15 16:08:05'),(3714,'1','313',1,'Retail Sale Id 3789',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-15 16:09:55'),(3715,'1','313',1,'Retail Sale Id 3790',0.00,3025.00,710.00,3550.00,525.00,'2023-03-15 16:11:32'),(3716,'1','313',1,'Retail Sale Id 3791',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 16:13:43'),(3717,'1','313',1,'Retail Sale Id 3792',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-15 16:14:28'),(3718,'1','313',1,'Retail Sale Id 3793',0.00,605.00,710.00,710.00,105.00,'2023-03-15 16:15:39'),(3719,'1','313',1,'Retail Sale Id 3794',0.00,1815.00,710.00,2130.00,315.00,'2023-03-15 16:17:24'),(3720,'1','313',1,'Retail Sale Id 3795',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 16:18:56'),(3721,'1','313',1,'Retail Sale Id 3796',0.00,605.00,710.00,710.00,105.00,'2023-03-15 16:19:46'),(3722,'1','313',1,'Retail Sale Id 3797',0.00,853.05,710.00,1001.10,148.05,'2023-03-15 16:20:50'),(3723,'1','313',1,'Retail Sale Id 3798',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 16:21:30'),(3724,'1','313',1,'Retail Sale Id 3800',0.00,2420.00,710.00,2840.00,420.00,'2023-03-15 16:22:57'),(3725,'1','313',1,'Retail Sale Id 3801',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 16:24:08'),(3726,'1','313',1,'Retail Sale Id 3802',0.00,14520.00,710.00,17040.00,2520.00,'2023-03-15 16:26:34'),(3727,'1','313',1,'Retail Sale Id 3803',0.00,4235.00,710.00,4970.00,735.00,'2023-03-15 16:28:02'),(3728,'1','313',1,'Retail Sale Id 3804',0.00,3025.00,710.00,3550.00,525.00,'2023-03-15 16:29:20'),(3729,'1','313',1,'Retail Sale Id 3805',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 16:32:06'),(3730,'1','313',1,'Retail Sale Id 3806',0.00,605.00,710.00,710.00,105.00,'2023-03-15 16:34:39'),(3731,'1','313',1,'Retail Sale Id 3807',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 16:35:18'),(3732,'1','313',1,'Retail Sale Id 3808',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 16:37:03'),(3733,'1','313',1,'Retail Sale Id 3809',0.00,853.05,710.00,1001.10,148.05,'2023-03-15 16:39:19'),(3734,'1','313',1,'Retail Sale Id 3810',0.00,1210.00,710.00,1420.00,210.00,'2023-03-15 16:40:15'),(3735,'1','313',1,'Retail Sale Id 3811',0.00,1276.55,710.00,1498.10,221.55,'2023-03-15 17:03:23'),(3736,'1','313',1,'Retail Sale Id 3812',0.00,4235.00,710.00,4970.00,735.00,'2023-03-15 17:04:28'),(3737,'1','313',1,'Retail Sale Id 3813',0.00,641.30,710.00,752.60,111.30,'2023-03-15 17:05:28'),(3738,'1','313',1,'Retail Sale Id 3814',0.00,2420.00,710.00,2840.00,420.00,'2023-03-15 17:10:56'),(3739,'1','313',1,'Return of Retail Sale Id 3719',14520.00,0.00,710.00,-17040.00,-2520.00,'2023-03-15 17:12:39'),(3740,'1','313',1,'Return of Retail Sale Id 3802',14520.00,0.00,710.00,-17040.00,-2520.00,'2023-03-15 17:14:08'),(3741,'1','313',1,'Retail Sale Id 3815',0.00,29040.00,670.00,32160.00,3120.00,'2023-03-15 17:15:11'),(3742,'1','313',1,'Return of Retail Sale Id 3794',1815.00,0.00,710.00,-2130.00,-315.00,'2023-03-15 17:21:57'),(3743,'1','313',1,'Retail Sale Id 3816',0.00,1621.40,710.00,1902.80,281.40,'2023-03-15 17:22:59'),(3744,'1','313',1,'Return of Retail Sale Id 3665',69575.00,0.00,670.00,-77050.00,-7475.00,'2023-03-15 17:38:04'),(3745,'1','313',1,'Retail Sale Id 3817',0.00,32893.85,670.00,36427.90,3534.05,'2023-03-15 17:38:53'),(3746,'1','313',1,'Retail Sale Id 3818',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 08:21:32'),(3747,'1','313',1,'Retail Sale Id 3819',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 08:22:59'),(3748,'1','313',1,'Retail Sale Id 3820',0.00,3630.00,710.00,4260.00,630.00,'2023-03-16 08:23:58'),(3749,'1','313',1,'Retail Sale Id 3821',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 08:25:21'),(3750,'1','313',1,'Retail Sale Id 3822',0.00,4840.00,710.00,5680.00,840.00,'2023-03-16 08:26:33'),(3751,'1','313',1,'Retail Sale Id 3823',0.00,2420.00,710.00,2840.00,420.00,'2023-03-16 08:28:13'),(3752,'1','313',1,'Retail Sale Id 3824',0.00,5445.00,710.00,6390.00,945.00,'2023-03-16 08:29:38'),(3753,'1','313',1,'Retail Sale Id 3825',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-16 08:31:07'),(3754,'1','313',1,'Retail Sale Id 3826',0.00,4840.00,710.00,5680.00,840.00,'2023-03-16 08:32:13'),(3755,'1','313',1,'Retail Sale Id 3827',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 08:33:01'),(3756,'1','313',1,'Retail Sale Id 3828',0.00,3025.00,710.00,3550.00,525.00,'2023-03-16 08:33:58'),(3757,'1','313',1,'Retail Sale Id 3829',0.00,605.00,710.00,710.00,105.00,'2023-03-16 08:35:17'),(3758,'1','313',1,'Retail Sale Id 3830',0.00,4840.00,710.00,5680.00,840.00,'2023-03-16 08:37:25'),(3759,'1','313',1,'Retail Sale Id 3831',0.00,3630.00,710.00,4260.00,630.00,'2023-03-16 08:38:07'),(3760,'1','313',1,'Retail Sale Id 3832',0.00,4235.00,710.00,4970.00,735.00,'2023-03-16 08:39:10'),(3761,'1','313',1,'Retail Sale Id 3833',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-16 08:40:01'),(3762,'1','313',1,'Retail Sale Id 3834',0.00,37261.95,670.00,41265.30,4003.35,'2023-03-16 08:43:52'),(3763,'1','313',1,'Retail Sale Id 3835',0.00,4235.00,710.00,4970.00,735.00,'2023-03-16 08:44:34'),(3764,'1','313',1,'Retail Sale Id 3836',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 08:45:19'),(3765,'1','313',1,'Retail Sale Id 3837',0.00,605.00,710.00,710.00,105.00,'2023-03-16 08:46:20'),(3766,'1','313',1,'Retail Sale Id 3838',0.00,605.00,710.00,710.00,105.00,'2023-03-16 08:47:00'),(3767,'1','313',1,'Retail Sale Id 3839',0.00,3025.00,710.00,3550.00,525.00,'2023-03-16 08:47:39'),(3768,'1','313',1,'Retail Sale Id 3840',0.00,4235.00,710.00,4970.00,735.00,'2023-03-16 08:48:24'),(3769,'1','313',1,'Retail Sale Id 3841',0.00,2420.00,710.00,2840.00,420.00,'2023-03-16 08:51:43'),(3770,'1','313',1,'Retail Sale Id 3842',0.00,605.00,710.00,710.00,105.00,'2023-03-16 08:52:15'),(3771,'1','313',1,'Retail Sale Id 3843',0.00,3025.00,710.00,3550.00,525.00,'2023-03-16 08:52:46'),(3772,'1','313',1,'Retail Sale Id 3844',0.00,4840.00,710.00,5680.00,840.00,'2023-03-16 08:53:47'),(3773,'1','313',1,'Return of Retail Sale Id 3844',4840.00,0.00,710.00,-5680.00,-840.00,'2023-03-16 08:54:31'),(3774,'1','313',1,'Retail Sale Id 3845',0.00,2420.00,710.00,2840.00,420.00,'2023-03-16 08:54:58'),(3775,'1','313',1,'Retail Sale Id 3846',0.00,2420.00,710.00,2840.00,420.00,'2023-03-16 08:55:29'),(3776,'1','313',1,'Retail Sale Id 3847',0.00,37510.00,710.00,44020.00,6510.00,'2023-03-16 08:57:01'),(3777,'1','313',1,'Retail Sale Id 3848',0.00,60500.00,670.00,67000.00,6500.00,'2023-03-16 08:58:03'),(3778,'1','313',1,'Retail Sale Id 3849',0.00,36106.40,670.00,39985.60,3879.20,'2023-03-16 08:59:25'),(3779,'1','313',1,'Retail Sale Id 3850',0.00,641.30,710.00,752.60,111.30,'2023-03-16 09:00:16'),(3780,'1','313',1,'Retail Sale Id 3851',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 09:01:54'),(3781,'1','313',1,'Retail Sale Id 3852',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-16 09:03:03'),(3782,'1','313',1,'Retail Sale Id 3853',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 09:03:57'),(3783,'1','313',1,'Retail Sale Id 3854',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-16 09:04:34'),(3784,'1','313',1,'Retail Sale Id 3855',0.00,4235.00,710.00,4970.00,735.00,'2023-03-16 09:05:09'),(3785,'1','313',1,'Retail Sale Id 3856',0.00,605.00,710.00,710.00,105.00,'2023-03-16 09:05:50'),(3786,'1','313',1,'Retail Sale Id 3857',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 09:06:22'),(3787,'1','313',1,'Retail Sale Id 3858',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 09:07:49'),(3788,'1','313',1,'Retail Sale Id 3859',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 09:08:26'),(3789,'1','313',1,'Retail Sale Id 3860',0.00,1833.15,710.00,2151.30,318.15,'2023-03-16 09:09:51'),(3790,'1','313',1,'Retail Sale Id 3861',0.00,1833.15,710.00,2151.30,318.15,'2023-03-16 09:11:21'),(3791,'1','313',1,'Retail Sale Id 3862',0.00,11495.00,670.00,12730.00,1235.00,'2023-03-16 09:12:27'),(3792,'1','313',1,'Retail Sale Id 3863',0.00,2420.00,710.00,2840.00,420.00,'2023-03-16 09:13:15'),(3793,'1','313',1,'Retail Sale Id 3864',0.00,3025.00,710.00,3550.00,525.00,'2023-03-16 09:13:48'),(3794,'1','313',1,'Retail Sale Id 3865',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 09:14:26'),(3795,'1','313',1,'Retail Sale Id 3866',0.00,605.00,710.00,710.00,105.00,'2023-03-16 09:15:12'),(3796,'1','313',1,'Retail Sale Id 3867',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-16 09:15:58'),(3797,'1','313',1,'Retail Sale Id 3868',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-16 09:16:46'),(3798,'1','313',1,'Retail Sale Id 3869',0.00,3630.00,710.00,4260.00,630.00,'2023-03-16 09:17:13'),(3799,'1','313',1,'Retail Sale Id 3870',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 09:18:09'),(3800,'1','313',1,'Retail Sale Id 3871',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-16 09:19:44'),(3801,'1','313',1,'Retail Sale Id 3872',0.00,2559.15,710.00,3003.30,444.15,'2023-03-16 09:20:31'),(3802,'1','313',1,'Retail Sale Id 3873',0.00,1833.15,710.00,2151.30,318.15,'2023-03-16 09:21:17'),(3803,'1','313',1,'Retail Sale Id 3874',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 09:22:19'),(3804,'1','313',1,'Retail Sale Id 3875',0.00,853.05,710.00,1001.10,148.05,'2023-03-16 09:23:14'),(3805,'1','313',1,'Retail Sale Id 3876',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 09:23:46'),(3806,'1','313',1,'Retail Sale Id 3877',0.00,5445.00,710.00,6390.00,945.00,'2023-03-16 09:25:27'),(3807,'1','313',1,'Retail Sale Id 3878',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-16 09:26:38'),(3808,'1','313',1,'Retail Sale Id 3879',0.00,13915.00,710.00,16330.00,2415.00,'2023-03-16 09:27:52'),(3809,'1','313',1,'Retail Sale Id 3880',0.00,605.00,710.00,710.00,105.00,'2023-03-16 09:28:49'),(3810,'1','313',1,'Retail Sale Id 3881',0.00,2420.00,710.00,2840.00,420.00,'2023-03-16 09:30:17'),(3811,'1','313',1,'Retail Sale Id 3882',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 09:31:14'),(3812,'1','313',1,'Retail Sale Id 3883',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-16 09:32:13'),(3813,'1','313',1,'Retail Sale Id 3884',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-16 09:33:12'),(3814,'1','313',1,'Retail Sale Id 3885',0.00,641.30,710.00,752.60,111.30,'2023-03-16 09:34:09'),(3815,'1','313',1,'Return of Retail Sale Id 3847',37510.00,0.00,710.00,-44020.00,-6510.00,'2023-03-16 09:36:22'),(3816,'1','313',1,'Retail Sale Id 3886',0.00,37510.00,670.00,41540.00,4030.00,'2023-03-16 09:37:07'),(3817,'1','313',1,'Retail Sale Id 3887',0.00,3630.00,710.00,4260.00,630.00,'2023-03-16 09:37:50'),(3818,'1','313',1,'Retail Sale Id 3888',0.00,2559.15,710.00,3003.30,444.15,'2023-03-16 09:38:29'),(3819,'1','313',1,'Retail Sale Id 3889',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 09:39:04'),(3820,'1','313',1,'Retail Sale Id 3890',0.00,605.00,710.00,710.00,105.00,'2023-03-16 09:43:41'),(3821,'1','313',1,'Retail Sale Id 3891',0.00,4235.00,710.00,4970.00,735.00,'2023-03-16 09:48:45'),(3822,'1','313',1,'Retail Sale Id 3892',0.00,15125.00,670.00,16750.00,1625.00,'2023-03-16 09:49:59'),(3823,'1','313',1,'Retail Sale Id 3893',0.00,605.00,710.00,710.00,105.00,'2023-03-16 09:50:44'),(3824,'1','313',1,'Retail Sale Id 3894',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 09:51:30'),(3825,'1','313',1,'Retail Sale Id 3895',0.00,1234.20,710.00,1448.40,214.20,'2023-03-16 09:52:13'),(3826,'1','313',1,'Retail Sale Id 3896',0.00,605.00,710.00,710.00,105.00,'2023-03-16 09:53:07'),(3827,'1','313',1,'Retail Sale Id 3897',0.00,7865.00,710.00,9230.00,1365.00,'2023-03-16 09:53:51'),(3828,'1','313',1,'Retail Sale Id 3898',0.00,3025.00,710.00,3550.00,525.00,'2023-03-16 09:58:09'),(3829,'1','313',1,'Retail Sale Id 3899',0.00,4235.00,710.00,4970.00,735.00,'2023-03-16 09:59:27'),(3830,'1','313',1,'Retail Sale Id 3900',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 10:00:08'),(3831,'1','313',1,'Retail Sale Id 3901',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 10:02:02'),(3832,'1','313',1,'Retail Sale Id 3902',0.00,3630.00,710.00,4260.00,630.00,'2023-03-16 10:04:35'),(3833,'1','313',1,'Retail Sale Id 3903',0.00,3630.00,710.00,4260.00,630.00,'2023-03-16 10:05:22'),(3834,'1','313',1,'Retail Sale Id 3904',0.00,2559.15,710.00,3003.30,444.15,'2023-03-16 10:06:43'),(3835,'1','313',1,'Retail Sale Id 3905',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 10:07:14'),(3836,'1','313',1,'Retail Sale Id 3906',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-16 10:07:47'),(3837,'1','313',1,'Retail Sale Id 3907',0.00,853.05,710.00,1001.10,148.05,'2023-03-16 10:08:40'),(3838,'1','313',1,'Retail Sale Id 3908',0.00,1833.15,710.00,2151.30,318.15,'2023-03-16 10:10:10'),(3839,'1','313',1,'Retail Sale Id 3909',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 10:11:10'),(3840,'1','313',1,'Retail Sale Id 3910',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 10:12:35'),(3841,'1','313',1,'Retail Sale Id 3911',0.00,7865.00,710.00,9230.00,1365.00,'2023-03-16 10:13:24'),(3842,'1','313',1,'Retail Sale Id 3912',0.00,3406.15,710.00,3997.30,591.15,'2023-03-16 10:14:25'),(3843,'1','313',1,'Retail Sale Id 3913',0.00,3630.00,710.00,4260.00,630.00,'2023-03-16 10:14:52'),(3844,'1','313',1,'Retail Sale Id 3914',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 10:16:04'),(3845,'1','313',1,'Retail Sale Id 3915',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 10:16:54'),(3846,'1','313',1,'Retail Sale Id 3916',0.00,6655.00,670.00,7370.00,715.00,'2023-03-16 10:20:55'),(3847,'1','313',1,'Retail Sale Id 3917',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-16 10:22:15'),(3848,'1','313',1,'Retail Sale Id 3918',0.00,1833.15,710.00,2151.30,318.15,'2023-03-16 10:26:40'),(3849,'1','313',1,'Retail Sale Id 3919',0.00,2559.15,710.00,3003.30,444.15,'2023-03-16 10:28:19'),(3850,'1','313',1,'Retail Sale Id 3921',0.00,1833.15,710.00,2151.30,318.15,'2023-03-16 10:32:36'),(3851,'1','313',1,'Retail Sale Id 3922',0.00,4537.50,710.00,5325.00,787.50,'2023-03-16 10:37:20'),(3852,'1','313',1,'Retail Sale Id 3923',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-16 10:43:58'),(3853,'1','313',1,'Retail Sale Id 3924',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 10:44:52'),(3854,'1','313',1,'Retail Sale Id 3925',0.00,2559.15,710.00,3003.30,444.15,'2023-03-16 10:46:00'),(3855,'1','313',1,'Retail Sale Id 3926',0.00,4235.00,710.00,4970.00,735.00,'2023-03-16 10:47:12'),(3856,'1','313',1,'Retail Sale Id 3927',0.00,1833.15,710.00,2151.30,318.15,'2023-03-16 10:49:19'),(3857,'1','313',1,'Retail Sale Id 3928',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 10:50:36'),(3858,'1','313',1,'Retail Sale Id 3929',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 10:51:18'),(3859,'1','313',1,'Retail Sale Id 3930',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 10:56:50'),(3860,'1','313',1,'Retail Sale Id 3931',0.00,2129.60,710.00,2499.20,369.60,'2023-03-16 10:59:17'),(3861,'1','313',1,'Retail Sale Id 3932',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 11:02:48'),(3862,'1','313',1,'Retail Sale Id 3933',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 11:04:00'),(3863,'1','313',1,'Retail Sale Id 3934',0.00,605.00,710.00,710.00,105.00,'2023-03-16 11:05:52'),(3864,'1','313',1,'Retail Sale Id 3935',0.00,683.65,710.00,802.30,118.65,'2023-03-16 11:12:37'),(3865,'1','313',1,'Retail Sale Id 3936',0.00,3630.00,710.00,4260.00,630.00,'2023-03-16 11:15:13'),(3866,'1','313',1,'Retail Sale Id 3937',0.00,1276.55,710.00,1498.10,221.55,'2023-03-16 11:29:11'),(3867,'1','313',1,'Retail Sale Id 3938',0.00,605.00,710.00,710.00,105.00,'2023-03-16 11:30:51'),(3868,'1','313',1,'Retail Sale Id 3939',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 11:32:22'),(3869,'1','313',1,'Retail Sale Id 3940',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 11:34:20'),(3870,'1','313',1,'Retail Sale Id 3941',0.00,853.05,710.00,1001.10,148.05,'2023-03-16 11:35:29'),(3871,'1','313',1,'Retail Sale Id 3942',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-16 11:37:16'),(3872,'1','313',1,'Retail Sale Id 3943',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 11:38:25'),(3873,'1','313',1,'Retail Sale Id 3944',0.00,3025.00,710.00,3550.00,525.00,'2023-03-16 11:40:39'),(3874,'1','313',1,'Retail Sale Id 3945',0.00,5112.25,710.00,5999.50,887.25,'2023-03-16 11:44:28'),(3875,'1','313',1,'Retail Sale Id 3946',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 11:45:32'),(3876,'1','313',1,'Retail Sale Id 3947',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 11:46:59'),(3877,'1','313',1,'Retail Sale Id 3948',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 11:53:20'),(3878,'1','313',1,'Retail Sale Id 3949',0.00,2420.00,710.00,2840.00,420.00,'2023-03-16 11:56:21'),(3879,'1','313',1,'Retail Sale Id 3950',0.00,2426.05,710.00,2847.10,421.05,'2023-03-16 11:57:49'),(3880,'1','313',1,'Retail Sale Id 3952',0.00,11797.50,710.00,13845.00,2047.50,'2023-03-16 12:02:15'),(3881,'1','313',1,'Retail Sale Id 3953',0.00,4235.00,710.00,4970.00,735.00,'2023-03-16 12:04:48'),(3882,'1','313',1,'Retail Sale Id 3954',0.00,3630.00,710.00,4260.00,630.00,'2023-03-16 12:06:52'),(3883,'1','313',1,'Retail Sale Id 3956',0.00,853.05,710.00,1001.10,148.05,'2023-03-16 12:10:46'),(3884,'1','313',1,'Retail Sale Id 3957',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 12:14:36'),(3885,'1','313',1,'Retail Sale Id 3958',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 12:17:34'),(3886,'1','313',1,'Retail Sale Id 3959',0.00,3025.00,710.00,3550.00,525.00,'2023-03-16 12:18:32'),(3887,'1','313',1,'Retail Sale Id 3960',0.00,3630.00,710.00,4260.00,630.00,'2023-03-16 12:24:45'),(3888,'1','313',1,'Retail Sale Id 3961',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 12:25:48'),(3889,'1','313',1,'Retail Sale Id 3962',0.00,605.00,710.00,710.00,105.00,'2023-03-16 12:28:22'),(3890,'1','313',1,'Retail Sale Id 3963',0.00,2559.15,710.00,3003.30,444.15,'2023-03-16 12:33:30'),(3891,'1','313',1,'Retail Sale Id 3964',0.00,3025.00,710.00,3550.00,525.00,'2023-03-16 12:37:29'),(3892,'1','313',1,'Retail Sale Id 3965',0.00,1706.10,710.00,2002.20,296.10,'2023-03-16 12:39:24'),(3893,'1','313',1,'Retail Sale Id 3966',0.00,2420.00,710.00,2840.00,420.00,'2023-03-16 12:40:43'),(3894,'1','313',1,'Retail Sale Id 3967',0.00,3630.00,710.00,4260.00,630.00,'2023-03-16 12:46:17'),(3895,'1','313',1,'Retail Sale Id 3968',0.00,605.00,710.00,710.00,105.00,'2023-03-16 12:49:42'),(3896,'1','313',1,'Retail Sale Id 3970',0.00,2420.00,710.00,2840.00,420.00,'2023-03-16 12:55:18'),(3897,'1','313',1,'Retail Sale Id 3971',0.00,605.00,710.00,710.00,105.00,'2023-03-16 12:57:13'),(3898,'1','313',1,'Retail Sale Id 3972',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 12:58:52'),(3899,'1','313',1,'Retail Sale Id 3973',0.00,4235.00,710.00,4970.00,735.00,'2023-03-16 13:00:59'),(3900,'1','313',1,'Retail Sale Id 3974',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 13:06:12'),(3901,'1','313',1,'Retail Sale Id 3975',0.00,3025.00,710.00,3550.00,525.00,'2023-03-16 13:11:30'),(3902,'1','313',1,'Retail Sale Id 3976',0.00,853.05,710.00,1001.10,148.05,'2023-03-16 13:12:57'),(3903,'1','313',1,'Retail Sale Id 3977',0.00,4235.00,710.00,4970.00,735.00,'2023-03-16 13:14:20'),(3904,'1','313',1,'Retail Sale Id 3978',0.00,3630.00,710.00,4260.00,630.00,'2023-03-16 13:14:48'),(3905,'1','313',1,'Retail Sale Id 3979',0.00,2420.00,710.00,2840.00,420.00,'2023-03-16 13:17:11'),(3906,'1','313',1,'Retail Sale Id 3980',0.00,3025.00,710.00,3550.00,525.00,'2023-03-16 13:20:39'),(3907,'1','313',1,'Retail Sale Id 3981',0.00,1512.50,710.00,1775.00,262.50,'2023-03-16 13:22:22'),(3908,'1','313',1,'Retail Sale Id 3982',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 13:25:41'),(3909,'1','313',1,'Retail Sale Id 3983',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 13:40:14'),(3910,'1','313',1,'Retail Sale Id 3984',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 13:53:46'),(3911,'1','313',1,'Retail Sale Id 3985',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 13:57:21'),(3912,'1','313',1,'Retail Sale Id 3986',0.00,3025.00,710.00,3550.00,525.00,'2023-03-16 13:58:48'),(3913,'1','313',1,'Retail Sale Id 3987',0.00,3025.00,710.00,3550.00,525.00,'2023-03-16 14:08:21'),(3914,'1','313',1,'Retail Sale Id 3988',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 14:12:46'),(3915,'1','313',1,'Retail Sale Id 3989',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 14:13:40'),(3916,'1','313',1,'Retail Sale Id 3990',0.00,3630.00,710.00,4260.00,630.00,'2023-03-16 14:14:50'),(3917,'1','313',1,'Retail Sale Id 3991',0.00,2420.00,710.00,2840.00,420.00,'2023-03-16 14:16:26'),(3918,'1','313',1,'Retail Sale Id 3992',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 14:18:47'),(3919,'1','313',1,'Retail Sale Id 3993',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-16 14:25:15'),(3920,'1','313',1,'Retail Sale Id 3994',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 14:26:37'),(3921,'1','313',1,'Retail Sale Id 3995',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-16 14:28:25'),(3922,'1','313',1,'Retail Sale Id 3996',0.00,3630.00,710.00,4260.00,630.00,'2023-03-16 14:29:52'),(3923,'1','313',1,'Retail Sale Id 3997',0.00,3630.00,710.00,4260.00,630.00,'2023-03-16 14:30:51'),(3924,'1','313',1,'Retail Sale Id 3998',0.00,3630.00,710.00,4260.00,630.00,'2023-03-16 14:33:00'),(3925,'1','313',1,'Retail Sale Id 3999',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 14:41:09'),(3926,'1','313',1,'Retail Sale Id 4000',0.00,3630.00,710.00,4260.00,630.00,'2023-03-16 14:42:36'),(3927,'1','313',1,'Retail Sale Id 4001',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-16 14:45:15'),(3928,'1','313',1,'Retail Sale Id 4002',0.00,2559.15,710.00,3003.30,444.15,'2023-03-16 14:50:28'),(3929,'1','313',1,'Retail Sale Id 4003',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 14:51:49'),(3930,'1','313',1,'Retail Sale Id 4004',0.00,3630.00,710.00,4260.00,630.00,'2023-03-16 14:58:34'),(3931,'1','313',1,'Retail Sale Id 4005',0.00,605.00,710.00,710.00,105.00,'2023-03-16 15:02:03'),(3932,'1','313',1,'Retail Sale Id 4006',0.00,4235.00,710.00,4970.00,735.00,'2023-03-16 15:02:45'),(3933,'1','313',1,'Retail Sale Id 4007',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 15:04:51'),(3934,'1','313',1,'Retail Sale Id 4008',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 15:06:41'),(3935,'1','313',1,'Retail Sale Id 4009',0.00,73186.85,670.00,81049.90,7863.05,'2023-03-16 15:10:15'),(3936,'1','313',1,'Retail Sale Id 4010',0.00,605.00,710.00,710.00,105.00,'2023-03-16 15:11:27'),(3937,'1','313',1,'Retail Sale Id 4011',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 15:17:42'),(3938,'1','313',1,'Retail Sale Id 4012',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-16 15:20:41'),(3939,'1','313',1,'Retail Sale Id 4013',0.00,24375.45,670.00,26994.30,2618.85,'2023-03-16 15:25:16'),(3940,'1','313',1,'Retail Sale Id 4014',0.00,605.00,710.00,710.00,105.00,'2023-03-16 15:26:13'),(3941,'1','313',1,'Retail Sale Id 4015',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 15:27:42'),(3942,'1','313',1,'Retail Sale Id 4016',0.00,853.05,710.00,1001.10,148.05,'2023-03-16 15:35:55'),(3943,'1','313',1,'Retail Sale Id 4018',0.00,641.30,710.00,752.60,111.30,'2023-03-16 15:36:58'),(3944,'1','313',1,'Retail Sale Id 4019',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-16 15:38:21'),(3945,'1','313',1,'Retail Sale Id 4020',0.00,1875.50,710.00,2201.00,325.50,'2023-03-16 15:40:40'),(3946,'1','313',1,'Retail Sale Id 4021',0.00,3025.00,710.00,3550.00,525.00,'2023-03-16 15:41:31'),(3947,'1','313',1,'Retail Sale Id 4022',0.00,4840.00,710.00,5680.00,840.00,'2023-03-16 15:42:44'),(3948,'1','313',1,'Retail Sale Id 4023',0.00,2117.50,710.00,2485.00,367.50,'2023-03-16 15:44:08'),(3949,'1','313',1,'Retail Sale Id 4024',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 15:44:52'),(3950,'1','313',1,'Retail Sale Id 4025',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-16 15:49:44'),(3951,'1','313',1,'Retail Sale Id 4026',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 15:51:10'),(3952,'1','313',1,'Retail Sale Id 4027',0.00,3025.00,710.00,3550.00,525.00,'2023-03-16 15:52:48'),(3953,'1','313',1,'Retail Sale Id 4028',0.00,4235.00,710.00,4970.00,735.00,'2023-03-16 15:54:14'),(3954,'1','313',1,'Retail Sale Id 4029',0.00,6050.00,670.00,6700.00,650.00,'2023-03-16 15:55:56'),(3955,'1','313',1,'Retail Sale Id 4030',0.00,4235.00,710.00,4970.00,735.00,'2023-03-16 15:57:10'),(3956,'1','313',1,'Retail Sale Id 4031',0.00,9075.00,710.00,10650.00,1575.00,'2023-03-16 15:59:18'),(3957,'1','313',1,'Retail Sale Id 4032',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 16:00:45'),(3958,'1','313',1,'Retail Sale Id 4033',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 16:01:38'),(3959,'1','313',1,'Retail Sale Id 4034',0.00,4235.00,710.00,4970.00,735.00,'2023-03-16 16:02:46'),(3960,'1','313',1,'Retail Sale Id 4035',0.00,1833.15,710.00,2151.30,318.15,'2023-03-16 16:04:43'),(3961,'1','313',1,'Retail Sale Id 4036',0.00,11192.50,710.00,13135.00,1942.50,'2023-03-16 16:06:44'),(3962,'1','313',1,'Retail Sale Id 4037',0.00,26620.00,670.00,29480.00,2860.00,'2023-03-16 16:11:05'),(3963,'1','313',1,'Retail Sale Id 4038',0.00,605.00,710.00,710.00,105.00,'2023-03-16 16:14:13'),(3964,'1','313',1,'Retail Sale Id 4039',0.00,2420.00,710.00,2840.00,420.00,'2023-03-16 16:14:53'),(3965,'1','313',1,'Retail Sale Id 4040',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 16:16:10'),(3966,'1','313',1,'Retail Sale Id 4041',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 16:18:17'),(3967,'1','313',1,'Retail Sale Id 4042',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 16:18:58'),(3968,'1','313',1,'Retail Sale Id 4043',0.00,2420.00,710.00,2840.00,420.00,'2023-03-16 16:19:35'),(3969,'1','313',1,'Retail Sale Id 4044',0.00,2420.00,710.00,2840.00,420.00,'2023-03-16 16:20:40'),(3970,'1','313',1,'Retail Sale Id 4045',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-16 16:23:09'),(3971,'1','313',1,'Retail Sale Id 4046',0.00,2420.00,710.00,2840.00,420.00,'2023-03-16 16:26:39'),(3972,'1','313',1,'Retail Sale Id 4047',0.00,907.50,710.00,1065.00,157.50,'2023-03-16 16:29:13'),(3973,'1','313',1,'Retail Sale Id 4048',0.00,605.00,710.00,710.00,105.00,'2023-03-16 16:30:27'),(3974,'1','313',1,'Retail Sale Id 4049',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-16 16:31:44'),(3975,'1','313',1,'Retail Sale Id 4050',0.00,605.00,710.00,710.00,105.00,'2023-03-16 16:32:53'),(3976,'1','313',1,'Retail Sale Id 4051',0.00,907.50,710.00,1065.00,157.50,'2023-03-16 16:34:04'),(3977,'1','313',1,'Retail Sale Id 4052',0.00,3630.00,710.00,4260.00,630.00,'2023-03-16 16:35:35'),(3978,'1','313',1,'Retail Sale Id 4053',0.00,3025.00,710.00,3550.00,525.00,'2023-03-16 16:36:41'),(3979,'1','313',1,'Retail Sale Id 4054',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 16:37:46'),(3980,'1','313',1,'Retail Sale Id 4055',0.00,2420.00,710.00,2840.00,420.00,'2023-03-16 16:39:05'),(3981,'1','313',1,'Retail Sale Id 4056',0.00,605.00,710.00,710.00,105.00,'2023-03-16 16:42:17'),(3982,'1','313',1,'Retail Sale Id 4057',0.00,8470.00,710.00,9940.00,1470.00,'2023-03-16 16:43:25'),(3983,'1','313',1,'Retail Sale Id 4058',0.00,1210.00,710.00,1420.00,210.00,'2023-03-16 16:44:55'),(3984,'1','313',1,'Retail Sale Id 4059',0.00,853.05,710.00,1001.10,148.05,'2023-03-16 16:46:14'),(3985,'1','313',1,'Retail Sale Id 4060',0.00,605.00,710.00,710.00,105.00,'2023-03-16 16:47:58'),(3986,'1','313',1,'Retail Sale Id 4061',0.00,4259.20,710.00,4998.40,739.20,'2023-03-16 16:50:03'),(3987,'1','313',1,'Retail Sale Id 4062',0.00,1790.80,710.00,2101.60,310.80,'2023-03-16 16:50:59'),(3988,'1','313',1,'Retail Sale Id 4063',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-16 16:51:56'),(3989,'1','313',1,'Retail Sale Id 4064',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 16:52:45'),(3990,'1','313',1,'Retail Sale Id 4065',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 16:54:11'),(3991,'1','313',1,'Retail Sale Id 4066',0.00,4235.00,710.00,4970.00,735.00,'2023-03-16 16:55:39'),(3992,'1','313',1,'Retail Sale Id 4067',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 16:56:48'),(3993,'1','313',1,'Retail Sale Id 4068',0.00,1815.00,710.00,2130.00,315.00,'2023-03-16 16:58:56'),(3994,'1','313',1,'Retail Sale Id 4069',0.00,3025.00,710.00,3550.00,525.00,'2023-03-16 17:00:06'),(3995,'1','313',1,'Return of Retail Sale Id 4052',3630.00,0.00,710.00,-4260.00,-630.00,'2023-03-16 17:19:55'),(3996,'1','313',1,'Retail Sale Id 4070',0.00,2383.70,710.00,2797.40,413.70,'2023-03-16 17:20:39'),(3997,'1','313',1,'Retail Sale Id 4071',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 08:02:52'),(3998,'1','313',1,'Retail Sale Id 4072',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 08:04:22'),(3999,'1','313',1,'Retail Sale Id 4073',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 08:05:26'),(4000,'1','313',1,'Retail Sale Id 4074',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 08:06:20'),(4001,'1','313',1,'Retail Sale Id 4075',0.00,641.30,710.00,752.60,111.30,'2023-03-17 08:07:23'),(4002,'1','313',1,'Retail Sale Id 4076',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 08:08:15'),(4003,'1','313',1,'Retail Sale Id 4077',0.00,4235.00,710.00,4970.00,735.00,'2023-03-17 08:13:37'),(4004,'1','313',1,'Retail Sale Id 4078',0.00,1706.10,710.00,2002.20,296.10,'2023-03-17 08:14:53'),(4005,'1','313',1,'Retail Sale Id 4079',0.00,4840.00,710.00,5680.00,840.00,'2023-03-17 08:16:08'),(4006,'1','313',1,'Retail Sale Id 4080',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 08:17:26'),(4007,'1','313',1,'Retail Sale Id 4081',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 08:18:20'),(4008,'1','313',1,'Retail Sale Id 4082',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 08:19:20'),(4009,'1','313',1,'Retail Sale Id 4083',0.00,853.05,710.00,1001.10,148.05,'2023-03-17 08:20:48'),(4010,'1','313',1,'Retail Sale Id 4084',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 08:21:46'),(4011,'1','313',1,'Retail Sale Id 4085',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 08:23:03'),(4012,'1','313',1,'Retail Sale Id 4086',0.00,853.05,710.00,1001.10,148.05,'2023-03-17 08:23:46'),(4013,'1','313',1,'Retail Sale Id 4087',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 08:24:47'),(4014,'1','313',1,'Retail Sale Id 4088',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 08:25:46'),(4015,'1','313',1,'Retail Sale Id 4089',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 08:26:49'),(4016,'1','313',1,'Retail Sale Id 4090',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 08:27:41'),(4017,'1','313',1,'Retail Sale Id 4091',0.00,19360.00,710.00,22720.00,3360.00,'2023-03-17 08:29:10'),(4018,'1','313',1,'Retail Sale Id 4092',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 08:30:19'),(4019,'1','313',1,'Retail Sale Id 4093',0.00,641.30,710.00,752.60,111.30,'2023-03-17 08:31:27'),(4020,'1','313',1,'Retail Sale Id 4094',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 08:32:11'),(4021,'1','313',1,'Retail Sale Id 4095',0.00,605.00,710.00,710.00,105.00,'2023-03-17 08:32:49'),(4022,'1','313',1,'Retail Sale Id 4096',0.00,4235.00,710.00,4970.00,735.00,'2023-03-17 08:34:02'),(4023,'1','313',1,'Retail Sale Id 4097',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 08:35:12'),(4024,'1','313',1,'Retail Sale Id 4098',0.00,7865.00,710.00,9230.00,1365.00,'2023-03-17 08:35:51'),(4025,'1','313',1,'Retail Sale Id 4099',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 08:37:03'),(4026,'1','313',1,'Retail Sale Id 4100',0.00,4235.00,710.00,4970.00,735.00,'2023-03-17 08:38:00'),(4027,'1','313',1,'Retail Sale Id 4101',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 08:39:23'),(4028,'1','313',1,'Retail Sale Id 4102',0.00,605.00,710.00,710.00,105.00,'2023-03-17 08:40:54'),(4029,'1','313',1,'Retail Sale Id 4103',0.00,1276.55,710.00,1498.10,221.55,'2023-03-17 08:42:15'),(4030,'1','313',1,'Retail Sale Id 4104',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-17 08:43:32'),(4031,'1','313',1,'Retail Sale Id 4105',0.00,4259.20,710.00,4998.40,739.20,'2023-03-17 08:44:11'),(4032,'1','313',1,'Retail Sale Id 4106',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 08:44:56'),(4033,'1','313',1,'Retail Sale Id 4107',0.00,853.05,710.00,1001.10,148.05,'2023-03-17 08:46:02'),(4034,'1','313',1,'Retail Sale Id 4108',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 08:46:53'),(4035,'1','313',1,'Retail Sale Id 4109',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 08:47:40'),(4036,'1','313',1,'Retail Sale Id 4110',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-17 08:49:14'),(4037,'1','313',1,'Retail Sale Id 4111',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 08:50:17'),(4038,'1','313',1,'Retail Sale Id 4112',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 08:51:35'),(4039,'1','313',1,'Retail Sale Id 4113',0.00,605.00,710.00,710.00,105.00,'2023-03-17 08:52:52'),(4040,'1','313',1,'Retail Sale Id 4114',0.00,605.00,710.00,710.00,105.00,'2023-03-17 08:53:33'),(4041,'1','313',1,'Retail Sale Id 4115',0.00,605.00,710.00,710.00,105.00,'2023-03-17 08:54:51'),(4042,'1','313',1,'Retail Sale Id 4116',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 08:55:26'),(4043,'1','313',1,'Retail Sale Id 4117',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 08:56:12'),(4044,'1','313',1,'Retail Sale Id 4118',0.00,605.00,710.00,710.00,105.00,'2023-03-17 08:57:29'),(4045,'1','313',1,'Retail Sale Id 4119',0.00,1706.10,710.00,2002.20,296.10,'2023-03-17 08:58:09'),(4046,'1','313',1,'Retail Sale Id 4120',0.00,2559.15,710.00,3003.30,444.15,'2023-03-17 08:58:51'),(4047,'1','313',1,'Retail Sale Id 4121',0.00,1276.55,710.00,1498.10,221.55,'2023-03-17 08:59:28'),(4048,'1','313',1,'Retail Sale Id 4122',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 09:00:07'),(4049,'1','313',1,'Retail Sale Id 4123',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 09:01:06'),(4050,'1','313',1,'Retail Sale Id 4124',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 09:01:39'),(4051,'1','313',1,'Retail Sale Id 4125',0.00,1833.15,710.00,2151.30,318.15,'2023-03-17 09:04:01'),(4052,'1','313',1,'Retail Sale Id 4126',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-17 09:04:36'),(4053,'1','313',1,'Retail Sale Id 4127',0.00,26620.00,670.00,29480.00,2860.00,'2023-03-17 09:06:41'),(4054,'1','313',1,'Retail Sale Id 4128',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 09:07:24'),(4055,'1','313',1,'Retail Sale Id 4129',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 09:08:03'),(4056,'1','313',1,'Retail Sale Id 4130',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 09:09:35'),(4057,'1','313',1,'Retail Sale Id 4131',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 09:10:32'),(4058,'1','313',1,'Retail Sale Id 4132',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-17 09:11:40'),(4059,'1','313',1,'Retail Sale Id 4133',0.00,605.00,710.00,710.00,105.00,'2023-03-17 09:12:15'),(4060,'1','313',1,'Retail Sale Id 4134',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 09:14:20'),(4061,'1','313',1,'Retail Sale Id 4135',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 09:15:30'),(4062,'1','313',1,'Retail Sale Id 4136',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 09:16:22'),(4063,'1','313',1,'Retail Sale Id 4137',0.00,5445.00,710.00,6390.00,945.00,'2023-03-17 09:18:07'),(4064,'1','313',1,'Retail Sale Id 4138',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 09:18:39'),(4065,'1','313',1,'Retail Sale Id 4139',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 09:20:08'),(4066,'1','313',1,'Retail Sale Id 4140',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 09:23:07'),(4067,'1','313',1,'Retail Sale Id 4141',0.00,1512.50,710.00,1775.00,262.50,'2023-03-17 09:26:44'),(4068,'1','313',1,'Retail Sale Id 4142',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 09:27:41'),(4069,'1','313',1,'Retail Sale Id 4143',0.00,4235.00,710.00,4970.00,735.00,'2023-03-17 09:29:10'),(4070,'1','313',1,'Retail Sale Id 4144',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-17 09:30:47'),(4071,'1','313',1,'Retail Sale Id 4145',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 09:32:00'),(4072,'1','313',1,'Retail Sale Id 4146',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 09:33:00'),(4073,'1','313',1,'Retail Sale Id 4147',0.00,611.05,710.00,717.10,106.05,'2023-03-17 09:34:35'),(4074,'1','313',1,'Retail Sale Id 4148',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-17 09:35:40'),(4075,'1','313',1,'Retail Sale Id 4149',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 09:36:40'),(4076,'1','313',1,'Retail Sale Id 4150',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 09:37:35'),(4077,'1','313',1,'Retail Sale Id 4151',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 09:38:49'),(4078,'1','313',1,'Retail Sale Id 4152',0.00,4235.00,710.00,4970.00,735.00,'2023-03-17 09:39:53'),(4079,'1','313',1,'Retail Sale Id 4153',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 09:40:56'),(4080,'1','313',1,'Retail Sale Id 4154',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 09:41:53'),(4081,'1','313',1,'Retail Sale Id 4155',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 09:43:08'),(4082,'1','313',1,'Retail Sale Id 4156',0.00,1234.20,710.00,1448.40,214.20,'2023-03-17 09:44:24'),(4083,'1','313',1,'Retail Sale Id 4157',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-17 09:45:25'),(4084,'1','313',1,'Retail Sale Id 4158',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 09:46:13'),(4085,'1','313',1,'Retail Sale Id 4159',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 09:47:25'),(4086,'1','313',1,'Retail Sale Id 4160',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 09:49:16'),(4087,'1','313',1,'Retail Sale Id 4161',0.00,1234.20,710.00,1448.40,214.20,'2023-03-17 09:50:28'),(4088,'1','313',1,'Retail Sale Id 4162',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 09:51:28'),(4089,'1','313',1,'Retail Sale Id 4163',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 09:53:03'),(4090,'1','313',1,'Retail Sale Id 4164',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-17 09:54:24'),(4091,'1','313',1,'Retail Sale Id 4165',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-17 09:55:41'),(4092,'1','313',1,'Retail Sale Id 4166',0.00,605.00,710.00,710.00,105.00,'2023-03-17 09:56:55'),(4093,'1','313',1,'Retail Sale Id 4167',0.00,605.00,710.00,710.00,105.00,'2023-03-17 09:58:41'),(4094,'1','313',1,'Retail Sale Id 4168',0.00,8167.50,710.00,9585.00,1417.50,'2023-03-17 10:00:59'),(4095,'1','313',1,'Retail Sale Id 4169',0.00,641.30,710.00,752.60,111.30,'2023-03-17 10:03:22'),(4096,'1','313',1,'Retail Sale Id 4170',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-17 10:06:20'),(4097,'1','313',1,'Retail Sale Id 4171',0.00,76332.85,670.00,84533.90,8201.05,'2023-03-17 10:07:23'),(4098,'1','313',1,'Retail Sale Id 4172',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 10:10:32'),(4099,'1','313',1,'Retail Sale Id 4173',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 10:11:10'),(4100,'1','313',1,'Retail Sale Id 4174',0.00,368559.95,670.00,408157.30,39597.35,'2023-03-17 10:13:48'),(4101,'1','313',1,'Retail Sale Id 4175',0.00,8167.50,710.00,9585.00,1417.50,'2023-03-17 10:14:35'),(4102,'1','313',1,'Retail Sale Id 4176',0.00,2129.60,710.00,2499.20,369.60,'2023-03-17 10:15:33'),(4103,'1','313',1,'Retail Sale Id 4178',0.00,605.00,710.00,710.00,105.00,'2023-03-17 10:18:26'),(4104,'1','313',1,'Retail Sale Id 4179',0.00,15125.00,710.00,17750.00,2625.00,'2023-03-17 10:19:18'),(4105,'1','313',1,'Retail Sale Id 4180',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 10:20:12'),(4106,'1','313',1,'Retail Sale Id 4181',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 10:21:29'),(4107,'1','313',1,'Retail Sale Id 4182',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 10:22:17'),(4108,'1','313',1,'Retail Sale Id 4183',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 10:23:13'),(4109,'1','313',1,'Retail Sale Id 4184',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 10:24:13'),(4110,'1','313',1,'Retail Sale Id 4186',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 10:25:06'),(4111,'1','313',1,'Retail Sale Id 4187',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 10:26:19'),(4112,'1','313',1,'Retail Sale Id 4188',0.00,605.00,710.00,710.00,105.00,'2023-03-17 10:27:01'),(4113,'1','313',1,'Retail Sale Id 4189',0.00,4235.00,710.00,4970.00,735.00,'2023-03-17 10:28:00'),(4114,'1','313',1,'Retail Sale Id 4190',0.00,605.00,710.00,710.00,105.00,'2023-03-17 10:29:03'),(4115,'1','313',1,'Retail Sale Id 4191',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 10:29:49'),(4116,'1','313',1,'Retail Sale Id 4192',0.00,18150.00,670.00,20100.00,1950.00,'2023-03-17 10:31:09'),(4117,'1','313',1,'Retail Sale Id 4193',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-17 10:31:52'),(4118,'1','313',1,'Retail Sale Id 4194',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 10:32:24'),(4119,'1','313',1,'Retail Sale Id 4195',0.00,4840.00,710.00,5680.00,840.00,'2023-03-17 10:33:32'),(4120,'1','313',1,'Retail Sale Id 4196',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 10:34:08'),(4121,'1','313',1,'Retail Sale Id 4197',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 10:34:59'),(4122,'1','313',1,'Retail Sale Id 4198',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 10:35:31'),(4123,'1','313',1,'Retail Sale Id 4199',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-17 10:36:26'),(4124,'1','313',1,'Retail Sale Id 4200',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 10:39:33'),(4125,'1','313',1,'Retail Sale Id 4201',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 10:41:51'),(4126,'1','313',1,'Retail Sale Id 4202',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 10:43:16'),(4127,'1','313',1,'Retail Sale Id 4203',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 10:44:53'),(4128,'1','313',1,'Retail Sale Id 4204',0.00,605.00,710.00,710.00,105.00,'2023-03-17 10:45:51'),(4129,'1','313',1,'Retail Sale Id 4206',0.00,8518.40,710.00,9996.80,1478.40,'2023-03-17 10:47:30'),(4130,'1','313',1,'Retail Sale Id 4207',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 10:48:10'),(4131,'1','313',1,'Retail Sale Id 4208',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-17 10:48:43'),(4132,'1','313',1,'Retail Sale Id 4209',0.00,641.30,710.00,752.60,111.30,'2023-03-17 10:49:34'),(4133,'1','313',1,'Retail Sale Id 4210',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 10:50:15'),(4134,'1','313',1,'Retail Sale Id 4211',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 10:52:16'),(4135,'1','313',1,'Retail Sale Id 4212',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 10:57:03'),(4136,'1','313',1,'Retail Sale Id 4213',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 11:02:54'),(4137,'1','313',1,'Retail Sale Id 4214',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 11:04:52'),(4138,'1','313',1,'Retail Sale Id 4215',0.00,605.00,710.00,710.00,105.00,'2023-03-17 11:05:31'),(4139,'1','313',1,'Retail Sale Id 4216',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 11:06:12'),(4140,'1','313',1,'Retail Sale Id 4217',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 11:07:20'),(4141,'1','313',1,'Retail Sale Id 4218',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 11:09:38'),(4142,'1','313',1,'Retail Sale Id 4219',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 11:10:34'),(4143,'1','313',1,'Retail Sale Id 4220',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 11:12:31'),(4144,'1','313',1,'Retail Sale Id 4221',0.00,5112.25,710.00,5999.50,887.25,'2023-03-17 11:15:08'),(4145,'1','313',1,'Retail Sale Id 4222',0.00,2129.60,710.00,2499.20,369.60,'2023-03-17 11:17:52'),(4146,'1','313',1,'Retail Sale Id 4224',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 11:19:51'),(4147,'1','313',1,'Retail Sale Id 4225',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 11:22:50'),(4148,'1','313',1,'Retail Sale Id 4226',0.00,26620.00,670.00,29480.00,2860.00,'2023-03-17 11:26:44'),(4149,'1','313',1,'Retail Sale Id 4227',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 11:31:24'),(4150,'1','313',1,'Retail Sale Id 4228',0.00,4235.00,710.00,4970.00,735.00,'2023-03-17 11:34:01'),(4151,'1','313',1,'Retail Sale Id 4229',0.00,605.00,710.00,710.00,105.00,'2023-03-17 11:35:14'),(4152,'1','313',1,'Retail Sale Id 4230',0.00,605.00,710.00,710.00,105.00,'2023-03-17 11:37:30'),(4153,'1','313',1,'Retail Sale Id 4231',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-17 11:38:31'),(4154,'1','313',1,'Retail Sale Id 4232',0.00,2214.30,710.00,2598.60,384.30,'2023-03-17 11:40:13'),(4155,'1','313',1,'Retail Sale Id 4233',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 11:41:12'),(4156,'1','313',1,'Retail Sale Id 4234',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 11:42:19'),(4157,'1','313',1,'Retail Sale Id 4235',0.00,647.35,670.00,716.90,69.55,'2023-03-17 11:44:31'),(4158,'1','313',1,'Retail Sale Id 4236',0.00,1833.15,710.00,2151.30,318.15,'2023-03-17 11:45:22'),(4159,'1','313',1,'Retail Sale Id 4237',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 11:47:53'),(4160,'1','313',1,'Retail Sale Id 4238',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 11:49:39'),(4161,'1','313',1,'Retail Sale Id 4239',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 11:50:46'),(4162,'1','313',1,'Retail Sale Id 4240',0.00,605.00,710.00,710.00,105.00,'2023-03-17 11:52:02'),(4163,'1','313',1,'Retail Sale Id 4241',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 11:54:09'),(4164,'1','313',1,'Retail Sale Id 4242',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 11:54:56'),(4165,'1','313',1,'Retail Sale Id 4243',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 11:55:52'),(4166,'1','313',1,'Retail Sale Id 4244',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 11:56:54'),(4167,'1','313',1,'Retail Sale Id 4245',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 11:59:31'),(4168,'1','313',1,'Retail Sale Id 4246',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 12:00:17'),(4169,'1','313',1,'Retail Sale Id 4247',0.00,1234.20,710.00,1448.40,214.20,'2023-03-17 12:01:06'),(4170,'1','313',1,'Retail Sale Id 4248',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-17 12:02:43'),(4171,'1','313',1,'Retail Sale Id 4249',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 12:05:09'),(4172,'1','313',1,'Retail Sale Id 4250',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-17 12:06:14'),(4173,'1','313',1,'Retail Sale Id 4251',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 12:07:36'),(4174,'1','313',1,'Retail Sale Id 4252',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 12:09:41'),(4175,'1','313',1,'Retail Sale Id 4253',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 12:10:46'),(4176,'1','313',1,'Retail Sale Id 4254',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 12:12:33'),(4177,'1','313',1,'Retail Sale Id 4255',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 12:13:54'),(4178,'1','313',1,'Retail Sale Id 4256',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 12:15:23'),(4179,'1','313',1,'Retail Sale Id 4257',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 12:17:04'),(4180,'1','313',1,'Retail Sale Id 4258',0.00,27085.85,670.00,29995.90,2910.05,'2023-03-17 12:19:54'),(4181,'1','313',1,'Retail Sale Id 4259',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 12:21:19'),(4182,'1','313',1,'Retail Sale Id 4260',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 12:23:00'),(4183,'1','313',1,'Retail Sale Id 4261',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 12:23:42'),(4184,'1','313',1,'Retail Sale Id 4262',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 12:25:12'),(4185,'1','313',1,'Retail Sale Id 4264',0.00,23595.00,670.00,26130.00,2535.00,'2023-03-17 12:31:23'),(4186,'1','313',1,'Retail Sale Id 4265',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 12:33:45'),(4187,'1','313',1,'Retail Sale Id 4266',0.00,33275.00,670.00,36850.00,3575.00,'2023-03-17 12:35:01'),(4188,'1','313',1,'Retail Sale Id 4267',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 12:36:10'),(4189,'1','313',1,'Retail Sale Id 4268',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 12:37:12'),(4190,'1','313',1,'Retail Sale Id 4269',0.00,605.00,710.00,710.00,105.00,'2023-03-17 12:38:00'),(4191,'1','313',1,'Retail Sale Id 4270',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 12:38:50'),(4192,'1','313',1,'Retail Sale Id 4271',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 12:40:00'),(4193,'1','313',1,'Retail Sale Id 4272',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 12:41:36'),(4194,'1','313',1,'Retail Sale Id 4273',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 12:42:22'),(4195,'1','313',1,'Retail Sale Id 4274',0.00,1276.55,710.00,1498.10,221.55,'2023-03-17 12:43:18'),(4196,'1','313',1,'Retail Sale Id 4275',0.00,1706.10,710.00,2002.20,296.10,'2023-03-17 12:44:00'),(4197,'1','313',1,'Retail Sale Id 4276',0.00,8470.00,710.00,9940.00,1470.00,'2023-03-17 12:47:58'),(4198,'1','313',1,'Retail Sale Id 4277',0.00,60500.00,670.00,67000.00,6500.00,'2023-03-17 12:50:10'),(4199,'1','313',1,'Retail Sale Id 4278',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 12:51:58'),(4200,'1','313',1,'Retail Sale Id 4279',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 12:53:09'),(4201,'1','313',1,'Retail Sale Id 4280',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 12:55:54'),(4202,'1','313',1,'Retail Sale Id 4281',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 12:56:47'),(4203,'1','313',1,'Retail Sale Id 4282',0.00,4235.00,710.00,4970.00,735.00,'2023-03-17 12:58:03'),(4204,'1','313',1,'Retail Sale Id 4283',0.00,1361.25,710.00,1597.50,236.25,'2023-03-17 12:59:42'),(4205,'1','313',1,'Retail Sale Id 4284',0.00,4235.00,710.00,4970.00,735.00,'2023-03-17 13:02:08'),(4206,'1','313',1,'Retail Sale Id 4285',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 13:04:10'),(4207,'1','313',1,'Retail Sale Id 4286',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 13:05:04'),(4208,'1','313',1,'Retail Sale Id 4288',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 13:07:40'),(4209,'1','313',1,'Retail Sale Id 4289',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 13:11:03'),(4210,'1','313',1,'Retail Sale Id 4290',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 13:11:56'),(4211,'1','313',1,'Retail Sale Id 4291',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 13:12:54'),(4212,'1','313',1,'Retail Sale Id 4292',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-17 13:15:36'),(4213,'1','313',1,'Retail Sale Id 4293',0.00,605.00,710.00,710.00,105.00,'2023-03-17 13:16:41'),(4214,'1','313',1,'Retail Sale Id 4294',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-17 13:18:14'),(4215,'1','313',1,'Retail Sale Id 4296',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 13:19:56'),(4216,'1','313',1,'Retail Sale Id 4297',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 13:21:06'),(4217,'1','313',1,'Retail Sale Id 4298',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 13:22:03'),(4218,'1','313',1,'Retail Sale Id 4299',0.00,605.00,710.00,710.00,105.00,'2023-03-17 13:23:08'),(4219,'1','313',1,'Retail Sale Id 4300',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-17 13:24:42'),(4220,'1','313',1,'Retail Sale Id 4301',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 13:25:59'),(4221,'1','313',1,'Retail Sale Id 4302',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 13:27:15'),(4222,'1','313',1,'Retail Sale Id 4303',0.00,32670.00,670.00,36180.00,3510.00,'2023-03-17 13:30:42'),(4223,'1','313',1,'Retail Sale Id 4304',0.00,605.00,710.00,710.00,105.00,'2023-03-17 13:31:48'),(4224,'1','313',1,'Retail Sale Id 4306',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 13:33:46'),(4225,'1','313',1,'Retail Sale Id 4307',0.00,1234.20,710.00,1448.40,214.20,'2023-03-17 13:34:59'),(4226,'1','313',1,'Retail Sale Id 4308',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-17 13:35:39'),(4227,'1','313',1,'Retail Sale Id 4309',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 13:36:37'),(4228,'1','313',1,'Retail Sale Id 4310',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 13:38:00'),(4229,'1','313',1,'Retail Sale Id 4311',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 13:38:31'),(4230,'1','313',1,'Retail Sale Id 4312',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 13:39:37'),(4231,'1','313',1,'Retail Sale Id 4313',0.00,5445.00,710.00,6390.00,945.00,'2023-03-17 13:42:40'),(4232,'1','313',1,'Retail Sale Id 4314',0.00,641.30,710.00,752.60,111.30,'2023-03-17 13:43:33'),(4233,'1','313',1,'Retail Sale Id 4315',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 13:44:50'),(4234,'1','313',1,'Retail Sale Id 4316',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 13:56:24'),(4235,'1','313',1,'Retail Sale Id 4317',0.00,605.00,710.00,710.00,105.00,'2023-03-17 13:57:23'),(4236,'1','313',1,'Retail Sale Id 4318',0.00,605.00,710.00,710.00,105.00,'2023-03-17 13:58:09'),(4237,'1','313',1,'Retail Sale Id 4319',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 14:00:36'),(4238,'1','313',1,'Retail Sale Id 4320',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 14:01:46'),(4239,'1','313',1,'Retail Sale Id 4321',0.00,1706.10,710.00,2002.20,296.10,'2023-03-17 14:03:58'),(4240,'1','313',1,'Retail Sale Id 4322',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 14:04:56'),(4241,'1','313',1,'Retail Sale Id 4323',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 14:05:51'),(4242,'1','313',1,'Retail Sale Id 4324',0.00,2426.05,710.00,2847.10,421.05,'2023-03-17 14:07:11'),(4243,'1','313',1,'Retail Sale Id 4325',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 14:07:50'),(4244,'1','313',1,'Retail Sale Id 4326',0.00,1833.15,710.00,2151.30,318.15,'2023-03-17 14:08:59'),(4245,'1','313',1,'Retail Sale Id 4327',0.00,1276.55,710.00,1498.10,221.55,'2023-03-17 14:10:31'),(4246,'1','313',1,'Retail Sale Id 4328',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 14:12:55'),(4247,'1','313',1,'Retail Sale Id 4329',0.00,641.30,710.00,752.60,111.30,'2023-03-17 14:13:49'),(4248,'1','313',1,'Retail Sale Id 4330',0.00,1276.55,710.00,1498.10,221.55,'2023-03-17 14:17:45'),(4249,'1','313',1,'Retail Sale Id 4331',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 14:19:34'),(4250,'1','313',1,'Retail Sale Id 4332',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 14:22:03'),(4251,'1','313',1,'Retail Sale Id 4333',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-17 14:23:55'),(4252,'1','313',1,'Retail Sale Id 4334',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 14:25:15'),(4253,'1','313',1,'Retail Sale Id 4335',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 14:26:18'),(4254,'1','313',1,'Retail Sale Id 4336',0.00,2982.65,710.00,3500.30,517.65,'2023-03-17 14:27:41'),(4255,'1','313',1,'Retail Sale Id 4337',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 14:29:34'),(4256,'1','313',1,'Retail Sale Id 4338',0.00,3406.15,710.00,3997.30,591.15,'2023-03-17 14:31:04'),(4257,'1','313',1,'Retail Sale Id 4339',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 14:32:06'),(4258,'1','313',1,'Retail Sale Id 4340',0.00,35695.00,670.00,39530.00,3835.00,'2023-03-17 14:35:53'),(4259,'1','313',1,'Retail Sale Id 4341',0.00,1234.20,710.00,1448.40,214.20,'2023-03-17 14:36:43'),(4260,'1','313',1,'Retail Sale Id 4342',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 14:38:07'),(4261,'1','313',1,'Retail Sale Id 4343',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 14:39:25'),(4262,'1','313',1,'Retail Sale Id 4344',0.00,605.00,710.00,710.00,105.00,'2023-03-17 14:40:12'),(4263,'1','313',1,'Retail Sale Id 4345',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 14:41:12'),(4264,'1','313',1,'Retail Sale Id 4346',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 14:41:53'),(4265,'1','313',1,'Retail Sale Id 4347',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 14:42:58'),(4266,'1','313',1,'Retail Sale Id 4348',0.00,8470.00,710.00,9940.00,1470.00,'2023-03-17 14:44:39'),(4267,'1','313',1,'Retail Sale Id 4349',0.00,7260.00,710.00,8520.00,1260.00,'2023-03-17 14:45:36'),(4268,'1','313',1,'Retail Sale Id 4350',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 14:46:25'),(4269,'1','313',1,'Retail Sale Id 4351',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 14:47:22'),(4270,'1','313',1,'Retail Sale Id 4352',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-17 14:48:03'),(4271,'1','313',1,'Retail Sale Id 4353',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 14:49:14'),(4272,'1','313',1,'Retail Sale Id 4354',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 14:52:03'),(4273,'1','313',1,'Retail Sale Id 4356',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 14:53:57'),(4274,'1','313',1,'Retail Sale Id 4358',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-17 14:57:34'),(4275,'1','313',1,'Retail Sale Id 4359',0.00,2117.50,710.00,2485.00,367.50,'2023-03-17 15:00:05'),(4276,'1','313',1,'Retail Sale Id 4360',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 15:02:38'),(4277,'1','313',1,'Retail Sale Id 4362',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 15:06:57'),(4278,'1','313',1,'Retail Sale Id 4363',0.00,4235.00,710.00,4970.00,735.00,'2023-03-17 15:08:16'),(4279,'1','313',1,'Retail Sale Id 4364',0.00,605.00,710.00,710.00,105.00,'2023-03-17 15:09:59'),(4280,'1','313',1,'Retail Sale Id 4366',0.00,2559.15,710.00,3003.30,444.15,'2023-03-17 15:11:46'),(4281,'1','313',1,'Retail Sale Id 4367',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 15:13:07'),(4282,'1','313',1,'Retail Sale Id 4368',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 15:13:58'),(4283,'1','313',1,'Retail Sale Id 4369',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 15:14:59'),(4284,'1','313',1,'Retail Sale Id 4370',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 15:15:54'),(4285,'1','313',1,'Retail Sale Id 4372',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-17 15:19:02'),(4286,'1','313',1,'Retail Sale Id 4373',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 15:19:55'),(4287,'1','313',1,'Retail Sale Id 4374',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 15:20:35'),(4288,'1','313',1,'Retail Sale Id 4375',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 15:21:13'),(4289,'1','313',1,'Retail Sale Id 4377',0.00,937.75,710.00,1100.50,162.75,'2023-03-17 15:23:12'),(4290,'1','313',1,'Retail Sale Id 4378',0.00,605.00,710.00,710.00,105.00,'2023-03-17 15:23:58'),(4291,'1','313',1,'Retail Sale Id 4379',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 15:24:37'),(4292,'1','313',1,'Retail Sale Id 4380',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 15:25:22'),(4293,'1','313',1,'Retail Sale Id 4381',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-17 15:28:08'),(4294,'1','313',1,'Retail Sale Id 4382',0.00,4235.00,710.00,4970.00,735.00,'2023-03-17 15:28:59'),(4295,'1','313',1,'Retail Sale Id 4383',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-17 15:30:36'),(4296,'1','313',1,'Retail Sale Id 4384',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 15:34:56'),(4297,'1','313',1,'Retail Sale Id 4385',0.00,641.30,710.00,752.60,111.30,'2023-03-17 15:38:35'),(4298,'1','313',1,'Retail Sale Id 4386',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 15:39:08'),(4299,'1','313',1,'Retail Sale Id 4387',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 15:40:18'),(4300,'1','313',1,'Retail Sale Id 4388',0.00,605.00,710.00,710.00,105.00,'2023-03-17 15:42:57'),(4301,'1','313',1,'Retail Sale Id 4389',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 15:44:08'),(4302,'1','313',1,'Retail Sale Id 4390',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-17 15:45:49'),(4303,'1','313',1,'Retail Sale Id 4391',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 15:46:28'),(4304,'1','313',1,'Retail Sale Id 4392',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 15:47:02'),(4305,'1','313',1,'Retail Sale Id 4393',0.00,2559.15,710.00,3003.30,444.15,'2023-03-17 15:47:54'),(4306,'1','313',1,'Retail Sale Id 4394',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 15:48:39'),(4307,'1','313',1,'Retail Sale Id 4395',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 15:49:55'),(4308,'1','313',1,'Retail Sale Id 4396',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 15:50:32'),(4309,'1','313',1,'Retail Sale Id 4397',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 15:51:33'),(4310,'1','313',1,'Retail Sale Id 4398',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 15:52:41'),(4311,'1','313',1,'Retail Sale Id 4399',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-17 15:53:32'),(4312,'1','313',1,'Retail Sale Id 4400',0.00,1234.20,710.00,1448.40,214.20,'2023-03-17 15:54:38'),(4313,'1','313',1,'Retail Sale Id 4401',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 15:55:25'),(4314,'1','313',1,'Retail Sale Id 4402',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 15:56:22'),(4315,'1','313',1,'Retail Sale Id 4403',0.00,4235.00,710.00,4970.00,735.00,'2023-03-17 15:57:10'),(4316,'1','313',1,'Retail Sale Id 4404',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 15:58:03'),(4317,'1','313',1,'Retail Sale Id 4405',0.00,19232.95,670.00,21299.30,2066.35,'2023-03-17 15:59:17'),(4318,'1','313',1,'Retail Sale Id 4406',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 16:00:19'),(4319,'1','313',1,'Retail Sale Id 4407',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 16:01:10'),(4320,'1','313',1,'Retail Sale Id 4408',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 16:02:06'),(4321,'1','313',1,'Retail Sale Id 4409',0.00,4259.20,710.00,4998.40,739.20,'2023-03-17 16:03:09'),(4322,'1','313',1,'Retail Sale Id 4410',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 16:04:13'),(4323,'1','313',1,'Retail Sale Id 4411',0.00,605.00,710.00,710.00,105.00,'2023-03-17 16:05:33'),(4324,'1','313',1,'Retail Sale Id 4412',0.00,641.30,710.00,752.60,111.30,'2023-03-17 16:06:49'),(4325,'1','313',1,'Retail Sale Id 4413',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 16:07:27'),(4326,'1','313',1,'Retail Sale Id 4414',0.00,60500.00,670.00,67000.00,6500.00,'2023-03-17 16:08:45'),(4327,'1','313',1,'Retail Sale Id 4415',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 16:09:23'),(4328,'1','313',1,'Retail Sale Id 4416',0.00,605.00,710.00,710.00,105.00,'2023-03-17 16:09:56'),(4329,'1','313',1,'Retail Sale Id 4417',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 16:10:38'),(4330,'1','313',1,'Retail Sale Id 4418',0.00,12100.00,710.00,14200.00,2100.00,'2023-03-17 16:11:57'),(4331,'1','313',1,'Retail Sale Id 4419',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 16:12:41'),(4332,'1','313',1,'Retail Sale Id 4420',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 16:13:33'),(4333,'1','313',1,'Retail Sale Id 4421',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 16:14:33'),(4334,'1','313',1,'Retail Sale Id 4422',0.00,605.00,710.00,710.00,105.00,'2023-03-17 16:15:31'),(4335,'1','313',1,'Retail Sale Id 4423',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 16:16:20'),(4336,'1','313',1,'Retail Sale Id 4425',0.00,641.30,710.00,752.60,111.30,'2023-03-17 16:18:19'),(4337,'1','313',1,'Retail Sale Id 4426',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-17 16:18:52'),(4338,'1','313',1,'Retail Sale Id 4427',0.00,605.00,710.00,710.00,105.00,'2023-03-17 16:19:36'),(4339,'1','313',1,'Retail Sale Id 4428',0.00,4235.00,710.00,4970.00,735.00,'2023-03-17 16:20:16'),(4340,'1','313',1,'Retail Sale Id 4429',0.00,605.00,710.00,710.00,105.00,'2023-03-17 16:21:01'),(4341,'1','313',1,'Retail Sale Id 4430',0.00,22385.00,670.00,24790.00,2405.00,'2023-03-17 16:23:03'),(4342,'1','313',1,'Retail Sale Id 4431',0.00,605.00,710.00,710.00,105.00,'2023-03-17 16:24:25'),(4343,'1','313',1,'Retail Sale Id 4432',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-17 16:25:37'),(4344,'1','313',1,'Retail Sale Id 4433',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 16:26:59'),(4345,'1','313',1,'Retail Sale Id 4434',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-17 16:27:57'),(4346,'1','313',1,'Retail Sale Id 4435',0.00,4840.00,710.00,5680.00,840.00,'2023-03-17 16:28:39'),(4347,'1','313',1,'Retail Sale Id 4436',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 16:29:25'),(4348,'1','313',1,'Retail Sale Id 4437',0.00,605.00,710.00,710.00,105.00,'2023-03-17 16:30:07'),(4349,'1','313',1,'Retail Sale Id 4438',0.00,4235.00,710.00,4970.00,735.00,'2023-03-17 16:31:53'),(4350,'1','313',1,'Retail Sale Id 4439',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 16:32:37'),(4351,'1','313',1,'Retail Sale Id 4440',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 16:33:21'),(4352,'1','313',1,'Retail Sale Id 4441',0.00,4235.00,710.00,4970.00,735.00,'2023-03-17 16:34:14'),(4353,'1','313',1,'Retail Sale Id 4442',0.00,605.00,710.00,710.00,105.00,'2023-03-17 16:34:58'),(4354,'1','313',1,'Retail Sale Id 4443',0.00,36300.00,670.00,40200.00,3900.00,'2023-03-17 16:35:56'),(4355,'1','313',1,'Retail Sale Id 4444',0.00,4840.00,710.00,5680.00,840.00,'2023-03-17 16:36:42'),(4356,'1','313',1,'Retail Sale Id 4445',0.00,641.30,710.00,752.60,111.30,'2023-03-17 16:37:35'),(4357,'1','313',1,'Retail Sale Id 4446',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 16:38:27'),(4358,'1','313',1,'Retail Sale Id 4447',0.00,1234.20,710.00,1448.40,214.20,'2023-03-17 16:40:19'),(4359,'1','313',1,'Retail Sale Id 4448',0.00,7865.00,710.00,9230.00,1365.00,'2023-03-17 16:41:10'),(4360,'1','313',1,'Retail Sale Id 4449',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 16:41:55'),(4361,'1','313',1,'Retail Sale Id 4450',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 16:42:57'),(4362,'1','313',1,'Retail Sale Id 4451',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 16:43:55'),(4363,'1','313',1,'Retail Sale Id 4453',0.00,30250.00,670.00,33500.00,3250.00,'2023-03-17 16:45:13'),(4364,'1','313',1,'Retail Sale Id 4454',0.00,4840.00,710.00,5680.00,840.00,'2023-03-17 16:45:56'),(4365,'1','313',1,'Retail Sale Id 4455',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 16:46:54'),(4366,'1','313',1,'Retail Sale Id 4456',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 16:48:04'),(4367,'1','313',1,'Retail Sale Id 4457',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 16:48:45'),(4368,'1','313',1,'Retail Sale Id 4458',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 16:49:30'),(4369,'1','313',1,'Retail Sale Id 4459',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 16:50:17'),(4370,'1','313',1,'Retail Sale Id 4460',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 16:51:09'),(4371,'1','313',1,'Retail Sale Id 4461',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 16:51:39'),(4372,'1','313',1,'Retail Sale Id 4462',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 16:52:24'),(4373,'1','313',1,'Retail Sale Id 4463',0.00,7562.50,710.00,8875.00,1312.50,'2023-03-17 16:53:06'),(4374,'1','313',1,'Retail Sale Id 4464',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 16:54:16'),(4375,'1','313',1,'Retail Sale Id 4465',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 16:54:56'),(4376,'1','313',1,'Retail Sale Id 4466',0.00,6655.00,710.00,7810.00,1155.00,'2023-03-17 16:56:00'),(4377,'1','313',1,'Retail Sale Id 4467',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 16:56:42'),(4378,'1','313',1,'Retail Sale Id 4468',0.00,4235.00,710.00,4970.00,735.00,'2023-03-17 16:57:18'),(4379,'1','313',1,'Retail Sale Id 4469',0.00,605.00,710.00,710.00,105.00,'2023-03-17 16:57:57'),(4380,'1','313',1,'Retail Sale Id 4470',0.00,1706.10,710.00,2002.20,296.10,'2023-03-17 16:58:39'),(4381,'1','313',1,'Retail Sale Id 4471',0.00,605.00,710.00,710.00,105.00,'2023-03-17 16:59:13'),(4382,'1','313',1,'Retail Sale Id 4472',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 17:00:38'),(4383,'1','313',1,'Retail Sale Id 4473',0.00,1234.20,710.00,1448.40,214.20,'2023-03-17 17:01:24'),(4384,'1','313',1,'Retail Sale Id 4474',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 17:02:01'),(4385,'1','313',1,'Retail Sale Id 4475',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 17:02:47'),(4386,'1','313',1,'Retail Sale Id 4476',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 17:03:20'),(4387,'1','313',1,'Retail Sale Id 4477',0.00,6050.00,710.00,7100.00,1050.00,'2023-03-17 17:04:06'),(4388,'1','313',1,'Retail Sale Id 4478',0.00,2559.15,710.00,3003.30,444.15,'2023-03-17 17:04:45'),(4389,'1','313',1,'Return of Retail Sale Id 4478',2559.15,0.00,710.00,-3003.30,-444.15,'2023-03-17 17:05:24'),(4390,'1','313',1,'Retail Sale Id 4479',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 17:05:52'),(4391,'1','313',1,'Retail Sale Id 4480',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 17:06:30'),(4392,'1','313',1,'Retail Sale Id 4481',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 17:07:06'),(4393,'1','313',1,'Retail Sale Id 4482',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 17:07:48'),(4394,'1','313',1,'Retail Sale Id 4483',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 17:08:27'),(4395,'1','313',1,'Retail Sale Id 4484',0.00,3630.00,710.00,4260.00,630.00,'2023-03-17 17:09:08'),(4396,'1','313',1,'Retail Sale Id 4485',0.00,605.00,710.00,710.00,105.00,'2023-03-17 17:09:47'),(4397,'1','313',1,'Retail Sale Id 4486',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 17:10:35'),(4398,'1','313',1,'Retail Sale Id 4487',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 17:11:24'),(4399,'1','313',1,'Retail Sale Id 4488',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 17:12:00'),(4400,'1','313',1,'Retail Sale Id 4490',0.00,13479.40,710.00,15818.80,2339.40,'2023-03-17 17:13:28'),(4401,'1','313',1,'Return of Retail Sale Id 4490',13479.40,0.00,710.00,-15818.80,-2339.40,'2023-03-17 17:13:51'),(4402,'1','313',1,'Retail Sale Id 4491',0.00,13612.50,710.00,15975.00,2362.50,'2023-03-17 17:14:17'),(4403,'1','313',1,'Return of Retail Sale Id 4491',13612.50,0.00,710.00,-15975.00,-2362.50,'2023-03-17 17:15:00'),(4404,'1','313',1,'Retail Sale Id 4492',0.00,13310.00,710.00,15620.00,2310.00,'2023-03-17 17:16:00'),(4405,'1','313',1,'Retail Sale Id 4493',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 17:17:00'),(4406,'1','313',1,'Retail Sale Id 4494',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 17:18:02'),(4407,'1','313',1,'Retail Sale Id 4495',0.00,2420.00,710.00,2840.00,420.00,'2023-03-17 17:19:11'),(4408,'1','313',1,'Retail Sale Id 4496',0.00,1815.00,710.00,2130.00,315.00,'2023-03-17 17:20:02'),(4409,'1','313',1,'Retail Sale Id 4497',0.00,641.30,710.00,752.60,111.30,'2023-03-17 17:21:20'),(4410,'1','313',1,'Retail Sale Id 4498',0.00,853.05,710.00,1001.10,148.05,'2023-03-17 17:23:16'),(4411,'1','313',1,'Retail Sale Id 4499',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 17:24:57'),(4412,'1','313',1,'Retail Sale Id 4500',0.00,1210.00,710.00,1420.00,210.00,'2023-03-17 17:25:55'),(4413,'1','313',1,'Retail Sale Id 4501',0.00,3025.00,710.00,3550.00,525.00,'2023-03-17 17:26:41'),(4414,'1','313',1,'Retail Sale Id 4502',0.00,1815.00,710.00,2130.00,315.00