-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_312
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_312`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_312` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_312`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,4000,'',0,'22','1','312','PURCHASES','','2023-01-23 01:48:52',5,0.00,0.00,'','479','2023-01-23 01:48:52','479',0,0),(2,8000,'',0,'24','1','312','PURCHASES','','2023-01-23 01:49:09',5,0.00,0.00,'','479','2023-01-23 01:49:09','479',0,0),(3,7000,'',0,'20','1','312','SALES','','2023-01-23 01:49:22',5,0.00,0.00,'','479','2023-01-23 01:49:22','479',0,0),(4,500,'',0,'6.1','1','312','CASH','','2023-01-23 01:49:46',5,0.00,0.00,'','479','2023-01-23 01:49:46','479',0,0),(5,8001,'',0,'24','1','312','SALARIES & WAGES','','2023-01-23 01:50:15',5,0.00,0.00,'','479','2023-01-23 01:50:15','479',0,0),(6,2500,'',0,'2','1','312','ZB(LPG)1014471475','','2023-01-23 01:51:24',5,0.00,0.00,'','479','2023-01-23 01:51:24','479',0,0),(7,2501,'',0,'2','1','312','ZNB E-BILL COLLECTION :1014717','','2023-01-23 01:51:35',5,0.00,0.00,'','479','2023-01-23 01:51:35','479',0,0),(8,2502,'',0,'2','1','312','ZNB-:POS 1015965368','','2023-01-23 01:51:48',5,0.00,0.00,'','479','2023-01-23 01:51:48','479',0,0),(9,2503,'',0,'2','1','312','UNITY BANK-0024061656','','2023-01-23 01:52:09',5,0.00,0.00,'','479','2023-01-23 01:52:09','479',0,0),(10,2504,'',0,'2','1','312','UBA-0039769388','','2023-01-23 01:52:21',5,0.00,0.00,'','479','2023-01-23 01:52:21','479',0,0),(11,2505,'',0,'2','1','312','UBA YOLA-1021398099','','2023-01-23 01:52:32',5,0.00,0.00,'','479','2023-01-23 01:52:32','479',0,0),(12,2506,'',0,'2','1','312','UBA-1019882661','','2023-01-23 01:52:46',5,0.00,0.00,'','479','2023-01-23 01:52:46','479',0,0),(13,2507,'',0,'2','1','312','FID POS COLLECTION-5620141491','','2023-01-23 01:53:11',5,0.00,0.00,'','479','2023-01-23 01:53:11','479',0,0),(14,2508,'',0,'2','1','312','FB(IBAL)2023855223','','2023-01-23 01:53:22',5,0.00,0.00,'','479','2023-01-23 01:53:22','479',0,0),(15,2509,'',0,'2','1','312','POLARIS BANK KEBBI:4091417377','','2023-01-23 01:53:38',5,0.00,0.00,'','479','2023-01-23 01:53:38','479',0,0),(16,2510,'',0,'2','1','312','TAJJ BANK CITY GATE:0001875361','','2023-01-23 01:53:51',5,0.00,0.00,'','479','2023-01-23 01:53:51','479',0,0),(17,2511,'',0,'2','1','312','E-BILLS  IBAL 1015372548','','2023-01-23 01:54:02',5,0.00,0.00,'','479','2023-01-23 01:54:02','479',0,0),(18,2512,'',0,'2','1','312','E-BILLS 1015372548','','2023-01-23 01:54:13',5,0.00,0.00,'','479','2023-01-23 01:54:13','479',0,0),(19,2513,'',0,'2','1','312','DANKANO-EBILLS:ZNB1014717618','','2023-01-23 01:55:31',5,0.00,0.00,'','479','2023-01-23 01:55:31','479',0,0),(20,2514,'',0,'2','1','312','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:28:19',5,0.00,0.00,'','792','2023-02-20 14:28:19','792',0,0),(21,2515,'',0,'2','1','312','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:32:27',5,0.00,0.00,'2023-03-15','792','2023-03-17 13:46:23','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','312','VICTOR GAS','VICTOR','08034183596','kabiruhabibu651@gmail.com','OWERRI CITY','IMO STATE','IRETE','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-18 16:04:11',5,'1027','2023-02-18 16:04:11','1027'),(2,'','1','312','UKLEO GAS','08064145320','08064145320','kabiruhabibu651@gmail.com','OWERRI CITY','IMO STATE','AFOR IRETE MARKET','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-18 18:12:01',5,'1027','2023-02-18 18:12:01','1027'),(3,'','1','312','JOSIAH GAS','07033059724','07033059724','kabiruhabibu651@gmail.com','OWERRI CITY','IMO STATE','Living Wold','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 10:03:05',5,'1027','2023-02-21 10:03:05','1027'),(4,'','1','312','PZ GAS','Umuyo Irete','08063508191','kabiruhabibu651@gmail.com','OWERRI CITY','IMO STATE','Umuyo Irete','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 11:59:26',5,'1027','2023-02-21 11:59:26','1027'),(5,'','1','312','212 GAS','07034290518','07034290518','kabiruhabibu651@gmail.com','OWERRI CITY','IMO STATE','AKWAKUMA ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-23 17:05:19',5,'1027','2023-02-23 17:05:19','1027'),(6,'','1','312','EMEKA GAS','08169860051','08169860051','kabiruhabibu651@gmail.com','OWERRI CITY','IMO STATE','CHUKUTEMEKA  ANUMUDI','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-24 18:36:33',5,'1027','2023-02-24 18:36:33','1027'),(7,'','1','312','COOK AND   SMILE GAS','PHILIP OJUKWU','07030132192','kabiruhabibu651@gmail.com','OWERRI CITY','IMO STATE','AMAKOHIA AVENUE','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-04 10:14:41',5,'1027','2023-03-04 10:14:41','1027'),(8,'','1','312','uche gas','09150527512','09150527512','kabiruhabibu651@gmail.com','OWERRI CITY','IMO STATE','ukigwe omakoya owerri','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-12 10:33:28',5,'1027','2023-03-12 10:33:28','1027');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','312','1',1,'5','LPG NOZZLE 1',8602.36,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','312','1',2,'5','LPG NOZZLE 2',6274.87,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','312',1,'DAILY SHIFT','2023-02-02','2023-02-02 11:43:30','2023-02-03 11:43:30','1027',0.00,0.00,'1027','2023-02-04 08:10:10','1027','2023-02-04 08:10:43',10,0),('1','312',2,'DAILY SHIFT','2023-02-04','2023-02-04 08:11:37','2023-02-05 08:11:37','1027',0.00,0.00,'1027','2023-02-04 09:33:37','1027','2023-02-04 09:42:01',10,0),('1','312',3,'DAILY SHIFT','2023-02-04','2023-02-04 09:42:47','2023-02-05 09:42:47','1027',0.00,0.00,'1027','2023-02-04 20:27:07','1027','2023-02-04 20:27:41',10,0),('1','312',4,'DAILY SHIFT','2023-02-05','2023-02-05 07:41:04','2023-02-06 07:41:04','1027',0.00,0.00,'1027','2023-02-05 19:38:37','1027','2023-02-05 19:39:13',10,0),('1','312',5,'DAILY SHIFT','2023-02-07','2023-02-07 07:41:06','2023-02-08 07:41:06','1027',0.00,0.00,'1027','2023-02-07 20:31:05','1027','2023-02-07 20:31:40',10,0),('1','312',6,'DAILY SHIFT','2023-02-08','2023-02-08 07:21:21','2023-02-09 07:21:21','1027',0.00,0.00,'1027','2023-02-08 19:34:10','1027','2023-02-08 19:34:34',10,0),('1','312',7,'DAILY SHIFT','2023-02-09','2023-02-09 07:43:38','2023-02-10 07:43:38','1027',0.00,0.00,'1027','2023-02-09 20:49:11','1027','2023-02-09 20:49:56',10,0),('1','312',8,'DAILY SHIFT','2023-02-10','2023-02-10 08:00:59','2023-02-11 08:00:59','1027',0.00,0.00,'1027','2023-02-10 19:53:36','1027','2023-02-10 19:53:59',10,0),('1','312',9,'DAILY SHIFT','2023-02-11','2023-02-11 07:20:56','2023-02-12 07:20:56','1027',0.00,0.00,'1027','2023-02-11 20:21:58','1027','2023-02-11 20:22:27',10,0),('1','312',10,'DAILY SHIFT','2023-02-12','2023-02-12 07:35:35','2023-02-13 07:35:35','1027',0.00,0.00,'1027','2023-02-12 20:24:55','1027','2023-02-12 20:25:24',10,0),('1','312',11,'DAILY SHIFT','2023-02-14','2023-02-14 07:48:50','2023-02-15 07:48:50','1027',0.00,0.00,'1027','2023-02-14 15:00:04','1027','2023-02-14 15:00:38',10,0),('1','312',12,'DAILY SHIFT','2023-02-14','2023-02-14 15:03:55','2023-02-15 15:03:55','1027',0.00,0.00,'1027','2023-02-14 20:20:37','1027','2023-02-14 20:21:05',10,0),('1','312',13,'DAILY SHIFT','2023-02-15','2023-02-15 07:25:23','2023-02-16 07:25:23','1027',0.00,0.00,'1027','2023-02-15 20:27:02','1027','2023-02-15 20:27:41',10,0),('1','312',14,'DIALY SHIFT','2023-02-16','2023-02-16 06:40:53','2023-02-17 06:40:53','1027',0.00,0.00,'1027','2023-02-16 19:52:10','1027','2023-02-16 19:52:43',10,0),('1','312',15,'DAILY SHIFT','2023-02-17','2023-02-17 07:07:33','2023-02-18 07:07:33','1027',0.00,0.00,'1027','2023-02-17 19:35:32','1027','2023-02-17 19:36:02',10,0),('1','312',16,'DAILY SHIFT','2023-02-18','2023-02-18 07:40:30','2023-02-19 07:40:30','1027',0.00,0.00,'1027','2023-02-18 21:17:14','1027','2023-02-18 21:17:42',10,0),('1','312',17,'DAILY SHIFT','2023-02-19','2023-02-19 08:38:11','2023-02-20 08:38:11','1027',0.00,0.00,'1027','2023-02-19 20:36:30','1027','2023-02-19 20:37:49',10,0),('1','312',18,'DAILY SHIFT','2023-02-21','2023-02-21 07:40:03','2023-02-22 07:40:03','1027',0.00,0.00,'1027','2023-02-21 20:14:30','1027','2023-02-21 20:14:58',10,0),('1','312',19,'DAILY SHIFT','2023-02-22','2023-02-22 07:18:28','2023-02-23 07:18:28','1027',0.00,0.00,'1027','2023-02-23 07:35:35','1027','2023-02-23 07:35:58',10,0),('1','312',20,'DAILY SHIFT','2023-02-23','2023-02-23 07:36:58','2023-02-24 07:36:58','1027',0.00,0.00,'1027','2023-02-23 12:55:40','1027','2023-02-23 12:56:14',10,0),('1','312',21,'DAILY SHIFT','2023-02-23','2023-02-23 13:05:43','2023-02-24 13:05:43','1027',0.00,0.00,'1027','2023-02-23 19:41:09','1027','2023-02-23 19:41:40',10,0),('1','312',22,'DAILY SHIFT','2023-02-24','2023-02-24 08:19:40','2023-02-25 08:19:40','1027',0.00,0.00,'1027','2023-02-24 19:12:55','1027','2023-02-24 19:13:42',10,0),('1','312',23,'DAILY SHIFT','2023-02-28','2023-02-28 07:56:19','2023-03-01 07:56:19','1027',0.00,0.00,'1027','2023-02-28 19:29:27','1027','2023-02-28 19:30:18',10,0),('1','312',24,'DAILY SHIFT','2023-03-01','2023-03-01 07:40:28','2023-03-02 07:40:28','1027',0.00,0.00,'1027','2023-03-01 19:44:25','1027','2023-03-01 19:45:32',10,0),('1','312',25,'DAILY SHIFT','2023-03-02','2023-03-02 08:15:26','2023-03-03 08:15:26','1027',0.00,0.00,'1027','2023-03-02 19:30:08','1027','2023-03-02 19:30:37',10,0),('1','312',26,'DAILY SHIFT','2023-03-03','2023-03-03 09:19:57','2023-03-04 09:19:57','1027',0.00,0.00,'1027','2023-03-03 19:33:06','1027','2023-03-03 19:33:38',10,0),('1','312',27,'DAILY SHIFT','2023-03-04','2023-03-04 07:40:26','2023-03-05 07:40:26','1027',0.00,0.00,'1027','2023-03-04 12:49:06','1027','2023-03-04 12:49:44',10,0),('1','312',28,'DAILY SHIFT','2023-03-08','2023-03-08 08:27:37','2023-03-09 08:27:37','1027',0.00,0.00,'1027','2023-03-08 19:18:34','1027','2023-03-09 07:28:17',10,0),('1','312',29,'DAILY SHIFT','2023-03-09','2023-03-09 07:29:06','2023-03-10 07:29:06','1027',0.00,0.00,'1027','2023-03-09 19:11:39','1027','2023-03-09 19:12:40',10,0),('1','312',30,'DIALY SHIFT','2023-03-10','2023-03-10 07:27:11','2023-03-11 07:27:11','1027',0.00,0.00,'1027','2023-03-10 19:28:45','1027','2023-03-10 19:29:25',10,0),('1','312',31,'DAILY SHIFT','2023-03-11','2023-03-11 07:22:56','2023-03-12 07:22:56','1027',0.00,0.00,'1027','2023-03-11 19:21:44','1027','2023-03-11 19:22:09',10,0),('1','312',32,'DAILY SHIFT','2023-03-12','2023-03-12 07:39:05','2023-03-13 07:39:05','1027',0.00,0.00,'1027','2023-03-12 18:42:08','1027','2023-03-12 18:42:34',10,0),('1','312',33,'DAILY SHIFT','2023-03-14','2023-03-14 07:35:08','2023-03-15 07:35:08','1027',0.00,0.00,'1027','2023-03-14 19:27:39','1027','2023-03-14 19:28:05',10,0),('1','312',34,'DAILY SHIFT','2023-03-15','2023-03-15 06:59:09','2023-03-16 06:59:09','1027',0.00,0.00,'1027','2023-03-15 18:06:47','1027','2023-03-15 18:07:12',10,0),('1','312',35,'DAILY SHIFT','2023-03-16','2023-03-16 07:09:43','2023-03-17 07:09:43','1027',0.00,0.00,'1027','2023-03-16 19:26:17','1027','2023-03-16 19:26:42',10,0),('1','312',36,'DAILY SHIFT','2023-03-17','2023-03-17 07:13:19','2023-03-18 07:13:19','1027',0.00,0.00,'1027','2023-03-17 20:12:13','1027','2023-03-17 20:12:44',10,0),('1','312',37,'DIALY SHIFT','2023-03-19','2023-03-19 10:18:01','2023-03-20 10:18:01','1027',0.00,0.00,'1027','2023-03-19 19:19:48','1027','2023-03-19 19:20:16',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','312','1','1',1,'1','1',0.00,9.00,0.00,0.00,9.00,6840.00,0.00,0.00,0.00),('1','312','1','1',2,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','312','1','2',3,'1','1',9.00,103.35,0.00,0.00,94.35,71706.00,0.00,0.00,0.00),('1','312','1','2',4,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','312','1','3',5,'1','1',103.35,285.39,0.00,0.00,182.04,138350.40,0.00,0.00,0.00),('1','312','1','3',6,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','312','1','4',7,'1','1',285.39,463.39,0.00,0.00,178.00,135280.00,0.00,0.00,0.00),('1','312','1','4',8,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','312','1','5',9,'1','1',463.39,661.83,0.00,0.00,198.44,150814.40,0.00,0.00,0.00),('1','312','1','5',10,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','312','1','6',11,'1','1',661.83,824.69,0.00,0.00,162.86,123773.60,0.00,0.00,0.00),('1','312','1','6',12,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','312','1','7',13,'1','1',824.69,977.22,0.00,0.00,152.53,115922.80,0.00,0.00,0.00),('1','312','1','7',14,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','312','1','8',15,'1','1',977.22,1131.86,0.00,0.00,154.64,117526.40,0.00,0.00,0.00),('1','312','1','8',16,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','312','1','9',17,'1','1',1131.86,1292.87,0.00,0.00,161.01,122367.60,0.00,0.00,0.00),('1','312','1','9',18,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','312','1','10',19,'1','1',1292.87,1498.48,0.00,0.00,205.61,156263.60,0.00,0.00,0.00),('1','312','1','10',20,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','312','1','11',21,'1','1',1498.48,1594.05,0.00,0.00,95.57,72633.20,0.00,0.00,0.00),('1','312','1','11',22,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','312','1','12',23,'1','1',1594.05,1664.75,0.00,0.00,70.70,50904.00,0.00,0.00,0.00),('1','312','1','12',24,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','312','1','13',25,'1','1',1664.75,1820.79,0.00,0.00,156.04,112348.80,0.00,0.00,0.00),('1','312','1','13',26,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','312','1','14',27,'1','1',1820.79,2061.91,0.00,0.00,241.12,173606.40,0.00,0.00,0.00),('1','312','1','14',28,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','312','1','15',29,'1','1',2061.91,2201.52,0.00,0.00,139.61,100519.20,0.00,0.00,0.00),('1','312','1','15',30,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','312','1','16',31,'1','1',2201.52,2544.79,0.00,0.00,343.27,247154.40,0.00,0.00,0.00),('1','312','1','16',32,'2','1',0.00,592.41,0.00,0.00,592.41,400901.75,0.00,0.00,0.00),('1','312','1','17',33,'1','1',2544.79,2904.70,0.00,0.00,359.91,259135.20,0.00,0.00,0.00),('1','312','1','17',34,'2','1',592.41,592.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','312','1','18',35,'1','1',2904.70,3219.17,0.00,0.00,314.47,226418.40,0.00,0.00,0.00),('1','312','1','18',36,'2','1',592.41,1522.01,0.00,0.00,929.60,628880.00,0.00,0.00,0.00),('1','312','1','19',37,'1','1',3219.17,3476.55,0.00,0.00,257.38,185313.60,0.00,0.00,0.00),('1','312','1','19',38,'2','1',1522.01,1692.01,0.00,0.00,170.00,115600.00,0.00,0.00,0.00),('1','312','1','20',39,'1','1',3476.55,3707.99,0.00,0.00,231.44,166636.80,0.00,0.00,0.00),('1','312','1','20',40,'2','1',1692.01,1692.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','312','1','21',41,'1','1',3707.99,4038.83,0.00,0.00,330.84,246484.80,0.00,0.00,0.00),('1','312','1','21',42,'2','1',1692.01,2394.45,0.00,0.00,702.44,477659.20,0.00,0.00,0.00),('1','312','1','22',43,'1','1',4038.83,4627.68,0.00,0.00,588.85,423972.00,0.00,0.00,0.00),('1','312','1','22',44,'2','1',2394.45,2878.84,0.00,0.00,484.39,327413.25,0.00,0.00,0.00),('1','312','1','23',45,'1','1',4627.68,4831.00,0.00,0.00,203.32,146390.40,0.00,0.00,0.00),('1','312','1','23',46,'2','1',2878.84,3496.79,0.00,0.00,617.95,417116.25,0.00,0.00,0.00),('1','312','1','24',47,'1','1',4831.00,5037.31,0.00,0.00,206.31,148543.20,0.00,0.00,0.00),('1','312','1','24',48,'2','1',3496.79,4196.23,0.00,0.00,699.44,472122.00,0.00,0.00,0.00),('1','312','1','25',49,'1','1',5037.31,5293.88,0.00,0.00,256.57,184730.40,0.00,0.00,0.00),('1','312','1','25',50,'2','1',4196.23,4366.23,0.00,0.00,170.00,115600.00,0.00,0.00,0.00),('1','312','1','26',51,'1','1',5293.88,5489.93,0.00,0.00,196.05,141156.00,0.00,0.00,0.00),('1','312','1','26',52,'2','1',4366.23,4486.23,0.00,0.00,120.00,81600.00,0.00,0.00,0.00),('1','312','1','27',53,'1','1',5489.93,5681.44,0.00,0.00,191.51,137887.20,0.00,0.00,0.00),('1','312','1','27',54,'2','1',4486.23,4676.23,0.00,0.00,190.00,129200.00,0.00,0.00,0.00),('1','312','1','28',55,'1','1',5681.44,5863.21,0.00,0.00,181.77,130874.40,0.00,0.00,0.00),('1','312','1','28',56,'2','1',4676.23,5236.73,0.00,0.00,560.50,378337.50,0.00,0.00,0.00),('1','312','1','29',57,'1','1',5863.21,6017.23,0.00,0.00,154.02,110894.40,0.00,0.00,0.00),('1','312','1','29',58,'2','1',5236.73,5296.73,0.00,0.00,60.00,40800.00,0.00,0.00,0.00),('1','312','1','30',59,'1','1',6017.23,6296.89,0.00,0.00,279.66,201355.20,0.00,0.00,0.00),('1','312','1','30',60,'2','1',5296.73,5415.88,0.00,0.00,119.15,81022.00,0.00,0.00,0.00),('1','312','1','31',61,'1','1',6296.89,6674.67,0.00,0.00,377.78,272001.60,0.00,0.00,0.00),('1','312','1','31',62,'2','1',5415.88,5475.67,0.00,0.00,59.79,40657.20,0.00,0.00,0.00),('1','312','1','32',63,'1','1',6674.67,7006.34,0.00,0.00,331.67,238802.40,0.00,0.00,0.00),('1','312','1','32',64,'2','1',5475.67,5687.51,0.00,0.00,211.84,144051.20,0.00,0.00,0.00),('1','312','1','33',65,'1','1',7006.34,7292.82,0.00,0.00,286.48,206265.60,0.00,0.00,0.00),('1','312','1','33',66,'2','1',5687.51,5832.51,0.00,0.00,145.00,98600.00,0.00,0.00,0.00),('1','312','1','34',67,'1','1',7292.82,7484.47,0.00,0.00,191.65,137988.00,0.00,0.00,0.00),('1','312','1','34',68,'2','1',5832.51,5832.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','312','1','35',69,'1','1',7484.47,7772.20,0.00,0.00,287.73,207165.60,0.00,0.00,0.00),('1','312','1','35',70,'2','1',5832.51,5832.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','312','1','36',71,'1','1',7772.20,8258.55,0.00,0.00,486.35,350172.00,0.00,0.00,0.00),('1','312','1','36',72,'2','1',5832.51,5999.87,0.00,0.00,167.36,113804.80,0.00,0.00,0.00),('1','312','1','37',73,'1','1',8258.55,8602.36,0.00,0.00,343.81,247543.20,0.00,0.00,0.00),('1','312','1','37',74,'2','1',5999.87,6274.87,0.00,0.00,275.00,187000.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','312','1','1',593.00,760.00,0.00,9.00,5337.00,6840.00,1503.00,1),('1','312','2','1',593.00,760.00,0.00,94.35,55949.55,71706.00,15756.45,2),('1','312','3','1',593.00,760.00,0.00,182.04,107949.72,138350.40,30400.68,3),('1','312','4','1',593.00,760.00,0.00,178.00,105554.00,135280.00,29726.00,4),('1','312','5','1',593.00,760.00,0.00,198.44,117674.92,150814.40,33139.48,5),('1','312','6','1',593.00,760.00,0.00,162.86,96575.98,123773.60,27197.62,6),('1','312','7','1',593.00,760.00,0.00,152.53,90450.29,115922.80,25472.51,7),('1','312','8','1',593.00,760.00,0.00,154.64,91701.52,117526.40,25824.88,8),('1','312','9','1',593.00,760.00,0.00,161.01,95478.93,122367.60,26888.67,9),('1','312','10','1',593.00,760.00,0.00,205.61,121926.73,156263.60,34336.87,10),('1','312','11','1',593.00,760.00,0.00,95.57,56673.01,72633.20,15960.19,11),('1','312','12','1',593.00,720.00,0.00,70.70,41925.10,50904.00,8978.90,12),('1','312','13','1',593.00,720.00,0.00,156.04,92531.72,112348.80,19817.08,13),('1','312','14','1',593.00,720.00,0.00,241.12,142984.16,173606.40,30622.24,14),('1','312','15','1',593.00,720.00,0.00,139.61,82788.73,100519.20,17730.47,15),('1','312','16','1',593.00,720.00,0.00,935.68,554858.24,648056.15,93197.91,16),('1','312','17','1',593.00,720.00,0.00,359.91,213426.63,259135.20,45708.57,17),('1','312','18','1',593.00,720.00,0.00,1244.07,737733.51,855298.40,117564.89,18),('1','312','19','1',593.00,720.00,0.00,427.38,253436.34,300913.60,47477.26,19),('1','312','20','1',593.00,720.00,0.00,231.44,137243.92,166636.80,29392.88,20),('1','312','21','1',593.00,720.00,0.00,1033.28,612735.04,724144.00,111408.96,21),('1','312','22','1',593.00,720.00,0.00,1073.24,636431.32,751385.25,114953.93,22),('1','312','23','1',593.00,720.00,0.00,821.27,487013.11,563506.65,76493.54,23),('1','312','24','1',593.00,720.00,0.00,905.75,537109.75,620665.20,83555.45,24),('1','312','25','1',593.00,720.00,0.00,426.57,252956.01,300330.40,47374.39,25),('1','312','26','1',593.00,720.00,0.00,316.05,187417.65,222756.00,35338.35,26),('1','312','27','1',593.00,720.00,0.00,381.51,226235.43,267087.20,40851.77,27),('1','312','28','1',593.00,720.00,0.00,742.27,452784.70,509211.90,56427.20,28),('1','312','29','1',610.00,720.00,0.00,214.02,130552.20,151694.40,21142.20,29),('1','312','30','1',610.00,720.00,0.00,398.81,243274.10,282377.20,39103.10,30),('1','312','31','1',610.00,720.00,0.00,437.57,266917.70,312658.80,45741.10,31),('1','312','32','1',610.00,720.00,0.00,543.51,331541.10,382853.60,51312.50,32),('1','312','33','1',610.00,720.00,0.00,431.48,263202.80,304865.60,41662.80,33),('1','312','34','1',610.00,720.00,0.00,191.65,116906.50,137988.00,21081.50,34),('1','312','35','1',610.00,720.00,0.00,287.73,175515.30,207165.60,31650.30,35),('1','312','36','1',610.00,720.00,0.00,653.71,398763.10,463976.80,65213.70,36),('1','312','37','1',610.00,720.00,0.00,618.81,377474.10,434543.20,57069.10,37);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'312','LPG PRODUCT ','LPG Tanks.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','312','1',1,1,'1','LPG TANK ',6000.00,0.00,NULL,'TANK CONTAINING LPG PRODUCT','479','2023-01-23 01:47:11','2023-01-23 01:47:11','479',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','312',1,880.44,'2023-03-19 18:54:16');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=1190 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','312',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3202200.00,5400.00,0.00,0.00,'2023-02-02 11:34:21','',''),(2,'1','312',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,5400.00,0.00,'2023-02-02 11:39:31','',''),(3,'1','312','1',1,'Received from bridging 1',0.00,0.00,5400.00,0.00,0.00,'2023-02-02 11:39:31','',''),(4,'1','312','1',1,'Retail Sale Id 1',760.00,0.00,0.00,1.00,167.00,'2023-02-02 11:53:57','',''),(5,'1','312','1',1,'Retail Sale Id 2',6080.00,0.00,0.00,8.00,1336.00,'2023-02-02 15:59:09','',''),(6,'1','312','1',1,'Retail Sale Id 3',760.00,0.00,0.00,1.00,167.00,'2023-02-04 08:16:54','',''),(7,'1','312','1',1,'Retail Sale Id 4',70946.00,0.00,0.00,93.35,15589.45,'2023-02-04 09:32:37','',''),(8,'1','312','1',1,'Retail Sale Id 5',3800.00,0.00,0.00,5.00,835.00,'2023-02-04 09:44:46','',''),(9,'1','312','1',1,'Retail Sale Id 6',4560.00,0.00,0.00,6.00,1002.00,'2023-02-04 09:47:01','',''),(10,'1','312','1',1,'Retail Sale Id 7',3800.00,0.00,0.00,5.00,835.00,'2023-02-04 09:48:31','',''),(11,'1','312','1',1,'Retail Sale Id 8',3800.00,0.00,0.00,5.00,835.00,'2023-02-04 09:50:15','',''),(12,'1','312','1',1,'Retail Sale Id 9',3800.00,0.00,0.00,5.00,835.00,'2023-02-04 09:51:52','',''),(13,'1','312','1',1,'Retail Sale Id 11',2500.40,0.00,0.00,3.29,549.43,'2023-02-04 09:57:50','',''),(14,'1','312','1',1,'Retail Sale Id 12',2302.80,0.00,0.00,3.03,506.01,'2023-02-04 09:59:20','',''),(15,'1','312','1',1,'Retail Sale Id 13',1520.00,0.00,0.00,2.00,334.00,'2023-02-04 10:03:34','',''),(16,'1','312','1',1,'Retail Sale Id 14',1497.20,0.00,0.00,1.97,328.99,'2023-02-04 10:04:56','',''),(17,'1','312','1',1,'Retail Sale Id 15',9500.00,0.00,0.00,12.50,2087.50,'2023-02-04 10:14:07','',''),(18,'1','312','1',1,'Retail Sale Id 16',9500.00,0.00,0.00,12.50,2087.50,'2023-02-04 11:25:06','',''),(19,'1','312','1',1,'Retail Sale Id 17',2660.00,0.00,0.00,3.50,584.50,'2023-02-04 11:26:40','',''),(20,'1','312','1',1,'Retail Sale Id 18',3503.60,0.00,0.00,4.61,769.87,'2023-02-04 11:27:49','',''),(21,'1','312','1',1,'Retail Sale Id 19',4560.00,0.00,0.00,6.00,1002.00,'2023-02-04 12:31:11','',''),(22,'1','312','1',1,'Retail Sale Id 20',4560.00,0.00,0.00,6.00,1002.00,'2023-02-04 12:49:57','',''),(23,'1','312','1',1,'Retail Sale Id 21',760.00,0.00,0.00,1.00,167.00,'2023-02-04 13:09:52','',''),(24,'1','312','1',1,'Retail Sale Id 22',3997.60,0.00,0.00,5.26,878.42,'2023-02-04 13:19:26','',''),(25,'1','312','1',1,'Retail Sale Id 23',4560.00,0.00,0.00,6.00,1002.00,'2023-02-04 13:23:05','',''),(26,'1','312','1',1,'Retail Sale Id 24',12600.80,0.00,0.00,16.58,2768.86,'2023-02-04 14:58:09','',''),(27,'1','312','1',1,'Retail Sale Id 25',2302.80,0.00,0.00,3.03,506.01,'2023-02-04 15:21:59','',''),(28,'1','312','1',1,'Retail Sale Id 26',7425.20,0.00,0.00,9.77,1631.59,'2023-02-04 16:50:24','',''),(29,'1','312','1',1,'Retail Sale Id 27',7600.00,0.00,0.00,10.00,1670.00,'2023-02-04 16:51:52','',''),(30,'1','312','1',1,'Retail Sale Id 28',6840.00,0.00,0.00,9.00,1503.00,'2023-02-04 19:54:57','',''),(31,'1','312','1',1,'Retail Sale Id 29',30400.00,0.00,0.00,40.00,6680.00,'2023-02-04 19:56:02','',''),(32,'1','312','1',1,'Retail Sale Id 30',9500.00,0.00,0.00,12.50,2087.50,'2023-02-05 07:42:06','',''),(33,'1','312','1',1,'Retail Sale Id 31',4560.00,0.00,0.00,6.00,1002.00,'2023-02-05 07:43:23','',''),(34,'1','312','1',1,'Retail Sale Id 32',9500.00,0.00,0.00,12.50,2087.50,'2023-02-05 10:13:49','',''),(35,'1','312','1',1,'Retail Sale Id 33',7600.00,0.00,0.00,10.00,1670.00,'2023-02-05 12:34:17','',''),(36,'1','312','1',1,'Retail Sale Id 34',1550.40,0.00,0.00,2.04,340.68,'2023-02-05 12:39:56','',''),(37,'1','312','1',1,'Retail Sale Id 35',2302.80,0.00,0.00,3.03,506.01,'2023-02-05 12:45:01','',''),(38,'1','312','1',1,'Retail Sale Id 36',9500.00,0.00,0.00,12.50,2087.50,'2023-02-05 12:58:36','',''),(39,'1','312','1',1,'Retail Sale Id 37',4560.00,0.00,0.00,6.00,1002.00,'2023-02-05 13:00:05','',''),(40,'1','312','1',1,'Retail Sale Id 38',10640.00,0.00,0.00,14.00,2338.00,'2023-02-05 13:04:16','',''),(41,'1','312','1',1,'Retail Sale Id 39',3800.00,0.00,0.00,5.00,835.00,'2023-02-05 13:05:47','',''),(42,'1','312','1',1,'Retail Sale Id 40',4560.00,0.00,0.00,6.00,1002.00,'2023-02-05 13:07:19','',''),(43,'1','312','1',1,'Retail Sale Id 41',3997.60,0.00,0.00,5.26,878.42,'2023-02-05 14:48:03','',''),(44,'1','312','1',1,'Retail Sale Id 42',1998.80,0.00,0.00,2.63,439.21,'2023-02-05 14:50:12','',''),(45,'1','312','1',1,'Retail Sale Id 43',9097.20,0.00,0.00,11.97,1998.99,'2023-02-05 15:38:53','',''),(46,'1','312','1',1,'Retail Sale Id 44',8002.80,0.00,0.00,10.53,1758.51,'2023-02-05 15:50:16','',''),(47,'1','312','1',1,'Retail Sale Id 45',6110.40,0.00,0.00,8.04,1342.68,'2023-02-05 19:25:27','',''),(48,'1','312','1',1,'Retail Sale Id 46',7600.00,0.00,0.00,10.00,1670.00,'2023-02-05 19:26:25','',''),(49,'1','312','1',1,'Retail Sale Id 47',9500.00,0.00,0.00,12.50,2087.50,'2023-02-05 19:27:24','',''),(50,'1','312','1',1,'Retail Sale Id 48',5700.00,0.00,0.00,7.50,1252.50,'2023-02-05 19:28:07','',''),(51,'1','312','1',1,'Retail Sale Id 49',15200.00,0.00,0.00,20.00,3340.00,'2023-02-05 19:28:47','',''),(52,'1','312','1',1,'Retail Sale Id 50',9500.00,0.00,0.00,12.50,2087.50,'2023-02-07 08:13:31','',''),(53,'1','312','1',1,'Retail Sale Id 51',4560.00,0.00,0.00,6.00,1002.00,'2023-02-07 08:15:09','',''),(54,'1','312','1',1,'Retail Sale Id 52',3800.00,0.00,0.00,5.00,835.00,'2023-02-07 08:16:16','',''),(55,'1','312','1',1,'Retail Sale Id 53',1998.80,0.00,0.00,2.63,439.21,'2023-02-07 08:35:31','',''),(56,'1','312','1',1,'Retail Sale Id 54',4560.00,0.00,0.00,6.00,1002.00,'2023-02-07 12:11:48','',''),(57,'1','312','1',1,'Retail Sale Id 55',3047.60,0.00,0.00,4.01,669.67,'2023-02-07 12:17:09','',''),(58,'1','312','1',1,'Retail Sale Id 56',8360.00,0.00,0.00,11.00,1837.00,'2023-02-07 13:44:57','',''),(59,'1','312','1',1,'Retail Sale Id 57',3997.60,0.00,0.00,5.26,878.42,'2023-02-07 14:27:44','',''),(60,'1','312','1',1,'Retail Sale Id 59',4590.40,0.00,0.00,6.04,1008.68,'2023-02-07 19:18:10','',''),(61,'1','312','1',1,'Retail Sale Id 60',15200.00,0.00,0.00,20.00,3340.00,'2023-02-07 19:19:29','',''),(62,'1','312','1',1,'Retail Sale Id 61',9500.00,0.00,0.00,12.50,2087.50,'2023-02-07 19:23:33','',''),(63,'1','312','1',1,'Retail Sale Id 62',4560.00,0.00,0.00,6.00,1002.00,'2023-02-07 19:27:21','',''),(64,'1','312','1',1,'Retail Sale Id 63',7600.00,0.00,0.00,10.00,1670.00,'2023-02-07 19:28:36','',''),(65,'1','312','1',1,'Retail Sale Id 64',9120.00,0.00,0.00,12.00,2004.00,'2023-02-07 19:30:17','',''),(66,'1','312','1',1,'Retail Sale Id 65',9500.00,0.00,0.00,12.50,2087.50,'2023-02-07 19:32:24','',''),(67,'1','312','1',1,'Retail Sale Id 66',7600.00,0.00,0.00,10.00,1670.00,'2023-02-07 19:33:20','',''),(68,'1','312','1',1,'Retail Sale Id 67',8360.00,0.00,0.00,11.00,1837.00,'2023-02-07 19:34:21','',''),(69,'1','312','1',1,'Retail Sale Id 68',9500.00,0.00,0.00,12.50,2087.50,'2023-02-07 19:35:18','',''),(70,'1','312','1',1,'Retail Sale Id 69',7600.00,0.00,0.00,10.00,1670.00,'2023-02-07 19:36:39','',''),(71,'1','312','1',1,'Retail Sale Id 70',17556.00,0.00,0.00,23.10,3857.70,'2023-02-07 19:39:37','',''),(72,'1','312','1',1,'Retail Sale Id 71',304.00,0.00,0.00,0.40,66.80,'2023-02-07 19:43:08','',''),(73,'1','312','1',1,'Retail Sale Id 72',9500.00,0.00,0.00,12.50,2087.50,'2023-02-08 11:05:18','',''),(74,'1','312','1',1,'Retail Sale Id 73',5320.00,0.00,0.00,7.00,1169.00,'2023-02-08 14:31:29','',''),(75,'1','312','1',1,'Retail Sale Id 74',7600.00,0.00,0.00,10.00,1670.00,'2023-02-08 14:33:18','',''),(76,'1','312','1',1,'Retail Sale Id 75',8740.00,0.00,0.00,11.50,1920.50,'2023-02-08 14:40:48','',''),(77,'1','312','1',1,'Retail Sale Id 76',7600.00,0.00,0.00,10.00,1670.00,'2023-02-08 14:42:02','',''),(78,'1','312','1',1,'Retail Sale Id 77',3800.00,0.00,0.00,5.00,835.00,'2023-02-08 14:43:08','',''),(79,'1','312','1',1,'Retail Sale Id 78',4560.00,0.00,0.00,6.00,1002.00,'2023-02-08 14:44:18','',''),(80,'1','312','1',1,'Retail Sale Id 79',6840.00,0.00,0.00,9.00,1503.00,'2023-02-08 14:45:38','',''),(81,'1','312','1',1,'Retail Sale Id 80',9500.00,0.00,0.00,12.50,2087.50,'2023-02-08 17:02:09','',''),(82,'1','312','1',1,'Retail Sale Id 81',4560.00,0.00,0.00,6.00,1002.00,'2023-02-08 17:37:05','',''),(83,'1','312','1',1,'Retail Sale Id 82',7600.00,0.00,0.00,10.00,1670.00,'2023-02-08 17:51:33','',''),(84,'1','312','1',1,'Retail Sale Id 83',2553.60,0.00,0.00,3.36,561.12,'2023-02-08 19:18:47','',''),(85,'1','312','1',1,'Retail Sale Id 84',9500.00,0.00,0.00,12.50,2087.50,'2023-02-08 19:21:33','',''),(86,'1','312','1',1,'Retail Sale Id 85',7600.00,0.00,0.00,10.00,1670.00,'2023-02-08 19:23:49','',''),(87,'1','312','1',1,'Retail Sale Id 86',9500.00,0.00,0.00,12.50,2087.50,'2023-02-08 19:26:12','',''),(88,'1','312','1',1,'Retail Sale Id 87',7600.00,0.00,0.00,10.00,1670.00,'2023-02-08 19:28:35','',''),(89,'1','312','1',1,'Retail Sale Id 88',11400.00,0.00,0.00,15.00,2505.00,'2023-02-08 19:32:56','',''),(90,'1','312','1',1,'Retail Sale Id 89',9500.00,0.00,0.00,12.50,2087.50,'2023-02-09 10:11:05','',''),(91,'1','312','1',1,'Retail Sale Id 90',3800.00,0.00,0.00,5.00,835.00,'2023-02-09 10:12:09','',''),(92,'1','312','1',1,'Retail Sale Id 91',7600.00,0.00,0.00,10.00,1670.00,'2023-02-09 10:13:16','',''),(93,'1','312','1',1,'Retail Sale Id 92',9500.00,0.00,0.00,12.50,2087.50,'2023-02-09 19:27:37','',''),(94,'1','312','1',1,'Retail Sale Id 93',8740.00,0.00,0.00,11.50,1920.50,'2023-02-09 19:28:30','',''),(95,'1','312','1',1,'Retail Sale Id 94',8360.00,0.00,0.00,11.00,1837.00,'2023-02-09 19:29:24','',''),(96,'1','312','1',1,'Retail Sale Id 95',7600.00,0.00,0.00,10.00,1670.00,'2023-02-09 19:30:12','',''),(97,'1','312','1',1,'Retail Sale Id 96',9500.00,0.00,0.00,12.50,2087.50,'2023-02-09 19:31:03','',''),(98,'1','312','1',1,'Retail Sale Id 97',8740.00,0.00,0.00,11.50,1920.50,'2023-02-09 19:31:56','',''),(99,'1','312','1',1,'Retail Sale Id 98',10640.00,0.00,0.00,14.00,2338.00,'2023-02-09 19:32:51','',''),(100,'1','312','1',1,'Retail Sale Id 99',7828.00,0.00,0.00,10.30,1720.10,'2023-02-09 19:34:16','',''),(101,'1','312','1',1,'Retail Sale Id 100',9500.00,0.00,0.00,12.50,2087.50,'2023-02-09 19:35:15','',''),(102,'1','312','1',1,'Retail Sale Id 101',1497.20,0.00,0.00,1.97,328.99,'2023-02-09 19:36:51','',''),(103,'1','312','1',1,'Retail Sale Id 102',9500.00,0.00,0.00,12.50,2087.50,'2023-02-09 19:37:49','',''),(104,'1','312','1',1,'Retail Sale Id 103',6612.00,0.00,0.00,8.70,1452.90,'2023-02-09 19:39:51','',''),(105,'1','312','1',1,'Return of Retail Sale Id 102',0.00,9500.00,12.50,0.00,-2087.50,'2023-02-09 19:42:49','',''),(106,'1','312','1',1,'Retail Sale Id 104',6505.60,0.00,0.00,8.56,1429.52,'2023-02-09 19:44:10','',''),(107,'1','312','1',1,'Retail Sale Id 105',9500.00,0.00,0.00,12.50,2087.50,'2023-02-10 12:37:17','',''),(108,'1','312','1',1,'Retail Sale Id 106',3800.00,0.00,0.00,5.00,835.00,'2023-02-10 12:40:00','',''),(109,'1','312','1',1,'Retail Sale Id 107',3040.00,0.00,0.00,4.00,668.00,'2023-02-10 17:59:12','',''),(110,'1','312','1',1,'Retail Sale Id 108',9500.00,0.00,0.00,12.50,2087.50,'2023-02-10 19:34:46','',''),(111,'1','312','1',1,'Retail Sale Id 109',7600.00,0.00,0.00,10.00,1670.00,'2023-02-10 19:35:34','',''),(112,'1','312','1',1,'Retail Sale Id 110',10640.00,0.00,0.00,14.00,2338.00,'2023-02-10 19:36:14','',''),(113,'1','312','1',1,'Retail Sale Id 111',8360.00,0.00,0.00,11.00,1837.00,'2023-02-10 19:37:05','',''),(114,'1','312','1',1,'Retail Sale Id 112',9500.00,0.00,0.00,12.50,2087.50,'2023-02-10 19:37:50','',''),(115,'1','312','1',1,'Retail Sale Id 113',7600.00,0.00,0.00,10.00,1670.00,'2023-02-10 19:38:31','',''),(116,'1','312','1',1,'Retail Sale Id 114',10640.00,0.00,0.00,14.00,2338.00,'2023-02-10 19:39:16','',''),(117,'1','312','1',1,'Retail Sale Id 115',9500.00,0.00,0.00,12.50,2087.50,'2023-02-10 19:39:59','',''),(118,'1','312','1',1,'Retail Sale Id 116',9500.00,0.00,0.00,12.50,2087.50,'2023-02-10 19:40:46','',''),(119,'1','312','1',1,'Retail Sale Id 117',7600.00,0.00,0.00,10.00,1670.00,'2023-02-10 19:41:47','',''),(120,'1','312','1',1,'Retail Sale Id 118',10746.40,0.00,0.00,14.14,2361.38,'2023-02-10 19:44:54','',''),(121,'1','312','1',1,'Retail Sale Id 120',9500.00,0.00,0.00,12.50,2087.50,'2023-02-11 07:51:06','',''),(122,'1','312','1',1,'Retail Sale Id 122',760.00,0.00,0.00,1.00,167.00,'2023-02-11 07:53:56','',''),(123,'1','312','1',1,'Retail Sale Id 123',2302.80,0.00,0.00,3.03,506.01,'2023-02-11 07:55:47','',''),(124,'1','312','1',1,'Retail Sale Id 124',5996.40,0.00,0.00,7.89,1317.63,'2023-02-11 08:46:22','',''),(125,'1','312','1',1,'Retail Sale Id 125',3040.00,0.00,0.00,4.00,668.00,'2023-02-11 09:11:36','',''),(126,'1','312','1',1,'Retail Sale Id 126',2280.00,0.00,0.00,3.00,501.00,'2023-02-11 10:41:09','',''),(127,'1','312','1',1,'Retail Sale Id 127',5320.00,0.00,0.00,7.00,1169.00,'2023-02-11 10:57:31','',''),(128,'1','312','1',1,'Retail Sale Id 128',5320.00,0.00,0.00,7.00,1169.00,'2023-02-11 12:17:58','',''),(129,'1','312','1',1,'Retail Sale Id 129',4560.00,0.00,0.00,6.00,1002.00,'2023-02-11 13:54:08','',''),(130,'1','312','1',1,'Retail Sale Id 130',9500.00,0.00,0.00,12.50,2087.50,'2023-02-11 13:55:36','',''),(131,'1','312','1',1,'Retail Sale Id 131',1527.60,0.00,0.00,2.01,335.67,'2023-02-11 14:33:37','',''),(132,'1','312','1',1,'Retail Sale Id 132',3860.80,0.00,0.00,5.08,848.36,'2023-02-11 20:01:19','',''),(133,'1','312','1',1,'Retail Sale Id 133',11400.00,0.00,0.00,15.00,2505.00,'2023-02-11 20:02:53','',''),(134,'1','312','1',1,'Retail Sale Id 134',9500.00,0.00,0.00,12.50,2087.50,'2023-02-11 20:03:44','',''),(135,'1','312','1',1,'Retail Sale Id 135',9500.00,0.00,0.00,12.50,2087.50,'2023-02-11 20:04:26','',''),(136,'1','312','1',1,'Retail Sale Id 136',7600.00,0.00,0.00,10.00,1670.00,'2023-02-11 20:05:13','',''),(137,'1','312','1',1,'Retail Sale Id 137',8360.00,0.00,0.00,11.00,1837.00,'2023-02-11 20:06:04','',''),(138,'1','312','1',1,'Retail Sale Id 138',6840.00,0.00,0.00,9.00,1503.00,'2023-02-11 20:06:51','',''),(139,'1','312','1',1,'Retail Sale Id 139',3800.00,0.00,0.00,5.00,835.00,'2023-02-11 20:07:31','',''),(140,'1','312','1',1,'Retail Sale Id 140',3800.00,0.00,0.00,5.00,835.00,'2023-02-11 20:08:16','',''),(141,'1','312','1',1,'Retail Sale Id 141',7600.00,0.00,0.00,10.00,1670.00,'2023-02-11 20:10:43','',''),(142,'1','312','1',1,'Retail Sale Id 142',9500.00,0.00,0.00,12.50,2087.50,'2023-02-12 07:56:25','',''),(143,'1','312','1',1,'Retail Sale Id 143',5000.80,0.00,0.00,6.58,1098.86,'2023-02-12 08:04:17','',''),(144,'1','312','1',1,'Retail Sale Id 144',3002.00,0.00,0.00,3.95,659.65,'2023-02-12 08:05:27','',''),(145,'1','312','1',1,'Retail Sale Id 145',1520.00,0.00,0.00,2.00,334.00,'2023-02-12 08:06:49','',''),(146,'1','312','1',1,'Retail Sale Id 146',10001.60,0.00,0.00,13.16,2197.72,'2023-02-12 09:25:54','',''),(147,'1','312','1',1,'Retail Sale Id 147',9500.00,0.00,0.00,12.50,2087.50,'2023-02-12 09:43:46','',''),(148,'1','312','1',1,'Retail Sale Id 148',3800.00,0.00,0.00,5.00,835.00,'2023-02-12 10:28:58','',''),(149,'1','312','1',1,'Retail Sale Id 149',2280.00,0.00,0.00,3.00,501.00,'2023-02-12 10:30:37','',''),(150,'1','312','1',1,'Retail Sale Id 150',7478.40,0.00,0.00,9.84,1643.28,'2023-02-12 11:11:26','',''),(151,'1','312','1',1,'Retail Sale Id 151',4560.00,0.00,0.00,6.00,1002.00,'2023-02-12 11:43:30','',''),(152,'1','312','1',1,'Retail Sale Id 152',5000.80,0.00,0.00,6.58,1098.86,'2023-02-12 12:05:59','',''),(153,'1','312','1',1,'Retail Sale Id 153',9500.00,0.00,0.00,12.50,2087.50,'2023-02-12 13:02:13','',''),(154,'1','312','1',1,'Retail Sale Id 154',10001.60,0.00,0.00,13.16,2197.72,'2023-02-12 13:03:39','',''),(155,'1','312','1',1,'Retail Sale Id 155',1520.00,0.00,0.00,2.00,334.00,'2023-02-12 13:04:46','',''),(156,'1','312','1',1,'Retail Sale Id 156',9500.00,0.00,0.00,12.50,2087.50,'2023-02-12 13:05:45','',''),(157,'1','312','1',1,'Retail Sale Id 157',1003.20,0.00,0.00,1.32,220.44,'2023-02-12 15:15:26','',''),(158,'1','312','1',1,'Retail Sale Id 158',9500.00,0.00,0.00,12.50,2087.50,'2023-02-12 15:16:46','',''),(159,'1','312','1',1,'Retail Sale Id 159',4940.00,0.00,0.00,6.50,1085.50,'2023-02-12 15:18:02','',''),(160,'1','312','1',1,'Retail Sale Id 160',3040.00,0.00,0.00,4.00,668.00,'2023-02-12 17:13:39','',''),(161,'1','312','1',1,'Retail Sale Id 161',1520.00,0.00,0.00,2.00,334.00,'2023-02-12 17:14:54','',''),(162,'1','312','1',1,'Retail Sale Id 162',3997.60,0.00,0.00,5.26,878.42,'2023-02-12 17:16:00','',''),(163,'1','312','1',1,'Retail Sale Id 163',2280.00,0.00,0.00,3.00,501.00,'2023-02-12 17:17:31','',''),(164,'1','312','1',1,'Retail Sale Id 164',5000.80,0.00,0.00,6.58,1098.86,'2023-02-12 17:41:43','',''),(165,'1','312','1',1,'Retail Sale Id 165',1520.00,0.00,0.00,2.00,334.00,'2023-02-12 17:45:37','',''),(166,'1','312','1',1,'Retail Sale Id 166',5000.80,0.00,0.00,6.58,1098.86,'2023-02-12 18:07:24','',''),(167,'1','312','1',1,'Retail Sale Id 167',3040.00,0.00,0.00,4.00,668.00,'2023-02-12 18:08:35','',''),(168,'1','312','1',1,'Retail Sale Id 168',23256.00,0.00,0.00,30.60,5110.20,'2023-02-12 19:35:31','',''),(169,'1','312','1',1,'Retail Sale Id 169',2280.00,0.00,0.00,3.00,501.00,'2023-02-14 07:50:16','',''),(170,'1','312','1',1,'Retail Sale Id 170',5282.00,0.00,0.00,6.95,1160.65,'2023-02-14 07:51:45','',''),(171,'1','312','1',1,'Retail Sale Id 171',9500.00,0.00,0.00,12.50,2087.50,'2023-02-14 07:53:38','',''),(172,'1','312','1',1,'Retail Sale Id 172',1998.80,0.00,0.00,2.63,439.21,'2023-02-14 07:54:39','',''),(173,'1','312','1',1,'Retail Sale Id 173',4560.00,0.00,0.00,6.00,1002.00,'2023-02-14 09:02:11','',''),(174,'1','312','1',1,'Retail Sale Id 174',2500.40,0.00,0.00,3.29,549.43,'2023-02-14 09:16:37','',''),(175,'1','312','1',1,'Retail Sale Id 175',3800.00,0.00,0.00,5.00,835.00,'2023-02-14 09:33:05','',''),(176,'1','312','1',1,'Retail Sale Id 176',4598.00,0.00,0.00,6.05,1010.35,'2023-02-14 09:57:38','',''),(177,'1','312','1',1,'Retail Sale Id 177',2280.00,0.00,0.00,3.00,501.00,'2023-02-14 10:35:39','',''),(178,'1','312','1',1,'Retail Sale Id 178',9500.00,0.00,0.00,12.50,2087.50,'2023-02-14 10:41:13','',''),(179,'1','312','1',1,'Retail Sale Id 179',4560.00,0.00,0.00,6.00,1002.00,'2023-02-14 11:34:53','',''),(180,'1','312','1',1,'Retail Sale Id 180',7600.00,0.00,0.00,10.00,1670.00,'2023-02-14 12:09:45','',''),(181,'1','312','1',1,'Retail Sale Id 181',3997.60,0.00,0.00,5.26,878.42,'2023-02-14 12:17:53','',''),(182,'1','312','1',1,'Retail Sale Id 182',1520.00,0.00,0.00,2.00,334.00,'2023-02-14 14:04:02','',''),(183,'1','312','1',1,'Retail Sale Id 183',2660.00,0.00,0.00,3.50,584.50,'2023-02-14 14:05:27','',''),(184,'1','312','1',1,'Retail Sale Id 184',1998.80,0.00,0.00,2.63,439.21,'2023-02-14 14:09:16','',''),(185,'1','312','1',1,'Retail Sale Id 185',3997.60,0.00,0.00,5.26,878.42,'2023-02-14 14:13:38','',''),(186,'1','312','1',1,'Retail Sale Id 186',5040.00,0.00,0.00,7.00,889.00,'2023-02-14 15:06:12','',''),(187,'1','312','1',1,'Retail Sale Id 187',6098.40,0.00,0.00,8.47,1075.69,'2023-02-14 15:38:18','',''),(188,'1','312','1',1,'Retail Sale Id 188',1447.20,0.00,0.00,2.01,255.27,'2023-02-14 16:01:33','',''),(189,'1','312','1',1,'Retail Sale Id 189',4320.00,0.00,0.00,6.00,762.00,'2023-02-14 19:00:07','',''),(190,'1','312','1',1,'Retail Sale Id 190',2160.00,0.00,0.00,3.00,381.00,'2023-02-14 19:01:09','',''),(191,'1','312','1',1,'Retail Sale Id 191',799.20,0.00,0.00,1.11,140.97,'2023-02-14 19:02:11','',''),(192,'1','312','1',1,'Retail Sale Id 192',1440.00,0.00,0.00,2.00,254.00,'2023-02-14 19:03:19','',''),(193,'1','312','1',1,'Retail Sale Id 193',2001.60,0.00,0.00,2.78,353.06,'2023-02-14 19:04:17','',''),(194,'1','312','1',1,'Retail Sale Id 194',9597.60,0.00,0.00,13.33,1692.91,'2023-02-14 19:13:49','',''),(195,'1','312','1',1,'Retail Sale Id 195',9000.00,0.00,0.00,12.50,1587.50,'2023-02-14 19:22:58','',''),(196,'1','312','1',1,'Retail Sale Id 196',9000.00,0.00,0.00,12.50,1587.50,'2023-02-14 20:14:57','',''),(197,'1','312','1',1,'Retail Sale Id 197',3600.00,0.00,0.00,5.00,635.00,'2023-02-15 07:26:23','',''),(198,'1','312','1',1,'Retail Sale Id 198',9000.00,0.00,0.00,12.50,1587.50,'2023-02-15 07:54:17','',''),(199,'1','312','1',1,'Retail Sale Id 199',4320.00,0.00,0.00,6.00,762.00,'2023-02-15 08:02:39','',''),(200,'1','312','1',1,'Retail Sale Id 200',2880.00,0.00,0.00,4.00,508.00,'2023-02-15 10:13:26','',''),(201,'1','312','1',1,'Retail Sale Id 201',4320.00,0.00,0.00,6.00,762.00,'2023-02-15 10:19:32','',''),(202,'1','312','1',1,'Retail Sale Id 202',2282.40,0.00,0.00,3.17,402.59,'2023-02-15 10:22:31','',''),(203,'1','312','1',1,'Retail Sale Id 203',4003.20,0.00,0.00,5.56,706.12,'2023-02-15 11:03:27','',''),(204,'1','312','1',1,'Retail Sale Id 204',9000.00,0.00,0.00,12.50,1587.50,'2023-02-15 11:42:43','',''),(205,'1','312','1',1,'Retail Sale Id 205',3600.00,0.00,0.00,5.00,635.00,'2023-02-15 12:03:40','',''),(206,'1','312','1',1,'Retail Sale Id 206',4320.00,0.00,0.00,6.00,762.00,'2023-02-15 12:12:12','',''),(207,'1','312','1',1,'Retail Sale Id 207',2880.00,0.00,0.00,4.00,508.00,'2023-02-15 12:49:56','',''),(208,'1','312','1',1,'Retail Sale Id 208',4003.20,0.00,0.00,5.56,706.12,'2023-02-15 13:23:32','',''),(209,'1','312','1',1,'Retail Sale Id 209',4320.00,0.00,0.00,6.00,762.00,'2023-02-15 13:52:21','',''),(210,'1','312','1',1,'Retail Sale Id 210',2880.00,0.00,0.00,4.00,508.00,'2023-02-15 15:30:55','',''),(211,'1','312','1',1,'Retail Sale Id 211',4348.80,0.00,0.00,6.04,767.08,'2023-02-15 17:04:23','',''),(212,'1','312','1',1,'Retail Sale Id 212',9000.00,0.00,0.00,12.50,1587.50,'2023-02-15 17:10:48','',''),(213,'1','312','1',1,'Retail Sale Id 213',3002.40,0.00,0.00,4.17,529.59,'2023-02-15 17:40:29','',''),(214,'1','312','1',1,'Retail Sale Id 214',4320.00,0.00,0.00,6.00,762.00,'2023-02-15 17:49:17','',''),(215,'1','312','1',1,'Retail Sale Id 215',2160.00,0.00,0.00,3.00,381.00,'2023-02-15 18:14:08','',''),(216,'1','312','1',1,'Retail Sale Id 216',7200.00,0.00,0.00,10.00,1270.00,'2023-02-15 18:51:00','',''),(217,'1','312','1',1,'Retail Sale Id 217',1396.80,0.00,0.00,1.94,246.38,'2023-02-15 18:52:00','',''),(218,'1','312','1',1,'Retail Sale Id 218',3002.40,0.00,0.00,4.17,529.59,'2023-02-15 18:53:01','',''),(219,'1','312','1',1,'Retail Sale Id 219',3600.00,0.00,0.00,5.00,635.00,'2023-02-15 18:54:03','',''),(220,'1','312','1',1,'Retail Sale Id 220',12909.60,0.00,0.00,17.93,2277.11,'2023-02-15 19:42:36','',''),(221,'1','312','1',1,'Retail Sale Id 222',9000.00,0.00,0.00,12.50,1587.50,'2023-02-16 07:30:34','',''),(222,'1','312','1',1,'Retail Sale Id 223',1440.00,0.00,0.00,2.00,254.00,'2023-02-16 08:12:08','',''),(223,'1','312','1',1,'Retail Sale Id 224',5040.00,0.00,0.00,7.00,889.00,'2023-02-16 08:28:35','',''),(224,'1','312','1',1,'Retail Sale Id 225',4320.00,0.00,0.00,6.00,762.00,'2023-02-16 08:38:12','',''),(225,'1','312','1',1,'Retail Sale Id 226',4320.00,0.00,0.00,6.00,762.00,'2023-02-16 08:41:54','',''),(226,'1','312','1',1,'Retail Sale Id 227',5040.00,0.00,0.00,7.00,889.00,'2023-02-16 08:49:18','',''),(227,'1','312','1',1,'Retail Sale Id 228',9000.00,0.00,0.00,12.50,1587.50,'2023-02-16 09:28:34','',''),(228,'1','312','1',1,'Retail Sale Id 229',8640.00,0.00,0.00,12.00,1524.00,'2023-02-16 09:33:12','',''),(229,'1','312','1',1,'Retail Sale Id 230',2001.60,0.00,0.00,2.78,353.06,'2023-02-16 10:03:34','',''),(230,'1','312','1',1,'Retail Sale Id 231',7200.00,0.00,0.00,10.00,1270.00,'2023-02-16 10:07:12','',''),(231,'1','312','1',1,'Retail Sale Id 232',2160.00,0.00,0.00,3.00,381.00,'2023-02-16 10:16:57','',''),(232,'1','312','1',1,'Retail Sale Id 233',18000.00,0.00,0.00,25.00,3175.00,'2023-02-16 10:33:46','',''),(233,'1','312','1',1,'Retail Sale Id 234',1497.60,0.00,0.00,2.08,264.16,'2023-02-16 11:17:32','',''),(234,'1','312','1',1,'Retail Sale Id 235',5760.00,0.00,0.00,8.00,1016.00,'2023-02-16 12:33:19','',''),(235,'1','312','1',1,'Retail Sale Id 237',5040.00,0.00,0.00,7.00,889.00,'2023-02-16 13:27:27','',''),(236,'1','312','1',1,'Retail Sale Id 238',36000.00,0.00,0.00,50.00,6350.00,'2023-02-16 14:16:59','',''),(237,'1','312','1',1,'Retail Sale Id 239',1447.20,0.00,0.00,2.01,255.27,'2023-02-16 15:34:57','',''),(238,'1','312','1',1,'Retail Sale Id 240',9000.00,0.00,0.00,12.50,1587.50,'2023-02-16 15:37:00','',''),(239,'1','312','1',1,'Retail Sale Id 241',8640.00,0.00,0.00,12.00,1524.00,'2023-02-16 16:51:16','',''),(240,'1','312','1',1,'Retail Sale Id 242',3600.00,0.00,0.00,5.00,635.00,'2023-02-16 17:10:07','',''),(241,'1','312','1',1,'Retail Sale Id 243',4320.00,0.00,0.00,6.00,762.00,'2023-02-16 17:23:04','',''),(242,'1','312','1',1,'Retail Sale Id 244',7200.00,0.00,0.00,10.00,1270.00,'2023-02-16 17:50:23','',''),(243,'1','312','1',1,'Retail Sale Id 245',2160.00,0.00,0.00,3.00,381.00,'2023-02-16 18:00:24','',''),(244,'1','312','1',1,'Return of Retail Sale Id 245',0.00,2160.00,3.00,0.00,-381.00,'2023-02-16 18:10:51','',''),(245,'1','312','1',1,'Retail Sale Id 246',1778.40,0.00,0.00,2.47,313.69,'2023-02-16 18:12:44','',''),(246,'1','312','1',1,'Retail Sale Id 247',9000.00,0.00,0.00,12.50,1587.50,'2023-02-16 18:23:11','',''),(247,'1','312','1',1,'Retail Sale Id 248',3600.00,0.00,0.00,5.00,635.00,'2023-02-16 18:48:48','',''),(248,'1','312','1',1,'Retail Sale Id 249',2001.60,0.00,0.00,2.78,353.06,'2023-02-16 18:50:21','',''),(249,'1','312','1',1,'Return of Retail Sale Id 248',0.00,3600.00,5.00,0.00,-635.00,'2023-02-16 18:54:09','',''),(250,'1','312','1',1,'Retail Sale Id 250',2160.00,0.00,0.00,3.00,381.00,'2023-02-16 18:56:11','',''),(251,'1','312','1',1,'Retail Sale Id 251',11160.00,0.00,0.00,15.50,1968.50,'2023-02-17 07:12:29','',''),(252,'1','312','1',1,'Retail Sale Id 252',7200.00,0.00,0.00,10.00,1270.00,'2023-02-17 08:33:12','',''),(253,'1','312','1',1,'Retail Sale Id 256',4996.80,0.00,0.00,6.94,881.38,'2023-02-17 09:14:17','',''),(254,'1','312','1',1,'Retail Sale Id 259',1447.20,0.00,0.00,2.01,255.27,'2023-02-17 10:58:20','',''),(255,'1','312','1',1,'Retail Sale Id 260',2160.00,0.00,0.00,3.00,381.00,'2023-02-17 11:03:12','',''),(256,'1','312','1',1,'Retail Sale Id 261',2160.00,0.00,0.00,3.00,381.00,'2023-02-17 11:39:16','',''),(257,'1','312','1',1,'Retail Sale Id 262',7200.00,0.00,0.00,10.00,1270.00,'2023-02-17 11:40:27','',''),(258,'1','312','1',1,'Retail Sale Id 263',9000.00,0.00,0.00,12.50,1587.50,'2023-02-17 12:22:03','',''),(259,'1','312','1',1,'Retail Sale Id 264',3600.00,0.00,0.00,5.00,635.00,'2023-02-17 15:02:25','',''),(260,'1','312','1',1,'Retail Sale Id 265',3600.00,0.00,0.00,5.00,635.00,'2023-02-17 15:04:39','',''),(261,'1','312','1',1,'Retail Sale Id 266',4298.40,0.00,0.00,5.97,758.19,'2023-02-17 15:05:48','',''),(262,'1','312','1',1,'Retail Sale Id 267',1000.80,0.00,0.00,1.39,176.53,'2023-02-17 15:10:17','',''),(263,'1','312','1',1,'Retail Sale Id 268',4320.00,0.00,0.00,6.00,762.00,'2023-02-17 15:20:43','',''),(264,'1','312','1',1,'Retail Sale Id 269',4802.40,0.00,0.00,6.67,847.09,'2023-02-17 15:32:17','',''),(265,'1','312','1',1,'Retail Sale Id 270',3002.40,0.00,0.00,4.17,529.59,'2023-02-17 16:05:35','',''),(266,'1','312','1',1,'Retail Sale Id 271',4996.80,0.00,0.00,6.94,881.38,'2023-02-17 17:46:50','',''),(267,'1','312','1',1,'Retail Sale Id 272',3600.00,0.00,0.00,5.00,635.00,'2023-02-17 17:48:32','',''),(268,'1','312','1',1,'Retail Sale Id 273',1396.80,0.00,0.00,1.94,246.38,'2023-02-17 17:49:24','',''),(269,'1','312','1',1,'Retail Sale Id 274',2001.60,0.00,0.00,2.78,353.06,'2023-02-17 17:53:32','',''),(270,'1','312','1',1,'Retail Sale Id 275',720.00,0.00,0.00,1.00,127.00,'2023-02-17 17:57:10','',''),(271,'1','312','1',1,'Retail Sale Id 276',9000.00,0.00,0.00,12.50,1587.50,'2023-02-17 18:11:11','',''),(272,'1','312','1',1,'Retail Sale Id 277',9360.00,0.00,0.00,13.00,1651.00,'2023-02-17 18:25:44','',''),(273,'1','312','1',1,'Return of Retail Sale Id 276',0.00,9000.00,12.50,0.00,-1587.50,'2023-02-17 19:14:52','',''),(274,'1','312','1',1,'Retail Sale Id 278',8496.00,0.00,0.00,11.80,1498.60,'2023-02-17 19:16:01','',''),(275,'1','312','1',1,'Retail Sale Id 279',10800.00,0.00,0.00,15.00,1905.00,'2023-02-18 07:46:10','',''),(276,'1','312','1',1,'Retail Sale Id 280',14040.00,0.00,0.00,19.50,2476.50,'2023-02-18 07:48:42','',''),(277,'1','312','1',1,'Retail Sale Id 281',3002.40,0.00,0.00,4.17,529.59,'2023-02-18 09:03:34','',''),(278,'1','312','1',1,'Retail Sale Id 282',9000.00,0.00,0.00,12.50,1587.50,'2023-02-18 09:05:20','',''),(279,'1','312','1',1,'Retail Sale Id 283',9000.00,0.00,0.00,12.50,1587.50,'2023-02-18 09:06:48','',''),(280,'1','312','1',1,'Retail Sale Id 284',720.00,0.00,0.00,1.00,127.00,'2023-02-18 09:14:50','',''),(281,'1','312','1',1,'Retail Sale Id 285',7200.00,0.00,0.00,10.00,1270.00,'2023-02-18 09:27:47','',''),(282,'1','312','1',1,'Retail Sale Id 286',16560.00,0.00,0.00,23.00,2921.00,'2023-02-18 09:38:35','',''),(283,'1','312','1',1,'Retail Sale Id 287',4320.00,0.00,0.00,6.00,762.00,'2023-02-18 09:49:07','',''),(284,'1','312','1',1,'Retail Sale Id 288',1447.20,0.00,0.00,2.01,255.27,'2023-02-18 09:52:49','',''),(285,'1','312','1',1,'Retail Sale Id 289',2160.00,0.00,0.00,3.00,381.00,'2023-02-18 10:24:12','',''),(286,'1','312','1',1,'Retail Sale Id 290',3600.00,0.00,0.00,5.00,635.00,'2023-02-18 11:18:25','',''),(287,'1','312','1',1,'Retail Sale Id 291',3600.00,0.00,0.00,5.00,635.00,'2023-02-18 12:03:24','',''),(288,'1','312','1',1,'Retail Sale Id 292',5040.00,0.00,0.00,7.00,889.00,'2023-02-18 12:10:27','',''),(289,'1','312','1',1,'Retail Sale Id 293',2160.00,0.00,0.00,3.00,381.00,'2023-02-18 12:14:15','',''),(290,'1','312','1',1,'Retail Sale Id 294',3600.00,0.00,0.00,5.00,635.00,'2023-02-18 12:21:34','',''),(291,'1','312','1',1,'Retail Sale Id 295',5760.00,0.00,0.00,8.00,1016.00,'2023-02-18 12:46:34','',''),(292,'1','312','1',1,'Retail Sale Id 296',3600.00,0.00,0.00,5.00,635.00,'2023-02-18 12:56:20','',''),(293,'1','312','1',1,'Retail Sale Id 297',4320.00,0.00,0.00,6.00,762.00,'2023-02-18 13:35:59','',''),(294,'1','312','1',1,'Retail Sale Id 298',3600.00,0.00,0.00,5.00,635.00,'2023-02-18 13:39:29','',''),(295,'1','312','1',1,'Retail Sale Id 299',7920.00,0.00,0.00,11.00,1397.00,'2023-02-18 14:12:50','',''),(296,'1','312','1',1,'Retail Sale Id 300',3600.00,0.00,0.00,5.00,635.00,'2023-02-18 15:14:51','',''),(297,'1','312','1',1,'Retail Sale Id 301',4320.00,0.00,0.00,6.00,762.00,'2023-02-18 15:15:51','',''),(298,'1','312','1',1,'Retail Sale Id 302',9000.00,0.00,0.00,12.50,1587.50,'2023-02-18 15:16:57','',''),(299,'1','312','1',1,'Retail Sale Id 303',33120.00,0.00,0.00,46.00,5842.00,'2023-02-18 15:22:23','',''),(300,'1','312','1',1,'Retail Sale Id 304',5040.00,0.00,0.00,7.00,889.00,'2023-02-18 15:33:22','',''),(301,'1','312','1',1,'Retail Sale Id 305',9000.00,0.00,0.00,12.50,1587.50,'2023-02-18 15:37:48','',''),(302,'1','312','1',1,'Retail Sale Id 307',139400.00,0.00,0.00,205.00,17835.00,'2023-02-18 16:05:04','',''),(303,'1','312','1',1,'Retail Sale Id 308',2160.00,0.00,0.00,3.00,381.00,'2023-02-18 16:34:00','',''),(304,'1','312','1',1,'Retail Sale Id 309',2880.00,0.00,0.00,4.00,508.00,'2023-02-18 16:35:03','',''),(305,'1','312','1',1,'Retail Sale Id 310',1303.20,0.00,0.00,1.81,229.87,'2023-02-18 16:41:27','',''),(306,'1','312','1',1,'Retail Sale Id 311',9000.00,0.00,0.00,12.50,1587.50,'2023-02-18 16:58:27','',''),(307,'1','312','1',1,'Retail Sale Id 312',9000.00,0.00,0.00,12.50,1587.50,'2023-02-18 17:04:12','',''),(308,'1','312','1',1,'Retail Sale Id 313',2203.20,0.00,0.00,3.06,388.62,'2023-02-18 17:06:00','',''),(309,'1','312','1',1,'Retail Sale Id 314',5040.00,0.00,0.00,7.00,889.00,'2023-02-18 17:09:31','',''),(310,'1','312','1',1,'Retail Sale Id 315',2160.00,0.00,0.00,3.00,381.00,'2023-02-18 17:23:55','',''),(311,'1','312','1',1,'Retail Sale Id 316',2203.20,0.00,0.00,3.06,388.62,'2023-02-18 17:38:35','',''),(312,'1','312','1',1,'Retail Sale Id 317',1447.20,0.00,0.00,2.01,255.27,'2023-02-18 17:43:03','',''),(313,'1','312','1',1,'Retail Sale Id 318',6480.00,0.00,0.00,9.00,1143.00,'2023-02-18 18:06:05','',''),(314,'1','312','1',1,'Retail Sale Id 319',5040.00,0.00,0.00,7.00,889.00,'2023-02-18 18:08:06','',''),(315,'1','312','1',1,'Retail Sale Id 320',261501.75,0.00,0.00,387.41,31767.62,'2023-02-18 18:13:22','',''),(316,'1','312','1',1,'Retail Sale Id 321',10800.00,0.00,0.00,15.00,1905.00,'2023-02-18 18:17:19','',''),(317,'1','312','1',1,'Retail Sale Id 322',1908.00,0.00,0.00,2.65,336.55,'2023-02-18 19:01:00','',''),(318,'1','312','1',1,'Retail Sale Id 323',8596.80,0.00,0.00,11.94,1516.38,'2023-02-19 08:39:18','',''),(319,'1','312','1',1,'Retail Sale Id 324',7200.00,0.00,0.00,10.00,1270.00,'2023-02-19 08:51:20','',''),(320,'1','312','1',1,'Retail Sale Id 325',2160.00,0.00,0.00,3.00,381.00,'2023-02-19 08:53:49','',''),(321,'1','312','1',1,'Retail Sale Id 326',9000.00,0.00,0.00,12.50,1587.50,'2023-02-19 08:56:31','',''),(322,'1','312','1',1,'Retail Sale Id 327',2001.60,0.00,0.00,2.78,353.06,'2023-02-19 11:03:56','',''),(323,'1','312','1',1,'Retail Sale Id 328',9000.00,0.00,0.00,12.50,1587.50,'2023-02-19 11:05:09','',''),(324,'1','312','1',1,'Retail Sale Id 329',1497.60,0.00,0.00,2.08,264.16,'2023-02-19 11:07:52','',''),(325,'1','312','1',1,'Retail Sale Id 330',3600.00,0.00,0.00,5.00,635.00,'2023-02-19 11:08:46','',''),(326,'1','312','1',1,'Retail Sale Id 331',4320.00,0.00,0.00,6.00,762.00,'2023-02-19 11:09:45','',''),(327,'1','312','1',1,'Retail Sale Id 332',3600.00,0.00,0.00,5.00,635.00,'2023-02-19 11:11:33','',''),(328,'1','312','1',1,'Retail Sale Id 333',4320.00,0.00,0.00,6.00,762.00,'2023-02-19 11:12:35','',''),(329,'1','312','1',1,'Retail Sale Id 334',1440.00,0.00,0.00,2.00,254.00,'2023-02-19 11:13:38','',''),(330,'1','312','1',1,'Retail Sale Id 335',5040.00,0.00,0.00,7.00,889.00,'2023-02-19 11:34:40','',''),(331,'1','312','1',1,'Retail Sale Id 336',8280.00,0.00,0.00,11.50,1460.50,'2023-02-19 11:38:29','',''),(332,'1','312','1',1,'Retail Sale Id 337',1800.00,0.00,0.00,2.50,317.50,'2023-02-19 12:01:13','',''),(333,'1','312','1',1,'Retail Sale Id 338',5040.00,0.00,0.00,7.00,889.00,'2023-02-19 13:32:51','',''),(334,'1','312','1',1,'Retail Sale Id 339',7200.00,0.00,0.00,10.00,1270.00,'2023-02-19 13:43:14','',''),(335,'1','312','1',1,'Retail Sale Id 340',2160.00,0.00,0.00,3.00,381.00,'2023-02-19 13:44:03','',''),(336,'1','312','1',1,'Retail Sale Id 341',2160.00,0.00,0.00,3.00,381.00,'2023-02-19 13:45:02','',''),(337,'1','312','1',1,'Retail Sale Id 342',7200.00,0.00,0.00,10.00,1270.00,'2023-02-19 13:52:09','',''),(338,'1','312','1',1,'Retail Sale Id 343',21600.00,0.00,0.00,30.00,3810.00,'2023-02-19 13:57:10','',''),(339,'1','312','1',1,'Retail Sale Id 344',1447.20,0.00,0.00,2.01,255.27,'2023-02-19 15:06:09','',''),(340,'1','312','1',1,'Retail Sale Id 345',2901.60,0.00,0.00,4.03,511.81,'2023-02-19 15:15:35','',''),(341,'1','312','1',1,'Retail Sale Id 346',9000.00,0.00,0.00,12.50,1587.50,'2023-02-19 15:17:00','',''),(342,'1','312','1',1,'Retail Sale Id 347',9000.00,0.00,0.00,12.50,1587.50,'2023-02-19 15:20:40','',''),(343,'1','312','1',1,'Retail Sale Id 348',4320.00,0.00,0.00,6.00,762.00,'2023-02-19 16:51:35','',''),(344,'1','312','1',1,'Retail Sale Id 349',3600.00,0.00,0.00,5.00,635.00,'2023-02-19 17:01:07','',''),(345,'1','312','1',1,'Retail Sale Id 350',3600.00,0.00,0.00,5.00,635.00,'2023-02-19 17:45:27','',''),(346,'1','312','1',1,'Retail Sale Id 351',5040.00,0.00,0.00,7.00,889.00,'2023-02-19 17:46:59','',''),(347,'1','312','1',1,'Retail Sale Id 352',16200.00,0.00,0.00,22.50,2857.50,'2023-02-19 17:48:13','',''),(348,'1','312','1',1,'Retail Sale Id 353',18000.00,0.00,0.00,25.00,3175.00,'2023-02-19 17:49:16','',''),(349,'1','312','1',1,'Retail Sale Id 354',2160.00,0.00,0.00,3.00,381.00,'2023-02-19 17:50:39','',''),(350,'1','312','1',1,'Retail Sale Id 355',7200.00,0.00,0.00,10.00,1270.00,'2023-02-19 17:51:28','',''),(351,'1','312','1',1,'Retail Sale Id 356',5040.00,0.00,0.00,7.00,889.00,'2023-02-19 17:54:00','',''),(352,'1','312','1',1,'Retail Sale Id 357',1800.00,0.00,0.00,2.50,317.50,'2023-02-19 17:56:00','',''),(353,'1','312','1',1,'Retail Sale Id 358',1447.20,0.00,0.00,2.01,255.27,'2023-02-19 17:58:40','',''),(354,'1','312','1',1,'Retail Sale Id 359',36000.00,0.00,0.00,50.00,6350.00,'2023-02-19 18:04:51','',''),(355,'1','312','1',1,'Retail Sale Id 360',5400.00,0.00,0.00,7.50,952.50,'2023-02-19 18:07:58','',''),(356,'1','312','1',1,'Retail Sale Id 361',9360.00,0.00,0.00,13.00,1651.00,'2023-02-19 18:50:50','',''),(357,'1','312','1',1,'Retail Sale Id 362',11001.60,0.00,0.00,15.28,1940.56,'2023-02-19 19:25:02','',''),(358,'1','312','1',1,'Return of Retail Sale Id 361',0.00,9360.00,13.00,0.00,-1651.00,'2023-02-19 19:27:57','',''),(359,'1','312','1',1,'Return of Retail Sale Id 354',0.00,2160.00,3.00,0.00,-381.00,'2023-02-19 19:35:24','',''),(360,'1','312','1',1,'Retail Sale Id 363',921.60,0.00,0.00,1.28,162.56,'2023-02-19 19:36:23','',''),(361,'1','312','1',1,'Retail Sale Id 364',3600.00,0.00,0.00,5.00,635.00,'2023-02-21 08:02:40','',''),(362,'1','312','1',1,'Retail Sale Id 365',7200.00,0.00,0.00,10.00,1270.00,'2023-02-21 08:46:33','',''),(363,'1','312','1',1,'Retail Sale Id 366',4320.00,0.00,0.00,6.00,762.00,'2023-02-21 08:47:31','',''),(364,'1','312','1',1,'Retail Sale Id 367',3002.40,0.00,0.00,4.17,529.59,'2023-02-21 08:49:02','',''),(365,'1','312','1',1,'Retail Sale Id 368',12600.00,0.00,0.00,17.50,2222.50,'2023-02-21 08:50:04','',''),(366,'1','312','1',1,'Retail Sale Id 369',9000.00,0.00,0.00,12.50,1587.50,'2023-02-21 09:01:37','',''),(367,'1','312','1',1,'Retail Sale Id 370',3600.00,0.00,0.00,5.00,635.00,'2023-02-21 09:02:34','',''),(368,'1','312','1',1,'Retail Sale Id 371',7200.00,0.00,0.00,10.00,1270.00,'2023-02-21 09:18:31','',''),(369,'1','312','1',1,'Retail Sale Id 372',7920.00,0.00,0.00,11.00,1397.00,'2023-02-21 09:20:17','',''),(370,'1','312','1',1,'Retail Sale Id 373',81597.60,0.00,0.00,113.33,14392.91,'2023-02-21 09:50:44','',''),(371,'1','312','1',1,'Retail Sale Id 374',2203.20,0.00,0.00,3.06,388.62,'2023-02-21 09:51:51','',''),(372,'1','312','1',1,'Retail Sale Id 376',9000.00,0.00,0.00,12.50,1587.50,'2023-02-21 09:53:24','',''),(373,'1','312','1',1,'Retail Sale Id 377',3600.00,0.00,0.00,5.00,635.00,'2023-02-21 10:29:58','',''),(374,'1','312','1',1,'Retail Sale Id 378',2203.20,0.00,0.00,3.06,388.62,'2023-02-21 11:12:53','',''),(375,'1','312','1',1,'Retail Sale Id 379',9000.00,0.00,0.00,12.50,1587.50,'2023-02-21 11:14:34','',''),(376,'1','312','1',1,'Retail Sale Id 380',9000.00,0.00,0.00,12.50,1587.50,'2023-02-21 11:54:13','',''),(377,'1','312','1',1,'Retail Sale Id 381',4320.00,0.00,0.00,6.00,762.00,'2023-02-21 12:06:32','',''),(378,'1','312','1',1,'Retail Sale Id 382',4320.00,0.00,0.00,6.00,762.00,'2023-02-21 12:09:05','',''),(379,'1','312','1',1,'Retail Sale Id 383',2160.00,0.00,0.00,3.00,381.00,'2023-02-21 12:17:34','',''),(380,'1','312','1',1,'Retail Sale Id 384',9000.00,0.00,0.00,12.50,1587.50,'2023-02-21 12:25:53','',''),(381,'1','312','1',1,'Retail Sale Id 385',74800.00,0.00,0.00,110.00,9570.00,'2023-02-21 12:28:38','',''),(382,'1','312','1',1,'Retail Sale Id 386',2001.60,0.00,0.00,2.78,353.06,'2023-02-21 12:30:14','',''),(383,'1','312','1',1,'Retail Sale Id 387',9000.00,0.00,0.00,12.50,1587.50,'2023-02-21 12:35:55','',''),(384,'1','312','1',1,'Retail Sale Id 388',4996.80,0.00,0.00,6.94,881.38,'2023-02-21 12:46:54','',''),(385,'1','312','1',1,'Retail Sale Id 389',2160.00,0.00,0.00,3.00,381.00,'2023-02-21 13:10:41','',''),(386,'1','312','1',1,'Retail Sale Id 390',2160.00,0.00,0.00,3.00,381.00,'2023-02-21 13:13:43','',''),(387,'1','312','1',1,'Retail Sale Id 391',438480.00,0.00,0.00,649.60,53267.20,'2023-02-21 13:17:15','',''),(388,'1','312','1',1,'Retail Sale Id 392',3600.00,0.00,0.00,5.00,635.00,'2023-02-21 13:21:02','',''),(389,'1','312','1',1,'Retail Sale Id 393',1447.20,0.00,0.00,2.01,255.27,'2023-02-21 13:23:08','',''),(390,'1','312','1',1,'Retail Sale Id 394',720.00,0.00,0.00,1.00,127.00,'2023-02-21 13:44:32','',''),(391,'1','312','1',1,'Retail Sale Id 395',34000.00,0.00,0.00,50.00,4350.00,'2023-02-21 13:52:44','',''),(392,'1','312','1',1,'Retail Sale Id 396',3600.00,0.00,0.00,5.00,635.00,'2023-02-21 14:05:41','',''),(393,'1','312','1',1,'Retail Sale Id 397',1447.20,0.00,0.00,2.01,255.27,'2023-02-21 14:15:49','',''),(394,'1','312','1',1,'Retail Sale Id 398',2203.20,0.00,0.00,3.06,388.62,'2023-02-21 14:49:32','',''),(395,'1','312','1',1,'Retail Sale Id 399',9000.00,0.00,0.00,12.50,1587.50,'2023-02-21 14:56:37','',''),(396,'1','312','1',1,'Retail Sale Id 400',9000.00,0.00,0.00,12.50,1587.50,'2023-02-21 16:29:05','',''),(397,'1','312','1',1,'Retail Sale Id 401',3600.00,0.00,0.00,5.00,635.00,'2023-02-21 16:30:38','',''),(398,'1','312','1',1,'Retail Sale Id 402',2160.00,0.00,0.00,3.00,381.00,'2023-02-21 16:33:06','',''),(399,'1','312','1',1,'Retail Sale Id 403',4320.00,0.00,0.00,6.00,762.00,'2023-02-21 16:35:36','',''),(400,'1','312','1',1,'Retail Sale Id 404',4320.00,0.00,0.00,6.00,762.00,'2023-02-21 16:47:53','',''),(401,'1','312','1',1,'Retail Sale Id 405',2160.00,0.00,0.00,3.00,381.00,'2023-02-21 16:55:15','',''),(402,'1','312','1',1,'Retail Sale Id 406',4320.00,0.00,0.00,6.00,762.00,'2023-02-21 17:00:38','',''),(403,'1','312','1',1,'Retail Sale Id 407',3600.00,0.00,0.00,5.00,635.00,'2023-02-21 17:05:22','',''),(404,'1','312','1',1,'Retail Sale Id 408',1440.00,0.00,0.00,2.00,254.00,'2023-02-21 17:56:01','',''),(405,'1','312','1',1,'Retail Sale Id 409',4320.00,0.00,0.00,6.00,762.00,'2023-02-21 17:59:05','',''),(406,'1','312','1',1,'Retail Sale Id 410',9000.00,0.00,0.00,12.50,1587.50,'2023-02-21 18:28:22','',''),(407,'1','312','1',1,'Retail Sale Id 411',4320.00,0.00,0.00,6.00,762.00,'2023-02-21 18:48:20','',''),(408,'1','312','1',1,'Retail Sale Id 412',748.80,0.00,0.00,1.04,132.08,'2023-02-21 18:49:32','',''),(409,'1','312','1',1,'Retail Sale Id 414',3247.20,0.00,0.00,4.51,572.77,'2023-02-21 18:57:50','',''),(410,'1','312','1',1,'Retail Sale Id 415',8503.20,0.00,0.00,11.81,1499.87,'2023-02-21 18:59:01','',''),(411,'1','312','1',1,'Return of Retail Sale Id 410',0.00,9000.00,12.50,0.00,-1587.50,'2023-02-21 19:52:16','',''),(412,'1','312','1',1,'Return of Retail Sale Id 387',0.00,9000.00,12.50,0.00,-1587.50,'2023-02-21 19:54:36','',''),(413,'1','312','1',1,'Return of Retail Sale Id 384',0.00,9000.00,12.50,0.00,-1587.50,'2023-02-21 19:56:19','',''),(414,'1','312','1',1,'Return of Retail Sale Id 369',0.00,9000.00,12.50,0.00,-1587.50,'2023-02-21 19:57:42','',''),(415,'1','312','1',1,'Return of Retail Sale Id 368',0.00,12600.00,17.50,0.00,-2222.50,'2023-02-21 19:59:26','',''),(416,'1','312','1',1,'Return of Retail Sale Id 371',0.00,7200.00,10.00,0.00,-1270.00,'2023-02-21 20:03:56','',''),(417,'1','312','1',1,'Return of Retail Sale Id 365',0.00,7200.00,10.00,0.00,-1270.00,'2023-02-21 20:05:31','',''),(418,'1','312','1',1,'Return of Retail Sale Id 366',0.00,4320.00,6.00,0.00,-762.00,'2023-02-21 20:08:01','',''),(419,'1','312','1',1,'Return of Retail Sale Id 415',0.00,8503.20,11.81,0.00,-1499.87,'2023-02-21 20:08:40','',''),(420,'1','312','1',1,'Retail Sale Id 416',81600.00,0.00,0.00,120.00,10440.00,'2023-02-21 20:13:18','',''),(421,'1','312','1',1,'Retail Sale Id 417',1447.20,0.00,0.00,2.01,255.27,'2023-02-22 07:39:22','',''),(422,'1','312','1',1,'Retail Sale Id 418',3196.80,0.00,0.00,4.44,563.88,'2023-02-22 08:17:05','',''),(423,'1','312','1',1,'Retail Sale Id 419',3600.00,0.00,0.00,5.00,635.00,'2023-02-22 08:46:55','',''),(424,'1','312','1',1,'Retail Sale Id 420',3600.00,0.00,0.00,5.00,635.00,'2023-02-22 08:48:43','',''),(425,'1','312','1',1,'Retail Sale Id 421',14997.60,0.00,0.00,20.83,2645.41,'2023-02-22 09:01:09','',''),(426,'1','312','1',1,'Retail Sale Id 422',9000.00,0.00,0.00,12.50,1587.50,'2023-02-22 09:08:41','',''),(427,'1','312','1',1,'Retail Sale Id 423',3600.00,0.00,0.00,5.00,635.00,'2023-02-22 09:39:53','',''),(428,'1','312','1',1,'Retail Sale Id 424',40800.00,0.00,0.00,60.00,5220.00,'2023-02-22 09:41:06','',''),(429,'1','312','1',1,'Retail Sale Id 426',9496.80,0.00,0.00,13.19,1675.13,'2023-02-22 09:55:40','',''),(430,'1','312','1',1,'Retail Sale Id 427',9000.00,0.00,0.00,12.50,1587.50,'2023-02-22 10:19:32','',''),(431,'1','312','1',1,'Retail Sale Id 428',3600.00,0.00,0.00,5.00,635.00,'2023-02-22 10:22:24','',''),(432,'1','312','1',1,'Retail Sale Id 429',5040.00,0.00,0.00,7.00,889.00,'2023-02-22 11:02:23','',''),(433,'1','312','1',1,'Retail Sale Id 430',4996.80,0.00,0.00,6.94,881.38,'2023-02-22 11:59:08','',''),(434,'1','312','1',1,'Retail Sale Id 431',3600.00,0.00,0.00,5.00,635.00,'2023-02-22 12:18:40','',''),(435,'1','312','1',1,'Retail Sale Id 432',2880.00,0.00,0.00,4.00,508.00,'2023-02-22 12:38:23','',''),(436,'1','312','1',1,'Retail Sale Id 433',5040.00,0.00,0.00,7.00,889.00,'2023-02-22 13:14:14','',''),(437,'1','312','1',1,'Retail Sale Id 435',2203.20,0.00,0.00,3.06,388.62,'2023-02-22 13:33:59','',''),(438,'1','312','1',1,'Retail Sale Id 436',9000.00,0.00,0.00,12.50,1587.50,'2023-02-22 13:52:56','',''),(439,'1','312','1',1,'Retail Sale Id 437',5760.00,0.00,0.00,8.00,1016.00,'2023-02-22 14:09:30','',''),(440,'1','312','1',1,'Retail Sale Id 438',4320.00,0.00,0.00,6.00,762.00,'2023-02-22 14:43:10','',''),(441,'1','312','1',1,'Retail Sale Id 439',9360.00,0.00,0.00,13.00,1651.00,'2023-02-22 14:46:02','',''),(442,'1','312','1',1,'Retail Sale Id 440',4996.80,0.00,0.00,6.94,881.38,'2023-02-22 15:03:17','',''),(443,'1','312','1',1,'Retail Sale Id 441',9000.00,0.00,0.00,12.50,1587.50,'2023-02-22 15:16:06','',''),(444,'1','312','1',1,'Retail Sale Id 442',2160.00,0.00,0.00,3.00,381.00,'2023-02-22 15:22:35','',''),(445,'1','312','1',1,'Retail Sale Id 444',9000.00,0.00,0.00,12.50,1587.50,'2023-02-22 15:25:23','',''),(446,'1','312','1',1,'Retail Sale Id 445',7200.00,0.00,0.00,10.00,1270.00,'2023-02-22 16:14:17','',''),(447,'1','312','1',1,'Retail Sale Id 446',6480.00,0.00,0.00,9.00,1143.00,'2023-02-22 16:30:25','',''),(448,'1','312','1',1,'Retail Sale Id 447',2498.40,0.00,0.00,3.47,440.69,'2023-02-22 16:40:27','',''),(449,'1','312','1',1,'Retail Sale Id 448',2203.20,0.00,0.00,3.06,388.62,'2023-02-22 16:45:33','',''),(450,'1','312','1',1,'Retail Sale Id 449',3002.40,0.00,0.00,4.17,529.59,'2023-02-22 17:25:47','',''),(451,'1','312','1',1,'Retail Sale Id 450',5097.60,0.00,0.00,7.08,899.16,'2023-02-22 17:48:39','',''),(452,'1','312','1',1,'Retail Sale Id 451',74800.00,0.00,0.00,110.00,9570.00,'2023-02-22 18:11:18','',''),(453,'1','312','1',1,'Retail Sale Id 452',9000.00,0.00,0.00,12.50,1587.50,'2023-02-22 18:44:17','',''),(454,'1','312','1',1,'Retail Sale Id 453',1000.80,0.00,0.00,1.39,176.53,'2023-02-22 18:47:47','',''),(455,'1','312','1',1,'Retail Sale Id 454',9936.00,0.00,0.00,13.80,1752.60,'2023-02-22 19:27:22','',''),(456,'1','312','1',1,'Retail Sale Id 455',2498.40,0.00,0.00,3.47,440.69,'2023-02-23 07:37:56','',''),(457,'1','312','1',1,'Retail Sale Id 456',9000.00,0.00,0.00,12.50,1587.50,'2023-02-23 07:50:04','',''),(458,'1','312','1',1,'Retail Sale Id 457',4320.00,0.00,0.00,6.00,762.00,'2023-02-23 07:58:58','',''),(459,'1','312','1',1,'Retail Sale Id 458',2880.00,0.00,0.00,4.00,508.00,'2023-02-23 08:13:43','',''),(460,'1','312','1',1,'Retail Sale Id 459',1440.00,0.00,0.00,2.00,254.00,'2023-02-23 08:16:27','',''),(461,'1','312','1',1,'Retail Sale Id 460',2880.00,0.00,0.00,4.00,508.00,'2023-02-23 08:19:05','',''),(462,'1','312','1',1,'Retail Sale Id 461',33840.00,0.00,0.00,47.00,5969.00,'2023-02-23 08:26:31','',''),(463,'1','312','1',1,'Retail Sale Id 462',7920.00,0.00,0.00,11.00,1397.00,'2023-02-23 08:57:50','',''),(464,'1','312','1',1,'Retail Sale Id 463',2160.00,0.00,0.00,3.00,381.00,'2023-02-23 09:01:32','',''),(465,'1','312','1',1,'Retail Sale Id 464',3600.00,0.00,0.00,5.00,635.00,'2023-02-23 09:03:56','',''),(466,'1','312','1',1,'Retail Sale Id 465',3600.00,0.00,0.00,5.00,635.00,'2023-02-23 09:06:55','',''),(467,'1','312','1',1,'Retail Sale Id 466',5047.20,0.00,0.00,7.01,890.27,'2023-02-23 09:08:31','',''),(468,'1','312','1',1,'Retail Sale Id 467',2160.00,0.00,0.00,3.00,381.00,'2023-02-23 09:17:20','',''),(469,'1','312','1',1,'Retail Sale Id 468',4320.00,0.00,0.00,6.00,762.00,'2023-02-23 09:19:25','',''),(470,'1','312','1',1,'Retail Sale Id 469',9000.00,0.00,0.00,12.50,1587.50,'2023-02-23 09:23:56','',''),(471,'1','312','1',1,'Retail Sale Id 470',5040.00,0.00,0.00,7.00,889.00,'2023-02-23 09:45:56','',''),(472,'1','312','1',1,'Retail Sale Id 471',12240.00,0.00,0.00,17.00,2159.00,'2023-02-23 09:51:35','',''),(473,'1','312','1',1,'Retail Sale Id 472',2901.60,0.00,0.00,4.03,511.81,'2023-02-23 09:56:27','',''),(474,'1','312','1',1,'Retail Sale Id 473',3600.00,0.00,0.00,5.00,635.00,'2023-02-23 09:58:02','',''),(475,'1','312','1',1,'Retail Sale Id 474',10080.00,0.00,0.00,14.00,1778.00,'2023-02-23 10:02:01','',''),(476,'1','312','1',1,'Retail Sale Id 475',4320.00,0.00,0.00,6.00,762.00,'2023-02-23 10:17:03','',''),(477,'1','312','1',1,'Retail Sale Id 476',12240.00,0.00,0.00,17.00,2159.00,'2023-02-23 10:41:28','',''),(478,'1','312','1',1,'Retail Sale Id 477',2880.00,0.00,0.00,4.00,508.00,'2023-02-23 10:49:18','',''),(479,'1','312','1',1,'Retail Sale Id 478',4320.00,0.00,0.00,6.00,762.00,'2023-02-23 11:14:27','',''),(480,'1','312','1',1,'Retail Sale Id 479',2160.00,0.00,0.00,3.00,381.00,'2023-02-23 11:17:38','',''),(481,'1','312','1',1,'Retail Sale Id 480',6480.00,0.00,0.00,9.00,1143.00,'2023-02-23 11:51:44','',''),(482,'1','312','1',1,'Retail Sale Id 481',2880.00,0.00,0.00,4.00,508.00,'2023-02-23 12:10:31','',''),(483,'1','312','1',1,'Retail Sale Id 482',2829.60,0.00,0.00,3.93,499.11,'2023-02-23 12:54:45','',''),(484,'1','312',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,2930013.00,4941.00,0.00,0.00,'2023-02-23 13:01:40','',''),(485,'1','312',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,4941.00,0.00,'2023-02-23 13:04:02','',''),(486,'1','312','1',1,'Received from bridging 2',0.00,0.00,4941.00,0.00,0.00,'2023-02-23 13:04:02','',''),(487,'1','312','1',1,'Retail Sale Id 483',9000.00,0.00,0.00,12.50,1587.50,'2023-02-23 13:06:57','',''),(488,'1','312','1',1,'Retail Sale Id 484',7200.00,0.00,0.00,10.00,1270.00,'2023-02-23 13:07:42','',''),(489,'1','312','1',1,'Retail Sale Id 485',8640.00,0.00,0.00,12.00,1524.00,'2023-02-23 13:08:32','',''),(490,'1','312','1',1,'Retail Sale Id 486',9000.00,0.00,0.00,12.50,1587.50,'2023-02-23 13:09:28','',''),(491,'1','312','1',1,'Retail Sale Id 487',2570.40,0.00,0.00,3.57,453.39,'2023-02-23 13:10:48','',''),(492,'1','312','1',1,'Retail Sale Id 488',187000.00,0.00,0.00,275.00,23925.00,'2023-02-23 13:13:29','',''),(493,'1','312','1',1,'Retail Sale Id 489',81600.00,0.00,0.00,120.00,10440.00,'2023-02-23 13:14:30','',''),(494,'1','312','1',1,'Retail Sale Id 490',188700.00,0.00,0.00,277.50,24142.50,'2023-02-23 13:15:55','',''),(495,'1','312','1',1,'Retail Sale Id 491',5760.00,0.00,0.00,8.00,1016.00,'2023-02-23 14:34:50','',''),(496,'1','312','1',1,'Retail Sale Id 492',5040.00,0.00,0.00,7.00,889.00,'2023-02-23 14:36:41','',''),(497,'1','312','1',1,'Retail Sale Id 493',9000.00,0.00,0.00,12.50,1587.50,'2023-02-23 14:41:04','',''),(498,'1','312','1',1,'Retail Sale Id 494',9000.00,0.00,0.00,12.50,1587.50,'2023-02-23 14:42:55','',''),(499,'1','312','1',1,'Retail Sale Id 495',9000.00,0.00,0.00,12.50,1587.50,'2023-02-23 14:46:01','',''),(500,'1','312','1',1,'Retail Sale Id 496',1440.00,0.00,0.00,2.00,254.00,'2023-02-23 14:47:35','',''),(501,'1','312','1',1,'Retail Sale Id 497',5040.00,0.00,0.00,7.00,889.00,'2023-02-23 14:55:56','',''),(502,'1','312','1',1,'Retail Sale Id 498',12240.00,0.00,0.00,17.00,2159.00,'2023-02-23 15:30:15','',''),(503,'1','312','1',1,'Retail Sale Id 499',18000.00,0.00,0.00,25.00,3175.00,'2023-02-23 15:32:56','',''),(504,'1','312','1',1,'Retail Sale Id 500',3600.00,0.00,0.00,5.00,635.00,'2023-02-23 15:35:00','',''),(505,'1','312','1',1,'Retail Sale Id 501',9000.00,0.00,0.00,12.50,1587.50,'2023-02-23 15:39:36','',''),(506,'1','312','1',1,'Retail Sale Id 502',4320.00,0.00,0.00,6.00,762.00,'2023-02-23 15:56:57','',''),(507,'1','312','1',1,'Retail Sale Id 503',5040.00,0.00,0.00,7.00,889.00,'2023-02-23 16:01:06','',''),(508,'1','312','1',1,'Retail Sale Id 504',1440.00,0.00,0.00,2.00,254.00,'2023-02-23 16:32:06','',''),(509,'1','312','1',1,'Retail Sale Id 505',1800.00,0.00,0.00,2.50,317.50,'2023-02-23 16:38:00','',''),(510,'1','312','1',1,'Retail Sale Id 506',7200.00,0.00,0.00,10.00,1270.00,'2023-02-23 16:43:08','',''),(511,'1','312','1',1,'Retail Sale Id 507',9000.00,0.00,0.00,12.50,1587.50,'2023-02-23 16:44:59','',''),(512,'1','312','1',1,'Retail Sale Id 508',1440.00,0.00,0.00,2.00,254.00,'2023-02-23 16:48:30','',''),(513,'1','312','1',1,'Retail Sale Id 509',9000.00,0.00,0.00,12.50,1587.50,'2023-02-23 17:03:05','',''),(514,'1','312','1',1,'Retail Sale Id 510',21080.00,0.00,0.00,31.00,2697.00,'2023-02-23 17:07:58','',''),(515,'1','312','1',1,'Retail Sale Id 511',1440.00,0.00,0.00,2.00,254.00,'2023-02-23 17:18:05','',''),(516,'1','312','1',1,'Retail Sale Id 512',4320.00,0.00,0.00,6.00,762.00,'2023-02-23 17:34:48','',''),(517,'1','312','1',1,'Retail Sale Id 513',2203.20,0.00,0.00,3.06,388.62,'2023-02-23 17:39:40','',''),(518,'1','312','1',1,'Retail Sale Id 514',9000.00,0.00,0.00,1.00,8407.00,'2023-02-23 17:58:23','',''),(519,'1','312','1',1,'Retail Sale Id 515',7200.00,0.00,0.00,10.00,1270.00,'2023-02-23 18:04:41','',''),(520,'1','312','1',1,'Retail Sale Id 516',1440.00,0.00,0.00,2.00,254.00,'2023-02-23 18:40:33','',''),(521,'1','312','1',1,'Retail Sale Id 517',4320.00,0.00,0.00,6.00,762.00,'2023-02-23 18:43:02','',''),(522,'1','312','1',1,'Retail Sale Id 518',7200.00,0.00,0.00,10.00,1270.00,'2023-02-23 18:44:06','',''),(523,'1','312','1',1,'Retail Sale Id 519',9000.00,0.00,0.00,12.50,1587.50,'2023-02-23 18:51:31','',''),(524,'1','312','1',1,'Retail Sale Id 521',3600.00,0.00,0.00,5.00,635.00,'2023-02-23 18:56:14','',''),(525,'1','312','1',1,'Retail Sale Id 522',5191.20,0.00,0.00,7.21,915.67,'2023-02-23 19:13:46','',''),(526,'1','312','1',1,'Retail Sale Id 523',14400.00,0.00,0.00,20.00,2540.00,'2023-02-23 19:14:31','',''),(527,'1','312','1',1,'Retail Sale Id 524',14400.00,0.00,0.00,20.00,2540.00,'2023-02-23 19:15:11','',''),(528,'1','312','1',1,'Return of Retail Sale Id 510',0.00,21080.00,31.00,0.00,-2697.00,'2023-02-23 19:18:47','',''),(529,'1','312','1',1,'Retail Sale Id 525',20359.20,0.00,0.00,29.94,2604.78,'2023-02-23 19:19:52','',''),(530,'1','312','1',1,'Retail Sale Id 526',6048.00,0.00,0.00,8.40,1066.80,'2023-02-24 08:22:18','',''),(531,'1','312','1',1,'Retail Sale Id 527',4996.80,0.00,0.00,6.94,881.38,'2023-02-24 08:45:37','',''),(532,'1','312','1',1,'Retail Sale Id 528',10800.00,0.00,0.00,15.00,1905.00,'2023-02-24 08:47:53','',''),(533,'1','312','1',1,'Retail Sale Id 529',2880.00,0.00,0.00,4.00,508.00,'2023-02-24 08:53:10','',''),(534,'1','312','1',1,'Retail Sale Id 530',3600.00,0.00,0.00,5.00,635.00,'2023-02-24 08:59:35','',''),(535,'1','312','1',1,'Retail Sale Id 531',10800.00,0.00,0.00,15.00,1905.00,'2023-02-24 09:03:08','',''),(536,'1','312','1',1,'Retail Sale Id 532',3600.00,0.00,0.00,5.00,635.00,'2023-02-24 09:33:17','',''),(537,'1','312','1',1,'Retail Sale Id 533',16200.00,0.00,0.00,22.50,2857.50,'2023-02-24 09:45:24','',''),(538,'1','312','1',1,'Retail Sale Id 534',5040.00,0.00,0.00,7.00,889.00,'2023-02-24 09:57:37','',''),(539,'1','312','1',1,'Retail Sale Id 535',9000.00,0.00,0.00,12.50,1587.50,'2023-02-24 10:05:59','',''),(540,'1','312','1',1,'Retail Sale Id 536',7200.00,0.00,0.00,10.00,1270.00,'2023-02-24 10:18:39','',''),(541,'1','312','1',1,'Retail Sale Id 537',4320.00,0.00,0.00,6.00,762.00,'2023-02-24 10:40:31','',''),(542,'1','312','1',1,'Retail Sale Id 538',3002.40,0.00,0.00,4.17,529.59,'2023-02-24 10:43:58','',''),(543,'1','312','1',1,'Retail Sale Id 539',2880.00,0.00,0.00,4.00,508.00,'2023-02-24 11:18:23','',''),(544,'1','312','1',1,'Retail Sale Id 540',4320.00,0.00,0.00,6.00,762.00,'2023-02-24 11:21:42','',''),(545,'1','312','1',1,'Retail Sale Id 541',6480.00,0.00,0.00,9.00,1143.00,'2023-02-24 11:34:39','',''),(546,'1','312','1',1,'Retail Sale Id 542',3600.00,0.00,0.00,5.00,635.00,'2023-02-24 11:41:44','',''),(547,'1','312','1',1,'Retail Sale Id 543',9000.00,0.00,0.00,12.50,1587.50,'2023-02-24 11:43:35','',''),(548,'1','312','1',1,'Retail Sale Id 545',3600.00,0.00,0.00,5.00,635.00,'2023-02-24 12:11:31','',''),(549,'1','312','1',1,'Retail Sale Id 546',2880.00,0.00,0.00,4.00,508.00,'2023-02-24 12:17:14','',''),(550,'1','312','1',1,'Retail Sale Id 547',5040.00,0.00,0.00,7.00,889.00,'2023-02-24 12:23:02','',''),(551,'1','312','1',1,'Retail Sale Id 548',4320.00,0.00,0.00,6.00,762.00,'2023-02-24 12:39:07','',''),(552,'1','312','1',1,'Retail Sale Id 549',8640.00,0.00,0.00,12.00,1524.00,'2023-02-24 12:42:12','',''),(553,'1','312','1',1,'Retail Sale Id 550',2160.00,0.00,0.00,3.00,381.00,'2023-02-24 12:56:04','',''),(554,'1','312','1',1,'Retail Sale Id 551',5040.00,0.00,0.00,7.00,889.00,'2023-02-24 13:08:48','',''),(555,'1','312','1',1,'Retail Sale Id 552',4320.00,0.00,0.00,6.00,762.00,'2023-02-24 13:16:20','',''),(556,'1','312','1',1,'Retail Sale Id 553',4320.00,0.00,0.00,6.00,762.00,'2023-02-24 13:22:23','',''),(557,'1','312','1',1,'Retail Sale Id 554',7920.00,0.00,0.00,11.00,1397.00,'2023-02-24 13:25:49','',''),(558,'1','312','1',1,'Retail Sale Id 555',18000.00,0.00,0.00,25.00,3175.00,'2023-02-24 13:28:58','',''),(559,'1','312','1',1,'Retail Sale Id 556',5040.00,0.00,0.00,7.00,889.00,'2023-02-24 13:37:17','',''),(560,'1','312','1',1,'Retail Sale Id 557',2001.60,0.00,0.00,2.78,353.06,'2023-02-24 13:44:41','',''),(561,'1','312','1',1,'Retail Sale Id 558',2880.00,0.00,0.00,4.00,508.00,'2023-02-24 13:58:18','',''),(562,'1','312','1',1,'Retail Sale Id 559',3600.00,0.00,0.00,5.00,635.00,'2023-02-24 14:00:45','',''),(563,'1','312','1',1,'Retail Sale Id 560',2160.00,0.00,0.00,3.00,381.00,'2023-02-24 14:03:15','',''),(564,'1','312','1',1,'Retail Sale Id 561',4680.00,0.00,0.00,6.50,825.50,'2023-02-24 14:05:16','',''),(565,'1','312','1',1,'Retail Sale Id 562',2880.00,0.00,0.00,4.00,508.00,'2023-02-24 14:30:06','',''),(566,'1','312','1',1,'Retail Sale Id 563',18000.00,0.00,0.00,25.00,3175.00,'2023-02-24 14:35:03','',''),(567,'1','312','1',1,'Retail Sale Id 564',18000.00,0.00,0.00,25.00,3175.00,'2023-02-24 15:20:56','',''),(568,'1','312','1',1,'Retail Sale Id 565',10440.00,0.00,0.00,14.50,1841.50,'2023-02-24 15:26:10','',''),(569,'1','312','1',1,'Retail Sale Id 566',2880.00,0.00,0.00,4.00,508.00,'2023-02-24 15:29:04','',''),(570,'1','312','1',1,'Retail Sale Id 567',2880.00,0.00,0.00,4.00,508.00,'2023-02-24 15:42:00','',''),(571,'1','312','1',1,'Retail Sale Id 568',9000.00,0.00,0.00,12.50,1587.50,'2023-02-24 15:44:51','',''),(572,'1','312','1',1,'Retail Sale Id 569',4680.00,0.00,0.00,6.50,825.50,'2023-02-24 15:46:40','',''),(573,'1','312','1',1,'Retail Sale Id 570',3600.00,0.00,0.00,5.00,635.00,'2023-02-24 15:52:44','',''),(574,'1','312','1',1,'Retail Sale Id 571',3600.00,0.00,0.00,5.00,635.00,'2023-02-24 15:56:19','',''),(575,'1','312','1',1,'Retail Sale Id 572',1440.00,0.00,0.00,2.00,254.00,'2023-02-24 16:00:56','',''),(576,'1','312','1',1,'Retail Sale Id 573',5040.00,0.00,0.00,7.00,889.00,'2023-02-24 16:05:30','',''),(577,'1','312','1',1,'Retail Sale Id 574',2160.00,0.00,0.00,3.00,381.00,'2023-02-24 16:14:34','',''),(578,'1','312','1',1,'Retail Sale Id 575',9000.00,0.00,0.00,12.50,1587.50,'2023-02-24 16:59:04','',''),(579,'1','312','1',1,'Retail Sale Id 576',1440.00,0.00,0.00,2.00,254.00,'2023-02-24 17:06:44','',''),(580,'1','312','1',1,'Retail Sale Id 577',4320.00,0.00,0.00,6.00,762.00,'2023-02-24 17:16:05','',''),(581,'1','312','1',1,'Retail Sale Id 578',2160.00,0.00,0.00,3.00,381.00,'2023-02-24 17:24:02','',''),(582,'1','312','1',1,'Retail Sale Id 579',2160.00,0.00,0.00,3.00,381.00,'2023-02-24 17:25:04','',''),(583,'1','312','1',1,'Retail Sale Id 580',2880.00,0.00,0.00,4.00,508.00,'2023-02-24 17:27:19','',''),(584,'1','312','1',1,'Retail Sale Id 582',10800.00,0.00,0.00,15.00,1905.00,'2023-02-24 17:29:19','',''),(585,'1','312','1',1,'Retail Sale Id 583',5040.00,0.00,0.00,7.00,889.00,'2023-02-24 17:30:18','',''),(586,'1','312','1',1,'Retail Sale Id 584',7200.00,0.00,0.00,10.00,1270.00,'2023-02-24 17:33:19','',''),(587,'1','312','1',1,'Retail Sale Id 585',5040.00,0.00,0.00,7.00,889.00,'2023-02-24 17:35:32','',''),(588,'1','312','1',1,'Retail Sale Id 586',12240.00,0.00,0.00,17.00,2159.00,'2023-02-24 17:37:20','',''),(589,'1','312','1',1,'Retail Sale Id 587',9000.00,0.00,0.00,12.50,1587.50,'2023-02-24 17:38:06','',''),(590,'1','312','1',1,'Retail Sale Id 589',7200.00,0.00,0.00,10.00,1270.00,'2023-02-24 17:42:48','',''),(591,'1','312','1',1,'Retail Sale Id 590',8280.00,0.00,0.00,11.50,1460.50,'2023-02-24 17:45:10','',''),(592,'1','312','1',1,'Retail Sale Id 591',1440.00,0.00,0.00,2.00,254.00,'2023-02-24 17:48:17','',''),(593,'1','312','1',1,'Retail Sale Id 592',7920.00,0.00,0.00,11.00,1397.00,'2023-02-24 17:49:47','',''),(594,'1','312','1',1,'Retail Sale Id 593',1440.00,0.00,0.00,2.00,254.00,'2023-02-24 18:04:36','',''),(595,'1','312','1',1,'Retail Sale Id 594',5040.00,0.00,0.00,7.00,889.00,'2023-02-24 18:10:23','',''),(596,'1','312','1',1,'Retail Sale Id 595',6480.00,0.00,0.00,9.00,1143.00,'2023-02-24 18:11:37','',''),(597,'1','312','1',1,'Retail Sale Id 597',2160.00,0.00,0.00,3.00,381.00,'2023-02-24 18:13:20','',''),(598,'1','312','1',1,'Retail Sale Id 598',3600.00,0.00,0.00,5.00,635.00,'2023-02-24 18:14:13','',''),(599,'1','312','1',1,'Retail Sale Id 599',2901.60,0.00,0.00,4.03,511.81,'2023-02-24 18:15:41','',''),(600,'1','312','1',1,'Retail Sale Id 600',3600.00,0.00,0.00,5.00,635.00,'2023-02-24 18:22:31','',''),(601,'1','312','1',1,'Retail Sale Id 601',5400.00,0.00,0.00,7.50,952.50,'2023-02-24 18:33:33','',''),(602,'1','312','1',1,'Retail Sale Id 602',16560.00,0.00,0.00,23.00,2921.00,'2023-02-24 18:40:19','',''),(603,'1','312','1',1,'Retail Sale Id 603',2901.60,0.00,0.00,4.03,511.81,'2023-02-24 18:43:11','',''),(604,'1','312','1',1,'Retail Sale Id 604',320213.25,0.00,0.00,474.39,38899.98,'2023-02-24 18:57:47','',''),(605,'1','312','1',1,'Retail Sale Id 605',2160.00,0.00,0.00,3.00,381.00,'2023-02-28 08:05:11','',''),(606,'1','312','1',1,'Retail Sale Id 606',2203.20,0.00,0.00,3.06,388.62,'2023-02-28 08:40:45','',''),(607,'1','312','1',1,'Retail Sale Id 607',7200.00,0.00,0.00,10.00,1270.00,'2023-02-28 08:42:36','',''),(608,'1','312','1',1,'Retail Sale Id 608',9000.00,0.00,0.00,12.50,1587.50,'2023-02-28 08:44:53','',''),(609,'1','312','1',1,'Retail Sale Id 609',7200.00,0.00,0.00,10.00,1270.00,'2023-02-28 08:53:53','',''),(610,'1','312','1',1,'Retail Sale Id 610',1440.00,0.00,0.00,2.00,254.00,'2023-02-28 09:28:23','',''),(611,'1','312','1',1,'Retail Sale Id 611',4320.00,0.00,0.00,6.00,762.00,'2023-02-28 09:34:03','',''),(612,'1','312','1',1,'Retail Sale Id 612',3600.00,0.00,0.00,5.00,635.00,'2023-02-28 09:59:45','',''),(613,'1','312','1',1,'Retail Sale Id 613',2880.00,0.00,0.00,4.00,508.00,'2023-02-28 10:00:55','',''),(614,'1','312','1',1,'Retail Sale Id 614',720.00,0.00,0.00,1.00,127.00,'2023-02-28 10:02:10','',''),(615,'1','312','1',1,'Retail Sale Id 615',4320.00,0.00,0.00,6.00,762.00,'2023-02-28 10:21:10','',''),(616,'1','312','1',1,'Retail Sale Id 616',5040.00,0.00,0.00,7.00,889.00,'2023-02-28 11:11:40','',''),(617,'1','312','1',1,'Retail Sale Id 617',5040.00,0.00,0.00,7.00,889.00,'2023-02-28 11:18:20','',''),(618,'1','312','1',1,'Retail Sale Id 618',5040.00,0.00,0.00,7.00,889.00,'2023-02-28 11:20:48','',''),(619,'1','312','1',1,'Retail Sale Id 619',3600.00,0.00,0.00,5.00,635.00,'2023-02-28 11:57:30','',''),(620,'1','312','1',1,'Retail Sale Id 620',7200.00,0.00,0.00,10.00,1270.00,'2023-02-28 12:09:04','',''),(621,'1','312','1',1,'Retail Sale Id 621',2160.00,0.00,0.00,3.00,381.00,'2023-02-28 12:29:11','',''),(622,'1','312','1',1,'Retail Sale Id 622',1497.60,0.00,0.00,2.08,264.16,'2023-02-28 12:48:46','',''),(623,'1','312','1',1,'Retail Sale Id 623',3600.00,0.00,0.00,5.00,635.00,'2023-02-28 13:52:22','',''),(624,'1','312','1',1,'Retail Sale Id 624',8640.00,0.00,0.00,12.00,1524.00,'2023-02-28 13:55:08','',''),(625,'1','312','1',1,'Retail Sale Id 625',7920.00,0.00,0.00,11.00,1397.00,'2023-02-28 14:20:06','',''),(626,'1','312','1',1,'Retail Sale Id 626',7977.60,0.00,0.00,11.08,1407.16,'2023-02-28 14:43:25','',''),(627,'1','312','1',1,'Retail Sale Id 627',1440.00,0.00,0.00,2.00,254.00,'2023-02-28 15:52:42','',''),(628,'1','312','1',1,'Retail Sale Id 628',9000.00,0.00,0.00,12.50,1587.50,'2023-02-28 16:05:15','',''),(629,'1','312','1',1,'Retail Sale Id 629',9000.00,0.00,0.00,12.50,1587.50,'2023-02-28 16:43:10','',''),(630,'1','312','1',1,'Retail Sale Id 630',1000.80,0.00,0.00,1.39,176.53,'2023-02-28 16:47:48','',''),(631,'1','312','1',1,'Retail Sale Id 631',417116.25,0.00,0.00,617.95,50671.90,'2023-02-28 19:14:03','',''),(632,'1','312','1',1,'Retail Sale Id 632',23191.20,0.00,0.00,32.21,4090.67,'2023-02-28 19:16:51','',''),(633,'1','312','1',1,'Retail Sale Id 633',5040.00,0.00,0.00,7.00,889.00,'2023-03-01 07:49:42','',''),(634,'1','312','1',1,'Retail Sale Id 634',9000.00,0.00,0.00,12.50,1587.50,'2023-03-01 07:59:30','',''),(635,'1','312','1',1,'Retail Sale Id 635',2160.00,0.00,0.00,3.00,381.00,'2023-03-01 08:16:33','',''),(636,'1','312','1',1,'Retail Sale Id 636',4680.00,0.00,0.00,6.50,825.50,'2023-03-01 08:24:27','',''),(637,'1','312','1',1,'Retail Sale Id 637',5040.00,0.00,0.00,7.00,889.00,'2023-03-01 08:37:51','',''),(638,'1','312','1',1,'Retail Sale Id 638',5997.60,0.00,0.00,8.33,1057.91,'2023-03-01 08:49:45','',''),(639,'1','312','1',1,'Retail Sale Id 639',5040.00,0.00,0.00,7.00,889.00,'2023-03-01 08:57:52','',''),(640,'1','312','1',1,'Retail Sale Id 640',7200.00,0.00,0.00,10.00,1270.00,'2023-03-01 09:43:42','',''),(641,'1','312','1',1,'Retail Sale Id 641',2880.00,0.00,0.00,4.00,508.00,'2023-03-01 10:27:16','',''),(642,'1','312','1',1,'Retail Sale Id 642',4500.00,0.00,0.00,6.25,793.75,'2023-03-01 10:41:36','',''),(643,'1','312','1',1,'Retail Sale Id 643',5040.00,0.00,0.00,7.00,889.00,'2023-03-01 10:44:03','',''),(644,'1','312','1',1,'Retail Sale Id 644',4320.00,0.00,0.00,6.00,762.00,'2023-03-01 10:50:54','',''),(645,'1','312','1',1,'Retail Sale Id 645',3600.00,0.00,0.00,5.00,635.00,'2023-03-01 12:16:06','',''),(646,'1','312','1',1,'Retail Sale Id 646',3600.00,0.00,0.00,5.00,635.00,'2023-03-01 12:49:59','',''),(647,'1','312','1',1,'Retail Sale Id 647',2160.00,0.00,0.00,3.00,381.00,'2023-03-01 14:20:52','',''),(648,'1','312','1',1,'Retail Sale Id 648',4320.00,0.00,0.00,6.00,762.00,'2023-03-01 14:36:25','',''),(649,'1','312','1',1,'Retail Sale Id 649',2880.00,0.00,0.00,4.00,508.00,'2023-03-01 15:08:05','',''),(650,'1','312','1',1,'Retail Sale Id 650',4003.20,0.00,0.00,5.56,706.12,'2023-03-01 15:10:14','',''),(651,'1','312','1',1,'Retail Sale Id 651',2160.00,0.00,0.00,3.00,381.00,'2023-03-01 17:38:29','',''),(652,'1','312','1',1,'Retail Sale Id 652',2160.00,0.00,0.00,3.00,381.00,'2023-03-01 17:40:25','',''),(653,'1','312','1',1,'Retail Sale Id 654',2880.00,0.00,0.00,4.00,508.00,'2023-03-01 17:42:49','',''),(654,'1','312','1',1,'Retail Sale Id 655',4320.00,0.00,0.00,6.00,762.00,'2023-03-01 17:51:56','',''),(655,'1','312','1',1,'Retail Sale Id 656',5040.00,0.00,0.00,7.00,889.00,'2023-03-01 18:13:20','',''),(656,'1','312','1',1,'Retail Sale Id 657',3002.40,0.00,0.00,4.17,529.59,'2023-03-01 18:22:55','',''),(657,'1','312','1',1,'Retail Sale Id 658',9000.00,0.00,0.00,12.50,1587.50,'2023-03-01 18:24:06','',''),(658,'1','312','1',1,'Retail Sale Id 659',2160.00,0.00,0.00,3.00,381.00,'2023-03-01 18:33:57','',''),(659,'1','312','1',1,'Retail Sale Id 660',2203.20,0.00,0.00,3.06,388.62,'2023-03-01 18:45:07','',''),(660,'1','312','1',1,'Retail Sale Id 661',9000.00,0.00,0.00,12.50,1587.50,'2023-03-01 18:49:46','',''),(661,'1','312','1',1,'Retail Sale Id 662',472122.00,0.00,0.00,699.44,57354.08,'2023-03-01 19:05:30','',''),(662,'1','312','1',1,'Retail Sale Id 663',3556.80,0.00,0.00,4.94,627.38,'2023-03-01 19:08:42','',''),(663,'1','312','1',1,'Retail Sale Id 664',21600.00,0.00,0.00,30.00,3810.00,'2023-03-01 19:09:22','',''),(664,'1','312','1',1,'Retail Sale Id 665',4996.80,0.00,0.00,6.94,881.38,'2023-03-02 08:28:18','',''),(665,'1','312','1',1,'Retail Sale Id 666',4320.00,0.00,0.00,6.00,762.00,'2023-03-02 08:48:11','',''),(666,'1','312','1',1,'Retail Sale Id 667',5040.00,0.00,0.00,7.00,889.00,'2023-03-02 08:57:31','',''),(667,'1','312','1',1,'Retail Sale Id 668',9000.00,0.00,0.00,12.50,1587.50,'2023-03-02 09:08:51','',''),(668,'1','312','1',1,'Retail Sale Id 669',5040.00,0.00,0.00,7.00,889.00,'2023-03-02 09:12:15','',''),(669,'1','312','1',1,'Retail Sale Id 670',720.00,0.00,0.00,1.00,127.00,'2023-03-02 09:35:32','',''),(670,'1','312','1',1,'Retail Sale Id 671',9000.00,0.00,0.00,12.50,1587.50,'2023-03-02 10:00:58','',''),(671,'1','312','1',1,'Retail Sale Id 672',2001.60,0.00,0.00,2.78,353.06,'2023-03-02 10:04:18','',''),(672,'1','312','1',1,'Retail Sale Id 673',2160.00,0.00,0.00,3.00,381.00,'2023-03-02 10:08:51','',''),(673,'1','312','1',1,'Retail Sale Id 674',9000.00,0.00,0.00,12.50,1587.50,'2023-03-02 11:05:44','',''),(674,'1','312','1',1,'Retail Sale Id 675',1440.00,0.00,0.00,2.00,254.00,'2023-03-02 11:16:23','',''),(675,'1','312','1',1,'Retail Sale Id 676',2160.00,0.00,0.00,3.00,381.00,'2023-03-02 11:52:20','',''),(676,'1','312','1',1,'Retail Sale Id 677',2160.00,0.00,0.00,3.00,381.00,'2023-03-02 12:20:46','',''),(677,'1','312','1',1,'Retail Sale Id 678',2203.20,0.00,0.00,3.06,388.62,'2023-03-02 12:23:03','',''),(678,'1','312','1',1,'Retail Sale Id 679',7200.00,0.00,0.00,10.00,1270.00,'2023-03-02 12:40:44','',''),(679,'1','312','1',1,'Retail Sale Id 680',3600.00,0.00,0.00,5.00,635.00,'2023-03-02 12:42:38','',''),(680,'1','312','1',1,'Retail Sale Id 681',7200.00,0.00,0.00,10.00,1270.00,'2023-03-02 13:45:37','',''),(681,'1','312','1',1,'Retail Sale Id 682',4320.00,0.00,0.00,6.00,762.00,'2023-03-02 13:47:46','',''),(682,'1','312','1',1,'Retail Sale Id 683',3002.40,0.00,0.00,4.17,529.59,'2023-03-02 14:02:01','',''),(683,'1','312','1',1,'Retail Sale Id 684',9000.00,0.00,0.00,12.50,1587.50,'2023-03-02 15:00:30','',''),(684,'1','312','1',1,'Retail Sale Id 685',4003.20,0.00,0.00,5.56,706.12,'2023-03-02 15:03:16','',''),(685,'1','312','1',1,'Retail Sale Id 686',9000.00,0.00,0.00,12.50,1587.50,'2023-03-02 15:27:16','',''),(686,'1','312','1',1,'Retail Sale Id 687',4320.00,0.00,0.00,6.00,762.00,'2023-03-02 15:35:56','',''),(687,'1','312','1',1,'Retail Sale Id 688',5040.00,0.00,0.00,7.00,889.00,'2023-03-02 15:37:34','',''),(688,'1','312','1',1,'Retail Sale Id 689',9000.00,0.00,0.00,12.50,1587.50,'2023-03-02 16:09:45','',''),(689,'1','312','1',1,'Retail Sale Id 690',5040.00,0.00,0.00,7.00,889.00,'2023-03-02 16:13:50','',''),(690,'1','312','1',1,'Retail Sale Id 691',4003.20,0.00,0.00,5.56,706.12,'2023-03-02 16:34:04','',''),(691,'1','312','1',1,'Retail Sale Id 692',5040.00,0.00,0.00,7.00,889.00,'2023-03-02 16:43:08','',''),(692,'1','312','1',1,'Retail Sale Id 693',9000.00,0.00,0.00,12.50,1587.50,'2023-03-02 17:01:11','',''),(693,'1','312','1',1,'Retail Sale Id 694',2160.00,0.00,0.00,3.00,381.00,'2023-03-02 17:35:47','',''),(694,'1','312','1',1,'Retail Sale Id 695',2160.00,0.00,0.00,3.00,381.00,'2023-03-02 17:38:00','',''),(695,'1','312','1',1,'Retail Sale Id 696',4320.00,0.00,0.00,6.00,762.00,'2023-03-02 17:51:30','',''),(696,'1','312','1',1,'Retail Sale Id 697',5040.00,0.00,0.00,7.00,889.00,'2023-03-02 18:06:42','',''),(697,'1','312','1',1,'Retail Sale Id 698',9000.00,0.00,0.00,12.50,1587.50,'2023-03-02 18:15:07','',''),(698,'1','312','1',1,'Retail Sale Id 699',5040.00,0.00,0.00,7.00,889.00,'2023-03-02 18:16:33','',''),(699,'1','312','1',1,'Retail Sale Id 700',9000.00,0.00,0.00,12.50,1587.50,'2023-03-02 18:23:03','',''),(700,'1','312','1',1,'Retail Sale Id 701',81600.00,0.00,0.00,120.00,10440.00,'2023-03-02 19:06:31','',''),(701,'1','312','1',1,'Retail Sale Id 702',34000.00,0.00,0.00,50.00,4350.00,'2023-03-02 19:07:25','',''),(702,'1','312','1',1,'Retail Sale Id 703',5040.00,0.00,0.00,7.00,889.00,'2023-03-03 09:22:59','',''),(703,'1','312','1',1,'Retail Sale Id 705',2160.00,0.00,0.00,3.00,381.00,'2023-03-03 10:18:12','',''),(704,'1','312','1',1,'Retail Sale Id 706',9000.00,0.00,0.00,12.50,1587.50,'2023-03-03 10:56:01','',''),(705,'1','312','1',1,'Retail Sale Id 707',9000.00,0.00,0.00,12.50,1587.50,'2023-03-03 11:24:39','',''),(706,'1','312','1',1,'Retail Sale Id 708',4320.00,0.00,0.00,6.00,762.00,'2023-03-03 11:27:53','',''),(707,'1','312','1',1,'Retail Sale Id 709',2160.00,0.00,0.00,3.00,381.00,'2023-03-03 11:45:05','',''),(708,'1','312','1',1,'Retail Sale Id 710',2880.00,0.00,0.00,4.00,508.00,'2023-03-03 12:00:08','',''),(709,'1','312','1',1,'Retail Sale Id 711',7920.00,0.00,0.00,11.00,1397.00,'2023-03-03 12:04:03','',''),(710,'1','312','1',1,'Retail Sale Id 712',5040.00,0.00,0.00,7.00,889.00,'2023-03-03 12:22:01','',''),(711,'1','312','1',1,'Retail Sale Id 713',2160.00,0.00,0.00,3.00,381.00,'2023-03-03 12:42:37','',''),(712,'1','312','1',1,'Retail Sale Id 714',4320.00,0.00,0.00,6.00,762.00,'2023-03-03 13:33:45','',''),(713,'1','312','1',1,'Retail Sale Id 715',2160.00,0.00,0.00,3.00,381.00,'2023-03-03 13:44:29','',''),(714,'1','312','1',1,'Retail Sale Id 716',9000.00,0.00,0.00,12.50,1587.50,'2023-03-03 13:56:08','',''),(715,'1','312','1',1,'Retail Sale Id 717',2160.00,0.00,0.00,3.00,381.00,'2023-03-03 14:09:15','',''),(716,'1','312','1',1,'Retail Sale Id 718',2880.00,0.00,0.00,4.00,508.00,'2023-03-03 14:22:15','',''),(717,'1','312','1',1,'Retail Sale Id 719',2880.00,0.00,0.00,4.00,508.00,'2023-03-03 14:49:55','',''),(718,'1','312','1',1,'Retail Sale Id 720',1440.00,0.00,0.00,2.00,254.00,'2023-03-03 15:14:28','',''),(719,'1','312','1',1,'Retail Sale Id 721',1497.60,0.00,0.00,2.08,264.16,'2023-03-03 15:40:32','',''),(720,'1','312','1',1,'Retail Sale Id 722',5040.00,0.00,0.00,7.00,889.00,'2023-03-03 15:48:07','',''),(721,'1','312','1',1,'Retail Sale Id 723',5040.00,0.00,0.00,7.00,889.00,'2023-03-03 15:50:40','',''),(722,'1','312','1',1,'Retail Sale Id 724',9000.00,0.00,0.00,12.50,1587.50,'2023-03-03 16:03:10','',''),(723,'1','312','1',1,'Retail Sale Id 725',4320.00,0.00,0.00,6.00,762.00,'2023-03-03 16:05:53','',''),(724,'1','312','1',1,'Retail Sale Id 726',7200.00,0.00,0.00,10.00,1270.00,'2023-03-03 16:34:41','',''),(725,'1','312','1',1,'Retail Sale Id 727',2498.40,0.00,0.00,3.47,440.69,'2023-03-03 16:36:42','',''),(726,'1','312','1',1,'Retail Sale Id 728',7200.00,0.00,0.00,10.00,1270.00,'2023-03-03 16:38:54','',''),(727,'1','312','1',1,'Retail Sale Id 729',3600.00,0.00,0.00,5.00,635.00,'2023-03-03 16:42:56','',''),(728,'1','312','1',1,'Retail Sale Id 730',5040.00,0.00,0.00,7.00,889.00,'2023-03-03 16:52:27','',''),(729,'1','312','1',1,'Retail Sale Id 731',40800.00,0.00,0.00,60.00,5220.00,'2023-03-03 19:19:23','',''),(730,'1','312','1',1,'Retail Sale Id 732',40800.00,0.00,0.00,60.00,5220.00,'2023-03-03 19:20:07','',''),(731,'1','312','1',1,'Retail Sale Id 733',16200.00,0.00,0.00,22.50,2857.50,'2023-03-03 19:22:12','',''),(732,'1','312','1',1,'Retail Sale Id 734',4320.00,0.00,0.00,6.00,762.00,'2023-03-04 08:00:22','',''),(733,'1','312','1',1,'Retail Sale Id 736',2880.00,0.00,0.00,4.00,508.00,'2023-03-04 08:09:46','',''),(734,'1','312','1',1,'Retail Sale Id 737',6998.40,0.00,0.00,9.72,1234.44,'2023-03-04 08:19:24','',''),(735,'1','312','1',1,'Retail Sale Id 738',1440.00,0.00,0.00,2.00,254.00,'2023-03-04 08:23:53','',''),(736,'1','312','1',1,'Retail Sale Id 739',1440.00,0.00,0.00,2.00,254.00,'2023-03-04 08:26:02','',''),(737,'1','312','1',1,'Retail Sale Id 740',4320.00,0.00,0.00,6.00,762.00,'2023-03-04 08:42:05','',''),(738,'1','312','1',1,'Retail Sale Id 741',4320.00,0.00,0.00,6.00,762.00,'2023-03-04 08:50:01','',''),(739,'1','312','1',1,'Retail Sale Id 742',3600.00,0.00,0.00,5.00,635.00,'2023-03-04 09:03:47','',''),(740,'1','312','1',1,'Retail Sale Id 743',9000.00,0.00,0.00,12.50,1587.50,'2023-03-04 09:29:10','',''),(741,'1','312','1',1,'Retail Sale Id 744',4003.20,0.00,0.00,5.56,706.12,'2023-03-04 09:33:25','',''),(742,'1','312','1',1,'Retail Sale Id 745',4348.80,0.00,0.00,6.04,767.08,'2023-03-04 09:36:03','',''),(743,'1','312','1',1,'Retail Sale Id 746',7920.00,0.00,0.00,11.00,1397.00,'2023-03-04 09:43:38','',''),(744,'1','312','1',1,'Retail Sale Id 747',9000.00,0.00,0.00,12.50,1587.50,'2023-03-04 09:47:59','',''),(745,'1','312','1',1,'Retail Sale Id 748',9000.00,0.00,0.00,12.50,1587.50,'2023-03-04 09:59:46','',''),(746,'1','312','1',1,'Retail Sale Id 749',9000.00,0.00,0.00,12.50,1587.50,'2023-03-04 10:15:51','',''),(747,'1','312','1',1,'Retail Sale Id 750',129200.00,0.00,0.00,190.00,16530.00,'2023-03-04 10:16:47','',''),(748,'1','312','1',1,'Retail Sale Id 751',5040.00,0.00,0.00,7.00,889.00,'2023-03-04 10:25:52','',''),(749,'1','312','1',1,'Retail Sale Id 752',7200.00,0.00,0.00,10.00,1270.00,'2023-03-04 10:38:42','',''),(750,'1','312','1',1,'Retail Sale Id 753',2160.00,0.00,0.00,3.00,381.00,'2023-03-04 10:51:55','',''),(751,'1','312','1',1,'Retail Sale Id 754',3002.40,0.00,0.00,4.17,529.59,'2023-03-04 10:57:22','',''),(752,'1','312','1',1,'Retail Sale Id 755',5097.60,0.00,0.00,7.08,899.16,'2023-03-04 11:01:52','',''),(753,'1','312','1',1,'Retail Sale Id 756',3600.00,0.00,0.00,5.00,635.00,'2023-03-04 11:27:36','',''),(754,'1','312','1',1,'Retail Sale Id 757',2203.20,0.00,0.00,3.06,388.62,'2023-03-04 11:50:37','',''),(755,'1','312','1',1,'Retail Sale Id 758',2880.00,0.00,0.00,4.00,508.00,'2023-03-04 12:02:20','',''),(756,'1','312','1',1,'Retail Sale Id 759',11520.00,0.00,0.00,16.00,2032.00,'2023-03-04 12:19:28','',''),(757,'1','312','1',1,'Retail Sale Id 760',1591.20,0.00,0.00,2.21,280.67,'2023-03-04 12:29:30','',''),(758,'1','312',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,9885.31,16.67,0.00,0.00,'2023-03-04 12:32:06','',''),(759,'1','312',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,16.67,0.00,'2023-03-04 12:33:49','',''),(760,'1','312','1',1,'Received from bridging 3',0.00,0.00,16.67,0.00,0.00,'2023-03-04 12:33:49','',''),(761,'1','312','1',1,'Retail Sale Id 761',12002.40,0.00,0.00,16.67,2117.09,'2023-03-04 12:34:58','',''),(762,'1','312',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,3294000.00,5400.00,0.00,0.00,'2023-03-08 08:55:07','',''),(763,'1','312',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,5400.00,0.00,'2023-03-08 08:59:09','',''),(764,'1','312','1',1,'Received from bridging 4',0.00,0.00,5400.00,0.00,0.00,'2023-03-08 08:59:09','',''),(765,'1','312','1',1,'Retail Sale Id 762',7920.00,0.00,0.00,11.00,1210.00,'2023-03-08 09:06:37','',''),(766,'1','312','1',1,'Retail Sale Id 763',2160.00,0.00,0.00,3.00,330.00,'2023-03-08 09:13:12','',''),(767,'1','312','1',1,'Retail Sale Id 764',9000.00,0.00,0.00,12.50,1375.00,'2023-03-08 09:14:40','',''),(768,'1','312','1',1,'Retail Sale Id 765',7200.00,0.00,0.00,10.00,1100.00,'2023-03-08 12:48:10','',''),(769,'1','312','1',1,'Retail Sale Id 766',9000.00,0.00,0.00,12.50,1375.00,'2023-03-08 12:52:46','',''),(770,'1','312','1',1,'Retail Sale Id 767',4320.00,0.00,0.00,6.00,660.00,'2023-03-08 12:58:19','',''),(771,'1','312','1',1,'Retail Sale Id 768',9000.00,0.00,0.00,12.50,1375.00,'2023-03-08 13:01:10','',''),(772,'1','312','1',1,'Retail Sale Id 769',172462.50,0.00,0.00,255.50,16607.50,'2023-03-08 13:13:36','',''),(773,'1','312','1',1,'Retail Sale Id 770',2160.00,0.00,0.00,3.00,330.00,'2023-03-08 13:14:54','',''),(774,'1','312','1',1,'Retail Sale Id 771',2880.00,0.00,0.00,4.00,440.00,'2023-03-08 13:15:45','',''),(775,'1','312','1',1,'Retail Sale Id 772',1440.00,0.00,0.00,2.00,220.00,'2023-03-08 13:16:48','',''),(776,'1','312','1',1,'Retail Sale Id 773',4320.00,0.00,0.00,6.00,660.00,'2023-03-08 13:17:54','',''),(777,'1','312','1',1,'Retail Sale Id 774',20400.00,0.00,0.00,30.00,2100.00,'2023-03-08 13:41:30','',''),(778,'1','312','1',1,'Retail Sale Id 775',4320.00,0.00,0.00,6.00,660.00,'2023-03-08 14:21:49','',''),(779,'1','312','1',1,'Retail Sale Id 776',9000.00,0.00,0.00,12.50,1375.00,'2023-03-08 14:59:20','',''),(780,'1','312','1',1,'Retail Sale Id 777',4320.00,0.00,0.00,6.00,660.00,'2023-03-08 15:03:08','',''),(781,'1','312','1',1,'Retail Sale Id 779',2160.00,0.00,0.00,3.00,330.00,'2023-03-08 15:06:19','',''),(782,'1','312','1',1,'Retail Sale Id 780',7200.00,0.00,0.00,10.00,1100.00,'2023-03-08 15:23:43','',''),(783,'1','312','1',1,'Retail Sale Id 786',2397.60,0.00,0.00,3.33,366.30,'2023-03-08 16:25:56','',''),(784,'1','312','1',1,'Retail Sale Id 787',4003.20,0.00,0.00,5.56,611.60,'2023-03-08 16:31:50','',''),(785,'1','312','1',1,'Retail Sale Id 781',5040.00,0.00,0.00,7.00,770.00,'2023-03-08 16:42:04','',''),(786,'1','312','1',1,'Retail Sale Id 788',2160.00,0.00,0.00,3.00,330.00,'2023-03-08 16:46:45','',''),(787,'1','312','1',1,'Retail Sale Id 789',2880.00,0.00,0.00,4.00,440.00,'2023-03-08 16:50:20','',''),(788,'1','312','1',1,'Retail Sale Id 790',9000.00,0.00,0.00,12.50,1375.00,'2023-03-08 17:22:10','',''),(789,'1','312','1',1,'Retail Sale Id 791',2160.00,0.00,0.00,3.00,330.00,'2023-03-08 17:47:30','',''),(790,'1','312','1',1,'Retail Sale Id 792',2160.00,0.00,0.00,3.00,330.00,'2023-03-08 17:57:30','',''),(791,'1','312','1',1,'Return of Retail Sale Id 792',0.00,2160.00,3.00,0.00,-330.00,'2023-03-08 18:02:47','',''),(792,'1','312','1',1,'Retail Sale Id 793',11520.00,0.00,0.00,16.00,1760.00,'2023-03-08 18:05:39','',''),(793,'1','312','1',1,'Return of Retail Sale Id 774',0.00,20400.00,30.00,0.00,-2100.00,'2023-03-08 18:19:37','',''),(794,'1','312','1',1,'Retail Sale Id 794',205875.00,0.00,0.00,305.00,19825.00,'2023-03-08 18:20:38','',''),(795,'1','312','1',1,'Retail Sale Id 795',5313.60,0.00,0.00,7.38,811.80,'2023-03-08 18:34:37','',''),(796,'1','312','1',1,'Retail Sale Id 796',2901.60,0.00,0.00,4.03,443.30,'2023-03-09 07:55:54','',''),(797,'1','312','1',1,'Retail Sale Id 797',5040.00,0.00,0.00,7.00,770.00,'2023-03-09 08:23:06','',''),(798,'1','312','1',1,'Retail Sale Id 798',720.00,0.00,0.00,1.00,110.00,'2023-03-09 08:29:41','',''),(799,'1','312','1',1,'Return of Retail Sale Id 798',0.00,720.00,1.00,0.00,-110.00,'2023-03-09 08:33:25','',''),(800,'1','312','1',1,'Retail Sale Id 799',1000.80,0.00,0.00,1.39,152.90,'2023-03-09 08:34:05','',''),(801,'1','312','1',1,'Retail Sale Id 800',4348.80,0.00,0.00,6.04,664.40,'2023-03-09 09:31:14','',''),(802,'1','312','1',1,'Retail Sale Id 801',2160.00,0.00,0.00,3.00,330.00,'2023-03-09 10:07:19','',''),(803,'1','312','1',1,'Retail Sale Id 802',40800.00,0.00,0.00,60.00,4200.00,'2023-03-09 10:17:07','',''),(804,'1','312','1',1,'Retail Sale Id 803',9000.00,0.00,0.00,12.50,1375.00,'2023-03-09 12:43:05','',''),(805,'1','312','1',1,'Retail Sale Id 804',5040.00,0.00,0.00,7.00,770.00,'2023-03-09 12:44:19','',''),(806,'1','312','1',1,'Retail Sale Id 805',2160.00,0.00,0.00,3.00,330.00,'2023-03-09 13:07:23','',''),(807,'1','312','1',1,'Retail Sale Id 807',9000.00,0.00,0.00,12.50,1375.00,'2023-03-09 13:58:39','',''),(808,'1','312','1',1,'Retail Sale Id 808',3600.00,0.00,0.00,5.00,550.00,'2023-03-09 15:01:48','',''),(809,'1','312','1',1,'Retail Sale Id 809',3600.00,0.00,0.00,5.00,550.00,'2023-03-09 15:02:43','',''),(810,'1','312','1',1,'Retail Sale Id 810',4003.20,0.00,0.00,5.56,611.60,'2023-03-09 15:36:31','',''),(811,'1','312','1',1,'Retail Sale Id 811',9000.00,0.00,0.00,12.50,1375.00,'2023-03-09 15:37:33','',''),(812,'1','312','1',1,'Retail Sale Id 812',4320.00,0.00,0.00,6.00,660.00,'2023-03-09 16:13:47','',''),(813,'1','312','1',1,'Retail Sale Id 813',3600.00,0.00,0.00,5.00,550.00,'2023-03-09 16:29:25','',''),(814,'1','312','1',1,'Retail Sale Id 814',9000.00,0.00,0.00,12.50,1375.00,'2023-03-09 17:12:36','',''),(815,'1','312','1',1,'Retail Sale Id 815',5040.00,0.00,0.00,7.00,770.00,'2023-03-09 17:45:53','',''),(816,'1','312','1',1,'Retail Sale Id 816',3600.00,0.00,0.00,5.00,550.00,'2023-03-09 17:49:00','',''),(817,'1','312','1',1,'Retail Sale Id 817',14400.00,0.00,0.00,20.00,2200.00,'2023-03-09 17:55:36','',''),(818,'1','312','1',1,'Retail Sale Id 818',4320.00,0.00,0.00,6.00,660.00,'2023-03-09 18:07:06','',''),(819,'1','312','1',1,'Retail Sale Id 819',1440.00,0.00,0.00,2.00,220.00,'2023-03-09 18:23:30','',''),(820,'1','312','1',1,'Retail Sale Id 820',4320.00,0.00,0.00,6.00,660.00,'2023-03-09 18:28:32','',''),(821,'1','312','1',1,'Retail Sale Id 821',2880.00,0.00,0.00,4.00,440.00,'2023-03-10 07:39:26','',''),(822,'1','312','1',1,'Retail Sale Id 822',1440.00,0.00,0.00,2.00,220.00,'2023-03-10 07:40:58','',''),(823,'1','312','1',1,'Retail Sale Id 823',2160.00,0.00,0.00,3.00,330.00,'2023-03-10 07:58:15','',''),(824,'1','312','1',1,'Retail Sale Id 824',2160.00,0.00,0.00,3.00,330.00,'2023-03-10 08:00:23','',''),(825,'1','312','1',1,'Retail Sale Id 825',9000.00,0.00,0.00,12.50,1375.00,'2023-03-10 08:06:06','',''),(826,'1','312','1',1,'Retail Sale Id 826',6076.80,0.00,0.00,8.44,928.40,'2023-03-10 08:08:42','',''),(827,'1','312','1',1,'Retail Sale Id 827',9000.00,0.00,0.00,12.50,1375.00,'2023-03-10 08:27:58','',''),(828,'1','312','1',1,'Retail Sale Id 828',2880.00,0.00,0.00,4.00,440.00,'2023-03-10 08:45:50','',''),(829,'1','312','1',1,'Retail Sale Id 829',3600.00,0.00,0.00,5.00,550.00,'2023-03-10 08:48:22','',''),(830,'1','312','1',1,'Retail Sale Id 830',4320.00,0.00,0.00,6.00,660.00,'2023-03-10 08:52:14','',''),(831,'1','312','1',1,'Retail Sale Id 831',81600.00,0.00,0.00,120.00,8400.00,'2023-03-10 09:10:38','',''),(832,'1','312','1',1,'Retail Sale Id 832',9000.00,0.00,0.00,12.50,1375.00,'2023-03-10 09:39:24','',''),(833,'1','312','1',1,'Retail Sale Id 833',9000.00,0.00,0.00,12.50,1375.00,'2023-03-10 10:17:23','',''),(834,'1','312','1',1,'Retail Sale Id 835',2880.00,0.00,0.00,4.00,440.00,'2023-03-10 10:30:37','',''),(835,'1','312','1',1,'Retail Sale Id 836',9360.00,0.00,0.00,13.00,1430.00,'2023-03-10 10:43:36','',''),(836,'1','312','1',1,'Retail Sale Id 837',5040.00,0.00,0.00,7.00,770.00,'2023-03-10 12:01:09','',''),(837,'1','312','1',1,'Retail Sale Id 838',9000.00,0.00,0.00,12.50,1375.00,'2023-03-10 12:03:17','',''),(838,'1','312','1',1,'Retail Sale Id 839',3600.00,0.00,0.00,5.00,550.00,'2023-03-10 12:22:05','',''),(839,'1','312','1',1,'Retail Sale Id 840',2880.00,0.00,0.00,4.00,440.00,'2023-03-10 13:03:41','',''),(840,'1','312','1',1,'Retail Sale Id 841',5040.00,0.00,0.00,7.00,770.00,'2023-03-10 13:19:07','',''),(841,'1','312','1',1,'Retail Sale Id 842',25200.00,0.00,0.00,35.00,3850.00,'2023-03-10 13:34:52','',''),(842,'1','312','1',1,'Retail Sale Id 843',5040.00,0.00,0.00,7.00,770.00,'2023-03-10 13:53:30','',''),(843,'1','312','1',1,'Retail Sale Id 844',5040.00,0.00,0.00,7.00,770.00,'2023-03-10 14:14:39','',''),(844,'1','312','1',1,'Retail Sale Id 845',2880.00,0.00,0.00,4.00,440.00,'2023-03-10 14:17:26','',''),(845,'1','312','1',1,'Retail Sale Id 846',3002.40,0.00,0.00,4.17,458.70,'2023-03-10 14:44:09','',''),(846,'1','312','1',1,'Retail Sale Id 847',9000.00,0.00,0.00,12.50,1375.00,'2023-03-10 15:34:07','',''),(847,'1','312','1',1,'Retail Sale Id 848',9000.00,0.00,0.00,12.50,1375.00,'2023-03-10 15:41:13','',''),(848,'1','312','1',1,'Retail Sale Id 849',2160.00,0.00,0.00,3.00,330.00,'2023-03-10 15:45:13','',''),(849,'1','312','1',1,'Retail Sale Id 850',3002.40,0.00,0.00,4.17,458.70,'2023-03-10 15:53:58','',''),(850,'1','312','1',1,'Retail Sale Id 851',4320.00,0.00,0.00,6.00,660.00,'2023-03-10 15:56:53','',''),(851,'1','312','1',1,'Retail Sale Id 852',2160.00,0.00,0.00,3.00,330.00,'2023-03-10 16:09:42','',''),(852,'1','312','1',1,'Retail Sale Id 853',2160.00,0.00,0.00,3.00,330.00,'2023-03-10 16:34:36','',''),(853,'1','312','1',1,'Retail Sale Id 854',5040.00,0.00,0.00,7.00,770.00,'2023-03-10 16:44:56','',''),(854,'1','312','1',1,'Retail Sale Id 855',4320.00,0.00,0.00,6.00,660.00,'2023-03-10 17:21:55','',''),(855,'1','312','1',1,'Retail Sale Id 856',4348.80,0.00,0.00,6.04,664.40,'2023-03-10 17:29:18','',''),(856,'1','312','1',1,'Retail Sale Id 857',2160.00,0.00,0.00,3.00,330.00,'2023-03-10 17:30:37','',''),(857,'1','312','1',1,'Retail Sale Id 858',3600.00,0.00,0.00,5.00,550.00,'2023-03-10 17:54:13','',''),(858,'1','312','1',1,'Retail Sale Id 859',2001.60,0.00,0.00,2.78,305.80,'2023-03-10 18:15:12','',''),(859,'1','312','1',1,'Retail Sale Id 860',3600.00,0.00,0.00,5.00,550.00,'2023-03-10 18:28:18','',''),(860,'1','312','1',1,'Retail Sale Id 861',4003.20,0.00,0.00,5.56,611.60,'2023-03-10 18:45:42','',''),(861,'1','312','1',1,'Return of Retail Sale Id 831',0.00,81600.00,120.00,0.00,-8400.00,'2023-03-10 19:04:00','',''),(862,'1','312','1',1,'Retail Sale Id 862',81022.00,0.00,0.00,119.15,8340.50,'2023-03-10 19:04:47','',''),(863,'1','312','1',1,'Retail Sale Id 863',4320.00,0.00,0.00,6.00,660.00,'2023-03-11 07:57:08','',''),(864,'1','312','1',1,'Retail Sale Id 864',5040.00,0.00,0.00,7.00,770.00,'2023-03-11 08:07:29','',''),(865,'1','312','1',1,'Retail Sale Id 865',9000.00,0.00,0.00,12.50,1375.00,'2023-03-11 08:25:13','',''),(866,'1','312','1',1,'Retail Sale Id 866',4320.00,0.00,0.00,6.00,660.00,'2023-03-11 08:45:57','',''),(867,'1','312','1',1,'Retail Sale Id 867',14040.00,0.00,0.00,19.50,2145.00,'2023-03-11 09:16:09','',''),(868,'1','312','1',1,'Retail Sale Id 868',10800.00,0.00,0.00,15.00,1650.00,'2023-03-11 09:20:09','',''),(869,'1','312','1',1,'Retail Sale Id 869',2880.00,0.00,0.00,4.00,440.00,'2023-03-11 09:22:44','',''),(870,'1','312','1',1,'Retail Sale Id 870',2160.00,0.00,0.00,3.00,330.00,'2023-03-11 09:45:58','',''),(871,'1','312','1',1,'Retail Sale Id 871',1440.00,0.00,0.00,2.00,220.00,'2023-03-11 09:47:49','',''),(872,'1','312','1',1,'Retail Sale Id 872',720.00,0.00,0.00,1.00,110.00,'2023-03-11 09:52:24','',''),(873,'1','312','1',1,'Retail Sale Id 873',9000.00,0.00,0.00,12.50,1375.00,'2023-03-11 10:05:27','',''),(874,'1','312','1',1,'Retail Sale Id 874',2001.60,0.00,0.00,2.78,305.80,'2023-03-11 10:07:14','',''),(875,'1','312','1',1,'Retail Sale Id 875',1440.00,0.00,0.00,2.00,220.00,'2023-03-11 10:19:37','',''),(876,'1','312','1',1,'Retail Sale Id 876',10800.00,0.00,0.00,15.00,1650.00,'2023-03-11 10:22:42','',''),(877,'1','312','1',1,'Retail Sale Id 877',2901.60,0.00,0.00,4.03,443.30,'2023-03-11 10:36:41','',''),(878,'1','312','1',1,'Retail Sale Id 878',5040.00,0.00,0.00,7.00,770.00,'2023-03-11 11:05:17','',''),(879,'1','312','1',1,'Retail Sale Id 879',3600.00,0.00,0.00,5.00,550.00,'2023-03-11 11:07:47','',''),(880,'1','312','1',1,'Retail Sale Id 880',3600.00,0.00,0.00,5.00,550.00,'2023-03-11 11:14:21','',''),(881,'1','312','1',1,'Retail Sale Id 881',3600.00,0.00,0.00,5.00,550.00,'2023-03-11 12:23:22','',''),(882,'1','312','1',1,'Retail Sale Id 882',5040.00,0.00,0.00,7.00,770.00,'2023-03-11 12:24:27','',''),(883,'1','312','1',1,'Retail Sale Id 883',3002.40,0.00,0.00,4.17,458.70,'2023-03-11 12:55:42','',''),(884,'1','312','1',1,'Retail Sale Id 884',6480.00,0.00,0.00,9.00,990.00,'2023-03-11 13:21:20','',''),(885,'1','312','1',1,'Retail Sale Id 885',9000.00,0.00,0.00,12.50,1375.00,'2023-03-11 13:28:04','',''),(886,'1','312','1',1,'Retail Sale Id 886',3600.00,0.00,0.00,5.00,550.00,'2023-03-11 13:29:49','',''),(887,'1','312','1',1,'Retail Sale Id 887',7200.00,0.00,0.00,10.00,1100.00,'2023-03-11 13:57:00','',''),(888,'1','312','1',1,'Retail Sale Id 888',1000.80,0.00,0.00,1.39,152.90,'2023-03-11 14:01:24','',''),(889,'1','312','1',1,'Retail Sale Id 889',5040.00,0.00,0.00,7.00,770.00,'2023-03-11 14:08:23','',''),(890,'1','312','1',1,'Retail Sale Id 891',12110.40,0.00,0.00,16.82,1850.20,'2023-03-11 14:38:44','',''),(891,'1','312','1',1,'Retail Sale Id 893',1440.00,0.00,0.00,2.00,220.00,'2023-03-11 14:46:18','',''),(892,'1','312','1',1,'Retail Sale Id 894',4996.80,0.00,0.00,6.94,763.40,'2023-03-11 15:07:20','',''),(893,'1','312','1',1,'Retail Sale Id 895',38880.00,0.00,0.00,54.00,5940.00,'2023-03-11 15:20:35','',''),(894,'1','312','1',1,'Retail Sale Id 896',18000.00,0.00,0.00,25.00,2750.00,'2023-03-11 15:30:00','',''),(895,'1','312','1',1,'Retail Sale Id 897',5040.00,0.00,0.00,7.00,770.00,'2023-03-11 15:39:20','',''),(896,'1','312','1',1,'Retail Sale Id 898',40800.00,0.00,0.00,60.00,4200.00,'2023-03-11 15:44:41','',''),(897,'1','312','1',1,'Retail Sale Id 899',2520.00,0.00,0.00,3.50,385.00,'2023-03-11 15:48:42','',''),(898,'1','312','1',1,'Retail Sale Id 900',9000.00,0.00,0.00,12.50,1375.00,'2023-03-11 15:55:22','',''),(899,'1','312','1',1,'Retail Sale Id 901',1000.80,0.00,0.00,1.39,152.90,'2023-03-11 15:56:30','',''),(900,'1','312','1',1,'Retail Sale Id 902',2880.00,0.00,0.00,4.00,440.00,'2023-03-11 16:13:02','',''),(901,'1','312','1',1,'Retail Sale Id 903',4320.00,0.00,0.00,6.00,660.00,'2023-03-11 16:26:30','',''),(902,'1','312','1',1,'Retail Sale Id 904',3600.00,0.00,0.00,5.00,550.00,'2023-03-11 16:49:06','',''),(903,'1','312','1',1,'Retail Sale Id 905',2001.60,0.00,0.00,2.78,305.80,'2023-03-11 16:55:35','',''),(904,'1','312','1',1,'Retail Sale Id 906',3600.00,0.00,0.00,5.00,550.00,'2023-03-11 16:57:47','',''),(905,'1','312','1',1,'Retail Sale Id 908',7200.00,0.00,0.00,10.00,1100.00,'2023-03-11 17:00:28','',''),(906,'1','312','1',1,'Retail Sale Id 909',2160.00,0.00,0.00,3.00,330.00,'2023-03-11 17:15:39','',''),(907,'1','312','1',1,'Retail Sale Id 910',5040.00,0.00,0.00,7.00,770.00,'2023-03-11 17:20:32','',''),(908,'1','312','1',1,'Retail Sale Id 911',5040.00,0.00,0.00,7.00,770.00,'2023-03-11 17:23:55','',''),(909,'1','312','1',1,'Retail Sale Id 912',2880.00,0.00,0.00,4.00,440.00,'2023-03-11 17:26:15','',''),(910,'1','312','1',1,'Retail Sale Id 913',2160.00,0.00,0.00,3.00,330.00,'2023-03-11 17:42:59','',''),(911,'1','312','1',1,'Retail Sale Id 914',1440.00,0.00,0.00,2.00,220.00,'2023-03-11 18:07:15','',''),(912,'1','312','1',1,'Return of Retail Sale Id 898',0.00,40800.00,60.00,0.00,-4200.00,'2023-03-11 18:40:09','',''),(913,'1','312','1',1,'Retail Sale Id 915',40657.20,0.00,0.00,59.79,4185.30,'2023-03-11 18:41:18','',''),(914,'1','312','1',1,'Return of Retail Sale Id 903',0.00,4320.00,6.00,0.00,-660.00,'2023-03-11 18:57:17','',''),(915,'1','312','1',1,'Retail Sale Id 916',3945.60,0.00,0.00,5.48,602.80,'2023-03-11 18:59:40','',''),(916,'1','312','1',1,'Retail Sale Id 917',1440.00,0.00,0.00,2.00,220.00,'2023-03-12 07:40:04','',''),(917,'1','312','1',1,'Retail Sale Id 918',4320.00,0.00,0.00,6.00,660.00,'2023-03-12 07:41:42','',''),(918,'1','312','1',1,'Retail Sale Id 919',5040.00,0.00,0.00,7.00,770.00,'2023-03-12 07:53:54','',''),(919,'1','312','1',1,'Retail Sale Id 920',2296.80,0.00,0.00,3.19,350.90,'2023-03-12 08:13:16','',''),(920,'1','312','1',1,'Retail Sale Id 921',3960.00,0.00,0.00,5.50,605.00,'2023-03-12 08:18:39','',''),(921,'1','312','1',1,'Retail Sale Id 922',5040.00,0.00,0.00,7.00,770.00,'2023-03-12 08:20:24','',''),(922,'1','312','1',1,'Retail Sale Id 923',4320.00,0.00,0.00,6.00,660.00,'2023-03-12 08:52:54','',''),(923,'1','312','1',1,'Retail Sale Id 926',2160.00,0.00,0.00,3.00,330.00,'2023-03-12 09:46:33','',''),(924,'1','312','1',1,'Retail Sale Id 927',3600.00,0.00,0.00,5.00,550.00,'2023-03-12 09:47:40','',''),(925,'1','312','1',1,'Retail Sale Id 928',9000.00,0.00,0.00,12.50,1375.00,'2023-03-12 09:48:46','',''),(926,'1','312','1',1,'Retail Sale Id 929',1440.00,0.00,0.00,2.00,220.00,'2023-03-12 09:51:22','',''),(927,'1','312','1',1,'Retail Sale Id 930',2160.00,0.00,0.00,3.00,330.00,'2023-03-12 09:55:55','',''),(928,'1','312','1',1,'Retail Sale Id 931',799.20,0.00,0.00,1.11,122.10,'2023-03-12 10:20:06','',''),(929,'1','312','1',1,'Retail Sale Id 932',2160.00,0.00,0.00,3.00,330.00,'2023-03-12 10:43:40','',''),(930,'1','312','1',1,'Retail Sale Id 933',2880.00,0.00,0.00,4.00,440.00,'2023-03-12 10:53:34','',''),(931,'1','312','1',1,'Retail Sale Id 934',39440.00,0.00,0.00,58.00,4060.00,'2023-03-12 11:15:47','',''),(932,'1','312','1',1,'Retail Sale Id 936',10800.00,0.00,0.00,15.00,1650.00,'2023-03-12 11:44:28','',''),(933,'1','312','1',1,'Retail Sale Id 937',4003.20,0.00,0.00,5.56,611.60,'2023-03-12 12:37:51','',''),(934,'1','312','1',1,'Retail Sale Id 938',1440.00,0.00,0.00,2.00,220.00,'2023-03-12 12:44:17','',''),(935,'1','312','1',1,'Retail Sale Id 939',9000.00,0.00,0.00,12.50,1375.00,'2023-03-12 12:52:32','',''),(936,'1','312','1',1,'Retail Sale Id 940',9000.00,0.00,0.00,12.50,1375.00,'2023-03-12 13:10:25','',''),(937,'1','312','1',1,'Retail Sale Id 941',7200.00,0.00,0.00,10.00,1100.00,'2023-03-12 13:14:55','',''),(938,'1','312','1',1,'Retail Sale Id 942',9000.00,0.00,0.00,12.50,1375.00,'2023-03-12 14:03:30','',''),(939,'1','312','1',1,'Retail Sale Id 943',36000.00,0.00,0.00,50.00,5500.00,'2023-03-12 14:24:37','',''),(940,'1','312','1',1,'Retail Sale Id 944',4996.80,0.00,0.00,6.94,763.40,'2023-03-12 14:43:56','',''),(941,'1','312','1',1,'Retail Sale Id 945',2498.40,0.00,0.00,3.47,381.70,'2023-03-12 14:46:34','',''),(942,'1','312','1',1,'Retail Sale Id 946',4320.00,0.00,0.00,6.00,660.00,'2023-03-12 14:50:02','',''),(943,'1','312','1',1,'Retail Sale Id 947',2160.00,0.00,0.00,3.00,330.00,'2023-03-12 15:02:49','',''),(944,'1','312','1',1,'Retail Sale Id 948',5040.00,0.00,0.00,7.00,770.00,'2023-03-12 15:15:28','',''),(945,'1','312','1',1,'Retail Sale Id 949',4003.20,0.00,0.00,5.56,611.60,'2023-03-12 15:54:00','',''),(946,'1','312','1',1,'Retail Sale Id 950',9000.00,0.00,0.00,12.50,1375.00,'2023-03-12 16:02:56','',''),(947,'1','312','1',1,'Retail Sale Id 951',9000.00,0.00,0.00,12.50,1375.00,'2023-03-12 16:16:02','',''),(948,'1','312','1',1,'Retail Sale Id 952',3600.00,0.00,0.00,5.00,550.00,'2023-03-12 16:19:24','',''),(949,'1','312','1',1,'Retail Sale Id 953',2160.00,0.00,0.00,3.00,330.00,'2023-03-12 16:22:03','',''),(950,'1','312','1',1,'Retail Sale Id 954',2160.00,0.00,0.00,3.00,330.00,'2023-03-12 16:38:31','',''),(951,'1','312','1',1,'Retail Sale Id 955',37400.00,0.00,0.00,55.00,3850.00,'2023-03-12 16:51:01','',''),(952,'1','312','1',1,'Retail Sale Id 956',2160.00,0.00,0.00,3.00,330.00,'2023-03-12 16:55:19','',''),(953,'1','312','1',1,'Retail Sale Id 957',2001.60,0.00,0.00,2.78,305.80,'2023-03-12 16:59:42','',''),(954,'1','312','1',1,'Retail Sale Id 958',5040.00,0.00,0.00,7.00,770.00,'2023-03-12 17:18:28','',''),(955,'1','312','1',1,'Retail Sale Id 959',4003.20,0.00,0.00,5.56,611.60,'2023-03-12 17:22:56','',''),(956,'1','312','1',1,'Retail Sale Id 960',3600.00,0.00,0.00,5.00,550.00,'2023-03-12 17:29:14','',''),(957,'1','312','1',1,'Retail Sale Id 961',9000.00,0.00,0.00,12.50,1375.00,'2023-03-12 17:33:12','',''),(958,'1','312','1',1,'Retail Sale Id 962',9000.00,0.00,0.00,12.50,1375.00,'2023-03-12 17:35:16','',''),(959,'1','312','1',1,'Retail Sale Id 963',3600.00,0.00,0.00,5.00,550.00,'2023-03-12 17:39:39','',''),(960,'1','312','1',1,'Retail Sale Id 964',5040.00,0.00,0.00,7.00,770.00,'2023-03-12 18:03:22','',''),(961,'1','312','1',1,'Retail Sale Id 965',4320.00,0.00,0.00,6.00,660.00,'2023-03-12 18:15:59','',''),(962,'1','312','1',1,'Retail Sale Id 966',4320.00,0.00,0.00,6.00,660.00,'2023-03-12 18:26:07','',''),(963,'1','312','1',1,'Retail Sale Id 967',67211.20,0.00,0.00,98.84,6918.80,'2023-03-12 18:34:31','',''),(964,'1','312','1',1,'Retail Sale Id 968',720.00,0.00,0.00,1.00,110.00,'2023-03-12 18:36:25','',''),(965,'1','312','1',1,'Retail Sale Id 969',4320.00,0.00,0.00,6.00,660.00,'2023-03-14 07:38:11','',''),(966,'1','312','1',1,'Retail Sale Id 970',9000.00,0.00,0.00,12.50,1375.00,'2023-03-14 07:39:22','',''),(967,'1','312','1',1,'Retail Sale Id 971',12240.00,0.00,0.00,17.00,1870.00,'2023-03-14 07:44:38','',''),(968,'1','312','1',1,'Retail Sale Id 972',4320.00,0.00,0.00,6.00,660.00,'2023-03-14 07:47:11','',''),(969,'1','312','1',1,'Retail Sale Id 973',9000.00,0.00,0.00,12.50,1375.00,'2023-03-14 07:53:04','',''),(970,'1','312','1',1,'Retail Sale Id 974',7200.00,0.00,0.00,10.00,1100.00,'2023-03-14 08:12:56','',''),(971,'1','312','1',1,'Retail Sale Id 975',4320.00,0.00,0.00,6.00,660.00,'2023-03-14 08:29:08','',''),(972,'1','312','1',1,'Retail Sale Id 976',13320.00,0.00,0.00,18.50,2035.00,'2023-03-14 08:40:39','',''),(973,'1','312','1',1,'Retail Sale Id 978',23760.00,0.00,0.00,33.00,3630.00,'2023-03-14 08:52:59','',''),(974,'1','312','1',1,'Retail Sale Id 979',3600.00,0.00,0.00,5.00,550.00,'2023-03-14 08:55:19','',''),(975,'1','312','1',1,'Retail Sale Id 980',9000.00,0.00,0.00,12.50,1375.00,'2023-03-14 08:56:45','',''),(976,'1','312','1',1,'Retail Sale Id 981',9000.00,0.00,0.00,12.50,1375.00,'2023-03-14 09:38:42','',''),(977,'1','312','1',1,'Retail Sale Id 982',9000.00,0.00,0.00,12.50,1375.00,'2023-03-14 09:54:57','',''),(978,'1','312','1',1,'Retail Sale Id 983',3002.40,0.00,0.00,4.17,458.70,'2023-03-14 10:25:13','',''),(979,'1','312','1',1,'Retail Sale Id 984',2203.20,0.00,0.00,3.06,336.60,'2023-03-14 11:16:59','',''),(980,'1','312','1',1,'Retail Sale Id 985',2160.00,0.00,0.00,3.00,330.00,'2023-03-14 11:18:54','',''),(981,'1','312','1',1,'Retail Sale Id 986',12240.00,0.00,0.00,17.00,1870.00,'2023-03-14 11:38:57','',''),(982,'1','312','1',1,'Retail Sale Id 987',8640.00,0.00,0.00,12.00,1320.00,'2023-03-14 12:03:12','',''),(983,'1','312','1',1,'Retail Sale Id 988',720.00,0.00,0.00,1.00,110.00,'2023-03-14 13:17:27','',''),(984,'1','312','1',1,'Retail Sale Id 989',1440.00,0.00,0.00,2.00,220.00,'2023-03-14 13:38:20','',''),(985,'1','312','1',1,'Retail Sale Id 990',5040.00,0.00,0.00,7.00,770.00,'2023-03-14 15:22:41','',''),(986,'1','312','1',1,'Retail Sale Id 991',4500.00,0.00,0.00,6.25,687.50,'2023-03-14 15:35:41','',''),(987,'1','312','1',1,'Retail Sale Id 992',9000.00,0.00,0.00,12.50,1375.00,'2023-03-14 15:37:17','',''),(988,'1','312','1',1,'Retail Sale Id 993',3600.00,0.00,0.00,5.00,550.00,'2023-03-14 15:48:51','',''),(989,'1','312','1',1,'Retail Sale Id 994',2880.00,0.00,0.00,4.00,440.00,'2023-03-14 16:51:03','',''),(990,'1','312','1',1,'Retail Sale Id 995',2160.00,0.00,0.00,3.00,330.00,'2023-03-14 17:02:50','',''),(991,'1','312','1',1,'Retail Sale Id 996',5760.00,0.00,0.00,8.00,880.00,'2023-03-14 17:14:02','',''),(992,'1','312','1',1,'Retail Sale Id 998',3600.00,0.00,0.00,5.00,550.00,'2023-03-14 17:19:59','',''),(993,'1','312','1',1,'Retail Sale Id 999',98600.00,0.00,0.00,145.00,10150.00,'2023-03-14 17:23:18','',''),(994,'1','312','1',1,'Retail Sale Id 1001',2160.00,0.00,0.00,3.00,330.00,'2023-03-14 17:38:36','',''),(995,'1','312','1',1,'Retail Sale Id 1002',5040.00,0.00,0.00,7.00,770.00,'2023-03-14 17:45:32','',''),(996,'1','312','1',1,'Retail Sale Id 1003',9000.00,0.00,0.00,12.50,1375.00,'2023-03-14 18:15:26','',''),(997,'1','312','1',1,'Retail Sale Id 1004',3600.00,0.00,0.00,5.00,550.00,'2023-03-14 18:45:35','',''),(998,'1','312','1',1,'Retail Sale Id 1005',1440.00,0.00,0.00,2.00,220.00,'2023-03-14 19:10:42','',''),(999,'1','312','1',1,'Retail Sale Id 1006',4320.00,0.00,0.00,6.00,660.00,'2023-03-15 08:05:02','',''),(1000,'1','312','1',1,'Retail Sale Id 1008',4320.00,0.00,0.00,6.00,660.00,'2023-03-15 08:22:33','',''),(1001,'1','312','1',1,'Retail Sale Id 1009',7200.00,0.00,0.00,10.00,1100.00,'2023-03-15 08:25:04','',''),(1002,'1','312','1',1,'Retail Sale Id 1010',9000.00,0.00,0.00,12.50,1375.00,'2023-03-15 08:52:24','',''),(1003,'1','312','1',1,'Retail Sale Id 1011',2880.00,0.00,0.00,4.00,440.00,'2023-03-15 08:55:33','',''),(1004,'1','312','1',1,'Retail Sale Id 1012',2160.00,0.00,0.00,3.00,330.00,'2023-03-15 08:58:50','',''),(1005,'1','312','1',1,'Retail Sale Id 1013',2203.20,0.00,0.00,3.06,336.60,'2023-03-15 09:07:37','',''),(1006,'1','312','1',1,'Retail Sale Id 1014',2880.00,0.00,0.00,4.00,440.00,'2023-03-15 09:28:21','',''),(1007,'1','312','1',1,'Retail Sale Id 1015',4320.00,0.00,0.00,6.00,660.00,'2023-03-15 09:39:02','',''),(1008,'1','312','1',1,'Retail Sale Id 1016',3240.00,0.00,0.00,4.50,495.00,'2023-03-15 10:09:48','',''),(1009,'1','312','1',1,'Retail Sale Id 1017',4320.00,0.00,0.00,6.00,660.00,'2023-03-15 10:11:37','',''),(1010,'1','312','1',1,'Retail Sale Id 1018',2160.00,0.00,0.00,3.00,330.00,'2023-03-15 10:38:54','',''),(1011,'1','312','1',1,'Retail Sale Id 1019',10800.00,0.00,0.00,15.00,1650.00,'2023-03-15 10:41:00','',''),(1012,'1','312','1',1,'Retail Sale Id 1020',2880.00,0.00,0.00,4.00,440.00,'2023-03-15 11:46:07','',''),(1013,'1','312','1',1,'Retail Sale Id 1021',9000.00,0.00,0.00,12.50,1375.00,'2023-03-15 12:23:41','',''),(1014,'1','312','1',1,'Retail Sale Id 1022',10440.00,0.00,0.00,14.50,1595.00,'2023-03-15 12:57:45','',''),(1015,'1','312','1',1,'Retail Sale Id 1023',1440.00,0.00,0.00,2.00,220.00,'2023-03-15 13:07:33','',''),(1016,'1','312','1',1,'Retail Sale Id 1024',9000.00,0.00,0.00,12.50,1375.00,'2023-03-15 14:32:02','',''),(1017,'1','312','1',1,'Retail Sale Id 1025',1497.60,0.00,0.00,2.08,228.80,'2023-03-15 14:53:48','',''),(1018,'1','312','1',1,'Retail Sale Id 1026',3600.00,0.00,0.00,5.00,550.00,'2023-03-15 15:35:49','',''),(1019,'1','312','1',1,'Retail Sale Id 1027',7200.00,0.00,0.00,10.00,1100.00,'2023-03-15 15:38:31','',''),(1020,'1','312','1',1,'Retail Sale Id 1028',10080.00,0.00,0.00,14.00,1540.00,'2023-03-15 15:40:22','',''),(1021,'1','312','1',1,'Retail Sale Id 1029',2160.00,0.00,0.00,3.00,330.00,'2023-03-15 15:42:51','',''),(1022,'1','312','1',1,'Retail Sale Id 1030',2880.00,0.00,0.00,4.00,440.00,'2023-03-15 15:49:52','',''),(1023,'1','312','1',1,'Retail Sale Id 1031',5040.00,0.00,0.00,7.00,770.00,'2023-03-15 16:03:41','',''),(1024,'1','312','1',1,'Retail Sale Id 1032',3600.00,0.00,0.00,5.00,550.00,'2023-03-15 16:09:54','',''),(1025,'1','312','1',1,'Retail Sale Id 1033',4320.00,0.00,0.00,6.00,660.00,'2023-03-15 16:20:23','',''),(1026,'1','312','1',1,'Retail Sale Id 1034',1440.00,0.00,0.00,2.00,220.00,'2023-03-15 16:22:46','',''),(1027,'1','312','1',1,'Retail Sale Id 1035',2160.00,0.00,0.00,3.00,330.00,'2023-03-15 16:48:05','',''),(1028,'1','312','1',1,'Retail Sale Id 1036',1447.20,0.00,0.00,2.01,221.10,'2023-03-15 17:18:13','',''),(1029,'1','312','1',1,'Retail Sale Id 1037',4320.00,0.00,0.00,6.00,660.00,'2023-03-16 08:01:25','',''),(1030,'1','312','1',1,'Retail Sale Id 1038',7200.00,0.00,0.00,10.00,1100.00,'2023-03-16 08:03:26','',''),(1031,'1','312','1',1,'Retail Sale Id 1039',9000.00,0.00,0.00,12.50,1375.00,'2023-03-16 08:29:46','',''),(1032,'1','312','1',1,'Retail Sale Id 1040',1440.00,0.00,0.00,2.00,220.00,'2023-03-16 08:48:34','',''),(1033,'1','312','1',1,'Retail Sale Id 1041',2160.00,0.00,0.00,3.00,330.00,'2023-03-16 08:57:55','',''),(1034,'1','312','1',1,'Retail Sale Id 1042',7200.00,0.00,0.00,10.00,1100.00,'2023-03-16 09:00:49','',''),(1035,'1','312','1',1,'Retail Sale Id 1043',4003.20,0.00,0.00,5.56,611.60,'2023-03-16 09:03:49','',''),(1036,'1','312','1',1,'Retail Sale Id 1044',4320.00,0.00,0.00,6.00,660.00,'2023-03-16 09:14:47','',''),(1037,'1','312','1',1,'Retail Sale Id 1045',4320.00,0.00,0.00,6.00,660.00,'2023-03-16 09:27:41','',''),(1038,'1','312','1',1,'Retail Sale Id 1046',3600.00,0.00,0.00,5.00,550.00,'2023-03-16 10:21:52','',''),(1039,'1','312','1',1,'Retail Sale Id 1047',7200.00,0.00,0.00,10.00,1100.00,'2023-03-16 10:45:06','',''),(1040,'1','312','1',1,'Retail Sale Id 1048',21600.00,0.00,0.00,30.00,3300.00,'2023-03-16 10:55:40','',''),(1041,'1','312','1',1,'Retail Sale Id 1049',2160.00,0.00,0.00,3.00,330.00,'2023-03-16 11:27:44','',''),(1042,'1','312','1',1,'Retail Sale Id 1050',3600.00,0.00,0.00,5.00,550.00,'2023-03-16 11:38:18','',''),(1043,'1','312','1',1,'Retail Sale Id 1051',6480.00,0.00,0.00,9.00,990.00,'2023-03-16 11:51:41','',''),(1044,'1','312','1',1,'Retail Sale Id 1052',3600.00,0.00,0.00,5.00,550.00,'2023-03-16 12:00:33','',''),(1045,'1','312','1',1,'Retail Sale Id 1053',1440.00,0.00,0.00,2.00,220.00,'2023-03-16 12:03:36','',''),(1046,'1','312','1',1,'Retail Sale Id 1054',3600.00,0.00,0.00,5.00,550.00,'2023-03-16 12:05:44','',''),(1047,'1','312','1',1,'Return of Retail Sale Id 1053',0.00,1440.00,2.00,0.00,-220.00,'2023-03-16 13:13:42','',''),(1048,'1','312','1',1,'Retail Sale Id 1055',9000.00,0.00,0.00,12.50,1375.00,'2023-03-16 13:14:52','',''),(1049,'1','312','1',1,'Retail Sale Id 1056',1440.00,0.00,0.00,2.00,220.00,'2023-03-16 13:16:23','',''),(1050,'1','312','1',1,'Retail Sale Id 1057',9000.00,0.00,0.00,12.50,1375.00,'2023-03-16 13:34:05','',''),(1051,'1','312','1',1,'Retail Sale Id 1058',7920.00,0.00,0.00,11.00,1210.00,'2023-03-16 14:16:44','',''),(1052,'1','312','1',1,'Retail Sale Id 1059',4320.00,0.00,0.00,6.00,660.00,'2023-03-16 14:18:22','',''),(1053,'1','312','1',1,'Retail Sale Id 1060',2880.00,0.00,0.00,4.00,440.00,'2023-03-16 15:52:58','',''),(1054,'1','312','1',1,'Retail Sale Id 1061',9000.00,0.00,0.00,12.50,1375.00,'2023-03-16 15:54:07','',''),(1055,'1','312','1',1,'Retail Sale Id 1062',8640.00,0.00,0.00,12.00,1320.00,'2023-03-16 15:55:55','',''),(1056,'1','312','1',1,'Retail Sale Id 1063',10800.00,0.00,0.00,15.00,1650.00,'2023-03-16 15:57:23','',''),(1057,'1','312','1',1,'Retail Sale Id 1064',9000.00,0.00,0.00,12.50,1375.00,'2023-03-16 15:58:34','',''),(1058,'1','312','1',1,'Retail Sale Id 1065',2296.80,0.00,0.00,3.19,350.90,'2023-03-16 16:01:41','',''),(1059,'1','312','1',1,'Retail Sale Id 1066',5760.00,0.00,0.00,8.00,880.00,'2023-03-16 16:38:29','',''),(1060,'1','312','1',1,'Retail Sale Id 1067',1440.00,0.00,0.00,2.00,220.00,'2023-03-16 16:39:55','',''),(1061,'1','312','1',1,'Retail Sale Id 1068',6480.00,0.00,0.00,9.00,990.00,'2023-03-16 16:55:37','',''),(1062,'1','312','1',1,'Retail Sale Id 1069',2160.00,0.00,0.00,3.00,330.00,'2023-03-16 16:58:33','',''),(1063,'1','312','1',1,'Retail Sale Id 1070',7200.00,0.00,0.00,10.00,1100.00,'2023-03-16 17:10:36','',''),(1064,'1','312','1',1,'Retail Sale Id 1071',3600.00,0.00,0.00,5.00,550.00,'2023-03-16 17:23:20','',''),(1065,'1','312','1',1,'Retail Sale Id 1072',2880.00,0.00,0.00,4.00,440.00,'2023-03-16 17:56:33','',''),(1066,'1','312','1',1,'Retail Sale Id 1074',1440.00,0.00,0.00,2.00,220.00,'2023-03-16 18:04:06','',''),(1067,'1','312','1',1,'Retail Sale Id 1075',2001.60,0.00,0.00,2.78,305.80,'2023-03-16 18:45:50','',''),(1068,'1','312','1',1,'Retail Sale Id 1076',1440.00,0.00,0.00,2.00,220.00,'2023-03-16 18:47:20','',''),(1069,'1','312','1',1,'Retail Sale Id 1077',2160.00,0.00,0.00,3.00,330.00,'2023-03-16 18:48:26','',''),(1070,'1','312','1',1,'Return of Retail Sale Id 1076',0.00,1440.00,2.00,0.00,-220.00,'2023-03-16 19:06:54','',''),(1071,'1','312','1',1,'Retail Sale Id 1078',1944.00,0.00,0.00,2.70,297.00,'2023-03-16 19:08:51','',''),(1072,'1','312','1',1,'Retail Sale Id 1079',2880.00,0.00,0.00,4.00,440.00,'2023-03-17 07:27:52','',''),(1073,'1','312','1',1,'Retail Sale Id 1080',2160.00,0.00,0.00,3.00,330.00,'2023-03-17 07:30:51','',''),(1074,'1','312','1',1,'Retail Sale Id 1081',4320.00,0.00,0.00,6.00,660.00,'2023-03-17 08:02:49','',''),(1075,'1','312','1',1,'Retail Sale Id 1082',2160.00,0.00,0.00,3.00,330.00,'2023-03-17 08:28:27','',''),(1076,'1','312','1',1,'Retail Sale Id 1083',5997.60,0.00,0.00,8.33,916.30,'2023-03-17 08:36:38','',''),(1077,'1','312','1',1,'Retail Sale Id 1084',7200.00,0.00,0.00,10.00,1100.00,'2023-03-17 08:39:58','',''),(1078,'1','312','1',1,'Retail Sale Id 1086',1497.60,0.00,0.00,2.08,228.80,'2023-03-17 09:02:45','',''),(1079,'1','312','1',1,'Retail Sale Id 1087',4348.80,0.00,0.00,6.04,664.40,'2023-03-17 09:04:33','',''),(1080,'1','312','1',1,'Retail Sale Id 1088',4320.00,0.00,0.00,6.00,660.00,'2023-03-17 09:16:58','',''),(1081,'1','312','1',1,'Retail Sale Id 1089',7200.00,0.00,0.00,10.00,1100.00,'2023-03-17 09:19:59','',''),(1082,'1','312','1',1,'Retail Sale Id 1090',4320.00,0.00,0.00,6.00,660.00,'2023-03-17 09:32:41','',''),(1083,'1','312','1',1,'Retail Sale Id 1091',2160.00,0.00,0.00,3.00,330.00,'2023-03-17 09:38:19','',''),(1084,'1','312','1',1,'Retail Sale Id 1092',4320.00,0.00,0.00,6.00,660.00,'2023-03-17 09:42:12','',''),(1085,'1','312','1',1,'Retail Sale Id 1093',5040.00,0.00,0.00,7.00,770.00,'2023-03-17 09:56:15','',''),(1086,'1','312','1',1,'Retail Sale Id 1094',3600.00,0.00,0.00,5.00,550.00,'2023-03-17 10:07:31','',''),(1087,'1','312','1',1,'Retail Sale Id 1095',7920.00,0.00,0.00,11.00,1210.00,'2023-03-17 10:22:16','',''),(1088,'1','312','1',1,'Retail Sale Id 1096',2160.00,0.00,0.00,3.00,330.00,'2023-03-17 10:34:16','',''),(1089,'1','312','1',1,'Retail Sale Id 1097',1000.80,0.00,0.00,1.39,152.90,'2023-03-17 10:44:00','',''),(1090,'1','312','1',1,'Retail Sale Id 1098',3600.00,0.00,0.00,5.00,550.00,'2023-03-17 10:59:08','',''),(1091,'1','312','1',1,'Retail Sale Id 1099',8640.00,0.00,0.00,12.00,1320.00,'2023-03-17 11:02:08','',''),(1092,'1','312','1',1,'Retail Sale Id 1100',7920.00,0.00,0.00,11.00,1210.00,'2023-03-17 11:04:09','',''),(1093,'1','312','1',1,'Retail Sale Id 1101',2880.00,0.00,0.00,4.00,440.00,'2023-03-17 11:08:34','',''),(1094,'1','312','1',1,'Retail Sale Id 1102',9000.00,0.00,0.00,12.50,1375.00,'2023-03-17 11:15:31','',''),(1095,'1','312','1',1,'Retail Sale Id 1103',7200.00,0.00,0.00,10.00,1100.00,'2023-03-17 11:17:13','',''),(1096,'1','312','1',1,'Retail Sale Id 1104',81600.00,0.00,0.00,120.00,8400.00,'2023-03-17 11:22:36','',''),(1097,'1','312','1',1,'Retail Sale Id 1105',4680.00,0.00,0.00,6.50,715.00,'2023-03-17 12:22:06','',''),(1098,'1','312','1',1,'Retail Sale Id 1106',4320.00,0.00,0.00,6.00,660.00,'2023-03-17 12:37:20','',''),(1099,'1','312','1',1,'Retail Sale Id 1107',11160.00,0.00,0.00,15.50,1705.00,'2023-03-17 12:48:12','',''),(1100,'1','312','1',1,'Retail Sale Id 1108',4320.00,0.00,0.00,6.00,660.00,'2023-03-17 13:05:29','',''),(1101,'1','312','1',1,'Retail Sale Id 1109',3600.00,0.00,0.00,5.00,550.00,'2023-03-17 13:41:56','',''),(1102,'1','312','1',1,'Retail Sale Id 1110',7200.00,0.00,0.00,10.00,1100.00,'2023-03-17 14:02:24','',''),(1103,'1','312','1',1,'Retail Sale Id 1111',5040.00,0.00,0.00,7.00,770.00,'2023-03-17 14:20:38','',''),(1104,'1','312','1',1,'Retail Sale Id 1112',28800.00,0.00,0.00,40.00,4400.00,'2023-03-17 14:40:02','',''),(1105,'1','312','1',1,'Retail Sale Id 1113',7200.00,0.00,0.00,10.00,1100.00,'2023-03-17 14:51:59','',''),(1106,'1','312','1',1,'Return of Retail Sale Id 1111',0.00,5040.00,7.00,0.00,-770.00,'2023-03-17 14:53:00','',''),(1107,'1','312','1',1,'Retail Sale Id 1114',3103.20,0.00,0.00,4.31,474.10,'2023-03-17 14:54:12','',''),(1108,'1','312','1',1,'Retail Sale Id 1115',7200.00,0.00,0.00,10.00,1100.00,'2023-03-17 15:07:44','',''),(1109,'1','312','1',1,'Retail Sale Id 1116',5040.00,0.00,0.00,7.00,770.00,'2023-03-17 15:23:53','',''),(1110,'1','312','1',1,'Retail Sale Id 1117',12240.00,0.00,0.00,17.00,1870.00,'2023-03-17 15:26:08','',''),(1111,'1','312','1',1,'Retail Sale Id 1118',2160.00,0.00,0.00,3.00,330.00,'2023-03-17 16:12:06','',''),(1112,'1','312','1',1,'Retail Sale Id 1119',4680.00,0.00,0.00,6.50,715.00,'2023-03-17 16:15:08','',''),(1113,'1','312','1',1,'Retail Sale Id 1120',18000.00,0.00,0.00,25.00,2750.00,'2023-03-17 16:21:26','',''),(1114,'1','312','1',1,'Retail Sale Id 1121',5040.00,0.00,0.00,7.00,770.00,'2023-03-17 16:38:20','',''),(1115,'1','312','1',1,'Retail Sale Id 1122',13320.00,0.00,0.00,18.50,2035.00,'2023-03-17 16:40:33','',''),(1116,'1','312','1',1,'Retail Sale Id 1123',7200.00,0.00,0.00,10.00,1100.00,'2023-03-17 16:41:46','',''),(1117,'1','312','1',1,'Retail Sale Id 1124',2880.00,0.00,0.00,4.00,440.00,'2023-03-17 16:50:10','',''),(1118,'1','312','1',1,'Retail Sale Id 1126',2040.00,0.00,0.00,3.00,210.00,'2023-03-17 16:57:31','',''),(1119,'1','312','1',1,'Retail Sale Id 1127',7200.00,0.00,0.00,10.00,1100.00,'2023-03-17 17:09:17','',''),(1120,'1','312','1',1,'Retail Sale Id 1128',9000.00,0.00,0.00,12.50,1375.00,'2023-03-17 17:11:27','',''),(1121,'1','312','1',1,'Retail Sale Id 1129',9000.00,0.00,0.00,12.50,1375.00,'2023-03-17 17:30:53','',''),(1122,'1','312','1',1,'Retail Sale Id 1130',7200.00,0.00,0.00,10.00,1100.00,'2023-03-17 17:35:03','',''),(1123,'1','312','1',1,'Retail Sale Id 1138',720.00,0.00,0.00,1.00,110.00,'2023-03-17 17:37:17','',''),(1124,'1','312','1',1,'Retail Sale Id 1139',2160.00,0.00,0.00,3.00,330.00,'2023-03-17 17:43:09','',''),(1125,'1','312','1',1,'Retail Sale Id 1142',1440.00,0.00,0.00,2.00,220.00,'2023-03-17 17:58:42','',''),(1126,'1','312','1',1,'Retail Sale Id 1143',9000.00,0.00,0.00,12.50,1375.00,'2023-03-17 18:09:20','',''),(1127,'1','312','1',1,'Retail Sale Id 1144',2160.00,0.00,0.00,3.00,330.00,'2023-03-17 18:16:11','',''),(1128,'1','312','1',1,'Retail Sale Id 1145',3600.00,0.00,0.00,5.00,550.00,'2023-03-17 18:17:13','',''),(1129,'1','312','1',1,'Retail Sale Id 1146',11160.00,0.00,0.00,15.50,1705.00,'2023-03-17 18:18:53','',''),(1130,'1','312','1',1,'Retail Sale Id 1147',1598.40,0.00,0.00,2.22,244.20,'2023-03-17 18:23:51','',''),(1131,'1','312','1',1,'Retail Sale Id 1148',30600.00,0.00,0.00,45.00,3150.00,'2023-03-17 18:40:34','',''),(1132,'1','312','1',1,'Retail Sale Id 1149',4996.80,0.00,0.00,6.94,763.40,'2023-03-17 18:43:06','',''),(1133,'1','312','1',1,'Retail Sale Id 1150',12600.00,0.00,0.00,17.50,1925.00,'2023-03-17 18:44:47','',''),(1134,'1','312','1',1,'Retail Sale Id 1151',1497.60,0.00,0.00,2.08,228.80,'2023-03-17 18:46:07','',''),(1135,'1','312','1',1,'Retail Sale Id 1152',2851.20,0.00,0.00,3.96,435.60,'2023-03-17 19:01:50','',''),(1136,'1','312','1',1,'Return of Retail Sale Id 1126',0.00,2040.00,3.00,0.00,-210.00,'2023-03-17 19:10:37','',''),(1137,'1','312','1',1,'Return of Retail Sale Id 1148',0.00,30600.00,45.00,0.00,-3150.00,'2023-03-17 19:13:00','',''),(1138,'1','312','1',1,'Retail Sale Id 1153',32204.80,0.00,0.00,47.36,3315.20,'2023-03-17 19:14:45','',''),(1139,'1','312','1',1,'Retail Sale Id 1154',3600.00,0.00,0.00,5.00,550.00,'2023-03-19 10:21:18','',''),(1140,'1','312','1',1,'Retail Sale Id 1155',5040.00,0.00,0.00,7.00,770.00,'2023-03-19 10:22:38','',''),(1141,'1','312','1',1,'Retail Sale Id 1156',9000.00,0.00,0.00,12.50,1375.00,'2023-03-19 10:24:00','',''),(1142,'1','312','1',1,'Retail Sale Id 1157',10800.00,0.00,0.00,15.00,1650.00,'2023-03-19 10:25:10','',''),(1143,'1','312','1',1,'Retail Sale Id 1158',2160.00,0.00,0.00,3.00,330.00,'2023-03-19 10:26:22','',''),(1144,'1','312','1',1,'Retail Sale Id 1159',2160.00,0.00,0.00,3.00,330.00,'2023-03-19 10:27:56','',''),(1145,'1','312','1',1,'Retail Sale Id 1160',2880.00,0.00,0.00,4.00,440.00,'2023-03-19 10:29:31','',''),(1146,'1','312','1',1,'Retail Sale Id 1161',13320.00,0.00,0.00,18.50,2035.00,'2023-03-19 10:32:09','',''),(1147,'1','312','1',1,'Retail Sale Id 1162',7200.00,0.00,0.00,10.00,1100.00,'2023-03-19 10:34:23','',''),(1148,'1','312','1',1,'Retail Sale Id 1163',2001.60,0.00,0.00,2.78,305.80,'2023-03-19 10:36:06','',''),(1149,'1','312','1',1,'Retail Sale Id 1164',7999.20,0.00,0.00,11.11,1222.10,'2023-03-19 10:37:32','',''),(1150,'1','312','1',1,'Retail Sale Id 1165',6480.00,0.00,0.00,9.00,990.00,'2023-03-19 12:00:48','',''),(1151,'1','312','1',1,'Retail Sale Id 1166',3960.00,0.00,0.00,5.50,605.00,'2023-03-19 12:02:06','',''),(1152,'1','312','1',1,'Retail Sale Id 1167',9000.00,0.00,0.00,12.50,1375.00,'2023-03-19 12:03:11','',''),(1153,'1','312','1',1,'Retail Sale Id 1168',3002.40,0.00,0.00,4.17,458.70,'2023-03-19 12:04:45','',''),(1154,'1','312','1',1,'Retail Sale Id 1169',9000.00,0.00,0.00,12.50,1375.00,'2023-03-19 12:05:43','',''),(1155,'1','312','1',1,'Retail Sale Id 1170',2160.00,0.00,0.00,3.00,330.00,'2023-03-19 12:06:43','',''),(1156,'1','312','1',1,'Retail Sale Id 1171',9000.00,0.00,0.00,12.50,1375.00,'2023-03-19 12:30:44','',''),(1157,'1','312','1',1,'Retail Sale Id 1172',11160.00,0.00,0.00,15.50,1705.00,'2023-03-19 12:45:58','',''),(1158,'1','312','1',1,'Retail Sale Id 1173',9000.00,0.00,0.00,12.50,1375.00,'2023-03-19 12:50:28','',''),(1159,'1','312','1',1,'Retail Sale Id 1174',7920.00,0.00,0.00,11.00,1210.00,'2023-03-19 12:52:42','',''),(1160,'1','312','1',1,'Retail Sale Id 1175',4320.00,0.00,0.00,6.00,660.00,'2023-03-19 13:40:28','',''),(1161,'1','312','1',1,'Retail Sale Id 1176',4320.00,0.00,0.00,6.00,660.00,'2023-03-19 13:42:31','',''),(1162,'1','312','1',1,'Retail Sale Id 1177',2880.00,0.00,0.00,4.00,440.00,'2023-03-19 13:49:23','',''),(1163,'1','312','1',1,'Retail Sale Id 1178',3600.00,0.00,0.00,5.00,550.00,'2023-03-19 14:01:27','',''),(1164,'1','312','1',1,'Retail Sale Id 1179',3600.00,0.00,0.00,5.00,550.00,'2023-03-19 14:06:35','',''),(1165,'1','312','1',1,'Retail Sale Id 1180',5040.00,0.00,0.00,7.00,770.00,'2023-03-19 14:11:36','',''),(1166,'1','312','1',1,'Retail Sale Id 1181',4320.00,0.00,0.00,6.00,660.00,'2023-03-19 14:30:01','',''),(1167,'1','312','1',1,'Retail Sale Id 1182',8280.00,0.00,0.00,11.50,1265.00,'2023-03-19 14:34:33','',''),(1168,'1','312','1',1,'Retail Sale Id 1183',7200.00,0.00,0.00,10.00,1100.00,'2023-03-19 14:51:19','',''),(1169,'1','312','1',1,'Retail Sale Id 1184',2160.00,0.00,0.00,3.00,330.00,'2023-03-19 14:58:31','',''),(1170,'1','312','1',1,'Retail Sale Id 1185',2880.00,0.00,0.00,4.00,440.00,'2023-03-19 15:16:01','',''),(1171,'1','312','1',1,'Retail Sale Id 1186',2001.60,0.00,0.00,2.78,305.80,'2023-03-19 15:30:36','',''),(1172,'1','312','1',1,'Retail Sale Id 1187',2160.00,0.00,0.00,3.00,330.00,'2023-03-19 15:33:23','',''),(1173,'1','312','1',1,'Retail Sale Id 1188',3600.00,0.00,0.00,5.00,550.00,'2023-03-19 15:42:17','',''),(1174,'1','312','1',1,'Retail Sale Id 1189',1440.00,0.00,0.00,2.00,220.00,'2023-03-19 15:45:43','',''),(1175,'1','312','1',1,'Retail Sale Id 1190',2160.00,0.00,0.00,3.00,330.00,'2023-03-19 15:47:55','',''),(1176,'1','312','1',1,'Retail Sale Id 1191',4298.40,0.00,0.00,5.97,656.70,'2023-03-19 15:53:57','',''),(1177,'1','312','1',1,'Retail Sale Id 1192',2880.00,0.00,0.00,4.00,440.00,'2023-03-19 15:55:56','',''),(1178,'1','312','1',1,'Retail Sale Id 1193',4003.20,0.00,0.00,5.56,611.60,'2023-03-19 16:09:59','',''),(1179,'1','312','1',1,'Retail Sale Id 1194',2880.00,0.00,0.00,4.00,440.00,'2023-03-19 16:12:30','',''),(1180,'1','312','1',1,'Retail Sale Id 1196',2880.00,0.00,0.00,4.00,440.00,'2023-03-19 16:22:49','',''),(1181,'1','312','1',1,'Retail Sale Id 1197',8640.00,0.00,0.00,12.00,1320.00,'2023-03-19 16:34:50','',''),(1182,'1','312','1',1,'Retail Sale Id 1198',4320.00,0.00,0.00,6.00,660.00,'2023-03-19 16:47:41','',''),(1183,'1','312','1',1,'Retail Sale Id 1199',4320.00,0.00,0.00,6.00,660.00,'2023-03-19 16:51:30','',''),(1184,'1','312','1',1,'Retail Sale Id 1200',1497.60,0.00,0.00,2.08,228.80,'2023-03-19 17:15:47','',''),(1185,'1','312','1',1,'Retail Sale Id 1201',187000.00,0.00,0.00,275.00,19250.00,'2023-03-19 17:25:27','',''),(1186,'1','312','1',1,'Retail Sale Id 1203',8640.00,0.00,0.00,12.00,1320.00,'2023-03-19 17:52:00','',''),(1187,'1','312','1',1,'Retail Sale Id 1204',4320.00,0.00,0.00,6.00,660.00,'2023-03-19 17:53:31','',''),(1188,'1','312','1',1,'Retail Sale Id 1205',748.80,0.00,0.00,1.04,114.40,'2023-03-19 18:30:19','',''),(1189,'1','312','1',1,'Retail Sale Id 1206',1310.40,0.00,0.00,1.82,200.20,'2023-03-19 18:54:16','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'1','312',1,880.44,'2023-03-19 18:54:16');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1178 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'1','312',1,'Retail Sale Id 1',0.00,593.00,760.00,760.00,167.00,'2023-02-02 11:53:57'),(2,'1','312',1,'Retail Sale Id 2',0.00,4744.00,760.00,6080.00,1336.00,'2023-02-02 15:59:09'),(3,'1','312',1,'Retail Sale Id 3',0.00,593.00,760.00,760.00,167.00,'2023-02-04 08:16:54'),(4,'1','312',1,'Retail Sale Id 4',0.00,55356.55,760.00,70946.00,15589.45,'2023-02-04 09:32:36'),(5,'1','312',1,'Retail Sale Id 5',0.00,2965.00,760.00,3800.00,835.00,'2023-02-04 09:44:46'),(6,'1','312',1,'Retail Sale Id 6',0.00,3558.00,760.00,4560.00,1002.00,'2023-02-04 09:47:01'),(7,'1','312',1,'Retail Sale Id 7',0.00,2965.00,760.00,3800.00,835.00,'2023-02-04 09:48:31'),(8,'1','312',1,'Retail Sale Id 8',0.00,2965.00,760.00,3800.00,835.00,'2023-02-04 09:50:15'),(9,'1','312',1,'Retail Sale Id 9',0.00,2965.00,760.00,3800.00,835.00,'2023-02-04 09:51:52'),(10,'1','312',1,'Retail Sale Id 11',0.00,1950.97,760.00,2500.40,549.43,'2023-02-04 09:57:50'),(11,'1','312',1,'Retail Sale Id 12',0.00,1796.79,760.00,2302.80,506.01,'2023-02-04 09:59:20'),(12,'1','312',1,'Retail Sale Id 13',0.00,1186.00,760.00,1520.00,334.00,'2023-02-04 10:03:34'),(13,'1','312',1,'Retail Sale Id 14',0.00,1168.21,760.00,1497.20,328.99,'2023-02-04 10:04:56'),(14,'1','312',1,'Retail Sale Id 15',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-04 10:14:07'),(15,'1','312',1,'Retail Sale Id 16',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-04 11:25:06'),(16,'1','312',1,'Retail Sale Id 17',0.00,2075.50,760.00,2660.00,584.50,'2023-02-04 11:26:40'),(17,'1','312',1,'Retail Sale Id 18',0.00,2733.73,760.00,3503.60,769.87,'2023-02-04 11:27:49'),(18,'1','312',1,'Retail Sale Id 19',0.00,3558.00,760.00,4560.00,1002.00,'2023-02-04 12:31:11'),(19,'1','312',1,'Retail Sale Id 20',0.00,3558.00,760.00,4560.00,1002.00,'2023-02-04 12:49:57'),(20,'1','312',1,'Retail Sale Id 21',0.00,593.00,760.00,760.00,167.00,'2023-02-04 13:09:52'),(21,'1','312',1,'Retail Sale Id 22',0.00,3119.18,760.00,3997.60,878.42,'2023-02-04 13:19:26'),(22,'1','312',1,'Retail Sale Id 23',0.00,3558.00,760.00,4560.00,1002.00,'2023-02-04 13:23:05'),(23,'1','312',1,'Retail Sale Id 24',0.00,9831.94,760.00,12600.80,2768.86,'2023-02-04 14:58:09'),(24,'1','312',1,'Retail Sale Id 25',0.00,1796.79,760.00,2302.80,506.01,'2023-02-04 15:21:59'),(25,'1','312',1,'Retail Sale Id 26',0.00,5793.61,760.00,7425.20,1631.59,'2023-02-04 16:50:24'),(26,'1','312',1,'Retail Sale Id 27',0.00,5930.00,760.00,7600.00,1670.00,'2023-02-04 16:51:52'),(27,'1','312',1,'Retail Sale Id 28',0.00,5337.00,760.00,6840.00,1503.00,'2023-02-04 19:54:57'),(28,'1','312',1,'Retail Sale Id 29',0.00,23720.00,760.00,30400.00,6680.00,'2023-02-04 19:56:02'),(29,'1','312',1,'Retail Sale Id 30',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-05 07:42:06'),(30,'1','312',1,'Retail Sale Id 31',0.00,3558.00,760.00,4560.00,1002.00,'2023-02-05 07:43:23'),(31,'1','312',1,'Retail Sale Id 32',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-05 10:13:49'),(32,'1','312',1,'Retail Sale Id 33',0.00,5930.00,760.00,7600.00,1670.00,'2023-02-05 12:34:17'),(33,'1','312',1,'Retail Sale Id 34',0.00,1209.72,760.00,1550.40,340.68,'2023-02-05 12:39:56'),(34,'1','312',1,'Retail Sale Id 35',0.00,1796.79,760.00,2302.80,506.01,'2023-02-05 12:45:01'),(35,'1','312',1,'Retail Sale Id 36',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-05 12:58:36'),(36,'1','312',1,'Retail Sale Id 37',0.00,3558.00,760.00,4560.00,1002.00,'2023-02-05 13:00:05'),(37,'1','312',1,'Retail Sale Id 38',0.00,8302.00,760.00,10640.00,2338.00,'2023-02-05 13:04:16'),(38,'1','312',1,'Retail Sale Id 39',0.00,2965.00,760.00,3800.00,835.00,'2023-02-05 13:05:47'),(39,'1','312',1,'Retail Sale Id 40',0.00,3558.00,760.00,4560.00,1002.00,'2023-02-05 13:07:19'),(40,'1','312',1,'Retail Sale Id 41',0.00,3119.18,760.00,3997.60,878.42,'2023-02-05 14:48:03'),(41,'1','312',1,'Retail Sale Id 42',0.00,1559.59,760.00,1998.80,439.21,'2023-02-05 14:50:12'),(42,'1','312',1,'Retail Sale Id 43',0.00,7098.21,760.00,9097.20,1998.99,'2023-02-05 15:38:53'),(43,'1','312',1,'Retail Sale Id 44',0.00,6244.29,760.00,8002.80,1758.51,'2023-02-05 15:50:16'),(44,'1','312',1,'Retail Sale Id 45',0.00,4767.72,760.00,6110.40,1342.68,'2023-02-05 19:25:27'),(45,'1','312',1,'Retail Sale Id 46',0.00,5930.00,760.00,7600.00,1670.00,'2023-02-05 19:26:25'),(46,'1','312',1,'Retail Sale Id 47',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-05 19:27:24'),(47,'1','312',1,'Retail Sale Id 48',0.00,4447.50,760.00,5700.00,1252.50,'2023-02-05 19:28:07'),(48,'1','312',1,'Retail Sale Id 49',0.00,11860.00,760.00,15200.00,3340.00,'2023-02-05 19:28:47'),(49,'1','312',1,'Retail Sale Id 50',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-07 08:13:31'),(50,'1','312',1,'Retail Sale Id 51',0.00,3558.00,760.00,4560.00,1002.00,'2023-02-07 08:15:09'),(51,'1','312',1,'Retail Sale Id 52',0.00,2965.00,760.00,3800.00,835.00,'2023-02-07 08:16:16'),(52,'1','312',1,'Retail Sale Id 53',0.00,1559.59,760.00,1998.80,439.21,'2023-02-07 08:35:31'),(53,'1','312',1,'Retail Sale Id 54',0.00,3558.00,760.00,4560.00,1002.00,'2023-02-07 12:11:48'),(54,'1','312',1,'Retail Sale Id 55',0.00,2377.93,760.00,3047.60,669.67,'2023-02-07 12:17:09'),(55,'1','312',1,'Retail Sale Id 56',0.00,6523.00,760.00,8360.00,1837.00,'2023-02-07 13:44:57'),(56,'1','312',1,'Retail Sale Id 57',0.00,3119.18,760.00,3997.60,878.42,'2023-02-07 14:27:44'),(57,'1','312',1,'Retail Sale Id 59',0.00,3581.72,760.00,4590.40,1008.68,'2023-02-07 19:18:10'),(58,'1','312',1,'Retail Sale Id 60',0.00,11860.00,760.00,15200.00,3340.00,'2023-02-07 19:19:29'),(59,'1','312',1,'Retail Sale Id 61',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-07 19:23:33'),(60,'1','312',1,'Retail Sale Id 62',0.00,3558.00,760.00,4560.00,1002.00,'2023-02-07 19:27:21'),(61,'1','312',1,'Retail Sale Id 63',0.00,5930.00,760.00,7600.00,1670.00,'2023-02-07 19:28:36'),(62,'1','312',1,'Retail Sale Id 64',0.00,7116.00,760.00,9120.00,2004.00,'2023-02-07 19:30:17'),(63,'1','312',1,'Retail Sale Id 65',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-07 19:32:24'),(64,'1','312',1,'Retail Sale Id 66',0.00,5930.00,760.00,7600.00,1670.00,'2023-02-07 19:33:20'),(65,'1','312',1,'Retail Sale Id 67',0.00,6523.00,760.00,8360.00,1837.00,'2023-02-07 19:34:21'),(66,'1','312',1,'Retail Sale Id 68',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-07 19:35:18'),(67,'1','312',1,'Retail Sale Id 69',0.00,5930.00,760.00,7600.00,1670.00,'2023-02-07 19:36:39'),(68,'1','312',1,'Retail Sale Id 70',0.00,13698.30,760.00,17556.00,3857.70,'2023-02-07 19:39:37'),(69,'1','312',1,'Retail Sale Id 71',0.00,237.20,760.00,304.00,66.80,'2023-02-07 19:43:08'),(70,'1','312',1,'Retail Sale Id 72',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-08 11:05:18'),(71,'1','312',1,'Retail Sale Id 73',0.00,4151.00,760.00,5320.00,1169.00,'2023-02-08 14:31:29'),(72,'1','312',1,'Retail Sale Id 74',0.00,5930.00,760.00,7600.00,1670.00,'2023-02-08 14:33:18'),(73,'1','312',1,'Retail Sale Id 75',0.00,6819.50,760.00,8740.00,1920.50,'2023-02-08 14:40:48'),(74,'1','312',1,'Retail Sale Id 76',0.00,5930.00,760.00,7600.00,1670.00,'2023-02-08 14:42:02'),(75,'1','312',1,'Retail Sale Id 77',0.00,2965.00,760.00,3800.00,835.00,'2023-02-08 14:43:08'),(76,'1','312',1,'Retail Sale Id 78',0.00,3558.00,760.00,4560.00,1002.00,'2023-02-08 14:44:18'),(77,'1','312',1,'Retail Sale Id 79',0.00,5337.00,760.00,6840.00,1503.00,'2023-02-08 14:45:38'),(78,'1','312',1,'Retail Sale Id 80',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-08 17:02:09'),(79,'1','312',1,'Retail Sale Id 81',0.00,3558.00,760.00,4560.00,1002.00,'2023-02-08 17:37:05'),(80,'1','312',1,'Retail Sale Id 82',0.00,5930.00,760.00,7600.00,1670.00,'2023-02-08 17:51:33'),(81,'1','312',1,'Retail Sale Id 83',0.00,1992.48,760.00,2553.60,561.12,'2023-02-08 19:18:47'),(82,'1','312',1,'Retail Sale Id 84',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-08 19:21:33'),(83,'1','312',1,'Retail Sale Id 85',0.00,5930.00,760.00,7600.00,1670.00,'2023-02-08 19:23:49'),(84,'1','312',1,'Retail Sale Id 86',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-08 19:26:12'),(85,'1','312',1,'Retail Sale Id 87',0.00,5930.00,760.00,7600.00,1670.00,'2023-02-08 19:28:35'),(86,'1','312',1,'Retail Sale Id 88',0.00,8895.00,760.00,11400.00,2505.00,'2023-02-08 19:32:56'),(87,'1','312',1,'Retail Sale Id 89',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-09 10:11:05'),(88,'1','312',1,'Retail Sale Id 90',0.00,2965.00,760.00,3800.00,835.00,'2023-02-09 10:12:09'),(89,'1','312',1,'Retail Sale Id 91',0.00,5930.00,760.00,7600.00,1670.00,'2023-02-09 10:13:16'),(90,'1','312',1,'Retail Sale Id 92',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-09 19:27:37'),(91,'1','312',1,'Retail Sale Id 93',0.00,6819.50,760.00,8740.00,1920.50,'2023-02-09 19:28:30'),(92,'1','312',1,'Retail Sale Id 94',0.00,6523.00,760.00,8360.00,1837.00,'2023-02-09 19:29:24'),(93,'1','312',1,'Retail Sale Id 95',0.00,5930.00,760.00,7600.00,1670.00,'2023-02-09 19:30:12'),(94,'1','312',1,'Retail Sale Id 96',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-09 19:31:03'),(95,'1','312',1,'Retail Sale Id 97',0.00,6819.50,760.00,8740.00,1920.50,'2023-02-09 19:31:56'),(96,'1','312',1,'Retail Sale Id 98',0.00,8302.00,760.00,10640.00,2338.00,'2023-02-09 19:32:51'),(97,'1','312',1,'Retail Sale Id 99',0.00,6107.90,760.00,7828.00,1720.10,'2023-02-09 19:34:16'),(98,'1','312',1,'Retail Sale Id 100',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-09 19:35:15'),(99,'1','312',1,'Retail Sale Id 101',0.00,1168.21,760.00,1497.20,328.99,'2023-02-09 19:36:51'),(100,'1','312',1,'Retail Sale Id 102',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-09 19:37:49'),(101,'1','312',1,'Retail Sale Id 103',0.00,5159.10,760.00,6612.00,1452.90,'2023-02-09 19:39:51'),(102,'1','312',1,'Return of Retail Sale Id 102',7412.50,0.00,760.00,-9500.00,-2087.50,'2023-02-09 19:42:49'),(103,'1','312',1,'Retail Sale Id 104',0.00,5076.08,760.00,6505.60,1429.52,'2023-02-09 19:44:10'),(104,'1','312',1,'Retail Sale Id 105',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-10 12:37:17'),(105,'1','312',1,'Retail Sale Id 106',0.00,2965.00,760.00,3800.00,835.00,'2023-02-10 12:40:00'),(106,'1','312',1,'Retail Sale Id 107',0.00,2372.00,760.00,3040.00,668.00,'2023-02-10 17:59:12'),(107,'1','312',1,'Retail Sale Id 108',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-10 19:34:46'),(108,'1','312',1,'Retail Sale Id 109',0.00,5930.00,760.00,7600.00,1670.00,'2023-02-10 19:35:34'),(109,'1','312',1,'Retail Sale Id 110',0.00,8302.00,760.00,10640.00,2338.00,'2023-02-10 19:36:14'),(110,'1','312',1,'Retail Sale Id 111',0.00,6523.00,760.00,8360.00,1837.00,'2023-02-10 19:37:05'),(111,'1','312',1,'Retail Sale Id 112',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-10 19:37:50'),(112,'1','312',1,'Retail Sale Id 113',0.00,5930.00,760.00,7600.00,1670.00,'2023-02-10 19:38:31'),(113,'1','312',1,'Retail Sale Id 114',0.00,8302.00,760.00,10640.00,2338.00,'2023-02-10 19:39:16'),(114,'1','312',1,'Retail Sale Id 115',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-10 19:39:59'),(115,'1','312',1,'Retail Sale Id 116',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-10 19:40:46'),(116,'1','312',1,'Retail Sale Id 117',0.00,5930.00,760.00,7600.00,1670.00,'2023-02-10 19:41:47'),(117,'1','312',1,'Retail Sale Id 118',0.00,8385.02,760.00,10746.40,2361.38,'2023-02-10 19:44:54'),(118,'1','312',1,'Retail Sale Id 120',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-11 07:51:06'),(119,'1','312',1,'Retail Sale Id 122',0.00,593.00,760.00,760.00,167.00,'2023-02-11 07:53:56'),(120,'1','312',1,'Retail Sale Id 123',0.00,1796.79,760.00,2302.80,506.01,'2023-02-11 07:55:47'),(121,'1','312',1,'Retail Sale Id 124',0.00,4678.77,760.00,5996.40,1317.63,'2023-02-11 08:46:22'),(122,'1','312',1,'Retail Sale Id 125',0.00,2372.00,760.00,3040.00,668.00,'2023-02-11 09:11:36'),(123,'1','312',1,'Retail Sale Id 126',0.00,1779.00,760.00,2280.00,501.00,'2023-02-11 10:41:09'),(124,'1','312',1,'Retail Sale Id 127',0.00,4151.00,760.00,5320.00,1169.00,'2023-02-11 10:57:31'),(125,'1','312',1,'Retail Sale Id 128',0.00,4151.00,760.00,5320.00,1169.00,'2023-02-11 12:17:58'),(126,'1','312',1,'Retail Sale Id 129',0.00,3558.00,760.00,4560.00,1002.00,'2023-02-11 13:54:08'),(127,'1','312',1,'Retail Sale Id 130',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-11 13:55:36'),(128,'1','312',1,'Retail Sale Id 131',0.00,1191.93,760.00,1527.60,335.67,'2023-02-11 14:33:37'),(129,'1','312',1,'Retail Sale Id 132',0.00,3012.44,760.00,3860.80,848.36,'2023-02-11 20:01:19'),(130,'1','312',1,'Retail Sale Id 133',0.00,8895.00,760.00,11400.00,2505.00,'2023-02-11 20:02:53'),(131,'1','312',1,'Retail Sale Id 134',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-11 20:03:44'),(132,'1','312',1,'Retail Sale Id 135',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-11 20:04:26'),(133,'1','312',1,'Retail Sale Id 136',0.00,5930.00,760.00,7600.00,1670.00,'2023-02-11 20:05:13'),(134,'1','312',1,'Retail Sale Id 137',0.00,6523.00,760.00,8360.00,1837.00,'2023-02-11 20:06:04'),(135,'1','312',1,'Retail Sale Id 138',0.00,5337.00,760.00,6840.00,1503.00,'2023-02-11 20:06:51'),(136,'1','312',1,'Retail Sale Id 139',0.00,2965.00,760.00,3800.00,835.00,'2023-02-11 20:07:31'),(137,'1','312',1,'Retail Sale Id 140',0.00,2965.00,760.00,3800.00,835.00,'2023-02-11 20:08:16'),(138,'1','312',1,'Retail Sale Id 141',0.00,5930.00,760.00,7600.00,1670.00,'2023-02-11 20:10:43'),(139,'1','312',1,'Retail Sale Id 142',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-12 07:56:25'),(140,'1','312',1,'Retail Sale Id 143',0.00,3901.94,760.00,5000.80,1098.86,'2023-02-12 08:04:17'),(141,'1','312',1,'Retail Sale Id 144',0.00,2342.35,760.00,3002.00,659.65,'2023-02-12 08:05:27'),(142,'1','312',1,'Retail Sale Id 145',0.00,1186.00,760.00,1520.00,334.00,'2023-02-12 08:06:49'),(143,'1','312',1,'Retail Sale Id 146',0.00,7803.88,760.00,10001.60,2197.72,'2023-02-12 09:25:54'),(144,'1','312',1,'Retail Sale Id 147',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-12 09:43:46'),(145,'1','312',1,'Retail Sale Id 148',0.00,2965.00,760.00,3800.00,835.00,'2023-02-12 10:28:58'),(146,'1','312',1,'Retail Sale Id 149',0.00,1779.00,760.00,2280.00,501.00,'2023-02-12 10:30:37'),(147,'1','312',1,'Retail Sale Id 150',0.00,5835.12,760.00,7478.40,1643.28,'2023-02-12 11:11:26'),(148,'1','312',1,'Retail Sale Id 151',0.00,3558.00,760.00,4560.00,1002.00,'2023-02-12 11:43:30'),(149,'1','312',1,'Retail Sale Id 152',0.00,3901.94,760.00,5000.80,1098.86,'2023-02-12 12:05:59'),(150,'1','312',1,'Retail Sale Id 153',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-12 13:02:13'),(151,'1','312',1,'Retail Sale Id 154',0.00,7803.88,760.00,10001.60,2197.72,'2023-02-12 13:03:39'),(152,'1','312',1,'Retail Sale Id 155',0.00,1186.00,760.00,1520.00,334.00,'2023-02-12 13:04:46'),(153,'1','312',1,'Retail Sale Id 156',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-12 13:05:45'),(154,'1','312',1,'Retail Sale Id 157',0.00,782.76,760.00,1003.20,220.44,'2023-02-12 15:15:26'),(155,'1','312',1,'Retail Sale Id 158',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-12 15:16:46'),(156,'1','312',1,'Retail Sale Id 159',0.00,3854.50,760.00,4940.00,1085.50,'2023-02-12 15:18:02'),(157,'1','312',1,'Retail Sale Id 160',0.00,2372.00,760.00,3040.00,668.00,'2023-02-12 17:13:39'),(158,'1','312',1,'Retail Sale Id 161',0.00,1186.00,760.00,1520.00,334.00,'2023-02-12 17:14:54'),(159,'1','312',1,'Retail Sale Id 162',0.00,3119.18,760.00,3997.60,878.42,'2023-02-12 17:16:00'),(160,'1','312',1,'Retail Sale Id 163',0.00,1779.00,760.00,2280.00,501.00,'2023-02-12 17:17:31'),(161,'1','312',1,'Retail Sale Id 164',0.00,3901.94,760.00,5000.80,1098.86,'2023-02-12 17:41:43'),(162,'1','312',1,'Retail Sale Id 165',0.00,1186.00,760.00,1520.00,334.00,'2023-02-12 17:45:36'),(163,'1','312',1,'Retail Sale Id 166',0.00,3901.94,760.00,5000.80,1098.86,'2023-02-12 18:07:24'),(164,'1','312',1,'Retail Sale Id 167',0.00,2372.00,760.00,3040.00,668.00,'2023-02-12 18:08:35'),(165,'1','312',1,'Retail Sale Id 168',0.00,18145.80,760.00,23256.00,5110.20,'2023-02-12 19:35:31'),(166,'1','312',1,'Retail Sale Id 169',0.00,1779.00,760.00,2280.00,501.00,'2023-02-14 07:50:16'),(167,'1','312',1,'Retail Sale Id 170',0.00,4121.35,760.00,5282.00,1160.65,'2023-02-14 07:51:45'),(168,'1','312',1,'Retail Sale Id 171',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-14 07:53:38'),(169,'1','312',1,'Retail Sale Id 172',0.00,1559.59,760.00,1998.80,439.21,'2023-02-14 07:54:39'),(170,'1','312',1,'Retail Sale Id 173',0.00,3558.00,760.00,4560.00,1002.00,'2023-02-14 09:02:11'),(171,'1','312',1,'Retail Sale Id 174',0.00,1950.97,760.00,2500.40,549.43,'2023-02-14 09:16:36'),(172,'1','312',1,'Retail Sale Id 175',0.00,2965.00,760.00,3800.00,835.00,'2023-02-14 09:33:05'),(173,'1','312',1,'Retail Sale Id 176',0.00,3587.65,760.00,4598.00,1010.35,'2023-02-14 09:57:38'),(174,'1','312',1,'Retail Sale Id 177',0.00,1779.00,760.00,2280.00,501.00,'2023-02-14 10:35:39'),(175,'1','312',1,'Retail Sale Id 178',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-14 10:41:13'),(176,'1','312',1,'Retail Sale Id 179',0.00,3558.00,760.00,4560.00,1002.00,'2023-02-14 11:34:53'),(177,'1','312',1,'Retail Sale Id 180',0.00,5930.00,760.00,7600.00,1670.00,'2023-02-14 12:09:45'),(178,'1','312',1,'Retail Sale Id 181',0.00,3119.18,760.00,3997.60,878.42,'2023-02-14 12:17:53'),(179,'1','312',1,'Retail Sale Id 182',0.00,1186.00,760.00,1520.00,334.00,'2023-02-14 14:04:01'),(180,'1','312',1,'Retail Sale Id 183',0.00,2075.50,760.00,2660.00,584.50,'2023-02-14 14:05:27'),(181,'1','312',1,'Retail Sale Id 184',0.00,1559.59,760.00,1998.80,439.21,'2023-02-14 14:09:16'),(182,'1','312',1,'Retail Sale Id 185',0.00,3119.18,760.00,3997.60,878.42,'2023-02-14 14:13:38'),(183,'1','312',1,'Retail Sale Id 186',0.00,4151.00,720.00,5040.00,889.00,'2023-02-14 15:06:12'),(184,'1','312',1,'Retail Sale Id 187',0.00,5022.71,720.00,6098.40,1075.69,'2023-02-14 15:38:18'),(185,'1','312',1,'Retail Sale Id 188',0.00,1191.93,720.00,1447.20,255.27,'2023-02-14 16:01:33'),(186,'1','312',1,'Retail Sale Id 189',0.00,3558.00,720.00,4320.00,762.00,'2023-02-14 19:00:07'),(187,'1','312',1,'Retail Sale Id 190',0.00,1779.00,720.00,2160.00,381.00,'2023-02-14 19:01:09'),(188,'1','312',1,'Retail Sale Id 191',0.00,658.23,720.00,799.20,140.97,'2023-02-14 19:02:11'),(189,'1','312',1,'Retail Sale Id 192',0.00,1186.00,720.00,1440.00,254.00,'2023-02-14 19:03:19'),(190,'1','312',1,'Retail Sale Id 193',0.00,1648.54,720.00,2001.60,353.06,'2023-02-14 19:04:17'),(191,'1','312',1,'Retail Sale Id 194',0.00,7904.69,720.00,9597.60,1692.91,'2023-02-14 19:13:49'),(192,'1','312',1,'Retail Sale Id 195',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-14 19:22:58'),(193,'1','312',1,'Retail Sale Id 196',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-14 20:14:57'),(194,'1','312',1,'Retail Sale Id 197',0.00,2965.00,720.00,3600.00,635.00,'2023-02-15 07:26:23'),(195,'1','312',1,'Retail Sale Id 198',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-15 07:54:17'),(196,'1','312',1,'Retail Sale Id 199',0.00,3558.00,720.00,4320.00,762.00,'2023-02-15 08:02:39'),(197,'1','312',1,'Retail Sale Id 200',0.00,2372.00,720.00,2880.00,508.00,'2023-02-15 10:13:26'),(198,'1','312',1,'Retail Sale Id 201',0.00,3558.00,720.00,4320.00,762.00,'2023-02-15 10:19:32'),(199,'1','312',1,'Retail Sale Id 202',0.00,1879.81,720.00,2282.40,402.59,'2023-02-15 10:22:31'),(200,'1','312',1,'Retail Sale Id 203',0.00,3297.08,720.00,4003.20,706.12,'2023-02-15 11:03:27'),(201,'1','312',1,'Retail Sale Id 204',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-15 11:42:43'),(202,'1','312',1,'Retail Sale Id 205',0.00,2965.00,720.00,3600.00,635.00,'2023-02-15 12:03:40'),(203,'1','312',1,'Retail Sale Id 206',0.00,3558.00,720.00,4320.00,762.00,'2023-02-15 12:12:12'),(204,'1','312',1,'Retail Sale Id 207',0.00,2372.00,720.00,2880.00,508.00,'2023-02-15 12:49:56'),(205,'1','312',1,'Retail Sale Id 208',0.00,3297.08,720.00,4003.20,706.12,'2023-02-15 13:23:32'),(206,'1','312',1,'Retail Sale Id 209',0.00,3558.00,720.00,4320.00,762.00,'2023-02-15 13:52:21'),(207,'1','312',1,'Retail Sale Id 210',0.00,2372.00,720.00,2880.00,508.00,'2023-02-15 15:30:55'),(208,'1','312',1,'Retail Sale Id 211',0.00,3581.72,720.00,4348.80,767.08,'2023-02-15 17:04:23'),(209,'1','312',1,'Retail Sale Id 212',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-15 17:10:48'),(210,'1','312',1,'Retail Sale Id 213',0.00,2472.81,720.00,3002.40,529.59,'2023-02-15 17:40:29'),(211,'1','312',1,'Retail Sale Id 214',0.00,3558.00,720.00,4320.00,762.00,'2023-02-15 17:49:17'),(212,'1','312',1,'Retail Sale Id 215',0.00,1779.00,720.00,2160.00,381.00,'2023-02-15 18:14:08'),(213,'1','312',1,'Retail Sale Id 216',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-15 18:51:00'),(214,'1','312',1,'Retail Sale Id 217',0.00,1150.42,720.00,1396.80,246.38,'2023-02-15 18:52:00'),(215,'1','312',1,'Retail Sale Id 218',0.00,2472.81,720.00,3002.40,529.59,'2023-02-15 18:53:01'),(216,'1','312',1,'Retail Sale Id 219',0.00,2965.00,720.00,3600.00,635.00,'2023-02-15 18:54:03'),(217,'1','312',1,'Retail Sale Id 220',0.00,10632.49,720.00,12909.60,2277.11,'2023-02-15 19:42:36'),(218,'1','312',1,'Retail Sale Id 222',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-16 07:30:34'),(219,'1','312',1,'Retail Sale Id 223',0.00,1186.00,720.00,1440.00,254.00,'2023-02-16 08:12:08'),(220,'1','312',1,'Retail Sale Id 224',0.00,4151.00,720.00,5040.00,889.00,'2023-02-16 08:28:35'),(221,'1','312',1,'Retail Sale Id 225',0.00,3558.00,720.00,4320.00,762.00,'2023-02-16 08:38:12'),(222,'1','312',1,'Retail Sale Id 226',0.00,3558.00,720.00,4320.00,762.00,'2023-02-16 08:41:54'),(223,'1','312',1,'Retail Sale Id 227',0.00,4151.00,720.00,5040.00,889.00,'2023-02-16 08:49:18'),(224,'1','312',1,'Retail Sale Id 228',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-16 09:28:34'),(225,'1','312',1,'Retail Sale Id 229',0.00,7116.00,720.00,8640.00,1524.00,'2023-02-16 09:33:12'),(226,'1','312',1,'Retail Sale Id 230',0.00,1648.54,720.00,2001.60,353.06,'2023-02-16 10:03:34'),(227,'1','312',1,'Retail Sale Id 231',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-16 10:07:12'),(228,'1','312',1,'Retail Sale Id 232',0.00,1779.00,720.00,2160.00,381.00,'2023-02-16 10:16:57'),(229,'1','312',1,'Retail Sale Id 233',0.00,14825.00,720.00,18000.00,3175.00,'2023-02-16 10:33:46'),(230,'1','312',1,'Retail Sale Id 234',0.00,1233.44,720.00,1497.60,264.16,'2023-02-16 11:17:32'),(231,'1','312',1,'Retail Sale Id 235',0.00,4744.00,720.00,5760.00,1016.00,'2023-02-16 12:33:19'),(232,'1','312',1,'Retail Sale Id 237',0.00,4151.00,720.00,5040.00,889.00,'2023-02-16 13:27:27'),(233,'1','312',1,'Retail Sale Id 238',0.00,29650.00,720.00,36000.00,6350.00,'2023-02-16 14:16:59'),(234,'1','312',1,'Retail Sale Id 239',0.00,1191.93,720.00,1447.20,255.27,'2023-02-16 15:34:57'),(235,'1','312',1,'Retail Sale Id 240',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-16 15:37:00'),(236,'1','312',1,'Retail Sale Id 241',0.00,7116.00,720.00,8640.00,1524.00,'2023-02-16 16:51:16'),(237,'1','312',1,'Retail Sale Id 242',0.00,2965.00,720.00,3600.00,635.00,'2023-02-16 17:10:07'),(238,'1','312',1,'Retail Sale Id 243',0.00,3558.00,720.00,4320.00,762.00,'2023-02-16 17:23:04'),(239,'1','312',1,'Retail Sale Id 244',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-16 17:50:23'),(240,'1','312',1,'Retail Sale Id 245',0.00,1779.00,720.00,2160.00,381.00,'2023-02-16 18:00:24'),(241,'1','312',1,'Return of Retail Sale Id 245',1779.00,0.00,720.00,-2160.00,-381.00,'2023-02-16 18:10:51'),(242,'1','312',1,'Retail Sale Id 246',0.00,1464.71,720.00,1778.40,313.69,'2023-02-16 18:12:44'),(243,'1','312',1,'Retail Sale Id 247',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-16 18:23:11'),(244,'1','312',1,'Retail Sale Id 248',0.00,2965.00,720.00,3600.00,635.00,'2023-02-16 18:48:48'),(245,'1','312',1,'Retail Sale Id 249',0.00,1648.54,720.00,2001.60,353.06,'2023-02-16 18:50:21'),(246,'1','312',1,'Return of Retail Sale Id 248',2965.00,0.00,720.00,-3600.00,-635.00,'2023-02-16 18:54:09'),(247,'1','312',1,'Retail Sale Id 250',0.00,1779.00,720.00,2160.00,381.00,'2023-02-16 18:56:11'),(248,'1','312',1,'Retail Sale Id 251',0.00,9191.50,720.00,11160.00,1968.50,'2023-02-17 07:12:29'),(249,'1','312',1,'Retail Sale Id 252',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-17 08:33:12'),(250,'1','312',1,'Retail Sale Id 256',0.00,4115.42,720.00,4996.80,881.38,'2023-02-17 09:14:17'),(251,'1','312',1,'Retail Sale Id 259',0.00,1191.93,720.00,1447.20,255.27,'2023-02-17 10:58:20'),(252,'1','312',1,'Retail Sale Id 260',0.00,1779.00,720.00,2160.00,381.00,'2023-02-17 11:03:12'),(253,'1','312',1,'Retail Sale Id 261',0.00,1779.00,720.00,2160.00,381.00,'2023-02-17 11:39:16'),(254,'1','312',1,'Retail Sale Id 262',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-17 11:40:27'),(255,'1','312',1,'Retail Sale Id 263',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-17 12:22:03'),(256,'1','312',1,'Retail Sale Id 264',0.00,2965.00,720.00,3600.00,635.00,'2023-02-17 15:02:25'),(257,'1','312',1,'Retail Sale Id 265',0.00,2965.00,720.00,3600.00,635.00,'2023-02-17 15:04:39'),(258,'1','312',1,'Retail Sale Id 266',0.00,3540.21,720.00,4298.40,758.19,'2023-02-17 15:05:48'),(259,'1','312',1,'Retail Sale Id 267',0.00,824.27,720.00,1000.80,176.53,'2023-02-17 15:10:17'),(260,'1','312',1,'Retail Sale Id 268',0.00,3558.00,720.00,4320.00,762.00,'2023-02-17 15:20:43'),(261,'1','312',1,'Retail Sale Id 269',0.00,3955.31,720.00,4802.40,847.09,'2023-02-17 15:32:17'),(262,'1','312',1,'Retail Sale Id 270',0.00,2472.81,720.00,3002.40,529.59,'2023-02-17 16:05:35'),(263,'1','312',1,'Retail Sale Id 271',0.00,4115.42,720.00,4996.80,881.38,'2023-02-17 17:46:50'),(264,'1','312',1,'Retail Sale Id 272',0.00,2965.00,720.00,3600.00,635.00,'2023-02-17 17:48:32'),(265,'1','312',1,'Retail Sale Id 273',0.00,1150.42,720.00,1396.80,246.38,'2023-02-17 17:49:24'),(266,'1','312',1,'Retail Sale Id 274',0.00,1648.54,720.00,2001.60,353.06,'2023-02-17 17:53:32'),(267,'1','312',1,'Retail Sale Id 275',0.00,593.00,720.00,720.00,127.00,'2023-02-17 17:57:09'),(268,'1','312',1,'Retail Sale Id 276',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-17 18:11:11'),(269,'1','312',1,'Retail Sale Id 277',0.00,7709.00,720.00,9360.00,1651.00,'2023-02-17 18:25:44'),(270,'1','312',1,'Return of Retail Sale Id 276',7412.50,0.00,720.00,-9000.00,-1587.50,'2023-02-17 19:14:52'),(271,'1','312',1,'Retail Sale Id 278',0.00,6997.40,720.00,8496.00,1498.60,'2023-02-17 19:16:01'),(272,'1','312',1,'Retail Sale Id 279',0.00,8895.00,720.00,10800.00,1905.00,'2023-02-18 07:46:10'),(273,'1','312',1,'Retail Sale Id 280',0.00,11563.50,720.00,14040.00,2476.50,'2023-02-18 07:48:42'),(274,'1','312',1,'Retail Sale Id 281',0.00,2472.81,720.00,3002.40,529.59,'2023-02-18 09:03:34'),(275,'1','312',1,'Retail Sale Id 282',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-18 09:05:20'),(276,'1','312',1,'Retail Sale Id 283',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-18 09:06:48'),(277,'1','312',1,'Retail Sale Id 284',0.00,593.00,720.00,720.00,127.00,'2023-02-18 09:14:50'),(278,'1','312',1,'Retail Sale Id 285',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-18 09:27:47'),(279,'1','312',1,'Retail Sale Id 286',0.00,13639.00,720.00,16560.00,2921.00,'2023-02-18 09:38:35'),(280,'1','312',1,'Retail Sale Id 287',0.00,3558.00,720.00,4320.00,762.00,'2023-02-18 09:49:07'),(281,'1','312',1,'Retail Sale Id 288',0.00,1191.93,720.00,1447.20,255.27,'2023-02-18 09:52:49'),(282,'1','312',1,'Retail Sale Id 289',0.00,1779.00,720.00,2160.00,381.00,'2023-02-18 10:24:12'),(283,'1','312',1,'Retail Sale Id 290',0.00,2965.00,720.00,3600.00,635.00,'2023-02-18 11:18:25'),(284,'1','312',1,'Retail Sale Id 291',0.00,2965.00,720.00,3600.00,635.00,'2023-02-18 12:03:24'),(285,'1','312',1,'Retail Sale Id 292',0.00,4151.00,720.00,5040.00,889.00,'2023-02-18 12:10:27'),(286,'1','312',1,'Retail Sale Id 293',0.00,1779.00,720.00,2160.00,381.00,'2023-02-18 12:14:15'),(287,'1','312',1,'Retail Sale Id 294',0.00,2965.00,720.00,3600.00,635.00,'2023-02-18 12:21:34'),(288,'1','312',1,'Retail Sale Id 295',0.00,4744.00,720.00,5760.00,1016.00,'2023-02-18 12:46:34'),(289,'1','312',1,'Retail Sale Id 296',0.00,2965.00,720.00,3600.00,635.00,'2023-02-18 12:56:20'),(290,'1','312',1,'Retail Sale Id 297',0.00,3558.00,720.00,4320.00,762.00,'2023-02-18 13:35:59'),(291,'1','312',1,'Retail Sale Id 298',0.00,2965.00,720.00,3600.00,635.00,'2023-02-18 13:39:29'),(292,'1','312',1,'Retail Sale Id 299',0.00,6523.00,720.00,7920.00,1397.00,'2023-02-18 14:12:50'),(293,'1','312',1,'Retail Sale Id 300',0.00,2965.00,720.00,3600.00,635.00,'2023-02-18 15:14:51'),(294,'1','312',1,'Retail Sale Id 301',0.00,3558.00,720.00,4320.00,762.00,'2023-02-18 15:15:51'),(295,'1','312',1,'Retail Sale Id 302',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-18 15:16:57'),(296,'1','312',1,'Retail Sale Id 303',0.00,27278.00,720.00,33120.00,5842.00,'2023-02-18 15:22:23'),(297,'1','312',1,'Retail Sale Id 304',0.00,4151.00,720.00,5040.00,889.00,'2023-02-18 15:33:22'),(298,'1','312',1,'Retail Sale Id 305',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-18 15:37:48'),(299,'1','312',1,'Retail Sale Id 307',0.00,121565.00,680.00,139400.00,17835.00,'2023-02-18 16:05:04'),(300,'1','312',1,'Retail Sale Id 308',0.00,1779.00,720.00,2160.00,381.00,'2023-02-18 16:34:00'),(301,'1','312',1,'Retail Sale Id 309',0.00,2372.00,720.00,2880.00,508.00,'2023-02-18 16:35:03'),(302,'1','312',1,'Retail Sale Id 310',0.00,1073.33,720.00,1303.20,229.87,'2023-02-18 16:41:27'),(303,'1','312',1,'Retail Sale Id 311',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-18 16:58:27'),(304,'1','312',1,'Retail Sale Id 312',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-18 17:04:12'),(305,'1','312',1,'Retail Sale Id 313',0.00,1814.58,720.00,2203.20,388.62,'2023-02-18 17:06:00'),(306,'1','312',1,'Retail Sale Id 314',0.00,4151.00,720.00,5040.00,889.00,'2023-02-18 17:09:31'),(307,'1','312',1,'Retail Sale Id 315',0.00,1779.00,720.00,2160.00,381.00,'2023-02-18 17:23:55'),(308,'1','312',1,'Retail Sale Id 316',0.00,1814.58,720.00,2203.20,388.62,'2023-02-18 17:38:35'),(309,'1','312',1,'Retail Sale Id 317',0.00,1191.93,720.00,1447.20,255.27,'2023-02-18 17:43:03'),(310,'1','312',1,'Retail Sale Id 318',0.00,5337.00,720.00,6480.00,1143.00,'2023-02-18 18:06:05'),(311,'1','312',1,'Retail Sale Id 319',0.00,4151.00,720.00,5040.00,889.00,'2023-02-18 18:08:06'),(312,'1','312',1,'Retail Sale Id 320',0.00,229734.13,675.00,261501.75,31767.62,'2023-02-18 18:13:22'),(313,'1','312',1,'Retail Sale Id 321',0.00,8895.00,720.00,10800.00,1905.00,'2023-02-18 18:17:19'),(314,'1','312',1,'Retail Sale Id 322',0.00,1571.45,720.00,1908.00,336.55,'2023-02-18 19:00:59'),(315,'1','312',1,'Retail Sale Id 323',0.00,7080.42,720.00,8596.80,1516.38,'2023-02-19 08:39:18'),(316,'1','312',1,'Retail Sale Id 324',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-19 08:51:20'),(317,'1','312',1,'Retail Sale Id 325',0.00,1779.00,720.00,2160.00,381.00,'2023-02-19 08:53:49'),(318,'1','312',1,'Retail Sale Id 326',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-19 08:56:31'),(319,'1','312',1,'Retail Sale Id 327',0.00,1648.54,720.00,2001.60,353.06,'2023-02-19 11:03:56'),(320,'1','312',1,'Retail Sale Id 328',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-19 11:05:09'),(321,'1','312',1,'Retail Sale Id 329',0.00,1233.44,720.00,1497.60,264.16,'2023-02-19 11:07:52'),(322,'1','312',1,'Retail Sale Id 330',0.00,2965.00,720.00,3600.00,635.00,'2023-02-19 11:08:46'),(323,'1','312',1,'Retail Sale Id 331',0.00,3558.00,720.00,4320.00,762.00,'2023-02-19 11:09:45'),(324,'1','312',1,'Retail Sale Id 332',0.00,2965.00,720.00,3600.00,635.00,'2023-02-19 11:11:33'),(325,'1','312',1,'Retail Sale Id 333',0.00,3558.00,720.00,4320.00,762.00,'2023-02-19 11:12:35'),(326,'1','312',1,'Retail Sale Id 334',0.00,1186.00,720.00,1440.00,254.00,'2023-02-19 11:13:37'),(327,'1','312',1,'Retail Sale Id 335',0.00,4151.00,720.00,5040.00,889.00,'2023-02-19 11:34:40'),(328,'1','312',1,'Retail Sale Id 336',0.00,6819.50,720.00,8280.00,1460.50,'2023-02-19 11:38:29'),(329,'1','312',1,'Retail Sale Id 337',0.00,1482.50,720.00,1800.00,317.50,'2023-02-19 12:01:13'),(330,'1','312',1,'Retail Sale Id 338',0.00,4151.00,720.00,5040.00,889.00,'2023-02-19 13:32:51'),(331,'1','312',1,'Retail Sale Id 339',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-19 13:43:14'),(332,'1','312',1,'Retail Sale Id 340',0.00,1779.00,720.00,2160.00,381.00,'2023-02-19 13:44:03'),(333,'1','312',1,'Retail Sale Id 341',0.00,1779.00,720.00,2160.00,381.00,'2023-02-19 13:45:02'),(334,'1','312',1,'Retail Sale Id 342',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-19 13:52:08'),(335,'1','312',1,'Retail Sale Id 343',0.00,17790.00,720.00,21600.00,3810.00,'2023-02-19 13:57:10'),(336,'1','312',1,'Retail Sale Id 344',0.00,1191.93,720.00,1447.20,255.27,'2023-02-19 15:06:09'),(337,'1','312',1,'Retail Sale Id 345',0.00,2389.79,720.00,2901.60,511.81,'2023-02-19 15:15:35'),(338,'1','312',1,'Retail Sale Id 346',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-19 15:17:00'),(339,'1','312',1,'Retail Sale Id 347',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-19 15:20:40'),(340,'1','312',1,'Retail Sale Id 348',0.00,3558.00,720.00,4320.00,762.00,'2023-02-19 16:51:35'),(341,'1','312',1,'Retail Sale Id 349',0.00,2965.00,720.00,3600.00,635.00,'2023-02-19 17:01:07'),(342,'1','312',1,'Retail Sale Id 350',0.00,2965.00,720.00,3600.00,635.00,'2023-02-19 17:45:27'),(343,'1','312',1,'Retail Sale Id 351',0.00,4151.00,720.00,5040.00,889.00,'2023-02-19 17:46:59'),(344,'1','312',1,'Retail Sale Id 352',0.00,13342.50,720.00,16200.00,2857.50,'2023-02-19 17:48:13'),(345,'1','312',1,'Retail Sale Id 353',0.00,14825.00,720.00,18000.00,3175.00,'2023-02-19 17:49:16'),(346,'1','312',1,'Retail Sale Id 354',0.00,1779.00,720.00,2160.00,381.00,'2023-02-19 17:50:39'),(347,'1','312',1,'Retail Sale Id 355',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-19 17:51:28'),(348,'1','312',1,'Retail Sale Id 356',0.00,4151.00,720.00,5040.00,889.00,'2023-02-19 17:54:00'),(349,'1','312',1,'Retail Sale Id 357',0.00,1482.50,720.00,1800.00,317.50,'2023-02-19 17:56:00'),(350,'1','312',1,'Retail Sale Id 358',0.00,1191.93,720.00,1447.20,255.27,'2023-02-19 17:58:40'),(351,'1','312',1,'Retail Sale Id 359',0.00,29650.00,720.00,36000.00,6350.00,'2023-02-19 18:04:51'),(352,'1','312',1,'Retail Sale Id 360',0.00,4447.50,720.00,5400.00,952.50,'2023-02-19 18:07:57'),(353,'1','312',1,'Retail Sale Id 361',0.00,7709.00,720.00,9360.00,1651.00,'2023-02-19 18:50:50'),(354,'1','312',1,'Retail Sale Id 362',0.00,9061.04,720.00,11001.60,1940.56,'2023-02-19 19:25:02'),(355,'1','312',1,'Return of Retail Sale Id 361',7709.00,0.00,720.00,-9360.00,-1651.00,'2023-02-19 19:27:57'),(356,'1','312',1,'Return of Retail Sale Id 354',1779.00,0.00,720.00,-2160.00,-381.00,'2023-02-19 19:35:24'),(357,'1','312',1,'Retail Sale Id 363',0.00,759.04,720.00,921.60,162.56,'2023-02-19 19:36:23'),(358,'1','312',1,'Retail Sale Id 364',0.00,2965.00,720.00,3600.00,635.00,'2023-02-21 08:02:40'),(359,'1','312',1,'Retail Sale Id 365',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-21 08:46:33'),(360,'1','312',1,'Retail Sale Id 366',0.00,3558.00,720.00,4320.00,762.00,'2023-02-21 08:47:31'),(361,'1','312',1,'Retail Sale Id 367',0.00,2472.81,720.00,3002.40,529.59,'2023-02-21 08:49:02'),(362,'1','312',1,'Retail Sale Id 368',0.00,10377.50,720.00,12600.00,2222.50,'2023-02-21 08:50:04'),(363,'1','312',1,'Retail Sale Id 369',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-21 09:01:37'),(364,'1','312',1,'Retail Sale Id 370',0.00,2965.00,720.00,3600.00,635.00,'2023-02-21 09:02:34'),(365,'1','312',1,'Retail Sale Id 371',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-21 09:18:31'),(366,'1','312',1,'Retail Sale Id 372',0.00,6523.00,720.00,7920.00,1397.00,'2023-02-21 09:20:17'),(367,'1','312',1,'Retail Sale Id 373',0.00,67204.69,720.00,81597.60,14392.91,'2023-02-21 09:50:44'),(368,'1','312',1,'Retail Sale Id 374',0.00,1814.58,720.00,2203.20,388.62,'2023-02-21 09:51:51'),(369,'1','312',1,'Retail Sale Id 376',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-21 09:53:24'),(370,'1','312',1,'Retail Sale Id 377',0.00,2965.00,720.00,3600.00,635.00,'2023-02-21 10:29:58'),(371,'1','312',1,'Retail Sale Id 378',0.00,1814.58,720.00,2203.20,388.62,'2023-02-21 11:12:53'),(372,'1','312',1,'Retail Sale Id 379',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-21 11:14:34'),(373,'1','312',1,'Retail Sale Id 380',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-21 11:54:13'),(374,'1','312',1,'Retail Sale Id 381',0.00,3558.00,720.00,4320.00,762.00,'2023-02-21 12:06:32'),(375,'1','312',1,'Retail Sale Id 382',0.00,3558.00,720.00,4320.00,762.00,'2023-02-21 12:09:04'),(376,'1','312',1,'Retail Sale Id 383',0.00,1779.00,720.00,2160.00,381.00,'2023-02-21 12:17:34'),(377,'1','312',1,'Retail Sale Id 384',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-21 12:25:53'),(378,'1','312',1,'Retail Sale Id 385',0.00,65230.00,680.00,74800.00,9570.00,'2023-02-21 12:28:38'),(379,'1','312',1,'Retail Sale Id 386',0.00,1648.54,720.00,2001.60,353.06,'2023-02-21 12:30:14'),(380,'1','312',1,'Retail Sale Id 387',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-21 12:35:55'),(381,'1','312',1,'Retail Sale Id 388',0.00,4115.42,720.00,4996.80,881.38,'2023-02-21 12:46:54'),(382,'1','312',1,'Retail Sale Id 389',0.00,1779.00,720.00,2160.00,381.00,'2023-02-21 13:10:41'),(383,'1','312',1,'Retail Sale Id 390',0.00,1779.00,720.00,2160.00,381.00,'2023-02-21 13:13:43'),(384,'1','312',1,'Retail Sale Id 391',0.00,385212.80,675.00,438480.00,53267.20,'2023-02-21 13:17:15'),(385,'1','312',1,'Retail Sale Id 392',0.00,2965.00,720.00,3600.00,635.00,'2023-02-21 13:21:02'),(386,'1','312',1,'Retail Sale Id 393',0.00,1191.93,720.00,1447.20,255.27,'2023-02-21 13:23:08'),(387,'1','312',1,'Retail Sale Id 394',0.00,593.00,720.00,720.00,127.00,'2023-02-21 13:44:32'),(388,'1','312',1,'Retail Sale Id 395',0.00,29650.00,680.00,34000.00,4350.00,'2023-02-21 13:52:44'),(389,'1','312',1,'Retail Sale Id 396',0.00,2965.00,720.00,3600.00,635.00,'2023-02-21 14:05:41'),(390,'1','312',1,'Retail Sale Id 397',0.00,1191.93,720.00,1447.20,255.27,'2023-02-21 14:15:49'),(391,'1','312',1,'Retail Sale Id 398',0.00,1814.58,720.00,2203.20,388.62,'2023-02-21 14:49:32'),(392,'1','312',1,'Retail Sale Id 399',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-21 14:56:36'),(393,'1','312',1,'Retail Sale Id 400',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-21 16:29:05'),(394,'1','312',1,'Retail Sale Id 401',0.00,2965.00,720.00,3600.00,635.00,'2023-02-21 16:30:38'),(395,'1','312',1,'Retail Sale Id 402',0.00,1779.00,720.00,2160.00,381.00,'2023-02-21 16:33:06'),(396,'1','312',1,'Retail Sale Id 403',0.00,3558.00,720.00,4320.00,762.00,'2023-02-21 16:35:36'),(397,'1','312',1,'Retail Sale Id 404',0.00,3558.00,720.00,4320.00,762.00,'2023-02-21 16:47:53'),(398,'1','312',1,'Retail Sale Id 405',0.00,1779.00,720.00,2160.00,381.00,'2023-02-21 16:55:15'),(399,'1','312',1,'Retail Sale Id 406',0.00,3558.00,720.00,4320.00,762.00,'2023-02-21 17:00:38'),(400,'1','312',1,'Retail Sale Id 407',0.00,2965.00,720.00,3600.00,635.00,'2023-02-21 17:05:22'),(401,'1','312',1,'Retail Sale Id 408',0.00,1186.00,720.00,1440.00,254.00,'2023-02-21 17:56:01'),(402,'1','312',1,'Retail Sale Id 409',0.00,3558.00,720.00,4320.00,762.00,'2023-02-21 17:59:05'),(403,'1','312',1,'Retail Sale Id 410',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-21 18:28:22'),(404,'1','312',1,'Retail Sale Id 411',0.00,3558.00,720.00,4320.00,762.00,'2023-02-21 18:48:20'),(405,'1','312',1,'Retail Sale Id 412',0.00,616.72,720.00,748.80,132.08,'2023-02-21 18:49:32'),(406,'1','312',1,'Retail Sale Id 414',0.00,2674.43,720.00,3247.20,572.77,'2023-02-21 18:57:50'),(407,'1','312',1,'Retail Sale Id 415',0.00,7003.33,720.00,8503.20,1499.87,'2023-02-21 18:59:01'),(408,'1','312',1,'Return of Retail Sale Id 410',7412.50,0.00,720.00,-9000.00,-1587.50,'2023-02-21 19:52:16'),(409,'1','312',1,'Return of Retail Sale Id 387',7412.50,0.00,720.00,-9000.00,-1587.50,'2023-02-21 19:54:35'),(410,'1','312',1,'Return of Retail Sale Id 384',7412.50,0.00,720.00,-9000.00,-1587.50,'2023-02-21 19:56:19'),(411,'1','312',1,'Return of Retail Sale Id 369',7412.50,0.00,720.00,-9000.00,-1587.50,'2023-02-21 19:57:42'),(412,'1','312',1,'Return of Retail Sale Id 368',10377.50,0.00,720.00,-12600.00,-2222.50,'2023-02-21 19:59:26'),(413,'1','312',1,'Return of Retail Sale Id 371',5930.00,0.00,720.00,-7200.00,-1270.00,'2023-02-21 20:03:56'),(414,'1','312',1,'Return of Retail Sale Id 365',5930.00,0.00,720.00,-7200.00,-1270.00,'2023-02-21 20:05:31'),(415,'1','312',1,'Return of Retail Sale Id 366',3558.00,0.00,720.00,-4320.00,-762.00,'2023-02-21 20:08:01'),(416,'1','312',1,'Return of Retail Sale Id 415',7003.33,0.00,720.00,-8503.20,-1499.87,'2023-02-21 20:08:40'),(417,'1','312',1,'Retail Sale Id 416',0.00,71160.00,680.00,81600.00,10440.00,'2023-02-21 20:13:18'),(418,'1','312',1,'Retail Sale Id 417',0.00,1191.93,720.00,1447.20,255.27,'2023-02-22 07:39:22'),(419,'1','312',1,'Retail Sale Id 418',0.00,2632.92,720.00,3196.80,563.88,'2023-02-22 08:17:05'),(420,'1','312',1,'Retail Sale Id 419',0.00,2965.00,720.00,3600.00,635.00,'2023-02-22 08:46:55'),(421,'1','312',1,'Retail Sale Id 420',0.00,2965.00,720.00,3600.00,635.00,'2023-02-22 08:48:43'),(422,'1','312',1,'Retail Sale Id 421',0.00,12352.19,720.00,14997.60,2645.41,'2023-02-22 09:01:09'),(423,'1','312',1,'Retail Sale Id 422',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-22 09:08:41'),(424,'1','312',1,'Retail Sale Id 423',0.00,2965.00,720.00,3600.00,635.00,'2023-02-22 09:39:53'),(425,'1','312',1,'Retail Sale Id 424',0.00,35580.00,680.00,40800.00,5220.00,'2023-02-22 09:41:06'),(426,'1','312',1,'Retail Sale Id 426',0.00,7821.67,720.00,9496.80,1675.13,'2023-02-22 09:55:40'),(427,'1','312',1,'Retail Sale Id 427',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-22 10:19:32'),(428,'1','312',1,'Retail Sale Id 428',0.00,2965.00,720.00,3600.00,635.00,'2023-02-22 10:22:24'),(429,'1','312',1,'Retail Sale Id 429',0.00,4151.00,720.00,5040.00,889.00,'2023-02-22 11:02:23'),(430,'1','312',1,'Retail Sale Id 430',0.00,4115.42,720.00,4996.80,881.38,'2023-02-22 11:59:08'),(431,'1','312',1,'Retail Sale Id 431',0.00,2965.00,720.00,3600.00,635.00,'2023-02-22 12:18:40'),(432,'1','312',1,'Retail Sale Id 432',0.00,2372.00,720.00,2880.00,508.00,'2023-02-22 12:38:23'),(433,'1','312',1,'Retail Sale Id 433',0.00,4151.00,720.00,5040.00,889.00,'2023-02-22 13:14:14'),(434,'1','312',1,'Retail Sale Id 435',0.00,1814.58,720.00,2203.20,388.62,'2023-02-22 13:33:59'),(435,'1','312',1,'Retail Sale Id 436',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-22 13:52:56'),(436,'1','312',1,'Retail Sale Id 437',0.00,4744.00,720.00,5760.00,1016.00,'2023-02-22 14:09:30'),(437,'1','312',1,'Retail Sale Id 438',0.00,3558.00,720.00,4320.00,762.00,'2023-02-22 14:43:10'),(438,'1','312',1,'Retail Sale Id 439',0.00,7709.00,720.00,9360.00,1651.00,'2023-02-22 14:46:02'),(439,'1','312',1,'Retail Sale Id 440',0.00,4115.42,720.00,4996.80,881.38,'2023-02-22 15:03:17'),(440,'1','312',1,'Retail Sale Id 441',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-22 15:16:06'),(441,'1','312',1,'Retail Sale Id 442',0.00,1779.00,720.00,2160.00,381.00,'2023-02-22 15:22:35'),(442,'1','312',1,'Retail Sale Id 444',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-22 15:25:23'),(443,'1','312',1,'Retail Sale Id 445',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-22 16:14:17'),(444,'1','312',1,'Retail Sale Id 446',0.00,5337.00,720.00,6480.00,1143.00,'2023-02-22 16:30:25'),(445,'1','312',1,'Retail Sale Id 447',0.00,2057.71,720.00,2498.40,440.69,'2023-02-22 16:40:27'),(446,'1','312',1,'Retail Sale Id 448',0.00,1814.58,720.00,2203.20,388.62,'2023-02-22 16:45:33'),(447,'1','312',1,'Retail Sale Id 449',0.00,2472.81,720.00,3002.40,529.59,'2023-02-22 17:25:47'),(448,'1','312',1,'Retail Sale Id 450',0.00,4198.44,720.00,5097.60,899.16,'2023-02-22 17:48:39'),(449,'1','312',1,'Retail Sale Id 451',0.00,65230.00,680.00,74800.00,9570.00,'2023-02-22 18:11:18'),(450,'1','312',1,'Retail Sale Id 452',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-22 18:44:17'),(451,'1','312',1,'Retail Sale Id 453',0.00,824.27,720.00,1000.80,176.53,'2023-02-22 18:47:47'),(452,'1','312',1,'Retail Sale Id 454',0.00,8183.40,720.00,9936.00,1752.60,'2023-02-22 19:27:22'),(453,'1','312',1,'Retail Sale Id 455',0.00,2057.71,720.00,2498.40,440.69,'2023-02-23 07:37:56'),(454,'1','312',1,'Retail Sale Id 456',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-23 07:50:04'),(455,'1','312',1,'Retail Sale Id 457',0.00,3558.00,720.00,4320.00,762.00,'2023-02-23 07:58:58'),(456,'1','312',1,'Retail Sale Id 458',0.00,2372.00,720.00,2880.00,508.00,'2023-02-23 08:13:43'),(457,'1','312',1,'Retail Sale Id 459',0.00,1186.00,720.00,1440.00,254.00,'2023-02-23 08:16:27'),(458,'1','312',1,'Retail Sale Id 460',0.00,2372.00,720.00,2880.00,508.00,'2023-02-23 08:19:05'),(459,'1','312',1,'Retail Sale Id 461',0.00,27871.00,720.00,33840.00,5969.00,'2023-02-23 08:26:31'),(460,'1','312',1,'Retail Sale Id 462',0.00,6523.00,720.00,7920.00,1397.00,'2023-02-23 08:57:49'),(461,'1','312',1,'Retail Sale Id 463',0.00,1779.00,720.00,2160.00,381.00,'2023-02-23 09:01:32'),(462,'1','312',1,'Retail Sale Id 464',0.00,2965.00,720.00,3600.00,635.00,'2023-02-23 09:03:56'),(463,'1','312',1,'Retail Sale Id 465',0.00,2965.00,720.00,3600.00,635.00,'2023-02-23 09:06:55'),(464,'1','312',1,'Retail Sale Id 466',0.00,4156.93,720.00,5047.20,890.27,'2023-02-23 09:08:31'),(465,'1','312',1,'Retail Sale Id 467',0.00,1779.00,720.00,2160.00,381.00,'2023-02-23 09:17:20'),(466,'1','312',1,'Retail Sale Id 468',0.00,3558.00,720.00,4320.00,762.00,'2023-02-23 09:19:25'),(467,'1','312',1,'Retail Sale Id 469',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-23 09:23:56'),(468,'1','312',1,'Retail Sale Id 470',0.00,4151.00,720.00,5040.00,889.00,'2023-02-23 09:45:56'),(469,'1','312',1,'Retail Sale Id 471',0.00,10081.00,720.00,12240.00,2159.00,'2023-02-23 09:51:35'),(470,'1','312',1,'Retail Sale Id 472',0.00,2389.79,720.00,2901.60,511.81,'2023-02-23 09:56:27'),(471,'1','312',1,'Retail Sale Id 473',0.00,2965.00,720.00,3600.00,635.00,'2023-02-23 09:58:02'),(472,'1','312',1,'Retail Sale Id 474',0.00,8302.00,720.00,10080.00,1778.00,'2023-02-23 10:02:01'),(473,'1','312',1,'Retail Sale Id 475',0.00,3558.00,720.00,4320.00,762.00,'2023-02-23 10:17:03'),(474,'1','312',1,'Retail Sale Id 476',0.00,10081.00,720.00,12240.00,2159.00,'2023-02-23 10:41:28'),(475,'1','312',1,'Retail Sale Id 477',0.00,2372.00,720.00,2880.00,508.00,'2023-02-23 10:49:18'),(476,'1','312',1,'Retail Sale Id 478',0.00,3558.00,720.00,4320.00,762.00,'2023-02-23 11:14:27'),(477,'1','312',1,'Retail Sale Id 479',0.00,1779.00,720.00,2160.00,381.00,'2023-02-23 11:17:38'),(478,'1','312',1,'Retail Sale Id 480',0.00,5337.00,720.00,6480.00,1143.00,'2023-02-23 11:51:44'),(479,'1','312',1,'Retail Sale Id 481',0.00,2372.00,720.00,2880.00,508.00,'2023-02-23 12:10:31'),(480,'1','312',1,'Retail Sale Id 482',0.00,2330.49,720.00,2829.60,499.11,'2023-02-23 12:54:45'),(481,'1','312',1,'Retail Sale Id 483',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-23 13:06:57'),(482,'1','312',1,'Retail Sale Id 484',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-23 13:07:42'),(483,'1','312',1,'Retail Sale Id 485',0.00,7116.00,720.00,8640.00,1524.00,'2023-02-23 13:08:32'),(484,'1','312',1,'Retail Sale Id 486',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-23 13:09:28'),(485,'1','312',1,'Retail Sale Id 487',0.00,2117.01,720.00,2570.40,453.39,'2023-02-23 13:10:48'),(486,'1','312',1,'Retail Sale Id 488',0.00,163075.00,680.00,187000.00,23925.00,'2023-02-23 13:13:29'),(487,'1','312',1,'Retail Sale Id 489',0.00,71160.00,680.00,81600.00,10440.00,'2023-02-23 13:14:30'),(488,'1','312',1,'Retail Sale Id 490',0.00,164557.50,680.00,188700.00,24142.50,'2023-02-23 13:15:55'),(489,'1','312',1,'Retail Sale Id 491',0.00,4744.00,720.00,5760.00,1016.00,'2023-02-23 14:34:50'),(490,'1','312',1,'Retail Sale Id 492',0.00,4151.00,720.00,5040.00,889.00,'2023-02-23 14:36:41'),(491,'1','312',1,'Retail Sale Id 493',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-23 14:41:04'),(492,'1','312',1,'Retail Sale Id 494',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-23 14:42:55'),(493,'1','312',1,'Retail Sale Id 495',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-23 14:46:01'),(494,'1','312',1,'Retail Sale Id 496',0.00,1186.00,720.00,1440.00,254.00,'2023-02-23 14:47:35'),(495,'1','312',1,'Retail Sale Id 497',0.00,4151.00,720.00,5040.00,889.00,'2023-02-23 14:55:56'),(496,'1','312',1,'Retail Sale Id 498',0.00,10081.00,720.00,12240.00,2159.00,'2023-02-23 15:30:15'),(497,'1','312',1,'Retail Sale Id 499',0.00,14825.00,720.00,18000.00,3175.00,'2023-02-23 15:32:56'),(498,'1','312',1,'Retail Sale Id 500',0.00,2965.00,720.00,3600.00,635.00,'2023-02-23 15:35:00'),(499,'1','312',1,'Retail Sale Id 501',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-23 15:39:36'),(500,'1','312',1,'Retail Sale Id 502',0.00,3558.00,720.00,4320.00,762.00,'2023-02-23 15:56:57'),(501,'1','312',1,'Retail Sale Id 503',0.00,4151.00,720.00,5040.00,889.00,'2023-02-23 16:01:06'),(502,'1','312',1,'Retail Sale Id 504',0.00,1186.00,720.00,1440.00,254.00,'2023-02-23 16:32:06'),(503,'1','312',1,'Retail Sale Id 505',0.00,1482.50,720.00,1800.00,317.50,'2023-02-23 16:38:00'),(504,'1','312',1,'Retail Sale Id 506',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-23 16:43:08'),(505,'1','312',1,'Retail Sale Id 507',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-23 16:44:59'),(506,'1','312',1,'Retail Sale Id 508',0.00,1186.00,720.00,1440.00,254.00,'2023-02-23 16:48:30'),(507,'1','312',1,'Retail Sale Id 509',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-23 17:03:05'),(508,'1','312',1,'Retail Sale Id 510',0.00,18383.00,680.00,21080.00,2697.00,'2023-02-23 17:07:58'),(509,'1','312',1,'Retail Sale Id 511',0.00,1186.00,720.00,1440.00,254.00,'2023-02-23 17:18:05'),(510,'1','312',1,'Retail Sale Id 512',0.00,3558.00,720.00,4320.00,762.00,'2023-02-23 17:34:48'),(511,'1','312',1,'Retail Sale Id 513',0.00,1814.58,720.00,2203.20,388.62,'2023-02-23 17:39:40'),(512,'1','312',1,'Retail Sale Id 514',0.00,593.00,9000.00,9000.00,8407.00,'2023-02-23 17:58:23'),(513,'1','312',1,'Retail Sale Id 515',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-23 18:04:41'),(514,'1','312',1,'Retail Sale Id 516',0.00,1186.00,720.00,1440.00,254.00,'2023-02-23 18:40:33'),(515,'1','312',1,'Retail Sale Id 517',0.00,3558.00,720.00,4320.00,762.00,'2023-02-23 18:43:02'),(516,'1','312',1,'Retail Sale Id 518',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-23 18:44:06'),(517,'1','312',1,'Retail Sale Id 519',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-23 18:51:31'),(518,'1','312',1,'Retail Sale Id 521',0.00,2965.00,720.00,3600.00,635.00,'2023-02-23 18:56:14'),(519,'1','312',1,'Retail Sale Id 522',0.00,4275.53,720.00,5191.20,915.67,'2023-02-23 19:13:46'),(520,'1','312',1,'Retail Sale Id 523',0.00,11860.00,720.00,14400.00,2540.00,'2023-02-23 19:14:31'),(521,'1','312',1,'Retail Sale Id 524',0.00,11860.00,720.00,14400.00,2540.00,'2023-02-23 19:15:11'),(522,'1','312',1,'Return of Retail Sale Id 510',18383.00,0.00,680.00,-21080.00,-2697.00,'2023-02-23 19:18:47'),(523,'1','312',1,'Retail Sale Id 525',0.00,17754.42,680.00,20359.20,2604.78,'2023-02-23 19:19:52'),(524,'1','312',1,'Retail Sale Id 526',0.00,4981.20,720.00,6048.00,1066.80,'2023-02-24 08:22:18'),(525,'1','312',1,'Retail Sale Id 527',0.00,4115.42,720.00,4996.80,881.38,'2023-02-24 08:45:37'),(526,'1','312',1,'Retail Sale Id 528',0.00,8895.00,720.00,10800.00,1905.00,'2023-02-24 08:47:53'),(527,'1','312',1,'Retail Sale Id 529',0.00,2372.00,720.00,2880.00,508.00,'2023-02-24 08:53:10'),(528,'1','312',1,'Retail Sale Id 530',0.00,2965.00,720.00,3600.00,635.00,'2023-02-24 08:59:35'),(529,'1','312',1,'Retail Sale Id 531',0.00,8895.00,720.00,10800.00,1905.00,'2023-02-24 09:03:08'),(530,'1','312',1,'Retail Sale Id 532',0.00,2965.00,720.00,3600.00,635.00,'2023-02-24 09:33:17'),(531,'1','312',1,'Retail Sale Id 533',0.00,13342.50,720.00,16200.00,2857.50,'2023-02-24 09:45:24'),(532,'1','312',1,'Retail Sale Id 534',0.00,4151.00,720.00,5040.00,889.00,'2023-02-24 09:57:36'),(533,'1','312',1,'Retail Sale Id 535',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-24 10:05:59'),(534,'1','312',1,'Retail Sale Id 536',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-24 10:18:39'),(535,'1','312',1,'Retail Sale Id 537',0.00,3558.00,720.00,4320.00,762.00,'2023-02-24 10:40:31'),(536,'1','312',1,'Retail Sale Id 538',0.00,2472.81,720.00,3002.40,529.59,'2023-02-24 10:43:58'),(537,'1','312',1,'Retail Sale Id 539',0.00,2372.00,720.00,2880.00,508.00,'2023-02-24 11:18:23'),(538,'1','312',1,'Retail Sale Id 540',0.00,3558.00,720.00,4320.00,762.00,'2023-02-24 11:21:42'),(539,'1','312',1,'Retail Sale Id 541',0.00,5337.00,720.00,6480.00,1143.00,'2023-02-24 11:34:39'),(540,'1','312',1,'Retail Sale Id 542',0.00,2965.00,720.00,3600.00,635.00,'2023-02-24 11:41:44'),(541,'1','312',1,'Retail Sale Id 543',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-24 11:43:35'),(542,'1','312',1,'Retail Sale Id 545',0.00,2965.00,720.00,3600.00,635.00,'2023-02-24 12:11:31'),(543,'1','312',1,'Retail Sale Id 546',0.00,2372.00,720.00,2880.00,508.00,'2023-02-24 12:17:14'),(544,'1','312',1,'Retail Sale Id 547',0.00,4151.00,720.00,5040.00,889.00,'2023-02-24 12:23:02'),(545,'1','312',1,'Retail Sale Id 548',0.00,3558.00,720.00,4320.00,762.00,'2023-02-24 12:39:07'),(546,'1','312',1,'Retail Sale Id 549',0.00,7116.00,720.00,8640.00,1524.00,'2023-02-24 12:42:12'),(547,'1','312',1,'Retail Sale Id 550',0.00,1779.00,720.00,2160.00,381.00,'2023-02-24 12:56:04'),(548,'1','312',1,'Retail Sale Id 551',0.00,4151.00,720.00,5040.00,889.00,'2023-02-24 13:08:48'),(549,'1','312',1,'Retail Sale Id 552',0.00,3558.00,720.00,4320.00,762.00,'2023-02-24 13:16:20'),(550,'1','312',1,'Retail Sale Id 553',0.00,3558.00,720.00,4320.00,762.00,'2023-02-24 13:22:23'),(551,'1','312',1,'Retail Sale Id 554',0.00,6523.00,720.00,7920.00,1397.00,'2023-02-24 13:25:49'),(552,'1','312',1,'Retail Sale Id 555',0.00,14825.00,720.00,18000.00,3175.00,'2023-02-24 13:28:58'),(553,'1','312',1,'Retail Sale Id 556',0.00,4151.00,720.00,5040.00,889.00,'2023-02-24 13:37:17'),(554,'1','312',1,'Retail Sale Id 557',0.00,1648.54,720.00,2001.60,353.06,'2023-02-24 13:44:41'),(555,'1','312',1,'Retail Sale Id 558',0.00,2372.00,720.00,2880.00,508.00,'2023-02-24 13:58:18'),(556,'1','312',1,'Retail Sale Id 559',0.00,2965.00,720.00,3600.00,635.00,'2023-02-24 14:00:45'),(557,'1','312',1,'Retail Sale Id 560',0.00,1779.00,720.00,2160.00,381.00,'2023-02-24 14:03:15'),(558,'1','312',1,'Retail Sale Id 561',0.00,3854.50,720.00,4680.00,825.50,'2023-02-24 14:05:16'),(559,'1','312',1,'Retail Sale Id 562',0.00,2372.00,720.00,2880.00,508.00,'2023-02-24 14:30:06'),(560,'1','312',1,'Retail Sale Id 563',0.00,14825.00,720.00,18000.00,3175.00,'2023-02-24 14:35:03'),(561,'1','312',1,'Retail Sale Id 564',0.00,14825.00,720.00,18000.00,3175.00,'2023-02-24 15:20:56'),(562,'1','312',1,'Retail Sale Id 565',0.00,8598.50,720.00,10440.00,1841.50,'2023-02-24 15:26:10'),(563,'1','312',1,'Retail Sale Id 566',0.00,2372.00,720.00,2880.00,508.00,'2023-02-24 15:29:04'),(564,'1','312',1,'Retail Sale Id 567',0.00,2372.00,720.00,2880.00,508.00,'2023-02-24 15:42:00'),(565,'1','312',1,'Retail Sale Id 568',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-24 15:44:51'),(566,'1','312',1,'Retail Sale Id 569',0.00,3854.50,720.00,4680.00,825.50,'2023-02-24 15:46:40'),(567,'1','312',1,'Retail Sale Id 570',0.00,2965.00,720.00,3600.00,635.00,'2023-02-24 15:52:44'),(568,'1','312',1,'Retail Sale Id 571',0.00,2965.00,720.00,3600.00,635.00,'2023-02-24 15:56:19'),(569,'1','312',1,'Retail Sale Id 572',0.00,1186.00,720.00,1440.00,254.00,'2023-02-24 16:00:56'),(570,'1','312',1,'Retail Sale Id 573',0.00,4151.00,720.00,5040.00,889.00,'2023-02-24 16:05:30'),(571,'1','312',1,'Retail Sale Id 574',0.00,1779.00,720.00,2160.00,381.00,'2023-02-24 16:14:34'),(572,'1','312',1,'Retail Sale Id 575',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-24 16:59:04'),(573,'1','312',1,'Retail Sale Id 576',0.00,1186.00,720.00,1440.00,254.00,'2023-02-24 17:06:44'),(574,'1','312',1,'Retail Sale Id 577',0.00,3558.00,720.00,4320.00,762.00,'2023-02-24 17:16:05'),(575,'1','312',1,'Retail Sale Id 578',0.00,1779.00,720.00,2160.00,381.00,'2023-02-24 17:24:02'),(576,'1','312',1,'Retail Sale Id 579',0.00,1779.00,720.00,2160.00,381.00,'2023-02-24 17:25:04'),(577,'1','312',1,'Retail Sale Id 580',0.00,2372.00,720.00,2880.00,508.00,'2023-02-24 17:27:19'),(578,'1','312',1,'Retail Sale Id 582',0.00,8895.00,720.00,10800.00,1905.00,'2023-02-24 17:29:19'),(579,'1','312',1,'Retail Sale Id 583',0.00,4151.00,720.00,5040.00,889.00,'2023-02-24 17:30:18'),(580,'1','312',1,'Retail Sale Id 584',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-24 17:33:19'),(581,'1','312',1,'Retail Sale Id 585',0.00,4151.00,720.00,5040.00,889.00,'2023-02-24 17:35:32'),(582,'1','312',1,'Retail Sale Id 586',0.00,10081.00,720.00,12240.00,2159.00,'2023-02-24 17:37:20'),(583,'1','312',1,'Retail Sale Id 587',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-24 17:38:06'),(584,'1','312',1,'Retail Sale Id 589',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-24 17:42:48'),(585,'1','312',1,'Retail Sale Id 590',0.00,6819.50,720.00,8280.00,1460.50,'2023-02-24 17:45:10'),(586,'1','312',1,'Retail Sale Id 591',0.00,1186.00,720.00,1440.00,254.00,'2023-02-24 17:48:17'),(587,'1','312',1,'Retail Sale Id 592',0.00,6523.00,720.00,7920.00,1397.00,'2023-02-24 17:49:47'),(588,'1','312',1,'Retail Sale Id 593',0.00,1186.00,720.00,1440.00,254.00,'2023-02-24 18:04:36'),(589,'1','312',1,'Retail Sale Id 594',0.00,4151.00,720.00,5040.00,889.00,'2023-02-24 18:10:23'),(590,'1','312',1,'Retail Sale Id 595',0.00,5337.00,720.00,6480.00,1143.00,'2023-02-24 18:11:37'),(591,'1','312',1,'Retail Sale Id 597',0.00,1779.00,720.00,2160.00,381.00,'2023-02-24 18:13:20'),(592,'1','312',1,'Retail Sale Id 598',0.00,2965.00,720.00,3600.00,635.00,'2023-02-24 18:14:13'),(593,'1','312',1,'Retail Sale Id 599',0.00,2389.79,720.00,2901.60,511.81,'2023-02-24 18:15:41'),(594,'1','312',1,'Retail Sale Id 600',0.00,2965.00,720.00,3600.00,635.00,'2023-02-24 18:22:31'),(595,'1','312',1,'Retail Sale Id 601',0.00,4447.50,720.00,5400.00,952.50,'2023-02-24 18:33:33'),(596,'1','312',1,'Retail Sale Id 602',0.00,13639.00,720.00,16560.00,2921.00,'2023-02-24 18:40:19'),(597,'1','312',1,'Retail Sale Id 603',0.00,2389.79,720.00,2901.60,511.81,'2023-02-24 18:43:11'),(598,'1','312',1,'Retail Sale Id 604',0.00,281313.27,675.00,320213.25,38899.98,'2023-02-24 18:57:47'),(599,'1','312',1,'Retail Sale Id 605',0.00,1779.00,720.00,2160.00,381.00,'2023-02-28 08:05:11'),(600,'1','312',1,'Retail Sale Id 606',0.00,1814.58,720.00,2203.20,388.62,'2023-02-28 08:40:45'),(601,'1','312',1,'Retail Sale Id 607',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-28 08:42:36'),(602,'1','312',1,'Retail Sale Id 608',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-28 08:44:53'),(603,'1','312',1,'Retail Sale Id 609',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-28 08:53:53'),(604,'1','312',1,'Retail Sale Id 610',0.00,1186.00,720.00,1440.00,254.00,'2023-02-28 09:28:23'),(605,'1','312',1,'Retail Sale Id 611',0.00,3558.00,720.00,4320.00,762.00,'2023-02-28 09:34:03'),(606,'1','312',1,'Retail Sale Id 612',0.00,2965.00,720.00,3600.00,635.00,'2023-02-28 09:59:45'),(607,'1','312',1,'Retail Sale Id 613',0.00,2372.00,720.00,2880.00,508.00,'2023-02-28 10:00:55'),(608,'1','312',1,'Retail Sale Id 614',0.00,593.00,720.00,720.00,127.00,'2023-02-28 10:02:10'),(609,'1','312',1,'Retail Sale Id 615',0.00,3558.00,720.00,4320.00,762.00,'2023-02-28 10:21:10'),(610,'1','312',1,'Retail Sale Id 616',0.00,4151.00,720.00,5040.00,889.00,'2023-02-28 11:11:40'),(611,'1','312',1,'Retail Sale Id 617',0.00,4151.00,720.00,5040.00,889.00,'2023-02-28 11:18:20'),(612,'1','312',1,'Retail Sale Id 618',0.00,4151.00,720.00,5040.00,889.00,'2023-02-28 11:20:48'),(613,'1','312',1,'Retail Sale Id 619',0.00,2965.00,720.00,3600.00,635.00,'2023-02-28 11:57:30'),(614,'1','312',1,'Retail Sale Id 620',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-28 12:09:04'),(615,'1','312',1,'Retail Sale Id 621',0.00,1779.00,720.00,2160.00,381.00,'2023-02-28 12:29:11'),(616,'1','312',1,'Retail Sale Id 622',0.00,1233.44,720.00,1497.60,264.16,'2023-02-28 12:48:46'),(617,'1','312',1,'Retail Sale Id 623',0.00,2965.00,720.00,3600.00,635.00,'2023-02-28 13:52:22'),(618,'1','312',1,'Retail Sale Id 624',0.00,7116.00,720.00,8640.00,1524.00,'2023-02-28 13:55:08'),(619,'1','312',1,'Retail Sale Id 625',0.00,6523.00,720.00,7920.00,1397.00,'2023-02-28 14:20:06'),(620,'1','312',1,'Retail Sale Id 626',0.00,6570.44,720.00,7977.60,1407.16,'2023-02-28 14:43:25'),(621,'1','312',1,'Retail Sale Id 627',0.00,1186.00,720.00,1440.00,254.00,'2023-02-28 15:52:42'),(622,'1','312',1,'Retail Sale Id 628',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-28 16:05:15'),(623,'1','312',1,'Retail Sale Id 629',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-28 16:43:10'),(624,'1','312',1,'Retail Sale Id 630',0.00,824.27,720.00,1000.80,176.53,'2023-02-28 16:47:48'),(625,'1','312',1,'Retail Sale Id 631',0.00,366444.35,675.00,417116.25,50671.90,'2023-02-28 19:14:03'),(626,'1','312',1,'Retail Sale Id 632',0.00,19100.53,720.00,23191.20,4090.67,'2023-02-28 19:16:51'),(627,'1','312',1,'Retail Sale Id 633',0.00,4151.00,720.00,5040.00,889.00,'2023-03-01 07:49:42'),(628,'1','312',1,'Retail Sale Id 634',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-01 07:59:30'),(629,'1','312',1,'Retail Sale Id 635',0.00,1779.00,720.00,2160.00,381.00,'2023-03-01 08:16:33'),(630,'1','312',1,'Retail Sale Id 636',0.00,3854.50,720.00,4680.00,825.50,'2023-03-01 08:24:27'),(631,'1','312',1,'Retail Sale Id 637',0.00,4151.00,720.00,5040.00,889.00,'2023-03-01 08:37:51'),(632,'1','312',1,'Retail Sale Id 638',0.00,4939.69,720.00,5997.60,1057.91,'2023-03-01 08:49:45'),(633,'1','312',1,'Retail Sale Id 639',0.00,4151.00,720.00,5040.00,889.00,'2023-03-01 08:57:52'),(634,'1','312',1,'Retail Sale Id 640',0.00,5930.00,720.00,7200.00,1270.00,'2023-03-01 09:43:42'),(635,'1','312',1,'Retail Sale Id 641',0.00,2372.00,720.00,2880.00,508.00,'2023-03-01 10:27:16'),(636,'1','312',1,'Retail Sale Id 642',0.00,3706.25,720.00,4500.00,793.75,'2023-03-01 10:41:36'),(637,'1','312',1,'Retail Sale Id 643',0.00,4151.00,720.00,5040.00,889.00,'2023-03-01 10:44:03'),(638,'1','312',1,'Retail Sale Id 644',0.00,3558.00,720.00,4320.00,762.00,'2023-03-01 10:50:54'),(639,'1','312',1,'Retail Sale Id 645',0.00,2965.00,720.00,3600.00,635.00,'2023-03-01 12:16:06'),(640,'1','312',1,'Retail Sale Id 646',0.00,2965.00,720.00,3600.00,635.00,'2023-03-01 12:49:59'),(641,'1','312',1,'Retail Sale Id 647',0.00,1779.00,720.00,2160.00,381.00,'2023-03-01 14:20:52'),(642,'1','312',1,'Retail Sale Id 648',0.00,3558.00,720.00,4320.00,762.00,'2023-03-01 14:36:25'),(643,'1','312',1,'Retail Sale Id 649',0.00,2372.00,720.00,2880.00,508.00,'2023-03-01 15:08:05'),(644,'1','312',1,'Retail Sale Id 650',0.00,3297.08,720.00,4003.20,706.12,'2023-03-01 15:10:14'),(645,'1','312',1,'Retail Sale Id 651',0.00,1779.00,720.00,2160.00,381.00,'2023-03-01 17:38:29'),(646,'1','312',1,'Retail Sale Id 652',0.00,1779.00,720.00,2160.00,381.00,'2023-03-01 17:40:25'),(647,'1','312',1,'Retail Sale Id 654',0.00,2372.00,720.00,2880.00,508.00,'2023-03-01 17:42:49'),(648,'1','312',1,'Retail Sale Id 655',0.00,3558.00,720.00,4320.00,762.00,'2023-03-01 17:51:56'),(649,'1','312',1,'Retail Sale Id 656',0.00,4151.00,720.00,5040.00,889.00,'2023-03-01 18:13:20'),(650,'1','312',1,'Retail Sale Id 657',0.00,2472.81,720.00,3002.40,529.59,'2023-03-01 18:22:55'),(651,'1','312',1,'Retail Sale Id 658',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-01 18:24:06'),(652,'1','312',1,'Retail Sale Id 659',0.00,1779.00,720.00,2160.00,381.00,'2023-03-01 18:33:57'),(653,'1','312',1,'Retail Sale Id 660',0.00,1814.58,720.00,2203.20,388.62,'2023-03-01 18:45:07'),(654,'1','312',1,'Retail Sale Id 661',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-01 18:49:46'),(655,'1','312',1,'Retail Sale Id 662',0.00,414767.92,675.00,472122.00,57354.08,'2023-03-01 19:05:30'),(656,'1','312',1,'Retail Sale Id 663',0.00,2929.42,720.00,3556.80,627.38,'2023-03-01 19:08:42'),(657,'1','312',1,'Retail Sale Id 664',0.00,17790.00,720.00,21600.00,3810.00,'2023-03-01 19:09:22'),(658,'1','312',1,'Retail Sale Id 665',0.00,4115.42,720.00,4996.80,881.38,'2023-03-02 08:28:18'),(659,'1','312',1,'Retail Sale Id 666',0.00,3558.00,720.00,4320.00,762.00,'2023-03-02 08:48:11'),(660,'1','312',1,'Retail Sale Id 667',0.00,4151.00,720.00,5040.00,889.00,'2023-03-02 08:57:31'),(661,'1','312',1,'Retail Sale Id 668',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-02 09:08:51'),(662,'1','312',1,'Retail Sale Id 669',0.00,4151.00,720.00,5040.00,889.00,'2023-03-02 09:12:15'),(663,'1','312',1,'Retail Sale Id 670',0.00,593.00,720.00,720.00,127.00,'2023-03-02 09:35:32'),(664,'1','312',1,'Retail Sale Id 671',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-02 10:00:58'),(665,'1','312',1,'Retail Sale Id 672',0.00,1648.54,720.00,2001.60,353.06,'2023-03-02 10:04:18'),(666,'1','312',1,'Retail Sale Id 673',0.00,1779.00,720.00,2160.00,381.00,'2023-03-02 10:08:51'),(667,'1','312',1,'Retail Sale Id 674',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-02 11:05:44'),(668,'1','312',1,'Retail Sale Id 675',0.00,1186.00,720.00,1440.00,254.00,'2023-03-02 11:16:23'),(669,'1','312',1,'Retail Sale Id 676',0.00,1779.00,720.00,2160.00,381.00,'2023-03-02 11:52:20'),(670,'1','312',1,'Retail Sale Id 677',0.00,1779.00,720.00,2160.00,381.00,'2023-03-02 12:20:46'),(671,'1','312',1,'Retail Sale Id 678',0.00,1814.58,720.00,2203.20,388.62,'2023-03-02 12:23:03'),(672,'1','312',1,'Retail Sale Id 679',0.00,5930.00,720.00,7200.00,1270.00,'2023-03-02 12:40:44'),(673,'1','312',1,'Retail Sale Id 680',0.00,2965.00,720.00,3600.00,635.00,'2023-03-02 12:42:38'),(674,'1','312',1,'Retail Sale Id 681',0.00,5930.00,720.00,7200.00,1270.00,'2023-03-02 13:45:37'),(675,'1','312',1,'Retail Sale Id 682',0.00,3558.00,720.00,4320.00,762.00,'2023-03-02 13:47:46'),(676,'1','312',1,'Retail Sale Id 683',0.00,2472.81,720.00,3002.40,529.59,'2023-03-02 14:02:01'),(677,'1','312',1,'Retail Sale Id 684',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-02 15:00:30'),(678,'1','312',1,'Retail Sale Id 685',0.00,3297.08,720.00,4003.20,706.12,'2023-03-02 15:03:16'),(679,'1','312',1,'Retail Sale Id 686',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-02 15:27:15'),(680,'1','312',1,'Retail Sale Id 687',0.00,3558.00,720.00,4320.00,762.00,'2023-03-02 15:35:56'),(681,'1','312',1,'Retail Sale Id 688',0.00,4151.00,720.00,5040.00,889.00,'2023-03-02 15:37:34'),(682,'1','312',1,'Retail Sale Id 689',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-02 16:09:45'),(683,'1','312',1,'Retail Sale Id 690',0.00,4151.00,720.00,5040.00,889.00,'2023-03-02 16:13:50'),(684,'1','312',1,'Retail Sale Id 691',0.00,3297.08,720.00,4003.20,706.12,'2023-03-02 16:34:04'),(685,'1','312',1,'Retail Sale Id 692',0.00,4151.00,720.00,5040.00,889.00,'2023-03-02 16:43:08'),(686,'1','312',1,'Retail Sale Id 693',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-02 17:01:11'),(687,'1','312',1,'Retail Sale Id 694',0.00,1779.00,720.00,2160.00,381.00,'2023-03-02 17:35:47'),(688,'1','312',1,'Retail Sale Id 695',0.00,1779.00,720.00,2160.00,381.00,'2023-03-02 17:38:00'),(689,'1','312',1,'Retail Sale Id 696',0.00,3558.00,720.00,4320.00,762.00,'2023-03-02 17:51:30'),(690,'1','312',1,'Retail Sale Id 697',0.00,4151.00,720.00,5040.00,889.00,'2023-03-02 18:06:42'),(691,'1','312',1,'Retail Sale Id 698',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-02 18:15:07'),(692,'1','312',1,'Retail Sale Id 699',0.00,4151.00,720.00,5040.00,889.00,'2023-03-02 18:16:33'),(693,'1','312',1,'Retail Sale Id 700',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-02 18:23:03'),(694,'1','312',1,'Retail Sale Id 701',0.00,71160.00,680.00,81600.00,10440.00,'2023-03-02 19:06:31'),(695,'1','312',1,'Retail Sale Id 702',0.00,29650.00,680.00,34000.00,4350.00,'2023-03-02 19:07:25'),(696,'1','312',1,'Retail Sale Id 703',0.00,4151.00,720.00,5040.00,889.00,'2023-03-03 09:22:59'),(697,'1','312',1,'Retail Sale Id 705',0.00,1779.00,720.00,2160.00,381.00,'2023-03-03 10:18:12'),(698,'1','312',1,'Retail Sale Id 706',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-03 10:56:01'),(699,'1','312',1,'Retail Sale Id 707',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-03 11:24:39'),(700,'1','312',1,'Retail Sale Id 708',0.00,3558.00,720.00,4320.00,762.00,'2023-03-03 11:27:53'),(701,'1','312',1,'Retail Sale Id 709',0.00,1779.00,720.00,2160.00,381.00,'2023-03-03 11:45:05'),(702,'1','312',1,'Retail Sale Id 710',0.00,2372.00,720.00,2880.00,508.00,'2023-03-03 12:00:08'),(703,'1','312',1,'Retail Sale Id 711',0.00,6523.00,720.00,7920.00,1397.00,'2023-03-03 12:04:03'),(704,'1','312',1,'Retail Sale Id 712',0.00,4151.00,720.00,5040.00,889.00,'2023-03-03 12:22:01'),(705,'1','312',1,'Retail Sale Id 713',0.00,1779.00,720.00,2160.00,381.00,'2023-03-03 12:42:37'),(706,'1','312',1,'Retail Sale Id 714',0.00,3558.00,720.00,4320.00,762.00,'2023-03-03 13:33:45'),(707,'1','312',1,'Retail Sale Id 715',0.00,1779.00,720.00,2160.00,381.00,'2023-03-03 13:44:29'),(708,'1','312',1,'Retail Sale Id 716',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-03 13:56:08'),(709,'1','312',1,'Retail Sale Id 717',0.00,1779.00,720.00,2160.00,381.00,'2023-03-03 14:09:15'),(710,'1','312',1,'Retail Sale Id 718',0.00,2372.00,720.00,2880.00,508.00,'2023-03-03 14:22:15'),(711,'1','312',1,'Retail Sale Id 719',0.00,2372.00,720.00,2880.00,508.00,'2023-03-03 14:49:55'),(712,'1','312',1,'Retail Sale Id 720',0.00,1186.00,720.00,1440.00,254.00,'2023-03-03 15:14:28'),(713,'1','312',1,'Retail Sale Id 721',0.00,1233.44,720.00,1497.60,264.16,'2023-03-03 15:40:32'),(714,'1','312',1,'Retail Sale Id 722',0.00,4151.00,720.00,5040.00,889.00,'2023-03-03 15:48:07'),(715,'1','312',1,'Retail Sale Id 723',0.00,4151.00,720.00,5040.00,889.00,'2023-03-03 15:50:40'),(716,'1','312',1,'Retail Sale Id 724',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-03 16:03:10'),(717,'1','312',1,'Retail Sale Id 725',0.00,3558.00,720.00,4320.00,762.00,'2023-03-03 16:05:53'),(718,'1','312',1,'Retail Sale Id 726',0.00,5930.00,720.00,7200.00,1270.00,'2023-03-03 16:34:41'),(719,'1','312',1,'Retail Sale Id 727',0.00,2057.71,720.00,2498.40,440.69,'2023-03-03 16:36:42'),(720,'1','312',1,'Retail Sale Id 728',0.00,5930.00,720.00,7200.00,1270.00,'2023-03-03 16:38:54'),(721,'1','312',1,'Retail Sale Id 729',0.00,2965.00,720.00,3600.00,635.00,'2023-03-03 16:42:56'),(722,'1','312',1,'Retail Sale Id 730',0.00,4151.00,720.00,5040.00,889.00,'2023-03-03 16:52:27'),(723,'1','312',1,'Retail Sale Id 731',0.00,35580.00,680.00,40800.00,5220.00,'2023-03-03 19:19:23'),(724,'1','312',1,'Retail Sale Id 732',0.00,35580.00,680.00,40800.00,5220.00,'2023-03-03 19:20:07'),(725,'1','312',1,'Retail Sale Id 733',0.00,13342.50,720.00,16200.00,2857.50,'2023-03-03 19:22:12'),(726,'1','312',1,'Retail Sale Id 734',0.00,3558.00,720.00,4320.00,762.00,'2023-03-04 08:00:22'),(727,'1','312',1,'Retail Sale Id 736',0.00,2372.00,720.00,2880.00,508.00,'2023-03-04 08:09:46'),(728,'1','312',1,'Retail Sale Id 737',0.00,5763.96,720.00,6998.40,1234.44,'2023-03-04 08:19:24'),(729,'1','312',1,'Retail Sale Id 738',0.00,1186.00,720.00,1440.00,254.00,'2023-03-04 08:23:53'),(730,'1','312',1,'Retail Sale Id 739',0.00,1186.00,720.00,1440.00,254.00,'2023-03-04 08:26:02'),(731,'1','312',1,'Retail Sale Id 740',0.00,3558.00,720.00,4320.00,762.00,'2023-03-04 08:42:05'),(732,'1','312',1,'Retail Sale Id 741',0.00,3558.00,720.00,4320.00,762.00,'2023-03-04 08:50:01'),(733,'1','312',1,'Retail Sale Id 742',0.00,2965.00,720.00,3600.00,635.00,'2023-03-04 09:03:47'),(734,'1','312',1,'Retail Sale Id 743',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-04 09:29:10'),(735,'1','312',1,'Retail Sale Id 744',0.00,3297.08,720.00,4003.20,706.12,'2023-03-04 09:33:25'),(736,'1','312',1,'Retail Sale Id 745',0.00,3581.72,720.00,4348.80,767.08,'2023-03-04 09:36:03'),(737,'1','312',1,'Retail Sale Id 746',0.00,6523.00,720.00,7920.00,1397.00,'2023-03-04 09:43:38'),(738,'1','312',1,'Retail Sale Id 747',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-04 09:47:59'),(739,'1','312',1,'Retail Sale Id 748',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-04 09:59:46'),(740,'1','312',1,'Retail Sale Id 749',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-04 10:15:51'),(741,'1','312',1,'Retail Sale Id 750',0.00,112670.00,680.00,129200.00,16530.00,'2023-03-04 10:16:46'),(742,'1','312',1,'Retail Sale Id 751',0.00,4151.00,720.00,5040.00,889.00,'2023-03-04 10:25:52'),(743,'1','312',1,'Retail Sale Id 752',0.00,5930.00,720.00,7200.00,1270.00,'2023-03-04 10:38:42'),(744,'1','312',1,'Retail Sale Id 753',0.00,1779.00,720.00,2160.00,381.00,'2023-03-04 10:51:55'),(745,'1','312',1,'Retail Sale Id 754',0.00,2472.81,720.00,3002.40,529.59,'2023-03-04 10:57:22'),(746,'1','312',1,'Retail Sale Id 755',0.00,4198.44,720.00,5097.60,899.16,'2023-03-04 11:01:52'),(747,'1','312',1,'Retail Sale Id 756',0.00,2965.00,720.00,3600.00,635.00,'2023-03-04 11:27:36'),(748,'1','312',1,'Retail Sale Id 757',0.00,1814.58,720.00,2203.20,388.62,'2023-03-04 11:50:37'),(749,'1','312',1,'Retail Sale Id 758',0.00,2372.00,720.00,2880.00,508.00,'2023-03-04 12:02:20'),(750,'1','312',1,'Retail Sale Id 759',0.00,9488.00,720.00,11520.00,2032.00,'2023-03-04 12:19:28'),(751,'1','312',1,'Retail Sale Id 760',0.00,1310.53,720.00,1591.20,280.67,'2023-03-04 12:29:30'),(752,'1','312',1,'Retail Sale Id 761',0.00,9885.31,720.00,12002.40,2117.09,'2023-03-04 12:34:58'),(753,'1','312',1,'Retail Sale Id 762',0.00,6710.00,720.00,7920.00,1210.00,'2023-03-08 09:06:37'),(754,'1','312',1,'Retail Sale Id 763',0.00,1830.00,720.00,2160.00,330.00,'2023-03-08 09:13:12'),(755,'1','312',1,'Retail Sale Id 764',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-08 09:14:40'),(756,'1','312',1,'Retail Sale Id 765',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-08 12:48:10'),(757,'1','312',1,'Retail Sale Id 766',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-08 12:52:46'),(758,'1','312',1,'Retail Sale Id 767',0.00,3660.00,720.00,4320.00,660.00,'2023-03-08 12:58:19'),(759,'1','312',1,'Retail Sale Id 768',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-08 13:01:10'),(760,'1','312',1,'Retail Sale Id 769',0.00,155855.00,675.00,172462.50,16607.50,'2023-03-08 13:13:36'),(761,'1','312',1,'Retail Sale Id 770',0.00,1830.00,720.00,2160.00,330.00,'2023-03-08 13:14:54'),(762,'1','312',1,'Retail Sale Id 771',0.00,2440.00,720.00,2880.00,440.00,'2023-03-08 13:15:45'),(763,'1','312',1,'Retail Sale Id 772',0.00,1220.00,720.00,1440.00,220.00,'2023-03-08 13:16:48'),(764,'1','312',1,'Retail Sale Id 773',0.00,3660.00,720.00,4320.00,660.00,'2023-03-08 13:17:54'),(765,'1','312',1,'Retail Sale Id 774',0.00,18300.00,680.00,20400.00,2100.00,'2023-03-08 13:41:30'),(766,'1','312',1,'Retail Sale Id 775',0.00,3660.00,720.00,4320.00,660.00,'2023-03-08 14:21:49'),(767,'1','312',1,'Retail Sale Id 776',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-08 14:59:20'),(768,'1','312',1,'Retail Sale Id 777',0.00,3660.00,720.00,4320.00,660.00,'2023-03-08 15:03:08'),(769,'1','312',1,'Retail Sale Id 779',0.00,1830.00,720.00,2160.00,330.00,'2023-03-08 15:06:19'),(770,'1','312',1,'Retail Sale Id 780',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-08 15:23:43'),(771,'1','312',1,'Retail Sale Id 786',0.00,2031.30,720.00,2397.60,366.30,'2023-03-08 16:25:56'),(772,'1','312',1,'Retail Sale Id 787',0.00,3391.60,720.00,4003.20,611.60,'2023-03-08 16:31:50'),(773,'1','312',1,'Retail Sale Id 781',0.00,4270.00,720.00,5040.00,770.00,'2023-03-08 16:42:04'),(774,'1','312',1,'Retail Sale Id 788',0.00,1830.00,720.00,2160.00,330.00,'2023-03-08 16:46:45'),(775,'1','312',1,'Retail Sale Id 789',0.00,2440.00,720.00,2880.00,440.00,'2023-03-08 16:50:20'),(776,'1','312',1,'Retail Sale Id 790',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-08 17:22:10'),(777,'1','312',1,'Retail Sale Id 791',0.00,1830.00,720.00,2160.00,330.00,'2023-03-08 17:47:30'),(778,'1','312',1,'Retail Sale Id 792',0.00,1830.00,720.00,2160.00,330.00,'2023-03-08 17:57:30'),(779,'1','312',1,'Return of Retail Sale Id 792',1830.00,0.00,720.00,-2160.00,-330.00,'2023-03-08 18:02:47'),(780,'1','312',1,'Retail Sale Id 793',0.00,9760.00,720.00,11520.00,1760.00,'2023-03-08 18:05:39'),(781,'1','312',1,'Return of Retail Sale Id 774',18300.00,0.00,680.00,-20400.00,-2100.00,'2023-03-08 18:19:37'),(782,'1','312',1,'Retail Sale Id 794',0.00,186050.00,675.00,205875.00,19825.00,'2023-03-08 18:20:38'),(783,'1','312',1,'Retail Sale Id 795',0.00,4501.80,720.00,5313.60,811.80,'2023-03-08 18:34:37'),(784,'1','312',1,'Retail Sale Id 796',0.00,2458.30,720.00,2901.60,443.30,'2023-03-09 07:55:54'),(785,'1','312',1,'Retail Sale Id 797',0.00,4270.00,720.00,5040.00,770.00,'2023-03-09 08:23:06'),(786,'1','312',1,'Retail Sale Id 798',0.00,610.00,720.00,720.00,110.00,'2023-03-09 08:29:41'),(787,'1','312',1,'Return of Retail Sale Id 798',610.00,0.00,720.00,-720.00,-110.00,'2023-03-09 08:33:25'),(788,'1','312',1,'Retail Sale Id 799',0.00,847.90,720.00,1000.80,152.90,'2023-03-09 08:34:05'),(789,'1','312',1,'Retail Sale Id 800',0.00,3684.40,720.00,4348.80,664.40,'2023-03-09 09:31:14'),(790,'1','312',1,'Retail Sale Id 801',0.00,1830.00,720.00,2160.00,330.00,'2023-03-09 10:07:19'),(791,'1','312',1,'Retail Sale Id 802',0.00,36600.00,680.00,40800.00,4200.00,'2023-03-09 10:17:07'),(792,'1','312',1,'Retail Sale Id 803',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-09 12:43:05'),(793,'1','312',1,'Retail Sale Id 804',0.00,4270.00,720.00,5040.00,770.00,'2023-03-09 12:44:19'),(794,'1','312',1,'Retail Sale Id 805',0.00,1830.00,720.00,2160.00,330.00,'2023-03-09 13:07:23'),(795,'1','312',1,'Retail Sale Id 807',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-09 13:58:39'),(796,'1','312',1,'Retail Sale Id 808',0.00,3050.00,720.00,3600.00,550.00,'2023-03-09 15:01:48'),(797,'1','312',1,'Retail Sale Id 809',0.00,3050.00,720.00,3600.00,550.00,'2023-03-09 15:02:43'),(798,'1','312',1,'Retail Sale Id 810',0.00,3391.60,720.00,4003.20,611.60,'2023-03-09 15:36:31'),(799,'1','312',1,'Retail Sale Id 811',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-09 15:37:33'),(800,'1','312',1,'Retail Sale Id 812',0.00,3660.00,720.00,4320.00,660.00,'2023-03-09 16:13:47'),(801,'1','312',1,'Retail Sale Id 813',0.00,3050.00,720.00,3600.00,550.00,'2023-03-09 16:29:25'),(802,'1','312',1,'Retail Sale Id 814',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-09 17:12:36'),(803,'1','312',1,'Retail Sale Id 815',0.00,4270.00,720.00,5040.00,770.00,'2023-03-09 17:45:53'),(804,'1','312',1,'Retail Sale Id 816',0.00,3050.00,720.00,3600.00,550.00,'2023-03-09 17:49:00'),(805,'1','312',1,'Retail Sale Id 817',0.00,12200.00,720.00,14400.00,2200.00,'2023-03-09 17:55:36'),(806,'1','312',1,'Retail Sale Id 818',0.00,3660.00,720.00,4320.00,660.00,'2023-03-09 18:07:06'),(807,'1','312',1,'Retail Sale Id 819',0.00,1220.00,720.00,1440.00,220.00,'2023-03-09 18:23:30'),(808,'1','312',1,'Retail Sale Id 820',0.00,3660.00,720.00,4320.00,660.00,'2023-03-09 18:28:32'),(809,'1','312',1,'Retail Sale Id 821',0.00,2440.00,720.00,2880.00,440.00,'2023-03-10 07:39:26'),(810,'1','312',1,'Retail Sale Id 822',0.00,1220.00,720.00,1440.00,220.00,'2023-03-10 07:40:58'),(811,'1','312',1,'Retail Sale Id 823',0.00,1830.00,720.00,2160.00,330.00,'2023-03-10 07:58:15'),(812,'1','312',1,'Retail Sale Id 824',0.00,1830.00,720.00,2160.00,330.00,'2023-03-10 08:00:23'),(813,'1','312',1,'Retail Sale Id 825',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-10 08:06:06'),(814,'1','312',1,'Retail Sale Id 826',0.00,5148.40,720.00,6076.80,928.40,'2023-03-10 08:08:42'),(815,'1','312',1,'Retail Sale Id 827',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-10 08:27:58'),(816,'1','312',1,'Retail Sale Id 828',0.00,2440.00,720.00,2880.00,440.00,'2023-03-10 08:45:50'),(817,'1','312',1,'Retail Sale Id 829',0.00,3050.00,720.00,3600.00,550.00,'2023-03-10 08:48:22'),(818,'1','312',1,'Retail Sale Id 830',0.00,3660.00,720.00,4320.00,660.00,'2023-03-10 08:52:14'),(819,'1','312',1,'Retail Sale Id 831',0.00,73200.00,680.00,81600.00,8400.00,'2023-03-10 09:10:38'),(820,'1','312',1,'Retail Sale Id 832',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-10 09:39:24'),(821,'1','312',1,'Retail Sale Id 833',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-10 10:17:23'),(822,'1','312',1,'Retail Sale Id 835',0.00,2440.00,720.00,2880.00,440.00,'2023-03-10 10:30:37'),(823,'1','312',1,'Retail Sale Id 836',0.00,7930.00,720.00,9360.00,1430.00,'2023-03-10 10:43:36'),(824,'1','312',1,'Retail Sale Id 837',0.00,4270.00,720.00,5040.00,770.00,'2023-03-10 12:01:09'),(825,'1','312',1,'Retail Sale Id 838',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-10 12:03:17'),(826,'1','312',1,'Retail Sale Id 839',0.00,3050.00,720.00,3600.00,550.00,'2023-03-10 12:22:05'),(827,'1','312',1,'Retail Sale Id 840',0.00,2440.00,720.00,2880.00,440.00,'2023-03-10 13:03:41'),(828,'1','312',1,'Retail Sale Id 841',0.00,4270.00,720.00,5040.00,770.00,'2023-03-10 13:19:07'),(829,'1','312',1,'Retail Sale Id 842',0.00,21350.00,720.00,25200.00,3850.00,'2023-03-10 13:34:52'),(830,'1','312',1,'Retail Sale Id 843',0.00,4270.00,720.00,5040.00,770.00,'2023-03-10 13:53:30'),(831,'1','312',1,'Retail Sale Id 844',0.00,4270.00,720.00,5040.00,770.00,'2023-03-10 14:14:39'),(832,'1','312',1,'Retail Sale Id 845',0.00,2440.00,720.00,2880.00,440.00,'2023-03-10 14:17:26'),(833,'1','312',1,'Retail Sale Id 846',0.00,2543.70,720.00,3002.40,458.70,'2023-03-10 14:44:09'),(834,'1','312',1,'Retail Sale Id 847',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-10 15:34:07'),(835,'1','312',1,'Retail Sale Id 848',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-10 15:41:12'),(836,'1','312',1,'Retail Sale Id 849',0.00,1830.00,720.00,2160.00,330.00,'2023-03-10 15:45:13'),(837,'1','312',1,'Retail Sale Id 850',0.00,2543.70,720.00,3002.40,458.70,'2023-03-10 15:53:58'),(838,'1','312',1,'Retail Sale Id 851',0.00,3660.00,720.00,4320.00,660.00,'2023-03-10 15:56:53'),(839,'1','312',1,'Retail Sale Id 852',0.00,1830.00,720.00,2160.00,330.00,'2023-03-10 16:09:42'),(840,'1','312',1,'Retail Sale Id 853',0.00,1830.00,720.00,2160.00,330.00,'2023-03-10 16:34:36'),(841,'1','312',1,'Retail Sale Id 854',0.00,4270.00,720.00,5040.00,770.00,'2023-03-10 16:44:56'),(842,'1','312',1,'Retail Sale Id 855',0.00,3660.00,720.00,4320.00,660.00,'2023-03-10 17:21:55'),(843,'1','312',1,'Retail Sale Id 856',0.00,3684.40,720.00,4348.80,664.40,'2023-03-10 17:29:18'),(844,'1','312',1,'Retail Sale Id 857',0.00,1830.00,720.00,2160.00,330.00,'2023-03-10 17:30:37'),(845,'1','312',1,'Retail Sale Id 858',0.00,3050.00,720.00,3600.00,550.00,'2023-03-10 17:54:13'),(846,'1','312',1,'Retail Sale Id 859',0.00,1695.80,720.00,2001.60,305.80,'2023-03-10 18:15:12'),(847,'1','312',1,'Retail Sale Id 860',0.00,3050.00,720.00,3600.00,550.00,'2023-03-10 18:28:18'),(848,'1','312',1,'Retail Sale Id 861',0.00,3391.60,720.00,4003.20,611.60,'2023-03-10 18:45:42'),(849,'1','312',1,'Return of Retail Sale Id 831',73200.00,0.00,680.00,-81600.00,-8400.00,'2023-03-10 19:04:00'),(850,'1','312',1,'Retail Sale Id 862',0.00,72681.50,680.00,81022.00,8340.50,'2023-03-10 19:04:47'),(851,'1','312',1,'Retail Sale Id 863',0.00,3660.00,720.00,4320.00,660.00,'2023-03-11 07:57:08'),(852,'1','312',1,'Retail Sale Id 864',0.00,4270.00,720.00,5040.00,770.00,'2023-03-11 08:07:29'),(853,'1','312',1,'Retail Sale Id 865',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-11 08:25:13'),(854,'1','312',1,'Retail Sale Id 866',0.00,3660.00,720.00,4320.00,660.00,'2023-03-11 08:45:57'),(855,'1','312',1,'Retail Sale Id 867',0.00,11895.00,720.00,14040.00,2145.00,'2023-03-11 09:16:09'),(856,'1','312',1,'Retail Sale Id 868',0.00,9150.00,720.00,10800.00,1650.00,'2023-03-11 09:20:09'),(857,'1','312',1,'Retail Sale Id 869',0.00,2440.00,720.00,2880.00,440.00,'2023-03-11 09:22:44'),(858,'1','312',1,'Retail Sale Id 870',0.00,1830.00,720.00,2160.00,330.00,'2023-03-11 09:45:58'),(859,'1','312',1,'Retail Sale Id 871',0.00,1220.00,720.00,1440.00,220.00,'2023-03-11 09:47:49'),(860,'1','312',1,'Retail Sale Id 872',0.00,610.00,720.00,720.00,110.00,'2023-03-11 09:52:23'),(861,'1','312',1,'Retail Sale Id 873',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-11 10:05:27'),(862,'1','312',1,'Retail Sale Id 874',0.00,1695.80,720.00,2001.60,305.80,'2023-03-11 10:07:14'),(863,'1','312',1,'Retail Sale Id 875',0.00,1220.00,720.00,1440.00,220.00,'2023-03-11 10:19:37'),(864,'1','312',1,'Retail Sale Id 876',0.00,9150.00,720.00,10800.00,1650.00,'2023-03-11 10:22:42'),(865,'1','312',1,'Retail Sale Id 877',0.00,2458.30,720.00,2901.60,443.30,'2023-03-11 10:36:41'),(866,'1','312',1,'Retail Sale Id 878',0.00,4270.00,720.00,5040.00,770.00,'2023-03-11 11:05:17'),(867,'1','312',1,'Retail Sale Id 879',0.00,3050.00,720.00,3600.00,550.00,'2023-03-11 11:07:47'),(868,'1','312',1,'Retail Sale Id 880',0.00,3050.00,720.00,3600.00,550.00,'2023-03-11 11:14:21'),(869,'1','312',1,'Retail Sale Id 881',0.00,3050.00,720.00,3600.00,550.00,'2023-03-11 12:23:22'),(870,'1','312',1,'Retail Sale Id 882',0.00,4270.00,720.00,5040.00,770.00,'2023-03-11 12:24:27'),(871,'1','312',1,'Retail Sale Id 883',0.00,2543.70,720.00,3002.40,458.70,'2023-03-11 12:55:42'),(872,'1','312',1,'Retail Sale Id 884',0.00,5490.00,720.00,6480.00,990.00,'2023-03-11 13:21:20'),(873,'1','312',1,'Retail Sale Id 885',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-11 13:28:04'),(874,'1','312',1,'Retail Sale Id 886',0.00,3050.00,720.00,3600.00,550.00,'2023-03-11 13:29:49'),(875,'1','312',1,'Retail Sale Id 887',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-11 13:57:00'),(876,'1','312',1,'Retail Sale Id 888',0.00,847.90,720.00,1000.80,152.90,'2023-03-11 14:01:24'),(877,'1','312',1,'Retail Sale Id 889',0.00,4270.00,720.00,5040.00,770.00,'2023-03-11 14:08:23'),(878,'1','312',1,'Retail Sale Id 891',0.00,10260.20,720.00,12110.40,1850.20,'2023-03-11 14:38:44'),(879,'1','312',1,'Retail Sale Id 893',0.00,1220.00,720.00,1440.00,220.00,'2023-03-11 14:46:18'),(880,'1','312',1,'Retail Sale Id 894',0.00,4233.40,720.00,4996.80,763.40,'2023-03-11 15:07:20'),(881,'1','312',1,'Retail Sale Id 895',0.00,32940.00,720.00,38880.00,5940.00,'2023-03-11 15:20:35'),(882,'1','312',1,'Retail Sale Id 896',0.00,15250.00,720.00,18000.00,2750.00,'2023-03-11 15:30:00'),(883,'1','312',1,'Retail Sale Id 897',0.00,4270.00,720.00,5040.00,770.00,'2023-03-11 15:39:20'),(884,'1','312',1,'Retail Sale Id 898',0.00,36600.00,680.00,40800.00,4200.00,'2023-03-11 15:44:41'),(885,'1','312',1,'Retail Sale Id 899',0.00,2135.00,720.00,2520.00,385.00,'2023-03-11 15:48:42'),(886,'1','312',1,'Retail Sale Id 900',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-11 15:55:22'),(887,'1','312',1,'Retail Sale Id 901',0.00,847.90,720.00,1000.80,152.90,'2023-03-11 15:56:30'),(888,'1','312',1,'Retail Sale Id 902',0.00,2440.00,720.00,2880.00,440.00,'2023-03-11 16:13:02'),(889,'1','312',1,'Retail Sale Id 903',0.00,3660.00,720.00,4320.00,660.00,'2023-03-11 16:26:30'),(890,'1','312',1,'Retail Sale Id 904',0.00,3050.00,720.00,3600.00,550.00,'2023-03-11 16:49:06'),(891,'1','312',1,'Retail Sale Id 905',0.00,1695.80,720.00,2001.60,305.80,'2023-03-11 16:55:35'),(892,'1','312',1,'Retail Sale Id 906',0.00,3050.00,720.00,3600.00,550.00,'2023-03-11 16:57:47'),(893,'1','312',1,'Retail Sale Id 908',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-11 17:00:28'),(894,'1','312',1,'Retail Sale Id 909',0.00,1830.00,720.00,2160.00,330.00,'2023-03-11 17:15:39'),(895,'1','312',1,'Retail Sale Id 910',0.00,4270.00,720.00,5040.00,770.00,'2023-03-11 17:20:32'),(896,'1','312',1,'Retail Sale Id 911',0.00,4270.00,720.00,5040.00,770.00,'2023-03-11 17:23:55'),(897,'1','312',1,'Retail Sale Id 912',0.00,2440.00,720.00,2880.00,440.00,'2023-03-11 17:26:15'),(898,'1','312',1,'Retail Sale Id 913',0.00,1830.00,720.00,2160.00,330.00,'2023-03-11 17:42:59'),(899,'1','312',1,'Retail Sale Id 914',0.00,1220.00,720.00,1440.00,220.00,'2023-03-11 18:07:15'),(900,'1','312',1,'Return of Retail Sale Id 898',36600.00,0.00,680.00,-40800.00,-4200.00,'2023-03-11 18:40:09'),(901,'1','312',1,'Retail Sale Id 915',0.00,36471.90,680.00,40657.20,4185.30,'2023-03-11 18:41:18'),(902,'1','312',1,'Return of Retail Sale Id 903',3660.00,0.00,720.00,-4320.00,-660.00,'2023-03-11 18:57:17'),(903,'1','312',1,'Retail Sale Id 916',0.00,3342.80,720.00,3945.60,602.80,'2023-03-11 18:59:40'),(904,'1','312',1,'Retail Sale Id 917',0.00,1220.00,720.00,1440.00,220.00,'2023-03-12 07:40:03'),(905,'1','312',1,'Retail Sale Id 918',0.00,3660.00,720.00,4320.00,660.00,'2023-03-12 07:41:42'),(906,'1','312',1,'Retail Sale Id 919',0.00,4270.00,720.00,5040.00,770.00,'2023-03-12 07:53:54'),(907,'1','312',1,'Retail Sale Id 920',0.00,1945.90,720.00,2296.80,350.90,'2023-03-12 08:13:16'),(908,'1','312',1,'Retail Sale Id 921',0.00,3355.00,720.00,3960.00,605.00,'2023-03-12 08:18:39'),(909,'1','312',1,'Retail Sale Id 922',0.00,4270.00,720.00,5040.00,770.00,'2023-03-12 08:20:24'),(910,'1','312',1,'Retail Sale Id 923',0.00,3660.00,720.00,4320.00,660.00,'2023-03-12 08:52:54'),(911,'1','312',1,'Retail Sale Id 926',0.00,1830.00,720.00,2160.00,330.00,'2023-03-12 09:46:33'),(912,'1','312',1,'Retail Sale Id 927',0.00,3050.00,720.00,3600.00,550.00,'2023-03-12 09:47:40'),(913,'1','312',1,'Retail Sale Id 928',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-12 09:48:46'),(914,'1','312',1,'Retail Sale Id 929',0.00,1220.00,720.00,1440.00,220.00,'2023-03-12 09:51:22'),(915,'1','312',1,'Retail Sale Id 930',0.00,1830.00,720.00,2160.00,330.00,'2023-03-12 09:55:55'),(916,'1','312',1,'Retail Sale Id 931',0.00,677.10,720.00,799.20,122.10,'2023-03-12 10:20:06'),(917,'1','312',1,'Retail Sale Id 932',0.00,1830.00,720.00,2160.00,330.00,'2023-03-12 10:43:40'),(918,'1','312',1,'Retail Sale Id 933',0.00,2440.00,720.00,2880.00,440.00,'2023-03-12 10:53:34'),(919,'1','312',1,'Retail Sale Id 934',0.00,35380.00,680.00,39440.00,4060.00,'2023-03-12 11:15:47'),(920,'1','312',1,'Retail Sale Id 936',0.00,9150.00,720.00,10800.00,1650.00,'2023-03-12 11:44:28'),(921,'1','312',1,'Retail Sale Id 937',0.00,3391.60,720.00,4003.20,611.60,'2023-03-12 12:37:51'),(922,'1','312',1,'Retail Sale Id 938',0.00,1220.00,720.00,1440.00,220.00,'2023-03-12 12:44:17'),(923,'1','312',1,'Retail Sale Id 939',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-12 12:52:32'),(924,'1','312',1,'Retail Sale Id 940',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-12 13:10:25'),(925,'1','312',1,'Retail Sale Id 941',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-12 13:14:55'),(926,'1','312',1,'Retail Sale Id 942',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-12 14:03:30'),(927,'1','312',1,'Retail Sale Id 943',0.00,30500.00,720.00,36000.00,5500.00,'2023-03-12 14:24:37'),(928,'1','312',1,'Retail Sale Id 944',0.00,4233.40,720.00,4996.80,763.40,'2023-03-12 14:43:56'),(929,'1','312',1,'Retail Sale Id 945',0.00,2116.70,720.00,2498.40,381.70,'2023-03-12 14:46:34'),(930,'1','312',1,'Retail Sale Id 946',0.00,3660.00,720.00,4320.00,660.00,'2023-03-12 14:50:02'),(931,'1','312',1,'Retail Sale Id 947',0.00,1830.00,720.00,2160.00,330.00,'2023-03-12 15:02:49'),(932,'1','312',1,'Retail Sale Id 948',0.00,4270.00,720.00,5040.00,770.00,'2023-03-12 15:15:28'),(933,'1','312',1,'Retail Sale Id 949',0.00,3391.60,720.00,4003.20,611.60,'2023-03-12 15:54:00'),(934,'1','312',1,'Retail Sale Id 950',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-12 16:02:56'),(935,'1','312',1,'Retail Sale Id 951',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-12 16:16:02'),(936,'1','312',1,'Retail Sale Id 952',0.00,3050.00,720.00,3600.00,550.00,'2023-03-12 16:19:24'),(937,'1','312',1,'Retail Sale Id 953',0.00,1830.00,720.00,2160.00,330.00,'2023-03-12 16:22:03'),(938,'1','312',1,'Retail Sale Id 954',0.00,1830.00,720.00,2160.00,330.00,'2023-03-12 16:38:31'),(939,'1','312',1,'Retail Sale Id 955',0.00,33550.00,680.00,37400.00,3850.00,'2023-03-12 16:51:01'),(940,'1','312',1,'Retail Sale Id 956',0.00,1830.00,720.00,2160.00,330.00,'2023-03-12 16:55:19'),(941,'1','312',1,'Retail Sale Id 957',0.00,1695.80,720.00,2001.60,305.80,'2023-03-12 16:59:42'),(942,'1','312',1,'Retail Sale Id 958',0.00,4270.00,720.00,5040.00,770.00,'2023-03-12 17:18:28'),(943,'1','312',1,'Retail Sale Id 959',0.00,3391.60,720.00,4003.20,611.60,'2023-03-12 17:22:56'),(944,'1','312',1,'Retail Sale Id 960',0.00,3050.00,720.00,3600.00,550.00,'2023-03-12 17:29:14'),(945,'1','312',1,'Retail Sale Id 961',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-12 17:33:12'),(946,'1','312',1,'Retail Sale Id 962',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-12 17:35:16'),(947,'1','312',1,'Retail Sale Id 963',0.00,3050.00,720.00,3600.00,550.00,'2023-03-12 17:39:39'),(948,'1','312',1,'Retail Sale Id 964',0.00,4270.00,720.00,5040.00,770.00,'2023-03-12 18:03:22'),(949,'1','312',1,'Retail Sale Id 965',0.00,3660.00,720.00,4320.00,660.00,'2023-03-12 18:15:59'),(950,'1','312',1,'Retail Sale Id 966',0.00,3660.00,720.00,4320.00,660.00,'2023-03-12 18:26:07'),(951,'1','312',1,'Retail Sale Id 967',0.00,60292.40,680.00,67211.20,6918.80,'2023-03-12 18:34:31'),(952,'1','312',1,'Retail Sale Id 968',0.00,610.00,720.00,720.00,110.00,'2023-03-12 18:36:25'),(953,'1','312',1,'Retail Sale Id 969',0.00,3660.00,720.00,4320.00,660.00,'2023-03-14 07:38:11'),(954,'1','312',1,'Retail Sale Id 970',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-14 07:39:22'),(955,'1','312',1,'Retail Sale Id 971',0.00,10370.00,720.00,12240.00,1870.00,'2023-03-14 07:44:38'),(956,'1','312',1,'Retail Sale Id 972',0.00,3660.00,720.00,4320.00,660.00,'2023-03-14 07:47:11'),(957,'1','312',1,'Retail Sale Id 973',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-14 07:53:04'),(958,'1','312',1,'Retail Sale Id 974',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-14 08:12:56'),(959,'1','312',1,'Retail Sale Id 975',0.00,3660.00,720.00,4320.00,660.00,'2023-03-14 08:29:08'),(960,'1','312',1,'Retail Sale Id 976',0.00,11285.00,720.00,13320.00,2035.00,'2023-03-14 08:40:39'),(961,'1','312',1,'Retail Sale Id 978',0.00,20130.00,720.00,23760.00,3630.00,'2023-03-14 08:52:59'),(962,'1','312',1,'Retail Sale Id 979',0.00,3050.00,720.00,3600.00,550.00,'2023-03-14 08:55:19'),(963,'1','312',1,'Retail Sale Id 980',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-14 08:56:45'),(964,'1','312',1,'Retail Sale Id 981',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-14 09:38:42'),(965,'1','312',1,'Retail Sale Id 982',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-14 09:54:57'),(966,'1','312',1,'Retail Sale Id 983',0.00,2543.70,720.00,3002.40,458.70,'2023-03-14 10:25:13'),(967,'1','312',1,'Retail Sale Id 984',0.00,1866.60,720.00,2203.20,336.60,'2023-03-14 11:16:59'),(968,'1','312',1,'Retail Sale Id 985',0.00,1830.00,720.00,2160.00,330.00,'2023-03-14 11:18:54'),(969,'1','312',1,'Retail Sale Id 986',0.00,10370.00,720.00,12240.00,1870.00,'2023-03-14 11:38:57'),(970,'1','312',1,'Retail Sale Id 987',0.00,7320.00,720.00,8640.00,1320.00,'2023-03-14 12:03:12'),(971,'1','312',1,'Retail Sale Id 988',0.00,610.00,720.00,720.00,110.00,'2023-03-14 13:17:27'),(972,'1','312',1,'Retail Sale Id 989',0.00,1220.00,720.00,1440.00,220.00,'2023-03-14 13:38:20'),(973,'1','312',1,'Retail Sale Id 990',0.00,4270.00,720.00,5040.00,770.00,'2023-03-14 15:22:41'),(974,'1','312',1,'Retail Sale Id 991',0.00,3812.50,720.00,4500.00,687.50,'2023-03-14 15:35:41'),(975,'1','312',1,'Retail Sale Id 992',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-14 15:37:17'),(976,'1','312',1,'Retail Sale Id 993',0.00,3050.00,720.00,3600.00,550.00,'2023-03-14 15:48:51'),(977,'1','312',1,'Retail Sale Id 994',0.00,2440.00,720.00,2880.00,440.00,'2023-03-14 16:51:03'),(978,'1','312',1,'Retail Sale Id 995',0.00,1830.00,720.00,2160.00,330.00,'2023-03-14 17:02:50'),(979,'1','312',1,'Retail Sale Id 996',0.00,4880.00,720.00,5760.00,880.00,'2023-03-14 17:14:02'),(980,'1','312',1,'Retail Sale Id 998',0.00,3050.00,720.00,3600.00,550.00,'2023-03-14 17:19:59'),(981,'1','312',1,'Retail Sale Id 999',0.00,88450.00,680.00,98600.00,10150.00,'2023-03-14 17:23:18'),(982,'1','312',1,'Retail Sale Id 1001',0.00,1830.00,720.00,2160.00,330.00,'2023-03-14 17:38:36'),(983,'1','312',1,'Retail Sale Id 1002',0.00,4270.00,720.00,5040.00,770.00,'2023-03-14 17:45:32'),(984,'1','312',1,'Retail Sale Id 1003',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-14 18:15:26'),(985,'1','312',1,'Retail Sale Id 1004',0.00,3050.00,720.00,3600.00,550.00,'2023-03-14 18:45:35'),(986,'1','312',1,'Retail Sale Id 1005',0.00,1220.00,720.00,1440.00,220.00,'2023-03-14 19:10:42'),(987,'1','312',1,'Retail Sale Id 1006',0.00,3660.00,720.00,4320.00,660.00,'2023-03-15 08:05:02'),(988,'1','312',1,'Retail Sale Id 1008',0.00,3660.00,720.00,4320.00,660.00,'2023-03-15 08:22:33'),(989,'1','312',1,'Retail Sale Id 1009',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-15 08:25:04'),(990,'1','312',1,'Retail Sale Id 1010',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-15 08:52:24'),(991,'1','312',1,'Retail Sale Id 1011',0.00,2440.00,720.00,2880.00,440.00,'2023-03-15 08:55:33'),(992,'1','312',1,'Retail Sale Id 1012',0.00,1830.00,720.00,2160.00,330.00,'2023-03-15 08:58:50'),(993,'1','312',1,'Retail Sale Id 1013',0.00,1866.60,720.00,2203.20,336.60,'2023-03-15 09:07:37'),(994,'1','312',1,'Retail Sale Id 1014',0.00,2440.00,720.00,2880.00,440.00,'2023-03-15 09:28:21'),(995,'1','312',1,'Retail Sale Id 1015',0.00,3660.00,720.00,4320.00,660.00,'2023-03-15 09:39:02'),(996,'1','312',1,'Retail Sale Id 1016',0.00,2745.00,720.00,3240.00,495.00,'2023-03-15 10:09:48'),(997,'1','312',1,'Retail Sale Id 1017',0.00,3660.00,720.00,4320.00,660.00,'2023-03-15 10:11:37'),(998,'1','312',1,'Retail Sale Id 1018',0.00,1830.00,720.00,2160.00,330.00,'2023-03-15 10:38:54'),(999,'1','312',1,'Retail Sale Id 1019',0.00,9150.00,720.00,10800.00,1650.00,'2023-03-15 10:41:00'),(1000,'1','312',1,'Retail Sale Id 1020',0.00,2440.00,720.00,2880.00,440.00,'2023-03-15 11:46:07'),(1001,'1','312',1,'Retail Sale Id 1021',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-15 12:23:41'),(1002,'1','312',1,'Retail Sale Id 1022',0.00,8845.00,720.00,10440.00,1595.00,'2023-03-15 12:57:45'),(1003,'1','312',1,'Retail Sale Id 1023',0.00,1220.00,720.00,1440.00,220.00,'2023-03-15 13:07:33'),(1004,'1','312',1,'Retail Sale Id 1024',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-15 14:32:02'),(1005,'1','312',1,'Retail Sale Id 1025',0.00,1268.80,720.00,1497.60,228.80,'2023-03-15 14:53:48'),(1006,'1','312',1,'Retail Sale Id 1026',0.00,3050.00,720.00,3600.00,550.00,'2023-03-15 15:35:49'),(1007,'1','312',1,'Retail Sale Id 1027',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-15 15:38:31'),(1008,'1','312',1,'Retail Sale Id 1028',0.00,8540.00,720.00,10080.00,1540.00,'2023-03-15 15:40:22'),(1009,'1','312',1,'Retail Sale Id 1029',0.00,1830.00,720.00,2160.00,330.00,'2023-03-15 15:42:51'),(1010,'1','312',1,'Retail Sale Id 1030',0.00,2440.00,720.00,2880.00,440.00,'2023-03-15 15:49:52'),(1011,'1','312',1,'Retail Sale Id 1031',0.00,4270.00,720.00,5040.00,770.00,'2023-03-15 16:03:41'),(1012,'1','312',1,'Retail Sale Id 1032',0.00,3050.00,720.00,3600.00,550.00,'2023-03-15 16:09:54'),(1013,'1','312',1,'Retail Sale Id 1033',0.00,3660.00,720.00,4320.00,660.00,'2023-03-15 16:20:23'),(1014,'1','312',1,'Retail Sale Id 1034',0.00,1220.00,720.00,1440.00,220.00,'2023-03-15 16:22:46'),(1015,'1','312',1,'Retail Sale Id 1035',0.00,1830.00,720.00,2160.00,330.00,'2023-03-15 16:48:05'),(1016,'1','312',1,'Retail Sale Id 1036',0.00,1226.10,720.00,1447.20,221.10,'2023-03-15 17:18:13'),(1017,'1','312',1,'Retail Sale Id 1037',0.00,3660.00,720.00,4320.00,660.00,'2023-03-16 08:01:25'),(1018,'1','312',1,'Retail Sale Id 1038',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-16 08:03:26'),(1019,'1','312',1,'Retail Sale Id 1039',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-16 08:29:46'),(1020,'1','312',1,'Retail Sale Id 1040',0.00,1220.00,720.00,1440.00,220.00,'2023-03-16 08:48:34'),(1021,'1','312',1,'Retail Sale Id 1041',0.00,1830.00,720.00,2160.00,330.00,'2023-03-16 08:57:55'),(1022,'1','312',1,'Retail Sale Id 1042',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-16 09:00:49'),(1023,'1','312',1,'Retail Sale Id 1043',0.00,3391.60,720.00,4003.20,611.60,'2023-03-16 09:03:49'),(1024,'1','312',1,'Retail Sale Id 1044',0.00,3660.00,720.00,4320.00,660.00,'2023-03-16 09:14:47'),(1025,'1','312',1,'Retail Sale Id 1045',0.00,3660.00,720.00,4320.00,660.00,'2023-03-16 09:27:41'),(1026,'1','312',1,'Retail Sale Id 1046',0.00,3050.00,720.00,3600.00,550.00,'2023-03-16 10:21:52'),(1027,'1','312',1,'Retail Sale Id 1047',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-16 10:45:06'),(1028,'1','312',1,'Retail Sale Id 1048',0.00,18300.00,720.00,21600.00,3300.00,'2023-03-16 10:55:40'),(1029,'1','312',1,'Retail Sale Id 1049',0.00,1830.00,720.00,2160.00,330.00,'2023-03-16 11:27:44'),(1030,'1','312',1,'Retail Sale Id 1050',0.00,3050.00,720.00,3600.00,550.00,'2023-03-16 11:38:18'),(1031,'1','312',1,'Retail Sale Id 1051',0.00,5490.00,720.00,6480.00,990.00,'2023-03-16 11:51:41'),(1032,'1','312',1,'Retail Sale Id 1052',0.00,3050.00,720.00,3600.00,550.00,'2023-03-16 12:00:33'),(1033,'1','312',1,'Retail Sale Id 1053',0.00,1220.00,720.00,1440.00,220.00,'2023-03-16 12:03:36'),(1034,'1','312',1,'Retail Sale Id 1054',0.00,3050.00,720.00,3600.00,550.00,'2023-03-16 12:05:44'),(1035,'1','312',1,'Return of Retail Sale Id 1053',1220.00,0.00,720.00,-1440.00,-220.00,'2023-03-16 13:13:42'),(1036,'1','312',1,'Retail Sale Id 1055',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-16 13:14:52'),(1037,'1','312',1,'Retail Sale Id 1056',0.00,1220.00,720.00,1440.00,220.00,'2023-03-16 13:16:23'),(1038,'1','312',1,'Retail Sale Id 1057',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-16 13:34:05'),(1039,'1','312',1,'Retail Sale Id 1058',0.00,6710.00,720.00,7920.00,1210.00,'2023-03-16 14:16:44'),(1040,'1','312',1,'Retail Sale Id 1059',0.00,3660.00,720.00,4320.00,660.00,'2023-03-16 14:18:22'),(1041,'1','312',1,'Retail Sale Id 1060',0.00,2440.00,720.00,2880.00,440.00,'2023-03-16 15:52:58'),(1042,'1','312',1,'Retail Sale Id 1061',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-16 15:54:07'),(1043,'1','312',1,'Retail Sale Id 1062',0.00,7320.00,720.00,8640.00,1320.00,'2023-03-16 15:55:55'),(1044,'1','312',1,'Retail Sale Id 1063',0.00,9150.00,720.00,10800.00,1650.00,'2023-03-16 15:57:23'),(1045,'1','312',1,'Retail Sale Id 1064',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-16 15:58:34'),(1046,'1','312',1,'Retail Sale Id 1065',0.00,1945.90,720.00,2296.80,350.90,'2023-03-16 16:01:41'),(1047,'1','312',1,'Retail Sale Id 1066',0.00,4880.00,720.00,5760.00,880.00,'2023-03-16 16:38:29'),(1048,'1','312',1,'Retail Sale Id 1067',0.00,1220.00,720.00,1440.00,220.00,'2023-03-16 16:39:55'),(1049,'1','312',1,'Retail Sale Id 1068',0.00,5490.00,720.00,6480.00,990.00,'2023-03-16 16:55:37'),(1050,'1','312',1,'Retail Sale Id 1069',0.00,1830.00,720.00,2160.00,330.00,'2023-03-16 16:58:33'),(1051,'1','312',1,'Retail Sale Id 1070',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-16 17:10:36'),(1052,'1','312',1,'Retail Sale Id 1071',0.00,3050.00,720.00,3600.00,550.00,'2023-03-16 17:23:20'),(1053,'1','312',1,'Retail Sale Id 1072',0.00,2440.00,720.00,2880.00,440.00,'2023-03-16 17:56:33'),(1054,'1','312',1,'Retail Sale Id 1074',0.00,1220.00,720.00,1440.00,220.00,'2023-03-16 18:04:06'),(1055,'1','312',1,'Retail Sale Id 1075',0.00,1695.80,720.00,2001.60,305.80,'2023-03-16 18:45:50'),(1056,'1','312',1,'Retail Sale Id 1076',0.00,1220.00,720.00,1440.00,220.00,'2023-03-16 18:47:20'),(1057,'1','312',1,'Retail Sale Id 1077',0.00,1830.00,720.00,2160.00,330.00,'2023-03-16 18:48:26'),(1058,'1','312',1,'Return of Retail Sale Id 1076',1220.00,0.00,720.00,-1440.00,-220.00,'2023-03-16 19:06:54'),(1059,'1','312',1,'Retail Sale Id 1078',0.00,1647.00,720.00,1944.00,297.00,'2023-03-16 19:08:51'),(1060,'1','312',1,'Retail Sale Id 1079',0.00,2440.00,720.00,2880.00,440.00,'2023-03-17 07:27:52'),(1061,'1','312',1,'Retail Sale Id 1080',0.00,1830.00,720.00,2160.00,330.00,'2023-03-17 07:30:51'),(1062,'1','312',1,'Retail Sale Id 1081',0.00,3660.00,720.00,4320.00,660.00,'2023-03-17 08:02:49'),(1063,'1','312',1,'Retail Sale Id 1082',0.00,1830.00,720.00,2160.00,330.00,'2023-03-17 08:28:27'),(1064,'1','312',1,'Retail Sale Id 1083',0.00,5081.30,720.00,5997.60,916.30,'2023-03-17 08:36:38'),(1065,'1','312',1,'Retail Sale Id 1084',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-17 08:39:58'),(1066,'1','312',1,'Retail Sale Id 1086',0.00,1268.80,720.00,1497.60,228.80,'2023-03-17 09:02:45'),(1067,'1','312',1,'Retail Sale Id 1087',0.00,3684.40,720.00,4348.80,664.40,'2023-03-17 09:04:33'),(1068,'1','312',1,'Retail Sale Id 1088',0.00,3660.00,720.00,4320.00,660.00,'2023-03-17 09:16:58'),(1069,'1','312',1,'Retail Sale Id 1089',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-17 09:19:59'),(1070,'1','312',1,'Retail Sale Id 1090',0.00,3660.00,720.00,4320.00,660.00,'2023-03-17 09:32:41'),(1071,'1','312',1,'Retail Sale Id 1091',0.00,1830.00,720.00,2160.00,330.00,'2023-03-17 09:38:19'),(1072,'1','312',1,'Retail Sale Id 1092',0.00,3660.00,720.00,4320.00,660.00,'2023-03-17 09:42:12'),(1073,'1','312',1,'Retail Sale Id 1093',0.00,4270.00,720.00,5040.00,770.00,'2023-03-17 09:56:15'),(1074,'1','312',1,'Retail Sale Id 1094',0.00,3050.00,720.00,3600.00,550.00,'2023-03-17 10:07:31'),(1075,'1','312',1,'Retail Sale Id 1095',0.00,6710.00,720.00,7920.00,1210.00,'2023-03-17 10:22:16'),(1076,'1','312',1,'Retail Sale Id 1096',0.00,1830.00,720.00,2160.00,330.00,'2023-03-17 10:34:16'),(1077,'1','312',1,'Retail Sale Id 1097',0.00,847.90,720.00,1000.80,152.90,'2023-03-17 10:44:00'),(1078,'1','312',1,'Retail Sale Id 1098',0.00,3050.00,720.00,3600.00,550.00,'2023-03-17 10:59:08'),(1079,'1','312',1,'Retail Sale Id 1099',0.00,7320.00,720.00,8640.00,1320.00,'2023-03-17 11:02:08'),(1080,'1','312',1,'Retail Sale Id 1100',0.00,6710.00,720.00,7920.00,1210.00,'2023-03-17 11:04:09'),(1081,'1','312',1,'Retail Sale Id 1101',0.00,2440.00,720.00,2880.00,440.00,'2023-03-17 11:08:34'),(1082,'1','312',1,'Retail Sale Id 1102',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-17 11:15:31'),(1083,'1','312',1,'Retail Sale Id 1103',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-17 11:17:13'),(1084,'1','312',1,'Retail Sale Id 1104',0.00,73200.00,680.00,81600.00,8400.00,'2023-03-17 11:22:36'),(1085,'1','312',1,'Retail Sale Id 1105',0.00,3965.00,720.00,4680.00,715.00,'2023-03-17 12:22:06'),(1086,'1','312',1,'Retail Sale Id 1106',0.00,3660.00,720.00,4320.00,660.00,'2023-03-17 12:37:20'),(1087,'1','312',1,'Retail Sale Id 1107',0.00,9455.00,720.00,11160.00,1705.00,'2023-03-17 12:48:12'),(1088,'1','312',1,'Retail Sale Id 1108',0.00,3660.00,720.00,4320.00,660.00,'2023-03-17 13:05:29'),(1089,'1','312',1,'Retail Sale Id 1109',0.00,3050.00,720.00,3600.00,550.00,'2023-03-17 13:41:56'),(1090,'1','312',1,'Retail Sale Id 1110',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-17 14:02:24'),(1091,'1','312',1,'Retail Sale Id 1111',0.00,4270.00,720.00,5040.00,770.00,'2023-03-17 14:20:38'),(1092,'1','312',1,'Retail Sale Id 1112',0.00,24400.00,720.00,28800.00,4400.00,'2023-03-17 14:40:02'),(1093,'1','312',1,'Retail Sale Id 1113',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-17 14:51:59'),(1094,'1','312',1,'Return of Retail Sale Id 1111',4270.00,0.00,720.00,-5040.00,-770.00,'2023-03-17 14:53:00'),(1095,'1','312',1,'Retail Sale Id 1114',0.00,2629.10,720.00,3103.20,474.10,'2023-03-17 14:54:12'),(1096,'1','312',1,'Retail Sale Id 1115',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-17 15:07:44'),(1097,'1','312',1,'Retail Sale Id 1116',0.00,4270.00,720.00,5040.00,770.00,'2023-03-17 15:23:53'),(1098,'1','312',1,'Retail Sale Id 1117',0.00,10370.00,720.00,12240.00,1870.00,'2023-03-17 15:26:08'),(1099,'1','312',1,'Retail Sale Id 1118',0.00,1830.00,720.00,2160.00,330.00,'2023-03-17 16:12:06'),(1100,'1','312',1,'Retail Sale Id 1119',0.00,3965.00,720.00,4680.00,715.00,'2023-03-17 16:15:08'),(1101,'1','312',1,'Retail Sale Id 1120',0.00,15250.00,720.00,18000.00,2750.00,'2023-03-17 16:21:26'),(1102,'1','312',1,'Retail Sale Id 1121',0.00,4270.00,720.00,5040.00,770.00,'2023-03-17 16:38:20'),(1103,'1','312',1,'Retail Sale Id 1122',0.00,11285.00,720.00,13320.00,2035.00,'2023-03-17 16:40:33'),(1104,'1','312',1,'Retail Sale Id 1123',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-17 16:41:46'),(1105,'1','312',1,'Retail Sale Id 1124',0.00,2440.00,720.00,2880.00,440.00,'2023-03-17 16:50:10'),(1106,'1','312',1,'Retail Sale Id 1126',0.00,1830.00,680.00,2040.00,210.00,'2023-03-17 16:57:31'),(1107,'1','312',1,'Retail Sale Id 1127',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-17 17:09:17'),(1108,'1','312',1,'Retail Sale Id 1128',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-17 17:11:27'),(1109,'1','312',1,'Retail Sale Id 1129',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-17 17:30:53'),(1110,'1','312',1,'Retail Sale Id 1130',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-17 17:35:03'),(1111,'1','312',1,'Retail Sale Id 1138',0.00,610.00,720.00,720.00,110.00,'2023-03-17 17:37:17'),(1112,'1','312',1,'Retail Sale Id 1139',0.00,1830.00,720.00,2160.00,330.00,'2023-03-17 17:43:09'),(1113,'1','312',1,'Retail Sale Id 1142',0.00,1220.00,720.00,1440.00,220.00,'2023-03-17 17:58:42'),(1114,'1','312',1,'Retail Sale Id 1143',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-17 18:09:20'),(1115,'1','312',1,'Retail Sale Id 1144',0.00,1830.00,720.00,2160.00,330.00,'2023-03-17 18:16:11'),(1116,'1','312',1,'Retail Sale Id 1145',0.00,3050.00,720.00,3600.00,550.00,'2023-03-17 18:17:13'),(1117,'1','312',1,'Retail Sale Id 1146',0.00,9455.00,720.00,11160.00,1705.00,'2023-03-17 18:18:53'),(1118,'1','312',1,'Retail Sale Id 1147',0.00,1354.20,720.00,1598.40,244.20,'2023-03-17 18:23:50'),(1119,'1','312',1,'Retail Sale Id 1148',0.00,27450.00,680.00,30600.00,3150.00,'2023-03-17 18:40:34'),(1120,'1','312',1,'Retail Sale Id 1149',0.00,4233.40,720.00,4996.80,763.40,'2023-03-17 18:43:06'),(1121,'1','312',1,'Retail Sale Id 1150',0.00,10675.00,720.00,12600.00,1925.00,'2023-03-17 18:44:47'),(1122,'1','312',1,'Retail Sale Id 1151',0.00,1268.80,720.00,1497.60,228.80,'2023-03-17 18:46:07'),(1123,'1','312',1,'Retail Sale Id 1152',0.00,2415.60,720.00,2851.20,435.60,'2023-03-17 19:01:50'),(1124,'1','312',1,'Return of Retail Sale Id 1126',1830.00,0.00,680.00,-2040.00,-210.00,'2023-03-17 19:10:37'),(1125,'1','312',1,'Return of Retail Sale Id 1148',27450.00,0.00,680.00,-30600.00,-3150.00,'2023-03-17 19:13:00'),(1126,'1','312',1,'Retail Sale Id 1153',0.00,28889.60,680.00,32204.80,3315.20,'2023-03-17 19:14:45'),(1127,'1','312',1,'Retail Sale Id 1154',0.00,3050.00,720.00,3600.00,550.00,'2023-03-19 10:21:18'),(1128,'1','312',1,'Retail Sale Id 1155',0.00,4270.00,720.00,5040.00,770.00,'2023-03-19 10:22:38'),(1129,'1','312',1,'Retail Sale Id 1156',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-19 10:24:00'),(1130,'1','312',1,'Retail Sale Id 1157',0.00,9150.00,720.00,10800.00,1650.00,'2023-03-19 10:25:10'),(1131,'1','312',1,'Retail Sale Id 1158',0.00,1830.00,720.00,2160.00,330.00,'2023-03-19 10:26:22'),(1132,'1','312',1,'Retail Sale Id 1159',0.00,1830.00,720.00,2160.00,330.00,'2023-03-19 10:27:56'),(1133,'1','312',1,'Retail Sale Id 1160',0.00,2440.00,720.00,2880.00,440.00,'2023-03-19 10:29:31'),(1134,'1','312',1,'Retail Sale Id 1161',0.00,11285.00,720.00,13320.00,2035.00,'2023-03-19 10:32:09'),(1135,'1','312',1,'Retail Sale Id 1162',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-19 10:34:23'),(1136,'1','312',1,'Retail Sale Id 1163',0.00,1695.80,720.00,2001.60,305.80,'2023-03-19 10:36:06'),(1137,'1','312',1,'Retail Sale Id 1164',0.00,6777.10,720.00,7999.20,1222.10,'2023-03-19 10:37:32'),(1138,'1','312',1,'Retail Sale Id 1165',0.00,5490.00,720.00,6480.00,990.00,'2023-03-19 12:00:48'),(1139,'1','312',1,'Retail Sale Id 1166',0.00,3355.00,720.00,3960.00,605.00,'2023-03-19 12:02:06'),(1140,'1','312',1,'Retail Sale Id 1167',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-19 12:03:11'),(1141,'1','312',1,'Retail Sale Id 1168',0.00,2543.70,720.00,3002.40,458.70,'2023-03-19 12:04:45'),(1142,'1','312',1,'Retail Sale Id 1169',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-19 12:05:43'),(1143,'1','312',1,'Retail Sale Id 1170',0.00,1830.00,720.00,2160.00,330.00,'2023-03-19 12:06:43'),(1144,'1','312',1,'Retail Sale Id 1171',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-19 12:30:44'),(1145,'1','312',1,'Retail Sale Id 1172',0.00,9455.00,720.00,11160.00,1705.00,'2023-03-19 12:45:58'),(1146,'1','312',1,'Retail Sale Id 1173',0.00,7625.00,720.00,9000.00,1375.00,'2023-03-19 12:50:28'),(1147,'1','312',1,'Retail Sale Id 1174',0.00,6710.00,720.00,7920.00,1210.00,'2023-03-19 12:52:42'),(1148,'1','312',1,'Retail Sale Id 1175',0.00,3660.00,720.00,4320.00,660.00,'2023-03-19 13:40:28'),(1149,'1','312',1,'Retail Sale Id 1176',0.00,3660.00,720.00,4320.00,660.00,'2023-03-19 13:42:31'),(1150,'1','312',1,'Retail Sale Id 1177',0.00,2440.00,720.00,2880.00,440.00,'2023-03-19 13:49:23'),(1151,'1','312',1,'Retail Sale Id 1178',0.00,3050.00,720.00,3600.00,550.00,'2023-03-19 14:01:27'),(1152,'1','312',1,'Retail Sale Id 1179',0.00,3050.00,720.00,3600.00,550.00,'2023-03-19 14:06:35'),(1153,'1','312',1,'Retail Sale Id 1180',0.00,4270.00,720.00,5040.00,770.00,'2023-03-19 14:11:36'),(1154,'1','312',1,'Retail Sale Id 1181',0.00,3660.00,720.00,4320.00,660.00,'2023-03-19 14:30:01'),(1155,'1','312',1,'Retail Sale Id 1182',0.00,7015.00,720.00,8280.00,1265.00,'2023-03-19 14:34:33'),(1156,'1','312',1,'Retail Sale Id 1183',0.00,6100.00,720.00,7200.00,1100.00,'2023-03-19 14:51:19'),(1157,'1','312',1,'Retail Sale Id 1184',0.00,1830.00,720.00,2160.00,330.00,'2023-03-19 14:58:31'),(1158,'1','312',1,'Retail Sale Id 1185',0.00,2440.00,720.00,2880.00,440.00,'2023-03-19 15:16:01'),(1159,'1','312',1,'Retail Sale Id 1186',0.00,1695.80,720.00,2001.60,305.80,'2023-03-19 15:30:36'),(1160,'1','312',1,'Retail Sale Id 1187',0.00,1830.00,720.00,2160.00,330.00,'2023-03-19 15:33:23'),(1161,'1','312',1,'Retail Sale Id 1188',0.00,3050.00,720.00,3600.00,550.00,'2023-03-19 15:42:17'),(1162,'1','312',1,'Retail Sale Id 1189',0.00,1220.00,720.00,1440.00,220.00,'2023-03-19 15:45:43'),(1163,'1','312',1,'Retail Sale Id 1190',0.00,1830.00,720.00,2160.00,330.00,'2023-03-19 15:47:54'),(1164,'1','312',1,'Retail Sale Id 1191',0.00,3641.70,720.00,4298.40,656.70,'2023-03-19 15:53:57'),(1165,'1','312',1,'Retail Sale Id 1192',0.00,2440.00,720.00,2880.00,440.00,'2023-03-19 15:55:56'),(1166,'1','312',1,'Retail Sale Id 1193',0.00,3391.60,720.00,4003.20,611.60,'2023-03-19 16:09:59'),(1167,'1','312',1,'Retail Sale Id 1194',0.00,2440.00,720.00,2880.00,440.00,'2023-03-19 16:12:30'),(1168,'1','312',1,'Retail Sale Id 1196',0.00,2440.00,720.00,2880.00,440.00,'2023-03-19 16:22:49'),(1169,'1','312',1,'Retail Sale Id 1197',0.00,7320.00,720.00,8640.00,1320.00,'2023-03-19 16:34:50'),(1170,'1','312',1,'Retail Sale Id 1198',0.00,3660.00,720.00,4320.00,660.00,'2023-03-19 16:47:41'),(1171,'1','312',1,'Retail Sale Id 1199',0.00,3660.00,720.00,4320.00,660.00,'2023-03-19 16:51:30'),(1172,'1','312',1,'Retail Sale Id 1200',0.00,1268.80,720.00,1497.60,228.80,'2023-03-19 17:15:47'),(1173,'1','312',1,'Retail Sale Id 1201',0.00,167750.00,680.00,187000.00,19250.00,'2023-03-19 17:25:27'),(1174,'1','312',1,'Retail Sale Id 1203',0.00,7320.00,720.00,8640.00,1320.00,'2023-03-19 17:52:00'),(1175,'1','312',1,'Retail Sale Id 1204',0.00,3660.00,720.00,4320.00,660.00,'2023-03-19 17:53:31'),(1176,'1','312',1,'Retail Sale Id 1205',0.00,634.40,720.00,748.80,114.40,'2023-03-19 18:30:19'),(1177,'1','312',1,'Retail Sale Id 1206',0.00,1110.20,720.00,1310.40,200.20,'2023-03-19 18:54:16');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2571 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('1','312',1,'','24','2',0.00,3202200.00,'Purchase Id 1 for 5,400.00 litters of Cooking Gas - LPG from AA RANO NIGERIA LTD','2023-02-02 11:34:21','',''),('1','312',2,'','supplier','1',3202200.00,0.00,'Purchase Id 1 for 5,400.00 litters of Cooking Gas - LPG from AA RANO NIGERIA LTD','2023-02-02 11:34:21','',''),('1','312',3,'','20','3',760.00,0.00,'Retail Sale Id 1 for 1.00 KG of Cooking Gas @ N760.00','2023-02-02 11:53:57','',''),('1','312',4,'','6.1','4',0.00,760.00,'Retail Sale Id 1 for retail product','2023-02-02 11:53:57','',''),('1','312',5,'','20','3',6080.00,0.00,'Retail Sale Id 2 for 8.00 KG of Cooking Gas @ N760.00','2023-02-02 15:59:09','',''),('1','312',6,'','6.1','4',0.00,6080.00,'Retail Sale Id 2 for retail product','2023-02-02 15:59:09','',''),('1','312',7,'','20','3',0.00,0.00,'Sales from shift 1 on 2023-02-04 08:10:43 ','2023-02-04 08:10:43','',''),('1','312',8,'','6.1','4',0.00,0.00,'Sales from shift 1 on 2023-02-04 08:10:43 ','2023-02-04 08:10:43','',''),('1','312',9,'','20','3',760.00,0.00,'Retail Sale Id 3 for 1.00 KG of Cooking Gas @ N760.00','2023-02-04 08:16:54','',''),('1','312',10,'','6.1','4',0.00,760.00,'Retail Sale Id 3 for retail product','2023-02-04 08:16:54','',''),('1','312',11,'','20','3',70946.00,0.00,'Retail Sale Id 4 for 93.35 KG of Cooking Gas @ N760.00','2023-02-04 09:32:37','',''),('1','312',12,'','6.1','4',0.00,70946.00,'Retail Sale Id 4 for retail product','2023-02-04 09:32:37','',''),('1','312',13,'','20','3',0.00,0.00,'Sales from shift 2 on 2023-02-04 09:42:01 ','2023-02-04 09:42:01','',''),('1','312',14,'','6.1','4',0.00,0.00,'Sales from shift 2 on 2023-02-04 09:42:01 ','2023-02-04 09:42:01','',''),('1','312',15,'','20','3',3800.00,0.00,'Retail Sale Id 5 for 5.00 KG of Cooking Gas @ N760.00','2023-02-04 09:44:46','',''),('1','312',16,'','6.1','4',0.00,3800.00,'Retail Sale Id 5 for retail product','2023-02-04 09:44:46','',''),('1','312',17,'','20','3',4560.00,0.00,'Retail Sale Id 6 for 6.00 KG of Cooking Gas @ N760.00','2023-02-04 09:47:01','',''),('1','312',18,'','6.1','4',0.00,4560.00,'Retail Sale Id 6 for retail product','2023-02-04 09:47:01','',''),('1','312',19,'','20','3',3800.00,0.00,'Retail Sale Id 7 for 5.00 KG of Cooking Gas @ N760.00','2023-02-04 09:48:31','',''),('1','312',20,'','6.1','4',0.00,3800.00,'Retail Sale Id 7 for retail product','2023-02-04 09:48:31','',''),('1','312',21,'','20','3',3800.00,0.00,'Retail Sale Id 8 for 5.00 KG of Cooking Gas @ N760.00','2023-02-04 09:50:15','',''),('1','312',22,'','6.1','4',0.00,3800.00,'Retail Sale Id 8 for retail product','2023-02-04 09:50:15','',''),('1','312',23,'','20','3',3800.00,0.00,'Retail Sale Id 9 for 5.00 KG of Cooking Gas @ N760.00','2023-02-04 09:51:52','',''),('1','312',24,'','6.1','4',0.00,3800.00,'Retail Sale Id 9 for retail product','2023-02-04 09:51:52','',''),('1','312',25,'','20','3',2500.00,0.00,'Retail Sale Id 11 for 3.29 KG of Cooking Gas @ N760.00','2023-02-04 09:57:50','',''),('1','312',26,'','6.1','4',0.00,2500.00,'Retail Sale Id 11 for retail product','2023-02-04 09:57:50','',''),('1','312',27,'','20','3',2300.00,0.00,'Retail Sale Id 12 for 3.03 KG of Cooking Gas @ N760.00','2023-02-04 09:59:20','',''),('1','312',28,'','6.1','4',0.00,2300.00,'Retail Sale Id 12 for retail product','2023-02-04 09:59:20','',''),('1','312',29,'','20','3',1520.00,0.00,'Retail Sale Id 13 for 2.00 KG of Cooking Gas @ N760.00','2023-02-04 10:03:34','',''),('1','312',30,'','6.1','4',0.00,1520.00,'Retail Sale Id 13 for retail product','2023-02-04 10:03:34','',''),('1','312',31,'','20','3',1500.00,0.00,'Retail Sale Id 14 for 1.97 KG of Cooking Gas @ N760.00','2023-02-04 10:04:56','',''),('1','312',32,'','6.1','4',0.00,1500.00,'Retail Sale Id 14 for retail product','2023-02-04 10:04:56','',''),('1','312',33,'','20','3',9500.00,0.00,'Retail Sale Id 15 for 12.50 KG of Cooking Gas @ N760.00','2023-02-04 10:14:07','',''),('1','312',34,'','6.1','4',0.00,9500.00,'Retail Sale Id 15 for retail product','2023-02-04 10:14:07','',''),('1','312',35,'','20','3',9500.00,0.00,'Retail Sale Id 16 for 12.50 KG of Cooking Gas @ N760.00','2023-02-04 11:25:06','',''),('1','312',36,'','6.1','4',0.00,9500.00,'Retail Sale Id 16 for retail product','2023-02-04 11:25:06','',''),('1','312',37,'','20','3',2660.00,0.00,'Retail Sale Id 17 for 3.50 KG of Cooking Gas @ N760.00','2023-02-04 11:26:40','',''),('1','312',38,'','6.1','4',0.00,2660.00,'Retail Sale Id 17 for retail product','2023-02-04 11:26:40','',''),('1','312',39,'','20','3',3500.00,0.00,'Retail Sale Id 18 for 4.61 KG of Cooking Gas @ N760.00','2023-02-04 11:27:49','',''),('1','312',40,'','6.1','4',0.00,3500.00,'Retail Sale Id 18 for retail product','2023-02-04 11:27:49','',''),('1','312',41,'','20','3',4560.00,0.00,'Retail Sale Id 19 for 6.00 KG of Cooking Gas @ N760.00','2023-02-04 12:31:11','',''),('1','312',42,'','6.1','4',0.00,4560.00,'Retail Sale Id 19 for retail product','2023-02-04 12:31:11','',''),('1','312',43,'','20','3',4560.00,0.00,'Retail Sale Id 20 for 6.00 KG of Cooking Gas @ N760.00','2023-02-04 12:49:57','',''),('1','312',44,'','6.1','4',0.00,4560.00,'Retail Sale Id 20 for retail product','2023-02-04 12:49:57','',''),('1','312',45,'','20','3',760.00,0.00,'Retail Sale Id 21 for 1.00 KG of Cooking Gas @ N760.00','2023-02-04 13:09:52','',''),('1','312',46,'','6.1','4',0.00,760.00,'Retail Sale Id 21 for retail product','2023-02-04 13:09:52','',''),('1','312',47,'','20','3',4000.00,0.00,'Retail Sale Id 22 for 5.26 KG of Cooking Gas @ N760.00','2023-02-04 13:19:26','',''),('1','312',48,'','6.1','4',0.00,4000.00,'Retail Sale Id 22 for retail product','2023-02-04 13:19:26','',''),('1','312',49,'','20','3',4560.00,0.00,'Retail Sale Id 23 for 6.00 KG of Cooking Gas @ N760.00','2023-02-04 13:23:05','',''),('1','312',50,'','6.1','4',0.00,4560.00,'Retail Sale Id 23 for retail product','2023-02-04 13:23:05','',''),('1','312',51,'','20','3',12600.00,0.00,'Retail Sale Id 24 for 16.58 KG of Cooking Gas @ N760.00','2023-02-04 14:58:09','',''),('1','312',52,'','6.1','4',0.00,12600.00,'Retail Sale Id 24 for retail product','2023-02-04 14:58:09','',''),('1','312',53,'','20','3',2300.00,0.00,'Retail Sale Id 25 for 3.03 KG of Cooking Gas @ N760.00','2023-02-04 15:21:59','',''),('1','312',54,'','6.1','4',0.00,2300.00,'Retail Sale Id 25 for retail product','2023-02-04 15:21:59','',''),('1','312',55,'','20','3',7425.20,0.00,'Retail Sale Id 26 for 9.77 KG of Cooking Gas @ N760.00','2023-02-04 16:50:24','',''),('1','312',56,'','6.1','4',0.00,7425.20,'Retail Sale Id 26 for retail product','2023-02-04 16:50:24','',''),('1','312',57,'','20','3',7600.00,0.00,'Retail Sale Id 27 for 10.00 KG of Cooking Gas @ N760.00','2023-02-04 16:51:52','',''),('1','312',58,'','6.1','4',0.00,7600.00,'Retail Sale Id 27 for retail product','2023-02-04 16:51:52','',''),('1','312',59,'','20','3',6840.00,0.00,'Retail Sale Id 28 for 9.00 KG of Cooking Gas @ N760.00','2023-02-04 19:54:57','',''),('1','312',60,'','6.1','4',0.00,6840.00,'Retail Sale Id 28 for retail product','2023-02-04 19:54:57','',''),('1','312',61,'','20','3',30400.00,0.00,'Retail Sale Id 29 for 40.00 KG of Cooking Gas @ N760.00','2023-02-04 19:56:02','',''),('1','312',62,'','6.1','4',0.00,30400.00,'Retail Sale Id 29 for retail product','2023-02-04 19:56:02','',''),('1','312',63,'','20','3',0.00,0.00,'Sales from shift 3 on 2023-02-04 20:27:41 ','2023-02-04 20:27:41','',''),('1','312',64,'','6.1','4',0.00,0.00,'Sales from shift 3 on 2023-02-04 20:27:41 ','2023-02-04 20:27:41','',''),('1','312',65,'','20','3',9500.00,0.00,'Retail Sale Id 30 for 12.50 KG of Cooking Gas @ N760.00','2023-02-05 07:42:06','',''),('1','312',66,'','6.1','4',0.00,9500.00,'Retail Sale Id 30 for retail product','2023-02-05 07:42:06','',''),('1','312',67,'','20','3',4560.00,0.00,'Retail Sale Id 31 for 6.00 KG of Cooking Gas @ N760.00','2023-02-05 07:43:23','',''),('1','312',68,'','6.1','4',0.00,4560.00,'Retail Sale Id 31 for retail product','2023-02-05 07:43:23','',''),('1','312',69,'','20','3',9500.00,0.00,'Retail Sale Id 32 for 12.50 KG of Cooking Gas @ N760.00','2023-02-05 10:13:49','',''),('1','312',70,'','6.1','4',0.00,9500.00,'Retail Sale Id 32 for retail product','2023-02-05 10:13:49','',''),('1','312',71,'','20','3',7600.00,0.00,'Retail Sale Id 33 for 10.00 KG of Cooking Gas @ N760.00','2023-02-05 12:34:17','',''),('1','312',72,'','6.1','4',0.00,7600.00,'Retail Sale Id 33 for retail product','2023-02-05 12:34:17','',''),('1','312',73,'','20','3',1550.00,0.00,'Retail Sale Id 34 for 2.04 KG of Cooking Gas @ N760.00','2023-02-05 12:39:56','',''),('1','312',74,'','6.1','4',0.00,1550.00,'Retail Sale Id 34 for retail product','2023-02-05 12:39:56','',''),('1','312',75,'','20','3',2300.00,0.00,'Retail Sale Id 35 for 3.03 KG of Cooking Gas @ N760.00','2023-02-05 12:45:01','',''),('1','312',76,'','6.1','4',0.00,2300.00,'Retail Sale Id 35 for retail product','2023-02-05 12:45:01','',''),('1','312',77,'','20','3',9500.00,0.00,'Retail Sale Id 36 for 12.50 KG of Cooking Gas @ N760.00','2023-02-05 12:58:36','',''),('1','312',78,'','6.1','4',0.00,9500.00,'Retail Sale Id 36 for retail product','2023-02-05 12:58:36','',''),('1','312',79,'','20','3',4560.00,0.00,'Retail Sale Id 37 for 6.00 KG of Cooking Gas @ N760.00','2023-02-05 13:00:05','',''),('1','312',80,'','6.1','4',0.00,4560.00,'Retail Sale Id 37 for retail product','2023-02-05 13:00:05','',''),('1','312',81,'','20','3',10640.00,0.00,'Retail Sale Id 38 for 14.00 KG of Cooking Gas @ N760.00','2023-02-05 13:04:16','',''),('1','312',82,'','6.1','4',0.00,10640.00,'Retail Sale Id 38 for retail product','2023-02-05 13:04:16','',''),('1','312',83,'','20','3',3800.00,0.00,'Retail Sale Id 39 for 5.00 KG of Cooking Gas @ N760.00','2023-02-05 13:05:47','',''),('1','312',84,'','6.1','4',0.00,3800.00,'Retail Sale Id 39 for retail product','2023-02-05 13:05:47','',''),('1','312',85,'','20','3',4560.00,0.00,'Retail Sale Id 40 for 6.00 KG of Cooking Gas @ N760.00','2023-02-05 13:07:19','',''),('1','312',86,'','6.1','4',0.00,4560.00,'Retail Sale Id 40 for retail product','2023-02-05 13:07:19','',''),('1','312',87,'','20','3',4000.00,0.00,'Retail Sale Id 41 for 5.26 KG of Cooking Gas @ N760.00','2023-02-05 14:48:03','',''),('1','312',88,'','6.1','4',0.00,4000.00,'Retail Sale Id 41 for retail product','2023-02-05 14:48:03','',''),('1','312',89,'','20','3',2000.00,0.00,'Retail Sale Id 42 for 2.63 KG of Cooking Gas @ N760.00','2023-02-05 14:50:12','',''),('1','312',90,'','6.1','4',0.00,2000.00,'Retail Sale Id 42 for retail product','2023-02-05 14:50:12','',''),('1','312',91,'','20','3',9100.00,0.00,'Retail Sale Id 43 for 11.97 KG of Cooking Gas @ N760.00','2023-02-05 15:38:53','',''),('1','312',92,'','6.1','4',0.00,9100.00,'Retail Sale Id 43 for retail product','2023-02-05 15:38:53','',''),('1','312',93,'','20','3',8000.00,0.00,'Retail Sale Id 44 for 10.53 KG of Cooking Gas @ N760.00','2023-02-05 15:50:16','',''),('1','312',94,'','6.1','4',0.00,8000.00,'Retail Sale Id 44 for retail product','2023-02-05 15:50:16','',''),('1','312',95,'','20','3',6110.40,0.00,'Retail Sale Id 45 for 8.04 KG of Cooking Gas @ N760.00','2023-02-05 19:25:27','',''),('1','312',96,'','6.1','4',0.00,6110.40,'Retail Sale Id 45 for retail product','2023-02-05 19:25:27','',''),('1','312',97,'','20','3',7600.00,0.00,'Retail Sale Id 46 for 10.00 KG of Cooking Gas @ N760.00','2023-02-05 19:26:25','',''),('1','312',98,'','6.1','4',0.00,7600.00,'Retail Sale Id 46 for retail product','2023-02-05 19:26:25','',''),('1','312',99,'','20','3',9500.00,0.00,'Retail Sale Id 47 for 12.50 KG of Cooking Gas @ N760.00','2023-02-05 19:27:24','',''),('1','312',100,'','6.1','4',0.00,9500.00,'Retail Sale Id 47 for retail product','2023-02-05 19:27:24','',''),('1','312',101,'','20','3',5700.00,0.00,'Retail Sale Id 48 for 7.50 KG of Cooking Gas @ N760.00','2023-02-05 19:28:07','',''),('1','312',102,'','6.1','4',0.00,5700.00,'Retail Sale Id 48 for retail product','2023-02-05 19:28:07','',''),('1','312',103,'','20','3',15200.00,0.00,'Retail Sale Id 49 for 20.00 KG of Cooking Gas @ N760.00','2023-02-05 19:28:47','',''),('1','312',104,'','6.1','4',0.00,15200.00,'Retail Sale Id 49 for retail product','2023-02-05 19:28:47','',''),('1','312',105,'','20','3',0.00,0.00,'Sales from shift 4 on 2023-02-05 19:39:13 ','2023-02-05 19:39:13','',''),('1','312',106,'','6.1','4',0.00,0.00,'Sales from shift 4 on 2023-02-05 19:39:13 ','2023-02-05 19:39:13','',''),('1','312',107,'','20','3',9500.00,0.00,'Retail Sale Id 50 for 12.50 KG of Cooking Gas @ N760.00','2023-02-07 08:13:31','',''),('1','312',108,'','6.1','4',0.00,9500.00,'Retail Sale Id 50 for retail product','2023-02-07 08:13:31','',''),('1','312',109,'','20','3',4560.00,0.00,'Retail Sale Id 51 for 6.00 KG of Cooking Gas @ N760.00','2023-02-07 08:15:09','',''),('1','312',110,'','6.1','4',0.00,4560.00,'Retail Sale Id 51 for retail product','2023-02-07 08:15:09','',''),('1','312',111,'','20','3',3800.00,0.00,'Retail Sale Id 52 for 5.00 KG of Cooking Gas @ N760.00','2023-02-07 08:16:16','',''),('1','312',112,'','6.1','4',0.00,3800.00,'Retail Sale Id 52 for retail product','2023-02-07 08:16:16','',''),('1','312',113,'','20','3',2000.00,0.00,'Retail Sale Id 53 for 2.63 KG of Cooking Gas @ N760.00','2023-02-07 08:35:31','',''),('1','312',114,'','6.1','4',0.00,2000.00,'Retail Sale Id 53 for retail product','2023-02-07 08:35:31','',''),('1','312',115,'','20','3',4560.00,0.00,'Retail Sale Id 54 for 6.00 KG of Cooking Gas @ N760.00','2023-02-07 12:11:48','',''),('1','312',116,'','6.1','4',0.00,4560.00,'Retail Sale Id 54 for retail product','2023-02-07 12:11:48','',''),('1','312',117,'','20','3',3050.00,0.00,'Retail Sale Id 55 for 4.01 KG of Cooking Gas @ N760.00','2023-02-07 12:17:09','',''),('1','312',118,'','6.1','4',0.00,3050.00,'Retail Sale Id 55 for retail product','2023-02-07 12:17:09','',''),('1','312',119,'','20','3',8360.00,0.00,'Retail Sale Id 56 for 11.00 KG of Cooking Gas @ N760.00','2023-02-07 13:44:57','',''),('1','312',120,'','6.1','4',0.00,8360.00,'Retail Sale Id 56 for retail product','2023-02-07 13:44:57','',''),('1','312',121,'','20','3',4000.00,0.00,'Retail Sale Id 57 for 5.26 KG of Cooking Gas @ N760.00','2023-02-07 14:27:44','',''),('1','312',122,'','6.1','4',0.00,4000.00,'Retail Sale Id 57 for retail product','2023-02-07 14:27:44','',''),('1','312',123,'','20','3',4590.40,0.00,'Retail Sale Id 59 for 6.04 KG of Cooking Gas @ N760.00','2023-02-07 19:18:10','',''),('1','312',124,'','6.1','4',0.00,4590.40,'Retail Sale Id 59 for retail product','2023-02-07 19:18:10','',''),('1','312',125,'','20','3',15200.00,0.00,'Retail Sale Id 60 for 20.00 KG of Cooking Gas @ N760.00','2023-02-07 19:19:29','',''),('1','312',126,'','6.1','4',0.00,15200.00,'Retail Sale Id 60 for retail product','2023-02-07 19:19:29','',''),('1','312',127,'','20','3',9500.00,0.00,'Retail Sale Id 61 for 12.50 KG of Cooking Gas @ N760.00','2023-02-07 19:23:33','',''),('1','312',128,'','6.1','4',0.00,9500.00,'Retail Sale Id 61 for retail product','2023-02-07 19:23:33','',''),('1','312',129,'','20','3',4560.00,0.00,'Retail Sale Id 62 for 6.00 KG of Cooking Gas @ N760.00','2023-02-07 19:27:21','',''),('1','312',130,'','6.1','4',0.00,4560.00,'Retail Sale Id 62 for retail product','2023-02-07 19:27:21','',''),('1','312',131,'','20','3',7600.00,0.00,'Retail Sale Id 63 for 10.00 KG of Cooking Gas @ N760.00','2023-02-07 19:28:36','',''),('1','312',132,'','6.1','4',0.00,7600.00,'Retail Sale Id 63 for retail product','2023-02-07 19:28:36','',''),('1','312',133,'','20','3',9120.00,0.00,'Retail Sale Id 64 for 12.00 KG of Cooking Gas @ N760.00','2023-02-07 19:30:17','',''),('1','312',134,'','6.1','4',0.00,9120.00,'Retail Sale Id 64 for retail product','2023-02-07 19:30:17','',''),('1','312',135,'','20','3',9500.00,0.00,'Retail Sale Id 65 for 12.50 KG of Cooking Gas @ N760.00','2023-02-07 19:32:24','',''),('1','312',136,'','6.1','4',0.00,9500.00,'Retail Sale Id 65 for retail product','2023-02-07 19:32:24','',''),('1','312',137,'','20','3',7600.00,0.00,'Retail Sale Id 66 for 10.00 KG of Cooking Gas @ N760.00','2023-02-07 19:33:20','',''),('1','312',138,'','6.1','4',0.00,7600.00,'Retail Sale Id 66 for retail product','2023-02-07 19:33:20','',''),('1','312',139,'','20','3',8360.00,0.00,'Retail Sale Id 67 for 11.00 KG of Cooking Gas @ N760.00','2023-02-07 19:34:21','',''),('1','312',140,'','6.1','4',0.00,8360.00,'Retail Sale Id 67 for retail product','2023-02-07 19:34:21','',''),('1','312',141,'','20','3',9500.00,0.00,'Retail Sale Id 68 for 12.50 KG of Cooking Gas @ N760.00','2023-02-07 19:35:18','',''),('1','312',142,'','6.1','4',0.00,9500.00,'Retail Sale Id 68 for retail product','2023-02-07 19:35:18','',''),('1','312',143,'','20','3',7600.00,0.00,'Retail Sale Id 69 for 10.00 KG of Cooking Gas @ N760.00','2023-02-07 19:36:39','',''),('1','312',144,'','6.1','4',0.00,7600.00,'Retail Sale Id 69 for retail product','2023-02-07 19:36:39','',''),('1','312',145,'','20','3',17556.00,0.00,'Retail Sale Id 70 for 23.10 KG of Cooking Gas @ N760.00','2023-02-07 19:39:37','',''),('1','312',146,'','6.1','4',0.00,17556.00,'Retail Sale Id 70 for retail product','2023-02-07 19:39:37','',''),('1','312',147,'','20','3',304.00,0.00,'Retail Sale Id 71 for 0.40 KG of Cooking Gas @ N760.00','2023-02-07 19:43:08','',''),('1','312',148,'','6.1','4',0.00,304.00,'Retail Sale Id 71 for retail product','2023-02-07 19:43:08','',''),('1','312',149,'','20','3',0.00,0.00,'Sales from shift 5 on 2023-02-07 20:31:40 ','2023-02-07 20:31:40','',''),('1','312',150,'','6.1','4',0.00,0.00,'Sales from shift 5 on 2023-02-07 20:31:40 ','2023-02-07 20:31:40','',''),('1','312',151,'','20','3',9500.00,0.00,'Retail Sale Id 72 for 12.50 KG of Cooking Gas @ N760.00','2023-02-08 11:05:18','',''),('1','312',152,'','6.1','4',0.00,9500.00,'Retail Sale Id 72 for retail product','2023-02-08 11:05:18','',''),('1','312',153,'','20','3',5320.00,0.00,'Retail Sale Id 73 for 7.00 KG of Cooking Gas @ N760.00','2023-02-08 14:31:29','',''),('1','312',154,'','6.1','4',0.00,5320.00,'Retail Sale Id 73 for retail product','2023-02-08 14:31:29','',''),('1','312',155,'','20','3',7600.00,0.00,'Retail Sale Id 74 for 10.00 KG of Cooking Gas @ N760.00','2023-02-08 14:33:18','',''),('1','312',156,'','6.1','4',0.00,7600.00,'Retail Sale Id 74 for retail product','2023-02-08 14:33:18','',''),('1','312',157,'','20','3',8740.00,0.00,'Retail Sale Id 75 for 11.50 KG of Cooking Gas @ N760.00','2023-02-08 14:40:49','',''),('1','312',158,'','6.1','4',0.00,8740.00,'Retail Sale Id 75 for retail product','2023-02-08 14:40:49','',''),('1','312',159,'','20','3',7600.00,0.00,'Retail Sale Id 76 for 10.00 KG of Cooking Gas @ N760.00','2023-02-08 14:42:02','',''),('1','312',160,'','6.1','4',0.00,7600.00,'Retail Sale Id 76 for retail product','2023-02-08 14:42:02','',''),('1','312',161,'','20','3',3800.00,0.00,'Retail Sale Id 77 for 5.00 KG of Cooking Gas @ N760.00','2023-02-08 14:43:08','',''),('1','312',162,'','6.1','4',0.00,3800.00,'Retail Sale Id 77 for retail product','2023-02-08 14:43:08','',''),('1','312',163,'','20','3',4560.00,0.00,'Retail Sale Id 78 for 6.00 KG of Cooking Gas @ N760.00','2023-02-08 14:44:18','',''),('1','312',164,'','6.1','4',0.00,4560.00,'Retail Sale Id 78 for retail product','2023-02-08 14:44:18','',''),('1','312',165,'','20','3',6840.00,0.00,'Retail Sale Id 79 for 9.00 KG of Cooking Gas @ N760.00','2023-02-08 14:45:38','',''),('1','312',166,'','6.1','4',0.00,6840.00,'Retail Sale Id 79 for retail product','2023-02-08 14:45:38','',''),('1','312',167,'','20','3',9500.00,0.00,'Retail Sale Id 80 for 12.50 KG of Cooking Gas @ N760.00','2023-02-08 17:02:09','',''),('1','312',168,'','6.1','4',0.00,9500.00,'Retail Sale Id 80 for retail product','2023-02-08 17:02:09','',''),('1','312',169,'','20','3',4560.00,0.00,'Retail Sale Id 81 for 6.00 KG of Cooking Gas @ N760.00','2023-02-08 17:37:05','',''),('1','312',170,'','6.1','4',0.00,4560.00,'Retail Sale Id 81 for retail product','2023-02-08 17:37:05','',''),('1','312',171,'','20','3',7600.00,0.00,'Retail Sale Id 82 for 10.00 KG of Cooking Gas @ N760.00','2023-02-08 17:51:33','',''),('1','312',172,'','6.1','4',0.00,7600.00,'Retail Sale Id 82 for retail product','2023-02-08 17:51:33','',''),('1','312',173,'','20','3',2553.60,0.00,'Retail Sale Id 83 for 3.36 KG of Cooking Gas @ N760.00','2023-02-08 19:18:47','',''),('1','312',174,'','6.1','4',0.00,2553.60,'Retail Sale Id 83 for retail product','2023-02-08 19:18:47','',''),('1','312',175,'','20','3',9500.00,0.00,'Retail Sale Id 84 for 12.50 KG of Cooking Gas @ N760.00','2023-02-08 19:21:33','',''),('1','312',176,'','6.1','4',0.00,9500.00,'Retail Sale Id 84 for retail product','2023-02-08 19:21:33','',''),('1','312',177,'','20','3',7600.00,0.00,'Retail Sale Id 85 for 10.00 KG of Cooking Gas @ N760.00','2023-02-08 19:23:49','',''),('1','312',178,'','6.1','4',0.00,7600.00,'Retail Sale Id 85 for retail product','2023-02-08 19:23:49','',''),('1','312',179,'','20','3',9500.00,0.00,'Retail Sale Id 86 for 12.50 KG of Cooking Gas @ N760.00','2023-02-08 19:26:12','',''),('1','312',180,'','6.1','4',0.00,9500.00,'Retail Sale Id 86 for retail product','2023-02-08 19:26:12','',''),('1','312',181,'','20','3',7600.00,0.00,'Retail Sale Id 87 for 10.00 KG of Cooking Gas @ N760.00','2023-02-08 19:28:35','',''),('1','312',182,'','6.1','4',0.00,7600.00,'Retail Sale Id 87 for retail product','2023-02-08 19:28:35','',''),('1','312',183,'','20','3',11400.00,0.00,'Retail Sale Id 88 for 15.00 KG of Cooking Gas @ N760.00','2023-02-08 19:32:56','',''),('1','312',184,'','6.1','4',0.00,11400.00,'Retail Sale Id 88 for retail product','2023-02-08 19:32:56','',''),('1','312',185,'','20','3',0.00,0.00,'Sales from shift 6 on 2023-02-08 19:34:34 ','2023-02-08 19:34:34','',''),('1','312',186,'','6.1','4',0.00,0.00,'Sales from shift 6 on 2023-02-08 19:34:34 ','2023-02-08 19:34:34','',''),('1','312',187,'','20','3',9500.00,0.00,'Retail Sale Id 89 for 12.50 KG of Cooking Gas @ N760.00','2023-02-09 10:11:05','',''),('1','312',188,'','6.1','4',0.00,9500.00,'Retail Sale Id 89 for retail product','2023-02-09 10:11:05','',''),('1','312',189,'','20','3',3800.00,0.00,'Retail Sale Id 90 for 5.00 KG of Cooking Gas @ N760.00','2023-02-09 10:12:09','',''),('1','312',190,'','6.1','4',0.00,3800.00,'Retail Sale Id 90 for retail product','2023-02-09 10:12:09','',''),('1','312',191,'','20','3',7600.00,0.00,'Retail Sale Id 91 for 10.00 KG of Cooking Gas @ N760.00','2023-02-09 10:13:16','',''),('1','312',192,'','6.1','4',0.00,7600.00,'Retail Sale Id 91 for retail product','2023-02-09 10:13:16','',''),('1','312',193,'','20','3',9500.00,0.00,'Retail Sale Id 92 for 12.50 KG of Cooking Gas @ N760.00','2023-02-09 19:27:37','',''),('1','312',194,'','6.1','4',0.00,9500.00,'Retail Sale Id 92 for retail product','2023-02-09 19:27:37','',''),('1','312',195,'','20','3',8740.00,0.00,'Retail Sale Id 93 for 11.50 KG of Cooking Gas @ N760.00','2023-02-09 19:28:30','',''),('1','312',196,'','6.1','4',0.00,8740.00,'Retail Sale Id 93 for retail product','2023-02-09 19:28:30','',''),('1','312',197,'','20','3',8360.00,0.00,'Retail Sale Id 94 for 11.00 KG of Cooking Gas @ N760.00','2023-02-09 19:29:24','',''),('1','312',198,'','6.1','4',0.00,8360.00,'Retail Sale Id 94 for retail product','2023-02-09 19:29:24','',''),('1','312',199,'','20','3',7600.00,0.00,'Retail Sale Id 95 for 10.00 KG of Cooking Gas @ N760.00','2023-02-09 19:30:12','',''),('1','312',200,'','6.1','4',0.00,7600.00,'Retail Sale Id 95 for retail product','2023-02-09 19:30:12','',''),('1','312',201,'','20','3',9500.00,0.00,'Retail Sale Id 96 for 12.50 KG of Cooking Gas @ N760.00','2023-02-09 19:31:03','',''),('1','312',202,'','6.1','4',0.00,9500.00,'Retail Sale Id 96 for retail product','2023-02-09 19:31:03','',''),('1','312',203,'','20','3',8740.00,0.00,'Retail Sale Id 97 for 11.50 KG of Cooking Gas @ N760.00','2023-02-09 19:31:56','',''),('1','312',204,'','6.1','4',0.00,8740.00,'Retail Sale Id 97 for retail product','2023-02-09 19:31:56','',''),('1','312',205,'','20','3',10640.00,0.00,'Retail Sale Id 98 for 14.00 KG of Cooking Gas @ N760.00','2023-02-09 19:32:51','',''),('1','312',206,'','6.1','4',0.00,10640.00,'Retail Sale Id 98 for retail product','2023-02-09 19:32:51','',''),('1','312',207,'','20','3',7828.00,0.00,'Retail Sale Id 99 for 10.30 KG of Cooking Gas @ N760.00','2023-02-09 19:34:16','',''),('1','312',208,'','6.1','4',0.00,7828.00,'Retail Sale Id 99 for retail product','2023-02-09 19:34:16','',''),('1','312',209,'','20','3',9500.00,0.00,'Retail Sale Id 100 for 12.50 KG of Cooking Gas @ N760.00','2023-02-09 19:35:15','',''),('1','312',210,'','6.1','4',0.00,9500.00,'Retail Sale Id 100 for retail product','2023-02-09 19:35:15','',''),('1','312',211,'','20','3',1497.20,0.00,'Retail Sale Id 101 for 1.97 KG of Cooking Gas @ N760.00','2023-02-09 19:36:51','',''),('1','312',212,'','6.1','4',0.00,1497.20,'Retail Sale Id 101 for retail product','2023-02-09 19:36:51','',''),('1','312',213,'','20','3',9500.00,0.00,'Retail Sale Id 102 for 12.50 KG of Cooking Gas @ N760.00','2023-02-09 19:37:49','',''),('1','312',214,'','6.1','4',0.00,9500.00,'Retail Sale Id 102 for retail product','2023-02-09 19:37:49','',''),('1','312',215,'','20','3',6612.00,0.00,'Retail Sale Id 103 for 8.70 KG of Cooking Gas @ N760.00','2023-02-09 19:39:51','',''),('1','312',216,'','6.1','4',0.00,6612.00,'Retail Sale Id 103 for retail product','2023-02-09 19:39:51','',''),('1','312',217,'','20','3',0.00,9500.00,'Return of Retail Sale Id 102 for products','2023-02-09 19:42:49','',''),('1','312',218,'','','',9500.00,0.00,'Return of Retail Sale Id 102 for products','2023-02-09 19:42:49','',''),('1','312',219,'','20','3',6505.60,0.00,'Retail Sale Id 104 for 8.56 KG of Cooking Gas @ N760.00','2023-02-09 19:44:10','',''),('1','312',220,'','6.1','4',0.00,6505.60,'Retail Sale Id 104 for retail product','2023-02-09 19:44:10','',''),('1','312',221,'','20','3',0.00,0.00,'Sales from shift 7 on 2023-02-09 20:49:56 ','2023-02-09 20:49:56','',''),('1','312',222,'','6.1','4',0.00,0.00,'Sales from shift 7 on 2023-02-09 20:49:56 ','2023-02-09 20:49:56','',''),('1','312',223,'','20','3',9500.00,0.00,'Retail Sale Id 105 for 12.50 KG of Cooking Gas @ N760.00','2023-02-10 12:37:17','',''),('1','312',224,'','6.1','4',0.00,9500.00,'Retail Sale Id 105 for retail product','2023-02-10 12:37:17','',''),('1','312',225,'','20','3',3800.00,0.00,'Retail Sale Id 106 for 5.00 KG of Cooking Gas @ N760.00','2023-02-10 12:40:00','',''),('1','312',226,'','6.1','4',0.00,3800.00,'Retail Sale Id 106 for retail product','2023-02-10 12:40:00','',''),('1','312',227,'','20','3',3040.00,0.00,'Retail Sale Id 107 for 4.00 KG of Cooking Gas @ N760.00','2023-02-10 17:59:12','',''),('1','312',228,'','6.1','4',0.00,3040.00,'Retail Sale Id 107 for retail product','2023-02-10 17:59:12','',''),('1','312',229,'','20','3',9500.00,0.00,'Retail Sale Id 108 for 12.50 KG of Cooking Gas @ N760.00','2023-02-10 19:34:46','',''),('1','312',230,'','6.1','4',0.00,9500.00,'Retail Sale Id 108 for retail product','2023-02-10 19:34:46','',''),('1','312',231,'','20','3',7600.00,0.00,'Retail Sale Id 109 for 10.00 KG of Cooking Gas @ N760.00','2023-02-10 19:35:34','',''),('1','312',232,'','6.1','4',0.00,7600.00,'Retail Sale Id 109 for retail product','2023-02-10 19:35:34','',''),('1','312',233,'','20','3',10640.00,0.00,'Retail Sale Id 110 for 14.00 KG of Cooking Gas @ N760.00','2023-02-10 19:36:14','',''),('1','312',234,'','6.1','4',0.00,10640.00,'Retail Sale Id 110 for retail product','2023-02-10 19:36:14','',''),('1','312',235,'','20','3',8360.00,0.00,'Retail Sale Id 111 for 11.00 KG of Cooking Gas @ N760.00','2023-02-10 19:37:05','',''),('1','312',236,'','6.1','4',0.00,8360.00,'Retail Sale Id 111 for retail product','2023-02-10 19:37:05','',''),('1','312',237,'','20','3',9500.00,0.00,'Retail Sale Id 112 for 12.50 KG of Cooking Gas @ N760.00','2023-02-10 19:37:50','',''),('1','312',238,'','6.1','4',0.00,9500.00,'Retail Sale Id 112 for retail product','2023-02-10 19:37:50','',''),('1','312',239,'','20','3',7600.00,0.00,'Retail Sale Id 113 for 10.00 KG of Cooking Gas @ N760.00','2023-02-10 19:38:31','',''),('1','312',240,'','6.1','4',0.00,7600.00,'Retail Sale Id 113 for retail product','2023-02-10 19:38:31','',''),('1','312',241,'','20','3',10640.00,0.00,'Retail Sale Id 114 for 14.00 KG of Cooking Gas @ N760.00','2023-02-10 19:39:16','',''),('1','312',242,'','6.1','4',0.00,10640.00,'Retail Sale Id 114 for retail product','2023-02-10 19:39:16','',''),('1','312',243,'','20','3',9500.00,0.00,'Retail Sale Id 115 for 12.50 KG of Cooking Gas @ N760.00','2023-02-10 19:39:59','',''),('1','312',244,'','6.1','4',0.00,9500.00,'Retail Sale Id 115 for retail product','2023-02-10 19:39:59','',''),('1','312',245,'','20','3',9500.00,0.00,'Retail Sale Id 116 for 12.50 KG of Cooking Gas @ N760.00','2023-02-10 19:40:46','',''),('1','312',246,'','6.1','4',0.00,9500.00,'Retail Sale Id 116 for retail product','2023-02-10 19:40:46','',''),('1','312',247,'','20','3',7600.00,0.00,'Retail Sale Id 117 for 10.00 KG of Cooking Gas @ N760.00','2023-02-10 19:41:47','',''),('1','312',248,'','6.1','4',0.00,7600.00,'Retail Sale Id 117 for retail product','2023-02-10 19:41:47','',''),('1','312',249,'','20','3',10746.40,0.00,'Retail Sale Id 118 for 14.14 KG of Cooking Gas @ N760.00','2023-02-10 19:44:54','',''),('1','312',250,'','6.1','4',0.00,10746.40,'Retail Sale Id 118 for retail product','2023-02-10 19:44:54','',''),('1','312',251,'','20','3',0.00,0.00,'Sales from shift 8 on 2023-02-10 19:53:59 ','2023-02-10 19:53:59','',''),('1','312',252,'','6.1','4',0.00,0.00,'Sales from shift 8 on 2023-02-10 19:53:59 ','2023-02-10 19:53:59','',''),('1','312',253,'','20','3',9500.00,0.00,'Retail Sale Id 120 for 12.50 KG of Cooking Gas @ N760.00','2023-02-11 07:51:06','',''),('1','312',254,'','6.1','4',0.00,9500.00,'Retail Sale Id 120 for retail product','2023-02-11 07:51:06','',''),('1','312',255,'','20','3',760.00,0.00,'Retail Sale Id 122 for 1.00 KG of Cooking Gas @ N760.00','2023-02-11 07:53:56','',''),('1','312',256,'','6.1','4',0.00,760.00,'Retail Sale Id 122 for retail product','2023-02-11 07:53:56','',''),('1','312',257,'','20','3',2300.00,0.00,'Retail Sale Id 123 for 3.03 KG of Cooking Gas @ N760.00','2023-02-11 07:55:47','',''),('1','312',258,'','6.1','4',0.00,2300.00,'Retail Sale Id 123 for retail product','2023-02-11 07:55:47','',''),('1','312',259,'','20','3',6000.00,0.00,'Retail Sale Id 124 for 7.89 KG of Cooking Gas @ N760.00','2023-02-11 08:46:22','',''),('1','312',260,'','6.1','4',0.00,6000.00,'Retail Sale Id 124 for retail product','2023-02-11 08:46:22','',''),('1','312',261,'','20','3',3040.00,0.00,'Retail Sale Id 125 for 4.00 KG of Cooking Gas @ N760.00','2023-02-11 09:11:36','',''),('1','312',262,'','6.1','4',0.00,3040.00,'Retail Sale Id 125 for retail product','2023-02-11 09:11:36','',''),('1','312',263,'','6.1','4',0.00,3040.00,'Retail Sale Id 125 for retail product','2023-02-11 09:11:36','',''),('1','312',264,'','20','3',2280.00,0.00,'Retail Sale Id 126 for 3.00 KG of Cooking Gas @ N760.00','2023-02-11 10:41:09','',''),('1','312',265,'','6.1','4',0.00,2280.00,'Retail Sale Id 126 for retail product','2023-02-11 10:41:09','',''),('1','312',266,'','20','3',5320.00,0.00,'Retail Sale Id 127 for 7.00 KG of Cooking Gas @ N760.00','2023-02-11 10:57:31','',''),('1','312',267,'','6.1','4',0.00,5320.00,'Retail Sale Id 127 for retail product','2023-02-11 10:57:31','',''),('1','312',268,'','20','3',5320.00,0.00,'Retail Sale Id 128 for 7.00 KG of Cooking Gas @ N760.00','2023-02-11 12:17:58','',''),('1','312',269,'','6.1','4',0.00,5320.00,'Retail Sale Id 128 for retail product','2023-02-11 12:17:58','',''),('1','312',270,'','20','3',4560.00,0.00,'Retail Sale Id 129 for 6.00 KG of Cooking Gas @ N760.00','2023-02-11 13:54:08','',''),('1','312',271,'','6.1','4',0.00,4560.00,'Retail Sale Id 129 for retail product','2023-02-11 13:54:08','',''),('1','312',272,'','20','3',9500.00,0.00,'Retail Sale Id 130 for 12.50 KG of Cooking Gas @ N760.00','2023-02-11 13:55:36','',''),('1','312',273,'','6.1','4',0.00,9500.00,'Retail Sale Id 130 for retail product','2023-02-11 13:55:36','',''),('1','312',274,'','20','3',1530.00,0.00,'Retail Sale Id 131 for 2.01 KG of Cooking Gas @ N760.00','2023-02-11 14:33:37','',''),('1','312',275,'','6.1','4',0.00,1530.00,'Retail Sale Id 131 for retail product','2023-02-11 14:33:37','',''),('1','312',276,'','20','3',3860.80,0.00,'Retail Sale Id 132 for 5.08 KG of Cooking Gas @ N760.00','2023-02-11 20:01:19','',''),('1','312',277,'','6.1','4',0.00,3860.80,'Retail Sale Id 132 for retail product','2023-02-11 20:01:19','',''),('1','312',278,'','20','3',11400.00,0.00,'Retail Sale Id 133 for 15.00 KG of Cooking Gas @ N760.00','2023-02-11 20:02:53','',''),('1','312',279,'','6.1','4',0.00,11400.00,'Retail Sale Id 133 for retail product','2023-02-11 20:02:53','',''),('1','312',280,'','20','3',9500.00,0.00,'Retail Sale Id 134 for 12.50 KG of Cooking Gas @ N760.00','2023-02-11 20:03:44','',''),('1','312',281,'','6.1','4',0.00,9500.00,'Retail Sale Id 134 for retail product','2023-02-11 20:03:44','',''),('1','312',282,'','20','3',9500.00,0.00,'Retail Sale Id 135 for 12.50 KG of Cooking Gas @ N760.00','2023-02-11 20:04:26','',''),('1','312',283,'','6.1','4',0.00,9500.00,'Retail Sale Id 135 for retail product','2023-02-11 20:04:26','',''),('1','312',284,'','20','3',7600.00,0.00,'Retail Sale Id 136 for 10.00 KG of Cooking Gas @ N760.00','2023-02-11 20:05:13','',''),('1','312',285,'','6.1','4',0.00,7600.00,'Retail Sale Id 136 for retail product','2023-02-11 20:05:13','',''),('1','312',286,'','20','3',8360.00,0.00,'Retail Sale Id 137 for 11.00 KG of Cooking Gas @ N760.00','2023-02-11 20:06:04','',''),('1','312',287,'','6.1','4',0.00,8360.00,'Retail Sale Id 137 for retail product','2023-02-11 20:06:04','',''),('1','312',288,'','20','3',6840.00,0.00,'Retail Sale Id 138 for 9.00 KG of Cooking Gas @ N760.00','2023-02-11 20:06:51','',''),('1','312',289,'','6.1','4',0.00,6840.00,'Retail Sale Id 138 for retail product','2023-02-11 20:06:51','',''),('1','312',290,'','20','3',3800.00,0.00,'Retail Sale Id 139 for 5.00 KG of Cooking Gas @ N760.00','2023-02-11 20:07:31','',''),('1','312',291,'','6.1','4',0.00,3800.00,'Retail Sale Id 139 for retail product','2023-02-11 20:07:31','',''),('1','312',292,'','20','3',3800.00,0.00,'Retail Sale Id 140 for 5.00 KG of Cooking Gas @ N760.00','2023-02-11 20:08:16','',''),('1','312',293,'','6.1','4',0.00,3800.00,'Retail Sale Id 140 for retail product','2023-02-11 20:08:16','',''),('1','312',294,'','20','3',7600.00,0.00,'Retail Sale Id 141 for 10.00 KG of Cooking Gas @ N760.00','2023-02-11 20:10:43','',''),('1','312',295,'','6.1','4',0.00,7600.00,'Retail Sale Id 141 for retail product','2023-02-11 20:10:43','',''),('1','312',296,'','20','3',0.00,0.00,'Sales from shift 9 on 2023-02-11 20:22:27 ','2023-02-11 20:22:27','',''),('1','312',297,'','6.1','4',0.00,0.00,'Sales from shift 9 on 2023-02-11 20:22:27 ','2023-02-11 20:22:27','',''),('1','312',298,'','20','3',9500.00,0.00,'Retail Sale Id 142 for 12.50 KG of Cooking Gas @ N760.00','2023-02-12 07:56:25','',''),('1','312',299,'','6.1','4',0.00,9500.00,'Retail Sale Id 142 for retail product','2023-02-12 07:56:25','',''),('1','312',300,'','20','3',5000.00,0.00,'Retail Sale Id 143 for 6.58 KG of Cooking Gas @ N760.00','2023-02-12 08:04:17','',''),('1','312',301,'','6.1','4',0.00,5000.00,'Retail Sale Id 143 for retail product','2023-02-12 08:04:17','',''),('1','312',302,'','20','3',3000.00,0.00,'Retail Sale Id 144 for 3.95 KG of Cooking Gas @ N760.00','2023-02-12 08:05:27','',''),('1','312',303,'','6.1','4',0.00,3000.00,'Retail Sale Id 144 for retail product','2023-02-12 08:05:27','',''),('1','312',304,'','20','3',1520.00,0.00,'Retail Sale Id 145 for 2.00 KG of Cooking Gas @ N760.00','2023-02-12 08:06:49','',''),('1','312',305,'','6.1','4',0.00,1520.00,'Retail Sale Id 145 for retail product','2023-02-12 08:06:49','',''),('1','312',306,'','20','3',10000.00,0.00,'Retail Sale Id 146 for 13.16 KG of Cooking Gas @ N760.00','2023-02-12 09:25:54','',''),('1','312',307,'','6.1','4',0.00,10000.00,'Retail Sale Id 146 for retail product','2023-02-12 09:25:54','',''),('1','312',308,'','20','3',9500.00,0.00,'Retail Sale Id 147 for 12.50 KG of Cooking Gas @ N760.00','2023-02-12 09:43:46','',''),('1','312',309,'','6.1','4',0.00,9500.00,'Retail Sale Id 147 for retail product','2023-02-12 09:43:46','',''),('1','312',310,'','20','3',3800.00,0.00,'Retail Sale Id 148 for 5.00 KG of Cooking Gas @ N760.00','2023-02-12 10:28:58','',''),('1','312',311,'','6.1','4',0.00,3800.00,'Retail Sale Id 148 for retail product','2023-02-12 10:28:58','',''),('1','312',312,'','20','3',2280.00,0.00,'Retail Sale Id 149 for 3.00 KG of Cooking Gas @ N760.00','2023-02-12 10:30:37','',''),('1','312',313,'','6.1','4',0.00,2280.00,'Retail Sale Id 149 for retail product','2023-02-12 10:30:37','',''),('1','312',314,'','20','3',7480.00,0.00,'Retail Sale Id 150 for 9.84 KG of Cooking Gas @ N760.00','2023-02-12 11:11:26','',''),('1','312',315,'','6.1','4',0.00,7480.00,'Retail Sale Id 150 for retail product','2023-02-12 11:11:26','',''),('1','312',316,'','20','3',4560.00,0.00,'Retail Sale Id 151 for 6.00 KG of Cooking Gas @ N760.00','2023-02-12 11:43:30','',''),('1','312',317,'','6.1','4',0.00,4560.00,'Retail Sale Id 151 for retail product','2023-02-12 11:43:30','',''),('1','312',318,'','20','3',5000.00,0.00,'Retail Sale Id 152 for 6.58 KG of Cooking Gas @ N760.00','2023-02-12 12:05:59','',''),('1','312',319,'','6.1','4',0.00,5000.00,'Retail Sale Id 152 for retail product','2023-02-12 12:05:59','',''),('1','312',320,'','20','3',9500.00,0.00,'Retail Sale Id 153 for 12.50 KG of Cooking Gas @ N760.00','2023-02-12 13:02:13','',''),('1','312',321,'','6.1','4',0.00,9500.00,'Retail Sale Id 153 for retail product','2023-02-12 13:02:13','',''),('1','312',322,'','20','3',10000.00,0.00,'Retail Sale Id 154 for 13.16 KG of Cooking Gas @ N760.00','2023-02-12 13:03:39','',''),('1','312',323,'','6.1','4',0.00,10000.00,'Retail Sale Id 154 for retail product','2023-02-12 13:03:39','',''),('1','312',324,'','20','3',1520.00,0.00,'Retail Sale Id 155 for 2.00 KG of Cooking Gas @ N760.00','2023-02-12 13:04:46','',''),('1','312',325,'','6.1','4',0.00,1520.00,'Retail Sale Id 155 for retail product','2023-02-12 13:04:46','',''),('1','312',326,'','20','3',9500.00,0.00,'Retail Sale Id 156 for 12.50 KG of Cooking Gas @ N760.00','2023-02-12 13:05:45','',''),('1','312',327,'','6.1','4',0.00,9500.00,'Retail Sale Id 156 for retail product','2023-02-12 13:05:45','',''),('1','312',328,'','20','3',1000.00,0.00,'Retail Sale Id 157 for 1.32 KG of Cooking Gas @ N760.00','2023-02-12 15:15:26','',''),('1','312',329,'','6.1','4',0.00,1000.00,'Retail Sale Id 157 for retail product','2023-02-12 15:15:26','',''),('1','312',330,'','20','3',9500.00,0.00,'Retail Sale Id 158 for 12.50 KG of Cooking Gas @ N760.00','2023-02-12 15:16:46','',''),('1','312',331,'','6.1','4',0.00,9500.00,'Retail Sale Id 158 for retail product','2023-02-12 15:16:46','',''),('1','312',332,'','20','3',4940.00,0.00,'Retail Sale Id 159 for 6.50 KG of Cooking Gas @ N760.00','2023-02-12 15:18:02','',''),('1','312',333,'','6.1','4',0.00,4940.00,'Retail Sale Id 159 for retail product','2023-02-12 15:18:02','',''),('1','312',334,'','20','3',3040.00,0.00,'Retail Sale Id 160 for 4.00 KG of Cooking Gas @ N760.00','2023-02-12 17:13:39','',''),('1','312',335,'','6.1','4',0.00,3040.00,'Retail Sale Id 160 for retail product','2023-02-12 17:13:39','',''),('1','312',336,'','20','3',1520.00,0.00,'Retail Sale Id 161 for 2.00 KG of Cooking Gas @ N760.00','2023-02-12 17:14:54','',''),('1','312',337,'','6.1','4',0.00,1520.00,'Retail Sale Id 161 for retail product','2023-02-12 17:14:54','',''),('1','312',338,'','20','3',4000.00,0.00,'Retail Sale Id 162 for 5.26 KG of Cooking Gas @ N760.00','2023-02-12 17:16:00','',''),('1','312',339,'','6.1','4',0.00,4000.00,'Retail Sale Id 162 for retail product','2023-02-12 17:16:00','',''),('1','312',340,'','20','3',2280.00,0.00,'Retail Sale Id 163 for 3.00 KG of Cooking Gas @ N760.00','2023-02-12 17:17:31','',''),('1','312',341,'','6.1','4',0.00,2280.00,'Retail Sale Id 163 for retail product','2023-02-12 17:17:31','',''),('1','312',342,'','20','3',5000.00,0.00,'Retail Sale Id 164 for 6.58 KG of Cooking Gas @ N760.00','2023-02-12 17:41:43','',''),('1','312',343,'','6.1','4',0.00,5000.00,'Retail Sale Id 164 for retail product','2023-02-12 17:41:43','',''),('1','312',344,'','20','3',1520.00,0.00,'Retail Sale Id 165 for 2.00 KG of Cooking Gas @ N760.00','2023-02-12 17:45:37','',''),('1','312',345,'','6.1','4',0.00,1520.00,'Retail Sale Id 165 for retail product','2023-02-12 17:45:37','',''),('1','312',346,'','20','3',5000.00,0.00,'Retail Sale Id 166 for 6.58 KG of Cooking Gas @ N760.00','2023-02-12 18:07:24','',''),('1','312',347,'','6.1','4',0.00,5000.00,'Retail Sale Id 166 for retail product','2023-02-12 18:07:24','',''),('1','312',348,'','20','3',3040.00,0.00,'Retail Sale Id 167 for 4.00 KG of Cooking Gas @ N760.00','2023-02-12 18:08:35','',''),('1','312',349,'','6.1','4',0.00,3040.00,'Retail Sale Id 167 for retail product','2023-02-12 18:08:35','',''),('1','312',350,'','20','3',23256.00,0.00,'Retail Sale Id 168 for 30.60 KG of Cooking Gas @ N760.00','2023-02-12 19:35:31','',''),('1','312',351,'','6.1','4',0.00,23256.00,'Retail Sale Id 168 for retail product','2023-02-12 19:35:31','',''),('1','312',352,'','20','3',0.00,0.00,'Sales from shift 10 on 2023-02-12 20:25:24 ','2023-02-12 20:25:24','',''),('1','312',353,'','6.1','4',0.00,0.00,'Sales from shift 10 on 2023-02-12 20:25:24 ','2023-02-12 20:25:24','',''),('1','312',354,'','20','3',2280.00,0.00,'Retail Sale Id 169 for 3.00 KG of Cooking Gas @ N760.00','2023-02-14 07:50:16','',''),('1','312',355,'','6.1','4',0.00,2280.00,'Retail Sale Id 169 for retail product','2023-02-14 07:50:16','',''),('1','312',356,'','20','3',5280.00,0.00,'Retail Sale Id 170 for 6.95 KG of Cooking Gas @ N760.00','2023-02-14 07:51:45','',''),('1','312',357,'','6.1','4',0.00,5280.00,'Retail Sale Id 170 for retail product','2023-02-14 07:51:45','',''),('1','312',358,'','20','3',9500.00,0.00,'Retail Sale Id 171 for 12.50 KG of Cooking Gas @ N760.00','2023-02-14 07:53:38','',''),('1','312',359,'','6.1','4',0.00,9500.00,'Retail Sale Id 171 for retail product','2023-02-14 07:53:38','',''),('1','312',360,'','20','3',2000.00,0.00,'Retail Sale Id 172 for 2.63 KG of Cooking Gas @ N760.00','2023-02-14 07:54:39','',''),('1','312',361,'','6.1','4',0.00,2000.00,'Retail Sale Id 172 for retail product','2023-02-14 07:54:39','',''),('1','312',362,'','20','3',4560.00,0.00,'Retail Sale Id 173 for 6.00 KG of Cooking Gas @ N760.00','2023-02-14 09:02:11','',''),('1','312',363,'','6.1','4',0.00,4560.00,'Retail Sale Id 173 for retail product','2023-02-14 09:02:11','',''),('1','312',364,'','20','3',2500.00,0.00,'Retail Sale Id 174 for 3.29 KG of Cooking Gas @ N760.00','2023-02-14 09:16:37','',''),('1','312',365,'','6.1','4',0.00,2500.00,'Retail Sale Id 174 for retail product','2023-02-14 09:16:37','',''),('1','312',366,'','20','3',3800.00,0.00,'Retail Sale Id 175 for 5.00 KG of Cooking Gas @ N760.00','2023-02-14 09:33:05','',''),('1','312',367,'','6.1','4',0.00,3800.00,'Retail Sale Id 175 for retail product','2023-02-14 09:33:05','',''),('1','312',368,'','20','3',4600.00,0.00,'Retail Sale Id 176 for 6.05 KG of Cooking Gas @ N760.00','2023-02-14 09:57:38','',''),('1','312',369,'','6.1','4',0.00,4600.00,'Retail Sale Id 176 for retail product','2023-02-14 09:57:38','',''),('1','312',370,'','20','3',2280.00,0.00,'Retail Sale Id 177 for 3.00 KG of Cooking Gas @ N760.00','2023-02-14 10:35:39','',''),('1','312',371,'','6.1','4',0.00,2280.00,'Retail Sale Id 177 for retail product','2023-02-14 10:35:39','',''),('1','312',372,'','20','3',9500.00,0.00,'Retail Sale Id 178 for 12.50 KG of Cooking Gas @ N760.00','2023-02-14 10:41:13','',''),('1','312',373,'','6.1','4',0.00,9500.00,'Retail Sale Id 178 for retail product','2023-02-14 10:41:13','',''),('1','312',374,'','20','3',4560.00,0.00,'Retail Sale Id 179 for 6.00 KG of Cooking Gas @ N760.00','2023-02-14 11:34:53','',''),('1','312',375,'','6.1','4',0.00,4560.00,'Retail Sale Id 179 for retail product','2023-02-14 11:34:53','',''),('1','312',376,'','20','3',7600.00,0.00,'Retail Sale Id 180 for 10.00 KG of Cooking Gas @ N760.00','2023-02-14 12:09:45','',''),('1','312',377,'','6.1','4',0.00,7600.00,'Retail Sale Id 180 for retail product','2023-02-14 12:09:45','',''),('1','312',378,'','20','3',4000.00,0.00,'Retail Sale Id 181 for 5.26 KG of Cooking Gas @ N760.00','2023-02-14 12:17:53','',''),('1','312',379,'','6.1','4',0.00,4000.00,'Retail Sale Id 181 for retail product','2023-02-14 12:17:53','',''),('1','312',380,'','20','3',1520.00,0.00,'Retail Sale Id 182 for 2.00 KG of Cooking Gas @ N760.00','2023-02-14 14:04:02','',''),('1','312',381,'','6.1','4',0.00,1520.00,'Retail Sale Id 182 for retail product','2023-02-14 14:04:02','',''),('1','312',382,'','20','3',2660.00,0.00,'Retail Sale Id 183 for 3.50 KG of Cooking Gas @ N760.00','2023-02-14 14:05:27','',''),('1','312',383,'','6.1','4',0.00,2660.00,'Retail Sale Id 183 for retail product','2023-02-14 14:05:27','',''),('1','312',384,'','20','3',2000.00,0.00,'Retail Sale Id 184 for 2.63 KG of Cooking Gas @ N760.00','2023-02-14 14:09:16','',''),('1','312',385,'','6.1','4',0.00,2000.00,'Retail Sale Id 184 for retail product','2023-02-14 14:09:16','',''),('1','312',386,'','20','3',4000.00,0.00,'Retail Sale Id 185 for 5.26 KG of Cooking Gas @ N760.00','2023-02-14 14:13:38','',''),('1','312',387,'','6.1','4',0.00,4000.00,'Retail Sale Id 185 for retail product','2023-02-14 14:13:38','',''),('1','312',388,'','20','3',0.00,0.00,'Sales from shift 11 on 2023-02-14 15:00:38 ','2023-02-14 15:00:38','',''),('1','312',389,'','6.1','4',0.00,0.00,'Sales from shift 11 on 2023-02-14 15:00:38 ','2023-02-14 15:00:38','',''),('1','312',390,'','20','3',5040.00,0.00,'Retail Sale Id 186 for 7.00 KG of Cooking Gas @ N720.00','2023-02-14 15:06:12','',''),('1','312',391,'','6.1','4',0.00,5040.00,'Retail Sale Id 186 for retail product','2023-02-14 15:06:12','',''),('1','312',392,'','20','3',6100.00,0.00,'Retail Sale Id 187 for 8.47 KG of Cooking Gas @ N720.00','2023-02-14 15:38:18','',''),('1','312',393,'','6.1','4',0.00,6100.00,'Retail Sale Id 187 for retail product','2023-02-14 15:38:18','',''),('1','312',394,'','20','3',1450.00,0.00,'Retail Sale Id 188 for 2.01 KG of Cooking Gas @ N720.00','2023-02-14 16:01:33','',''),('1','312',395,'','6.1','4',0.00,1450.00,'Retail Sale Id 188 for retail product','2023-02-14 16:01:33','',''),('1','312',396,'','20','3',4320.00,0.00,'Retail Sale Id 189 for 6.00 KG of Cooking Gas @ N720.00','2023-02-14 19:00:07','',''),('1','312',397,'','6.1','4',0.00,4320.00,'Retail Sale Id 189 for retail product','2023-02-14 19:00:07','',''),('1','312',398,'','20','3',2160.00,0.00,'Retail Sale Id 190 for 3.00 KG of Cooking Gas @ N720.00','2023-02-14 19:01:09','',''),('1','312',399,'','6.1','4',0.00,2160.00,'Retail Sale Id 190 for retail product','2023-02-14 19:01:09','',''),('1','312',400,'','20','3',800.00,0.00,'Retail Sale Id 191 for 1.11 KG of Cooking Gas @ N720.00','2023-02-14 19:02:11','',''),('1','312',401,'','6.1','4',0.00,800.00,'Retail Sale Id 191 for retail product','2023-02-14 19:02:11','',''),('1','312',402,'','20','3',1440.00,0.00,'Retail Sale Id 192 for 2.00 KG of Cooking Gas @ N720.00','2023-02-14 19:03:19','',''),('1','312',403,'','6.1','4',0.00,1440.00,'Retail Sale Id 192 for retail product','2023-02-14 19:03:19','',''),('1','312',404,'','20','3',2000.00,0.00,'Retail Sale Id 193 for 2.78 KG of Cooking Gas @ N720.00','2023-02-14 19:04:17','',''),('1','312',405,'','6.1','4',0.00,2000.00,'Retail Sale Id 193 for retail product','2023-02-14 19:04:17','',''),('1','312',406,'','20','3',9600.00,0.00,'Retail Sale Id 194 for 13.33 KG of Cooking Gas @ N720.00','2023-02-14 19:13:49','',''),('1','312',407,'','6.1','4',0.00,9600.00,'Retail Sale Id 194 for retail product','2023-02-14 19:13:49','',''),('1','312',408,'','20','3',9000.00,0.00,'Retail Sale Id 195 for 12.50 KG of Cooking Gas @ N720.00','2023-02-14 19:22:58','',''),('1','312',409,'','6.1','4',0.00,9000.00,'Retail Sale Id 195 for retail product','2023-02-14 19:22:58','',''),('1','312',410,'','20','3',9000.00,0.00,'Retail Sale Id 196 for 12.50 KG of Cooking Gas @ N720.00','2023-02-14 20:14:57','',''),('1','312',411,'','6.1','4',0.00,9000.00,'Retail Sale Id 196 for retail product','2023-02-14 20:14:57','',''),('1','312',412,'','20','3',0.00,0.00,'Sales from shift 12 on 2023-02-14 20:21:05 ','2023-02-14 20:21:05','',''),('1','312',413,'','6.1','4',0.00,0.00,'Sales from shift 12 on 2023-02-14 20:21:05 ','2023-02-14 20:21:05','',''),('1','312',414,'','20','3',3600.00,0.00,'Retail Sale Id 197 for 5.00 KG of Cooking Gas @ N720.00','2023-02-15 07:26:23','',''),('1','312',415,'','6.1','4',0.00,3600.00,'Retail Sale Id 197 for retail product','2023-02-15 07:26:23','',''),('1','312',416,'','20','3',9000.00,0.00,'Retail Sale Id 198 for 12.50 KG of Cooking Gas @ N720.00','2023-02-15 07:54:17','',''),('1','312',417,'','6.1','4',0.00,9000.00,'Retail Sale Id 198 for retail product','2023-02-15 07:54:17','',''),('1','312',418,'','20','3',4320.00,0.00,'Retail Sale Id 199 for 6.00 KG of Cooking Gas @ N720.00','2023-02-15 08:02:39','',''),('1','312',419,'','6.1','4',0.00,4320.00,'Retail Sale Id 199 for retail product','2023-02-15 08:02:39','',''),('1','312',420,'','20','3',2880.00,0.00,'Retail Sale Id 200 for 4.00 KG of Cooking Gas @ N720.00','2023-02-15 10:13:26','',''),('1','312',421,'','6.1','4',0.00,2880.00,'Retail Sale Id 200 for retail product','2023-02-15 10:13:26','',''),('1','312',422,'','20','3',4320.00,0.00,'Retail Sale Id 201 for 6.00 KG of Cooking Gas @ N720.00','2023-02-15 10:19:32','',''),('1','312',423,'','6.1','4',0.00,4320.00,'Retail Sale Id 201 for retail product','2023-02-15 10:19:32','',''),('1','312',424,'','20','3',2280.00,0.00,'Retail Sale Id 202 for 3.17 KG of Cooking Gas @ N720.00','2023-02-15 10:22:31','',''),('1','312',425,'','6.1','4',0.00,2280.00,'Retail Sale Id 202 for retail product','2023-02-15 10:22:31','',''),('1','312',426,'','20','3',4000.00,0.00,'Retail Sale Id 203 for 5.56 KG of Cooking Gas @ N720.00','2023-02-15 11:03:27','',''),('1','312',427,'','6.1','4',0.00,4000.00,'Retail Sale Id 203 for retail product','2023-02-15 11:03:27','',''),('1','312',428,'','20','3',9000.00,0.00,'Retail Sale Id 204 for 12.50 KG of Cooking Gas @ N720.00','2023-02-15 11:42:43','',''),('1','312',429,'','6.1','4',0.00,9000.00,'Retail Sale Id 204 for retail product','2023-02-15 11:42:43','',''),('1','312',430,'','20','3',3600.00,0.00,'Retail Sale Id 205 for 5.00 KG of Cooking Gas @ N720.00','2023-02-15 12:03:40','',''),('1','312',431,'','6.1','4',0.00,3600.00,'Retail Sale Id 205 for retail product','2023-02-15 12:03:40','',''),('1','312',432,'','20','3',4320.00,0.00,'Retail Sale Id 206 for 6.00 KG of Cooking Gas @ N720.00','2023-02-15 12:12:12','',''),('1','312',433,'','6.1','4',0.00,4320.00,'Retail Sale Id 206 for retail product','2023-02-15 12:12:12','',''),('1','312',434,'','20','3',2880.00,0.00,'Retail Sale Id 207 for 4.00 KG of Cooking Gas @ N720.00','2023-02-15 12:49:56','',''),('1','312',435,'','6.1','4',0.00,2880.00,'Retail Sale Id 207 for retail product','2023-02-15 12:49:56','',''),('1','312',436,'','20','3',4000.00,0.00,'Retail Sale Id 208 for 5.56 KG of Cooking Gas @ N720.00','2023-02-15 13:23:32','',''),('1','312',437,'','6.1','4',0.00,4000.00,'Retail Sale Id 208 for retail product','2023-02-15 13:23:32','',''),('1','312',438,'','20','3',4320.00,0.00,'Retail Sale Id 209 for 6.00 KG of Cooking Gas @ N720.00','2023-02-15 13:52:21','',''),('1','312',439,'','6.1','4',0.00,4320.00,'Retail Sale Id 209 for retail product','2023-02-15 13:52:21','',''),('1','312',440,'','20','3',2880.00,0.00,'Retail Sale Id 210 for 4.00 KG of Cooking Gas @ N720.00','2023-02-15 15:30:55','',''),('1','312',441,'','6.1','4',0.00,2880.00,'Retail Sale Id 210 for retail product','2023-02-15 15:30:55','',''),('1','312',442,'','20','3',4350.00,0.00,'Retail Sale Id 211 for 6.04 KG of Cooking Gas @ N720.00','2023-02-15 17:04:23','',''),('1','312',443,'','6.1','4',0.00,4350.00,'Retail Sale Id 211 for retail product','2023-02-15 17:04:23','',''),('1','312',444,'','20','3',9000.00,0.00,'Retail Sale Id 212 for 12.50 KG of Cooking Gas @ N720.00','2023-02-15 17:10:48','',''),('1','312',445,'','6.1','4',0.00,9000.00,'Retail Sale Id 212 for retail product','2023-02-15 17:10:48','',''),('1','312',446,'','20','3',3000.00,0.00,'Retail Sale Id 213 for 4.17 KG of Cooking Gas @ N720.00','2023-02-15 17:40:29','',''),('1','312',447,'','6.1','4',0.00,3000.00,'Retail Sale Id 213 for retail product','2023-02-15 17:40:29','',''),('1','312',448,'','20','3',4320.00,0.00,'Retail Sale Id 214 for 6.00 KG of Cooking Gas @ N720.00','2023-02-15 17:49:17','',''),('1','312',449,'','6.1','4',0.00,4320.00,'Retail Sale Id 214 for retail product','2023-02-15 17:49:17','',''),('1','312',450,'','20','3',2160.00,0.00,'Retail Sale Id 215 for 3.00 KG of Cooking Gas @ N720.00','2023-02-15 18:14:08','',''),('1','312',451,'','6.1','4',0.00,2160.00,'Retail Sale Id 215 for retail product','2023-02-15 18:14:08','',''),('1','312',452,'','20','3',7200.00,0.00,'Retail Sale Id 216 for 10.00 KG of Cooking Gas @ N720.00','2023-02-15 18:51:00','',''),('1','312',453,'','6.1','4',0.00,7200.00,'Retail Sale Id 216 for retail product','2023-02-15 18:51:00','',''),('1','312',454,'','20','3',1400.00,0.00,'Retail Sale Id 217 for 1.94 KG of Cooking Gas @ N720.00','2023-02-15 18:52:00','',''),('1','312',455,'','6.1','4',0.00,1400.00,'Retail Sale Id 217 for retail product','2023-02-15 18:52:00','',''),('1','312',456,'','20','3',3000.00,0.00,'Retail Sale Id 218 for 4.17 KG of Cooking Gas @ N720.00','2023-02-15 18:53:01','',''),('1','312',457,'','6.1','4',0.00,3000.00,'Retail Sale Id 218 for retail product','2023-02-15 18:53:01','',''),('1','312',458,'','20','3',3600.00,0.00,'Retail Sale Id 219 for 5.00 KG of Cooking Gas @ N720.00','2023-02-15 18:54:03','',''),('1','312',459,'','6.1','4',0.00,3600.00,'Retail Sale Id 219 for retail product','2023-02-15 18:54:03','',''),('1','312',460,'','20','3',12909.60,0.00,'Retail Sale Id 220 for 17.93 KG of Cooking Gas @ N720.00','2023-02-15 19:42:36','',''),('1','312',461,'','6.1','4',0.00,12909.60,'Retail Sale Id 220 for retail product','2023-02-15 19:42:36','',''),('1','312',462,'','20','3',0.00,0.00,'Sales from shift 13 on 2023-02-15 20:27:41 ','2023-02-15 20:27:41','',''),('1','312',463,'','6.1','4',0.00,0.00,'Sales from shift 13 on 2023-02-15 20:27:41 ','2023-02-15 20:27:41','',''),('1','312',464,'','20','3',9000.00,0.00,'Retail Sale Id 222 for 12.50 KG of Cooking Gas @ N720.00','2023-02-16 07:30:34','',''),('1','312',465,'','6.1','4',0.00,9000.00,'Retail Sale Id 222 for retail product','2023-02-16 07:30:34','',''),('1','312',466,'','20','3',1440.00,0.00,'Retail Sale Id 223 for 2.00 KG of Cooking Gas @ N720.00','2023-02-16 08:12:08','',''),('1','312',467,'','6.1','4',0.00,1440.00,'Retail Sale Id 223 for retail product','2023-02-16 08:12:08','',''),('1','312',468,'','20','3',5040.00,0.00,'Retail Sale Id 224 for 7.00 KG of Cooking Gas @ N720.00','2023-02-16 08:28:35','',''),('1','312',469,'','6.1','4',0.00,5040.00,'Retail Sale Id 224 for retail product','2023-02-16 08:28:35','',''),('1','312',470,'','20','3',4320.00,0.00,'Retail Sale Id 225 for 6.00 KG of Cooking Gas @ N720.00','2023-02-16 08:38:12','',''),('1','312',471,'','6.1','4',0.00,4320.00,'Retail Sale Id 225 for retail product','2023-02-16 08:38:12','',''),('1','312',472,'','20','3',4320.00,0.00,'Retail Sale Id 226 for 6.00 KG of Cooking Gas @ N720.00','2023-02-16 08:41:54','',''),('1','312',473,'','6.1','4',0.00,4320.00,'Retail Sale Id 226 for retail product','2023-02-16 08:41:54','',''),('1','312',474,'','20','3',5040.00,0.00,'Retail Sale Id 227 for 7.00 KG of Cooking Gas @ N720.00','2023-02-16 08:49:18','',''),('1','312',475,'','6.1','4',0.00,5040.00,'Retail Sale Id 227 for retail product','2023-02-16 08:49:18','',''),('1','312',476,'','20','3',9000.00,0.00,'Retail Sale Id 228 for 12.50 KG of Cooking Gas @ N720.00','2023-02-16 09:28:34','',''),('1','312',477,'','6.1','4',0.00,9000.00,'Retail Sale Id 228 for retail product','2023-02-16 09:28:34','',''),('1','312',478,'','20','3',8640.00,0.00,'Retail Sale Id 229 for 12.00 KG of Cooking Gas @ N720.00','2023-02-16 09:33:12','',''),('1','312',479,'','6.1','4',0.00,8640.00,'Retail Sale Id 229 for retail product','2023-02-16 09:33:12','',''),('1','312',480,'','20','3',2000.00,0.00,'Retail Sale Id 230 for 2.78 KG of Cooking Gas @ N720.00','2023-02-16 10:03:34','',''),('1','312',481,'','6.1','4',0.00,2000.00,'Retail Sale Id 230 for retail product','2023-02-16 10:03:34','',''),('1','312',482,'','20','3',7200.00,0.00,'Retail Sale Id 231 for 10.00 KG of Cooking Gas @ N720.00','2023-02-16 10:07:12','',''),('1','312',483,'','6.1','4',0.00,7200.00,'Retail Sale Id 231 for retail product','2023-02-16 10:07:12','',''),('1','312',484,'','20','3',2160.00,0.00,'Retail Sale Id 232 for 3.00 KG of Cooking Gas @ N720.00','2023-02-16 10:16:57','',''),('1','312',485,'','6.1','4',0.00,2160.00,'Retail Sale Id 232 for retail product','2023-02-16 10:16:57','',''),('1','312',486,'','20','3',18000.00,0.00,'Retail Sale Id 233 for 25.00 KG of Cooking Gas @ N720.00','2023-02-16 10:33:46','',''),('1','312',487,'','6.1','4',0.00,18000.00,'Retail Sale Id 233 for retail product','2023-02-16 10:33:47','',''),('1','312',488,'','20','3',1500.00,0.00,'Retail Sale Id 234 for 2.08 KG of Cooking Gas @ N720.00','2023-02-16 11:17:32','',''),('1','312',489,'','6.1','4',0.00,1500.00,'Retail Sale Id 234 for retail product','2023-02-16 11:17:32','',''),('1','312',490,'','20','3',5760.00,0.00,'Retail Sale Id 235 for 8.00 KG of Cooking Gas @ N720.00','2023-02-16 12:33:19','',''),('1','312',491,'','6.1','4',0.00,5760.00,'Retail Sale Id 235 for retail product','2023-02-16 12:33:19','',''),('1','312',492,'','20','3',5040.00,0.00,'Retail Sale Id 237 for 7.00 KG of Cooking Gas @ N720.00','2023-02-16 13:27:27','',''),('1','312',493,'','6.1','4',0.00,5040.00,'Retail Sale Id 237 for retail product','2023-02-16 13:27:27','',''),('1','312',494,'','20','3',36000.00,0.00,'Retail Sale Id 238 for 50.00 KG of Cooking Gas @ N720.00','2023-02-16 14:16:59','',''),('1','312',495,'','6.1','4',0.00,36000.00,'Retail Sale Id 238 for retail product','2023-02-16 14:16:59','',''),('1','312',496,'','20','3',1450.00,0.00,'Retail Sale Id 239 for 2.01 KG of Cooking Gas @ N720.00','2023-02-16 15:34:57','',''),('1','312',497,'','6.1','4',0.00,1450.00,'Retail Sale Id 239 for retail product','2023-02-16 15:34:57','',''),('1','312',498,'','20','3',9000.00,0.00,'Retail Sale Id 240 for 12.50 KG of Cooking Gas @ N720.00','2023-02-16 15:37:00','',''),('1','312',499,'','6.1','4',0.00,9000.00,'Retail Sale Id 240 for retail product','2023-02-16 15:37:00','',''),('1','312',500,'','20','3',8640.00,0.00,'Retail Sale Id 241 for 12.00 KG of Cooking Gas @ N720.00','2023-02-16 16:51:16','',''),('1','312',501,'','6.1','4',0.00,8640.00,'Retail Sale Id 241 for retail product','2023-02-16 16:51:16','',''),('1','312',502,'','20','3',3600.00,0.00,'Retail Sale Id 242 for 5.00 KG of Cooking Gas @ N720.00','2023-02-16 17:10:07','',''),('1','312',503,'','6.1','4',0.00,3600.00,'Retail Sale Id 242 for retail product','2023-02-16 17:10:07','',''),('1','312',504,'','20','3',4320.00,0.00,'Retail Sale Id 243 for 6.00 KG of Cooking Gas @ N720.00','2023-02-16 17:23:04','',''),('1','312',505,'','6.1','4',0.00,4320.00,'Retail Sale Id 243 for retail product','2023-02-16 17:23:04','',''),('1','312',506,'','20','3',7200.00,0.00,'Retail Sale Id 244 for 10.00 KG of Cooking Gas @ N720.00','2023-02-16 17:50:23','',''),('1','312',507,'','6.1','4',0.00,7200.00,'Retail Sale Id 244 for retail product','2023-02-16 17:50:23','',''),('1','312',508,'','20','3',2160.00,0.00,'Retail Sale Id 245 for 3.00 KG of Cooking Gas @ N720.00','2023-02-16 18:00:24','',''),('1','312',509,'','6.1','4',0.00,2160.00,'Retail Sale Id 245 for retail product','2023-02-16 18:00:24','',''),('1','312',510,'','20','3',0.00,2160.00,'Return of Retail Sale Id 245 for products','2023-02-16 18:10:51','',''),('1','312',511,'','','',2160.00,0.00,'Return of Retail Sale Id 245 for products','2023-02-16 18:10:51','',''),('1','312',512,'','20','3',1778.40,0.00,'Retail Sale Id 246 for 2.47 KG of Cooking Gas @ N720.00','2023-02-16 18:12:44','',''),('1','312',513,'','6.1','4',0.00,1778.40,'Retail Sale Id 246 for retail product','2023-02-16 18:12:44','',''),('1','312',514,'','20','3',9000.00,0.00,'Retail Sale Id 247 for 12.50 KG of Cooking Gas @ N720.00','2023-02-16 18:23:11','',''),('1','312',515,'','6.1','4',0.00,9000.00,'Retail Sale Id 247 for retail product','2023-02-16 18:23:11','',''),('1','312',516,'','20','3',3600.00,0.00,'Retail Sale Id 248 for 5.00 KG of Cooking Gas @ N720.00','2023-02-16 18:48:48','',''),('1','312',517,'','6.1','4',0.00,3600.00,'Retail Sale Id 248 for retail product','2023-02-16 18:48:48','',''),('1','312',518,'','20','3',2000.00,0.00,'Retail Sale Id 249 for 2.78 KG of Cooking Gas @ N720.00','2023-02-16 18:50:21','',''),('1','312',519,'','6.1','4',0.00,2000.00,'Retail Sale Id 249 for retail product','2023-02-16 18:50:21','',''),('1','312',520,'','20','3',0.00,3600.00,'Return of Retail Sale Id 248 for products','2023-02-16 18:54:09','',''),('1','312',521,'','','',3600.00,0.00,'Return of Retail Sale Id 248 for products','2023-02-16 18:54:09','',''),('1','312',522,'','20','3',2160.00,0.00,'Retail Sale Id 250 for 3.00 KG of Cooking Gas @ N720.00','2023-02-16 18:56:11','',''),('1','312',523,'','6.1','4',0.00,2160.00,'Retail Sale Id 250 for retail product','2023-02-16 18:56:11','',''),('1','312',524,'','20','3',0.00,0.00,'Sales from shift 14 on 2023-02-16 19:52:43 ','2023-02-16 19:52:43','',''),('1','312',525,'','6.1','4',0.00,0.00,'Sales from shift 14 on 2023-02-16 19:52:43 ','2023-02-16 19:52:43','',''),('1','312',526,'','20','3',11160.00,0.00,'Retail Sale Id 251 for 15.50 KG of Cooking Gas @ N720.00','2023-02-17 07:12:29','',''),('1','312',527,'','6.1','4',0.00,11160.00,'Retail Sale Id 251 for retail product','2023-02-17 07:12:29','',''),('1','312',528,'','20','3',7200.00,0.00,'Retail Sale Id 252 for 10.00 KG of Cooking Gas @ N720.00','2023-02-17 08:33:12','',''),('1','312',529,'','6.1','4',0.00,7200.00,'Retail Sale Id 252 for retail product','2023-02-17 08:33:12','',''),('1','312',530,'','20','3',5000.00,0.00,'Retail Sale Id 256 for 6.94 KG of Cooking Gas @ N720.00','2023-02-17 09:14:17','',''),('1','312',531,'','6.1','4',0.00,5000.00,'Retail Sale Id 256 for retail product','2023-02-17 09:14:17','',''),('1','312',532,'','20','3',1450.00,0.00,'Retail Sale Id 259 for 2.01 KG of Cooking Gas @ N720.00','2023-02-17 10:58:20','',''),('1','312',533,'','6.1','4',0.00,1450.00,'Retail Sale Id 259 for retail product','2023-02-17 10:58:20','',''),('1','312',534,'','6.1','4',0.00,1450.00,'Retail Sale Id 259 for retail product','2023-02-17 10:58:20','',''),('1','312',535,'','20','3',2160.00,0.00,'Retail Sale Id 260 for 3.00 KG of Cooking Gas @ N720.00','2023-02-17 11:03:12','',''),('1','312',536,'','6.1','4',0.00,2160.00,'Retail Sale Id 260 for retail product','2023-02-17 11:03:12','',''),('1','312',537,'','20','3',2160.00,0.00,'Retail Sale Id 261 for 3.00 KG of Cooking Gas @ N720.00','2023-02-17 11:39:16','',''),('1','312',538,'','6.1','4',0.00,2160.00,'Retail Sale Id 261 for retail product','2023-02-17 11:39:16','',''),('1','312',539,'','20','3',7200.00,0.00,'Retail Sale Id 262 for 10.00 KG of Cooking Gas @ N720.00','2023-02-17 11:40:27','',''),('1','312',540,'','6.1','4',0.00,7200.00,'Retail Sale Id 262 for retail product','2023-02-17 11:40:27','',''),('1','312',541,'','20','3',9000.00,0.00,'Retail Sale Id 263 for 12.50 KG of Cooking Gas @ N720.00','2023-02-17 12:22:03','',''),('1','312',542,'','6.1','4',0.00,9000.00,'Retail Sale Id 263 for retail product','2023-02-17 12:22:03','',''),('1','312',543,'','6.1','4',0.00,9000.00,'Retail Sale Id 263 for retail product','2023-02-17 12:22:03','',''),('1','312',544,'','20','3',3600.00,0.00,'Retail Sale Id 264 for 5.00 KG of Cooking Gas @ N720.00','2023-02-17 15:02:25','',''),('1','312',545,'','6.1','4',0.00,3600.00,'Retail Sale Id 264 for retail product','2023-02-17 15:02:25','',''),('1','312',546,'','20','3',3600.00,0.00,'Retail Sale Id 265 for 5.00 KG of Cooking Gas @ N720.00','2023-02-17 15:04:39','',''),('1','312',547,'','6.1','4',0.00,3600.00,'Retail Sale Id 265 for retail product','2023-02-17 15:04:39','',''),('1','312',548,'','20','3',4300.00,0.00,'Retail Sale Id 266 for 5.97 KG of Cooking Gas @ N720.00','2023-02-17 15:05:48','',''),('1','312',549,'','6.1','4',0.00,4300.00,'Retail Sale Id 266 for retail product','2023-02-17 15:05:48','',''),('1','312',550,'','20','3',1000.00,0.00,'Retail Sale Id 267 for 1.39 KG of Cooking Gas @ N720.00','2023-02-17 15:10:17','',''),('1','312',551,'','6.1','4',0.00,1000.00,'Retail Sale Id 267 for retail product','2023-02-17 15:10:17','',''),('1','312',552,'','20','3',4320.00,0.00,'Retail Sale Id 268 for 6.00 KG of Cooking Gas @ N720.00','2023-02-17 15:20:43','',''),('1','312',553,'','6.1','4',0.00,4320.00,'Retail Sale Id 268 for retail product','2023-02-17 15:20:43','',''),('1','312',554,'','20','3',4800.00,0.00,'Retail Sale Id 269 for 6.67 KG of Cooking Gas @ N720.00','2023-02-17 15:32:17','',''),('1','312',555,'','6.1','4',0.00,4800.00,'Retail Sale Id 269 for retail product','2023-02-17 15:32:17','',''),('1','312',556,'','20','3',3000.00,0.00,'Retail Sale Id 270 for 4.17 KG of Cooking Gas @ N720.00','2023-02-17 16:05:35','',''),('1','312',557,'','6.1','4',0.00,3000.00,'Retail Sale Id 270 for retail product','2023-02-17 16:05:35','',''),('1','312',558,'','20','3',5000.00,0.00,'Retail Sale Id 271 for 6.94 KG of Cooking Gas @ N720.00','2023-02-17 17:46:50','',''),('1','312',559,'','6.1','4',0.00,5000.00,'Retail Sale Id 271 for retail product','2023-02-17 17:46:50','',''),('1','312',560,'','20','3',3600.00,0.00,'Retail Sale Id 272 for 5.00 KG of Cooking Gas @ N720.00','2023-02-17 17:48:32','',''),('1','312',561,'','6.1','4',0.00,3600.00,'Retail Sale Id 272 for retail product','2023-02-17 17:48:32','',''),('1','312',562,'','20','3',1400.00,0.00,'Retail Sale Id 273 for 1.94 KG of Cooking Gas @ N720.00','2023-02-17 17:49:24','',''),('1','312',563,'','6.1','4',0.00,1400.00,'Retail Sale Id 273 for retail product','2023-02-17 17:49:24','',''),('1','312',564,'','20','3',2000.00,0.00,'Retail Sale Id 274 for 2.78 KG of Cooking Gas @ N720.00','2023-02-17 17:53:32','',''),('1','312',565,'','6.1','4',0.00,2000.00,'Retail Sale Id 274 for retail product','2023-02-17 17:53:32','',''),('1','312',566,'','20','3',720.00,0.00,'Retail Sale Id 275 for 1.00 KG of Cooking Gas @ N720.00','2023-02-17 17:57:10','',''),('1','312',567,'','6.1','4',0.00,720.00,'Retail Sale Id 275 for retail product','2023-02-17 17:57:10','',''),('1','312',568,'','20','3',9000.00,0.00,'Retail Sale Id 276 for 12.50 KG of Cooking Gas @ N720.00','2023-02-17 18:11:11','',''),('1','312',569,'','6.1','4',0.00,9000.00,'Retail Sale Id 276 for retail product','2023-02-17 18:11:11','',''),('1','312',570,'','20','3',9360.00,0.00,'Retail Sale Id 277 for 13.00 KG of Cooking Gas @ N720.00','2023-02-17 18:25:44','',''),('1','312',571,'','6.1','4',0.00,9360.00,'Retail Sale Id 277 for retail product','2023-02-17 18:25:44','',''),('1','312',572,'','20','3',0.00,9000.00,'Return of Retail Sale Id 276 for products','2023-02-17 19:14:52','',''),('1','312',573,'','','',9000.00,0.00,'Return of Retail Sale Id 276 for products','2023-02-17 19:14:52','',''),('1','312',574,'','20','3',8496.00,0.00,'Retail Sale Id 278 for 11.80 KG of Cooking Gas @ N720.00','2023-02-17 19:16:01','',''),('1','312',575,'','6.1','4',0.00,8496.00,'Retail Sale Id 278 for retail product','2023-02-17 19:16:01','',''),('1','312',576,'','20','3',0.00,0.00,'Sales from shift 15 on 2023-02-17 19:36:02 ','2023-02-17 19:36:02','',''),('1','312',577,'','6.1','4',0.00,0.00,'Sales from shift 15 on 2023-02-17 19:36:02 ','2023-02-17 19:36:02','',''),('1','312',578,'','20','3',10800.00,0.00,'Retail Sale Id 279 for 15.00 KG of Cooking Gas @ N720.00','2023-02-18 07:46:10','',''),('1','312',579,'','6.1','4',0.00,10800.00,'Retail Sale Id 279 for retail product','2023-02-18 07:46:10','',''),('1','312',580,'','20','3',14040.00,0.00,'Retail Sale Id 280 for 19.50 KG of Cooking Gas @ N720.00','2023-02-18 07:48:42','',''),('1','312',581,'','6.1','4',0.00,14040.00,'Retail Sale Id 280 for retail product','2023-02-18 07:48:42','',''),('1','312',582,'','20','3',3000.00,0.00,'Retail Sale Id 281 for 4.17 KG of Cooking Gas @ N720.00','2023-02-18 09:03:34','',''),('1','312',583,'','6.1','4',0.00,3000.00,'Retail Sale Id 281 for retail product','2023-02-18 09:03:34','',''),('1','312',584,'','20','3',9000.00,0.00,'Retail Sale Id 282 for 12.50 KG of Cooking Gas @ N720.00','2023-02-18 09:05:20','',''),('1','312',585,'','6.1','4',0.00,9000.00,'Retail Sale Id 282 for retail product','2023-02-18 09:05:20','',''),('1','312',586,'','20','3',9000.00,0.00,'Retail Sale Id 283 for 12.50 KG of Cooking Gas @ N720.00','2023-02-18 09:06:48','',''),('1','312',587,'','6.1','4',0.00,9000.00,'Retail Sale Id 283 for retail product','2023-02-18 09:06:48','',''),('1','312',588,'','20','3',720.00,0.00,'Retail Sale Id 284 for 1.00 KG of Cooking Gas @ N720.00','2023-02-18 09:14:50','',''),('1','312',589,'','6.1','4',0.00,720.00,'Retail Sale Id 284 for retail product','2023-02-18 09:14:50','',''),('1','312',590,'','20','3',7200.00,0.00,'Retail Sale Id 285 for 10.00 KG of Cooking Gas @ N720.00','2023-02-18 09:27:47','',''),('1','312',591,'','6.1','4',0.00,7200.00,'Retail Sale Id 285 for retail product','2023-02-18 09:27:47','',''),('1','312',592,'','20','3',16560.00,0.00,'Retail Sale Id 286 for 23.00 KG of Cooking Gas @ N720.00','2023-02-18 09:38:35','',''),('1','312',593,'','6.1','4',0.00,16560.00,'Retail Sale Id 286 for retail product','2023-02-18 09:38:35','',''),('1','312',594,'','20','3',4320.00,0.00,'Retail Sale Id 287 for 6.00 KG of Cooking Gas @ N720.00','2023-02-18 09:49:07','',''),('1','312',595,'','6.1','4',0.00,4320.00,'Retail Sale Id 287 for retail product','2023-02-18 09:49:07','',''),('1','312',596,'','20','3',1450.00,0.00,'Retail Sale Id 288 for 2.01 KG of Cooking Gas @ N720.00','2023-02-18 09:52:49','',''),('1','312',597,'','6.1','4',0.00,1450.00,'Retail Sale Id 288 for retail product','2023-02-18 09:52:49','',''),('1','312',598,'','20','3',2160.00,0.00,'Retail Sale Id 289 for 3.00 KG of Cooking Gas @ N720.00','2023-02-18 10:24:12','',''),('1','312',599,'','6.1','4',0.00,2160.00,'Retail Sale Id 289 for retail product','2023-02-18 10:24:12','',''),('1','312',600,'','20','3',3600.00,0.00,'Retail Sale Id 290 for 5.00 KG of Cooking Gas @ N720.00','2023-02-18 11:18:25','',''),('1','312',601,'','6.1','4',0.00,3600.00,'Retail Sale Id 290 for retail product','2023-02-18 11:18:25','',''),('1','312',602,'','20','3',3600.00,0.00,'Retail Sale Id 291 for 5.00 KG of Cooking Gas @ N720.00','2023-02-18 12:03:24','',''),('1','312',603,'','6.1','4',0.00,3600.00,'Retail Sale Id 291 for retail product','2023-02-18 12:03:24','',''),('1','312',604,'','20','3',5040.00,0.00,'Retail Sale Id 292 for 7.00 KG of Cooking Gas @ N720.00','2023-02-18 12:10:27','',''),('1','312',605,'','6.1','4',0.00,5040.00,'Retail Sale Id 292 for retail product','2023-02-18 12:10:27','',''),('1','312',606,'','20','3',2160.00,0.00,'Retail Sale Id 293 for 3.00 KG of Cooking Gas @ N720.00','2023-02-18 12:14:15','',''),('1','312',607,'','6.1','4',0.00,2160.00,'Retail Sale Id 293 for retail product','2023-02-18 12:14:15','',''),('1','312',608,'','20','3',3600.00,0.00,'Retail Sale Id 294 for 5.00 KG of Cooking Gas @ N720.00','2023-02-18 12:21:34','',''),('1','312',609,'','6.1','4',0.00,3600.00,'Retail Sale Id 294 for retail product','2023-02-18 12:21:34','',''),('1','312',610,'','20','3',5760.00,0.00,'Retail Sale Id 295 for 8.00 KG of Cooking Gas @ N720.00','2023-02-18 12:46:34','',''),('1','312',611,'','6.1','4',0.00,5760.00,'Retail Sale Id 295 for retail product','2023-02-18 12:46:34','',''),('1','312',612,'','20','3',3600.00,0.00,'Retail Sale Id 296 for 5.00 KG of Cooking Gas @ N720.00','2023-02-18 12:56:20','',''),('1','312',613,'','6.1','4',0.00,3600.00,'Retail Sale Id 296 for retail product','2023-02-18 12:56:20','',''),('1','312',614,'','20','3',4320.00,0.00,'Retail Sale Id 297 for 6.00 KG of Cooking Gas @ N720.00','2023-02-18 13:35:59','',''),('1','312',615,'','6.1','4',0.00,4320.00,'Retail Sale Id 297 for retail product','2023-02-18 13:35:59','',''),('1','312',616,'','20','3',3600.00,0.00,'Retail Sale Id 298 for 5.00 KG of Cooking Gas @ N720.00','2023-02-18 13:39:29','',''),('1','312',617,'','6.1','4',0.00,3600.00,'Retail Sale Id 298 for retail product','2023-02-18 13:39:29','',''),('1','312',618,'','20','3',7920.00,0.00,'Retail Sale Id 299 for 11.00 KG of Cooking Gas @ N720.00','2023-02-18 14:12:50','',''),('1','312',619,'','6.1','4',0.00,7920.00,'Retail Sale Id 299 for retail product','2023-02-18 14:12:50','',''),('1','312',620,'','20','3',3600.00,0.00,'Retail Sale Id 300 for 5.00 KG of Cooking Gas @ N720.00','2023-02-18 15:14:51','',''),('1','312',621,'','6.1','4',0.00,3600.00,'Retail Sale Id 300 for retail product','2023-02-18 15:14:51','',''),('1','312',622,'','20','3',4320.00,0.00,'Retail Sale Id 301 for 6.00 KG of Cooking Gas @ N720.00','2023-02-18 15:15:51','',''),('1','312',623,'','6.1','4',0.00,4320.00,'Retail Sale Id 301 for retail product','2023-02-18 15:15:51','',''),('1','312',624,'','20','3',9000.00,0.00,'Retail Sale Id 302 for 12.50 KG of Cooking Gas @ N720.00','2023-02-18 15:16:57','',''),('1','312',625,'','6.1','4',0.00,9000.00,'Retail Sale Id 302 for retail product','2023-02-18 15:16:57','',''),('1','312',626,'','20','3',33120.00,0.00,'Retail Sale Id 303 for 46.00 KG of Cooking Gas @ N720.00','2023-02-18 15:22:23','',''),('1','312',627,'','6.1','4',0.00,33120.00,'Retail Sale Id 303 for retail product','2023-02-18 15:22:23','',''),('1','312',628,'','20','3',5040.00,0.00,'Retail Sale Id 304 for 7.00 KG of Cooking Gas @ N720.00','2023-02-18 15:33:22','',''),('1','312',629,'','6.1','4',0.00,5040.00,'Retail Sale Id 304 for retail product','2023-02-18 15:33:22','',''),('1','312',630,'','20','3',9000.00,0.00,'Retail Sale Id 305 for 12.50 KG of Cooking Gas @ N720.00','2023-02-18 15:37:48','',''),('1','312',631,'','6.1','4',0.00,9000.00,'Retail Sale Id 305 for retail product','2023-02-18 15:37:48','',''),('1','312',632,'','20','3',139400.00,0.00,'Retail Sale Id 307 for 205.00 KG of Cooking Gas @ N680.00','2023-02-18 16:05:04','',''),('1','312',633,'','6.1','4',0.00,139400.00,'Retail Sale Id 307 for retail product','2023-02-18 16:05:04','',''),('1','312',634,'','20','3',2160.00,0.00,'Retail Sale Id 308 for 3.00 KG of Cooking Gas @ N720.00','2023-02-18 16:34:00','',''),('1','312',635,'','6.1','4',0.00,2160.00,'Retail Sale Id 308 for retail product','2023-02-18 16:34:00','',''),('1','312',636,'','20','3',2880.00,0.00,'Retail Sale Id 309 for 4.00 KG of Cooking Gas @ N720.00','2023-02-18 16:35:03','',''),('1','312',637,'','6.1','4',0.00,2880.00,'Retail Sale Id 309 for retail product','2023-02-18 16:35:03','',''),('1','312',638,'','20','3',1300.00,0.00,'Retail Sale Id 310 for 1.81 KG of Cooking Gas @ N720.00','2023-02-18 16:41:27','',''),('1','312',639,'','6.1','4',0.00,1300.00,'Retail Sale Id 310 for retail product','2023-02-18 16:41:27','',''),('1','312',640,'','20','3',9000.00,0.00,'Retail Sale Id 311 for 12.50 KG of Cooking Gas @ N720.00','2023-02-18 16:58:27','',''),('1','312',641,'','6.1','4',0.00,9000.00,'Retail Sale Id 311 for retail product','2023-02-18 16:58:27','',''),('1','312',642,'','20','3',9000.00,0.00,'Retail Sale Id 312 for 12.50 KG of Cooking Gas @ N720.00','2023-02-18 17:04:12','',''),('1','312',643,'','6.1','4',0.00,9000.00,'Retail Sale Id 312 for retail product','2023-02-18 17:04:12','',''),('1','312',644,'','20','3',2200.00,0.00,'Retail Sale Id 313 for 3.06 KG of Cooking Gas @ N720.00','2023-02-18 17:06:00','',''),('1','312',645,'','6.1','4',0.00,2200.00,'Retail Sale Id 313 for retail product','2023-02-18 17:06:00','',''),('1','312',646,'','20','3',5040.00,0.00,'Retail Sale Id 314 for 7.00 KG of Cooking Gas @ N720.00','2023-02-18 17:09:31','',''),('1','312',647,'','6.1','4',0.00,5040.00,'Retail Sale Id 314 for retail product','2023-02-18 17:09:31','',''),('1','312',648,'','20','3',2160.00,0.00,'Retail Sale Id 315 for 3.00 KG of Cooking Gas @ N720.00','2023-02-18 17:23:55','',''),('1','312',649,'','6.1','4',0.00,2160.00,'Retail Sale Id 315 for retail product','2023-02-18 17:23:55','',''),('1','312',650,'','20','3',2200.00,0.00,'Retail Sale Id 316 for 3.06 KG of Cooking Gas @ N720.00','2023-02-18 17:38:35','',''),('1','312',651,'','6.1','4',0.00,2200.00,'Retail Sale Id 316 for retail product','2023-02-18 17:38:35','',''),('1','312',652,'','20','3',1450.00,0.00,'Retail Sale Id 317 for 2.01 KG of Cooking Gas @ N720.00','2023-02-18 17:43:03','',''),('1','312',653,'','6.1','4',0.00,1450.00,'Retail Sale Id 317 for retail product','2023-02-18 17:43:03','',''),('1','312',654,'','20','3',6480.00,0.00,'Retail Sale Id 318 for 9.00 KG of Cooking Gas @ N720.00','2023-02-18 18:06:05','',''),('1','312',655,'','6.1','4',0.00,6480.00,'Retail Sale Id 318 for retail product','2023-02-18 18:06:05','',''),('1','312',656,'','20','3',5040.00,0.00,'Retail Sale Id 319 for 7.00 KG of Cooking Gas @ N720.00','2023-02-18 18:08:06','',''),('1','312',657,'','6.1','4',0.00,5040.00,'Retail Sale Id 319 for retail product','2023-02-18 18:08:06','',''),('1','312',658,'','20','3',261501.75,0.00,'Retail Sale Id 320 for 387.41 KG of Cooking Gas @ N675.00','2023-02-18 18:13:22','',''),('1','312',659,'','6.1','4',0.00,261501.75,'Retail Sale Id 320 for retail product','2023-02-18 18:13:22','',''),('1','312',660,'','20','3',10800.00,0.00,'Retail Sale Id 321 for 15.00 KG of Cooking Gas @ N720.00','2023-02-18 18:17:19','',''),('1','312',661,'','6.1','4',0.00,10800.00,'Retail Sale Id 321 for retail product','2023-02-18 18:17:19','',''),('1','312',662,'','20','3',1908.00,0.00,'Retail Sale Id 322 for 2.65 KG of Cooking Gas @ N720.00','2023-02-18 19:01:00','',''),('1','312',663,'','6.1','4',0.00,1908.00,'Retail Sale Id 322 for retail product','2023-02-18 19:01:00','',''),('1','312',664,'','20','3',0.00,0.00,'Sales from shift 16 on 2023-02-18 21:17:42 ','2023-02-18 21:17:42','',''),('1','312',665,'','6.1','4',0.00,0.00,'Sales from shift 16 on 2023-02-18 21:17:42 ','2023-02-18 21:17:42','',''),('1','312',666,'','20','3',8600.00,0.00,'Retail Sale Id 323 for 11.94 KG of Cooking Gas @ N720.00','2023-02-19 08:39:18','',''),('1','312',667,'','6.1','4',0.00,8600.00,'Retail Sale Id 323 for retail product','2023-02-19 08:39:18','',''),('1','312',668,'','20','3',7200.00,0.00,'Retail Sale Id 324 for 10.00 KG of Cooking Gas @ N720.00','2023-02-19 08:51:20','',''),('1','312',669,'','6.1','4',0.00,7200.00,'Retail Sale Id 324 for retail product','2023-02-19 08:51:20','',''),('1','312',670,'','20','3',2160.00,0.00,'Retail Sale Id 325 for 3.00 KG of Cooking Gas @ N720.00','2023-02-19 08:53:49','',''),('1','312',671,'','6.1','4',0.00,2160.00,'Retail Sale Id 325 for retail product','2023-02-19 08:53:49','',''),('1','312',672,'','20','3',9000.00,0.00,'Retail Sale Id 326 for 12.50 KG of Cooking Gas @ N720.00','2023-02-19 08:56:31','',''),('1','312',673,'','6.1','4',0.00,9000.00,'Retail Sale Id 326 for retail product','2023-02-19 08:56:31','',''),('1','312',674,'','20','3',2000.00,0.00,'Retail Sale Id 327 for 2.78 KG of Cooking Gas @ N720.00','2023-02-19 11:03:56','',''),('1','312',675,'','6.1','4',0.00,2000.00,'Retail Sale Id 327 for retail product','2023-02-19 11:03:56','',''),('1','312',676,'','20','3',9000.00,0.00,'Retail Sale Id 328 for 12.50 KG of Cooking Gas @ N720.00','2023-02-19 11:05:09','',''),('1','312',677,'','6.1','4',0.00,9000.00,'Retail Sale Id 328 for retail product','2023-02-19 11:05:09','',''),('1','312',678,'','20','3',1500.00,0.00,'Retail Sale Id 329 for 2.08 KG of Cooking Gas @ N720.00','2023-02-19 11:07:52','',''),('1','312',679,'','6.1','4',0.00,1500.00,'Retail Sale Id 329 for retail product','2023-02-19 11:07:52','',''),('1','312',680,'','20','3',3600.00,0.00,'Retail Sale Id 330 for 5.00 KG of Cooking Gas @ N720.00','2023-02-19 11:08:46','',''),('1','312',681,'','6.1','4',0.00,3600.00,'Retail Sale Id 330 for retail product','2023-02-19 11:08:46','',''),('1','312',682,'','20','3',4320.00,0.00,'Retail Sale Id 331 for 6.00 KG of Cooking Gas @ N720.00','2023-02-19 11:09:45','',''),('1','312',683,'','6.1','4',0.00,4320.00,'Retail Sale Id 331 for retail product','2023-02-19 11:09:45','',''),('1','312',684,'','20','3',3600.00,0.00,'Retail Sale Id 332 for 5.00 KG of Cooking Gas @ N720.00','2023-02-19 11:11:33','',''),('1','312',685,'','6.1','4',0.00,3600.00,'Retail Sale Id 332 for retail product','2023-02-19 11:11:33','',''),('1','312',686,'','20','3',4320.00,0.00,'Retail Sale Id 333 for 6.00 KG of Cooking Gas @ N720.00','2023-02-19 11:12:35','',''),('1','312',687,'','6.1','4',0.00,4320.00,'Retail Sale Id 333 for retail product','2023-02-19 11:12:35','',''),('1','312',688,'','20','3',1440.00,0.00,'Retail Sale Id 334 for 2.00 KG of Cooking Gas @ N720.00','2023-02-19 11:13:38','',''),('1','312',689,'','6.1','4',0.00,1440.00,'Retail Sale Id 334 for retail product','2023-02-19 11:13:38','',''),('1','312',690,'','20','3',5040.00,0.00,'Retail Sale Id 335 for 7.00 KG of Cooking Gas @ N720.00','2023-02-19 11:34:40','',''),('1','312',691,'','6.1','4',0.00,5040.00,'Retail Sale Id 335 for retail product','2023-02-19 11:34:40','',''),('1','312',692,'','20','3',8280.00,0.00,'Retail Sale Id 336 for 11.50 KG of Cooking Gas @ N720.00','2023-02-19 11:38:29','',''),('1','312',693,'','6.1','4',0.00,8280.00,'Retail Sale Id 336 for retail product','2023-02-19 11:38:29','',''),('1','312',694,'','20','3',1800.00,0.00,'Retail Sale Id 337 for 2.50 KG of Cooking Gas @ N720.00','2023-02-19 12:01:13','',''),('1','312',695,'','6.1','4',0.00,1800.00,'Retail Sale Id 337 for retail product','2023-02-19 12:01:13','',''),('1','312',696,'','20','3',5040.00,0.00,'Retail Sale Id 338 for 7.00 KG of Cooking Gas @ N720.00','2023-02-19 13:32:51','',''),('1','312',697,'','6.1','4',0.00,5040.00,'Retail Sale Id 338 for retail product','2023-02-19 13:32:51','',''),('1','312',698,'','20','3',7200.00,0.00,'Retail Sale Id 339 for 10.00 KG of Cooking Gas @ N720.00','2023-02-19 13:43:14','',''),('1','312',699,'','6.1','4',0.00,7200.00,'Retail Sale Id 339 for retail product','2023-02-19 13:43:14','',''),('1','312',700,'','20','3',2160.00,0.00,'Retail Sale Id 340 for 3.00 KG of Cooking Gas @ N720.00','2023-02-19 13:44:03','',''),('1','312',701,'','6.1','4',0.00,2160.00,'Retail Sale Id 340 for retail product','2023-02-19 13:44:03','',''),('1','312',702,'','20','3',2160.00,0.00,'Retail Sale Id 341 for 3.00 KG of Cooking Gas @ N720.00','2023-02-19 13:45:02','',''),('1','312',703,'','6.1','4',0.00,2160.00,'Retail Sale Id 341 for retail product','2023-02-19 13:45:02','',''),('1','312',704,'','20','3',7200.00,0.00,'Retail Sale Id 342 for 10.00 KG of Cooking Gas @ N720.00','2023-02-19 13:52:09','',''),('1','312',705,'','6.1','4',0.00,7200.00,'Retail Sale Id 342 for retail product','2023-02-19 13:52:09','',''),('1','312',706,'','20','3',21600.00,0.00,'Retail Sale Id 343 for 30.00 KG of Cooking Gas @ N720.00','2023-02-19 13:57:10','',''),('1','312',707,'','6.1','4',0.00,21600.00,'Retail Sale Id 343 for retail product','2023-02-19 13:57:10','',''),('1','312',708,'','20','3',1450.00,0.00,'Retail Sale Id 344 for 2.01 KG of Cooking Gas @ N720.00','2023-02-19 15:06:09','',''),('1','312',709,'','6.1','4',0.00,1450.00,'Retail Sale Id 344 for retail product','2023-02-19 15:06:09','',''),('1','312',710,'','20','3',2900.00,0.00,'Retail Sale Id 345 for 4.03 KG of Cooking Gas @ N720.00','2023-02-19 15:15:35','',''),('1','312',711,'','6.1','4',0.00,2900.00,'Retail Sale Id 345 for retail product','2023-02-19 15:15:35','',''),('1','312',712,'','20','3',9000.00,0.00,'Retail Sale Id 346 for 12.50 KG of Cooking Gas @ N720.00','2023-02-19 15:17:00','',''),('1','312',713,'','6.1','4',0.00,9000.00,'Retail Sale Id 346 for retail product','2023-02-19 15:17:00','',''),('1','312',714,'','20','3',9000.00,0.00,'Retail Sale Id 347 for 12.50 KG of Cooking Gas @ N720.00','2023-02-19 15:20:40','',''),('1','312',715,'','6.1','4',0.00,9000.00,'Retail Sale Id 347 for retail product','2023-02-19 15:20:40','',''),('1','312',716,'','20','3',4320.00,0.00,'Retail Sale Id 348 for 6.00 KG of Cooking Gas @ N720.00','2023-02-19 16:51:35','',''),('1','312',717,'','6.1','4',0.00,4320.00,'Retail Sale Id 348 for retail product','2023-02-19 16:51:35','',''),('1','312',718,'','20','3',3600.00,0.00,'Retail Sale Id 349 for 5.00 KG of Cooking Gas @ N720.00','2023-02-19 17:01:07','',''),('1','312',719,'','6.1','4',0.00,3600.00,'Retail Sale Id 349 for retail product','2023-02-19 17:01:07','',''),('1','312',720,'','20','3',3600.00,0.00,'Retail Sale Id 350 for 5.00 KG of Cooking Gas @ N720.00','2023-02-19 17:45:27','',''),('1','312',721,'','6.1','4',0.00,3600.00,'Retail Sale Id 350 for retail product','2023-02-19 17:45:27','',''),('1','312',722,'','20','3',5040.00,0.00,'Retail Sale Id 351 for 7.00 KG of Cooking Gas @ N720.00','2023-02-19 17:46:59','',''),('1','312',723,'','6.1','4',0.00,5040.00,'Retail Sale Id 351 for retail product','2023-02-19 17:46:59','',''),('1','312',724,'','20','3',16200.00,0.00,'Retail Sale Id 352 for 22.50 KG of Cooking Gas @ N720.00','2023-02-19 17:48:13','',''),('1','312',725,'','6.1','4',0.00,16200.00,'Retail Sale Id 352 for retail product','2023-02-19 17:48:13','',''),('1','312',726,'','20','3',18000.00,0.00,'Retail Sale Id 353 for 25.00 KG of Cooking Gas @ N720.00','2023-02-19 17:49:16','',''),('1','312',727,'','6.1','4',0.00,18000.00,'Retail Sale Id 353 for retail product','2023-02-19 17:49:16','',''),('1','312',728,'','20','3',2160.00,0.00,'Retail Sale Id 354 for 3.00 KG of Cooking Gas @ N720.00','2023-02-19 17:50:39','',''),('1','312',729,'','6.1','4',0.00,2160.00,'Retail Sale Id 354 for retail product','2023-02-19 17:50:39','',''),('1','312',730,'','20','3',7200.00,0.00,'Retail Sale Id 355 for 10.00 KG of Cooking Gas @ N720.00','2023-02-19 17:51:28','',''),('1','312',731,'','6.1','4',0.00,7200.00,'Retail Sale Id 355 for retail product','2023-02-19 17:51:28','',''),('1','312',732,'','20','3',5040.00,0.00,'Retail Sale Id 356 for 7.00 KG of Cooking Gas @ N720.00','2023-02-19 17:54:00','',''),('1','312',733,'','6.1','4',0.00,5040.00,'Retail Sale Id 356 for retail product','2023-02-19 17:54:00','',''),('1','312',734,'','20','3',1800.00,0.00,'Retail Sale Id 357 for 2.50 KG of Cooking Gas @ N720.00','2023-02-19 17:56:00','',''),('1','312',735,'','6.1','4',0.00,1800.00,'Retail Sale Id 357 for retail product','2023-02-19 17:56:00','',''),('1','312',736,'','20','3',1450.00,0.00,'Retail Sale Id 358 for 2.01 KG of Cooking Gas @ N720.00','2023-02-19 17:58:40','',''),('1','312',737,'','6.1','4',0.00,1450.00,'Retail Sale Id 358 for retail product','2023-02-19 17:58:40','',''),('1','312',738,'','20','3',36000.00,0.00,'Retail Sale Id 359 for 50.00 KG of Cooking Gas @ N720.00','2023-02-19 18:04:51','',''),('1','312',739,'','6.1','4',0.00,36000.00,'Retail Sale Id 359 for retail product','2023-02-19 18:04:51','',''),('1','312',740,'','20','3',5400.00,0.00,'Retail Sale Id 360 for 7.50 KG of Cooking Gas @ N720.00','2023-02-19 18:07:58','',''),('1','312',741,'','6.1','4',0.00,5400.00,'Retail Sale Id 360 for retail product','2023-02-19 18:07:58','',''),('1','312',742,'','20','3',9360.00,0.00,'Retail Sale Id 361 for 13.00 KG of Cooking Gas @ N720.00','2023-02-19 18:50:50','',''),('1','312',743,'','6.1','4',0.00,9360.00,'Retail Sale Id 361 for retail product','2023-02-19 18:50:50','',''),('1','312',744,'','20','3',11000.00,0.00,'Retail Sale Id 362 for 15.28 KG of Cooking Gas @ N720.00','2023-02-19 19:25:02','',''),('1','312',745,'','6.1','4',0.00,11000.00,'Retail Sale Id 362 for retail product','2023-02-19 19:25:02','',''),('1','312',746,'','20','3',0.00,9360.00,'Return of Retail Sale Id 361 for products','2023-02-19 19:27:57','',''),('1','312',747,'','','',9360.00,0.00,'Return of Retail Sale Id 361 for products','2023-02-19 19:27:57','',''),('1','312',748,'','20','3',0.00,2160.00,'Return of Retail Sale Id 354 for products','2023-02-19 19:35:24','',''),('1','312',749,'','','',2160.00,0.00,'Return of Retail Sale Id 354 for products','2023-02-19 19:35:24','',''),('1','312',750,'','20','3',921.60,0.00,'Retail Sale Id 363 for 1.28 KG of Cooking Gas @ N720.00','2023-02-19 19:36:23','',''),('1','312',751,'','6.1','4',0.00,921.60,'Retail Sale Id 363 for retail product','2023-02-19 19:36:23','',''),('1','312',752,'','20','3',0.00,0.00,'Sales from shift 17 on 2023-02-19 20:37:49 ','2023-02-19 20:37:49','',''),('1','312',753,'','6.1','4',0.00,0.00,'Sales from shift 17 on 2023-02-19 20:37:49 ','2023-02-19 20:37:49','',''),('1','312',754,'','2','19',6840.00,0.00,'Payment Id 1 for invoice:1, receipt: 000 by AA RANO NIGERIA LTD','2023-02-20 16:16:47','',''),('1','312',755,'','supplier','1',0.00,6840.00,'Payment Id 1 for invoice:1, receipt: 000 by AA RANO NIGERIA LTD','2023-02-20 16:16:47','',''),('1','312',756,'','2','19',71705.00,0.00,'Payment Id 2 for invoice:2, receipt: 000 by AA RANO NIGERIA LTD','2023-02-20 16:20:20','',''),('1','312',757,'','supplier','1',0.00,71705.00,'Payment Id 2 for invoice:2, receipt: 000 by AA RANO NIGERIA LTD','2023-02-20 16:20:20','',''),('1','312',758,'','2','19',138350.00,0.00,'Payment Id 3 for invoice:3, receipt: 000 by AA RANO NIGERIA LTD','2023-02-20 16:20:42','',''),('1','312',759,'','supplier','1',0.00,138350.00,'Payment Id 3 for invoice:3, receipt: 000 by AA RANO NIGERIA LTD','2023-02-20 16:20:42','',''),('1','312',760,'','2','19',135280.00,0.00,'Payment Id 4 for invoice:4, receipt: 000 by AA RANO NIGERIA LTD','2023-02-20 16:22:11','',''),('1','312',761,'','supplier','1',0.00,135280.00,'Payment Id 4 for invoice:4, receipt: 000 by AA RANO NIGERIA LTD','2023-02-20 16:22:11','',''),('1','312',762,'','2','19',150820.00,0.00,'Payment Id 5 for invoice:5, receipt: 000 by AA RANO NIGERIA LTD','2023-02-20 16:22:39','',''),('1','312',763,'','supplier','1',0.00,150820.00,'Payment Id 5 for invoice:5, receipt: 000 by AA RANO NIGERIA LTD','2023-02-20 16:22:39','',''),('1','312',764,'','2','8',117526.00,0.00,'Payment Id 8 for invoice:8, receipt: p o s by AA RANO NIGERIA LTD','2023-02-20 16:33:58','',''),('1','312',765,'','supplier','1',0.00,117526.00,'Payment Id 8 for invoice:8, receipt: p o s by AA RANO NIGERIA LTD','2023-02-20 16:33:58','',''),('1','312',766,'','2','8',122371.80,0.00,'Payment Id 10 for invoice:9, receipt: p o s by AA RANO NIGERIA LTD','2023-02-20 16:34:42','',''),('1','312',767,'','supplier','1',0.00,122371.80,'Payment Id 10 for invoice:9, receipt: p o s by AA RANO NIGERIA LTD','2023-02-20 16:34:42','',''),('1','312',768,'','2','8',96320.00,0.00,'Payment Id 12 for invoice:10, receipt: p o s by AA RANO NIGERIA LTD','2023-02-20 16:35:20','',''),('1','312',769,'','supplier','1',0.00,96320.00,'Payment Id 12 for invoice:10, receipt: p o s by AA RANO NIGERIA LTD','2023-02-20 16:35:20','',''),('1','312',770,'','2','8',47460.00,0.00,'Payment Id 15 for invoice:12, receipt: p o s by AA RANO NIGERIA LTD','2023-02-20 16:36:06','',''),('1','312',771,'','supplier','1',0.00,47460.00,'Payment Id 15 for invoice:12, receipt: p o s by AA RANO NIGERIA LTD','2023-02-20 16:36:06','',''),('1','312',772,'','2','8',39280.00,0.00,'Payment Id 17 for invoice:13, receipt: p o s by AA RANO NIGERIA LTD','2023-02-20 16:36:45','',''),('1','312',773,'','supplier','1',0.00,39280.00,'Payment Id 17 for invoice:13, receipt: p o s by AA RANO NIGERIA LTD','2023-02-20 16:36:45','',''),('1','312',774,'','2','8',93080.00,0.00,'Payment Id 19 for invoice:14, receipt: p o s by AA RANO NIGERIA LTD','2023-02-20 16:38:10','',''),('1','312',775,'','supplier','1',0.00,93080.00,'Payment Id 19 for invoice:14, receipt: p o s by AA RANO NIGERIA LTD','2023-02-20 16:38:10','',''),('1','312',776,'','2','19',63166.00,0.00,'Payment Id 20 for invoice:15, receipt: 000 by AA RANO NIGERIA LTD','2023-02-20 16:39:48','',''),('1','312',777,'','supplier','1',0.00,63166.00,'Payment Id 20 for invoice:15, receipt: 000 by AA RANO NIGERIA LTD','2023-02-20 16:39:48','',''),('1','312',778,'','20','3',3600.00,0.00,'Retail Sale Id 364 for 5.00 KG of Cooking Gas @ N720.00','2023-02-21 08:02:41','',''),('1','312',779,'','6.1','4',0.00,3600.00,'Retail Sale Id 364 for retail product','2023-02-21 08:02:41','',''),('1','312',780,'','20','3',7200.00,0.00,'Retail Sale Id 365 for 10.00 KG of Cooking Gas @ N720.00','2023-02-21 08:46:33','',''),('1','312',781,'','6.1','4',0.00,7200.00,'Retail Sale Id 365 for retail product','2023-02-21 08:46:33','',''),('1','312',782,'','20','3',4320.00,0.00,'Retail Sale Id 366 for 6.00 KG of Cooking Gas @ N720.00','2023-02-21 08:47:31','',''),('1','312',783,'','6.1','4',0.00,4320.00,'Retail Sale Id 366 for retail product','2023-02-21 08:47:31','',''),('1','312',784,'','20','3',3000.00,0.00,'Retail Sale Id 367 for 4.17 KG of Cooking Gas @ N720.00','2023-02-21 08:49:02','',''),('1','312',785,'','6.1','4',0.00,3000.00,'Retail Sale Id 367 for retail product','2023-02-21 08:49:02','',''),('1','312',786,'','20','3',12600.00,0.00,'Retail Sale Id 368 for 17.50 KG of Cooking Gas @ N720.00','2023-02-21 08:50:04','',''),('1','312',787,'','6.1','4',0.00,12600.00,'Retail Sale Id 368 for retail product','2023-02-21 08:50:04','',''),('1','312',788,'','20','3',9000.00,0.00,'Retail Sale Id 369 for 12.50 KG of Cooking Gas @ N720.00','2023-02-21 09:01:37','',''),('1','312',789,'','6.1','4',0.00,9000.00,'Retail Sale Id 369 for retail product','2023-02-21 09:01:37','',''),('1','312',790,'','20','3',3600.00,0.00,'Retail Sale Id 370 for 5.00 KG of Cooking Gas @ N720.00','2023-02-21 09:02:34','',''),('1','312',791,'','6.1','4',0.00,3600.00,'Retail Sale Id 370 for retail product','2023-02-21 09:02:34','',''),('1','312',792,'','20','3',7200.00,0.00,'Retail Sale Id 371 for 10.00 KG of Cooking Gas @ N720.00','2023-02-21 09:18:32','',''),('1','312',793,'','6.1','4',0.00,7200.00,'Retail Sale Id 371 for retail product','2023-02-21 09:18:32','',''),('1','312',794,'','20','3',7920.00,0.00,'Retail Sale Id 372 for 11.00 KG of Cooking Gas @ N720.00','2023-02-21 09:20:17','',''),('1','312',795,'','6.1','4',0.00,7920.00,'Retail Sale Id 372 for retail product','2023-02-21 09:20:17','',''),('1','312',796,'','20','3',81600.00,0.00,'Retail Sale Id 373 for 113.33 KG of Cooking Gas @ N720.00','2023-02-21 09:50:44','',''),('1','312',797,'','6.1','4',0.00,81600.00,'Retail Sale Id 373 for retail product','2023-02-21 09:50:44','',''),('1','312',798,'','20','3',2200.00,0.00,'Retail Sale Id 374 for 3.06 KG of Cooking Gas @ N720.00','2023-02-21 09:51:51','',''),('1','312',799,'','6.1','4',0.00,2200.00,'Retail Sale Id 374 for retail product','2023-02-21 09:51:51','',''),('1','312',800,'','20','3',9000.00,0.00,'Retail Sale Id 376 for 12.50 KG of Cooking Gas @ N720.00','2023-02-21 09:53:24','',''),('1','312',801,'','6.1','4',0.00,9000.00,'Retail Sale Id 376 for retail product','2023-02-21 09:53:24','',''),('1','312',802,'','20','3',3600.00,0.00,'Retail Sale Id 377 for 5.00 KG of Cooking Gas @ N720.00','2023-02-21 10:29:58','',''),('1','312',803,'','6.1','4',0.00,3600.00,'Retail Sale Id 377 for retail product','2023-02-21 10:29:58','',''),('1','312',804,'','20','3',2200.00,0.00,'Retail Sale Id 378 for 3.06 KG of Cooking Gas @ N720.00','2023-02-21 11:12:53','',''),('1','312',805,'','6.1','4',0.00,2200.00,'Retail Sale Id 378 for retail product','2023-02-21 11:12:53','',''),('1','312',806,'','20','3',9000.00,0.00,'Retail Sale Id 379 for 12.50 KG of Cooking Gas @ N720.00','2023-02-21 11:14:34','',''),('1','312',807,'','6.1','4',0.00,9000.00,'Retail Sale Id 379 for retail product','2023-02-21 11:14:34','',''),('1','312',808,'','20','3',9000.00,0.00,'Retail Sale Id 380 for 12.50 KG of Cooking Gas @ N720.00','2023-02-21 11:54:13','',''),('1','312',809,'','6.1','4',0.00,9000.00,'Retail Sale Id 380 for retail product','2023-02-21 11:54:13','',''),('1','312',810,'','20','3',4320.00,0.00,'Retail Sale Id 381 for 6.00 KG of Cooking Gas @ N720.00','2023-02-21 12:06:32','',''),('1','312',811,'','6.1','4',0.00,4320.00,'Retail Sale Id 381 for retail product','2023-02-21 12:06:32','',''),('1','312',812,'','20','3',4320.00,0.00,'Retail Sale Id 382 for 6.00 KG of Cooking Gas @ N720.00','2023-02-21 12:09:05','',''),('1','312',813,'','6.1','4',0.00,4320.00,'Retail Sale Id 382 for retail product','2023-02-21 12:09:05','',''),('1','312',814,'','20','3',2160.00,0.00,'Retail Sale Id 383 for 3.00 KG of Cooking Gas @ N720.00','2023-02-21 12:17:34','',''),('1','312',815,'','6.1','4',0.00,2160.00,'Retail Sale Id 383 for retail product','2023-02-21 12:17:34','',''),('1','312',816,'','20','3',9000.00,0.00,'Retail Sale Id 384 for 12.50 KG of Cooking Gas @ N720.00','2023-02-21 12:25:53','',''),('1','312',817,'','6.1','4',0.00,9000.00,'Retail Sale Id 384 for retail product','2023-02-21 12:25:53','',''),('1','312',818,'','20','3',74800.00,0.00,'Retail Sale Id 385 for 110.00 KG of Cooking Gas @ N680.00','2023-02-21 12:28:38','',''),('1','312',819,'','6.1','4',0.00,74800.00,'Retail Sale Id 385 for retail product','2023-02-21 12:28:38','',''),('1','312',820,'','20','3',2000.00,0.00,'Retail Sale Id 386 for 2.78 KG of Cooking Gas @ N720.00','2023-02-21 12:30:14','',''),('1','312',821,'','6.1','4',0.00,2000.00,'Retail Sale Id 386 for retail product','2023-02-21 12:30:14','',''),('1','312',822,'','2','8',238520.00,0.00,'Payment Id 23 for invoice:16, receipt: p o s by AA RANO NIGERIA LTD','2023-02-21 12:32:00','',''),('1','312',823,'','supplier','1',0.00,238520.00,'Payment Id 23 for invoice:16, receipt: p o s by AA RANO NIGERIA LTD','2023-02-21 12:32:00','',''),('1','312',824,'','2','8',37360.00,0.00,'Payment Id 21 for invoice:15, receipt: p o s by AA RANO NIGERIA LTD','2023-02-21 12:32:45','',''),('1','312',825,'','supplier','1',0.00,37360.00,'Payment Id 21 for invoice:15, receipt: p o s by AA RANO NIGERIA LTD','2023-02-21 12:32:45','',''),('1','312',826,'','20','3',9000.00,0.00,'Retail Sale Id 387 for 12.50 KG of Cooking Gas @ N720.00','2023-02-21 12:35:55','',''),('1','312',827,'','6.1','4',0.00,9000.00,'Retail Sale Id 387 for retail product','2023-02-21 12:35:55','',''),('1','312',828,'','20','3',5000.00,0.00,'Retail Sale Id 388 for 6.94 KG of Cooking Gas @ N720.00','2023-02-21 12:46:54','',''),('1','312',829,'','6.1','4',0.00,5000.00,'Retail Sale Id 388 for retail product','2023-02-21 12:46:54','',''),('1','312',830,'','20','3',2160.00,0.00,'Retail Sale Id 389 for 3.00 KG of Cooking Gas @ N720.00','2023-02-21 13:10:41','',''),('1','312',831,'','6.1','4',0.00,2160.00,'Retail Sale Id 389 for retail product','2023-02-21 13:10:41','',''),('1','312',832,'','20','3',2160.00,0.00,'Retail Sale Id 390 for 3.00 KG of Cooking Gas @ N720.00','2023-02-21 13:13:43','',''),('1','312',833,'','6.1','4',0.00,2160.00,'Retail Sale Id 390 for retail product','2023-02-21 13:13:43','',''),('1','312',834,'','20','3',438480.00,0.00,'Retail Sale Id 391 for 649.60 KG of Cooking Gas @ N675.00','2023-02-21 13:17:15','',''),('1','312',835,'','6.1','4',0.00,438480.00,'Retail Sale Id 391 for retail product','2023-02-21 13:17:15','',''),('1','312',836,'','20','3',3600.00,0.00,'Retail Sale Id 392 for 5.00 KG of Cooking Gas @ N720.00','2023-02-21 13:21:02','',''),('1','312',837,'','6.1','4',0.00,3600.00,'Retail Sale Id 392 for retail product','2023-02-21 13:21:02','',''),('1','312',838,'','20','3',1450.00,0.00,'Retail Sale Id 393 for 2.01 KG of Cooking Gas @ N720.00','2023-02-21 13:23:08','',''),('1','312',839,'','6.1','4',0.00,1450.00,'Retail Sale Id 393 for retail product','2023-02-21 13:23:08','',''),('1','312',840,'','20','3',720.00,0.00,'Retail Sale Id 394 for 1.00 KG of Cooking Gas @ N720.00','2023-02-21 13:44:32','',''),('1','312',841,'','6.1','4',0.00,720.00,'Retail Sale Id 394 for retail product','2023-02-21 13:44:32','',''),('1','312',842,'','20','3',34000.00,0.00,'Retail Sale Id 395 for 50.00 KG of Cooking Gas @ N680.00','2023-02-21 13:52:44','',''),('1','312',843,'','6.1','4',0.00,34000.00,'Retail Sale Id 395 for retail product','2023-02-21 13:52:44','',''),('1','312',844,'','20','3',3600.00,0.00,'Retail Sale Id 396 for 5.00 KG of Cooking Gas @ N720.00','2023-02-21 14:05:41','',''),('1','312',845,'','6.1','4',0.00,3600.00,'Retail Sale Id 396 for retail product','2023-02-21 14:05:41','',''),('1','312',846,'','20','3',1450.00,0.00,'Retail Sale Id 397 for 2.01 KG of Cooking Gas @ N720.00','2023-02-21 14:15:49','',''),('1','312',847,'','6.1','4',0.00,1450.00,'Retail Sale Id 397 for retail product','2023-02-21 14:15:49','',''),('1','312',848,'','20','3',2200.00,0.00,'Retail Sale Id 398 for 3.06 KG of Cooking Gas @ N720.00','2023-02-21 14:49:32','',''),('1','312',849,'','6.1','4',0.00,2200.00,'Retail Sale Id 398 for retail product','2023-02-21 14:49:32','',''),('1','312',850,'','20','3',9000.00,0.00,'Retail Sale Id 399 for 12.50 KG of Cooking Gas @ N720.00','2023-02-21 14:56:37','',''),('1','312',851,'','6.1','4',0.00,9000.00,'Retail Sale Id 399 for retail product','2023-02-21 14:56:37','',''),('1','312',852,'','20','3',9000.00,0.00,'Retail Sale Id 400 for 12.50 KG of Cooking Gas @ N720.00','2023-02-21 16:29:05','',''),('1','312',853,'','6.1','4',0.00,9000.00,'Retail Sale Id 400 for retail product','2023-02-21 16:29:05','',''),('1','312',854,'','20','3',3600.00,0.00,'Retail Sale Id 401 for 5.00 KG of Cooking Gas @ N720.00','2023-02-21 16:30:38','',''),('1','312',855,'','6.1','4',0.00,3600.00,'Retail Sale Id 401 for retail product','2023-02-21 16:30:38','',''),('1','312',856,'','20','3',2160.00,0.00,'Retail Sale Id 402 for 3.00 KG of Cooking Gas @ N720.00','2023-02-21 16:33:06','',''),('1','312',857,'','6.1','4',0.00,2160.00,'Retail Sale Id 402 for retail product','2023-02-21 16:33:06','',''),('1','312',858,'','20','3',4320.00,0.00,'Retail Sale Id 403 for 6.00 KG of Cooking Gas @ N720.00','2023-02-21 16:35:36','',''),('1','312',859,'','6.1','4',0.00,4320.00,'Retail Sale Id 403 for retail product','2023-02-21 16:35:36','',''),('1','312',860,'','20','3',4320.00,0.00,'Retail Sale Id 404 for 6.00 KG of Cooking Gas @ N720.00','2023-02-21 16:47:53','',''),('1','312',861,'','6.1','4',0.00,4320.00,'Retail Sale Id 404 for retail product','2023-02-21 16:47:53','',''),('1','312',862,'','20','3',2160.00,0.00,'Retail Sale Id 405 for 3.00 KG of Cooking Gas @ N720.00','2023-02-21 16:55:15','',''),('1','312',863,'','6.1','4',0.00,2160.00,'Retail Sale Id 405 for retail product','2023-02-21 16:55:15','',''),('1','312',864,'','20','3',4320.00,0.00,'Retail Sale Id 406 for 6.00 KG of Cooking Gas @ N720.00','2023-02-21 17:00:38','',''),('1','312',865,'','6.1','4',0.00,4320.00,'Retail Sale Id 406 for retail product','2023-02-21 17:00:38','',''),('1','312',866,'','20','3',3600.00,0.00,'Retail Sale Id 407 for 5.00 KG of Cooking Gas @ N720.00','2023-02-21 17:05:22','',''),('1','312',867,'','6.1','4',0.00,3600.00,'Retail Sale Id 407 for retail product','2023-02-21 17:05:22','',''),('1','312',868,'','20','3',1440.00,0.00,'Retail Sale Id 408 for 2.00 KG of Cooking Gas @ N720.00','2023-02-21 17:56:01','',''),('1','312',869,'','6.1','4',0.00,1440.00,'Retail Sale Id 408 for retail product','2023-02-21 17:56:01','',''),('1','312',870,'','20','3',4320.00,0.00,'Retail Sale Id 409 for 6.00 KG of Cooking Gas @ N720.00','2023-02-21 17:59:05','',''),('1','312',871,'','6.1','4',0.00,4320.00,'Retail Sale Id 409 for retail product','2023-02-21 17:59:05','',''),('1','312',872,'','20','3',9000.00,0.00,'Retail Sale Id 410 for 12.50 KG of Cooking Gas @ N720.00','2023-02-21 18:28:22','',''),('1','312',873,'','6.1','4',0.00,9000.00,'Retail Sale Id 410 for retail product','2023-02-21 18:28:22','',''),('1','312',874,'','20','3',4320.00,0.00,'Retail Sale Id 411 for 6.00 KG of Cooking Gas @ N720.00','2023-02-21 18:48:20','',''),('1','312',875,'','6.1','4',0.00,4320.00,'Retail Sale Id 411 for retail product','2023-02-21 18:48:20','',''),('1','312',876,'','20','3',750.00,0.00,'Retail Sale Id 412 for 1.04 KG of Cooking Gas @ N720.00','2023-02-21 18:49:32','',''),('1','312',877,'','6.1','4',0.00,750.00,'Retail Sale Id 412 for retail product','2023-02-21 18:49:32','',''),('1','312',878,'','20','3',3250.00,0.00,'Retail Sale Id 414 for 4.51 KG of Cooking Gas @ N720.00','2023-02-21 18:57:50','',''),('1','312',879,'','6.1','4',0.00,3250.00,'Retail Sale Id 414 for retail product','2023-02-21 18:57:50','',''),('1','312',880,'','20','3',8500.00,0.00,'Retail Sale Id 415 for 11.81 KG of Cooking Gas @ N720.00','2023-02-21 18:59:01','',''),('1','312',881,'','6.1','4',0.00,8500.00,'Retail Sale Id 415 for retail product','2023-02-21 18:59:01','',''),('1','312',882,'','20','3',0.00,9000.00,'Return of Retail Sale Id 410 for products','2023-02-21 19:52:16','',''),('1','312',883,'','','',9000.00,0.00,'Return of Retail Sale Id 410 for products','2023-02-21 19:52:16','',''),('1','312',884,'','20','3',0.00,9000.00,'Return of Retail Sale Id 387 for products','2023-02-21 19:54:36','',''),('1','312',885,'','','',9000.00,0.00,'Return of Retail Sale Id 387 for products','2023-02-21 19:54:36','',''),('1','312',886,'','20','3',0.00,9000.00,'Return of Retail Sale Id 384 for products','2023-02-21 19:56:19','',''),('1','312',887,'','','',9000.00,0.00,'Return of Retail Sale Id 384 for products','2023-02-21 19:56:19','',''),('1','312',888,'','20','3',0.00,9000.00,'Return of Retail Sale Id 369 for products','2023-02-21 19:57:42','',''),('1','312',889,'','','',9000.00,0.00,'Return of Retail Sale Id 369 for products','2023-02-21 19:57:42','',''),('1','312',890,'','20','3',0.00,12600.00,'Return of Retail Sale Id 368 for products','2023-02-21 19:59:26','',''),('1','312',891,'','','',12600.00,0.00,'Return of Retail Sale Id 368 for products','2023-02-21 19:59:26','',''),('1','312',892,'','20','3',0.00,7200.00,'Return of Retail Sale Id 371 for products','2023-02-21 20:03:56','',''),('1','312',893,'','','',7200.00,0.00,'Return of Retail Sale Id 371 for products','2023-02-21 20:03:56','',''),('1','312',894,'','20','3',0.00,7200.00,'Return of Retail Sale Id 365 for products','2023-02-21 20:05:31','',''),('1','312',895,'','','',7200.00,0.00,'Return of Retail Sale Id 365 for products','2023-02-21 20:05:31','',''),('1','312',896,'','20','3',0.00,4320.00,'Return of Retail Sale Id 366 for products','2023-02-21 20:08:01','',''),('1','312',897,'','','',4320.00,0.00,'Return of Retail Sale Id 366 for products','2023-02-21 20:08:01','',''),('1','312',898,'','20','3',0.00,8500.00,'Return of Retail Sale Id 415 for products','2023-02-21 20:08:40','',''),('1','312',899,'','','',8500.00,0.00,'Return of Retail Sale Id 415 for products','2023-02-21 20:08:40','',''),('1','312',900,'','20','3',81600.00,0.00,'Retail Sale Id 416 for 120.00 KG of Cooking Gas @ N680.00','2023-02-21 20:13:18','',''),('1','312',901,'','6.1','4',0.00,81600.00,'Retail Sale Id 416 for retail product','2023-02-21 20:13:18','',''),('1','312',902,'','20','3',0.00,0.00,'Sales from shift 18 on 2023-02-21 20:14:58 ','2023-02-21 20:14:58','',''),('1','312',903,'','6.1','4',0.00,0.00,'Sales from shift 18 on 2023-02-21 20:14:58 ','2023-02-21 20:14:58','',''),('1','312',904,'','20','3',1450.00,0.00,'Retail Sale Id 417 for 2.01 KG of Cooking Gas @ N720.00','2023-02-22 07:39:22','',''),('1','312',905,'','6.1','4',0.00,1450.00,'Retail Sale Id 417 for retail product','2023-02-22 07:39:22','',''),('1','312',906,'','20','3',3200.00,0.00,'Retail Sale Id 418 for 4.44 KG of Cooking Gas @ N720.00','2023-02-22 08:17:05','',''),('1','312',907,'','6.1','4',0.00,3200.00,'Retail Sale Id 418 for retail product','2023-02-22 08:17:05','',''),('1','312',908,'','20','3',3600.00,0.00,'Retail Sale Id 419 for 5.00 KG of Cooking Gas @ N720.00','2023-02-22 08:46:55','',''),('1','312',909,'','6.1','4',0.00,3600.00,'Retail Sale Id 419 for retail product','2023-02-22 08:46:55','',''),('1','312',910,'','20','3',3600.00,0.00,'Retail Sale Id 420 for 5.00 KG of Cooking Gas @ N720.00','2023-02-22 08:48:43','',''),('1','312',911,'','6.1','4',0.00,3600.00,'Retail Sale Id 420 for retail product','2023-02-22 08:48:43','',''),('1','312',912,'','20','3',15000.00,0.00,'Retail Sale Id 421 for 20.83 KG of Cooking Gas @ N720.00','2023-02-22 09:01:09','',''),('1','312',913,'','6.1','4',0.00,15000.00,'Retail Sale Id 421 for retail product','2023-02-22 09:01:09','',''),('1','312',914,'','20','3',9000.00,0.00,'Retail Sale Id 422 for 12.50 KG of Cooking Gas @ N720.00','2023-02-22 09:08:41','',''),('1','312',915,'','6.1','4',0.00,9000.00,'Retail Sale Id 422 for retail product','2023-02-22 09:08:41','',''),('1','312',916,'','20','3',3600.00,0.00,'Retail Sale Id 423 for 5.00 KG of Cooking Gas @ N720.00','2023-02-22 09:39:53','',''),('1','312',917,'','6.1','4',0.00,3600.00,'Retail Sale Id 423 for retail product','2023-02-22 09:39:53','',''),('1','312',918,'','20','3',40800.00,0.00,'Retail Sale Id 424 for 60.00 KG of Cooking Gas @ N680.00','2023-02-22 09:41:06','',''),('1','312',919,'','6.1','4',0.00,40800.00,'Retail Sale Id 424 for retail product','2023-02-22 09:41:06','',''),('1','312',920,'','20','3',9500.00,0.00,'Retail Sale Id 426 for 13.19 KG of Cooking Gas @ N720.00','2023-02-22 09:55:40','',''),('1','312',921,'','6.1','4',0.00,9500.00,'Retail Sale Id 426 for retail product','2023-02-22 09:55:40','',''),('1','312',922,'','20','3',9000.00,0.00,'Retail Sale Id 427 for 12.50 KG of Cooking Gas @ N720.00','2023-02-22 10:19:32','',''),('1','312',923,'','6.1','4',0.00,9000.00,'Retail Sale Id 427 for retail product','2023-02-22 10:19:32','',''),('1','312',924,'','20','3',3600.00,0.00,'Retail Sale Id 428 for 5.00 KG of Cooking Gas @ N720.00','2023-02-22 10:22:24','',''),('1','312',925,'','6.1','4',0.00,3600.00,'Retail Sale Id 428 for retail product','2023-02-22 10:22:24','',''),('1','312',926,'','20','3',5040.00,0.00,'Retail Sale Id 429 for 7.00 KG of Cooking Gas @ N720.00','2023-02-22 11:02:23','',''),('1','312',927,'','6.1','4',0.00,5040.00,'Retail Sale Id 429 for retail product','2023-02-22 11:02:23','',''),('1','312',928,'','20','3',5000.00,0.00,'Retail Sale Id 430 for 6.94 KG of Cooking Gas @ N720.00','2023-02-22 11:59:08','',''),('1','312',929,'','6.1','4',0.00,5000.00,'Retail Sale Id 430 for retail product','2023-02-22 11:59:08','',''),('1','312',930,'','20','3',3600.00,0.00,'Retail Sale Id 431 for 5.00 KG of Cooking Gas @ N720.00','2023-02-22 12:18:40','',''),('1','312',931,'','6.1','4',0.00,3600.00,'Retail Sale Id 431 for retail product','2023-02-22 12:18:40','',''),('1','312',932,'','20','3',2880.00,0.00,'Retail Sale Id 432 for 4.00 KG of Cooking Gas @ N720.00','2023-02-22 12:38:23','',''),('1','312',933,'','6.1','4',0.00,2880.00,'Retail Sale Id 432 for retail product','2023-02-22 12:38:23','',''),('1','312',934,'','20','3',5040.00,0.00,'Retail Sale Id 433 for 7.00 KG of Cooking Gas @ N720.00','2023-02-22 13:14:14','',''),('1','312',935,'','6.1','4',0.00,5040.00,'Retail Sale Id 433 for retail product','2023-02-22 13:14:14','',''),('1','312',936,'','20','3',2200.00,0.00,'Retail Sale Id 435 for 3.06 KG of Cooking Gas @ N720.00','2023-02-22 13:33:59','',''),('1','312',937,'','6.1','4',0.00,2200.00,'Retail Sale Id 435 for retail product','2023-02-22 13:33:59','',''),('1','312',938,'','20','3',9000.00,0.00,'Retail Sale Id 436 for 12.50 KG of Cooking Gas @ N720.00','2023-02-22 13:52:56','',''),('1','312',939,'','6.1','4',0.00,9000.00,'Retail Sale Id 436 for retail product','2023-02-22 13:52:56','',''),('1','312',940,'','20','3',5760.00,0.00,'Retail Sale Id 437 for 8.00 KG of Cooking Gas @ N720.00','2023-02-22 14:09:30','',''),('1','312',941,'','6.1','4',0.00,5760.00,'Retail Sale Id 437 for retail product','2023-02-22 14:09:30','',''),('1','312',942,'','20','3',4320.00,0.00,'Retail Sale Id 438 for 6.00 KG of Cooking Gas @ N720.00','2023-02-22 14:43:10','',''),('1','312',943,'','6.1','4',0.00,4320.00,'Retail Sale Id 438 for retail product','2023-02-22 14:43:10','',''),('1','312',944,'','20','3',9360.00,0.00,'Retail Sale Id 439 for 13.00 KG of Cooking Gas @ N720.00','2023-02-22 14:46:02','',''),('1','312',945,'','6.1','4',0.00,9360.00,'Retail Sale Id 439 for retail product','2023-02-22 14:46:02','',''),('1','312',946,'','20','3',5000.00,0.00,'Retail Sale Id 440 for 6.94 KG of Cooking Gas @ N720.00','2023-02-22 15:03:17','',''),('1','312',947,'','6.1','4',0.00,5000.00,'Retail Sale Id 440 for retail product','2023-02-22 15:03:17','',''),('1','312',948,'','20','3',9000.00,0.00,'Retail Sale Id 441 for 12.50 KG of Cooking Gas @ N720.00','2023-02-22 15:16:06','',''),('1','312',949,'','6.1','4',0.00,9000.00,'Retail Sale Id 441 for retail product','2023-02-22 15:16:06','',''),('1','312',950,'','2','19',123775.00,0.00,'Payment Id 6 for invoice:6, receipt: 000 by AA RANO NIGERIA LTD','2023-02-22 15:17:58','',''),('1','312',951,'','supplier','1',0.00,123775.00,'Payment Id 6 for invoice:6, receipt: 000 by AA RANO NIGERIA LTD','2023-02-22 15:17:58','',''),('1','312',952,'','2','19',3450.00,0.00,'Payment Id 14 for invoice:12, receipt: 000 by AA RANO NIGERIA LTD','2023-02-22 15:20:06','',''),('1','312',953,'','supplier','1',0.00,3450.00,'Payment Id 14 for invoice:12, receipt: 000 by AA RANO NIGERIA LTD','2023-02-22 15:20:06','',''),('1','312',954,'','2','19',73060.00,0.00,'Payment Id 16 for invoice:13, receipt: 000 by AA RANO NIGERIA LTD','2023-02-22 15:20:48','',''),('1','312',955,'','supplier','1',0.00,73060.00,'Payment Id 16 for invoice:13, receipt: 000 by AA RANO NIGERIA LTD','2023-02-22 15:20:48','',''),('1','312',956,'','20','3',2160.00,0.00,'Retail Sale Id 442 for 3.00 KG of Cooking Gas @ N720.00','2023-02-22 15:22:35','',''),('1','312',957,'','6.1','4',0.00,2160.00,'Retail Sale Id 442 for retail product','2023-02-22 15:22:35','',''),('1','312',958,'','20','3',9000.00,0.00,'Retail Sale Id 444 for 12.50 KG of Cooking Gas @ N720.00','2023-02-22 15:25:23','',''),('1','312',959,'','6.1','4',0.00,9000.00,'Retail Sale Id 444 for retail product','2023-02-22 15:25:23','',''),('1','312',960,'','20','3',7200.00,0.00,'Retail Sale Id 445 for 10.00 KG of Cooking Gas @ N720.00','2023-02-22 16:14:17','',''),('1','312',961,'','6.1','4',0.00,7200.00,'Retail Sale Id 445 for retail product','2023-02-22 16:14:17','',''),('1','312',962,'','20','3',6480.00,0.00,'Retail Sale Id 446 for 9.00 KG of Cooking Gas @ N720.00','2023-02-22 16:30:25','',''),('1','312',963,'','6.1','4',0.00,6480.00,'Retail Sale Id 446 for retail product','2023-02-22 16:30:25','',''),('1','312',964,'','20','3',2500.00,0.00,'Retail Sale Id 447 for 3.47 KG of Cooking Gas @ N720.00','2023-02-22 16:40:27','',''),('1','312',965,'','6.1','4',0.00,2500.00,'Retail Sale Id 447 for retail product','2023-02-22 16:40:27','',''),('1','312',966,'','20','3',2200.00,0.00,'Retail Sale Id 448 for 3.06 KG of Cooking Gas @ N720.00','2023-02-22 16:45:33','',''),('1','312',967,'','6.1','4',0.00,2200.00,'Retail Sale Id 448 for retail product','2023-02-22 16:45:33','',''),('1','312',968,'','20','3',3000.00,0.00,'Retail Sale Id 449 for 4.17 KG of Cooking Gas @ N720.00','2023-02-22 17:25:47','',''),('1','312',969,'','6.1','4',0.00,3000.00,'Retail Sale Id 449 for retail product','2023-02-22 17:25:47','',''),('1','312',970,'','20','3',5100.00,0.00,'Retail Sale Id 450 for 7.08 KG of Cooking Gas @ N720.00','2023-02-22 17:48:39','',''),('1','312',971,'','6.1','4',0.00,5100.00,'Retail Sale Id 450 for retail product','2023-02-22 17:48:39','',''),('1','312',972,'','20','3',74800.00,0.00,'Retail Sale Id 451 for 110.00 KG of Cooking Gas @ N680.00','2023-02-22 18:11:18','',''),('1','312',973,'','6.1','4',0.00,74800.00,'Retail Sale Id 451 for retail product','2023-02-22 18:11:18','',''),('1','312',974,'','20','3',9000.00,0.00,'Retail Sale Id 452 for 12.50 KG of Cooking Gas @ N720.00','2023-02-22 18:44:17','',''),('1','312',975,'','6.1','4',0.00,9000.00,'Retail Sale Id 452 for retail product','2023-02-22 18:44:17','',''),('1','312',976,'','20','3',1000.00,0.00,'Retail Sale Id 453 for 1.39 KG of Cooking Gas @ N720.00','2023-02-22 18:47:47','',''),('1','312',977,'','6.1','4',0.00,1000.00,'Retail Sale Id 453 for retail product','2023-02-22 18:47:47','',''),('1','312',978,'','20','3',9936.00,0.00,'Retail Sale Id 454 for 13.80 KG of Cooking Gas @ N720.00','2023-02-22 19:27:22','',''),('1','312',979,'','6.1','4',0.00,9936.00,'Retail Sale Id 454 for retail product','2023-02-22 19:27:22','',''),('1','312',980,'','20','3',0.00,0.00,'Sales from shift 19 on 2023-02-23 07:35:58 ','2023-02-23 07:35:58','',''),('1','312',981,'','6.1','4',0.00,0.00,'Sales from shift 19 on 2023-02-23 07:35:58 ','2023-02-23 07:35:58','',''),('1','312',982,'','20','3',2500.00,0.00,'Retail Sale Id 455 for 3.47 KG of Cooking Gas @ N720.00','2023-02-23 07:37:56','',''),('1','312',983,'','6.1','4',0.00,2500.00,'Retail Sale Id 455 for retail product','2023-02-23 07:37:56','',''),('1','312',984,'','20','3',9000.00,0.00,'Retail Sale Id 456 for 12.50 KG of Cooking Gas @ N720.00','2023-02-23 07:50:04','',''),('1','312',985,'','6.1','4',0.00,9000.00,'Retail Sale Id 456 for retail product','2023-02-23 07:50:04','',''),('1','312',986,'','20','3',4320.00,0.00,'Retail Sale Id 457 for 6.00 KG of Cooking Gas @ N720.00','2023-02-23 07:58:58','',''),('1','312',987,'','6.1','4',0.00,4320.00,'Retail Sale Id 457 for retail product','2023-02-23 07:58:58','',''),('1','312',988,'','20','3',2880.00,0.00,'Retail Sale Id 458 for 4.00 KG of Cooking Gas @ N720.00','2023-02-23 08:13:43','',''),('1','312',989,'','6.1','4',0.00,2880.00,'Retail Sale Id 458 for retail product','2023-02-23 08:13:43','',''),('1','312',990,'','20','3',1440.00,0.00,'Retail Sale Id 459 for 2.00 KG of Cooking Gas @ N720.00','2023-02-23 08:16:27','',''),('1','312',991,'','6.1','4',0.00,1440.00,'Retail Sale Id 459 for retail product','2023-02-23 08:16:27','',''),('1','312',992,'','20','3',2880.00,0.00,'Retail Sale Id 460 for 4.00 KG of Cooking Gas @ N720.00','2023-02-23 08:19:05','',''),('1','312',993,'','6.1','4',0.00,2880.00,'Retail Sale Id 460 for retail product','2023-02-23 08:19:05','',''),('1','312',994,'','20','3',33840.00,0.00,'Retail Sale Id 461 for 47.00 KG of Cooking Gas @ N720.00','2023-02-23 08:26:31','',''),('1','312',995,'','6.1','4',0.00,33840.00,'Retail Sale Id 461 for retail product','2023-02-23 08:26:31','',''),('1','312',996,'','20','3',7920.00,0.00,'Retail Sale Id 462 for 11.00 KG of Cooking Gas @ N720.00','2023-02-23 08:57:50','',''),('1','312',997,'','6.1','4',0.00,7920.00,'Retail Sale Id 462 for retail product','2023-02-23 08:57:50','',''),('1','312',998,'','20','3',2160.00,0.00,'Retail Sale Id 463 for 3.00 KG of Cooking Gas @ N720.00','2023-02-23 09:01:32','',''),('1','312',999,'','6.1','4',0.00,2160.00,'Retail Sale Id 463 for retail product','2023-02-23 09:01:32','',''),('1','312',1000,'','20','3',3600.00,0.00,'Retail Sale Id 464 for 5.00 KG of Cooking Gas @ N720.00','2023-02-23 09:03:56','',''),('1','312',1001,'','6.1','4',0.00,3600.00,'Retail Sale Id 464 for retail product','2023-02-23 09:03:56','',''),('1','312',1002,'','20','3',3600.00,0.00,'Retail Sale Id 465 for 5.00 KG of Cooking Gas @ N720.00','2023-02-23 09:06:55','',''),('1','312',1003,'','6.1','4',0.00,3600.00,'Retail Sale Id 465 for retail product','2023-02-23 09:06:55','',''),('1','312',1004,'','20','3',5050.00,0.00,'Retail Sale Id 466 for 7.01 KG of Cooking Gas @ N720.00','2023-02-23 09:08:31','',''),('1','312',1005,'','6.1','4',0.00,5050.00,'Retail Sale Id 466 for retail product','2023-02-23 09:08:31','',''),('1','312',1006,'','20','3',2160.00,0.00,'Retail Sale Id 467 for 3.00 KG of Cooking Gas @ N720.00','2023-02-23 09:17:20','',''),('1','312',1007,'','6.1','4',0.00,2160.00,'Retail Sale Id 467 for retail product','2023-02-23 09:17:20','',''),('1','312',1008,'','20','3',4320.00,0.00,'Retail Sale Id 468 for 6.00 KG of Cooking Gas @ N720.00','2023-02-23 09:19:25','',''),('1','312',1009,'','6.1','4',0.00,4320.00,'Retail Sale Id 468 for retail product','2023-02-23 09:19:25','',''),('1','312',1010,'','20','3',9000.00,0.00,'Retail Sale Id 469 for 12.50 KG of Cooking Gas @ N720.00','2023-02-23 09:23:56','',''),('1','312',1011,'','6.1','4',0.00,9000.00,'Retail Sale Id 469 for retail product','2023-02-23 09:23:56','',''),('1','312',1012,'','20','3',5040.00,0.00,'Retail Sale Id 470 for 7.00 KG of Cooking Gas @ N720.00','2023-02-23 09:45:56','',''),('1','312',1013,'','6.1','4',0.00,5040.00,'Retail Sale Id 470 for retail product','2023-02-23 09:45:56','',''),('1','312',1014,'','20','3',12240.00,0.00,'Retail Sale Id 471 for 17.00 KG of Cooking Gas @ N720.00','2023-02-23 09:51:35','',''),('1','312',1015,'','6.1','4',0.00,12240.00,'Retail Sale Id 471 for retail product','2023-02-23 09:51:35','',''),('1','312',1016,'','20','3',2900.00,0.00,'Retail Sale Id 472 for 4.03 KG of Cooking Gas @ N720.00','2023-02-23 09:56:27','',''),('1','312',1017,'','6.1','4',0.00,2900.00,'Retail Sale Id 472 for retail product','2023-02-23 09:56:27','',''),('1','312',1018,'','20','3',3600.00,0.00,'Retail Sale Id 473 for 5.00 KG of Cooking Gas @ N720.00','2023-02-23 09:58:02','',''),('1','312',1019,'','6.1','4',0.00,3600.00,'Retail Sale Id 473 for retail product','2023-02-23 09:58:02','',''),('1','312',1020,'','20','3',10080.00,0.00,'Retail Sale Id 474 for 14.00 KG of Cooking Gas @ N720.00','2023-02-23 10:02:01','',''),('1','312',1021,'','6.1','4',0.00,10080.00,'Retail Sale Id 474 for retail product','2023-02-23 10:02:01','',''),('1','312',1022,'','20','3',4320.00,0.00,'Retail Sale Id 475 for 6.00 KG of Cooking Gas @ N720.00','2023-02-23 10:17:03','',''),('1','312',1023,'','6.1','4',0.00,4320.00,'Retail Sale Id 475 for retail product','2023-02-23 10:17:03','',''),('1','312',1024,'','20','3',12240.00,0.00,'Retail Sale Id 476 for 17.00 KG of Cooking Gas @ N720.00','2023-02-23 10:41:28','',''),('1','312',1025,'','6.1','4',0.00,12240.00,'Retail Sale Id 476 for retail product','2023-02-23 10:41:28','',''),('1','312',1026,'','20','3',2880.00,0.00,'Retail Sale Id 477 for 4.00 KG of Cooking Gas @ N720.00','2023-02-23 10:49:18','',''),('1','312',1027,'','6.1','4',0.00,2880.00,'Retail Sale Id 477 for retail product','2023-02-23 10:49:18','',''),('1','312',1028,'','20','3',4320.00,0.00,'Retail Sale Id 478 for 6.00 KG of Cooking Gas @ N720.00','2023-02-23 11:14:27','',''),('1','312',1029,'','6.1','4',0.00,4320.00,'Retail Sale Id 478 for retail product','2023-02-23 11:14:27','',''),('1','312',1030,'','20','3',2160.00,0.00,'Retail Sale Id 479 for 3.00 KG of Cooking Gas @ N720.00','2023-02-23 11:17:38','',''),('1','312',1031,'','6.1','4',0.00,2160.00,'Retail Sale Id 479 for retail product','2023-02-23 11:17:39','',''),('1','312',1032,'','20','3',6480.00,0.00,'Retail Sale Id 480 for 9.00 KG of Cooking Gas @ N720.00','2023-02-23 11:51:44','',''),('1','312',1033,'','6.1','4',0.00,6480.00,'Retail Sale Id 480 for retail product','2023-02-23 11:51:44','',''),('1','312',1034,'','20','3',2880.00,0.00,'Retail Sale Id 481 for 4.00 KG of Cooking Gas @ N720.00','2023-02-23 12:10:31','',''),('1','312',1035,'','6.1','4',0.00,2880.00,'Retail Sale Id 481 for retail product','2023-02-23 12:10:31','',''),('1','312',1036,'','20','3',2829.60,0.00,'Retail Sale Id 482 for 3.93 KG of Cooking Gas @ N720.00','2023-02-23 12:54:45','',''),('1','312',1037,'','6.1','4',0.00,2829.60,'Retail Sale Id 482 for retail product','2023-02-23 12:54:45','',''),('1','312',1038,'','20','3',0.00,0.00,'Sales from shift 20 on 2023-02-23 12:56:14 ','2023-02-23 12:56:14','',''),('1','312',1039,'','6.1','4',0.00,0.00,'Sales from shift 20 on 2023-02-23 12:56:14 ','2023-02-23 12:56:14','',''),('1','312',1040,'','24','2',0.00,2930013.00,'Purchase Id 2 for 4,941.00 litters of Cooking Gas - LPG from AA RANO NIGERIA LTD','2023-02-23 13:01:40','',''),('1','312',1041,'','supplier','1',2930013.00,0.00,'Purchase Id 2 for 4,941.00 litters of Cooking Gas - LPG from AA RANO NIGERIA LTD','2023-02-23 13:01:40','',''),('1','312',1042,'','20','3',9000.00,0.00,'Retail Sale Id 483 for 12.50 KG of Cooking Gas @ N720.00','2023-02-23 13:06:57','',''),('1','312',1043,'','6.1','4',0.00,9000.00,'Retail Sale Id 483 for retail product','2023-02-23 13:06:57','',''),('1','312',1044,'','20','3',7200.00,0.00,'Retail Sale Id 484 for 10.00 KG of Cooking Gas @ N720.00','2023-02-23 13:07:42','',''),('1','312',1045,'','6.1','4',0.00,7200.00,'Retail Sale Id 484 for retail product','2023-02-23 13:07:42','',''),('1','312',1046,'','20','3',8640.00,0.00,'Retail Sale Id 485 for 12.00 KG of Cooking Gas @ N720.00','2023-02-23 13:08:32','',''),('1','312',1047,'','6.1','4',0.00,8640.00,'Retail Sale Id 485 for retail product','2023-02-23 13:08:32','',''),('1','312',1048,'','20','3',9000.00,0.00,'Retail Sale Id 486 for 12.50 KG of Cooking Gas @ N720.00','2023-02-23 13:09:28','',''),('1','312',1049,'','6.1','4',0.00,9000.00,'Retail Sale Id 486 for retail product','2023-02-23 13:09:28','',''),('1','312',1050,'','20','3',2570.40,0.00,'Retail Sale Id 487 for 3.57 KG of Cooking Gas @ N720.00','2023-02-23 13:10:48','',''),('1','312',1051,'','6.1','4',0.00,2570.40,'Retail Sale Id 487 for retail product','2023-02-23 13:10:48','',''),('1','312',1052,'','20','3',187000.00,0.00,'Retail Sale Id 488 for 275.00 KG of Cooking Gas @ N680.00','2023-02-23 13:13:29','',''),('1','312',1053,'','6.1','4',0.00,187000.00,'Retail Sale Id 488 for retail product','2023-02-23 13:13:29','',''),('1','312',1054,'','20','3',81600.00,0.00,'Retail Sale Id 489 for 120.00 KG of Cooking Gas @ N680.00','2023-02-23 13:14:30','',''),('1','312',1055,'','6.1','4',0.00,81600.00,'Retail Sale Id 489 for retail product','2023-02-23 13:14:30','',''),('1','312',1056,'','20','3',188700.00,0.00,'Retail Sale Id 490 for 277.50 KG of Cooking Gas @ N680.00','2023-02-23 13:15:55','',''),('1','312',1057,'','6.1','4',0.00,188700.00,'Retail Sale Id 490 for retail product','2023-02-23 13:15:55','',''),('1','312',1058,'','20','3',5760.00,0.00,'Retail Sale Id 491 for 8.00 KG of Cooking Gas @ N720.00','2023-02-23 14:34:50','',''),('1','312',1059,'','6.1','4',0.00,5760.00,'Retail Sale Id 491 for retail product','2023-02-23 14:34:50','',''),('1','312',1060,'','20','3',5040.00,0.00,'Retail Sale Id 492 for 7.00 KG of Cooking Gas @ N720.00','2023-02-23 14:36:41','',''),('1','312',1061,'','6.1','4',0.00,5040.00,'Retail Sale Id 492 for retail product','2023-02-23 14:36:41','',''),('1','312',1062,'','20','3',9000.00,0.00,'Retail Sale Id 493 for 12.50 KG of Cooking Gas @ N720.00','2023-02-23 14:41:04','',''),('1','312',1063,'','6.1','4',0.00,9000.00,'Retail Sale Id 493 for retail product','2023-02-23 14:41:04','',''),('1','312',1064,'','20','3',9000.00,0.00,'Retail Sale Id 494 for 12.50 KG of Cooking Gas @ N720.00','2023-02-23 14:42:55','',''),('1','312',1065,'','6.1','4',0.00,9000.00,'Retail Sale Id 494 for retail product','2023-02-23 14:42:55','',''),('1','312',1066,'','20','3',9000.00,0.00,'Retail Sale Id 495 for 12.50 KG of Cooking Gas @ N720.00','2023-02-23 14:46:01','',''),('1','312',1067,'','6.1','4',0.00,9000.00,'Retail Sale Id 495 for retail product','2023-02-23 14:46:01','',''),('1','312',1068,'','20','3',1440.00,0.00,'Retail Sale Id 496 for 2.00 KG of Cooking Gas @ N720.00','2023-02-23 14:47:35','',''),('1','312',1069,'','6.1','4',0.00,1440.00,'Retail Sale Id 496 for retail product','2023-02-23 14:47:35','',''),('1','312',1070,'','20','3',5040.00,0.00,'Retail Sale Id 497 for 7.00 KG of Cooking Gas @ N720.00','2023-02-23 14:55:56','',''),('1','312',1071,'','6.1','4',0.00,5040.00,'Retail Sale Id 497 for retail product','2023-02-23 14:55:56','',''),('1','312',1072,'','20','3',12240.00,0.00,'Retail Sale Id 498 for 17.00 KG of Cooking Gas @ N720.00','2023-02-23 15:30:15','',''),('1','312',1073,'','6.1','4',0.00,12240.00,'Retail Sale Id 498 for retail product','2023-02-23 15:30:15','',''),('1','312',1074,'','20','3',18000.00,0.00,'Retail Sale Id 499 for 25.00 KG of Cooking Gas @ N720.00','2023-02-23 15:32:56','',''),('1','312',1075,'','6.1','4',0.00,18000.00,'Retail Sale Id 499 for retail product','2023-02-23 15:32:56','',''),('1','312',1076,'','20','3',3600.00,0.00,'Retail Sale Id 500 for 5.00 KG of Cooking Gas @ N720.00','2023-02-23 15:35:00','',''),('1','312',1077,'','6.1','4',0.00,3600.00,'Retail Sale Id 500 for retail product','2023-02-23 15:35:00','',''),('1','312',1078,'','20','3',9000.00,0.00,'Retail Sale Id 501 for 12.50 KG of Cooking Gas @ N720.00','2023-02-23 15:39:36','',''),('1','312',1079,'','6.1','4',0.00,9000.00,'Retail Sale Id 501 for retail product','2023-02-23 15:39:36','',''),('1','312',1080,'','2','19',72670.00,0.00,'Payment Id 13 for invoice:11, receipt: 000 by AA RANO NIGERIA LTD','2023-02-23 15:49:31','',''),('1','312',1081,'','supplier','1',0.00,72670.00,'Payment Id 13 for invoice:11, receipt: 000 by AA RANO NIGERIA LTD','2023-02-23 15:49:31','',''),('1','312',1082,'','20','3',4320.00,0.00,'Retail Sale Id 502 for 6.00 KG of Cooking Gas @ N720.00','2023-02-23 15:56:57','',''),('1','312',1083,'','6.1','4',0.00,4320.00,'Retail Sale Id 502 for retail product','2023-02-23 15:56:57','',''),('1','312',1084,'','20','3',5040.00,0.00,'Retail Sale Id 503 for 7.00 KG of Cooking Gas @ N720.00','2023-02-23 16:01:06','',''),('1','312',1085,'','6.1','4',0.00,5040.00,'Retail Sale Id 503 for retail product','2023-02-23 16:01:06','',''),('1','312',1086,'','20','3',1440.00,0.00,'Retail Sale Id 504 for 2.00 KG of Cooking Gas @ N720.00','2023-02-23 16:32:06','',''),('1','312',1087,'','6.1','4',0.00,1440.00,'Retail Sale Id 504 for retail product','2023-02-23 16:32:06','',''),('1','312',1088,'','20','3',1800.00,0.00,'Retail Sale Id 505 for 2.50 KG of Cooking Gas @ N720.00','2023-02-23 16:38:00','',''),('1','312',1089,'','6.1','4',0.00,1800.00,'Retail Sale Id 505 for retail product','2023-02-23 16:38:00','',''),('1','312',1090,'','20','3',7200.00,0.00,'Retail Sale Id 506 for 10.00 KG of Cooking Gas @ N720.00','2023-02-23 16:43:08','',''),('1','312',1091,'','6.1','4',0.00,7200.00,'Retail Sale Id 506 for retail product','2023-02-23 16:43:08','',''),('1','312',1092,'','20','3',9000.00,0.00,'Retail Sale Id 507 for 12.50 KG of Cooking Gas @ N720.00','2023-02-23 16:44:59','',''),('1','312',1093,'','6.1','4',0.00,9000.00,'Retail Sale Id 507 for retail product','2023-02-23 16:44:59','',''),('1','312',1094,'','20','3',1440.00,0.00,'Retail Sale Id 508 for 2.00 KG of Cooking Gas @ N720.00','2023-02-23 16:48:30','',''),('1','312',1095,'','6.1','4',0.00,1440.00,'Retail Sale Id 508 for retail product','2023-02-23 16:48:30','',''),('1','312',1096,'','20','3',9000.00,0.00,'Retail Sale Id 509 for 12.50 KG of Cooking Gas @ N720.00','2023-02-23 17:03:05','',''),('1','312',1097,'','6.1','4',0.00,9000.00,'Retail Sale Id 509 for retail product','2023-02-23 17:03:05','',''),('1','312',1098,'','20','3',21080.00,0.00,'Retail Sale Id 510 for 31.00 KG of Cooking Gas @ N680.00','2023-02-23 17:07:58','',''),('1','312',1099,'','6.1','4',0.00,21080.00,'Retail Sale Id 510 for retail product','2023-02-23 17:07:58','',''),('1','312',1100,'','20','3',1440.00,0.00,'Retail Sale Id 511 for 2.00 KG of Cooking Gas @ N720.00','2023-02-23 17:18:05','',''),('1','312',1101,'','6.1','4',0.00,1440.00,'Retail Sale Id 511 for retail product','2023-02-23 17:18:05','',''),('1','312',1102,'','20','3',4320.00,0.00,'Retail Sale Id 512 for 6.00 KG of Cooking Gas @ N720.00','2023-02-23 17:34:48','',''),('1','312',1103,'','6.1','4',0.00,4320.00,'Retail Sale Id 512 for retail product','2023-02-23 17:34:48','',''),('1','312',1104,'','20','3',2200.00,0.00,'Retail Sale Id 513 for 3.06 KG of Cooking Gas @ N720.00','2023-02-23 17:39:40','',''),('1','312',1105,'','6.1','4',0.00,2200.00,'Retail Sale Id 513 for retail product','2023-02-23 17:39:40','',''),('1','312',1106,'','20','3',9000.00,0.00,'Retail Sale Id 514 for 1.00 KG of Cooking Gas @ N9000.00','2023-02-23 17:58:23','',''),('1','312',1107,'','6.1','4',0.00,9000.00,'Retail Sale Id 514 for retail product','2023-02-23 17:58:23','',''),('1','312',1108,'','20','3',7200.00,0.00,'Retail Sale Id 515 for 10.00 KG of Cooking Gas @ N720.00','2023-02-23 18:04:41','',''),('1','312',1109,'','6.1','4',0.00,7200.00,'Retail Sale Id 515 for retail product','2023-02-23 18:04:41','',''),('1','312',1110,'','20','3',1440.00,0.00,'Retail Sale Id 516 for 2.00 KG of Cooking Gas @ N720.00','2023-02-23 18:40:33','',''),('1','312',1111,'','6.1','4',0.00,1440.00,'Retail Sale Id 516 for retail product','2023-02-23 18:40:33','',''),('1','312',1112,'','20','3',4320.00,0.00,'Retail Sale Id 517 for 6.00 KG of Cooking Gas @ N720.00','2023-02-23 18:43:02','',''),('1','312',1113,'','6.1','4',0.00,4320.00,'Retail Sale Id 517 for retail product','2023-02-23 18:43:02','',''),('1','312',1114,'','20','3',7200.00,0.00,'Retail Sale Id 518 for 10.00 KG of Cooking Gas @ N720.00','2023-02-23 18:44:06','',''),('1','312',1115,'','6.1','4',0.00,7200.00,'Retail Sale Id 518 for retail product','2023-02-23 18:44:06','',''),('1','312',1116,'','20','3',9000.00,0.00,'Retail Sale Id 519 for 12.50 KG of Cooking Gas @ N720.00','2023-02-23 18:51:31','',''),('1','312',1117,'','6.1','4',0.00,9000.00,'Retail Sale Id 519 for retail product','2023-02-23 18:51:31','',''),('1','312',1118,'','20','3',3600.00,0.00,'Retail Sale Id 521 for 5.00 KG of Cooking Gas @ N720.00','2023-02-23 18:56:14','',''),('1','312',1119,'','6.1','4',0.00,3600.00,'Retail Sale Id 521 for retail product','2023-02-23 18:56:14','',''),('1','312',1120,'','20','3',5191.20,0.00,'Retail Sale Id 522 for 7.21 KG of Cooking Gas @ N720.00','2023-02-23 19:13:46','',''),('1','312',1121,'','6.1','4',0.00,5191.20,'Retail Sale Id 522 for retail product','2023-02-23 19:13:46','',''),('1','312',1122,'','20','3',14400.00,0.00,'Retail Sale Id 523 for 20.00 KG of Cooking Gas @ N720.00','2023-02-23 19:14:31','',''),('1','312',1123,'','6.1','4',0.00,14400.00,'Retail Sale Id 523 for retail product','2023-02-23 19:14:31','',''),('1','312',1124,'','20','3',14400.00,0.00,'Retail Sale Id 524 for 20.00 KG of Cooking Gas @ N720.00','2023-02-23 19:15:11','',''),('1','312',1125,'','6.1','4',0.00,14400.00,'Retail Sale Id 524 for retail product','2023-02-23 19:15:11','',''),('1','312',1126,'','20','3',0.00,21080.00,'Return of Retail Sale Id 510 for products','2023-02-23 19:18:47','',''),('1','312',1127,'','','',21080.00,0.00,'Return of Retail Sale Id 510 for products','2023-02-23 19:18:47','',''),('1','312',1128,'','20','3',20359.20,0.00,'Retail Sale Id 525 for 29.94 KG of Cooking Gas @ N680.00','2023-02-23 19:19:52','',''),('1','312',1129,'','6.1','4',0.00,20359.20,'Retail Sale Id 525 for retail product','2023-02-23 19:19:52','',''),('1','312',1130,'','20','3',0.00,0.00,'Sales from shift 21 on 2023-02-23 19:41:40 ','2023-02-23 19:41:40','',''),('1','312',1131,'','6.1','4',0.00,0.00,'Sales from shift 21 on 2023-02-23 19:41:40 ','2023-02-23 19:41:40','',''),('1','312',1132,'','20','3',6050.00,0.00,'Retail Sale Id 526 for 8.40 KG of Cooking Gas @ N720.00','2023-02-24 08:22:18','',''),('1','312',1133,'','6.1','4',0.00,6050.00,'Retail Sale Id 526 for retail product','2023-02-24 08:22:18','',''),('1','312',1134,'','20','3',5000.00,0.00,'Retail Sale Id 527 for 6.94 KG of Cooking Gas @ N720.00','2023-02-24 08:45:37','',''),('1','312',1135,'','6.1','4',0.00,5000.00,'Retail Sale Id 527 for retail product','2023-02-24 08:45:37','',''),('1','312',1136,'','20','3',10800.00,0.00,'Retail Sale Id 528 for 15.00 KG of Cooking Gas @ N720.00','2023-02-24 08:47:53','',''),('1','312',1137,'','6.1','4',0.00,10800.00,'Retail Sale Id 528 for retail product','2023-02-24 08:47:53','',''),('1','312',1138,'','20','3',2880.00,0.00,'Retail Sale Id 529 for 4.00 KG of Cooking Gas @ N720.00','2023-02-24 08:53:10','',''),('1','312',1139,'','6.1','4',0.00,2880.00,'Retail Sale Id 529 for retail product','2023-02-24 08:53:10','',''),('1','312',1140,'','20','3',3600.00,0.00,'Retail Sale Id 530 for 5.00 KG of Cooking Gas @ N720.00','2023-02-24 08:59:35','',''),('1','312',1141,'','6.1','4',0.00,3600.00,'Retail Sale Id 530 for retail product','2023-02-24 08:59:35','',''),('1','312',1142,'','20','3',10800.00,0.00,'Retail Sale Id 531 for 15.00 KG of Cooking Gas @ N720.00','2023-02-24 09:03:08','',''),('1','312',1143,'','6.1','4',0.00,10800.00,'Retail Sale Id 531 for retail product','2023-02-24 09:03:08','',''),('1','312',1144,'','20','3',3600.00,0.00,'Retail Sale Id 532 for 5.00 KG of Cooking Gas @ N720.00','2023-02-24 09:33:17','',''),('1','312',1145,'','6.1','4',0.00,3600.00,'Retail Sale Id 532 for retail product','2023-02-24 09:33:17','',''),('1','312',1146,'','20','3',16200.00,0.00,'Retail Sale Id 533 for 22.50 KG of Cooking Gas @ N720.00','2023-02-24 09:45:24','',''),('1','312',1147,'','6.1','4',0.00,16200.00,'Retail Sale Id 533 for retail product','2023-02-24 09:45:24','',''),('1','312',1148,'','20','3',5040.00,0.00,'Retail Sale Id 534 for 7.00 KG of Cooking Gas @ N720.00','2023-02-24 09:57:37','',''),('1','312',1149,'','6.1','4',0.00,5040.00,'Retail Sale Id 534 for retail product','2023-02-24 09:57:37','',''),('1','312',1150,'','20','3',9000.00,0.00,'Retail Sale Id 535 for 12.50 KG of Cooking Gas @ N720.00','2023-02-24 10:05:59','',''),('1','312',1151,'','6.1','4',0.00,9000.00,'Retail Sale Id 535 for retail product','2023-02-24 10:05:59','',''),('1','312',1152,'','20','3',7200.00,0.00,'Retail Sale Id 536 for 10.00 KG of Cooking Gas @ N720.00','2023-02-24 10:18:39','',''),('1','312',1153,'','6.1','4',0.00,7200.00,'Retail Sale Id 536 for retail product','2023-02-24 10:18:39','',''),('1','312',1154,'','20','3',4320.00,0.00,'Retail Sale Id 537 for 6.00 KG of Cooking Gas @ N720.00','2023-02-24 10:40:31','',''),('1','312',1155,'','6.1','4',0.00,4320.00,'Retail Sale Id 537 for retail product','2023-02-24 10:40:31','',''),('1','312',1156,'','20','3',3000.00,0.00,'Retail Sale Id 538 for 4.17 KG of Cooking Gas @ N720.00','2023-02-24 10:43:58','',''),('1','312',1157,'','6.1','4',0.00,3000.00,'Retail Sale Id 538 for retail product','2023-02-24 10:43:58','',''),('1','312',1158,'','20','3',2880.00,0.00,'Retail Sale Id 539 for 4.00 KG of Cooking Gas @ N720.00','2023-02-24 11:18:23','',''),('1','312',1159,'','6.1','4',0.00,2880.00,'Retail Sale Id 539 for retail product','2023-02-24 11:18:23','',''),('1','312',1160,'','20','3',4320.00,0.00,'Retail Sale Id 540 for 6.00 KG of Cooking Gas @ N720.00','2023-02-24 11:21:42','',''),('1','312',1161,'','6.1','4',0.00,4320.00,'Retail Sale Id 540 for retail product','2023-02-24 11:21:42','',''),('1','312',1162,'','20','3',6480.00,0.00,'Retail Sale Id 541 for 9.00 KG of Cooking Gas @ N720.00','2023-02-24 11:34:39','',''),('1','312',1163,'','6.1','4',0.00,6480.00,'Retail Sale Id 541 for retail product','2023-02-24 11:34:39','',''),('1','312',1164,'','20','3',3600.00,0.00,'Retail Sale Id 542 for 5.00 KG of Cooking Gas @ N720.00','2023-02-24 11:41:44','',''),('1','312',1165,'','6.1','4',0.00,3600.00,'Retail Sale Id 542 for retail product','2023-02-24 11:41:44','',''),('1','312',1166,'','20','3',9000.00,0.00,'Retail Sale Id 543 for 12.50 KG of Cooking Gas @ N720.00','2023-02-24 11:43:35','',''),('1','312',1167,'','6.1','4',0.00,9000.00,'Retail Sale Id 543 for retail product','2023-02-24 11:43:35','',''),('1','312',1168,'','20','3',3600.00,0.00,'Retail Sale Id 545 for 5.00 KG of Cooking Gas @ N720.00','2023-02-24 12:11:31','',''),('1','312',1169,'','6.1','4',0.00,3600.00,'Retail Sale Id 545 for retail product','2023-02-24 12:11:31','',''),('1','312',1170,'','20','3',2880.00,0.00,'Retail Sale Id 546 for 4.00 KG of Cooking Gas @ N720.00','2023-02-24 12:17:14','',''),('1','312',1171,'','6.1','4',0.00,2880.00,'Retail Sale Id 546 for retail product','2023-02-24 12:17:14','',''),('1','312',1172,'','20','3',5040.00,0.00,'Retail Sale Id 547 for 7.00 KG of Cooking Gas @ N720.00','2023-02-24 12:23:02','',''),('1','312',1173,'','6.1','4',0.00,5040.00,'Retail Sale Id 547 for retail product','2023-02-24 12:23:02','',''),('1','312',1174,'','20','3',4320.00,0.00,'Retail Sale Id 548 for 6.00 KG of Cooking Gas @ N720.00','2023-02-24 12:39:07','',''),('1','312',1175,'','6.1','4',0.00,4320.00,'Retail Sale Id 548 for retail product','2023-02-24 12:39:07','',''),('1','312',1176,'','20','3',8640.00,0.00,'Retail Sale Id 549 for 12.00 KG of Cooking Gas @ N720.00','2023-02-24 12:42:12','',''),('1','312',1177,'','6.1','4',0.00,8640.00,'Retail Sale Id 549 for retail product','2023-02-24 12:42:12','',''),('1','312',1178,'','20','3',2160.00,0.00,'Retail Sale Id 550 for 3.00 KG of Cooking Gas @ N720.00','2023-02-24 12:56:04','',''),('1','312',1179,'','6.1','4',0.00,2160.00,'Retail Sale Id 550 for retail product','2023-02-24 12:56:04','',''),('1','312',1180,'','20','3',5040.00,0.00,'Retail Sale Id 551 for 7.00 KG of Cooking Gas @ N720.00','2023-02-24 13:08:48','',''),('1','312',1181,'','6.1','4',0.00,5040.00,'Retail Sale Id 551 for retail product','2023-02-24 13:08:48','',''),('1','312',1182,'','20','3',4320.00,0.00,'Retail Sale Id 552 for 6.00 KG of Cooking Gas @ N720.00','2023-02-24 13:16:20','',''),('1','312',1183,'','6.1','4',0.00,4320.00,'Retail Sale Id 552 for retail product','2023-02-24 13:16:20','',''),('1','312',1184,'','20','3',4320.00,0.00,'Retail Sale Id 553 for 6.00 KG of Cooking Gas @ N720.00','2023-02-24 13:22:23','',''),('1','312',1185,'','6.1','4',0.00,4320.00,'Retail Sale Id 553 for retail product','2023-02-24 13:22:23','',''),('1','312',1186,'','20','3',7920.00,0.00,'Retail Sale Id 554 for 11.00 KG of Cooking Gas @ N720.00','2023-02-24 13:25:49','',''),('1','312',1187,'','6.1','4',0.00,7920.00,'Retail Sale Id 554 for retail product','2023-02-24 13:25:49','',''),('1','312',1188,'','20','3',18000.00,0.00,'Retail Sale Id 555 for 25.00 KG of Cooking Gas @ N720.00','2023-02-24 13:28:58','',''),('1','312',1189,'','6.1','4',0.00,18000.00,'Retail Sale Id 555 for retail product','2023-02-24 13:28:58','',''),('1','312',1190,'','20','3',5040.00,0.00,'Retail Sale Id 556 for 7.00 KG of Cooking Gas @ N720.00','2023-02-24 13:37:17','',''),('1','312',1191,'','6.1','4',0.00,5040.00,'Retail Sale Id 556 for retail product','2023-02-24 13:37:17','',''),('1','312',1192,'','20','3',2000.00,0.00,'Retail Sale Id 557 for 2.78 KG of Cooking Gas @ N720.00','2023-02-24 13:44:41','',''),('1','312',1193,'','6.1','4',0.00,2000.00,'Retail Sale Id 557 for retail product','2023-02-24 13:44:41','',''),('1','312',1194,'','20','3',2880.00,0.00,'Retail Sale Id 558 for 4.00 KG of Cooking Gas @ N720.00','2023-02-24 13:58:18','',''),('1','312',1195,'','6.1','4',0.00,2880.00,'Retail Sale Id 558 for retail product','2023-02-24 13:58:18','',''),('1','312',1196,'','20','3',3600.00,0.00,'Retail Sale Id 559 for 5.00 KG of Cooking Gas @ N720.00','2023-02-24 14:00:45','',''),('1','312',1197,'','6.1','4',0.00,3600.00,'Retail Sale Id 559 for retail product','2023-02-24 14:00:45','',''),('1','312',1198,'','20','3',2160.00,0.00,'Retail Sale Id 560 for 3.00 KG of Cooking Gas @ N720.00','2023-02-24 14:03:15','',''),('1','312',1199,'','6.1','4',0.00,2160.00,'Retail Sale Id 560 for retail product','2023-02-24 14:03:15','',''),('1','312',1200,'','20','3',4680.00,0.00,'Retail Sale Id 561 for 6.50 KG of Cooking Gas @ N720.00','2023-02-24 14:05:16','',''),('1','312',1201,'','6.1','4',0.00,4680.00,'Retail Sale Id 561 for retail product','2023-02-24 14:05:16','',''),('1','312',1202,'','20','3',2880.00,0.00,'Retail Sale Id 562 for 4.00 KG of Cooking Gas @ N720.00','2023-02-24 14:30:06','',''),('1','312',1203,'','6.1','4',0.00,2880.00,'Retail Sale Id 562 for retail product','2023-02-24 14:30:06','',''),('1','312',1204,'','20','3',18000.00,0.00,'Retail Sale Id 563 for 25.00 KG of Cooking Gas @ N720.00','2023-02-24 14:35:03','',''),('1','312',1205,'','6.1','4',0.00,18000.00,'Retail Sale Id 563 for retail product','2023-02-24 14:35:03','',''),('1','312',1206,'','20','3',18000.00,0.00,'Retail Sale Id 564 for 25.00 KG of Cooking Gas @ N720.00','2023-02-24 15:20:56','',''),('1','312',1207,'','6.1','4',0.00,18000.00,'Retail Sale Id 564 for retail product','2023-02-24 15:20:56','',''),('1','312',1208,'','20','3',10440.00,0.00,'Retail Sale Id 565 for 14.50 KG of Cooking Gas @ N720.00','2023-02-24 15:26:10','',''),('1','312',1209,'','6.1','4',0.00,10440.00,'Retail Sale Id 565 for retail product','2023-02-24 15:26:10','',''),('1','312',1210,'','20','3',2880.00,0.00,'Retail Sale Id 566 for 4.00 KG of Cooking Gas @ N720.00','2023-02-24 15:29:04','',''),('1','312',1211,'','6.1','4',0.00,2880.00,'Retail Sale Id 566 for retail product','2023-02-24 15:29:04','',''),('1','312',1212,'','20','3',2880.00,0.00,'Retail Sale Id 567 for 4.00 KG of Cooking Gas @ N720.00','2023-02-24 15:42:00','',''),('1','312',1213,'','6.1','4',0.00,2880.00,'Retail Sale Id 567 for retail product','2023-02-24 15:42:00','',''),('1','312',1214,'','20','3',9000.00,0.00,'Retail Sale Id 568 for 12.50 KG of Cooking Gas @ N720.00','2023-02-24 15:44:51','',''),('1','312',1215,'','6.1','4',0.00,9000.00,'Retail Sale Id 568 for retail product','2023-02-24 15:44:51','',''),('1','312',1216,'','20','3',4680.00,0.00,'Retail Sale Id 569 for 6.50 KG of Cooking Gas @ N720.00','2023-02-24 15:46:40','',''),('1','312',1217,'','6.1','4',0.00,4680.00,'Retail Sale Id 569 for retail product','2023-02-24 15:46:40','',''),('1','312',1218,'','20','3',3600.00,0.00,'Retail Sale Id 570 for 5.00 KG of Cooking Gas @ N720.00','2023-02-24 15:52:44','',''),('1','312',1219,'','6.1','4',0.00,3600.00,'Retail Sale Id 570 for retail product','2023-02-24 15:52:44','',''),('1','312',1220,'','20','3',3600.00,0.00,'Retail Sale Id 571 for 5.00 KG of Cooking Gas @ N720.00','2023-02-24 15:56:19','',''),('1','312',1221,'','6.1','4',0.00,3600.00,'Retail Sale Id 571 for retail product','2023-02-24 15:56:19','',''),('1','312',1222,'','20','3',1440.00,0.00,'Retail Sale Id 572 for 2.00 KG of Cooking Gas @ N720.00','2023-02-24 16:00:56','',''),('1','312',1223,'','6.1','4',0.00,1440.00,'Retail Sale Id 572 for retail product','2023-02-24 16:00:56','',''),('1','312',1224,'','20','3',5040.00,0.00,'Retail Sale Id 573 for 7.00 KG of Cooking Gas @ N720.00','2023-02-24 16:05:30','',''),('1','312',1225,'','6.1','4',0.00,5040.00,'Retail Sale Id 573 for retail product','2023-02-24 16:05:30','',''),('1','312',1226,'','20','3',2160.00,0.00,'Retail Sale Id 574 for 3.00 KG of Cooking Gas @ N720.00','2023-02-24 16:14:34','',''),('1','312',1227,'','6.1','4',0.00,2160.00,'Retail Sale Id 574 for retail product','2023-02-24 16:14:34','',''),('1','312',1228,'','20','3',9000.00,0.00,'Retail Sale Id 575 for 12.50 KG of Cooking Gas @ N720.00','2023-02-24 16:59:04','',''),('1','312',1229,'','6.1','4',0.00,9000.00,'Retail Sale Id 575 for retail product','2023-02-24 16:59:04','',''),('1','312',1230,'','20','3',1440.00,0.00,'Retail Sale Id 576 for 2.00 KG of Cooking Gas @ N720.00','2023-02-24 17:06:44','',''),('1','312',1231,'','6.1','4',0.00,1440.00,'Retail Sale Id 576 for retail product','2023-02-24 17:06:44','',''),('1','312',1232,'','20','3',4320.00,0.00,'Retail Sale Id 577 for 6.00 KG of Cooking Gas @ N720.00','2023-02-24 17:16:05','',''),('1','312',1233,'','6.1','4',0.00,4320.00,'Retail Sale Id 577 for retail product','2023-02-24 17:16:05','',''),('1','312',1234,'','20','3',2160.00,0.00,'Retail Sale Id 578 for 3.00 KG of Cooking Gas @ N720.00','2023-02-24 17:24:02','',''),('1','312',1235,'','6.1','4',0.00,2160.00,'Retail Sale Id 578 for retail product','2023-02-24 17:24:02','',''),('1','312',1236,'','20','3',2160.00,0.00,'Retail Sale Id 579 for 3.00 KG of Cooking Gas @ N720.00','2023-02-24 17:25:04','',''),('1','312',1237,'','6.1','4',0.00,2160.00,'Retail Sale Id 579 for retail product','2023-02-24 17:25:04','',''),('1','312',1238,'','20','3',2880.00,0.00,'Retail Sale Id 580 for 4.00 KG of Cooking Gas @ N720.00','2023-02-24 17:27:19','',''),('1','312',1239,'','6.1','4',0.00,2880.00,'Retail Sale Id 580 for retail product','2023-02-24 17:27:19','',''),('1','312',1240,'','20','3',10800.00,0.00,'Retail Sale Id 582 for 15.00 KG of Cooking Gas @ N720.00','2023-02-24 17:29:19','',''),('1','312',1241,'','6.1','4',0.00,10800.00,'Retail Sale Id 582 for retail product','2023-02-24 17:29:19','',''),('1','312',1242,'','20','3',5040.00,0.00,'Retail Sale Id 583 for 7.00 KG of Cooking Gas @ N720.00','2023-02-24 17:30:18','',''),('1','312',1243,'','6.1','4',0.00,5040.00,'Retail Sale Id 583 for retail product','2023-02-24 17:30:18','',''),('1','312',1244,'','20','3',7200.00,0.00,'Retail Sale Id 584 for 10.00 KG of Cooking Gas @ N720.00','2023-02-24 17:33:19','',''),('1','312',1245,'','6.1','4',0.00,7200.00,'Retail Sale Id 584 for retail product','2023-02-24 17:33:19','',''),('1','312',1246,'','20','3',5040.00,0.00,'Retail Sale Id 585 for 7.00 KG of Cooking Gas @ N720.00','2023-02-24 17:35:32','',''),('1','312',1247,'','6.1','4',0.00,5040.00,'Retail Sale Id 585 for retail product','2023-02-24 17:35:32','',''),('1','312',1248,'','20','3',12240.00,0.00,'Retail Sale Id 586 for 17.00 KG of Cooking Gas @ N720.00','2023-02-24 17:37:20','',''),('1','312',1249,'','6.1','4',0.00,12240.00,'Retail Sale Id 586 for retail product','2023-02-24 17:37:20','',''),('1','312',1250,'','20','3',9000.00,0.00,'Retail Sale Id 587 for 12.50 KG of Cooking Gas @ N720.00','2023-02-24 17:38:06','',''),('1','312',1251,'','6.1','4',0.00,9000.00,'Retail Sale Id 587 for retail product','2023-02-24 17:38:06','',''),('1','312',1252,'','20','3',7200.00,0.00,'Retail Sale Id 589 for 10.00 KG of Cooking Gas @ N720.00','2023-02-24 17:42:48','',''),('1','312',1253,'','6.1','4',0.00,7200.00,'Retail Sale Id 589 for retail product','2023-02-24 17:42:48','',''),('1','312',1254,'','20','3',8280.00,0.00,'Retail Sale Id 590 for 11.50 KG of Cooking Gas @ N720.00','2023-02-24 17:45:11','',''),('1','312',1255,'','6.1','4',0.00,8280.00,'Retail Sale Id 590 for retail product','2023-02-24 17:45:11','',''),('1','312',1256,'','20','3',1440.00,0.00,'Retail Sale Id 591 for 2.00 KG of Cooking Gas @ N720.00','2023-02-24 17:48:17','',''),('1','312',1257,'','6.1','4',0.00,1440.00,'Retail Sale Id 591 for retail product','2023-02-24 17:48:17','',''),('1','312',1258,'','20','3',7920.00,0.00,'Retail Sale Id 592 for 11.00 KG of Cooking Gas @ N720.00','2023-02-24 17:49:47','',''),('1','312',1259,'','6.1','4',0.00,7920.00,'Retail Sale Id 592 for retail product','2023-02-24 17:49:47','',''),('1','312',1260,'','20','3',1440.00,0.00,'Retail Sale Id 593 for 2.00 KG of Cooking Gas @ N720.00','2023-02-24 18:04:36','',''),('1','312',1261,'','6.1','4',0.00,1440.00,'Retail Sale Id 593 for retail product','2023-02-24 18:04:36','',''),('1','312',1262,'','20','3',5040.00,0.00,'Retail Sale Id 594 for 7.00 KG of Cooking Gas @ N720.00','2023-02-24 18:10:23','',''),('1','312',1263,'','6.1','4',0.00,5040.00,'Retail Sale Id 594 for retail product','2023-02-24 18:10:23','',''),('1','312',1264,'','20','3',6480.00,0.00,'Retail Sale Id 595 for 9.00 KG of Cooking Gas @ N720.00','2023-02-24 18:11:37','',''),('1','312',1265,'','6.1','4',0.00,6480.00,'Retail Sale Id 595 for retail product','2023-02-24 18:11:37','',''),('1','312',1266,'','20','3',2160.00,0.00,'Retail Sale Id 597 for 3.00 KG of Cooking Gas @ N720.00','2023-02-24 18:13:20','',''),('1','312',1267,'','6.1','4',0.00,2160.00,'Retail Sale Id 597 for retail product','2023-02-24 18:13:20','',''),('1','312',1268,'','20','3',3600.00,0.00,'Retail Sale Id 598 for 5.00 KG of Cooking Gas @ N720.00','2023-02-24 18:14:13','',''),('1','312',1269,'','6.1','4',0.00,3600.00,'Retail Sale Id 598 for retail product','2023-02-24 18:14:13','',''),('1','312',1270,'','20','3',2900.00,0.00,'Retail Sale Id 599 for 4.03 KG of Cooking Gas @ N720.00','2023-02-24 18:15:41','',''),('1','312',1271,'','6.1','4',0.00,2900.00,'Retail Sale Id 599 for retail product','2023-02-24 18:15:41','',''),('1','312',1272,'','20','3',3600.00,0.00,'Retail Sale Id 600 for 5.00 KG of Cooking Gas @ N720.00','2023-02-24 18:22:31','',''),('1','312',1273,'','6.1','4',0.00,3600.00,'Retail Sale Id 600 for retail product','2023-02-24 18:22:31','',''),('1','312',1274,'','20','3',5400.00,0.00,'Retail Sale Id 601 for 7.50 KG of Cooking Gas @ N720.00','2023-02-24 18:33:33','',''),('1','312',1275,'','6.1','4',0.00,5400.00,'Retail Sale Id 601 for retail product','2023-02-24 18:33:33','',''),('1','312',1276,'','20','3',16560.00,0.00,'Retail Sale Id 602 for 23.00 KG of Cooking Gas @ N720.00','2023-02-24 18:40:19','',''),('1','312',1277,'','6.1','4',0.00,16560.00,'Retail Sale Id 602 for retail product','2023-02-24 18:40:19','',''),('1','312',1278,'','20','3',2900.00,0.00,'Retail Sale Id 603 for 4.03 KG of Cooking Gas @ N720.00','2023-02-24 18:43:11','',''),('1','312',1279,'','6.1','4',0.00,2900.00,'Retail Sale Id 603 for retail product','2023-02-24 18:43:11','',''),('1','312',1280,'','20','3',320213.25,0.00,'Retail Sale Id 604 for 474.39 KG of Cooking Gas @ N675.00','2023-02-24 18:57:47','',''),('1','312',1281,'','6.1','4',0.00,320213.25,'Retail Sale Id 604 for retail product','2023-02-24 18:57:47','',''),('1','312',1282,'','20','3',0.00,0.00,'Sales from shift 22 on 2023-02-24 19:13:42 ','2023-02-24 19:13:42','',''),('1','312',1283,'','6.1','4',0.00,0.00,'Sales from shift 22 on 2023-02-24 19:13:42 ','2023-02-24 19:13:42','',''),('1','312',1284,'','20','3',2160.00,0.00,'Retail Sale Id 605 for 3.00 KG of Cooking Gas @ N720.00','2023-02-28 08:05:11','',''),('1','312',1285,'','6.1','4',0.00,2160.00,'Retail Sale Id 605 for retail product','2023-02-28 08:05:11','',''),('1','312',1286,'','20','3',2200.00,0.00,'Retail Sale Id 606 for 3.06 KG of Cooking Gas @ N720.00','2023-02-28 08:40:45','',''),('1','312',1287,'','6.1','4',0.00,2200.00,'Retail Sale Id 606 for retail product','2023-02-28 08:40:45','',''),('1','312',1288,'','20','3',7200.00,0.00,'Retail Sale Id 607 for 10.00 KG of Cooking Gas @ N720.00','2023-02-28 08:42:36','',''),('1','312',1289,'','6.1','4',0.00,7200.00,'Retail Sale Id 607 for retail product','2023-02-28 08:42:36','',''),('1','312',1290,'','20','3',9000.00,0.00,'Retail Sale Id 608 for 12.50 KG of Cooking Gas @ N720.00','2023-02-28 08:44:53','',''),('1','312',1291,'','6.1','4',0.00,9000.00,'Retail Sale Id 608 for retail product','2023-02-28 08:44:53','',''),('1','312',1292,'','20','3',7200.00,0.00,'Retail Sale Id 609 for 10.00 KG of Cooking Gas @ N720.00','2023-02-28 08:53:53','',''),('1','312',1293,'','6.1','4',0.00,7200.00,'Retail Sale Id 609 for retail product','2023-02-28 08:53:53','',''),('1','312',1294,'','20','3',1440.00,0.00,'Retail Sale Id 610 for 2.00 KG of Cooking Gas @ N720.00','2023-02-28 09:28:23','',''),('1','312',1295,'','6.1','4',0.00,1440.00,'Retail Sale Id 610 for retail product','2023-02-28 09:28:23','',''),('1','312',1296,'','20','3',4320.00,0.00,'Retail Sale Id 611 for 6.00 KG of Cooking Gas @ N720.00','2023-02-28 09:34:03','',''),('1','312',1297,'','6.1','4',0.00,4320.00,'Retail Sale Id 611 for retail product','2023-02-28 09:34:03','',''),('1','312',1298,'','20','3',3600.00,0.00,'Retail Sale Id 612 for 5.00 KG of Cooking Gas @ N720.00','2023-02-28 09:59:45','',''),('1','312',1299,'','6.1','4',0.00,3600.00,'Retail Sale Id 612 for retail product','2023-02-28 09:59:45','',''),('1','312',1300,'','20','3',2880.00,0.00,'Retail Sale Id 613 for 4.00 KG of Cooking Gas @ N720.00','2023-02-28 10:00:55','',''),('1','312',1301,'','6.1','4',0.00,2880.00,'Retail Sale Id 613 for retail product','2023-02-28 10:00:55','',''),('1','312',1302,'','20','3',720.00,0.00,'Retail Sale Id 614 for 1.00 KG of Cooking Gas @ N720.00','2023-02-28 10:02:10','',''),('1','312',1303,'','6.1','4',0.00,720.00,'Retail Sale Id 614 for retail product','2023-02-28 10:02:10','',''),('1','312',1304,'','20','3',4320.00,0.00,'Retail Sale Id 615 for 6.00 KG of Cooking Gas @ N720.00','2023-02-28 10:21:10','',''),('1','312',1305,'','6.1','4',0.00,4320.00,'Retail Sale Id 615 for retail product','2023-02-28 10:21:10','',''),('1','312',1306,'','20','3',5040.00,0.00,'Retail Sale Id 616 for 7.00 KG of Cooking Gas @ N720.00','2023-02-28 11:11:40','',''),('1','312',1307,'','6.1','4',0.00,5040.00,'Retail Sale Id 616 for retail product','2023-02-28 11:11:40','',''),('1','312',1308,'','20','3',5040.00,0.00,'Retail Sale Id 617 for 7.00 KG of Cooking Gas @ N720.00','2023-02-28 11:18:20','',''),('1','312',1309,'','6.1','4',0.00,5040.00,'Retail Sale Id 617 for retail product','2023-02-28 11:18:20','',''),('1','312',1310,'','20','3',5040.00,0.00,'Retail Sale Id 618 for 7.00 KG of Cooking Gas @ N720.00','2023-02-28 11:20:48','',''),('1','312',1311,'','6.1','4',0.00,5040.00,'Retail Sale Id 618 for retail product','2023-02-28 11:20:48','',''),('1','312',1312,'','20','3',3600.00,0.00,'Retail Sale Id 619 for 5.00 KG of Cooking Gas @ N720.00','2023-02-28 11:57:30','',''),('1','312',1313,'','6.1','4',0.00,3600.00,'Retail Sale Id 619 for retail product','2023-02-28 11:57:30','',''),('1','312',1314,'','20','3',7200.00,0.00,'Retail Sale Id 620 for 10.00 KG of Cooking Gas @ N720.00','2023-02-28 12:09:04','',''),('1','312',1315,'','6.1','4',0.00,7200.00,'Retail Sale Id 620 for retail product','2023-02-28 12:09:04','',''),('1','312',1316,'','20','3',2160.00,0.00,'Retail Sale Id 621 for 3.00 KG of Cooking Gas @ N720.00','2023-02-28 12:29:11','',''),('1','312',1317,'','6.1','4',0.00,2160.00,'Retail Sale Id 621 for retail product','2023-02-28 12:29:11','',''),('1','312',1318,'','20','3',1500.00,0.00,'Retail Sale Id 622 for 2.08 KG of Cooking Gas @ N720.00','2023-02-28 12:48:46','',''),('1','312',1319,'','6.1','4',0.00,1500.00,'Retail Sale Id 622 for retail product','2023-02-28 12:48:46','',''),('1','312',1320,'','2','19',409528.00,0.00,'Payment Id 22 for invoice:16, receipt: 000 by AA RANO NIGERIA LTD','2023-02-28 12:55:17','',''),('1','312',1321,'','supplier','1',0.00,409528.00,'Payment Id 22 for invoice:16, receipt: 000 by AA RANO NIGERIA LTD','2023-02-28 12:55:17','',''),('1','312',1322,'','2','20',394340.00,0.00,'Payment Id 25 for invoice:18, receipt: p o s by AA RANO NIGERIA LTD','2023-02-28 12:56:08','',''),('1','312',1323,'','supplier','1',0.00,394340.00,'Payment Id 25 for invoice:18, receipt: p o s by AA RANO NIGERIA LTD','2023-02-28 12:56:08','',''),('1','312',1324,'','2','19',460958.00,0.00,'Payment Id 24 for invoice:18, receipt: 000 by AA RANO NIGERIA LTD','2023-02-28 12:56:08','',''),('1','312',1325,'','supplier','1',0.00,460958.00,'Payment Id 24 for invoice:18, receipt: 000 by AA RANO NIGERIA LTD','2023-02-28 12:56:08','',''),('1','312',1326,'','2','20',178520.00,0.00,'Payment Id 37 for invoice:19, receipt: p o s by AA RANO NIGERIA LTD','2023-02-28 13:31:28','',''),('1','312',1327,'','supplier','1',0.00,178520.00,'Payment Id 37 for invoice:19, receipt: p o s by AA RANO NIGERIA LTD','2023-02-28 13:31:28','',''),('1','312',1328,'','2','19',122400.00,0.00,'Payment Id 26 for invoice:19, receipt: 000 by AA RANO NIGERIA LTD','2023-02-28 13:31:28','',''),('1','312',1329,'','supplier','1',0.00,122400.00,'Payment Id 26 for invoice:19, receipt: 000 by AA RANO NIGERIA LTD','2023-02-28 13:31:28','',''),('1','312',1330,'','2','8',115922.80,0.00,'Payment Id 29 for invoice:7, receipt: p o s by AA RANO NIGERIA LTD','2023-02-28 13:33:19','',''),('1','312',1331,'','supplier','1',0.00,115922.80,'Payment Id 29 for invoice:7, receipt: p o s by AA RANO NIGERIA LTD','2023-02-28 13:33:19','',''),('1','312',1332,'','2','20',719100.00,0.00,'Payment Id 32 for invoice:21, receipt: p o s by AA RANO NIGERIA LTD','2023-02-28 13:34:16','',''),('1','312',1333,'','supplier','1',0.00,719100.00,'Payment Id 32 for invoice:21, receipt: p o s by AA RANO NIGERIA LTD','2023-02-28 13:34:16','',''),('1','312',1334,'','2','8',51600.00,0.00,'Payment Id 36 for invoice:22, receipt: p o s by AA RANO NIGERIA LTD','2023-02-28 13:35:44','',''),('1','312',1335,'','supplier','1',0.00,51600.00,'Payment Id 36 for invoice:22, receipt: p o s by AA RANO NIGERIA LTD','2023-02-28 13:35:44','',''),('1','312',1336,'','2','20',356400.00,0.00,'Payment Id 35 for invoice:22, receipt: p o s by AA RANO NIGERIA LTD','2023-02-28 13:35:44','',''),('1','312',1337,'','supplier','1',0.00,356400.00,'Payment Id 35 for invoice:22, receipt: p o s by AA RANO NIGERIA LTD','2023-02-28 13:35:44','',''),('1','312',1338,'','20','3',3600.00,0.00,'Retail Sale Id 623 for 5.00 KG of Cooking Gas @ N720.00','2023-02-28 13:52:22','',''),('1','312',1339,'','6.1','4',0.00,3600.00,'Retail Sale Id 623 for retail product','2023-02-28 13:52:22','',''),('1','312',1340,'','20','3',8640.00,0.00,'Retail Sale Id 624 for 12.00 KG of Cooking Gas @ N720.00','2023-02-28 13:55:08','',''),('1','312',1341,'','6.1','4',0.00,8640.00,'Retail Sale Id 624 for retail product','2023-02-28 13:55:08','',''),('1','312',1342,'','20','3',7920.00,0.00,'Retail Sale Id 625 for 11.00 KG of Cooking Gas @ N720.00','2023-02-28 14:20:06','',''),('1','312',1343,'','6.1','4',0.00,7920.00,'Retail Sale Id 625 for retail product','2023-02-28 14:20:06','',''),('1','312',1344,'','20','3',7980.00,0.00,'Retail Sale Id 626 for 11.08 KG of Cooking Gas @ N720.00','2023-02-28 14:43:25','',''),('1','312',1345,'','6.1','4',0.00,7980.00,'Retail Sale Id 626 for retail product','2023-02-28 14:43:25','',''),('1','312',1346,'','20','3',1440.00,0.00,'Retail Sale Id 627 for 2.00 KG of Cooking Gas @ N720.00','2023-02-28 15:52:42','',''),('1','312',1347,'','6.1','4',0.00,1440.00,'Retail Sale Id 627 for retail product','2023-02-28 15:52:42','',''),('1','312',1348,'','20','3',9000.00,0.00,'Retail Sale Id 628 for 12.50 KG of Cooking Gas @ N720.00','2023-02-28 16:05:15','',''),('1','312',1349,'','6.1','4',0.00,9000.00,'Retail Sale Id 628 for retail product','2023-02-28 16:05:15','',''),('1','312',1350,'','20','3',9000.00,0.00,'Retail Sale Id 629 for 12.50 KG of Cooking Gas @ N720.00','2023-02-28 16:43:10','',''),('1','312',1351,'','6.1','4',0.00,9000.00,'Retail Sale Id 629 for retail product','2023-02-28 16:43:10','',''),('1','312',1352,'','20','3',1000.00,0.00,'Retail Sale Id 630 for 1.39 KG of Cooking Gas @ N720.00','2023-02-28 16:47:48','',''),('1','312',1353,'','6.1','4',0.00,1000.00,'Retail Sale Id 630 for retail product','2023-02-28 16:47:48','',''),('1','312',1354,'','20','3',417116.25,0.00,'Retail Sale Id 631 for 617.95 KG of Cooking Gas @ N675.00','2023-02-28 19:14:03','',''),('1','312',1355,'','6.1','4',0.00,417116.25,'Retail Sale Id 631 for retail product','2023-02-28 19:14:03','',''),('1','312',1356,'','20','3',23191.20,0.00,'Retail Sale Id 632 for 32.21 KG of Cooking Gas @ N720.00','2023-02-28 19:16:51','',''),('1','312',1357,'','6.1','4',0.00,23191.20,'Retail Sale Id 632 for retail product','2023-02-28 19:16:51','',''),('1','312',1358,'','20','3',0.00,0.00,'Sales from shift 23 on 2023-02-28 19:30:18 ','2023-02-28 19:30:18','',''),('1','312',1359,'','6.1','4',0.00,0.00,'Sales from shift 23 on 2023-02-28 19:30:18 ','2023-02-28 19:30:18','',''),('1','312',1360,'','20','3',5040.00,0.00,'Retail Sale Id 633 for 7.00 KG of Cooking Gas @ N720.00','2023-03-01 07:49:42','',''),('1','312',1361,'','6.1','4',0.00,5040.00,'Retail Sale Id 633 for retail product','2023-03-01 07:49:42','',''),('1','312',1362,'','20','3',9000.00,0.00,'Retail Sale Id 634 for 12.50 KG of Cooking Gas @ N720.00','2023-03-01 07:59:30','',''),('1','312',1363,'','6.1','4',0.00,9000.00,'Retail Sale Id 634 for retail product','2023-03-01 07:59:30','',''),('1','312',1364,'','20','3',2160.00,0.00,'Retail Sale Id 635 for 3.00 KG of Cooking Gas @ N720.00','2023-03-01 08:16:33','',''),('1','312',1365,'','6.1','4',0.00,2160.00,'Retail Sale Id 635 for retail product','2023-03-01 08:16:33','',''),('1','312',1366,'','20','3',4680.00,0.00,'Retail Sale Id 636 for 6.50 KG of Cooking Gas @ N720.00','2023-03-01 08:24:27','',''),('1','312',1367,'','6.1','4',0.00,4680.00,'Retail Sale Id 636 for retail product','2023-03-01 08:24:27','',''),('1','312',1368,'','20','3',5040.00,0.00,'Retail Sale Id 637 for 7.00 KG of Cooking Gas @ N720.00','2023-03-01 08:37:51','',''),('1','312',1369,'','6.1','4',0.00,5040.00,'Retail Sale Id 637 for retail product','2023-03-01 08:37:51','',''),('1','312',1370,'','20','3',6000.00,0.00,'Retail Sale Id 638 for 8.33 KG of Cooking Gas @ N720.00','2023-03-01 08:49:45','',''),('1','312',1371,'','6.1','4',0.00,6000.00,'Retail Sale Id 638 for retail product','2023-03-01 08:49:45','',''),('1','312',1372,'','20','3',5040.00,0.00,'Retail Sale Id 639 for 7.00 KG of Cooking Gas @ N720.00','2023-03-01 08:57:52','',''),('1','312',1373,'','6.1','4',0.00,5040.00,'Retail Sale Id 639 for retail product','2023-03-01 08:57:52','',''),('1','312',1374,'','20','3',7200.00,0.00,'Retail Sale Id 640 for 10.00 KG of Cooking Gas @ N720.00','2023-03-01 09:43:42','',''),('1','312',1375,'','6.1','4',0.00,7200.00,'Retail Sale Id 640 for retail product','2023-03-01 09:43:43','',''),('1','312',1376,'','20','3',2880.00,0.00,'Retail Sale Id 641 for 4.00 KG of Cooking Gas @ N720.00','2023-03-01 10:27:16','',''),('1','312',1377,'','6.1','4',0.00,2880.00,'Retail Sale Id 641 for retail product','2023-03-01 10:27:16','',''),('1','312',1378,'','20','3',4500.00,0.00,'Retail Sale Id 642 for 6.25 KG of Cooking Gas @ N720.00','2023-03-01 10:41:36','',''),('1','312',1379,'','6.1','4',0.00,4500.00,'Retail Sale Id 642 for retail product','2023-03-01 10:41:36','',''),('1','312',1380,'','20','3',5040.00,0.00,'Retail Sale Id 643 for 7.00 KG of Cooking Gas @ N720.00','2023-03-01 10:44:03','',''),('1','312',1381,'','6.1','4',0.00,5040.00,'Retail Sale Id 643 for retail product','2023-03-01 10:44:03','',''),('1','312',1382,'','20','3',4320.00,0.00,'Retail Sale Id 644 for 6.00 KG of Cooking Gas @ N720.00','2023-03-01 10:50:54','',''),('1','312',1383,'','6.1','4',0.00,4320.00,'Retail Sale Id 644 for retail product','2023-03-01 10:50:54','',''),('1','312',1384,'','20','3',3600.00,0.00,'Retail Sale Id 645 for 5.00 KG of Cooking Gas @ N720.00','2023-03-01 12:16:06','',''),('1','312',1385,'','6.1','4',0.00,3600.00,'Retail Sale Id 645 for retail product','2023-03-01 12:16:06','',''),('1','312',1386,'','20','3',3600.00,0.00,'Retail Sale Id 646 for 5.00 KG of Cooking Gas @ N720.00','2023-03-01 12:49:59','',''),('1','312',1387,'','6.1','4',0.00,3600.00,'Retail Sale Id 646 for retail product','2023-03-01 12:49:59','',''),('1','312',1388,'','20','3',2160.00,0.00,'Retail Sale Id 647 for 3.00 KG of Cooking Gas @ N720.00','2023-03-01 14:20:52','',''),('1','312',1389,'','6.1','4',0.00,2160.00,'Retail Sale Id 647 for retail product','2023-03-01 14:20:52','',''),('1','312',1390,'','20','3',4320.00,0.00,'Retail Sale Id 648 for 6.00 KG of Cooking Gas @ N720.00','2023-03-01 14:36:25','',''),('1','312',1391,'','6.1','4',0.00,4320.00,'Retail Sale Id 648 for retail product','2023-03-01 14:36:25','',''),('1','312',1392,'','2','19',80530.00,0.00,'Payment Id 18 for invoice:14, receipt: 000 by AA RANO NIGERIA LTD','2023-03-01 14:40:42','',''),('1','312',1393,'','supplier','1',0.00,80530.00,'Payment Id 18 for invoice:14, receipt: 000 by AA RANO NIGERIA LTD','2023-03-01 14:40:42','',''),('1','312',1394,'','2','19',173120.00,0.00,'Payment Id 38 for invoice:17, receipt: 000 by AA RANO NIGERIA LTD','2023-03-01 14:43:47','',''),('1','312',1395,'','supplier','1',0.00,173120.00,'Payment Id 38 for invoice:17, receipt: 000 by AA RANO NIGERIA LTD','2023-03-01 14:43:47','',''),('1','312',1396,'','20','3',2880.00,0.00,'Retail Sale Id 649 for 4.00 KG of Cooking Gas @ N720.00','2023-03-01 15:08:05','',''),('1','312',1397,'','6.1','4',0.00,2880.00,'Retail Sale Id 649 for retail product','2023-03-01 15:08:05','',''),('1','312',1398,'','20','3',4000.00,0.00,'Retail Sale Id 650 for 5.56 KG of Cooking Gas @ N720.00','2023-03-01 15:10:14','',''),('1','312',1399,'','6.1','4',0.00,4000.00,'Retail Sale Id 650 for retail product','2023-03-01 15:10:14','',''),('1','312',1400,'','6.1','4',0.00,115922.80,'Payment Id 29 for invoice:7, receipt: p o s by AA RANO NIGERIA LTD','2023-03-01 16:36:27','',''),('1','312',1401,'','supplier','1',115922.80,0.00,'Payment Id 29 for invoice:7, receipt: p o s by AA RANO NIGERIA LTD','2023-03-01 16:36:27','',''),('1','312',1402,'','2','8',85900.00,0.00,'Payment Id 39 for invoice:17, receipt: p o s by AA RANO NIGERIA LTD','2023-03-01 17:01:25','',''),('1','312',1403,'','supplier','1',0.00,85900.00,'Payment Id 39 for invoice:17, receipt: p o s by AA RANO NIGERIA LTD','2023-03-01 17:01:25','',''),('1','312',1404,'','2','8',5040.00,0.00,'Payment Id 33 for invoice:21, receipt: p o s by AA RANO NIGERIA LTD','2023-03-01 17:01:51','',''),('1','312',1405,'','supplier','1',0.00,5040.00,'Payment Id 33 for invoice:21, receipt: p o s by AA RANO NIGERIA LTD','2023-03-01 17:01:51','',''),('1','312',1406,'','20','3',2160.00,0.00,'Retail Sale Id 651 for 3.00 KG of Cooking Gas @ N720.00','2023-03-01 17:38:29','',''),('1','312',1407,'','6.1','4',0.00,2160.00,'Retail Sale Id 651 for retail product','2023-03-01 17:38:29','',''),('1','312',1408,'','20','3',2160.00,0.00,'Retail Sale Id 652 for 3.00 KG of Cooking Gas @ N720.00','2023-03-01 17:40:25','',''),('1','312',1409,'','6.1','4',0.00,2160.00,'Retail Sale Id 652 for retail product','2023-03-01 17:40:25','',''),('1','312',1410,'','20','3',2880.00,0.00,'Retail Sale Id 654 for 4.00 KG of Cooking Gas @ N720.00','2023-03-01 17:42:49','',''),('1','312',1411,'','6.1','4',0.00,2880.00,'Retail Sale Id 654 for retail product','2023-03-01 17:42:49','',''),('1','312',1412,'','20','3',4320.00,0.00,'Retail Sale Id 655 for 6.00 KG of Cooking Gas @ N720.00','2023-03-01 17:51:56','',''),('1','312',1413,'','6.1','4',0.00,4320.00,'Retail Sale Id 655 for retail product','2023-03-01 17:51:56','',''),('1','312',1414,'','20','3',5040.00,0.00,'Retail Sale Id 656 for 7.00 KG of Cooking Gas @ N720.00','2023-03-01 18:13:20','',''),('1','312',1415,'','6.1','4',0.00,5040.00,'Retail Sale Id 656 for retail product','2023-03-01 18:13:20','',''),('1','312',1416,'','20','3',3000.00,0.00,'Retail Sale Id 657 for 4.17 KG of Cooking Gas @ N720.00','2023-03-01 18:22:55','',''),('1','312',1417,'','6.1','4',0.00,3000.00,'Retail Sale Id 657 for retail product','2023-03-01 18:22:55','',''),('1','312',1418,'','20','3',9000.00,0.00,'Retail Sale Id 658 for 12.50 KG of Cooking Gas @ N720.00','2023-03-01 18:24:06','',''),('1','312',1419,'','6.1','4',0.00,9000.00,'Retail Sale Id 658 for retail product','2023-03-01 18:24:06','',''),('1','312',1420,'','20','3',2160.00,0.00,'Retail Sale Id 659 for 3.00 KG of Cooking Gas @ N720.00','2023-03-01 18:33:57','',''),('1','312',1421,'','6.1','4',0.00,2160.00,'Retail Sale Id 659 for retail product','2023-03-01 18:33:57','',''),('1','312',1422,'','20','3',2200.00,0.00,'Retail Sale Id 660 for 3.06 KG of Cooking Gas @ N720.00','2023-03-01 18:45:07','',''),('1','312',1423,'','6.1','4',0.00,2200.00,'Retail Sale Id 660 for retail product','2023-03-01 18:45:07','',''),('1','312',1424,'','20','3',9000.00,0.00,'Retail Sale Id 661 for 12.50 KG of Cooking Gas @ N720.00','2023-03-01 18:49:46','',''),('1','312',1425,'','6.1','4',0.00,9000.00,'Retail Sale Id 661 for retail product','2023-03-01 18:49:46','',''),('1','312',1426,'','20','3',472122.00,0.00,'Retail Sale Id 662 for 699.44 KG of Cooking Gas @ N675.00','2023-03-01 19:05:30','',''),('1','312',1427,'','6.1','4',0.00,472122.00,'Retail Sale Id 662 for retail product','2023-03-01 19:05:30','',''),('1','312',1428,'','20','3',3556.80,0.00,'Retail Sale Id 663 for 4.94 KG of Cooking Gas @ N720.00','2023-03-01 19:08:42','',''),('1','312',1429,'','6.1','4',0.00,3556.80,'Retail Sale Id 663 for retail product','2023-03-01 19:08:42','',''),('1','312',1430,'','20','3',21600.00,0.00,'Retail Sale Id 664 for 30.00 KG of Cooking Gas @ N720.00','2023-03-01 19:09:22','',''),('1','312',1431,'','6.1','4',0.00,21600.00,'Retail Sale Id 664 for retail product','2023-03-01 19:09:22','',''),('1','312',1432,'','20','3',0.00,0.00,'Sales from shift 24 on 2023-03-01 19:45:32 ','2023-03-01 19:45:32','',''),('1','312',1433,'','6.1','4',0.00,0.00,'Sales from shift 24 on 2023-03-01 19:45:32 ','2023-03-01 19:45:32','',''),('1','312',1434,'','20','3',5000.00,0.00,'Retail Sale Id 665 for 6.94 KG of Cooking Gas @ N720.00','2023-03-02 08:28:18','',''),('1','312',1435,'','6.1','4',0.00,5000.00,'Retail Sale Id 665 for retail product','2023-03-02 08:28:18','',''),('1','312',1436,'','20','3',4320.00,0.00,'Retail Sale Id 666 for 6.00 KG of Cooking Gas @ N720.00','2023-03-02 08:48:11','',''),('1','312',1437,'','6.1','4',0.00,4320.00,'Retail Sale Id 666 for retail product','2023-03-02 08:48:11','',''),('1','312',1438,'','20','3',5040.00,0.00,'Retail Sale Id 667 for 7.00 KG of Cooking Gas @ N720.00','2023-03-02 08:57:31','',''),('1','312',1439,'','6.1','4',0.00,5040.00,'Retail Sale Id 667 for retail product','2023-03-02 08:57:31','',''),('1','312',1440,'','20','3',9000.00,0.00,'Retail Sale Id 668 for 12.50 KG of Cooking Gas @ N720.00','2023-03-02 09:08:51','',''),('1','312',1441,'','6.1','4',0.00,9000.00,'Retail Sale Id 668 for retail product','2023-03-02 09:08:51','',''),('1','312',1442,'','20','3',5040.00,0.00,'Retail Sale Id 669 for 7.00 KG of Cooking Gas @ N720.00','2023-03-02 09:12:15','',''),('1','312',1443,'','6.1','4',0.00,5040.00,'Retail Sale Id 669 for retail product','2023-03-02 09:12:15','',''),('1','312',1444,'','20','3',720.00,0.00,'Retail Sale Id 670 for 1.00 KG of Cooking Gas @ N720.00','2023-03-02 09:35:32','',''),('1','312',1445,'','6.1','4',0.00,720.00,'Retail Sale Id 670 for retail product','2023-03-02 09:35:32','',''),('1','312',1446,'','20','3',9000.00,0.00,'Retail Sale Id 671 for 12.50 KG of Cooking Gas @ N720.00','2023-03-02 10:00:58','',''),('1','312',1447,'','6.1','4',0.00,9000.00,'Retail Sale Id 671 for retail product','2023-03-02 10:00:58','',''),('1','312',1448,'','20','3',2000.00,0.00,'Retail Sale Id 672 for 2.78 KG of Cooking Gas @ N720.00','2023-03-02 10:04:19','',''),('1','312',1449,'','6.1','4',0.00,2000.00,'Retail Sale Id 672 for retail product','2023-03-02 10:04:19','',''),('1','312',1450,'','20','3',2160.00,0.00,'Retail Sale Id 673 for 3.00 KG of Cooking Gas @ N720.00','2023-03-02 10:08:51','',''),('1','312',1451,'','6.1','4',0.00,2160.00,'Retail Sale Id 673 for retail product','2023-03-02 10:08:51','',''),('1','312',1452,'','20','3',9000.00,0.00,'Retail Sale Id 674 for 12.50 KG of Cooking Gas @ N720.00','2023-03-02 11:05:44','',''),('1','312',1453,'','6.1','4',0.00,9000.00,'Retail Sale Id 674 for retail product','2023-03-02 11:05:44','',''),('1','312',1454,'','20','3',1440.00,0.00,'Retail Sale Id 675 for 2.00 KG of Cooking Gas @ N720.00','2023-03-02 11:16:23','',''),('1','312',1455,'','6.1','4',0.00,1440.00,'Retail Sale Id 675 for retail product','2023-03-02 11:16:23','',''),('1','312',1456,'','20','3',2160.00,0.00,'Retail Sale Id 676 for 3.00 KG of Cooking Gas @ N720.00','2023-03-02 11:52:20','',''),('1','312',1457,'','6.1','4',0.00,2160.00,'Retail Sale Id 676 for retail product','2023-03-02 11:52:20','',''),('1','312',1458,'','20','3',2160.00,0.00,'Retail Sale Id 677 for 3.00 KG of Cooking Gas @ N720.00','2023-03-02 12:20:46','',''),('1','312',1459,'','6.1','4',0.00,2160.00,'Retail Sale Id 677 for retail product','2023-03-02 12:20:46','',''),('1','312',1460,'','20','3',2200.00,0.00,'Retail Sale Id 678 for 3.06 KG of Cooking Gas @ N720.00','2023-03-02 12:23:03','',''),('1','312',1461,'','6.1','4',0.00,2200.00,'Retail Sale Id 678 for retail product','2023-03-02 12:23:03','',''),('1','312',1462,'','20','3',7200.00,0.00,'Retail Sale Id 679 for 10.00 KG of Cooking Gas @ N720.00','2023-03-02 12:40:44','',''),('1','312',1463,'','6.1','4',0.00,7200.00,'Retail Sale Id 679 for retail product','2023-03-02 12:40:44','',''),('1','312',1464,'','20','3',3600.00,0.00,'Retail Sale Id 680 for 5.00 KG of Cooking Gas @ N720.00','2023-03-02 12:42:38','',''),('1','312',1465,'','6.1','4',0.00,3600.00,'Retail Sale Id 680 for retail product','2023-03-02 12:42:38','',''),('1','312',1466,'','20','3',7200.00,0.00,'Retail Sale Id 681 for 10.00 KG of Cooking Gas @ N720.00','2023-03-02 13:45:37','',''),('1','312',1467,'','6.1','4',0.00,7200.00,'Retail Sale Id 681 for retail product','2023-03-02 13:45:37','',''),('1','312',1468,'','20','3',4320.00,0.00,'Retail Sale Id 682 for 6.00 KG of Cooking Gas @ N720.00','2023-03-02 13:47:46','',''),('1','312',1469,'','6.1','4',0.00,4320.00,'Retail Sale Id 682 for retail product','2023-03-02 13:47:46','',''),('1','312',1470,'','20','3',3000.00,0.00,'Retail Sale Id 683 for 4.17 KG of Cooking Gas @ N720.00','2023-03-02 14:02:01','',''),('1','312',1471,'','6.1','4',0.00,3000.00,'Retail Sale Id 683 for retail product','2023-03-02 14:02:01','',''),('1','312',1472,'','20','3',9000.00,0.00,'Retail Sale Id 684 for 12.50 KG of Cooking Gas @ N720.00','2023-03-02 15:00:30','',''),('1','312',1473,'','6.1','4',0.00,9000.00,'Retail Sale Id 684 for retail product','2023-03-02 15:00:30','',''),('1','312',1474,'','20','3',4000.00,0.00,'Retail Sale Id 685 for 5.56 KG of Cooking Gas @ N720.00','2023-03-02 15:03:16','',''),('1','312',1475,'','6.1','4',0.00,4000.00,'Retail Sale Id 685 for retail product','2023-03-02 15:03:16','',''),('1','312',1476,'','20','3',9000.00,0.00,'Retail Sale Id 686 for 12.50 KG of Cooking Gas @ N720.00','2023-03-02 15:27:16','',''),('1','312',1477,'','6.1','4',0.00,9000.00,'Retail Sale Id 686 for retail product','2023-03-02 15:27:16','',''),('1','312',1478,'','20','3',4320.00,0.00,'Retail Sale Id 687 for 6.00 KG of Cooking Gas @ N720.00','2023-03-02 15:35:56','',''),('1','312',1479,'','6.1','4',0.00,4320.00,'Retail Sale Id 687 for retail product','2023-03-02 15:35:56','',''),('1','312',1480,'','20','3',5040.00,0.00,'Retail Sale Id 688 for 7.00 KG of Cooking Gas @ N720.00','2023-03-02 15:37:34','',''),('1','312',1481,'','6.1','4',0.00,5040.00,'Retail Sale Id 688 for retail product','2023-03-02 15:37:34','',''),('1','312',1482,'','2','20',271510.00,0.00,'Payment Id 42 for invoice:23, receipt: p o s by AA RANO NIGERIA LTD','2023-03-02 15:58:17','',''),('1','312',1483,'','supplier','1',0.00,271510.00,'Payment Id 42 for invoice:23, receipt: p o s by AA RANO NIGERIA LTD','2023-03-02 15:58:17','',''),('1','312',1484,'','2','19',46958.00,0.00,'Payment Id 40 for invoice:23, receipt: 000 by AA RANO NIGERIA LTD','2023-03-02 15:58:17','',''),('1','312',1485,'','supplier','1',0.00,46958.00,'Payment Id 40 for invoice:23, receipt: 000 by AA RANO NIGERIA LTD','2023-03-02 15:58:17','',''),('1','312',1486,'','20','3',9000.00,0.00,'Retail Sale Id 689 for 12.50 KG of Cooking Gas @ N720.00','2023-03-02 16:09:45','',''),('1','312',1487,'','6.1','4',0.00,9000.00,'Retail Sale Id 689 for retail product','2023-03-02 16:09:45','',''),('1','312',1488,'','20','3',5040.00,0.00,'Retail Sale Id 690 for 7.00 KG of Cooking Gas @ N720.00','2023-03-02 16:13:50','',''),('1','312',1489,'','6.1','4',0.00,5040.00,'Retail Sale Id 690 for retail product','2023-03-02 16:13:50','',''),('1','312',1490,'','20','3',4000.00,0.00,'Retail Sale Id 691 for 5.56 KG of Cooking Gas @ N720.00','2023-03-02 16:34:04','',''),('1','312',1491,'','6.1','4',0.00,4000.00,'Retail Sale Id 691 for retail product','2023-03-02 16:34:04','',''),('1','312',1492,'','20','3',5040.00,0.00,'Retail Sale Id 692 for 7.00 KG of Cooking Gas @ N720.00','2023-03-02 16:43:08','',''),('1','312',1493,'','6.1','4',0.00,5040.00,'Retail Sale Id 692 for retail product','2023-03-02 16:43:08','',''),('1','312',1494,'','20','3',9000.00,0.00,'Retail Sale Id 693 for 12.50 KG of Cooking Gas @ N720.00','2023-03-02 17:01:11','',''),('1','312',1495,'','6.1','4',0.00,9000.00,'Retail Sale Id 693 for retail product','2023-03-02 17:01:11','',''),('1','312',1496,'','20','3',2160.00,0.00,'Retail Sale Id 694 for 3.00 KG of Cooking Gas @ N720.00','2023-03-02 17:35:47','',''),('1','312',1497,'','6.1','4',0.00,2160.00,'Retail Sale Id 694 for retail product','2023-03-02 17:35:47','',''),('1','312',1498,'','20','3',2160.00,0.00,'Retail Sale Id 695 for 3.00 KG of Cooking Gas @ N720.00','2023-03-02 17:38:00','',''),('1','312',1499,'','6.1','4',0.00,2160.00,'Retail Sale Id 695 for retail product','2023-03-02 17:38:00','',''),('1','312',1500,'','20','3',4320.00,0.00,'Retail Sale Id 696 for 6.00 KG of Cooking Gas @ N720.00','2023-03-02 17:51:30','',''),('1','312',1501,'','6.1','4',0.00,4320.00,'Retail Sale Id 696 for retail product','2023-03-02 17:51:30','',''),('1','312',1502,'','20','3',5040.00,0.00,'Retail Sale Id 697 for 7.00 KG of Cooking Gas @ N720.00','2023-03-02 18:06:42','',''),('1','312',1503,'','6.1','4',0.00,5040.00,'Retail Sale Id 697 for retail product','2023-03-02 18:06:42','',''),('1','312',1504,'','20','3',9000.00,0.00,'Retail Sale Id 698 for 12.50 KG of Cooking Gas @ N720.00','2023-03-02 18:15:07','',''),('1','312',1505,'','6.1','4',0.00,9000.00,'Retail Sale Id 698 for retail product','2023-03-02 18:15:07','',''),('1','312',1506,'','20','3',5040.00,0.00,'Retail Sale Id 699 for 7.00 KG of Cooking Gas @ N720.00','2023-03-02 18:16:33','',''),('1','312',1507,'','6.1','4',0.00,5040.00,'Retail Sale Id 699 for retail product','2023-03-02 18:16:33','',''),('1','312',1508,'','20','3',9000.00,0.00,'Retail Sale Id 700 for 12.50 KG of Cooking Gas @ N720.00','2023-03-02 18:23:03','',''),('1','312',1509,'','6.1','4',0.00,9000.00,'Retail Sale Id 700 for retail product','2023-03-02 18:23:03','',''),('1','312',1510,'','20','3',81600.00,0.00,'Retail Sale Id 701 for 120.00 KG of Cooking Gas @ N680.00','2023-03-02 19:06:31','',''),('1','312',1511,'','6.1','4',0.00,81600.00,'Retail Sale Id 701 for retail product','2023-03-02 19:06:31','',''),('1','312',1512,'','20','3',34000.00,0.00,'Retail Sale Id 702 for 50.00 KG of Cooking Gas @ N680.00','2023-03-02 19:07:25','',''),('1','312',1513,'','6.1','4',0.00,34000.00,'Retail Sale Id 702 for retail product','2023-03-02 19:07:25','',''),('1','312',1514,'','20','3',0.00,0.00,'Sales from shift 25 on 2023-03-02 19:30:37 ','2023-03-02 19:30:37','',''),('1','312',1515,'','6.1','4',0.00,0.00,'Sales from shift 25 on 2023-03-02 19:30:37 ','2023-03-02 19:30:37','',''),('1','312',1516,'','20','3',5040.00,0.00,'Retail Sale Id 703 for 7.00 KG of Cooking Gas @ N720.00','2023-03-03 09:22:59','',''),('1','312',1517,'','6.1','4',0.00,5040.00,'Retail Sale Id 703 for retail product','2023-03-03 09:22:59','',''),('1','312',1518,'','20','3',2160.00,0.00,'Retail Sale Id 705 for 3.00 KG of Cooking Gas @ N720.00','2023-03-03 10:18:12','',''),('1','312',1519,'','6.1','4',0.00,2160.00,'Retail Sale Id 705 for retail product','2023-03-03 10:18:12','',''),('1','312',1520,'','20','3',9000.00,0.00,'Retail Sale Id 706 for 12.50 KG of Cooking Gas @ N720.00','2023-03-03 10:56:01','',''),('1','312',1521,'','6.1','4',0.00,9000.00,'Retail Sale Id 706 for retail product','2023-03-03 10:56:01','',''),('1','312',1522,'','20','3',9000.00,0.00,'Retail Sale Id 707 for 12.50 KG of Cooking Gas @ N720.00','2023-03-03 11:24:39','',''),('1','312',1523,'','6.1','4',0.00,9000.00,'Retail Sale Id 707 for retail product','2023-03-03 11:24:39','',''),('1','312',1524,'','20','3',4320.00,0.00,'Retail Sale Id 708 for 6.00 KG of Cooking Gas @ N720.00','2023-03-03 11:27:53','',''),('1','312',1525,'','6.1','4',0.00,4320.00,'Retail Sale Id 708 for retail product','2023-03-03 11:27:53','',''),('1','312',1526,'','20','3',2160.00,0.00,'Retail Sale Id 709 for 3.00 KG of Cooking Gas @ N720.00','2023-03-03 11:45:05','',''),('1','312',1527,'','6.1','4',0.00,2160.00,'Retail Sale Id 709 for retail product','2023-03-03 11:45:05','',''),('1','312',1528,'','20','3',2880.00,0.00,'Retail Sale Id 710 for 4.00 KG of Cooking Gas @ N720.00','2023-03-03 12:00:08','',''),('1','312',1529,'','6.1','4',0.00,2880.00,'Retail Sale Id 710 for retail product','2023-03-03 12:00:08','',''),('1','312',1530,'','20','3',7920.00,0.00,'Retail Sale Id 711 for 11.00 KG of Cooking Gas @ N720.00','2023-03-03 12:04:03','',''),('1','312',1531,'','6.1','4',0.00,7920.00,'Retail Sale Id 711 for retail product','2023-03-03 12:04:03','',''),('1','312',1532,'','20','3',5040.00,0.00,'Retail Sale Id 712 for 7.00 KG of Cooking Gas @ N720.00','2023-03-03 12:22:01','',''),('1','312',1533,'','6.1','4',0.00,5040.00,'Retail Sale Id 712 for retail product','2023-03-03 12:22:01','',''),('1','312',1534,'','20','3',2160.00,0.00,'Retail Sale Id 713 for 3.00 KG of Cooking Gas @ N720.00','2023-03-03 12:42:37','',''),('1','312',1535,'','6.1','4',0.00,2160.00,'Retail Sale Id 713 for retail product','2023-03-03 12:42:37','',''),('1','312',1536,'','20','3',4320.00,0.00,'Retail Sale Id 714 for 6.00 KG of Cooking Gas @ N720.00','2023-03-03 13:33:45','',''),('1','312',1537,'','6.1','4',0.00,4320.00,'Retail Sale Id 714 for retail product','2023-03-03 13:33:45','',''),('1','312',1538,'','20','3',2160.00,0.00,'Retail Sale Id 715 for 3.00 KG of Cooking Gas @ N720.00','2023-03-03 13:44:29','',''),('1','312',1539,'','6.1','4',0.00,2160.00,'Retail Sale Id 715 for retail product','2023-03-03 13:44:29','',''),('1','312',1540,'','20','3',9000.00,0.00,'Retail Sale Id 716 for 12.50 KG of Cooking Gas @ N720.00','2023-03-03 13:56:08','',''),('1','312',1541,'','6.1','4',0.00,9000.00,'Retail Sale Id 716 for retail product','2023-03-03 13:56:08','',''),('1','312',1542,'','20','3',2160.00,0.00,'Retail Sale Id 717 for 3.00 KG of Cooking Gas @ N720.00','2023-03-03 14:09:15','',''),('1','312',1543,'','6.1','4',0.00,2160.00,'Retail Sale Id 717 for retail product','2023-03-03 14:09:15','',''),('1','312',1544,'','20','3',2880.00,0.00,'Retail Sale Id 718 for 4.00 KG of Cooking Gas @ N720.00','2023-03-03 14:22:15','',''),('1','312',1545,'','6.1','4',0.00,2880.00,'Retail Sale Id 718 for retail product','2023-03-03 14:22:15','',''),('1','312',1546,'','2','20',116080.00,0.00,'Payment Id 44 for invoice:24, receipt: p o s by AA RANO NIGERIA LTD','2023-03-03 14:44:16','',''),('1','312',1547,'','supplier','1',0.00,116080.00,'Payment Id 44 for invoice:24, receipt: p o s by AA RANO NIGERIA LTD','2023-03-03 14:44:16','',''),('1','312',1548,'','2','8',115922.00,0.00,'Payment Id 45 for invoice:7, receipt: p o s by AA RANO NIGERIA LTD','2023-03-03 14:44:59','',''),('1','312',1549,'','supplier','1',0.00,115922.00,'Payment Id 45 for invoice:7, receipt: p o s by AA RANO NIGERIA LTD','2023-03-03 14:44:59','',''),('1','312',1550,'','2','20',246960.00,0.00,'Payment Id 47 for invoice:25, receipt: p o s by AA RANO NIGERIA LTD','2023-03-03 14:46:02','',''),('1','312',1551,'','supplier','1',0.00,246960.00,'Payment Id 47 for invoice:25, receipt: p o s by AA RANO NIGERIA LTD','2023-03-03 14:46:02','',''),('1','312',1552,'','20','3',2880.00,0.00,'Retail Sale Id 719 for 4.00 KG of Cooking Gas @ N720.00','2023-03-03 14:49:55','',''),('1','312',1553,'','6.1','4',0.00,2880.00,'Retail Sale Id 719 for retail product','2023-03-03 14:49:55','',''),('1','312',1554,'','20','3',1440.00,0.00,'Retail Sale Id 720 for 2.00 KG of Cooking Gas @ N720.00','2023-03-03 15:14:28','',''),('1','312',1555,'','6.1','4',0.00,1440.00,'Retail Sale Id 720 for retail product','2023-03-03 15:14:28','',''),('1','312',1556,'','20','3',1500.00,0.00,'Retail Sale Id 721 for 2.08 KG of Cooking Gas @ N720.00','2023-03-03 15:40:32','',''),('1','312',1557,'','6.1','4',0.00,1500.00,'Retail Sale Id 721 for retail product','2023-03-03 15:40:32','',''),('1','312',1558,'','20','3',5040.00,0.00,'Retail Sale Id 722 for 7.00 KG of Cooking Gas @ N720.00','2023-03-03 15:48:07','',''),('1','312',1559,'','6.1','4',0.00,5040.00,'Retail Sale Id 722 for retail product','2023-03-03 15:48:07','',''),('1','312',1560,'','20','3',5040.00,0.00,'Retail Sale Id 723 for 7.00 KG of Cooking Gas @ N720.00','2023-03-03 15:50:40','',''),('1','312',1561,'','6.1','4',0.00,5040.00,'Retail Sale Id 723 for retail product','2023-03-03 15:50:40','',''),('1','312',1562,'','20','3',9000.00,0.00,'Retail Sale Id 724 for 12.50 KG of Cooking Gas @ N720.00','2023-03-03 16:03:10','',''),('1','312',1563,'','6.1','4',0.00,9000.00,'Retail Sale Id 724 for retail product','2023-03-03 16:03:10','',''),('1','312',1564,'','20','3',4320.00,0.00,'Retail Sale Id 725 for 6.00 KG of Cooking Gas @ N720.00','2023-03-03 16:05:53','',''),('1','312',1565,'','6.1','4',0.00,4320.00,'Retail Sale Id 725 for retail product','2023-03-03 16:05:53','',''),('1','312',1566,'','20','3',7200.00,0.00,'Retail Sale Id 726 for 10.00 KG of Cooking Gas @ N720.00','2023-03-03 16:34:41','',''),('1','312',1567,'','6.1','4',0.00,7200.00,'Retail Sale Id 726 for retail product','2023-03-03 16:34:41','',''),('1','312',1568,'','20','3',2500.00,0.00,'Retail Sale Id 727 for 3.47 KG of Cooking Gas @ N720.00','2023-03-03 16:36:42','',''),('1','312',1569,'','6.1','4',0.00,2500.00,'Retail Sale Id 727 for retail product','2023-03-03 16:36:42','',''),('1','312',1570,'','20','3',7200.00,0.00,'Retail Sale Id 728 for 10.00 KG of Cooking Gas @ N720.00','2023-03-03 16:38:54','',''),('1','312',1571,'','6.1','4',0.00,7200.00,'Retail Sale Id 728 for retail product','2023-03-03 16:38:54','',''),('1','312',1572,'','20','3',3600.00,0.00,'Retail Sale Id 729 for 5.00 KG of Cooking Gas @ N720.00','2023-03-03 16:42:56','',''),('1','312',1573,'','6.1','4',0.00,3600.00,'Retail Sale Id 729 for retail product','2023-03-03 16:42:56','',''),('1','312',1574,'','20','3',5040.00,0.00,'Retail Sale Id 730 for 7.00 KG of Cooking Gas @ N720.00','2023-03-03 16:52:27','',''),('1','312',1575,'','6.1','4',0.00,5040.00,'Retail Sale Id 730 for retail product','2023-03-03 16:52:27','',''),('1','312',1576,'','20','3',40800.00,0.00,'Retail Sale Id 731 for 60.00 KG of Cooking Gas @ N680.00','2023-03-03 19:19:23','',''),('1','312',1577,'','6.1','4',0.00,40800.00,'Retail Sale Id 731 for retail product','2023-03-03 19:19:23','',''),('1','312',1578,'','20','3',40800.00,0.00,'Retail Sale Id 732 for 60.00 KG of Cooking Gas @ N680.00','2023-03-03 19:20:07','',''),('1','312',1579,'','6.1','4',0.00,40800.00,'Retail Sale Id 732 for retail product','2023-03-03 19:20:07','',''),('1','312',1580,'','20','3',16200.00,0.00,'Retail Sale Id 733 for 22.50 KG of Cooking Gas @ N720.00','2023-03-03 19:22:12','',''),('1','312',1581,'','6.1','4',0.00,16200.00,'Retail Sale Id 733 for retail product','2023-03-03 19:22:12','',''),('1','312',1582,'','20','3',0.00,0.00,'Sales from shift 26 on 2023-03-03 19:33:38 ','2023-03-03 19:33:38','',''),('1','312',1583,'','6.1','4',0.00,0.00,'Sales from shift 26 on 2023-03-03 19:33:38 ','2023-03-03 19:33:38','',''),('1','312',1584,'','20','3',4320.00,0.00,'Retail Sale Id 734 for 6.00 KG of Cooking Gas @ N720.00','2023-03-04 08:00:22','',''),('1','312',1585,'','6.1','4',0.00,4320.00,'Retail Sale Id 734 for retail product','2023-03-04 08:00:22','',''),('1','312',1586,'','20','3',2880.00,0.00,'Retail Sale Id 736 for 4.00 KG of Cooking Gas @ N720.00','2023-03-04 08:09:46','',''),('1','312',1587,'','6.1','4',0.00,2880.00,'Retail Sale Id 736 for retail product','2023-03-04 08:09:47','',''),('1','312',1588,'','20','3',7000.00,0.00,'Retail Sale Id 737 for 9.72 KG of Cooking Gas @ N720.00','2023-03-04 08:19:24','',''),('1','312',1589,'','6.1','4',0.00,7000.00,'Retail Sale Id 737 for retail product','2023-03-04 08:19:24','',''),('1','312',1590,'','20','3',1440.00,0.00,'Retail Sale Id 738 for 2.00 KG of Cooking Gas @ N720.00','2023-03-04 08:23:53','',''),('1','312',1591,'','6.1','4',0.00,1440.00,'Retail Sale Id 738 for retail product','2023-03-04 08:23:53','',''),('1','312',1592,'','20','3',1440.00,0.00,'Retail Sale Id 739 for 2.00 KG of Cooking Gas @ N720.00','2023-03-04 08:26:02','',''),('1','312',1593,'','6.1','4',0.00,1440.00,'Retail Sale Id 739 for retail product','2023-03-04 08:26:02','',''),('1','312',1594,'','20','3',4320.00,0.00,'Retail Sale Id 740 for 6.00 KG of Cooking Gas @ N720.00','2023-03-04 08:42:05','',''),('1','312',1595,'','6.1','4',0.00,4320.00,'Retail Sale Id 740 for retail product','2023-03-04 08:42:05','',''),('1','312',1596,'','20','3',4320.00,0.00,'Retail Sale Id 741 for 6.00 KG of Cooking Gas @ N720.00','2023-03-04 08:50:01','',''),('1','312',1597,'','6.1','4',0.00,4320.00,'Retail Sale Id 741 for retail product','2023-03-04 08:50:01','',''),('1','312',1598,'','20','3',3600.00,0.00,'Retail Sale Id 742 for 5.00 KG of Cooking Gas @ N720.00','2023-03-04 09:03:47','',''),('1','312',1599,'','6.1','4',0.00,3600.00,'Retail Sale Id 742 for retail product','2023-03-04 09:03:47','',''),('1','312',1600,'','20','3',9000.00,0.00,'Retail Sale Id 743 for 12.50 KG of Cooking Gas @ N720.00','2023-03-04 09:29:10','',''),('1','312',1601,'','6.1','4',0.00,9000.00,'Retail Sale Id 743 for retail product','2023-03-04 09:29:10','',''),('1','312',1602,'','20','3',4000.00,0.00,'Retail Sale Id 744 for 5.56 KG of Cooking Gas @ N720.00','2023-03-04 09:33:25','',''),('1','312',1603,'','6.1','4',0.00,4000.00,'Retail Sale Id 744 for retail product','2023-03-04 09:33:25','',''),('1','312',1604,'','20','3',4350.00,0.00,'Retail Sale Id 745 for 6.04 KG of Cooking Gas @ N720.00','2023-03-04 09:36:03','',''),('1','312',1605,'','6.1','4',0.00,4350.00,'Retail Sale Id 745 for retail product','2023-03-04 09:36:03','',''),('1','312',1606,'','20','3',7920.00,0.00,'Retail Sale Id 746 for 11.00 KG of Cooking Gas @ N720.00','2023-03-04 09:43:38','',''),('1','312',1607,'','6.1','4',0.00,7920.00,'Retail Sale Id 746 for retail product','2023-03-04 09:43:38','',''),('1','312',1608,'','20','3',9000.00,0.00,'Retail Sale Id 747 for 12.50 KG of Cooking Gas @ N720.00','2023-03-04 09:47:59','',''),('1','312',1609,'','6.1','4',0.00,9000.00,'Retail Sale Id 747 for retail product','2023-03-04 09:47:59','',''),('1','312',1610,'','20','3',9000.00,0.00,'Retail Sale Id 748 for 12.50 KG of Cooking Gas @ N720.00','2023-03-04 09:59:46','',''),('1','312',1611,'','6.1','4',0.00,9000.00,'Retail Sale Id 748 for retail product','2023-03-04 09:59:46','',''),('1','312',1612,'','20','3',9000.00,0.00,'Retail Sale Id 749 for 12.50 KG of Cooking Gas @ N720.00','2023-03-04 10:15:51','',''),('1','312',1613,'','6.1','4',0.00,9000.00,'Retail Sale Id 749 for retail product','2023-03-04 10:15:51','',''),('1','312',1614,'','20','3',129200.00,0.00,'Retail Sale Id 750 for 190.00 KG of Cooking Gas @ N680.00','2023-03-04 10:16:47','',''),('1','312',1615,'','6.1','4',0.00,129200.00,'Retail Sale Id 750 for retail product','2023-03-04 10:16:47','',''),('1','312',1616,'','20','3',5040.00,0.00,'Retail Sale Id 751 for 7.00 KG of Cooking Gas @ N720.00','2023-03-04 10:25:52','',''),('1','312',1617,'','6.1','4',0.00,5040.00,'Retail Sale Id 751 for retail product','2023-03-04 10:25:52','',''),('1','312',1618,'','20','3',7200.00,0.00,'Retail Sale Id 752 for 10.00 KG of Cooking Gas @ N720.00','2023-03-04 10:38:42','',''),('1','312',1619,'','6.1','4',0.00,7200.00,'Retail Sale Id 752 for retail product','2023-03-04 10:38:42','',''),('1','312',1620,'','20','3',2160.00,0.00,'Retail Sale Id 753 for 3.00 KG of Cooking Gas @ N720.00','2023-03-04 10:51:55','',''),('1','312',1621,'','6.1','4',0.00,2160.00,'Retail Sale Id 753 for retail product','2023-03-04 10:51:55','',''),('1','312',1622,'','20','3',3000.00,0.00,'Retail Sale Id 754 for 4.17 KG of Cooking Gas @ N720.00','2023-03-04 10:57:22','',''),('1','312',1623,'','6.1','4',0.00,3000.00,'Retail Sale Id 754 for retail product','2023-03-04 10:57:22','',''),('1','312',1624,'','20','3',5100.00,0.00,'Retail Sale Id 755 for 7.08 KG of Cooking Gas @ N720.00','2023-03-04 11:01:52','',''),('1','312',1625,'','6.1','4',0.00,5100.00,'Retail Sale Id 755 for retail product','2023-03-04 11:01:52','',''),('1','312',1626,'','20','3',3600.00,0.00,'Retail Sale Id 756 for 5.00 KG of Cooking Gas @ N720.00','2023-03-04 11:27:36','',''),('1','312',1627,'','6.1','4',0.00,3600.00,'Retail Sale Id 756 for retail product','2023-03-04 11:27:36','',''),('1','312',1628,'','20','3',2200.00,0.00,'Retail Sale Id 757 for 3.06 KG of Cooking Gas @ N720.00','2023-03-04 11:50:37','',''),('1','312',1629,'','6.1','4',0.00,2200.00,'Retail Sale Id 757 for retail product','2023-03-04 11:50:37','',''),('1','312',1630,'','20','3',2880.00,0.00,'Retail Sale Id 758 for 4.00 KG of Cooking Gas @ N720.00','2023-03-04 12:02:20','',''),('1','312',1631,'','6.1','4',0.00,2880.00,'Retail Sale Id 758 for retail product','2023-03-04 12:02:20','',''),('1','312',1632,'','20','3',11520.00,0.00,'Retail Sale Id 759 for 16.00 KG of Cooking Gas @ N720.00','2023-03-04 12:19:28','',''),('1','312',1633,'','6.1','4',0.00,11520.00,'Retail Sale Id 759 for retail product','2023-03-04 12:19:28','',''),('1','312',1634,'','20','3',1591.20,0.00,'Retail Sale Id 760 for 2.21 KG of Cooking Gas @ N720.00','2023-03-04 12:29:30','',''),('1','312',1635,'','6.1','4',0.00,1591.20,'Retail Sale Id 760 for retail product','2023-03-04 12:29:30','',''),('1','312',1636,'','24','2',0.00,9885.31,'Purchase Id 3 for 16.67 litters of Cooking Gas - LPG from AA RANO NIGERIA LTD','2023-03-04 12:32:06','',''),('1','312',1637,'','supplier','1',9885.31,0.00,'Purchase Id 3 for 16.67 litters of Cooking Gas - LPG from AA RANO NIGERIA LTD','2023-03-04 12:32:06','',''),('1','312',1638,'','20','3',12002.40,0.00,'Retail Sale Id 761 for 16.67 KG of Cooking Gas @ N720.00','2023-03-04 12:34:58','',''),('1','312',1639,'','6.1','4',0.00,12002.40,'Retail Sale Id 761 for retail product','2023-03-04 12:34:58','',''),('1','312',1640,'','20','3',0.00,0.00,'Sales from shift 27 on 2023-03-04 12:49:44 ','2023-03-04 12:49:44','',''),('1','312',1641,'','6.1','4',0.00,0.00,'Sales from shift 27 on 2023-03-04 12:49:44 ','2023-03-04 12:49:44','',''),('1','312',1642,'','2','19',59940.00,0.00,'Payment Id 11 for invoice:10, receipt: 000 by AA RANO NIGERIA LTD','2023-03-06 13:00:08','',''),('1','312',1643,'','supplier','1',0.00,59940.00,'Payment Id 11 for invoice:10, receipt: 000 by AA RANO NIGERIA LTD','2023-03-06 13:00:08','',''),('1','312',1644,'','2','19',166639.00,0.00,'Payment Id 31 for invoice:20, receipt: 000 by AA RANO NIGERIA LTD','2023-03-06 13:00:43','',''),('1','312',1645,'','supplier','1',0.00,166639.00,'Payment Id 31 for invoice:20, receipt: 000 by AA RANO NIGERIA LTD','2023-03-06 13:00:43','',''),('1','312',1646,'','2','19',343378.00,0.00,'Payment Id 34 for invoice:22, receipt: 000 by AA RANO NIGERIA LTD','2023-03-06 13:01:08','',''),('1','312',1647,'','supplier','1',0.00,343378.00,'Payment Id 34 for invoice:22, receipt: 000 by AA RANO NIGERIA LTD','2023-03-06 13:01:08','',''),('1','312',1648,'','2','19',245039.00,0.00,'Payment Id 41 for invoice:23, receipt: 000 by AA RANO NIGERIA LTD','2023-03-06 13:01:38','',''),('1','312',1649,'','supplier','1',0.00,245039.00,'Payment Id 41 for invoice:23, receipt: 000 by AA RANO NIGERIA LTD','2023-03-06 13:01:38','',''),('1','312',1650,'','2','8',8320.00,0.00,'Payment Id 48 for invoice:25, receipt: p o s by AA RANO NIGERIA LTD','2023-03-06 13:06:05','',''),('1','312',1651,'','supplier','1',0.00,8320.00,'Payment Id 48 for invoice:25, receipt: p o s by AA RANO NIGERIA LTD','2023-03-06 13:06:05','',''),('1','312',1652,'','2','20',187190.00,0.00,'Payment Id 50 for invoice:26, receipt: p o s by AA RANO NIGERIA LTD','2023-03-07 11:59:51','',''),('1','312',1653,'','supplier','1',0.00,187190.00,'Payment Id 50 for invoice:26, receipt: p o s by AA RANO NIGERIA LTD','2023-03-07 11:59:51','',''),('1','312',1654,'','2','20',267080.00,0.00,'Payment Id 51 for invoice:27, receipt: p o s by AA RANO NIGERIA LTD','2023-03-07 12:00:25','',''),('1','312',1655,'','supplier','1',0.00,267080.00,'Payment Id 51 for invoice:27, receipt: p o s by AA RANO NIGERIA LTD','2023-03-07 12:00:25','',''),('1','312',1656,'','24','2',0.00,3294000.00,'Purchase Id 4 for 5,400.00 litters of Cooking Gas - LPG from AA RANO NIGERIA LTD','2023-03-08 08:55:07','',''),('1','312',1657,'','supplier','1',3294000.00,0.00,'Purchase Id 4 for 5,400.00 litters of Cooking Gas - LPG from AA RANO NIGERIA LTD','2023-03-08 08:55:07','',''),('1','312',1658,'','20','3',7920.00,0.00,'Retail Sale Id 762 for 11.00 KG of Cooking Gas @ N720.00','2023-03-08 09:06:37','',''),('1','312',1659,'','6.1','4',0.00,7920.00,'Retail Sale Id 762 for retail product','2023-03-08 09:06:37','',''),('1','312',1660,'','20','3',2160.00,0.00,'Retail Sale Id 763 for 3.00 KG of Cooking Gas @ N720.00','2023-03-08 09:13:12','',''),('1','312',1661,'','6.1','4',0.00,2160.00,'Retail Sale Id 763 for retail product','2023-03-08 09:13:12','',''),('1','312',1662,'','20','3',9000.00,0.00,'Retail Sale Id 764 for 12.50 KG of Cooking Gas @ N720.00','2023-03-08 09:14:40','',''),('1','312',1663,'','6.1','4',0.00,9000.00,'Retail Sale Id 764 for retail product','2023-03-08 09:14:40','',''),('1','312',1664,'','20','3',7200.00,0.00,'Retail Sale Id 765 for 10.00 KG of Cooking Gas @ N720.00','2023-03-08 12:48:10','',''),('1','312',1665,'','6.1','4',0.00,7200.00,'Retail Sale Id 765 for retail product','2023-03-08 12:48:10','',''),('1','312',1666,'','20','3',9000.00,0.00,'Retail Sale Id 766 for 12.50 KG of Cooking Gas @ N720.00','2023-03-08 12:52:46','',''),('1','312',1667,'','6.1','4',0.00,9000.00,'Retail Sale Id 766 for retail product','2023-03-08 12:52:46','',''),('1','312',1668,'','20','3',4320.00,0.00,'Retail Sale Id 767 for 6.00 KG of Cooking Gas @ N720.00','2023-03-08 12:58:19','',''),('1','312',1669,'','6.1','4',0.00,4320.00,'Retail Sale Id 767 for retail product','2023-03-08 12:58:19','',''),('1','312',1670,'','20','3',9000.00,0.00,'Retail Sale Id 768 for 12.50 KG of Cooking Gas @ N720.00','2023-03-08 13:01:10','',''),('1','312',1671,'','6.1','4',0.00,9000.00,'Retail Sale Id 768 for retail product','2023-03-08 13:01:10','',''),('1','312',1672,'','20','3',172462.50,0.00,'Retail Sale Id 769 for 255.50 KG of Cooking Gas @ N675.00','2023-03-08 13:13:36','',''),('1','312',1673,'','6.1','4',0.00,172462.50,'Retail Sale Id 769 for retail product','2023-03-08 13:13:36','',''),('1','312',1674,'','20','3',2160.00,0.00,'Retail Sale Id 770 for 3.00 KG of Cooking Gas @ N720.00','2023-03-08 13:14:54','',''),('1','312',1675,'','6.1','4',0.00,2160.00,'Retail Sale Id 770 for retail product','2023-03-08 13:14:54','',''),('1','312',1676,'','20','3',2880.00,0.00,'Retail Sale Id 771 for 4.00 KG of Cooking Gas @ N720.00','2023-03-08 13:15:45','',''),('1','312',1677,'','6.1','4',0.00,2880.00,'Retail Sale Id 771 for retail product','2023-03-08 13:15:45','',''),('1','312',1678,'','20','3',1440.00,0.00,'Retail Sale Id 772 for 2.00 KG of Cooking Gas @ N720.00','2023-03-08 13:16:48','',''),('1','312',1679,'','6.1','4',0.00,1440.00,'Retail Sale Id 772 for retail product','2023-03-08 13:16:48','',''),('1','312',1680,'','20','3',4320.00,0.00,'Retail Sale Id 773 for 6.00 KG of Cooking Gas @ N720.00','2023-03-08 13:17:54','',''),('1','312',1681,'','6.1','4',0.00,4320.00,'Retail Sale Id 773 for retail product','2023-03-08 13:17:54','',''),('1','312',1682,'','20','3',20400.00,0.00,'Retail Sale Id 774 for 30.00 KG of Cooking Gas @ N680.00','2023-03-08 13:41:30','',''),('1','312',1683,'','6.1','4',0.00,20400.00,'Retail Sale Id 774 for retail product','2023-03-08 13:41:30','',''),('1','312',1684,'','20','3',4320.00,0.00,'Retail Sale Id 775 for 6.00 KG of Cooking Gas @ N720.00','2023-03-08 14:21:49','',''),('1','312',1685,'','6.1','4',0.00,4320.00,'Retail Sale Id 775 for retail product','2023-03-08 14:21:49','',''),('1','312',1686,'','20','3',9000.00,0.00,'Retail Sale Id 776 for 12.50 KG of Cooking Gas @ N720.00','2023-03-08 14:59:20','',''),('1','312',1687,'','6.1','4',0.00,9000.00,'Retail Sale Id 776 for retail product','2023-03-08 14:59:20','',''),('1','312',1688,'','20','3',4320.00,0.00,'Retail Sale Id 777 for 6.00 KG of Cooking Gas @ N720.00','2023-03-08 15:03:08','',''),('1','312',1689,'','6.1','4',0.00,4320.00,'Retail Sale Id 777 for retail product','2023-03-08 15:03:08','',''),('1','312',1690,'','6.1','4',0.00,4320.00,'Retail Sale Id 777 for retail product','2023-03-08 15:03:08','',''),('1','312',1691,'','20','3',2160.00,0.00,'Retail Sale Id 779 for 3.00 KG of Cooking Gas @ N720.00','2023-03-08 15:06:19','',''),('1','312',1692,'','6.1','4',0.00,2160.00,'Retail Sale Id 779 for retail product','2023-03-08 15:06:19','',''),('1','312',1693,'','20','3',7200.00,0.00,'Retail Sale Id 780 for 10.00 KG of Cooking Gas @ N720.00','2023-03-08 15:23:43','',''),('1','312',1694,'','6.1','4',0.00,7200.00,'Retail Sale Id 780 for retail product','2023-03-08 15:23:43','',''),('1','312',1695,'','20','3',2400.00,0.00,'Retail Sale Id 786 for 3.33 KG of Cooking Gas @ N720.00','2023-03-08 16:25:56','',''),('1','312',1696,'','6.1','4',0.00,2400.00,'Retail Sale Id 786 for retail product','2023-03-08 16:25:56','',''),('1','312',1697,'','20','3',4000.00,0.00,'Retail Sale Id 787 for 5.56 KG of Cooking Gas @ N720.00','2023-03-08 16:31:50','',''),('1','312',1698,'','6.1','4',0.00,4000.00,'Retail Sale Id 787 for retail product','2023-03-08 16:31:50','',''),('1','312',1699,'','20','3',5040.00,0.00,'Retail Sale Id 781 for 7.00 KG of Cooking Gas @ N720.00','2023-03-08 16:42:04','',''),('1','312',1700,'','6.1','4',0.00,5040.00,'Retail Sale Id 781 for retail product','2023-03-08 16:42:04','',''),('1','312',1701,'','20','3',2160.00,0.00,'Retail Sale Id 788 for 3.00 KG of Cooking Gas @ N720.00','2023-03-08 16:46:45','',''),('1','312',1702,'','6.1','4',0.00,2160.00,'Retail Sale Id 788 for retail product','2023-03-08 16:46:45','',''),('1','312',1703,'','20','3',2880.00,0.00,'Retail Sale Id 789 for 4.00 KG of Cooking Gas @ N720.00','2023-03-08 16:50:20','',''),('1','312',1704,'','6.1','4',0.00,2880.00,'Retail Sale Id 789 for retail product','2023-03-08 16:50:20','',''),('1','312',1705,'','20','3',9000.00,0.00,'Retail Sale Id 790 for 12.50 KG of Cooking Gas @ N720.00','2023-03-08 17:22:10','',''),('1','312',1706,'','6.1','4',0.00,9000.00,'Retail Sale Id 790 for retail product','2023-03-08 17:22:10','',''),('1','312',1707,'','20','3',2160.00,0.00,'Retail Sale Id 791 for 3.00 KG of Cooking Gas @ N720.00','2023-03-08 17:47:30','',''),('1','312',1708,'','6.1','4',0.00,2160.00,'Retail Sale Id 791 for retail product','2023-03-08 17:47:30','',''),('1','312',1709,'','20','3',2160.00,0.00,'Retail Sale Id 792 for 3.00 KG of Cooking Gas @ N720.00','2023-03-08 17:57:30','',''),('1','312',1710,'','6.1','4',0.00,2160.00,'Retail Sale Id 792 for retail product','2023-03-08 17:57:30','',''),('1','312',1711,'','20','3',0.00,2160.00,'Return of Retail Sale Id 792 for products','2023-03-08 18:02:47','',''),('1','312',1712,'','','',2160.00,0.00,'Return of Retail Sale Id 792 for products','2023-03-08 18:02:47','',''),('1','312',1713,'','20','3',11520.00,0.00,'Retail Sale Id 793 for 16.00 KG of Cooking Gas @ N720.00','2023-03-08 18:05:39','',''),('1','312',1714,'','6.1','4',0.00,11520.00,'Retail Sale Id 793 for retail product','2023-03-08 18:05:39','',''),('1','312',1715,'','20','3',0.00,20400.00,'Return of Retail Sale Id 774 for products','2023-03-08 18:19:37','',''),('1','312',1716,'','','',20400.00,0.00,'Return of Retail Sale Id 774 for products','2023-03-08 18:19:37','',''),('1','312',1717,'','20','3',205875.00,0.00,'Retail Sale Id 794 for 305.00 KG of Cooking Gas @ N675.00','2023-03-08 18:20:38','',''),('1','312',1718,'','6.1','4',0.00,205875.00,'Retail Sale Id 794 for retail product','2023-03-08 18:20:38','',''),('1','312',1719,'','20','3',5313.60,0.00,'Retail Sale Id 795 for 7.38 KG of Cooking Gas @ N720.00','2023-03-08 18:34:37','',''),('1','312',1720,'','6.1','4',0.00,5313.60,'Retail Sale Id 795 for retail product','2023-03-08 18:34:37','',''),('1','312',1721,'','20','3',0.00,0.00,'Sales from shift 28 on 2023-03-09 07:28:17 ','2023-03-09 07:28:17','',''),('1','312',1722,'','6.1','4',0.00,0.00,'Sales from shift 28 on 2023-03-09 07:28:17 ','2023-03-09 07:28:17','',''),('1','312',1723,'','20','3',2900.00,0.00,'Retail Sale Id 796 for 4.03 KG of Cooking Gas @ N720.00','2023-03-09 07:55:54','',''),('1','312',1724,'','6.1','4',0.00,2900.00,'Retail Sale Id 796 for retail product','2023-03-09 07:55:54','',''),('1','312',1725,'','20','3',5040.00,0.00,'Retail Sale Id 797 for 7.00 KG of Cooking Gas @ N720.00','2023-03-09 08:23:06','',''),('1','312',1726,'','6.1','4',0.00,5040.00,'Retail Sale Id 797 for retail product','2023-03-09 08:23:06','',''),('1','312',1727,'','20','3',720.00,0.00,'Retail Sale Id 798 for 1.00 KG of Cooking Gas @ N720.00','2023-03-09 08:29:41','',''),('1','312',1728,'','6.1','4',0.00,720.00,'Retail Sale Id 798 for retail product','2023-03-09 08:29:41','',''),('1','312',1729,'','20','3',0.00,720.00,'Return of Retail Sale Id 798 for products','2023-03-09 08:33:25','',''),('1','312',1730,'','','',720.00,0.00,'Return of Retail Sale Id 798 for products','2023-03-09 08:33:25','',''),('1','312',1731,'','20','3',1000.00,0.00,'Retail Sale Id 799 for 1.39 KG of Cooking Gas @ N720.00','2023-03-09 08:34:05','',''),('1','312',1732,'','6.1','4',0.00,1000.00,'Retail Sale Id 799 for retail product','2023-03-09 08:34:05','',''),('1','312',1733,'','20','3',4350.00,0.00,'Retail Sale Id 800 for 6.04 KG of Cooking Gas @ N720.00','2023-03-09 09:31:14','',''),('1','312',1734,'','6.1','4',0.00,4350.00,'Retail Sale Id 800 for retail product','2023-03-09 09:31:14','',''),('1','312',1735,'','20','3',2160.00,0.00,'Retail Sale Id 801 for 3.00 KG of Cooking Gas @ N720.00','2023-03-09 10:07:19','',''),('1','312',1736,'','6.1','4',0.00,2160.00,'Retail Sale Id 801 for retail product','2023-03-09 10:07:19','',''),('1','312',1737,'','20','3',40800.00,0.00,'Retail Sale Id 802 for 60.00 KG of Cooking Gas @ N680.00','2023-03-09 10:17:07','',''),('1','312',1738,'','6.1','4',0.00,40800.00,'Retail Sale Id 802 for retail product','2023-03-09 10:17:07','',''),('1','312',1739,'','20','3',9000.00,0.00,'Retail Sale Id 803 for 12.50 KG of Cooking Gas @ N720.00','2023-03-09 12:43:05','',''),('1','312',1740,'','6.1','4',0.00,9000.00,'Retail Sale Id 803 for retail product','2023-03-09 12:43:05','',''),('1','312',1741,'','20','3',5040.00,0.00,'Retail Sale Id 804 for 7.00 KG of Cooking Gas @ N720.00','2023-03-09 12:44:20','',''),('1','312',1742,'','6.1','4',0.00,5040.00,'Retail Sale Id 804 for retail product','2023-03-09 12:44:20','',''),('1','312',1743,'','20','3',2160.00,0.00,'Retail Sale Id 805 for 3.00 KG of Cooking Gas @ N720.00','2023-03-09 13:07:23','',''),('1','312',1744,'','6.1','4',0.00,2160.00,'Retail Sale Id 805 for retail product','2023-03-09 13:07:23','',''),('1','312',1745,'','20','3',9000.00,0.00,'Retail Sale Id 807 for 12.50 KG of Cooking Gas @ N720.00','2023-03-09 13:58:39','',''),('1','312',1746,'','6.1','4',0.00,9000.00,'Retail Sale Id 807 for retail product','2023-03-09 13:58:39','',''),('1','312',1747,'','20','3',3600.00,0.00,'Retail Sale Id 808 for 5.00 KG of Cooking Gas @ N720.00','2023-03-09 15:01:48','',''),('1','312',1748,'','6.1','4',0.00,3600.00,'Retail Sale Id 808 for retail product','2023-03-09 15:01:48','',''),('1','312',1749,'','20','3',3600.00,0.00,'Retail Sale Id 809 for 5.00 KG of Cooking Gas @ N720.00','2023-03-09 15:02:43','',''),('1','312',1750,'','6.1','4',0.00,3600.00,'Retail Sale Id 809 for retail product','2023-03-09 15:02:43','',''),('1','312',1751,'','20','3',4003.20,0.00,'Retail Sale Id 810 for 5.56 KG of Cooking Gas @ N720.00','2023-03-09 15:36:31','',''),('1','312',1752,'','6.1','4',0.00,4003.20,'Retail Sale Id 810 for retail product','2023-03-09 15:36:31','',''),('1','312',1753,'','20','3',9000.00,0.00,'Retail Sale Id 811 for 12.50 KG of Cooking Gas @ N720.00','2023-03-09 15:37:33','',''),('1','312',1754,'','6.1','4',0.00,9000.00,'Retail Sale Id 811 for retail product','2023-03-09 15:37:33','',''),('1','312',1755,'','20','3',4320.00,0.00,'Retail Sale Id 812 for 6.00 KG of Cooking Gas @ N720.00','2023-03-09 16:13:47','',''),('1','312',1756,'','6.1','4',0.00,4320.00,'Retail Sale Id 812 for retail product','2023-03-09 16:13:48','',''),('1','312',1757,'','20','3',3600.00,0.00,'Retail Sale Id 813 for 5.00 KG of Cooking Gas @ N720.00','2023-03-09 16:29:25','',''),('1','312',1758,'','6.1','4',0.00,3600.00,'Retail Sale Id 813 for retail product','2023-03-09 16:29:25','',''),('1','312',1759,'','20','3',9000.00,0.00,'Retail Sale Id 814 for 12.50 KG of Cooking Gas @ N720.00','2023-03-09 17:12:36','',''),('1','312',1760,'','6.1','4',0.00,9000.00,'Retail Sale Id 814 for retail product','2023-03-09 17:12:36','',''),('1','312',1761,'','20','3',5040.00,0.00,'Retail Sale Id 815 for 7.00 KG of Cooking Gas @ N720.00','2023-03-09 17:45:53','',''),('1','312',1762,'','6.1','4',0.00,5040.00,'Retail Sale Id 815 for retail product','2023-03-09 17:45:53','',''),('1','312',1763,'','20','3',3600.00,0.00,'Retail Sale Id 816 for 5.00 KG of Cooking Gas @ N720.00','2023-03-09 17:49:00','',''),('1','312',1764,'','6.1','4',0.00,3600.00,'Retail Sale Id 816 for retail product','2023-03-09 17:49:00','',''),('1','312',1765,'','20','3',14400.00,0.00,'Retail Sale Id 817 for 20.00 KG of Cooking Gas @ N720.00','2023-03-09 17:55:36','',''),('1','312',1766,'','6.1','4',0.00,14400.00,'Retail Sale Id 817 for retail product','2023-03-09 17:55:36','',''),('1','312',1767,'','20','3',4320.00,0.00,'Retail Sale Id 818 for 6.00 KG of Cooking Gas @ N720.00','2023-03-09 18:07:06','',''),('1','312',1768,'','6.1','4',0.00,4320.00,'Retail Sale Id 818 for retail product','2023-03-09 18:07:06','',''),('1','312',1769,'','20','3',1440.00,0.00,'Retail Sale Id 819 for 2.00 KG of Cooking Gas @ N720.00','2023-03-09 18:23:30','',''),('1','312',1770,'','6.1','4',0.00,1440.00,'Retail Sale Id 819 for retail product','2023-03-09 18:23:30','',''),('1','312',1771,'','20','3',4320.00,0.00,'Retail Sale Id 820 for 6.00 KG of Cooking Gas @ N720.00','2023-03-09 18:28:32','',''),('1','312',1772,'','6.1','4',0.00,4320.00,'Retail Sale Id 820 for retail product','2023-03-09 18:28:32','',''),('1','312',1773,'','20','3',0.00,0.00,'Sales from shift 29 on 2023-03-09 19:12:40 ','2023-03-09 19:12:40','',''),('1','312',1774,'','6.1','4',0.00,0.00,'Sales from shift 29 on 2023-03-09 19:12:40 ','2023-03-09 19:12:40','',''),('1','312',1775,'','20','3',2880.00,0.00,'Retail Sale Id 821 for 4.00 KG of Cooking Gas @ N720.00','2023-03-10 07:39:26','',''),('1','312',1776,'','6.1','4',0.00,2880.00,'Retail Sale Id 821 for retail product','2023-03-10 07:39:26','',''),('1','312',1777,'','20','3',1440.00,0.00,'Retail Sale Id 822 for 2.00 KG of Cooking Gas @ N720.00','2023-03-10 07:40:58','',''),('1','312',1778,'','6.1','4',0.00,1440.00,'Retail Sale Id 822 for retail product','2023-03-10 07:40:58','',''),('1','312',1779,'','20','3',2160.00,0.00,'Retail Sale Id 823 for 3.00 KG of Cooking Gas @ N720.00','2023-03-10 07:58:15','',''),('1','312',1780,'','6.1','4',0.00,2160.00,'Retail Sale Id 823 for retail product','2023-03-10 07:58:15','',''),('1','312',1781,'','20','3',2160.00,0.00,'Retail Sale Id 824 for 3.00 KG of Cooking Gas @ N720.00','2023-03-10 08:00:23','',''),('1','312',1782,'','6.1','4',0.00,2160.00,'Retail Sale Id 824 for retail product','2023-03-10 08:00:23','',''),('1','312',1783,'','20','3',9000.00,0.00,'Retail Sale Id 825 for 12.50 KG of Cooking Gas @ N720.00','2023-03-10 08:06:06','',''),('1','312',1784,'','6.1','4',0.00,9000.00,'Retail Sale Id 825 for retail product','2023-03-10 08:06:06','',''),('1','312',1785,'','20','3',6080.00,0.00,'Retail Sale Id 826 for 8.44 KG of Cooking Gas @ N720.00','2023-03-10 08:08:42','',''),('1','312',1786,'','6.1','4',0.00,6080.00,'Retail Sale Id 826 for retail product','2023-03-10 08:08:42','',''),('1','312',1787,'','20','3',9000.00,0.00,'Retail Sale Id 827 for 12.50 KG of Cooking Gas @ N720.00','2023-03-10 08:27:58','',''),('1','312',1788,'','6.1','4',0.00,9000.00,'Retail Sale Id 827 for retail product','2023-03-10 08:27:58','',''),('1','312',1789,'','20','3',2880.00,0.00,'Retail Sale Id 828 for 4.00 KG of Cooking Gas @ N720.00','2023-03-10 08:45:50','',''),('1','312',1790,'','6.1','4',0.00,2880.00,'Retail Sale Id 828 for retail product','2023-03-10 08:45:50','',''),('1','312',1791,'','20','3',3600.00,0.00,'Retail Sale Id 829 for 5.00 KG of Cooking Gas @ N720.00','2023-03-10 08:48:22','',''),('1','312',1792,'','6.1','4',0.00,3600.00,'Retail Sale Id 829 for retail product','2023-03-10 08:48:22','',''),('1','312',1793,'','20','3',4320.00,0.00,'Retail Sale Id 830 for 6.00 KG of Cooking Gas @ N720.00','2023-03-10 08:52:14','',''),('1','312',1794,'','6.1','4',0.00,4320.00,'Retail Sale Id 830 for retail product','2023-03-10 08:52:14','',''),('1','312',1795,'','20','3',81600.00,0.00,'Retail Sale Id 831 for 120.00 KG of Cooking Gas @ N680.00','2023-03-10 09:10:38','',''),('1','312',1796,'','6.1','4',0.00,81600.00,'Retail Sale Id 831 for retail product','2023-03-10 09:10:38','',''),('1','312',1797,'','20','3',9000.00,0.00,'Retail Sale Id 832 for 12.50 KG of Cooking Gas @ N720.00','2023-03-10 09:39:24','',''),('1','312',1798,'','6.1','4',0.00,9000.00,'Retail Sale Id 832 for retail product','2023-03-10 09:39:24','',''),('1','312',1799,'','20','3',9000.00,0.00,'Retail Sale Id 833 for 12.50 KG of Cooking Gas @ N720.00','2023-03-10 10:17:23','',''),('1','312',1800,'','6.1','4',0.00,9000.00,'Retail Sale Id 833 for retail product','2023-03-10 10:17:23','',''),('1','312',1801,'','20','3',2880.00,0.00,'Retail Sale Id 835 for 4.00 KG of Cooking Gas @ N720.00','2023-03-10 10:30:37','',''),('1','312',1802,'','6.1','4',0.00,2880.00,'Retail Sale Id 835 for retail product','2023-03-10 10:30:37','',''),('1','312',1803,'','20','3',9360.00,0.00,'Retail Sale Id 836 for 13.00 KG of Cooking Gas @ N720.00','2023-03-10 10:43:36','',''),('1','312',1804,'','6.1','4',0.00,9360.00,'Retail Sale Id 836 for retail product','2023-03-10 10:43:36','',''),('1','312',1805,'','2','19',212581.00,0.00,'Payment Id 53 for invoice:24, receipt: 000 by AA RANO NIGERIA LTD','2023-03-10 11:16:43','',''),('1','312',1806,'','supplier','1',0.00,212581.00,'Payment Id 53 for invoice:24, receipt: 000 by AA RANO NIGERIA LTD','2023-03-10 11:16:43','',''),('1','312',1807,'','2','19',291997.00,0.00,'Payment Id 52 for invoice:24, receipt: 000 by AA RANO NIGERIA LTD','2023-03-10 11:16:43','',''),('1','312',1808,'','supplier','1',0.00,291997.00,'Payment Id 52 for invoice:24, receipt: 000 by AA RANO NIGERIA LTD','2023-03-10 11:16:43','',''),('1','312',1809,'','20','3',5040.00,0.00,'Retail Sale Id 837 for 7.00 KG of Cooking Gas @ N720.00','2023-03-10 12:01:09','',''),('1','312',1810,'','6.1','4',0.00,5040.00,'Retail Sale Id 837 for retail product','2023-03-10 12:01:09','',''),('1','312',1811,'','20','3',9000.00,0.00,'Retail Sale Id 838 for 12.50 KG of Cooking Gas @ N720.00','2023-03-10 12:03:17','',''),('1','312',1812,'','6.1','4',0.00,9000.00,'Retail Sale Id 838 for retail product','2023-03-10 12:03:17','',''),('1','312',1813,'','20','3',3600.00,0.00,'Retail Sale Id 839 for 5.00 KG of Cooking Gas @ N720.00','2023-03-10 12:22:05','',''),('1','312',1814,'','6.1','4',0.00,3600.00,'Retail Sale Id 839 for retail product','2023-03-10 12:22:05','',''),('1','312',1815,'','20','3',2880.00,0.00,'Retail Sale Id 840 for 4.00 KG of Cooking Gas @ N720.00','2023-03-10 13:03:41','',''),('1','312',1816,'','6.1','4',0.00,2880.00,'Retail Sale Id 840 for retail product','2023-03-10 13:03:41','',''),('1','312',1817,'','20','3',5040.00,0.00,'Retail Sale Id 841 for 7.00 KG of Cooking Gas @ N720.00','2023-03-10 13:19:07','',''),('1','312',1818,'','6.1','4',0.00,5040.00,'Retail Sale Id 841 for retail product','2023-03-10 13:19:07','',''),('1','312',1819,'','20','3',25200.00,0.00,'Retail Sale Id 842 for 35.00 KG of Cooking Gas @ N720.00','2023-03-10 13:34:52','',''),('1','312',1820,'','6.1','4',0.00,25200.00,'Retail Sale Id 842 for retail product','2023-03-10 13:34:52','',''),('1','312',1821,'','20','3',5040.00,0.00,'Retail Sale Id 843 for 7.00 KG of Cooking Gas @ N720.00','2023-03-10 13:53:30','',''),('1','312',1822,'','6.1','4',0.00,5040.00,'Retail Sale Id 843 for retail product','2023-03-10 13:53:30','',''),('1','312',1823,'','20','3',5040.00,0.00,'Retail Sale Id 844 for 7.00 KG of Cooking Gas @ N720.00','2023-03-10 14:14:39','',''),('1','312',1824,'','6.1','4',0.00,5040.00,'Retail Sale Id 844 for retail product','2023-03-10 14:14:39','',''),('1','312',1825,'','20','3',2880.00,0.00,'Retail Sale Id 845 for 4.00 KG of Cooking Gas @ N720.00','2023-03-10 14:17:26','',''),('1','312',1826,'','6.1','4',0.00,2880.00,'Retail Sale Id 845 for retail product','2023-03-10 14:17:26','',''),('1','312',1827,'','20','3',3000.00,0.00,'Retail Sale Id 846 for 4.17 KG of Cooking Gas @ N720.00','2023-03-10 14:44:09','',''),('1','312',1828,'','6.1','4',0.00,3000.00,'Retail Sale Id 846 for retail product','2023-03-10 14:44:09','',''),('1','312',1829,'','20','3',9000.00,0.00,'Retail Sale Id 847 for 12.50 KG of Cooking Gas @ N720.00','2023-03-10 15:34:07','',''),('1','312',1830,'','6.1','4',0.00,9000.00,'Retail Sale Id 847 for retail product','2023-03-10 15:34:07','',''),('1','312',1831,'','20','3',9000.00,0.00,'Retail Sale Id 848 for 12.50 KG of Cooking Gas @ N720.00','2023-03-10 15:41:13','',''),('1','312',1832,'','6.1','4',0.00,9000.00,'Retail Sale Id 848 for retail product','2023-03-10 15:41:13','',''),('1','312',1833,'','20','3',2160.00,0.00,'Retail Sale Id 849 for 3.00 KG of Cooking Gas @ N720.00','2023-03-10 15:45:13','',''),('1','312',1834,'','6.1','4',0.00,2160.00,'Retail Sale Id 849 for retail product','2023-03-10 15:45:13','',''),('1','312',1835,'','20','3',3000.00,0.00,'Retail Sale Id 850 for 4.17 KG of Cooking Gas @ N720.00','2023-03-10 15:53:58','',''),('1','312',1836,'','6.1','4',0.00,3000.00,'Retail Sale Id 850 for retail product','2023-03-10 15:53:59','',''),('1','312',1837,'','20','3',4320.00,0.00,'Retail Sale Id 851 for 6.00 KG of Cooking Gas @ N720.00','2023-03-10 15:56:53','',''),('1','312',1838,'','6.1','4',0.00,4320.00,'Retail Sale Id 851 for retail product','2023-03-10 15:56:53','',''),('1','312',1839,'','20','3',2160.00,0.00,'Retail Sale Id 852 for 3.00 KG of Cooking Gas @ N720.00','2023-03-10 16:09:42','',''),('1','312',1840,'','6.1','4',0.00,2160.00,'Retail Sale Id 852 for retail product','2023-03-10 16:09:42','',''),('1','312',1841,'','2','20',133700.00,0.00,'Payment Id 57 for invoice:29, receipt: p o s by AA RANO NIGERIA LTD','2023-03-10 16:13:17','',''),('1','312',1842,'','supplier','1',0.00,133700.00,'Payment Id 57 for invoice:29, receipt: p o s by AA RANO NIGERIA LTD','2023-03-10 16:13:17','',''),('1','312',1843,'','2','20',322350.00,0.00,'Payment Id 55 for invoice:28, receipt: p o s by AA RANO NIGERIA LTD','2023-03-10 16:13:43','',''),('1','312',1844,'','supplier','1',0.00,322350.00,'Payment Id 55 for invoice:28, receipt: p o s by AA RANO NIGERIA LTD','2023-03-10 16:13:43','',''),('1','312',1845,'','20','3',2160.00,0.00,'Retail Sale Id 853 for 3.00 KG of Cooking Gas @ N720.00','2023-03-10 16:34:36','',''),('1','312',1846,'','6.1','4',0.00,2160.00,'Retail Sale Id 853 for retail product','2023-03-10 16:34:36','',''),('1','312',1847,'','20','3',5040.00,0.00,'Retail Sale Id 854 for 7.00 KG of Cooking Gas @ N720.00','2023-03-10 16:44:56','',''),('1','312',1848,'','6.1','4',0.00,5040.00,'Retail Sale Id 854 for retail product','2023-03-10 16:44:56','',''),('1','312',1849,'','20','3',4320.00,0.00,'Retail Sale Id 855 for 6.00 KG of Cooking Gas @ N720.00','2023-03-10 17:21:55','',''),('1','312',1850,'','6.1','4',0.00,4320.00,'Retail Sale Id 855 for retail product','2023-03-10 17:21:55','',''),('1','312',1851,'','20','3',4350.00,0.00,'Retail Sale Id 856 for 6.04 KG of Cooking Gas @ N720.00','2023-03-10 17:29:18','',''),('1','312',1852,'','6.1','4',0.00,4350.00,'Retail Sale Id 856 for retail product','2023-03-10 17:29:18','',''),('1','312',1853,'','20','3',2160.00,0.00,'Retail Sale Id 857 for 3.00 KG of Cooking Gas @ N720.00','2023-03-10 17:30:37','',''),('1','312',1854,'','6.1','4',0.00,2160.00,'Retail Sale Id 857 for retail product','2023-03-10 17:30:37','',''),('1','312',1855,'','20','3',3600.00,0.00,'Retail Sale Id 858 for 5.00 KG of Cooking Gas @ N720.00','2023-03-10 17:54:13','',''),('1','312',1856,'','6.1','4',0.00,3600.00,'Retail Sale Id 858 for retail product','2023-03-10 17:54:13','',''),('1','312',1857,'','20','3',2000.00,0.00,'Retail Sale Id 859 for 2.78 KG of Cooking Gas @ N720.00','2023-03-10 18:15:12','',''),('1','312',1858,'','6.1','4',0.00,2000.00,'Retail Sale Id 859 for retail product','2023-03-10 18:15:12','',''),('1','312',1859,'','20','3',3600.00,0.00,'Retail Sale Id 860 for 5.00 KG of Cooking Gas @ N720.00','2023-03-10 18:28:18','',''),('1','312',1860,'','6.1','4',0.00,3600.00,'Retail Sale Id 860 for retail product','2023-03-10 18:28:18','',''),('1','312',1861,'','20','3',4000.00,0.00,'Retail Sale Id 861 for 5.56 KG of Cooking Gas @ N720.00','2023-03-10 18:45:42','',''),('1','312',1862,'','6.1','4',0.00,4000.00,'Retail Sale Id 861 for retail product','2023-03-10 18:45:42','',''),('1','312',1863,'','20','3',0.00,81600.00,'Return of Retail Sale Id 831 for products','2023-03-10 19:04:00','',''),('1','312',1864,'','','',81600.00,0.00,'Return of Retail Sale Id 831 for products','2023-03-10 19:04:00','',''),('1','312',1865,'','20','3',81022.00,0.00,'Retail Sale Id 862 for 119.15 KG of Cooking Gas @ N680.00','2023-03-10 19:04:47','',''),('1','312',1866,'','6.1','4',0.00,81022.00,'Retail Sale Id 862 for retail product','2023-03-10 19:04:47','',''),('1','312',1867,'','20','3',0.00,0.00,'Sales from shift 30 on 2023-03-10 19:29:25 ','2023-03-10 19:29:25','',''),('1','312',1868,'','6.1','4',0.00,0.00,'Sales from shift 30 on 2023-03-10 19:29:25 ','2023-03-10 19:29:25','',''),('1','312',1869,'','20','3',4320.00,0.00,'Retail Sale Id 863 for 6.00 KG of Cooking Gas @ N720.00','2023-03-11 07:57:08','',''),('1','312',1870,'','6.1','4',0.00,4320.00,'Retail Sale Id 863 for retail product','2023-03-11 07:57:08','',''),('1','312',1871,'','6.1','4',0.00,4320.00,'Retail Sale Id 863 for retail product','2023-03-11 07:57:08','',''),('1','312',1872,'','20','3',5040.00,0.00,'Retail Sale Id 864 for 7.00 KG of Cooking Gas @ N720.00','2023-03-11 08:07:29','',''),('1','312',1873,'','6.1','4',0.00,5040.00,'Retail Sale Id 864 for retail product','2023-03-11 08:07:29','',''),('1','312',1874,'','20','3',9000.00,0.00,'Retail Sale Id 865 for 12.50 KG of Cooking Gas @ N720.00','2023-03-11 08:25:13','',''),('1','312',1875,'','6.1','4',0.00,9000.00,'Retail Sale Id 865 for retail product','2023-03-11 08:25:13','',''),('1','312',1876,'','20','3',4320.00,0.00,'Retail Sale Id 866 for 6.00 KG of Cooking Gas @ N720.00','2023-03-11 08:45:57','',''),('1','312',1877,'','6.1','4',0.00,4320.00,'Retail Sale Id 866 for retail product','2023-03-11 08:45:57','',''),('1','312',1878,'','20','3',14040.00,0.00,'Retail Sale Id 867 for 19.50 KG of Cooking Gas @ N720.00','2023-03-11 09:16:09','',''),('1','312',1879,'','6.1','4',0.00,14040.00,'Retail Sale Id 867 for retail product','2023-03-11 09:16:09','',''),('1','312',1880,'','20','3',10800.00,0.00,'Retail Sale Id 868 for 15.00 KG of Cooking Gas @ N720.00','2023-03-11 09:20:09','',''),('1','312',1881,'','6.1','4',0.00,10800.00,'Retail Sale Id 868 for retail product','2023-03-11 09:20:09','',''),('1','312',1882,'','20','3',2880.00,0.00,'Retail Sale Id 869 for 4.00 KG of Cooking Gas @ N720.00','2023-03-11 09:22:44','',''),('1','312',1883,'','6.1','4',0.00,2880.00,'Retail Sale Id 869 for retail product','2023-03-11 09:22:44','',''),('1','312',1884,'','20','3',2160.00,0.00,'Retail Sale Id 870 for 3.00 KG of Cooking Gas @ N720.00','2023-03-11 09:45:58','',''),('1','312',1885,'','6.1','4',0.00,2160.00,'Retail Sale Id 870 for retail product','2023-03-11 09:45:58','',''),('1','312',1886,'','20','3',1440.00,0.00,'Retail Sale Id 871 for 2.00 KG of Cooking Gas @ N720.00','2023-03-11 09:47:49','',''),('1','312',1887,'','6.1','4',0.00,1440.00,'Retail Sale Id 871 for retail product','2023-03-11 09:47:49','',''),('1','312',1888,'','20','3',720.00,0.00,'Retail Sale Id 872 for 1.00 KG of Cooking Gas @ N720.00','2023-03-11 09:52:24','',''),('1','312',1889,'','6.1','4',0.00,720.00,'Retail Sale Id 872 for retail product','2023-03-11 09:52:24','',''),('1','312',1890,'','20','3',9000.00,0.00,'Retail Sale Id 873 for 12.50 KG of Cooking Gas @ N720.00','2023-03-11 10:05:27','',''),('1','312',1891,'','6.1','4',0.00,9000.00,'Retail Sale Id 873 for retail product','2023-03-11 10:05:27','',''),('1','312',1892,'','20','3',2000.00,0.00,'Retail Sale Id 874 for 2.78 KG of Cooking Gas @ N720.00','2023-03-11 10:07:14','',''),('1','312',1893,'','6.1','4',0.00,2000.00,'Retail Sale Id 874 for retail product','2023-03-11 10:07:14','',''),('1','312',1894,'','20','3',1440.00,0.00,'Retail Sale Id 875 for 2.00 KG of Cooking Gas @ N720.00','2023-03-11 10:19:37','',''),('1','312',1895,'','6.1','4',0.00,1440.00,'Retail Sale Id 875 for retail product','2023-03-11 10:19:37','',''),('1','312',1896,'','20','3',10800.00,0.00,'Retail Sale Id 876 for 15.00 KG of Cooking Gas @ N720.00','2023-03-11 10:22:42','',''),('1','312',1897,'','6.1','4',0.00,10800.00,'Retail Sale Id 876 for retail product','2023-03-11 10:22:42','',''),('1','312',1898,'','20','3',2900.00,0.00,'Retail Sale Id 877 for 4.03 KG of Cooking Gas @ N720.00','2023-03-11 10:36:41','',''),('1','312',1899,'','6.1','4',0.00,2900.00,'Retail Sale Id 877 for retail product','2023-03-11 10:36:41','',''),('1','312',1900,'','20','3',5040.00,0.00,'Retail Sale Id 878 for 7.00 KG of Cooking Gas @ N720.00','2023-03-11 11:05:17','',''),('1','312',1901,'','6.1','4',0.00,5040.00,'Retail Sale Id 878 for retail product','2023-03-11 11:05:17','',''),('1','312',1902,'','20','3',3600.00,0.00,'Retail Sale Id 879 for 5.00 KG of Cooking Gas @ N720.00','2023-03-11 11:07:47','',''),('1','312',1903,'','6.1','4',0.00,3600.00,'Retail Sale Id 879 for retail product','2023-03-11 11:07:47','',''),('1','312',1904,'','20','3',3600.00,0.00,'Retail Sale Id 880 for 5.00 KG of Cooking Gas @ N720.00','2023-03-11 11:14:21','',''),('1','312',1905,'','6.1','4',0.00,3600.00,'Retail Sale Id 880 for retail product','2023-03-11 11:14:21','',''),('1','312',1906,'','20','3',3600.00,0.00,'Retail Sale Id 881 for 5.00 KG of Cooking Gas @ N720.00','2023-03-11 12:23:22','',''),('1','312',1907,'','6.1','4',0.00,3600.00,'Retail Sale Id 881 for retail product','2023-03-11 12:23:22','',''),('1','312',1908,'','20','3',5040.00,0.00,'Retail Sale Id 882 for 7.00 KG of Cooking Gas @ N720.00','2023-03-11 12:24:27','',''),('1','312',1909,'','6.1','4',0.00,5040.00,'Retail Sale Id 882 for retail product','2023-03-11 12:24:27','',''),('1','312',1910,'','20','3',3000.00,0.00,'Retail Sale Id 883 for 4.17 KG of Cooking Gas @ N720.00','2023-03-11 12:55:42','',''),('1','312',1911,'','6.1','4',0.00,3000.00,'Retail Sale Id 883 for retail product','2023-03-11 12:55:42','',''),('1','312',1912,'','20','3',6480.00,0.00,'Retail Sale Id 884 for 9.00 KG of Cooking Gas @ N720.00','2023-03-11 13:21:20','',''),('1','312',1913,'','6.1','4',0.00,6480.00,'Retail Sale Id 884 for retail product','2023-03-11 13:21:20','',''),('1','312',1914,'','20','3',9000.00,0.00,'Retail Sale Id 885 for 12.50 KG of Cooking Gas @ N720.00','2023-03-11 13:28:04','',''),('1','312',1915,'','6.1','4',0.00,9000.00,'Retail Sale Id 885 for retail product','2023-03-11 13:28:04','',''),('1','312',1916,'','20','3',3600.00,0.00,'Retail Sale Id 886 for 5.00 KG of Cooking Gas @ N720.00','2023-03-11 13:29:49','',''),('1','312',1917,'','6.1','4',0.00,3600.00,'Retail Sale Id 886 for retail product','2023-03-11 13:29:49','',''),('1','312',1918,'','20','3',7200.00,0.00,'Retail Sale Id 887 for 10.00 KG of Cooking Gas @ N720.00','2023-03-11 13:57:00','',''),('1','312',1919,'','6.1','4',0.00,7200.00,'Retail Sale Id 887 for retail product','2023-03-11 13:57:00','',''),('1','312',1920,'','20','3',1000.00,0.00,'Retail Sale Id 888 for 1.39 KG of Cooking Gas @ N720.00','2023-03-11 14:01:24','',''),('1','312',1921,'','6.1','4',0.00,1000.00,'Retail Sale Id 888 for retail product','2023-03-11 14:01:24','',''),('1','312',1922,'','20','3',5040.00,0.00,'Retail Sale Id 889 for 7.00 KG of Cooking Gas @ N720.00','2023-03-11 14:08:23','',''),('1','312',1923,'','6.1','4',0.00,5040.00,'Retail Sale Id 889 for retail product','2023-03-11 14:08:23','',''),('1','312',1924,'','20','3',12110.40,0.00,'Retail Sale Id 891 for 16.82 KG of Cooking Gas @ N720.00','2023-03-11 14:38:44','',''),('1','312',1925,'','6.1','4',0.00,12110.40,'Retail Sale Id 891 for retail product','2023-03-11 14:38:44','',''),('1','312',1926,'','20','3',1440.00,0.00,'Retail Sale Id 893 for 2.00 KG of Cooking Gas @ N720.00','2023-03-11 14:46:18','',''),('1','312',1927,'','6.1','4',0.00,1440.00,'Retail Sale Id 893 for retail product','2023-03-11 14:46:18','',''),('1','312',1928,'','20','3',5000.00,0.00,'Retail Sale Id 894 for 6.94 KG of Cooking Gas @ N720.00','2023-03-11 15:07:20','',''),('1','312',1929,'','6.1','4',0.00,5000.00,'Retail Sale Id 894 for retail product','2023-03-11 15:07:20','',''),('1','312',1930,'','20','3',38880.00,0.00,'Retail Sale Id 895 for 54.00 KG of Cooking Gas @ N720.00','2023-03-11 15:20:35','',''),('1','312',1931,'','6.1','4',0.00,38880.00,'Retail Sale Id 895 for retail product','2023-03-11 15:20:35','',''),('1','312',1932,'','20','3',18000.00,0.00,'Retail Sale Id 896 for 25.00 KG of Cooking Gas @ N720.00','2023-03-11 15:30:00','',''),('1','312',1933,'','6.1','4',0.00,18000.00,'Retail Sale Id 896 for retail product','2023-03-11 15:30:00','',''),('1','312',1934,'','20','3',5040.00,0.00,'Retail Sale Id 897 for 7.00 KG of Cooking Gas @ N720.00','2023-03-11 15:39:20','',''),('1','312',1935,'','6.1','4',0.00,5040.00,'Retail Sale Id 897 for retail product','2023-03-11 15:39:20','',''),('1','312',1936,'','20','3',40800.00,0.00,'Retail Sale Id 898 for 60.00 KG of Cooking Gas @ N680.00','2023-03-11 15:44:41','',''),('1','312',1937,'','6.1','4',0.00,40800.00,'Retail Sale Id 898 for retail product','2023-03-11 15:44:41','',''),('1','312',1938,'','20','3',2520.00,0.00,'Retail Sale Id 899 for 3.50 KG of Cooking Gas @ N720.00','2023-03-11 15:48:42','',''),('1','312',1939,'','6.1','4',0.00,2520.00,'Retail Sale Id 899 for retail product','2023-03-11 15:48:42','',''),('1','312',1940,'','20','3',9000.00,0.00,'Retail Sale Id 900 for 12.50 KG of Cooking Gas @ N720.00','2023-03-11 15:55:22','',''),('1','312',1941,'','6.1','4',0.00,9000.00,'Retail Sale Id 900 for retail product','2023-03-11 15:55:22','',''),('1','312',1942,'','20','3',1000.00,0.00,'Retail Sale Id 901 for 1.39 KG of Cooking Gas @ N720.00','2023-03-11 15:56:30','',''),('1','312',1943,'','6.1','4',0.00,1000.00,'Retail Sale Id 901 for retail product','2023-03-11 15:56:30','',''),('1','312',1944,'','20','3',2880.00,0.00,'Retail Sale Id 902 for 4.00 KG of Cooking Gas @ N720.00','2023-03-11 16:13:02','',''),('1','312',1945,'','6.1','4',0.00,2880.00,'Retail Sale Id 902 for retail product','2023-03-11 16:13:02','',''),('1','312',1946,'','20','3',4320.00,0.00,'Retail Sale Id 903 for 6.00 KG of Cooking Gas @ N720.00','2023-03-11 16:26:30','',''),('1','312',1947,'','6.1','4',0.00,4320.00,'Retail Sale Id 903 for retail product','2023-03-11 16:26:30','',''),('1','312',1948,'','6.1','4',0.00,4320.00,'Retail Sale Id 903 for retail product','2023-03-11 16:26:30','',''),('1','312',1949,'','20','3',3600.00,0.00,'Retail Sale Id 904 for 5.00 KG of Cooking Gas @ N720.00','2023-03-11 16:49:06','',''),('1','312',1950,'','6.1','4',0.00,3600.00,'Retail Sale Id 904 for retail product','2023-03-11 16:49:06','',''),('1','312',1951,'','20','3',2000.00,0.00,'Retail Sale Id 905 for 2.78 KG of Cooking Gas @ N720.00','2023-03-11 16:55:35','',''),('1','312',1952,'','6.1','4',0.00,2000.00,'Retail Sale Id 905 for retail product','2023-03-11 16:55:35','',''),('1','312',1953,'','20','3',3600.00,0.00,'Retail Sale Id 906 for 5.00 KG of Cooking Gas @ N720.00','2023-03-11 16:57:47','',''),('1','312',1954,'','6.1','4',0.00,3600.00,'Retail Sale Id 906 for retail product','2023-03-11 16:57:47','',''),('1','312',1955,'','20','3',7200.00,0.00,'Retail Sale Id 908 for 10.00 KG of Cooking Gas @ N720.00','2023-03-11 17:00:28','',''),('1','312',1956,'','6.1','4',0.00,7200.00,'Retail Sale Id 908 for retail product','2023-03-11 17:00:28','',''),('1','312',1957,'','20','3',2160.00,0.00,'Retail Sale Id 909 for 3.00 KG of Cooking Gas @ N720.00','2023-03-11 17:15:39','',''),('1','312',1958,'','6.1','4',0.00,2160.00,'Retail Sale Id 909 for retail product','2023-03-11 17:15:39','',''),('1','312',1959,'','20','3',5040.00,0.00,'Retail Sale Id 910 for 7.00 KG of Cooking Gas @ N720.00','2023-03-11 17:20:32','',''),('1','312',1960,'','6.1','4',0.00,5040.00,'Retail Sale Id 910 for retail product','2023-03-11 17:20:32','',''),('1','312',1961,'','20','3',5040.00,0.00,'Retail Sale Id 911 for 7.00 KG of Cooking Gas @ N720.00','2023-03-11 17:23:55','',''),('1','312',1962,'','6.1','4',0.00,5040.00,'Retail Sale Id 911 for retail product','2023-03-11 17:23:55','',''),('1','312',1963,'','20','3',2880.00,0.00,'Retail Sale Id 912 for 4.00 KG of Cooking Gas @ N720.00','2023-03-11 17:26:15','',''),('1','312',1964,'','6.1','4',0.00,2880.00,'Retail Sale Id 912 for retail product','2023-03-11 17:26:15','',''),('1','312',1965,'','20','3',2160.00,0.00,'Retail Sale Id 913 for 3.00 KG of Cooking Gas @ N720.00','2023-03-11 17:42:59','',''),('1','312',1966,'','6.1','4',0.00,2160.00,'Retail Sale Id 913 for retail product','2023-03-11 17:42:59','',''),('1','312',1967,'','20','3',1440.00,0.00,'Retail Sale Id 914 for 2.00 KG of Cooking Gas @ N720.00','2023-03-11 18:07:15','',''),('1','312',1968,'','6.1','4',0.00,1440.00,'Retail Sale Id 914 for retail product','2023-03-11 18:07:15','',''),('1','312',1969,'','20','3',0.00,40800.00,'Return of Retail Sale Id 898 for products','2023-03-11 18:40:09','',''),('1','312',1970,'','','',40800.00,0.00,'Return of Retail Sale Id 898 for products','2023-03-11 18:40:09','',''),('1','312',1971,'','20','3',40657.20,0.00,'Retail Sale Id 915 for 59.79 KG of Cooking Gas @ N680.00','2023-03-11 18:41:18','',''),('1','312',1972,'','6.1','4',0.00,40657.20,'Retail Sale Id 915 for retail product','2023-03-11 18:41:18','',''),('1','312',1973,'','20','3',0.00,4320.00,'Return of Retail Sale Id 903 for products','2023-03-11 18:57:17','',''),('1','312',1974,'','','',4320.00,0.00,'Return of Retail Sale Id 903 for products','2023-03-11 18:57:17','',''),('1','312',1975,'','20','3',3945.60,0.00,'Retail Sale Id 916 for 5.48 KG of Cooking Gas @ N720.00','2023-03-11 18:59:40','',''),('1','312',1976,'','6.1','4',0.00,3945.60,'Retail Sale Id 916 for retail product','2023-03-11 18:59:40','',''),('1','312',1977,'','20','3',0.00,0.00,'Sales from shift 31 on 2023-03-11 19:22:09 ','2023-03-11 19:22:09','',''),('1','312',1978,'','6.1','4',0.00,0.00,'Sales from shift 31 on 2023-03-11 19:22:09 ','2023-03-11 19:22:09','',''),('1','312',1979,'','20','3',1440.00,0.00,'Retail Sale Id 917 for 2.00 KG of Cooking Gas @ N720.00','2023-03-12 07:40:04','',''),('1','312',1980,'','6.1','4',0.00,1440.00,'Retail Sale Id 917 for retail product','2023-03-12 07:40:04','',''),('1','312',1981,'','20','3',4320.00,0.00,'Retail Sale Id 918 for 6.00 KG of Cooking Gas @ N720.00','2023-03-12 07:41:42','',''),('1','312',1982,'','6.1','4',0.00,4320.00,'Retail Sale Id 918 for retail product','2023-03-12 07:41:42','',''),('1','312',1983,'','20','3',5040.00,0.00,'Retail Sale Id 919 for 7.00 KG of Cooking Gas @ N720.00','2023-03-12 07:53:54','',''),('1','312',1984,'','6.1','4',0.00,5040.00,'Retail Sale Id 919 for retail product','2023-03-12 07:53:54','',''),('1','312',1985,'','20','3',2300.00,0.00,'Retail Sale Id 920 for 3.19 KG of Cooking Gas @ N720.00','2023-03-12 08:13:16','',''),('1','312',1986,'','6.1','4',0.00,2300.00,'Retail Sale Id 920 for retail product','2023-03-12 08:13:16','',''),('1','312',1987,'','20','3',3960.00,0.00,'Retail Sale Id 921 for 5.50 KG of Cooking Gas @ N720.00','2023-03-12 08:18:39','',''),('1','312',1988,'','6.1','4',0.00,3960.00,'Retail Sale Id 921 for retail product','2023-03-12 08:18:39','',''),('1','312',1989,'','20','3',5040.00,0.00,'Retail Sale Id 922 for 7.00 KG of Cooking Gas @ N720.00','2023-03-12 08:20:24','',''),('1','312',1990,'','6.1','4',0.00,5040.00,'Retail Sale Id 922 for retail product','2023-03-12 08:20:24','',''),('1','312',1991,'','20','3',4320.00,0.00,'Retail Sale Id 923 for 6.00 KG of Cooking Gas @ N720.00','2023-03-12 08:52:54','',''),('1','312',1992,'','6.1','4',0.00,4320.00,'Retail Sale Id 923 for retail product','2023-03-12 08:52:54','',''),('1','312',1993,'','20','3',2160.00,0.00,'Retail Sale Id 926 for 3.00 KG of Cooking Gas @ N720.00','2023-03-12 09:46:33','',''),('1','312',1994,'','6.1','4',0.00,2160.00,'Retail Sale Id 926 for retail product','2023-03-12 09:46:33','',''),('1','312',1995,'','20','3',3600.00,0.00,'Retail Sale Id 927 for 5.00 KG of Cooking Gas @ N720.00','2023-03-12 09:47:40','',''),('1','312',1996,'','6.1','4',0.00,3600.00,'Retail Sale Id 927 for retail product','2023-03-12 09:47:40','',''),('1','312',1997,'','20','3',9000.00,0.00,'Retail Sale Id 928 for 12.50 KG of Cooking Gas @ N720.00','2023-03-12 09:48:46','',''),('1','312',1998,'','6.1','4',0.00,9000.00,'Retail Sale Id 928 for retail product','2023-03-12 09:48:46','',''),('1','312',1999,'','20','3',1440.00,0.00,'Retail Sale Id 929 for 2.00 KG of Cooking Gas @ N720.00','2023-03-12 09:51:22','',''),('1','312',2000,'','6.1','4',0.00,1440.00,'Retail Sale Id 929 for retail product','2023-03-12 09:51:22','',''),('1','312',2001,'','20','3',2160.00,0.00,'Retail Sale Id 930 for 3.00 KG of Cooking Gas @ N720.00','2023-03-12 09:55:55','',''),('1','312',2002,'','6.1','4',0.00,2160.00,'Retail Sale Id 930 for retail product','2023-03-12 09:55:55','',''),('1','312',2003,'','20','3',800.00,0.00,'Retail Sale Id 931 for 1.11 KG of Cooking Gas @ N720.00','2023-03-12 10:20:06','',''),('1','312',2004,'','6.1','4',0.00,800.00,'Retail Sale Id 931 for retail product','2023-03-12 10:20:06','',''),('1','312',2005,'','20','3',2160.00,0.00,'Retail Sale Id 932 for 3.00 KG of Cooking Gas @ N720.00','2023-03-12 10:43:40','',''),('1','312',2006,'','6.1','4',0.00,2160.00,'Retail Sale Id 932 for retail product','2023-03-12 10:43:40','',''),('1','312',2007,'','20','3',2880.00,0.00,'Retail Sale Id 933 for 4.00 KG of Cooking Gas @ N720.00','2023-03-12 10:53:34','',''),('1','312',2008,'','6.1','4',0.00,2880.00,'Retail Sale Id 933 for retail product','2023-03-12 10:53:34','',''),('1','312',2009,'','20','3',39440.00,0.00,'Retail Sale Id 934 for 58.00 KG of Cooking Gas @ N680.00','2023-03-12 11:15:47','',''),('1','312',2010,'','6.1','4',0.00,39440.00,'Retail Sale Id 934 for retail product','2023-03-12 11:15:47','',''),('1','312',2011,'','20','3',10800.00,0.00,'Retail Sale Id 936 for 15.00 KG of Cooking Gas @ N720.00','2023-03-12 11:44:28','',''),('1','312',2012,'','6.1','4',0.00,10800.00,'Retail Sale Id 936 for retail product','2023-03-12 11:44:28','',''),('1','312',2013,'','20','3',4000.00,0.00,'Retail Sale Id 937 for 5.56 KG of Cooking Gas @ N720.00','2023-03-12 12:37:51','',''),('1','312',2014,'','6.1','4',0.00,4000.00,'Retail Sale Id 937 for retail product','2023-03-12 12:37:51','',''),('1','312',2015,'','20','3',1440.00,0.00,'Retail Sale Id 938 for 2.00 KG of Cooking Gas @ N720.00','2023-03-12 12:44:17','',''),('1','312',2016,'','6.1','4',0.00,1440.00,'Retail Sale Id 938 for retail product','2023-03-12 12:44:17','',''),('1','312',2017,'','20','3',9000.00,0.00,'Retail Sale Id 939 for 12.50 KG of Cooking Gas @ N720.00','2023-03-12 12:52:32','',''),('1','312',2018,'','6.1','4',0.00,9000.00,'Retail Sale Id 939 for retail product','2023-03-12 12:52:32','',''),('1','312',2019,'','20','3',9000.00,0.00,'Retail Sale Id 940 for 12.50 KG of Cooking Gas @ N720.00','2023-03-12 13:10:25','',''),('1','312',2020,'','6.1','4',0.00,9000.00,'Retail Sale Id 940 for retail product','2023-03-12 13:10:25','',''),('1','312',2021,'','20','3',7200.00,0.00,'Retail Sale Id 941 for 10.00 KG of Cooking Gas @ N720.00','2023-03-12 13:14:55','',''),('1','312',2022,'','6.1','4',0.00,7200.00,'Retail Sale Id 941 for retail product','2023-03-12 13:14:55','',''),('1','312',2023,'','20','3',9000.00,0.00,'Retail Sale Id 942 for 12.50 KG of Cooking Gas @ N720.00','2023-03-12 14:03:30','',''),('1','312',2024,'','6.1','4',0.00,9000.00,'Retail Sale Id 942 for retail product','2023-03-12 14:03:30','',''),('1','312',2025,'','20','3',36000.00,0.00,'Retail Sale Id 943 for 50.00 KG of Cooking Gas @ N720.00','2023-03-12 14:24:37','',''),('1','312',2026,'','6.1','4',0.00,36000.00,'Retail Sale Id 943 for retail product','2023-03-12 14:24:37','',''),('1','312',2027,'','20','3',5000.00,0.00,'Retail Sale Id 944 for 6.94 KG of Cooking Gas @ N720.00','2023-03-12 14:43:56','',''),('1','312',2028,'','6.1','4',0.00,5000.00,'Retail Sale Id 944 for retail product','2023-03-12 14:43:56','',''),('1','312',2029,'','20','3',2500.00,0.00,'Retail Sale Id 945 for 3.47 KG of Cooking Gas @ N720.00','2023-03-12 14:46:34','',''),('1','312',2030,'','6.1','4',0.00,2500.00,'Retail Sale Id 945 for retail product','2023-03-12 14:46:34','',''),('1','312',2031,'','20','3',4320.00,0.00,'Retail Sale Id 946 for 6.00 KG of Cooking Gas @ N720.00','2023-03-12 14:50:02','',''),('1','312',2032,'','6.1','4',0.00,4320.00,'Retail Sale Id 946 for retail product','2023-03-12 14:50:02','',''),('1','312',2033,'','20','3',2160.00,0.00,'Retail Sale Id 947 for 3.00 KG of Cooking Gas @ N720.00','2023-03-12 15:02:49','',''),('1','312',2034,'','6.1','4',0.00,2160.00,'Retail Sale Id 947 for retail product','2023-03-12 15:02:49','',''),('1','312',2035,'','20','3',5040.00,0.00,'Retail Sale Id 948 for 7.00 KG of Cooking Gas @ N720.00','2023-03-12 15:15:28','',''),('1','312',2036,'','6.1','4',0.00,5040.00,'Retail Sale Id 948 for retail product','2023-03-12 15:15:28','',''),('1','312',2037,'','20','3',4000.00,0.00,'Retail Sale Id 949 for 5.56 KG of Cooking Gas @ N720.00','2023-03-12 15:54:00','',''),('1','312',2038,'','6.1','4',0.00,4000.00,'Retail Sale Id 949 for retail product','2023-03-12 15:54:00','',''),('1','312',2039,'','20','3',9000.00,0.00,'Retail Sale Id 950 for 12.50 KG of Cooking Gas @ N720.00','2023-03-12 16:02:56','',''),('1','312',2040,'','6.1','4',0.00,9000.00,'Retail Sale Id 950 for retail product','2023-03-12 16:02:56','',''),('1','312',2041,'','20','3',9000.00,0.00,'Retail Sale Id 951 for 12.50 KG of Cooking Gas @ N720.00','2023-03-12 16:16:02','',''),('1','312',2042,'','6.1','4',0.00,9000.00,'Retail Sale Id 951 for retail product','2023-03-12 16:16:02','',''),('1','312',2043,'','20','3',3600.00,0.00,'Retail Sale Id 952 for 5.00 KG of Cooking Gas @ N720.00','2023-03-12 16:19:24','',''),('1','312',2044,'','6.1','4',0.00,3600.00,'Retail Sale Id 952 for retail product','2023-03-12 16:19:24','',''),('1','312',2045,'','20','3',2160.00,0.00,'Retail Sale Id 953 for 3.00 KG of Cooking Gas @ N720.00','2023-03-12 16:22:03','',''),('1','312',2046,'','6.1','4',0.00,2160.00,'Retail Sale Id 953 for retail product','2023-03-12 16:22:03','',''),('1','312',2047,'','20','3',2160.00,0.00,'Retail Sale Id 954 for 3.00 KG of Cooking Gas @ N720.00','2023-03-12 16:38:31','',''),('1','312',2048,'','6.1','4',0.00,2160.00,'Retail Sale Id 954 for retail product','2023-03-12 16:38:31','',''),('1','312',2049,'','20','3',37400.00,0.00,'Retail Sale Id 955 for 55.00 KG of Cooking Gas @ N680.00','2023-03-12 16:51:02','',''),('1','312',2050,'','6.1','4',0.00,37400.00,'Retail Sale Id 955 for retail product','2023-03-12 16:51:02','',''),('1','312',2051,'','20','3',2160.00,0.00,'Retail Sale Id 956 for 3.00 KG of Cooking Gas @ N720.00','2023-03-12 16:55:19','',''),('1','312',2052,'','6.1','4',0.00,2160.00,'Retail Sale Id 956 for retail product','2023-03-12 16:55:19','',''),('1','312',2053,'','20','3',2000.00,0.00,'Retail Sale Id 957 for 2.78 KG of Cooking Gas @ N720.00','2023-03-12 16:59:42','',''),('1','312',2054,'','6.1','4',0.00,2000.00,'Retail Sale Id 957 for retail product','2023-03-12 16:59:42','',''),('1','312',2055,'','20','3',5040.00,0.00,'Retail Sale Id 958 for 7.00 KG of Cooking Gas @ N720.00','2023-03-12 17:18:28','',''),('1','312',2056,'','6.1','4',0.00,5040.00,'Retail Sale Id 958 for retail product','2023-03-12 17:18:28','',''),('1','312',2057,'','20','3',4000.00,0.00,'Retail Sale Id 959 for 5.56 KG of Cooking Gas @ N720.00','2023-03-12 17:22:56','',''),('1','312',2058,'','6.1','4',0.00,4000.00,'Retail Sale Id 959 for retail product','2023-03-12 17:22:56','',''),('1','312',2059,'','20','3',3600.00,0.00,'Retail Sale Id 960 for 5.00 KG of Cooking Gas @ N720.00','2023-03-12 17:29:14','',''),('1','312',2060,'','6.1','4',0.00,3600.00,'Retail Sale Id 960 for retail product','2023-03-12 17:29:14','',''),('1','312',2061,'','20','3',9000.00,0.00,'Retail Sale Id 961 for 12.50 KG of Cooking Gas @ N720.00','2023-03-12 17:33:12','',''),('1','312',2062,'','6.1','4',0.00,9000.00,'Retail Sale Id 961 for retail product','2023-03-12 17:33:12','',''),('1','312',2063,'','20','3',9000.00,0.00,'Retail Sale Id 962 for 12.50 KG of Cooking Gas @ N720.00','2023-03-12 17:35:16','',''),('1','312',2064,'','6.1','4',0.00,9000.00,'Retail Sale Id 962 for retail product','2023-03-12 17:35:16','',''),('1','312',2065,'','20','3',3600.00,0.00,'Retail Sale Id 963 for 5.00 KG of Cooking Gas @ N720.00','2023-03-12 17:39:39','',''),('1','312',2066,'','6.1','4',0.00,3600.00,'Retail Sale Id 963 for retail product','2023-03-12 17:39:39','',''),('1','312',2067,'','20','3',5040.00,0.00,'Retail Sale Id 964 for 7.00 KG of Cooking Gas @ N720.00','2023-03-12 18:03:22','',''),('1','312',2068,'','6.1','4',0.00,5040.00,'Retail Sale Id 964 for retail product','2023-03-12 18:03:22','',''),('1','312',2069,'','20','3',4320.00,0.00,'Retail Sale Id 965 for 6.00 KG of Cooking Gas @ N720.00','2023-03-12 18:15:59','',''),('1','312',2070,'','6.1','4',0.00,4320.00,'Retail Sale Id 965 for retail product','2023-03-12 18:15:59','',''),('1','312',2071,'','20','3',4320.00,0.00,'Retail Sale Id 966 for 6.00 KG of Cooking Gas @ N720.00','2023-03-12 18:26:07','',''),('1','312',2072,'','6.1','4',0.00,4320.00,'Retail Sale Id 966 for retail product','2023-03-12 18:26:07','',''),('1','312',2073,'','20','3',67211.20,0.00,'Retail Sale Id 967 for 98.84 KG of Cooking Gas @ N680.00','2023-03-12 18:34:31','',''),('1','312',2074,'','6.1','4',0.00,67211.20,'Retail Sale Id 967 for retail product','2023-03-12 18:34:31','',''),('1','312',2075,'','20','3',720.00,0.00,'Retail Sale Id 968 for 1.00 KG of Cooking Gas @ N720.00','2023-03-12 18:36:25','',''),('1','312',2076,'','6.1','4',0.00,720.00,'Retail Sale Id 968 for retail product','2023-03-12 18:36:25','',''),('1','312',2077,'','20','3',0.00,0.00,'Sales from shift 32 on 2023-03-12 18:42:34 ','2023-03-12 18:42:34','',''),('1','312',2078,'','6.1','4',0.00,0.00,'Sales from shift 32 on 2023-03-12 18:42:34 ','2023-03-12 18:42:34','',''),('1','312',2079,'','2','19',45151.00,0.00,'Payment Id 46 for invoice:25, receipt: 000 by AA RANO NIGERIA LTD','2023-03-13 12:07:46','',''),('1','312',2080,'','supplier','1',0.00,45151.00,'Payment Id 46 for invoice:25, receipt: 000 by AA RANO NIGERIA LTD','2023-03-13 12:07:46','',''),('1','312',2081,'','2','19',35566.00,0.00,'Payment Id 49 for invoice:26, receipt: 000 by AA RANO NIGERIA LTD','2023-03-13 12:08:20','',''),('1','312',2082,'','supplier','1',0.00,35566.00,'Payment Id 49 for invoice:26, receipt: 000 by AA RANO NIGERIA LTD','2023-03-13 12:08:20','',''),('1','312',2083,'','2','19',17993.00,0.00,'Payment Id 56 for invoice:29, receipt: 000 by AA RANO NIGERIA LTD','2023-03-13 12:09:17','',''),('1','312',2084,'','supplier','1',0.00,17993.00,'Payment Id 56 for invoice:29, receipt: 000 by AA RANO NIGERIA LTD','2023-03-13 12:09:17','',''),('1','312',2085,'','2','19',16478.00,0.00,'Payment Id 58 for invoice:30, receipt: 000 by AA RANO NIGERIA LTD','2023-03-13 12:10:02','',''),('1','312',2086,'','supplier','1',0.00,16478.00,'Payment Id 58 for invoice:30, receipt: 000 by AA RANO NIGERIA LTD','2023-03-13 12:10:02','',''),('1','312',2087,'','2','19',3482.00,0.00,'Payment Id 60 for invoice:31, receipt: 000 by AA RANO NIGERIA LTD','2023-03-13 12:10:53','',''),('1','312',2088,'','supplier','1',0.00,3482.00,'Payment Id 60 for invoice:31, receipt: 000 by AA RANO NIGERIA LTD','2023-03-13 12:10:53','',''),('1','312',2089,'','20','3',4320.00,0.00,'Retail Sale Id 969 for 6.00 KG of Cooking Gas @ N720.00','2023-03-14 07:38:11','',''),('1','312',2090,'','6.1','4',0.00,4320.00,'Retail Sale Id 969 for retail product','2023-03-14 07:38:11','',''),('1','312',2091,'','20','3',9000.00,0.00,'Retail Sale Id 970 for 12.50 KG of Cooking Gas @ N720.00','2023-03-14 07:39:22','',''),('1','312',2092,'','6.1','4',0.00,9000.00,'Retail Sale Id 970 for retail product','2023-03-14 07:39:22','',''),('1','312',2093,'','20','3',12240.00,0.00,'Retail Sale Id 971 for 17.00 KG of Cooking Gas @ N720.00','2023-03-14 07:44:38','',''),('1','312',2094,'','6.1','4',0.00,12240.00,'Retail Sale Id 971 for retail product','2023-03-14 07:44:38','',''),('1','312',2095,'','20','3',4320.00,0.00,'Retail Sale Id 972 for 6.00 KG of Cooking Gas @ N720.00','2023-03-14 07:47:11','',''),('1','312',2096,'','6.1','4',0.00,4320.00,'Retail Sale Id 972 for retail product','2023-03-14 07:47:11','',''),('1','312',2097,'','20','3',9000.00,0.00,'Retail Sale Id 973 for 12.50 KG of Cooking Gas @ N720.00','2023-03-14 07:53:04','',''),('1','312',2098,'','6.1','4',0.00,9000.00,'Retail Sale Id 973 for retail product','2023-03-14 07:53:04','',''),('1','312',2099,'','20','3',7200.00,0.00,'Retail Sale Id 974 for 10.00 KG of Cooking Gas @ N720.00','2023-03-14 08:12:56','',''),('1','312',2100,'','6.1','4',0.00,7200.00,'Retail Sale Id 974 for retail product','2023-03-14 08:12:56','',''),('1','312',2101,'','20','3',4320.00,0.00,'Retail Sale Id 975 for 6.00 KG of Cooking Gas @ N720.00','2023-03-14 08:29:08','',''),('1','312',2102,'','6.1','4',0.00,4320.00,'Retail Sale Id 975 for retail product','2023-03-14 08:29:08','',''),('1','312',2103,'','20','3',13320.00,0.00,'Retail Sale Id 976 for 18.50 KG of Cooking Gas @ N720.00','2023-03-14 08:40:39','',''),('1','312',2104,'','6.1','4',0.00,13320.00,'Retail Sale Id 976 for retail product','2023-03-14 08:40:39','',''),('1','312',2105,'','20','3',23760.00,0.00,'Retail Sale Id 978 for 33.00 KG of Cooking Gas @ N720.00','2023-03-14 08:52:59','',''),('1','312',2106,'','6.1','4',0.00,23760.00,'Retail Sale Id 978 for retail product','2023-03-14 08:52:59','',''),('1','312',2107,'','20','3',3600.00,0.00,'Retail Sale Id 979 for 5.00 KG of Cooking Gas @ N720.00','2023-03-14 08:55:19','',''),('1','312',2108,'','6.1','4',0.00,3600.00,'Retail Sale Id 979 for retail product','2023-03-14 08:55:19','',''),('1','312',2109,'','20','3',9000.00,0.00,'Retail Sale Id 980 for 12.50 KG of Cooking Gas @ N720.00','2023-03-14 08:56:45','',''),('1','312',2110,'','6.1','4',0.00,9000.00,'Retail Sale Id 980 for retail product','2023-03-14 08:56:45','',''),('1','312',2111,'','20','3',9000.00,0.00,'Retail Sale Id 981 for 12.50 KG of Cooking Gas @ N720.00','2023-03-14 09:38:42','',''),('1','312',2112,'','6.1','4',0.00,9000.00,'Retail Sale Id 981 for retail product','2023-03-14 09:38:42','',''),('1','312',2113,'','20','3',9000.00,0.00,'Retail Sale Id 982 for 12.50 KG of Cooking Gas @ N720.00','2023-03-14 09:54:57','',''),('1','312',2114,'','6.1','4',0.00,9000.00,'Retail Sale Id 982 for retail product','2023-03-14 09:54:57','',''),('1','312',2115,'','20','3',3000.00,0.00,'Retail Sale Id 983 for 4.17 KG of Cooking Gas @ N720.00','2023-03-14 10:25:13','',''),('1','312',2116,'','6.1','4',0.00,3000.00,'Retail Sale Id 983 for retail product','2023-03-14 10:25:13','',''),('1','312',2117,'','20','3',2200.00,0.00,'Retail Sale Id 984 for 3.06 KG of Cooking Gas @ N720.00','2023-03-14 11:16:59','',''),('1','312',2118,'','6.1','4',0.00,2200.00,'Retail Sale Id 984 for retail product','2023-03-14 11:16:59','',''),('1','312',2119,'','20','3',2160.00,0.00,'Retail Sale Id 985 for 3.00 KG of Cooking Gas @ N720.00','2023-03-14 11:18:54','',''),('1','312',2120,'','6.1','4',0.00,2160.00,'Retail Sale Id 985 for retail product','2023-03-14 11:18:54','',''),('1','312',2121,'','20','3',12240.00,0.00,'Retail Sale Id 986 for 17.00 KG of Cooking Gas @ N720.00','2023-03-14 11:38:57','',''),('1','312',2122,'','6.1','4',0.00,12240.00,'Retail Sale Id 986 for retail product','2023-03-14 11:38:57','',''),('1','312',2123,'','2','20',265820.00,0.00,'Payment Id 59 for invoice:30, receipt: p o s by AA RANO NIGERIA LTD','2023-03-14 11:55:00','',''),('1','312',2124,'','supplier','1',0.00,265820.00,'Payment Id 59 for invoice:30, receipt: p o s by AA RANO NIGERIA LTD','2023-03-14 11:55:00','',''),('1','312',2125,'','2','8',14040.00,0.00,'Payment Id 62 for invoice:31, receipt: p o s by AA RANO NIGERIA LTD','2023-03-14 11:56:41','',''),('1','312',2126,'','supplier','1',0.00,14040.00,'Payment Id 62 for invoice:31, receipt: p o s by AA RANO NIGERIA LTD','2023-03-14 11:56:41','',''),('1','312',2127,'','2','20',295050.00,0.00,'Payment Id 61 for invoice:31, receipt: p o s by AA RANO NIGERIA LTD','2023-03-14 11:56:41','',''),('1','312',2128,'','supplier','1',0.00,295050.00,'Payment Id 61 for invoice:31, receipt: p o s by AA RANO NIGERIA LTD','2023-03-14 11:56:41','',''),('1','312',2129,'','2','20',382851.00,0.00,'Payment Id 63 for invoice:32, receipt: p o s by AA RANO NIGERIA LTD','2023-03-14 11:57:18','',''),('1','312',2130,'','supplier','1',0.00,382851.00,'Payment Id 63 for invoice:32, receipt: p o s by AA RANO NIGERIA LTD','2023-03-14 11:57:18','',''),('1','312',2131,'','20','3',8640.00,0.00,'Retail Sale Id 987 for 12.00 KG of Cooking Gas @ N720.00','2023-03-14 12:03:12','',''),('1','312',2132,'','6.1','4',0.00,8640.00,'Retail Sale Id 987 for retail product','2023-03-14 12:03:12','',''),('1','312',2133,'','20','3',720.00,0.00,'Retail Sale Id 988 for 1.00 KG of Cooking Gas @ N720.00','2023-03-14 13:17:27','',''),('1','312',2134,'','6.1','4',0.00,720.00,'Retail Sale Id 988 for retail product','2023-03-14 13:17:27','',''),('1','312',2135,'','20','3',1440.00,0.00,'Retail Sale Id 989 for 2.00 KG of Cooking Gas @ N720.00','2023-03-14 13:38:20','',''),('1','312',2136,'','6.1','4',0.00,1440.00,'Retail Sale Id 989 for retail product','2023-03-14 13:38:20','',''),('1','312',2137,'','20','3',5040.00,0.00,'Retail Sale Id 990 for 7.00 KG of Cooking Gas @ N720.00','2023-03-14 15:22:41','',''),('1','312',2138,'','6.1','4',0.00,5040.00,'Retail Sale Id 990 for retail product','2023-03-14 15:22:41','',''),('1','312',2139,'','20','3',4500.00,0.00,'Retail Sale Id 991 for 6.25 KG of Cooking Gas @ N720.00','2023-03-14 15:35:41','',''),('1','312',2140,'','6.1','4',0.00,4500.00,'Retail Sale Id 991 for retail product','2023-03-14 15:35:41','',''),('1','312',2141,'','20','3',9000.00,0.00,'Retail Sale Id 992 for 12.50 KG of Cooking Gas @ N720.00','2023-03-14 15:37:17','',''),('1','312',2142,'','6.1','4',0.00,9000.00,'Retail Sale Id 992 for retail product','2023-03-14 15:37:17','',''),('1','312',2143,'','20','3',3600.00,0.00,'Retail Sale Id 993 for 5.00 KG of Cooking Gas @ N720.00','2023-03-14 15:48:51','',''),('1','312',2144,'','6.1','4',0.00,3600.00,'Retail Sale Id 993 for retail product','2023-03-14 15:48:51','',''),('1','312',2145,'','20','3',2880.00,0.00,'Retail Sale Id 994 for 4.00 KG of Cooking Gas @ N720.00','2023-03-14 16:51:03','',''),('1','312',2146,'','6.1','4',0.00,2880.00,'Retail Sale Id 994 for retail product','2023-03-14 16:51:03','',''),('1','312',2147,'','20','3',2160.00,0.00,'Retail Sale Id 995 for 3.00 KG of Cooking Gas @ N720.00','2023-03-14 17:02:50','',''),('1','312',2148,'','6.1','4',0.00,2160.00,'Retail Sale Id 995 for retail product','2023-03-14 17:02:50','',''),('1','312',2149,'','20','3',5760.00,0.00,'Retail Sale Id 996 for 8.00 KG of Cooking Gas @ N720.00','2023-03-14 17:14:02','',''),('1','312',2150,'','6.1','4',0.00,5760.00,'Retail Sale Id 996 for retail product','2023-03-14 17:14:02','',''),('1','312',2151,'','20','3',3600.00,0.00,'Retail Sale Id 998 for 5.00 KG of Cooking Gas @ N720.00','2023-03-14 17:19:59','',''),('1','312',2152,'','6.1','4',0.00,3600.00,'Retail Sale Id 998 for retail product','2023-03-14 17:19:59','',''),('1','312',2153,'','20','3',98600.00,0.00,'Retail Sale Id 999 for 145.00 KG of Cooking Gas @ N680.00','2023-03-14 17:23:18','',''),('1','312',2154,'','6.1','4',0.00,98600.00,'Retail Sale Id 999 for retail product','2023-03-14 17:23:18','',''),('1','312',2155,'','20','3',2160.00,0.00,'Retail Sale Id 1001 for 3.00 KG of Cooking Gas @ N720.00','2023-03-14 17:38:36','',''),('1','312',2156,'','6.1','4',0.00,2160.00,'Retail Sale Id 1001 for retail product','2023-03-14 17:38:36','',''),('1','312',2157,'','20','3',5040.00,0.00,'Retail Sale Id 1002 for 7.00 KG of Cooking Gas @ N720.00','2023-03-14 17:45:32','',''),('1','312',2158,'','6.1','4',0.00,5040.00,'Retail Sale Id 1002 for retail product','2023-03-14 17:45:32','',''),('1','312',2159,'','20','3',9000.00,0.00,'Retail Sale Id 1003 for 12.50 KG of Cooking Gas @ N720.00','2023-03-14 18:15:26','',''),('1','312',2160,'','6.1','4',0.00,9000.00,'Retail Sale Id 1003 for retail product','2023-03-14 18:15:26','',''),('1','312',2161,'','20','3',3600.00,0.00,'Retail Sale Id 1004 for 5.00 KG of Cooking Gas @ N720.00','2023-03-14 18:45:35','',''),('1','312',2162,'','6.1','4',0.00,3600.00,'Retail Sale Id 1004 for retail product','2023-03-14 18:45:35','',''),('1','312',2163,'','20','3',1440.00,0.00,'Retail Sale Id 1005 for 2.00 KG of Cooking Gas @ N720.00','2023-03-14 19:10:42','',''),('1','312',2164,'','6.1','4',0.00,1440.00,'Retail Sale Id 1005 for retail product','2023-03-14 19:10:42','',''),('1','312',2165,'','20','3',0.00,0.00,'Sales from shift 33 on 2023-03-14 19:28:05 ','2023-03-14 19:28:05','',''),('1','312',2166,'','6.1','4',0.00,0.00,'Sales from shift 33 on 2023-03-14 19:28:05 ','2023-03-14 19:28:05','',''),('1','312',2167,'','20','3',4320.00,0.00,'Retail Sale Id 1006 for 6.00 KG of Cooking Gas @ N720.00','2023-03-15 08:05:02','',''),('1','312',2168,'','6.1','4',0.00,4320.00,'Retail Sale Id 1006 for retail product','2023-03-15 08:05:02','',''),('1','312',2169,'','20','3',4320.00,0.00,'Retail Sale Id 1008 for 6.00 KG of Cooking Gas @ N720.00','2023-03-15 08:22:33','',''),('1','312',2170,'','6.1','4',0.00,4320.00,'Retail Sale Id 1008 for retail product','2023-03-15 08:22:33','',''),('1','312',2171,'','20','3',7200.00,0.00,'Retail Sale Id 1009 for 10.00 KG of Cooking Gas @ N720.00','2023-03-15 08:25:04','',''),('1','312',2172,'','6.1','4',0.00,7200.00,'Retail Sale Id 1009 for retail product','2023-03-15 08:25:04','',''),('1','312',2173,'','20','3',9000.00,0.00,'Retail Sale Id 1010 for 12.50 KG of Cooking Gas @ N720.00','2023-03-15 08:52:24','',''),('1','312',2174,'','6.1','4',0.00,9000.00,'Retail Sale Id 1010 for retail product','2023-03-15 08:52:24','',''),('1','312',2175,'','20','3',2880.00,0.00,'Retail Sale Id 1011 for 4.00 KG of Cooking Gas @ N720.00','2023-03-15 08:55:33','',''),('1','312',2176,'','6.1','4',0.00,2880.00,'Retail Sale Id 1011 for retail product','2023-03-15 08:55:33','',''),('1','312',2177,'','20','3',2160.00,0.00,'Retail Sale Id 1012 for 3.00 KG of Cooking Gas @ N720.00','2023-03-15 08:58:50','',''),('1','312',2178,'','6.1','4',0.00,2160.00,'Retail Sale Id 1012 for retail product','2023-03-15 08:58:50','',''),('1','312',2179,'','20','3',2200.00,0.00,'Retail Sale Id 1013 for 3.06 KG of Cooking Gas @ N720.00','2023-03-15 09:07:37','',''),('1','312',2180,'','6.1','4',0.00,2200.00,'Retail Sale Id 1013 for retail product','2023-03-15 09:07:37','',''),('1','312',2181,'','20','3',2880.00,0.00,'Retail Sale Id 1014 for 4.00 KG of Cooking Gas @ N720.00','2023-03-15 09:28:21','',''),('1','312',2182,'','6.1','4',0.00,2880.00,'Retail Sale Id 1014 for retail product','2023-03-15 09:28:21','',''),('1','312',2183,'','20','3',4320.00,0.00,'Retail Sale Id 1015 for 6.00 KG of Cooking Gas @ N720.00','2023-03-15 09:39:02','',''),('1','312',2184,'','6.1','4',0.00,4320.00,'Retail Sale Id 1015 for retail product','2023-03-15 09:39:02','',''),('1','312',2185,'','20','3',3240.00,0.00,'Retail Sale Id 1016 for 4.50 KG of Cooking Gas @ N720.00','2023-03-15 10:09:48','',''),('1','312',2186,'','6.1','4',0.00,3240.00,'Retail Sale Id 1016 for retail product','2023-03-15 10:09:48','',''),('1','312',2187,'','20','3',4320.00,0.00,'Retail Sale Id 1017 for 6.00 KG of Cooking Gas @ N720.00','2023-03-15 10:11:37','',''),('1','312',2188,'','6.1','4',0.00,4320.00,'Retail Sale Id 1017 for retail product','2023-03-15 10:11:37','',''),('1','312',2189,'','20','3',2160.00,0.00,'Retail Sale Id 1018 for 3.00 KG of Cooking Gas @ N720.00','2023-03-15 10:38:54','',''),('1','312',2190,'','6.1','4',0.00,2160.00,'Retail Sale Id 1018 for retail product','2023-03-15 10:38:54','',''),('1','312',2191,'','20','3',10800.00,0.00,'Retail Sale Id 1019 for 15.00 KG of Cooking Gas @ N720.00','2023-03-15 10:41:00','',''),('1','312',2192,'','6.1','4',0.00,10800.00,'Retail Sale Id 1019 for retail product','2023-03-15 10:41:00','',''),('1','312',2193,'','20','3',2880.00,0.00,'Retail Sale Id 1020 for 4.00 KG of Cooking Gas @ N720.00','2023-03-15 11:46:07','',''),('1','312',2194,'','6.1','4',0.00,2880.00,'Retail Sale Id 1020 for retail product','2023-03-15 11:46:07','',''),('1','312',2195,'','20','3',9000.00,0.00,'Retail Sale Id 1021 for 12.50 KG of Cooking Gas @ N720.00','2023-03-15 12:23:41','',''),('1','312',2196,'','6.1','4',0.00,9000.00,'Retail Sale Id 1021 for retail product','2023-03-15 12:23:41','',''),('1','312',2197,'','20','3',10440.00,0.00,'Retail Sale Id 1022 for 14.50 KG of Cooking Gas @ N720.00','2023-03-15 12:57:45','',''),('1','312',2198,'','6.1','4',0.00,10440.00,'Retail Sale Id 1022 for retail product','2023-03-15 12:57:45','',''),('1','312',2199,'','20','3',1440.00,0.00,'Retail Sale Id 1023 for 2.00 KG of Cooking Gas @ N720.00','2023-03-15 13:07:33','',''),('1','312',2200,'','6.1','4',0.00,1440.00,'Retail Sale Id 1023 for retail product','2023-03-15 13:07:33','',''),('1','312',2201,'','2','8',12882.00,0.00,'Payment Id 65 for invoice:33, receipt: p o s by AA RANO NIGERIA LTD','2023-03-15 14:30:49','',''),('1','312',2202,'','supplier','1',0.00,12882.00,'Payment Id 65 for invoice:33, receipt: p o s by AA RANO NIGERIA LTD','2023-03-15 14:30:49','',''),('1','312',2203,'','20','3',9000.00,0.00,'Retail Sale Id 1024 for 12.50 KG of Cooking Gas @ N720.00','2023-03-15 14:32:02','',''),('1','312',2204,'','6.1','4',0.00,9000.00,'Retail Sale Id 1024 for retail product','2023-03-15 14:32:02','',''),('1','312',2205,'','20','3',1500.00,0.00,'Retail Sale Id 1025 for 2.08 KG of Cooking Gas @ N720.00','2023-03-15 14:53:48','',''),('1','312',2206,'','6.1','4',0.00,1500.00,'Retail Sale Id 1025 for retail product','2023-03-15 14:53:48','',''),('1','312',2207,'','20','3',3600.00,0.00,'Retail Sale Id 1026 for 5.00 KG of Cooking Gas @ N720.00','2023-03-15 15:35:49','',''),('1','312',2208,'','6.1','4',0.00,3600.00,'Retail Sale Id 1026 for retail product','2023-03-15 15:35:49','',''),('1','312',2209,'','20','3',7200.00,0.00,'Retail Sale Id 1027 for 10.00 KG of Cooking Gas @ N720.00','2023-03-15 15:38:31','',''),('1','312',2210,'','6.1','4',0.00,7200.00,'Retail Sale Id 1027 for retail product','2023-03-15 15:38:31','',''),('1','312',2211,'','20','3',10080.00,0.00,'Retail Sale Id 1028 for 14.00 KG of Cooking Gas @ N720.00','2023-03-15 15:40:22','',''),('1','312',2212,'','6.1','4',0.00,10080.00,'Retail Sale Id 1028 for retail product','2023-03-15 15:40:22','',''),('1','312',2213,'','20','3',2160.00,0.00,'Retail Sale Id 1029 for 3.00 KG of Cooking Gas @ N720.00','2023-03-15 15:42:51','',''),('1','312',2214,'','6.1','4',0.00,2160.00,'Retail Sale Id 1029 for retail product','2023-03-15 15:42:51','',''),('1','312',2215,'','20','3',2880.00,0.00,'Retail Sale Id 1030 for 4.00 KG of Cooking Gas @ N720.00','2023-03-15 15:49:52','',''),('1','312',2216,'','6.1','4',0.00,2880.00,'Retail Sale Id 1030 for retail product','2023-03-15 15:49:52','',''),('1','312',2217,'','20','3',5040.00,0.00,'Retail Sale Id 1031 for 7.00 KG of Cooking Gas @ N720.00','2023-03-15 16:03:41','',''),('1','312',2218,'','6.1','4',0.00,5040.00,'Retail Sale Id 1031 for retail product','2023-03-15 16:03:41','',''),('1','312',2219,'','20','3',3600.00,0.00,'Retail Sale Id 1032 for 5.00 KG of Cooking Gas @ N720.00','2023-03-15 16:09:54','',''),('1','312',2220,'','6.1','4',0.00,3600.00,'Retail Sale Id 1032 for retail product','2023-03-15 16:09:54','',''),('1','312',2221,'','20','3',4320.00,0.00,'Retail Sale Id 1033 for 6.00 KG of Cooking Gas @ N720.00','2023-03-15 16:20:23','',''),('1','312',2222,'','6.1','4',0.00,4320.00,'Retail Sale Id 1033 for retail product','2023-03-15 16:20:23','',''),('1','312',2223,'','20','3',1440.00,0.00,'Retail Sale Id 1034 for 2.00 KG of Cooking Gas @ N720.00','2023-03-15 16:22:47','',''),('1','312',2224,'','6.1','4',0.00,1440.00,'Retail Sale Id 1034 for retail product','2023-03-15 16:22:47','',''),('1','312',2225,'','20','3',2160.00,0.00,'Retail Sale Id 1035 for 3.00 KG of Cooking Gas @ N720.00','2023-03-15 16:48:05','',''),('1','312',2226,'','6.1','4',0.00,2160.00,'Retail Sale Id 1035 for retail product','2023-03-15 16:48:05','',''),('1','312',2227,'','20','3',1450.00,0.00,'Retail Sale Id 1036 for 2.01 KG of Cooking Gas @ N720.00','2023-03-15 17:18:13','',''),('1','312',2228,'','6.1','4',0.00,1450.00,'Retail Sale Id 1036 for retail product','2023-03-15 17:18:13','',''),('1','312',2229,'','20','3',0.00,0.00,'Sales from shift 34 on 2023-03-15 18:07:12 ','2023-03-15 18:07:12','',''),('1','312',2230,'','6.1','4',0.00,0.00,'Sales from shift 34 on 2023-03-15 18:07:12 ','2023-03-15 18:07:12','',''),('1','312',2231,'','20','3',4320.00,0.00,'Retail Sale Id 1037 for 6.00 KG of Cooking Gas @ N720.00','2023-03-16 08:01:25','',''),('1','312',2232,'','6.1','4',0.00,4320.00,'Retail Sale Id 1037 for retail product','2023-03-16 08:01:25','',''),('1','312',2233,'','20','3',7200.00,0.00,'Retail Sale Id 1038 for 10.00 KG of Cooking Gas @ N720.00','2023-03-16 08:03:26','',''),('1','312',2234,'','6.1','4',0.00,7200.00,'Retail Sale Id 1038 for retail product','2023-03-16 08:03:26','',''),('1','312',2235,'','20','3',9000.00,0.00,'Retail Sale Id 1039 for 12.50 KG of Cooking Gas @ N720.00','2023-03-16 08:29:46','',''),('1','312',2236,'','6.1','4',0.00,9000.00,'Retail Sale Id 1039 for retail product','2023-03-16 08:29:46','',''),('1','312',2237,'','20','3',1440.00,0.00,'Retail Sale Id 1040 for 2.00 KG of Cooking Gas @ N720.00','2023-03-16 08:48:34','',''),('1','312',2238,'','6.1','4',0.00,1440.00,'Retail Sale Id 1040 for retail product','2023-03-16 08:48:34','',''),('1','312',2239,'','20','3',2160.00,0.00,'Retail Sale Id 1041 for 3.00 KG of Cooking Gas @ N720.00','2023-03-16 08:57:55','',''),('1','312',2240,'','6.1','4',0.00,2160.00,'Retail Sale Id 1041 for retail product','2023-03-16 08:57:55','',''),('1','312',2241,'','20','3',7200.00,0.00,'Retail Sale Id 1042 for 10.00 KG of Cooking Gas @ N720.00','2023-03-16 09:00:49','',''),('1','312',2242,'','6.1','4',0.00,7200.00,'Retail Sale Id 1042 for retail product','2023-03-16 09:00:49','',''),('1','312',2243,'','20','3',4000.00,0.00,'Retail Sale Id 1043 for 5.56 KG of Cooking Gas @ N720.00','2023-03-16 09:03:49','',''),('1','312',2244,'','6.1','4',0.00,4000.00,'Retail Sale Id 1043 for retail product','2023-03-16 09:03:49','',''),('1','312',2245,'','20','3',4320.00,0.00,'Retail Sale Id 1044 for 6.00 KG of Cooking Gas @ N720.00','2023-03-16 09:14:47','',''),('1','312',2246,'','6.1','4',0.00,4320.00,'Retail Sale Id 1044 for retail product','2023-03-16 09:14:47','',''),('1','312',2247,'','20','3',4320.00,0.00,'Retail Sale Id 1045 for 6.00 KG of Cooking Gas @ N720.00','2023-03-16 09:27:41','',''),('1','312',2248,'','6.1','4',0.00,4320.00,'Retail Sale Id 1045 for retail product','2023-03-16 09:27:41','',''),('1','312',2249,'','20','3',3600.00,0.00,'Retail Sale Id 1046 for 5.00 KG of Cooking Gas @ N720.00','2023-03-16 10:21:52','',''),('1','312',2250,'','6.1','4',0.00,3600.00,'Retail Sale Id 1046 for retail product','2023-03-16 10:21:52','',''),('1','312',2251,'','20','3',7200.00,0.00,'Retail Sale Id 1047 for 10.00 KG of Cooking Gas @ N720.00','2023-03-16 10:45:06','',''),('1','312',2252,'','6.1','4',0.00,7200.00,'Retail Sale Id 1047 for retail product','2023-03-16 10:45:06','',''),('1','312',2253,'','20','3',21600.00,0.00,'Retail Sale Id 1048 for 30.00 KG of Cooking Gas @ N720.00','2023-03-16 10:55:40','',''),('1','312',2254,'','6.1','4',0.00,21600.00,'Retail Sale Id 1048 for retail product','2023-03-16 10:55:40','',''),('1','312',2255,'','20','3',2160.00,0.00,'Retail Sale Id 1049 for 3.00 KG of Cooking Gas @ N720.00','2023-03-16 11:27:44','',''),('1','312',2256,'','6.1','4',0.00,2160.00,'Retail Sale Id 1049 for retail product','2023-03-16 11:27:44','',''),('1','312',2257,'','20','3',3600.00,0.00,'Retail Sale Id 1050 for 5.00 KG of Cooking Gas @ N720.00','2023-03-16 11:38:18','',''),('1','312',2258,'','6.1','4',0.00,3600.00,'Retail Sale Id 1050 for retail product','2023-03-16 11:38:18','',''),('1','312',2259,'','20','3',6480.00,0.00,'Retail Sale Id 1051 for 9.00 KG of Cooking Gas @ N720.00','2023-03-16 11:51:41','',''),('1','312',2260,'','6.1','4',0.00,6480.00,'Retail Sale Id 1051 for retail product','2023-03-16 11:51:41','',''),('1','312',2261,'','2','20',290500.00,0.00,'Payment Id 64 for invoice:33, receipt: p o s by AA RANO NIGERIA LTD','2023-03-16 11:57:27','',''),('1','312',2262,'','supplier','1',0.00,290500.00,'Payment Id 64 for invoice:33, receipt: p o s by AA RANO NIGERIA LTD','2023-03-16 11:57:27','',''),('1','312',2263,'','20','3',3600.00,0.00,'Retail Sale Id 1052 for 5.00 KG of Cooking Gas @ N720.00','2023-03-16 12:00:33','',''),('1','312',2264,'','6.1','4',0.00,3600.00,'Retail Sale Id 1052 for retail product','2023-03-16 12:00:33','',''),('1','312',2265,'','20','3',1440.00,0.00,'Retail Sale Id 1053 for 2.00 KG of Cooking Gas @ N720.00','2023-03-16 12:03:36','',''),('1','312',2266,'','6.1','4',0.00,1440.00,'Retail Sale Id 1053 for retail product','2023-03-16 12:03:36','',''),('1','312',2267,'','20','3',3600.00,0.00,'Retail Sale Id 1054 for 5.00 KG of Cooking Gas @ N720.00','2023-03-16 12:05:44','',''),('1','312',2268,'','6.1','4',0.00,3600.00,'Retail Sale Id 1054 for retail product','2023-03-16 12:05:44','',''),('1','312',2269,'','20','3',0.00,1440.00,'Return of Retail Sale Id 1053 for products','2023-03-16 13:13:42','',''),('1','312',2270,'','','',1440.00,0.00,'Return of Retail Sale Id 1053 for products','2023-03-16 13:13:42','',''),('1','312',2271,'','20','3',9000.00,0.00,'Retail Sale Id 1055 for 12.50 KG of Cooking Gas @ N720.00','2023-03-16 13:14:52','',''),('1','312',2272,'','6.1','4',0.00,9000.00,'Retail Sale Id 1055 for retail product','2023-03-16 13:14:52','',''),('1','312',2273,'','20','3',1440.00,0.00,'Retail Sale Id 1056 for 2.00 KG of Cooking Gas @ N720.00','2023-03-16 13:16:23','',''),('1','312',2274,'','6.1','4',0.00,1440.00,'Retail Sale Id 1056 for retail product','2023-03-16 13:16:23','',''),('1','312',2275,'','20','3',9000.00,0.00,'Retail Sale Id 1057 for 12.50 KG of Cooking Gas @ N720.00','2023-03-16 13:34:05','',''),('1','312',2276,'','6.1','4',0.00,9000.00,'Retail Sale Id 1057 for retail product','2023-03-16 13:34:05','',''),('1','312',2277,'','20','3',7920.00,0.00,'Retail Sale Id 1058 for 11.00 KG of Cooking Gas @ N720.00','2023-03-16 14:16:44','',''),('1','312',2278,'','6.1','4',0.00,7920.00,'Retail Sale Id 1058 for retail product','2023-03-16 14:16:44','',''),('1','312',2279,'','20','3',4320.00,0.00,'Retail Sale Id 1059 for 6.00 KG of Cooking Gas @ N720.00','2023-03-16 14:18:22','',''),('1','312',2280,'','6.1','4',0.00,4320.00,'Retail Sale Id 1059 for retail product','2023-03-16 14:18:22','',''),('1','312',2281,'','20','3',2880.00,0.00,'Retail Sale Id 1060 for 4.00 KG of Cooking Gas @ N720.00','2023-03-16 15:52:58','',''),('1','312',2282,'','6.1','4',0.00,2880.00,'Retail Sale Id 1060 for retail product','2023-03-16 15:52:58','',''),('1','312',2283,'','20','3',9000.00,0.00,'Retail Sale Id 1061 for 12.50 KG of Cooking Gas @ N720.00','2023-03-16 15:54:07','',''),('1','312',2284,'','6.1','4',0.00,9000.00,'Retail Sale Id 1061 for retail product','2023-03-16 15:54:07','',''),('1','312',2285,'','20','3',8640.00,0.00,'Retail Sale Id 1062 for 12.00 KG of Cooking Gas @ N720.00','2023-03-16 15:55:55','',''),('1','312',2286,'','6.1','4',0.00,8640.00,'Retail Sale Id 1062 for retail product','2023-03-16 15:55:55','',''),('1','312',2287,'','20','3',10800.00,0.00,'Retail Sale Id 1063 for 15.00 KG of Cooking Gas @ N720.00','2023-03-16 15:57:23','',''),('1','312',2288,'','6.1','4',0.00,10800.00,'Retail Sale Id 1063 for retail product','2023-03-16 15:57:23','',''),('1','312',2289,'','20','3',9000.00,0.00,'Retail Sale Id 1064 for 12.50 KG of Cooking Gas @ N720.00','2023-03-16 15:58:34','',''),('1','312',2290,'','6.1','4',0.00,9000.00,'Retail Sale Id 1064 for retail product','2023-03-16 15:58:34','',''),('1','312',2291,'','20','3',2296.80,0.00,'Retail Sale Id 1065 for 3.19 KG of Cooking Gas @ N720.00','2023-03-16 16:01:41','',''),('1','312',2292,'','6.1','4',0.00,2296.80,'Retail Sale Id 1065 for retail product','2023-03-16 16:01:41','',''),('1','312',2293,'','20','3',5760.00,0.00,'Retail Sale Id 1066 for 8.00 KG of Cooking Gas @ N720.00','2023-03-16 16:38:29','',''),('1','312',2294,'','6.1','4',0.00,5760.00,'Retail Sale Id 1066 for retail product','2023-03-16 16:38:29','',''),('1','312',2295,'','20','3',1440.00,0.00,'Retail Sale Id 1067 for 2.00 KG of Cooking Gas @ N720.00','2023-03-16 16:39:55','',''),('1','312',2296,'','6.1','4',0.00,1440.00,'Retail Sale Id 1067 for retail product','2023-03-16 16:39:55','',''),('1','312',2297,'','20','3',6480.00,0.00,'Retail Sale Id 1068 for 9.00 KG of Cooking Gas @ N720.00','2023-03-16 16:55:37','',''),('1','312',2298,'','6.1','4',0.00,6480.00,'Retail Sale Id 1068 for retail product','2023-03-16 16:55:37','',''),('1','312',2299,'','20','3',2160.00,0.00,'Retail Sale Id 1069 for 3.00 KG of Cooking Gas @ N720.00','2023-03-16 16:58:33','',''),('1','312',2300,'','6.1','4',0.00,2160.00,'Retail Sale Id 1069 for retail product','2023-03-16 16:58:33','',''),('1','312',2301,'','20','3',7200.00,0.00,'Retail Sale Id 1070 for 10.00 KG of Cooking Gas @ N720.00','2023-03-16 17:10:36','',''),('1','312',2302,'','6.1','4',0.00,7200.00,'Retail Sale Id 1070 for retail product','2023-03-16 17:10:36','',''),('1','312',2303,'','20','3',3600.00,0.00,'Retail Sale Id 1071 for 5.00 KG of Cooking Gas @ N720.00','2023-03-16 17:23:20','',''),('1','312',2304,'','6.1','4',0.00,3600.00,'Retail Sale Id 1071 for retail product','2023-03-16 17:23:20','',''),('1','312',2305,'','20','3',2880.00,0.00,'Retail Sale Id 1072 for 4.00 KG of Cooking Gas @ N720.00','2023-03-16 17:56:33','',''),('1','312',2306,'','6.1','4',0.00,2880.00,'Retail Sale Id 1072 for retail product','2023-03-16 17:56:33','',''),('1','312',2307,'','20','3',1440.00,0.00,'Retail Sale Id 1074 for 2.00 KG of Cooking Gas @ N720.00','2023-03-16 18:04:06','',''),('1','312',2308,'','6.1','4',0.00,1440.00,'Retail Sale Id 1074 for retail product','2023-03-16 18:04:06','',''),('1','312',2309,'','20','3',2000.00,0.00,'Retail Sale Id 1075 for 2.78 KG of Cooking Gas @ N720.00','2023-03-16 18:45:50','',''),('1','312',2310,'','6.1','4',0.00,2000.00,'Retail Sale Id 1075 for retail product','2023-03-16 18:45:50','',''),('1','312',2311,'','20','3',1440.00,0.00,'Retail Sale Id 1076 for 2.00 KG of Cooking Gas @ N720.00','2023-03-16 18:47:20','',''),('1','312',2312,'','6.1','4',0.00,1440.00,'Retail Sale Id 1076 for retail product','2023-03-16 18:47:20','',''),('1','312',2313,'','20','3',2160.00,0.00,'Retail Sale Id 1077 for 3.00 KG of Cooking Gas @ N720.00','2023-03-16 18:48:26','',''),('1','312',2314,'','6.1','4',0.00,2160.00,'Retail Sale Id 1077 for retail product','2023-03-16 18:48:26','',''),('1','312',2315,'','20','3',0.00,1440.00,'Return of Retail Sale Id 1076 for products','2023-03-16 19:06:55','',''),('1','312',2316,'','','',1440.00,0.00,'Return of Retail Sale Id 1076 for products','2023-03-16 19:06:55','',''),('1','312',2317,'','20','3',1944.00,0.00,'Retail Sale Id 1078 for 2.70 KG of Cooking Gas @ N720.00','2023-03-16 19:08:51','',''),('1','312',2318,'','6.1','4',0.00,1944.00,'Retail Sale Id 1078 for retail product','2023-03-16 19:08:51','',''),('1','312',2319,'','20','3',0.00,0.00,'Sales from shift 35 on 2023-03-16 19:26:42 ','2023-03-16 19:26:42','',''),('1','312',2320,'','6.1','4',0.00,0.00,'Sales from shift 35 on 2023-03-16 19:26:42 ','2023-03-16 19:26:42','',''),('1','312',2321,'','20','3',2880.00,0.00,'Retail Sale Id 1079 for 4.00 KG of Cooking Gas @ N720.00','2023-03-17 07:27:52','',''),('1','312',2322,'','6.1','4',0.00,2880.00,'Retail Sale Id 1079 for retail product','2023-03-17 07:27:52','',''),('1','312',2323,'','20','3',2160.00,0.00,'Retail Sale Id 1080 for 3.00 KG of Cooking Gas @ N720.00','2023-03-17 07:30:51','',''),('1','312',2324,'','6.1','4',0.00,2160.00,'Retail Sale Id 1080 for retail product','2023-03-17 07:30:51','',''),('1','312',2325,'','20','3',4320.00,0.00,'Retail Sale Id 1081 for 6.00 KG of Cooking Gas @ N720.00','2023-03-17 08:02:49','',''),('1','312',2326,'','6.1','4',0.00,4320.00,'Retail Sale Id 1081 for retail product','2023-03-17 08:02:49','',''),('1','312',2327,'','20','3',2160.00,0.00,'Retail Sale Id 1082 for 3.00 KG of Cooking Gas @ N720.00','2023-03-17 08:28:27','',''),('1','312',2328,'','6.1','4',0.00,2160.00,'Retail Sale Id 1082 for retail product','2023-03-17 08:28:27','',''),('1','312',2329,'','20','3',6000.00,0.00,'Retail Sale Id 1083 for 8.33 KG of Cooking Gas @ N720.00','2023-03-17 08:36:38','',''),('1','312',2330,'','6.1','4',0.00,6000.00,'Retail Sale Id 1083 for retail product','2023-03-17 08:36:38','',''),('1','312',2331,'','20','3',7200.00,0.00,'Retail Sale Id 1084 for 10.00 KG of Cooking Gas @ N720.00','2023-03-17 08:39:58','',''),('1','312',2332,'','6.1','4',0.00,7200.00,'Retail Sale Id 1084 for retail product','2023-03-17 08:39:58','',''),('1','312',2333,'','20','3',1500.00,0.00,'Retail Sale Id 1086 for 2.08 KG of Cooking Gas @ N720.00','2023-03-17 09:02:45','',''),('1','312',2334,'','6.1','4',0.00,1500.00,'Retail Sale Id 1086 for retail product','2023-03-17 09:02:45','',''),('1','312',2335,'','20','3',4350.00,0.00,'Retail Sale Id 1087 for 6.04 KG of Cooking Gas @ N720.00','2023-03-17 09:04:33','',''),('1','312',2336,'','6.1','4',0.00,4350.00,'Retail Sale Id 1087 for retail product','2023-03-17 09:04:33','',''),('1','312',2337,'','20','3',4320.00,0.00,'Retail Sale Id 1088 for 6.00 KG of Cooking Gas @ N720.00','2023-03-17 09:16:58','',''),('1','312',2338,'','6.1','4',0.00,4320.00,'Retail Sale Id 1088 for retail product','2023-03-17 09:16:58','',''),('1','312',2339,'','20','3',7200.00,0.00,'Retail Sale Id 1089 for 10.00 KG of Cooking Gas @ N720.00','2023-03-17 09:19:59','',''),('1','312',2340,'','6.1','4',0.00,7200.00,'Retail Sale Id 1089 for retail product','2023-03-17 09:19:59','',''),('1','312',2341,'','20','3',4320.00,0.00,'Retail Sale Id 1090 for 6.00 KG of Cooking Gas @ N720.00','2023-03-17 09:32:41','',''),('1','312',2342,'','6.1','4',0.00,4320.00,'Retail Sale Id 1090 for retail product','2023-03-17 09:32:41','',''),('1','312',2343,'','20','3',2160.00,0.00,'Retail Sale Id 1091 for 3.00 KG of Cooking Gas @ N720.00','2023-03-17 09:38:19','',''),('1','312',2344,'','6.1','4',0.00,2160.00,'Retail Sale Id 1091 for retail product','2023-03-17 09:38:19','',''),('1','312',2345,'','20','3',4320.00,0.00,'Retail Sale Id 1092 for 6.00 KG of Cooking Gas @ N720.00','2023-03-17 09:42:12','',''),('1','312',2346,'','6.1','4',0.00,4320.00,'Retail Sale Id 1092 for retail product','2023-03-17 09:42:12','',''),('1','312',2347,'','20','3',5040.00,0.00,'Retail Sale Id 1093 for 7.00 KG of Cooking Gas @ N720.00','2023-03-17 09:56:15','',''),('1','312',2348,'','6.1','4',0.00,5040.00,'Retail Sale Id 1093 for retail product','2023-03-17 09:56:15','',''),('1','312',2349,'','20','3',3600.00,0.00,'Retail Sale Id 1094 for 5.00 KG of Cooking Gas @ N720.00','2023-03-17 10:07:31','',''),('1','312',2350,'','6.1','4',0.00,3600.00,'Retail Sale Id 1094 for retail product','2023-03-17 10:07:31','',''),('1','312',2351,'','20','3',7920.00,0.00,'Retail Sale Id 1095 for 11.00 KG of Cooking Gas @ N720.00','2023-03-17 10:22:16','',''),('1','312',2352,'','6.1','4',0.00,7920.00,'Retail Sale Id 1095 for retail product','2023-03-17 10:22:16','',''),('1','312',2353,'','2','20',98060.00,0.00,'Payment Id 67 for invoice:34, receipt: 000 by AA RANO NIGERIA LTD','2023-03-17 10:33:00','',''),('1','312',2354,'','supplier','1',0.00,98060.00,'Payment Id 67 for invoice:34, receipt: 000 by AA RANO NIGERIA LTD','2023-03-17 10:33:00','',''),('1','312',2355,'','20','3',2160.00,0.00,'Retail Sale Id 1096 for 3.00 KG of Cooking Gas @ N720.00','2023-03-17 10:34:16','',''),('1','312',2356,'','6.1','4',0.00,2160.00,'Retail Sale Id 1096 for retail product','2023-03-17 10:34:16','',''),('1','312',2357,'','20','3',1000.00,0.00,'Retail Sale Id 1097 for 1.39 KG of Cooking Gas @ N720.00','2023-03-17 10:44:00','',''),('1','312',2358,'','6.1','4',0.00,1000.00,'Retail Sale Id 1097 for retail product','2023-03-17 10:44:00','',''),('1','312',2359,'','20','3',3600.00,0.00,'Retail Sale Id 1098 for 5.00 KG of Cooking Gas @ N720.00','2023-03-17 10:59:08','',''),('1','312',2360,'','6.1','4',0.00,3600.00,'Retail Sale Id 1098 for retail product','2023-03-17 10:59:08','',''),('1','312',2361,'','20','3',8640.00,0.00,'Retail Sale Id 1099 for 12.00 KG of Cooking Gas @ N720.00','2023-03-17 11:02:08','',''),('1','312',2362,'','6.1','4',0.00,8640.00,'Retail Sale Id 1099 for retail product','2023-03-17 11:02:08','',''),('1','312',2363,'','20','3',7920.00,0.00,'Retail Sale Id 1100 for 11.00 KG of Cooking Gas @ N720.00','2023-03-17 11:04:09','',''),('1','312',2364,'','6.1','4',0.00,7920.00,'Retail Sale Id 1100 for retail product','2023-03-17 11:04:09','',''),('1','312',2365,'','20','3',2880.00,0.00,'Retail Sale Id 1101 for 4.00 KG of Cooking Gas @ N720.00','2023-03-17 11:08:34','',''),('1','312',2366,'','6.1','4',0.00,2880.00,'Retail Sale Id 1101 for retail product','2023-03-17 11:08:34','',''),('1','312',2367,'','20','3',9000.00,0.00,'Retail Sale Id 1102 for 12.50 KG of Cooking Gas @ N720.00','2023-03-17 11:15:31','',''),('1','312',2368,'','6.1','4',0.00,9000.00,'Retail Sale Id 1102 for retail product','2023-03-17 11:15:31','',''),('1','312',2369,'','20','3',7200.00,0.00,'Retail Sale Id 1103 for 10.00 KG of Cooking Gas @ N720.00','2023-03-17 11:17:13','',''),('1','312',2370,'','6.1','4',0.00,7200.00,'Retail Sale Id 1103 for retail product','2023-03-17 11:17:13','',''),('1','312',2371,'','20','3',81600.00,0.00,'Retail Sale Id 1104 for 120.00 KG of Cooking Gas @ N680.00','2023-03-17 11:22:36','',''),('1','312',2372,'','6.1','4',0.00,81600.00,'Retail Sale Id 1104 for retail product','2023-03-17 11:22:36','',''),('1','312',2373,'','20','3',4680.00,0.00,'Retail Sale Id 1105 for 6.50 KG of Cooking Gas @ N720.00','2023-03-17 12:22:06','',''),('1','312',2374,'','6.1','4',0.00,4680.00,'Retail Sale Id 1105 for retail product','2023-03-17 12:22:06','',''),('1','312',2375,'','20','3',4320.00,0.00,'Retail Sale Id 1106 for 6.00 KG of Cooking Gas @ N720.00','2023-03-17 12:37:20','',''),('1','312',2376,'','6.1','4',0.00,4320.00,'Retail Sale Id 1106 for retail product','2023-03-17 12:37:20','',''),('1','312',2377,'','20','3',11160.00,0.00,'Retail Sale Id 1107 for 15.50 KG of Cooking Gas @ N720.00','2023-03-17 12:48:12','',''),('1','312',2378,'','6.1','4',0.00,11160.00,'Retail Sale Id 1107 for retail product','2023-03-17 12:48:12','',''),('1','312',2379,'','20','3',4320.00,0.00,'Retail Sale Id 1108 for 6.00 KG of Cooking Gas @ N720.00','2023-03-17 13:05:29','',''),('1','312',2380,'','6.1','4',0.00,4320.00,'Retail Sale Id 1108 for retail product','2023-03-17 13:05:29','',''),('1','312',2381,'','20','3',3600.00,0.00,'Retail Sale Id 1109 for 5.00 KG of Cooking Gas @ N720.00','2023-03-17 13:41:56','',''),('1','312',2382,'','6.1','4',0.00,3600.00,'Retail Sale Id 1109 for retail product','2023-03-17 13:41:56','',''),('1','312',2383,'','20','3',7200.00,0.00,'Retail Sale Id 1110 for 10.00 KG of Cooking Gas @ N720.00','2023-03-17 14:02:24','',''),('1','312',2384,'','6.1','4',0.00,7200.00,'Retail Sale Id 1110 for retail product','2023-03-17 14:02:24','',''),('1','312',2385,'','20','3',5040.00,0.00,'Retail Sale Id 1111 for 7.00 KG of Cooking Gas @ N720.00','2023-03-17 14:20:38','',''),('1','312',2386,'','6.1','4',0.00,5040.00,'Retail Sale Id 1111 for retail product','2023-03-17 14:20:38','',''),('1','312',2387,'','2','8',5600.00,0.00,'Payment Id 72 for invoice:35, receipt: p o s by AA RANO NIGERIA LTD','2023-03-17 14:22:15','',''),('1','312',2388,'','supplier','1',0.00,5600.00,'Payment Id 72 for invoice:35, receipt: p o s by AA RANO NIGERIA LTD','2023-03-17 14:22:15','',''),('1','312',2389,'','2','20',197270.00,0.00,'Payment Id 71 for invoice:35, receipt: p o s by AA RANO NIGERIA LTD','2023-03-17 14:22:15','',''),('1','312',2390,'','supplier','1',0.00,197270.00,'Payment Id 71 for invoice:35, receipt: p o s by AA RANO NIGERIA LTD','2023-03-17 14:22:15','',''),('1','312',2391,'','2','8',31380.00,0.00,'Payment Id 68 for invoice:34, receipt: p o s by AA RANO NIGERIA LTD','2023-03-17 14:37:54','',''),('1','312',2392,'','supplier','1',0.00,31380.00,'Payment Id 68 for invoice:34, receipt: p o s by AA RANO NIGERIA LTD','2023-03-17 14:37:54','',''),('1','312',2393,'','20','3',28800.00,0.00,'Retail Sale Id 1112 for 40.00 KG of Cooking Gas @ N720.00','2023-03-17 14:40:02','',''),('1','312',2394,'','6.1','4',0.00,28800.00,'Retail Sale Id 1112 for retail product','2023-03-17 14:40:02','',''),('1','312',2395,'','20','3',7200.00,0.00,'Retail Sale Id 1113 for 10.00 KG of Cooking Gas @ N720.00','2023-03-17 14:51:59','',''),('1','312',2396,'','6.1','4',0.00,7200.00,'Retail Sale Id 1113 for retail product','2023-03-17 14:51:59','',''),('1','312',2397,'','20','3',0.00,5040.00,'Return of Retail Sale Id 1111 for products','2023-03-17 14:53:00','',''),('1','312',2398,'','','',5040.00,0.00,'Return of Retail Sale Id 1111 for products','2023-03-17 14:53:00','',''),('1','312',2399,'','20','3',3103.20,0.00,'Retail Sale Id 1114 for 4.31 KG of Cooking Gas @ N720.00','2023-03-17 14:54:12','',''),('1','312',2400,'','6.1','4',0.00,3103.20,'Retail Sale Id 1114 for retail product','2023-03-17 14:54:12','',''),('1','312',2401,'','20','3',7200.00,0.00,'Retail Sale Id 1115 for 10.00 KG of Cooking Gas @ N720.00','2023-03-17 15:07:44','',''),('1','312',2402,'','6.1','4',0.00,7200.00,'Retail Sale Id 1115 for retail product','2023-03-17 15:07:44','',''),('1','312',2403,'','20','3',5040.00,0.00,'Retail Sale Id 1116 for 7.00 KG of Cooking Gas @ N720.00','2023-03-17 15:23:53','',''),('1','312',2404,'','6.1','4',0.00,5040.00,'Retail Sale Id 1116 for retail product','2023-03-17 15:23:53','',''),('1','312',2405,'','20','3',12240.00,0.00,'Retail Sale Id 1117 for 17.00 KG of Cooking Gas @ N720.00','2023-03-17 15:26:08','',''),('1','312',2406,'','6.1','4',0.00,12240.00,'Retail Sale Id 1117 for retail product','2023-03-17 15:26:08','',''),('1','312',2407,'','20','3',2160.00,0.00,'Retail Sale Id 1118 for 3.00 KG of Cooking Gas @ N720.00','2023-03-17 16:12:06','',''),('1','312',2408,'','6.1','4',0.00,2160.00,'Retail Sale Id 1118 for retail product','2023-03-17 16:12:06','',''),('1','312',2409,'','20','3',4680.00,0.00,'Retail Sale Id 1119 for 6.50 KG of Cooking Gas @ N720.00','2023-03-17 16:15:08','',''),('1','312',2410,'','6.1','4',0.00,4680.00,'Retail Sale Id 1119 for retail product','2023-03-17 16:15:08','',''),('1','312',2411,'','20','3',18000.00,0.00,'Retail Sale Id 1120 for 25.00 KG of Cooking Gas @ N720.00','2023-03-17 16:21:26','',''),('1','312',2412,'','6.1','4',0.00,18000.00,'Retail Sale Id 1120 for retail product','2023-03-17 16:21:26','',''),('1','312',2413,'','20','3',5040.00,0.00,'Retail Sale Id 1121 for 7.00 KG of Cooking Gas @ N720.00','2023-03-17 16:38:20','',''),('1','312',2414,'','6.1','4',0.00,5040.00,'Retail Sale Id 1121 for retail product','2023-03-17 16:38:20','',''),('1','312',2415,'','20','3',13320.00,0.00,'Retail Sale Id 1122 for 18.50 KG of Cooking Gas @ N720.00','2023-03-17 16:40:33','',''),('1','312',2416,'','6.1','4',0.00,13320.00,'Retail Sale Id 1122 for retail product','2023-03-17 16:40:33','',''),('1','312',2417,'','20','3',7200.00,0.00,'Retail Sale Id 1123 for 10.00 KG of Cooking Gas @ N720.00','2023-03-17 16:41:46','',''),('1','312',2418,'','6.1','4',0.00,7200.00,'Retail Sale Id 1123 for retail product','2023-03-17 16:41:46','',''),('1','312',2419,'','20','3',2880.00,0.00,'Retail Sale Id 1124 for 4.00 KG of Cooking Gas @ N720.00','2023-03-17 16:50:10','',''),('1','312',2420,'','6.1','4',0.00,2880.00,'Retail Sale Id 1124 for retail product','2023-03-17 16:50:10','',''),('1','312',2421,'','20','3',2040.00,0.00,'Retail Sale Id 1126 for 3.00 KG of Cooking Gas @ N680.00','2023-03-17 16:57:31','',''),('1','312',2422,'','6.1','4',0.00,2040.00,'Retail Sale Id 1126 for retail product','2023-03-17 16:57:31','',''),('1','312',2423,'','20','3',7200.00,0.00,'Retail Sale Id 1127 for 10.00 KG of Cooking Gas @ N720.00','2023-03-17 17:09:17','',''),('1','312',2424,'','6.1','4',0.00,7200.00,'Retail Sale Id 1127 for retail product','2023-03-17 17:09:17','',''),('1','312',2425,'','20','3',9000.00,0.00,'Retail Sale Id 1128 for 12.50 KG of Cooking Gas @ N720.00','2023-03-17 17:11:27','',''),('1','312',2426,'','6.1','4',0.00,9000.00,'Retail Sale Id 1128 for retail product','2023-03-17 17:11:27','',''),('1','312',2427,'','20','3',9000.00,0.00,'Retail Sale Id 1129 for 12.50 KG of Cooking Gas @ N720.00','2023-03-17 17:30:53','',''),('1','312',2428,'','6.1','4',0.00,9000.00,'Retail Sale Id 1129 for retail product','2023-03-17 17:30:53','',''),('1','312',2429,'','20','3',7200.00,0.00,'Retail Sale Id 1130 for 10.00 KG of Cooking Gas @ N720.00','2023-03-17 17:35:03','',''),('1','312',2430,'','6.1','4',0.00,7200.00,'Retail Sale Id 1130 for retail product','2023-03-17 17:35:03','',''),('1','312',2431,'','20','3',720.00,0.00,'Retail Sale Id 1138 for 1.00 KG of Cooking Gas @ N720.00','2023-03-17 17:37:17','',''),('1','312',2432,'','6.1','4',0.00,720.00,'Retail Sale Id 1138 for retail product','2023-03-17 17:37:17','',''),('1','312',2433,'','20','3',2160.00,0.00,'Retail Sale Id 1139 for 3.00 KG of Cooking Gas @ N720.00','2023-03-17 17:43:09','',''),('1','312',2434,'','6.1','4',0.00,2160.00,'Retail Sale Id 1139 for retail product','2023-03-17 17:43:09','',''),('1','312',2435,'','20','3',1440.00,0.00,'Retail Sale Id 1142 for 2.00 KG of Cooking Gas @ N720.00','2023-03-17 17:58:42','',''),('1','312',2436,'','6.1','4',0.00,1440.00,'Retail Sale Id 1142 for retail product','2023-03-17 17:58:42','',''),('1','312',2437,'','20','3',9000.00,0.00,'Retail Sale Id 1143 for 12.50 KG of Cooking Gas @ N720.00','2023-03-17 18:09:20','',''),('1','312',2438,'','6.1','4',0.00,9000.00,'Retail Sale Id 1143 for retail product','2023-03-17 18:09:20','',''),('1','312',2439,'','20','3',2160.00,0.00,'Retail Sale Id 1144 for 3.00 KG of Cooking Gas @ N720.00','2023-03-17 18:16:11','',''),('1','312',2440,'','6.1','4',0.00,2160.00,'Retail Sale Id 1144 for retail product','2023-03-17 18:16:11','',''),('1','312',2441,'','20','3',3600.00,0.00,'Retail Sale Id 1145 for 5.00 KG of Cooking Gas @ N720.00','2023-03-17 18:17:13','',''),('1','312',2442,'','6.1','4',0.00,3600.00,'Retail Sale Id 1145 for retail product','2023-03-17 18:17:13','',''),('1','312',2443,'','20','3',11160.00,0.00,'Retail Sale Id 1146 for 15.50 KG of Cooking Gas @ N720.00','2023-03-17 18:18:53','',''),('1','312',2444,'','6.1','4',0.00,11160.00,'Retail Sale Id 1146 for retail product','2023-03-17 18:18:53','',''),('1','312',2445,'','20','3',1600.00,0.00,'Retail Sale Id 1147 for 2.22 KG of Cooking Gas @ N720.00','2023-03-17 18:23:51','',''),('1','312',2446,'','6.1','4',0.00,1600.00,'Retail Sale Id 1147 for retail product','2023-03-17 18:23:51','',''),('1','312',2447,'','20','3',30600.00,0.00,'Retail Sale Id 1148 for 45.00 KG of Cooking Gas @ N680.00','2023-03-17 18:40:34','',''),('1','312',2448,'','6.1','4',0.00,30600.00,'Retail Sale Id 1148 for retail product','2023-03-17 18:40:34','',''),('1','312',2449,'','20','3',5000.00,0.00,'Retail Sale Id 1149 for 6.94 KG of Cooking Gas @ N720.00','2023-03-17 18:43:06','',''),('1','312',2450,'','6.1','4',0.00,5000.00,'Retail Sale Id 1149 for retail product','2023-03-17 18:43:06','',''),('1','312',2451,'','20','3',12600.00,0.00,'Retail Sale Id 1150 for 17.50 KG of Cooking Gas @ N720.00','2023-03-17 18:44:47','',''),('1','312',2452,'','6.1','4',0.00,12600.00,'Retail Sale Id 1150 for retail product','2023-03-17 18:44:47','',''),('1','312',2453,'','20','3',1500.00,0.00,'Retail Sale Id 1151 for 2.08 KG of Cooking Gas @ N720.00','2023-03-17 18:46:07','',''),('1','312',2454,'','6.1','4',0.00,1500.00,'Retail Sale Id 1151 for retail product','2023-03-17 18:46:07','',''),('1','312',2455,'','20','3',2851.20,0.00,'Retail Sale Id 1152 for 3.96 KG of Cooking Gas @ N720.00','2023-03-17 19:01:50','',''),('1','312',2456,'','6.1','4',0.00,2851.20,'Retail Sale Id 1152 for retail product','2023-03-17 19:01:50','',''),('1','312',2457,'','20','3',0.00,2040.00,'Return of Retail Sale Id 1126 for products','2023-03-17 19:10:37','',''),('1','312',2458,'','','',2040.00,0.00,'Return of Retail Sale Id 1126 for products','2023-03-17 19:10:37','',''),('1','312',2459,'','20','3',0.00,30600.00,'Return of Retail Sale Id 1148 for products','2023-03-17 19:13:00','',''),('1','312',2460,'','','',30600.00,0.00,'Return of Retail Sale Id 1148 for products','2023-03-17 19:13:00','',''),('1','312',2461,'','20','3',32204.80,0.00,'Retail Sale Id 1153 for 47.36 KG of Cooking Gas @ N680.00','2023-03-17 19:14:45','',''),('1','312',2462,'','6.1','4',0.00,32204.80,'Retail Sale Id 1153 for retail product','2023-03-17 19:14:45','',''),('1','312',2463,'','20','3',0.00,0.00,'Sales from shift 36 on 2023-03-17 20:12:44 ','2023-03-17 20:12:44','',''),('1','312',2464,'','6.1','4',0.00,0.00,'Sales from shift 36 on 2023-03-17 20:12:44 ','2023-03-17 20:12:44','',''),('1','312',2465,'','20','3',3600.00,0.00,'Retail Sale Id 1154 for 5.00 KG of Cooking Gas @ N720.00','2023-03-19 10:21:18','',''),('1','312',2466,'','6.1','4',0.00,3600.00,'Retail Sale Id 1154 for retail product','2023-03-19 10:21:18','',''),('1','312',2467,'','20','3',5040.00,0.00,'Retail Sale Id 1155 for 7.00 KG of Cooking Gas @ N720.00','2023-03-19 10:22:38','',''),('1','312',2468,'','6.1','4',0.00,5040.00,'Retail Sale Id 1155 for retail product','2023-03-19 10:22:38','',''),('1','312',2469,'','20','3',9000.00,0.00,'Retail Sale Id 1156 for 12.50 KG of Cooking Gas @ N720.00','2023-03-19 10:24:00','',''),('1','312',2470,'','6.1','4',0.00,9000.00,'Retail Sale Id 1156 for retail product','2023-03-19 10:24:00','',''),('1','312',2471,'','20','3',10800.00,0.00,'Retail Sale Id 1157 for 15.00 KG of Cooking Gas @ N720.00','2023-03-19 10:25:10','',''),('1','312',2472,'','6.1','4',0.00,10800.00,'Retail Sale Id 1157 for retail product','2023-03-19 10:25:10','',''),('1','312',2473,'','20','3',2160.00,0.00,'Retail Sale Id 1158 for 3.00 KG of Cooking Gas @ N720.00','2023-03-19 10:26:22','',''),('1','312',2474,'','6.1','4',0.00,2160.00,'Retail Sale Id 1158 for retail product','2023-03-19 10:26:22','',''),('1','312',2475,'','20','3',2160.00,0.00,'Retail Sale Id 1159 for 3.00 KG of Cooking Gas @ N720.00','2023-03-19 10:27:56','',''),('1','312',2476,'','6.1','4',0.00,2160.00,'Retail Sale Id 1159 for retail product','2023-03-19 10:27:56','',''),('1','312',2477,'','6.1','4',0.00,2160.00,'Retail Sale Id 1159 for retail product','2023-03-19 10:27:56','',''),('1','312',2478,'','20','3',2880.00,0.00,'Retail Sale Id 1160 for 4.00 KG of Cooking Gas @ N720.00','2023-03-19 10:29:31','',''),('1','312',2479,'','6.1','4',0.00,2880.00,'Retail Sale Id 1160 for retail product','2023-03-19 10:29:31','',''),('1','312',2480,'','6.1','4',0.00,2880.00,'Retail Sale Id 1160 for retail product','2023-03-19 10:29:31','',''),('1','312',2481,'','20','3',13320.00,0.00,'Retail Sale Id 1161 for 18.50 KG of Cooking Gas @ N720.00','2023-03-19 10:32:09','',''),('1','312',2482,'','6.1','4',0.00,13320.00,'Retail Sale Id 1161 for retail product','2023-03-19 10:32:09','',''),('1','312',2483,'','20','3',7200.00,0.00,'Retail Sale Id 1162 for 10.00 KG of Cooking Gas @ N720.00','2023-03-19 10:34:23','',''),('1','312',2484,'','6.1','4',0.00,7200.00,'Retail Sale Id 1162 for retail product','2023-03-19 10:34:23','',''),('1','312',2485,'','20','3',2000.00,0.00,'Retail Sale Id 1163 for 2.78 KG of Cooking Gas @ N720.00','2023-03-19 10:36:06','',''),('1','312',2486,'','6.1','4',0.00,2000.00,'Retail Sale Id 1163 for retail product','2023-03-19 10:36:06','',''),('1','312',2487,'','20','3',8000.00,0.00,'Retail Sale Id 1164 for 11.11 KG of Cooking Gas @ N720.00','2023-03-19 10:37:32','',''),('1','312',2488,'','6.1','4',0.00,8000.00,'Retail Sale Id 1164 for retail product','2023-03-19 10:37:32','',''),('1','312',2489,'','20','3',6480.00,0.00,'Retail Sale Id 1165 for 9.00 KG of Cooking Gas @ N720.00','2023-03-19 12:00:48','',''),('1','312',2490,'','6.1','4',0.00,6480.00,'Retail Sale Id 1165 for retail product','2023-03-19 12:00:48','',''),('1','312',2491,'','20','3',3960.00,0.00,'Retail Sale Id 1166 for 5.50 KG of Cooking Gas @ N720.00','2023-03-19 12:02:06','',''),('1','312',2492,'','6.1','4',0.00,3960.00,'Retail Sale Id 1166 for retail product','2023-03-19 12:02:06','',''),('1','312',2493,'','20','3',9000.00,0.00,'Retail Sale Id 1167 for 12.50 KG of Cooking Gas @ N720.00','2023-03-19 12:03:11','',''),('1','312',2494,'','6.1','4',0.00,9000.00,'Retail Sale Id 1167 for retail product','2023-03-19 12:03:11','',''),('1','312',2495,'','20','3',3000.00,0.00,'Retail Sale Id 1168 for 4.17 KG of Cooking Gas @ N720.00','2023-03-19 12:04:45','',''),('1','312',2496,'','6.1','4',0.00,3000.00,'Retail Sale Id 1168 for retail product','2023-03-19 12:04:45','',''),('1','312',2497,'','20','3',9000.00,0.00,'Retail Sale Id 1169 for 12.50 KG of Cooking Gas @ N720.00','2023-03-19 12:05:43','',''),('1','312',2498,'','6.1','4',0.00,9000.00,'Retail Sale Id 1169 for retail product','2023-03-19 12:05:43','',''),('1','312',2499,'','20','3',2160.00,0.00,'Retail Sale Id 1170 for 3.00 KG of Cooking Gas @ N720.00','2023-03-19 12:06:43','',''),('1','312',2500,'','6.1','4',0.00,2160.00,'Retail Sale Id 1170 for retail product','2023-03-19 12:06:43','',''),('1','312',2501,'','20','3',9000.00,0.00,'Retail Sale Id 1171 for 12.50 KG of Cooking Gas @ N720.00','2023-03-19 12:30:44','',''),('1','312',2502,'','6.1','4',0.00,9000.00,'Retail Sale Id 1171 for retail product','2023-03-19 12:30:44','',''),('1','312',2503,'','20','3',11160.00,0.00,'Retail Sale Id 1172 for 15.50 KG of Cooking Gas @ N720.00','2023-03-19 12:45:58','',''),('1','312',2504,'','6.1','4',0.00,11160.00,'Retail Sale Id 1172 for retail product','2023-03-19 12:45:58','',''),('1','312',2505,'','20','3',9000.00,0.00,'Retail Sale Id 1173 for 12.50 KG of Cooking Gas @ N720.00','2023-03-19 12:50:28','',''),('1','312',2506,'','6.1','4',0.00,9000.00,'Retail Sale Id 1173 for retail product','2023-03-19 12:50:28','',''),('1','312',2507,'','20','3',7920.00,0.00,'Retail Sale Id 1174 for 11.00 KG of Cooking Gas @ N720.00','2023-03-19 12:52:42','',''),('1','312',2508,'','6.1','4',0.00,7920.00,'Retail Sale Id 1174 for retail product','2023-03-19 12:52:42','',''),('1','312',2509,'','20','3',4320.00,0.00,'Retail Sale Id 1175 for 6.00 KG of Cooking Gas @ N720.00','2023-03-19 13:40:28','',''),('1','312',2510,'','6.1','4',0.00,4320.00,'Retail Sale Id 1175 for retail product','2023-03-19 13:40:28','',''),('1','312',2511,'','20','3',4320.00,0.00,'Retail Sale Id 1176 for 6.00 KG of Cooking Gas @ N720.00','2023-03-19 13:42:31','',''),('1','312',2512,'','6.1','4',0.00,4320.00,'Retail Sale Id 1176 for retail product','2023-03-19 13:42:31','',''),('1','312',2513,'','20','3',2880.00,0.00,'Retail Sale Id 1177 for 4.00 KG of Cooking Gas @ N720.00','2023-03-19 13:49:23','',''),('1','312',2514,'','6.1','4',0.00,2880.00,'Retail Sale Id 1177 for retail product','2023-03-19 13:49:23','',''),('1','312',2515,'','20','3',3600.00,0.00,'Retail Sale Id 1178 for 5.00 KG of Cooking Gas @ N720.00','2023-03-19 14:01:27','',''),('1','312',2516,'','6.1','4',0.00,3600.00,'Retail Sale Id 1178 for retail product','2023-03-19 14:01:27','',''),('1','312',2517,'','20','3',3600.00,0.00,'Retail Sale Id 1179 for 5.00 KG of Cooking Gas @ N720.00','2023-03-19 14:06:35','',''),('1','312',2518,'','6.1','4',0.00,3600.00,'Retail Sale Id 1179 for retail product','2023-03-19 14:06:35','',''),('1','312',2519,'','20','3',5040.00,0.00,'Retail Sale Id 1180 for 7.00 KG of Cooking Gas @ N720.00','2023-03-19 14:11:36','',''),('1','312',2520,'','6.1','4',0.00,5040.00,'Retail Sale Id 1180 for retail product','2023-03-19 14:11:36','',''),('1','312',2521,'','20','3',4320.00,0.00,'Retail Sale Id 1181 for 6.00 KG of Cooking Gas @ N720.00','2023-03-19 14:30:01','',''),('1','312',2522,'','6.1','4',0.00,4320.00,'Retail Sale Id 1181 for retail product','2023-03-19 14:30:01','',''),('1','312',2523,'','20','3',8280.00,0.00,'Retail Sale Id 1182 for 11.50 KG of Cooking Gas @ N720.00','2023-03-19 14:34:33','',''),('1','312',2524,'','6.1','4',0.00,8280.00,'Retail Sale Id 1182 for retail product','2023-03-19 14:34:33','',''),('1','312',2525,'','20','3',7200.00,0.00,'Retail Sale Id 1183 for 10.00 KG of Cooking Gas @ N720.00','2023-03-19 14:51:19','',''),('1','312',2526,'','6.1','4',0.00,7200.00,'Retail Sale Id 1183 for retail product','2023-03-19 14:51:19','',''),('1','312',2527,'','20','3',2160.00,0.00,'Retail Sale Id 1184 for 3.00 KG of Cooking Gas @ N720.00','2023-03-19 14:58:31','',''),('1','312',2528,'','6.1','4',0.00,2160.00,'Retail Sale Id 1184 for retail product','2023-03-19 14:58:31','',''),('1','312',2529,'','20','3',2880.00,0.00,'Retail Sale Id 1185 for 4.00 KG of Cooking Gas @ N720.00','2023-03-19 15:16:01','',''),('1','312',2530,'','6.1','4',0.00,2880.00,'Retail Sale Id 1185 for retail product','2023-03-19 15:16:01','',''),('1','312',2531,'','20','3',2000.00,0.00,'Retail Sale Id 1186 for 2.78 KG of Cooking Gas @ N720.00','2023-03-19 15:30:36','',''),('1','312',2532,'','6.1','4',0.00,2000.00,'Retail Sale Id 1186 for retail product','2023-03-19 15:30:36','',''),('1','312',2533,'','20','3',2160.00,0.00,'Retail Sale Id 1187 for 3.00 KG of Cooking Gas @ N720.00','2023-03-19 15:33:23','',''),('1','312',2534,'','6.1','4',0.00,2160.00,'Retail Sale Id 1187 for retail product','2023-03-19 15:33:23','',''),('1','312',2535,'','20','3',3600.00,0.00,'Retail Sale Id 1188 for 5.00 KG of Cooking Gas @ N720.00','2023-03-19 15:42:17','',''),('1','312',2536,'','6.1','4',0.00,3600.00,'Retail Sale Id 1188 for retail product','2023-03-19 15:42:17','',''),('1','312',2537,'','20','3',1440.00,0.00,'Retail Sale Id 1189 for 2.00 KG of Cooking Gas @ N720.00','2023-03-19 15:45:43','',''),('1','312',2538,'','6.1','4',0.00,1440.00,'Retail Sale Id 1189 for retail product','2023-03-19 15:45:43','',''),('1','312',2539,'','20','3',2160.00,0.00,'Retail Sale Id 1190 for 3.00 KG of Cooking Gas @ N720.00','2023-03-19 15:47:55','',''),('1','312',2540,'','6.1','4',0.00,2160.00,'Retail Sale Id 1190 for retail product','2023-03-19 15:47:55','',''),('1','312',2541,'','20','3',4300.00,0.00,'Retail Sale Id 1191 for 5.97 KG of Cooking Gas @ N720.00','2023-03-19 15:53:57','',''),('1','312',2542,'','6.1','4',0.00,4300.00,'Retail Sale Id 1191 for retail product','2023-03-19 15:53:57','',''),('1','312',2543,'','20','3',2880.00,0.00,'Retail Sale Id 1192 for 4.00 KG of Cooking Gas @ N720.00','2023-03-19 15:55:56','',''),('1','312',2544,'','6.1','4',0.00,2880.00,'Retail Sale Id 1192 for retail product','2023-03-19 15:55:56','',''),('1','312',2545,'','20','3',4000.00,0.00,'Retail Sale Id 1193 for 5.56 KG of Cooking Gas @ N720.00','2023-03-19 16:09:59','',''),('1','312',2546,'','6.1','4',0.00,4000.00,'Retail Sale Id 1193 for retail product','2023-03-19 16:09:59','',''),('1','312',2547,'','20','3',2880.00,0.00,'Retail Sale Id 1194 for 4.00 KG of Cooking Gas @ N720.00','2023-03-19 16:12:30','',''),('1','312',2548,'','6.1','4',0.00,2880.00,'Retail Sale Id 1194 for retail product','2023-03-19 16:12:30','',''),('1','312',2549,'','20','3',2880.00,0.00,'Retail Sale Id 1196 for 4.00 KG of Cooking Gas @ N720.00','2023-03-19 16:22:49','',''),('1','312',2550,'','6.1','4',0.00,2880.00,'Retail Sale Id 1196 for retail product','2023-03-19 16:22:49','',''),('1','312',2551,'','20','3',8640.00,0.00,'Retail Sale Id 1197 for 12.00 KG of Cooking Gas @ N720.00','2023-03-19 16:34:50','',''),('1','312',2552,'','6.1','4',0.00,8640.00,'Retail Sale Id 1197 for retail product','2023-03-19 16:34:50','',''),('1','312',2553,'','20','3',4320.00,0.00,'Retail Sale Id 1198 for 6.00 KG of Cooking Gas @ N720.00','2023-03-19 16:47:41','',''),('1','312',2554,'','6.1','4',0.00,4320.00,'Retail Sale Id 1198 for retail product','2023-03-19 16:47:41','',''),('1','312',2555,'','20','3',4320.00,0.00,'Retail Sale Id 1199 for 6.00 KG of Cooking Gas @ N720.00','2023-03-19 16:51:30','',''),('1','312',2556,'','6.1','4',0.00,4320.00,'Retail Sale Id 1199 for retail product','2023-03-19 16:51:30','',''),('1','312',2557,'','20','3',1500.00,0.00,'Retail Sale Id 1200 for 2.08 KG of Cooking Gas @ N720.00','2023-03-19 17:15:47','',''),('1','312',2558,'','6.1','4',0.00,1500.00,'Retail Sale Id 1200 for retail product','2023-03-19 17:15:47','',''),('1','312',2559,'','20','3',187000.00,0.00,'Retail Sale Id 1201 for 275.00 KG of Cooking Gas @ N680.00','2023-03-19 17:25:28','',''),('1','312',2560,'','6.1','4',0.00,187000.00,'Retail Sale Id 1201 for retail product','2023-03-19 17:25:28','',''),('1','312',2561,'','20','3',8640.00,0.00,'Retail Sale Id 1203 for 12.00 KG of Cooking Gas @ N720.00','2023-03-19 17:52:00','',''),('1','312',2562,'','6.1','4',0.00,8640.00,'Retail Sale Id 1203 for retail product','2023-03-19 17:52:00','',''),('1','312',2563,'','20','3',4320.00,0.00,'Retail Sale Id 1204 for 6.00 KG of Cooking Gas @ N720.00','2023-03-19 17:53:31','',''),('1','312',2564,'','6.1','4',0.00,4320.00,'Retail Sale Id 1204 for retail product','2023-03-19 17:53:31','',''),('1','312',2565,'','20','3',750.00,0.00,'Retail Sale Id 1205 for 1.04 KG of Cooking Gas @ N720.00','2023-03-19 18:30:19','',''),('1','312',2566,'','6.1','4',0.00,750.00,'Retail Sale Id 1205 for retail product','2023-03-19 18:30:19','',''),('1','312',2567,'','20','3',1310.40,0.00,'Retail Sale Id 1206 for 1.82 KG of Cooking Gas @ N720.00','2023-03-19 18:54:16','',''),('1','312',2568,'','6.1','4',0.00,1310.40,'Retail Sale Id 1206 for retail product','2023-03-19 18:54:16','',''),('1','312',2569,'','20','3',0.00,0.00,'Sales from shift 37 on 2023-03-19 19:20:16 ','2023-03-19 19:20:16','',''),('1','312',2570,'','6.1','4',0.00,0.00,'Sales from shift 37 on 2023-03-19 19:20:16 ','2023-03-19 19:20:16','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'1','312','LPG','Cooking Gas','Kg',0,610.00,720.00,680.00,593.00,0.00,0,'2023-01-23 01:47:11','479','479','2023-01-23 01:47:11',0);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (1,'1','312',1,593.00,0.00,0.00,0.00,'Cost from purchase id #1','2023-02-02 11:34:21','1027'),(2,'1','312',1,593.00,760.00,0.00,593.00,'PRICE','2023-02-02 11:41:56','1027'),(3,'1','312',1,593.00,720.00,680.00,593.00,'PRICE','2023-02-14 15:03:20','1027'),(4,'1','312',1,610.00,720.00,0.00,0.00,'Cost from purchase id #4','2023-03-08 08:55:07','1027');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (1,'1','312','2023-02-02',1,1,593.00,5400.00,0.00,0.00,3202200.00,0.00,'','000','KMC 257 ZU','','','','2023-02-02 11:33:36',15,'purchase','1027','','0000-00-00 00:00:00','1027','2023-02-02 11:34:21'),(2,'1','312','2023-02-23',1,1,593.00,4941.00,0.00,0.00,2930013.00,0.00,'','000','FGE 986 ZY','','','','2023-02-23 13:00:30',15,'PURCHASE','1027','','0000-00-00 00:00:00','1027','2023-02-23 13:01:40'),(3,'1','312','2023-03-04',1,1,593.00,16.67,0.00,0.00,9885.31,0.00,'','000','FGE 986 ZY','','','','2023-03-04 12:31:28',15,'PURCHASE','1027','','0000-00-00 00:00:00','1027','2023-03-04 12:32:06'),(4,'1','312','2023-03-08',1,1,610.00,5400.00,0.00,0.00,3294000.00,0.00,'','16781087725','KKM 200 XA','','','','2023-03-08 08:54:36',15,'PURCHASE','1027','','0000-00-00 00:00:00','1027','2023-03-08 08:55:07');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (1,'1','312','2023-02-02',1,'000','','5',6840.00,'1','','','19','owerri lpg 044','000',6840.00,'2023-02-08 11:13:21',5,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','939','2023-02-20 16:16:47'),(2,'1','312','2023-02-03',1,'000','','5',71705.00,'2','','','19','owerri lpg 044','0000',71706.00,'2023-02-08 11:15:54',5,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','939','2023-02-20 16:20:21'),(3,'1','312','2023-02-04',1,'000','','5',138350.00,'3','','','19','owerri lpg 044','001',138345.20,'2023-02-08 11:20:49',5,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','939','2023-02-20 16:20:42'),(4,'1','312','2023-02-05',1,'000','','5',135280.00,'4','','','19','owerri lpg 044','0002',135280.40,'2023-02-08 11:22:56',5,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','939','2023-02-20 16:22:11'),(5,'1','312','2023-02-07',1,'000','','5',150820.00,'5','','','19','owerri lpg 044','0003',150820.40,'2023-02-08 11:25:00',5,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','939','2023-02-20 16:22:39'),(6,'1','312','2023-02-08',1,'000','','5',123775.00,'6','','','19','owerriipg2','0005',123773.60,'2023-02-11 08:52:26',5,'TELLERPAYMENT','1027','','0000-00-00 00:00:00','939','2023-02-22 15:17:58'),(8,'1','312','2023-02-10',1,'p o s','','10',117526.00,'8','','','8','owerriipg2 p o s','p o s2',117526.40,'2023-02-12 08:58:05',5,'P O S PAYMENT','1027','','0000-00-00 00:00:00','939','2023-02-20 16:33:58'),(10,'1','312','2023-02-11',1,'p o s','','10',122371.80,'9','','','8','owerriipg2 p o s','p o s4',122370.80,'2023-02-12 09:05:25',5,'P O S PAYMENT','1027','','0000-00-00 00:00:00','939','2023-02-20 16:34:42'),(11,'1','312','2023-02-12',1,'000','','5',59940.00,'10','','','19','owerriipg2','007',156256.00,'2023-02-14 11:17:11',5,'TELLRR PAYMENT','1027','','0000-00-00 00:00:00','939','2023-03-06 13:00:08'),(12,'1','312','2023-02-12',1,'p o s','','10',96320.00,'10','','','8','owerriipg2 p o s','p o s7',0.00,'2023-02-14 11:29:03',5,'P O S PAYMENT','1027','','0000-00-00 00:00:00','939','2023-02-20 16:35:20'),(13,'1','312','2023-02-14',1,'000','','5',72670.00,'11','','','19','owerriipg2','0008',72640.00,'2023-02-15 13:10:28',5,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','939','2023-02-23 15:49:31'),(14,'1','312','2023-02-14',1,'000','','5',3450.00,'12','','','19','owerriipg2','0009',50910.00,'2023-02-15 13:12:38',5,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','939','2023-02-22 15:20:06'),(15,'1','312','2023-02-14',1,'p o s','','10',47460.00,'12','','','8','owerriipg2 p o s','p o s8',0.00,'2023-02-15 13:15:32',5,'P O S PAYMENT','1027','','0000-00-00 00:00:00','939','2023-02-20 16:36:06'),(16,'1','312','2023-02-15',1,'000','','5',73060.00,'13','','','19','owerriipg2','011',112339.60,'2023-02-19 12:12:25',5,'','1027','','0000-00-00 00:00:00','939','2023-02-22 15:20:48'),(17,'1','312','2023-02-15',1,'p o s','','5',39280.00,'13','','','8','owerriipg2 p o s','p o s 11',0.00,'2023-02-19 12:14:19',5,'','1027','','0000-00-00 00:00:00','939','2023-02-20 16:36:45'),(18,'1','312','2023-02-16',1,'000','','5',80530.00,'14','','','19','owerriipg2','012',173608.40,'2023-02-19 12:17:45',5,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','939','2023-03-01 14:40:42'),(19,'1','312','2023-02-16',1,'p o s','','10',93080.00,'14','','','8','owerriipg2 p o s','p o s12',0.00,'2023-02-19 12:19:34',5,'P O S PAYMENT','1027','','0000-00-00 00:00:00','939','2023-02-20 16:38:10'),(20,'1','312','2023-02-17',1,'000','','5',63166.00,'15','','','19','owerriipg2','013',100526.00,'2023-02-19 12:21:37',5,'BANK PAYMENT','1027','','0000-00-00 00:00:00','939','2023-02-20 16:39:48'),(21,'1','312','2023-02-17',1,'p o s','','10',37360.00,'15','','','8','owerriipg2 p o s','p o s13',0.00,'2023-02-19 12:24:32',5,'P O S PAYMENT','1027','','0000-00-00 00:00:00','939','2023-02-21 12:32:45'),(22,'1','312','2023-02-18',1,'000','','5',409528.00,'16','','','19','owerriipg2','014',648049.75,'2023-02-19 12:26:14',5,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','939','2023-02-28 12:55:17'),(23,'1','312','2023-02-18',1,'p o s','','10',238520.00,'16','','','8','owerriipg2 p o s','p o s10',0.00,'2023-02-19 12:28:00',5,'P O S PAYMENT','1027','','0000-00-00 00:00:00','939','2023-02-21 12:32:00'),(24,'1','312','2023-02-21',1,'000','','5',460958.00,'18','','','19','owerriipg2','T',855300.00,'2023-02-22 15:46:21',5,'BANK PAYMENT','1027','','0000-00-00 00:00:00','939','2023-02-28 12:56:08'),(25,'1','312','2023-02-21',1,'p o s','','10',394340.00,'18','','','20','owerriipg2 p o s','p o s18',0.00,'2023-02-22 15:48:27',5,'P O S PAYMENT','1027','','0000-00-00 00:00:00','939','2023-02-28 12:56:08'),(26,'1','312','2023-02-22',1,'000','','5',122400.00,'19','','','19','owerriipg2','T19',300926.00,'2023-02-23 08:04:32',5,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','939','2023-02-28 13:31:28'),(29,'1','312','2023-02-09',1,'p o s','','10',115922.80,'7','','','8','owerriipg2 p o s','pos 9',115922.80,'2023-02-24 08:13:07',2,'p o s PAYMENT','1027','','0000-00-00 00:00:00','939','2023-02-28 13:33:19'),(31,'1','312','2023-02-23',1,'000','','5',166639.00,'20','','','19','owerriipg2','T 20',166639.60,'2023-02-24 11:28:50',5,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','939','2023-03-06 13:00:43'),(32,'1','312','2023-02-23',1,'p o s','','10',719100.00,'21','','','20','owerriipg2 p o s','P O S 21',724140.80,'2023-02-24 11:34:03',5,'P O S 1','1027','','0000-00-00 00:00:00','939','2023-02-28 13:34:16'),(33,'1','312','2023-02-23',1,'p o s','','10',5040.00,'21','','','8','owerriipg2 p o s','p o s22',0.00,'2023-02-24 11:35:35',5,'P O S 2','1027','','0000-00-00 00:00:00','939','2023-03-01 17:01:51'),(34,'1','312','2023-02-24',1,'000','','5',343378.00,'22','','','19','owerriipg2','T 22',751383.25,'2023-02-26 11:40:07',5,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','939','2023-03-06 13:01:08'),(35,'1','312','2023-02-24',1,'p o s','','10',356400.00,'22','','','20','owerriipg2 p o s','POS 22',0.00,'2023-02-26 11:41:45',5,'P O S 1','1027','','0000-00-00 00:00:00','939','2023-02-28 13:35:45'),(36,'1','312','2023-02-24',1,'p o s','','10',51600.00,'22','','','8','owerriipg2 p o s','P OS T',0.00,'2023-02-26 11:43:19',5,'POS 2','1027','','0000-00-00 00:00:00','939','2023-02-28 13:35:44'),(37,'1','312','2023-02-22',1,'p o s','','10',178520.00,'19','','','20','owerriipg2 p o s','pos22',0.00,'2023-02-28 13:19:33',5,'POS PAYMENT','1027','','0000-00-00 00:00:00','939','2023-02-28 13:31:28'),(38,'1','312','2023-02-19',1,'000','','5',173120.00,'17','','','19','owerriipg2','T17',259141.60,'2023-02-28 13:45:10',5,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','939','2023-03-01 14:43:47'),(39,'1','312','2023-02-19',1,'p o s','','10',85900.00,'17','','','8','owerriipg2 p o s','POS17',0.00,'2023-02-28 13:48:09',5,'POS PAYMENT','1027','','0000-00-00 00:00:00','939','2023-03-01 17:01:25'),(40,'1','312','2023-02-28',1,'000','','5',46958.00,'23','','','19','owerriipg2','T23',563507.45,'2023-03-01 13:14:13',5,'TELLER 1','1027','','0000-00-00 00:00:00','939','2023-03-02 15:58:17'),(41,'1','312','2023-02-28',1,'000','','5',245039.00,'23','','','19','owerriipg2','T24',0.00,'2023-03-01 13:16:43',5,'TELLER 2','1027','','0000-00-00 00:00:00','939','2023-03-06 13:01:38'),(42,'1','312','2023-02-28',1,'p o s','','10',271510.00,'23','','','20','owerriipg2 p o s','p o s23',0.00,'2023-03-01 13:18:55',5,'P O S PAYMENT','1027','','0000-00-00 00:00:00','939','2023-03-02 15:58:17'),(44,'1','312','2023-03-01',1,'p o s','','10',116080.00,'24','','','20','owerriipg2 p o s','p o s26',0.00,'2023-03-02 08:44:18',5,'P O S PAYMENT','1027','','0000-00-00 00:00:00','939','2023-03-03 14:44:16'),(45,'1','312','2023-02-09',1,'p o s','','10',115922.00,'7','','','8','owerriipg2 p o s','p o sT',115922.80,'2023-03-02 16:00:05',5,'POS PAYMENT','1027','','0000-00-00 00:00:00','939','2023-03-03 14:44:59'),(46,'1','312','2023-03-02',1,'000','','5',45151.00,'25','','','19','owerriipg2','T26',300320.00,'2023-03-03 09:34:43',5,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','939','2023-03-13 12:07:46'),(47,'1','312','2023-03-02',1,'p o s','','10',246960.00,'25','','','20','owerriipg2 p o s','PT',0.00,'2023-03-03 09:36:00',5,'POS 1','1027','','0000-00-00 00:00:00','939','2023-03-03 14:46:02'),(48,'1','312','2023-03-02',1,'p o s','','10',8320.00,'25','','','8','owerriipg2 p o s','PX',0.00,'2023-03-03 09:37:32',5,'POS 2','1027','','0000-00-00 00:00:00','939','2023-03-06 13:06:05'),(49,'1','312','2023-03-03',1,'000','','5',35566.00,'26','','','19','owerriipg2','T27',222760.00,'2023-03-04 08:17:52',5,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','939','2023-03-13 12:08:21'),(50,'1','312','2023-03-03',1,'p o s','','10',187190.00,'26','','','20','owerriipg2 p o s','POS3',0.00,'2023-03-04 08:19:54',5,'POS PAYMENT','1027','','0000-00-00 00:00:00','939','2023-03-07 11:59:51'),(51,'1','312','2023-03-04',1,'p o s','','10',267080.00,'27','','','20','owerriipg2 p o s','POS 28',267083.60,'2023-03-04 13:12:06',5,'POS PAYMENT','1027','','0000-00-00 00:00:00','939','2023-03-07 12:00:25'),(52,'1','312','2023-03-01',1,'000','','5',291997.00,'24','','','19','owerriipg2','TY',620658.80,'2023-03-08 14:00:43',5,'TELLER 1','1027','939','2023-03-10 11:16:21','939','2023-03-10 11:16:43'),(53,'1','312','2023-03-01',1,'000','','5',212581.00,'24','','','19','owerriipg2','TA',0.00,'2023-03-08 14:02:28',5,'TELLER 2','1027','','0000-00-00 00:00:00','939','2023-03-10 11:16:43'),(54,'1','312','2023-03-08',1,'000','','5',186854.00,'28','','','19','owerriipg2','TS',509211.10,'2023-03-09 11:42:50',0,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(55,'1','312','2023-03-08',1,'p o s','','10',322350.00,'28','','','20','owerriipg2 p o s','PO',0.00,'2023-03-09 11:44:13',5,'P O S PAYMENT','1027','','0000-00-00 00:00:00','939','2023-03-10 16:13:43'),(56,'1','312','2023-03-09',1,'000','','5',17993.00,'29','','','19','owerriipg2','TF',151693.20,'2023-03-10 07:24:47',5,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','939','2023-03-13 12:09:17'),(57,'1','312','2023-03-09',1,'p o s','','10',133700.00,'29','','','20','owerriipg2 p o s','POS F',0.00,'2023-03-10 07:26:40',5,'POS PAYMENT','1027','','0000-00-00 00:00:00','939','2023-03-10 16:13:17'),(58,'1','312','2023-03-10',1,'000','','5',16478.00,'30','','','19','owerriipg2','TW',282372.00,'2023-03-11 07:32:43',5,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','939','2023-03-13 12:10:02'),(59,'1','312','2023-03-10',1,'p o s','','10',265820.00,'30','','','20','','p o s 30',0.00,'2023-03-11 07:34:20',5,'POS PAYMENT','1027','','0000-00-00 00:00:00','939','2023-03-14 11:55:01'),(60,'1','312','2023-03-11',1,'000','','5',3482.00,'31','','','19','owerriipg2','TS 11',312653.20,'2023-03-12 08:10:52',5,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','939','2023-03-13 12:10:53'),(61,'1','312','2023-03-11',1,'p o s','','10',295050.00,'31','','','20','owerriipg2 p o s','p o s71',0.00,'2023-03-12 08:12:58',5,'POS 1','1027','','0000-00-00 00:00:00','939','2023-03-14 11:56:41'),(62,'1','312','2023-03-11',1,'p o s','','10',14040.00,'31','','','8','owerriipg2 p o s','p o s72',0.00,'2023-03-12 08:14:24',5,'POS2','1027','','0000-00-00 00:00:00','939','2023-03-14 11:56:41'),(63,'1','312','2023-03-12',1,'p o s','','10',382851.00,'32','','','20','owerriipg2 p o s','p o s32',382851.20,'2023-03-13 08:21:24',5,'POS PAYMENT','1027','','0000-00-00 00:00:00','939','2023-03-14 11:57:18'),(64,'1','312','2023-03-14',1,'p o s','','10',290500.00,'33','','','20','owerriipg2 p o s','p o s33',304860.00,'2023-03-14 19:20:14',5,'POS 1','1027','','0000-00-00 00:00:00','939','2023-03-16 11:57:27'),(65,'1','312','2023-03-14',1,'p o s','','10',12882.00,'33','','','8','owerriipg2 p o s','p o s20',0.00,'2023-03-14 19:21:36',5,'POS 2','1027','','0000-00-00 00:00:00','939','2023-03-15 14:30:49'),(66,'1','312','2023-03-14',1,'000','','5',1440.00,'33','','','19','owerriipg2','T193',0.00,'2023-03-15 06:58:29',0,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(67,'1','312','2023-03-15',1,'000','','10',98060.00,'34','','','20','owerriipg2 p o s','p o s34',137990.00,'2023-03-15 18:08:52',5,'POS 1','1027','','0000-00-00 00:00:00','939','2023-03-17 10:33:00'),(68,'1','312','2023-03-15',1,'p o s','','10',31380.00,'34','','','8','owerriipg2 p o s','p o sT1',0.00,'2023-03-15 18:10:38',5,'POS 2','1027','','0000-00-00 00:00:00','939','2023-03-17 14:37:54'),(69,'1','312','2023-03-15',1,'000','','5',8550.00,'34','','','19','owerriipg2','T34',0.00,'2023-03-15 18:12:59',0,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(70,'1','312','2023-03-16',1,'000','','5',4288.00,'35','','','19','owerriipg2','T196',207160.80,'2023-03-16 19:35:42',0,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(71,'1','312','2023-03-16',1,'p o s','','10',197270.00,'35','','','20','owerriipg2 p o s','p o sT6',0.00,'2023-03-16 19:36:49',5,'POS 1','1027','','0000-00-00 00:00:00','939','2023-03-17 14:22:15'),(72,'1','312','2023-03-16',1,'p o s','','10',5600.00,'35','','','8','owerriipg2 p o s','p o sT3',0.00,'2023-03-16 19:37:55',5,'POS 2','1027','','0000-00-00 00:00:00','939','2023-03-17 14:22:15'),(73,'1','312','2023-03-17',1,'000','','5',38244.00,'36','','','19','owerriipg2','TY2',463989.20,'2023-03-17 20:01:35',0,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(74,'1','312','2023-03-17',1,'p o s','','10',276000.00,'36','','','20','owerriipg2 p o s','p o sT36',0.00,'2023-03-17 20:03:25',0,'POS 1PAYMENT','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(75,'1','312','2023-03-17',1,'p o s','','10',149740.00,'36','','','8','owerriipg2 p o s','p o sTR',0.00,'2023-03-17 20:05:51',0,'POS 2 PAYMENT','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(76,'1','312','2023-03-19',1,'000','','5',202863.00,'37','','','19','owerriipg2','TR',434540.40,'2023-03-19 19:39:20',0,'TELLER PAYMENT','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(77,'1','312','2023-03-19',1,'p o s','','10',61000.00,'37','','','20','owerriipg2 p o s','p o sT5',0.00,'2023-03-19 19:40:35',0,'POS 1','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(78,'1','312','2023-03-19',1,'p o s','','10',170680.00,'37','','','8','owerriipg2 p o s','p o sTG',0.00,'2023-03-19 19:41:54',0,'POS 2','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (1,'1',1,'312',1,1,'2023-02-02 00:00:00','STOCK GAP',5400.00,5400.00,0.00,'000','','1','KMC 257 ZU','ABUBAKAR MUHAMMAD','000','RECEIVED',5,'2023-02-02 11:37:52','1027','0000-00-00 00:00:00','','2023-02-02 11:39:31','1027'),(2,'1',2,'312',1,1,'2023-02-23 00:00:00','STOCK GAP',4941.00,4941.00,0.00,'000','','1','FGE 986 ZY','USAINI LAWAN','000','RECEIVED',5,'2023-02-23 13:03:34','1027','0000-00-00 00:00:00','','2023-02-23 13:04:02','1027'),(3,'1',3,'312',1,1,'2023-03-04 00:00:00','STOCK GAP',16.67,16.67,0.00,'000','','1','FGE 986 ZY','USAINI LAWAN','000','RECEIVED',5,'2023-03-04 12:33:21','1027','0000-00-00 00:00:00','','2023-03-04 12:33:49','1027'),(4,'1',4,'312',1,1,'2023-03-08 00:00:00','RANO GAZ',5400.00,5400.00,0.00,'1678108725','','1','KKM 200 XA','ABDULLAHI ADAMU','000','RECIEVCED',5,'2023-03-08 08:58:09','1027','0000-00-00 00:00:00','','2023-03-08 08:59:09','1027');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
INSERT INTO `retail_customers` VALUES (1,'1','312','ENUSER','2348131593035','','2023-02-02 11:53:25','1027','0000-00-00 00:00:00',''),(2,'1','312','END USER','2348134818197','','2023-02-22 19:27:08','1027','0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB AUTO_INCREMENT=1207 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
INSERT INTO `retail_sales` VALUES (1,'1','312','1','2023-02-02','','ENUSER','2348131593035',0.00,760.00,'02021152','2023-02-02 11:53:26',5,'cash','','',760.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(2,'1','312','1','2023-02-02','','ENUSER','2348131593035',0.00,6080.00,'02021557','2023-02-02 15:58:45',5,'cash','','',6080.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(3,'1','312','2','2023-02-04','','END USER','2348131593035',0.00,760.00,'02040814','2023-02-04 08:16:34',5,'cash','','',760.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(4,'1','312','2','2023-02-04','','END USER','2348131593035',0.00,70946.00,'02040931','2023-02-04 09:32:23',5,'cash','','',70946.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(5,'1','312','3','2023-02-04','','END USER','2348131593035',0.00,3800.00,'02040943','2023-02-04 09:44:30',5,'cash','','',3800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(6,'1','312','3','2023-02-04','','END USER','2348131593035',0.00,4560.00,'02040946','2023-02-04 09:46:42',5,'cash','','',4560.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(7,'1','312','3','2023-02-04','','END USER','2348131593035',0.00,3800.00,'02040947','2023-02-04 09:48:12',5,'cash','','',3800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(8,'1','312','3','2023-02-04','','END USER','2348131593035',0.00,3800.00,'02040949','2023-02-04 09:49:49',5,'cash','','',3800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(9,'1','312','3','2023-02-04','','END USER','2348131593035',0.00,3800.00,'02040951','2023-02-04 09:51:31',5,'cash','','',3800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(11,'1','312','3','2023-02-04','','END USER','2348131593035',0.00,2500.00,'02040952','2023-02-04 09:57:27',5,'cash','','',2500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(12,'1','312','3','2023-02-04','','END USER','2348131593035',0.00,2300.00,'02040958','2023-02-04 09:59:01',5,'cash','','',2300.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(13,'1','312','3','2023-02-04','','END USER','2348131593035',0.00,1520.00,'02041002','2023-02-04 10:03:17',5,'cash','','',1520.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(14,'1','312','3','2023-02-04','','END USER','2348131593035',0.00,1500.00,'02041004','2023-02-04 10:04:40',5,'cash','','',1500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(15,'1','312','3','2023-02-04','','END USER','2348131593035',0.00,9500.00,'02041013','2023-02-04 10:13:49',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(16,'1','312','3','2023-02-04','','END USER','2348131593035',0.00,9500.00,'02041043','2023-02-04 11:24:51',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(17,'1','312','3','2023-02-04','','END USER','2348131593035',0.00,2660.00,'02041125','2023-02-04 11:26:13',5,'cash','','',2660.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(18,'1','312','3','2023-02-04','','END USER','2348131593035',0.00,3500.00,'02041127','2023-02-04 11:27:35',5,'cash','','',3500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(19,'1','312','3','2023-02-04','','END USER','2348131593035',0.00,4560.00,'02041230','2023-02-04 12:30:52',5,'cash','','',4560.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(20,'1','312','3','2023-02-04','','END USER','2348131593035',0.00,4560.00,'02041235','2023-02-04 12:49:31',5,'cash','','',4560.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(21,'1','312','3','2023-02-04','','END USER','2348131593035',0.00,760.00,'02041308','2023-02-04 13:09:28',5,'cash','','',760.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(22,'1','312','3','2023-02-04','','END USER','2348131593035',0.00,4000.00,'02041310','2023-02-04 13:19:08',5,'cash','','',4000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(23,'1','312','3','2023-02-04','','END USER','2348131593035',0.00,4560.00,'02041321','2023-02-04 13:22:26',5,'cash','','',4560.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(24,'1','312','3','2023-02-04','','END USER','2348131593035',0.00,12600.00,'02041457','2023-02-04 14:57:48',5,'cash','','',12600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(25,'1','312','3','2023-02-04','','END USER','2348131593035',0.00,2300.00,'02041502','2023-02-04 15:21:34',5,'cash','','',2300.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(26,'1','312','3','2023-02-04','','END USER','2348131593035',0.00,7425.20,'02041634','2023-02-04 16:50:02',5,'cash','','',7425.20,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(27,'1','312','3','2023-02-04','','END USER','2348131593035',0.00,7600.00,'02041650','2023-02-04 16:51:28',5,'cash','','',7600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(28,'1','312','3','2023-02-04','','ENUSER','2348131593035',0.00,6840.00,'02041954','2023-02-04 19:54:39',5,'cash','','',6840.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(29,'1','312','3','2023-02-04','','ENUSER','2348131593035',0.00,30400.00,'02041955','2023-02-04 19:55:37',5,'cash','','',30400.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(30,'1','312','4','2023-02-05','','ENUSER','2348131593035',0.00,9500.00,'02050741','2023-02-05 07:41:50',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(31,'1','312','4','2023-02-05','','ENUSER','2348131593035',0.00,4560.00,'02050742','2023-02-05 07:43:04',5,'cash','','',4560.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(32,'1','312','4','2023-02-05','','END USER','2348131593035',0.00,9500.00,'02050906','2023-02-05 10:13:29',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(33,'1','312','4','2023-02-05','','END USER','2348131593035',0.00,7600.00,'02051233','2023-02-05 12:33:51',5,'cash','','',7600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(34,'1','312','4','2023-02-05','','END USER','2348131593035',0.00,1550.00,'02051239','2023-02-05 12:39:40',5,'cash','','',1550.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(35,'1','312','4','2023-02-05','','END USER','2348131593035',0.00,2300.00,'02051244','2023-02-05 12:44:44',5,'cash','','',2300.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(36,'1','312','4','2023-02-05','','END USER','2348131593035',0.00,9500.00,'02051257','2023-02-05 12:58:13',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(37,'1','312','4','2023-02-05','','END USER','2348131593035',0.00,4560.00,'02051259','2023-02-05 12:59:48',5,'cash','','',4560.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(38,'1','312','4','2023-02-05','','END USER','2348131593035',0.00,10640.00,'02051302','2023-02-05 13:03:51',5,'cash','','',10640.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(39,'1','312','4','2023-02-05','','END USER','2348131593035',0.00,3800.00,'02051304','2023-02-05 13:05:33',5,'cash','','',3800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(40,'1','312','4','2023-02-05','','END USER','2348131593035',0.00,4560.00,'02051306','2023-02-05 13:07:00',5,'cash','','',4560.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(41,'1','312','4','2023-02-05','','ENUSER','2348131593035',0.00,4000.00,'02051407','2023-02-05 14:47:43',5,'cash','','',4000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(42,'1','312','4','2023-02-05','','ENUSER','2348131593035',0.00,2000.00,'02051449','2023-02-05 14:49:58',5,'cash','','',2000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(43,'1','312','4','2023-02-05','','ENUSER','2348131593035',0.00,9100.00,'02051537','2023-02-05 15:38:34',5,'cash','','',9100.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(44,'1','312','4','2023-02-05','','END USER','2348131593035',0.00,8000.00,'02051549','2023-02-05 15:49:55',5,'cash','','',8000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(45,'1','312','4','2023-02-05','','ENUSER','2348131593035',0.00,6110.40,'02051924','2023-02-05 19:25:04',5,'cash','','',6110.40,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(46,'1','312','4','2023-02-05','','ENUSER','2348131593035',0.00,7600.00,'02051925','2023-02-05 19:26:05',5,'cash','','',7600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(47,'1','312','4','2023-02-05','','ENUSER','2348131593035',0.00,9500.00,'02051926','2023-02-05 19:27:01',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(48,'1','312','4','2023-02-05','','ENUSER','2348131593035',0.00,5700.00,'02051927','2023-02-05 19:27:53',5,'cash','','',5700.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(49,'1','312','4','2023-02-05','','ENUSER','2348131593035',0.00,15200.00,'02051928','2023-02-05 19:28:34',5,'cash','','',15200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(50,'1','312','5','2023-02-07','','ENUSER','2348131593035',0.00,9500.00,'02070812','2023-02-07 08:13:13',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(51,'1','312','5','2023-02-07','','ENUSER','2348131593035',0.00,4560.00,'02070814','2023-02-07 08:14:38',5,'cash','','',4560.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(52,'1','312','5','2023-02-07','','ENUSER','2348131593035',0.00,3800.00,'02070815','2023-02-07 08:15:58',5,'cash','','',3800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(53,'1','312','5','2023-02-07','','END USER','2348131593035',0.00,2000.00,'02070829','2023-02-07 08:35:15',5,'cash','','',2000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(54,'1','312','5','2023-02-07','','ENUSER','2348131593035',0.00,4560.00,'02070836','2023-02-07 12:11:20',5,'cash','','',4560.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(55,'1','312','5','2023-02-07','','END USER','2348131593035',0.00,3050.00,'02071215','2023-02-07 12:16:50',5,'cash','','',3050.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(56,'1','312','5','2023-02-07','','ENUSER','2348131593035',0.00,8360.00,'02071217','2023-02-07 13:44:09',5,'cash','','',8360.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(57,'1','312','5','2023-02-07','','END USER','2348131593035',0.00,4000.00,'02071426','2023-02-07 14:27:25',5,'cash','','',4000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(59,'1','312','5','2023-02-07','','ENUSER','2348131593035',0.00,4590.40,'02071917','2023-02-07 19:17:53',5,'cash','','',4590.40,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(60,'1','312','5','2023-02-07','','END USER','2348131593035',0.00,15200.00,'02071918','2023-02-07 19:19:12',5,'cash','','',15200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(61,'1','312','5','2023-02-07','','END USER','2348131593035',0.00,9500.00,'02071922','2023-02-07 19:23:05',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(62,'1','312','5','2023-02-07','','END USER','2348131593035',0.00,4560.00,'02071924','2023-02-07 19:26:55',5,'cash','','',4560.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(63,'1','312','5','2023-02-07','','END USER','2348131593035',0.00,7600.00,'02071927','2023-02-07 19:28:21',5,'cash','','',7600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(64,'1','312','5','2023-02-07','','END USER','2348131593035',0.00,9120.00,'02071928','2023-02-07 19:29:46',5,'cash','','',9120.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(65,'1','312','5','2023-02-07','','END USER','2348131593035',0.00,9500.00,'02071930','2023-02-07 19:31:31',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(66,'1','312','5','2023-02-07','','END USER','2348131593035',0.00,7600.00,'02071932','2023-02-07 19:32:56',5,'cash','','',7600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(67,'1','312','5','2023-02-07','','END USER','2348131593035',0.00,8360.00,'02071933','2023-02-07 19:33:59',5,'cash','','',8360.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(68,'1','312','5','2023-02-07','','END USER','2348131593035',0.00,9500.00,'02071934','2023-02-07 19:34:59',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(69,'1','312','5','2023-02-07','','END USER','2348131593035',0.00,7600.00,'02071935','2023-02-07 19:36:14',5,'cash','','',7600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(70,'1','312','5','2023-02-07','','END USER','2348131593035',0.00,17556.00,'02071938','2023-02-07 19:39:19',5,'cash','','',17556.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(71,'1','312','5','2023-02-07','','END USER','2348131593035',0.00,304.00,'02071942','2023-02-07 19:42:53',5,'cash','','',304.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(72,'1','312','6','2023-02-08','','ENUSER','2348131593035',0.00,9500.00,'02081104','2023-02-08 11:05:01',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(73,'1','312','6','2023-02-08','','END USER','2348131593035',0.00,5320.00,'02081430','2023-02-08 14:31:11',5,'cash','','',5320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(74,'1','312','6','2023-02-08','','END USER','2348131593035',0.00,7600.00,'02081432','2023-02-08 14:32:57',5,'cash','','',7600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(75,'1','312','6','2023-02-08','','END USER','2348131593035',0.00,8740.00,'02081439','2023-02-08 14:40:25',5,'cash','','',8740.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(76,'1','312','6','2023-02-08','','END USER','2348131593035',0.00,7600.00,'02081441','2023-02-08 14:41:44',5,'cash','','',7600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(77,'1','312','6','2023-02-08','','END USER','2348131593035',0.00,3800.00,'02081442','2023-02-08 14:42:53',5,'cash','','',3800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(78,'1','312','6','2023-02-08','','END USER','2348131593035',0.00,4560.00,'02081443','2023-02-08 14:43:53',5,'cash','','',4560.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(79,'1','312','6','2023-02-08','','END USER','2348131593035',0.00,6840.00,'02081444','2023-02-08 14:45:22',5,'cash','','',6840.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(80,'1','312','6','2023-02-08','','END USER','2348131593035',0.00,9500.00,'02081701','2023-02-08 17:01:53',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(81,'1','312','6','2023-02-08','','ENUSER','2348131593035',0.00,4560.00,'02081736','2023-02-08 17:36:49',5,'cash','','',4560.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82,'1','312','6','2023-02-08','','ENUSER','2348131593035',0.00,7600.00,'02081750','2023-02-08 17:51:15',5,'cash','','',7600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(83,'1','312','6','2023-02-08','','ENUSER','2348131593035',0.00,2553.60,'02081916','2023-02-08 19:18:06',5,'cash','','',2553.60,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(84,'1','312','6','2023-02-08','','END USER','2348131593035',0.00,9500.00,'02081919','2023-02-08 19:21:04',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(85,'1','312','6','2023-02-08','','END USER','2348131593035',0.00,7600.00,'02081922','2023-02-08 19:23:04',5,'cash','','',7600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(86,'1','312','6','2023-02-08','','END USER','2348131593035',0.00,9500.00,'02081924','2023-02-08 19:25:08',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(87,'1','312','6','2023-02-08','','END USER','2348131593035',0.00,7600.00,'02081926','2023-02-08 19:27:45',5,'cash','','',7600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(88,'1','312','6','2023-02-08','','END USER','2348131593035',0.00,11400.00,'02081931','2023-02-08 19:32:07',5,'cash','','',11400.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(89,'1','312','7','2023-02-09','','ENUSER','2348131593035',0.00,9500.00,'02091010','2023-02-09 10:10:49',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(90,'1','312','7','2023-02-09','','ENUSER','2348131593035',0.00,3800.00,'02091011','2023-02-09 10:11:51',5,'cash','','',3800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(91,'1','312','7','2023-02-09','','ENUSER','2348131593035',0.00,7600.00,'02091012','2023-02-09 10:12:59',5,'cash','','',7600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(92,'1','312','7','2023-02-09','','END USER','2348131593035',0.00,9500.00,'02091925','2023-02-09 19:26:54',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(93,'1','312','7','2023-02-09','','END USER','2348131593035',0.00,8740.00,'02091927','2023-02-09 19:28:13',5,'cash','','',8740.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(94,'1','312','7','2023-02-09','','END USER','2348131593035',0.00,8360.00,'02091928','2023-02-09 19:29:05',5,'cash','','',8360.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(95,'1','312','7','2023-02-09','','END USER','2348131593035',0.00,7600.00,'02091929','2023-02-09 19:29:56',5,'cash','','',7600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(96,'1','312','7','2023-02-09','','END USER','2348131593035',0.00,9500.00,'02091930','2023-02-09 19:30:44',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(97,'1','312','7','2023-02-09','','END USER','2348131593035',0.00,8740.00,'02091931','2023-02-09 19:31:36',5,'cash','','',8740.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(98,'1','312','7','2023-02-09','','END USER','2348131593035',0.00,10640.00,'02091932','2023-02-09 19:32:32',5,'cash','','',10640.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(99,'1','312','7','2023-02-09','','END USER','2348131593035',0.00,7828.00,'02091932','2023-02-09 19:33:52',5,'cash','','',7828.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(100,'1','312','7','2023-02-09','','END USER','2348131593035',0.00,9500.00,'02091934','2023-02-09 19:34:54',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(101,'1','312','7','2023-02-09','','END USER','2348131593035',0.00,1497.20,'02091935','2023-02-09 19:35:50',5,'cash','','',1497.20,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(102,'1','312','7','2023-02-09','','END USER','2348131593035',0.00,9500.00,'02091936','2023-02-09 19:37:30',2,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(103,'1','312','7','2023-02-09','','END USER','2348131593035',0.00,6612.00,'02091937','2023-02-09 19:39:34',5,'cash','','',6612.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(104,'1','312','7','2023-02-09','','END USER','2348131593035',0.00,6505.60,'02091943','2023-02-09 19:43:49',5,'cash','','',6505.60,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(105,'1','312','8','2023-02-10','','ENUSER','2348131593035',0.00,9500.00,'02101236','2023-02-10 12:36:55',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(106,'1','312','8','2023-02-10','','ENUSER','2348131593035',0.00,3800.00,'02101239','2023-02-10 12:39:40',5,'cash','','',3800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(107,'1','312','8','2023-02-10','','ENUSER','2348131593035',0.00,3040.00,'02101758','2023-02-10 17:58:58',5,'cash','','',3040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(108,'1','312','8','2023-02-10','','END USER','2348131593035',0.00,9500.00,'02101930','2023-02-10 19:34:20',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(109,'1','312','8','2023-02-10','','END USER','2348131593035',0.00,7600.00,'02101934','2023-02-10 19:35:18',5,'cash','','',7600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(110,'1','312','8','2023-02-10','','END USER','2348131593035',0.00,10640.00,'02101935','2023-02-10 19:36:00',5,'cash','','',10640.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(111,'1','312','8','2023-02-10','','END USER','2348131593035',0.00,8360.00,'02101936','2023-02-10 19:36:44',5,'cash','','',8360.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(112,'1','312','8','2023-02-10','','END USER','2348131593035',0.00,9500.00,'02101937','2023-02-10 19:37:36',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(113,'1','312','8','2023-02-10','','END USER','2348131593035',0.00,7600.00,'02101937','2023-02-10 19:38:18',5,'cash','','',7600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(114,'1','312','8','2023-02-10','','END USER','2348131593035',0.00,10640.00,'02101938','2023-02-10 19:39:01',5,'cash','','',10640.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(115,'1','312','8','2023-02-10','','END USER','2348131593035',0.00,9500.00,'02101939','2023-02-10 19:39:44',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(116,'1','312','8','2023-02-10','','END USER','2348131593035',0.00,9500.00,'02101940','2023-02-10 19:40:31',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(117,'1','312','8','2023-02-10','','END USER','2348131593035',0.00,7600.00,'02101940','2023-02-10 19:41:16',5,'cash','','',7600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(118,'1','312','8','2023-02-10','','END USER','2348131593035',0.00,10746.40,'02101942','2023-02-10 19:44:36',5,'cash','','',10746.40,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(120,'1','312','9','2023-02-11','','ENUSER','2348131593035',0.00,9500.00,'02110750','2023-02-11 07:50:47',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(122,'1','312','9','2023-02-11','','END USER','2348131593035',0.00,760.00,'02110753','2023-02-11 07:53:40',5,'cash','','',760.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(123,'1','312','9','2023-02-11','','END USER','2348131593035',0.00,2300.00,'02110754','2023-02-11 07:55:22',5,'cash','','',2300.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(124,'1','312','9','2023-02-11','','ENUSER','2348131593035',0.00,6000.00,'02110819','2023-02-11 08:45:59',5,'cash','','',6000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(125,'1','312','9','2023-02-11','','ENUSER','2348131593035',0.00,3040.00,'02110910','2023-02-11 09:11:17',5,'cash','','',6080.00,3040.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(126,'1','312','9','2023-02-11','','END USER','2348131593035',0.00,2280.00,'02111040','2023-02-11 10:40:54',5,'cash','','',2280.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(127,'1','312','9','2023-02-11','','END USER','2348131593035',0.00,5320.00,'02111056','2023-02-11 10:57:10',5,'cash','','',5320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(128,'1','312','9','2023-02-11','','END USER','2348131593035',0.00,5320.00,'02111123','2023-02-11 12:17:34',5,'cash','','',5320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(129,'1','312','9','2023-02-11','','END USER','2348131593035',0.00,4560.00,'02111353','2023-02-11 13:53:42',5,'cash','','',4560.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(130,'1','312','9','2023-02-11','','END USER','2348131593035',0.00,9500.00,'02111354','2023-02-11 13:55:16',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(131,'1','312','9','2023-02-11','','END USER','2348131593035',0.00,1530.00,'02111432','2023-02-11 14:33:16',5,'cash','','',1530.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(132,'1','312','9','2023-02-11','','ENUSER','2348131593035',0.00,3860.80,'02112000','2023-02-11 20:01:03',5,'cash','','',3860.80,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(133,'1','312','9','2023-02-11','','ENUSER','2348131593035',0.00,11400.00,'02112002','2023-02-11 20:02:29',5,'cash','','',11400.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(134,'1','312','9','2023-02-11','','ENUSER','2348131593035',0.00,9500.00,'02112002','2023-02-11 20:03:22',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(135,'1','312','9','2023-02-11','','ENUSER','2348131593035',0.00,9500.00,'02112003','2023-02-11 20:04:11',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(136,'1','312','9','2023-02-11','','ENUSER','2348131593035',0.00,7600.00,'02112004','2023-02-11 20:04:56',5,'cash','','',7600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(137,'1','312','9','2023-02-11','','ENUSER','2348131593035',0.00,8360.00,'02112005','2023-02-11 20:05:45',5,'cash','','',8360.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(138,'1','312','9','2023-02-11','','ENUSER','2348131593035',0.00,6840.00,'02112006','2023-02-11 20:06:32',5,'cash','','',6840.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(139,'1','312','9','2023-02-11','','ENUSER','2348131593035',0.00,3800.00,'02112006','2023-02-11 20:07:16',5,'cash','','',3800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(140,'1','312','9','2023-02-11','','ENUSER','2348131593035',0.00,3800.00,'02112007','2023-02-11 20:07:58',5,'cash','','',3800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(141,'1','312','9','2023-02-11','','ENUSER','2348131593035',0.00,7600.00,'02112010','2023-02-11 20:10:24',5,'cash','','',7600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(142,'1','312','10','2023-02-12','','END USER','2348131593035',0.00,9500.00,'02120755','2023-02-12 07:56:07',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(143,'1','312','10','2023-02-12','','END USER','2348131593035',0.00,5000.00,'02120803','2023-02-12 08:04:01',5,'cash','','',5000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(144,'1','312','10','2023-02-12','','END USER','2348131593035',0.00,3000.00,'02120804','2023-02-12 08:05:11',5,'cash','','',3000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(145,'1','312','10','2023-02-12','','END USER','2348131593035',0.00,1520.00,'02120806','2023-02-12 08:06:32',5,'cash','','',1520.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(146,'1','312','10','2023-02-12','','END USER','2348131593035',0.00,10000.00,'02120925','2023-02-12 09:25:33',5,'cash','','',10000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(147,'1','312','10','2023-02-12','','END USER','2348131593035',0.00,9500.00,'02120943','2023-02-12 09:43:29',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(148,'1','312','10','2023-02-12','','END USER','2348131593035',0.00,3800.00,'02121028','2023-02-12 10:28:40',5,'cash','','',3800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(149,'1','312','10','2023-02-12','','END USER','2348131593035',0.00,2280.00,'02121029','2023-02-12 10:30:17',5,'cash','','',2280.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(150,'1','312','10','2023-02-12','','END USER','2348131593035',0.00,7480.00,'02121110','2023-02-12 11:11:07',5,'cash','','',7480.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(151,'1','312','10','2023-02-12','','ENUSER','2348131593035',0.00,4560.00,'02121142','2023-02-12 11:43:17',5,'cash','','',4560.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(152,'1','312','10','2023-02-12','','ENUSER','2348131593035',0.00,5000.00,'02121157','2023-02-12 12:05:42',5,'cash','','',5000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(153,'1','312','10','2023-02-12','','END USER','2348131593035',0.00,9500.00,'02121252','2023-02-12 13:01:51',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(154,'1','312','10','2023-02-12','','END USER','2348131593035',0.00,10000.00,'02121302','2023-02-12 13:03:21',5,'cash','','',10000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(155,'1','312','10','2023-02-12','','END USER','2348131593035',0.00,1520.00,'02121303','2023-02-12 13:04:30',5,'cash','','',1520.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(156,'1','312','10','2023-02-12','','END USER','2348131593035',0.00,9500.00,'02121305','2023-02-12 13:05:27',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(157,'1','312','10','2023-02-12','','END USER','2348131593035',0.00,1000.00,'02121514','2023-02-12 15:15:01',5,'cash','','',1000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(158,'1','312','10','2023-02-12','','END USER','2348131593035',0.00,9500.00,'02121515','2023-02-12 15:16:30',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(159,'1','312','10','2023-02-12','','END USER','2348131593035',0.00,4940.00,'02121517','2023-02-12 15:17:45',5,'cash','','',4940.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(160,'1','312','10','2023-02-12','','ENUSER','2348131593035',0.00,3040.00,'02121712','2023-02-12 17:13:12',5,'cash','','',3040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(161,'1','312','10','2023-02-12','','ENUSER','2348131593035',0.00,1520.00,'02121714','2023-02-12 17:14:32',5,'cash','','',1520.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(162,'1','312','10','2023-02-12','','ENUSER','2348131593035',0.00,4000.00,'02121715','2023-02-12 17:15:40',5,'cash','','',4000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(163,'1','312','10','2023-02-12','','ENUSER','2348131593035',0.00,2280.00,'02121716','2023-02-12 17:17:11',5,'cash','','',2280.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(164,'1','312','10','2023-02-12','','END USER','2348131593035',0.00,5000.00,'02121740','2023-02-12 17:41:21',5,'cash','','',5000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(165,'1','312','10','2023-02-12','','END USER','2348131593035',0.00,1520.00,'02121744','2023-02-12 17:45:09',5,'cash','','',1520.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(166,'1','312','10','2023-02-12','','END USER','2348131593035',0.00,5000.00,'02121806','2023-02-12 18:07:00',5,'cash','','',5000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(167,'1','312','10','2023-02-12','','END USER','2348131593035',0.00,3040.00,'02121807','2023-02-12 18:08:18',5,'cash','','',3040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(168,'1','312','10','2023-02-12','','END USER','2348131593035',0.00,23256.00,'02121934','2023-02-12 19:35:10',5,'cash','','',23256.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(169,'1','312','11','2023-02-14','','END USER','2348131593035',0.00,2280.00,'02140749','2023-02-14 07:50:01',5,'cash','','',2280.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(170,'1','312','11','2023-02-14','','END USER','2348131593035',0.00,5280.00,'02140750','2023-02-14 07:51:28',5,'cash','','',5280.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(171,'1','312','11','2023-02-14','','END USER','2348131593035',0.00,9500.00,'02140752','2023-02-14 07:53:23',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(172,'1','312','11','2023-02-14','','END USER','2348131593035',0.00,2000.00,'02140753','2023-02-14 07:54:24',5,'cash','','',2000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(173,'1','312','11','2023-02-14','','END USER  ','2348131593035',0.00,4560.00,'02140801','2023-02-14 09:01:55',5,'cash','','',4560.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(174,'1','312','11','2023-02-14','','END USER','2348131593035',0.00,2500.00,'02140915','2023-02-14 09:16:23',5,'cash','','',2500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(175,'1','312','11','2023-02-14','','END USER','2348131593035',0.00,3800.00,'02140917','2023-02-14 09:32:47',5,'cash','','',3800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(176,'1','312','11','2023-02-14','','ENUSER','2348131593035',0.00,4600.00,'02140955','2023-02-14 09:57:13',5,'cash','','',4600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(177,'1','312','11','2023-02-14','','END USER','2348131593035',0.00,2280.00,'02141034','2023-02-14 10:35:19',5,'cash','','',2280.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(178,'1','312','11','2023-02-14','','END USER','2348131593035',0.00,9500.00,'02141038','2023-02-14 10:40:41',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(179,'1','312','11','2023-02-14','','END USER','2348131593035',0.00,4560.00,'02141043','2023-02-14 11:34:39',5,'cash','','',4560.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(180,'1','312','11','2023-02-14','','END USER','2348131593035',0.00,7600.00,'02141206','2023-02-14 12:09:25',5,'cash','','',7600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(181,'1','312','11','2023-02-14','','END USER','2348131593035',0.00,4000.00,'02141217','2023-02-14 12:17:37',5,'cash','','',4000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(182,'1','312','11','2023-02-14','','END USER','2348131593035',0.00,1520.00,'02141403','2023-02-14 14:03:42',5,'cash','','',1520.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(183,'1','312','11','2023-02-14','','END USER','2348131593035',0.00,2660.00,'02141404','2023-02-14 14:04:46',5,'cash','','',2660.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(184,'1','312','11','2023-02-14','','END USER','2348131593035',0.00,2000.00,'02141408','2023-02-14 14:08:52',5,'cash','','',2000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(185,'1','312','11','2023-02-14','','END USER','2348131593035',0.00,4000.00,'02141412','2023-02-14 14:13:17',5,'cash','','',4000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(186,'1','312','12','2023-02-14','','END USER','2348131593035',0.00,5040.00,'02141504','2023-02-14 15:05:47',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(187,'1','312','12','2023-02-14','','END USER','2348131593035',0.00,6100.00,'02141534','2023-02-14 15:38:02',5,'cash','','',6100.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(188,'1','312','12','2023-02-14','','END USER','2348131593035',0.00,1450.00,'02141600','2023-02-14 16:01:13',5,'cash','','',1450.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(189,'1','312','12','2023-02-14','','END USER','2348131593035',0.00,4320.00,'02141856','2023-02-14 18:59:28',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(190,'1','312','12','2023-02-14','','END USER','2348131593035',0.00,2160.00,'02141900','2023-02-14 19:00:54',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(191,'1','312','12','2023-02-14','','END USER','2348131593035',0.00,800.00,'02141901','2023-02-14 19:01:52',5,'cash','','',800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(192,'1','312','12','2023-02-14','','END USER','2348131593035',0.00,1440.00,'02141902','2023-02-14 19:02:59',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(193,'1','312','12','2023-02-14','','END USER','2348131593035',0.00,2000.00,'02141903','2023-02-14 19:04:05',5,'cash','','',2000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(194,'1','312','12','2023-02-14','','END USER','2348131593035',0.00,9600.00,'02141911','2023-02-14 19:13:00',5,'cash','','',9600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(195,'1','312','12','2023-02-14','','END USER','2348131593035',0.00,9000.00,'02141922','2023-02-14 19:22:47',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(196,'1','312','12','2023-02-14','','END USER','2348131593035',0.00,9000.00,'02142013','2023-02-14 20:14:39',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(197,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,3600.00,'02150725','2023-02-15 07:26:10',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(198,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,9000.00,'02150750','2023-02-15 07:54:03',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(199,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,4320.00,'02150801','2023-02-15 08:02:13',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(200,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,2880.00,'02151012','2023-02-15 10:13:13',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(201,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,4320.00,'02151017','2023-02-15 10:18:10',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(202,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,2280.00,'02151021','2023-02-15 10:22:14',5,'cash','','',2280.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(203,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,4000.00,'02151102','2023-02-15 11:03:10',5,'cash','','',4000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(204,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,9000.00,'02151104','2023-02-15 11:42:27',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(205,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,3600.00,'02151201','2023-02-15 12:03:11',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(206,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,4320.00,'02151211','2023-02-15 12:11:41',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(207,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,2880.00,'02151213','2023-02-15 12:49:12',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(208,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,4000.00,'02151322','2023-02-15 13:23:13',5,'cash','','',4000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(209,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,4320.00,'02151347','2023-02-15 13:51:50',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(210,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,2880.00,'02151527','2023-02-15 15:30:13',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(211,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,4350.00,'02151702','2023-02-15 17:03:46',5,'cash','','',4350.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(212,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,9000.00,'02151709','2023-02-15 17:10:30',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(213,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,3000.00,'02151712','2023-02-15 17:39:49',5,'cash','','',3000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(214,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,4320.00,'02151741','2023-02-15 17:48:46',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(215,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,2160.00,'02151812','2023-02-15 18:13:34',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(216,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,7200.00,'02151850','2023-02-15 18:50:46',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(217,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,1400.00,'02151851','2023-02-15 18:51:42',5,'cash','','',1400.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(218,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,3000.00,'02151852','2023-02-15 18:52:45',5,'cash','','',3000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(219,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,3600.00,'02151853','2023-02-15 18:53:48',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(220,'1','312','13','2023-02-15','','END USER','2348131593035',0.00,12909.60,'02151908','2023-02-15 19:42:17',5,'cash','','',12909.60,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(222,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,9000.00,'02160713','2023-02-16 07:30:08',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(223,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,1440.00,'02160811','2023-02-16 08:11:52',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(224,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,5040.00,'02160812','2023-02-16 08:28:19',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(225,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,4320.00,'02160833','2023-02-16 08:34:20',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(226,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,4320.00,'02160841','2023-02-16 08:41:37',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(227,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,5040.00,'02160846','2023-02-16 08:49:03',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(228,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,9000.00,'02160850','2023-02-16 09:27:41',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(229,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,8640.00,'02160930','2023-02-16 09:32:49',5,'cash','','',8640.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(230,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,2000.00,'02161003','2023-02-16 10:03:22',5,'cash','','',2000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(231,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,7200.00,'02161004','2023-02-16 10:06:57',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(232,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,2160.00,'02161008','2023-02-16 10:16:31',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(233,'1','312','14','2023-02-16','','ENUSER','2348131593035',0.00,18000.00,'02161023','2023-02-16 10:33:31',5,'cash','','',18000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(234,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,1500.00,'02161035','2023-02-16 11:17:04',5,'cash','','',1500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(235,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,5760.00,'02161232','2023-02-16 12:32:56',5,'cash','','',5760.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(237,'1','312','14','2023-02-16','','ENUSER','2348131593035',0.00,5040.00,'02161326','2023-02-16 13:27:11',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(238,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,36000.00,'02161416','2023-02-16 14:16:44',5,'cash','','',36000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(239,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,1450.00,'02161533','2023-02-16 15:34:43',5,'cash','','',1450.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(240,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,9000.00,'02161536','2023-02-16 15:36:48',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(241,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,8640.00,'02161557','2023-02-16 16:51:02',5,'cash','','',8640.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(242,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,3600.00,'02161708','2023-02-16 17:09:41',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(243,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,4320.00,'02161721','2023-02-16 17:22:40',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(244,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,7200.00,'02161734','2023-02-16 17:50:09',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(245,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,2160.00,'02161759','2023-02-16 18:00:04',2,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(246,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,1778.40,'02161811','2023-02-16 18:12:22',5,'cash','','',1778.40,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(247,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,9000.00,'02161822','2023-02-16 18:22:57',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(248,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,3600.00,'02161844','2023-02-16 18:48:37',2,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(249,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,2000.00,'02161849','2023-02-16 18:50:07',5,'cash','','',2000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(250,'1','312','14','2023-02-16','','END USER','2348131593035',0.00,2160.00,'02161855','2023-02-16 18:55:49',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(251,'1','312','15','2023-02-17','','END USER','2348131593035',0.00,11160.00,'02170707','2023-02-17 07:12:07',5,'cash','','',11160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(252,'1','312','15','2023-02-17','','END USER','2348131593035',0.00,7200.00,'02170728','2023-02-17 08:32:58',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(256,'1','312','15','2023-02-17','','END USER','2348131593035',0.00,5000.00,'02170837','2023-02-17 09:13:11',5,'cash','','',5000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(259,'1','312','15','2023-02-17','','ENUSER','2348131593035',0.00,1450.00,'02171055','2023-02-17 10:56:02',5,'cash','','',2900.00,1450.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(260,'1','312','15','2023-02-17','','ENUSER','2348131593035',0.00,2160.00,'02171059','2023-02-17 11:01:53',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(261,'1','312','15','2023-02-17','','END USER','2348131593035',0.00,2160.00,'02171138','2023-02-17 11:38:59',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(262,'1','312','15','2023-02-17','','END USER','2348131593035',0.00,7200.00,'02171139','2023-02-17 11:40:12',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(263,'1','312','15','2023-02-17','','END USER','2348131593035',0.00,9000.00,'02171200','2023-02-17 12:09:59',5,'cash','','',18000.00,9000.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(264,'1','312','15','2023-02-17','','END USER','2348131593035',0.00,3600.00,'02171501','2023-02-17 15:02:10',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(265,'1','312','15','2023-02-17','','END USER','2348131593035',0.00,3600.00,'02171503','2023-02-17 15:04:27',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(266,'1','312','15','2023-02-17','','END USER','2348131593035',0.00,4300.00,'02171505','2023-02-17 15:05:35',5,'cash','','',4300.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(267,'1','312','15','2023-02-17','','END USER','2348131593035',0.00,1000.00,'02171509','2023-02-17 15:10:04',5,'cash','','',1000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(268,'1','312','15','2023-02-17','','END USER','2348131593035',0.00,4320.00,'02171515','2023-02-17 15:20:26',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(269,'1','312','15','2023-02-17','','END USER','2348131593035',0.00,4800.00,'02171523','2023-02-17 15:32:03',5,'cash','','',4800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(270,'1','312','15','2023-02-17','','END USER','2348131593035',0.00,3000.00,'02171533','2023-02-17 16:05:08',5,'cash','','',3000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(271,'1','312','15','2023-02-17','','END USER','2348131593035',0.00,5000.00,'02171745','2023-02-17 17:46:33',5,'cash','','',5000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(272,'1','312','15','2023-02-17','','END USER','2348131593035',0.00,3600.00,'02171747','2023-02-17 17:48:11',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(273,'1','312','15','2023-02-17','','END USER','2348131593035',0.00,1400.00,'02171748','2023-02-17 17:49:08',5,'cash','','',1400.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(274,'1','312','15','2023-02-17','','END USER','2348131593035',0.00,2000.00,'02171750','2023-02-17 17:53:17',5,'cash','','',2000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(275,'1','312','15','2023-02-17','','END USER','2348131593035',0.00,720.00,'02171756','2023-02-17 17:56:55',5,'cash','','',720.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(276,'1','312','15','2023-02-17','','END USER','2348131593035',0.00,9000.00,'02171810','2023-02-17 18:10:57',2,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(277,'1','312','15','2023-02-17','','END USER','2348131593035',0.00,9360.00,'02171820','2023-02-17 18:25:16',5,'cash','','',9360.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(278,'1','312','15','2023-02-17','','ENUSER','2348131593035',0.00,8496.00,'02171915','2023-02-17 19:15:36',5,'cash','','',8496.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(279,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,10800.00,'02180743','2023-02-18 07:45:43',5,'cash','','',10800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(280,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,14040.00,'02180747','2023-02-18 07:48:28',5,'cash','','',14040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(281,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,3000.00,'02180751','2023-02-18 09:03:14',5,'cash','','',3000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(282,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,9000.00,'02180904','2023-02-18 09:04:58',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(283,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,9000.00,'02180905','2023-02-18 09:06:30',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(284,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,720.00,'02180909','2023-02-18 09:14:20',5,'cash','','',720.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(285,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,7200.00,'02180927','2023-02-18 09:27:36',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(286,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,16560.00,'02180930','2023-02-18 09:38:08',5,'cash','','',16560.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(287,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,4320.00,'02180947','2023-02-18 09:48:53',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(288,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,1450.00,'02180951','2023-02-18 09:52:33',5,'cash','','',1450.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(289,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,2160.00,'02180954','2023-02-18 10:23:31',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(290,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,3600.00,'02181106','2023-02-18 11:18:12',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(291,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,3600.00,'02181119','2023-02-18 12:03:08',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(292,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,5040.00,'02181209','2023-02-18 12:10:13',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(293,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,2160.00,'02181211','2023-02-18 12:14:00',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(294,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,3600.00,'02181215','2023-02-18 12:21:19',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(295,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,5760.00,'02181242','2023-02-18 12:46:02',5,'cash','','',5760.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(296,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,3600.00,'02181250','2023-02-18 12:56:07',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(297,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,4320.00,'02181302','2023-02-18 13:35:38',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(298,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,3600.00,'02181338','2023-02-18 13:39:14',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(299,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,7920.00,'02181343','2023-02-18 14:12:34',5,'cash','','',7920.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(300,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,3600.00,'02181511','2023-02-18 15:14:31',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(301,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,4320.00,'02181515','2023-02-18 15:15:38',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(302,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,9000.00,'02181516','2023-02-18 15:16:41',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(303,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,33120.00,'02181519','2023-02-18 15:22:06',5,'cash','','',33120.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(304,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,5040.00,'02181532','2023-02-18 15:32:54',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(305,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,9000.00,'02181536','2023-02-18 15:37:26',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(307,'1','312','16','2023-02-18','1','VICTOR GAS','08034183596',0.00,139400.00,'02181604','2023-02-18 16:04:49',5,'cash','','',139400.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(308,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,2160.00,'02181633','2023-02-18 16:33:46',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(309,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,2880.00,'02181634','2023-02-18 16:34:50',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(310,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,1300.00,'02181635','2023-02-18 16:41:14',5,'cash','','',1300.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(311,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,9000.00,'02181657','2023-02-18 16:57:53',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(312,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,9000.00,'02181703','2023-02-18 17:04:00',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(313,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,2200.00,'02181704','2023-02-18 17:05:47',5,'cash','','',2200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(314,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,5040.00,'02181706','2023-02-18 17:09:12',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(315,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,2160.00,'02181710','2023-02-18 17:23:42',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(316,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,2200.00,'02181737','2023-02-18 17:38:21',5,'cash','','',2200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(317,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,1450.00,'02181740','2023-02-18 17:41:32',5,'cash','','',1450.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(318,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,6480.00,'02181805','2023-02-18 18:05:41',5,'cash','','',6480.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(319,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,5040.00,'02181807','2023-02-18 18:07:48',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(320,'1','312','16','2023-02-18','2','UKLEO GAS','08064145320',0.00,261501.75,'02181812','2023-02-18 18:13:09',5,'cash','','',261501.75,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(321,'1','312','16','2023-02-18','','END USER','2348131593035',0.00,10800.00,'02181816','2023-02-18 18:17:04',5,'cash','','',10800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(322,'1','312','16','2023-02-18','','ENUSER','2348131593035',0.00,1908.00,'02181900','2023-02-18 19:00:38',5,'cash','','',1908.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(323,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,8600.00,'02190838','2023-02-19 08:38:57',5,'cash','','',8600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(324,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,7200.00,'02190841','2023-02-19 08:51:03',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(325,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,2160.00,'02190853','2023-02-19 08:53:36',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(326,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,9000.00,'02190855','2023-02-19 08:56:16',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(327,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,2000.00,'02191103','2023-02-19 11:03:42',5,'cash','','',2000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(328,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,9000.00,'02191104','2023-02-19 11:04:54',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(329,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,1500.00,'02191105','2023-02-19 11:07:38',5,'cash','','',1500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(330,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,3600.00,'02191108','2023-02-19 11:08:33',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(331,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,4320.00,'02191109','2023-02-19 11:09:30',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(332,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,3600.00,'02191109','2023-02-19 11:10:20',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(333,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,4320.00,'02191111','2023-02-19 11:12:23',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(334,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,1440.00,'02191112','2023-02-19 11:13:25',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(335,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,5040.00,'02191133','2023-02-19 11:34:24',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(336,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,8280.00,'02191134','2023-02-19 11:38:04',5,'cash','','',8280.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(337,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,1800.00,'02191139','2023-02-19 12:00:35',5,'cash','','',1800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(338,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,5040.00,'02191331','2023-02-19 13:32:22',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(339,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,7200.00,'02191342','2023-02-19 13:43:01',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(340,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,2160.00,'02191343','2023-02-19 13:43:48',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(341,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,2160.00,'02191344','2023-02-19 13:44:46',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(342,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,7200.00,'02191347','2023-02-19 13:50:15',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(343,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,21600.00,'02191356','2023-02-19 13:56:56',5,'cash','','',21600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(344,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,1450.00,'02191505','2023-02-19 15:05:57',5,'cash','','',1450.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(345,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,2900.00,'02191506','2023-02-19 15:15:18',5,'cash','','',2900.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(346,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,9000.00,'02191516','2023-02-19 15:16:41',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(347,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,9000.00,'02191520','2023-02-19 15:20:27',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(348,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,4320.00,'02191650','2023-02-19 16:51:10',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(349,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,3600.00,'02191651','2023-02-19 17:00:43',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(350,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,3600.00,'02191743','2023-02-19 17:45:13',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(351,'1','312','17','2023-02-19','','ENUSER','2348131593035',0.00,5040.00,'02191745','2023-02-19 17:46:39',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(352,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,16200.00,'02191747','2023-02-19 17:47:43',5,'cash','','',16200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(353,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,18000.00,'02191748','2023-02-19 17:48:50',5,'cash','','',18000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(354,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,2160.00,'02191749','2023-02-19 17:50:16',2,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(355,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,7200.00,'02191750','2023-02-19 17:51:14',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(356,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,5040.00,'02191751','2023-02-19 17:53:44',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(357,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,1800.00,'02191754','2023-02-19 17:55:43',5,'cash','','',1800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(358,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,1450.00,'02191756','2023-02-19 17:58:25',5,'cash','','',1450.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(359,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,36000.00,'02191803','2023-02-19 18:04:36',5,'cash','','',36000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(360,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,5400.00,'02191804','2023-02-19 18:07:45',5,'cash','','',5400.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(361,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,9360.00,'02191849','2023-02-19 18:50:34',2,'cash','','',9360.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(362,'1','312','17','2023-02-19','','END USER','2348131593035',0.00,11000.00,'02191923','2023-02-19 19:24:49',5,'cash','','',11000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(363,'1','312','17','2023-02-19','','ENUSER','2348131593035',0.00,921.60,'02191935','2023-02-19 19:36:10',5,'cash','','',921.60,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(364,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,3600.00,'02210740','2023-02-21 08:01:31',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(365,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,7200.00,'02210802','2023-02-21 08:46:16',2,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(366,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,4320.00,'02210846','2023-02-21 08:47:17',2,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(367,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,3000.00,'02210847','2023-02-21 08:48:42',5,'cash','','',3000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(368,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,12600.00,'02210849','2023-02-21 08:49:51',2,'cash','','',12600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(369,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,9000.00,'02210850','2023-02-21 09:01:23',2,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(370,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,3600.00,'02210901','2023-02-21 09:02:16',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(371,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,7200.00,'02210902','2023-02-21 09:18:14',2,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(372,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,7920.00,'02210918','2023-02-21 09:20:00',5,'cash','','',7920.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(373,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,81600.00,'02210920','2023-02-21 09:50:12',5,'cash','','',81600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(374,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,2200.00,'02210950','2023-02-21 09:51:34',5,'cash','','',2200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(376,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,9000.00,'02210951','2023-02-21 09:53:03',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(377,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,3600.00,'02211029','2023-02-21 10:29:46',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(378,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,2200.00,'02211030','2023-02-21 10:55:04',5,'cash','','',2200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(379,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,9000.00,'02211113','2023-02-21 11:14:05',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(380,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,9000.00,'02211116','2023-02-21 11:54:00',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(381,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,4320.00,'02211205','2023-02-21 12:06:18',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(382,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,4320.00,'02211206','2023-02-21 12:08:45',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(383,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,2160.00,'02211209','2023-02-21 12:17:20',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(384,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,9000.00,'02211225','2023-02-21 12:25:42',2,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(385,'1','312','18','2023-02-21','4','PZ GAS','08063508191',0.00,74800.00,'02211226','2023-02-21 12:28:25',5,'cash','','',74800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(386,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,2000.00,'02211228','2023-02-21 12:29:12',5,'cash','','',2000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(387,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,9000.00,'02211230','2023-02-21 12:35:36',2,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(388,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,5000.00,'02211237','2023-02-21 12:46:36',5,'cash','','',5000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(389,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,2160.00,'02211309','2023-02-21 13:10:10',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(390,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,2160.00,'02211311','2023-02-21 13:13:29',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(391,'1','312','18','2023-02-21','2','UKLEO GAS','08064145320',0.00,438480.00,'02211315','2023-02-21 13:16:54',5,'cash','','',438480.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(392,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,3600.00,'02211317','2023-02-21 13:20:42',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(393,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,1450.00,'02211321','2023-02-21 13:22:52',5,'cash','','',1450.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(394,'1','312','18','2023-02-21','','ENUSER','2348131593035',0.00,720.00,'02211343','2023-02-21 13:44:16',5,'cash','','',720.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(395,'1','312','18','2023-02-21','4','PZ GAS','08063508191',0.00,34000.00,'02211349','2023-02-21 13:52:26',5,'cash','','',34000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(396,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,3600.00,'02211404','2023-02-21 14:05:25',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(397,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,1450.00,'02211414','2023-02-21 14:15:11',5,'cash','','',1450.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(398,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,2200.00,'02211448','2023-02-21 14:49:13',5,'cash','','',2200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(399,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,9000.00,'02211455','2023-02-21 14:56:15',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(400,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,9000.00,'02211628','2023-02-21 16:28:51',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(401,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,3600.00,'02211629','2023-02-21 16:30:14',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(402,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,2160.00,'02211632','2023-02-21 16:32:53',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(403,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,4320.00,'02211634','2023-02-21 16:35:21',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(404,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,4320.00,'02211645','2023-02-21 16:47:32',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(405,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,2160.00,'02211653','2023-02-21 16:55:01',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(406,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,4320.00,'02211659','2023-02-21 17:00:16',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(407,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,3600.00,'02211703','2023-02-21 17:04:58',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(408,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,1440.00,'02211752','2023-02-21 17:55:38',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(409,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,4320.00,'02211757','2023-02-21 17:58:45',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(410,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,9000.00,'02211822','2023-02-21 18:28:09',2,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(411,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,4320.00,'02211846','2023-02-21 18:48:07',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(412,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,750.00,'02211848','2023-02-21 18:49:19',5,'cash','','',750.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(414,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,3250.00,'02211856','2023-02-21 18:57:33',5,'cash','','',3250.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(415,'1','312','18','2023-02-21','','END USER','2348131593035',0.00,8500.00,'02211858','2023-02-21 18:58:48',2,'cash','','',8500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(416,'1','312','18','2023-02-21','3','JOSIAH GAS','07033059724',0.00,81600.00,'02212011','2023-02-21 20:13:03',5,'cash','','',81600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(417,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,1450.00,'02220719','2023-02-22 07:39:04',5,'cash','','',1450.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(418,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,3200.00,'02220746','2023-02-22 08:15:59',5,'cash','','',3200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(419,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,3600.00,'02220832','2023-02-22 08:46:30',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(420,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,3600.00,'02220847','2023-02-22 08:48:22',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(421,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,15000.00,'02220855','2023-02-22 09:00:53',5,'cash','','',15000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(422,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,9000.00,'02220907','2023-02-22 09:08:28',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(423,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,3600.00,'02220939','2023-02-22 09:39:40',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(424,'1','312','19','2023-02-22','3','JOSIAH GAS','07033059724',0.00,40800.00,'02220940','2023-02-22 09:40:51',5,'cash','','',40800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(426,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,9500.00,'02220954','2023-02-22 09:55:16',5,'cash','','',9500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(427,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,9000.00,'02221012','2023-02-22 10:19:02',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(428,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,3600.00,'02221020','2023-02-22 10:22:08',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(429,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,5040.00,'02221100','2023-02-22 11:02:04',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(430,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,5000.00,'02221140','2023-02-22 11:58:37',5,'cash','','',5000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(431,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,3600.00,'02221217','2023-02-22 12:18:27',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(432,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,2880.00,'02221222','2023-02-22 12:37:54',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(433,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,5040.00,'02221312','2023-02-22 13:13:59',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(435,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,2200.00,'02221333','2023-02-22 13:33:45',5,'cash','','',2200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(436,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,9000.00,'02221344','2023-02-22 13:52:23',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(437,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,5760.00,'02221408','2023-02-22 14:08:55',5,'cash','','',5760.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(438,'1','312','19','2023-02-22','','END USER  ','2348131593035',0.00,4320.00,'02221440','2023-02-22 14:42:58',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(439,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,9360.00,'02221444','2023-02-22 14:45:49',5,'cash','','',9360.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(440,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,5000.00,'02221502','2023-02-22 15:03:05',5,'cash','','',5000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(441,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,9000.00,'02221513','2023-02-22 15:15:54',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(442,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,2160.00,'02221517','2023-02-22 15:22:14',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(444,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,9000.00,'02221524','2023-02-22 15:25:10',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(445,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,7200.00,'02221529','2023-02-22 16:14:05',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(446,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,6480.00,'02221628','2023-02-22 16:29:59',5,'cash','','',6480.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(447,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,2500.00,'02221639','2023-02-22 16:40:10',5,'cash','','',2500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(448,'1','312','19','2023-02-22','','END USER','2348131593035',0.00,2200.00,'02221643','2023-02-22 16:45:11',5,'cash','','',2200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(449,'1','312','19','2023-02-22','','ENUSER','2348131593035',0.00,3000.00,'02221725','2023-02-22 17:25:25',5,'cash','','',3000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(450,'1','312','19','2023-02-22','','ENUSER','2348131593035',0.00,5100.00,'02221747','2023-02-22 17:48:26',5,'cash','','',5100.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(451,'1','312','19','2023-02-22','4','PZ GAS','08063508191',0.00,74800.00,'02221810','2023-02-22 18:11:05',5,'cash','','',74800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(452,'1','312','19','2023-02-22','','ENUSER','2348131593035',0.00,9000.00,'02221843','2023-02-22 18:43:59',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(453,'1','312','19','2023-02-22','','ENUSER','2348131593035',0.00,1000.00,'02221846','2023-02-22 18:47:25',5,'cash','','',1000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(454,'1','312','19','2023-02-22','','END USER','2348134818197',0.00,9936.00,'02221926','2023-02-22 19:27:08',5,'cash','','',9936.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(455,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,2500.00,'02230737','2023-02-23 07:37:39',5,'cash','','',2500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(456,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,9000.00,'02230738','2023-02-23 07:49:51',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(457,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,4320.00,'02230757','2023-02-23 07:58:38',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(458,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,2880.00,'02230809','2023-02-23 08:13:23',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(459,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,1440.00,'02230814','2023-02-23 08:16:07',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(460,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,2880.00,'02230817','2023-02-23 08:18:48',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(461,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,33840.00,'02230824','2023-02-23 08:26:13',5,'cash','','',33840.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(462,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,7920.00,'02230856','2023-02-23 08:57:24',5,'cash','','',7920.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(463,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,2160.00,'02230900','2023-02-23 09:01:06',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(464,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,3600.00,'02230903','2023-02-23 09:03:41',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(465,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,3600.00,'02230905','2023-02-23 09:06:40',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(466,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,5050.00,'02230907','2023-02-23 09:08:13',5,'cash','','',5050.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(467,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,2160.00,'02230916','2023-02-23 09:16:56',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(468,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,4320.00,'02230917','2023-02-23 09:18:35',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(469,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,9000.00,'02230922','2023-02-23 09:23:37',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(470,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,5040.00,'02230941','2023-02-23 09:45:29',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(471,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,12240.00,'02230950','2023-02-23 09:51:09',5,'cash','','',12240.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(472,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,2900.00,'02230954','2023-02-23 09:55:57',5,'cash','','',2900.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(473,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,3600.00,'02230957','2023-02-23 09:57:45',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(474,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,10080.00,'02231000','2023-02-23 10:01:39',5,'cash','','',10080.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(475,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,4320.00,'02231015','2023-02-23 10:16:42',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(476,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,12240.00,'02231034','2023-02-23 10:39:46',5,'cash','','',12240.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(477,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,2880.00,'02231047','2023-02-23 10:48:44',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(478,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,4320.00,'02231113','2023-02-23 11:14:01',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(479,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,2160.00,'02231116','2023-02-23 11:17:10',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(480,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,6480.00,'02231150','2023-02-23 11:51:27',5,'cash','','',6480.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(481,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,2880.00,'02231204','2023-02-23 12:10:14',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(482,'1','312','20','2023-02-23','','END USER','2348134818197',0.00,2829.60,'02231253','2023-02-23 12:54:27',5,'cash','','',2829.60,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(483,'1','312','21','2023-02-23','','ENUSER','2348131593035',0.00,9000.00,'02231306','2023-02-23 13:06:42',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(484,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,7200.00,'02231307','2023-02-23 13:07:28',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(485,'1','312','21','2023-02-23','','ENUSER','2348131593035',0.00,8640.00,'02231307','2023-02-23 13:08:15',5,'cash','','',8640.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(486,'1','312','21','2023-02-23','','ENUSER','2348131593035',0.00,9000.00,'02231308','2023-02-23 13:09:10',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(487,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,2570.40,'02231309','2023-02-23 13:10:35',5,'cash','','',2570.40,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(488,'1','312','21','2023-02-23','4','PZ GAS','08063508191',0.00,187000.00,'02231311','2023-02-23 13:13:12',5,'cash','','',187000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(489,'1','312','21','2023-02-23','3','JOSIAH GAS','07033059724',0.00,81600.00,'02231313','2023-02-23 13:14:12',5,'cash','','',81600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(490,'1','312','21','2023-02-23','1','VICTOR GAS','08034183596',0.00,188700.00,'02231314','2023-02-23 13:15:37',5,'cash','','',188700.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(491,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,5760.00,'02231433','2023-02-23 14:34:31',5,'cash','','',5760.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(492,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,5040.00,'02231435','2023-02-23 14:35:53',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(493,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,9000.00,'02231438','2023-02-23 14:40:42',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(494,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,9000.00,'02231441','2023-02-23 14:42:26',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(495,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,9000.00,'02231444','2023-02-23 14:45:29',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(496,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,1440.00,'02231446','2023-02-23 14:47:18',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(497,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,5040.00,'02231454','2023-02-23 14:55:34',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(498,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,12240.00,'02231525','2023-02-23 15:29:55',5,'cash','','',12240.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(499,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,18000.00,'02231531','2023-02-23 15:32:31',5,'cash','','',18000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(500,'1','312','21','2023-02-23','','ENUSER','2348131593035',0.00,3600.00,'02231534','2023-02-23 15:34:44',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(501,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,9000.00,'02231538','2023-02-23 15:39:21',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(502,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,4320.00,'02231553','2023-02-23 15:56:38',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(503,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,5040.00,'02231600','2023-02-23 16:00:42',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(504,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,1440.00,'02231630','2023-02-23 16:31:46',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(505,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,1800.00,'02231636','2023-02-23 16:37:37',5,'cash','','',1800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(506,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,7200.00,'02231641','2023-02-23 16:42:43',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(507,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,9000.00,'02231643','2023-02-23 16:44:38',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(508,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,1440.00,'02231646','2023-02-23 16:48:12',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(509,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,9000.00,'02231702','2023-02-23 17:02:48',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(510,'1','312','21','2023-02-23','5','212 GAS','07034290518',0.00,21080.00,'02231705','2023-02-23 17:07:45',2,'cash','','',21080.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(511,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,1440.00,'02231717','2023-02-23 17:17:47',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(512,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,4320.00,'02231733','2023-02-23 17:34:18',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(513,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,2200.00,'02231737','2023-02-23 17:39:14',5,'cash','','',2200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(514,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,9000.00,'02231755','2023-02-23 17:57:53',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(515,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,7200.00,'02231803','2023-02-23 18:04:23',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(516,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,1440.00,'02231838','2023-02-23 18:40:13',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(517,'1','312','21','2023-02-23','','ENUSER','2348131593035',0.00,4320.00,'02231841','2023-02-23 18:42:48',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(518,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,7200.00,'02231843','2023-02-23 18:43:51',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(519,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,9000.00,'02231850','2023-02-23 18:51:15',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(521,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,3600.00,'02231854','2023-02-23 18:55:41',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(522,'1','312','21','2023-02-23','','ENUSER','2348131593035',0.00,5191.20,'02231913','2023-02-23 19:13:31',5,'cash','','',5191.20,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(523,'1','312','21','2023-02-23','','END USER','2348134818197',0.00,14400.00,'02231913','2023-02-23 19:14:17',5,'cash','','',14400.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(524,'1','312','21','2023-02-23','','ENUSER','2348131593035',0.00,14400.00,'02231914','2023-02-23 19:14:57',5,'cash','','',14400.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(525,'1','312','21','2023-02-23','5','212 GAS','07034290518',0.00,20359.20,'02231919','2023-02-23 19:19:39',5,'cash','','',20359.20,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(526,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,6050.00,'02240821','2023-02-24 08:21:58',5,'cash','','',6050.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(527,'1','312','22','2023-02-24','','ENUSER','2348131593035',0.00,5000.00,'02240844','2023-02-24 08:45:18',5,'cash','','',5000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(528,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,10800.00,'02240846','2023-02-24 08:47:38',5,'cash','','',10800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(529,'1','312','22','2023-02-24','','ENUSER','2348131593035',0.00,2880.00,'02240852','2023-02-24 08:52:57',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(530,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,3600.00,'02240859','2023-02-24 08:59:21',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(531,'1','312','22','2023-02-24','','ENUSER','2348131593035',0.00,10800.00,'02240902','2023-02-24 09:02:55',5,'cash','','',10800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(532,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,3600.00,'02240932','2023-02-24 09:32:53',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(533,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,16200.00,'02240943','2023-02-24 09:44:58',5,'cash','','',16200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(534,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,5040.00,'02240956','2023-02-24 09:57:18',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(535,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,9000.00,'02241004','2023-02-24 10:05:26',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(536,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,7200.00,'02241012','2023-02-24 10:18:10',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(537,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,4320.00,'02241039','2023-02-24 10:40:17',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(538,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,3000.00,'02241041','2023-02-24 10:43:38',5,'cash','','',3000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(539,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,2880.00,'02241046','2023-02-24 11:17:59',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(540,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,4320.00,'02241120','2023-02-24 11:21:22',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(541,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,6480.00,'02241132','2023-02-24 11:34:22',5,'cash','','',6480.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(542,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,3600.00,'02241135','2023-02-24 11:41:21',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(543,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,9000.00,'02241142','2023-02-24 11:43:16',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(545,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,3600.00,'02241210','2023-02-24 12:11:10',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(546,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,2880.00,'02241214','2023-02-24 12:15:50',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(547,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,5040.00,'02241220','2023-02-24 12:22:48',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(548,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,4320.00,'02241224','2023-02-24 12:38:42',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(549,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,8640.00,'02241240','2023-02-24 12:41:53',5,'cash','','',8640.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(550,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,2160.00,'02241254','2023-02-24 12:55:44',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(551,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,5040.00,'02241307','2023-02-24 13:08:33',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(552,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,4320.00,'02241315','2023-02-24 13:16:06',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(553,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,4320.00,'02241321','2023-02-24 13:22:09',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(554,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,7920.00,'02241324','2023-02-24 13:25:35',5,'cash','','',7920.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(555,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,18000.00,'02241327','2023-02-24 13:28:41',5,'cash','','',18000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(556,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,5040.00,'02241334','2023-02-24 13:36:22',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(557,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,2000.00,'02241342','2023-02-24 13:44:24',5,'cash','','',2000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(558,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,2880.00,'02241356','2023-02-24 13:57:52',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(559,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,3600.00,'02241359','2023-02-24 14:00:27',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(560,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,2160.00,'02241401','2023-02-24 14:02:35',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(561,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,4680.00,'02241404','2023-02-24 14:04:58',5,'cash','','',4680.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(562,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,2880.00,'02241428','2023-02-24 14:29:29',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(563,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,18000.00,'02241434','2023-02-24 14:34:45',5,'cash','','',18000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(564,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,18000.00,'02241454','2023-02-24 15:20:34',5,'cash','','',18000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(565,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,10440.00,'02241524','2023-02-24 15:25:49',5,'cash','','',10440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(566,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,2880.00,'02241528','2023-02-24 15:28:49',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(567,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,2880.00,'02241540','2023-02-24 15:41:40',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(568,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,9000.00,'02241543','2023-02-24 15:44:25',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(569,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,4680.00,'02241545','2023-02-24 15:46:24',5,'cash','','',4680.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(570,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,3600.00,'02241548','2023-02-24 15:52:16',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(571,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,3600.00,'02241554','2023-02-24 15:56:01',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(572,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,1440.00,'02241557','2023-02-24 16:00:37',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(573,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,5040.00,'02241602','2023-02-24 16:05:07',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(574,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,2160.00,'02241613','2023-02-24 16:14:14',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(575,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,9000.00,'02241657','2023-02-24 16:58:43',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(576,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,1440.00,'02241703','2023-02-24 17:06:22',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(577,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,4320.00,'02241714','2023-02-24 17:15:49',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(578,'1','312','22','2023-02-24','','ENUSER','2348131593035',0.00,2160.00,'02241718','2023-02-24 17:23:50',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(579,'1','312','22','2023-02-24','','ENUSER','2348131593035',0.00,2160.00,'02241724','2023-02-24 17:24:44',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(580,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,2880.00,'02241725','2023-02-24 17:27:07',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(582,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,10800.00,'02241728','2023-02-24 17:28:56',5,'cash','','',10800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(583,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,5040.00,'02241729','2023-02-24 17:30:06',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(584,'1','312','22','2023-02-24','','ENUSER','2348131593035',0.00,7200.00,'02241731','2023-02-24 17:33:06',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(585,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,5040.00,'02241733','2023-02-24 17:35:20',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(586,'1','312','22','2023-02-24','','ENUSER','2348131593035',0.00,12240.00,'02241735','2023-02-24 17:37:04',5,'cash','','',12240.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(587,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,9000.00,'02241737','2023-02-24 17:37:53',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(589,'1','312','22','2023-02-24','','ENUSER','2348131593035',0.00,7200.00,'02241739','2023-02-24 17:42:08',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(590,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,8280.00,'02241744','2023-02-24 17:44:55',5,'cash','','',8280.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(591,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,1440.00,'02241745','2023-02-24 17:47:59',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(592,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,7920.00,'02241748','2023-02-24 17:49:32',5,'cash','','',7920.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(593,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,1440.00,'02241751','2023-02-24 18:04:23',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(594,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,5040.00,'02241804','2023-02-24 18:09:53',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(595,'1','312','22','2023-02-24','','ENUSER','2348131593035',0.00,6480.00,'02241810','2023-02-24 18:11:09',5,'cash','','',6480.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(597,'1','312','22','2023-02-24','','ENUSER','2348131593035',0.00,2160.00,'02241812','2023-02-24 18:13:06',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(598,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,3600.00,'02241813','2023-02-24 18:14:00',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(599,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,2900.00,'02241815','2023-02-24 18:15:26',5,'cash','','',2900.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(600,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,3600.00,'02241816','2023-02-24 18:22:06',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(601,'1','312','22','2023-02-24','','END USER','2348134818197',0.00,5400.00,'02241833','2023-02-24 18:33:20',5,'cash','','',5400.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(602,'1','312','22','2023-02-24','','END USER','2348131593035',0.00,16560.00,'02241837','2023-02-24 18:40:06',5,'cash','','',16560.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(603,'1','312','22','2023-02-24','','ENUSER','2348131593035',0.00,2900.00,'02241840','2023-02-24 18:42:58',5,'cash','','',2900.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(604,'1','312','22','2023-02-24','2','UKLEO GAS','08064145320',0.00,320213.25,'02241856','2023-02-24 18:57:33',5,'cash','','',320213.25,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(605,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,2160.00,'02280800','2023-02-28 08:01:27',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(606,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,2200.00,'02280839','2023-02-28 08:40:30',5,'cash','','',2200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(607,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,7200.00,'02280841','2023-02-28 08:42:15',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(608,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,9000.00,'02280843','2023-02-28 08:44:35',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(609,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,7200.00,'02280852','2023-02-28 08:53:31',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(610,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,1440.00,'02280927','2023-02-28 09:27:55',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(611,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,4320.00,'02280933','2023-02-28 09:33:47',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(612,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,3600.00,'02280948','2023-02-28 09:59:25',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(613,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,2880.00,'02281000','2023-02-28 10:00:42',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(614,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,720.00,'02281001','2023-02-28 10:01:51',5,'cash','','',720.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(615,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,4320.00,'02281017','2023-02-28 10:20:41',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(616,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,5040.00,'02281110','2023-02-28 11:11:18',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(617,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,5040.00,'02281117','2023-02-28 11:18:01',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(618,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,5040.00,'02281120','2023-02-28 11:20:33',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(619,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,3600.00,'02281154','2023-02-28 11:57:12',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(620,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,7200.00,'02281208','2023-02-28 12:08:31',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(621,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,2160.00,'02281228','2023-02-28 12:28:48',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(622,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,1500.00,'02281247','2023-02-28 12:48:25',5,'cash','','',1500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(623,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,3600.00,'02281351','2023-02-28 13:52:06',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(624,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,8640.00,'02281353','2023-02-28 13:54:49',5,'cash','','',8640.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(625,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,7920.00,'02281359','2023-02-28 14:19:50',5,'cash','','',7920.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(626,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,7980.00,'02281439','2023-02-28 14:40:58',5,'cash','','',7980.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(627,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,1440.00,'02281551','2023-02-28 15:52:24',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(628,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,9000.00,'02281559','2023-02-28 16:00:48',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(629,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,9000.00,'02281642','2023-02-28 16:42:52',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(630,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,1000.00,'02281646','2023-02-28 16:47:24',5,'cash','','',1000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(631,'1','312','23','2023-02-28','2','UKLEO GAS','08064145320',0.00,417116.25,'02281913','2023-02-28 19:13:50',5,'cash','','',417116.25,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(632,'1','312','23','2023-02-28','','END USER','2348134818197',0.00,23191.20,'02281916','2023-02-28 19:16:37',5,'cash','','',23191.20,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(633,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,5040.00,'03010741','2023-03-01 07:49:08',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(634,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,9000.00,'03010758','2023-03-01 07:59:10',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(635,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,2160.00,'03010815','2023-03-01 08:16:17',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(636,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,4680.00,'03010823','2023-03-01 08:24:12',5,'cash','','',4680.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(637,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,5040.00,'03010837','2023-03-01 08:37:30',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(638,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,6000.00,'03010848','2023-03-01 08:49:22',5,'cash','','',6000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(639,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,5040.00,'03010855','2023-03-01 08:57:17',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(640,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,7200.00,'03010937','2023-03-01 09:40:01',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(641,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,2880.00,'03011026','2023-03-01 10:26:48',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(642,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,4500.00,'03011037','2023-03-01 10:41:05',5,'cash','','',4500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(643,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,5040.00,'03011043','2023-03-01 10:43:38',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(644,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,4320.00,'03011045','2023-03-01 10:50:21',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(645,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,3600.00,'03011053','2023-03-01 12:15:40',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(646,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,3600.00,'03011248','2023-03-01 12:49:19',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(647,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,2160.00,'03011420','2023-03-01 14:20:39',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(648,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,4320.00,'03011433','2023-03-01 14:36:09',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(649,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,2880.00,'03011506','2023-03-01 15:07:45',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(650,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,4000.00,'03011508','2023-03-01 15:09:56',5,'cash','','',4000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(651,'1','312','24','2023-03-01','','ENUSER','2348131593035',0.00,2160.00,'03011737','2023-03-01 17:38:12',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(652,'1','312','24','2023-03-01','','ENUSER','2348131593035',0.00,2160.00,'03011739','2023-03-01 17:39:54',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(654,'1','312','24','2023-03-01','','ENUSER','2348131593035',0.00,2880.00,'03011742','2023-03-01 17:42:35',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(655,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,4320.00,'03011746','2023-03-01 17:51:42',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(656,'1','312','24','2023-03-01','','END USE','2348134818197',0.00,5040.00,'03011756','2023-03-01 18:13:04',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(657,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,3000.00,'03011822','2023-03-01 18:22:37',5,'cash','','',3000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(658,'1','312','24','2023-03-01','','ENUSER','2348131593035',0.00,9000.00,'03011823','2023-03-01 18:23:41',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(659,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,2160.00,'03011832','2023-03-01 18:33:28',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(660,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,2200.00,'03011836','2023-03-01 18:44:37',5,'cash','','',2200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(661,'1','312','24','2023-03-01','','END USER','2348134818197',0.00,9000.00,'03011846','2023-03-01 18:49:26',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(662,'1','312','24','2023-03-01','2','UKLEO GAS','08064145320',0.00,472122.00,'03011904','2023-03-01 19:05:10',5,'cash','','',472122.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(663,'1','312','24','2023-03-01','','ENUSER','2348131593035',0.00,3556.80,'03011908','2023-03-01 19:08:28',5,'cash','','',3556.80,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(664,'1','312','24','2023-03-01','','ENUSER','2348131593035',0.00,21600.00,'03011908','2023-03-01 19:09:08',5,'cash','','',21600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(665,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,5000.00,'03020827','2023-03-02 08:27:59',5,'cash','','',5000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(666,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,4320.00,'03020847','2023-03-02 08:47:47',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(667,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,5040.00,'03020856','2023-03-02 08:57:08',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(668,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,9000.00,'03020905','2023-03-02 09:08:26',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(669,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,5040.00,'03020910','2023-03-02 09:11:51',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(670,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,720.00,'03020934','2023-03-02 09:35:02',5,'cash','','',720.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(671,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,9000.00,'03021000','2023-03-02 10:00:37',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(672,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,2000.00,'03021003','2023-03-02 10:03:56',5,'cash','','',2000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(673,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,2160.00,'03021006','2023-03-02 10:08:29',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(674,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,9000.00,'03021104','2023-03-02 11:05:18',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(675,'1','312','25','2023-03-02','','ENUSER','2348131593035',0.00,1440.00,'03021115','2023-03-02 11:16:10',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(676,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,2160.00,'03021117','2023-03-02 11:52:01',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(677,'1','312','25','2023-03-02','','ENUSER','2348131593035',0.00,2160.00,'03021153','2023-03-02 12:20:31',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(678,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,2200.00,'03021222','2023-03-02 12:22:46',5,'cash','','',2200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(679,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,7200.00,'03021239','2023-03-02 12:40:19',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(680,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,3600.00,'03021242','2023-03-02 12:42:23',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(681,'1','312','25','2023-03-02','','ENUSER','2348131593035',0.00,7200.00,'03021313','2023-03-02 13:45:22',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(682,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,4320.00,'03021347','2023-03-02 13:47:25',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(683,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,3000.00,'03021359','2023-03-02 14:01:34',5,'cash','','',3000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(684,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,9000.00,'03021459','2023-03-02 15:00:14',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(685,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,4000.00,'03021502','2023-03-02 15:02:57',5,'cash','','',4000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(686,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,9000.00,'03021519','2023-03-02 15:26:57',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(687,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,4320.00,'03021534','2023-03-02 15:35:35',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(688,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,5040.00,'03021536','2023-03-02 15:37:14',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(689,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,9000.00,'03021608','2023-03-02 16:09:25',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(690,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,5040.00,'03021611','2023-03-02 16:13:26',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(691,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,4000.00,'03021631','2023-03-02 16:33:30',5,'cash','','',4000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(692,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,5040.00,'03021641','2023-03-02 16:42:37',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(693,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,9000.00,'03021700','2023-03-02 17:00:55',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(694,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,2160.00,'03021732','2023-03-02 17:35:22',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(695,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,2160.00,'03021737','2023-03-02 17:37:40',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(696,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,4320.00,'03021750','2023-03-02 17:51:09',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(697,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,5040.00,'03021805','2023-03-02 18:05:27',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(698,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,9000.00,'03021814','2023-03-02 18:14:51',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(699,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,5040.00,'03021815','2023-03-02 18:16:18',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(700,'1','312','25','2023-03-02','','END USER','2348134818197',0.00,9000.00,'03021822','2023-03-02 18:22:47',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(701,'1','312','25','2023-03-02','3','JOSIAH GAS','07033059724',0.00,81600.00,'03021905','2023-03-02 19:06:14',5,'cash','','',81600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(702,'1','312','25','2023-03-02','6','EMEKA GAS','08169860051',0.00,34000.00,'03021906','2023-03-02 19:07:09',5,'cash','','',34000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(703,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,5040.00,'03030921','2023-03-03 09:22:25',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(705,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,2160.00,'03031016','2023-03-03 10:17:56',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(706,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,9000.00,'03031055','2023-03-03 10:55:46',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(707,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,9000.00,'03031120','2023-03-03 11:23:59',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(708,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,4320.00,'03031127','2023-03-03 11:27:33',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(709,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,2160.00,'03031144','2023-03-03 11:44:48',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(710,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,2880.00,'03031146','2023-03-03 11:59:50',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(711,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,7920.00,'03031202','2023-03-03 12:03:22',5,'cash','','',7920.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(712,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,5040.00,'03031221','2023-03-03 12:21:47',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(713,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,2160.00,'03031241','2023-03-03 12:41:22',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(714,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,4320.00,'03031332','2023-03-03 13:33:23',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(715,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,2160.00,'03031343','2023-03-03 13:44:09',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(716,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,9000.00,'03031355','2023-03-03 13:55:55',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(717,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,2160.00,'03031408','2023-03-03 14:08:53',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(718,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,2880.00,'03031421','2023-03-03 14:21:50',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(719,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,2880.00,'03031447','2023-03-03 14:49:37',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(720,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,1440.00,'03031513','2023-03-03 15:14:09',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(721,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,1500.00,'03031539','2023-03-03 15:39:56',5,'cash','','',1500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(722,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,5040.00,'03031547','2023-03-03 15:47:44',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(723,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,5040.00,'03031549','2023-03-03 15:50:22',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(724,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,9000.00,'03031602','2023-03-03 16:02:53',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(725,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,4320.00,'03031604','2023-03-03 16:05:35',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(726,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,7200.00,'03031632','2023-03-03 16:34:20',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(727,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,2500.00,'03031635','2023-03-03 16:36:25',5,'cash','','',2500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(728,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,7200.00,'03031638','2023-03-03 16:38:29',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(729,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,3600.00,'03031639','2023-03-03 16:42:28',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(730,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,5040.00,'03031651','2023-03-03 16:52:05',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(731,'1','312','26','2023-03-03','3','JOSIAH GAS','07033059724',0.00,40800.00,'03031918','2023-03-03 19:19:06',5,'cash','','',40800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(732,'1','312','26','2023-03-03','4','PZ GAS','08063508191',0.00,40800.00,'03031919','2023-03-03 19:19:52',5,'cash','','',40800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(733,'1','312','26','2023-03-03','','END USER','2348134818197',0.00,16200.00,'03031921','2023-03-03 19:21:58',5,'cash','','',16200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(734,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,4320.00,'03040742','2023-03-04 07:59:57',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(736,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,2880.00,'03040803','2023-03-04 08:08:54',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(737,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,7000.00,'03040813','2023-03-04 08:19:01',5,'cash','','',7000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(738,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,1440.00,'03040820','2023-03-04 08:23:15',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(739,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,1440.00,'03040825','2023-03-04 08:25:44',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(740,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,4320.00,'03040840','2023-03-04 08:41:21',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(741,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,4320.00,'03040844','2023-03-04 08:49:44',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(742,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,3600.00,'03040902','2023-03-04 09:03:14',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(743,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,9000.00,'03040927','2023-03-04 09:28:30',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(744,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,4000.00,'03040932','2023-03-04 09:33:12',5,'cash','','',4000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(745,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,4350.00,'03040935','2023-03-04 09:35:48',5,'cash','','',4350.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(746,'1','312','27','2023-03-04','','ENUSER','2348131593035',0.00,7920.00,'03040943','2023-03-04 09:43:25',5,'cash','','',7920.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(747,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,9000.00,'03040947','2023-03-04 09:47:43',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(748,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,9000.00,'03040958','2023-03-04 09:59:25',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(749,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,9000.00,'03041015','2023-03-04 10:15:37',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(750,'1','312','27','2023-03-04','7','COOK AND   SMILE GAS','07030132192',0.00,129200.00,'03041016','2023-03-04 10:16:33',5,'cash','','',129200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(751,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,5040.00,'03041025','2023-03-04 10:25:36',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(752,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,7200.00,'03041035','2023-03-04 10:38:25',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(753,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,2160.00,'03041050','2023-03-04 10:51:40',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(754,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,3000.00,'03041056','2023-03-04 10:56:57',5,'cash','','',3000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(755,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,5100.00,'03041100','2023-03-04 11:01:38',5,'cash','','',5100.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(756,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,3600.00,'03041126','2023-03-04 11:27:11',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(757,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,2200.00,'03041149','2023-03-04 11:50:21',5,'cash','','',2200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(758,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,2880.00,'03041201','2023-03-04 12:02:07',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(759,'1','312','27','2023-03-04','','ENUSER','2348131593035',0.00,11520.00,'03041218','2023-03-04 12:19:05',5,'cash','','',11520.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(760,'1','312','27','2023-03-04','','END USER','2348134818197',0.00,1591.20,'03041228','2023-03-04 12:29:18',5,'cash','','',1591.20,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(761,'1','312','27','2023-03-04','','ENUSER','2348131593035',0.00,12002.40,'03041234','2023-03-04 12:34:39',5,'cash','','',12002.40,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(762,'1','312','28','2023-03-08','','ENUSER','2348131593035',0.00,7920.00,'03080904','2023-03-08 09:05:35',5,'cash','','',7920.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(763,'1','312','28','2023-03-08','','END USER','2348131593035',0.00,2160.00,'03080911','2023-03-08 09:12:29',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(764,'1','312','28','2023-03-08','','END USER','2348131593035',0.00,9000.00,'03080913','2023-03-08 09:14:23',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(765,'1','312','28','2023-03-08','','END USER','2348131593035',0.00,7200.00,'03081247','2023-03-08 12:47:51',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(766,'1','312','28','2023-03-08','','END USER','2348134818197',0.00,9000.00,'03081251','2023-03-08 12:52:32',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(767,'1','312','28','2023-03-08','','END USER','2348134818197',0.00,4320.00,'03081257','2023-03-08 12:58:03',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(768,'1','312','28','2023-03-08','','END USER','2348134818197',0.00,9000.00,'03081300','2023-03-08 13:00:41',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(769,'1','312','28','2023-03-08','1','VICTOR GAS','08034183596',0.00,172462.50,'03081311','2023-03-08 13:13:17',5,'cash','','',172462.50,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(770,'1','312','28','2023-03-08','','END USER','2348131593035',0.00,2160.00,'03081314','2023-03-08 13:14:43',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(771,'1','312','28','2023-03-08','','END USER','2348131593035',0.00,2880.00,'03081315','2023-03-08 13:15:32',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(772,'1','312','28','2023-03-08','','END USER','2348131593035',0.00,1440.00,'03081316','2023-03-08 13:16:33',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(773,'1','312','28','2023-03-08','','END USER','2348131593035',0.00,4320.00,'03081317','2023-03-08 13:17:29',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(774,'1','312','28','2023-03-08','1','VICTOR GAS','08034183596',0.00,20400.00,'03081334','2023-03-08 13:35:40',2,'cash','','',20400.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(775,'1','312','28','2023-03-08','','END USER','2348134818197',0.00,4320.00,'03081417','2023-03-08 14:18:39',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(776,'1','312','28','2023-03-08','','END USER','2348131593035',0.00,9000.00,'03081456','2023-03-08 14:58:46',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(777,'1','312','28','2023-03-08','','END USER','2348134818197',0.00,4320.00,'03081501','2023-03-08 15:02:27',5,'cash','','',8640.00,4320.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(779,'1','312','28','2023-03-08','','END USER','2348134818197',0.00,2160.00,'03081504','2023-03-08 15:05:33',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(780,'1','312','28','2023-03-08','','END USER','2348134818197',0.00,7200.00,'03081522','2023-03-08 15:23:06',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(781,'1','312','28','2023-03-08','','END USER','2348134818197',0.00,5040.00,'03081537','2023-03-08 15:49:52',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(786,'1','312','28','2023-03-08','','END USER','2348131593035',0.00,2400.00,'03081625','2023-03-08 16:25:40',5,'cash','','',2400.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(787,'1','312','28','2023-03-08','','END USER','2348131593035',0.00,4000.00,'03081630','2023-03-08 16:31:32',5,'cash','','',4000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(788,'1','312','28','2023-03-08','','END USER','2348131593035',0.00,2160.00,'03081645','2023-03-08 16:46:33',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(789,'1','312','28','2023-03-08','','END USER','2348131593035',0.00,2880.00,'03081649','2023-03-08 16:50:00',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(790,'1','312','28','2023-03-08','','END USER','2348134818197',0.00,9000.00,'03081721','2023-03-08 17:21:53',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(791,'1','312','28','2023-03-08','','END USER','2348131593035',0.00,2160.00,'03081733','2023-03-08 17:47:13',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(792,'1','312','28','2023-03-08','','END USER','2348131593035',0.00,2160.00,'03081756','2023-03-08 17:57:02',2,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(793,'1','312','28','2023-03-08','','END USER','2348131593035',0.00,11520.00,'03081804','2023-03-08 18:05:25',5,'cash','','',11520.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(794,'1','312','28','2023-03-08','1','VICTOR GAS','08034183596',0.00,205875.00,'03081819','2023-03-08 18:20:21',5,'cash','','',205875.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(795,'1','312','28','2023-03-08','','END USER','2348131593035',0.00,5313.60,'03081833','2023-03-08 18:34:18',5,'cash','','',5313.60,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(796,'1','312','29','2023-03-09','','END USER','2348131593035',0.00,2900.00,'03090729','2023-03-09 07:55:16',5,'cash','','',2900.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(797,'1','312','29','2023-03-09','','END USER','2348131593035',0.00,5040.00,'03090800','2023-03-09 08:22:32',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(798,'1','312','29','2023-03-09','','END USER','2348131593035',0.00,720.00,'03090824','2023-03-09 08:29:22',2,'cash','','',720.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(799,'1','312','29','2023-03-09','','ENUSER','2348131593035',0.00,1000.00,'03090833','2023-03-09 08:33:53',5,'cash','','',1000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(800,'1','312','29','2023-03-09','','END USER','2348134818197',0.00,4350.00,'03090929','2023-03-09 09:30:55',5,'cash','','',4350.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(801,'1','312','29','2023-03-09','','END USER','2348131593035',0.00,2160.00,'03090943','2023-03-09 10:07:00',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(802,'1','312','29','2023-03-09','3','JOSIAH GAS','07033059724',0.00,40800.00,'03091015','2023-03-09 10:16:46',5,'cash','','',40800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(803,'1','312','29','2023-03-09','','END USER','2348134818197',0.00,9000.00,'03091205','2023-03-09 12:42:48',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(804,'1','312','29','2023-03-09','','END USER','2348131593035',0.00,5040.00,'03091243','2023-03-09 12:44:05',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(805,'1','312','29','2023-03-09','','END USER','2348131593035',0.00,2160.00,'03091246','2023-03-09 13:07:03',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(807,'1','312','29','2023-03-09','','END USER','2348131593035',0.00,9000.00,'03091320','2023-03-09 13:58:21',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(808,'1','312','29','2023-03-09','','END USER','2348131593035',0.00,3600.00,'03091413','2023-03-09 15:01:33',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(809,'1','312','29','2023-03-09','','END USER','2348131593035',0.00,3600.00,'03091502','2023-03-09 15:02:28',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(810,'1','312','29','2023-03-09','','END USER','2348131593035',0.00,4003.20,'03091535','2023-03-09 15:36:04',5,'cash','','',4003.20,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(811,'1','312','29','2023-03-09','','END USER','2348131593035',0.00,9000.00,'03091536','2023-03-09 15:37:11',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(812,'1','312','29','2023-03-09','','END USER','2348131593035',0.00,4320.00,'03091613','2023-03-09 16:13:35',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(813,'1','312','29','2023-03-09','','END USER','2348131593035',0.00,3600.00,'03091615','2023-03-09 16:28:47',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(814,'1','312','29','2023-03-09','','END USER','2348134818197',0.00,9000.00,'03091631','2023-03-09 17:11:57',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(815,'1','312','29','2023-03-09','','END USER','2348131593035',0.00,5040.00,'03091715','2023-03-09 17:44:44',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(816,'1','312','29','2023-03-09','','END USER','2348131593035',0.00,3600.00,'03091748','2023-03-09 17:48:45',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(817,'1','312','29','2023-03-09','','END USER','2348131593035',0.00,14400.00,'03091751','2023-03-09 17:52:07',5,'cash','','',14400.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(818,'1','312','29','2023-03-09','','END USER','2348134818197',0.00,4320.00,'03091806','2023-03-09 18:06:48',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(819,'1','312','29','2023-03-09','','END USER','2348131593035',0.00,1440.00,'03091817','2023-03-09 18:22:54',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(820,'1','312','29','2023-03-09','','END USER','2348134818197',0.00,4320.00,'03091827','2023-03-09 18:28:14',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(821,'1','312','30','2023-03-10','','END USER','2348131593035',0.00,2880.00,'03100727','2023-03-10 07:39:12',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(822,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,1440.00,'03100740','2023-03-10 07:40:40',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(823,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,2160.00,'03100757','2023-03-10 07:57:42',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(824,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,2160.00,'03100759','2023-03-10 08:00:09',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(825,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,9000.00,'03100804','2023-03-10 08:05:47',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(826,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,6080.00,'03100807','2023-03-10 08:08:04',5,'cash','','',6080.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(827,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,9000.00,'03100827','2023-03-10 08:27:44',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(828,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,2880.00,'03100845','2023-03-10 08:45:33',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(829,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,3600.00,'03100847','2023-03-10 08:48:06',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(830,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,4320.00,'03100851','2023-03-10 08:51:57',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(831,'1','312','30','2023-03-10','3','JOSIAH GAS','07033059724',0.00,81600.00,'03100909','2023-03-10 09:10:23',2,'cash','','',81600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(832,'1','312','30','2023-03-10','','END USER','2348131593035',0.00,9000.00,'03100911','2023-03-10 09:39:00',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(833,'1','312','30','2023-03-10','','END USER','2348131593035',0.00,9000.00,'03101015','2023-03-10 10:17:05',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(835,'1','312','30','2023-03-10','','END USER','2348131593035',0.00,2880.00,'03101030','2023-03-10 10:30:23',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(836,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,9360.00,'03101042','2023-03-10 10:43:14',5,'cash','','',9360.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(837,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,5040.00,'03101159','2023-03-10 12:00:46',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(838,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,9000.00,'03101202','2023-03-10 12:03:00',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(839,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,3600.00,'03101221','2023-03-10 12:21:46',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(840,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,2880.00,'03101302','2023-03-10 13:03:04',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(841,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,5040.00,'03101318','2023-03-10 13:18:43',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(842,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,25200.00,'03101333','2023-03-10 13:34:35',5,'cash','','',25200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(843,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,5040.00,'03101352','2023-03-10 13:53:12',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(844,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,5040.00,'03101413','2023-03-10 14:14:24',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(845,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,2880.00,'03101416','2023-03-10 14:17:00',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(846,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,3000.00,'03101419','2023-03-10 14:43:35',5,'cash','','',3000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(847,'1','312','30','2023-03-10','','END USER','2348131593035',0.00,9000.00,'03101459','2023-03-10 15:15:12',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(848,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,9000.00,'03101540','2023-03-10 15:40:54',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(849,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,2160.00,'03101542','2023-03-10 15:44:55',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(850,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,3000.00,'03101553','2023-03-10 15:53:38',5,'cash','','',3000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(851,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,4320.00,'03101556','2023-03-10 15:56:37',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(852,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,2160.00,'03101608','2023-03-10 16:09:18',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(853,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,2160.00,'03101625','2023-03-10 16:34:04',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(854,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,5040.00,'03101639','2023-03-10 16:44:34',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(855,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,4320.00,'03101646','2023-03-10 17:21:34',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(856,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,4350.00,'03101728','2023-03-10 17:29:02',5,'cash','','',4350.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(857,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,2160.00,'03101729','2023-03-10 17:30:19',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(858,'1','312','30','2023-03-10','','END USER','2348131593035',0.00,3600.00,'03101744','2023-03-10 17:53:31',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(859,'1','312','30','2023-03-10','','END USER','2348131593035',0.00,2000.00,'03101814','2023-03-10 18:14:56',5,'cash','','',2000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(860,'1','312','30','2023-03-10','','END USER','2348131593035',0.00,3600.00,'03101827','2023-03-10 18:28:03',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(861,'1','312','30','2023-03-10','','END USER','2348134818197',0.00,4000.00,'03101844','2023-03-10 18:45:27',5,'cash','','',4000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(862,'1','312','30','2023-03-10','3','JOSIAH GAS','07033059724',0.00,81022.00,'03101904','2023-03-10 19:04:33',5,'cash','','',81022.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(863,'1','312','31','2023-03-11','','END USER','2348131593035',0.00,4320.00,'03110723','2023-03-11 07:56:47',5,'cash','','',8640.00,4320.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(864,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,5040.00,'03110759','2023-03-11 08:07:03',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(865,'1','312','31','2023-03-11','','END USER','2348131593035',0.00,9000.00,'03110824','2023-03-11 08:24:58',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(866,'1','312','31','2023-03-11','','END USER','2348131593035',0.00,4320.00,'03110845','2023-03-11 08:45:44',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(867,'1','312','31','2023-03-11','','END USER','2348131593035',0.00,14040.00,'03110906','2023-03-11 09:15:43',5,'cash','','',14040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(868,'1','312','31','2023-03-11','','END USER','2348131593035',0.00,10800.00,'03110917','2023-03-11 09:19:52',5,'cash','','',10800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(869,'1','312','31','2023-03-11','','END USER','2348131593035',0.00,2880.00,'03110921','2023-03-11 09:22:25',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(870,'1','312','31','2023-03-11','','END USER','2348131593035',0.00,2160.00,'03110925','2023-03-11 09:45:26',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(871,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,1440.00,'03110946','2023-03-11 09:47:17',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(872,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,720.00,'03110951','2023-03-11 09:52:08',5,'cash','','',720.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(873,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,9000.00,'03111004','2023-03-11 10:04:57',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(874,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,2000.00,'03111006','2023-03-11 10:07:01',5,'cash','','',2000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(875,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,1440.00,'03111018','2023-03-11 10:19:20',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(876,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,10800.00,'03111021','2023-03-11 10:22:17',5,'cash','','',10800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(877,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,2900.00,'03111035','2023-03-11 10:36:23',5,'cash','','',2900.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(878,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,5040.00,'03111104','2023-03-11 11:04:58',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(879,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,3600.00,'03111106','2023-03-11 11:07:23',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(880,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,3600.00,'03111113','2023-03-11 11:14:05',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(881,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,3600.00,'03111222','2023-03-11 12:22:59',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(882,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,5040.00,'03111223','2023-03-11 12:24:11',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(883,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,3000.00,'03111224','2023-03-11 12:55:28',5,'cash','','',3000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(884,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,6480.00,'03111320','2023-03-11 13:20:55',5,'cash','','',6480.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(885,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,9000.00,'03111327','2023-03-11 13:27:46',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(886,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,3600.00,'03111328','2023-03-11 13:29:27',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(887,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,7200.00,'03111356','2023-03-11 13:56:42',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(888,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,1000.00,'03111400','2023-03-11 14:00:49',5,'cash','','',1000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(889,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,5040.00,'03111406','2023-03-11 14:07:09',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(891,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,12110.40,'03111437','2023-03-11 14:38:15',5,'cash','','',12110.40,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(893,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,1440.00,'03111445','2023-03-11 14:45:58',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(894,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,5000.00,'03111506','2023-03-11 15:07:02',5,'cash','','',5000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(895,'1','312','31','2023-03-11','','END USER','2348131593035',0.00,38880.00,'03111515','2023-03-11 15:19:49',5,'cash','','',38880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(896,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,18000.00,'03111527','2023-03-11 15:28:02',5,'cash','','',18000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(897,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,5040.00,'03111538','2023-03-11 15:39:01',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(898,'1','312','31','2023-03-11','3','JOSIAH GAS','07033059724',0.00,40800.00,'03111543','2023-03-11 15:44:27',2,'cash','','',40800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(899,'1','312','31','2023-03-11','','END USER','2348131593035',0.00,2520.00,'03111548','2023-03-11 15:48:28',5,'cash','','',2520.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(900,'1','312','31','2023-03-11','','END USER','2348131593035',0.00,9000.00,'03111554','2023-03-11 15:55:02',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(901,'1','312','31','2023-03-11','','END USER','2348131593035',0.00,1000.00,'03111555','2023-03-11 15:56:17',5,'cash','','',1000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(902,'1','312','31','2023-03-11','','END USER','2348131593035',0.00,2880.00,'03111606','2023-03-11 16:12:44',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(903,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,4320.00,'03111624','2023-03-11 16:25:02',2,'cash','','',8640.00,4320.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(904,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,3600.00,'03111647','2023-03-11 16:48:46',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(905,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,2000.00,'03111653','2023-03-11 16:54:55',5,'cash','','',2000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(906,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,3600.00,'03111656','2023-03-11 16:57:27',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(908,'1','312','31','2023-03-11','','END USER','2348131593035',0.00,7200.00,'03111659','2023-03-11 17:00:15',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(909,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,2160.00,'03111714','2023-03-11 17:15:15',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(910,'1','312','31','2023-03-11','','END USER','2348131593035',0.00,5040.00,'03111719','2023-03-11 17:20:09',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(911,'1','312','31','2023-03-11','','END USER','2348131593035',0.00,5040.00,'03111723','2023-03-11 17:23:34',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(912,'1','312','31','2023-03-11','','END USER','2348131593035',0.00,2880.00,'03111724','2023-03-11 17:25:54',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(913,'1','312','31','2023-03-11','','END USER','2348131593035',0.00,2160.00,'03111727','2023-03-11 17:42:33',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(914,'1','312','31','2023-03-11','','END USER','2348134818197',0.00,1440.00,'03111806','2023-03-11 18:06:56',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(915,'1','312','31','2023-03-11','3','JOSIAH GAS','07033059724',0.00,40657.20,'03111840','2023-03-11 18:41:02',5,'cash','','',40657.20,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(916,'1','312','31','2023-03-11','','END USER','2348131593035',0.00,3945.60,'03111858','2023-03-11 18:59:17',5,'cash','','',3945.60,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(917,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,1440.00,'03120739','2023-03-12 07:39:48',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(918,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,4320.00,'03120741','2023-03-12 07:41:29',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(919,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,5040.00,'03120752','2023-03-12 07:53:41',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(920,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,2300.00,'03120812','2023-03-12 08:13:02',5,'cash','','',2300.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(921,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,3960.00,'03120815','2023-03-12 08:18:10',5,'cash','','',3960.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(922,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,5040.00,'03120819','2023-03-12 08:20:12',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(923,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,4320.00,'03120851','2023-03-12 08:52:40',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(926,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,2160.00,'03120945','2023-03-12 09:46:15',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(927,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,3600.00,'03120946','2023-03-12 09:47:20',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(928,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,9000.00,'03120948','2023-03-12 09:48:30',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(929,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,1440.00,'03120950','2023-03-12 09:51:06',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(930,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,2160.00,'03120955','2023-03-12 09:55:39',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(931,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,800.00,'03121019','2023-03-12 10:19:52',5,'cash','','',800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(932,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,2160.00,'03121026','2023-03-12 10:43:11',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(933,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,2880.00,'03121052','2023-03-12 10:52:57',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(934,'1','312','32','2023-03-12','8','uche gas','09150527512',0.00,39440.00,'03121114','2023-03-12 11:15:26',5,'cash','','',39440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(936,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,10800.00,'03121143','2023-03-12 11:44:11',5,'cash','','',10800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(937,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,4000.00,'03121149','2023-03-12 12:37:31',5,'cash','','',4000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(938,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,1440.00,'03121243','2023-03-12 12:44:05',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(939,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,9000.00,'03121251','2023-03-12 12:52:14',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(940,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,9000.00,'03121309','2023-03-12 13:09:49',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(941,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,7200.00,'03121313','2023-03-12 13:14:31',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(942,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,9000.00,'03121401','2023-03-12 14:03:17',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(943,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,36000.00,'03121423','2023-03-12 14:24:21',5,'cash','','',36000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(944,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,5000.00,'03121433','2023-03-12 14:43:41',5,'cash','','',5000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(945,'1','312','32','2023-03-12','','END USER','2348134818197',0.00,2500.00,'03121445','2023-03-12 14:46:17',5,'cash','','',2500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(946,'1','312','32','2023-03-12','','END USER','2348134818197',0.00,4320.00,'03121449','2023-03-12 14:49:41',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(947,'1','312','32','2023-03-12','','END USER','2348134818197',0.00,2160.00,'03121502','2023-03-12 15:02:33',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(948,'1','312','32','2023-03-12','','END USER','2348134818197',0.00,5040.00,'03121514','2023-03-12 15:15:05',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(949,'1','312','32','2023-03-12','','END USER','2348134818197',0.00,4000.00,'03121553','2023-03-12 15:53:44',5,'cash','','',4000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(950,'1','312','32','2023-03-12','','END USER','2348134818197',0.00,9000.00,'03121601','2023-03-12 16:02:28',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(951,'1','312','32','2023-03-12','','END USER','2348134818197',0.00,9000.00,'03121614','2023-03-12 16:15:33',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(952,'1','312','32','2023-03-12','','END USER','2348134818197',0.00,3600.00,'03121618','2023-03-12 16:19:09',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(953,'1','312','32','2023-03-12','','END USER','2348134818197',0.00,2160.00,'03121621','2023-03-12 16:21:41',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(954,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,2160.00,'03121631','2023-03-12 16:38:11',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(955,'1','312','32','2023-03-12','3','JOSIAH GAS','07033059724',0.00,37400.00,'03121649','2023-03-12 16:50:43',5,'cash','','',37400.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(956,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,2160.00,'03121653','2023-03-12 16:54:59',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(957,'1','312','32','2023-03-12','','END USER','2348134818197',0.00,2000.00,'03121658','2023-03-12 16:59:17',5,'cash','','',2000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(958,'1','312','32','2023-03-12','','END USER','2348134818197',0.00,5040.00,'03121717','2023-03-12 17:18:07',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(959,'1','312','32','2023-03-12','','END USER','2348134818197',0.00,4000.00,'03121721','2023-03-12 17:22:30',5,'cash','','',4000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(960,'1','312','32','2023-03-12','','END USER','2348134818197',0.00,3600.00,'03121728','2023-03-12 17:28:48',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(961,'1','312','32','2023-03-12','','END USER','2348134818197',0.00,9000.00,'03121732','2023-03-12 17:32:56',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(962,'1','312','32','2023-03-12','','END USER','2348134818197',0.00,9000.00,'03121734','2023-03-12 17:34:59',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(963,'1','312','32','2023-03-12','','END USER','2348134818197',0.00,3600.00,'03121738','2023-03-12 17:39:20',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(964,'1','312','32','2023-03-12','','END USER','2348134818197',0.00,5040.00,'03121746','2023-03-12 18:03:03',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(965,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,4320.00,'03121815','2023-03-12 18:15:44',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(966,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,4320.00,'03121825','2023-03-12 18:25:54',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(967,'1','312','32','2023-03-12','3','JOSIAH GAS','07033059724',0.00,67211.20,'03121833','2023-03-12 18:34:17',5,'cash','','',67211.20,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(968,'1','312','32','2023-03-12','','END USER','2348131593035',0.00,720.00,'03121835','2023-03-12 18:36:10',5,'cash','','',720.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(969,'1','312','33','2023-03-14','','END USER','2348131593035',0.00,4320.00,'03140735','2023-03-14 07:37:55',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(970,'1','312','33','2023-03-14','','ENUSER','2348131593035',0.00,9000.00,'03140738','2023-03-14 07:39:07',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(971,'1','312','33','2023-03-14','','END USER','2348131593035',0.00,12240.00,'03140740','2023-03-14 07:43:53',5,'cash','','',12240.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(972,'1','312','33','2023-03-14','','END USER','2348134818197',0.00,4320.00,'03140746','2023-03-14 07:46:57',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(973,'1','312','33','2023-03-14','','END USER','2348134818197',0.00,9000.00,'03140752','2023-03-14 07:52:42',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(974,'1','312','33','2023-03-14','','END USER','2348134818197',0.00,7200.00,'03140811','2023-03-14 08:12:17',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(975,'1','312','33','2023-03-14','','END USER','2348131593035',0.00,4320.00,'03140828','2023-03-14 08:28:58',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(976,'1','312','33','2023-03-14','','END USER','2348131593035',0.00,13320.00,'03140831','2023-03-14 08:40:01',5,'cash','','',13320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(978,'1','312','33','2023-03-14','','END USER','2348134818197',0.00,23760.00,'03140852','2023-03-14 08:52:37',5,'cash','','',23760.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(979,'1','312','33','2023-03-14','','END USER','2348134818197',0.00,3600.00,'03140854','2023-03-14 08:55:05',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(980,'1','312','33','2023-03-14','','END USER','2348131593035',0.00,9000.00,'03140855','2023-03-14 08:56:27',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(981,'1','312','33','2023-03-14','','END USER','2348134818197',0.00,9000.00,'03140931','2023-03-14 09:38:11',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(982,'1','312','33','2023-03-14','','END USER','2348131593035',0.00,9000.00,'03140953','2023-03-14 09:54:32',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(983,'1','312','33','2023-03-14','','END USER','2348134818197',0.00,3000.00,'03141024','2023-03-14 10:24:53',5,'cash','','',3000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(984,'1','312','33','2023-03-14','','END USER','2348134818197',0.00,2200.00,'03141115','2023-03-14 11:16:43',5,'cash','','',2200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(985,'1','312','33','2023-03-14','','END USER','2348134818197',0.00,2160.00,'03141118','2023-03-14 11:18:32',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(986,'1','312','33','2023-03-14','','END USER','2348131593035',0.00,12240.00,'03141126','2023-03-14 11:38:33',5,'cash','','',12240.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(987,'1','312','33','2023-03-14','','END USER','2348134818197',0.00,8640.00,'03141202','2023-03-14 12:02:56',5,'cash','','',8640.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(988,'1','312','33','2023-03-14','','END USER','2348131593035',0.00,720.00,'03141251','2023-03-14 13:16:53',5,'cash','','',720.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(989,'1','312','33','2023-03-14','','END USER','2348131593035',0.00,1440.00,'03141330','2023-03-14 13:37:58',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(990,'1','312','33','2023-03-14','','END USER','2348131593035',0.00,5040.00,'03141359','2023-03-14 15:22:16',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(991,'1','312','33','2023-03-14','','END USER','2348131593035',0.00,4500.00,'03141523','2023-03-14 15:35:14',5,'cash','','',4500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(992,'1','312','33','2023-03-14','','END USER','2348134818197',0.00,9000.00,'03141536','2023-03-14 15:36:56',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(993,'1','312','33','2023-03-14','','END USER','2348134818197',0.00,3600.00,'03141546','2023-03-14 15:48:27',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(994,'1','312','33','2023-03-14','','END USER','2348131593035',0.00,2880.00,'03141650','2023-03-14 16:50:51',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(995,'1','312','33','2023-03-14','','END USER','2348134818197',0.00,2160.00,'03141702','2023-03-14 17:02:35',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(996,'1','312','33','2023-03-14','','END USER','2348134818197',0.00,5760.00,'03141711','2023-03-14 17:13:33',5,'cash','','',5760.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(998,'1','312','33','2023-03-14','','END USER','2348134818197',0.00,3600.00,'03141717','2023-03-14 17:18:15',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(999,'1','312','33','2023-03-14','1','VICTOR GAS','08034183596',0.00,98600.00,'03141722','2023-03-14 17:23:02',5,'cash','','',98600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1001,'1','312','33','2023-03-14','','END USER','2348131593035',0.00,2160.00,'03141735','2023-03-14 17:38:18',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1002,'1','312','33','2023-03-14','','END USER','2348131593035',0.00,5040.00,'03141743','2023-03-14 17:45:17',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1003,'1','312','33','2023-03-14','','END USER','2348134818197',0.00,9000.00,'03141814','2023-03-14 18:15:09',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1004,'1','312','33','2023-03-14','','END USER','2348131593035',0.00,3600.00,'03141840','2023-03-14 18:45:17',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1005,'1','312','33','2023-03-14','','END USER','2348131593035',0.00,1440.00,'03141909','2023-03-14 19:10:18',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1006,'1','312','34','2023-03-15','','END USER','2348131593035',0.00,4320.00,'03150659','2023-03-15 08:04:42',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1008,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,4320.00,'03150808','2023-03-15 08:22:07',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1009,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,7200.00,'03150823','2023-03-15 08:24:30',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1010,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,9000.00,'03150841','2023-03-15 08:52:09',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1011,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,2880.00,'03150854','2023-03-15 08:55:19',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1012,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,2160.00,'03150857','2023-03-15 08:58:17',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1013,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,2200.00,'03150906','2023-03-15 09:07:20',5,'cash','','',2200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1014,'1','312','34','2023-03-15','','END USER','2348131593035',0.00,2880.00,'03150915','2023-03-15 09:27:41',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1015,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,4320.00,'03150936','2023-03-15 09:38:41',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1016,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,3240.00,'03151008','2023-03-15 10:09:32',5,'cash','','',3240.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1017,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,4320.00,'03151010','2023-03-15 10:11:14',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1018,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,2160.00,'03151037','2023-03-15 10:38:36',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1019,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,10800.00,'03151040','2023-03-15 10:40:43',5,'cash','','',10800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1020,'1','312','34','2023-03-15','','END USER','2348131593035',0.00,2880.00,'03151129','2023-03-15 11:45:42',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1021,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,9000.00,'03151222','2023-03-15 12:23:12',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1022,'1','312','34','2023-03-15','','END USER','2348131593035',0.00,10440.00,'03151243','2023-03-15 12:57:26',5,'cash','','',10440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1023,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,1440.00,'03151306','2023-03-15 13:07:17',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1024,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,9000.00,'03151422','2023-03-15 14:31:43',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1025,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,1500.00,'03151453','2023-03-15 14:53:35',5,'cash','','',1500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1026,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,3600.00,'03151533','2023-03-15 15:35:31',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1027,'1','312','34','2023-03-15','','END USER','2348131593035',0.00,7200.00,'03151536','2023-03-15 15:38:13',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1028,'1','312','34','2023-03-15','','END USER','2348131593035',0.00,10080.00,'03151539','2023-03-15 15:40:04',5,'cash','','',10080.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1029,'1','312','34','2023-03-15','','END USER','2348131593035',0.00,2160.00,'03151540','2023-03-15 15:42:33',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1030,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,2880.00,'03151549','2023-03-15 15:49:36',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1031,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,5040.00,'03151602','2023-03-15 16:03:22',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1032,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,3600.00,'03151607','2023-03-15 16:09:31',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1033,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,4320.00,'03151619','2023-03-15 16:20:06',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1034,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,1440.00,'03151621','2023-03-15 16:22:27',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1035,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,2160.00,'03151647','2023-03-15 16:47:38',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1036,'1','312','34','2023-03-15','','END USER','2348134818197',0.00,1450.00,'03151707','2023-03-15 17:17:58',5,'cash','','',1450.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1037,'1','312','35','2023-03-16','','END USER','2348131593035',0.00,4320.00,'03160710','2023-03-16 08:00:57',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1038,'1','312','35','2023-03-16','','END USER','2348131593035',0.00,7200.00,'03160802','2023-03-16 08:03:13',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1039,'1','312','35','2023-03-16','','END USER','2348131593035',0.00,9000.00,'03160806','2023-03-16 08:29:25',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1040,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,1440.00,'03160847','2023-03-16 08:48:18',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1041,'1','312','35','2023-03-16','','END USER','2348131593035',0.00,2160.00,'03160855','2023-03-16 08:57:37',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1042,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,7200.00,'03160859','2023-03-16 09:00:29',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1043,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,4000.00,'03160902','2023-03-16 09:03:34',5,'cash','','',4000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1044,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,4320.00,'03160913','2023-03-16 09:14:32',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1045,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,4320.00,'03160926','2023-03-16 09:27:17',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1046,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,3600.00,'03161021','2023-03-16 10:21:33',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1047,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,7200.00,'03161044','2023-03-16 10:44:52',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1048,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,21600.00,'03161054','2023-03-16 10:55:22',5,'cash','','',21600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1049,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,2160.00,'03161126','2023-03-16 11:27:22',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1050,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,3600.00,'03161137','2023-03-16 11:37:57',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1051,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,6480.00,'03161150','2023-03-16 11:51:23',5,'cash','','',6480.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1052,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,3600.00,'03161159','2023-03-16 12:00:14',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1053,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,1440.00,'03161202','2023-03-16 12:03:11',2,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1054,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,3600.00,'03161204','2023-03-16 12:05:29',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1055,'1','312','35','2023-03-16','','END USER','2348131593035',0.00,9000.00,'03161314','2023-03-16 13:14:36',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1056,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,1440.00,'03161315','2023-03-16 13:16:01',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1057,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,9000.00,'03161317','2023-03-16 13:33:49',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1058,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,7920.00,'03161415','2023-03-16 14:16:30',5,'cash','','',7920.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1059,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,4320.00,'03161417','2023-03-16 14:18:02',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1060,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,2880.00,'03161552','2023-03-16 15:52:41',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1061,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,9000.00,'03161553','2023-03-16 15:53:50',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1062,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,8640.00,'03161555','2023-03-16 15:55:40',5,'cash','','',8640.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1063,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,10800.00,'03161556','2023-03-16 15:56:51',5,'cash','','',10800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1064,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,9000.00,'03161557','2023-03-16 15:58:10',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1065,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,2296.80,'03161600','2023-03-16 16:01:26',5,'cash','','',2296.80,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1066,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,5760.00,'03161637','2023-03-16 16:38:12',5,'cash','','',5760.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1067,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,1440.00,'03161639','2023-03-16 16:39:41',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1068,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,6480.00,'03161654','2023-03-16 16:55:20',5,'cash','','',6480.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1069,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,2160.00,'03161657','2023-03-16 16:58:15',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1070,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,7200.00,'03161709','2023-03-16 17:10:20',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1071,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,3600.00,'03161722','2023-03-16 17:23:00',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1072,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,2880.00,'03161724','2023-03-16 17:56:20',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1074,'1','312','35','2023-03-16','','END USER','2348131593035',0.00,1440.00,'03161803','2023-03-16 18:03:46',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1075,'1','312','35','2023-03-16','','END USER','2348131593035',0.00,2000.00,'03161816','2023-03-16 18:45:06',5,'cash','','',2000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1076,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,1440.00,'03161846','2023-03-16 18:47:06',2,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1077,'1','312','35','2023-03-16','','END USER','2348134818197',0.00,2160.00,'03161847','2023-03-16 18:48:08',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1078,'1','312','35','2023-03-16','','END USER','2348131593035',0.00,1944.00,'03161907','2023-03-16 19:08:03',5,'cash','','',1944.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1079,'1','312','36','2023-03-17','','END USER','2348131593035',0.00,2880.00,'03170713','2023-03-17 07:27:36',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1080,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,2160.00,'03170729','2023-03-17 07:30:31',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1081,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,4320.00,'03170802','2023-03-17 08:02:34',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1082,'1','312','36','2023-03-17','','END USER','2348131593035',0.00,2160.00,'03170827','2023-03-17 08:28:14',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1083,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,6000.00,'03170834','2023-03-17 08:36:22',5,'cash','','',6000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1084,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,7200.00,'03170839','2023-03-17 08:39:38',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1086,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,1500.00,'03170901','2023-03-17 09:02:28',5,'cash','','',1500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1087,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,4350.00,'03170903','2023-03-17 09:04:14',5,'cash','','',4350.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1088,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,4320.00,'03170916','2023-03-17 09:16:41',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1089,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,7200.00,'03170917','2023-03-17 09:19:08',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1090,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,4320.00,'03170932','2023-03-17 09:32:26',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1091,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,2160.00,'03170937','2023-03-17 09:38:04',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1092,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,4320.00,'03170940','2023-03-17 09:41:58',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1093,'1','312','36','2023-03-17','','END USER','2348131593035',0.00,5040.00,'03170955','2023-03-17 09:56:00',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1094,'1','312','36','2023-03-17','','END USER','2348131593035',0.00,3600.00,'03170957','2023-03-17 10:07:16',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1095,'1','312','36','2023-03-17','','END USER','2348131593035',0.00,7920.00,'03171009','2023-03-17 10:21:59',5,'cash','','',7920.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1096,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,2160.00,'03171030','2023-03-17 10:33:00',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1097,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,1000.00,'03171042','2023-03-17 10:43:22',5,'cash','','',1000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1098,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,3600.00,'03171045','2023-03-17 10:58:49',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1099,'1','312','36','2023-03-17','','END USER','2348131593035',0.00,8640.00,'03171101','2023-03-17 11:01:55',5,'cash','','',8640.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1100,'1','312','36','2023-03-17','','END USER','2348131593035',0.00,7920.00,'03171102','2023-03-17 11:03:56',5,'cash','','',7920.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1101,'1','312','36','2023-03-17','','END USER','2348131593035',0.00,2880.00,'03171104','2023-03-17 11:08:18',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1102,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,9000.00,'03171113','2023-03-17 11:15:03',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1103,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,7200.00,'03171116','2023-03-17 11:16:59',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1104,'1','312','36','2023-03-17','6','EMEKA GAS','08169860051',0.00,81600.00,'03171119','2023-03-17 11:22:16',5,'cash','','',81600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1105,'1','312','36','2023-03-17','','END USER','2348131593035',0.00,4680.00,'03171125','2023-03-17 12:21:25',5,'cash','','',4680.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1106,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,4320.00,'03171236','2023-03-17 12:37:02',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1107,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,11160.00,'03171247','2023-03-17 12:47:58',5,'cash','','',11160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1108,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,4320.00,'03171304','2023-03-17 13:05:14',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1109,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,3600.00,'03171336','2023-03-17 13:41:26',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1110,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,7200.00,'03171401','2023-03-17 14:02:04',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1111,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,5040.00,'03171414','2023-03-17 14:20:16',2,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1112,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,28800.00,'03171439','2023-03-17 14:39:45',5,'cash','','',28800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1113,'1','312','36','2023-03-17','','END USER','2348131593035',0.00,7200.00,'03171451','2023-03-17 14:51:33',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1114,'1','312','36','2023-03-17','','END USER','2348131593035',0.00,3103.20,'03171453','2023-03-17 14:53:51',5,'cash','','',3103.20,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1115,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,7200.00,'03171507','2023-03-17 15:07:30',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1116,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,5040.00,'03171523','2023-03-17 15:23:32',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1117,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,12240.00,'03171524','2023-03-17 15:25:47',5,'cash','','',12240.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1118,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,2160.00,'03171554','2023-03-17 16:11:52',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1119,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,4680.00,'03171613','2023-03-17 16:14:48',5,'cash','','',4680.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1120,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,18000.00,'03171620','2023-03-17 16:21:11',5,'cash','','',18000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1121,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,5040.00,'03171622','2023-03-17 16:38:05',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1122,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,13320.00,'03171639','2023-03-17 16:40:17',5,'cash','','',13320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1123,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,7200.00,'03171641','2023-03-17 16:41:29',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1124,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,2880.00,'03171646','2023-03-17 16:49:50',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1126,'1','312','36','2023-03-17','3','JOSIAH GAS','07033059724',0.00,2040.00,'03171656','2023-03-17 16:57:16',2,'cash','','',2040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1127,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,7200.00,'03171708','2023-03-17 17:09:01',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1128,'1','312','36','2023-03-17','','END USER','2348131593035',0.00,9000.00,'03171710','2023-03-17 17:11:11',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1129,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,9000.00,'03171714','2023-03-17 17:30:36',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1130,'1','312','36','2023-03-17','','END USER','2348131593035',0.00,7200.00,'03171731','2023-03-17 17:34:46',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1138,'1','312','36','2023-03-17','','END USER','2348131593035',0.00,720.00,'03171736','2023-03-17 17:37:04',5,'cash','','',720.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1139,'1','312','36','2023-03-17','','END USER','2348131593035',0.00,2160.00,'03171737','2023-03-17 17:42:52',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1142,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,1440.00,'03171757','2023-03-17 17:58:26',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1143,'1','312','36','2023-03-17','','END USER','2348131593035',0.00,9000.00,'03171808','2023-03-17 18:09:07',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1144,'1','312','36','2023-03-17','','END USER','2348131593035',0.00,2160.00,'03171815','2023-03-17 18:15:58',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1145,'1','312','36','2023-03-17','','END USER','2348131593035',0.00,3600.00,'03171816','2023-03-17 18:17:02',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1146,'1','312','36','2023-03-17','','END USER','2348131593035',0.00,11160.00,'03171817','2023-03-17 18:18:38',5,'cash','','',11160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1147,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,1600.00,'03171821','2023-03-17 18:23:03',5,'cash','','',1600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1148,'1','312','36','2023-03-17','8','uche gas','09150527512',0.00,30600.00,'03171838','2023-03-17 18:40:14',2,'cash','','',30600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1149,'1','312','36','2023-03-17','','END USER','2348131593035',0.00,5000.00,'03171841','2023-03-17 18:42:49',5,'cash','','',5000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1150,'1','312','36','2023-03-17','','END USER','2348131593035',0.00,12600.00,'03171843','2023-03-17 18:44:34',5,'cash','','',12600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1151,'1','312','36','2023-03-17','','END USER','2348134818197',0.00,1500.00,'03171845','2023-03-17 18:45:51',5,'cash','','',1500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1152,'1','312','36','2023-03-17','','END USER','2348131593035',0.00,2851.20,'03171851','2023-03-17 19:01:30',5,'cash','','',2851.20,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1153,'1','312','36','2023-03-17','8','uche gas','09150527512',0.00,32204.80,'03171913','2023-03-17 19:14:32',5,'cash','','',32204.80,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1154,'1','312','37','2023-03-19','','END USER','2348131593035',0.00,3600.00,'03191020','2023-03-19 10:21:01',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1155,'1','312','37','2023-03-19','','END USER','2348131593035',0.00,5040.00,'03191021','2023-03-19 10:22:12',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1156,'1','312','37','2023-03-19','','END USER','2348131593035',0.00,9000.00,'03191022','2023-03-19 10:23:46',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1157,'1','312','37','2023-03-19','','END USER','2348131593035',0.00,10800.00,'03191024','2023-03-19 10:24:54',5,'cash','','',10800.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1158,'1','312','37','2023-03-19','','END USER','2348131593035',0.00,2160.00,'03191025','2023-03-19 10:26:07',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1159,'1','312','37','2023-03-19','','END USER','2348131593035',0.00,2160.00,'03191026','2023-03-19 10:27:20',5,'cash','','',4320.00,2160.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1160,'1','312','37','2023-03-19','','END USER','2348131593035',0.00,2880.00,'03191028','2023-03-19 10:28:50',5,'cash','','',5760.00,2880.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1161,'1','312','37','2023-03-19','','END USER','2348131593035',0.00,13320.00,'03191030','2023-03-19 10:31:28',5,'cash','','',13320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1162,'1','312','37','2023-03-19','','END USER','2348131593035',0.00,7200.00,'03191033','2023-03-19 10:34:05',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1163,'1','312','37','2023-03-19','','END USER','2348131593035',0.00,2000.00,'03191035','2023-03-19 10:35:41',5,'cash','','',2000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1164,'1','312','37','2023-03-19','','END USER','2348131593035',0.00,8000.00,'03191036','2023-03-19 10:37:12',5,'cash','','',8000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1165,'1','312','37','2023-03-19','','END USER','2348131593035',0.00,6480.00,'03191159','2023-03-19 12:00:34',5,'cash','','',6480.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1166,'1','312','37','2023-03-19','','END USER','2348131593035',0.00,3960.00,'03191201','2023-03-19 12:01:51',5,'cash','','',3960.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1167,'1','312','37','2023-03-19','','END USER','2348131593035',0.00,9000.00,'03191202','2023-03-19 12:02:57',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1168,'1','312','37','2023-03-19','','END USER','2348131593035',0.00,3000.00,'03191203','2023-03-19 12:04:26',5,'cash','','',3000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1169,'1','312','37','2023-03-19','','END USER','2348131593035',0.00,9000.00,'03191205','2023-03-19 12:05:30',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1170,'1','312','37','2023-03-19','','END USER','2348131593035',0.00,2160.00,'03191206','2023-03-19 12:06:28',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1171,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,9000.00,'03191217','2023-03-19 12:30:29',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1172,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,11160.00,'03191245','2023-03-19 12:45:30',5,'cash','','',11160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1173,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,9000.00,'03191249','2023-03-19 12:50:13',5,'cash','','',9000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1174,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,7920.00,'03191251','2023-03-19 12:52:26',5,'cash','','',7920.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1175,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,4320.00,'03191339','2023-03-19 13:40:16',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1176,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,4320.00,'03191341','2023-03-19 13:42:16',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1177,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,2880.00,'03191348','2023-03-19 13:49:09',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1178,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,3600.00,'03191354','2023-03-19 14:01:11',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1179,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,3600.00,'03191405','2023-03-19 14:06:22',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1180,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,5040.00,'03191410','2023-03-19 14:11:15',5,'cash','','',5040.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1181,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,4320.00,'03191426','2023-03-19 14:28:43',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1182,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,8280.00,'03191433','2023-03-19 14:34:19',5,'cash','','',8280.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1183,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,7200.00,'03191446','2023-03-19 14:51:02',5,'cash','','',7200.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1184,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,2160.00,'03191457','2023-03-19 14:58:13',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1185,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,2880.00,'03191511','2023-03-19 15:15:46',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1186,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,2000.00,'03191529','2023-03-19 15:30:19',5,'cash','','',2000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1187,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,2160.00,'03191532','2023-03-19 15:33:07',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1188,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,3600.00,'03191538','2023-03-19 15:41:51',5,'cash','','',3600.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1189,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,1440.00,'03191544','2023-03-19 15:45:01',5,'cash','','',1440.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1190,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,2160.00,'03191547','2023-03-19 15:47:40',5,'cash','','',2160.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1191,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,4300.00,'03191552','2023-03-19 15:53:41',5,'cash','','',4300.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1192,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,2880.00,'03191555','2023-03-19 15:55:40',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1193,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,4000.00,'03191609','2023-03-19 16:09:42',5,'cash','','',4000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1194,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,2880.00,'03191611','2023-03-19 16:12:15',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1196,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,2880.00,'03191621','2023-03-19 16:22:31',5,'cash','','',2880.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1197,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,8640.00,'03191633','2023-03-19 16:34:33',5,'cash','','',8640.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1198,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,4320.00,'03191646','2023-03-19 16:47:27',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1199,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,4320.00,'03191649','2023-03-19 16:51:10',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1200,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,1500.00,'03191715','2023-03-19 17:15:33',5,'cash','','',1500.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1201,'1','312','37','2023-03-19','4','PZ GAS','08063508191',0.00,187000.00,'03191723','2023-03-19 17:25:04',5,'cash','','',187000.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1203,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,8640.00,'03191751','2023-03-19 17:51:42',5,'cash','','',8640.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1204,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,4320.00,'03191752','2023-03-19 17:53:13',5,'cash','','',4320.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1205,'1','312','37','2023-03-19','','END USER','2348134818197',0.00,750.00,'03191828','2023-03-19 18:30:00',5,'cash','','',750.00,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(1206,'1','312','37','2023-03-19','','END USER','2348131593035',0.00,1310.40,'03191847','2023-03-19 18:53:55',5,'cash','','',1310.40,0.00,'','1027','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1207 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
INSERT INTO `retail_sales_items` VALUES (1,'1','312','1','1',1,'0','Cooking Gas','1',593.00,760.00,1.00,1.96,760.00,'',0.00,0.00,0.00,5),(2,'1','312','1','2',1,'0','Cooking Gas','1',593.00,760.00,8.00,15.68,6080.00,'',0.00,0.00,0.00,5),(3,'1','312','2','3',1,'0','Cooking Gas','1',593.00,760.00,1.00,1.96,760.00,'',0.00,0.00,0.00,5),(4,'1','312','2','4',1,'0','Cooking Gas','1',593.00,760.00,93.35,182.97,70946.00,'',0.00,0.00,0.00,5),(5,'1','312','3','5',1,'0','Cooking Gas','1',593.00,760.00,5.00,9.80,3800.00,'',0.00,0.00,0.00,5),(6,'1','312','3','6',1,'0','Cooking Gas','1',593.00,760.00,6.00,11.76,4560.00,'',0.00,0.00,0.00,5),(7,'1','312','3','7',1,'0','Cooking Gas','1',593.00,760.00,5.00,9.80,3800.00,'',0.00,0.00,0.00,5),(8,'1','312','3','8',1,'0','Cooking Gas','1',593.00,760.00,5.00,9.80,3800.00,'',0.00,0.00,0.00,5),(9,'1','312','3','9',1,'0','Cooking Gas','1',593.00,760.00,5.00,9.80,3800.00,'',0.00,0.00,0.00,5),(11,'1','312','3','11',1,'0','Cooking Gas','1',593.00,760.00,3.29,6.45,2500.00,'',0.00,0.00,0.00,5),(12,'1','312','3','12',1,'0','Cooking Gas','1',593.00,760.00,3.03,5.94,2300.00,'',0.00,0.00,0.00,5),(13,'1','312','3','13',1,'0','Cooking Gas','1',593.00,760.00,2.00,3.92,1520.00,'',0.00,0.00,0.00,5),(14,'1','312','3','14',1,'0','Cooking Gas','1',593.00,760.00,1.97,3.86,1500.00,'',0.00,0.00,0.00,5),(15,'1','312','3','15',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(16,'1','312','3','16',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(17,'1','312','3','17',1,'0','Cooking Gas','1',593.00,760.00,3.50,6.86,2660.00,'',0.00,0.00,0.00,5),(18,'1','312','3','18',1,'0','Cooking Gas','1',593.00,760.00,4.61,9.04,3500.00,'',0.00,0.00,0.00,5),(19,'1','312','3','19',1,'0','Cooking Gas','1',593.00,760.00,6.00,11.76,4560.00,'',0.00,0.00,0.00,5),(20,'1','312','3','20',1,'0','Cooking Gas','1',593.00,760.00,6.00,11.76,4560.00,'',0.00,0.00,0.00,5),(21,'1','312','3','21',1,'0','Cooking Gas','1',593.00,760.00,1.00,1.96,760.00,'',0.00,0.00,0.00,5),(22,'1','312','3','22',1,'0','Cooking Gas','1',593.00,760.00,5.26,10.31,4000.00,'',0.00,0.00,0.00,5),(23,'1','312','3','23',1,'0','Cooking Gas','1',593.00,760.00,6.00,11.76,4560.00,'',0.00,0.00,0.00,5),(24,'1','312','3','24',1,'0','Cooking Gas','1',593.00,760.00,16.58,32.50,12600.00,'',0.00,0.00,0.00,5),(25,'1','312','3','25',1,'0','Cooking Gas','1',593.00,760.00,3.03,5.94,2300.00,'',0.00,0.00,0.00,5),(26,'1','312','3','26',1,'0','Cooking Gas','1',593.00,760.00,9.77,19.15,7425.20,'',0.00,0.00,0.00,5),(27,'1','312','3','27',1,'0','Cooking Gas','1',593.00,760.00,10.00,19.60,7600.00,'',0.00,0.00,0.00,5),(28,'1','312','3','28',1,'0','Cooking Gas','1',593.00,760.00,9.00,17.64,6840.00,'',0.00,0.00,0.00,5),(29,'1','312','3','29',1,'0','Cooking Gas','1',593.00,760.00,40.00,78.40,30400.00,'',0.00,0.00,0.00,5),(30,'1','312','4','30',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(31,'1','312','4','31',1,'0','Cooking Gas','1',593.00,760.00,6.00,11.76,4560.00,'',0.00,0.00,0.00,5),(32,'1','312','4','32',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(33,'1','312','4','33',1,'0','Cooking Gas','1',593.00,760.00,10.00,19.60,7600.00,'',0.00,0.00,0.00,5),(34,'1','312','4','34',1,'0','Cooking Gas','1',593.00,760.00,2.04,4.00,1550.00,'',0.00,0.00,0.00,5),(35,'1','312','4','35',1,'0','Cooking Gas','1',593.00,760.00,3.03,5.94,2300.00,'',0.00,0.00,0.00,5),(36,'1','312','4','36',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(37,'1','312','4','37',1,'0','Cooking Gas','1',593.00,760.00,6.00,11.76,4560.00,'',0.00,0.00,0.00,5),(38,'1','312','4','38',1,'0','Cooking Gas','1',593.00,760.00,14.00,27.44,10640.00,'',0.00,0.00,0.00,5),(39,'1','312','4','39',1,'0','Cooking Gas','1',593.00,760.00,5.00,9.80,3800.00,'',0.00,0.00,0.00,5),(40,'1','312','4','40',1,'0','Cooking Gas','1',593.00,760.00,6.00,11.76,4560.00,'',0.00,0.00,0.00,5),(41,'1','312','4','41',1,'0','Cooking Gas','1',593.00,760.00,5.26,10.31,4000.00,'',0.00,0.00,0.00,5),(42,'1','312','4','42',1,'0','Cooking Gas','1',593.00,760.00,2.63,5.15,2000.00,'',0.00,0.00,0.00,5),(43,'1','312','4','43',1,'0','Cooking Gas','1',593.00,760.00,11.97,23.46,9100.00,'',0.00,0.00,0.00,5),(44,'1','312','4','44',1,'0','Cooking Gas','1',593.00,760.00,10.53,20.64,8000.00,'',0.00,0.00,0.00,5),(45,'1','312','4','45',1,'0','Cooking Gas','1',593.00,760.00,8.04,15.76,6110.40,'',0.00,0.00,0.00,5),(46,'1','312','4','46',1,'0','Cooking Gas','1',593.00,760.00,10.00,19.60,7600.00,'',0.00,0.00,0.00,5),(47,'1','312','4','47',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(48,'1','312','4','48',1,'0','Cooking Gas','1',593.00,760.00,7.50,14.70,5700.00,'',0.00,0.00,0.00,5),(49,'1','312','4','49',1,'0','Cooking Gas','1',593.00,760.00,20.00,39.20,15200.00,'',0.00,0.00,0.00,5),(50,'1','312','5','50',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(51,'1','312','5','51',1,'0','Cooking Gas','1',593.00,760.00,6.00,11.76,4560.00,'',0.00,0.00,0.00,5),(52,'1','312','5','52',1,'0','Cooking Gas','1',593.00,760.00,5.00,9.80,3800.00,'',0.00,0.00,0.00,5),(53,'1','312','5','53',1,'0','Cooking Gas','1',593.00,760.00,2.63,5.15,2000.00,'',0.00,0.00,0.00,5),(54,'1','312','5','54',1,'0','Cooking Gas','1',593.00,760.00,6.00,11.76,4560.00,'',0.00,0.00,0.00,5),(55,'1','312','5','55',1,'0','Cooking Gas','1',593.00,760.00,4.01,7.86,3050.00,'',0.00,0.00,0.00,5),(56,'1','312','5','56',1,'0','Cooking Gas','1',593.00,760.00,11.00,21.56,8360.00,'',0.00,0.00,0.00,5),(57,'1','312','5','57',1,'0','Cooking Gas','1',593.00,760.00,5.26,10.31,4000.00,'',0.00,0.00,0.00,5),(59,'1','312','5','59',1,'0','Cooking Gas','1',593.00,760.00,6.04,11.84,4590.40,'',0.00,0.00,0.00,5),(60,'1','312','5','60',1,'0','Cooking Gas','1',593.00,760.00,20.00,39.20,15200.00,'',0.00,0.00,0.00,5),(61,'1','312','5','61',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(62,'1','312','5','62',1,'0','Cooking Gas','1',593.00,760.00,6.00,11.76,4560.00,'',0.00,0.00,0.00,5),(63,'1','312','5','63',1,'0','Cooking Gas','1',593.00,760.00,10.00,19.60,7600.00,'',0.00,0.00,0.00,5),(64,'1','312','5','64',1,'0','Cooking Gas','1',593.00,760.00,12.00,23.52,9120.00,'',0.00,0.00,0.00,5),(65,'1','312','5','65',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(66,'1','312','5','66',1,'0','Cooking Gas','1',593.00,760.00,10.00,19.60,7600.00,'',0.00,0.00,0.00,5),(67,'1','312','5','67',1,'0','Cooking Gas','1',593.00,760.00,11.00,21.56,8360.00,'',0.00,0.00,0.00,5),(68,'1','312','5','68',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(69,'1','312','5','69',1,'0','Cooking Gas','1',593.00,760.00,10.00,19.60,7600.00,'',0.00,0.00,0.00,5),(70,'1','312','5','70',1,'0','Cooking Gas','1',593.00,760.00,23.10,45.28,17556.00,'',0.00,0.00,0.00,5),(71,'1','312','5','71',1,'0','Cooking Gas','1',593.00,760.00,0.40,0.78,304.00,'',0.00,0.00,0.00,5),(72,'1','312','6','72',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(73,'1','312','6','73',1,'0','Cooking Gas','1',593.00,760.00,7.00,13.72,5320.00,'',0.00,0.00,0.00,5),(74,'1','312','6','74',1,'0','Cooking Gas','1',593.00,760.00,10.00,19.60,7600.00,'',0.00,0.00,0.00,5),(75,'1','312','6','75',1,'0','Cooking Gas','1',593.00,760.00,11.50,22.54,8740.00,'',0.00,0.00,0.00,5),(76,'1','312','6','76',1,'0','Cooking Gas','1',593.00,760.00,10.00,19.60,7600.00,'',0.00,0.00,0.00,5),(77,'1','312','6','77',1,'0','Cooking Gas','1',593.00,760.00,5.00,9.80,3800.00,'',0.00,0.00,0.00,5),(78,'1','312','6','78',1,'0','Cooking Gas','1',593.00,760.00,6.00,11.76,4560.00,'',0.00,0.00,0.00,5),(79,'1','312','6','79',1,'0','Cooking Gas','1',593.00,760.00,9.00,17.64,6840.00,'',0.00,0.00,0.00,5),(80,'1','312','6','80',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(81,'1','312','6','81',1,'0','Cooking Gas','1',593.00,760.00,6.00,11.76,4560.00,'',0.00,0.00,0.00,5),(82,'1','312','6','82',1,'0','Cooking Gas','1',593.00,760.00,10.00,19.60,7600.00,'',0.00,0.00,0.00,5),(83,'1','312','6','83',1,'0','Cooking Gas','1',593.00,760.00,3.36,6.59,2553.60,'',0.00,0.00,0.00,5),(84,'1','312','6','84',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(85,'1','312','6','85',1,'0','Cooking Gas','1',593.00,760.00,10.00,19.60,7600.00,'',0.00,0.00,0.00,5),(86,'1','312','6','86',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(87,'1','312','6','87',1,'0','Cooking Gas','1',593.00,760.00,10.00,19.60,7600.00,'',0.00,0.00,0.00,5),(88,'1','312','6','88',1,'0','Cooking Gas','1',593.00,760.00,15.00,29.40,11400.00,'',0.00,0.00,0.00,5),(89,'1','312','7','89',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(90,'1','312','7','90',1,'0','Cooking Gas','1',593.00,760.00,5.00,9.80,3800.00,'',0.00,0.00,0.00,5),(91,'1','312','7','91',1,'0','Cooking Gas','1',593.00,760.00,10.00,19.60,7600.00,'',0.00,0.00,0.00,5),(92,'1','312','7','92',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(93,'1','312','7','93',1,'0','Cooking Gas','1',593.00,760.00,11.50,22.54,8740.00,'',0.00,0.00,0.00,5),(94,'1','312','7','94',1,'0','Cooking Gas','1',593.00,760.00,11.00,21.56,8360.00,'',0.00,0.00,0.00,5),(95,'1','312','7','95',1,'0','Cooking Gas','1',593.00,760.00,10.00,19.60,7600.00,'',0.00,0.00,0.00,5),(96,'1','312','7','96',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(97,'1','312','7','97',1,'0','Cooking Gas','1',593.00,760.00,11.50,22.54,8740.00,'',0.00,0.00,0.00,5),(98,'1','312','7','98',1,'0','Cooking Gas','1',593.00,760.00,14.00,27.44,10640.00,'',0.00,0.00,0.00,5),(99,'1','312','7','99',1,'0','Cooking Gas','1',593.00,760.00,10.30,20.19,7828.00,'',0.00,0.00,0.00,5),(100,'1','312','7','100',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(101,'1','312','7','101',1,'0','Cooking Gas','1',593.00,760.00,1.97,3.86,1497.20,'',0.00,0.00,0.00,5),(102,'1','312','7','102',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(103,'1','312','7','103',1,'0','Cooking Gas','1',593.00,760.00,8.70,17.05,6612.00,'',0.00,0.00,0.00,5),(104,'1','312','7','104',1,'0','Cooking Gas','1',593.00,760.00,8.56,16.78,6505.60,'',0.00,0.00,0.00,5),(105,'1','312','8','105',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(106,'1','312','8','106',1,'0','Cooking Gas','1',593.00,760.00,5.00,9.80,3800.00,'',0.00,0.00,0.00,5),(107,'1','312','8','107',1,'0','Cooking Gas','1',593.00,760.00,4.00,7.84,3040.00,'',0.00,0.00,0.00,5),(108,'1','312','8','108',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(109,'1','312','8','109',1,'0','Cooking Gas','1',593.00,760.00,10.00,19.60,7600.00,'',0.00,0.00,0.00,5),(110,'1','312','8','110',1,'0','Cooking Gas','1',593.00,760.00,14.00,27.44,10640.00,'',0.00,0.00,0.00,5),(111,'1','312','8','111',1,'0','Cooking Gas','1',593.00,760.00,11.00,21.56,8360.00,'',0.00,0.00,0.00,5),(112,'1','312','8','112',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(113,'1','312','8','113',1,'0','Cooking Gas','1',593.00,760.00,10.00,19.60,7600.00,'',0.00,0.00,0.00,5),(114,'1','312','8','114',1,'0','Cooking Gas','1',593.00,760.00,14.00,27.44,10640.00,'',0.00,0.00,0.00,5),(115,'1','312','8','115',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(116,'1','312','8','116',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(117,'1','312','8','117',1,'0','Cooking Gas','1',593.00,760.00,10.00,19.60,7600.00,'',0.00,0.00,0.00,5),(118,'1','312','8','118',1,'0','Cooking Gas','1',593.00,760.00,14.14,27.71,10746.40,'',0.00,0.00,0.00,5),(120,'1','312','9','120',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(122,'1','312','9','122',1,'0','Cooking Gas','1',593.00,760.00,1.00,1.96,760.00,'',0.00,0.00,0.00,5),(123,'1','312','9','123',1,'0','Cooking Gas','1',593.00,760.00,3.03,5.94,2300.00,'',0.00,0.00,0.00,5),(124,'1','312','9','124',1,'0','Cooking Gas','1',593.00,760.00,7.89,15.46,6000.00,'',0.00,0.00,0.00,5),(125,'1','312','9','125',1,'0','Cooking Gas','1',593.00,760.00,4.00,7.84,3040.00,'',0.00,0.00,0.00,5),(126,'1','312','9','126',1,'0','Cooking Gas','1',593.00,760.00,3.00,5.88,2280.00,'',0.00,0.00,0.00,5),(127,'1','312','9','127',1,'0','Cooking Gas','1',593.00,760.00,7.00,13.72,5320.00,'',0.00,0.00,0.00,5),(128,'1','312','9','128',1,'0','Cooking Gas','1',593.00,760.00,7.00,13.72,5320.00,'',0.00,0.00,0.00,5),(129,'1','312','9','129',1,'0','Cooking Gas','1',593.00,760.00,6.00,11.76,4560.00,'',0.00,0.00,0.00,5),(130,'1','312','9','130',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(131,'1','312','9','131',1,'0','Cooking Gas','1',593.00,760.00,2.01,3.94,1530.00,'',0.00,0.00,0.00,5),(132,'1','312','9','132',1,'0','Cooking Gas','1',593.00,760.00,5.08,9.96,3860.80,'',0.00,0.00,0.00,5),(133,'1','312','9','133',1,'0','Cooking Gas','1',593.00,760.00,15.00,29.40,11400.00,'',0.00,0.00,0.00,5),(134,'1','312','9','134',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(135,'1','312','9','135',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(136,'1','312','9','136',1,'0','Cooking Gas','1',593.00,760.00,10.00,19.60,7600.00,'',0.00,0.00,0.00,5),(137,'1','312','9','137',1,'0','Cooking Gas','1',593.00,760.00,11.00,21.56,8360.00,'',0.00,0.00,0.00,5),(138,'1','312','9','138',1,'0','Cooking Gas','1',593.00,760.00,9.00,17.64,6840.00,'',0.00,0.00,0.00,5),(139,'1','312','9','139',1,'0','Cooking Gas','1',593.00,760.00,5.00,9.80,3800.00,'',0.00,0.00,0.00,5),(140,'1','312','9','140',1,'0','Cooking Gas','1',593.00,760.00,5.00,9.80,3800.00,'',0.00,0.00,0.00,5),(141,'1','312','9','141',1,'0','Cooking Gas','1',593.00,760.00,10.00,19.60,7600.00,'',0.00,0.00,0.00,5),(142,'1','312','10','142',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(143,'1','312','10','143',1,'0','Cooking Gas','1',593.00,760.00,6.58,12.90,5000.00,'',0.00,0.00,0.00,5),(144,'1','312','10','144',1,'0','Cooking Gas','1',593.00,760.00,3.95,7.74,3000.00,'',0.00,0.00,0.00,5),(145,'1','312','10','145',1,'0','Cooking Gas','1',593.00,760.00,2.00,3.92,1520.00,'',0.00,0.00,0.00,5),(146,'1','312','10','146',1,'0','Cooking Gas','1',593.00,760.00,13.16,25.79,10000.00,'',0.00,0.00,0.00,5),(147,'1','312','10','147',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(148,'1','312','10','148',1,'0','Cooking Gas','1',593.00,760.00,5.00,9.80,3800.00,'',0.00,0.00,0.00,5),(149,'1','312','10','149',1,'0','Cooking Gas','1',593.00,760.00,3.00,5.88,2280.00,'',0.00,0.00,0.00,5),(150,'1','312','10','150',1,'0','Cooking Gas','1',593.00,760.00,9.84,19.29,7480.00,'',0.00,0.00,0.00,5),(151,'1','312','10','151',1,'0','Cooking Gas','1',593.00,760.00,6.00,11.76,4560.00,'',0.00,0.00,0.00,5),(152,'1','312','10','152',1,'0','Cooking Gas','1',593.00,760.00,6.58,12.90,5000.00,'',0.00,0.00,0.00,5),(153,'1','312','10','153',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(154,'1','312','10','154',1,'0','Cooking Gas','1',593.00,760.00,13.16,25.79,10000.00,'',0.00,0.00,0.00,5),(155,'1','312','10','155',1,'0','Cooking Gas','1',593.00,760.00,2.00,3.92,1520.00,'',0.00,0.00,0.00,5),(156,'1','312','10','156',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(157,'1','312','10','157',1,'0','Cooking Gas','1',593.00,760.00,1.32,2.59,1000.00,'',0.00,0.00,0.00,5),(158,'1','312','10','158',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(159,'1','312','10','159',1,'0','Cooking Gas','1',593.00,760.00,6.50,12.74,4940.00,'',0.00,0.00,0.00,5),(160,'1','312','10','160',1,'0','Cooking Gas','1',593.00,760.00,4.00,7.84,3040.00,'',0.00,0.00,0.00,5),(161,'1','312','10','161',1,'0','Cooking Gas','1',593.00,760.00,2.00,3.92,1520.00,'',0.00,0.00,0.00,5),(162,'1','312','10','162',1,'0','Cooking Gas','1',593.00,760.00,5.26,10.31,4000.00,'',0.00,0.00,0.00,5),(163,'1','312','10','163',1,'0','Cooking Gas','1',593.00,760.00,3.00,5.88,2280.00,'',0.00,0.00,0.00,5),(164,'1','312','10','164',1,'0','Cooking Gas','1',593.00,760.00,6.58,12.90,5000.00,'',0.00,0.00,0.00,5),(165,'1','312','10','165',1,'0','Cooking Gas','1',593.00,760.00,2.00,3.92,1520.00,'',0.00,0.00,0.00,5),(166,'1','312','10','166',1,'0','Cooking Gas','1',593.00,760.00,6.58,12.90,5000.00,'',0.00,0.00,0.00,5),(167,'1','312','10','167',1,'0','Cooking Gas','1',593.00,760.00,4.00,7.84,3040.00,'',0.00,0.00,0.00,5),(168,'1','312','10','168',1,'0','Cooking Gas','1',593.00,760.00,30.60,59.98,23256.00,'',0.00,0.00,0.00,5),(169,'1','312','11','169',1,'0','Cooking Gas','1',593.00,760.00,3.00,5.88,2280.00,'',0.00,0.00,0.00,5),(170,'1','312','11','170',1,'0','Cooking Gas','1',593.00,760.00,6.95,13.62,5280.00,'',0.00,0.00,0.00,5),(171,'1','312','11','171',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(172,'1','312','11','172',1,'0','Cooking Gas','1',593.00,760.00,2.63,5.15,2000.00,'',0.00,0.00,0.00,5),(173,'1','312','11','173',1,'0','Cooking Gas','1',593.00,760.00,6.00,11.76,4560.00,'',0.00,0.00,0.00,5),(174,'1','312','11','174',1,'0','Cooking Gas','1',593.00,760.00,3.29,6.45,2500.00,'',0.00,0.00,0.00,5),(175,'1','312','11','175',1,'0','Cooking Gas','1',593.00,760.00,5.00,9.80,3800.00,'',0.00,0.00,0.00,5),(176,'1','312','11','176',1,'0','Cooking Gas','1',593.00,760.00,6.05,11.86,4600.00,'',0.00,0.00,0.00,5),(177,'1','312','11','177',1,'0','Cooking Gas','1',593.00,760.00,3.00,5.88,2280.00,'',0.00,0.00,0.00,5),(178,'1','312','11','178',1,'0','Cooking Gas','1',593.00,760.00,12.50,24.50,9500.00,'',0.00,0.00,0.00,5),(179,'1','312','11','179',1,'0','Cooking Gas','1',593.00,760.00,6.00,11.76,4560.00,'',0.00,0.00,0.00,5),(180,'1','312','11','180',1,'0','Cooking Gas','1',593.00,760.00,10.00,19.60,7600.00,'',0.00,0.00,0.00,5),(181,'1','312','11','181',1,'0','Cooking Gas','1',593.00,760.00,5.26,10.31,4000.00,'',0.00,0.00,0.00,5),(182,'1','312','11','182',1,'0','Cooking Gas','1',593.00,760.00,2.00,3.92,1520.00,'',0.00,0.00,0.00,5),(183,'1','312','11','183',1,'0','Cooking Gas','1',593.00,760.00,3.50,6.86,2660.00,'',0.00,0.00,0.00,5),(184,'1','312','11','184',1,'0','Cooking Gas','1',593.00,760.00,2.63,5.15,2000.00,'',0.00,0.00,0.00,5),(185,'1','312','11','185',1,'0','Cooking Gas','1',593.00,760.00,5.26,10.31,4000.00,'',0.00,0.00,0.00,5),(186,'1','312','12','186',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(187,'1','312','12','187',1,'0','Cooking Gas','1',593.00,720.00,8.47,16.60,6100.00,'',0.00,0.00,0.00,5),(188,'1','312','12','188',1,'0','Cooking Gas','1',593.00,720.00,2.01,3.94,1450.00,'',0.00,0.00,0.00,5),(189,'1','312','12','189',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(190,'1','312','12','190',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(191,'1','312','12','191',1,'0','Cooking Gas','1',593.00,720.00,1.11,2.18,800.00,'',0.00,0.00,0.00,5),(192,'1','312','12','192',1,'0','Cooking Gas','1',593.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(193,'1','312','12','193',1,'0','Cooking Gas','1',593.00,720.00,2.78,5.45,2000.00,'',0.00,0.00,0.00,5),(194,'1','312','12','194',1,'0','Cooking Gas','1',593.00,720.00,13.33,26.13,9600.00,'',0.00,0.00,0.00,5),(195,'1','312','12','195',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(196,'1','312','12','196',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(197,'1','312','13','197',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(198,'1','312','13','198',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(199,'1','312','13','199',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(200,'1','312','13','200',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(201,'1','312','13','201',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(202,'1','312','13','202',1,'0','Cooking Gas','1',593.00,720.00,3.17,6.21,2280.00,'',0.00,0.00,0.00,5),(203,'1','312','13','203',1,'0','Cooking Gas','1',593.00,720.00,5.56,10.90,4000.00,'',0.00,0.00,0.00,5),(204,'1','312','13','204',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(205,'1','312','13','205',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(206,'1','312','13','206',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(207,'1','312','13','207',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(208,'1','312','13','208',1,'0','Cooking Gas','1',593.00,720.00,5.56,10.90,4000.00,'',0.00,0.00,0.00,5),(209,'1','312','13','209',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(210,'1','312','13','210',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(211,'1','312','13','211',1,'0','Cooking Gas','1',593.00,720.00,6.04,11.84,4350.00,'',0.00,0.00,0.00,5),(212,'1','312','13','212',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(213,'1','312','13','213',1,'0','Cooking Gas','1',593.00,720.00,4.17,8.17,3000.00,'',0.00,0.00,0.00,5),(214,'1','312','13','214',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(215,'1','312','13','215',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(216,'1','312','13','216',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(217,'1','312','13','217',1,'0','Cooking Gas','1',593.00,720.00,1.94,3.80,1400.00,'',0.00,0.00,0.00,5),(218,'1','312','13','218',1,'0','Cooking Gas','1',593.00,720.00,4.17,8.17,3000.00,'',0.00,0.00,0.00,5),(219,'1','312','13','219',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(220,'1','312','13','220',1,'0','Cooking Gas','1',593.00,720.00,17.93,35.14,12909.60,'',0.00,0.00,0.00,5),(222,'1','312','14','222',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(223,'1','312','14','223',1,'0','Cooking Gas','1',593.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(224,'1','312','14','224',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(225,'1','312','14','225',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(226,'1','312','14','226',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(227,'1','312','14','227',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(228,'1','312','14','228',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(229,'1','312','14','229',1,'0','Cooking Gas','1',593.00,720.00,12.00,23.52,8640.00,'',0.00,0.00,0.00,5),(230,'1','312','14','230',1,'0','Cooking Gas','1',593.00,720.00,2.78,5.45,2000.00,'',0.00,0.00,0.00,5),(231,'1','312','14','231',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(232,'1','312','14','232',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(233,'1','312','14','233',1,'0','Cooking Gas','1',593.00,720.00,25.00,49.00,18000.00,'',0.00,0.00,0.00,5),(234,'1','312','14','234',1,'0','Cooking Gas','1',593.00,720.00,2.08,4.08,1500.00,'',0.00,0.00,0.00,5),(235,'1','312','14','235',1,'0','Cooking Gas','1',593.00,720.00,8.00,15.68,5760.00,'',0.00,0.00,0.00,5),(237,'1','312','14','237',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(238,'1','312','14','238',1,'0','Cooking Gas','1',593.00,720.00,50.00,98.00,36000.00,'',0.00,0.00,0.00,5),(239,'1','312','14','239',1,'0','Cooking Gas','1',593.00,720.00,2.01,3.94,1450.00,'',0.00,0.00,0.00,5),(240,'1','312','14','240',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(241,'1','312','14','241',1,'0','Cooking Gas','1',593.00,720.00,12.00,23.52,8640.00,'',0.00,0.00,0.00,5),(242,'1','312','14','242',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(243,'1','312','14','243',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(244,'1','312','14','244',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(245,'1','312','14','245',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(246,'1','312','14','246',1,'0','Cooking Gas','1',593.00,720.00,2.47,4.84,1778.40,'',0.00,0.00,0.00,5),(247,'1','312','14','247',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(248,'1','312','14','248',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(249,'1','312','14','249',1,'0','Cooking Gas','1',593.00,720.00,2.78,5.45,2000.00,'',0.00,0.00,0.00,5),(250,'1','312','14','250',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(251,'1','312','15','251',1,'0','Cooking Gas','1',593.00,720.00,15.50,30.38,11160.00,'',0.00,0.00,0.00,5),(252,'1','312','15','252',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(256,'1','312','15','256',1,'0','Cooking Gas','1',593.00,720.00,6.94,13.60,5000.00,'',0.00,0.00,0.00,5),(259,'1','312','15','259',1,'0','Cooking Gas','1',593.00,720.00,2.01,3.94,1450.00,'',0.00,0.00,0.00,5),(260,'1','312','15','260',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(261,'1','312','15','261',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(262,'1','312','15','262',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(263,'1','312','15','263',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(264,'1','312','15','264',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(265,'1','312','15','265',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(266,'1','312','15','266',1,'0','Cooking Gas','1',593.00,720.00,5.97,11.70,4300.00,'',0.00,0.00,0.00,5),(267,'1','312','15','267',1,'0','Cooking Gas','1',593.00,720.00,1.39,2.72,1000.00,'',0.00,0.00,0.00,5),(268,'1','312','15','268',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(269,'1','312','15','269',1,'0','Cooking Gas','1',593.00,720.00,6.67,13.07,4800.00,'',0.00,0.00,0.00,5),(270,'1','312','15','270',1,'0','Cooking Gas','1',593.00,720.00,4.17,8.17,3000.00,'',0.00,0.00,0.00,5),(271,'1','312','15','271',1,'0','Cooking Gas','1',593.00,720.00,6.94,13.60,5000.00,'',0.00,0.00,0.00,5),(272,'1','312','15','272',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(273,'1','312','15','273',1,'0','Cooking Gas','1',593.00,720.00,1.94,3.80,1400.00,'',0.00,0.00,0.00,5),(274,'1','312','15','274',1,'0','Cooking Gas','1',593.00,720.00,2.78,5.45,2000.00,'',0.00,0.00,0.00,5),(275,'1','312','15','275',1,'0','Cooking Gas','1',593.00,720.00,1.00,1.96,720.00,'',0.00,0.00,0.00,5),(276,'1','312','15','276',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(277,'1','312','15','277',1,'0','Cooking Gas','1',593.00,720.00,13.00,25.48,9360.00,'',0.00,0.00,0.00,5),(278,'1','312','15','278',1,'0','Cooking Gas','1',593.00,720.00,11.80,23.13,8496.00,'',0.00,0.00,0.00,5),(279,'1','312','16','279',1,'0','Cooking Gas','1',593.00,720.00,15.00,29.40,10800.00,'',0.00,0.00,0.00,5),(280,'1','312','16','280',1,'0','Cooking Gas','1',593.00,720.00,19.50,38.22,14040.00,'',0.00,0.00,0.00,5),(281,'1','312','16','281',1,'0','Cooking Gas','1',593.00,720.00,4.17,8.17,3000.00,'',0.00,0.00,0.00,5),(282,'1','312','16','282',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(283,'1','312','16','283',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(284,'1','312','16','284',1,'0','Cooking Gas','1',593.00,720.00,1.00,1.96,720.00,'',0.00,0.00,0.00,5),(285,'1','312','16','285',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(286,'1','312','16','286',1,'0','Cooking Gas','1',593.00,720.00,23.00,45.08,16560.00,'',0.00,0.00,0.00,5),(287,'1','312','16','287',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(288,'1','312','16','288',1,'0','Cooking Gas','1',593.00,720.00,2.01,3.94,1450.00,'',0.00,0.00,0.00,5),(289,'1','312','16','289',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(290,'1','312','16','290',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(291,'1','312','16','291',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(292,'1','312','16','292',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(293,'1','312','16','293',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(294,'1','312','16','294',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(295,'1','312','16','295',1,'0','Cooking Gas','1',593.00,720.00,8.00,15.68,5760.00,'',0.00,0.00,0.00,5),(296,'1','312','16','296',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(297,'1','312','16','297',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(298,'1','312','16','298',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(299,'1','312','16','299',1,'0','Cooking Gas','1',593.00,720.00,11.00,21.56,7920.00,'',0.00,0.00,0.00,5),(300,'1','312','16','300',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(301,'1','312','16','301',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(302,'1','312','16','302',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(303,'1','312','16','303',1,'0','Cooking Gas','1',593.00,720.00,46.00,90.16,33120.00,'',0.00,0.00,0.00,5),(304,'1','312','16','304',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(305,'1','312','16','305',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(307,'1','312','16','307',1,'0','Cooking Gas','2',593.00,680.00,205.00,401.80,139400.00,'',0.00,0.00,0.00,5),(308,'1','312','16','308',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(309,'1','312','16','309',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(310,'1','312','16','310',1,'0','Cooking Gas','1',593.00,720.00,1.81,3.55,1300.00,'',0.00,0.00,0.00,5),(311,'1','312','16','311',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(312,'1','312','16','312',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(313,'1','312','16','313',1,'0','Cooking Gas','1',593.00,720.00,3.06,6.00,2200.00,'',0.00,0.00,0.00,5),(314,'1','312','16','314',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(315,'1','312','16','315',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(316,'1','312','16','316',1,'0','Cooking Gas','1',593.00,720.00,3.06,6.00,2200.00,'',0.00,0.00,0.00,5),(317,'1','312','16','317',1,'0','Cooking Gas','1',593.00,720.00,2.01,3.94,1450.00,'',0.00,0.00,0.00,5),(318,'1','312','16','318',1,'0','Cooking Gas','1',593.00,720.00,9.00,17.64,6480.00,'',0.00,0.00,0.00,5),(319,'1','312','16','319',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(320,'1','312','16','320',1,'0','Cooking Gas','2',593.00,675.00,387.41,759.32,261501.75,'',0.00,0.00,0.00,5),(321,'1','312','16','321',1,'0','Cooking Gas','1',593.00,720.00,15.00,29.40,10800.00,'',0.00,0.00,0.00,5),(322,'1','312','16','322',1,'0','Cooking Gas','1',593.00,720.00,2.65,5.19,1908.00,'',0.00,0.00,0.00,5),(323,'1','312','17','323',1,'0','Cooking Gas','1',593.00,720.00,11.94,23.40,8600.00,'',0.00,0.00,0.00,5),(324,'1','312','17','324',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(325,'1','312','17','325',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(326,'1','312','17','326',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(327,'1','312','17','327',1,'0','Cooking Gas','1',593.00,720.00,2.78,5.45,2000.00,'',0.00,0.00,0.00,5),(328,'1','312','17','328',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(329,'1','312','17','329',1,'0','Cooking Gas','1',593.00,720.00,2.08,4.08,1500.00,'',0.00,0.00,0.00,5),(330,'1','312','17','330',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(331,'1','312','17','331',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(332,'1','312','17','332',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(333,'1','312','17','333',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(334,'1','312','17','334',1,'0','Cooking Gas','1',593.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(335,'1','312','17','335',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(336,'1','312','17','336',1,'0','Cooking Gas','1',593.00,720.00,11.50,22.54,8280.00,'',0.00,0.00,0.00,5),(337,'1','312','17','337',1,'0','Cooking Gas','1',593.00,720.00,2.50,4.90,1800.00,'',0.00,0.00,0.00,5),(338,'1','312','17','338',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(339,'1','312','17','339',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(340,'1','312','17','340',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(341,'1','312','17','341',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(342,'1','312','17','342',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(343,'1','312','17','343',1,'0','Cooking Gas','1',593.00,720.00,30.00,58.80,21600.00,'',0.00,0.00,0.00,5),(344,'1','312','17','344',1,'0','Cooking Gas','1',593.00,720.00,2.01,3.94,1450.00,'',0.00,0.00,0.00,5),(345,'1','312','17','345',1,'0','Cooking Gas','1',593.00,720.00,4.03,7.90,2900.00,'',0.00,0.00,0.00,5),(346,'1','312','17','346',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(347,'1','312','17','347',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(348,'1','312','17','348',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(349,'1','312','17','349',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(350,'1','312','17','350',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(351,'1','312','17','351',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(352,'1','312','17','352',1,'0','Cooking Gas','1',593.00,720.00,22.50,44.10,16200.00,'',0.00,0.00,0.00,5),(353,'1','312','17','353',1,'0','Cooking Gas','1',593.00,720.00,25.00,49.00,18000.00,'',0.00,0.00,0.00,5),(354,'1','312','17','354',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(355,'1','312','17','355',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(356,'1','312','17','356',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(357,'1','312','17','357',1,'0','Cooking Gas','1',593.00,720.00,2.50,4.90,1800.00,'',0.00,0.00,0.00,5),(358,'1','312','17','358',1,'0','Cooking Gas','1',593.00,720.00,2.01,3.94,1450.00,'',0.00,0.00,0.00,5),(359,'1','312','17','359',1,'0','Cooking Gas','1',593.00,720.00,50.00,98.00,36000.00,'',0.00,0.00,0.00,5),(360,'1','312','17','360',1,'0','Cooking Gas','1',593.00,720.00,7.50,14.70,5400.00,'',0.00,0.00,0.00,5),(361,'1','312','17','361',1,'0','Cooking Gas','1',593.00,720.00,13.00,25.48,9360.00,'',0.00,0.00,0.00,5),(362,'1','312','17','362',1,'0','Cooking Gas','1',593.00,720.00,15.28,29.95,11000.00,'',0.00,0.00,0.00,5),(363,'1','312','17','363',1,'0','Cooking Gas','1',593.00,720.00,1.28,2.51,921.60,'',0.00,0.00,0.00,5),(364,'1','312','18','364',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(365,'1','312','18','365',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(366,'1','312','18','366',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(367,'1','312','18','367',1,'0','Cooking Gas','1',593.00,720.00,4.17,8.17,3000.00,'',0.00,0.00,0.00,5),(368,'1','312','18','368',1,'0','Cooking Gas','1',593.00,720.00,17.50,34.30,12600.00,'',0.00,0.00,0.00,5),(369,'1','312','18','369',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(370,'1','312','18','370',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(371,'1','312','18','371',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(372,'1','312','18','372',1,'0','Cooking Gas','1',593.00,720.00,11.00,21.56,7920.00,'',0.00,0.00,0.00,5),(373,'1','312','18','373',1,'0','Cooking Gas','1',593.00,720.00,113.33,222.13,81600.00,'',0.00,0.00,0.00,5),(374,'1','312','18','374',1,'0','Cooking Gas','1',593.00,720.00,3.06,6.00,2200.00,'',0.00,0.00,0.00,5),(376,'1','312','18','376',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(377,'1','312','18','377',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(378,'1','312','18','378',1,'0','Cooking Gas','1',593.00,720.00,3.06,6.00,2200.00,'',0.00,0.00,0.00,5),(379,'1','312','18','379',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(380,'1','312','18','380',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(381,'1','312','18','381',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(382,'1','312','18','382',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(383,'1','312','18','383',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(384,'1','312','18','384',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(385,'1','312','18','385',1,'0','Cooking Gas','2',593.00,680.00,110.00,215.60,74800.00,'',0.00,0.00,0.00,5),(386,'1','312','18','386',1,'0','Cooking Gas','1',593.00,720.00,2.78,5.45,2000.00,'',0.00,0.00,0.00,5),(387,'1','312','18','387',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(388,'1','312','18','388',1,'0','Cooking Gas','1',593.00,720.00,6.94,13.60,5000.00,'',0.00,0.00,0.00,5),(389,'1','312','18','389',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(390,'1','312','18','390',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(391,'1','312','18','391',1,'0','Cooking Gas','2',593.00,675.00,649.60,1273.22,438480.00,'',0.00,0.00,0.00,5),(392,'1','312','18','392',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(393,'1','312','18','393',1,'0','Cooking Gas','1',593.00,720.00,2.01,3.94,1450.00,'',0.00,0.00,0.00,5),(394,'1','312','18','394',1,'0','Cooking Gas','1',593.00,720.00,1.00,1.96,720.00,'',0.00,0.00,0.00,5),(395,'1','312','18','395',1,'0','Cooking Gas','2',593.00,680.00,50.00,98.00,34000.00,'',0.00,0.00,0.00,5),(396,'1','312','18','396',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(397,'1','312','18','397',1,'0','Cooking Gas','1',593.00,720.00,2.01,3.94,1450.00,'',0.00,0.00,0.00,5),(398,'1','312','18','398',1,'0','Cooking Gas','1',593.00,720.00,3.06,6.00,2200.00,'',0.00,0.00,0.00,5),(399,'1','312','18','399',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(400,'1','312','18','400',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(401,'1','312','18','401',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(402,'1','312','18','402',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(403,'1','312','18','403',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(404,'1','312','18','404',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(405,'1','312','18','405',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(406,'1','312','18','406',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(407,'1','312','18','407',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(408,'1','312','18','408',1,'0','Cooking Gas','1',593.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(409,'1','312','18','409',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(410,'1','312','18','410',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(411,'1','312','18','411',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(412,'1','312','18','412',1,'0','Cooking Gas','1',593.00,720.00,1.04,2.04,750.00,'',0.00,0.00,0.00,5),(414,'1','312','18','414',1,'0','Cooking Gas','1',593.00,720.00,4.51,8.84,3250.00,'',0.00,0.00,0.00,5),(415,'1','312','18','415',1,'0','Cooking Gas','1',593.00,720.00,11.81,23.15,8500.00,'',0.00,0.00,0.00,5),(416,'1','312','18','416',1,'0','Cooking Gas','2',593.00,680.00,120.00,235.20,81600.00,'',0.00,0.00,0.00,5),(417,'1','312','19','417',1,'0','Cooking Gas','1',593.00,720.00,2.01,3.94,1450.00,'',0.00,0.00,0.00,5),(418,'1','312','19','418',1,'0','Cooking Gas','1',593.00,720.00,4.44,8.70,3200.00,'',0.00,0.00,0.00,5),(419,'1','312','19','419',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(420,'1','312','19','420',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(421,'1','312','19','421',1,'0','Cooking Gas','1',593.00,720.00,20.83,40.83,15000.00,'',0.00,0.00,0.00,5),(422,'1','312','19','422',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(423,'1','312','19','423',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(424,'1','312','19','424',1,'0','Cooking Gas','2',593.00,680.00,60.00,117.60,40800.00,'',0.00,0.00,0.00,5),(426,'1','312','19','426',1,'0','Cooking Gas','1',593.00,720.00,13.19,25.85,9500.00,'',0.00,0.00,0.00,5),(427,'1','312','19','427',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(428,'1','312','19','428',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(429,'1','312','19','429',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(430,'1','312','19','430',1,'0','Cooking Gas','1',593.00,720.00,6.94,13.60,5000.00,'',0.00,0.00,0.00,5),(431,'1','312','19','431',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(432,'1','312','19','432',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(433,'1','312','19','433',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(435,'1','312','19','435',1,'0','Cooking Gas','1',593.00,720.00,3.06,6.00,2200.00,'',0.00,0.00,0.00,5),(436,'1','312','19','436',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(437,'1','312','19','437',1,'0','Cooking Gas','1',593.00,720.00,8.00,15.68,5760.00,'',0.00,0.00,0.00,5),(438,'1','312','19','438',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(439,'1','312','19','439',1,'0','Cooking Gas','1',593.00,720.00,13.00,25.48,9360.00,'',0.00,0.00,0.00,5),(440,'1','312','19','440',1,'0','Cooking Gas','1',593.00,720.00,6.94,13.60,5000.00,'',0.00,0.00,0.00,5),(441,'1','312','19','441',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(442,'1','312','19','442',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(444,'1','312','19','444',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(445,'1','312','19','445',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(446,'1','312','19','446',1,'0','Cooking Gas','1',593.00,720.00,9.00,17.64,6480.00,'',0.00,0.00,0.00,5),(447,'1','312','19','447',1,'0','Cooking Gas','1',593.00,720.00,3.47,6.80,2500.00,'',0.00,0.00,0.00,5),(448,'1','312','19','448',1,'0','Cooking Gas','1',593.00,720.00,3.06,6.00,2200.00,'',0.00,0.00,0.00,5),(449,'1','312','19','449',1,'0','Cooking Gas','1',593.00,720.00,4.17,8.17,3000.00,'',0.00,0.00,0.00,5),(450,'1','312','19','450',1,'0','Cooking Gas','1',593.00,720.00,7.08,13.88,5100.00,'',0.00,0.00,0.00,5),(451,'1','312','19','451',1,'0','Cooking Gas','2',593.00,680.00,110.00,215.60,74800.00,'',0.00,0.00,0.00,5),(452,'1','312','19','452',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(453,'1','312','19','453',1,'0','Cooking Gas','1',593.00,720.00,1.39,2.72,1000.00,'',0.00,0.00,0.00,5),(454,'1','312','19','454',1,'0','Cooking Gas','1',593.00,720.00,13.80,27.05,9936.00,'',0.00,0.00,0.00,5),(455,'1','312','20','455',1,'0','Cooking Gas','1',593.00,720.00,3.47,6.80,2500.00,'',0.00,0.00,0.00,5),(456,'1','312','20','456',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(457,'1','312','20','457',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(458,'1','312','20','458',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(459,'1','312','20','459',1,'0','Cooking Gas','1',593.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(460,'1','312','20','460',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(461,'1','312','20','461',1,'0','Cooking Gas','1',593.00,720.00,47.00,92.12,33840.00,'',0.00,0.00,0.00,5),(462,'1','312','20','462',1,'0','Cooking Gas','1',593.00,720.00,11.00,21.56,7920.00,'',0.00,0.00,0.00,5),(463,'1','312','20','463',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(464,'1','312','20','464',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(465,'1','312','20','465',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(466,'1','312','20','466',1,'0','Cooking Gas','1',593.00,720.00,7.01,13.74,5050.00,'',0.00,0.00,0.00,5),(467,'1','312','20','467',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(468,'1','312','20','468',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(469,'1','312','20','469',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(470,'1','312','20','470',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(471,'1','312','20','471',1,'0','Cooking Gas','1',593.00,720.00,17.00,33.32,12240.00,'',0.00,0.00,0.00,5),(472,'1','312','20','472',1,'0','Cooking Gas','1',593.00,720.00,4.03,7.90,2900.00,'',0.00,0.00,0.00,5),(473,'1','312','20','473',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(474,'1','312','20','474',1,'0','Cooking Gas','1',593.00,720.00,14.00,27.44,10080.00,'',0.00,0.00,0.00,5),(475,'1','312','20','475',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(476,'1','312','20','476',1,'0','Cooking Gas','1',593.00,720.00,17.00,33.32,12240.00,'',0.00,0.00,0.00,5),(477,'1','312','20','477',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(478,'1','312','20','478',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(479,'1','312','20','479',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(480,'1','312','20','480',1,'0','Cooking Gas','1',593.00,720.00,9.00,17.64,6480.00,'',0.00,0.00,0.00,5),(481,'1','312','20','481',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(482,'1','312','20','482',1,'0','Cooking Gas','1',593.00,720.00,3.93,7.70,2829.60,'',0.00,0.00,0.00,5),(483,'1','312','21','483',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(484,'1','312','21','484',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(485,'1','312','21','485',1,'0','Cooking Gas','1',593.00,720.00,12.00,23.52,8640.00,'',0.00,0.00,0.00,5),(486,'1','312','21','486',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(487,'1','312','21','487',1,'0','Cooking Gas','1',593.00,720.00,3.57,7.00,2570.40,'',0.00,0.00,0.00,5),(488,'1','312','21','488',1,'0','Cooking Gas','2',593.00,680.00,275.00,539.00,187000.00,'',0.00,0.00,0.00,5),(489,'1','312','21','489',1,'0','Cooking Gas','2',593.00,680.00,120.00,235.20,81600.00,'',0.00,0.00,0.00,5),(490,'1','312','21','490',1,'0','Cooking Gas','2',593.00,680.00,277.50,543.90,188700.00,'',0.00,0.00,0.00,5),(491,'1','312','21','491',1,'0','Cooking Gas','1',593.00,720.00,8.00,15.68,5760.00,'',0.00,0.00,0.00,5),(492,'1','312','21','492',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(493,'1','312','21','493',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(494,'1','312','21','494',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(495,'1','312','21','495',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(496,'1','312','21','496',1,'0','Cooking Gas','1',593.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(497,'1','312','21','497',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(498,'1','312','21','498',1,'0','Cooking Gas','1',593.00,720.00,17.00,33.32,12240.00,'',0.00,0.00,0.00,5),(499,'1','312','21','499',1,'0','Cooking Gas','1',593.00,720.00,25.00,49.00,18000.00,'',0.00,0.00,0.00,5),(500,'1','312','21','500',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(501,'1','312','21','501',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(502,'1','312','21','502',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(503,'1','312','21','503',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(504,'1','312','21','504',1,'0','Cooking Gas','1',593.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(505,'1','312','21','505',1,'0','Cooking Gas','1',593.00,720.00,2.50,4.90,1800.00,'',0.00,0.00,0.00,5),(506,'1','312','21','506',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(507,'1','312','21','507',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(508,'1','312','21','508',1,'0','Cooking Gas','1',593.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(509,'1','312','21','509',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(510,'1','312','21','510',1,'0','Cooking Gas','2',593.00,680.00,31.00,60.76,21080.00,'',0.00,0.00,0.00,5),(511,'1','312','21','511',1,'0','Cooking Gas','1',593.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(512,'1','312','21','512',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(513,'1','312','21','513',1,'0','Cooking Gas','1',593.00,720.00,3.06,6.00,2200.00,'',0.00,0.00,0.00,5),(514,'1','312','21','514',1,'0','Cooking Gas','1',593.00,9000.00,1.00,1.96,9000.00,'',0.00,0.00,0.00,5),(515,'1','312','21','515',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(516,'1','312','21','516',1,'0','Cooking Gas','1',593.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(517,'1','312','21','517',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(518,'1','312','21','518',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(519,'1','312','21','519',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(521,'1','312','21','521',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(522,'1','312','21','522',1,'0','Cooking Gas','1',593.00,720.00,7.21,14.13,5191.20,'',0.00,0.00,0.00,5),(523,'1','312','21','523',1,'0','Cooking Gas','1',593.00,720.00,20.00,39.20,14400.00,'',0.00,0.00,0.00,5),(524,'1','312','21','524',1,'0','Cooking Gas','1',593.00,720.00,20.00,39.20,14400.00,'',0.00,0.00,0.00,5),(525,'1','312','21','525',1,'0','Cooking Gas','2',593.00,680.00,29.94,58.68,20359.20,'',0.00,0.00,0.00,5),(526,'1','312','22','526',1,'0','Cooking Gas','1',593.00,720.00,8.40,16.46,6050.00,'',0.00,0.00,0.00,5),(527,'1','312','22','527',1,'0','Cooking Gas','1',593.00,720.00,6.94,13.60,5000.00,'',0.00,0.00,0.00,5),(528,'1','312','22','528',1,'0','Cooking Gas','1',593.00,720.00,15.00,29.40,10800.00,'',0.00,0.00,0.00,5),(529,'1','312','22','529',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(530,'1','312','22','530',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(531,'1','312','22','531',1,'0','Cooking Gas','1',593.00,720.00,15.00,29.40,10800.00,'',0.00,0.00,0.00,5),(532,'1','312','22','532',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(533,'1','312','22','533',1,'0','Cooking Gas','1',593.00,720.00,22.50,44.10,16200.00,'',0.00,0.00,0.00,5),(534,'1','312','22','534',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(535,'1','312','22','535',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(536,'1','312','22','536',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(537,'1','312','22','537',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(538,'1','312','22','538',1,'0','Cooking Gas','1',593.00,720.00,4.17,8.17,3000.00,'',0.00,0.00,0.00,5),(539,'1','312','22','539',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(540,'1','312','22','540',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(541,'1','312','22','541',1,'0','Cooking Gas','1',593.00,720.00,9.00,17.64,6480.00,'',0.00,0.00,0.00,5),(542,'1','312','22','542',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(543,'1','312','22','543',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(545,'1','312','22','545',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(546,'1','312','22','546',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(547,'1','312','22','547',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(548,'1','312','22','548',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(549,'1','312','22','549',1,'0','Cooking Gas','1',593.00,720.00,12.00,23.52,8640.00,'',0.00,0.00,0.00,5),(550,'1','312','22','550',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(551,'1','312','22','551',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(552,'1','312','22','552',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(553,'1','312','22','553',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(554,'1','312','22','554',1,'0','Cooking Gas','1',593.00,720.00,11.00,21.56,7920.00,'',0.00,0.00,0.00,5),(555,'1','312','22','555',1,'0','Cooking Gas','1',593.00,720.00,25.00,49.00,18000.00,'',0.00,0.00,0.00,5),(556,'1','312','22','556',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(557,'1','312','22','557',1,'0','Cooking Gas','1',593.00,720.00,2.78,5.45,2000.00,'',0.00,0.00,0.00,5),(558,'1','312','22','558',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(559,'1','312','22','559',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(560,'1','312','22','560',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(561,'1','312','22','561',1,'0','Cooking Gas','1',593.00,720.00,6.50,12.74,4680.00,'',0.00,0.00,0.00,5),(562,'1','312','22','562',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(563,'1','312','22','563',1,'0','Cooking Gas','1',593.00,720.00,25.00,49.00,18000.00,'',0.00,0.00,0.00,5),(564,'1','312','22','564',1,'0','Cooking Gas','1',593.00,720.00,25.00,49.00,18000.00,'',0.00,0.00,0.00,5),(565,'1','312','22','565',1,'0','Cooking Gas','1',593.00,720.00,14.50,28.42,10440.00,'',0.00,0.00,0.00,5),(566,'1','312','22','566',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(567,'1','312','22','567',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(568,'1','312','22','568',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(569,'1','312','22','569',1,'0','Cooking Gas','1',593.00,720.00,6.50,12.74,4680.00,'',0.00,0.00,0.00,5),(570,'1','312','22','570',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(571,'1','312','22','571',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(572,'1','312','22','572',1,'0','Cooking Gas','1',593.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(573,'1','312','22','573',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(574,'1','312','22','574',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(575,'1','312','22','575',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(576,'1','312','22','576',1,'0','Cooking Gas','1',593.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(577,'1','312','22','577',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(578,'1','312','22','578',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(579,'1','312','22','579',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(580,'1','312','22','580',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(582,'1','312','22','582',1,'0','Cooking Gas','1',593.00,720.00,15.00,29.40,10800.00,'',0.00,0.00,0.00,5),(583,'1','312','22','583',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(584,'1','312','22','584',1,'0','Cooking Gas','2',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(585,'1','312','22','585',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(586,'1','312','22','586',1,'0','Cooking Gas','1',593.00,720.00,17.00,33.32,12240.00,'',0.00,0.00,0.00,5),(587,'1','312','22','587',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(589,'1','312','22','589',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(590,'1','312','22','590',1,'0','Cooking Gas','1',593.00,720.00,11.50,22.54,8280.00,'',0.00,0.00,0.00,5),(591,'1','312','22','591',1,'0','Cooking Gas','1',593.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(592,'1','312','22','592',1,'0','Cooking Gas','1',593.00,720.00,11.00,21.56,7920.00,'',0.00,0.00,0.00,5),(593,'1','312','22','593',1,'0','Cooking Gas','1',593.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(594,'1','312','22','594',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(595,'1','312','22','595',1,'0','Cooking Gas','1',593.00,720.00,9.00,17.64,6480.00,'',0.00,0.00,0.00,5),(597,'1','312','22','597',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(598,'1','312','22','598',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(599,'1','312','22','599',1,'0','Cooking Gas','1',593.00,720.00,4.03,7.90,2900.00,'',0.00,0.00,0.00,5),(600,'1','312','22','600',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(601,'1','312','22','601',1,'0','Cooking Gas','1',593.00,720.00,7.50,14.70,5400.00,'',0.00,0.00,0.00,5),(602,'1','312','22','602',1,'0','Cooking Gas','1',593.00,720.00,23.00,45.08,16560.00,'',0.00,0.00,0.00,5),(603,'1','312','22','603',1,'0','Cooking Gas','1',593.00,720.00,4.03,7.90,2900.00,'',0.00,0.00,0.00,5),(604,'1','312','22','604',1,'0','Cooking Gas','2',593.00,675.00,474.39,929.80,320213.25,'',0.00,0.00,0.00,5),(605,'1','312','23','605',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(606,'1','312','23','606',1,'0','Cooking Gas','1',593.00,720.00,3.06,6.00,2200.00,'',0.00,0.00,0.00,5),(607,'1','312','23','607',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(608,'1','312','23','608',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(609,'1','312','23','609',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(610,'1','312','23','610',1,'0','Cooking Gas','1',593.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(611,'1','312','23','611',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(612,'1','312','23','612',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(613,'1','312','23','613',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(614,'1','312','23','614',1,'0','Cooking Gas','1',593.00,720.00,1.00,1.96,720.00,'',0.00,0.00,0.00,5),(615,'1','312','23','615',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(616,'1','312','23','616',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(617,'1','312','23','617',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(618,'1','312','23','618',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(619,'1','312','23','619',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(620,'1','312','23','620',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(621,'1','312','23','621',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(622,'1','312','23','622',1,'0','Cooking Gas','1',593.00,720.00,2.08,4.08,1500.00,'',0.00,0.00,0.00,5),(623,'1','312','23','623',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(624,'1','312','23','624',1,'0','Cooking Gas','1',593.00,720.00,12.00,23.52,8640.00,'',0.00,0.00,0.00,5),(625,'1','312','23','625',1,'0','Cooking Gas','1',593.00,720.00,11.00,21.56,7920.00,'',0.00,0.00,0.00,5),(626,'1','312','23','626',1,'0','Cooking Gas','1',593.00,720.00,11.08,21.72,7980.00,'',0.00,0.00,0.00,5),(627,'1','312','23','627',1,'0','Cooking Gas','1',593.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(628,'1','312','23','628',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(629,'1','312','23','629',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(630,'1','312','23','630',1,'0','Cooking Gas','1',593.00,720.00,1.39,2.72,1000.00,'',0.00,0.00,0.00,5),(631,'1','312','23','631',1,'0','Cooking Gas','2',593.00,675.00,617.95,1211.18,417116.25,'',0.00,0.00,0.00,5),(632,'1','312','23','632',1,'0','Cooking Gas','1',593.00,720.00,32.21,63.13,23191.20,'',0.00,0.00,0.00,5),(633,'1','312','24','633',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(634,'1','312','24','634',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(635,'1','312','24','635',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(636,'1','312','24','636',1,'0','Cooking Gas','1',593.00,720.00,6.50,12.74,4680.00,'',0.00,0.00,0.00,5),(637,'1','312','24','637',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(638,'1','312','24','638',1,'0','Cooking Gas','1',593.00,720.00,8.33,16.33,6000.00,'',0.00,0.00,0.00,5),(639,'1','312','24','639',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(640,'1','312','24','640',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(641,'1','312','24','641',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(642,'1','312','24','642',1,'0','Cooking Gas','1',593.00,720.00,6.25,12.25,4500.00,'',0.00,0.00,0.00,5),(643,'1','312','24','643',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(644,'1','312','24','644',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(645,'1','312','24','645',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(646,'1','312','24','646',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(647,'1','312','24','647',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(648,'1','312','24','648',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(649,'1','312','24','649',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(650,'1','312','24','650',1,'0','Cooking Gas','1',593.00,720.00,5.56,10.90,4000.00,'',0.00,0.00,0.00,5),(651,'1','312','24','651',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(652,'1','312','24','652',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(654,'1','312','24','654',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(655,'1','312','24','655',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(656,'1','312','24','656',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(657,'1','312','24','657',1,'0','Cooking Gas','1',593.00,720.00,4.17,8.17,3000.00,'',0.00,0.00,0.00,5),(658,'1','312','24','658',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(659,'1','312','24','659',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(660,'1','312','24','660',1,'0','Cooking Gas','1',593.00,720.00,3.06,6.00,2200.00,'',0.00,0.00,0.00,5),(661,'1','312','24','661',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(662,'1','312','24','662',1,'0','Cooking Gas','2',593.00,675.00,699.44,1370.90,472122.00,'',0.00,0.00,0.00,5),(663,'1','312','24','663',1,'0','Cooking Gas','1',593.00,720.00,4.94,9.68,3556.80,'',0.00,0.00,0.00,5),(664,'1','312','24','664',1,'0','Cooking Gas','1',593.00,720.00,30.00,58.80,21600.00,'',0.00,0.00,0.00,5),(665,'1','312','25','665',1,'0','Cooking Gas','1',593.00,720.00,6.94,13.60,5000.00,'',0.00,0.00,0.00,5),(666,'1','312','25','666',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(667,'1','312','25','667',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(668,'1','312','25','668',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(669,'1','312','25','669',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(670,'1','312','25','670',1,'0','Cooking Gas','1',593.00,720.00,1.00,1.96,720.00,'',0.00,0.00,0.00,5),(671,'1','312','25','671',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(672,'1','312','25','672',1,'0','Cooking Gas','1',593.00,720.00,2.78,5.45,2000.00,'',0.00,0.00,0.00,5),(673,'1','312','25','673',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(674,'1','312','25','674',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(675,'1','312','25','675',1,'0','Cooking Gas','1',593.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(676,'1','312','25','676',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(677,'1','312','25','677',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(678,'1','312','25','678',1,'0','Cooking Gas','1',593.00,720.00,3.06,6.00,2200.00,'',0.00,0.00,0.00,5),(679,'1','312','25','679',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(680,'1','312','25','680',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(681,'1','312','25','681',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(682,'1','312','25','682',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(683,'1','312','25','683',1,'0','Cooking Gas','1',593.00,720.00,4.17,8.17,3000.00,'',0.00,0.00,0.00,5),(684,'1','312','25','684',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(685,'1','312','25','685',1,'0','Cooking Gas','1',593.00,720.00,5.56,10.90,4000.00,'',0.00,0.00,0.00,5),(686,'1','312','25','686',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(687,'1','312','25','687',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(688,'1','312','25','688',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(689,'1','312','25','689',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(690,'1','312','25','690',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(691,'1','312','25','691',1,'0','Cooking Gas','1',593.00,720.00,5.56,10.90,4000.00,'',0.00,0.00,0.00,5),(692,'1','312','25','692',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(693,'1','312','25','693',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(694,'1','312','25','694',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(695,'1','312','25','695',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(696,'1','312','25','696',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(697,'1','312','25','697',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(698,'1','312','25','698',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(699,'1','312','25','699',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(700,'1','312','25','700',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(701,'1','312','25','701',1,'0','Cooking Gas','2',593.00,680.00,120.00,235.20,81600.00,'',0.00,0.00,0.00,5),(702,'1','312','25','702',1,'0','Cooking Gas','2',593.00,680.00,50.00,98.00,34000.00,'',0.00,0.00,0.00,5),(703,'1','312','26','703',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(705,'1','312','26','705',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(706,'1','312','26','706',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(707,'1','312','26','707',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(708,'1','312','26','708',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(709,'1','312','26','709',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(710,'1','312','26','710',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(711,'1','312','26','711',1,'0','Cooking Gas','1',593.00,720.00,11.00,21.56,7920.00,'',0.00,0.00,0.00,5),(712,'1','312','26','712',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(713,'1','312','26','713',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(714,'1','312','26','714',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(715,'1','312','26','715',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(716,'1','312','26','716',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(717,'1','312','26','717',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(718,'1','312','26','718',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(719,'1','312','26','719',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(720,'1','312','26','720',1,'0','Cooking Gas','1',593.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(721,'1','312','26','721',1,'0','Cooking Gas','1',593.00,720.00,2.08,4.08,1500.00,'',0.00,0.00,0.00,5),(722,'1','312','26','722',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(723,'1','312','26','723',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(724,'1','312','26','724',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(725,'1','312','26','725',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(726,'1','312','26','726',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(727,'1','312','26','727',1,'0','Cooking Gas','1',593.00,720.00,3.47,6.80,2500.00,'',0.00,0.00,0.00,5),(728,'1','312','26','728',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(729,'1','312','26','729',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(730,'1','312','26','730',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(731,'1','312','26','731',1,'0','Cooking Gas','2',593.00,680.00,60.00,117.60,40800.00,'',0.00,0.00,0.00,5),(732,'1','312','26','732',1,'0','Cooking Gas','2',593.00,680.00,60.00,117.60,40800.00,'',0.00,0.00,0.00,5),(733,'1','312','26','733',1,'0','Cooking Gas','1',593.00,720.00,22.50,44.10,16200.00,'',0.00,0.00,0.00,5),(734,'1','312','27','734',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(736,'1','312','27','736',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(737,'1','312','27','737',1,'0','Cooking Gas','1',593.00,720.00,9.72,19.05,7000.00,'',0.00,0.00,0.00,5),(738,'1','312','27','738',1,'0','Cooking Gas','1',593.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(739,'1','312','27','739',1,'0','Cooking Gas','1',593.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(740,'1','312','27','740',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(741,'1','312','27','741',1,'0','Cooking Gas','1',593.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(742,'1','312','27','742',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(743,'1','312','27','743',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(744,'1','312','27','744',1,'0','Cooking Gas','1',593.00,720.00,5.56,10.90,4000.00,'',0.00,0.00,0.00,5),(745,'1','312','27','745',1,'0','Cooking Gas','1',593.00,720.00,6.04,11.84,4350.00,'',0.00,0.00,0.00,5),(746,'1','312','27','746',1,'0','Cooking Gas','1',593.00,720.00,11.00,21.56,7920.00,'',0.00,0.00,0.00,5),(747,'1','312','27','747',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(748,'1','312','27','748',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(749,'1','312','27','749',1,'0','Cooking Gas','1',593.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(750,'1','312','27','750',1,'0','Cooking Gas','2',593.00,680.00,190.00,372.40,129200.00,'',0.00,0.00,0.00,5),(751,'1','312','27','751',1,'0','Cooking Gas','1',593.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(752,'1','312','27','752',1,'0','Cooking Gas','1',593.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(753,'1','312','27','753',1,'0','Cooking Gas','1',593.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(754,'1','312','27','754',1,'0','Cooking Gas','1',593.00,720.00,4.17,8.17,3000.00,'',0.00,0.00,0.00,5),(755,'1','312','27','755',1,'0','Cooking Gas','1',593.00,720.00,7.08,13.88,5100.00,'',0.00,0.00,0.00,5),(756,'1','312','27','756',1,'0','Cooking Gas','1',593.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(757,'1','312','27','757',1,'0','Cooking Gas','1',593.00,720.00,3.06,6.00,2200.00,'',0.00,0.00,0.00,5),(758,'1','312','27','758',1,'0','Cooking Gas','1',593.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(759,'1','312','27','759',1,'0','Cooking Gas','1',593.00,720.00,16.00,31.36,11520.00,'',0.00,0.00,0.00,5),(760,'1','312','27','760',1,'0','Cooking Gas','1',593.00,720.00,2.21,4.33,1591.20,'',0.00,0.00,0.00,5),(761,'1','312','27','761',1,'0','Cooking Gas','1',593.00,720.00,16.67,32.67,12002.40,'',0.00,0.00,0.00,5),(762,'1','312','28','762',1,'0','Cooking Gas','1',610.00,720.00,11.00,21.56,7920.00,'',0.00,0.00,0.00,5),(763,'1','312','28','763',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(764,'1','312','28','764',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(765,'1','312','28','765',1,'0','Cooking Gas','1',610.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(766,'1','312','28','766',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(767,'1','312','28','767',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(768,'1','312','28','768',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(769,'1','312','28','769',1,'0','Cooking Gas','2',610.00,675.00,255.50,500.78,172462.50,'',0.00,0.00,0.00,5),(770,'1','312','28','770',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(771,'1','312','28','771',1,'0','Cooking Gas','1',610.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(772,'1','312','28','772',1,'0','Cooking Gas','1',610.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(773,'1','312','28','773',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(774,'1','312','28','774',1,'0','Cooking Gas','2',610.00,680.00,30.00,58.80,20400.00,'',0.00,0.00,0.00,5),(775,'1','312','28','775',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(776,'1','312','28','776',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(777,'1','312','28','777',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(779,'1','312','28','779',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(780,'1','312','28','780',1,'0','Cooking Gas','1',610.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(781,'1','312','28','781',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(786,'1','312','28','786',1,'0','Cooking Gas','1',610.00,720.00,3.33,6.53,2400.00,'',0.00,0.00,0.00,5),(787,'1','312','28','787',1,'0','Cooking Gas','1',610.00,720.00,5.56,10.90,4000.00,'',0.00,0.00,0.00,5),(788,'1','312','28','788',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(789,'1','312','28','789',1,'0','Cooking Gas','1',610.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(790,'1','312','28','790',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(791,'1','312','28','791',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(792,'1','312','28','792',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(793,'1','312','28','793',1,'0','Cooking Gas','1',610.00,720.00,16.00,31.36,11520.00,'',0.00,0.00,0.00,5),(794,'1','312','28','794',1,'0','Cooking Gas','2',610.00,675.00,305.00,597.80,205875.00,'',0.00,0.00,0.00,5),(795,'1','312','28','795',1,'0','Cooking Gas','1',610.00,720.00,7.38,14.46,5313.60,'',0.00,0.00,0.00,5),(796,'1','312','29','796',1,'0','Cooking Gas','1',610.00,720.00,4.03,7.90,2900.00,'',0.00,0.00,0.00,5),(797,'1','312','29','797',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(798,'1','312','29','798',1,'0','Cooking Gas','1',610.00,720.00,1.00,1.96,720.00,'',0.00,0.00,0.00,5),(799,'1','312','29','799',1,'0','Cooking Gas','1',610.00,720.00,1.39,2.72,1000.00,'',0.00,0.00,0.00,5),(800,'1','312','29','800',1,'0','Cooking Gas','1',610.00,720.00,6.04,11.84,4350.00,'',0.00,0.00,0.00,5),(801,'1','312','29','801',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(802,'1','312','29','802',1,'0','Cooking Gas','2',610.00,680.00,60.00,117.60,40800.00,'',0.00,0.00,0.00,5),(803,'1','312','29','803',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(804,'1','312','29','804',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(805,'1','312','29','805',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(807,'1','312','29','807',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(808,'1','312','29','808',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(809,'1','312','29','809',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(810,'1','312','29','810',1,'0','Cooking Gas','1',610.00,720.00,5.56,10.90,4003.20,'',0.00,0.00,0.00,5),(811,'1','312','29','811',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(812,'1','312','29','812',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(813,'1','312','29','813',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(814,'1','312','29','814',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(815,'1','312','29','815',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(816,'1','312','29','816',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(817,'1','312','29','817',1,'0','Cooking Gas','1',610.00,720.00,20.00,39.20,14400.00,'',0.00,0.00,0.00,5),(818,'1','312','29','818',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(819,'1','312','29','819',1,'0','Cooking Gas','1',610.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(820,'1','312','29','820',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(821,'1','312','30','821',1,'0','Cooking Gas','1',610.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(822,'1','312','30','822',1,'0','Cooking Gas','1',610.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(823,'1','312','30','823',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(824,'1','312','30','824',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(825,'1','312','30','825',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(826,'1','312','30','826',1,'0','Cooking Gas','1',610.00,720.00,8.44,16.54,6080.00,'',0.00,0.00,0.00,5),(827,'1','312','30','827',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(828,'1','312','30','828',1,'0','Cooking Gas','1',610.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(829,'1','312','30','829',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(830,'1','312','30','830',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(831,'1','312','30','831',1,'0','Cooking Gas','2',610.00,680.00,120.00,235.20,81600.00,'',0.00,0.00,0.00,5),(832,'1','312','30','832',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(833,'1','312','30','833',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(835,'1','312','30','835',1,'0','Cooking Gas','1',610.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(836,'1','312','30','836',1,'0','Cooking Gas','1',610.00,720.00,13.00,25.48,9360.00,'',0.00,0.00,0.00,5),(837,'1','312','30','837',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(838,'1','312','30','838',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(839,'1','312','30','839',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(840,'1','312','30','840',1,'0','Cooking Gas','1',610.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(841,'1','312','30','841',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(842,'1','312','30','842',1,'0','Cooking Gas','1',610.00,720.00,35.00,68.60,25200.00,'',0.00,0.00,0.00,5),(843,'1','312','30','843',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(844,'1','312','30','844',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(845,'1','312','30','845',1,'0','Cooking Gas','1',610.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(846,'1','312','30','846',1,'0','Cooking Gas','1',610.00,720.00,4.17,8.17,3000.00,'',0.00,0.00,0.00,5),(847,'1','312','30','847',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(848,'1','312','30','848',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(849,'1','312','30','849',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(850,'1','312','30','850',1,'0','Cooking Gas','1',610.00,720.00,4.17,8.17,3000.00,'',0.00,0.00,0.00,5),(851,'1','312','30','851',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(852,'1','312','30','852',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(853,'1','312','30','853',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(854,'1','312','30','854',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(855,'1','312','30','855',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(856,'1','312','30','856',1,'0','Cooking Gas','1',610.00,720.00,6.04,11.84,4350.00,'',0.00,0.00,0.00,5),(857,'1','312','30','857',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(858,'1','312','30','858',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(859,'1','312','30','859',1,'0','Cooking Gas','1',610.00,720.00,2.78,5.45,2000.00,'',0.00,0.00,0.00,5),(860,'1','312','30','860',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(861,'1','312','30','861',1,'0','Cooking Gas','1',610.00,720.00,5.56,10.90,4000.00,'',0.00,0.00,0.00,5),(862,'1','312','30','862',1,'0','Cooking Gas','2',610.00,680.00,119.15,233.53,81022.00,'',0.00,0.00,0.00,5),(863,'1','312','31','863',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(864,'1','312','31','864',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(865,'1','312','31','865',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(866,'1','312','31','866',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(867,'1','312','31','867',1,'0','Cooking Gas','1',610.00,720.00,19.50,38.22,14040.00,'',0.00,0.00,0.00,5),(868,'1','312','31','868',1,'0','Cooking Gas','1',610.00,720.00,15.00,29.40,10800.00,'',0.00,0.00,0.00,5),(869,'1','312','31','869',1,'0','Cooking Gas','1',610.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(870,'1','312','31','870',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(871,'1','312','31','871',1,'0','Cooking Gas','1',610.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(872,'1','312','31','872',1,'0','Cooking Gas','1',610.00,720.00,1.00,1.96,720.00,'',0.00,0.00,0.00,5),(873,'1','312','31','873',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(874,'1','312','31','874',1,'0','Cooking Gas','1',610.00,720.00,2.78,5.45,2000.00,'',0.00,0.00,0.00,5),(875,'1','312','31','875',1,'0','Cooking Gas','1',610.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(876,'1','312','31','876',1,'0','Cooking Gas','1',610.00,720.00,15.00,29.40,10800.00,'',0.00,0.00,0.00,5),(877,'1','312','31','877',1,'0','Cooking Gas','1',610.00,720.00,4.03,7.90,2900.00,'',0.00,0.00,0.00,5),(878,'1','312','31','878',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(879,'1','312','31','879',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(880,'1','312','31','880',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(881,'1','312','31','881',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(882,'1','312','31','882',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(883,'1','312','31','883',1,'0','Cooking Gas','1',610.00,720.00,4.17,8.17,3000.00,'',0.00,0.00,0.00,5),(884,'1','312','31','884',1,'0','Cooking Gas','1',610.00,720.00,9.00,17.64,6480.00,'',0.00,0.00,0.00,5),(885,'1','312','31','885',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(886,'1','312','31','886',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(887,'1','312','31','887',1,'0','Cooking Gas','1',610.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(888,'1','312','31','888',1,'0','Cooking Gas','1',610.00,720.00,1.39,2.72,1000.00,'',0.00,0.00,0.00,5),(889,'1','312','31','889',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(891,'1','312','31','891',1,'0','Cooking Gas','1',610.00,720.00,16.82,32.97,12110.40,'',0.00,0.00,0.00,5),(893,'1','312','31','893',1,'0','Cooking Gas','1',610.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(894,'1','312','31','894',1,'0','Cooking Gas','1',610.00,720.00,6.94,13.60,5000.00,'',0.00,0.00,0.00,5),(895,'1','312','31','895',1,'0','Cooking Gas','1',610.00,720.00,54.00,105.84,38880.00,'',0.00,0.00,0.00,5),(896,'1','312','31','896',1,'0','Cooking Gas','1',610.00,720.00,25.00,49.00,18000.00,'',0.00,0.00,0.00,5),(897,'1','312','31','897',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(898,'1','312','31','898',1,'0','Cooking Gas','2',610.00,680.00,60.00,117.60,40800.00,'',0.00,0.00,0.00,5),(899,'1','312','31','899',1,'0','Cooking Gas','1',610.00,720.00,3.50,6.86,2520.00,'',0.00,0.00,0.00,5),(900,'1','312','31','900',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(901,'1','312','31','901',1,'0','Cooking Gas','1',610.00,720.00,1.39,2.72,1000.00,'',0.00,0.00,0.00,5),(902,'1','312','31','902',1,'0','Cooking Gas','1',610.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(903,'1','312','31','903',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(904,'1','312','31','904',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(905,'1','312','31','905',1,'0','Cooking Gas','1',610.00,720.00,2.78,5.45,2000.00,'',0.00,0.00,0.00,5),(906,'1','312','31','906',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(908,'1','312','31','908',1,'0','Cooking Gas','1',610.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(909,'1','312','31','909',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(910,'1','312','31','910',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(911,'1','312','31','911',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(912,'1','312','31','912',1,'0','Cooking Gas','1',610.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(913,'1','312','31','913',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(914,'1','312','31','914',1,'0','Cooking Gas','1',610.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(915,'1','312','31','915',1,'0','Cooking Gas','2',610.00,680.00,59.79,117.19,40657.20,'',0.00,0.00,0.00,5),(916,'1','312','31','916',1,'0','Cooking Gas','1',610.00,720.00,5.48,10.74,3945.60,'',0.00,0.00,0.00,5),(917,'1','312','32','917',1,'0','Cooking Gas','1',610.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(918,'1','312','32','918',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(919,'1','312','32','919',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(920,'1','312','32','920',1,'0','Cooking Gas','1',610.00,720.00,3.19,6.25,2300.00,'',0.00,0.00,0.00,5),(921,'1','312','32','921',1,'0','Cooking Gas','1',610.00,720.00,5.50,10.78,3960.00,'',0.00,0.00,0.00,5),(922,'1','312','32','922',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(923,'1','312','32','923',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(926,'1','312','32','926',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(927,'1','312','32','927',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(928,'1','312','32','928',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(929,'1','312','32','929',1,'0','Cooking Gas','1',610.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(930,'1','312','32','930',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(931,'1','312','32','931',1,'0','Cooking Gas','1',610.00,720.00,1.11,2.18,800.00,'',0.00,0.00,0.00,5),(932,'1','312','32','932',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(933,'1','312','32','933',1,'0','Cooking Gas','1',610.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(934,'1','312','32','934',1,'0','Cooking Gas','2',610.00,680.00,58.00,113.68,39440.00,'',0.00,0.00,0.00,5),(936,'1','312','32','936',1,'0','Cooking Gas','1',610.00,720.00,15.00,29.40,10800.00,'',0.00,0.00,0.00,5),(937,'1','312','32','937',1,'0','Cooking Gas','1',610.00,720.00,5.56,10.90,4000.00,'',0.00,0.00,0.00,5),(938,'1','312','32','938',1,'0','Cooking Gas','1',610.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(939,'1','312','32','939',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(940,'1','312','32','940',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(941,'1','312','32','941',1,'0','Cooking Gas','1',610.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(942,'1','312','32','942',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(943,'1','312','32','943',1,'0','Cooking Gas','1',610.00,720.00,50.00,98.00,36000.00,'',0.00,0.00,0.00,5),(944,'1','312','32','944',1,'0','Cooking Gas','1',610.00,720.00,6.94,13.60,5000.00,'',0.00,0.00,0.00,5),(945,'1','312','32','945',1,'0','Cooking Gas','1',610.00,720.00,3.47,6.80,2500.00,'',0.00,0.00,0.00,5),(946,'1','312','32','946',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(947,'1','312','32','947',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(948,'1','312','32','948',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(949,'1','312','32','949',1,'0','Cooking Gas','1',610.00,720.00,5.56,10.90,4000.00,'',0.00,0.00,0.00,5),(950,'1','312','32','950',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(951,'1','312','32','951',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(952,'1','312','32','952',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(953,'1','312','32','953',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(954,'1','312','32','954',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(955,'1','312','32','955',1,'0','Cooking Gas','2',610.00,680.00,55.00,107.80,37400.00,'',0.00,0.00,0.00,5),(956,'1','312','32','956',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(957,'1','312','32','957',1,'0','Cooking Gas','1',610.00,720.00,2.78,5.45,2000.00,'',0.00,0.00,0.00,5),(958,'1','312','32','958',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(959,'1','312','32','959',1,'0','Cooking Gas','1',610.00,720.00,5.56,10.90,4000.00,'',0.00,0.00,0.00,5),(960,'1','312','32','960',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(961,'1','312','32','961',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(962,'1','312','32','962',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(963,'1','312','32','963',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(964,'1','312','32','964',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(965,'1','312','32','965',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(966,'1','312','32','966',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(967,'1','312','32','967',1,'0','Cooking Gas','2',610.00,680.00,98.84,193.73,67211.20,'',0.00,0.00,0.00,5),(968,'1','312','32','968',1,'0','Cooking Gas','1',610.00,720.00,1.00,1.96,720.00,'',0.00,0.00,0.00,5),(969,'1','312','33','969',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(970,'1','312','33','970',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(971,'1','312','33','971',1,'0','Cooking Gas','1',610.00,720.00,17.00,33.32,12240.00,'',0.00,0.00,0.00,5),(972,'1','312','33','972',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(973,'1','312','33','973',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(974,'1','312','33','974',1,'0','Cooking Gas','1',610.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(975,'1','312','33','975',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(976,'1','312','33','976',1,'0','Cooking Gas','1',610.00,720.00,18.50,36.26,13320.00,'',0.00,0.00,0.00,5),(978,'1','312','33','978',1,'0','Cooking Gas','1',610.00,720.00,33.00,64.68,23760.00,'',0.00,0.00,0.00,5),(979,'1','312','33','979',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(980,'1','312','33','980',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(981,'1','312','33','981',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(982,'1','312','33','982',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(983,'1','312','33','983',1,'0','Cooking Gas','1',610.00,720.00,4.17,8.17,3000.00,'',0.00,0.00,0.00,5),(984,'1','312','33','984',1,'0','Cooking Gas','1',610.00,720.00,3.06,6.00,2200.00,'',0.00,0.00,0.00,5),(985,'1','312','33','985',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(986,'1','312','33','986',1,'0','Cooking Gas','1',610.00,720.00,17.00,33.32,12240.00,'',0.00,0.00,0.00,5),(987,'1','312','33','987',1,'0','Cooking Gas','1',610.00,720.00,12.00,23.52,8640.00,'',0.00,0.00,0.00,5),(988,'1','312','33','988',1,'0','Cooking Gas','1',610.00,720.00,1.00,1.96,720.00,'',0.00,0.00,0.00,5),(989,'1','312','33','989',1,'0','Cooking Gas','1',610.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(990,'1','312','33','990',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(991,'1','312','33','991',1,'0','Cooking Gas','1',610.00,720.00,6.25,12.25,4500.00,'',0.00,0.00,0.00,5),(992,'1','312','33','992',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(993,'1','312','33','993',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(994,'1','312','33','994',1,'0','Cooking Gas','1',610.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(995,'1','312','33','995',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(996,'1','312','33','996',1,'0','Cooking Gas','1',610.00,720.00,8.00,15.68,5760.00,'',0.00,0.00,0.00,5),(998,'1','312','33','998',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(999,'1','312','33','999',1,'0','Cooking Gas','2',610.00,680.00,145.00,284.20,98600.00,'',0.00,0.00,0.00,5),(1001,'1','312','33','1001',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(1002,'1','312','33','1002',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(1003,'1','312','33','1003',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(1004,'1','312','33','1004',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(1005,'1','312','33','1005',1,'0','Cooking Gas','1',610.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(1006,'1','312','34','1006',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(1008,'1','312','34','1008',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(1009,'1','312','34','1009',1,'0','Cooking Gas','1',610.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(1010,'1','312','34','1010',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(1011,'1','312','34','1011',1,'0','Cooking Gas','1',610.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(1012,'1','312','34','1012',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(1013,'1','312','34','1013',1,'0','Cooking Gas','1',610.00,720.00,3.06,6.00,2200.00,'',0.00,0.00,0.00,5),(1014,'1','312','34','1014',1,'0','Cooking Gas','1',610.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(1015,'1','312','34','1015',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(1016,'1','312','34','1016',1,'0','Cooking Gas','1',610.00,720.00,4.50,8.82,3240.00,'',0.00,0.00,0.00,5),(1017,'1','312','34','1017',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(1018,'1','312','34','1018',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(1019,'1','312','34','1019',1,'0','Cooking Gas','1',610.00,720.00,15.00,29.40,10800.00,'',0.00,0.00,0.00,5),(1020,'1','312','34','1020',1,'0','Cooking Gas','1',610.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(1021,'1','312','34','1021',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(1022,'1','312','34','1022',1,'0','Cooking Gas','1',610.00,720.00,14.50,28.42,10440.00,'',0.00,0.00,0.00,5),(1023,'1','312','34','1023',1,'0','Cooking Gas','1',610.00,720.00,2.00,3.92,1440.00,'',0.00,0.00,0.00,5),(1024,'1','312','34','1024',1,'0','Cooking Gas','1',610.00,720.00,12.50,24.50,9000.00,'',0.00,0.00,0.00,5),(1025,'1','312','34','1025',1,'0','Cooking Gas','1',610.00,720.00,2.08,4.08,1500.00,'',0.00,0.00,0.00,5),(1026,'1','312','34','1026',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(1027,'1','312','34','1027',1,'0','Cooking Gas','1',610.00,720.00,10.00,19.60,7200.00,'',0.00,0.00,0.00,5),(1028,'1','312','34','1028',1,'0','Cooking Gas','1',610.00,720.00,14.00,27.44,10080.00,'',0.00,0.00,0.00,5),(1029,'1','312','34','1029',1,'0','Cooking Gas','1',610.00,720.00,3.00,5.88,2160.00,'',0.00,0.00,0.00,5),(1030,'1','312','34','1030',1,'0','Cooking Gas','1',610.00,720.00,4.00,7.84,2880.00,'',0.00,0.00,0.00,5),(1031,'1','312','34','1031',1,'0','Cooking Gas','1',610.00,720.00,7.00,13.72,5040.00,'',0.00,0.00,0.00,5),(1032,'1','312','34','1032',1,'0','Cooking Gas','1',610.00,720.00,5.00,9.80,3600.00,'',0.00,0.00,0.00,5),(1033,'1','312','34','1033',1,'0','Cooking Gas','1',610.00,720.00,6.00,11.76,4320.00,'',0.00,0.00,0.00,5),(1034,'1','312'