-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_311
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_311`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_311` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_311`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,4000,'',0,'22','1','311','PURCHASES','','2023-01-23 01:34:43',5,0.00,0.00,'','479','2023-01-23 01:34:43','479',0,0),(2,8000,'',0,'24','1','311','PURCHASES','','2023-01-23 01:35:31',5,0.00,0.00,'','479','2023-01-23 01:35:31','479',0,0),(3,7000,'',0,'20','1','311','SALES','','2023-01-23 01:35:55',5,0.00,0.00,'','479','2023-01-23 01:35:55','479',0,0),(4,500,'',0,'6.1','1','311','CASH','','2023-01-23 01:36:35',5,0.00,0.00,'','479','2023-01-23 01:36:35','479',0,0),(5,8001,'',0,'24','1','311','SALARIES & WAGES','','2023-01-23 01:37:04',5,0.00,0.00,'','479','2023-01-23 01:37:04','479',0,0),(6,2500,'',0,'2','1','311','ZB(LPG)1014471475','','2023-01-23 01:37:37',5,0.00,0.00,'','479','2023-01-23 01:37:37','479',0,0),(7,2501,'',0,'2','1','311','ZNB E-BILL COLLECTION :1014717','','2023-01-23 01:37:47',5,0.00,0.00,'','479','2023-01-23 01:37:47','479',0,0),(8,2502,'',0,'2','1','311','ZNB-:POS 1015965368','','2023-01-23 01:37:58',5,0.00,0.00,'','479','2023-01-23 01:37:58','479',0,0),(9,2503,'',0,'2','1','311','FID POS COLLECTION-5620141491','','2023-01-23 01:38:16',5,0.00,0.00,'','479','2023-01-23 01:38:16','479',0,0),(10,2504,'',0,'2','1','311','FB(IBAL)2023855223','','2023-01-23 01:38:27',5,0.00,0.00,'','479','2023-01-23 01:38:27','479',0,0),(11,2505,'',0,'2','1','311','UBA-0039769388','','2023-01-23 01:38:38',5,0.00,0.00,'','479','2023-01-23 01:38:38','479',0,0),(12,2506,'',0,'2','1','311','UNITY BANK-0024061656','','2023-01-23 01:38:49',5,0.00,0.00,'','479','2023-01-23 01:38:49','479',0,0),(13,2507,'',0,'2','1','311','UBA YOLA-1021398099','','2023-01-23 01:38:59',5,0.00,0.00,'','479','2023-01-23 01:38:59','479',0,0),(14,2508,'',0,'2','1','311','UBA-1019882661','','2023-01-23 01:39:09',5,0.00,0.00,'','479','2023-01-23 01:39:09','479',0,0),(15,2509,'',0,'2','1','311','DANKANO-EBILLS:ZNB1014717618','','2023-01-23 01:40:14',5,0.00,0.00,'','479','2023-01-23 01:40:14','479',0,0),(16,2510,'',0,'2','1','311','TAJJ BANK CITY GATE:0001875361','','2023-01-23 01:40:37',5,0.00,0.00,'','479','2023-01-23 01:40:37','479',0,0),(17,2511,'',0,'2','1','311','POLARIS BANK KEBBI:4091417377','','2023-01-23 01:40:47',5,0.00,0.00,'','479','2023-01-23 01:40:47','479',0,0),(18,2512,'',0,'2','1','311','E-BILLS  IBAL 1015372548','','2023-01-23 01:41:04',5,0.00,0.00,'','479','2023-01-23 01:41:04','479',0,0),(19,2513,'',0,'2','1','311','E-BILLS 1015372548','','2023-01-23 01:41:15',5,0.00,0.00,'','479','2023-01-23 01:41:15','479',0,0),(20,2514,'',0,'2','1','311','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:44:38',5,0.00,0.00,'','792','2023-02-20 14:44:38','792',0,0),(21,2515,'',0,'2','1','311','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:47:04',5,0.00,0.00,'2023-03-15','792','2023-03-17 14:04:10','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','311','samuel onwuka gas','samuel onwuka','08035690297','baseergeo1@gmail.com','owerri','Imo','owerri, Imo state','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-23 18:29:22',5,'1026','2023-02-23 18:29:22','1026'),(2,'','1','311','ikechukwu gas','ikechukwu gas','08167741133','baseergeo1@gmail.com','owerri','Imo','owerri west','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-28 10:58:32',5,'1026','2023-02-28 10:58:32','1026'),(3,'','1','311','PRINCE UCHE','PRINCE UCHE','07063069808','baseergeo1@gmail.com','owerri','Imo','0WERRI','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-04 18:03:09',5,'1026','2023-03-04 18:03:09','1026'),(4,'','1','311','godly gas','godly gas','08037248883','baseergeo1@gmail.com','owerri','Imo','phc rd','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-07 12:02:09',5,'1026','2023-03-07 12:02:09','1026'),(5,'','1','311','chibuzo rita gas','chibuzo rita gas','07063542007','baseergeo1@gmail.com','owerri','Imo','orji','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-07 13:04:36',5,'1026','2023-03-07 13:04:36','1026'),(6,'','1','311','nwachukwu chinaza gas','nwachukwu chinaza','08136165412','baseergeo1@gmail.com','owerri','Imo','owerri west','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-10 12:03:49',5,'1026','2023-03-10 12:03:49','1026'),(7,'','1','311','ROSE GAS ','ROSE GAS','08114205795','baseergeo1@gmail.com','owerri','Imo','OTTA JUNCTIONS','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-15 08:42:12',5,'1026','2023-03-15 08:42:12','1026'),(8,'','1','311','eo.onsco gas','eo.onsco gas','08104065295','baseergeo1@gmail.com','owerri','Imo','atta','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-16 10:56:38',5,'1026','2023-03-16 10:56:38','1026'),(9,'','1','311','god save gas','god save gas','08125885980','baseergeo1@gmail.com','owerri','Imo','opposite nepa office','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-17 09:20:38',5,'1026','2023-03-17 09:20:38','1026');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','311','1',1,'5','LPG NOZZLE 1',8131.11,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','311','1',2,'5','LPG NOZZLE 2',2352.76,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','311','1',3,'5','LPG NOZZLE 3',1353.88,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','311','1',4,'5','LPG NOZZLE 4',1764.19,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','311','1',5,'5','LPG NOZZLE 5',0.00,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','311','1',6,'5','LPG NOZZLE 6',1965.86,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','311',1,'DAILY SHIFT','2023-02-02','2023-02-02 15:49:40','2023-02-03 15:49:40','1026',0.00,0.00,'1026','2023-02-03 10:54:18','1026','2023-02-03 10:58:46',10,0),('1','311',2,'DAILY SHIFT','2023-02-02','2023-02-03 11:00:03','2023-02-04 11:00:03','1026',0.00,0.00,'1026','2023-02-03 11:40:22','1026','2023-02-03 11:41:31',10,0),('1','311',3,'DAILY SHIFT','2023-02-03','2023-02-03 11:42:07','2023-02-04 11:42:07','1026',0.00,0.00,'1026','2023-02-03 21:27:49','1026','2023-02-03 21:28:38',10,0),('1','311',4,'DAILY SHIFT','2023-02-04','2023-02-04 10:01:44','2023-02-05 10:01:44','1026',0.00,0.00,'1026','2023-02-04 20:46:35','1026','2023-02-04 20:46:56',10,0),('1','311',5,'DAILY SHIFT','2023-02-05','2023-02-05 08:35:16','2023-02-06 08:35:16','1026',0.00,0.00,'1026','2023-02-05 11:14:51','1026','2023-02-05 11:15:13',10,0),('1','311',6,'DAILY SHIFT','2023-02-14','2023-02-14 11:22:20','2023-02-15 11:22:20','1026',0.00,0.00,'1026','2023-02-14 14:17:31','1026','2023-02-14 14:17:57',10,0),('1','311',7,'DAILY SHIFT','2023-02-14','2023-02-14 16:20:10','2023-02-15 16:20:10','1026',0.00,0.00,'1026','2023-02-15 07:18:05','1026','2023-02-15 07:18:32',10,0),('1','311',8,'DAILY SHIFT','2023-02-15','2023-02-15 07:19:07','2023-02-16 07:19:07','1026',0.00,0.00,'1026','2023-02-15 21:30:10','1026','2023-02-15 21:31:04',10,0),('1','311',9,'DAILY SHIFT','2023-02-16','2023-02-16 08:13:55','2023-02-17 08:13:55','1026',0.00,0.00,'1026','2023-02-16 18:23:11','1026','2023-02-16 18:23:37',10,0),('1','311',10,'DAILY SHIFT','2023-02-17','2023-02-17 08:12:42','2023-02-18 08:12:42','1026',0.00,0.00,'1026','2023-02-17 20:47:00','1026','2023-02-17 20:47:18',10,0),('1','311',11,'DAILY SHIFT','2023-02-18','2023-02-18 08:12:13','2023-02-19 08:12:13','1026',0.00,0.00,'1026','2023-02-18 21:36:47','1026','2023-02-18 21:37:10',10,0),('1','311',12,'DAILY SHIFT','2023-02-19','2023-02-19 08:42:20','2023-02-20 08:42:20','1026',0.00,0.00,'1026','2023-02-19 20:26:26','1026','2023-02-19 20:26:50',10,0),('1','311',13,'DAILY SHIFT','2023-02-21','2023-02-21 08:23:23','2023-02-22 08:23:23','1026',0.00,0.00,'1026','2023-02-21 23:22:36','1026','2023-02-21 23:23:09',10,0),('1','311',14,'DAILY SHIFT','2023-02-22','2023-02-22 08:12:59','2023-02-23 08:12:59','1026',0.00,0.00,'1026','2023-02-22 18:13:29','1026','2023-02-22 18:13:51',10,0),('1','311',15,'DAILY SHIFT','2023-02-23','2023-02-23 08:12:43','2023-02-24 08:12:43','1026',0.00,0.00,'1026','2023-02-23 20:12:24','1026','2023-02-23 20:12:43',10,0),('1','311',16,'DAILY SHIFT','2023-02-28','2023-02-28 08:13:12','2023-03-01 08:13:12','1026',0.00,0.00,'1026','2023-02-28 21:05:51','1026','2023-02-28 21:06:52',10,0),('1','311',17,'DAILY SHIFT','2023-03-01','2023-03-01 08:12:58','2023-03-02 08:12:58','1026',0.00,0.00,'1026','2023-03-01 20:45:53','1026','2023-03-01 20:46:19',10,0),('1','311',18,'DAILY SHIFT','2023-03-02','2023-03-02 08:06:48','2023-03-03 08:06:48','1026',0.00,0.00,'1026','2023-03-02 20:02:57','1026','2023-03-02 20:03:14',10,0),('1','311',19,'DAILY SHIFT','2023-03-03','2023-03-03 10:00:09','2023-03-04 10:00:09','1026',0.00,0.00,'1026','2023-03-03 18:19:51','1026','2023-03-03 18:20:14',10,0),('1','311',20,'DAILY SHIFT','2023-03-04','2023-03-04 16:50:54','2023-03-05 16:50:54','1026',0.00,0.00,'1026','2023-03-04 22:30:27','1026','2023-03-04 22:31:01',10,0),('1','311',21,'DAILY SHIFT','2023-03-05','2023-03-05 08:24:02','2023-03-06 08:24:02','1026',0.00,0.00,'1026','2023-03-05 18:10:53','1026','2023-03-05 18:11:23',10,0),('1','311',22,'DAILY SHIFT','2023-03-07','2023-03-07 08:01:15','2023-03-08 08:01:15','1026',0.00,0.00,'1026','2023-03-07 20:21:10','1026','2023-03-07 20:21:33',10,0),('1','311',23,'DAILY SHIFT','2023-03-08','2023-03-08 10:51:34','2023-03-09 10:51:34','1026',0.00,0.00,'1026','2023-03-08 19:01:22','1026','2023-03-08 19:01:47',10,0),('1','311',24,'DAILY SHIFT','2023-03-09','2023-03-09 09:11:26','2023-03-10 09:11:26','1026',0.00,0.00,'1026','2023-03-09 18:28:19','1026','2023-03-09 18:28:39',10,0),('1','311',25,'DAILY SHIFT','2023-03-10','2023-03-10 07:16:16','2023-03-11 07:16:16','1026',0.00,0.00,'1026','2023-03-10 19:07:45','1026','2023-03-10 19:08:05',10,0),('1','311',26,'DAILY SHIFT','2023-03-11','2023-03-11 08:17:30','2023-03-12 08:17:30','1026',0.00,0.00,'1026','2023-03-11 23:26:14','1026','2023-03-11 23:26:49',10,0),('1','311',27,'DAILY SHIFT','2023-03-12','2023-03-12 08:02:10','2023-03-13 08:02:10','1026',0.00,0.00,'1026','2023-03-12 20:45:47','1026','2023-03-12 20:46:27',10,0),('1','311',28,'DAILY SHIFT','2023-03-14','2023-03-14 08:14:22','2023-03-15 08:14:22','1026',0.00,0.00,'1026','2023-03-14 18:47:34','1026','2023-03-14 18:47:57',10,0),('1','311',29,'DAILY SHIFT','2023-03-15','2023-03-15 07:56:06','2023-03-16 07:56:06','1026',0.00,0.00,'1026','2023-03-15 17:49:13','1026','2023-03-15 17:49:40',10,0),('1','311',30,'DAILY SHIFT','2023-03-16','2023-03-16 08:05:22','2023-03-17 08:05:22','1026',0.00,0.00,'1026','2023-03-16 22:27:59','1026','2023-03-16 22:28:23',10,0),('1','311',31,'DAILY SHIFT','2023-03-17','2023-03-17 07:49:47','2023-03-18 07:49:47','1026',0.00,0.00,'1026','2023-03-17 19:48:21','1026','2023-03-17 19:48:48',10,0),('1','311',32,'DAILY SHIFT','2023-03-19','2023-03-19 07:44:13','2023-03-20 07:44:13','1026',0.00,0.00,'1026','2023-03-19 19:29:40','1026','2023-03-19 19:29:58',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=191 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','311','1','1',1,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','1',2,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','1',3,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','1',4,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','2',5,'1','1',0.00,28.00,0.00,0.00,28.00,21280.00,0.00,0.00,0.00),('1','311','1','2',6,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','2',7,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','2',8,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','2',9,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','2',10,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','3',11,'1','1',28.00,86.16,0.00,0.00,58.16,44201.60,0.00,0.00,0.00),('1','311','1','3',12,'2','1',0.00,65.55,0.00,0.00,65.55,49818.00,0.00,0.00,0.00),('1','311','1','3',13,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','3',14,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','3',15,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','3',16,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','4',17,'1','1',86.16,148.21,0.00,0.00,62.05,47158.00,0.00,0.00,0.00),('1','311','1','4',18,'2','1',65.55,147.58,0.00,0.00,82.03,62342.80,0.00,0.00,0.00),('1','311','1','4',19,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','4',20,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','4',21,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','4',22,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','5',23,'1','1',148.21,152.69,0.00,0.00,4.48,3404.80,0.00,0.00,0.00),('1','311','1','5',24,'2','1',147.58,159.55,0.00,0.00,11.97,9097.20,0.00,0.00,0.00),('1','311','1','5',25,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','5',26,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','5',27,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','5',28,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','6',29,'1','1',152.69,174.27,0.00,0.00,21.58,16400.80,0.00,0.00,0.00),('1','311','1','6',30,'2','1',159.55,159.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','6',31,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','6',32,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','6',33,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','6',34,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','7',35,'1','1',174.27,198.80,0.00,0.00,24.53,17661.60,0.00,0.00,0.00),('1','311','1','7',36,'2','1',159.55,199.08,0.00,0.00,39.53,28461.60,0.00,0.00,0.00),('1','311','1','7',37,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','7',38,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','7',39,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','7',40,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','8',41,'1','1',198.80,279.65,0.00,0.00,80.85,58212.00,0.00,0.00,0.00),('1','311','1','8',42,'2','1',199.08,258.81,0.00,0.00,59.73,43005.60,0.00,0.00,0.00),('1','311','1','8',43,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','8',44,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','8',45,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','8',46,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','9',47,'1','1',279.65,413.21,0.00,0.00,133.56,96163.20,0.00,0.00,0.00),('1','311','1','9',48,'2','1',258.81,327.30,0.00,0.00,68.49,49312.80,0.00,0.00,0.00),('1','311','1','9',49,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','9',50,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','9',51,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','9',52,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','10',53,'1','1',413.21,477.24,0.00,0.00,64.03,46101.60,0.00,0.00,0.00),('1','311','1','10',54,'2','1',327.30,412.04,0.00,0.00,84.74,61012.80,0.00,0.00,0.00),('1','311','1','10',55,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','10',56,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','10',57,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','10',58,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','11',59,'1','1',477.24,529.04,0.00,0.00,51.80,37296.00,0.00,0.00,0.00),('1','311','1','11',60,'2','1',412.04,457.61,0.00,0.00,45.57,32810.40,0.00,0.00,0.00),('1','311','1','11',61,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','11',62,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','11',63,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','11',64,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','12',65,'1','1',529.04,656.53,0.00,0.00,127.49,91792.80,0.00,0.00,0.00),('1','311','1','12',66,'2','1',457.61,580.41,0.00,0.00,122.80,88416.00,0.00,0.00,0.00),('1','311','1','12',67,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','12',68,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','12',69,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','12',70,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','13',71,'1','1',656.53,775.38,0.00,0.00,118.85,85572.00,0.00,0.00,0.00),('1','311','1','13',72,'2','1',580.41,741.78,0.00,0.00,161.37,116186.40,0.00,0.00,0.00),('1','311','1','13',73,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','13',74,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','13',75,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','13',76,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','14',77,'1','1',775.38,943.04,0.00,0.00,167.66,120715.20,0.00,0.00,0.00),('1','311','1','14',78,'2','1',741.78,852.33,0.00,0.00,110.55,79596.00,0.00,0.00,0.00),('1','311','1','14',79,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','14',80,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','14',81,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','14',82,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','15',83,'1','1',943.04,1124.51,0.00,0.00,181.47,130658.40,0.00,0.00,0.00),('1','311','1','15',84,'2','1',852.33,971.21,0.00,0.00,118.88,85593.60,0.00,0.00,0.00),('1','311','1','15',85,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','15',86,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','15',87,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','15',88,'6','1',0.00,120.00,0.00,0.00,120.00,81600.00,0.00,0.00,0.00),('1','311','1','16',89,'1','1',1124.51,1503.05,0.00,0.00,378.54,272548.80,0.00,0.00,0.00),('1','311','1','16',90,'2','1',971.21,1328.18,0.00,0.00,356.97,257018.40,0.00,0.00,0.00),('1','311','1','16',91,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','16',92,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','16',93,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','16',94,'6','1',120.00,600.00,0.00,0.00,480.00,326400.00,0.00,0.00,0.00),('1','311','1','17',95,'1','1',1503.05,1703.37,0.00,0.00,200.32,144230.40,0.00,0.00,0.00),('1','311','1','17',96,'2','1',1328.18,1484.82,0.00,0.00,156.64,112780.80,0.00,0.00,0.00),('1','311','1','17',97,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','17',98,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','17',99,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','17',100,'6','1',600.00,600.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','18',101,'1','1',1703.37,1773.38,0.00,0.00,70.01,50407.20,0.00,0.00,0.00),('1','311','1','18',102,'2','1',1484.82,1616.72,0.00,0.00,131.90,94968.00,0.00,0.00,0.00),('1','311','1','18',103,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','18',104,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','18',105,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','18',106,'6','1',600.00,660.86,0.00,0.00,60.86,43819.20,0.00,0.00,0.00),('1','311','1','19',107,'1','1',1773.38,1845.55,0.00,0.00,72.17,51962.40,0.00,0.00,0.00),('1','311','1','19',108,'2','1',1616.72,1717.54,0.00,0.00,100.82,72590.40,0.00,0.00,0.00),('1','311','1','19',109,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','19',110,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','19',111,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','19',112,'6','1',660.86,660.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','20',113,'1','1',1845.55,2015.59,0.00,0.00,170.04,122428.80,0.00,0.00,0.00),('1','311','1','20',114,'2','1',1717.54,1892.79,0.00,0.00,175.25,126180.00,0.00,0.00,0.00),('1','311','1','20',115,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','20',116,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','20',117,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','20',118,'6','1',660.86,720.86,0.00,0.00,60.00,40800.00,0.00,0.00,0.00),('1','311','1','21',119,'1','1',2015.59,2185.33,0.00,0.00,169.74,122212.80,0.00,0.00,0.00),('1','311','1','21',120,'2','1',1892.79,2043.42,0.00,0.00,150.63,108453.60,0.00,0.00,0.00),('1','311','1','21',121,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','21',122,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','21',123,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','21',124,'6','1',720.86,720.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','22',125,'1','1',2185.33,2380.79,0.00,0.00,195.46,140731.20,0.00,0.00,0.00),('1','311','1','22',126,'2','1',2043.42,2209.96,0.00,0.00,166.54,119908.80,0.00,0.00,0.00),('1','311','1','22',127,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','22',128,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','22',129,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','22',130,'6','1',720.86,1965.86,0.00,0.00,1245.00,846600.00,0.00,0.00,0.00),('1','311','1','23',131,'1','1',2380.79,2563.10,0.00,0.00,182.31,131263.20,0.00,0.00,0.00),('1','311','1','23',132,'2','1',2209.96,2351.76,0.00,0.00,141.80,102096.00,0.00,0.00,0.00),('1','311','1','23',133,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','23',134,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','23',135,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','23',136,'6','1',1965.86,1965.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','24',137,'1','1',2563.10,2920.00,0.00,0.00,356.90,246261.00,0.00,0.00,0.00),('1','311','1','24',138,'2','1',2351.76,2351.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','24',139,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','24',140,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','24',141,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','24',142,'6','1',1965.86,1965.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','25',143,'1','1',2920.00,3274.58,0.00,0.00,354.58,244660.20,0.00,0.00,0.00),('1','311','1','25',144,'2','1',2351.76,2351.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','25',145,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','25',146,'4','1',0.00,116.00,0.00,0.00,116.00,77720.00,0.00,0.00,0.00),('1','311','1','25',147,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','25',148,'6','1',1965.86,1965.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','26',149,'1','1',3274.58,3948.13,0.00,0.00,673.55,464749.50,0.00,0.00,0.00),('1','311','1','26',150,'2','1',2351.76,2352.76,0.00,0.00,1.00,690.00,0.00,0.00,0.00),('1','311','1','26',151,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','26',152,'4','1',116.00,235.39,0.00,0.00,119.39,79991.30,0.00,0.00,0.00),('1','311','1','26',153,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','26',154,'6','1',1965.86,1965.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','27',155,'1','1',3948.13,4752.59,0.00,0.00,804.46,555077.40,0.00,0.00,0.00),('1','311','1','27',156,'2','1',2352.76,2352.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','27',157,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','27',158,'4','1',235.39,297.39,0.00,0.00,62.00,41600.00,0.00,0.00,0.00),('1','311','1','27',159,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','27',160,'6','1',1965.86,1965.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','28',161,'1','1',4752.59,5704.06,0.00,0.00,951.47,656514.30,0.00,0.00,0.00),('1','311','1','28',162,'2','1',2352.76,2352.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','28',163,'3','1',0.00,424.91,0.00,0.00,424.91,284689.70,0.00,0.00,0.00),('1','311','1','28',164,'4','1',297.39,1138.19,0.00,0.00,840.80,563336.00,0.00,0.00,0.00),('1','311','1','28',165,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','28',166,'6','1',1965.86,1965.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','29',167,'1','1',5704.06,6277.56,0.00,0.00,573.50,395715.00,0.00,0.00,0.00),('1','311','1','29',168,'2','1',2352.76,2352.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','29',169,'3','1',424.91,624.91,0.00,0.00,200.00,134000.00,0.00,0.00,0.00),('1','311','1','29',170,'4','1',1138.19,1197.19,0.00,0.00,59.00,39530.00,0.00,0.00,0.00),('1','311','1','29',171,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','29',172,'6','1',1965.86,1965.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','30',173,'1','1',6277.56,6774.54,0.00,0.00,496.98,342916.20,0.00,0.00,0.00),('1','311','1','30',174,'2','1',2352.76,2352.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','30',175,'3','1',624.91,733.88,0.00,0.00,108.97,73009.90,0.00,0.00,0.00),('1','311','1','30',176,'4','1',1197.19,1305.19,0.00,0.00,108.00,72360.00,0.00,0.00,0.00),('1','311','1','30',177,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','30',178,'6','1',1965.86,1965.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','31',179,'1','1',6774.54,7358.44,0.00,0.00,583.90,402891.00,0.00,0.00,0.00),('1','311','1','31',180,'2','1',2352.76,2352.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','31',181,'3','1',733.88,1035.88,0.00,0.00,302.00,202340.00,0.00,0.00,0.00),('1','311','1','31',182,'4','1',1305.19,1305.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','31',183,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','31',184,'6','1',1965.86,1965.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','32',185,'1','1',7358.44,8131.11,0.00,0.00,772.67,533052.30,0.00,0.00,0.00),('1','311','1','32',186,'2','1',2352.76,2352.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','32',187,'3','1',1035.88,1353.88,0.00,0.00,318.00,213060.00,0.00,0.00,0.00),('1','311','1','32',188,'4','1',1305.19,1764.19,0.00,0.00,459.00,307530.00,0.00,0.00,0.00),('1','311','1','32',189,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','311','1','32',190,'6','1',1965.86,1965.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','311','1','1',593.00,760.00,0.00,0.00,0.00,0.00,0.00,1),('1','311','2','1',593.00,760.00,0.00,28.00,16604.00,21280.00,4676.00,2),('1','311','3','1',593.00,760.00,0.00,123.71,73360.03,94019.60,20659.57,3),('1','311','4','1',593.00,760.00,0.00,144.08,85439.44,109500.80,24061.36,4),('1','311','5','1',593.00,760.00,0.00,16.45,9754.85,12502.00,2747.15,5),('1','311','6','1',593.00,760.00,0.00,21.58,12796.94,16400.80,3603.86,6),('1','311','7','1',593.00,720.00,0.00,64.06,37987.58,46123.20,8135.62,7),('1','311','8','1',593.00,720.00,0.00,140.58,83363.94,101217.60,17853.66,8),('1','311','9','1',593.00,720.00,0.00,202.05,119815.65,145476.00,25660.35,9),('1','311','10','1',593.00,720.00,0.00,148.77,88220.61,107114.40,18893.79,10),('1','311','11','1',593.00,720.00,0.00,97.37,57740.41,70106.40,12365.99,11),('1','311','12','1',593.00,720.00,0.00,250.29,148421.97,180208.80,31786.83,12),('1','311','13','1',593.00,720.00,0.00,280.22,166170.46,201758.40,35587.94,13),('1','311','14','1',593.00,720.00,0.00,278.21,164978.53,200311.20,35332.67,14),('1','311','15','1',593.00,720.00,0.00,420.35,249267.55,297852.00,48584.45,15),('1','311','16','1',593.00,720.00,0.00,1215.51,720797.43,855967.20,135169.77,16),('1','311','17','1',593.00,720.00,0.00,356.96,211677.28,257011.20,45333.92,17),('1','311','18','1',593.00,720.00,0.00,262.77,155822.61,189194.40,33371.79,18),('1','311','19','1',593.00,720.00,0.00,172.99,102583.07,124552.80,21969.73,19),('1','311','20','1',593.00,720.00,0.00,405.29,240336.97,289408.80,49071.83,20),('1','311','21','1',593.00,720.00,0.00,320.37,189979.41,230666.40,40686.99,21),('1','311','22','1',593.00,720.00,0.00,1607.00,952951.00,1107240.00,154289.00,22),('1','311','23','1',593.00,720.00,0.00,324.11,192197.23,233359.20,41161.97,23),('1','311','24','1',593.00,690.00,0.00,356.90,211641.70,246261.00,34619.30,24),('1','311','25','1',593.00,690.00,0.00,470.58,279053.94,322380.20,43326.26,25),('1','311','26','1',593.00,690.00,0.00,793.94,470806.42,545430.80,74624.38,26),('1','311','27','1',593.00,690.00,0.00,866.46,513810.78,596677.40,82866.62,27),('1','311','28','1',593.00,690.00,0.00,2217.18,1314787.74,1504540.00,189752.26,28),('1','311','29','1',593.00,690.00,0.00,832.50,493672.50,569245.00,75572.50,29),('1','311','30','1',593.00,690.00,0.00,713.95,423372.35,488286.10,64913.75,30),('1','311','31','1',593.00,690.00,0.00,885.90,525338.70,605231.00,79892.30,31),('1','311','32','1',593.00,690.00,0.00,1549.67,918954.31,1053642.30,134687.99,32);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'311','LPG PRODUCT ','LPG Product Tanks.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','311','1',1,1,'1','LPG TANK ',25000.00,0.00,NULL,'TANK CONTAINING LPG PRODUCT','479','2023-01-23 01:32:09','2023-01-23 01:32:09','479',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','311',1,4032.20,'2023-03-19 18:50:29');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2270 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','311',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,11622800.00,19600.00,0.00,0.00,'2023-02-02 15:15:10','',''),(2,'1','311',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,19600.00,0.00,'2023-02-02 16:00:55','',''),(3,'1','311','1',1,'Received from bridging 1',0.00,0.00,19600.00,0.00,0.00,'2023-02-02 16:00:55','',''),(4,'1','311','1',1,'Retail Sale Id 1',21280.00,0.00,0.00,28.00,4676.00,'2023-02-03 11:04:06','',''),(5,'1','311','1',1,'Retail Sale Id 2',4316.80,0.00,0.00,5.68,948.56,'2023-02-03 11:53:35','',''),(6,'1','311','1',1,'Retail Sale Id 3',10685.60,0.00,0.00,14.06,2348.02,'2023-02-03 11:56:07','',''),(7,'1','311','1',1,'Retail Sale Id 4',2302.80,0.00,0.00,3.03,506.01,'2023-02-03 12:04:40','',''),(8,'1','311','1',1,'Retail Sale Id 6',1497.20,0.00,0.00,1.97,328.99,'2023-02-03 13:31:13','',''),(9,'1','311','1',1,'Retail Sale Id 7',2280.00,0.00,0.00,3.00,501.00,'2023-02-03 13:35:35','',''),(10,'1','311','1',1,'Retail Sale Id 7',4560.00,0.00,0.00,6.00,1002.00,'2023-02-03 13:35:35','',''),(11,'1','311','1',1,'Retail Sale Id 8',4560.00,0.00,0.00,6.00,1002.00,'2023-02-03 13:49:26','',''),(12,'1','311','1',1,'Retail Sale Id 9',9500.00,0.00,0.00,12.50,2087.50,'2023-02-03 13:57:14','',''),(13,'1','311','1',1,'Retail Sale Id 11',3997.60,0.00,0.00,5.26,878.42,'2023-02-03 14:03:51','',''),(14,'1','311','1',1,'Retail Sale Id 12',1998.80,0.00,0.00,2.63,439.21,'2023-02-03 14:11:37','',''),(15,'1','311','1',1,'Retail Sale Id 13',1398.40,0.00,0.00,1.84,307.28,'2023-02-03 14:16:24','',''),(16,'1','311','1',1,'Retail Sale Id 14',7600.00,0.00,0.00,10.00,1670.00,'2023-02-03 14:18:56','',''),(17,'1','311','1',1,'Retail Sale Id 15',5320.00,0.00,0.00,7.00,1169.00,'2023-02-03 14:20:54','',''),(18,'1','311','1',1,'Retail Sale Id 16',1497.20,0.00,0.00,1.97,328.99,'2023-02-03 14:26:52','',''),(19,'1','311','1',1,'Retail Sale Id 18',1998.80,0.00,0.00,2.63,439.21,'2023-02-03 15:18:51','',''),(20,'1','311','1',1,'Retail Sale Id 19',3800.00,0.00,0.00,5.00,835.00,'2023-02-03 16:11:45','',''),(21,'1','311','1',1,'Retail Sale Id 20',1497.20,0.00,0.00,1.97,328.99,'2023-02-03 16:31:34','',''),(22,'1','311','1',1,'Retail Sale Id 21',1998.80,0.00,0.00,2.63,439.21,'2023-02-03 16:41:50','',''),(23,'1','311','1',1,'Retail Sale Id 22',9500.00,0.00,0.00,12.50,2087.50,'2023-02-03 17:00:16','',''),(24,'1','311','1',1,'Retail Sale Id 26',1922.80,0.00,0.00,2.53,422.51,'2023-02-03 21:22:44','',''),(25,'1','311','1',1,'Retail Sale Id 26',11787.60,0.00,0.00,15.51,2590.17,'2023-02-03 21:22:44','',''),(26,'1','311','1',1,'Retail Sale Id 28',1998.80,0.00,0.00,2.63,439.21,'2023-02-04 10:07:57','',''),(27,'1','311','1',1,'Retail Sale Id 29',760.00,0.00,0.00,1.00,167.00,'2023-02-04 10:13:19','',''),(28,'1','311','1',1,'Retail Sale Id 31',5000.80,0.00,0.00,6.58,1098.86,'2023-02-04 11:14:15','',''),(29,'1','311','1',1,'Retail Sale Id 31',19000.00,0.00,0.00,25.00,4175.00,'2023-02-04 11:14:15','',''),(30,'1','311','1',1,'Return of Retail Sale Id 31',0.00,5000.80,6.58,0.00,-1098.86,'2023-02-04 11:14:54','',''),(31,'1','311','1',1,'Return of Retail Sale Id 31',0.00,19000.00,25.00,0.00,-4175.00,'2023-02-04 11:14:54','',''),(32,'1','311','1',1,'Retail Sale Id 32',9500.00,0.00,0.00,12.50,2087.50,'2023-02-04 11:16:28','',''),(33,'1','311','1',1,'Retail Sale Id 33',5000.80,0.00,0.00,6.58,1098.86,'2023-02-04 11:17:40','',''),(34,'1','311','1',1,'Retail Sale Id 34',1998.80,0.00,0.00,2.63,439.21,'2023-02-04 11:34:05','',''),(35,'1','311','1',1,'Retail Sale Id 35',3002.00,0.00,0.00,3.95,659.65,'2023-02-04 11:49:15','',''),(36,'1','311','1',1,'Retail Sale Id 36',4499.20,0.00,0.00,5.92,988.64,'2023-02-04 11:51:30','',''),(37,'1','311','1',1,'Retail Sale Id 37',1998.80,0.00,0.00,2.63,439.21,'2023-02-04 11:53:36','',''),(38,'1','311','1',1,'Return of Retail Sale Id 36',0.00,4499.20,5.92,0.00,-988.64,'2023-02-04 11:57:44','',''),(39,'1','311','1',1,'Retail Sale Id 38',3997.60,0.00,0.00,5.26,878.42,'2023-02-04 11:59:10','',''),(40,'1','311','1',1,'Retail Sale Id 39',4529.60,0.00,0.00,5.96,995.32,'2023-02-04 14:16:00','',''),(41,'1','311','1',1,'Retail Sale Id 40',1998.80,0.00,0.00,2.63,439.21,'2023-02-04 14:42:14','',''),(42,'1','311','1',1,'Return of Retail Sale Id 40',0.00,1998.80,2.63,0.00,-439.21,'2023-02-04 14:45:08','',''),(43,'1','311','1',1,'Retail Sale Id 41',7600.00,0.00,0.00,10.00,1670.00,'2023-02-04 14:52:24','',''),(44,'1','311','1',1,'Retail Sale Id 43',1003.20,0.00,0.00,1.32,220.44,'2023-02-04 15:03:47','',''),(45,'1','311','1',1,'Retail Sale Id 44',1520.00,0.00,0.00,2.00,334.00,'2023-02-04 15:08:05','',''),(46,'1','311','1',1,'Retail Sale Id 46',760.00,0.00,0.00,1.00,167.00,'2023-02-04 15:13:28','',''),(47,'1','311','1',1,'Retail Sale Id 48',1520.00,0.00,0.00,2.00,334.00,'2023-02-04 16:06:52','',''),(48,'1','311','1',1,'Retail Sale Id 49',1520.00,0.00,0.00,2.00,334.00,'2023-02-04 16:15:17','',''),(49,'1','311','1',1,'Retail Sale Id 50',760.00,0.00,0.00,1.00,167.00,'2023-02-04 16:21:04','',''),(50,'1','311','1',1,'Retail Sale Id 51',9500.00,0.00,0.00,12.50,2087.50,'2023-02-04 16:23:12','',''),(51,'1','311','1',1,'Retail Sale Id 52',3040.00,0.00,0.00,4.00,668.00,'2023-02-04 16:28:56','',''),(52,'1','311','1',1,'Retail Sale Id 53',3040.00,0.00,0.00,4.00,668.00,'2023-02-04 16:50:03','',''),(53,'1','311','1',1,'Retail Sale Id 54',4560.00,0.00,0.00,6.00,1002.00,'2023-02-04 16:53:20','',''),(54,'1','311','1',1,'Retail Sale Id 55',3997.60,0.00,0.00,5.26,878.42,'2023-02-04 17:16:46','',''),(55,'1','311','1',1,'Retail Sale Id 55',5996.40,0.00,0.00,7.89,1317.63,'2023-02-04 17:16:46','',''),(56,'1','311','1',1,'Retail Sale Id 56',9500.00,0.00,0.00,12.50,2087.50,'2023-02-04 17:19:21','',''),(57,'1','311','1',1,'Retail Sale Id 57',6080.00,0.00,0.00,8.00,1336.00,'2023-02-04 17:24:24','',''),(58,'1','311','1',1,'Retail Sale Id 58',8496.80,0.00,0.00,11.18,1867.06,'2023-02-04 17:53:37','',''),(59,'1','311','1',1,'Retail Sale Id 59',1497.20,0.00,0.00,1.97,328.99,'2023-02-04 17:57:23','',''),(60,'1','311','1',1,'Retail Sale Id 60',2348.40,0.00,0.00,3.09,516.03,'2023-02-04 18:04:28','',''),(61,'1','311','1',1,'Return of Retail Sale Id 50',0.00,760.00,1.00,0.00,-167.00,'2023-02-04 20:28:46','',''),(62,'1','311','1',1,'Retail Sale Id 61',1026.00,0.00,0.00,1.35,225.45,'2023-02-04 20:35:05','',''),(63,'1','311','1',1,'Return of Retail Sale Id 56',0.00,9500.00,12.50,0.00,-2087.50,'2023-02-04 20:42:54','',''),(64,'1','311','1',1,'Retail Sale Id 62',1185.60,0.00,0.00,1.56,260.52,'2023-02-04 20:44:06','',''),(65,'1','311','1',1,'Retail Sale Id 63',12023.20,0.00,0.00,15.82,2641.94,'2023-02-04 20:46:00','',''),(66,'1','311','1',1,'Retail Sale Id 64',1998.80,0.00,0.00,2.63,439.21,'2023-02-05 08:36:51','',''),(67,'1','311','1',1,'Retail Sale Id 65',1497.20,0.00,0.00,1.97,328.99,'2023-02-05 08:42:09','',''),(68,'1','311','1',1,'Retail Sale Id 66',1603.60,0.00,0.00,2.11,352.37,'2023-02-05 08:44:17','',''),(69,'1','311','1',1,'Retail Sale Id 67',798.00,0.00,0.00,1.05,175.35,'2023-02-05 08:45:44','',''),(70,'1','311','1',1,'Return of Retail Sale Id 64',0.00,1998.80,2.63,0.00,-439.21,'2023-02-05 09:01:07','',''),(71,'1','311','1',1,'Retail Sale Id 68',7600.00,0.00,0.00,10.00,1670.00,'2023-02-05 09:26:47','',''),(72,'1','311','1',1,'Retail Sale Id 69',1003.20,0.00,0.00,1.32,220.44,'2023-02-05 09:46:13','',''),(73,'1','311','1',1,'Retail Sale Id 70',3800.00,0.00,0.00,5.00,835.00,'2023-02-14 11:23:33','',''),(74,'1','311','1',1,'Retail Sale Id 71',3100.80,0.00,0.00,4.08,681.36,'2023-02-14 12:39:23','',''),(75,'1','311','1',1,'Retail Sale Id 72',9500.00,0.00,0.00,12.50,2087.50,'2023-02-14 12:43:58','',''),(76,'1','311','1',1,'Retail Sale Id 73',1000.80,0.00,0.00,1.39,176.53,'2023-02-14 16:24:04','',''),(77,'1','311','1',1,'Retail Sale Id 74',2001.60,0.00,0.00,2.78,353.06,'2023-02-14 16:25:58','',''),(78,'1','311','1',1,'Retail Sale Id 75',4320.00,0.00,0.00,6.00,762.00,'2023-02-14 16:27:53','',''),(79,'1','311','1',1,'Retail Sale Id 76',3600.00,0.00,0.00,5.00,635.00,'2023-02-14 16:28:58','',''),(80,'1','311','1',1,'Retail Sale Id 77',1000.80,0.00,0.00,1.39,176.53,'2023-02-14 16:33:21','',''),(81,'1','311','1',1,'Return of Retail Sale Id 77',0.00,1000.80,1.39,0.00,-176.53,'2023-02-14 16:36:44','',''),(82,'1','311','1',1,'Retail Sale Id 78',1497.60,0.00,0.00,2.08,264.16,'2023-02-14 16:37:35','',''),(83,'1','311','1',1,'Retail Sale Id 79',1497.60,0.00,0.00,2.08,264.16,'2023-02-14 16:38:42','',''),(84,'1','311','1',1,'Return of Retail Sale Id 78',0.00,1497.60,2.08,0.00,-264.16,'2023-02-14 16:39:40','',''),(85,'1','311','1',1,'Retail Sale Id 82',4348.80,0.00,0.00,6.04,767.08,'2023-02-14 17:29:53','',''),(86,'1','311','1',1,'Retail Sale Id 83',4003.20,0.00,0.00,5.56,706.12,'2023-02-14 17:37:24','',''),(87,'1','311','1',1,'Retail Sale Id 84',4320.00,0.00,0.00,6.00,762.00,'2023-02-14 17:47:29','',''),(88,'1','311','1',1,'Retail Sale Id 85',3600.00,0.00,0.00,5.00,635.00,'2023-02-14 17:58:34','',''),(89,'1','311','1',1,'Retail Sale Id 86',2160.00,0.00,0.00,3.00,381.00,'2023-02-14 18:12:42','',''),(90,'1','311','1',1,'Retail Sale Id 87',1396.80,0.00,0.00,1.94,246.38,'2023-02-14 18:15:29','',''),(91,'1','311','1',1,'Retail Sale Id 88',4680.00,0.00,0.00,6.50,825.50,'2023-02-14 18:17:31','',''),(92,'1','311','1',1,'Retail Sale Id 89',3499.20,0.00,0.00,4.86,617.22,'2023-02-14 18:20:28','',''),(93,'1','311','1',1,'Retail Sale Id 90',698.40,0.00,0.00,0.97,123.19,'2023-02-14 18:24:22','',''),(94,'1','311','1',1,'Return of Retail Sale Id 90',0.00,698.40,0.97,0.00,-123.19,'2023-02-14 20:15:09','',''),(95,'1','311','1',1,'Retail Sale Id 91',5695.20,0.00,0.00,7.91,1004.57,'2023-02-14 20:17:21','',''),(96,'1','311','1',1,'Return of Retail Sale Id 83',0.00,4003.20,5.56,0.00,-706.12,'2023-02-14 20:37:38','',''),(97,'1','311','1',1,'Retail Sale Id 92',3600.00,0.00,0.00,5.00,635.00,'2023-02-14 20:38:28','',''),(98,'1','311','1',1,'Retail Sale Id 93',403.20,0.00,0.00,0.56,71.12,'2023-02-14 20:39:17','',''),(99,'1','311','1',1,'Retail Sale Id 94',7200.00,0.00,0.00,10.00,1270.00,'2023-02-15 07:25:36','',''),(100,'1','311','1',1,'Retail Sale Id 95',2001.60,0.00,0.00,2.78,353.06,'2023-02-15 07:49:55','',''),(101,'1','311','1',1,'Return of Retail Sale Id 94',0.00,7200.00,10.00,0.00,-1270.00,'2023-02-15 08:07:10','',''),(102,'1','311','1',1,'Retail Sale Id 96',7200.00,0.00,0.00,10.00,1270.00,'2023-02-15 10:46:59','',''),(103,'1','311','1',1,'Retail Sale Id 97',7200.00,0.00,0.00,10.00,1270.00,'2023-02-15 12:02:13','',''),(104,'1','311','1',1,'Retail Sale Id 98',3002.40,0.00,0.00,4.17,529.59,'2023-02-15 12:06:18','',''),(105,'1','311','1',1,'Retail Sale Id 99',4996.80,0.00,0.00,6.94,881.38,'2023-02-15 13:13:27','',''),(106,'1','311','1',1,'Return of Retail Sale Id 97',0.00,7200.00,10.00,0.00,-1270.00,'2023-02-15 13:36:04','',''),(107,'1','311','1',1,'Retail Sale Id 100',7200.00,0.00,0.00,10.00,1270.00,'2023-02-15 13:37:20','',''),(108,'1','311','1',1,'Retail Sale Id 101',8640.00,0.00,0.00,12.00,1524.00,'2023-02-15 14:01:58','',''),(109,'1','311','1',1,'Retail Sale Id 102',5040.00,0.00,0.00,7.00,889.00,'2023-02-15 14:15:28','',''),(110,'1','311','1',1,'Retail Sale Id 103',1440.00,0.00,0.00,2.00,254.00,'2023-02-15 14:20:14','',''),(111,'1','311','1',1,'Retail Sale Id 104',4003.20,0.00,0.00,5.56,706.12,'2023-02-15 14:23:04','',''),(112,'1','311','1',1,'Retail Sale Id 105',2901.60,0.00,0.00,4.03,511.81,'2023-02-15 14:24:41','',''),(113,'1','311','1',1,'Retail Sale Id 106',1497.60,0.00,0.00,2.08,264.16,'2023-02-15 14:26:33','',''),(114,'1','311','1',1,'Retail Sale Id 107',7200.00,0.00,0.00,10.00,1270.00,'2023-02-15 14:31:44','',''),(115,'1','311','1',1,'Retail Sale Id 108',1000.80,0.00,0.00,1.39,176.53,'2023-02-15 14:34:33','',''),(116,'1','311','1',1,'Retail Sale Id 109',8640.00,0.00,0.00,12.00,1524.00,'2023-02-15 14:36:33','',''),(117,'1','311','1',1,'Retail Sale Id 110',3600.00,0.00,0.00,5.00,635.00,'2023-02-15 15:14:02','',''),(118,'1','311','1',1,'Retail Sale Id 111',3002.40,0.00,0.00,4.17,529.59,'2023-02-15 15:56:15','',''),(119,'1','311','1',1,'Retail Sale Id 112',1800.00,0.00,0.00,2.50,317.50,'2023-02-15 15:58:14','',''),(120,'1','311','1',1,'Retail Sale Id 113',1440.00,0.00,0.00,2.00,254.00,'2023-02-15 16:06:24','',''),(121,'1','311','1',1,'Retail Sale Id 115',7200.00,0.00,0.00,10.00,1270.00,'2023-02-15 16:45:47','',''),(122,'1','311','1',1,'Retail Sale Id 116',4320.00,0.00,0.00,6.00,762.00,'2023-02-15 16:47:47','',''),(123,'1','311','1',1,'Retail Sale Id 118',5040.00,0.00,0.00,7.00,889.00,'2023-02-15 16:54:36','',''),(124,'1','311','1',1,'Retail Sale Id 120',3600.00,0.00,0.00,5.00,635.00,'2023-02-15 17:00:45','',''),(125,'1','311','1',1,'Retail Sale Id 121',1447.20,0.00,0.00,2.01,255.27,'2023-02-15 17:23:31','',''),(126,'1','311','1',1,'Retail Sale Id 122',1000.80,0.00,0.00,1.39,176.53,'2023-02-15 17:31:44','',''),(127,'1','311','1',1,'Retail Sale Id 123',1000.80,0.00,0.00,1.39,176.53,'2023-02-15 17:34:23','',''),(128,'1','311','1',1,'Retail Sale Id 124',3002.40,0.00,0.00,4.17,529.59,'2023-02-15 18:46:19','',''),(129,'1','311','1',1,'Retail Sale Id 125',3002.40,0.00,0.00,4.17,529.59,'2023-02-16 08:17:35','',''),(130,'1','311','1',1,'Retail Sale Id 126',9000.00,0.00,0.00,12.50,1587.50,'2023-02-16 08:39:32','',''),(131,'1','311','1',1,'Retail Sale Id 127',1497.60,0.00,0.00,2.08,264.16,'2023-02-16 08:46:45','',''),(132,'1','311','1',1,'Retail Sale Id 128',2001.60,0.00,0.00,2.78,353.06,'2023-02-16 08:50:09','',''),(133,'1','311','1',1,'Retail Sale Id 130',1440.00,0.00,0.00,2.00,254.00,'2023-02-16 09:04:28','',''),(134,'1','311','1',1,'Retail Sale Id 132',9000.00,0.00,0.00,12.50,1587.50,'2023-02-16 09:06:15','',''),(135,'1','311','1',1,'Retail Sale Id 133',2167.20,0.00,0.00,3.01,382.27,'2023-02-16 09:32:58','',''),(136,'1','311','1',1,'Retail Sale Id 135',3960.00,0.00,0.00,5.50,698.50,'2023-02-16 09:36:59','',''),(137,'1','311','1',1,'Retail Sale Id 136',3600.00,0.00,0.00,5.00,635.00,'2023-02-16 09:56:27','',''),(138,'1','311','1',1,'Retail Sale Id 138',4320.00,0.00,0.00,6.00,762.00,'2023-02-16 10:50:25','',''),(139,'1','311','1',1,'Retail Sale Id 139',8640.00,0.00,0.00,12.00,1524.00,'2023-02-16 11:09:43','',''),(140,'1','311','1',1,'Retail Sale Id 141',5040.00,0.00,0.00,7.00,889.00,'2023-02-16 11:34:21','',''),(141,'1','311','1',1,'Retail Sale Id 143',1497.60,0.00,0.00,2.08,264.16,'2023-02-16 11:39:05','',''),(142,'1','311','1',1,'Retail Sale Id 144',2160.00,0.00,0.00,3.00,381.00,'2023-02-16 11:44:37','',''),(143,'1','311','1',1,'Retail Sale Id 145',3600.00,0.00,0.00,5.00,635.00,'2023-02-16 12:54:34','',''),(144,'1','311','1',1,'Retail Sale Id 146',5040.00,0.00,0.00,7.00,889.00,'2023-02-16 12:57:37','',''),(145,'1','311','1',1,'Retail Sale Id 147',9000.00,0.00,0.00,12.50,1587.50,'2023-02-16 13:10:30','',''),(146,'1','311','1',1,'Retail Sale Id 148',4003.20,0.00,0.00,5.56,706.12,'2023-02-16 14:29:36','',''),(147,'1','311','1',1,'Retail Sale Id 149',2397.60,0.00,0.00,3.33,422.91,'2023-02-16 14:51:05','',''),(148,'1','311','1',1,'Retail Sale Id 150',8640.00,0.00,0.00,12.00,1524.00,'2023-02-16 14:52:49','',''),(149,'1','311','1',1,'Retail Sale Id 151',4996.80,0.00,0.00,6.94,881.38,'2023-02-16 15:09:54','',''),(150,'1','311','1',1,'Retail Sale Id 153',4320.00,0.00,0.00,6.00,762.00,'2023-02-16 15:35:39','',''),(151,'1','311','1',1,'Retail Sale Id 154',2160.00,0.00,0.00,3.00,381.00,'2023-02-16 16:03:20','',''),(152,'1','311','1',1,'Retail Sale Id 155',3002.40,0.00,0.00,4.17,529.59,'2023-02-16 16:04:49','',''),(153,'1','311','1',1,'Retail Sale Id 157',5040.00,0.00,0.00,7.00,889.00,'2023-02-16 16:18:49','',''),(154,'1','311','1',1,'Retail Sale Id 158',4320.00,0.00,0.00,6.00,762.00,'2023-02-16 16:22:50','',''),(155,'1','311','1',1,'Retail Sale Id 159',2152.80,0.00,0.00,2.99,379.73,'2023-02-16 16:37:27','',''),(156,'1','311','1',1,'Retail Sale Id 160',9000.00,0.00,0.00,12.50,1587.50,'2023-02-16 16:38:32','',''),(157,'1','311','1',1,'Retail Sale Id 161',1000.80,0.00,0.00,1.39,176.53,'2023-02-16 16:40:07','',''),(158,'1','311','1',1,'Retail Sale Id 163',2880.00,0.00,0.00,4.00,508.00,'2023-02-16 16:44:43','',''),(159,'1','311','1',1,'Retail Sale Id 164',3600.00,0.00,0.00,5.00,635.00,'2023-02-16 16:46:50','',''),(160,'1','311','1',1,'Retail Sale Id 165',1440.00,0.00,0.00,2.00,254.00,'2023-02-16 17:13:46','',''),(161,'1','311','1',1,'Retail Sale Id 165',5040.00,0.00,0.00,7.00,889.00,'2023-02-16 17:13:46','',''),(162,'1','311','1',1,'Retail Sale Id 166',2160.00,0.00,0.00,3.00,381.00,'2023-02-16 17:19:17','',''),(163,'1','311','1',1,'Retail Sale Id 167',748.80,0.00,0.00,1.04,132.08,'2023-02-16 17:27:20','',''),(164,'1','311','1',1,'Retail Sale Id 168',1447.20,0.00,0.00,2.01,255.27,'2023-02-16 17:30:33','',''),(165,'1','311','1',1,'Retail Sale Id 169',2160.00,0.00,0.00,3.00,381.00,'2023-02-16 17:53:37','',''),(166,'1','311','1',1,'Retail Sale Id 170',5040.00,0.00,0.00,7.00,889.00,'2023-02-17 08:19:58','',''),(167,'1','311','1',1,'Retail Sale Id 171',7200.00,0.00,0.00,10.00,1270.00,'2023-02-17 09:08:56','',''),(168,'1','311','1',1,'Retail Sale Id 172',9000.00,0.00,0.00,12.50,1587.50,'2023-02-17 09:28:55','',''),(169,'1','311','1',1,'Retail Sale Id 173',8640.00,0.00,0.00,12.00,1524.00,'2023-02-17 10:40:19','',''),(170,'1','311','1',1,'Retail Sale Id 174',5040.00,0.00,0.00,7.00,889.00,'2023-02-17 10:41:17','',''),(171,'1','311','1',1,'Retail Sale Id 175',3960.00,0.00,0.00,5.50,698.50,'2023-02-17 11:06:51','',''),(172,'1','311','1',1,'Retail Sale Id 176',5040.00,0.00,0.00,7.00,889.00,'2023-02-17 11:33:51','',''),(173,'1','311','1',1,'Retail Sale Id 179',2001.60,0.00,0.00,2.78,353.06,'2023-02-17 11:40:09','',''),(174,'1','311','1',1,'Retail Sale Id 179',2001.60,0.00,0.00,2.78,353.06,'2023-02-17 11:40:09','',''),(175,'1','311','1',1,'Retail Sale Id 181',1000.80,0.00,0.00,1.39,176.53,'2023-02-17 12:05:10','',''),(176,'1','311','1',1,'Retail Sale Id 182',4003.20,0.00,0.00,5.56,706.12,'2023-02-17 12:18:07','',''),(177,'1','311','1',1,'Retail Sale Id 183',5040.00,0.00,0.00,7.00,889.00,'2023-02-17 12:22:59','',''),(178,'1','311','1',1,'Retail Sale Id 184',2001.60,0.00,0.00,2.78,353.06,'2023-02-17 12:40:33','',''),(179,'1','311','1',1,'Retail Sale Id 184',2001.60,0.00,0.00,2.78,353.06,'2023-02-17 12:40:33','',''),(180,'1','311','1',1,'Retail Sale Id 185',7200.00,0.00,0.00,10.00,1270.00,'2023-02-17 13:17:34','',''),(181,'1','311','1',1,'Retail Sale Id 186',9000.00,0.00,0.00,12.50,1587.50,'2023-02-17 13:19:26','',''),(182,'1','311','1',1,'Retail Sale Id 187',3600.00,0.00,0.00,5.00,635.00,'2023-02-17 14:08:27','',''),(183,'1','311','1',1,'Retail Sale Id 188',5040.00,0.00,0.00,7.00,889.00,'2023-02-17 14:26:14','',''),(184,'1','311','1',1,'Retail Sale Id 189',2160.00,0.00,0.00,3.00,381.00,'2023-02-17 14:29:40','',''),(185,'1','311','1',1,'Retail Sale Id 191',799.20,0.00,0.00,1.11,140.97,'2023-02-17 14:35:00','',''),(186,'1','311','1',1,'Retail Sale Id 192',3600.00,0.00,0.00,5.00,635.00,'2023-02-17 14:39:07','',''),(187,'1','311','1',1,'Retail Sale Id 195',4320.00,0.00,0.00,6.00,762.00,'2023-02-17 15:24:39','',''),(188,'1','311','1',1,'Retail Sale Id 196',1440.00,0.00,0.00,2.00,254.00,'2023-02-17 16:28:25','',''),(189,'1','311','1',1,'Retail Sale Id 197',2160.00,0.00,0.00,3.00,381.00,'2023-02-17 16:33:02','',''),(190,'1','311','1',1,'Retail Sale Id 198',4320.00,0.00,0.00,6.00,762.00,'2023-02-17 16:35:47','',''),(191,'1','311','1',1,'Retail Sale Id 199',1497.60,0.00,0.00,2.08,264.16,'2023-02-17 16:59:25','',''),(192,'1','311','1',1,'Return of Retail Sale Id 191',0.00,799.20,1.11,0.00,-140.97,'2023-02-17 20:43:47','',''),(193,'1','311','1',1,'Retail Sale Id 202',806.40,0.00,0.00,1.12,142.24,'2023-02-17 20:45:55','',''),(194,'1','311','1',1,'Retail Sale Id 203',1497.60,0.00,0.00,2.08,264.16,'2023-02-18 08:13:18','',''),(195,'1','311','1',1,'Retail Sale Id 205',4320.00,0.00,0.00,6.00,762.00,'2023-02-18 08:28:23','',''),(196,'1','311','1',1,'Retail Sale Id 207',3002.40,0.00,0.00,4.17,529.59,'2023-02-18 09:31:13','',''),(197,'1','311','1',1,'Retail Sale Id 208',5047.20,0.00,0.00,7.01,890.27,'2023-02-18 09:35:13','',''),(198,'1','311','1',1,'Retail Sale Id 209',1000.80,0.00,0.00,1.39,176.53,'2023-02-18 10:06:42','',''),(199,'1','311','1',1,'Retail Sale Id 211',4996.80,0.00,0.00,6.94,881.38,'2023-02-18 10:45:42','',''),(200,'1','311','1',1,'Retail Sale Id 212',1447.20,0.00,0.00,2.01,255.27,'2023-02-18 10:54:27','',''),(201,'1','311','1',1,'Retail Sale Id 213',2001.60,0.00,0.00,2.78,353.06,'2023-02-18 13:37:18','',''),(202,'1','311','1',1,'Retail Sale Id 214',4320.00,0.00,0.00,6.00,762.00,'2023-02-18 13:39:19','',''),(203,'1','311','1',1,'Retail Sale Id 215',9000.00,0.00,0.00,12.50,1587.50,'2023-02-18 13:41:03','',''),(204,'1','311','1',1,'Retail Sale Id 216',2160.00,0.00,0.00,3.00,381.00,'2023-02-18 13:42:14','',''),(205,'1','311','1',1,'Retail Sale Id 217',2001.60,0.00,0.00,2.78,353.06,'2023-02-18 13:43:24','',''),(206,'1','311','1',1,'Retail Sale Id 218',7200.00,0.00,0.00,10.00,1270.00,'2023-02-18 13:45:55','',''),(207,'1','311','1',1,'Retail Sale Id 220',3002.40,0.00,0.00,4.17,529.59,'2023-02-18 14:34:13','',''),(208,'1','311','1',1,'Retail Sale Id 223',720.00,0.00,0.00,1.00,127.00,'2023-02-18 14:53:52','',''),(209,'1','311','1',1,'Return of Retail Sale Id 223',0.00,720.00,1.00,0.00,-127.00,'2023-02-18 14:58:08','',''),(210,'1','311','1',1,'Retail Sale Id 224',720.00,0.00,0.00,1.00,127.00,'2023-02-18 14:59:40','',''),(211,'1','311','1',1,'Retail Sale Id 225',8640.00,0.00,0.00,12.00,1524.00,'2023-02-18 15:14:27','',''),(212,'1','311','1',1,'Retail Sale Id 227',9000.00,0.00,0.00,12.50,1587.50,'2023-02-18 16:26:53','',''),(213,'1','311','1',1,'Retail Sale Id 228',799.20,0.00,0.00,1.11,140.97,'2023-02-18 16:31:22','',''),(214,'1','311','1',1,'Return of Retail Sale Id 208',0.00,5047.20,7.01,0.00,-890.27,'2023-02-18 21:28:19','',''),(215,'1','311','1',1,'Retail Sale Id 229',5047.20,0.00,0.00,7.01,890.27,'2023-02-18 21:30:44','',''),(216,'1','311','1',1,'Return of Retail Sale Id 229',0.00,5047.20,7.01,0.00,-890.27,'2023-02-18 21:32:52','',''),(217,'1','311','1',1,'Retail Sale Id 230',4996.80,0.00,0.00,6.94,881.38,'2023-02-18 21:35:12','',''),(218,'1','311','1',1,'Retail Sale Id 231',3002.40,0.00,0.00,4.17,529.59,'2023-02-19 08:43:09','',''),(219,'1','311','1',1,'Retail Sale Id 232',2160.00,0.00,0.00,3.00,381.00,'2023-02-19 08:45:39','',''),(220,'1','311','1',1,'Retail Sale Id 234',1440.00,0.00,0.00,2.00,254.00,'2023-02-19 08:55:46','',''),(221,'1','311','1',1,'Retail Sale Id 234',1440.00,0.00,0.00,2.00,254.00,'2023-02-19 08:55:46','',''),(222,'1','311','1',1,'Retail Sale Id 235',3600.00,0.00,0.00,5.00,635.00,'2023-02-19 09:04:28','',''),(223,'1','311','1',1,'Retail Sale Id 236',2160.00,0.00,0.00,3.00,381.00,'2023-02-19 09:07:11','',''),(224,'1','311','1',1,'Retail Sale Id 237',2880.00,0.00,0.00,4.00,508.00,'2023-02-19 09:08:52','',''),(225,'1','311','1',1,'Retail Sale Id 239',5040.00,0.00,0.00,7.00,889.00,'2023-02-19 09:19:01','',''),(226,'1','311','1',1,'Retail Sale Id 240',2880.00,0.00,0.00,4.00,508.00,'2023-02-19 09:21:07','',''),(227,'1','311','1',1,'Retail Sale Id 241',9000.00,0.00,0.00,12.50,1587.50,'2023-02-19 09:25:37','',''),(228,'1','311','1',1,'Retail Sale Id 242',2160.00,0.00,0.00,3.00,381.00,'2023-02-19 09:27:35','',''),(229,'1','311','1',1,'Retail Sale Id 243',1440.00,0.00,0.00,2.00,254.00,'2023-02-19 09:31:40','',''),(230,'1','311','1',1,'Retail Sale Id 244',352.80,0.00,0.00,0.49,62.23,'2023-02-19 09:36:08','',''),(231,'1','311','1',1,'Retail Sale Id 245',1440.00,0.00,0.00,2.00,254.00,'2023-02-19 09:37:38','',''),(232,'1','311','1',1,'Retail Sale Id 246',3600.00,0.00,0.00,5.00,635.00,'2023-02-19 09:39:36','',''),(233,'1','311','1',1,'Retail Sale Id 247',2160.00,0.00,0.00,3.00,381.00,'2023-02-19 09:42:00','',''),(234,'1','311','1',1,'Retail Sale Id 249',5040.00,0.00,0.00,7.00,889.00,'2023-02-19 09:53:36','',''),(235,'1','311','1',1,'Retail Sale Id 250',6480.00,0.00,0.00,9.00,1143.00,'2023-02-19 10:34:10','',''),(236,'1','311','1',1,'Retail Sale Id 251',3600.00,0.00,0.00,5.00,635.00,'2023-02-19 10:38:42','',''),(237,'1','311','1',1,'Retail Sale Id 251',4320.00,0.00,0.00,6.00,762.00,'2023-02-19 10:38:42','',''),(238,'1','311','1',1,'Retail Sale Id 252',1440.00,0.00,0.00,2.00,254.00,'2023-02-19 13:01:22','',''),(239,'1','311','1',1,'Retail Sale Id 253',3600.00,0.00,0.00,5.00,635.00,'2023-02-19 13:02:13','',''),(240,'1','311','1',1,'Retail Sale Id 254',7999.20,0.00,0.00,11.11,1410.97,'2023-02-19 13:06:28','',''),(241,'1','311','1',1,'Retail Sale Id 256',4320.00,0.00,0.00,6.00,762.00,'2023-02-19 13:27:28','',''),(242,'1','311','1',1,'Retail Sale Id 257',5040.00,0.00,0.00,7.00,889.00,'2023-02-19 13:56:32','',''),(243,'1','311','1',1,'Retail Sale Id 259',5040.00,0.00,0.00,7.00,889.00,'2023-02-19 14:02:11','',''),(244,'1','311','1',1,'Retail Sale Id 260',4320.00,0.00,0.00,6.00,762.00,'2023-02-19 14:57:02','',''),(245,'1','311','1',1,'Retail Sale Id 261',1440.00,0.00,0.00,2.00,254.00,'2023-02-19 16:06:20','',''),(246,'1','311','1',1,'Retail Sale Id 262',9000.00,0.00,0.00,12.50,1587.50,'2023-02-19 16:26:28','',''),(247,'1','311','1',1,'Retail Sale Id 263',3002.40,0.00,0.00,4.17,529.59,'2023-02-19 17:24:47','',''),(248,'1','311','1',1,'Retail Sale Id 264',720.00,0.00,0.00,1.00,127.00,'2023-02-19 17:27:52','',''),(249,'1','311','1',1,'Retail Sale Id 265',1440.00,0.00,0.00,2.00,254.00,'2023-02-19 17:40:08','',''),(250,'1','311','1',1,'Retail Sale Id 267',2880.00,0.00,0.00,4.00,508.00,'2023-02-19 17:46:16','',''),(251,'1','311','1',1,'Retail Sale Id 268',2001.60,0.00,0.00,2.78,353.06,'2023-02-19 17:47:37','',''),(252,'1','311','1',1,'Retail Sale Id 269',1000.80,0.00,0.00,1.39,176.53,'2023-02-19 17:49:04','',''),(253,'1','311','1',1,'Retail Sale Id 270',1497.60,0.00,0.00,2.08,264.16,'2023-02-19 17:50:25','',''),(254,'1','311','1',1,'Retail Sale Id 271',8812.80,0.00,0.00,12.24,1554.48,'2023-02-19 20:03:07','',''),(255,'1','311','1',1,'Retail Sale Id 272',9259.20,0.00,0.00,12.86,1633.22,'2023-02-19 20:05:33','',''),(256,'1','311','1',1,'Retail Sale Id 273',10800.00,0.00,0.00,15.00,1905.00,'2023-02-19 20:06:31','',''),(257,'1','311','1',1,'Retail Sale Id 275',14997.60,0.00,0.00,20.83,2645.41,'2023-02-19 20:09:44','',''),(258,'1','311','1',1,'Retail Sale Id 276',14997.60,0.00,0.00,20.83,2645.41,'2023-02-19 20:10:22','',''),(259,'1','311','1',1,'Retail Sale Id 277',14997.60,0.00,0.00,20.83,2645.41,'2023-02-19 20:10:55','',''),(260,'1','311','1',1,'Retail Sale Id 278',14997.60,0.00,0.00,20.83,2645.41,'2023-02-19 20:11:33','',''),(261,'1','311','1',1,'Return of Retail Sale Id 278',0.00,14997.60,20.83,0.00,-2645.41,'2023-02-19 20:15:25','',''),(262,'1','311','1',1,'Return of Retail Sale Id 277',0.00,14997.60,20.83,0.00,-2645.41,'2023-02-19 20:16:30','',''),(263,'1','311','1',1,'Return of Retail Sale Id 269',0.00,1000.80,1.39,0.00,-176.53,'2023-02-19 20:18:21','',''),(264,'1','311','1',1,'Retail Sale Id 279',1180.80,0.00,0.00,1.64,208.28,'2023-02-19 20:19:19','',''),(265,'1','311','1',1,'Return of Retail Sale Id 261',0.00,1440.00,2.00,0.00,-254.00,'2023-02-19 20:22:08','',''),(266,'1','311','1',1,'Retail Sale Id 280',1080.00,0.00,0.00,1.50,190.50,'2023-02-19 20:23:36','',''),(267,'1','311','1',1,'Retail Sale Id 281',2584.80,0.00,0.00,3.59,455.93,'2023-02-19 20:25:39','',''),(268,'1','311','1',1,'Retail Sale Id 282',2498.40,0.00,0.00,3.47,440.69,'2023-02-21 08:25:43','',''),(269,'1','311','1',1,'Retail Sale Id 283',4320.00,0.00,0.00,6.00,762.00,'2023-02-21 08:31:54','',''),(270,'1','311','1',1,'Retail Sale Id 284',3600.00,0.00,0.00,5.00,635.00,'2023-02-21 08:34:17','',''),(271,'1','311','1',1,'Retail Sale Id 285',7200.00,0.00,0.00,10.00,1270.00,'2023-02-21 08:35:21','',''),(272,'1','311','1',1,'Retail Sale Id 289',1440.00,0.00,0.00,2.00,254.00,'2023-02-21 08:39:56','',''),(273,'1','311','1',1,'Retail Sale Id 290',2160.00,0.00,0.00,3.00,381.00,'2023-02-21 09:02:08','',''),(274,'1','311','1',1,'Retail Sale Id 292',1000.80,0.00,0.00,1.39,176.53,'2023-02-21 09:31:03','',''),(275,'1','311','1',1,'Retail Sale Id 294',1598.40,0.00,0.00,2.22,281.94,'2023-02-21 11:00:26','',''),(276,'1','311','1',1,'Retail Sale Id 295',2001.60,0.00,0.00,2.78,353.06,'2023-02-21 11:02:25','',''),(277,'1','311','1',1,'Retail Sale Id 296',1396.80,0.00,0.00,1.94,246.38,'2023-02-21 11:04:15','',''),(278,'1','311','1',1,'Retail Sale Id 297',9000.00,0.00,0.00,12.50,1587.50,'2023-02-21 11:07:01','',''),(279,'1','311','1',1,'Retail Sale Id 298',2001.60,0.00,0.00,2.78,353.06,'2023-02-21 11:08:36','',''),(280,'1','311','1',1,'Retail Sale Id 299',5040.00,0.00,0.00,7.00,889.00,'2023-02-21 11:10:47','',''),(281,'1','311','1',1,'Retail Sale Id 299',8640.00,0.00,0.00,12.00,1524.00,'2023-02-21 11:10:47','',''),(282,'1','311','1',1,'Retail Sale Id 300',4996.80,0.00,0.00,6.94,881.38,'2023-02-21 11:12:30','',''),(283,'1','311','1',1,'Return of Retail Sale Id 298',0.00,2001.60,2.78,0.00,-353.06,'2023-02-21 11:24:12','',''),(284,'1','311','1',1,'Retail Sale Id 301',2001.60,0.00,0.00,2.78,353.06,'2023-02-21 11:25:37','',''),(285,'1','311','1',1,'Retail Sale Id 303',2880.00,0.00,0.00,4.00,508.00,'2023-02-21 12:45:42','',''),(286,'1','311','1',1,'Retail Sale Id 304',2160.00,0.00,0.00,3.00,381.00,'2023-02-21 12:48:32','',''),(287,'1','311','1',1,'Retail Sale Id 305',3196.80,0.00,0.00,4.44,563.88,'2023-02-21 12:50:15','',''),(288,'1','311','1',1,'Retail Sale Id 306',2001.60,0.00,0.00,2.78,353.06,'2023-02-21 12:51:50','',''),(289,'1','311','1',1,'Retail Sale Id 307',5040.00,0.00,0.00,7.00,889.00,'2023-02-21 12:54:13','',''),(290,'1','311','1',1,'Retail Sale Id 309',2800.80,0.00,0.00,3.89,494.03,'2023-02-21 12:56:19','',''),(291,'1','311','1',1,'Retail Sale Id 312',3002.40,0.00,0.00,4.17,529.59,'2023-02-21 13:24:27','',''),(292,'1','311','1',1,'Retail Sale Id 313',3002.40,0.00,0.00,4.17,529.59,'2023-02-21 13:29:14','',''),(293,'1','311','1',1,'Retail Sale Id 314',2203.20,0.00,0.00,3.06,388.62,'2023-02-21 13:31:03','',''),(294,'1','311','1',1,'Retail Sale Id 316',5040.00,0.00,0.00,7.00,889.00,'2023-02-21 13:32:35','',''),(295,'1','311','1',1,'Retail Sale Id 318',2203.20,0.00,0.00,3.06,388.62,'2023-02-21 13:34:02','',''),(296,'1','311','1',1,'Retail Sale Id 321',3002.40,0.00,0.00,4.17,529.59,'2023-02-21 13:56:45','',''),(297,'1','311','1',1,'Retail Sale Id 321',4003.20,0.00,0.00,5.56,706.12,'2023-02-21 13:56:45','',''),(298,'1','311','1',1,'Retail Sale Id 322',2001.60,0.00,0.00,2.78,353.06,'2023-02-21 14:57:32','',''),(299,'1','311','1',1,'Retail Sale Id 323',7200.00,0.00,0.00,10.00,1270.00,'2023-02-21 14:59:23','',''),(300,'1','311','1',1,'Retail Sale Id 324',2880.00,0.00,0.00,4.00,508.00,'2023-02-21 15:00:57','',''),(301,'1','311','1',1,'Retail Sale Id 325',3600.00,0.00,0.00,5.00,635.00,'2023-02-21 15:02:03','',''),(302,'1','311','1',1,'Retail Sale Id 326',1447.20,0.00,0.00,2.01,255.27,'2023-02-21 15:03:55','',''),(303,'1','311','1',1,'Retail Sale Id 327',2160.00,0.00,0.00,3.00,381.00,'2023-02-21 15:05:15','',''),(304,'1','311','1',1,'Retail Sale Id 328',3600.00,0.00,0.00,5.00,635.00,'2023-02-21 15:09:12','',''),(305,'1','311','1',1,'Retail Sale Id 330',2160.00,0.00,0.00,3.00,381.00,'2023-02-21 15:24:06','',''),(306,'1','311','1',1,'Retail Sale Id 331',5040.00,0.00,0.00,7.00,889.00,'2023-02-21 15:35:57','',''),(307,'1','311','1',1,'Retail Sale Id 332',2160.00,0.00,0.00,3.00,381.00,'2023-02-21 15:37:19','',''),(308,'1','311','1',1,'Retail Sale Id 333',5040.00,0.00,0.00,7.00,889.00,'2023-02-21 15:58:39','',''),(309,'1','311','1',1,'Retail Sale Id 335',4327.20,0.00,0.00,6.01,763.27,'2023-02-21 16:17:45','',''),(310,'1','311','1',1,'Retail Sale Id 336',5040.00,0.00,0.00,7.00,889.00,'2023-02-21 16:19:54','',''),(311,'1','311','1',1,'Retail Sale Id 338',5040.00,0.00,0.00,7.00,889.00,'2023-02-21 16:36:35','',''),(312,'1','311','1',1,'Retail Sale Id 338',7200.00,0.00,0.00,10.00,1270.00,'2023-02-21 16:36:35','',''),(313,'1','311','1',1,'Retail Sale Id 342',3002.40,0.00,0.00,4.17,529.59,'2023-02-21 16:55:58','',''),(314,'1','311','1',1,'Retail Sale Id 342',3002.40,0.00,0.00,4.17,529.59,'2023-02-21 16:55:58','',''),(315,'1','311','1',1,'Retail Sale Id 343',1447.20,0.00,0.00,2.01,255.27,'2023-02-21 17:15:59','',''),(316,'1','311','1',1,'Retail Sale Id 344',2001.60,0.00,0.00,2.78,353.06,'2023-02-21 17:17:08','',''),(317,'1','311','1',1,'Retail Sale Id 345',1440.00,0.00,0.00,2.00,254.00,'2023-02-21 17:26:18','',''),(318,'1','311','1',1,'Retail Sale Id 346',2160.00,0.00,0.00,3.00,381.00,'2023-02-21 17:28:03','',''),(319,'1','311','1',1,'Retail Sale Id 347',4320.00,0.00,0.00,6.00,762.00,'2023-02-21 17:29:43','',''),(320,'1','311','1',1,'Retail Sale Id 349',4996.80,0.00,0.00,6.94,881.38,'2023-02-21 17:35:44','',''),(321,'1','311','1',1,'Retail Sale Id 350',1447.20,0.00,0.00,2.01,255.27,'2023-02-21 17:41:20','',''),(322,'1','311','1',1,'Retail Sale Id 351',9000.00,0.00,0.00,12.50,1587.50,'2023-02-21 17:52:44','',''),(323,'1','311','1',1,'Retail Sale Id 352',3002.40,0.00,0.00,4.17,529.59,'2023-02-21 17:58:47','',''),(324,'1','311','1',1,'Return of Retail Sale Id 342',0.00,3002.40,4.17,0.00,-529.59,'2023-02-21 22:51:19','',''),(325,'1','311','1',1,'Return of Retail Sale Id 342',0.00,3002.40,4.17,0.00,-529.59,'2023-02-21 22:51:19','',''),(326,'1','311','1',1,'Return of Retail Sale Id 335',0.00,4327.20,6.01,0.00,-763.27,'2023-02-21 22:56:27','',''),(327,'1','311','1',1,'Return of Retail Sale Id 333',0.00,5040.00,7.00,0.00,-889.00,'2023-02-21 22:58:09','',''),(328,'1','311','1',1,'Retail Sale Id 353',1684.80,0.00,0.00,2.34,297.18,'2023-02-21 23:00:13','',''),(329,'1','311','1',1,'Retail Sale Id 354',4327.20,0.00,0.00,6.01,763.27,'2023-02-21 23:06:31','',''),(330,'1','311','1',1,'Retail Sale Id 355',5997.60,0.00,0.00,8.33,1057.91,'2023-02-21 23:11:40','',''),(331,'1','311','1',1,'Retail Sale Id 356',7200.00,0.00,0.00,10.00,1270.00,'2023-02-21 23:15:17','',''),(332,'1','311','1',1,'Retail Sale Id 358',3081.60,0.00,0.00,4.28,543.56,'2023-02-21 23:17:55','',''),(333,'1','311','1',1,'Retail Sale Id 359',2692.80,0.00,0.00,3.74,474.98,'2023-02-21 23:19:27','',''),(334,'1','311','1',1,'Retail Sale Id 360',2203.20,0.00,0.00,3.06,388.62,'2023-02-22 08:14:09','',''),(335,'1','311','1',1,'Retail Sale Id 361',2880.00,0.00,0.00,4.00,508.00,'2023-02-22 08:19:00','',''),(336,'1','311','1',1,'Retail Sale Id 362',5040.00,0.00,0.00,7.00,889.00,'2023-02-22 08:21:15','',''),(337,'1','311','1',1,'Retail Sale Id 362',5040.00,0.00,0.00,7.00,889.00,'2023-02-22 08:21:15','',''),(338,'1','311','1',1,'Retail Sale Id 363',1440.00,0.00,0.00,2.00,254.00,'2023-02-22 08:36:32','',''),(339,'1','311','1',1,'Retail Sale Id 364',7200.00,0.00,0.00,10.00,1270.00,'2023-02-22 08:47:31','',''),(340,'1','311','1',1,'Retail Sale Id 365',3002.40,0.00,0.00,4.17,529.59,'2023-02-22 09:00:10','',''),(341,'1','311','1',1,'Retail Sale Id 366',3002.40,0.00,0.00,4.17,529.59,'2023-02-22 09:02:03','',''),(342,'1','311','1',1,'Retail Sale Id 367',2160.00,0.00,0.00,3.00,381.00,'2023-02-22 09:07:25','',''),(343,'1','311','1',1,'Retail Sale Id 369',3600.00,0.00,0.00,5.00,635.00,'2023-02-22 09:15:34','',''),(344,'1','311','1',1,'Retail Sale Id 370',2160.00,0.00,0.00,3.00,381.00,'2023-02-22 09:29:49','',''),(345,'1','311','1',1,'Retail Sale Id 371',3002.40,0.00,0.00,4.17,529.59,'2023-02-22 09:46:03','',''),(346,'1','311','1',1,'Retail Sale Id 372',2160.00,0.00,0.00,3.00,381.00,'2023-02-22 09:48:28','',''),(347,'1','311','1',1,'Retail Sale Id 373',3600.00,0.00,0.00,5.00,635.00,'2023-02-22 09:50:31','',''),(348,'1','311','1',1,'Retail Sale Id 374',9000.00,0.00,0.00,12.50,1587.50,'2023-02-22 09:53:58','',''),(349,'1','311','1',1,'Retail Sale Id 376',2152.80,0.00,0.00,2.99,379.73,'2023-02-22 10:00:14','',''),(350,'1','311','1',1,'Retail Sale Id 377',3600.00,0.00,0.00,5.00,635.00,'2023-02-22 10:08:44','',''),(351,'1','311','1',1,'Retail Sale Id 378',3600.00,0.00,0.00,5.00,635.00,'2023-02-22 10:12:00','',''),(352,'1','311','1',1,'Retail Sale Id 379',2203.20,0.00,0.00,3.06,388.62,'2023-02-22 10:20:54','',''),(353,'1','311','1',1,'Retail Sale Id 380',5040.00,0.00,0.00,7.00,889.00,'2023-02-22 10:23:15','',''),(354,'1','311','1',1,'Retail Sale Id 382',4320.00,0.00,0.00,6.00,762.00,'2023-02-22 10:26:41','',''),(355,'1','311','1',1,'Retail Sale Id 383',5040.00,0.00,0.00,7.00,889.00,'2023-02-22 10:28:20','',''),(356,'1','311','1',1,'Retail Sale Id 384',9000.00,0.00,0.00,12.50,1587.50,'2023-02-22 10:29:26','',''),(357,'1','311','1',1,'Retail Sale Id 386',3600.00,0.00,0.00,5.00,635.00,'2023-02-22 10:41:21','',''),(358,'1','311','1',1,'Retail Sale Id 389',748.80,0.00,0.00,1.04,132.08,'2023-02-22 11:05:27','',''),(359,'1','311','1',1,'Retail Sale Id 392',9000.00,0.00,0.00,12.50,1587.50,'2023-02-22 11:23:45','',''),(360,'1','311','1',1,'Retail Sale Id 393',2901.60,0.00,0.00,4.03,511.81,'2023-02-22 11:38:35','',''),(361,'1','311','1',1,'Retail Sale Id 395',2001.60,0.00,0.00,2.78,353.06,'2023-02-22 11:44:18','',''),(362,'1','311','1',1,'Retail Sale Id 396',1497.60,0.00,0.00,2.08,264.16,'2023-02-22 12:05:50','',''),(363,'1','311','1',1,'Retail Sale Id 397',2001.60,0.00,0.00,2.78,353.06,'2023-02-22 12:22:01','',''),(364,'1','311','1',1,'Return of Retail Sale Id 397',0.00,2001.60,2.78,0.00,-353.06,'2023-02-22 12:29:00','',''),(365,'1','311','1',1,'Retail Sale Id 399',3600.00,0.00,0.00,5.00,635.00,'2023-02-22 12:58:10','',''),(366,'1','311','1',1,'Retail Sale Id 400',7200.00,0.00,0.00,10.00,1270.00,'2023-02-22 13:25:54','',''),(367,'1','311','1',1,'Retail Sale Id 402',2001.60,0.00,0.00,2.78,353.06,'2023-02-22 13:28:55','',''),(368,'1','311','1',1,'Retail Sale Id 403',3600.00,0.00,0.00,5.00,635.00,'2023-02-22 13:30:24','',''),(369,'1','311','1',1,'Retail Sale Id 404',2880.00,0.00,0.00,4.00,508.00,'2023-02-22 14:19:03','',''),(370,'1','311','1',1,'Retail Sale Id 405',5040.00,0.00,0.00,7.00,889.00,'2023-02-22 15:11:41','',''),(371,'1','311','1',1,'Return of Retail Sale Id 405',0.00,5040.00,7.00,0.00,-889.00,'2023-02-22 15:22:58','',''),(372,'1','311','1',1,'Retail Sale Id 407',4788.00,0.00,0.00,6.65,844.55,'2023-02-22 15:25:10','',''),(373,'1','311','1',1,'Retail Sale Id 408',7200.00,0.00,0.00,10.00,1270.00,'2023-02-22 15:28:12','',''),(374,'1','311','1',1,'Retail Sale Id 409',9000.00,0.00,0.00,12.50,1587.50,'2023-02-22 15:50:09','',''),(375,'1','311','1',1,'Retail Sale Id 410',9000.00,0.00,0.00,12.50,1587.50,'2023-02-22 15:52:14','',''),(376,'1','311','1',1,'Retail Sale Id 411',1440.00,0.00,0.00,2.00,254.00,'2023-02-22 15:55:14','',''),(377,'1','311','1',1,'Retail Sale Id 412',5760.00,0.00,0.00,8.00,1016.00,'2023-02-22 16:00:31','',''),(378,'1','311','1',1,'Retail Sale Id 413',2160.00,0.00,0.00,3.00,381.00,'2023-02-22 16:02:55','',''),(379,'1','311','1',1,'Retail Sale Id 416',3600.00,0.00,0.00,5.00,635.00,'2023-02-22 16:05:49','',''),(380,'1','311','1',1,'Retail Sale Id 417',1447.20,0.00,0.00,2.01,255.27,'2023-02-22 16:08:16','',''),(381,'1','311','1',1,'Return of Retail Sale Id 416',0.00,3600.00,5.00,0.00,-635.00,'2023-02-22 16:09:31','',''),(382,'1','311','1',1,'Retail Sale Id 418',3600.00,0.00,0.00,5.00,635.00,'2023-02-22 16:10:15','',''),(383,'1','311','1',1,'Retail Sale Id 420',2160.00,0.00,0.00,3.00,381.00,'2023-02-22 16:26:05','',''),(384,'1','311','1',1,'Retail Sale Id 422',2700.00,0.00,0.00,3.75,476.25,'2023-02-22 16:53:41','',''),(385,'1','311','1',1,'Retail Sale Id 423',1447.20,0.00,0.00,2.01,255.27,'2023-02-22 16:54:43','',''),(386,'1','311','1',1,'Retail Sale Id 424',2880.00,0.00,0.00,4.00,508.00,'2023-02-22 16:59:06','',''),(387,'1','311','1',1,'Retail Sale Id 426',2880.00,0.00,0.00,4.00,508.00,'2023-02-22 17:03:30','',''),(388,'1','311','1',1,'Retail Sale Id 427',2880.00,0.00,0.00,4.00,508.00,'2023-02-22 17:24:22','',''),(389,'1','311','1',1,'Retail Sale Id 428',5040.00,0.00,0.00,7.00,889.00,'2023-02-22 17:30:01','',''),(390,'1','311','1',1,'Retail Sale Id 431',4996.80,0.00,0.00,6.94,881.38,'2023-02-22 17:44:59','',''),(391,'1','311','1',1,'Retail Sale Id 432',1447.20,0.00,0.00,2.01,255.27,'2023-02-22 17:45:58','',''),(392,'1','311','1',1,'Return of Retail Sale Id 422',0.00,2700.00,3.75,0.00,-476.25,'2023-02-22 18:12:20','',''),(393,'1','311','1',1,'Retail Sale Id 433',2707.20,0.00,0.00,3.76,477.52,'2023-02-22 18:13:03','',''),(394,'1','311','1',1,'Retail Sale Id 434',9000.00,0.00,0.00,12.50,1587.50,'2023-02-23 08:14:09','',''),(395,'1','311','1',1,'Retail Sale Id 435',5040.00,0.00,0.00,7.00,889.00,'2023-02-23 08:15:32','',''),(396,'1','311','1',1,'Retail Sale Id 436',2880.00,0.00,0.00,4.00,508.00,'2023-02-23 08:57:23','',''),(397,'1','311','1',1,'Retail Sale Id 437',4320.00,0.00,0.00,6.00,762.00,'2023-02-23 09:11:25','',''),(398,'1','311','1',1,'Retail Sale Id 438',2880.00,0.00,0.00,4.00,508.00,'2023-02-23 09:21:04','',''),(399,'1','311','1',1,'Retail Sale Id 439',9000.00,0.00,0.00,12.50,1587.50,'2023-02-23 09:24:01','',''),(400,'1','311','1',1,'Retail Sale Id 440',3600.00,0.00,0.00,5.00,635.00,'2023-02-23 09:25:01','',''),(401,'1','311','1',1,'Retail Sale Id 441',9000.00,0.00,0.00,12.50,1587.50,'2023-02-23 09:36:04','',''),(402,'1','311','1',1,'Retail Sale Id 442',1440.00,0.00,0.00,2.00,254.00,'2023-02-23 09:37:52','',''),(403,'1','311','1',1,'Retail Sale Id 443',3002.40,0.00,0.00,4.17,529.59,'2023-02-23 10:01:06','',''),(404,'1','311','1',1,'Retail Sale Id 444',3600.00,0.00,0.00,5.00,635.00,'2023-02-23 10:01:51','',''),(405,'1','311','1',1,'Retail Sale Id 445',2880.00,0.00,0.00,4.00,508.00,'2023-02-23 10:03:30','',''),(406,'1','311','1',1,'Retail Sale Id 446',3600.00,0.00,0.00,5.00,635.00,'2023-02-23 10:30:05','',''),(407,'1','311','1',1,'Retail Sale Id 446',3600.00,0.00,0.00,5.00,635.00,'2023-02-23 10:30:05','',''),(408,'1','311','1',1,'Retail Sale Id 448',9000.00,0.00,0.00,12.50,1587.50,'2023-02-23 10:48:19','',''),(409,'1','311','1',1,'Retail Sale Id 449',3600.00,0.00,0.00,5.00,635.00,'2023-02-23 10:57:17','',''),(410,'1','311','1',1,'Retail Sale Id 450',3600.00,0.00,0.00,5.00,635.00,'2023-02-23 11:05:20','',''),(411,'1','311','1',1,'Retail Sale Id 451',7200.00,0.00,0.00,10.00,1270.00,'2023-02-23 11:43:46','',''),(412,'1','311','1',1,'Retail Sale Id 452',2001.60,0.00,0.00,2.78,353.06,'2023-02-23 11:53:13','',''),(413,'1','311','1',1,'Retail Sale Id 453',1440.00,0.00,0.00,2.00,254.00,'2023-02-23 12:27:35','',''),(414,'1','311','1',1,'Retail Sale Id 454',1440.00,0.00,0.00,2.00,254.00,'2023-02-23 12:36:48','',''),(415,'1','311','1',1,'Retail Sale Id 455',2160.00,0.00,0.00,3.00,381.00,'2023-02-23 12:38:12','',''),(416,'1','311','1',1,'Retail Sale Id 456',3600.00,0.00,0.00,5.00,635.00,'2023-02-23 12:39:58','',''),(417,'1','311','1',1,'Retail Sale Id 457',9000.00,0.00,0.00,12.50,1587.50,'2023-02-23 12:41:17','',''),(418,'1','311','1',1,'Retail Sale Id 458',3600.00,0.00,0.00,5.00,635.00,'2023-02-23 12:45:57','',''),(419,'1','311','1',1,'Retail Sale Id 459',3600.00,0.00,0.00,5.00,635.00,'2023-02-23 13:26:31','',''),(420,'1','311','1',1,'Retail Sale Id 460',3600.00,0.00,0.00,5.00,635.00,'2023-02-23 13:27:56','',''),(421,'1','311','1',1,'Retail Sale Id 461',1000.80,0.00,0.00,1.39,176.53,'2023-02-23 13:40:10','',''),(422,'1','311','1',1,'Retail Sale Id 462',3600.00,0.00,0.00,5.00,635.00,'2023-02-23 13:51:34','',''),(423,'1','311','1',1,'Retail Sale Id 463',4320.00,0.00,0.00,6.00,762.00,'2023-02-23 13:54:40','',''),(424,'1','311','1',1,'Retail Sale Id 464',2880.00,0.00,0.00,4.00,508.00,'2023-02-23 14:05:29','',''),(425,'1','311','1',1,'Retail Sale Id 465',1440.00,0.00,0.00,2.00,254.00,'2023-02-23 14:07:09','',''),(426,'1','311','1',1,'Retail Sale Id 466',2880.00,0.00,0.00,4.00,508.00,'2023-02-23 14:09:37','',''),(427,'1','311','1',1,'Retail Sale Id 467',720.00,0.00,0.00,1.00,127.00,'2023-02-23 14:19:46','',''),(428,'1','311','1',1,'Retail Sale Id 468',1440.00,0.00,0.00,2.00,254.00,'2023-02-23 14:47:11','',''),(429,'1','311','1',1,'Retail Sale Id 469',2160.00,0.00,0.00,3.00,381.00,'2023-02-23 14:49:07','',''),(430,'1','311','1',1,'Retail Sale Id 470',2001.60,0.00,0.00,2.78,353.06,'2023-02-23 15:17:41','',''),(431,'1','311','1',1,'Retail Sale Id 470',2498.40,0.00,0.00,3.47,440.69,'2023-02-23 15:17:41','',''),(432,'1','311','1',1,'Retail Sale Id 471',7200.00,0.00,0.00,10.00,1270.00,'2023-02-23 15:27:06','',''),(433,'1','311','1',1,'Retail Sale Id 472',1440.00,0.00,0.00,2.00,254.00,'2023-02-23 15:33:41','',''),(434,'1','311','1',1,'Retail Sale Id 473',2520.00,0.00,0.00,3.50,444.50,'2023-02-23 15:46:01','',''),(435,'1','311','1',1,'Retail Sale Id 475',5760.00,0.00,0.00,8.00,1016.00,'2023-02-23 15:50:40','',''),(436,'1','311','1',1,'Retail Sale Id 478',4320.00,0.00,0.00,6.00,762.00,'2023-02-23 16:20:59','',''),(437,'1','311','1',1,'Retail Sale Id 478',7200.00,0.00,0.00,10.00,1270.00,'2023-02-23 16:21:00','',''),(438,'1','311','1',1,'Retail Sale Id 479',2880.00,0.00,0.00,4.00,508.00,'2023-02-23 16:22:26','',''),(439,'1','311','1',1,'Retail Sale Id 480',1440.00,0.00,0.00,2.00,254.00,'2023-02-23 16:28:20','',''),(440,'1','311','1',1,'Return of Retail Sale Id 480',0.00,1440.00,2.00,0.00,-254.00,'2023-02-23 16:31:50','',''),(441,'1','311','1',1,'Retail Sale Id 481',1497.60,0.00,0.00,2.08,264.16,'2023-02-23 16:32:43','',''),(442,'1','311','1',1,'Retail Sale Id 482',2160.00,0.00,0.00,3.00,381.00,'2023-02-23 16:35:17','',''),(443,'1','311','1',1,'Retail Sale Id 485',3600.00,0.00,0.00,5.00,635.00,'2023-02-23 16:42:05','',''),(444,'1','311','1',1,'Retail Sale Id 486',2880.00,0.00,0.00,4.00,508.00,'2023-02-23 16:44:49','',''),(445,'1','311','1',1,'Retail Sale Id 488',3600.00,0.00,0.00,5.00,635.00,'2023-02-23 16:47:16','',''),(446,'1','311','1',1,'Retail Sale Id 489',1497.60,0.00,0.00,2.08,264.16,'2023-02-23 16:50:41','',''),(447,'1','311','1',1,'Retail Sale Id 491',2880.00,0.00,0.00,4.00,508.00,'2023-02-23 16:59:20','',''),(448,'1','311','1',1,'Retail Sale Id 492',9000.00,0.00,0.00,12.50,1587.50,'2023-02-23 17:03:28','',''),(449,'1','311','1',1,'Retail Sale Id 493',2160.00,0.00,0.00,3.00,381.00,'2023-02-23 17:16:56','',''),(450,'1','311','1',1,'Retail Sale Id 494',3600.00,0.00,0.00,5.00,635.00,'2023-02-23 17:29:11','',''),(451,'1','311','1',1,'Retail Sale Id 495',1000.80,0.00,0.00,1.39,176.53,'2023-02-23 17:38:04','',''),(452,'1','311','1',1,'Retail Sale Id 496',1447.20,0.00,0.00,2.01,255.27,'2023-02-23 17:39:30','',''),(453,'1','311','1',1,'Retail Sale Id 497',1440.00,0.00,0.00,2.00,254.00,'2023-02-23 17:40:48','',''),(454,'1','311','1',1,'Retail Sale Id 498',1447.20,0.00,0.00,2.01,255.27,'2023-02-23 17:42:13','',''),(455,'1','311','1',1,'Return of Retail Sale Id 495',0.00,1000.80,1.39,0.00,-176.53,'2023-02-23 17:46:46','',''),(456,'1','311','1',1,'Retail Sale Id 499',2160.00,0.00,0.00,3.00,381.00,'2023-02-23 17:52:44','',''),(457,'1','311','1',1,'Retail Sale Id 500',2880.00,0.00,0.00,4.00,508.00,'2023-02-23 18:18:33','',''),(458,'1','311','1',1,'Retail Sale Id 501',81600.00,0.00,0.00,120.00,10440.00,'2023-02-23 18:31:17','',''),(459,'1','311','1',1,'Return of Retail Sale Id 492',0.00,9000.00,12.50,0.00,-1587.50,'2023-02-23 20:06:55','',''),(460,'1','311','1',1,'Retail Sale Id 502',3304.80,0.00,0.00,4.59,582.93,'2023-02-23 20:08:28','',''),(461,'1','311','1',1,'Retail Sale Id 503',5695.20,0.00,0.00,7.91,1004.57,'2023-02-23 20:09:57','',''),(462,'1','311','1',1,'Return of Retail Sale Id 503',0.00,5695.20,7.91,0.00,-1004.57,'2023-02-23 20:11:05','',''),(463,'1','311','1',1,'Retail Sale Id 504',5752.80,0.00,0.00,7.99,1014.73,'2023-02-23 20:11:49','',''),(464,'1','311','1',1,'Retail Sale Id 507',5047.20,0.00,0.00,7.01,890.27,'2023-02-28 08:14:36','',''),(465,'1','311','1',1,'Retail Sale Id 508',2001.60,0.00,0.00,2.78,353.06,'2023-02-28 08:15:44','',''),(466,'1','311','1',1,'Retail Sale Id 509',1699.20,0.00,0.00,2.36,299.72,'2023-02-28 08:16:59','',''),(467,'1','311','1',1,'Retail Sale Id 510',2160.00,0.00,0.00,3.00,381.00,'2023-02-28 08:17:52','',''),(468,'1','311','1',1,'Retail Sale Id 511',1000.80,0.00,0.00,1.39,176.53,'2023-02-28 08:18:47','',''),(469,'1','311','1',1,'Retail Sale Id 512',2203.20,0.00,0.00,3.06,388.62,'2023-02-28 08:19:48','',''),(470,'1','311','1',1,'Retail Sale Id 513',2901.60,0.00,0.00,4.03,511.81,'2023-02-28 08:21:24','',''),(471,'1','311','1',1,'Retail Sale Id 514',900.00,0.00,0.00,1.25,158.75,'2023-02-28 08:22:35','',''),(472,'1','311','1',1,'Retail Sale Id 515',2880.00,0.00,0.00,4.00,508.00,'2023-02-28 08:24:09','',''),(473,'1','311','1',1,'Return of Retail Sale Id 514',0.00,900.00,1.25,0.00,-158.75,'2023-02-28 08:44:10','',''),(474,'1','311','1',1,'Retail Sale Id 517',4320.00,0.00,0.00,6.00,762.00,'2023-02-28 08:47:40','',''),(475,'1','311','1',1,'Retail Sale Id 518',2880.00,0.00,0.00,4.00,508.00,'2023-02-28 08:50:59','',''),(476,'1','311','1',1,'Retail Sale Id 519',1000.80,0.00,0.00,1.39,176.53,'2023-02-28 08:52:12','',''),(477,'1','311','1',1,'Retail Sale Id 521',3002.40,0.00,0.00,4.17,529.59,'2023-02-28 08:54:31','',''),(478,'1','311','1',1,'Retail Sale Id 522',1440.00,0.00,0.00,2.00,254.00,'2023-02-28 08:55:38','',''),(479,'1','311','1',1,'Retail Sale Id 523',4320.00,0.00,0.00,6.00,762.00,'2023-02-28 08:58:01','',''),(480,'1','311','1',1,'Retail Sale Id 524',2880.00,0.00,0.00,4.00,508.00,'2023-02-28 09:05:01','',''),(481,'1','311','1',1,'Retail Sale Id 525',3600.00,0.00,0.00,5.00,635.00,'2023-02-28 09:07:14','',''),(482,'1','311','1',1,'Retail Sale Id 526',9000.00,0.00,0.00,12.50,1587.50,'2023-02-28 09:15:44','',''),(483,'1','311','1',1,'Retail Sale Id 527',2160.00,0.00,0.00,3.00,381.00,'2023-02-28 09:17:41','',''),(484,'1','311','1',1,'Retail Sale Id 527',9000.00,0.00,0.00,12.50,1587.50,'2023-02-28 09:17:41','',''),(485,'1','311','1',1,'Retail Sale Id 528',2001.60,0.00,0.00,2.78,353.06,'2023-02-28 09:20:03','',''),(486,'1','311','1',1,'Retail Sale Id 529',9000.00,0.00,0.00,12.50,1587.50,'2023-02-28 09:21:32','',''),(487,'1','311','1',1,'Retail Sale Id 530',3600.00,0.00,0.00,5.00,635.00,'2023-02-28 09:24:08','',''),(488,'1','311','1',1,'Retail Sale Id 531',2160.00,0.00,0.00,3.00,381.00,'2023-02-28 09:32:48','',''),(489,'1','311','1',1,'Retail Sale Id 532',5040.00,0.00,0.00,7.00,889.00,'2023-02-28 09:34:26','',''),(490,'1','311','1',1,'Retail Sale Id 533',1440.00,0.00,0.00,2.00,254.00,'2023-02-28 09:36:36','',''),(491,'1','311','1',1,'Retail Sale Id 534',748.80,0.00,0.00,1.04,132.08,'2023-02-28 09:39:28','',''),(492,'1','311','1',1,'Retail Sale Id 535',3002.40,0.00,0.00,4.17,529.59,'2023-02-28 09:41:10','',''),(493,'1','311','1',1,'Retail Sale Id 536',2498.40,0.00,0.00,3.47,440.69,'2023-02-28 09:42:38','',''),(494,'1','311','1',1,'Retail Sale Id 540',2160.00,0.00,0.00,3.00,381.00,'2023-02-28 09:48:40','',''),(495,'1','311','1',1,'Retail Sale Id 541',7200.00,0.00,0.00,10.00,1270.00,'2023-02-28 09:53:05','',''),(496,'1','311','1',1,'Retail Sale Id 543',1440.00,0.00,0.00,2.00,254.00,'2023-02-28 10:03:40','',''),(497,'1','311','1',1,'Retail Sale Id 544',2160.00,0.00,0.00,3.00,381.00,'2023-02-28 10:05:18','',''),(498,'1','311','1',1,'Retail Sale Id 546',9000.00,0.00,0.00,12.50,1587.50,'2023-02-28 10:08:00','',''),(499,'1','311','1',1,'Retail Sale Id 549',3002.40,0.00,0.00,4.17,529.59,'2023-02-28 10:20:22','',''),(500,'1','311','1',1,'Retail Sale Id 550',2001.60,0.00,0.00,2.78,353.06,'2023-02-28 10:21:06','',''),(501,'1','311','1',1,'Retail Sale Id 551',3600.00,0.00,0.00,5.00,635.00,'2023-02-28 10:21:46','',''),(502,'1','311','1',1,'Retail Sale Id 552',7200.00,0.00,0.00,10.00,1270.00,'2023-02-28 10:22:43','',''),(503,'1','311','1',1,'Retail Sale Id 554',4320.00,0.00,0.00,6.00,762.00,'2023-02-28 10:25:54','',''),(504,'1','311','1',1,'Retail Sale Id 556',7920.00,0.00,0.00,11.00,1397.00,'2023-02-28 10:28:11','',''),(505,'1','311','1',1,'Retail Sale Id 557',2001.60,0.00,0.00,2.78,353.06,'2023-02-28 10:31:20','',''),(506,'1','311','1',1,'Retail Sale Id 558',7200.00,0.00,0.00,10.00,1270.00,'2023-02-28 10:45:47','',''),(507,'1','311','1',1,'Retail Sale Id 559',9000.00,0.00,0.00,12.50,1587.50,'2023-02-28 10:56:22','',''),(508,'1','311','1',1,'Retail Sale Id 563',3600.00,0.00,0.00,5.00,635.00,'2023-02-28 11:04:49','',''),(509,'1','311','1',1,'Retail Sale Id 564',2102.40,0.00,0.00,2.92,370.84,'2023-02-28 11:11:03','',''),(510,'1','311','1',1,'Retail Sale Id 565',2160.00,0.00,0.00,3.00,381.00,'2023-02-28 11:14:54','',''),(511,'1','311','1',1,'Retail Sale Id 566',204000.00,0.00,0.00,300.00,26100.00,'2023-02-28 11:20:24','',''),(512,'1','311','1',1,'Retail Sale Id 567',4320.00,0.00,0.00,6.00,762.00,'2023-02-28 11:23:35','',''),(513,'1','311','1',1,'Retail Sale Id 568',3002.40,0.00,0.00,4.17,529.59,'2023-02-28 11:33:33','',''),(514,'1','311','1',1,'Retail Sale Id 570',1000.80,0.00,0.00,1.39,176.53,'2023-02-28 11:47:09','',''),(515,'1','311','1',1,'Retail Sale Id 571',4003.20,0.00,0.00,5.56,706.12,'2023-02-28 11:49:38','',''),(516,'1','311','1',1,'Retail Sale Id 572',2001.60,0.00,0.00,2.78,353.06,'2023-02-28 11:53:26','',''),(517,'1','311','1',1,'Retail Sale Id 573',122400.00,0.00,0.00,180.00,15660.00,'2023-02-28 12:01:04','',''),(518,'1','311','1',1,'Retail Sale Id 574',1447.20,0.00,0.00,2.01,255.27,'2023-02-28 12:16:50','',''),(519,'1','311','1',1,'Retail Sale Id 575',2160.00,0.00,0.00,3.00,381.00,'2023-02-28 12:29:44','',''),(520,'1','311','1',1,'Retail Sale Id 576',1440.00,0.00,0.00,2.00,254.00,'2023-02-28 12:39:10','',''),(521,'1','311','1',1,'Retail Sale Id 577',9000.00,0.00,0.00,12.50,1587.50,'2023-02-28 13:10:10','',''),(522,'1','311','1',1,'Retail Sale Id 578',7999.20,0.00,0.00,11.11,1410.97,'2023-02-28 13:11:45','',''),(523,'1','311','1',1,'Return of Retail Sale Id 578',0.00,7999.20,11.11,0.00,-1410.97,'2023-02-28 13:13:04','',''),(524,'1','311','1',1,'Retail Sale Id 579',7999.20,0.00,0.00,11.11,1410.97,'2023-02-28 13:14:35','',''),(525,'1','311','1',1,'Retail Sale Id 581',5047.20,0.00,0.00,7.01,890.27,'2023-02-28 13:25:29','',''),(526,'1','311','1',1,'Retail Sale Id 582',1440.00,0.00,0.00,2.00,254.00,'2023-02-28 13:35:02','',''),(527,'1','311','1',1,'Retail Sale Id 583',4320.00,0.00,0.00,6.00,762.00,'2023-02-28 13:53:08','',''),(528,'1','311','1',1,'Retail Sale Id 584',4320.00,0.00,0.00,6.00,762.00,'2023-02-28 14:01:56','',''),(529,'1','311','1',1,'Retail Sale Id 586',3600.00,0.00,0.00,5.00,635.00,'2023-02-28 14:07:21','',''),(530,'1','311','1',1,'Retail Sale Id 587',2160.00,0.00,0.00,3.00,381.00,'2023-02-28 14:11:48','',''),(531,'1','311','1',1,'Retail Sale Id 588',3600.00,0.00,0.00,5.00,635.00,'2023-02-28 14:26:24','',''),(532,'1','311','1',1,'Retail Sale Id 589',1440.00,0.00,0.00,2.00,254.00,'2023-02-28 14:27:52','',''),(533,'1','311','1',1,'Retail Sale Id 590',3002.40,0.00,0.00,4.17,529.59,'2023-02-28 14:34:58','',''),(534,'1','311','1',1,'Retail Sale Id 591',9000.00,0.00,0.00,12.50,1587.50,'2023-02-28 14:36:52','',''),(535,'1','311','1',1,'Retail Sale Id 593',2203.20,0.00,0.00,3.06,388.62,'2023-02-28 14:41:51','',''),(536,'1','311','1',1,'Retail Sale Id 595',1440.00,0.00,0.00,2.00,254.00,'2023-02-28 14:49:43','',''),(537,'1','311','1',1,'Retail Sale Id 596',9000.00,0.00,0.00,12.50,1587.50,'2023-02-28 14:51:26','',''),(538,'1','311','1',1,'Retail Sale Id 597',8640.00,0.00,0.00,12.00,1524.00,'2023-02-28 14:54:59','',''),(539,'1','311','1',1,'Retail Sale Id 598',2160.00,0.00,0.00,3.00,381.00,'2023-02-28 14:59:02','',''),(540,'1','311','1',1,'Retail Sale Id 599',9000.00,0.00,0.00,12.50,1587.50,'2023-02-28 15:02:38','',''),(541,'1','311','1',1,'Retail Sale Id 601',1440.00,0.00,0.00,2.00,254.00,'2023-02-28 15:06:15','',''),(542,'1','311','1',1,'Retail Sale Id 601',1440.00,0.00,0.00,2.00,254.00,'2023-02-28 15:06:15','',''),(543,'1','311','1',1,'Retail Sale Id 603',4320.00,0.00,0.00,6.00,762.00,'2023-02-28 15:10:15','',''),(544,'1','311','1',1,'Retail Sale Id 603',4320.00,0.00,0.00,6.00,762.00,'2023-02-28 15:10:15','',''),(545,'1','311','1',1,'Return of Retail Sale Id 599',0.00,9000.00,12.50,0.00,-1587.50,'2023-02-28 15:11:36','',''),(546,'1','311','1',1,'Retail Sale Id 604',8661.60,0.00,0.00,12.03,1527.81,'2023-02-28 15:13:35','',''),(547,'1','311','1',1,'Retail Sale Id 605',1440.00,0.00,0.00,2.00,254.00,'2023-02-28 15:14:41','',''),(548,'1','311','1',1,'Retail Sale Id 606',2152.80,0.00,0.00,2.99,379.73,'2023-02-28 15:21:53','',''),(549,'1','311','1',1,'Retail Sale Id 607',2880.00,0.00,0.00,4.00,508.00,'2023-02-28 16:18:33','',''),(550,'1','311','1',1,'Retail Sale Id 608',2001.60,0.00,0.00,2.78,353.06,'2023-02-28 16:19:20','',''),(551,'1','311','1',1,'Retail Sale Id 609',1497.60,0.00,0.00,2.08,264.16,'2023-02-28 16:20:03','',''),(552,'1','311','1',1,'Retail Sale Id 610',3600.00,0.00,0.00,5.00,635.00,'2023-02-28 16:20:52','',''),(553,'1','311','1',1,'Retail Sale Id 611',4003.20,0.00,0.00,5.56,706.12,'2023-02-28 16:21:41','',''),(554,'1','311','1',1,'Retail Sale Id 612',1000.80,0.00,0.00,1.39,176.53,'2023-02-28 16:22:37','',''),(555,'1','311','1',1,'Retail Sale Id 613',11001.60,0.00,0.00,15.28,1940.56,'2023-02-28 16:24:12','',''),(556,'1','311','1',1,'Retail Sale Id 614',5040.00,0.00,0.00,7.00,889.00,'2023-02-28 16:25:16','',''),(557,'1','311','1',1,'Retail Sale Id 615',1497.60,0.00,0.00,2.08,264.16,'2023-02-28 16:26:21','',''),(558,'1','311','1',1,'Retail Sale Id 617',4320.00,0.00,0.00,6.00,762.00,'2023-02-28 16:29:00','',''),(559,'1','311','1',1,'Retail Sale Id 618',7200.00,0.00,0.00,10.00,1270.00,'2023-02-28 16:30:20','',''),(560,'1','311','1',1,'Retail Sale Id 618',7200.00,0.00,0.00,10.00,1270.00,'2023-02-28 16:30:20','',''),(561,'1','311','1',1,'Retail Sale Id 619',1497.60,0.00,0.00,2.08,264.16,'2023-02-28 16:31:51','',''),(562,'1','311','1',1,'Retail Sale Id 620',2203.20,0.00,0.00,3.06,388.62,'2023-02-28 16:32:55','',''),(563,'1','311','1',1,'Retail Sale Id 621',4320.00,0.00,0.00,6.00,762.00,'2023-02-28 16:34:06','',''),(564,'1','311','1',1,'Retail Sale Id 622',1497.60,0.00,0.00,2.08,264.16,'2023-02-28 16:34:59','',''),(565,'1','311','1',1,'Retail Sale Id 623',4320.00,0.00,0.00,6.00,762.00,'2023-02-28 16:38:17','',''),(566,'1','311','1',1,'Retail Sale Id 624',5040.00,0.00,0.00,7.00,889.00,'2023-02-28 16:39:39','',''),(567,'1','311','1',1,'Retail Sale Id 625',2160.00,0.00,0.00,3.00,381.00,'2023-02-28 16:40:42','',''),(568,'1','311','1',1,'Retail Sale Id 626',4320.00,0.00,0.00,6.00,762.00,'2023-02-28 16:42:23','',''),(569,'1','311','1',1,'Retail Sale Id 627',799.20,0.00,0.00,1.11,140.97,'2023-02-28 16:44:13','',''),(570,'1','311','1',1,'Retail Sale Id 628',1497.60,0.00,0.00,2.08,264.16,'2023-02-28 16:46:56','',''),(571,'1','311','1',1,'Retail Sale Id 629',2160.00,0.00,0.00,3.00,381.00,'2023-02-28 16:47:33','',''),(572,'1','311','1',1,'Retail Sale Id 630',2880.00,0.00,0.00,4.00,508.00,'2023-02-28 16:48:53','',''),(573,'1','311','1',1,'Retail Sale Id 631',3600.00,0.00,0.00,5.00,635.00,'2023-02-28 16:49:45','',''),(574,'1','311','1',1,'Retail Sale Id 632',5040.00,0.00,0.00,7.00,889.00,'2023-02-28 16:50:39','',''),(575,'1','311','1',1,'Retail Sale Id 634',799.20,0.00,0.00,1.11,140.97,'2023-02-28 16:59:44','',''),(576,'1','311','1',1,'Retail Sale Id 635',3002.40,0.00,0.00,4.17,529.59,'2023-02-28 17:08:22','',''),(577,'1','311','1',1,'Retail Sale Id 636',4320.00,0.00,0.00,6.00,762.00,'2023-02-28 17:12:26','',''),(578,'1','311','1',1,'Retail Sale Id 637',2160.00,0.00,0.00,3.00,381.00,'2023-02-28 17:13:39','',''),(579,'1','311','1',1,'Retail Sale Id 638',2880.00,0.00,0.00,4.00,508.00,'2023-02-28 17:14:39','',''),(580,'1','311','1',1,'Retail Sale Id 639',3600.00,0.00,0.00,5.00,635.00,'2023-02-28 17:17:41','',''),(581,'1','311','1',1,'Retail Sale Id 639',4320.00,0.00,0.00,6.00,762.00,'2023-02-28 17:17:41','',''),(582,'1','311','1',1,'Retail Sale Id 640',4003.20,0.00,0.00,5.56,706.12,'2023-02-28 17:20:00','',''),(583,'1','311','1',1,'Retail Sale Id 641',9000.00,0.00,0.00,12.50,1587.50,'2023-02-28 17:21:20','',''),(584,'1','311','1',1,'Retail Sale Id 642',3600.00,0.00,0.00,5.00,635.00,'2023-02-28 17:22:50','',''),(585,'1','311','1',1,'Retail Sale Id 643',7200.00,0.00,0.00,10.00,1270.00,'2023-02-28 17:24:21','',''),(586,'1','311','1',1,'Retail Sale Id 644',5040.00,0.00,0.00,7.00,889.00,'2023-02-28 17:26:25','',''),(587,'1','311','1',1,'Retail Sale Id 645',7200.00,0.00,0.00,10.00,1270.00,'2023-02-28 17:27:38','',''),(588,'1','311','1',1,'Retail Sale Id 647',4996.80,0.00,0.00,6.94,881.38,'2023-02-28 17:34:07','',''),(589,'1','311','1',1,'Retail Sale Id 648',5040.00,0.00,0.00,7.00,889.00,'2023-02-28 17:35:12','',''),(590,'1','311','1',1,'Retail Sale Id 649',4003.20,0.00,0.00,5.56,706.12,'2023-02-28 17:36:19','',''),(591,'1','311','1',1,'Retail Sale Id 650',1440.00,0.00,0.00,2.00,254.00,'2023-02-28 17:37:58','',''),(592,'1','311','1',1,'Retail Sale Id 651',7920.00,0.00,0.00,11.00,1397.00,'2023-02-28 17:39:52','',''),(593,'1','311','1',1,'Retail Sale Id 652',2160.00,0.00,0.00,3.00,381.00,'2023-02-28 17:43:17','',''),(594,'1','311','1',1,'Retail Sale Id 653',3600.00,0.00,0.00,5.00,635.00,'2023-02-28 17:45:35','',''),(595,'1','311','1',1,'Retail Sale Id 654',1000.80,0.00,0.00,1.39,176.53,'2023-02-28 17:46:38','',''),(596,'1','311','1',1,'Retail Sale Id 655',3002.40,0.00,0.00,4.17,529.59,'2023-02-28 17:48:29','',''),(597,'1','311','1',1,'Retail Sale Id 656',3600.00,0.00,0.00,5.00,635.00,'2023-02-28 17:49:18','',''),(598,'1','311','1',1,'Retail Sale Id 657',1000.80,0.00,0.00,1.39,176.53,'2023-02-28 17:50:36','',''),(599,'1','311','1',1,'Retail Sale Id 658',3600.00,0.00,0.00,5.00,635.00,'2023-02-28 17:53:23','',''),(600,'1','311','1',1,'Retail Sale Id 660',3600.00,0.00,0.00,5.00,635.00,'2023-02-28 17:55:26','',''),(601,'1','311','1',1,'Retail Sale Id 661',748.80,0.00,0.00,1.04,132.08,'2023-02-28 17:57:10','',''),(602,'1','311','1',1,'Retail Sale Id 662',2160.00,0.00,0.00,3.00,381.00,'2023-02-28 17:58:50','',''),(603,'1','311','1',1,'Retail Sale Id 663',2160.00,0.00,0.00,3.00,381.00,'2023-02-28 18:03:01','',''),(604,'1','311','1',1,'Retail Sale Id 664',2498.40,0.00,0.00,3.47,440.69,'2023-02-28 18:05:07','',''),(605,'1','311','1',1,'Retail Sale Id 665',3600.00,0.00,0.00,5.00,635.00,'2023-02-28 18:06:37','',''),(606,'1','311','1',1,'Retail Sale Id 666',2160.00,0.00,0.00,3.00,381.00,'2023-02-28 18:08:17','',''),(607,'1','311','1',1,'Retail Sale Id 667',8640.00,0.00,0.00,12.00,1524.00,'2023-02-28 18:12:03','',''),(608,'1','311','1',1,'Retail Sale Id 669',1440.00,0.00,0.00,2.00,254.00,'2023-02-28 18:15:25','',''),(609,'1','311','1',1,'Retail Sale Id 671',2160.00,0.00,0.00,3.00,381.00,'2023-02-28 18:16:36','',''),(610,'1','311','1',1,'Retail Sale Id 672',3600.00,0.00,0.00,5.00,635.00,'2023-02-28 18:17:54','',''),(611,'1','311','1',1,'Retail Sale Id 673',1497.60,0.00,0.00,2.08,264.16,'2023-02-28 18:18:50','',''),(612,'1','311','1',1,'Retail Sale Id 674',2001.60,0.00,0.00,2.78,353.06,'2023-02-28 18:21:53','',''),(613,'1','311','1',1,'Retail Sale Id 675',2498.40,0.00,0.00,3.47,440.69,'2023-02-28 18:23:34','',''),(614,'1','311','1',1,'Retail Sale Id 676',9000.00,0.00,0.00,12.50,1587.50,'2023-02-28 18:27:08','',''),(615,'1','311','1',1,'Retail Sale Id 677',3600.00,0.00,0.00,5.00,635.00,'2023-02-28 18:32:05','',''),(616,'1','311','1',1,'Retail Sale Id 678',2160.00,0.00,0.00,3.00,381.00,'2023-02-28 18:36:20','',''),(617,'1','311','1',1,'Return of Retail Sale Id 676',0.00,9000.00,12.50,0.00,-1587.50,'2023-02-28 20:44:22','',''),(618,'1','311','1',1,'Retail Sale Id 679',3412.80,0.00,0.00,4.74,601.98,'2023-02-28 20:45:25','',''),(619,'1','311','1',1,'Return of Retail Sale Id 667',0.00,8640.00,12.00,0.00,-1524.00,'2023-02-28 20:54:00','',''),(620,'1','311','1',1,'Retail Sale Id 680',2685.60,0.00,0.00,3.73,473.71,'2023-02-28 20:56:07','',''),(621,'1','311','1',1,'Return of Retail Sale Id 680',0.00,2685.60,3.73,0.00,-473.71,'2023-02-28 20:58:06','',''),(622,'1','311','1',1,'Retail Sale Id 681',2685.60,0.00,0.00,3.73,473.71,'2023-02-28 20:59:07','',''),(623,'1','311','1',1,'Retail Sale Id 682',5940.00,0.00,0.00,8.25,1047.75,'2023-02-28 21:01:34','',''),(624,'1','311','1',1,'Return of Retail Sale Id 681',0.00,2685.60,3.73,0.00,-473.71,'2023-02-28 21:03:46','',''),(625,'1','311','1',1,'Retail Sale Id 683',2685.60,0.00,0.00,3.73,473.71,'2023-02-28 21:04:29','',''),(626,'1','311','1',1,'Retail Sale Id 684',2160.00,0.00,0.00,3.00,381.00,'2023-03-01 08:17:12','',''),(627,'1','311','1',1,'Retail Sale Id 685',3600.00,0.00,0.00,5.00,635.00,'2023-03-01 08:18:20','',''),(628,'1','311','1',1,'Retail Sale Id 686',3600.00,0.00,0.00,5.00,635.00,'2023-03-01 08:31:36','',''),(629,'1','311','1',1,'Retail Sale Id 688',5040.00,0.00,0.00,7.00,889.00,'2023-03-01 08:33:22','',''),(630,'1','311','1',1,'Retail Sale Id 689',2498.40,0.00,0.00,3.47,440.69,'2023-03-01 08:59:38','',''),(631,'1','311','1',1,'Return of Retail Sale Id 689',0.00,2498.40,3.47,0.00,-440.69,'2023-03-01 09:03:25','',''),(632,'1','311','1',1,'Retail Sale Id 690',3600.00,0.00,0.00,5.00,635.00,'2023-03-01 09:04:17','',''),(633,'1','311','1',1,'Retail Sale Id 691',4320.00,0.00,0.00,6.00,762.00,'2023-03-01 09:11:15','',''),(634,'1','311','1',1,'Retail Sale Id 692',9000.00,0.00,0.00,12.50,1587.50,'2023-03-01 09:14:26','',''),(635,'1','311','1',1,'Retail Sale Id 693',2001.60,0.00,0.00,2.78,353.06,'2023-03-01 09:53:44','',''),(636,'1','311','1',1,'Retail Sale Id 694',1440.00,0.00,0.00,2.00,254.00,'2023-03-01 10:01:04','',''),(637,'1','311','1',1,'Retail Sale Id 695',5040.00,0.00,0.00,7.00,889.00,'2023-03-01 10:02:00','',''),(638,'1','311','1',1,'Retail Sale Id 696',9000.00,0.00,0.00,12.50,1587.50,'2023-03-01 10:05:41','',''),(639,'1','311','1',1,'Retail Sale Id 697',748.80,0.00,0.00,1.04,132.08,'2023-03-01 10:07:09','',''),(640,'1','311','1',1,'Retail Sale Id 698',4320.00,0.00,0.00,6.00,762.00,'2023-03-01 10:20:44','',''),(641,'1','311','1',1,'Retail Sale Id 699',4320.00,0.00,0.00,6.00,762.00,'2023-03-01 10:24:28','',''),(642,'1','311','1',1,'Return of Retail Sale Id 699',0.00,4320.00,6.00,0.00,-762.00,'2023-03-01 10:31:20','',''),(643,'1','311','1',1,'Retail Sale Id 701',5040.00,0.00,0.00,7.00,889.00,'2023-03-01 10:33:40','',''),(644,'1','311','1',1,'Retail Sale Id 702',1497.60,0.00,0.00,2.08,264.16,'2023-03-01 10:35:01','',''),(645,'1','311','1',1,'Retail Sale Id 703',9000.00,0.00,0.00,12.50,1587.50,'2023-03-01 10:35:56','',''),(646,'1','311','1',1,'Retail Sale Id 704',2498.40,0.00,0.00,3.47,440.69,'2023-03-01 10:53:06','',''),(647,'1','311','1',1,'Retail Sale Id 705',3600.00,0.00,0.00,5.00,635.00,'2023-03-01 10:56:41','',''),(648,'1','311','1',1,'Retail Sale Id 706',5997.60,0.00,0.00,8.33,1057.91,'2023-03-01 10:58:59','',''),(649,'1','311','1',1,'Retail Sale Id 707',3002.40,0.00,0.00,4.17,529.59,'2023-03-01 11:01:57','',''),(650,'1','311','1',1,'Retail Sale Id 708',4320.00,0.00,0.00,6.00,762.00,'2023-03-01 11:03:38','',''),(651,'1','311','1',1,'Retail Sale Id 709',2001.60,0.00,0.00,2.78,353.06,'2023-03-01 11:04:47','',''),(652,'1','311','1',1,'Retail Sale Id 711',3499.20,0.00,0.00,4.86,617.22,'2023-03-01 11:07:35','',''),(653,'1','311','1',1,'Retail Sale Id 712',1440.00,0.00,0.00,2.00,254.00,'2023-03-01 11:23:40','',''),(654,'1','311','1',1,'Retail Sale Id 713',3002.40,0.00,0.00,4.17,529.59,'2023-03-01 11:29:16','',''),(655,'1','311','1',1,'Retail Sale Id 713',4003.20,0.00,0.00,5.56,706.12,'2023-03-01 11:29:16','',''),(656,'1','311','1',1,'Retail Sale Id 714',1000.80,0.00,0.00,1.39,176.53,'2023-03-01 11:30:57','',''),(657,'1','311','1',1,'Retail Sale Id 715',2160.00,0.00,0.00,3.00,381.00,'2023-03-01 12:03:00','',''),(658,'1','311','1',1,'Retail Sale Id 716',2880.00,0.00,0.00,4.00,508.00,'2023-03-01 12:17:03','',''),(659,'1','311','1',1,'Retail Sale Id 717',2001.60,0.00,0.00,2.78,353.06,'2023-03-01 12:18:18','',''),(660,'1','311','1',1,'Retail Sale Id 718',720.00,0.00,0.00,1.00,127.00,'2023-03-01 12:24:37','',''),(661,'1','311','1',1,'Retail Sale Id 719',3600.00,0.00,0.00,5.00,635.00,'2023-03-01 12:39:37','',''),(662,'1','311','1',1,'Retail Sale Id 720',7920.00,0.00,0.00,11.00,1397.00,'2023-03-01 12:41:50','',''),(663,'1','311','1',1,'Retail Sale Id 721',3002.40,0.00,0.00,4.17,529.59,'2023-03-01 12:56:23','',''),(664,'1','311','1',1,'Retail Sale Id 722',2001.60,0.00,0.00,2.78,353.06,'2023-03-01 12:57:23','',''),(665,'1','311','1',1,'Retail Sale Id 723',5040.00,0.00,0.00,7.00,889.00,'2023-03-01 12:58:06','',''),(666,'1','311','1',1,'Retail Sale Id 724',2880.00,0.00,0.00,4.00,508.00,'2023-03-01 13:10:37','',''),(667,'1','311','1',1,'Retail Sale Id 725',2160.00,0.00,0.00,3.00,381.00,'2023-03-01 13:19:18','',''),(668,'1','311','1',1,'Retail Sale Id 726',2160.00,0.00,0.00,3.00,381.00,'2023-03-01 13:27:52','',''),(669,'1','311','1',1,'Retail Sale Id 727',1000.80,0.00,0.00,1.39,176.53,'2023-03-01 13:34:12','',''),(670,'1','311','1',1,'Retail Sale Id 728',5320.80,0.00,0.00,7.39,938.53,'2023-03-01 13:36:13','',''),(671,'1','311','1',1,'Return of Retail Sale Id 728',0.00,5320.80,7.39,0.00,-938.53,'2023-03-01 13:36:56','',''),(672,'1','311','1',1,'Retail Sale Id 729',4320.00,0.00,0.00,6.00,762.00,'2023-03-01 13:37:37','',''),(673,'1','311','1',1,'Retail Sale Id 730',1000.80,0.00,0.00,1.39,176.53,'2023-03-01 13:40:24','',''),(674,'1','311','1',1,'Retail Sale Id 731',9000.00,0.00,0.00,12.50,1587.50,'2023-03-01 13:57:05','',''),(675,'1','311','1',1,'Retail Sale Id 732',5040.00,0.00,0.00,7.00,889.00,'2023-03-01 13:58:51','',''),(676,'1','311','1',1,'Retail Sale Id 733',1800.00,0.00,0.00,2.50,317.50,'2023-03-01 14:06:02','',''),(677,'1','311','1',1,'Retail Sale Id 734',1497.60,0.00,0.00,2.08,264.16,'2023-03-01 14:20:11','',''),(678,'1','311','1',1,'Retail Sale Id 736',4320.00,0.00,0.00,6.00,762.00,'2023-03-01 14:23:38','',''),(679,'1','311','1',1,'Retail Sale Id 737',4147.20,0.00,0.00,5.76,731.52,'2023-03-01 14:24:53','',''),(680,'1','311','1',1,'Retail Sale Id 738',2880.00,0.00,0.00,4.00,508.00,'2023-03-01 14:25:58','',''),(681,'1','311','1',1,'Retail Sale Id 739',3600.00,0.00,0.00,5.00,635.00,'2023-03-01 14:29:12','',''),(682,'1','311','1',1,'Retail Sale Id 741',8640.00,0.00,0.00,12.00,1524.00,'2023-03-01 14:39:14','',''),(683,'1','311','1',1,'Retail Sale Id 742',3600.00,0.00,0.00,5.00,635.00,'2023-03-01 14:44:14','',''),(684,'1','311','1',1,'Retail Sale Id 743',3600.00,0.00,0.00,5.00,635.00,'2023-03-01 14:49:50','',''),(685,'1','311','1',1,'Retail Sale Id 743',3600.00,0.00,0.00,5.00,635.00,'2023-03-01 14:49:50','',''),(686,'1','311','1',1,'Retail Sale Id 744',9000.00,0.00,0.00,12.50,1587.50,'2023-03-01 14:58:24','',''),(687,'1','311','1',1,'Retail Sale Id 745',9000.00,0.00,0.00,12.50,1587.50,'2023-03-01 15:01:47','',''),(688,'1','311','1',1,'Retail Sale Id 746',1440.00,0.00,0.00,2.00,254.00,'2023-03-01 15:08:24','',''),(689,'1','311','1',1,'Retail Sale Id 747',2160.00,0.00,0.00,3.00,381.00,'2023-03-01 15:14:54','',''),(690,'1','311','1',1,'Retail Sale Id 748',4003.20,0.00,0.00,5.56,706.12,'2023-03-01 15:33:17','',''),(691,'1','311','1',1,'Retail Sale Id 750',2160.00,0.00,0.00,3.00,381.00,'2023-03-01 15:36:42','',''),(692,'1','311','1',1,'Retail Sale Id 750',4320.00,0.00,0.00,6.00,762.00,'2023-03-01 15:36:42','',''),(693,'1','311','1',1,'Retail Sale Id 751',2880.00,0.00,0.00,4.00,508.00,'2023-03-01 15:38:31','',''),(694,'1','311','1',1,'Retail Sale Id 752',2498.40,0.00,0.00,3.47,440.69,'2023-03-01 15:39:58','',''),(695,'1','311','1',1,'Retail Sale Id 754',1497.60,0.00,0.00,2.08,264.16,'2023-03-01 16:02:22','',''),(696,'1','311','1',1,'Retail Sale Id 757',1396.80,0.00,0.00,1.94,246.38,'2023-03-01 16:09:28','',''),(697,'1','311','1',1,'Retail Sale Id 758',4320.00,0.00,0.00,6.00,762.00,'2023-03-01 16:32:05','',''),(698,'1','311','1',1,'Retail Sale Id 759',3600.00,0.00,0.00,5.00,635.00,'2023-03-01 17:13:43','',''),(699,'1','311','1',1,'Retail Sale Id 760',1440.00,0.00,0.00,2.00,254.00,'2023-03-01 17:21:55','',''),(700,'1','311','1',1,'Retail Sale Id 761',9000.00,0.00,0.00,12.50,1587.50,'2023-03-01 17:27:16','',''),(701,'1','311','1',1,'Retail Sale Id 762',9000.00,0.00,0.00,12.50,1587.50,'2023-03-01 17:36:41','',''),(702,'1','311','1',1,'Return of Retail Sale Id 762',0.00,9000.00,12.50,0.00,-1587.50,'2023-03-01 17:37:23','',''),(703,'1','311','1',1,'Retail Sale Id 763',9000.00,0.00,0.00,12.50,1587.50,'2023-03-01 17:37:59','',''),(704,'1','311','1',1,'Retail Sale Id 764',2160.00,0.00,0.00,3.00,381.00,'2023-03-01 17:40:11','',''),(705,'1','311','1',1,'Return of Retail Sale Id 764',0.00,2160.00,3.00,0.00,-381.00,'2023-03-01 20:30:33','',''),(706,'1','311','1',1,'Return of Retail Sale Id 746',0.00,1440.00,2.00,0.00,-254.00,'2023-03-01 20:35:04','',''),(707,'1','311','1',1,'Retail Sale Id 765',1440.00,0.00,0.00,2.00,254.00,'2023-03-01 20:36:05','',''),(708,'1','311','1',1,'Return of Retail Sale Id 763',0.00,9000.00,12.50,0.00,-1587.50,'2023-03-01 20:39:32','',''),(709,'1','311','1',1,'Return of Retail Sale Id 757',0.00,1396.80,1.94,0.00,-246.38,'2023-03-01 20:43:32','',''),(710,'1','311','1',1,'Retail Sale Id 766',1346.40,0.00,0.00,1.87,237.49,'2023-03-01 20:44:44','',''),(711,'1','311','1',1,'Retail Sale Id 767',9000.00,0.00,0.00,12.50,1587.50,'2023-03-02 08:07:21','',''),(712,'1','311','1',1,'Retail Sale Id 768',5040.00,0.00,0.00,7.00,889.00,'2023-03-02 08:09:34','',''),(713,'1','311','1',1,'Retail Sale Id 770',3600.00,0.00,0.00,5.00,635.00,'2023-03-02 08:13:15','',''),(714,'1','311','1',1,'Retail Sale Id 770',5040.00,0.00,0.00,7.00,889.00,'2023-03-02 08:13:15','',''),(715,'1','311','1',1,'Retail Sale Id 771',1440.00,0.00,0.00,2.00,254.00,'2023-03-02 08:17:09','',''),(716,'1','311','1',1,'Retail Sale Id 772',4680.00,0.00,0.00,6.50,825.50,'2023-03-02 08:25:46','',''),(717,'1','311','1',1,'Retail Sale Id 773',9000.00,0.00,0.00,12.50,1587.50,'2023-03-02 08:38:50','',''),(718,'1','311','1',1,'Retail Sale Id 774',3002.40,0.00,0.00,4.17,529.59,'2023-03-02 08:45:16','',''),(719,'1','311','1',1,'Retail Sale Id 776',1497.60,0.00,0.00,2.08,264.16,'2023-03-02 08:56:24','',''),(720,'1','311','1',1,'Retail Sale Id 777',1497.60,0.00,0.00,2.08,264.16,'2023-03-02 08:57:55','',''),(721,'1','311','1',1,'Retail Sale Id 778',720.00,0.00,0.00,1.00,127.00,'2023-03-02 09:00:12','',''),(722,'1','311','1',1,'Retail Sale Id 779',5040.00,0.00,0.00,7.00,889.00,'2023-03-02 09:10:09','',''),(723,'1','311','1',1,'Retail Sale Id 780',9000.00,0.00,0.00,12.50,1587.50,'2023-03-02 09:11:32','',''),(724,'1','311','1',1,'Retail Sale Id 781',3002.40,0.00,0.00,4.17,529.59,'2023-03-02 09:12:38','',''),(725,'1','311','1',1,'Retail Sale Id 782',4320.00,0.00,0.00,6.00,762.00,'2023-03-02 09:18:00','',''),(726,'1','311','1',1,'Retail Sale Id 783',2160.00,0.00,0.00,3.00,381.00,'2023-03-02 09:24:30','',''),(727,'1','311','1',1,'Retail Sale Id 784',2001.60,0.00,0.00,2.78,353.06,'2023-03-02 09:35:08','',''),(728,'1','311','1',1,'Retail Sale Id 785',4320.00,0.00,0.00,6.00,762.00,'2023-03-02 09:36:09','',''),(729,'1','311','1',1,'Retail Sale Id 786',2880.00,0.00,0.00,4.00,508.00,'2023-03-02 09:38:13','',''),(730,'1','311','1',1,'Retail Sale Id 788',2203.20,0.00,0.00,3.06,388.62,'2023-03-02 09:49:03','',''),(731,'1','311','1',1,'Retail Sale Id 789',799.20,0.00,0.00,1.11,140.97,'2023-03-02 09:58:05','',''),(732,'1','311','1',1,'Retail Sale Id 790',2160.00,0.00,0.00,3.00,381.00,'2023-03-02 10:02:05','',''),(733,'1','311','1',1,'Retail Sale Id 791',7200.00,0.00,0.00,10.00,1270.00,'2023-03-02 10:11:03','',''),(734,'1','311','1',1,'Retail Sale Id 792',7999.20,0.00,0.00,11.11,1410.97,'2023-03-02 10:14:46','',''),(735,'1','311','1',1,'Return of Retail Sale Id 792',0.00,7999.20,11.11,0.00,-1410.97,'2023-03-02 10:16:13','',''),(736,'1','311','1',1,'Retail Sale Id 793',799.20,0.00,0.00,1.11,140.97,'2023-03-02 10:16:49','',''),(737,'1','311','1',1,'Retail Sale Id 795',9000.00,0.00,0.00,12.50,1587.50,'2023-03-02 10:49:42','',''),(738,'1','311','1',1,'Retail Sale Id 797',2001.60,0.00,0.00,2.78,353.06,'2023-03-02 12:33:37','',''),(739,'1','311','1',1,'Retail Sale Id 797',3600.00,0.00,0.00,5.00,635.00,'2023-03-02 12:33:37','',''),(740,'1','311','1',1,'Retail Sale Id 798',1440.00,0.00,0.00,2.00,254.00,'2023-03-02 12:37:24','',''),(741,'1','311','1',1,'Retail Sale Id 798',1497.60,0.00,0.00,2.08,264.16,'2023-03-02 12:37:24','',''),(742,'1','311','1',1,'Retail Sale Id 800',2880.00,0.00,0.00,4.00,508.00,'2023-03-02 12:58:53','',''),(743,'1','311','1',1,'Retail Sale Id 800',7200.00,0.00,0.00,10.00,1270.00,'2023-03-02 12:58:53','',''),(744,'1','311','1',1,'Retail Sale Id 801',1000.80,0.00,0.00,1.39,176.53,'2023-03-02 13:04:37','',''),(745,'1','311','1',1,'Retail Sale Id 803',7200.00,0.00,0.00,10.00,1270.00,'2023-03-02 13:32:05','',''),(746,'1','311','1',1,'Retail Sale Id 804',9000.00,0.00,0.00,12.50,1587.50,'2023-03-02 13:34:01','',''),(747,'1','311','1',1,'Retail Sale Id 805',2160.00,0.00,0.00,3.00,381.00,'2023-03-02 13:46:56','',''),(748,'1','311','1',1,'Retail Sale Id 806',7200.00,0.00,0.00,10.00,1270.00,'2023-03-02 13:47:41','',''),(749,'1','311','1',1,'Retail Sale Id 807',1497.60,0.00,0.00,2.08,264.16,'2023-03-02 15:22:15','',''),(750,'1','311','1',1,'Retail Sale Id 808',1440.00,0.00,0.00,2.00,254.00,'2023-03-02 15:24:43','',''),(751,'1','311','1',1,'Retail Sale Id 809',748.80,0.00,0.00,1.04,132.08,'2023-03-02 15:27:39','',''),(752,'1','311','1',1,'Retail Sale Id 809',1497.60,0.00,0.00,2.08,264.16,'2023-03-02 15:27:39','',''),(753,'1','311','1',1,'Retail Sale Id 810',3600.00,0.00,0.00,5.00,635.00,'2023-03-02 15:31:24','',''),(754,'1','311','1',1,'Retail Sale Id 823',2001.60,0.00,0.00,2.78,353.06,'2023-03-02 16:49:59','',''),(755,'1','311','1',1,'Retail Sale Id 823',2901.60,0.00,0.00,4.03,511.81,'2023-03-02 16:49:59','',''),(756,'1','311','1',1,'Retail Sale Id 823',4320.00,0.00,0.00,6.00,762.00,'2023-03-02 16:49:59','',''),(757,'1','311','1',1,'Retail Sale Id 824',3600.00,0.00,0.00,5.00,635.00,'2023-03-02 16:50:45','',''),(758,'1','311','1',1,'Retail Sale Id 826',748.80,0.00,0.00,1.04,132.08,'2023-03-02 16:53:58','',''),(759,'1','311','1',1,'Retail Sale Id 826',748.80,0.00,0.00,1.04,132.08,'2023-03-02 16:53:58','',''),(760,'1','311','1',1,'Retail Sale Id 826',2901.60,0.00,0.00,4.03,511.81,'2023-03-02 16:53:58','',''),(761,'1','311','1',1,'Retail Sale Id 827',1497.60,0.00,0.00,2.08,264.16,'2023-03-02 16:57:06','',''),(762,'1','311','1',1,'Retail Sale Id 828',1497.60,0.00,0.00,2.08,264.16,'2023-03-02 17:00:35','',''),(763,'1','311','1',1,'Retail Sale Id 829',597.60,0.00,0.00,0.83,105.41,'2023-03-02 17:11:13','',''),(764,'1','311','1',1,'Retail Sale Id 831',2880.00,0.00,0.00,4.00,508.00,'2023-03-02 17:18:45','',''),(765,'1','311','1',1,'Retail Sale Id 832',2880.00,0.00,0.00,4.00,508.00,'2023-03-02 17:22:05','',''),(766,'1','311','1',1,'Retail Sale Id 833',9000.00,0.00,0.00,12.50,1587.50,'2023-03-02 17:32:01','',''),(767,'1','311','1',1,'Return of Retail Sale Id 833',0.00,9000.00,12.50,0.00,-1587.50,'2023-03-02 19:36:51','',''),(768,'1','311','1',1,'Return of Retail Sale Id 831',0.00,2880.00,4.00,0.00,-508.00,'2023-03-02 19:38:30','',''),(769,'1','311','1',1,'Return of Retail Sale Id 826',0.00,748.80,1.04,0.00,-132.08,'2023-03-02 19:42:58','',''),(770,'1','311','1',1,'Return of Retail Sale Id 826',0.00,748.80,1.04,0.00,-132.08,'2023-03-02 19:42:58','',''),(771,'1','311','1',1,'Return of Retail Sale Id 826',0.00,2901.60,4.03,0.00,-511.81,'2023-03-02 19:42:58','',''),(772,'1','311','1',1,'Return of Retail Sale Id 832',0.00,2880.00,4.00,0.00,-508.00,'2023-03-02 19:45:08','',''),(773,'1','311','1',1,'Return of Retail Sale Id 824',0.00,3600.00,5.00,0.00,-635.00,'2023-03-02 19:48:35','',''),(774,'1','311','1',1,'Retail Sale Id 834',3009.60,0.00,0.00,4.18,530.86,'2023-03-02 19:49:36','',''),(775,'1','311','1',1,'Return of Retail Sale Id 829',0.00,597.60,0.83,0.00,-105.41,'2023-03-02 19:52:46','',''),(776,'1','311','1',1,'Return of Retail Sale Id 828',0.00,1497.60,2.08,0.00,-264.16,'2023-03-02 19:53:29','',''),(777,'1','311','1',1,'Return of Retail Sale Id 827',0.00,1497.60,2.08,0.00,-264.16,'2023-03-02 19:56:12','',''),(778,'1','311','1',1,'Retail Sale Id 835',2138.40,0.00,0.00,2.97,377.19,'2023-03-02 19:56:57','',''),(779,'1','311','1',1,'Retail Sale Id 836',9000.00,0.00,0.00,12.50,1587.50,'2023-03-02 20:00:03','',''),(780,'1','311','1',1,'Retail Sale Id 837',9000.00,0.00,0.00,12.50,1587.50,'2023-03-02 20:00:35','',''),(781,'1','311','1',1,'Retail Sale Id 838',3456.00,0.00,0.00,4.80,609.60,'2023-03-02 20:01:25','',''),(782,'1','311','1',1,'Retail Sale Id 839',2160.00,0.00,0.00,3.00,381.00,'2023-03-03 10:00:58','',''),(783,'1','311','1',1,'Retail Sale Id 840',1440.00,0.00,0.00,2.00,254.00,'2023-03-03 10:05:44','',''),(784,'1','311','1',1,'Retail Sale Id 841',720.00,0.00,0.00,1.00,127.00,'2023-03-03 10:13:39','',''),(785,'1','311','1',1,'Retail Sale Id 843',1440.00,0.00,0.00,2.00,254.00,'2023-03-03 10:34:45','',''),(786,'1','311','1',1,'Retail Sale Id 844',7200.00,0.00,0.00,10.00,1270.00,'2023-03-03 10:52:44','',''),(787,'1','311','1',1,'Retail Sale Id 845',1497.60,0.00,0.00,2.08,264.16,'2023-03-03 11:30:47','',''),(788,'1','311','1',1,'Retail Sale Id 846',4320.00,0.00,0.00,6.00,762.00,'2023-03-03 11:36:33','',''),(789,'1','311','1',1,'Retail Sale Id 847',2160.00,0.00,0.00,3.00,381.00,'2023-03-03 12:06:59','',''),(790,'1','311','1',1,'Retail Sale Id 848',3600.00,0.00,0.00,5.00,635.00,'2023-03-03 12:08:32','',''),(791,'1','311','1',1,'Retail Sale Id 849',3600.00,0.00,0.00,5.00,635.00,'2023-03-03 12:14:23','',''),(792,'1','311','1',1,'Retail Sale Id 849',4320.00,0.00,0.00,6.00,762.00,'2023-03-03 12:14:23','',''),(793,'1','311','1',1,'Retail Sale Id 850',720.00,0.00,0.00,1.00,127.00,'2023-03-03 12:22:19','',''),(794,'1','311','1',1,'Retail Sale Id 851',1440.00,0.00,0.00,2.00,254.00,'2023-03-03 12:26:37','',''),(795,'1','311','1',1,'Retail Sale Id 852',3600.00,0.00,0.00,5.00,635.00,'2023-03-03 12:59:12','',''),(796,'1','311','1',1,'Retail Sale Id 853',2880.00,0.00,0.00,4.00,508.00,'2023-03-03 13:14:08','',''),(797,'1','311','1',1,'Retail Sale Id 855',3600.00,0.00,0.00,5.00,635.00,'2023-03-03 14:14:26','',''),(798,'1','311','1',1,'Retail Sale Id 856',9000.00,0.00,0.00,12.50,1587.50,'2023-03-03 14:21:04','',''),(799,'1','311','1',1,'Retail Sale Id 857',2880.00,0.00,0.00,4.00,508.00,'2023-03-03 14:56:18','',''),(800,'1','311','1',1,'Retail Sale Id 858',3600.00,0.00,0.00,5.00,635.00,'2023-03-03 15:08:33','',''),(801,'1','311','1',1,'Retail Sale Id 859',4320.00,0.00,0.00,6.00,762.00,'2023-03-03 15:13:12','',''),(802,'1','311','1',1,'Retail Sale Id 860',4320.00,0.00,0.00,6.00,762.00,'2023-03-03 15:22:59','',''),(803,'1','311','1',1,'Retail Sale Id 861',9000.00,0.00,0.00,12.50,1587.50,'2023-03-03 15:26:59','',''),(804,'1','311','1',1,'Retail Sale Id 862',1440.00,0.00,0.00,2.00,254.00,'2023-03-03 15:28:54','',''),(805,'1','311','1',1,'Retail Sale Id 863',9000.00,0.00,0.00,12.50,1587.50,'2023-03-03 15:38:04','',''),(806,'1','311','1',1,'Retail Sale Id 864',2880.00,0.00,0.00,4.00,508.00,'2023-03-03 15:38:50','',''),(807,'1','311','1',1,'Retail Sale Id 866',2160.00,0.00,0.00,3.00,381.00,'2023-03-03 16:00:13','',''),(808,'1','311','1',1,'Retail Sale Id 867',4320.00,0.00,0.00,6.00,762.00,'2023-03-03 16:01:07','',''),(809,'1','311','1',1,'Retail Sale Id 868',1000.80,0.00,0.00,1.39,176.53,'2023-03-03 16:34:33','',''),(810,'1','311','1',1,'Retail Sale Id 869',720.00,0.00,0.00,1.00,127.00,'2023-03-03 16:44:19','',''),(811,'1','311','1',1,'Retail Sale Id 870',4003.20,0.00,0.00,5.56,706.12,'2023-03-03 16:48:39','',''),(812,'1','311','1',1,'Retail Sale Id 871',2880.00,0.00,0.00,4.00,508.00,'2023-03-03 17:37:49','',''),(813,'1','311','1',1,'Retail Sale Id 871',3002.40,0.00,0.00,4.17,529.59,'2023-03-03 17:37:49','',''),(814,'1','311','1',1,'Retail Sale Id 872',2160.00,0.00,0.00,3.00,381.00,'2023-03-03 17:39:24','',''),(815,'1','311','1',1,'Retail Sale Id 872',2203.20,0.00,0.00,3.06,388.62,'2023-03-03 17:39:24','',''),(816,'1','311','1',1,'Retail Sale Id 874',2203.20,0.00,0.00,3.06,388.62,'2023-03-03 17:47:13','',''),(817,'1','311','1',1,'Retail Sale Id 875',9000.00,0.00,0.00,12.50,1587.50,'2023-03-03 17:54:46','',''),(818,'1','311','1',1,'Return of Retail Sale Id 869',0.00,720.00,1.00,0.00,-127.00,'2023-03-03 18:11:17','',''),(819,'1','311','1',1,'Retail Sale Id 876',957.60,0.00,0.00,1.33,168.91,'2023-03-03 18:12:03','',''),(820,'1','311','1',1,'Return of Retail Sale Id 874',0.00,2203.20,3.06,0.00,-388.62,'2023-03-03 18:14:51','',''),(821,'1','311','1',1,'Retail Sale Id 877',1728.00,0.00,0.00,2.40,304.80,'2023-03-03 18:18:35','',''),(822,'1','311','1',1,'Retail Sale Id 878',7200.00,0.00,0.00,10.00,1270.00,'2023-03-04 16:51:57','',''),(823,'1','311','1',1,'Retail Sale Id 879',2880.00,0.00,0.00,4.00,508.00,'2023-03-04 16:53:21','',''),(824,'1','311','1',1,'Retail Sale Id 880',2160.00,0.00,0.00,3.00,381.00,'2023-03-04 16:54:01','',''),(825,'1','311','1',1,'Retail Sale Id 881',4320.00,0.00,0.00,6.00,762.00,'2023-03-04 16:54:40','',''),(826,'1','311','1',1,'Retail Sale Id 882',2520.00,0.00,0.00,3.50,444.50,'2023-03-04 16:55:24','',''),(827,'1','311','1',1,'Retail Sale Id 883',1000.80,0.00,0.00,1.39,176.53,'2023-03-04 16:56:10','',''),(828,'1','311','1',1,'Retail Sale Id 884',2160.00,0.00,0.00,3.00,381.00,'2023-03-04 16:56:52','',''),(829,'1','311','1',1,'Retail Sale Id 885',4320.00,0.00,0.00,6.00,762.00,'2023-03-04 16:57:29','',''),(830,'1','311','1',1,'Retail Sale Id 886',2001.60,0.00,0.00,2.78,353.06,'2023-03-04 16:58:51','',''),(831,'1','311','1',1,'Retail Sale Id 887',1000.80,0.00,0.00,1.39,176.53,'2023-03-04 17:00:07','',''),(832,'1','311','1',1,'Retail Sale Id 888',5400.00,0.00,0.00,7.50,952.50,'2023-03-04 17:01:30','',''),(833,'1','311','1',1,'Retail Sale Id 889',3600.00,0.00,0.00,5.00,635.00,'2023-03-04 17:02:22','',''),(834,'1','311','1',1,'Retail Sale Id 890',3600.00,0.00,0.00,5.00,635.00,'2023-03-04 17:04:31','',''),(835,'1','311','1',1,'Retail Sale Id 892',3600.00,0.00,0.00,5.00,635.00,'2023-03-04 17:05:32','',''),(836,'1','311','1',1,'Retail Sale Id 893',3002.40,0.00,0.00,4.17,529.59,'2023-03-04 17:06:25','',''),(837,'1','311','1',1,'Retail Sale Id 894',2498.40,0.00,0.00,3.47,440.69,'2023-03-04 17:07:49','',''),(838,'1','311','1',1,'Retail Sale Id 895',597.60,0.00,0.00,0.83,105.41,'2023-03-04 17:08:53','',''),(839,'1','311','1',1,'Retail Sale Id 896',7920.00,0.00,0.00,11.00,1397.00,'2023-03-04 17:09:33','',''),(840,'1','311','1',1,'Retail Sale Id 897',4320.00,0.00,0.00,6.00,762.00,'2023-03-04 17:10:08','',''),(841,'1','311','1',1,'Retail Sale Id 898',4320.00,0.00,0.00,6.00,762.00,'2023-03-04 17:11:07','',''),(842,'1','311','1',1,'Retail Sale Id 899',3600.00,0.00,0.00,5.00,635.00,'2023-03-04 17:12:01','',''),(843,'1','311','1',1,'Retail Sale Id 900',9000.00,0.00,0.00,12.50,1587.50,'2023-03-04 17:14:58','',''),(844,'1','311','1',1,'Retail Sale Id 901',3600.00,0.00,0.00,5.00,635.00,'2023-03-04 17:16:15','',''),(845,'1','311','1',1,'Retail Sale Id 903',1497.60,0.00,0.00,2.08,264.16,'2023-03-04 17:18:35','',''),(846,'1','311','1',1,'Retail Sale Id 904',3002.40,0.00,0.00,4.17,529.59,'2023-03-04 17:21:07','',''),(847,'1','311','1',1,'Retail Sale Id 904',3600.00,0.00,0.00,5.00,635.00,'2023-03-04 17:21:07','',''),(848,'1','311','1',1,'Retail Sale Id 904',7200.00,0.00,0.00,10.00,1270.00,'2023-03-04 17:21:07','',''),(849,'1','311','1',1,'Retail Sale Id 905',3600.00,0.00,0.00,5.00,635.00,'2023-03-04 17:23:10','',''),(850,'1','311','1',1,'Retail Sale Id 906',2880.00,0.00,0.00,4.00,508.00,'2023-03-04 17:24:30','',''),(851,'1','311','1',1,'Retail Sale Id 907',1440.00,0.00,0.00,2.00,254.00,'2023-03-04 17:25:09','',''),(852,'1','311','1',1,'Retail Sale Id 908',2160.00,0.00,0.00,3.00,381.00,'2023-03-04 17:26:22','',''),(853,'1','311','1',1,'Retail Sale Id 909',2001.60,0.00,0.00,2.78,353.06,'2023-03-04 17:27:09','',''),(854,'1','311','1',1,'Retail Sale Id 910',1000.80,0.00,0.00,1.39,176.53,'2023-03-04 17:27:51','',''),(855,'1','311','1',1,'Retail Sale Id 911',1000.80,0.00,0.00,1.39,176.53,'2023-03-04 17:28:52','',''),(856,'1','311','1',1,'Retail Sale Id 912',5040.00,0.00,0.00,7.00,889.00,'2023-03-04 17:29:49','',''),(857,'1','311','1',1,'Retail Sale Id 913',3002.40,0.00,0.00,4.17,529.59,'2023-03-04 17:30:42','',''),(858,'1','311','1',1,'Retail Sale Id 914',6501.60,0.00,0.00,9.03,1146.81,'2023-03-04 17:31:55','',''),(859,'1','311','1',1,'Retail Sale Id 915',5162.40,0.00,0.00,7.17,910.59,'2023-03-04 17:32:41','',''),(860,'1','311','1',1,'Retail Sale Id 916',10800.00,0.00,0.00,15.00,1905.00,'2023-03-04 17:35:01','',''),(861,'1','311','1',1,'Retail Sale Id 917',18000.00,0.00,0.00,25.00,3175.00,'2023-03-04 17:36:00','',''),(862,'1','311','1',1,'Retail Sale Id 918',12600.00,0.00,0.00,17.50,2222.50,'2023-03-04 17:36:57','',''),(863,'1','311','1',1,'Retail Sale Id 919',6501.60,0.00,0.00,9.03,1146.81,'2023-03-04 17:37:41','',''),(864,'1','311','1',1,'Retail Sale Id 920',9360.00,0.00,0.00,13.00,1651.00,'2023-03-04 17:38:17','',''),(865,'1','311','1',1,'Retail Sale Id 921',8949.60,0.00,0.00,12.43,1578.61,'2023-03-04 17:39:02','',''),(866,'1','311','1',1,'Retail Sale Id 922',8640.00,0.00,0.00,12.00,1524.00,'2023-03-04 17:39:38','',''),(867,'1','311','1',1,'Retail Sale Id 924',10144.80,0.00,0.00,14.09,1789.43,'2023-03-04 17:41:49','',''),(868,'1','311','1',1,'Retail Sale Id 925',7351.20,0.00,0.00,10.21,1296.67,'2023-03-04 17:42:26','',''),(869,'1','311','1',1,'Retail Sale Id 926',14630.40,0.00,0.00,20.32,2580.64,'2023-03-04 17:43:32','',''),(870,'1','311','1',1,'Retail Sale Id 927',7920.00,0.00,0.00,11.00,1397.00,'2023-03-04 17:50:03','',''),(871,'1','311','1',1,'Retail Sale Id 928',40800.00,0.00,0.00,60.00,5220.00,'2023-03-04 18:04:28','',''),(872,'1','311','1',1,'Retail Sale Id 929',1440.00,0.00,0.00,2.00,254.00,'2023-03-05 08:24:48','',''),(873,'1','311','1',1,'Retail Sale Id 930',2160.00,0.00,0.00,3.00,381.00,'2023-03-05 08:26:08','',''),(874,'1','311','1',1,'Retail Sale Id 931',5040.00,0.00,0.00,7.00,889.00,'2023-03-05 08:35:34','',''),(875,'1','311','1',1,'Retail Sale Id 932',2160.00,0.00,0.00,3.00,381.00,'2023-03-05 08:43:53','',''),(876,'1','311','1',1,'Retail Sale Id 932',4320.00,0.00,0.00,6.00,762.00,'2023-03-05 08:43:53','',''),(877,'1','311','1',1,'Return of Retail Sale Id 932',0.00,2160.00,3.00,0.00,-381.00,'2023-03-05 08:50:39','',''),(878,'1','311','1',1,'Return of Retail Sale Id 932',0.00,4320.00,6.00,0.00,-762.00,'2023-03-05 08:50:39','',''),(879,'1','311','1',1,'Retail Sale Id 934',2160.00,0.00,0.00,3.00,381.00,'2023-03-05 08:52:13','',''),(880,'1','311','1',1,'Retail Sale Id 934',4320.00,0.00,0.00,6.00,762.00,'2023-03-05 08:52:13','',''),(881,'1','311','1',1,'Retail Sale Id 935',2001.60,0.00,0.00,2.78,353.06,'2023-03-05 08:56:59','',''),(882,'1','311','1',1,'Retail Sale Id 936',2880.00,0.00,0.00,4.00,508.00,'2023-03-05 09:03:52','',''),(883,'1','311','1',1,'Retail Sale Id 937',2160.00,0.00,0.00,3.00,381.00,'2023-03-05 09:11:17','',''),(884,'1','311','1',1,'Retail Sale Id 937',5040.00,0.00,0.00,7.00,889.00,'2023-03-05 09:11:17','',''),(885,'1','311','1',1,'Retail Sale Id 938',2001.60,0.00,0.00,2.78,353.06,'2023-03-05 09:18:00','',''),(886,'1','311','1',1,'Retail Sale Id 939',2901.60,0.00,0.00,4.03,511.81,'2023-03-05 09:37:25','',''),(887,'1','311','1',1,'Retail Sale Id 940',2160.00,0.00,0.00,3.00,381.00,'2023-03-05 09:48:02','',''),(888,'1','311','1',1,'Retail Sale Id 940',4320.00,0.00,0.00,6.00,762.00,'2023-03-05 09:48:02','',''),(889,'1','311','1',1,'Retail Sale Id 941',5040.00,0.00,0.00,7.00,889.00,'2023-03-05 10:09:52','',''),(890,'1','311','1',1,'Retail Sale Id 942',1440.00,0.00,0.00,2.00,254.00,'2023-03-05 10:52:42','',''),(891,'1','311','1',1,'Retail Sale Id 944',2498.40,0.00,0.00,3.47,440.69,'2023-03-05 11:02:31','',''),(892,'1','311','1',1,'Retail Sale Id 943',2880.00,0.00,0.00,4.00,508.00,'2023-03-05 11:03:25','',''),(893,'1','311','1',1,'Retail Sale Id 945',1440.00,0.00,0.00,2.00,254.00,'2023-03-05 11:04:46','',''),(894,'1','311','1',1,'Retail Sale Id 946',720.00,0.00,0.00,1.00,127.00,'2023-03-05 11:11:36','',''),(895,'1','311','1',1,'Retail Sale Id 947',3600.00,0.00,0.00,5.00,635.00,'2023-03-05 11:21:41','',''),(896,'1','311','1',1,'Retail Sale Id 949',720.00,0.00,0.00,1.00,127.00,'2023-03-05 11:25:18','',''),(897,'1','311','1',1,'Retail Sale Id 950',9000.00,0.00,0.00,12.50,1587.50,'2023-03-05 11:54:30','',''),(898,'1','311','1',1,'Retail Sale Id 951',3600.00,0.00,0.00,5.00,635.00,'2023-03-05 12:00:10','',''),(899,'1','311','1',1,'Retail Sale Id 952',4320.00,0.00,0.00,6.00,762.00,'2023-03-05 12:26:17','',''),(900,'1','311','1',1,'Retail Sale Id 953',4320.00,0.00,0.00,6.00,762.00,'2023-03-05 12:45:02','',''),(901,'1','311','1',1,'Retail Sale Id 954',4320.00,0.00,0.00,6.00,762.00,'2023-03-05 12:46:45','',''),(902,'1','311','1',1,'Retail Sale Id 955',2160.00,0.00,0.00,3.00,381.00,'2023-03-05 13:08:17','',''),(903,'1','311','1',1,'Retail Sale Id 956',1000.80,0.00,0.00,1.39,176.53,'2023-03-05 13:09:19','',''),(904,'1','311','1',1,'Retail Sale Id 957',2160.00,0.00,0.00,3.00,381.00,'2023-03-05 13:21:46','',''),(905,'1','311','1',1,'Retail Sale Id 958',5040.00,0.00,0.00,7.00,889.00,'2023-03-05 13:48:49','',''),(906,'1','311','1',1,'Retail Sale Id 959',1440.00,0.00,0.00,2.00,254.00,'2023-03-05 13:57:50','',''),(907,'1','311','1',1,'Retail Sale Id 959',4320.00,0.00,0.00,6.00,762.00,'2023-03-05 13:57:50','',''),(908,'1','311','1',1,'Retail Sale Id 960',2160.00,0.00,0.00,3.00,381.00,'2023-03-05 14:00:17','',''),(909,'1','311','1',1,'Retail Sale Id 961',5040.00,0.00,0.00,7.00,889.00,'2023-03-05 14:09:30','',''),(910,'1','311','1',1,'Retail Sale Id 962',1497.60,0.00,0.00,2.08,264.16,'2023-03-05 14:10:19','',''),(911,'1','311','1',1,'Retail Sale Id 963',5040.00,0.00,0.00,7.00,889.00,'2023-03-05 14:23:38','',''),(912,'1','311','1',1,'Retail Sale Id 964',2160.00,0.00,0.00,3.00,381.00,'2023-03-05 14:38:04','',''),(913,'1','311','1',1,'Retail Sale Id 965',720.00,0.00,0.00,1.00,127.00,'2023-03-05 14:41:24','',''),(914,'1','311','1',1,'Retail Sale Id 966',5040.00,0.00,0.00,7.00,889.00,'2023-03-05 15:01:19','',''),(915,'1','311','1',1,'Retail Sale Id 967',6480.00,0.00,0.00,9.00,1143.00,'2023-03-05 15:07:02','',''),(916,'1','311','1',1,'Retail Sale Id 968',5040.00,0.00,0.00,7.00,889.00,'2023-03-05 15:08:37','',''),(917,'1','311','1',1,'Retail Sale Id 969',3600.00,0.00,0.00,5.00,635.00,'2023-03-05 15:14:42','',''),(918,'1','311','1',1,'Retail Sale Id 970',9000.00,0.00,0.00,12.50,1587.50,'2023-03-05 15:15:51','',''),(919,'1','311','1',1,'Retail Sale Id 971',1000.80,0.00,0.00,1.39,176.53,'2023-03-05 15:18:17','',''),(920,'1','311','1',1,'Retail Sale Id 971',1497.60,0.00,0.00,2.08,264.16,'2023-03-05 15:18:17','',''),(921,'1','311','1',1,'Retail Sale Id 972',2160.00,0.00,0.00,3.00,381.00,'2023-03-05 15:19:28','',''),(922,'1','311','1',1,'Retail Sale Id 974',2880.00,0.00,0.00,4.00,508.00,'2023-03-05 15:23:54','',''),(923,'1','311','1',1,'Retail Sale Id 975',4802.40,0.00,0.00,6.67,847.09,'2023-03-05 15:26:02','',''),(924,'1','311','1',1,'Retail Sale Id 973',2160.00,0.00,0.00,3.00,381.00,'2023-03-05 15:27:27','',''),(925,'1','311','1',1,'Return of Retail Sale Id 975',0.00,4802.40,6.67,0.00,-847.09,'2023-03-05 15:31:04','',''),(926,'1','311','1',1,'Retail Sale Id 976',3801.60,0.00,0.00,5.28,670.56,'2023-03-05 15:33:54','',''),(927,'1','311','1',1,'Retail Sale Id 977',9000.00,0.00,0.00,12.50,1587.50,'2023-03-05 15:41:26','',''),(928,'1','311','1',1,'Retail Sale Id 978',1800.00,0.00,0.00,2.50,317.50,'2023-03-05 15:42:29','',''),(929,'1','311','1',1,'Retail Sale Id 979',1000.80,0.00,0.00,1.39,176.53,'2023-03-05 15:47:48','',''),(930,'1','311','1',1,'Retail Sale Id 980',3600.00,0.00,0.00,5.00,635.00,'2023-03-05 16:08:33','',''),(931,'1','311','1',1,'Retail Sale Id 981',4996.80,0.00,0.00,6.94,881.38,'2023-03-05 16:09:37','',''),(932,'1','311','1',1,'Retail Sale Id 982',5040.00,0.00,0.00,7.00,889.00,'2023-03-05 16:11:07','',''),(933,'1','311','1',1,'Retail Sale Id 983',3002.40,0.00,0.00,4.17,529.59,'2023-03-05 16:17:38','',''),(934,'1','311','1',1,'Retail Sale Id 984',5040.00,0.00,0.00,7.00,889.00,'2023-03-05 16:37:06','',''),(935,'1','311','1',1,'Retail Sale Id 985',1800.00,0.00,0.00,2.50,317.50,'2023-03-05 16:41:36','',''),(936,'1','311','1',1,'Retail Sale Id 986',2001.60,0.00,0.00,2.78,353.06,'2023-03-05 16:52:35','',''),(937,'1','311','1',1,'Retail Sale Id 987',2160.00,0.00,0.00,3.00,381.00,'2023-03-05 16:54:32','',''),(938,'1','311','1',1,'Retail Sale Id 988',3002.40,0.00,0.00,4.17,529.59,'2023-03-05 16:57:08','',''),(939,'1','311','1',1,'Retail Sale Id 989',2160.00,0.00,0.00,3.00,381.00,'2023-03-05 16:58:38','',''),(940,'1','311','1',1,'Retail Sale Id 990',4320.00,0.00,0.00,6.00,762.00,'2023-03-05 17:10:44','',''),(941,'1','311','1',1,'Retail Sale Id 991',4320.00,0.00,0.00,6.00,762.00,'2023-03-05 17:11:31','',''),(942,'1','311','1',1,'Retail Sale Id 992',3600.00,0.00,0.00,5.00,635.00,'2023-03-05 17:12:42','',''),(943,'1','311','1',1,'Retail Sale Id 993',5040.00,0.00,0.00,7.00,889.00,'2023-03-05 17:19:37','',''),(944,'1','311','1',1,'Retail Sale Id 994',1497.60,0.00,0.00,2.08,264.16,'2023-03-05 17:26:24','',''),(945,'1','311','1',1,'Retail Sale Id 995',6480.00,0.00,0.00,9.00,1143.00,'2023-03-05 17:28:53','',''),(946,'1','311','1',1,'Retail Sale Id 996',756.00,0.00,0.00,1.05,133.35,'2023-03-05 17:50:28','',''),(947,'1','311','1',1,'Retail Sale Id 997',2167.20,0.00,0.00,3.01,382.27,'2023-03-05 18:07:51','',''),(948,'1','311','1',1,'Retail Sale Id 998',2880.00,0.00,0.00,4.00,508.00,'2023-03-07 08:17:30','',''),(949,'1','311','1',1,'Retail Sale Id 999',2001.60,0.00,0.00,2.78,353.06,'2023-03-07 08:18:34','',''),(950,'1','311','1',1,'Retail Sale Id 1000',1000.80,0.00,0.00,1.39,176.53,'2023-03-07 08:19:39','',''),(951,'1','311','1',1,'Retail Sale Id 1001',9000.00,0.00,0.00,12.50,1587.50,'2023-03-07 08:20:26','',''),(952,'1','311','1',1,'Retail Sale Id 1002',5040.00,0.00,0.00,7.00,889.00,'2023-03-07 08:21:37','',''),(953,'1','311','1',1,'Retail Sale Id 1003',2880.00,0.00,0.00,4.00,508.00,'2023-03-07 08:24:23','',''),(954,'1','311','1',1,'Retail Sale Id 1004',4320.00,0.00,0.00,6.00,762.00,'2023-03-07 08:29:33','',''),(955,'1','311','1',1,'Retail Sale Id 1005',2880.00,0.00,0.00,4.00,508.00,'2023-03-07 08:30:45','',''),(956,'1','311','1',1,'Retail Sale Id 1006',4320.00,0.00,0.00,6.00,762.00,'2023-03-07 08:32:15','',''),(957,'1','311','1',1,'Retail Sale Id 1007',9000.00,0.00,0.00,12.50,1587.50,'2023-03-07 08:56:20','',''),(958,'1','311','1',1,'Retail Sale Id 1008',1440.00,0.00,0.00,2.00,254.00,'2023-03-07 08:58:05','',''),(959,'1','311','1',1,'Retail Sale Id 1008',9000.00,0.00,0.00,12.50,1587.50,'2023-03-07 08:58:05','',''),(960,'1','311','1',1,'Retail Sale Id 1009',3002.40,0.00,0.00,4.17,529.59,'2023-03-07 08:59:28','',''),(961,'1','311','1',1,'Retail Sale Id 1011',1497.60,0.00,0.00,2.08,264.16,'2023-03-07 09:06:49','',''),(962,'1','311','1',1,'Retail Sale Id 1012',1440.00,0.00,0.00,2.00,254.00,'2023-03-07 09:22:36','',''),(963,'1','311','1',1,'Retail Sale Id 1013',1440.00,0.00,0.00,2.00,254.00,'2023-03-07 09:30:54','',''),(964,'1','311','1',1,'Retail Sale Id 1013',1440.00,0.00,0.00,2.00,254.00,'2023-03-07 09:30:54','',''),(965,'1','311','1',1,'Retail Sale Id 1013',3600.00,0.00,0.00,5.00,635.00,'2023-03-07 09:30:54','',''),(966,'1','311','1',1,'Retail Sale Id 1014',9000.00,0.00,0.00,12.50,1587.50,'2023-03-07 09:32:13','',''),(967,'1','311','1',1,'Retail Sale Id 1015',2160.00,0.00,0.00,3.00,381.00,'2023-03-07 09:39:53','',''),(968,'1','311','1',1,'Return of Retail Sale Id 1015',0.00,2160.00,3.00,0.00,-381.00,'2023-03-07 09:45:23','',''),(969,'1','311','1',1,'Retail Sale Id 1016',2160.00,0.00,0.00,3.00,381.00,'2023-03-07 09:46:48','',''),(970,'1','311','1',1,'Retail Sale Id 1017',4680.00,0.00,0.00,6.50,825.50,'2023-03-07 09:53:41','',''),(971,'1','311','1',1,'Retail Sale Id 1019',1000.80,0.00,0.00,1.39,176.53,'2023-03-07 10:17:38','',''),(972,'1','311','1',1,'Retail Sale Id 1020',4680.00,0.00,0.00,6.50,825.50,'2023-03-07 10:19:46','',''),(973,'1','311','1',1,'Retail Sale Id 1021',4320.00,0.00,0.00,6.00,762.00,'2023-03-07 10:23:58','',''),(974,'1','311','1',1,'Retail Sale Id 1022',1396.80,0.00,0.00,1.94,246.38,'2023-03-07 10:27:47','',''),(975,'1','311','1',1,'Retail Sale Id 1024',5040.00,0.00,0.00,7.00,889.00,'2023-03-07 10:36:51','',''),(976,'1','311','1',1,'Retail Sale Id 1018',4320.00,0.00,0.00,6.00,762.00,'2023-03-07 10:56:35','',''),(977,'1','311','1',1,'Retail Sale Id 1026',2160.00,0.00,0.00,3.00,381.00,'2023-03-07 11:16:24','',''),(978,'1','311','1',1,'Retail Sale Id 1027',136000.00,0.00,0.00,200.00,17400.00,'2023-03-07 12:03:18','',''),(979,'1','311','1',1,'Retail Sale Id 1028',2160.00,0.00,0.00,3.00,381.00,'2023-03-07 12:07:03','',''),(980,'1','311','1',1,'Retail Sale Id 1029',2498.40,0.00,0.00,3.47,440.69,'2023-03-07 12:10:04','',''),(981,'1','311','1',1,'Retail Sale Id 1030',1080.00,0.00,0.00,1.50,190.50,'2023-03-07 12:11:46','',''),(982,'1','311','1',1,'Retail Sale Id 1031',4320.00,0.00,0.00,6.00,762.00,'2023-03-07 12:15:55','',''),(983,'1','311','1',1,'Retail Sale Id 1032',5040.00,0.00,0.00,7.00,889.00,'2023-03-07 12:17:06','',''),(984,'1','311','1',1,'Retail Sale Id 1033',4320.00,0.00,0.00,6.00,762.00,'2023-03-07 12:17:59','',''),(985,'1','311','1',1,'Retail Sale Id 1034',4320.00,0.00,0.00,6.00,762.00,'2023-03-07 12:18:48','',''),(986,'1','311','1',1,'Return of Retail Sale Id 1030',0.00,1080.00,1.50,0.00,-190.50,'2023-03-07 12:19:24','',''),(987,'1','311','1',1,'Retail Sale Id 1035',1080.00,0.00,0.00,1.50,190.50,'2023-03-07 12:20:19','',''),(988,'1','311','1',1,'Retail Sale Id 1036',544000.00,0.00,0.00,800.00,69600.00,'2023-03-07 12:31:41','',''),(989,'1','311','1',1,'Retail Sale Id 1037',1440.00,0.00,0.00,2.00,254.00,'2023-03-07 13:05:38','',''),(990,'1','311','1',1,'Retail Sale Id 1038',85999.60,0.00,0.00,126.47,11002.89,'2023-03-07 13:07:41','',''),(991,'1','311','1',1,'Retail Sale Id 1039',3600.00,0.00,0.00,5.00,635.00,'2023-03-07 13:13:54','',''),(992,'1','311','1',1,'Return of Retail Sale Id 1038',0.00,85999.60,126.47,0.00,-11002.89,'2023-03-07 13:18:03','',''),(993,'1','311','1',1,'Retail Sale Id 1040',85000.00,0.00,0.00,125.00,10875.00,'2023-03-07 13:19:07','',''),(994,'1','311','1',1,'Retail Sale Id 1041',1440.00,0.00,0.00,2.00,254.00,'2023-03-07 13:48:53','',''),(995,'1','311','1',1,'Return of Retail Sale Id 1041',0.00,1440.00,2.00,0.00,-254.00,'2023-03-07 13:53:24','',''),(996,'1','311','1',1,'Retail Sale Id 1042',2001.60,0.00,0.00,2.78,353.06,'2023-03-07 13:54:16','',''),(997,'1','311','1',1,'Retail Sale Id 1043',2001.60,0.00,0.00,2.78,353.06,'2023-03-07 14:17:27','',''),(998,'1','311','1',1,'Retail Sale Id 1044',8697.60,0.00,0.00,12.08,1534.16,'2023-03-07 14:37:35','',''),(999,'1','311','1',1,'Retail Sale Id 1045',1440.00,0.00,0.00,2.00,254.00,'2023-03-07 14:38:32','',''),(1000,'1','311','1',1,'Retail Sale Id 1046',3600.00,0.00,0.00,5.00,635.00,'2023-03-07 14:48:53','',''),(1001,'1','311','1',1,'Retail Sale Id 1047',3002.40,0.00,0.00,4.17,529.59,'2023-03-07 15:00:17','',''),(1002,'1','311','1',1,'Retail Sale Id 1048',2800.80,0.00,0.00,3.89,494.03,'2023-03-07 15:46:48','',''),(1003,'1','311','1',1,'Retail Sale Id 1054',3002.40,0.00,0.00,4.17,529.59,'2023-03-07 15:50:20','',''),(1004,'1','311','1',1,'Retail Sale Id 1055',3002.40,0.00,0.00,4.17,529.59,'2023-03-07 15:51:13','',''),(1005,'1','311','1',1,'Retail Sale Id 1056',3002.40,0.00,0.00,4.17,529.59,'2023-03-07 15:56:45','',''),(1006,'1','311','1',1,'Retail Sale Id 1057',2001.60,0.00,0.00,2.78,353.06,'2023-03-07 16:03:34','',''),(1007,'1','311','1',1,'Retail Sale Id 1058',7200.00,0.00,0.00,10.00,1270.00,'2023-03-07 16:05:02','',''),(1008,'1','311','1',1,'Retail Sale Id 1059',81600.00,0.00,0.00,120.00,10440.00,'2023-03-07 16:11:20','',''),(1009,'1','311','1',1,'Retail Sale Id 1060',2160.00,0.00,0.00,3.00,381.00,'2023-03-07 16:15:00','',''),(1010,'1','311','1',1,'Retail Sale Id 1061',7200.00,0.00,0.00,10.00,1270.00,'2023-03-07 16:15:53','',''),(1011,'1','311','1',1,'Retail Sale Id 1062',2160.00,0.00,0.00,3.00,381.00,'2023-03-07 16:16:51','',''),(1012,'1','311','1',1,'Retail Sale Id 1063',1440.00,0.00,0.00,2.00,254.00,'2023-03-07 16:18:10','',''),(1013,'1','311','1',1,'Retail Sale Id 1063',2160.00,0.00,0.00,3.00,381.00,'2023-03-07 16:18:10','',''),(1014,'1','311','1',1,'Return of Retail Sale Id 1058',0.00,7200.00,10.00,0.00,-1270.00,'2023-03-07 16:20:29','',''),(1015,'1','311','1',1,'Retail Sale Id 1065',720.00,0.00,0.00,1.00,127.00,'2023-03-07 16:29:34','',''),(1016,'1','311','1',1,'Retail Sale Id 1066',4003.20,0.00,0.00,5.56,706.12,'2023-03-07 16:35:38','',''),(1017,'1','311','1',1,'Retail Sale Id 1067',1497.60,0.00,0.00,2.08,264.16,'2023-03-07 16:37:19','',''),(1018,'1','311','1',1,'Return of Retail Sale Id 1067',0.00,1497.60,2.08,0.00,-264.16,'2023-03-07 16:38:26','',''),(1019,'1','311','1',1,'Retail Sale Id 1068',1396.80,0.00,0.00,1.94,246.38,'2023-03-07 16:38:59','',''),(1020,'1','311','1',1,'Retail Sale Id 1070',2160.00,0.00,0.00,3.00,381.00,'2023-03-07 16:45:58','',''),(1021,'1','311','1',1,'Retail Sale Id 1071',3002.40,0.00,0.00,4.17,529.59,'2023-03-07 16:47:33','',''),(1022,'1','311','1',1,'Retail Sale Id 1072',2520.00,0.00,0.00,3.50,444.50,'2023-03-07 16:48:37','',''),(1023,'1','311','1',1,'Retail Sale Id 1073',3002.40,0.00,0.00,4.17,529.59,'2023-03-07 16:49:23','',''),(1024,'1','311','1',1,'Retail Sale Id 1074',2160.00,0.00,0.00,3.00,381.00,'2023-03-07 16:50:44','',''),(1025,'1','311','1',1,'Retail Sale Id 1075',3600.00,0.00,0.00,5.00,635.00,'2023-03-07 16:59:17','',''),(1026,'1','311','1',1,'Retail Sale Id 1076',2001.60,0.00,0.00,2.78,353.06,'2023-03-07 17:00:28','',''),(1027,'1','311','1',1,'Retail Sale Id 1077',2160.00,0.00,0.00,3.00,381.00,'2023-03-07 17:02:03','',''),(1028,'1','311','1',1,'Retail Sale Id 1078',2880.00,0.00,0.00,4.00,508.00,'2023-03-07 17:04:08','',''),(1029,'1','311','1',1,'Retail Sale Id 1080',3600.00,0.00,0.00,5.00,635.00,'2023-03-07 17:05:43','',''),(1030,'1','311','1',1,'Retail Sale Id 1081',3600.00,0.00,0.00,5.00,635.00,'2023-03-07 17:06:39','',''),(1031,'1','311','1',1,'Retail Sale Id 1082',3600.00,0.00,0.00,5.00,635.00,'2023-03-07 17:07:35','',''),(1032,'1','311','1',1,'Retail Sale Id 1084',1440.00,0.00,0.00,2.00,254.00,'2023-03-07 17:11:53','',''),(1033,'1','311','1',1,'Retail Sale Id 1085',4320.00,0.00,0.00,6.00,762.00,'2023-03-07 17:13:43','',''),(1034,'1','311','1',1,'Retail Sale Id 1086',1440.00,0.00,0.00,2.00,254.00,'2023-03-07 17:14:40','',''),(1035,'1','311','1',1,'Retail Sale Id 1087',7200.00,0.00,0.00,10.00,1270.00,'2023-03-07 17:15:25','',''),(1036,'1','311','1',1,'Return of Retail Sale Id 1072',0.00,2520.00,3.50,0.00,-444.50,'2023-03-07 17:19:40','',''),(1037,'1','311','1',1,'Retail Sale Id 1089',2160.00,0.00,0.00,3.00,381.00,'2023-03-07 17:21:05','',''),(1038,'1','311','1',1,'Retail Sale Id 1089',9000.00,0.00,0.00,12.50,1587.50,'2023-03-07 17:21:05','',''),(1039,'1','311','1',1,'Retail Sale Id 1090',2880.00,0.00,0.00,4.00,508.00,'2023-03-07 17:22:14','',''),(1040,'1','311','1',1,'Retail Sale Id 1092',4320.00,0.00,0.00,6.00,762.00,'2023-03-07 17:31:08','',''),(1041,'1','311','1',1,'Retail Sale Id 1093',2160.00,0.00,0.00,3.00,381.00,'2023-03-07 17:34:58','',''),(1042,'1','311','1',1,'Retail Sale Id 1094',2160.00,0.00,0.00,3.00,381.00,'2023-03-07 17:36:31','',''),(1043,'1','311','1',1,'Retail Sale Id 1095',1440.00,0.00,0.00,2.00,254.00,'2023-03-07 17:38:38','',''),(1044,'1','311','1',1,'Retail Sale Id 1096',720.00,0.00,0.00,1.00,127.00,'2023-03-07 20:08:21','',''),(1045,'1','311','1',1,'Return of Retail Sale Id 1096',0.00,720.00,1.00,0.00,-127.00,'2023-03-07 20:10:36','',''),(1046,'1','311','1',1,'Retail Sale Id 1097',842.40,0.00,0.00,1.17,148.59,'2023-03-07 20:12:08','',''),(1047,'1','311','1',1,'Retail Sale Id 1098',4320.00,0.00,0.00,6.00,762.00,'2023-03-08 10:53:29','',''),(1048,'1','311','1',1,'Retail Sale Id 1099',2203.20,0.00,0.00,3.06,388.62,'2023-03-08 11:02:21','',''),(1049,'1','311','1',1,'Retail Sale Id 1101',2001.60,0.00,0.00,2.78,353.06,'2023-03-08 11:26:40','',''),(1050,'1','311','1',1,'Retail Sale Id 1103',2880.00,0.00,0.00,4.00,508.00,'2023-03-08 11:28:51','',''),(1051,'1','311','1',1,'Retail Sale Id 1104',7200.00,0.00,0.00,10.00,1270.00,'2023-03-08 11:37:06','',''),(1052,'1','311','1',1,'Retail Sale Id 1104',7200.00,0.00,0.00,10.00,1270.00,'2023-03-08 11:37:06','',''),(1053,'1','311','1',1,'Retail Sale Id 1102',9000.00,0.00,0.00,12.50,1587.50,'2023-03-08 11:38:17','',''),(1054,'1','311','1',1,'Retail Sale Id 1105',2160.00,0.00,0.00,3.00,381.00,'2023-03-08 11:56:54','',''),(1055,'1','311','1',1,'Retail Sale Id 1106',3600.00,0.00,0.00,5.00,635.00,'2023-03-08 11:59:01','',''),(1056,'1','311','1',1,'Retail Sale Id 1107',3002.40,0.00,0.00,4.17,529.59,'2023-03-08 12:29:48','',''),(1057,'1','311','1',1,'Retail Sale Id 1108',3002.40,0.00,0.00,4.17,529.59,'2023-03-08 12:46:23','',''),(1058,'1','311','1',1,'Retail Sale Id 1109',4003.20,0.00,0.00,5.56,706.12,'2023-03-08 13:00:15','',''),(1059,'1','311','1',1,'Retail Sale Id 1110',4320.00,0.00,0.00,6.00,762.00,'2023-03-08 13:07:43','',''),(1060,'1','311','1',1,'Retail Sale Id 1111',3600.00,0.00,0.00,5.00,635.00,'2023-03-08 13:12:42','',''),(1061,'1','311','1',1,'Retail Sale Id 1113',2880.00,0.00,0.00,4.00,508.00,'2023-03-08 13:15:46','',''),(1062,'1','311','1',1,'Retail Sale Id 1114',2160.00,0.00,0.00,3.00,381.00,'2023-03-08 13:22:51','',''),(1063,'1','311','1',1,'Retail Sale Id 1115',4003.20,0.00,0.00,5.56,706.12,'2023-03-08 13:48:19','',''),(1064,'1','311','1',1,'Retail Sale Id 1116',720.00,0.00,0.00,1.00,127.00,'2023-03-08 13:49:43','',''),(1065,'1','311','1',1,'Retail Sale Id 1117',3600.00,0.00,0.00,5.00,635.00,'2023-03-08 13:54:40','',''),(1066,'1','311','1',1,'Retail Sale Id 1118',2880.00,0.00,0.00,4.00,508.00,'2023-03-08 14:12:17','',''),(1067,'1','311','1',1,'Return of Retail Sale Id 1118',0.00,2880.00,4.00,0.00,-508.00,'2023-03-08 14:14:36','',''),(1068,'1','311','1',1,'Retail Sale Id 1119',1440.00,0.00,0.00,2.00,254.00,'2023-03-08 14:15:17','',''),(1069,'1','311','1',1,'Retail Sale Id 1120',12657.60,0.00,0.00,17.58,2232.66,'2023-03-08 14:16:33','',''),(1070,'1','311','1',1,'Retail Sale Id 1121',2160.00,0.00,0.00,3.00,381.00,'2023-03-08 14:18:47','',''),(1071,'1','311','1',1,'Retail Sale Id 1122',25200.00,0.00,0.00,35.00,4445.00,'2023-03-08 14:21:56','',''),(1072,'1','311','1',1,'Retail Sale Id 1123',5040.00,0.00,0.00,7.00,889.00,'2023-03-08 14:24:17','',''),(1073,'1','311','1',1,'Retail Sale Id 1124',7228.80,0.00,0.00,10.04,1275.08,'2023-03-08 14:27:13','',''),(1074,'1','311','1',1,'Retail Sale Id 1125',5760.00,0.00,0.00,8.00,1016.00,'2023-03-08 14:29:42','',''),(1075,'1','311','1',1,'Retail Sale Id 1126',6501.60,0.00,0.00,9.03,1146.81,'2023-03-08 14:32:04','',''),(1076,'1','311','1',1,'Retail Sale Id 1127',9000.00,0.00,0.00,12.50,1587.50,'2023-03-08 14:35:12','',''),(1077,'1','311','1',1,'Retail Sale Id 1127',9000.00,0.00,0.00,12.50,1587.50,'2023-03-08 14:35:12','',''),(1078,'1','311','1',1,'Retail Sale Id 1128',3600.00,0.00,0.00,5.00,635.00,'2023-03-08 14:37:52','',''),(1079,'1','311','1',1,'Retail Sale Id 1128',10800.00,0.00,0.00,15.00,1905.00,'2023-03-08 14:37:52','',''),(1080,'1','311','1',1,'Retail Sale Id 1130',1440.00,0.00,0.00,2.00,254.00,'2023-03-08 15:08:06','',''),(1081,'1','311','1',1,'Retail Sale Id 1131',9000.00,0.00,0.00,12.50,1587.50,'2023-03-08 15:10:34','',''),(1082,'1','311','1',1,'Retail Sale Id 1132',1497.60,0.00,0.00,2.08,264.16,'2023-03-08 15:37:08','',''),(1083,'1','311','1',1,'Retail Sale Id 1133',2160.00,0.00,0.00,3.00,381.00,'2023-03-08 15:38:41','',''),(1084,'1','311','1',1,'Retail Sale Id 1134',1497.60,0.00,0.00,2.08,264.16,'2023-03-08 15:40:59','',''),(1085,'1','311','1',1,'Retail Sale Id 1135',2160.00,0.00,0.00,3.00,381.00,'2023-03-08 15:41:55','',''),(1086,'1','311','1',1,'Retail Sale Id 1136',1497.60,0.00,0.00,2.08,264.16,'2023-03-08 15:53:24','',''),(1087,'1','311','1',1,'Retail Sale Id 1137',4320.00,0.00,0.00,6.00,762.00,'2023-03-08 16:04:37','',''),(1088,'1','311','1',1,'Retail Sale Id 1138',2160.00,0.00,0.00,3.00,381.00,'2023-03-08 16:11:02','',''),(1089,'1','311','1',1,'Retail Sale Id 1139',1440.00,0.00,0.00,2.00,254.00,'2023-03-08 16:29:05','',''),(1090,'1','311','1',1,'Retail Sale Id 1140',8640.00,0.00,0.00,12.00,1524.00,'2023-03-08 16:39:51','',''),(1091,'1','311','1',1,'Retail Sale Id 1141',3600.00,0.00,0.00,5.00,635.00,'2023-03-08 16:43:43','',''),(1092,'1','311','1',1,'Retail Sale Id 1142',4320.00,0.00,0.00,6.00,762.00,'2023-03-08 16:44:47','',''),(1093,'1','311','1',1,'Retail Sale Id 1143',2160.00,0.00,0.00,3.00,381.00,'2023-03-08 16:45:43','',''),(1094,'1','311','1',1,'Retail Sale Id 1144',3002.40,0.00,0.00,4.17,529.59,'2023-03-08 16:46:43','',''),(1095,'1','311','1',1,'Retail Sale Id 1146',2296.80,0.00,0.00,3.19,405.13,'2023-03-08 16:49:34','',''),(1096,'1','311','1',1,'Retail Sale Id 1147',2160.00,0.00,0.00,3.00,381.00,'2023-03-08 16:55:18','',''),(1097,'1','311','1',1,'Retail Sale Id 1148',720.00,0.00,0.00,1.00,127.00,'2023-03-08 16:57:55','',''),(1098,'1','311','1',1,'Retail Sale Id 1149',2001.60,0.00,0.00,2.78,353.06,'2023-03-08 16:59:14','',''),(1099,'1','311','1',1,'Retail Sale Id 1150',1000.80,0.00,0.00,1.39,176.53,'2023-03-08 17:01:00','',''),(1100,'1','311','1',1,'Retail Sale Id 1152',1000.80,0.00,0.00,1.39,176.53,'2023-03-08 17:06:18','',''),(1101,'1','311','1',1,'Retail Sale Id 1153',5040.00,0.00,0.00,7.00,889.00,'2023-03-08 17:10:03','',''),(1102,'1','311','1',1,'Return of Retail Sale Id 1104',0.00,7200.00,10.00,0.00,-1270.00,'2023-03-08 17:35:04','',''),(1103,'1','311','1',1,'Return of Retail Sale Id 1104',0.00,7200.00,10.00,0.00,-1270.00,'2023-03-08 17:35:04','',''),(1104,'1','311','1',1,'Retail Sale Id 1154',10080.00,0.00,0.00,14.00,1778.00,'2023-03-08 17:35:54','',''),(1105,'1','311','1',1,'Retail Sale Id 1155',4320.00,0.00,0.00,6.00,762.00,'2023-03-08 17:36:39','',''),(1106,'1','311','1',1,'Retail Sale Id 1156',3498.30,0.00,0.00,5.07,491.79,'2023-03-09 09:16:38','',''),(1107,'1','311','1',1,'Retail Sale Id 1158',4140.00,0.00,0.00,6.00,582.00,'2023-03-09 09:18:55','',''),(1108,'1','311','1',1,'Retail Sale Id 1159',3450.00,0.00,0.00,5.00,485.00,'2023-03-09 09:20:31','',''),(1109,'1','311','1',1,'Retail Sale Id 1160',1918.20,0.00,0.00,2.78,269.66,'2023-03-09 09:23:24','',''),(1110,'1','311','1',1,'Retail Sale Id 1161',2070.00,0.00,0.00,3.00,291.00,'2023-03-09 09:24:34','',''),(1111,'1','311','1',1,'Retail Sale Id 1162',4830.00,0.00,0.00,7.00,679.00,'2023-03-09 09:25:26','',''),(1112,'1','311','1',1,'Retail Sale Id 1163',2870.40,0.00,0.00,4.16,403.52,'2023-03-09 09:26:58','',''),(1113,'1','311','1',1,'Retail Sale Id 1164',1380.00,0.00,0.00,2.00,194.00,'2023-03-09 09:27:44','',''),(1114,'1','311','1',1,'Retail Sale Id 1165',1911.30,0.00,0.00,2.77,268.69,'2023-03-09 09:29:12','',''),(1115,'1','311','1',1,'Retail Sale Id 1166',4140.00,0.00,0.00,6.00,582.00,'2023-03-09 09:31:07','',''),(1116,'1','311','1',1,'Retail Sale Id 1167',4140.00,0.00,0.00,6.00,582.00,'2023-03-09 09:32:07','',''),(1117,'1','311','1',1,'Retail Sale Id 1168',2760.00,0.00,0.00,4.00,388.00,'2023-03-09 09:32:57','',''),(1118,'1','311','1',1,'Retail Sale Id 1169',2394.30,0.00,0.00,3.47,336.59,'2023-03-09 09:34:25','',''),(1119,'1','311','1',1,'Retail Sale Id 1170',4140.00,0.00,0.00,6.00,582.00,'2023-03-09 09:35:45','',''),(1120,'1','311','1',1,'Retail Sale Id 1171',6900.00,0.00,0.00,10.00,970.00,'2023-03-09 09:36:39','',''),(1121,'1','311','1',1,'Retail Sale Id 1172',2870.40,0.00,0.00,4.16,403.52,'2023-03-09 09:37:57','',''),(1122,'1','311','1',1,'Retail Sale Id 1173',2070.00,0.00,0.00,3.00,291.00,'2023-03-09 09:39:35','',''),(1123,'1','311','1',1,'Return of Retail Sale Id 1163',0.00,2870.40,4.16,0.00,-403.52,'2023-03-09 14:21:40','',''),(1124,'1','311','1',1,'Return of Retail Sale Id 1172',0.00,2870.40,4.16,0.00,-403.52,'2023-03-09 14:22:48','',''),(1125,'1','311','1',1,'Return of Retail Sale Id 1169',0.00,2394.30,3.47,0.00,-336.59,'2023-03-09 14:24:39','',''),(1126,'1','311','1',1,'Return of Retail Sale Id 1165',0.00,1911.30,2.77,0.00,-268.69,'2023-03-09 14:25:25','',''),(1127,'1','311','1',1,'Retail Sale Id 1174',8625.00,0.00,0.00,12.50,1212.50,'2023-03-09 14:28:43','',''),(1128,'1','311','1',1,'Retail Sale Id 1175',1442.10,0.00,0.00,2.09,202.73,'2023-03-09 14:30:49','',''),(1129,'1','311','1',1,'Retail Sale Id 1176',2070.00,0.00,0.00,3.00,291.00,'2023-03-09 14:33:20','',''),(1130,'1','311','1',1,'Retail Sale Id 1177',3450.00,0.00,0.00,5.00,485.00,'2023-03-09 14:38:39','',''),(1131,'1','311','1',1,'Retail Sale Id 1178',7590.00,0.00,0.00,11.00,1067.00,'2023-03-09 14:40:08','',''),(1132,'1','311','1',1,'Retail Sale Id 1179',8280.00,0.00,0.00,12.00,1164.00,'2023-03-09 14:41:27','',''),(1133,'1','311','1',1,'Retail Sale Id 1180',3091.20,0.00,0.00,4.48,434.56,'2023-03-09 14:45:49','',''),(1134,'1','311','1',1,'Retail Sale Id 1181',2760.00,0.00,0.00,4.00,388.00,'2023-03-09 14:46:55','',''),(1135,'1','311','1',1,'Retail Sale Id 1182',5727.00,0.00,0.00,8.30,805.10,'2023-03-09 14:48:19','',''),(1136,'1','311','1',1,'Retail Sale Id 1183',3450.00,0.00,0.00,5.00,485.00,'2023-03-09 14:48:57','',''),(1137,'1','311','1',1,'Retail Sale Id 1184',6900.00,0.00,0.00,10.00,970.00,'2023-03-09 14:50:57','',''),(1138,'1','311','1',1,'Retail Sale Id 1185',3795.00,0.00,0.00,5.50,533.50,'2023-03-09 14:53:11','',''),(1139,'1','311','1',1,'Retail Sale Id 1186',8625.00,0.00,0.00,12.50,1212.50,'2023-03-09 14:56:38','',''),(1140,'1','311','1',1,'Retail Sale Id 1187',6900.00,0.00,0.00,10.00,970.00,'2023-03-09 15:00:47','',''),(1141,'1','311','1',1,'Retail Sale Id 1187',8625.00,0.00,0.00,12.50,1212.50,'2023-03-09 15:00:47','',''),(1142,'1','311','1',1,'Retail Sale Id 1188',6210.00,0.00,0.00,9.00,873.00,'2023-03-09 15:01:32','',''),(1143,'1','311','1',1,'Retail Sale Id 1189',6900.00,0.00,0.00,10.00,970.00,'2023-03-09 15:03:08','',''),(1144,'1','311','1',1,'Retail Sale Id 1190',6900.00,0.00,0.00,10.00,970.00,'2023-03-09 15:03:57','',''),(1145,'1','311','1',1,'Retail Sale Id 1191',4140.00,0.00,0.00,6.00,582.00,'2023-03-09 16:48:09','',''),(1146,'1','311','1',1,'Retail Sale Id 1192',10350.00,0.00,0.00,15.00,1455.00,'2023-03-09 16:49:47','',''),(1147,'1','311','1',1,'Retail Sale Id 1193',5520.00,0.00,0.00,8.00,776.00,'2023-03-09 16:51:02','',''),(1148,'1','311','1',1,'Retail Sale Id 1194',2801.40,0.00,0.00,4.06,393.82,'2023-03-09 17:02:20','',''),(1149,'1','311','1',1,'Retail Sale Id 1195',4485.00,0.00,0.00,6.50,630.50,'2023-03-09 17:06:03','',''),(1150,'1','311','1',1,'Retail Sale Id 1196',4140.00,0.00,0.00,6.00,582.00,'2023-03-09 17:07:15','',''),(1151,'1','311','1',1,'Retail Sale Id 1197',6900.00,0.00,0.00,10.00,970.00,'2023-03-09 17:08:15','',''),(1152,'1','311','1',1,'Retail Sale Id 1198',8625.00,0.00,0.00,12.50,1212.50,'2023-03-09 17:09:10','',''),(1153,'1','311','1',1,'Retail Sale Id 1199',496.80,0.00,0.00,0.72,69.84,'2023-03-09 17:11:33','',''),(1154,'1','311','1',1,'Retail Sale Id 1200',4830.00,0.00,0.00,7.00,679.00,'2023-03-09 17:12:22','',''),(1155,'1','311','1',1,'Retail Sale Id 1201',1380.00,0.00,0.00,2.00,194.00,'2023-03-09 17:12:57','',''),(1156,'1','311','1',1,'Retail Sale Id 1202',8625.00,0.00,0.00,12.50,1212.50,'2023-03-09 17:49:03','',''),(1157,'1','311','1',1,'Retail Sale Id 1203',2070.00,0.00,0.00,3.00,291.00,'2023-03-09 17:49:46','',''),(1158,'1','311','1',1,'Retail Sale Id 1204',1800.90,0.00,0.00,2.61,253.17,'2023-03-09 17:51:20','',''),(1159,'1','311','1',1,'Retail Sale Id 1205',8625.00,0.00,0.00,12.50,1212.50,'2023-03-09 17:56:01','',''),(1160,'1','311','1',1,'Retail Sale Id 1207',7797.00,0.00,0.00,11.30,1096.10,'2023-03-09 18:00:08','',''),(1161,'1','311','1',1,'Retail Sale Id 1208',8625.00,0.00,0.00,12.50,1212.50,'2023-03-09 18:01:21','',''),(1162,'1','311','1',1,'Retail Sale Id 1210',8121.30,0.00,0.00,11.77,1141.69,'2023-03-09 18:11:46','',''),(1163,'1','311','1',1,'Retail Sale Id 1211',2070.00,0.00,0.00,3.00,291.00,'2023-03-09 18:25:11','',''),(1164,'1','311','1',1,'Return of Retail Sale Id 1160',0.00,1918.20,2.78,0.00,-269.66,'2023-03-09 18:26:13','',''),(1165,'1','311','1',1,'Retail Sale Id 1212',4140.00,0.00,0.00,6.00,582.00,'2023-03-10 07:54:21','',''),(1166,'1','311','1',1,'Retail Sale Id 1213',4140.00,0.00,0.00,6.00,582.00,'2023-03-10 08:04:09','',''),(1167,'1','311','1',1,'Retail Sale Id 1214',8280.00,0.00,0.00,12.00,1164.00,'2023-03-10 08:05:44','',''),(1168,'1','311','1',1,'Retail Sale Id 1215',1380.00,0.00,0.00,2.00,194.00,'2023-03-10 08:07:11','',''),(1169,'1','311','1',1,'Retail Sale Id 1216',4485.00,0.00,0.00,6.50,630.50,'2023-03-10 08:09:34','',''),(1170,'1','311','1',1,'Retail Sale Id 1217',2760.00,0.00,0.00,4.00,388.00,'2023-03-10 08:35:15','',''),(1171,'1','311','1',1,'Retail Sale Id 1218',2760.00,0.00,0.00,4.00,388.00,'2023-03-10 08:51:10','',''),(1172,'1','311','1',1,'Retail Sale Id 1219',4002.00,0.00,0.00,5.80,562.60,'2023-03-10 08:56:53','',''),(1173,'1','311','1',1,'Retail Sale Id 1220',2070.00,0.00,0.00,3.00,291.00,'2023-03-10 09:15:18','',''),(1174,'1','311','1',1,'Retail Sale Id 1221',8625.00,0.00,0.00,12.50,1212.50,'2023-03-10 09:17:05','',''),(1175,'1','311','1',1,'Retail Sale Id 1222',4140.00,0.00,0.00,6.00,582.00,'2023-03-10 09:18:38','',''),(1176,'1','311','1',1,'Retail Sale Id 1222',5520.00,0.00,0.00,8.00,776.00,'2023-03-10 09:18:38','',''),(1177,'1','311','1',1,'Retail Sale Id 1223',2760.00,0.00,0.00,4.00,388.00,'2023-03-10 09:20:10','',''),(1178,'1','311','1',1,'Retail Sale Id 1224',3450.00,0.00,0.00,5.00,485.00,'2023-03-10 09:31:47','',''),(1179,'1','311','1',1,'Retail Sale Id 1225',2070.00,0.00,0.00,3.00,291.00,'2023-03-10 09:34:48','',''),(1180,'1','311','1',1,'Retail Sale Id 1226',2070.00,0.00,0.00,3.00,291.00,'2023-03-10 09:40:32','',''),(1181,'1','311','1',1,'Retail Sale Id 1227',3001.50,0.00,0.00,4.35,421.95,'2023-03-10 09:49:44','',''),(1182,'1','311','1',1,'Retail Sale Id 1228',3450.00,0.00,0.00,5.00,485.00,'2023-03-10 09:56:28','',''),(1183,'1','311','1',1,'Retail Sale Id 1229',5520.00,0.00,0.00,8.00,776.00,'2023-03-10 10:10:05','',''),(1184,'1','311','1',1,'Retail Sale Id 1230',2001.00,0.00,0.00,2.90,281.30,'2023-03-10 10:32:18','',''),(1185,'1','311','1',1,'Retail Sale Id 1231',1497.30,0.00,0.00,2.17,210.49,'2023-03-10 10:34:04','',''),(1186,'1','311','1',1,'Retail Sale Id 1233',4485.00,0.00,0.00,6.50,630.50,'2023-03-10 10:38:34','',''),(1187,'1','311','1',1,'Retail Sale Id 1234',690.00,0.00,0.00,1.00,97.00,'2023-03-10 10:39:30','',''),(1188,'1','311','1',1,'Retail Sale Id 1235',5520.00,0.00,0.00,8.00,776.00,'2023-03-10 10:55:59','',''),(1189,'1','311','1',1,'Retail Sale Id 1236',3601.80,0.00,0.00,5.22,506.34,'2023-03-10 10:57:54','',''),(1190,'1','311','1',1,'Retail Sale Id 1237',7245.00,0.00,0.00,10.50,1018.50,'2023-03-10 11:09:39','',''),(1191,'1','311','1',1,'Retail Sale Id 1240',3001.50,0.00,0.00,4.35,421.95,'2023-03-10 11:29:40','',''),(1192,'1','311','1',1,'Retail Sale Id 1239',4140.00,0.00,0.00,6.00,582.00,'2023-03-10 11:30:52','',''),(1193,'1','311','1',1,'Retail Sale Id 1239',8970.00,0.00,0.00,13.00,1261.00,'2023-03-10 11:30:52','',''),(1194,'1','311','1',1,'Retail Sale Id 1241',2070.00,0.00,0.00,3.00,291.00,'2023-03-10 11:47:08','',''),(1195,'1','311','1',1,'Retail Sale Id 1242',3450.00,0.00,0.00,5.00,485.00,'2023-03-10 12:04:26','',''),(1196,'1','311','1',1,'Retail Sale Id 1243',77720.00,0.00,0.00,116.00,8932.00,'2023-03-10 12:05:56','',''),(1197,'1','311','1',1,'Retail Sale Id 1244',5520.00,0.00,0.00,8.00,776.00,'2023-03-10 12:07:36','',''),(1198,'1','311','1',1,'Retail Sale Id 1245',2760.00,0.00,0.00,4.00,388.00,'2023-03-10 12:25:19','',''),(1199,'1','311','1',1,'Retail Sale Id 1246',2760.00,0.00,0.00,4.00,388.00,'2023-03-10 12:50:43','',''),(1200,'1','311','1',1,'Retail Sale Id 1247',4002.00,0.00,0.00,5.80,562.60,'2023-03-10 12:59:58','',''),(1201,'1','311','1',1,'Retail Sale Id 1248',4140.00,0.00,0.00,6.00,582.00,'2023-03-10 13:01:57','',''),(1202,'1','311','1',1,'Retail Sale Id 1250',4140.00,0.00,0.00,6.00,582.00,'2023-03-10 13:17:41','',''),(1203,'1','311','1',1,'Retail Sale Id 1253',1380.00,0.00,0.00,2.00,194.00,'2023-03-10 13:23:09','',''),(1204,'1','311','1',1,'Retail Sale Id 1252',3450.00,0.00,0.00,5.00,485.00,'2023-03-10 13:23:36','',''),(1205,'1','311','1',1,'Retail Sale Id 1254',8625.00,0.00,0.00,12.50,1212.50,'2023-03-10 13:25:11','',''),(1206,'1','311','1',1,'Retail Sale Id 1255',8625.00,0.00,0.00,12.50,1212.50,'2023-03-10 13:27:44','',''),(1207,'1','311','1',1,'Retail Sale Id 1256',2760.00,0.00,0.00,4.00,388.00,'2023-03-10 13:28:30','',''),(1208,'1','311','1',1,'Retail Sale Id 1257',8625.00,0.00,0.00,12.50,1212.50,'2023-03-10 13:43:39','',''),(1209,'1','311','1',1,'Retail Sale Id 1258',3450.00,0.00,0.00,5.00,485.00,'2023-03-10 14:03:43','',''),(1210,'1','311','1',1,'Retail Sale Id 1259',1380.00,0.00,0.00,2.00,194.00,'2023-03-10 14:08:25','',''),(1211,'1','311','1',1,'Retail Sale Id 1259',2070.00,0.00,0.00,3.00,291.00,'2023-03-10 14:08:25','',''),(1212,'1','311','1',1,'Retail Sale Id 1260',2070.00,0.00,0.00,3.00,291.00,'2023-03-10 14:21:38','',''),(1213,'1','311','1',1,'Retail Sale Id 1261',1380.00,0.00,0.00,2.00,194.00,'2023-03-10 14:28:48','',''),(1214,'1','311','1',1,'Retail Sale Id 1261',1380.00,0.00,0.00,2.00,194.00,'2023-03-10 14:28:48','',''),(1215,'1','311','1',1,'Retail Sale Id 1262',8625.00,0.00,0.00,12.50,1212.50,'2023-03-10 15:04:43','',''),(1216,'1','311','1',1,'Retail Sale Id 1263',8625.00,0.00,0.00,12.50,1212.50,'2023-03-10 15:05:43','',''),(1217,'1','311','1',1,'Retail Sale Id 1264',2760.00,0.00,0.00,4.00,388.00,'2023-03-10 15:08:17','',''),(1218,'1','311','1',1,'Retail Sale Id 1265',5520.00,0.00,0.00,8.00,776.00,'2023-03-10 15:26:30','',''),(1219,'1','311','1',1,'Retail Sale Id 1266',1000.50,0.00,0.00,1.45,140.65,'2023-03-10 15:28:09','',''),(1220,'1','311','1',1,'Retail Sale Id 1267',2070.00,0.00,0.00,3.00,291.00,'2023-03-10 15:28:58','',''),(1221,'1','311','1',1,'Retail Sale Id 1268',4830.00,0.00,0.00,7.00,679.00,'2023-03-10 15:39:15','',''),(1222,'1','311','1',1,'Retail Sale Id 1269',3001.50,0.00,0.00,4.35,421.95,'2023-03-10 16:28:29','',''),(1223,'1','311','1',1,'Retail Sale Id 1270',2760.00,0.00,0.00,4.00,388.00,'2023-03-10 16:45:35','',''),(1224,'1','311','1',1,'Retail Sale Id 1271',1380.00,0.00,0.00,2.00,194.00,'2023-03-10 16:47:43','',''),(1225,'1','311','1',1,'Retail Sale Id 1272',1497.30,0.00,0.00,2.17,210.49,'2023-03-10 17:05:46','',''),(1226,'1','311','1',1,'Retail Sale Id 1274',2070.00,0.00,0.00,3.00,291.00,'2023-03-10 17:11:22','',''),(1227,'1','311','1',1,'Retail Sale Id 1276',1380.00,0.00,0.00,2.00,194.00,'2023-03-10 17:32:55','',''),(1228,'1','311','1',1,'Retail Sale Id 1277',4140.00,0.00,0.00,6.00,582.00,'2023-03-10 17:35:42','',''),(1229,'1','311','1',1,'Retail Sale Id 1279',4140.00,0.00,0.00,6.00,582.00,'2023-03-10 17:52:09','',''),(1230,'1','311','1',1,'Retail Sale Id 1280',2070.00,0.00,0.00,3.00,291.00,'2023-03-10 17:57:22','',''),(1231,'1','311','1',1,'Return of Retail Sale Id 1277',0.00,4140.00,6.00,0.00,-582.00,'2023-03-10 19:02:40','',''),(1232,'1','311','1',1,'Retail Sale Id 1281',3118.80,0.00,0.00,4.52,438.44,'2023-03-10 19:03:34','',''),(1233,'1','311','1',1,'Return of Retail Sale Id 1281',0.00,3118.80,4.52,0.00,-438.44,'2023-03-10 19:05:34','',''),(1234,'1','311','1',1,'Retail Sale Id 1282',3118.80,0.00,0.00,4.52,438.44,'2023-03-10 19:06:18','',''),(1235,'1','311','1',1,'Retail Sale Id 1283',39530.00,0.00,0.00,59.00,4543.00,'2023-03-11 08:21:26','',''),(1236,'1','311','1',1,'Retail Sale Id 1284',3450.00,0.00,0.00,5.00,485.00,'2023-03-11 08:25:48','',''),(1237,'1','311','1',1,'Retail Sale Id 1284',3450.00,0.00,0.00,5.00,485.00,'2023-03-11 08:25:48','',''),(1238,'1','311','1',1,'Retail Sale Id 1285',2070.00,0.00,0.00,3.00,291.00,'2023-03-11 08:30:30','',''),(1239,'1','311','1',1,'Retail Sale Id 1286',3450.00,0.00,0.00,5.00,485.00,'2023-03-11 08:32:37','',''),(1240,'1','311','1',1,'Retail Sale Id 1287',3450.00,0.00,0.00,5.00,485.00,'2023-03-11 08:38:16','',''),(1241,'1','311','1',1,'Retail Sale Id 1288',2760.00,0.00,0.00,4.00,388.00,'2023-03-11 08:39:52','',''),(1242,'1','311','1',1,'Retail Sale Id 1289',5520.00,0.00,0.00,8.00,776.00,'2023-03-11 09:03:51','',''),(1243,'1','311','1',1,'Retail Sale Id 1290',4140.00,0.00,0.00,6.00,582.00,'2023-03-11 09:05:09','',''),(1244,'1','311','1',1,'Retail Sale Id 1291',1600.80,0.00,0.00,2.32,225.04,'2023-03-11 09:06:25','',''),(1245,'1','311','1',1,'Retail Sale Id 1292',2001.00,0.00,0.00,2.90,281.30,'2023-03-11 09:09:57','',''),(1246,'1','311','1',1,'Retail Sale Id 1292',5002.50,0.00,0.00,7.25,703.25,'2023-03-11 09:09:57','',''),(1247,'1','311','1',1,'Retail Sale Id 1293',4830.00,0.00,0.00,7.00,679.00,'2023-03-11 09:12:27','',''),(1248,'1','311','1',1,'Retail Sale Id 1294',6900.00,0.00,0.00,10.00,970.00,'2023-03-11 09:16:24','',''),(1249,'1','311','1',1,'Retail Sale Id 1295',690.00,0.00,0.00,1.00,97.00,'2023-03-11 09:17:25','',''),(1250,'1','311','1',1,'Retail Sale Id 1296',2070.00,0.00,0.00,3.00,291.00,'2023-03-11 09:21:12','',''),(1251,'1','311','1',1,'Retail Sale Id 1297',2070.00,0.00,0.00,3.00,291.00,'2023-03-11 09:29:16','',''),(1252,'1','311','1',1,'Retail Sale Id 1298',3001.50,0.00,0.00,4.35,421.95,'2023-03-11 09:30:17','',''),(1253,'1','311','1',1,'Retail Sale Id 1299',690.00,0.00,0.00,1.00,97.00,'2023-03-11 09:31:28','',''),(1254,'1','311','1',1,'Retail Sale Id 1300',8625.00,0.00,0.00,12.50,1212.50,'2023-03-11 09:32:36','',''),(1255,'1','311','1',1,'Retail Sale Id 1301',3450.00,0.00,0.00,5.00,485.00,'2023-03-11 09:34:34','',''),(1256,'1','311','1',1,'Retail Sale Id 1302',4140.00,0.00,0.00,6.00,582.00,'2023-03-11 09:38:04','',''),(1257,'1','311','1',1,'Retail Sale Id 1303',1000.50,0.00,0.00,1.45,140.65,'2023-03-11 09:39:54','',''),(1258,'1','311','1',1,'Retail Sale Id 1304',3450.00,0.00,0.00,5.00,485.00,'2023-03-11 09:40:47','',''),(1259,'1','311','1',1,'Retail Sale Id 1305',1000.50,0.00,0.00,1.45,140.65,'2023-03-11 09:43:49','',''),(1260,'1','311','1',1,'Retail Sale Id 1306',8625.00,0.00,0.00,12.50,1212.50,'2023-03-11 09:52:24','',''),(1261,'1','311','1',1,'Retail Sale Id 1307',4140.00,0.00,0.00,6.00,582.00,'2023-03-11 09:57:30','',''),(1262,'1','311','1',1,'Retail Sale Id 1308',4485.00,0.00,0.00,6.50,630.50,'2023-03-11 10:00:40','',''),(1263,'1','311','1',1,'Retail Sale Id 1309',1725.00,0.00,0.00,2.50,242.50,'2023-03-11 10:14:52','',''),(1264,'1','311','1',1,'Retail Sale Id 1311',1000.50,0.00,0.00,1.45,140.65,'2023-03-11 10:20:00','',''),(1265,'1','311','1',1,'Retail Sale Id 1312',2001.00,0.00,0.00,2.90,281.30,'2023-03-11 10:20:28','',''),(1266,'1','311','1',1,'Retail Sale Id 1313',800.40,0.00,0.00,1.16,112.52,'2023-03-11 10:21:23','',''),(1267,'1','311','1',1,'Retail Sale Id 1314',4140.00,0.00,0.00,6.00,582.00,'2023-03-11 10:24:09','',''),(1268,'1','311','1',1,'Retail Sale Id 1315',2070.00,0.00,0.00,3.00,291.00,'2023-03-11 10:26:03','',''),(1269,'1','311','1',1,'Retail Sale Id 1316',4140.00,0.00,0.00,6.00,582.00,'2023-03-11 10:27:39','',''),(1270,'1','311','1',1,'Retail Sale Id 1317',4140.00,0.00,0.00,6.00,582.00,'2023-03-11 10:28:44','',''),(1271,'1','311','1',1,'Retail Sale Id 1318',4140.00,0.00,0.00,6.00,582.00,'2023-03-11 10:30:06','',''),(1272,'1','311','1',1,'Retail Sale Id 1320',2760.00,0.00,0.00,4.00,388.00,'2023-03-11 10:33:31','',''),(1273,'1','311','1',1,'Retail Sale Id 1321',4830.00,0.00,0.00,7.00,679.00,'2023-03-11 10:35:27','',''),(1274,'1','311','1',1,'Retail Sale Id 1322',4830.00,0.00,0.00,7.00,679.00,'2023-03-11 10:37:27','',''),(1275,'1','311','1',1,'Retail Sale Id 1323',3450.00,0.00,0.00,5.00,485.00,'2023-03-11 10:39:11','',''),(1276,'1','311','1',1,'Retail Sale Id 1324',8625.00,0.00,0.00,12.50,1212.50,'2023-03-11 10:43:26','',''),(1277,'1','311','1',1,'Retail Sale Id 1325',9660.00,0.00,0.00,14.00,1358.00,'2023-03-11 11:06:23','',''),(1278,'1','311','1',1,'Retail Sale Id 1326',2760.00,0.00,0.00,4.00,388.00,'2023-03-11 11:09:55','',''),(1279,'1','311','1',1,'Retail Sale Id 1327',4140.00,0.00,0.00,6.00,582.00,'2023-03-11 11:17:04','',''),(1280,'1','311','1',1,'Retail Sale Id 1328',2760.00,0.00,0.00,4.00,388.00,'2023-03-11 11:19:00','',''),(1281,'1','311','1',1,'Retail Sale Id 1330',2070.00,0.00,0.00,3.00,291.00,'2023-03-11 11:23:51','',''),(1282,'1','311','1',1,'Retail Sale Id 1331',4140.00,0.00,0.00,6.00,582.00,'2023-03-11 11:25:27','',''),(1283,'1','311','1',1,'Retail Sale Id 1332',4140.00,0.00,0.00,6.00,582.00,'2023-03-11 11:29:18','',''),(1284,'1','311','1',1,'Retail Sale Id 1333',1000.50,0.00,0.00,1.45,140.65,'2023-03-11 11:31:53','',''),(1285,'1','311','1',1,'Retail Sale Id 1334',3450.00,0.00,0.00,5.00,485.00,'2023-03-11 11:34:43','',''),(1286,'1','311','1',1,'Retail Sale Id 1335',11730.00,0.00,0.00,17.00,1649.00,'2023-03-11 11:37:46','',''),(1287,'1','311','1',1,'Retail Sale Id 1336',8625.00,0.00,0.00,12.50,1212.50,'2023-03-11 11:40:10','',''),(1288,'1','311','1',1,'Retail Sale Id 1337',2001.00,0.00,0.00,2.90,281.30,'2023-03-11 11:41:42','',''),(1289,'1','311','1',1,'Retail Sale Id 1338',1000.50,0.00,0.00,1.45,140.65,'2023-03-11 11:53:13','',''),(1290,'1','311','1',1,'Retail Sale Id 1339',2070.00,0.00,0.00,3.00,291.00,'2023-03-11 11:56:56','',''),(1291,'1','311','1',1,'Retail Sale Id 1339',2070.00,0.00,0.00,3.00,291.00,'2023-03-11 11:56:56','',''),(1292,'1','311','1',1,'Retail Sale Id 1340',6210.00,0.00,0.00,9.00,873.00,'2023-03-11 11:58:22','',''),(1293,'1','311','1',1,'Retail Sale Id 1342',3450.00,0.00,0.00,5.00,485.00,'2023-03-11 12:02:45','',''),(1294,'1','311','1',1,'Retail Sale Id 1343',1400.70,0.00,0.00,2.03,196.91,'2023-03-11 12:05:09','',''),(1295,'1','311','1',1,'Retail Sale Id 1344',40461.30,0.00,0.00,60.39,4650.03,'2023-03-11 12:12:42','',''),(1296,'1','311','1',1,'Retail Sale Id 1345',6900.00,0.00,0.00,10.00,970.00,'2023-03-11 12:36:55','',''),(1297,'1','311','1',1,'Retail Sale Id 1346',2760.00,0.00,0.00,4.00,388.00,'2023-03-11 12:38:14','',''),(1298,'1','311','1',1,'Retail Sale Id 1347',4830.00,0.00,0.00,7.00,679.00,'2023-03-11 12:40:10','',''),(1299,'1','311','1',1,'Retail Sale Id 1348',3001.50,0.00,0.00,4.35,421.95,'2023-03-11 12:49:57','',''),(1300,'1','311','1',1,'Retail Sale Id 1349',6900.00,0.00,0.00,10.00,970.00,'2023-03-11 12:50:56','',''),(1301,'1','311','1',1,'Retail Sale Id 1350',2001.00,0.00,0.00,2.90,281.30,'2023-03-11 12:51:53','',''),(1302,'1','311','1',1,'Retail Sale Id 1351',3450.00,0.00,0.00,5.00,485.00,'2023-03-11 12:56:55','',''),(1303,'1','311','1',1,'Retail Sale Id 1352',3450.00,0.00,0.00,5.00,485.00,'2023-03-11 13:00:26','',''),(1304,'1','311','1',1,'Retail Sale Id 1353',4140.00,0.00,0.00,6.00,582.00,'2023-03-11 13:01:35','',''),(1305,'1','311','1',1,'Retail Sale Id 1354',3450.00,0.00,0.00,5.00,485.00,'2023-03-11 13:35:17','',''),(1306,'1','311','1',1,'Retail Sale Id 1355',3001.50,0.00,0.00,4.35,421.95,'2023-03-11 13:36:39','',''),(1307,'1','311','1',1,'Retail Sale Id 1356',1697.40,0.00,0.00,2.46,238.62,'2023-03-11 13:39:16','',''),(1308,'1','311','1',1,'Retail Sale Id 1357',1000.50,0.00,0.00,1.45,140.65,'2023-03-11 13:39:50','',''),(1309,'1','311','1',1,'Retail Sale Id 1358',2070.00,0.00,0.00,3.00,291.00,'2023-03-11 13:49:49','',''),(1310,'1','311','1',1,'Retail Sale Id 1359',3450.00,0.00,0.00,5.00,485.00,'2023-03-11 13:53:52','',''),(1311,'1','311','1',1,'Retail Sale Id 1360',4140.00,0.00,0.00,6.00,582.00,'2023-03-11 13:56:26','',''),(1312,'1','311','1',1,'Retail Sale Id 1361',2070.00,0.00,0.00,3.00,291.00,'2023-03-11 13:59:57','',''),(1313,'1','311','1',1,'Retail Sale Id 1362',1380.00,0.00,0.00,2.00,194.00,'2023-03-11 14:09:36','',''),(1314,'1','311','1',1,'Retail Sale Id 1363',5002.50,0.00,0.00,7.25,703.25,'2023-03-11 14:11:12','',''),(1315,'1','311','1',1,'Retail Sale Id 1365',4830.00,0.00,0.00,7.00,679.00,'2023-03-11 14:21:48','',''),(1316,'1','311','1',1,'Retail Sale Id 1366',5520.00,0.00,0.00,8.00,776.00,'2023-03-11 14:37:06','',''),(1317,'1','311','1',1,'Retail Sale Id 1367',8625.00,0.00,0.00,12.50,1212.50,'2023-03-11 14:47:17','',''),(1318,'1','311','1',1,'Retail Sale Id 1368',1380.00,0.00,0.00,2.00,194.00,'2023-03-11 14:53:10','',''),(1319,'1','311','1',1,'Retail Sale Id 1369',8625.00,0.00,0.00,12.50,1212.50,'2023-03-11 14:56:39','',''),(1320,'1','311','1',1,'Retail Sale Id 1370',6996.60,0.00,0.00,10.14,983.58,'2023-03-11 15:15:19','',''),(1321,'1','311','1',1,'Retail Sale Id 1371',3001.50,0.00,0.00,4.35,421.95,'2023-03-11 15:18:25','',''),(1322,'1','311','1',1,'Retail Sale Id 1372',4002.00,0.00,0.00,5.80,562.60,'2023-03-11 15:20:34','',''),(1323,'1','311','1',1,'Retail Sale Id 1372',4002.00,0.00,0.00,5.80,562.60,'2023-03-11 15:20:34','',''),(1324,'1','311','1',1,'Retail Sale Id 1373',1400.70,0.00,0.00,2.03,196.91,'2023-03-11 15:25:28','',''),(1325,'1','311','1',1,'Retail Sale Id 1376',2097.60,0.00,0.00,3.04,294.88,'2023-03-11 15:34:44','',''),(1326,'1','311','1',1,'Retail Sale Id 1377',4146.90,0.00,0.00,6.01,582.97,'2023-03-11 15:35:31','',''),(1327,'1','311','1',1,'Retail Sale Id 1378',4202.10,0.00,0.00,6.09,590.73,'2023-03-11 15:36:49','',''),(1328,'1','311','1',1,'Retail Sale Id 1379',2070.00,0.00,0.00,3.00,291.00,'2023-03-11 15:38:36','',''),(1329,'1','311','1',1,'Retail Sale Id 1382',3450.00,0.00,0.00,5.00,485.00,'2023-03-11 15:45:34','',''),(1330,'1','311','1',1,'Retail Sale Id 1383',2001.00,0.00,0.00,2.90,281.30,'2023-03-11 15:46:17','',''),(1331,'1','311','1',1,'Retail Sale Id 1384',3450.00,0.00,0.00,5.00,485.00,'2023-03-11 15:47:42','',''),(1332,'1','311','1',1,'Retail Sale Id 1385',4140.00,0.00,0.00,6.00,582.00,'2023-03-11 15:55:13','',''),(1333,'1','311','1',1,'Retail Sale Id 1387',2097.60,0.00,0.00,3.04,294.88,'2023-03-11 15:57:19','',''),(1334,'1','311','1',1,'Retail Sale Id 1389',2760.00,0.00,0.00,4.00,388.00,'2023-03-11 16:08:44','',''),(1335,'1','311','1',1,'Retail Sale Id 1388',2070.00,0.00,0.00,3.00,291.00,'2023-03-11 16:10:48','',''),(1336,'1','311','1',1,'Retail Sale Id 1391',2070.00,0.00,0.00,3.00,291.00,'2023-03-11 16:15:50','',''),(1337,'1','311','1',1,'Retail Sale Id 1392',4140.00,0.00,0.00,6.00,582.00,'2023-03-11 16:37:21','',''),(1338,'1','311','1',1,'Retail Sale Id 1394',4140.00,0.00,0.00,6.00,582.00,'2023-03-11 16:50:12','',''),(1339,'1','311','1',1,'Retail Sale Id 1395',4830.00,0.00,0.00,7.00,679.00,'2023-03-11 16:57:11','',''),(1340,'1','311','1',1,'Retail Sale Id 1396',1380.00,0.00,0.00,2.00,194.00,'2023-03-11 17:09:16','',''),(1341,'1','311','1',1,'Retail Sale Id 1397',4002.00,0.00,0.00,5.80,562.60,'2023-03-11 17:13:55','',''),(1342,'1','311','1',1,'Retail Sale Id 1398',3450.00,0.00,0.00,5.00,485.00,'2023-03-11 17:15:51','',''),(1343,'1','311','1',1,'Retail Sale Id 1399',2070.00,0.00,0.00,3.00,291.00,'2023-03-11 17:17:02','',''),(1344,'1','311','1',1,'Retail Sale Id 1400',8625.00,0.00,0.00,12.50,1212.50,'2023-03-11 17:18:20','',''),(1345,'1','311','1',1,'Retail Sale Id 1401',2760.00,0.00,0.00,4.00,388.00,'2023-03-11 17:20:55','',''),(1346,'1','311','1',1,'Retail Sale Id 1402',3450.00,0.00,0.00,5.00,485.00,'2023-03-11 17:23:42','',''),(1347,'1','311','1',1,'Retail Sale Id 1403',4140.00,0.00,0.00,6.00,582.00,'2023-03-11 17:28:37','',''),(1348,'1','311','1',1,'Retail Sale Id 1405',3001.50,0.00,0.00,4.35,421.95,'2023-03-11 17:31:42','',''),(1349,'1','311','1',1,'Retail Sale Id 1406',8625.00,0.00,0.00,12.50,1212.50,'2023-03-11 17:36:33','',''),(1350,'1','311','1',1,'Retail Sale Id 1408',1000.50,0.00,0.00,1.45,140.65,'2023-03-11 17:37:48','',''),(1351,'1','311','1',1,'Retail Sale Id 1409',2070.00,0.00,0.00,3.00,291.00,'2023-03-11 17:41:47','',''),(1352,'1','311','1',1,'Retail Sale Id 1411',8625.00,0.00,0.00,12.50,1212.50,'2023-03-11 17:54:37','',''),(1353,'1','311','1',1,'Retail Sale Id 1412',2070.00,0.00,0.00,3.00,291.00,'2023-03-11 17:55:46','',''),(1354,'1','311','1',1,'Retail Sale Id 1413',8970.00,0.00,0.00,13.00,1261.00,'2023-03-11 18:12:46','',''),(1355,'1','311','1',1,'Retail Sale Id 1415',690.00,0.00,0.00,1.00,97.00,'2023-03-11 18:21:49','',''),(1356,'1','311','1',1,'Retail Sale Id 1417',2760.00,0.00,0.00,4.00,388.00,'2023-03-11 18:25:51','',''),(1357,'1','311','1',1,'Retail Sale Id 1417',4140.00,0.00,0.00,6.00,582.00,'2023-03-11 18:25:51','',''),(1358,'1','311','1',1,'Retail Sale Id 1419',2070.00,0.00,0.00,3.00,291.00,'2023-03-11 18:26:54','',''),(1359,'1','311','1',1,'Retail Sale Id 1420',690.00,0.00,0.00,1.00,97.00,'2023-03-11 18:28:49','',''),(1360,'1','311','1',1,'Retail Sale Id 1421',1200.60,0.00,0.00,1.74,168.78,'2023-03-11 18:30:08','',''),(1361,'1','311','1',1,'Retail Sale Id 1422',2070.00,0.00,0.00,3.00,291.00,'2023-03-11 18:30:53','',''),(1362,'1','311','1',1,'Retail Sale Id 1374',4830.00,0.00,0.00,7.00,679.00,'2023-03-11 18:41:45','',''),(1363,'1','311','1',1,'Retail Sale Id 1374',8625.00,0.00,0.00,12.50,1212.50,'2023-03-11 18:41:45','',''),(1364,'1','311','1',1,'Retail Sale Id 1423',4140.00,0.00,0.00,6.00,582.00,'2023-03-11 18:43:11','',''),(1365,'1','311','1',1,'Return of Retail Sale Id 1423',0.00,4140.00,6.00,0.00,-582.00,'2023-03-11 23:16:16','',''),(1366,'1','311','1',1,'Return of Retail Sale Id 1422',0.00,2070.00,3.00,0.00,-291.00,'2023-03-11 23:17:25','',''),(1367,'1','311','1',1,'Return of Retail Sale Id 1401',0.00,2760.00,4.00,0.00,-388.00,'2023-03-11 23:20:54','',''),(1368,'1','311','1',1,'Return of Retail Sale Id 1415',0.00,690.00,1.00,0.00,-97.00,'2023-03-11 23:23:39','',''),(1369,'1','311','1',1,'Retail Sale Id 1424',1511.10,0.00,0.00,2.19,212.43,'2023-03-11 23:25:05','',''),(1370,'1','311','1',1,'Retail Sale Id 1425',2001.00,0.00,0.00,2.90,281.30,'2023-03-12 08:02:41','',''),(1371,'1','311','1',1,'Retail Sale Id 1426',3450.00,0.00,0.00,5.00,485.00,'2023-03-12 08:04:03','',''),(1372,'1','311','1',1,'Retail Sale Id 1427',3001.50,0.00,0.00,4.35,421.95,'2023-03-12 08:05:52','',''),(1373,'1','311','1',1,'Retail Sale Id 1428',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 08:07:06','',''),(1374,'1','311','1',1,'Retail Sale Id 1429',931.50,0.00,0.00,1.35,130.95,'2023-03-12 08:09:04','',''),(1375,'1','311','1',1,'Retail Sale Id 1431',1000.50,0.00,0.00,1.45,140.65,'2023-03-12 08:13:20','',''),(1376,'1','311','1',1,'Retail Sale Id 1431',1380.00,0.00,0.00,2.00,194.00,'2023-03-12 08:13:20','',''),(1377,'1','311','1',1,'Retail Sale Id 1431',3450.00,0.00,0.00,5.00,485.00,'2023-03-12 08:13:20','',''),(1378,'1','311','1',1,'Retail Sale Id 1431',4830.00,0.00,0.00,7.00,679.00,'2023-03-12 08:13:20','',''),(1379,'1','311','1',1,'Retail Sale Id 1432',2001.00,0.00,0.00,2.90,281.30,'2023-03-12 08:14:39','',''),(1380,'1','311','1',1,'Retail Sale Id 1433',4140.00,0.00,0.00,6.00,582.00,'2023-03-12 08:16:08','',''),(1381,'1','311','1',1,'Retail Sale Id 1434',2001.00,0.00,0.00,2.90,281.30,'2023-03-12 08:17:29','',''),(1382,'1','311','1',1,'Retail Sale Id 1435',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 08:22:17','',''),(1383,'1','311','1',1,'Retail Sale Id 1436',3450.00,0.00,0.00,5.00,485.00,'2023-03-12 08:23:20','',''),(1384,'1','311','1',1,'Retail Sale Id 1437',3795.00,0.00,0.00,5.50,533.50,'2023-03-12 08:25:01','',''),(1385,'1','311','1',1,'Retail Sale Id 1438',4830.00,0.00,0.00,7.00,679.00,'2023-03-12 08:26:49','',''),(1386,'1','311','1',1,'Retail Sale Id 1439',2760.00,0.00,0.00,4.00,388.00,'2023-03-12 08:29:10','',''),(1387,'1','311','1',1,'Retail Sale Id 1440',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 08:30:32','',''),(1388,'1','311','1',1,'Retail Sale Id 1441',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 08:33:01','',''),(1389,'1','311','1',1,'Retail Sale Id 1442',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 08:34:17','',''),(1390,'1','311','1',1,'Retail Sale Id 1443',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 08:35:49','',''),(1391,'1','311','1',1,'Retail Sale Id 1444',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 08:38:57','',''),(1392,'1','311','1',1,'Retail Sale Id 1446',3001.50,0.00,0.00,4.35,421.95,'2023-03-12 08:42:12','',''),(1393,'1','311','1',1,'Retail Sale Id 1447',8280.00,0.00,0.00,12.00,1164.00,'2023-03-12 08:43:44','',''),(1394,'1','311','1',1,'Retail Sale Id 1448',8625.00,0.00,0.00,12.50,1212.50,'2023-03-12 08:45:07','',''),(1395,'1','311','1',1,'Retail Sale Id 1449',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 08:46:51','',''),(1396,'1','311','1',1,'Retail Sale Id 1451',2001.00,0.00,0.00,2.90,281.30,'2023-03-12 08:48:37','',''),(1397,'1','311','1',1,'Retail Sale Id 1452',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 08:50:45','',''),(1398,'1','311','1',1,'Retail Sale Id 1453',1380.00,0.00,0.00,2.00,194.00,'2023-03-12 08:53:38','',''),(1399,'1','311','1',1,'Retail Sale Id 1454',690.00,0.00,0.00,1.00,97.00,'2023-03-12 08:56:15','',''),(1400,'1','311','1',1,'Retail Sale Id 1455',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 08:58:34','',''),(1401,'1','311','1',1,'Retail Sale Id 1456',1000.50,0.00,0.00,1.45,140.65,'2023-03-12 08:59:59','',''),(1402,'1','311','1',1,'Retail Sale Id 1457',6900.00,0.00,0.00,10.00,970.00,'2023-03-12 09:02:23','',''),(1403,'1','311','1',1,'Retail Sale Id 1458',2760.00,0.00,0.00,4.00,388.00,'2023-03-12 09:07:16','',''),(1404,'1','311','1',1,'Retail Sale Id 1459',3450.00,0.00,0.00,5.00,485.00,'2023-03-12 09:09:06','',''),(1405,'1','311','1',1,'Retail Sale Id 1460',1380.00,0.00,0.00,2.00,194.00,'2023-03-12 09:10:41','',''),(1406,'1','311','1',1,'Retail Sale Id 1461',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 09:17:38','',''),(1407,'1','311','1',1,'Retail Sale Id 1462',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 09:18:14','',''),(1408,'1','311','1',1,'Retail Sale Id 1463',3450.00,0.00,0.00,5.00,485.00,'2023-03-12 09:19:47','',''),(1409,'1','311','1',1,'Retail Sale Id 1464',8280.00,0.00,0.00,12.00,1164.00,'2023-03-12 09:21:34','',''),(1410,'1','311','1',1,'Retail Sale Id 1465',4830.00,0.00,0.00,7.00,679.00,'2023-03-12 09:28:36','',''),(1411,'1','311','1',1,'Retail Sale Id 1466',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 09:29:53','',''),(1412,'1','311','1',1,'Retail Sale Id 1467',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 09:31:28','',''),(1413,'1','311','1',1,'Retail Sale Id 1468',4002.00,0.00,0.00,5.80,562.60,'2023-03-12 09:33:39','',''),(1414,'1','311','1',1,'Retail Sale Id 1469',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 09:36:20','',''),(1415,'1','311','1',1,'Retail Sale Id 1471',690.00,0.00,0.00,1.00,97.00,'2023-03-12 09:40:14','',''),(1416,'1','311','1',1,'Retail Sale Id 1472',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 09:52:22','',''),(1417,'1','311','1',1,'Retail Sale Id 1474',696.90,0.00,0.00,1.01,97.97,'2023-03-12 09:55:54','',''),(1418,'1','311','1',1,'Retail Sale Id 1476',1497.30,0.00,0.00,2.17,210.49,'2023-03-12 09:57:32','',''),(1419,'1','311','1',1,'Retail Sale Id 1477',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 10:00:50','',''),(1420,'1','311','1',1,'Retail Sale Id 1479',4140.00,0.00,0.00,6.00,582.00,'2023-03-12 10:05:25','',''),(1421,'1','311','1',1,'Retail Sale Id 1480',8625.00,0.00,0.00,12.50,1212.50,'2023-03-12 10:07:30','',''),(1422,'1','311','1',1,'Retail Sale Id 1478',3001.50,0.00,0.00,4.35,421.95,'2023-03-12 10:09:04','',''),(1423,'1','311','1',1,'Retail Sale Id 1481',2001.00,0.00,0.00,2.90,281.30,'2023-03-12 10:14:31','',''),(1424,'1','311','1',1,'Retail Sale Id 1482',4140.00,0.00,0.00,6.00,582.00,'2023-03-12 10:21:39','',''),(1425,'1','311','1',1,'Retail Sale Id 1483',3450.00,0.00,0.00,5.00,485.00,'2023-03-12 10:25:34','',''),(1426,'1','311','1',1,'Retail Sale Id 1484',2760.00,0.00,0.00,4.00,388.00,'2023-03-12 10:27:50','',''),(1427,'1','311','1',1,'Retail Sale Id 1485',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 10:28:55','',''),(1428,'1','311','1',1,'Retail Sale Id 1486',1000.50,0.00,0.00,1.45,140.65,'2023-03-12 10:29:49','',''),(1429,'1','311','1',1,'Retail Sale Id 1488',2801.40,0.00,0.00,4.06,393.82,'2023-03-12 10:31:24','',''),(1430,'1','311','1',1,'Retail Sale Id 1489',4140.00,0.00,0.00,6.00,582.00,'2023-03-12 10:32:19','',''),(1431,'1','311','1',1,'Retail Sale Id 1490',1000.50,0.00,0.00,1.45,140.65,'2023-03-12 10:33:05','',''),(1432,'1','311','1',1,'Retail Sale Id 1491',1380.00,0.00,0.00,2.00,194.00,'2023-03-12 10:35:33','',''),(1433,'1','311','1',1,'Retail Sale Id 1492',1380.00,0.00,0.00,2.00,194.00,'2023-03-12 10:39:55','',''),(1434,'1','311','1',1,'Retail Sale Id 1493',5520.00,0.00,0.00,8.00,776.00,'2023-03-12 10:42:55','',''),(1435,'1','311','1',1,'Retail Sale Id 1494',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 10:49:41','',''),(1436,'1','311','1',1,'Retail Sale Id 1494',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 10:49:41','',''),(1437,'1','311','1',1,'Retail Sale Id 1495',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 10:51:27','',''),(1438,'1','311','1',1,'Retail Sale Id 1496',2760.00,0.00,0.00,4.00,388.00,'2023-03-12 10:53:38','',''),(1439,'1','311','1',1,'Retail Sale Id 1498',4140.00,0.00,0.00,6.00,582.00,'2023-03-12 10:59:37','',''),(1440,'1','311','1',1,'Retail Sale Id 1499',690.00,0.00,0.00,1.00,97.00,'2023-03-12 11:01:25','',''),(1441,'1','311','1',1,'Retail Sale Id 1497',2415.00,0.00,0.00,3.50,339.50,'2023-03-12 11:02:08','',''),(1442,'1','311','1',1,'Retail Sale Id 1500',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 11:02:58','',''),(1443,'1','311','1',1,'Retail Sale Id 1501',1697.40,0.00,0.00,2.46,238.62,'2023-03-12 11:06:43','',''),(1444,'1','311','1',1,'Retail Sale Id 1503',2760.00,0.00,0.00,4.00,388.00,'2023-03-12 11:14:06','',''),(1445,'1','311','1',1,'Retail Sale Id 1504',4140.00,0.00,0.00,6.00,582.00,'2023-03-12 11:24:26','',''),(1446,'1','311','1',1,'Retail Sale Id 1505',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 11:26:28','',''),(1447,'1','311','1',1,'Retail Sale Id 1506',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 11:27:22','',''),(1448,'1','311','1',1,'Retail Sale Id 1507',4002.00,0.00,0.00,5.80,562.60,'2023-03-12 11:28:09','',''),(1449,'1','311','1',1,'Retail Sale Id 1508',1200.60,0.00,0.00,1.74,168.78,'2023-03-12 11:32:23','',''),(1450,'1','311','1',1,'Retail Sale Id 1509',6900.00,0.00,0.00,10.00,970.00,'2023-03-12 11:35:48','',''),(1451,'1','311','1',1,'Retail Sale Id 1510',1400.70,0.00,0.00,2.03,196.91,'2023-03-12 11:45:39','',''),(1452,'1','311','1',1,'Retail Sale Id 1511',1380.00,0.00,0.00,2.00,194.00,'2023-03-12 11:46:27','',''),(1453,'1','311','1',1,'Retail Sale Id 1512',3001.50,0.00,0.00,4.35,421.95,'2023-03-12 11:55:24','',''),(1454,'1','311','1',1,'Retail Sale Id 1513',4140.00,0.00,0.00,6.00,582.00,'2023-03-12 12:05:02','',''),(1455,'1','311','1',1,'Retail Sale Id 1514',1000.50,0.00,0.00,1.45,140.65,'2023-03-12 12:14:12','',''),(1456,'1','311','1',1,'Retail Sale Id 1515',3450.00,0.00,0.00,5.00,485.00,'2023-03-12 12:16:24','',''),(1457,'1','311','1',1,'Retail Sale Id 1517',1380.00,0.00,0.00,2.00,194.00,'2023-03-12 12:20:00','',''),(1458,'1','311','1',1,'Retail Sale Id 1518',2760.00,0.00,0.00,4.00,388.00,'2023-03-12 12:31:05','',''),(1459,'1','311','1',1,'Retail Sale Id 1519',3498.30,0.00,0.00,5.07,491.79,'2023-03-12 12:35:29','',''),(1460,'1','311','1',1,'Retail Sale Id 1520',4002.00,0.00,0.00,5.80,562.60,'2023-03-12 12:38:57','',''),(1461,'1','311','1',1,'Retail Sale Id 1521',2760.00,0.00,0.00,4.00,388.00,'2023-03-12 12:43:43','',''),(1462,'1','311','1',1,'Retail Sale Id 1522',3001.50,0.00,0.00,4.35,421.95,'2023-03-12 12:44:48','',''),(1463,'1','311','1',1,'Retail Sale Id 1523',1400.70,0.00,0.00,2.03,196.91,'2023-03-12 12:47:29','',''),(1464,'1','311','1',1,'Retail Sale Id 1524',2760.00,0.00,0.00,4.00,388.00,'2023-03-12 12:48:36','',''),(1465,'1','311','1',1,'Retail Sale Id 1525',3001.50,0.00,0.00,4.35,421.95,'2023-03-12 12:56:25','',''),(1466,'1','311','1',1,'Retail Sale Id 1526',3450.00,0.00,0.00,5.00,485.00,'2023-03-12 12:58:51','',''),(1467,'1','311','1',1,'Retail Sale Id 1527',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 13:01:26','',''),(1468,'1','311','1',1,'Retail Sale Id 1528',3450.00,0.00,0.00,5.00,485.00,'2023-03-12 13:05:38','',''),(1469,'1','311','1',1,'Retail Sale Id 1528',4140.00,0.00,0.00,6.00,582.00,'2023-03-12 13:05:38','',''),(1470,'1','311','1',1,'Retail Sale Id 1529',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 13:07:02','',''),(1471,'1','311','1',1,'Retail Sale Id 1530',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 13:11:00','',''),(1472,'1','311','1',1,'Retail Sale Id 1531',1200.60,0.00,0.00,1.74,168.78,'2023-03-12 13:13:27','',''),(1473,'1','311','1',1,'Retail Sale Id 1532',4140.00,0.00,0.00,6.00,582.00,'2023-03-12 13:25:37','',''),(1474,'1','311','1',1,'Retail Sale Id 1533',2760.00,0.00,0.00,4.00,388.00,'2023-03-12 13:27:32','',''),(1475,'1','311','1',1,'Retail Sale Id 1534',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 13:38:56','',''),(1476,'1','311','1',1,'Retail Sale Id 1535',1380.00,0.00,0.00,2.00,194.00,'2023-03-12 13:40:26','',''),(1477,'1','311','1',1,'Retail Sale Id 1536',1000.50,0.00,0.00,1.45,140.65,'2023-03-12 13:44:35','',''),(1478,'1','311','1',1,'Retail Sale Id 1537',1000.50,0.00,0.00,1.45,140.65,'2023-03-12 13:53:28','',''),(1479,'1','311','1',1,'Retail Sale Id 1538',3001.50,0.00,0.00,4.35,421.95,'2023-03-12 13:54:52','',''),(1480,'1','311','1',1,'Retail Sale Id 1539',1497.30,0.00,0.00,2.17,210.49,'2023-03-12 13:58:44','',''),(1481,'1','311','1',1,'Retail Sale Id 1540',6900.00,0.00,0.00,10.00,970.00,'2023-03-12 14:00:40','',''),(1482,'1','311','1',1,'Retail Sale Id 1541',4140.00,0.00,0.00,6.00,582.00,'2023-03-12 14:01:47','',''),(1483,'1','311','1',1,'Retail Sale Id 1542',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 14:02:59','',''),(1484,'1','311','1',1,'Retail Sale Id 1543',3450.00,0.00,0.00,5.00,485.00,'2023-03-12 14:05:11','',''),(1485,'1','311','1',1,'Retail Sale Id 1544',4140.00,0.00,0.00,6.00,582.00,'2023-03-12 14:06:09','',''),(1486,'1','311','1',1,'Retail Sale Id 1545',1000.50,0.00,0.00,1.45,140.65,'2023-03-12 14:07:46','',''),(1487,'1','311','1',1,'Retail Sale Id 1548',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 14:14:29','',''),(1488,'1','311','1',1,'Retail Sale Id 1548',3450.00,0.00,0.00,5.00,485.00,'2023-03-12 14:14:29','',''),(1489,'1','311','1',1,'Retail Sale Id 1549',4830.00,0.00,0.00,7.00,679.00,'2023-03-12 14:15:39','',''),(1490,'1','311','1',1,'Retail Sale Id 1549',4830.00,0.00,0.00,7.00,679.00,'2023-03-12 14:15:39','',''),(1491,'1','311','1',1,'Retail Sale Id 1546',5520.00,0.00,0.00,8.00,776.00,'2023-03-12 14:18:55','',''),(1492,'1','311','1',1,'Retail Sale Id 1551',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 14:23:03','',''),(1493,'1','311','1',1,'Retail Sale Id 1552',3795.00,0.00,0.00,5.50,533.50,'2023-03-12 14:26:16','',''),(1494,'1','311','1',1,'Retail Sale Id 1553',6003.00,0.00,0.00,8.70,843.90,'2023-03-12 14:29:48','',''),(1495,'1','311','1',1,'Retail Sale Id 1555',4002.00,0.00,0.00,5.80,562.60,'2023-03-12 14:33:13','',''),(1496,'1','311','1',1,'Retail Sale Id 1556',1000.50,0.00,0.00,1.45,140.65,'2023-03-12 14:33:57','',''),(1497,'1','311','1',1,'Retail Sale Id 1557',2001.00,0.00,0.00,2.90,281.30,'2023-03-12 15:00:07','',''),(1498,'1','311','1',1,'Retail Sale Id 1558',4002.00,0.00,0.00,5.80,562.60,'2023-03-12 15:04:14','',''),(1499,'1','311','1',1,'Retail Sale Id 1559',1497.30,0.00,0.00,2.17,210.49,'2023-03-12 15:05:38','',''),(1500,'1','311','1',1,'Retail Sale Id 1560',2001.00,0.00,0.00,2.90,281.30,'2023-03-12 15:07:00','',''),(1501,'1','311','1',1,'Retail Sale Id 1561',6900.00,0.00,0.00,10.00,970.00,'2023-03-12 15:07:55','',''),(1502,'1','311','1',1,'Retail Sale Id 1562',3001.50,0.00,0.00,4.35,421.95,'2023-03-12 15:10:19','',''),(1503,'1','311','1',1,'Retail Sale Id 1563',1380.00,0.00,0.00,2.00,194.00,'2023-03-12 15:11:40','',''),(1504,'1','311','1',1,'Retail Sale Id 1564',4140.00,0.00,0.00,6.00,582.00,'2023-03-12 15:12:39','',''),(1505,'1','311','1',1,'Retail Sale Id 1565',1380.00,0.00,0.00,2.00,194.00,'2023-03-12 15:16:20','',''),(1506,'1','311','1',1,'Retail Sale Id 1567',4140.00,0.00,0.00,6.00,582.00,'2023-03-12 15:19:00','',''),(1507,'1','311','1',1,'Retail Sale Id 1568',8652.60,0.00,0.00,12.54,1216.38,'2023-03-12 15:21:46','',''),(1508,'1','311','1',1,'Retail Sale Id 1569',8625.00,0.00,0.00,12.50,1212.50,'2023-03-12 15:35:22','',''),(1509,'1','311','1',1,'Retail Sale Id 1570',1000.50,0.00,0.00,1.45,140.65,'2023-03-12 15:37:05','',''),(1510,'1','311','1',1,'Retail Sale Id 1571',4140.00,0.00,0.00,6.00,582.00,'2023-03-12 15:39:31','',''),(1511,'1','311','1',1,'Retail Sale Id 1572',4830.00,0.00,0.00,7.00,679.00,'2023-03-12 15:44:13','',''),(1512,'1','311','1',1,'Retail Sale Id 1573',4202.10,0.00,0.00,6.09,590.73,'2023-03-12 15:45:40','',''),(1513,'1','311','1',1,'Retail Sale Id 1574',1497.30,0.00,0.00,2.17,210.49,'2023-03-12 15:47:43','',''),(1514,'1','311','1',1,'Retail Sale Id 1575',3001.50,0.00,0.00,4.35,421.95,'2023-03-12 15:55:22','',''),(1515,'1','311','1',1,'Retail Sale Id 1576',1380.00,0.00,0.00,2.00,194.00,'2023-03-12 15:57:12','',''),(1516,'1','311','1',1,'Retail Sale Id 1577',1380.00,0.00,0.00,2.00,194.00,'2023-03-12 16:00:44','',''),(1517,'1','311','1',1,'Retail Sale Id 1579',696.90,0.00,0.00,1.01,97.97,'2023-03-12 16:04:27','',''),(1518,'1','311','1',1,'Retail Sale Id 1580',8625.00,0.00,0.00,12.50,1212.50,'2023-03-12 16:07:16','',''),(1519,'1','311','1',1,'Retail Sale Id 1581',4830.00,0.00,0.00,7.00,679.00,'2023-03-12 16:09:17','',''),(1520,'1','311','1',1,'Retail Sale Id 1582',1725.00,0.00,0.00,2.50,242.50,'2023-03-12 16:17:24','',''),(1521,'1','311','1',1,'Retail Sale Id 1583',1380.00,0.00,0.00,2.00,194.00,'2023-03-12 16:18:09','',''),(1522,'1','311','1',1,'Retail Sale Id 1584',1497.30,0.00,0.00,2.17,210.49,'2023-03-12 16:19:52','',''),(1523,'1','311','1',1,'Retail Sale Id 1585',6900.00,0.00,0.00,10.00,970.00,'2023-03-12 16:26:48','',''),(1524,'1','311','1',1,'Retail Sale Id 1586',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 16:32:43','',''),(1525,'1','311','1',1,'Retail Sale Id 1587',4830.00,0.00,0.00,7.00,679.00,'2023-03-12 16:34:51','',''),(1526,'1','311','1',1,'Retail Sale Id 1588',1380.00,0.00,0.00,2.00,194.00,'2023-03-12 16:35:54','',''),(1527,'1','311','1',1,'Retail Sale Id 1589',1380.00,0.00,0.00,2.00,194.00,'2023-03-12 16:37:00','',''),(1528,'1','311','1',1,'Retail Sale Id 1590',4140.00,0.00,0.00,6.00,582.00,'2023-03-12 16:42:13','',''),(1529,'1','311','1',1,'Retail Sale Id 1591',696.90,0.00,0.00,1.01,97.97,'2023-03-12 16:44:09','',''),(1530,'1','311','1',1,'Retail Sale Id 1592',3450.00,0.00,0.00,5.00,485.00,'2023-03-12 16:45:03','',''),(1531,'1','311','1',1,'Retail Sale Id 1593',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 16:46:24','',''),(1532,'1','311','1',1,'Retail Sale Id 1594',1000.50,0.00,0.00,1.45,140.65,'2023-03-12 16:50:21','',''),(1533,'1','311','1',1,'Retail Sale Id 1595',8625.00,0.00,0.00,12.50,1212.50,'2023-03-12 16:56:02','',''),(1534,'1','311','1',1,'Retail Sale Id 1596',696.90,0.00,0.00,1.01,97.97,'2023-03-12 16:57:49','',''),(1535,'1','311','1',1,'Retail Sale Id 1597',1000.50,0.00,0.00,1.45,140.65,'2023-03-12 17:05:19','',''),(1536,'1','311','1',1,'Retail Sale Id 1598',6210.00,0.00,0.00,9.00,873.00,'2023-03-12 17:14:55','',''),(1537,'1','311','1',1,'Return of Retail Sale Id 1581',0.00,4830.00,7.00,0.00,-679.00,'2023-03-12 17:18:53','',''),(1538,'1','311','1',1,'Retail Sale Id 1599',4512.60,0.00,0.00,6.54,634.38,'2023-03-12 17:20:02','',''),(1539,'1','311','1',1,'Retail Sale Id 1601',4830.00,0.00,0.00,7.00,679.00,'2023-03-12 17:21:09','',''),(1540,'1','311','1',1,'Retail Sale Id 1516',690.00,0.00,0.00,1.00,97.00,'2023-03-12 17:23:30','',''),(1541,'1','311','1',1,'Retail Sale Id 1602',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 17:24:21','',''),(1542,'1','311','1',1,'Retail Sale Id 1603',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 17:28:41','',''),(1543,'1','311','1',1,'Retail Sale Id 1604',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 17:30:50','',''),(1544,'1','311','1',1,'Retail Sale Id 1605',8625.00,0.00,0.00,12.50,1212.50,'2023-03-12 17:36:03','',''),(1545,'1','311','1',1,'Retail Sale Id 1606',1497.30,0.00,0.00,2.17,210.49,'2023-03-12 17:37:00','',''),(1546,'1','311','1',1,'Retail Sale Id 1607',4140.00,0.00,0.00,6.00,582.00,'2023-03-12 17:41:01','',''),(1547,'1','311','1',1,'Retail Sale Id 1608',2201.10,0.00,0.00,3.19,309.43,'2023-03-12 17:45:31','',''),(1548,'1','311','1',1,'Retail Sale Id 1609',2070.00,0.00,0.00,3.00,291.00,'2023-03-12 17:47:04','',''),(1549,'1','311','1',1,'Retail Sale Id 1611',3450.00,0.00,0.00,5.00,485.00,'2023-03-12 18:01:07','',''),(1550,'1','311','1',1,'Retail Sale Id 1612',6900.00,0.00,0.00,10.00,970.00,'2023-03-12 18:03:20','',''),(1551,'1','311','1',1,'Retail Sale Id 1614',2760.00,0.00,0.00,4.00,388.00,'2023-03-12 18:06:00','',''),(1552,'1','311','1',1,'Retail Sale Id 1615',2001.00,0.00,0.00,2.90,281.30,'2023-03-12 18:08:56','',''),(1553,'1','311','1',1,'Retail Sale Id 1616',1400.70,0.00,0.00,2.03,196.91,'2023-03-12 18:09:59','',''),(1554,'1','311','1',1,'Retail Sale Id 1617',1380.00,0.00,0.00,2.00,194.00,'2023-03-12 18:14:21','',''),(1555,'1','311','1',1,'Retail Sale Id 1618',2801.40,0.00,0.00,4.06,393.82,'2023-03-12 18:18:52','',''),(1556,'1','311','1',1,'Retail Sale Id 1619',39530.00,0.00,0.00,59.00,4543.00,'2023-03-12 18:22:03','',''),(1557,'1','311','1',1,'Retail Sale Id 1620',3450.00,0.00,0.00,5.00,485.00,'2023-03-12 18:24:08','',''),(1558,'1','311','1',1,'Retail Sale Id 1621',4830.00,0.00,0.00,7.00,679.00,'2023-03-12 18:35:51','',''),(1559,'1','311','1',1,'Return of Retail Sale Id 1612',0.00,6900.00,10.00,0.00,-970.00,'2023-03-12 18:39:13','',''),(1560,'1','311','1',1,'Retail Sale Id 1622',6417.00,0.00,0.00,9.30,902.10,'2023-03-12 18:39:57','',''),(1561,'1','311','1',1,'Return of Retail Sale Id 1509',0.00,6900.00,10.00,0.00,-970.00,'2023-03-12 18:48:26','',''),(1562,'1','311','1',1,'Retail Sale Id 1624',3001.50,0.00,0.00,4.35,421.95,'2023-03-12 18:51:01','',''),(1563,'1','311','1',1,'Retail Sale Id 1625',7134.60,0.00,0.00,10.34,1002.98,'2023-03-12 20:26:15','',''),(1564,'1','311','1',1,'Return of Retail Sale Id 1625',0.00,7134.60,10.34,0.00,-1002.98,'2023-03-12 20:29:05','',''),(1565,'1','311','1',1,'Retail Sale Id 1626',5085.30,0.00,0.00,7.37,714.89,'2023-03-12 20:32:27','',''),(1566,'1','311','1',1,'Retail Sale Id 1627',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 08:17:39','',''),(1567,'1','311','1',1,'Retail Sale Id 1628',4140.00,0.00,0.00,6.00,582.00,'2023-03-14 08:21:18','',''),(1568,'1','311','1',1,'Retail Sale Id 1629',3450.00,0.00,0.00,5.00,485.00,'2023-03-14 08:22:13','',''),(1569,'1','311','1',1,'Retail Sale Id 1630',6900.00,0.00,0.00,10.00,970.00,'2023-03-14 08:24:31','',''),(1570,'1','311','1',1,'Retail Sale Id 1631',8625.00,0.00,0.00,12.50,1212.50,'2023-03-14 08:25:27','',''),(1571,'1','311','1',1,'Retail Sale Id 1632',800.40,0.00,0.00,1.16,112.52,'2023-03-14 08:26:07','',''),(1572,'1','311','1',1,'Retail Sale Id 1633',4140.00,0.00,0.00,6.00,582.00,'2023-03-14 08:27:34','',''),(1573,'1','311','1',1,'Retail Sale Id 1634',4830.00,0.00,0.00,7.00,679.00,'2023-03-14 08:28:34','',''),(1574,'1','311','1',1,'Retail Sale Id 1636',2001.00,0.00,0.00,2.90,281.30,'2023-03-14 08:29:34','',''),(1575,'1','311','1',1,'Retail Sale Id 1637',5520.00,0.00,0.00,8.00,776.00,'2023-03-14 08:31:03','',''),(1576,'1','311','1',1,'Retail Sale Id 1638',4140.00,0.00,0.00,6.00,582.00,'2023-03-14 08:31:49','',''),(1577,'1','311','1',1,'Retail Sale Id 1639',1380.00,0.00,0.00,2.00,194.00,'2023-03-14 08:32:32','',''),(1578,'1','311','1',1,'Retail Sale Id 1640',3450.00,0.00,0.00,5.00,485.00,'2023-03-14 08:34:21','',''),(1579,'1','311','1',1,'Retail Sale Id 1641',2001.00,0.00,0.00,2.90,281.30,'2023-03-14 08:35:04','',''),(1580,'1','311','1',1,'Retail Sale Id 1642',4830.00,0.00,0.00,7.00,679.00,'2023-03-14 08:35:55','',''),(1581,'1','311','1',1,'Retail Sale Id 1643',4830.00,0.00,0.00,7.00,679.00,'2023-03-14 08:36:46','',''),(1582,'1','311','1',1,'Retail Sale Id 1644',1000.50,0.00,0.00,1.45,140.65,'2023-03-14 08:37:55','',''),(1583,'1','311','1',1,'Retail Sale Id 1645',4140.00,0.00,0.00,6.00,582.00,'2023-03-14 08:38:39','',''),(1584,'1','311','1',1,'Return of Retail Sale Id 1637',0.00,5520.00,8.00,0.00,-776.00,'2023-03-14 08:40:20','',''),(1585,'1','311','1',1,'Retail Sale Id 1647',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 08:41:04','',''),(1586,'1','311','1',1,'Retail Sale Id 1648',4830.00,0.00,0.00,7.00,679.00,'2023-03-14 08:41:49','',''),(1587,'1','311','1',1,'Retail Sale Id 1649',2097.60,0.00,0.00,3.04,294.88,'2023-03-14 08:42:44','',''),(1588,'1','311','1',1,'Retail Sale Id 1650',4830.00,0.00,0.00,7.00,679.00,'2023-03-14 08:43:33','',''),(1589,'1','311','1',1,'Retail Sale Id 1651',8625.00,0.00,0.00,12.50,1212.50,'2023-03-14 08:44:23','',''),(1590,'1','311','1',1,'Retail Sale Id 1652',6900.00,0.00,0.00,10.00,970.00,'2023-03-14 08:45:19','',''),(1591,'1','311','1',1,'Retail Sale Id 1653',4140.00,0.00,0.00,6.00,582.00,'2023-03-14 08:48:01','',''),(1592,'1','311','1',1,'Retail Sale Id 1654',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 08:48:51','',''),(1593,'1','311','1',1,'Retail Sale Id 1655',4830.00,0.00,0.00,7.00,679.00,'2023-03-14 08:49:39','',''),(1594,'1','311','1',1,'Retail Sale Id 1657',4830.00,0.00,0.00,7.00,679.00,'2023-03-14 08:50:58','',''),(1595,'1','311','1',1,'Retail Sale Id 1658',2760.00,0.00,0.00,4.00,388.00,'2023-03-14 08:51:43','',''),(1596,'1','311','1',1,'Retail Sale Id 1656',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 08:52:13','',''),(1597,'1','311','1',1,'Retail Sale Id 1659',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 08:53:27','',''),(1598,'1','311','1',1,'Retail Sale Id 1660',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 08:55:49','',''),(1599,'1','311','1',1,'Retail Sale Id 1661',6900.00,0.00,0.00,10.00,970.00,'2023-03-14 08:57:35','',''),(1600,'1','311','1',1,'Retail Sale Id 1662',5002.50,0.00,0.00,7.25,703.25,'2023-03-14 08:58:53','',''),(1601,'1','311','1',1,'Retail Sale Id 1665',4140.00,0.00,0.00,6.00,582.00,'2023-03-14 09:03:27','',''),(1602,'1','311','1',1,'Retail Sale Id 1667',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 09:06:13','',''),(1603,'1','311','1',1,'Retail Sale Id 1668',3450.00,0.00,0.00,5.00,485.00,'2023-03-14 09:09:44','',''),(1604,'1','311','1',1,'Retail Sale Id 1669',1380.00,0.00,0.00,2.00,194.00,'2023-03-14 09:11:19','',''),(1605,'1','311','1',1,'Retail Sale Id 1670',2760.00,0.00,0.00,4.00,388.00,'2023-03-14 09:12:36','',''),(1606,'1','311','1',1,'Retail Sale Id 1671',4830.00,0.00,0.00,7.00,679.00,'2023-03-14 09:18:01','',''),(1607,'1','311','1',1,'Retail Sale Id 1672',2001.00,0.00,0.00,2.90,281.30,'2023-03-14 09:21:42','',''),(1608,'1','311','1',1,'Retail Sale Id 1673',4146.90,0.00,0.00,6.01,582.97,'2023-03-14 09:29:58','',''),(1609,'1','311','1',1,'Retail Sale Id 1674',2001.00,0.00,0.00,2.90,281.30,'2023-03-14 09:37:20','',''),(1610,'1','311','1',1,'Retail Sale Id 1675',2201.10,0.00,0.00,3.19,309.43,'2023-03-14 09:41:12','',''),(1611,'1','311','1',1,'Retail Sale Id 1676',5520.00,0.00,0.00,8.00,776.00,'2023-03-14 09:45:21','',''),(1612,'1','311','1',1,'Retail Sale Id 1678',1380.00,0.00,0.00,2.00,194.00,'2023-03-14 09:52:58','',''),(1613,'1','311','1',1,'Retail Sale Id 1678',6900.00,0.00,0.00,10.00,970.00,'2023-03-14 09:52:58','',''),(1614,'1','311','1',1,'Retail Sale Id 1679',8280.00,0.00,0.00,12.00,1164.00,'2023-03-14 09:54:28','',''),(1615,'1','311','1',1,'Retail Sale Id 1680',4830.00,0.00,0.00,7.00,679.00,'2023-03-14 09:55:44','',''),(1616,'1','311','1',1,'Retail Sale Id 1681',4140.00,0.00,0.00,6.00,582.00,'2023-03-14 10:02:53','',''),(1617,'1','311','1',1,'Retail Sale Id 1682',5002.50,0.00,0.00,7.25,703.25,'2023-03-14 10:04:51','',''),(1618,'1','311','1',1,'Retail Sale Id 1683',2760.00,0.00,0.00,4.00,388.00,'2023-03-14 10:08:06','',''),(1619,'1','311','1',1,'Retail Sale Id 1684',3450.00,0.00,0.00,5.00,485.00,'2023-03-14 10:16:07','',''),(1620,'1','311','1',1,'Retail Sale Id 1685',4140.00,0.00,0.00,6.00,582.00,'2023-03-14 10:17:40','',''),(1621,'1','311','1',1,'Retail Sale Id 1686',474963.00,0.00,0.00,708.90,54585.30,'2023-03-14 10:19:50','',''),(1622,'1','311','1',1,'Retail Sale Id 1687',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 10:20:51','',''),(1623,'1','311','1',1,'Retail Sale Id 1688',2760.00,0.00,0.00,4.00,388.00,'2023-03-14 10:21:50','',''),(1624,'1','311','1',1,'Retail Sale Id 1689',2001.00,0.00,0.00,2.90,281.30,'2023-03-14 10:23:06','',''),(1625,'1','311','1',1,'Retail Sale Id 1691',696.90,0.00,0.00,1.01,97.97,'2023-03-14 10:24:32','',''),(1626,'1','311','1',1,'Retail Sale Id 1692',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 10:35:55','',''),(1627,'1','311','1',1,'Retail Sale Id 1693',1380.00,0.00,0.00,2.00,194.00,'2023-03-14 10:51:31','',''),(1628,'1','311','1',1,'Retail Sale Id 1695',4140.00,0.00,0.00,6.00,582.00,'2023-03-14 11:07:48','',''),(1629,'1','311','1',1,'Retail Sale Id 1696',2001.00,0.00,0.00,2.90,281.30,'2023-03-14 11:11:36','',''),(1630,'1','311','1',1,'Retail Sale Id 1697',8625.00,0.00,0.00,12.50,1212.50,'2023-03-14 11:13:13','',''),(1631,'1','311','1',1,'Retail Sale Id 1698',8280.00,0.00,0.00,12.00,1164.00,'2023-03-14 11:18:54','',''),(1632,'1','311','1',1,'Retail Sale Id 1699',1400.70,0.00,0.00,2.03,196.91,'2023-03-14 11:29:12','',''),(1633,'1','311','1',1,'Retail Sale Id 1700',2001.00,0.00,0.00,2.90,281.30,'2023-03-14 11:29:59','',''),(1634,'1','311','1',1,'Retail Sale Id 1701',6900.00,0.00,0.00,10.00,970.00,'2023-03-14 11:32:20','',''),(1635,'1','311','1',1,'Retail Sale Id 1702',1400.70,0.00,0.00,2.03,196.91,'2023-03-14 11:33:07','',''),(1636,'1','311','1',1,'Retail Sale Id 1703',55610.00,0.00,0.00,83.00,6391.00,'2023-03-14 11:34:41','',''),(1637,'1','311','1',1,'Retail Sale Id 1704',8625.00,0.00,0.00,12.50,1212.50,'2023-03-14 11:40:29','',''),(1638,'1','311','1',1,'Retail Sale Id 1705',8625.00,0.00,0.00,12.50,1212.50,'2023-03-14 11:42:41','',''),(1639,'1','311','1',1,'Retail Sale Id 1706',8280.00,0.00,0.00,12.00,1164.00,'2023-03-14 11:44:01','',''),(1640,'1','311','1',1,'Retail Sale Id 1707',1380.00,0.00,0.00,2.00,194.00,'2023-03-14 11:48:14','',''),(1641,'1','311','1',1,'Retail Sale Id 1708',4140.00,0.00,0.00,6.00,582.00,'2023-03-14 11:55:14','',''),(1642,'1','311','1',1,'Retail Sale Id 1709',2801.40,0.00,0.00,4.06,393.82,'2023-03-14 11:57:54','',''),(1643,'1','311','1',1,'Retail Sale Id 1710',3450.00,0.00,0.00,5.00,485.00,'2023-03-14 11:58:37','',''),(1644,'1','311','1',1,'Retail Sale Id 1711',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 12:08:26','',''),(1645,'1','311','1',1,'Retail Sale Id 1712',2760.00,0.00,0.00,4.00,388.00,'2023-03-14 12:09:46','',''),(1646,'1','311','1',1,'Retail Sale Id 1713',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 12:25:39','',''),(1647,'1','311','1',1,'Retail Sale Id 1714',8625.00,0.00,0.00,12.50,1212.50,'2023-03-14 12:28:49','',''),(1648,'1','311','1',1,'Retail Sale Id 1714',8625.00,0.00,0.00,12.50,1212.50,'2023-03-14 12:28:49','',''),(1649,'1','311','1',1,'Retail Sale Id 1715',134000.00,0.00,0.00,200.00,15400.00,'2023-03-14 12:38:49','',''),(1650,'1','311','1',1,'Retail Sale Id 1716',3450.00,0.00,0.00,5.00,485.00,'2023-03-14 12:40:36','',''),(1651,'1','311','1',1,'Retail Sale Id 1718',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 12:51:25','',''),(1652,'1','311','1',1,'Retail Sale Id 1719',2760.00,0.00,0.00,4.00,388.00,'2023-03-14 12:59:07','',''),(1653,'1','311','1',1,'Retail Sale Id 1720',1000.50,0.00,0.00,1.45,140.65,'2023-03-14 12:59:50','',''),(1654,'1','311','1',1,'Retail Sale Id 1722',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 13:14:24','',''),(1655,'1','311','1',1,'Retail Sale Id 1723',8625.00,0.00,0.00,12.50,1212.50,'2023-03-14 13:18:23','',''),(1656,'1','311','1',1,'Retail Sale Id 1724',8625.00,0.00,0.00,12.50,1212.50,'2023-03-14 13:20:55','',''),(1657,'1','311','1',1,'Retail Sale Id 1725',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 13:22:27','',''),(1658,'1','311','1',1,'Retail Sale Id 1726',4140.00,0.00,0.00,6.00,582.00,'2023-03-14 13:39:02','',''),(1659,'1','311','1',1,'Retail Sale Id 1727',5520.00,0.00,0.00,8.00,776.00,'2023-03-14 13:43:12','',''),(1660,'1','311','1',1,'Retail Sale Id 1728',1380.00,0.00,0.00,2.00,194.00,'2023-03-14 13:54:38','',''),(1661,'1','311','1',1,'Retail Sale Id 1729',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 13:58:03','',''),(1662,'1','311','1',1,'Retail Sale Id 1730',3450.00,0.00,0.00,5.00,485.00,'2023-03-14 14:14:02','',''),(1663,'1','311','1',1,'Retail Sale Id 1730',8970.00,0.00,0.00,13.00,1261.00,'2023-03-14 14:14:02','',''),(1664,'1','311','1',1,'Retail Sale Id 1731',1000.50,0.00,0.00,1.45,140.65,'2023-03-14 14:17:20','',''),(1665,'1','311','1',1,'Retail Sale Id 1732',4140.00,0.00,0.00,6.00,582.00,'2023-03-14 14:18:21','',''),(1666,'1','311','1',1,'Retail Sale Id 1733',4140.00,0.00,0.00,6.00,582.00,'2023-03-14 14:21:55','',''),(1667,'1','311','1',1,'Retail Sale Id 1734',8625.00,0.00,0.00,12.50,1212.50,'2023-03-14 14:22:57','',''),(1668,'1','311','1',1,'Retail Sale Id 1735',7590.00,0.00,0.00,11.00,1067.00,'2023-03-14 14:23:46','',''),(1669,'1','311','1',1,'Retail Sale Id 1736',4140.00,0.00,0.00,6.00,582.00,'2023-03-14 14:25:49','',''),(1670,'1','311','1',1,'Retail Sale Id 1737',1380.00,0.00,0.00,2.00,194.00,'2023-03-14 14:27:33','',''),(1671,'1','311','1',1,'Retail Sale Id 1738',10350.00,0.00,0.00,15.00,1455.00,'2023-03-14 14:28:33','',''),(1672,'1','311','1',1,'Retail Sale Id 1739',3001.50,0.00,0.00,4.35,421.95,'2023-03-14 14:31:31','',''),(1673,'1','311','1',1,'Retail Sale Id 1740',4830.00,0.00,0.00,7.00,679.00,'2023-03-14 14:37:21','',''),(1674,'1','311','1',1,'Retail Sale Id 1741',4140.00,0.00,0.00,6.00,582.00,'2023-03-14 14:40:54','',''),(1675,'1','311','1',1,'Retail Sale Id 1742',5520.00,0.00,0.00,8.00,776.00,'2023-03-14 14:44:52','',''),(1676,'1','311','1',1,'Retail Sale Id 1743',3450.00,0.00,0.00,5.00,485.00,'2023-03-14 14:49:27','',''),(1677,'1','311','1',1,'Retail Sale Id 1744',3001.50,0.00,0.00,4.35,421.95,'2023-03-14 15:00:02','',''),(1678,'1','311','1',1,'Retail Sale Id 1745',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 15:02:09','',''),(1679,'1','311','1',1,'Retail Sale Id 1746',8625.00,0.00,0.00,12.50,1212.50,'2023-03-14 15:20:07','',''),(1680,'1','311','1',1,'Retail Sale Id 1746',15870.00,0.00,0.00,23.00,2231.00,'2023-03-14 15:20:07','',''),(1681,'1','311','1',1,'Retail Sale Id 1748',3450.00,0.00,0.00,5.00,485.00,'2023-03-14 15:31:15','',''),(1682,'1','311','1',1,'Retail Sale Id 1749',5520.00,0.00,0.00,8.00,776.00,'2023-03-14 15:31:49','',''),(1683,'1','311','1',1,'Retail Sale Id 1751',5520.00,0.00,0.00,8.00,776.00,'2023-03-14 15:35:08','',''),(1684,'1','311','1',1,'Retail Sale Id 1753',4140.00,0.00,0.00,6.00,582.00,'2023-03-14 15:38:07','',''),(1685,'1','311','1',1,'Retail Sale Id 1755',2760.00,0.00,0.00,4.00,388.00,'2023-03-14 15:44:16','',''),(1686,'1','311','1',1,'Retail Sale Id 1756',8625.00,0.00,0.00,12.50,1212.50,'2023-03-14 15:45:11','',''),(1687,'1','311','1',1,'Retail Sale Id 1757',4830.00,0.00,0.00,7.00,679.00,'2023-03-14 15:48:12','',''),(1688,'1','311','1',1,'Retail Sale Id 1758',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 15:49:16','',''),(1689,'1','311','1',1,'Retail Sale Id 1760',4850.70,0.00,0.00,7.03,681.91,'2023-03-14 15:50:47','',''),(1690,'1','311','1',1,'Retail Sale Id 1761',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 15:52:10','',''),(1691,'1','311','1',1,'Retail Sale Id 1766',2760.00,0.00,0.00,4.00,388.00,'2023-03-14 15:54:19','',''),(1692,'1','311','1',1,'Return of Retail Sale Id 1757',0.00,4830.00,7.00,0.00,-679.00,'2023-03-14 15:57:03','',''),(1693,'1','311','1',1,'Retail Sale Id 1767',4512.60,0.00,0.00,6.54,634.38,'2023-03-14 15:59:06','',''),(1694,'1','311','1',1,'Retail Sale Id 1768',3450.00,0.00,0.00,5.00,485.00,'2023-03-14 16:00:34','',''),(1695,'1','311','1',1,'Retail Sale Id 1769',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 16:01:33','',''),(1696,'1','311','1',1,'Retail Sale Id 1770',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 16:04:25','',''),(1697,'1','311','1',1,'Retail Sale Id 1771',8625.00,0.00,0.00,12.50,1212.50,'2023-03-14 16:05:08','',''),(1698,'1','311','1',1,'Retail Sale Id 1772',3450.00,0.00,0.00,5.00,485.00,'2023-03-14 16:05:54','',''),(1699,'1','311','1',1,'Retail Sale Id 1775',1400.70,0.00,0.00,2.03,196.91,'2023-03-14 16:08:36','',''),(1700,'1','311','1',1,'Retail Sale Id 1776',1497.30,0.00,0.00,2.17,210.49,'2023-03-14 16:11:04','',''),(1701,'1','311','1',1,'Retail Sale Id 1777',4140.00,0.00,0.00,6.00,582.00,'2023-03-14 16:11:53','',''),(1702,'1','311','1',1,'Retail Sale Id 1779',6900.00,0.00,0.00,10.00,970.00,'2023-03-14 16:15:40','',''),(1703,'1','311','1',1,'Retail Sale Id 1780',2001.00,0.00,0.00,2.90,281.30,'2023-03-14 16:16:31','',''),(1704,'1','311','1',1,'Retail Sale Id 1781',4830.00,0.00,0.00,7.00,679.00,'2023-03-14 16:17:22','',''),(1705,'1','311','1',1,'Retail Sale Id 1782',3001.50,0.00,0.00,4.35,421.95,'2023-03-14 16:18:48','',''),(1706,'1','311','1',1,'Retail Sale Id 1782',5002.50,0.00,0.00,7.25,703.25,'2023-03-14 16:18:48','',''),(1707,'1','311','1',1,'Retail Sale Id 1783',4830.00,0.00,0.00,7.00,679.00,'2023-03-14 16:19:46','',''),(1708,'1','311','1',1,'Retail Sale Id 1773',1725.00,0.00,0.00,2.50,242.50,'2023-03-14 16:21:24','',''),(1709,'1','311','1',1,'Retail Sale Id 1784',3001.50,0.00,0.00,4.35,421.95,'2023-03-14 16:22:26','',''),(1710,'1','311','1',1,'Retail Sale Id 1785',8625.00,0.00,0.00,12.50,1212.50,'2023-03-14 16:23:31','',''),(1711,'1','311','1',1,'Retail Sale Id 1786',4140.00,0.00,0.00,6.00,582.00,'2023-03-14 16:25:25','',''),(1712,'1','311','1',1,'Retail Sale Id 1786',6900.00,0.00,0.00,10.00,970.00,'2023-03-14 16:25:25','',''),(1713,'1','311','1',1,'Retail Sale Id 1787',4830.00,0.00,0.00,7.00,679.00,'2023-03-14 16:26:35','',''),(1714,'1','311','1',1,'Retail Sale Id 1788',1035.00,0.00,0.00,1.50,145.50,'2023-03-14 16:37:38','',''),(1715,'1','311','1',1,'Retail Sale Id 1788',8625.00,0.00,0.00,12.50,1212.50,'2023-03-14 16:37:38','',''),(1716,'1','311','1',1,'Retail Sale Id 1791',1400.70,0.00,0.00,2.03,196.91,'2023-03-14 16:39:32','',''),(1717,'1','311','1',1,'Retail Sale Id 1792',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 16:41:17','',''),(1718,'1','311','1',1,'Retail Sale Id 1793',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 16:44:28','',''),(1719,'1','311','1',1,'Retail Sale Id 1794',3450.00,0.00,0.00,5.00,485.00,'2023-03-14 16:45:19','',''),(1720,'1','311','1',1,'Retail Sale Id 1789',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 16:46:06','',''),(1721,'1','311','1',1,'Retail Sale Id 1795',1380.00,0.00,0.00,2.00,194.00,'2023-03-14 16:47:01','',''),(1722,'1','311','1',1,'Retail Sale Id 1797',1380.00,0.00,0.00,2.00,194.00,'2023-03-14 16:50:48','',''),(1723,'1','311','1',1,'Retail Sale Id 1797',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 16:50:48','',''),(1724,'1','311','1',1,'Retail Sale Id 1798',2760.00,0.00,0.00,4.00,388.00,'2023-03-14 16:54:04','',''),(1725,'1','311','1',1,'Retail Sale Id 1800',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 16:57:17','',''),(1726,'1','311','1',1,'Retail Sale Id 1801',1400.70,0.00,0.00,2.03,196.91,'2023-03-14 17:02:08','',''),(1727,'1','311','1',1,'Retail Sale Id 1802',1000.50,0.00,0.00,1.45,140.65,'2023-03-14 17:04:03','',''),(1728,'1','311','1',1,'Retail Sale Id 1802',2001.00,0.00,0.00,2.90,281.30,'2023-03-14 17:04:04','',''),(1729,'1','311','1',1,'Retail Sale Id 1803',2801.40,0.00,0.00,4.06,393.82,'2023-03-14 17:06:33','',''),(1730,'1','311','1',1,'Return of Retail Sale Id 1802',0.00,1000.50,1.45,0.00,-140.65,'2023-03-14 17:08:55','',''),(1731,'1','311','1',1,'Return of Retail Sale Id 1802',0.00,2001.00,2.90,0.00,-281.30,'2023-03-14 17:08:55','',''),(1732,'1','311','1',1,'Retail Sale Id 1804',2001.00,0.00,0.00,2.90,281.30,'2023-03-14 17:10:13','',''),(1733,'1','311','1',1,'Retail Sale Id 1804',2001.00,0.00,0.00,2.90,281.30,'2023-03-14 17:10:13','',''),(1734,'1','311','1',1,'Retail Sale Id 1805',1380.00,0.00,0.00,2.00,194.00,'2023-03-14 17:12:36','',''),(1735,'1','311','1',1,'Retail Sale Id 1806',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 17:13:48','',''),(1736,'1','311','1',1,'Retail Sale Id 1807',3450.00,0.00,0.00,5.00,485.00,'2023-03-14 17:15:21','',''),(1737,'1','311','1',1,'Retail Sale Id 1808',1380.00,0.00,0.00,2.00,194.00,'2023-03-14 17:16:14','',''),(1738,'1','311','1',1,'Retail Sale Id 1809',1000.50,0.00,0.00,1.45,140.65,'2023-03-14 17:17:12','',''),(1739,'1','311','1',1,'Retail Sale Id 1810',3450.00,0.00,0.00,5.00,485.00,'2023-03-14 17:19:45','',''),(1740,'1','311','1',1,'Retail Sale Id 1811',1380.00,0.00,0.00,2.00,194.00,'2023-03-14 17:21:28','',''),(1741,'1','311','1',1,'Retail Sale Id 1812',1380.00,0.00,0.00,2.00,194.00,'2023-03-14 17:22:59','',''),(1742,'1','311','1',1,'Retail Sale Id 1814',6900.00,0.00,0.00,10.00,970.00,'2023-03-14 17:25:35','',''),(1743,'1','311','1',1,'Retail Sale Id 1815',3001.50,0.00,0.00,4.35,421.95,'2023-03-14 17:26:33','',''),(1744,'1','311','1',1,'Retail Sale Id 1816',1000.50,0.00,0.00,1.45,140.65,'2023-03-14 17:27:30','',''),(1745,'1','311','1',1,'Retail Sale Id 1817',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 17:28:23','',''),(1746,'1','311','1',1,'Retail Sale Id 1818',3450.00,0.00,0.00,5.00,485.00,'2023-03-14 17:30:32','',''),(1747,'1','311','1',1,'Retail Sale Id 1819',3450.00,0.00,0.00,5.00,485.00,'2023-03-14 17:34:03','',''),(1748,'1','311','1',1,'Retail Sale Id 1820',2070.00,0.00,0.00,3.00,291.00,'2023-03-14 17:35:14','',''),(1749,'1','311','1',1,'Retail Sale Id 1821',4830.00,0.00,0.00,7.00,679.00,'2023-03-14 17:38:34','',''),(1750,'1','311','1',1,'Retail Sale Id 1822',3450.00,0.00,0.00,5.00,485.00,'2023-03-14 17:39:34','',''),(1751,'1','311','1',1,'Retail Sale Id 1823',8280.00,0.00,0.00,12.00,1164.00,'2023-03-14 17:41:11','',''),(1752,'1','311','1',1,'Retail Sale Id 1824',2415.00,0.00,0.00,3.50,339.50,'2023-03-14 17:52:40','',''),(1753,'1','311','1',1,'Return of Retail Sale Id 1686',0.00,474963.00,708.90,0.00,-54585.30,'2023-03-14 18:19:36','',''),(1754,'1','311','1',1,'Retail Sale Id 1825',373726.00,0.00,0.00,557.80,42950.60,'2023-03-14 18:23:51','',''),(1755,'1','311','1',1,'Retail Sale Id 1826',284689.70,0.00,0.00,424.91,32718.07,'2023-03-14 18:27:29','',''),(1756,'1','311','1',1,'Return of Retail Sale Id 1788',0.00,1035.00,1.50,0.00,-145.50,'2023-03-14 18:32:54','',''),(1757,'1','311','1',1,'Return of Retail Sale Id 1788',0.00,8625.00,12.50,0.00,-1212.50,'2023-03-14 18:32:54','',''),(1758,'1','311','1',1,'Return of Retail Sale Id 1823',0.00,8280.00,12.00,0.00,-1164.00,'2023-03-14 18:34:22','',''),(1759,'1','311','1',1,'Return of Retail Sale Id 1814',0.00,6900.00,10.00,0.00,-970.00,'2023-03-14 18:35:48','',''),(1760,'1','311','1',1,'Return of Retail Sale Id 1821',0.00,4830.00,7.00,0.00,-679.00,'2023-03-14 18:37:45','',''),(1761,'1','311','1',1,'Retail Sale Id 1827',2967.00,0.00,0.00,4.30,417.10,'2023-03-14 18:38:29','',''),(1762,'1','311','1',1,'Retail Sale Id 1829',1000.50,0.00,0.00,1.45,140.65,'2023-03-15 08:01:57','',''),(1763,'1','311','1',1,'Retail Sale Id 1828',4140.00,0.00,0.00,6.00,582.00,'2023-03-15 08:03:32','',''),(1764,'1','311','1',1,'Retail Sale Id 1830',2070.00,0.00,0.00,3.00,291.00,'2023-03-15 08:12:47','',''),(1765,'1','311','1',1,'Retail Sale Id 1830',6900.00,0.00,0.00,10.00,970.00,'2023-03-15 08:12:47','',''),(1766,'1','311','1',1,'Retail Sale Id 1831',2070.00,0.00,0.00,3.00,291.00,'2023-03-15 08:14:20','',''),(1767,'1','311','1',1,'Retail Sale Id 1832',5002.50,0.00,0.00,7.25,703.25,'2023-03-15 08:15:40','',''),(1768,'1','311','1',1,'Retail Sale Id 1833',6996.60,0.00,0.00,10.14,983.58,'2023-03-15 08:16:55','',''),(1769,'1','311','1',1,'Retail Sale Id 1834',8625.00,0.00,0.00,12.50,1212.50,'2023-03-15 08:19:21','',''),(1770,'1','311','1',1,'Retail Sale Id 1835',6900.00,0.00,0.00,10.00,970.00,'2023-03-15 08:20:31','',''),(1771,'1','311','1',1,'Retail Sale Id 1836',3450.00,0.00,0.00,5.00,485.00,'2023-03-15 08:23:02','',''),(1772,'1','311','1',1,'Retail Sale Id 1837',1380.00,0.00,0.00,2.00,194.00,'2023-03-15 08:27:06','',''),(1773,'1','311','1',1,'Retail Sale Id 1838',1352.40,0.00,0.00,1.96,190.12,'2023-03-15 08:28:31','',''),(1774,'1','311','1',1,'Retail Sale Id 1839',2697.90,0.00,0.00,3.91,379.27,'2023-03-15 08:36:22','',''),(1775,'1','311','1',1,'Retail Sale Id 1840',1380.00,0.00,0.00,2.00,194.00,'2023-03-15 08:38:30','',''),(1776,'1','311','1',1,'Retail Sale Id 1841',134000.00,0.00,0.00,200.00,15400.00,'2023-03-15 08:44:35','',''),(1777,'1','311','1',1,'Retail Sale Id 1842',2070.00,0.00,0.00,3.00,291.00,'2023-03-15 08:45:10','',''),(1778,'1','311','1',1,'Retail Sale Id 1843',3450.00,0.00,0.00,5.00,485.00,'2023-03-15 08:45:45','',''),(1779,'1','311','1',1,'Retail Sale Id 1844',1000.50,0.00,0.00,1.45,140.65,'2023-03-15 08:46:41','',''),(1780,'1','311','1',1,'Retail Sale Id 1845',5002.50,0.00,0.00,7.25,703.25,'2023-03-15 08:50:35','',''),(1781,'1','311','1',1,'Retail Sale Id 1846',2001.00,0.00,0.00,2.90,281.30,'2023-03-15 08:52:31','',''),(1782,'1','311','1',1,'Retail Sale Id 1847',1600.80,0.00,0.00,2.32,225.04,'2023-03-15 08:53:59','',''),(1783,'1','311','1',1,'Retail Sale Id 1848',4830.00,0.00,0.00,7.00,679.00,'2023-03-15 09:02:56','',''),(1784,'1','311','1',1,'Retail Sale Id 1849',6210.00,0.00,0.00,9.00,873.00,'2023-03-15 09:06:01','',''),(1785,'1','311','1',1,'Retail Sale Id 1850',2760.00,0.00,0.00,4.00,388.00,'2023-03-15 09:10:35','',''),(1786,'1','311','1',1,'Retail Sale Id 1851',1400.70,0.00,0.00,2.03,196.91,'2023-03-15 09:12:58','',''),(1787,'1','311','1',1,'Retail Sale Id 1852',2760.00,0.00,0.00,4.00,388.00,'2023-03-15 09:22:13','',''),(1788,'1','311','1',1,'Retail Sale Id 1853',1380.00,0.00,0.00,2.00,194.00,'2023-03-15 09:23:03','',''),(1789,'1','311','1',1,'Retail Sale Id 1854',4140.00,0.00,0.00,6.00,582.00,'2023-03-15 09:23:59','',''),(1790,'1','311','1',1,'Retail Sale Id 1855',3001.50,0.00,0.00,4.35,421.95,'2023-03-15 09:32:00','',''),(1791,'1','311','1',1,'Retail Sale Id 1856',8625.00,0.00,0.00,12.50,1212.50,'2023-03-15 09:37:16','',''),(1792,'1','311','1',1,'Retail Sale Id 1857',2760.00,0.00,0.00,4.00,388.00,'2023-03-15 09:38:53','',''),(1793,'1','311','1',1,'Retail Sale Id 1858',2760.00,0.00,0.00,4.00,388.00,'2023-03-15 10:08:29','',''),(1794,'1','311','1',1,'Retail Sale Id 1860',1497.30,0.00,0.00,2.17,210.49,'2023-03-15 10:32:19','',''),(1795,'1','311','1',1,'Retail Sale Id 1860',2001.00,0.00,0.00,2.90,281.30,'2023-03-15 10:32:19','',''),(1796,'1','311','1',1,'Retail Sale Id 1859',39530.00,0.00,0.00,59.00,4543.00,'2023-03-15 10:33:58','',''),(1797,'1','311','1',1,'Retail Sale Id 1861',2070.00,0.00,0.00,3.00,291.00,'2023-03-15 10:35:25','',''),(1798,'1','311','1',1,'Retail Sale Id 1863',6900.00,0.00,0.00,10.00,970.00,'2023-03-15 10:46:45','',''),(1799,'1','311','1',1,'Retail Sale Id 1865',4140.00,0.00,0.00,6.00,582.00,'2023-03-15 11:03:35','',''),(1800,'1','311','1',1,'Retail Sale Id 1866',4830.00,0.00,0.00,7.00,679.00,'2023-03-15 11:09:57','',''),(1801,'1','311','1',1,'Retail Sale Id 1867',1380.00,0.00,0.00,2.00,194.00,'2023-03-15 11:12:51','',''),(1802,'1','311','1',1,'Retail Sale Id 1872',8625.00,0.00,0.00,12.50,1212.50,'2023-03-15 11:39:48','',''),(1803,'1','311','1',1,'Retail Sale Id 1873',8625.00,0.00,0.00,12.50,1212.50,'2023-03-15 11:49:27','',''),(1804,'1','311','1',1,'Retail Sale Id 1874',2070.00,0.00,0.00,3.00,291.00,'2023-03-15 11:50:47','',''),(1805,'1','311','1',1,'Retail Sale Id 1875',4140.00,0.00,0.00,6.00,582.00,'2023-03-15 11:52:22','',''),(1806,'1','311','1',1,'Retail Sale Id 1876',3450.00,0.00,0.00,5.00,485.00,'2023-03-15 12:15:47','',''),(1807,'1','311','1',1,'Retail Sale Id 1877',8625.00,0.00,0.00,12.50,1212.50,'2023-03-15 12:23:09','',''),(1808,'1','311','1',1,'Retail Sale Id 1879',4002.00,0.00,0.00,5.80,562.60,'2023-03-15 12:50:15','',''),(1809,'1','311','1',1,'Return of Retail Sale Id 1879',0.00,4002.00,5.80,0.00,-562.60,'2023-03-15 12:52:03','',''),(1810,'1','311','1',1,'Retail Sale Id 1880',4002.00,0.00,0.00,5.80,562.60,'2023-03-15 12:52:36','',''),(1811,'1','311','1',1,'Retail Sale Id 1882',6900.00,0.00,0.00,10.00,970.00,'2023-03-15 13:07:44','',''),(1812,'1','311','1',1,'Retail Sale Id 1883',3450.00,0.00,0.00,5.00,485.00,'2023-03-15 13:20:15','',''),(1813,'1','311','1',1,'Retail Sale Id 1884',4830.00,0.00,0.00,7.00,679.00,'2023-03-15 13:46:34','',''),(1814,'1','311','1',1,'Retail Sale Id 1884',4830.00,0.00,0.00,7.00,679.00,'2023-03-15 13:46:34','',''),(1815,'1','311','1',1,'Retail Sale Id 1885',3450.00,0.00,0.00,5.00,485.00,'2023-03-15 13:48:56','',''),(1816,'1','311','1',1,'Retail Sale Id 1886',3450.00,0.00,0.00,5.00,485.00,'2023-03-15 14:38:55','',''),(1817,'1','311','1',1,'Retail Sale Id 1887',8625.00,0.00,0.00,12.50,1212.50,'2023-03-15 14:39:53','',''),(1818,'1','311','1',1,'Retail Sale Id 1888',8625.00,0.00,0.00,12.50,1212.50,'2023-03-15 14:41:13','',''),(1819,'1','311','1',1,'Retail Sale Id 1890',2760.00,0.00,0.00,4.00,388.00,'2023-03-15 14:47:09','',''),(1820,'1','311','1',1,'Retail Sale Id 1891',8625.00,0.00,0.00,12.50,1212.50,'2023-03-15 14:50:24','',''),(1821,'1','311','1',1,'Retail Sale Id 1892',1380.00,0.00,0.00,2.00,194.00,'2023-03-15 14:51:59','',''),(1822,'1','311','1',1,'Retail Sale Id 1894',1380.00,0.00,0.00,2.00,194.00,'2023-03-15 14:54:28','',''),(1823,'1','311','1',1,'Retail Sale Id 1895',6900.00,0.00,0.00,10.00,970.00,'2023-03-15 14:56:22','',''),(1824,'1','311','1',1,'Retail Sale Id 1896',4140.00,0.00,0.00,6.00,582.00,'2023-03-15 14:58:03','',''),(1825,'1','311','1',1,'Retail Sale Id 1897',8625.00,0.00,0.00,12.50,1212.50,'2023-03-15 15:21:28','',''),(1826,'1','311','1',1,'Retail Sale Id 1899',8625.00,0.00,0.00,12.50,1212.50,'2023-03-15 15:43:50','',''),(1827,'1','311','1',1,'Retail Sale Id 1900',8625.00,0.00,0.00,12.50,1212.50,'2023-03-15 15:45:01','',''),(1828,'1','311','1',1,'Retail Sale Id 1901',3450.00,0.00,0.00,5.00,485.00,'2023-03-15 15:46:13','',''),(1829,'1','311','1',1,'Retail Sale Id 1903',1697.40,0.00,0.00,2.46,238.62,'2023-03-15 15:56:55','',''),(1830,'1','311','1',1,'Retail Sale Id 1904',3450.00,0.00,0.00,5.00,485.00,'2023-03-15 16:00:50','',''),(1831,'1','311','1',1,'Retail Sale Id 1905',4002.00,0.00,0.00,5.80,562.60,'2023-03-15 16:02:05','',''),(1832,'1','311','1',1,'Retail Sale Id 1906',1000.50,0.00,0.00,1.45,140.65,'2023-03-15 16:03:57','',''),(1833,'1','311','1',1,'Retail Sale Id 1907',1200.60,0.00,0.00,1.74,168.78,'2023-03-15 16:10:25','',''),(1834,'1','311','1',1,'Retail Sale Id 1908',1380.00,0.00,0.00,2.00,194.00,'2023-03-15 16:12:09','',''),(1835,'1','311','1',1,'Retail Sale Id 1909',1000.50,0.00,0.00,1.45,140.65,'2023-03-15 16:19:43','',''),(1836,'1','311','1',1,'Retail Sale Id 1910',6900.00,0.00,0.00,10.00,970.00,'2023-03-15 16:20:53','',''),(1837,'1','311','1',1,'Retail Sale Id 1911',2070.00,0.00,0.00,3.00,291.00,'2023-03-15 16:22:09','',''),(1838,'1','311','1',1,'Retail Sale Id 1912',3450.00,0.00,0.00,5.00,485.00,'2023-03-15 16:25:37','',''),(1839,'1','311','1',1,'Retail Sale Id 1913',4140.00,0.00,0.00,6.00,582.00,'2023-03-15 16:26:52','',''),(1840,'1','311','1',1,'Retail Sale Id 1914',3498.30,0.00,0.00,5.07,491.79,'2023-03-15 16:28:25','',''),(1841,'1','311','1',1,'Retail Sale Id 1915',2070.00,0.00,0.00,3.00,291.00,'2023-03-15 16:29:50','',''),(1842,'1','311','1',1,'Retail Sale Id 1916',8625.00,0.00,0.00,12.50,1212.50,'2023-03-15 16:31:57','',''),(1843,'1','311','1',1,'Retail Sale Id 1917',1380.00,0.00,0.00,2.00,194.00,'2023-03-15 16:33:03','',''),(1844,'1','311','1',1,'Retail Sale Id 1918',2070.00,0.00,0.00,3.00,291.00,'2023-03-15 16:33:51','',''),(1845,'1','311','1',1,'Retail Sale Id 1919',2070.00,0.00,0.00,3.00,291.00,'2023-03-15 16:34:30','',''),(1846,'1','311','1',1,'Retail Sale Id 1920',8625.00,0.00,0.00,12.50,1212.50,'2023-03-15 16:37:01','',''),(1847,'1','311','1',1,'Retail Sale Id 1921',1000.50,0.00,0.00,1.45,140.65,'2023-03-15 16:38:19','',''),(1848,'1','311','1',1,'Retail Sale Id 1922',3450.00,0.00,0.00,5.00,485.00,'2023-03-15 16:40:25','',''),(1849,'1','311','1',1,'Retail Sale Id 1923',3001.50,0.00,0.00,4.35,421.95,'2023-03-15 16:43:13','',''),(1850,'1','311','1',1,'Retail Sale Id 1924',6900.00,0.00,0.00,10.00,970.00,'2023-03-15 16:47:03','',''),(1851,'1','311','1',1,'Retail Sale Id 1924',6900.00,0.00,0.00,10.00,970.00,'2023-03-15 16:47:03','',''),(1852,'1','311','1',1,'Retail Sale Id 1925',3450.00,0.00,0.00,5.00,485.00,'2023-03-15 16:49:24','',''),(1853,'1','311','1',1,'Retail Sale Id 1926',3450.00,0.00,0.00,5.00,485.00,'2023-03-15 16:52:11','',''),(1854,'1','311','1',1,'Retail Sale Id 1927',2070.00,0.00,0.00,3.00,291.00,'2023-03-15 16:53:59','',''),(1855,'1','311','1',1,'Retail Sale Id 1928',2760.00,0.00,0.00,4.00,388.00,'2023-03-15 16:58:34','',''),(1856,'1','311','1',1,'Retail Sale Id 1929',1497.30,0.00,0.00,2.17,210.49,'2023-03-15 17:02:08','',''),(1857,'1','311','1',1,'Retail Sale Id 1930',1000.50,0.00,0.00,1.45,140.65,'2023-03-15 17:03:31','',''),(1858,'1','311','1',1,'Retail Sale Id 1931',6003.00,0.00,0.00,8.70,843.90,'2023-03-15 17:07:41','',''),(1859,'1','311','1',1,'Retail Sale Id 1933',11385.00,0.00,0.00,16.50,1600.50,'2023-03-15 17:37:28','',''),(1860,'1','311','1',1,'Retail Sale Id 1934',8970.00,0.00,0.00,13.00,1261.00,'2023-03-15 17:38:26','',''),(1861,'1','311','1',1,'Retail Sale Id 1935',2697.90,0.00,0.00,3.91,379.27,'2023-03-15 17:40:03','',''),(1862,'1','311','1',1,'Retail Sale Id 1935',5520.00,0.00,0.00,8.00,776.00,'2023-03-15 17:40:03','',''),(1863,'1','311','1',1,'Return of Retail Sale Id 1933',0.00,11385.00,16.50,0.00,-1600.50,'2023-03-15 17:45:23','',''),(1864,'1','311','1',1,'Retail Sale Id 1936',7672.80,0.00,0.00,11.12,1078.64,'2023-03-15 17:46:10','',''),(1865,'1','311','1',1,'Retail Sale Id 1937',4485.00,0.00,0.00,6.50,630.50,'2023-03-16 08:07:11','',''),(1866,'1','311','1',1,'Retail Sale Id 1938',2070.00,0.00,0.00,3.00,291.00,'2023-03-16 08:19:46','',''),(1867,'1','311','1',1,'Retail Sale Id 1939',3450.00,0.00,0.00,5.00,485.00,'2023-03-16 08:23:44','',''),(1868,'1','311','1',1,'Retail Sale Id 1940',3450.00,0.00,0.00,5.00,485.00,'2023-03-16 08:27:29','',''),(1869,'1','311','1',1,'Retail Sale Id 1940',3450.00,0.00,0.00,5.00,485.00,'2023-03-16 08:27:29','',''),(1870,'1','311','1',1,'Retail Sale Id 1941',2697.90,0.00,0.00,3.91,379.27,'2023-03-16 08:28:46','',''),(1871,'1','311','1',1,'Retail Sale Id 1943',696.90,0.00,0.00,1.01,97.97,'2023-03-16 08:31:11','',''),(1872,'1','311','1',1,'Retail Sale Id 1945',1000.50,0.00,0.00,1.45,140.65,'2023-03-16 08:32:50','',''),(1873,'1','311','1',1,'Retail Sale Id 1946',2497.80,0.00,0.00,3.62,351.14,'2023-03-16 08:34:13','',''),(1874,'1','311','1',1,'Retail Sale Id 1947',3450.00,0.00,0.00,5.00,485.00,'2023-03-16 08:37:36','',''),(1875,'1','311','1',1,'Retail Sale Id 1948',8625.00,0.00,0.00,12.50,1212.50,'2023-03-16 08:40:01','',''),(1876,'1','311','1',1,'Retail Sale Id 1949',7590.00,0.00,0.00,11.00,1067.00,'2023-03-16 08:41:35','',''),(1877,'1','311','1',1,'Retail Sale Id 1950',2070.00,0.00,0.00,3.00,291.00,'2023-03-16 08:47:18','',''),(1878,'1','311','1',1,'Retail Sale Id 1951',8625.00,0.00,0.00,12.50,1212.50,'2023-03-16 08:48:30','',''),(1879,'1','311','1',1,'Retail Sale Id 1952',1497.30,0.00,0.00,2.17,210.49,'2023-03-16 08:52:58','',''),(1880,'1','311','1',1,'Return of Retail Sale Id 1946',0.00,2497.80,3.62,0.00,-351.14,'2023-03-16 08:59:08','',''),(1881,'1','311','1',1,'Return of Retail Sale Id 1941',0.00,2697.90,3.91,0.00,-379.27,'2023-03-16 09:00:08','',''),(1882,'1','311','1',1,'Retail Sale Id 1953',3001.50,0.00,0.00,4.35,421.95,'2023-03-16 09:03:15','',''),(1883,'1','311','1',1,'Retail Sale Id 1954',4002.00,0.00,0.00,5.80,562.60,'2023-03-16 09:10:39','',''),(1884,'1','311','1',1,'Retail Sale Id 1955',2760.00,0.00,0.00,4.00,388.00,'2023-03-16 09:12:12','',''),(1885,'1','311','1',1,'Retail Sale Id 1956',1400.70,0.00,0.00,2.03,196.91,'2023-03-16 09:13:00','',''),(1886,'1','311','1',1,'Retail Sale Id 1957',6900.00,0.00,0.00,10.00,970.00,'2023-03-16 09:13:55','',''),(1887,'1','311','1',1,'Retail Sale Id 1958',1497.30,0.00,0.00,2.17,210.49,'2023-03-16 09:30:39','',''),(1888,'1','311','1',1,'Retail Sale Id 1959',690.00,0.00,0.00,1.00,97.00,'2023-03-16 09:32:15','',''),(1889,'1','311','1',1,'Retail Sale Id 1960',4140.00,0.00,0.00,6.00,582.00,'2023-03-16 09:35:22','',''),(1890,'1','311','1',1,'Retail Sale Id 1961',690.00,0.00,0.00,1.00,97.00,'2023-03-16 09:36:53','',''),(1891,'1','311','1',1,'Retail Sale Id 1962',2415.00,0.00,0.00,3.50,339.50,'2023-03-16 09:39:11','',''),(1892,'1','311','1',1,'Retail Sale Id 1963',2760.00,0.00,0.00,4.00,388.00,'2023-03-16 09:44:43','',''),(1893,'1','311','1',1,'Retail Sale Id 1964',39530.00,0.00,0.00,59.00,4543.00,'2023-03-16 09:46:22','',''),(1894,'1','311','1',1,'Retail Sale Id 1965',2001.00,0.00,0.00,2.90,281.30,'2023-03-16 09:57:52','',''),(1895,'1','311','1',1,'Retail Sale Id 1966',3450.00,0.00,0.00,5.00,485.00,'2023-03-16 10:02:36','',''),(1896,'1','311','1',1,'Retail Sale Id 1967',3450.00,0.00,0.00,5.00,485.00,'2023-03-16 10:17:25','',''),(1897,'1','311','1',1,'Retail Sale Id 1968',4140.00,0.00,0.00,6.00,582.00,'2023-03-16 10:21:07','',''),(1898,'1','311','1',1,'Retail Sale Id 1968',4830.00,0.00,0.00,7.00,679.00,'2023-03-16 10:21:07','',''),(1899,'1','311','1',1,'Retail Sale Id 1968',8625.00,0.00,0.00,12.50,1212.50,'2023-03-16 10:21:07','',''),(1900,'1','311','1',1,'Retail Sale Id 1969',5520.00,0.00,0.00,8.00,776.00,'2023-03-16 10:29:38','',''),(1901,'1','311','1',1,'Retail Sale Id 1970',4485.00,0.00,0.00,6.50,630.50,'2023-03-16 10:31:04','',''),(1902,'1','311','1',1,'Retail Sale Id 1971',4140.00,0.00,0.00,6.00,582.00,'2023-03-16 10:32:36','',''),(1903,'1','311','1',1,'Retail Sale Id 1972',2001.00,0.00,0.00,2.90,281.30,'2023-03-16 10:42:13','',''),(1904,'1','311','1',1,'Retail Sale Id 1973',3450.00,0.00,0.00,5.00,485.00,'2023-03-16 10:43:11','',''),(1905,'1','311','1',1,'Retail Sale Id 1975',67000.00,0.00,0.00,100.00,7700.00,'2023-03-16 10:57:19','',''),(1906,'1','311','1',1,'Retail Sale Id 1976',3001.50,0.00,0.00,4.35,421.95,'2023-03-16 11:03:00','',''),(1907,'1','311','1',1,'Retail Sale Id 1977',3450.00,0.00,0.00,5.00,485.00,'2023-03-16 11:04:32','',''),(1908,'1','311','1',1,'Return of Retail Sale Id 1975',0.00,67000.00,100.00,0.00,-7700.00,'2023-03-16 11:12:36','',''),(1909,'1','311','1',1,'Retail Sale Id 1978',33500.00,0.00,0.00,50.00,3850.00,'2023-03-16 11:13:38','',''),(1910,'1','311','1',1,'Retail Sale Id 1979',33500.00,0.00,0.00,50.00,3850.00,'2023-03-16 11:14:43','',''),(1911,'1','311','1',1,'Retail Sale Id 1980',38746.10,0.00,0.00,57.83,4452.91,'2023-03-16 11:31:29','',''),(1912,'1','311','1',1,'Retail Sale Id 1982',1380.00,0.00,0.00,2.00,194.00,'2023-03-16 11:48:42','',''),(1913,'1','311','1',1,'Retail Sale Id 1983',2001.00,0.00,0.00,2.90,281.30,'2023-03-16 11:50:01','',''),(1914,'1','311','1',1,'Retail Sale Id 1984',8625.00,0.00,0.00,12.50,1212.50,'2023-03-16 12:01:57','',''),(1915,'1','311','1',1,'Retail Sale Id 1985',4830.00,0.00,0.00,7.00,679.00,'2023-03-16 12:07:14','',''),(1916,'1','311','1',1,'Retail Sale Id 1986',1400.70,0.00,0.00,2.03,196.91,'2023-03-16 12:08:29','',''),(1917,'1','311','1',1,'Retail Sale Id 1987',3450.00,0.00,0.00,5.00,485.00,'2023-03-16 12:28:51','',''),(1918,'1','311','1',1,'Retail Sale Id 1988',8625.00,0.00,0.00,12.50,1212.50,'2023-03-16 12:33:33','',''),(1919,'1','311','1',1,'Retail Sale Id 1989',4830.00,0.00,0.00,7.00,679.00,'2023-03-16 12:35:21','',''),(1920,'1','311','1',1,'Retail Sale Id 1990',4830.00,0.00,0.00,7.00,679.00,'2023-03-16 12:37:58','',''),(1921,'1','311','1',1,'Retail Sale Id 1991',1000.50,0.00,0.00,1.45,140.65,'2023-03-16 12:40:40','',''),(1922,'1','311','1',1,'Retail Sale Id 1991',2070.00,0.00,0.00,3.00,291.00,'2023-03-16 12:40:40','',''),(1923,'1','311','1',1,'Return of Retail Sale Id 1989',0.00,4830.00,7.00,0.00,-679.00,'2023-03-16 12:46:28','',''),(1924,'1','311','1',1,'Retail Sale Id 1992',3450.00,0.00,0.00,5.00,485.00,'2023-03-16 12:47:17','',''),(1925,'1','311','1',1,'Retail Sale Id 1993',2070.00,0.00,0.00,3.00,291.00,'2023-03-16 12:51:09','',''),(1926,'1','311','1',1,'Retail Sale Id 1994',3001.50,0.00,0.00,4.35,421.95,'2023-03-16 12:52:43','',''),(1927,'1','311','1',1,'Retail Sale Id 1996',2801.40,0.00,0.00,4.06,393.82,'2023-03-16 13:21:45','',''),(1928,'1','311','1',1,'Retail Sale Id 1997',2760.00,0.00,0.00,4.00,388.00,'2023-03-16 13:42:52','',''),(1929,'1','311','1',1,'Retail Sale Id 1998',5520.00,0.00,0.00,8.00,776.00,'2023-03-16 13:47:38','',''),(1930,'1','311','1',1,'Retail Sale Id 1999',6900.00,0.00,0.00,10.00,970.00,'2023-03-16 13:50:28','',''),(1931,'1','311','1',1,'Retail Sale Id 2000',2070.00,0.00,0.00,3.00,291.00,'2023-03-16 13:51:50','',''),(1932,'1','311','1',1,'Retail Sale Id 2002',4485.00,0.00,0.00,6.50,630.50,'2023-03-16 14:17:46','',''),(1933,'1','311','1',1,'Retail Sale Id 2003',3450.00,0.00,0.00,5.00,485.00,'2023-03-16 14:22:24','',''),(1934,'1','311','1',1,'Retail Sale Id 2005',8625.00,0.00,0.00,12.50,1212.50,'2023-03-16 14:31:05','',''),(1935,'1','311','1',1,'Retail Sale Id 2006',2760.00,0.00,0.00,4.00,388.00,'2023-03-16 14:37:01','',''),(1936,'1','311','1',1,'Retail Sale Id 2007',2070.00,0.00,0.00,3.00,291.00,'2023-03-16 14:37:34','',''),(1937,'1','311','1',1,'Retail Sale Id 2008',2070.00,0.00,0.00,3.00,291.00,'2023-03-16 14:44:22','',''),(1938,'1','311','1',1,'Retail Sale Id 2009',4140.00,0.00,0.00,6.00,582.00,'2023-03-16 15:00:26','',''),(1939,'1','311','1',1,'Retail Sale Id 2010',2001.00,0.00,0.00,2.90,281.30,'2023-03-16 15:04:01','',''),(1940,'1','311','1',1,'Retail Sale Id 2011',3450.00,0.00,0.00,5.00,485.00,'2023-03-16 15:09:23','',''),(1941,'1','311','1',1,'Retail Sale Id 2012',2070.00,0.00,0.00,3.00,291.00,'2023-03-16 15:25:44','',''),(1942,'1','311','1',1,'Retail Sale Id 2013',4830.00,0.00,0.00,7.00,679.00,'2023-03-16 15:46:58','',''),(1943,'1','311','1',1,'Retail Sale Id 2014',690.00,0.00,0.00,1.00,97.00,'2023-03-16 15:59:54','',''),(1944,'1','311','1',1,'Retail Sale Id 2016',4140.00,0.00,0.00,6.00,582.00,'2023-03-16 16:06:41','',''),(1945,'1','311','1',1,'Retail Sale Id 2017',8625.00,0.00,0.00,12.50,1212.50,'2023-03-16 16:08:42','',''),(1946,'1','311','1',1,'Retail Sale Id 2017',8625.00,0.00,0.00,12.50,1212.50,'2023-03-16 16:08:42','',''),(1947,'1','311','1',1,'Retail Sale Id 2018',4140.00,0.00,0.00,6.00,582.00,'2023-03-16 16:09:15','',''),(1948,'1','311','1',1,'Retail Sale Id 2019',3450.00,0.00,0.00,5.00,485.00,'2023-03-16 16:10:09','',''),(1949,'1','311','1',1,'Retail Sale Id 2020',4140.00,0.00,0.00,6.00,582.00,'2023-03-16 16:12:44','',''),(1950,'1','311','1',1,'Retail Sale Id 2021',2076.90,0.00,0.00,3.01,291.97,'2023-03-16 16:16:16','',''),(1951,'1','311','1',1,'Retail Sale Id 2015',6900.00,0.00,0.00,10.00,970.00,'2023-03-16 16:21:49','',''),(1952,'1','311','1',1,'Retail Sale Id 2022',4140.00,0.00,0.00,6.00,582.00,'2023-03-16 16:29:51','',''),(1953,'1','311','1',1,'Retail Sale Id 2023',4002.00,0.00,0.00,5.80,562.60,'2023-03-16 16:37:10','',''),(1954,'1','311','1',1,'Retail Sale Id 2024',2070.00,0.00,0.00,3.00,291.00,'2023-03-16 16:42:55','',''),(1955,'1','311','1',1,'Retail Sale Id 2025',8625.00,0.00,0.00,12.50,1212.50,'2023-03-16 16:45:16','',''),(1956,'1','311','1',1,'Retail Sale Id 2026',8625.00,0.00,0.00,12.50,1212.50,'2023-03-16 16:46:32','',''),(1957,'1','311','1',1,'Retail Sale Id 2027',4140.00,0.00,0.00,6.00,582.00,'2023-03-16 16:52:14','',''),(1958,'1','311','1',1,'Retail Sale Id 2028',3001.50,0.00,0.00,4.35,421.95,'2023-03-16 16:55:49','',''),(1959,'1','311','1',1,'Retail Sale Id 2029',2070.00,0.00,0.00,3.00,291.00,'2023-03-16 17:15:33','',''),(1960,'1','311','1',1,'Retail Sale Id 2030',1000.50,0.00,0.00,1.45,140.65,'2023-03-16 17:17:25','',''),(1961,'1','311','1',1,'Retail Sale Id 2031',4830.00,0.00,0.00,7.00,679.00,'2023-03-16 17:18:26','',''),(1962,'1','311','1',1,'Retail Sale Id 2032',1380.00,0.00,0.00,2.00,194.00,'2023-03-16 17:19:50','',''),(1963,'1','311','1',1,'Retail Sale Id 2033',4140.00,0.00,0.00,6.00,582.00,'2023-03-16 17:20:58','',''),(1964,'1','311','1',1,'Retail Sale Id 2034',1380.00,0.00,0.00,2.00,194.00,'2023-03-16 17:23:06','',''),(1965,'1','311','1',1,'Retail Sale Id 2035',2760.00,0.00,0.00,4.00,388.00,'2023-03-16 17:24:22','',''),(1966,'1','311','1',1,'Retail Sale Id 2036',4830.00,0.00,0.00,7.00,679.00,'2023-03-16 17:26:43','',''),(1967,'1','311','1',1,'Retail Sale Id 2037',5002.50,0.00,0.00,7.25,703.25,'2023-03-16 17:27:58','',''),(1968,'1','311','1',1,'Return of Retail Sale Id 1980',0.00,38746.10,57.83,0.00,-4452.91,'2023-03-16 18:06:32','',''),(1969,'1','311','1',1,'Retail Sale Id 2038',38860.00,0.00,0.00,58.00,4466.00,'2023-03-16 18:09:45','',''),(1970,'1','311','1',1,'Return of Retail Sale Id 1978',0.00,33500.00,50.00,0.00,-3850.00,'2023-03-16 18:11:51','',''),(1971,'1','311','1',1,'Retail Sale Id 2039',32809.90,0.00,0.00,48.97,3770.69,'2023-03-16 18:13:05','',''),(1972,'1','311','1',1,'Return of Retail Sale Id 2012',0.00,2070.00,3.00,0.00,-291.00,'2023-03-16 21:44:22','',''),(1973,'1','311','1',1,'Return of Retail Sale Id 2039',0.00,32809.90,48.97,0.00,-3770.69,'2023-03-16 21:55:29','',''),(1974,'1','311','1',1,'Retail Sale Id 2040',32809.90,0.00,0.00,48.97,3770.69,'2023-03-16 21:57:21','',''),(1975,'1','311','1',1,'Return of Retail Sale Id 1968',0.00,4140.00,6.00,0.00,-582.00,'2023-03-16 22:04:12','',''),(1976,'1','311','1',1,'Return of Retail Sale Id 1968',0.00,4830.00,7.00,0.00,-679.00,'2023-03-16 22:04:12','',''),(1977,'1','311','1',1,'Return of Retail Sale Id 1968',0.00,8625.00,12.50,0.00,-1212.50,'2023-03-16 22:04:12','',''),(1978,'1','311','1',1,'Retail Sale Id 2044',4347.00,0.00,0.00,6.30,611.10,'2023-03-16 22:08:05','',''),(1979,'1','311','1',1,'Retail Sale Id 2044',4830.00,0.00,0.00,7.00,679.00,'2023-03-16 22:08:05','',''),(1980,'1','311','1',1,'Retail Sale Id 2044',8625.00,0.00,0.00,12.50,1212.50,'2023-03-16 22:08:05','',''),(1981,'1','311','1',1,'Retail Sale Id 2045',593.40,0.00,0.00,0.86,83.42,'2023-03-16 22:10:49','',''),(1982,'1','311','1',1,'Return of Retail Sale Id 2045',0.00,593.40,0.86,0.00,-83.42,'2023-03-16 22:12:01','',''),(1983,'1','311','1',1,'Return of Retail Sale Id 2040',0.00,32809.90,48.97,0.00,-3770.69,'2023-03-16 22:13:56','',''),(1984,'1','311','1',1,'Retail Sale Id 2046',32809.90,0.00,0.00,48.97,3770.69,'2023-03-16 22:15:22','',''),(1985,'1','311','1',1,'Return of Retail Sale Id 1964',0.00,39530.00,59.00,0.00,-4543.00,'2023-03-16 22:18:54','',''),(1986,'1','311','1',1,'Retail Sale Id 2047',39530.00,0.00,0.00,59.00,4543.00,'2023-03-16 22:20:11','',''),(1987,'1','311','1',1,'Retail Sale Id 2049',670.00,0.00,0.00,1.00,77.00,'2023-03-16 22:26:42','',''),(1988,'1','311','1',1,'Retail Sale Id 2050',2001.00,0.00,0.00,2.90,281.30,'2023-03-17 07:50:29','',''),(1989,'1','311','1',1,'Retail Sale Id 2051',5002.50,0.00,0.00,7.25,703.25,'2023-03-17 07:52:45','',''),(1990,'1','311','1',1,'Retail Sale Id 2053',8625.00,0.00,0.00,12.50,1212.50,'2023-03-17 08:18:09','',''),(1991,'1','311','1',1,'Retail Sale Id 2054',6900.00,0.00,0.00,10.00,970.00,'2023-03-17 08:39:13','',''),(1992,'1','311','1',1,'Retail Sale Id 2055',2001.00,0.00,0.00,2.90,281.30,'2023-03-17 08:50:38','',''),(1993,'1','311','1',1,'Retail Sale Id 2057',4485.00,0.00,0.00,6.50,630.50,'2023-03-17 08:53:22','',''),(1994,'1','311','1',1,'Retail Sale Id 2058',6900.00,0.00,0.00,10.00,970.00,'2023-03-17 08:54:53','',''),(1995,'1','311','1',1,'Retail Sale Id 2059',3001.50,0.00,0.00,4.35,421.95,'2023-03-17 08:59:23','',''),(1996,'1','311','1',1,'Retail Sale Id 2060',2760.00,0.00,0.00,4.00,388.00,'2023-03-17 09:01:39','',''),(1997,'1','311','1',1,'Retail Sale Id 2061',2070.00,0.00,0.00,3.00,291.00,'2023-03-17 09:13:24','',''),(1998,'1','311','1',1,'Retail Sale Id 2062',8625.00,0.00,0.00,12.50,1212.50,'2023-03-17 09:14:08','',''),(1999,'1','311','1',1,'Retail Sale Id 2063',73700.00,0.00,0.00,110.00,8470.00,'2023-03-17 09:22:05','',''),(2000,'1','311','1',1,'Retail Sale Id 2064',8625.00,0.00,0.00,12.50,1212.50,'2023-03-17 09:25:01','',''),(2001,'1','311','1',1,'Retail Sale Id 2065',2001.00,0.00,0.00,2.90,281.30,'2023-03-17 09:39:59','',''),(2002,'1','311','1',1,'Retail Sale Id 2066',2097.60,0.00,0.00,3.04,294.88,'2023-03-17 09:46:16','',''),(2003,'1','311','1',1,'Retail Sale Id 2067',4140.00,0.00,0.00,6.00,582.00,'2023-03-17 09:52:36','',''),(2004,'1','311','1',1,'Retail Sale Id 2068',3450.00,0.00,0.00,5.00,485.00,'2023-03-17 09:55:32','',''),(2005,'1','311','1',1,'Retail Sale Id 2069',3450.00,0.00,0.00,5.00,485.00,'2023-03-17 10:01:14','',''),(2006,'1','311','1',1,'Return of Retail Sale Id 2067',0.00,4140.00,6.00,0.00,-582.00,'2023-03-17 10:03:55','',''),(2007,'1','311','1',1,'Retail Sale Id 2070',4485.00,0.00,0.00,6.50,630.50,'2023-03-17 10:10:37','',''),(2008,'1','311','1',1,'Retail Sale Id 2071',696.90,0.00,0.00,1.01,97.97,'2023-03-17 10:19:03','',''),(2009,'1','311','1',1,'Retail Sale Id 2072',3450.00,0.00,0.00,5.00,485.00,'2023-03-17 10:23:38','',''),(2010,'1','311','1',1,'Retail Sale Id 2073',3001.50,0.00,0.00,4.35,421.95,'2023-03-17 10:28:06','',''),(2011,'1','311','1',1,'Retail Sale Id 2074',1497.30,0.00,0.00,2.17,210.49,'2023-03-17 10:36:33','',''),(2012,'1','311','1',1,'Retail Sale Id 2076',1497.30,0.00,0.00,2.17,210.49,'2023-03-17 10:43:45','',''),(2013,'1','311','1',1,'Retail Sale Id 2076',2760.00,0.00,0.00,4.00,388.00,'2023-03-17 10:43:45','',''),(2014,'1','311','1',1,'Retail Sale Id 2078',4830.00,0.00,0.00,7.00,679.00,'2023-03-17 10:51:14','',''),(2015,'1','311','1',1,'Retail Sale Id 2079',690.00,0.00,0.00,1.00,97.00,'2023-03-17 10:54:13','',''),(2016,'1','311','1',1,'Retail Sale Id 2079',2760.00,0.00,0.00,4.00,388.00,'2023-03-17 10:54:13','',''),(2017,'1','311','1',1,'Retail Sale Id 2080',2070.00,0.00,0.00,3.00,291.00,'2023-03-17 10:55:44','',''),(2018,'1','311','1',1,'Retail Sale Id 2081',2070.00,0.00,0.00,3.00,291.00,'2023-03-17 10:57:41','',''),(2019,'1','311','1',1,'Retail Sale Id 2082',4830.00,0.00,0.00,7.00,679.00,'2023-03-17 11:01:40','',''),(2020,'1','311','1',1,'Retail Sale Id 2083',3450.00,0.00,0.00,5.00,485.00,'2023-03-17 11:03:50','',''),(2021,'1','311','1',1,'Retail Sale Id 2084',2760.00,0.00,0.00,4.00,388.00,'2023-03-17 11:08:34','',''),(2022,'1','311','1',1,'Retail Sale Id 2086',3450.00,0.00,0.00,5.00,485.00,'2023-03-17 11:10:18','',''),(2023,'1','311','1',1,'Retail Sale Id 2085',2001.00,0.00,0.00,2.90,281.30,'2023-03-17 11:11:37','',''),(2024,'1','311','1',1,'Retail Sale Id 2087',2070.00,0.00,0.00,3.00,291.00,'2023-03-17 11:12:48','',''),(2025,'1','311','1',1,'Retail Sale Id 2088',1000.50,0.00,0.00,1.45,140.65,'2023-03-17 11:14:01','',''),(2026,'1','311','1',1,'Retail Sale Id 2089',3450.00,0.00,0.00,5.00,485.00,'2023-03-17 11:14:55','',''),(2027,'1','311','1',1,'Retail Sale Id 2090',4140.00,0.00,0.00,6.00,582.00,'2023-03-17 11:24:34','',''),(2028,'1','311','1',1,'Retail Sale Id 2091',3450.00,0.00,0.00,5.00,485.00,'2023-03-17 11:40:50','',''),(2029,'1','311','1',1,'Retail Sale Id 2092',1856.10,0.00,0.00,2.69,260.93,'2023-03-17 11:43:47','',''),(2030,'1','311','1',1,'Retail Sale Id 2093',4140.00,0.00,0.00,6.00,582.00,'2023-03-17 11:46:40','',''),(2031,'1','311','1',1,'Retail Sale Id 2095',3450.00,0.00,0.00,5.00,485.00,'2023-03-17 12:05:14','',''),(2032,'1','311','1',1,'Retail Sale Id 2096',2801.40,0.00,0.00,4.06,393.82,'2023-03-17 12:11:57','',''),(2033,'1','311','1',1,'Retail Sale Id 2098',4498.80,0.00,0.00,6.52,632.44,'2023-03-17 12:32:59','',''),(2034,'1','311','1',1,'Retail Sale Id 2099',3450.00,0.00,0.00,5.00,485.00,'2023-03-17 12:33:59','',''),(2035,'1','311','1',1,'Retail Sale Id 2100',2070.00,0.00,0.00,3.00,291.00,'2023-03-17 12:35:44','',''),(2036,'1','311','1',1,'Retail Sale Id 2103',4830.00,0.00,0.00,7.00,679.00,'2023-03-17 12:52:53','',''),(2037,'1','311','1',1,'Retail Sale Id 2104',3450.00,0.00,0.00,5.00,485.00,'2023-03-17 12:53:37','',''),(2038,'1','311','1',1,'Retail Sale Id 2106',1297.20,0.00,0.00,1.88,182.36,'2023-03-17 12:58:06','',''),(2039,'1','311','1',1,'Retail Sale Id 2106',1297.20,0.00,0.00,1.88,182.36,'2023-03-17 12:58:06','',''),(2040,'1','311','1',1,'Retail Sale Id 2107',2001.00,0.00,0.00,2.90,281.30,'2023-03-17 13:00:39','',''),(2041,'1','311','1',1,'Retail Sale Id 2108',8625.00,0.00,0.00,12.50,1212.50,'2023-03-17 13:03:31','',''),(2042,'1','311','1',1,'Retail Sale Id 2109',8625.00,0.00,0.00,12.50,1212.50,'2023-03-17 13:05:36','',''),(2043,'1','311','1',1,'Retail Sale Id 2110',1497.30,0.00,0.00,2.17,210.49,'2023-03-17 13:28:10','',''),(2044,'1','311','1',1,'Retail Sale Id 2111',4830.00,0.00,0.00,7.00,679.00,'2023-03-17 13:37:05','',''),(2045,'1','311','1',1,'Retail Sale Id 2112',1380.00,0.00,0.00,2.00,194.00,'2023-03-17 13:38:05','',''),(2046,'1','311','1',1,'Retail Sale Id 2113',2760.00,0.00,0.00,4.00,388.00,'2023-03-17 13:47:04','',''),(2047,'1','311','1',1,'Retail Sale Id 2114',2001.00,0.00,0.00,2.90,281.30,'2023-03-17 13:52:13','',''),(2048,'1','311','1',1,'Retail Sale Id 2115',39530.00,0.00,0.00,59.00,4543.00,'2023-03-17 14:01:43','',''),(2049,'1','311','1',1,'Retail Sale Id 2117',4140.00,0.00,0.00,6.00,582.00,'2023-03-17 14:23:44','',''),(2050,'1','311','1',1,'Retail Sale Id 2119',4830.00,0.00,0.00,7.00,679.00,'2023-03-17 14:40:58','',''),(2051,'1','311','1',1,'Retail Sale Id 2120',690.00,0.00,0.00,1.00,97.00,'2023-03-17 14:46:16','',''),(2052,'1','311','1',1,'Retail Sale Id 2121',2070.00,0.00,0.00,3.00,291.00,'2023-03-17 14:56:50','',''),(2053,'1','311','1',1,'Retail Sale Id 2122',3450.00,0.00,0.00,5.00,485.00,'2023-03-17 15:18:26','',''),(2054,'1','311','1',1,'Retail Sale Id 2123',6900.00,0.00,0.00,10.00,970.00,'2023-03-17 15:20:01','',''),(2055,'1','311','1',1,'Retail Sale Id 2124',1000.50,0.00,0.00,1.45,140.65,'2023-03-17 15:22:53','',''),(2056,'1','311','1',1,'Retail Sale Id 2125',5002.50,0.00,0.00,7.25,703.25,'2023-03-17 15:28:01','',''),(2057,'1','311','1',1,'Retail Sale Id 2126',3001.50,0.00,0.00,4.35,421.95,'2023-03-17 15:31:05','',''),(2058,'1','311','1',1,'Return of Retail Sale Id 2110',0.00,1497.30,2.17,0.00,-210.49,'2023-03-17 15:47:33','',''),(2059,'1','311','1',1,'Retail Sale Id 2128',1497.30,0.00,0.00,2.17,210.49,'2023-03-17 15:48:15','',''),(2060,'1','311','1',1,'Retail Sale Id 2130',1897.50,0.00,0.00,2.75,266.75,'2023-03-17 15:56:40','',''),(2061,'1','311','1',1,'Retail Sale Id 2131',8625.00,0.00,0.00,12.50,1212.50,'2023-03-17 15:58:03','',''),(2062,'1','311','1',1,'Retail Sale Id 2132',8625.00,0.00,0.00,12.50,1212.50,'2023-03-17 15:58:56','',''),(2063,'1','311','1',1,'Retail Sale Id 2133',2760.00,0.00,0.00,4.00,388.00,'2023-03-17 16:00:05','',''),(2064,'1','311','1',1,'Retail Sale Id 2134',2497.80,0.00,0.00,3.62,351.14,'2023-03-17 16:02:25','',''),(2065,'1','311','1',1,'Retail Sale Id 2135',800.40,0.00,0.00,1.16,112.52,'2023-03-17 16:03:06','',''),(2066,'1','311','1',1,'Retail Sale Id 2136',696.90,0.00,0.00,1.01,97.97,'2023-03-17 16:04:22','',''),(2067,'1','311','1',1,'Return of Retail Sale Id 2135',0.00,800.40,1.16,0.00,-112.52,'2023-03-17 16:05:12','',''),(2068,'1','311','1',1,'Retail Sale Id 2138',1400.70,0.00,0.00,2.03,196.91,'2023-03-17 16:10:31','',''),(2069,'1','311','1',1,'Retail Sale Id 2140',3001.50,0.00,0.00,4.35,421.95,'2023-03-17 16:11:55','',''),(2070,'1','311','1',1,'Retail Sale Id 2141',1380.00,0.00,0.00,2.00,194.00,'2023-03-17 16:12:43','',''),(2071,'1','311','1',1,'Retail Sale Id 2142',2070.00,0.00,0.00,3.00,291.00,'2023-03-17 16:13:34','',''),(2072,'1','311','1',1,'Retail Sale Id 2143',6900.00,0.00,0.00,10.00,970.00,'2023-03-17 16:15:26','',''),(2073,'1','311','1',1,'Retail Sale Id 2143',6900.00,0.00,0.00,10.00,970.00,'2023-03-17 16:15:26','',''),(2074,'1','311','1',1,'Retail Sale Id 2145',1000.50,0.00,0.00,1.45,140.65,'2023-03-17 16:18:20','',''),(2075,'1','311','1',1,'Retail Sale Id 2144',8625.00,0.00,0.00,12.50,1212.50,'2023-03-17 16:18:38','',''),(2076,'1','311','1',1,'Retail Sale Id 2147',5002.50,0.00,0.00,7.25,703.25,'2023-03-17 16:33:22','',''),(2077,'1','311','1',1,'Retail Sale Id 2148',4485.00,0.00,0.00,6.50,630.50,'2023-03-17 16:34:38','',''),(2078,'1','311','1',1,'Retail Sale Id 2149',2070.00,0.00,0.00,3.00,291.00,'2023-03-17 16:38:36','',''),(2079,'1','311','1',1,'Retail Sale Id 2150',2760.00,0.00,0.00,4.00,388.00,'2023-03-17 16:39:50','',''),(2080,'1','311','1',1,'Retail Sale Id 2151',15410.00,0.00,0.00,23.00,1771.00,'2023-03-17 16:42:09','',''),(2081,'1','311','1',1,'Retail Sale Id 2152',4140.00,0.00,0.00,6.00,582.00,'2023-03-17 16:42:48','',''),(2082,'1','311','1',1,'Retail Sale Id 2154',8625.00,0.00,0.00,12.50,1212.50,'2023-03-17 16:49:24','',''),(2083,'1','311','1',1,'Retail Sale Id 2156',1380.00,0.00,0.00,2.00,194.00,'2023-03-17 16:53:37','',''),(2084,'1','311','1',1,'Retail Sale Id 2157',2760.00,0.00,0.00,4.00,388.00,'2023-03-17 16:54:32','',''),(2085,'1','311','1',1,'Retail Sale Id 2158',1400.70,0.00,0.00,2.03,196.91,'2023-03-17 16:55:35','',''),(2086,'1','311','1',1,'Retail Sale Id 2160',6900.00,0.00,0.00,10.00,970.00,'2023-03-17 17:05:32','',''),(2087,'1','311','1',1,'Retail Sale Id 2161',7590.00,0.00,0.00,11.00,1067.00,'2023-03-17 17:09:56','',''),(2088,'1','311','1',1,'Retail Sale Id 2159',8625.00,0.00,0.00,12.50,1212.50,'2023-03-17 17:12:54','',''),(2089,'1','311','1',1,'Retail Sale Id 2162',2201.10,0.00,0.00,3.19,309.43,'2023-03-17 17:15:25','',''),(2090,'1','311','1',1,'Retail Sale Id 2164',73700.00,0.00,0.00,110.00,8470.00,'2023-03-17 17:24:55','',''),(2091,'1','311','1',1,'Retail Sale Id 2165',3450.00,0.00,0.00,5.00,485.00,'2023-03-17 17:26:32','',''),(2092,'1','311','1',1,'Retail Sale Id 2166',1380.00,0.00,0.00,2.00,194.00,'2023-03-17 17:27:56','',''),(2093,'1','311','1',1,'Retail Sale Id 2167',2070.00,0.00,0.00,3.00,291.00,'2023-03-17 17:30:39','',''),(2094,'1','311','1',1,'Retail Sale Id 2168',4140.00,0.00,0.00,6.00,582.00,'2023-03-17 17:44:47','',''),(2095,'1','311','1',1,'Retail Sale Id 2169',8625.00,0.00,0.00,12.50,1212.50,'2023-03-17 17:45:49','',''),(2096,'1','311','1',1,'Retail Sale Id 2172',4830.00,0.00,0.00,7.00,679.00,'2023-03-17 17:55:02','',''),(2097,'1','311','1',1,'Retail Sale Id 2173',2070.00,0.00,0.00,3.00,291.00,'2023-03-17 17:56:43','',''),(2098,'1','311','1',1,'Retail Sale Id 2174',8625.00,0.00,0.00,12.50,1212.50,'2023-03-17 17:58:19','',''),(2099,'1','311','1',1,'Retail Sale Id 2176',8625.00,0.00,0.00,12.50,1212.50,'2023-03-17 18:00:00','',''),(2100,'1','311','1',1,'Retail Sale Id 2175',3450.00,0.00,0.00,5.00,485.00,'2023-03-17 18:00:33','',''),(2101,'1','311','1',1,'Retail Sale Id 2177',1497.30,0.00,0.00,2.17,210.49,'2023-03-17 18:03:02','',''),(2102,'1','311','1',1,'Retail Sale Id 2178',2001.00,0.00,0.00,2.90,281.30,'2023-03-17 18:03:56','',''),(2103,'1','311','1',1,'Retail Sale Id 2179',4830.00,0.00,0.00,7.00,679.00,'2023-03-17 18:05:04','',''),(2104,'1','311','1',1,'Retail Sale Id 2181',1497.30,0.00,0.00,2.17,210.49,'2023-03-17 18:07:30','',''),(2105,'1','311','1',1,'Retail Sale Id 2182',2760.00,0.00,0.00,4.00,388.00,'2023-03-17 18:08:33','',''),(2106,'1','311','1',1,'Return of Retail Sale Id 2179',0.00,4830.00,7.00,0.00,-679.00,'2023-03-17 18:14:06','',''),(2107,'1','311','1',1,'Retail Sale Id 2185',3822.60,0.00,0.00,5.54,537.38,'2023-03-17 18:14:47','',''),(2108,'1','311','1',1,'Retail Sale Id 2186',1380.00,0.00,0.00,2.00,194.00,'2023-03-17 18:18:25','',''),(2109,'1','311','1',1,'Retail Sale Id 2189',1380.00,0.00,0.00,2.00,194.00,'2023-03-19 07:50:58','',''),(2110,'1','311','1',1,'Retail Sale Id 2188',2760.00,0.00,0.00,4.00,388.00,'2023-03-19 08:19:41','',''),(2111,'1','311','1',1,'Retail Sale Id 2188',4830.00,0.00,0.00,7.00,679.00,'2023-03-19 08:19:41','',''),(2112,'1','311','1',1,'Retail Sale Id 2188',7590.00,0.00,0.00,11.00,1067.00,'2023-03-19 08:19:41','',''),(2113,'1','311','1',1,'Retail Sale Id 2190',3450.00,0.00,0.00,5.00,485.00,'2023-03-19 08:21:26','',''),(2114,'1','311','1',1,'Retail Sale Id 2191',4140.00,0.00,0.00,6.00,582.00,'2023-03-19 08:22:08','',''),(2115,'1','311','1',1,'Retail Sale Id 2192',6900.00,0.00,0.00,10.00,970.00,'2023-03-19 08:23:06','',''),(2116,'1','311','1',1,'Retail Sale Id 2192',8625.00,0.00,0.00,12.50,1212.50,'2023-03-19 08:23:06','',''),(2117,'1','311','1',1,'Retail Sale Id 2193',3450.00,0.00,0.00,5.00,485.00,'2023-03-19 08:23:46','',''),(2118,'1','311','1',1,'Retail Sale Id 2194',5002.50,0.00,0.00,7.25,703.25,'2023-03-19 08:24:59','',''),(2119,'1','311','1',1,'Retail Sale Id 2195',2760.00,0.00,0.00,4.00,388.00,'2023-03-19 08:25:44','',''),(2120,'1','311','1',1,'Retail Sale Id 2196',5520.00,0.00,0.00,8.00,776.00,'2023-03-19 08:29:04','',''),(2121,'1','311','1',1,'Retail Sale Id 2197',10350.00,0.00,0.00,15.00,1455.00,'2023-03-19 08:30:13','',''),(2122,'1','311','1',1,'Retail Sale Id 2198',4140.00,0.00,0.00,6.00,582.00,'2023-03-19 08:31:35','',''),(2123,'1','311','1',1,'Retail Sale Id 2199',2760.00,0.00,0.00,4.00,388.00,'2023-03-19 08:32:41','',''),(2124,'1','311','1',1,'Retail Sale Id 2200',2070.00,0.00,0.00,3.00,291.00,'2023-03-19 08:33:58','',''),(2125,'1','311','1',1,'Retail Sale Id 2201',2070.00,0.00,0.00,3.00,291.00,'2023-03-19 08:36:32','',''),(2126,'1','311','1',1,'Retail Sale Id 2202',1380.00,0.00,0.00,2.00,194.00,'2023-03-19 08:38:19','',''),(2127,'1','311','1',1,'Retail Sale Id 2203',8625.00,0.00,0.00,12.50,1212.50,'2023-03-19 08:46:40','',''),(2128,'1','311','1',1,'Retail Sale Id 2204',3001.50,0.00,0.00,4.35,421.95,'2023-03-19 08:49:32','',''),(2129,'1','311','1',1,'Retail Sale Id 2205',3001.50,0.00,0.00,4.35,421.95,'2023-03-19 08:50:33','',''),(2130,'1','311','1',1,'Retail Sale Id 2206',1380.00,0.00,0.00,2.00,194.00,'2023-03-19 08:51:38','',''),(2131,'1','311','1',1,'Retail Sale Id 2207',3450.00,0.00,0.00,5.00,485.00,'2023-03-19 09:10:05','',''),(2132,'1','311','1',1,'Retail Sale Id 2208',1497.30,0.00,0.00,2.17,210.49,'2023-03-19 09:21:14','',''),(2133,'1','311','1',1,'Retail Sale Id 2209',1380.00,0.00,0.00,2.00,194.00,'2023-03-19 09:23:37','',''),(2134,'1','311','1',1,'Retail Sale Id 2212',2497.80,0.00,0.00,3.62,351.14,'2023-03-19 09:30:39','',''),(2135,'1','311','1',1,'Retail Sale Id 2212',3001.50,0.00,0.00,4.35,421.95,'2023-03-19 09:30:39','',''),(2136,'1','311','1',1,'Retail Sale Id 2213',2760.00,0.00,0.00,4.00,388.00,'2023-03-19 09:32:00','',''),(2137,'1','311','1',1,'Retail Sale Id 2214',3001.50,0.00,0.00,4.35,421.95,'2023-03-19 09:33:19','',''),(2138,'1','311','1',1,'Retail Sale Id 2216',1497.30,0.00,0.00,2.17,210.49,'2023-03-19 09:35:51','',''),(2139,'1','311','1',1,'Retail Sale Id 2217',2070.00,0.00,0.00,3.00,291.00,'2023-03-19 09:38:51','',''),(2140,'1','311','1',1,'Retail Sale Id 2218',6900.00,0.00,0.00,10.00,970.00,'2023-03-19 09:40:04','',''),(2141,'1','311','1',1,'Retail Sale Id 2219',3450.00,0.00,0.00,5.00,485.00,'2023-03-19 09:41:26','',''),(2142,'1','311','1',1,'Retail Sale Id 2220',2070.00,0.00,0.00,3.00,291.00,'2023-03-19 09:42:32','',''),(2143,'1','311','1',1,'Retail Sale Id 2222',1380.00,0.00,0.00,2.00,194.00,'2023-03-19 10:09:30','',''),(2144,'1','311','1',1,'Retail Sale Id 2223',1000.50,0.00,0.00,1.45,140.65,'2023-03-19 10:11:38','',''),(2145,'1','311','1',1,'Retail Sale Id 2224',4140.00,0.00,0.00,6.00,582.00,'2023-03-19 10:12:52','',''),(2146,'1','311','1',1,'Retail Sale Id 2225',696.90,0.00,0.00,1.01,97.97,'2023-03-19 10:21:29','',''),(2147,'1','311','1',1,'Retail Sale Id 2226',6900.00,0.00,0.00,10.00,970.00,'2023-03-19 10:26:46','',''),(2148,'1','311','1',1,'Retail Sale Id 2227',2097.60,0.00,0.00,3.04,294.88,'2023-03-19 10:30:29','',''),(2149,'1','311','1',1,'Retail Sale Id 2228',8625.00,0.00,0.00,12.50,1212.50,'2023-03-19 10:34:47','',''),(2150,'1','311','1',1,'Retail Sale Id 2229',4140.00,0.00,0.00,6.00,582.00,'2023-03-19 10:45:42','',''),(2151,'1','311','1',1,'Retail Sale Id 2230',4140.00,0.00,0.00,6.00,582.00,'2023-03-19 10:46:47','',''),(2152,'1','311','1',1,'Retail Sale Id 2231',3001.50,0.00,0.00,4.35,421.95,'2023-03-19 10:55:02','',''),(2153,'1','311','1',1,'Retail Sale Id 2232',1380.00,0.00,0.00,2.00,194.00,'2023-03-19 11:02:31','',''),(2154,'1','311','1',1,'Retail Sale Id 2233',79060.00,0.00,0.00,118.00,9086.00,'2023-03-19 11:05:23','',''),(2155,'1','311','1',1,'Retail Sale Id 2234',2760.00,0.00,0.00,4.00,388.00,'2023-03-19 11:08:26','',''),(2156,'1','311','1',1,'Retail Sale Id 2235',8625.00,0.00,0.00,12.50,1212.50,'2023-03-19 11:11:54','',''),(2157,'1','311','1',1,'Retail Sale Id 2236',600.00,0.00,0.00,1.00,7.00,'2023-03-19 11:16:24','',''),(2158,'1','311','1',1,'Retail Sale Id 2237',1000.50,0.00,0.00,1.45,140.65,'2023-03-19 11:17:17','',''),(2159,'1','311','1',1,'Retail Sale Id 2238',1400.70,0.00,0.00,2.03,196.91,'2023-03-19 11:18:45','',''),(2160,'1','311','1',1,'Retail Sale Id 2239',3001.50,0.00,0.00,4.35,421.95,'2023-03-19 11:19:47','',''),(2161,'1','311','1',1,'Retail Sale Id 2240',2097.60,0.00,0.00,3.04,294.88,'2023-03-19 11:20:57','',''),(2162,'1','311','1',1,'Retail Sale Id 2241',2001.00,0.00,0.00,2.90,281.30,'2023-03-19 11:22:01','',''),(2163,'1','311','1',1,'Retail Sale Id 2242',1380.00,0.00,0.00,2.00,194.00,'2023-03-19 11:22:58','',''),(2164,'1','311','1',1,'Retail Sale Id 2243',3450.00,0.00,0.00,5.00,485.00,'2023-03-19 11:24:21','',''),(2165,'1','311','1',1,'Retail Sale Id 2244',2097.60,0.00,0.00,3.04,294.88,'2023-03-19 11:31:07','',''),(2166,'1','311','1',1,'Retail Sale Id 2245',1400.70,0.00,0.00,2.03,196.91,'2023-03-19 11:37:49','',''),(2167,'1','311','1',1,'Retail Sale Id 2246',2070.00,0.00,0.00,3.00,291.00,'2023-03-19 12:11:33','',''),(2168,'1','311','1',1,'Retail Sale Id 2247',2001.00,0.00,0.00,2.90,281.30,'2023-03-19 12:22:12','',''),(2169,'1','311','1',1,'Retail Sale Id 2248',3001.50,0.00,0.00,4.35,421.95,'2023-03-19 12:29:36','',''),(2170,'1','311','1',1,'Retail Sale Id 2249',2070.00,0.00,0.00,3.00,291.00,'2023-03-19 12:44:32','',''),(2171,'1','311','1',1,'Retail Sale Id 2250',8625.00,0.00,0.00,12.50,1212.50,'2023-03-19 12:49:45','',''),(2172,'1','311','1',1,'Retail Sale Id 2251',4830.00,0.00,0.00,7.00,679.00,'2023-03-19 12:52:19','',''),(2173,'1','311','1',1,'Retail Sale Id 2252',4140.00,0.00,0.00,6.00,582.00,'2023-03-19 12:55:16','',''),(2174,'1','311','1',1,'Retail Sale Id 2253',2070.00,0.00,0.00,3.00,291.00,'2023-03-19 12:57:13','',''),(2175,'1','311','1',1,'Retail Sale Id 2254',3001.50,0.00,0.00,4.35,421.95,'2023-03-19 12:59:12','',''),(2176,'1','311','1',1,'Retail Sale Id 2256',4140.00,0.00,0.00,6.00,582.00,'2023-03-19 13:02:59','',''),(2177,'1','311','1',1,'Retail Sale Id 2257',3450.00,0.00,0.00,5.00,485.00,'2023-03-19 13:07:53','',''),(2178,'1','311','1',1,'Retail Sale Id 2258',2001.00,0.00,0.00,2.90,281.30,'2023-03-19 13:09:53','',''),(2179,'1','311','1',1,'Retail Sale Id 2260',6996.60,0.00,0.00,10.14,983.58,'2023-03-19 13:19:27','',''),(2180,'1','311','1',1,'Retail Sale Id 2261',2097.60,0.00,0.00,3.04,294.88,'2023-03-19 13:21:26','',''),(2181,'1','311','1',1,'Retail Sale Id 2262',1400.70,0.00,0.00,2.03,196.91,'2023-03-19 13:28:42','',''),(2182,'1','311','1',1,'Retail Sale Id 2263',4830.00,0.00,0.00,7.00,679.00,'2023-03-19 13:30:39','',''),(2183,'1','311','1',1,'Retail Sale Id 2264',3001.50,0.00,0.00,4.35,421.95,'2023-03-19 13:32:20','',''),(2184,'1','311','1',1,'Retail Sale Id 2265',4140.00,0.00,0.00,6.00,582.00,'2023-03-19 13:45:38','',''),(2185,'1','311','1',1,'Retail Sale Id 2266',1000.50,0.00,0.00,1.45,140.65,'2023-03-19 13:47:40','',''),(2186,'1','311','1',1,'Retail Sale Id 2267',4830.00,0.00,0.00,7.00,679.00,'2023-03-19 13:53:37','',''),(2187,'1','311','1',1,'Retail Sale Id 2268',3450.00,0.00,0.00,5.00,485.00,'2023-03-19 14:00:50','',''),(2188,'1','311','1',1,'Retail Sale Id 2269',3450.00,0.00,0.00,5.00,485.00,'2023-03-19 14:02:35','',''),(2189,'1','311','1',1,'Retail Sale Id 2270',2070.00,0.00,0.00,3.00,291.00,'2023-03-19 14:05:53','',''),(2190,'1','311','1',1,'Retail Sale Id 2271',2097.60,0.00,0.00,3.04,294.88,'2023-03-19 14:08:15','',''),(2191,'1','311','1',1,'Retail Sale Id 2274',2070.00,0.00,0.00,3.00,291.00,'2023-03-19 14:12:21','',''),(2192,'1','311','1',1,'Retail Sale Id 2276',696.90,0.00,0.00,1.01,97.97,'2023-03-19 14:15:24','',''),(2193,'1','311','1',1,'Retail Sale Id 2275',2070.00,0.00,0.00,3.00,291.00,'2023-03-19 14:16:02','',''),(2194,'1','311','1',1,'Retail Sale Id 2275',3795.00,0.00,0.00,5.50,533.50,'2023-03-19 14:16:02','',''),(2195,'1','311','1',1,'Retail Sale Id 2277',1497.30,0.00,0.00,2.17,210.49,'2023-03-19 14:17:33','',''),(2196,'1','311','1',1,'Retail Sale Id 2278',8625.00,0.00,0.00,12.50,1212.50,'2023-03-19 14:19:53','',''),(2197,'1','311','1',1,'Retail Sale Id 2280',8280.00,0.00,0.00,12.00,1164.00,'2023-03-19 14:21:39','',''),(2198,'1','311','1',1,'Retail Sale Id 2282',1400.70,0.00,0.00,2.03,196.91,'2023-03-19 14:23:16','',''),(2199,'1','311','1',1,'Retail Sale Id 2283',4140.00,0.00,0.00,6.00,582.00,'2023-03-19 14:24:25','',''),(2200,'1','311','1',1,'Retail Sale Id 2284',2070.00,0.00,0.00,3.00,291.00,'2023-03-19 14:26:58','',''),(2201,'1','311','1',1,'Retail Sale Id 2286',5520.00,0.00,0.00,8.00,776.00,'2023-03-19 14:29:15','',''),(2202,'1','311','1',1,'Retail Sale Id 2287',6900.00,0.00,0.00,10.00,970.00,'2023-03-19 14:31:08','',''),(2203,'1','311','1',1,'Retail Sale Id 2288',2097.60,0.00,0.00,3.04,294.88,'2023-03-19 14:32:03','',''),(2204,'1','311','1',1,'Retail Sale Id 2289',5520.00,0.00,0.00,8.00,776.00,'2023-03-19 14:34:06','',''),(2205,'1','311','1',1,'Retail Sale Id 2290',2070.00,0.00,0.00,3.00,291.00,'2023-03-19 14:35:12','',''),(2206,'1','311','1',1,'Retail Sale Id 2291',1000.50,0.00,0.00,1.45,140.65,'2023-03-19 14:37:26','',''),(2207,'1','311','1',1,'Retail Sale Id 2293',2760.00,0.00,0.00,4.00,388.00,'2023-03-19 14:42:08','',''),(2208,'1','311','1',1,'Retail Sale Id 2294',3001.50,0.00,0.00,4.35,421.95,'2023-03-19 14:44:51','',''),(2209,'1','311','1',1,'Retail Sale Id 2292',2070.00,0.00,0.00,3.00,291.00,'2023-03-19 14:45:20','',''),(2210,'1','311','1',1,'Retail Sale Id 2295',268000.00,0.00,0.00,400.00,30800.00,'2023-03-19 14:48:41','',''),(2211,'1','311','1',1,'Retail Sale Id 2296',173530.00,0.00,0.00,259.00,19943.00,'2023-03-19 14:50:42','',''),(2212,'1','311','1',1,'Retail Sale Id 2297',2760.00,0.00,0.00,4.00,388.00,'2023-03-19 14:52:22','',''),(2213,'1','311','1',1,'Retail Sale Id 2299',3450.00,0.00,0.00,5.00,485.00,'2023-03-19 14:54:11','',''),(2214,'1','311','1',1,'Retail Sale Id 2300',3450.00,0.00,0.00,5.00,485.00,'2023-03-19 14:56:12','',''),(2215,'1','311','1',1,'Retail Sale Id 2300',4830.00,0.00,0.00,7.00,679.00,'2023-03-19 14:56:12','',''),(2216,'1','311','1',1,'Retail Sale Id 2300',5520.00,0.00,0.00,8.00,776.00,'2023-03-19 14:56:12','',''),(2217,'1','311','1',1,'Retail Sale Id 2301',2070.00,0.00,0.00,3.00,291.00,'2023-03-19 14:57:42','',''),(2218,'1','311','1',1,'Retail Sale Id 2302',8625.00,0.00,0.00,12.50,1212.50,'2023-03-19 15:01:44','',''),(2219,'1','311','1',1,'Retail Sale Id 2303',2097.60,0.00,0.00,3.04,294.88,'2023-03-19 15:04:42','',''),(2220,'1','311','1',1,'Retail Sale Id 2304',2070.00,0.00,0.00,3.00,291.00,'2023-03-19 15:07:12','',''),(2221,'1','311','1',1,'Retail Sale Id 2305',4002.00,0.00,0.00,5.80,562.60,'2023-03-19 15:08:26','',''),(2222,'1','311','1',1,'Retail Sale Id 2306',3450.00,0.00,0.00,5.00,485.00,'2023-03-19 15:17:58','',''),(2223,'1','311','1',1,'Retail Sale Id 2307',2070.00,0.00,0.00,3.00,291.00,'2023-03-19 15:19:29','',''),(2224,'1','311','1',1,'Retail Sale Id 2308',1738.80,0.00,0.00,2.52,244.44,'2023-03-19 15:23:03','',''),(2225,'1','311','1',1,'Retail Sale Id 2310',2001.00,0.00,0.00,2.90,281.30,'2023-03-19 15:32:04','',''),(2226,'1','311','1',1,'Retail Sale Id 2311',2001.00,0.00,0.00,2.90,281.30,'2023-03-19 15:33:19','',''),(2227,'1','311','1',1,'Retail Sale Id 2312',3001.50,0.00,0.00,4.35,421.95,'2023-03-19 15:35:53','',''),(2228,'1','311','1',1,'Retail Sale Id 2313',2760.00,0.00,0.00,4.00,388.00,'2023-03-19 15:37:23','',''),(2229,'1','311','1',1,'Retail Sale Id 2314',8652.60,0.00,0.00,12.54,1216.38,'2023-03-19 15:44:47','',''),(2230,'1','311','1',1,'Retail Sale Id 2315',696.90,0.00,0.00,1.01,97.97,'2023-03-19 15:52:48','',''),(2231,'1','311','1',1,'Retail Sale Id 2316',2070.00,0.00,0.00,3.00,291.00,'2023-03-19 15:54:05','',''),(2232,'1','311','1',1,'Retail Sale Id 2317',4830.00,0.00,0.00,7.00,679.00,'2023-03-19 15:55:11','',''),(2233,'1','311','1',1,'Retail Sale Id 2318',2070.00,0.00,0.00,3.00,291.00,'2023-03-19 15:56:21','',''),(2234,'1','311','1',1,'Retail Sale Id 2319',2001.00,0.00,0.00,2.90,281.30,'2023-03-19 15:57:21','',''),(2235,'1','311','1',1,'Retail Sale Id 2320',5520.00,0.00,0.00,8.00,776.00,'2023-03-19 15:59:12','',''),(2236,'1','311','1',1,'Retail Sale Id 2321',2070.00,0.00,0.00,3.00,291.00,'2023-03-19 16:05:14','',''),(2237,'1','311','1',1,'Retail Sale Id 2322',4830.00,0.00,0.00,7.00,679.00,'2023-03-19 16:06:37','',''),(2238,'1','311','1',1,'Retail Sale Id 2323',3450.00,0.00,0.00,5.00,485.00,'2023-03-19 16:07:46','',''),(2239,'1','311','1',1,'Retail Sale Id 2324',1725.00,0.00,0.00,2.50,242.50,'2023-03-19 16:10:33','',''),(2240,'1','311','1',1,'Retail Sale Id 2325',4140.00,0.00,0.00,6.00,582.00,'2023-03-19 16:11:43','',''),(2241,'1','311','1',1,'Retail Sale Id 2326',4140.00,0.00,0.00,6.00,582.00,'2023-03-19 16:13:20','',''),(2242,'1','311','1',1,'Retail Sale Id 2327',6900.00,0.00,0.00,10.00,970.00,'2023-03-19 16:15:00','',''),(2243,'1','311','1',1,'Retail Sale Id 2329',2001.00,0.00,0.00,2.90,281.30,'2023-03-19 16:16:49','',''),(2244,'1','311','1',1,'Retail Sale Id 2340',2346.00,0.00,0.00,3.40,329.80,'2023-03-19 16:21:58','',''),(2245,'1','311','1',1,'Retail Sale Id 2340',8652.60,0.00,0.00,12.54,1216.38,'2023-03-19 16:21:58','',''),(2246,'1','311','1',1,'Retail Sale Id 2341',1000.50,0.00,0.00,1.45,140.65,'2023-03-19 16:25:08','',''),(2247,'1','311','1',1,'Retail Sale Id 2342',3450.00,0.00,0.00,5.00,485.00,'2023-03-19 16:26:28','',''),(2248,'1','311','1',1,'Retail Sale Id 2343',5002.50,0.00,0.00,7.25,703.25,'2023-03-19 16:32:35','',''),(2249,'1','311','1',1,'Retail Sale Id 2344',1497.30,0.00,0.00,2.17,210.49,'2023-03-19 16:33:47','',''),(2250,'1','311','1',1,'Retail Sale Id 2345',2760.00,0.00,0.00,4.00,388.00,'2023-03-19 16:34:56','',''),(2251,'1','311','1',1,'Retail Sale Id 2346',1400.70,0.00,0.00,2.03,196.91,'2023-03-19 16:39:12','',''),(2252,'1','311','1',1,'Retail Sale Id 2347',4830.00,0.00,0.00,7.00,679.00,'2023-03-19 16:42:23','',''),(2253,'1','311','1',1,'Retail Sale Id 2348',2760.00,0.00,0.00,4.00,388.00,'2023-03-19 16:47:38','',''),(2254,'1','311','1',1,'Retail Sale Id 2349',2097.60,0.00,0.00,3.04,294.88,'2023-03-19 16:55:09','',''),(2255,'1','311','1',1,'Retail Sale Id 2350',1000.50,0.00,0.00,1.45,140.65,'2023-03-19 16:57:09','',''),(2256,'1','311','1',1,'Retail Sale Id 2351',8280.00,0.00,0.00,12.00,1164.00,'2023-03-19 16:59:20','',''),(2257,'1','311','1',1,'Retail Sale Id 2352',4140.00,0.00,0.00,6.00,582.00,'2023-03-19 17:00:38','',''),(2258,'1','311','1',1,'Retail Sale Id 2353',8625.00,0.00,0.00,12.50,1212.50,'2023-03-19 17:03:18','',''),(2259,'1','311','1',1,'Retail Sale Id 2356',3795.00,0.00,0.00,5.50,533.50,'2023-03-19 17:05:42','',''),(2260,'1','311','1',1,'Retail Sale Id 2359',1380.00,0.00,0.00,2.00,194.00,'2023-03-19 17:25:04','',''),(2261,'1','311','1',1,'Retail Sale Id 2360',800.40,0.00,0.00,1.16,112.52,'2023-03-19 17:40:25','',''),(2262,'1','311','1',1,'Retail Sale Id 2362',6900.00,0.00,0.00,10.00,970.00,'2023-03-19 17:45:22','',''),(2263,'1','311','1',1,'Retail Sale Id 2363',2760.00,0.00,0.00,4.00,388.00,'2023-03-19 17:46:57','',''),(2264,'1','311','1',1,'Retail Sale Id 2364',8625.00,0.00,0.00,12.50,1212.50,'2023-03-19 17:48:57','',''),(2265,'1','311','1',1,'Return of Retail Sale Id 2364',0.00,8625.00,12.50,0.00,-1212.50,'2023-03-19 18:42:51','',''),(2266,'1','311','1',1,'Retail Sale Id 2365',6154.80,0.00,0.00,8.92,865.24,'2023-03-19 18:43:36','',''),(2267,'1','311','1',1,'Retail Sale Id 2366',39530.00,0.00,0.00,59.00,4543.00,'2023-03-19 18:46:12','',''),(2268,'1','311','1',1,'Return of Retail Sale Id 2295',0.00,268000.00,400.00,0.00,-30800.00,'2023-03-19 18:49:46','',''),(2269,'1','311','1',1,'Retail Sale Id 2367',228470.00,0.00,0.00,341.00,26257.00,'2023-03-19 18:50:29','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'1','311',1,4032.20,'2023-03-19 18:50:29');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2267 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'1','311',1,'Retail Sale Id 1',0.00,16604.00,760.00,21280.00,4676.00,'2023-02-03 11:04:06'),(2,'1','311',1,'Retail Sale Id 2',0.00,3368.24,760.00,4316.80,948.56,'2023-02-03 11:53:35'),(3,'1','311',1,'Retail Sale Id 3',0.00,8337.58,760.00,10685.60,2348.02,'2023-02-03 11:56:07'),(4,'1','311',1,'Retail Sale Id 4',0.00,1796.79,760.00,2302.80,506.01,'2023-02-03 12:04:40'),(5,'1','311',1,'Retail Sale Id 6',0.00,1168.21,760.00,1497.20,328.99,'2023-02-03 13:31:13'),(6,'1','311',1,'Retail Sale Id 7',0.00,1779.00,760.00,2280.00,501.00,'2023-02-03 13:35:35'),(7,'1','311',1,'Retail Sale Id 7',0.00,3558.00,760.00,4560.00,1002.00,'2023-02-03 13:35:35'),(8,'1','311',1,'Retail Sale Id 8',0.00,3558.00,760.00,4560.00,1002.00,'2023-02-03 13:49:26'),(9,'1','311',1,'Retail Sale Id 9',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-03 13:57:14'),(10,'1','311',1,'Retail Sale Id 11',0.00,3119.18,760.00,3997.60,878.42,'2023-02-03 14:03:51'),(11,'1','311',1,'Retail Sale Id 12',0.00,1559.59,760.00,1998.80,439.21,'2023-02-03 14:11:37'),(12,'1','311',1,'Retail Sale Id 13',0.00,1091.12,760.00,1398.40,307.28,'2023-02-03 14:16:24'),(13,'1','311',1,'Retail Sale Id 14',0.00,5930.00,760.00,7600.00,1670.00,'2023-02-03 14:18:56'),(14,'1','311',1,'Retail Sale Id 15',0.00,4151.00,760.00,5320.00,1169.00,'2023-02-03 14:20:54'),(15,'1','311',1,'Retail Sale Id 16',0.00,1168.21,760.00,1497.20,328.99,'2023-02-03 14:26:52'),(16,'1','311',1,'Retail Sale Id 18',0.00,1559.59,760.00,1998.80,439.21,'2023-02-03 15:18:51'),(17,'1','311',1,'Retail Sale Id 19',0.00,2965.00,760.00,3800.00,835.00,'2023-02-03 16:11:45'),(18,'1','311',1,'Retail Sale Id 20',0.00,1168.21,760.00,1497.20,328.99,'2023-02-03 16:31:34'),(19,'1','311',1,'Retail Sale Id 21',0.00,1559.59,760.00,1998.80,439.21,'2023-02-03 16:41:50'),(20,'1','311',1,'Retail Sale Id 22',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-03 17:00:16'),(21,'1','311',1,'Retail Sale Id 26',0.00,1500.29,760.00,1922.80,422.51,'2023-02-03 21:22:44'),(22,'1','311',1,'Retail Sale Id 26',0.00,9197.43,760.00,11787.60,2590.17,'2023-02-03 21:22:44'),(23,'1','311',1,'Retail Sale Id 28',0.00,1559.59,760.00,1998.80,439.21,'2023-02-04 10:07:57'),(24,'1','311',1,'Retail Sale Id 29',0.00,593.00,760.00,760.00,167.00,'2023-02-04 10:13:19'),(25,'1','311',1,'Retail Sale Id 31',0.00,3901.94,760.00,5000.80,1098.86,'2023-02-04 11:14:15'),(26,'1','311',1,'Retail Sale Id 31',0.00,14825.00,760.00,19000.00,4175.00,'2023-02-04 11:14:15'),(27,'1','311',1,'Return of Retail Sale Id 31',3901.94,0.00,760.00,-5000.80,-1098.86,'2023-02-04 11:14:54'),(28,'1','311',1,'Return of Retail Sale Id 31',14825.00,0.00,760.00,-19000.00,-4175.00,'2023-02-04 11:14:54'),(29,'1','311',1,'Retail Sale Id 32',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-04 11:16:28'),(30,'1','311',1,'Retail Sale Id 33',0.00,3901.94,760.00,5000.80,1098.86,'2023-02-04 11:17:40'),(31,'1','311',1,'Retail Sale Id 34',0.00,1559.59,760.00,1998.80,439.21,'2023-02-04 11:34:05'),(32,'1','311',1,'Retail Sale Id 35',0.00,2342.35,760.00,3002.00,659.65,'2023-02-04 11:49:15'),(33,'1','311',1,'Retail Sale Id 36',0.00,3510.56,760.00,4499.20,988.64,'2023-02-04 11:51:30'),(34,'1','311',1,'Retail Sale Id 37',0.00,1559.59,760.00,1998.80,439.21,'2023-02-04 11:53:36'),(35,'1','311',1,'Return of Retail Sale Id 36',3510.56,0.00,760.00,-4499.20,-988.64,'2023-02-04 11:57:44'),(36,'1','311',1,'Retail Sale Id 38',0.00,3119.18,760.00,3997.60,878.42,'2023-02-04 11:59:10'),(37,'1','311',1,'Retail Sale Id 39',0.00,3534.28,760.00,4529.60,995.32,'2023-02-04 14:16:00'),(38,'1','311',1,'Retail Sale Id 40',0.00,1559.59,760.00,1998.80,439.21,'2023-02-04 14:42:14'),(39,'1','311',1,'Return of Retail Sale Id 40',1559.59,0.00,760.00,-1998.80,-439.21,'2023-02-04 14:45:08'),(40,'1','311',1,'Retail Sale Id 41',0.00,5930.00,760.00,7600.00,1670.00,'2023-02-04 14:52:24'),(41,'1','311',1,'Retail Sale Id 43',0.00,782.76,760.00,1003.20,220.44,'2023-02-04 15:03:47'),(42,'1','311',1,'Retail Sale Id 44',0.00,1186.00,760.00,1520.00,334.00,'2023-02-04 15:08:05'),(43,'1','311',1,'Retail Sale Id 46',0.00,593.00,760.00,760.00,167.00,'2023-02-04 15:13:28'),(44,'1','311',1,'Retail Sale Id 48',0.00,1186.00,760.00,1520.00,334.00,'2023-02-04 16:06:52'),(45,'1','311',1,'Retail Sale Id 49',0.00,1186.00,760.00,1520.00,334.00,'2023-02-04 16:15:17'),(46,'1','311',1,'Retail Sale Id 50',0.00,593.00,760.00,760.00,167.00,'2023-02-04 16:21:04'),(47,'1','311',1,'Retail Sale Id 51',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-04 16:23:12'),(48,'1','311',1,'Retail Sale Id 52',0.00,2372.00,760.00,3040.00,668.00,'2023-02-04 16:28:56'),(49,'1','311',1,'Retail Sale Id 53',0.00,2372.00,760.00,3040.00,668.00,'2023-02-04 16:50:03'),(50,'1','311',1,'Retail Sale Id 54',0.00,3558.00,760.00,4560.00,1002.00,'2023-02-04 16:53:20'),(51,'1','311',1,'Retail Sale Id 55',0.00,3119.18,760.00,3997.60,878.42,'2023-02-04 17:16:46'),(52,'1','311',1,'Retail Sale Id 55',0.00,4678.77,760.00,5996.40,1317.63,'2023-02-04 17:16:46'),(53,'1','311',1,'Retail Sale Id 56',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-04 17:19:21'),(54,'1','311',1,'Retail Sale Id 57',0.00,4744.00,760.00,6080.00,1336.00,'2023-02-04 17:24:24'),(55,'1','311',1,'Retail Sale Id 58',0.00,6629.74,760.00,8496.80,1867.06,'2023-02-04 17:53:37'),(56,'1','311',1,'Retail Sale Id 59',0.00,1168.21,760.00,1497.20,328.99,'2023-02-04 17:57:23'),(57,'1','311',1,'Retail Sale Id 60',0.00,1832.37,760.00,2348.40,516.03,'2023-02-04 18:04:28'),(58,'1','311',1,'Return of Retail Sale Id 50',593.00,0.00,760.00,-760.00,-167.00,'2023-02-04 20:28:46'),(59,'1','311',1,'Retail Sale Id 61',0.00,800.55,760.00,1026.00,225.45,'2023-02-04 20:35:05'),(60,'1','311',1,'Return of Retail Sale Id 56',7412.50,0.00,760.00,-9500.00,-2087.50,'2023-02-04 20:42:54'),(61,'1','311',1,'Retail Sale Id 62',0.00,925.08,760.00,1185.60,260.52,'2023-02-04 20:44:06'),(62,'1','311',1,'Retail Sale Id 63',0.00,9381.26,760.00,12023.20,2641.94,'2023-02-04 20:46:00'),(63,'1','311',1,'Retail Sale Id 64',0.00,1559.59,760.00,1998.80,439.21,'2023-02-05 08:36:51'),(64,'1','311',1,'Retail Sale Id 65',0.00,1168.21,760.00,1497.20,328.99,'2023-02-05 08:42:09'),(65,'1','311',1,'Retail Sale Id 66',0.00,1251.23,760.00,1603.60,352.37,'2023-02-05 08:44:17'),(66,'1','311',1,'Retail Sale Id 67',0.00,622.65,760.00,798.00,175.35,'2023-02-05 08:45:44'),(67,'1','311',1,'Return of Retail Sale Id 64',1559.59,0.00,760.00,-1998.80,-439.21,'2023-02-05 09:01:07'),(68,'1','311',1,'Retail Sale Id 68',0.00,5930.00,760.00,7600.00,1670.00,'2023-02-05 09:26:47'),(69,'1','311',1,'Retail Sale Id 69',0.00,782.76,760.00,1003.20,220.44,'2023-02-05 09:46:13'),(70,'1','311',1,'Retail Sale Id 70',0.00,2965.00,760.00,3800.00,835.00,'2023-02-14 11:23:33'),(71,'1','311',1,'Retail Sale Id 71',0.00,2419.44,760.00,3100.80,681.36,'2023-02-14 12:39:23'),(72,'1','311',1,'Retail Sale Id 72',0.00,7412.50,760.00,9500.00,2087.50,'2023-02-14 12:43:58'),(73,'1','311',1,'Retail Sale Id 73',0.00,824.27,720.00,1000.80,176.53,'2023-02-14 16:24:04'),(74,'1','311',1,'Retail Sale Id 74',0.00,1648.54,720.00,2001.60,353.06,'2023-02-14 16:25:58'),(75,'1','311',1,'Retail Sale Id 75',0.00,3558.00,720.00,4320.00,762.00,'2023-02-14 16:27:53'),(76,'1','311',1,'Retail Sale Id 76',0.00,2965.00,720.00,3600.00,635.00,'2023-02-14 16:28:58'),(77,'1','311',1,'Retail Sale Id 77',0.00,824.27,720.00,1000.80,176.53,'2023-02-14 16:33:21'),(78,'1','311',1,'Return of Retail Sale Id 77',824.27,0.00,720.00,-1000.80,-176.53,'2023-02-14 16:36:44'),(79,'1','311',1,'Retail Sale Id 78',0.00,1233.44,720.00,1497.60,264.16,'2023-02-14 16:37:35'),(80,'1','311',1,'Retail Sale Id 79',0.00,1233.44,720.00,1497.60,264.16,'2023-02-14 16:38:42'),(81,'1','311',1,'Return of Retail Sale Id 78',1233.44,0.00,720.00,-1497.60,-264.16,'2023-02-14 16:39:40'),(82,'1','311',1,'Retail Sale Id 82',0.00,3581.72,720.00,4348.80,767.08,'2023-02-14 17:29:53'),(83,'1','311',1,'Retail Sale Id 83',0.00,3297.08,720.00,4003.20,706.12,'2023-02-14 17:37:24'),(84,'1','311',1,'Retail Sale Id 84',0.00,3558.00,720.00,4320.00,762.00,'2023-02-14 17:47:29'),(85,'1','311',1,'Retail Sale Id 85',0.00,2965.00,720.00,3600.00,635.00,'2023-02-14 17:58:34'),(86,'1','311',1,'Retail Sale Id 86',0.00,1779.00,720.00,2160.00,381.00,'2023-02-14 18:12:42'),(87,'1','311',1,'Retail Sale Id 87',0.00,1150.42,720.00,1396.80,246.38,'2023-02-14 18:15:29'),(88,'1','311',1,'Retail Sale Id 88',0.00,3854.50,720.00,4680.00,825.50,'2023-02-14 18:17:31'),(89,'1','311',1,'Retail Sale Id 89',0.00,2881.98,720.00,3499.20,617.22,'2023-02-14 18:20:28'),(90,'1','311',1,'Retail Sale Id 90',0.00,575.21,720.00,698.40,123.19,'2023-02-14 18:24:22'),(91,'1','311',1,'Return of Retail Sale Id 90',575.21,0.00,720.00,-698.40,-123.19,'2023-02-14 20:15:09'),(92,'1','311',1,'Retail Sale Id 91',0.00,4690.63,720.00,5695.20,1004.57,'2023-02-14 20:17:21'),(93,'1','311',1,'Return of Retail Sale Id 83',3297.08,0.00,720.00,-4003.20,-706.12,'2023-02-14 20:37:38'),(94,'1','311',1,'Retail Sale Id 92',0.00,2965.00,720.00,3600.00,635.00,'2023-02-14 20:38:28'),(95,'1','311',1,'Retail Sale Id 93',0.00,332.08,720.00,403.20,71.12,'2023-02-14 20:39:17'),(96,'1','311',1,'Retail Sale Id 94',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-15 07:25:36'),(97,'1','311',1,'Retail Sale Id 95',0.00,1648.54,720.00,2001.60,353.06,'2023-02-15 07:49:55'),(98,'1','311',1,'Return of Retail Sale Id 94',5930.00,0.00,720.00,-7200.00,-1270.00,'2023-02-15 08:07:10'),(99,'1','311',1,'Retail Sale Id 96',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-15 10:46:59'),(100,'1','311',1,'Retail Sale Id 97',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-15 12:02:13'),(101,'1','311',1,'Retail Sale Id 98',0.00,2472.81,720.00,3002.40,529.59,'2023-02-15 12:06:18'),(102,'1','311',1,'Retail Sale Id 99',0.00,4115.42,720.00,4996.80,881.38,'2023-02-15 13:13:27'),(103,'1','311',1,'Return of Retail Sale Id 97',5930.00,0.00,720.00,-7200.00,-1270.00,'2023-02-15 13:36:04'),(104,'1','311',1,'Retail Sale Id 100',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-15 13:37:20'),(105,'1','311',1,'Retail Sale Id 101',0.00,7116.00,720.00,8640.00,1524.00,'2023-02-15 14:01:58'),(106,'1','311',1,'Retail Sale Id 102',0.00,4151.00,720.00,5040.00,889.00,'2023-02-15 14:15:28'),(107,'1','311',1,'Retail Sale Id 103',0.00,1186.00,720.00,1440.00,254.00,'2023-02-15 14:20:14'),(108,'1','311',1,'Retail Sale Id 104',0.00,3297.08,720.00,4003.20,706.12,'2023-02-15 14:23:04'),(109,'1','311',1,'Retail Sale Id 105',0.00,2389.79,720.00,2901.60,511.81,'2023-02-15 14:24:41'),(110,'1','311',1,'Retail Sale Id 106',0.00,1233.44,720.00,1497.60,264.16,'2023-02-15 14:26:33'),(111,'1','311',1,'Retail Sale Id 107',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-15 14:31:44'),(112,'1','311',1,'Retail Sale Id 108',0.00,824.27,720.00,1000.80,176.53,'2023-02-15 14:34:33'),(113,'1','311',1,'Retail Sale Id 109',0.00,7116.00,720.00,8640.00,1524.00,'2023-02-15 14:36:33'),(114,'1','311',1,'Retail Sale Id 110',0.00,2965.00,720.00,3600.00,635.00,'2023-02-15 15:14:02'),(115,'1','311',1,'Retail Sale Id 111',0.00,2472.81,720.00,3002.40,529.59,'2023-02-15 15:56:15'),(116,'1','311',1,'Retail Sale Id 112',0.00,1482.50,720.00,1800.00,317.50,'2023-02-15 15:58:14'),(117,'1','311',1,'Retail Sale Id 113',0.00,1186.00,720.00,1440.00,254.00,'2023-02-15 16:06:24'),(118,'1','311',1,'Retail Sale Id 115',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-15 16:45:47'),(119,'1','311',1,'Retail Sale Id 116',0.00,3558.00,720.00,4320.00,762.00,'2023-02-15 16:47:47'),(120,'1','311',1,'Retail Sale Id 118',0.00,4151.00,720.00,5040.00,889.00,'2023-02-15 16:54:36'),(121,'1','311',1,'Retail Sale Id 120',0.00,2965.00,720.00,3600.00,635.00,'2023-02-15 17:00:45'),(122,'1','311',1,'Retail Sale Id 121',0.00,1191.93,720.00,1447.20,255.27,'2023-02-15 17:23:31'),(123,'1','311',1,'Retail Sale Id 122',0.00,824.27,720.00,1000.80,176.53,'2023-02-15 17:31:44'),(124,'1','311',1,'Retail Sale Id 123',0.00,824.27,720.00,1000.80,176.53,'2023-02-15 17:34:23'),(125,'1','311',1,'Retail Sale Id 124',0.00,2472.81,720.00,3002.40,529.59,'2023-02-15 18:46:19'),(126,'1','311',1,'Retail Sale Id 125',0.00,2472.81,720.00,3002.40,529.59,'2023-02-16 08:17:35'),(127,'1','311',1,'Retail Sale Id 126',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-16 08:39:32'),(128,'1','311',1,'Retail Sale Id 127',0.00,1233.44,720.00,1497.60,264.16,'2023-02-16 08:46:45'),(129,'1','311',1,'Retail Sale Id 128',0.00,1648.54,720.00,2001.60,353.06,'2023-02-16 08:50:09'),(130,'1','311',1,'Retail Sale Id 130',0.00,1186.00,720.00,1440.00,254.00,'2023-02-16 09:04:28'),(131,'1','311',1,'Retail Sale Id 132',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-16 09:06:15'),(132,'1','311',1,'Retail Sale Id 133',0.00,1784.93,720.00,2167.20,382.27,'2023-02-16 09:32:58'),(133,'1','311',1,'Retail Sale Id 135',0.00,3261.50,720.00,3960.00,698.50,'2023-02-16 09:36:59'),(134,'1','311',1,'Retail Sale Id 136',0.00,2965.00,720.00,3600.00,635.00,'2023-02-16 09:56:27'),(135,'1','311',1,'Retail Sale Id 138',0.00,3558.00,720.00,4320.00,762.00,'2023-02-16 10:50:25'),(136,'1','311',1,'Retail Sale Id 139',0.00,7116.00,720.00,8640.00,1524.00,'2023-02-16 11:09:43'),(137,'1','311',1,'Retail Sale Id 141',0.00,4151.00,720.00,5040.00,889.00,'2023-02-16 11:34:21'),(138,'1','311',1,'Retail Sale Id 143',0.00,1233.44,720.00,1497.60,264.16,'2023-02-16 11:39:05'),(139,'1','311',1,'Retail Sale Id 144',0.00,1779.00,720.00,2160.00,381.00,'2023-02-16 11:44:37'),(140,'1','311',1,'Retail Sale Id 145',0.00,2965.00,720.00,3600.00,635.00,'2023-02-16 12:54:34'),(141,'1','311',1,'Retail Sale Id 146',0.00,4151.00,720.00,5040.00,889.00,'2023-02-16 12:57:37'),(142,'1','311',1,'Retail Sale Id 147',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-16 13:10:30'),(143,'1','311',1,'Retail Sale Id 148',0.00,3297.08,720.00,4003.20,706.12,'2023-02-16 14:29:36'),(144,'1','311',1,'Retail Sale Id 149',0.00,1974.69,720.00,2397.60,422.91,'2023-02-16 14:51:05'),(145,'1','311',1,'Retail Sale Id 150',0.00,7116.00,720.00,8640.00,1524.00,'2023-02-16 14:52:49'),(146,'1','311',1,'Retail Sale Id 151',0.00,4115.42,720.00,4996.80,881.38,'2023-02-16 15:09:54'),(147,'1','311',1,'Retail Sale Id 153',0.00,3558.00,720.00,4320.00,762.00,'2023-02-16 15:35:39'),(148,'1','311',1,'Retail Sale Id 154',0.00,1779.00,720.00,2160.00,381.00,'2023-02-16 16:03:20'),(149,'1','311',1,'Retail Sale Id 155',0.00,2472.81,720.00,3002.40,529.59,'2023-02-16 16:04:49'),(150,'1','311',1,'Retail Sale Id 157',0.00,4151.00,720.00,5040.00,889.00,'2023-02-16 16:18:49'),(151,'1','311',1,'Retail Sale Id 158',0.00,3558.00,720.00,4320.00,762.00,'2023-02-16 16:22:50'),(152,'1','311',1,'Retail Sale Id 159',0.00,1773.07,720.00,2152.80,379.73,'2023-02-16 16:37:27'),(153,'1','311',1,'Retail Sale Id 160',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-16 16:38:32'),(154,'1','311',1,'Retail Sale Id 161',0.00,824.27,720.00,1000.80,176.53,'2023-02-16 16:40:07'),(155,'1','311',1,'Retail Sale Id 163',0.00,2372.00,720.00,2880.00,508.00,'2023-02-16 16:44:43'),(156,'1','311',1,'Retail Sale Id 164',0.00,2965.00,720.00,3600.00,635.00,'2023-02-16 16:46:50'),(157,'1','311',1,'Retail Sale Id 165',0.00,1186.00,720.00,1440.00,254.00,'2023-02-16 17:13:46'),(158,'1','311',1,'Retail Sale Id 165',0.00,4151.00,720.00,5040.00,889.00,'2023-02-16 17:13:46'),(159,'1','311',1,'Retail Sale Id 166',0.00,1779.00,720.00,2160.00,381.00,'2023-02-16 17:19:17'),(160,'1','311',1,'Retail Sale Id 167',0.00,616.72,720.00,748.80,132.08,'2023-02-16 17:27:20'),(161,'1','311',1,'Retail Sale Id 168',0.00,1191.93,720.00,1447.20,255.27,'2023-02-16 17:30:33'),(162,'1','311',1,'Retail Sale Id 169',0.00,1779.00,720.00,2160.00,381.00,'2023-02-16 17:53:37'),(163,'1','311',1,'Retail Sale Id 170',0.00,4151.00,720.00,5040.00,889.00,'2023-02-17 08:19:58'),(164,'1','311',1,'Retail Sale Id 171',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-17 09:08:56'),(165,'1','311',1,'Retail Sale Id 172',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-17 09:28:55'),(166,'1','311',1,'Retail Sale Id 173',0.00,7116.00,720.00,8640.00,1524.00,'2023-02-17 10:40:19'),(167,'1','311',1,'Retail Sale Id 174',0.00,4151.00,720.00,5040.00,889.00,'2023-02-17 10:41:17'),(168,'1','311',1,'Retail Sale Id 175',0.00,3261.50,720.00,3960.00,698.50,'2023-02-17 11:06:51'),(169,'1','311',1,'Retail Sale Id 176',0.00,4151.00,720.00,5040.00,889.00,'2023-02-17 11:33:51'),(170,'1','311',1,'Retail Sale Id 179',0.00,1648.54,720.00,2001.60,353.06,'2023-02-17 11:40:09'),(171,'1','311',1,'Retail Sale Id 179',0.00,1648.54,720.00,2001.60,353.06,'2023-02-17 11:40:09'),(172,'1','311',1,'Retail Sale Id 181',0.00,824.27,720.00,1000.80,176.53,'2023-02-17 12:05:10'),(173,'1','311',1,'Retail Sale Id 182',0.00,3297.08,720.00,4003.20,706.12,'2023-02-17 12:18:07'),(174,'1','311',1,'Retail Sale Id 183',0.00,4151.00,720.00,5040.00,889.00,'2023-02-17 12:22:59'),(175,'1','311',1,'Retail Sale Id 184',0.00,1648.54,720.00,2001.60,353.06,'2023-02-17 12:40:33'),(176,'1','311',1,'Retail Sale Id 184',0.00,1648.54,720.00,2001.60,353.06,'2023-02-17 12:40:33'),(177,'1','311',1,'Retail Sale Id 185',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-17 13:17:34'),(178,'1','311',1,'Retail Sale Id 186',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-17 13:19:26'),(179,'1','311',1,'Retail Sale Id 187',0.00,2965.00,720.00,3600.00,635.00,'2023-02-17 14:08:27'),(180,'1','311',1,'Retail Sale Id 188',0.00,4151.00,720.00,5040.00,889.00,'2023-02-17 14:26:14'),(181,'1','311',1,'Retail Sale Id 189',0.00,1779.00,720.00,2160.00,381.00,'2023-02-17 14:29:40'),(182,'1','311',1,'Retail Sale Id 191',0.00,658.23,720.00,799.20,140.97,'2023-02-17 14:35:00'),(183,'1','311',1,'Retail Sale Id 192',0.00,2965.00,720.00,3600.00,635.00,'2023-02-17 14:39:07'),(184,'1','311',1,'Retail Sale Id 195',0.00,3558.00,720.00,4320.00,762.00,'2023-02-17 15:24:39'),(185,'1','311',1,'Retail Sale Id 196',0.00,1186.00,720.00,1440.00,254.00,'2023-02-17 16:28:25'),(186,'1','311',1,'Retail Sale Id 197',0.00,1779.00,720.00,2160.00,381.00,'2023-02-17 16:33:02'),(187,'1','311',1,'Retail Sale Id 198',0.00,3558.00,720.00,4320.00,762.00,'2023-02-17 16:35:47'),(188,'1','311',1,'Retail Sale Id 199',0.00,1233.44,720.00,1497.60,264.16,'2023-02-17 16:59:25'),(189,'1','311',1,'Return of Retail Sale Id 191',658.23,0.00,720.00,-799.20,-140.97,'2023-02-17 20:43:47'),(190,'1','311',1,'Retail Sale Id 202',0.00,664.16,720.00,806.40,142.24,'2023-02-17 20:45:55'),(191,'1','311',1,'Retail Sale Id 203',0.00,1233.44,720.00,1497.60,264.16,'2023-02-18 08:13:18'),(192,'1','311',1,'Retail Sale Id 205',0.00,3558.00,720.00,4320.00,762.00,'2023-02-18 08:28:23'),(193,'1','311',1,'Retail Sale Id 207',0.00,2472.81,720.00,3002.40,529.59,'2023-02-18 09:31:13'),(194,'1','311',1,'Retail Sale Id 208',0.00,4156.93,720.00,5047.20,890.27,'2023-02-18 09:35:13'),(195,'1','311',1,'Retail Sale Id 209',0.00,824.27,720.00,1000.80,176.53,'2023-02-18 10:06:42'),(196,'1','311',1,'Retail Sale Id 211',0.00,4115.42,720.00,4996.80,881.38,'2023-02-18 10:45:42'),(197,'1','311',1,'Retail Sale Id 212',0.00,1191.93,720.00,1447.20,255.27,'2023-02-18 10:54:27'),(198,'1','311',1,'Retail Sale Id 213',0.00,1648.54,720.00,2001.60,353.06,'2023-02-18 13:37:18'),(199,'1','311',1,'Retail Sale Id 214',0.00,3558.00,720.00,4320.00,762.00,'2023-02-18 13:39:19'),(200,'1','311',1,'Retail Sale Id 215',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-18 13:41:03'),(201,'1','311',1,'Retail Sale Id 216',0.00,1779.00,720.00,2160.00,381.00,'2023-02-18 13:42:14'),(202,'1','311',1,'Retail Sale Id 217',0.00,1648.54,720.00,2001.60,353.06,'2023-02-18 13:43:24'),(203,'1','311',1,'Retail Sale Id 218',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-18 13:45:55'),(204,'1','311',1,'Retail Sale Id 220',0.00,2472.81,720.00,3002.40,529.59,'2023-02-18 14:34:13'),(205,'1','311',1,'Retail Sale Id 223',0.00,593.00,720.00,720.00,127.00,'2023-02-18 14:53:52'),(206,'1','311',1,'Return of Retail Sale Id 223',593.00,0.00,720.00,-720.00,-127.00,'2023-02-18 14:58:08'),(207,'1','311',1,'Retail Sale Id 224',0.00,593.00,720.00,720.00,127.00,'2023-02-18 14:59:40'),(208,'1','311',1,'Retail Sale Id 225',0.00,7116.00,720.00,8640.00,1524.00,'2023-02-18 15:14:27'),(209,'1','311',1,'Retail Sale Id 227',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-18 16:26:53'),(210,'1','311',1,'Retail Sale Id 228',0.00,658.23,720.00,799.20,140.97,'2023-02-18 16:31:22'),(211,'1','311',1,'Return of Retail Sale Id 208',4156.93,0.00,720.00,-5047.20,-890.27,'2023-02-18 21:28:19'),(212,'1','311',1,'Retail Sale Id 229',0.00,4156.93,720.00,5047.20,890.27,'2023-02-18 21:30:44'),(213,'1','311',1,'Return of Retail Sale Id 229',4156.93,0.00,720.00,-5047.20,-890.27,'2023-02-18 21:32:52'),(214,'1','311',1,'Retail Sale Id 230',0.00,4115.42,720.00,4996.80,881.38,'2023-02-18 21:35:12'),(215,'1','311',1,'Retail Sale Id 231',0.00,2472.81,720.00,3002.40,529.59,'2023-02-19 08:43:09'),(216,'1','311',1,'Retail Sale Id 232',0.00,1779.00,720.00,2160.00,381.00,'2023-02-19 08:45:39'),(217,'1','311',1,'Retail Sale Id 234',0.00,1186.00,720.00,1440.00,254.00,'2023-02-19 08:55:46'),(218,'1','311',1,'Retail Sale Id 234',0.00,1186.00,720.00,1440.00,254.00,'2023-02-19 08:55:46'),(219,'1','311',1,'Retail Sale Id 235',0.00,2965.00,720.00,3600.00,635.00,'2023-02-19 09:04:28'),(220,'1','311',1,'Retail Sale Id 236',0.00,1779.00,720.00,2160.00,381.00,'2023-02-19 09:07:11'),(221,'1','311',1,'Retail Sale Id 237',0.00,2372.00,720.00,2880.00,508.00,'2023-02-19 09:08:52'),(222,'1','311',1,'Retail Sale Id 239',0.00,4151.00,720.00,5040.00,889.00,'2023-02-19 09:19:01'),(223,'1','311',1,'Retail Sale Id 240',0.00,2372.00,720.00,2880.00,508.00,'2023-02-19 09:21:07'),(224,'1','311',1,'Retail Sale Id 241',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-19 09:25:37'),(225,'1','311',1,'Retail Sale Id 242',0.00,1779.00,720.00,2160.00,381.00,'2023-02-19 09:27:35'),(226,'1','311',1,'Retail Sale Id 243',0.00,1186.00,720.00,1440.00,254.00,'2023-02-19 09:31:40'),(227,'1','311',1,'Retail Sale Id 244',0.00,290.57,720.00,352.80,62.23,'2023-02-19 09:36:08'),(228,'1','311',1,'Retail Sale Id 245',0.00,1186.00,720.00,1440.00,254.00,'2023-02-19 09:37:38'),(229,'1','311',1,'Retail Sale Id 246',0.00,2965.00,720.00,3600.00,635.00,'2023-02-19 09:39:36'),(230,'1','311',1,'Retail Sale Id 247',0.00,1779.00,720.00,2160.00,381.00,'2023-02-19 09:42:00'),(231,'1','311',1,'Retail Sale Id 249',0.00,4151.00,720.00,5040.00,889.00,'2023-02-19 09:53:36'),(232,'1','311',1,'Retail Sale Id 250',0.00,5337.00,720.00,6480.00,1143.00,'2023-02-19 10:34:10'),(233,'1','311',1,'Retail Sale Id 251',0.00,2965.00,720.00,3600.00,635.00,'2023-02-19 10:38:42'),(234,'1','311',1,'Retail Sale Id 251',0.00,3558.00,720.00,4320.00,762.00,'2023-02-19 10:38:42'),(235,'1','311',1,'Retail Sale Id 252',0.00,1186.00,720.00,1440.00,254.00,'2023-02-19 13:01:22'),(236,'1','311',1,'Retail Sale Id 253',0.00,2965.00,720.00,3600.00,635.00,'2023-02-19 13:02:13'),(237,'1','311',1,'Retail Sale Id 254',0.00,6588.23,720.00,7999.20,1410.97,'2023-02-19 13:06:28'),(238,'1','311',1,'Retail Sale Id 256',0.00,3558.00,720.00,4320.00,762.00,'2023-02-19 13:27:28'),(239,'1','311',1,'Retail Sale Id 257',0.00,4151.00,720.00,5040.00,889.00,'2023-02-19 13:56:32'),(240,'1','311',1,'Retail Sale Id 259',0.00,4151.00,720.00,5040.00,889.00,'2023-02-19 14:02:11'),(241,'1','311',1,'Retail Sale Id 260',0.00,3558.00,720.00,4320.00,762.00,'2023-02-19 14:57:02'),(242,'1','311',1,'Retail Sale Id 261',0.00,1186.00,720.00,1440.00,254.00,'2023-02-19 16:06:20'),(243,'1','311',1,'Retail Sale Id 262',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-19 16:26:28'),(244,'1','311',1,'Retail Sale Id 263',0.00,2472.81,720.00,3002.40,529.59,'2023-02-19 17:24:47'),(245,'1','311',1,'Retail Sale Id 264',0.00,593.00,720.00,720.00,127.00,'2023-02-19 17:27:52'),(246,'1','311',1,'Retail Sale Id 265',0.00,1186.00,720.00,1440.00,254.00,'2023-02-19 17:40:08'),(247,'1','311',1,'Retail Sale Id 267',0.00,2372.00,720.00,2880.00,508.00,'2023-02-19 17:46:16'),(248,'1','311',1,'Retail Sale Id 268',0.00,1648.54,720.00,2001.60,353.06,'2023-02-19 17:47:37'),(249,'1','311',1,'Retail Sale Id 269',0.00,824.27,720.00,1000.80,176.53,'2023-02-19 17:49:04'),(250,'1','311',1,'Retail Sale Id 270',0.00,1233.44,720.00,1497.60,264.16,'2023-02-19 17:50:25'),(251,'1','311',1,'Retail Sale Id 271',0.00,7258.32,720.00,8812.80,1554.48,'2023-02-19 20:03:07'),(252,'1','311',1,'Retail Sale Id 272',0.00,7625.98,720.00,9259.20,1633.22,'2023-02-19 20:05:33'),(253,'1','311',1,'Retail Sale Id 273',0.00,8895.00,720.00,10800.00,1905.00,'2023-02-19 20:06:31'),(254,'1','311',1,'Retail Sale Id 275',0.00,12352.19,720.00,14997.60,2645.41,'2023-02-19 20:09:44'),(255,'1','311',1,'Retail Sale Id 276',0.00,12352.19,720.00,14997.60,2645.41,'2023-02-19 20:10:22'),(256,'1','311',1,'Retail Sale Id 277',0.00,12352.19,720.00,14997.60,2645.41,'2023-02-19 20:10:55'),(257,'1','311',1,'Retail Sale Id 278',0.00,12352.19,720.00,14997.60,2645.41,'2023-02-19 20:11:33'),(258,'1','311',1,'Return of Retail Sale Id 278',12352.19,0.00,720.00,-14997.60,-2645.41,'2023-02-19 20:15:25'),(259,'1','311',1,'Return of Retail Sale Id 277',12352.19,0.00,720.00,-14997.60,-2645.41,'2023-02-19 20:16:30'),(260,'1','311',1,'Return of Retail Sale Id 269',824.27,0.00,720.00,-1000.80,-176.53,'2023-02-19 20:18:21'),(261,'1','311',1,'Retail Sale Id 279',0.00,972.52,720.00,1180.80,208.28,'2023-02-19 20:19:19'),(262,'1','311',1,'Return of Retail Sale Id 261',1186.00,0.00,720.00,-1440.00,-254.00,'2023-02-19 20:22:08'),(263,'1','311',1,'Retail Sale Id 280',0.00,889.50,720.00,1080.00,190.50,'2023-02-19 20:23:36'),(264,'1','311',1,'Retail Sale Id 281',0.00,2128.87,720.00,2584.80,455.93,'2023-02-19 20:25:39'),(265,'1','311',1,'Retail Sale Id 282',0.00,2057.71,720.00,2498.40,440.69,'2023-02-21 08:25:43'),(266,'1','311',1,'Retail Sale Id 283',0.00,3558.00,720.00,4320.00,762.00,'2023-02-21 08:31:54'),(267,'1','311',1,'Retail Sale Id 284',0.00,2965.00,720.00,3600.00,635.00,'2023-02-21 08:34:17'),(268,'1','311',1,'Retail Sale Id 285',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-21 08:35:21'),(269,'1','311',1,'Retail Sale Id 289',0.00,1186.00,720.00,1440.00,254.00,'2023-02-21 08:39:55'),(270,'1','311',1,'Retail Sale Id 290',0.00,1779.00,720.00,2160.00,381.00,'2023-02-21 09:02:08'),(271,'1','311',1,'Retail Sale Id 292',0.00,824.27,720.00,1000.80,176.53,'2023-02-21 09:31:03'),(272,'1','311',1,'Retail Sale Id 294',0.00,1316.46,720.00,1598.40,281.94,'2023-02-21 11:00:26'),(273,'1','311',1,'Retail Sale Id 295',0.00,1648.54,720.00,2001.60,353.06,'2023-02-21 11:02:25'),(274,'1','311',1,'Retail Sale Id 296',0.00,1150.42,720.00,1396.80,246.38,'2023-02-21 11:04:15'),(275,'1','311',1,'Retail Sale Id 297',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-21 11:07:01'),(276,'1','311',1,'Retail Sale Id 298',0.00,1648.54,720.00,2001.60,353.06,'2023-02-21 11:08:36'),(277,'1','311',1,'Retail Sale Id 299',0.00,4151.00,720.00,5040.00,889.00,'2023-02-21 11:10:47'),(278,'1','311',1,'Retail Sale Id 299',0.00,7116.00,720.00,8640.00,1524.00,'2023-02-21 11:10:47'),(279,'1','311',1,'Retail Sale Id 300',0.00,4115.42,720.00,4996.80,881.38,'2023-02-21 11:12:30'),(280,'1','311',1,'Return of Retail Sale Id 298',1648.54,0.00,720.00,-2001.60,-353.06,'2023-02-21 11:24:12'),(281,'1','311',1,'Retail Sale Id 301',0.00,1648.54,720.00,2001.60,353.06,'2023-02-21 11:25:37'),(282,'1','311',1,'Retail Sale Id 303',0.00,2372.00,720.00,2880.00,508.00,'2023-02-21 12:45:42'),(283,'1','311',1,'Retail Sale Id 304',0.00,1779.00,720.00,2160.00,381.00,'2023-02-21 12:48:32'),(284,'1','311',1,'Retail Sale Id 305',0.00,2632.92,720.00,3196.80,563.88,'2023-02-21 12:50:15'),(285,'1','311',1,'Retail Sale Id 306',0.00,1648.54,720.00,2001.60,353.06,'2023-02-21 12:51:50'),(286,'1','311',1,'Retail Sale Id 307',0.00,4151.00,720.00,5040.00,889.00,'2023-02-21 12:54:13'),(287,'1','311',1,'Retail Sale Id 309',0.00,2306.77,720.00,2800.80,494.03,'2023-02-21 12:56:19'),(288,'1','311',1,'Retail Sale Id 312',0.00,2472.81,720.00,3002.40,529.59,'2023-02-21 13:24:27'),(289,'1','311',1,'Retail Sale Id 313',0.00,2472.81,720.00,3002.40,529.59,'2023-02-21 13:29:14'),(290,'1','311',1,'Retail Sale Id 314',0.00,1814.58,720.00,2203.20,388.62,'2023-02-21 13:31:03'),(291,'1','311',1,'Retail Sale Id 316',0.00,4151.00,720.00,5040.00,889.00,'2023-02-21 13:32:35'),(292,'1','311',1,'Retail Sale Id 318',0.00,1814.58,720.00,2203.20,388.62,'2023-02-21 13:34:02'),(293,'1','311',1,'Retail Sale Id 321',0.00,2472.81,720.00,3002.40,529.59,'2023-02-21 13:56:45'),(294,'1','311',1,'Retail Sale Id 321',0.00,3297.08,720.00,4003.20,706.12,'2023-02-21 13:56:45'),(295,'1','311',1,'Retail Sale Id 322',0.00,1648.54,720.00,2001.60,353.06,'2023-02-21 14:57:32'),(296,'1','311',1,'Retail Sale Id 323',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-21 14:59:23'),(297,'1','311',1,'Retail Sale Id 324',0.00,2372.00,720.00,2880.00,508.00,'2023-02-21 15:00:57'),(298,'1','311',1,'Retail Sale Id 325',0.00,2965.00,720.00,3600.00,635.00,'2023-02-21 15:02:03'),(299,'1','311',1,'Retail Sale Id 326',0.00,1191.93,720.00,1447.20,255.27,'2023-02-21 15:03:55'),(300,'1','311',1,'Retail Sale Id 327',0.00,1779.00,720.00,2160.00,381.00,'2023-02-21 15:05:15'),(301,'1','311',1,'Retail Sale Id 328',0.00,2965.00,720.00,3600.00,635.00,'2023-02-21 15:09:12'),(302,'1','311',1,'Retail Sale Id 330',0.00,1779.00,720.00,2160.00,381.00,'2023-02-21 15:24:06'),(303,'1','311',1,'Retail Sale Id 331',0.00,4151.00,720.00,5040.00,889.00,'2023-02-21 15:35:57'),(304,'1','311',1,'Retail Sale Id 332',0.00,1779.00,720.00,2160.00,381.00,'2023-02-21 15:37:19'),(305,'1','311',1,'Retail Sale Id 333',0.00,4151.00,720.00,5040.00,889.00,'2023-02-21 15:58:39'),(306,'1','311',1,'Retail Sale Id 335',0.00,3563.93,720.00,4327.20,763.27,'2023-02-21 16:17:45'),(307,'1','311',1,'Retail Sale Id 336',0.00,4151.00,720.00,5040.00,889.00,'2023-02-21 16:19:54'),(308,'1','311',1,'Retail Sale Id 338',0.00,4151.00,720.00,5040.00,889.00,'2023-02-21 16:36:35'),(309,'1','311',1,'Retail Sale Id 338',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-21 16:36:35'),(310,'1','311',1,'Retail Sale Id 342',0.00,2472.81,720.00,3002.40,529.59,'2023-02-21 16:55:58'),(311,'1','311',1,'Retail Sale Id 342',0.00,2472.81,720.00,3002.40,529.59,'2023-02-21 16:55:58'),(312,'1','311',1,'Retail Sale Id 343',0.00,1191.93,720.00,1447.20,255.27,'2023-02-21 17:15:59'),(313,'1','311',1,'Retail Sale Id 344',0.00,1648.54,720.00,2001.60,353.06,'2023-02-21 17:17:08'),(314,'1','311',1,'Retail Sale Id 345',0.00,1186.00,720.00,1440.00,254.00,'2023-02-21 17:26:18'),(315,'1','311',1,'Retail Sale Id 346',0.00,1779.00,720.00,2160.00,381.00,'2023-02-21 17:28:03'),(316,'1','311',1,'Retail Sale Id 347',0.00,3558.00,720.00,4320.00,762.00,'2023-02-21 17:29:43'),(317,'1','311',1,'Retail Sale Id 349',0.00,4115.42,720.00,4996.80,881.38,'2023-02-21 17:35:44'),(318,'1','311',1,'Retail Sale Id 350',0.00,1191.93,720.00,1447.20,255.27,'2023-02-21 17:41:20'),(319,'1','311',1,'Retail Sale Id 351',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-21 17:52:44'),(320,'1','311',1,'Retail Sale Id 352',0.00,2472.81,720.00,3002.40,529.59,'2023-02-21 17:58:47'),(321,'1','311',1,'Return of Retail Sale Id 342',2472.81,0.00,720.00,-3002.40,-529.59,'2023-02-21 22:51:19'),(322,'1','311',1,'Return of Retail Sale Id 342',2472.81,0.00,720.00,-3002.40,-529.59,'2023-02-21 22:51:19'),(323,'1','311',1,'Return of Retail Sale Id 335',3563.93,0.00,720.00,-4327.20,-763.27,'2023-02-21 22:56:27'),(324,'1','311',1,'Return of Retail Sale Id 333',4151.00,0.00,720.00,-5040.00,-889.00,'2023-02-21 22:58:09'),(325,'1','311',1,'Retail Sale Id 353',0.00,1387.62,720.00,1684.80,297.18,'2023-02-21 23:00:13'),(326,'1','311',1,'Retail Sale Id 354',0.00,3563.93,720.00,4327.20,763.27,'2023-02-21 23:06:31'),(327,'1','311',1,'Retail Sale Id 355',0.00,4939.69,720.00,5997.60,1057.91,'2023-02-21 23:11:40'),(328,'1','311',1,'Retail Sale Id 356',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-21 23:15:17'),(329,'1','311',1,'Retail Sale Id 358',0.00,2538.04,720.00,3081.60,543.56,'2023-02-21 23:17:55'),(330,'1','311',1,'Retail Sale Id 359',0.00,2217.82,720.00,2692.80,474.98,'2023-02-21 23:19:27'),(331,'1','311',1,'Retail Sale Id 360',0.00,1814.58,720.00,2203.20,388.62,'2023-02-22 08:14:09'),(332,'1','311',1,'Retail Sale Id 361',0.00,2372.00,720.00,2880.00,508.00,'2023-02-22 08:19:00'),(333,'1','311',1,'Retail Sale Id 362',0.00,4151.00,720.00,5040.00,889.00,'2023-02-22 08:21:15'),(334,'1','311',1,'Retail Sale Id 362',0.00,4151.00,720.00,5040.00,889.00,'2023-02-22 08:21:15'),(335,'1','311',1,'Retail Sale Id 363',0.00,1186.00,720.00,1440.00,254.00,'2023-02-22 08:36:32'),(336,'1','311',1,'Retail Sale Id 364',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-22 08:47:31'),(337,'1','311',1,'Retail Sale Id 365',0.00,2472.81,720.00,3002.40,529.59,'2023-02-22 09:00:10'),(338,'1','311',1,'Retail Sale Id 366',0.00,2472.81,720.00,3002.40,529.59,'2023-02-22 09:02:03'),(339,'1','311',1,'Retail Sale Id 367',0.00,1779.00,720.00,2160.00,381.00,'2023-02-22 09:07:25'),(340,'1','311',1,'Retail Sale Id 369',0.00,2965.00,720.00,3600.00,635.00,'2023-02-22 09:15:34'),(341,'1','311',1,'Retail Sale Id 370',0.00,1779.00,720.00,2160.00,381.00,'2023-02-22 09:29:49'),(342,'1','311',1,'Retail Sale Id 371',0.00,2472.81,720.00,3002.40,529.59,'2023-02-22 09:46:03'),(343,'1','311',1,'Retail Sale Id 372',0.00,1779.00,720.00,2160.00,381.00,'2023-02-22 09:48:28'),(344,'1','311',1,'Retail Sale Id 373',0.00,2965.00,720.00,3600.00,635.00,'2023-02-22 09:50:31'),(345,'1','311',1,'Retail Sale Id 374',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-22 09:53:58'),(346,'1','311',1,'Retail Sale Id 376',0.00,1773.07,720.00,2152.80,379.73,'2023-02-22 10:00:14'),(347,'1','311',1,'Retail Sale Id 377',0.00,2965.00,720.00,3600.00,635.00,'2023-02-22 10:08:44'),(348,'1','311',1,'Retail Sale Id 378',0.00,2965.00,720.00,3600.00,635.00,'2023-02-22 10:12:00'),(349,'1','311',1,'Retail Sale Id 379',0.00,1814.58,720.00,2203.20,388.62,'2023-02-22 10:20:54'),(350,'1','311',1,'Retail Sale Id 380',0.00,4151.00,720.00,5040.00,889.00,'2023-02-22 10:23:15'),(351,'1','311',1,'Retail Sale Id 382',0.00,3558.00,720.00,4320.00,762.00,'2023-02-22 10:26:41'),(352,'1','311',1,'Retail Sale Id 383',0.00,4151.00,720.00,5040.00,889.00,'2023-02-22 10:28:20'),(353,'1','311',1,'Retail Sale Id 384',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-22 10:29:26'),(354,'1','311',1,'Retail Sale Id 386',0.00,2965.00,720.00,3600.00,635.00,'2023-02-22 10:41:21'),(355,'1','311',1,'Retail Sale Id 389',0.00,616.72,720.00,748.80,132.08,'2023-02-22 11:05:27'),(356,'1','311',1,'Retail Sale Id 392',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-22 11:23:45'),(357,'1','311',1,'Retail Sale Id 393',0.00,2389.79,720.00,2901.60,511.81,'2023-02-22 11:38:35'),(358,'1','311',1,'Retail Sale Id 395',0.00,1648.54,720.00,2001.60,353.06,'2023-02-22 11:44:18'),(359,'1','311',1,'Retail Sale Id 396',0.00,1233.44,720.00,1497.60,264.16,'2023-02-22 12:05:50'),(360,'1','311',1,'Retail Sale Id 397',0.00,1648.54,720.00,2001.60,353.06,'2023-02-22 12:22:01'),(361,'1','311',1,'Return of Retail Sale Id 397',1648.54,0.00,720.00,-2001.60,-353.06,'2023-02-22 12:29:00'),(362,'1','311',1,'Retail Sale Id 399',0.00,2965.00,720.00,3600.00,635.00,'2023-02-22 12:58:10'),(363,'1','311',1,'Retail Sale Id 400',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-22 13:25:54'),(364,'1','311',1,'Retail Sale Id 402',0.00,1648.54,720.00,2001.60,353.06,'2023-02-22 13:28:55'),(365,'1','311',1,'Retail Sale Id 403',0.00,2965.00,720.00,3600.00,635.00,'2023-02-22 13:30:24'),(366,'1','311',1,'Retail Sale Id 404',0.00,2372.00,720.00,2880.00,508.00,'2023-02-22 14:19:03'),(367,'1','311',1,'Retail Sale Id 405',0.00,4151.00,720.00,5040.00,889.00,'2023-02-22 15:11:41'),(368,'1','311',1,'Return of Retail Sale Id 405',4151.00,0.00,720.00,-5040.00,-889.00,'2023-02-22 15:22:58'),(369,'1','311',1,'Retail Sale Id 407',0.00,3943.45,720.00,4788.00,844.55,'2023-02-22 15:25:10'),(370,'1','311',1,'Retail Sale Id 408',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-22 15:28:12'),(371,'1','311',1,'Retail Sale Id 409',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-22 15:50:09'),(372,'1','311',1,'Retail Sale Id 410',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-22 15:52:14'),(373,'1','311',1,'Retail Sale Id 411',0.00,1186.00,720.00,1440.00,254.00,'2023-02-22 15:55:14'),(374,'1','311',1,'Retail Sale Id 412',0.00,4744.00,720.00,5760.00,1016.00,'2023-02-22 16:00:31'),(375,'1','311',1,'Retail Sale Id 413',0.00,1779.00,720.00,2160.00,381.00,'2023-02-22 16:02:55'),(376,'1','311',1,'Retail Sale Id 416',0.00,2965.00,720.00,3600.00,635.00,'2023-02-22 16:05:49'),(377,'1','311',1,'Retail Sale Id 417',0.00,1191.93,720.00,1447.20,255.27,'2023-02-22 16:08:16'),(378,'1','311',1,'Return of Retail Sale Id 416',2965.00,0.00,720.00,-3600.00,-635.00,'2023-02-22 16:09:31'),(379,'1','311',1,'Retail Sale Id 418',0.00,2965.00,720.00,3600.00,635.00,'2023-02-22 16:10:15'),(380,'1','311',1,'Retail Sale Id 420',0.00,1779.00,720.00,2160.00,381.00,'2023-02-22 16:26:05'),(381,'1','311',1,'Retail Sale Id 422',0.00,2223.75,720.00,2700.00,476.25,'2023-02-22 16:53:41'),(382,'1','311',1,'Retail Sale Id 423',0.00,1191.93,720.00,1447.20,255.27,'2023-02-22 16:54:43'),(383,'1','311',1,'Retail Sale Id 424',0.00,2372.00,720.00,2880.00,508.00,'2023-02-22 16:59:06'),(384,'1','311',1,'Retail Sale Id 426',0.00,2372.00,720.00,2880.00,508.00,'2023-02-22 17:03:30'),(385,'1','311',1,'Retail Sale Id 427',0.00,2372.00,720.00,2880.00,508.00,'2023-02-22 17:24:22'),(386,'1','311',1,'Retail Sale Id 428',0.00,4151.00,720.00,5040.00,889.00,'2023-02-22 17:30:01'),(387,'1','311',1,'Retail Sale Id 431',0.00,4115.42,720.00,4996.80,881.38,'2023-02-22 17:44:59'),(388,'1','311',1,'Retail Sale Id 432',0.00,1191.93,720.00,1447.20,255.27,'2023-02-22 17:45:58'),(389,'1','311',1,'Return of Retail Sale Id 422',2223.75,0.00,720.00,-2700.00,-476.25,'2023-02-22 18:12:20'),(390,'1','311',1,'Retail Sale Id 433',0.00,2229.68,720.00,2707.20,477.52,'2023-02-22 18:13:03'),(391,'1','311',1,'Retail Sale Id 434',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-23 08:14:09'),(392,'1','311',1,'Retail Sale Id 435',0.00,4151.00,720.00,5040.00,889.00,'2023-02-23 08:15:32'),(393,'1','311',1,'Retail Sale Id 436',0.00,2372.00,720.00,2880.00,508.00,'2023-02-23 08:57:23'),(394,'1','311',1,'Retail Sale Id 437',0.00,3558.00,720.00,4320.00,762.00,'2023-02-23 09:11:25'),(395,'1','311',1,'Retail Sale Id 438',0.00,2372.00,720.00,2880.00,508.00,'2023-02-23 09:21:04'),(396,'1','311',1,'Retail Sale Id 439',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-23 09:24:01'),(397,'1','311',1,'Retail Sale Id 440',0.00,2965.00,720.00,3600.00,635.00,'2023-02-23 09:25:01'),(398,'1','311',1,'Retail Sale Id 441',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-23 09:36:04'),(399,'1','311',1,'Retail Sale Id 442',0.00,1186.00,720.00,1440.00,254.00,'2023-02-23 09:37:52'),(400,'1','311',1,'Retail Sale Id 443',0.00,2472.81,720.00,3002.40,529.59,'2023-02-23 10:01:06'),(401,'1','311',1,'Retail Sale Id 444',0.00,2965.00,720.00,3600.00,635.00,'2023-02-23 10:01:51'),(402,'1','311',1,'Retail Sale Id 445',0.00,2372.00,720.00,2880.00,508.00,'2023-02-23 10:03:30'),(403,'1','311',1,'Retail Sale Id 446',0.00,2965.00,720.00,3600.00,635.00,'2023-02-23 10:30:05'),(404,'1','311',1,'Retail Sale Id 446',0.00,2965.00,720.00,3600.00,635.00,'2023-02-23 10:30:05'),(405,'1','311',1,'Retail Sale Id 448',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-23 10:48:19'),(406,'1','311',1,'Retail Sale Id 449',0.00,2965.00,720.00,3600.00,635.00,'2023-02-23 10:57:17'),(407,'1','311',1,'Retail Sale Id 450',0.00,2965.00,720.00,3600.00,635.00,'2023-02-23 11:05:20'),(408,'1','311',1,'Retail Sale Id 451',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-23 11:43:46'),(409,'1','311',1,'Retail Sale Id 452',0.00,1648.54,720.00,2001.60,353.06,'2023-02-23 11:53:13'),(410,'1','311',1,'Retail Sale Id 453',0.00,1186.00,720.00,1440.00,254.00,'2023-02-23 12:27:35'),(411,'1','311',1,'Retail Sale Id 454',0.00,1186.00,720.00,1440.00,254.00,'2023-02-23 12:36:48'),(412,'1','311',1,'Retail Sale Id 455',0.00,1779.00,720.00,2160.00,381.00,'2023-02-23 12:38:12'),(413,'1','311',1,'Retail Sale Id 456',0.00,2965.00,720.00,3600.00,635.00,'2023-02-23 12:39:58'),(414,'1','311',1,'Retail Sale Id 457',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-23 12:41:17'),(415,'1','311',1,'Retail Sale Id 458',0.00,2965.00,720.00,3600.00,635.00,'2023-02-23 12:45:57'),(416,'1','311',1,'Retail Sale Id 459',0.00,2965.00,720.00,3600.00,635.00,'2023-02-23 13:26:31'),(417,'1','311',1,'Retail Sale Id 460',0.00,2965.00,720.00,3600.00,635.00,'2023-02-23 13:27:56'),(418,'1','311',1,'Retail Sale Id 461',0.00,824.27,720.00,1000.80,176.53,'2023-02-23 13:40:10'),(419,'1','311',1,'Retail Sale Id 462',0.00,2965.00,720.00,3600.00,635.00,'2023-02-23 13:51:34'),(420,'1','311',1,'Retail Sale Id 463',0.00,3558.00,720.00,4320.00,762.00,'2023-02-23 13:54:40'),(421,'1','311',1,'Retail Sale Id 464',0.00,2372.00,720.00,2880.00,508.00,'2023-02-23 14:05:29'),(422,'1','311',1,'Retail Sale Id 465',0.00,1186.00,720.00,1440.00,254.00,'2023-02-23 14:07:09'),(423,'1','311',1,'Retail Sale Id 466',0.00,2372.00,720.00,2880.00,508.00,'2023-02-23 14:09:37'),(424,'1','311',1,'Retail Sale Id 467',0.00,593.00,720.00,720.00,127.00,'2023-02-23 14:19:46'),(425,'1','311',1,'Retail Sale Id 468',0.00,1186.00,720.00,1440.00,254.00,'2023-02-23 14:47:11'),(426,'1','311',1,'Retail Sale Id 469',0.00,1779.00,720.00,2160.00,381.00,'2023-02-23 14:49:07'),(427,'1','311',1,'Retail Sale Id 470',0.00,1648.54,720.00,2001.60,353.06,'2023-02-23 15:17:41'),(428,'1','311',1,'Retail Sale Id 470',0.00,2057.71,720.00,2498.40,440.69,'2023-02-23 15:17:41'),(429,'1','311',1,'Retail Sale Id 471',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-23 15:27:06'),(430,'1','311',1,'Retail Sale Id 472',0.00,1186.00,720.00,1440.00,254.00,'2023-02-23 15:33:41'),(431,'1','311',1,'Retail Sale Id 473',0.00,2075.50,720.00,2520.00,444.50,'2023-02-23 15:46:01'),(432,'1','311',1,'Retail Sale Id 475',0.00,4744.00,720.00,5760.00,1016.00,'2023-02-23 15:50:40'),(433,'1','311',1,'Retail Sale Id 478',0.00,3558.00,720.00,4320.00,762.00,'2023-02-23 16:20:59'),(434,'1','311',1,'Retail Sale Id 478',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-23 16:21:00'),(435,'1','311',1,'Retail Sale Id 479',0.00,2372.00,720.00,2880.00,508.00,'2023-02-23 16:22:26'),(436,'1','311',1,'Retail Sale Id 480',0.00,1186.00,720.00,1440.00,254.00,'2023-02-23 16:28:20'),(437,'1','311',1,'Return of Retail Sale Id 480',1186.00,0.00,720.00,-1440.00,-254.00,'2023-02-23 16:31:50'),(438,'1','311',1,'Retail Sale Id 481',0.00,1233.44,720.00,1497.60,264.16,'2023-02-23 16:32:43'),(439,'1','311',1,'Retail Sale Id 482',0.00,1779.00,720.00,2160.00,381.00,'2023-02-23 16:35:17'),(440,'1','311',1,'Retail Sale Id 485',0.00,2965.00,720.00,3600.00,635.00,'2023-02-23 16:42:05'),(441,'1','311',1,'Retail Sale Id 486',0.00,2372.00,720.00,2880.00,508.00,'2023-02-23 16:44:49'),(442,'1','311',1,'Retail Sale Id 488',0.00,2965.00,720.00,3600.00,635.00,'2023-02-23 16:47:16'),(443,'1','311',1,'Retail Sale Id 489',0.00,1233.44,720.00,1497.60,264.16,'2023-02-23 16:50:41'),(444,'1','311',1,'Retail Sale Id 491',0.00,2372.00,720.00,2880.00,508.00,'2023-02-23 16:59:20'),(445,'1','311',1,'Retail Sale Id 492',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-23 17:03:28'),(446,'1','311',1,'Retail Sale Id 493',0.00,1779.00,720.00,2160.00,381.00,'2023-02-23 17:16:56'),(447,'1','311',1,'Retail Sale Id 494',0.00,2965.00,720.00,3600.00,635.00,'2023-02-23 17:29:11'),(448,'1','311',1,'Retail Sale Id 495',0.00,824.27,720.00,1000.80,176.53,'2023-02-23 17:38:04'),(449,'1','311',1,'Retail Sale Id 496',0.00,1191.93,720.00,1447.20,255.27,'2023-02-23 17:39:30'),(450,'1','311',1,'Retail Sale Id 497',0.00,1186.00,720.00,1440.00,254.00,'2023-02-23 17:40:48'),(451,'1','311',1,'Retail Sale Id 498',0.00,1191.93,720.00,1447.20,255.27,'2023-02-23 17:42:13'),(452,'1','311',1,'Return of Retail Sale Id 495',824.27,0.00,720.00,-1000.80,-176.53,'2023-02-23 17:46:46'),(453,'1','311',1,'Retail Sale Id 499',0.00,1779.00,720.00,2160.00,381.00,'2023-02-23 17:52:44'),(454,'1','311',1,'Retail Sale Id 500',0.00,2372.00,720.00,2880.00,508.00,'2023-02-23 18:18:33'),(455,'1','311',1,'Retail Sale Id 501',0.00,71160.00,680.00,81600.00,10440.00,'2023-02-23 18:31:17'),(456,'1','311',1,'Return of Retail Sale Id 492',7412.50,0.00,720.00,-9000.00,-1587.50,'2023-02-23 20:06:55'),(457,'1','311',1,'Retail Sale Id 502',0.00,2721.87,720.00,3304.80,582.93,'2023-02-23 20:08:28'),(458,'1','311',1,'Retail Sale Id 503',0.00,4690.63,720.00,5695.20,1004.57,'2023-02-23 20:09:57'),(459,'1','311',1,'Return of Retail Sale Id 503',4690.63,0.00,720.00,-5695.20,-1004.57,'2023-02-23 20:11:05'),(460,'1','311',1,'Retail Sale Id 504',0.00,4738.07,720.00,5752.80,1014.73,'2023-02-23 20:11:49'),(461,'1','311',1,'Retail Sale Id 507',0.00,4156.93,720.00,5047.20,890.27,'2023-02-28 08:14:36'),(462,'1','311',1,'Retail Sale Id 508',0.00,1648.54,720.00,2001.60,353.06,'2023-02-28 08:15:44'),(463,'1','311',1,'Retail Sale Id 509',0.00,1399.48,720.00,1699.20,299.72,'2023-02-28 08:16:59'),(464,'1','311',1,'Retail Sale Id 510',0.00,1779.00,720.00,2160.00,381.00,'2023-02-28 08:17:52'),(465,'1','311',1,'Retail Sale Id 511',0.00,824.27,720.00,1000.80,176.53,'2023-02-28 08:18:47'),(466,'1','311',1,'Retail Sale Id 512',0.00,1814.58,720.00,2203.20,388.62,'2023-02-28 08:19:48'),(467,'1','311',1,'Retail Sale Id 513',0.00,2389.79,720.00,2901.60,511.81,'2023-02-28 08:21:24'),(468,'1','311',1,'Retail Sale Id 514',0.00,741.25,720.00,900.00,158.75,'2023-02-28 08:22:35'),(469,'1','311',1,'Retail Sale Id 515',0.00,2372.00,720.00,2880.00,508.00,'2023-02-28 08:24:09'),(470,'1','311',1,'Return of Retail Sale Id 514',741.25,0.00,720.00,-900.00,-158.75,'2023-02-28 08:44:10'),(471,'1','311',1,'Retail Sale Id 517',0.00,3558.00,720.00,4320.00,762.00,'2023-02-28 08:47:40'),(472,'1','311',1,'Retail Sale Id 518',0.00,2372.00,720.00,2880.00,508.00,'2023-02-28 08:50:59'),(473,'1','311',1,'Retail Sale Id 519',0.00,824.27,720.00,1000.80,176.53,'2023-02-28 08:52:12'),(474,'1','311',1,'Retail Sale Id 521',0.00,2472.81,720.00,3002.40,529.59,'2023-02-28 08:54:31'),(475,'1','311',1,'Retail Sale Id 522',0.00,1186.00,720.00,1440.00,254.00,'2023-02-28 08:55:38'),(476,'1','311',1,'Retail Sale Id 523',0.00,3558.00,720.00,4320.00,762.00,'2023-02-28 08:58:01'),(477,'1','311',1,'Retail Sale Id 524',0.00,2372.00,720.00,2880.00,508.00,'2023-02-28 09:05:01'),(478,'1','311',1,'Retail Sale Id 525',0.00,2965.00,720.00,3600.00,635.00,'2023-02-28 09:07:14'),(479,'1','311',1,'Retail Sale Id 526',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-28 09:15:44'),(480,'1','311',1,'Retail Sale Id 527',0.00,1779.00,720.00,2160.00,381.00,'2023-02-28 09:17:41'),(481,'1','311',1,'Retail Sale Id 527',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-28 09:17:41'),(482,'1','311',1,'Retail Sale Id 528',0.00,1648.54,720.00,2001.60,353.06,'2023-02-28 09:20:03'),(483,'1','311',1,'Retail Sale Id 529',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-28 09:21:32'),(484,'1','311',1,'Retail Sale Id 530',0.00,2965.00,720.00,3600.00,635.00,'2023-02-28 09:24:08'),(485,'1','311',1,'Retail Sale Id 531',0.00,1779.00,720.00,2160.00,381.00,'2023-02-28 09:32:47'),(486,'1','311',1,'Retail Sale Id 532',0.00,4151.00,720.00,5040.00,889.00,'2023-02-28 09:34:26'),(487,'1','311',1,'Retail Sale Id 533',0.00,1186.00,720.00,1440.00,254.00,'2023-02-28 09:36:36'),(488,'1','311',1,'Retail Sale Id 534',0.00,616.72,720.00,748.80,132.08,'2023-02-28 09:39:28'),(489,'1','311',1,'Retail Sale Id 535',0.00,2472.81,720.00,3002.40,529.59,'2023-02-28 09:41:10'),(490,'1','311',1,'Retail Sale Id 536',0.00,2057.71,720.00,2498.40,440.69,'2023-02-28 09:42:38'),(491,'1','311',1,'Retail Sale Id 540',0.00,1779.00,720.00,2160.00,381.00,'2023-02-28 09:48:40'),(492,'1','311',1,'Retail Sale Id 541',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-28 09:53:05'),(493,'1','311',1,'Retail Sale Id 543',0.00,1186.00,720.00,1440.00,254.00,'2023-02-28 10:03:40'),(494,'1','311',1,'Retail Sale Id 544',0.00,1779.00,720.00,2160.00,381.00,'2023-02-28 10:05:18'),(495,'1','311',1,'Retail Sale Id 546',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-28 10:08:00'),(496,'1','311',1,'Retail Sale Id 549',0.00,2472.81,720.00,3002.40,529.59,'2023-02-28 10:20:22'),(497,'1','311',1,'Retail Sale Id 550',0.00,1648.54,720.00,2001.60,353.06,'2023-02-28 10:21:06'),(498,'1','311',1,'Retail Sale Id 551',0.00,2965.00,720.00,3600.00,635.00,'2023-02-28 10:21:46'),(499,'1','311',1,'Retail Sale Id 552',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-28 10:22:43'),(500,'1','311',1,'Retail Sale Id 554',0.00,3558.00,720.00,4320.00,762.00,'2023-02-28 10:25:54'),(501,'1','311',1,'Retail Sale Id 556',0.00,6523.00,720.00,7920.00,1397.00,'2023-02-28 10:28:11'),(502,'1','311',1,'Retail Sale Id 557',0.00,1648.54,720.00,2001.60,353.06,'2023-02-28 10:31:20'),(503,'1','311',1,'Retail Sale Id 558',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-28 10:45:47'),(504,'1','311',1,'Retail Sale Id 559',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-28 10:56:22'),(505,'1','311',1,'Retail Sale Id 563',0.00,2965.00,720.00,3600.00,635.00,'2023-02-28 11:04:49'),(506,'1','311',1,'Retail Sale Id 564',0.00,1731.56,720.00,2102.40,370.84,'2023-02-28 11:11:03'),(507,'1','311',1,'Retail Sale Id 565',0.00,1779.00,720.00,2160.00,381.00,'2023-02-28 11:14:54'),(508,'1','311',1,'Retail Sale Id 566',0.00,177900.00,680.00,204000.00,26100.00,'2023-02-28 11:20:24'),(509,'1','311',1,'Retail Sale Id 567',0.00,3558.00,720.00,4320.00,762.00,'2023-02-28 11:23:35'),(510,'1','311',1,'Retail Sale Id 568',0.00,2472.81,720.00,3002.40,529.59,'2023-02-28 11:33:33'),(511,'1','311',1,'Retail Sale Id 570',0.00,824.27,720.00,1000.80,176.53,'2023-02-28 11:47:09'),(512,'1','311',1,'Retail Sale Id 571',0.00,3297.08,720.00,4003.20,706.12,'2023-02-28 11:49:38'),(513,'1','311',1,'Retail Sale Id 572',0.00,1648.54,720.00,2001.60,353.06,'2023-02-28 11:53:26'),(514,'1','311',1,'Retail Sale Id 573',0.00,106740.00,680.00,122400.00,15660.00,'2023-02-28 12:01:04'),(515,'1','311',1,'Retail Sale Id 574',0.00,1191.93,720.00,1447.20,255.27,'2023-02-28 12:16:50'),(516,'1','311',1,'Retail Sale Id 575',0.00,1779.00,720.00,2160.00,381.00,'2023-02-28 12:29:44'),(517,'1','311',1,'Retail Sale Id 576',0.00,1186.00,720.00,1440.00,254.00,'2023-02-28 12:39:10'),(518,'1','311',1,'Retail Sale Id 577',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-28 13:10:10'),(519,'1','311',1,'Retail Sale Id 578',0.00,6588.23,720.00,7999.20,1410.97,'2023-02-28 13:11:45'),(520,'1','311',1,'Return of Retail Sale Id 578',6588.23,0.00,720.00,-7999.20,-1410.97,'2023-02-28 13:13:04'),(521,'1','311',1,'Retail Sale Id 579',0.00,6588.23,720.00,7999.20,1410.97,'2023-02-28 13:14:35'),(522,'1','311',1,'Retail Sale Id 581',0.00,4156.93,720.00,5047.20,890.27,'2023-02-28 13:25:29'),(523,'1','311',1,'Retail Sale Id 582',0.00,1186.00,720.00,1440.00,254.00,'2023-02-28 13:35:02'),(524,'1','311',1,'Retail Sale Id 583',0.00,3558.00,720.00,4320.00,762.00,'2023-02-28 13:53:08'),(525,'1','311',1,'Retail Sale Id 584',0.00,3558.00,720.00,4320.00,762.00,'2023-02-28 14:01:56'),(526,'1','311',1,'Retail Sale Id 586',0.00,2965.00,720.00,3600.00,635.00,'2023-02-28 14:07:21'),(527,'1','311',1,'Retail Sale Id 587',0.00,1779.00,720.00,2160.00,381.00,'2023-02-28 14:11:48'),(528,'1','311',1,'Retail Sale Id 588',0.00,2965.00,720.00,3600.00,635.00,'2023-02-28 14:26:24'),(529,'1','311',1,'Retail Sale Id 589',0.00,1186.00,720.00,1440.00,254.00,'2023-02-28 14:27:52'),(530,'1','311',1,'Retail Sale Id 590',0.00,2472.81,720.00,3002.40,529.59,'2023-02-28 14:34:58'),(531,'1','311',1,'Retail Sale Id 591',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-28 14:36:52'),(532,'1','311',1,'Retail Sale Id 593',0.00,1814.58,720.00,2203.20,388.62,'2023-02-28 14:41:51'),(533,'1','311',1,'Retail Sale Id 595',0.00,1186.00,720.00,1440.00,254.00,'2023-02-28 14:49:43'),(534,'1','311',1,'Retail Sale Id 596',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-28 14:51:26'),(535,'1','311',1,'Retail Sale Id 597',0.00,7116.00,720.00,8640.00,1524.00,'2023-02-28 14:54:59'),(536,'1','311',1,'Retail Sale Id 598',0.00,1779.00,720.00,2160.00,381.00,'2023-02-28 14:59:02'),(537,'1','311',1,'Retail Sale Id 599',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-28 15:02:38'),(538,'1','311',1,'Retail Sale Id 601',0.00,1186.00,720.00,1440.00,254.00,'2023-02-28 15:06:15'),(539,'1','311',1,'Retail Sale Id 601',0.00,1186.00,720.00,1440.00,254.00,'2023-02-28 15:06:15'),(540,'1','311',1,'Retail Sale Id 603',0.00,3558.00,720.00,4320.00,762.00,'2023-02-28 15:10:15'),(541,'1','311',1,'Retail Sale Id 603',0.00,3558.00,720.00,4320.00,762.00,'2023-02-28 15:10:15'),(542,'1','311',1,'Return of Retail Sale Id 599',7412.50,0.00,720.00,-9000.00,-1587.50,'2023-02-28 15:11:36'),(543,'1','311',1,'Retail Sale Id 604',0.00,7133.79,720.00,8661.60,1527.81,'2023-02-28 15:13:35'),(544,'1','311',1,'Retail Sale Id 605',0.00,1186.00,720.00,1440.00,254.00,'2023-02-28 15:14:41'),(545,'1','311',1,'Retail Sale Id 606',0.00,1773.07,720.00,2152.80,379.73,'2023-02-28 15:21:53'),(546,'1','311',1,'Retail Sale Id 607',0.00,2372.00,720.00,2880.00,508.00,'2023-02-28 16:18:33'),(547,'1','311',1,'Retail Sale Id 608',0.00,1648.54,720.00,2001.60,353.06,'2023-02-28 16:19:20'),(548,'1','311',1,'Retail Sale Id 609',0.00,1233.44,720.00,1497.60,264.16,'2023-02-28 16:20:03'),(549,'1','311',1,'Retail Sale Id 610',0.00,2965.00,720.00,3600.00,635.00,'2023-02-28 16:20:52'),(550,'1','311',1,'Retail Sale Id 611',0.00,3297.08,720.00,4003.20,706.12,'2023-02-28 16:21:41'),(551,'1','311',1,'Retail Sale Id 612',0.00,824.27,720.00,1000.80,176.53,'2023-02-28 16:22:37'),(552,'1','311',1,'Retail Sale Id 613',0.00,9061.04,720.00,11001.60,1940.56,'2023-02-28 16:24:12'),(553,'1','311',1,'Retail Sale Id 614',0.00,4151.00,720.00,5040.00,889.00,'2023-02-28 16:25:16'),(554,'1','311',1,'Retail Sale Id 615',0.00,1233.44,720.00,1497.60,264.16,'2023-02-28 16:26:21'),(555,'1','311',1,'Retail Sale Id 617',0.00,3558.00,720.00,4320.00,762.00,'2023-02-28 16:29:00'),(556,'1','311',1,'Retail Sale Id 618',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-28 16:30:20'),(557,'1','311',1,'Retail Sale Id 618',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-28 16:30:20'),(558,'1','311',1,'Retail Sale Id 619',0.00,1233.44,720.00,1497.60,264.16,'2023-02-28 16:31:51'),(559,'1','311',1,'Retail Sale Id 620',0.00,1814.58,720.00,2203.20,388.62,'2023-02-28 16:32:55'),(560,'1','311',1,'Retail Sale Id 621',0.00,3558.00,720.00,4320.00,762.00,'2023-02-28 16:34:06'),(561,'1','311',1,'Retail Sale Id 622',0.00,1233.44,720.00,1497.60,264.16,'2023-02-28 16:34:59'),(562,'1','311',1,'Retail Sale Id 623',0.00,3558.00,720.00,4320.00,762.00,'2023-02-28 16:38:17'),(563,'1','311',1,'Retail Sale Id 624',0.00,4151.00,720.00,5040.00,889.00,'2023-02-28 16:39:39'),(564,'1','311',1,'Retail Sale Id 625',0.00,1779.00,720.00,2160.00,381.00,'2023-02-28 16:40:42'),(565,'1','311',1,'Retail Sale Id 626',0.00,3558.00,720.00,4320.00,762.00,'2023-02-28 16:42:23'),(566,'1','311',1,'Retail Sale Id 627',0.00,658.23,720.00,799.20,140.97,'2023-02-28 16:44:13'),(567,'1','311',1,'Retail Sale Id 628',0.00,1233.44,720.00,1497.60,264.16,'2023-02-28 16:46:56'),(568,'1','311',1,'Retail Sale Id 629',0.00,1779.00,720.00,2160.00,381.00,'2023-02-28 16:47:33'),(569,'1','311',1,'Retail Sale Id 630',0.00,2372.00,720.00,2880.00,508.00,'2023-02-28 16:48:53'),(570,'1','311',1,'Retail Sale Id 631',0.00,2965.00,720.00,3600.00,635.00,'2023-02-28 16:49:45'),(571,'1','311',1,'Retail Sale Id 632',0.00,4151.00,720.00,5040.00,889.00,'2023-02-28 16:50:39'),(572,'1','311',1,'Retail Sale Id 634',0.00,658.23,720.00,799.20,140.97,'2023-02-28 16:59:44'),(573,'1','311',1,'Retail Sale Id 635',0.00,2472.81,720.00,3002.40,529.59,'2023-02-28 17:08:22'),(574,'1','311',1,'Retail Sale Id 636',0.00,3558.00,720.00,4320.00,762.00,'2023-02-28 17:12:26'),(575,'1','311',1,'Retail Sale Id 637',0.00,1779.00,720.00,2160.00,381.00,'2023-02-28 17:13:39'),(576,'1','311',1,'Retail Sale Id 638',0.00,2372.00,720.00,2880.00,508.00,'2023-02-28 17:14:39'),(577,'1','311',1,'Retail Sale Id 639',0.00,2965.00,720.00,3600.00,635.00,'2023-02-28 17:17:41'),(578,'1','311',1,'Retail Sale Id 639',0.00,3558.00,720.00,4320.00,762.00,'2023-02-28 17:17:41'),(579,'1','311',1,'Retail Sale Id 640',0.00,3297.08,720.00,4003.20,706.12,'2023-02-28 17:20:00'),(580,'1','311',1,'Retail Sale Id 641',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-28 17:21:20'),(581,'1','311',1,'Retail Sale Id 642',0.00,2965.00,720.00,3600.00,635.00,'2023-02-28 17:22:50'),(582,'1','311',1,'Retail Sale Id 643',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-28 17:24:21'),(583,'1','311',1,'Retail Sale Id 644',0.00,4151.00,720.00,5040.00,889.00,'2023-02-28 17:26:25'),(584,'1','311',1,'Retail Sale Id 645',0.00,5930.00,720.00,7200.00,1270.00,'2023-02-28 17:27:38'),(585,'1','311',1,'Retail Sale Id 647',0.00,4115.42,720.00,4996.80,881.38,'2023-02-28 17:34:07'),(586,'1','311',1,'Retail Sale Id 648',0.00,4151.00,720.00,5040.00,889.00,'2023-02-28 17:35:12'),(587,'1','311',1,'Retail Sale Id 649',0.00,3297.08,720.00,4003.20,706.12,'2023-02-28 17:36:19'),(588,'1','311',1,'Retail Sale Id 650',0.00,1186.00,720.00,1440.00,254.00,'2023-02-28 17:37:58'),(589,'1','311',1,'Retail Sale Id 651',0.00,6523.00,720.00,7920.00,1397.00,'2023-02-28 17:39:52'),(590,'1','311',1,'Retail Sale Id 652',0.00,1779.00,720.00,2160.00,381.00,'2023-02-28 17:43:17'),(591,'1','311',1,'Retail Sale Id 653',0.00,2965.00,720.00,3600.00,635.00,'2023-02-28 17:45:35'),(592,'1','311',1,'Retail Sale Id 654',0.00,824.27,720.00,1000.80,176.53,'2023-02-28 17:46:38'),(593,'1','311',1,'Retail Sale Id 655',0.00,2472.81,720.00,3002.40,529.59,'2023-02-28 17:48:29'),(594,'1','311',1,'Retail Sale Id 656',0.00,2965.00,720.00,3600.00,635.00,'2023-02-28 17:49:18'),(595,'1','311',1,'Retail Sale Id 657',0.00,824.27,720.00,1000.80,176.53,'2023-02-28 17:50:36'),(596,'1','311',1,'Retail Sale Id 658',0.00,2965.00,720.00,3600.00,635.00,'2023-02-28 17:53:23'),(597,'1','311',1,'Retail Sale Id 660',0.00,2965.00,720.00,3600.00,635.00,'2023-02-28 17:55:26'),(598,'1','311',1,'Retail Sale Id 661',0.00,616.72,720.00,748.80,132.08,'2023-02-28 17:57:10'),(599,'1','311',1,'Retail Sale Id 662',0.00,1779.00,720.00,2160.00,381.00,'2023-02-28 17:58:50'),(600,'1','311',1,'Retail Sale Id 663',0.00,1779.00,720.00,2160.00,381.00,'2023-02-28 18:03:01'),(601,'1','311',1,'Retail Sale Id 664',0.00,2057.71,720.00,2498.40,440.69,'2023-02-28 18:05:07'),(602,'1','311',1,'Retail Sale Id 665',0.00,2965.00,720.00,3600.00,635.00,'2023-02-28 18:06:37'),(603,'1','311',1,'Retail Sale Id 666',0.00,1779.00,720.00,2160.00,381.00,'2023-02-28 18:08:17'),(604,'1','311',1,'Retail Sale Id 667',0.00,7116.00,720.00,8640.00,1524.00,'2023-02-28 18:12:03'),(605,'1','311',1,'Retail Sale Id 669',0.00,1186.00,720.00,1440.00,254.00,'2023-02-28 18:15:25'),(606,'1','311',1,'Retail Sale Id 671',0.00,1779.00,720.00,2160.00,381.00,'2023-02-28 18:16:36'),(607,'1','311',1,'Retail Sale Id 672',0.00,2965.00,720.00,3600.00,635.00,'2023-02-28 18:17:54'),(608,'1','311',1,'Retail Sale Id 673',0.00,1233.44,720.00,1497.60,264.16,'2023-02-28 18:18:50'),(609,'1','311',1,'Retail Sale Id 674',0.00,1648.54,720.00,2001.60,353.06,'2023-02-28 18:21:53'),(610,'1','311',1,'Retail Sale Id 675',0.00,2057.71,720.00,2498.40,440.69,'2023-02-28 18:23:34'),(611,'1','311',1,'Retail Sale Id 676',0.00,7412.50,720.00,9000.00,1587.50,'2023-02-28 18:27:08'),(612,'1','311',1,'Retail Sale Id 677',0.00,2965.00,720.00,3600.00,635.00,'2023-02-28 18:32:05'),(613,'1','311',1,'Retail Sale Id 678',0.00,1779.00,720.00,2160.00,381.00,'2023-02-28 18:36:20'),(614,'1','311',1,'Return of Retail Sale Id 676',7412.50,0.00,720.00,-9000.00,-1587.50,'2023-02-28 20:44:22'),(615,'1','311',1,'Retail Sale Id 679',0.00,2810.82,720.00,3412.80,601.98,'2023-02-28 20:45:25'),(616,'1','311',1,'Return of Retail Sale Id 667',7116.00,0.00,720.00,-8640.00,-1524.00,'2023-02-28 20:54:00'),(617,'1','311',1,'Retail Sale Id 680',0.00,2211.89,720.00,2685.60,473.71,'2023-02-28 20:56:07'),(618,'1','311',1,'Return of Retail Sale Id 680',2211.89,0.00,720.00,-2685.60,-473.71,'2023-02-28 20:58:06'),(619,'1','311',1,'Retail Sale Id 681',0.00,2211.89,720.00,2685.60,473.71,'2023-02-28 20:59:07'),(620,'1','311',1,'Retail Sale Id 682',0.00,4892.25,720.00,5940.00,1047.75,'2023-02-28 21:01:34'),(621,'1','311',1,'Return of Retail Sale Id 681',2211.89,0.00,720.00,-2685.60,-473.71,'2023-02-28 21:03:46'),(622,'1','311',1,'Retail Sale Id 683',0.00,2211.89,720.00,2685.60,473.71,'2023-02-28 21:04:29'),(623,'1','311',1,'Retail Sale Id 684',0.00,1779.00,720.00,2160.00,381.00,'2023-03-01 08:17:12'),(624,'1','311',1,'Retail Sale Id 685',0.00,2965.00,720.00,3600.00,635.00,'2023-03-01 08:18:20'),(625,'1','311',1,'Retail Sale Id 686',0.00,2965.00,720.00,3600.00,635.00,'2023-03-01 08:31:36'),(626,'1','311',1,'Retail Sale Id 688',0.00,4151.00,720.00,5040.00,889.00,'2023-03-01 08:33:22'),(627,'1','311',1,'Retail Sale Id 689',0.00,2057.71,720.00,2498.40,440.69,'2023-03-01 08:59:38'),(628,'1','311',1,'Return of Retail Sale Id 689',2057.71,0.00,720.00,-2498.40,-440.69,'2023-03-01 09:03:25'),(629,'1','311',1,'Retail Sale Id 690',0.00,2965.00,720.00,3600.00,635.00,'2023-03-01 09:04:17'),(630,'1','311',1,'Retail Sale Id 691',0.00,3558.00,720.00,4320.00,762.00,'2023-03-01 09:11:15'),(631,'1','311',1,'Retail Sale Id 692',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-01 09:14:26'),(632,'1','311',1,'Retail Sale Id 693',0.00,1648.54,720.00,2001.60,353.06,'2023-03-01 09:53:44'),(633,'1','311',1,'Retail Sale Id 694',0.00,1186.00,720.00,1440.00,254.00,'2023-03-01 10:01:04'),(634,'1','311',1,'Retail Sale Id 695',0.00,4151.00,720.00,5040.00,889.00,'2023-03-01 10:02:00'),(635,'1','311',1,'Retail Sale Id 696',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-01 10:05:41'),(636,'1','311',1,'Retail Sale Id 697',0.00,616.72,720.00,748.80,132.08,'2023-03-01 10:07:09'),(637,'1','311',1,'Retail Sale Id 698',0.00,3558.00,720.00,4320.00,762.00,'2023-03-01 10:20:44'),(638,'1','311',1,'Retail Sale Id 699',0.00,3558.00,720.00,4320.00,762.00,'2023-03-01 10:24:28'),(639,'1','311',1,'Return of Retail Sale Id 699',3558.00,0.00,720.00,-4320.00,-762.00,'2023-03-01 10:31:20'),(640,'1','311',1,'Retail Sale Id 701',0.00,4151.00,720.00,5040.00,889.00,'2023-03-01 10:33:40'),(641,'1','311',1,'Retail Sale Id 702',0.00,1233.44,720.00,1497.60,264.16,'2023-03-01 10:35:01'),(642,'1','311',1,'Retail Sale Id 703',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-01 10:35:56'),(643,'1','311',1,'Retail Sale Id 704',0.00,2057.71,720.00,2498.40,440.69,'2023-03-01 10:53:06'),(644,'1','311',1,'Retail Sale Id 705',0.00,2965.00,720.00,3600.00,635.00,'2023-03-01 10:56:41'),(645,'1','311',1,'Retail Sale Id 706',0.00,4939.69,720.00,5997.60,1057.91,'2023-03-01 10:58:59'),(646,'1','311',1,'Retail Sale Id 707',0.00,2472.81,720.00,3002.40,529.59,'2023-03-01 11:01:57'),(647,'1','311',1,'Retail Sale Id 708',0.00,3558.00,720.00,4320.00,762.00,'2023-03-01 11:03:38'),(648,'1','311',1,'Retail Sale Id 709',0.00,1648.54,720.00,2001.60,353.06,'2023-03-01 11:04:47'),(649,'1','311',1,'Retail Sale Id 711',0.00,2881.98,720.00,3499.20,617.22,'2023-03-01 11:07:35'),(650,'1','311',1,'Retail Sale Id 712',0.00,1186.00,720.00,1440.00,254.00,'2023-03-01 11:23:40'),(651,'1','311',1,'Retail Sale Id 713',0.00,2472.81,720.00,3002.40,529.59,'2023-03-01 11:29:16'),(652,'1','311',1,'Retail Sale Id 713',0.00,3297.08,720.00,4003.20,706.12,'2023-03-01 11:29:16'),(653,'1','311',1,'Retail Sale Id 714',0.00,824.27,720.00,1000.80,176.53,'2023-03-01 11:30:57'),(654,'1','311',1,'Retail Sale Id 715',0.00,1779.00,720.00,2160.00,381.00,'2023-03-01 12:03:00'),(655,'1','311',1,'Retail Sale Id 716',0.00,2372.00,720.00,2880.00,508.00,'2023-03-01 12:17:03'),(656,'1','311',1,'Retail Sale Id 717',0.00,1648.54,720.00,2001.60,353.06,'2023-03-01 12:18:18'),(657,'1','311',1,'Retail Sale Id 718',0.00,593.00,720.00,720.00,127.00,'2023-03-01 12:24:37'),(658,'1','311',1,'Retail Sale Id 719',0.00,2965.00,720.00,3600.00,635.00,'2023-03-01 12:39:37'),(659,'1','311',1,'Retail Sale Id 720',0.00,6523.00,720.00,7920.00,1397.00,'2023-03-01 12:41:50'),(660,'1','311',1,'Retail Sale Id 721',0.00,2472.81,720.00,3002.40,529.59,'2023-03-01 12:56:23'),(661,'1','311',1,'Retail Sale Id 722',0.00,1648.54,720.00,2001.60,353.06,'2023-03-01 12:57:23'),(662,'1','311',1,'Retail Sale Id 723',0.00,4151.00,720.00,5040.00,889.00,'2023-03-01 12:58:06'),(663,'1','311',1,'Retail Sale Id 724',0.00,2372.00,720.00,2880.00,508.00,'2023-03-01 13:10:37'),(664,'1','311',1,'Retail Sale Id 725',0.00,1779.00,720.00,2160.00,381.00,'2023-03-01 13:19:18'),(665,'1','311',1,'Retail Sale Id 726',0.00,1779.00,720.00,2160.00,381.00,'2023-03-01 13:27:52'),(666,'1','311',1,'Retail Sale Id 727',0.00,824.27,720.00,1000.80,176.53,'2023-03-01 13:34:12'),(667,'1','311',1,'Retail Sale Id 728',0.00,4382.27,720.00,5320.80,938.53,'2023-03-01 13:36:13'),(668,'1','311',1,'Return of Retail Sale Id 728',4382.27,0.00,720.00,-5320.80,-938.53,'2023-03-01 13:36:56'),(669,'1','311',1,'Retail Sale Id 729',0.00,3558.00,720.00,4320.00,762.00,'2023-03-01 13:37:37'),(670,'1','311',1,'Retail Sale Id 730',0.00,824.27,720.00,1000.80,176.53,'2023-03-01 13:40:24'),(671,'1','311',1,'Retail Sale Id 731',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-01 13:57:05'),(672,'1','311',1,'Retail Sale Id 732',0.00,4151.00,720.00,5040.00,889.00,'2023-03-01 13:58:51'),(673,'1','311',1,'Retail Sale Id 733',0.00,1482.50,720.00,1800.00,317.50,'2023-03-01 14:06:02'),(674,'1','311',1,'Retail Sale Id 734',0.00,1233.44,720.00,1497.60,264.16,'2023-03-01 14:20:11'),(675,'1','311',1,'Retail Sale Id 736',0.00,3558.00,720.00,4320.00,762.00,'2023-03-01 14:23:38'),(676,'1','311',1,'Retail Sale Id 737',0.00,3415.68,720.00,4147.20,731.52,'2023-03-01 14:24:53'),(677,'1','311',1,'Retail Sale Id 738',0.00,2372.00,720.00,2880.00,508.00,'2023-03-01 14:25:58'),(678,'1','311',1,'Retail Sale Id 739',0.00,2965.00,720.00,3600.00,635.00,'2023-03-01 14:29:12'),(679,'1','311',1,'Retail Sale Id 741',0.00,7116.00,720.00,8640.00,1524.00,'2023-03-01 14:39:14'),(680,'1','311',1,'Retail Sale Id 742',0.00,2965.00,720.00,3600.00,635.00,'2023-03-01 14:44:14'),(681,'1','311',1,'Retail Sale Id 743',0.00,2965.00,720.00,3600.00,635.00,'2023-03-01 14:49:50'),(682,'1','311',1,'Retail Sale Id 743',0.00,2965.00,720.00,3600.00,635.00,'2023-03-01 14:49:50'),(683,'1','311',1,'Retail Sale Id 744',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-01 14:58:24'),(684,'1','311',1,'Retail Sale Id 745',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-01 15:01:47'),(685,'1','311',1,'Retail Sale Id 746',0.00,1186.00,720.00,1440.00,254.00,'2023-03-01 15:08:24'),(686,'1','311',1,'Retail Sale Id 747',0.00,1779.00,720.00,2160.00,381.00,'2023-03-01 15:14:54'),(687,'1','311',1,'Retail Sale Id 748',0.00,3297.08,720.00,4003.20,706.12,'2023-03-01 15:33:17'),(688,'1','311',1,'Retail Sale Id 750',0.00,1779.00,720.00,2160.00,381.00,'2023-03-01 15:36:42'),(689,'1','311',1,'Retail Sale Id 750',0.00,3558.00,720.00,4320.00,762.00,'2023-03-01 15:36:42'),(690,'1','311',1,'Retail Sale Id 751',0.00,2372.00,720.00,2880.00,508.00,'2023-03-01 15:38:31'),(691,'1','311',1,'Retail Sale Id 752',0.00,2057.71,720.00,2498.40,440.69,'2023-03-01 15:39:58'),(692,'1','311',1,'Retail Sale Id 754',0.00,1233.44,720.00,1497.60,264.16,'2023-03-01 16:02:22'),(693,'1','311',1,'Retail Sale Id 757',0.00,1150.42,720.00,1396.80,246.38,'2023-03-01 16:09:28'),(694,'1','311',1,'Retail Sale Id 758',0.00,3558.00,720.00,4320.00,762.00,'2023-03-01 16:32:05'),(695,'1','311',1,'Retail Sale Id 759',0.00,2965.00,720.00,3600.00,635.00,'2023-03-01 17:13:43'),(696,'1','311',1,'Retail Sale Id 760',0.00,1186.00,720.00,1440.00,254.00,'2023-03-01 17:21:55'),(697,'1','311',1,'Retail Sale Id 761',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-01 17:27:16'),(698,'1','311',1,'Retail Sale Id 762',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-01 17:36:41'),(699,'1','311',1,'Return of Retail Sale Id 762',7412.50,0.00,720.00,-9000.00,-1587.50,'2023-03-01 17:37:23'),(700,'1','311',1,'Retail Sale Id 763',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-01 17:37:59'),(701,'1','311',1,'Retail Sale Id 764',0.00,1779.00,720.00,2160.00,381.00,'2023-03-01 17:40:11'),(702,'1','311',1,'Return of Retail Sale Id 764',1779.00,0.00,720.00,-2160.00,-381.00,'2023-03-01 20:30:33'),(703,'1','311',1,'Return of Retail Sale Id 746',1186.00,0.00,720.00,-1440.00,-254.00,'2023-03-01 20:35:04'),(704,'1','311',1,'Retail Sale Id 765',0.00,1186.00,720.00,1440.00,254.00,'2023-03-01 20:36:05'),(705,'1','311',1,'Return of Retail Sale Id 763',7412.50,0.00,720.00,-9000.00,-1587.50,'2023-03-01 20:39:32'),(706,'1','311',1,'Return of Retail Sale Id 757',1150.42,0.00,720.00,-1396.80,-246.38,'2023-03-01 20:43:32'),(707,'1','311',1,'Retail Sale Id 766',0.00,1108.91,720.00,1346.40,237.49,'2023-03-01 20:44:44'),(708,'1','311',1,'Retail Sale Id 767',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-02 08:07:21'),(709,'1','311',1,'Retail Sale Id 768',0.00,4151.00,720.00,5040.00,889.00,'2023-03-02 08:09:34'),(710,'1','311',1,'Retail Sale Id 770',0.00,2965.00,720.00,3600.00,635.00,'2023-03-02 08:13:15'),(711,'1','311',1,'Retail Sale Id 770',0.00,4151.00,720.00,5040.00,889.00,'2023-03-02 08:13:15'),(712,'1','311',1,'Retail Sale Id 771',0.00,1186.00,720.00,1440.00,254.00,'2023-03-02 08:17:09'),(713,'1','311',1,'Retail Sale Id 772',0.00,3854.50,720.00,4680.00,825.50,'2023-03-02 08:25:46'),(714,'1','311',1,'Retail Sale Id 773',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-02 08:38:50'),(715,'1','311',1,'Retail Sale Id 774',0.00,2472.81,720.00,3002.40,529.59,'2023-03-02 08:45:16'),(716,'1','311',1,'Retail Sale Id 776',0.00,1233.44,720.00,1497.60,264.16,'2023-03-02 08:56:24'),(717,'1','311',1,'Retail Sale Id 777',0.00,1233.44,720.00,1497.60,264.16,'2023-03-02 08:57:55'),(718,'1','311',1,'Retail Sale Id 778',0.00,593.00,720.00,720.00,127.00,'2023-03-02 09:00:12'),(719,'1','311',1,'Retail Sale Id 779',0.00,4151.00,720.00,5040.00,889.00,'2023-03-02 09:10:09'),(720,'1','311',1,'Retail Sale Id 780',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-02 09:11:32'),(721,'1','311',1,'Retail Sale Id 781',0.00,2472.81,720.00,3002.40,529.59,'2023-03-02 09:12:38'),(722,'1','311',1,'Retail Sale Id 782',0.00,3558.00,720.00,4320.00,762.00,'2023-03-02 09:18:00'),(723,'1','311',1,'Retail Sale Id 783',0.00,1779.00,720.00,2160.00,381.00,'2023-03-02 09:24:30'),(724,'1','311',1,'Retail Sale Id 784',0.00,1648.54,720.00,2001.60,353.06,'2023-03-02 09:35:08'),(725,'1','311',1,'Retail Sale Id 785',0.00,3558.00,720.00,4320.00,762.00,'2023-03-02 09:36:09'),(726,'1','311',1,'Retail Sale Id 786',0.00,2372.00,720.00,2880.00,508.00,'2023-03-02 09:38:13'),(727,'1','311',1,'Retail Sale Id 788',0.00,1814.58,720.00,2203.20,388.62,'2023-03-02 09:49:03'),(728,'1','311',1,'Retail Sale Id 789',0.00,658.23,720.00,799.20,140.97,'2023-03-02 09:58:05'),(729,'1','311',1,'Retail Sale Id 790',0.00,1779.00,720.00,2160.00,381.00,'2023-03-02 10:02:05'),(730,'1','311',1,'Retail Sale Id 791',0.00,5930.00,720.00,7200.00,1270.00,'2023-03-02 10:11:03'),(731,'1','311',1,'Retail Sale Id 792',0.00,6588.23,720.00,7999.20,1410.97,'2023-03-02 10:14:46'),(732,'1','311',1,'Return of Retail Sale Id 792',6588.23,0.00,720.00,-7999.20,-1410.97,'2023-03-02 10:16:13'),(733,'1','311',1,'Retail Sale Id 793',0.00,658.23,720.00,799.20,140.97,'2023-03-02 10:16:49'),(734,'1','311',1,'Retail Sale Id 795',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-02 10:49:42'),(735,'1','311',1,'Retail Sale Id 797',0.00,1648.54,720.00,2001.60,353.06,'2023-03-02 12:33:37'),(736,'1','311',1,'Retail Sale Id 797',0.00,2965.00,720.00,3600.00,635.00,'2023-03-02 12:33:37'),(737,'1','311',1,'Retail Sale Id 798',0.00,1186.00,720.00,1440.00,254.00,'2023-03-02 12:37:24'),(738,'1','311',1,'Retail Sale Id 798',0.00,1233.44,720.00,1497.60,264.16,'2023-03-02 12:37:24'),(739,'1','311',1,'Retail Sale Id 800',0.00,2372.00,720.00,2880.00,508.00,'2023-03-02 12:58:53'),(740,'1','311',1,'Retail Sale Id 800',0.00,5930.00,720.00,7200.00,1270.00,'2023-03-02 12:58:53'),(741,'1','311',1,'Retail Sale Id 801',0.00,824.27,720.00,1000.80,176.53,'2023-03-02 13:04:37'),(742,'1','311',1,'Retail Sale Id 803',0.00,5930.00,720.00,7200.00,1270.00,'2023-03-02 13:32:05'),(743,'1','311',1,'Retail Sale Id 804',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-02 13:34:01'),(744,'1','311',1,'Retail Sale Id 805',0.00,1779.00,720.00,2160.00,381.00,'2023-03-02 13:46:56'),(745,'1','311',1,'Retail Sale Id 806',0.00,5930.00,720.00,7200.00,1270.00,'2023-03-02 13:47:41'),(746,'1','311',1,'Retail Sale Id 807',0.00,1233.44,720.00,1497.60,264.16,'2023-03-02 15:22:15'),(747,'1','311',1,'Retail Sale Id 808',0.00,1186.00,720.00,1440.00,254.00,'2023-03-02 15:24:43'),(748,'1','311',1,'Retail Sale Id 809',0.00,616.72,720.00,748.80,132.08,'2023-03-02 15:27:39'),(749,'1','311',1,'Retail Sale Id 809',0.00,1233.44,720.00,1497.60,264.16,'2023-03-02 15:27:39'),(750,'1','311',1,'Retail Sale Id 810',0.00,2965.00,720.00,3600.00,635.00,'2023-03-02 15:31:24'),(751,'1','311',1,'Retail Sale Id 823',0.00,1648.54,720.00,2001.60,353.06,'2023-03-02 16:49:59'),(752,'1','311',1,'Retail Sale Id 823',0.00,2389.79,720.00,2901.60,511.81,'2023-03-02 16:49:59'),(753,'1','311',1,'Retail Sale Id 823',0.00,3558.00,720.00,4320.00,762.00,'2023-03-02 16:49:59'),(754,'1','311',1,'Retail Sale Id 824',0.00,2965.00,720.00,3600.00,635.00,'2023-03-02 16:50:45'),(755,'1','311',1,'Retail Sale Id 826',0.00,616.72,720.00,748.80,132.08,'2023-03-02 16:53:58'),(756,'1','311',1,'Retail Sale Id 826',0.00,616.72,720.00,748.80,132.08,'2023-03-02 16:53:58'),(757,'1','311',1,'Retail Sale Id 826',0.00,2389.79,720.00,2901.60,511.81,'2023-03-02 16:53:58'),(758,'1','311',1,'Retail Sale Id 827',0.00,1233.44,720.00,1497.60,264.16,'2023-03-02 16:57:06'),(759,'1','311',1,'Retail Sale Id 828',0.00,1233.44,720.00,1497.60,264.16,'2023-03-02 17:00:35'),(760,'1','311',1,'Retail Sale Id 829',0.00,492.19,720.00,597.60,105.41,'2023-03-02 17:11:13'),(761,'1','311',1,'Retail Sale Id 831',0.00,2372.00,720.00,2880.00,508.00,'2023-03-02 17:18:45'),(762,'1','311',1,'Retail Sale Id 832',0.00,2372.00,720.00,2880.00,508.00,'2023-03-02 17:22:05'),(763,'1','311',1,'Retail Sale Id 833',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-02 17:32:01'),(764,'1','311',1,'Return of Retail Sale Id 833',7412.50,0.00,720.00,-9000.00,-1587.50,'2023-03-02 19:36:51'),(765,'1','311',1,'Return of Retail Sale Id 831',2372.00,0.00,720.00,-2880.00,-508.00,'2023-03-02 19:38:30'),(766,'1','311',1,'Return of Retail Sale Id 826',616.72,0.00,720.00,-748.80,-132.08,'2023-03-02 19:42:58'),(767,'1','311',1,'Return of Retail Sale Id 826',616.72,0.00,720.00,-748.80,-132.08,'2023-03-02 19:42:58'),(768,'1','311',1,'Return of Retail Sale Id 826',2389.79,0.00,720.00,-2901.60,-511.81,'2023-03-02 19:42:58'),(769,'1','311',1,'Return of Retail Sale Id 832',2372.00,0.00,720.00,-2880.00,-508.00,'2023-03-02 19:45:08'),(770,'1','311',1,'Return of Retail Sale Id 824',2965.00,0.00,720.00,-3600.00,-635.00,'2023-03-02 19:48:35'),(771,'1','311',1,'Retail Sale Id 834',0.00,2478.74,720.00,3009.60,530.86,'2023-03-02 19:49:36'),(772,'1','311',1,'Return of Retail Sale Id 829',492.19,0.00,720.00,-597.60,-105.41,'2023-03-02 19:52:46'),(773,'1','311',1,'Return of Retail Sale Id 828',1233.44,0.00,720.00,-1497.60,-264.16,'2023-03-02 19:53:29'),(774,'1','311',1,'Return of Retail Sale Id 827',1233.44,0.00,720.00,-1497.60,-264.16,'2023-03-02 19:56:12'),(775,'1','311',1,'Retail Sale Id 835',0.00,1761.21,720.00,2138.40,377.19,'2023-03-02 19:56:57'),(776,'1','311',1,'Retail Sale Id 836',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-02 20:00:03'),(777,'1','311',1,'Retail Sale Id 837',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-02 20:00:35'),(778,'1','311',1,'Retail Sale Id 838',0.00,2846.40,720.00,3456.00,609.60,'2023-03-02 20:01:25'),(779,'1','311',1,'Retail Sale Id 839',0.00,1779.00,720.00,2160.00,381.00,'2023-03-03 10:00:58'),(780,'1','311',1,'Retail Sale Id 840',0.00,1186.00,720.00,1440.00,254.00,'2023-03-03 10:05:44'),(781,'1','311',1,'Retail Sale Id 841',0.00,593.00,720.00,720.00,127.00,'2023-03-03 10:13:39'),(782,'1','311',1,'Retail Sale Id 843',0.00,1186.00,720.00,1440.00,254.00,'2023-03-03 10:34:45'),(783,'1','311',1,'Retail Sale Id 844',0.00,5930.00,720.00,7200.00,1270.00,'2023-03-03 10:52:44'),(784,'1','311',1,'Retail Sale Id 845',0.00,1233.44,720.00,1497.60,264.16,'2023-03-03 11:30:47'),(785,'1','311',1,'Retail Sale Id 846',0.00,3558.00,720.00,4320.00,762.00,'2023-03-03 11:36:33'),(786,'1','311',1,'Retail Sale Id 847',0.00,1779.00,720.00,2160.00,381.00,'2023-03-03 12:06:59'),(787,'1','311',1,'Retail Sale Id 848',0.00,2965.00,720.00,3600.00,635.00,'2023-03-03 12:08:32'),(788,'1','311',1,'Retail Sale Id 849',0.00,2965.00,720.00,3600.00,635.00,'2023-03-03 12:14:23'),(789,'1','311',1,'Retail Sale Id 849',0.00,3558.00,720.00,4320.00,762.00,'2023-03-03 12:14:23'),(790,'1','311',1,'Retail Sale Id 850',0.00,593.00,720.00,720.00,127.00,'2023-03-03 12:22:19'),(791,'1','311',1,'Retail Sale Id 851',0.00,1186.00,720.00,1440.00,254.00,'2023-03-03 12:26:37'),(792,'1','311',1,'Retail Sale Id 852',0.00,2965.00,720.00,3600.00,635.00,'2023-03-03 12:59:12'),(793,'1','311',1,'Retail Sale Id 853',0.00,2372.00,720.00,2880.00,508.00,'2023-03-03 13:14:08'),(794,'1','311',1,'Retail Sale Id 855',0.00,2965.00,720.00,3600.00,635.00,'2023-03-03 14:14:26'),(795,'1','311',1,'Retail Sale Id 856',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-03 14:21:04'),(796,'1','311',1,'Retail Sale Id 857',0.00,2372.00,720.00,2880.00,508.00,'2023-03-03 14:56:18'),(797,'1','311',1,'Retail Sale Id 858',0.00,2965.00,720.00,3600.00,635.00,'2023-03-03 15:08:33'),(798,'1','311',1,'Retail Sale Id 859',0.00,3558.00,720.00,4320.00,762.00,'2023-03-03 15:13:12'),(799,'1','311',1,'Retail Sale Id 860',0.00,3558.00,720.00,4320.00,762.00,'2023-03-03 15:22:59'),(800,'1','311',1,'Retail Sale Id 861',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-03 15:26:59'),(801,'1','311',1,'Retail Sale Id 862',0.00,1186.00,720.00,1440.00,254.00,'2023-03-03 15:28:54'),(802,'1','311',1,'Retail Sale Id 863',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-03 15:38:04'),(803,'1','311',1,'Retail Sale Id 864',0.00,2372.00,720.00,2880.00,508.00,'2023-03-03 15:38:50'),(804,'1','311',1,'Retail Sale Id 866',0.00,1779.00,720.00,2160.00,381.00,'2023-03-03 16:00:13'),(805,'1','311',1,'Retail Sale Id 867',0.00,3558.00,720.00,4320.00,762.00,'2023-03-03 16:01:07'),(806,'1','311',1,'Retail Sale Id 868',0.00,824.27,720.00,1000.80,176.53,'2023-03-03 16:34:33'),(807,'1','311',1,'Retail Sale Id 869',0.00,593.00,720.00,720.00,127.00,'2023-03-03 16:44:19'),(808,'1','311',1,'Retail Sale Id 870',0.00,3297.08,720.00,4003.20,706.12,'2023-03-03 16:48:39'),(809,'1','311',1,'Retail Sale Id 871',0.00,2372.00,720.00,2880.00,508.00,'2023-03-03 17:37:49'),(810,'1','311',1,'Retail Sale Id 871',0.00,2472.81,720.00,3002.40,529.59,'2023-03-03 17:37:49'),(811,'1','311',1,'Retail Sale Id 872',0.00,1779.00,720.00,2160.00,381.00,'2023-03-03 17:39:24'),(812,'1','311',1,'Retail Sale Id 872',0.00,1814.58,720.00,2203.20,388.62,'2023-03-03 17:39:24'),(813,'1','311',1,'Retail Sale Id 874',0.00,1814.58,720.00,2203.20,388.62,'2023-03-03 17:47:13'),(814,'1','311',1,'Retail Sale Id 875',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-03 17:54:46'),(815,'1','311',1,'Return of Retail Sale Id 869',593.00,0.00,720.00,-720.00,-127.00,'2023-03-03 18:11:17'),(816,'1','311',1,'Retail Sale Id 876',0.00,788.69,720.00,957.60,168.91,'2023-03-03 18:12:03'),(817,'1','311',1,'Return of Retail Sale Id 874',1814.58,0.00,720.00,-2203.20,-388.62,'2023-03-03 18:14:51'),(818,'1','311',1,'Retail Sale Id 877',0.00,1423.20,720.00,1728.00,304.80,'2023-03-03 18:18:35'),(819,'1','311',1,'Retail Sale Id 878',0.00,5930.00,720.00,7200.00,1270.00,'2023-03-04 16:51:57'),(820,'1','311',1,'Retail Sale Id 879',0.00,2372.00,720.00,2880.00,508.00,'2023-03-04 16:53:21'),(821,'1','311',1,'Retail Sale Id 880',0.00,1779.00,720.00,2160.00,381.00,'2023-03-04 16:54:01'),(822,'1','311',1,'Retail Sale Id 881',0.00,3558.00,720.00,4320.00,762.00,'2023-03-04 16:54:40'),(823,'1','311',1,'Retail Sale Id 882',0.00,2075.50,720.00,2520.00,444.50,'2023-03-04 16:55:24'),(824,'1','311',1,'Retail Sale Id 883',0.00,824.27,720.00,1000.80,176.53,'2023-03-04 16:56:10'),(825,'1','311',1,'Retail Sale Id 884',0.00,1779.00,720.00,2160.00,381.00,'2023-03-04 16:56:52'),(826,'1','311',1,'Retail Sale Id 885',0.00,3558.00,720.00,4320.00,762.00,'2023-03-04 16:57:29'),(827,'1','311',1,'Retail Sale Id 886',0.00,1648.54,720.00,2001.60,353.06,'2023-03-04 16:58:51'),(828,'1','311',1,'Retail Sale Id 887',0.00,824.27,720.00,1000.80,176.53,'2023-03-04 17:00:07'),(829,'1','311',1,'Retail Sale Id 888',0.00,4447.50,720.00,5400.00,952.50,'2023-03-04 17:01:30'),(830,'1','311',1,'Retail Sale Id 889',0.00,2965.00,720.00,3600.00,635.00,'2023-03-04 17:02:22'),(831,'1','311',1,'Retail Sale Id 890',0.00,2965.00,720.00,3600.00,635.00,'2023-03-04 17:04:31'),(832,'1','311',1,'Retail Sale Id 892',0.00,2965.00,720.00,3600.00,635.00,'2023-03-04 17:05:32'),(833,'1','311',1,'Retail Sale Id 893',0.00,2472.81,720.00,3002.40,529.59,'2023-03-04 17:06:25'),(834,'1','311',1,'Retail Sale Id 894',0.00,2057.71,720.00,2498.40,440.69,'2023-03-04 17:07:49'),(835,'1','311',1,'Retail Sale Id 895',0.00,492.19,720.00,597.60,105.41,'2023-03-04 17:08:53'),(836,'1','311',1,'Retail Sale Id 896',0.00,6523.00,720.00,7920.00,1397.00,'2023-03-04 17:09:33'),(837,'1','311',1,'Retail Sale Id 897',0.00,3558.00,720.00,4320.00,762.00,'2023-03-04 17:10:08'),(838,'1','311',1,'Retail Sale Id 898',0.00,3558.00,720.00,4320.00,762.00,'2023-03-04 17:11:07'),(839,'1','311',1,'Retail Sale Id 899',0.00,2965.00,720.00,3600.00,635.00,'2023-03-04 17:12:01'),(840,'1','311',1,'Retail Sale Id 900',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-04 17:14:58'),(841,'1','311',1,'Retail Sale Id 901',0.00,2965.00,720.00,3600.00,635.00,'2023-03-04 17:16:15'),(842,'1','311',1,'Retail Sale Id 903',0.00,1233.44,720.00,1497.60,264.16,'2023-03-04 17:18:35'),(843,'1','311',1,'Retail Sale Id 904',0.00,2472.81,720.00,3002.40,529.59,'2023-03-04 17:21:07'),(844,'1','311',1,'Retail Sale Id 904',0.00,2965.00,720.00,3600.00,635.00,'2023-03-04 17:21:07'),(845,'1','311',1,'Retail Sale Id 904',0.00,5930.00,720.00,7200.00,1270.00,'2023-03-04 17:21:07'),(846,'1','311',1,'Retail Sale Id 905',0.00,2965.00,720.00,3600.00,635.00,'2023-03-04 17:23:10'),(847,'1','311',1,'Retail Sale Id 906',0.00,2372.00,720.00,2880.00,508.00,'2023-03-04 17:24:30'),(848,'1','311',1,'Retail Sale Id 907',0.00,1186.00,720.00,1440.00,254.00,'2023-03-04 17:25:09'),(849,'1','311',1,'Retail Sale Id 908',0.00,1779.00,720.00,2160.00,381.00,'2023-03-04 17:26:22'),(850,'1','311',1,'Retail Sale Id 909',0.00,1648.54,720.00,2001.60,353.06,'2023-03-04 17:27:09'),(851,'1','311',1,'Retail Sale Id 910',0.00,824.27,720.00,1000.80,176.53,'2023-03-04 17:27:51'),(852,'1','311',1,'Retail Sale Id 911',0.00,824.27,720.00,1000.80,176.53,'2023-03-04 17:28:52'),(853,'1','311',1,'Retail Sale Id 912',0.00,4151.00,720.00,5040.00,889.00,'2023-03-04 17:29:49'),(854,'1','311',1,'Retail Sale Id 913',0.00,2472.81,720.00,3002.40,529.59,'2023-03-04 17:30:42'),(855,'1','311',1,'Retail Sale Id 914',0.00,5354.79,720.00,6501.60,1146.81,'2023-03-04 17:31:55'),(856,'1','311',1,'Retail Sale Id 915',0.00,4251.81,720.00,5162.40,910.59,'2023-03-04 17:32:41'),(857,'1','311',1,'Retail Sale Id 916',0.00,8895.00,720.00,10800.00,1905.00,'2023-03-04 17:35:01'),(858,'1','311',1,'Retail Sale Id 917',0.00,14825.00,720.00,18000.00,3175.00,'2023-03-04 17:36:00'),(859,'1','311',1,'Retail Sale Id 918',0.00,10377.50,720.00,12600.00,2222.50,'2023-03-04 17:36:57'),(860,'1','311',1,'Retail Sale Id 919',0.00,5354.79,720.00,6501.60,1146.81,'2023-03-04 17:37:41'),(861,'1','311',1,'Retail Sale Id 920',0.00,7709.00,720.00,9360.00,1651.00,'2023-03-04 17:38:17'),(862,'1','311',1,'Retail Sale Id 921',0.00,7370.99,720.00,8949.60,1578.61,'2023-03-04 17:39:02'),(863,'1','311',1,'Retail Sale Id 922',0.00,7116.00,720.00,8640.00,1524.00,'2023-03-04 17:39:38'),(864,'1','311',1,'Retail Sale Id 924',0.00,8355.37,720.00,10144.80,1789.43,'2023-03-04 17:41:49'),(865,'1','311',1,'Retail Sale Id 925',0.00,6054.53,720.00,7351.20,1296.67,'2023-03-04 17:42:26'),(866,'1','311',1,'Retail Sale Id 926',0.00,12049.76,720.00,14630.40,2580.64,'2023-03-04 17:43:32'),(867,'1','311',1,'Retail Sale Id 927',0.00,6523.00,720.00,7920.00,1397.00,'2023-03-04 17:50:03'),(868,'1','311',1,'Retail Sale Id 928',0.00,35580.00,680.00,40800.00,5220.00,'2023-03-04 18:04:28'),(869,'1','311',1,'Retail Sale Id 929',0.00,1186.00,720.00,1440.00,254.00,'2023-03-05 08:24:48'),(870,'1','311',1,'Retail Sale Id 930',0.00,1779.00,720.00,2160.00,381.00,'2023-03-05 08:26:08'),(871,'1','311',1,'Retail Sale Id 931',0.00,4151.00,720.00,5040.00,889.00,'2023-03-05 08:35:34'),(872,'1','311',1,'Retail Sale Id 932',0.00,1779.00,720.00,2160.00,381.00,'2023-03-05 08:43:53'),(873,'1','311',1,'Retail Sale Id 932',0.00,3558.00,720.00,4320.00,762.00,'2023-03-05 08:43:53'),(874,'1','311',1,'Return of Retail Sale Id 932',1779.00,0.00,720.00,-2160.00,-381.00,'2023-03-05 08:50:39'),(875,'1','311',1,'Return of Retail Sale Id 932',3558.00,0.00,720.00,-4320.00,-762.00,'2023-03-05 08:50:39'),(876,'1','311',1,'Retail Sale Id 934',0.00,1779.00,720.00,2160.00,381.00,'2023-03-05 08:52:13'),(877,'1','311',1,'Retail Sale Id 934',0.00,3558.00,720.00,4320.00,762.00,'2023-03-05 08:52:13'),(878,'1','311',1,'Retail Sale Id 935',0.00,1648.54,720.00,2001.60,353.06,'2023-03-05 08:56:59'),(879,'1','311',1,'Retail Sale Id 936',0.00,2372.00,720.00,2880.00,508.00,'2023-03-05 09:03:52'),(880,'1','311',1,'Retail Sale Id 937',0.00,1779.00,720.00,2160.00,381.00,'2023-03-05 09:11:17'),(881,'1','311',1,'Retail Sale Id 937',0.00,4151.00,720.00,5040.00,889.00,'2023-03-05 09:11:17'),(882,'1','311',1,'Retail Sale Id 938',0.00,1648.54,720.00,2001.60,353.06,'2023-03-05 09:18:00'),(883,'1','311',1,'Retail Sale Id 939',0.00,2389.79,720.00,2901.60,511.81,'2023-03-05 09:37:25'),(884,'1','311',1,'Retail Sale Id 940',0.00,1779.00,720.00,2160.00,381.00,'2023-03-05 09:48:02'),(885,'1','311',1,'Retail Sale Id 940',0.00,3558.00,720.00,4320.00,762.00,'2023-03-05 09:48:02'),(886,'1','311',1,'Retail Sale Id 941',0.00,4151.00,720.00,5040.00,889.00,'2023-03-05 10:09:52'),(887,'1','311',1,'Retail Sale Id 942',0.00,1186.00,720.00,1440.00,254.00,'2023-03-05 10:52:42'),(888,'1','311',1,'Retail Sale Id 944',0.00,2057.71,720.00,2498.40,440.69,'2023-03-05 11:02:31'),(889,'1','311',1,'Retail Sale Id 943',0.00,2372.00,720.00,2880.00,508.00,'2023-03-05 11:03:25'),(890,'1','311',1,'Retail Sale Id 945',0.00,1186.00,720.00,1440.00,254.00,'2023-03-05 11:04:46'),(891,'1','311',1,'Retail Sale Id 946',0.00,593.00,720.00,720.00,127.00,'2023-03-05 11:11:36'),(892,'1','311',1,'Retail Sale Id 947',0.00,2965.00,720.00,3600.00,635.00,'2023-03-05 11:21:41'),(893,'1','311',1,'Retail Sale Id 949',0.00,593.00,720.00,720.00,127.00,'2023-03-05 11:25:18'),(894,'1','311',1,'Retail Sale Id 950',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-05 11:54:30'),(895,'1','311',1,'Retail Sale Id 951',0.00,2965.00,720.00,3600.00,635.00,'2023-03-05 12:00:10'),(896,'1','311',1,'Retail Sale Id 952',0.00,3558.00,720.00,4320.00,762.00,'2023-03-05 12:26:17'),(897,'1','311',1,'Retail Sale Id 953',0.00,3558.00,720.00,4320.00,762.00,'2023-03-05 12:45:02'),(898,'1','311',1,'Retail Sale Id 954',0.00,3558.00,720.00,4320.00,762.00,'2023-03-05 12:46:45'),(899,'1','311',1,'Retail Sale Id 955',0.00,1779.00,720.00,2160.00,381.00,'2023-03-05 13:08:17'),(900,'1','311',1,'Retail Sale Id 956',0.00,824.27,720.00,1000.80,176.53,'2023-03-05 13:09:19'),(901,'1','311',1,'Retail Sale Id 957',0.00,1779.00,720.00,2160.00,381.00,'2023-03-05 13:21:46'),(902,'1','311',1,'Retail Sale Id 958',0.00,4151.00,720.00,5040.00,889.00,'2023-03-05 13:48:49'),(903,'1','311',1,'Retail Sale Id 959',0.00,1186.00,720.00,1440.00,254.00,'2023-03-05 13:57:50'),(904,'1','311',1,'Retail Sale Id 959',0.00,3558.00,720.00,4320.00,762.00,'2023-03-05 13:57:50'),(905,'1','311',1,'Retail Sale Id 960',0.00,1779.00,720.00,2160.00,381.00,'2023-03-05 14:00:17'),(906,'1','311',1,'Retail Sale Id 961',0.00,4151.00,720.00,5040.00,889.00,'2023-03-05 14:09:30'),(907,'1','311',1,'Retail Sale Id 962',0.00,1233.44,720.00,1497.60,264.16,'2023-03-05 14:10:19'),(908,'1','311',1,'Retail Sale Id 963',0.00,4151.00,720.00,5040.00,889.00,'2023-03-05 14:23:38'),(909,'1','311',1,'Retail Sale Id 964',0.00,1779.00,720.00,2160.00,381.00,'2023-03-05 14:38:04'),(910,'1','311',1,'Retail Sale Id 965',0.00,593.00,720.00,720.00,127.00,'2023-03-05 14:41:24'),(911,'1','311',1,'Retail Sale Id 966',0.00,4151.00,720.00,5040.00,889.00,'2023-03-05 15:01:19'),(912,'1','311',1,'Retail Sale Id 967',0.00,5337.00,720.00,6480.00,1143.00,'2023-03-05 15:07:02'),(913,'1','311',1,'Retail Sale Id 968',0.00,4151.00,720.00,5040.00,889.00,'2023-03-05 15:08:37'),(914,'1','311',1,'Retail Sale Id 969',0.00,2965.00,720.00,3600.00,635.00,'2023-03-05 15:14:42'),(915,'1','311',1,'Retail Sale Id 970',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-05 15:15:51'),(916,'1','311',1,'Retail Sale Id 971',0.00,824.27,720.00,1000.80,176.53,'2023-03-05 15:18:17'),(917,'1','311',1,'Retail Sale Id 971',0.00,1233.44,720.00,1497.60,264.16,'2023-03-05 15:18:17'),(918,'1','311',1,'Retail Sale Id 972',0.00,1779.00,720.00,2160.00,381.00,'2023-03-05 15:19:28'),(919,'1','311',1,'Retail Sale Id 974',0.00,2372.00,720.00,2880.00,508.00,'2023-03-05 15:23:54'),(920,'1','311',1,'Retail Sale Id 975',0.00,3955.31,720.00,4802.40,847.09,'2023-03-05 15:26:02'),(921,'1','311',1,'Retail Sale Id 973',0.00,1779.00,720.00,2160.00,381.00,'2023-03-05 15:27:27'),(922,'1','311',1,'Return of Retail Sale Id 975',3955.31,0.00,720.00,-4802.40,-847.09,'2023-03-05 15:31:04'),(923,'1','311',1,'Retail Sale Id 976',0.00,3131.04,720.00,3801.60,670.56,'2023-03-05 15:33:54'),(924,'1','311',1,'Retail Sale Id 977',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-05 15:41:26'),(925,'1','311',1,'Retail Sale Id 978',0.00,1482.50,720.00,1800.00,317.50,'2023-03-05 15:42:29'),(926,'1','311',1,'Retail Sale Id 979',0.00,824.27,720.00,1000.80,176.53,'2023-03-05 15:47:48'),(927,'1','311',1,'Retail Sale Id 980',0.00,2965.00,720.00,3600.00,635.00,'2023-03-05 16:08:33'),(928,'1','311',1,'Retail Sale Id 981',0.00,4115.42,720.00,4996.80,881.38,'2023-03-05 16:09:37'),(929,'1','311',1,'Retail Sale Id 982',0.00,4151.00,720.00,5040.00,889.00,'2023-03-05 16:11:07'),(930,'1','311',1,'Retail Sale Id 983',0.00,2472.81,720.00,3002.40,529.59,'2023-03-05 16:17:38'),(931,'1','311',1,'Retail Sale Id 984',0.00,4151.00,720.00,5040.00,889.00,'2023-03-05 16:37:06'),(932,'1','311',1,'Retail Sale Id 985',0.00,1482.50,720.00,1800.00,317.50,'2023-03-05 16:41:36'),(933,'1','311',1,'Retail Sale Id 986',0.00,1648.54,720.00,2001.60,353.06,'2023-03-05 16:52:35'),(934,'1','311',1,'Retail Sale Id 987',0.00,1779.00,720.00,2160.00,381.00,'2023-03-05 16:54:32'),(935,'1','311',1,'Retail Sale Id 988',0.00,2472.81,720.00,3002.40,529.59,'2023-03-05 16:57:08'),(936,'1','311',1,'Retail Sale Id 989',0.00,1779.00,720.00,2160.00,381.00,'2023-03-05 16:58:38'),(937,'1','311',1,'Retail Sale Id 990',0.00,3558.00,720.00,4320.00,762.00,'2023-03-05 17:10:44'),(938,'1','311',1,'Retail Sale Id 991',0.00,3558.00,720.00,4320.00,762.00,'2023-03-05 17:11:31'),(939,'1','311',1,'Retail Sale Id 992',0.00,2965.00,720.00,3600.00,635.00,'2023-03-05 17:12:42'),(940,'1','311',1,'Retail Sale Id 993',0.00,4151.00,720.00,5040.00,889.00,'2023-03-05 17:19:37'),(941,'1','311',1,'Retail Sale Id 994',0.00,1233.44,720.00,1497.60,264.16,'2023-03-05 17:26:24'),(942,'1','311',1,'Retail Sale Id 995',0.00,5337.00,720.00,6480.00,1143.00,'2023-03-05 17:28:53'),(943,'1','311',1,'Retail Sale Id 996',0.00,622.65,720.00,756.00,133.35,'2023-03-05 17:50:28'),(944,'1','311',1,'Retail Sale Id 997',0.00,1784.93,720.00,2167.20,382.27,'2023-03-05 18:07:51'),(945,'1','311',1,'Retail Sale Id 998',0.00,2372.00,720.00,2880.00,508.00,'2023-03-07 08:17:30'),(946,'1','311',1,'Retail Sale Id 999',0.00,1648.54,720.00,2001.60,353.06,'2023-03-07 08:18:34'),(947,'1','311',1,'Retail Sale Id 1000',0.00,824.27,720.00,1000.80,176.53,'2023-03-07 08:19:39'),(948,'1','311',1,'Retail Sale Id 1001',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-07 08:20:26'),(949,'1','311',1,'Retail Sale Id 1002',0.00,4151.00,720.00,5040.00,889.00,'2023-03-07 08:21:37'),(950,'1','311',1,'Retail Sale Id 1003',0.00,2372.00,720.00,2880.00,508.00,'2023-03-07 08:24:23'),(951,'1','311',1,'Retail Sale Id 1004',0.00,3558.00,720.00,4320.00,762.00,'2023-03-07 08:29:33'),(952,'1','311',1,'Retail Sale Id 1005',0.00,2372.00,720.00,2880.00,508.00,'2023-03-07 08:30:45'),(953,'1','311',1,'Retail Sale Id 1006',0.00,3558.00,720.00,4320.00,762.00,'2023-03-07 08:32:15'),(954,'1','311',1,'Retail Sale Id 1007',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-07 08:56:20'),(955,'1','311',1,'Retail Sale Id 1008',0.00,1186.00,720.00,1440.00,254.00,'2023-03-07 08:58:05'),(956,'1','311',1,'Retail Sale Id 1008',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-07 08:58:05'),(957,'1','311',1,'Retail Sale Id 1009',0.00,2472.81,720.00,3002.40,529.59,'2023-03-07 08:59:28'),(958,'1','311',1,'Retail Sale Id 1011',0.00,1233.44,720.00,1497.60,264.16,'2023-03-07 09:06:49'),(959,'1','311',1,'Retail Sale Id 1012',0.00,1186.00,720.00,1440.00,254.00,'2023-03-07 09:22:36'),(960,'1','311',1,'Retail Sale Id 1013',0.00,1186.00,720.00,1440.00,254.00,'2023-03-07 09:30:54'),(961,'1','311',1,'Retail Sale Id 1013',0.00,1186.00,720.00,1440.00,254.00,'2023-03-07 09:30:54'),(962,'1','311',1,'Retail Sale Id 1013',0.00,2965.00,720.00,3600.00,635.00,'2023-03-07 09:30:54'),(963,'1','311',1,'Retail Sale Id 1014',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-07 09:32:13'),(964,'1','311',1,'Retail Sale Id 1015',0.00,1779.00,720.00,2160.00,381.00,'2023-03-07 09:39:53'),(965,'1','311',1,'Return of Retail Sale Id 1015',1779.00,0.00,720.00,-2160.00,-381.00,'2023-03-07 09:45:23'),(966,'1','311',1,'Retail Sale Id 1016',0.00,1779.00,720.00,2160.00,381.00,'2023-03-07 09:46:48'),(967,'1','311',1,'Retail Sale Id 1017',0.00,3854.50,720.00,4680.00,825.50,'2023-03-07 09:53:41'),(968,'1','311',1,'Retail Sale Id 1019',0.00,824.27,720.00,1000.80,176.53,'2023-03-07 10:17:38'),(969,'1','311',1,'Retail Sale Id 1020',0.00,3854.50,720.00,4680.00,825.50,'2023-03-07 10:19:46'),(970,'1','311',1,'Retail Sale Id 1021',0.00,3558.00,720.00,4320.00,762.00,'2023-03-07 10:23:58'),(971,'1','311',1,'Retail Sale Id 1022',0.00,1150.42,720.00,1396.80,246.38,'2023-03-07 10:27:47'),(972,'1','311',1,'Retail Sale Id 1024',0.00,4151.00,720.00,5040.00,889.00,'2023-03-07 10:36:51'),(973,'1','311',1,'Retail Sale Id 1018',0.00,3558.00,720.00,4320.00,762.00,'2023-03-07 10:56:35'),(974,'1','311',1,'Retail Sale Id 1026',0.00,1779.00,720.00,2160.00,381.00,'2023-03-07 11:16:24'),(975,'1','311',1,'Retail Sale Id 1027',0.00,118600.00,680.00,136000.00,17400.00,'2023-03-07 12:03:18'),(976,'1','311',1,'Retail Sale Id 1028',0.00,1779.00,720.00,2160.00,381.00,'2023-03-07 12:07:03'),(977,'1','311',1,'Retail Sale Id 1029',0.00,2057.71,720.00,2498.40,440.69,'2023-03-07 12:10:04'),(978,'1','311',1,'Retail Sale Id 1030',0.00,889.50,720.00,1080.00,190.50,'2023-03-07 12:11:46'),(979,'1','311',1,'Retail Sale Id 1031',0.00,3558.00,720.00,4320.00,762.00,'2023-03-07 12:15:55'),(980,'1','311',1,'Retail Sale Id 1032',0.00,4151.00,720.00,5040.00,889.00,'2023-03-07 12:17:06'),(981,'1','311',1,'Retail Sale Id 1033',0.00,3558.00,720.00,4320.00,762.00,'2023-03-07 12:17:59'),(982,'1','311',1,'Retail Sale Id 1034',0.00,3558.00,720.00,4320.00,762.00,'2023-03-07 12:18:48'),(983,'1','311',1,'Return of Retail Sale Id 1030',889.50,0.00,720.00,-1080.00,-190.50,'2023-03-07 12:19:24'),(984,'1','311',1,'Retail Sale Id 1035',0.00,889.50,720.00,1080.00,190.50,'2023-03-07 12:20:19'),(985,'1','311',1,'Retail Sale Id 1036',0.00,474400.00,680.00,544000.00,69600.00,'2023-03-07 12:31:41'),(986,'1','311',1,'Retail Sale Id 1037',0.00,1186.00,720.00,1440.00,254.00,'2023-03-07 13:05:38'),(987,'1','311',1,'Retail Sale Id 1038',0.00,74996.71,680.00,85999.60,11002.89,'2023-03-07 13:07:41'),(988,'1','311',1,'Retail Sale Id 1039',0.00,2965.00,720.00,3600.00,635.00,'2023-03-07 13:13:54'),(989,'1','311',1,'Return of Retail Sale Id 1038',74996.71,0.00,680.00,-85999.60,-11002.89,'2023-03-07 13:18:03'),(990,'1','311',1,'Retail Sale Id 1040',0.00,74125.00,680.00,85000.00,10875.00,'2023-03-07 13:19:07'),(991,'1','311',1,'Retail Sale Id 1041',0.00,1186.00,720.00,1440.00,254.00,'2023-03-07 13:48:53'),(992,'1','311',1,'Return of Retail Sale Id 1041',1186.00,0.00,720.00,-1440.00,-254.00,'2023-03-07 13:53:24'),(993,'1','311',1,'Retail Sale Id 1042',0.00,1648.54,720.00,2001.60,353.06,'2023-03-07 13:54:16'),(994,'1','311',1,'Retail Sale Id 1043',0.00,1648.54,720.00,2001.60,353.06,'2023-03-07 14:17:27'),(995,'1','311',1,'Retail Sale Id 1044',0.00,7163.44,720.00,8697.60,1534.16,'2023-03-07 14:37:35'),(996,'1','311',1,'Retail Sale Id 1045',0.00,1186.00,720.00,1440.00,254.00,'2023-03-07 14:38:32'),(997,'1','311',1,'Retail Sale Id 1046',0.00,2965.00,720.00,3600.00,635.00,'2023-03-07 14:48:53'),(998,'1','311',1,'Retail Sale Id 1047',0.00,2472.81,720.00,3002.40,529.59,'2023-03-07 15:00:17'),(999,'1','311',1,'Retail Sale Id 1048',0.00,2306.77,720.00,2800.80,494.03,'2023-03-07 15:46:48'),(1000,'1','311',1,'Retail Sale Id 1054',0.00,2472.81,720.00,3002.40,529.59,'2023-03-07 15:50:20'),(1001,'1','311',1,'Retail Sale Id 1055',0.00,2472.81,720.00,3002.40,529.59,'2023-03-07 15:51:13'),(1002,'1','311',1,'Retail Sale Id 1056',0.00,2472.81,720.00,3002.40,529.59,'2023-03-07 15:56:45'),(1003,'1','311',1,'Retail Sale Id 1057',0.00,1648.54,720.00,2001.60,353.06,'2023-03-07 16:03:34'),(1004,'1','311',1,'Retail Sale Id 1058',0.00,5930.00,720.00,7200.00,1270.00,'2023-03-07 16:05:02'),(1005,'1','311',1,'Retail Sale Id 1059',0.00,71160.00,680.00,81600.00,10440.00,'2023-03-07 16:11:20'),(1006,'1','311',1,'Retail Sale Id 1060',0.00,1779.00,720.00,2160.00,381.00,'2023-03-07 16:15:00'),(1007,'1','311',1,'Retail Sale Id 1061',0.00,5930.00,720.00,7200.00,1270.00,'2023-03-07 16:15:53'),(1008,'1','311',1,'Retail Sale Id 1062',0.00,1779.00,720.00,2160.00,381.00,'2023-03-07 16:16:51'),(1009,'1','311',1,'Retail Sale Id 1063',0.00,1186.00,720.00,1440.00,254.00,'2023-03-07 16:18:10'),(1010,'1','311',1,'Retail Sale Id 1063',0.00,1779.00,720.00,2160.00,381.00,'2023-03-07 16:18:10'),(1011,'1','311',1,'Return of Retail Sale Id 1058',5930.00,0.00,720.00,-7200.00,-1270.00,'2023-03-07 16:20:29'),(1012,'1','311',1,'Retail Sale Id 1065',0.00,593.00,720.00,720.00,127.00,'2023-03-07 16:29:34'),(1013,'1','311',1,'Retail Sale Id 1066',0.00,3297.08,720.00,4003.20,706.12,'2023-03-07 16:35:38'),(1014,'1','311',1,'Retail Sale Id 1067',0.00,1233.44,720.00,1497.60,264.16,'2023-03-07 16:37:19'),(1015,'1','311',1,'Return of Retail Sale Id 1067',1233.44,0.00,720.00,-1497.60,-264.16,'2023-03-07 16:38:26'),(1016,'1','311',1,'Retail Sale Id 1068',0.00,1150.42,720.00,1396.80,246.38,'2023-03-07 16:38:59'),(1017,'1','311',1,'Retail Sale Id 1070',0.00,1779.00,720.00,2160.00,381.00,'2023-03-07 16:45:58'),(1018,'1','311',1,'Retail Sale Id 1071',0.00,2472.81,720.00,3002.40,529.59,'2023-03-07 16:47:33'),(1019,'1','311',1,'Retail Sale Id 1072',0.00,2075.50,720.00,2520.00,444.50,'2023-03-07 16:48:37'),(1020,'1','311',1,'Retail Sale Id 1073',0.00,2472.81,720.00,3002.40,529.59,'2023-03-07 16:49:23'),(1021,'1','311',1,'Retail Sale Id 1074',0.00,1779.00,720.00,2160.00,381.00,'2023-03-07 16:50:44'),(1022,'1','311',1,'Retail Sale Id 1075',0.00,2965.00,720.00,3600.00,635.00,'2023-03-07 16:59:17'),(1023,'1','311',1,'Retail Sale Id 1076',0.00,1648.54,720.00,2001.60,353.06,'2023-03-07 17:00:28'),(1024,'1','311',1,'Retail Sale Id 1077',0.00,1779.00,720.00,2160.00,381.00,'2023-03-07 17:02:03'),(1025,'1','311',1,'Retail Sale Id 1078',0.00,2372.00,720.00,2880.00,508.00,'2023-03-07 17:04:08'),(1026,'1','311',1,'Retail Sale Id 1080',0.00,2965.00,720.00,3600.00,635.00,'2023-03-07 17:05:43'),(1027,'1','311',1,'Retail Sale Id 1081',0.00,2965.00,720.00,3600.00,635.00,'2023-03-07 17:06:39'),(1028,'1','311',1,'Retail Sale Id 1082',0.00,2965.00,720.00,3600.00,635.00,'2023-03-07 17:07:35'),(1029,'1','311',1,'Retail Sale Id 1084',0.00,1186.00,720.00,1440.00,254.00,'2023-03-07 17:11:53'),(1030,'1','311',1,'Retail Sale Id 1085',0.00,3558.00,720.00,4320.00,762.00,'2023-03-07 17:13:43'),(1031,'1','311',1,'Retail Sale Id 1086',0.00,1186.00,720.00,1440.00,254.00,'2023-03-07 17:14:40'),(1032,'1','311',1,'Retail Sale Id 1087',0.00,5930.00,720.00,7200.00,1270.00,'2023-03-07 17:15:25'),(1033,'1','311',1,'Return of Retail Sale Id 1072',2075.50,0.00,720.00,-2520.00,-444.50,'2023-03-07 17:19:40'),(1034,'1','311',1,'Retail Sale Id 1089',0.00,1779.00,720.00,2160.00,381.00,'2023-03-07 17:21:05'),(1035,'1','311',1,'Retail Sale Id 1089',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-07 17:21:05'),(1036,'1','311',1,'Retail Sale Id 1090',0.00,2372.00,720.00,2880.00,508.00,'2023-03-07 17:22:14'),(1037,'1','311',1,'Retail Sale Id 1092',0.00,3558.00,720.00,4320.00,762.00,'2023-03-07 17:31:08'),(1038,'1','311',1,'Retail Sale Id 1093',0.00,1779.00,720.00,2160.00,381.00,'2023-03-07 17:34:58'),(1039,'1','311',1,'Retail Sale Id 1094',0.00,1779.00,720.00,2160.00,381.00,'2023-03-07 17:36:31'),(1040,'1','311',1,'Retail Sale Id 1095',0.00,1186.00,720.00,1440.00,254.00,'2023-03-07 17:38:38'),(1041,'1','311',1,'Retail Sale Id 1096',0.00,593.00,720.00,720.00,127.00,'2023-03-07 20:08:21'),(1042,'1','311',1,'Return of Retail Sale Id 1096',593.00,0.00,720.00,-720.00,-127.00,'2023-03-07 20:10:36'),(1043,'1','311',1,'Retail Sale Id 1097',0.00,693.81,720.00,842.40,148.59,'2023-03-07 20:12:08'),(1044,'1','311',1,'Retail Sale Id 1098',0.00,3558.00,720.00,4320.00,762.00,'2023-03-08 10:53:29'),(1045,'1','311',1,'Retail Sale Id 1099',0.00,1814.58,720.00,2203.20,388.62,'2023-03-08 11:02:21'),(1046,'1','311',1,'Retail Sale Id 1101',0.00,1648.54,720.00,2001.60,353.06,'2023-03-08 11:26:40'),(1047,'1','311',1,'Retail Sale Id 1103',0.00,2372.00,720.00,2880.00,508.00,'2023-03-08 11:28:51'),(1048,'1','311',1,'Retail Sale Id 1104',0.00,5930.00,720.00,7200.00,1270.00,'2023-03-08 11:37:06'),(1049,'1','311',1,'Retail Sale Id 1104',0.00,5930.00,720.00,7200.00,1270.00,'2023-03-08 11:37:06'),(1050,'1','311',1,'Retail Sale Id 1102',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-08 11:38:17'),(1051,'1','311',1,'Retail Sale Id 1105',0.00,1779.00,720.00,2160.00,381.00,'2023-03-08 11:56:54'),(1052,'1','311',1,'Retail Sale Id 1106',0.00,2965.00,720.00,3600.00,635.00,'2023-03-08 11:59:01'),(1053,'1','311',1,'Retail Sale Id 1107',0.00,2472.81,720.00,3002.40,529.59,'2023-03-08 12:29:48'),(1054,'1','311',1,'Retail Sale Id 1108',0.00,2472.81,720.00,3002.40,529.59,'2023-03-08 12:46:23'),(1055,'1','311',1,'Retail Sale Id 1109',0.00,3297.08,720.00,4003.20,706.12,'2023-03-08 13:00:15'),(1056,'1','311',1,'Retail Sale Id 1110',0.00,3558.00,720.00,4320.00,762.00,'2023-03-08 13:07:43'),(1057,'1','311',1,'Retail Sale Id 1111',0.00,2965.00,720.00,3600.00,635.00,'2023-03-08 13:12:42'),(1058,'1','311',1,'Retail Sale Id 1113',0.00,2372.00,720.00,2880.00,508.00,'2023-03-08 13:15:46'),(1059,'1','311',1,'Retail Sale Id 1114',0.00,1779.00,720.00,2160.00,381.00,'2023-03-08 13:22:51'),(1060,'1','311',1,'Retail Sale Id 1115',0.00,3297.08,720.00,4003.20,706.12,'2023-03-08 13:48:19'),(1061,'1','311',1,'Retail Sale Id 1116',0.00,593.00,720.00,720.00,127.00,'2023-03-08 13:49:43'),(1062,'1','311',1,'Retail Sale Id 1117',0.00,2965.00,720.00,3600.00,635.00,'2023-03-08 13:54:40'),(1063,'1','311',1,'Retail Sale Id 1118',0.00,2372.00,720.00,2880.00,508.00,'2023-03-08 14:12:17'),(1064,'1','311',1,'Return of Retail Sale Id 1118',2372.00,0.00,720.00,-2880.00,-508.00,'2023-03-08 14:14:36'),(1065,'1','311',1,'Retail Sale Id 1119',0.00,1186.00,720.00,1440.00,254.00,'2023-03-08 14:15:17'),(1066,'1','311',1,'Retail Sale Id 1120',0.00,10424.94,720.00,12657.60,2232.66,'2023-03-08 14:16:33'),(1067,'1','311',1,'Retail Sale Id 1121',0.00,1779.00,720.00,2160.00,381.00,'2023-03-08 14:18:47'),(1068,'1','311',1,'Retail Sale Id 1122',0.00,20755.00,720.00,25200.00,4445.00,'2023-03-08 14:21:56'),(1069,'1','311',1,'Retail Sale Id 1123',0.00,4151.00,720.00,5040.00,889.00,'2023-03-08 14:24:17'),(1070,'1','311',1,'Retail Sale Id 1124',0.00,5953.72,720.00,7228.80,1275.08,'2023-03-08 14:27:13'),(1071,'1','311',1,'Retail Sale Id 1125',0.00,4744.00,720.00,5760.00,1016.00,'2023-03-08 14:29:42'),(1072,'1','311',1,'Retail Sale Id 1126',0.00,5354.79,720.00,6501.60,1146.81,'2023-03-08 14:32:04'),(1073,'1','311',1,'Retail Sale Id 1127',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-08 14:35:12'),(1074,'1','311',1,'Retail Sale Id 1127',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-08 14:35:12'),(1075,'1','311',1,'Retail Sale Id 1128',0.00,2965.00,720.00,3600.00,635.00,'2023-03-08 14:37:52'),(1076,'1','311',1,'Retail Sale Id 1128',0.00,8895.00,720.00,10800.00,1905.00,'2023-03-08 14:37:52'),(1077,'1','311',1,'Retail Sale Id 1130',0.00,1186.00,720.00,1440.00,254.00,'2023-03-08 15:08:06'),(1078,'1','311',1,'Retail Sale Id 1131',0.00,7412.50,720.00,9000.00,1587.50,'2023-03-08 15:10:34'),(1079,'1','311',1,'Retail Sale Id 1132',0.00,1233.44,720.00,1497.60,264.16,'2023-03-08 15:37:08'),(1080,'1','311',1,'Retail Sale Id 1133',0.00,1779.00,720.00,2160.00,381.00,'2023-03-08 15:38:41'),(1081,'1','311',1,'Retail Sale Id 1134',0.00,1233.44,720.00,1497.60,264.16,'2023-03-08 15:40:59'),(1082,'1','311',1,'Retail Sale Id 1135',0.00,1779.00,720.00,2160.00,381.00,'2023-03-08 15:41:55'),(1083,'1','311',1,'Retail Sale Id 1136',0.00,1233.44,720.00,1497.60,264.16,'2023-03-08 15:53:24'),(1084,'1','311',1,'Retail Sale Id 1137',0.00,3558.00,720.00,4320.00,762.00,'2023-03-08 16:04:37'),(1085,'1','311',1,'Retail Sale Id 1138',0.00,1779.00,720.00,2160.00,381.00,'2023-03-08 16:11:02'),(1086,'1','311',1,'Retail Sale Id 1139',0.00,1186.00,720.00,1440.00,254.00,'2023-03-08 16:29:05'),(1087,'1','311',1,'Retail Sale Id 1140',0.00,7116.00,720.00,8640.00,1524.00,'2023-03-08 16:39:51'),(1088,'1','311',1,'Retail Sale Id 1141',0.00,2965.00,720.00,3600.00,635.00,'2023-03-08 16:43:43'),(1089,'1','311',1,'Retail Sale Id 1142',0.00,3558.00,720.00,4320.00,762.00,'2023-03-08 16:44:47'),(1090,'1','311',1,'Retail Sale Id 1143',0.00,1779.00,720.00,2160.00,381.00,'2023-03-08 16:45:43'),(1091,'1','311',1,'Retail Sale Id 1144',0.00,2472.81,720.00,3002.40,529.59,'2023-03-08 16:46:43'),(1092,'1','311',1,'Retail Sale Id 1146',0.00,1891.67,720.00,2296.80,405.13,'2023-03-08 16:49:34'),(1093,'1','311',1,'Retail Sale Id 1147',0.00,1779.00,720.00,2160.00,381.00,'2023-03-08 16:55:18'),(1094,'1','311',1,'Retail Sale Id 1148',0.00,593.00,720.00,720.00,127.00,'2023-03-08 16:57:55'),(1095,'1','311',1,'Retail Sale Id 1149',0.00,1648.54,720.00,2001.60,353.06,'2023-03-08 16:59:14'),(1096,'1','311',1,'Retail Sale Id 1150',0.00,824.27,720.00,1000.80,176.53,'2023-03-08 17:01:00'),(1097,'1','311',1,'Retail Sale Id 1152',0.00,824.27,720.00,1000.80,176.53,'2023-03-08 17:06:18'),(1098,'1','311',1,'Retail Sale Id 1153',0.00,4151.00,720.00,5040.00,889.00,'2023-03-08 17:10:03'),(1099,'1','311',1,'Return of Retail Sale Id 1104',5930.00,0.00,720.00,-7200.00,-1270.00,'2023-03-08 17:35:04'),(1100,'1','311',1,'Return of Retail Sale Id 1104',5930.00,0.00,720.00,-7200.00,-1270.00,'2023-03-08 17:35:04'),(1101,'1','311',1,'Retail Sale Id 1154',0.00,8302.00,720.00,10080.00,1778.00,'2023-03-08 17:35:54'),(1102,'1','311',1,'Retail Sale Id 1155',0.00,3558.00,720.00,4320.00,762.00,'2023-03-08 17:36:39'),(1103,'1','311',1,'Retail Sale Id 1156',0.00,3006.51,690.00,3498.30,491.79,'2023-03-09 09:16:38'),(1104,'1','311',1,'Retail Sale Id 1158',0.00,3558.00,690.00,4140.00,582.00,'2023-03-09 09:18:55'),(1105,'1','311',1,'Retail Sale Id 1159',0.00,2965.00,690.00,3450.00,485.00,'2023-03-09 09:20:31'),(1106,'1','311',1,'Retail Sale Id 1160',0.00,1648.54,690.00,1918.20,269.66,'2023-03-09 09:23:24'),(1107,'1','311',1,'Retail Sale Id 1161',0.00,1779.00,690.00,2070.00,291.00,'2023-03-09 09:24:34'),(1108,'1','311',1,'Retail Sale Id 1162',0.00,4151.00,690.00,4830.00,679.00,'2023-03-09 09:25:26'),(1109,'1','311',1,'Retail Sale Id 1163',0.00,2466.88,690.00,2870.40,403.52,'2023-03-09 09:26:58'),(1110,'1','311',1,'Retail Sale Id 1164',0.00,1186.00,690.00,1380.00,194.00,'2023-03-09 09:27:44'),(1111,'1','311',1,'Retail Sale Id 1165',0.00,1642.61,690.00,1911.30,268.69,'2023-03-09 09:29:12'),(1112,'1','311',1,'Retail Sale Id 1166',0.00,3558.00,690.00,4140.00,582.00,'2023-03-09 09:31:07'),(1113,'1','311',1,'Retail Sale Id 1167',0.00,3558.00,690.00,4140.00,582.00,'2023-03-09 09:32:07'),(1114,'1','311',1,'Retail Sale Id 1168',0.00,2372.00,690.00,2760.00,388.00,'2023-03-09 09:32:57'),(1115,'1','311',1,'Retail Sale Id 1169',0.00,2057.71,690.00,2394.30,336.59,'2023-03-09 09:34:25'),(1116,'1','311',1,'Retail Sale Id 1170',0.00,3558.00,690.00,4140.00,582.00,'2023-03-09 09:35:45'),(1117,'1','311',1,'Retail Sale Id 1171',0.00,5930.00,690.00,6900.00,970.00,'2023-03-09 09:36:39'),(1118,'1','311',1,'Retail Sale Id 1172',0.00,2466.88,690.00,2870.40,403.52,'2023-03-09 09:37:57'),(1119,'1','311',1,'Retail Sale Id 1173',0.00,1779.00,690.00,2070.00,291.00,'2023-03-09 09:39:35'),(1120,'1','311',1,'Return of Retail Sale Id 1163',2466.88,0.00,690.00,-2870.40,-403.52,'2023-03-09 14:21:40'),(1121,'1','311',1,'Return of Retail Sale Id 1172',2466.88,0.00,690.00,-2870.40,-403.52,'2023-03-09 14:22:48'),(1122,'1','311',1,'Return of Retail Sale Id 1169',2057.71,0.00,690.00,-2394.30,-336.59,'2023-03-09 14:24:39'),(1123,'1','311',1,'Return of Retail Sale Id 1165',1642.61,0.00,690.00,-1911.30,-268.69,'2023-03-09 14:25:25'),(1124,'1','311',1,'Retail Sale Id 1174',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-09 14:28:43'),(1125,'1','311',1,'Retail Sale Id 1175',0.00,1239.37,690.00,1442.10,202.73,'2023-03-09 14:30:49'),(1126,'1','311',1,'Retail Sale Id 1176',0.00,1779.00,690.00,2070.00,291.00,'2023-03-09 14:33:20'),(1127,'1','311',1,'Retail Sale Id 1177',0.00,2965.00,690.00,3450.00,485.00,'2023-03-09 14:38:39'),(1128,'1','311',1,'Retail Sale Id 1178',0.00,6523.00,690.00,7590.00,1067.00,'2023-03-09 14:40:08'),(1129,'1','311',1,'Retail Sale Id 1179',0.00,7116.00,690.00,8280.00,1164.00,'2023-03-09 14:41:27'),(1130,'1','311',1,'Retail Sale Id 1180',0.00,2656.64,690.00,3091.20,434.56,'2023-03-09 14:45:49'),(1131,'1','311',1,'Retail Sale Id 1181',0.00,2372.00,690.00,2760.00,388.00,'2023-03-09 14:46:55'),(1132,'1','311',1,'Retail Sale Id 1182',0.00,4921.90,690.00,5727.00,805.10,'2023-03-09 14:48:19'),(1133,'1','311',1,'Retail Sale Id 1183',0.00,2965.00,690.00,3450.00,485.00,'2023-03-09 14:48:57'),(1134,'1','311',1,'Retail Sale Id 1184',0.00,5930.00,690.00,6900.00,970.00,'2023-03-09 14:50:57'),(1135,'1','311',1,'Retail Sale Id 1185',0.00,3261.50,690.00,3795.00,533.50,'2023-03-09 14:53:11'),(1136,'1','311',1,'Retail Sale Id 1186',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-09 14:56:38'),(1137,'1','311',1,'Retail Sale Id 1187',0.00,5930.00,690.00,6900.00,970.00,'2023-03-09 15:00:47'),(1138,'1','311',1,'Retail Sale Id 1187',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-09 15:00:47'),(1139,'1','311',1,'Retail Sale Id 1188',0.00,5337.00,690.00,6210.00,873.00,'2023-03-09 15:01:32'),(1140,'1','311',1,'Retail Sale Id 1189',0.00,5930.00,690.00,6900.00,970.00,'2023-03-09 15:03:08'),(1141,'1','311',1,'Retail Sale Id 1190',0.00,5930.00,690.00,6900.00,970.00,'2023-03-09 15:03:57'),(1142,'1','311',1,'Retail Sale Id 1191',0.00,3558.00,690.00,4140.00,582.00,'2023-03-09 16:48:09'),(1143,'1','311',1,'Retail Sale Id 1192',0.00,8895.00,690.00,10350.00,1455.00,'2023-03-09 16:49:47'),(1144,'1','311',1,'Retail Sale Id 1193',0.00,4744.00,690.00,5520.00,776.00,'2023-03-09 16:51:02'),(1145,'1','311',1,'Retail Sale Id 1194',0.00,2407.58,690.00,2801.40,393.82,'2023-03-09 17:02:20'),(1146,'1','311',1,'Retail Sale Id 1195',0.00,3854.50,690.00,4485.00,630.50,'2023-03-09 17:06:03'),(1147,'1','311',1,'Retail Sale Id 1196',0.00,3558.00,690.00,4140.00,582.00,'2023-03-09 17:07:15'),(1148,'1','311',1,'Retail Sale Id 1197',0.00,5930.00,690.00,6900.00,970.00,'2023-03-09 17:08:15'),(1149,'1','311',1,'Retail Sale Id 1198',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-09 17:09:10'),(1150,'1','311',1,'Retail Sale Id 1199',0.00,426.96,690.00,496.80,69.84,'2023-03-09 17:11:33'),(1151,'1','311',1,'Retail Sale Id 1200',0.00,4151.00,690.00,4830.00,679.00,'2023-03-09 17:12:22'),(1152,'1','311',1,'Retail Sale Id 1201',0.00,1186.00,690.00,1380.00,194.00,'2023-03-09 17:12:57'),(1153,'1','311',1,'Retail Sale Id 1202',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-09 17:49:03'),(1154,'1','311',1,'Retail Sale Id 1203',0.00,1779.00,690.00,2070.00,291.00,'2023-03-09 17:49:46'),(1155,'1','311',1,'Retail Sale Id 1204',0.00,1547.73,690.00,1800.90,253.17,'2023-03-09 17:51:20'),(1156,'1','311',1,'Retail Sale Id 1205',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-09 17:56:01'),(1157,'1','311',1,'Retail Sale Id 1207',0.00,6700.90,690.00,7797.00,1096.10,'2023-03-09 18:00:08'),(1158,'1','311',1,'Retail Sale Id 1208',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-09 18:01:21'),(1159,'1','311',1,'Retail Sale Id 1210',0.00,6979.61,690.00,8121.30,1141.69,'2023-03-09 18:11:46'),(1160,'1','311',1,'Retail Sale Id 1211',0.00,1779.00,690.00,2070.00,291.00,'2023-03-09 18:25:11'),(1161,'1','311',1,'Return of Retail Sale Id 1160',1648.54,0.00,690.00,-1918.20,-269.66,'2023-03-09 18:26:13'),(1162,'1','311',1,'Retail Sale Id 1212',0.00,3558.00,690.00,4140.00,582.00,'2023-03-10 07:54:21'),(1163,'1','311',1,'Retail Sale Id 1213',0.00,3558.00,690.00,4140.00,582.00,'2023-03-10 08:04:09'),(1164,'1','311',1,'Retail Sale Id 1214',0.00,7116.00,690.00,8280.00,1164.00,'2023-03-10 08:05:44'),(1165,'1','311',1,'Retail Sale Id 1215',0.00,1186.00,690.00,1380.00,194.00,'2023-03-10 08:07:11'),(1166,'1','311',1,'Retail Sale Id 1216',0.00,3854.50,690.00,4485.00,630.50,'2023-03-10 08:09:34'),(1167,'1','311',1,'Retail Sale Id 1217',0.00,2372.00,690.00,2760.00,388.00,'2023-03-10 08:35:15'),(1168,'1','311',1,'Retail Sale Id 1218',0.00,2372.00,690.00,2760.00,388.00,'2023-03-10 08:51:10'),(1169,'1','311',1,'Retail Sale Id 1219',0.00,3439.40,690.00,4002.00,562.60,'2023-03-10 08:56:53'),(1170,'1','311',1,'Retail Sale Id 1220',0.00,1779.00,690.00,2070.00,291.00,'2023-03-10 09:15:18'),(1171,'1','311',1,'Retail Sale Id 1221',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-10 09:17:05'),(1172,'1','311',1,'Retail Sale Id 1222',0.00,3558.00,690.00,4140.00,582.00,'2023-03-10 09:18:38'),(1173,'1','311',1,'Retail Sale Id 1222',0.00,4744.00,690.00,5520.00,776.00,'2023-03-10 09:18:38'),(1174,'1','311',1,'Retail Sale Id 1223',0.00,2372.00,690.00,2760.00,388.00,'2023-03-10 09:20:10'),(1175,'1','311',1,'Retail Sale Id 1224',0.00,2965.00,690.00,3450.00,485.00,'2023-03-10 09:31:47'),(1176,'1','311',1,'Retail Sale Id 1225',0.00,1779.00,690.00,2070.00,291.00,'2023-03-10 09:34:48'),(1177,'1','311',1,'Retail Sale Id 1226',0.00,1779.00,690.00,2070.00,291.00,'2023-03-10 09:40:32'),(1178,'1','311',1,'Retail Sale Id 1227',0.00,2579.55,690.00,3001.50,421.95,'2023-03-10 09:49:44'),(1179,'1','311',1,'Retail Sale Id 1228',0.00,2965.00,690.00,3450.00,485.00,'2023-03-10 09:56:28'),(1180,'1','311',1,'Retail Sale Id 1229',0.00,4744.00,690.00,5520.00,776.00,'2023-03-10 10:10:05'),(1181,'1','311',1,'Retail Sale Id 1230',0.00,1719.70,690.00,2001.00,281.30,'2023-03-10 10:32:18'),(1182,'1','311',1,'Retail Sale Id 1231',0.00,1286.81,690.00,1497.30,210.49,'2023-03-10 10:34:04'),(1183,'1','311',1,'Retail Sale Id 1233',0.00,3854.50,690.00,4485.00,630.50,'2023-03-10 10:38:34'),(1184,'1','311',1,'Retail Sale Id 1234',0.00,593.00,690.00,690.00,97.00,'2023-03-10 10:39:30'),(1185,'1','311',1,'Retail Sale Id 1235',0.00,4744.00,690.00,5520.00,776.00,'2023-03-10 10:55:59'),(1186,'1','311',1,'Retail Sale Id 1236',0.00,3095.46,690.00,3601.80,506.34,'2023-03-10 10:57:54'),(1187,'1','311',1,'Retail Sale Id 1237',0.00,6226.50,690.00,7245.00,1018.50,'2023-03-10 11:09:39'),(1188,'1','311',1,'Retail Sale Id 1240',0.00,2579.55,690.00,3001.50,421.95,'2023-03-10 11:29:40'),(1189,'1','311',1,'Retail Sale Id 1239',0.00,3558.00,690.00,4140.00,582.00,'2023-03-10 11:30:52'),(1190,'1','311',1,'Retail Sale Id 1239',0.00,7709.00,690.00,8970.00,1261.00,'2023-03-10 11:30:52'),(1191,'1','311',1,'Retail Sale Id 1241',0.00,1779.00,690.00,2070.00,291.00,'2023-03-10 11:47:08'),(1192,'1','311',1,'Retail Sale Id 1242',0.00,2965.00,690.00,3450.00,485.00,'2023-03-10 12:04:26'),(1193,'1','311',1,'Retail Sale Id 1243',0.00,68788.00,670.00,77720.00,8932.00,'2023-03-10 12:05:56'),(1194,'1','311',1,'Retail Sale Id 1244',0.00,4744.00,690.00,5520.00,776.00,'2023-03-10 12:07:36'),(1195,'1','311',1,'Retail Sale Id 1245',0.00,2372.00,690.00,2760.00,388.00,'2023-03-10 12:25:19'),(1196,'1','311',1,'Retail Sale Id 1246',0.00,2372.00,690.00,2760.00,388.00,'2023-03-10 12:50:43'),(1197,'1','311',1,'Retail Sale Id 1247',0.00,3439.40,690.00,4002.00,562.60,'2023-03-10 12:59:58'),(1198,'1','311',1,'Retail Sale Id 1248',0.00,3558.00,690.00,4140.00,582.00,'2023-03-10 13:01:57'),(1199,'1','311',1,'Retail Sale Id 1250',0.00,3558.00,690.00,4140.00,582.00,'2023-03-10 13:17:41'),(1200,'1','311',1,'Retail Sale Id 1253',0.00,1186.00,690.00,1380.00,194.00,'2023-03-10 13:23:09'),(1201,'1','311',1,'Retail Sale Id 1252',0.00,2965.00,690.00,3450.00,485.00,'2023-03-10 13:23:36'),(1202,'1','311',1,'Retail Sale Id 1254',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-10 13:25:11'),(1203,'1','311',1,'Retail Sale Id 1255',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-10 13:27:44'),(1204,'1','311',1,'Retail Sale Id 1256',0.00,2372.00,690.00,2760.00,388.00,'2023-03-10 13:28:30'),(1205,'1','311',1,'Retail Sale Id 1257',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-10 13:43:39'),(1206,'1','311',1,'Retail Sale Id 1258',0.00,2965.00,690.00,3450.00,485.00,'2023-03-10 14:03:43'),(1207,'1','311',1,'Retail Sale Id 1259',0.00,1186.00,690.00,1380.00,194.00,'2023-03-10 14:08:25'),(1208,'1','311',1,'Retail Sale Id 1259',0.00,1779.00,690.00,2070.00,291.00,'2023-03-10 14:08:25'),(1209,'1','311',1,'Retail Sale Id 1260',0.00,1779.00,690.00,2070.00,291.00,'2023-03-10 14:21:38'),(1210,'1','311',1,'Retail Sale Id 1261',0.00,1186.00,690.00,1380.00,194.00,'2023-03-10 14:28:48'),(1211,'1','311',1,'Retail Sale Id 1261',0.00,1186.00,690.00,1380.00,194.00,'2023-03-10 14:28:48'),(1212,'1','311',1,'Retail Sale Id 1262',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-10 15:04:43'),(1213,'1','311',1,'Retail Sale Id 1263',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-10 15:05:43'),(1214,'1','311',1,'Retail Sale Id 1264',0.00,2372.00,690.00,2760.00,388.00,'2023-03-10 15:08:17'),(1215,'1','311',1,'Retail Sale Id 1265',0.00,4744.00,690.00,5520.00,776.00,'2023-03-10 15:26:30'),(1216,'1','311',1,'Retail Sale Id 1266',0.00,859.85,690.00,1000.50,140.65,'2023-03-10 15:28:09'),(1217,'1','311',1,'Retail Sale Id 1267',0.00,1779.00,690.00,2070.00,291.00,'2023-03-10 15:28:58'),(1218,'1','311',1,'Retail Sale Id 1268',0.00,4151.00,690.00,4830.00,679.00,'2023-03-10 15:39:15'),(1219,'1','311',1,'Retail Sale Id 1269',0.00,2579.55,690.00,3001.50,421.95,'2023-03-10 16:28:29'),(1220,'1','311',1,'Retail Sale Id 1270',0.00,2372.00,690.00,2760.00,388.00,'2023-03-10 16:45:35'),(1221,'1','311',1,'Retail Sale Id 1271',0.00,1186.00,690.00,1380.00,194.00,'2023-03-10 16:47:43'),(1222,'1','311',1,'Retail Sale Id 1272',0.00,1286.81,690.00,1497.30,210.49,'2023-03-10 17:05:46'),(1223,'1','311',1,'Retail Sale Id 1274',0.00,1779.00,690.00,2070.00,291.00,'2023-03-10 17:11:22'),(1224,'1','311',1,'Retail Sale Id 1276',0.00,1186.00,690.00,1380.00,194.00,'2023-03-10 17:32:55'),(1225,'1','311',1,'Retail Sale Id 1277',0.00,3558.00,690.00,4140.00,582.00,'2023-03-10 17:35:42'),(1226,'1','311',1,'Retail Sale Id 1279',0.00,3558.00,690.00,4140.00,582.00,'2023-03-10 17:52:09'),(1227,'1','311',1,'Retail Sale Id 1280',0.00,1779.00,690.00,2070.00,291.00,'2023-03-10 17:57:22'),(1228,'1','311',1,'Return of Retail Sale Id 1277',3558.00,0.00,690.00,-4140.00,-582.00,'2023-03-10 19:02:40'),(1229,'1','311',1,'Retail Sale Id 1281',0.00,2680.36,690.00,3118.80,438.44,'2023-03-10 19:03:34'),(1230,'1','311',1,'Return of Retail Sale Id 1281',2680.36,0.00,690.00,-3118.80,-438.44,'2023-03-10 19:05:34'),(1231,'1','311',1,'Retail Sale Id 1282',0.00,2680.36,690.00,3118.80,438.44,'2023-03-10 19:06:18'),(1232,'1','311',1,'Retail Sale Id 1283',0.00,34987.00,670.00,39530.00,4543.00,'2023-03-11 08:21:26'),(1233,'1','311',1,'Retail Sale Id 1284',0.00,2965.00,690.00,3450.00,485.00,'2023-03-11 08:25:48'),(1234,'1','311',1,'Retail Sale Id 1284',0.00,2965.00,690.00,3450.00,485.00,'2023-03-11 08:25:48'),(1235,'1','311',1,'Retail Sale Id 1285',0.00,1779.00,690.00,2070.00,291.00,'2023-03-11 08:30:30'),(1236,'1','311',1,'Retail Sale Id 1286',0.00,2965.00,690.00,3450.00,485.00,'2023-03-11 08:32:37'),(1237,'1','311',1,'Retail Sale Id 1287',0.00,2965.00,690.00,3450.00,485.00,'2023-03-11 08:38:16'),(1238,'1','311',1,'Retail Sale Id 1288',0.00,2372.00,690.00,2760.00,388.00,'2023-03-11 08:39:52'),(1239,'1','311',1,'Retail Sale Id 1289',0.00,4744.00,690.00,5520.00,776.00,'2023-03-11 09:03:51'),(1240,'1','311',1,'Retail Sale Id 1290',0.00,3558.00,690.00,4140.00,582.00,'2023-03-11 09:05:09'),(1241,'1','311',1,'Retail Sale Id 1291',0.00,1375.76,690.00,1600.80,225.04,'2023-03-11 09:06:25'),(1242,'1','311',1,'Retail Sale Id 1292',0.00,1719.70,690.00,2001.00,281.30,'2023-03-11 09:09:57'),(1243,'1','311',1,'Retail Sale Id 1292',0.00,4299.25,690.00,5002.50,703.25,'2023-03-11 09:09:57'),(1244,'1','311',1,'Retail Sale Id 1293',0.00,4151.00,690.00,4830.00,679.00,'2023-03-11 09:12:27'),(1245,'1','311',1,'Retail Sale Id 1294',0.00,5930.00,690.00,6900.00,970.00,'2023-03-11 09:16:24'),(1246,'1','311',1,'Retail Sale Id 1295',0.00,593.00,690.00,690.00,97.00,'2023-03-11 09:17:25'),(1247,'1','311',1,'Retail Sale Id 1296',0.00,1779.00,690.00,2070.00,291.00,'2023-03-11 09:21:12'),(1248,'1','311',1,'Retail Sale Id 1297',0.00,1779.00,690.00,2070.00,291.00,'2023-03-11 09:29:16'),(1249,'1','311',1,'Retail Sale Id 1298',0.00,2579.55,690.00,3001.50,421.95,'2023-03-11 09:30:17'),(1250,'1','311',1,'Retail Sale Id 1299',0.00,593.00,690.00,690.00,97.00,'2023-03-11 09:31:28'),(1251,'1','311',1,'Retail Sale Id 1300',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-11 09:32:36'),(1252,'1','311',1,'Retail Sale Id 1301',0.00,2965.00,690.00,3450.00,485.00,'2023-03-11 09:34:34'),(1253,'1','311',1,'Retail Sale Id 1302',0.00,3558.00,690.00,4140.00,582.00,'2023-03-11 09:38:04'),(1254,'1','311',1,'Retail Sale Id 1303',0.00,859.85,690.00,1000.50,140.65,'2023-03-11 09:39:54'),(1255,'1','311',1,'Retail Sale Id 1304',0.00,2965.00,690.00,3450.00,485.00,'2023-03-11 09:40:47'),(1256,'1','311',1,'Retail Sale Id 1305',0.00,859.85,690.00,1000.50,140.65,'2023-03-11 09:43:49'),(1257,'1','311',1,'Retail Sale Id 1306',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-11 09:52:24'),(1258,'1','311',1,'Retail Sale Id 1307',0.00,3558.00,690.00,4140.00,582.00,'2023-03-11 09:57:30'),(1259,'1','311',1,'Retail Sale Id 1308',0.00,3854.50,690.00,4485.00,630.50,'2023-03-11 10:00:40'),(1260,'1','311',1,'Retail Sale Id 1309',0.00,1482.50,690.00,1725.00,242.50,'2023-03-11 10:14:52'),(1261,'1','311',1,'Retail Sale Id 1311',0.00,859.85,690.00,1000.50,140.65,'2023-03-11 10:20:00'),(1262,'1','311',1,'Retail Sale Id 1312',0.00,1719.70,690.00,2001.00,281.30,'2023-03-11 10:20:28'),(1263,'1','311',1,'Retail Sale Id 1313',0.00,687.88,690.00,800.40,112.52,'2023-03-11 10:21:23'),(1264,'1','311',1,'Retail Sale Id 1314',0.00,3558.00,690.00,4140.00,582.00,'2023-03-11 10:24:09'),(1265,'1','311',1,'Retail Sale Id 1315',0.00,1779.00,690.00,2070.00,291.00,'2023-03-11 10:26:03'),(1266,'1','311',1,'Retail Sale Id 1316',0.00,3558.00,690.00,4140.00,582.00,'2023-03-11 10:27:39'),(1267,'1','311',1,'Retail Sale Id 1317',0.00,3558.00,690.00,4140.00,582.00,'2023-03-11 10:28:44'),(1268,'1','311',1,'Retail Sale Id 1318',0.00,3558.00,690.00,4140.00,582.00,'2023-03-11 10:30:06'),(1269,'1','311',1,'Retail Sale Id 1320',0.00,2372.00,690.00,2760.00,388.00,'2023-03-11 10:33:31'),(1270,'1','311',1,'Retail Sale Id 1321',0.00,4151.00,690.00,4830.00,679.00,'2023-03-11 10:35:27'),(1271,'1','311',1,'Retail Sale Id 1322',0.00,4151.00,690.00,4830.00,679.00,'2023-03-11 10:37:27'),(1272,'1','311',1,'Retail Sale Id 1323',0.00,2965.00,690.00,3450.00,485.00,'2023-03-11 10:39:11'),(1273,'1','311',1,'Retail Sale Id 1324',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-11 10:43:26'),(1274,'1','311',1,'Retail Sale Id 1325',0.00,8302.00,690.00,9660.00,1358.00,'2023-03-11 11:06:23'),(1275,'1','311',1,'Retail Sale Id 1326',0.00,2372.00,690.00,2760.00,388.00,'2023-03-11 11:09:55'),(1276,'1','311',1,'Retail Sale Id 1327',0.00,3558.00,690.00,4140.00,582.00,'2023-03-11 11:17:04'),(1277,'1','311',1,'Retail Sale Id 1328',0.00,2372.00,690.00,2760.00,388.00,'2023-03-11 11:19:00'),(1278,'1','311',1,'Retail Sale Id 1330',0.00,1779.00,690.00,2070.00,291.00,'2023-03-11 11:23:51'),(1279,'1','311',1,'Retail Sale Id 1331',0.00,3558.00,690.00,4140.00,582.00,'2023-03-11 11:25:27'),(1280,'1','311',1,'Retail Sale Id 1332',0.00,3558.00,690.00,4140.00,582.00,'2023-03-11 11:29:18'),(1281,'1','311',1,'Retail Sale Id 1333',0.00,859.85,690.00,1000.50,140.65,'2023-03-11 11:31:53'),(1282,'1','311',1,'Retail Sale Id 1334',0.00,2965.00,690.00,3450.00,485.00,'2023-03-11 11:34:43'),(1283,'1','311',1,'Retail Sale Id 1335',0.00,10081.00,690.00,11730.00,1649.00,'2023-03-11 11:37:46'),(1284,'1','311',1,'Retail Sale Id 1336',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-11 11:40:10'),(1285,'1','311',1,'Retail Sale Id 1337',0.00,1719.70,690.00,2001.00,281.30,'2023-03-11 11:41:42'),(1286,'1','311',1,'Retail Sale Id 1338',0.00,859.85,690.00,1000.50,140.65,'2023-03-11 11:53:13'),(1287,'1','311',1,'Retail Sale Id 1339',0.00,1779.00,690.00,2070.00,291.00,'2023-03-11 11:56:56'),(1288,'1','311',1,'Retail Sale Id 1339',0.00,1779.00,690.00,2070.00,291.00,'2023-03-11 11:56:56'),(1289,'1','311',1,'Retail Sale Id 1340',0.00,5337.00,690.00,6210.00,873.00,'2023-03-11 11:58:22'),(1290,'1','311',1,'Retail Sale Id 1342',0.00,2965.00,690.00,3450.00,485.00,'2023-03-11 12:02:45'),(1291,'1','311',1,'Retail Sale Id 1343',0.00,1203.79,690.00,1400.70,196.91,'2023-03-11 12:05:09'),(1292,'1','311',1,'Retail Sale Id 1344',0.00,35811.27,670.00,40461.30,4650.03,'2023-03-11 12:12:42'),(1293,'1','311',1,'Retail Sale Id 1345',0.00,5930.00,690.00,6900.00,970.00,'2023-03-11 12:36:55'),(1294,'1','311',1,'Retail Sale Id 1346',0.00,2372.00,690.00,2760.00,388.00,'2023-03-11 12:38:14'),(1295,'1','311',1,'Retail Sale Id 1347',0.00,4151.00,690.00,4830.00,679.00,'2023-03-11 12:40:10'),(1296,'1','311',1,'Retail Sale Id 1348',0.00,2579.55,690.00,3001.50,421.95,'2023-03-11 12:49:57'),(1297,'1','311',1,'Retail Sale Id 1349',0.00,5930.00,690.00,6900.00,970.00,'2023-03-11 12:50:56'),(1298,'1','311',1,'Retail Sale Id 1350',0.00,1719.70,690.00,2001.00,281.30,'2023-03-11 12:51:53'),(1299,'1','311',1,'Retail Sale Id 1351',0.00,2965.00,690.00,3450.00,485.00,'2023-03-11 12:56:54'),(1300,'1','311',1,'Retail Sale Id 1352',0.00,2965.00,690.00,3450.00,485.00,'2023-03-11 13:00:26'),(1301,'1','311',1,'Retail Sale Id 1353',0.00,3558.00,690.00,4140.00,582.00,'2023-03-11 13:01:35'),(1302,'1','311',1,'Retail Sale Id 1354',0.00,2965.00,690.00,3450.00,485.00,'2023-03-11 13:35:17'),(1303,'1','311',1,'Retail Sale Id 1355',0.00,2579.55,690.00,3001.50,421.95,'2023-03-11 13:36:39'),(1304,'1','311',1,'Retail Sale Id 1356',0.00,1458.78,690.00,1697.40,238.62,'2023-03-11 13:39:16'),(1305,'1','311',1,'Retail Sale Id 1357',0.00,859.85,690.00,1000.50,140.65,'2023-03-11 13:39:50'),(1306,'1','311',1,'Retail Sale Id 1358',0.00,1779.00,690.00,2070.00,291.00,'2023-03-11 13:49:49'),(1307,'1','311',1,'Retail Sale Id 1359',0.00,2965.00,690.00,3450.00,485.00,'2023-03-11 13:53:52'),(1308,'1','311',1,'Retail Sale Id 1360',0.00,3558.00,690.00,4140.00,582.00,'2023-03-11 13:56:26'),(1309,'1','311',1,'Retail Sale Id 1361',0.00,1779.00,690.00,2070.00,291.00,'2023-03-11 13:59:57'),(1310,'1','311',1,'Retail Sale Id 1362',0.00,1186.00,690.00,1380.00,194.00,'2023-03-11 14:09:36'),(1311,'1','311',1,'Retail Sale Id 1363',0.00,4299.25,690.00,5002.50,703.25,'2023-03-11 14:11:12'),(1312,'1','311',1,'Retail Sale Id 1365',0.00,4151.00,690.00,4830.00,679.00,'2023-03-11 14:21:48'),(1313,'1','311',1,'Retail Sale Id 1366',0.00,4744.00,690.00,5520.00,776.00,'2023-03-11 14:37:06'),(1314,'1','311',1,'Retail Sale Id 1367',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-11 14:47:17'),(1315,'1','311',1,'Retail Sale Id 1368',0.00,1186.00,690.00,1380.00,194.00,'2023-03-11 14:53:10'),(1316,'1','311',1,'Retail Sale Id 1369',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-11 14:56:39'),(1317,'1','311',1,'Retail Sale Id 1370',0.00,6013.02,690.00,6996.60,983.58,'2023-03-11 15:15:19'),(1318,'1','311',1,'Retail Sale Id 1371',0.00,2579.55,690.00,3001.50,421.95,'2023-03-11 15:18:25'),(1319,'1','311',1,'Retail Sale Id 1372',0.00,3439.40,690.00,4002.00,562.60,'2023-03-11 15:20:34'),(1320,'1','311',1,'Retail Sale Id 1372',0.00,3439.40,690.00,4002.00,562.60,'2023-03-11 15:20:34'),(1321,'1','311',1,'Retail Sale Id 1373',0.00,1203.79,690.00,1400.70,196.91,'2023-03-11 15:25:28'),(1322,'1','311',1,'Retail Sale Id 1376',0.00,1802.72,690.00,2097.60,294.88,'2023-03-11 15:34:44'),(1323,'1','311',1,'Retail Sale Id 1377',0.00,3563.93,690.00,4146.90,582.97,'2023-03-11 15:35:31'),(1324,'1','311',1,'Retail Sale Id 1378',0.00,3611.37,690.00,4202.10,590.73,'2023-03-11 15:36:49'),(1325,'1','311',1,'Retail Sale Id 1379',0.00,1779.00,690.00,2070.00,291.00,'2023-03-11 15:38:36'),(1326,'1','311',1,'Retail Sale Id 1382',0.00,2965.00,690.00,3450.00,485.00,'2023-03-11 15:45:34'),(1327,'1','311',1,'Retail Sale Id 1383',0.00,1719.70,690.00,2001.00,281.30,'2023-03-11 15:46:17'),(1328,'1','311',1,'Retail Sale Id 1384',0.00,2965.00,690.00,3450.00,485.00,'2023-03-11 15:47:42'),(1329,'1','311',1,'Retail Sale Id 1385',0.00,3558.00,690.00,4140.00,582.00,'2023-03-11 15:55:13'),(1330,'1','311',1,'Retail Sale Id 1387',0.00,1802.72,690.00,2097.60,294.88,'2023-03-11 15:57:19'),(1331,'1','311',1,'Retail Sale Id 1389',0.00,2372.00,690.00,2760.00,388.00,'2023-03-11 16:08:44'),(1332,'1','311',1,'Retail Sale Id 1388',0.00,1779.00,690.00,2070.00,291.00,'2023-03-11 16:10:48'),(1333,'1','311',1,'Retail Sale Id 1391',0.00,1779.00,690.00,2070.00,291.00,'2023-03-11 16:15:50'),(1334,'1','311',1,'Retail Sale Id 1392',0.00,3558.00,690.00,4140.00,582.00,'2023-03-11 16:37:21'),(1335,'1','311',1,'Retail Sale Id 1394',0.00,3558.00,690.00,4140.00,582.00,'2023-03-11 16:50:12'),(1336,'1','311',1,'Retail Sale Id 1395',0.00,4151.00,690.00,4830.00,679.00,'2023-03-11 16:57:11'),(1337,'1','311',1,'Retail Sale Id 1396',0.00,1186.00,690.00,1380.00,194.00,'2023-03-11 17:09:16'),(1338,'1','311',1,'Retail Sale Id 1397',0.00,3439.40,690.00,4002.00,562.60,'2023-03-11 17:13:55'),(1339,'1','311',1,'Retail Sale Id 1398',0.00,2965.00,690.00,3450.00,485.00,'2023-03-11 17:15:51'),(1340,'1','311',1,'Retail Sale Id 1399',0.00,1779.00,690.00,2070.00,291.00,'2023-03-11 17:17:02'),(1341,'1','311',1,'Retail Sale Id 1400',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-11 17:18:20'),(1342,'1','311',1,'Retail Sale Id 1401',0.00,2372.00,690.00,2760.00,388.00,'2023-03-11 17:20:55'),(1343,'1','311',1,'Retail Sale Id 1402',0.00,2965.00,690.00,3450.00,485.00,'2023-03-11 17:23:42'),(1344,'1','311',1,'Retail Sale Id 1403',0.00,3558.00,690.00,4140.00,582.00,'2023-03-11 17:28:37'),(1345,'1','311',1,'Retail Sale Id 1405',0.00,2579.55,690.00,3001.50,421.95,'2023-03-11 17:31:42'),(1346,'1','311',1,'Retail Sale Id 1406',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-11 17:36:33'),(1347,'1','311',1,'Retail Sale Id 1408',0.00,859.85,690.00,1000.50,140.65,'2023-03-11 17:37:48'),(1348,'1','311',1,'Retail Sale Id 1409',0.00,1779.00,690.00,2070.00,291.00,'2023-03-11 17:41:47'),(1349,'1','311',1,'Retail Sale Id 1411',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-11 17:54:37'),(1350,'1','311',1,'Retail Sale Id 1412',0.00,1779.00,690.00,2070.00,291.00,'2023-03-11 17:55:46'),(1351,'1','311',1,'Retail Sale Id 1413',0.00,7709.00,690.00,8970.00,1261.00,'2023-03-11 18:12:46'),(1352,'1','311',1,'Retail Sale Id 1415',0.00,593.00,690.00,690.00,97.00,'2023-03-11 18:21:49'),(1353,'1','311',1,'Retail Sale Id 1417',0.00,2372.00,690.00,2760.00,388.00,'2023-03-11 18:25:51'),(1354,'1','311',1,'Retail Sale Id 1417',0.00,3558.00,690.00,4140.00,582.00,'2023-03-11 18:25:51'),(1355,'1','311',1,'Retail Sale Id 1419',0.00,1779.00,690.00,2070.00,291.00,'2023-03-11 18:26:54'),(1356,'1','311',1,'Retail Sale Id 1420',0.00,593.00,690.00,690.00,97.00,'2023-03-11 18:28:49'),(1357,'1','311',1,'Retail Sale Id 1421',0.00,1031.82,690.00,1200.60,168.78,'2023-03-11 18:30:08'),(1358,'1','311',1,'Retail Sale Id 1422',0.00,1779.00,690.00,2070.00,291.00,'2023-03-11 18:30:53'),(1359,'1','311',1,'Retail Sale Id 1374',0.00,4151.00,690.00,4830.00,679.00,'2023-03-11 18:41:45'),(1360,'1','311',1,'Retail Sale Id 1374',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-11 18:41:45'),(1361,'1','311',1,'Retail Sale Id 1423',0.00,3558.00,690.00,4140.00,582.00,'2023-03-11 18:43:11'),(1362,'1','311',1,'Return of Retail Sale Id 1423',3558.00,0.00,690.00,-4140.00,-582.00,'2023-03-11 23:16:16'),(1363,'1','311',1,'Return of Retail Sale Id 1422',1779.00,0.00,690.00,-2070.00,-291.00,'2023-03-11 23:17:25'),(1364,'1','311',1,'Return of Retail Sale Id 1401',2372.00,0.00,690.00,-2760.00,-388.00,'2023-03-11 23:20:54'),(1365,'1','311',1,'Return of Retail Sale Id 1415',593.00,0.00,690.00,-690.00,-97.00,'2023-03-11 23:23:39'),(1366,'1','311',1,'Retail Sale Id 1424',0.00,1298.67,690.00,1511.10,212.43,'2023-03-11 23:25:05'),(1367,'1','311',1,'Retail Sale Id 1425',0.00,1719.70,690.00,2001.00,281.30,'2023-03-12 08:02:41'),(1368,'1','311',1,'Retail Sale Id 1426',0.00,2965.00,690.00,3450.00,485.00,'2023-03-12 08:04:03'),(1369,'1','311',1,'Retail Sale Id 1427',0.00,2579.55,690.00,3001.50,421.95,'2023-03-12 08:05:52'),(1370,'1','311',1,'Retail Sale Id 1428',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 08:07:06'),(1371,'1','311',1,'Retail Sale Id 1429',0.00,800.55,690.00,931.50,130.95,'2023-03-12 08:09:04'),(1372,'1','311',1,'Retail Sale Id 1431',0.00,859.85,690.00,1000.50,140.65,'2023-03-12 08:13:20'),(1373,'1','311',1,'Retail Sale Id 1431',0.00,1186.00,690.00,1380.00,194.00,'2023-03-12 08:13:20'),(1374,'1','311',1,'Retail Sale Id 1431',0.00,2965.00,690.00,3450.00,485.00,'2023-03-12 08:13:20'),(1375,'1','311',1,'Retail Sale Id 1431',0.00,4151.00,690.00,4830.00,679.00,'2023-03-12 08:13:20'),(1376,'1','311',1,'Retail Sale Id 1432',0.00,1719.70,690.00,2001.00,281.30,'2023-03-12 08:14:39'),(1377,'1','311',1,'Retail Sale Id 1433',0.00,3558.00,690.00,4140.00,582.00,'2023-03-12 08:16:08'),(1378,'1','311',1,'Retail Sale Id 1434',0.00,1719.70,690.00,2001.00,281.30,'2023-03-12 08:17:29'),(1379,'1','311',1,'Retail Sale Id 1435',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 08:22:17'),(1380,'1','311',1,'Retail Sale Id 1436',0.00,2965.00,690.00,3450.00,485.00,'2023-03-12 08:23:20'),(1381,'1','311',1,'Retail Sale Id 1437',0.00,3261.50,690.00,3795.00,533.50,'2023-03-12 08:25:01'),(1382,'1','311',1,'Retail Sale Id 1438',0.00,4151.00,690.00,4830.00,679.00,'2023-03-12 08:26:49'),(1383,'1','311',1,'Retail Sale Id 1439',0.00,2372.00,690.00,2760.00,388.00,'2023-03-12 08:29:10'),(1384,'1','311',1,'Retail Sale Id 1440',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 08:30:32'),(1385,'1','311',1,'Retail Sale Id 1441',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 08:33:01'),(1386,'1','311',1,'Retail Sale Id 1442',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 08:34:17'),(1387,'1','311',1,'Retail Sale Id 1443',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 08:35:49'),(1388,'1','311',1,'Retail Sale Id 1444',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 08:38:57'),(1389,'1','311',1,'Retail Sale Id 1446',0.00,2579.55,690.00,3001.50,421.95,'2023-03-12 08:42:12'),(1390,'1','311',1,'Retail Sale Id 1447',0.00,7116.00,690.00,8280.00,1164.00,'2023-03-12 08:43:44'),(1391,'1','311',1,'Retail Sale Id 1448',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-12 08:45:07'),(1392,'1','311',1,'Retail Sale Id 1449',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 08:46:51'),(1393,'1','311',1,'Retail Sale Id 1451',0.00,1719.70,690.00,2001.00,281.30,'2023-03-12 08:48:37'),(1394,'1','311',1,'Retail Sale Id 1452',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 08:50:45'),(1395,'1','311',1,'Retail Sale Id 1453',0.00,1186.00,690.00,1380.00,194.00,'2023-03-12 08:53:38'),(1396,'1','311',1,'Retail Sale Id 1454',0.00,593.00,690.00,690.00,97.00,'2023-03-12 08:56:15'),(1397,'1','311',1,'Retail Sale Id 1455',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 08:58:34'),(1398,'1','311',1,'Retail Sale Id 1456',0.00,859.85,690.00,1000.50,140.65,'2023-03-12 08:59:59'),(1399,'1','311',1,'Retail Sale Id 1457',0.00,5930.00,690.00,6900.00,970.00,'2023-03-12 09:02:23'),(1400,'1','311',1,'Retail Sale Id 1458',0.00,2372.00,690.00,2760.00,388.00,'2023-03-12 09:07:16'),(1401,'1','311',1,'Retail Sale Id 1459',0.00,2965.00,690.00,3450.00,485.00,'2023-03-12 09:09:06'),(1402,'1','311',1,'Retail Sale Id 1460',0.00,1186.00,690.00,1380.00,194.00,'2023-03-12 09:10:41'),(1403,'1','311',1,'Retail Sale Id 1461',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 09:17:38'),(1404,'1','311',1,'Retail Sale Id 1462',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 09:18:14'),(1405,'1','311',1,'Retail Sale Id 1463',0.00,2965.00,690.00,3450.00,485.00,'2023-03-12 09:19:47'),(1406,'1','311',1,'Retail Sale Id 1464',0.00,7116.00,690.00,8280.00,1164.00,'2023-03-12 09:21:34'),(1407,'1','311',1,'Retail Sale Id 1465',0.00,4151.00,690.00,4830.00,679.00,'2023-03-12 09:28:36'),(1408,'1','311',1,'Retail Sale Id 1466',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 09:29:53'),(1409,'1','311',1,'Retail Sale Id 1467',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 09:31:28'),(1410,'1','311',1,'Retail Sale Id 1468',0.00,3439.40,690.00,4002.00,562.60,'2023-03-12 09:33:39'),(1411,'1','311',1,'Retail Sale Id 1469',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 09:36:20'),(1412,'1','311',1,'Retail Sale Id 1471',0.00,593.00,690.00,690.00,97.00,'2023-03-12 09:40:14'),(1413,'1','311',1,'Retail Sale Id 1472',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 09:52:22'),(1414,'1','311',1,'Retail Sale Id 1474',0.00,598.93,690.00,696.90,97.97,'2023-03-12 09:55:54'),(1415,'1','311',1,'Retail Sale Id 1476',0.00,1286.81,690.00,1497.30,210.49,'2023-03-12 09:57:32'),(1416,'1','311',1,'Retail Sale Id 1477',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 10:00:50'),(1417,'1','311',1,'Retail Sale Id 1479',0.00,3558.00,690.00,4140.00,582.00,'2023-03-12 10:05:25'),(1418,'1','311',1,'Retail Sale Id 1480',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-12 10:07:30'),(1419,'1','311',1,'Retail Sale Id 1478',0.00,2579.55,690.00,3001.50,421.95,'2023-03-12 10:09:04'),(1420,'1','311',1,'Retail Sale Id 1481',0.00,1719.70,690.00,2001.00,281.30,'2023-03-12 10:14:31'),(1421,'1','311',1,'Retail Sale Id 1482',0.00,3558.00,690.00,4140.00,582.00,'2023-03-12 10:21:39'),(1422,'1','311',1,'Retail Sale Id 1483',0.00,2965.00,690.00,3450.00,485.00,'2023-03-12 10:25:34'),(1423,'1','311',1,'Retail Sale Id 1484',0.00,2372.00,690.00,2760.00,388.00,'2023-03-12 10:27:50'),(1424,'1','311',1,'Retail Sale Id 1485',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 10:28:55'),(1425,'1','311',1,'Retail Sale Id 1486',0.00,859.85,690.00,1000.50,140.65,'2023-03-12 10:29:49'),(1426,'1','311',1,'Retail Sale Id 1488',0.00,2407.58,690.00,2801.40,393.82,'2023-03-12 10:31:24'),(1427,'1','311',1,'Retail Sale Id 1489',0.00,3558.00,690.00,4140.00,582.00,'2023-03-12 10:32:19'),(1428,'1','311',1,'Retail Sale Id 1490',0.00,859.85,690.00,1000.50,140.65,'2023-03-12 10:33:05'),(1429,'1','311',1,'Retail Sale Id 1491',0.00,1186.00,690.00,1380.00,194.00,'2023-03-12 10:35:33'),(1430,'1','311',1,'Retail Sale Id 1492',0.00,1186.00,690.00,1380.00,194.00,'2023-03-12 10:39:55'),(1431,'1','311',1,'Retail Sale Id 1493',0.00,4744.00,690.00,5520.00,776.00,'2023-03-12 10:42:55'),(1432,'1','311',1,'Retail Sale Id 1494',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 10:49:41'),(1433,'1','311',1,'Retail Sale Id 1494',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 10:49:41'),(1434,'1','311',1,'Retail Sale Id 1495',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 10:51:27'),(1435,'1','311',1,'Retail Sale Id 1496',0.00,2372.00,690.00,2760.00,388.00,'2023-03-12 10:53:38'),(1436,'1','311',1,'Retail Sale Id 1498',0.00,3558.00,690.00,4140.00,582.00,'2023-03-12 10:59:37'),(1437,'1','311',1,'Retail Sale Id 1499',0.00,593.00,690.00,690.00,97.00,'2023-03-12 11:01:25'),(1438,'1','311',1,'Retail Sale Id 1497',0.00,2075.50,690.00,2415.00,339.50,'2023-03-12 11:02:08'),(1439,'1','311',1,'Retail Sale Id 1500',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 11:02:58'),(1440,'1','311',1,'Retail Sale Id 1501',0.00,1458.78,690.00,1697.40,238.62,'2023-03-12 11:06:43'),(1441,'1','311',1,'Retail Sale Id 1503',0.00,2372.00,690.00,2760.00,388.00,'2023-03-12 11:14:06'),(1442,'1','311',1,'Retail Sale Id 1504',0.00,3558.00,690.00,4140.00,582.00,'2023-03-12 11:24:26'),(1443,'1','311',1,'Retail Sale Id 1505',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 11:26:28'),(1444,'1','311',1,'Retail Sale Id 1506',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 11:27:22'),(1445,'1','311',1,'Retail Sale Id 1507',0.00,3439.40,690.00,4002.00,562.60,'2023-03-12 11:28:09'),(1446,'1','311',1,'Retail Sale Id 1508',0.00,1031.82,690.00,1200.60,168.78,'2023-03-12 11:32:23'),(1447,'1','311',1,'Retail Sale Id 1509',0.00,5930.00,690.00,6900.00,970.00,'2023-03-12 11:35:48'),(1448,'1','311',1,'Retail Sale Id 1510',0.00,1203.79,690.00,1400.70,196.91,'2023-03-12 11:45:39'),(1449,'1','311',1,'Retail Sale Id 1511',0.00,1186.00,690.00,1380.00,194.00,'2023-03-12 11:46:27'),(1450,'1','311',1,'Retail Sale Id 1512',0.00,2579.55,690.00,3001.50,421.95,'2023-03-12 11:55:24'),(1451,'1','311',1,'Retail Sale Id 1513',0.00,3558.00,690.00,4140.00,582.00,'2023-03-12 12:05:02'),(1452,'1','311',1,'Retail Sale Id 1514',0.00,859.85,690.00,1000.50,140.65,'2023-03-12 12:14:12'),(1453,'1','311',1,'Retail Sale Id 1515',0.00,2965.00,690.00,3450.00,485.00,'2023-03-12 12:16:24'),(1454,'1','311',1,'Retail Sale Id 1517',0.00,1186.00,690.00,1380.00,194.00,'2023-03-12 12:20:00'),(1455,'1','311',1,'Retail Sale Id 1518',0.00,2372.00,690.00,2760.00,388.00,'2023-03-12 12:31:05'),(1456,'1','311',1,'Retail Sale Id 1519',0.00,3006.51,690.00,3498.30,491.79,'2023-03-12 12:35:29'),(1457,'1','311',1,'Retail Sale Id 1520',0.00,3439.40,690.00,4002.00,562.60,'2023-03-12 12:38:57'),(1458,'1','311',1,'Retail Sale Id 1521',0.00,2372.00,690.00,2760.00,388.00,'2023-03-12 12:43:43'),(1459,'1','311',1,'Retail Sale Id 1522',0.00,2579.55,690.00,3001.50,421.95,'2023-03-12 12:44:48'),(1460,'1','311',1,'Retail Sale Id 1523',0.00,1203.79,690.00,1400.70,196.91,'2023-03-12 12:47:29'),(1461,'1','311',1,'Retail Sale Id 1524',0.00,2372.00,690.00,2760.00,388.00,'2023-03-12 12:48:36'),(1462,'1','311',1,'Retail Sale Id 1525',0.00,2579.55,690.00,3001.50,421.95,'2023-03-12 12:56:25'),(1463,'1','311',1,'Retail Sale Id 1526',0.00,2965.00,690.00,3450.00,485.00,'2023-03-12 12:58:51'),(1464,'1','311',1,'Retail Sale Id 1527',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 13:01:26'),(1465,'1','311',1,'Retail Sale Id 1528',0.00,2965.00,690.00,3450.00,485.00,'2023-03-12 13:05:38'),(1466,'1','311',1,'Retail Sale Id 1528',0.00,3558.00,690.00,4140.00,582.00,'2023-03-12 13:05:38'),(1467,'1','311',1,'Retail Sale Id 1529',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 13:07:02'),(1468,'1','311',1,'Retail Sale Id 1530',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 13:11:00'),(1469,'1','311',1,'Retail Sale Id 1531',0.00,1031.82,690.00,1200.60,168.78,'2023-03-12 13:13:27'),(1470,'1','311',1,'Retail Sale Id 1532',0.00,3558.00,690.00,4140.00,582.00,'2023-03-12 13:25:37'),(1471,'1','311',1,'Retail Sale Id 1533',0.00,2372.00,690.00,2760.00,388.00,'2023-03-12 13:27:32'),(1472,'1','311',1,'Retail Sale Id 1534',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 13:38:56'),(1473,'1','311',1,'Retail Sale Id 1535',0.00,1186.00,690.00,1380.00,194.00,'2023-03-12 13:40:26'),(1474,'1','311',1,'Retail Sale Id 1536',0.00,859.85,690.00,1000.50,140.65,'2023-03-12 13:44:35'),(1475,'1','311',1,'Retail Sale Id 1537',0.00,859.85,690.00,1000.50,140.65,'2023-03-12 13:53:28'),(1476,'1','311',1,'Retail Sale Id 1538',0.00,2579.55,690.00,3001.50,421.95,'2023-03-12 13:54:52'),(1477,'1','311',1,'Retail Sale Id 1539',0.00,1286.81,690.00,1497.30,210.49,'2023-03-12 13:58:44'),(1478,'1','311',1,'Retail Sale Id 1540',0.00,5930.00,690.00,6900.00,970.00,'2023-03-12 14:00:40'),(1479,'1','311',1,'Retail Sale Id 1541',0.00,3558.00,690.00,4140.00,582.00,'2023-03-12 14:01:47'),(1480,'1','311',1,'Retail Sale Id 1542',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 14:02:59'),(1481,'1','311',1,'Retail Sale Id 1543',0.00,2965.00,690.00,3450.00,485.00,'2023-03-12 14:05:11'),(1482,'1','311',1,'Retail Sale Id 1544',0.00,3558.00,690.00,4140.00,582.00,'2023-03-12 14:06:09'),(1483,'1','311',1,'Retail Sale Id 1545',0.00,859.85,690.00,1000.50,140.65,'2023-03-12 14:07:46'),(1484,'1','311',1,'Retail Sale Id 1548',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 14:14:29'),(1485,'1','311',1,'Retail Sale Id 1548',0.00,2965.00,690.00,3450.00,485.00,'2023-03-12 14:14:29'),(1486,'1','311',1,'Retail Sale Id 1549',0.00,4151.00,690.00,4830.00,679.00,'2023-03-12 14:15:39'),(1487,'1','311',1,'Retail Sale Id 1549',0.00,4151.00,690.00,4830.00,679.00,'2023-03-12 14:15:39'),(1488,'1','311',1,'Retail Sale Id 1546',0.00,4744.00,690.00,5520.00,776.00,'2023-03-12 14:18:55'),(1489,'1','311',1,'Retail Sale Id 1551',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 14:23:03'),(1490,'1','311',1,'Retail Sale Id 1552',0.00,3261.50,690.00,3795.00,533.50,'2023-03-12 14:26:16'),(1491,'1','311',1,'Retail Sale Id 1553',0.00,5159.10,690.00,6003.00,843.90,'2023-03-12 14:29:48'),(1492,'1','311',1,'Retail Sale Id 1555',0.00,3439.40,690.00,4002.00,562.60,'2023-03-12 14:33:13'),(1493,'1','311',1,'Retail Sale Id 1556',0.00,859.85,690.00,1000.50,140.65,'2023-03-12 14:33:57'),(1494,'1','311',1,'Retail Sale Id 1557',0.00,1719.70,690.00,2001.00,281.30,'2023-03-12 15:00:07'),(1495,'1','311',1,'Retail Sale Id 1558',0.00,3439.40,690.00,4002.00,562.60,'2023-03-12 15:04:14'),(1496,'1','311',1,'Retail Sale Id 1559',0.00,1286.81,690.00,1497.30,210.49,'2023-03-12 15:05:38'),(1497,'1','311',1,'Retail Sale Id 1560',0.00,1719.70,690.00,2001.00,281.30,'2023-03-12 15:07:00'),(1498,'1','311',1,'Retail Sale Id 1561',0.00,5930.00,690.00,6900.00,970.00,'2023-03-12 15:07:55'),(1499,'1','311',1,'Retail Sale Id 1562',0.00,2579.55,690.00,3001.50,421.95,'2023-03-12 15:10:19'),(1500,'1','311',1,'Retail Sale Id 1563',0.00,1186.00,690.00,1380.00,194.00,'2023-03-12 15:11:40'),(1501,'1','311',1,'Retail Sale Id 1564',0.00,3558.00,690.00,4140.00,582.00,'2023-03-12 15:12:39'),(1502,'1','311',1,'Retail Sale Id 1565',0.00,1186.00,690.00,1380.00,194.00,'2023-03-12 15:16:20'),(1503,'1','311',1,'Retail Sale Id 1567',0.00,3558.00,690.00,4140.00,582.00,'2023-03-12 15:19:00'),(1504,'1','311',1,'Retail Sale Id 1568',0.00,7436.22,690.00,8652.60,1216.38,'2023-03-12 15:21:46'),(1505,'1','311',1,'Retail Sale Id 1569',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-12 15:35:22'),(1506,'1','311',1,'Retail Sale Id 1570',0.00,859.85,690.00,1000.50,140.65,'2023-03-12 15:37:05'),(1507,'1','311',1,'Retail Sale Id 1571',0.00,3558.00,690.00,4140.00,582.00,'2023-03-12 15:39:31'),(1508,'1','311',1,'Retail Sale Id 1572',0.00,4151.00,690.00,4830.00,679.00,'2023-03-12 15:44:13'),(1509,'1','311',1,'Retail Sale Id 1573',0.00,3611.37,690.00,4202.10,590.73,'2023-03-12 15:45:40'),(1510,'1','311',1,'Retail Sale Id 1574',0.00,1286.81,690.00,1497.30,210.49,'2023-03-12 15:47:43'),(1511,'1','311',1,'Retail Sale Id 1575',0.00,2579.55,690.00,3001.50,421.95,'2023-03-12 15:55:22'),(1512,'1','311',1,'Retail Sale Id 1576',0.00,1186.00,690.00,1380.00,194.00,'2023-03-12 15:57:12'),(1513,'1','311',1,'Retail Sale Id 1577',0.00,1186.00,690.00,1380.00,194.00,'2023-03-12 16:00:44'),(1514,'1','311',1,'Retail Sale Id 1579',0.00,598.93,690.00,696.90,97.97,'2023-03-12 16:04:27'),(1515,'1','311',1,'Retail Sale Id 1580',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-12 16:07:16'),(1516,'1','311',1,'Retail Sale Id 1581',0.00,4151.00,690.00,4830.00,679.00,'2023-03-12 16:09:17'),(1517,'1','311',1,'Retail Sale Id 1582',0.00,1482.50,690.00,1725.00,242.50,'2023-03-12 16:17:24'),(1518,'1','311',1,'Retail Sale Id 1583',0.00,1186.00,690.00,1380.00,194.00,'2023-03-12 16:18:09'),(1519,'1','311',1,'Retail Sale Id 1584',0.00,1286.81,690.00,1497.30,210.49,'2023-03-12 16:19:52'),(1520,'1','311',1,'Retail Sale Id 1585',0.00,5930.00,690.00,6900.00,970.00,'2023-03-12 16:26:48'),(1521,'1','311',1,'Retail Sale Id 1586',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 16:32:43'),(1522,'1','311',1,'Retail Sale Id 1587',0.00,4151.00,690.00,4830.00,679.00,'2023-03-12 16:34:51'),(1523,'1','311',1,'Retail Sale Id 1588',0.00,1186.00,690.00,1380.00,194.00,'2023-03-12 16:35:54'),(1524,'1','311',1,'Retail Sale Id 1589',0.00,1186.00,690.00,1380.00,194.00,'2023-03-12 16:37:00'),(1525,'1','311',1,'Retail Sale Id 1590',0.00,3558.00,690.00,4140.00,582.00,'2023-03-12 16:42:13'),(1526,'1','311',1,'Retail Sale Id 1591',0.00,598.93,690.00,696.90,97.97,'2023-03-12 16:44:09'),(1527,'1','311',1,'Retail Sale Id 1592',0.00,2965.00,690.00,3450.00,485.00,'2023-03-12 16:45:03'),(1528,'1','311',1,'Retail Sale Id 1593',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 16:46:24'),(1529,'1','311',1,'Retail Sale Id 1594',0.00,859.85,690.00,1000.50,140.65,'2023-03-12 16:50:21'),(1530,'1','311',1,'Retail Sale Id 1595',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-12 16:56:02'),(1531,'1','311',1,'Retail Sale Id 1596',0.00,598.93,690.00,696.90,97.97,'2023-03-12 16:57:49'),(1532,'1','311',1,'Retail Sale Id 1597',0.00,859.85,690.00,1000.50,140.65,'2023-03-12 17:05:19'),(1533,'1','311',1,'Retail Sale Id 1598',0.00,5337.00,690.00,6210.00,873.00,'2023-03-12 17:14:55'),(1534,'1','311',1,'Return of Retail Sale Id 1581',4151.00,0.00,690.00,-4830.00,-679.00,'2023-03-12 17:18:53'),(1535,'1','311',1,'Retail Sale Id 1599',0.00,3878.22,690.00,4512.60,634.38,'2023-03-12 17:20:02'),(1536,'1','311',1,'Retail Sale Id 1601',0.00,4151.00,690.00,4830.00,679.00,'2023-03-12 17:21:09'),(1537,'1','311',1,'Retail Sale Id 1516',0.00,593.00,690.00,690.00,97.00,'2023-03-12 17:23:30'),(1538,'1','311',1,'Retail Sale Id 1602',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 17:24:21'),(1539,'1','311',1,'Retail Sale Id 1603',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 17:28:41'),(1540,'1','311',1,'Retail Sale Id 1604',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 17:30:50'),(1541,'1','311',1,'Retail Sale Id 1605',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-12 17:36:03'),(1542,'1','311',1,'Retail Sale Id 1606',0.00,1286.81,690.00,1497.30,210.49,'2023-03-12 17:37:00'),(1543,'1','311',1,'Retail Sale Id 1607',0.00,3558.00,690.00,4140.00,582.00,'2023-03-12 17:41:01'),(1544,'1','311',1,'Retail Sale Id 1608',0.00,1891.67,690.00,2201.10,309.43,'2023-03-12 17:45:31'),(1545,'1','311',1,'Retail Sale Id 1609',0.00,1779.00,690.00,2070.00,291.00,'2023-03-12 17:47:04'),(1546,'1','311',1,'Retail Sale Id 1611',0.00,2965.00,690.00,3450.00,485.00,'2023-03-12 18:01:07'),(1547,'1','311',1,'Retail Sale Id 1612',0.00,5930.00,690.00,6900.00,970.00,'2023-03-12 18:03:20'),(1548,'1','311',1,'Retail Sale Id 1614',0.00,2372.00,690.00,2760.00,388.00,'2023-03-12 18:06:00'),(1549,'1','311',1,'Retail Sale Id 1615',0.00,1719.70,690.00,2001.00,281.30,'2023-03-12 18:08:56'),(1550,'1','311',1,'Retail Sale Id 1616',0.00,1203.79,690.00,1400.70,196.91,'2023-03-12 18:09:59'),(1551,'1','311',1,'Retail Sale Id 1617',0.00,1186.00,690.00,1380.00,194.00,'2023-03-12 18:14:21'),(1552,'1','311',1,'Retail Sale Id 1618',0.00,2407.58,690.00,2801.40,393.82,'2023-03-12 18:18:52'),(1553,'1','311',1,'Retail Sale Id 1619',0.00,34987.00,670.00,39530.00,4543.00,'2023-03-12 18:22:03'),(1554,'1','311',1,'Retail Sale Id 1620',0.00,2965.00,690.00,3450.00,485.00,'2023-03-12 18:24:08'),(1555,'1','311',1,'Retail Sale Id 1621',0.00,4151.00,690.00,4830.00,679.00,'2023-03-12 18:35:51'),(1556,'1','311',1,'Return of Retail Sale Id 1612',5930.00,0.00,690.00,-6900.00,-970.00,'2023-03-12 18:39:13'),(1557,'1','311',1,'Retail Sale Id 1622',0.00,5514.90,690.00,6417.00,902.10,'2023-03-12 18:39:57'),(1558,'1','311',1,'Return of Retail Sale Id 1509',5930.00,0.00,690.00,-6900.00,-970.00,'2023-03-12 18:48:26'),(1559,'1','311',1,'Retail Sale Id 1624',0.00,2579.55,690.00,3001.50,421.95,'2023-03-12 18:51:01'),(1560,'1','311',1,'Retail Sale Id 1625',0.00,6131.62,690.00,7134.60,1002.98,'2023-03-12 20:26:15'),(1561,'1','311',1,'Return of Retail Sale Id 1625',6131.62,0.00,690.00,-7134.60,-1002.98,'2023-03-12 20:29:05'),(1562,'1','311',1,'Retail Sale Id 1626',0.00,4370.41,690.00,5085.30,714.89,'2023-03-12 20:32:27'),(1563,'1','311',1,'Retail Sale Id 1627',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 08:17:39'),(1564,'1','311',1,'Retail Sale Id 1628',0.00,3558.00,690.00,4140.00,582.00,'2023-03-14 08:21:18'),(1565,'1','311',1,'Retail Sale Id 1629',0.00,2965.00,690.00,3450.00,485.00,'2023-03-14 08:22:13'),(1566,'1','311',1,'Retail Sale Id 1630',0.00,5930.00,690.00,6900.00,970.00,'2023-03-14 08:24:31'),(1567,'1','311',1,'Retail Sale Id 1631',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-14 08:25:27'),(1568,'1','311',1,'Retail Sale Id 1632',0.00,687.88,690.00,800.40,112.52,'2023-03-14 08:26:07'),(1569,'1','311',1,'Retail Sale Id 1633',0.00,3558.00,690.00,4140.00,582.00,'2023-03-14 08:27:34'),(1570,'1','311',1,'Retail Sale Id 1634',0.00,4151.00,690.00,4830.00,679.00,'2023-03-14 08:28:34'),(1571,'1','311',1,'Retail Sale Id 1636',0.00,1719.70,690.00,2001.00,281.30,'2023-03-14 08:29:34'),(1572,'1','311',1,'Retail Sale Id 1637',0.00,4744.00,690.00,5520.00,776.00,'2023-03-14 08:31:03'),(1573,'1','311',1,'Retail Sale Id 1638',0.00,3558.00,690.00,4140.00,582.00,'2023-03-14 08:31:49'),(1574,'1','311',1,'Retail Sale Id 1639',0.00,1186.00,690.00,1380.00,194.00,'2023-03-14 08:32:32'),(1575,'1','311',1,'Retail Sale Id 1640',0.00,2965.00,690.00,3450.00,485.00,'2023-03-14 08:34:21'),(1576,'1','311',1,'Retail Sale Id 1641',0.00,1719.70,690.00,2001.00,281.30,'2023-03-14 08:35:04'),(1577,'1','311',1,'Retail Sale Id 1642',0.00,4151.00,690.00,4830.00,679.00,'2023-03-14 08:35:55'),(1578,'1','311',1,'Retail Sale Id 1643',0.00,4151.00,690.00,4830.00,679.00,'2023-03-14 08:36:46'),(1579,'1','311',1,'Retail Sale Id 1644',0.00,859.85,690.00,1000.50,140.65,'2023-03-14 08:37:55'),(1580,'1','311',1,'Retail Sale Id 1645',0.00,3558.00,690.00,4140.00,582.00,'2023-03-14 08:38:39'),(1581,'1','311',1,'Return of Retail Sale Id 1637',4744.00,0.00,690.00,-5520.00,-776.00,'2023-03-14 08:40:20'),(1582,'1','311',1,'Retail Sale Id 1647',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 08:41:04'),(1583,'1','311',1,'Retail Sale Id 1648',0.00,4151.00,690.00,4830.00,679.00,'2023-03-14 08:41:49'),(1584,'1','311',1,'Retail Sale Id 1649',0.00,1802.72,690.00,2097.60,294.88,'2023-03-14 08:42:44'),(1585,'1','311',1,'Retail Sale Id 1650',0.00,4151.00,690.00,4830.00,679.00,'2023-03-14 08:43:33'),(1586,'1','311',1,'Retail Sale Id 1651',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-14 08:44:23'),(1587,'1','311',1,'Retail Sale Id 1652',0.00,5930.00,690.00,6900.00,970.00,'2023-03-14 08:45:19'),(1588,'1','311',1,'Retail Sale Id 1653',0.00,3558.00,690.00,4140.00,582.00,'2023-03-14 08:48:01'),(1589,'1','311',1,'Retail Sale Id 1654',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 08:48:51'),(1590,'1','311',1,'Retail Sale Id 1655',0.00,4151.00,690.00,4830.00,679.00,'2023-03-14 08:49:39'),(1591,'1','311',1,'Retail Sale Id 1657',0.00,4151.00,690.00,4830.00,679.00,'2023-03-14 08:50:58'),(1592,'1','311',1,'Retail Sale Id 1658',0.00,2372.00,690.00,2760.00,388.00,'2023-03-14 08:51:43'),(1593,'1','311',1,'Retail Sale Id 1656',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 08:52:13'),(1594,'1','311',1,'Retail Sale Id 1659',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 08:53:27'),(1595,'1','311',1,'Retail Sale Id 1660',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 08:55:49'),(1596,'1','311',1,'Retail Sale Id 1661',0.00,5930.00,690.00,6900.00,970.00,'2023-03-14 08:57:35'),(1597,'1','311',1,'Retail Sale Id 1662',0.00,4299.25,690.00,5002.50,703.25,'2023-03-14 08:58:53'),(1598,'1','311',1,'Retail Sale Id 1665',0.00,3558.00,690.00,4140.00,582.00,'2023-03-14 09:03:27'),(1599,'1','311',1,'Retail Sale Id 1667',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 09:06:13'),(1600,'1','311',1,'Retail Sale Id 1668',0.00,2965.00,690.00,3450.00,485.00,'2023-03-14 09:09:44'),(1601,'1','311',1,'Retail Sale Id 1669',0.00,1186.00,690.00,1380.00,194.00,'2023-03-14 09:11:19'),(1602,'1','311',1,'Retail Sale Id 1670',0.00,2372.00,690.00,2760.00,388.00,'2023-03-14 09:12:36'),(1603,'1','311',1,'Retail Sale Id 1671',0.00,4151.00,690.00,4830.00,679.00,'2023-03-14 09:18:01'),(1604,'1','311',1,'Retail Sale Id 1672',0.00,1719.70,690.00,2001.00,281.30,'2023-03-14 09:21:42'),(1605,'1','311',1,'Retail Sale Id 1673',0.00,3563.93,690.00,4146.90,582.97,'2023-03-14 09:29:58'),(1606,'1','311',1,'Retail Sale Id 1674',0.00,1719.70,690.00,2001.00,281.30,'2023-03-14 09:37:20'),(1607,'1','311',1,'Retail Sale Id 1675',0.00,1891.67,690.00,2201.10,309.43,'2023-03-14 09:41:12'),(1608,'1','311',1,'Retail Sale Id 1676',0.00,4744.00,690.00,5520.00,776.00,'2023-03-14 09:45:21'),(1609,'1','311',1,'Retail Sale Id 1678',0.00,1186.00,690.00,1380.00,194.00,'2023-03-14 09:52:58'),(1610,'1','311',1,'Retail Sale Id 1678',0.00,5930.00,690.00,6900.00,970.00,'2023-03-14 09:52:58'),(1611,'1','311',1,'Retail Sale Id 1679',0.00,7116.00,690.00,8280.00,1164.00,'2023-03-14 09:54:28'),(1612,'1','311',1,'Retail Sale Id 1680',0.00,4151.00,690.00,4830.00,679.00,'2023-03-14 09:55:44'),(1613,'1','311',1,'Retail Sale Id 1681',0.00,3558.00,690.00,4140.00,582.00,'2023-03-14 10:02:53'),(1614,'1','311',1,'Retail Sale Id 1682',0.00,4299.25,690.00,5002.50,703.25,'2023-03-14 10:04:51'),(1615,'1','311',1,'Retail Sale Id 1683',0.00,2372.00,690.00,2760.00,388.00,'2023-03-14 10:08:06'),(1616,'1','311',1,'Retail Sale Id 1684',0.00,2965.00,690.00,3450.00,485.00,'2023-03-14 10:16:07'),(1617,'1','311',1,'Retail Sale Id 1685',0.00,3558.00,690.00,4140.00,582.00,'2023-03-14 10:17:40'),(1618,'1','311',1,'Retail Sale Id 1686',0.00,420377.70,670.00,474963.00,54585.30,'2023-03-14 10:19:50'),(1619,'1','311',1,'Retail Sale Id 1687',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 10:20:51'),(1620,'1','311',1,'Retail Sale Id 1688',0.00,2372.00,690.00,2760.00,388.00,'2023-03-14 10:21:50'),(1621,'1','311',1,'Retail Sale Id 1689',0.00,1719.70,690.00,2001.00,281.30,'2023-03-14 10:23:06'),(1622,'1','311',1,'Retail Sale Id 1691',0.00,598.93,690.00,696.90,97.97,'2023-03-14 10:24:32'),(1623,'1','311',1,'Retail Sale Id 1692',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 10:35:55'),(1624,'1','311',1,'Retail Sale Id 1693',0.00,1186.00,690.00,1380.00,194.00,'2023-03-14 10:51:31'),(1625,'1','311',1,'Retail Sale Id 1695',0.00,3558.00,690.00,4140.00,582.00,'2023-03-14 11:07:48'),(1626,'1','311',1,'Retail Sale Id 1696',0.00,1719.70,690.00,2001.00,281.30,'2023-03-14 11:11:36'),(1627,'1','311',1,'Retail Sale Id 1697',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-14 11:13:13'),(1628,'1','311',1,'Retail Sale Id 1698',0.00,7116.00,690.00,8280.00,1164.00,'2023-03-14 11:18:54'),(1629,'1','311',1,'Retail Sale Id 1699',0.00,1203.79,690.00,1400.70,196.91,'2023-03-14 11:29:12'),(1630,'1','311',1,'Retail Sale Id 1700',0.00,1719.70,690.00,2001.00,281.30,'2023-03-14 11:29:59'),(1631,'1','311',1,'Retail Sale Id 1701',0.00,5930.00,690.00,6900.00,970.00,'2023-03-14 11:32:20'),(1632,'1','311',1,'Retail Sale Id 1702',0.00,1203.79,690.00,1400.70,196.91,'2023-03-14 11:33:07'),(1633,'1','311',1,'Retail Sale Id 1703',0.00,49219.00,670.00,55610.00,6391.00,'2023-03-14 11:34:41'),(1634,'1','311',1,'Retail Sale Id 1704',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-14 11:40:29'),(1635,'1','311',1,'Retail Sale Id 1705',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-14 11:42:41'),(1636,'1','311',1,'Retail Sale Id 1706',0.00,7116.00,690.00,8280.00,1164.00,'2023-03-14 11:44:01'),(1637,'1','311',1,'Retail Sale Id 1707',0.00,1186.00,690.00,1380.00,194.00,'2023-03-14 11:48:14'),(1638,'1','311',1,'Retail Sale Id 1708',0.00,3558.00,690.00,4140.00,582.00,'2023-03-14 11:55:14'),(1639,'1','311',1,'Retail Sale Id 1709',0.00,2407.58,690.00,2801.40,393.82,'2023-03-14 11:57:54'),(1640,'1','311',1,'Retail Sale Id 1710',0.00,2965.00,690.00,3450.00,485.00,'2023-03-14 11:58:37'),(1641,'1','311',1,'Retail Sale Id 1711',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 12:08:26'),(1642,'1','311',1,'Retail Sale Id 1712',0.00,2372.00,690.00,2760.00,388.00,'2023-03-14 12:09:46'),(1643,'1','311',1,'Retail Sale Id 1713',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 12:25:39'),(1644,'1','311',1,'Retail Sale Id 1714',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-14 12:28:49'),(1645,'1','311',1,'Retail Sale Id 1714',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-14 12:28:49'),(1646,'1','311',1,'Retail Sale Id 1715',0.00,118600.00,670.00,134000.00,15400.00,'2023-03-14 12:38:49'),(1647,'1','311',1,'Retail Sale Id 1716',0.00,2965.00,690.00,3450.00,485.00,'2023-03-14 12:40:36'),(1648,'1','311',1,'Retail Sale Id 1718',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 12:51:25'),(1649,'1','311',1,'Retail Sale Id 1719',0.00,2372.00,690.00,2760.00,388.00,'2023-03-14 12:59:07'),(1650,'1','311',1,'Retail Sale Id 1720',0.00,859.85,690.00,1000.50,140.65,'2023-03-14 12:59:50'),(1651,'1','311',1,'Retail Sale Id 1722',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 13:14:24'),(1652,'1','311',1,'Retail Sale Id 1723',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-14 13:18:23'),(1653,'1','311',1,'Retail Sale Id 1724',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-14 13:20:55'),(1654,'1','311',1,'Retail Sale Id 1725',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 13:22:27'),(1655,'1','311',1,'Retail Sale Id 1726',0.00,3558.00,690.00,4140.00,582.00,'2023-03-14 13:39:02'),(1656,'1','311',1,'Retail Sale Id 1727',0.00,4744.00,690.00,5520.00,776.00,'2023-03-14 13:43:12'),(1657,'1','311',1,'Retail Sale Id 1728',0.00,1186.00,690.00,1380.00,194.00,'2023-03-14 13:54:38'),(1658,'1','311',1,'Retail Sale Id 1729',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 13:58:03'),(1659,'1','311',1,'Retail Sale Id 1730',0.00,2965.00,690.00,3450.00,485.00,'2023-03-14 14:14:02'),(1660,'1','311',1,'Retail Sale Id 1730',0.00,7709.00,690.00,8970.00,1261.00,'2023-03-14 14:14:02'),(1661,'1','311',1,'Retail Sale Id 1731',0.00,859.85,690.00,1000.50,140.65,'2023-03-14 14:17:20'),(1662,'1','311',1,'Retail Sale Id 1732',0.00,3558.00,690.00,4140.00,582.00,'2023-03-14 14:18:21'),(1663,'1','311',1,'Retail Sale Id 1733',0.00,3558.00,690.00,4140.00,582.00,'2023-03-14 14:21:55'),(1664,'1','311',1,'Retail Sale Id 1734',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-14 14:22:57'),(1665,'1','311',1,'Retail Sale Id 1735',0.00,6523.00,690.00,7590.00,1067.00,'2023-03-14 14:23:46'),(1666,'1','311',1,'Retail Sale Id 1736',0.00,3558.00,690.00,4140.00,582.00,'2023-03-14 14:25:49'),(1667,'1','311',1,'Retail Sale Id 1737',0.00,1186.00,690.00,1380.00,194.00,'2023-03-14 14:27:33'),(1668,'1','311',1,'Retail Sale Id 1738',0.00,8895.00,690.00,10350.00,1455.00,'2023-03-14 14:28:33'),(1669,'1','311',1,'Retail Sale Id 1739',0.00,2579.55,690.00,3001.50,421.95,'2023-03-14 14:31:31'),(1670,'1','311',1,'Retail Sale Id 1740',0.00,4151.00,690.00,4830.00,679.00,'2023-03-14 14:37:21'),(1671,'1','311',1,'Retail Sale Id 1741',0.00,3558.00,690.00,4140.00,582.00,'2023-03-14 14:40:54'),(1672,'1','311',1,'Retail Sale Id 1742',0.00,4744.00,690.00,5520.00,776.00,'2023-03-14 14:44:52'),(1673,'1','311',1,'Retail Sale Id 1743',0.00,2965.00,690.00,3450.00,485.00,'2023-03-14 14:49:27'),(1674,'1','311',1,'Retail Sale Id 1744',0.00,2579.55,690.00,3001.50,421.95,'2023-03-14 15:00:02'),(1675,'1','311',1,'Retail Sale Id 1745',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 15:02:09'),(1676,'1','311',1,'Retail Sale Id 1746',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-14 15:20:07'),(1677,'1','311',1,'Retail Sale Id 1746',0.00,13639.00,690.00,15870.00,2231.00,'2023-03-14 15:20:07'),(1678,'1','311',1,'Retail Sale Id 1748',0.00,2965.00,690.00,3450.00,485.00,'2023-03-14 15:31:15'),(1679,'1','311',1,'Retail Sale Id 1749',0.00,4744.00,690.00,5520.00,776.00,'2023-03-14 15:31:49'),(1680,'1','311',1,'Retail Sale Id 1751',0.00,4744.00,690.00,5520.00,776.00,'2023-03-14 15:35:08'),(1681,'1','311',1,'Retail Sale Id 1753',0.00,3558.00,690.00,4140.00,582.00,'2023-03-14 15:38:07'),(1682,'1','311',1,'Retail Sale Id 1755',0.00,2372.00,690.00,2760.00,388.00,'2023-03-14 15:44:16'),(1683,'1','311',1,'Retail Sale Id 1756',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-14 15:45:11'),(1684,'1','311',1,'Retail Sale Id 1757',0.00,4151.00,690.00,4830.00,679.00,'2023-03-14 15:48:12'),(1685,'1','311',1,'Retail Sale Id 1758',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 15:49:16'),(1686,'1','311',1,'Retail Sale Id 1760',0.00,4168.79,690.00,4850.70,681.91,'2023-03-14 15:50:47'),(1687,'1','311',1,'Retail Sale Id 1761',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 15:52:10'),(1688,'1','311',1,'Retail Sale Id 1766',0.00,2372.00,690.00,2760.00,388.00,'2023-03-14 15:54:19'),(1689,'1','311',1,'Return of Retail Sale Id 1757',4151.00,0.00,690.00,-4830.00,-679.00,'2023-03-14 15:57:03'),(1690,'1','311',1,'Retail Sale Id 1767',0.00,3878.22,690.00,4512.60,634.38,'2023-03-14 15:59:06'),(1691,'1','311',1,'Retail Sale Id 1768',0.00,2965.00,690.00,3450.00,485.00,'2023-03-14 16:00:34'),(1692,'1','311',1,'Retail Sale Id 1769',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 16:01:33'),(1693,'1','311',1,'Retail Sale Id 1770',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 16:04:25'),(1694,'1','311',1,'Retail Sale Id 1771',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-14 16:05:08'),(1695,'1','311',1,'Retail Sale Id 1772',0.00,2965.00,690.00,3450.00,485.00,'2023-03-14 16:05:54'),(1696,'1','311',1,'Retail Sale Id 1775',0.00,1203.79,690.00,1400.70,196.91,'2023-03-14 16:08:35'),(1697,'1','311',1,'Retail Sale Id 1776',0.00,1286.81,690.00,1497.30,210.49,'2023-03-14 16:11:04'),(1698,'1','311',1,'Retail Sale Id 1777',0.00,3558.00,690.00,4140.00,582.00,'2023-03-14 16:11:53'),(1699,'1','311',1,'Retail Sale Id 1779',0.00,5930.00,690.00,6900.00,970.00,'2023-03-14 16:15:40'),(1700,'1','311',1,'Retail Sale Id 1780',0.00,1719.70,690.00,2001.00,281.30,'2023-03-14 16:16:31'),(1701,'1','311',1,'Retail Sale Id 1781',0.00,4151.00,690.00,4830.00,679.00,'2023-03-14 16:17:22'),(1702,'1','311',1,'Retail Sale Id 1782',0.00,2579.55,690.00,3001.50,421.95,'2023-03-14 16:18:48'),(1703,'1','311',1,'Retail Sale Id 1782',0.00,4299.25,690.00,5002.50,703.25,'2023-03-14 16:18:48'),(1704,'1','311',1,'Retail Sale Id 1783',0.00,4151.00,690.00,4830.00,679.00,'2023-03-14 16:19:46'),(1705,'1','311',1,'Retail Sale Id 1773',0.00,1482.50,690.00,1725.00,242.50,'2023-03-14 16:21:24'),(1706,'1','311',1,'Retail Sale Id 1784',0.00,2579.55,690.00,3001.50,421.95,'2023-03-14 16:22:26'),(1707,'1','311',1,'Retail Sale Id 1785',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-14 16:23:31'),(1708,'1','311',1,'Retail Sale Id 1786',0.00,3558.00,690.00,4140.00,582.00,'2023-03-14 16:25:25'),(1709,'1','311',1,'Retail Sale Id 1786',0.00,5930.00,690.00,6900.00,970.00,'2023-03-14 16:25:25'),(1710,'1','311',1,'Retail Sale Id 1787',0.00,4151.00,690.00,4830.00,679.00,'2023-03-14 16:26:35'),(1711,'1','311',1,'Retail Sale Id 1788',0.00,889.50,690.00,1035.00,145.50,'2023-03-14 16:37:38'),(1712,'1','311',1,'Retail Sale Id 1788',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-14 16:37:38'),(1713,'1','311',1,'Retail Sale Id 1791',0.00,1203.79,690.00,1400.70,196.91,'2023-03-14 16:39:32'),(1714,'1','311',1,'Retail Sale Id 1792',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 16:41:17'),(1715,'1','311',1,'Retail Sale Id 1793',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 16:44:28'),(1716,'1','311',1,'Retail Sale Id 1794',0.00,2965.00,690.00,3450.00,485.00,'2023-03-14 16:45:19'),(1717,'1','311',1,'Retail Sale Id 1789',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 16:46:06'),(1718,'1','311',1,'Retail Sale Id 1795',0.00,1186.00,690.00,1380.00,194.00,'2023-03-14 16:47:01'),(1719,'1','311',1,'Retail Sale Id 1797',0.00,1186.00,690.00,1380.00,194.00,'2023-03-14 16:50:48'),(1720,'1','311',1,'Retail Sale Id 1797',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 16:50:48'),(1721,'1','311',1,'Retail Sale Id 1798',0.00,2372.00,690.00,2760.00,388.00,'2023-03-14 16:54:03'),(1722,'1','311',1,'Retail Sale Id 1800',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 16:57:17'),(1723,'1','311',1,'Retail Sale Id 1801',0.00,1203.79,690.00,1400.70,196.91,'2023-03-14 17:02:08'),(1724,'1','311',1,'Retail Sale Id 1802',0.00,859.85,690.00,1000.50,140.65,'2023-03-14 17:04:03'),(1725,'1','311',1,'Retail Sale Id 1802',0.00,1719.70,690.00,2001.00,281.30,'2023-03-14 17:04:04'),(1726,'1','311',1,'Retail Sale Id 1803',0.00,2407.58,690.00,2801.40,393.82,'2023-03-14 17:06:33'),(1727,'1','311',1,'Return of Retail Sale Id 1802',859.85,0.00,690.00,-1000.50,-140.65,'2023-03-14 17:08:55'),(1728,'1','311',1,'Return of Retail Sale Id 1802',1719.70,0.00,690.00,-2001.00,-281.30,'2023-03-14 17:08:55'),(1729,'1','311',1,'Retail Sale Id 1804',0.00,1719.70,690.00,2001.00,281.30,'2023-03-14 17:10:13'),(1730,'1','311',1,'Retail Sale Id 1804',0.00,1719.70,690.00,2001.00,281.30,'2023-03-14 17:10:13'),(1731,'1','311',1,'Retail Sale Id 1805',0.00,1186.00,690.00,1380.00,194.00,'2023-03-14 17:12:36'),(1732,'1','311',1,'Retail Sale Id 1806',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 17:13:48'),(1733,'1','311',1,'Retail Sale Id 1807',0.00,2965.00,690.00,3450.00,485.00,'2023-03-14 17:15:21'),(1734,'1','311',1,'Retail Sale Id 1808',0.00,1186.00,690.00,1380.00,194.00,'2023-03-14 17:16:14'),(1735,'1','311',1,'Retail Sale Id 1809',0.00,859.85,690.00,1000.50,140.65,'2023-03-14 17:17:12'),(1736,'1','311',1,'Retail Sale Id 1810',0.00,2965.00,690.00,3450.00,485.00,'2023-03-14 17:19:45'),(1737,'1','311',1,'Retail Sale Id 1811',0.00,1186.00,690.00,1380.00,194.00,'2023-03-14 17:21:28'),(1738,'1','311',1,'Retail Sale Id 1812',0.00,1186.00,690.00,1380.00,194.00,'2023-03-14 17:22:59'),(1739,'1','311',1,'Retail Sale Id 1814',0.00,5930.00,690.00,6900.00,970.00,'2023-03-14 17:25:35'),(1740,'1','311',1,'Retail Sale Id 1815',0.00,2579.55,690.00,3001.50,421.95,'2023-03-14 17:26:33'),(1741,'1','311',1,'Retail Sale Id 1816',0.00,859.85,690.00,1000.50,140.65,'2023-03-14 17:27:30'),(1742,'1','311',1,'Retail Sale Id 1817',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 17:28:23'),(1743,'1','311',1,'Retail Sale Id 1818',0.00,2965.00,690.00,3450.00,485.00,'2023-03-14 17:30:32'),(1744,'1','311',1,'Retail Sale Id 1819',0.00,2965.00,690.00,3450.00,485.00,'2023-03-14 17:34:03'),(1745,'1','311',1,'Retail Sale Id 1820',0.00,1779.00,690.00,2070.00,291.00,'2023-03-14 17:35:14'),(1746,'1','311',1,'Retail Sale Id 1821',0.00,4151.00,690.00,4830.00,679.00,'2023-03-14 17:38:34'),(1747,'1','311',1,'Retail Sale Id 1822',0.00,2965.00,690.00,3450.00,485.00,'2023-03-14 17:39:34'),(1748,'1','311',1,'Retail Sale Id 1823',0.00,7116.00,690.00,8280.00,1164.00,'2023-03-14 17:41:11'),(1749,'1','311',1,'Retail Sale Id 1824',0.00,2075.50,690.00,2415.00,339.50,'2023-03-14 17:52:40'),(1750,'1','311',1,'Return of Retail Sale Id 1686',420377.70,0.00,670.00,-474963.00,-54585.30,'2023-03-14 18:19:36'),(1751,'1','311',1,'Retail Sale Id 1825',0.00,330775.40,670.00,373726.00,42950.60,'2023-03-14 18:23:51'),(1752,'1','311',1,'Retail Sale Id 1826',0.00,251971.63,670.00,284689.70,32718.07,'2023-03-14 18:27:29'),(1753,'1','311',1,'Return of Retail Sale Id 1788',889.50,0.00,690.00,-1035.00,-145.50,'2023-03-14 18:32:54'),(1754,'1','311',1,'Return of Retail Sale Id 1788',7412.50,0.00,690.00,-8625.00,-1212.50,'2023-03-14 18:32:54'),(1755,'1','311',1,'Return of Retail Sale Id 1823',7116.00,0.00,690.00,-8280.00,-1164.00,'2023-03-14 18:34:22'),(1756,'1','311',1,'Return of Retail Sale Id 1814',5930.00,0.00,690.00,-6900.00,-970.00,'2023-03-14 18:35:48'),(1757,'1','311',1,'Return of Retail Sale Id 1821',4151.00,0.00,690.00,-4830.00,-679.00,'2023-03-14 18:37:45'),(1758,'1','311',1,'Retail Sale Id 1827',0.00,2549.90,690.00,2967.00,417.10,'2023-03-14 18:38:29'),(1759,'1','311',1,'Retail Sale Id 1829',0.00,859.85,690.00,1000.50,140.65,'2023-03-15 08:01:57'),(1760,'1','311',1,'Retail Sale Id 1828',0.00,3558.00,690.00,4140.00,582.00,'2023-03-15 08:03:32'),(1761,'1','311',1,'Retail Sale Id 1830',0.00,1779.00,690.00,2070.00,291.00,'2023-03-15 08:12:47'),(1762,'1','311',1,'Retail Sale Id 1830',0.00,5930.00,690.00,6900.00,970.00,'2023-03-15 08:12:47'),(1763,'1','311',1,'Retail Sale Id 1831',0.00,1779.00,690.00,2070.00,291.00,'2023-03-15 08:14:20'),(1764,'1','311',1,'Retail Sale Id 1832',0.00,4299.25,690.00,5002.50,703.25,'2023-03-15 08:15:40'),(1765,'1','311',1,'Retail Sale Id 1833',0.00,6013.02,690.00,6996.60,983.58,'2023-03-15 08:16:55'),(1766,'1','311',1,'Retail Sale Id 1834',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-15 08:19:21'),(1767,'1','311',1,'Retail Sale Id 1835',0.00,5930.00,690.00,6900.00,970.00,'2023-03-15 08:20:31'),(1768,'1','311',1,'Retail Sale Id 1836',0.00,2965.00,690.00,3450.00,485.00,'2023-03-15 08:23:02'),(1769,'1','311',1,'Retail Sale Id 1837',0.00,1186.00,690.00,1380.00,194.00,'2023-03-15 08:27:06'),(1770,'1','311',1,'Retail Sale Id 1838',0.00,1162.28,690.00,1352.40,190.12,'2023-03-15 08:28:31'),(1771,'1','311',1,'Retail Sale Id 1839',0.00,2318.63,690.00,2697.90,379.27,'2023-03-15 08:36:22'),(1772,'1','311',1,'Retail Sale Id 1840',0.00,1186.00,690.00,1380.00,194.00,'2023-03-15 08:38:30'),(1773,'1','311',1,'Retail Sale Id 1841',0.00,118600.00,670.00,134000.00,15400.00,'2023-03-15 08:44:35'),(1774,'1','311',1,'Retail Sale Id 1842',0.00,1779.00,690.00,2070.00,291.00,'2023-03-15 08:45:10'),(1775,'1','311',1,'Retail Sale Id 1843',0.00,2965.00,690.00,3450.00,485.00,'2023-03-15 08:45:45'),(1776,'1','311',1,'Retail Sale Id 1844',0.00,859.85,690.00,1000.50,140.65,'2023-03-15 08:46:41'),(1777,'1','311',1,'Retail Sale Id 1845',0.00,4299.25,690.00,5002.50,703.25,'2023-03-15 08:50:35'),(1778,'1','311',1,'Retail Sale Id 1846',0.00,1719.70,690.00,2001.00,281.30,'2023-03-15 08:52:31'),(1779,'1','311',1,'Retail Sale Id 1847',0.00,1375.76,690.00,1600.80,225.04,'2023-03-15 08:53:59'),(1780,'1','311',1,'Retail Sale Id 1848',0.00,4151.00,690.00,4830.00,679.00,'2023-03-15 09:02:56'),(1781,'1','311',1,'Retail Sale Id 1849',0.00,5337.00,690.00,6210.00,873.00,'2023-03-15 09:06:01'),(1782,'1','311',1,'Retail Sale Id 1850',0.00,2372.00,690.00,2760.00,388.00,'2023-03-15 09:10:35'),(1783,'1','311',1,'Retail Sale Id 1851',0.00,1203.79,690.00,1400.70,196.91,'2023-03-15 09:12:58'),(1784,'1','311',1,'Retail Sale Id 1852',0.00,2372.00,690.00,2760.00,388.00,'2023-03-15 09:22:13'),(1785,'1','311',1,'Retail Sale Id 1853',0.00,1186.00,690.00,1380.00,194.00,'2023-03-15 09:23:03'),(1786,'1','311',1,'Retail Sale Id 1854',0.00,3558.00,690.00,4140.00,582.00,'2023-03-15 09:23:59'),(1787,'1','311',1,'Retail Sale Id 1855',0.00,2579.55,690.00,3001.50,421.95,'2023-03-15 09:32:00'),(1788,'1','311',1,'Retail Sale Id 1856',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-15 09:37:16'),(1789,'1','311',1,'Retail Sale Id 1857',0.00,2372.00,690.00,2760.00,388.00,'2023-03-15 09:38:53'),(1790,'1','311',1,'Retail Sale Id 1858',0.00,2372.00,690.00,2760.00,388.00,'2023-03-15 10:08:29'),(1791,'1','311',1,'Retail Sale Id 1860',0.00,1286.81,690.00,1497.30,210.49,'2023-03-15 10:32:19'),(1792,'1','311',1,'Retail Sale Id 1860',0.00,1719.70,690.00,2001.00,281.30,'2023-03-15 10:32:19'),(1793,'1','311',1,'Retail Sale Id 1859',0.00,34987.00,670.00,39530.00,4543.00,'2023-03-15 10:33:58'),(1794,'1','311',1,'Retail Sale Id 1861',0.00,1779.00,690.00,2070.00,291.00,'2023-03-15 10:35:25'),(1795,'1','311',1,'Retail Sale Id 1863',0.00,5930.00,690.00,6900.00,970.00,'2023-03-15 10:46:45'),(1796,'1','311',1,'Retail Sale Id 1865',0.00,3558.00,690.00,4140.00,582.00,'2023-03-15 11:03:35'),(1797,'1','311',1,'Retail Sale Id 1866',0.00,4151.00,690.00,4830.00,679.00,'2023-03-15 11:09:57'),(1798,'1','311',1,'Retail Sale Id 1867',0.00,1186.00,690.00,1380.00,194.00,'2023-03-15 11:12:51'),(1799,'1','311',1,'Retail Sale Id 1872',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-15 11:39:48'),(1800,'1','311',1,'Retail Sale Id 1873',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-15 11:49:27'),(1801,'1','311',1,'Retail Sale Id 1874',0.00,1779.00,690.00,2070.00,291.00,'2023-03-15 11:50:47'),(1802,'1','311',1,'Retail Sale Id 1875',0.00,3558.00,690.00,4140.00,582.00,'2023-03-15 11:52:22'),(1803,'1','311',1,'Retail Sale Id 1876',0.00,2965.00,690.00,3450.00,485.00,'2023-03-15 12:15:47'),(1804,'1','311',1,'Retail Sale Id 1877',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-15 12:23:09'),(1805,'1','311',1,'Retail Sale Id 1879',0.00,3439.40,690.00,4002.00,562.60,'2023-03-15 12:50:15'),(1806,'1','311',1,'Return of Retail Sale Id 1879',3439.40,0.00,690.00,-4002.00,-562.60,'2023-03-15 12:52:03'),(1807,'1','311',1,'Retail Sale Id 1880',0.00,3439.40,690.00,4002.00,562.60,'2023-03-15 12:52:36'),(1808,'1','311',1,'Retail Sale Id 1882',0.00,5930.00,690.00,6900.00,970.00,'2023-03-15 13:07:44'),(1809,'1','311',1,'Retail Sale Id 1883',0.00,2965.00,690.00,3450.00,485.00,'2023-03-15 13:20:15'),(1810,'1','311',1,'Retail Sale Id 1884',0.00,4151.00,690.00,4830.00,679.00,'2023-03-15 13:46:34'),(1811,'1','311',1,'Retail Sale Id 1884',0.00,4151.00,690.00,4830.00,679.00,'2023-03-15 13:46:34'),(1812,'1','311',1,'Retail Sale Id 1885',0.00,2965.00,690.00,3450.00,485.00,'2023-03-15 13:48:56'),(1813,'1','311',1,'Retail Sale Id 1886',0.00,2965.00,690.00,3450.00,485.00,'2023-03-15 14:38:55'),(1814,'1','311',1,'Retail Sale Id 1887',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-15 14:39:53'),(1815,'1','311',1,'Retail Sale Id 1888',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-15 14:41:13'),(1816,'1','311',1,'Retail Sale Id 1890',0.00,2372.00,690.00,2760.00,388.00,'2023-03-15 14:47:09'),(1817,'1','311',1,'Retail Sale Id 1891',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-15 14:50:24'),(1818,'1','311',1,'Retail Sale Id 1892',0.00,1186.00,690.00,1380.00,194.00,'2023-03-15 14:51:59'),(1819,'1','311',1,'Retail Sale Id 1894',0.00,1186.00,690.00,1380.00,194.00,'2023-03-15 14:54:28'),(1820,'1','311',1,'Retail Sale Id 1895',0.00,5930.00,690.00,6900.00,970.00,'2023-03-15 14:56:22'),(1821,'1','311',1,'Retail Sale Id 1896',0.00,3558.00,690.00,4140.00,582.00,'2023-03-15 14:58:03'),(1822,'1','311',1,'Retail Sale Id 1897',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-15 15:21:28'),(1823,'1','311',1,'Retail Sale Id 1899',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-15 15:43:50'),(1824,'1','311',1,'Retail Sale Id 1900',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-15 15:45:01'),(1825,'1','311',1,'Retail Sale Id 1901',0.00,2965.00,690.00,3450.00,485.00,'2023-03-15 15:46:13'),(1826,'1','311',1,'Retail Sale Id 1903',0.00,1458.78,690.00,1697.40,238.62,'2023-03-15 15:56:55'),(1827,'1','311',1,'Retail Sale Id 1904',0.00,2965.00,690.00,3450.00,485.00,'2023-03-15 16:00:50'),(1828,'1','311',1,'Retail Sale Id 1905',0.00,3439.40,690.00,4002.00,562.60,'2023-03-15 16:02:05'),(1829,'1','311',1,'Retail Sale Id 1906',0.00,859.85,690.00,1000.50,140.65,'2023-03-15 16:03:57'),(1830,'1','311',1,'Retail Sale Id 1907',0.00,1031.82,690.00,1200.60,168.78,'2023-03-15 16:10:25'),(1831,'1','311',1,'Retail Sale Id 1908',0.00,1186.00,690.00,1380.00,194.00,'2023-03-15 16:12:09'),(1832,'1','311',1,'Retail Sale Id 1909',0.00,859.85,690.00,1000.50,140.65,'2023-03-15 16:19:43'),(1833,'1','311',1,'Retail Sale Id 1910',0.00,5930.00,690.00,6900.00,970.00,'2023-03-15 16:20:53'),(1834,'1','311',1,'Retail Sale Id 1911',0.00,1779.00,690.00,2070.00,291.00,'2023-03-15 16:22:09'),(1835,'1','311',1,'Retail Sale Id 1912',0.00,2965.00,690.00,3450.00,485.00,'2023-03-15 16:25:37'),(1836,'1','311',1,'Retail Sale Id 1913',0.00,3558.00,690.00,4140.00,582.00,'2023-03-15 16:26:52'),(1837,'1','311',1,'Retail Sale Id 1914',0.00,3006.51,690.00,3498.30,491.79,'2023-03-15 16:28:25'),(1838,'1','311',1,'Retail Sale Id 1915',0.00,1779.00,690.00,2070.00,291.00,'2023-03-15 16:29:50'),(1839,'1','311',1,'Retail Sale Id 1916',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-15 16:31:57'),(1840,'1','311',1,'Retail Sale Id 1917',0.00,1186.00,690.00,1380.00,194.00,'2023-03-15 16:33:03'),(1841,'1','311',1,'Retail Sale Id 1918',0.00,1779.00,690.00,2070.00,291.00,'2023-03-15 16:33:51'),(1842,'1','311',1,'Retail Sale Id 1919',0.00,1779.00,690.00,2070.00,291.00,'2023-03-15 16:34:30'),(1843,'1','311',1,'Retail Sale Id 1920',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-15 16:37:01'),(1844,'1','311',1,'Retail Sale Id 1921',0.00,859.85,690.00,1000.50,140.65,'2023-03-15 16:38:19'),(1845,'1','311',1,'Retail Sale Id 1922',0.00,2965.00,690.00,3450.00,485.00,'2023-03-15 16:40:25'),(1846,'1','311',1,'Retail Sale Id 1923',0.00,2579.55,690.00,3001.50,421.95,'2023-03-15 16:43:13'),(1847,'1','311',1,'Retail Sale Id 1924',0.00,5930.00,690.00,6900.00,970.00,'2023-03-15 16:47:03'),(1848,'1','311',1,'Retail Sale Id 1924',0.00,5930.00,690.00,6900.00,970.00,'2023-03-15 16:47:03'),(1849,'1','311',1,'Retail Sale Id 1925',0.00,2965.00,690.00,3450.00,485.00,'2023-03-15 16:49:24'),(1850,'1','311',1,'Retail Sale Id 1926',0.00,2965.00,690.00,3450.00,485.00,'2023-03-15 16:52:11'),(1851,'1','311',1,'Retail Sale Id 1927',0.00,1779.00,690.00,2070.00,291.00,'2023-03-15 16:53:59'),(1852,'1','311',1,'Retail Sale Id 1928',0.00,2372.00,690.00,2760.00,388.00,'2023-03-15 16:58:34'),(1853,'1','311',1,'Retail Sale Id 1929',0.00,1286.81,690.00,1497.30,210.49,'2023-03-15 17:02:08'),(1854,'1','311',1,'Retail Sale Id 1930',0.00,859.85,690.00,1000.50,140.65,'2023-03-15 17:03:31'),(1855,'1','311',1,'Retail Sale Id 1931',0.00,5159.10,690.00,6003.00,843.90,'2023-03-15 17:07:41'),(1856,'1','311',1,'Retail Sale Id 1933',0.00,9784.50,690.00,11385.00,1600.50,'2023-03-15 17:37:28'),(1857,'1','311',1,'Retail Sale Id 1934',0.00,7709.00,690.00,8970.00,1261.00,'2023-03-15 17:38:26'),(1858,'1','311',1,'Retail Sale Id 1935',0.00,2318.63,690.00,2697.90,379.27,'2023-03-15 17:40:03'),(1859,'1','311',1,'Retail Sale Id 1935',0.00,4744.00,690.00,5520.00,776.00,'2023-03-15 17:40:03'),(1860,'1','311',1,'Return of Retail Sale Id 1933',9784.50,0.00,690.00,-11385.00,-1600.50,'2023-03-15 17:45:23'),(1861,'1','311',1,'Retail Sale Id 1936',0.00,6594.16,690.00,7672.80,1078.64,'2023-03-15 17:46:10'),(1862,'1','311',1,'Retail Sale Id 1937',0.00,3854.50,690.00,4485.00,630.50,'2023-03-16 08:07:11'),(1863,'1','311',1,'Retail Sale Id 1938',0.00,1779.00,690.00,2070.00,291.00,'2023-03-16 08:19:46'),(1864,'1','311',1,'Retail Sale Id 1939',0.00,2965.00,690.00,3450.00,485.00,'2023-03-16 08:23:44'),(1865,'1','311',1,'Retail Sale Id 1940',0.00,2965.00,690.00,3450.00,485.00,'2023-03-16 08:27:29'),(1866,'1','311',1,'Retail Sale Id 1940',0.00,2965.00,690.00,3450.00,485.00,'2023-03-16 08:27:29'),(1867,'1','311',1,'Retail Sale Id 1941',0.00,2318.63,690.00,2697.90,379.27,'2023-03-16 08:28:46'),(1868,'1','311',1,'Retail Sale Id 1943',0.00,598.93,690.00,696.90,97.97,'2023-03-16 08:31:11'),(1869,'1','311',1,'Retail Sale Id 1945',0.00,859.85,690.00,1000.50,140.65,'2023-03-16 08:32:50'),(1870,'1','311',1,'Retail Sale Id 1946',0.00,2146.66,690.00,2497.80,351.14,'2023-03-16 08:34:13'),(1871,'1','311',1,'Retail Sale Id 1947',0.00,2965.00,690.00,3450.00,485.00,'2023-03-16 08:37:36'),(1872,'1','311',1,'Retail Sale Id 1948',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-16 08:40:01'),(1873,'1','311',1,'Retail Sale Id 1949',0.00,6523.00,690.00,7590.00,1067.00,'2023-03-16 08:41:35'),(1874,'1','311',1,'Retail Sale Id 1950',0.00,1779.00,690.00,2070.00,291.00,'2023-03-16 08:47:18'),(1875,'1','311',1,'Retail Sale Id 1951',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-16 08:48:30'),(1876,'1','311',1,'Retail Sale Id 1952',0.00,1286.81,690.00,1497.30,210.49,'2023-03-16 08:52:58'),(1877,'1','311',1,'Return of Retail Sale Id 1946',2146.66,0.00,690.00,-2497.80,-351.14,'2023-03-16 08:59:08'),(1878,'1','311',1,'Return of Retail Sale Id 1941',2318.63,0.00,690.00,-2697.90,-379.27,'2023-03-16 09:00:08'),(1879,'1','311',1,'Retail Sale Id 1953',0.00,2579.55,690.00,3001.50,421.95,'2023-03-16 09:03:15'),(1880,'1','311',1,'Retail Sale Id 1954',0.00,3439.40,690.00,4002.00,562.60,'2023-03-16 09:10:39'),(1881,'1','311',1,'Retail Sale Id 1955',0.00,2372.00,690.00,2760.00,388.00,'2023-03-16 09:12:12'),(1882,'1','311',1,'Retail Sale Id 1956',0.00,1203.79,690.00,1400.70,196.91,'2023-03-16 09:13:00'),(1883,'1','311',1,'Retail Sale Id 1957',0.00,5930.00,690.00,6900.00,970.00,'2023-03-16 09:13:55'),(1884,'1','311',1,'Retail Sale Id 1958',0.00,1286.81,690.00,1497.30,210.49,'2023-03-16 09:30:39'),(1885,'1','311',1,'Retail Sale Id 1959',0.00,593.00,690.00,690.00,97.00,'2023-03-16 09:32:15'),(1886,'1','311',1,'Retail Sale Id 1960',0.00,3558.00,690.00,4140.00,582.00,'2023-03-16 09:35:22'),(1887,'1','311',1,'Retail Sale Id 1961',0.00,593.00,690.00,690.00,97.00,'2023-03-16 09:36:53'),(1888,'1','311',1,'Retail Sale Id 1962',0.00,2075.50,690.00,2415.00,339.50,'2023-03-16 09:39:11'),(1889,'1','311',1,'Retail Sale Id 1963',0.00,2372.00,690.00,2760.00,388.00,'2023-03-16 09:44:43'),(1890,'1','311',1,'Retail Sale Id 1964',0.00,34987.00,670.00,39530.00,4543.00,'2023-03-16 09:46:22'),(1891,'1','311',1,'Retail Sale Id 1965',0.00,1719.70,690.00,2001.00,281.30,'2023-03-16 09:57:52'),(1892,'1','311',1,'Retail Sale Id 1966',0.00,2965.00,690.00,3450.00,485.00,'2023-03-16 10:02:36'),(1893,'1','311',1,'Retail Sale Id 1967',0.00,2965.00,690.00,3450.00,485.00,'2023-03-16 10:17:25'),(1894,'1','311',1,'Retail Sale Id 1968',0.00,3558.00,690.00,4140.00,582.00,'2023-03-16 10:21:07'),(1895,'1','311',1,'Retail Sale Id 1968',0.00,4151.00,690.00,4830.00,679.00,'2023-03-16 10:21:07'),(1896,'1','311',1,'Retail Sale Id 1968',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-16 10:21:07'),(1897,'1','311',1,'Retail Sale Id 1969',0.00,4744.00,690.00,5520.00,776.00,'2023-03-16 10:29:38'),(1898,'1','311',1,'Retail Sale Id 1970',0.00,3854.50,690.00,4485.00,630.50,'2023-03-16 10:31:04'),(1899,'1','311',1,'Retail Sale Id 1971',0.00,3558.00,690.00,4140.00,582.00,'2023-03-16 10:32:36'),(1900,'1','311',1,'Retail Sale Id 1972',0.00,1719.70,690.00,2001.00,281.30,'2023-03-16 10:42:13'),(1901,'1','311',1,'Retail Sale Id 1973',0.00,2965.00,690.00,3450.00,485.00,'2023-03-16 10:43:11'),(1902,'1','311',1,'Retail Sale Id 1975',0.00,59300.00,670.00,67000.00,7700.00,'2023-03-16 10:57:19'),(1903,'1','311',1,'Retail Sale Id 1976',0.00,2579.55,690.00,3001.50,421.95,'2023-03-16 11:03:00'),(1904,'1','311',1,'Retail Sale Id 1977',0.00,2965.00,690.00,3450.00,485.00,'2023-03-16 11:04:32'),(1905,'1','311',1,'Return of Retail Sale Id 1975',59300.00,0.00,670.00,-67000.00,-7700.00,'2023-03-16 11:12:36'),(1906,'1','311',1,'Retail Sale Id 1978',0.00,29650.00,670.00,33500.00,3850.00,'2023-03-16 11:13:38'),(1907,'1','311',1,'Retail Sale Id 1979',0.00,29650.00,670.00,33500.00,3850.00,'2023-03-16 11:14:43'),(1908,'1','311',1,'Retail Sale Id 1980',0.00,34293.19,670.00,38746.10,4452.91,'2023-03-16 11:31:29'),(1909,'1','311',1,'Retail Sale Id 1982',0.00,1186.00,690.00,1380.00,194.00,'2023-03-16 11:48:42'),(1910,'1','311',1,'Retail Sale Id 1983',0.00,1719.70,690.00,2001.00,281.30,'2023-03-16 11:50:01'),(1911,'1','311',1,'Retail Sale Id 1984',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-16 12:01:57'),(1912,'1','311',1,'Retail Sale Id 1985',0.00,4151.00,690.00,4830.00,679.00,'2023-03-16 12:07:14'),(1913,'1','311',1,'Retail Sale Id 1986',0.00,1203.79,690.00,1400.70,196.91,'2023-03-16 12:08:29'),(1914,'1','311',1,'Retail Sale Id 1987',0.00,2965.00,690.00,3450.00,485.00,'2023-03-16 12:28:51'),(1915,'1','311',1,'Retail Sale Id 1988',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-16 12:33:33'),(1916,'1','311',1,'Retail Sale Id 1989',0.00,4151.00,690.00,4830.00,679.00,'2023-03-16 12:35:21'),(1917,'1','311',1,'Retail Sale Id 1990',0.00,4151.00,690.00,4830.00,679.00,'2023-03-16 12:37:58'),(1918,'1','311',1,'Retail Sale Id 1991',0.00,859.85,690.00,1000.50,140.65,'2023-03-16 12:40:40'),(1919,'1','311',1,'Retail Sale Id 1991',0.00,1779.00,690.00,2070.00,291.00,'2023-03-16 12:40:40'),(1920,'1','311',1,'Return of Retail Sale Id 1989',4151.00,0.00,690.00,-4830.00,-679.00,'2023-03-16 12:46:28'),(1921,'1','311',1,'Retail Sale Id 1992',0.00,2965.00,690.00,3450.00,485.00,'2023-03-16 12:47:17'),(1922,'1','311',1,'Retail Sale Id 1993',0.00,1779.00,690.00,2070.00,291.00,'2023-03-16 12:51:09'),(1923,'1','311',1,'Retail Sale Id 1994',0.00,2579.55,690.00,3001.50,421.95,'2023-03-16 12:52:43'),(1924,'1','311',1,'Retail Sale Id 1996',0.00,2407.58,690.00,2801.40,393.82,'2023-03-16 13:21:45'),(1925,'1','311',1,'Retail Sale Id 1997',0.00,2372.00,690.00,2760.00,388.00,'2023-03-16 13:42:52'),(1926,'1','311',1,'Retail Sale Id 1998',0.00,4744.00,690.00,5520.00,776.00,'2023-03-16 13:47:38'),(1927,'1','311',1,'Retail Sale Id 1999',0.00,5930.00,690.00,6900.00,970.00,'2023-03-16 13:50:28'),(1928,'1','311',1,'Retail Sale Id 2000',0.00,1779.00,690.00,2070.00,291.00,'2023-03-16 13:51:50'),(1929,'1','311',1,'Retail Sale Id 2002',0.00,3854.50,690.00,4485.00,630.50,'2023-03-16 14:17:46'),(1930,'1','311',1,'Retail Sale Id 2003',0.00,2965.00,690.00,3450.00,485.00,'2023-03-16 14:22:24'),(1931,'1','311',1,'Retail Sale Id 2005',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-16 14:31:05'),(1932,'1','311',1,'Retail Sale Id 2006',0.00,2372.00,690.00,2760.00,388.00,'2023-03-16 14:37:01'),(1933,'1','311',1,'Retail Sale Id 2007',0.00,1779.00,690.00,2070.00,291.00,'2023-03-16 14:37:34'),(1934,'1','311',1,'Retail Sale Id 2008',0.00,1779.00,690.00,2070.00,291.00,'2023-03-16 14:44:22'),(1935,'1','311',1,'Retail Sale Id 2009',0.00,3558.00,690.00,4140.00,582.00,'2023-03-16 15:00:26'),(1936,'1','311',1,'Retail Sale Id 2010',0.00,1719.70,690.00,2001.00,281.30,'2023-03-16 15:04:01'),(1937,'1','311',1,'Retail Sale Id 2011',0.00,2965.00,690.00,3450.00,485.00,'2023-03-16 15:09:23'),(1938,'1','311',1,'Retail Sale Id 2012',0.00,1779.00,690.00,2070.00,291.00,'2023-03-16 15:25:44'),(1939,'1','311',1,'Retail Sale Id 2013',0.00,4151.00,690.00,4830.00,679.00,'2023-03-16 15:46:58'),(1940,'1','311',1,'Retail Sale Id 2014',0.00,593.00,690.00,690.00,97.00,'2023-03-16 15:59:54'),(1941,'1','311',1,'Retail Sale Id 2016',0.00,3558.00,690.00,4140.00,582.00,'2023-03-16 16:06:41'),(1942,'1','311',1,'Retail Sale Id 2017',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-16 16:08:42'),(1943,'1','311',1,'Retail Sale Id 2017',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-16 16:08:42'),(1944,'1','311',1,'Retail Sale Id 2018',0.00,3558.00,690.00,4140.00,582.00,'2023-03-16 16:09:15'),(1945,'1','311',1,'Retail Sale Id 2019',0.00,2965.00,690.00,3450.00,485.00,'2023-03-16 16:10:09'),(1946,'1','311',1,'Retail Sale Id 2020',0.00,3558.00,690.00,4140.00,582.00,'2023-03-16 16:12:44'),(1947,'1','311',1,'Retail Sale Id 2021',0.00,1784.93,690.00,2076.90,291.97,'2023-03-16 16:16:16'),(1948,'1','311',1,'Retail Sale Id 2015',0.00,5930.00,690.00,6900.00,970.00,'2023-03-16 16:21:49'),(1949,'1','311',1,'Retail Sale Id 2022',0.00,3558.00,690.00,4140.00,582.00,'2023-03-16 16:29:51'),(1950,'1','311',1,'Retail Sale Id 2023',0.00,3439.40,690.00,4002.00,562.60,'2023-03-16 16:37:10'),(1951,'1','311',1,'Retail Sale Id 2024',0.00,1779.00,690.00,2070.00,291.00,'2023-03-16 16:42:55'),(1952,'1','311',1,'Retail Sale Id 2025',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-16 16:45:16'),(1953,'1','311',1,'Retail Sale Id 2026',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-16 16:46:32'),(1954,'1','311',1,'Retail Sale Id 2027',0.00,3558.00,690.00,4140.00,582.00,'2023-03-16 16:52:14'),(1955,'1','311',1,'Retail Sale Id 2028',0.00,2579.55,690.00,3001.50,421.95,'2023-03-16 16:55:48'),(1956,'1','311',1,'Retail Sale Id 2029',0.00,1779.00,690.00,2070.00,291.00,'2023-03-16 17:15:33'),(1957,'1','311',1,'Retail Sale Id 2030',0.00,859.85,690.00,1000.50,140.65,'2023-03-16 17:17:25'),(1958,'1','311',1,'Retail Sale Id 2031',0.00,4151.00,690.00,4830.00,679.00,'2023-03-16 17:18:26'),(1959,'1','311',1,'Retail Sale Id 2032',0.00,1186.00,690.00,1380.00,194.00,'2023-03-16 17:19:50'),(1960,'1','311',1,'Retail Sale Id 2033',0.00,3558.00,690.00,4140.00,582.00,'2023-03-16 17:20:58'),(1961,'1','311',1,'Retail Sale Id 2034',0.00,1186.00,690.00,1380.00,194.00,'2023-03-16 17:23:06'),(1962,'1','311',1,'Retail Sale Id 2035',0.00,2372.00,690.00,2760.00,388.00,'2023-03-16 17:24:22'),(1963,'1','311',1,'Retail Sale Id 2036',0.00,4151.00,690.00,4830.00,679.00,'2023-03-16 17:26:43'),(1964,'1','311',1,'Retail Sale Id 2037',0.00,4299.25,690.00,5002.50,703.25,'2023-03-16 17:27:58'),(1965,'1','311',1,'Return of Retail Sale Id 1980',34293.19,0.00,670.00,-38746.10,-4452.91,'2023-03-16 18:06:32'),(1966,'1','311',1,'Retail Sale Id 2038',0.00,34394.00,670.00,38860.00,4466.00,'2023-03-16 18:09:45'),(1967,'1','311',1,'Return of Retail Sale Id 1978',29650.00,0.00,670.00,-33500.00,-3850.00,'2023-03-16 18:11:51'),(1968,'1','311',1,'Retail Sale Id 2039',0.00,29039.21,670.00,32809.90,3770.69,'2023-03-16 18:13:05'),(1969,'1','311',1,'Return of Retail Sale Id 2012',1779.00,0.00,690.00,-2070.00,-291.00,'2023-03-16 21:44:22'),(1970,'1','311',1,'Return of Retail Sale Id 2039',29039.21,0.00,670.00,-32809.90,-3770.69,'2023-03-16 21:55:29'),(1971,'1','311',1,'Retail Sale Id 2040',0.00,29039.21,670.00,32809.90,3770.69,'2023-03-16 21:57:21'),(1972,'1','311',1,'Return of Retail Sale Id 1968',3558.00,0.00,690.00,-4140.00,-582.00,'2023-03-16 22:04:12'),(1973,'1','311',1,'Return of Retail Sale Id 1968',4151.00,0.00,690.00,-4830.00,-679.00,'2023-03-16 22:04:12'),(1974,'1','311',1,'Return of Retail Sale Id 1968',7412.50,0.00,690.00,-8625.00,-1212.50,'2023-03-16 22:04:12'),(1975,'1','311',1,'Retail Sale Id 2044',0.00,3735.90,690.00,4347.00,611.10,'2023-03-16 22:08:05'),(1976,'1','311',1,'Retail Sale Id 2044',0.00,4151.00,690.00,4830.00,679.00,'2023-03-16 22:08:05'),(1977,'1','311',1,'Retail Sale Id 2044',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-16 22:08:05'),(1978,'1','311',1,'Retail Sale Id 2045',0.00,509.98,690.00,593.40,83.42,'2023-03-16 22:10:49'),(1979,'1','311',1,'Return of Retail Sale Id 2045',509.98,0.00,690.00,-593.40,-83.42,'2023-03-16 22:12:01'),(1980,'1','311',1,'Return of Retail Sale Id 2040',29039.21,0.00,670.00,-32809.90,-3770.69,'2023-03-16 22:13:56'),(1981,'1','311',1,'Retail Sale Id 2046',0.00,29039.21,670.00,32809.90,3770.69,'2023-03-16 22:15:22'),(1982,'1','311',1,'Return of Retail Sale Id 1964',34987.00,0.00,670.00,-39530.00,-4543.00,'2023-03-16 22:18:54'),(1983,'1','311',1,'Retail Sale Id 2047',0.00,34987.00,670.00,39530.00,4543.00,'2023-03-16 22:20:11'),(1984,'1','311',1,'Retail Sale Id 2049',0.00,593.00,670.00,670.00,77.00,'2023-03-16 22:26:42'),(1985,'1','311',1,'Retail Sale Id 2050',0.00,1719.70,690.00,2001.00,281.30,'2023-03-17 07:50:29'),(1986,'1','311',1,'Retail Sale Id 2051',0.00,4299.25,690.00,5002.50,703.25,'2023-03-17 07:52:45'),(1987,'1','311',1,'Retail Sale Id 2053',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-17 08:18:09'),(1988,'1','311',1,'Retail Sale Id 2054',0.00,5930.00,690.00,6900.00,970.00,'2023-03-17 08:39:13'),(1989,'1','311',1,'Retail Sale Id 2055',0.00,1719.70,690.00,2001.00,281.30,'2023-03-17 08:50:38'),(1990,'1','311',1,'Retail Sale Id 2057',0.00,3854.50,690.00,4485.00,630.50,'2023-03-17 08:53:22'),(1991,'1','311',1,'Retail Sale Id 2058',0.00,5930.00,690.00,6900.00,970.00,'2023-03-17 08:54:53'),(1992,'1','311',1,'Retail Sale Id 2059',0.00,2579.55,690.00,3001.50,421.95,'2023-03-17 08:59:23'),(1993,'1','311',1,'Retail Sale Id 2060',0.00,2372.00,690.00,2760.00,388.00,'2023-03-17 09:01:39'),(1994,'1','311',1,'Retail Sale Id 2061',0.00,1779.00,690.00,2070.00,291.00,'2023-03-17 09:13:24'),(1995,'1','311',1,'Retail Sale Id 2062',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-17 09:14:08'),(1996,'1','311',1,'Retail Sale Id 2063',0.00,65230.00,670.00,73700.00,8470.00,'2023-03-17 09:22:05'),(1997,'1','311',1,'Retail Sale Id 2064',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-17 09:25:01'),(1998,'1','311',1,'Retail Sale Id 2065',0.00,1719.70,690.00,2001.00,281.30,'2023-03-17 09:39:59'),(1999,'1','311',1,'Retail Sale Id 2066',0.00,1802.72,690.00,2097.60,294.88,'2023-03-17 09:46:16'),(2000,'1','311',1,'Retail Sale Id 2067',0.00,3558.00,690.00,4140.00,582.00,'2023-03-17 09:52:36'),(2001,'1','311',1,'Retail Sale Id 2068',0.00,2965.00,690.00,3450.00,485.00,'2023-03-17 09:55:32'),(2002,'1','311',1,'Retail Sale Id 2069',0.00,2965.00,690.00,3450.00,485.00,'2023-03-17 10:01:14'),(2003,'1','311',1,'Return of Retail Sale Id 2067',3558.00,0.00,690.00,-4140.00,-582.00,'2023-03-17 10:03:55'),(2004,'1','311',1,'Retail Sale Id 2070',0.00,3854.50,690.00,4485.00,630.50,'2023-03-17 10:10:37'),(2005,'1','311',1,'Retail Sale Id 2071',0.00,598.93,690.00,696.90,97.97,'2023-03-17 10:19:03'),(2006,'1','311',1,'Retail Sale Id 2072',0.00,2965.00,690.00,3450.00,485.00,'2023-03-17 10:23:38'),(2007,'1','311',1,'Retail Sale Id 2073',0.00,2579.55,690.00,3001.50,421.95,'2023-03-17 10:28:06'),(2008,'1','311',1,'Retail Sale Id 2074',0.00,1286.81,690.00,1497.30,210.49,'2023-03-17 10:36:33'),(2009,'1','311',1,'Retail Sale Id 2076',0.00,1286.81,690.00,1497.30,210.49,'2023-03-17 10:43:45'),(2010,'1','311',1,'Retail Sale Id 2076',0.00,2372.00,690.00,2760.00,388.00,'2023-03-17 10:43:45'),(2011,'1','311',1,'Retail Sale Id 2078',0.00,4151.00,690.00,4830.00,679.00,'2023-03-17 10:51:14'),(2012,'1','311',1,'Retail Sale Id 2079',0.00,593.00,690.00,690.00,97.00,'2023-03-17 10:54:13'),(2013,'1','311',1,'Retail Sale Id 2079',0.00,2372.00,690.00,2760.00,388.00,'2023-03-17 10:54:13'),(2014,'1','311',1,'Retail Sale Id 2080',0.00,1779.00,690.00,2070.00,291.00,'2023-03-17 10:55:44'),(2015,'1','311',1,'Retail Sale Id 2081',0.00,1779.00,690.00,2070.00,291.00,'2023-03-17 10:57:41'),(2016,'1','311',1,'Retail Sale Id 2082',0.00,4151.00,690.00,4830.00,679.00,'2023-03-17 11:01:40'),(2017,'1','311',1,'Retail Sale Id 2083',0.00,2965.00,690.00,3450.00,485.00,'2023-03-17 11:03:50'),(2018,'1','311',1,'Retail Sale Id 2084',0.00,2372.00,690.00,2760.00,388.00,'2023-03-17 11:08:34'),(2019,'1','311',1,'Retail Sale Id 2086',0.00,2965.00,690.00,3450.00,485.00,'2023-03-17 11:10:18'),(2020,'1','311',1,'Retail Sale Id 2085',0.00,1719.70,690.00,2001.00,281.30,'2023-03-17 11:11:37'),(2021,'1','311',1,'Retail Sale Id 2087',0.00,1779.00,690.00,2070.00,291.00,'2023-03-17 11:12:48'),(2022,'1','311',1,'Retail Sale Id 2088',0.00,859.85,690.00,1000.50,140.65,'2023-03-17 11:14:01'),(2023,'1','311',1,'Retail Sale Id 2089',0.00,2965.00,690.00,3450.00,485.00,'2023-03-17 11:14:55'),(2024,'1','311',1,'Retail Sale Id 2090',0.00,3558.00,690.00,4140.00,582.00,'2023-03-17 11:24:34'),(2025,'1','311',1,'Retail Sale Id 2091',0.00,2965.00,690.00,3450.00,485.00,'2023-03-17 11:40:50'),(2026,'1','311',1,'Retail Sale Id 2092',0.00,1595.17,690.00,1856.10,260.93,'2023-03-17 11:43:47'),(2027,'1','311',1,'Retail Sale Id 2093',0.00,3558.00,690.00,4140.00,582.00,'2023-03-17 11:46:40'),(2028,'1','311',1,'Retail Sale Id 2095',0.00,2965.00,690.00,3450.00,485.00,'2023-03-17 12:05:14'),(2029,'1','311',1,'Retail Sale Id 2096',0.00,2407.58,690.00,2801.40,393.82,'2023-03-17 12:11:57'),(2030,'1','311',1,'Retail Sale Id 2098',0.00,3866.36,690.00,4498.80,632.44,'2023-03-17 12:32:59'),(2031,'1','311',1,'Retail Sale Id 2099',0.00,2965.00,690.00,3450.00,485.00,'2023-03-17 12:33:59'),(2032,'1','311',1,'Retail Sale Id 2100',0.00,1779.00,690.00,2070.00,291.00,'2023-03-17 12:35:44'),(2033,'1','311',1,'Retail Sale Id 2103',0.00,4151.00,690.00,4830.00,679.00,'2023-03-17 12:52:53'),(2034,'1','311',1,'Retail Sale Id 2104',0.00,2965.00,690.00,3450.00,485.00,'2023-03-17 12:53:37'),(2035,'1','311',1,'Retail Sale Id 2106',0.00,1114.84,690.00,1297.20,182.36,'2023-03-17 12:58:06'),(2036,'1','311',1,'Retail Sale Id 2106',0.00,1114.84,690.00,1297.20,182.36,'2023-03-17 12:58:06'),(2037,'1','311',1,'Retail Sale Id 2107',0.00,1719.70,690.00,2001.00,281.30,'2023-03-17 13:00:39'),(2038,'1','311',1,'Retail Sale Id 2108',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-17 13:03:31'),(2039,'1','311',1,'Retail Sale Id 2109',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-17 13:05:36'),(2040,'1','311',1,'Retail Sale Id 2110',0.00,1286.81,690.00,1497.30,210.49,'2023-03-17 13:28:10'),(2041,'1','311',1,'Retail Sale Id 2111',0.00,4151.00,690.00,4830.00,679.00,'2023-03-17 13:37:05'),(2042,'1','311',1,'Retail Sale Id 2112',0.00,1186.00,690.00,1380.00,194.00,'2023-03-17 13:38:05'),(2043,'1','311',1,'Retail Sale Id 2113',0.00,2372.00,690.00,2760.00,388.00,'2023-03-17 13:47:04'),(2044,'1','311',1,'Retail Sale Id 2114',0.00,1719.70,690.00,2001.00,281.30,'2023-03-17 13:52:13'),(2045,'1','311',1,'Retail Sale Id 2115',0.00,34987.00,670.00,39530.00,4543.00,'2023-03-17 14:01:43'),(2046,'1','311',1,'Retail Sale Id 2117',0.00,3558.00,690.00,4140.00,582.00,'2023-03-17 14:23:44'),(2047,'1','311',1,'Retail Sale Id 2119',0.00,4151.00,690.00,4830.00,679.00,'2023-03-17 14:40:58'),(2048,'1','311',1,'Retail Sale Id 2120',0.00,593.00,690.00,690.00,97.00,'2023-03-17 14:46:16'),(2049,'1','311',1,'Retail Sale Id 2121',0.00,1779.00,690.00,2070.00,291.00,'2023-03-17 14:56:50'),(2050,'1','311',1,'Retail Sale Id 2122',0.00,2965.00,690.00,3450.00,485.00,'2023-03-17 15:18:26'),(2051,'1','311',1,'Retail Sale Id 2123',0.00,5930.00,690.00,6900.00,970.00,'2023-03-17 15:20:01'),(2052,'1','311',1,'Retail Sale Id 2124',0.00,859.85,690.00,1000.50,140.65,'2023-03-17 15:22:53'),(2053,'1','311',1,'Retail Sale Id 2125',0.00,4299.25,690.00,5002.50,703.25,'2023-03-17 15:28:01'),(2054,'1','311',1,'Retail Sale Id 2126',0.00,2579.55,690.00,3001.50,421.95,'2023-03-17 15:31:05'),(2055,'1','311',1,'Return of Retail Sale Id 2110',1286.81,0.00,690.00,-1497.30,-210.49,'2023-03-17 15:47:33'),(2056,'1','311',1,'Retail Sale Id 2128',0.00,1286.81,690.00,1497.30,210.49,'2023-03-17 15:48:15'),(2057,'1','311',1,'Retail Sale Id 2130',0.00,1630.75,690.00,1897.50,266.75,'2023-03-17 15:56:40'),(2058,'1','311',1,'Retail Sale Id 2131',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-17 15:58:03'),(2059,'1','311',1,'Retail Sale Id 2132',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-17 15:58:56'),(2060,'1','311',1,'Retail Sale Id 2133',0.00,2372.00,690.00,2760.00,388.00,'2023-03-17 16:00:05'),(2061,'1','311',1,'Retail Sale Id 2134',0.00,2146.66,690.00,2497.80,351.14,'2023-03-17 16:02:25'),(2062,'1','311',1,'Retail Sale Id 2135',0.00,687.88,690.00,800.40,112.52,'2023-03-17 16:03:06'),(2063,'1','311',1,'Retail Sale Id 2136',0.00,598.93,690.00,696.90,97.97,'2023-03-17 16:04:22'),(2064,'1','311',1,'Return of Retail Sale Id 2135',687.88,0.00,690.00,-800.40,-112.52,'2023-03-17 16:05:12'),(2065,'1','311',1,'Retail Sale Id 2138',0.00,1203.79,690.00,1400.70,196.91,'2023-03-17 16:10:31'),(2066,'1','311',1,'Retail Sale Id 2140',0.00,2579.55,690.00,3001.50,421.95,'2023-03-17 16:11:55'),(2067,'1','311',1,'Retail Sale Id 2141',0.00,1186.00,690.00,1380.00,194.00,'2023-03-17 16:12:43'),(2068,'1','311',1,'Retail Sale Id 2142',0.00,1779.00,690.00,2070.00,291.00,'2023-03-17 16:13:34'),(2069,'1','311',1,'Retail Sale Id 2143',0.00,5930.00,690.00,6900.00,970.00,'2023-03-17 16:15:26'),(2070,'1','311',1,'Retail Sale Id 2143',0.00,5930.00,690.00,6900.00,970.00,'2023-03-17 16:15:26'),(2071,'1','311',1,'Retail Sale Id 2145',0.00,859.85,690.00,1000.50,140.65,'2023-03-17 16:18:20'),(2072,'1','311',1,'Retail Sale Id 2144',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-17 16:18:38'),(2073,'1','311',1,'Retail Sale Id 2147',0.00,4299.25,690.00,5002.50,703.25,'2023-03-17 16:33:22'),(2074,'1','311',1,'Retail Sale Id 2148',0.00,3854.50,690.00,4485.00,630.50,'2023-03-17 16:34:38'),(2075,'1','311',1,'Retail Sale Id 2149',0.00,1779.00,690.00,2070.00,291.00,'2023-03-17 16:38:36'),(2076,'1','311',1,'Retail Sale Id 2150',0.00,2372.00,690.00,2760.00,388.00,'2023-03-17 16:39:50'),(2077,'1','311',1,'Retail Sale Id 2151',0.00,13639.00,670.00,15410.00,1771.00,'2023-03-17 16:42:08'),(2078,'1','311',1,'Retail Sale Id 2152',0.00,3558.00,690.00,4140.00,582.00,'2023-03-17 16:42:48'),(2079,'1','311',1,'Retail Sale Id 2154',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-17 16:49:24'),(2080,'1','311',1,'Retail Sale Id 2156',0.00,1186.00,690.00,1380.00,194.00,'2023-03-17 16:53:37'),(2081,'1','311',1,'Retail Sale Id 2157',0.00,2372.00,690.00,2760.00,388.00,'2023-03-17 16:54:32'),(2082,'1','311',1,'Retail Sale Id 2158',0.00,1203.79,690.00,1400.70,196.91,'2023-03-17 16:55:35'),(2083,'1','311',1,'Retail Sale Id 2160',0.00,5930.00,690.00,6900.00,970.00,'2023-03-17 17:05:32'),(2084,'1','311',1,'Retail Sale Id 2161',0.00,6523.00,690.00,7590.00,1067.00,'2023-03-17 17:09:56'),(2085,'1','311',1,'Retail Sale Id 2159',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-17 17:12:54'),(2086,'1','311',1,'Retail Sale Id 2162',0.00,1891.67,690.00,2201.10,309.43,'2023-03-17 17:15:25'),(2087,'1','311',1,'Retail Sale Id 2164',0.00,65230.00,670.00,73700.00,8470.00,'2023-03-17 17:24:55'),(2088,'1','311',1,'Retail Sale Id 2165',0.00,2965.00,690.00,3450.00,485.00,'2023-03-17 17:26:32'),(2089,'1','311',1,'Retail Sale Id 2166',0.00,1186.00,690.00,1380.00,194.00,'2023-03-17 17:27:56'),(2090,'1','311',1,'Retail Sale Id 2167',0.00,1779.00,690.00,2070.00,291.00,'2023-03-17 17:30:39'),(2091,'1','311',1,'Retail Sale Id 2168',0.00,3558.00,690.00,4140.00,582.00,'2023-03-17 17:44:47'),(2092,'1','311',1,'Retail Sale Id 2169',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-17 17:45:49'),(2093,'1','311',1,'Retail Sale Id 2172',0.00,4151.00,690.00,4830.00,679.00,'2023-03-17 17:55:02'),(2094,'1','311',1,'Retail Sale Id 2173',0.00,1779.00,690.00,2070.00,291.00,'2023-03-17 17:56:43'),(2095,'1','311',1,'Retail Sale Id 2174',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-17 17:58:19'),(2096,'1','311',1,'Retail Sale Id 2176',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-17 18:00:00'),(2097,'1','311',1,'Retail Sale Id 2175',0.00,2965.00,690.00,3450.00,485.00,'2023-03-17 18:00:33'),(2098,'1','311',1,'Retail Sale Id 2177',0.00,1286.81,690.00,1497.30,210.49,'2023-03-17 18:03:02'),(2099,'1','311',1,'Retail Sale Id 2178',0.00,1719.70,690.00,2001.00,281.30,'2023-03-17 18:03:56'),(2100,'1','311',1,'Retail Sale Id 2179',0.00,4151.00,690.00,4830.00,679.00,'2023-03-17 18:05:04'),(2101,'1','311',1,'Retail Sale Id 2181',0.00,1286.81,690.00,1497.30,210.49,'2023-03-17 18:07:30'),(2102,'1','311',1,'Retail Sale Id 2182',0.00,2372.00,690.00,2760.00,388.00,'2023-03-17 18:08:33'),(2103,'1','311',1,'Return of Retail Sale Id 2179',4151.00,0.00,690.00,-4830.00,-679.00,'2023-03-17 18:14:06'),(2104,'1','311',1,'Retail Sale Id 2185',0.00,3285.22,690.00,3822.60,537.38,'2023-03-17 18:14:47'),(2105,'1','311',1,'Retail Sale Id 2186',0.00,1186.00,690.00,1380.00,194.00,'2023-03-17 18:18:25'),(2106,'1','311',1,'Retail Sale Id 2189',0.00,1186.00,690.00,1380.00,194.00,'2023-03-19 07:50:58'),(2107,'1','311',1,'Retail Sale Id 2188',0.00,2372.00,690.00,2760.00,388.00,'2023-03-19 08:19:41'),(2108,'1','311',1,'Retail Sale Id 2188',0.00,4151.00,690.00,4830.00,679.00,'2023-03-19 08:19:41'),(2109,'1','311',1,'Retail Sale Id 2188',0.00,6523.00,690.00,7590.00,1067.00,'2023-03-19 08:19:41'),(2110,'1','311',1,'Retail Sale Id 2190',0.00,2965.00,690.00,3450.00,485.00,'2023-03-19 08:21:26'),(2111,'1','311',1,'Retail Sale Id 2191',0.00,3558.00,690.00,4140.00,582.00,'2023-03-19 08:22:08'),(2112,'1','311',1,'Retail Sale Id 2192',0.00,5930.00,690.00,6900.00,970.00,'2023-03-19 08:23:06'),(2113,'1','311',1,'Retail Sale Id 2192',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-19 08:23:06'),(2114,'1','311',1,'Retail Sale Id 2193',0.00,2965.00,690.00,3450.00,485.00,'2023-03-19 08:23:46'),(2115,'1','311',1,'Retail Sale Id 2194',0.00,4299.25,690.00,5002.50,703.25,'2023-03-19 08:24:59'),(2116,'1','311',1,'Retail Sale Id 2195',0.00,2372.00,690.00,2760.00,388.00,'2023-03-19 08:25:44'),(2117,'1','311',1,'Retail Sale Id 2196',0.00,4744.00,690.00,5520.00,776.00,'2023-03-19 08:29:04'),(2118,'1','311',1,'Retail Sale Id 2197',0.00,8895.00,690.00,10350.00,1455.00,'2023-03-19 08:30:13'),(2119,'1','311',1,'Retail Sale Id 2198',0.00,3558.00,690.00,4140.00,582.00,'2023-03-19 08:31:35'),(2120,'1','311',1,'Retail Sale Id 2199',0.00,2372.00,690.00,2760.00,388.00,'2023-03-19 08:32:41'),(2121,'1','311',1,'Retail Sale Id 2200',0.00,1779.00,690.00,2070.00,291.00,'2023-03-19 08:33:58'),(2122,'1','311',1,'Retail Sale Id 2201',0.00,1779.00,690.00,2070.00,291.00,'2023-03-19 08:36:32'),(2123,'1','311',1,'Retail Sale Id 2202',0.00,1186.00,690.00,1380.00,194.00,'2023-03-19 08:38:19'),(2124,'1','311',1,'Retail Sale Id 2203',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-19 08:46:40'),(2125,'1','311',1,'Retail Sale Id 2204',0.00,2579.55,690.00,3001.50,421.95,'2023-03-19 08:49:32'),(2126,'1','311',1,'Retail Sale Id 2205',0.00,2579.55,690.00,3001.50,421.95,'2023-03-19 08:50:33'),(2127,'1','311',1,'Retail Sale Id 2206',0.00,1186.00,690.00,1380.00,194.00,'2023-03-19 08:51:38'),(2128,'1','311',1,'Retail Sale Id 2207',0.00,2965.00,690.00,3450.00,485.00,'2023-03-19 09:10:05'),(2129,'1','311',1,'Retail Sale Id 2208',0.00,1286.81,690.00,1497.30,210.49,'2023-03-19 09:21:14'),(2130,'1','311',1,'Retail Sale Id 2209',0.00,1186.00,690.00,1380.00,194.00,'2023-03-19 09:23:37'),(2131,'1','311',1,'Retail Sale Id 2212',0.00,2146.66,690.00,2497.80,351.14,'2023-03-19 09:30:39'),(2132,'1','311',1,'Retail Sale Id 2212',0.00,2579.55,690.00,3001.50,421.95,'2023-03-19 09:30:39'),(2133,'1','311',1,'Retail Sale Id 2213',0.00,2372.00,690.00,2760.00,388.00,'2023-03-19 09:32:00'),(2134,'1','311',1,'Retail Sale Id 2214',0.00,2579.55,690.00,3001.50,421.95,'2023-03-19 09:33:19'),(2135,'1','311',1,'Retail Sale Id 2216',0.00,1286.81,690.00,1497.30,210.49,'2023-03-19 09:35:50'),(2136,'1','311',1,'Retail Sale Id 2217',0.00,1779.00,690.00,2070.00,291.00,'2023-03-19 09:38:51'),(2137,'1','311',1,'Retail Sale Id 2218',0.00,5930.00,690.00,6900.00,970.00,'2023-03-19 09:40:04'),(2138,'1','311',1,'Retail Sale Id 2219',0.00,2965.00,690.00,3450.00,485.00,'2023-03-19 09:41:26'),(2139,'1','311',1,'Retail Sale Id 2220',0.00,1779.00,690.00,2070.00,291.00,'2023-03-19 09:42:32'),(2140,'1','311',1,'Retail Sale Id 2222',0.00,1186.00,690.00,1380.00,194.00,'2023-03-19 10:09:30'),(2141,'1','311',1,'Retail Sale Id 2223',0.00,859.85,690.00,1000.50,140.65,'2023-03-19 10:11:38'),(2142,'1','311',1,'Retail Sale Id 2224',0.00,3558.00,690.00,4140.00,582.00,'2023-03-19 10:12:52'),(2143,'1','311',1,'Retail Sale Id 2225',0.00,598.93,690.00,696.90,97.97,'2023-03-19 10:21:29'),(2144,'1','311',1,'Retail Sale Id 2226',0.00,5930.00,690.00,6900.00,970.00,'2023-03-19 10:26:46'),(2145,'1','311',1,'Retail Sale Id 2227',0.00,1802.72,690.00,2097.60,294.88,'2023-03-19 10:30:29'),(2146,'1','311',1,'Retail Sale Id 2228',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-19 10:34:47'),(2147,'1','311',1,'Retail Sale Id 2229',0.00,3558.00,690.00,4140.00,582.00,'2023-03-19 10:45:42'),(2148,'1','311',1,'Retail Sale Id 2230',0.00,3558.00,690.00,4140.00,582.00,'2023-03-19 10:46:47'),(2149,'1','311',1,'Retail Sale Id 2231',0.00,2579.55,690.00,3001.50,421.95,'2023-03-19 10:55:02'),(2150,'1','311',1,'Retail Sale Id 2232',0.00,1186.00,690.00,1380.00,194.00,'2023-03-19 11:02:31'),(2151,'1','311',1,'Retail Sale Id 2233',0.00,69974.00,670.00,79060.00,9086.00,'2023-03-19 11:05:23'),(2152,'1','311',1,'Retail Sale Id 2234',0.00,2372.00,690.00,2760.00,388.00,'2023-03-19 11:08:26'),(2153,'1','311',1,'Retail Sale Id 2235',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-19 11:11:54'),(2154,'1','311',1,'Retail Sale Id 2236',0.00,593.00,600.00,600.00,7.00,'2023-03-19 11:16:24'),(2155,'1','311',1,'Retail Sale Id 2237',0.00,859.85,690.00,1000.50,140.65,'2023-03-19 11:17:17'),(2156,'1','311',1,'Retail Sale Id 2238',0.00,1203.79,690.00,1400.70,196.91,'2023-03-19 11:18:45'),(2157,'1','311',1,'Retail Sale Id 2239',0.00,2579.55,690.00,3001.50,421.95,'2023-03-19 11:19:47'),(2158,'1','311',1,'Retail Sale Id 2240',0.00,1802.72,690.00,2097.60,294.88,'2023-03-19 11:20:57'),(2159,'1','311',1,'Retail Sale Id 2241',0.00,1719.70,690.00,2001.00,281.30,'2023-03-19 11:22:01'),(2160,'1','311',1,'Retail Sale Id 2242',0.00,1186.00,690.00,1380.00,194.00,'2023-03-19 11:22:58'),(2161,'1','311',1,'Retail Sale Id 2243',0.00,2965.00,690.00,3450.00,485.00,'2023-03-19 11:24:21'),(2162,'1','311',1,'Retail Sale Id 2244',0.00,1802.72,690.00,2097.60,294.88,'2023-03-19 11:31:07'),(2163,'1','311',1,'Retail Sale Id 2245',0.00,1203.79,690.00,1400.70,196.91,'2023-03-19 11:37:49'),(2164,'1','311',1,'Retail Sale Id 2246',0.00,1779.00,690.00,2070.00,291.00,'2023-03-19 12:11:33'),(2165,'1','311',1,'Retail Sale Id 2247',0.00,1719.70,690.00,2001.00,281.30,'2023-03-19 12:22:12'),(2166,'1','311',1,'Retail Sale Id 2248',0.00,2579.55,690.00,3001.50,421.95,'2023-03-19 12:29:36'),(2167,'1','311',1,'Retail Sale Id 2249',0.00,1779.00,690.00,2070.00,291.00,'2023-03-19 12:44:32'),(2168,'1','311',1,'Retail Sale Id 2250',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-19 12:49:45'),(2169,'1','311',1,'Retail Sale Id 2251',0.00,4151.00,690.00,4830.00,679.00,'2023-03-19 12:52:19'),(2170,'1','311',1,'Retail Sale Id 2252',0.00,3558.00,690.00,4140.00,582.00,'2023-03-19 12:55:16'),(2171,'1','311',1,'Retail Sale Id 2253',0.00,1779.00,690.00,2070.00,291.00,'2023-03-19 12:57:13'),(2172,'1','311',1,'Retail Sale Id 2254',0.00,2579.55,690.00,3001.50,421.95,'2023-03-19 12:59:12'),(2173,'1','311',1,'Retail Sale Id 2256',0.00,3558.00,690.00,4140.00,582.00,'2023-03-19 13:02:59'),(2174,'1','311',1,'Retail Sale Id 2257',0.00,2965.00,690.00,3450.00,485.00,'2023-03-19 13:07:53'),(2175,'1','311',1,'Retail Sale Id 2258',0.00,1719.70,690.00,2001.00,281.30,'2023-03-19 13:09:53'),(2176,'1','311',1,'Retail Sale Id 2260',0.00,6013.02,690.00,6996.60,983.58,'2023-03-19 13:19:27'),(2177,'1','311',1,'Retail Sale Id 2261',0.00,1802.72,690.00,2097.60,294.88,'2023-03-19 13:21:26'),(2178,'1','311',1,'Retail Sale Id 2262',0.00,1203.79,690.00,1400.70,196.91,'2023-03-19 13:28:42'),(2179,'1','311',1,'Retail Sale Id 2263',0.00,4151.00,690.00,4830.00,679.00,'2023-03-19 13:30:39'),(2180,'1','311',1,'Retail Sale Id 2264',0.00,2579.55,690.00,3001.50,421.95,'2023-03-19 13:32:20'),(2181,'1','311',1,'Retail Sale Id 2265',0.00,3558.00,690.00,4140.00,582.00,'2023-03-19 13:45:38'),(2182,'1','311',1,'Retail Sale Id 2266',0.00,859.85,690.00,1000.50,140.65,'2023-03-19 13:47:40'),(2183,'1','311',1,'Retail Sale Id 2267',0.00,4151.00,690.00,4830.00,679.00,'2023-03-19 13:53:37'),(2184,'1','311',1,'Retail Sale Id 2268',0.00,2965.00,690.00,3450.00,485.00,'2023-03-19 14:00:50'),(2185,'1','311',1,'Retail Sale Id 2269',0.00,2965.00,690.00,3450.00,485.00,'2023-03-19 14:02:35'),(2186,'1','311',1,'Retail Sale Id 2270',0.00,1779.00,690.00,2070.00,291.00,'2023-03-19 14:05:53'),(2187,'1','311',1,'Retail Sale Id 2271',0.00,1802.72,690.00,2097.60,294.88,'2023-03-19 14:08:15'),(2188,'1','311',1,'Retail Sale Id 2274',0.00,1779.00,690.00,2070.00,291.00,'2023-03-19 14:12:21'),(2189,'1','311',1,'Retail Sale Id 2276',0.00,598.93,690.00,696.90,97.97,'2023-03-19 14:15:24'),(2190,'1','311',1,'Retail Sale Id 2275',0.00,1779.00,690.00,2070.00,291.00,'2023-03-19 14:16:02'),(2191,'1','311',1,'Retail Sale Id 2275',0.00,3261.50,690.00,3795.00,533.50,'2023-03-19 14:16:02'),(2192,'1','311',1,'Retail Sale Id 2277',0.00,1286.81,690.00,1497.30,210.49,'2023-03-19 14:17:33'),(2193,'1','311',1,'Retail Sale Id 2278',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-19 14:19:53'),(2194,'1','311',1,'Retail Sale Id 2280',0.00,7116.00,690.00,8280.00,1164.00,'2023-03-19 14:21:39'),(2195,'1','311',1,'Retail Sale Id 2282',0.00,1203.79,690.00,1400.70,196.91,'2023-03-19 14:23:16'),(2196,'1','311',1,'Retail Sale Id 2283',0.00,3558.00,690.00,4140.00,582.00,'2023-03-19 14:24:25'),(2197,'1','311',1,'Retail Sale Id 2284',0.00,1779.00,690.00,2070.00,291.00,'2023-03-19 14:26:58'),(2198,'1','311',1,'Retail Sale Id 2286',0.00,4744.00,690.00,5520.00,776.00,'2023-03-19 14:29:15'),(2199,'1','311',1,'Retail Sale Id 2287',0.00,5930.00,690.00,6900.00,970.00,'2023-03-19 14:31:08'),(2200,'1','311',1,'Retail Sale Id 2288',0.00,1802.72,690.00,2097.60,294.88,'2023-03-19 14:32:03'),(2201,'1','311',1,'Retail Sale Id 2289',0.00,4744.00,690.00,5520.00,776.00,'2023-03-19 14:34:06'),(2202,'1','311',1,'Retail Sale Id 2290',0.00,1779.00,690.00,2070.00,291.00,'2023-03-19 14:35:12'),(2203,'1','311',1,'Retail Sale Id 2291',0.00,859.85,690.00,1000.50,140.65,'2023-03-19 14:37:26'),(2204,'1','311',1,'Retail Sale Id 2293',0.00,2372.00,690.00,2760.00,388.00,'2023-03-19 14:42:08'),(2205,'1','311',1,'Retail Sale Id 2294',0.00,2579.55,690.00,3001.50,421.95,'2023-03-19 14:44:51'),(2206,'1','311',1,'Retail Sale Id 2292',0.00,1779.00,690.00,2070.00,291.00,'2023-03-19 14:45:20'),(2207,'1','311',1,'Retail Sale Id 2295',0.00,237200.00,670.00,268000.00,30800.00,'2023-03-19 14:48:41'),(2208,'1','311',1,'Retail Sale Id 2296',0.00,153587.00,670.00,173530.00,19943.00,'2023-03-19 14:50:41'),(2209,'1','311',1,'Retail Sale Id 2297',0.00,2372.00,690.00,2760.00,388.00,'2023-03-19 14:52:22'),(2210,'1','311',1,'Retail Sale Id 2299',0.00,2965.00,690.00,3450.00,485.00,'2023-03-19 14:54:11'),(2211,'1','311',1,'Retail Sale Id 2300',0.00,2965.00,690.00,3450.00,485.00,'2023-03-19 14:56:12'),(2212,'1','311',1,'Retail Sale Id 2300',0.00,4151.00,690.00,4830.00,679.00,'2023-03-19 14:56:12'),(2213,'1','311',1,'Retail Sale Id 2300',0.00,4744.00,690.00,5520.00,776.00,'2023-03-19 14:56:12'),(2214,'1','311',1,'Retail Sale Id 2301',0.00,1779.00,690.00,2070.00,291.00,'2023-03-19 14:57:42'),(2215,'1','311',1,'Retail Sale Id 2302',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-19 15:01:44'),(2216,'1','311',1,'Retail Sale Id 2303',0.00,1802.72,690.00,2097.60,294.88,'2023-03-19 15:04:42'),(2217,'1','311',1,'Retail Sale Id 2304',0.00,1779.00,690.00,2070.00,291.00,'2023-03-19 15:07:12'),(2218,'1','311',1,'Retail Sale Id 2305',0.00,3439.40,690.00,4002.00,562.60,'2023-03-19 15:08:26'),(2219,'1','311',1,'Retail Sale Id 2306',0.00,2965.00,690.00,3450.00,485.00,'2023-03-19 15:17:58'),(2220,'1','311',1,'Retail Sale Id 2307',0.00,1779.00,690.00,2070.00,291.00,'2023-03-19 15:19:29'),(2221,'1','311',1,'Retail Sale Id 2308',0.00,1494.36,690.00,1738.80,244.44,'2023-03-19 15:23:03'),(2222,'1','311',1,'Retail Sale Id 2310',0.00,1719.70,690.00,2001.00,281.30,'2023-03-19 15:32:04'),(2223,'1','311',1,'Retail Sale Id 2311',0.00,1719.70,690.00,2001.00,281.30,'2023-03-19 15:33:19'),(2224,'1','311',1,'Retail Sale Id 2312',0.00,2579.55,690.00,3001.50,421.95,'2023-03-19 15:35:53'),(2225,'1','311',1,'Retail Sale Id 2313',0.00,2372.00,690.00,2760.00,388.00,'2023-03-19 15:37:23'),(2226,'1','311',1,'Retail Sale Id 2314',0.00,7436.22,690.00,8652.60,1216.38,'2023-03-19 15:44:47'),(2227,'1','311',1,'Retail Sale Id 2315',0.00,598.93,690.00,696.90,97.97,'2023-03-19 15:52:48'),(2228,'1','311',1,'Retail Sale Id 2316',0.00,1779.00,690.00,2070.00,291.00,'2023-03-19 15:54:05'),(2229,'1','311',1,'Retail Sale Id 2317',0.00,4151.00,690.00,4830.00,679.00,'2023-03-19 15:55:11'),(2230,'1','311',1,'Retail Sale Id 2318',0.00,1779.00,690.00,2070.00,291.00,'2023-03-19 15:56:21'),(2231,'1','311',1,'Retail Sale Id 2319',0.00,1719.70,690.00,2001.00,281.30,'2023-03-19 15:57:21'),(2232,'1','311',1,'Retail Sale Id 2320',0.00,4744.00,690.00,5520.00,776.00,'2023-03-19 15:59:12'),(2233,'1','311',1,'Retail Sale Id 2321',0.00,1779.00,690.00,2070.00,291.00,'2023-03-19 16:05:14'),(2234,'1','311',1,'Retail Sale Id 2322',0.00,4151.00,690.00,4830.00,679.00,'2023-03-19 16:06:37'),(2235,'1','311',1,'Retail Sale Id 2323',0.00,2965.00,690.00,3450.00,485.00,'2023-03-19 16:07:46'),(2236,'1','311',1,'Retail Sale Id 2324',0.00,1482.50,690.00,1725.00,242.50,'2023-03-19 16:10:33'),(2237,'1','311',1,'Retail Sale Id 2325',0.00,3558.00,690.00,4140.00,582.00,'2023-03-19 16:11:43'),(2238,'1','311',1,'Retail Sale Id 2326',0.00,3558.00,690.00,4140.00,582.00,'2023-03-19 16:13:20'),(2239,'1','311',1,'Retail Sale Id 2327',0.00,5930.00,690.00,6900.00,970.00,'2023-03-19 16:15:00'),(2240,'1','311',1,'Retail Sale Id 2329',0.00,1719.70,690.00,2001.00,281.30,'2023-03-19 16:16:49'),(2241,'1','311',1,'Retail Sale Id 2340',0.00,2016.20,690.00,2346.00,329.80,'2023-03-19 16:21:58'),(2242,'1','311',1,'Retail Sale Id 2340',0.00,7436.22,690.00,8652.60,1216.38,'2023-03-19 16:21:58'),(2243,'1','311',1,'Retail Sale Id 2341',0.00,859.85,690.00,1000.50,140.65,'2023-03-19 16:25:08'),(2244,'1','311',1,'Retail Sale Id 2342',0.00,2965.00,690.00,3450.00,485.00,'2023-03-19 16:26:28'),(2245,'1','311',1,'Retail Sale Id 2343',0.00,4299.25,690.00,5002.50,703.25,'2023-03-19 16:32:35'),(2246,'1','311',1,'Retail Sale Id 2344',0.00,1286.81,690.00,1497.30,210.49,'2023-03-19 16:33:47'),(2247,'1','311',1,'Retail Sale Id 2345',0.00,2372.00,690.00,2760.00,388.00,'2023-03-19 16:34:56'),(2248,'1','311',1,'Retail Sale Id 2346',0.00,1203.79,690.00,1400.70,196.91,'2023-03-19 16:39:12'),(2249,'1','311',1,'Retail Sale Id 2347',0.00,4151.00,690.00,4830.00,679.00,'2023-03-19 16:42:23'),(2250,'1','311',1,'Retail Sale Id 2348',0.00,2372.00,690.00,2760.00,388.00,'2023-03-19 16:47:38'),(2251,'1','311',1,'Retail Sale Id 2349',0.00,1802.72,690.00,2097.60,294.88,'2023-03-19 16:55:09'),(2252,'1','311',1,'Retail Sale Id 2350',0.00,859.85,690.00,1000.50,140.65,'2023-03-19 16:57:09'),(2253,'1','311',1,'Retail Sale Id 2351',0.00,7116.00,690.00,8280.00,1164.00,'2023-03-19 16:59:20'),(2254,'1','311',1,'Retail Sale Id 2352',0.00,3558.00,690.00,4140.00,582.00,'2023-03-19 17:00:38'),(2255,'1','311',1,'Retail Sale Id 2353',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-19 17:03:18'),(2256,'1','311',1,'Retail Sale Id 2356',0.00,3261.50,690.00,3795.00,533.50,'2023-03-19 17:05:42'),(2257,'1','311',1,'Retail Sale Id 2359',0.00,1186.00,690.00,1380.00,194.00,'2023-03-19 17:25:04'),(2258,'1','311',1,'Retail Sale Id 2360',0.00,687.88,690.00,800.40,112.52,'2023-03-19 17:40:25'),(2259,'1','311',1,'Retail Sale Id 2362',0.00,5930.00,690.00,6900.00,970.00,'2023-03-19 17:45:22'),(2260,'1','311',1,'Retail Sale Id 2363',0.00,2372.00,690.00,2760.00,388.00,'2023-03-19 17:46:57'),(2261,'1','311',1,'Retail Sale Id 2364',0.00,7412.50,690.00,8625.00,1212.50,'2023-03-19 17:48:57'),(2262,'1','311',1,'Return of Retail Sale Id 2364',7412.50,0.00,690.00,-8625.00,-1212.50,'2023-03-19 18:42:51'),(2263,'1','311',1,'Retail Sale Id 2365',0.00,5289.56,690.00,6154.80,865.24,'2023-03-19 18:43:36'),(2264,'1','311',1,'Retail Sale Id 2366',0.00,34987.00,670.00,39530.00,4543.00,'2023-03-19 18:46:12'),(2265,'1','311',1,'Return of Retail Sale Id 2295',237200.00,0.00,670.00,-268000.00,-30800.00,'2023-03-19 18:49:46'),(2266,'1','311',1,'Retail Sale Id 2367',0.00,202213.00,670.00,228470.00,26257.00,'2023-03-19 18:50:29');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=4529 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('1','311',1,'','24','2',0.00,11622800.00,'Purchase Id 1 for 19,600.00 litters of Cooking Gas - LPG from AA RANO NIGERIA LTD','2023-02-02 15:15:10','',''),('1','311',2,'','supplier','1',11622800.00,0.00,'Purchase Id 1 for 19,600.00 litters of Cooking Gas - LPG from AA RANO NIGERIA LTD','2023-02-02 15:15:10','',''),('1','311',3,'','20','3',0.00,0.00,'Sales from shift 1 on 2023-02-03 10:58:46 ','2023-02-03 10:58:46','',''),('1','311',4,'','6.1','4',0.00,0.00,'Sales from shift 1 on 2023-02-03 10:58:46 ','2023-02-03 10:58:46','',''),('1','311',5,'','20','3',21280.00,0.00,'Retail Sale Id 1 for 28.00 KG of Cooking Gas @ N760.00','2023-02-03 11:04:06','',''),('1','311',6,'','6.1','4',0.00,21280.00,'Retail Sale Id 1 for retail product','2023-02-03 11:04:06','',''),('1','311',7,'','20','3',0.00,0.00,'Sales from shift 2 on 2023-02-03 11:41:31 ','2023-02-03 11:41:31','',''),('1','311',8,'','6.1','4',0.00,0.00,'Sales from shift 2 on 2023-02-03 11:41:31 ','2023-02-03 11:41:31','',''),('1','311',9,'','20','3',4316.80,0.00,'Retail Sale Id 2 for 5.68 KG of Cooking Gas @ N760.00','2023-02-03 11:53:35','',''),('1','311',10,'','6.1','4',0.00,4316.80,'Retail Sale Id 2 for retail product','2023-02-03 11:53:35','',''),('1','311',11,'','20','3',10685.60,0.00,'Retail Sale Id 3 for 14.06 KG of Cooking Gas @ N760.00','2023-02-03 11:56:07','',''),('1','311',12,'','6.1','4',0.00,10685.60,'Retail Sale Id 3 for retail product','2023-02-03 11:56:07','',''),('1','311',13,'','20','3',2300.00,0.00,'Retail Sale Id 4 for 3.03 KG of Cooking Gas @ N760.00','2023-02-03 12:04:40','',''),('1','311',14,'','6.1','4',0.00,2300.00,'Retail Sale Id 4 for retail product','2023-02-03 12:04:40','',''),('1','311',15,'','20','3',1500.00,0.00,'Retail Sale Id 6 for 1.97 KG of Cooking Gas @ N760.00','2023-02-03 13:31:13','',''),('1','311',16,'','6.1','4',0.00,1500.00,'Retail Sale Id 6 for retail product','2023-02-03 13:31:13','',''),('1','311',17,'','20','3',6840.00,0.00,'Retail Sale Id 7 for multiple products','2023-02-03 13:35:35','',''),('1','311',18,'','6.1','4',0.00,6840.00,'Retail Sale Id 7 for retail product','2023-02-03 13:35:35','',''),('1','311',19,'','20','3',4560.00,0.00,'Retail Sale Id 8 for 6.00 KG of Cooking Gas @ N760.00','2023-02-03 13:49:26','',''),('1','311',20,'','6.1','4',0.00,4560.00,'Retail Sale Id 8 for retail product','2023-02-03 13:49:26','',''),('1','311',21,'','20','3',9500.00,0.00,'Retail Sale Id 9 for 12.50 KG of Cooking Gas @ N760.00','2023-02-03 13:57:14','',''),('1','311',22,'','6.1','4',0.00,9500.00,'Retail Sale Id 9 for retail product','2023-02-03 13:57:14','',''),('1','311',23,'','20','3',4000.00,0.00,'Retail Sale Id 11 for 5.26 KG of Cooking Gas @ N760.00','2023-02-03 14:03:51','',''),('1','311',24,'','6.1','4',0.00,4000.00,'Retail Sale Id 11 for retail product','2023-02-03 14:03:51','',''),('1','311',25,'','20','3',2000.00,0.00,'Retail Sale Id 12 for 2.63 KG of Cooking Gas @ N760.00','2023-02-03 14:11:37','',''),('1','311',26,'','6.1','4',0.00,2000.00,'Retail Sale Id 12 for retail product','2023-02-03 14:11:37','',''),('1','311',27,'','20','3',1400.00,0.00,'Retail Sale Id 13 for 1.84 KG of Cooking Gas @ N760.00','2023-02-03 14:16:24','',''),('1','311',28,'','6.1','4',0.00,1400.00,'Retail Sale Id 13 for retail product','2023-02-03 14:16:24','',''),('1','311',29,'','6.1','4',0.00,1400.00,'Retail Sale Id 13 for retail product','2023-02-03 14:16:24','',''),('1','311',30,'','6.1','4',0.00,1400.00,'Retail Sale Id 13 for retail product','2023-02-03 14:16:24','',''),('1','311',31,'','20','3',7600.00,0.00,'Retail Sale Id 14 for 10.00 KG of Cooking Gas @ N760.00','2023-02-03 14:18:56','',''),('1','311',32,'','6.1','4',0.00,7600.00,'Retail Sale Id 14 for retail product','2023-02-03 14:18:56','',''),('1','311',33,'','20','3',5320.00,0.00,'Retail Sale Id 15 for 7.00 KG of Cooking Gas @ N760.00','2023-02-03 14:20:54','',''),('1','311',34,'','6.1','4',0.00,5320.00,'Retail Sale Id 15 for retail product','2023-02-03 14:20:54','',''),('1','311',35,'','20','3',1500.00,0.00,'Retail Sale Id 16 for 1.97 KG of Cooking Gas @ N760.00','2023-02-03 14:26:52','',''),('1','311',36,'','6.1','4',0.00,1500.00,'Retail Sale Id 16 for retail product','2023-02-03 14:26:52','',''),('1','311',37,'','20','3',2000.00,0.00,'Retail Sale Id 18 for 2.63 KG of Cooking Gas @ N760.00','2023-02-03 15:18:51','',''),('1','311',38,'','6.1','4',0.00,2000.00,'Retail Sale Id 18 for retail product','2023-02-03 15:18:51','',''),('1','311',39,'','6.1','4',0.00,2000.00,'Retail Sale Id 18 for retail product','2023-02-03 15:18:51','',''),('1','311',40,'','20','3',3800.00,0.00,'Retail Sale Id 19 for 5.00 KG of Cooking Gas @ N760.00','2023-02-03 16:11:45','',''),('1','311',41,'','6.1','4',0.00,3800.00,'Retail Sale Id 19 for retail product','2023-02-03 16:11:45','',''),('1','311',42,'','20','3',1500.00,0.00,'Retail Sale Id 20 for 1.97 KG of Cooking Gas @ N760.00','2023-02-03 16:31:34','',''),('1','311',43,'','6.1','4',0.00,1500.00,'Retail Sale Id 20 for retail product','2023-02-03 16:31:34','',''),('1','311',44,'','20','3',2000.00,0.00,'Retail Sale Id 21 for 2.63 KG of Cooking Gas @ N760.00','2023-02-03 16:41:50','',''),('1','311',45,'','6.1','4',0.00,2000.00,'Retail Sale Id 21 for retail product','2023-02-03 16:41:50','',''),('1','311',46,'','20','3',9500.00,0.00,'Retail Sale Id 22 for 12.50 KG of Cooking Gas @ N760.00','2023-02-03 17:00:16','',''),('1','311',47,'','6.1','4',0.00,9500.00,'Retail Sale Id 22 for retail product','2023-02-03 17:00:16','',''),('1','311',48,'','20','3',13710.40,0.00,'Retail Sale Id 26 for multiple products','2023-02-03 21:22:44','',''),('1','311',49,'','6.1','4',0.00,13710.40,'Retail Sale Id 26 for retail product','2023-02-03 21:22:44','',''),('1','311',50,'','20','3',0.00,0.00,'Sales from shift 3 on 2023-02-03 21:28:38 ','2023-02-03 21:28:38','',''),('1','311',51,'','6.1','4',0.00,0.00,'Sales from shift 3 on 2023-02-03 21:28:38 ','2023-02-03 21:28:38','',''),('1','311',52,'','20','3',2000.00,0.00,'Retail Sale Id 28 for 2.63 KG of Cooking Gas @ N760.00','2023-02-04 10:07:57','',''),('1','311',53,'','6.1','4',0.00,2000.00,'Retail Sale Id 28 for retail product','2023-02-04 10:07:57','',''),('1','311',54,'','20','3',760.00,0.00,'Retail Sale Id 29 for 1.00 KG of Cooking Gas @ N760.00','2023-02-04 10:13:19','',''),('1','311',55,'','6.1','4',0.00,760.00,'Retail Sale Id 29 for retail product','2023-02-04 10:13:19','',''),('1','311',56,'','20','3',24000.00,0.00,'Retail Sale Id 31 for multiple products','2023-02-04 11:14:15','',''),('1','311',57,'','6.1','4',0.00,24000.00,'Retail Sale Id 31 for retail product','2023-02-04 11:14:15','',''),('1','311',58,'','20','3',0.00,24000.00,'Return of Retail Sale Id 31 for products','2023-02-04 11:14:54','',''),('1','311',59,'','','',24000.00,0.00,'Return of Retail Sale Id 31 for products','2023-02-04 11:14:54','',''),('1','311',60,'','20','3',9500.00,0.00,'Retail Sale Id 32 for 12.50 KG of Cooking Gas @ N760.00','2023-02-04 11:16:28','',''),('1','311',61,'','6.1','4',0.00,9500.00,'Retail Sale Id 32 for retail product','2023-02-04 11:16:28','',''),('1','311',62,'','20','3',5000.00,0.00,'Retail Sale Id 33 for 6.58 KG of Cooking Gas @ N760.00','2023-02-04 11:17:40','',''),('1','311',63,'','6.1','4',0.00,5000.00,'Retail Sale Id 33 for retail product','2023-02-04 11:17:40','',''),('1','311',64,'','20','3',2000.00,0.00,'Retail Sale Id 34 for 2.63 KG of Cooking Gas @ N760.00','2023-02-04 11:34:05','',''),('1','311',65,'','6.1','4',0.00,2000.00,'Retail Sale Id 34 for retail product','2023-02-04 11:34:05','',''),('1','311',66,'','20','3',3000.00,0.00,'Retail Sale Id 35 for 3.95 KG of Cooking Gas @ N760.00','2023-02-04 11:49:15','',''),('1','311',67,'','6.1','4',0.00,3000.00,'Retail Sale Id 35 for retail product','2023-02-04 11:49:15','',''),('1','311',68,'','20','3',4500.00,0.00,'Retail Sale Id 36 for 5.92 KG of Cooking Gas @ N760.00','2023-02-04 11:51:30','',''),('1','311',69,'','6.1','4',0.00,4500.00,'Retail Sale Id 36 for retail product','2023-02-04 11:51:30','',''),('1','311',70,'','20','3',2000.00,0.00,'Retail Sale Id 37 for 2.63 KG of Cooking Gas @ N760.00','2023-02-04 11:53:36','',''),('1','311',71,'','6.1','4',0.00,2000.00,'Retail Sale Id 37 for retail product','2023-02-04 11:53:36','',''),('1','311',72,'','20','3',0.00,4500.00,'Return of Retail Sale Id 36 for products','2023-02-04 11:57:44','',''),('1','311',73,'','','',4500.00,0.00,'Return of Retail Sale Id 36 for products','2023-02-04 11:57:44','',''),('1','311',74,'','20','3',4000.00,0.00,'Retail Sale Id 38 for 5.26 KG of Cooking Gas @ N760.00','2023-02-04 11:59:10','',''),('1','311',75,'','6.1','4',0.00,4000.00,'Retail Sale Id 38 for retail product','2023-02-04 11:59:10','',''),('1','311',76,'','20','3',4530.00,0.00,'Retail Sale Id 39 for 5.96 KG of Cooking Gas @ N760.00','2023-02-04 14:16:00','',''),('1','311',77,'','6.1','4',0.00,4530.00,'Retail Sale Id 39 for retail product','2023-02-04 14:16:00','',''),('1','311',78,'','20','3',2000.00,0.00,'Retail Sale Id 40 for 2.63 KG of Cooking Gas @ N760.00','2023-02-04 14:42:14','',''),('1','311',79,'','6.1','4',0.00,2000.00,'Retail Sale Id 40 for retail product','2023-02-04 14:42:14','',''),('1','311',80,'','20','3',0.00,2000.00,'Return of Retail Sale Id 40 for products','2023-02-04 14:45:08','',''),('1','311',81,'','','',2000.00,0.00,'Return of Retail Sale Id 40 for products','2023-02-04 14:45:08','',''),('1','311',82,'','20','3',7600.00,0.00,'Retail Sale Id 41 for 10.00 KG of Cooking Gas @ N760.00','2023-02-04 14:52:24','',''),('1','311',83,'','6.1','4',0.00,7600.00,'Retail Sale Id 41 for retail product','2023-02-04 14:52:24','',''),('1','311',84,'','20','3',1000.00,0.00,'Retail Sale Id 43 for 1.32 KG of Cooking Gas @ N760.00','2023-02-04 15:03:47','',''),('1','311',85,'','6.1','4',0.00,1000.00,'Retail Sale Id 43 for retail product','2023-02-04 15:03:47','',''),('1','311',86,'','20','3',1520.00,0.00,'Retail Sale Id 44 for 2.00 KG of Cooking Gas @ N760.00','2023-02-04 15:08:05','',''),('1','311',87,'','6.1','4',0.00,1520.00,'Retail Sale Id 44 for retail product','2023-02-04 15:08:05','',''),('1','311',88,'','20','3',760.00,0.00,'Retail Sale Id 46 for 1.00 KG of Cooking Gas @ N760.00','2023-02-04 15:13:28','',''),('1','311',89,'','6.1','4',0.00,760.00,'Retail Sale Id 46 for retail product','2023-02-04 15:13:28','',''),('1','311',90,'','20','3',1520.00,0.00,'Retail Sale Id 48 for 2.00 KG of Cooking Gas @ N760.00','2023-02-04 16:06:52','',''),('1','311',91,'','6.1','4',0.00,1520.00,'Retail Sale Id 48 for retail product','2023-02-04 16:06:52','',''),('1','311',92,'','20','3',1520.00,0.00,'Retail Sale Id 49 for 2.00 KG of Cooking Gas @ N760.00','2023-02-04 16:15:17','',''),('1','311',93,'','6.1','4',0.00,1520.00,'Retail Sale Id 49 for retail product','2023-02-04 16:15:17','',''),('1','311',94,'','20','3',760.00,0.00,'Retail Sale Id 50 for 1.00 KG of Cooking Gas @ N760.00','2023-02-04 16:21:04','',''),('1','311',95,'','6.1','4',0.00,760.00,'Retail Sale Id 50 for retail product','2023-02-04 16:21:04','',''),('1','311',96,'','20','3',9500.00,0.00,'Retail Sale Id 51 for 12.50 KG of Cooking Gas @ N760.00','2023-02-04 16:23:12','',''),('1','311',97,'','6.1','4',0.00,9500.00,'Retail Sale Id 51 for retail product','2023-02-04 16:23:12','',''),('1','311',98,'','20','3',3040.00,0.00,'Retail Sale Id 52 for 4.00 KG of Cooking Gas @ N760.00','2023-02-04 16:28:56','',''),('1','311',99,'','6.1','4',0.00,3040.00,'Retail Sale Id 52 for retail product','2023-02-04 16:28:56','',''),('1','311',100,'','20','3',3040.00,0.00,'Retail Sale Id 53 for 4.00 KG of Cooking Gas @ N760.00','2023-02-04 16:50:03','',''),('1','311',101,'','6.1','4',0.00,3040.00,'Retail Sale Id 53 for retail product','2023-02-04 16:50:03','',''),('1','311',102,'','20','3',4560.00,0.00,'Retail Sale Id 54 for 6.00 KG of Cooking Gas @ N760.00','2023-02-04 16:53:20','',''),('1','311',103,'','6.1','4',0.00,4560.00,'Retail Sale Id 54 for retail product','2023-02-04 16:53:20','',''),('1','311',104,'','20','3',10000.00,0.00,'Retail Sale Id 55 for multiple products','2023-02-04 17:16:46','',''),('1','311',105,'','6.1','4',0.00,10000.00,'Retail Sale Id 55 for retail product','2023-02-04 17:16:46','',''),('1','311',106,'','20','3',9500.00,0.00,'Retail Sale Id 56 for 12.50 KG of Cooking Gas @ N760.00','2023-02-04 17:19:21','',''),('1','311',107,'','6.1','4',0.00,9500.00,'Retail Sale Id 56 for retail product','2023-02-04 17:19:21','',''),('1','311',108,'','20','3',6080.00,0.00,'Retail Sale Id 57 for 8.00 KG of Cooking Gas @ N760.00','2023-02-04 17:24:24','',''),('1','311',109,'','6.1','4',0.00,6080.00,'Retail Sale Id 57 for retail product','2023-02-04 17:24:24','',''),('1','311',110,'','20','3',8500.00,0.00,'Retail Sale Id 58 for 11.18 KG of Cooking Gas @ N760.00','2023-02-04 17:53:37','',''),('1','311',111,'','6.1','4',0.00,8500.00,'Retail Sale Id 58 for retail product','2023-02-04 17:53:37','',''),('1','311',112,'','20','3',1500.00,0.00,'Retail Sale Id 59 for 1.97 KG of Cooking Gas @ N760.00','2023-02-04 17:57:23','',''),('1','311',113,'','6.1','4',0.00,1500.00,'Retail Sale Id 59 for retail product','2023-02-04 17:57:23','',''),('1','311',114,'','20','3',2350.00,0.00,'Retail Sale Id 60 for 3.09 KG of Cooking Gas @ N760.00','2023-02-04 18:04:28','',''),('1','311',115,'','6.1','4',0.00,2350.00,'Retail Sale Id 60 for retail product','2023-02-04 18:04:28','',''),('1','311',116,'','20','3',0.00,760.00,'Return of Retail Sale Id 50 for products','2023-02-04 20:28:46','',''),('1','311',117,'','','',760.00,0.00,'Return of Retail Sale Id 50 for products','2023-02-04 20:28:46','',''),('1','311',118,'','20','3',1026.00,0.00,'Retail Sale Id 61 for 1.35 KG of Cooking Gas @ N760.00','2023-02-04 20:35:05','',''),('1','311',119,'','6.1','4',0.00,1026.00,'Retail Sale Id 61 for retail product','2023-02-04 20:35:05','',''),('1','311',120,'','20','3',0.00,9500.00,'Return of Retail Sale Id 56 for products','2023-02-04 20:42:54','',''),('1','311',121,'','','',9500.00,0.00,'Return of Retail Sale Id 56 for products','2023-02-04 20:42:54','',''),('1','311',122,'','20','3',1185.60,0.00,'Retail Sale Id 62 for 1.56 KG of Cooking Gas @ N760.00','2023-02-04 20:44:06','',''),('1','311',123,'','6.1','4',0.00,1185.60,'Retail Sale Id 62 for retail product','2023-02-04 20:44:06','',''),('1','311',124,'','20','3',12024.40,0.00,'Retail Sale Id 63 for 15.82 KG of Cooking Gas @ N760.00','2023-02-04 20:46:00','',''),('1','311',125,'','6.1','4',0.00,12024.40,'Retail Sale Id 63 for retail product','2023-02-04 20:46:00','',''),('1','311',126,'','20','3',0.00,0.00,'Sales from shift 4 on 2023-02-04 20:46:56 ','2023-02-04 20:46:56','',''),('1','311',127,'','6.1','4',0.00,0.00,'Sales from shift 4 on 2023-02-04 20:46:56 ','2023-02-04 20:46:56','',''),('1','311',128,'','20','3',2000.00,0.00,'Retail Sale Id 64 for 2.63 KG of Cooking Gas @ N760.00','2023-02-05 08:36:51','',''),('1','311',129,'','6.1','4',0.00,2000.00,'Retail Sale Id 64 for retail product','2023-02-05 08:36:51','',''),('1','311',130,'','20','3',1500.00,0.00,'Retail Sale Id 65 for 1.97 KG of Cooking Gas @ N760.00','2023-02-05 08:42:09','',''),('1','311',131,'','6.1','4',0.00,1500.00,'Retail Sale Id 65 for retail product','2023-02-05 08:42:09','',''),('1','311',132,'','20','3',1600.00,0.00,'Retail Sale Id 66 for 2.11 KG of Cooking Gas @ N760.00','2023-02-05 08:44:17','',''),('1','311',133,'','6.1','4',0.00,1600.00,'Retail Sale Id 66 for retail product','2023-02-05 08:44:17','',''),('1','311',134,'','20','3',800.00,0.00,'Retail Sale Id 67 for 1.05 KG of Cooking Gas @ N760.00','2023-02-05 08:45:44','',''),('1','311',135,'','6.1','4',0.00,800.00,'Retail Sale Id 67 for retail product','2023-02-05 08:45:44','',''),('1','311',136,'','20','3',0.00,2000.00,'Return of Retail Sale Id 64 for products','2023-02-05 09:01:07','',''),('1','311',137,'','','',2000.00,0.00,'Return of Retail Sale Id 64 for products','2023-02-05 09:01:07','',''),('1','311',138,'','20','3',7600.00,0.00,'Retail Sale Id 68 for 10.00 KG of Cooking Gas @ N760.00','2023-02-05 09:26:47','',''),('1','311',139,'','6.1','4',0.00,7600.00,'Retail Sale Id 68 for retail product','2023-02-05 09:26:47','',''),('1','311',140,'','20','3',1000.00,0.00,'Retail Sale Id 69 for 1.32 KG of Cooking Gas @ N760.00','2023-02-05 09:46:13','',''),('1','311',141,'','6.1','4',0.00,1000.00,'Retail Sale Id 69 for retail product','2023-02-05 09:46:13','',''),('1','311',142,'','20','3',0.00,0.00,'Sales from shift 5 on 2023-02-05 11:15:13 ','2023-02-05 11:15:13','',''),('1','311',143,'','6.1','4',0.00,0.00,'Sales from shift 5 on 2023-02-05 11:15:13 ','2023-02-05 11:15:13','',''),('1','311',144,'','20','3',3800.00,0.00,'Retail Sale Id 70 for 5.00 KG of Cooking Gas @ N760.00','2023-02-14 11:23:33','',''),('1','311',145,'','6.1','4',0.00,3800.00,'Retail Sale Id 70 for retail product','2023-02-14 11:23:33','',''),('1','311',146,'','20','3',3100.00,0.00,'Retail Sale Id 71 for 4.08 KG of Cooking Gas @ N760.00','2023-02-14 12:39:23','',''),('1','311',147,'','6.1','4',0.00,3100.00,'Retail Sale Id 71 for retail product','2023-02-14 12:39:23','',''),('1','311',148,'','20','3',9500.00,0.00,'Retail Sale Id 72 for 12.50 KG of Cooking Gas @ N760.00','2023-02-14 12:43:58','',''),('1','311',149,'','6.1','4',0.00,9500.00,'Retail Sale Id 72 for retail product','2023-02-14 12:43:58','',''),('1','311',150,'','20','3',0.00,0.00,'Sales from shift 6 on 2023-02-14 14:17:57 ','2023-02-14 14:17:57','',''),('1','311',151,'','6.1','4',0.00,0.00,'Sales from shift 6 on 2023-02-14 14:17:57 ','2023-02-14 14:17:57','',''),('1','311',152,'','20','3',1000.00,0.00,'Retail Sale Id 73 for 1.39 KG of Cooking Gas @ N720.00','2023-02-14 16:24:04','',''),('1','311',153,'','6.1','4',0.00,1000.00,'Retail Sale Id 73 for retail product','2023-02-14 16:24:04','',''),('1','311',154,'','20','3',2000.00,0.00,'Retail Sale Id 74 for 2.78 KG of Cooking Gas @ N720.00','2023-02-14 16:25:58','',''),('1','311',155,'','6.1','4',0.00,2000.00,'Retail Sale Id 74 for retail product','2023-02-14 16:25:58','',''),('1','311',156,'','20','3',4320.00,0.00,'Retail Sale Id 75 for 6.00 KG of Cooking Gas @ N720.00','2023-02-14 16:27:53','',''),('1','311',157,'','6.1','4',0.00,4320.00,'Retail Sale Id 75 for retail product','2023-02-14 16:27:53','',''),('1','311',158,'','20','3',3600.00,0.00,'Retail Sale Id 76 for 5.00 KG of Cooking Gas @ N720.00','2023-02-14 16:28:58','',''),('1','311',159,'','6.1','4',0.00,3600.00,'Retail Sale Id 76 for retail product','2023-02-14 16:28:58','',''),('1','311',160,'','20','3',1000.00,0.00,'Retail Sale Id 77 for 1.39 KG of Cooking Gas @ N720.00','2023-02-14 16:33:21','',''),('1','311',161,'','6.1','4',0.00,1000.00,'Retail Sale Id 77 for retail product','2023-02-14 16:33:21','',''),('1','311',162,'','6.1','4',0.00,1000.00,'Retail Sale Id 77 for retail product','2023-02-14 16:33:21','',''),('1','311',163,'','20','3',0.00,1000.00,'Return of Retail Sale Id 77 for products','2023-02-14 16:36:44','',''),('1','311',164,'','','',1000.00,0.00,'Return of Retail Sale Id 77 for products','2023-02-14 16:36:44','',''),('1','311',165,'','20','3',1500.00,0.00,'Retail Sale Id 78 for 2.08 KG of Cooking Gas @ N720.00','2023-02-14 16:37:35','',''),('1','311',166,'','6.1','4',0.00,1500.00,'Retail Sale Id 78 for retail product','2023-02-14 16:37:35','',''),('1','311',167,'','20','3',1500.00,0.00,'Retail Sale Id 79 for 2.08 KG of Cooking Gas @ N720.00','2023-02-14 16:38:42','',''),('1','311',168,'','6.1','4',0.00,1500.00,'Retail Sale Id 79 for retail product','2023-02-14 16:38:42','',''),('1','311',169,'','20','3',0.00,1500.00,'Return of Retail Sale Id 78 for products','2023-02-14 16:39:40','',''),('1','311',170,'','','',1500.00,0.00,'Return of Retail Sale Id 78 for products','2023-02-14 16:39:40','',''),('1','311',171,'','20','3',4350.00,0.00,'Retail Sale Id 82 for 6.04 KG of Cooking Gas @ N720.00','2023-02-14 17:29:53','',''),('1','311',172,'','6.1','4',0.00,4350.00,'Retail Sale Id 82 for retail product','2023-02-14 17:29:53','',''),('1','311',173,'','20','3',4000.00,0.00,'Retail Sale Id 83 for 5.56 KG of Cooking Gas @ N720.00','2023-02-14 17:37:24','',''),('1','311',174,'','6.1','4',0.00,4000.00,'Retail Sale Id 83 for retail product','2023-02-14 17:37:24','',''),('1','311',175,'','20','3',4320.00,0.00,'Retail Sale Id 84 for 6.00 KG of Cooking Gas @ N720.00','2023-02-14 17:47:29','',''),('1','311',176,'','6.1','4',0.00,4320.00,'Retail Sale Id 84 for retail product','2023-02-14 17:47:29','',''),('1','311',177,'','20','3',3600.00,0.00,'Retail Sale Id 85 for 5.00 KG of Cooking Gas @ N720.00','2023-02-14 17:58:34','',''),('1','311',178,'','6.1','4',0.00,3600.00,'Retail Sale Id 85 for retail product','2023-02-14 17:58:34','',''),('1','311',179,'','20','3',2160.00,0.00,'Retail Sale Id 86 for 3.00 KG of Cooking Gas @ N720.00','2023-02-14 18:12:42','',''),('1','311',180,'','6.1','4',0.00,2160.00,'Retail Sale Id 86 for retail product','2023-02-14 18:12:42','',''),('1','311',181,'','20','3',1400.00,0.00,'Retail Sale Id 87 for 1.94 KG of Cooking Gas @ N720.00','2023-02-14 18:15:29','',''),('1','311',182,'','6.1','4',0.00,1400.00,'Retail Sale Id 87 for retail product','2023-02-14 18:15:29','',''),('1','311',183,'','20','3',4680.00,0.00,'Retail Sale Id 88 for 6.50 KG of Cooking Gas @ N720.00','2023-02-14 18:17:31','',''),('1','311',184,'','6.1','4',0.00,4680.00,'Retail Sale Id 88 for retail product','2023-02-14 18:17:31','',''),('1','311',185,'','20','3',3500.00,0.00,'Retail Sale Id 89 for 4.86 KG of Cooking Gas @ N720.00','2023-02-14 18:20:28','',''),('1','311',186,'','6.1','4',0.00,3500.00,'Retail Sale Id 89 for retail product','2023-02-14 18:20:28','',''),('1','311',187,'','20','3',700.00,0.00,'Retail Sale Id 90 for 0.97 KG of Cooking Gas @ N720.00','2023-02-14 18:24:22','',''),('1','311',188,'','6.1','4',0.00,700.00,'Retail Sale Id 90 for retail product','2023-02-14 18:24:22','',''),('1','311',189,'','20','3',0.00,700.00,'Return of Retail Sale Id 90 for products','2023-02-14 20:15:09','',''),('1','311',190,'','','',700.00,0.00,'Return of Retail Sale Id 90 for products','2023-02-14 20:15:09','',''),('1','311',191,'','20','3',5693.20,0.00,'Retail Sale Id 91 for 7.91 KG of Cooking Gas @ N720.00','2023-02-14 20:17:21','',''),('1','311',192,'','6.1','4',0.00,5693.20,'Retail Sale Id 91 for retail product','2023-02-14 20:17:21','',''),('1','311',193,'','20','3',0.00,4000.00,'Return of Retail Sale Id 83 for products','2023-02-14 20:37:38','',''),('1','311',194,'','','',4000.00,0.00,'Return of Retail Sale Id 83 for products','2023-02-14 20:37:38','',''),('1','311',195,'','20','3',3600.00,0.00,'Retail Sale Id 92 for 5.00 KG of Cooking Gas @ N720.00','2023-02-14 20:38:28','',''),('1','311',196,'','6.1','4',0.00,3600.00,'Retail Sale Id 92 for retail product','2023-02-14 20:38:28','',''),('1','311',197,'','20','3',400.00,0.00,'Retail Sale Id 93 for 0.56 KG of Cooking Gas @ N720.00','2023-02-14 20:39:17','',''),('1','311',198,'','6.1','4',0.00,400.00,'Retail Sale Id 93 for retail product','2023-02-14 20:39:17','',''),('1','311',199,'','20','3',0.00,0.00,'Sales from shift 7 on 2023-02-15 07:18:32 ','2023-02-15 07:18:32','',''),('1','311',200,'','6.1','4',0.00,0.00,'Sales from shift 7 on 2023-02-15 07:18:32 ','2023-02-15 07:18:32','',''),('1','311',201,'','20','3',7200.00,0.00,'Retail Sale Id 94 for 10.00 KG of Cooking Gas @ N720.00','2023-02-15 07:25:36','',''),('1','311',202,'','6.1','4',0.00,7200.00,'Retail Sale Id 94 for retail product','2023-02-15 07:25:36','',''),('1','311',203,'','20','3',2000.00,0.00,'Retail Sale Id 95 for 2.78 KG of Cooking Gas @ N720.00','2023-02-15 07:49:55','',''),('1','311',204,'','6.1','4',0.00,2000.00,'Retail Sale Id 95 for retail product','2023-02-15 07:49:55','',''),('1','311',205,'','20','3',0.00,7200.00,'Return of Retail Sale Id 94 for products','2023-02-15 08:07:10','',''),('1','311',206,'','','',7200.00,0.00,'Return of Retail Sale Id 94 for products','2023-02-15 08:07:10','',''),('1','311',207,'','20','3',7200.00,0.00,'Retail Sale Id 96 for 10.00 KG of Cooking Gas @ N720.00','2023-02-15 10:46:59','',''),('1','311',208,'','6.1','4',0.00,7200.00,'Retail Sale Id 96 for retail product','2023-02-15 10:46:59','',''),('1','311',209,'','20','3',7200.00,0.00,'Retail Sale Id 97 for 10.00 KG of Cooking Gas @ N720.00','2023-02-15 12:02:13','',''),('1','311',210,'','6.1','4',0.00,7200.00,'Retail Sale Id 97 for retail product','2023-02-15 12:02:13','',''),('1','311',211,'','20','3',3000.00,0.00,'Retail Sale Id 98 for 4.17 KG of Cooking Gas @ N720.00','2023-02-15 12:06:18','',''),('1','311',212,'','6.1','4',0.00,3000.00,'Retail Sale Id 98 for retail product','2023-02-15 12:06:18','',''),('1','311',213,'','20','3',5000.00,0.00,'Retail Sale Id 99 for 6.94 KG of Cooking Gas @ N720.00','2023-02-15 13:13:27','',''),('1','311',214,'','6.1','4',0.00,5000.00,'Retail Sale Id 99 for retail product','2023-02-15 13:13:27','',''),('1','311',215,'','20','3',0.00,7200.00,'Return of Retail Sale Id 97 for products','2023-02-15 13:36:04','',''),('1','311',216,'','','',7200.00,0.00,'Return of Retail Sale Id 97 for products','2023-02-15 13:36:04','',''),('1','311',217,'','20','3',7200.00,0.00,'Retail Sale Id 100 for 10.00 KG of Cooking Gas @ N720.00','2023-02-15 13:37:20','',''),('1','311',218,'','6.1','4',0.00,7200.00,'Retail Sale Id 100 for retail product','2023-02-15 13:37:20','',''),('1','311',219,'','20','3',8640.00,0.00,'Retail Sale Id 101 for 12.00 KG of Cooking Gas @ N720.00','2023-02-15 14:01:58','',''),('1','311',220,'','6.1','4',0.00,8640.00,'Retail Sale Id 101 for retail product','2023-02-15 14:01:58','',''),('1','311',221,'','20','3',5040.00,0.00,'Retail Sale Id 102 for 7.00 KG of Cooking Gas @ N720.00','2023-02-15 14:15:28','',''),('1','311',222,'','6.1','4',0.00,5040.00,'Retail Sale Id 102 for retail product','2023-02-15 14:15:28','',''),('1','311',223,'','20','3',1440.00,0.00,'Retail Sale Id 103 for 2.00 KG of Cooking Gas @ N720.00','2023-02-15 14:20:14','',''),('1','311',224,'','6.1','4',0.00,1440.00,'Retail Sale Id 103 for retail product','2023-02-15 14:20:14','',''),('1','311',225,'','20','3',4000.00,0.00,'Retail Sale Id 104 for 5.56 KG of Cooking Gas @ N720.00','2023-02-15 14:23:04','',''),('1','311',226,'','6.1','4',0.00,4000.00,'Retail Sale Id 104 for retail product','2023-02-15 14:23:04','',''),('1','311',227,'','20','3',2900.00,0.00,'Retail Sale Id 105 for 4.03 KG of Cooking Gas @ N720.00','2023-02-15 14:24:41','',''),('1','311',228,'','6.1','4',0.00,2900.00,'Retail Sale Id 105 for retail product','2023-02-15 14:24:41','',''),('1','311',229,'','20','3',1500.00,0.00,'Retail Sale Id 106 for 2.08 KG of Cooking Gas @ N720.00','2023-02-15 14:26:33','',''),('1','311',230,'','6.1','4',0.00,1500.00,'Retail Sale Id 106 for retail product','2023-02-15 14:26:33','',''),('1','311',231,'','20','3',7200.00,0.00,'Retail Sale Id 107 for 10.00 KG of Cooking Gas @ N720.00','2023-02-15 14:31:44','',''),('1','311',232,'','6.1','4',0.00,7200.00,'Retail Sale Id 107 for retail product','2023-02-15 14:31:44','',''),('1','311',233,'','20','3',1000.00,0.00,'Retail Sale Id 108 for 1.39 KG of Cooking Gas @ N720.00','2023-02-15 14:34:33','',''),('1','311',234,'','6.1','4',0.00,1000.00,'Retail Sale Id 108 for retail product','2023-02-15 14:34:33','',''),('1','311',235,'','20','3',8640.00,0.00,'Retail Sale Id 109 for 12.00 KG of Cooking Gas @ N720.00','2023-02-15 14:36:33','',''),('1','311',236,'','6.1','4',0.00,8640.00,'Retail Sale Id 109 for retail product','2023-02-15 14:36:33','',''),('1','311',237,'','20','3',3600.00,0.00,'Retail Sale Id 110 for 5.00 KG of Cooking Gas @ N720.00','2023-02-15 15:14:02','',''),('1','311',238,'','6.1','4',0.00,3600.00,'Retail Sale Id 110 for retail product','2023-02-15 15:14:02','',''),('1','311',239,'','20','3',3000.00,0.00,'Retail Sale Id 111 for 4.17 KG of Cooking Gas @ N720.00','2023-02-15 15:56:15','',''),('1','311',240,'','6.1','4',0.00,3000.00,'Retail Sale Id 111 for retail product','2023-02-15 15:56:15','',''),('1','311',241,'','20','3',1800.00,0.00,'Retail Sale Id 112 for 2.50 KG of Cooking Gas @ N720.00','2023-02-15 15:58:14','',''),('1','311',242,'','6.1','4',0.00,1800.00,'Retail Sale Id 112 for retail product','2023-02-15 15:58:14','',''),('1','311',243,'','20','3',1440.00,0.00,'Retail Sale Id 113 for 2.00 KG of Cooking Gas @ N720.00','2023-02-15 16:06:24','',''),('1','311',244,'','6.1','4',0.00,1440.00,'Retail Sale Id 113 for retail product','2023-02-15 16:06:24','',''),('1','311',245,'','20','3',7200.00,0.00,'Retail Sale Id 115 for 10.00 KG of Cooking Gas @ N720.00','2023-02-15 16:45:47','',''),('1','311',246,'','6.1','4',0.00,7200.00,'Retail Sale Id 115 for retail product','2023-02-15 16:45:47','',''),('1','311',247,'','20','3',4320.00,0.00,'Retail Sale Id 116 for 6.00 KG of Cooking Gas @ N720.00','2023-02-15 16:47:47','',''),('1','311',248,'','6.1','4',0.00,4320.00,'Retail Sale Id 116 for retail product','2023-02-15 16:47:47','',''),('1','311',249,'','20','3',5040.00,0.00,'Retail Sale Id 118 for 7.00 KG of Cooking Gas @ N720.00','2023-02-15 16:54:36','',''),('1','311',250,'','6.1','4',0.00,5040.00,'Retail Sale Id 118 for retail product','2023-02-15 16:54:36','',''),('1','311',251,'','20','3',3600.00,0.00,'Retail Sale Id 120 for 5.00 KG of Cooking Gas @ N720.00','2023-02-15 17:00:45','',''),('1','311',252,'','6.1','4',0.00,3600.00,'Retail Sale Id 120 for retail product','2023-02-15 17:00:45','',''),('1','311',253,'','20','3',1450.00,0.00,'Retail Sale Id 121 for 2.01 KG of Cooking Gas @ N720.00','2023-02-15 17:23:31','',''),('1','311',254,'','6.1','4',0.00,1450.00,'Retail Sale Id 121 for retail product','2023-02-15 17:23:31','',''),('1','311',255,'','20','3',1000.00,0.00,'Retail Sale Id 122 for 1.39 KG of Cooking Gas @ N720.00','2023-02-15 17:31:44','',''),('1','311',256,'','6.1','4',0.00,1000.00,'Retail Sale Id 122 for retail product','2023-02-15 17:31:44','',''),('1','311',257,'','20','3',1000.00,0.00,'Retail Sale Id 123 for 1.39 KG of Cooking Gas @ N720.00','2023-02-15 17:34:23','',''),('1','311',258,'','6.1','4',0.00,1000.00,'Retail Sale Id 123 for retail product','2023-02-15 17:34:23','',''),('1','311',259,'','20','3',3000.00,0.00,'Retail Sale Id 124 for 4.17 KG of Cooking Gas @ N720.00','2023-02-15 18:46:19','',''),('1','311',260,'','6.1','4',0.00,3000.00,'Retail Sale Id 124 for retail product','2023-02-15 18:46:19','',''),('1','311',261,'','20','3',0.00,0.00,'Sales from shift 8 on 2023-02-15 21:31:04 ','2023-02-15 21:31:04','',''),('1','311',262,'','6.1','4',0.00,0.00,'Sales from shift 8 on 2023-02-15 21:31:04 ','2023-02-15 21:31:04','',''),('1','311',263,'','20','3',3000.00,0.00,'Retail Sale Id 125 for 4.17 KG of Cooking Gas @ N720.00','2023-02-16 08:17:35','',''),('1','311',264,'','6.1','4',0.00,3000.00,'Retail Sale Id 125 for retail product','2023-02-16 08:17:35','',''),('1','311',265,'','20','3',9000.00,0.00,'Retail Sale Id 126 for 12.50 KG of Cooking Gas @ N720.00','2023-02-16 08:39:32','',''),('1','311',266,'','6.1','4',0.00,9000.00,'Retail Sale Id 126 for retail product','2023-02-16 08:39:32','',''),('1','311',267,'','20','3',1500.00,0.00,'Retail Sale Id 127 for 2.08 KG of Cooking Gas @ N720.00','2023-02-16 08:46:45','',''),('1','311',268,'','6.1','4',0.00,1500.00,'Retail Sale Id 127 for retail product','2023-02-16 08:46:45','',''),('1','311',269,'','20','3',2000.00,0.00,'Retail Sale Id 128 for 2.78 KG of Cooking Gas @ N720.00','2023-02-16 08:50:09','',''),('1','311',270,'','6.1','4',0.00,2000.00,'Retail Sale Id 128 for retail product','2023-02-16 08:50:09','',''),('1','311',271,'','20','3',1440.00,0.00,'Retail Sale Id 130 for 2.00 KG of Cooking Gas @ N720.00','2023-02-16 09:04:28','',''),('1','311',272,'','6.1','4',0.00,1440.00,'Retail Sale Id 130 for retail product','2023-02-16 09:04:28','',''),('1','311',273,'','6.1','4',0.00,1440.00,'Retail Sale Id 130 for retail product','2023-02-16 09:04:28','',''),('1','311',274,'','20','3',9000.00,0.00,'Retail Sale Id 132 for 12.50 KG of Cooking Gas @ N720.00','2023-02-16 09:06:15','',''),('1','311',275,'','6.1','4',0.00,9000.00,'Retail Sale Id 132 for retail product','2023-02-16 09:06:15','',''),('1','311',276,'','20','3',2170.00,0.00,'Retail Sale Id 133 for 3.01 KG of Cooking Gas @ N720.00','2023-02-16 09:32:58','',''),('1','311',277,'','6.1','4',0.00,2170.00,'Retail Sale Id 133 for retail product','2023-02-16 09:32:58','',''),('1','311',278,'','20','3',3960.00,0.00,'Retail Sale Id 135 for 5.50 KG of Cooking Gas @ N720.00','2023-02-16 09:36:59','',''),('1','311',279,'','6.1','4',0.00,3960.00,'Retail Sale Id 135 for retail product','2023-02-16 09:36:59','',''),('1','311',280,'','20','3',3600.00,0.00,'Retail Sale Id 136 for 5.00 KG of Cooking Gas @ N720.00','2023-02-16 09:56:27','',''),('1','311',281,'','6.1','4',0.00,3600.00,'Retail Sale Id 136 for retail product','2023-02-16 09:56:27','',''),('1','311',282,'','20','3',4320.00,0.00,'Retail Sale Id 138 for 6.00 KG of Cooking Gas @ N720.00','2023-02-16 10:50:25','',''),('1','311',283,'','6.1','4',0.00,4320.00,'Retail Sale Id 138 for retail product','2023-02-16 10:50:25','',''),('1','311',284,'','20','3',8640.00,0.00,'Retail Sale Id 139 for 12.00 KG of Cooking Gas @ N720.00','2023-02-16 11:09:43','',''),('1','311',285,'','6.1','4',0.00,8640.00,'Retail Sale Id 139 for retail product','2023-02-16 11:09:43','',''),('1','311',286,'','20','3',5040.00,0.00,'Retail Sale Id 141 for 7.00 KG of Cooking Gas @ N720.00','2023-02-16 11:34:21','',''),('1','311',287,'','6.1','4',0.00,5040.00,'Retail Sale Id 141 for retail product','2023-02-16 11:34:21','',''),('1','311',288,'','20','3',1500.00,0.00,'Retail Sale Id 143 for 2.08 KG of Cooking Gas @ N720.00','2023-02-16 11:39:05','',''),('1','311',289,'','6.1','4',0.00,1500.00,'Retail Sale Id 143 for retail product','2023-02-16 11:39:05','',''),('1','311',290,'','20','3',2160.00,0.00,'Retail Sale Id 144 for 3.00 KG of Cooking Gas @ N720.00','2023-02-16 11:44:37','',''),('1','311',291,'','6.1','4',0.00,2160.00,'Retail Sale Id 144 for retail product','2023-02-16 11:44:37','',''),('1','311',292,'','20','3',3600.00,0.00,'Retail Sale Id 145 for 5.00 KG of Cooking Gas @ N720.00','2023-02-16 12:54:34','',''),('1','311',293,'','6.1','4',0.00,3600.00,'Retail Sale Id 145 for retail product','2023-02-16 12:54:34','',''),('1','311',294,'','20','3',5040.00,0.00,'Retail Sale Id 146 for 7.00 KG of Cooking Gas @ N720.00','2023-02-16 12:57:37','',''),('1','311',295,'','6.1','4',0.00,5040.00,'Retail Sale Id 146 for retail product','2023-02-16 12:57:37','',''),('1','311',296,'','20','3',9000.00,0.00,'Retail Sale Id 147 for 12.50 KG of Cooking Gas @ N720.00','2023-02-16 13:10:30','',''),('1','311',297,'','6.1','4',0.00,9000.00,'Retail Sale Id 147 for retail product','2023-02-16 13:10:30','',''),('1','311',298,'','20','3',4000.00,0.00,'Retail Sale Id 148 for 5.56 KG of Cooking Gas @ N720.00','2023-02-16 14:29:36','',''),('1','311',299,'','6.1','4',0.00,4000.00,'Retail Sale Id 148 for retail product','2023-02-16 14:29:36','',''),('1','311',300,'','20','3',2400.00,0.00,'Retail Sale Id 149 for 3.33 KG of Cooking Gas @ N720.00','2023-02-16 14:51:05','',''),('1','311',301,'','6.1','4',0.00,2400.00,'Retail Sale Id 149 for retail product','2023-02-16 14:51:05','',''),('1','311',302,'','20','3',8640.00,0.00,'Retail Sale Id 150 for 12.00 KG of Cooking Gas @ N720.00','2023-02-16 14:52:49','',''),('1','311',303,'','6.1','4',0.00,8640.00,'Retail Sale Id 150 for retail product','2023-02-16 14:52:49','',''),('1','311',304,'','20','3',5000.00,0.00,'Retail Sale Id 151 for 6.94 KG of Cooking Gas @ N720.00','2023-02-16 15:09:54','',''),('1','311',305,'','6.1','4',0.00,5000.00,'Retail Sale Id 151 for retail product','2023-02-16 15:09:54','',''),('1','311',306,'','20','3',4320.00,0.00,'Retail Sale Id 153 for 6.00 KG of Cooking Gas @ N720.00','2023-02-16 15:35:39','',''),('1','311',307,'','6.1','4',0.00,4320.00,'Retail Sale Id 153 for retail product','2023-02-16 15:35:39','',''),('1','311',308,'','20','3',2160.00,0.00,'Retail Sale Id 154 for 3.00 KG of Cooking Gas @ N720.00','2023-02-16 16:03:20','',''),('1','311',309,'','6.1','4',0.00,2160.00,'Retail Sale Id 154 for retail product','2023-02-16 16:03:20','',''),('1','311',310,'','20','3',3000.00,0.00,'Retail Sale Id 155 for 4.17 KG of Cooking Gas @ N720.00','2023-02-16 16:04:49','',''),('1','311',311,'','6.1','4',0.00,3000.00,'Retail Sale Id 155 for retail product','2023-02-16 16:04:49','',''),('1','311',312,'','20','3',5040.00,0.00,'Retail Sale Id 157 for 7.00 KG of Cooking Gas @ N720.00','2023-02-16 16:18:49','',''),('1','311',313,'','6.1','4',0.00,5050.00,'Retail Sale Id 157 for retail product','2023-02-16 16:18:49','',''),('1','311',314,'','20','3',4320.00,0.00,'Retail Sale Id 158 for 6.00 KG of Cooking Gas @ N720.00','2023-02-16 16:22:50','',''),('1','311',315,'','6.1','4',0.00,4320.00,'Retail Sale Id 158 for retail product','2023-02-16 16:22:50','',''),('1','311',316,'','20','3',2150.00,0.00,'Retail Sale Id 159 for 2.99 KG of Cooking Gas @ N720.00','2023-02-16 16:37:27','',''),('1','311',317,'','6.1','4',0.00,2150.00,'Retail Sale Id 159 for retail product','2023-02-16 16:37:27','',''),('1','311',318,'','20','3',9000.00,0.00,'Retail Sale Id 160 for 12.50 KG of Cooking Gas @ N720.00','2023-02-16 16:38:32','',''),('1','311',319,'','6.1','4',0.00,9000.00,'Retail Sale Id 160 for retail product','2023-02-16 16:38:32','',''),('1','311',320,'','20','3',1000.00,0.00,'Retail Sale Id 161 for 1.39 KG of Cooking Gas @ N720.00','2023-02-16 16:40:07','',''),('1','311',321,'','6.1','4',0.00,1000.00,'Retail Sale Id 161 for retail product','2023-02-16 16:40:07','',''),('1','311',322,'','20','3',2880.00,0.00,'Retail Sale Id 163 for 4.00 KG of Cooking Gas @ N720.00','2023-02-16 16:44:43','',''),('1','311',323,'','6.1','4',0.00,2880.00,'Retail Sale Id 163 for retail product','2023-02-16 16:44:43','',''),('1','311',324,'','20','3',3600.00,0.00,'Retail Sale Id 164 for 5.00 KG of Cooking Gas @ N720.00','2023-02-16 16:46:50','',''),('1','311',325,'','6.1','4',0.00,3600.00,'Retail Sale Id 164 for retail product','2023-02-16 16:46:50','',''),('1','311',326,'','20','3',6480.00,0.00,'Retail Sale Id 165 for multiple products','2023-02-16 17:13:46','',''),('1','311',327,'','6.1','4',0.00,6480.00,'Retail Sale Id 165 for retail product','2023-02-16 17:13:46','',''),('1','311',328,'','20','3',2160.00,0.00,'Retail Sale Id 166 for 3.00 KG of Cooking Gas @ N720.00','2023-02-16 17:19:17','',''),('1','311',329,'','6.1','4',0.00,2160.00,'Retail Sale Id 166 for retail product','2023-02-16 17:19:17','',''),('1','311',330,'','20','3',750.00,0.00,'Retail Sale Id 167 for 1.04 KG of Cooking Gas @ N720.00','2023-02-16 17:27:20','',''),('1','311',331,'','6.1','4',0.00,750.00,'Retail Sale Id 167 for retail product','2023-02-16 17:27:20','',''),('1','311',332,'','20','3',1450.00,0.00,'Retail Sale Id 168 for 2.01 KG of Cooking Gas @ N720.00','2023-02-16 17:30:33','',''),('1','311',333,'','6.1','4',0.00,1450.00,'Retail Sale Id 168 for retail product','2023-02-16 17:30:33','',''),('1','311',334,'','20','3',2160.00,0.00,'Retail Sale Id 169 for 3.00 KG of Cooking Gas @ N720.00','2023-02-16 17:53:37','',''),('1','311',335,'','6.1','4',0.00,2160.00,'Retail Sale Id 169 for retail product','2023-02-16 17:53:37','',''),('1','311',336,'','20','3',0.00,0.00,'Sales from shift 9 on 2023-02-16 18:23:37 ','2023-02-16 18:23:37','',''),('1','311',337,'','6.1','4',0.00,0.00,'Sales from shift 9 on 2023-02-16 18:23:37 ','2023-02-16 18:23:37','',''),('1','311',338,'','20','3',5040.00,0.00,'Retail Sale Id 170 for 7.00 KG of Cooking Gas @ N720.00','2023-02-17 08:19:58','',''),('1','311',339,'','6.1','4',0.00,5040.00,'Retail Sale Id 170 for retail product','2023-02-17 08:19:58','',''),('1','311',340,'','20','3',7200.00,0.00,'Retail Sale Id 171 for 10.00 KG of Cooking Gas @ N720.00','2023-02-17 09:08:56','',''),('1','311',341,'','6.1','4',0.00,7200.00,'Retail Sale Id 171 for retail product','2023-02-17 09:08:56','',''),('1','311',342,'','20','3',9000.00,0.00,'Retail Sale Id 172 for 12.50 KG of Cooking Gas @ N720.00','2023-02-17 09:28:55','',''),('1','311',343,'','6.1','4',0.00,9000.00,'Retail Sale Id 172 for retail product','2023-02-17 09:28:55','',''),('1','311',344,'','20','3',8640.00,0.00,'Retail Sale Id 173 for 12.00 KG of Cooking Gas @ N720.00','2023-02-17 10:40:19','',''),('1','311',345,'','6.1','4',0.00,8640.00,'Retail Sale Id 173 for retail product','2023-02-17 10:40:19','',''),('1','311',346,'','20','3',5040.00,0.00,'Retail Sale Id 174 for 7.00 KG of Cooking Gas @ N720.00','2023-02-17 10:41:17','',''),('1','311',347,'','6.1','4',0.00,5040.00,'Retail Sale Id 174 for retail product','2023-02-17 10:41:17','',''),('1','311',348,'','20','3',3960.00,0.00,'Retail Sale Id 175 for 5.50 KG of Cooking Gas @ N720.00','2023-02-17 11:06:51','',''),('1','311',349,'','6.1','4',0.00,3960.00,'Retail Sale Id 175 for retail product','2023-02-17 11:06:51','',''),('1','311',350,'','20','3',5040.00,0.00,'Retail Sale Id 176 for 7.00 KG of Cooking Gas @ N720.00','2023-02-17 11:33:51','',''),('1','311',351,'','6.1','4',0.00,5040.00,'Retail Sale Id 176 for retail product','2023-02-17 11:33:51','',''),('1','311',352,'','20','3',4000.00,0.00,'Retail Sale Id 179 for multiple products','2023-02-17 11:40:09','',''),('1','311',353,'','6.1','4',0.00,4000.00,'Retail Sale Id 179 for retail product','2023-02-17 11:40:09','',''),('1','311',354,'','20','3',1000.00,0.00,'Retail Sale Id 181 for 1.39 KG of Cooking Gas @ N720.00','2023-02-17 12:05:10','',''),('1','311',355,'','6.1','4',0.00,1000.00,'Retail Sale Id 181 for retail product','2023-02-17 12:05:10','',''),('1','311',356,'','20','3',4000.00,0.00,'Retail Sale Id 182 for 5.56 KG of Cooking Gas @ N720.00','2023-02-17 12:18:07','',''),('1','311',357,'','6.1','4',0.00,4000.00,'Retail Sale Id 182 for retail product','2023-02-17 12:18:07','',''),('1','311',358,'','20','3',5040.00,0.00,'Retail Sale Id 183 for 7.00 KG of Cooking Gas @ N720.00','2023-02-17 12:22:59','',''),('1','311',359,'','6.1','4',0.00,5040.00,'Retail Sale Id 183 for retail product','2023-02-17 12:22:59','',''),('1','311',360,'','20','3',4000.00,0.00,'Retail Sale Id 184 for multiple products','2023-02-17 12:40:33','',''),('1','311',361,'','6.1','4',0.00,4000.00,'Retail Sale Id 184 for retail product','2023-02-17 12:40:33','',''),('1','311',362,'','20','3',7200.00,0.00,'Retail Sale Id 185 for 10.00 KG of Cooking Gas @ N720.00','2023-02-17 13:17:34','',''),('1','311',363,'','6.1','4',0.00,7200.00,'Retail Sale Id 185 for retail product','2023-02-17 13:17:34','',''),('1','311',364,'','20','3',9000.00,0.00,'Retail Sale Id 186 for 12.50 KG of Cooking Gas @ N720.00','2023-02-17 13:19:26','',''),('1','311',365,'','6.1','4',0.00,9000.00,'Retail Sale Id 186 for retail product','2023-02-17 13:19:26','',''),('1','311',366,'','20','3',3600.00,0.00,'Retail Sale Id 187 for 5.00 KG of Cooking Gas @ N720.00','2023-02-17 14:08:28','',''),('1','311',367,'','6.1','4',0.00,3600.00,'Retail Sale Id 187 for retail product','2023-02-17 14:08:28','',''),('1','311',368,'','20','3',5040.00,0.00,'Retail Sale Id 188 for 7.00 KG of Cooking Gas @ N720.00','2023-02-17 14:26:14','',''),('1','311',369,'','6.1','4',0.00,5040.00,'Retail Sale Id 188 for retail product','2023-02-17 14:26:14','',''),('1','311',370,'','20','3',2160.00,0.00,'Retail Sale Id 189 for 3.00 KG of Cooking Gas @ N720.00','2023-02-17 14:29:40','',''),('1','311',371,'','6.1','4',0.00,2160.00,'Retail Sale Id 189 for retail product','2023-02-17 14:29:40','',''),('1','311',372,'','20','3',800.00,0.00,'Retail Sale Id 191 for 1.11 KG of Cooking Gas @ N720.00','2023-02-17 14:35:00','',''),('1','311',373,'','6.1','4',0.00,800.00,'Retail Sale Id 191 for retail product','2023-02-17 14:35:00','',''),('1','311',374,'','20','3',3600.00,0.00,'Retail Sale Id 192 for 5.00 KG of Cooking Gas @ N720.00','2023-02-17 14:39:07','',''),('1','311',375,'','6.1','4',0.00,3600.00,'Retail Sale Id 192 for retail product','2023-02-17 14:39:07','',''),('1','311',376,'','20','3',4320.00,0.00,'Retail Sale Id 195 for 6.00 KG of Cooking Gas @ N720.00','2023-02-17 15:24:39','',''),('1','311',377,'','6.1','4',0.00,4320.00,'Retail Sale Id 195 for retail product','2023-02-17 15:24:39','',''),('1','311',378,'','20','3',1440.00,0.00,'Retail Sale Id 196 for 2.00 KG of Cooking Gas @ N720.00','2023-02-17 16:28:25','',''),('1','311',379,'','6.1','4',0.00,1440.00,'Retail Sale Id 196 for retail product','2023-02-17 16:28:25','',''),('1','311',380,'','20','3',2160.00,0.00,'Retail Sale Id 197 for 3.00 KG of Cooking Gas @ N720.00','2023-02-17 16:33:02','',''),('1','311',381,'','6.1','4',0.00,2160.00,'Retail Sale Id 197 for retail product','2023-02-17 16:33:02','',''),('1','311',382,'','20','3',4320.00,0.00,'Retail Sale Id 198 for 6.00 KG of Cooking Gas @ N720.00','2023-02-17 16:35:47','',''),('1','311',383,'','6.1','4',0.00,4320.00,'Retail Sale Id 198 for retail product','2023-02-17 16:35:47','',''),('1','311',384,'','20','3',1500.00,0.00,'Retail Sale Id 199 for 2.08 KG of Cooking Gas @ N720.00','2023-02-17 16:59:25','',''),('1','311',385,'','6.1','4',0.00,1500.00,'Retail Sale Id 199 for retail product','2023-02-17 16:59:25','',''),('1','311',386,'','20','3',0.00,800.00,'Return of Retail Sale Id 191 for products','2023-02-17 20:43:47','',''),('1','311',387,'','','',800.00,0.00,'Return of Retail Sale Id 191 for products','2023-02-17 20:43:47','',''),('1','311',388,'','20','3',807.20,0.00,'Retail Sale Id 202 for 1.12 KG of Cooking Gas @ N720.00','2023-02-17 20:45:55','',''),('1','311',389,'','6.1','4',0.00,807.20,'Retail Sale Id 202 for retail product','2023-02-17 20:45:55','',''),('1','311',390,'','20','3',0.00,0.00,'Sales from shift 10 on 2023-02-17 20:47:18 ','2023-02-17 20:47:18','',''),('1','311',391,'','6.1','4',0.00,0.00,'Sales from shift 10 on 2023-02-17 20:47:18 ','2023-02-17 20:47:18','',''),('1','311',392,'','20','3',1500.00,0.00,'Retail Sale Id 203 for 2.08 KG of Cooking Gas @ N720.00','2023-02-18 08:13:18','',''),('1','311',393,'','6.1','4',0.00,1500.00,'Retail Sale Id 203 for retail product','2023-02-18 08:13:18','',''),('1','311',394,'','20','3',4320.00,0.00,'Retail Sale Id 205 for 6.00 KG of Cooking Gas @ N720.00','2023-02-18 08:28:23','',''),('1','311',395,'','6.1','4',0.00,4320.00,'Retail Sale Id 205 for retail product','2023-02-18 08:28:23','',''),('1','311',396,'','20','3',3000.00,0.00,'Retail Sale Id 207 for 4.17 KG of Cooking Gas @ N720.00','2023-02-18 09:31:13','',''),('1','311',397,'','6.1','4',0.00,3000.00,'Retail Sale Id 207 for retail product','2023-02-18 09:31:13','',''),('1','311',398,'','20','3',5050.00,0.00,'Retail Sale Id 208 for 7.01 KG of Cooking Gas @ N720.00','2023-02-18 09:35:13','',''),('1','311',399,'','6.1','4',0.00,5050.00,'Retail Sale Id 208 for retail product','2023-02-18 09:35:13','',''),('1','311',400,'','20','3',1000.00,0.00,'Retail Sale Id 209 for 1.39 KG of Cooking Gas @ N720.00','2023-02-18 10:06:42','',''),('1','311',401,'','6.1','4',0.00,1000.00,'Retail Sale Id 209 for retail product','2023-02-18 10:06:42','',''),('1','311',402,'','20','3',5000.00,0.00,'Retail Sale Id 211 for 6.94 KG of Cooking Gas @ N720.00','2023-02-18 10:45:42','',''),('1','311',403,'','6.1','4',0.00,5000.00,'Retail Sale Id 211 for retail product','2023-02-18 10:45:42','',''),('1','311',404,'','20','3',1450.00,0.00,'Retail Sale Id 212 for 2.01 KG of Cooking Gas @ N720.00','2023-02-18 10:54:27','',''),('1','311',405,'','6.1','4',0.00,1450.00,'Retail Sale Id 212 for retail product','2023-02-18 10:54:27','',''),('1','311',406,'','20','3',2000.00,0.00,'Retail Sale Id 213 for 2.78 KG of Cooking Gas @ N720.00','2023-02-18 13:37:18','',''),('1','311',407,'','6.1','4',0.00,2000.00,'Retail Sale Id 213 for retail product','2023-02-18 13:37:18','',''),('1','311',408,'','20','3',4320.00,0.00,'Retail Sale Id 214 for 6.00 KG of Cooking Gas @ N720.00','2023-02-18 13:39:19','',''),('1','311',409,'','6.1','4',0.00,4320.00,'Retail Sale Id 214 for retail product','2023-02-18 13:39:19','',''),('1','311',410,'','20','3',9000.00,0.00,'Retail Sale Id 215 for 12.50 KG of Cooking Gas @ N720.00','2023-02-18 13:41:03','',''),('1','311',411,'','6.1','4',0.00,9000.00,'Retail Sale Id 215 for retail product','2023-02-18 13:41:03','',''),('1','311',412,'','20','3',2160.00,0.00,'Retail Sale Id 216 for 3.00 KG of Cooking Gas @ N720.00','2023-02-18 13:42:14','',''),('1','311',413,'','6.1','4',0.00,2160.00,'Retail Sale Id 216 for retail product','2023-02-18 13:42:14','',''),('1','311',414,'','20','3',2000.00,0.00,'Retail Sale Id 217 for 2.78 KG of Cooking Gas @ N720.00','2023-02-18 13:43:24','',''),('1','311',415,'','6.1','4',0.00,2000.00,'Retail Sale Id 217 for retail product','2023-02-18 13:43:24','',''),('1','311',416,'','20','3',7200.00,0.00,'Retail Sale Id 218 for 10.00 KG of Cooking Gas @ N720.00','2023-02-18 13:45:55','',''),('1','311',417,'','6.1','4',0.00,7200.00,'Retail Sale Id 218 for retail product','2023-02-18 13:45:55','',''),('1','311',418,'','20','3',3000.00,0.00,'Retail Sale Id 220 for 4.17 KG of Cooking Gas @ N720.00','2023-02-18 14:34:13','',''),('1','311',419,'','6.1','4',0.00,3000.00,'Retail Sale Id 220 for retail product','2023-02-18 14:34:13','',''),('1','311',420,'','20','3',720.00,0.00,'Retail Sale Id 223 for 1.00 KG of Cooking Gas @ N720.00','2023-02-18 14:53:52','',''),('1','311',421,'','6.1','4',0.00,720.00,'Retail Sale Id 223 for retail product','2023-02-18 14:53:52','',''),('1','311',422,'','20','3',0.00,720.00,'Return of Retail Sale Id 223 for products','2023-02-18 14:58:08','',''),('1','311',423,'','','',720.00,0.00,'Return of Retail Sale Id 223 for products','2023-02-18 14:58:08','',''),('1','311',424,'','20','3',720.00,0.00,'Retail Sale Id 224 for 1.00 KG of Cooking Gas @ N720.00','2023-02-18 14:59:40','',''),('1','311',425,'','6.1','4',0.00,720.00,'Retail Sale Id 224 for retail product','2023-02-18 14:59:40','',''),('1','311',426,'','20','3',8640.00,0.00,'Retail Sale Id 225 for 12.00 KG of Cooking Gas @ N720.00','2023-02-18 15:14:27','',''),('1','311',427,'','6.1','4',0.00,8640.00,'Retail Sale Id 225 for retail product','2023-02-18 15:14:27','',''),('1','311',428,'','20','3',9000.00,0.00,'Retail Sale Id 227 for 12.50 KG of Cooking Gas @ N720.00','2023-02-18 16:26:53','',''),('1','311',429,'','6.1','4',0.00,9000.00,'Retail Sale Id 227 for retail product','2023-02-18 16:26:53','',''),('1','311',430,'','20','3',800.00,0.00,'Retail Sale Id 228 for 1.11 KG of Cooking Gas @ N720.00','2023-02-18 16:31:22','',''),('1','311',431,'','6.1','4',0.00,800.00,'Retail Sale Id 228 for retail product','2023-02-18 16:31:22','',''),('1','311',432,'','20','3',0.00,5050.00,'Return of Retail Sale Id 208 for products','2023-02-18 21:28:19','',''),('1','311',433,'','','',5050.00,0.00,'Return of Retail Sale Id 208 for products','2023-02-18 21:28:19','',''),('1','311',434,'','20','3',5049.93,0.00,'Retail Sale Id 229 for 7.01 KG of Cooking Gas @ N720.00','2023-02-18 21:30:45','',''),('1','311',435,'','6.1','4',0.00,5049.93,'Retail Sale Id 229 for retail product','2023-02-18 21:30:45','',''),('1','311',436,'','20','3',0.00,5049.93,'Return of Retail Sale Id 229 for products','2023-02-18 21:32:52','',''),('1','311',437,'','','',5049.93,0.00,'Return of Retail Sale Id 229 for products','2023-02-18 21:32:52','',''),('1','311',438,'','20','3',4996.40,0.00,'Retail Sale Id 230 for 6.94 KG of Cooking Gas @ N720.00','2023-02-18 21:35:12','',''),('1','311',439,'','6.1','4',0.00,4996.40,'Retail Sale Id 230 for retail product','2023-02-18 21:35:12','',''),('1','311',440,'','20','3',0.00,0.00,'Sales from shift 11 on 2023-02-18 21:37:10 ','2023-02-18 21:37:10','',''),('1','311',441,'','6.1','4',0.00,0.00,'Sales from shift 11 on 2023-02-18 21:37:10 ','2023-02-18 21:37:10','',''),('1','311',442,'','20','3',3000.00,0.00,'Retail Sale Id 231 for 4.17 KG of Cooking Gas @ N720.00','2023-02-19 08:43:09','',''),('1','311',443,'','6.1','4',0.00,3000.00,'Retail Sale Id 231 for retail product','2023-02-19 08:43:09','',''),('1','311',444,'','20','3',2160.00,0.00,'Retail Sale Id 232 for 3.00 KG of Cooking Gas @ N720.00','2023-02-19 08:45:39','',''),('1','311',445,'','6.1','4',0.00,2160.00,'Retail Sale Id 232 for retail product','2023-02-19 08:45:39','',''),('1','311',446,'','20','3',2880.00,0.00,'Retail Sale Id 234 for multiple products','2023-02-19 08:55:46','',''),('1','311',447,'','6.1','4',0.00,2880.00,'Retail Sale Id 234 for retail product','2023-02-19 08:55:46','',''),('1','311',448,'','20','3',3600.00,0.00,'Retail Sale Id 235 for 5.00 KG of Cooking Gas @ N720.00','2023-02-19 09:04:28','',''),('1','311',449,'','6.1','4',0.00,3600.00,'Retail Sale Id 235 for retail product','2023-02-19 09:04:28','',''),('1','311',450,'','20','3',2160.00,0.00,'Retail Sale Id 236 for 3.00 KG of Cooking Gas @ N720.00','2023-02-19 09:07:11','',''),('1','311',451,'','6.1','4',0.00,2160.00,'Retail Sale Id 236 for retail product','2023-02-19 09:07:11','',''),('1','311',452,'','20','3',2880.00,0.00,'Retail Sale Id 237 for 4.00 KG of Cooking Gas @ N720.00','2023-02-19 09:08:52','',''),('1','311',453,'','6.1','4',0.00,2880.00,'Retail Sale Id 237 for retail product','2023-02-19 09:08:52','',''),('1','311',454,'','20','3',5040.00,0.00,'Retail Sale Id 239 for 7.00 KG of Cooking Gas @ N720.00','2023-02-19 09:19:01','',''),('1','311',455,'','6.1','4',0.00,5040.00,'Retail Sale Id 239 for retail product','2023-02-19 09:19:01','',''),('1','311',456,'','20','3',2880.00,0.00,'Retail Sale Id 240 for 4.00 KG of Cooking Gas @ N720.00','2023-02-19 09:21:07','',''),('1','311',457,'','6.1','4',0.00,2880.00,'Retail Sale Id 240 for retail product','2023-02-19 09:21:07','',''),('1','311',458,'','20','3',9000.00,0.00,'Retail Sale Id 241 for 12.50 KG of Cooking Gas @ N720.00','2023-02-19 09:25:37','',''),('1','311',459,'','6.1','4',0.00,9000.00,'Retail Sale Id 241 for retail product','2023-02-19 09:25:37','',''),('1','311',460,'','20','3',2160.00,0.00,'Retail Sale Id 242 for 3.00 KG of Cooking Gas @ N720.00','2023-02-19 09:27:35','',''),('1','311',461,'','6.1','4',0.00,2160.00,'Retail Sale Id 242 for retail product','2023-02-19 09:27:35','',''),('1','311',462,'','20','3',1440.00,0.00,'Retail Sale Id 243 for 2.00 KG of Cooking Gas @ N720.00','2023-02-19 09:31:40','',''),('1','311',463,'','6.1','4',0.00,1440.00,'Retail Sale Id 243 for retail product','2023-02-19 09:31:40','',''),('1','311',464,'','20','3',350.00,0.00,'Retail Sale Id 244 for 0.49 KG of Cooking Gas @ N720.00','2023-02-19 09:36:08','',''),('1','311',465,'','6.1','4',0.00,350.00,'Retail Sale Id 244 for retail product','2023-02-19 09:36:08','',''),('1','311',466,'','20','3',1440.00,0.00,'Retail Sale Id 245 for 2.00 KG of Cooking Gas @ N720.00','2023-02-19 09:37:38','',''),('1','311',467,'','6.1','4',0.00,1440.00,'Retail Sale Id 245 for retail product','2023-02-19 09:37:38','',''),('1','311',468,'','20','3',3600.00,0.00,'Retail Sale Id 246 for 5.00 KG of Cooking Gas @ N720.00','2023-02-19 09:39:36','',''),('1','311',469,'','6.1','4',0.00,3600.00,'Retail Sale Id 246 for retail product','2023-02-19 09:39:36','',''),('1','311',470,'','20','3',2160.00,0.00,'Retail Sale Id 247 for 3.00 KG of Cooking Gas @ N720.00','2023-02-19 09:42:00','',''),('1','311',471,'','6.1','4',0.00,2160.00,'Retail Sale Id 247 for retail product','2023-02-19 09:42:00','',''),('1','311',472,'','20','3',5040.00,0.00,'Retail Sale Id 249 for 7.00 KG of Cooking Gas @ N720.00','2023-02-19 09:53:36','',''),('1','311',473,'','6.1','4',0.00,5040.00,'Retail Sale Id 249 for retail product','2023-02-19 09:53:36','',''),('1','311',474,'','20','3',6480.00,0.00,'Retail Sale Id 250 for 9.00 KG of Cooking Gas @ N720.00','2023-02-19 10:34:10','',''),('1','311',475,'','6.1','4',0.00,6480.00,'Retail Sale Id 250 for retail product','2023-02-19 10:34:10','',''),('1','311',476,'','20','3',7920.00,0.00,'Retail Sale Id 251 for multiple products','2023-02-19 10:38:42','',''),('1','311',477,'','6.1','4',0.00,7920.00,'Retail Sale Id 251 for retail product','2023-02-19 10:38:42','',''),('1','311',478,'','20','3',1440.00,0.00,'Retail Sale Id 252 for 2.00 KG of Cooking Gas @ N720.00','2023-02-19 13:01:22','',''),('1','311',479,'','6.1','4',0.00,1440.00,'Retail Sale Id 252 for retail product','2023-02-19 13:01:22','',''),('1','311',480,'','20','3',3600.00,0.00,'Retail Sale Id 253 for 5.00 KG of Cooking Gas @ N720.00','2023-02-19 13:02:13','',''),('1','311',481,'','6.1','4',0.00,3600.00,'Retail Sale Id 253 for retail product','2023-02-19 13:02:13','',''),('1','311',482,'','20','3',8000.00,0.00,'Retail Sale Id 254 for 11.11 KG of Cooking Gas @ N720.00','2023-02-19 13:06:28','',''),('1','311',483,'','6.1','4',0.00,8000.00,'Retail Sale Id 254 for retail product','2023-02-19 13:06:28','',''),('1','311',484,'','20','3',4320.00,0.00,'Retail Sale Id 256 for 6.00 KG of Cooking Gas @ N720.00','2023-02-19 13:27:28','',''),('1','311',485,'','6.1','4',0.00,4320.00,'Retail Sale Id 256 for retail product','2023-02-19 13:27:28','',''),('1','311',486,'','20','3',5040.00,0.00,'Retail Sale Id 257 for 7.00 KG of Cooking Gas @ N720.00','2023-02-19 13:56:32','',''),('1','311',487,'','6.1','4',0.00,5040.00,'Retail Sale Id 257 for retail product','2023-02-19 13:56:32','',''),('1','311',488,'','20','3',5040.00,0.00,'Retail Sale Id 259 for 7.00 KG of Cooking Gas @ N720.00','2023-02-19 14:02:11','',''),('1','311',489,'','6.1','4',0.00,5040.00,'Retail Sale Id 259 for retail product','2023-02-19 14:02:11','',''),('1','311',490,'','20','3',4320.00,0.00,'Retail Sale Id 260 for 6.00 KG of Cooking Gas @ N720.00','2023-02-19 14:57:02','',''),('1','311',491,'','6.1','4',0.00,4320.00,'Retail Sale Id 260 for retail product','2023-02-19 14:57:02','',''),('1','311',492,'','20','3',1440.00,0.00,'Retail Sale Id 261 for 2.00 KG of Cooking Gas @ N720.00','2023-02-19 16:06:20','',''),('1','311',493,'','6.1','4',0.00,1440.00,'Retail Sale Id 261 for retail product','2023-02-19 16:06:20','',''),('1','311',494,'','20','3',9000.00,0.00,'Retail Sale Id 262 for 12.50 KG of Cooking Gas @ N720.00','2023-02-19 16:26:28','',''),('1','311',495,'','6.1','4',0.00,9000.00,'Retail Sale Id 262 for retail product','2023-02-19 16:26:28','',''),('1','311',496,'','20','3',3000.00,0.00,'Retail Sale Id 263 for 4.17 KG of Cooking Gas @ N720.00','2023-02-19 17:24:47','',''),('1','311',497,'','6.1','4',0.00,3000.00,'Retail Sale Id 263 for retail product','2023-02-19 17:24:47','',''),('1','311',498,'','20','3',720.00,0.00,'Retail Sale Id 264 for 1.00 KG of Cooking Gas @ N720.00','2023-02-19 17:27:52','',''),('1','311',499,'','6.1','4',0.00,720.00,'Retail Sale Id 264 for retail product','2023-02-19 17:27:53','',''),('1','311',500,'','20','3',1440.00,0.00,'Retail Sale Id 265 for 2.00 KG of Cooking Gas @ N720.00','2023-02-19 17:40:08','',''),('1','311',501,'','6.1','4',0.00,1440.00,'Retail Sale Id 265 for retail product','2023-02-19 17:40:08','',''),('1','311',502,'','20','3',2880.00,0.00,'Retail Sale Id 267 for 4.00 KG of Cooking Gas @ N720.00','2023-02-19 17:46:16','',''),('1','311',503,'','6.1','4',0.00,2880.00,'Retail Sale Id 267 for retail product','2023-02-19 17:46:16','',''),('1','311',504,'','20','3',2000.00,0.00,'Retail Sale Id 268 for 2.78 KG of Cooking Gas @ N720.00','2023-02-19 17:47:37','',''),('1','311',505,'','6.1','4',0.00,2000.00,'Retail Sale Id 268 for retail product','2023-02-19 17:47:37','',''),('1','311',506,'','20','3',1000.00,0.00,'Retail Sale Id 269 for 1.39 KG of Cooking Gas @ N720.00','2023-02-19 17:49:04','',''),('1','311',507,'','6.1','4',0.00,1000.00,'Retail Sale Id 269 for retail product','2023-02-19 17:49:04','',''),('1','311',508,'','20','3',1500.00,0.00,'Retail Sale Id 270 for 2.08 KG of Cooking Gas @ N720.00','2023-02-19 17:50:25','',''),('1','311',509,'','6.1','4',0.00,1500.00,'Retail Sale Id 270 for retail product','2023-02-19 17:50:25','',''),('1','311',510,'','20','3',8812.80,0.00,'Retail Sale Id 271 for 12.24 KG of Cooking Gas @ N720.00','2023-02-19 20:03:07','',''),('1','311',511,'','6.1','4',0.00,8812.80,'Retail Sale Id 271 for retail product','2023-02-19 20:03:07','',''),('1','311',512,'','20','3',9259.20,0.00,'Retail Sale Id 272 for 12.86 KG of Cooking Gas @ N720.00','2023-02-19 20:05:33','',''),('1','311',513,'','6.1','4',0.00,9259.20,'Retail Sale Id 272 for retail product','2023-02-19 20:05:33','',''),('1','311',514,'','20','3',10800.00,0.00,'Retail Sale Id 273 for 15.00 KG of Cooking Gas @ N720.00','2023-02-19 20:06:32','',''),('1','311',515,'','6.1','4',0.00,10800.00,'Retail Sale Id 273 for retail product','2023-02-19 20:06:32','',''),('1','311',516,'','20','3',15000.00,0.00,'Retail Sale Id 275 for 20.83 KG of Cooking Gas @ N720.00','2023-02-19 20:09:44','',''),('1','311',517,'','6.1','4',0.00,15000.00,'Retail Sale Id 275 for retail product','2023-02-19 20:09:44','',''),('1','311',518,'','20','3',15000.00,0.00,'Retail Sale Id 276 for 20.83 KG of Cooking Gas @ N720.00','2023-02-19 20:10:22','',''),('1','311',519,'','6.1','4',0.00,15000.00,'Retail Sale Id 276 for retail product','2023-02-19 20:10:22','',''),('1','311',520,'','20','3',15000.00,0.00,'Retail Sale Id 277 for 20.83 KG of Cooking Gas @ N720.00','2023-02-19 20:10:55','',''),('1','311',521,'','6.1','4',0.00,15000.00,'Retail Sale Id 277 for retail product','2023-02-19 20:10:55','',''),('1','311',522,'','20','3',15000.00,0.00,'Retail Sale Id 278 for 20.83 KG of Cooking Gas @ N720.00','2023-02-19 20:11:33','',''),('1','311',523,'','6.1','4',0.00,15000.00,'Retail Sale Id 278 for retail product','2023-02-19 20:11:33','',''),('1','311',524,'','20','3',0.00,15000.00,'Return of Retail Sale Id 278 for products','2023-02-19 20:15:25','',''),('1','311',525,'','','',15000.00,0.00,'Return of Retail Sale Id 278 for products','2023-02-19 20:15:25','',''),('1','311',526,'','20','3',0.00,15000.00,'Return of Retail Sale Id 277 for products','2023-02-19 20:16:30','',''),('1','311',527,'','','',15000.00,0.00,'Return of Retail Sale Id 277 for products','2023-02-19 20:16:30','',''),('1','311',528,'','20','3',0.00,1000.00,'Return of Retail Sale Id 269 for products','2023-02-19 20:18:21','',''),('1','311',529,'','','',1000.00,0.00,'Return of Retail Sale Id 269 for products','2023-02-19 20:18:21','',''),('1','311',530,'','20','3',1181.00,0.00,'Retail Sale Id 279 for 1.64 KG of Cooking Gas @ N720.00','2023-02-19 20:19:19','',''),('1','311',531,'','6.1','4',0.00,1181.00,'Retail Sale Id 279 for retail product','2023-02-19 20:19:19','',''),('1','311',532,'','20','3',0.00,1440.00,'Return of Retail Sale Id 261 for products','2023-02-19 20:22:08','',''),('1','311',533,'','','',1440.00,0.00,'Return of Retail Sale Id 261 for products','2023-02-19 20:22:08','',''),('1','311',534,'','20','3',1078.00,0.00,'Retail Sale Id 280 for 1.50 KG of Cooking Gas @ N720.00','2023-02-19 20:23:36','',''),('1','311',535,'','6.1','4',0.00,1078.00,'Retail Sale Id 280 for retail product','2023-02-19 20:23:36','',''),('1','311',536,'','20','3',2587.00,0.00,'Retail Sale Id 281 for 3.59 KG of Cooking Gas @ N720.00','2023-02-19 20:25:39','',''),('1','311',537,'','6.1','4',0.00,2587.00,'Retail Sale Id 281 for retail product','2023-02-19 20:25:39','',''),('1','311',538,'','20','3',0.00,0.00,'Sales from shift 12 on 2023-02-19 20:26:50 ','2023-02-19 20:26:50','',''),('1','311',539,'','6.1','4',0.00,0.00,'Sales from shift 12 on 2023-02-19 20:26:50 ','2023-02-19 20:26:50','',''),('1','311',540,'','20','3',2500.00,0.00,'Retail Sale Id 282 for 3.47 KG of Cooking Gas @ N720.00','2023-02-21 08:25:43','',''),('1','311',541,'','6.1','4',0.00,2500.00,'Retail Sale Id 282 for retail product','2023-02-21 08:25:43','',''),('1','311',542,'','20','3',4320.00,0.00,'Retail Sale Id 283 for 6.00 KG of Cooking Gas @ N720.00','2023-02-21 08:31:54','',''),('1','311',543,'','6.1','4',0.00,4320.00,'Retail Sale Id 283 for retail product','2023-02-21 08:31:54','',''),('1','311',544,'','20','3',3600.00,0.00,'Retail Sale Id 284 for 5.00 KG of Cooking Gas @ N720.00','2023-02-21 08:34:17','',''),('1','311',545,'','6.1','4',0.00,3600.00,'Retail Sale Id 284 for retail product','2023-02-21 08:34:17','',''),('1','311',546,'','20','3',7200.00,0.00,'Retail Sale Id 285 for 10.00 KG of Cooking Gas @ N720.00','2023-02-21 08:35:21','',''),('1','311',547,'','6.1','4',0.00,7200.00,'Retail Sale Id 285 for retail product','2023-02-21 08:35:21','',''),('1','311',548,'','20','3',1440.00,0.00,'Retail Sale Id 289 for 2.00 KG of Cooking Gas @ N720.00','2023-02-21 08:39:56','',''),('1','311',549,'','6.1','4',0.00,1440.00,'Retail Sale Id 289 for retail product','2023-02-21 08:39:56','',''),('1','311',550,'','20','3',2160.00,0.00,'Retail Sale Id 290 for 3.00 KG of Cooking Gas @ N720.00','2023-02-21 09:02:08','',''),('1','311',551,'','6.1','4',0.00,2160.00,'Retail Sale Id 290 for retail product','2023-02-21 09:02:08','',''),('1','311',552,'','20','3',1000.00,0.00,'Retail Sale Id 292 for 1.39 KG of Cooking Gas @ N720.00','2023-02-21 09:31:03','',''),('1','311',553,'','6.1','4',0.00,1000.00,'Retail Sale Id 292 for retail product','2023-02-21 09:31:03','',''),('1','311',554,'','20','3',1600.00,0.00,'Retail Sale Id 294 for 2.22 KG of Cooking Gas @ N720.00','2023-02-21 11:00:26','',''),('1','311',555,'','6.1','4',0.00,1600.00,'Retail Sale Id 294 for retail product','2023-02-21 11:00:26','',''),('1','311',556,'','20','3',2000.00,0.00,'Retail Sale Id 295 for 2.78 KG of Cooking Gas @ N720.00','2023-02-21 11:02:25','',''),('1','311',557,'','6.1','4',0.00,2000.00,'Retail Sale Id 295 for retail product','2023-02-21 11:02:25','',''),('1','311',558,'','20','3',1400.00,0.00,'Retail Sale Id 296 for 1.94 KG of Cooking Gas @ N720.00','2023-02-21 11:04:15','',''),('1','311',559,'','6.1','4',0.00,1400.00,'Retail Sale Id 296 for retail product','2023-02-21 11:04:15','',''),('1','311',560,'','20','3',9000.00,0.00,'Retail Sale Id 297 for 12.50 KG of Cooking Gas @ N720.00','2023-02-21 11:07:01','',''),('1','311',561,'','6.1','4',0.00,9000.00,'Retail Sale Id 297 for retail product','2023-02-21 11:07:01','',''),('1','311',562,'','20','3',2000.00,0.00,'Retail Sale Id 298 for 2.78 KG of Cooking Gas @ N720.00','2023-02-21 11:08:36','',''),('1','311',563,'','6.1','4',0.00,2000.00,'Retail Sale Id 298 for retail product','2023-02-21 11:08:36','',''),('1','311',564,'','6.1','4',0.00,2000.00,'Retail Sale Id 298 for retail product','2023-02-21 11:08:36','',''),('1','311',565,'','20','3',13680.00,0.00,'Retail Sale Id 299 for multiple products','2023-02-21 11:10:47','',''),('1','311',566,'','6.1','4',0.00,13680.00,'Retail Sale Id 299 for retail product','2023-02-21 11:10:47','',''),('1','311',567,'','20','3',5000.00,0.00,'Retail Sale Id 300 for 6.94 KG of Cooking Gas @ N720.00','2023-02-21 11:12:30','',''),('1','311',568,'','6.1','4',0.00,5000.00,'Retail Sale Id 300 for retail product','2023-02-21 11:12:30','',''),('1','311',569,'','20','3',0.00,2000.00,'Return of Retail Sale Id 298 for products','2023-02-21 11:24:12','',''),('1','311',570,'','','',2000.00,0.00,'Return of Retail Sale Id 298 for products','2023-02-21 11:24:12','',''),('1','311',571,'','20','3',2000.00,0.00,'Retail Sale Id 301 for 2.78 KG of Cooking Gas @ N720.00','2023-02-21 11:25:37','',''),('1','311',572,'','6.1','4',0.00,2000.00,'Retail Sale Id 301 for retail product','2023-02-21 11:25:37','',''),('1','311',573,'','20','3',2880.00,0.00,'Retail Sale Id 303 for 4.00 KG of Cooking Gas @ N720.00','2023-02-21 12:45:42','',''),('1','311',574,'','6.1','4',0.00,2880.00,'Retail Sale Id 303 for retail product','2023-02-21 12:45:42','',''),('1','311',575,'','20','3',2160.00,0.00,'Retail Sale Id 304 for 3.00 KG of Cooking Gas @ N720.00','2023-02-21 12:48:32','',''),('1','311',576,'','6.1','4',0.00,2160.00,'Retail Sale Id 304 for retail product','2023-02-21 12:48:32','',''),('1','311',577,'','20','3',3200.00,0.00,'Retail Sale Id 305 for 4.44 KG of Cooking Gas @ N720.00','2023-02-21 12:50:15','',''),('1','311',578,'','6.1','4',0.00,3200.00,'Retail Sale Id 305 for retail product','2023-02-21 12:50:15','',''),('1','311',579,'','20','3',2000.00,0.00,'Retail Sale Id 306 for 2.78 KG of Cooking Gas @ N720.00','2023-02-21 12:51:50','',''),('1','311',580,'','6.1','4',0.00,2000.00,'Retail Sale Id 306 for retail product','2023-02-21 12:51:50','',''),('1','311',581,'','20','3',5040.00,0.00,'Retail Sale Id 307 for 7.00 KG of Cooking Gas @ N720.00','2023-02-21 12:54:13','',''),('1','311',582,'','6.1','4',0.00,5040.00,'Retail Sale Id 307 for retail product','2023-02-21 12:54:13','',''),('1','311',583,'','6.1','4',0.00,5040.00,'Retail Sale Id 307 for retail product','2023-02-21 12:54:13','',''),('1','311',584,'','6.1','4',0.00,5040.00,'Retail Sale Id 307 for retail product','2023-02-21 12:54:13','',''),('1','311',585,'','20','3',2800.00,0.00,'Retail Sale Id 309 for 3.89 KG of Cooking Gas @ N720.00','2023-02-21 12:56:19','',''),('1','311',586,'','6.1','4',0.00,2800.00,'Retail Sale Id 309 for retail product','2023-02-21 12:56:19','',''),('1','311',587,'','20','3',3000.00,0.00,'Retail Sale Id 312 for 4.17 KG of Cooking Gas @ N720.00','2023-02-21 13:24:27','',''),('1','311',588,'','6.1','4',0.00,3000.00,'Retail Sale Id 312 for retail product','2023-02-21 13:24:27','',''),('1','311',589,'','20','3',3000.00,0.00,'Retail Sale Id 313 for 4.17 KG of Cooking Gas @ N720.00','2023-02-21 13:29:14','',''),('1','311',590,'','6.1','4',0.00,3000.00,'Retail Sale Id 313 for retail product','2023-02-21 13:29:14','',''),('1','311',591,'','20','3',2200.00,0.00,'Retail Sale Id 314 for 3.06 KG of Cooking Gas @ N720.00','2023-02-21 13:31:04','',''),('1','311',592,'','6.1','4',0.00,2200.00,'Retail Sale Id 314 for retail product','2023-02-21 13:31:04','',''),('1','311',593,'','20','3',5040.00,0.00,'Retail Sale Id 316 for 7.00 KG of Cooking Gas @ N720.00','2023-02-21 13:32:35','',''),('1','311',594,'','6.1','4',0.00,5040.00,'Retail Sale Id 316 for retail product','2023-02-21 13:32:35','',''),('1','311',595,'','20','3',2200.00,0.00,'Retail Sale Id 318 for 3.06 KG of Cooking Gas @ N720.00','2023-02-21 13:34:02','',''),('1','311',596,'','6.1','4',0.00,2200.00,'Retail Sale Id 318 for retail product','2023-02-21 13:34:02','',''),('1','311',597,'','20','3',7000.00,0.00,'Retail Sale Id 321 for multiple products','2023-02-21 13:56:45','',''),('1','311',598,'','6.1','4',0.00,7000.00,'Retail Sale Id 321 for retail product','2023-02-21 13:56:45','',''),('1','311',599,'','20','3',2000.00,0.00,'Retail Sale Id 322 for 2.78 KG of Cooking Gas @ N720.00','2023-02-21 14:57:32','',''),('1','311',600,'','6.1','4',0.00,2000.00,'Retail Sale Id 322 for retail product','2023-02-21 14:57:32','',''),('1','311',601,'','20','3',7200.00,0.00,'Retail Sale Id 323 for 10.00 KG of Cooking Gas @ N720.00','2023-02-21 14:59:23','',''),('1','311',602,'','6.1','4',0.00,7200.00,'Retail Sale Id 323 for retail product','2023-02-21 14:59:23','',''),('1','311',603,'','20','3',2880.00,0.00,'Retail Sale Id 324 for 4.00 KG of Cooking Gas @ N720.00','2023-02-21 15:00:57','',''),('1','311',604,'','6.1','4',0.00,2880.00,'Retail Sale Id 324 for retail product','2023-02-21 15:00:57','',''),('1','311',605,'','20','3',3600.00,0.00,'Retail Sale Id 325 for 5.00 KG of Cooking Gas @ N720.00','2023-02-21 15:02:03','',''),('1','311',606,'','6.1','4',0.00,3600.00,'Retail Sale Id 325 for retail product','2023-02-21 15:02:03','',''),('1','311',607,'','20','3',1450.00,0.00,'Retail Sale Id 326 for 2.01 KG of Cooking Gas @ N720.00','2023-02-21 15:03:55','',''),('1','311',608,'','6.1','4',0.00,1450.00,'Retail Sale Id 326 for retail product','2023-02-21 15:03:55','',''),('1','311',609,'','20','3',2160.00,0.00,'Retail Sale Id 327 for 3.00 KG of Cooking Gas @ N720.00','2023-02-21 15:05:15','',''),('1','311',610,'','6.1','4',0.00,2160.00,'Retail Sale Id 327 for retail product','2023-02-21 15:05:15','',''),('1','311',611,'','20','3',3600.00,0.00,'Retail Sale Id 328 for 5.00 KG of Cooking Gas @ N720.00','2023-02-21 15:09:12','',''),('1','311',612,'','6.1','4',0.00,3600.00,'Retail Sale Id 328 for retail product','2023-02-21 15:09:12','',''),('1','311',613,'','20','3',2160.00,0.00,'Retail Sale Id 330 for 3.00 KG of Cooking Gas @ N720.00','2023-02-21 15:24:06','',''),('1','311',614,'','6.1','4',0.00,2160.00,'Retail Sale Id 330 for retail product','2023-02-21 15:24:06','',''),('1','311',615,'','20','3',5040.00,0.00,'Retail Sale Id 331 for 7.00 KG of Cooking Gas @ N720.00','2023-02-21 15:35:57','',''),('1','311',616,'','6.1','4',0.00,5040.00,'Retail Sale Id 331 for retail product','2023-02-21 15:35:57','',''),('1','311',617,'','20','3',2160.00,0.00,'Retail Sale Id 332 for 3.00 KG of Cooking Gas @ N720.00','2023-02-21 15:37:19','',''),('1','311',618,'','6.1','4',0.00,2160.00,'Retail Sale Id 332 for retail product','2023-02-21 15:37:19','',''),('1','311',619,'','20','3',5040.00,0.00,'Retail Sale Id 333 for 7.00 KG of Cooking Gas @ N720.00','2023-02-21 15:58:39','',''),('1','311',620,'','6.1','4',0.00,5040.00,'Retail Sale Id 333 for retail product','2023-02-21 15:58:39','',''),('1','311',621,'','20','3',4330.00,0.00,'Retail Sale Id 335 for 6.01 KG of Cooking Gas @ N720.00','2023-02-21 16:17:45','',''),('1','311',622,'','6.1','4',0.00,4330.00,'Retail Sale Id 335 for retail product','2023-02-21 16:17:45','',''),('1','311',623,'','20','3',5040.00,0.00,'Retail Sale Id 336 for 7.00 KG of Cooking Gas @ N720.00','2023-02-21 16:19:54','',''),('1','311',624,'','6.1','4',0.00,5040.00,'Retail Sale Id 336 for retail product','2023-02-21 16:19:54','',''),('1','311',625,'','20','3',12240.00,0.00,'Retail Sale Id 338 for multiple products','2023-02-21 16:36:35','',''),('1','311',626,'','6.1','4',0.00,12240.00,'Retail Sale Id 338 for retail product','2023-02-21 16:36:35','',''),('1','311',627,'','20','3',6000.00,0.00,'Retail Sale Id 342 for multiple products','2023-02-21 16:55:58','',''),('1','311',628,'','6.1','4',0.00,6000.00,'Retail Sale Id 342 for retail product','2023-02-21 16:55:58','',''),('1','311',629,'','20','3',1450.00,0.00,'Retail Sale Id 343 for 2.01 KG of Cooking Gas @ N720.00','2023-02-21 17:15:59','',''),('1','311',630,'','6.1','4',0.00,1450.00,'Retail Sale Id 343 for retail product','2023-02-21 17:15:59','',''),('1','311',631,'','20','3',2000.00,0.00,'Retail Sale Id 344 for 2.78 KG of Cooking Gas @ N720.00','2023-02-21 17:17:08','',''),('1','311',632,'','6.1','4',0.00,2000.00,'Retail Sale Id 344 for retail product','2023-02-21 17:17:08','',''),('1','311',633,'','20','3',1440.00,0.00,'Retail Sale Id 345 for 2.00 KG of Cooking Gas @ N720.00','2023-02-21 17:26:18','',''),('1','311',634,'','6.1','4',0.00,1440.00,'Retail Sale Id 345 for retail product','2023-02-21 17:26:18','',''),('1','311',635,'','20','3',2160.00,0.00,'Retail Sale Id 346 for 3.00 KG of Cooking Gas @ N720.00','2023-02-21 17:28:03','',''),('1','311',636,'','6.1','4',0.00,2160.00,'Retail Sale Id 346 for retail product','2023-02-21 17:28:03','',''),('1','311',637,'','20','3',4320.00,0.00,'Retail Sale Id 347 for 6.00 KG of Cooking Gas @ N720.00','2023-02-21 17:29:43','',''),('1','311',638,'','6.1','4',0.00,4320.00,'Retail Sale Id 347 for retail product','2023-02-21 17:29:43','',''),('1','311',639,'','20','3',5000.00,0.00,'Retail Sale Id 349 for 6.94 KG of Cooking Gas @ N720.00','2023-02-21 17:35:44','',''),('1','311',640,'','6.1','4',0.00,5000.00,'Retail Sale Id 349 for retail product','2023-02-21 17:35:44','',''),('1','311',641,'','20','3',1450.00,0.00,'Retail Sale Id 350 for 2.01 KG of Cooking Gas @ N720.00','2023-02-21 17:41:20','',''),('1','311',642,'','6.1','4',0.00,1450.00,'Retail Sale Id 350 for retail product','2023-02-21 17:41:20','',''),('1','311',643,'','20','3',9000.00,0.00,'Retail Sale Id 351 for 12.50 KG of Cooking Gas @ N720.00','2023-02-21 17:52:44','',''),('1','311',644,'','6.1','4',0.00,9000.00,'Retail Sale Id 351 for retail product','2023-02-21 17:52:44','',''),('1','311',645,'','20','3',3000.00,0.00,'Retail Sale Id 352 for 4.17 KG of Cooking Gas @ N720.00','2023-02-21 17:58:47','',''),('1','311',646,'','6.1','4',0.00,3000.00,'Retail Sale Id 352 for retail product','2023-02-21 17:58:47','',''),('1','311',647,'','20','3',0.00,6000.00,'Return of Retail Sale Id 342 for products','2023-02-21 22:51:19','',''),('1','311',648,'','','',6000.00,0.00,'Return of Retail Sale Id 342 for products','2023-02-21 22:51:19','',''),('1','311',649,'','20','3',0.00,4330.00,'Return of Retail Sale Id 335 for products','2023-02-21 22:56:27','',''),('1','311',650,'','','',4330.00,0.00,'Return of Retail Sale Id 335 for products','2023-02-21 22:56:27','',''),('1','311',651,'','20','3',0.00,5040.00,'Return of Retail Sale Id 333 for products','2023-02-21 22:58:09','',''),('1','311',652,'','','',5040.00,0.00,'Return of Retail Sale Id 333 for products','2023-02-21 22:58:09','',''),('1','311',653,'','20','3',1684.80,0.00,'Retail Sale Id 353 for 2.34 KG of Cooking Gas @ N720.00','2023-02-21 23:00:13','',''),('1','311',654,'','6.1','4',0.00,1684.80,'Retail Sale Id 353 for retail product','2023-02-21 23:00:13','',''),('1','311',655,'','20','3',4330.00,0.00,'Retail Sale Id 354 for 6.01 KG of Cooking Gas @ N720.00','2023-02-21 23:06:31','',''),('1','311',656,'','6.1','4',0.00,4330.00,'Retail Sale Id 354 for retail product','2023-02-21 23:06:31','',''),('1','311',657,'','20','3',6000.00,0.00,'Retail Sale Id 355 for 8.33 KG of Cooking Gas @ N720.00','2023-02-21 23:11:40','',''),('1','311',658,'','6.1','4',0.00,6000.00,'Retail Sale Id 355 for retail product','2023-02-21 23:11:40','',''),('1','311',659,'','20','3',7200.00,0.00,'Retail Sale Id 356 for 10.00 KG of Cooking Gas @ N720.00','2023-02-21 23:15:17','',''),('1','311',660,'','6.1','4',0.00,7200.00,'Retail Sale Id 356 for retail product','2023-02-21 23:15:17','',''),('1','311',661,'','20','3',3081.60,0.00,'Retail Sale Id 358 for 4.28 KG of Cooking Gas @ N720.00','2023-02-21 23:17:55','',''),('1','311',662,'','6.1','4',0.00,3081.60,'Retail Sale Id 358 for retail product','2023-02-21 23:17:55','',''),('1','311',663,'','20','3',2692.00,0.00,'Retail Sale Id 359 for 3.74 KG of Cooking Gas @ N720.00','2023-02-21 23:19:27','',''),('1','311',664,'','6.1','4',0.00,2692.00,'Retail Sale Id 359 for retail product','2023-02-21 23:19:27','',''),('1','311',665,'','20','3',0.00,0.00,'Sales from shift 13 on 2023-02-21 23:23:09 ','2023-02-21 23:23:09','',''),('1','311',666,'','6.1','4',0.00,0.00,'Sales from shift 13 on 2023-02-21 23:23:09 ','2023-02-21 23:23:09','',''),('1','311',667,'','20','3',2200.00,0.00,'Retail Sale Id 360 for 3.06 KG of Cooking Gas @ N720.00','2023-02-22 08:14:09','',''),('1','311',668,'','6.1','4',0.00,2200.00,'Retail Sale Id 360 for retail product','2023-02-22 08:14:09','',''),('1','311',669,'','20','3',2880.00,0.00,'Retail Sale Id 361 for 4.00 KG of Cooking Gas @ N720.00','2023-02-22 08:19:00','',''),('1','311',670,'','6.1','4',0.00,2880.00,'Retail Sale Id 361 for retail product','2023-02-22 08:19:00','',''),('1','311',671,'','20','3',10080.00,0.00,'Retail Sale Id 362 for multiple products','2023-02-22 08:21:15','',''),('1','311',672,'','6.1','4',0.00,10080.00,'Retail Sale Id 362 for retail product','2023-02-22 08:21:15','',''),('1','311',673,'','20','3',1440.00,0.00,'Retail Sale Id 363 for 2.00 KG of Cooking Gas @ N720.00','2023-02-22 08:36:32','',''),('1','311',674,'','6.1','4',0.00,1440.00,'Retail Sale Id 363 for retail product','2023-02-22 08:36:32','',''),('1','311',675,'','6.1','4',0.00,1440.00,'Retail Sale Id 363 for retail product','2023-02-22 08:36:32','',''),('1','311',676,'','20','3',7200.00,0.00,'Retail Sale Id 364 for 10.00 KG of Cooking Gas @ N720.00','2023-02-22 08:47:31','',''),('1','311',677,'','6.1','4',0.00,7200.00,'Retail Sale Id 364 for retail product','2023-02-22 08:47:31','',''),('1','311',678,'','20','3',3000.00,0.00,'Retail Sale Id 365 for 4.17 KG of Cooking Gas @ N720.00','2023-02-22 09:00:10','',''),('1','311',679,'','6.1','4',0.00,3000.00,'Retail Sale Id 365 for retail product','2023-02-22 09:00:10','',''),('1','311',680,'','20','3',3000.00,0.00,'Retail Sale Id 366 for 4.17 KG of Cooking Gas @ N720.00','2023-02-22 09:02:03','',''),('1','311',681,'','6.1','4',0.00,3000.00,'Retail Sale Id 366 for retail product','2023-02-22 09:02:03','',''),('1','311',682,'','20','3',2160.00,0.00,'Retail Sale Id 367 for 3.00 KG of Cooking Gas @ N720.00','2023-02-22 09:07:25','',''),('1','311',683,'','6.1','4',0.00,2160.00,'Retail Sale Id 367 for retail product','2023-02-22 09:07:25','',''),('1','311',684,'','20','3',3600.00,0.00,'Retail Sale Id 369 for 5.00 KG of Cooking Gas @ N720.00','2023-02-22 09:15:34','',''),('1','311',685,'','6.1','4',0.00,3600.00,'Retail Sale Id 369 for retail product','2023-02-22 09:15:34','',''),('1','311',686,'','20','3',2160.00,0.00,'Retail Sale Id 370 for 3.00 KG of Cooking Gas @ N720.00','2023-02-22 09:29:49','',''),('1','311',687,'','6.1','4',0.00,2160.00,'Retail Sale Id 370 for retail product','2023-02-22 09:29:49','',''),('1','311',688,'','20','3',3000.00,0.00,'Retail Sale Id 371 for 4.17 KG of Cooking Gas @ N720.00','2023-02-22 09:46:03','',''),('1','311',689,'','6.1','4',0.00,3000.00,'Retail Sale Id 371 for retail product','2023-02-22 09:46:03','',''),('1','311',690,'','20','3',2160.00,0.00,'Retail Sale Id 372 for 3.00 KG of Cooking Gas @ N720.00','2023-02-22 09:48:28','',''),('1','311',691,'','6.1','4',0.00,2160.00,'Retail Sale Id 372 for retail product','2023-02-22 09:48:28','',''),('1','311',692,'','20','3',3600.00,0.00,'Retail Sale Id 373 for 5.00 KG of Cooking Gas @ N720.00','2023-02-22 09:50:31','',''),('1','311',693,'','6.1','4',0.00,3600.00,'Retail Sale Id 373 for retail product','2023-02-22 09:50:31','',''),('1','311',694,'','20','3',9000.00,0.00,'Retail Sale Id 374 for 12.50 KG of Cooking Gas @ N720.00','2023-02-22 09:53:58','',''),('1','311',695,'','6.1','4',0.00,9000.00,'Retail Sale Id 374 for retail product','2023-02-22 09:53:58','',''),('1','311',696,'','20','3',2150.00,0.00,'Retail Sale Id 376 for 2.99 KG of Cooking Gas @ N720.00','2023-02-22 10:00:14','',''),('1','311',697,'','6.1','4',0.00,2150.00,'Retail Sale Id 376 for retail product','2023-02-22 10:00:14','',''),('1','311',698,'','20','3',3600.00,0.00,'Retail Sale Id 377 for 5.00 KG of Cooking Gas @ N720.00','2023-02-22 10:08:44','',''),('1','311',699,'','6.1','4',0.00,3600.00,'Retail Sale Id 377 for retail product','2023-02-22 10:08:44','',''),('1','311',700,'','20','3',3600.00,0.00,'Retail Sale Id 378 for 5.00 KG of Cooking Gas @ N720.00','2023-02-22 10:12:00','',''),('1','311',701,'','6.1','4',0.00,3600.00,'Retail Sale Id 378 for retail product','2023-02-22 10:12:00','',''),('1','311',702,'','20','3',2200.00,0.00,'Retail Sale Id 379 for 3.06 KG of Cooking Gas @ N720.00','2023-02-22 10:20:54','',''),('1','311',703,'','6.1','4',0.00,2200.00,'Retail Sale Id 379 for retail product','2023-02-22 10:20:54','',''),('1','311',704,'','20','3',5040.00,0.00,'Retail Sale Id 380 for 7.00 KG of Cooking Gas @ N720.00','2023-02-22 10:23:15','',''),('1','311',705,'','6.1','4',0.00,5040.00,'Retail Sale Id 380 for retail product','2023-02-22 10:23:15','',''),('1','311',706,'','20','3',4320.00,0.00,'Retail Sale Id 382 for 6.00 KG of Cooking Gas @ N720.00','2023-02-22 10:26:41','',''),('1','311',707,'','6.1','4',0.00,4320.00,'Retail Sale Id 382 for retail product','2023-02-22 10:26:41','',''),('1','311',708,'','20','3',5040.00,0.00,'Retail Sale Id 383 for 7.00 KG of Cooking Gas @ N720.00','2023-02-22 10:28:20','',''),('1','311',709,'','6.1','4',0.00,5040.00,'Retail Sale Id 383 for retail product','2023-02-22 10:28:20','',''),('1','311',710,'','20','3',9000.00,0.00,'Retail Sale Id 384 for 12.50 KG of Cooking Gas @ N720.00','2023-02-22 10:29:26','',''),('1','311',711,'','6.1','4',0.00,9000.00,'Retail Sale Id 384 for retail product','2023-02-22 10:29:26','',''),('1','311',712,'','20','3',3600.00,0.00,'Retail Sale Id 386 for 5.00 KG of Cooking Gas @ N720.00','2023-02-22 10:41:21','',''),('1','311',713,'','6.1','4',0.00,3600.00,'Retail Sale Id 386 for retail product','2023-02-22 10:41:21','',''),('1','311',714,'','20','3',750.00,0.00,'Retail Sale Id 389 for 1.04 KG of Cooking Gas @ N720.00','2023-02-22 11:05:27','',''),('1','311',715,'','6.1','4',0.00,750.00,'Retail Sale Id 389 for retail product','2023-02-22 11:05:27','',''),('1','311',716,'','20','3',9000.00,0.00,'Retail Sale Id 392 for 12.50 KG of Cooking Gas @ N720.00','2023-02-22 11:23:45','',''),('1','311',717,'','6.1','4',0.00,9000.00,'Retail Sale Id 392 for retail product','2023-02-22 11:23:45','',''),('1','311',718,'','20','3',2900.00,0.00,'Retail Sale Id 393 for 4.03 KG of Cooking Gas @ N720.00','2023-02-22 11:38:35','',''),('1','311',719,'','6.1','4',0.00,2900.00,'Retail Sale Id 393 for retail product','2023-02-22 11:38:35','',''),('1','311',720,'','20','3',2000.00,0.00,'Retail Sale Id 395 for 2.78 KG of Cooking Gas @ N720.00','2023-02-22 11:44:18','',''),('1','311',721,'','6.1','4',0.00,2000.00,'Retail Sale Id 395 for retail product','2023-02-22 11:44:18','',''),('1','311',722,'','20','3',1500.00,0.00,'Retail Sale Id 396 for 2.08 KG of Cooking Gas @ N720.00','2023-02-22 12:05:50','',''),('1','311',723,'','6.1','4',0.00,1500.00,'Retail Sale Id 396 for retail product','2023-02-22 12:05:50','',''),('1','311',724,'','20','3',2000.00,0.00,'Retail Sale Id 397 for 2.78 KG of Cooking Gas @ N720.00','2023-02-22 12:22:01','',''),('1','311',725,'','6.1','4',0.00,2000.00,'Retail Sale Id 397 for retail product','2023-02-22 12:22:01','',''),('1','311',726,'','20','3',0.00,2000.00,'Return of Retail Sale Id 397 for products','2023-02-22 12:29:00','',''),('1','311',727,'','','',2000.00,0.00,'Return of Retail Sale Id 397 for products','2023-02-22 12:29:00','',''),('1','311',728,'','20','3',3600.00,0.00,'Retail Sale Id 399 for 5.00 KG of Cooking Gas @ N720.00','2023-02-22 12:58:10','',''),('1','311',729,'','6.1','4',0.00,3600.00,'Retail Sale Id 399 for retail product','2023-02-22 12:58:10','',''),('1','311',730,'','20','3',7200.00,0.00,'Retail Sale Id 400 for 10.00 KG of Cooking Gas @ N720.00','2023-02-22 13:25:54','',''),('1','311',731,'','6.1','4',0.00,7200.00,'Retail Sale Id 400 for retail product','2023-02-22 13:25:54','',''),('1','311',732,'','20','3',2000.00,0.00,'Retail Sale Id 402 for 2.78 KG of Cooking Gas @ N720.00','2023-02-22 13:28:55','',''),('1','311',733,'','6.1','4',0.00,2000.00,'Retail Sale Id 402 for retail product','2023-02-22 13:28:55','',''),('1','311',734,'','20','3',3600.00,0.00,'Retail Sale Id 403 for 5.00 KG of Cooking Gas @ N720.00','2023-02-22 13:30:24','',''),('1','311',735,'','6.1','4',0.00,3600.00,'Retail Sale Id 403 for retail product','2023-02-22 13:30:24','',''),('1','311',736,'','20','3',2880.00,0.00,'Retail Sale Id 404 for 4.00 KG of Cooking Gas @ N720.00','2023-02-22 14:19:03','',''),('1','311',737,'','6.1','4',0.00,2880.00,'Retail Sale Id 404 for retail product','2023-02-22 14:19:03','',''),('1','311',738,'','20','3',5040.00,0.00,'Retail Sale Id 405 for 7.00 KG of Cooking Gas @ N720.00','2023-02-22 15:11:41','',''),('1','311',739,'','6.1','4',0.00,5040.00,'Retail Sale Id 405 for retail product','2023-02-22 15:11:41','',''),('1','311',740,'','20','3',0.00,5040.00,'Return of Retail Sale Id 405 for products','2023-02-22 15:22:58','',''),('1','311',741,'','','',5040.00,0.00,'Return of Retail Sale Id 405 for products','2023-02-22 15:22:58','',''),('1','311',742,'','20','3',4788.00,0.00,'Retail Sale Id 407 for 6.65 KG of Cooking Gas @ N720.00','2023-02-22 15:25:10','',''),('1','311',743,'','6.1','4',0.00,4788.00,'Retail Sale Id 407 for retail product','2023-02-22 15:25:10','',''),('1','311',744,'','20','3',7200.00,0.00,'Retail Sale Id 408 for 10.00 KG of Cooking Gas @ N720.00','2023-02-22 15:28:12','',''),('1','311',745,'','6.1','4',0.00,7200.00,'Retail Sale Id 408 for retail product','2023-02-22 15:28:12','',''),('1','311',746,'','20','3',9000.00,0.00,'Retail Sale Id 409 for 12.50 KG of Cooking Gas @ N720.00','2023-02-22 15:50:09','',''),('1','311',747,'','6.1','4',0.00,9000.00,'Retail Sale Id 409 for retail product','2023-02-22 15:50:09','',''),('1','311',748,'','20','3',9000.00,0.00,'Retail Sale Id 410 for 12.50 KG of Cooking Gas @ N720.00','2023-02-22 15:52:14','',''),('1','311',749,'','6.1','4',0.00,9000.00,'Retail Sale Id 410 for retail product','2023-02-22 15:52:14','',''),('1','311',750,'','20','3',1440.00,0.00,'Retail Sale Id 411 for 2.00 KG of Cooking Gas @ N720.00','2023-02-22 15:55:14','',''),('1','311',751,'','6.1','4',0.00,1440.00,'Retail Sale Id 411 for retail product','2023-02-22 15:55:14','',''),('1','311',752,'','6.1','4',0.00,1440.00,'Retail Sale Id 411 for retail product','2023-02-22 15:55:14','',''),('1','311',753,'','20','3',5760.00,0.00,'Retail Sale Id 412 for 8.00 KG of Cooking Gas @ N720.00','2023-02-22 16:00:31','',''),('1','311',754,'','6.1','4',0.00,5760.00,'Retail Sale Id 412 for retail product','2023-02-22 16:00:31','',''),('1','311',755,'','6.1','4',0.00,5760.00,'Retail Sale Id 412 for retail product','2023-02-22 16:00:31','',''),('1','311',756,'','20','3',2160.00,0.00,'Retail Sale Id 413 for 3.00 KG of Cooking Gas @ N720.00','2023-02-22 16:02:55','',''),('1','311',757,'','6.1','4',0.00,2160.00,'Retail Sale Id 413 for retail product','2023-02-22 16:02:55','',''),('1','311',758,'','20','3',3600.00,0.00,'Retail Sale Id 416 for 5.00 KG of Cooking Gas @ N720.00','2023-02-22 16:05:49','',''),('1','311',759,'','6.1','4',0.00,3600.00,'Retail Sale Id 416 for retail product','2023-02-22 16:05:49','',''),('1','311',760,'','6.1','4',0.00,3600.00,'Retail Sale Id 416 for retail product','2023-02-22 16:05:49','',''),('1','311',761,'','6.1','4',0.00,3600.00,'Retail Sale Id 416 for retail product','2023-02-22 16:05:49','',''),('1','311',762,'','20','3',1450.00,0.00,'Retail Sale Id 417 for 2.01 KG of Cooking Gas @ N720.00','2023-02-22 16:08:16','',''),('1','311',763,'','6.1','4',0.00,1450.00,'Retail Sale Id 417 for retail product','2023-02-22 16:08:16','',''),('1','311',764,'','20','3',0.00,3600.00,'Return of Retail Sale Id 416 for products','2023-02-22 16:09:31','',''),('1','311',765,'','','',3600.00,0.00,'Return of Retail Sale Id 416 for products','2023-02-22 16:09:31','',''),('1','311',766,'','20','3',3600.00,0.00,'Retail Sale Id 418 for 5.00 KG of Cooking Gas @ N720.00','2023-02-22 16:10:16','',''),('1','311',767,'','6.1','4',0.00,3600.00,'Retail Sale Id 418 for retail product','2023-02-22 16:10:16','',''),('1','311',768,'','20','3',2160.00,0.00,'Retail Sale Id 420 for 3.00 KG of Cooking Gas @ N720.00','2023-02-22 16:26:05','',''),('1','311',769,'','6.1','4',0.00,2160.00,'Retail Sale Id 420 for retail product','2023-02-22 16:26:05','',''),('1','311',770,'','20','3',2700.00,0.00,'Retail Sale Id 422 for 3.75 KG of Cooking Gas @ N720.00','2023-02-22 16:53:41','',''),('1','311',771,'','6.1','4',0.00,2700.00,'Retail Sale Id 422 for retail product','2023-02-22 16:53:41','',''),('1','311',772,'','20','3',1450.00,0.00,'Retail Sale Id 423 for 2.01 KG of Cooking Gas @ N720.00','2023-02-22 16:54:43','',''),('1','311',773,'','6.1','4',0.00,1450.00,'Retail Sale Id 423 for retail product','2023-02-22 16:54:43','',''),('1','311',774,'','20','3',2880.00,0.00,'Retail Sale Id 424 for 4.00 KG of Cooking Gas @ N720.00','2023-02-22 16:59:06','',''),('1','311',775,'','6.1','4',0.00,2880.00,'Retail Sale Id 424 for retail product','2023-02-22 16:59:06','',''),('1','311',776,'','20','3',2880.00,0.00,'Retail Sale Id 426 for 4.00 KG of Cooking Gas @ N720.00','2023-02-22 17:03:30','',''),('1','311',777,'','6.1','4',0.00,2880.00,'Retail Sale Id 426 for retail product','2023-02-22 17:03:30','',''),('1','311',778,'','20','3',2880.00,0.00,'Retail Sale Id 427 for 4.00 KG of Cooking Gas @ N720.00','2023-02-22 17:24:22','',''),('1','311',779,'','6.1','4',0.00,2880.00,'Retail Sale Id 427 for retail product','2023-02-22 17:24:22','',''),('1','311',780,'','20','3',5040.00,0.00,'Retail Sale Id 428 for 7.00 KG of Cooking Gas @ N720.00','2023-02-22 17:30:01','',''),('1','311',781,'','6.1','4',0.00,5040.00,'Retail Sale Id 428 for retail product','2023-02-22 17:30:01','',''),('1','311',782,'','20','3',5000.00,0.00,'Retail Sale Id 431 for 6.94 KG of Cooking Gas @ N720.00','2023-02-22 17:44:59','',''),('1','311',783,'','6.1','4',0.00,5000.00,'Retail Sale Id 431 for retail product','2023-02-22 17:44:59','',''),('1','311',784,'','20','3',1450.00,0.00,'Retail Sale Id 432 for 2.01 KG of Cooking Gas @ N720.00','2023-02-22 17:45:58','',''),('1','311',785,'','6.1','4',0.00,1450.00,'Retail Sale Id 432 for retail product','2023-02-22 17:45:58','',''),('1','311',786,'','20','3',0.00,2700.00,'Return of Retail Sale Id 422 for products','2023-02-22 18:12:20','',''),('1','311',787,'','','',2700.00,0.00,'Return of Retail Sale Id 422 for products','2023-02-22 18:12:20','',''),('1','311',788,'','20','3',2706.00,0.00,'Retail Sale Id 433 for 3.76 KG of Cooking Gas @ N720.00','2023-02-22 18:13:03','',''),('1','311',789,'','6.1','4',0.00,2706.00,'Retail Sale Id 433 for retail product','2023-02-22 18:13:03','',''),('1','311',790,'','20','3',0.00,0.00,'Sales from shift 14 on 2023-02-22 18:13:51 ','2023-02-22 18:13:51','',''),('1','311',791,'','6.1','4',0.00,0.00,'Sales from shift 14 on 2023-02-22 18:13:51 ','2023-02-22 18:13:51','',''),('1','311',792,'','20','3',9000.00,0.00,'Retail Sale Id 434 for 12.50 KG of Cooking Gas @ N720.00','2023-02-23 08:14:09','',''),('1','311',793,'','6.1','4',0.00,9000.00,'Retail Sale Id 434 for retail product','2023-02-23 08:14:09','',''),('1','311',794,'','20','3',5040.00,0.00,'Retail Sale Id 435 for 7.00 KG of Cooking Gas @ N720.00','2023-02-23 08:15:32','',''),('1','311',795,'','6.1','4',0.00,5040.00,'Retail Sale Id 435 for retail product','2023-02-23 08:15:32','',''),('1','311',796,'','20','3',2880.00,0.00,'Retail Sale Id 436 for 4.00 KG of Cooking Gas @ N720.00','2023-02-23 08:57:23','',''),('1','311',797,'','6.1','4',0.00,2880.00,'Retail Sale Id 436 for retail product','2023-02-23 08:57:23','',''),('1','311',798,'','20','3',4320.00,0.00,'Retail Sale Id 437 for 6.00 KG of Cooking Gas @ N720.00','2023-02-23 09:11:25','',''),('1','311',799,'','6.1','4',0.00,4320.00,'Retail Sale Id 437 for retail product','2023-02-23 09:11:25','',''),('1','311',800,'','20','3',2880.00,0.00,'Retail Sale Id 438 for 4.00 KG of Cooking Gas @ N720.00','2023-02-23 09:21:04','',''),('1','311',801,'','6.1','4',0.00,2880.00,'Retail Sale Id 438 for retail product','2023-02-23 09:21:04','',''),('1','311',802,'','20','3',9000.00,0.00,'Retail Sale Id 439 for 12.50 KG of Cooking Gas @ N720.00','2023-02-23 09:24:01','',''),('1','311',803,'','6.1','4',0.00,9000.00,'Retail Sale Id 439 for retail product','2023-02-23 09:24:01','',''),('1','311',804,'','20','3',3600.00,0.00,'Retail Sale Id 440 for 5.00 KG of Cooking Gas @ N720.00','2023-02-23 09:25:01','',''),('1','311',805,'','6.1','4',0.00,3600.00,'Retail Sale Id 440 for retail product','2023-02-23 09:25:01','',''),('1','311',806,'','20','3',9000.00,0.00,'Retail Sale Id 441 for 12.50 KG of Cooking Gas @ N720.00','2023-02-23 09:36:04','',''),('1','311',807,'','6.1','4',0.00,9000.00,'Retail Sale Id 441 for retail product','2023-02-23 09:36:04','',''),('1','311',808,'','20','3',1440.00,0.00,'Retail Sale Id 442 for 2.00 KG of Cooking Gas @ N720.00','2023-02-23 09:37:52','',''),('1','311',809,'','6.1','4',0.00,1440.00,'Retail Sale Id 442 for retail product','2023-02-23 09:37:52','',''),('1','311',810,'','20','3',3000.00,0.00,'Retail Sale Id 443 for 4.17 KG of Cooking Gas @ N720.00','2023-02-23 10:01:06','',''),('1','311',811,'','6.1','4',0.00,3000.00,'Retail Sale Id 443 for retail product','2023-02-23 10:01:06','',''),('1','311',812,'','20','3',3600.00,0.00,'Retail Sale Id 444 for 5.00 KG of Cooking Gas @ N720.00','2023-02-23 10:01:51','',''),('1','311',813,'','6.1','4',0.00,3600.00,'Retail Sale Id 444 for retail product','2023-02-23 10:01:51','',''),('1','311',814,'','20','3',2880.00,0.00,'Retail Sale Id 445 for 4.00 KG of Cooking Gas @ N720.00','2023-02-23 10:03:30','',''),('1','311',815,'','6.1','4',0.00,2880.00,'Retail Sale Id 445 for retail product','2023-02-23 10:03:30','',''),('1','311',816,'','20','3',7200.00,0.00,'Retail Sale Id 446 for multiple products','2023-02-23 10:30:05','',''),('1','311',817,'','6.1','4',0.00,7200.00,'Retail Sale Id 446 for retail product','2023-02-23 10:30:05','',''),('1','311',818,'','20','3',9000.00,0.00,'Retail Sale Id 448 for 12.50 KG of Cooking Gas @ N720.00','2023-02-23 10:48:19','',''),('1','311',819,'','6.1','4',0.00,9000.00,'Retail Sale Id 448 for retail product','2023-02-23 10:48:19','',''),('1','311',820,'','20','3',3600.00,0.00,'Retail Sale Id 449 for 5.00 KG of Cooking Gas @ N720.00','2023-02-23 10:57:17','',''),('1','311',821,'','6.1','4',0.00,3600.00,'Retail Sale Id 449 for retail product','2023-02-23 10:57:17','',''),('1','311',822,'','20','3',3600.00,0.00,'Retail Sale Id 450 for 5.00 KG of Cooking Gas @ N720.00','2023-02-23 11:05:20','',''),('1','311',823,'','6.1','4',0.00,3600.00,'Retail Sale Id 450 for retail product','2023-02-23 11:05:20','',''),('1','311',824,'','20','3',7200.00,0.00,'Retail Sale Id 451 for 10.00 KG of Cooking Gas @ N720.00','2023-02-23 11:43:46','',''),('1','311',825,'','6.1','4',0.00,7200.00,'Retail Sale Id 451 for retail product','2023-02-23 11:43:46','',''),('1','311',826,'','20','3',2000.00,0.00,'Retail Sale Id 452 for 2.78 KG of Cooking Gas @ N720.00','2023-02-23 11:53:13','',''),('1','311',827,'','6.1','4',0.00,2000.00,'Retail Sale Id 452 for retail product','2023-02-23 11:53:13','',''),('1','311',828,'','20','3',1440.00,0.00,'Retail Sale Id 453 for 2.00 KG of Cooking Gas @ N720.00','2023-02-23 12:27:35','',''),('1','311',829,'','6.1','4',0.00,1440.00,'Retail Sale Id 453 for retail product','2023-02-23 12:27:35','',''),('1','311',830,'','20','3',1440.00,0.00,'Retail Sale Id 454 for 2.00 KG of Cooking Gas @ N720.00','2023-02-23 12:36:48','',''),('1','311',831,'','6.1','4',0.00,1440.00,'Retail Sale Id 454 for retail product','2023-02-23 12:36:48','',''),('1','311',832,'','20','3',2160.00,0.00,'Retail Sale Id 455 for 3.00 KG of Cooking Gas @ N720.00','2023-02-23 12:38:12','',''),('1','311',833,'','6.1','4',0.00,2160.00,'Retail Sale Id 455 for retail product','2023-02-23 12:38:12','',''),('1','311',834,'','20','3',3600.00,0.00,'Retail Sale Id 456 for 5.00 KG of Cooking Gas @ N720.00','2023-02-23 12:39:58','',''),('1','311',835,'','6.1','4',0.00,3600.00,'Retail Sale Id 456 for retail product','2023-02-23 12:39:58','',''),('1','311',836,'','20','3',9000.00,0.00,'Retail Sale Id 457 for 12.50 KG of Cooking Gas @ N720.00','2023-02-23 12:41:17','',''),('1','311',837,'','6.1','4',0.00,9000.00,'Retail Sale Id 457 for retail product','2023-02-23 12:41:17','',''),('1','311',838,'','20','3',3600.00,0.00,'Retail Sale Id 458 for 5.00 KG of Cooking Gas @ N720.00','2023-02-23 12:45:57','',''),('1','311',839,'','6.1','4',0.00,3600.00,'Retail Sale Id 458 for retail product','2023-02-23 12:45:57','',''),('1','311',840,'','20','3',3600.00,0.00,'Retail Sale Id 459 for 5.00 KG of Cooking Gas @ N720.00','2023-02-23 13:26:31','',''),('1','311',841,'','6.1','4',0.00,3600.00,'Retail Sale Id 459 for retail product','2023-02-23 13:26:31','',''),('1','311',842,'','20','3',3600.00,0.00,'Retail Sale Id 460 for 5.00 KG of Cooking Gas @ N720.00','2023-02-23 13:27:56','',''),('1','311',843,'','6.1','4',0.00,3600.00,'Retail Sale Id 460 for retail product','2023-02-23 13:27:56','',''),('1','311',844,'','20','3',1000.00,0.00,'Retail Sale Id 461 for 1.39 KG of Cooking Gas @ N720.00','2023-02-23 13:40:10','',''),('1','311',845,'','6.1','4',0.00,1000.00,'Retail Sale Id 461 for retail product','2023-02-23 13:40:10','',''),('1','311',846,'','20','3',3600.00,0.00,'Retail Sale Id 462 for 5.00 KG of Cooking Gas @ N720.00','2023-02-23 13:51:34','',''),('1','311',847,'','6.1','4',0.00,3600.00,'Retail Sale Id 462 for retail product','2023-02-23 13:51:34','',''),('1','311',848,'','20','3',4320.00,0.00,'Retail Sale Id 463 for 6.00 KG of Cooking Gas @ N720.00','2023-02-23 13:54:40','',''),('1','311',849,'','6.1','4',0.00,4320.00,'Retail Sale Id 463 for retail product','2023-02-23 13:54:40','',''),('1','311',850,'','20','3',2880.00,0.00,'Retail Sale Id 464 for 4.00 KG of Cooking Gas @ N720.00','2023-02-23 14:05:29','',''),('1','311',851,'','6.1','4',0.00,2880.00,'Retail Sale Id 464 for retail product','2023-02-23 14:05:29','',''),('1','311',852,'','20','3',1440.00,0.00,'Retail Sale Id 465 for 2.00 KG of Cooking Gas @ N720.00','2023-02-23 14:07:09','',''),('1','311',853,'','6.1','4',0.00,1440.00,'Retail Sale Id 465 for retail product','2023-02-23 14:07:09','',''),('1','311',854,'','20','3',2880.00,0.00,'Retail Sale Id 466 for 4.00 KG of Cooking Gas @ N720.00','2023-02-23 14:09:37','',''),('1','311',855,'','6.1','4',0.00,2880.00,'Retail Sale Id 466 for retail product','2023-02-23 14:09:37','',''),('1','311',856,'','20','3',720.00,0.00,'Retail Sale Id 467 for 1.00 KG of Cooking Gas @ N720.00','2023-02-23 14:19:46','',''),('1','311',857,'','6.1','4',0.00,720.00,'Retail Sale Id 467 for retail product','2023-02-23 14:19:46','',''),('1','311',858,'','20','3',1440.00,0.00,'Retail Sale Id 468 for 2.00 KG of Cooking Gas @ N720.00','2023-02-23 14:47:11','',''),('1','311',859,'','6.1','4',0.00,1440.00,'Retail Sale Id 468 for retail product','2023-02-23 14:47:11','',''),('1','311',860,'','20','3',2160.00,0.00,'Retail Sale Id 469 for 3.00 KG of Cooking Gas @ N720.00','2023-02-23 14:49:07','',''),('1','311',861,'','6.1','4',0.00,2160.00,'Retail Sale Id 469 for retail product','2023-02-23 14:49:07','',''),('1','311',862,'','20','3',4500.00,0.00,'Retail Sale Id 470 for multiple products','2023-02-23 15:17:41','',''),('1','311',863,'','6.1','4',0.00,4500.00,'Retail Sale Id 470 for retail product','2023-02-23 15:17:41','',''),('1','311',864,'','20','3',7200.00,0.00,'Retail Sale Id 471 for 10.00 KG of Cooking Gas @ N720.00','2023-02-23 15:27:06','',''),('1','311',865,'','6.1','4',0.00,7200.00,'Retail Sale Id 471 for retail product','2023-02-23 15:27:06','',''),('1','311',866,'','20','3',1440.00,0.00,'Retail Sale Id 472 for 2.00 KG of Cooking Gas @ N720.00','2023-02-23 15:33:41','',''),('1','311',867,'','6.1','4',0.00,1440.00,'Retail Sale Id 472 for retail product','2023-02-23 15:33:41','',''),('1','311',868,'','20','3',2520.00,0.00,'Retail Sale Id 473 for 3.50 KG of Cooking Gas @ N720.00','2023-02-23 15:46:01','',''),('1','311',869,'','6.1','4',0.00,2520.00,'Retail Sale Id 473 for retail product','2023-02-23 15:46:01','',''),('1','311',870,'','6.1','4',0.00,2520.00,'Retail Sale Id 473 for retail product','2023-02-23 15:46:01','',''),('1','311',871,'','20','3',5760.00,0.00,'Retail Sale Id 475 for 8.00 KG of Cooking Gas @ N720.00','2023-02-23 15:50:40','',''),('1','311',872,'','6.1','4',0.00,5760.00,'Retail Sale Id 475 for retail product','2023-02-23 15:50:40','',''),('1','311',873,'','20','3',11520.00,0.00,'Retail Sale Id 478 for multiple products','2023-02-23 16:21:00','',''),('1','311',874,'','6.1','4',0.00,11520.00,'Retail Sale Id 478 for retail product','2023-02-23 16:21:00','',''),('1','311',875,'','20','3',2880.00,0.00,'Retail Sale Id 479 for 4.00 KG of Cooking Gas @ N720.00','2023-02-23 16:22:26','',''),('1','311',876,'','6.1','4',0.00,2880.00,'Retail Sale Id 479 for retail product','2023-02-23 16:22:26','',''),('1','311',877,'','20','3',1440.00,0.00,'Retail Sale Id 480 for 2.00 KG of Cooking Gas @ N720.00','2023-02-23 16:28:20','',''),('1','311',878,'','6.1','4',0.00,1440.00,'Retail Sale Id 480 for retail product','2023-02-23 16:28:20','',''),('1','311',879,'','20','3',0.00,1440.00,'Return of Retail Sale Id 480 for products','2023-02-23 16:31:50','',''),('1','311',880,'','','',1440.00,0.00,'Return of Retail Sale Id 480 for products','2023-02-23 16:31:50','',''),('1','311',881,'','20','3',1500.00,0.00,'Retail Sale Id 481 for 2.08 KG of Cooking Gas @ N720.00','2023-02-23 16:32:43','',''),('1','311',882,'','6.1','4',0.00,1500.00,'Retail Sale Id 481 for retail product','2023-02-23 16:32:43','',''),('1','311',883,'','20','3',2160.00,0.00,'Retail Sale Id 482 for 3.00 KG of Cooking Gas @ N720.00','2023-02-23 16:35:17','',''),('1','311',884,'','6.1','4',0.00,2160.00,'Retail Sale Id 482 for retail product','2023-02-23 16:35:17','',''),('1','311',885,'','20','3',3600.00,0.00,'Retail Sale Id 485 for 5.00 KG of Cooking Gas @ N720.00','2023-02-23 16:42:05','',''),('1','311',886,'','6.1','4',0.00,3600.00,'Retail Sale Id 485 for retail product','2023-02-23 16:42:05','',''),('1','311',887,'','20','3',2880.00,0.00,'Retail Sale Id 486 for 4.00 KG of Cooking Gas @ N720.00','2023-02-23 16:44:49','',''),('1','311',888,'','6.1','4',0.00,2880.00,'Retail Sale Id 486 for retail product','2023-02-23 16:44:49','',''),('1','311',889,'','20','3',3600.00,0.00,'Retail Sale Id 488 for 5.00 KG of Cooking Gas @ N720.00','2023-02-23 16:47:16','',''),('1','311',890,'','6.1','4',0.00,3600.00,'Retail Sale Id 488 for retail product','2023-02-23 16:47:16','',''),('1','311',891,'','20','3',1500.00,0.00,'Retail Sale Id 489 for 2.08 KG of Cooking Gas @ N720.00','2023-02-23 16:50:41','',''),('1','311',892,'','6.1','4',0.00,1500.00,'Retail Sale Id 489 for retail product','2023-02-23 16:50:41','',''),('1','311',893,'','20','3',2880.00,0.00,'Retail Sale Id 491 for 4.00 KG of Cooking Gas @ N720.00','2023-02-23 16:59:20','',''),('1','311',894,'','6.1','4',0.00,2880.00,'Retail Sale Id 491 for retail product','2023-02-23 16:59:20','',''),('1','311',895,'','20','3',9000.00,0.00,'Retail Sale Id 492 for 12.50 KG of Cooking Gas @ N720.00','2023-02-23 17:03:28','',''),('1','311',896,'','6.1','4',0.00,9000.00,'Retail Sale Id 492 for retail product','2023-02-23 17:03:28','',''),('1','311',897,'','20','3',2160.00,0.00,'Retail Sale Id 493 for 3.00 KG of Cooking Gas @ N720.00','2023-02-23 17:16:56','',''),('1','311',898,'','6.1','4',0.00,2160.00,'Retail Sale Id 493 for retail product','2023-02-23 17:16:56','',''),('1','311',899,'','20','3',3600.00,0.00,'Retail Sale Id 494 for 5.00 KG of Cooking Gas @ N720.00','2023-02-23 17:29:11','',''),('1','311',900,'','6.1','4',0.00,3600.00,'Retail Sale Id 494 for retail product','2023-02-23 17:29:11','',''),('1','311',901,'','20','3',1000.00,0.00,'Retail Sale Id 495 for 1.39 KG of Cooking Gas @ N720.00','2023-02-23 17:38:04','',''),('1','311',902,'','6.1','4',0.00,1000.00,'Retail Sale Id 495 for retail product','2023-02-23 17:38:04','',''),('1','311',903,'','20','3',1450.00,0.00,'Retail Sale Id 496 for 2.01 KG of Cooking Gas @ N720.00','2023-02-23 17:39:30','',''),('1','311',904,'','6.1','4',0.00,1450.00,'Retail Sale Id 496 for retail product','2023-02-23 17:39:30','',''),('1','311',905,'','20','3',1440.00,0.00,'Retail Sale Id 497 for 2.00 KG of Cooking Gas @ N720.00','2023-02-23 17:40:48','',''),('1','311',906,'','6.1','4',0.00,1440.00,'Retail Sale Id 497 for retail product','2023-02-23 17:40:48','',''),('1','311',907,'','20','3',1450.00,0.00,'Retail Sale Id 498 for 2.01 KG of Cooking Gas @ N720.00','2023-02-23 17:42:13','',''),('1','311',908,'','6.1','4',0.00,1450.00,'Retail Sale Id 498 for retail product','2023-02-23 17:42:13','',''),('1','311',909,'','20','3',0.00,1000.00,'Return of Retail Sale Id 495 for products','2023-02-23 17:46:46','',''),('1','311',910,'','','',1000.00,0.00,'Return of Retail Sale Id 495 for products','2023-02-23 17:46:46','',''),('1','311',911,'','20','3',2160.00,0.00,'Retail Sale Id 499 for 3.00 KG of Cooking Gas @ N720.00','2023-02-23 17:52:44','',''),('1','311',912,'','6.1','4',0.00,2160.00,'Retail Sale Id 499 for retail product','2023-02-23 17:52:44','',''),('1','311',913,'','20','3',2880.00,0.00,'Retail Sale Id 500 for 4.00 KG of Cooking Gas @ N720.00','2023-02-23 18:18:33','',''),('1','311',914,'','6.1','4',0.00,2880.00,'Retail Sale Id 500 for retail product','2023-02-23 18:18:33','',''),('1','311',915,'','20','3',81600.00,0.00,'Retail Sale Id 501 for 120.00 KG of Cooking Gas @ N680.00','2023-02-23 18:31:17','',''),('1','311',916,'','6.1','4',0.00,81600.00,'Retail Sale Id 501 for retail product','2023-02-23 18:31:17','',''),('1','311',917,'','20','3',0.00,9000.00,'Return of Retail Sale Id 492 for products','2023-02-23 20:06:55','',''),('1','311',918,'','','',9000.00,0.00,'Return of Retail Sale Id 492 for products','2023-02-23 20:06:55','',''),('1','311',919,'','20','3',3304.80,0.00,'Retail Sale Id 502 for 4.59 KG of Cooking Gas @ N720.00','2023-02-23 20:08:28','',''),('1','311',920,'','6.1','4',0.00,3304.80,'Retail Sale Id 502 for retail product','2023-02-23 20:08:28','',''),('1','311',921,'','20','3',5695.20,0.00,'Retail Sale Id 503 for 7.91 KG of Cooking Gas @ N720.00','2023-02-23 20:09:57','',''),('1','311',922,'','6.1','4',0.00,5695.20,'Retail Sale Id 503 for retail product','2023-02-23 20:09:57','',''),('1','311',923,'','20','3',0.00,5695.20,'Return of Retail Sale Id 503 for products','2023-02-23 20:11:05','',''),('1','311',924,'','','',5695.20,0.00,'Return of Retail Sale Id 503 for products','2023-02-23 20:11:05','',''),('1','311',925,'','20','3',5754.40,0.00,'Retail Sale Id 504 for 7.99 KG of Cooking Gas @ N720.00','2023-02-23 20:11:49','',''),('1','311',926,'','6.1','4',0.00,5754.40,'Retail Sale Id 504 for retail product','2023-02-23 20:11:49','',''),('1','311',927,'','20','3',0.00,0.00,'Sales from shift 15 on 2023-02-23 20:12:43 ','2023-02-23 20:12:43','',''),('1','311',928,'','6.1','4',0.00,0.00,'Sales from shift 15 on 2023-02-23 20:12:43 ','2023-02-23 20:12:43','',''),('1','311',929,'','20','3',5050.00,0.00,'Retail Sale Id 507 for 7.01 KG of Cooking Gas @ N720.00','2023-02-28 08:14:36','',''),('1','311',930,'','6.1','4',0.00,5050.00,'Retail Sale Id 507 for retail product','2023-02-28 08:14:36','',''),('1','311',931,'','20','3',2000.00,0.00,'Retail Sale Id 508 for 2.78 KG of Cooking Gas @ N720.00','2023-02-28 08:15:44','',''),('1','311',932,'','6.1','4',0.00,2000.00,'Retail Sale Id 508 for retail product','2023-02-28 08:15:44','',''),('1','311',933,'','20','3',1700.00,0.00,'Retail Sale Id 509 for 2.36 KG of Cooking Gas @ N720.00','2023-02-28 08:16:59','',''),('1','311',934,'','6.1','4',0.00,1700.00,'Retail Sale Id 509 for retail product','2023-02-28 08:16:59','',''),('1','311',935,'','20','3',2160.00,0.00,'Retail Sale Id 510 for 3.00 KG of Cooking Gas @ N720.00','2023-02-28 08:17:52','',''),('1','311',936,'','6.1','4',0.00,2160.00,'Retail Sale Id 510 for retail product','2023-02-28 08:17:52','',''),('1','311',937,'','20','3',1000.00,0.00,'Retail Sale Id 511 for 1.39 KG of Cooking Gas @ N720.00','2023-02-28 08:18:47','',''),('1','311',938,'','6.1','4',0.00,1000.00,'Retail Sale Id 511 for retail product','2023-02-28 08:18:47','',''),('1','311',939,'','20','3',2200.00,0.00,'Retail Sale Id 512 for 3.06 KG of Cooking Gas @ N720.00','2023-02-28 08:19:48','',''),('1','311',940,'','6.1','4',0.00,2200.00,'Retail Sale Id 512 for retail product','2023-02-28 08:19:48','',''),('1','311',941,'','20','3',2900.00,0.00,'Retail Sale Id 513 for 4.03 KG of Cooking Gas @ N720.00','2023-02-28 08:21:24','',''),('1','311',942,'','6.1','4',0.00,2900.00,'Retail Sale Id 513 for retail product','2023-02-28 08:21:24','',''),('1','311',943,'','20','3',900.00,0.00,'Retail Sale Id 514 for 1.25 KG of Cooking Gas @ N720.00','2023-02-28 08:22:35','',''),('1','311',944,'','6.1','4',0.00,900.00,'Retail Sale Id 514 for retail product','2023-02-28 08:22:35','',''),('1','311',945,'','20','3',2880.00,0.00,'Retail Sale Id 515 for 4.00 KG of Cooking Gas @ N720.00','2023-02-28 08:24:09','',''),('1','311',946,'','6.1','4',0.00,2880.00,'Retail Sale Id 515 for retail product','2023-02-28 08:24:09','',''),('1','311',947,'','20','3',0.00,900.00,'Return of Retail Sale Id 514 for products','2023-02-28 08:44:10','',''),('1','311',948,'','','',900.00,0.00,'Return of Retail Sale Id 514 for products','2023-02-28 08:44:10','',''),('1','311',949,'','20','3',4320.00,0.00,'Retail Sale Id 517 for 6.00 KG of Cooking Gas @ N720.00','2023-02-28 08:47:40','',''),('1','311',950,'','6.1','4',0.00,4320.00,'Retail Sale Id 517 for retail product','2023-02-28 08:47:40','',''),('1','311',951,'','20','3',2880.00,0.00,'Retail Sale Id 518 for 4.00 KG of Cooking Gas @ N720.00','2023-02-28 08:50:59','',''),('1','311',952,'','6.1','4',0.00,2880.00,'Retail Sale Id 518 for retail product','2023-02-28 08:50:59','',''),('1','311',953,'','20','3',1000.00,0.00,'Retail Sale Id 519 for 1.39 KG of Cooking Gas @ N720.00','2023-02-28 08:52:12','',''),('1','311',954,'','6.1','4',0.00,1000.00,'Retail Sale Id 519 for retail product','2023-02-28 08:52:12','',''),('1','311',955,'','20','3',3000.00,0.00,'Retail Sale Id 521 for 4.17 KG of Cooking Gas @ N720.00','2023-02-28 08:54:31','',''),('1','311',956,'','6.1','4',0.00,3000.00,'Retail Sale Id 521 for retail product','2023-02-28 08:54:31','',''),('1','311',957,'','20','3',1440.00,0.00,'Retail Sale Id 522 for 2.00 KG of Cooking Gas @ N720.00','2023-02-28 08:55:38','',''),('1','311',958,'','6.1','4',0.00,1440.00,'Retail Sale Id 522 for retail product','2023-02-28 08:55:38','',''),('1','311',959,'','20','3',4320.00,0.00,'Retail Sale Id 523 for 6.00 KG of Cooking Gas @ N720.00','2023-02-28 08:58:01','',''),('1','311',960,'','6.1','4',0.00,4320.00,'Retail Sale Id 523 for retail product','2023-02-28 08:58:01','',''),('1','311',961,'','20','3',2880.00,0.00,'Retail Sale Id 524 for 4.00 KG of Cooking Gas @ N720.00','2023-02-28 09:05:01','',''),('1','311',962,'','6.1','4',0.00,2880.00,'Retail Sale Id 524 for retail product','2023-02-28 09:05:01','',''),('1','311',963,'','20','3',3600.00,0.00,'Retail Sale Id 525 for 5.00 KG of Cooking Gas @ N720.00','2023-02-28 09:07:14','',''),('1','311',964,'','6.1','4',0.00,3600.00,'Retail Sale Id 525 for retail product','2023-02-28 09:07:14','',''),('1','311',965,'','20','3',9000.00,0.00,'Retail Sale Id 526 for 12.50 KG of Cooking Gas @ N720.00','2023-02-28 09:15:44','',''),('1','311',966,'','6.1','4',0.00,9000.00,'Retail Sale Id 526 for retail product','2023-02-28 09:15:44','',''),('1','311',967,'','20','3',11160.00,0.00,'Retail Sale Id 527 for multiple products','2023-02-28 09:17:41','',''),('1','311',968,'','6.1','4',0.00,11160.00,'Retail Sale Id 527 for retail product','2023-02-28 09:17:41','',''),('1','311',969,'','20','3',2000.00,0.00,'Retail Sale Id 528 for 2.78 KG of Cooking Gas @ N720.00','2023-02-28 09:20:03','',''),('1','311',970,'','6.1','4',0.00,2000.00,'Retail Sale Id 528 for retail product','2023-02-28 09:20:03','',''),('1','311',971,'','20','3',9000.00,0.00,'Retail Sale Id 529 for 12.50 KG of Cooking Gas @ N720.00','2023-02-28 09:21:32','',''),('1','311',972,'','6.1','4',0.00,9000.00,'Retail Sale Id 529 for retail product','2023-02-28 09:21:32','',''),('1','311',973,'','20','3',3600.00,0.00,'Retail Sale Id 530 for 5.00 KG of Cooking Gas @ N720.00','2023-02-28 09:24:08','',''),('1','311',974,'','6.1','4',0.00,3600.00,'Retail Sale Id 530 for retail product','2023-02-28 09:24:08','',''),('1','311',975,'','20','3',2160.00,0.00,'Retail Sale Id 531 for 3.00 KG of Cooking Gas @ N720.00','2023-02-28 09:32:48','',''),('1','311',976,'','6.1','4',0.00,2160.00,'Retail Sale Id 531 for retail product','2023-02-28 09:32:48','',''),('1','311',977,'','20','3',5040.00,0.00,'Retail Sale Id 532 for 7.00 KG of Cooking Gas @ N720.00','2023-02-28 09:34:26','',''),('1','311',978,'','6.1','4',0.00,5040.00,'Retail Sale Id 532 for retail product','2023-02-28 09:34:26','',''),('1','311',979,'','20','3',1440.00,0.00,'Retail Sale Id 533 for 2.00 KG of Cooking Gas @ N720.00','2023-02-28 09:36:36','',''),('1','311',980,'','6.1','4',0.00,1440.00,'Retail Sale Id 533 for retail product','2023-02-28 09:36:36','',''),('1','311',981,'','20','3',750.00,0.00,'Retail Sale Id 534 for 1.04 KG of Cooking Gas @ N720.00','2023-02-28 09:39:28','',''),('1','311',982,'','6.1','4',0.00,750.00,'Retail Sale Id 534 for retail product','2023-02-28 09:39:28','',''),('1','311',983,'','20','3',3000.00,0.00,'Retail Sale Id 535 for 4.17 KG of Cooking Gas @ N720.00','2023-02-28 09:41:10','',''),('1','311',984,'','6.1','4',0.00,3000.00,'Retail Sale Id 535 for retail product','2023-02-28 09:41:10','',''),('1','311',985,'','20','3',2500.00,0.00,'Retail Sale Id 536 for 3.47 KG of Cooking Gas @ N720.00','2023-02-28 09:42:38','',''),('1','311',986,'','6.1','4',0.00,2500.00,'Retail Sale Id 536 for retail product','2023-02-28 09:42:38','',''),('1','311',987,'','20','3',2160.00,0.00,'Retail Sale Id 540 for 3.00 KG of Cooking Gas @ N720.00','2023-02-28 09:48:40','',''),('1','311',988,'','6.1','4',0.00,2160.00,'Retail Sale Id 540 for retail product','2023-02-28 09:48:40','',''),('1','311',989,'','20','3',7200.00,0.00,'Retail Sale Id 541 for 10.00 KG of Cooking Gas @ N720.00','2023-02-28 09:53:05','',''),('1','311',990,'','6.1','4',0.00,7200.00,'Retail Sale Id 541 for retail product','2023-02-28 09:53:05','',''),('1','311',991,'','20','3',1440.00,0.00,'Retail Sale Id 543 for 2.00 KG of Cooking Gas @ N720.00','2023-02-28 10:03:40','',''),('1','311',992,'','6.1','4',0.00,1440.00,'Retail Sale Id 543 for retail product','2023-02-28 10:03:40','',''),('1','311',993,'','20','3',2160.00,0.00,'Retail Sale Id 544 for 3.00 KG of Cooking Gas @ N720.00','2023-02-28 10:05:18','',''),('1','311',994,'','6.1','4',0.00,2160.00,'Retail Sale Id 544 for retail product','2023-02-28 10:05:18','',''),('1','311',995,'','20','3',9000.00,0.00,'Retail Sale Id 546 for 12.50 KG of Cooking Gas @ N720.00','2023-02-28 10:08:00','',''),('1','311',996,'','6.1','4',0.00,9000.00,'Retail Sale Id 546 for retail product','2023-02-28 10:08:00','',''),('1','311',997,'','20','3',3000.00,0.00,'Retail Sale Id 549 for 4.17 KG of Cooking Gas @ N720.00','2023-02-28 10:20:22','',''),('1','311',998,'','6.1','4',0.00,3000.00,'Retail Sale Id 549 for retail product','2023-02-28 10:20:22','',''),('1','311',999,'','20','3',2000.00,0.00,'Retail Sale Id 550 for 2.78 KG of Cooking Gas @ N720.00','2023-02-28 10:21:06','',''),('1','311',1000,'','6.1','4',0.00,2000.00,'Retail Sale Id 550 for retail product','2023-02-28 10:21:06','',''),('1','311',1001,'','20','3',3600.00,0.00,'Retail Sale Id 551 for 5.00 KG of Cooking Gas @ N720.00','2023-02-28 10:21:46','',''),('1','311',1002,'','6.1','4',0.00,3600.00,'Retail Sale Id 551 for retail product','2023-02-28 10:21:46','',''),('1','311',1003,'','20','3',7200.00,0.00,'Retail Sale Id 552 for 10.00 KG of Cooking Gas @ N720.00','2023-02-28 10:22:43','',''),('1','311',1004,'','6.1','4',0.00,7200.00,'Retail Sale Id 552 for retail product','2023-02-28 10:22:43','',''),('1','311',1005,'','20','3',4320.00,0.00,'Retail Sale Id 554 for 6.00 KG of Cooking Gas @ N720.00','2023-02-28 10:25:54','',''),('1','311',1006,'','6.1','4',0.00,4320.00,'Retail Sale Id 554 for retail product','2023-02-28 10:25:54','',''),('1','311',1007,'','20','3',7920.00,0.00,'Retail Sale Id 556 for 11.00 KG of Cooking Gas @ N720.00','2023-02-28 10:28:11','',''),('1','311',1008,'','6.1','4',0.00,7920.00,'Retail Sale Id 556 for retail product','2023-02-28 10:28:11','',''),('1','311',1009,'','20','3',2000.00,0.00,'Retail Sale Id 557 for 2.78 KG of Cooking Gas @ N720.00','2023-02-28 10:31:20','',''),('1','311',1010,'','6.1','4',0.00,2000.00,'Retail Sale Id 557 for retail product','2023-02-28 10:31:20','',''),('1','311',1011,'','20','3',7200.00,0.00,'Retail Sale Id 558 for 10.00 KG of Cooking Gas @ N720.00','2023-02-28 10:45:47','',''),('1','311',1012,'','6.1','4',0.00,7200.00,'Retail Sale Id 558 for retail product','2023-02-28 10:45:47','',''),('1','311',1013,'','20','3',9000.00,0.00,'Retail Sale Id 559 for 12.50 KG of Cooking Gas @ N720.00','2023-02-28 10:56:22','',''),('1','311',1014,'','6.1','4',0.00,9000.00,'Retail Sale Id 559 for retail product','2023-02-28 10:56:22','',''),('1','311',1015,'','20','3',3600.00,0.00,'Retail Sale Id 563 for 5.00 KG of Cooking Gas @ N720.00','2023-02-28 11:04:49','',''),('1','311',1016,'','6.1','4',0.00,3600.00,'Retail Sale Id 563 for retail product','2023-02-28 11:04:49','',''),('1','311',1017,'','20','3',2100.00,0.00,'Retail Sale Id 564 for 2.92 KG of Cooking Gas @ N720.00','2023-02-28 11:11:03','',''),('1','311',1018,'','6.1','4',0.00,2100.00,'Retail Sale Id 564 for retail product','2023-02-28 11:11:03','',''),('1','311',1019,'','20','3',2160.00,0.00,'Retail Sale Id 565 for 3.00 KG of Cooking Gas @ N720.00','2023-02-28 11:14:54','',''),('1','311',1020,'','6.1','4',0.00,2160.00,'Retail Sale Id 565 for retail product','2023-02-28 11:14:54','',''),('1','311',1021,'','20','3',204000.00,0.00,'Retail Sale Id 566 for 300.00 KG of Cooking Gas @ N680.00','2023-02-28 11:20:24','',''),('1','311',1022,'','6.1','4',0.00,204000.00,'Retail Sale Id 566 for retail product','2023-02-28 11:20:24','',''),('1','311',1023,'','20','3',4320.00,0.00,'Retail Sale Id 567 for 6.00 KG of Cooking Gas @ N720.00','2023-02-28 11:23:35','',''),('1','311',1024,'','6.1','4',0.00,4320.00,'Retail Sale Id 567 for retail product','2023-02-28 11:23:35','',''),('1','311',1025,'','20','3',3000.00,0.00,'Retail Sale Id 568 for 4.17 KG of Cooking Gas @ N720.00','2023-02-28 11:33:33','',''),('1','311',1026,'','6.1','4',0.00,3000.00,'Retail Sale Id 568 for retail product','2023-02-28 11:33:33','',''),('1','311',1027,'','20','3',1000.00,0.00,'Retail Sale Id 570 for 1.39 KG of Cooking Gas @ N720.00','2023-02-28 11:47:09','',''),('1','311',1028,'','6.1','4',0.00,1000.00,'Retail Sale Id 570 for retail product','2023-02-28 11:47:09','',''),('1','311',1029,'','2','15',94020.00,0.00,'Payment Id 4 for invoice:3, receipt: 0000 by AA RANO NIGERIA LTD','2023-02-28 11:47:13','',''),('1','311',1030,'','supplier','1',0.00,94020.00,'Payment Id 4 for invoice:3, receipt: 0000 by AA RANO NIGERIA LTD','2023-02-28 11:47:13','',''),('1','311',1031,'','2','9',61721.00,0.00,'Payment Id 3 for invoice:4, receipt: FIDELITY POS by AA RANO NIGERIA LTD','2023-02-28 11:48:33','',''),('1','311',1032,'','supplier','1',0.00,61721.00,'Payment Id 3 for invoice:4, receipt: FIDELITY POS by AA RANO NIGERIA LTD','2023-02-28 11:48:33','',''),('1','311',1033,'','2','15',47780.00,0.00,'Payment Id 2 for invoice:4, receipt: 0000 by AA RANO NIGERIA LTD','2023-02-28 11:48:33','',''),('1','311',1034,'','supplier','1',0.00,47780.00,'Payment Id 2 for invoice:4, receipt: 0000 by AA RANO NIGERIA LTD','2023-02-28 11:48:33','',''),('1','311',1035,'','2','15',12500.00,0.00,'Payment Id 5 for invoice:5, receipt: 0000 by AA RANO NIGERIA LTD','2023-02-28 11:49:11','',''),('1','311',1036,'','supplier','1',0.00,12500.00,'Payment Id 5 for invoice:5, receipt: 0000 by AA RANO NIGERIA LTD','2023-02-28 11:49:11','',''),('1','311',1037,'','20','3',4000.00,0.00,'Retail Sale Id 571 for 5.56 KG of Cooking Gas @ N720.00','2023-02-28 11:49:38','',''),('1','311',1038,'','6.1','4',0.00,4000.00,'Retail Sale Id 571 for retail product','2023-02-28 11:49:38','',''),('1','311',1039,'','20','3',2000.00,0.00,'Retail Sale Id 572 for 2.78 KG of Cooking Gas @ N720.00','2023-02-28 11:53:26','',''),('1','311',1040,'','6.1','4',0.00,2000.00,'Retail Sale Id 572 for retail product','2023-02-28 11:53:26','',''),('1','311',1041,'','2','9',98761.00,0.00,'Payment Id 12 for invoice:10, receipt: FIDELITY POS by AA RANO NIGERIA LTD','2023-02-28 12:00:40','',''),('1','311',1042,'','supplier','1',0.00,98761.00,'Payment Id 12 for invoice:10, receipt: FIDELITY POS by AA RANO NIGERIA LTD','2023-02-28 12:00:40','',''),('1','311',1043,'','20','3',122400.00,0.00,'Retail Sale Id 573 for 180.00 KG of Cooking Gas @ N680.00','2023-02-28 12:01:04','',''),('1','311',1044,'','6.1','4',0.00,122400.00,'Retail Sale Id 573 for retail product','2023-02-28 12:01:04','',''),('1','311',1045,'','2','9',111680.00,0.00,'Payment Id 10 for invoice:9, receipt: 0000 by AA RANO NIGERIA LTD','2023-02-28 12:05:25','',''),('1','311',1046,'','supplier','1',0.00,111680.00,'Payment Id 10 for invoice:9, receipt: 0000 by AA RANO NIGERIA LTD','2023-02-28 12:05:25','',''),('1','311',1047,'','2','9',5320.00,0.00,'Payment Id 14 for invoice:11, receipt: FIDELITY POS by AA RANO NIGERIA LTD','2023-02-28 12:10:59','',''),('1','311',1048,'','supplier','1',0.00,5320.00,'Payment Id 14 for invoice:11, receipt: FIDELITY POS by AA RANO NIGERIA LTD','2023-02-28 12:10:59','',''),('1','311',1049,'','20','3',1450.00,0.00,'Retail Sale Id 574 for 2.01 KG of Cooking Gas @ N720.00','2023-02-28 12:16:50','',''),('1','311',1050,'','6.1','4',0.00,1450.00,'Retail Sale Id 574 for retail product','2023-02-28 12:16:50','',''),('1','311',1051,'','20','3',2160.00,0.00,'Retail Sale Id 575 for 3.00 KG of Cooking Gas @ N720.00','2023-02-28 12:29:44','',''),('1','311',1052,'','6.1','4',0.00,2160.00,'Retail Sale Id 575 for retail product','2023-02-28 12:29:44','',''),('1','311',1053,'','20','3',1440.00,0.00,'Retail Sale Id 576 for 2.00 KG of Cooking Gas @ N720.00','2023-02-28 12:39:10','',''),('1','311',1054,'','6.1','4',0.00,1440.00,'Retail Sale Id 576 for retail product','2023-02-28 12:39:10','',''),('1','311',1055,'','20','3',9000.00,0.00,'Retail Sale Id 577 for 12.50 KG of Cooking Gas @ N720.00','2023-02-28 13:10:10','',''),('1','311',1056,'','6.1','4',0.00,9000.00,'Retail Sale Id 577 for retail product','2023-02-28 13:10:10','',''),('1','311',1057,'','20','3',8000.00,0.00,'Retail Sale Id 578 for 11.11 KG of Cooking Gas @ N720.00','2023-02-28 13:11:45','',''),('1','311',1058,'','6.1','4',0.00,8000.00,'Retail Sale Id 578 for retail product','2023-02-28 13:11:45','',''),('1','311',1059,'','20','3',0.00,8000.00,'Return of Retail Sale Id 578 for products','2023-02-28 13:13:04','',''),('1','311',1060,'','','',8000.00,0.00,'Return of Retail Sale Id 578 for products','2023-02-28 13:13:04','',''),('1','311',1061,'','20','3',8000.00,0.00,'Retail Sale Id 579 for 11.11 KG of Cooking Gas @ N720.00','2023-02-28 13:14:35','',''),('1','311',1062,'','6.1','4',0.00,8000.00,'Retail Sale Id 579 for retail product','2023-02-28 13:14:35','',''),('1','311',1063,'','20','3',5050.00,0.00,'Retail Sale Id 581 for 7.01 KG of Cooking Gas @ N720.00','2023-02-28 13:25:29','',''),('1','311',1064,'','6.1','4',0.00,5050.00,'Retail Sale Id 581 for retail product','2023-02-28 13:25:29','',''),('1','311',1065,'','20','3',1440.00,0.00,'Retail Sale Id 582 for 2.00 KG of Cooking Gas @ N720.00','2023-02-28 13:35:02','',''),('1','311',1066,'','6.1','4',0.00,1440.00,'Retail Sale Id 582 for retail product','2023-02-28 13:35:02','',''),('1','311',1067,'','20','3',4320.00,0.00,'Retail Sale Id 583 for 6.00 KG of Cooking Gas @ N720.00','2023-02-28 13:53:09','',''),('1','311',1068,'','6.1','4',0.00,4320.00,'Retail Sale Id 583 for retail product','2023-02-28 13:53:09','',''),('1','311',1069,'','20','3',4320.00,0.00,'Retail Sale Id 584 for 6.00 KG of Cooking Gas @ N720.00','2023-02-28 14:01:56','',''),('1','311',1070,'','6.1','4',0.00,4320.00,'Retail Sale Id 584 for retail product','2023-02-28 14:01:56','',''),('1','311',1071,'','20','3',3600.00,0.00,'Retail Sale Id 586 for 5.00 KG of Cooking Gas @ N720.00','2023-02-28 14:07:21','',''),('1','311',1072,'','6.1','4',0.00,3600.00,'Retail Sale Id 586 for retail product','2023-02-28 14:07:21','',''),('1','311',1073,'','20','3',2160.00,0.00,'Retail Sale Id 587 for 3.00 KG of Cooking Gas @ N720.00','2023-02-28 14:11:48','',''),('1','311',1074,'','6.1','4',0.00,2160.00,'Retail Sale Id 587 for retail product','2023-02-28 14:11:48','',''),('1','311',1075,'','20','3',3600.00,0.00,'Retail Sale Id 588 for 5.00 KG of Cooking Gas @ N720.00','2023-02-28 14:26:24','',''),('1','311',1076,'','6.1','4',0.00,3600.00,'Retail Sale Id 588 for retail product','2023-02-28 14:26:24','',''),('1','311',1077,'','20','3',1440.00,0.00,'Retail Sale Id 589 for 2.00 KG of Cooking Gas @ N720.00','2023-02-28 14:27:52','',''),('1','311',1078,'','6.1','4',0.00,1440.00,'Retail Sale Id 589 for retail product','2023-02-28 14:27:52','',''),('1','311',1079,'','20','3',3000.00,0.00,'Retail Sale Id 590 for 4.17 KG of Cooking Gas @ N720.00','2023-02-28 14:34:58','',''),('1','311',1080,'','6.1','4',0.00,3000.00,'Retail Sale Id 590 for retail product','2023-02-28 14:34:58','',''),('1','311',1081,'','6.1','4',0.00,3000.00,'Retail Sale Id 590 for retail product','2023-02-28 14:34:58','',''),('1','311',1082,'','20','3',9000.00,0.00,'Retail Sale Id 591 for 12.50 KG of Cooking Gas @ N720.00','2023-02-28 14:36:52','',''),('1','311',1083,'','6.1','4',0.00,9000.00,'Retail Sale Id 591 for retail product','2023-02-28 14:36:52','',''),('1','311',1084,'','20','3',2200.00,0.00,'Retail Sale Id 593 for 3.06 KG of Cooking Gas @ N720.00','2023-02-28 14:41:51','',''),('1','311',1085,'','6.1','4',0.00,2200.00,'Retail Sale Id 593 for retail product','2023-02-28 14:41:51','',''),('1','311',1086,'','20','3',1440.00,0.00,'Retail Sale Id 595 for 2.00 KG of Cooking Gas @ N720.00','2023-02-28 14:49:43','',''),('1','311',1087,'','6.1','4',0.00,1440.00,'Retail Sale Id 595 for retail product','2023-02-28 14:49:43','',''),('1','311',1088,'','20','3',9000.00,0.00,'Retail Sale Id 596 for 12.50 KG of Cooking Gas @ N720.00','2023-02-28 14:51:26','',''),('1','311',1089,'','6.1','4',0.00,9000.00,'Retail Sale Id 596 for retail product','2023-02-28 14:51:26','',''),('1','311',1090,'','20','3',8640.00,0.00,'Retail Sale Id 597 for 12.00 KG of Cooking Gas @ N720.00','2023-02-28 14:54:59','',''),('1','311',1091,'','6.1','4',0.00,8640.00,'Retail Sale Id 597 for retail product','2023-02-28 14:54:59','',''),('1','311',1092,'','20','3',2160.00,0.00,'Retail Sale Id 598 for 3.00 KG of Cooking Gas @ N720.00','2023-02-28 14:59:02','',''),('1','311',1093,'','6.1','4',0.00,2160.00,'Retail Sale Id 598 for retail product','2023-02-28 14:59:02','',''),('1','311',1094,'','20','3',9000.00,0.00,'Retail Sale Id 599 for 12.50 KG of Cooking Gas @ N720.00','2023-02-28 15:02:38','',''),('1','311',1095,'','6.1','4',0.00,9000.00,'Retail Sale Id 599 for retail product','2023-02-28 15:02:38','',''),('1','311',1096,'','20','3',2880.00,0.00,'Retail Sale Id 601 for multiple products','2023-02-28 15:06:15','',''),('1','311',1097,'','6.1','4',0.00,2880.00,'Retail Sale Id 601 for retail product','2023-02-28 15:06:15','',''),('1','311',1098,'','20','3',8640.00,0.00,'Retail Sale Id 603 for multiple products','2023-02-28 15:10:15','',''),('1','311',1099,'','6.1','4',0.00,8640.00,'Retail Sale Id 603 for retail product','2023-02-28 15:10:15','',''),('1','311',1100,'','20','3',0.00,9000.00,'Return of Retail Sale Id 599 for products','2023-02-28 15:11:36','',''),('1','311',1101,'','','',9000.00,0.00,'Return of Retail Sale Id 599 for products','2023-02-28 15:11:36','',''),('1','311',1102,'','20','3',8661.60,0.00,'Retail Sale Id 604 for 12.03 KG of Cooking Gas @ N720.00','2023-02-28 15:13:35','',''),('1','311',1103,'','6.1','4',0.00,8661.60,'Retail Sale Id 604 for retail product','2023-02-28 15:13:35','',''),('1','311',1104,'','20','3',1440.00,0.00,'Retail Sale Id 605 for 2.00 KG of Cooking Gas @ N720.00','2023-02-28 15:14:41','',''),('1','311',1105,'','6.1','4',0.00,1440.00,'Retail Sale Id 605 for retail product','2023-02-28 15:14:41','',''),('1','311',1106,'','20','3',2150.00,0.00,'Retail Sale Id 606 for 2.99 KG of Cooking Gas @ N720.00','2023-02-28 15:21:53','',''),('1','311',1107,'','6.1','4',0.00,2150.00,'Retail Sale Id 606 for retail product','2023-02-28 15:21:53','',''),('1','311',1108,'','20','3',2880.00,0.00,'Retail Sale Id 607 for 4.00 KG of Cooking Gas @ N720.00','2023-02-28 16:18:33','',''),('1','311',1109,'','6.1','4',0.00,2880.00,'Retail Sale Id 607 for retail product','2023-02-28 16:18:33','',''),('1','311',1110,'','20','3',2000.00,0.00,'Retail Sale Id 608 for 2.78 KG of Cooking Gas @ N720.00','2023-02-28 16:19:20','',''),('1','311',1111,'','6.1','4',0.00,2000.00,'Retail Sale Id 608 for retail product','2023-02-28 16:19:20','',''),('1','311',1112,'','20','3',1500.00,0.00,'Retail Sale Id 609 for 2.08 KG of Cooking Gas @ N720.00','2023-02-28 16:20:03','',''),('1','311',1113,'','6.1','4',0.00,1500.00,'Retail Sale Id 609 for retail product','2023-02-28 16:20:03','',''),('1','311',1114,'','20','3',3600.00,0.00,'Retail Sale Id 610 for 5.00 KG of Cooking Gas @ N720.00','2023-02-28 16:20:52','',''),('1','311',1115,'','6.1','4',0.00,3600.00,'Retail Sale Id 610 for retail product','2023-02-28 16:20:52','',''),('1','311',1116,'','20','3',4000.00,0.00,'Retail Sale Id 611 for 5.56 KG of Cooking Gas @ N720.00','2023-02-28 16:21:41','',''),('1','311',1117,'','6.1','4',0.00,4000.00,'Retail Sale Id 611 for retail product','2023-02-28 16:21:41','',''),('1','311',1118,'','20','3',1000.00,0.00,'Retail Sale Id 612 for 1.39 KG of Cooking Gas @ N720.00','2023-02-28 16:22:37','',''),('1','311',1119,'','6.1','4',0.00,1000.00,'Retail Sale Id 612 for retail product','2023-02-28 16:22:37','',''),('1','311',1120,'','20','3',11000.00,0.00,'Retail Sale Id 613 for 15.28 KG of Cooking Gas @ N720.00','2023-02-28 16:24:12','',''),('1','311',1121,'','6.1','4',0.00,11000.00,'Retail Sale Id 613 for retail product','2023-02-28 16:24:12','',''),('1','311',1122,'','20','3',5040.00,0.00,'Retail Sale Id 614 for 7.00 KG of Cooking Gas @ N720.00','2023-02-28 16:25:16','',''),('1','311',1123,'','6.1','4',0.00,5040.00,'Retail Sale Id 614 for retail product','2023-02-28 16:25:16','',''),('1','311',1124,'','20','3',1500.00,0.00,'Retail Sale Id 615 for 2.08 KG of Cooking Gas @ N720.00','2023-02-28 16:26:21','',''),('1','311',1125,'','6.1','4',0.00,1500.00,'Retail Sale Id 615 for retail product','2023-02-28 16:26:21','',''),('1','311',1126,'','20','3',4320.00,0.00,'Retail Sale Id 617 for 6.00 KG of Cooking Gas @ N720.00','2023-02-28 16:29:00','',''),('1','311',1127,'','6.1','4',0.00,4320.00,'Retail Sale Id 617 for retail product','2023-02-28 16:29:00','',''),('1','311',1128,'','20','3',14400.00,0.00,'Retail Sale Id 618 for multiple products','2023-02-28 16:30:20','',''),('1','311',1129,'','6.1','4',0.00,14400.00,'Retail Sale Id 618 for retail product','2023-02-28 16:30:20','',''),('1','311',1130,'','20','3',1500.00,0.00,'Retail Sale Id 619 for 2.08 KG of Cooking Gas @ N720.00','2023-02-28 16:31:51','',''),('1','311',1131,'','6.1','4',0.00,1500.00,'Retail Sale Id 619 for retail product','2023-02-28 16:31:51','',''),('1','311',1132,'','20','3',2200.00,0.00,'Retail Sale Id 620 for 3.06 KG of Cooking Gas @ N720.00','2023-02-28 16:32:55','',''),('1','311',1133,'','6.1','4',0.00,2200.00,'Retail Sale Id 620 for retail product','2023-02-28 16:32:55','',''),('1','311',1134,'','20','3',4320.00,0.00,'Retail Sale Id 621 for 6.00 KG of Cooking Gas @ N720.00','2023-02-28 16:34:06','',''),('1','311',1135,'','6.1','4',0.00,4320.00,'Retail Sale Id 621 for retail product','2023-02-28 16:34:06','',''),('1','311',1136,'','20','3',1500.00,0.00,'Retail Sale Id 622 for 2.08 KG of Cooking Gas @ N720.00','2023-02-28 16:34:59','',''),('1','311',1137,'','6.1','4',0.00,1500.00,'Retail Sale Id 622 for retail product','2023-02-28 16:34:59','',''),('1','311',1138,'','20','3',4320.00,0.00,'Retail Sale Id 623 for 6.00 KG of Cooking Gas @ N720.00','2023-02-28 16:38:17','',''),('1','311',1139,'','6.1','4',0.00,4320.00,'Retail Sale Id 623 for retail product','2023-02-28 16:38:17','',''),('1','311',1140,'','20','3',5040.00,0.00,'Retail Sale Id 624 for 7.00 KG of Cooking Gas @ N720.00','2023-02-28 16:39:39','',''),('1','311',1141,'','6.1','4',0.00,5040.00,'Retail Sale Id 624 for retail product','2023-02-28 16:39:39','',''),('1','311',1142,'','20','3',2160.00,0.00,'Retail Sale Id 625 for 3.00 KG of Cooking Gas @ N720.00','2023-02-28 16:40:42','',''),('1','311',1143,'','6.1','4',0.00,2160.00,'Retail Sale Id 625 for retail product','2023-02-28 16:40:42','',''),('1','311',1144,'','20','3',4320.00,0.00,'Retail Sale Id 626 for 6.00 KG of Cooking Gas @ N720.00','2023-02-28 16:42:23','',''),('1','311',1145,'','6.1','4',0.00,4320.00,'Retail Sale Id 626 for retail product','2023-02-28 16:42:23','',''),('1','311',1146,'','20','3',799.20,0.00,'Retail Sale Id 627 for 1.11 KG of Cooking Gas @ N720.00','2023-02-28 16:44:13','',''),('1','311',1147,'','6.1','4',0.00,799.20,'Retail Sale Id 627 for retail product','2023-02-28 16:44:13','',''),('1','311',1148,'','20','3',1500.00,0.00,'Retail Sale Id 628 for 2.08 KG of Cooking Gas @ N720.00','2023-02-28 16:46:56','',''),('1','311',1149,'','6.1','4',0.00,1500.00,'Retail Sale Id 628 for retail product','2023-02-28 16:46:56','',''),('1','311',1150,'','20','3',2160.00,0.00,'Retail Sale Id 629 for 3.00 KG of Cooking Gas @ N720.00','2023-02-28 16:47:33','',''),('1','311',1151,'','6.1','4',0.00,2160.00,'Retail Sale Id 629 for retail product','2023-02-28 16:47:33','',''),('1','311',1152,'','20','3',2880.00,0.00,'Retail Sale Id 630 for 4.00 KG of Cooking Gas @ N720.00','2023-02-28 16:48:53','',''),('1','311',1153,'','6.1','4',0.00,2880.00,'Retail Sale Id 630 for retail product','2023-02-28 16:48:53','',''),('1','311',1154,'','20','3',3600.00,0.00,'Retail Sale Id 631 for 5.00 KG of Cooking Gas @ N720.00','2023-02-28 16:49:45','',''),('1','311',1155,'','6.1','4',0.00,3600.00,'Retail Sale Id 631 for retail product','2023-02-28 16:49:45','',''),('1','311',1156,'','20','3',5040.00,0.00,'Retail Sale Id 632 for 7.00 KG of Cooking Gas @ N720.00','2023-02-28 16:50:39','',''),('1','311',1157,'','6.1','4',0.00,5040.00,'Retail Sale Id 632 for retail product','2023-02-28 16:50:39','',''),('1','311',1158,'','20','3',800.00,0.00,'Retail Sale Id 634 for 1.11 KG of Cooking Gas @ N720.00','2023-02-28 16:59:44','',''),('1','311',1159,'','6.1','4',0.00,800.00,'Retail Sale Id 634 for retail product','2023-02-28 16:59:44','',''),('1','311',1160,'','20','3',3000.00,0.00,'Retail Sale Id 635 for 4.17 KG of Cooking Gas @ N720.00','2023-02-28 17:08:22','',''),('1','311',1161,'','6.1','4',0.00,3000.00,'Retail Sale Id 635 for retail product','2023-02-28 17:08:22','',''),('1','311',1162,'','20','3',4320.00,0.00,'Retail Sale Id 636 for 6.00 KG of Cooking Gas @ N720.00','2023-02-28 17:12:26','',''),('1','311',1163,'','6.1','4',0.00,4320.00,'Retail Sale Id 636 for retail product','2023-02-28 17:12:26','',''),('1','311',1164,'','20','3',2160.00,0.00,'Retail Sale Id 637 for 3.00 KG of Cooking Gas @ N720.00','2023-02-28 17:13:39','',''),('1','311',1165,'','6.1','4',0.00,2160.00,'Retail Sale Id 637 for retail product','2023-02-28 17:13:39','',''),('1','311',1166,'','20','3',2880.00,0.00,'Retail Sale Id 638 for 4.00 KG of Cooking Gas @ N720.00','2023-02-28 17:14:39','',''),('1','311',1167,'','6.1','4',0.00,2880.00,'Retail Sale Id 638 for retail product','2023-02-28 17:14:39','',''),('1','311',1168,'','20','3',7920.00,0.00,'Retail Sale Id 639 for multiple products','2023-02-28 17:17:41','',''),('1','311',1169,'','6.1','4',0.00,7920.00,'Retail Sale Id 639 for retail product','2023-02-28 17:17:41','',''),('1','311',1170,'','20','3',4000.00,0.00,'Retail Sale Id 640 for 5.56 KG of Cooking Gas @ N720.00','2023-02-28 17:20:00','',''),('1','311',1171,'','6.1','4',0.00,4000.00,'Retail Sale Id 640 for retail product','2023-02-28 17:20:01','',''),('1','311',1172,'','20','3',9000.00,0.00,'Retail Sale Id 641 for 12.50 KG of Cooking Gas @ N720.00','2023-02-28 17:21:20','',''),('1','311',1173,'','6.1','4',0.00,9000.00,'Retail Sale Id 641 for retail product','2023-02-28 17:21:20','',''),('1','311',1174,'','20','3',3600.00,0.00,'Retail Sale Id 642 for 5.00 KG of Cooking Gas @ N720.00','2023-02-28 17:22:50','',''),('1','311',1175,'','6.1','4',0.00,3600.00,'Retail Sale Id 642 for retail product','2023-02-28 17:22:50','',''),('1','311',1176,'','20','3',7200.00,0.00,'Retail Sale Id 643 for 10.00 KG of Cooking Gas @ N720.00','2023-02-28 17:24:21','',''),('1','311',1177,'','6.1','4',0.00,7200.00,'Retail Sale Id 643 for retail product','2023-02-28 17:24:21','',''),('1','311',1178,'','20','3',5040.00,0.00,'Retail Sale Id 644 for 7.00 KG of Cooking Gas @ N720.00','2023-02-28 17:26:25','',''),('1','311',1179,'','6.1','4',0.00,5040.00,'Retail Sale Id 644 for retail product','2023-02-28 17:26:25','',''),('1','311',1180,'','20','3',7200.00,0.00,'Retail Sale Id 645 for 10.00 KG of Cooking Gas @ N720.00','2023-02-28 17:27:38','',''),('1','311',1181,'','6.1','4',0.00,7200.00,'Retail Sale Id 645 for retail product','2023-02-28 17:27:38','',''),('1','311',1182,'','20','3',5000.00,0.00,'Retail Sale Id 647 for 6.94 KG of Cooking Gas @ N720.00','2023-02-28 17:34:07','',''),('1','311',1183,'','6.1','4',0.00,5000.00,'Retail Sale Id 647 for retail product','2023-02-28 17:34:07','',''),('1','311',1184,'','20','3',5040.00,0.00,'Retail Sale Id 648 for 7.00 KG of Cooking Gas @ N720.00','2023-02-28 17:35:12','',''),('1','311',1185,'','6.1','4',0.00,5040.00,'Retail Sale Id 648 for retail product','2023-02-28 17:35:12','',''),('1','311',1186,'','6.1','4',0.00,5040.00,'Retail Sale Id 648 for retail product','2023-02-28 17:35:12','',''),('1','311',1187,'','20','3',4000.00,0.00,'Retail Sale Id 649 for 5.56 KG of Cooking Gas @ N720.00','2023-02-28 17:36:19','',''),('1','311',1188,'','6.1','4',0.00,4000.00,'Retail Sale Id 649 for retail product','2023-02-28 17:36:19','',''),('1','311',1189,'','20','3',1440.00,0.00,'Retail Sale Id 650 for 2.00 KG of Cooking Gas @ N720.00','2023-02-28 17:37:58','',''),('1','311',1190,'','6.1','4',0.00,1440.00,'Retail Sale Id 650 for retail product','2023-02-28 17:37:58','',''),('1','311',1191,'','20','3',7920.00,0.00,'Retail Sale Id 651 for 11.00 KG of Cooking Gas @ N720.00','2023-02-28 17:39:52','',''),('1','311',1192,'','6.1','4',0.00,7920.00,'Retail Sale Id 651 for retail product','2023-02-28 17:39:52','',''),('1','311',1193,'','20','3',2160.00,0.00,'Retail Sale Id 652 for 3.00 KG of Cooking Gas @ N720.00','2023-02-28 17:43:17','',''),('1','311',1194,'','6.1','4',0.00,2160.00,'Retail Sale Id 652 for retail product','2023-02-28 17:43:17','',''),('1','311',1195,'','20','3',3600.00,0.00,'Retail Sale Id 653 for 5.00 KG of Cooking Gas @ N720.00','2023-02-28 17:45:35','',''),('1','311',1196,'','6.1','4',0.00,3600.00,'Retail Sale Id 653 for retail product','2023-02-28 17:45:35','',''),('1','311',1197,'','20','3',1000.00,0.00,'Retail Sale Id 654 for 1.39 KG of Cooking Gas @ N720.00','2023-02-28 17:46:38','',''),('1','311',1198,'','6.1','4',0.00,1000.00,'Retail Sale Id 654 for retail product','2023-02-28 17:46:38','',''),('1','311',1199,'','20','3',3000.00,0.00,'Retail Sale Id 655 for 4.17 KG of Cooking Gas @ N720.00','2023-02-28 17:48:29','',''),('1','311',1200,'','6.1','4',0.00,3000.00,'Retail Sale Id 655 for retail product','2023-02-28 17:48:29','',''),('1','311',1201,'','20','3',3600.00,0.00,'Retail Sale Id 656 for 5.00 KG of Cooking Gas @ N720.00','2023-02-28 17:49:18','',''),('1','311',1202,'','6.1','4',0.00,3600.00,'Retail Sale Id 656 for retail product','2023-02-28 17:49:18','',''),('1','311',1203,'','20','3',1000.00,0.00,'Retail Sale Id 657 for 1.39 KG of Cooking Gas @ N720.00','2023-02-28 17:50:36','',''),('1','311',1204,'','6.1','4',0.00,1000.00,'Retail Sale Id 657 for retail product','2023-02-28 17:50:36','',''),('1','311',1205,'','20','3',3600.00,0.00,'Retail Sale Id 658 for 5.00 KG of Cooking Gas @ N720.00','2023-02-28 17:53:23','',''),('1','311',1206,'','6.1','4',0.00,3600.00,'Retail Sale Id 658 for retail product','2023-02-28 17:53:23','',''),('1','311',1207,'','20','3',3600.00,0.00,'Retail Sale Id 660 for 5.00 KG of Cooking Gas @ N720.00','2023-02-28 17:55:26','',''),('1','311',1208,'','6.1','4',0.00,3600.00,'Retail Sale Id 660 for retail product','2023-02-28 17:55:26','',''),('1','311',1209,'','20','3',750.00,0.00,'Retail Sale Id 661 for 1.04 KG of Cooking Gas @ N720.00','2023-02-28 17:57:10','',''),('1','311',1210,'','6.1','4',0.00,750.00,'Retail Sale Id 661 for retail product','2023-02-28 17:57:10','',''),('1','311',1211,'','6.1','4',0.00,750.00,'Retail Sale Id 661 for retail product','2023-02-28 17:57:10','',''),('1','311',1212,'','20','3',2160.00,0.00,'Retail Sale Id 662 for 3.00 KG of Cooking Gas @ N720.00','2023-02-28 17:58:50','',''),('1','311',1213,'','6.1','4',0.00,2160.00,'Retail Sale Id 662 for retail product','2023-02-28 17:58:50','',''),('1','311',1214,'','20','3',2160.00,0.00,'Retail Sale Id 663 for 3.00 KG of Cooking Gas @ N720.00','2023-02-28 18:03:01','',''),('1','311',1215,'','6.1','4',0.00,2160.00,'Retail Sale Id 663 for retail product','2023-02-28 18:03:01','',''),('1','311',1216,'','20','3',2500.00,0.00,'Retail Sale Id 664 for 3.47 KG of Cooking Gas @ N720.00','2023-02-28 18:05:07','',''),('1','311',1217,'','6.1','4',0.00,2500.00,'Retail Sale Id 664 for retail product','2023-02-28 18:05:07','',''),('1','311',1218,'','20','3',3600.00,0.00,'Retail Sale Id 665 for 5.00 KG of Cooking Gas @ N720.00','2023-02-28 18:06:37','',''),('1','311',1219,'','6.1','4',0.00,3600.00,'Retail Sale Id 665 for retail product','2023-02-28 18:06:37','',''),('1','311',1220,'','20','3',2160.00,0.00,'Retail Sale Id 666 for 3.00 KG of Cooking Gas @ N720.00','2023-02-28 18:08:17','',''),('1','311',1221,'','6.1','4',0.00,2160.00,'Retail Sale Id 666 for retail product','2023-02-28 18:08:17','',''),('1','311',1222,'','6.1','4',0.00,2160.00,'Retail Sale Id 666 for retail product','2023-02-28 18:08:17','',''),('1','311',1223,'','20','3',8640.00,0.00,'Retail Sale Id 667 for 12.00 KG of Cooking Gas @ N720.00','2023-02-28 18:12:03','',''),('1','311',1224,'','6.1','4',0.00,8640.00,'Retail Sale Id 667 for retail product','2023-02-28 18:12:03','',''),('1','311',1225,'','20','3',1440.00,0.00,'Retail Sale Id 669 for 2.00 KG of Cooking Gas @ N720.00','2023-02-28 18:15:25','',''),('1','311',1226,'','6.1','4',0.00,1440.00,'Retail Sale Id 669 for retail product','2023-02-28 18:15:25','',''),('1','311',1227,'','20','3',2160.00,0.00,'Retail Sale Id 671 for 3.00 KG of Cooking Gas @ N720.00','2023-02-28 18:16:36','',''),('1','311',1228,'','6.1','4',0.00,2160.00,'Retail Sale Id 671 for retail product','2023-02-28 18:16:36','',''),('1','311',1229,'','20','3',3600.00,0.00,'Retail Sale Id 672 for 5.00 KG of Cooking Gas @ N720.00','2023-02-28 18:17:54','',''),('1','311',1230,'','6.1','4',0.00,3600.00,'Retail Sale Id 672 for retail product','2023-02-28 18:17:54','',''),('1','311',1231,'','20','3',1500.00,0.00,'Retail Sale Id 673 for 2.08 KG of Cooking Gas @ N720.00','2023-02-28 18:18:50','',''),('1','311',1232,'','6.1','4',0.00,1500.00,'Retail Sale Id 673 for retail product','2023-02-28 18:18:50','',''),('1','311',1233,'','20','3',2000.00,0.00,'Retail Sale Id 674 for 2.78 KG of Cooking Gas @ N720.00','2023-02-28 18:21:53','',''),('1','311',1234,'','6.1','4',0.00,2000.00,'Retail Sale Id 674 for retail product','2023-02-28 18:21:53','',''),('1','311',1235,'','20','3',2500.00,0.00,'Retail Sale Id 675 for 3.47 KG of Cooking Gas @ N720.00','2023-02-28 18:23:34','',''),('1','311',1236,'','6.1','4',0.00,2500.00,'Retail Sale Id 675 for retail product','2023-02-28 18:23:34','',''),('1','311',1237,'','20','3',9000.00,0.00,'Retail Sale Id 676 for 12.50 KG of Cooking Gas @ N720.00','2023-02-28 18:27:08','',''),('1','311',1238,'','6.1','4',0.00,9000.00,'Retail Sale Id 676 for retail product','2023-02-28 18:27:08','',''),('1','311',1239,'','20','3',3600.00,0.00,'Retail Sale Id 677 for 5.00 KG of Cooking Gas @ N720.00','2023-02-28 18:32:05','',''),('1','311',1240,'','6.1','4',0.00,3600.00,'Retail Sale Id 677 for retail product','2023-02-28 18:32:05','',''),('1','311',1241,'','20','3',2160.00,0.00,'Retail Sale Id 678 for 3.00 KG of Cooking Gas @ N720.00','2023-02-28 18:36:20','',''),('1','311',1242,'','6.1','4',0.00,2160.00,'Retail Sale Id 678 for retail product','2023-02-28 18:36:20','',''),('1','311',1243,'','20','3',0.00,9000.00,'Return of Retail Sale Id 676 for products','2023-02-28 20:44:22','',''),('1','311',1244,'','','',9000.00,0.00,'Return of Retail Sale Id 676 for products','2023-02-28 20:44:22','',''),('1','311',1245,'','20','3',3411.99,0.00,'Retail Sale Id 679 for 4.74 KG of Cooking Gas @ N720.00','2023-02-28 20:45:25','',''),('1','311',1246,'','6.1','4',0.00,3411.99,'Retail Sale Id 679 for retail product','2023-02-28 20:45:25','',''),('1','311',1247,'','20','3',0.00,8640.00,'Return of Retail Sale Id 667 for products','2023-02-28 20:54:00','',''),('1','311',1248,'','','',8640.00,0.00,'Return of Retail Sale Id 667 for products','2023-02-28 20:54:00','',''),('1','311',1249,'','20','3',2685.60,0.00,'Retail Sale Id 680 for 3.73 KG of Cooking Gas @ N720.00','2023-02-28 20:56:07','',''),('1','311',1250,'','6.1','4',0.00,2685.60,'Retail Sale Id 680 for retail product','2023-02-28 20:56:07','',''),('1','311',1251,'','20','3',0.00,2685.60,'Return of Retail Sale Id 680 for products','2023-02-28 20:58:06','',''),('1','311',1252,'','','',2685.60,0.00,'Return of Retail Sale Id 680 for products','2023-02-28 20:58:06','',''),('1','311',1253,'','20','3',2685.62,0.00,'Retail Sale Id 681 for 3.73 KG of Cooking Gas @ N720.00','2023-02-28 20:59:07','',''),('1','311',1254,'','6.1','4',0.00,2685.62,'Retail Sale Id 681 for retail product','2023-02-28 20:59:07','',''),('1','311',1255,'','20','3',5940.00,0.00,'Retail Sale Id 682 for 8.25 KG of Cooking Gas @ N720.00','2023-02-28 21:01:34','',''),('1','311',1256,'','6.1','4',0.00,5940.00,'Retail Sale Id 682 for retail product','2023-02-28 21:01:34','',''),('1','311',1257,'','20','3',0.00,2685.62,'Return of Retail Sale Id 681 for products','2023-02-28 21:03:46','',''),('1','311',1258,'','','',2685.62,0.00,'Return of Retail Sale Id 681 for products','2023-02-28 21:03:46','',''),('1','311',1259,'','20','3',2685.60,0.00,'Retail Sale Id 683 for 3.73 KG of Cooking Gas @ N720.00','2023-02-28 21:04:29','',''),('1','311',1260,'','6.1','4',0.00,2685.60,'Retail Sale Id 683 for retail product','2023-02-28 21:04:29','',''),('1','311',1261,'','20','3',0.00,0.00,'Sales from shift 16 on 2023-02-28 21:06:52 ','2023-02-28 21:06:52','',''),('1','311',1262,'','6.1','4',0.00,0.00,'Sales from shift 16 on 2023-02-28 21:06:52 ','2023-02-28 21:06:52','',''),('1','311',1263,'','20','3',2160.00,0.00,'Retail Sale Id 684 for 3.00 KG of Cooking Gas @ N720.00','2023-03-01 08:17:12','',''),('1','311',1264,'','6.1','4',0.00,2160.00,'Retail Sale Id 684 for retail product','2023-03-01 08:17:12','',''),('1','311',1265,'','20','3',3600.00,0.00,'Retail Sale Id 685 for 5.00 KG of Cooking Gas @ N720.00','2023-03-01 08:18:20','',''),('1','311',1266,'','6.1','4',0.00,3600.00,'Retail Sale Id 685 for retail product','2023-03-01 08:18:20','',''),('1','311',1267,'','20','3',3600.00,0.00,'Retail Sale Id 686 for 5.00 KG of Cooking Gas @ N720.00','2023-03-01 08:31:36','',''),('1','311',1268,'','6.1','4',0.00,3600.00,'Retail Sale Id 686 for retail product','2023-03-01 08:31:36','',''),('1','311',1269,'','20','3',5040.00,0.00,'Retail Sale Id 688 for 7.00 KG of Cooking Gas @ N720.00','2023-03-01 08:33:22','',''),('1','311',1270,'','6.1','4',0.00,5040.00,'Retail Sale Id 688 for retail product','2023-03-01 08:33:22','',''),('1','311',1271,'','20','3',2500.00,0.00,'Retail Sale Id 689 for 3.47 KG of Cooking Gas @ N720.00','2023-03-01 08:59:38','',''),('1','311',1272,'','6.1','4',0.00,2500.00,'Retail Sale Id 689 for retail product','2023-03-01 08:59:38','',''),('1','311',1273,'','20','3',0.00,2500.00,'Return of Retail Sale Id 689 for products','2023-03-01 09:03:25','',''),('1','311',1274,'','','',2500.00,0.00,'Return of Retail Sale Id 689 for products','2023-03-01 09:03:25','',''),('1','311',1275,'','20','3',3600.00,0.00,'Retail Sale Id 690 for 5.00 KG of Cooking Gas @ N720.00','2023-03-01 09:04:17','',''),('1','311',1276,'','6.1','4',0.00,3600.00,'Retail Sale Id 690 for retail product','2023-03-01 09:04:17','',''),('1','311',1277,'','20','3',4320.00,0.00,'Retail Sale Id 691 for 6.00 KG of Cooking Gas @ N720.00','2023-03-01 09:11:15','',''),('1','311',1278,'','6.1','4',0.00,4320.00,'Retail Sale Id 691 for retail product','2023-03-01 09:11:15','',''),('1','311',1279,'','20','3',9000.00,0.00,'Retail Sale Id 692 for 12.50 KG of Cooking Gas @ N720.00','2023-03-01 09:14:26','',''),('1','311',1280,'','6.1','4',0.00,9000.00,'Retail Sale Id 692 for retail product','2023-03-01 09:14:26','',''),('1','311',1281,'','20','3',2000.00,0.00,'Retail Sale Id 693 for 2.78 KG of Cooking Gas @ N720.00','2023-03-01 09:53:44','',''),('1','311',1282,'','6.1','4',0.00,2000.00,'Retail Sale Id 693 for retail product','2023-03-01 09:53:44','',''),('1','311',1283,'','20','3',1440.00,0.00,'Retail Sale Id 694 for 2.00 KG of Cooking Gas @ N720.00','2023-03-01 10:01:04','',''),('1','311',1284,'','6.1','4',0.00,1440.00,'Retail Sale Id 694 for retail product','2023-03-01 10:01:04','',''),('1','311',1285,'','20','3',5040.00,0.00,'Retail Sale Id 695 for 7.00 KG of Cooking Gas @ N720.00','2023-03-01 10:02:00','',''),('1','311',1286,'','6.1','4',0.00,5040.00,'Retail Sale Id 695 for retail product','2023-03-01 10:02:00','',''),('1','311',1287,'','20','3',9000.00,0.00,'Retail Sale Id 696 for 12.50 KG of Cooking Gas @ N720.00','2023-03-01 10:05:41','',''),('1','311',1288,'','6.1','4',0.00,9000.00,'Retail Sale Id 696 for retail product','2023-03-01 10:05:41','',''),('1','311',1289,'','20','3',750.00,0.00,'Retail Sale Id 697 for 1.04 KG of Cooking Gas @ N720.00','2023-03-01 10:07:09','',''),('1','311',1290,'','6.1','4',0.00,750.00,'Retail Sale Id 697 for retail product','2023-03-01 10:07:09','',''),('1','311',1291,'','20','3',4320.00,0.00,'Retail Sale Id 698 for 6.00 KG of Cooking Gas @ N720.00','2023-03-01 10:20:44','',''),('1','311',1292,'','6.1','4',0.00,4320.00,'Retail Sale Id 698 for retail product','2023-03-01 10:20:44','',''),('1','311',1293,'','20','3',4320.00,0.00,'Retail Sale Id 699 for 6.00 KG of Cooking Gas @ N720.00','2023-03-01 10:24:28','',''),('1','311',1294,'','6.1','4',0.00,4320.00,'Retail Sale Id 699 for retail product','2023-03-01 10:24:28','',''),('1','311',1295,'','20','3',0.00,4320.00,'Return of Retail Sale Id 699 for products','2023-03-01 10:31:20','',''),('1','311',1296,'','','',4320.00,0.00,'Return of Retail Sale Id 699 for products','2023-03-01 10:31:20','',''),('1','311',1297,'','20','3',5040.00,0.00,'Retail Sale Id 701 for 7.00 KG of Cooking Gas @ N720.00','2023-03-01 10:33:40','',''),('1','311',1298,'','6.1','4',0.00,5040.00,'Retail Sale Id 701 for retail product','2023-03-01 10:33:40','',''),('1','311',1299,'','20','3',1500.00,0.00,'Retail Sale Id 702 for 2.08 KG of Cooking Gas @ N720.00','2023-03-01 10:35:01','',''),('1','311',1300,'','6.1','4',0.00,1500.00,'Retail Sale Id 702 for retail product','2023-03-01 10:35:01','',''),('1','311',1301,'','20','3',9000.00,0.00,'Retail Sale Id 703 for 12.50 KG of Cooking Gas @ N720.00','2023-03-01 10:35:56','',''),('1','311',1302,'','6.1','4',0.00,9000.00,'Retail Sale Id 703 for retail product','2023-03-01 10:35:56','',''),('1','311',1303,'','20','3',2500.00,0.00,'Retail Sale Id 704 for 3.47 KG of Cooking Gas @ N720.00','2023-03-01 10:53:06','',''),('1','311',1304,'','6.1','4',0.00,2500.00,'Retail Sale Id 704 for retail product','2023-03-01 10:53:06','',''),('1','311',1305,'','20','3',3600.00,0.00,'Retail Sale Id 705 for 5.00 KG of Cooking Gas @ N720.00','2023-03-01 10:56:41','',''),('1','311',1306,'','6.1','4',0.00,3600.00,'Retail Sale Id 705 for retail product','2023-03-01 10:56:41','',''),('1','311',1307,'','20','3',6000.00,0.00,'Retail Sale Id 706 for 8.33 KG of Cooking Gas @ N720.00','2023-03-01 10:58:59','',''),('1','311',1308,'','6.1','4',0.00,6000.00,'Retail Sale Id 706 for retail product','2023-03-01 10:58:59','',''),('1','311',1309,'','6.1','4',0.00,6000.00,'Retail Sale Id 706 for retail product','2023-03-01 10:58:59','',''),('1','311',1310,'','20','3',3000.00,0.00,'Retail Sale Id 707 for 4.17 KG of Cooking Gas @ N720.00','2023-03-01 11:01:57','',''),('1','311',1311,'','6.1','4',0.00,3000.00,'Retail Sale Id 707 for retail product','2023-03-01 11:01:57','',''),('1','311',1312,'','20','3',4320.00,0.00,'Retail Sale Id 708 for 6.00 KG of Cooking Gas @ N720.00','2023-03-01 11:03:38','',''),('1','311',1313,'','6.1','4',0.00,4320.00,'Retail Sale Id 708 for retail product','2023-03-01 11:03:38','',''),('1','311',1314,'','20','3',2000.00,0.00,'Retail Sale Id 709 for 2.78 KG of Cooking Gas @ N720.00','2023-03-01 11:04:47','',''),('1','311',1315,'','6.1','4',0.00,2000.00,'Retail Sale Id 709 for retail product','2023-03-01 11:04:47','',''),('1','311',1316,'','20','3',3500.00,0.00,'Retail Sale Id 711 for 4.86 KG of Cooking Gas @ N720.00','2023-03-01 11:07:35','',''),('1','311',1317,'','6.1','4',0.00,3500.00,'Retail Sale Id 711 for retail product','2023-03-01 11:07:35','',''),('1','311',1318,'','20','3',1440.00,0.00,'Retail Sale Id 712 for 2.00 KG of Cooking Gas @ N720.00','2023-03-01 11:23:40','',''),('1','311',1319,'','6.1','4',0.00,1440.00,'Retail Sale Id 712 for retail product','2023-03-01 11:23:40','',''),('1','311',1320,'','20','3',7000.00,0.00,'Retail Sale Id 713 for multiple products','2023-03-01 11:29:16','',''),('1','311',1321,'','6.1','4',0.00,7000.00,'Retail Sale Id 713 for retail product','2023-03-01 11:29:16','',''),('1','311',1322,'','20','3',1000.00,0.00,'Retail Sale Id 714 for 1.39 KG of Cooking Gas @ N720.00','2023-03-01 11:30:57','',''),('1','311',1323,'','6.1','4',0.00,1000.00,'Retail Sale Id 714 for retail product','2023-03-01 11:30:57','',''),('1','311',1324,'','20','3',2160.00,0.00,'Retail Sale Id 715 for 3.00 KG of Cooking Gas @ N720.00','2023-03-01 12:03:00','',''),('1','311',1325,'','6.1','4',0.00,2160.00,'Retail Sale Id 715 for retail product','2023-03-01 12:03:00','',''),('1','311',1326,'','20','3',2880.00,0.00,'Retail Sale Id 716 for 4.00 KG of Cooking Gas @ N720.00','2023-03-01 12:17:03','',''),('1','311',1327,'','6.1','4',0.00,2880.00,'Retail Sale Id 716 for retail product','2023-03-01 12:17:03','',''),('1','311',1328,'','20','3',2000.00,0.00,'Retail Sale Id 717 for 2.78 KG of Cooking Gas @ N720.00','2023-03-01 12:18:18','',''),('1','311',1329,'','6.1','4',0.00,2000.00,'Retail Sale Id 717 for retail product','2023-03-01 12:18:18','',''),('1','311',1330,'','20','3',720.00,0.00,'Retail Sale Id 718 for 1.00 KG of Cooking Gas @ N720.00','2023-03-01 12:24:37','',''),('1','311',1331,'','6.1','4',0.00,720.00,'Retail Sale Id 718 for retail product','2023-03-01 12:24:37','',''),('1','311',1332,'','20','3',3600.00,0.00,'Retail Sale Id 719 for 5.00 KG of Cooking Gas @ N720.00','2023-03-01 12:39:37','',''),('1','311',1333,'','6.1','4',0.00,3600.00,'Retail Sale Id 719 for retail product','2023-03-01 12:39:37','',''),('1','311',1334,'','20','3',7920.00,0.00,'Retail Sale Id 720 for 11.00 KG of Cooking Gas @ N720.00','2023-03-01 12:41:50','',''),('1','311',1335,'','6.1','4',0.00,7920.00,'Retail Sale Id 720 for retail product','2023-03-01 12:41:50','',''),('1','311',1336,'','20','3',3000.00,0.00,'Retail Sale Id 721 for 4.17 KG of Cooking Gas @ N720.00','2023-03-01 12:56:23','',''),('1','311',1337,'','6.1','4',0.00,3000.00,'Retail Sale Id 721 for retail product','2023-03-01 12:56:24','',''),('1','311',1338,'','20','3',2000.00,0.00,'Retail Sale Id 722 for 2.78 KG of Cooking Gas @ N720.00','2023-03-01 12:57:23','',''),('1','311',1339,'','6.1','4',0.00,2000.00,'Retail Sale Id 722 for retail product','2023-03-01 12:57:23','',''),('1','311',1340,'','20','3',5040.00,0.00,'Retail Sale Id 723 for 7.00 KG of Cooking Gas @ N720.00','2023-03-01 12:58:06','',''),('1','311',1341,'','6.1','4',0.00,5040.00,'Retail Sale Id 723 for retail product','2023-03-01 12:58:06','',''),('1','311',1342,'','20','3',2880.00,0.00,'Retail Sale Id 724 for 4.00 KG of Cooking Gas @ N720.00','2023-03-01 13:10:37','',''),('1','311',1343,'','6.1','4',0.00,2880.00,'Retail Sale Id 724 for retail product','2023-03-01 13:10:37','',''),('1','311',1344,'','20','3',2160.00,0.00,'Retail Sale Id 725 for 3.00 KG of Cooking Gas @ N720.00','2023-03-01 13:19:18','',''),('1','311',1345,'','6.1','4',0.00,2160.00,'Retail Sale Id 725 for retail product','2023-03-01 13:19:18','',''),('1','311',1346,'','20','3',2160.00,0.00,'Retail Sale Id 726 for 3.00 KG of Cooking Gas @ N720.00','2023-03-01 13:27:52','',''),('1','311',1347,'','6.1','4',0.00,2160.00,'Retail Sale Id 726 for retail product','2023-03-01 13:27:52','',''),('1','311',1348,'','20','3',1000.00,0.00,'Retail Sale Id 727 for 1.39 KG of Cooking Gas @ N720.00','2023-03-01 13:34:12','',''),('1','311',1349,'','6.1','4',0.00,1000.00,'Retail Sale Id 727 for retail product','2023-03-01 13:34:12','',''),('1','311',1350,'','20','3',5320.00,0.00,'Retail Sale Id 728 for 7.39 KG of Cooking Gas @ N720.00','2023-03-01 13:36:13','',''),('1','311',1351,'','6.1','4',0.00,5320.00,'Retail Sale Id 728 for retail product','2023-03-01 13:36:13','',''),('1','311',1352,'','20','3',0.00,5320.00,'Return of Retail Sale Id 728 for products','2023-03-01 13:36:56','',''),('1','311',1353,'','','',5320.00,0.00,'Return of Retail Sale Id 728 for products','2023-03-01 13:36:56','',''),('1','311',1354,'','20','3',4320.00,0.00,'Retail Sale Id 729 for 6.00 KG of Cooking Gas @ N720.00','2023-03-01 13:37:37','',''),('1','311',1355,'','6.1','4',0.00,4320.00,'Retail Sale Id 729 for retail product','2023-03-01 13:37:37','',''),('1','311',1356,'','20','3',1000.00,0.00,'Retail Sale Id 730 for 1.39 KG of Cooking Gas @ N720.00','2023-03-01 13:40:24','',''),('1','311',1357,'','6.1','4',0.00,1000.00,'Retail Sale Id 730 for retail product','2023-03-01 13:40:24','',''),('1','311',1358,'','20','3',9000.00,0.00,'Retail Sale Id 731 for 12.50 KG of Cooking Gas @ N720.00','2023-03-01 13:57:05','',''),('1','311',1359,'','6.1','4',0.00,9000.00,'Retail Sale Id 731 for retail product','2023-03-01 13:57:06','',''),('1','311',1360,'','20','3',5040.00,0.00,'Retail Sale Id 732 for 7.00 KG of Cooking Gas @ N720.00','2023-03-01 13:58:51','',''),('1','311',1361,'','6.1','4',0.00,5040.00,'Retail Sale Id 732 for retail product','2023-03-01 13:58:51','',''),('1','311',1362,'','20','3',1800.00,0.00,'Retail Sale Id 733 for 2.50 KG of Cooking Gas @ N720.00','2023-03-01 14:06:02','',''),('1','311',1363,'','6.1','4',0.00,1800.00,'Retail Sale Id 733 for retail product','2023-03-01 14:06:02','',''),('1','311',1364,'','20','3',1500.00,0.00,'Retail Sale Id 734 for 2.08 KG of Cooking Gas @ N720.00','2023-03-01 14:20:11','',''),('1','311',1365,'','6.1','4',0.00,1500.00,'Retail Sale Id 734 for retail product','2023-03-01 14:20:11','',''),('1','311',1366,'','20','3',4320.00,0.00,'Retail Sale Id 736 for 6.00 KG of Cooking Gas @ N720.00','2023-03-01 14:23:38','',''),('1','311',1367,'','6.1','4',0.00,4320.00,'Retail Sale Id 736 for retail product','2023-03-01 14:23:38','',''),('1','311',1368,'','20','3',4147.20,0.00,'Retail Sale Id 737 for 5.76 KG of Cooking Gas @ N720.00','2023-03-01 14:24:53','',''),('1','311',1369,'','6.1','4',0.00,4147.20,'Retail Sale Id 737 for retail product','2023-03-01 14:24:53','',''),('1','311',1370,'','20','3',2880.00,0.00,'Retail Sale Id 738 for 4.00 KG of Cooking Gas @ N720.00','2023-03-01 14:25:58','',''),('1','311',1371,'','6.1','4',0.00,2880.00,'Retail Sale Id 738 for retail product','2023-03-01 14:25:58','',''),('1','311',1372,'','2','15',16400.00,0.00,'Payment Id 22 for invoice:6, receipt: 0017 by AA RANO NIGERIA LTD','2023-03-01 14:28:28','',''),('1','311',1373,'','supplier','1',0.00,16400.00,'Payment Id 22 for invoice:6, receipt: 0017 by AA RANO NIGERIA LTD','2023-03-01 14:28:28','',''),('1','311',1374,'','20','3',3600.00,0.00,'Retail Sale Id 739 for 5.00 KG of Cooking Gas @ N720.00','2023-03-01 14:29:12','',''),('1','311',1375,'','6.1','4',0.00,3600.00,'Retail Sale Id 739 for retail product','2023-03-01 14:29:12','',''),('1','311',1376,'','2','9',32210.00,0.00,'Payment Id 24 for invoice:7, receipt: 0018 by AA RANO NIGERIA LTD','2023-03-01 14:30:25','',''),('1','311',1377,'','supplier','1',0.00,32210.00,'Payment Id 24 for invoice:7, receipt: 0018 by AA RANO NIGERIA LTD','2023-03-01 14:30:25','',''),('1','311',1378,'','2','15',13898.00,0.00,'Payment Id 23 for invoice:7, receipt: 0017 by AA RANO NIGERIA LTD','2023-03-01 14:30:25','',''),('1','311',1379,'','supplier','1',0.00,13898.00,'Payment Id 23 for invoice:7, receipt: 0017 by AA RANO NIGERIA LTD','2023-03-01 14:30:25','',''),('1','311',1380,'','2','9',53500.00,0.00,'Payment Id 20 for invoice:8, receipt: 0016 by AA RANO NIGERIA LTD','2023-03-01 14:32:06','',''),('1','311',1381,'','supplier','1',0.00,53500.00,'Payment Id 20 for invoice:8, receipt: 0016 by AA RANO NIGERIA LTD','2023-03-01 14:32:06','',''),('1','311',1382,'','2','9',2881.00,0.00,'Payment Id 21 for invoice:12, receipt: 0014 by AA RANO NIGERIA LTD','2023-03-01 14:34:59','',''),('1','311',1383,'','supplier','1',0.00,2881.00,'Payment Id 21 for invoice:12, receipt: 0014 by AA RANO NIGERIA LTD','2023-03-01 14:34:59','',''),('1','311',1384,'','2','14',177328.80,0.00,'Payment Id 16 for invoice:12, receipt: UBA by AA RANO NIGERIA LTD','2023-03-01 14:34:59','',''),('1','311',1385,'','supplier','1',0.00,177328.80,'Payment Id 16 for invoice:12, receipt: UBA by AA RANO NIGERIA LTD','2023-03-01 14:34:59','',''),('1','311',1386,'','2','20',143840.00,0.00,'Payment Id 27 for invoice:13, receipt: 0021 by AA RANO NIGERIA LTD','2023-03-01 14:36:36','',''),('1','311',1387,'','supplier','1',0.00,143840.00,'Payment Id 27 for invoice:13, receipt: 0021 by AA RANO NIGERIA LTD','2023-03-01 14:36:36','',''),('1','311',1388,'','20','3',8640.00,0.00,'Retail Sale Id 741 for 12.00 KG of Cooking Gas @ N720.00','2023-03-01 14:39:14','',''),('1','311',1389,'','6.1','4',0.00,8640.00,'Retail Sale Id 741 for retail product','2023-03-01 14:39:14','',''),('1','311',1390,'','2','20',235080.00,0.00,'Payment Id 34 for invoice:15, receipt: 0026 by AA RANO NIGERIA LTD','2023-03-01 14:41:36','',''),('1','311',1391,'','supplier','1',0.00,235080.00,'Payment Id 34 for invoice:15, receipt: 0026 by AA RANO NIGERIA LTD','2023-03-01 14:41:36','',''),('1','311',1392,'','2','9',20520.00,0.00,'Payment Id 33 for invoice:15, receipt: 0025 by AA RANO NIGERIA LTD','2023-03-01 14:41:36','',''),('1','311',1393,'','supplier','1',0.00,20520.00,'Payment Id 33 for invoice:15, receipt: 0025 by AA RANO NIGERIA LTD','2023-03-01 14:41:36','',''),('1','311',1394,'','20','3',3600.00,0.00,'Retail Sale Id 742 for 5.00 KG of Cooking Gas @ N720.00','2023-03-01 14:44:14','',''),('1','311',1395,'','6.1','4',0.00,3600.00,'Retail Sale Id 742 for retail product','2023-03-01 14:44:14','',''),('1','311',1396,'','20','3',7200.00,0.00,'Retail Sale Id 743 for multiple products','2023-03-01 14:49:50','',''),('1','311',1397,'','6.1','4',0.00,7200.00,'Retail Sale Id 743 for retail product','2023-03-01 14:49:50','',''),('1','311',1398,'','2','20',122060.00,0.00,'Payment Id 31 for invoice:14, receipt: 0024 by AA RANO NIGERIA LTD','2023-03-01 14:57:11','',''),('1','311',1399,'','supplier','1',0.00,122060.00,'Payment Id 31 for invoice:14, receipt: 0024 by AA RANO NIGERIA LTD','2023-03-01 14:57:11','',''),('1','311',1400,'','2','9',30560.00,0.00,'Payment Id 29 for invoice:14, receipt: 0023 by AA RANO NIGERIA LTD','2023-03-01 14:57:11','',''),('1','311',1401,'','supplier','1',0.00,30560.00,'Payment Id 29 for invoice:14, receipt: 0023 by AA RANO NIGERIA LTD','2023-03-01 14:57:11','',''),('1','311',1402,'','20','3',9000.00,0.00,'Retail Sale Id 744 for 12.50 KG of Cooking Gas @ N720.00','2023-03-01 14:58:24','',''),('1','311',1403,'','6.1','4',0.00,9000.00,'Retail Sale Id 744 for retail product','2023-03-01 14:58:24','',''),('1','311',1404,'','2','9',25220.00,0.00,'Payment Id 26 for invoice:13, receipt: 0020 by AA RANO NIGERIA LTD','2023-03-01 15:00:00','',''),('1','311',1405,'','supplier','1',0.00,25220.00,'Payment Id 26 for invoice:13, receipt: 0020 by AA RANO NIGERIA LTD','2023-03-01 15:00:00','',''),('1','311',1406,'','20','3',9000.00,0.00,'Retail Sale Id 745 for 12.50 KG of Cooking Gas @ N720.00','2023-03-01 15:01:47','',''),('1','311',1407,'','6.1','4',0.00,9000.00,'Retail Sale Id 745 for retail product','2023-03-01 15:01:47','',''),('1','311',1408,'','20','3',1440.00,0.00,'Retail Sale Id 746 for 2.00 KG of Cooking Gas @ N720.00','2023-03-01 15:08:24','',''),('1','311',1409,'','6.1','4',0.00,1440.00,'Retail Sale Id 746 for retail product','2023-03-01 15:08:24','',''),('1','311',1410,'','20','3',2160.00,0.00,'Retail Sale Id 747 for 3.00 KG of Cooking Gas @ N720.00','2023-03-01 15:14:54','',''),('1','311',1411,'','6.1','4',0.00,2160.00,'Retail Sale Id 747 for retail product','2023-03-01 15:14:54','',''),('1','311',1412,'','20','3',4000.00,0.00,'Retail Sale Id 748 for 5.56 KG of Cooking Gas @ N720.00','2023-03-01 15:33:17','',''),('1','311',1413,'','6.1','4',0.00,4000.00,'Retail Sale Id 748 for retail product','2023-03-01 15:33:17','',''),('1','311',1414,'','20','3',6480.00,0.00,'Retail Sale Id 750 for multiple products','2023-03-01 15:36:42','',''),('1','311',1415,'','6.1','4',0.00,6480.00,'Retail Sale Id 750 for retail product','2023-03-01 15:36:42','',''),('1','311',1416,'','20','3',2880.00,0.00,'Retail Sale Id 751 for 4.00 KG of Cooking Gas @ N720.00','2023-03-01 15:38:31','',''),('1','311',1417,'','6.1','4',0.00,2880.00,'Retail Sale Id 751 for retail product','2023-03-01 15:38:31','',''),('1','311',1418,'','20','3',2500.00,0.00,'Retail Sale Id 752 for 3.47 KG of Cooking Gas @ N720.00','2023-03-01 15:39:58','',''),('1','311',1419,'','6.1','4',0.00,2500.00,'Retail Sale Id 752 for retail product','2023-03-01 15:39:58','',''),('1','311',1420,'','20','3',1500.00,0.00,'Retail Sale Id 754 for 2.08 KG of Cooking Gas @ N720.00','2023-03-01 16:02:22','',''),('1','311',1421,'','6.1','4',0.00,1500.00,'Retail Sale Id 754 for retail product','2023-03-01 16:02:22','',''),('1','311',1422,'','20','3',1400.00,0.00,'Retail Sale Id 757 for 1.94 KG of Cooking Gas @ N720.00','2023-03-01 16:09:28','',''),('1','311',1423,'','6.1','4',0.00,1400.00,'Retail Sale Id 757 for retail product','2023-03-01 16:09:28','',''),('1','311',1424,'','20','3',4320.00,0.00,'Retail Sale Id 758 for 6.00 KG of Cooking Gas @ N720.00','2023-03-01 16:32:05','',''),('1','311',1425,'','6.1','4',0.00,4320.00,'Retail Sale Id 758 for retail product','2023-03-01 16:32:05','',''),('1','311',1426,'','20','3',3600.00,0.00,'Retail Sale Id 759 for 5.00 KG of Cooking Gas @ N720.00','2023-03-01 17:13:43','',''),('1','311',1427,'','6.1','4',0.00,3600.00,'Retail Sale Id 759 for retail product','2023-03-01 17:13:43','',''),('1','311',1428,'','20','3',1440.00,0.00,'Retail Sale Id 760 for 2.00 KG of Cooking Gas @ N720.00','2023-03-01 17:21:55','',''),('1','311',1429,'','6.1','4',0.00,1440.00,'Retail Sale Id 760 for retail product','2023-03-01 17:21:55','',''),('1','311',1430,'','20','3',9000.00,0.00,'Retail Sale Id 761 for 12.50 KG of Cooking Gas @ N720.00','2023-03-01 17:27:16','',''),('1','311',1431,'','6.1','4',0.00,9000.00,'Retail Sale Id 761 for retail product','2023-03-01 17:27:16','',''),('1','311',1432,'','20','3',9000.00,0.00,'Retail Sale Id 762 for 12.50 KG of Cooking Gas @ N720.00','2023-03-01 17:36:41','',''),('1','311',1433,'','6.1','4',0.00,9000.00,'Retail Sale Id 762 for retail product','2023-03-01 17:36:41','',''),('1','311',1434,'','20','3',0.00,9000.00,'Return of Retail Sale Id 762 for products','2023-03-01 17:37:23','',''),('1','311',1435,'','','',9000.00,0.00,'Return of Retail Sale Id 762 for products','2023-03-01 17:37:23','',''),('1','311',1436,'','20','3',9000.00,0.00,'Retail Sale Id 763 for 12.50 KG of Cooking Gas @ N720.00','2023-03-01 17:37:59','',''),('1','311',1437,'','6.1','4',0.00,9000.00,'Retail Sale Id 763 for retail product','2023-03-01 17:37:59','',''),('1','311',1438,'','20','3',2160.00,0.00,'Retail Sale Id 764 for 3.00 KG of Cooking Gas @ N720.00','2023-03-01 17:40:11','',''),('1','311',1439,'','6.1','4',0.00,2160.00,'Retail Sale Id 764 for retail product','2023-03-01 17:40:11','',''),('1','311',1440,'','20','3',0.00,2160.00,'Return of Retail Sale Id 764 for products','2023-03-01 20:30:33','',''),('1','311',1441,'','','',2160.00,0.00,'Return of Retail Sale Id 764 for products','2023-03-01 20:30:33','',''),('1','311',1442,'','20','3',0.00,1440.00,'Return of Retail Sale Id 746 for products','2023-03-01 20:35:04','',''),('1','311',1443,'','','',1440.00,0.00,'Return of Retail Sale Id 746 for products','2023-03-01 20:35:04','',''),('1','311',1444,'','20','3',1440.08,0.00,'Retail Sale Id 765 for 2.00 KG of Cooking Gas @ N720.00','2023-03-01 20:36:05','',''),('1','311',1445,'','6.1','4',0.00,1440.08,'Retail Sale Id 765 for retail product','2023-03-01 20:36:05','',''),('1','311',1446,'','20','3',0.00,9000.00,'Return of Retail Sale Id 763 for products','2023-03-01 20:39:32','',''),('1','311',1447,'','','',9000.00,0.00,'Return of Retail Sale Id 763 for products','2023-03-01 20:39:32','',''),('1','311',1448,'','20','3',0.00,1400.00,'Return of Retail Sale Id 757 for products','2023-03-01 20:43:32','',''),('1','311',1449,'','','',1400.00,0.00,'Return of Retail Sale Id 757 for products','2023-03-01 20:43:32','',''),('1','311',1450,'','20','3',1346.72,0.00,'Retail Sale Id 766 for 1.87 KG of Cooking Gas @ N720.00','2023-03-01 20:44:44','',''),('1','311',1451,'','6.1','4',0.00,1346.72,'Retail Sale Id 766 for retail product','2023-03-01 20:44:44','',''),('1','311',1452,'','20','3',0.00,0.00,'Sales from shift 17 on 2023-03-01 20:46:19 ','2023-03-01 20:46:19','',''),('1','311',1453,'','6.1','4',0.00,0.00,'Sales from shift 17 on 2023-03-01 20:46:19 ','2023-03-01 20:46:19','',''),('1','311',1454,'','20','3',9000.00,0.00,'Retail Sale Id 767 for 12.50 KG of Cooking Gas @ N720.00','2023-03-02 08:07:21','',''),('1','311',1455,'','6.1','4',0.00,9000.00,'Retail Sale Id 767 for retail product','2023-03-02 08:07:21','',''),('1','311',1456,'','20','3',5040.00,0.00,'Retail Sale Id 768 for 7.00 KG of Cooking Gas @ N720.00','2023-03-02 08:09:34','',''),('1','311',1457,'','6.1','4',0.00,5040.00,'Retail Sale Id 768 for retail product','2023-03-02 08:09:34','',''),('1','311',1458,'','20','3',8640.00,0.00,'Retail Sale Id 770 for multiple products','2023-03-02 08:13:15','',''),('1','311',1459,'','6.1','4',0.00,8640.00,'Retail Sale Id 770 for retail product','2023-03-02 08:13:15','',''),('1','311',1460,'','20','3',1440.00,0.00,'Retail Sale Id 771 for 2.00 KG of Cooking Gas @ N720.00','2023-03-02 08:17:09','',''),('1','311',1461,'','6.1','4',0.00,1440.00,'Retail Sale Id 771 for retail product','2023-03-02 08:17:09','',''),('1','311',1462,'','20','3',4680.00,0.00,'Retail Sale Id 772 for 6.50 KG of Cooking Gas @ N720.00','2023-03-02 08:25:46','',''),('1','311',1463,'','6.1','4',0.00,4680.00,'Retail Sale Id 772 for retail product','2023-03-02 08:25:46','',''),('1','311',1464,'','20','3',9000.00,0.00,'Retail Sale Id 773 for 12.50 KG of Cooking Gas @ N720.00','2023-03-02 08:38:50','',''),('1','311',1465,'','6.1','4',0.00,9000.00,'Retail Sale Id 773 for retail product','2023-03-02 08:38:50','',''),('1','311',1466,'','20','3',3000.00,0.00,'Retail Sale Id 774 for 4.17 KG of Cooking Gas @ N720.00','2023-03-02 08:45:16','',''),('1','311',1467,'','6.1','4',0.00,3000.00,'Retail Sale Id 774 for retail product','2023-03-02 08:45:16','',''),('1','311',1468,'','20','3',1500.00,0.00,'Retail Sale Id 776 for 2.08 KG of Cooking Gas @ N720.00','2023-03-02 08:56:24','',''),('1','311',1469,'','6.1','4',0.00,1500.00,'Retail Sale Id 776 for retail product','2023-03-02 08:56:24','',''),('1','311',1470,'','20','3',1500.00,0.00,'Retail Sale Id 777 for 2.08 KG of Cooking Gas @ N720.00','2023-03-02 08:57:55','',''),('1','311',1471,'','6.1','4',0.00,1500.00,'Retail Sale Id 777 for retail product','2023-03-02 08:57:55','',''),('1','311',1472,'','20','3',720.00,0.00,'Retail Sale Id 778 for 1.00 KG of Cooking Gas @ N720.00','2023-03-02 09:00:12','',''),('1','311',1473,'','6.1','4',0.00,720.00,'Retail Sale Id 778 for retail product','2023-03-02 09:00:12','',''),('1','311',1474,'','20','3',5040.00,0.00,'Retail Sale Id 779 for 7.00 KG of Cooking Gas @ N720.00','2023-03-02 09:10:09','',''),('1','311',1475,'','6.1','4',0.00,5040.00,'Retail Sale Id 779 for retail product','2023-03-02 09:10:09','',''),('1','311',1476,'','20','3',9000.00,0.00,'Retail Sale Id 780 for 12.50 KG of Cooking Gas @ N720.00','2023-03-02 09:11:32','',''),('1','311',1477,'','6.1','4',0.00,9000.00,'Retail Sale Id 780 for retail product','2023-03-02 09:11:32','',''),('1','311',1478,'','20','3',3000.00,0.00,'Retail Sale Id 781 for 4.17 KG of Cooking Gas @ N720.00','2023-03-02 09:12:38','',''),('1','311',1479,'','6.1','4',0.00,3000.00,'Retail Sale Id 781 for retail product','2023-03-02 09:12:38','',''),('1','311',1480,'','20','3',4320.00,0.00,'Retail Sale Id 782 for 6.00 KG of Cooking Gas @ N720.00','2023-03-02 09:18:00','',''),('1','311',1481,'','6.1','4',0.00,4320.00,'Retail Sale Id 782 for retail product','2023-03-02 09:18:00','',''),('1','311',1482,'','20','3',2160.00,0.00,'Retail Sale Id 783 for 3.00 KG of Cooking Gas @ N720.00','2023-03-02 09:24:30','',''),('1','311',1483,'','6.1','4',0.00,2160.00,'Retail Sale Id 783 for retail product','2023-03-02 09:24:30','',''),('1','311',1484,'','20','3',2000.00,0.00,'Retail Sale Id 784 for 2.78 KG of Cooking Gas @ N720.00','2023-03-02 09:35:08','',''),('1','311',1485,'','6.1','4',0.00,2000.00,'Retail Sale Id 784 for retail product','2023-03-02 09:35:08','',''),('1','311',1486,'','20','3',4320.00,0.00,'Retail Sale Id 785 for 6.00 KG of Cooking Gas @ N720.00','2023-03-02 09:36:09','',''),('1','311',1487,'','6.1','4',0.00,4320.00,'Retail Sale Id 785 for retail product','2023-03-02 09:36:09','',''),('1','311',1488,'','20','3',2880.00,0.00,'Retail Sale Id 786 for 4.00 KG of Cooking Gas @ N720.00','2023-03-02 09:38:13','',''),('1','311',1489,'','6.1','4',0.00,2880.00,'Retail Sale Id 786 for retail product','2023-03-02 09:38:14','',''),('1','311',1490,'','20','3',2200.00,0.00,'Retail Sale Id 788 for 3.06 KG of Cooking Gas @ N720.00','2023-03-02 09:49:03','',''),('1','311',1491,'','6.1','4',0.00,2200.00,'Retail Sale Id 788 for retail product','2023-03-02 09:49:03','',''),('1','311',1492,'','20','3',800.00,0.00,'Retail Sale Id 789 for 1.11 KG of Cooking Gas @ N720.00','2023-03-02 09:58:05','',''),('1','311',1493,'','6.1','4',0.00,800.00,'Retail Sale Id 789 for retail product','2023-03-02 09:58:05','',''),('1','311',1494,'','20','3',2160.00,0.00,'Retail Sale Id 790 for 3.00 KG of Cooking Gas @ N720.00','2023-03-02 10:02:05','',''),('1','311',1495,'','6.1','4',0.00,2160.00,'Retail Sale Id 790 for retail product','2023-03-02 10:02:06','',''),('1','311',1496,'','20','3',7200.00,0.00,'Retail Sale Id 791 for 10.00 KG of Cooking Gas @ N720.00','2023-03-02 10:11:03','',''),('1','311',1497,'','6.1','4',0.00,7200.00,'Retail Sale Id 791 for retail product','2023-03-02 10:11:03','',''),('1','311',1498,'','20','3',8000.00,0.00,'Retail Sale Id 792 for 11.11 KG of Cooking Gas @ N720.00','2023-03-02 10:14:46','',''),('1','311',1499,'','6.1','4',0.00,8000.00,'Retail Sale Id 792 for retail product','2023-03-02 10:14:46','',''),('1','311',1500,'','20','3',0.00,8000.00,'Return of Retail Sale Id 792 for products','2023-03-02 10:16:13','',''),('1','311',1501,'','','',8000.00,0.00,'Return of Retail Sale Id 792 for products','2023-03-02 10:16:13','',''),('1','311',1502,'','20','3',800.00,0.00,'Retail Sale Id 793 for 1.11 KG of Cooking Gas @ N720.00','2023-03-02 10:16:49','',''),('1','311',1503,'','6.1','4',0.00,800.00,'Retail Sale Id 793 for retail product','2023-03-02 10:16:49','',''),('1','311',1504,'','20','3',9000.00,0.00,'Retail Sale Id 795 for 12.50 KG of Cooking Gas @ N720.00','2023-03-02 10:49:42','',''),('1','311',1505,'','6.1','4',0.00,9000.00,'Retail Sale Id 795 for retail product','2023-03-02 10:49:42','',''),('1','311',1506,'','20','3',5600.00,0.00,'Retail Sale Id 797 for multiple products','2023-03-02 12:33:37','',''),('1','311',1507,'','6.1','4',0.00,5600.00,'Retail Sale Id 797 for retail product','2023-03-02 12:33:37','',''),('1','311',1508,'','20','3',2940.00,0.00,'Retail Sale Id 798 for multiple products','2023-03-02 12:37:24','',''),('1','311',1509,'','6.1','4',0.00,2940.00,'Retail Sale Id 798 for retail product','2023-03-02 12:37:24','',''),('1','311',1510,'','20','3',10080.00,0.00,'Retail Sale Id 800 for multiple products','2023-03-02 12:58:53','',''),('1','311',1511,'','6.1','4',0.00,10080.00,'Retail Sale Id 800 for retail product','2023-03-02 12:58:53','',''),('1','311',1512,'','20','3',1000.00,0.00,'Retail Sale Id 801 for 1.39 KG of Cooking Gas @ N720.00','2023-03-02 13:04:37','',''),('1','311',1513,'','6.1','4',0.00,1000.00,'Retail Sale Id 801 for retail product','2023-03-02 13:04:37','',''),('1','311',1514,'','20','3',7200.00,0.00,'Retail Sale Id 803 for 10.00 KG of Cooking Gas @ N720.00','2023-03-02 13:32:05','',''),('1','311',1515,'','6.1','4',0.00,7200.00,'Retail Sale Id 803 for retail product','2023-03-02 13:32:05','',''),('1','311',1516,'','20','3',9000.00,0.00,'Retail Sale Id 804 for 12.50 KG of Cooking Gas @ N720.00','2023-03-02 13:34:01','',''),('1','311',1517,'','6.1','4',0.00,9000.00,'Retail Sale Id 804 for retail product','2023-03-02 13:34:01','',''),('1','311',1518,'','20','3',2160.00,0.00,'Retail Sale Id 805 for 3.00 KG of Cooking Gas @ N720.00','2023-03-02 13:46:56','',''),('1','311',1519,'','6.1','4',0.00,2160.00,'Retail Sale Id 805 for retail product','2023-03-02 13:46:56','',''),('1','311',1520,'','20','3',7200.00,0.00,'Retail Sale Id 806 for 10.00 KG of Cooking Gas @ N720.00','2023-03-02 13:47:41','',''),('1','311',1521,'','6.1','4',0.00,7200.00,'Retail Sale Id 806 for retail product','2023-03-02 13:47:41','',''),('1','311',1522,'','20','3',1500.00,0.00,'Retail Sale Id 807 for 2.08 KG of Cooking Gas @ N720.00','2023-03-02 15:22:15','',''),('1','311',1523,'','6.1','4',0.00,1500.00,'Retail Sale Id 807 for retail product','2023-03-02 15:22:15','',''),('1','311',1524,'','20','3',1440.00,0.00,'Retail Sale Id 808 for 2.00 KG of Cooking Gas @ N720.00','2023-03-02 15:24:43','',''),('1','311',1525,'','6.1','4',0.00,1440.00,'Retail Sale Id 808 for retail product','2023-03-02 15:24:43','',''),('1','311',1526,'','20','3',2250.00,0.00,'Retail Sale Id 809 for multiple products','2023-03-02 15:27:39','',''),('1','311',1527,'','6.1','4',0.00,2250.00,'Retail Sale Id 809 for retail product','2023-03-02 15:27:39','',''),('1','311',1528,'','20','3',3600.00,0.00,'Retail Sale Id 810 for 5.00 KG of Cooking Gas @ N720.00','2023-03-02 15:31:24','',''),('1','311',1529,'','6.1','4',0.00,3600.00,'Retail Sale Id 810 for retail product','2023-03-02 15:31:24','',''),('1','311',1530,'','2','20',538180.00,0.00,'Payment Id 37 for invoice:16, receipt: 0027 by AA RANO NIGERIA LTD','2023-03-02 16:32:34','',''),('1','311',1531,'','supplier','1',0.00,538180.00,'Payment Id 37 for invoice:16, receipt: 0027 by AA RANO NIGERIA LTD','2023-03-02 16:32:34','',''),('1','311',1532,'','2','9',12921.00,0.00,'Payment Id 36 for invoice:16, receipt: 0026 by AA RANO NIGERIA LTD','2023-03-02 16:32:34','',''),('1','311',1533,'','supplier','1',0.00,12921.00,'Payment Id 36 for invoice:16, receipt: 0026 by AA RANO NIGERIA LTD','2023-03-02 16:32:34','',''),('1','311',1534,'','20','3',9220.00,0.00,'Retail Sale Id 823 for multiple products','2023-03-02 16:49:59','',''),('1','311',1535,'','6.1','4',0.00,9220.00,'Retail Sale Id 823 for retail product','2023-03-02 16:49:59','',''),('1','311',1536,'','20','3',3600.00,0.00,'Retail Sale Id 824 for 5.00 KG of Cooking Gas @ N720.00','2023-03-02 16:50:45','',''),('1','311',1537,'','6.1','4',0.00,3600.00,'Retail Sale Id 824 for retail product','2023-03-02 16:50:45','',''),('1','311',1538,'','20','3',4400.00,0.00,'Retail Sale Id 826 for multiple products','2023-03-02 16:53:58','',''),('1','311',1539,'','6.1','4',0.00,4400.00,'Retail Sale Id 826 for retail product','2023-03-02 16:53:58','',''),('1','311',1540,'','20','3',1500.00,0.00,'Retail Sale Id 827 for 2.08 KG of Cooking Gas @ N720.00','2023-03-02 16:57:06','',''),('1','311',1541,'','6.1','4',0.00,1500.00,'Retail Sale Id 827 for retail product','2023-03-02 16:57:06','',''),('1','311',1542,'','20','3',1500.00,0.00,'Retail Sale Id 828 for 2.08 KG of Cooking Gas @ N720.00','2023-03-02 17:00:35','',''),('1','311',1543,'','6.1','4',0.00,1500.00,'Retail Sale Id 828 for retail product','2023-03-02 17:00:35','',''),('1','311',1544,'','20','3',600.00,0.00,'Retail Sale Id 829 for 0.83 KG of Cooking Gas @ N720.00','2023-03-02 17:11:13','',''),('1','311',1545,'','6.1','4',0.00,600.00,'Retail Sale Id 829 for retail product','2023-03-02 17:11:13','',''),('1','311',1546,'','20','3',2880.00,0.00,'Retail Sale Id 831 for 4.00 KG of Cooking Gas @ N720.00','2023-03-02 17:18:45','',''),('1','311',1547,'','6.1','4',0.00,2880.00,'Retail Sale Id 831 for retail product','2023-03-02 17:18:45','',''),('1','311',1548,'','20','3',2880.00,0.00,'Retail Sale Id 832 for 4.00 KG of Cooking Gas @ N720.00','2023-03-02 17:22:05','',''),('1','311',1549,'','6.1','4',0.00,2880.00,'Retail Sale Id 832 for retail product','2023-03-02 17:22:05','',''),('1','311',1550,'','20','3',9000.00,0.00,'Retail Sale Id 833 for 12.50 KG of Cooking Gas @ N720.00','2023-03-02 17:32:01','',''),('1','311',1551,'','6.1','4',0.00,9000.00,'Retail Sale Id 833 for retail product','2023-03-02 17:32:01','',''),('1','311',1552,'','20','3',0.00,9000.00,'Return of Retail Sale Id 833 for products','2023-03-02 19:36:51','',''),('1','311',1553,'','','',9000.00,0.00,'Return of Retail Sale Id 833 for products','2023-03-02 19:36:51','',''),('1','311',1554,'','20','3',0.00,2880.00,'Return of Retail Sale Id 831 for products','2023-03-02 19:38:30','',''),('1','311',1555,'','','',2880.00,0.00,'Return of Retail Sale Id 831 for products','2023-03-02 19:38:30','',''),('1','311',1556,'','20','3',0.00,4400.00,'Return of Retail Sale Id 826 for products','2023-03-02 19:42:58','',''),('1','311',1557,'','','',4400.00,0.00,'Return of Retail Sale Id 826 for products','2023-03-02 19:42:58','',''),('1','311',1558,'','20','3',0.00,2880.00,'Return of Retail Sale Id 832 for products','2023-03-02 19:45:08','',''),('1','311',1559,'','','',2880.00,0.00,'Return of Retail Sale Id 832 for products','2023-03-02 19:45:08','',''),('1','311',1560,'','20','3',0.00,3600.00,'Return of Retail Sale Id 824 for products','2023-03-02 19:48:35','',''),('1','311',1561,'','','',3600.00,0.00,'Return of Retail Sale Id 824 for products','2023-03-02 19:48:35','',''),('1','311',1562,'','20','3',3010.40,0.00,'Retail Sale Id 834 for 4.18 KG of Cooking Gas @ N720.00','2023-03-02 19:49:36','',''),('1','311',1563,'','6.1','4',0.00,3010.40,'Retail Sale Id 834 for retail product','2023-03-02 19:49:36','',''),('1','311',1564,'','20','3',0.00,600.00,'Return of Retail Sale Id 829 for products','2023-03-02 19:52:46','',''),('1','311',1565,'','','',600.00,0.00,'Return of Retail Sale Id 829 for products','2023-03-02 19:52:46','',''),('1','311',1566,'','20','3',0.00,1500.00,'Return of Retail Sale Id 828 for products','2023-03-02 19:53:29','',''),('1','311',1567,'','','',1500.00,0.00,'Return of Retail Sale Id 828 for products','2023-03-02 19:53:29','',''),('1','311',1568,'','20','3',0.00,1500.00,'Return of Retail Sale Id 827 for products','2023-03-02 19:56:12','',''),('1','311',1569,'','','',1500.00,0.00,'Return of Retail Sale Id 827 for products','2023-03-02 19:56:12','',''),('1','311',1570,'','20','3',2138.40,0.00,'Retail Sale Id 835 for 2.97 KG of Cooking Gas @ N720.00','2023-03-02 19:56:57','',''),('1','311',1571,'','6.1','4',0.00,2138.40,'Retail Sale Id 835 for retail product','2023-03-02 19:56:57','',''),('1','311',1572,'','20','3',9000.00,0.00,'Retail Sale Id 836 for 12.50 KG of Cooking Gas @ N720.00','2023-03-02 20:00:03','',''),('1','311',1573,'','6.1','4',0.00,9000.00,'Retail Sale Id 836 for retail product','2023-03-02 20:00:03','',''),('1','311',1574,'','20','3',9000.00,0.00,'Retail Sale Id 837 for 12.50 KG of Cooking Gas @ N720.00','2023-03-02 20:00:35','',''),('1','311',1575,'','6.1','4',0.00,9000.00,'Retail Sale Id 837 for retail product','2023-03-02 20:00:35','',''),('1','311',1576,'','20','3',3456.00,0.00,'Retail Sale Id 838 for 4.80 KG of Cooking Gas @ N720.00','2023-03-02 20:01:25','',''),('1','311',1577,'','6.1','4',0.00,3456.00,'Retail Sale Id 838 for retail product','2023-03-02 20:01:25','',''),('1','311',1578,'','20','3',0.00,0.00,'Sales from shift 18 on 2023-03-02 20:03:14 ','2023-03-02 20:03:14','',''),('1','311',1579,'','6.1','4',0.00,0.00,'Sales from shift 18 on 2023-03-02 20:03:14 ','2023-03-02 20:03:14','',''),('1','311',1580,'','20','3',2160.00,0.00,'Retail Sale Id 839 for 3.00 KG of Cooking Gas @ N720.00','2023-03-03 10:00:58','',''),('1','311',1581,'','6.1','4',0.00,2160.00,'Retail Sale Id 839 for retail product','2023-03-03 10:00:58','',''),('1','311',1582,'','20','3',1440.00,0.00,'Retail Sale Id 840 for 2.00 KG of Cooking Gas @ N720.00','2023-03-03 10:05:44','',''),('1','311',1583,'','6.1','4',0.00,1440.00,'Retail Sale Id 840 for retail product','2023-03-03 10:05:44','',''),('1','311',1584,'','20','3',720.00,0.00,'Retail Sale Id 841 for 1.00 KG of Cooking Gas @ N720.00','2023-03-03 10:13:39','',''),('1','311',1585,'','6.1','4',0.00,720.00,'Retail Sale Id 841 for retail product','2023-03-03 10:13:39','',''),('1','311',1586,'','20','3',1440.00,0.00,'Retail Sale Id 843 for 2.00 KG of Cooking Gas @ N720.00','2023-03-03 10:34:45','',''),('1','311',1587,'','6.1','4',0.00,1440.00,'Retail Sale Id 843 for retail product','2023-03-03 10:34:45','',''),('1','311',1588,'','20','3',7200.00,0.00,'Retail Sale Id 844 for 10.00 KG of Cooking Gas @ N720.00','2023-03-03 10:52:44','',''),('1','311',1589,'','6.1','4',0.00,7200.00,'Retail Sale Id 844 for retail product','2023-03-03 10:52:44','',''),('1','311',1590,'','20','3',1500.00,0.00,'Retail Sale Id 845 for 2.08 KG of Cooking Gas @ N720.00','2023-03-03 11:30:47','',''),('1','311',1591,'','6.1','4',0.00,1500.00,'Retail Sale Id 845 for retail product','2023-03-03 11:30:47','',''),('1','311',1592,'','20','3',4320.00,0.00,'Retail Sale Id 846 for 6.00 KG of Cooking Gas @ N720.00','2023-03-03 11:36:33','',''),('1','311',1593,'','6.1','4',0.00,4320.00,'Retail Sale Id 846 for retail product','2023-03-03 11:36:33','',''),('1','311',1594,'','20','3',2160.00,0.00,'Retail Sale Id 847 for 3.00 KG of Cooking Gas @ N720.00','2023-03-03 12:06:59','',''),('1','311',1595,'','6.1','4',0.00,2160.00,'Retail Sale Id 847 for retail product','2023-03-03 12:06:59','',''),('1','311',1596,'','20','3',3600.00,0.00,'Retail Sale Id 848 for 5.00 KG of Cooking Gas @ N720.00','2023-03-03 12:08:32','',''),('1','311',1597,'','6.1','4',0.00,3600.00,'Retail Sale Id 848 for retail product','2023-03-03 12:08:32','',''),('1','311',1598,'','20','3',7920.00,0.00,'Retail Sale Id 849 for multiple products','2023-03-03 12:14:23','',''),('1','311',1599,'','6.1','4',0.00,7920.00,'Retail Sale Id 849 for retail product','2023-03-03 12:14:23','',''),('1','311',1600,'','20','3',720.00,0.00,'Retail Sale Id 850 for 1.00 KG of Cooking Gas @ N720.00','2023-03-03 12:22:19','',''),('1','311',1601,'','6.1','4',0.00,720.00,'Retail Sale Id 850 for retail product','2023-03-03 12:22:19','',''),('1','311',1602,'','20','3',1440.00,0.00,'Retail Sale Id 851 for 2.00 KG of Cooking Gas @ N720.00','2023-03-03 12:26:37','',''),('1','311',1603,'','6.1','4',0.00,1440.00,'Retail Sale Id 851 for retail product','2023-03-03 12:26:37','',''),('1','311',1604,'','20','3',3600.00,0.00,'Retail Sale Id 852 for 5.00 KG of Cooking Gas @ N720.00','2023-03-03 12:59:12','',''),('1','311',1605,'','6.1','4',0.00,3600.00,'Retail Sale Id 852 for retail product','2023-03-03 12:59:13','',''),('1','311',1606,'','20','3',2880.00,0.00,'Retail Sale Id 853 for 4.00 KG of Cooking Gas @ N720.00','2023-03-03 13:14:08','',''),('1','311',1607,'','6.1','4',0.00,2880.00,'Retail Sale Id 853 for retail product','2023-03-03 13:14:08','',''),('1','311',1608,'','20','3',3600.00,0.00,'Retail Sale Id 855 for 5.00 KG of Cooking Gas @ N720.00','2023-03-03 14:14:26','',''),('1','311',1609,'','6.1','4',0.00,3600.00,'Retail Sale Id 855 for retail product','2023-03-03 14:14:26','',''),('1','311',1610,'','20','3',9000.00,0.00,'Retail Sale Id 856 for 12.50 KG of Cooking Gas @ N720.00','2023-03-03 14:21:04','',''),('1','311',1611,'','6.1','4',0.00,9000.00,'Retail Sale Id 856 for retail product','2023-03-03 14:21:04','',''),('1','311',1612,'','20','3',2880.00,0.00,'Retail Sale Id 857 for 4.00 KG of Cooking Gas @ N720.00','2023-03-03 14:56:18','',''),('1','311',1613,'','6.1','4',0.00,2880.00,'Retail Sale Id 857 for retail product','2023-03-03 14:56:18','',''),('1','311',1614,'','20','3',3600.00,0.00,'Retail Sale Id 858 for 5.00 KG of Cooking Gas @ N720.00','2023-03-03 15:08:33','',''),('1','311',1615,'','6.1','4',0.00,3600.00,'Retail Sale Id 858 for retail product','2023-03-03 15:08:33','',''),('1','311',1616,'','20','3',4320.00,0.00,'Retail Sale Id 859 for 6.00 KG of Cooking Gas @ N720.00','2023-03-03 15:13:12','',''),('1','311',1617,'','6.1','4',0.00,4320.00,'Retail Sale Id 859 for retail product','2023-03-03 15:13:12','',''),('1','311',1618,'','20','3',4320.00,0.00,'Retail Sale Id 860 for 6.00 KG of Cooking Gas @ N720.00','2023-03-03 15:22:59','',''),('1','311',1619,'','6.1','4',0.00,4320.00,'Retail Sale Id 860 for retail product','2023-03-03 15:22:59','',''),('1','311',1620,'','20','3',9000.00,0.00,'Retail Sale Id 861 for 12.50 KG of Cooking Gas @ N720.00','2023-03-03 15:26:59','',''),('1','311',1621,'','6.1','4',0.00,9000.00,'Retail Sale Id 861 for retail product','2023-03-03 15:26:59','',''),('1','311',1622,'','20','3',1440.00,0.00,'Retail Sale Id 862 for 2.00 KG of Cooking Gas @ N720.00','2023-03-03 15:28:54','',''),('1','311',1623,'','6.1','4',0.00,1440.00,'Retail Sale Id 862 for retail product','2023-03-03 15:28:54','',''),('1','311',1624,'','20','3',9000.00,0.00,'Retail Sale Id 863 for 12.50 KG of Cooking Gas @ N720.00','2023-03-03 15:38:04','',''),('1','311',1625,'','6.1','4',0.00,9000.00,'Retail Sale Id 863 for retail product','2023-03-03 15:38:04','',''),('1','311',1626,'','20','3',2880.00,0.00,'Retail Sale Id 864 for 4.00 KG of Cooking Gas @ N720.00','2023-03-03 15:38:50','',''),('1','311',1627,'','6.1','4',0.00,2880.00,'Retail Sale Id 864 for retail product','2023-03-03 15:38:50','',''),('1','311',1628,'','20','3',2160.00,0.00,'Retail Sale Id 866 for 3.00 KG of Cooking Gas @ N720.00','2023-03-03 16:00:13','',''),('1','311',1629,'','6.1','4',0.00,2160.00,'Retail Sale Id 866 for retail product','2023-03-03 16:00:13','',''),('1','311',1630,'','20','3',4320.00,0.00,'Retail Sale Id 867 for 6.00 KG of Cooking Gas @ N720.00','2023-03-03 16:01:07','',''),('1','311',1631,'','6.1','4',0.00,4320.00,'Retail Sale Id 867 for retail product','2023-03-03 16:01:07','',''),('1','311',1632,'','20','3',1000.00,0.00,'Retail Sale Id 868 for 1.39 KG of Cooking Gas @ N720.00','2023-03-03 16:34:33','',''),('1','311',1633,'','6.1','4',0.00,1000.00,'Retail Sale Id 868 for retail product','2023-03-03 16:34:33','',''),('1','311',1634,'','20','3',720.00,0.00,'Retail Sale Id 869 for 1.00 KG of Cooking Gas @ N720.00','2023-03-03 16:44:19','',''),('1','311',1635,'','6.1','4',0.00,720.00,'Retail Sale Id 869 for retail product','2023-03-03 16:44:19','',''),('1','311',1636,'','20','3',4000.00,0.00,'Retail Sale Id 870 for 5.56 KG of Cooking Gas @ N720.00','2023-03-03 16:48:39','',''),('1','311',1637,'','6.1','4',0.00,4000.00,'Retail Sale Id 870 for retail product','2023-03-03 16:48:39','',''),('1','311',1638,'','20','3',5880.00,0.00,'Retail Sale Id 871 for multiple products','2023-03-03 17:37:49','',''),('1','311',1639,'','6.1','4',0.00,5880.00,'Retail Sale Id 871 for retail product','2023-03-03 17:37:49','',''),('1','311',1640,'','20','3',4360.00,0.00,'Retail Sale Id 872 for multiple products','2023-03-03 17:39:24','',''),('1','311',1641,'','6.1','4',0.00,4360.00,'Retail Sale Id 872 for retail product','2023-03-03 17:39:24','',''),('1','311',1642,'','20','3',2200.00,0.00,'Retail Sale Id 874 for 3.06 KG of Cooking Gas @ N720.00','2023-03-03 17:47:13','',''),('1','311',1643,'','6.1','4',0.00,2200.00,'Retail Sale Id 874 for retail product','2023-03-03 17:47:13','',''),('1','311',1644,'','20','3',9000.00,0.00,'Retail Sale Id 875 for 12.50 KG of Cooking Gas @ N720.00','2023-03-03 17:54:46','',''),('1','311',1645,'','6.1','4',0.00,9000.00,'Retail Sale Id 875 for retail product','2023-03-03 17:54:46','',''),('1','311',1646,'','20','3',0.00,720.00,'Return of Retail Sale Id 869 for products','2023-03-03 18:11:17','',''),('1','311',1647,'','','',720.00,0.00,'Return of Retail Sale Id 869 for products','2023-03-03 18:11:17','',''),('1','311',1648,'','20','3',957.60,0.00,'Retail Sale Id 876 for 1.33 KG of Cooking Gas @ N720.00','2023-03-03 18:12:03','',''),('1','311',1649,'','6.1','4',0.00,957.60,'Retail Sale Id 876 for retail product','2023-03-03 18:12:03','',''),('1','311',1650,'','20','3',0.00,2200.00,'Return of Retail Sale Id 874 for products','2023-03-03 18:14:51','',''),('1','311',1651,'','','',2200.00,0.00,'Return of Retail Sale Id 874 for products','2023-03-03 18:14:51','',''),('1','311',1652,'','20','3',1728.00,0.00,'Retail Sale Id 877 for 2.40 KG of Cooking Gas @ N720.00','2023-03-03 18:18:35','',''),('1','311',1653,'','6.1','4',0.00,1728.00,'Retail Sale Id 877 for retail product','2023-03-03 18:18:35','',''),('1','311',1654,'','20','3',0.00,0.00,'Sales from shift 19 on 2023-03-03 18:20:14 ','2023-03-03 18:20:14','',''),('1','311',1655,'','6.1','4',0.00,0.00,'Sales from shift 19 on 2023-03-03 18:20:14 ','2023-03-03 18:20:14','',''),('1','311',1656,'','20','3',7200.00,0.00,'Retail Sale Id 878 for 10.00 KG of Cooking Gas @ N720.00','2023-03-04 16:51:57','',''),('1','311',1657,'','6.1','4',0.00,7200.00,'Retail Sale Id 878 for retail product','2023-03-04 16:51:57','',''),('1','311',1658,'','20','3',2880.00,0.00,'Retail Sale Id 879 for 4.00 KG of Cooking Gas @ N720.00','2023-03-04 16:53:21','',''),('1','311',1659,'','6.1','4',0.00,2880.00,'Retail Sale Id 879 for retail product','2023-03-04 16:53:21','',''),('1','311',1660,'','20','3',2160.00,0.00,'Retail Sale Id 880 for 3.00 KG of Cooking Gas @ N720.00','2023-03-04 16:54:01','',''),('1','311',1661,'','6.1','4',0.00,2160.00,'Retail Sale Id 880 for retail product','2023-03-04 16:54:01','',''),('1','311',1662,'','20','3',4320.00,0.00,'Retail Sale Id 881 for 6.00 KG of Cooking Gas @ N720.00','2023-03-04 16:54:40','',''),('1','311',1663,'','6.1','4',0.00,4320.00,'Retail Sale Id 881 for retail product','2023-03-04 16:54:40','',''),('1','311',1664,'','20','3',2520.00,0.00,'Retail Sale Id 882 for 3.50 KG of Cooking Gas @ N720.00','2023-03-04 16:55:24','',''),('1','311',1665,'','6.1','4',0.00,2520.00,'Retail Sale Id 882 for retail product','2023-03-04 16:55:24','',''),('1','311',1666,'','20','3',1000.00,0.00,'Retail Sale Id 883 for 1.39 KG of Cooking Gas @ N720.00','2023-03-04 16:56:10','',''),('1','311',1667,'','6.1','4',0.00,1000.00,'Retail Sale Id 883 for retail product','2023-03-04 16:56:10','',''),('1','311',1668,'','20','3',2160.00,0.00,'Retail Sale Id 884 for 3.00 KG of Cooking Gas @ N720.00','2023-03-04 16:56:52','',''),('1','311',1669,'','6.1','4',0.00,2160.00,'Retail Sale Id 884 for retail product','2023-03-04 16:56:52','',''),('1','311',1670,'','20','3',4320.00,0.00,'Retail Sale Id 885 for 6.00 KG of Cooking Gas @ N720.00','2023-03-04 16:57:29','',''),('1','311',1671,'','6.1','4',0.00,4320.00,'Retail Sale Id 885 for retail product','2023-03-04 16:57:29','',''),('1','311',1672,'','20','3',2000.00,0.00,'Retail Sale Id 886 for 2.78 KG of Cooking Gas @ N720.00','2023-03-04 16:58:51','',''),('1','311',1673,'','6.1','4',0.00,2000.00,'Retail Sale Id 886 for retail product','2023-03-04 16:58:51','',''),('1','311',1674,'','20','3',1000.00,0.00,'Retail Sale Id 887 for 1.39 KG of Cooking Gas @ N720.00','2023-03-04 17:00:07','',''),('1','311',1675,'','6.1','4',0.00,1000.00,'Retail Sale Id 887 for retail product','2023-03-04 17:00:07','',''),('1','311',1676,'','20','3',5400.00,0.00,'Retail Sale Id 888 for 7.50 KG of Cooking Gas @ N720.00','2023-03-04 17:01:30','',''),('1','311',1677,'','6.1','4',0.00,5400.00,'Retail Sale Id 888 for retail product','2023-03-04 17:01:30','',''),('1','311',1678,'','20','3',3600.00,0.00,'Retail Sale Id 889 for 5.00 KG of Cooking Gas @ N720.00','2023-03-04 17:02:22','',''),('1','311',1679,'','6.1','4',0.00,3600.00,'Retail Sale Id 889 for retail product','2023-03-04 17:02:22','',''),('1','311',1680,'','20','3',3600.00,0.00,'Retail Sale Id 890 for 5.00 KG of Cooking Gas @ N720.00','2023-03-04 17:04:31','',''),('1','311',1681,'','6.1','4',0.00,3600.00,'Retail Sale Id 890 for retail product','2023-03-04 17:04:31','',''),('1','311',1682,'','6.1','4',0.00,3600.00,'Retail Sale Id 890 for retail product','2023-03-04 17:04:31','',''),('1','311',1683,'','20','3',3600.00,0.00,'Retail Sale Id 892 for 5.00 KG of Cooking Gas @ N720.00','2023-03-04 17:05:32','',''),('1','311',1684,'','6.1','4',0.00,3600.00,'Retail Sale Id 892 for retail product','2023-03-04 17:05:32','',''),('1','311',1685,'','20','3',3000.00,0.00,'Retail Sale Id 893 for 4.17 KG of Cooking Gas @ N720.00','2023-03-04 17:06:25','',''),('1','311',1686,'','6.1','4',0.00,3000.00,'Retail Sale Id 893 for retail product','2023-03-04 17:06:25','',''),('1','311',1687,'','20','3',2500.00,0.00,'Retail Sale Id 894 for 3.47 KG of Cooking Gas @ N720.00','2023-03-04 17:07:49','',''),('1','311',1688,'','6.1','4',0.00,2500.00,'Retail Sale Id 894 for retail product','2023-03-04 17:07:49','',''),('1','311',1689,'','20','3',600.00,0.00,'Retail Sale Id 895 for 0.83 KG of Cooking Gas @ N720.00','2023-03-04 17:08:53','',''),('1','311',1690,'','6.1','4',0.00,600.00,'Retail Sale Id 895 for retail product','2023-03-04 17:08:53','',''),('1','311',1691,'','20','3',7920.00,0.00,'Retail Sale Id 896 for 11.00 KG of Cooking Gas @ N720.00','2023-03-04 17:09:33','',''),('1','311',1692,'','6.1','4',0.00,7920.00,'Retail Sale Id 896 for retail product','2023-03-04 17:09:33','',''),('1','311',1693,'','20','3',4320.00,0.00,'Retail Sale Id 897 for 6.00 KG of Cooking Gas @ N720.00','2023-03-04 17:10:08','',''),('1','311',1694,'','6.1','4',0.00,4320.00,'Retail Sale Id 897 for retail product','2023-03-04 17:10:08','',''),('1','311',1695,'','20','3',4320.00,0.00,'Retail Sale Id 898 for 6.00 KG of Cooking Gas @ N720.00','2023-03-04 17:11:07','',''),('1','311',1696,'','6.1','4',0.00,4320.00,'Retail Sale Id 898 for retail product','2023-03-04 17:11:07','',''),('1','311',1697,'','20','3',3600.00,0.00,'Retail Sale Id 899 for 5.00 KG of Cooking Gas @ N720.00','2023-03-04 17:12:01','',''),('1','311',1698,'','6.1','4',0.00,3600.00,'Retail Sale Id 899 for retail product','2023-03-04 17:12:01','',''),('1','311',1699,'','20','3',9000.00,0.00,'Retail Sale Id 900 for 12.50 KG of Cooking Gas @ N720.00','2023-03-04 17:14:58','',''),('1','311',1700,'','6.1','4',0.00,9000.00,'Retail Sale Id 900 for retail product','2023-03-04 17:14:58','',''),('1','311',1701,'','20','3',3600.00,0.00,'Retail Sale Id 901 for 5.00 KG of Cooking Gas @ N720.00','2023-03-04 17:16:15','',''),('1','311',1702,'','6.1','4',0.00,3600.00,'Retail Sale Id 901 for retail product','2023-03-04 17:16:15','',''),('1','311',1703,'','20','3',1500.00,0.00,'Retail Sale Id 903 for 2.08 KG of Cooking Gas @ N720.00','2023-03-04 17:18:35','',''),('1','311',1704,'','6.1','4',0.00,1500.00,'Retail Sale Id 903 for retail product','2023-03-04 17:18:35','',''),('1','311',1705,'','20','3',13800.00,0.00,'Retail Sale Id 904 for multiple products','2023-03-04 17:21:07','',''),('1','311',1706,'','6.1','4',0.00,13800.00,'Retail Sale Id 904 for retail product','2023-03-04 17:21:07','',''),('1','311',1707,'','20','3',3600.00,0.00,'Retail Sale Id 905 for 5.00 KG of Cooking Gas @ N720.00','2023-03-04 17:23:10','',''),('1','311',1708,'','6.1','4',0.00,3600.00,'Retail Sale Id 905 for retail product','2023-03-04 17:23:10','',''),('1','311',1709,'','20','3',2880.00,0.00,'Retail Sale Id 906 for 4.00 KG of Cooking Gas @ N720.00','2023-03-04 17:24:30','',''),('1','311',1710,'','6.1','4',0.00,2880.00,'Retail Sale Id 906 for retail product','2023-03-04 17:24:30','',''),('1','311',1711,'','20','3',1440.00,0.00,'Retail Sale Id 907 for 2.00 KG of Cooking Gas @ N720.00','2023-03-04 17:25:09','',''),('1','311',1712,'','6.1','4',0.00,1440.00,'Retail Sale Id 907 for retail product','2023-03-04 17:25:09','',''),('1','311',1713,'','20','3',2160.00,0.00,'Retail Sale Id 908 for 3.00 KG of Cooking Gas @ N720.00','2023-03-04 17:26:22','',''),('1','311',1714,'','6.1','4',0.00,2160.00,'Retail Sale Id 908 for retail product','2023-03-04 17:26:22','',''),('1','311',1715,'','20','3',2000.00,0.00,'Retail Sale Id 909 for 2.78 KG of Cooking Gas @ N720.00','2023-03-04 17:27:09','',''),('1','311',1716,'','6.1','4',0.00,2000.00,'Retail Sale Id 909 for retail product','2023-03-04 17:27:09','',''),('1','311',1717,'','20','3',1000.00,0.00,'Retail Sale Id 910 for 1.39 KG of Cooking Gas @ N720.00','2023-03-04 17:27:51','',''),('1','311',1718,'','6.1','4',0.00,1000.00,'Retail Sale Id 910 for retail product','2023-03-04 17:27:51','',''),('1','311',1719,'','20','3',1000.00,0.00,'Retail Sale Id 911 for 1.39 KG of Cooking Gas @ N720.00','2023-03-04 17:28:52','',''),('1','311',1720,'','6.1','4',0.00,1000.00,'Retail Sale Id 911 for retail product','2023-03-04 17:28:52','',''),('1','311',1721,'','20','3',5040.00,0.00,'Retail Sale Id 912 for 7.00 KG of Cooking Gas @ N720.00','2023-03-04 17:29:49','',''),('1','311',1722,'','6.1','4',0.00,5040.00,'Retail Sale Id 912 for retail product','2023-03-04 17:29:49','',''),('1','311',1723,'','20','3',3000.00,0.00,'Retail Sale Id 913 for 4.17 KG of Cooking Gas @ N720.00','2023-03-04 17:30:42','',''),('1','311',1724,'','6.1','4',0.00,3000.00,'Retail Sale Id 913 for retail product','2023-03-04 17:30:42','',''),('1','311',1725,'','20','3',6500.00,0.00,'Retail Sale Id 914 for 9.03 KG of Cooking Gas @ N720.00','2023-03-04 17:31:55','',''),('1','311',1726,'','6.1','4',0.00,6500.00,'Retail Sale Id 914 for retail product','2023-03-04 17:31:55','',''),('1','311',1727,'','20','3',5160.00,0.00,'Retail Sale Id 915 for 7.17 KG of Cooking Gas @ N720.00','2023-03-04 17:32:41','',''),('1','311',1728,'','6.1','4',0.00,5160.00,'Retail Sale Id 915 for retail product','2023-03-04 17:32:41','',''),('1','311',1729,'','20','3',10800.00,0.00,'Retail Sale Id 916 for 15.00 KG of Cooking Gas @ N720.00','2023-03-04 17:35:01','',''),('1','311',1730,'','6.1','4',0.00,10800.00,'Retail Sale Id 916 for retail product','2023-03-04 17:35:01','',''),('1','311',1731,'','20','3',18000.00,0.00,'Retail Sale Id 917 for 25.00 KG of Cooking Gas @ N720.00','2023-03-04 17:36:00','',''),('1','311',1732,'','6.1','4',0.00,18000.00,'Retail Sale Id 917 for retail product','2023-03-04 17:36:00','',''),('1','311',1733,'','20','3',12600.00,0.00,'Retail Sale Id 918 for 17.50 KG of Cooking Gas @ N720.00','2023-03-04 17:36:57','',''),('1','311',1734,'','6.1','4',0.00,12600.00,'Retail Sale Id 918 for retail product','2023-03-04 17:36:57','',''),('1','311',1735,'','20','3',6500.00,0.00,'Retail Sale Id 919 for 9.03 KG of Cooking Gas @ N720.00','2023-03-04 17:37:41','',''),('1','311',1736,'','6.1','4',0.00,6500.00,'Retail Sale Id 919 for retail product','2023-03-04 17:37:41','',''),('1','311',1737,'','20','3',9360.00,0.00,'Retail Sale Id 920 for 13.00 KG of Cooking Gas @ N720.00','2023-03-04 17:38:17','',''),('1','311',1738,'','6.1','4',0.00,9360.00,'Retail Sale Id 920 for retail product','2023-03-04 17:38:17','',''),('1','311',1739,'','20','3',8950.00,0.00,'Retail Sale Id 921 for 12.43 KG of Cooking Gas @ N720.00','2023-03-04 17:39:03','',''),('1','311',1740,'','6.1','4',0.00,8950.00,'Retail Sale Id 921 for retail product','2023-03-04 17:39:03','',''),('1','311',1741,'','20','3',8640.00,0.00,'Retail Sale Id 922 for 12.00 KG of Cooking Gas @ N720.00','2023-03-04 17:39:38','',''),('1','311',1742,'','6.1','4',0.00,8640.00,'Retail Sale Id 922 for retail product','2023-03-04 17:39:38','',''),('1','311',1743,'','20','3',10144.80,0.00,'Retail Sale Id 924 for 14.09 KG of Cooking Gas @ N720.00','2023-03-04 17:41:49','',''),('1','311',1744,'','6.1','4',0.00,10144.80,'Retail Sale Id 924 for retail product','2023-03-04 17:41:49','',''),('1','311',1745,'','20','3',7350.00,0.00,'Retail Sale Id 925 for 10.21 KG of Cooking Gas @ N720.00','2023-03-04 17:42:26','',''),('1','311',1746,'','6.1','4',0.00,7350.00,'Retail Sale Id 925 for retail product','2023-03-04 17:42:26','',''),('1','311',1747,'','20','3',14630.00,0.00,'Retail Sale Id 926 for 20.32 KG of Cooking Gas @ N720.00','2023-03-04 17:43:32','',''),('1','311',1748,'','6.1','4',0.00,14630.00,'Retail Sale Id 926 for retail product','2023-03-04 17:43:32','',''),('1','311',1749,'','20','3',7920.00,0.00,'Retail Sale Id 927 for 11.00 KG of Cooking Gas @ N720.00','2023-03-04 17:50:03','',''),('1','311',1750,'','6.1','4',0.00,7920.00,'Retail Sale Id 927 for retail product','2023-03-04 17:50:03','',''),('1','311',1751,'','20','3',40800.00,0.00,'Retail Sale Id 928 for 60.00 KG of Cooking Gas @ N680.00','2023-03-04 18:04:28','',''),('1','311',1752,'','6.1','4',0.00,40800.00,'Retail Sale Id 928 for retail product','2023-03-04 18:04:28','',''),('1','311',1753,'','20','3',0.00,0.00,'Sales from shift 20 on 2023-03-04 22:31:01 ','2023-03-04 22:31:01','',''),('1','311',1754,'','6.1','4',0.00,0.00,'Sales from shift 20 on 2023-03-04 22:31:01 ','2023-03-04 22:31:01','',''),('1','311',1755,'','20','3',1440.00,0.00,'Retail Sale Id 929 for 2.00 KG of Cooking Gas @ N720.00','2023-03-05 08:24:48','',''),('1','311',1756,'','6.1','4',0.00,1440.00,'Retail Sale Id 929 for retail product','2023-03-05 08:24:48','',''),('1','311',1757,'','20','3',2160.00,0.00,'Retail Sale Id 930 for 3.00 KG of Cooking Gas @ N720.00','2023-03-05 08:26:08','',''),('1','311',1758,'','6.1','4',0.00,2160.00,'Retail Sale Id 930 for retail product','2023-03-05 08:26:08','',''),('1','311',1759,'','20','3',5040.00,0.00,'Retail Sale Id 931 for 7.00 KG of Cooking Gas @ N720.00','2023-03-05 08:35:34','',''),('1','311',1760,'','6.1','4',0.00,5040.00,'Retail Sale Id 931 for retail product','2023-03-05 08:35:34','',''),('1','311',1761,'','20','3',6480.00,0.00,'Retail Sale Id 932 for multiple products','2023-03-05 08:43:53','',''),('1','311',1762,'','6.1','4',0.00,6480.00,'Retail Sale Id 932 for retail product','2023-03-05 08:43:53','',''),('1','311',1763,'','20','3',0.00,6480.00,'Return of Retail Sale Id 932 for products','2023-03-05 08:50:39','',''),('1','311',1764,'','','',6480.00,0.00,'Return of Retail Sale Id 932 for products','2023-03-05 08:50:39','',''),('1','311',1765,'','20','3',6480.00,0.00,'Retail Sale Id 934 for multiple products','2023-03-05 08:52:13','',''),('1','311',1766,'','6.1','4',0.00,6480.00,'Retail Sale Id 934 for retail product','2023-03-05 08:52:13','',''),('1','311',1767,'','20','3',2000.00,0.00,'Retail Sale Id 935 for 2.78 KG of Cooking Gas @ N720.00','2023-03-05 08:56:59','',''),('1','311',1768,'','6.1','4',0.00,2000.00,'Retail Sale Id 935 for retail product','2023-03-05 08:56:59','',''),('1','311',1769,'','20','3',2880.00,0.00,'Retail Sale Id 936 for 4.00 KG of Cooking Gas @ N720.00','2023-03-05 09:03:52','',''),('1','311',1770,'','6.1','4',0.00,2880.00,'Retail Sale Id 936 for retail product','2023-03-05 09:03:52','',''),('1','311',1771,'','20','3',7200.00,0.00,'Retail Sale Id 937 for multiple products','2023-03-05 09:11:17','',''),('1','311',1772,'','6.1','4',0.00,7200.00,'Retail Sale Id 937 for retail product','2023-03-05 09:11:17','',''),('1','311',1773,'','20','3',2000.00,0.00,'Retail Sale Id 938 for 2.78 KG of Cooking Gas @ N720.00','2023-03-05 09:18:00','',''),('1','311',1774,'','6.1','4',0.00,2000.00,'Retail Sale Id 938 for retail product','2023-03-05 09:18:00','',''),('1','311',1775,'','20','3',2900.00,0.00,'Retail Sale Id 939 for 4.03 KG of Cooking Gas @ N720.00','2023-03-05 09:37:25','',''),('1','311',1776,'','6.1','4',0.00,2900.00,'Retail Sale Id 939 for retail product','2023-03-05 09:37:25','',''),('1','311',1777,'','20','3',6480.00,0.00,'Retail Sale Id 940 for multiple products','2023-03-05 09:48:02','',''),('1','311',1778,'','6.1','4',0.00,6480.00,'Retail Sale Id 940 for retail product','2023-03-05 09:48:02','',''),('1','311',1779,'','20','3',5040.00,0.00,'Retail Sale Id 941 for 7.00 KG of Cooking Gas @ N720.00','2023-03-05 10:09:52','',''),('1','311',1780,'','6.1','4',0.00,5040.00,'Retail Sale Id 941 for retail product','2023-03-05 10:09:52','',''),('1','311',1781,'','20','3',1440.00,0.00,'Retail Sale Id 942 for 2.00 KG of Cooking Gas @ N720.00','2023-03-05 10:52:42','',''),('1','311',1782,'','6.1','4',0.00,1440.00,'Retail Sale Id 942 for retail product','2023-03-05 10:52:42','',''),('1','311',1783,'','20','3',2500.00,0.00,'Retail Sale Id 944 for 3.47 KG of Cooking Gas @ N720.00','2023-03-05 11:02:31','',''),('1','311',1784,'','6.1','4',0.00,2500.00,'Retail Sale Id 944 for retail product','2023-03-05 11:02:31','',''),('1','311',1785,'','20','3',2880.00,0.00,'Retail Sale Id 943 for 4.00 KG of Cooking Gas @ N720.00','2023-03-05 11:03:25','',''),('1','311',1786,'','6.1','4',0.00,2880.00,'Retail Sale Id 943 for retail product','2023-03-05 11:03:25','',''),('1','311',1787,'','20','3',1440.00,0.00,'Retail Sale Id 945 for 2.00 KG of Cooking Gas @ N720.00','2023-03-05 11:04:46','',''),('1','311',1788,'','6.1','4',0.00,1440.00,'Retail Sale Id 945 for retail product','2023-03-05 11:04:46','',''),('1','311',1789,'','20','3',720.00,0.00,'Retail Sale Id 946 for 1.00 KG of Cooking Gas @ N720.00','2023-03-05 11:11:36','',''),('1','311',1790,'','6.1','4',0.00,720.00,'Retail Sale Id 946 for retail product','2023-03-05 11:11:36','',''),('1','311',1791,'','20','3',3600.00,0.00,'Retail Sale Id 947 for 5.00 KG of Cooking Gas @ N720.00','2023-03-05 11:21:41','',''),('1','311',1792,'','6.1','4',0.00,3600.00,'Retail Sale Id 947 for retail product','2023-03-05 11:21:41','',''),('1','311',1793,'','20','3',720.00,0.00,'Retail Sale Id 949 for 1.00 KG of Cooking Gas @ N720.00','2023-03-05 11:25:18','',''),('1','311',1794,'','6.1','4',0.00,720.00,'Retail Sale Id 949 for retail product','2023-03-05 11:25:18','',''),('1','311',1795,'','20','3',9000.00,0.00,'Retail Sale Id 950 for 12.50 KG of Cooking Gas @ N720.00','2023-03-05 11:54:30','',''),('1','311',1796,'','6.1','4',0.00,9000.00,'Retail Sale Id 950 for retail product','2023-03-05 11:54:30','',''),('1','311',1797,'','20','3',3600.00,0.00,'Retail Sale Id 951 for 5.00 KG of Cooking Gas @ N720.00','2023-03-05 12:00:10','',''),('1','311',1798,'','6.1','4',0.00,3600.00,'Retail Sale Id 951 for retail product','2023-03-05 12:00:10','',''),('1','311',1799,'','20','3',4320.00,0.00,'Retail Sale Id 952 for 6.00 KG of Cooking Gas @ N720.00','2023-03-05 12:26:17','',''),('1','311',1800,'','6.1','4',0.00,4320.00,'Retail Sale Id 952 for retail product','2023-03-05 12:26:17','',''),('1','311',1801,'','20','3',4320.00,0.00,'Retail Sale Id 953 for 6.00 KG of Cooking Gas @ N720.00','2023-03-05 12:45:02','',''),('1','311',1802,'','6.1','4',0.00,4320.00,'Retail Sale Id 953 for retail product','2023-03-05 12:45:02','',''),('1','311',1803,'','20','3',4320.00,0.00,'Retail Sale Id 954 for 6.00 KG of Cooking Gas @ N720.00','2023-03-05 12:46:45','',''),('1','311',1804,'','6.1','4',0.00,4320.00,'Retail Sale Id 954 for retail product','2023-03-05 12:46:45','',''),('1','311',1805,'','20','3',2160.00,0.00,'Retail Sale Id 955 for 3.00 KG of Cooking Gas @ N720.00','2023-03-05 13:08:17','',''),('1','311',1806,'','6.1','4',0.00,2160.00,'Retail Sale Id 955 for retail product','2023-03-05 13:08:17','',''),('1','311',1807,'','20','3',1000.00,0.00,'Retail Sale Id 956 for 1.39 KG of Cooking Gas @ N720.00','2023-03-05 13:09:19','',''),('1','311',1808,'','6.1','4',0.00,1000.00,'Retail Sale Id 956 for retail product','2023-03-05 13:09:19','',''),('1','311',1809,'','20','3',2160.00,0.00,'Retail Sale Id 957 for 3.00 KG of Cooking Gas @ N720.00','2023-03-05 13:21:46','',''),('1','311',1810,'','6.1','4',0.00,2160.00,'Retail Sale Id 957 for retail product','2023-03-05 13:21:46','',''),('1','311',1811,'','20','3',5040.00,0.00,'Retail Sale Id 958 for 7.00 KG of Cooking Gas @ N720.00','2023-03-05 13:48:49','',''),('1','311',1812,'','6.1','4',0.00,5040.00,'Retail Sale Id 958 for retail product','2023-03-05 13:48:49','',''),('1','311',1813,'','20','3',5760.00,0.00,'Retail Sale Id 959 for multiple products','2023-03-05 13:57:50','',''),('1','311',1814,'','6.1','4',0.00,5760.00,'Retail Sale Id 959 for retail product','2023-03-05 13:57:50','',''),('1','311',1815,'','20','3',2160.00,0.00,'Retail Sale Id 960 for 3.00 KG of Cooking Gas @ N720.00','2023-03-05 14:00:17','',''),('1','311',1816,'','6.1','4',0.00,2160.00,'Retail Sale Id 960 for retail product','2023-03-05 14:00:17','',''),('1','311',1817,'','20','3',5040.00,0.00,'Retail Sale Id 961 for 7.00 KG of Cooking Gas @ N720.00','2023-03-05 14:09:30','',''),('1','311',1818,'','6.1','4',0.00,5040.00,'Retail Sale Id 961 for retail product','2023-03-05 14:09:30','',''),('1','311',1819,'','20','3',1500.00,0.00,'Retail Sale Id 962 for 2.08 KG of Cooking Gas @ N720.00','2023-03-05 14:10:19','',''),('1','311',1820,'','6.1','4',0.00,1500.00,'Retail Sale Id 962 for retail product','2023-03-05 14:10:19','',''),('1','311',1821,'','20','3',5040.00,0.00,'Retail Sale Id 963 for 7.00 KG of Cooking Gas @ N720.00','2023-03-05 14:23:38','',''),('1','311',1822,'','6.1','4',0.00,5040.00,'Retail Sale Id 963 for retail product','2023-03-05 14:23:38','',''),('1','311',1823,'','20','3',2160.00,0.00,'Retail Sale Id 964 for 3.00 KG of Cooking Gas @ N720.00','2023-03-05 14:38:04','',''),('1','311',1824,'','6.1','4',0.00,2160.00,'Retail Sale Id 964 for retail product','2023-03-05 14:38:04','',''),('1','311',1825,'','20','3',720.00,0.00,'Retail Sale Id 965 for 1.00 KG of Cooking Gas @ N720.00','2023-03-05 14:41:24','',''),('1','311',1826,'','6.1','4',0.00,720.00,'Retail Sale Id 965 for retail product','2023-03-05 14:41:24','',''),('1','311',1827,'','20','3',5040.00,0.00,'Retail Sale Id 966 for 7.00 KG of Cooking Gas @ N720.00','2023-03-05 15:01:19','',''),('1','311',1828,'','6.1','4',0.00,5040.00,'Retail Sale Id 966 for retail product','2023-03-05 15:01:19','',''),('1','311',1829,'','20','3',6480.00,0.00,'Retail Sale Id 967 for 9.00 KG of Cooking Gas @ N720.00','2023-03-05 15:07:02','',''),('1','311',1830,'','6.1','4',0.00,6480.00,'Retail Sale Id 967 for retail product','2023-03-05 15:07:02','',''),('1','311',1831,'','20','3',5040.00,0.00,'Retail Sale Id 968 for 7.00 KG of Cooking Gas @ N720.00','2023-03-05 15:08:37','',''),('1','311',1832,'','6.1','4',0.00,5040.00,'Retail Sale Id 968 for retail product','2023-03-05 15:08:37','',''),('1','311',1833,'','20','3',3600.00,0.00,'Retail Sale Id 969 for 5.00 KG of Cooking Gas @ N720.00','2023-03-05 15:14:42','',''),('1','311',1834,'','6.1','4',0.00,3600.00,'Retail Sale Id 969 for retail product','2023-03-05 15:14:42','',''),('1','311',1835,'','20','3',9000.00,0.00,'Retail Sale Id 970 for 12.50 KG of Cooking Gas @ N720.00','2023-03-05 15:15:51','',''),('1','311',1836,'','6.1','4',0.00,9000.00,'Retail Sale Id 970 for retail product','2023-03-05 15:15:51','',''),('1','311',1837,'','20','3',2500.00,0.00,'Retail Sale Id 971 for multiple products','2023-03-05 15:18:17','',''),('1','311',1838,'','6.1','4',0.00,2500.00,'Retail Sale Id 971 for retail product','2023-03-05 15:18:17','',''),('1','311',1839,'','20','3',2160.00,0.00,'Retail Sale Id 972 for 3.00 KG of Cooking Gas @ N720.00','2023-03-05 15:19:28','',''),('1','311',1840,'','6.1','4',0.00,2160.00,'Retail Sale Id 972 for retail product','2023-03-05 15:19:28','',''),('1','311',1841,'','20','3',2880.00,0.00,'Retail Sale Id 974 for 4.00 KG of Cooking Gas @ N720.00','2023-03-05 15:23:54','',''),('1','311',1842,'','6.1','4',0.00,2880.00,'Retail Sale Id 974 for retail product','2023-03-05 15:23:54','',''),('1','311',1843,'','20','3',4800.00,0.00,'Retail Sale Id 975 for 6.67 KG of Cooking Gas @ N720.00','2023-03-05 15:26:02','',''),('1','311',1844,'','6.1','4',0.00,4800.00,'Retail Sale Id 975 for retail product','2023-03-05 15:26:02','',''),('1','311',1845,'','20','3',2160.00,0.00,'Retail Sale Id 973 for 3.00 KG of Cooking Gas @ N720.00','2023-03-05 15:27:27','',''),('1','311',1846,'','6.1','4',0.00,2160.00,'Retail Sale Id 973 for retail product','2023-03-05 15:27:27','',''),('1','311',1847,'','20','3',0.00,4800.00,'Return of Retail Sale Id 975 for products','2023-03-05 15:31:04','',''),('1','311',1848,'','','',4800.00,0.00,'Return of Retail Sale Id 975 for products','2023-03-05 15:31:04','',''),('1','311',1849,'','20','3',3800.00,0.00,'Retail Sale Id 976 for 5.28 KG of Cooking Gas @ N720.00','2023-03-05 15:33:54','',''),('1','311',1850,'','6.1','4',0.00,3800.00,'Retail Sale Id 976 for retail product','2023-03-05 15:33:54','',''),('1','311',1851,'','20','3',9000.00,0.00,'Retail Sale Id 977 for 12.50 KG of Cooking Gas @ N720.00','2023-03-05 15:41:26','',''),('1','311',1852,'','6.1','4',0.00,9000.00,'Retail Sale Id 977 for retail product','2023-03-05 15:41:26','',''),('1','311',1853,'','20','3',1800.00,0.00,'Retail Sale Id 978 for 2.50 KG of Cooking Gas @ N720.00','2023-03-05 15:42:29','',''),('1','311',1854,'','6.1','4',0.00,1800.00,'Retail Sale Id 978 for retail product','2023-03-05 15:42:29','',''),('1','311',1855,'','20','3',1000.00,0.00,'Retail Sale Id 979 for 1.39 KG of Cooking Gas @ N720.00','2023-03-05 15:47:48','',''),('1','311',1856,'','6.1','4',0.00,1000.00,'Retail Sale Id 979 for retail product','2023-03-05 15:47:48','',''),('1','311',1857,'','20','3',3600.00,0.00,'Retail Sale Id 980 for 5.00 KG of Cooking Gas @ N720.00','2023-03-05 16:08:33','',''),('1','311',1858,'','6.1','4',0.00,3600.00,'Retail Sale Id 980 for retail product','2023-03-05 16:08:33','',''),('1','311',1859,'','20','3',5000.00,0.00,'Retail Sale Id 981 for 6.94 KG of Cooking Gas @ N720.00','2023-03-05 16:09:37','',''),('1','311',1860,'','6.1','4',0.00,5000.00,'Retail Sale Id 981 for retail product','2023-03-05 16:09:37','',''),('1','311',1861,'','20','3',5040.00,0.00,'Retail Sale Id 982 for 7.00 KG of Cooking Gas @ N720.00','2023-03-05 16:11:07','',''),('1','311',1862,'','6.1','4',0.00,5040.00,'Retail Sale Id 982 for retail product','2023-03-05 16:11:07','',''),('1','311',1863,'','20','3',3000.00,0.00,'Retail Sale Id 983 for 4.17 KG of Cooking Gas @ N720.00','2023-03-05 16:17:38','',''),('1','311',1864,'','6.1','4',0.00,3000.00,'Retail Sale Id 983 for retail product','2023-03-05 16:17:38','',''),('1','311',1865,'','20','3',5040.00,0.00,'Retail Sale Id 984 for 7.00 KG of Cooking Gas @ N720.00','2023-03-05 16:37:06','',''),('1','311',1866,'','6.1','4',0.00,5040.00,'Retail Sale Id 984 for retail product','2023-03-05 16:37:06','',''),('1','311',1867,'','20','3',1800.00,0.00,'Retail Sale Id 985 for 2.50 KG of Cooking Gas @ N720.00','2023-03-05 16:41:36','',''),('1','311',1868,'','6.1','4',0.00,1800.00,'Retail Sale Id 985 for retail product','2023-03-05 16:41:36','',''),('1','311',1869,'','20','3',2000.00,0.00,'Retail Sale Id 986 for 2.78 KG of Cooking Gas @ N720.00','2023-03-05 16:52:35','',''),('1','311',1870,'','6.1','4',0.00,2000.00,'Retail Sale Id 986 for retail product','2023-03-05 16:52:35','',''),('1','311',1871,'','20','3',2160.00,0.00,'Retail Sale Id 987 for 3.00 KG of Cooking Gas @ N720.00','2023-03-05 16:54:32','',''),('1','311',1872,'','6.1','4',0.00,2160.00,'Retail Sale Id 987 for retail product','2023-03-05 16:54:32','',''),('1','311',1873,'','20','3',3000.00,0.00,'Retail Sale Id 988 for 4.17 KG of Cooking Gas @ N720.00','2023-03-05 16:57:08','',''),('1','311',1874,'','6.1','4',0.00,3000.00,'Retail Sale Id 988 for retail product','2023-03-05 16:57:08','',''),('1','311',1875,'','20','3',2160.00,0.00,'Retail Sale Id 989 for 3.00 KG of Cooking Gas @ N720.00','2023-03-05 16:58:38','',''),('1','311',1876,'','6.1','4',0.00,2160.00,'Retail Sale Id 989 for retail product','2023-03-05 16:58:38','',''),('1','311',1877,'','20','3',4320.00,0.00,'Retail Sale Id 990 for 6.00 KG of Cooking Gas @ N720.00','2023-03-05 17:10:44','',''),('1','311',1878,'','6.1','4',0.00,4320.00,'Retail Sale Id 990 for retail product','2023-03-05 17:10:44','',''),('1','311',1879,'','20','3',4320.00,0.00,'Retail Sale Id 991 for 6.00 KG of Cooking Gas @ N720.00','2023-03-05 17:11:31','',''),('1','311',1880,'','6.1','4',0.00,4320.00,'Retail Sale Id 991 for retail product','2023-03-05 17:11:31','',''),('1','311',1881,'','20','3',3600.00,0.00,'Retail Sale Id 992 for 5.00 KG of Cooking Gas @ N720.00','2023-03-05 17:12:42','',''),('1','311',1882,'','6.1','4',0.00,3600.00,'Retail Sale Id 992 for retail product','2023-03-05 17:12:42','',''),('1','311',1883,'','20','3',5040.00,0.00,'Retail Sale Id 993 for 7.00 KG of Cooking Gas @ N720.00','2023-03-05 17:19:37','',''),('1','311',1884,'','6.1','4',0.00,5040.00,'Retail Sale Id 993 for retail product','2023-03-05 17:19:37','',''),('1','311',1885,'','20','3',1500.00,0.00,'Retail Sale Id 994 for 2.08 KG of Cooking Gas @ N720.00','2023-03-05 17:26:24','',''),('1','311',1886,'','6.1','4',0.00,1500.00,'Retail Sale Id 994 for retail product','2023-03-05 17:26:24','',''),('1','311',1887,'','20','3',6480.00,0.00,'Retail Sale Id 995 for 9.00 KG of Cooking Gas @ N720.00','2023-03-05 17:28:53','',''),('1','311',1888,'','6.1','4',0.00,6480.00,'Retail Sale Id 995 for retail product','2023-03-05 17:28:53','',''),('1','311',1889,'','20','3',756.00,0.00,'Retail Sale Id 996 for 1.05 KG of Cooking Gas @ N720.00','2023-03-05 17:50:28','',''),('1','311',1890,'','6.1','4',0.00,756.00,'Retail Sale Id 996 for retail product','2023-03-05 17:50:28','',''),('1','311',1891,'','20','3',2167.20,0.00,'Retail Sale Id 997 for 3.01 KG of Cooking Gas @ N720.00','2023-03-05 18:07:51','',''),('1','311',1892,'','6.1','4',0.00,2167.20,'Retail Sale Id 997 for retail product','2023-03-05 18:07:51','',''),('1','311',1893,'','20','3',0.00,0.00,'Sales from shift 21 on 2023-03-05 18:11:23 ','2023-03-05 18:11:23','',''),('1','311',1894,'','6.1','4',0.00,0.00,'Sales from shift 21 on 2023-03-05 18:11:23 ','2023-03-05 18:11:23','',''),('1','311',1895,'','20','3',2880.00,0.00,'Retail Sale Id 998 for 4.00 KG of Cooking Gas @ N720.00','2023-03-07 08:17:30','',''),('1','311',1896,'','6.1','4',0.00,2880.00,'Retail Sale Id 998 for retail product','2023-03-07 08:17:30','',''),('1','311',1897,'','20','3',2000.00,0.00,'Retail Sale Id 999 for 2.78 KG of Cooking Gas @ N720.00','2023-03-07 08:18:34','',''),('1','311',1898,'','6.1','4',0.00,2000.00,'Retail Sale Id 999 for retail product','2023-03-07 08:18:34','',''),('1','311',1899,'','20','3',1000.00,0.00,'Retail Sale Id 1000 for 1.39 KG of Cooking Gas @ N720.00','2023-03-07 08:19:39','',''),('1','311',1900,'','6.1','4',0.00,1000.00,'Retail Sale Id 1000 for retail product','2023-03-07 08:19:39','',''),('1','311',1901,'','20','3',9000.00,0.00,'Retail Sale Id 1001 for 12.50 KG of Cooking Gas @ N720.00','2023-03-07 08:20:26','',''),('1','311',1902,'','6.1','4',0.00,9000.00,'Retail Sale Id 1001 for retail product','2023-03-07 08:20:26','',''),('1','311',1903,'','20','3',5040.00,0.00,'Retail Sale Id 1002 for 7.00 KG of Cooking Gas @ N720.00','2023-03-07 08:21:37','',''),('1','311',1904,'','6.1','4',0.00,5040.00,'Retail Sale Id 1002 for retail product','2023-03-07 08:21:37','',''),('1','311',1905,'','20','3',2880.00,0.00,'Retail Sale Id 1003 for 4.00 KG of Cooking Gas @ N720.00','2023-03-07 08:24:23','',''),('1','311',1906,'','6.1','4',0.00,2880.00,'Retail Sale Id 1003 for retail product','2023-03-07 08:24:23','',''),('1','311',1907,'','20','3',4320.00,0.00,'Retail Sale Id 1004 for 6.00 KG of Cooking Gas @ N720.00','2023-03-07 08:29:33','',''),('1','311',1908,'','6.1','4',0.00,4320.00,'Retail Sale Id 1004 for retail product','2023-03-07 08:29:33','',''),('1','311',1909,'','20','3',2880.00,0.00,'Retail Sale Id 1005 for 4.00 KG of Cooking Gas @ N720.00','2023-03-07 08:30:45','',''),('1','311',1910,'','6.1','4',0.00,2880.00,'Retail Sale Id 1005 for retail product','2023-03-07 08:30:45','',''),('1','311',1911,'','20','3',4320.00,0.00,'Retail Sale Id 1006 for 6.00 KG of Cooking Gas @ N720.00','2023-03-07 08:32:15','',''),('1','311',1912,'','6.1','4',0.00,4320.00,'Retail Sale Id 1006 for retail product','2023-03-07 08:32:15','',''),('1','311',1913,'','20','3',9000.00,0.00,'Retail Sale Id 1007 for 12.50 KG of Cooking Gas @ N720.00','2023-03-07 08:56:20','',''),('1','311',1914,'','6.1','4',0.00,9000.00,'Retail Sale Id 1007 for retail product','2023-03-07 08:56:20','',''),('1','311',1915,'','20','3',10440.00,0.00,'Retail Sale Id 1008 for multiple products','2023-03-07 08:58:05','',''),('1','311',1916,'','6.1','4',0.00,10440.00,'Retail Sale Id 1008 for retail product','2023-03-07 08:58:05','',''),('1','311',1917,'','20','3',3000.00,0.00,'Retail Sale Id 1009 for 4.17 KG of Cooking Gas @ N720.00','2023-03-07 08:59:28','',''),('1','311',1918,'','6.1','4',0.00,3000.00,'Retail Sale Id 1009 for retail product','2023-03-07 08:59:28','',''),('1','311',1919,'','20','3',1500.00,0.00,'Retail Sale Id 1011 for 2.08 KG of Cooking Gas @ N720.00','2023-03-07 09:06:49','',''),('1','311',1920,'','6.1','4',0.00,1500.00,'Retail Sale Id 1011 for retail product','2023-03-07 09:06:49','',''),('1','311',1921,'','20','3',1440.00,0.00,'Retail Sale Id 1012 for 2.00 KG of Cooking Gas @ N720.00','2023-03-07 09:22:36','',''),('1','311',1922,'','6.1','4',0.00,1440.00,'Retail Sale Id 1012 for retail product','2023-03-07 09:22:36','',''),('1','311',1923,'','20','3',6480.00,0.00,'Retail Sale Id 1013 for multiple products','2023-03-07 09:30:54','',''),('1','311',1924,'','6.1','4',0.00,6480.00,'Retail Sale Id 1013 for retail product','2023-03-07 09:30:54','',''),('1','311',1925,'','20','3',9000.00,0.00,'Retail Sale Id 1014 for 12.50 KG of Cooking Gas @ N720.00','2023-03-07 09:32:13','',''),('1','311',1926,'','6.1','4',0.00,9000.00,'Retail Sale Id 1014 for retail product','2023-03-07 09:32:13','',''),('1','311',1927,'','20','3',2160.00,0.00,'Retail Sale Id 1015 for 3.00 KG of Cooking Gas @ N720.00','2023-03-07 09:39:53','',''),('1','311',1928,'','6.1','4',0.00,2160.00,'Retail Sale Id 1015 for retail product','2023-03-07 09:39:53','',''),('1','311',1929,'','20','3',0.00,2160.00,'Return of Retail Sale Id 1015 for products','2023-03-07 09:45:23','',''),('1','311',1930,'','','',2160.00,0.00,'Return of Retail Sale Id 1015 for products','2023-03-07 09:45:23','',''),('1','311',1931,'','20','3',2160.00,0.00,'Retail Sale Id 1016 for 3.00 KG of Cooking Gas @ N720.00','2023-03-07 09:46:48','',''),('1','311',1932,'','6.1','4',0.00,2160.00,'Retail Sale Id 1016 for retail product','2023-03-07 09:46:48','',''),('1','311',1933,'','20','3',4680.00,0.00,'Retail Sale Id 1017 for 6.50 KG of Cooking Gas @ N720.00','2023-03-07 09:53:41','',''),('1','311',1934,'','6.1','4',0.00,4680.00,'Retail Sale Id 1017 for retail product','2023-03-07 09:53:41','',''),('1','311',1935,'','20','3',1000.00,0.00,'Retail Sale Id 1019 for 1.39 KG of Cooking Gas @ N720.00','2023-03-07 10:17:38','',''),('1','311',1936,'','6.1','4',0.00,1000.00,'Retail Sale Id 1019 for retail product','2023-03-07 10:17:38','',''),('1','311',1937,'','20','3',4680.00,0.00,'Retail Sale Id 1020 for 6.50 KG of Cooking Gas @ N720.00','2023-03-07 10:19:46','',''),('1','311',1938,'','6.1','4',0.00,4680.00,'Retail Sale Id 1020 for retail product','2023-03-07 10:19:46','',''),('1','311',1939,'','20','3',4320.00,0.00,'Retail Sale Id 1021 for 6.00 KG of Cooking Gas @ N720.00','2023-03-07 10:23:58','',''),('1','311',1940,'','6.1','4',0.00,4320.00,'Retail Sale Id 1021 for retail product','2023-03-07 10:23:58','',''),('1','311',1941,'','20','3',1400.00,0.00,'Retail Sale Id 1022 for 1.94 KG of Cooking Gas @ N720.00','2023-03-07 10:27:47','',''),('1','311',1942,'','6.1','4',0.00,1400.00,'Retail Sale Id 1022 for retail product','2023-03-07 10:27:47','',''),('1','311',1943,'','2','20',146060.00,0.00,'Payment Id 42 for invoice:17, receipt: 0036 by AA RANO NIGERIA LTD','2023-03-07 10:36:17','',''),('1','311',1944,'','supplier','1',0.00,146060.00,'Payment Id 42 for invoice:17, receipt: 0036 by AA RANO NIGERIA LTD','2023-03-07 10:36:17','',''),('1','311',1945,'','2','9',22240.00,0.00,'Payment Id 41 for invoice:17, receipt: 0035 by AA RANO NIGERIA LTD','2023-03-07 10:36:17','',''),('1','311',1946,'','supplier','1',0.00,22240.00,'Payment Id 41 for invoice:17, receipt: 0035 by AA RANO NIGERIA LTD','2023-03-07 10:36:17','',''),('1','311',1947,'','20','3',5040.00,0.00,'Retail Sale Id 1024 for 7.00 KG of Cooking Gas @ N720.00','2023-03-07 10:36:51','',''),('1','311',1948,'','6.1','4',0.00,5040.00,'Retail Sale Id 1024 for retail product','2023-03-07 10:36:51','',''),('1','311',1949,'','2','20',129260.00,0.00,'Payment Id 45 for invoice:18, receipt: 0037 by AA RANO NIGERIA LTD','2023-03-07 10:37:01','',''),('1','311',1950,'','supplier','1',0.00,129260.00,'Payment Id 45 for invoice:18, receipt: 0037 by AA RANO NIGERIA LTD','2023-03-07 10:37:01','',''),('1','311',1951,'','2','9',39900.00,0.00,'Payment Id 44 for invoice:18, receipt: 0037 by AA RANO NIGERIA LTD','2023-03-07 10:37:01','',''),('1','311',1952,'','supplier','1',0.00,39900.00,'Payment Id 44 for invoice:18, receipt: 0037 by AA RANO NIGERIA LTD','2023-03-07 10:37:01','',''),('1','311',1953,'','2','20',100801.00,0.00,'Payment Id 48 for invoice:19, receipt: 0038 by AA RANO NIGERIA LTD','2023-03-07 10:37:58','',''),('1','311',1954,'','supplier','1',0.00,100801.00,'Payment Id 48 for invoice:19, receipt: 0038 by AA RANO NIGERIA LTD','2023-03-07 10:37:58','',''),('1','311',1955,'','2','20',232673.00,0.00,'Payment Id 51 for invoice:20, receipt: 0040 by AA RANO NIGERIA LTD','2023-03-07 10:38:44','',''),('1','311',1956,'','supplier','1',0.00,232673.00,'Payment Id 51 for invoice:20, receipt: 0040 by AA RANO NIGERIA LTD','2023-03-07 10:38:44','',''),('1','311',1957,'','2','9',18000.00,0.00,'Payment Id 50 for invoice:20, receipt: 0040 by AA RANO NIGERIA LTD','2023-03-07 10:38:44','',''),('1','311',1958,'','supplier','1',0.00,18000.00,'Payment Id 50 for invoice:20, receipt: 0040 by AA RANO NIGERIA LTD','2023-03-07 10:38:44','',''),('1','311',1959,'','2','20',194150.00,0.00,'Payment Id 54 for invoice:21, receipt: 0049 by AA RANO NIGERIA LTD','2023-03-07 10:51:45','',''),('1','311',1960,'','supplier','1',0.00,194150.00,'Payment Id 54 for invoice:21, receipt: 0049 by AA RANO NIGERIA LTD','2023-03-07 10:51:45','',''),('1','311',1961,'','2','9',10800.00,0.00,'Payment Id 53 for invoice:21, receipt: 0049 by AA RANO NIGERIA LTD','2023-03-07 10:51:45','',''),('1','311',1962,'','supplier','1',0.00,10800.00,'Payment Id 53 for invoice:21, receipt: 0049 by AA RANO NIGERIA LTD','2023-03-07 10:51:45','',''),('1','311',1963,'','20','3',4320.00,0.00,'Retail Sale Id 1018 for 6.00 KG of Cooking Gas @ N720.00','2023-03-07 10:56:35','',''),('1','311',1964,'','6.1','4',0.00,4320.00,'Retail Sale Id 1018 for retail product','2023-03-07 10:56:35','',''),('1','311',1965,'','20','3',2160.00,0.00,'Retail Sale Id 1026 for 3.00 KG of Cooking Gas @ N720.00','2023-03-07 11:16:24','',''),('1','311',1966,'','6.1','4',0.00,2160.00,'Retail Sale Id 1026 for retail product','2023-03-07 11:16:24','',''),('1','311',1967,'','20','3',136000.00,0.00,'Retail Sale Id 1027 for 200.00 KG of Cooking Gas @ N680.00','2023-03-07 12:03:18','',''),('1','311',1968,'','6.1','4',0.00,136000.00,'Retail Sale Id 1027 for retail product','2023-03-07 12:03:18','',''),('1','311',1969,'','20','3',2160.00,0.00,'Retail Sale Id 1028 for 3.00 KG of Cooking Gas @ N720.00','2023-03-07 12:07:03','',''),('1','311',1970,'','6.1','4',0.00,2160.00,'Retail Sale Id 1028 for retail product','2023-03-07 12:07:03','',''),('1','311',1971,'','20','3',2500.00,0.00,'Retail Sale Id 1029 for 3.47 KG of Cooking Gas @ N720.00','2023-03-07 12:10:04','',''),('1','311',1972,'','6.1','4',0.00,2500.00,'Retail Sale Id 1029 for retail product','2023-03-07 12:10:04','',''),('1','311',1973,'','20','3',1080.00,0.00,'Retail Sale Id 1030 for 1.50 KG of Cooking Gas @ N720.00','2023-03-07 12:11:46','',''),('1','311',1974,'','6.1','4',0.00,1080.00,'Retail Sale Id 1030 for retail product','2023-03-07 12:11:46','',''),('1','311',1975,'','20','3',4320.00,0.00,'Retail Sale Id 1031 for 6.00 KG of Cooking Gas @ N720.00','2023-03-07 12:15:55','',''),('1','311',1976,'','6.1','4',0.00,4320.00,'Retail Sale Id 1031 for retail product','2023-03-07 12:15:55','',''),('1','311',1977,'','20','3',5040.00,0.00,'Retail Sale Id 1032 for 7.00 KG of Cooking Gas @ N720.00','2023-03-07 12:17:06','',''),('1','311',1978,'','6.1','4',0.00,5040.00,'Retail Sale Id 1032 for retail product','2023-03-07 12:17:06','',''),('1','311',1979,'','20','3',4320.00,0.00,'Retail Sale Id 1033 for 6.00 KG of Cooking Gas @ N720.00','2023-03-07 12:17:59','',''),('1','311',1980,'','6.1','4',0.00,4320.00,'Retail Sale Id 1033 for retail product','2023-03-07 12:17:59','',''),('1','311',1981,'','20','3',4320.00,0.00,'Retail Sale Id 1034 for 6.00 KG of Cooking Gas @ N720.00','2023-03-07 12:18:48','',''),('1','311',1982,'','6.1','4',0.00,4320.00,'Retail Sale Id 1034 for retail product','2023-03-07 12:18:48','',''),('1','311',1983,'','20','3',0.00,1080.00,'Return of Retail Sale Id 1030 for products','2023-03-07 12:19:24','',''),('1','311',1984,'','','',1080.00,0.00,'Return of Retail Sale Id 1030 for products','2023-03-07 12:19:24','',''),('1','311',1985,'','20','3',1080.00,0.00,'Retail Sale Id 1035 for 1.50 KG of Cooking Gas @ N720.00','2023-03-07 12:20:19','',''),('1','311',1986,'','6.1','4',0.00,1080.00,'Retail Sale Id 1035 for retail product','2023-03-07 12:20:19','',''),('1','311',1987,'','20','3',544000.00,0.00,'Retail Sale Id 1036 for 800.00 KG of Cooking Gas @ N680.00','2023-03-07 12:31:41','',''),('1','311',1988,'','6.1','4',0.00,544000.00,'Retail Sale Id 1036 for retail product','2023-03-07 12:31:41','',''),('1','311',1989,'','2','15',64785.00,0.00,'Payment Id 13 for invoice:11, receipt: 0000 by AA RANO NIGERIA LTD','2023-03-07 12:43:41','',''),('1','311',1990,'','supplier','1',0.00,64785.00,'Payment Id 13 for invoice:11, receipt: 0000 by AA RANO NIGERIA LTD','2023-03-07 12:43:41','',''),('1','311',1991,'','2','15',8345.00,0.00,'Payment Id 11 for invoice:10, receipt: 0000 by AA RANO NIGERIA LTD','2023-03-07 12:43:41','',''),('1','311',1992,'','supplier','1',0.00,8345.00,'Payment Id 11 for invoice:10, receipt: 0000 by AA RANO NIGERIA LTD','2023-03-07 12:43:41','',''),('1','311',1993,'','2','15',33795.00,0.00,'Payment Id 9 for invoice:9, receipt: 0000 by AA RANO NIGERIA LTD','2023-03-07 12:43:41','',''),('1','311',1994,'','supplier','1',0.00,33795.00,'Payment Id 9 for invoice:9, receipt: 0000 by AA RANO NIGERIA LTD','2023-03-07 12:43:41','',''),('1','311',1995,'','20','3',1440.00,0.00,'Retail Sale Id 1037 for 2.00 KG of Cooking Gas @ N720.00','2023-03-07 13:05:38','',''),('1','311',1996,'','6.1','4',0.00,1440.00,'Retail Sale Id 1037 for retail product','2023-03-07 13:05:38','',''),('1','311',1997,'','20','3',86000.00,0.00,'Retail Sale Id 1038 for 126.47 KG of Cooking Gas @ N680.00','2023-03-07 13:07:41','',''),('1','311',1998,'','6.1','4',0.00,86000.00,'Retail Sale Id 1038 for retail product','2023-03-07 13:07:41','',''),('1','311',1999,'','20','3',3600.00,0.00,'Retail Sale Id 1039 for 5.00 KG of Cooking Gas @ N720.00','2023-03-07 13:13:54','',''),('1','311',2000,'','6.1','4',0.00,3600.00,'Retail Sale Id 1039 for retail product','2023-03-07 13:13:54','',''),('1','311',2001,'','20','3',0.00,86000.00,'Return of Retail Sale Id 1038 for products','2023-03-07 13:18:03','',''),('1','311',2002,'','','',86000.00,0.00,'Return of Retail Sale Id 1038 for products','2023-03-07 13:18:03','',''),('1','311',2003,'','20','3',85000.00,0.00,'Retail Sale Id 1040 for 125.00 KG of Cooking Gas @ N680.00','2023-03-07 13:19:07','',''),('1','311',2004,'','6.1','4',0.00,85000.00,'Retail Sale Id 1040 for retail product','2023-03-07 13:19:07','',''),('1','311',2005,'','20','3',1440.00,0.00,'Retail Sale Id 1041 for 2.00 KG of Cooking Gas @ N720.00','2023-03-07 13:48:53','',''),('1','311',2006,'','6.1','4',0.00,1440.00,'Retail Sale Id 1041 for retail product','2023-03-07 13:48:53','',''),('1','311',2007,'','20','3',0.00,1440.00,'Return of Retail Sale Id 1041 for products','2023-03-07 13:53:24','',''),('1','311',2008,'','','',1440.00,0.00,'Return of Retail Sale Id 1041 for products','2023-03-07 13:53:24','',''),('1','311',2009,'','20','3',2000.00,0.00,'Retail Sale Id 1042 for 2.78 KG of Cooking Gas @ N720.00','2023-03-07 13:54:16','',''),('1','311',2010,'','6.1','4',0.00,2000.00,'Retail Sale Id 1042 for retail product','2023-03-07 13:54:16','',''),('1','311',2011,'','20','3',2000.00,0.00,'Retail Sale Id 1043 for 2.78 KG of Cooking Gas @ N720.00','2023-03-07 14:17:27','',''),('1','311',2012,'','6.1','4',0.00,2000.00,'Retail Sale Id 1043 for retail product','2023-03-07 14:17:27','',''),('1','311',2013,'','20','3',8700.00,0.00,'Retail Sale Id 1044 for 12.08 KG of Cooking Gas @ N720.00','2023-03-07 14:37:35','',''),('1','311',2014,'','6.1','4',0.00,8700.00,'Retail Sale Id 1044 for retail product','2023-03-07 14:37:35','',''),('1','311',2015,'','20','3',1440.00,0.00,'Retail Sale Id 1045 for 2.00 KG of Cooking Gas @ N720.00','2023-03-07 14:38:32','',''),('1','311',2016,'','6.1','4',0.00,1440.00,'Retail Sale Id 1045 for retail product','2023-03-07 14:38:32','',''),('1','311',2017,'','20','3',3600.00,0.00,'Retail Sale Id 1046 for 5.00 KG of Cooking Gas @ N720.00','2023-03-07 14:48:53','',''),('1','311',2018,'','6.1','4',0.00,3600.00,'Retail Sale Id 1046 for retail product','2023-03-07 14:48:53','',''),('1','311',2019,'','20','3',3000.00,0.00,'Retail Sale Id 1047 for 4.17 KG of Cooking Gas @ N720.00','2023-03-07 15:00:17','',''),('1','311',2020,'','6.1','4',0.00,3000.00,'Retail Sale Id 1047 for retail product','2023-03-07 15:00:17','',''),('1','311',2021,'','20','3',2800.00,0.00,'Retail Sale Id 1048 for 3.89 KG of Cooking Gas @ N720.00','2023-03-07 15:46:48','',''),('1','311',2022,'','6.1','4',0.00,2800.00,'Retail Sale Id 1048 for retail product','2023-03-07 15:46:48','',''),('1','311',2023,'','20','3',3000.00,0.00,'Retail Sale Id 1054 for 4.17 KG of Cooking Gas @ N720.00','2023-03-07 15:50:20','',''),('1','311',2024,'','6.1','4',0.00,3000.00,'Retail Sale Id 1054 for retail product','2023-03-07 15:50:20','',''),('1','311',2025,'','20','3',3000.00,0.00,'Retail Sale Id 1055 for 4.17 KG of Cooking Gas @ N720.00','2023-03-07 15:51:13','',''),('1','311',2026,'','6.1','4',0.00,3000.00,'Retail Sale Id 1055 for retail product','2023-03-07 15:51:13','',''),('1','311',2027,'','20','3',3000.00,0.00,'Retail Sale Id 1056 for 4.17 KG of Cooking Gas @ N720.00','2023-03-07 15:56:45','',''),('1','311',2028,'','6.1','4',0.00,3000.00,'Retail Sale Id 1056 for retail product','2023-03-07 15:56:45','',''),('1','311',2029,'','20','3',2000.00,0.00,'Retail Sale Id 1057 for 2.78 KG of Cooking Gas @ N720.00','2023-03-07 16:03:34','',''),('1','311',2030,'','6.1','4',0.00,2000.00,'Retail Sale Id 1057 for retail product','2023-03-07 16:03:34','',''),('1','311',2031,'','20','3',7200.00,0.00,'Retail Sale Id 1058 for 10.00 KG of Cooking Gas @ N720.00','2023-03-07 16:05:02','',''),('1','311',2032,'','6.1','4',0.00,7200.00,'Retail Sale Id 1058 for retail product','2023-03-07 16:05:02','',''),('1','311',2033,'','20','3',81600.00,0.00,'Retail Sale Id 1059 for 120.00 KG of Cooking Gas @ N680.00','2023-03-07 16:11:20','',''),('1','311',2034,'','6.1','4',0.00,81600.00,'Retail Sale Id 1059 for retail product','2023-03-07 16:11:20','',''),('1','311',2035,'','20','3',2160.00,0.00,'Retail Sale Id 1060 for 3.00 KG of Cooking Gas @ N720.00','2023-03-07 16:15:00','',''),('1','311',2036,'','6.1','4',0.00,2160.00,'Retail Sale Id 1060 for retail product','2023-03-07 16:15:00','',''),('1','311',2037,'','20','3',7200.00,0.00,'Retail Sale Id 1061 for 10.00 KG of Cooking Gas @ N720.00','2023-03-07 16:15:53','',''),('1','311',2038,'','6.1','4',0.00,7200.00,'Retail Sale Id 1061 for retail product','2023-03-07 16:15:53','',''),('1','311',2039,'','20','3',2160.00,0.00,'Retail Sale Id 1062 for 3.00 KG of Cooking Gas @ N720.00','2023-03-07 16:16:51','',''),('1','311',2040,'','6.1','4',0.00,2160.00,'Retail Sale Id 1062 for retail product','2023-03-07 16:16:51','',''),('1','311',2041,'','20','3',3600.00,0.00,'Retail Sale Id 1063 for multiple products','2023-03-07 16:18:10','',''),('1','311',2042,'','6.1','4',0.00,3600.00,'Retail Sale Id 1063 for retail product','2023-03-07 16:18:10','',''),('1','311',2043,'','20','3',0.00,7200.00,'Return of Retail Sale Id 1058 for products','2023-03-07 16:20:29','',''),('1','311',2044,'','','',7200.00,0.00,'Return of Retail Sale Id 1058 for products','2023-03-07 16:20:29','',''),('1','311',2045,'','20','3',720.00,0.00,'Retail Sale Id 1065 for 1.00 KG of Cooking Gas @ N720.00','2023-03-07 16:29:34','',''),('1','311',2046,'','6.1','4',0.00,720.00,'Retail Sale Id 1065 for retail product','2023-03-07 16:29:34','',''),('1','311',2047,'','20','3',4000.00,0.00,'Retail Sale Id 1066 for 5.56 KG of Cooking Gas @ N720.00','2023-03-07 16:35:38','',''),('1','311',2048,'','6.1','4',0.00,4000.00,'Retail Sale Id 1066 for retail product','2023-03-07 16:35:38','',''),('1','311',2049,'','20','3',1500.00,0.00,'Retail Sale Id 1067 for 2.08 KG of Cooking Gas @ N720.00','2023-03-07 16:37:19','',''),('1','311',2050,'','6.1','4',0.00,1500.00,'Retail Sale Id 1067 for retail product','2023-03-07 16:37:19','',''),('1','311',2051,'','20','3',0.00,1500.00,'Return of Retail Sale Id 1067 for products','2023-03-07 16:38:26','',''),('1','311',2052,'','','',1500.00,0.00,'Return of Retail Sale Id 1067 for products','2023-03-07 16:38:26','',''),('1','311',2053,'','20','3',1400.00,0.00,'Retail Sale Id 1068 for 1.94 KG of Cooking Gas @ N720.00','2023-03-07 16:38:59','',''),('1','311',2054,'','6.1','4',0.00,1400.00,'Retail Sale Id 1068 for retail product','2023-03-07 16:38:59','',''),('1','311',2055,'','20','3',2160.00,0.00,'Retail Sale Id 1070 for 3.00 KG of Cooking Gas @ N720.00','2023-03-07 16:45:58','',''),('1','311',2056,'','6.1','4',0.00,2160.00,'Retail Sale Id 1070 for retail product','2023-03-07 16:45:58','',''),('1','311',2057,'','20','3',3000.00,0.00,'Retail Sale Id 1071 for 4.17 KG of Cooking Gas @ N720.00','2023-03-07 16:47:33','',''),('1','311',2058,'','6.1','4',0.00,3000.00,'Retail Sale Id 1071 for retail product','2023-03-07 16:47:33','',''),('1','311',2059,'','20','3',2520.00,0.00,'Retail Sale Id 1072 for 3.50 KG of Cooking Gas @ N720.00','2023-03-07 16:48:37','',''),('1','311',2060,'','6.1','4',0.00,2520.00,'Retail Sale Id 1072 for retail product','2023-03-07 16:48:37','',''),('1','311',2061,'','20','3',3000.00,0.00,'Retail Sale Id 1073 for 4.17 KG of Cooking Gas @ N720.00','2023-03-07 16:49:23','',''),('1','311',2062,'','6.1','4',0.00,3000.00,'Retail Sale Id 1073 for retail product','2023-03-07 16:49:23','',''),('1','311',2063,'','20','3',2160.00,0.00,'Retail Sale Id 1074 for 3.00 KG of Cooking Gas @ N720.00','2023-03-07 16:50:44','',''),('1','311',2064,'','6.1','4',0.00,2160.00,'Retail Sale Id 1074 for retail product','2023-03-07 16:50:44','',''),('1','311',2065,'','20','3',3600.00,0.00,'Retail Sale Id 1075 for 5.00 KG of Cooking Gas @ N720.00','2023-03-07 16:59:17','',''),('1','311',2066,'','6.1','4',0.00,3600.00,'Retail Sale Id 1075 for retail product','2023-03-07 16:59:17','',''),('1','311',2067,'','20','3',2000.00,0.00,'Retail Sale Id 1076 for 2.78 KG of Cooking Gas @ N720.00','2023-03-07 17:00:28','',''),('1','311',2068,'','6.1','4',0.00,2000.00,'Retail Sale Id 1076 for retail product','2023-03-07 17:00:28','',''),('1','311',2069,'','20','3',2160.00,0.00,'Retail Sale Id 1077 for 3.00 KG of Cooking Gas @ N720.00','2023-03-07 17:02:03','',''),('1','311',2070,'','6.1','4',0.00,2160.00,'Retail Sale Id 1077 for retail product','2023-03-07 17:02:03','',''),('1','311',2071,'','20','3',2880.00,0.00,'Retail Sale Id 1078 for 4.00 KG of Cooking Gas @ N720.00','2023-03-07 17:04:08','',''),('1','311',2072,'','6.1','4',0.00,2880.00,'Retail Sale Id 1078 for retail product','2023-03-07 17:04:08','',''),('1','311',2073,'','20','3',3600.00,0.00,'Retail Sale Id 1080 for 5.00 KG of Cooking Gas @ N720.00','2023-03-07 17:05:43','',''),('1','311',2074,'','6.1','4',0.00,3600.00,'Retail Sale Id 1080 for retail product','2023-03-07 17:05:43','',''),('1','311',2075,'','20','3',3600.00,0.00,'Retail Sale Id 1081 for 5.00 KG of Cooking Gas @ N720.00','2023-03-07 17:06:39','',''),('1','311',2076,'','6.1','4',0.00,3600.00,'Retail Sale Id 1081 for retail product','2023-03-07 17:06:39','',''),('1','311',2077,'','20','3',3600.00,0.00,'Retail Sale Id 1082 for 5.00 KG of Cooking Gas @ N720.00','2023-03-07 17:07:35','',''),('1','311',2078,'','6.1','4',0.00,3600.00,'Retail Sale Id 1082 for retail product','2023-03-07 17:07:35','',''),('1','311',2079,'','20','3',1440.00,0.00,'Retail Sale Id 1084 for 2.00 KG of Cooking Gas @ N720.00','2023-03-07 17:11:53','',''),('1','311',2080,'','6.1','4',0.00,1440.00,'Retail Sale Id 1084 for retail product','2023-03-07 17:11:53','',''),('1','311',2081,'','20','3',4320.00,0.00,'Retail Sale Id 1085 for 6.00 KG of Cooking Gas @ N720.00','2023-03-07 17:13:43','',''),('1','311',2082,'','6.1','4',0.00,4320.00,'Retail Sale Id 1085 for retail product','2023-03-07 17:13:43','',''),('1','311',2083,'','20','3',1440.00,0.00,'Retail Sale Id 1086 for 2.00 KG of Cooking Gas @ N720.00','2023-03-07 17:14:40','',''),('1','311',2084,'','6.1','4',0.00,1440.00,'Retail Sale Id 1086 for retail product','2023-03-07 17:14:40','',''),('1','311',2085,'','20','3',7200.00,0.00,'Retail Sale Id 1087 for 10.00 KG of Cooking Gas @ N720.00','2023-03-07 17:15:25','',''),('1','311',2086,'','6.1','4',0.00,7200.00,'Retail Sale Id 1087 for retail product','2023-03-07 17:15:25','',''),('1','311',2087,'','20','3',0.00,2520.00,'Return of Retail Sale Id 1072 for products','2023-03-07 17:19:40','',''),('1','311',2088,'','','',2520.00,0.00,'Return of Retail Sale Id 1072 for products','2023-03-07 17:19:40','',''),('1','311',2089,'','20','3',11160.00,0.00,'Retail Sale Id 1089 for multiple products','2023-03-07 17:21:05','',''),('1','311',2090,'','6.1','4',0.00,11160.00,'Retail Sale Id 1089 for retail product','2023-03-07 17:21:05','',''),('1','311',2091,'','20','3',2880.00,0.00,'Retail Sale Id 1090 for 4.00 KG of Cooking Gas @ N720.00','2023-03-07 17:22:14','',''),('1','311',2092,'','6.1','4',0.00,2880.00,'Retail Sale Id 1090 for retail product','2023-03-07 17:22:14','',''),('1','311',2093,'','20','3',4320.00,0.00,'Retail Sale Id 1092 for 6.00 KG of Cooking Gas @ N720.00','2023-03-07 17:31:08','',''),('1','311',2094,'','6.1','4',0.00,4320.00,'Retail Sale Id 1092 for retail product','2023-03-07 17:31:08','',''),('1','311',2095,'','20','3',2160.00,0.00,'Retail Sale Id 1093 for 3.00 KG of Cooking Gas @ N720.00','2023-03-07 17:34:58','',''),('1','311',2096,'','6.1','4',0.00,2160.00,'Retail Sale Id 1093 for retail product','2023-03-07 17:34:58','',''),('1','311',2097,'','20','3',2160.00,0.00,'Retail Sale Id 1094 for 3.00 KG of Cooking Gas @ N720.00','2023-03-07 17:36:31','',''),('1','311',2098,'','6.1','4',0.00,2160.00,'Retail Sale Id 1094 for retail product','2023-03-07 17:36:31','',''),('1','311',2099,'','20','3',1440.00,0.00,'Retail Sale Id 1095 for 2.00 KG of Cooking Gas @ N720.00','2023-03-07 17:38:38','',''),('1','311',2100,'','6.1','4',0.00,1440.00,'Retail Sale Id 1095 for retail product','2023-03-07 17:38:38','',''),('1','311',2101,'','20','3',720.00,0.00,'Retail Sale Id 1096 for 1.00 KG of Cooking Gas @ N720.00','2023-03-07 20:08:21','',''),('1','311',2102,'','6.1','4',0.00,720.00,'Retail Sale Id 1096 for retail product','2023-03-07 20:08:21','',''),('1','311',2103,'','20','3',0.00,720.00,'Return of Retail Sale Id 1096 for products','2023-03-07 20:10:36','',''),('1','311',2104,'','','',720.00,0.00,'Return of Retail Sale Id 1096 for products','2023-03-07 20:10:36','',''),('1','311',2105,'','20','3',842.40,0.00,'Retail Sale Id 1097 for 1.17 KG of Cooking Gas @ N720.00','2023-03-07 20:12:08','',''),('1','311',2106,'','6.1','4',0.00,842.40,'Retail Sale Id 1097 for retail product','2023-03-07 20:12:08','',''),('1','311',2107,'','20','3',0.00,0.00,'Sales from shift 22 on 2023-03-07 20:21:33 ','2023-03-07 20:21:33','',''),('1','311',2108,'','6.1','4',0.00,0.00,'Sales from shift 22 on 2023-03-07 20:21:33 ','2023-03-07 20:21:33','',''),('1','311',2109,'','20','3',4320.00,0.00,'Retail Sale Id 1098 for 6.00 KG of Cooking Gas @ N720.00','2023-03-08 10:53:29','',''),('1','311',2110,'','6.1','4',0.00,4320.00,'Retail Sale Id 1098 for retail product','2023-03-08 10:53:29','',''),('1','311',2111,'','20','3',2200.00,0.00,'Retail Sale Id 1099 for 3.06 KG of Cooking Gas @ N720.00','2023-03-08 11:02:21','',''),('1','311',2112,'','6.1','4',0.00,2200.00,'Retail Sale Id 1099 for retail product','2023-03-08 11:02:21','',''),('1','311',2113,'','2','15',21280.00,0.00,'Payment Id 1 for invoice:2, receipt: 0000 by AA RANO NIGERIA LTD','2023-03-08 11:20:46','',''),('1','311',2114,'','supplier','1',0.00,21280.00,'Payment Id 1 for invoice:2, receipt: 0000 by AA RANO NIGERIA LTD','2023-03-08 11:20:46','',''),('1','311',2115,'','2','15',47670.00,0.00,'Payment Id 19 for invoice:8, receipt: 0015 by AA RANO NIGERIA LTD','2023-03-08 11:23:18','',''),('1','311',2116,'','supplier','1',0.00,47670.00,'Payment Id 19 for invoice:8, receipt: 0015 by AA RANO NIGERIA LTD','2023-03-08 11:23:18','',''),('1','311',2117,'','20','3',2000.00,0.00,'Retail Sale Id 1101 for 2.78 KG of Cooking Gas @ N720.00','2023-03-08 11:26:40','',''),('1','311',2118,'','6.1','4',0.00,2000.00,'Retail Sale Id 1101 for retail product','2023-03-08 11:26:40','',''),('1','311',2119,'','20','3',2880.00,0.00,'Retail Sale Id 1103 for 4.00 KG of Cooking Gas @ N720.00','2023-03-08 11:28:51','',''),('1','311',2120,'','6.1','4',0.00,2880.00,'Retail Sale Id 1103 for retail product','2023-03-08 11:28:51','',''),('1','311',2121,'','20','3',14400.00,0.00,'Retail Sale Id 1104 for multiple products','2023-03-08 11:37:06','',''),('1','311',2122,'','6.1','4',0.00,14400.00,'Retail Sale Id 1104 for retail product','2023-03-08 11:37:06','',''),('1','311',2123,'','20','3',9000.00,0.00,'Retail Sale Id 1102 for 12.50 KG of Cooking Gas @ N720.00','2023-03-08 11:38:17','',''),('1','311',2124,'','6.1','4',0.00,9000.00,'Retail Sale Id 1102 for retail product','2023-03-08 11:38:17','',''),('1','311',2125,'','20','3',2160.00,0.00,'Retail Sale Id 1105 for 3.00 KG of Cooking Gas @ N720.00','2023-03-08 11:56:54','',''),('1','311',2126,'','6.1','4',0.00,2160.00,'Retail Sale Id 1105 for retail product','2023-03-08 11:56:54','',''),('1','311',2127,'','20','3',3600.00,0.00,'Retail Sale Id 1106 for 5.00 KG of Cooking Gas @ N720.00','2023-03-08 11:59:01','',''),('1','311',2128,'','6.1','4',0.00,3600.00,'Retail Sale Id 1106 for retail product','2023-03-08 11:59:01','',''),('1','311',2129,'','2','15',33795.00,0.00,'Payment Id 58 for invoice:16, receipt: 0015 by AA RANO NIGERIA LTD','2023-03-08 12:22:25','',''),('1','311',2130,'','supplier','1',0.00,33795.00,'Payment Id 58 for invoice:16, receipt: 0015 by AA RANO NIGERIA LTD','2023-03-08 12:22:25','',''),('1','311',2131,'','20','3',3000.00,0.00,'Retail Sale Id 1107 for 4.17 KG of Cooking Gas @ N720.00','2023-03-08 12:29:48','',''),('1','311',2132,'','6.1','4',0.00,3000.00,'Retail Sale Id 1107 for retail product','2023-03-08 12:29:48','',''),('1','311',2133,'','20','3',3000.00,0.00,'Retail Sale Id 1108 for 4.17 KG of Cooking Gas @ N720.00','2023-03-08 12:46:23','',''),('1','311',2134,'','6.1','4',0.00,3000.00,'Retail Sale Id 1108 for retail product','2023-03-08 12:46:23','',''),('1','311',2135,'','20','3',4000.00,0.00,'Retail Sale Id 1109 for 5.56 KG of Cooking Gas @ N720.00','2023-03-08 13:00:15','',''),('1','311',2136,'','6.1','4',0.00,4000.00,'Retail Sale Id 1109 for retail product','2023-03-08 13:00:15','',''),('1','311',2137,'','20','3',4320.00,0.00,'Retail Sale Id 1110 for 6.00 KG of Cooking Gas @ N720.00','2023-03-08 13:07:43','',''),('1','311',2138,'','6.1','4',0.00,4320.00,'Retail Sale Id 1110 for retail product','2023-03-08 13:07:43','',''),('1','311',2139,'','20','3',3600.00,0.00,'Retail Sale Id 1111 for 5.00 KG of Cooking Gas @ N720.00','2023-03-08 13:12:42','',''),('1','311',2140,'','6.1','4',0.00,3600.00,'Retail Sale Id 1111 for retail product','2023-03-08 13:12:42','',''),('1','311',2141,'','20','3',2880.00,0.00,'Retail Sale Id 1113 for 4.00 KG of Cooking Gas @ N720.00','2023-03-08 13:15:46','',''),('1','311',2142,'','6.1','4',0.00,2880.00,'Retail Sale Id 1113 for retail product','2023-03-08 13:15:46','',''),('1','311',2143,'','20','3',2160.00,0.00,'Retail Sale Id 1114 for 3.00 KG of Cooking Gas @ N720.00','2023-03-08 13:22:51','',''),('1','311',2144,'','6.1','4',0.00,2160.00,'Retail Sale Id 1114 for retail product','2023-03-08 13:22:51','',''),('1','311',2145,'','20','3',4000.00,0.00,'Retail Sale Id 1115 for 5.56 KG of Cooking Gas @ N720.00','2023-03-08 13:48:19','',''),('1','311',2146,'','6.1','4',0.00,4000.00,'Retail Sale Id 1115 for retail product','2023-03-08 13:48:19','',''),('1','311',2147,'','20','3',720.00,0.00,'Retail Sale Id 1116 for 1.00 KG of Cooking Gas @ N720.00','2023-03-08 13:49:43','',''),('1','311',2148,'','6.1','4',0.00,720.00,'Retail Sale Id 1116 for retail product','2023-03-08 13:49:43','',''),('1','311',2149,'','20','3',3600.00,0.00,'Retail Sale Id 1117 for 5.00 KG of Cooking Gas @ N720.00','2023-03-08 13:54:40','',''),('1','311',2150,'','6.1','4',0.00,3600.00,'Retail Sale Id 1117 for retail product','2023-03-08 13:54:40','',''),('1','311',2151,'','20','3',2880.00,0.00,'Retail Sale Id 1118 for 4.00 KG of Cooking Gas @ N720.00','2023-03-08 14:12:17','',''),('1','311',2152,'','6.1','4',0.00,2880.00,'Retail Sale Id 1118 for retail product','2023-03-08 14:12:17','',''),('1','311',2153,'','20','3',0.00,2880.00,'Return of Retail Sale Id 1118 for products','2023-03-08 14:14:36','',''),('1','311',2154,'','','',2880.00,0.00,'Return of Retail Sale Id 1118 for products','2023-03-08 14:14:36','',''),('1','311',2155,'','20','3',1440.00,0.00,'Retail Sale Id 1119 for 2.00 KG of Cooking Gas @ N720.00','2023-03-08 14:15:17','',''),('1','311',2156,'','6.1','4',0.00,1440.00,'Retail Sale Id 1119 for retail product','2023-03-08 14:15:17','',''),('1','311',2157,'','20','3',12660.00,0.00,'Retail Sale Id 1120 for 17.58 KG of Cooking Gas @ N720.00','2023-03-08 14:16:33','',''),('1','311',2158,'','6.1','4',0.00,12660.00,'Retail Sale Id 1120 for retail product','2023-03-08 14:16:33','',''),('1','311',2159,'','20','3',2160.00,0.00,'Retail Sale Id 1121 for 3.00 KG of Cooking Gas @ N720.00','2023-03-08 14:18:47','',''),('1','311',2160,'','6.1','4',0.00,2160.00,'Retail Sale Id 1121 for retail product','2023-03-08 14:18:47','',''),('1','311',2161,'','20','3',25200.00,0.00,'Retail Sale Id 1122 for 35.00 KG of Cooking Gas @ N720.00','2023-03-08 14:21:56','',''),('1','311',2162,'','6.1','4',0.00,25200.00,'Retail Sale Id 1122 for retail product','2023-03-08 14:21:56','',''),('1','311',2163,'','20','3',5040.00,0.00,'Retail Sale Id 1123 for 7.00 KG of Cooking Gas @ N720.00','2023-03-08 14:24:17','',''),('1','311',2164,'','6.1','4',0.00,5040.00,'Retail Sale Id 1123 for retail product','2023-03-08 14:24:17','',''),('1','311',2165,'','20','3',7230.00,0.00,'Retail Sale Id 1124 for 10.04 KG of Cooking Gas @ N720.00','2023-03-08 14:27:13','',''),('1','311',2166,'','6.1','4',0.00,7230.00,'Retail Sale Id 1124 for retail product','2023-03-08 14:27:13','',''),('1','311',2167,'','20','3',5760.00,0.00,'Retail Sale Id 1125 for 8.00 KG of Cooking Gas @ N720.00','2023-03-08 14:29:42','',''),('1','311',2168,'','6.1','4',0.00,5760.00,'Retail Sale Id 1125 for retail product','2023-03-08 14:29:42','',''),('1','311',2169,'','20','3',6500.00,0.00,'Retail Sale Id 1126 for 9.03 KG of Cooking Gas @ N720.00','2023-03-08 14:32:04','',''),('1','311',2170,'','6.1','4',0.00,6500.00,'Retail Sale Id 1126 for retail product','2023-03-08 14:32:04','',''),('1','311',2171,'','20','3',18000.00,0.00,'Retail Sale Id 1127 for multiple products','2023-03-08 14:35:12','',''),('1','311',2172,'','6.1','4',0.00,18000.00,'Retail Sale Id 1127 for retail product','2023-03-08 14:35:12','',''),('1','311',2173,'','20','3',14400.00,0.00,'Retail Sale Id 1128 for multiple products','2023-03-08 14:37:52','',''),('1','311',2174,'','6.1','4',0.00,14400.00,'Retail Sale Id 1128 for retail product','2023-03-08 14:37:52','',''),('1','311',2175,'','20','3',1440.00,0.00,'Retail Sale Id 1130 for 2.00 KG of Cooking Gas @ N720.00','2023-03-08 15:08:06','',''),('1','311',2176,'','6.1','4',0.00,1440.00,'Retail Sale Id 1130 for retail product','2023-03-08 15:08:06','',''),('1','311',2177,'','20','3',9000.00,0.00,'Retail Sale Id 1131 for 12.50 KG of Cooking Gas @ N720.00','2023-03-08 15:10:34','',''),('1','311',2178,'','6.1','4',0.00,9000.00,'Retail Sale Id 1131 for retail product','2023-03-08 15:10:34','',''),('1','311',2179,'','20','3',1500.00,0.00,'Retail Sale Id 1132 for 2.08 KG of Cooking Gas @ N720.00','2023-03-08 15:37:08','',''),('1','311',2180,'','6.1','4',0.00,1500.00,'Retail Sale Id 1132 for retail product','2023-03-08 15:37:08','',''),('1','311',2181,'','20','3',2160.00,0.00,'Retail Sale Id 1133 for 3.00 KG of Cooking Gas @ N720.00','2023-03-08 15:38:41','',''),('1','311',2182,'','6.1','4',0.00,2160.00,'Retail Sale Id 1133 for retail product','2023-03-08 15:38:41','',''),('1','311',2183,'','20','3',1500.00,0.00,'Retail Sale Id 1134 for 2.08 KG of Cooking Gas @ N720.00','2023-03-08 15:40:59','',''),('1','311',2184,'','6.1','4',0.00,1500.00,'Retail Sale Id 1134 for retail product','2023-03-08 15:40:59','',''),('1','311',2185,'','20','3',2160.00,0.00,'Retail Sale Id 1135 for 3.00 KG of Cooking Gas @ N720.00','2023-03-08 15:41:55','',''),('1','311',2186,'','6.1','4',0.00,2160.00,'Retail Sale Id 1135 for retail product','2023-03-08 15:41:55','',''),('1','311',2187,'','20','3',1500.00,0.00,'Retail Sale Id 1136 for 2.08 KG of Cooking Gas @ N720.00','2023-03-08 15:53:24','',''),('1','311',2188,'','6.1','4',0.00,1500.00,'Retail Sale Id 1136 for retail product','2023-03-08 15:53:24','',''),('1','311',2189,'','20','3',4320.00,0.00,'Retail Sale Id 1137 for 6.00 KG of Cooking Gas @ N720.00','2023-03-08 16:04:37','',''),('1','311',2190,'','6.1','4',0.00,4320.00,'Retail Sale Id 1137 for retail product','2023-03-08 16:04:37','',''),('1','311',2191,'','20','3',2160.00,0.00,'Retail Sale Id 1138 for 3.00 KG of Cooking Gas @ N720.00','2023-03-08 16:11:02','',''),('1','311',2192,'','6.1','4',0.00,2160.00,'Retail Sale Id 1138 for retail product','2023-03-08 16:11:02','',''),('1','311',2193,'','20','3',1440.00,0.00,'Retail Sale Id 1139 for 2.00 KG of Cooking Gas @ N720.00','2023-03-08 16:29:05','',''),('1','311',2194,'','6.1','4',0.00,1440.00,'Retail Sale Id 1139 for retail product','2023-03-08 16:29:05','',''),('1','311',2195,'','20','3',8640.00,0.00,'Retail Sale Id 1140 for 12.00 KG of Cooking Gas @ N720.00','2023-03-08 16:39:51','',''),('1','311',2196,'','6.1','4',0.00,8640.00,'Retail Sale Id 1140 for retail product','2023-03-08 16:39:51','',''),('1','311',2197,'','20','3',3600.00,0.00,'Retail Sale Id 1141 for 5.00 KG of Cooking Gas @ N720.00','2023-03-08 16:43:43','',''),('1','311',2198,'','6.1','4',0.00,3600.00,'Retail Sale Id 1141 for retail product','2023-03-08 16:43:43','',''),('1','311',2199,'','20','3',4320.00,0.00,'Retail Sale Id 1142 for 6.00 KG of Cooking Gas @ N720.00','2023-03-08 16:44:47','',''),('1','311',2200,'','6.1','4',0.00,4320.00,'Retail Sale Id 1142 for retail product','2023-03-08 16:44:47','',''),('1','311',2201,'','20','3',2160.00,0.00,'Retail Sale Id 1143 for 3.00 KG of Cooking Gas @ N720.00','2023-03-08 16:45:43','',''),('1','311',2202,'','6.1','4',0.00,2160.00,'Retail Sale Id 1143 for retail product','2023-03-08 16:45:43','',''),('1','311',2203,'','20','3',3000.00,0.00,'Retail Sale Id 1144 for 4.17 KG of Cooking Gas @ N720.00','2023-03-08 16:46:43','',''),('1','311',2204,'','6.1','4',0.00,3000.00,'Retail Sale Id 1144 for retail product','2023-03-08 16:46:43','',''),('1','311',2205,'','20','3',2300.00,0.00,'Retail Sale Id 1146 for 3.19 KG of Cooking Gas @ N720.00','2023-03-08 16:49:34','',''),('1','311',2206,'','6.1','4',0.00,2300.00,'Retail Sale Id 1146 for retail product','2023-03-08 16:49:34','',''),('1','311',2207,'','20','3',2160.00,0.00,'Retail Sale Id 1147 for 3.00 KG of Cooking Gas @ N720.00','2023-03-08 16:55:18','',''),('1','311',2208,'','6.1','4',0.00,2160.00,'Retail Sale Id 1147 for retail product','2023-03-08 16:55:18','',''),('1','311',2209,'','20','3',720.00,0.00,'Retail Sale Id 1148 for 1.00 KG of Cooking Gas @ N720.00','2023-03-08 16:57:55','',''),('1','311',2210,'','6.1','4',0.00,720.00,'Retail Sale Id 1148 for retail product','2023-03-08 16:57:55','',''),('1','311',2211,'','20','3',2000.00,0.00,'Retail Sale Id 1149 for 2.78 KG of Cooking Gas @ N720.00','2023-03-08 16:59:14','',''),('1','311',2212,'','6.1','4',0.00,2000.00,'Retail Sale Id 1149 for retail product','2023-03-08 16:59:14','',''),('1','311',2213,'','20','3',1000.00,0.00,'Retail Sale Id 1150 for 1.39 KG of Cooking Gas @ N720.00','2023-03-08 17:01:00','',''),('1','311',2214,'','6.1','4',0.00,1000.00,'Retail Sale Id 1150 for retail product','2023-03-08 17:01:00','',''),('1','311',2215,'','20','3',1000.00,0.00,'Retail Sale Id 1152 for 1.39 KG of Cooking Gas @ N720.00','2023-03-08 17:06:18','',''),('1','311',2216,'','6.1','4',0.00,1000.00,'Retail Sale Id 1152 for retail product','2023-03-08 17:06:18','',''),('1','311',2217,'','20','3',5040.00,0.00,'Retail Sale Id 1153 for 7.00 KG of Cooking Gas @ N720.00','2023-03-08 17:10:03','',''),('1','311',2218,'','6.1','4',0.00,5040.00,'Retail Sale Id 1153 for retail product','2023-03-08 17:10:03','',''),('1','311',2219,'','20','3',0.00,14400.00,'Return of Retail Sale Id 1104 for products','2023-03-08 17:35:04','',''),('1','311',2220,'','','',14400.00,0.00,'Return of Retail Sale Id 1104 for products','2023-03-08 17:35:04','',''),('1','311',2221,'','20','3',10080.00,0.00,'Retail Sale Id 1154 for 14.00 KG of Cooking Gas @ N720.00','2023-03-08 17:35:54','',''),('1','311',2222,'','6.1','4',0.00,10080.00,'Retail Sale Id 1154 for retail product','2023-03-08 17:35:54','',''),('1','311',2223,'','20','3',4320.00,0.00,'Retail Sale Id 1155 for 6.00 KG of Cooking Gas @ N720.00','2023-03-08 17:36:39','',''),('1','311',2224,'','6.1','4',0.00,4320.00,'Retail Sale Id 1155 for retail product','2023-03-08 17:36:39','',''),('1','311',2225,'','20','3',0.00,0.00,'Sales from shift 23 on 2023-03-08 19:01:47 ','2023-03-08 19:01:47','',''),('1','311',2226,'','6.1','4',0.00,0.00,'Sales from shift 23 on 2023-03-08 19:01:47 ','2023-03-08 19:01:47','',''),('1','311',2227,'','20','3',3500.00,0.00,'Retail Sale Id 1156 for 5.07 KG of Cooking Gas @ N690.00','2023-03-09 09:16:38','',''),('1','311',2228,'','6.1','4',0.00,3500.00,'Retail Sale Id 1156 for retail product','2023-03-09 09:16:38','',''),('1','311',2229,'','20','3',4140.00,0.00,'Retail Sale Id 1158 for 6.00 KG of Cooking Gas @ N690.00','2023-03-09 09:18:55','',''),('1','311',2230,'','6.1','4',0.00,4140.00,'Retail Sale Id 1158 for retail product','2023-03-09 09:18:55','',''),('1','311',2231,'','20','3',3450.00,0.00,'Retail Sale Id 1159 for 5.00 KG of Cooking Gas @ N690.00','2023-03-09 09:20:31','',''),('1','311',2232,'','6.1','4',0.00,3450.00,'Retail Sale Id 1159 for retail product','2023-03-09 09:20:31','',''),('1','311',2233,'','20','3',1920.00,0.00,'Retail Sale Id 1160 for 2.78 KG of Cooking Gas @ N690.00','2023-03-09 09:23:24','',''),('1','311',2234,'','6.1','4',0.00,1920.00,'Retail Sale Id 1160 for retail product','2023-03-09 09:23:24','',''),('1','311',2235,'','20','3',2070.00,0.00,'Retail Sale Id 1161 for 3.00 KG of Cooking Gas @ N690.00','2023-03-09 09:24:34','',''),('1','311',2236,'','6.1','4',0.00,2070.00,'Retail Sale Id 1161 for retail product','2023-03-09 09:24:34','',''),('1','311',2237,'','20','3',4830.00,0.00,'Retail Sale Id 1162 for 7.00 KG of Cooking Gas @ N690.00','2023-03-09 09:25:26','',''),('1','311',2238,'','6.1','4',0.00,4830.00,'Retail Sale Id 1162 for retail product','2023-03-09 09:25:26','',''),('1','311',2239,'','20','3',2870.40,0.00,'Retail Sale Id 1163 for 4.16 KG of Cooking Gas @ N690.00','2023-03-09 09:26:58','',''),('1','311',2240,'','6.1','4',0.00,2870.40,'Retail Sale Id 1163 for retail product','2023-03-09 09:26:58','',''),('1','311',2241,'','20','3',1380.00,0.00,'Retail Sale Id 1164 for 2.00 KG of Cooking Gas @ N690.00','2023-03-09 09:27:44','',''),('1','311',2242,'','6.1','4',0.00,1380.00,'Retail Sale Id 1164 for retail product','2023-03-09 09:27:45','',''),('1','311',2243,'','20','3',1911.30,0.00,'Retail Sale Id 1165 for 2.77 KG of Cooking Gas @ N690.00','2023-03-09 09:29:12','',''),('1','311',2244,'','6.1','4',0.00,1911.30,'Retail Sale Id 1165 for retail product','2023-03-09 09:29:12','',''),('1','311',2245,'','20','3',4140.00,0.00,'Retail Sale Id 1166 for 6.00 KG of Cooking Gas @ N690.00','2023-03-09 09:31:07','',''),('1','311',2246,'','6.1','4',0.00,4140.00,'Retail Sale Id 1166 for retail product','2023-03-09 09:31:07','',''),('1','311',2247,'','20','3',4140.00,0.00,'Retail Sale Id 1167 for 6.00 KG of Cooking Gas @ N690.00','2023-03-09 09:32:07','',''),('1','311',2248,'','6.1','4',0.00,4140.00,'Retail Sale Id 1167 for retail product','2023-03-09 09:32:07','',''),('1','311',2249,'','20','3',2760.00,0.00,'Retail Sale Id 1168 for 4.00 KG of Cooking Gas @ N690.00','2023-03-09 09:32:57','',''),('1','311',2250,'','6.1','4',0.00,2760.00,'Retail Sale Id 1168 for retail product','2023-03-09 09:32:57','',''),('1','311',2251,'','20','3',2394.30,0.00,'Retail Sale Id 1169 for 3.47 KG of Cooking Gas @ N690.00','2023-03-09 09:34:25','',''),('1','311',2252,'','6.1','4',0.00,2394.30,'Retail Sale Id 1169 for retail product','2023-03-09 09:34:25','',''),('1','311',2253,'','20','3',4140.00,0.00,'Retail Sale Id 1170 for 6.00 KG of Cooking Gas @ N690.00','2023-03-09 09:35:45','',''),('1','311',2254,'','6.1','4',0.00,4140.00,'Retail Sale Id 1170 for retail product','2023-03-09 09:35:45','',''),('1','311',2255,'','20','3',6900.00,0.00,'Retail Sale Id 1171 for 10.00 KG of Cooking Gas @ N690.00','2023-03-09 09:36:39','',''),('1','311',2256,'','6.1','4',0.00,6900.00,'Retail Sale Id 1171 for retail product','2023-03-09 09:36:39','',''),('1','311',2257,'','20','3',2870.40,0.00,'Retail Sale Id 1172 for 4.16 KG of Cooking Gas @ N690.00','2023-03-09 09:37:57','',''),('1','311',2258,'','6.1','4',0.00,2870.40,'Retail Sale Id 1172 for retail product','2023-03-09 09:37:57','',''),('1','311',2259,'','20','3',2070.00,0.00,'Retail Sale Id 1173 for 3.00 KG of Cooking Gas @ N690.00','2023-03-09 09:39:35','',''),('1','311',2260,'','6.1','4',0.00,2070.00,'Retail Sale Id 1173 for retail product','2023-03-09 09:39:35','',''),('1','311',2261,'','20','3',0.00,2870.40,'Return of Retail Sale Id 1163 for products','2023-03-09 14:21:40','',''),('1','311',2262,'','','',2870.40,0.00,'Return of Retail Sale Id 1163 for products','2023-03-09 14:21:40','',''),('1','311',2263,'','20','3',0.00,2870.40,'Return of Retail Sale Id 1172 for products','2023-03-09 14:22:48','',''),('1','311',2264,'','','',2870.40,0.00,'Return of Retail Sale Id 1172 for products','2023-03-09 14:22:48','',''),('1','311',2265,'','20','3',0.00,2394.30,'Return of Retail Sale Id 1169 for products','2023-03-09 14:24:39','',''),('1','311',2266,'','','',2394.30,0.00,'Return of Retail Sale Id 1169 for products','2023-03-09 14:24:39','',''),('1','311',2267,'','20','3',0.00,1911.30,'Return of Retail Sale Id 1165 for products','2023-03-09 14:25:25','',''),('1','311',2268,'','','',1911.30,0.00,'Return of Retail Sale Id 1165 for products','2023-03-09 14:25:25','',''),('1','311',2269,'','20','3',8625.00,0.00,'Retail Sale Id 1174 for 12.50 KG of Cooking Gas @ N690.00','2023-03-09 14:28:43','',''),('1','311',2270,'','6.1','4',0.00,8625.00,'Retail Sale Id 1174 for retail product','2023-03-09 14:28:43','',''),('1','311',2271,'','20','3',1440.00,0.00,'Retail Sale Id 1175 for 2.09 KG of Cooking Gas @ N690.00','2023-03-09 14:30:49','',''),('1','311',2272,'','6.1','4',0.00,1440.00,'Retail Sale Id 1175 for retail product','2023-03-09 14:30:49','',''),('1','311',2273,'','20','3',2070.00,0.00,'Retail Sale Id 1176 for 3.00 KG of Cooking Gas @ N690.00','2023-03-09 14:33:20','',''),('1','311',2274,'','6.1','4',0.00,2070.00,'Retail Sale Id 1176 for retail product','2023-03-09 14:33:20','',''),('1','311',2275,'','20','3',3450.00,0.00,'Retail Sale Id 1177 for 5.00 KG of Cooking Gas @ N690.00','2023-03-09 14:38:39','',''),('1','311',2276,'','6.1','4',0.00,3450.00,'Retail Sale Id 1177 for retail product','2023-03-09 14:38:39','',''),('1','311',2277,'','20','3',7590.00,0.00,'Retail Sale Id 1178 for 11.00 KG of Cooking Gas @ N690.00','2023-03-09 14:40:08','',''),('1','311',2278,'','6.1','4',0.00,7590.00,'Retail Sale Id 1178 for retail product','2023-03-09 14:40:08','',''),('1','311',2279,'','20','3',8280.00,0.00,'Retail Sale Id 1179 for 12.00 KG of Cooking Gas @ N690.00','2023-03-09 14:41:27','',''),('1','311',2280,'','6.1','4',0.00,8280.00,'Retail Sale Id 1179 for retail product','2023-03-09 14:41:27','',''),('1','311',2281,'','20','3',3090.00,0.00,'Retail Sale Id 1180 for 4.48 KG of Cooking Gas @ N690.00','2023-03-09 14:45:49','',''),('1','311',2282,'','6.1','4',0.00,3090.00,'Retail Sale Id 1180 for retail product','2023-03-09 14:45:49','',''),('1','311',2283,'','20','3',2760.00,0.00,'Retail Sale Id 1181 for 4.00 KG of Cooking Gas @ N690.00','2023-03-09 14:46:55','',''),('1','311',2284,'','6.1','4',0.00,2760.00,'Retail Sale Id 1181 for retail product','2023-03-09 14:46:55','',''),('1','311',2285,'','20','3',5730.00,0.00,'Retail Sale Id 1182 for 8.30 KG of Cooking Gas @ N690.00','2023-03-09 14:48:19','',''),('1','311',2286,'','6.1','4',0.00,5730.00,'Retail Sale Id 1182 for retail product','2023-03-09 14:48:19','',''),('1','311',2287,'','20','3',3450.00,0.00,'Retail Sale Id 1183 for 5.00 KG of Cooking Gas @ N690.00','2023-03-09 14:48:57','',''),('1','311',2288,'','6.1','4',0.00,3450.00,'Retail Sale Id 1183 for retail product','2023-03-09 14:48:57','',''),('1','311',2289,'','20','3',6900.00,0.00,'Retail Sale Id 1184 for 10.00 KG of Cooking Gas @ N690.00','2023-03-09 14:50:57','',''),('1','311',2290,'','6.1','4',0.00,6900.00,'Retail Sale Id 1184 for retail product','2023-03-09 14:50:57','',''),('1','311',2291,'','20','3',3795.00,0.00,'Retail Sale Id 1185 for 5.50 KG of Cooking Gas @ N690.00','2023-03-09 14:53:11','',''),('1','311',2292,'','6.1','4',0.00,3795.00,'Retail Sale Id 1185 for retail product','2023-03-09 14:53:11','',''),('1','311',2293,'','20','3',8625.00,0.00,'Retail Sale Id 1186 for 12.50 KG of Cooking Gas @ N690.00','2023-03-09 14:56:38','',''),('1','311',2294,'','6.1','4',0.00,8625.00,'Retail Sale Id 1186 for retail product','2023-03-09 14:56:38','',''),('1','311',2295,'','20','3',15525.00,0.00,'Retail Sale Id 1187 for multiple products','2023-03-09 15:00:47','',''),('1','311',2296,'','6.1','4',0.00,15525.00,'Retail Sale Id 1187 for retail product','2023-03-09 15:00:47','',''),('1','311',2297,'','20','3',6210.00,0.00,'Retail Sale Id 1188 for 9.00 KG of Cooking Gas @ N690.00','2023-03-09 15:01:32','',''),('1','311',2298,'','6.1','4',0.00,6210.00,'Retail Sale Id 1188 for retail product','2023-03-09 15:01:32','',''),('1','311',2299,'','20','3',6900.00,0.00,'Retail Sale Id 1189 for 10.00 KG of Cooking Gas @ N690.00','2023-03-09 15:03:08','',''),('1','311',2300,'','6.1','4',0.00,6900.00,'Retail Sale Id 1189 for retail product','2023-03-09 15:03:08','',''),('1','311',2301,'','20','3',6900.00,0.00,'Retail Sale Id 1190 for 10.00 KG of Cooking Gas @ N690.00','2023-03-09 15:03:57','',''),('1','311',2302,'','6.1','4',0.00,6900.00,'Retail Sale Id 1190 for retail product','2023-03-09 15:03:57','',''),('1','311',2303,'','20','3',4140.00,0.00,'Retail Sale Id 1191 for 6.00 KG of Cooking Gas @ N690.00','2023-03-09 16:48:09','',''),('1','311',2304,'','6.1','4',0.00,4140.00,'Retail Sale Id 1191 for retail product','2023-03-09 16:48:09','',''),('1','311',2305,'','20','3',10350.00,0.00,'Retail Sale Id 1192 for 15.00 KG of Cooking Gas @ N690.00','2023-03-09 16:49:47','',''),('1','311',2306,'','6.1','4',0.00,10350.00,'Retail Sale Id 1192 for retail product','2023-03-09 16:49:47','',''),('1','311',2307,'','20','3',5520.00,0.00,'Retail Sale Id 1193 for 8.00 KG of Cooking Gas @ N690.00','2023-03-09 16:51:02','',''),('1','311',2308,'','6.1','4',0.00,5520.00,'Retail Sale Id 1193 for retail product','2023-03-09 16:51:02','',''),('1','311',2309,'','20','3',2800.00,0.00,'Retail Sale Id 1194 for 4.06 KG of Cooking Gas @ N690.00','2023-03-09 17:02:20','',''),('1','311',2310,'','6.1','4',0.00,2800.00,'Retail Sale Id 1194 for retail product','2023-03-09 17:02:20','',''),('1','311',2311,'','2','15',25713.20,0.00,'Payment Id 52 for invoice:21, receipt: 0041 by AA RANO NIGERIA LTD','2023-03-09 17:03:16','',''),('1','311',2312,'','supplier','1',0.00,25713.20,'Payment Id 52 for invoice:21, receipt: 0041 by AA RANO NIGERIA LTD','2023-03-09 17:03:16','',''),('1','311',2313,'','2','15',38700.80,0.00,'Payment Id 49 for invoice:20, receipt: 0039 by AA RANO NIGERIA LTD','2023-03-09 17:03:45','',''),('1','311',2314,'','supplier','1',0.00,38700.80,'Payment Id 49 for invoice:20, receipt: 0039 by AA RANO NIGERIA LTD','2023-03-09 17:03:45','',''),('1','311',2315,'','20','3',4485.00,0.00,'Retail Sale Id 1195 for 6.50 KG of Cooking Gas @ N690.00','2023-03-09 17:06:03','',''),('1','311',2316,'','6.1','4',0.00,4485.00,'Retail Sale Id 1195 for retail product','2023-03-09 17:06:03','',''),('1','311',2317,'','2','20',612603.00,0.00,'Payment Id 57 for invoice:22, receipt: 0050 by AA RANO NIGERIA LTD','2023-03-09 17:06:22','',''),('1','311',2318,'','supplier','1',0.00,612603.00,'Payment Id 57 for invoice:22, receipt: 0050 by AA RANO NIGERIA LTD','2023-03-09 17:06:22','',''),('1','311',2319,'','2','9',5760.00,0.00,'Payment Id 56 for invoice:22, receipt: 50 by AA RANO NIGERIA LTD','2023-03-09 17:06:22','',''),('1','311',2320,'','supplier','1',0.00,5760.00,'Payment Id 56 for invoice:22, receipt: 50 by AA RANO NIGERIA LTD','2023-03-09 17:06:22','',''),('1','311',2321,'','20','3',4140.00,0.00,'Retail Sale Id 1196 for 6.00 KG of Cooking Gas @ N690.00','2023-03-09 17:07:15','',''),('1','311',2322,'','6.1','4',0.00,4140.00,'Retail Sale Id 1196 for retail product','2023-03-09 17:07:15','',''),('1','311',2323,'','20','3',6900.00,0.00,'Retail Sale Id 1197 for 10.00 KG of Cooking Gas @ N690.00','2023-03-09 17:08:15','',''),('1','311',2324,'','6.1','4',0.00,6900.00,'Retail Sale Id 1197 for retail product','2023-03-09 17:08:15','',''),('1','311',2325,'','20','3',8625.00,0.00,'Retail Sale Id 1198 for 12.50 KG of Cooking Gas @ N690.00','2023-03-09 17:09:10','',''),('1','311',2326,'','6.1','4',0.00,8625.00,'Retail Sale Id 1198 for retail product','2023-03-09 17:09:10','',''),('1','311',2327,'','20','3',500.00,0.00,'Retail Sale Id 1199 for 0.72 KG of Cooking Gas @ N690.00','2023-03-09 17:11:33','',''),('1','311',2328,'','6.1','4',0.00,500.00,'Retail Sale Id 1199 for retail product','2023-03-09 17:11:33','',''),('1','311',2329,'','20','3',4830.00,0.00,'Retail Sale Id 1200 for 7.00 KG of Cooking Gas @ N690.00','2023-03-09 17:12:22','',''),('1','311',2330,'','6.1','4',0.00,4830.00,'Retail Sale Id 1200 for retail product','2023-03-09 17:12:22','',''),('1','311',2331,'','20','3',1380.00,0.00,'Retail Sale Id 1201 for 2.00 KG of Cooking Gas @ N690.00','2023-03-09 17:12:57','',''),('1','311',2332,'','6.1','4',0.00,1380.00,'Retail Sale Id 1201 for retail product','2023-03-09 17:12:57','',''),('1','311',2333,'','20','3',8625.00,0.00,'Retail Sale Id 1202 for 12.50 KG of Cooking Gas @ N690.00','2023-03-09 17:49:03','',''),('1','311',2334,'','6.1','4',0.00,8625.00,'Retail Sale Id 1202 for retail product','2023-03-09 17:49:03','',''),('1','311',2335,'','20','3',2070.00,0.00,'Retail Sale Id 1203 for 3.00 KG of Cooking Gas @ N690.00','2023-03-09 17:49:46','',''),('1','311',2336,'','6.1','4',0.00,2070.00,'Retail Sale Id 1203 for retail product','2023-03-09 17:49:46','',''),('1','311',2337,'','20','3',1800.00,0.00,'Retail Sale Id 1204 for 2.61 KG of Cooking Gas @ N690.00','2023-03-09 17:51:20','',''),('1','311',2338,'','6.1','4',0.00,1800.00,'Retail Sale Id 1204 for retail product','2023-03-09 17:51:20','',''),('1','311',2339,'','20','3',8625.00,0.00,'Retail Sale Id 1205 for 12.50 KG of Cooking Gas @ N690.00','2023-03-09 17:56:01','',''),('1','311',2340,'','6.1','4',0.00,8625.00,'Retail Sale Id 1205 for retail product','2023-03-09 17:56:01','',''),('1','311',2341,'','20','3',7800.00,0.00,'Retail Sale Id 1207 for 11.30 KG of Cooking Gas @ N690.00','2023-03-09 18:00:08','',''),('1','311',2342,'','6.1','4',0.00,7800.00,'Retail Sale Id 1207 for retail product','2023-03-09 18:00:08','',''),('1','311',2343,'','20','3',8625.00,0.00,'Retail Sale Id 1208 for 12.50 KG of Cooking Gas @ N690.00','2023-03-09 18:01:21','',''),('1','311',2344,'','6.1','4',0.00,8625.00,'Retail Sale Id 1208 for retail product','2023-03-09 18:01:21','',''),('1','311',2345,'','20','3',8120.00,0.00,'Retail Sale Id 1210 for 11.77 KG of Cooking Gas @ N690.00','2023-03-09 18:11:46','',''),('1','311',2346,'','6.1','4',0.00,8120.00,'Retail Sale Id 1210 for retail product','2023-03-09 18:11:46','',''),('1','311',2347,'','20','3',2070.00,0.00,'Retail Sale Id 1211 for 3.00 KG of Cooking Gas @ N690.00','2023-03-09 18:25:11','',''),('1','311',2348,'','6.1','4',0.00,2070.00,'Retail Sale Id 1211 for retail product','2023-03-09 18:25:11','',''),('1','311',2349,'','20','3',0.00,1920.00,'Return of Retail Sale Id 1160 for products','2023-03-09 18:26:13','',''),('1','311',2350,'','','',1920.00,0.00,'Return of Retail Sale Id 1160 for products','2023-03-09 18:26:13','',''),('1','311',2351,'','20','3',0.00,0.00,'Sales from shift 24 on 2023-03-09 18:28:39 ','2023-03-09 18:28:39','',''),('1','311',2352,'','6.1','4',0.00,0.00,'Sales from shift 24 on 2023-03-09 18:28:39 ','2023-03-09 18:28:39','',''),('1','311',2353,'','20','3',4140.00,0.00,'Retail Sale Id 1212 for 6.00 KG of Cooking Gas @ N690.00','2023-03-10 07:54:21','',''),('1','311',2354,'','6.1','4',0.00,4140.00,'Retail Sale Id 1212 for retail product','2023-03-10 07:54:21','',''),('1','311',2355,'','20','3',4140.00,0.00,'Retail Sale Id 1213 for 6.00 KG of Cooking Gas @ N690.00','2023-03-10 08:04:09','',''),('1','311',2356,'','6.1','4',0.00,4140.00,'Retail Sale Id 1213 for retail product','2023-03-10 08:04:09','',''),('1','311',2357,'','20','3',8280.00,0.00,'Retail Sale Id 1214 for 12.00 KG of Cooking Gas @ N690.00','2023-03-10 08:05:44','',''),('1','311',2358,'','6.1','4',0.00,8280.00,'Retail Sale Id 1214 for retail product','2023-03-10 08:05:44','',''),('1','311',2359,'','20','3',1380.00,0.00,'Retail Sale Id 1215 for 2.00 KG of Cooking Gas @ N690.00','2023-03-10 08:07:11','',''),('1','311',2360,'','6.1','4',0.00,1380.00,'Retail Sale Id 1215 for retail product','2023-03-10 08:07:11','',''),('1','311',2361,'','20','3',4485.00,0.00,'Retail Sale Id 1216 for 6.50 KG of Cooking Gas @ N690.00','2023-03-10 08:09:34','',''),('1','311',2362,'','6.1','4',0.00,4485.00,'Retail Sale Id 1216 for retail product','2023-03-10 08:09:34','',''),('1','311',2363,'','20','3',2760.00,0.00,'Retail Sale Id 1217 for 4.00 KG of Cooking Gas @ N690.00','2023-03-10 08:35:15','',''),('1','311',2364,'','6.1','4',0.00,2760.00,'Retail Sale Id 1217 for retail product','2023-03-10 08:35:15','',''),('1','311',2365,'','20','3',2760.00,0.00,'Retail Sale Id 1218 for 4.00 KG of Cooking Gas @ N690.00','2023-03-10 08:51:10','',''),('1','311',2366,'','6.1','4',0.00,2760.00,'Retail Sale Id 1218 for retail product','2023-03-10 08:51:10','',''),('1','311',2367,'','20','3',4000.00,0.00,'Retail Sale Id 1219 for 5.80 KG of Cooking Gas @ N690.00','2023-03-10 08:56:53','',''),('1','311',2368,'','6.1','4',0.00,4000.00,'Retail Sale Id 1219 for retail product','2023-03-10 08:56:53','',''),('1','311',2369,'','20','3',2070.00,0.00,'Retail Sale Id 1220 for 3.00 KG of Cooking Gas @ N690.00','2023-03-10 09:15:18','',''),('1','311',2370,'','6.1','4',0.00,2070.00,'Retail Sale Id 1220 for retail product','2023-03-10 09:15:18','',''),('1','311',2371,'','20','3',8625.00,0.00,'Retail Sale Id 1221 for 12.50 KG of Cooking Gas @ N690.00','2023-03-10 09:17:05','',''),('1','311',2372,'','6.1','4',0.00,8625.00,'Retail Sale Id 1221 for retail product','2023-03-10 09:17:05','',''),('1','311',2373,'','20','3',9660.00,0.00,'Retail Sale Id 1222 for multiple products','2023-03-10 09:18:38','',''),('1','311',2374,'','6.1','4',0.00,9660.00,'Retail Sale Id 1222 for retail product','2023-03-10 09:18:38','',''),('1','311',2375,'','20','3',2760.00,0.00,'Retail Sale Id 1223 for 4.00 KG of Cooking Gas @ N690.00','2023-03-10 09:20:10','',''),('1','311',2376,'','6.1','4',0.00,2760.00,'Retail Sale Id 1223 for retail product','2023-03-10 09:20:10','',''),('1','311',2377,'','20','3',3450.00,0.00,'Retail Sale Id 1224 for 5.00 KG of Cooking Gas @ N690.00','2023-03-10 09:31:47','',''),('1','311',2378,'','6.1','4',0.00,3450.00,'Retail Sale Id 1224 for retail product','2023-03-10 09:31:47','',''),('1','311',2379,'','20','3',2070.00,0.00,'Retail Sale Id 1225 for 3.00 KG of Cooking Gas @ N690.00','2023-03-10 09:34:48','',''),('1','311',2380,'','6.1','4',0.00,2070.00,'Retail Sale Id 1225 for retail product','2023-03-10 09:34:48','',''),('1','311',2381,'','20','3',2070.00,0.00,'Retail Sale Id 1226 for 3.00 KG of Cooking Gas @ N690.00','2023-03-10 09:40:32','',''),('1','311',2382,'','6.1','4',0.00,2070.00,'Retail Sale Id 1226 for retail product','2023-03-10 09:40:32','',''),('1','311',2383,'','20','3',3000.00,0.00,'Retail Sale Id 1227 for 4.35 KG of Cooking Gas @ N690.00','2023-03-10 09:49:44','',''),('1','311',2384,'','6.1','4',0.00,3000.00,'Retail Sale Id 1227 for retail product','2023-03-10 09:49:44','',''),('1','311',2385,'','20','3',3450.00,0.00,'Retail Sale Id 1228 for 5.00 KG of Cooking Gas @ N690.00','2023-03-10 09:56:28','',''),('1','311',2386,'','6.1','4',0.00,3450.00,'Retail Sale Id 1228 for retail product','2023-03-10 09:56:28','',''),('1','311',2387,'','20','3',5520.00,0.00,'Retail Sale Id 1229 for 8.00 KG of Cooking Gas @ N690.00','2023-03-10 10:10:05','',''),('1','311',2388,'','6.1','4',0.00,5520.00,'Retail Sale Id 1229 for retail product','2023-03-10 10:10:05','',''),('1','311',2389,'','20','3',2000.00,0.00,'Retail Sale Id 1230 for 2.90 KG of Cooking Gas @ N690.00','2023-03-10 10:32:18','',''),('1','311',2390,'','6.1','4',0.00,2000.00,'Retail Sale Id 1230 for retail product','2023-03-10 10:32:18','',''),('1','311',2391,'','20','3',1500.00,0.00,'Retail Sale Id 1231 for 2.17 KG of Cooking Gas @ N690.00','2023-03-10 10:34:04','',''),('1','311',2392,'','6.1','4',0.00,1500.00,'Retail Sale Id 1231 for retail product','2023-03-10 10:34:04','',''),('1','311',2393,'','20','3',4485.00,0.00,'Retail Sale Id 1233 for 6.50 KG of Cooking Gas @ N690.00','2023-03-10 10:38:34','',''),('1','311',2394,'','6.1','4',0.00,4485.00,'Retail Sale Id 1233 for retail product','2023-03-10 10:38:34','',''),('1','311',2395,'','20','3',690.00,0.00,'Retail Sale Id 1234 for 1.00 KG of Cooking Gas @ N690.00','2023-03-10 10:39:30','',''),('1','311',2396,'','6.1','4',0.00,690.00,'Retail Sale Id 1234 for retail product','2023-03-10 10:39:30','',''),('1','311',2397,'','20','3',5520.00,0.00,'Retail Sale Id 1235 for 8.00 KG of Cooking Gas @ N690.00','2023-03-10 10:55:59','',''),('1','311',2398,'','6.1','4',0.00,5520.00,'Retail Sale Id 1235 for retail product','2023-03-10 10:55:59','',''),('1','311',2399,'','20','3',3600.00,0.00,'Retail Sale Id 1236 for 5.22 KG of Cooking Gas @ N690.00','2023-03-10 10:57:54','',''),('1','311',2400,'','6.1','4',0.00,3600.00,'Retail Sale Id 1236 for retail product','2023-03-10 10:57:54','',''),('1','311',2401,'','20','3',7245.00,0.00,'Retail Sale Id 1237 for 10.50 KG of Cooking Gas @ N690.00','2023-03-10 11:09:39','',''),('1','311',2402,'','6.1','4',0.00,7245.00,'Retail Sale Id 1237 for retail product','2023-03-10 11:09:39','',''),('1','311',2403,'','20','3',3000.00,0.00,'Retail Sale Id 1240 for 4.35 KG of Cooking Gas @ N690.00','2023-03-10 11:29:40','',''),('1','311',2404,'','6.1','4',0.00,3000.00,'Retail Sale Id 1240 for retail product','2023-03-10 11:29:40','',''),('1','311',2405,'','20','3',13110.00,0.00,'Retail Sale Id 1239 for multiple products','2023-03-10 11:30:52','',''),('1','311',2406,'','6.1','4',0.00,13110.00,'Retail Sale Id 1239 for retail product','2023-03-10 11:30:52','',''),('1','311',2407,'','20','3',2070.00,0.00,'Retail Sale Id 1241 for 3.00 KG of Cooking Gas @ N690.00','2023-03-10 11:47:08','',''),('1','311',2408,'','6.1','4',0.00,2070.00,'Retail Sale Id 1241 for retail product','2023-03-10 11:47:08','',''),('1','311',2409,'','20','3',3450.00,0.00,'Retail Sale Id 1242 for 5.00 KG of Cooking Gas @ N690.00','2023-03-10 12:04:26','',''),('1','311',2410,'','6.1','4',0.00,3450.00,'Retail Sale Id 1242 for retail product','2023-03-10 12:04:26','',''),('1','311',2411,'','20','3',77720.00,0.00,'Retail Sale Id 1243 for 116.00 KG of Cooking Gas @ N670.00','2023-03-10 12:05:56','',''),('1','311',2412,'','6.1','4',0.00,77720.00,'Retail Sale Id 1243 for retail product','2023-03-10 12:05:56','',''),('1','311',2413,'','20','3',5520.00,0.00,'Retail Sale Id 1244 for 8.00 KG of Cooking Gas @ N690.00','2023-03-10 12:07:36','',''),('1','311',2414,'','6.1','4',0.00,5520.00,'Retail Sale Id 1244 for retail product','2023-03-10 12:07:36','',''),('1','311',2415,'','20','3',2760.00,0.00,'Retail Sale Id 1245 for 4.00 KG of Cooking Gas @ N690.00','2023-03-10 12:25:19','',''),('1','311',2416,'','6.1','4',0.00,2760.00,'Retail Sale Id 1245 for retail product','2023-03-10 12:25:19','',''),('1','311',2417,'','20','3',2760.00,0.00,'Retail Sale Id 1246 for 4.00 KG of Cooking Gas @ N690.00','2023-03-10 12:50:43','',''),('1','311',2418,'','6.1','4',0.00,2760.00,'Retail Sale Id 1246 for retail product','2023-03-10 12:50:43','',''),('1','311',2419,'','20','3',4000.00,0.00,'Retail Sale Id 1247 for 5.80 KG of Cooking Gas @ N690.00','2023-03-10 12:59:58','',''),('1','311',2420,'','6.1','4',0.00,4000.00,'Retail Sale Id 1247 for retail product','2023-03-10 12:59:58','',''),('1','311',2421,'','20','3',4140.00,0.00,'Retail Sale Id 1248 for 6.00 KG of Cooking Gas @ N690.00','2023-03-10 13:01:57','',''),('1','311',2422,'','6.1','4',0.00,4140.00,'Retail Sale Id 1248 for retail product','2023-03-10 13:01:57','',''),('1','311',2423,'','20','3',4140.00,0.00,'Retail Sale Id 1250 for 6.00 KG of Cooking Gas @ N690.00','2023-03-10 13:17:41','',''),('1','311',2424,'','6.1','4',0.00,4140.00,'Retail Sale Id 1250 for retail product','2023-03-10 13:17:41','',''),('1','311',2425,'','20','3',1380.00,0.00,'Retail Sale Id 1253 for 2.00 KG of Cooking Gas @ N690.00','2023-03-10 13:23:09','',''),('1','311',2426,'','6.1','4',0.00,1380.00,'Retail Sale Id 1253 for retail product','2023-03-10 13:23:09','',''),('1','311',2427,'','20','3',3450.00,0.00,'Retail Sale Id 1252 for 5.00 KG of Cooking Gas @ N690.00','2023-03-10 13:23:36','',''),('1','311',2428,'','6.1','4',0.00,3450.00,'Retail Sale Id 1252 for retail product','2023-03-10 13:23:36','',''),('1','311',2429,'','20','3',8625.00,0.00,'Retail Sale Id 1254 for 12.50 KG of Cooking Gas @ N690.00','2023-03-10 13:25:11','',''),('1','311',2430,'','6.1','4',0.00,8625.00,'Retail Sale Id 1254 for retail product','2023-03-10 13:25:11','',''),('1','311',2431,'','20','3',8625.00,0.00,'Retail Sale Id 1255 for 12.50 KG of Cooking Gas @ N690.00','2023-03-10 13:27:44','',''),('1','311',2432,'','6.1','4',0.00,8625.00,'Retail Sale Id 1255 for retail product','2023-03-10 13:27:44','',''),('1','311',2433,'','20','3',2760.00,0.00,'Retail Sale Id 1256 for 4.00 KG of Cooking Gas @ N690.00','2023-03-10 13:28:30','',''),('1','311',2434,'','6.1','4',0.00,2760.00,'Retail Sale Id 1256 for retail product','2023-03-10 13:28:30','',''),('1','311',2435,'','2','15',23759.00,0.00,'Payment Id 47 for invoice:19, receipt: 0038 by AA RANO NIGERIA LTD','2023-03-10 13:43:05','',''),('1','311',2436,'','supplier','1',0.00,23759.00,'Payment Id 47 for invoice:19, receipt: 0038 by AA RANO NIGERIA LTD','2023-03-10 13:43:05','',''),('1','311',2437,'','2','15',21280.00,0.00,'Payment Id 46 for invoice:2, receipt: 001 by AA RANO NIGERIA LTD','2023-03-10 13:43:05','',''),('1','311',2438,'','supplier','1',0.00,21280.00,'Payment Id 46 for invoice:2, receipt: 001 by AA RANO NIGERIA LTD','2023-03-10 13:43:05','',''),('1','311',2439,'','20','3',8625.00,0.00,'Retail Sale Id 1257 for 12.50 KG of Cooking Gas @ N690.00','2023-03-10 13:43:39','',''),('1','311',2440,'','6.1','4',0.00,8625.00,'Retail Sale Id 1257 for retail product','2023-03-10 13:43:39','',''),('1','311',2441,'','2','15',20027.20,0.00,'Payment Id 43 for invoice:18, receipt: 0037 by AA RANO NIGERIA LTD','2023-03-10 13:45:09','',''),('1','311',2442,'','supplier','1',0.00,20027.20,'Payment Id 43 for invoice:18, receipt: 0037 by AA RANO NIGERIA LTD','2023-03-10 13:45:09','',''),('1','311',2443,'','2','15',88704.00,0.00,'Payment Id 40 for invoice:17, receipt: 0034 by AA RANO NIGERIA LTD','2023-03-10 13:45:09','',''),('1','311',2444,'','supplier','1',0.00,88704.00,'Payment Id 40 for invoice:17, receipt: 0034 by AA RANO NIGERIA LTD','2023-03-10 13:45:09','',''),('1','311',2445,'','20','3',3450.00,0.00,'Retail Sale Id 1258 for 5.00 KG of Cooking Gas @ N690.00','2023-03-10 14:03:43','',''),('1','311',2446,'','6.1','4',0.00,3450.00,'Retail Sale Id 1258 for retail product','2023-03-10 14:03:43','',''),('1','311',2447,'','20','3',3450.00,0.00,'Retail Sale Id 1259 for multiple products','2023-03-10 14:08:25','',''),('1','311',2448,'','6.1','4',0.00,3450.00,'Retail Sale Id 1259 for retail product','2023-03-10 14:08:25','',''),('1','311',2449,'','20','3',2070.00,0.00,'Retail Sale Id 1260 for 3.00 KG of Cooking Gas @ N690.00','2023-03-10 14:21:38','',''),('1','311',2450,'','6.1','4',0.00,2070.00,'Retail Sale Id 1260 for retail product','2023-03-10 14:21:38','',''),('1','311',2451,'','20','3',2760.00,0.00,'Retail Sale Id 1261 for multiple products','2023-03-10 14:28:48','',''),('1','311',2452,'','6.1','4',0.00,2760.00,'Retail Sale Id 1261 for retail product','2023-03-10 14:28:48','',''),('1','311',2453,'','20','3',8625.00,0.00,'Retail Sale Id 1262 for 12.50 KG of Cooking Gas @ N690.00','2023-03-10 15:04:43','',''),('1','311',2454,'','6.1','4',0.00,8625.00,'Retail Sale Id 1262 for retail product','2023-03-10 15:04:43','',''),('1','311',2455,'','20','3',8625.00,0.00,'Retail Sale Id 1263 for 12.50 KG of Cooking Gas @ N690.00','2023-03-10 15:05:43','',''),('1','311',2456,'','6.1','4',0.00,8625.00,'Retail Sale Id 1263 for retail product','2023-03-10 15:05:43','',''),('1','311',2457,'','20','3',2760.00,0.00,'Retail Sale Id 1264 for 4.00 KG of Cooking Gas @ N690.00','2023-03-10 15:08:17','',''),('1','311',2458,'','6.1','4',0.00,2760.00,'Retail Sale Id 1264 for retail product','2023-03-10 15:08:17','',''),('1','311',2459,'','20','3',5520.00,0.00,'Retail Sale Id 1265 for 8.00 KG of Cooking Gas @ N690.00','2023-03-10 15:26:30','',''),('1','311',2460,'','6.1','4',0.00,5520.00,'Retail Sale Id 1265 for retail product','2023-03-10 15:26:30','',''),('1','311',2461,'','20','3',1000.00,0.00,'Retail Sale Id 1266 for 1.45 KG of Cooking Gas @ N690.00','2023-03-10 15:28:09','',''),('1','311',2462,'','6.1','4',0.00,1000.00,'Retail Sale Id 1266 for retail product','2023-03-10 15:28:09','',''),('1','311',2463,'','20','3',2070.00,0.00,'Retail Sale Id 1267 for 3.00 KG of Cooking Gas @ N690.00','2023-03-10 15:28:58','',''),('1','311',2464,'','6.1','4',0.00,2070.00,'Retail Sale Id 1267 for retail product','2023-03-10 15:28:58','',''),('1','311',2465,'','20','3',4830.00,0.00,'Retail Sale Id 1268 for 7.00 KG of Cooking Gas @ N690.00','2023-03-10 15:39:15','',''),('1','311',2466,'','6.1','4',0.00,4830.00,'Retail Sale Id 1268 for retail product','2023-03-10 15:39:15','',''),('1','311',2467,'','2','20',197201.00,0.00,'Payment Id 61 for invoice:23, receipt: 0052 by AA RANO NIGERIA LTD','2023-03-10 15:57:40','',''),('1','311',2468,'','supplier','1',0.00,197201.00,'Payment Id 61 for invoice:23, receipt: 0052 by AA RANO NIGERIA LTD','2023-03-10 15:57:40','',''),('1','311',2469,'','2','9',22701.00,0.00,'Payment Id 60 for invoice:23, receipt: 0052 by AA RANO NIGERIA LTD','2023-03-10 15:57:40','',''),('1','311',2470,'','supplier','1',0.00,22701.00,'Payment Id 60 for invoice:23, receipt: 0052 by AA RANO NIGERIA LTD','2023-03-10 15:57:40','',''),('1','311',2471,'','2','20',186561.00,0.00,'Payment Id 64 for invoice:24, receipt: 0054 by AA RANO NIGERIA LTD','2023-03-10 15:58:26','',''),('1','311',2472,'','supplier','1',0.00,186561.00,'Payment Id 64 for invoice:24, receipt: 0054 by AA RANO NIGERIA LTD','2023-03-10 15:58:26','',''),('1','311',2473,'','2','9',37811.01,0.00,'Payment Id 63 for invoice:24, receipt: 0053 by AA RANO NIGERIA LTD','2023-03-10 15:58:26','',''),('1','311',2474,'','supplier','1',0.00,37811.01,'Payment Id 63 for invoice:24, receipt: 0053 by AA RANO NIGERIA LTD','2023-03-10 15:58:26','',''),('1','311',2475,'','20','3',3000.00,0.00,'Retail Sale Id 1269 for 4.35 KG of Cooking Gas @ N690.00','2023-03-10 16:28:29','',''),('1','311',2476,'','6.1','4',0.00,3000.00,'Retail Sale Id 1269 for retail product','2023-03-10 16:28:29','',''),('1','311',2477,'','20','3',2760.00,0.00,'Retail Sale Id 1270 for 4.00 KG of Cooking Gas @ N690.00','2023-03-10 16:45:36','',''),('1','311',2478,'','6.1','4',0.00,2760.00,'Retail Sale Id 1270 for retail product','2023-03-10 16:45:36','',''),('1','311',2479,'','20','3',1380.00,0.00,'Retail Sale Id 1271 for 2.00 KG of Cooking Gas @ N690.00','2023-03-10 16:47:43','',''),('1','311',2480,'','6.1','4',0.00,1380.00,'Retail Sale Id 1271 for retail product','2023-03-10 16:47:43','',''),('1','311',2481,'','20','3',1500.00,0.00,'Retail Sale Id 1272 for 2.17 KG of Cooking Gas @ N690.00','2023-03-10 17:05:46','',''),('1','311',2482,'','6.1','4',0.00,1500.00,'Retail Sale Id 1272 for retail product','2023-03-10 17:05:46','',''),('1','311',2483,'','20','3',2070.00,0.00,'Retail Sale Id 1274 for 3.00 KG of Cooking Gas @ N690.00','2023-03-10 17:11:22','',''),('1','311',2484,'','6.1','4',0.00,2070.00,'Retail Sale Id 1274 for retail product','2023-03-10 17:11:23','',''),('1','311',2485,'','20','3',1380.00,0.00,'Retail Sale Id 1276 for 2.00 KG of Cooking Gas @ N690.00','2023-03-10 17:32:55','',''),('1','311',2486,'','6.1','4',0.00,1380.00,'Retail Sale Id 1276 for retail product','2023-03-10 17:32:55','',''),('1','311',2487,'','20','3',4140.00,0.00,'Retail Sale Id 1277 for 6.00 KG of Cooking Gas @ N690.00','2023-03-10 17:35:42','',''),('1','311',2488,'','6.1','4',0.00,4140.00,'Retail Sale Id 1277 for retail product','2023-03-10 17:35:42','',''),('1','311',2489,'','20','3',4140.00,0.00,'Retail Sale Id 1279 for 6.00 KG of Cooking Gas @ N690.00','2023-03-10 17:52:09','',''),('1','311',2490,'','6.1','4',0.00,4140.00,'Retail Sale Id 1279 for retail product','2023-03-10 17:52:09','',''),('1','311',2491,'','20','3',2070.00,0.00,'Retail Sale Id 1280 for 3.00 KG of Cooking Gas @ N690.00','2023-03-10 17:57:22','',''),('1','311',2492,'','6.1','4',0.00,2070.00,'Retail Sale Id 1280 for retail product','2023-03-10 17:57:22','',''),('1','311',2493,'','20','3',0.00,4140.00,'Return of Retail Sale Id 1277 for products','2023-03-10 19:02:40','',''),('1','311',2494,'','','',4140.00,0.00,'Return of Retail Sale Id 1277 for products','2023-03-10 19:02:40','',''),('1','311',2495,'','20','3',3118.80,0.00,'Retail Sale Id 1281 for 4.52 KG of Cooking Gas @ N690.00','2023-03-10 19:03:34','',''),('1','311',2496,'','6.1','4',0.00,3118.80,'Retail Sale Id 1281 for retail product','2023-03-10 19:03:34','',''),('1','311',2497,'','20','3',0.00,3118.80,'Return of Retail Sale Id 1281 for products','2023-03-10 19:05:34','',''),('1','311',2498,'','','',3118.80,0.00,'Return of Retail Sale Id 1281 for products','2023-03-10 19:05:34','',''),('1','311',2499,'','20','3',3120.00,0.00,'Retail Sale Id 1282 for 4.52 KG of Cooking Gas @ N690.00','2023-03-10 19:06:18','',''),('1','311',2500,'','6.1','4',0.00,3120.00,'Retail Sale Id 1282 for retail product','2023-03-10 19:06:18','',''),('1','311',2501,'','20','3',0.00,0.00,'Sales from shift 25 on 2023-03-10 19:08:05 ','2023-03-10 19:08:05','',''),('1','311',2502,'','6.1','4',0.00,0.00,'Sales from shift 25 on 2023-03-10 19:08:05 ','2023-03-10 19:08:05','',''),('1','311',2503,'','20','3',39530.00,0.00,'Retail Sale Id 1283 for 59.00 KG of Cooking Gas @ N670.00','2023-03-11 08:21:26','',''),('1','311',2504,'','6.1','4',0.00,39530.00,'Retail Sale Id 1283 for retail product','2023-03-11 08:21:26','',''),('1','311',2505,'','20','3',6900.00,0.00,'Retail Sale Id 1284 for multiple products','2023-03-11 08:25:48','',''),('1','311',2506,'','6.1','4',0.00,6900.00,'Retail Sale Id 1284 for retail product','2023-03-11 08:25:48','',''),('1','311',2507,'','20','3',2070.00,0.00,'Retail Sale Id 1285 for 3.00 KG of Cooking Gas @ N690.00','2023-03-11 08:30:30','',''),('1','311',2508,'','6.1','4',0.00,2070.00,'Retail Sale Id 1285 for retail product','2023-03-11 08:30:30','',''),('1','311',2509,'','20','3',3450.00,0.00,'Retail Sale Id 1286 for 5.00 KG of Cooking Gas @ N690.00','2023-03-11 08:32:37','',''),('1','311',2510,'','6.1','4',0.00,3450.00,'Retail Sale Id 1286 for retail product','2023-03-11 08:32:37','',''),('1','311',2511,'','20','3',3450.00,0.00,'Retail Sale Id 1287 for 5.00 KG of Cooking Gas @ N690.00','2023-03-11 08:38:16','',''),('1','311',2512,'','6.1','4',0.00,3450.00,'Retail Sale Id 1287 for retail product','2023-03-11 08:38:16','',''),('1','311',2513,'','20','3',2760.00,0.00,'Retail Sale Id 1288 for 4.00 KG of Cooking Gas @ N690.00','2023-03-11 08:39:52','',''),('1','311',2514,'','6.1','4',0.00,2760.00,'Retail Sale Id 1288 for retail product','2023-03-11 08:39:52','',''),('1','311',2515,'','20','3',5520.00,0.00,'Retail Sale Id 1289 for 8.00 KG of Cooking Gas @ N690.00','2023-03-11 09:03:51','',''),('1','311',2516,'','6.1','4',0.00,5520.00,'Retail Sale Id 1289 for retail product','2023-03-11 09:03:51','',''),('1','311',2517,'','20','3',4140.00,0.00,'Retail Sale Id 1290 for 6.00 KG of Cooking Gas @ N690.00','2023-03-11 09:05:09','',''),('1','311',2518,'','6.1','4',0.00,4140.00,'Retail Sale Id 1290 for retail product','2023-03-11 09:05:09','',''),('1','311',2519,'','20','3',1600.00,0.00,'Retail Sale Id 1291 for 2.32 KG of Cooking Gas @ N690.00','2023-03-11 09:06:25','',''),('1','311',2520,'','6.1','4',0.00,1600.00,'Retail Sale Id 1291 for retail product','2023-03-11 09:06:25','',''),('1','311',2521,'','20','3',7000.00,0.00,'Retail Sale Id 1292 for multiple products','2023-03-11 09:09:57','',''),('1','311',2522,'','6.1','4',0.00,7000.00,'Retail Sale Id 1292 for retail product','2023-03-11 09:09:57','',''),('1','311',2523,'','20','3',4830.00,0.00,'Retail Sale Id 1293 for 7.00 KG of Cooking Gas @ N690.00','2023-03-11 09:12:27','',''),('1','311',2524,'','6.1','4',0.00,4830.00,'Retail Sale Id 1293 for retail product','2023-03-11 09:12:27','',''),('1','311',2525,'','20','3',6900.00,0.00,'Retail Sale Id 1294 for 10.00 KG of Cooking Gas @ N690.00','2023-03-11 09:16:24','',''),('1','311',2526,'','6.1','4',0.00,6900.00,'Retail Sale Id 1294 for retail product','2023-03-11 09:16:24','',''),('1','311',2527,'','20','3',690.00,0.00,'Retail Sale Id 1295 for 1.00 KG of Cooking Gas @ N690.00','2023-03-11 09:17:25','',''),('1','311',2528,'','6.1','4',0.00,690.00,'Retail Sale Id 1295 for retail product','2023-03-11 09:17:25','',''),('1','311',2529,'','20','3',2070.00,0.00,'Retail Sale Id 1296 for 3.00 KG of Cooking Gas @ N690.00','2023-03-11 09:21:12','',''),('1','311',2530,'','6.1','4',0.00,2070.00,'Retail Sale Id 1296 for retail product','2023-03-11 09:21:12','',''),('1','311',2531,'','20','3',2070.00,0.00,'Retail Sale Id 1297 for 3.00 KG of Cooking Gas @ N690.00','2023-03-11 09:29:16','',''),('1','311',2532,'','6.1','4',0.00,2070.00,'Retail Sale Id 1297 for retail product','2023-03-11 09:29:16','',''),('1','311',2533,'','20','3',3000.00,0.00,'Retail Sale Id 1298 for 4.35 KG of Cooking Gas @ N690.00','2023-03-11 09:30:17','',''),('1','311',2534,'','6.1','4',0.00,3000.00,'Retail Sale Id 1298 for retail product','2023-03-11 09:30:17','',''),('1','311',2535,'','20','3',690.00,0.00,'Retail Sale Id 1299 for 1.00 KG of Cooking Gas @ N690.00','2023-03-11 09:31:28','',''),('1','311',2536,'','6.1','4',0.00,690.00,'Retail Sale Id 1299 for retail product','2023-03-11 09:31:28','',''),('1','311',2537,'','20','3',8625.00,0.00,'Retail Sale Id 1300 for 12.50 KG of Cooking Gas @ N690.00','2023-03-11 09:32:36','',''),('1','311',2538,'','6.1','4',0.00,8625.00,'Retail Sale Id 1300 for retail product','2023-03-11 09:32:36','',''),('1','311',2539,'','20','3',3450.00,0.00,'Retail Sale Id 1301 for 5.00 KG of Cooking Gas @ N690.00','2023-03-11 09:34:34','',''),('1','311',2540,'','6.1','4',0.00,3450.00,'Retail Sale Id 1301 for retail product','2023-03-11 09:34:34','',''),('1','311',2541,'','20','3',4140.00,0.00,'Retail Sale Id 1302 for 6.00 KG of Cooking Gas @ N690.00','2023-03-11 09:38:04','',''),('1','311',2542,'','6.1','4',0.00,4140.00,'Retail Sale Id 1302 for retail product','2023-03-11 09:38:04','',''),('1','311',2543,'','20','3',1000.00,0.00,'Retail Sale Id 1303 for 1.45 KG of Cooking Gas @ N690.00','2023-03-11 09:39:54','',''),('1','311',2544,'','6.1','4',0.00,1000.00,'Retail Sale Id 1303 for retail product','2023-03-11 09:39:54','',''),('1','311',2545,'','20','3',3450.00,0.00,'Retail Sale Id 1304 for 5.00 KG of Cooking Gas @ N690.00','2023-03-11 09:40:47','',''),('1','311',2546,'','6.1','4',0.00,3450.00,'Retail Sale Id 1304 for retail product','2023-03-11 09:40:47','',''),('1','311',2547,'','20','3',1000.00,0.00,'Retail Sale Id 1305 for 1.45 KG of Cooking Gas @ N690.00','2023-03-11 09:43:49','',''),('1','311',2548,'','6.1','4',0.00,1000.00,'Retail Sale Id 1305 for retail product','2023-03-11 09:43:49','',''),('1','311',2549,'','20','3',8625.00,0.00,'Retail Sale Id 1306 for 12.50 KG of Cooking Gas @ N690.00','2023-03-11 09:52:24','',''),('1','311',2550,'','6.1','4',0.00,8625.00,'Retail Sale Id 1306 for retail product','2023-03-11 09:52:24','',''),('1','311',2551,'','20','3',4140.00,0.00,'Retail Sale Id 1307 for 6.00 KG of Cooking Gas @ N690.00','2023-03-11 09:57:30','',''),('1','311',2552,'','6.1','4',0.00,4140.00,'Retail Sale Id 1307 for retail product','2023-03-11 09:57:30','',''),('1','311',2553,'','20','3',4485.00,0.00,'Retail Sale Id 1308 for 6.50 KG of Cooking Gas @ N690.00','2023-03-11 10:00:40','',''),('1','311',2554,'','6.1','4',0.00,4485.00,'Retail Sale Id 1308 for retail product','2023-03-11 10:00:40','',''),('1','311',2555,'','20','3',1725.00,0.00,'Retail Sale Id 1309 for 2.50 KG of Cooking Gas @ N690.00','2023-03-11 10:14:52','',''),('1','311',2556,'','6.1','4',0.00,1725.00,'Retail Sale Id 1309 for retail product','2023-03-11 10:14:53','',''),('1','311',2557,'','20','3',1000.00,0.00,'Retail Sale Id 1311 for 1.45 KG of Cooking Gas @ N690.00','2023-03-11 10:20:00','',''),('1','311',2558,'','6.1','4',0.00,1000.00,'Retail Sale Id 1311 for retail product','2023-03-11 10:20:00','',''),('1','311',2559,'','20','3',2000.00,0.00,'Retail Sale Id 1312 for 2.90 KG of Cooking Gas @ N690.00','2023-03-11 10:20:28','',''),('1','311',2560,'','6.1','4',0.00,2000.00,'Retail Sale Id 1312 for retail product','2023-03-11 10:20:28','',''),('1','311',2561,'','20','3',800.00,0.00,'Retail Sale Id 1313 for 1.16 KG of Cooking Gas @ N690.00','2023-03-11 10:21:23','',''),('1','311',2562,'','6.1','4',0.00,800.00,'Retail Sale Id 1313 for retail product','2023-03-11 10:21:23','',''),('1','311',2563,'','20','3',4140.00,0.00,'Retail Sale Id 1314 for 6.00 KG of Cooking Gas @ N690.00','2023-03-11 10:24:09','',''),('1','311',2564,'','6.1','4',0.00,4140.00,'Retail Sale Id 1314 for retail product','2023-03-11 10:24:09','',''),('1','311',2565,'','20','3',2070.00,0.00,'Retail Sale Id 1315 for 3.00 KG of Cooking Gas @ N690.00','2023-03-11 10:26:03','',''),('1','311',2566,'','6.1','4',0.00,2070.00,'Retail Sale Id 1315 for retail product','2023-03-11 10:26:03','',''),('1','311',2567,'','20','3',4140.00,0.00,'Retail Sale Id 1316 for 6.00 KG of Cooking Gas @ N690.00','2023-03-11 10:27:39','',''),('1','311',2568,'','6.1','4',0.00,4140.00,'Retail Sale Id 1316 for retail product','2023-03-11 10:27:39','',''),('1','311',2569,'','20','3',4140.00,0.00,'Retail Sale Id 1317 for 6.00 KG of Cooking Gas @ N690.00','2023-03-11 10:28:44','',''),('1','311',2570,'','6.1','4',0.00,4140.00,'Retail Sale Id 1317 for retail product','2023-03-11 10:28:44','',''),('1','311',2571,'','20','3',4140.00,0.00,'Retail Sale Id 1318 for 6.00 KG of Cooking Gas @ N690.00','2023-03-11 10:30:06','',''),('1','311',2572,'','6.1','4',0.00,4140.00,'Retail Sale Id 1318 for retail product','2023-03-11 10:30:06','',''),('1','311',2573,'','20','3',2760.00,0.00,'Retail Sale Id 1320 for 4.00 KG of Cooking Gas @ N690.00','2023-03-11 10:33:31','',''),('1','311',2574,'','6.1','4',0.00,2760.00,'Retail Sale Id 1320 for retail product','2023-03-11 10:33:31','',''),('1','311',2575,'','20','3',4830.00,0.00,'Retail Sale Id 1321 for 7.00 KG of Cooking Gas @ N690.00','2023-03-11 10:35:27','',''),('1','311',2576,'','6.1','4',0.00,4830.00,'Retail Sale Id 1321 for retail product','2023-03-11 10:35:27','',''),('1','311',2577,'','20','3',4830.00,0.00,'Retail Sale Id 1322 for 7.00 KG of Cooking Gas @ N690.00','2023-03-11 10:37:27','',''),('1','311',2578,'','6.1','4',0.00,4830.00,'Retail Sale Id 1322 for retail product','2023-03-11 10:37:27','',''),('1','311',2579,'','20','3',3450.00,0.00,'Retail Sale Id 1323 for 5.00 KG of Cooking Gas @ N690.00','2023-03-11 10:39:11','',''),('1','311',2580,'','6.1','4',0.00,3450.00,'Retail Sale Id 1323 for retail product','2023-03-11 10:39:11','',''),('1','311',2581,'','20','3',8625.00,0.00,'Retail Sale Id 1324 for 12.50 KG of Cooking Gas @ N690.00','2023-03-11 10:43:26','',''),('1','311',2582,'','6.1','4',0.00,8625.00,'Retail Sale Id 1324 for retail product','2023-03-11 10:43:26','',''),('1','311',2583,'','20','3',9660.00,0.00,'Retail Sale Id 1325 for 14.00 KG of Cooking Gas @ N690.00','2023-03-11 11:06:23','',''),('1','311',2584,'','6.1','4',0.00,9660.00,'Retail Sale Id 1325 for retail product','2023-03-11 11:06:23','',''),('1','311',2585,'','20','3',2760.00,0.00,'Retail Sale Id 1326 for 4.00 KG of Cooking Gas @ N690.00','2023-03-11 11:09:55','',''),('1','311',2586,'','6.1','4',0.00,2760.00,'Retail Sale Id 1326 for retail product','2023-03-11 11:09:55','',''),('1','311',2587,'','20','3',4140.00,0.00,'Retail Sale Id 1327 for 6.00 KG of Cooking Gas @ N690.00','2023-03-11 11:17:04','',''),('1','311',2588,'','6.1','4',0.00,4140.00,'Retail Sale Id 1327 for retail product','2023-03-11 11:17:04','',''),('1','311',2589,'','20','3',2760.00,0.00,'Retail Sale Id 1328 for 4.00 KG of Cooking Gas @ N690.00','2023-03-11 11:19:00','',''),('1','311',2590,'','6.1','4',0.00,2760.00,'Retail Sale Id 1328 for retail product','2023-03-11 11:19:00','',''),('1','311',2591,'','20','3',2070.00,0.00,'Retail Sale Id 1330 for 3.00 KG of Cooking Gas @ N690.00','2023-03-11 11:23:51','',''),('1','311',2592,'','6.1','4',0.00,2070.00,'Retail Sale Id 1330 for retail product','2023-03-11 11:23:51','',''),('1','311',2593,'','20','3',4140.00,0.00,'Retail Sale Id 1331 for 6.00 KG of Cooking Gas @ N690.00','2023-03-11 11:25:27','',''),('1','311',2594,'','6.1','4',0.00,4140.00,'Retail Sale Id 1331 for retail product','2023-03-11 11:25:27','',''),('1','311',2595,'','20','3',4140.00,0.00,'Retail Sale Id 1332 for 6.00 KG of Cooking Gas @ N690.00','2023-03-11 11:29:18','',''),('1','311',2596,'','6.1','4',0.00,4140.00,'Retail Sale Id 1332 for retail product','2023-03-11 11:29:18','',''),('1','311',2597,'','20','3',1000.00,0.00,'Retail Sale Id 1333 for 1.45 KG of Cooking Gas @ N690.00','2023-03-11 11:31:53','',''),('1','311',2598,'','6.1','4',0.00,1000.00,'Retail Sale Id 1333 for retail product','2023-03-11 11:31:53','',''),('1','311',2599,'','20','3',3450.00,0.00,'Retail Sale Id 1334 for 5.00 KG of Cooking Gas @ N690.00','2023-03-11 11:34:43','',''),('1','311',2600,'','6.1','4',0.00,3450.00,'Retail Sale Id 1334 for retail product','2023-03-11 11:34:43','',''),('1','311',2601,'','20','3',11730.00,0.00,'Retail Sale Id 1335 for 17.00 KG of Cooking Gas @ N690.00','2023-03-11 11:37:46','',''),('1','311',2602,'','6.1','4',0.00,11730.00,'Retail Sale Id 1335 for retail product','2023-03-11 11:37:46','',''),('1','311',2603,'','20','3',8625.00,0.00,'Retail Sale Id 1336 for 12.50 KG of Cooking Gas @ N690.00','2023-03-11 11:40:10','',''),('1','311',2604,'','6.1','4',0.00,8625.00,'Retail Sale Id 1336 for retail product','2023-03-11 11:40:10','',''),('1','311',2605,'','20','3',2000.00,0.00,'Retail Sale Id 1337 for 2.90 KG of Cooking Gas @ N690.00','2023-03-11 11:41:42','',''),('1','311',2606,'','6.1','4',0.00,2000.00,'Retail Sale Id 1337 for retail product','2023-03-11 11:41:42','',''),('1','311',2607,'','20','3',1000.00,0.00,'Retail Sale Id 1338 for 1.45 KG of Cooking Gas @ N690.00','2023-03-11 11:53:13','',''),('1','311',2608,'','6.1','4',0.00,1000.00,'Retail Sale Id 1338 for retail product','2023-03-11 11:53:13','',''),('1','311',2609,'','20','3',4140.00,0.00,'Retail Sale Id 1339 for multiple products','2023-03-11 11:56:56','',''),('1','311',2610,'','6.1','4',0.00,4140.00,'Retail Sale Id 1339 for retail product','2023-03-11 11:56:56','',''),('1','311',2611,'','20','3',6210.00,0.00,'Retail Sale Id 1340 for 9.00 KG of Cooking Gas @ N690.00','2023-03-11 11:58:22','',''),('1','311',2612,'','6.1','4',0.00,6210.00,'Retail Sale Id 1340 for retail product','2023-03-11 11:58:22','',''),('1','311',2613,'','20','3',3450.00,0.00,'Retail Sale Id 1342 for 5.00 KG of Cooking Gas @ N690.00','2023-03-11 12:02:45','',''),('1','311',2614,'','6.1','4',0.00,3450.00,'Retail Sale Id 1342 for retail product','2023-03-11 12:02:45','',''),('1','311',2615,'','20','3',1400.00,0.00,'Retail Sale Id 1343 for 2.03 KG of Cooking Gas @ N690.00','2023-03-11 12:05:09','',''),('1','311',2616,'','6.1','4',0.00,1400.00,'Retail Sale Id 1343 for retail product','2023-03-11 12:05:09','',''),('1','311',2617,'','20','3',40461.30,0.00,'Retail Sale Id 1344 for 60.39 KG of Cooking Gas @ N670.00','2023-03-11 12:12:42','',''),('1','311',2618,'','6.1','4',0.00,40461.30,'Retail Sale Id 1344 for retail product','2023-03-11 12:12:42','',''),('1','311',2619,'','20','3',6900.00,0.00,'Retail Sale Id 1345 for 10.00 KG of Cooking Gas @ N690.00','2023-03-11 12:36:55','',''),('1','311',2620,'','6.1','4',0.00,6900.00,'Retail Sale Id 1345 for retail product','2023-03-11 12:36:55','',''),('1','311',2621,'','20','3',2760.00,0.00,'Retail Sale Id 1346 for 4.00 KG of Cooking Gas @ N690.00','2023-03-11 12:38:14','',''),('1','311',2622,'','6.1','4',0.00,2760.00,'Retail Sale Id 1346 for retail product','2023-03-11 12:38:14','',''),('1','311',2623,'','20','3',4830.00,0.00,'Retail Sale Id 1347 for 7.00 KG of Cooking Gas @ N690.00','2023-03-11 12:40:10','',''),('1','311',2624,'','6.1','4',0.00,4830.00,'Retail Sale Id 1347 for retail product','2023-03-11 12:40:10','',''),('1','311',2625,'','20','3',3000.00,0.00,'Retail Sale Id 1348 for 4.35 KG of Cooking Gas @ N690.00','2023-03-11 12:49:57','',''),('1','311',2626,'','6.1','4',0.00,3000.00,'Retail Sale Id 1348 for retail product','2023-03-11 12:49:57','',''),('1','311',2627,'','20','3',6900.00,0.00,'Retail Sale Id 1349 for 10.00 KG of Cooking Gas @ N690.00','2023-03-11 12:50:56','',''),('1','311',2628,'','6.1','4',0.00,6900.00,'Retail Sale Id 1349 for retail product','2023-03-11 12:50:56','',''),('1','311',2629,'','20','3',2000.00,0.00,'Retail Sale Id 1350 for 2.90 KG of Cooking Gas @ N690.00','2023-03-11 12:51:53','',''),('1','311',2630,'','6.1','4',0.00,2000.00,'Retail Sale Id 1350 for retail product','2023-03-11 12:51:53','',''),('1','311',2631,'','20','3',3450.00,0.00,'Retail Sale Id 1351 for 5.00 KG of Cooking Gas @ N690.00','2023-03-11 12:56:55','',''),('1','311',2632,'','6.1','4',0.00,3450.00,'Retail Sale Id 1351 for retail product','2023-03-11 12:56:55','',''),('1','311',2633,'','20','3',3450.00,0.00,'Retail Sale Id 1352 for 5.00 KG of Cooking Gas @ N690.00','2023-03-11 13:00:27','',''),('1','311',2634,'','6.1','4',0.00,3450.00,'Retail Sale Id 1352 for retail product','2023-03-11 13:00:27','',''),('1','311',2635,'','20','3',4140.00,0.00,'Retail Sale Id 1353 for 6.00 KG of Cooking Gas @ N690.00','2023-03-11 13:01:35','',''),('1','311',2636,'','6.1','4',0.00,4140.00,'Retail Sale Id 1353 for retail product','2023-03-11 13:01:35','',''),('1','311',2637,'','20','3',3450.00,0.00,'Retail Sale Id 1354 for 5.00 KG of Cooking Gas @ N690.00','2023-03-11 13:35:17','',''),('1','311',2638,'','6.1','4',0.00,3450.00,'Retail Sale Id 1354 for retail product','2023-03-11 13:35:17','',''),('1','311',2639,'','20','3',3000.00,0.00,'Retail Sale Id 1355 for 4.35 KG of Cooking Gas @ N690.00','2023-03-11 13:36:39','',''),('1','311',2640,'','6.1','4',0.00,3000.00,'Retail Sale Id 1355 for retail product','2023-03-11 13:36:39','',''),('1','311',2641,'','20','3',1700.00,0.00,'Retail Sale Id 1356 for 2.46 KG of Cooking Gas @ N690.00','2023-03-11 13:39:16','',''),('1','311',2642,'','6.1','4',0.00,1700.00,'Retail Sale Id 1356 for retail product','2023-03-11 13:39:16','',''),('1','311',2643,'','20','3',1000.00,0.00,'Retail Sale Id 1357 for 1.45 KG of Cooking Gas @ N690.00','2023-03-11 13:39:50','',''),('1','311',2644,'','6.1','4',0.00,1000.00,'Retail Sale Id 1357 for retail product','2023-03-11 13:39:50','',''),('1','311',2645,'','20','3',2070.00,0.00,'Retail Sale Id 1358 for 3.00 KG of Cooking Gas @ N690.00','2023-03-11 13:49:49','',''),('1','311',2646,'','6.1','4',0.00,2070.00,'Retail Sale Id 1358 for retail product','2023-03-11 13:49:49','',''),('1','311',2647,'','20','3',3450.00,0.00,'Retail Sale Id 1359 for 5.00 KG of Cooking Gas @ N690.00','2023-03-11 13:53:52','',''),('1','311',2648,'','6.1','4',0.00,3450.00,'Retail Sale Id 1359 for retail product','2023-03-11 13:53:52','',''),('1','311',2649,'','20','3',4140.00,0.00,'Retail Sale Id 1360 for 6.00 KG of Cooking Gas @ N690.00','2023-03-11 13:56:26','',''),('1','311',2650,'','6.1','4',0.00,4140.00,'Retail Sale Id 1360 for retail product','2023-03-11 13:56:26','',''),('1','311',2651,'','20','3',2070.00,0.00,'Retail Sale Id 1361 for 3.00 KG of Cooking Gas @ N690.00','2023-03-11 13:59:57','',''),('1','311',2652,'','6.1','4',0.00,2070.00,'Retail Sale Id 1361 for retail product','2023-03-11 13:59:57','',''),('1','311',2653,'','20','3',1380.00,0.00,'Retail Sale Id 1362 for 2.00 KG of Cooking Gas @ N690.00','2023-03-11 14:09:36','',''),('1','311',2654,'','6.1','4',0.00,1380.00,'Retail Sale Id 1362 for retail product','2023-03-11 14:09:36','',''),('1','311',2655,'','20','3',5000.00,0.00,'Retail Sale Id 1363 for 7.25 KG of Cooking Gas @ N690.00','2023-03-11 14:11:12','',''),('1','311',2656,'','6.1','4',0.00,5000.00,'Retail Sale Id 1363 for retail product','2023-03-11 14:11:12','',''),('1','311',2657,'','20','3',4830.00,0.00,'Retail Sale Id 1365 for 7.00 KG of Cooking Gas @ N690.00','2023-03-11 14:21:48','',''),('1','311',2658,'','6.1','4',0.00,4830.00,'Retail Sale Id 1365 for retail product','2023-03-11 14:21:48','',''),('1','311',2659,'','20','3',5520.00,0.00,'Retail Sale Id 1366 for 8.00 KG of Cooking Gas @ N690.00','2023-03-11 14:37:06','',''),('1','311',2660,'','6.1','4',0.00,5520.00,'Retail Sale Id 1366 for retail product','2023-03-11 14:37:06','',''),('1','311',2661,'','20','3',8625.00,0.00,'Retail Sale Id 1367 for 12.50 KG of Cooking Gas @ N690.00','2023-03-11 14:47:17','',''),('1','311',2662,'','6.1','4',0.00,8625.00,'Retail Sale Id 1367 for retail product','2023-03-11 14:47:17','',''),('1','311',2663,'','20','3',1380.00,0.00,'Retail Sale Id 1368 for 2.00 KG of Cooking Gas @ N690.00','2023-03-11 14:53:11','',''),('1','311',2664,'','6.1','4',0.00,1380.00,'Retail Sale Id 1368 for retail product','2023-03-11 14:53:11','',''),('1','311',2665,'','20','3',8625.00,0.00,'Retail Sale Id 1369 for 12.50 KG of Cooking Gas @ N690.00','2023-03-11 14:56:39','',''),('1','311',2666,'','6.1','4',0.00,8625.00,'Retail Sale Id 1369 for retail product','2023-03-11 14:56:39','',''),('1','311',2667,'','20','3',7000.00,0.00,'Retail Sale Id 1370 for 10.14 KG of Cooking Gas @ N690.00','2023-03-11 15:15:19','',''),('1','311',2668,'','6.1','4',0.00,7000.00,'Retail Sale Id 1370 for retail product','2023-03-11 15:15:19','',''),('1','311',2669,'','20','3',3000.00,0.00,'Retail Sale Id 1371 for 4.35 KG of Cooking Gas @ N690.00','2023-03-11 15:18:25','',''),('1','311',2670,'','6.1','4',0.00,3000.00,'Retail Sale Id 1371 for retail product','2023-03-11 15:18:25','',''),('1','311',2671,'','20','3',8000.00,0.00,'Retail Sale Id 1372 for multiple products','2023-03-11 15:20:34','',''),('1','311',2672,'','6.1','4',0.00,8000.00,'Retail Sale Id 1372 for retail product','2023-03-11 15:20:34','',''),('1','311',2673,'','20','3',1400.00,0.00,'Retail Sale Id 1373 for 2.03 KG of Cooking Gas @ N690.00','2023-03-11 15:25:28','',''),('1','311',2674,'','6.1','4',0.00,1400.00,'Retail Sale Id 1373 for retail product','2023-03-11 15:25:28','',''),('1','311',2675,'','20','3',2100.00,0.00,'Retail Sale Id 1376 for 3.04 KG of Cooking Gas @ N690.00','2023-03-11 15:34:44','',''),('1','311',2676,'','6.1','4',0.00,2100.00,'Retail Sale Id 1376 for retail product','2023-03-11 15:34:44','',''),('1','311',2677,'','20','3',4150.00,0.00,'Retail Sale Id 1377 for 6.01 KG of Cooking Gas @ N690.00','2023-03-11 15:35:31','',''),('1','311',2678,'','6.1','4',0.00,4150.00,'Retail Sale Id 1377 for retail product','2023-03-11 15:35:31','',''),('1','311',2679,'','20','3',4200.00,0.00,'Retail Sale Id 1378 for 6.09 KG of Cooking Gas @ N690.00','2023-03-11 15:36:49','',''),('1','311',2680,'','6.1','4',0.00,4200.00,'Retail Sale Id 1378 for retail product','2023-03-11 15:36:49','',''),('1','311',2681,'','20','3',2070.00,0.00,'Retail Sale Id 1379 for 3.00 KG of Cooking Gas @ N690.00','2023-03-11 15:38:36','',''),('1','311',2682,'','6.1','4',0.00,2070.00,'Retail Sale Id 1379 for retail product','2023-03-11 15:38:36','',''),('1','311',2683,'','20','3',3450.00,0.00,'Retail Sale Id 1382 for 5.00 KG of Cooking Gas @ N690.00','2023-03-11 15:45:34','',''),('1','311',2684,'','6.1','4',0.00,3450.00,'Retail Sale Id 1382 for retail product','2023-03-11 15:45:34','',''),('1','311',2685,'','20','3',2000.00,0.00,'Retail Sale Id 1383 for 2.90 KG of Cooking Gas @ N690.00','2023-03-11 15:46:17','',''),('1','311',2686,'','6.1','4',0.00,2000.00,'Retail Sale Id 1383 for retail product','2023-03-11 15:46:17','',''),('1','311',2687,'','20','3',3450.00,0.00,'Retail Sale Id 1384 for 5.00 KG of Cooking Gas @ N690.00','2023-03-11 15:47:42','',''),('1','311',2688,'','6.1','4',0.00,3450.00,'Retail Sale Id 1384 for retail product','2023-03-11 15:47:42','',''),('1','311',2689,'','20','3',4140.00,0.00,'Retail Sale Id 1385 for 6.00 KG of Cooking Gas @ N690.00','2023-03-11 15:55:14','',''),('1','311',2690,'','6.1','4',0.00,4140.00,'Retail Sale Id 1385 for retail product','2023-03-11 15:55:14','',''),('1','311',2691,'','20','3',2100.00,0.00,'Retail Sale Id 1387 for 3.04 KG of Cooking Gas @ N690.00','2023-03-11 15:57:19','',''),('1','311',2692,'','6.1','4',0.00,2100.00,'Retail Sale Id 1387 for retail product','2023-03-11 15:57:19','',''),('1','311',2693,'','20','3',2760.00,0.00,'Retail Sale Id 1389 for 4.00 KG of Cooking Gas @ N690.00','2023-03-11 16:08:44','',''),('1','311',2694,'','6.1','4',0.00,2760.00,'Retail Sale Id 1389 for retail product','2023-03-11 16:08:44','',''),('1','311',2695,'','20','3',2070.00,0.00,'Retail Sale Id 1388 for 3.00 KG of Cooking Gas @ N690.00','2023-03-11 16:10:48','',''),('1','311',2696,'','6.1','4',0.00,2070.00,'Retail Sale Id 1388 for retail product','2023-03-11 16:10:48','',''),('1','311',2697,'','20','3',2070.00,0.00,'Retail Sale Id 1391 for 3.00 KG of Cooking Gas @ N690.00','2023-03-11 16:15:50','',''),('1','311',2698,'','6.1','4',0.00,2070.00,'Retail Sale Id 1391 for retail product','2023-03-11 16:15:50','',''),('1','311',2699,'','20','3',4140.00,0.00,'Retail Sale Id 1392 for 6.00 KG of Cooking Gas @ N690.00','2023-03-11 16:37:21','',''),('1','311',2700,'','6.1','4',0.00,4140.00,'Retail Sale Id 1392 for retail product','2023-03-11 16:37:21','',''),('1','311',2701,'','20','3',4140.00,0.00,'Retail Sale Id 1394 for 6.00 KG of Cooking Gas @ N690.00','2023-03-11 16:50:12','',''),('1','311',2702,'','6.1','4',0.00,4140.00,'Retail Sale Id 1394 for retail product','2023-03-11 16:50:12','',''),('1','311',2703,'','20','3',4830.00,0.00,'Retail Sale Id 1395 for 7.00 KG of Cooking Gas @ N690.00','2023-03-11 16:57:11','',''),('1','311',2704,'','6.1','4',0.00,4830.00,'Retail Sale Id 1395 for retail product','2023-03-11 16:57:11','',''),('1','311',2705,'','20','3',1380.00,0.00,'Retail Sale Id 1396 for 2.00 KG of Cooking Gas @ N690.00','2023-03-11 17:09:16','',''),('1','311',2706,'','6.1','4',0.00,1380.00,'Retail Sale Id 1396 for retail product','2023-03-11 17:09:16','',''),('1','311',2707,'','20','3',4000.00,0.00,'Retail Sale Id 1397 for 5.80 KG of Cooking Gas @ N690.00','2023-03-11 17:13:55','',''),('1','311',2708,'','6.1','4',0.00,4000.00,'Retail Sale Id 1397 for retail product','2023-03-11 17:13:55','',''),('1','311',2709,'','20','3',3450.00,0.00,'Retail Sale Id 1398 for 5.00 KG of Cooking Gas @ N690.00','2023-03-11 17:15:51','',''),('1','311',2710,'','6.1','4',0.00,3450.00,'Retail Sale Id 1398 for retail product','2023-03-11 17:15:51','',''),('1','311',2711,'','20','3',2070.00,0.00,'Retail Sale Id 1399 for 3.00 KG of Cooking Gas @ N690.00','2023-03-11 17:17:02','',''),('1','311',2712,'','6.1','4',0.00,2070.00,'Retail Sale Id 1399 for retail product','2023-03-11 17:17:02','',''),('1','311',2713,'','20','3',8625.00,0.00,'Retail Sale Id 1400 for 12.50 KG of Cooking Gas @ N690.00','2023-03-11 17:18:20','',''),('1','311',2714,'','6.1','4',0.00,8625.00,'Retail Sale Id 1400 for retail product','2023-03-11 17:18:20','',''),('1','311',2715,'','20','3',2760.00,0.00,'Retail Sale Id 1401 for 4.00 KG of Cooking Gas @ N690.00','2023-03-11 17:20:55','',''),('1','311',2716,'','6.1','4',0.00,2760.00,'Retail Sale Id 1401 for retail product','2023-03-11 17:20:55','',''),('1','311',2717,'','20','3',3450.00,0.00,'Retail Sale Id 1402 for 5.00 KG of Cooking Gas @ N690.00','2023-03-11 17:23:42','',''),('1','311',2718,'','6.1','4',0.00,3450.00,'Retail Sale Id 1402 for retail product','2023-03-11 17:23:42','',''),('1','311',2719,'','20','3',4140.00,0.00,'Retail Sale Id 1403 for 6.00 KG of Cooking Gas @ N690.00','2023-03-11 17:28:37','',''),('1','311',2720,'','6.1','4',0.00,4140.00,'Retail Sale Id 1403 for retail product','2023-03-11 17:28:37','',''),('1','311',2721,'','20','3',3000.00,0.00,'Retail Sale Id 1405 for 4.35 KG of Cooking Gas @ N690.00','2023-03-11 17:31:42','',''),('1','311',2722,'','6.1','4',0.00,3000.00,'Retail Sale Id 1405 for retail product','2023-03-11 17:31:42','',''),('1','311',2723,'','20','3',8625.00,0.00,'Retail Sale Id 1406 for 12.50 KG of Cooking Gas @ N690.00','2023-03-11 17:36:33','',''),('1','311',2724,'','6.1','4',0.00,8625.00,'Retail Sale Id 1406 for retail product','2023-03-11 17:36:33','',''),('1','311',2725,'','20','3',1000.00,0.00,'Retail Sale Id 1408 for 1.45 KG of Cooking Gas @ N690.00','2023-03-11 17:37:48','',''),('1','311',2726,'','6.1','4',0.00,1000.00,'Retail Sale Id 1408 for retail product','2023-03-11 17:37:48','',''),('1','311',2727,'','20','3',2070.00,0.00,'Retail Sale Id 1409 for 3.00 KG of Cooking Gas @ N690.00','2023-03-11 17:41:47','',''),('1','311',2728,'','6.1','4',0.00,2070.00,'Retail Sale Id 1409 for retail product','2023-03-11 17:41:47','',''),('1','311',2729,'','20','3',8625.00,0.00,'Retail Sale Id 1411 for 12.50 KG of Cooking Gas @ N690.00','2023-03-11 17:54:37','',''),('1','311',2730,'','6.1','4',0.00,8625.00,'Retail Sale Id 1411 for retail product','2023-03-11 17:54:37','',''),('1','311',2731,'','20','3',2070.00,0.00,'Retail Sale Id 1412 for 3.00 KG of Cooking Gas @ N690.00','2023-03-11 17:55:46','',''),('1','311',2732,'','6.1','4',0.00,2070.00,'Retail Sale Id 1412 for retail product','2023-03-11 17:55:46','',''),('1','311',2733,'','20','3',8970.00,0.00,'Retail Sale Id 1413 for 13.00 KG of Cooking Gas @ N690.00','2023-03-11 18:12:46','',''),('1','311',2734,'','6.1','4',0.00,8970.00,'Retail Sale Id 1413 for retail product','2023-03-11 18:12:46','',''),('1','311',2735,'','20','3',690.00,0.00,'Retail Sale Id 1415 for 1.00 KG of Cooking Gas @ N690.00','2023-03-11 18:21:49','',''),('1','311',2736,'','6.1','4',0.00,690.00,'Retail Sale Id 1415 for retail product','2023-03-11 18:21:49','',''),('1','311',2737,'','20','3',6900.00,0.00,'Retail Sale Id 1417 for multiple products','2023-03-11 18:25:51','',''),('1','311',2738,'','6.1','4',0.00,6900.00,'Retail Sale Id 1417 for retail product','2023-03-11 18:25:51','',''),('1','311',2739,'','20','3',2070.00,0.00,'Retail Sale Id 1419 for 3.00 KG of Cooking Gas @ N690.00','2023-03-11 18:26:54','',''),('1','311',2740,'','6.1','4',0.00,2070.00,'Retail Sale Id 1419 for retail product','2023-03-11 18:26:54','',''),('1','311',2741,'','20','3',690.00,0.00,'Retail Sale Id 1420 for 1.00 KG of Cooking Gas @ N690.00','2023-03-11 18:28:49','',''),('1','311',2742,'','6.1','4',0.00,690.00,'Retail Sale Id 1420 for retail product','2023-03-11 18:28:49','',''),('1','311',2743,'','20','3',1200.00,0.00,'Retail Sale Id 1421 for 1.74 KG of Cooking Gas @ N690.00','2023-03-11 18:30:08','',''),('1','311',2744,'','6.1','4',0.00,1200.00,'Retail Sale Id 1421 for retail product','2023-03-11 18:30:08','',''),('1','311',2745,'','20','3',2070.00,0.00,'Retail Sale Id 1422 for 3.00 KG of Cooking Gas @ N690.00','2023-03-11 18:30:53','',''),('1','311',2746,'','6.1','4',0.00,2070.00,'Retail Sale Id 1422 for retail product','2023-03-11 18:30:53','',''),('1','311',2747,'','20','3',13455.00,0.00,'Retail Sale Id 1374 for multiple products','2023-03-11 18:41:45','',''),('1','311',2748,'','6.1','4',0.00,13455.00,'Retail Sale Id 1374 for retail product','2023-03-11 18:41:45','',''),('1','311',2749,'','20','3',4140.00,0.00,'Retail Sale Id 1423 for 6.00 KG of Cooking Gas @ N690.00','2023-03-11 18:43:11','',''),('1','311',2750,'','6.1','4',0.00,4140.00,'Retail Sale Id 1423 for retail product','2023-03-11 18:43:11','',''),('1','311',2751,'','20','3',0.00,4140.00,'Return of Retail Sale Id 1423 for products','2023-03-11 23:16:16','',''),('1','311',2752,'','','',4140.00,0.00,'Return of Retail Sale Id 1423 for products','2023-03-11 23:16:16','',''),('1','311',2753,'','20','3',0.00,2070.00,'Return of Retail Sale Id 1422 for products','2023-03-11 23:17:25','',''),('1','311',2754,'','','',2070.00,0.00,'Return of Retail Sale Id 1422 for products','2023-03-11 23:17:25','',''),('1','311',2755,'','20','3',0.00,2760.00,'Return of Retail Sale Id 1401 for products','2023-03-11 23:20:54','',''),('1','311',2756,'','','',2760.00,0.00,'Return of Retail Sale Id 1401 for products','2023-03-11 23:20:54','',''),('1','311',2757,'','20','3',0.00,690.00,'Return of Retail Sale Id 1415 for products','2023-03-11 23:23:39','',''),('1','311',2758,'','','',690.00,0.00,'Return of Retail Sale Id 1415 for products','2023-03-11 23:23:39','',''),('1','311',2759,'','20','3',1510.39,0.00,'Retail Sale Id 1424 for 2.19 KG of Cooking Gas @ N690.00','2023-03-11 23:25:05','',''),('1','311',2760,'','6.1','4',0.00,1510.39,'Retail Sale Id 1424 for retail product','2023-03-11 23:25:05','',''),('1','311',2761,'','20','3',0.00,0.00,'Sales from shift 26 on 2023-03-11 23:26:49 ','2023-03-11 23:26:49','',''),('1','311',2762,'','6.1','4',0.00,0.00,'Sales from shift 26 on 2023-03-11 23:26:49 ','2023-03-11 23:26:49','',''),('1','311',2763,'','20','3',2000.00,0.00,'Retail Sale Id 1425 for 2.90 KG of Cooking Gas @ N690.00','2023-03-12 08:02:41','',''),('1','311',2764,'','6.1','4',0.00,2000.00,'Retail Sale Id 1425 for retail product','2023-03-12 08:02:41','',''),('1','311',2765,'','20','3',3450.00,0.00,'Retail Sale Id 1426 for 5.00 KG of Cooking Gas @ N690.00','2023-03-12 08:04:03','',''),('1','311',2766,'','6.1','4',0.00,3450.00,'Retail Sale Id 1426 for retail product','2023-03-12 08:04:03','',''),('1','311',2767,'','20','3',3000.00,0.00,'Retail Sale Id 1427 for 4.35 KG of Cooking Gas @ N690.00','2023-03-12 08:05:52','',''),('1','311',2768,'','6.1','4',0.00,3000.00,'Retail Sale Id 1427 for retail product','2023-03-12 08:05:52','',''),('1','311',2769,'','20','3',2070.00,0.00,'Retail Sale Id 1428 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 08:07:06','',''),('1','311',2770,'','6.1','4',0.00,2070.00,'Retail Sale Id 1428 for retail product','2023-03-12 08:07:06','',''),('1','311',2771,'','20','3',930.00,0.00,'Retail Sale Id 1429 for 1.35 KG of Cooking Gas @ N690.00','2023-03-12 08:09:04','',''),('1','311',2772,'','6.1','4',0.00,930.00,'Retail Sale Id 1429 for retail product','2023-03-12 08:09:04','',''),('1','311',2773,'','20','3',10660.00,0.00,'Retail Sale Id 1431 for multiple products','2023-03-12 08:13:20','',''),('1','311',2774,'','6.1','4',0.00,10660.00,'Retail Sale Id 1431 for retail product','2023-03-12 08:13:20','',''),('1','311',2775,'','20','3',2000.00,0.00,'Retail Sale Id 1432 for 2.90 KG of Cooking Gas @ N690.00','2023-03-12 08:14:39','',''),('1','311',2776,'','6.1','4',0.00,2000.00,'Retail Sale Id 1432 for retail product','2023-03-12 08:14:39','',''),('1','311',2777,'','20','3',4140.00,0.00,'Retail Sale Id 1433 for 6.00 KG of Cooking Gas @ N690.00','2023-03-12 08:16:08','',''),('1','311',2778,'','6.1','4',0.00,4140.00,'Retail Sale Id 1433 for retail product','2023-03-12 08:16:08','',''),('1','311',2779,'','20','3',2000.00,0.00,'Retail Sale Id 1434 for 2.90 KG of Cooking Gas @ N690.00','2023-03-12 08:17:29','',''),('1','311',2780,'','6.1','4',0.00,2000.00,'Retail Sale Id 1434 for retail product','2023-03-12 08:17:29','',''),('1','311',2781,'','20','3',2070.00,0.00,'Retail Sale Id 1435 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 08:22:17','',''),('1','311',2782,'','6.1','4',0.00,2070.00,'Retail Sale Id 1435 for retail product','2023-03-12 08:22:17','',''),('1','311',2783,'','20','3',3450.00,0.00,'Retail Sale Id 1436 for 5.00 KG of Cooking Gas @ N690.00','2023-03-12 08:23:20','',''),('1','311',2784,'','6.1','4',0.00,3450.00,'Retail Sale Id 1436 for retail product','2023-03-12 08:23:20','',''),('1','311',2785,'','20','3',3795.00,0.00,'Retail Sale Id 1437 for 5.50 KG of Cooking Gas @ N690.00','2023-03-12 08:25:01','',''),('1','311',2786,'','6.1','4',0.00,3795.00,'Retail Sale Id 1437 for retail product','2023-03-12 08:25:01','',''),('1','311',2787,'','20','3',4830.00,0.00,'Retail Sale Id 1438 for 7.00 KG of Cooking Gas @ N690.00','2023-03-12 08:26:49','',''),('1','311',2788,'','6.1','4',0.00,4830.00,'Retail Sale Id 1438 for retail product','2023-03-12 08:26:49','',''),('1','311',2789,'','20','3',2760.00,0.00,'Retail Sale Id 1439 for 4.00 KG of Cooking Gas @ N690.00','2023-03-12 08:29:10','',''),('1','311',2790,'','6.1','4',0.00,2760.00,'Retail Sale Id 1439 for retail product','2023-03-12 08:29:10','',''),('1','311',2791,'','20','3',2070.00,0.00,'Retail Sale Id 1440 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 08:30:32','',''),('1','311',2792,'','6.1','4',0.00,2070.00,'Retail Sale Id 1440 for retail product','2023-03-12 08:30:32','',''),('1','311',2793,'','20','3',2070.00,0.00,'Retail Sale Id 1441 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 08:33:01','',''),('1','311',2794,'','6.1','4',0.00,2070.00,'Retail Sale Id 1441 for retail product','2023-03-12 08:33:01','',''),('1','311',2795,'','20','3',2070.00,0.00,'Retail Sale Id 1442 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 08:34:17','',''),('1','311',2796,'','6.1','4',0.00,2070.00,'Retail Sale Id 1442 for retail product','2023-03-12 08:34:17','',''),('1','311',2797,'','20','3',2070.00,0.00,'Retail Sale Id 1443 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 08:35:49','',''),('1','311',2798,'','6.1','4',0.00,2070.00,'Retail Sale Id 1443 for retail product','2023-03-12 08:35:49','',''),('1','311',2799,'','20','3',2070.00,0.00,'Retail Sale Id 1444 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 08:38:57','',''),('1','311',2800,'','6.1','4',0.00,2070.00,'Retail Sale Id 1444 for retail product','2023-03-12 08:38:57','',''),('1','311',2801,'','20','3',3000.00,0.00,'Retail Sale Id 1446 for 4.35 KG of Cooking Gas @ N690.00','2023-03-12 08:42:12','',''),('1','311',2802,'','6.1','4',0.00,3000.00,'Retail Sale Id 1446 for retail product','2023-03-12 08:42:12','',''),('1','311',2803,'','20','3',8280.00,0.00,'Retail Sale Id 1447 for 12.00 KG of Cooking Gas @ N690.00','2023-03-12 08:43:44','',''),('1','311',2804,'','6.1','4',0.00,8280.00,'Retail Sale Id 1447 for retail product','2023-03-12 08:43:44','',''),('1','311',2805,'','20','3',8625.00,0.00,'Retail Sale Id 1448 for 12.50 KG of Cooking Gas @ N690.00','2023-03-12 08:45:07','',''),('1','311',2806,'','6.1','4',0.00,8625.00,'Retail Sale Id 1448 for retail product','2023-03-12 08:45:07','',''),('1','311',2807,'','20','3',2070.00,0.00,'Retail Sale Id 1449 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 08:46:51','',''),('1','311',2808,'','6.1','4',0.00,2070.00,'Retail Sale Id 1449 for retail product','2023-03-12 08:46:51','',''),('1','311',2809,'','20','3',2000.00,0.00,'Retail Sale Id 1451 for 2.90 KG of Cooking Gas @ N690.00','2023-03-12 08:48:37','',''),('1','311',2810,'','6.1','4',0.00,2000.00,'Retail Sale Id 1451 for retail product','2023-03-12 08:48:37','',''),('1','311',2811,'','20','3',2070.00,0.00,'Retail Sale Id 1452 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 08:50:45','',''),('1','311',2812,'','6.1','4',0.00,2070.00,'Retail Sale Id 1452 for retail product','2023-03-12 08:50:45','',''),('1','311',2813,'','20','3',1380.00,0.00,'Retail Sale Id 1453 for 2.00 KG of Cooking Gas @ N690.00','2023-03-12 08:53:38','',''),('1','311',2814,'','6.1','4',0.00,1380.00,'Retail Sale Id 1453 for retail product','2023-03-12 08:53:38','',''),('1','311',2815,'','20','3',690.00,0.00,'Retail Sale Id 1454 for 1.00 KG of Cooking Gas @ N690.00','2023-03-12 08:56:15','',''),('1','311',2816,'','6.1','4',0.00,690.00,'Retail Sale Id 1454 for retail product','2023-03-12 08:56:15','',''),('1','311',2817,'','20','3',2070.00,0.00,'Retail Sale Id 1455 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 08:58:34','',''),('1','311',2818,'','6.1','4',0.00,2070.00,'Retail Sale Id 1455 for retail product','2023-03-12 08:58:34','',''),('1','311',2819,'','20','3',1000.00,0.00,'Retail Sale Id 1456 for 1.45 KG of Cooking Gas @ N690.00','2023-03-12 08:59:59','',''),('1','311',2820,'','6.1','4',0.00,1000.00,'Retail Sale Id 1456 for retail product','2023-03-12 08:59:59','',''),('1','311',2821,'','20','3',6900.00,0.00,'Retail Sale Id 1457 for 10.00 KG of Cooking Gas @ N690.00','2023-03-12 09:02:24','',''),('1','311',2822,'','6.1','4',0.00,6900.00,'Retail Sale Id 1457 for retail product','2023-03-12 09:02:24','',''),('1','311',2823,'','20','3',2760.00,0.00,'Retail Sale Id 1458 for 4.00 KG of Cooking Gas @ N690.00','2023-03-12 09:07:16','',''),('1','311',2824,'','6.1','4',0.00,2760.00,'Retail Sale Id 1458 for retail product','2023-03-12 09:07:16','',''),('1','311',2825,'','20','3',3450.00,0.00,'Retail Sale Id 1459 for 5.00 KG of Cooking Gas @ N690.00','2023-03-12 09:09:06','',''),('1','311',2826,'','6.1','4',0.00,3450.00,'Retail Sale Id 1459 for retail product','2023-03-12 09:09:06','',''),('1','311',2827,'','20','3',1380.00,0.00,'Retail Sale Id 1460 for 2.00 KG of Cooking Gas @ N690.00','2023-03-12 09:10:41','',''),('1','311',2828,'','6.1','4',0.00,1380.00,'Retail Sale Id 1460 for retail product','2023-03-12 09:10:41','',''),('1','311',2829,'','20','3',2070.00,0.00,'Retail Sale Id 1461 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 09:17:38','',''),('1','311',2830,'','6.1','4',0.00,2070.00,'Retail Sale Id 1461 for retail product','2023-03-12 09:17:38','',''),('1','311',2831,'','20','3',2070.00,0.00,'Retail Sale Id 1462 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 09:18:14','',''),('1','311',2832,'','6.1','4',0.00,2070.00,'Retail Sale Id 1462 for retail product','2023-03-12 09:18:14','',''),('1','311',2833,'','20','3',3450.00,0.00,'Retail Sale Id 1463 for 5.00 KG of Cooking Gas @ N690.00','2023-03-12 09:19:47','',''),('1','311',2834,'','6.1','4',0.00,3450.00,'Retail Sale Id 1463 for retail product','2023-03-12 09:19:47','',''),('1','311',2835,'','20','3',8280.00,0.00,'Retail Sale Id 1464 for 12.00 KG of Cooking Gas @ N690.00','2023-03-12 09:21:34','',''),('1','311',2836,'','6.1','4',0.00,8280.00,'Retail Sale Id 1464 for retail product','2023-03-12 09:21:34','',''),('1','311',2837,'','20','3',4830.00,0.00,'Retail Sale Id 1465 for 7.00 KG of Cooking Gas @ N690.00','2023-03-12 09:28:36','',''),('1','311',2838,'','6.1','4',0.00,4830.00,'Retail Sale Id 1465 for retail product','2023-03-12 09:28:36','',''),('1','311',2839,'','20','3',2070.00,0.00,'Retail Sale Id 1466 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 09:29:53','',''),('1','311',2840,'','6.1','4',0.00,2070.00,'Retail Sale Id 1466 for retail product','2023-03-12 09:29:53','',''),('1','311',2841,'','20','3',2070.00,0.00,'Retail Sale Id 1467 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 09:31:28','',''),('1','311',2842,'','6.1','4',0.00,2070.00,'Retail Sale Id 1467 for retail product','2023-03-12 09:31:28','',''),('1','311',2843,'','20','3',4000.00,0.00,'Retail Sale Id 1468 for 5.80 KG of Cooking Gas @ N690.00','2023-03-12 09:33:39','',''),('1','311',2844,'','6.1','4',0.00,4000.00,'Retail Sale Id 1468 for retail product','2023-03-12 09:33:39','',''),('1','311',2845,'','20','3',2070.00,0.00,'Retail Sale Id 1469 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 09:36:20','',''),('1','311',2846,'','6.1','4',0.00,2070.00,'Retail Sale Id 1469 for retail product','2023-03-12 09:36:20','',''),('1','311',2847,'','20','3',690.00,0.00,'Retail Sale Id 1471 for 1.00 KG of Cooking Gas @ N690.00','2023-03-12 09:40:14','',''),('1','311',2848,'','6.1','4',0.00,690.00,'Retail Sale Id 1471 for retail product','2023-03-12 09:40:14','',''),('1','311',2849,'','20','3',2070.00,0.00,'Retail Sale Id 1472 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 09:52:22','',''),('1','311',2850,'','6.1','4',0.00,2070.00,'Retail Sale Id 1472 for retail product','2023-03-12 09:52:22','',''),('1','311',2851,'','20','3',700.00,0.00,'Retail Sale Id 1474 for 1.01 KG of Cooking Gas @ N690.00','2023-03-12 09:55:54','',''),('1','311',2852,'','6.1','4',0.00,700.00,'Retail Sale Id 1474 for retail product','2023-03-12 09:55:54','',''),('1','311',2853,'','20','3',1500.00,0.00,'Retail Sale Id 1476 for 2.17 KG of Cooking Gas @ N690.00','2023-03-12 09:57:32','',''),('1','311',2854,'','6.1','4',0.00,1500.00,'Retail Sale Id 1476 for retail product','2023-03-12 09:57:32','',''),('1','311',2855,'','20','3',2070.00,0.00,'Retail Sale Id 1477 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 10:00:50','',''),('1','311',2856,'','6.1','4',0.00,2070.00,'Retail Sale Id 1477 for retail product','2023-03-12 10:00:50','',''),('1','311',2857,'','20','3',4140.00,0.00,'Retail Sale Id 1479 for 6.00 KG of Cooking Gas @ N690.00','2023-03-12 10:05:25','',''),('1','311',2858,'','6.1','4',0.00,4140.00,'Retail Sale Id 1479 for retail product','2023-03-12 10:05:25','',''),('1','311',2859,'','20','3',8625.00,0.00,'Retail Sale Id 1480 for 12.50 KG of Cooking Gas @ N690.00','2023-03-12 10:07:30','',''),('1','311',2860,'','6.1','4',0.00,8625.00,'Retail Sale Id 1480 for retail product','2023-03-12 10:07:30','',''),('1','311',2861,'','20','3',3000.00,0.00,'Retail Sale Id 1478 for 4.35 KG of Cooking Gas @ N690.00','2023-03-12 10:09:04','',''),('1','311',2862,'','6.1','4',0.00,3000.00,'Retail Sale Id 1478 for retail product','2023-03-12 10:09:04','',''),('1','311',2863,'','20','3',2000.00,0.00,'Retail Sale Id 1481 for 2.90 KG of Cooking Gas @ N690.00','2023-03-12 10:14:31','',''),('1','311',2864,'','6.1','4',0.00,2000.00,'Retail Sale Id 1481 for retail product','2023-03-12 10:14:31','',''),('1','311',2865,'','20','3',4140.00,0.00,'Retail Sale Id 1482 for 6.00 KG of Cooking Gas @ N690.00','2023-03-12 10:21:39','',''),('1','311',2866,'','6.1','4',0.00,4140.00,'Retail Sale Id 1482 for retail product','2023-03-12 10:21:39','',''),('1','311',2867,'','20','3',3450.00,0.00,'Retail Sale Id 1483 for 5.00 KG of Cooking Gas @ N690.00','2023-03-12 10:25:34','',''),('1','311',2868,'','6.1','4',0.00,3450.00,'Retail Sale Id 1483 for retail product','2023-03-12 10:25:34','',''),('1','311',2869,'','20','3',2760.00,0.00,'Retail Sale Id 1484 for 4.00 KG of Cooking Gas @ N690.00','2023-03-12 10:27:51','',''),('1','311',2870,'','6.1','4',0.00,2760.00,'Retail Sale Id 1484 for retail product','2023-03-12 10:27:51','',''),('1','311',2871,'','20','3',2070.00,0.00,'Retail Sale Id 1485 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 10:28:55','',''),('1','311',2872,'','6.1','4',0.00,2070.00,'Retail Sale Id 1485 for retail product','2023-03-12 10:28:55','',''),('1','311',2873,'','20','3',1000.00,0.00,'Retail Sale Id 1486 for 1.45 KG of Cooking Gas @ N690.00','2023-03-12 10:29:49','',''),('1','311',2874,'','6.1','4',0.00,1000.00,'Retail Sale Id 1486 for retail product','2023-03-12 10:29:49','',''),('1','311',2875,'','20','3',2800.00,0.00,'Retail Sale Id 1488 for 4.06 KG of Cooking Gas @ N690.00','2023-03-12 10:31:24','',''),('1','311',2876,'','6.1','4',0.00,2800.00,'Retail Sale Id 1488 for retail product','2023-03-12 10:31:24','',''),('1','311',2877,'','20','3',4140.00,0.00,'Retail Sale Id 1489 for 6.00 KG of Cooking Gas @ N690.00','2023-03-12 10:32:19','',''),('1','311',2878,'','6.1','4',0.00,4140.00,'Retail Sale Id 1489 for retail product','2023-03-12 10:32:19','',''),('1','311',2879,'','20','3',1000.00,0.00,'Retail Sale Id 1490 for 1.45 KG of Cooking Gas @ N690.00','2023-03-12 10:33:05','',''),('1','311',2880,'','6.1','4',0.00,1000.00,'Retail Sale Id 1490 for retail product','2023-03-12 10:33:05','',''),('1','311',2881,'','20','3',1380.00,0.00,'Retail Sale Id 1491 for 2.00 KG of Cooking Gas @ N690.00','2023-03-12 10:35:33','',''),('1','311',2882,'','6.1','4',0.00,1380.00,'Retail Sale Id 1491 for retail product','2023-03-12 10:35:33','',''),('1','311',2883,'','20','3',1380.00,0.00,'Retail Sale Id 1492 for 2.00 KG of Cooking Gas @ N690.00','2023-03-12 10:39:55','',''),('1','311',2884,'','6.1','4',0.00,1380.00,'Retail Sale Id 1492 for retail product','2023-03-12 10:39:55','',''),('1','311',2885,'','20','3',5520.00,0.00,'Retail Sale Id 1493 for 8.00 KG of Cooking Gas @ N690.00','2023-03-12 10:42:55','',''),('1','311',2886,'','6.1','4',0.00,5520.00,'Retail Sale Id 1493 for retail product','2023-03-12 10:42:55','',''),('1','311',2887,'','20','3',4140.00,0.00,'Retail Sale Id 1494 for multiple products','2023-03-12 10:49:41','',''),('1','311',2888,'','6.1','4',0.00,4140.00,'Retail Sale Id 1494 for retail product','2023-03-12 10:49:41','',''),('1','311',2889,'','20','3',2070.00,0.00,'Retail Sale Id 1495 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 10:51:27','',''),('1','311',2890,'','6.1','4',0.00,2070.00,'Retail Sale Id 1495 for retail product','2023-03-12 10:51:27','',''),('1','311',2891,'','20','3',2760.00,0.00,'Retail Sale Id 1496 for 4.00 KG of Cooking Gas @ N690.00','2023-03-12 10:53:38','',''),('1','311',2892,'','6.1','4',0.00,2760.00,'Retail Sale Id 1496 for retail product','2023-03-12 10:53:38','',''),('1','311',2893,'','20','3',4140.00,0.00,'Retail Sale Id 1498 for 6.00 KG of Cooking Gas @ N690.00','2023-03-12 10:59:37','',''),('1','311',2894,'','6.1','4',0.00,4140.00,'Retail Sale Id 1498 for retail product','2023-03-12 10:59:37','',''),('1','311',2895,'','20','3',690.00,0.00,'Retail Sale Id 1499 for 1.00 KG of Cooking Gas @ N690.00','2023-03-12 11:01:25','',''),('1','311',2896,'','6.1','4',0.00,690.00,'Retail Sale Id 1499 for retail product','2023-03-12 11:01:25','',''),('1','311',2897,'','20','3',2415.00,0.00,'Retail Sale Id 1497 for 3.50 KG of Cooking Gas @ N690.00','2023-03-12 11:02:08','',''),('1','311',2898,'','6.1','4',0.00,2415.00,'Retail Sale Id 1497 for retail product','2023-03-12 11:02:08','',''),('1','311',2899,'','20','3',2070.00,0.00,'Retail Sale Id 1500 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 11:02:58','',''),('1','311',2900,'','6.1','4',0.00,2070.00,'Retail Sale Id 1500 for retail product','2023-03-12 11:02:58','',''),('1','311',2901,'','20','3',1700.00,0.00,'Retail Sale Id 1501 for 2.46 KG of Cooking Gas @ N690.00','2023-03-12 11:06:43','',''),('1','311',2902,'','6.1','4',0.00,1700.00,'Retail Sale Id 1501 for retail product','2023-03-12 11:06:43','',''),('1','311',2903,'','20','3',2760.00,0.00,'Retail Sale Id 1503 for 4.00 KG of Cooking Gas @ N690.00','2023-03-12 11:14:06','',''),('1','311',2904,'','6.1','4',0.00,2760.00,'Retail Sale Id 1503 for retail product','2023-03-12 11:14:06','',''),('1','311',2905,'','20','3',4140.00,0.00,'Retail Sale Id 1504 for 6.00 KG of Cooking Gas @ N690.00','2023-03-12 11:24:26','',''),('1','311',2906,'','6.1','4',0.00,4140.00,'Retail Sale Id 1504 for retail product','2023-03-12 11:24:26','',''),('1','311',2907,'','20','3',2070.00,0.00,'Retail Sale Id 1505 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 11:26:28','',''),('1','311',2908,'','6.1','4',0.00,2070.00,'Retail Sale Id 1505 for retail product','2023-03-12 11:26:28','',''),('1','311',2909,'','20','3',2070.00,0.00,'Retail Sale Id 1506 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 11:27:22','',''),('1','311',2910,'','6.1','4',0.00,2070.00,'Retail Sale Id 1506 for retail product','2023-03-12 11:27:22','',''),('1','311',2911,'','20','3',4000.00,0.00,'Retail Sale Id 1507 for 5.80 KG of Cooking Gas @ N690.00','2023-03-12 11:28:09','',''),('1','311',2912,'','6.1','4',0.00,4000.00,'Retail Sale Id 1507 for retail product','2023-03-12 11:28:09','',''),('1','311',2913,'','20','3',1200.00,0.00,'Retail Sale Id 1508 for 1.74 KG of Cooking Gas @ N690.00','2023-03-12 11:32:23','',''),('1','311',2914,'','6.1','4',0.00,1200.00,'Retail Sale Id 1508 for retail product','2023-03-12 11:32:23','',''),('1','311',2915,'','20','3',6900.00,0.00,'Retail Sale Id 1509 for 10.00 KG of Cooking Gas @ N690.00','2023-03-12 11:35:48','',''),('1','311',2916,'','6.1','4',0.00,6900.00,'Retail Sale Id 1509 for retail product','2023-03-12 11:35:48','',''),('1','311',2917,'','20','3',1400.00,0.00,'Retail Sale Id 1510 for 2.03 KG of Cooking Gas @ N690.00','2023-03-12 11:45:39','',''),('1','311',2918,'','6.1','4',0.00,1400.00,'Retail Sale Id 1510 for retail product','2023-03-12 11:45:39','',''),('1','311',2919,'','20','3',1380.00,0.00,'Retail Sale Id 1511 for 2.00 KG of Cooking Gas @ N690.00','2023-03-12 11:46:27','',''),('1','311',2920,'','6.1','4',0.00,1380.00,'Retail Sale Id 1511 for retail product','2023-03-12 11:46:27','',''),('1','311',2921,'','20','3',3000.00,0.00,'Retail Sale Id 1512 for 4.35 KG of Cooking Gas @ N690.00','2023-03-12 11:55:24','',''),('1','311',2922,'','6.1','4',0.00,3000.00,'Retail Sale Id 1512 for retail product','2023-03-12 11:55:24','',''),('1','311',2923,'','20','3',4140.00,0.00,'Retail Sale Id 1513 for 6.00 KG of Cooking Gas @ N690.00','2023-03-12 12:05:02','',''),('1','311',2924,'','6.1','4',0.00,4140.00,'Retail Sale Id 1513 for retail product','2023-03-12 12:05:02','',''),('1','311',2925,'','20','3',1000.00,0.00,'Retail Sale Id 1514 for 1.45 KG of Cooking Gas @ N690.00','2023-03-12 12:14:12','',''),('1','311',2926,'','6.1','4',0.00,1000.00,'Retail Sale Id 1514 for retail product','2023-03-12 12:14:12','',''),('1','311',2927,'','20','3',3450.00,0.00,'Retail Sale Id 1515 for 5.00 KG of Cooking Gas @ N690.00','2023-03-12 12:16:24','',''),('1','311',2928,'','6.1','4',0.00,3450.00,'Retail Sale Id 1515 for retail product','2023-03-12 12:16:24','',''),('1','311',2929,'','20','3',1380.00,0.00,'Retail Sale Id 1517 for 2.00 KG of Cooking Gas @ N690.00','2023-03-12 12:20:00','',''),('1','311',2930,'','6.1','4',0.00,1380.00,'Retail Sale Id 1517 for retail product','2023-03-12 12:20:00','',''),('1','311',2931,'','20','3',2760.00,0.00,'Retail Sale Id 1518 for 4.00 KG of Cooking Gas @ N690.00','2023-03-12 12:31:05','',''),('1','311',2932,'','6.1','4',0.00,2760.00,'Retail Sale Id 1518 for retail product','2023-03-12 12:31:05','',''),('1','311',2933,'','20','3',3500.00,0.00,'Retail Sale Id 1519 for 5.07 KG of Cooking Gas @ N690.00','2023-03-12 12:35:29','',''),('1','311',2934,'','6.1','4',0.00,3500.00,'Retail Sale Id 1519 for retail product','2023-03-12 12:35:29','',''),('1','311',2935,'','20','3',4000.00,0.00,'Retail Sale Id 1520 for 5.80 KG of Cooking Gas @ N690.00','2023-03-12 12:38:57','',''),('1','311',2936,'','6.1','4',0.00,4000.00,'Retail Sale Id 1520 for retail product','2023-03-12 12:38:57','',''),('1','311',2937,'','20','3',2760.00,0.00,'Retail Sale Id 1521 for 4.00 KG of Cooking Gas @ N690.00','2023-03-12 12:43:43','',''),('1','311',2938,'','6.1','4',0.00,2760.00,'Retail Sale Id 1521 for retail product','2023-03-12 12:43:43','',''),('1','311',2939,'','20','3',3000.00,0.00,'Retail Sale Id 1522 for 4.35 KG of Cooking Gas @ N690.00','2023-03-12 12:44:48','',''),('1','311',2940,'','6.1','4',0.00,3000.00,'Retail Sale Id 1522 for retail product','2023-03-12 12:44:48','',''),('1','311',2941,'','20','3',1400.00,0.00,'Retail Sale Id 1523 for 2.03 KG of Cooking Gas @ N690.00','2023-03-12 12:47:29','',''),('1','311',2942,'','6.1','4',0.00,1400.00,'Retail Sale Id 1523 for retail product','2023-03-12 12:47:29','',''),('1','311',2943,'','20','3',2760.00,0.00,'Retail Sale Id 1524 for 4.00 KG of Cooking Gas @ N690.00','2023-03-12 12:48:36','',''),('1','311',2944,'','6.1','4',0.00,2760.00,'Retail Sale Id 1524 for retail product','2023-03-12 12:48:36','',''),('1','311',2945,'','20','3',3000.00,0.00,'Retail Sale Id 1525 for 4.35 KG of Cooking Gas @ N690.00','2023-03-12 12:56:25','',''),('1','311',2946,'','6.1','4',0.00,3000.00,'Retail Sale Id 1525 for retail product','2023-03-12 12:56:25','',''),('1','311',2947,'','20','3',3450.00,0.00,'Retail Sale Id 1526 for 5.00 KG of Cooking Gas @ N690.00','2023-03-12 12:58:51','',''),('1','311',2948,'','6.1','4',0.00,3450.00,'Retail Sale Id 1526 for retail product','2023-03-12 12:58:51','',''),('1','311',2949,'','20','3',2070.00,0.00,'Retail Sale Id 1527 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 13:01:26','',''),('1','311',2950,'','6.1','4',0.00,2070.00,'Retail Sale Id 1527 for retail product','2023-03-12 13:01:26','',''),('1','311',2951,'','20','3',7590.00,0.00,'Retail Sale Id 1528 for multiple products','2023-03-12 13:05:38','',''),('1','311',2952,'','6.1','4',0.00,7590.00,'Retail Sale Id 1528 for retail product','2023-03-12 13:05:38','',''),('1','311',2953,'','20','3',2070.00,0.00,'Retail Sale Id 1529 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 13:07:02','',''),('1','311',2954,'','6.1','4',0.00,2070.00,'Retail Sale Id 1529 for retail product','2023-03-12 13:07:02','',''),('1','311',2955,'','20','3',2070.00,0.00,'Retail Sale Id 1530 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 13:11:00','',''),('1','311',2956,'','6.1','4',0.00,2070.00,'Retail Sale Id 1530 for retail product','2023-03-12 13:11:00','',''),('1','311',2957,'','20','3',1200.00,0.00,'Retail Sale Id 1531 for 1.74 KG of Cooking Gas @ N690.00','2023-03-12 13:13:27','',''),('1','311',2958,'','6.1','4',0.00,1200.00,'Retail Sale Id 1531 for retail product','2023-03-12 13:13:27','',''),('1','311',2959,'','20','3',4140.00,0.00,'Retail Sale Id 1532 for 6.00 KG of Cooking Gas @ N690.00','2023-03-12 13:25:37','',''),('1','311',2960,'','6.1','4',0.00,4140.00,'Retail Sale Id 1532 for retail product','2023-03-12 13:25:37','',''),('1','311',2961,'','20','3',2760.00,0.00,'Retail Sale Id 1533 for 4.00 KG of Cooking Gas @ N690.00','2023-03-12 13:27:32','',''),('1','311',2962,'','6.1','4',0.00,2760.00,'Retail Sale Id 1533 for retail product','2023-03-12 13:27:32','',''),('1','311',2963,'','20','3',2070.00,0.00,'Retail Sale Id 1534 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 13:38:56','',''),('1','311',2964,'','6.1','4',0.00,2070.00,'Retail Sale Id 1534 for retail product','2023-03-12 13:38:56','',''),('1','311',2965,'','20','3',1380.00,0.00,'Retail Sale Id 1535 for 2.00 KG of Cooking Gas @ N690.00','2023-03-12 13:40:26','',''),('1','311',2966,'','6.1','4',0.00,1380.00,'Retail Sale Id 1535 for retail product','2023-03-12 13:40:26','',''),('1','311',2967,'','20','3',1000.00,0.00,'Retail Sale Id 1536 for 1.45 KG of Cooking Gas @ N690.00','2023-03-12 13:44:35','',''),('1','311',2968,'','6.1','4',0.00,1000.00,'Retail Sale Id 1536 for retail product','2023-03-12 13:44:35','',''),('1','311',2969,'','20','3',1000.00,0.00,'Retail Sale Id 1537 for 1.45 KG of Cooking Gas @ N690.00','2023-03-12 13:53:29','',''),('1','311',2970,'','6.1','4',0.00,1000.00,'Retail Sale Id 1537 for retail product','2023-03-12 13:53:29','',''),('1','311',2971,'','20','3',3000.00,0.00,'Retail Sale Id 1538 for 4.35 KG of Cooking Gas @ N690.00','2023-03-12 13:54:52','',''),('1','311',2972,'','6.1','4',0.00,3000.00,'Retail Sale Id 1538 for retail product','2023-03-12 13:54:52','',''),('1','311',2973,'','20','3',1500.00,0.00,'Retail Sale Id 1539 for 2.17 KG of Cooking Gas @ N690.00','2023-03-12 13:58:44','',''),('1','311',2974,'','6.1','4',0.00,1500.00,'Retail Sale Id 1539 for retail product','2023-03-12 13:58:44','',''),('1','311',2975,'','20','3',6900.00,0.00,'Retail Sale Id 1540 for 10.00 KG of Cooking Gas @ N690.00','2023-03-12 14:00:40','',''),('1','311',2976,'','6.1','4',0.00,6900.00,'Retail Sale Id 1540 for retail product','2023-03-12 14:00:40','',''),('1','311',2977,'','20','3',4140.00,0.00,'Retail Sale Id 1541 for 6.00 KG of Cooking Gas @ N690.00','2023-03-12 14:01:47','',''),('1','311',2978,'','6.1','4',0.00,4140.00,'Retail Sale Id 1541 for retail product','2023-03-12 14:01:47','',''),('1','311',2979,'','20','3',2070.00,0.00,'Retail Sale Id 1542 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 14:02:59','',''),('1','311',2980,'','6.1','4',0.00,2070.00,'Retail Sale Id 1542 for retail product','2023-03-12 14:02:59','',''),('1','311',2981,'','20','3',3450.00,0.00,'Retail Sale Id 1543 for 5.00 KG of Cooking Gas @ N690.00','2023-03-12 14:05:11','',''),('1','311',2982,'','6.1','4',0.00,3450.00,'Retail Sale Id 1543 for retail product','2023-03-12 14:05:11','',''),('1','311',2983,'','20','3',4140.00,0.00,'Retail Sale Id 1544 for 6.00 KG of Cooking Gas @ N690.00','2023-03-12 14:06:09','',''),('1','311',2984,'','6.1','4',0.00,4140.00,'Retail Sale Id 1544 for retail product','2023-03-12 14:06:09','',''),('1','311',2985,'','20','3',1000.00,0.00,'Retail Sale Id 1545 for 1.45 KG of Cooking Gas @ N690.00','2023-03-12 14:07:46','',''),('1','311',2986,'','6.1','4',0.00,1000.00,'Retail Sale Id 1545 for retail product','2023-03-12 14:07:46','',''),('1','311',2987,'','20','3',5520.00,0.00,'Retail Sale Id 1548 for multiple products','2023-03-12 14:14:29','',''),('1','311',2988,'','6.1','4',0.00,5520.00,'Retail Sale Id 1548 for retail product','2023-03-12 14:14:29','',''),('1','311',2989,'','20','3',9660.00,0.00,'Retail Sale Id 1549 for multiple products','2023-03-12 14:15:39','',''),('1','311',2990,'','6.1','4',0.00,9660.00,'Retail Sale Id 1549 for retail product','2023-03-12 14:15:39','',''),('1','311',2991,'','20','3',5520.00,0.00,'Retail Sale Id 1546 for 8.00 KG of Cooking Gas @ N690.00','2023-03-12 14:18:55','',''),('1','311',2992,'','6.1','4',0.00,5520.00,'Retail Sale Id 1546 for retail product','2023-03-12 14:18:55','',''),('1','311',2993,'','20','3',2070.00,0.00,'Retail Sale Id 1551 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 14:23:03','',''),('1','311',2994,'','6.1','4',0.00,2070.00,'Retail Sale Id 1551 for retail product','2023-03-12 14:23:03','',''),('1','311',2995,'','20','3',3795.00,0.00,'Retail Sale Id 1552 for 5.50 KG of Cooking Gas @ N690.00','2023-03-12 14:26:16','',''),('1','311',2996,'','6.1','4',0.00,3795.00,'Retail Sale Id 1552 for retail product','2023-03-12 14:26:16','',''),('1','311',2997,'','20','3',6000.00,0.00,'Retail Sale Id 1553 for 8.70 KG of Cooking Gas @ N690.00','2023-03-12 14:29:48','',''),('1','311',2998,'','6.1','4',0.00,6000.00,'Retail Sale Id 1553 for retail product','2023-03-12 14:29:48','',''),('1','311',2999,'','20','3',4000.00,0.00,'Retail Sale Id 1555 for 5.80 KG of Cooking Gas @ N690.00','2023-03-12 14:33:13','',''),('1','311',3000,'','6.1','4',0.00,4000.00,'Retail Sale Id 1555 for retail product','2023-03-12 14:33:13','',''),('1','311',3001,'','20','3',1000.00,0.00,'Retail Sale Id 1556 for 1.45 KG of Cooking Gas @ N690.00','2023-03-12 14:33:57','',''),('1','311',3002,'','6.1','4',0.00,1000.00,'Retail Sale Id 1556 for retail product','2023-03-12 14:33:57','',''),('1','311',3003,'','20','3',2000.00,0.00,'Retail Sale Id 1557 for 2.90 KG of Cooking Gas @ N690.00','2023-03-12 15:00:07','',''),('1','311',3004,'','6.1','4',0.00,2000.00,'Retail Sale Id 1557 for retail product','2023-03-12 15:00:07','',''),('1','311',3005,'','20','3',4000.00,0.00,'Retail Sale Id 1558 for 5.80 KG of Cooking Gas @ N690.00','2023-03-12 15:04:14','',''),('1','311',3006,'','6.1','4',0.00,4000.00,'Retail Sale Id 1558 for retail product','2023-03-12 15:04:14','',''),('1','311',3007,'','20','3',1500.00,0.00,'Retail Sale Id 1559 for 2.17 KG of Cooking Gas @ N690.00','2023-03-12 15:05:38','',''),('1','311',3008,'','6.1','4',0.00,1500.00,'Retail Sale Id 1559 for retail product','2023-03-12 15:05:38','',''),('1','311',3009,'','20','3',2000.00,0.00,'Retail Sale Id 1560 for 2.90 KG of Cooking Gas @ N690.00','2023-03-12 15:07:00','',''),('1','311',3010,'','6.1','4',0.00,2000.00,'Retail Sale Id 1560 for retail product','2023-03-12 15:07:00','',''),('1','311',3011,'','20','3',6900.00,0.00,'Retail Sale Id 1561 for 10.00 KG of Cooking Gas @ N690.00','2023-03-12 15:07:55','',''),('1','311',3012,'','6.1','4',0.00,6900.00,'Retail Sale Id 1561 for retail product','2023-03-12 15:07:55','',''),('1','311',3013,'','20','3',3000.00,0.00,'Retail Sale Id 1562 for 4.35 KG of Cooking Gas @ N690.00','2023-03-12 15:10:19','',''),('1','311',3014,'','6.1','4',0.00,3000.00,'Retail Sale Id 1562 for retail product','2023-03-12 15:10:19','',''),('1','311',3015,'','20','3',1380.00,0.00,'Retail Sale Id 1563 for 2.00 KG of Cooking Gas @ N690.00','2023-03-12 15:11:40','',''),('1','311',3016,'','6.1','4',0.00,1380.00,'Retail Sale Id 1563 for retail product','2023-03-12 15:11:40','',''),('1','311',3017,'','20','3',4140.00,0.00,'Retail Sale Id 1564 for 6.00 KG of Cooking Gas @ N690.00','2023-03-12 15:12:39','',''),('1','311',3018,'','6.1','4',0.00,4140.00,'Retail Sale Id 1564 for retail product','2023-03-12 15:12:39','',''),('1','311',3019,'','20','3',1380.00,0.00,'Retail Sale Id 1565 for 2.00 KG of Cooking Gas @ N690.00','2023-03-12 15:16:20','',''),('1','311',3020,'','6.1','4',0.00,1380.00,'Retail Sale Id 1565 for retail product','2023-03-12 15:16:20','',''),('1','311',3021,'','20','3',4140.00,0.00,'Retail Sale Id 1567 for 6.00 KG of Cooking Gas @ N690.00','2023-03-12 15:19:00','',''),('1','311',3022,'','6.1','4',0.00,4140.00,'Retail Sale Id 1567 for retail product','2023-03-12 15:19:00','',''),('1','311',3023,'','20','3',8650.00,0.00,'Retail Sale Id 1568 for 12.54 KG of Cooking Gas @ N690.00','2023-03-12 15:21:46','',''),('1','311',3024,'','6.1','4',0.00,8650.00,'Retail Sale Id 1568 for retail product','2023-03-12 15:21:46','',''),('1','311',3025,'','20','3',8625.00,0.00,'Retail Sale Id 1569 for 12.50 KG of Cooking Gas @ N690.00','2023-03-12 15:35:22','',''),('1','311',3026,'','6.1','4',0.00,8625.00,'Retail Sale Id 1569 for retail product','2023-03-12 15:35:22','',''),('1','311',3027,'','20','3',1000.00,0.00,'Retail Sale Id 1570 for 1.45 KG of Cooking Gas @ N690.00','2023-03-12 15:37:05','',''),('1','311',3028,'','6.1','4',0.00,1000.00,'Retail Sale Id 1570 for retail product','2023-03-12 15:37:05','',''),('1','311',3029,'','20','3',4140.00,0.00,'Retail Sale Id 1571 for 6.00 KG of Cooking Gas @ N690.00','2023-03-12 15:39:31','',''),('1','311',3030,'','6.1','4',0.00,4140.00,'Retail Sale Id 1571 for retail product','2023-03-12 15:39:31','',''),('1','311',3031,'','20','3',4830.00,0.00,'Retail Sale Id 1572 for 7.00 KG of Cooking Gas @ N690.00','2023-03-12 15:44:13','',''),('1','311',3032,'','6.1','4',0.00,4830.00,'Retail Sale Id 1572 for retail product','2023-03-12 15:44:13','',''),('1','311',3033,'','20','3',4200.00,0.00,'Retail Sale Id 1573 for 6.09 KG of Cooking Gas @ N690.00','2023-03-12 15:45:40','',''),('1','311',3034,'','6.1','4',0.00,4200.00,'Retail Sale Id 1573 for retail product','2023-03-12 15:45:40','',''),('1','311',3035,'','20','3',1500.00,0.00,'Retail Sale Id 1574 for 2.17 KG of Cooking Gas @ N690.00','2023-03-12 15:47:43','',''),('1','311',3036,'','6.1','4',0.00,1500.00,'Retail Sale Id 1574 for retail product','2023-03-12 15:47:43','',''),('1','311',3037,'','20','3',3000.00,0.00,'Retail Sale Id 1575 for 4.35 KG of Cooking Gas @ N690.00','2023-03-12 15:55:22','',''),('1','311',3038,'','6.1','4',0.00,3000.00,'Retail Sale Id 1575 for retail product','2023-03-12 15:55:22','',''),('1','311',3039,'','20','3',1380.00,0.00,'Retail Sale Id 1576 for 2.00 KG of Cooking Gas @ N690.00','2023-03-12 15:57:12','',''),('1','311',3040,'','6.1','4',0.00,1380.00,'Retail Sale Id 1576 for retail product','2023-03-12 15:57:12','',''),('1','311',3041,'','20','3',1380.00,0.00,'Retail Sale Id 1577 for 2.00 KG of Cooking Gas @ N690.00','2023-03-12 16:00:44','',''),('1','311',3042,'','6.1','4',0.00,1380.00,'Retail Sale Id 1577 for retail product','2023-03-12 16:00:44','',''),('1','311',3043,'','20','3',700.00,0.00,'Retail Sale Id 1579 for 1.01 KG of Cooking Gas @ N690.00','2023-03-12 16:04:27','',''),('1','311',3044,'','6.1','4',0.00,700.00,'Retail Sale Id 1579 for retail product','2023-03-12 16:04:27','',''),('1','311',3045,'','20','3',8625.00,0.00,'Retail Sale Id 1580 for 12.50 KG of Cooking Gas @ N690.00','2023-03-12 16:07:16','',''),('1','311',3046,'','6.1','4',0.00,8625.00,'Retail Sale Id 1580 for retail product','2023-03-12 16:07:16','',''),('1','311',3047,'','20','3',4830.00,0.00,'Retail Sale Id 1581 for 7.00 KG of Cooking Gas @ N690.00','2023-03-12 16:09:17','',''),('1','311',3048,'','6.1','4',0.00,4830.00,'Retail Sale Id 1581 for retail product','2023-03-12 16:09:17','',''),('1','311',3049,'','20','3',1725.00,0.00,'Retail Sale Id 1582 for 2.50 KG of Cooking Gas @ N690.00','2023-03-12 16:17:24','',''),('1','311',3050,'','6.1','4',0.00,1725.00,'Retail Sale Id 1582 for retail product','2023-03-12 16:17:24','',''),('1','311',3051,'','20','3',1380.00,0.00,'Retail Sale Id 1583 for 2.00 KG of Cooking Gas @ N690.00','2023-03-12 16:18:09','',''),('1','311',3052,'','6.1','4',0.00,1380.00,'Retail Sale Id 1583 for retail product','2023-03-12 16:18:09','',''),('1','311',3053,'','20','3',1500.00,0.00,'Retail Sale Id 1584 for 2.17 KG of Cooking Gas @ N690.00','2023-03-12 16:19:52','',''),('1','311',3054,'','6.1','4',0.00,1500.00,'Retail Sale Id 1584 for retail product','2023-03-12 16:19:52','',''),('1','311',3055,'','20','3',6900.00,0.00,'Retail Sale Id 1585 for 10.00 KG of Cooking Gas @ N690.00','2023-03-12 16:26:48','',''),('1','311',3056,'','6.1','4',0.00,6900.00,'Retail Sale Id 1585 for retail product','2023-03-12 16:26:48','',''),('1','311',3057,'','20','3',2070.00,0.00,'Retail Sale Id 1586 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 16:32:43','',''),('1','311',3058,'','6.1','4',0.00,2070.00,'Retail Sale Id 1586 for retail product','2023-03-12 16:32:43','',''),('1','311',3059,'','20','3',4830.00,0.00,'Retail Sale Id 1587 for 7.00 KG of Cooking Gas @ N690.00','2023-03-12 16:34:51','',''),('1','311',3060,'','6.1','4',0.00,4830.00,'Retail Sale Id 1587 for retail product','2023-03-12 16:34:51','',''),('1','311',3061,'','20','3',1380.00,0.00,'Retail Sale Id 1588 for 2.00 KG of Cooking Gas @ N690.00','2023-03-12 16:35:54','',''),('1','311',3062,'','6.1','4',0.00,1380.00,'Retail Sale Id 1588 for retail product','2023-03-12 16:35:54','',''),('1','311',3063,'','20','3',1380.00,0.00,'Retail Sale Id 1589 for 2.00 KG of Cooking Gas @ N690.00','2023-03-12 16:37:00','',''),('1','311',3064,'','6.1','4',0.00,1380.00,'Retail Sale Id 1589 for retail product','2023-03-12 16:37:00','',''),('1','311',3065,'','20','3',4140.00,0.00,'Retail Sale Id 1590 for 6.00 KG of Cooking Gas @ N690.00','2023-03-12 16:42:13','',''),('1','311',3066,'','6.1','4',0.00,4140.00,'Retail Sale Id 1590 for retail product','2023-03-12 16:42:13','',''),('1','311',3067,'','20','3',700.00,0.00,'Retail Sale Id 1591 for 1.01 KG of Cooking Gas @ N690.00','2023-03-12 16:44:09','',''),('1','311',3068,'','6.1','4',0.00,700.00,'Retail Sale Id 1591 for retail product','2023-03-12 16:44:09','',''),('1','311',3069,'','20','3',3450.00,0.00,'Retail Sale Id 1592 for 5.00 KG of Cooking Gas @ N690.00','2023-03-12 16:45:03','',''),('1','311',3070,'','6.1','4',0.00,3450.00,'Retail Sale Id 1592 for retail product','2023-03-12 16:45:03','',''),('1','311',3071,'','20','3',2070.00,0.00,'Retail Sale Id 1593 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 16:46:24','',''),('1','311',3072,'','6.1','4',0.00,2070.00,'Retail Sale Id 1593 for retail product','2023-03-12 16:46:24','',''),('1','311',3073,'','20','3',1000.00,0.00,'Retail Sale Id 1594 for 1.45 KG of Cooking Gas @ N690.00','2023-03-12 16:50:21','',''),('1','311',3074,'','6.1','4',0.00,1000.00,'Retail Sale Id 1594 for retail product','2023-03-12 16:50:21','',''),('1','311',3075,'','20','3',8625.00,0.00,'Retail Sale Id 1595 for 12.50 KG of Cooking Gas @ N690.00','2023-03-12 16:56:02','',''),('1','311',3076,'','6.1','4',0.00,8625.00,'Retail Sale Id 1595 for retail product','2023-03-12 16:56:02','',''),('1','311',3077,'','20','3',700.00,0.00,'Retail Sale Id 1596 for 1.01 KG of Cooking Gas @ N690.00','2023-03-12 16:57:49','',''),('1','311',3078,'','6.1','4',0.00,700.00,'Retail Sale Id 1596 for retail product','2023-03-12 16:57:49','',''),('1','311',3079,'','20','3',1000.00,0.00,'Retail Sale Id 1597 for 1.45 KG of Cooking Gas @ N690.00','2023-03-12 17:05:19','',''),('1','311',3080,'','6.1','4',0.00,1000.00,'Retail Sale Id 1597 for retail product','2023-03-12 17:05:19','',''),('1','311',3081,'','20','3',6210.00,0.00,'Retail Sale Id 1598 for 9.00 KG of Cooking Gas @ N690.00','2023-03-12 17:14:55','',''),('1','311',3082,'','6.1','4',0.00,6210.00,'Retail Sale Id 1598 for retail product','2023-03-12 17:14:55','',''),('1','311',3083,'','20','3',0.00,4830.00,'Return of Retail Sale Id 1581 for products','2023-03-12 17:18:53','',''),('1','311',3084,'','','',4830.00,0.00,'Return of Retail Sale Id 1581 for products','2023-03-12 17:18:53','',''),('1','311',3085,'','20','3',4512.60,0.00,'Retail Sale Id 1599 for 6.54 KG of Cooking Gas @ N690.00','2023-03-12 17:20:03','',''),('1','311',3086,'','6.1','4',0.00,4512.60,'Retail Sale Id 1599 for retail product','2023-03-12 17:20:03','',''),('1','311',3087,'','20','3',4830.00,0.00,'Retail Sale Id 1601 for 7.00 KG of Cooking Gas @ N690.00','2023-03-12 17:21:09','',''),('1','311',3088,'','6.1','4',0.00,4830.00,'Retail Sale Id 1601 for retail product','2023-03-12 17:21:09','',''),('1','311',3089,'','20','3',690.00,0.00,'Retail Sale Id 1516 for 1.00 KG of Cooking Gas @ N690.00','2023-03-12 17:23:30','',''),('1','311',3090,'','6.1','4',0.00,690.00,'Retail Sale Id 1516 for retail product','2023-03-12 17:23:30','',''),('1','311',3091,'','20','3',2070.00,0.00,'Retail Sale Id 1602 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 17:24:21','',''),('1','311',3092,'','6.1','4',0.00,2070.00,'Retail Sale Id 1602 for retail product','2023-03-12 17:24:21','',''),('1','311',3093,'','20','3',2070.00,0.00,'Retail Sale Id 1603 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 17:28:41','',''),('1','311',3094,'','6.1','4',0.00,2070.00,'Retail Sale Id 1603 for retail product','2023-03-12 17:28:41','',''),('1','311',3095,'','20','3',2070.00,0.00,'Retail Sale Id 1604 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 17:30:50','',''),('1','311',3096,'','6.1','4',0.00,2070.00,'Retail Sale Id 1604 for retail product','2023-03-12 17:30:50','',''),('1','311',3097,'','20','3',8625.00,0.00,'Retail Sale Id 1605 for 12.50 KG of Cooking Gas @ N690.00','2023-03-12 17:36:03','',''),('1','311',3098,'','6.1','4',0.00,8625.00,'Retail Sale Id 1605 for retail product','2023-03-12 17:36:03','',''),('1','311',3099,'','20','3',1500.00,0.00,'Retail Sale Id 1606 for 2.17 KG of Cooking Gas @ N690.00','2023-03-12 17:37:00','',''),('1','311',3100,'','6.1','4',0.00,1500.00,'Retail Sale Id 1606 for retail product','2023-03-12 17:37:00','',''),('1','311',3101,'','20','3',4140.00,0.00,'Retail Sale Id 1607 for 6.00 KG of Cooking Gas @ N690.00','2023-03-12 17:41:01','',''),('1','311',3102,'','6.1','4',0.00,4140.00,'Retail Sale Id 1607 for retail product','2023-03-12 17:41:01','',''),('1','311',3103,'','20','3',2200.00,0.00,'Retail Sale Id 1608 for 3.19 KG of Cooking Gas @ N690.00','2023-03-12 17:45:31','',''),('1','311',3104,'','6.1','4',0.00,2200.00,'Retail Sale Id 1608 for retail product','2023-03-12 17:45:31','',''),('1','311',3105,'','20','3',2070.00,0.00,'Retail Sale Id 1609 for 3.00 KG of Cooking Gas @ N690.00','2023-03-12 17:47:04','',''),('1','311',3106,'','6.1','4',0.00,2070.00,'Retail Sale Id 1609 for retail product','2023-03-12 17:47:04','',''),('1','311',3107,'','20','3',3450.00,0.00,'Retail Sale Id 1611 for 5.00 KG of Cooking Gas @ N690.00','2023-03-12 18:01:07','',''),('1','311',3108,'','6.1','4',0.00,3450.00,'Retail Sale Id 1611 for retail product','2023-03-12 18:01:07','',''),('1','311',3109,'','20','3',6900.00,0.00,'Retail Sale Id 1612 for 10.00 KG of Cooking Gas @ N690.00','2023-03-12 18:03:20','',''),('1','311',3110,'','6.1','4',0.00,6900.00,'Retail Sale Id 1612 for retail product','2023-03-12 18:03:20','',''),('1','311',3111,'','20','3',2760.00,0.00,'Retail Sale Id 1614 for 4.00 KG of Cooking Gas @ N690.00','2023-03-12 18:06:00','',''),('1','311',3112,'','6.1','4',0.00,2760.00,'Retail Sale Id 1614 for retail product','2023-03-12 18:06:00','',''),('1','311',3113,'','20','3',2000.00,0.00,'Retail Sale Id 1615 for 2.90 KG of Cooking Gas @ N690.00','2023-03-12 18:08:56','',''),('1','311',3114,'','6.1','4',0.00,2000.00,'Retail Sale Id 1615 for retail product','2023-03-12 18:08:56','',''),('1','311',3115,'','20','3',1400.00,0.00,'Retail Sale Id 1616 for 2.03 KG of Cooking Gas @ N690.00','2023-03-12 18:10:00','',''),('1','311',3116,'','6.1','4',0.00,1400.00,'Retail Sale Id 1616 for retail product','2023-03-12 18:10:00','',''),('1','311',3117,'','20','3',1380.00,0.00,'Retail Sale Id 1617 for 2.00 KG of Cooking Gas @ N690.00','2023-03-12 18:14:21','',''),('1','311',3118,'','6.1','4',0.00,1380.00,'Retail Sale Id 1617 for retail product','2023-03-12 18:14:21','',''),('1','311',3119,'','20','3',2800.00,0.00,'Retail Sale Id 1618 for 4.06 KG of Cooking Gas @ N690.00','2023-03-12 18:18:52','',''),('1','311',3120,'','6.1','4',0.00,2800.00,'Retail Sale Id 1618 for retail product','2023-03-12 18:18:52','',''),('1','311',3121,'','20','3',39530.00,0.00,'Retail Sale Id 1619 for 59.00 KG of Cooking Gas @ N670.00','2023-03-12 18:22:03','',''),('1','311',3122,'','6.1','4',0.00,39530.00,'Retail Sale Id 1619 for retail product','2023-03-12 18:22:03','',''),('1','311',3123,'','20','3',3450.00,0.00,'Retail Sale Id 1620 for 5.00 KG of Cooking Gas @ N690.00','2023-03-12 18:24:08','',''),('1','311',3124,'','6.1','4',0.00,3450.00,'Retail Sale Id 1620 for retail product','2023-03-12 18:24:08','',''),('1','311',3125,'','20','3',4830.00,0.00,'Retail Sale Id 1621 for 7.00 KG of Cooking Gas @ N690.00','2023-03-12 18:35:51','',''),('1','311',3126,'','6.1','4',0.00,4830.00,'Retail Sale Id 1621 for retail product','2023-03-12 18:35:51','',''),('1','311',3127,'','20','3',0.00,6900.00,'Return of Retail Sale Id 1612 for products','2023-03-12 18:39:13','',''),('1','311',3128,'','','',6900.00,0.00,'Return of Retail Sale Id 1612 for products','2023-03-12 18:39:13','',''),('1','311',3129,'','20','3',6417.00,0.00,'Retail Sale Id 1622 for 9.30 KG of Cooking Gas @ N690.00','2023-03-12 18:39:57','',''),('1','311',3130,'','6.1','4',0.00,6417.00,'Retail Sale Id 1622 for retail product','2023-03-12 18:39:57','',''),('1','311',3131,'','20','3',0.00,6900.00,'Return of Retail Sale Id 1509 for products','2023-03-12 18:48:26','',''),('1','311',3132,'','','',6900.00,0.00,'Return of Retail Sale Id 1509 for products','2023-03-12 18:48:26','',''),('1','311',3133,'','20','3',3000.00,0.00,'Retail Sale Id 1624 for 4.35 KG of Cooking Gas @ N690.00','2023-03-12 18:51:01','',''),('1','311',3134,'','6.1','4',0.00,3000.00,'Retail Sale Id 1624 for retail product','2023-03-12 18:51:01','',''),('1','311',3135,'','20','3',7134.60,0.00,'Retail Sale Id 1625 for 10.34 KG of Cooking Gas @ N690.00','2023-03-12 20:26:15','',''),('1','311',3136,'','6.1','4',0.00,7134.60,'Retail Sale Id 1625 for retail product','2023-03-12 20:26:15','',''),('1','311',3137,'','20','3',0.00,7134.60,'Return of Retail Sale Id 1625 for products','2023-03-12 20:29:05','',''),('1','311',3138,'','','',7134.60,0.00,'Return of Retail Sale Id 1625 for products','2023-03-12 20:29:05','',''),('1','311',3139,'','20','3',5087.08,0.00,'Retail Sale Id 1626 for 7.37 KG of Cooking Gas @ N690.00','2023-03-12 20:32:27','',''),('1','311',3140,'','6.1','4',0.00,5087.08,'Retail Sale Id 1626 for retail product','2023-03-12 20:32:27','',''),('1','311',3141,'','20','3',0.00,0.00,'Sales from shift 27 on 2023-03-12 20:46:27 ','2023-03-12 20:46:27','',''),('1','311',3142,'','6.1','4',0.00,0.00,'Sales from shift 27 on 2023-03-12 20:46:27 ','2023-03-12 20:46:27','',''),('1','311',3143,'','2','15',13450.00,0.00,'Payment Id 59 for invoice:23, receipt: 0051 by AA RANO NIGERIA LTD','2023-03-13 12:43:56','',''),('1','311',3144,'','supplier','1',0.00,13450.00,'Payment Id 59 for invoice:23, receipt: 0051 by AA RANO NIGERIA LTD','2023-03-13 12:43:56','',''),('1','311',3145,'','2','15',42260.00,0.00,'Payment Id 32 for invoice:15, receipt: 0024 by AA RANO NIGERIA LTD','2023-03-13 12:45:05','',''),('1','311',3146,'','supplier','1',0.00,42260.00,'Payment Id 32 for invoice:15, receipt: 0024 by AA RANO NIGERIA LTD','2023-03-13 12:45:05','',''),('1','311',3147,'','2','15',47670.00,0.00,'Payment Id 38 for invoice:14, receipt: 0030 by AA RANO NIGERIA LTD','2023-03-13 12:45:41','',''),('1','311',3148,'','supplier','1',0.00,47670.00,'Payment Id 38 for invoice:14, receipt: 0030 by AA RANO NIGERIA LTD','2023-03-13 12:45:41','',''),('1','311',3149,'','2','15',121056.00,0.00,'Payment Id 72 for invoice:16, receipt: 0067 by AA RANO NIGERIA LTD','2023-03-13 12:49:50','',''),('1','311',3150,'','supplier','1',0.00,121056.00,'Payment Id 72 for invoice:16, receipt: 0067 by AA RANO NIGERIA LTD','2023-03-13 12:49:50','',''),('1','311',3151,'','2','15',150000.00,0.00,'Payment Id 65 for invoice:16, receipt: 0055 by AA RANO NIGERIA LTD','2023-03-13 12:49:50','',''),('1','311',3152,'','supplier','1',0.00,150000.00,'Payment Id 65 for invoice:16, receipt: 0055 by AA RANO NIGERIA LTD','2023-03-13 12:49:50','',''),('1','311',3153,'','2','20',73870.00,0.00,'Payment Id 68 for invoice:25, receipt: 0058 by AA RANO NIGERIA LTD','2023-03-13 17:39:46','',''),('1','311',3154,'','supplier','1',0.00,73870.00,'Payment Id 68 for invoice:25, receipt: 0058 by AA RANO NIGERIA LTD','2023-03-13 17:39:46','',''),('1','311',3155,'','2','9',196120.01,0.00,'Payment Id 67 for invoice:25, receipt: 0057 by AA RANO NIGERIA LTD','2023-03-13 17:39:46','',''),('1','311',3156,'','supplier','1',0.00,196120.01,'Payment Id 67 for invoice:25, receipt: 0057 by AA RANO NIGERIA LTD','2023-03-13 17:39:46','',''),('1','311',3157,'','2','20',360550.00,0.00,'Payment Id 71 for invoice:26, receipt: 0062 by AA RANO NIGERIA LTD','2023-03-13 17:40:22','',''),('1','311',3158,'','supplier','1',0.00,360550.00,'Payment Id 71 for invoice:26, receipt: 0062 by AA RANO NIGERIA LTD','2023-03-13 17:40:22','',''),('1','311',3159,'','2','9',84340.00,0.00,'Payment Id 70 for invoice:26, receipt: 0061 by AA RANO NIGERIA LTD','2023-03-13 17:40:22','',''),('1','311',3160,'','supplier','1',0.00,84340.00,'Payment Id 70 for invoice:26, receipt: 0061 by AA RANO NIGERIA LTD','2023-03-13 17:40:22','',''),('1','311',3161,'','20','3',2070.00,0.00,'Retail Sale Id 1627 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 08:17:39','',''),('1','311',3162,'','6.1','4',0.00,2070.00,'Retail Sale Id 1627 for retail product','2023-03-14 08:17:39','',''),('1','311',3163,'','20','3',4140.00,0.00,'Retail Sale Id 1628 for 6.00 KG of Cooking Gas @ N690.00','2023-03-14 08:21:18','',''),('1','311',3164,'','6.1','4',0.00,4140.00,'Retail Sale Id 1628 for retail product','2023-03-14 08:21:18','',''),('1','311',3165,'','20','3',3450.00,0.00,'Retail Sale Id 1629 for 5.00 KG of Cooking Gas @ N690.00','2023-03-14 08:22:14','',''),('1','311',3166,'','6.1','4',0.00,3450.00,'Retail Sale Id 1629 for retail product','2023-03-14 08:22:14','',''),('1','311',3167,'','20','3',6900.00,0.00,'Retail Sale Id 1630 for 10.00 KG of Cooking Gas @ N690.00','2023-03-14 08:24:31','',''),('1','311',3168,'','6.1','4',0.00,6900.00,'Retail Sale Id 1630 for retail product','2023-03-14 08:24:31','',''),('1','311',3169,'','20','3',8625.00,0.00,'Retail Sale Id 1631 for 12.50 KG of Cooking Gas @ N690.00','2023-03-14 08:25:27','',''),('1','311',3170,'','6.1','4',0.00,8625.00,'Retail Sale Id 1631 for retail product','2023-03-14 08:25:27','',''),('1','311',3171,'','20','3',800.00,0.00,'Retail Sale Id 1632 for 1.16 KG of Cooking Gas @ N690.00','2023-03-14 08:26:07','',''),('1','311',3172,'','6.1','4',0.00,800.00,'Retail Sale Id 1632 for retail product','2023-03-14 08:26:07','',''),('1','311',3173,'','20','3',4140.00,0.00,'Retail Sale Id 1633 for 6.00 KG of Cooking Gas @ N690.00','2023-03-14 08:27:34','',''),('1','311',3174,'','6.1','4',0.00,4140.00,'Retail Sale Id 1633 for retail product','2023-03-14 08:27:34','',''),('1','311',3175,'','20','3',4830.00,0.00,'Retail Sale Id 1634 for 7.00 KG of Cooking Gas @ N690.00','2023-03-14 08:28:34','',''),('1','311',3176,'','6.1','4',0.00,4830.00,'Retail Sale Id 1634 for retail product','2023-03-14 08:28:34','',''),('1','311',3177,'','20','3',2000.00,0.00,'Retail Sale Id 1636 for 2.90 KG of Cooking Gas @ N690.00','2023-03-14 08:29:34','',''),('1','311',3178,'','6.1','4',0.00,2000.00,'Retail Sale Id 1636 for retail product','2023-03-14 08:29:34','',''),('1','311',3179,'','20','3',5520.00,0.00,'Retail Sale Id 1637 for 8.00 KG of Cooking Gas @ N690.00','2023-03-14 08:31:03','',''),('1','311',3180,'','6.1','4',0.00,5520.00,'Retail Sale Id 1637 for retail product','2023-03-14 08:31:03','',''),('1','311',3181,'','20','3',4140.00,0.00,'Retail Sale Id 1638 for 6.00 KG of Cooking Gas @ N690.00','2023-03-14 08:31:49','',''),('1','311',3182,'','6.1','4',0.00,4140.00,'Retail Sale Id 1638 for retail product','2023-03-14 08:31:49','',''),('1','311',3183,'','20','3',1380.00,0.00,'Retail Sale Id 1639 for 2.00 KG of Cooking Gas @ N690.00','2023-03-14 08:32:32','',''),('1','311',3184,'','6.1','4',0.00,1380.00,'Retail Sale Id 1639 for retail product','2023-03-14 08:32:32','',''),('1','311',3185,'','20','3',3450.00,0.00,'Retail Sale Id 1640 for 5.00 KG of Cooking Gas @ N690.00','2023-03-14 08:34:21','',''),('1','311',3186,'','6.1','4',0.00,3450.00,'Retail Sale Id 1640 for retail product','2023-03-14 08:34:21','',''),('1','311',3187,'','20','3',2000.00,0.00,'Retail Sale Id 1641 for 2.90 KG of Cooking Gas @ N690.00','2023-03-14 08:35:04','',''),('1','311',3188,'','6.1','4',0.00,2000.00,'Retail Sale Id 1641 for retail product','2023-03-14 08:35:04','',''),('1','311',3189,'','20','3',4830.00,0.00,'Retail Sale Id 1642 for 7.00 KG of Cooking Gas @ N690.00','2023-03-14 08:35:55','',''),('1','311',3190,'','6.1','4',0.00,4830.00,'Retail Sale Id 1642 for retail product','2023-03-14 08:35:55','',''),('1','311',3191,'','20','3',4830.00,0.00,'Retail Sale Id 1643 for 7.00 KG of Cooking Gas @ N690.00','2023-03-14 08:36:46','',''),('1','311',3192,'','6.1','4',0.00,4830.00,'Retail Sale Id 1643 for retail product','2023-03-14 08:36:46','',''),('1','311',3193,'','20','3',1000.00,0.00,'Retail Sale Id 1644 for 1.45 KG of Cooking Gas @ N690.00','2023-03-14 08:37:55','',''),('1','311',3194,'','6.1','4',0.00,1000.00,'Retail Sale Id 1644 for retail product','2023-03-14 08:37:55','',''),('1','311',3195,'','20','3',4140.00,0.00,'Retail Sale Id 1645 for 6.00 KG of Cooking Gas @ N690.00','2023-03-14 08:38:39','',''),('1','311',3196,'','6.1','4',0.00,4140.00,'Retail Sale Id 1645 for retail product','2023-03-14 08:38:39','',''),('1','311',3197,'','20','3',0.00,5520.00,'Return of Retail Sale Id 1637 for products','2023-03-14 08:40:20','',''),('1','311',3198,'','','',5520.00,0.00,'Return of Retail Sale Id 1637 for products','2023-03-14 08:40:20','',''),('1','311',3199,'','20','3',2070.00,0.00,'Retail Sale Id 1647 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 08:41:04','',''),('1','311',3200,'','6.1','4',0.00,2070.00,'Retail Sale Id 1647 for retail product','2023-03-14 08:41:04','',''),('1','311',3201,'','20','3',4830.00,0.00,'Retail Sale Id 1648 for 7.00 KG of Cooking Gas @ N690.00','2023-03-14 08:41:49','',''),('1','311',3202,'','6.1','4',0.00,4830.00,'Retail Sale Id 1648 for retail product','2023-03-14 08:41:49','',''),('1','311',3203,'','20','3',2100.00,0.00,'Retail Sale Id 1649 for 3.04 KG of Cooking Gas @ N690.00','2023-03-14 08:42:44','',''),('1','311',3204,'','6.1','4',0.00,2100.00,'Retail Sale Id 1649 for retail product','2023-03-14 08:42:44','',''),('1','311',3205,'','20','3',4830.00,0.00,'Retail Sale Id 1650 for 7.00 KG of Cooking Gas @ N690.00','2023-03-14 08:43:33','',''),('1','311',3206,'','6.1','4',0.00,4830.00,'Retail Sale Id 1650 for retail product','2023-03-14 08:43:33','',''),('1','311',3207,'','20','3',8625.00,0.00,'Retail Sale Id 1651 for 12.50 KG of Cooking Gas @ N690.00','2023-03-14 08:44:23','',''),('1','311',3208,'','6.1','4',0.00,8625.00,'Retail Sale Id 1651 for retail product','2023-03-14 08:44:23','',''),('1','311',3209,'','20','3',6900.00,0.00,'Retail Sale Id 1652 for 10.00 KG of Cooking Gas @ N690.00','2023-03-14 08:45:19','',''),('1','311',3210,'','6.1','4',0.00,6900.00,'Retail Sale Id 1652 for retail product','2023-03-14 08:45:19','',''),('1','311',3211,'','20','3',4140.00,0.00,'Retail Sale Id 1653 for 6.00 KG of Cooking Gas @ N690.00','2023-03-14 08:48:01','',''),('1','311',3212,'','6.1','4',0.00,4140.00,'Retail Sale Id 1653 for retail product','2023-03-14 08:48:01','',''),('1','311',3213,'','20','3',2070.00,0.00,'Retail Sale Id 1654 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 08:48:51','',''),('1','311',3214,'','6.1','4',0.00,2070.00,'Retail Sale Id 1654 for retail product','2023-03-14 08:48:51','',''),('1','311',3215,'','20','3',4830.00,0.00,'Retail Sale Id 1655 for 7.00 KG of Cooking Gas @ N690.00','2023-03-14 08:49:39','',''),('1','311',3216,'','6.1','4',0.00,4830.00,'Retail Sale Id 1655 for retail product','2023-03-14 08:49:39','',''),('1','311',3217,'','20','3',4830.00,0.00,'Retail Sale Id 1657 for 7.00 KG of Cooking Gas @ N690.00','2023-03-14 08:50:58','',''),('1','311',3218,'','6.1','4',0.00,4830.00,'Retail Sale Id 1657 for retail product','2023-03-14 08:50:58','',''),('1','311',3219,'','20','3',2760.00,0.00,'Retail Sale Id 1658 for 4.00 KG of Cooking Gas @ N690.00','2023-03-14 08:51:43','',''),('1','311',3220,'','6.1','4',0.00,2760.00,'Retail Sale Id 1658 for retail product','2023-03-14 08:51:43','',''),('1','311',3221,'','20','3',2070.00,0.00,'Retail Sale Id 1656 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 08:52:13','',''),('1','311',3222,'','6.1','4',0.00,2070.00,'Retail Sale Id 1656 for retail product','2023-03-14 08:52:13','',''),('1','311',3223,'','20','3',2070.00,0.00,'Retail Sale Id 1659 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 08:53:27','',''),('1','311',3224,'','6.1','4',0.00,2070.00,'Retail Sale Id 1659 for retail product','2023-03-14 08:53:27','',''),('1','311',3225,'','20','3',2070.00,0.00,'Retail Sale Id 1660 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 08:55:49','',''),('1','311',3226,'','6.1','4',0.00,2070.00,'Retail Sale Id 1660 for retail product','2023-03-14 08:55:49','',''),('1','311',3227,'','20','3',6900.00,0.00,'Retail Sale Id 1661 for 10.00 KG of Cooking Gas @ N690.00','2023-03-14 08:57:35','',''),('1','311',3228,'','6.1','4',0.00,6900.00,'Retail Sale Id 1661 for retail product','2023-03-14 08:57:35','',''),('1','311',3229,'','20','3',5000.00,0.00,'Retail Sale Id 1662 for 7.25 KG of Cooking Gas @ N690.00','2023-03-14 08:58:53','',''),('1','311',3230,'','6.1','4',0.00,5000.00,'Retail Sale Id 1662 for retail product','2023-03-14 08:58:53','',''),('1','311',3231,'','20','3',4140.00,0.00,'Retail Sale Id 1665 for 6.00 KG of Cooking Gas @ N690.00','2023-03-14 09:03:27','',''),('1','311',3232,'','6.1','4',0.00,4140.00,'Retail Sale Id 1665 for retail product','2023-03-14 09:03:27','',''),('1','311',3233,'','20','3',2070.00,0.00,'Retail Sale Id 1667 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 09:06:13','',''),('1','311',3234,'','6.1','4',0.00,2070.00,'Retail Sale Id 1667 for retail product','2023-03-14 09:06:13','',''),('1','311',3235,'','20','3',3450.00,0.00,'Retail Sale Id 1668 for 5.00 KG of Cooking Gas @ N690.00','2023-03-14 09:09:44','',''),('1','311',3236,'','6.1','4',0.00,3450.00,'Retail Sale Id 1668 for retail product','2023-03-14 09:09:44','',''),('1','311',3237,'','20','3',1380.00,0.00,'Retail Sale Id 1669 for 2.00 KG of Cooking Gas @ N690.00','2023-03-14 09:11:19','',''),('1','311',3238,'','6.1','4',0.00,1380.00,'Retail Sale Id 1669 for retail product','2023-03-14 09:11:19','',''),('1','311',3239,'','20','3',2760.00,0.00,'Retail Sale Id 1670 for 4.00 KG of Cooking Gas @ N690.00','2023-03-14 09:12:36','',''),('1','311',3240,'','6.1','4',0.00,2760.00,'Retail Sale Id 1670 for retail product','2023-03-14 09:12:36','',''),('1','311',3241,'','20','3',4830.00,0.00,'Retail Sale Id 1671 for 7.00 KG of Cooking Gas @ N690.00','2023-03-14 09:18:01','',''),('1','311',3242,'','6.1','4',0.00,4830.00,'Retail Sale Id 1671 for retail product','2023-03-14 09:18:01','',''),('1','311',3243,'','20','3',2000.00,0.00,'Retail Sale Id 1672 for 2.90 KG of Cooking Gas @ N690.00','2023-03-14 09:21:42','',''),('1','311',3244,'','6.1','4',0.00,2000.00,'Retail Sale Id 1672 for retail product','2023-03-14 09:21:42','',''),('1','311',3245,'','20','3',4150.00,0.00,'Retail Sale Id 1673 for 6.01 KG of Cooking Gas @ N690.00','2023-03-14 09:29:58','',''),('1','311',3246,'','6.1','4',0.00,4150.00,'Retail Sale Id 1673 for retail product','2023-03-14 09:29:59','',''),('1','311',3247,'','20','3',2000.00,0.00,'Retail Sale Id 1674 for 2.90 KG of Cooking Gas @ N690.00','2023-03-14 09:37:20','',''),('1','311',3248,'','6.1','4',0.00,2000.00,'Retail Sale Id 1674 for retail product','2023-03-14 09:37:20','',''),('1','311',3249,'','20','3',2200.00,0.00,'Retail Sale Id 1675 for 3.19 KG of Cooking Gas @ N690.00','2023-03-14 09:41:12','',''),('1','311',3250,'','6.1','4',0.00,2200.00,'Retail Sale Id 1675 for retail product','2023-03-14 09:41:12','',''),('1','311',3251,'','20','3',5520.00,0.00,'Retail Sale Id 1676 for 8.00 KG of Cooking Gas @ N690.00','2023-03-14 09:45:21','',''),('1','311',3252,'','6.1','4',0.00,5520.00,'Retail Sale Id 1676 for retail product','2023-03-14 09:45:21','',''),('1','311',3253,'','20','3',8280.00,0.00,'Retail Sale Id 1678 for multiple products','2023-03-14 09:52:58','',''),('1','311',3254,'','6.1','4',0.00,8280.00,'Retail Sale Id 1678 for retail product','2023-03-14 09:52:58','',''),('1','311',3255,'','20','3',8280.00,0.00,'Retail Sale Id 1679 for 12.00 KG of Cooking Gas @ N690.00','2023-03-14 09:54:28','',''),('1','311',3256,'','6.1','4',0.00,8280.00,'Retail Sale Id 1679 for retail product','2023-03-14 09:54:28','',''),('1','311',3257,'','20','3',4830.00,0.00,'Retail Sale Id 1680 for 7.00 KG of Cooking Gas @ N690.00','2023-03-14 09:55:44','',''),('1','311',3258,'','6.1','4',0.00,4830.00,'Retail Sale Id 1680 for retail product','2023-03-14 09:55:44','',''),('1','311',3259,'','20','3',4140.00,0.00,'Retail Sale Id 1681 for 6.00 KG of Cooking Gas @ N690.00','2023-03-14 10:02:53','',''),('1','311',3260,'','6.1','4',0.00,4140.00,'Retail Sale Id 1681 for retail product','2023-03-14 10:02:53','',''),('1','311',3261,'','20','3',5000.00,0.00,'Retail Sale Id 1682 for 7.25 KG of Cooking Gas @ N690.00','2023-03-14 10:04:51','',''),('1','311',3262,'','6.1','4',0.00,5000.00,'Retail Sale Id 1682 for retail product','2023-03-14 10:04:51','',''),('1','311',3263,'','20','3',2760.00,0.00,'Retail Sale Id 1683 for 4.00 KG of Cooking Gas @ N690.00','2023-03-14 10:08:06','',''),('1','311',3264,'','6.1','4',0.00,2760.00,'Retail Sale Id 1683 for retail product','2023-03-14 10:08:06','',''),('1','311',3265,'','20','3',3450.00,0.00,'Retail Sale Id 1684 for 5.00 KG of Cooking Gas @ N690.00','2023-03-14 10:16:07','',''),('1','311',3266,'','6.1','4',0.00,3450.00,'Retail Sale Id 1684 for retail product','2023-03-14 10:16:07','',''),('1','311',3267,'','20','3',4140.00,0.00,'Retail Sale Id 1685 for 6.00 KG of Cooking Gas @ N690.00','2023-03-14 10:17:40','',''),('1','311',3268,'','6.1','4',0.00,4140.00,'Retail Sale Id 1685 for retail product','2023-03-14 10:17:40','',''),('1','311',3269,'','20','3',474963.00,0.00,'Retail Sale Id 1686 for 708.90 KG of Cooking Gas @ N670.00','2023-03-14 10:19:50','',''),('1','311',3270,'','6.1','4',0.00,474963.00,'Retail Sale Id 1686 for retail product','2023-03-14 10:19:50','',''),('1','311',3271,'','20','3',2070.00,0.00,'Retail Sale Id 1687 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 10:20:51','',''),('1','311',3272,'','6.1','4',0.00,2070.00,'Retail Sale Id 1687 for retail product','2023-03-14 10:20:51','',''),('1','311',3273,'','20','3',2760.00,0.00,'Retail Sale Id 1688 for 4.00 KG of Cooking Gas @ N690.00','2023-03-14 10:21:50','',''),('1','311',3274,'','6.1','4',0.00,2760.00,'Retail Sale Id 1688 for retail product','2023-03-14 10:21:50','',''),('1','311',3275,'','20','3',2000.00,0.00,'Retail Sale Id 1689 for 2.90 KG of Cooking Gas @ N690.00','2023-03-14 10:23:06','',''),('1','311',3276,'','6.1','4',0.00,2000.00,'Retail Sale Id 1689 for retail product','2023-03-14 10:23:06','',''),('1','311',3277,'','20','3',700.00,0.00,'Retail Sale Id 1691 for 1.01 KG of Cooking Gas @ N690.00','2023-03-14 10:24:32','',''),('1','311',3278,'','6.1','4',0.00,700.00,'Retail Sale Id 1691 for retail product','2023-03-14 10:24:32','',''),('1','311',3279,'','20','3',2070.00,0.00,'Retail Sale Id 1692 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 10:35:55','',''),('1','311',3280,'','6.1','4',0.00,2070.00,'Retail Sale Id 1692 for retail product','2023-03-14 10:35:55','',''),('1','311',3281,'','20','3',1380.00,0.00,'Retail Sale Id 1693 for 2.00 KG of Cooking Gas @ N690.00','2023-03-14 10:51:31','',''),('1','311',3282,'','6.1','4',0.00,1380.00,'Retail Sale Id 1693 for retail product','2023-03-14 10:51:31','',''),('1','311',3283,'','20','3',4140.00,0.00,'Retail Sale Id 1695 for 6.00 KG of Cooking Gas @ N690.00','2023-03-14 11:07:48','',''),('1','311',3284,'','6.1','4',0.00,4140.00,'Retail Sale Id 1695 for retail product','2023-03-14 11:07:48','',''),('1','311',3285,'','20','3',2000.00,0.00,'Retail Sale Id 1696 for 2.90 KG of Cooking Gas @ N690.00','2023-03-14 11:11:36','',''),('1','311',3286,'','6.1','4',0.00,2000.00,'Retail Sale Id 1696 for retail product','2023-03-14 11:11:36','',''),('1','311',3287,'','20','3',8625.00,0.00,'Retail Sale Id 1697 for 12.50 KG of Cooking Gas @ N690.00','2023-03-14 11:13:13','',''),('1','311',3288,'','6.1','4',0.00,8625.00,'Retail Sale Id 1697 for retail product','2023-03-14 11:13:13','',''),('1','311',3289,'','20','3',8280.00,0.00,'Retail Sale Id 1698 for 12.00 KG of Cooking Gas @ N690.00','2023-03-14 11:18:54','',''),('1','311',3290,'','6.1','4',0.00,8280.00,'Retail Sale Id 1698 for retail product','2023-03-14 11:18:54','',''),('1','311',3291,'','20','3',1400.00,0.00,'Retail Sale Id 1699 for 2.03 KG of Cooking Gas @ N690.00','2023-03-14 11:29:12','',''),('1','311',3292,'','6.1','4',0.00,1400.00,'Retail Sale Id 1699 for retail product','2023-03-14 11:29:12','',''),('1','311',3293,'','20','3',2000.00,0.00,'Retail Sale Id 1700 for 2.90 KG of Cooking Gas @ N690.00','2023-03-14 11:29:59','',''),('1','311',3294,'','6.1','4',0.00,2000.00,'Retail Sale Id 1700 for retail product','2023-03-14 11:29:59','',''),('1','311',3295,'','20','3',6900.00,0.00,'Retail Sale Id 1701 for 10.00 KG of Cooking Gas @ N690.00','2023-03-14 11:32:20','',''),('1','311',3296,'','6.1','4',0.00,6900.00,'Retail Sale Id 1701 for retail product','2023-03-14 11:32:20','',''),('1','311',3297,'','20','3',1400.00,0.00,'Retail Sale Id 1702 for 2.03 KG of Cooking Gas @ N690.00','2023-03-14 11:33:07','',''),('1','311',3298,'','6.1','4',0.00,1400.00,'Retail Sale Id 1702 for retail product','2023-03-14 11:33:07','',''),('1','311',3299,'','20','3',55610.00,0.00,'Retail Sale Id 1703 for 83.00 KG of Cooking Gas @ N670.00','2023-03-14 11:34:41','',''),('1','311',3300,'','6.1','4',0.00,55610.00,'Retail Sale Id 1703 for retail product','2023-03-14 11:34:41','',''),('1','311',3301,'','20','3',8625.00,0.00,'Retail Sale Id 1704 for 12.50 KG of Cooking Gas @ N690.00','2023-03-14 11:40:29','',''),('1','311',3302,'','6.1','4',0.00,8625.00,'Retail Sale Id 1704 for retail product','2023-03-14 11:40:29','',''),('1','311',3303,'','20','3',8625.00,0.00,'Retail Sale Id 1705 for 12.50 KG of Cooking Gas @ N690.00','2023-03-14 11:42:41','',''),('1','311',3304,'','6.1','4',0.00,8625.00,'Retail Sale Id 1705 for retail product','2023-03-14 11:42:41','',''),('1','311',3305,'','20','3',8280.00,0.00,'Retail Sale Id 1706 for 12.00 KG of Cooking Gas @ N690.00','2023-03-14 11:44:01','',''),('1','311',3306,'','6.1','4',0.00,8280.00,'Retail Sale Id 1706 for retail product','2023-03-14 11:44:01','',''),('1','311',3307,'','20','3',1380.00,0.00,'Retail Sale Id 1707 for 2.00 KG of Cooking Gas @ N690.00','2023-03-14 11:48:14','',''),('1','311',3308,'','6.1','4',0.00,1380.00,'Retail Sale Id 1707 for retail product','2023-03-14 11:48:14','',''),('1','311',3309,'','20','3',4140.00,0.00,'Retail Sale Id 1708 for 6.00 KG of Cooking Gas @ N690.00','2023-03-14 11:55:14','',''),('1','311',3310,'','6.1','4',0.00,4140.00,'Retail Sale Id 1708 for retail product','2023-03-14 11:55:14','',''),('1','311',3311,'','20','3',2800.00,0.00,'Retail Sale Id 1709 for 4.06 KG of Cooking Gas @ N690.00','2023-03-14 11:57:54','',''),('1','311',3312,'','6.1','4',0.00,2800.00,'Retail Sale Id 1709 for retail product','2023-03-14 11:57:54','',''),('1','311',3313,'','20','3',3450.00,0.00,'Retail Sale Id 1710 for 5.00 KG of Cooking Gas @ N690.00','2023-03-14 11:58:37','',''),('1','311',3314,'','6.1','4',0.00,3450.00,'Retail Sale Id 1710 for retail product','2023-03-14 11:58:37','',''),('1','311',3315,'','20','3',2070.00,0.00,'Retail Sale Id 1711 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 12:08:26','',''),('1','311',3316,'','6.1','4',0.00,2070.00,'Retail Sale Id 1711 for retail product','2023-03-14 12:08:26','',''),('1','311',3317,'','20','3',2760.00,0.00,'Retail Sale Id 1712 for 4.00 KG of Cooking Gas @ N690.00','2023-03-14 12:09:46','',''),('1','311',3318,'','6.1','4',0.00,2760.00,'Retail Sale Id 1712 for retail product','2023-03-14 12:09:46','',''),('1','311',3319,'','20','3',2070.00,0.00,'Retail Sale Id 1713 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 12:25:39','',''),('1','311',3320,'','6.1','4',0.00,2070.00,'Retail Sale Id 1713 for retail product','2023-03-14 12:25:39','',''),('1','311',3321,'','20','3',17250.00,0.00,'Retail Sale Id 1714 for multiple products','2023-03-14 12:28:49','',''),('1','311',3322,'','6.1','4',0.00,17250.00,'Retail Sale Id 1714 for retail product','2023-03-14 12:28:49','',''),('1','311',3323,'','20','3',134000.00,0.00,'Retail Sale Id 1715 for 200.00 KG of Cooking Gas @ N670.00','2023-03-14 12:38:49','',''),('1','311',3324,'','6.1','4',0.00,134000.00,'Retail Sale Id 1715 for retail product','2023-03-14 12:38:49','',''),('1','311',3325,'','20','3',3450.00,0.00,'Retail Sale Id 1716 for 5.00 KG of Cooking Gas @ N690.00','2023-03-14 12:40:36','',''),('1','311',3326,'','6.1','4',0.00,3450.00,'Retail Sale Id 1716 for retail product','2023-03-14 12:40:36','',''),('1','311',3327,'','20','3',2070.00,0.00,'Retail Sale Id 1718 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 12:51:25','',''),('1','311',3328,'','6.1','4',0.00,2070.00,'Retail Sale Id 1718 for retail product','2023-03-14 12:51:25','',''),('1','311',3329,'','20','3',2760.00,0.00,'Retail Sale Id 1719 for 4.00 KG of Cooking Gas @ N690.00','2023-03-14 12:59:07','',''),('1','311',3330,'','6.1','4',0.00,2760.00,'Retail Sale Id 1719 for retail product','2023-03-14 12:59:07','',''),('1','311',3331,'','20','3',1000.00,0.00,'Retail Sale Id 1720 for 1.45 KG of Cooking Gas @ N690.00','2023-03-14 12:59:50','',''),('1','311',3332,'','6.1','4',0.00,1000.00,'Retail Sale Id 1720 for retail product','2023-03-14 12:59:50','',''),('1','311',3333,'','20','3',2070.00,0.00,'Retail Sale Id 1722 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 13:14:24','',''),('1','311',3334,'','6.1','4',0.00,2070.00,'Retail Sale Id 1722 for retail product','2023-03-14 13:14:24','',''),('1','311',3335,'','20','3',8625.00,0.00,'Retail Sale Id 1723 for 12.50 KG of Cooking Gas @ N690.00','2023-03-14 13:18:23','',''),('1','311',3336,'','6.1','4',0.00,8625.00,'Retail Sale Id 1723 for retail product','2023-03-14 13:18:23','',''),('1','311',3337,'','20','3',8625.00,0.00,'Retail Sale Id 1724 for 12.50 KG of Cooking Gas @ N690.00','2023-03-14 13:20:55','',''),('1','311',3338,'','6.1','4',0.00,8625.00,'Retail Sale Id 1724 for retail product','2023-03-14 13:20:55','',''),('1','311',3339,'','20','3',2070.00,0.00,'Retail Sale Id 1725 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 13:22:27','',''),('1','311',3340,'','6.1','4',0.00,2070.00,'Retail Sale Id 1725 for retail product','2023-03-14 13:22:27','',''),('1','311',3341,'','2','15',32700.00,0.00,'Payment Id 25 for invoice:13, receipt: 0019 by AA RANO NIGERIA LTD','2023-03-14 13:28:57','',''),('1','311',3342,'','supplier','1',0.00,32700.00,'Payment Id 25 for invoice:13, receipt: 0019 by AA RANO NIGERIA LTD','2023-03-14 13:28:57','',''),('1','311',3343,'','20','3',4140.00,0.00,'Retail Sale Id 1726 for 6.00 KG of Cooking Gas @ N690.00','2023-03-14 13:39:02','',''),('1','311',3344,'','6.1','4',0.00,4140.00,'Retail Sale Id 1726 for retail product','2023-03-14 13:39:02','',''),('1','311',3345,'','20','3',5520.00,0.00,'Retail Sale Id 1727 for 8.00 KG of Cooking Gas @ N690.00','2023-03-14 13:43:12','',''),('1','311',3346,'','6.1','4',0.00,5520.00,'Retail Sale Id 1727 for retail product','2023-03-14 13:43:12','',''),('1','311',3347,'','20','3',1380.00,0.00,'Retail Sale Id 1728 for 2.00 KG of Cooking Gas @ N690.00','2023-03-14 13:54:38','',''),('1','311',3348,'','6.1','4',0.00,1380.00,'Retail Sale Id 1728 for retail product','2023-03-14 13:54:38','',''),('1','311',3349,'','20','3',2070.00,0.00,'Retail Sale Id 1729 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 13:58:03','',''),('1','311',3350,'','6.1','4',0.00,2070.00,'Retail Sale Id 1729 for retail product','2023-03-14 13:58:03','',''),('1','311',3351,'','20','3',12420.00,0.00,'Retail Sale Id 1730 for multiple products','2023-03-14 14:14:02','',''),('1','311',3352,'','6.1','4',0.00,12420.00,'Retail Sale Id 1730 for retail product','2023-03-14 14:14:02','',''),('1','311',3353,'','20','3',1000.00,0.00,'Retail Sale Id 1731 for 1.45 KG of Cooking Gas @ N690.00','2023-03-14 14:17:20','',''),('1','311',3354,'','6.1','4',0.00,1000.00,'Retail Sale Id 1731 for retail product','2023-03-14 14:17:20','',''),('1','311',3355,'','20','3',4140.00,0.00,'Retail Sale Id 1732 for 6.00 KG of Cooking Gas @ N690.00','2023-03-14 14:18:21','',''),('1','311',3356,'','6.1','4',0.00,4140.00,'Retail Sale Id 1732 for retail product','2023-03-14 14:18:21','',''),('1','311',3357,'','20','3',4140.00,0.00,'Retail Sale Id 1733 for 6.00 KG of Cooking Gas @ N690.00','2023-03-14 14:21:55','',''),('1','311',3358,'','6.1','4',0.00,4140.00,'Retail Sale Id 1733 for retail product','2023-03-14 14:21:55','',''),('1','311',3359,'','20','3',8625.00,0.00,'Retail Sale Id 1734 for 12.50 KG of Cooking Gas @ N690.00','2023-03-14 14:22:57','',''),('1','311',3360,'','6.1','4',0.00,8625.00,'Retail Sale Id 1734 for retail product','2023-03-14 14:22:57','',''),('1','311',3361,'','20','3',7590.00,0.00,'Retail Sale Id 1735 for 11.00 KG of Cooking Gas @ N690.00','2023-03-14 14:23:46','',''),('1','311',3362,'','6.1','4',0.00,7590.00,'Retail Sale Id 1735 for retail product','2023-03-14 14:23:46','',''),('1','311',3363,'','20','3',4140.00,0.00,'Retail Sale Id 1736 for 6.00 KG of Cooking Gas @ N690.00','2023-03-14 14:25:49','',''),('1','311',3364,'','6.1','4',0.00,4140.00,'Retail Sale Id 1736 for retail product','2023-03-14 14:25:49','',''),('1','311',3365,'','20','3',1380.00,0.00,'Retail Sale Id 1737 for 2.00 KG of Cooking Gas @ N690.00','2023-03-14 14:27:33','',''),('1','311',3366,'','6.1','4',0.00,1380.00,'Retail Sale Id 1737 for retail product','2023-03-14 14:27:33','',''),('1','311',3367,'','20','3',10350.00,0.00,'Retail Sale Id 1738 for 15.00 KG of Cooking Gas @ N690.00','2023-03-14 14:28:33','',''),('1','311',3368,'','6.1','4',0.00,10350.00,'Retail Sale Id 1738 for retail product','2023-03-14 14:28:33','',''),('1','311',3369,'','20','3',3000.00,0.00,'Retail Sale Id 1739 for 4.35 KG of Cooking Gas @ N690.00','2023-03-14 14:31:31','',''),('1','311',3370,'','6.1','4',0.00,3000.00,'Retail Sale Id 1739 for retail product','2023-03-14 14:31:31','',''),('1','311',3371,'','20','3',4830.00,0.00,'Retail Sale Id 1740 for 7.00 KG of Cooking Gas @ N690.00','2023-03-14 14:37:21','',''),('1','311',3372,'','6.1','4',0.00,4830.00,'Retail Sale Id 1740 for retail product','2023-03-14 14:37:21','',''),('1','311',3373,'','20','3',4140.00,0.00,'Retail Sale Id 1741 for 6.00 KG of Cooking Gas @ N690.00','2023-03-14 14:40:54','',''),('1','311',3374,'','6.1','4',0.00,4140.00,'Retail Sale Id 1741 for retail product','2023-03-14 14:40:54','',''),('1','311',3375,'','20','3',5520.00,0.00,'Retail Sale Id 1742 for 8.00 KG of Cooking Gas @ N690.00','2023-03-14 14:44:52','',''),('1','311',3376,'','6.1','4',0.00,5520.00,'Retail Sale Id 1742 for retail product','2023-03-14 14:44:52','',''),('1','311',3377,'','20','3',3450.00,0.00,'Retail Sale Id 1743 for 5.00 KG of Cooking Gas @ N690.00','2023-03-14 14:49:27','',''),('1','311',3378,'','6.1','4',0.00,3450.00,'Retail Sale Id 1743 for retail product','2023-03-14 14:49:27','',''),('1','311',3379,'','20','3',3000.00,0.00,'Retail Sale Id 1744 for 4.35 KG of Cooking Gas @ N690.00','2023-03-14 15:00:02','',''),('1','311',3380,'','6.1','4',0.00,3000.00,'Retail Sale Id 1744 for retail product','2023-03-14 15:00:02','',''),('1','311',3381,'','20','3',2070.00,0.00,'Retail Sale Id 1745 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 15:02:09','',''),('1','311',3382,'','6.1','4',0.00,2070.00,'Retail Sale Id 1745 for retail product','2023-03-14 15:02:09','',''),('1','311',3383,'','20','3',24495.00,0.00,'Retail Sale Id 1746 for multiple products','2023-03-14 15:20:07','',''),('1','311',3384,'','6.1','4',0.00,24495.00,'Retail Sale Id 1746 for retail product','2023-03-14 15:20:07','',''),('1','311',3385,'','20','3',3450.00,0.00,'Retail Sale Id 1748 for 5.00 KG of Cooking Gas @ N690.00','2023-03-14 15:31:15','',''),('1','311',3386,'','6.1','4',0.00,3450.00,'Retail Sale Id 1748 for retail product','2023-03-14 15:31:15','',''),('1','311',3387,'','20','3',5520.00,0.00,'Retail Sale Id 1749 for 8.00 KG of Cooking Gas @ N690.00','2023-03-14 15:31:49','',''),('1','311',3388,'','6.1','4',0.00,5520.00,'Retail Sale Id 1749 for retail product','2023-03-14 15:31:49','',''),('1','311',3389,'','20','3',5520.00,0.00,'Retail Sale Id 1751 for 8.00 KG of Cooking Gas @ N690.00','2023-03-14 15:35:08','',''),('1','311',3390,'','6.1','4',0.00,5520.00,'Retail Sale Id 1751 for retail product','2023-03-14 15:35:08','',''),('1','311',3391,'','20','3',4140.00,0.00,'Retail Sale Id 1753 for 6.00 KG of Cooking Gas @ N690.00','2023-03-14 15:38:07','',''),('1','311',3392,'','6.1','4',0.00,4140.00,'Retail Sale Id 1753 for retail product','2023-03-14 15:38:07','',''),('1','311',3393,'','20','3',2760.00,0.00,'Retail Sale Id 1755 for 4.00 KG of Cooking Gas @ N690.00','2023-03-14 15:44:16','',''),('1','311',3394,'','6.1','4',0.00,2760.00,'Retail Sale Id 1755 for retail product','2023-03-14 15:44:16','',''),('1','311',3395,'','20','3',8625.00,0.00,'Retail Sale Id 1756 for 12.50 KG of Cooking Gas @ N690.00','2023-03-14 15:45:11','',''),('1','311',3396,'','6.1','4',0.00,8625.00,'Retail Sale Id 1756 for retail product','2023-03-14 15:45:11','',''),('1','311',3397,'','20','3',4830.00,0.00,'Retail Sale Id 1757 for 7.00 KG of Cooking Gas @ N690.00','2023-03-14 15:48:12','',''),('1','311',3398,'','6.1','4',0.00,4830.00,'Retail Sale Id 1757 for retail product','2023-03-14 15:48:12','',''),('1','311',3399,'','20','3',2070.00,0.00,'Retail Sale Id 1758 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 15:49:16','',''),('1','311',3400,'','6.1','4',0.00,2070.00,'Retail Sale Id 1758 for retail product','2023-03-14 15:49:16','',''),('1','311',3401,'','20','3',4850.00,0.00,'Retail Sale Id 1760 for 7.03 KG of Cooking Gas @ N690.00','2023-03-14 15:50:47','',''),('1','311',3402,'','6.1','4',0.00,4850.00,'Retail Sale Id 1760 for retail product','2023-03-14 15:50:47','',''),('1','311',3403,'','20','3',2070.00,0.00,'Retail Sale Id 1761 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 15:52:10','',''),('1','311',3404,'','6.1','4',0.00,2070.00,'Retail Sale Id 1761 for retail product','2023-03-14 15:52:10','',''),('1','311',3405,'','20','3',2760.00,0.00,'Retail Sale Id 1766 for 4.00 KG of Cooking Gas @ N690.00','2023-03-14 15:54:19','',''),('1','311',3406,'','6.1','4',0.00,2760.00,'Retail Sale Id 1766 for retail product','2023-03-14 15:54:19','',''),('1','311',3407,'','20','3',0.00,4830.00,'Return of Retail Sale Id 1757 for products','2023-03-14 15:57:03','',''),('1','311',3408,'','','',4830.00,0.00,'Return of Retail Sale Id 1757 for products','2023-03-14 15:57:03','',''),('1','311',3409,'','20','3',4512.60,0.00,'Retail Sale Id 1767 for 6.54 KG of Cooking Gas @ N690.00','2023-03-14 15:59:06','',''),('1','311',3410,'','6.1','4',0.00,4512.60,'Retail Sale Id 1767 for retail product','2023-03-14 15:59:06','',''),('1','311',3411,'','20','3',3450.00,0.00,'Retail Sale Id 1768 for 5.00 KG of Cooking Gas @ N690.00','2023-03-14 16:00:34','',''),('1','311',3412,'','6.1','4',0.00,3450.00,'Retail Sale Id 1768 for retail product','2023-03-14 16:00:34','',''),('1','311',3413,'','20','3',2070.00,0.00,'Retail Sale Id 1769 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 16:01:33','',''),('1','311',3414,'','6.1','4',0.00,2070.00,'Retail Sale Id 1769 for retail product','2023-03-14 16:01:33','',''),('1','311',3415,'','20','3',2070.00,0.00,'Retail Sale Id 1770 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 16:04:25','',''),('1','311',3416,'','6.1','4',0.00,2070.00,'Retail Sale Id 1770 for retail product','2023-03-14 16:04:25','',''),('1','311',3417,'','20','3',8625.00,0.00,'Retail Sale Id 1771 for 12.50 KG of Cooking Gas @ N690.00','2023-03-14 16:05:08','',''),('1','311',3418,'','6.1','4',0.00,8625.00,'Retail Sale Id 1771 for retail product','2023-03-14 16:05:08','',''),('1','311',3419,'','20','3',3450.00,0.00,'Retail Sale Id 1772 for 5.00 KG of Cooking Gas @ N690.00','2023-03-14 16:05:54','',''),('1','311',3420,'','6.1','4',0.00,3450.00,'Retail Sale Id 1772 for retail product','2023-03-14 16:05:54','',''),('1','311',3421,'','20','3',1400.00,0.00,'Retail Sale Id 1775 for 2.03 KG of Cooking Gas @ N690.00','2023-03-14 16:08:36','',''),('1','311',3422,'','6.1','4',0.00,1400.00,'Retail Sale Id 1775 for retail product','2023-03-14 16:08:36','',''),('1','311',3423,'','20','3',1500.00,0.00,'Retail Sale Id 1776 for 2.17 KG of Cooking Gas @ N690.00','2023-03-14 16:11:04','',''),('1','311',3424,'','6.1','4',0.00,1500.00,'Retail Sale Id 1776 for retail product','2023-03-14 16:11:04','',''),('1','311',3425,'','20','3',4140.00,0.00,'Retail Sale Id 1777 for 6.00 KG of Cooking Gas @ N690.00','2023-03-14 16:11:53','',''),('1','311',3426,'','6.1','4',0.00,4140.00,'Retail Sale Id 1777 for retail product','2023-03-14 16:11:53','',''),('1','311',3427,'','20','3',6900.00,0.00,'Retail Sale Id 1779 for 10.00 KG of Cooking Gas @ N690.00','2023-03-14 16:15:40','',''),('1','311',3428,'','6.1','4',0.00,6900.00,'Retail Sale Id 1779 for retail product','2023-03-14 16:15:40','',''),('1','311',3429,'','20','3',2000.00,0.00,'Retail Sale Id 1780 for 2.90 KG of Cooking Gas @ N690.00','2023-03-14 16:16:31','',''),('1','311',3430,'','6.1','4',0.00,2000.00,'Retail Sale Id 1780 for retail product','2023-03-14 16:16:31','',''),('1','311',3431,'','20','3',4830.00,0.00,'Retail Sale Id 1781 for 7.00 KG of Cooking Gas @ N690.00','2023-03-14 16:17:22','',''),('1','311',3432,'','6.1','4',0.00,4830.00,'Retail Sale Id 1781 for retail product','2023-03-14 16:17:22','',''),('1','311',3433,'','20','3',8000.00,0.00,'Retail Sale Id 1782 for multiple products','2023-03-14 16:18:48','',''),('1','311',3434,'','6.1','4',0.00,8000.00,'Retail Sale Id 1782 for retail product','2023-03-14 16:18:48','',''),('1','311',3435,'','20','3',4830.00,0.00,'Retail Sale Id 1783 for 7.00 KG of Cooking Gas @ N690.00','2023-03-14 16:19:46','',''),('1','311',3436,'','6.1','4',0.00,4830.00,'Retail Sale Id 1783 for retail product','2023-03-14 16:19:46','',''),('1','311',3437,'','20','3',1725.00,0.00,'Retail Sale Id 1773 for 2.50 KG of Cooking Gas @ N690.00','2023-03-14 16:21:24','',''),('1','311',3438,'','6.1','4',0.00,1725.00,'Retail Sale Id 1773 for retail product','2023-03-14 16:21:24','',''),('1','311',3439,'','20','3',3000.00,0.00,'Retail Sale Id 1784 for 4.35 KG of Cooking Gas @ N690.00','2023-03-14 16:22:26','',''),('1','311',3440,'','6.1','4',0.00,3000.00,'Retail Sale Id 1784 for retail product','2023-03-14 16:22:26','',''),('1','311',3441,'','20','3',8625.00,0.00,'Retail Sale Id 1785 for 12.50 KG of Cooking Gas @ N690.00','2023-03-14 16:23:31','',''),('1','311',3442,'','6.1','4',0.00,8625.00,'Retail Sale Id 1785 for retail product','2023-03-14 16:23:31','',''),('1','311',3443,'','20','3',11040.00,0.00,'Retail Sale Id 1786 for multiple products','2023-03-14 16:25:25','',''),('1','311',3444,'','6.1','4',0.00,11040.00,'Retail Sale Id 1786 for retail product','2023-03-14 16:25:25','',''),('1','311',3445,'','20','3',4830.00,0.00,'Retail Sale Id 1787 for 7.00 KG of Cooking Gas @ N690.00','2023-03-14 16:26:35','',''),('1','311',3446,'','6.1','4',0.00,4830.00,'Retail Sale Id 1787 for retail product','2023-03-14 16:26:35','',''),('1','311',3447,'','20','3',9660.00,0.00,'Retail Sale Id 1788 for multiple products','2023-03-14 16:37:38','',''),('1','311',3448,'','6.1','4',0.00,9660.00,'Retail Sale Id 1788 for retail product','2023-03-14 16:37:38','',''),('1','311',3449,'','20','3',1400.00,0.00,'Retail Sale Id 1791 for 2.03 KG of Cooking Gas @ N690.00','2023-03-14 16:39:32','',''),('1','311',3450,'','6.1','4',0.00,1400.00,'Retail Sale Id 1791 for retail product','2023-03-14 16:39:32','',''),('1','311',3451,'','20','3',2070.00,0.00,'Retail Sale Id 1792 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 16:41:17','',''),('1','311',3452,'','6.1','4',0.00,2070.00,'Retail Sale Id 1792 for retail product','2023-03-14 16:41:17','',''),('1','311',3453,'','20','3',2070.00,0.00,'Retail Sale Id 1793 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 16:44:28','',''),('1','311',3454,'','6.1','4',0.00,2070.00,'Retail Sale Id 1793 for retail product','2023-03-14 16:44:28','',''),('1','311',3455,'','20','3',3450.00,0.00,'Retail Sale Id 1794 for 5.00 KG of Cooking Gas @ N690.00','2023-03-14 16:45:19','',''),('1','311',3456,'','6.1','4',0.00,3450.00,'Retail Sale Id 1794 for retail product','2023-03-14 16:45:19','',''),('1','311',3457,'','20','3',2070.00,0.00,'Retail Sale Id 1789 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 16:46:06','',''),('1','311',3458,'','6.1','4',0.00,2070.00,'Retail Sale Id 1789 for retail product','2023-03-14 16:46:06','',''),('1','311',3459,'','20','3',1380.00,0.00,'Retail Sale Id 1795 for 2.00 KG of Cooking Gas @ N690.00','2023-03-14 16:47:01','',''),('1','311',3460,'','6.1','4',0.00,1380.00,'Retail Sale Id 1795 for retail product','2023-03-14 16:47:01','',''),('1','311',3461,'','20','3',3450.00,0.00,'Retail Sale Id 1797 for multiple products','2023-03-14 16:50:48','',''),('1','311',3462,'','6.1','4',0.00,3450.00,'Retail Sale Id 1797 for retail product','2023-03-14 16:50:48','',''),('1','311',3463,'','20','3',2760.00,0.00,'Retail Sale Id 1798 for 4.00 KG of Cooking Gas @ N690.00','2023-03-14 16:54:04','',''),('1','311',3464,'','6.1','4',0.00,2760.00,'Retail Sale Id 1798 for retail product','2023-03-14 16:54:04','',''),('1','311',3465,'','20','3',2070.00,0.00,'Retail Sale Id 1800 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 16:57:17','',''),('1','311',3466,'','6.1','4',0.00,2070.00,'Retail Sale Id 1800 for retail product','2023-03-14 16:57:17','',''),('1','311',3467,'','20','3',1400.00,0.00,'Retail Sale Id 1801 for 2.03 KG of Cooking Gas @ N690.00','2023-03-14 17:02:08','',''),('1','311',3468,'','6.1','4',0.00,1400.00,'Retail Sale Id 1801 for retail product','2023-03-14 17:02:08','',''),('1','311',3469,'','20','3',3000.00,0.00,'Retail Sale Id 1802 for multiple products','2023-03-14 17:04:04','',''),('1','311',3470,'','6.1','4',0.00,3000.00,'Retail Sale Id 1802 for retail product','2023-03-14 17:04:04','',''),('1','311',3471,'','20','3',2800.00,0.00,'Retail Sale Id 1803 for 4.06 KG of Cooking Gas @ N690.00','2023-03-14 17:06:33','',''),('1','311',3472,'','6.1','4',0.00,2800.00,'Retail Sale Id 1803 for retail product','2023-03-14 17:06:33','',''),('1','311',3473,'','20','3',0.00,3000.00,'Return of Retail Sale Id 1802 for products','2023-03-14 17:08:55','',''),('1','311',3474,'','','',3000.00,0.00,'Return of Retail Sale Id 1802 for products','2023-03-14 17:08:55','',''),('1','311',3475,'','20','3',4000.00,0.00,'Retail Sale Id 1804 for multiple products','2023-03-14 17:10:13','',''),('1','311',3476,'','6.1','4',0.00,4000.00,'Retail Sale Id 1804 for retail product','2023-03-14 17:10:13','',''),('1','311',3477,'','20','3',1380.00,0.00,'Retail Sale Id 1805 for 2.00 KG of Cooking Gas @ N690.00','2023-03-14 17:12:36','',''),('1','311',3478,'','6.1','4',0.00,1380.00,'Retail Sale Id 1805 for retail product','2023-03-14 17:12:36','',''),('1','311',3479,'','20','3',2070.00,0.00,'Retail Sale Id 1806 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 17:13:48','',''),('1','311',3480,'','6.1','4',0.00,2070.00,'Retail Sale Id 1806 for retail product','2023-03-14 17:13:49','',''),('1','311',3481,'','20','3',3450.00,0.00,'Retail Sale Id 1807 for 5.00 KG of Cooking Gas @ N690.00','2023-03-14 17:15:21','',''),('1','311',3482,'','6.1','4',0.00,3450.00,'Retail Sale Id 1807 for retail product','2023-03-14 17:15:21','',''),('1','311',3483,'','20','3',1380.00,0.00,'Retail Sale Id 1808 for 2.00 KG of Cooking Gas @ N690.00','2023-03-14 17:16:14','',''),('1','311',3484,'','6.1','4',0.00,1380.00,'Retail Sale Id 1808 for retail product','2023-03-14 17:16:14','',''),('1','311',3485,'','20','3',1000.00,0.00,'Retail Sale Id 1809 for 1.45 KG of Cooking Gas @ N690.00','2023-03-14 17:17:12','',''),('1','311',3486,'','6.1','4',0.00,1000.00,'Retail Sale Id 1809 for retail product','2023-03-14 17:17:12','',''),('1','311',3487,'','20','3',3450.00,0.00,'Retail Sale Id 1810 for 5.00 KG of Cooking Gas @ N690.00','2023-03-14 17:19:45','',''),('1','311',3488,'','6.1','4',0.00,3450.00,'Retail Sale Id 1810 for retail product','2023-03-14 17:19:45','',''),('1','311',3489,'','20','3',1380.00,0.00,'Retail Sale Id 1811 for 2.00 KG of Cooking Gas @ N690.00','2023-03-14 17:21:28','',''),('1','311',3490,'','6.1','4',0.00,1380.00,'Retail Sale Id 1811 for retail product','2023-03-14 17:21:28','',''),('1','311',3491,'','20','3',1380.00,0.00,'Retail Sale Id 1812 for 2.00 KG of Cooking Gas @ N690.00','2023-03-14 17:22:59','',''),('1','311',3492,'','6.1','4',0.00,1380.00,'Retail Sale Id 1812 for retail product','2023-03-14 17:22:59','',''),('1','311',3493,'','20','3',6900.00,0.00,'Retail Sale Id 1814 for 10.00 KG of Cooking Gas @ N690.00','2023-03-14 17:25:35','',''),('1','311',3494,'','6.1','4',0.00,6900.00,'Retail Sale Id 1814 for retail product','2023-03-14 17:25:35','',''),('1','311',3495,'','20','3',3000.00,0.00,'Retail Sale Id 1815 for 4.35 KG of Cooking Gas @ N690.00','2023-03-14 17:26:33','',''),('1','311',3496,'','6.1','4',0.00,3000.00,'Retail Sale Id 1815 for retail product','2023-03-14 17:26:33','',''),('1','311',3497,'','20','3',1000.00,0.00,'Retail Sale Id 1816 for 1.45 KG of Cooking Gas @ N690.00','2023-03-14 17:27:30','',''),('1','311',3498,'','6.1','4',0.00,1000.00,'Retail Sale Id 1816 for retail product','2023-03-14 17:27:30','',''),('1','311',3499,'','20','3',2070.00,0.00,'Retail Sale Id 1817 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 17:28:23','',''),('1','311',3500,'','6.1','4',0.00,2070.00,'Retail Sale Id 1817 for retail product','2023-03-14 17:28:23','',''),('1','311',3501,'','20','3',3450.00,0.00,'Retail Sale Id 1818 for 5.00 KG of Cooking Gas @ N690.00','2023-03-14 17:30:32','',''),('1','311',3502,'','6.1','4',0.00,3450.00,'Retail Sale Id 1818 for retail product','2023-03-14 17:30:32','',''),('1','311',3503,'','20','3',3450.00,0.00,'Retail Sale Id 1819 for 5.00 KG of Cooking Gas @ N690.00','2023-03-14 17:34:03','',''),('1','311',3504,'','6.1','4',0.00,3450.00,'Retail Sale Id 1819 for retail product','2023-03-14 17:34:03','',''),('1','311',3505,'','20','3',2070.00,0.00,'Retail Sale Id 1820 for 3.00 KG of Cooking Gas @ N690.00','2023-03-14 17:35:14','',''),('1','311',3506,'','6.1','4',0.00,2070.00,'Retail Sale Id 1820 for retail product','2023-03-14 17:35:14','',''),('1','311',3507,'','20','3',4830.00,0.00,'Retail Sale Id 1821 for 7.00 KG of Cooking Gas @ N690.00','2023-03-14 17:38:34','',''),('1','311',3508,'','6.1','4',0.00,4830.00,'Retail Sale Id 1821 for retail product','2023-03-14 17:38:34','',''),('1','311',3509,'','20','3',3450.00,0.00,'Retail Sale Id 1822 for 5.00 KG of Cooking Gas @ N690.00','2023-03-14 17:39:34','',''),('1','311',3510,'','6.1','4',0.00,3450.00,'Retail Sale Id 1822 for retail product','2023-03-14 17:39:34','',''),('1','311',3511,'','20','3',8280.00,0.00,'Retail Sale Id 1823 for 12.00 KG of Cooking Gas @ N690.00','2023-03-14 17:41:11','',''),('1','311',3512,'','6.1','4',0.00,8280.00,'Retail Sale Id 1823 for retail product','2023-03-14 17:41:11','',''),('1','311',3513,'','20','3',2415.00,0.00,'Retail Sale Id 1824 for 3.50 KG of Cooking Gas @ N690.00','2023-03-14 17:52:40','',''),('1','311',3514,'','6.1','4',0.00,2415.00,'Retail Sale Id 1824 for retail product','2023-03-14 17:52:40','',''),('1','311',3515,'','20','3',0.00,474963.00,'Return of Retail Sale Id 1686 for products','2023-03-14 18:19:36','',''),('1','311',3516,'','','',474963.00,0.00,'Return of Retail Sale Id 1686 for products','2023-03-14 18:19:36','',''),('1','311',3517,'','20','3',373726.00,0.00,'Retail Sale Id 1825 for 557.80 KG of Cooking Gas @ N670.00','2023-03-14 18:23:51','',''),('1','311',3518,'','6.1','4',0.00,373726.00,'Retail Sale Id 1825 for retail product','2023-03-14 18:23:51','',''),('1','311',3519,'','20','3',284689.70,0.00,'Retail Sale Id 1826 for 424.91 KG of Cooking Gas @ N670.00','2023-03-14 18:27:29','',''),('1','311',3520,'','6.1','4',0.00,284689.70,'Retail Sale Id 1826 for retail product','2023-03-14 18:27:29','',''),('1','311',3521,'','20','3',0.00,9660.00,'Return of Retail Sale Id 1788 for products','2023-03-14 18:32:54','',''),('1','311',3522,'','','',9660.00,0.00,'Return of Retail Sale Id 1788 for products','2023-03-14 18:32:54','',''),('1','311',3523,'','20','3',0.00,8280.00,'Return of Retail Sale Id 1823 for products','2023-03-14 18:34:22','',''),('1','311',3524,'','','',8280.00,0.00,'Return of Retail Sale Id 1823 for products','2023-03-14 18:34:22','',''),('1','311',3525,'','20','3',0.00,6900.00,'Return of Retail Sale Id 1814 for products','2023-03-14 18:35:48','',''),('1','311',3526,'','','',6900.00,0.00,'Return of Retail Sale Id 1814 for products','2023-03-14 18:35:48','',''),('1','311',3527,'','20','3',0.00,4830.00,'Return of Retail Sale Id 1821 for products','2023-03-14 18:37:45','',''),('1','311',3528,'','','',4830.00,0.00,'Return of Retail Sale Id 1821 for products','2023-03-14 18:37:45','',''),('1','311',3529,'','20','3',2967.00,0.00,'Retail Sale Id 1827 for 4.30 KG of Cooking Gas @ N690.00','2023-03-14 18:38:29','',''),('1','311',3530,'','6.1','4',0.00,2967.00,'Retail Sale Id 1827 for retail product','2023-03-14 18:38:29','',''),('1','311',3531,'','20','3',0.00,0.00,'Sales from shift 28 on 2023-03-14 18:47:57 ','2023-03-14 18:47:57','',''),('1','311',3532,'','6.1','4',0.00,0.00,'Sales from shift 28 on 2023-03-14 18:47:57 ','2023-03-14 18:47:57','',''),('1','311',3533,'','20','3',1000.00,0.00,'Retail Sale Id 1829 for 1.45 KG of Cooking Gas @ N690.00','2023-03-15 08:01:57','',''),('1','311',3534,'','6.1','4',0.00,1000.00,'Retail Sale Id 1829 for retail product','2023-03-15 08:01:57','',''),('1','311',3535,'','20','3',4140.00,0.00,'Retail Sale Id 1828 for 6.00 KG of Cooking Gas @ N690.00','2023-03-15 08:03:32','',''),('1','311',3536,'','6.1','4',0.00,4140.00,'Retail Sale Id 1828 for retail product','2023-03-15 08:03:32','',''),('1','311',3537,'','20','3',8970.00,0.00,'Retail Sale Id 1830 for multiple products','2023-03-15 08:12:47','',''),('1','311',3538,'','6.1','4',0.00,8970.00,'Retail Sale Id 1830 for retail product','2023-03-15 08:12:47','',''),('1','311',3539,'','20','3',2070.00,0.00,'Retail Sale Id 1831 for 3.00 KG of Cooking Gas @ N690.00','2023-03-15 08:14:20','',''),('1','311',3540,'','6.1','4',0.00,2070.00,'Retail Sale Id 1831 for retail product','2023-03-15 08:14:20','',''),('1','311',3541,'','20','3',5000.00,0.00,'Retail Sale Id 1832 for 7.25 KG of Cooking Gas @ N690.00','2023-03-15 08:15:40','',''),('1','311',3542,'','6.1','4',0.00,5000.00,'Retail Sale Id 1832 for retail product','2023-03-15 08:15:40','',''),('1','311',3543,'','20','3',7000.00,0.00,'Retail Sale Id 1833 for 10.14 KG of Cooking Gas @ N690.00','2023-03-15 08:16:55','',''),('1','311',3544,'','6.1','4',0.00,7000.00,'Retail Sale Id 1833 for retail product','2023-03-15 08:16:55','',''),('1','311',3545,'','20','3',8625.00,0.00,'Retail Sale Id 1834 for 12.50 KG of Cooking Gas @ N690.00','2023-03-15 08:19:21','',''),('1','311',3546,'','6.1','4',0.00,8625.00,'Retail Sale Id 1834 for retail product','2023-03-15 08:19:21','',''),('1','311',3547,'','20','3',6900.00,0.00,'Retail Sale Id 1835 for 10.00 KG of Cooking Gas @ N690.00','2023-03-15 08:20:31','',''),('1','311',3548,'','6.1','4',0.00,6900.00,'Retail Sale Id 1835 for retail product','2023-03-15 08:20:31','',''),('1','311',3549,'','20','3',3450.00,0.00,'Retail Sale Id 1836 for 5.00 KG of Cooking Gas @ N690.00','2023-03-15 08:23:02','',''),('1','311',3550,'','6.1','4',0.00,3450.00,'Retail Sale Id 1836 for retail product','2023-03-15 08:23:02','',''),('1','311',3551,'','20','3',1380.00,0.00,'Retail Sale Id 1837 for 2.00 KG of Cooking Gas @ N690.00','2023-03-15 08:27:06','',''),('1','311',3552,'','6.1','4',0.00,1380.00,'Retail Sale Id 1837 for retail product','2023-03-15 08:27:06','',''),('1','311',3553,'','20','3',1350.00,0.00,'Retail Sale Id 1838 for 1.96 KG of Cooking Gas @ N690.00','2023-03-15 08:28:31','',''),('1','311',3554,'','6.1','4',0.00,1350.00,'Retail Sale Id 1838 for retail product','2023-03-15 08:28:31','',''),('1','311',3555,'','20','3',2700.00,0.00,'Retail Sale Id 1839 for 3.91 KG of Cooking Gas @ N690.00','2023-03-15 08:36:22','',''),('1','311',3556,'','6.1','4',0.00,2700.00,'Retail Sale Id 1839 for retail product','2023-03-15 08:36:22','',''),('1','311',3557,'','20','3',1380.00,0.00,'Retail Sale Id 1840 for 2.00 KG of Cooking Gas @ N690.00','2023-03-15 08:38:30','',''),('1','311',3558,'','6.1','4',0.00,1380.00,'Retail Sale Id 1840 for retail product','2023-03-15 08:38:30','',''),('1','311',3559,'','20','3',134000.00,0.00,'Retail Sale Id 1841 for 200.00 KG of Cooking Gas @ N670.00','2023-03-15 08:44:35','',''),('1','311',3560,'','6.1','4',0.00,134000.00,'Retail Sale Id 1841 for retail product','2023-03-15 08:44:35','',''),('1','311',3561,'','20','3',2070.00,0.00,'Retail Sale Id 1842 for 3.00 KG of Cooking Gas @ N690.00','2023-03-15 08:45:10','',''),('1','311',3562,'','6.1','4',0.00,2070.00,'Retail Sale Id 1842 for retail product','2023-03-15 08:45:10','',''),('1','311',3563,'','20','3',3450.00,0.00,'Retail Sale Id 1843 for 5.00 KG of Cooking Gas @ N690.00','2023-03-15 08:45:45','',''),('1','311',3564,'','6.1','4',0.00,3450.00,'Retail Sale Id 1843 for retail product','2023-03-15 08:45:45','',''),('1','311',3565,'','20','3',1000.00,0.00,'Retail Sale Id 1844 for 1.45 KG of Cooking Gas @ N690.00','2023-03-15 08:46:41','',''),('1','311',3566,'','6.1','4',0.00,1000.00,'Retail Sale Id 1844 for retail product','2023-03-15 08:46:41','',''),('1','311',3567,'','20','3',5000.00,0.00,'Retail Sale Id 1845 for 7.25 KG of Cooking Gas @ N690.00','2023-03-15 08:50:35','',''),('1','311',3568,'','6.1','4',0.00,5000.00,'Retail Sale Id 1845 for retail product','2023-03-15 08:50:35','',''),('1','311',3569,'','20','3',2000.00,0.00,'Retail Sale Id 1846 for 2.90 KG of Cooking Gas @ N690.00','2023-03-15 08:52:31','',''),('1','311',3570,'','6.1','4',0.00,2000.00,'Retail Sale Id 1846 for retail product','2023-03-15 08:52:31','',''),('1','311',3571,'','20','3',1600.00,0.00,'Retail Sale Id 1847 for 2.32 KG of Cooking Gas @ N690.00','2023-03-15 08:53:59','',''),('1','311',3572,'','6.1','4',0.00,1600.00,'Retail Sale Id 1847 for retail product','2023-03-15 08:53:59','',''),('1','311',3573,'','20','3',4830.00,0.00,'Retail Sale Id 1848 for 7.00 KG of Cooking Gas @ N690.00','2023-03-15 09:02:56','',''),('1','311',3574,'','6.1','4',0.00,4830.00,'Retail Sale Id 1848 for retail product','2023-03-15 09:02:56','',''),('1','311',3575,'','20','3',6210.00,0.00,'Retail Sale Id 1849 for 9.00 KG of Cooking Gas @ N690.00','2023-03-15 09:06:01','',''),('1','311',3576,'','6.1','4',0.00,6210.00,'Retail Sale Id 1849 for retail product','2023-03-15 09:06:01','',''),('1','311',3577,'','20','3',2760.00,0.00,'Retail Sale Id 1850 for 4.00 KG of Cooking Gas @ N690.00','2023-03-15 09:10:35','',''),('1','311',3578,'','6.1','4',0.00,2760.00,'Retail Sale Id 1850 for retail product','2023-03-15 09:10:35','',''),('1','311',3579,'','20','3',1400.00,0.00,'Retail Sale Id 1851 for 2.03 KG of Cooking Gas @ N690.00','2023-03-15 09:12:58','',''),('1','311',3580,'','6.1','4',0.00,1400.00,'Retail Sale Id 1851 for retail product','2023-03-15 09:12:58','',''),('1','311',3581,'','20','3',2760.00,0.00,'Retail Sale Id 1852 for 4.00 KG of Cooking Gas @ N690.00','2023-03-15 09:22:13','',''),('1','311',3582,'','6.1','4',0.00,2760.00,'Retail Sale Id 1852 for retail product','2023-03-15 09:22:13','',''),('1','311',3583,'','20','3',1380.00,0.00,'Retail Sale Id 1853 for 2.00 KG of Cooking Gas @ N690.00','2023-03-15 09:23:03','',''),('1','311',3584,'','6.1','4',0.00,1380.00,'Retail Sale Id 1853 for retail product','2023-03-15 09:23:03','',''),('1','311',3585,'','20','3',4140.00,0.00,'Retail Sale Id 1854 for 6.00 KG of Cooking Gas @ N690.00','2023-03-15 09:23:59','',''),('1','311',3586,'','6.1','4',0.00,4140.00,'Retail Sale Id 1854 for retail product','2023-03-15 09:23:59','',''),('1','311',3587,'','20','3',3000.00,0.00,'Retail Sale Id 1855 for 4.35 KG of Cooking Gas @ N690.00','2023-03-15 09:32:00','',''),('1','311',3588,'','6.1','4',0.00,3000.00,'Retail Sale Id 1855 for retail product','2023-03-15 09:32:00','',''),('1','311',3589,'','20','3',8625.00,0.00,'Retail Sale Id 1856 for 12.50 KG of Cooking Gas @ N690.00','2023-03-15 09:37:16','',''),('1','311',3590,'','6.1','4',0.00,8625.00,'Retail Sale Id 1856 for retail product','2023-03-15 09:37:16','',''),('1','311',3591,'','20','3',2760.00,0.00,'Retail Sale Id 1857 for 4.00 KG of Cooking Gas @ N690.00','2023-03-15 09:38:53','',''),('1','311',3592,'','6.1','4',0.00,2760.00,'Retail Sale Id 1857 for retail product','2023-03-15 09:38:53','',''),('1','311',3593,'','20','3',2760.00,0.00,'Retail Sale Id 1858 for 4.00 KG of Cooking Gas @ N690.00','2023-03-15 10:08:29','',''),('1','311',3594,'','6.1','4',0.00,2760.00,'Retail Sale Id 1858 for retail product','2023-03-15 10:08:29','',''),('1','311',3595,'','20','3',3500.00,0.00,'Retail Sale Id 1860 for multiple products','2023-03-15 10:32:19','',''),('1','311',3596,'','6.1','4',0.00,3500.00,'Retail Sale Id 1860 for retail product','2023-03-15 10:32:19','',''),('1','311',3597,'','20','3',39530.00,0.00,'Retail Sale Id 1859 for 59.00 KG of Cooking Gas @ N670.00','2023-03-15 10:33:58','',''),('1','311',3598,'','6.1','4',0.00,39530.00,'Retail Sale Id 1859 for retail product','2023-03-15 10:33:58','',''),('1','311',3599,'','20','3',2070.00,0.00,'Retail Sale Id 1861 for 3.00 KG of Cooking Gas @ N690.00','2023-03-15 10:35:25','',''),('1','311',3600,'','6.1','4',0.00,2070.00,'Retail Sale Id 1861 for retail product','2023-03-15 10:35:25','',''),('1','311',3601,'','20','3',6900.00,0.00,'Retail Sale Id 1863 for 10.00 KG of Cooking Gas @ N690.00','2023-03-15 10:46:45','',''),('1','311',3602,'','6.1','4',0.00,6900.00,'Retail Sale Id 1863 for retail product','2023-03-15 10:46:45','',''),('1','311',3603,'','20','3',4140.00,0.00,'Retail Sale Id 1865 for 6.00 KG of Cooking Gas @ N690.00','2023-03-15 11:03:35','',''),('1','311',3604,'','6.1','4',0.00,4140.00,'Retail Sale Id 1865 for retail product','2023-03-15 11:03:35','',''),('1','311',3605,'','6.1','4',0.00,4140.00,'Retail Sale Id 1865 for retail product','2023-03-15 11:03:35','',''),('1','311',3606,'','20','3',4830.00,0.00,'Retail Sale Id 1866 for 7.00 KG of Cooking Gas @ N690.00','2023-03-15 11:09:57','',''),('1','311',3607,'','6.1','4',0.00,4830.00,'Retail Sale Id 1866 for retail product','2023-03-15 11:09:57','',''),('1','311',3608,'','20','3',1380.00,0.00,'Retail Sale Id 1867 for 2.00 KG of Cooking Gas @ N690.00','2023-03-15 11:12:51','',''),('1','311',3609,'','6.1','4',0.00,1380.00,'Retail Sale Id 1867 for retail product','2023-03-15 11:12:51','',''),('1','311',3610,'','20','3',8625.00,0.00,'Retail Sale Id 1872 for 12.50 KG of Cooking Gas @ N690.00','2023-03-15 11:39:48','',''),('1','311',3611,'','6.1','4',0.00,8625.00,'Retail Sale Id 1872 for retail product','2023-03-15 11:39:48','',''),('1','311',3612,'','20','3',8625.00,0.00,'Retail Sale Id 1873 for 12.50 KG of Cooking Gas @ N690.00','2023-03-15 11:49:27','',''),('1','311',3613,'','6.1','4',0.00,8625.00,'Retail Sale Id 1873 for retail product','2023-03-15 11:49:27','',''),('1','311',3614,'','20','3',2070.00,0.00,'Retail Sale Id 1874 for 3.00 KG of Cooking Gas @ N690.00','2023-03-15 11:50:47','',''),('1','311',3615,'','6.1','4',0.00,2070.00,'Retail Sale Id 1874 for retail product','2023-03-15 11:50:47','',''),('1','311',3616,'','20','3',4140.00,0.00,'Retail Sale Id 1875 for 6.00 KG of Cooking Gas @ N690.00','2023-03-15 11:52:22','',''),('1','311',3617,'','6.1','4',0.00,4140.00,'Retail Sale Id 1875 for retail product','2023-03-15 11:52:22','',''),('1','311',3618,'','20','3',3450.00,0.00,'Retail Sale Id 1876 for 5.00 KG of Cooking Gas @ N690.00','2023-03-15 12:15:47','',''),('1','311',3619,'','6.1','4',0.00,3450.00,'Retail Sale Id 1876 for retail product','2023-03-15 12:15:47','',''),('1','311',3620,'','20','3',8625.00,0.00,'Retail Sale Id 1877 for 12.50 KG of Cooking Gas @ N690.00','2023-03-15 12:23:09','',''),('1','311',3621,'','6.1','4',0.00,8625.00,'Retail Sale Id 1877 for retail product','2023-03-15 12:23:09','',''),('1','311',3622,'','20','3',4000.00,0.00,'Retail Sale Id 1879 for 5.80 KG of Cooking Gas @ N690.00','2023-03-15 12:50:15','',''),('1','311',3623,'','6.1','4',0.00,4000.00,'Retail Sale Id 1879 for retail product','2023-03-15 12:50:15','',''),('1','311',3624,'','6.1','4',0.00,4000.00,'Retail Sale Id 1879 for retail product','2023-03-15 12:50:15','',''),('1','311',3625,'','20','3',0.00,4000.00,'Return of Retail Sale Id 1879 for products','2023-03-15 12:52:03','',''),('1','311',3626,'','','',4000.00,0.00,'Return of Retail Sale Id 1879 for products','2023-03-15 12:52:03','',''),('1','311',3627,'','20','3',4000.00,0.00,'Retail Sale Id 1880 for 5.80 KG of Cooking Gas @ N690.00','2023-03-15 12:52:36','',''),('1','311',3628,'','6.1','4',0.00,4000.00,'Retail Sale Id 1880 for retail product','2023-03-15 12:52:36','',''),('1','311',3629,'','20','3',6900.00,0.00,'Retail Sale Id 1882 for 10.00 KG of Cooking Gas @ N690.00','2023-03-15 13:07:44','',''),('1','311',3630,'','6.1','4',0.00,6900.00,'Retail Sale Id 1882 for retail product','2023-03-15 13:07:44','',''),('1','311',3631,'','20','3',3450.00,0.00,'Retail Sale Id 1883 for 5.00 KG of Cooking Gas @ N690.00','2023-03-15 13:20:15','',''),('1','311',3632,'','6.1','4',0.00,3450.00,'Retail Sale Id 1883 for retail product','2023-03-15 13:20:15','',''),('1','311',3633,'','20','3',9660.00,0.00,'Retail Sale Id 1884 for multiple products','2023-03-15 13:46:34','',''),('1','311',3634,'','6.1','4',0.00,9660.00,'Retail Sale Id 1884 for retail product','2023-03-15 13:46:34','',''),('1','311',3635,'','20','3',3450.00,0.00,'Retail Sale Id 1885 for 5.00 KG of Cooking Gas @ N690.00','2023-03-15 13:48:56','',''),('1','311',3636,'','6.1','4',0.00,3450.00,'Retail Sale Id 1885 for retail product','2023-03-15 13:48:56','',''),('1','311',3637,'','20','3',3450.00,0.00,'Retail Sale Id 1886 for 5.00 KG of Cooking Gas @ N690.00','2023-03-15 14:38:55','',''),('1','311',3638,'','6.1','4',0.00,3450.00,'Retail Sale Id 1886 for retail product','2023-03-15 14:38:55','',''),('1','311',3639,'','20','3',8625.00,0.00,'Retail Sale Id 1887 for 12.50 KG of Cooking Gas @ N690.00','2023-03-15 14:39:53','',''),('1','311',3640,'','6.1','4',0.00,8625.00,'Retail Sale Id 1887 for retail product','2023-03-15 14:39:54','',''),('1','311',3641,'','20','3',8625.00,0.00,'Retail Sale Id 1888 for 12.50 KG of Cooking Gas @ N690.00','2023-03-15 14:41:13','',''),('1','311',3642,'','6.1','4',0.00,8625.00,'Retail Sale Id 1888 for retail product','2023-03-15 14:41:13','',''),('1','311',3643,'','20','3',2760.00,0.00,'Retail Sale Id 1890 for 4.00 KG of Cooking Gas @ N690.00','2023-03-15 14:47:09','',''),('1','311',3644,'','6.1','4',0.00,2760.00,'Retail Sale Id 1890 for retail product','2023-03-15 14:47:09','',''),('1','311',3645,'','20','3',8625.00,0.00,'Retail Sale Id 1891 for 12.50 KG of Cooking Gas @ N690.00','2023-03-15 14:50:24','',''),('1','311',3646,'','6.1','4',0.00,8625.00,'Retail Sale Id 1891 for retail product','2023-03-15 14:50:24','',''),('1','311',3647,'','20','3',1380.00,0.00,'Retail Sale Id 1892 for 2.00 KG of Cooking Gas @ N690.00','2023-03-15 14:51:59','',''),('1','311',3648,'','6.1','4',0.00,1380.00,'Retail Sale Id 1892 for retail product','2023-03-15 14:51:59','',''),('1','311',3649,'','20','3',1380.00,0.00,'Retail Sale Id 1894 for 2.00 KG of Cooking Gas @ N690.00','2023-03-15 14:54:28','',''),('1','311',3650,'','6.1','4',0.00,1380.00,'Retail Sale Id 1894 for retail product','2023-03-15 14:54:28','',''),('1','311',3651,'','20','3',6900.00,0.00,'Retail Sale Id 1895 for 10.00 KG of Cooking Gas @ N690.00','2023-03-15 14:56:22','',''),('1','311',3652,'','6.1','4',0.00,6900.00,'Retail Sale Id 1895 for retail product','2023-03-15 14:56:22','',''),('1','311',3653,'','20','3',4140.00,0.00,'Retail Sale Id 1896 for 6.00 KG of Cooking Gas @ N690.00','2023-03-15 14:58:03','',''),('1','311',3654,'','6.1','4',0.00,4140.00,'Retail Sale Id 1896 for retail product','2023-03-15 14:58:03','',''),('1','311',3655,'','20','3',8625.00,0.00,'Retail Sale Id 1897 for 12.50 KG of Cooking Gas @ N690.00','2023-03-15 15:21:28','',''),('1','311',3656,'','6.1','4',0.00,8625.00,'Retail Sale Id 1897 for retail product','2023-03-15 15:21:28','',''),('1','311',3657,'','20','3',8625.00,0.00,'Retail Sale Id 1899 for 12.50 KG of Cooking Gas @ N690.00','2023-03-15 15:43:50','',''),('1','311',3658,'','6.1','4',0.00,8625.00,'Retail Sale Id 1899 for retail product','2023-03-15 15:43:50','',''),('1','311',3659,'','20','3',8625.00,0.00,'Retail Sale Id 1900 for 12.50 KG of Cooking Gas @ N690.00','2023-03-15 15:45:01','',''),('1','311',3660,'','6.1','4',0.00,8625.00,'Retail Sale Id 1900 for retail product','2023-03-15 15:45:01','',''),('1','311',3661,'','20','3',3450.00,0.00,'Retail Sale Id 1901 for 5.00 KG of Cooking Gas @ N690.00','2023-03-15 15:46:13','',''),('1','311',3662,'','6.1','4',0.00,3450.00,'Retail Sale Id 1901 for retail product','2023-03-15 15:46:13','',''),('1','311',3663,'','20','3',1700.00,0.00,'Retail Sale Id 1903 for 2.46 KG of Cooking Gas @ N690.00','2023-03-15 15:56:55','',''),('1','311',3664,'','6.1','4',0.00,1700.00,'Retail Sale Id 1903 for retail product','2023-03-15 15:56:55','',''),('1','311',3665,'','20','3',3450.00,0.00,'Retail Sale Id 1904 for 5.00 KG of Cooking Gas @ N690.00','2023-03-15 16:00:50','',''),('1','311',3666,'','6.1','4',0.00,3450.00,'Retail Sale Id 1904 for retail product','2023-03-15 16:00:50','',''),('1','311',3667,'','20','3',4000.00,0.00,'Retail Sale Id 1905 for 5.80 KG of Cooking Gas @ N690.00','2023-03-15 16:02:05','',''),('1','311',3668,'','6.1','4',0.00,4000.00,'Retail Sale Id 1905 for retail product','2023-03-15 16:02:05','',''),('1','311',3669,'','20','3',1000.00,0.00,'Retail Sale Id 1906 for 1.45 KG of Cooking Gas @ N690.00','2023-03-15 16:03:57','',''),('1','311',3670,'','6.1','4',0.00,1000.00,'Retail Sale Id 1906 for retail product','2023-03-15 16:03:57','',''),('1','311',3671,'','20','3',1200.00,0.00,'Retail Sale Id 1907 for 1.74 KG of Cooking Gas @ N690.00','2023-03-15 16:10:25','',''),('1','311',3672,'','6.1','4',0.00,1200.00,'Retail Sale Id 1907 for retail product','2023-03-15 16:10:25','',''),('1','311',3673,'','20','3',1380.00,0.00,'Retail Sale Id 1908 for 2.00 KG of Cooking Gas @ N690.00','2023-03-15 16:12:09','',''),('1','311',3674,'','6.1','4',0.00,1380.00,'Retail Sale Id 1908 for retail product','2023-03-15 16:12:09','',''),('1','311',3675,'','20','3',1000.00,0.00,'Retail Sale Id 1909 for 1.45 KG of Cooking Gas @ N690.00','2023-03-15 16:19:43','',''),('1','311',3676,'','6.1','4',0.00,1000.00,'Retail Sale Id 1909 for retail product','2023-03-15 16:19:43','',''),('1','311',3677,'','20','3',6900.00,0.00,'Retail Sale Id 1910 for 10.00 KG of Cooking Gas @ N690.00','2023-03-15 16:20:53','',''),('1','311',3678,'','6.1','4',0.00,6900.00,'Retail Sale Id 1910 for retail product','2023-03-15 16:20:53','',''),('1','311',3679,'','20','3',2070.00,0.00,'Retail Sale Id 1911 for 3.00 KG of Cooking Gas @ N690.00','2023-03-15 16:22:09','',''),('1','311',3680,'','6.1','4',0.00,2070.00,'Retail Sale Id 1911 for retail product','2023-03-15 16:22:09','',''),('1','311',3681,'','20','3',3450.00,0.00,'Retail Sale Id 1912 for 5.00 KG of Cooking Gas @ N690.00','2023-03-15 16:25:37','',''),('1','311',3682,'','6.1','4',0.00,3450.00,'Retail Sale Id 1912 for retail product','2023-03-15 16:25:37','',''),('1','311',3683,'','20','3',4140.00,0.00,'Retail Sale Id 1913 for 6.00 KG of Cooking Gas @ N690.00','2023-03-15 16:26:52','',''),('1','311',3684,'','6.1','4',0.00,4140.00,'Retail Sale Id 1913 for retail product','2023-03-15 16:26:52','',''),('1','311',3685,'','20','3',3500.00,0.00,'Retail Sale Id 1914 for 5.07 KG of Cooking Gas @ N690.00','2023-03-15 16:28:25','',''),('1','311',3686,'','6.1','4',0.00,3500.00,'Retail Sale Id 1914 for retail product','2023-03-15 16:28:25','',''),('1','311',3687,'','20','3',2070.00,0.00,'Retail Sale Id 1915 for 3.00 KG of Cooking Gas @ N690.00','2023-03-15 16:29:50','',''),('1','311',3688,'','6.1','4',0.00,2070.00,'Retail Sale Id 1915 for retail product','2023-03-15 16:29:50','',''),('1','311',3689,'','20','3',8625.00,0.00,'Retail Sale Id 1916 for 12.50 KG of Cooking Gas @ N690.00','2023-03-15 16:31:57','',''),('1','311',3690,'','6.1','4',0.00,8625.00,'Retail Sale Id 1916 for retail product','2023-03-15 16:31:57','',''),('1','311',3691,'','20','3',1380.00,0.00,'Retail Sale Id 1917 for 2.00 KG of Cooking Gas @ N690.00','2023-03-15 16:33:03','',''),('1','311',3692,'','6.1','4',0.00,1380.00,'Retail Sale Id 1917 for retail product','2023-03-15 16:33:03','',''),('1','311',3693,'','20','3',2070.00,0.00,'Retail Sale Id 1918 for 3.00 KG of Cooking Gas @ N690.00','2023-03-15 16:33:51','',''),('1','311',3694,'','6.1','4',0.00,2070.00,'Retail Sale Id 1918 for retail product','2023-03-15 16:33:51','',''),('1','311',3695,'','20','3',2070.00,0.00,'Retail Sale Id 1919 for 3.00 KG of Cooking Gas @ N690.00','2023-03-15 16:34:30','',''),('1','311',3696,'','6.1','4',0.00,2070.00,'Retail Sale Id 1919 for retail product','2023-03-15 16:34:30','',''),('1','311',3697,'','20','3',8625.00,0.00,'Retail Sale Id 1920 for 12.50 KG of Cooking Gas @ N690.00','2023-03-15 16:37:01','',''),('1','311',3698,'','6.1','4',0.00,8625.00,'Retail Sale Id 1920 for retail product','2023-03-15 16:37:01','',''),('1','311',3699,'','20','3',1000.00,0.00,'Retail Sale Id 1921 for 1.45 KG of Cooking Gas @ N690.00','2023-03-15 16:38:19','',''),('1','311',3700,'','6.1','4',0.00,1000.00,'Retail Sale Id 1921 for retail product','2023-03-15 16:38:19','',''),('1','311',3701,'','20','3',3450.00,0.00,'Retail Sale Id 1922 for 5.00 KG of Cooking Gas @ N690.00','2023-03-15 16:40:25','',''),('1','311',3702,'','6.1','4',0.00,3450.00,'Retail Sale Id 1922 for retail product','2023-03-15 16:40:25','',''),('1','311',3703,'','20','3',3000.00,0.00,'Retail Sale Id 1923 for 4.35 KG of Cooking Gas @ N690.00','2023-03-15 16:43:13','',''),('1','311',3704,'','6.1','4',0.00,3000.00,'Retail Sale Id 1923 for retail product','2023-03-15 16:43:13','',''),('1','311',3705,'','20','3',13800.00,0.00,'Retail Sale Id 1924 for multiple products','2023-03-15 16:47:03','',''),('1','311',3706,'','6.1','4',0.00,13800.00,'Retail Sale Id 1924 for retail product','2023-03-15 16:47:03','',''),('1','311',3707,'','2','20',227590.00,0.00,'Payment Id 80 for invoice:27, receipt: 0076 by AA RANO NIGERIA LTD','2023-03-15 16:49:07','',''),('1','311',3708,'','supplier','1',0.00,227590.00,'Payment Id 80 for invoice:27, receipt: 0076 by AA RANO NIGERIA LTD','2023-03-15 16:49:07','',''),('1','311',3709,'','2','9',308450.00,0.00,'Payment Id 79 for invoice:27, receipt: 0075 by AA RANO NIGERIA LTD','2023-03-15 16:49:07','',''),('1','311',3710,'','supplier','1',0.00,308450.00,'Payment Id 79 for invoice:27, receipt: 0075 by AA RANO NIGERIA LTD','2023-03-15 16:49:07','',''),('1','311',3711,'','2','15',38010.00,0.00,'Payment Id 78 for invoice:27, receipt: 0074 by AA RANO NIGERIA LTD','2023-03-15 16:49:07','',''),('1','311',3712,'','supplier','1',0.00,38010.00,'Payment Id 78 for invoice:27, receipt: 0074 by AA RANO NIGERIA LTD','2023-03-15 16:49:07','',''),('1','311',3713,'','20','3',3450.00,0.00,'Retail Sale Id 1925 for 5.00 KG of Cooking Gas @ N690.00','2023-03-15 16:49:24','',''),('1','311',3714,'','6.1','4',0.00,3450.00,'Retail Sale Id 1925 for retail product','2023-03-15 16:49:24','',''),('1','311',3715,'','2','20',738427.00,0.00,'Payment Id 84 for invoice:28, receipt: 0078 by AA RANO NIGERIA LTD','2023-03-15 16:50:09','',''),('1','311',3716,'','supplier','1',0.00,738427.00,'Payment Id 84 for invoice:28, receipt: 0078 by AA RANO NIGERIA LTD','2023-03-15 16:50:09','',''),('1','311',3717,'','2','9',234760.34,0.00,'Payment Id 83 for invoice:28, receipt: 0077 by AA RANO NIGERIA LTD','2023-03-15 16:50:09','',''),('1','311',3718,'','supplier','1',0.00,234760.34,'Payment Id 83 for invoice:28, receipt: 0077 by AA RANO NIGERIA LTD','2023-03-15 16:50:09','',''),('1','311',3719,'','20','3',3450.00,0.00,'Retail Sale Id 1926 for 5.00 KG of Cooking Gas @ N690.00','2023-03-15 16:52:11','',''),('1','311',3720,'','6.1','4',0.00,3450.00,'Retail Sale Id 1926 for retail product','2023-03-15 16:52:11','',''),('1','311',3721,'','20','3',2070.00,0.00,'Retail Sale Id 1927 for 3.00 KG of Cooking Gas @ N690.00','2023-03-15 16:53:59','',''),('1','311',3722,'','6.1','4',0.00,2070.00,'Retail Sale Id 1927 for retail product','2023-03-15 16:53:59','',''),('1','311',3723,'','20','3',2760.00,0.00,'Retail Sale Id 1928 for 4.00 KG of Cooking Gas @ N690.00','2023-03-15 16:58:34','',''),('1','311',3724,'','6.1','4',0.00,2760.00,'Retail Sale Id 1928 for retail product','2023-03-15 16:58:34','',''),('1','311',3725,'','20','3',1500.00,0.00,'Retail Sale Id 1929 for 2.17 KG of Cooking Gas @ N690.00','2023-03-15 17:02:08','',''),('1','311',3726,'','6.1','4',0.00,1500.00,'Retail Sale Id 1929 for retail product','2023-03-15 17:02:08','',''),('1','311',3727,'','20','3',1000.00,0.00,'Retail Sale Id 1930 for 1.45 KG of Cooking Gas @ N690.00','2023-03-15 17:03:31','',''),('1','311',3728,'','6.1','4',0.00,1000.00,'Retail Sale Id 1930 for retail product','2023-03-15 17:03:31','',''),('1','311',3729,'','20','3',6000.00,0.00,'Retail Sale Id 1931 for 8.70 KG of Cooking Gas @ N690.00','2023-03-15 17:07:41','',''),('1','311',3730,'','6.1','4',0.00,6000.00,'Retail Sale Id 1931 for retail product','2023-03-15 17:07:41','',''),('1','311',3731,'','20','3',11385.00,0.00,'Retail Sale Id 1933 for 16.50 KG of Cooking Gas @ N690.00','2023-03-15 17:37:28','',''),('1','311',3732,'','6.1','4',0.00,11385.00,'Retail Sale Id 1933 for retail product','2023-03-15 17:37:28','',''),('1','311',3733,'','20','3',8970.00,0.00,'Retail Sale Id 1934 for 13.00 KG of Cooking Gas @ N690.00','2023-03-15 17:38:26','',''),('1','311',3734,'','6.1','4',0.00,8970.00,'Retail Sale Id 1934 for retail product','2023-03-15 17:38:26','',''),('1','311',3735,'','20','3',8220.00,0.00,'Retail Sale Id 1935 for multiple products','2023-03-15 17:40:03','',''),('1','311',3736,'','6.1','4',0.00,8220.00,'Retail Sale Id 1935 for retail product','2023-03-15 17:40:03','',''),('1','311',3737,'','20','3',0.00,11385.00,'Return of Retail Sale Id 1933 for products','2023-03-15 17:45:23','',''),('1','311',3738,'','','',11385.00,0.00,'Return of Retail Sale Id 1933 for products','2023-03-15 17:45:23','',''),('1','311',3739,'','20','3',7673.09,0.00,'Retail Sale Id 1936 for 11.12 KG of Cooking Gas @ N690.00','2023-03-15 17:46:10','',''),('1','311',3740,'','6.1','4',0.00,7673.09,'Retail Sale Id 1936 for retail product','2023-03-15 17:46:10','',''),('1','311',3741,'','20','3',0.00,0.00,'Sales from shift 29 on 2023-03-15 17:49:40 ','2023-03-15 17:49:40','',''),('1','311',3742,'','6.1','4',0.00,0.00,'Sales from shift 29 on 2023-03-15 17:49:40 ','2023-03-15 17:49:40','',''),('1','311',3743,'','20','3',4485.00,0.00,'Retail Sale Id 1937 for 6.50 KG of Cooking Gas @ N690.00','2023-03-16 08:07:11','',''),('1','311',3744,'','6.1','4',0.00,4485.00,'Retail Sale Id 1937 for retail product','2023-03-16 08:07:11','',''),('1','311',3745,'','20','3',2070.00,0.00,'Retail Sale Id 1938 for 3.00 KG of Cooking Gas @ N690.00','2023-03-16 08:19:46','',''),('1','311',3746,'','6.1','4',0.00,2070.00,'Retail Sale Id 1938 for retail product','2023-03-16 08:19:46','',''),('1','311',3747,'','20','3',3450.00,0.00,'Retail Sale Id 1939 for 5.00 KG of Cooking Gas @ N690.00','2023-03-16 08:23:44','',''),('1','311',3748,'','6.1','4',0.00,3450.00,'Retail Sale Id 1939 for retail product','2023-03-16 08:23:44','',''),('1','311',3749,'','20','3',6900.00,0.00,'Retail Sale Id 1940 for multiple products','2023-03-16 08:27:29','',''),('1','311',3750,'','6.1','4',0.00,6900.00,'Retail Sale Id 1940 for retail product','2023-03-16 08:27:29','',''),('1','311',3751,'','20','3',2700.00,0.00,'Retail Sale Id 1941 for 3.91 KG of Cooking Gas @ N690.00','2023-03-16 08:28:46','',''),('1','311',3752,'','6.1','4',0.00,2700.00,'Retail Sale Id 1941 for retail product','2023-03-16 08:28:46','',''),('1','311',3753,'','20','3',700.00,0.00,'Retail Sale Id 1943 for 1.01 KG of Cooking Gas @ N690.00','2023-03-16 08:31:11','',''),('1','311',3754,'','6.1','4',0.00,700.00,'Retail Sale Id 1943 for retail product','2023-03-16 08:31:11','',''),('1','311',3755,'','20','3',1000.00,0.00,'Retail Sale Id 1945 for 1.45 KG of Cooking Gas @ N690.00','2023-03-16 08:32:50','',''),('1','311',3756,'','6.1','4',0.00,1000.00,'Retail Sale Id 1945 for retail product','2023-03-16 08:32:50','',''),('1','311',3757,'','20','3',2500.00,0.00,'Retail Sale Id 1946 for 3.62 KG of Cooking Gas @ N690.00','2023-03-16 08:34:13','',''),('1','311',3758,'','6.1','4',0.00,2500.00,'Retail Sale Id 1946 for retail product','2023-03-16 08:34:13','',''),('1','311',3759,'','20','3',3450.00,0.00,'Retail Sale Id 1947 for 5.00 KG of Cooking Gas @ N690.00','2023-03-16 08:37:36','',''),('1','311',3760,'','6.1','4',0.00,3450.00,'Retail Sale Id 1947 for retail product','2023-03-16 08:37:36','',''),('1','311',3761,'','20','3',8625.00,0.00,'Retail Sale Id 1948 for 12.50 KG of Cooking Gas @ N690.00','2023-03-16 08:40:01','',''),('1','311',3762,'','6.1','4',0.00,8625.00,'Retail Sale Id 1948 for retail product','2023-03-16 08:40:01','',''),('1','311',3763,'','20','3',7590.00,0.00,'Retail Sale Id 1949 for 11.00 KG of Cooking Gas @ N690.00','2023-03-16 08:41:35','',''),('1','311',3764,'','6.1','4',0.00,7590.00,'Retail Sale Id 1949 for retail product','2023-03-16 08:41:35','',''),('1','311',3765,'','20','3',2070.00,0.00,'Retail Sale Id 1950 for 3.00 KG of Cooking Gas @ N690.00','2023-03-16 08:47:18','',''),('1','311',3766,'','6.1','4',0.00,2070.00,'Retail Sale Id 1950 for retail product','2023-03-16 08:47:18','',''),('1','311',3767,'','20','3',8625.00,0.00,'Retail Sale Id 1951 for 12.50 KG of Cooking Gas @ N690.00','2023-03-16 08:48:30','',''),('1','311',3768,'','6.1','4',0.00,8625.00,'Retail Sale Id 1951 for retail product','2023-03-16 08:48:30','',''),('1','311',3769,'','20','3',1500.00,0.00,'Retail Sale Id 1952 for 2.17 KG of Cooking Gas @ N690.00','2023-03-16 08:52:58','',''),('1','311',3770,'','6.1','4',0.00,1500.00,'Retail Sale Id 1952 for retail product','2023-03-16 08:52:58','',''),('1','311',3771,'','20','3',0.00,2500.00,'Return of Retail Sale Id 1946 for products','2023-03-16 08:59:08','',''),('1','311',3772,'','','',2500.00,0.00,'Return of Retail Sale Id 1946 for products','2023-03-16 08:59:08','',''),('1','311',3773,'','20','3',0.00,2700.00,'Return of Retail Sale Id 1941 for products','2023-03-16 09:00:08','',''),('1','311',3774,'','','',2700.00,0.00,'Return of Retail Sale Id 1941 for products','2023-03-16 09:00:08','',''),('1','311',3775,'','20','3',3000.00,0.00,'Retail Sale Id 1953 for 4.35 KG of Cooking Gas @ N690.00','2023-03-16 09:03:15','',''),('1','311',3776,'','6.1','4',0.00,3000.00,'Retail Sale Id 1953 for retail product','2023-03-16 09:03:15','',''),('1','311',3777,'','20','3',4000.00,0.00,'Retail Sale Id 1954 for 5.80 KG of Cooking Gas @ N690.00','2023-03-16 09:10:39','',''),('1','311',3778,'','6.1','4',0.00,4000.00,'Retail Sale Id 1954 for retail product','2023-03-16 09:10:39','',''),('1','311',3779,'','20','3',2760.00,0.00,'Retail Sale Id 1955 for 4.00 KG of Cooking Gas @ N690.00','2023-03-16 09:12:12','',''),('1','311',3780,'','6.1','4',0.00,2760.00,'Retail Sale Id 1955 for retail product','2023-03-16 09:12:12','',''),('1','311',3781,'','20','3',1400.00,0.00,'Retail Sale Id 1956 for 2.03 KG of Cooking Gas @ N690.00','2023-03-16 09:13:00','',''),('1','311',3782,'','6.1','4',0.00,1400.00,'Retail Sale Id 1956 for retail product','2023-03-16 09:13:00','',''),('1','311',3783,'','20','3',6900.00,0.00,'Retail Sale Id 1957 for 10.00 KG of Cooking Gas @ N690.00','2023-03-16 09:13:55','',''),('1','311',3784,'','6.1','4',0.00,6900.00,'Retail Sale Id 1957 for retail product','2023-03-16 09:13:55','',''),('1','311',3785,'','20','3',1500.00,0.00,'Retail Sale Id 1958 for 2.17 KG of Cooking Gas @ N690.00','2023-03-16 09:30:39','',''),('1','311',3786,'','6.1','4',0.00,1500.00,'Retail Sale Id 1958 for retail product','2023-03-16 09:30:39','',''),('1','311',3787,'','20','3',690.00,0.00,'Retail Sale Id 1959 for 1.00 KG of Cooking Gas @ N690.00','2023-03-16 09:32:15','',''),('1','311',3788,'','6.1','4',0.00,690.00,'Retail Sale Id 1959 for retail product','2023-03-16 09:32:15','',''),('1','311',3789,'','20','3',4140.00,0.00,'Retail Sale Id 1960 for 6.00 KG of Cooking Gas @ N690.00','2023-03-16 09:35:22','',''),('1','311',3790,'','6.1','4',0.00,4140.00,'Retail Sale Id 1960 for retail product','2023-03-16 09:35:22','',''),('1','311',3791,'','20','3',690.00,0.00,'Retail Sale Id 1961 for 1.00 KG of Cooking Gas @ N690.00','2023-03-16 09:36:53','',''),('1','311',3792,'','6.1','4',0.00,690.00,'Retail Sale Id 1961 for retail product','2023-03-16 09:36:53','',''),('1','311',3793,'','20','3',2415.00,0.00,'Retail Sale Id 1962 for 3.50 KG of Cooking Gas @ N690.00','2023-03-16 09:39:11','',''),('1','311',3794,'','6.1','4',0.00,2415.00,'Retail Sale Id 1962 for retail product','2023-03-16 09:39:11','',''),('1','311',3795,'','20','3',2760.00,0.00,'Retail Sale Id 1963 for 4.00 KG of Cooking Gas @ N690.00','2023-03-16 09:44:43','',''),('1','311',3796,'','6.1','4',0.00,2760.00,'Retail Sale Id 1963 for retail product','2023-03-16 09:44:43','',''),('1','311',3797,'','20','3',39530.00,0.00,'Retail Sale Id 1964 for 59.00 KG of Cooking Gas @ N670.00','2023-03-16 09:46:22','',''),('1','311',3798,'','6.1','4',0.00,39530.00,'Retail Sale Id 1964 for retail product','2023-03-16 09:46:22','',''),('1','311',3799,'','20','3',2000.00,0.00,'Retail Sale Id 1965 for 2.90 KG of Cooking Gas @ N690.00','2023-03-16 09:57:52','',''),('1','311',3800,'','6.1','4',0.00,2000.00,'Retail Sale Id 1965 for retail product','2023-03-16 09:57:52','',''),('1','311',3801,'','20','3',3450.00,0.00,'Retail Sale Id 1966 for 5.00 KG of Cooking Gas @ N690.00','2023-03-16 10:02:36','',''),('1','311',3802,'','6.1','4',0.00,3450.00,'Retail Sale Id 1966 for retail product','2023-03-16 10:02:36','',''),('1','311',3803,'','20','3',3450.00,0.00,'Retail Sale Id 1967 for 5.00 KG of Cooking Gas @ N690.00','2023-03-16 10:17:25','',''),('1','311',3804,'','6.1','4',0.00,3450.00,'Retail Sale Id 1967 for retail product','2023-03-16 10:17:25','',''),('1','311',3805,'','20','3',17595.00,0.00,'Retail Sale Id 1968 for multiple products','2023-03-16 10:21:07','',''),('1','311',3806,'','6.1','4',0.00,17595.00,'Retail Sale Id 1968 for retail product','2023-03-16 10:21:07','',''),('1','311',3807,'','20','3',5520.00,0.00,'Retail Sale Id 1969 for 8.00 KG of Cooking Gas @ N690.00','2023-03-16 10:29:38','',''),('1','311',3808,'','6.1','4',0.00,5520.00,'Retail Sale Id 1969 for retail product','2023-03-16 10:29:38','',''),('1','311',3809,'','20','3',4485.00,0.00,'Retail Sale Id 1970 for 6.50 KG of Cooking Gas @ N690.00','2023-03-16 10:31:04','',''),('1','311',3810,'','6.1','4',0.00,4485.00,'Retail Sale Id 1970 for retail product','2023-03-16 10:31:04','',''),('1','311',3811,'','20','3',4140.00,0.00,'Retail Sale Id 1971 for 6.00 KG of Cooking Gas @ N690.00','2023-03-16 10:32:36','',''),('1','311',3812,'','6.1','4',0.00,4140.00,'Retail Sale Id 1971 for retail product','2023-03-16 10:32:36','',''),('1','311',3813,'','20','3',2000.00,0.00,'Retail Sale Id 1972 for 2.90 KG of Cooking Gas @ N690.00','2023-03-16 10:42:13','',''),('1','311',3814,'','6.1','4',0.00,2000.00,'Retail Sale Id 1972 for retail product','2023-03-16 10:42:13','',''),('1','311',3815,'','20','3',3450.00,0.00,'Retail Sale Id 1973 for 5.00 KG of Cooking Gas @ N690.00','2023-03-16 10:43:11','',''),('1','311',3816,'','6.1','4',0.00,3450.00,'Retail Sale Id 1973 for retail product','2023-03-16 10:43:11','',''),('1','311',3817,'','20','3',67000.00,0.00,'Retail Sale Id 1975 for 100.00 KG of Cooking Gas @ N670.00','2023-03-16 10:57:19','',''),('1','311',3818,'','6.1','4',0.00,67000.00,'Retail Sale Id 1975 for retail product','2023-03-16 10:57:19','',''),('1','311',3819,'','20','3',3000.00,0.00,'Retail Sale Id 1976 for 4.35 KG of Cooking Gas @ N690.00','2023-03-16 11:03:00','',''),('1','311',3820,'','6.1','4',0.00,3000.00,'Retail Sale Id 1976 for retail product','2023-03-16 11:03:00','',''),('1','311',3821,'','20','3',3450.00,0.00,'Retail Sale Id 1977 for 5.00 KG of Cooking Gas @ N690.00','2023-03-16 11:04:32','',''),('1','311',3822,'','6.1','4',0.00,3450.00,'Retail Sale Id 1977 for retail product','2023-03-16 11:04:32','',''),('1','311',3823,'','20','3',0.00,67000.00,'Return of Retail Sale Id 1975 for products','2023-03-16 11:12:36','',''),('1','311',3824,'','','',67000.00,0.00,'Return of Retail Sale Id 1975 for products','2023-03-16 11:12:36','',''),('1','311',3825,'','20','3',33500.00,0.00,'Retail Sale Id 1978 for 50.00 KG of Cooking Gas @ N670.00','2023-03-16 11:13:38','',''),('1','311',3826,'','6.1','4',0.00,33500.00,'Retail Sale Id 1978 for retail product','2023-03-16 11:13:38','',''),('1','311',3827,'','20','3',33500.00,0.00,'Retail Sale Id 1979 for 50.00 KG of Cooking Gas @ N670.00','2023-03-16 11:14:43','',''),('1','311',3828,'','6.1','4',0.00,33500.00,'Retail Sale Id 1979 for retail product','2023-03-16 11:14:43','',''),('1','311',3829,'','20','3',38746.10,0.00,'Retail Sale Id 1980 for 57.83 KG of Cooking Gas @ N670.0