-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_310
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_310`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_310` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_310`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,4000,'',0,'22','1','310','PURCHASES','','2023-01-23 00:30:22',5,0.00,0.00,'','479','2023-01-23 00:30:22','479',0,0),(2,7000,'',0,'20','1','310','SALES','','2023-01-23 00:30:35',5,0.00,0.00,'','479','2023-01-23 00:30:35','479',0,0),(3,500,'',0,'6.1','1','310','CASH','','2023-01-23 00:30:49',5,0.00,0.00,'','479','2023-01-23 00:30:49','479',0,0),(4,8000,'',0,'24','1','310','SALARIES & WAGES','','2023-01-23 00:31:09',5,0.00,0.00,'','479','2023-01-23 00:31:09','479',0,0),(5,8001,'',0,'24','1','310','PURCHASES','','2023-01-23 00:31:28',5,0.00,0.00,'','479','2023-01-23 00:31:28','479',0,0),(6,2500,'',0,'2','1','310','ZB(LPG)1014471475','','2023-01-23 00:32:05',5,0.00,0.00,'','479','2023-01-23 00:32:05','479',0,0),(7,2501,'',0,'2','1','310','ZNB E-BILL COLLECTION :1014717','','2023-01-23 00:32:19',5,0.00,0.00,'','479','2023-01-23 00:32:19','479',0,0),(8,2502,'',0,'2','1','310','ZNB-:POS 1015965368','','2023-01-23 00:32:31',5,0.00,0.00,'','479','2023-01-23 00:32:31','479',0,0),(9,2503,'',0,'2','1','310','FID POS COLLECTION-5620141491','','2023-01-23 00:33:04',5,0.00,0.00,'','479','2023-01-23 00:33:04','479',0,0),(10,2504,'',0,'2','1','310','FB(IBAL)2023855223','','2023-01-23 00:33:19',5,0.00,0.00,'','479','2023-01-23 00:33:19','479',0,0),(11,2505,'',0,'2','1','310','E-BILLS  IBAL 1015372548','','2023-01-23 00:33:37',5,0.00,0.00,'','479','2023-01-23 00:33:37','479',0,0),(12,2506,'',0,'2','1','310','E-BILLS 1015372548','','2023-01-23 00:33:50',5,0.00,0.00,'','479','2023-01-23 00:33:50','479',0,0),(13,2507,'',0,'2','1','310','UNITY BANK-0024061656','','2023-01-23 00:34:19',5,0.00,0.00,'','479','2023-01-23 00:34:19','479',0,0),(14,2508,'',0,'2','1','310','UBA-0039769388','','2023-01-23 00:34:29',5,0.00,0.00,'','479','2023-01-23 00:34:29','479',0,0),(15,2509,'',0,'2','1','310','UBA YOLA-1021398099','','2023-01-23 00:34:42',5,0.00,0.00,'','479','2023-01-23 00:34:42','479',0,0),(16,2510,'',0,'2','1','310','UBA-1019882661','','2023-01-23 00:35:15',5,0.00,0.00,'','479','2023-01-23 00:35:15','479',0,0),(17,2511,'',0,'2','1','310','DANKANO-EBILLS:ZNB1014717618','','2023-01-23 00:36:03',5,0.00,0.00,'','479','2023-01-23 00:36:03','479',0,0),(18,2512,'',0,'2','1','310','TAJJ BANK CITY GATE:0001875361','','2023-01-23 00:36:39',5,0.00,0.00,'','479','2023-01-23 00:36:39','479',0,0),(19,2513,'',0,'2','1','310','POLARIS BANK KEBBI:4091417377','','2023-01-23 00:36:53',5,0.00,0.00,'','479','2023-01-23 00:36:53','479',0,0),(20,2514,'',0,'2','1','310','FID POS COLL ACCT:-5620141491','FID POS COLLECTION ACCOUNT','2023-01-25 17:08:01',5,0.00,0.00,'','792','2023-01-25 17:08:01','792',0,0),(21,2515,'',0,'2','1','310','ZNB POS COLL ACCT:-1015965368','ZNB POS COLLECTION ACCOUNT','2023-01-25 17:09:35',5,0.00,0.00,'','792','2023-01-25 17:09:35','792',0,0),(22,2516,'',0,'2','1','310','UBA LPG COLL ACCT:-1020811140','UBA LPG COLLECTION ACCOUNT','2023-01-25 17:10:52',5,0.00,0.00,'','792','2023-01-25 17:10:52','792',0,0),(23,2517,'',0,'2','1','310','ZNB AA RANO NIG LTD:-101471761','ZNB AA RANO NIG LTD','2023-01-25 17:12:10',5,0.00,0.00,'','792','2023-01-25 17:12:10','792',0,0),(24,2518,'',0,'2','1','310','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:35:14',5,0.00,0.00,'','792','2023-02-20 14:35:14','792',0,0),(25,2519,'',0,'2','1','310','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:38:26',5,0.00,0.00,'2023-03-15','792','2023-03-17 13:53:28','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','310','ALBARKA GAS','AHMAD','09077002293','ahmadsg99@yahoo.com','KANO','KANO','HOTORO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-23 11:38:17',5,'1022','2023-01-23 11:38:17','1022'),(2,'','1','310','Akib Gas','Abubakar Adamu','08032147654','akibgas@gmail.com','Kano','Kano','Bunkure','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-26 07:20:54',5,'1022','2023-01-26 07:20:54','1022'),(3,'','1','310','JANWUYA GAS','MUHAMMAD','08039798759','akibgas@gmail.com','Kano','Kano','NAIBAWA YAN LEMON','Nigeria',1000.00,0.00,0.00,'0000-00-00','2023-01-27 11:12:21',5,'1022','2023-01-27 11:12:21','1022'),(4,'','1','310','UMAR GAS ','UMAR','08063533417','akibgas@gmail.com','Kano','Kano','DARMANAWA PRIMARY ','Nigeria',2000.00,0.00,0.00,'0000-00-00','2023-01-27 11:13:32',5,'1022','2023-01-27 11:13:32','1022'),(5,'','1','310','GABBY GAS','GABRIEL','09046638221','akibgas@gmail.com','Kano','Kano','ZARIA ROAD DAKA TSALLE','Nigeria',500.00,0.00,0.00,'0000-00-00','2023-01-27 15:24:25',5,'1022','2023-01-27 15:24:25','1022'),(6,'','1','310','IHSAN GAS NIG LTD','MUBARAK MOHD MUSA','08034368675','akibgas@gmail.com','Kano','Kano','TARAUNI ALONG MAIDUGURI ROAD KANO','Nigeria',2500.00,0.00,0.00,'0000-00-00','2023-01-27 15:27:09',5,'1022','2023-01-27 15:27:09','1022'),(7,'','1','310','UMAR GAS NAIBAWA','AMINU IDRIS','08030803959','akibgas@gmail.com','Kano','Kano','NAIBAWA','Nigeria',2000.00,0.00,0.00,'0000-00-00','2023-01-27 17:08:44',5,'1022','2023-01-27 17:08:44','1022'),(8,'','1','310','JMT GAS ','JAMILU MUHD TIGA','07061547110','akibgas@gmail.com','Kano','Kano','TIGA DAM','Nigeria',1000.00,0.00,0.00,'0000-00-00','2023-01-29 07:36:15',5,'1022','2023-01-29 07:36:15','1022'),(9,'','1','310','BABAN SUHAILA GAS','MUHD BASHIR HASSAN','08035558232','akibgas@gmail.com','Kano','Kano','ZARIA ROAD','Nigeria',500.00,0.00,0.00,'0000-00-00','2023-01-29 08:38:23',5,'1022','2023-01-29 08:38:23','1022'),(10,'','1','310','L G GAS','LAWAN HAMISU','08038450758','akibgas@gmail.com','Kano','Kano','HOTORO CBN QTRS ROAD TRN','Nigeria',1000.00,0.00,0.00,'0000-00-00','2023-01-29 11:07:32',5,'1022','2023-01-29 11:07:32','1022'),(11,'','1','310','SAYYADI  GAS LIMITED','SALISU ABUBAKAR','09027967332','akibgas@gmail.com','Kano','Kano','KURA','Nigeria',2000.00,0.00,0.00,'0000-00-00','2023-01-29 11:26:33',5,'1022','2023-01-29 11:26:33','1022'),(12,'','1','310','M.MAI KATI GAS','AUWAL','08169064409','akibgas@gmail.com','Kano','Kano','NAIBAWA DAN HASSAN','Nigeria',1000.00,0.00,0.00,'0000-00-00','2023-01-29 13:59:36',5,'1022','2023-01-29 13:59:36','1022'),(13,'','1','310','NASIRU GAS','NASIRU YUSIF','08036304619','akibgas@gmail.com','Kano','Kano','NAIBAWA  YAN LEMON OPP GIDAN KATE','Nigeria',2000.00,0.00,0.00,'0000-00-00','2023-01-29 17:28:18',5,'1022','2023-01-29 17:28:18','1022'),(14,'','1','310','OLATUDE GAS','OLATUNDE YEMI','08142641412','akibgas@gmail.com','Kano','Kano','SABON GARI','Nigeria',2000.00,0.00,0.00,'0000-00-00','2023-02-02 13:00:53',5,'1022','2023-02-02 13:09:18','1022'),(15,'','1','310','AHMED YUSUF','AHMAD GAS','08167933809','akibgas@gmail.com','Kano','Kano','YAN AWAKI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2023-02-02 13:12:29',5,'1022','2023-02-02 13:12:29','1022'),(16,'','1','310','SB BUNKURE GAS','MUHAMMAD','08081101554','akibgas@gmail.com','Kano','Kano','BUNKURE','Nigeria',1000.00,0.00,0.00,'0000-00-00','2023-02-02 13:13:22',5,'1022','2023-02-02 13:13:22','1022'),(17,'','1','310','safiya ibrahim','SHABRIK VENTURE','08067841431','akibgas@gmail.com','Kano','Kano','NAIBAWA NO 444 YAN AWAKI ','Nigeria',1000.00,0.00,0.00,'0000-00-00','2023-02-04 09:51:25',5,'1022','2023-02-04 09:51:25','1022'),(18,'','1','310','HABSAN DOT ENTEPRISE','UMAR ','07037142763 07058765716','akibgas@gmail.com','Kano','Kano','OP OPP 341 NAIBAWA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2023-02-04 17:34:37',5,'1022','2023-02-04 17:34:37','1022'),(19,'','1','310','DAN TSAKUWA','SANI','08130304932','akibgas@gmail.com','Kano','Kano','DAN TSAKUWA','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-02-05 11:21:34',5,'1022','2023-02-05 11:21:34','1022'),(20,'','1','310','R FADA','ABDULLAHI AHMAD','08131910364','akibgas@gmail.com','Kano','Kano','R FADA','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-02-05 11:22:41',5,'1022','2023-02-05 11:22:41','1022'),(21,'','1','310','ALIYU DOGUWA GAS','ALIYU DOGUWA','08034368675','akibgas@gmail.com','Kano','Kano','DOGUWA','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-02-05 11:37:58',5,'1022','2023-02-05 11:37:58','1022'),(22,'','1','310','KAMILU GAS','KAMILU JIBRIN','09077549770','kamilugas@gmail.com','KANO','KANO','KWANAR DAN GORA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-05 11:43:41',5,'1022','2023-02-05 11:43:41','1022'),(23,'','1','310','MEDICUS GAS','ABDULLAHI','08034368675','akibgas@gmail.com','Kano','Kano','CIVIC CENTTRE','Nigeria',200.00,0.00,0.00,'0000-00-00','2023-02-07 12:02:22',5,'1022','2023-02-07 12:02:22','1022'),(24,'','1','310','ELHAJ INDUSTRES','MUHAMA','08096994332','akibgas@gmail.com','kano','Kano','14 Calawa','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-07 12:06:20',5,'1022','2023-02-07 12:06:20','1022'),(25,'','1','310','MS RANO','ALKASIM SANI','07036435328','akibgas@gmail.com','Kano','Kano','RANO\r\n','Nigeria',250.00,0.00,0.00,'0000-00-00','2023-02-07 13:57:02',5,'1022','2023-02-07 13:57:02','1022'),(26,'','1','310','D.S GAS','PETER LOHNAN','08069542088','akibgas@gmail.com','Kano','Kano','YAN SHANA PRIMARY','Nigeria',2000.00,0.00,0.00,'0000-00-00','2023-02-08 09:48:21',5,'1022','2023-02-08 09:48:21','1022'),(27,'','1','310','NADADA A KURA','ABDULKADIR SALISU','08067421940','akibgas@gmail.com','Kano','Kano','KURA KOFAR YAMMA','Nigeria',150.00,0.00,0.00,'0000-00-00','2023-02-09 18:19:16',5,'1022','2023-02-09 18:19:16','1022'),(28,'','1','310','LAMIDO BROTHERS','ABDULLAHI','08036282603','akibgas@gmail.com','Kano','Kano','GYADI GYADI ZARIA ROAD','Nigeria',200.00,0.00,0.00,'0000-00-00','2023-02-09 18:20:23',5,'1022','2023-02-09 18:20:23','1022'),(29,'','1','310','CGS GAS','OGOCHUKWU','08065497313','akibgas@gmail.com','Kano','Kano','TARAUNI NEAR TRN PRIMARY SCHOOL','Nigeria',2000.00,0.00,0.00,'0000-00-00','2023-02-10 10:16:15',5,'1022','2023-02-10 10:17:39','1022'),(30,'','1','310','SHAVRIK VENTURES','SAFIYA IBRAHIM','08067841431','akibgas@gmail.com','Kano','Kano','NO 44 YARAKWA','Nigeria',200.00,0.00,0.00,'0000-00-00','2023-02-11 14:39:44',5,'1022','2023-02-11 14:44:01','1022'),(31,'','1','310','H R N COOKING GAS','SANI ADAM SANI','08141145565','akibgas@gmail.com','Kano','Kano','KURA BESIDE SANI MARSHALL','Nigeria',1000.00,0.00,0.00,'0000-00-00','2023-02-12 09:40:33',5,'1022','2023-02-12 09:40:33','1022'),(32,'','1','310','A S RATU GAS','ABUBAKAR','08083125991','akibgas@gmail.com','Kano','Kano','RANO','Nigeria',2000.00,0.00,0.00,'0000-00-00','2023-02-12 16:58:05',5,'1022','2023-02-12 16:58:05','1022'),(33,'','1','310','RYNUS','KABIRU RANO','07030182444','akibgas@gmail.com','Kano','Kano','RANO','Nigeria',1000.00,0.00,0.00,'0000-00-00','2023-02-12 18:26:18',5,'1022','2023-02-12 18:26:18','1022'),(34,'','1','310','US GLOBAL GAS',' US GLOBAL','08036669883','akibgas@gmail.com','RANO','Kano','BESIDE RANO POST OFFICE','Nigeria',500.00,0.00,0.00,'0000-00-00','2023-02-13 14:49:17',5,'1022','2023-02-13 14:49:17','1022'),(35,'','1','310','LAMIDO BROTHERS GAS','ABDULMUDALLAB ABDULLAHI','08036282603','lamidobrothers@gmail.com','KANO','KANO','ZARIA ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-14 18:20:30',5,'1022','2023-02-14 18:20:30','1022'),(36,'','1','310','MAI NASARA GAS','AA MAI NASARA','08038497665','akibgas@gmail.com','KANO','Kano','KANO','Nigeria',250.00,0.00,0.00,'0000-00-00','2023-02-15 10:02:50',5,'1022','2023-03-06 15:16:16','1022'),(37,'','1','310','NBJ   ANAS','ANAS','08062985100','akibgas@gmail.com','Kano','Kano','HOTORO  RAKTA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-15 16:21:40',5,'1022','2023-03-17 10:12:22','1022'),(38,'','1','310','NBJ  GAS','ANAS','08062985100','akibgas@gmail.com','Kano','Kano','HOTORO RAKAT','Nigeria',250.00,0.00,0.00,'0000-00-00','2023-02-15 16:23:53',5,'1022','2023-03-17 10:11:42','1022'),(39,'','1','310','SPEEDWAY  GAS','IMIRANA','08086610975','akibgas@gmail.com','Kano','Kano','YAR   AKWA','Nigeria',250.00,0.00,0.00,'0000-00-00','2023-02-15 16:45:12',5,'1022','2023-02-15 16:45:12','1022'),(40,'','1','310','A2 Riruwai Gas','Riruwai','0806986880','a2rdgw@gmail.com','Doguwa','Kano','Riruwai town','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-02-18 07:58:06',5,'1022','2023-02-18 07:58:06','1022'),(41,'','1','310','ALHAJI GAMS','GAMBO AUDU GARKO','08146466819','akibgas@gmail.com','Kano','Kano','RANO','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-02-20 07:59:43',5,'1022','2023-02-20 07:59:43','1022'),(42,'','1','310','B.A TUDUN WADA','ALIYU YAHAYA','09061900081','akibgas@gmail.com','Kano','Kano','TUDUN WADA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2023-02-20 12:16:43',5,'1022','2023-02-20 12:16:43','1022'),(43,'','1','310','OPERATIONAL LOSS','ABDULL','08120375333','ahmadsg99@yahoo.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-20 17:07:39',5,'1022','2023-02-20 17:07:39','1022'),(44,'','1','310','AB GAS','MUBARAK BARKUM','07061979396','akibgas@gmail.com','BUNKURE','Kano','BARKUM','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-02-21 12:38:57',5,'1022','2023-02-21 12:38:57','1022'),(45,'','1','310','RAHAMA VENTURES','MAGAJI','09074139132','akibgas@gmail.com','KANO','Kano','NAIBAWA LAYIN CHAIRMAN','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-02-21 12:40:18',5,'1022','2023-02-21 12:40:18','1022'),(46,'','1','310','DAWAKI GAS','MUHAMMAD LAMIM','07066738722','akibgas@gmail.com','KANO','Kano','DAWAKI','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-02-23 08:45:02',5,'1022','2023-02-23 08:45:02','1022'),(47,'','1','310','AL BARKA GAS','MUHAMMAD','08033363323','akibgas@gmail.com','Kano','Kano','KARKASARA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-23 13:25:23',5,'1022','2023-02-23 13:25:23','1022'),(48,'','1','310','BURINBURIN GAS','ABDULHADI','09019190600','akibgas@gmail.com','Kano','Kano','BURIN BURIN','Nigeria',1000.00,0.00,0.00,'0000-00-00','2023-02-24 09:25:17',5,'1022','2023-02-24 09:25:17','1022'),(49,'','1','310','AUWAL GAS','AUWAL','08066046854','akibgas@gmail.com','kano','Kano','AMADIYA','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-02-26 12:28:25',5,'1022','2023-02-26 12:28:25','1022'),(50,'','1','310','MUSUMED GAS','MUHD SULE','08065404877','akibgas@gmail.com','Kano','Kano','NAIBAWA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2023-03-02 08:59:50',5,'1022','2023-03-04 10:48:45','1022'),(51,'','1','310','UMAR ZAKARI GAS','UMAR ZAKARI GARBA','08024679363','akibgas@gmail.com','KANO','Kano','DARMANAWA PRIMARY','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-03-03 15:37:23',5,'1022','2023-03-03 15:37:23','1022'),(52,'','1','310','M H T GAS','MUSTAPHA HAMISU ','08069090525','akibgas@gmail.com','Kano','Kano','T WADA ','Nigeria',1000.00,0.00,0.00,'0000-00-00','2023-03-04 15:32:45',5,'1022','2023-03-04 15:32:45','1022'),(53,'','1','310','NORTHWEST GAS','LURWANU ALI','08066433019','akibgas@gmail.com','KANO','Kano','BABSA IMPOSSIBLE STREET KUNDILA','Nigeria',150.00,0.00,0.00,'0000-00-00','2023-03-05 14:14:22',5,'1022','2023-03-05 14:14:22','1022'),(54,'','1','310','BARNA GAS','IBRAHIM YUSUF','07014909999','akibgas@gmail.com','KANO','Kano','NAIBAWA','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-03-07 16:16:43',5,'1022','2023-03-07 16:16:43','1022'),(55,'','1','310','CITIZEN GAS','ABBAS SAIDU','09162695170','akibgas@gmail.com','Kano','Kano','GADAR TAMBURAWA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2023-03-12 08:59:38',5,'1022','2023-03-12 08:59:38','1022'),(56,'','1','310','BB GAS','UMAR G UMAR','08034336217','akibgas@gmail.com','KANO','Kano','NAIBAWA LAYIN DAN HASSAN','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-03-13 11:14:19',5,'1022','2023-03-13 11:14:19','1022'),(57,'','1','310','AS SUMAILA AND SONS','AMINU ABDULLAHI','08037141435','aminuabdullahisumaila@gmail.co','KANO','KANO','CBN ROAD','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-03-14 13:55:25',5,'1022','2023-03-14 13:55:25','1022'),(58,'','1','310','JAJA GAS','ABDULLAHI M ABUBAKAR','08066141138','abdullahmabkr@gmail.com','TUDUN WADA','KANO','TUDUN WADA LGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-16 15:47:46',5,'1022','2023-03-16 16:51:37','1022'),(59,'','1','310','WAILARI GAS','IMAM BAZALLAH ','08036477924','bazallah@gmail.com','KANO','KANO','NAIBAWA TSOHOWAR TASHA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-16 19:19:34',5,'1022','2023-03-16 19:19:34','1022');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','310','1',1,'5','LPG NOZZLE 1',690.84,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','310','1',2,'5','LPG NOZZLE 2',207.96,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','310','1',3,'5','LPG NOZZLE 3',19245.91,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','310','1',4,'5','LPG NOZZLE 4',18030.81,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','310','1',5,'5','LPG NOZZLE 5',24726.10,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','310','1',6,'5','LPG NOZZLE 6',19718.94,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','310','1',7,'5','LPG NOZZLE 7',10820.38,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','310',1,'DAILY SHIFT','2023-01-23','2023-01-23 11:24:42','2023-01-24 11:24:42','1022',0.00,0.00,'1022','2023-01-23 11:40:46','1022','2023-01-23 11:41:20',10,0),('1','310',2,'DAILY SHIFT','2023-01-20','2023-01-23 11:45:11','2023-01-24 11:45:11','1022',0.00,0.00,'1022','2023-01-23 11:50:40','1022','2023-01-23 11:50:54',10,0),('1','310',3,'DAILY SHIFT','2023-01-23','2023-01-23 11:51:36','2023-01-24 11:51:36','1022',0.00,0.00,'1022','2023-01-23 11:52:42','1022','2023-01-23 11:52:58',10,0),('1','310',4,'DAILY SHIFT','2023-01-21','2023-01-23 11:53:42','2023-01-24 11:53:42','1022',0.00,0.00,'1022','2023-01-23 11:57:16','1022','2023-01-23 11:57:36',10,0),('1','310',5,'DAILY SHIFT','2023-01-22','2023-01-23 11:58:10','2023-01-24 11:58:10','1022',0.00,0.00,'1022','2023-01-23 12:02:47','1022','2023-01-23 12:03:01',10,0),('1','310',6,'DAILY SHIFT','2023-01-23','2023-01-23 12:05:59','2023-01-24 12:05:59','1022',0.00,0.00,'1022','2023-01-23 19:21:10','1022','2023-01-23 19:21:23',10,0),('1','310',7,'DAILY SHIFT','2023-01-24','2023-01-24 07:17:03','2023-01-25 07:17:03','1022',0.00,0.00,'1022','2023-01-24 19:31:16','1022','2023-01-24 19:31:31',10,0),('1','310',8,'DAILY SHIFT','2023-01-25','2023-01-25 07:19:23','2023-01-26 07:19:23','1022',0.00,0.00,'1022','2023-01-25 18:45:26','1022','2023-01-25 18:45:39',10,0),('1','310',9,'DAILY SHIFT','2023-01-26','2023-01-26 07:18:30','2023-01-27 07:18:30','1022',0.00,0.00,'1022','2023-01-26 19:06:10','1022','2023-01-26 19:06:51',10,0),('1','310',10,'DAILY SHIFT','2023-01-27','2023-01-27 07:10:41','2023-01-28 07:10:41','1022',0.00,0.00,'1022','2023-01-27 19:08:48','1022','2023-01-27 19:09:06',10,0),('1','310',11,'DAILY SHIFT','2023-01-28','2023-01-28 07:00:04','2023-01-29 07:00:04','1022',0.00,0.00,'1022','2023-01-28 19:34:45','1022','2023-01-28 19:35:01',10,0),('1','310',12,'DAILY SHIFT','2023-01-29','2023-01-29 07:15:48','2023-01-30 07:15:48','1022',0.00,0.00,'1022','2023-01-29 18:50:40','1022','2023-01-29 18:50:54',10,0),('1','310',13,'DAILY SHIFT','2023-01-30','2023-01-30 07:07:02','2023-01-31 07:07:02','1022',0.00,0.00,'1022','2023-01-30 19:16:45','1022','2023-01-30 19:17:02',10,0),('1','310',14,'DAILY SHIFT','2023-01-31','2023-01-31 07:11:18','2023-02-01 07:11:18','1022',0.00,0.00,'1022','2023-01-31 19:16:08','1022','2023-01-31 19:16:24',10,0),('1','310',15,'DAILY SHIFT','2023-02-01','2023-02-01 07:16:27','2023-02-02 07:16:27','1022',0.00,0.00,'1022','2023-02-01 20:07:00','1022','2023-02-01 20:07:23',10,0),('1','310',16,'DAILY SHIFT','2023-02-02','2023-02-02 07:04:22','2023-02-03 07:04:22','1022',0.00,0.00,'1022','2023-02-02 20:01:12','1022','2023-02-02 20:01:32',10,0),('1','310',17,'DAILY SHIFT','2023-02-03','2023-02-03 07:06:27','2023-02-04 07:06:27','1022',0.00,0.00,'1022','2023-02-03 19:24:07','1022','2023-02-03 19:24:30',10,0),('1','310',18,'DAILY SHIFT','2023-02-04','2023-02-04 07:04:32','2023-02-05 07:04:32','1022',0.00,0.00,'1022','2023-02-04 19:22:57','1022','2023-02-04 19:23:20',10,0),('1','310',19,'DAILY SHIFT','2023-02-05','2023-02-05 07:04:23','2023-02-06 07:04:23','1022',0.00,0.00,'1022','2023-02-05 19:44:17','1022','2023-02-05 19:44:36',10,0),('1','310',20,'DAILY SHIFT','2023-02-06','2023-02-06 07:20:38','2023-02-07 07:20:38','1022',0.00,0.00,'1022','2023-02-06 19:44:53','1022','2023-02-06 19:45:07',10,0),('1','310',21,'DAILY SHIFT','2023-02-07','2023-02-07 07:10:32','2023-02-08 07:10:32','1022',0.00,0.00,'1022','2023-02-07 20:49:12','1022','2023-02-07 20:49:30',10,0),('1','310',22,'DAILY SHIFT','2023-02-08','2023-02-08 07:13:33','2023-02-09 07:13:33','1022',0.00,0.00,'1022','2023-02-08 19:39:45','1022','2023-02-08 19:40:03',10,0),('1','310',23,'DAILY SHIFT','2023-02-09','2023-02-09 07:02:40','2023-02-10 07:02:40','1022',0.00,0.00,'1022','2023-02-09 19:34:49','1022','2023-02-09 19:35:08',10,0),('1','310',24,'DAILY SHIFT','2023-02-10','2023-02-10 07:43:43','2023-02-11 07:43:43','1022',0.00,0.00,'1022','2023-02-10 19:25:35','1022','2023-02-10 19:25:51',10,0),('1','310',25,'DAILY SHIFT','2023-02-11','2023-02-11 07:06:31','2023-02-12 07:06:31','1022',0.00,0.00,'1022','2023-02-11 19:47:52','1022','2023-02-11 19:48:06',10,0),('1','310',26,'DAILY SHIFT','2023-02-12','2023-02-12 07:04:18','2023-02-13 07:04:18','1022',0.00,0.00,'1022','2023-02-12 19:14:41','1022','2023-02-12 19:14:58',10,0),('1','310',27,'DAILY SHIFT','2023-02-13','2023-02-13 07:21:19','2023-02-14 07:21:19','1022',0.00,0.00,'1022','2023-02-13 19:33:00','1022','2023-02-13 19:33:32',10,0),('1','310',28,'DAILY SHIFT','2023-02-14','2023-02-14 07:04:07','2023-02-15 07:04:07','1022',0.00,0.00,'1022','2023-02-14 19:48:00','1022','2023-02-14 19:48:15',10,0),('1','310',29,'DAILY SHIFT','2023-02-15','2023-02-15 08:13:40','2023-02-16 08:13:40','1022',0.00,0.00,'1022','2023-02-15 19:28:08','1022','2023-02-15 19:28:21',10,0),('1','310',30,'DAILY SHIFT','2023-02-16','2023-02-16 07:03:48','2023-02-17 07:03:48','1022',0.00,0.00,'1022','2023-02-16 19:34:01','1022','2023-02-16 19:34:23',10,0),('1','310',31,'DAILY SHIFT','2023-02-17','2023-02-17 07:12:50','2023-02-18 07:12:50','1022',0.00,0.00,'1022','2023-02-17 19:49:05','1022','2023-02-17 19:49:47',10,0),('1','310',32,'DAILY SHIFT','2023-02-18','2023-02-18 07:00:23','2023-02-19 07:00:23','1022',0.00,0.00,'1022','2023-02-18 20:44:27','1022','2023-02-18 20:45:00',10,0),('1','310',33,'DAILY SHIFT','2023-02-19','2023-02-19 07:01:32','2023-02-20 07:01:32','1022',0.00,0.00,'1022','2023-02-19 19:19:46','1022','2023-02-19 19:20:06',10,0),('1','310',34,'DAILY SHIFT','2023-02-20','2023-02-20 06:55:04','2023-02-21 06:55:04','1022',0.00,0.00,'1022','2023-02-20 14:52:00','1022','2023-02-20 15:50:30',10,0),('1','310',35,'DAILY SHIFT','2023-02-20','2023-02-20 17:06:03','2023-02-21 17:06:03','1022',0.00,0.00,'1022','2023-02-20 17:48:20','1022','2023-02-20 17:48:35',10,0),('1','310',36,'DAILY SHIFT','2023-02-20','2023-02-20 17:48:58','2023-02-21 17:48:58','1022',0.00,0.00,'1022','2023-02-20 19:36:00','1022','2023-02-20 19:36:19',10,0),('1','310',37,'DAILY SHIFT','2023-02-21','2023-02-21 07:19:55','2023-02-22 07:19:55','1022',0.00,0.00,'1022','2023-02-21 20:09:42','1022','2023-02-21 20:10:28',10,0),('1','310',38,'DAILY SHIFT','2023-02-22','2023-02-22 07:01:39','2023-02-23 07:01:39','1022',0.00,0.00,'1022','2023-02-22 21:01:59','1022','2023-02-22 21:02:26',10,0),('1','310',39,'DAILY SHIFT','2023-02-23','2023-02-23 07:03:13','2023-02-24 07:03:13','1022',0.00,0.00,'1022','2023-02-23 19:52:09','1022','2023-02-23 19:52:27',10,0),('1','310',40,'DAILY SHIFT','2023-02-24','2023-02-24 07:03:05','2023-02-25 07:03:05','1022',0.00,0.00,'1022','2023-02-24 23:00:38','1022','2023-02-24 23:00:58',10,0),('1','310',41,'DAILY SHIFT','2023-02-26','2023-02-26 07:53:36','2023-02-27 07:53:36','1022',0.00,0.00,'1022','2023-02-26 19:21:27','1022','2023-02-26 19:21:47',10,0),('1','310',42,'DAILY SHIFT','2023-02-27','2023-02-27 07:04:43','2023-02-28 07:04:43','1022',0.00,0.00,'1022','2023-02-27 18:56:30','1022','2023-02-27 18:56:44',10,0),('1','310',43,'DAILY SHIFT','2023-02-28','2023-02-28 07:07:56','2023-03-01 07:07:56','1022',0.00,0.00,'1022','2023-02-28 19:06:56','1022','2023-02-28 19:07:25',10,0),('1','310',44,'DAILY SHIFT','2023-03-01','2023-03-01 07:04:34','2023-03-02 07:04:34','1022',0.00,0.00,'1022','2023-03-01 18:51:05','1022','2023-03-01 18:51:25',10,0),('1','310',45,'DAILY SHIFT','2023-03-02','2023-03-02 07:16:30','2023-03-03 07:16:30','1022',0.00,0.00,'1022','2023-03-02 19:12:42','1022','2023-03-02 19:12:56',10,0),('1','310',46,'DAILY SHIFT','2023-03-03','2023-03-03 07:32:50','2023-03-04 07:32:50','1022',0.00,0.00,'1022','2023-03-03 19:30:11','1022','2023-03-03 19:30:26',10,0),('1','310',47,'DAILY SHIFT','2023-03-04','2023-03-04 06:54:14','2023-03-05 06:54:14','1022',0.00,0.00,'1022','2023-03-04 20:02:29','1022','2023-03-04 20:02:49',10,0),('1','310',48,'DAILY SHIFT','2023-03-05','2023-03-05 07:20:48','2023-03-06 07:20:48','1022',0.00,0.00,'1022','2023-03-05 20:14:38','1022','2023-03-05 20:15:13',10,0),('1','310',49,'DAILY SHIFT','2023-03-06','2023-03-06 07:36:29','2023-03-07 07:36:29','1022',0.00,0.00,'1022','2023-03-06 19:40:18','1022','2023-03-06 19:40:42',10,0),('1','310',50,'DAILY SHIFT','2023-03-07','2023-03-07 06:57:28','2023-03-08 06:57:28','1022',0.00,0.00,'1022','2023-03-07 20:57:08','1022','2023-03-07 20:57:22',10,0),('1','310',51,'DAILY SHIFT','2023-03-08','2023-03-08 06:57:03','2023-03-09 06:57:03','1022',0.00,0.00,'1022','2023-03-08 20:00:12','1022','2023-03-08 20:00:38',10,0),('1','310',52,'DAILY SHIFT','2023-03-09','2023-03-09 07:15:51','2023-03-10 07:15:51','1022',0.00,0.00,'1022','2023-03-09 19:46:56','1022','2023-03-09 19:47:11',10,0),('1','310',53,'DAILY SHIFT','2023-03-10','2023-03-10 06:59:17','2023-03-11 06:59:17','1022',0.00,0.00,'1022','2023-03-11 07:04:15','1022','2023-03-11 07:04:59',10,0),('1','310',54,'DAILY SHIFT','2023-03-11','2023-03-11 07:05:25','2023-03-12 07:05:25','1022',0.00,0.00,'1022','2023-03-11 19:30:05','1022','2023-03-11 19:30:53',10,0),('1','310',55,'DAILY SHIFT','2023-03-12','2023-03-12 07:16:11','2023-03-13 07:16:11','1022',0.00,0.00,'1022','2023-03-12 20:04:24','1022','2023-03-12 20:05:12',10,0),('1','310',56,'DAILY SHIFT','2023-03-13','2023-03-13 07:20:24','2023-03-14 07:20:24','1022',0.00,0.00,'1022','2023-03-13 19:41:11','1022','2023-03-13 19:41:24',10,0),('1','310',57,'DAILY SHIFT','2023-03-14','2023-03-14 07:05:19','2023-03-15 07:05:19','1022',0.00,0.00,'1022','2023-03-14 19:51:55','1022','2023-03-14 19:52:14',10,0),('1','310',58,'DAILY SHIFT','2023-03-15','2023-03-15 07:00:44','2023-03-16 07:00:44','1022',0.00,0.00,'1022','2023-03-15 19:44:13','1022','2023-03-15 19:44:30',10,0),('1','310',59,'DAILY SHIFT','2023-03-16','2023-03-16 07:01:59','2023-03-17 07:01:59','1022',0.00,0.00,'1022','2023-03-16 19:56:18','1022','2023-03-16 19:56:44',10,0),('1','310',60,'DAILY SHIFT','2023-03-17','2023-03-17 07:03:56','2023-03-18 07:03:56','1022',0.00,0.00,'1022','2023-03-17 21:09:20','1022','2023-03-17 21:09:44',10,0),('1','310',61,'DAILY SHIFT','2023-03-19','2023-03-19 06:53:26','2023-03-20 06:53:26','1022',0.00,0.00,'1022','2023-03-19 19:05:37','1022','2023-03-19 19:05:54',10,0),('1','310',62,'DAILY SHIFT','2023-03-20','2023-03-20 07:03:11','2023-03-21 07:03:11','1022',0.00,0.00,'1022','2023-03-20 10:10:16','1022','2023-03-20 10:10:31',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=435 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','310','1','1',1,'1','1',0.00,46.46,0.00,0.00,46.46,33451.20,0.00,0.00,0.00),('1','310','1','1',2,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','1',3,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','1',4,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','1',5,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','1',6,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','1',7,'7','1',0.00,433.89,0.00,0.00,433.89,303723.00,0.00,0.00,0.00),('1','310','1','2',8,'1','1',46.46,194.39,0.00,0.00,147.93,106509.60,0.00,0.00,0.00),('1','310','1','2',9,'2','1',0.00,94.40,0.00,0.00,94.40,67968.00,0.00,0.00,0.00),('1','310','1','2',10,'3','1',0.00,3.06,0.00,0.00,3.06,2203.20,0.00,0.00,0.00),('1','310','1','2',11,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','2',12,'5','1',0.00,567.00,0.00,0.00,567.00,396900.00,0.00,0.00,0.00),('1','310','1','2',13,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','2',14,'7','1',433.89,433.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','3',15,'1','1',194.39,194.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','3',16,'2','1',94.40,94.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','3',17,'3','1',3.06,3.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','3',18,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','3',19,'5','1',567.00,567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','3',20,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','3',21,'7','1',433.89,433.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','4',22,'1','1',194.39,424.51,0.00,0.00,230.12,165686.40,0.00,0.00,0.00),('1','310','1','4',23,'2','1',94.40,194.25,0.00,0.00,99.85,71892.00,0.00,0.00,0.00),('1','310','1','4',24,'3','1',3.06,3.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','4',25,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','4',26,'5','1',567.00,567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','4',27,'6','1',0.00,619.29,0.00,0.00,619.29,433503.00,0.00,0.00,0.00),('1','310','1','4',28,'7','1',433.89,433.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','5',29,'1','1',424.51,424.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','5',30,'2','1',194.25,194.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','5',31,'3','1',3.06,3.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','5',32,'4','1',0.00,529.45,0.00,0.00,529.45,381204.00,0.00,0.00,0.00),('1','310','1','5',33,'5','1',567.00,1807.50,0.00,0.00,1240.50,868350.00,0.00,0.00,0.00),('1','310','1','5',34,'6','1',619.29,619.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','5',35,'7','1',433.89,433.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','6',36,'1','1',424.51,563.50,0.00,0.00,138.99,100072.80,0.00,0.00,0.00),('1','310','1','6',37,'2','1',194.25,197.03,0.00,0.00,2.78,2001.60,0.00,0.00,0.00),('1','310','1','6',38,'3','1',3.06,77.95,0.00,0.00,74.89,53920.80,0.00,0.00,0.00),('1','310','1','6',39,'4','1',529.45,662.09,0.00,0.00,132.64,95500.80,0.00,0.00,0.00),('1','310','1','6',40,'5','1',1807.50,1983.00,0.00,0.00,175.50,122850.00,0.00,0.00,0.00),('1','310','1','6',41,'6','1',619.29,719.29,0.00,0.00,100.00,70000.00,0.00,0.00,0.00),('1','310','1','6',42,'7','1',433.89,671.39,0.00,0.00,237.50,166250.00,0.00,0.00,0.00),('1','310','1','7',43,'1','1',563.50,563.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','7',44,'2','1',197.03,197.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','7',45,'3','1',77.95,241.27,0.00,0.00,163.32,117590.40,0.00,0.00,0.00),('1','310','1','7',46,'4','1',662.09,1006.92,0.00,0.00,344.83,246277.60,0.00,0.00,0.00),('1','310','1','7',47,'5','1',1983.00,2207.86,0.00,0.00,224.86,157402.00,0.00,0.00,0.00),('1','310','1','7',48,'6','1',719.29,1327.75,0.00,0.00,608.46,425922.00,0.00,0.00,0.00),('1','310','1','7',49,'7','1',671.39,671.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','8',50,'1','1',563.50,563.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','8',51,'2','1',197.03,201.96,0.00,0.00,4.93,3549.60,0.00,0.00,0.00),('1','310','1','8',52,'3','1',241.27,527.83,0.00,0.00,286.56,206323.20,0.00,0.00,0.00),('1','310','1','8',53,'4','1',1006.92,1308.68,0.00,0.00,301.76,217267.20,0.00,0.00,0.00),('1','310','1','8',54,'5','1',2207.86,2357.86,0.00,0.00,150.00,105000.00,0.00,0.00,0.00),('1','310','1','8',55,'6','1',1327.75,1712.75,0.00,0.00,385.00,269500.00,0.00,0.00,0.00),('1','310','1','8',56,'7','1',671.39,896.39,0.00,0.00,225.00,157500.00,0.00,0.00,0.00),('1','310','1','9',57,'1','1',563.50,564.89,0.00,0.00,1.39,1000.80,0.00,0.00,0.00),('1','310','1','9',58,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','9',59,'3','1',527.83,736.00,0.00,0.00,208.17,149882.40,0.00,0.00,0.00),('1','310','1','9',60,'4','1',1308.68,1478.48,0.00,0.00,169.80,122256.00,0.00,0.00,0.00),('1','310','1','9',61,'5','1',2357.86,2507.86,0.00,0.00,150.00,105000.00,0.00,0.00,0.00),('1','310','1','9',62,'6','1',1712.75,2022.75,0.00,0.00,310.00,217000.00,0.00,0.00,0.00),('1','310','1','9',63,'7','1',896.39,1116.39,0.00,0.00,220.00,154000.00,0.00,0.00,0.00),('1','310','1','10',64,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','10',65,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','10',66,'3','1',736.00,883.73,0.00,0.00,147.73,106365.60,0.00,0.00,0.00),('1','310','1','10',67,'4','1',1478.48,1714.57,0.00,0.00,236.09,169984.80,0.00,0.00,0.00),('1','310','1','10',68,'5','1',2507.86,3274.86,0.00,0.00,767.00,536900.00,0.00,0.00,0.00),('1','310','1','10',69,'6','1',2022.75,2626.73,0.00,0.00,603.98,422786.00,0.00,0.00,0.00),('1','310','1','10',70,'7','1',1116.39,1493.82,0.00,0.00,377.43,264201.00,0.00,0.00,0.00),('1','310','1','11',71,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','11',72,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','11',73,'3','1',883.73,1119.80,0.00,0.00,236.07,169970.40,0.00,0.00,0.00),('1','310','1','11',74,'4','1',1714.57,1921.42,0.00,0.00,206.85,148932.00,0.00,0.00,0.00),('1','310','1','11',75,'5','1',3274.86,3533.86,0.00,0.00,259.00,181300.00,0.00,0.00,0.00),('1','310','1','11',76,'6','1',2626.73,3005.73,0.00,0.00,379.00,265300.00,0.00,0.00,0.00),('1','310','1','11',77,'7','1',1493.82,1888.82,0.00,0.00,395.00,276500.00,0.00,0.00,0.00),('1','310','1','12',78,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','12',79,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','12',80,'3','1',1119.80,1339.28,0.00,0.00,219.48,158025.60,0.00,0.00,0.00),('1','310','1','12',81,'4','1',1921.42,2149.77,0.00,0.00,228.35,164412.00,0.00,0.00,0.00),('1','310','1','12',82,'5','1',3533.86,3805.36,0.00,0.00,271.50,190050.00,0.00,0.00,0.00),('1','310','1','12',83,'6','1',3005.73,3260.73,0.00,0.00,255.00,178500.00,0.00,0.00,0.00),('1','310','1','12',84,'7','1',1888.82,1938.82,0.00,0.00,50.00,35000.00,0.00,0.00,0.00),('1','310','1','13',85,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','13',86,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','13',87,'3','1',1339.28,1533.35,0.00,0.00,194.07,139730.40,0.00,0.00,0.00),('1','310','1','13',88,'4','1',2149.77,2299.31,0.00,0.00,149.54,107668.80,0.00,0.00,0.00),('1','310','1','13',89,'5','1',3805.36,3910.36,0.00,0.00,105.00,73500.00,0.00,0.00,0.00),('1','310','1','13',90,'6','1',3260.73,3490.24,0.00,0.00,229.51,160657.00,0.00,0.00,0.00),('1','310','1','13',91,'7','1',1938.82,2253.82,0.00,0.00,315.00,220500.00,0.00,0.00,0.00),('1','310','1','14',92,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','14',93,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','14',94,'3','1',1533.35,1874.96,0.00,0.00,341.61,245959.20,0.00,0.00,0.00),('1','310','1','14',95,'4','1',2299.31,2606.97,0.00,0.00,307.66,221515.20,0.00,0.00,0.00),('1','310','1','14',96,'5','1',3910.36,4060.36,0.00,0.00,150.00,105000.00,0.00,0.00,0.00),('1','310','1','14',97,'6','1',3490.24,3627.30,0.00,0.00,137.06,95942.00,0.00,0.00,0.00),('1','310','1','14',98,'7','1',2253.82,2253.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','15',99,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','15',100,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','15',101,'3','1',1874.96,2217.38,0.00,0.00,342.42,246542.40,0.00,0.00,0.00),('1','310','1','15',102,'4','1',2606.97,2850.32,0.00,0.00,243.35,175212.00,0.00,0.00,0.00),('1','310','1','15',103,'5','1',4060.36,4072.36,0.00,0.00,12.00,8400.00,0.00,0.00,0.00),('1','310','1','15',104,'6','1',3627.30,3705.55,0.00,0.00,78.25,54775.00,0.00,0.00,0.00),('1','310','1','15',105,'7','1',2253.82,2282.39,0.00,0.00,28.57,19999.00,0.00,0.00,0.00),('1','310','1','16',106,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','16',107,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','16',108,'3','1',2217.38,2598.44,0.00,0.00,381.06,274363.20,0.00,0.00,0.00),('1','310','1','16',109,'4','1',2850.32,3245.50,0.00,0.00,395.18,284529.60,0.00,0.00,0.00),('1','310','1','16',110,'5','1',4072.36,4311.73,0.00,0.00,239.37,167559.00,0.00,0.00,0.00),('1','310','1','16',111,'6','1',3705.55,4122.26,0.00,0.00,416.71,291697.00,0.00,0.00,0.00),('1','310','1','16',112,'7','1',2282.39,2404.67,0.00,0.00,122.28,85596.00,0.00,0.00,0.00),('1','310','1','17',113,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','17',114,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','17',115,'3','1',2598.44,2842.21,0.00,0.00,243.77,175514.40,0.00,0.00,0.00),('1','310','1','17',116,'4','1',3245.50,3524.24,0.00,0.00,278.74,200692.80,0.00,0.00,0.00),('1','310','1','17',117,'5','1',4311.73,4436.73,0.00,0.00,125.00,87500.00,0.00,0.00,0.00),('1','310','1','17',118,'6','1',4122.26,4239.90,0.00,0.00,117.64,82348.00,0.00,0.00,0.00),('1','310','1','17',119,'7','1',2404.67,2515.28,0.00,0.00,110.61,77427.00,0.00,0.00,0.00),('1','310','1','18',120,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','18',121,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','18',122,'3','1',2842.21,3062.94,0.00,0.00,220.73,158925.60,0.00,0.00,0.00),('1','310','1','18',123,'4','1',3524.24,3809.59,0.00,0.00,285.35,205452.00,0.00,0.00,0.00),('1','310','1','18',124,'5','1',4436.73,4595.73,0.00,0.00,159.00,111300.00,0.00,0.00,0.00),('1','310','1','18',125,'6','1',4239.90,4724.12,0.00,0.00,484.22,338954.00,0.00,0.00,0.00),('1','310','1','18',126,'7','1',2515.28,2515.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','19',127,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','19',128,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','19',129,'3','1',3062.94,3518.51,0.00,0.00,455.57,328010.40,0.00,0.00,0.00),('1','310','1','19',130,'4','1',3809.59,4267.82,0.00,0.00,458.23,329925.60,0.00,0.00,0.00),('1','310','1','19',131,'5','1',4595.73,4838.58,0.00,0.00,242.85,169995.00,0.00,0.00,0.00),('1','310','1','19',132,'6','1',4724.12,5214.98,0.00,0.00,490.86,343722.00,0.00,0.00,0.00),('1','310','1','19',133,'7','1',2515.28,2864.57,0.00,0.00,349.29,244503.00,0.00,0.00,0.00),('1','310','1','20',134,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','20',135,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','20',136,'3','1',3518.51,3896.93,0.00,0.00,378.42,272462.40,0.00,0.00,0.00),('1','310','1','20',137,'4','1',4267.82,4545.67,0.00,0.00,277.85,200052.00,0.00,0.00,0.00),('1','310','1','20',138,'5','1',4838.58,5543.58,0.00,0.00,705.00,493500.00,0.00,0.00,0.00),('1','310','1','20',139,'6','1',5214.98,6205.97,0.00,0.00,990.99,693693.00,0.00,0.00,0.00),('1','310','1','20',140,'7','1',2864.57,2906.54,0.00,0.00,41.97,29379.00,0.00,0.00,0.00),('1','310','1','21',141,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','21',142,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','21',143,'3','1',3896.93,4377.92,0.00,0.00,480.99,346312.80,0.00,0.00,0.00),('1','310','1','21',144,'4','1',4545.67,4910.55,0.00,0.00,364.88,262713.60,0.00,0.00,0.00),('1','310','1','21',145,'5','1',5543.58,6019.58,0.00,0.00,476.00,333200.00,0.00,0.00,0.00),('1','310','1','21',146,'6','1',6205.97,6734.47,0.00,0.00,528.50,370070.00,0.00,0.00,0.00),('1','310','1','21',147,'7','1',2906.54,3294.61,0.00,0.00,388.07,271649.00,0.00,0.00,0.00),('1','310','1','22',148,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','22',149,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','22',150,'3','1',4377.92,4696.98,0.00,0.00,319.06,229723.20,0.00,0.00,0.00),('1','310','1','22',151,'4','1',4910.55,5137.15,0.00,0.00,226.60,163152.00,0.00,0.00,0.00),('1','310','1','22',152,'5','1',6019.58,6629.58,0.00,0.00,610.00,427000.00,0.00,0.00,0.00),('1','310','1','22',153,'6','1',6734.47,7181.33,0.00,0.00,446.86,312802.00,0.00,0.00,0.00),('1','310','1','22',154,'7','1',3294.61,3306.61,0.00,0.00,12.00,8400.00,0.00,0.00,0.00),('1','310','1','23',155,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','23',156,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','23',157,'3','1',4696.98,4938.14,0.00,0.00,241.16,173635.20,0.00,0.00,0.00),('1','310','1','23',158,'4','1',5137.15,5465.62,0.00,0.00,328.47,236498.40,0.00,0.00,0.00),('1','310','1','23',159,'5','1',6629.58,6904.58,0.00,0.00,275.00,192500.00,0.00,0.00,0.00),('1','310','1','23',160,'6','1',7181.33,7567.83,0.00,0.00,386.50,270550.00,0.00,0.00,0.00),('1','310','1','23',161,'7','1',3306.61,3764.61,0.00,0.00,458.00,320600.00,0.00,0.00,0.00),('1','310','1','24',162,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','24',163,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','24',164,'3','1',4938.14,5233.35,0.00,0.00,295.21,212551.20,0.00,0.00,0.00),('1','310','1','24',165,'4','1',5465.62,5699.29,0.00,0.00,233.67,168242.40,0.00,0.00,0.00),('1','310','1','24',166,'5','1',6904.58,7157.58,0.00,0.00,253.00,177100.00,0.00,0.00,0.00),('1','310','1','24',167,'6','1',7567.83,7846.33,0.00,0.00,278.50,194950.00,0.00,0.00,0.00),('1','310','1','24',168,'7','1',3764.61,3768.90,0.00,0.00,4.29,3003.00,0.00,0.00,0.00),('1','310','1','25',169,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','25',170,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','25',171,'3','1',5233.35,5691.34,0.00,0.00,457.99,329752.80,0.00,0.00,0.00),('1','310','1','25',172,'4','1',5699.29,6064.65,0.00,0.00,365.36,263059.20,0.00,0.00,0.00),('1','310','1','25',173,'5','1',7157.58,7573.58,0.00,0.00,416.00,291200.00,0.00,0.00,0.00),('1','310','1','25',174,'6','1',7846.33,8721.04,0.00,0.00,874.71,612297.00,0.00,0.00,0.00),('1','310','1','25',175,'7','1',3768.90,3972.12,0.00,0.00,203.22,142254.00,0.00,0.00,0.00),('1','310','1','26',176,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','26',177,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','26',178,'3','1',5691.34,6128.54,0.00,0.00,437.20,314784.00,0.00,0.00,0.00),('1','310','1','26',179,'4','1',6064.65,6365.80,0.00,0.00,301.15,216828.00,0.00,0.00,0.00),('1','310','1','26',180,'5','1',7573.58,7820.29,0.00,0.00,246.71,172697.00,0.00,0.00,0.00),('1','310','1','26',181,'6','1',8721.04,9415.04,0.00,0.00,694.00,485800.00,0.00,0.00,0.00),('1','310','1','26',182,'7','1',3972.12,4325.13,0.00,0.00,353.01,247107.00,0.00,0.00,0.00),('1','310','1','27',183,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','27',184,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','27',185,'3','1',6128.54,6324.84,0.00,0.00,196.30,141336.00,0.00,0.00,0.00),('1','310','1','27',186,'4','1',6365.80,6535.88,0.00,0.00,170.08,122457.60,0.00,0.00,0.00),('1','310','1','27',187,'5','1',7820.29,8117.79,0.00,0.00,297.50,208250.00,0.00,0.00,0.00),('1','310','1','27',188,'6','1',9415.04,9828.04,0.00,0.00,413.00,289100.00,0.00,0.00,0.00),('1','310','1','27',189,'7','1',4325.13,4706.42,0.00,0.00,381.29,266903.00,0.00,0.00,0.00),('1','310','1','28',190,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','28',191,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','28',192,'3','1',6324.84,6724.28,0.00,0.00,399.44,287596.80,0.00,0.00,0.00),('1','310','1','28',193,'4','1',6535.88,6720.39,0.00,0.00,184.51,132847.20,0.00,0.00,0.00),('1','310','1','28',194,'5','1',8117.79,8586.79,0.00,0.00,469.00,328300.00,0.00,0.00,0.00),('1','310','1','28',195,'6','1',9828.04,10070.54,0.00,0.00,242.50,169750.00,0.00,0.00,0.00),('1','310','1','28',196,'7','1',4706.42,4706.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','29',197,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','29',198,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','29',199,'3','1',6724.28,7000.28,0.00,0.00,276.00,198720.00,0.00,0.00,0.00),('1','310','1','29',200,'4','1',6720.39,6964.74,0.00,0.00,244.35,175932.00,0.00,0.00,0.00),('1','310','1','29',201,'5','1',8586.79,9280.29,0.00,0.00,693.50,485450.00,0.00,0.00,0.00),('1','310','1','29',202,'6','1',10070.54,10984.04,0.00,0.00,913.50,639450.00,0.00,0.00,0.00),('1','310','1','29',203,'7','1',4706.42,4956.42,0.00,0.00,250.00,175000.00,0.00,0.00,0.00),('1','310','1','30',204,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','30',205,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','30',206,'3','1',7000.28,7316.99,0.00,0.00,316.71,228031.20,0.00,0.00,0.00),('1','310','1','30',207,'4','1',6964.74,7150.13,0.00,0.00,185.39,133480.80,0.00,0.00,0.00),('1','310','1','30',208,'5','1',9280.29,10033.43,0.00,0.00,753.14,527198.00,0.00,0.00,0.00),('1','310','1','30',209,'6','1',10984.04,11034.04,0.00,0.00,50.00,35000.00,0.00,0.00,0.00),('1','310','1','30',210,'7','1',4956.42,4968.93,0.00,0.00,12.51,8757.00,0.00,0.00,0.00),('1','310','1','31',211,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','31',212,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','31',213,'3','1',7316.99,7664.35,0.00,0.00,347.36,250099.20,0.00,0.00,0.00),('1','310','1','31',214,'4','1',7150.13,7382.59,0.00,0.00,232.46,167371.20,0.00,0.00,0.00),('1','310','1','31',215,'5','1',10033.43,10392.43,0.00,0.00,359.00,251300.00,0.00,0.00,0.00),('1','310','1','31',216,'6','1',11034.04,11034.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','31',217,'7','1',4968.93,5237.14,0.00,0.00,268.21,187747.00,0.00,0.00,0.00),('1','310','1','32',218,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','32',219,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','32',220,'3','1',7664.35,8054.00,0.00,0.00,389.65,280548.00,0.00,0.00,0.00),('1','310','1','32',221,'4','1',7382.59,7645.78,0.00,0.00,263.19,189496.80,0.00,0.00,0.00),('1','310','1','32',222,'5','1',10392.43,11999.93,0.00,0.00,1607.50,1125250.00,0.00,0.00,0.00),('1','310','1','32',223,'6','1',11034.04,11294.04,0.00,0.00,260.00,182000.00,0.00,0.00,0.00),('1','310','1','32',224,'7','1',5237.14,5250.65,0.00,0.00,13.51,9457.00,0.00,0.00,0.00),('1','310','1','33',225,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','33',226,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','33',227,'3','1',8054.00,8539.62,0.00,0.00,485.62,349646.40,0.00,0.00,0.00),('1','310','1','33',228,'4','1',7645.78,7981.83,0.00,0.00,336.05,241956.00,0.00,0.00,0.00),('1','310','1','33',229,'5','1',11999.93,12376.07,0.00,0.00,376.14,263338.00,0.00,0.00,0.00),('1','310','1','33',230,'6','1',11294.04,11406.54,0.00,0.00,112.50,78750.00,0.00,0.00,0.00),('1','310','1','33',231,'7','1',5250.65,5256.89,0.00,0.00,6.24,4368.00,0.00,0.00,0.00),('1','310','1','34',232,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','34',233,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','34',234,'3','1',8539.62,8844.19,0.00,0.00,304.57,219290.40,0.00,0.00,0.00),('1','310','1','34',235,'4','1',7981.83,8122.08,0.00,0.00,140.25,100980.00,0.00,0.00,0.00),('1','310','1','34',236,'5','1',12376.07,13033.07,0.00,0.00,657.00,459900.00,0.00,0.00,0.00),('1','310','1','34',237,'6','1',11406.54,11418.54,0.00,0.00,12.00,8400.00,0.00,0.00,0.00),('1','310','1','34',238,'7','1',5256.89,5256.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','35',239,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','35',240,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','35',241,'3','1',8844.19,8844.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','35',242,'4','1',8122.08,8122.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','35',243,'5','1',13033.07,13033.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','35',244,'6','1',11418.54,11418.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','35',245,'7','1',5256.89,5256.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','36',246,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','36',247,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','36',248,'3','1',8844.19,9044.11,0.00,0.00,199.92,143942.40,0.00,0.00,0.00),('1','310','1','36',249,'4','1',8122.08,8149.80,0.00,0.00,27.72,19958.40,0.00,0.00,0.00),('1','310','1','36',250,'5','1',13033.07,13033.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','36',251,'6','1',11418.54,11418.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','36',252,'7','1',5256.89,5466.17,0.00,0.00,209.28,146496.00,0.00,0.00,0.00),('1','310','1','37',253,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','37',254,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','37',255,'3','1',9044.11,9384.89,0.00,0.00,340.78,245361.60,0.00,0.00,0.00),('1','310','1','37',256,'4','1',8149.80,8555.09,0.00,0.00,405.29,291808.80,0.00,0.00,0.00),('1','310','1','37',257,'5','1',13033.07,13665.57,0.00,0.00,632.50,443072.80,0.00,0.00,0.00),('1','310','1','37',258,'6','1',11418.54,11421.40,0.00,0.00,2.86,2002.00,0.00,0.00,0.00),('1','310','1','37',259,'7','1',5466.17,5475.87,0.00,0.00,9.70,6790.00,0.00,0.00,0.00),('1','310','1','38',260,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','38',261,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','38',262,'3','1',9384.89,9713.66,0.00,0.00,328.77,236714.40,0.00,0.00,0.00),('1','310','1','38',263,'4','1',8555.09,8881.99,0.00,0.00,326.90,235368.00,0.00,0.00,0.00),('1','310','1','38',264,'5','1',13665.57,13731.64,0.00,0.00,66.07,46249.00,0.00,0.00,0.00),('1','310','1','38',265,'6','1',11421.40,12456.40,0.00,0.00,1035.00,724500.00,0.00,0.00,0.00),('1','310','1','38',266,'7','1',5475.87,5475.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','39',267,'1','1',564.89,564.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','39',268,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','39',269,'3','1',9713.66,10069.65,0.00,0.00,355.99,256312.80,0.00,0.00,0.00),('1','310','1','39',270,'4','1',8881.99,9235.94,0.00,0.00,353.95,254844.00,0.00,0.00,0.00),('1','310','1','39',271,'5','1',13731.64,13959.64,0.00,0.00,228.00,159600.00,0.00,0.00,0.00),('1','310','1','39',272,'6','1',12456.40,12708.54,0.00,0.00,252.14,176498.00,0.00,0.00,0.00),('1','310','1','39',273,'7','1',5475.87,5475.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','40',274,'1','1',564.89,614.25,0.00,0.00,49.36,35539.20,0.00,0.00,0.00),('1','310','1','40',275,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','40',276,'3','1',10069.65,10935.89,0.00,0.00,866.24,623692.80,0.00,0.00,0.00),('1','310','1','40',277,'4','1',9235.94,10052.53,0.00,0.00,816.59,587944.80,0.00,0.00,0.00),('1','310','1','40',278,'5','1',13959.64,15390.72,0.00,0.00,1431.08,1001756.00,0.00,0.00,0.00),('1','310','1','40',279,'6','1',12708.54,13139.54,0.00,0.00,431.00,301700.00,0.00,0.00,0.00),('1','310','1','40',280,'7','1',5475.87,5589.45,0.00,0.00,113.58,79506.00,0.00,0.00,0.00),('1','310','1','41',281,'1','1',614.25,614.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','41',282,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','41',283,'3','1',10935.89,11381.89,0.00,0.00,446.00,321120.00,0.00,0.00,0.00),('1','310','1','41',284,'4','1',10052.53,10479.44,0.00,0.00,426.91,307375.20,0.00,0.00,0.00),('1','310','1','41',285,'5','1',15390.72,16647.72,0.00,0.00,1257.00,879900.00,0.00,0.00,0.00),('1','310','1','41',286,'6','1',13139.54,13317.11,0.00,0.00,177.57,124299.00,0.00,0.00,0.00),('1','310','1','41',287,'7','1',5589.45,5624.10,0.00,0.00,34.65,24338.40,0.00,0.00,0.00),('1','310','1','42',288,'1','1',614.25,614.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','42',289,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','42',290,'3','1',11381.89,11694.88,0.00,0.00,312.99,225352.80,0.00,0.00,0.00),('1','310','1','42',291,'4','1',10479.44,10772.74,0.00,0.00,293.30,211176.00,0.00,0.00,0.00),('1','310','1','42',292,'5','1',16647.72,16847.72,0.00,0.00,200.00,140000.00,0.00,0.00,0.00),('1','310','1','42',293,'6','1',13317.11,13533.11,0.00,0.00,216.00,151200.00,0.00,0.00,0.00),('1','310','1','42',294,'7','1',5624.10,5626.96,0.00,0.00,2.86,2002.00,0.00,0.00,0.00),('1','310','1','43',295,'1','1',614.25,614.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','43',296,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','43',297,'3','1',11694.88,12120.81,0.00,0.00,425.93,306669.60,0.00,0.00,0.00),('1','310','1','43',298,'4','1',10772.74,11003.53,0.00,0.00,230.79,166168.80,0.00,0.00,0.00),('1','310','1','43',299,'5','1',16847.72,18032.15,0.00,0.00,1184.43,829101.00,0.00,0.00,0.00),('1','310','1','43',300,'6','1',13533.11,13585.97,0.00,0.00,52.86,37002.00,0.00,0.00,0.00),('1','310','1','43',301,'7','1',5626.96,5629.88,0.00,0.00,2.92,2044.00,0.00,0.00,0.00),('1','310','1','44',302,'1','1',614.25,614.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','44',303,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','44',304,'3','1',12120.81,12419.29,0.00,0.00,298.48,214905.60,0.00,0.00,0.00),('1','310','1','44',305,'4','1',11003.53,11192.85,0.00,0.00,189.32,136310.40,0.00,0.00,0.00),('1','310','1','44',306,'5','1',18032.15,18482.15,0.00,0.00,450.00,315000.00,0.00,0.00,0.00),('1','310','1','44',307,'6','1',13585.97,13622.47,0.00,0.00,36.50,25550.00,0.00,0.00,0.00),('1','310','1','44',308,'7','1',5629.88,5844.38,0.00,0.00,214.50,150150.00,0.00,0.00,0.00),('1','310','1','45',309,'1','1',614.25,614.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','45',310,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','45',311,'3','1',12419.29,12730.25,0.00,0.00,310.96,223891.20,0.00,0.00,0.00),('1','310','1','45',312,'4','1',11192.85,11588.99,0.00,0.00,396.14,285220.80,0.00,0.00,0.00),('1','310','1','45',313,'5','1',18482.15,19703.15,0.00,0.00,1221.00,854700.00,0.00,0.00,0.00),('1','310','1','45',314,'6','1',13622.47,13757.47,0.00,0.00,135.00,94500.00,0.00,0.00,0.00),('1','310','1','45',315,'7','1',5844.38,5844.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','46',316,'1','1',614.25,614.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','46',317,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','46',318,'3','1',12730.25,13148.19,0.00,0.00,417.94,300916.80,0.00,0.00,0.00),('1','310','1','46',319,'4','1',11588.99,11932.40,0.00,0.00,343.41,247255.20,0.00,0.00,0.00),('1','310','1','46',320,'5','1',19703.15,19953.15,0.00,0.00,250.00,175000.00,0.00,0.00,0.00),('1','310','1','46',321,'6','1',13757.47,13817.47,0.00,0.00,60.00,42000.00,0.00,0.00,0.00),('1','310','1','46',322,'7','1',5844.38,5996.95,0.00,0.00,152.57,106799.00,0.00,0.00,0.00),('1','310','1','47',323,'1','1',614.25,614.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','47',324,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','47',325,'3','1',13148.19,13509.89,0.00,0.00,361.70,260424.00,0.00,0.00,0.00),('1','310','1','47',326,'4','1',11932.40,12339.32,0.00,0.00,406.92,292982.40,0.00,0.00,0.00),('1','310','1','47',327,'5','1',19953.15,20694.86,0.00,0.00,741.71,519197.00,0.00,0.00,0.00),('1','310','1','47',328,'6','1',13817.47,14315.95,0.00,0.00,498.48,348936.00,0.00,0.00,0.00),('1','310','1','47',329,'7','1',5996.95,6046.95,0.00,0.00,50.00,35000.00,0.00,0.00,0.00),('1','310','1','48',330,'1','1',614.25,614.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','48',331,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','48',332,'3','1',13509.89,14171.58,0.00,0.00,661.69,473616.80,0.00,0.00,0.00),('1','310','1','48',333,'4','1',12339.32,12832.35,0.00,0.00,493.03,354981.60,0.00,0.00,0.00),('1','310','1','48',334,'5','1',20694.86,20957.00,0.00,0.00,262.14,183498.00,0.00,0.00,0.00),('1','310','1','48',335,'6','1',14315.95,14484.95,0.00,0.00,169.00,118300.00,0.00,0.00,0.00),('1','310','1','48',336,'7','1',6046.95,6046.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','49',337,'1','1',614.25,614.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','49',338,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','49',339,'3','1',14171.58,14503.15,0.00,0.00,331.57,238730.40,0.00,0.00,0.00),('1','310','1','49',340,'4','1',12832.35,13156.81,0.00,0.00,324.46,233611.20,0.00,0.00,0.00),('1','310','1','49',341,'5','1',20957.00,21448.86,0.00,0.00,491.86,344302.00,0.00,0.00,0.00),('1','310','1','49',342,'6','1',14484.95,14646.95,0.00,0.00,162.00,113400.00,0.00,0.00,0.00),('1','310','1','49',343,'7','1',6046.95,6046.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','50',344,'1','1',614.25,614.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','50',345,'2','1',201.96,201.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','50',346,'3','1',14503.15,14848.51,0.00,0.00,345.36,248659.20,0.00,0.00,0.00),('1','310','1','50',347,'4','1',13156.81,13630.88,0.00,0.00,474.07,341080.40,0.00,0.00,0.00),('1','310','1','50',348,'5','1',21448.86,21858.86,0.00,0.00,410.00,287000.00,0.00,0.00,0.00),('1','310','1','50',349,'6','1',14646.95,14924.95,0.00,0.00,278.00,194600.00,0.00,0.00,0.00),('1','310','1','50',350,'7','1',6046.95,6339.81,0.00,0.00,292.86,205002.00,0.00,0.00,0.00),('1','310','1','51',351,'1','1',614.25,614.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','51',352,'2','1',201.96,207.96,0.00,0.00,6.00,4200.00,0.00,0.00,0.00),('1','310','1','51',353,'3','1',14848.51,15253.92,0.00,0.00,405.41,291895.20,0.00,0.00,0.00),('1','310','1','51',354,'4','1',13630.88,14010.48,0.00,0.00,379.60,273312.00,0.00,0.00,0.00),('1','310','1','51',355,'5','1',21858.86,22041.50,0.00,0.00,182.64,127848.00,0.00,0.00,0.00),('1','310','1','51',356,'6','1',14924.95,15176.95,0.00,0.00,252.00,176400.00,0.00,0.00,0.00),('1','310','1','51',357,'7','1',6339.81,6339.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','52',358,'1','1',614.25,614.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','52',359,'2','1',207.96,207.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','52',360,'3','1',15253.92,15569.42,0.00,0.00,315.50,227160.00,0.00,0.00,0.00),('1','310','1','52',361,'4','1',14010.48,14362.75,0.00,0.00,352.27,253634.40,0.00,0.00,0.00),('1','310','1','52',362,'5','1',22041.50,22651.50,0.00,0.00,610.00,427000.00,0.00,0.00,0.00),('1','310','1','52',363,'6','1',15176.95,15547.95,0.00,0.00,371.00,259700.00,0.00,0.00,0.00),('1','310','1','52',364,'7','1',6339.81,6568.80,0.00,0.00,228.99,160293.00,0.00,0.00,0.00),('1','310','1','53',365,'1','1',614.25,614.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','53',366,'2','1',207.96,207.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','53',367,'3','1',15569.42,15841.17,0.00,0.00,271.75,195660.00,0.00,0.00,0.00),('1','310','1','53',368,'4','1',14362.75,14819.01,0.00,0.00,456.26,328507.20,0.00,0.00,0.00),('1','310','1','53',369,'5','1',22651.50,23011.50,0.00,0.00,360.00,252000.00,0.00,0.00,0.00),('1','310','1','53',370,'6','1',15547.95,15677.94,0.00,0.00,129.99,90993.00,0.00,0.00,0.00),('1','310','1','53',371,'7','1',6568.80,6568.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','54',372,'1','1',614.25,690.84,0.00,0.00,76.59,55144.80,0.00,0.00,0.00),('1','310','1','54',373,'2','1',207.96,207.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','54',374,'3','1',15841.17,16289.43,0.00,0.00,448.26,322747.20,0.00,0.00,0.00),('1','310','1','54',375,'4','1',14819.01,15351.37,0.00,0.00,532.36,383299.20,0.00,0.00,0.00),('1','310','1','54',376,'5','1',23011.50,23270.50,0.00,0.00,259.00,181300.00,0.00,0.00,0.00),('1','310','1','54',377,'6','1',15677.94,15887.94,0.00,0.00,210.00,147000.00,0.00,0.00,0.00),('1','310','1','54',378,'7','1',6568.80,7065.80,0.00,0.00,497.00,347900.00,0.00,0.00,0.00),('1','310','1','55',379,'1','1',690.84,690.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','55',380,'2','1',207.96,207.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','55',381,'3','1',16289.43,16870.57,0.00,0.00,581.14,418420.80,0.00,0.00,0.00),('1','310','1','55',382,'4','1',15351.37,15898.28,0.00,0.00,546.91,393775.20,0.00,0.00,0.00),('1','310','1','55',383,'5','1',23270.50,23584.84,0.00,0.00,314.34,220096.20,0.00,0.00,0.00),('1','310','1','55',384,'6','1',15887.94,16351.37,0.00,0.00,463.43,324401.00,0.00,0.00,0.00),('1','310','1','55',385,'7','1',7065.80,7405.80,0.00,0.00,340.00,238000.00,0.00,0.00,0.00),('1','310','1','56',386,'1','1',690.84,690.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','56',387,'2','1',207.96,207.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','56',388,'3','1',16870.57,17083.51,0.00,0.00,212.94,153316.80,0.00,0.00,0.00),('1','310','1','56',389,'4','1',15898.28,16135.18,0.00,0.00,236.90,170568.00,0.00,0.00,0.00),('1','310','1','56',390,'5','1',23584.84,23829.94,0.00,0.00,245.10,175272.00,0.00,0.00,0.00),('1','310','1','56',391,'6','1',16351.37,16363.34,0.00,0.00,11.97,8379.00,0.00,0.00,0.00),('1','310','1','56',392,'7','1',7405.80,7893.87,0.00,0.00,488.07,341649.00,0.00,0.00,0.00),('1','310','1','57',393,'1','1',690.84,690.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','57',394,'2','1',207.96,207.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','57',395,'3','1',17083.51,17447.31,0.00,0.00,363.80,261936.00,0.00,0.00,0.00),('1','310','1','57',396,'4','1',16135.18,16461.66,0.00,0.00,326.48,235065.60,0.00,0.00,0.00),('1','310','1','57',397,'5','1',23829.94,23836.94,0.00,0.00,7.00,5040.00,0.00,0.00,0.00),('1','310','1','57',398,'6','1',16363.34,16492.62,0.00,0.00,129.28,90496.00,0.00,0.00,0.00),('1','310','1','57',399,'7','1',7893.87,8693.87,0.00,0.00,800.00,560000.00,0.00,0.00,0.00),('1','310','1','58',400,'1','1',690.84,690.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','58',401,'2','1',207.96,207.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','58',402,'3','1',17447.31,17737.93,0.00,0.00,290.62,209246.40,0.00,0.00,0.00),('1','310','1','58',403,'4','1',16461.66,16746.95,0.00,0.00,285.29,205408.80,0.00,0.00,0.00),('1','310','1','58',404,'5','1',23836.94,24033.62,0.00,0.00,196.68,141609.60,0.00,0.00,0.00),('1','310','1','58',405,'6','1',16492.62,17468.95,0.00,0.00,976.33,683431.00,0.00,0.00,0.00),('1','310','1','58',406,'7','1',8693.87,9016.87,0.00,0.00,323.00,226100.00,0.00,0.00,0.00),('1','310','1','59',407,'1','1',690.84,690.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','59',408,'2','1',207.96,207.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','59',409,'3','1',17737.93,18109.63,0.00,0.00,371.70,267624.00,0.00,0.00,0.00),('1','310','1','59',410,'4','1',16746.95,17103.35,0.00,0.00,356.40,256608.00,0.00,0.00,0.00),('1','310','1','59',411,'5','1',24033.62,24039.62,0.00,0.00,6.00,4320.00,0.00,0.00,0.00),('1','310','1','59',412,'6','1',17468.95,18074.66,0.00,0.00,605.71,423997.00,0.00,0.00,0.00),('1','310','1','59',413,'7','1',9016.87,9485.47,0.00,0.00,468.60,328020.00,0.00,0.00,0.00),('1','310','1','60',414,'1','1',690.84,690.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','60',415,'2','1',207.96,207.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','60',416,'3','1',18109.63,18672.73,0.00,0.00,563.10,405432.00,0.00,0.00,0.00),('1','310','1','60',417,'4','1',17103.35,17619.72,0.00,0.00,516.37,371786.40,0.00,0.00,0.00),('1','310','1','60',418,'5','1',24039.62,24387.97,0.00,0.00,348.35,250812.00,0.00,0.00,0.00),('1','310','1','60',419,'6','1',18074.66,18608.37,0.00,0.00,533.71,373597.00,0.00,0.00,0.00),('1','310','1','60',420,'7','1',9485.47,9949.67,0.00,0.00,464.20,324940.00,0.00,0.00,0.00),('1','310','1','61',421,'1','1',690.84,690.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','61',422,'2','1',207.96,207.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','61',423,'3','1',18672.73,19133.79,0.00,0.00,461.06,331963.20,0.00,0.00,0.00),('1','310','1','61',424,'4','1',17619.72,18030.80,0.00,0.00,411.08,295977.60,0.00,0.00,0.00),('1','310','1','61',425,'5','1',24387.97,24726.10,0.00,0.00,338.13,243453.60,0.00,0.00,0.00),('1','310','1','61',426,'6','1',18608.37,19681.94,0.00,0.00,1073.57,751499.00,0.00,0.00,0.00),('1','310','1','61',427,'7','1',9949.67,10662.53,0.00,0.00,712.86,499002.00,0.00,0.00,0.00),('1','310','1','62',428,'1','1',690.84,690.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','62',429,'2','1',207.96,207.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','62',430,'3','1',19133.79,19245.91,0.00,0.00,112.12,80726.40,0.00,0.00,0.00),('1','310','1','62',431,'4','1',18030.80,18030.81,0.00,0.00,0.01,7.20,0.00,0.00,0.00),('1','310','1','62',432,'5','1',24726.10,24726.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','310','1','62',433,'6','1',19681.94,19718.94,0.00,0.00,37.00,25900.00,0.00,0.00,0.00),('1','310','1','62',434,'7','1',10662.53,10820.38,0.00,0.00,157.85,110495.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','310','1','1',651.00,0.00,0.00,480.35,312707.85,337174.20,24466.35,1),('1','310','2','1',651.00,720.00,0.00,812.39,528865.89,573580.80,44714.91,2),('1','310','3','1',651.00,720.00,0.00,0.00,0.00,0.00,0.00,3),('1','310','4','1',651.00,720.00,0.00,949.26,617968.26,671081.40,53113.14,4),('1','310','5','1',651.00,720.00,0.00,1769.95,1152237.45,1249554.00,97316.55,5),('1','310','6','1',651.00,720.00,0.00,862.30,561357.30,610596.00,49238.70,6),('1','310','7','1',651.00,720.00,0.00,1341.47,873296.97,947192.00,73895.03,7),('1','310','8','1',651.00,720.00,0.00,1353.25,880965.75,959140.00,78174.25,8),('1','310','9','1',651.00,720.00,0.00,1059.36,689643.36,749139.20,59495.84,9),('1','310','10','1',651.00,720.00,0.00,2132.23,1388081.73,1500237.40,112155.67,10),('1','310','11','1',651.00,720.00,0.00,1475.92,960823.92,1042002.40,81178.48,11),('1','310','12','1',651.00,720.00,0.00,1024.33,666838.83,725987.60,59148.77,12),('1','310','13','1',651.00,720.00,0.00,993.12,646521.12,702056.20,55535.08,13),('1','310','14','1',651.00,720.00,0.00,936.33,609550.83,668416.40,58865.57,14),('1','310','15','1',651.00,720.00,0.00,704.59,458688.09,504928.40,46240.31,15),('1','310','16','1',651.00,720.00,0.00,1554.60,1012044.60,1103744.80,91700.20,16),('1','310','17','1',651.00,720.00,0.00,875.76,570119.76,623482.20,53362.44,17),('1','310','18','1',651.00,720.00,0.00,1149.30,748194.30,814631.60,66437.30,18),('1','310','19','1',651.00,720.00,0.00,1996.80,1299916.80,1416156.00,116239.20,19),('1','310','20','1',651.00,720.00,0.00,2394.23,1558643.73,1689086.40,130442.67,20),('1','310','21','1',651.00,720.00,0.00,2238.44,1457224.44,1583945.40,126720.96,21),('1','310','22','1',651.00,720.00,0.00,1614.52,1051052.52,1141077.20,90024.68,22),('1','310','23','1',651.00,720.00,0.00,1689.13,1099623.63,1193783.60,94159.97,23),('1','310','24','1',651.00,720.00,0.00,1064.67,693100.17,755846.60,62746.43,24),('1','310','25','1',651.00,720.00,0.00,2317.28,1508549.28,1638563.00,130013.72,25),('1','310','26','1',651.00,720.00,0.00,2032.07,1322877.57,1437216.00,114338.43,26),('1','310','27','1',651.00,720.00,0.00,1458.17,949268.67,1028046.60,78777.93,27),('1','310','28','1',651.00,720.00,0.00,1295.45,843337.95,918494.00,75156.05,28),('1','310','29','1',651.00,720.00,0.00,2377.35,1547654.85,1674552.00,126897.15,29),('1','310','30','1',651.00,720.00,0.00,1317.75,857855.25,932467.00,74611.75,30),('1','310','31','1',651.00,720.00,0.00,1207.03,785776.53,856517.40,70740.87,31),('1','310','32','1',651.00,720.00,0.00,2533.85,1649536.35,1786751.80,137215.45,32),('1','310','33','1',651.00,720.00,0.00,1316.55,857074.05,938058.40,80984.35,33),('1','310','34','1',651.00,720.00,0.00,1113.82,725096.82,788570.40,63473.58,34),('1','310','35','1',651.00,720.00,0.00,0.00,0.00,0.00,0.00,35),('1','310','36','1',651.00,720.00,0.00,436.92,284434.92,310396.80,25961.88,36),('1','310','37','1',651.00,720.00,0.00,1391.13,905625.63,989035.20,83409.57,37),('1','310','38','1',651.00,720.00,0.00,1756.74,1143637.74,1242831.40,99193.66,38),('1','310','39','1',651.00,720.00,0.00,1190.08,774742.08,847254.80,72512.72,39),('1','310','40','1',651.00,720.00,0.00,3707.85,2413810.35,2630138.80,216328.45,40),('1','310','41','1',651.00,720.00,0.00,2342.13,1524726.63,1657032.60,132305.97,41),('1','310','42','1',651.00,720.00,0.00,1025.15,667372.65,729730.80,62358.15,42),('1','310','43','1',651.00,720.00,0.00,1896.93,1234901.43,1340985.40,106083.97,43),('1','310','44','1',651.00,720.00,0.00,1188.80,773908.80,841916.00,68007.20,44),('1','310','45','1',651.00,720.00,0.00,2063.10,1343078.10,1458312.00,115233.90,45),('1','310','46','1',651.00,720.00,0.00,1223.92,796771.92,871971.00,75199.08,46),('1','310','47','1',651.00,720.00,0.00,2058.81,1340285.31,1456539.40,116254.09,47),('1','310','48','1',651.00,720.00,0.00,1585.86,1032394.86,1130396.40,98001.54,48),('1','310','49','1',651.00,720.00,0.00,1309.89,852738.39,930043.60,77305.21,49),('1','310','50','1',651.00,720.00,0.00,1800.29,1171988.79,1276341.60,104352.81,50),('1','310','51','1',651.00,720.00,0.00,1225.65,797898.15,873655.20,75757.05,51),('1','310','52','1',651.00,720.00,0.00,1877.76,1222421.76,1327787.40,105365.64,52),('1','310','53','1',651.00,720.00,0.00,1218.00,792918.00,867160.20,74242.20,53),('1','310','54','1',651.00,720.00,0.00,2023.21,1317109.71,1437391.20,120281.49,54),('1','310','55','1',651.00,720.00,0.00,2245.82,1462028.82,1594693.20,132664.38,55),('1','310','56','1',651.00,720.00,0.00,1194.98,777931.98,849184.80,71252.82,56),('1','310','57','1',651.00,720.00,0.00,1626.56,1058890.56,1152537.60,93647.04,57),('1','310','58','1',651.00,720.00,0.00,2071.92,1348819.92,1465795.80,116975.88,58),('1','310','59','1',651.00,720.00,0.00,1808.41,1177274.91,1280569.00,103294.09,59),('1','310','60','1',651.00,720.00,0.00,2425.73,1579150.23,1726567.40,147417.17,60),('1','310','61','1',651.00,720.00,0.00,2996.70,1950851.70,2121895.40,171043.70,61),('1','310','62','1',651.00,720.00,0.00,306.98,199843.98,217128.60,17284.62,62);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'310','LPG PRODUCT ','Tanks Containing LPG Product.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','310','1',1,1,'1','LPG TANK ',70000.00,0.00,NULL,'TANK CONTAINING LPG PRODUCT.','479','2023-01-23 00:24:45','2023-01-23 00:24:57','479',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','310',1,3860.68,'2023-03-20 09:58:28');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=7833 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','310',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,16294530.00,25030.00,0.00,0.00,'2023-01-23 11:12:08','',''),(2,'1','310',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,25030.00,0.00,'2023-01-23 11:15:16','',''),(3,'1','310','1',1,'Received from bridging 1',0.00,0.00,25030.00,0.00,0.00,'2023-01-23 11:15:16','',''),(4,'1','310',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,16327080.00,25080.00,0.00,0.00,'2023-01-23 11:17:49','',''),(5,'1','310',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,25080.00,0.00,'2023-01-23 11:20:47','',''),(6,'1','310','1',1,'Received from bridging 2',0.00,0.00,25080.00,0.00,0.00,'2023-01-23 11:20:47','',''),(7,'1','310','1',1,'Retail Sale Id 1',33451.20,0.00,0.00,46.46,3205.74,'2023-01-23 11:34:04','',''),(8,'1','310','1',1,'Retail Sale Id 2',303723.00,0.00,0.00,433.89,21260.61,'2023-01-23 11:39:51','',''),(9,'1','310','1',1,'Retail Sale Id 3',2203.20,0.00,0.00,3.06,211.14,'2023-01-23 11:47:17','',''),(10,'1','310','1',1,'Retail Sale Id 3',67968.00,0.00,0.00,94.40,6513.60,'2023-01-23 11:47:17','',''),(11,'1','310','1',1,'Retail Sale Id 3',106509.60,0.00,0.00,147.93,10207.17,'2023-01-23 11:47:17','',''),(12,'1','310','1',1,'Retail Sale Id 4',396900.00,0.00,0.00,567.00,27783.00,'2023-01-23 11:50:02','',''),(13,'1','310','1',1,'Retail Sale Id 5',71892.00,0.00,0.00,99.85,6889.65,'2023-01-23 11:55:29','',''),(14,'1','310','1',1,'Retail Sale Id 5',165686.40,0.00,0.00,230.12,15878.28,'2023-01-23 11:55:29','',''),(15,'1','310','1',1,'Retail Sale Id 6',433503.00,0.00,0.00,619.29,30345.21,'2023-01-23 11:56:50','',''),(16,'1','310','1',1,'Retail Sale Id 8',381204.00,0.00,0.00,529.45,36532.05,'2023-01-23 11:59:57','',''),(17,'1','310','1',1,'Retail Sale Id 9',868350.00,0.00,0.00,1240.50,60784.50,'2023-01-23 12:01:28','',''),(18,'1','310','1',1,'Retail Sale Id 10',2001.60,0.00,0.00,2.78,191.82,'2023-01-23 12:12:33','',''),(19,'1','310','1',1,'Retail Sale Id 11',2001.60,0.00,0.00,2.78,191.82,'2023-01-23 12:14:06','',''),(20,'1','310','1',1,'Retail Sale Id 12',1000.80,0.00,0.00,1.39,95.91,'2023-01-23 12:17:21','',''),(21,'1','310','1',1,'Retail Sale Id 13',70000.00,0.00,0.00,100.00,4900.00,'2023-01-23 12:27:09','',''),(22,'1','310','1',1,'Retail Sale Id 14',2160.00,0.00,0.00,3.00,207.00,'2023-01-23 12:37:51','',''),(23,'1','310','1',1,'Retail Sale Id 15',799.20,0.00,0.00,1.11,76.59,'2023-01-23 12:44:10','',''),(24,'1','310','1',1,'Retail Sale Id 16',35000.00,0.00,0.00,50.00,2450.00,'2023-01-23 12:56:38','',''),(25,'1','310','1',1,'Retail Sale Id 17',4399.20,0.00,0.00,6.11,421.59,'2023-01-23 12:58:06','',''),(26,'1','310','1',1,'Retail Sale Id 18',35000.00,0.00,0.00,50.00,2450.00,'2023-01-23 12:59:39','',''),(27,'1','310','1',1,'Retail Sale Id 19',9100.00,0.00,0.00,13.00,637.00,'2023-01-23 13:11:45','',''),(28,'1','310','1',1,'Retail Sale Id 20',3600.00,0.00,0.00,5.00,345.00,'2023-01-23 13:18:56','',''),(29,'1','310','1',1,'Retail Sale Id 20',4399.20,0.00,0.00,6.11,421.59,'2023-01-23 13:18:56','',''),(30,'1','310','1',1,'Retail Sale Id 21',2001.60,0.00,0.00,2.78,191.82,'2023-01-23 13:35:31','',''),(31,'1','310','1',1,'Retail Sale Id 22',4500.00,0.00,0.00,6.25,431.25,'2023-01-23 13:36:29','',''),(32,'1','310','1',1,'Retail Sale Id 23',1000.80,0.00,0.00,1.39,95.91,'2023-01-23 13:37:53','',''),(33,'1','310','1',1,'Retail Sale Id 24',9000.00,0.00,0.00,12.50,862.50,'2023-01-23 13:45:38','',''),(34,'1','310','1',1,'Retail Sale Id 25',4399.20,0.00,0.00,6.11,421.59,'2023-01-23 14:01:54','',''),(35,'1','310','1',1,'Retail Sale Id 26',1000.80,0.00,0.00,1.39,95.91,'2023-01-23 14:05:51','',''),(36,'1','310','1',1,'Retail Sale Id 27',1000.80,0.00,0.00,1.39,95.91,'2023-01-23 14:13:46','',''),(37,'1','310','1',1,'Retail Sale Id 28',4399.20,0.00,0.00,6.11,421.59,'2023-01-23 14:20:37','',''),(38,'1','310','1',1,'Retail Sale Id 29',4399.20,0.00,0.00,6.11,421.59,'2023-01-23 14:31:40','',''),(39,'1','310','1',1,'Retail Sale Id 30',9000.00,0.00,0.00,12.50,862.50,'2023-01-23 14:40:14','',''),(40,'1','310','1',1,'Retail Sale Id 31',2203.20,0.00,0.00,3.06,211.14,'2023-01-23 15:33:24','',''),(41,'1','310','1',1,'Retail Sale Id 32',2001.60,0.00,0.00,2.78,191.82,'2023-01-23 15:36:53','',''),(42,'1','310','1',1,'Retail Sale Id 33',3700.80,0.00,0.00,5.14,354.66,'2023-01-23 15:40:03','',''),(43,'1','310','1',1,'Retail Sale Id 34',2203.20,0.00,0.00,3.06,211.14,'2023-01-23 15:40:52','',''),(44,'1','310','1',1,'Retail Sale Id 35',2203.20,0.00,0.00,3.06,211.14,'2023-01-23 15:55:36','',''),(45,'1','310','1',1,'Retail Sale Id 36',1000.80,0.00,0.00,1.39,95.91,'2023-01-23 16:08:50','',''),(46,'1','310','1',1,'Retail Sale Id 37',4320.00,0.00,0.00,6.00,414.00,'2023-01-23 16:17:46','',''),(47,'1','310','1',1,'Retail Sale Id 38',3600.00,0.00,0.00,5.00,345.00,'2023-01-23 16:23:19','',''),(48,'1','310','1',1,'Retail Sale Id 39',1000.80,0.00,0.00,1.39,95.91,'2023-01-23 16:24:47','',''),(49,'1','310','1',1,'Retail Sale Id 40',3002.40,0.00,0.00,4.17,287.73,'2023-01-23 16:50:39','',''),(50,'1','310','1',1,'Retail Sale Id 41',2203.20,0.00,0.00,3.06,211.14,'2023-01-23 16:58:57','',''),(51,'1','310','1',1,'Retail Sale Id 42',1202.40,0.00,0.00,1.67,115.23,'2023-01-23 17:00:59','',''),(52,'1','310','1',1,'Retail Sale Id 43',1497.60,0.00,0.00,2.08,143.52,'2023-01-23 17:02:45','',''),(53,'1','310','1',1,'Retail Sale Id 47',4003.20,0.00,0.00,5.56,383.64,'2023-01-23 17:09:33','',''),(54,'1','310','1',1,'Retail Sale Id 49',4003.20,0.00,0.00,5.56,383.64,'2023-01-23 17:12:08','',''),(55,'1','310','1',1,'Retail Sale Id 50',4003.20,0.00,0.00,5.56,383.64,'2023-01-23 17:12:51','',''),(56,'1','310','1',1,'Retail Sale Id 51',4003.20,0.00,0.00,5.56,383.64,'2023-01-23 17:13:51','',''),(57,'1','310','1',1,'Retail Sale Id 52',35000.00,0.00,0.00,50.00,2450.00,'2023-01-23 17:15:39','',''),(58,'1','310','1',1,'Retail Sale Id 53',8750.00,0.00,0.00,12.50,612.50,'2023-01-23 17:36:45','',''),(59,'1','310','1',1,'Retail Sale Id 54',4399.20,0.00,0.00,6.11,421.59,'2023-01-23 17:38:47','',''),(60,'1','310','1',1,'Retail Sale Id 55',1497.60,0.00,0.00,2.08,143.52,'2023-01-23 17:41:32','',''),(61,'1','310','1',1,'Retail Sale Id 56',2001.60,0.00,0.00,2.78,191.82,'2023-01-23 17:44:25','',''),(62,'1','310','1',1,'Retail Sale Id 56',4003.20,0.00,0.00,5.56,383.64,'2023-01-23 17:44:26','',''),(63,'1','310','1',1,'Retail Sale Id 57',3002.40,0.00,0.00,4.17,287.73,'2023-01-23 17:54:17','',''),(64,'1','310','1',1,'Retail Sale Id 58',1101.60,0.00,0.00,1.53,105.57,'2023-01-23 17:59:18','',''),(65,'1','310','1',1,'Retail Sale Id 59',1000.80,0.00,0.00,1.39,95.91,'2023-01-23 18:02:34','',''),(66,'1','310','1',1,'Retail Sale Id 60',9000.00,0.00,0.00,12.50,862.50,'2023-01-23 18:11:06','',''),(67,'1','310','1',1,'Retail Sale Id 61',2203.20,0.00,0.00,3.06,211.14,'2023-01-23 18:12:32','',''),(68,'1','310','1',1,'Retail Sale Id 62',4399.20,0.00,0.00,6.11,421.59,'2023-01-23 18:14:54','',''),(69,'1','310','1',1,'Retail Sale Id 63',2001.60,0.00,0.00,2.78,191.82,'2023-01-23 18:23:19','',''),(70,'1','310','1',1,'Retail Sale Id 63',3002.40,0.00,0.00,4.17,287.73,'2023-01-23 18:23:19','',''),(71,'1','310','1',1,'Retail Sale Id 64',1497.60,0.00,0.00,2.08,143.52,'2023-01-23 18:24:45','',''),(72,'1','310','1',1,'Retail Sale Id 65',2498.40,0.00,0.00,3.47,239.43,'2023-01-23 18:27:38','',''),(73,'1','310','1',1,'Retail Sale Id 66',3600.00,0.00,0.00,5.00,345.00,'2023-01-23 18:30:57','',''),(74,'1','310','1',1,'Retail Sale Id 67',2001.60,0.00,0.00,2.78,191.82,'2023-01-23 18:43:31','',''),(75,'1','310','1',1,'Retail Sale Id 68',129369.60,0.00,0.00,179.68,12397.92,'2023-01-23 19:16:03','',''),(76,'1','310','1',1,'Retail Sale Id 69',166250.00,0.00,0.00,237.50,11637.50,'2023-01-23 19:18:15','',''),(77,'1','310','1',1,'Return of Retail Sale Id 68',0.00,129369.60,179.68,0.00,-12397.92,'2023-01-23 19:19:47','',''),(78,'1','310','1',1,'Retail Sale Id 70',97070.40,0.00,0.00,134.82,9302.58,'2023-01-23 19:20:27','',''),(79,'1','310','1',1,'Retail Sale Id 71',1000.80,0.00,0.00,1.39,95.91,'2023-01-24 07:59:41','',''),(80,'1','310','1',1,'Retail Sale Id 72',9000.00,0.00,0.00,12.50,862.50,'2023-01-24 08:12:48','',''),(81,'1','310','1',1,'Retail Sale Id 73',496.80,0.00,0.00,0.69,47.61,'2023-01-24 08:26:10','',''),(82,'1','310','1',1,'Retail Sale Id 74',10500.00,0.00,0.00,15.00,735.00,'2023-01-24 08:37:12','',''),(83,'1','310','1',1,'Retail Sale Id 75',2001.60,0.00,0.00,2.78,191.82,'2023-01-24 08:42:25','',''),(84,'1','310','1',1,'Retail Sale Id 76',84000.00,0.00,0.00,120.00,5880.00,'2023-01-24 08:45:01','',''),(85,'1','310','1',1,'Retail Sale Id 77',2397.60,0.00,0.00,3.33,229.77,'2023-01-24 08:46:57','',''),(86,'1','310','1',1,'Retail Sale Id 78',2001.60,0.00,0.00,2.78,191.82,'2023-01-24 08:48:06','',''),(87,'1','310','1',1,'Retail Sale Id 79',9000.00,0.00,0.00,12.50,862.50,'2023-01-24 08:51:10','',''),(88,'1','310','1',1,'Retail Sale Id 80',9000.00,0.00,0.00,12.50,862.50,'2023-01-24 08:53:24','',''),(89,'1','310','1',1,'Retail Sale Id 81',1497.60,0.00,0.00,2.08,143.52,'2023-01-24 08:55:47','',''),(90,'1','310','1',1,'Retail Sale Id 82',25900.00,0.00,0.00,37.00,1813.00,'2023-01-24 09:23:08','',''),(91,'1','310','1',1,'Retail Sale Id 83',4500.00,0.00,0.00,6.25,431.25,'2023-01-24 09:24:23','',''),(92,'1','310','1',1,'Retail Sale Id 84',4399.20,0.00,0.00,6.11,421.59,'2023-01-24 09:31:12','',''),(93,'1','310','1',1,'Retail Sale Id 85',2001.60,0.00,0.00,2.78,191.82,'2023-01-24 09:33:09','',''),(94,'1','310','1',1,'Retail Sale Id 86',2203.20,0.00,0.00,3.06,211.14,'2023-01-24 09:40:09','',''),(95,'1','310','1',1,'Retail Sale Id 86',4399.20,0.00,0.00,6.11,421.59,'2023-01-24 09:40:09','',''),(96,'1','310','1',1,'Retail Sale Id 86',4399.20,0.00,0.00,6.11,421.59,'2023-01-24 09:40:09','',''),(97,'1','310','1',1,'Retail Sale Id 87',4996.80,0.00,0.00,6.94,478.86,'2023-01-24 09:44:52','',''),(98,'1','310','1',1,'Retail Sale Id 88',1000.80,0.00,0.00,1.39,95.91,'2023-01-24 09:53:59','',''),(99,'1','310','1',1,'Retail Sale Id 89',9000.00,0.00,0.00,12.50,862.50,'2023-01-24 10:06:27','',''),(100,'1','310','1',1,'Retail Sale Id 90',4996.80,0.00,0.00,6.94,478.86,'2023-01-24 10:08:05','',''),(101,'1','310','1',1,'Retail Sale Id 91',9000.00,0.00,0.00,12.50,862.50,'2023-01-24 10:16:51','',''),(102,'1','310','1',1,'Retail Sale Id 92',2001.60,0.00,0.00,2.78,191.82,'2023-01-24 10:18:24','',''),(103,'1','310','1',1,'Retail Sale Id 93',2001.60,0.00,0.00,2.78,191.82,'2023-01-24 10:29:12','',''),(104,'1','310','1',1,'Retail Sale Id 94',1598.40,0.00,0.00,2.22,153.18,'2023-01-24 10:30:30','',''),(105,'1','310','1',1,'Retail Sale Id 95',1497.60,0.00,0.00,2.08,143.52,'2023-01-24 10:39:38','',''),(106,'1','310','1',1,'Retail Sale Id 96',4320.00,0.00,0.00,6.00,414.00,'2023-01-24 10:40:50','',''),(107,'1','310','1',1,'Retail Sale Id 97',9000.00,0.00,0.00,12.50,862.50,'2023-01-24 10:45:09','',''),(108,'1','310','1',1,'Retail Sale Id 98',1000.80,0.00,0.00,1.39,95.91,'2023-01-24 10:54:48','',''),(109,'1','310','1',1,'Retail Sale Id 99',2160.00,0.00,0.00,3.00,207.00,'2023-01-24 10:57:40','',''),(110,'1','310','1',1,'Retail Sale Id 100',4996.80,0.00,0.00,6.94,478.86,'2023-01-24 11:05:12','',''),(111,'1','310','1',1,'Retail Sale Id 101',315000.00,0.00,0.00,450.00,22050.00,'2023-01-24 11:57:55','',''),(112,'1','310','1',1,'Retail Sale Id 102',9000.00,0.00,0.00,12.50,862.50,'2023-01-24 12:09:35','',''),(113,'1','310','1',1,'Retail Sale Id 103',1497.60,0.00,0.00,2.08,143.52,'2023-01-24 12:19:16','',''),(114,'1','310','1',1,'Retail Sale Id 104',4003.20,0.00,0.00,5.56,383.64,'2023-01-24 12:48:41','',''),(115,'1','310','1',1,'Retail Sale Id 106',2001.60,0.00,0.00,2.78,191.82,'2023-01-24 12:54:50','',''),(116,'1','310','1',1,'Retail Sale Id 107',3002.40,0.00,0.00,4.17,287.73,'2023-01-24 12:56:12','',''),(117,'1','310','1',1,'Retail Sale Id 108',2203.20,0.00,0.00,3.06,211.14,'2023-01-24 13:30:30','',''),(118,'1','310','1',1,'Retail Sale Id 109',70000.00,0.00,0.00,100.00,4900.00,'2023-01-24 13:34:36','',''),(119,'1','310','1',1,'Retail Sale Id 110',1000.80,0.00,0.00,1.39,95.91,'2023-01-24 14:31:22','',''),(120,'1','310','1',1,'Retail Sale Id 111',403.20,0.00,0.00,0.56,38.64,'2023-01-24 15:02:15','',''),(121,'1','310','1',1,'Retail Sale Id 112',148400.00,0.00,0.00,212.00,10388.00,'2023-01-24 15:21:32','',''),(122,'1','310','1',1,'Retail Sale Id 113',2203.20,0.00,0.00,3.06,211.14,'2023-01-24 15:22:33','',''),(123,'1','310','1',1,'Retail Sale Id 114',4399.20,0.00,0.00,6.11,421.59,'2023-01-24 15:28:30','',''),(124,'1','310','1',1,'Retail Sale Id 115',2001.60,0.00,0.00,2.78,191.82,'2023-01-24 15:37:02','',''),(125,'1','310','1',1,'Retail Sale Id 116',2001.60,0.00,0.00,2.78,191.82,'2023-01-24 16:26:03','',''),(126,'1','310','1',1,'Retail Sale Id 117',3002.40,0.00,0.00,4.17,287.73,'2023-01-24 16:27:01','',''),(127,'1','310','1',1,'Retail Sale Id 118',3002.40,0.00,0.00,4.17,287.73,'2023-01-24 16:49:57','',''),(128,'1','310','1',1,'Retail Sale Id 119',2203.20,0.00,0.00,3.06,211.14,'2023-01-24 16:55:13','',''),(129,'1','310','1',1,'Retail Sale Id 120',1000.80,0.00,0.00,1.39,95.91,'2023-01-24 16:56:17','',''),(130,'1','310','1',1,'Retail Sale Id 121',9000.00,0.00,0.00,12.50,862.50,'2023-01-24 16:58:03','',''),(131,'1','310','1',1,'Retail Sale Id 122',10800.00,0.00,0.00,15.00,1035.00,'2023-01-24 17:01:57','',''),(132,'1','310','1',1,'Retail Sale Id 123',1000.80,0.00,0.00,1.39,95.91,'2023-01-24 17:03:18','',''),(133,'1','310','1',1,'Retail Sale Id 124',9000.00,0.00,0.00,12.50,862.50,'2023-01-24 17:05:59','',''),(134,'1','310','1',1,'Retail Sale Id 125',2203.20,0.00,0.00,3.06,211.14,'2023-01-24 17:22:21','',''),(135,'1','310','1',1,'Retail Sale Id 126',1000.80,0.00,0.00,1.39,95.91,'2023-01-24 17:27:18','',''),(136,'1','310','1',1,'Retail Sale Id 127',2001.60,0.00,0.00,2.78,191.82,'2023-01-24 17:28:56','',''),(137,'1','310','1',1,'Retail Sale Id 128',4320.00,0.00,0.00,6.00,414.00,'2023-01-24 17:35:19','',''),(138,'1','310','1',1,'Retail Sale Id 129',4996.80,0.00,0.00,6.94,478.86,'2023-01-24 17:37:41','',''),(139,'1','310','1',1,'Retail Sale Id 129',4996.80,0.00,0.00,6.94,478.86,'2023-01-24 17:37:41','',''),(140,'1','310','1',1,'Retail Sale Id 130',3600.00,0.00,0.00,5.00,345.00,'2023-01-24 17:41:23','',''),(141,'1','310','1',1,'Retail Sale Id 131',4320.00,0.00,0.00,6.00,414.00,'2023-01-24 17:45:16','',''),(142,'1','310','1',1,'Retail Sale Id 132',2203.20,0.00,0.00,3.06,211.14,'2023-01-24 17:53:54','',''),(143,'1','310','1',1,'Retail Sale Id 133',4320.00,0.00,0.00,6.00,414.00,'2023-01-24 17:56:26','',''),(144,'1','310','1',1,'Retail Sale Id 134',1000.80,0.00,0.00,1.39,95.91,'2023-01-24 18:09:01','',''),(145,'1','310','1',1,'Retail Sale Id 135',9002.00,0.00,0.00,12.86,630.14,'2023-01-24 18:11:49','',''),(146,'1','310','1',1,'Retail Sale Id 136',9000.00,0.00,0.00,12.50,862.50,'2023-01-24 18:14:21','',''),(147,'1','310','1',1,'Retail Sale Id 136',9000.00,0.00,0.00,12.50,862.50,'2023-01-24 18:14:21','',''),(148,'1','310','1',1,'Retail Sale Id 137',496.80,0.00,0.00,0.69,47.61,'2023-01-24 18:20:35','',''),(149,'1','310','1',1,'Retail Sale Id 138',51811.20,0.00,0.00,71.96,4965.24,'2023-01-24 19:25:08','',''),(150,'1','310','1',1,'Return of Retail Sale Id 74',0.00,10500.00,15.00,0.00,-735.00,'2023-01-24 19:26:54','',''),(151,'1','310','1',1,'Retail Sale Id 139',1022.00,0.00,0.00,1.46,71.54,'2023-01-24 19:28:10','',''),(152,'1','310','1',1,'Retail Sale Id 140',1497.60,0.00,0.00,2.08,143.52,'2023-01-25 07:25:11','',''),(153,'1','310','1',1,'Retail Sale Id 141',80500.00,0.00,0.00,115.00,5635.00,'2023-01-25 07:28:51','',''),(154,'1','310','1',1,'Retail Sale Id 142',1497.60,0.00,0.00,2.08,143.52,'2023-01-25 08:31:19','',''),(155,'1','310','1',1,'Retail Sale Id 143',4003.20,0.00,0.00,5.56,383.64,'2023-01-25 08:32:17','',''),(156,'1','310','1',1,'Retail Sale Id 144',3600.00,0.00,0.00,5.00,345.00,'2023-01-25 08:36:45','',''),(157,'1','310','1',1,'Retail Sale Id 145',3002.40,0.00,0.00,4.17,287.73,'2023-01-25 09:06:56','',''),(158,'1','310','1',1,'Retail Sale Id 146',1000.80,0.00,0.00,1.39,95.91,'2023-01-25 09:12:38','',''),(159,'1','310','1',1,'Retail Sale Id 147',4996.80,0.00,0.00,6.94,478.86,'2023-01-25 09:15:24','',''),(160,'1','310','1',1,'Retail Sale Id 148',1000.80,0.00,0.00,1.39,95.91,'2023-01-25 09:16:10','',''),(161,'1','310','1',1,'Retail Sale Id 151',2203.20,0.00,0.00,3.06,211.14,'2023-01-25 09:33:50','',''),(162,'1','310','1',1,'Retail Sale Id 152',4320.00,0.00,0.00,6.00,414.00,'2023-01-25 09:36:14','',''),(163,'1','310','1',1,'Retail Sale Id 153',3600.00,0.00,0.00,5.00,345.00,'2023-01-25 10:00:39','',''),(164,'1','310','1',1,'Retail Sale Id 154',4320.00,0.00,0.00,6.00,414.00,'2023-01-25 10:01:36','',''),(165,'1','310','1',1,'Retail Sale Id 155',10000.80,0.00,0.00,13.89,958.41,'2023-01-25 10:02:32','',''),(166,'1','310','1',1,'Retail Sale Id 156',2160.00,0.00,0.00,3.00,207.00,'2023-01-25 10:03:40','',''),(167,'1','310','1',1,'Retail Sale Id 157',2001.60,0.00,0.00,2.78,191.82,'2023-01-25 10:04:35','',''),(168,'1','310','1',1,'Retail Sale Id 157',2001.60,0.00,0.00,2.78,191.82,'2023-01-25 10:04:35','',''),(169,'1','310','1',1,'Retail Sale Id 158',2203.20,0.00,0.00,3.06,211.14,'2023-01-25 10:07:53','',''),(170,'1','310','1',1,'Retail Sale Id 159',2203.20,0.00,0.00,3.06,211.14,'2023-01-25 10:19:20','',''),(171,'1','310','1',1,'Retail Sale Id 161',1000.80,0.00,0.00,1.39,95.91,'2023-01-25 10:33:14','',''),(172,'1','310','1',1,'Retail Sale Id 168',45500.00,0.00,0.00,65.00,3185.00,'2023-01-25 10:48:18','',''),(173,'1','310','1',1,'Retail Sale Id 169',4003.20,0.00,0.00,5.56,383.64,'2023-01-25 10:52:04','',''),(174,'1','310','1',1,'Retail Sale Id 170',3103.20,0.00,0.00,4.31,297.39,'2023-01-25 11:00:27','',''),(175,'1','310','1',1,'Retail Sale Id 171',70000.00,0.00,0.00,100.00,4900.00,'2023-01-25 11:01:30','',''),(176,'1','310','1',1,'Retail Sale Id 172',4298.40,0.00,0.00,5.97,411.93,'2023-01-25 11:03:17','',''),(177,'1','310','1',1,'Retail Sale Id 173',4298.40,0.00,0.00,5.97,411.93,'2023-01-25 11:04:52','',''),(178,'1','310','1',1,'Retail Sale Id 174',2001.60,0.00,0.00,2.78,191.82,'2023-01-25 11:05:34','',''),(179,'1','310','1',1,'Retail Sale Id 175',1497.60,0.00,0.00,2.08,143.52,'2023-01-25 11:07:07','',''),(180,'1','310','1',1,'Retail Sale Id 176',4399.20,0.00,0.00,6.11,421.59,'2023-01-25 11:09:05','',''),(181,'1','310','1',1,'Retail Sale Id 176',9000.00,0.00,0.00,12.50,862.50,'2023-01-25 11:09:05','',''),(182,'1','310','1',1,'Retail Sale Id 177',4399.20,0.00,0.00,6.11,421.59,'2023-01-25 11:09:51','',''),(183,'1','310','1',1,'Retail Sale Id 178',4003.20,0.00,0.00,5.56,383.64,'2023-01-25 11:10:26','',''),(184,'1','310','1',1,'Retail Sale Id 179',1000.80,0.00,0.00,1.39,95.91,'2023-01-25 11:11:00','',''),(185,'1','310','1',1,'Retail Sale Id 180',3600.00,0.00,0.00,5.00,345.00,'2023-01-25 11:11:36','',''),(186,'1','310','1',1,'Retail Sale Id 181',7200.00,0.00,0.00,10.00,690.00,'2023-01-25 11:12:16','',''),(187,'1','310','1',1,'Retail Sale Id 182',3499.20,0.00,0.00,4.86,335.34,'2023-01-25 11:13:01','',''),(188,'1','310','1',1,'Retail Sale Id 183',4399.20,0.00,0.00,6.11,421.59,'2023-01-25 11:13:48','',''),(189,'1','310','1',1,'Retail Sale Id 184',2880.00,0.00,0.00,4.00,276.00,'2023-01-25 11:16:12','',''),(190,'1','310','1',1,'Retail Sale Id 185',1497.60,0.00,0.00,2.08,143.52,'2023-01-25 11:22:21','',''),(191,'1','310','1',1,'Retail Sale Id 185',1497.60,0.00,0.00,2.08,143.52,'2023-01-25 11:22:21','',''),(192,'1','310','1',1,'Retail Sale Id 186',7200.00,0.00,0.00,10.00,690.00,'2023-01-25 11:24:29','',''),(193,'1','310','1',1,'Retail Sale Id 187',1000.80,0.00,0.00,1.39,95.91,'2023-01-25 11:25:57','',''),(194,'1','310','1',1,'Retail Sale Id 188',1800.00,0.00,0.00,2.50,172.50,'2023-01-25 11:26:51','',''),(195,'1','310','1',1,'Retail Sale Id 189',59500.00,0.00,0.00,85.00,4165.00,'2023-01-25 11:34:38','',''),(196,'1','310','1',1,'Retail Sale Id 190',1000.80,0.00,0.00,1.39,95.91,'2023-01-25 11:50:34','',''),(197,'1','310','1',1,'Retail Sale Id 191',1000.80,0.00,0.00,1.39,95.91,'2023-01-25 11:51:25','',''),(198,'1','310','1',1,'Retail Sale Id 192',87500.00,0.00,0.00,125.00,6125.00,'2023-01-25 11:53:41','',''),(199,'1','310','1',1,'Retail Sale Id 193',9000.00,0.00,0.00,12.50,862.50,'2023-01-25 11:58:41','',''),(200,'1','310','1',1,'Retail Sale Id 194',84000.00,0.00,0.00,120.00,5880.00,'2023-01-25 11:59:31','',''),(201,'1','310','1',1,'Retail Sale Id 195',9000.00,0.00,0.00,12.50,862.50,'2023-01-25 12:05:44','',''),(202,'1','310','1',1,'Retail Sale Id 196',9302.40,0.00,0.00,12.92,891.48,'2023-01-25 12:11:18','',''),(203,'1','310','1',1,'Retail Sale Id 197',4399.20,0.00,0.00,6.11,421.59,'2023-01-25 12:22:08','',''),(204,'1','310','1',1,'Retail Sale Id 197',9000.00,0.00,0.00,12.50,862.50,'2023-01-25 12:22:08','',''),(205,'1','310','1',1,'Retail Sale Id 198',2001.60,0.00,0.00,2.78,191.82,'2023-01-25 12:30:05','',''),(206,'1','310','1',1,'Retail Sale Id 199',2203.20,0.00,0.00,3.06,211.14,'2023-01-25 12:40:51','',''),(207,'1','310','1',1,'Retail Sale Id 200',2800.80,0.00,0.00,3.89,268.41,'2023-01-25 12:54:00','',''),(208,'1','310','1',1,'Retail Sale Id 201',3499.20,0.00,0.00,4.86,335.34,'2023-01-25 13:07:22','',''),(209,'1','310','1',1,'Retail Sale Id 202',6998.40,0.00,0.00,9.72,670.68,'2023-01-25 13:13:01','',''),(210,'1','310','1',1,'Retail Sale Id 203',2160.00,0.00,0.00,3.00,207.00,'2023-01-25 13:14:16','',''),(211,'1','310','1',1,'Retail Sale Id 204',4320.00,0.00,0.00,6.00,414.00,'2023-01-25 13:25:12','',''),(212,'1','310','1',1,'Retail Sale Id 205',2001.60,0.00,0.00,2.78,191.82,'2023-01-25 13:35:38','',''),(213,'1','310','1',1,'Retail Sale Id 206',2160.00,0.00,0.00,3.00,207.00,'2023-01-25 13:36:40','',''),(214,'1','310','1',1,'Retail Sale Id 208',2160.00,0.00,0.00,3.00,207.00,'2023-01-25 13:45:11','',''),(215,'1','310','1',1,'Retail Sale Id 209',4320.00,0.00,0.00,6.00,414.00,'2023-01-25 13:46:01','',''),(216,'1','310','1',1,'Retail Sale Id 210',2203.20,0.00,0.00,3.06,211.14,'2023-01-25 13:48:59','',''),(217,'1','310','1',1,'Retail Sale Id 211',9000.00,0.00,0.00,12.50,862.50,'2023-01-25 13:54:29','',''),(218,'1','310','1',1,'Retail Sale Id 212',18000.00,0.00,0.00,25.00,1725.00,'2023-01-25 14:13:30','',''),(219,'1','310','1',1,'Retail Sale Id 213',9000.00,0.00,0.00,12.50,862.50,'2023-01-25 14:14:27','',''),(220,'1','310','1',1,'Retail Sale Id 214',4320.00,0.00,0.00,6.00,414.00,'2023-01-25 14:15:58','',''),(221,'1','310','1',1,'Retail Sale Id 215',799.20,0.00,0.00,1.11,76.59,'2023-01-25 14:17:45','',''),(222,'1','310','1',1,'Retail Sale Id 216',1000.80,0.00,0.00,1.39,95.91,'2023-01-25 14:20:54','',''),(223,'1','310','1',1,'Retail Sale Id 217',4399.20,0.00,0.00,6.11,421.59,'2023-01-25 14:29:15','',''),(224,'1','310','1',1,'Retail Sale Id 217',9000.00,0.00,0.00,12.50,862.50,'2023-01-25 14:29:15','',''),(225,'1','310','1',1,'Retail Sale Id 218',4320.00,0.00,0.00,6.00,414.00,'2023-01-25 14:33:27','',''),(226,'1','310','1',1,'Retail Sale Id 218',6480.00,0.00,0.00,9.00,621.00,'2023-01-25 14:33:27','',''),(227,'1','310','1',1,'Retail Sale Id 219',1000.80,0.00,0.00,1.39,95.91,'2023-01-25 14:34:27','',''),(228,'1','310','1',1,'Retail Sale Id 220',799.20,0.00,0.00,1.11,76.59,'2023-01-25 14:41:23','',''),(229,'1','310','1',1,'Retail Sale Id 221',3600.00,0.00,0.00,5.00,345.00,'2023-01-25 14:53:47','',''),(230,'1','310','1',1,'Retail Sale Id 222',799.20,0.00,0.00,1.11,76.59,'2023-01-25 15:01:36','',''),(231,'1','310','1',1,'Retail Sale Id 223',1000.80,0.00,0.00,1.39,95.91,'2023-01-25 15:02:22','',''),(232,'1','310','1',1,'Retail Sale Id 224',7200.00,0.00,0.00,10.00,690.00,'2023-01-25 15:14:34','',''),(233,'1','310','1',1,'Retail Sale Id 225',4003.20,0.00,0.00,5.56,383.64,'2023-01-25 15:15:31','',''),(234,'1','310','1',1,'Retail Sale Id 226',1000.80,0.00,0.00,1.39,95.91,'2023-01-25 15:17:48','',''),(235,'1','310','1',1,'Retail Sale Id 227',4320.00,0.00,0.00,6.00,414.00,'2023-01-25 15:20:18','',''),(236,'1','310','1',1,'Retail Sale Id 228',9000.00,0.00,0.00,12.50,862.50,'2023-01-25 15:23:06','',''),(237,'1','310','1',1,'Retail Sale Id 229',2160.00,0.00,0.00,3.00,207.00,'2023-01-25 15:53:09','',''),(238,'1','310','1',1,'Retail Sale Id 229',9000.00,0.00,0.00,12.50,862.50,'2023-01-25 15:53:09','',''),(239,'1','310','1',1,'Retail Sale Id 230',2001.60,0.00,0.00,2.78,191.82,'2023-01-25 15:53:51','',''),(240,'1','310','1',1,'Retail Sale Id 231',4996.80,0.00,0.00,6.94,478.86,'2023-01-25 15:54:34','',''),(241,'1','310','1',1,'Retail Sale Id 232',1497.60,0.00,0.00,2.08,143.52,'2023-01-25 15:55:21','',''),(242,'1','310','1',1,'Retail Sale Id 232',1497.60,0.00,0.00,2.08,143.52,'2023-01-25 15:55:21','',''),(243,'1','310','1',1,'Retail Sale Id 233',2160.00,0.00,0.00,3.00,207.00,'2023-01-25 15:56:03','',''),(244,'1','310','1',1,'Retail Sale Id 234',9000.00,0.00,0.00,12.50,862.50,'2023-01-25 15:56:37','',''),(245,'1','310','1',1,'Retail Sale Id 236',1497.60,0.00,0.00,2.08,143.52,'2023-01-25 16:01:09','',''),(246,'1','310','1',1,'Retail Sale Id 237',70000.00,0.00,0.00,100.00,4900.00,'2023-01-25 16:02:44','',''),(247,'1','310','1',1,'Retail Sale Id 238',1000.80,0.00,0.00,1.39,95.91,'2023-01-25 16:20:31','',''),(248,'1','310','1',1,'Retail Sale Id 239',2160.00,0.00,0.00,3.00,207.00,'2023-01-25 16:23:06','',''),(249,'1','310','1',1,'Retail Sale Id 240',7200.00,0.00,0.00,10.00,690.00,'2023-01-25 16:25:01','',''),(250,'1','310','1',1,'Retail Sale Id 241',4320.00,0.00,0.00,6.00,414.00,'2023-01-25 16:27:13','',''),(251,'1','310','1',1,'Retail Sale Id 241',4320.00,0.00,0.00,6.00,414.00,'2023-01-25 16:27:13','',''),(252,'1','310','1',1,'Retail Sale Id 242',2203.20,0.00,0.00,3.06,211.14,'2023-01-25 16:35:39','',''),(253,'1','310','1',1,'Retail Sale Id 243',698.40,0.00,0.00,0.97,66.93,'2023-01-25 16:37:45','',''),(254,'1','310','1',1,'Retail Sale Id 244',1000.80,0.00,0.00,1.39,95.91,'2023-01-25 16:54:01','',''),(255,'1','310','1',1,'Retail Sale Id 245',4320.00,0.00,0.00,6.00,414.00,'2023-01-25 16:55:18','',''),(256,'1','310','1',1,'Retail Sale Id 246',1000.80,0.00,0.00,1.39,95.91,'2023-01-25 17:00:40','',''),(257,'1','310','1',1,'Retail Sale Id 247',3600.00,0.00,0.00,5.00,345.00,'2023-01-25 17:02:06','',''),(258,'1','310','1',1,'Retail Sale Id 248',2001.60,0.00,0.00,2.78,191.82,'2023-01-25 17:10:42','',''),(259,'1','310','1',1,'Retail Sale Id 248',9000.00,0.00,0.00,12.50,862.50,'2023-01-25 17:10:42','',''),(260,'1','310','1',1,'Retail Sale Id 249',2001.60,0.00,0.00,2.78,191.82,'2023-01-25 17:11:44','',''),(261,'1','310','1',1,'Retail Sale Id 250',9000.00,0.00,0.00,12.50,862.50,'2023-01-25 17:12:34','',''),(262,'1','310','1',1,'Retail Sale Id 251',1497.60,0.00,0.00,2.08,143.52,'2023-01-25 17:14:58','',''),(263,'1','310','1',1,'Retail Sale Id 252',4320.00,0.00,0.00,6.00,414.00,'2023-01-25 17:22:25','',''),(264,'1','310','1',1,'Retail Sale Id 253',4320.00,0.00,0.00,6.00,414.00,'2023-01-25 17:28:49','',''),(265,'1','310','1',1,'Retail Sale Id 254',3499.20,0.00,0.00,4.86,335.34,'2023-01-25 17:35:08','',''),(266,'1','310','1',1,'Retail Sale Id 255',2498.40,0.00,0.00,3.47,239.43,'2023-01-25 17:36:08','',''),(267,'1','310','1',1,'Retail Sale Id 256',3002.40,0.00,0.00,4.17,287.73,'2023-01-25 17:37:13','',''),(268,'1','310','1',1,'Retail Sale Id 257',1000.80,0.00,0.00,1.39,95.91,'2023-01-25 17:40:14','',''),(269,'1','310','1',1,'Retail Sale Id 257',2203.20,0.00,0.00,3.06,211.14,'2023-01-25 17:40:14','',''),(270,'1','310','1',1,'Retail Sale Id 258',3002.40,0.00,0.00,4.17,287.73,'2023-01-25 17:41:05','',''),(271,'1','310','1',1,'Retail Sale Id 259',2203.20,0.00,0.00,3.06,211.14,'2023-01-25 17:42:46','',''),(272,'1','310','1',1,'Retail Sale Id 260',35000.00,0.00,0.00,50.00,2450.00,'2023-01-25 17:51:10','',''),(273,'1','310','1',1,'Retail Sale Id 261',4348.80,0.00,0.00,6.04,416.76,'2023-01-25 17:52:50','',''),(274,'1','310','1',1,'Retail Sale Id 262',9302.40,0.00,0.00,12.92,891.48,'2023-01-25 17:53:43','',''),(275,'1','310','1',1,'Retail Sale Id 263',496.80,0.00,0.00,0.69,47.61,'2023-01-25 18:08:13','',''),(276,'1','310','1',1,'Retail Sale Id 264',496.80,0.00,0.00,0.69,47.61,'2023-01-25 18:08:51','',''),(277,'1','310','1',1,'Retail Sale Id 265',993.60,0.00,0.00,1.38,95.22,'2023-01-25 18:11:57','',''),(278,'1','310','1',1,'Return of Retail Sale Id 212',0.00,18000.00,25.00,0.00,-1725.00,'2023-01-25 18:39:05','',''),(279,'1','310','1',1,'Retail Sale Id 266',2548.80,0.00,0.00,3.54,244.26,'2023-01-25 18:41:44','',''),(280,'1','310','1',1,'Retail Sale Id 267',2203.20,0.00,0.00,3.06,211.14,'2023-01-26 07:35:46','',''),(281,'1','310','1',1,'Retail Sale Id 268',2901.60,0.00,0.00,4.03,278.07,'2023-01-26 08:49:00','',''),(282,'1','310','1',1,'Retail Sale Id 269',4399.20,0.00,0.00,6.11,421.59,'2023-01-26 08:49:56','',''),(283,'1','310','1',1,'Retail Sale Id 270',3002.40,0.00,0.00,4.17,287.73,'2023-01-26 08:50:49','',''),(284,'1','310','1',1,'Retail Sale Id 272',1303.20,0.00,0.00,1.81,124.89,'2023-01-26 08:52:49','',''),(285,'1','310','1',1,'Retail Sale Id 273',4003.20,0.00,0.00,5.56,383.64,'2023-01-26 08:56:28','',''),(286,'1','310','1',1,'Retail Sale Id 274',2001.60,0.00,0.00,2.78,191.82,'2023-01-26 09:01:00','',''),(287,'1','310','1',1,'Retail Sale Id 275',1000.80,0.00,0.00,1.39,95.91,'2023-01-26 09:02:10','',''),(288,'1','310','1',1,'Retail Sale Id 276',105000.00,0.00,0.00,150.00,7350.00,'2023-01-26 09:11:02','',''),(289,'1','310','1',1,'Retail Sale Id 277',105000.00,0.00,0.00,150.00,7350.00,'2023-01-26 09:11:54','',''),(290,'1','310','1',1,'Retail Sale Id 278',105000.00,0.00,0.00,150.00,7350.00,'2023-01-26 09:12:44','',''),(291,'1','310','1',1,'Retail Sale Id 279',4298.40,0.00,0.00,5.97,411.93,'2023-01-26 09:13:55','',''),(292,'1','310','1',1,'Retail Sale Id 280',2001.60,0.00,0.00,2.78,191.82,'2023-01-26 09:15:35','',''),(293,'1','310','1',1,'Retail Sale Id 281',3002.40,0.00,0.00,4.17,287.73,'2023-01-26 09:16:35','',''),(294,'1','310','1',1,'Retail Sale Id 282',1497.60,0.00,0.00,2.08,143.52,'2023-01-26 09:18:12','',''),(295,'1','310','1',1,'Retail Sale Id 283',496.80,0.00,0.00,0.69,47.61,'2023-01-26 09:19:29','',''),(296,'1','310','1',1,'Retail Sale Id 283',1000.80,0.00,0.00,1.39,95.91,'2023-01-26 09:19:29','',''),(297,'1','310','1',1,'Retail Sale Id 284',4399.20,0.00,0.00,6.11,421.59,'2023-01-26 09:20:57','',''),(298,'1','310','1',1,'Retail Sale Id 285',1000.80,0.00,0.00,1.39,95.91,'2023-01-26 09:22:33','',''),(299,'1','310','1',1,'Retail Sale Id 286',4399.20,0.00,0.00,6.11,421.59,'2023-01-26 09:25:00','',''),(300,'1','310','1',1,'Retail Sale Id 287',1000.80,0.00,0.00,1.39,95.91,'2023-01-26 09:26:43','',''),(301,'1','310','1',1,'Retail Sale Id 288',1000.80,0.00,0.00,1.39,95.91,'2023-01-26 09:28:02','',''),(302,'1','310','1',1,'Retail Sale Id 289',4320.00,0.00,0.00,6.00,414.00,'2023-01-26 09:53:10','',''),(303,'1','310','1',1,'Retail Sale Id 290',4399.20,0.00,0.00,6.11,421.59,'2023-01-26 09:54:49','',''),(304,'1','310','1',1,'Retail Sale Id 291',4996.80,0.00,0.00,6.94,478.86,'2023-01-26 10:04:20','',''),(305,'1','310','1',1,'Retail Sale Id 292',3002.40,0.00,0.00,4.17,287.73,'2023-01-26 10:12:31','',''),(306,'1','310','1',1,'Retail Sale Id 293',2203.20,0.00,0.00,3.06,211.14,'2023-01-26 10:15:54','',''),(307,'1','310','1',1,'Retail Sale Id 294',2001.60,0.00,0.00,2.78,191.82,'2023-01-26 10:24:11','',''),(308,'1','310','1',1,'Retail Sale Id 295',3700.80,0.00,0.00,5.14,354.66,'2023-01-26 10:25:26','',''),(309,'1','310','1',1,'Retail Sale Id 297',4500.00,0.00,0.00,6.25,431.25,'2023-01-26 10:27:54','',''),(310,'1','310','1',1,'Retail Sale Id 298',9000.00,0.00,0.00,12.50,862.50,'2023-01-26 10:36:07','',''),(311,'1','310','1',1,'Retail Sale Id 299',4399.20,0.00,0.00,6.11,421.59,'2023-01-26 11:08:49','',''),(312,'1','310','1',1,'Retail Sale Id 300',1101.60,0.00,0.00,1.53,105.57,'2023-01-26 11:10:02','',''),(313,'1','310','1',1,'Retail Sale Id 301',4399.20,0.00,0.00,6.11,421.59,'2023-01-26 11:19:23','',''),(314,'1','310','1',1,'Retail Sale Id 302',9000.00,0.00,0.00,12.50,862.50,'2023-01-26 11:20:24','',''),(315,'1','310','1',1,'Retail Sale Id 303',3002.40,0.00,0.00,4.17,287.73,'2023-01-26 11:22:23','',''),(316,'1','310','1',1,'Retail Sale Id 304',3002.40,0.00,0.00,4.17,287.73,'2023-01-26 11:23:59','',''),(317,'1','310','1',1,'Retail Sale Id 305',2203.20,0.00,0.00,3.06,211.14,'2023-01-26 11:24:54','',''),(318,'1','310','1',1,'Retail Sale Id 306',1497.60,0.00,0.00,2.08,143.52,'2023-01-26 11:28:05','',''),(319,'1','310','1',1,'Retail Sale Id 307',1396.80,0.00,0.00,1.94,133.86,'2023-01-26 11:31:43','',''),(320,'1','310','1',1,'Retail Sale Id 308',3002.40,0.00,0.00,4.17,287.73,'2023-01-26 11:32:57','',''),(321,'1','310','1',1,'Retail Sale Id 309',9000.00,0.00,0.00,12.50,862.50,'2023-01-26 11:36:32','',''),(322,'1','310','1',1,'Retail Sale Id 310',7999.20,0.00,0.00,11.11,766.59,'2023-01-26 11:41:07','',''),(323,'1','310','1',1,'Retail Sale Id 311',1497.60,0.00,0.00,2.08,143.52,'2023-01-26 11:42:33','',''),(324,'1','310','1',1,'Retail Sale Id 312',2001.60,0.00,0.00,2.78,191.82,'2023-01-26 11:53:33','',''),(325,'1','310','1',1,'Retail Sale Id 313',1000.80,0.00,0.00,1.39,95.91,'2023-01-26 12:02:20','',''),(326,'1','310','1',1,'Retail Sale Id 314',3002.40,0.00,0.00,4.17,287.73,'2023-01-26 12:06:43','',''),(327,'1','310','1',1,'Retail Sale Id 315',3002.40,0.00,0.00,4.17,287.73,'2023-01-26 12:08:10','',''),(328,'1','310','1',1,'Retail Sale Id 316',4399.20,0.00,0.00,6.11,421.59,'2023-01-26 12:16:49','',''),(329,'1','310','1',1,'Retail Sale Id 317',4500.00,0.00,0.00,6.25,431.25,'2023-01-26 12:47:49','',''),(330,'1','310','1',1,'Retail Sale Id 318',9000.00,0.00,0.00,12.50,862.50,'2023-01-26 13:09:33','',''),(331,'1','310','1',1,'Retail Sale Id 319',2001.60,0.00,0.00,2.78,191.82,'2023-01-26 13:10:52','',''),(332,'1','310','1',1,'Retail Sale Id 320',3002.40,0.00,0.00,4.17,287.73,'2023-01-26 13:32:02','',''),(333,'1','310','1',1,'Retail Sale Id 321',2203.20,0.00,0.00,3.06,211.14,'2023-01-26 13:37:52','',''),(334,'1','310','1',1,'Retail Sale Id 322',2001.60,0.00,0.00,2.78,191.82,'2023-01-26 13:39:10','',''),(335,'1','310','1',1,'Retail Sale Id 323',77000.00,0.00,0.00,110.00,5390.00,'2023-01-26 13:55:58','',''),(336,'1','310','1',1,'Retail Sale Id 324',2001.60,0.00,0.00,2.78,191.82,'2023-01-26 14:03:09','',''),(337,'1','310','1',1,'Retail Sale Id 325',4320.00,0.00,0.00,6.00,414.00,'2023-01-26 14:11:11','',''),(338,'1','310','1',1,'Retail Sale Id 326',1497.60,0.00,0.00,2.08,143.52,'2023-01-26 14:14:22','',''),(339,'1','310','1',1,'Retail Sale Id 327',1497.60,0.00,0.00,2.08,143.52,'2023-01-26 14:24:59','',''),(340,'1','310','1',1,'Retail Sale Id 328',2001.60,0.00,0.00,2.78,191.82,'2023-01-26 14:34:07','',''),(341,'1','310','1',1,'Retail Sale Id 329',1000.80,0.00,0.00,1.39,95.91,'2023-01-26 14:40:12','',''),(342,'1','310','1',1,'Retail Sale Id 330',4802.40,0.00,0.00,6.67,460.23,'2023-01-26 14:41:13','',''),(343,'1','310','1',1,'Retail Sale Id 331',547.20,0.00,0.00,0.76,52.44,'2023-01-26 14:42:48','',''),(344,'1','310','1',1,'Retail Sale Id 332',35000.00,0.00,0.00,50.00,2450.00,'2023-01-26 14:48:43','',''),(345,'1','310','1',1,'Retail Sale Id 333',3002.40,0.00,0.00,4.17,287.73,'2023-01-26 15:11:54','',''),(346,'1','310','1',1,'Retail Sale Id 334',2001.60,0.00,0.00,2.78,191.82,'2023-01-26 15:12:47','',''),(347,'1','310','1',1,'Retail Sale Id 335',2001.60,0.00,0.00,2.78,191.82,'2023-01-26 15:15:34','',''),(348,'1','310','1',1,'Retail Sale Id 336',309.60,0.00,0.00,0.43,29.67,'2023-01-26 15:16:33','',''),(349,'1','310','1',1,'Retail Sale Id 337',4399.20,0.00,0.00,6.11,421.59,'2023-01-26 15:57:58','',''),(350,'1','310','1',1,'Retail Sale Id 338',2001.60,0.00,0.00,2.78,191.82,'2023-01-26 16:12:07','',''),(351,'1','310','1',1,'Retail Sale Id 339',3600.00,0.00,0.00,5.00,345.00,'2023-01-26 16:14:20','',''),(352,'1','310','1',1,'Retail Sale Id 340',1000.80,0.00,0.00,1.39,95.91,'2023-01-26 16:36:16','',''),(353,'1','310','1',1,'Retail Sale Id 341',1447.20,0.00,0.00,2.01,138.69,'2023-01-26 16:43:32','',''),(354,'1','310','1',1,'Retail Sale Id 342',1497.60,0.00,0.00,2.08,143.52,'2023-01-26 16:53:18','',''),(355,'1','310','1',1,'Retail Sale Id 343',1800.00,0.00,0.00,2.50,172.50,'2023-01-26 17:15:23','',''),(356,'1','310','1',1,'Retail Sale Id 344',6501.60,0.00,0.00,9.03,623.07,'2023-01-26 17:22:39','',''),(357,'1','310','1',1,'Retail Sale Id 345',698.40,0.00,0.00,0.97,66.93,'2023-01-26 17:25:43','',''),(358,'1','310','1',1,'Retail Sale Id 346',4399.20,0.00,0.00,6.11,421.59,'2023-01-26 17:27:13','',''),(359,'1','310','1',1,'Retail Sale Id 347',4399.20,0.00,0.00,6.11,421.59,'2023-01-26 17:34:24','',''),(360,'1','310','1',1,'Retail Sale Id 348',35000.00,0.00,0.00,50.00,2450.00,'2023-01-26 17:39:14','',''),(361,'1','310','1',1,'Retail Sale Id 349',1000.80,0.00,0.00,1.39,95.91,'2023-01-26 17:40:18','',''),(362,'1','310','1',1,'Retail Sale Id 350',2498.40,0.00,0.00,3.47,239.43,'2023-01-26 17:42:25','',''),(363,'1','310','1',1,'Retail Sale Id 351',1000.80,0.00,0.00,1.39,95.91,'2023-01-26 17:43:54','',''),(364,'1','310','1',1,'Retail Sale Id 352',3002.40,0.00,0.00,4.17,287.73,'2023-01-26 17:44:49','',''),(365,'1','310','1',1,'Retail Sale Id 353',3600.00,0.00,0.00,5.00,345.00,'2023-01-26 17:46:38','',''),(366,'1','310','1',1,'Retail Sale Id 354',2203.20,0.00,0.00,3.06,211.14,'2023-01-26 17:47:24','',''),(367,'1','310','1',1,'Retail Sale Id 355',2203.20,0.00,0.00,3.06,211.14,'2023-01-26 17:50:39','',''),(368,'1','310','1',1,'Retail Sale Id 356',3002.40,0.00,0.00,4.17,287.73,'2023-01-26 18:00:29','',''),(369,'1','310','1',1,'Retail Sale Id 357',2001.60,0.00,0.00,2.78,191.82,'2023-01-26 18:08:19','',''),(370,'1','310','1',1,'Retail Sale Id 357',2001.60,0.00,0.00,2.78,191.82,'2023-01-26 18:08:19','',''),(371,'1','310','1',1,'Retail Sale Id 358',4003.20,0.00,0.00,5.56,383.64,'2023-01-26 18:13:28','',''),(372,'1','310','1',1,'Retail Sale Id 358',9000.00,0.00,0.00,12.50,862.50,'2023-01-26 18:13:28','',''),(373,'1','310','1',1,'Retail Sale Id 359',4399.20,0.00,0.00,6.11,421.59,'2023-01-26 18:14:49','',''),(374,'1','310','1',1,'Retail Sale Id 359',9000.00,0.00,0.00,12.50,862.50,'2023-01-26 18:14:49','',''),(375,'1','310','1',1,'Retail Sale Id 360',14000.00,0.00,0.00,20.00,980.00,'2023-01-26 19:02:00','',''),(376,'1','310','1',1,'Return of Retail Sale Id 357',0.00,2001.60,2.78,0.00,-191.82,'2023-01-26 19:04:25','',''),(377,'1','310','1',1,'Return of Retail Sale Id 357',0.00,2001.60,2.78,0.00,-191.82,'2023-01-26 19:04:25','',''),(378,'1','310','1',1,'Retail Sale Id 361',842.40,0.00,0.00,1.17,80.73,'2023-01-26 19:05:33','',''),(379,'1','310','1',1,'Retail Sale Id 362',496.80,0.00,0.00,0.69,47.61,'2023-01-27 08:01:49','',''),(380,'1','310','1',1,'Retail Sale Id 362',9000.00,0.00,0.00,12.50,862.50,'2023-01-27 08:01:49','',''),(381,'1','310','1',1,'Retail Sale Id 363',3600.00,0.00,0.00,5.00,345.00,'2023-01-27 08:09:04','',''),(382,'1','310','1',1,'Retail Sale Id 364',4003.20,0.00,0.00,5.56,383.64,'2023-01-27 08:46:29','',''),(383,'1','310','1',1,'Retail Sale Id 365',3499.20,0.00,0.00,4.86,335.34,'2023-01-27 08:50:55','',''),(384,'1','310','1',1,'Retail Sale Id 366',60900.00,0.00,0.00,87.00,4263.00,'2023-01-27 08:57:42','',''),(385,'1','310','1',1,'Retail Sale Id 367',1000.80,0.00,0.00,1.39,95.91,'2023-01-27 09:03:34','',''),(386,'1','310','1',1,'Retail Sale Id 368',35000.00,0.00,0.00,50.00,2450.00,'2023-01-27 09:07:29','',''),(387,'1','310','1',1,'Retail Sale Id 369',35000.00,0.00,0.00,50.00,2450.00,'2023-01-27 09:08:11','',''),(388,'1','310','1',1,'Retail Sale Id 370',35000.00,0.00,0.00,50.00,2450.00,'2023-01-27 09:09:19','',''),(389,'1','310','1',1,'Retail Sale Id 371',4320.00,0.00,0.00,6.00,414.00,'2023-01-27 09:18:18','',''),(390,'1','310','1',1,'Retail Sale Id 372',1000.80,0.00,0.00,1.39,95.91,'2023-01-27 09:21:03','',''),(391,'1','310','1',1,'Retail Sale Id 373',1440.00,0.00,0.00,2.00,138.00,'2023-01-27 09:34:15','',''),(392,'1','310','1',1,'Retail Sale Id 374',2880.00,0.00,0.00,4.00,276.00,'2023-01-27 09:42:22','',''),(393,'1','310','1',1,'Retail Sale Id 375',4320.00,0.00,0.00,6.00,414.00,'2023-01-27 09:43:39','',''),(394,'1','310','1',1,'Retail Sale Id 376',7000.00,0.00,0.00,10.00,490.00,'2023-01-27 09:44:57','',''),(395,'1','310','1',1,'Retail Sale Id 377',2203.20,0.00,0.00,3.06,211.14,'2023-01-27 09:48:50','',''),(396,'1','310','1',1,'Retail Sale Id 378',5500.80,0.00,0.00,7.64,527.16,'2023-01-27 09:55:30','',''),(397,'1','310','1',1,'Retail Sale Id 380',4320.00,0.00,0.00,6.00,414.00,'2023-01-27 09:58:13','',''),(398,'1','310','1',1,'Retail Sale Id 381',76300.00,0.00,0.00,109.00,5341.00,'2023-01-27 09:59:18','',''),(399,'1','310','1',1,'Retail Sale Id 382',3600.00,0.00,0.00,5.00,345.00,'2023-01-27 10:04:32','',''),(400,'1','310','1',1,'Retail Sale Id 383',15001.00,0.00,0.00,21.43,1050.07,'2023-01-27 10:09:41','',''),(401,'1','310','1',1,'Retail Sale Id 384',1202.40,0.00,0.00,1.67,115.23,'2023-01-27 10:11:10','',''),(402,'1','310','1',1,'Retail Sale Id 385',2498.40,0.00,0.00,3.47,239.43,'2023-01-27 10:16:53','',''),(403,'1','310','1',1,'Retail Sale Id 385',9000.00,0.00,0.00,12.50,862.50,'2023-01-27 10:16:53','',''),(404,'1','310','1',1,'Retail Sale Id 386',4320.00,0.00,0.00,6.00,414.00,'2023-01-27 10:30:05','',''),(405,'1','310','1',1,'Retail Sale Id 387',4320.00,0.00,0.00,6.00,414.00,'2023-01-27 10:32:58','',''),(406,'1','310','1',1,'Retail Sale Id 388',2001.60,0.00,0.00,2.78,191.82,'2023-01-27 10:35:29','',''),(407,'1','310','1',1,'Retail Sale Id 389',4399.20,0.00,0.00,6.11,421.59,'2023-01-27 10:39:51','',''),(408,'1','310','1',1,'Retail Sale Id 390',2203.20,0.00,0.00,3.06,211.14,'2023-01-27 10:42:07','',''),(409,'1','310','1',1,'Retail Sale Id 391',105000.00,0.00,0.00,150.00,7350.00,'2023-01-27 10:56:30','',''),(410,'1','310','1',1,'Retail Sale Id 392',105000.00,0.00,0.00,150.00,7350.00,'2023-01-27 10:57:17','',''),(411,'1','310','1',1,'Retail Sale Id 393',105000.00,0.00,0.00,150.00,7350.00,'2023-01-27 10:58:19','',''),(412,'1','310','1',1,'Retail Sale Id 394',84000.00,0.00,0.00,120.00,5880.00,'2023-01-27 10:59:50','',''),(413,'1','310','1',1,'Retail Sale Id 395',35000.00,0.00,0.00,50.00,2450.00,'2023-01-27 11:01:14','',''),(414,'1','310','1',1,'Retail Sale Id 396',35000.00,0.00,0.00,50.00,2450.00,'2023-01-27 11:02:08','',''),(415,'1','310','1',1,'Retail Sale Id 397',35000.00,0.00,0.00,50.00,2450.00,'2023-01-27 11:02:50','',''),(416,'1','310','1',1,'Retail Sale Id 398',4320.00,0.00,0.00,6.00,414.00,'2023-01-27 11:04:52','',''),(417,'1','310','1',1,'Retail Sale Id 399',1497.60,0.00,0.00,2.08,143.52,'2023-01-27 11:05:48','',''),(418,'1','310','1',1,'Retail Sale Id 400',2203.20,0.00,0.00,3.06,211.14,'2023-01-27 11:07:29','',''),(419,'1','310','1',1,'Retail Sale Id 401',799.20,0.00,0.00,1.11,76.59,'2023-01-27 11:16:08','',''),(420,'1','310','1',1,'Retail Sale Id 402',4996.80,0.00,0.00,6.94,478.86,'2023-01-27 11:17:06','',''),(421,'1','310','1',1,'Retail Sale Id 403',4320.00,0.00,0.00,6.00,414.00,'2023-01-27 11:21:45','',''),(422,'1','310','1',1,'Retail Sale Id 404',7000.00,0.00,0.00,10.00,490.00,'2023-01-27 11:28:37','',''),(423,'1','310','1',1,'Retail Sale Id 405',4200.00,0.00,0.00,6.00,294.00,'2023-01-27 11:29:56','',''),(424,'1','310','1',1,'Retail Sale Id 406',1000.80,0.00,0.00,1.39,95.91,'2023-01-27 11:42:28','',''),(425,'1','310','1',1,'Retail Sale Id 407',3600.00,0.00,0.00,5.00,345.00,'2023-01-27 11:44:49','',''),(426,'1','310','1',1,'Retail Sale Id 408',42000.00,0.00,0.00,60.00,2940.00,'2023-01-27 11:52:45','',''),(427,'1','310','1',1,'Retail Sale Id 409',11403.00,0.00,0.00,16.29,798.21,'2023-01-27 11:56:09','',''),(428,'1','310','1',1,'Retail Sale Id 410',42000.00,0.00,0.00,60.00,2940.00,'2023-01-27 11:57:28','',''),(429,'1','310','1',1,'Retail Sale Id 412',1000.80,0.00,0.00,1.39,95.91,'2023-01-27 12:12:31','',''),(430,'1','310','1',1,'Retail Sale Id 413',9000.00,0.00,0.00,12.50,862.50,'2023-01-27 12:20:04','',''),(431,'1','310','1',1,'Retail Sale Id 414',4320.00,0.00,0.00,6.00,414.00,'2023-01-27 12:21:55','',''),(432,'1','310','1',1,'Retail Sale Id 415',3002.40,0.00,0.00,4.17,287.73,'2023-01-27 12:44:50','',''),(433,'1','310','1',1,'Retail Sale Id 416',7999.20,0.00,0.00,11.11,766.59,'2023-01-27 12:47:12','',''),(434,'1','310','1',1,'Retail Sale Id 417',4996.80,0.00,0.00,6.94,478.86,'2023-01-27 12:48:55','',''),(435,'1','310','1',1,'Retail Sale Id 418',3002.40,0.00,0.00,4.17,287.73,'2023-01-27 13:00:14','',''),(436,'1','310','1',1,'Retail Sale Id 419',2203.20,0.00,0.00,3.06,211.14,'2023-01-27 13:09:38','',''),(437,'1','310','1',1,'Retail Sale Id 420',70000.00,0.00,0.00,100.00,4900.00,'2023-01-27 13:42:35','',''),(438,'1','310','1',1,'Retail Sale Id 421',70000.00,0.00,0.00,100.00,4900.00,'2023-01-27 13:43:46','',''),(439,'1','310','1',1,'Retail Sale Id 422',2001.60,0.00,0.00,2.78,191.82,'2023-01-27 14:14:18','',''),(440,'1','310','1',1,'Retail Sale Id 423',1000.80,0.00,0.00,1.39,95.91,'2023-01-27 14:24:41','',''),(441,'1','310','1',1,'Retail Sale Id 423',3002.40,0.00,0.00,4.17,287.73,'2023-01-27 14:24:41','',''),(442,'1','310','1',1,'Retail Sale Id 424',175000.00,0.00,0.00,250.00,12250.00,'2023-01-27 14:38:25','',''),(443,'1','310','1',1,'Retail Sale Id 425',2001.60,0.00,0.00,2.78,191.82,'2023-01-27 14:41:51','',''),(444,'1','310','1',1,'Retail Sale Id 426',3002.40,0.00,0.00,4.17,287.73,'2023-01-27 14:43:25','',''),(445,'1','310','1',1,'Retail Sale Id 427',7200.00,0.00,0.00,10.00,690.00,'2023-01-27 14:45:51','',''),(446,'1','310','1',1,'Retail Sale Id 428',1497.60,0.00,0.00,2.08,143.52,'2023-01-27 15:02:51','',''),(447,'1','310','1',1,'Retail Sale Id 429',2001.60,0.00,0.00,2.78,191.82,'2023-01-27 15:17:03','',''),(448,'1','310','1',1,'Retail Sale Id 430',7200.00,0.00,0.00,10.00,690.00,'2023-01-27 15:21:09','',''),(449,'1','310','1',1,'Retail Sale Id 430',7200.00,0.00,0.00,10.00,690.00,'2023-01-27 15:21:09','',''),(450,'1','310','1',1,'Retail Sale Id 431',799.20,0.00,0.00,1.11,76.59,'2023-01-27 15:40:34','',''),(451,'1','310','1',1,'Retail Sale Id 432',4399.20,0.00,0.00,6.11,421.59,'2023-01-27 15:51:49','',''),(452,'1','310','1',1,'Retail Sale Id 433',1699.20,0.00,0.00,2.36,162.84,'2023-01-27 15:57:39','',''),(453,'1','310','1',1,'Retail Sale Id 434',4003.20,0.00,0.00,5.56,383.64,'2023-01-27 16:03:18','',''),(454,'1','310','1',1,'Retail Sale Id 436',3002.40,0.00,0.00,4.17,287.73,'2023-01-27 16:43:20','',''),(455,'1','310','1',1,'Retail Sale Id 437',496.80,0.00,0.00,0.69,47.61,'2023-01-27 16:44:30','',''),(456,'1','310','1',1,'Retail Sale Id 438',2001.60,0.00,0.00,2.78,191.82,'2023-01-27 16:47:01','',''),(457,'1','310','1',1,'Retail Sale Id 439',9000.00,0.00,0.00,12.50,862.50,'2023-01-27 16:51:22','',''),(458,'1','310','1',1,'Retail Sale Id 440',2160.00,0.00,0.00,3.00,207.00,'2023-01-27 16:52:17','',''),(459,'1','310','1',1,'Retail Sale Id 440',4320.00,0.00,0.00,6.00,414.00,'2023-01-27 16:52:17','',''),(460,'1','310','1',1,'Retail Sale Id 441',1000.80,0.00,0.00,1.39,95.91,'2023-01-27 16:57:47','',''),(461,'1','310','1',1,'Retail Sale Id 442',35000.00,0.00,0.00,50.00,2450.00,'2023-01-27 17:03:47','',''),(462,'1','310','1',1,'Retail Sale Id 443',2203.20,0.00,0.00,3.06,211.14,'2023-01-27 17:05:58','',''),(463,'1','310','1',1,'Retail Sale Id 444',3600.00,0.00,0.00,5.00,345.00,'2023-01-27 17:11:38','',''),(464,'1','310','1',1,'Retail Sale Id 445',4399.20,0.00,0.00,6.11,421.59,'2023-01-27 17:12:36','',''),(465,'1','310','1',1,'Retail Sale Id 447',4500.00,0.00,0.00,6.25,431.25,'2023-01-27 17:15:52','',''),(466,'1','310','1',1,'Retail Sale Id 448',1497.60,0.00,0.00,2.08,143.52,'2023-01-27 17:16:45','',''),(467,'1','310','1',1,'Retail Sale Id 449',1497.60,0.00,0.00,2.08,143.52,'2023-01-27 17:17:33','',''),(468,'1','310','1',1,'Retail Sale Id 450',3002.40,0.00,0.00,4.17,287.73,'2023-01-27 17:23:23','',''),(469,'1','310','1',1,'Retail Sale Id 451',1000.80,0.00,0.00,1.39,95.91,'2023-01-27 17:31:14','',''),(470,'1','310','1',1,'Retail Sale Id 452',2203.20,0.00,0.00,3.06,211.14,'2023-01-27 17:39:44','',''),(471,'1','310','1',1,'Retail Sale Id 453',1000.80,0.00,0.00,1.39,95.91,'2023-01-27 17:41:32','',''),(472,'1','310','1',1,'Retail Sale Id 454',2001.60,0.00,0.00,2.78,191.82,'2023-01-27 17:44:51','',''),(473,'1','310','1',1,'Retail Sale Id 455',4197.60,0.00,0.00,5.83,402.27,'2023-01-27 17:52:03','',''),(474,'1','310','1',1,'Retail Sale Id 456',4399.20,0.00,0.00,6.11,421.59,'2023-01-27 18:00:27','',''),(475,'1','310','1',1,'Retail Sale Id 458',2160.00,0.00,0.00,3.00,207.00,'2023-01-27 18:05:39','',''),(476,'1','310','1',1,'Retail Sale Id 458',2160.00,0.00,0.00,3.00,207.00,'2023-01-27 18:05:39','',''),(477,'1','310','1',1,'Retail Sale Id 459',1000.80,0.00,0.00,1.39,95.91,'2023-01-27 18:09:07','',''),(478,'1','310','1',1,'Retail Sale Id 460',1000.80,0.00,0.00,1.39,95.91,'2023-01-27 18:22:01','',''),(479,'1','310','1',1,'Retail Sale Id 460',1000.80,0.00,0.00,1.39,95.91,'2023-01-27 18:22:01','',''),(480,'1','310','1',1,'Retail Sale Id 461',1000.80,0.00,0.00,1.39,95.91,'2023-01-27 18:23:14','',''),(481,'1','310','1',1,'Retail Sale Id 461',1000.80,0.00,0.00,1.39,95.91,'2023-01-27 18:23:14','',''),(482,'1','310','1',1,'Retail Sale Id 462',3002.40,0.00,0.00,4.17,287.73,'2023-01-27 18:24:10','',''),(483,'1','310','1',1,'Retail Sale Id 463',799.20,0.00,0.00,1.11,76.59,'2023-01-27 18:24:55','',''),(484,'1','310','1',1,'Retail Sale Id 464',9000.00,0.00,0.00,12.50,862.50,'2023-01-27 18:25:41','',''),(485,'1','310','1',1,'Retail Sale Id 465',1699.20,0.00,0.00,2.36,162.84,'2023-01-27 18:26:24','',''),(486,'1','310','1',1,'Retail Sale Id 466',9000.00,0.00,0.00,12.50,862.50,'2023-01-27 18:27:17','',''),(487,'1','310','1',1,'Retail Sale Id 467',2001.60,0.00,0.00,2.78,191.82,'2023-01-27 18:30:13','',''),(488,'1','310','1',1,'Return of Retail Sale Id 460',0.00,1000.80,1.39,0.00,-95.91,'2023-01-27 18:52:35','',''),(489,'1','310','1',1,'Return of Retail Sale Id 460',0.00,1000.80,1.39,0.00,-95.91,'2023-01-27 18:52:35','',''),(490,'1','310','1',1,'Retail Sale Id 468',49700.00,0.00,0.00,71.00,3479.00,'2023-01-27 18:54:23','',''),(491,'1','310','1',1,'Return of Retail Sale Id 468',0.00,49700.00,71.00,0.00,-3479.00,'2023-01-27 18:54:36','',''),(492,'1','310','1',1,'Retail Sale Id 470',360.00,0.00,0.00,0.50,34.50,'2023-01-27 18:56:29','',''),(493,'1','310','1',1,'Return of Retail Sale Id 470',0.00,360.00,0.50,0.00,-34.50,'2023-01-27 18:56:47','',''),(494,'1','310','1',1,'Return of Retail Sale Id 467',0.00,2001.60,2.78,0.00,-191.82,'2023-01-27 18:57:14','',''),(495,'1','310','1',1,'Return of Retail Sale Id 409',0.00,11403.00,16.29,0.00,-798.21,'2023-01-27 19:04:50','',''),(496,'1','310','1',1,'Retail Sale Id 471',10486.00,0.00,0.00,14.98,734.02,'2023-01-27 19:05:44','',''),(497,'1','310','1',1,'Retail Sale Id 472',1641.60,0.00,0.00,2.28,157.32,'2023-01-27 19:06:28','',''),(498,'1','310','1',1,'Retail Sale Id 473',9000.00,0.00,0.00,12.50,862.50,'2023-01-28 09:52:11','',''),(499,'1','310','1',1,'Retail Sale Id 473',9000.00,0.00,0.00,12.50,862.50,'2023-01-28 09:52:11','',''),(500,'1','310','1',1,'Retail Sale Id 474',4320.00,0.00,0.00,6.00,414.00,'2023-01-28 10:16:22','',''),(501,'1','310','1',1,'Retail Sale Id 475',4500.00,0.00,0.00,6.25,431.25,'2023-01-28 10:19:51','',''),(502,'1','310','1',1,'Retail Sale Id 476',2160.00,0.00,0.00,3.00,207.00,'2023-01-28 10:27:15','',''),(503,'1','310','1',1,'Retail Sale Id 477',1000.80,0.00,0.00,1.39,95.91,'2023-01-28 10:29:07','',''),(504,'1','310','1',1,'Retail Sale Id 478',9000.00,0.00,0.00,12.50,862.50,'2023-01-28 10:31:44','',''),(505,'1','310','1',1,'Retail Sale Id 478',9000.00,0.00,0.00,12.50,862.50,'2023-01-28 10:31:44','',''),(506,'1','310','1',1,'Retail Sale Id 479',1000.80,0.00,0.00,1.39,95.91,'2023-01-28 10:42:43','',''),(507,'1','310','1',1,'Retail Sale Id 480',38500.00,0.00,0.00,55.00,2695.00,'2023-01-28 10:53:29','',''),(508,'1','310','1',1,'Retail Sale Id 481',38500.00,0.00,0.00,55.00,2695.00,'2023-01-28 10:54:43','',''),(509,'1','310','1',1,'Retail Sale Id 482',234500.00,0.00,0.00,335.00,16415.00,'2023-01-28 10:56:19','',''),(510,'1','310','1',1,'Retail Sale Id 483',2001.60,0.00,0.00,2.78,191.82,'2023-01-28 10:58:32','',''),(511,'1','310','1',1,'Retail Sale Id 484',2001.60,0.00,0.00,2.78,191.82,'2023-01-28 10:59:21','',''),(512,'1','310','1',1,'Retail Sale Id 485',4500.00,0.00,0.00,6.25,431.25,'2023-01-28 11:07:27','',''),(513,'1','310','1',1,'Retail Sale Id 486',4320.00,0.00,0.00,6.00,414.00,'2023-01-28 11:08:59','',''),(514,'1','310','1',1,'Retail Sale Id 488',3600.00,0.00,0.00,5.00,345.00,'2023-01-28 11:12:14','',''),(515,'1','310','1',1,'Retail Sale Id 488',4320.00,0.00,0.00,6.00,414.00,'2023-01-28 11:12:14','',''),(516,'1','310','1',1,'Retail Sale Id 489',2102.40,0.00,0.00,2.92,201.48,'2023-01-28 11:13:36','',''),(517,'1','310','1',1,'Retail Sale Id 490',4500.00,0.00,0.00,6.25,431.25,'2023-01-28 11:14:50','',''),(518,'1','310','1',1,'Retail Sale Id 491',4320.00,0.00,0.00,6.00,414.00,'2023-01-28 11:17:33','',''),(519,'1','310','1',1,'Retail Sale Id 492',1900.80,0.00,0.00,2.64,182.16,'2023-01-28 11:18:25','',''),(520,'1','310','1',1,'Retail Sale Id 493',1497.60,0.00,0.00,2.08,143.52,'2023-01-28 11:26:48','',''),(521,'1','310','1',1,'Retail Sale Id 495',1396.80,0.00,0.00,1.94,133.86,'2023-01-28 11:29:21','',''),(522,'1','310','1',1,'Retail Sale Id 497',42000.00,0.00,0.00,60.00,2940.00,'2023-01-28 11:32:24','',''),(523,'1','310','1',1,'Retail Sale Id 498',2203.20,0.00,0.00,3.06,211.14,'2023-01-28 11:34:18','',''),(524,'1','310','1',1,'Retail Sale Id 499',2203.20,0.00,0.00,3.06,211.14,'2023-01-28 11:45:59','',''),(525,'1','310','1',1,'Retail Sale Id 500',4500.00,0.00,0.00,6.25,431.25,'2023-01-28 11:53:55','',''),(526,'1','310','1',1,'Retail Sale Id 501',1497.60,0.00,0.00,2.08,143.52,'2023-01-28 11:54:56','',''),(527,'1','310','1',1,'Retail Sale Id 502',4399.20,0.00,0.00,6.11,421.59,'2023-01-28 12:01:53','',''),(528,'1','310','1',1,'Retail Sale Id 503',1000.80,0.00,0.00,1.39,95.91,'2023-01-28 12:02:45','',''),(529,'1','310','1',1,'Retail Sale Id 505',9000.00,0.00,0.00,12.50,862.50,'2023-01-28 12:15:09','',''),(530,'1','310','1',1,'Retail Sale Id 506',1000.80,0.00,0.00,1.39,95.91,'2023-01-28 12:23:01','',''),(531,'1','310','1',1,'Retail Sale Id 507',720.00,0.00,0.00,1.00,69.00,'2023-01-28 12:24:57','',''),(532,'1','310','1',1,'Retail Sale Id 508',9000.00,0.00,0.00,12.50,862.50,'2023-01-28 12:36:26','',''),(533,'1','310','1',1,'Retail Sale Id 509',1000.80,0.00,0.00,1.39,95.91,'2023-01-28 12:50:48','',''),(534,'1','310','1',1,'Retail Sale Id 510',9800.00,0.00,0.00,14.00,686.00,'2023-01-28 13:17:40','',''),(535,'1','310','1',1,'Retail Sale Id 511',6501.60,0.00,0.00,9.03,623.07,'2023-01-28 13:20:38','',''),(536,'1','310','1',1,'Retail Sale Id 512',4320.00,0.00,0.00,6.00,414.00,'2023-01-28 13:26:06','',''),(537,'1','310','1',1,'Retail Sale Id 512',7200.00,0.00,0.00,10.00,690.00,'2023-01-28 13:26:06','',''),(538,'1','310','1',1,'Retail Sale Id 513',7200.00,0.00,0.00,10.00,690.00,'2023-01-28 13:32:24','',''),(539,'1','310','1',1,'Retail Sale Id 514',9000.00,0.00,0.00,12.50,862.50,'2023-01-28 13:45:59','',''),(540,'1','310','1',1,'Retail Sale Id 515',3600.00,0.00,0.00,5.00,345.00,'2023-01-28 13:52:19','',''),(541,'1','310','1',1,'Retail Sale Id 516',175000.00,0.00,0.00,250.00,12250.00,'2023-01-28 13:57:53','',''),(542,'1','310','1',1,'Retail Sale Id 517',4399.20,0.00,0.00,6.11,421.59,'2023-01-28 14:17:10','',''),(543,'1','310','1',1,'Retail Sale Id 518',2001.60,0.00,0.00,2.78,191.82,'2023-01-28 14:23:35','',''),(544,'1','310','1',1,'Retail Sale Id 520',9000.00,0.00,0.00,12.50,862.50,'2023-01-28 14:28:53','',''),(545,'1','310','1',1,'Retail Sale Id 521',1000.80,0.00,0.00,1.39,95.91,'2023-01-28 14:32:37','',''),(546,'1','310','1',1,'Retail Sale Id 522',1497.60,0.00,0.00,2.08,143.52,'2023-01-28 14:37:08','',''),(547,'1','310','1',1,'Retail Sale Id 523',496.80,0.00,0.00,0.69,47.61,'2023-01-28 14:41:22','',''),(548,'1','310','1',1,'Retail Sale Id 524',5997.60,0.00,0.00,8.33,574.77,'2023-01-28 14:52:56','',''),(549,'1','310','1',1,'Retail Sale Id 525',1000.80,0.00,0.00,1.39,95.91,'2023-01-28 14:57:23','',''),(550,'1','310','1',1,'Retail Sale Id 526',42000.00,0.00,0.00,60.00,2940.00,'2023-01-28 15:10:17','',''),(551,'1','310','1',1,'Retail Sale Id 527',10800.00,0.00,0.00,15.00,1035.00,'2023-01-28 15:11:35','',''),(552,'1','310','1',1,'Retail Sale Id 528',4996.80,0.00,0.00,6.94,478.86,'2023-01-28 15:17:04','',''),(553,'1','310','1',1,'Retail Sale Id 529',3600.00,0.00,0.00,5.00,345.00,'2023-01-28 15:19:18','',''),(554,'1','310','1',1,'Retail Sale Id 530',4320.00,0.00,0.00,6.00,414.00,'2023-01-28 15:24:25','',''),(555,'1','310','1',1,'Retail Sale Id 531',1000.80,0.00,0.00,1.39,95.91,'2023-01-28 15:47:04','',''),(556,'1','310','1',1,'Retail Sale Id 532',6480.00,0.00,0.00,9.00,621.00,'2023-01-28 15:54:52','',''),(557,'1','310','1',1,'Retail Sale Id 533',3600.00,0.00,0.00,5.00,345.00,'2023-01-28 15:59:43','',''),(558,'1','310','1',1,'Retail Sale Id 533',9000.00,0.00,0.00,12.50,862.50,'2023-01-28 15:59:43','',''),(559,'1','310','1',1,'Retail Sale Id 534',2901.60,0.00,0.00,4.03,278.07,'2023-01-28 16:18:39','',''),(560,'1','310','1',1,'Retail Sale Id 535',3002.40,0.00,0.00,4.17,287.73,'2023-01-28 16:26:22','',''),(561,'1','310','1',1,'Retail Sale Id 536',142800.00,0.00,0.00,204.00,9996.00,'2023-01-28 16:36:06','',''),(562,'1','310','1',1,'Retail Sale Id 537',9000.00,0.00,0.00,12.50,862.50,'2023-01-28 16:41:57','',''),(563,'1','310','1',1,'Retail Sale Id 538',1000.80,0.00,0.00,1.39,95.91,'2023-01-28 16:42:40','',''),(564,'1','310','1',1,'Retail Sale Id 539',4996.80,0.00,0.00,6.94,478.86,'2023-01-28 16:45:02','',''),(565,'1','310','1',1,'Retail Sale Id 540',1497.60,0.00,0.00,2.08,143.52,'2023-01-28 16:46:07','',''),(566,'1','310','1',1,'Retail Sale Id 541',2203.20,0.00,0.00,3.06,211.14,'2023-01-28 16:56:02','',''),(567,'1','310','1',1,'Retail Sale Id 542',2203.20,0.00,0.00,3.06,211.14,'2023-01-28 16:57:03','',''),(568,'1','310','1',1,'Retail Sale Id 543',3002.40,0.00,0.00,4.17,287.73,'2023-01-28 16:58:16','',''),(569,'1','310','1',1,'Retail Sale Id 544',2001.60,0.00,0.00,2.78,191.82,'2023-01-28 16:59:10','',''),(570,'1','310','1',1,'Retail Sale Id 545',1000.80,0.00,0.00,1.39,95.91,'2023-01-28 17:00:54','',''),(571,'1','310','1',1,'Retail Sale Id 546',2203.20,0.00,0.00,3.06,211.14,'2023-01-28 17:01:42','',''),(572,'1','310','1',1,'Retail Sale Id 547',1000.80,0.00,0.00,1.39,95.91,'2023-01-28 17:04:45','',''),(573,'1','310','1',1,'Retail Sale Id 548',7200.00,0.00,0.00,10.00,690.00,'2023-01-28 17:08:21','',''),(574,'1','310','1',1,'Retail Sale Id 549',4320.00,0.00,0.00,6.00,414.00,'2023-01-28 17:12:33','',''),(575,'1','310','1',1,'Retail Sale Id 550',4320.00,0.00,0.00,6.00,414.00,'2023-01-28 17:17:51','',''),(576,'1','310','1',1,'Retail Sale Id 551',3600.00,0.00,0.00,5.00,345.00,'2023-01-28 17:27:39','',''),(577,'1','310','1',1,'Retail Sale Id 551',4320.00,0.00,0.00,6.00,414.00,'2023-01-28 17:27:39','',''),(578,'1','310','1',1,'Retail Sale Id 552',4500.00,0.00,0.00,6.25,431.25,'2023-01-28 17:31:48','',''),(579,'1','310','1',1,'Retail Sale Id 553',4320.00,0.00,0.00,6.00,414.00,'2023-01-28 17:36:31','',''),(580,'1','310','1',1,'Retail Sale Id 554',1000.80,0.00,0.00,1.39,95.91,'2023-01-28 17:42:01','',''),(581,'1','310','1',1,'Retail Sale Id 555',1000.80,0.00,0.00,1.39,95.91,'2023-01-28 17:45:46','',''),(582,'1','310','1',1,'Retail Sale Id 556',748.80,0.00,0.00,1.04,71.76,'2023-01-28 17:58:46','',''),(583,'1','310','1',1,'Retail Sale Id 557',2001.60,0.00,0.00,2.78,191.82,'2023-01-28 18:00:31','',''),(584,'1','310','1',1,'Retail Sale Id 558',2498.40,0.00,0.00,3.47,239.43,'2023-01-28 18:03:37','',''),(585,'1','310','1',1,'Retail Sale Id 559',3499.20,0.00,0.00,4.86,335.34,'2023-01-28 18:08:27','',''),(586,'1','310','1',1,'Retail Sale Id 560',2001.60,0.00,0.00,2.78,191.82,'2023-01-28 18:13:57','',''),(587,'1','310','1',1,'Retail Sale Id 561',1000.80,0.00,0.00,1.39,95.91,'2023-01-28 18:15:16','',''),(588,'1','310','1',1,'Retail Sale Id 561',1497.60,0.00,0.00,2.08,143.52,'2023-01-28 18:15:16','',''),(589,'1','310','1',1,'Retail Sale Id 562',2160.00,0.00,0.00,3.00,207.00,'2023-01-28 18:16:12','',''),(590,'1','310','1',1,'Retail Sale Id 563',3002.40,0.00,0.00,4.17,287.73,'2023-01-28 18:26:38','',''),(591,'1','310','1',1,'Retail Sale Id 564',914.40,0.00,0.00,1.27,87.63,'2023-01-28 19:21:59','',''),(592,'1','310','1',1,'Retail Sale Id 565',42000.00,0.00,0.00,60.00,2940.00,'2023-01-29 07:38:05','',''),(593,'1','310','1',1,'Retail Sale Id 566',9000.00,0.00,0.00,12.50,862.50,'2023-01-29 07:56:54','',''),(594,'1','310','1',1,'Retail Sale Id 567',720.00,0.00,0.00,1.00,69.00,'2023-01-29 08:14:10','',''),(595,'1','310','1',1,'Retail Sale Id 569',1000.80,0.00,0.00,1.39,95.91,'2023-01-29 08:33:51','',''),(596,'1','310','1',1,'Retail Sale Id 570',4900.00,0.00,0.00,7.00,343.00,'2023-01-29 08:39:08','',''),(597,'1','310','1',1,'Retail Sale Id 571',9000.00,0.00,0.00,12.50,862.50,'2023-01-29 08:42:04','',''),(598,'1','310','1',1,'Retail Sale Id 572',4320.00,0.00,0.00,6.00,414.00,'2023-01-29 08:51:51','',''),(599,'1','310','1',1,'Retail Sale Id 573',4399.20,0.00,0.00,6.11,421.59,'2023-01-29 09:11:21','',''),(600,'1','310','1',1,'Retail Sale Id 574',3600.00,0.00,0.00,5.00,345.00,'2023-01-29 09:12:46','',''),(601,'1','310','1',1,'Retail Sale Id 575',3499.20,0.00,0.00,4.86,335.34,'2023-01-29 09:23:16','',''),(602,'1','310','1',1,'Retail Sale Id 576',35000.00,0.00,0.00,50.00,2450.00,'2023-01-29 09:26:20','',''),(603,'1','310','1',1,'Retail Sale Id 577',35000.00,0.00,0.00,50.00,2450.00,'2023-01-29 09:26:59','',''),(604,'1','310','1',1,'Retail Sale Id 578',35000.00,0.00,0.00,50.00,2450.00,'2023-01-29 09:27:38','',''),(605,'1','310','1',1,'Retail Sale Id 579',3002.40,0.00,0.00,4.17,287.73,'2023-01-29 09:29:29','',''),(606,'1','310','1',1,'Retail Sale Id 580',2001.60,0.00,0.00,2.78,191.82,'2023-01-29 09:40:48','',''),(607,'1','310','1',1,'Retail Sale Id 581',2001.60,0.00,0.00,2.78,191.82,'2023-01-29 09:42:12','',''),(608,'1','310','1',1,'Retail Sale Id 582',1000.80,0.00,0.00,1.39,95.91,'2023-01-29 09:43:13','',''),(609,'1','310','1',1,'Retail Sale Id 583',1497.60,0.00,0.00,2.08,143.52,'2023-01-29 09:52:15','',''),(610,'1','310','1',1,'Retail Sale Id 584',9000.00,0.00,0.00,12.50,862.50,'2023-01-29 09:54:34','',''),(611,'1','310','1',1,'Retail Sale Id 585',3002.40,0.00,0.00,4.17,287.73,'2023-01-29 09:57:30','',''),(612,'1','310','1',1,'Retail Sale Id 586',4320.00,0.00,0.00,6.00,414.00,'2023-01-29 09:58:46','',''),(613,'1','310','1',1,'Retail Sale Id 587',2001.60,0.00,0.00,2.78,191.82,'2023-01-29 10:02:12','',''),(614,'1','310','1',1,'Retail Sale Id 588',1000.80,0.00,0.00,1.39,95.91,'2023-01-29 10:20:35','',''),(615,'1','310','1',1,'Retail Sale Id 589',4320.00,0.00,0.00,6.00,414.00,'2023-01-29 10:21:10','',''),(616,'1','310','1',1,'Retail Sale Id 590',1497.60,0.00,0.00,2.08,143.52,'2023-01-29 10:21:49','',''),(617,'1','310','1',1,'Retail Sale Id 591',2160.00,0.00,0.00,3.00,207.00,'2023-01-29 10:24:22','',''),(618,'1','310','1',1,'Retail Sale Id 592',4003.20,0.00,0.00,5.56,383.64,'2023-01-29 10:27:12','',''),(619,'1','310','1',1,'Retail Sale Id 593',3600.00,0.00,0.00,5.00,345.00,'2023-01-29 10:29:45','',''),(620,'1','310','1',1,'Retail Sale Id 594',2001.60,0.00,0.00,2.78,191.82,'2023-01-29 10:32:29','',''),(621,'1','310','1',1,'Retail Sale Id 595',4003.20,0.00,0.00,5.56,383.64,'2023-01-29 10:37:53','',''),(622,'1','310','1',1,'Retail Sale Id 596',3002.40,0.00,0.00,4.17,287.73,'2023-01-29 10:39:29','',''),(623,'1','310','1',1,'Retail Sale Id 597',1000.80,0.00,0.00,1.39,95.91,'2023-01-29 10:40:24','',''),(624,'1','310','1',1,'Retail Sale Id 598',2203.20,0.00,0.00,3.06,211.14,'2023-01-29 10:41:49','',''),(625,'1','310','1',1,'Retail Sale Id 599',2203.20,0.00,0.00,3.06,211.14,'2023-01-29 10:42:35','',''),(626,'1','310','1',1,'Retail Sale Id 600',4320.00,0.00,0.00,6.00,414.00,'2023-01-29 10:43:37','',''),(627,'1','310','1',1,'Retail Sale Id 601',2160.00,0.00,0.00,3.00,207.00,'2023-01-29 10:47:19','',''),(628,'1','310','1',1,'Retail Sale Id 602',1699.20,0.00,0.00,2.36,162.84,'2023-01-29 10:48:40','',''),(629,'1','310','1',1,'Retail Sale Id 603',4320.00,0.00,0.00,6.00,414.00,'2023-01-29 10:54:07','',''),(630,'1','310','1',1,'Return of Retail Sale Id 598',0.00,2203.20,3.06,0.00,-211.14,'2023-01-29 11:01:34','',''),(631,'1','310','1',1,'Retail Sale Id 604',4996.80,0.00,0.00,6.94,478.86,'2023-01-29 11:05:20','',''),(632,'1','310','1',1,'Retail Sale Id 605',6300.00,0.00,0.00,9.00,441.00,'2023-01-29 11:08:09','',''),(633,'1','310','1',1,'Retail Sale Id 606',4320.00,0.00,0.00,6.00,414.00,'2023-01-29 11:10:10','',''),(634,'1','310','1',1,'Retail Sale Id 607',1497.60,0.00,0.00,2.08,143.52,'2023-01-29 11:13:19','',''),(635,'1','310','1',1,'Retail Sale Id 607',2001.60,0.00,0.00,2.78,191.82,'2023-01-29 11:13:19','',''),(636,'1','310','1',1,'Retail Sale Id 608',7200.00,0.00,0.00,10.00,690.00,'2023-01-29 11:27:47','',''),(637,'1','310','1',1,'Retail Sale Id 609',3002.40,0.00,0.00,4.17,287.73,'2023-01-29 11:28:39','',''),(638,'1','310','1',1,'Retail Sale Id 610',4003.20,0.00,0.00,5.56,383.64,'2023-01-29 11:29:34','',''),(639,'1','310','1',1,'Retail Sale Id 611',35000.00,0.00,0.00,50.00,2450.00,'2023-01-29 11:34:21','',''),(640,'1','310','1',1,'Retail Sale Id 612',35000.00,0.00,0.00,50.00,2450.00,'2023-01-29 11:35:11','',''),(641,'1','310','1',1,'Retail Sale Id 613',4320.00,0.00,0.00,6.00,414.00,'2023-01-29 11:37:24','',''),(642,'1','310','1',1,'Retail Sale Id 614',2664.00,0.00,0.00,3.70,255.30,'2023-01-29 11:41:51','',''),(643,'1','310','1',1,'Retail Sale Id 615',4320.00,0.00,0.00,6.00,414.00,'2023-01-29 11:43:54','',''),(644,'1','310','1',1,'Retail Sale Id 616',1497.60,0.00,0.00,2.08,143.52,'2023-01-29 11:44:42','',''),(645,'1','310','1',1,'Retail Sale Id 617',4320.00,0.00,0.00,6.00,414.00,'2023-01-29 11:54:58','',''),(646,'1','310','1',1,'Retail Sale Id 617',4320.00,0.00,0.00,6.00,414.00,'2023-01-29 11:54:58','',''),(647,'1','310','1',1,'Retail Sale Id 618',9000.00,0.00,0.00,12.50,862.50,'2023-01-29 11:56:47','',''),(648,'1','310','1',1,'Retail Sale Id 619',9000.00,0.00,0.00,12.50,862.50,'2023-01-29 12:13:38','',''),(649,'1','310','1',1,'Retail Sale Id 620',1101.60,0.00,0.00,1.53,105.57,'2023-01-29 12:26:26','',''),(650,'1','310','1',1,'Retail Sale Id 621',2001.60,0.00,0.00,2.78,191.82,'2023-01-29 12:39:33','',''),(651,'1','310','1',1,'Retail Sale Id 622',35000.00,0.00,0.00,50.00,2450.00,'2023-01-29 12:41:56','',''),(652,'1','310','1',1,'Retail Sale Id 623',16800.00,0.00,0.00,24.00,1176.00,'2023-01-29 12:43:13','',''),(653,'1','310','1',1,'Retail Sale Id 624',5760.00,0.00,0.00,8.00,552.00,'2023-01-29 12:45:17','',''),(654,'1','310','1',1,'Retail Sale Id 625',3600.00,0.00,0.00,5.00,345.00,'2023-01-29 12:52:43','',''),(655,'1','310','1',1,'Retail Sale Id 626',7920.00,0.00,0.00,11.00,759.00,'2023-01-29 12:58:12','',''),(656,'1','310','1',1,'Retail Sale Id 627',1000.80,0.00,0.00,1.39,95.91,'2023-01-29 13:01:27','',''),(657,'1','310','1',1,'Retail Sale Id 628',9000.00,0.00,0.00,12.50,862.50,'2023-01-29 13:19:35','',''),(658,'1','310','1',1,'Retail Sale Id 629',2001.60,0.00,0.00,2.78,191.82,'2023-01-29 13:22:17','',''),(659,'1','310','1',1,'Retail Sale Id 630',14000.00,0.00,0.00,20.00,980.00,'2023-01-29 14:01:06','',''),(660,'1','310','1',1,'Retail Sale Id 631',1497.60,0.00,0.00,2.08,143.52,'2023-01-29 14:02:00','',''),(661,'1','310','1',1,'Retail Sale Id 632',2001.60,0.00,0.00,2.78,191.82,'2023-01-29 14:04:02','',''),(662,'1','310','1',1,'Retail Sale Id 633',720.00,0.00,0.00,1.00,69.00,'2023-01-29 14:09:26','',''),(663,'1','310','1',1,'Retail Sale Id 634',2160.00,0.00,0.00,3.00,207.00,'2023-01-29 14:24:41','',''),(664,'1','310','1',1,'Retail Sale Id 635',9000.00,0.00,0.00,12.50,862.50,'2023-01-29 14:26:09','',''),(665,'1','310','1',1,'Retail Sale Id 636',2160.00,0.00,0.00,3.00,207.00,'2023-01-29 14:27:49','',''),(666,'1','310','1',1,'Retail Sale Id 637',3600.00,0.00,0.00,5.00,345.00,'2023-01-29 14:42:30','',''),(667,'1','310','1',1,'Retail Sale Id 638',3600.00,0.00,0.00,5.00,345.00,'2023-01-29 14:51:28','',''),(668,'1','310','1',1,'Retail Sale Id 640',61250.00,0.00,0.00,87.50,4287.50,'2023-01-29 14:59:59','',''),(669,'1','310','1',1,'Retail Sale Id 642',1303.20,0.00,0.00,1.81,124.89,'2023-01-29 15:01:59','',''),(670,'1','310','1',1,'Retail Sale Id 643',1000.80,0.00,0.00,1.39,95.91,'2023-01-29 15:03:37','',''),(671,'1','310','1',1,'Retail Sale Id 644',9000.00,0.00,0.00,12.50,862.50,'2023-01-29 15:12:57','',''),(672,'1','310','1',1,'Retail Sale Id 645',1000.80,0.00,0.00,1.39,95.91,'2023-01-29 15:17:01','',''),(673,'1','310','1',1,'Retail Sale Id 646',2160.00,0.00,0.00,3.00,207.00,'2023-01-29 16:11:59','',''),(674,'1','310','1',1,'Retail Sale Id 647',2203.20,0.00,0.00,3.06,211.14,'2023-01-29 16:12:56','',''),(675,'1','310','1',1,'Retail Sale Id 648',1000.80,0.00,0.00,1.39,95.91,'2023-01-29 16:15:56','',''),(676,'1','310','1',1,'Retail Sale Id 649',9000.00,0.00,0.00,12.50,862.50,'2023-01-29 16:24:01','',''),(677,'1','310','1',1,'Retail Sale Id 650',2001.60,0.00,0.00,2.78,191.82,'2023-01-29 16:25:57','',''),(678,'1','310','1',1,'Retail Sale Id 651',1000.80,0.00,0.00,1.39,95.91,'2023-01-29 16:35:29','',''),(679,'1','310','1',1,'Retail Sale Id 652',2203.20,0.00,0.00,3.06,211.14,'2023-01-29 16:36:50','',''),(680,'1','310','1',1,'Retail Sale Id 653',1000.80,0.00,0.00,1.39,95.91,'2023-01-29 16:37:43','',''),(681,'1','310','1',1,'Retail Sale Id 654',3002.40,0.00,0.00,4.17,287.73,'2023-01-29 16:47:52','',''),(682,'1','310','1',1,'Retail Sale Id 655',1497.60,0.00,0.00,2.08,143.52,'2023-01-29 16:48:49','',''),(683,'1','310','1',1,'Retail Sale Id 656',1000.80,0.00,0.00,1.39,95.91,'2023-01-29 16:52:56','',''),(684,'1','310','1',1,'Retail Sale Id 657',3600.00,0.00,0.00,5.00,345.00,'2023-01-29 16:53:52','',''),(685,'1','310','1',1,'Retail Sale Id 658',2160.00,0.00,0.00,3.00,207.00,'2023-01-29 16:55:11','',''),(686,'1','310','1',1,'Retail Sale Id 659',3002.40,0.00,0.00,4.17,287.73,'2023-01-29 16:57:05','',''),(687,'1','310','1',1,'Retail Sale Id 660',2160.00,0.00,0.00,3.00,207.00,'2023-01-29 17:04:40','',''),(688,'1','310','1',1,'Retail Sale Id 661',9000.00,0.00,0.00,12.50,862.50,'2023-01-29 17:11:22','',''),(689,'1','310','1',1,'Retail Sale Id 662',496.80,0.00,0.00,0.69,47.61,'2023-01-29 17:12:16','',''),(690,'1','310','1',1,'Retail Sale Id 663',4320.00,0.00,0.00,6.00,414.00,'2023-01-29 17:14:50','',''),(691,'1','310','1',1,'Retail Sale Id 664',5040.00,0.00,0.00,7.00,483.00,'2023-01-29 17:18:56','',''),(692,'1','310','1',1,'Retail Sale Id 665',13300.00,0.00,0.00,19.00,931.00,'2023-01-29 17:29:07','',''),(693,'1','310','1',1,'Retail Sale Id 666',9000.00,0.00,0.00,12.50,862.50,'2023-01-29 17:37:37','',''),(694,'1','310','1',1,'Retail Sale Id 667',1497.60,0.00,0.00,2.08,143.52,'2023-01-29 17:58:51','',''),(695,'1','310','1',1,'Retail Sale Id 668',1497.60,0.00,0.00,2.08,143.52,'2023-01-29 18:00:21','',''),(696,'1','310','1',1,'Retail Sale Id 669',1000.80,0.00,0.00,1.39,95.91,'2023-01-29 18:02:54','',''),(697,'1','310','1',1,'Retail Sale Id 670',35000.00,0.00,0.00,50.00,2450.00,'2023-01-29 18:04:54','',''),(698,'1','310','1',1,'Retail Sale Id 671',2001.60,0.00,0.00,2.78,191.82,'2023-01-29 18:05:28','',''),(699,'1','310','1',1,'Retail Sale Id 672',3002.40,0.00,0.00,4.17,287.73,'2023-01-29 18:12:43','',''),(700,'1','310','1',1,'Retail Sale Id 673',3679.20,0.00,0.00,5.11,352.59,'2023-01-29 18:19:22','',''),(701,'1','310','1',1,'Retail Sale Id 673',4320.00,0.00,0.00,6.00,414.00,'2023-01-29 18:19:22','',''),(702,'1','310','1',1,'Retail Sale Id 674',3679.20,0.00,0.00,5.11,352.59,'2023-01-29 18:21:26','',''),(703,'1','310','1',1,'Retail Sale Id 674',4320.00,0.00,0.00,6.00,414.00,'2023-01-29 18:21:26','',''),(704,'1','310','1',1,'Return of Retail Sale Id 673',0.00,3679.20,5.11,0.00,-352.59,'2023-01-29 18:22:19','',''),(705,'1','310','1',1,'Return of Retail Sale Id 673',0.00,4320.00,6.00,0.00,-414.00,'2023-01-29 18:22:19','',''),(706,'1','310','1',1,'Retail Sale Id 675',36.00,0.00,0.00,0.05,3.45,'2023-01-29 18:36:25','',''),(707,'1','310','1',1,'Retail Sale Id 676',2498.40,0.00,0.00,3.47,239.43,'2023-01-30 07:16:10','',''),(708,'1','310','1',1,'Retail Sale Id 677',9000.00,0.00,0.00,12.50,862.50,'2023-01-30 07:34:48','',''),(709,'1','310','1',1,'Retail Sale Id 678',2203.20,0.00,0.00,3.06,211.14,'2023-01-30 07:39:07','',''),(710,'1','310','1',1,'Retail Sale Id 679',1497.60,0.00,0.00,2.08,143.52,'2023-01-30 07:58:19','',''),(711,'1','310','1',1,'Retail Sale Id 680',7920.00,0.00,0.00,11.00,759.00,'2023-01-30 08:17:17','',''),(712,'1','310','1',1,'Retail Sale Id 681',4003.20,0.00,0.00,5.56,383.64,'2023-01-30 08:31:43','',''),(713,'1','310','1',1,'Retail Sale Id 682',720.00,0.00,0.00,1.00,69.00,'2023-01-30 08:33:28','',''),(714,'1','310','1',1,'Retail Sale Id 683',9000.00,0.00,0.00,12.50,862.50,'2023-01-30 08:34:25','',''),(715,'1','310','1',1,'Retail Sale Id 684',3600.00,0.00,0.00,5.00,345.00,'2023-01-30 08:37:03','',''),(716,'1','310','1',1,'Retail Sale Id 685',3002.40,0.00,0.00,4.17,287.73,'2023-01-30 08:38:21','',''),(717,'1','310','1',1,'Retail Sale Id 686',10500.00,0.00,0.00,15.00,735.00,'2023-01-30 08:52:58','',''),(718,'1','310','1',1,'Retail Sale Id 687',1000.80,0.00,0.00,1.39,95.91,'2023-01-30 08:55:23','',''),(719,'1','310','1',1,'Retail Sale Id 688',1000.80,0.00,0.00,1.39,95.91,'2023-01-30 09:02:16','',''),(720,'1','310','1',1,'Retail Sale Id 691',2001.60,0.00,0.00,2.78,191.82,'2023-01-30 09:13:39','',''),(721,'1','310','1',1,'Retail Sale Id 692',4320.00,0.00,0.00,6.00,414.00,'2023-01-30 09:34:38','',''),(722,'1','310','1',1,'Retail Sale Id 692',9000.00,0.00,0.00,12.50,862.50,'2023-01-30 09:34:38','',''),(723,'1','310','1',1,'Retail Sale Id 693',4996.80,0.00,0.00,6.94,478.86,'2023-01-30 09:59:01','',''),(724,'1','310','1',1,'Retail Sale Id 694',5040.00,0.00,0.00,7.00,483.00,'2023-01-30 10:06:02','',''),(725,'1','310','1',1,'Retail Sale Id 695',2001.60,0.00,0.00,2.78,191.82,'2023-01-30 10:19:07','',''),(726,'1','310','1',1,'Retail Sale Id 696',1000.80,0.00,0.00,1.39,95.91,'2023-01-30 10:20:14','',''),(727,'1','310','1',1,'Retail Sale Id 697',1000.80,0.00,0.00,1.39,95.91,'2023-01-30 10:28:43','',''),(728,'1','310','1',1,'Retail Sale Id 698',42000.00,0.00,0.00,60.00,2940.00,'2023-01-30 10:41:05','',''),(729,'1','310','1',1,'Retail Sale Id 699',1497.60,0.00,0.00,2.08,143.52,'2023-01-30 11:18:41','',''),(730,'1','310','1',1,'Retail Sale Id 700',496.80,0.00,0.00,0.69,47.61,'2023-01-30 11:22:02','',''),(731,'1','310','1',1,'Retail Sale Id 701',2160.00,0.00,0.00,3.00,207.00,'2023-01-30 11:22:50','',''),(732,'1','310','1',1,'Retail Sale Id 702',1000.80,0.00,0.00,1.39,95.91,'2023-01-30 11:24:33','',''),(733,'1','310','1',1,'Retail Sale Id 703',9000.00,0.00,0.00,12.50,862.50,'2023-01-30 11:29:11','',''),(734,'1','310','1',1,'Retail Sale Id 704',2160.00,0.00,0.00,3.00,207.00,'2023-01-30 11:31:57','',''),(735,'1','310','1',1,'Retail Sale Id 705',70000.00,0.00,0.00,100.00,4900.00,'2023-01-30 11:33:17','',''),(736,'1','310','1',1,'Retail Sale Id 706',2001.60,0.00,0.00,2.78,191.82,'2023-01-30 11:48:29','',''),(737,'1','310','1',1,'Retail Sale Id 707',1000.80,0.00,0.00,1.39,95.91,'2023-01-30 12:00:39','',''),(738,'1','310','1',1,'Retail Sale Id 708',70000.00,0.00,0.00,100.00,4900.00,'2023-01-30 12:06:18','',''),(739,'1','310','1',1,'Retail Sale Id 709',35000.00,0.00,0.00,50.00,2450.00,'2023-01-30 12:07:35','',''),(740,'1','310','1',1,'Retail Sale Id 710',115500.00,0.00,0.00,165.00,8085.00,'2023-01-30 12:22:57','',''),(741,'1','310','1',1,'Retail Sale Id 711',28000.00,0.00,0.00,40.00,1960.00,'2023-01-30 12:25:31','',''),(742,'1','310','1',1,'Retail Sale Id 712',35000.00,0.00,0.00,50.00,2450.00,'2023-01-30 12:27:29','',''),(743,'1','310','1',1,'Retail Sale Id 713',1000.80,0.00,0.00,1.39,95.91,'2023-01-30 12:33:01','',''),(744,'1','310','1',1,'Retail Sale Id 714',4320.00,0.00,0.00,6.00,414.00,'2023-01-30 12:34:44','',''),(745,'1','310','1',1,'Retail Sale Id 715',4298.40,0.00,0.00,5.97,411.93,'2023-01-30 12:54:22','',''),(746,'1','310','1',1,'Retail Sale Id 715',7200.00,0.00,0.00,10.00,690.00,'2023-01-30 12:54:22','',''),(747,'1','310','1',1,'Retail Sale Id 716',1000.80,0.00,0.00,1.39,95.91,'2023-01-30 12:55:34','',''),(748,'1','310','1',1,'Retail Sale Id 717',4500.00,0.00,0.00,6.25,431.25,'2023-01-30 13:20:06','',''),(749,'1','310','1',1,'Retail Sale Id 718',4996.80,0.00,0.00,6.94,478.86,'2023-01-30 13:21:08','',''),(750,'1','310','1',1,'Retail Sale Id 719',1000.80,0.00,0.00,1.39,95.91,'2023-01-30 13:22:08','',''),(751,'1','310','1',1,'Retail Sale Id 720',2203.20,0.00,0.00,3.06,211.14,'2023-01-30 13:23:03','',''),(752,'1','310','1',1,'Retail Sale Id 721',2160.00,0.00,0.00,3.00,207.00,'2023-01-30 13:24:23','',''),(753,'1','310','1',1,'Retail Sale Id 722',4320.00,0.00,0.00,6.00,414.00,'2023-01-30 13:26:03','',''),(754,'1','310','1',1,'Retail Sale Id 723',1000.80,0.00,0.00,1.39,95.91,'2023-01-30 13:57:09','',''),(755,'1','310','1',1,'Retail Sale Id 724',2160.00,0.00,0.00,3.00,207.00,'2023-01-30 14:04:55','',''),(756,'1','310','1',1,'Retail Sale Id 725',2203.20,0.00,0.00,3.06,211.14,'2023-01-30 14:14:06','',''),(757,'1','310','1',1,'Retail Sale Id 726',4200.00,0.00,0.00,6.00,294.00,'2023-01-30 14:20:12','',''),(758,'1','310','1',1,'Retail Sale Id 727',2160.00,0.00,0.00,3.00,207.00,'2023-01-30 14:28:05','',''),(759,'1','310','1',1,'Return of Retail Sale Id 708',0.00,70000.00,100.00,0.00,-4900.00,'2023-01-30 14:37:25','',''),(760,'1','310','1',1,'Return of Retail Sale Id 721',0.00,2160.00,3.00,0.00,-207.00,'2023-01-30 14:39:30','',''),(761,'1','310','1',1,'Retail Sale Id 728',1000.80,0.00,0.00,1.39,95.91,'2023-01-30 14:54:41','',''),(762,'1','310','1',1,'Retail Sale Id 729',35000.00,0.00,0.00,50.00,2450.00,'2023-01-30 14:57:02','',''),(763,'1','310','1',1,'Retail Sale Id 730',2203.20,0.00,0.00,3.06,211.14,'2023-01-30 15:22:22','',''),(764,'1','310','1',1,'Retail Sale Id 731',4399.20,0.00,0.00,6.11,421.59,'2023-01-30 15:26:39','',''),(765,'1','310','1',1,'Retail Sale Id 732',2001.60,0.00,0.00,2.78,191.82,'2023-01-30 15:36:01','',''),(766,'1','310','1',1,'Retail Sale Id 733',4501.00,0.00,0.00,6.43,315.07,'2023-01-30 15:37:50','',''),(767,'1','310','1',1,'Retail Sale Id 734',2203.20,0.00,0.00,3.06,211.14,'2023-01-30 15:44:36','',''),(768,'1','310','1',1,'Retail Sale Id 735',4320.00,0.00,0.00,6.00,414.00,'2023-01-30 15:58:37','',''),(769,'1','310','1',1,'Retail Sale Id 736',9000.00,0.00,0.00,12.50,862.50,'2023-01-30 16:18:46','',''),(770,'1','310','1',1,'Retail Sale Id 737',720.00,0.00,0.00,1.00,69.00,'2023-01-30 16:24:08','',''),(771,'1','310','1',1,'Retail Sale Id 738',4320.00,0.00,0.00,6.00,414.00,'2023-01-30 16:48:20','',''),(772,'1','310','1',1,'Retail Sale Id 739',2498.40,0.00,0.00,3.47,239.43,'2023-01-30 16:53:53','',''),(773,'1','310','1',1,'Retail Sale Id 740',3002.40,0.00,0.00,4.17,287.73,'2023-01-30 16:54:50','',''),(774,'1','310','1',1,'Retail Sale Id 741',2203.20,0.00,0.00,3.06,211.14,'2023-01-30 16:56:27','',''),(775,'1','310','1',1,'Retail Sale Id 742',2001.60,0.00,0.00,2.78,191.82,'2023-01-30 17:11:42','',''),(776,'1','310','1',1,'Retail Sale Id 743',35000.00,0.00,0.00,50.00,2450.00,'2023-01-30 17:12:51','',''),(777,'1','310','1',1,'Retail Sale Id 744',2203.20,0.00,0.00,3.06,211.14,'2023-01-30 17:13:55','',''),(778,'1','310','1',1,'Retail Sale Id 745',698.40,0.00,0.00,0.97,66.93,'2023-01-30 17:16:55','',''),(779,'1','310','1',1,'Retail Sale Id 746',1497.60,0.00,0.00,2.08,143.52,'2023-01-30 17:18:00','',''),(780,'1','310','1',1,'Retail Sale Id 747',496.80,0.00,0.00,0.69,47.61,'2023-01-30 17:19:13','',''),(781,'1','310','1',1,'Retail Sale Id 748',1000.80,0.00,0.00,1.39,95.91,'2023-01-30 17:21:07','',''),(782,'1','310','1',1,'Retail Sale Id 749',1497.60,0.00,0.00,2.08,143.52,'2023-01-30 17:22:09','',''),(783,'1','310','1',1,'Retail Sale Id 750',2498.40,0.00,0.00,3.47,239.43,'2023-01-30 17:24:49','',''),(784,'1','310','1',1,'Retail Sale Id 751',2160.00,0.00,0.00,3.00,207.00,'2023-01-30 17:27:16','',''),(785,'1','310','1',1,'Retail Sale Id 752',4399.20,0.00,0.00,6.11,421.59,'2023-01-30 17:45:07','',''),(786,'1','310','1',1,'Retail Sale Id 753',4399.20,0.00,0.00,6.11,421.59,'2023-01-30 17:46:56','',''),(787,'1','310','1',1,'Retail Sale Id 754',39998.00,0.00,0.00,57.14,2799.86,'2023-01-30 17:49:43','',''),(788,'1','310','1',1,'Retail Sale Id 755',496.80,0.00,0.00,0.69,47.61,'2023-01-30 18:07:05','',''),(789,'1','310','1',1,'Retail Sale Id 756',4399.20,0.00,0.00,6.11,421.59,'2023-01-30 18:08:28','',''),(790,'1','310','1',1,'Return of Retail Sale Id 733',0.00,4501.00,6.43,0.00,-315.07,'2023-01-30 19:13:13','',''),(791,'1','310','1',1,'Retail Sale Id 757',1591786.00,0.00,0.00,2273.98,111425.02,'2023-01-30 19:14:16','',''),(792,'1','310','1',1,'Return of Retail Sale Id 757',0.00,1591786.00,2273.98,0.00,-111425.02,'2023-01-30 19:14:50','',''),(793,'1','310','1',1,'Retail Sale Id 758',4459.00,0.00,0.00,6.37,312.13,'2023-01-30 19:15:34','',''),(794,'1','310','1',1,'Retail Sale Id 759',45288.00,0.00,0.00,62.90,4340.10,'2023-01-30 19:16:12','',''),(795,'1','310','1',1,'Retail Sale Id 761',4996.80,0.00,0.00,6.94,478.86,'2023-01-31 07:36:57','',''),(796,'1','310','1',1,'Retail Sale Id 762',2160.00,0.00,0.00,3.00,207.00,'2023-01-31 07:41:14','',''),(797,'1','310','1',1,'Retail Sale Id 763',2160.00,0.00,0.00,3.00,207.00,'2023-01-31 07:52:30','',''),(798,'1','310','1',1,'Retail Sale Id 764',21000.00,0.00,0.00,30.00,1470.00,'2023-01-31 08:00:09','',''),(799,'1','310','1',1,'Retail Sale Id 765',1000.80,0.00,0.00,1.39,95.91,'2023-01-31 08:10:31','',''),(800,'1','310','1',1,'Retail Sale Id 766',4320.00,0.00,0.00,6.00,414.00,'2023-01-31 08:19:02','',''),(801,'1','310','1',1,'Retail Sale Id 767',9000.00,0.00,0.00,12.50,862.50,'2023-01-31 08:20:09','',''),(802,'1','310','1',1,'Retail Sale Id 768',4399.20,0.00,0.00,6.11,421.59,'2023-01-31 08:28:21','',''),(803,'1','310','1',1,'Retail Sale Id 769',3499.20,0.00,0.00,4.86,335.34,'2023-01-31 08:39:53','',''),(804,'1','310','1',1,'Retail Sale Id 770',4500.00,0.00,0.00,6.25,431.25,'2023-01-31 08:49:31','',''),(805,'1','310','1',1,'Retail Sale Id 771',35000.00,0.00,0.00,50.00,2450.00,'2023-01-31 08:58:36','',''),(806,'1','310','1',1,'Retail Sale Id 772',35000.00,0.00,0.00,50.00,2450.00,'2023-01-31 08:59:29','',''),(807,'1','310','1',1,'Retail Sale Id 773',1447.20,0.00,0.00,2.01,138.69,'2023-01-31 09:05:25','',''),(808,'1','310','1',1,'Retail Sale Id 774',3002.40,0.00,0.00,4.17,287.73,'2023-01-31 09:11:49','',''),(809,'1','310','1',1,'Retail Sale Id 776',3600.00,0.00,0.00,5.00,345.00,'2023-01-31 09:22:49','',''),(810,'1','310','1',1,'Retail Sale Id 777',4320.00,0.00,0.00,6.00,414.00,'2023-01-31 09:27:07','',''),(811,'1','310','1',1,'Retail Sale Id 778',3801.60,0.00,0.00,5.28,364.32,'2023-01-31 09:34:25','',''),(812,'1','310','1',1,'Retail Sale Id 779',1000.80,0.00,0.00,1.39,95.91,'2023-01-31 09:37:00','',''),(813,'1','310','1',1,'Retail Sale Id 780',3002.40,0.00,0.00,4.17,287.73,'2023-01-31 09:40:06','',''),(814,'1','310','1',1,'Retail Sale Id 781',9000.00,0.00,0.00,12.50,862.50,'2023-01-31 09:41:56','',''),(815,'1','310','1',1,'Retail Sale Id 781',9000.00,0.00,0.00,12.50,862.50,'2023-01-31 09:41:56','',''),(816,'1','310','1',1,'Retail Sale Id 781',9000.00,0.00,0.00,12.50,862.50,'2023-01-31 09:41:56','',''),(817,'1','310','1',1,'Retail Sale Id 782',3002.40,0.00,0.00,4.17,287.73,'2023-01-31 09:42:57','',''),(818,'1','310','1',1,'Retail Sale Id 782',3002.40,0.00,0.00,4.17,287.73,'2023-01-31 09:42:57','',''),(819,'1','310','1',1,'Retail Sale Id 782',3002.40,0.00,0.00,4.17,287.73,'2023-01-31 09:42:57','',''),(820,'1','310','1',1,'Retail Sale Id 783',4320.00,0.00,0.00,6.00,414.00,'2023-01-31 09:59:03','',''),(821,'1','310','1',1,'Retail Sale Id 784',2160.00,0.00,0.00,3.00,207.00,'2023-01-31 10:25:15','',''),(822,'1','310','1',1,'Retail Sale Id 785',2102.40,0.00,0.00,2.92,201.48,'2023-01-31 10:33:58','',''),(823,'1','310','1',1,'Retail Sale Id 786',4399.20,0.00,0.00,6.11,421.59,'2023-01-31 10:35:00','',''),(824,'1','310','1',1,'Retail Sale Id 787',669.60,0.00,0.00,0.93,64.17,'2023-01-31 10:40:23','',''),(825,'1','310','1',1,'Retail Sale Id 788',4320.00,0.00,0.00,6.00,414.00,'2023-01-31 10:42:13','',''),(826,'1','310','1',1,'Retail Sale Id 789',2160.00,0.00,0.00,3.00,207.00,'2023-01-31 10:49:37','',''),(827,'1','310','1',1,'Retail Sale Id 790',1497.60,0.00,0.00,2.08,143.52,'2023-01-31 10:59:04','',''),(828,'1','310','1',1,'Retail Sale Id 791',7200.00,0.00,0.00,10.00,690.00,'2023-01-31 11:03:22','',''),(829,'1','310','1',1,'Retail Sale Id 792',2203.20,0.00,0.00,3.06,211.14,'2023-01-31 11:08:11','',''),(830,'1','310','1',1,'Retail Sale Id 793',3600.00,0.00,0.00,5.00,345.00,'2023-01-31 11:14:23','',''),(831,'1','310','1',1,'Retail Sale Id 794',4320.00,0.00,0.00,6.00,414.00,'2023-01-31 11:19:46','',''),(832,'1','310','1',1,'Retail Sale Id 795',3600.00,0.00,0.00,5.00,345.00,'2023-01-31 11:25:18','',''),(833,'1','310','1',1,'Retail Sale Id 796',4320.00,0.00,0.00,6.00,414.00,'2023-01-31 11:29:59','',''),(834,'1','310','1',1,'Retail Sale Id 797',3002.40,0.00,0.00,4.17,287.73,'2023-01-31 11:37:36','',''),(835,'1','310','1',1,'Retail Sale Id 798',6480.00,0.00,0.00,9.00,621.00,'2023-01-31 11:41:00','',''),(836,'1','310','1',1,'Retail Sale Id 799',2001.60,0.00,0.00,2.78,191.82,'2023-01-31 11:42:05','',''),(837,'1','310','1',1,'Retail Sale Id 800',9000.00,0.00,0.00,12.50,862.50,'2023-01-31 11:42:56','',''),(838,'1','310','1',1,'Retail Sale Id 801',4996.80,0.00,0.00,6.94,478.86,'2023-01-31 11:52:50','',''),(839,'1','310','1',1,'Retail Sale Id 802',4399.20,0.00,0.00,6.11,421.59,'2023-01-31 11:54:02','',''),(840,'1','310','1',1,'Retail Sale Id 803',9000.00,0.00,0.00,12.50,862.50,'2023-01-31 11:56:07','',''),(841,'1','310','1',1,'Retail Sale Id 804',2001.60,0.00,0.00,2.78,191.82,'2023-01-31 11:57:13','',''),(842,'1','310','1',1,'Retail Sale Id 805',4320.00,0.00,0.00,6.00,414.00,'2023-01-31 12:04:05','',''),(843,'1','310','1',1,'Retail Sale Id 806',4320.00,0.00,0.00,6.00,414.00,'2023-01-31 12:07:15','',''),(844,'1','310','1',1,'Retail Sale Id 807',9000.00,0.00,0.00,12.50,862.50,'2023-01-31 12:13:39','',''),(845,'1','310','1',1,'Retail Sale Id 808',9000.00,0.00,0.00,12.50,862.50,'2023-01-31 12:17:41','',''),(846,'1','310','1',1,'Retail Sale Id 809',2001.60,0.00,0.00,2.78,191.82,'2023-01-31 12:18:44','',''),(847,'1','310','1',1,'Retail Sale Id 810',1000.80,0.00,0.00,1.39,95.91,'2023-01-31 12:22:34','',''),(848,'1','310','1',1,'Retail Sale Id 811',18000.00,0.00,0.00,25.00,1725.00,'2023-01-31 12:23:11','',''),(849,'1','310','1',1,'Retail Sale Id 812',1440.00,0.00,0.00,2.00,138.00,'2023-01-31 12:26:36','',''),(850,'1','310','1',1,'Retail Sale Id 813',1864.80,0.00,0.00,2.59,178.71,'2023-01-31 12:27:59','',''),(851,'1','310','1',1,'Retail Sale Id 814',4320.00,0.00,0.00,6.00,414.00,'2023-01-31 12:30:37','',''),(852,'1','310','1',1,'Retail Sale Id 815',1000.80,0.00,0.00,1.39,95.91,'2023-01-31 12:32:59','',''),(853,'1','310','1',1,'Retail Sale Id 816',2160.00,0.00,0.00,3.00,207.00,'2023-01-31 12:34:24','',''),(854,'1','310','1',1,'Retail Sale Id 816',2160.00,0.00,0.00,3.00,207.00,'2023-01-31 12:34:24','',''),(855,'1','310','1',1,'Retail Sale Id 817',9000.00,0.00,0.00,12.50,862.50,'2023-01-31 12:40:26','',''),(856,'1','310','1',1,'Retail Sale Id 818',1000.80,0.00,0.00,1.39,95.91,'2023-01-31 12:50:52','',''),(857,'1','310','1',1,'Retail Sale Id 819',2160.00,0.00,0.00,3.00,207.00,'2023-01-31 12:51:37','',''),(858,'1','310','1',1,'Retail Sale Id 820',4320.00,0.00,0.00,6.00,414.00,'2023-01-31 12:56:48','',''),(859,'1','310','1',1,'Retail Sale Id 821',1000.80,0.00,0.00,1.39,95.91,'2023-01-31 13:18:50','',''),(860,'1','310','1',1,'Retail Sale Id 822',2700.00,0.00,0.00,3.75,258.75,'2023-01-31 13:28:35','',''),(861,'1','310','1',1,'Retail Sale Id 823',2160.00,0.00,0.00,3.00,207.00,'2023-01-31 13:29:43','',''),(862,'1','310','1',1,'Retail Sale Id 824',3002.40,0.00,0.00,4.17,287.73,'2023-01-31 13:30:36','',''),(863,'1','310','1',1,'Retail Sale Id 825',2203.20,0.00,0.00,3.06,211.14,'2023-01-31 13:38:32','',''),(864,'1','310','1',1,'Retail Sale Id 826',9000.00,0.00,0.00,12.50,862.50,'2023-01-31 13:44:41','',''),(865,'1','310','1',1,'Retail Sale Id 827',2203.20,0.00,0.00,3.06,211.14,'2023-01-31 13:45:48','',''),(866,'1','310','1',1,'Retail Sale Id 828',4003.20,0.00,0.00,5.56,383.64,'2023-01-31 14:14:04','',''),(867,'1','310','1',1,'Retail Sale Id 828',4996.80,0.00,0.00,6.94,478.86,'2023-01-31 14:14:04','',''),(868,'1','310','1',1,'Retail Sale Id 829',3600.00,0.00,0.00,5.00,345.00,'2023-01-31 14:31:23','',''),(869,'1','310','1',1,'Retail Sale Id 830',2160.00,0.00,0.00,3.00,207.00,'2023-01-31 14:32:45','',''),(870,'1','310','1',1,'Retail Sale Id 831',9000.00,0.00,0.00,12.50,862.50,'2023-01-31 14:38:50','',''),(871,'1','310','1',1,'Retail Sale Id 832',2066.40,0.00,0.00,2.87,198.03,'2023-01-31 14:39:44','',''),(872,'1','310','1',1,'Retail Sale Id 833',2498.40,0.00,0.00,3.47,239.43,'2023-01-31 14:40:49','',''),(873,'1','310','1',1,'Retail Sale Id 834',4003.20,0.00,0.00,5.56,383.64,'2023-01-31 15:07:26','',''),(874,'1','310','1',1,'Retail Sale Id 835',2880.00,0.00,0.00,4.00,276.00,'2023-01-31 15:40:40','',''),(875,'1','310','1',1,'Retail Sale Id 836',4320.00,0.00,0.00,6.00,414.00,'2023-01-31 15:44:48','',''),(876,'1','310','1',1,'Retail Sale Id 837',70000.00,0.00,0.00,100.00,4900.00,'2023-01-31 15:48:29','',''),(877,'1','310','1',1,'Retail Sale Id 838',2001.60,0.00,0.00,2.78,191.82,'2023-01-31 15:50:51','',''),(878,'1','310','1',1,'Retail Sale Id 839',2001.60,0.00,0.00,2.78,191.82,'2023-01-31 15:57:32','',''),(879,'1','310','1',1,'Retail Sale Id 839',2001.60,0.00,0.00,2.78,191.82,'2023-01-31 15:57:32','',''),(880,'1','310','1',1,'Retail Sale Id 840',3600.00,0.00,0.00,5.00,345.00,'2023-01-31 16:10:41','',''),(881,'1','310','1',1,'Retail Sale Id 840',9000.00,0.00,0.00,12.50,862.50,'2023-01-31 16:10:41','',''),(882,'1','310','1',1,'Retail Sale Id 841',3600.00,0.00,0.00,5.00,345.00,'2023-01-31 16:14:07','',''),(883,'1','310','1',1,'Retail Sale Id 842',2160.00,0.00,0.00,3.00,207.00,'2023-01-31 16:15:25','',''),(884,'1','310','1',1,'Retail Sale Id 843',5040.00,0.00,0.00,7.00,483.00,'2023-01-31 16:18:57','',''),(885,'1','310','1',1,'Retail Sale Id 844',496.80,0.00,0.00,0.69,47.61,'2023-01-31 16:28:21','',''),(886,'1','310','1',1,'Retail Sale Id 845',4298.40,0.00,0.00,5.97,411.93,'2023-01-31 16:33:19','',''),(887,'1','310','1',1,'Retail Sale Id 846',3600.00,0.00,0.00,5.00,345.00,'2023-01-31 16:35:24','',''),(888,'1','310','1',1,'Retail Sale Id 846',3600.00,0.00,0.00,5.00,345.00,'2023-01-31 16:35:24','',''),(889,'1','310','1',1,'Retail Sale Id 847',4003.20,0.00,0.00,5.56,383.64,'2023-01-31 16:38:08','',''),(890,'1','310','1',1,'Retail Sale Id 848',1497.60,0.00,0.00,2.08,143.52,'2023-01-31 16:55:05','',''),(891,'1','310','1',1,'Retail Sale Id 849',3997.00,0.00,0.00,5.71,279.79,'2023-01-31 17:03:27','',''),(892,'1','310','1',1,'Retail Sale Id 850',9000.00,0.00,0.00,12.50,862.50,'2023-01-31 17:08:42','',''),(893,'1','310','1',1,'Retail Sale Id 851',2001.60,0.00,0.00,2.78,191.82,'2023-01-31 17:10:45','',''),(894,'1','310','1',1,'Retail Sale Id 852',5040.00,0.00,0.00,7.00,483.00,'2023-01-31 17:16:44','',''),(895,'1','310','1',1,'Retail Sale Id 853',3500.00,0.00,0.00,5.00,245.00,'2023-01-31 17:17:44','',''),(896,'1','310','1',1,'Retail Sale Id 854',4320.00,0.00,0.00,6.00,414.00,'2023-01-31 17:19:24','',''),(897,'1','310','1',1,'Retail Sale Id 855',4320.00,0.00,0.00,6.00,414.00,'2023-01-31 17:32:28','',''),(898,'1','310','1',1,'Retail Sale Id 856',9000.00,0.00,0.00,12.50,862.50,'2023-01-31 17:37:56','',''),(899,'1','310','1',1,'Retail Sale Id 856',9000.00,0.00,0.00,12.50,862.50,'2023-01-31 17:37:56','',''),(900,'1','310','1',1,'Retail Sale Id 857',1000.80,0.00,0.00,1.39,95.91,'2023-01-31 17:49:12','',''),(901,'1','310','1',1,'Retail Sale Id 858',9000.00,0.00,0.00,12.50,862.50,'2023-01-31 17:51:49','',''),(902,'1','310','1',1,'Retail Sale Id 859',3600.00,0.00,0.00,5.00,345.00,'2023-01-31 17:56:44','',''),(903,'1','310','1',1,'Retail Sale Id 860',32550.00,0.00,0.00,46.50,2278.50,'2023-01-31 18:00:40','',''),(904,'1','310','1',1,'Retail Sale Id 861',1000.80,0.00,0.00,1.39,95.91,'2023-01-31 18:01:38','',''),(905,'1','310','1',1,'Retail Sale Id 861',1000.80,0.00,0.00,1.39,95.91,'2023-01-31 18:01:38','',''),(906,'1','310','1',1,'Retail Sale Id 862',4320.00,0.00,0.00,6.00,414.00,'2023-01-31 18:05:36','',''),(907,'1','310','1',1,'Retail Sale Id 863',180.00,0.00,0.00,0.25,17.25,'2023-01-31 18:08:41','',''),(908,'1','310','1',1,'Retail Sale Id 865',4320.00,0.00,0.00,6.00,414.00,'2023-01-31 18:11:41','',''),(909,'1','310','1',1,'Retail Sale Id 866',4500.00,0.00,0.00,6.25,431.25,'2023-01-31 18:13:02','',''),(910,'1','310','1',1,'Retail Sale Id 867',496.80,0.00,0.00,0.69,47.61,'2023-01-31 18:13:50','',''),(911,'1','310','1',1,'Retail Sale Id 868',1497.60,0.00,0.00,2.08,143.52,'2023-01-31 18:14:38','',''),(912,'1','310','1',1,'Retail Sale Id 869',496.80,0.00,0.00,0.69,47.61,'2023-01-31 18:15:41','',''),(913,'1','310','1',1,'Retail Sale Id 870',4320.00,0.00,0.00,6.00,414.00,'2023-01-31 18:17:15','',''),(914,'1','310','1',1,'Retail Sale Id 871',1000.80,0.00,0.00,1.39,95.91,'2023-01-31 18:17:49','',''),(915,'1','310','1',1,'Retail Sale Id 872',2001.60,0.00,0.00,2.78,191.82,'2023-01-31 18:18:49','',''),(916,'1','310','1',1,'Retail Sale Id 873',9000.00,0.00,0.00,12.50,862.50,'2023-01-31 18:22:34','',''),(917,'1','310','1',1,'Retail Sale Id 874',2498.40,0.00,0.00,3.47,239.43,'2023-01-31 18:24:04','',''),(918,'1','310','1',1,'Retail Sale Id 875',1000.80,0.00,0.00,1.39,95.91,'2023-01-31 18:27:07','',''),(919,'1','310','1',1,'Retail Sale Id 876',4399.20,0.00,0.00,6.11,421.59,'2023-01-31 18:29:20','',''),(920,'1','310','1',1,'Retail Sale Id 877',496.80,0.00,0.00,0.69,47.61,'2023-01-31 18:30:34','',''),(921,'1','310','1',1,'Retail Sale Id 878',2498.40,0.00,0.00,3.47,239.43,'2023-01-31 18:32:06','',''),(922,'1','310','1',1,'Return of Retail Sale Id 853',0.00,3500.00,5.00,0.00,-245.00,'2023-01-31 19:06:11','',''),(923,'1','310','1',1,'Retail Sale Id 879',3395.00,0.00,0.00,4.85,237.65,'2023-01-31 19:07:15','',''),(924,'1','310','1',1,'Retail Sale Id 880',424.80,0.00,0.00,0.59,40.71,'2023-01-31 19:08:04','',''),(925,'1','310','1',1,'Retail Sale Id 881',3002.40,0.00,0.00,4.17,287.73,'2023-02-01 07:41:56','',''),(926,'1','310','1',1,'Retail Sale Id 882',2160.00,0.00,0.00,3.00,207.00,'2023-02-01 07:48:00','',''),(927,'1','310','1',1,'Retail Sale Id 883',9000.00,0.00,0.00,12.50,862.50,'2023-02-01 08:07:25','',''),(928,'1','310','1',1,'Retail Sale Id 884',4320.00,0.00,0.00,6.00,414.00,'2023-02-01 08:09:44','',''),(929,'1','310','1',1,'Retail Sale Id 885',2160.00,0.00,0.00,3.00,207.00,'2023-02-01 08:16:42','',''),(930,'1','310','1',1,'Retail Sale Id 886',4320.00,0.00,0.00,6.00,414.00,'2023-02-01 08:18:19','',''),(931,'1','310','1',1,'Retail Sale Id 887',2160.00,0.00,0.00,3.00,207.00,'2023-02-01 08:25:35','',''),(932,'1','310','1',1,'Retail Sale Id 888',1800.00,0.00,0.00,2.50,172.50,'2023-02-01 08:26:30','',''),(933,'1','310','1',1,'Retail Sale Id 889',4996.80,0.00,0.00,6.94,478.86,'2023-02-01 08:28:16','',''),(934,'1','310','1',1,'Retail Sale Id 890',7200.00,0.00,0.00,10.00,690.00,'2023-02-01 08:42:39','',''),(935,'1','310','1',1,'Retail Sale Id 891',9000.00,0.00,0.00,12.50,862.50,'2023-02-01 08:43:46','',''),(936,'1','310','1',1,'Retail Sale Id 893',3002.40,0.00,0.00,4.17,287.73,'2023-02-01 08:52:01','',''),(937,'1','310','1',1,'Retail Sale Id 894',4003.20,0.00,0.00,5.56,383.64,'2023-02-01 09:02:30','',''),(938,'1','310','1',1,'Retail Sale Id 895',698.40,0.00,0.00,0.97,66.93,'2023-02-01 09:20:06','',''),(939,'1','310','1',1,'Retail Sale Id 896',3002.40,0.00,0.00,4.17,287.73,'2023-02-01 09:21:01','',''),(940,'1','310','1',1,'Retail Sale Id 897',496.80,0.00,0.00,0.69,47.61,'2023-02-01 09:22:23','',''),(941,'1','310','1',1,'Retail Sale Id 898',4399.20,0.00,0.00,6.11,421.59,'2023-02-01 09:23:25','',''),(942,'1','310','1',1,'Retail Sale Id 899',8400.00,0.00,0.00,12.00,588.00,'2023-02-01 09:34:19','',''),(943,'1','310','1',1,'Retail Sale Id 900',9000.00,0.00,0.00,12.50,862.50,'2023-02-01 09:40:13','',''),(944,'1','310','1',1,'Retail Sale Id 901',5760.00,0.00,0.00,8.00,552.00,'2023-02-01 09:41:46','',''),(945,'1','310','1',1,'Retail Sale Id 902',9000.00,0.00,0.00,12.50,862.50,'2023-02-01 09:43:59','',''),(946,'1','310','1',1,'Retail Sale Id 903',2160.00,0.00,0.00,3.00,207.00,'2023-02-01 09:45:33','',''),(947,'1','310','1',1,'Retail Sale Id 904',2160.00,0.00,0.00,3.00,207.00,'2023-02-01 10:03:53','',''),(948,'1','310','1',1,'Retail Sale Id 905',4320.00,0.00,0.00,6.00,414.00,'2023-02-01 10:14:07','',''),(949,'1','310','1',1,'Retail Sale Id 906',9000.00,0.00,0.00,12.50,862.50,'2023-02-01 10:20:39','',''),(950,'1','310','1',1,'Retail Sale Id 907',4320.00,0.00,0.00,6.00,414.00,'2023-02-01 10:25:18','',''),(951,'1','310','1',1,'Retail Sale Id 907',4320.00,0.00,0.00,6.00,414.00,'2023-02-01 10:25:18','',''),(952,'1','310','1',1,'Retail Sale Id 908',2203.20,0.00,0.00,3.06,211.14,'2023-02-01 10:35:59','',''),(953,'1','310','1',1,'Retail Sale Id 911',4500.00,0.00,0.00,6.25,431.25,'2023-02-01 12:18:33','',''),(954,'1','310','1',1,'Retail Sale Id 912',9000.00,0.00,0.00,12.50,862.50,'2023-02-01 12:26:00','',''),(955,'1','310','1',1,'Retail Sale Id 913',2160.00,0.00,0.00,3.00,207.00,'2023-02-01 12:53:05','',''),(956,'1','310','1',1,'Retail Sale Id 914',2498.40,0.00,0.00,3.47,239.43,'2023-02-01 12:57:38','',''),(957,'1','310','1',1,'Retail Sale Id 915',7200.00,0.00,0.00,10.00,690.00,'2023-02-01 13:15:57','',''),(958,'1','310','1',1,'Retail Sale Id 916',1497.60,0.00,0.00,2.08,143.52,'2023-02-01 13:16:50','',''),(959,'1','310','1',1,'Retail Sale Id 917',9000.00,0.00,0.00,12.50,862.50,'2023-02-01 13:29:21','',''),(960,'1','310','1',1,'Retail Sale Id 918',9000.00,0.00,0.00,12.50,862.50,'2023-02-01 13:36:21','',''),(961,'1','310','1',1,'Retail Sale Id 919',4399.20,0.00,0.00,6.11,421.59,'2023-02-01 13:37:59','',''),(962,'1','310','1',1,'Retail Sale Id 920',2001.60,0.00,0.00,2.78,191.82,'2023-02-01 13:40:15','',''),(963,'1','310','1',1,'Retail Sale Id 921',4996.80,0.00,0.00,6.94,478.86,'2023-02-01 13:43:09','',''),(964,'1','310','1',1,'Retail Sale Id 921',4996.80,0.00,0.00,6.94,478.86,'2023-02-01 13:43:09','',''),(965,'1','310','1',1,'Retail Sale Id 922',403.20,0.00,0.00,0.56,38.64,'2023-02-01 13:51:35','',''),(966,'1','310','1',1,'Retail Sale Id 923',2001.60,0.00,0.00,2.78,191.82,'2023-02-01 14:02:33','',''),(967,'1','310','1',1,'Retail Sale Id 924',1497.60,0.00,0.00,2.08,143.52,'2023-02-01 14:03:24','',''),(968,'1','310','1',1,'Retail Sale Id 925',4320.00,0.00,0.00,6.00,414.00,'2023-02-01 14:11:10','',''),(969,'1','310','1',1,'Retail Sale Id 926',2498.40,0.00,0.00,3.47,239.43,'2023-02-01 14:13:48','',''),(970,'1','310','1',1,'Retail Sale Id 926',4996.80,0.00,0.00,6.94,478.86,'2023-02-01 14:13:48','',''),(971,'1','310','1',1,'Retail Sale Id 927',1497.60,0.00,0.00,2.08,143.52,'2023-02-01 14:16:52','',''),(972,'1','310','1',1,'Retail Sale Id 928',4320.00,0.00,0.00,6.00,414.00,'2023-02-01 14:23:04','',''),(973,'1','310','1',1,'Retail Sale Id 929',8001.00,0.00,0.00,11.43,560.07,'2023-02-01 14:24:40','',''),(974,'1','310','1',1,'Retail Sale Id 930',3600.00,0.00,0.00,5.00,345.00,'2023-02-01 14:30:10','',''),(975,'1','310','1',1,'Retail Sale Id 930',9000.00,0.00,0.00,12.50,862.50,'2023-02-01 14:30:10','',''),(976,'1','310','1',1,'Retail Sale Id 931',1497.60,0.00,0.00,2.08,143.52,'2023-02-01 14:33:58','',''),(977,'1','310','1',1,'Retail Sale Id 932',1000.80,0.00,0.00,1.39,95.91,'2023-02-01 14:42:14','',''),(978,'1','310','1',1,'Retail Sale Id 933',9000.00,0.00,0.00,12.50,862.50,'2023-02-01 15:03:27','',''),(979,'1','310','1',1,'Retail Sale Id 934',1000.80,0.00,0.00,1.39,95.91,'2023-02-01 15:10:38','',''),(980,'1','310','1',1,'Retail Sale Id 935',2203.20,0.00,0.00,3.06,211.14,'2023-02-01 15:13:37','',''),(981,'1','310','1',1,'Retail Sale Id 935',9000.00,0.00,0.00,12.50,862.50,'2023-02-01 15:13:37','',''),(982,'1','310','1',1,'Retail Sale Id 936',2160.00,0.00,0.00,3.00,207.00,'2023-02-01 15:16:02','',''),(983,'1','310','1',1,'Retail Sale Id 937',4320.00,0.00,0.00,6.00,414.00,'2023-02-01 15:29:24','',''),(984,'1','310','1',1,'Retail Sale Id 938',2001.60,0.00,0.00,2.78,191.82,'2023-02-01 15:54:23','',''),(985,'1','310','1',1,'Retail Sale Id 939',4996.80,0.00,0.00,6.94,478.86,'2023-02-01 15:57:52','',''),(986,'1','310','1',1,'Retail Sale Id 940',11998.00,0.00,0.00,17.14,839.86,'2023-02-01 16:04:41','',''),(987,'1','310','1',1,'Retail Sale Id 941',4996.80,0.00,0.00,6.94,478.86,'2023-02-01 16:07:25','',''),(988,'1','310','1',1,'Retail Sale Id 942',2001.60,0.00,0.00,2.78,191.82,'2023-02-01 16:09:01','',''),(989,'1','310','1',1,'Retail Sale Id 943',4320.00,0.00,0.00,6.00,414.00,'2023-02-01 16:11:07','',''),(990,'1','310','1',1,'Retail Sale Id 944',748.80,0.00,0.00,1.04,71.76,'2023-02-01 16:56:15','',''),(991,'1','310','1',1,'Retail Sale Id 945',3002.40,0.00,0.00,4.17,287.73,'2023-02-01 17:05:21','',''),(992,'1','310','1',1,'Retail Sale Id 946',2001.60,0.00,0.00,2.78,191.82,'2023-02-01 17:07:59','',''),(993,'1','310','1',1,'Retail Sale Id 947',4320.00,0.00,0.00,6.00,414.00,'2023-02-01 17:21:52','',''),(994,'1','310','1',1,'Retail Sale Id 948',3600.00,0.00,0.00,5.00,345.00,'2023-02-01 17:23:09','',''),(995,'1','310','1',1,'Retail Sale Id 949',2901.60,0.00,0.00,4.03,278.07,'2023-02-01 17:26:44','',''),(996,'1','310','1',1,'Retail Sale Id 950',4399.20,0.00,0.00,6.11,421.59,'2023-02-01 17:28:14','',''),(997,'1','310','1',1,'Retail Sale Id 951',2160.00,0.00,0.00,3.00,207.00,'2023-02-01 17:33:26','',''),(998,'1','310','1',1,'Retail Sale Id 951',4320.00,0.00,0.00,6.00,414.00,'2023-02-01 17:33:26','',''),(999,'1','310','1',1,'Retail Sale Id 951',9000.00,0.00,0.00,12.50,862.50,'2023-02-01 17:33:26','',''),(1000,'1','310','1',1,'Retail Sale Id 952',9000.00,0.00,0.00,12.50,862.50,'2023-02-01 17:38:33','',''),(1001,'1','310','1',1,'Retail Sale Id 954',7200.00,0.00,0.00,10.00,690.00,'2023-02-01 17:42:02','',''),(1002,'1','310','1',1,'Retail Sale Id 955',698.40,0.00,0.00,0.97,66.93,'2023-02-01 17:44:44','',''),(1003,'1','310','1',1,'Retail Sale Id 956',1000.80,0.00,0.00,1.39,95.91,'2023-02-01 17:50:10','',''),(1004,'1','310','1',1,'Retail Sale Id 957',698.40,0.00,0.00,0.97,66.93,'2023-02-01 17:51:38','',''),(1005,'1','310','1',1,'Retail Sale Id 958',4320.00,0.00,0.00,6.00,414.00,'2023-02-01 17:56:39','',''),(1006,'1','310','1',1,'Retail Sale Id 959',1497.60,0.00,0.00,2.08,143.52,'2023-02-01 17:58:22','',''),(1007,'1','310','1',1,'Retail Sale Id 960',9000.00,0.00,0.00,12.50,862.50,'2023-02-01 18:03:27','',''),(1008,'1','310','1',1,'Retail Sale Id 961',1497.60,0.00,0.00,2.08,143.52,'2023-02-01 18:08:31','',''),(1009,'1','310','1',1,'Retail Sale Id 962',2203.20,0.00,0.00,3.06,211.14,'2023-02-01 18:14:39','',''),(1010,'1','310','1',1,'Retail Sale Id 963',1497.60,0.00,0.00,2.08,143.52,'2023-02-01 18:20:43','',''),(1011,'1','310','1',1,'Retail Sale Id 964',2203.20,0.00,0.00,3.06,211.14,'2023-02-01 18:22:53','',''),(1012,'1','310','1',1,'Retail Sale Id 965',1000.80,0.00,0.00,1.39,95.91,'2023-02-01 18:26:08','',''),(1013,'1','310','1',1,'Retail Sale Id 966',1440.00,0.00,0.00,2.00,138.00,'2023-02-01 18:27:32','',''),(1014,'1','310','1',1,'Retail Sale Id 968',3002.40,0.00,0.00,4.17,287.73,'2023-02-01 18:29:23','',''),(1015,'1','310','1',1,'Retail Sale Id 969',9000.00,0.00,0.00,12.50,862.50,'2023-02-01 18:31:15','',''),(1016,'1','310','1',1,'Retail Sale Id 970',1000.80,0.00,0.00,1.39,95.91,'2023-02-01 18:39:26','',''),(1017,'1','310','1',1,'Retail Sale Id 971',2001.60,0.00,0.00,2.78,191.82,'2023-02-01 18:45:17','',''),(1018,'1','310','1',1,'Retail Sale Id 973',54777.60,0.00,0.00,76.08,5249.52,'2023-02-01 19:30:47','',''),(1019,'1','310','1',1,'Return of Retail Sale Id 973',0.00,54777.60,76.08,0.00,-5249.52,'2023-02-01 19:32:28','',''),(1020,'1','310','1',1,'Retail Sale Id 974',54775.00,0.00,0.00,78.25,3834.25,'2023-02-01 19:33:21','',''),(1021,'1','310','1',1,'Retail Sale Id 975',65188.80,0.00,0.00,90.54,6247.26,'2023-02-01 19:36:15','',''),(1022,'1','310','1',1,'Retail Sale Id 976',4320.00,0.00,0.00,6.00,414.00,'2023-02-02 07:34:43','',''),(1023,'1','310','1',1,'Retail Sale Id 977',4003.20,0.00,0.00,5.56,383.64,'2023-02-02 07:36:38','',''),(1024,'1','310','1',1,'Retail Sale Id 978',42000.00,0.00,0.00,60.00,2940.00,'2023-02-02 07:38:21','',''),(1025,'1','310','1',1,'Retail Sale Id 979',3002.40,0.00,0.00,4.17,287.73,'2023-02-02 07:39:08','',''),(1026,'1','310','1',1,'Retail Sale Id 980',3801.00,0.00,0.00,5.43,266.07,'2023-02-02 07:49:41','',''),(1027,'1','310','1',1,'Retail Sale Id 981',2498.40,0.00,0.00,3.47,239.43,'2023-02-02 07:50:27','',''),(1028,'1','310','1',1,'Retail Sale Id 982',3500.00,0.00,0.00,5.00,245.00,'2023-02-02 07:55:40','',''),(1029,'1','310','1',1,'Retail Sale Id 984',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 08:02:12','',''),(1030,'1','310','1',1,'Retail Sale Id 985',4320.00,0.00,0.00,6.00,414.00,'2023-02-02 08:03:31','',''),(1031,'1','310','1',1,'Retail Sale Id 986',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 08:19:40','',''),(1032,'1','310','1',1,'Retail Sale Id 987',4003.20,0.00,0.00,5.56,383.64,'2023-02-02 08:21:00','',''),(1033,'1','310','1',1,'Retail Sale Id 988',2160.00,0.00,0.00,3.00,207.00,'2023-02-02 08:21:52','',''),(1034,'1','310','1',1,'Retail Sale Id 989',2001.60,0.00,0.00,2.78,191.82,'2023-02-02 08:26:03','',''),(1035,'1','310','1',1,'Retail Sale Id 990',2160.00,0.00,0.00,3.00,207.00,'2023-02-02 08:36:59','',''),(1036,'1','310','1',1,'Retail Sale Id 990',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 08:36:59','',''),(1037,'1','310','1',1,'Retail Sale Id 991',3002.40,0.00,0.00,4.17,287.73,'2023-02-02 09:01:56','',''),(1038,'1','310','1',1,'Retail Sale Id 992',3600.00,0.00,0.00,5.00,345.00,'2023-02-02 09:11:02','',''),(1039,'1','310','1',1,'Retail Sale Id 993',4996.80,0.00,0.00,6.94,478.86,'2023-02-02 09:12:18','',''),(1040,'1','310','1',1,'Retail Sale Id 994',6998.40,0.00,0.00,9.72,670.68,'2023-02-02 09:14:54','',''),(1041,'1','310','1',1,'Retail Sale Id 996',4996.80,0.00,0.00,6.94,478.86,'2023-02-02 09:31:34','',''),(1042,'1','310','1',1,'Retail Sale Id 997',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 09:33:04','',''),(1043,'1','310','1',1,'Retail Sale Id 998',3002.40,0.00,0.00,4.17,287.73,'2023-02-02 09:53:12','',''),(1044,'1','310','1',1,'Retail Sale Id 999',42000.00,0.00,0.00,60.00,2940.00,'2023-02-02 09:58:34','',''),(1045,'1','310','1',1,'Retail Sale Id 1000',42000.00,0.00,0.00,60.00,2940.00,'2023-02-02 09:59:29','',''),(1046,'1','310','1',1,'Retail Sale Id 1001',42000.00,0.00,0.00,60.00,2940.00,'2023-02-02 10:00:25','',''),(1047,'1','310','1',1,'Retail Sale Id 1002',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 10:20:30','',''),(1048,'1','310','1',1,'Retail Sale Id 1003',4320.00,0.00,0.00,6.00,414.00,'2023-02-02 10:34:11','',''),(1049,'1','310','1',1,'Retail Sale Id 1004',4003.20,0.00,0.00,5.56,383.64,'2023-02-02 10:37:42','',''),(1050,'1','310','1',1,'Retail Sale Id 1005',62895.00,0.00,0.00,89.85,4402.65,'2023-02-02 10:44:55','',''),(1051,'1','310','1',1,'Retail Sale Id 1006',35000.00,0.00,0.00,50.00,2450.00,'2023-02-02 10:46:35','',''),(1052,'1','310','1',1,'Retail Sale Id 1007',35000.00,0.00,0.00,50.00,2450.00,'2023-02-02 10:47:24','',''),(1053,'1','310','1',1,'Retail Sale Id 1008',3600.00,0.00,0.00,5.00,345.00,'2023-02-02 10:49:05','',''),(1054,'1','310','1',1,'Retail Sale Id 1009',2160.00,0.00,0.00,3.00,207.00,'2023-02-02 10:50:54','',''),(1055,'1','310','1',1,'Retail Sale Id 1010',3319.20,0.00,0.00,4.61,318.09,'2023-02-02 10:54:22','',''),(1056,'1','310','1',1,'Retail Sale Id 1011',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 10:59:20','',''),(1057,'1','310','1',1,'Retail Sale Id 1011',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 10:59:20','',''),(1058,'1','310','1',1,'Retail Sale Id 1012',35000.00,0.00,0.00,50.00,2450.00,'2023-02-02 11:05:05','',''),(1059,'1','310','1',1,'Retail Sale Id 1013',35000.00,0.00,0.00,50.00,2450.00,'2023-02-02 11:05:57','',''),(1060,'1','310','1',1,'Retail Sale Id 1014',4320.00,0.00,0.00,6.00,414.00,'2023-02-02 11:13:25','',''),(1061,'1','310','1',1,'Retail Sale Id 1015',2160.00,0.00,0.00,3.00,207.00,'2023-02-02 11:17:40','',''),(1062,'1','310','1',1,'Retail Sale Id 1016',4320.00,0.00,0.00,6.00,414.00,'2023-02-02 11:22:55','',''),(1063,'1','310','1',1,'Retail Sale Id 1017',4320.00,0.00,0.00,6.00,414.00,'2023-02-02 12:05:03','',''),(1064,'1','310','1',1,'Retail Sale Id 1019',6480.00,0.00,0.00,9.00,621.00,'2023-02-02 12:12:44','',''),(1065,'1','310','1',1,'Retail Sale Id 1020',3600.00,0.00,0.00,5.00,345.00,'2023-02-02 12:16:20','',''),(1066,'1','310','1',1,'Retail Sale Id 1020',10800.00,0.00,0.00,15.00,1035.00,'2023-02-02 12:16:20','',''),(1067,'1','310','1',1,'Retail Sale Id 1021',4320.00,0.00,0.00,6.00,414.00,'2023-02-02 12:26:10','',''),(1068,'1','310','1',1,'Retail Sale Id 1022',4320.00,0.00,0.00,6.00,414.00,'2023-02-02 12:32:39','',''),(1069,'1','310','1',1,'Retail Sale Id 1022',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 12:32:39','',''),(1070,'1','310','1',1,'Retail Sale Id 1023',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 12:38:36','',''),(1071,'1','310','1',1,'Retail Sale Id 1024',4320.00,0.00,0.00,6.00,414.00,'2023-02-02 12:43:34','',''),(1072,'1','310','1',1,'Retail Sale Id 1025',4320.00,0.00,0.00,6.00,414.00,'2023-02-02 12:46:21','',''),(1073,'1','310','1',1,'Retail Sale Id 1026',4200.00,0.00,0.00,6.00,294.00,'2023-02-02 12:48:22','',''),(1074,'1','310','1',1,'Retail Sale Id 1028',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 12:58:40','',''),(1075,'1','310','1',1,'Retail Sale Id 1029',38500.00,0.00,0.00,55.00,2695.00,'2023-02-02 13:01:33','',''),(1076,'1','310','1',1,'Retail Sale Id 1030',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 13:02:36','',''),(1077,'1','310','1',1,'Retail Sale Id 1031',2160.00,0.00,0.00,3.00,207.00,'2023-02-02 13:04:10','',''),(1078,'1','310','1',1,'Retail Sale Id 1031',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 13:04:10','',''),(1079,'1','310','1',1,'Retail Sale Id 1032',7999.20,0.00,0.00,11.11,766.59,'2023-02-02 13:05:23','',''),(1080,'1','310','1',1,'Retail Sale Id 1033',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 13:06:40','',''),(1081,'1','310','1',1,'Retail Sale Id 1034',900.00,0.00,0.00,1.25,86.25,'2023-02-02 13:07:41','',''),(1082,'1','310','1',1,'Retail Sale Id 1035',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 13:16:16','',''),(1083,'1','310','1',1,'Retail Sale Id 1036',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 13:47:08','',''),(1084,'1','310','1',1,'Retail Sale Id 1037',3600.00,0.00,0.00,5.00,345.00,'2023-02-02 13:49:06','',''),(1085,'1','310','1',1,'Retail Sale Id 1038',36001.00,0.00,0.00,51.43,2520.07,'2023-02-02 14:01:06','',''),(1086,'1','310','1',1,'Retail Sale Id 1039',3002.40,0.00,0.00,4.17,287.73,'2023-02-02 14:13:01','',''),(1087,'1','310','1',1,'Retail Sale Id 1040',1440.00,0.00,0.00,2.00,138.00,'2023-02-02 14:22:26','',''),(1088,'1','310','1',1,'Retail Sale Id 1041',2001.60,0.00,0.00,2.78,191.82,'2023-02-02 14:23:27','',''),(1089,'1','310','1',1,'Retail Sale Id 1042',3002.40,0.00,0.00,4.17,287.73,'2023-02-02 14:28:30','',''),(1090,'1','310','1',1,'Retail Sale Id 1043',3002.40,0.00,0.00,4.17,287.73,'2023-02-02 14:33:46','',''),(1091,'1','310','1',1,'Retail Sale Id 1044',2203.20,0.00,0.00,3.06,211.14,'2023-02-02 14:35:12','',''),(1092,'1','310','1',1,'Retail Sale Id 1045',9360.00,0.00,0.00,13.00,897.00,'2023-02-02 14:37:07','',''),(1093,'1','310','1',1,'Retail Sale Id 1046',2203.20,0.00,0.00,3.06,211.14,'2023-02-02 14:39:49','',''),(1094,'1','310','1',1,'Retail Sale Id 1047',9359.00,0.00,0.00,13.37,655.13,'2023-02-02 14:45:06','',''),(1095,'1','310','1',1,'Retail Sale Id 1048',3499.20,0.00,0.00,4.86,335.34,'2023-02-02 14:45:58','',''),(1096,'1','310','1',1,'Return of Retail Sale Id 1045',0.00,9360.00,13.00,0.00,-897.00,'2023-02-02 14:47:21','',''),(1097,'1','310','1',1,'Retail Sale Id 1049',2001.60,0.00,0.00,2.78,191.82,'2023-02-02 14:59:50','',''),(1098,'1','310','1',1,'Retail Sale Id 1050',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 15:02:49','',''),(1099,'1','310','1',1,'Retail Sale Id 1051',1000.80,0.00,0.00,1.39,95.91,'2023-02-02 15:17:57','',''),(1100,'1','310','1',1,'Retail Sale Id 1052',2203.20,0.00,0.00,3.06,211.14,'2023-02-02 15:19:09','',''),(1101,'1','310','1',1,'Retail Sale Id 1053',2001.60,0.00,0.00,2.78,191.82,'2023-02-02 15:25:38','',''),(1102,'1','310','1',1,'Retail Sale Id 1054',4320.00,0.00,0.00,6.00,414.00,'2023-02-02 15:29:56','',''),(1103,'1','310','1',1,'Retail Sale Id 1055',7999.20,0.00,0.00,11.11,766.59,'2023-02-02 15:31:21','',''),(1104,'1','310','1',1,'Retail Sale Id 1056',3600.00,0.00,0.00,5.00,345.00,'2023-02-02 15:33:00','',''),(1105,'1','310','1',1,'Retail Sale Id 1058',4996.80,0.00,0.00,6.94,478.86,'2023-02-02 15:49:27','',''),(1106,'1','310','1',1,'Retail Sale Id 1059',70000.00,0.00,0.00,100.00,4900.00,'2023-02-02 15:54:20','',''),(1107,'1','310','1',1,'Retail Sale Id 1060',2001.60,0.00,0.00,2.78,191.82,'2023-02-02 15:56:33','',''),(1108,'1','310','1',1,'Retail Sale Id 1061',3600.00,0.00,0.00,5.00,345.00,'2023-02-02 15:57:18','',''),(1109,'1','310','1',1,'Retail Sale Id 1062',4320.00,0.00,0.00,6.00,414.00,'2023-02-02 16:01:10','',''),(1110,'1','310','1',1,'Retail Sale Id 1063',1000.80,0.00,0.00,1.39,95.91,'2023-02-02 16:09:01','',''),(1111,'1','310','1',1,'Retail Sale Id 1064',2001.60,0.00,0.00,2.78,191.82,'2023-02-02 16:11:56','',''),(1112,'1','310','1',1,'Retail Sale Id 1065',4996.80,0.00,0.00,6.94,478.86,'2023-02-02 16:14:02','',''),(1113,'1','310','1',1,'Retail Sale Id 1068',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 16:16:13','',''),(1114,'1','310','1',1,'Retail Sale Id 1069',4320.00,0.00,0.00,6.00,414.00,'2023-02-02 16:28:58','',''),(1115,'1','310','1',1,'Retail Sale Id 1070',3600.00,0.00,0.00,5.00,345.00,'2023-02-02 16:32:00','',''),(1116,'1','310','1',1,'Retail Sale Id 1071',2498.40,0.00,0.00,3.47,239.43,'2023-02-02 16:33:40','',''),(1117,'1','310','1',1,'Retail Sale Id 1072',1497.60,0.00,0.00,2.08,143.52,'2023-02-02 16:35:31','',''),(1118,'1','310','1',1,'Retail Sale Id 1074',3600.00,0.00,0.00,5.00,345.00,'2023-02-02 16:41:02','',''),(1119,'1','310','1',1,'Retail Sale Id 1074',3600.00,0.00,0.00,5.00,345.00,'2023-02-02 16:41:02','',''),(1120,'1','310','1',1,'Retail Sale Id 1075',8750.00,0.00,0.00,12.50,612.50,'2023-02-02 16:43:30','',''),(1121,'1','310','1',1,'Retail Sale Id 1076',2160.00,0.00,0.00,3.00,207.00,'2023-02-02 16:44:12','',''),(1122,'1','310','1',1,'Retail Sale Id 1077',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 16:48:13','',''),(1123,'1','310','1',1,'Retail Sale Id 1077',10000.80,0.00,0.00,13.89,958.41,'2023-02-02 16:48:13','',''),(1124,'1','310','1',1,'Retail Sale Id 1078',2160.00,0.00,0.00,3.00,207.00,'2023-02-02 16:50:55','',''),(1125,'1','310','1',1,'Retail Sale Id 1079',7200.00,0.00,0.00,10.00,690.00,'2023-02-02 16:51:37','',''),(1126,'1','310','1',1,'Retail Sale Id 1080',4003.20,0.00,0.00,5.56,383.64,'2023-02-02 16:53:08','',''),(1127,'1','310','1',1,'Retail Sale Id 1081',4298.40,0.00,0.00,5.97,411.93,'2023-02-02 16:55:24','',''),(1128,'1','310','1',1,'Retail Sale Id 1082',2001.60,0.00,0.00,2.78,191.82,'2023-02-02 16:57:05','',''),(1129,'1','310','1',1,'Retail Sale Id 1083',4320.00,0.00,0.00,6.00,414.00,'2023-02-02 16:59:54','',''),(1130,'1','310','1',1,'Retail Sale Id 1084',2001.60,0.00,0.00,2.78,191.82,'2023-02-02 17:04:33','',''),(1131,'1','310','1',1,'Retail Sale Id 1085',2203.20,0.00,0.00,3.06,211.14,'2023-02-02 17:07:59','',''),(1132,'1','310','1',1,'Retail Sale Id 1087',3888.00,0.00,0.00,5.40,372.60,'2023-02-02 17:10:34','',''),(1133,'1','310','1',1,'Retail Sale Id 1088',2887.20,0.00,0.00,4.01,276.69,'2023-02-02 17:11:04','',''),(1134,'1','310','1',1,'Retail Sale Id 1089',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 17:11:50','',''),(1135,'1','310','1',1,'Retail Sale Id 1090',2001.60,0.00,0.00,2.78,191.82,'2023-02-02 17:14:29','',''),(1136,'1','310','1',1,'Retail Sale Id 1091',2152.80,0.00,0.00,2.99,206.31,'2023-02-02 17:15:59','',''),(1137,'1','310','1',1,'Retail Sale Id 1092',3600.00,0.00,0.00,5.00,345.00,'2023-02-02 17:18:23','',''),(1138,'1','310','1',1,'Retail Sale Id 1093',1497.60,0.00,0.00,2.08,143.52,'2023-02-02 17:22:53','',''),(1139,'1','310','1',1,'Retail Sale Id 1094',2498.40,0.00,0.00,3.47,239.43,'2023-02-02 17:24:40','',''),(1140,'1','310','1',1,'Retail Sale Id 1094',2498.40,0.00,0.00,3.47,239.43,'2023-02-02 17:24:40','',''),(1141,'1','310','1',1,'Retail Sale Id 1095',2001.60,0.00,0.00,2.78,191.82,'2023-02-02 17:26:56','',''),(1142,'1','310','1',1,'Retail Sale Id 1096',4399.20,0.00,0.00,6.11,421.59,'2023-02-02 17:28:14','',''),(1143,'1','310','1',1,'Retail Sale Id 1097',2203.20,0.00,0.00,3.06,211.14,'2023-02-02 17:30:32','',''),(1144,'1','310','1',1,'Retail Sale Id 1098',2203.20,0.00,0.00,3.06,211.14,'2023-02-02 17:32:02','',''),(1145,'1','310','1',1,'Retail Sale Id 1099',2001.60,0.00,0.00,2.78,191.82,'2023-02-02 17:34:04','',''),(1146,'1','310','1',1,'Retail Sale Id 1100',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 17:35:19','',''),(1147,'1','310','1',1,'Retail Sale Id 1101',2160.00,0.00,0.00,3.00,207.00,'2023-02-02 17:37:07','',''),(1148,'1','310','1',1,'Retail Sale Id 1103',2160.00,0.00,0.00,3.00,207.00,'2023-02-02 17:40:43','',''),(1149,'1','310','1',1,'Retail Sale Id 1104',2203.20,0.00,0.00,3.06,211.14,'2023-02-02 17:42:36','',''),(1150,'1','310','1',1,'Retail Sale Id 1104',2203.20,0.00,0.00,3.06,211.14,'2023-02-02 17:42:36','',''),(1151,'1','310','1',1,'Retail Sale Id 1105',2203.20,0.00,0.00,3.06,211.14,'2023-02-02 17:45:18','',''),(1152,'1','310','1',1,'Retail Sale Id 1106',3002.40,0.00,0.00,4.17,287.73,'2023-02-02 17:46:02','',''),(1153,'1','310','1',1,'Retail Sale Id 1107',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 17:48:14','',''),(1154,'1','310','1',1,'Retail Sale Id 1108',3600.00,0.00,0.00,5.00,345.00,'2023-02-02 17:49:53','',''),(1155,'1','310','1',1,'Retail Sale Id 1109',1000.80,0.00,0.00,1.39,95.91,'2023-02-02 17:51:37','',''),(1156,'1','310','1',1,'Retail Sale Id 1110',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 17:53:23','',''),(1157,'1','310','1',1,'Retail Sale Id 1111',2203.20,0.00,0.00,3.06,211.14,'2023-02-02 17:55:20','',''),(1158,'1','310','1',1,'Retail Sale Id 1112',2498.40,0.00,0.00,3.47,239.43,'2023-02-02 17:56:19','',''),(1159,'1','310','1',1,'Retail Sale Id 1113',2001.60,0.00,0.00,2.78,191.82,'2023-02-02 17:57:28','',''),(1160,'1','310','1',1,'Retail Sale Id 1114',9000.00,0.00,0.00,12.50,862.50,'2023-02-02 17:58:21','',''),(1161,'1','310','1',1,'Retail Sale Id 1115',4320.00,0.00,0.00,6.00,414.00,'2023-02-02 18:03:42','',''),(1162,'1','310','1',1,'Retail Sale Id 1116',4003.20,0.00,0.00,5.56,383.64,'2023-02-02 18:04:51','',''),(1163,'1','310','1',1,'Retail Sale Id 1117',1497.60,0.00,0.00,2.08,143.52,'2023-02-02 18:06:40','',''),(1164,'1','310','1',1,'Retail Sale Id 1118',4320.00,0.00,0.00,6.00,414.00,'2023-02-02 18:08:19','',''),(1165,'1','310','1',1,'Retail Sale Id 1119',3600.00,0.00,0.00,5.00,345.00,'2023-02-02 18:24:56','',''),(1166,'1','310','1',1,'Retail Sale Id 1120',2160.00,0.00,0.00,3.00,207.00,'2023-02-02 18:26:50','',''),(1167,'1','310','1',1,'Retail Sale Id 1121',1000.80,0.00,0.00,1.39,95.91,'2023-02-02 18:29:24','',''),(1168,'1','310','1',1,'Retail Sale Id 1122',1000.80,0.00,0.00,1.39,95.91,'2023-02-02 18:30:40','',''),(1169,'1','310','1',1,'Retail Sale Id 1123',4320.00,0.00,0.00,6.00,414.00,'2023-02-02 18:33:43','',''),(1170,'1','310','1',1,'Retail Sale Id 1124',2160.00,0.00,0.00,3.00,207.00,'2023-02-02 18:39:31','',''),(1171,'1','310','1',1,'Retail Sale Id 1125',4320.00,0.00,0.00,6.00,414.00,'2023-02-02 18:41:44','',''),(1172,'1','310','1',1,'Retail Sale Id 1126',2001.60,0.00,0.00,2.78,191.82,'2023-02-02 18:54:07','',''),(1173,'1','310','1',1,'Return of Retail Sale Id 1107',0.00,9000.00,12.50,0.00,-862.50,'2023-02-02 19:32:24','',''),(1174,'1','310','1',1,'Return of Retail Sale Id 1075',0.00,8750.00,12.50,0.00,-612.50,'2023-02-02 19:33:10','',''),(1175,'1','310','1',1,'Retail Sale Id 1127',849.60,0.00,0.00,1.18,81.42,'2023-02-02 19:34:13','',''),(1176,'1','310','1',1,'Retail Sale Id 1128',8596.00,0.00,0.00,12.28,601.72,'2023-02-02 19:34:58','',''),(1177,'1','310','1',1,'Retail Sale Id 1129',9000.00,0.00,0.00,12.50,862.50,'2023-02-03 07:48:11','',''),(1178,'1','310','1',1,'Retail Sale Id 1130',4320.00,0.00,0.00,6.00,414.00,'2023-02-03 07:51:05','',''),(1179,'1','310','1',1,'Retail Sale Id 1131',1000.80,0.00,0.00,1.39,95.91,'2023-02-03 07:52:50','',''),(1180,'1','310','1',1,'Retail Sale Id 1132',1396.80,0.00,0.00,1.94,133.86,'2023-02-03 08:06:13','',''),(1181,'1','310','1',1,'Retail Sale Id 1133',2160.00,0.00,0.00,3.00,207.00,'2023-02-03 08:12:07','',''),(1182,'1','310','1',1,'Retail Sale Id 1134',70000.00,0.00,0.00,100.00,4900.00,'2023-02-03 08:20:01','',''),(1183,'1','310','1',1,'Retail Sale Id 1135',70000.00,0.00,0.00,100.00,4900.00,'2023-02-03 08:21:32','',''),(1184,'1','310','1',1,'Retail Sale Id 1136',70000.00,0.00,0.00,100.00,4900.00,'2023-02-03 08:22:16','',''),(1185,'1','310','1',1,'Retail Sale Id 1137',1000.80,0.00,0.00,1.39,95.91,'2023-02-03 08:30:28','',''),(1186,'1','310','1',1,'Retail Sale Id 1138',3600.00,0.00,0.00,5.00,345.00,'2023-02-03 08:36:27','',''),(1187,'1','310','1',1,'Retail Sale Id 1139',4320.00,0.00,0.00,6.00,414.00,'2023-02-03 08:55:40','',''),(1188,'1','310','1',1,'Retail Sale Id 1140',4003.20,0.00,0.00,5.56,383.64,'2023-02-03 08:57:46','',''),(1189,'1','310','1',1,'Retail Sale Id 1141',698.40,0.00,0.00,0.97,66.93,'2023-02-03 08:59:52','',''),(1190,'1','310','1',1,'Retail Sale Id 1142',4320.00,0.00,0.00,6.00,414.00,'2023-02-03 09:03:06','',''),(1191,'1','310','1',1,'Retail Sale Id 1144',2160.00,0.00,0.00,3.00,207.00,'2023-02-03 09:21:16','',''),(1192,'1','310','1',1,'Retail Sale Id 1145',1000.80,0.00,0.00,1.39,95.91,'2023-02-03 09:23:38','',''),(1193,'1','310','1',1,'Retail Sale Id 1146',1497.60,0.00,0.00,2.08,143.52,'2023-02-03 09:26:33','',''),(1194,'1','310','1',1,'Retail Sale Id 1147',4298.40,0.00,0.00,5.97,411.93,'2023-02-03 09:32:40','',''),(1195,'1','310','1',1,'Retail Sale Id 1148',3002.40,0.00,0.00,4.17,287.73,'2023-02-03 09:38:38','',''),(1196,'1','310','1',1,'Retail Sale Id 1149',8750.00,0.00,0.00,12.50,612.50,'2023-02-03 09:43:41','',''),(1197,'1','310','1',1,'Retail Sale Id 1150',2001.60,0.00,0.00,2.78,191.82,'2023-02-03 09:47:10','',''),(1198,'1','310','1',1,'Retail Sale Id 1151',4003.20,0.00,0.00,5.56,383.64,'2023-02-03 09:56:20','',''),(1199,'1','310','1',1,'Retail Sale Id 1153',3002.40,0.00,0.00,4.17,287.73,'2023-02-03 10:02:28','',''),(1200,'1','310','1',1,'Retail Sale Id 1154',4003.20,0.00,0.00,5.56,383.64,'2023-02-03 10:17:42','',''),(1201,'1','310','1',1,'Retail Sale Id 1155',3600.00,0.00,0.00,5.00,345.00,'2023-02-03 10:19:51','',''),(1202,'1','310','1',1,'Retail Sale Id 1157',2880.00,0.00,0.00,4.00,276.00,'2023-02-03 10:24:39','',''),(1203,'1','310','1',1,'Retail Sale Id 1158',1000.80,0.00,0.00,1.39,95.91,'2023-02-03 10:28:25','',''),(1204,'1','310','1',1,'Retail Sale Id 1159',4320.00,0.00,0.00,6.00,414.00,'2023-02-03 10:39:56','',''),(1205,'1','310','1',1,'Retail Sale Id 1160',7200.00,0.00,0.00,10.00,690.00,'2023-02-03 10:51:02','',''),(1206,'1','310','1',1,'Retail Sale Id 1161',1303.20,0.00,0.00,1.81,124.89,'2023-02-03 10:55:30','',''),(1207,'1','310','1',1,'Retail Sale Id 1162',4320.00,0.00,0.00,6.00,414.00,'2023-02-03 10:57:58','',''),(1208,'1','310','1',1,'Retail Sale Id 1163',4003.20,0.00,0.00,5.56,383.64,'2023-02-03 10:59:24','',''),(1209,'1','310','1',1,'Retail Sale Id 1165',2397.60,0.00,0.00,3.33,229.77,'2023-02-03 11:06:10','',''),(1210,'1','310','1',1,'Retail Sale Id 1166',3002.40,0.00,0.00,4.17,287.73,'2023-02-03 11:07:03','',''),(1211,'1','310','1',1,'Retail Sale Id 1167',3002.40,0.00,0.00,4.17,287.73,'2023-02-03 11:09:51','',''),(1212,'1','310','1',1,'Retail Sale Id 1168',4320.00,0.00,0.00,6.00,414.00,'2023-02-03 11:15:40','',''),(1213,'1','310','1',1,'Retail Sale Id 1169',1000.80,0.00,0.00,1.39,95.91,'2023-02-03 11:34:26','',''),(1214,'1','310','1',1,'Retail Sale Id 1170',2498.40,0.00,0.00,3.47,239.43,'2023-02-03 11:36:43','',''),(1215,'1','310','1',1,'Retail Sale Id 1171',4320.00,0.00,0.00,6.00,414.00,'2023-02-03 11:39:07','',''),(1216,'1','310','1',1,'Retail Sale Id 1172',9000.00,0.00,0.00,12.50,862.50,'2023-02-03 11:42:35','',''),(1217,'1','310','1',1,'Retail Sale Id 1173',9000.00,0.00,0.00,12.50,862.50,'2023-02-03 11:44:06','',''),(1218,'1','310','1',1,'Retail Sale Id 1174',9000.00,0.00,0.00,12.50,862.50,'2023-02-03 11:45:45','',''),(1219,'1','310','1',1,'Retail Sale Id 1175',9000.00,0.00,0.00,12.50,862.50,'2023-02-03 11:48:45','',''),(1220,'1','310','1',1,'Retail Sale Id 1176',1440.00,0.00,0.00,2.00,138.00,'2023-02-03 11:55:25','',''),(1221,'1','310','1',1,'Retail Sale Id 1177',2001.60,0.00,0.00,2.78,191.82,'2023-02-03 11:57:38','',''),(1222,'1','310','1',1,'Retail Sale Id 1178',5997.60,0.00,0.00,8.33,574.77,'2023-02-03 12:02:00','',''),(1223,'1','310','1',1,'Retail Sale Id 1179',9000.00,0.00,0.00,12.50,862.50,'2023-02-03 12:07:13','',''),(1224,'1','310','1',1,'Retail Sale Id 1180',3002.40,0.00,0.00,4.17,287.73,'2023-02-03 12:20:21','',''),(1225,'1','310','1',1,'Retail Sale Id 1181',2160.00,0.00,0.00,3.00,207.00,'2023-02-03 12:39:26','',''),(1226,'1','310','1',1,'Retail Sale Id 1182',2001.60,0.00,0.00,2.78,191.82,'2023-02-03 12:42:52','',''),(1227,'1','310','1',1,'Retail Sale Id 1183',1000.80,0.00,0.00,1.39,95.91,'2023-02-03 12:43:56','',''),(1228,'1','310','1',1,'Retail Sale Id 1184',4320.00,0.00,0.00,6.00,414.00,'2023-02-03 12:46:02','',''),(1229,'1','310','1',1,'Retail Sale Id 1185',1497.60,0.00,0.00,2.08,143.52,'2023-02-03 12:48:26','',''),(1230,'1','310','1',1,'Retail Sale Id 1186',748.80,0.00,0.00,1.04,71.76,'2023-02-03 12:49:49','',''),(1231,'1','310','1',1,'Retail Sale Id 1187',720.00,0.00,0.00,1.00,69.00,'2023-02-03 12:58:22','',''),(1232,'1','310','1',1,'Retail Sale Id 1188',3600.00,0.00,0.00,5.00,345.00,'2023-02-03 13:04:33','',''),(1233,'1','310','1',1,'Retail Sale Id 1189',4320.00,0.00,0.00,6.00,414.00,'2023-02-03 13:08:43','',''),(1234,'1','310','1',1,'Retail Sale Id 1190',4320.00,0.00,0.00,6.00,414.00,'2023-02-03 13:32:31','',''),(1235,'1','310','1',1,'Retail Sale Id 1191',2498.40,0.00,0.00,3.47,239.43,'2023-02-03 13:39:18','',''),(1236,'1','310','1',1,'Retail Sale Id 1192',1497.60,0.00,0.00,2.08,143.52,'2023-02-03 13:47:15','',''),(1237,'1','310','1',1,'Retail Sale Id 1193',8750.00,0.00,0.00,12.50,612.50,'2023-02-03 13:50:03','',''),(1238,'1','310','1',1,'Retail Sale Id 1194',3600.00,0.00,0.00,5.00,345.00,'2023-02-03 13:52:54','',''),(1239,'1','310','1',1,'Retail Sale Id 1195',8750.00,0.00,0.00,12.50,612.50,'2023-02-03 13:55:45','',''),(1240,'1','310','1',1,'Retail Sale Id 1196',2498.40,0.00,0.00,3.47,239.43,'2023-02-03 14:05:47','',''),(1241,'1','310','1',1,'Retail Sale Id 1197',1497.60,0.00,0.00,2.08,143.52,'2023-02-03 14:06:46','',''),(1242,'1','310','1',1,'Retail Sale Id 1198',3499.20,0.00,0.00,4.86,335.34,'2023-02-03 14:12:37','',''),(1243,'1','310','1',1,'Retail Sale Id 1199',1303.20,0.00,0.00,1.81,124.89,'2023-02-03 14:16:41','',''),(1244,'1','310','1',1,'Retail Sale Id 1200',3600.00,0.00,0.00,5.00,345.00,'2023-02-03 14:21:23','',''),(1245,'1','310','1',1,'Retail Sale Id 1201',9000.00,0.00,0.00,12.50,862.50,'2023-02-03 14:23:47','',''),(1246,'1','310','1',1,'Retail Sale Id 1202',2800.00,0.00,0.00,4.00,196.00,'2023-02-03 14:32:57','',''),(1247,'1','310','1',1,'Retail Sale Id 1203',3002.40,0.00,0.00,4.17,287.73,'2023-02-03 14:39:15','',''),(1248,'1','310','1',1,'Retail Sale Id 1204',1497.60,0.00,0.00,2.08,143.52,'2023-02-03 14:40:51','',''),(1249,'1','310','1',1,'Retail Sale Id 1205',2001.60,0.00,0.00,2.78,191.82,'2023-02-03 15:04:00','',''),(1250,'1','310','1',1,'Retail Sale Id 1206',2001.60,0.00,0.00,2.78,191.82,'2023-02-03 15:13:18','',''),(1251,'1','310','1',1,'Retail Sale Id 1207',9000.00,0.00,0.00,12.50,862.50,'2023-02-03 15:15:57','',''),(1252,'1','310','1',1,'Retail Sale Id 1208',9000.00,0.00,0.00,12.50,862.50,'2023-02-03 15:17:51','',''),(1253,'1','310','1',1,'Retail Sale Id 1209',7200.00,0.00,0.00,10.00,690.00,'2023-02-03 15:30:37','',''),(1254,'1','310','1',1,'Retail Sale Id 1210',1000.80,0.00,0.00,1.39,95.91,'2023-02-03 15:38:01','',''),(1255,'1','310','1',1,'Retail Sale Id 1211',9000.00,0.00,0.00,12.50,862.50,'2023-02-03 15:39:06','',''),(1256,'1','310','1',1,'Retail Sale Id 1212',9000.00,0.00,0.00,12.50,862.50,'2023-02-03 15:41:49','',''),(1257,'1','310','1',1,'Retail Sale Id 1213',4320.00,0.00,0.00,6.00,414.00,'2023-02-03 15:48:29','',''),(1258,'1','310','1',1,'Retail Sale Id 1214',1497.60,0.00,0.00,2.08,143.52,'2023-02-03 15:58:14','',''),(1259,'1','310','1',1,'Retail Sale Id 1215',799.20,0.00,0.00,1.11,76.59,'2023-02-03 15:59:52','',''),(1260,'1','310','1',1,'Retail Sale Id 1216',1000.80,0.00,0.00,1.39,95.91,'2023-02-03 16:26:28','',''),(1261,'1','310','1',1,'Retail Sale Id 1217',2001.60,0.00,0.00,2.78,191.82,'2023-02-03 16:32:39','',''),(1262,'1','310','1',1,'Retail Sale Id 1218',3598.00,0.00,0.00,5.14,251.86,'2023-02-03 16:39:22','',''),(1263,'1','310','1',1,'Retail Sale Id 1219',496.80,0.00,0.00,0.69,47.61,'2023-02-03 16:47:53','',''),(1264,'1','310','1',1,'Retail Sale Id 1220',4200.00,0.00,0.00,6.00,294.00,'2023-02-03 16:57:55','',''),(1265,'1','310','1',1,'Retail Sale Id 1221',2001.60,0.00,0.00,2.78,191.82,'2023-02-03 17:00:19','',''),(1266,'1','310','1',1,'Retail Sale Id 1222',9000.00,0.00,0.00,12.50,862.50,'2023-02-03 17:10:16','',''),(1267,'1','310','1',1,'Retail Sale Id 1223',3600.00,0.00,0.00,5.00,345.00,'2023-02-03 17:11:48','',''),(1268,'1','310','1',1,'Retail Sale Id 1224',2160.00,0.00,0.00,3.00,207.00,'2023-02-03 17:15:22','',''),(1269,'1','310','1',1,'Retail Sale Id 1225',4320.00,0.00,0.00,6.00,414.00,'2023-02-03 17:17:26','',''),(1270,'1','310','1',1,'Retail Sale Id 1226',4320.00,0.00,0.00,6.00,414.00,'2023-02-03 17:19:38','',''),(1271,'1','310','1',1,'Retail Sale Id 1227',4320.00,0.00,0.00,6.00,414.00,'2023-02-03 17:21:20','',''),(1272,'1','310','1',1,'Retail Sale Id 1228',1202.40,0.00,0.00,1.67,115.23,'2023-02-03 17:30:53','',''),(1273,'1','310','1',1,'Retail Sale Id 1229',1000.80,0.00,0.00,1.39,95.91,'2023-02-03 17:31:57','',''),(1274,'1','310','1',1,'Retail Sale Id 1230',9000.00,0.00,0.00,12.50,862.50,'2023-02-03 17:46:28','',''),(1275,'1','310','1',1,'Retail Sale Id 1231',1497.60,0.00,0.00,2.08,143.52,'2023-02-03 17:50:33','',''),(1276,'1','310','1',1,'Retail Sale Id 1232',7200.00,0.00,0.00,10.00,690.00,'2023-02-03 18:02:32','',''),(1277,'1','310','1',1,'Retail Sale Id 1233',9000.00,0.00,0.00,12.50,862.50,'2023-02-03 18:17:53','',''),(1278,'1','310','1',1,'Retail Sale Id 1233',9000.00,0.00,0.00,12.50,862.50,'2023-02-03 18:17:53','',''),(1279,'1','310','1',1,'Retail Sale Id 1234',4320.00,0.00,0.00,6.00,414.00,'2023-02-03 18:20:40','',''),(1280,'1','310','1',1,'Retail Sale Id 1235',4298.40,0.00,0.00,5.97,411.93,'2023-02-03 18:21:52','',''),(1281,'1','310','1',1,'Retail Sale Id 1236',2160.00,0.00,0.00,3.00,207.00,'2023-02-03 18:27:02','',''),(1282,'1','310','1',1,'Retail Sale Id 1237',9000.00,0.00,0.00,12.50,862.50,'2023-02-03 18:29:17','',''),(1283,'1','310','1',1,'Retail Sale Id 1238',8503.20,0.00,0.00,11.81,814.89,'2023-02-03 18:32:50','',''),(1284,'1','310','1',1,'Retail Sale Id 1238',9000.00,0.00,0.00,12.50,862.50,'2023-02-03 18:32:50','',''),(1285,'1','310','1',1,'Retail Sale Id 1239',2160.00,0.00,0.00,3.00,207.00,'2023-02-03 18:35:04','',''),(1286,'1','310','1',1,'Retail Sale Id 1240',2001.60,0.00,0.00,2.78,191.82,'2023-02-03 18:37:04','',''),(1287,'1','310','1',1,'Return of Retail Sale Id 1238',0.00,8503.20,11.81,0.00,-814.89,'2023-02-03 19:00:51','',''),(1288,'1','310','1',1,'Return of Retail Sale Id 1238',0.00,9000.00,12.50,0.00,-862.50,'2023-02-03 19:00:51','',''),(1289,'1','310','1',1,'Retail Sale Id 1241',741.60,0.00,0.00,1.03,71.07,'2023-02-03 19:03:01','',''),(1290,'1','310','1',1,'Return of Retail Sale Id 1220',0.00,4200.00,6.00,0.00,-294.00,'2023-02-03 19:05:37','',''),(1291,'1','310','1',1,'Retail Sale Id 1242',4627.00,0.00,0.00,6.61,323.89,'2023-02-03 19:06:38','',''),(1292,'1','310','1',1,'Retail Sale Id 1243',4003.20,0.00,0.00,5.56,383.64,'2023-02-04 08:03:34','',''),(1293,'1','310','1',1,'Retail Sale Id 1244',42000.00,0.00,0.00,60.00,2940.00,'2023-02-04 08:16:30','',''),(1294,'1','310','1',1,'Retail Sale Id 1245',2001.60,0.00,0.00,2.78,191.82,'2023-02-04 08:18:20','',''),(1295,'1','310','1',1,'Retail Sale Id 1246',1000.80,0.00,0.00,1.39,95.91,'2023-02-04 08:20:55','',''),(1296,'1','310','1',1,'Retail Sale Id 1247',2001.60,0.00,0.00,2.78,191.82,'2023-02-04 08:29:33','',''),(1297,'1','310','1',1,'Retail Sale Id 1248',4320.00,0.00,0.00,6.00,414.00,'2023-02-04 08:31:54','',''),(1298,'1','310','1',1,'Retail Sale Id 1249',1497.60,0.00,0.00,2.08,143.52,'2023-02-04 08:37:48','',''),(1299,'1','310','1',1,'Retail Sale Id 1250',2160.00,0.00,0.00,3.00,207.00,'2023-02-04 08:59:32','',''),(1300,'1','310','1',1,'Retail Sale Id 1251',4320.00,0.00,0.00,6.00,414.00,'2023-02-04 09:05:59','',''),(1301,'1','310','1',1,'Retail Sale Id 1251',4320.00,0.00,0.00,6.00,414.00,'2023-02-04 09:05:59','',''),(1302,'1','310','1',1,'Retail Sale Id 1252',9000.00,0.00,0.00,12.50,862.50,'2023-02-04 09:24:41','',''),(1303,'1','310','1',1,'Retail Sale Id 1253',2001.60,0.00,0.00,2.78,191.82,'2023-02-04 09:35:45','',''),(1304,'1','310','1',1,'Retail Sale Id 1254',4996.80,0.00,0.00,6.94,478.86,'2023-02-04 09:36:56','',''),(1305,'1','310','1',1,'Retail Sale Id 1255',4298.40,0.00,0.00,5.97,411.93,'2023-02-04 09:43:47','',''),(1306,'1','310','1',1,'Retail Sale Id 1256',1497.60,0.00,0.00,2.08,143.52,'2023-02-04 09:47:45','',''),(1307,'1','310','1',1,'Retail Sale Id 1257',2160.00,0.00,0.00,3.00,207.00,'2023-02-04 10:03:53','',''),(1308,'1','310','1',1,'Retail Sale Id 1258',7999.20,0.00,0.00,11.11,766.59,'2023-02-04 10:05:09','',''),(1309,'1','310','1',1,'Retail Sale Id 1259',42000.00,0.00,0.00,60.00,2940.00,'2023-02-04 10:13:43','',''),(1310,'1','310','1',1,'Retail Sale Id 1260',4320.00,0.00,0.00,6.00,414.00,'2023-02-04 10:19:41','',''),(1311,'1','310','1',1,'Retail Sale Id 1262',9000.00,0.00,0.00,12.50,862.50,'2023-02-04 10:28:27','',''),(1312,'1','310','1',1,'Retail Sale Id 1263',4320.00,0.00,0.00,6.00,414.00,'2023-02-04 10:29:42','',''),(1313,'1','310','1',1,'Retail Sale Id 1264',4320.00,0.00,0.00,6.00,414.00,'2023-02-04 10:32:26','',''),(1314,'1','310','1',1,'Retail Sale Id 1265',9000.00,0.00,0.00,12.50,862.50,'2023-02-04 10:35:10','',''),(1315,'1','310','1',1,'Retail Sale Id 1266',2880.00,0.00,0.00,4.00,276.00,'2023-02-04 10:42:26','',''),(1316,'1','310','1',1,'Retail Sale Id 1267',5760.00,0.00,0.00,8.00,552.00,'2023-02-04 10:51:49','',''),(1317,'1','310','1',1,'Retail Sale Id 1269',1000.80,0.00,0.00,1.39,95.91,'2023-02-04 10:59:52','',''),(1318,'1','310','1',1,'Retail Sale Id 1270',35000.00,0.00,0.00,50.00,2450.00,'2023-02-04 11:04:00','',''),(1319,'1','310','1',1,'Retail Sale Id 1271',2160.00,0.00,0.00,3.00,207.00,'2023-02-04 11:04:58','',''),(1320,'1','310','1',1,'Retail Sale Id 1272',9000.00,0.00,0.00,12.50,862.50,'2023-02-04 11:10:59','',''),(1321,'1','310','1',1,'Retail Sale Id 1273',9000.00,0.00,0.00,12.50,862.50,'2023-02-04 11:12:35','',''),(1322,'1','310','1',1,'Retail Sale Id 1274',3002.40,0.00,0.00,4.17,287.73,'2023-02-04 11:13:52','',''),(1323,'1','310','1',1,'Retail Sale Id 1275',3002.40,0.00,0.00,4.17,287.73,'2023-02-04 11:14:44','',''),(1324,'1','310','1',1,'Retail Sale Id 1276',8143.20,0.00,0.00,11.31,780.39,'2023-02-04 11:17:30','',''),(1325,'1','310','1',1,'Retail Sale Id 1277',2100.00,0.00,0.00,3.00,147.00,'2023-02-04 11:24:37','',''),(1326,'1','310','1',1,'Retail Sale Id 1278',9000.00,0.00,0.00,12.50,862.50,'2023-02-04 11:28:26','',''),(1327,'1','310','1',1,'Retail Sale Id 1279',2160.00,0.00,0.00,3.00,207.00,'2023-02-04 11:30:00','',''),(1328,'1','310','1',1,'Retail Sale Id 1280',9000.00,0.00,0.00,12.50,862.50,'2023-02-04 11:35:38','',''),(1329,'1','310','1',1,'Retail Sale Id 1281',4320.00,0.00,0.00,6.00,414.00,'2023-02-04 11:57:15','',''),(1330,'1','310','1',1,'Retail Sale Id 1282',2001.60,0.00,0.00,2.78,191.82,'2023-02-04 12:02:54','',''),(1331,'1','310','1',1,'Retail Sale Id 1283',1497.60,0.00,0.00,2.08,143.52,'2023-02-04 12:08:02','',''),(1332,'1','310','1',1,'Retail Sale Id 1284',3600.00,0.00,0.00,5.00,345.00,'2023-02-04 12:10:38','',''),(1333,'1','310','1',1,'Retail Sale Id 1285',9000.00,0.00,0.00,12.50,862.50,'2023-02-04 12:12:28','',''),(1334,'1','310','1',1,'Retail Sale Id 1286',9000.00,0.00,0.00,12.50,862.50,'2023-02-04 12:13:39','',''),(1335,'1','310','1',1,'Retail Sale Id 1287',4320.00,0.00,0.00,6.00,414.00,'2023-02-04 12:16:24','',''),(1336,'1','310','1',1,'Retail Sale Id 1289',2880.00,0.00,0.00,4.00,276.00,'2023-02-04 12:17:28','',''),(1337,'1','310','1',1,'Retail Sale Id 1290',1000.80,0.00,0.00,1.39,95.91,'2023-02-04 12:18:15','',''),(1338,'1','310','1',1,'Retail Sale Id 1291',2001.60,0.00,0.00,2.78,191.82,'2023-02-04 12:30:42','',''),(1339,'1','310','1',1,'Retail Sale Id 1292',4320.00,0.00,0.00,6.00,414.00,'2023-02-04 12:36:30','',''),(1340,'1','310','1',1,'Retail Sale Id 1293',1598.40,0.00,0.00,2.22,153.18,'2023-02-04 12:41:56','',''),(1341,'1','310','1',1,'Retail Sale Id 1294',1440.00,0.00,0.00,2.00,138.00,'2023-02-04 12:51:52','',''),(1342,'1','310','1',1,'Retail Sale Id 1295',35000.00,0.00,0.00,50.00,2450.00,'2023-02-04 13:02:05','',''),(1343,'1','310','1',1,'Retail Sale Id 1296',34300.00,0.00,0.00,49.00,2401.00,'2023-02-04 13:02:53','',''),(1344,'1','310','1',1,'Retail Sale Id 1297',4320.00,0.00,0.00,6.00,414.00,'2023-02-04 13:04:46','',''),(1345,'1','310','1',1,'Retail Sale Id 1298',4996.80,0.00,0.00,6.94,478.86,'2023-02-04 13:14:29','',''),(1346,'1','310','1',1,'Retail Sale Id 1299',35000.00,0.00,0.00,50.00,2450.00,'2023-02-04 13:21:37','',''),(1347,'1','310','1',1,'Retail Sale Id 1300',35000.00,0.00,0.00,50.00,2450.00,'2023-02-04 13:22:13','',''),(1348,'1','310','1',1,'Retail Sale Id 1301',9000.00,0.00,0.00,12.50,862.50,'2023-02-04 13:26:41','',''),(1349,'1','310','1',1,'Retail Sale Id 1302',4320.00,0.00,0.00,6.00,414.00,'2023-02-04 14:04:41','',''),(1350,'1','310','1',1,'Retail Sale Id 1303',2498.40,0.00,0.00,3.47,239.43,'2023-02-04 14:30:23','',''),(1351,'1','310','1',1,'Retail Sale Id 1304',2001.60,0.00,0.00,2.78,191.82,'2023-02-04 14:31:01','',''),(1352,'1','310','1',1,'Retail Sale Id 1305',6300.00,0.00,0.00,9.00,441.00,'2023-02-04 14:35:24','',''),(1353,'1','310','1',1,'Retail Sale Id 1306',5040.00,0.00,0.00,7.00,483.00,'2023-02-04 14:42:17','',''),(1354,'1','310','1',1,'Retail Sale Id 1307',140000.00,0.00,0.00,200.00,9800.00,'2023-02-04 14:43:11','',''),(1355,'1','310','1',1,'Retail Sale Id 1308',2160.00,0.00,0.00,3.00,207.00,'2023-02-04 14:44:04','',''),(1356,'1','310','1',1,'Retail Sale Id 1309',9000.00,0.00,0.00,12.50,862.50,'2023-02-04 14:47:36','',''),(1357,'1','310','1',1,'Retail Sale Id 1310',1497.60,0.00,0.00,2.08,143.52,'2023-02-04 14:57:53','',''),(1358,'1','310','1',1,'Retail Sale Id 1311',2160.00,0.00,0.00,3.00,207.00,'2023-02-04 15:30:02','',''),(1359,'1','310','1',1,'Retail Sale Id 1311',9000.00,0.00,0.00,12.50,862.50,'2023-02-04 15:30:02','',''),(1360,'1','310','1',1,'Retail Sale Id 1312',4320.00,0.00,0.00,6.00,414.00,'2023-02-04 15:55:16','',''),(1361,'1','310','1',1,'Retail Sale Id 1313',2160.00,0.00,0.00,3.00,207.00,'2023-02-04 16:02:23','',''),(1362,'1','310','1',1,'Retail Sale Id 1314',2001.60,0.00,0.00,2.78,191.82,'2023-02-04 16:05:21','',''),(1363,'1','310','1',1,'Retail Sale Id 1314',3499.20,0.00,0.00,4.86,335.34,'2023-02-04 16:05:21','',''),(1364,'1','310','1',1,'Retail Sale Id 1315',1000.80,0.00,0.00,1.39,95.91,'2023-02-04 16:13:28','',''),(1365,'1','310','1',1,'Retail Sale Id 1316',2001.60,0.00,0.00,2.78,191.82,'2023-02-04 16:14:15','',''),(1366,'1','310','1',1,'Retail Sale Id 1316',3499.20,0.00,0.00,4.86,335.34,'2023-02-04 16:14:15','',''),(1367,'1','310','1',1,'Retail Sale Id 1317',1440.00,0.00,0.00,2.00,138.00,'2023-02-04 16:15:26','',''),(1368,'1','310','1',1,'Retail Sale Id 1318',3600.00,0.00,0.00,5.00,345.00,'2023-02-04 16:16:18','',''),(1369,'1','310','1',1,'Retail Sale Id 1319',698.40,0.00,0.00,0.97,66.93,'2023-02-04 16:17:31','',''),(1370,'1','310','1',1,'Retail Sale Id 1319',698.40,0.00,0.00,0.97,66.93,'2023-02-04 16:17:31','',''),(1371,'1','310','1',1,'Retail Sale Id 1320',799.20,0.00,0.00,1.11,76.59,'2023-02-04 16:18:45','',''),(1372,'1','310','1',1,'Retail Sale Id 1321',3499.20,0.00,0.00,4.86,335.34,'2023-02-04 16:19:27','',''),(1373,'1','310','1',1,'Return of Retail Sale Id 1316',0.00,2001.60,2.78,0.00,-191.82,'2023-02-04 16:20:36','',''),(1374,'1','310','1',1,'Return of Retail Sale Id 1316',0.00,3499.20,4.86,0.00,-335.34,'2023-02-04 16:20:37','',''),(1375,'1','310','1',1,'Retail Sale Id 1322',4320.00,0.00,0.00,6.00,414.00,'2023-02-04 16:25:28','',''),(1376,'1','310','1',1,'Retail Sale Id 1323',2498.40,0.00,0.00,3.47,239.43,'2023-02-04 16:26:46','',''),(1377,'1','310','1',1,'Retail Sale Id 1324',597.60,0.00,0.00,0.83,57.27,'2023-02-04 16:27:38','',''),(1378,'1','310','1',1,'Retail Sale Id 1325',2498.40,0.00,0.00,3.47,239.43,'2023-02-04 16:37:25','',''),(1379,'1','310','1',1,'Retail Sale Id 1326',7200.00,0.00,0.00,10.00,690.00,'2023-02-04 16:40:41','',''),(1380,'1','310','1',1,'Retail Sale Id 1327',3002.40,0.00,0.00,4.17,287.73,'2023-02-04 16:41:55','',''),(1381,'1','310','1',1,'Retail Sale Id 1328',9000.00,0.00,0.00,12.50,862.50,'2023-02-04 16:57:58','',''),(1382,'1','310','1',1,'Retail Sale Id 1329',2001.60,0.00,0.00,2.78,191.82,'2023-02-04 17:04:34','',''),(1383,'1','310','1',1,'Retail Sale Id 1330',496.80,0.00,0.00,0.69,47.61,'2023-02-04 17:09:30','',''),(1384,'1','310','1',1,'Retail Sale Id 1332',1000.80,0.00,0.00,1.39,95.91,'2023-02-04 17:12:24','',''),(1385,'1','310','1',1,'Retail Sale Id 1333',4320.00,0.00,0.00,6.00,414.00,'2023-02-04 17:13:00','',''),(1386,'1','310','1',1,'Retail Sale Id 1334',2160.00,0.00,0.00,3.00,207.00,'2023-02-04 17:15:29','',''),(1387,'1','310','1',1,'Retail Sale Id 1335',2001.60,0.00,0.00,2.78,191.82,'2023-02-04 17:21:25','',''),(1388,'1','310','1',1,'Return of Retail Sale Id 1314',0.00,2001.60,2.78,0.00,-191.82,'2023-02-04 17:27:14','',''),(1389,'1','310','1',1,'Return of Retail Sale Id 1314',0.00,3499.20,4.86,0.00,-335.34,'2023-02-04 17:27:14','',''),(1390,'1','310','1',1,'Retail Sale Id 1336',6480.00,0.00,0.00,9.00,621.00,'2023-02-04 17:31:03','',''),(1391,'1','310','1',1,'Retail Sale Id 1337',35000.00,0.00,0.00,50.00,2450.00,'2023-02-04 17:35:17','',''),(1392,'1','310','1',1,'Retail Sale Id 1338',2160.00,0.00,0.00,3.00,207.00,'2023-02-04 17:35:59','',''),(1393,'1','310','1',1,'Retail Sale Id 1339',1000.80,0.00,0.00,1.39,95.91,'2023-02-04 17:43:31','',''),(1394,'1','310','1',1,'Retail Sale Id 1340',4320.00,0.00,0.00,6.00,414.00,'2023-02-04 17:54:47','',''),(1395,'1','310','1',1,'Retail Sale Id 1341',1497.60,0.00,0.00,2.08,143.52,'2023-02-04 17:55:48','',''),(1396,'1','310','1',1,'Retail Sale Id 1342',1000.80,0.00,0.00,1.39,95.91,'2023-02-04 17:56:34','',''),(1397,'1','310','1',1,'Retail Sale Id 1343',4320.00,0.00,0.00,6.00,414.00,'2023-02-04 18:00:13','',''),(1398,'1','310','1',1,'Retail Sale Id 1344',9000.00,0.00,0.00,12.50,862.50,'2023-02-04 18:03:38','',''),(1399,'1','310','1',1,'Retail Sale Id 1346',1000.80,0.00,0.00,1.39,95.91,'2023-02-04 18:15:02','',''),(1400,'1','310','1',1,'Retail Sale Id 1347',8750.00,0.00,0.00,12.50,612.50,'2023-02-04 18:19:17','',''),(1401,'1','310','1',1,'Retail Sale Id 1349',2160.00,0.00,0.00,3.00,207.00,'2023-02-04 18:23:57','',''),(1402,'1','310','1',1,'Retail Sale Id 1349',4996.80,0.00,0.00,6.94,478.86,'2023-02-04 18:23:57','',''),(1403,'1','310','1',1,'Retail Sale Id 1350',1000.80,0.00,0.00,1.39,95.91,'2023-02-04 18:26:23','',''),(1404,'1','310','1',1,'Retail Sale Id 1351',1497.60,0.00,0.00,2.08,143.52,'2023-02-04 18:35:01','',''),(1405,'1','310','1',1,'Retail Sale Id 1352',9000.00,0.00,0.00,12.50,862.50,'2023-02-04 18:47:34','',''),(1406,'1','310','1',1,'Retail Sale Id 1353',9000.00,0.00,0.00,12.50,862.50,'2023-02-04 18:51:53','',''),(1407,'1','310','1',1,'Retail Sale Id 1354',7.20,0.00,0.00,0.01,0.69,'2023-02-04 18:58:26','',''),(1408,'1','310','1',1,'Return of Retail Sale Id 1277',0.00,2100.00,3.00,0.00,-147.00,'2023-02-04 18:59:47','',''),(1409,'1','310','1',1,'Retail Sale Id 1355',1904.00,0.00,0.00,2.72,133.28,'2023-02-04 19:01:12','',''),(1410,'1','310','1',1,'Return of Retail Sale Id 1353',0.00,9000.00,12.50,0.00,-862.50,'2023-02-04 19:08:32','',''),(1411,'1','310','1',1,'Retail Sale Id 1356',2296.80,0.00,0.00,3.19,220.11,'2023-02-05 07:19:00','',''),(1412,'1','310','1',1,'Retail Sale Id 1357',496.80,0.00,0.00,0.69,47.61,'2023-02-05 07:28:06','',''),(1413,'1','310','1',1,'Retail Sale Id 1358',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 07:31:55','',''),(1414,'1','310','1',1,'Retail Sale Id 1358',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 07:31:55','',''),(1415,'1','310','1',1,'Retail Sale Id 1358',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 07:31:55','',''),(1416,'1','310','1',1,'Retail Sale Id 1359',2160.00,0.00,0.00,3.00,207.00,'2023-02-05 07:36:40','',''),(1417,'1','310','1',1,'Retail Sale Id 1360',2880.00,0.00,0.00,4.00,276.00,'2023-02-05 07:54:12','',''),(1418,'1','310','1',1,'Retail Sale Id 1361',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 08:04:59','',''),(1419,'1','310','1',1,'Retail Sale Id 1362',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 08:10:10','',''),(1420,'1','310','1',1,'Retail Sale Id 1363',18998.00,0.00,0.00,27.14,1329.86,'2023-02-05 08:17:02','',''),(1421,'1','310','1',1,'Retail Sale Id 1364',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 08:21:49','',''),(1422,'1','310','1',1,'Retail Sale Id 1365',2498.40,0.00,0.00,3.47,239.43,'2023-02-05 08:34:32','',''),(1423,'1','310','1',1,'Retail Sale Id 1366',42000.00,0.00,0.00,60.00,2940.00,'2023-02-05 08:35:44','',''),(1424,'1','310','1',1,'Retail Sale Id 1367',2001.60,0.00,0.00,2.78,191.82,'2023-02-05 08:36:29','',''),(1425,'1','310','1',1,'Retail Sale Id 1368',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 08:39:29','',''),(1426,'1','310','1',1,'Retail Sale Id 1368',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 08:39:29','',''),(1427,'1','310','1',1,'Retail Sale Id 1369',2160.00,0.00,0.00,3.00,207.00,'2023-02-05 08:41:29','',''),(1428,'1','310','1',1,'Retail Sale Id 1370',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 08:46:44','',''),(1429,'1','310','1',1,'Retail Sale Id 1371',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 08:47:44','',''),(1430,'1','310','1',1,'Retail Sale Id 1372',7999.20,0.00,0.00,11.11,766.59,'2023-02-05 08:53:22','',''),(1431,'1','310','1',1,'Retail Sale Id 1373',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 08:54:59','',''),(1432,'1','310','1',1,'Retail Sale Id 1374',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 09:03:31','',''),(1433,'1','310','1',1,'Retail Sale Id 1375',1497.60,0.00,0.00,2.08,143.52,'2023-02-05 09:08:13','',''),(1434,'1','310','1',1,'Retail Sale Id 1376',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 09:13:02','',''),(1435,'1','310','1',1,'Retail Sale Id 1377',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 09:23:36','',''),(1436,'1','310','1',1,'Retail Sale Id 1377',7200.00,0.00,0.00,10.00,690.00,'2023-02-05 09:23:36','',''),(1437,'1','310','1',1,'Retail Sale Id 1378',1000.80,0.00,0.00,1.39,95.91,'2023-02-05 09:24:39','',''),(1438,'1','310','1',1,'Retail Sale Id 1379',8001.00,0.00,0.00,11.43,560.07,'2023-02-05 09:32:52','',''),(1439,'1','310','1',1,'Retail Sale Id 1380',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 09:35:23','',''),(1440,'1','310','1',1,'Retail Sale Id 1381',2160.00,0.00,0.00,3.00,207.00,'2023-02-05 09:41:51','',''),(1441,'1','310','1',1,'Retail Sale Id 1382',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 09:43:33','',''),(1442,'1','310','1',1,'Retail Sale Id 1383',3600.00,0.00,0.00,5.00,345.00,'2023-02-05 09:45:04','',''),(1443,'1','310','1',1,'Retail Sale Id 1384',2001.60,0.00,0.00,2.78,191.82,'2023-02-05 09:48:47','',''),(1444,'1','310','1',1,'Retail Sale Id 1385',1000.80,0.00,0.00,1.39,95.91,'2023-02-05 09:49:59','',''),(1445,'1','310','1',1,'Retail Sale Id 1387',2880.00,0.00,0.00,4.00,276.00,'2023-02-05 09:53:46','',''),(1446,'1','310','1',1,'Retail Sale Id 1388',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 09:56:34','',''),(1447,'1','310','1',1,'Retail Sale Id 1389',3600.00,0.00,0.00,5.00,345.00,'2023-02-05 10:04:08','',''),(1448,'1','310','1',1,'Retail Sale Id 1391',2160.00,0.00,0.00,3.00,207.00,'2023-02-05 10:05:06','',''),(1449,'1','310','1',1,'Retail Sale Id 1392',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 10:05:56','',''),(1450,'1','310','1',1,'Retail Sale Id 1393',5760.00,0.00,0.00,8.00,552.00,'2023-02-05 10:07:54','',''),(1451,'1','310','1',1,'Retail Sale Id 1394',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 10:09:49','',''),(1452,'1','310','1',1,'Retail Sale Id 1395',2203.20,0.00,0.00,3.06,211.14,'2023-02-05 10:14:48','',''),(1453,'1','310','1',1,'Retail Sale Id 1396',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 10:16:07','',''),(1454,'1','310','1',1,'Retail Sale Id 1397',2160.00,0.00,0.00,3.00,207.00,'2023-02-05 10:17:29','',''),(1455,'1','310','1',1,'Retail Sale Id 1398',2203.20,0.00,0.00,3.06,211.14,'2023-02-05 10:18:36','',''),(1456,'1','310','1',1,'Retail Sale Id 1399',2160.00,0.00,0.00,3.00,207.00,'2023-02-05 10:19:18','',''),(1457,'1','310','1',1,'Retail Sale Id 1400',1497.60,0.00,0.00,2.08,143.52,'2023-02-05 10:27:27','',''),(1458,'1','310','1',1,'Retail Sale Id 1401',7920.00,0.00,0.00,11.00,759.00,'2023-02-05 10:38:50','',''),(1459,'1','310','1',1,'Retail Sale Id 1402',2001.60,0.00,0.00,2.78,191.82,'2023-02-05 10:40:41','',''),(1460,'1','310','1',1,'Retail Sale Id 1403',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 10:49:42','',''),(1461,'1','310','1',1,'Retail Sale Id 1403',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 10:49:42','',''),(1462,'1','310','1',1,'Retail Sale Id 1404',748.80,0.00,0.00,1.04,71.76,'2023-02-05 10:52:36','',''),(1463,'1','310','1',1,'Retail Sale Id 1405',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 11:00:00','',''),(1464,'1','310','1',1,'Retail Sale Id 1406',2160.00,0.00,0.00,3.00,207.00,'2023-02-05 11:04:18','',''),(1465,'1','310','1',1,'Retail Sale Id 1407',2296.80,0.00,0.00,3.19,220.11,'2023-02-05 11:05:39','',''),(1466,'1','310','1',1,'Retail Sale Id 1408',2880.00,0.00,0.00,4.00,276.00,'2023-02-05 11:11:10','',''),(1467,'1','310','1',1,'Retail Sale Id 1409',720.00,0.00,0.00,1.00,69.00,'2023-02-05 11:18:59','',''),(1468,'1','310','1',1,'Retail Sale Id 1410',74200.00,0.00,0.00,106.00,5194.00,'2023-02-05 11:24:38','',''),(1469,'1','310','1',1,'Retail Sale Id 1411',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 11:26:32','',''),(1470,'1','310','1',1,'Retail Sale Id 1411',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 11:26:32','',''),(1471,'1','310','1',1,'Retail Sale Id 1412',1000.80,0.00,0.00,1.39,95.91,'2023-02-05 11:27:58','',''),(1472,'1','310','1',1,'Retail Sale Id 1413',1800.00,0.00,0.00,2.50,172.50,'2023-02-05 11:29:32','',''),(1473,'1','310','1',1,'Retail Sale Id 1414',2880.00,0.00,0.00,4.00,276.00,'2023-02-05 11:35:33','',''),(1474,'1','310','1',1,'Retail Sale Id 1415',38500.00,0.00,0.00,55.00,2695.00,'2023-02-05 11:39:22','',''),(1475,'1','310','1',1,'Retail Sale Id 1416',3600.00,0.00,0.00,5.00,345.00,'2023-02-05 11:40:15','',''),(1476,'1','310','1',1,'Retail Sale Id 1416',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 11:40:15','',''),(1477,'1','310','1',1,'Retail Sale Id 1417',192500.00,0.00,0.00,275.00,13475.00,'2023-02-05 11:41:21','',''),(1478,'1','310','1',1,'Retail Sale Id 1418',3600.00,0.00,0.00,5.00,345.00,'2023-02-05 11:45:40','',''),(1479,'1','310','1',1,'Retail Sale Id 1419',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 12:02:20','',''),(1480,'1','310','1',1,'Retail Sale Id 1420',1497.60,0.00,0.00,2.08,143.52,'2023-02-05 12:03:47','',''),(1481,'1','310','1',1,'Retail Sale Id 1421',48300.00,0.00,0.00,69.00,3381.00,'2023-02-05 12:06:45','',''),(1482,'1','310','1',1,'Retail Sale Id 1422',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 12:08:16','',''),(1483,'1','310','1',1,'Retail Sale Id 1423',1800.00,0.00,0.00,2.50,172.50,'2023-02-05 12:09:21','',''),(1484,'1','310','1',1,'Retail Sale Id 1424',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 12:14:36','',''),(1485,'1','310','1',1,'Retail Sale Id 1425',3600.00,0.00,0.00,5.00,345.00,'2023-02-05 12:16:30','',''),(1486,'1','310','1',1,'Retail Sale Id 1426',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 12:19:48','',''),(1487,'1','310','1',1,'Retail Sale Id 1427',1677.60,0.00,0.00,2.33,160.77,'2023-02-05 12:23:45','',''),(1488,'1','310','1',1,'Retail Sale Id 1428',2160.00,0.00,0.00,3.00,207.00,'2023-02-05 12:24:35','',''),(1489,'1','310','1',1,'Retail Sale Id 1429',5040.00,0.00,0.00,7.00,483.00,'2023-02-05 12:26:19','',''),(1490,'1','310','1',1,'Retail Sale Id 1430',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 12:27:02','',''),(1491,'1','310','1',1,'Retail Sale Id 1431',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 12:28:31','',''),(1492,'1','310','1',1,'Retail Sale Id 1432',1000.80,0.00,0.00,1.39,95.91,'2023-02-05 12:29:39','',''),(1493,'1','310','1',1,'Retail Sale Id 1432',1000.80,0.00,0.00,1.39,95.91,'2023-02-05 12:29:39','',''),(1494,'1','310','1',1,'Retail Sale Id 1433',3002.40,0.00,0.00,4.17,287.73,'2023-02-05 12:33:54','',''),(1495,'1','310','1',1,'Retail Sale Id 1434',3002.40,0.00,0.00,4.17,287.73,'2023-02-05 12:43:26','',''),(1496,'1','310','1',1,'Retail Sale Id 1435',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 12:44:37','',''),(1497,'1','310','1',1,'Retail Sale Id 1436',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 12:45:27','',''),(1498,'1','310','1',1,'Retail Sale Id 1437',4996.80,0.00,0.00,6.94,478.86,'2023-02-05 13:03:48','',''),(1499,'1','310','1',1,'Retail Sale Id 1438',2001.60,0.00,0.00,2.78,191.82,'2023-02-05 13:11:16','',''),(1500,'1','310','1',1,'Retail Sale Id 1439',3002.40,0.00,0.00,4.17,287.73,'2023-02-05 13:14:07','',''),(1501,'1','310','1',1,'Retail Sale Id 1440',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 13:17:38','',''),(1502,'1','310','1',1,'Retail Sale Id 1441',496.80,0.00,0.00,0.69,47.61,'2023-02-05 13:20:48','',''),(1503,'1','310','1',1,'Retail Sale Id 1442',1000.80,0.00,0.00,1.39,95.91,'2023-02-05 13:21:45','',''),(1504,'1','310','1',1,'Retail Sale Id 1443',5997.60,0.00,0.00,8.33,574.77,'2023-02-05 13:26:25','',''),(1505,'1','310','1',1,'Retail Sale Id 1444',4996.80,0.00,0.00,6.94,478.86,'2023-02-05 13:32:12','',''),(1506,'1','310','1',1,'Retail Sale Id 1445',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 13:37:02','',''),(1507,'1','310','1',1,'Retail Sale Id 1446',496.80,0.00,0.00,0.69,47.61,'2023-02-05 13:38:11','',''),(1508,'1','310','1',1,'Retail Sale Id 1447',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 13:39:37','',''),(1509,'1','310','1',1,'Retail Sale Id 1448',10003.00,0.00,0.00,14.29,700.21,'2023-02-05 13:41:34','',''),(1510,'1','310','1',1,'Retail Sale Id 1450',3600.00,0.00,0.00,5.00,345.00,'2023-02-05 13:49:56','',''),(1511,'1','310','1',1,'Retail Sale Id 1451',16800.00,0.00,0.00,24.00,1176.00,'2023-02-05 13:55:53','',''),(1512,'1','310','1',1,'Retail Sale Id 1452',3499.20,0.00,0.00,4.86,335.34,'2023-02-05 13:58:20','',''),(1513,'1','310','1',1,'Retail Sale Id 1453',1497.60,0.00,0.00,2.08,143.52,'2023-02-05 13:59:08','',''),(1514,'1','310','1',1,'Retail Sale Id 1454',3002.40,0.00,0.00,4.17,287.73,'2023-02-05 14:01:23','',''),(1515,'1','310','1',1,'Retail Sale Id 1455',2160.00,0.00,0.00,3.00,207.00,'2023-02-05 14:02:57','',''),(1516,'1','310','1',1,'Retail Sale Id 1456',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 14:05:34','',''),(1517,'1','310','1',1,'Retail Sale Id 1457',2001.60,0.00,0.00,2.78,191.82,'2023-02-05 14:06:54','',''),(1518,'1','310','1',1,'Retail Sale Id 1458',3600.00,0.00,0.00,5.00,345.00,'2023-02-05 14:17:27','',''),(1519,'1','310','1',1,'Retail Sale Id 1459',1497.60,0.00,0.00,2.08,143.52,'2023-02-05 14:22:53','',''),(1520,'1','310','1',1,'Retail Sale Id 1460',5600.00,0.00,0.00,8.00,392.00,'2023-02-05 14:26:26','',''),(1521,'1','310','1',1,'Retail Sale Id 1461',2160.00,0.00,0.00,3.00,207.00,'2023-02-05 14:27:37','',''),(1522,'1','310','1',1,'Retail Sale Id 1462',2160.00,0.00,0.00,3.00,207.00,'2023-02-05 14:33:56','',''),(1523,'1','310','1',1,'Retail Sale Id 1462',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 14:33:56','',''),(1524,'1','310','1',1,'Retail Sale Id 1463',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 14:35:37','',''),(1525,'1','310','1',1,'Retail Sale Id 1464',4500.00,0.00,0.00,6.25,431.25,'2023-02-05 14:40:42','',''),(1526,'1','310','1',1,'Retail Sale Id 1465',2160.00,0.00,0.00,3.00,207.00,'2023-02-05 14:45:48','',''),(1527,'1','310','1',1,'Retail Sale Id 1465',3002.40,0.00,0.00,4.17,287.73,'2023-02-05 14:45:48','',''),(1528,'1','310','1',1,'Retail Sale Id 1465',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 14:45:48','',''),(1529,'1','310','1',1,'Retail Sale Id 1465',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 14:45:48','',''),(1530,'1','310','1',1,'Retail Sale Id 1465',4996.80,0.00,0.00,6.94,478.86,'2023-02-05 14:45:48','',''),(1531,'1','310','1',1,'Retail Sale Id 1466',2160.00,0.00,0.00,3.00,207.00,'2023-02-05 14:48:29','',''),(1532,'1','310','1',1,'Retail Sale Id 1467',70000.00,0.00,0.00,100.00,4900.00,'2023-02-05 15:00:07','',''),(1533,'1','310','1',1,'Retail Sale Id 1468',70000.00,0.00,0.00,100.00,4900.00,'2023-02-05 15:00:57','',''),(1534,'1','310','1',1,'Retail Sale Id 1469',3997.00,0.00,0.00,5.71,279.79,'2023-02-05 15:03:25','',''),(1535,'1','310','1',1,'Retail Sale Id 1470',70000.00,0.00,0.00,100.00,4900.00,'2023-02-05 15:04:55','',''),(1536,'1','310','1',1,'Retail Sale Id 1471',1440.00,0.00,0.00,2.00,138.00,'2023-02-05 15:06:48','',''),(1537,'1','310','1',1,'Retail Sale Id 1473',3002.40,0.00,0.00,4.17,287.73,'2023-02-05 15:08:27','',''),(1538,'1','310','1',1,'Retail Sale Id 1474',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 15:09:21','',''),(1539,'1','310','1',1,'Retail Sale Id 1475',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 15:10:12','',''),(1540,'1','310','1',1,'Retail Sale Id 1476',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 15:27:23','',''),(1541,'1','310','1',1,'Retail Sale Id 1477',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 15:29:22','',''),(1542,'1','310','1',1,'Retail Sale Id 1478',4500.00,0.00,0.00,6.25,431.25,'2023-02-05 15:31:34','',''),(1543,'1','310','1',1,'Retail Sale Id 1479',1497.60,0.00,0.00,2.08,143.52,'2023-02-05 15:32:01','',''),(1544,'1','310','1',1,'Return of Retail Sale Id 1403',0.00,4320.00,6.00,0.00,-414.00,'2023-02-05 15:33:56','',''),(1545,'1','310','1',1,'Return of Retail Sale Id 1403',0.00,9000.00,12.50,0.00,-862.50,'2023-02-05 15:33:56','',''),(1546,'1','310','1',1,'Return of Retail Sale Id 1471',0.00,1440.00,2.00,0.00,-138.00,'2023-02-05 15:34:50','',''),(1547,'1','310','1',1,'Retail Sale Id 1480',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 15:37:08','',''),(1548,'1','310','1',1,'Retail Sale Id 1481',3002.40,0.00,0.00,4.17,287.73,'2023-02-05 15:41:13','',''),(1549,'1','310','1',1,'Retail Sale Id 1482',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 15:43:46','',''),(1550,'1','310','1',1,'Retail Sale Id 1483',2800.80,0.00,0.00,3.89,268.41,'2023-02-05 15:54:42','',''),(1551,'1','310','1',1,'Retail Sale Id 1484',2880.00,0.00,0.00,4.00,276.00,'2023-02-05 15:55:42','',''),(1552,'1','310','1',1,'Retail Sale Id 1485',2160.00,0.00,0.00,3.00,207.00,'2023-02-05 15:58:56','',''),(1553,'1','310','1',1,'Retail Sale Id 1486',1000.80,0.00,0.00,1.39,95.91,'2023-02-05 16:05:59','',''),(1554,'1','310','1',1,'Retail Sale Id 1487',2203.20,0.00,0.00,3.06,211.14,'2023-02-05 16:07:12','',''),(1555,'1','310','1',1,'Retail Sale Id 1488',720.00,0.00,0.00,1.00,69.00,'2023-02-05 16:09:22','',''),(1556,'1','310','1',1,'Retail Sale Id 1489',35000.00,0.00,0.00,50.00,2450.00,'2023-02-05 16:13:02','',''),(1557,'1','310','1',1,'Retail Sale Id 1490',1000.80,0.00,0.00,1.39,95.91,'2023-02-05 16:17:18','',''),(1558,'1','310','1',1,'Retail Sale Id 1492',7200.00,0.00,0.00,10.00,690.00,'2023-02-05 16:24:20','',''),(1559,'1','310','1',1,'Retail Sale Id 1493',2160.00,0.00,0.00,3.00,207.00,'2023-02-05 16:25:01','',''),(1560,'1','310','1',1,'Retail Sale Id 1494',3600.00,0.00,0.00,5.00,345.00,'2023-02-05 16:32:26','',''),(1561,'1','310','1',1,'Retail Sale Id 1495',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 16:36:08','',''),(1562,'1','310','1',1,'Retail Sale Id 1496',2001.60,0.00,0.00,2.78,191.82,'2023-02-05 16:47:26','',''),(1563,'1','310','1',1,'Retail Sale Id 1497',2203.20,0.00,0.00,3.06,211.14,'2023-02-05 16:53:19','',''),(1564,'1','310','1',1,'Retail Sale Id 1498',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 17:04:55','',''),(1565,'1','310','1',1,'Retail Sale Id 1499',1000.80,0.00,0.00,1.39,95.91,'2023-02-05 17:11:27','',''),(1566,'1','310','1',1,'Retail Sale Id 1500',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 17:12:54','',''),(1567,'1','310','1',1,'Retail Sale Id 1501',2160.00,0.00,0.00,3.00,207.00,'2023-02-05 17:19:50','',''),(1568,'1','310','1',1,'Retail Sale Id 1502',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 17:25:36','',''),(1569,'1','310','1',1,'Retail Sale Id 1503',2001.60,0.00,0.00,2.78,191.82,'2023-02-05 17:26:28','',''),(1570,'1','310','1',1,'Retail Sale Id 1504',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 17:30:22','',''),(1571,'1','310','1',1,'Retail Sale Id 1505',2160.00,0.00,0.00,3.00,207.00,'2023-02-05 17:31:01','',''),(1572,'1','310','1',1,'Retail Sale Id 1506',1000.80,0.00,0.00,1.39,95.91,'2023-02-05 17:37:10','',''),(1573,'1','310','1',1,'Retail Sale Id 1507',35000.00,0.00,0.00,50.00,2450.00,'2023-02-05 17:47:51','',''),(1574,'1','310','1',1,'Retail Sale Id 1508',3002.40,0.00,0.00,4.17,287.73,'2023-02-05 17:48:27','',''),(1575,'1','310','1',1,'Retail Sale Id 1509',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 17:50:27','',''),(1576,'1','310','1',1,'Retail Sale Id 1511',1440.00,0.00,0.00,2.00,138.00,'2023-02-05 17:52:13','',''),(1577,'1','310','1',1,'Retail Sale Id 1512',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 17:53:09','',''),(1578,'1','310','1',1,'Retail Sale Id 1513',2160.00,0.00,0.00,3.00,207.00,'2023-02-05 17:53:53','',''),(1579,'1','310','1',1,'Return of Retail Sale Id 1512',0.00,4320.00,6.00,0.00,-414.00,'2023-02-05 17:54:59','',''),(1580,'1','310','1',1,'Retail Sale Id 1514',1497.60,0.00,0.00,2.08,143.52,'2023-02-05 17:55:50','',''),(1581,'1','310','1',1,'Retail Sale Id 1515',15001.00,0.00,0.00,21.43,1050.07,'2023-02-05 17:59:25','',''),(1582,'1','310','1',1,'Retail Sale Id 1516',8503.20,0.00,0.00,11.81,814.89,'2023-02-05 18:05:20','',''),(1583,'1','310','1',1,'Retail Sale Id 1517',2160.00,0.00,0.00,3.00,207.00,'2023-02-05 18:09:08','',''),(1584,'1','310','1',1,'Retail Sale Id 1518',1000.80,0.00,0.00,1.39,95.91,'2023-02-05 18:10:29','',''),(1585,'1','310','1',1,'Retail Sale Id 1519',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 18:11:21','',''),(1586,'1','310','1',1,'Retail Sale Id 1520',720.00,0.00,0.00,1.00,69.00,'2023-02-05 18:12:43','',''),(1587,'1','310','1',1,'Retail Sale Id 1521',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 18:13:27','',''),(1588,'1','310','1',1,'Retail Sale Id 1522',2001.60,0.00,0.00,2.78,191.82,'2023-02-05 18:20:08','',''),(1589,'1','310','1',1,'Retail Sale Id 1523',2001.60,0.00,0.00,2.78,191.82,'2023-02-05 18:20:59','',''),(1590,'1','310','1',1,'Retail Sale Id 1524',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 18:22:01','',''),(1591,'1','310','1',1,'Retail Sale Id 1525',7200.00,0.00,0.00,10.00,690.00,'2023-02-05 18:23:19','',''),(1592,'1','310','1',1,'Retail Sale Id 1526',1000.80,0.00,0.00,1.39,95.91,'2023-02-05 18:24:07','',''),(1593,'1','310','1',1,'Retail Sale Id 1527',1497.60,0.00,0.00,2.08,143.52,'2023-02-05 18:24:39','',''),(1594,'1','310','1',1,'Retail Sale Id 1528',3002.40,0.00,0.00,4.17,287.73,'2023-02-05 18:25:20','',''),(1595,'1','310','1',1,'Retail Sale Id 1529',9000.00,0.00,0.00,12.50,862.50,'2023-02-05 18:30:45','',''),(1596,'1','310','1',1,'Retail Sale Id 1530',799.20,0.00,0.00,1.11,76.59,'2023-02-05 18:48:44','',''),(1597,'1','310','1',1,'Retail Sale Id 1531',4320.00,0.00,0.00,6.00,414.00,'2023-02-05 18:50:24','',''),(1598,'1','310','1',1,'Retail Sale Id 1532',4327.20,0.00,0.00,6.01,414.69,'2023-02-05 18:51:33','',''),(1599,'1','310','1',1,'Retail Sale Id 1534',3600.00,0.00,0.00,5.00,345.00,'2023-02-05 18:52:38','',''),(1600,'1','310','1',1,'Retail Sale Id 1535',2851.20,0.00,0.00,3.96,273.24,'2023-02-05 19:12:25','',''),(1601,'1','310','1',1,'Return of Retail Sale Id 1515',0.00,15001.00,21.43,0.00,-1050.07,'2023-02-05 19:16:14','',''),(1602,'1','310','1',1,'Retail Sale Id 1536',15001.00,0.00,0.00,21.43,1050.07,'2023-02-05 19:18:11','',''),(1603,'1','310','1',1,'Retail Sale Id 1537',4003.20,0.00,0.00,5.56,383.64,'2023-02-06 07:21:41','',''),(1604,'1','310','1',1,'Retail Sale Id 1538',3997.00,0.00,0.00,5.71,279.79,'2023-02-06 07:59:25','',''),(1605,'1','310','1',1,'Retail Sale Id 1539',9000.00,0.00,0.00,12.50,862.50,'2023-02-06 08:08:11','',''),(1606,'1','310','1',1,'Retail Sale Id 1539',9000.00,0.00,0.00,12.50,862.50,'2023-02-06 08:08:11','',''),(1607,'1','310','1',1,'Retail Sale Id 1540',2001.60,0.00,0.00,2.78,191.82,'2023-02-06 08:13:31','',''),(1608,'1','310','1',1,'Retail Sale Id 1541',2001.60,0.00,0.00,2.78,191.82,'2023-02-06 08:33:25','',''),(1609,'1','310','1',1,'Retail Sale Id 1542',2160.00,0.00,0.00,3.00,207.00,'2023-02-06 08:35:29','',''),(1610,'1','310','1',1,'Retail Sale Id 1543',2160.00,0.00,0.00,3.00,207.00,'2023-02-06 08:40:02','',''),(1611,'1','310','1',1,'Retail Sale Id 1544',7200.00,0.00,0.00,10.00,690.00,'2023-02-06 08:42:59','',''),(1612,'1','310','1',1,'Retail Sale Id 1544',9000.00,0.00,0.00,12.50,862.50,'2023-02-06 08:42:59','',''),(1613,'1','310','1',1,'Retail Sale Id 1545',2160.00,0.00,0.00,3.00,207.00,'2023-02-06 08:47:10','',''),(1614,'1','310','1',1,'Retail Sale Id 1546',2001.60,0.00,0.00,2.78,191.82,'2023-02-06 08:52:22','',''),(1615,'1','310','1',1,'Retail Sale Id 1547',4320.00,0.00,0.00,6.00,414.00,'2023-02-06 08:53:52','',''),(1616,'1','310','1',1,'Retail Sale Id 1548',2160.00,0.00,0.00,3.00,207.00,'2023-02-06 09:04:48','',''),(1617,'1','310','1',1,'Retail Sale Id 1549',4320.00,0.00,0.00,6.00,414.00,'2023-02-06 09:40:25','',''),(1618,'1','310','1',1,'Retail Sale Id 1550',4996.80,0.00,0.00,6.94,478.86,'2023-02-06 09:55:26','',''),(1619,'1','310','1',1,'Retail Sale Id 1551',2001.60,0.00,0.00,2.78,191.82,'2023-02-06 10:02:54','',''),(1620,'1','310','1',1,'Retail Sale Id 1552',7999.20,0.00,0.00,11.11,766.59,'2023-02-06 10:04:22','',''),(1621,'1','310','1',1,'Retail Sale Id 1553',9000.00,0.00,0.00,12.50,862.50,'2023-02-06 10:05:47','',''),(1622,'1','310','1',1,'Retail Sale Id 1554',1800.00,0.00,0.00,2.50,172.50,'2023-02-06 10:07:47','',''),(1623,'1','310','1',1,'Retail Sale Id 1555',4320.00,0.00,0.00,6.00,414.00,'2023-02-06 10:12:36','',''),(1624,'1','310','1',1,'Retail Sale Id 1556',38500.00,0.00,0.00,55.00,2695.00,'2023-02-06 10:14:44','',''),(1625,'1','310','1',1,'Retail Sale Id 1557',7200.00,0.00,0.00,10.00,690.00,'2023-02-06 10:21:41','',''),(1626,'1','310','1',1,'Retail Sale Id 1558',1303.20,0.00,0.00,1.81,124.89,'2023-02-06 10:22:46','',''),(1627,'1','310','1',1,'Retail Sale Id 1559',4320.00,0.00,0.00,6.00,414.00,'2023-02-06 10:25:31','',''),(1628,'1','310','1',1,'Retail Sale Id 1560',3002.40,0.00,0.00,4.17,287.73,'2023-02-06 10:26:43','',''),(1629,'1','310','1',1,'Retail Sale Id 1562',6998.40,0.00,0.00,9.72,670.68,'2023-02-06 10:30:07','',''),(1630,'1','310','1',1,'Retail Sale Id 1563',4003.20,0.00,0.00,5.56,383.64,'2023-02-06 10:33:02','',''),(1631,'1','310','1',1,'Retail Sale Id 1564',3600.00,0.00,0.00,5.00,345.00,'2023-02-06 10:34:47','',''),(1632,'1','310','1',1,'Retail Sale Id 1565',2160.00,0.00,0.00,3.00,207.00,'2023-02-06 10:40:40','',''),(1633,'1','310','1',1,'Retail Sale Id 1566',503300.00,0.00,0.00,719.00,35231.00,'2023-02-06 10:56:29','',''),(1634,'1','310','1',1,'Retail Sale Id 1567',9000.00,0.00,0.00,12.50,862.50,'2023-02-06 10:57:17','',''),(1635,'1','310','1',1,'Retail Sale Id 1568',4320.00,0.00,0.00,6.00,414.00,'2023-02-06 11:02:39','',''),(1636,'1','310','1',1,'Retail Sale Id 1569',2001.60,0.00,0.00,2.78,191.82,'2023-02-06 11:07:55','',''),(1637,'1','310','1',1,'Retail Sale Id 1570',2160.00,0.00,0.00,3.00,207.00,'2023-02-06 11:10:26','',''),(1638,'1','310','1',1,'Retail Sale Id 1571',2498.40,0.00,0.00,3.47,239.43,'2023-02-06 11:13:56','',''),(1639,'1','310','1',1,'Retail Sale Id 1572',42000.00,0.00,0.00,60.00,2940.00,'2023-02-06 11:22:19','',''),(1640,'1','310','1',1,'Retail Sale Id 1573',3002.40,0.00,0.00,4.17,287.73,'2023-02-06 11:24:00','',''),(1641,'1','310','1',1,'Retail Sale Id 1574',9000.00,0.00,0.00,12.50,862.50,'2023-02-06 11:31:05','',''),(1642,'1','310','1',1,'Retail Sale Id 1575',9000.00,0.00,0.00,12.50,862.50,'2023-02-06 11:48:36','',''),(1643,'1','310','1',1,'Retail Sale Id 1576',8750.00,0.00,0.00,12.50,612.50,'2023-02-06 11:54:21','',''),(1644,'1','310','1',1,'Retail Sale Id 1577',9000.00,0.00,0.00,12.50,862.50,'2023-02-06 11:58:29','',''),(1645,'1','310','1',1,'Retail Sale Id 1577',9000.00,0.00,0.00,12.50,862.50,'2023-02-06 11:58:29','',''),(1646,'1','310','1',1,'Retail Sale Id 1577',9000.00,0.00,0.00,12.50,862.50,'2023-02-06 11:58:29','',''),(1647,'1','310','1',1,'Retail Sale Id 1578',2160.00,0.00,0.00,3.00,207.00,'2023-02-06 12:03:39','',''),(1648,'1','310','1',1,'Retail Sale Id 1579',3002.40,0.00,0.00,4.17,287.73,'2023-02-06 12:11:59','',''),(1649,'1','310','1',1,'Retail Sale Id 1580',5040.00,0.00,0.00,7.00,483.00,'2023-02-06 12:13:14','',''),(1650,'1','310','1',1,'Retail Sale Id 1581',5040.00,0.00,0.00,7.00,483.00,'2023-02-06 12:15:00','',''),(1651,'1','310','1',1,'Retail Sale Id 1582',2001.60,0.00,0.00,2.78,191.82,'2023-02-06 12:16:41','',''),(1652,'1','310','1',1,'Retail Sale Id 1584',2160.00,0.00,0.00,3.00,207.00,'2023-02-06 12:23:30','',''),(1653,'1','310','1',1,'Retail Sale Id 1585',9000.00,0.00,0.00,12.50,862.50,'2023-02-06 12:26:51','',''),(1654,'1','310','1',1,'Retail Sale Id 1586',65100.00,0.00,0.00,93.00,4557.00,'2023-02-06 12:32:06','',''),(1655,'1','310','1',1,'Retail Sale Id 1587',2160.00,0.00,0.00,3.00,207.00,'2023-02-06 12:35:56','',''),(1656,'1','310','1',1,'Retail Sale Id 1587',3600.00,0.00,0.00,5.00,345.00,'2023-02-06 12:35:56','',''),(1657,'1','310','1',1,'Retail Sale Id 1587',4320.00,0.00,0.00,6.00,414.00,'2023-02-06 12:35:56','',''),(1658,'1','310','1',1,'Retail Sale Id 1587',4320.00,0.00,0.00,6.00,414.00,'2023-02-06 12:35:56','',''),(1659,'1','310','1',1,'Retail Sale Id 1588',4003.20,0.00,0.00,5.56,383.64,'2023-02-06 12:36:35','',''),(1660,'1','310','1',1,'Retail Sale Id 1589',4320.00,0.00,0.00,6.00,414.00,'2023-02-06 12:39:33','',''),(1661,'1','310','1',1,'Retail Sale Id 1590',4320.00,0.00,0.00,6.00,414.00,'2023-02-06 12:44:41','',''),(1662,'1','310','1',1,'Retail Sale Id 1590',9000.00,0.00,0.00,12.50,862.50,'2023-02-06 12:44:41','',''),(1663,'1','310','1',1,'Retail Sale Id 1591',1497.60,0.00,0.00,2.08,143.52,'2023-02-06 12:48:07','',''),(1664,'1','310','1',1,'Retail Sale Id 1592',1000.80,0.00,0.00,1.39,95.91,'2023-02-06 12:51:09','',''),(1665,'1','310','1',1,'Retail Sale Id 1593',1497.60,0.00,0.00,2.08,143.52,'2023-02-06 13:05:33','',''),(1666,'1','310','1',1,'Retail Sale Id 1594',1000.80,0.00,0.00,1.39,95.91,'2023-02-06 13:06:24','',''),(1667,'1','310','1',1,'Retail Sale Id 1595',2160.00,0.00,0.00,3.00,207.00,'2023-02-06 13:12:00','',''),(1668,'1','310','1',1,'Retail Sale Id 1596',2001.60,0.00,0.00,2.78,191.82,'2023-02-06 13:15:25','',''),(1669,'1','310','1',1,'Retail Sale Id 1597',4320.00,0.00,0.00,6.00,414.00,'2023-02-06 13:20:58','',''),(1670,'1','310','1',1,'Retail Sale Id 1597',4320.00,0.00,0.00,6.00,414.00,'2023-02-06 13:20:58','',''),(1671,'1','310','1',1,'Retail Sale Id 1598',9000.00,0.00,0.00,12.50,862.50,'2023-02-06 13:22:49','',''),(1672,'1','310','1',1,'Retail Sale Id 1599',1000.80,0.00,0.00,1.39,95.91,'2023-02-06 13:24:06','',''),(1673,'1','310','1',1,'Retail Sale Id 1600',2001.60,0.00,0.00,2.78,191.82,'2023-02-06 13:37:03','',''),(1674,'1','310','1',1,'Retail Sale Id 1601',6480.00,0.00,0.00,9.00,621.00,'2023-02-06 13:42:00','',''),(1675,'1','310','1',1,'Retail Sale Id 1602',7502.40,0.00,0.00,10.42,718.98,'2023-02-06 13:43:55','',''),(1676,'1','310','1',1,'Retail Sale Id 1604',3600.00,0.00,0.00,5.00,345.00,'2023-02-06 13:56:26','',''),(1677,'1','310','1',1,'Retail Sale Id 1605',9000.00,0.00,0.00,12.50,862.50,'2023-02-06 13:59:26','',''),(1678,'1','310','1',1,'Retail Sale Id 1607',70000.00,0.00,0.00,100.00,4900.00,'2023-02-06 14:16:01','',''),(1679,'1','310','1',1,'Retail Sale Id 1608',70000.00,0.00,0.00,100.00,4900.00,'2023-02-06 14:16:58','',''),(1680,'1','310','1',1,'Retail Sale Id 1609',26250.00,0.00,0.00,37.50,1837.50,'2023-02-06 14:18:17','',''),(1681,'1','310','1',1,'Retail Sale Id 1610',496.80,0.00,0.00,0.69,47.61,'2023-02-06 14:19:34','',''),(1682,'1','310','1',1,'Retail Sale Id 1611',1000.80,0.00,0.00,1.39,95.91,'2023-02-06 14:20:51','',''),(1683,'1','310','1',1,'Retail Sale Id 1612',1000.80,0.00,0.00,1.39,95.91,'2023-02-06 14:43:24','',''),(1684,'1','310','1',1,'Retail Sale Id 1613',4320.00,0.00,0.00,6.00,414.00,'2023-02-06 14:44:56','',''),(1685,'1','310','1',1,'Retail Sale Id 1613',4320.00,0.00,0.00,6.00,414.00,'2023-02-06 14:44:56','',''),(1686,'1','310','1',1,'Retail Sale Id 1614',2001.60,0.00,0.00,2.78,191.82,'2023-02-06 14:48:14','',''),(1687,'1','310','1',1,'Retail Sale Id 1615',3002.40,0.00,0.00,4.17,287.73,'2023-02-06 15:09:00','',''),(1688,'1','310','1',1,'Retail Sale Id 1616',1800.00,0.00,0.00,2.50,172.50,'2023-02-06 15:10:43','',''),(1689,'1','310','1',1,'Retail Sale Id 1617',9296.00,0.00,0.00,13.28,650.72,'2023-02-06 15:15:30','',''),(1690,'1','310','1',1,'Retail Sale Id 1618',3002.40,0.00,0.00,4.17,287.73,'2023-02-06 15:18:56','',''),(1691,'1','310','1',1,'Retail Sale Id 1618',3002.40,0.00,0.00,4.17,287.73,'2023-02-06 15:18:56','',''),(1692,'1','310','1',1,'Retail Sale Id 1619',4399.20,0.00,0.00,6.11,421.59,'2023-02-06 15:20:12','',''),(1693,'1','310','1',1,'Retail Sale Id 1620',2160.00,0.00,0.00,3.00,207.00,'2023-02-06 15:21:54','',''),(1694,'1','310','1',1,'Retail Sale Id 1621',350000.00,0.00,0.00,500.00,24500.00,'2023-02-06 15:30:43','',''),(1695,'1','310','1',1,'Retail Sale Id 1622',4003.20,0.00,0.00,5.56,383.64,'2023-02-06 15:31:35','',''),(1696,'1','310','1',1,'Retail Sale Id 1624',2498.40,0.00,0.00,3.47,239.43,'2023-02-06 15:37:33','',''),(1697,'1','310','1',1,'Retail Sale Id 1625',4320.00,0.00,0.00,6.00,414.00,'2023-02-06 15:38:00','',''),(1698,'1','310','1',1,'Retail Sale Id 1626',7200.00,0.00,0.00,10.00,690.00,'2023-02-06 15:55:43','',''),(1699,'1','310','1',1,'Retail Sale Id 1627',7200.00,0.00,0.00,10.00,690.00,'2023-02-06 16:04:19','',''),(1700,'1','310','1',1,'Retail Sale Id 1628',7999.20,0.00,0.00,11.11,766.59,'2023-02-06 16:07:56','',''),(1701,'1','310','1',1,'Retail Sale Id 1629',3600.00,0.00,0.00,5.00,345.00,'2023-02-06 16:08:42','',''),(1702,'1','310','1',1,'Retail Sale Id 1630',1000.80,0.00,0.00,1.39,95.91,'2023-02-06 16:26:24','',''),(1703,'1','310','1',1,'Retail Sale Id 1631',2001.60,0.00,0.00,2.78,191.82,'2023-02-06 16:31:29','',''),(1704,'1','310','1',1,'Retail Sale Id 1632',496.80,0.00,0.00,0.69,47.61,'2023-02-06 16:42:16','',''),(1705,'1','310','1',1,'Retail Sale Id 1633',1202.40,0.00,0.00,1.67,115.23,'2023-02-06 16:43:15','',''),(1706,'1','310','1',1,'Retail Sale Id 1634',10800.00,0.00,0.00,15.00,1035.00,'2023-02-06 16:46:15','',''),(1707,'1','310','1',1,'Retail Sale Id 1635',4320.00,0.00,0.00,6.00,414.00,'2023-02-06 16:51:27','',''),(1708,'1','310','1',1,'Retail Sale Id 1636',1440.00,0.00,0.00,2.00,138.00,'2023-02-06 16:52:32','',''),(1709,'1','310','1',1,'Retail Sale Id 1637',3600.00,0.00,0.00,5.00,345.00,'2023-02-06 16:54:11','',''),(1710,'1','310','1',1,'Retail Sale Id 1638',4320.00,0.00,0.00,6.00,414.00,'2023-02-06 16:59:57','',''),(1711,'1','310','1',1,'Retail Sale Id 1639',1202.40,0.00,0.00,1.67,115.23,'2023-02-06 17:00:43','',''),(1712,'1','310','1',1,'Retail Sale Id 1640',3002.40,0.00,0.00,4.17,287.73,'2023-02-06 17:09:27','',''),(1713,'1','310','1',1,'Retail Sale Id 1641',35000.00,0.00,0.00,50.00,2450.00,'2023-02-06 17:10:09','',''),(1714,'1','310','1',1,'Retail Sale Id 1643',748.80,0.00,0.00,1.04,71.76,'2023-02-06 17:13:55','',''),(1715,'1','310','1',1,'Retail Sale Id 1644',720.00,0.00,0.00,1.00,69.00,'2023-02-06 17:15:00','',''),(1716,'1','310','1',1,'Retail Sale Id 1645',799.20,0.00,0.00,1.11,76.59,'2023-02-06 17:15:51','',''),(1717,'1','310','1',1,'Return of Retail Sale Id 1643',0.00,748.80,1.04,0.00,-71.76,'2023-02-06 17:17:26','',''),(1718,'1','310','1',1,'Retail Sale Id 1646',2203.20,0.00,0.00,3.06,211.14,'2023-02-06 17:18:42','',''),(1719,'1','310','1',1,'Retail Sale Id 1647',720.00,0.00,0.00,1.00,69.00,'2023-02-06 17:19:33','',''),(1720,'1','310','1',1,'Retail Sale Id 1648',2160.00,0.00,0.00,3.00,207.00,'2023-02-06 17:24:20','',''),(1721,'1','310','1',1,'Retail Sale Id 1649',1000.80,0.00,0.00,1.39,95.91,'2023-02-06 17:27:08','',''),(1722,'1','310','1',1,'Retail Sale Id 1650',2001.60,0.00,0.00,2.78,191.82,'2023-02-06 17:27:43','',''),(1723,'1','310','1',1,'Retail Sale Id 1651',748.80,0.00,0.00,1.04,71.76,'2023-02-06 17:34:06','',''),(1724,'1','310','1',1,'Retail Sale Id 1652',1497.60,0.00,0.00,2.08,143.52,'2023-02-06 17:43:36','',''),(1725,'1','310','1',1,'Retail Sale Id 1653',2160.00,0.00,0.00,3.00,207.00,'2023-02-06 17:48:47','',''),(1726,'1','310','1',1,'Retail Sale Id 1654',3002.40,0.00,0.00,4.17,287.73,'2023-02-06 17:51:30','',''),(1727,'1','310','1',1,'Retail Sale Id 1655',4320.00,0.00,0.00,6.00,414.00,'2023-02-06 17:52:59','',''),(1728,'1','310','1',1,'Retail Sale Id 1655',9000.00,0.00,0.00,12.50,862.50,'2023-02-06 17:52:59','',''),(1729,'1','310','1',1,'Retail Sale Id 1656',1000.80,0.00,0.00,1.39,95.91,'2023-02-06 18:01:28','',''),(1730,'1','310','1',1,'Retail Sale Id 1657',9000.00,0.00,0.00,12.50,862.50,'2023-02-06 18:03:03','',''),(1731,'1','310','1',1,'Retail Sale Id 1658',4320.00,0.00,0.00,6.00,414.00,'2023-02-06 18:09:22','',''),(1732,'1','310','1',1,'Retail Sale Id 1659',1000.80,0.00,0.00,1.39,95.91,'2023-02-06 18:11:34','',''),(1733,'1','310','1',1,'Retail Sale Id 1660',4320.00,0.00,0.00,6.00,414.00,'2023-02-06 18:12:33','',''),(1734,'1','310','1',1,'Retail Sale Id 1661',748.80,0.00,0.00,1.04,71.76,'2023-02-06 18:13:13','',''),(1735,'1','310','1',1,'Retail Sale Id 1662',1497.60,0.00,0.00,2.08,143.52,'2023-02-06 18:13:56','',''),(1736,'1','310','1',1,'Retail Sale Id 1663',1000.80,0.00,0.00,1.39,95.91,'2023-02-06 18:16:41','',''),(1737,'1','310','1',1,'Retail Sale Id 1664',799.20,0.00,0.00,1.11,76.59,'2023-02-06 18:17:43','',''),(1738,'1','310','1',1,'Retail Sale Id 1665',1497.60,0.00,0.00,2.08,143.52,'2023-02-06 18:21:03','',''),(1739,'1','310','1',1,'Retail Sale Id 1666',3600.00,0.00,0.00,5.00,345.00,'2023-02-06 18:50:57','',''),(1740,'1','310','1',1,'Return of Retail Sale Id 1664',0.00,799.20,1.11,0.00,-76.59,'2023-02-06 18:59:10','',''),(1741,'1','310','1',1,'Retail Sale Id 1667',374.40,0.00,0.00,0.52,35.88,'2023-02-06 18:59:41','',''),(1742,'1','310','1',1,'Retail Sale Id 1668',100.80,0.00,0.00,0.14,9.66,'2023-02-06 19:01:18','',''),(1743,'1','310','1',1,'Retail Sale Id 1669',5621.00,0.00,0.00,8.03,393.47,'2023-02-06 19:02:52','',''),(1744,'1','310','1',1,'Return of Retail Sale Id 1576',0.00,8750.00,12.50,0.00,-612.50,'2023-02-06 19:04:34','',''),(1745,'1','310','1',1,'Return of Retail Sale Id 1669',0.00,5621.00,8.03,0.00,-393.47,'2023-02-06 19:05:55','',''),(1746,'1','310','1',1,'Retail Sale Id 1670',3129.00,0.00,0.00,4.47,219.03,'2023-02-06 19:08:11','',''),(1747,'1','310','1',1,'Retail Sale Id 1671',3600.00,0.00,0.00,5.00,345.00,'2023-02-07 07:13:04','',''),(1748,'1','310','1',1,'Retail Sale Id 1672',496.80,0.00,0.00,0.69,47.61,'2023-02-07 07:45:04','',''),(1749,'1','310','1',1,'Retail Sale Id 1673',7000.00,0.00,0.00,10.00,490.00,'2023-02-07 07:57:47','',''),(1750,'1','310','1',1,'Retail Sale Id 1674',1000.80,0.00,0.00,1.39,95.91,'2023-02-07 07:58:58','',''),(1751,'1','310','1',1,'Retail Sale Id 1675',3499.20,0.00,0.00,4.86,335.34,'2023-02-07 08:13:02','',''),(1752,'1','310','1',1,'Retail Sale Id 1676',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 08:22:26','',''),(1753,'1','310','1',1,'Retail Sale Id 1677',2001.60,0.00,0.00,2.78,191.82,'2023-02-07 08:28:09','',''),(1754,'1','310','1',1,'Retail Sale Id 1678',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 08:32:18','',''),(1755,'1','310','1',1,'Retail Sale Id 1679',2160.00,0.00,0.00,3.00,207.00,'2023-02-07 08:47:17','',''),(1756,'1','310','1',1,'Retail Sale Id 1680',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 08:48:47','',''),(1757,'1','310','1',1,'Retail Sale Id 1681',496.80,0.00,0.00,0.69,47.61,'2023-02-07 08:53:28','',''),(1758,'1','310','1',1,'Retail Sale Id 1682',12600.00,0.00,0.00,18.00,882.00,'2023-02-07 08:56:16','',''),(1759,'1','310','1',1,'Retail Sale Id 1683',11200.00,0.00,0.00,16.00,784.00,'2023-02-07 08:59:39','',''),(1760,'1','310','1',1,'Return of Retail Sale Id 1682',0.00,12600.00,18.00,0.00,-882.00,'2023-02-07 09:00:38','',''),(1761,'1','310','1',1,'Retail Sale Id 1684',5760.00,0.00,0.00,8.00,552.00,'2023-02-07 09:08:17','',''),(1762,'1','310','1',1,'Retail Sale Id 1685',1000.80,0.00,0.00,1.39,95.91,'2023-02-07 09:20:04','',''),(1763,'1','310','1',1,'Retail Sale Id 1686',3600.00,0.00,0.00,5.00,345.00,'2023-02-07 09:35:14','',''),(1764,'1','310','1',1,'Retail Sale Id 1687',4996.80,0.00,0.00,6.94,478.86,'2023-02-07 09:36:37','',''),(1765,'1','310','1',1,'Retail Sale Id 1688',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 09:40:06','',''),(1766,'1','310','1',1,'Retail Sale Id 1689',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 09:41:05','',''),(1767,'1','310','1',1,'Retail Sale Id 1690',4320.00,0.00,0.00,6.00,414.00,'2023-02-07 09:48:29','',''),(1768,'1','310','1',1,'Retail Sale Id 1691',2160.00,0.00,0.00,3.00,207.00,'2023-02-07 09:57:03','',''),(1769,'1','310','1',1,'Retail Sale Id 1691',2160.00,0.00,0.00,3.00,207.00,'2023-02-07 09:57:03','',''),(1770,'1','310','1',1,'Retail Sale Id 1692',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 09:59:16','',''),(1771,'1','310','1',1,'Retail Sale Id 1693',70000.00,0.00,0.00,100.00,4900.00,'2023-02-07 10:03:16','',''),(1772,'1','310','1',1,'Retail Sale Id 1694',4320.00,0.00,0.00,6.00,414.00,'2023-02-07 10:04:17','',''),(1773,'1','310','1',1,'Retail Sale Id 1695',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 10:06:07','',''),(1774,'1','310','1',1,'Retail Sale Id 1696',7200.00,0.00,0.00,10.00,690.00,'2023-02-07 10:13:30','',''),(1775,'1','310','1',1,'Retail Sale Id 1697',126000.00,0.00,0.00,180.00,8820.00,'2023-02-07 10:23:07','',''),(1776,'1','310','1',1,'Retail Sale Id 1698',1000.80,0.00,0.00,1.39,95.91,'2023-02-07 10:24:52','',''),(1777,'1','310','1',1,'Retail Sale Id 1699',1000.80,0.00,0.00,1.39,95.91,'2023-02-07 10:25:52','',''),(1778,'1','310','1',1,'Retail Sale Id 1700',4320.00,0.00,0.00,6.00,414.00,'2023-02-07 10:33:35','',''),(1779,'1','310','1',1,'Retail Sale Id 1701',496.80,0.00,0.00,0.69,47.61,'2023-02-07 10:44:43','',''),(1780,'1','310','1',1,'Retail Sale Id 1702',3002.40,0.00,0.00,4.17,287.73,'2023-02-07 10:47:00','',''),(1781,'1','310','1',1,'Retail Sale Id 1703',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 10:50:50','',''),(1782,'1','310','1',1,'Retail Sale Id 1704',1000.80,0.00,0.00,1.39,95.91,'2023-02-07 10:56:40','',''),(1783,'1','310','1',1,'Retail Sale Id 1704',1000.80,0.00,0.00,1.39,95.91,'2023-02-07 10:56:40','',''),(1784,'1','310','1',1,'Retail Sale Id 1705',4348.80,0.00,0.00,6.04,416.76,'2023-02-07 10:57:50','',''),(1785,'1','310','1',1,'Retail Sale Id 1706',72000.00,0.00,0.00,100.00,6900.00,'2023-02-07 10:58:43','',''),(1786,'1','310','1',1,'Retail Sale Id 1708',2880.00,0.00,0.00,4.00,276.00,'2023-02-07 11:00:20','',''),(1787,'1','310','1',1,'Retail Sale Id 1709',1000.80,0.00,0.00,1.39,95.91,'2023-02-07 11:01:34','',''),(1788,'1','310','1',1,'Retail Sale Id 1710',1000.80,0.00,0.00,1.39,95.91,'2023-02-07 11:02:42','',''),(1789,'1','310','1',1,'Retail Sale Id 1711',140000.00,0.00,0.00,200.00,9800.00,'2023-02-07 11:06:45','',''),(1790,'1','310','1',1,'Retail Sale Id 1712',42000.00,0.00,0.00,60.00,2940.00,'2023-02-07 11:11:06','',''),(1791,'1','310','1',1,'Retail Sale Id 1713',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 11:11:58','',''),(1792,'1','310','1',1,'Retail Sale Id 1714',2001.60,0.00,0.00,2.78,191.82,'2023-02-07 11:17:23','',''),(1793,'1','310','1',1,'Retail Sale Id 1715',77000.00,0.00,0.00,110.00,5390.00,'2023-02-07 11:19:22','',''),(1794,'1','310','1',1,'Retail Sale Id 1716',799.20,0.00,0.00,1.11,76.59,'2023-02-07 11:20:51','',''),(1795,'1','310','1',1,'Retail Sale Id 1717',2160.00,0.00,0.00,3.00,207.00,'2023-02-07 11:34:08','',''),(1796,'1','310','1',1,'Retail Sale Id 1719',799.20,0.00,0.00,1.11,76.59,'2023-02-07 11:48:47','',''),(1797,'1','310','1',1,'Retail Sale Id 1722',2203.20,0.00,0.00,3.06,211.14,'2023-02-07 11:55:35','',''),(1798,'1','310','1',1,'Retail Sale Id 1723',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 12:10:29','',''),(1799,'1','310','1',1,'Retail Sale Id 1724',2160.00,0.00,0.00,3.00,207.00,'2023-02-07 12:16:05','',''),(1800,'1','310','1',1,'Retail Sale Id 1724',7920.00,0.00,0.00,11.00,759.00,'2023-02-07 12:16:05','',''),(1801,'1','310','1',1,'Retail Sale Id 1725',2700.00,0.00,0.00,3.75,258.75,'2023-02-07 12:17:02','',''),(1802,'1','310','1',1,'Retail Sale Id 1726',35000.00,0.00,0.00,50.00,2450.00,'2023-02-07 12:18:27','',''),(1803,'1','310','1',1,'Retail Sale Id 1727',140000.00,0.00,0.00,200.00,9800.00,'2023-02-07 12:19:24','',''),(1804,'1','310','1',1,'Retail Sale Id 1728',38500.00,0.00,0.00,55.00,2695.00,'2023-02-07 12:29:33','',''),(1805,'1','310','1',1,'Return of Retail Sale Id 1709',0.00,1000.80,1.39,0.00,-95.91,'2023-02-07 12:42:22','',''),(1806,'1','310','1',1,'Retail Sale Id 1729',5040.00,0.00,0.00,7.00,483.00,'2023-02-07 12:49:09','',''),(1807,'1','310','1',1,'Retail Sale Id 1730',2001.60,0.00,0.00,2.78,191.82,'2023-02-07 12:50:21','',''),(1808,'1','310','1',1,'Retail Sale Id 1731',125300.00,0.00,0.00,179.00,8771.00,'2023-02-07 12:52:27','',''),(1809,'1','310','1',1,'Return of Retail Sale Id 1727',0.00,140000.00,200.00,0.00,-9800.00,'2023-02-07 12:53:49','',''),(1810,'1','310','1',1,'Retail Sale Id 1732',2160.00,0.00,0.00,3.00,207.00,'2023-02-07 12:55:28','',''),(1811,'1','310','1',1,'Retail Sale Id 1733',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 13:01:39','',''),(1812,'1','310','1',1,'Retail Sale Id 1734',4500.00,0.00,0.00,6.25,431.25,'2023-02-07 13:06:20','',''),(1813,'1','310','1',1,'Retail Sale Id 1735',1000.80,0.00,0.00,1.39,95.91,'2023-02-07 13:08:01','',''),(1814,'1','310','1',1,'Retail Sale Id 1736',4320.00,0.00,0.00,6.00,414.00,'2023-02-07 13:09:27','',''),(1815,'1','310','1',1,'Retail Sale Id 1737',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 13:10:41','',''),(1816,'1','310','1',1,'Retail Sale Id 1739',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 13:20:09','',''),(1817,'1','310','1',1,'Retail Sale Id 1740',2160.00,0.00,0.00,3.00,207.00,'2023-02-07 13:22:06','',''),(1818,'1','310','1',1,'Retail Sale Id 1742',2160.00,0.00,0.00,3.00,207.00,'2023-02-07 13:24:35','',''),(1819,'1','310','1',1,'Retail Sale Id 1743',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 13:25:25','',''),(1820,'1','310','1',1,'Retail Sale Id 1744',4003.20,0.00,0.00,5.56,383.64,'2023-02-07 13:26:43','',''),(1821,'1','310','1',1,'Retail Sale Id 1745',2001.60,0.00,0.00,2.78,191.82,'2023-02-07 13:31:59','',''),(1822,'1','310','1',1,'Return of Retail Sale Id 1740',0.00,2160.00,3.00,0.00,-207.00,'2023-02-07 13:34:49','',''),(1823,'1','310','1',1,'Retail Sale Id 1746',1000.80,0.00,0.00,1.39,95.91,'2023-02-07 13:40:48','',''),(1824,'1','310','1',1,'Retail Sale Id 1747',2880.00,0.00,0.00,4.00,276.00,'2023-02-07 13:54:50','',''),(1825,'1','310','1',1,'Retail Sale Id 1748',175000.00,0.00,0.00,250.00,12250.00,'2023-02-07 13:58:48','',''),(1826,'1','310','1',1,'Retail Sale Id 1749',4320.00,0.00,0.00,6.00,414.00,'2023-02-07 14:07:48','',''),(1827,'1','310','1',1,'Retail Sale Id 1750',4320.00,0.00,0.00,6.00,414.00,'2023-02-07 14:15:39','',''),(1828,'1','310','1',1,'Retail Sale Id 1750',5040.00,0.00,0.00,7.00,483.00,'2023-02-07 14:15:39','',''),(1829,'1','310','1',1,'Retail Sale Id 1751',8750.00,0.00,0.00,12.50,612.50,'2023-02-07 14:18:57','',''),(1830,'1','310','1',1,'Retail Sale Id 1753',1000.80,0.00,0.00,1.39,95.91,'2023-02-07 14:20:40','',''),(1831,'1','310','1',1,'Retail Sale Id 1754',1000.80,0.00,0.00,1.39,95.91,'2023-02-07 14:23:25','',''),(1832,'1','310','1',1,'Retail Sale Id 1755',2001.60,0.00,0.00,2.78,191.82,'2023-02-07 14:25:10','',''),(1833,'1','310','1',1,'Retail Sale Id 1756',7200.00,0.00,0.00,10.00,690.00,'2023-02-07 14:27:51','',''),(1834,'1','310','1',1,'Retail Sale Id 1757',2498.40,0.00,0.00,3.47,239.43,'2023-02-07 14:30:09','',''),(1835,'1','310','1',1,'Retail Sale Id 1758',5040.00,0.00,0.00,7.00,483.00,'2023-02-07 14:40:51','',''),(1836,'1','310','1',1,'Retail Sale Id 1759',4320.00,0.00,0.00,6.00,414.00,'2023-02-07 14:50:30','',''),(1837,'1','310','1',1,'Retail Sale Id 1760',3600.00,0.00,0.00,5.00,345.00,'2023-02-07 14:54:36','',''),(1838,'1','310','1',1,'Retail Sale Id 1761',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 15:04:28','',''),(1839,'1','310','1',1,'Retail Sale Id 1761',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 15:04:28','',''),(1840,'1','310','1',1,'Retail Sale Id 1762',3002.40,0.00,0.00,4.17,287.73,'2023-02-07 15:06:14','',''),(1841,'1','310','1',1,'Retail Sale Id 1762',6998.40,0.00,0.00,9.72,670.68,'2023-02-07 15:06:14','',''),(1842,'1','310','1',1,'Retail Sale Id 1763',2160.00,0.00,0.00,3.00,207.00,'2023-02-07 15:09:02','',''),(1843,'1','310','1',1,'Retail Sale Id 1764',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 15:20:19','',''),(1844,'1','310','1',1,'Retail Sale Id 1765',4298.40,0.00,0.00,5.97,411.93,'2023-02-07 15:21:46','',''),(1845,'1','310','1',1,'Retail Sale Id 1767',4320.00,0.00,0.00,6.00,414.00,'2023-02-07 15:23:31','',''),(1846,'1','310','1',1,'Retail Sale Id 1768',2203.20,0.00,0.00,3.06,211.14,'2023-02-07 15:24:46','',''),(1847,'1','310','1',1,'Retail Sale Id 1769',2001.60,0.00,0.00,2.78,191.82,'2023-02-07 15:32:16','',''),(1848,'1','310','1',1,'Retail Sale Id 1770',7999.20,0.00,0.00,11.11,766.59,'2023-02-07 15:34:51','',''),(1849,'1','310','1',1,'Retail Sale Id 1771',4996.80,0.00,0.00,6.94,478.86,'2023-02-07 15:39:04','',''),(1850,'1','310','1',1,'Retail Sale Id 1772',8503.20,0.00,0.00,11.81,814.89,'2023-02-07 15:53:43','',''),(1851,'1','310','1',1,'Retail Sale Id 1775',70000.00,0.00,0.00,100.00,4900.00,'2023-02-07 16:18:40','',''),(1852,'1','310','1',1,'Retail Sale Id 1776',35000.00,0.00,0.00,50.00,2450.00,'2023-02-07 16:20:15','',''),(1853,'1','310','1',1,'Retail Sale Id 1777',4320.00,0.00,0.00,6.00,414.00,'2023-02-07 16:21:52','',''),(1854,'1','310','1',1,'Retail Sale Id 1778',8503.20,0.00,0.00,11.81,814.89,'2023-02-07 16:26:09','',''),(1855,'1','310','1',1,'Retail Sale Id 1779',1497.60,0.00,0.00,2.08,143.52,'2023-02-07 16:29:54','',''),(1856,'1','310','1',1,'Retail Sale Id 1781',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 16:37:16','',''),(1857,'1','310','1',1,'Retail Sale Id 1782',1000.80,0.00,0.00,1.39,95.91,'2023-02-07 16:38:06','',''),(1858,'1','310','1',1,'Retail Sale Id 1783',3600.00,0.00,0.00,5.00,345.00,'2023-02-07 16:45:21','',''),(1859,'1','310','1',1,'Retail Sale Id 1784',2160.00,0.00,0.00,3.00,207.00,'2023-02-07 16:52:42','',''),(1860,'1','310','1',1,'Retail Sale Id 1785',3700.80,0.00,0.00,5.14,354.66,'2023-02-07 16:56:29','',''),(1861,'1','310','1',1,'Return of Retail Sale Id 1785',0.00,3700.80,5.14,0.00,-354.66,'2023-02-07 16:58:44','',''),(1862,'1','310','1',1,'Retail Sale Id 1786',1497.60,0.00,0.00,2.08,143.52,'2023-02-07 16:59:24','',''),(1863,'1','310','1',1,'Retail Sale Id 1787',4500.00,0.00,0.00,6.25,431.25,'2023-02-07 17:04:21','',''),(1864,'1','310','1',1,'Retail Sale Id 1788',2160.00,0.00,0.00,3.00,207.00,'2023-02-07 17:06:52','',''),(1865,'1','310','1',1,'Retail Sale Id 1789',7920.00,0.00,0.00,11.00,759.00,'2023-02-07 17:11:50','',''),(1866,'1','310','1',1,'Retail Sale Id 1790',1000.80,0.00,0.00,1.39,95.91,'2023-02-07 17:13:15','',''),(1867,'1','310','1',1,'Retail Sale Id 1791',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 17:13:48','',''),(1868,'1','310','1',1,'Retail Sale Id 1792',1000.80,0.00,0.00,1.39,95.91,'2023-02-07 17:14:40','',''),(1869,'1','310','1',1,'Retail Sale Id 1793',5047.20,0.00,0.00,7.01,483.69,'2023-02-07 17:16:34','',''),(1870,'1','310','1',1,'Retail Sale Id 1794',4003.20,0.00,0.00,5.56,383.64,'2023-02-07 17:17:34','',''),(1871,'1','310','1',1,'Retail Sale Id 1795',4320.00,0.00,0.00,6.00,414.00,'2023-02-07 17:18:13','',''),(1872,'1','310','1',1,'Retail Sale Id 1796',2160.00,0.00,0.00,3.00,207.00,'2023-02-07 17:19:16','',''),(1873,'1','310','1',1,'Retail Sale Id 1797',2001.60,0.00,0.00,2.78,191.82,'2023-02-07 17:21:59','',''),(1874,'1','310','1',1,'Retail Sale Id 1797',2498.40,0.00,0.00,3.47,239.43,'2023-02-07 17:21:59','',''),(1875,'1','310','1',1,'Retail Sale Id 1798',2498.40,0.00,0.00,3.47,239.43,'2023-02-07 17:22:51','',''),(1876,'1','310','1',1,'Retail Sale Id 1799',1303.20,0.00,0.00,1.81,124.89,'2023-02-07 17:23:30','',''),(1877,'1','310','1',1,'Retail Sale Id 1800',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 17:24:44','',''),(1878,'1','310','1',1,'Retail Sale Id 1801',4320.00,0.00,0.00,6.00,414.00,'2023-02-07 17:28:48','',''),(1879,'1','310','1',1,'Retail Sale Id 1802',4320.00,0.00,0.00,6.00,414.00,'2023-02-07 17:30:48','',''),(1880,'1','310','1',1,'Retail Sale Id 1803',1000.80,0.00,0.00,1.39,95.91,'2023-02-07 17:34:43','',''),(1881,'1','310','1',1,'Retail Sale Id 1804',1000.80,0.00,0.00,1.39,95.91,'2023-02-07 17:36:01','',''),(1882,'1','310','1',1,'Return of Retail Sale Id 1797',0.00,2001.60,2.78,0.00,-191.82,'2023-02-07 17:38:50','',''),(1883,'1','310','1',1,'Return of Retail Sale Id 1797',0.00,2498.40,3.47,0.00,-239.43,'2023-02-07 17:38:50','',''),(1884,'1','310','1',1,'Retail Sale Id 1805',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 17:46:00','',''),(1885,'1','310','1',1,'Retail Sale Id 1806',3002.40,0.00,0.00,4.17,287.73,'2023-02-07 17:49:47','',''),(1886,'1','310','1',1,'Retail Sale Id 1807',3600.00,0.00,0.00,5.00,345.00,'2023-02-07 17:50:24','',''),(1887,'1','310','1',1,'Retail Sale Id 1808',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 17:51:55','',''),(1888,'1','310','1',1,'Retail Sale Id 1808',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 17:51:55','',''),(1889,'1','310','1',1,'Retail Sale Id 1809',4900.00,0.00,0.00,7.00,343.00,'2023-02-07 17:53:16','',''),(1890,'1','310','1',1,'Retail Sale Id 1810',2160.00,0.00,0.00,3.00,207.00,'2023-02-07 17:56:43','',''),(1891,'1','310','1',1,'Retail Sale Id 1811',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 18:00:11','',''),(1892,'1','310','1',1,'Retail Sale Id 1812',3600.00,0.00,0.00,5.00,345.00,'2023-02-07 18:00:50','',''),(1893,'1','310','1',1,'Retail Sale Id 1813',4900.00,0.00,0.00,7.00,343.00,'2023-02-07 18:01:44','',''),(1894,'1','310','1',1,'Retail Sale Id 1814',4320.00,0.00,0.00,6.00,414.00,'2023-02-07 18:06:16','',''),(1895,'1','310','1',1,'Retail Sale Id 1815',1497.60,0.00,0.00,2.08,143.52,'2023-02-07 18:19:01','',''),(1896,'1','310','1',1,'Retail Sale Id 1815',1497.60,0.00,0.00,2.08,143.52,'2023-02-07 18:19:01','',''),(1897,'1','310','1',1,'Retail Sale Id 1816',1000.80,0.00,0.00,1.39,95.91,'2023-02-07 18:20:39','',''),(1898,'1','310','1',1,'Retail Sale Id 1817',2001.60,0.00,0.00,2.78,191.82,'2023-02-07 18:26:26','',''),(1899,'1','310','1',1,'Retail Sale Id 1818',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 18:33:48','',''),(1900,'1','310','1',1,'Retail Sale Id 1819',4003.20,0.00,0.00,5.56,383.64,'2023-02-07 18:35:59','',''),(1901,'1','310','1',1,'Retail Sale Id 1820',2160.00,0.00,0.00,3.00,207.00,'2023-02-07 18:37:15','',''),(1902,'1','310','1',1,'Retail Sale Id 1821',1000.80,0.00,0.00,1.39,95.91,'2023-02-07 18:40:55','',''),(1903,'1','310','1',1,'Retail Sale Id 1822',4320.00,0.00,0.00,6.00,414.00,'2023-02-07 18:49:52','',''),(1904,'1','310','1',1,'Retail Sale Id 1823',9000.00,0.00,0.00,12.50,862.50,'2023-02-07 18:55:02','',''),(1905,'1','310','1',1,'Return of Retail Sale Id 1822',0.00,4320.00,6.00,0.00,-414.00,'2023-02-07 19:06:15','',''),(1906,'1','310','1',1,'Retail Sale Id 1824',907.20,0.00,0.00,1.26,86.94,'2023-02-07 19:09:27','',''),(1907,'1','310','1',1,'Return of Retail Sale Id 1813',0.00,4900.00,7.00,0.00,-343.00,'2023-02-07 19:11:48','',''),(1908,'1','310','1',1,'Retail Sale Id 1825',4949.00,0.00,0.00,7.07,346.43,'2023-02-07 19:13:02','',''),(1909,'1','310','1',1,'Retail Sale Id 1826',42000.00,0.00,0.00,60.00,2940.00,'2023-02-08 07:16:44','',''),(1910,'1','310','1',1,'Retail Sale Id 1827',4320.00,0.00,0.00,6.00,414.00,'2023-02-08 07:22:38','',''),(1911,'1','310','1',1,'Retail Sale Id 1828',22400.00,0.00,0.00,32.00,1568.00,'2023-02-08 07:35:07','',''),(1912,'1','310','1',1,'Retail Sale Id 1829',9000.00,0.00,0.00,12.50,862.50,'2023-02-08 07:50:22','',''),(1913,'1','310','1',1,'Retail Sale Id 1830',4320.00,0.00,0.00,6.00,414.00,'2023-02-08 07:57:35','',''),(1914,'1','310','1',1,'Retail Sale Id 1830',9000.00,0.00,0.00,12.50,862.50,'2023-02-08 07:57:35','',''),(1915,'1','310','1',1,'Retail Sale Id 1831',2160.00,0.00,0.00,3.00,207.00,'2023-02-08 08:01:09','',''),(1916,'1','310','1',1,'Retail Sale Id 1831',9000.00,0.00,0.00,12.50,862.50,'2023-02-08 08:01:09','',''),(1917,'1','310','1',1,'Retail Sale Id 1832',1202.40,0.00,0.00,1.67,115.23,'2023-02-08 08:03:53','',''),(1918,'1','310','1',1,'Retail Sale Id 1833',4298.40,0.00,0.00,5.97,411.93,'2023-02-08 08:08:26','',''),(1919,'1','310','1',1,'Retail Sale Id 1834',9000.00,0.00,0.00,12.50,862.50,'2023-02-08 08:12:35','',''),(1920,'1','310','1',1,'Retail Sale Id 1835',9000.00,0.00,0.00,12.50,862.50,'2023-02-08 08:13:41','',''),(1921,'1','310','1',1,'Retail Sale Id 1836',2001.60,0.00,0.00,2.78,191.82,'2023-02-08 08:42:13','',''),(1922,'1','310','1',1,'Retail Sale Id 1837',3960.00,0.00,0.00,5.50,379.50,'2023-02-08 08:53:32','',''),(1923,'1','310','1',1,'Retail Sale Id 1838',3002.40,0.00,0.00,4.17,287.73,'2023-02-08 08:54:50','',''),(1924,'1','310','1',1,'Retail Sale Id 1839',2001.60,0.00,0.00,2.78,191.82,'2023-02-08 08:56:10','',''),(1925,'1','310','1',1,'Retail Sale Id 1840',2160.00,0.00,0.00,3.00,207.00,'2023-02-08 09:10:47','',''),(1926,'1','310','1',1,'Retail Sale Id 1840',4320.00,0.00,0.00,6.00,414.00,'2023-02-08 09:10:47','',''),(1927,'1','310','1',1,'Retail Sale Id 1841',2001.60,0.00,0.00,2.78,191.82,'2023-02-08 09:25:26','',''),(1928,'1','310','1',1,'Retail Sale Id 1841',2001.60,0.00,0.00,2.78,191.82,'2023-02-08 09:25:26','',''),(1929,'1','310','1',1,'Retail Sale Id 1842',2203.20,0.00,0.00,3.06,211.14,'2023-02-08 09:28:10','',''),(1930,'1','310','1',1,'Retail Sale Id 1843',9000.00,0.00,0.00,12.50,862.50,'2023-02-08 09:38:50','',''),(1931,'1','310','1',1,'Retail Sale Id 1844',4003.20,0.00,0.00,5.56,383.64,'2023-02-08 09:39:52','',''),(1932,'1','310','1',1,'Retail Sale Id 1845',315000.00,0.00,0.00,450.00,22050.00,'2023-02-08 09:49:09','',''),(1933,'1','310','1',1,'Retail Sale Id 1846',4320.00,0.00,0.00,6.00,414.00,'2023-02-08 10:16:44','',''),(1934,'1','310','1',1,'Retail Sale Id 1847',9000.00,0.00,0.00,12.50,862.50,'2023-02-08 10:18:02','',''),(1935,'1','310','1',1,'Retail Sale Id 1848',1000.80,0.00,0.00,1.39,95.91,'2023-02-08 10:22:46','',''),(1936,'1','310','1',1,'Retail Sale Id 1849',7200.00,0.00,0.00,10.00,690.00,'2023-02-08 10:28:19','',''),(1937,'1','310','1',1,'Retail Sale Id 1850',4320.00,0.00,0.00,6.00,414.00,'2023-02-08 10:29:49','',''),(1938,'1','310','1',1,'Retail Sale Id 1851',4003.20,0.00,0.00,5.56,383.64,'2023-02-08 10:30:55','',''),(1939,'1','310','1',1,'Retail Sale Id 1852',1800.00,0.00,0.00,2.50,172.50,'2023-02-08 10:33:24','',''),(1940,'1','310','1',1,'Retail Sale Id 1853',8400.00,0.00,0.00,12.00,588.00,'2023-02-08 10:38:55','',''),(1941,'1','310','1',1,'Retail Sale Id 1854',2001.60,0.00,0.00,2.78,191.82,'2023-02-08 10:39:36','',''),(1942,'1','310','1',1,'Retail Sale Id 1855',3600.00,0.00,0.00,5.00,345.00,'2023-02-08 10:47:38','',''),(1943,'1','310','1',1,'Retail Sale Id 1856',77000.00,0.00,0.00,110.00,5390.00,'2023-02-08 10:54:19','',''),(1944,'1','310','1',1,'Retail Sale Id 1857',1000.80,0.00,0.00,1.39,95.91,'2023-02-08 10:58:56','',''),(1945,'1','310','1',1,'Retail Sale Id 1859',4320.00,0.00,0.00,6.00,414.00,'2023-02-08 11:04:52','',''),(1946,'1','310','1',1,'Retail Sale Id 1860',8400.00,0.00,0.00,12.00,588.00,'2023-02-08 11:07:32','',''),(1947,'1','310','1',1,'Retail Sale Id 1861',9000.00,0.00,0.00,12.50,862.50,'2023-02-08 11:08:41','',''),(1948,'1','310','1',1,'Retail Sale Id 1862',35000.00,0.00,0.00,50.00,2450.00,'2023-02-08 11:12:33','',''),(1949,'1','310','1',1,'Retail Sale Id 1863',4320.00,0.00,0.00,6.00,414.00,'2023-02-08 11:33:44','',''),(1950,'1','310','1',1,'Retail Sale Id 1865',2203.20,0.00,0.00,3.06,211.14,'2023-02-08 11:48:53','',''),(1951,'1','310','1',1,'Retail Sale Id 1866',4320.00,0.00,0.00,6.00,414.00,'2023-02-08 11:57:57','',''),(1952,'1','310','1',1,'Retail Sale Id 1867',3002.40,0.00,0.00,4.17,287.73,'2023-02-08 11:59:10','',''),(1953,'1','310','1',1,'Retail Sale Id 1868',3600.00,0.00,0.00,5.00,345.00,'2023-02-08 12:00:15','',''),(1954,'1','310','1',1,'Retail Sale Id 1869',154000.00,0.00,0.00,220.00,10780.00,'2023-02-08 12:07:57','',''),(1955,'1','310','1',1,'Retail Sale Id 1870',2001.60,0.00,0.00,2.78,191.82,'2023-02-08 12:08:39','',''),(1956,'1','310','1',1,'Retail Sale Id 1871',1000.80,0.00,0.00,1.39,95.91,'2023-02-08 12:10:25','',''),(1957,'1','310','1',1,'Retail Sale Id 1873',9000.00,0.00,0.00,12.50,862.50,'2023-02-08 12:18:06','',''),(1958,'1','310','1',1,'Retail Sale Id 1874',1000.80,0.00,0.00,1.39,95.91,'2023-02-08 12:21:21','',''),(1959,'1','310','1',1,'Retail Sale Id 1875',3600.00,0.00,0.00,5.00,345.00,'2023-02-08 12:29:53','',''),(1960,'1','310','1',1,'Retail Sale Id 1876',2160.00,0.00,0.00,3.00,207.00,'2023-02-08 12:35:37','',''),(1961,'1','310','1',1,'Retail Sale Id 1876',4320.00,0.00,0.00,6.00,414.00,'2023-02-08 12:35:37','',''),(1962,'1','310','1',1,'Retail Sale Id 1877',2001.60,0.00,0.00,2.78,191.82,'2023-02-08 12:43:40','',''),(1963,'1','310','1',1,'Retail Sale Id 1878',2160.00,0.00,0.00,3.00,207.00,'2023-02-08 12:44:38','',''),(1964,'1','310','1',1,'Retail Sale Id 1879',4298.40,0.00,0.00,5.97,411.93,'2023-02-08 12:45:46','',''),(1965,'1','310','1',1,'Retail Sale Id 1880',4320.00,0.00,0.00,6.00,414.00,'2023-02-08 12:46:52','',''),(1966,'1','310','1',1,'Retail Sale Id 1881',5997.60,0.00,0.00,8.33,574.77,'2023-02-08 12:48:00','',''),(1967,'1','310','1',1,'Retail Sale Id 1882',3002.40,0.00,0.00,4.17,287.73,'2023-02-08 12:52:05','',''),(1968,'1','310','1',1,'Retail Sale Id 1883',1000.80,0.00,0.00,1.39,95.91,'2023-02-08 12:55:17','',''),(1969,'1','310','1',1,'Retail Sale Id 1884',2397.60,0.00,0.00,3.33,229.77,'2023-02-08 13:00:20','',''),(1970,'1','310','1',1,'Retail Sale Id 1885',3600.00,0.00,0.00,5.00,345.00,'2023-02-08 13:13:27','',''),(1971,'1','310','1',1,'Retail Sale Id 1886',4003.20,0.00,0.00,5.56,383.64,'2023-02-08 13:24:19','',''),(1972,'1','310','1',1,'Retail Sale Id 1888',496.80,0.00,0.00,0.69,47.61,'2023-02-08 13:34:21','',''),(1973,'1','310','1',1,'Retail Sale Id 1889',42000.00,0.00,0.00,60.00,2940.00,'2023-02-08 13:39:50','',''),(1974,'1','310','1',1,'Retail Sale Id 1890',2001.60,0.00,0.00,2.78,191.82,'2023-02-08 13:54:51','',''),(1975,'1','310','1',1,'Retail Sale Id 1891',3600.00,0.00,0.00,5.00,345.00,'2023-02-08 13:57:46','',''),(1976,'1','310','1',1,'Retail Sale Id 1892',1000.80,0.00,0.00,1.39,95.91,'2023-02-08 14:01:19','',''),(1977,'1','310','1',1,'Retail Sale Id 1893',720.00,0.00,0.00,1.00,69.00,'2023-02-08 14:05:57','',''),(1978,'1','310','1',1,'Retail Sale Id 1894',720.00,0.00,0.00,1.00,69.00,'2023-02-08 14:06:55','',''),(1979,'1','310','1',1,'Retail Sale Id 1895',2001.60,0.00,0.00,2.78,191.82,'2023-02-08 14:27:08','',''),(1980,'1','310','1',1,'Retail Sale Id 1895',9000.00,0.00,0.00,12.50,862.50,'2023-02-08 14:27:08','',''),(1981,'1','310','1',1,'Retail Sale Id 1896',1000.80,0.00,0.00,1.39,95.91,'2023-02-08 14:34:10','',''),(1982,'1','310','1',1,'Retail Sale Id 1897',3002.40,0.00,0.00,4.17,287.73,'2023-02-08 14:35:26','',''),(1983,'1','310','1',1,'Retail Sale Id 1898',4320.00,0.00,0.00,6.00,414.00,'2023-02-08 14:54:46','',''),(1984,'1','310','1',1,'Retail Sale Id 1899',2880.00,0.00,0.00,4.00,276.00,'2023-02-08 14:58:12','',''),(1985,'1','310','1',1,'Retail Sale Id 1900',1440.00,0.00,0.00,2.00,138.00,'2023-02-08 15:10:07','',''),(1986,'1','310','1',1,'Retail Sale Id 1901',720.00,0.00,0.00,1.00,69.00,'2023-02-08 15:26:28','',''),(1987,'1','310','1',1,'Retail Sale Id 1902',9000.00,0.00,0.00,12.50,862.50,'2023-02-08 15:28:01','',''),(1988,'1','310','1',1,'Retail Sale Id 1903',4320.00,0.00,0.00,6.00,414.00,'2023-02-08 15:36:35','',''),(1989,'1','310','1',1,'Retail Sale Id 1905',2160.00,0.00,0.00,3.00,207.00,'2023-02-08 15:52:35','',''),(1990,'1','310','1',1,'Retail Sale Id 1906',1101.60,0.00,0.00,1.53,105.57,'2023-02-08 15:53:25','',''),(1991,'1','310','1',1,'Retail Sale Id 1907',4996.80,0.00,0.00,6.94,478.86,'2023-02-08 16:00:10','',''),(1992,'1','310','1',1,'Retail Sale Id 1908',9000.00,0.00,0.00,12.50,862.50,'2023-02-08 16:13:47','',''),(1993,'1','310','1',1,'Retail Sale Id 1911',2001.60,0.00,0.00,2.78,191.82,'2023-02-08 16:23:08','',''),(1994,'1','310','1',1,'Retail Sale Id 1912',9000.00,0.00,0.00,12.50,862.50,'2023-02-08 16:24:22','',''),(1995,'1','310','1',1,'Retail Sale Id 1913',2001.60,0.00,0.00,2.78,191.82,'2023-02-08 16:26:38','',''),(1996,'1','310','1',1,'Retail Sale Id 1914',2160.00,0.00,0.00,3.00,207.00,'2023-02-08 16:27:44','',''),(1997,'1','310','1',1,'Retail Sale Id 1915',4320.00,0.00,0.00,6.00,414.00,'2023-02-08 16:33:43','',''),(1998,'1','310','1',1,'Retail Sale Id 1916',1000.80,0.00,0.00,1.39,95.91,'2023-02-08 16:36:21','',''),(1999,'1','310','1',1,'Retail Sale Id 1918',5198.40,0.00,0.00,7.22,498.18,'2023-02-08 16:41:20','',''),(2000,'1','310','1',1,'Retail Sale Id 1919',2160.00,0.00,0.00,3.00,207.00,'2023-02-08 17:15:22','',''),(2001,'1','310','1',1,'Retail Sale Id 1920',2001.60,0.00,0.00,2.78,191.82,'2023-02-08 17:17:49','',''),(2002,'1','310','1',1,'Retail Sale Id 1921',1000.80,0.00,0.00,1.39,95.91,'2023-02-08 17:18:44','',''),(2003,'1','310','1',1,'Retail Sale Id 1922',4320.00,0.00,0.00,6.00,414.00,'2023-02-08 17:20:00','',''),(2004,'1','310','1',1,'Retail Sale Id 1923',2001.60,0.00,0.00,2.78,191.82,'2023-02-08 17:20:57','',''),(2005,'1','310','1',1,'Retail Sale Id 1924',1000.80,0.00,0.00,1.39,95.91,'2023-02-08 17:22:20','',''),(2006,'1','310','1',1,'Retail Sale Id 1925',4320.00,0.00,0.00,6.00,414.00,'2023-02-08 17:27:35','',''),(2007,'1','310','1',1,'Retail Sale Id 1926',2001.60,0.00,0.00,2.78,191.82,'2023-02-08 17:28:30','',''),(2008,'1','310','1',1,'Retail Sale Id 1927',698.40,0.00,0.00,0.97,66.93,'2023-02-08 17:29:56','',''),(2009,'1','310','1',1,'Retail Sale Id 1928',799.20,0.00,0.00,1.11,76.59,'2023-02-08 17:30:44','',''),(2010,'1','310','1',1,'Retail Sale Id 1929',2160.00,0.00,0.00,3.00,207.00,'2023-02-08 17:31:55','',''),(2011,'1','310','1',1,'Retail Sale Id 1930',4320.00,0.00,0.00,6.00,414.00,'2023-02-08 17:33:54','',''),(2012,'1','310','1',1,'Retail Sale Id 1931',2160.00,0.00,0.00,3.00,207.00,'2023-02-08 17:35:32','',''),(2013,'1','310','1',1,'Retail Sale Id 1932',35000.00,0.00,0.00,50.00,2450.00,'2023-02-08 17:37:22','',''),(2014,'1','310','1',1,'Retail Sale Id 1933',9000.00,0.00,0.00,12.50,862.50,'2023-02-08 17:39:41','',''),(2015,'1','310','1',1,'Retail Sale Id 1934',9002.00,0.00,0.00,12.86,630.14,'2023-02-08 17:56:30','',''),(2016,'1','310','1',1,'Retail Sale Id 1935',1000.80,0.00,0.00,1.39,95.91,'2023-02-08 18:00:51','',''),(2017,'1','310','1',1,'Retail Sale Id 1936',1000.80,0.00,0.00,1.39,95.91,'2023-02-08 18:02:33','',''),(2018,'1','310','1',1,'Retail Sale Id 1937',1000.80,0.00,0.00,1.39,95.91,'2023-02-08 18:10:51','',''),(2019,'1','310','1',1,'Retail Sale Id 1938',1000.80,0.00,0.00,1.39,95.91,'2023-02-08 18:11:47','',''),(2020,'1','310','1',1,'Retail Sale Id 1939',4320.00,0.00,0.00,6.00,414.00,'2023-02-08 18:15:25','',''),(2021,'1','310','1',1,'Retail Sale Id 1940',5040.00,0.00,0.00,7.00,483.00,'2023-02-08 18:16:21','',''),(2022,'1','310','1',1,'Retail Sale Id 1941',4320.00,0.00,0.00,6.00,414.00,'2023-02-08 18:18:48','',''),(2023,'1','310','1',1,'Retail Sale Id 1942',7200.00,0.00,0.00,10.00,690.00,'2023-02-08 18:21:38','',''),(2024,'1','310','1',1,'Retail Sale Id 1945',4003.20,0.00,0.00,5.56,383.64,'2023-02-08 18:48:06','',''),(2025,'1','310','1',1,'Retail Sale Id 1946',4996.80,0.00,0.00,6.94,478.86,'2023-02-08 18:51:17','',''),(2026,'1','310','1',1,'Return of Retail Sale Id 1942',0.00,7200.00,10.00,0.00,-690.00,'2023-02-08 19:29:39','',''),(2027,'1','310','1',1,'Retail Sale Id 1947',7200.00,0.00,0.00,10.00,690.00,'2023-02-08 19:30:25','',''),(2028,'1','310','1',1,'Retail Sale Id 1948',7999.20,0.00,0.00,11.11,766.59,'2023-02-08 19:31:53','',''),(2029,'1','310','1',1,'Retail Sale Id 1949',1000.80,0.00,0.00,1.39,95.91,'2023-02-08 19:33:34','',''),(2030,'1','310','1',1,'Retail Sale Id 1950',50.40,0.00,0.00,0.07,4.83,'2023-02-08 19:35:32','',''),(2031,'1','310','1',1,'Return of Retail Sale Id 1860',0.00,8400.00,12.00,0.00,-588.00,'2023-02-08 19:36:27','',''),(2032,'1','310','1',1,'Retail Sale Id 1951',8400.00,0.00,0.00,12.00,588.00,'2023-02-08 19:38:07','',''),(2033,'1','310','1',1,'Retail Sale Id 1952',1000.80,0.00,0.00,1.39,95.91,'2023-02-09 07:21:32','',''),(2034,'1','310','1',1,'Retail Sale Id 1953',496.80,0.00,0.00,0.69,47.61,'2023-02-09 07:38:55','',''),(2035,'1','310','1',1,'Retail Sale Id 1954',4320.00,0.00,0.00,6.00,414.00,'2023-02-09 07:46:19','',''),(2036,'1','310','1',1,'Retail Sale Id 1955',4320.00,0.00,0.00,6.00,414.00,'2023-02-09 07:56:01','',''),(2037,'1','310','1',1,'Retail Sale Id 1956',2001.60,0.00,0.00,2.78,191.82,'2023-02-09 08:05:51','',''),(2038,'1','310','1',1,'Retail Sale Id 1956',3002.40,0.00,0.00,4.17,287.73,'2023-02-09 08:05:51','',''),(2039,'1','310','1',1,'Retail Sale Id 1957',3499.20,0.00,0.00,4.86,335.34,'2023-02-09 08:08:24','',''),(2040,'1','310','1',1,'Retail Sale Id 1958',2160.00,0.00,0.00,3.00,207.00,'2023-02-09 08:23:18','',''),(2041,'1','310','1',1,'Retail Sale Id 1959',4003.20,0.00,0.00,5.56,383.64,'2023-02-09 08:37:24','',''),(2042,'1','310','1',1,'Retail Sale Id 1960',1000.80,0.00,0.00,1.39,95.91,'2023-02-09 08:40:38','',''),(2043,'1','310','1',1,'Retail Sale Id 1961',7200.00,0.00,0.00,10.00,690.00,'2023-02-09 08:42:46','',''),(2044,'1','310','1',1,'Retail Sale Id 1962',2160.00,0.00,0.00,3.00,207.00,'2023-02-09 08:56:31','',''),(2045,'1','310','1',1,'Retail Sale Id 1962',2160.00,0.00,0.00,3.00,207.00,'2023-02-09 08:56:31','',''),(2046,'1','310','1',1,'Retail Sale Id 1963',17500.00,0.00,0.00,25.00,1225.00,'2023-02-09 09:01:08','',''),(2047,'1','310','1',1,'Retail Sale Id 1964',8750.00,0.00,0.00,12.50,612.50,'2023-02-09 09:15:06','',''),(2048,'1','310','1',1,'Retail Sale Id 1965',2880.00,0.00,0.00,4.00,276.00,'2023-02-09 09:15:48','',''),(2049,'1','310','1',1,'Retail Sale Id 1966',2001.60,0.00,0.00,2.78,191.82,'2023-02-09 09:32:59','',''),(2050,'1','310','1',1,'Retail Sale Id 1967',9000.00,0.00,0.00,12.50,862.50,'2023-02-09 09:36:33','',''),(2051,'1','310','1',1,'Retail Sale Id 1968',4320.00,0.00,0.00,6.00,414.00,'2023-02-09 09:37:55','',''),(2052,'1','310','1',1,'Retail Sale Id 1969',1000.80,0.00,0.00,1.39,95.91,'2023-02-09 09:42:39','',''),(2053,'1','310','1',1,'Retail Sale Id 1970',720.00,0.00,0.00,1.00,69.00,'2023-02-09 09:43:42','',''),(2054,'1','310','1',1,'Retail Sale Id 1971',9000.00,0.00,0.00,12.50,862.50,'2023-02-09 09:44:56','',''),(2055,'1','310','1',1,'Retail Sale Id 1972',3002.40,0.00,0.00,4.17,287.73,'2023-02-09 09:55:15','',''),(2056,'1','310','1',1,'Retail Sale Id 1973',3600.00,0.00,0.00,5.00,345.00,'2023-02-09 09:58:12','',''),(2057,'1','310','1',1,'Retail Sale Id 1974',4996.80,0.00,0.00,6.94,478.86,'2023-02-09 10:04:17','',''),(2058,'1','310','1',1,'Retail Sale Id 1975',1000.80,0.00,0.00,1.39,95.91,'2023-02-09 10:19:44','',''),(2059,'1','310','1',1,'Retail Sale Id 1976',1497.60,0.00,0.00,2.08,143.52,'2023-02-09 10:22:30','',''),(2060,'1','310','1',1,'Retail Sale Id 1977',1000.80,0.00,0.00,1.39,95.91,'2023-02-09 10:23:37','',''),(2061,'1','310','1',1,'Retail Sale Id 1978',73500.00,0.00,0.00,105.00,5145.00,'2023-02-09 10:49:59','',''),(2062,'1','310','1',1,'Retail Sale Id 1979',2001.60,0.00,0.00,2.78,191.82,'2023-02-09 10:52:00','',''),(2063,'1','310','1',1,'Retail Sale Id 1980',1000.80,0.00,0.00,1.39,95.91,'2023-02-09 10:53:09','',''),(2064,'1','310','1',1,'Retail Sale Id 1981',2160.00,0.00,0.00,3.00,207.00,'2023-02-09 11:01:04','',''),(2065,'1','310','1',1,'Retail Sale Id 1982',70000.00,0.00,0.00,100.00,4900.00,'2023-02-09 11:04:51','',''),(2066,'1','310','1',1,'Retail Sale Id 1983',2160.00,0.00,0.00,3.00,207.00,'2023-02-09 11:09:47','',''),(2067,'1','310','1',1,'Retail Sale Id 1984',2001.60,0.00,0.00,2.78,191.82,'2023-02-09 11:10:52','',''),(2068,'1','310','1',1,'Retail Sale Id 1985',2160.00,0.00,0.00,3.00,207.00,'2023-02-09 11:13:20','',''),(2069,'1','310','1',1,'Retail Sale Id 1986',3002.40,0.00,0.00,4.17,287.73,'2023-02-09 11:15:00','',''),(2070,'1','310','1',1,'Retail Sale Id 1987',70000.00,0.00,0.00,100.00,4900.00,'2023-02-09 11:29:46','',''),(2071,'1','310','1',1,'Retail Sale Id 1988',35000.00,0.00,0.00,50.00,2450.00,'2023-02-09 11:30:50','',''),(2072,'1','310','1',1,'Retail Sale Id 1989',70000.00,0.00,0.00,100.00,4900.00,'2023-02-09 11:38:49','',''),(2073,'1','310','1',1,'Retail Sale Id 1990',1497.60,0.00,0.00,2.08,143.52,'2023-02-09 11:51:11','',''),(2074,'1','310','1',1,'Retail Sale Id 1990',1497.60,0.00,0.00,2.08,143.52,'2023-02-09 11:51:11','',''),(2075,'1','310','1',1,'Retail Sale Id 1991',1497.60,0.00,0.00,2.08,143.52,'2023-02-09 11:58:58','',''),(2076,'1','310','1',1,'Retail Sale Id 1992',1497.60,0.00,0.00,2.08,143.52,'2023-02-09 12:00:15','',''),(2077,'1','310','1',1,'Retail Sale Id 1993',2160.00,0.00,0.00,3.00,207.00,'2023-02-09 12:05:15','',''),(2078,'1','310','1',1,'Retail Sale Id 1994',2160.00,0.00,0.00,3.00,207.00,'2023-02-09 12:07:26','',''),(2079,'1','310','1',1,'Retail Sale Id 1994',9000.00,0.00,0.00,12.50,862.50,'2023-02-09 12:07:26','',''),(2080,'1','310','1',1,'Retail Sale Id 1995',2397.60,0.00,0.00,3.33,229.77,'2023-02-09 12:11:51','',''),(2081,'1','310','1',1,'Retail Sale Id 1996',2160.00,0.00,0.00,3.00,207.00,'2023-02-09 12:16:06','',''),(2082,'1','310','1',1,'Retail Sale Id 1997',4320.00,0.00,0.00,6.00,414.00,'2023-02-09 12:21:15','',''),(2083,'1','310','1',1,'Retail Sale Id 1998',4003.20,0.00,0.00,5.56,383.64,'2023-02-09 12:47:49','',''),(2084,'1','310','1',1,'Retail Sale Id 1999',3002.40,0.00,0.00,4.17,287.73,'2023-02-09 12:51:56','',''),(2085,'1','310','1',1,'Retail Sale Id 2000',4500.00,0.00,0.00,6.25,431.25,'2023-02-09 12:56:24','',''),(2086,'1','310','1',1,'Retail Sale Id 2001',3002.40,0.00,0.00,4.17,287.73,'2023-02-09 13:01:00','',''),(2087,'1','310','1',1,'Retail Sale Id 2002',37800.00,0.00,0.00,54.00,2646.00,'2023-02-09 13:03:59','',''),(2088,'1','310','1',1,'Retail Sale Id 2003',4320.00,0.00,0.00,6.00,414.00,'2023-02-09 13:24:17','',''),(2089,'1','310','1',1,'Retail Sale Id 2004',4320.00,0.00,0.00,6.00,414.00,'2023-02-09 13:25:24','',''),(2090,'1','310','1',1,'Retail Sale Id 2005',2160.00,0.00,0.00,3.00,207.00,'2023-02-09 13:30:03','',''),(2091,'1','310','1',1,'Retail Sale Id 2006',35000.00,0.00,0.00,50.00,2450.00,'2023-02-09 13:38:52','',''),(2092,'1','310','1',1,'Retail Sale Id 2007',4320.00,0.00,0.00,6.00,414.00,'2023-02-09 13:40:07','',''),(2093,'1','310','1',1,'Retail Sale Id 2008',2001.60,0.00,0.00,2.78,191.82,'2023-02-09 13:45:41','',''),(2094,'1','310','1',1,'Retail Sale Id 2009',7200.00,0.00,0.00,10.00,690.00,'2023-02-09 13:51:52','',''),(2095,'1','310','1',1,'Retail Sale Id 2010',1000.80,0.00,0.00,1.39,95.91,'2023-02-09 14:03:33','',''),(2096,'1','310','1',1,'Retail Sale Id 2011',1000.80,0.00,0.00,1.39,95.91,'2023-02-09 14:09:47','',''),(2097,'1','310','1',1,'Retail Sale Id 2012',2001.60,0.00,0.00,2.78,191.82,'2023-02-09 14:18:20','',''),(2098,'1','310','1',1,'Retail Sale Id 2013',2203.20,0.00,0.00,3.06,211.14,'2023-02-09 14:25:57','',''),(2099,'1','310','1',1,'Retail Sale Id 2014',1000.80,0.00,0.00,1.39,95.91,'2023-02-09 14:30:36','',''),(2100,'1','310','1',1,'Retail Sale Id 2015',2160.00,0.00,0.00,3.00,207.00,'2023-02-09 14:41:30','',''),(2101,'1','310','1',1,'Retail Sale Id 2017',4320.00,0.00,0.00,6.00,414.00,'2023-02-09 14:46:31','',''),(2102,'1','310','1',1,'Retail Sale Id 2018',2160.00,0.00,0.00,3.00,207.00,'2023-02-09 14:48:37','',''),(2103,'1','310','1',1,'Retail Sale Id 2019',720.00,0.00,0.00,1.00,69.00,'2023-02-09 14:49:30','',''),(2104,'1','310','1',1,'Retail Sale Id 2020',4320.00,0.00,0.00,6.00,414.00,'2023-02-09 14:50:15','',''),(2105,'1','310','1',1,'Retail Sale Id 2021',6480.00,0.00,0.00,9.00,621.00,'2023-02-09 14:51:38','',''),(2106,'1','310','1',1,'Retail Sale Id 2021',9000.00,0.00,0.00,12.50,862.50,'2023-02-09 14:51:38','',''),(2107,'1','310','1',1,'Retail Sale Id 2022',1497.60,0.00,0.00,2.08,143.52,'2023-02-09 14:52:26','',''),(2108,'1','310','1',1,'Retail Sale Id 2023',7200.00,0.00,0.00,10.00,690.00,'2023-02-09 14:54:32','',''),(2109,'1','310','1',1,'Retail Sale Id 2024',4320.00,0.00,0.00,6.00,414.00,'2023-02-09 14:56:27','',''),(2110,'1','310','1',1,'Retail Sale Id 2025',2498.40,0.00,0.00,3.47,239.43,'2023-02-09 15:03:53','',''),(2111,'1','310','1',1,'Retail Sale Id 2026',110600.00,0.00,0.00,158.00,7742.00,'2023-02-09 15:23:42','',''),(2112,'1','310','1',1,'Retail Sale Id 2062',4003.20,0.00,0.00,5.56,383.64,'2023-02-09 15:24:59','',''),(2113,'1','310','1',1,'Retail Sale Id 2063',2160.00,0.00,0.00,3.00,207.00,'2023-02-09 15:33:27','',''),(2114,'1','310','1',1,'Retail Sale Id 2064',3002.40,0.00,0.00,4.17,287.73,'2023-02-09 15:34:31','',''),(2115,'1','310','1',1,'Retail Sale Id 2065',720.00,0.00,0.00,1.00,69.00,'2023-02-09 15:36:12','',''),(2116,'1','310','1',1,'Retail Sale Id 2066',4003.20,0.00,0.00,5.56,383.64,'2023-02-09 15:43:39','',''),(2117,'1','310','1',1,'Retail Sale Id 2068',70000.00,0.00,0.00,100.00,4900.00,'2023-02-09 15:47:58','',''),(2118,'1','310','1',1,'Retail Sale Id 2069',70000.00,0.00,0.00,100.00,4900.00,'2023-02-09 15:49:10','',''),(2119,'1','310','1',1,'Retail Sale Id 2070',35000.00,0.00,0.00,50.00,2450.00,'2023-02-09 15:50:07','',''),(2120,'1','310','1',1,'Retail Sale Id 2071',4320.00,0.00,0.00,6.00,414.00,'2023-02-09 15:50:54','',''),(2121,'1','310','1',1,'Retail Sale Id 2072',2160.00,0.00,0.00,3.00,207.00,'2023-02-09 15:51:54','',''),(2122,'1','310','1',1,'Retail Sale Id 2073',1497.60,0.00,0.00,2.08,143.52,'2023-02-09 15:53:02','',''),(2123,'1','310','1',1,'Retail Sale Id 2074',2001.60,0.00,0.00,2.78,191.82,'2023-02-09 15:56:09','',''),(2124,'1','310','1',1,'Retail Sale Id 2075',1497.60,0.00,0.00,2.08,143.52,'2023-02-09 15:59:36','',''),(2125,'1','310','1',1,'Retail Sale Id 2076',9000.00,0.00,0.00,12.50,862.50,'2023-02-09 16:06:00','',''),(2126,'1','310','1',1,'Retail Sale Id 2077',5040.00,0.00,0.00,7.00,483.00,'2023-02-09 16:08:32','',''),(2127,'1','310','1',1,'Retail Sale Id 2078',2160.00,0.00,0.00,3.00,207.00,'2023-02-09 16:10:21','',''),(2128,'1','310','1',1,'Retail Sale Id 2079',3002.40,0.00,0.00,4.17,287.73,'2023-02-09 16:12:31','',''),(2129,'1','310','1',1,'Retail Sale Id 2080',2160.00,0.00,0.00,3.00,207.00,'2023-02-09 16:28:46','',''),(2130,'1','310','1',1,'Retail Sale Id 2080',2160.00,0.00,0.00,3.00,207.00,'2023-02-09 16:28:46','',''),(2131,'1','310','1',1,'Retail Sale Id 2081',4320.00,0.00,0.00,6.00,414.00,'2023-02-09 16:31:53','',''),(2132,'1','310','1',1,'Retail Sale Id 2082',2160.00,0.00,0.00,3.00,207.00,'2023-02-09 16:33:56','',''),(2133,'1','310','1',1,'Retail Sale Id 2083',3600.00,0.00,0.00,5.00,345.00,'2023-02-09 16:38:57','',''),(2134,'1','310','1',1,'Retail Sale Id 2084',4320.00,0.00,0.00,6.00,414.00,'2023-02-09 16:43:49','',''),(2135,'1','310','1',1,'Retail Sale Id 2085',4320.00,0.00,0.00,6.00,414.00,'2023-02-09 16:46:25','',''),(2136,'1','310','1',1,'Retail Sale Id 2086',2001.60,0.00,0.00,2.78,191.82,'2023-02-09 16:47:09','',''),(2137,'1','310','1',1,'Retail Sale Id 2087',1202.40,0.00,0.00,1.67,115.23,'2023-02-09 16:47:54','',''),(2138,'1','310','1',1,'Retail Sale Id 2088',2001.60,0.00,0.00,2.78,191.82,'2023-02-09 16:49:26','',''),(2139,'1','310','1',1,'Retail Sale Id 2089',4320.00,0.00,0.00,6.00,414.00,'2023-02-09 16:51:14','',''),(2140,'1','310','1',1,'Retail Sale Id 2090',9000.00,0.00,0.00,12.50,862.50,'2023-02-09 16:54:28','',''),(2141,'1','310','1',1,'Retail Sale Id 2091',18000.00,0.00,0.00,25.00,1725.00,'2023-02-09 17:00:39','',''),(2142,'1','310','1',1,'Retail Sale Id 2092',3600.00,0.00,0.00,5.00,345.00,'2023-02-09 17:08:14','',''),(2143,'1','310','1',1,'Retail Sale Id 2093',4320.00,0.00,0.00,6.00,414.00,'2023-02-09 17:19:25','',''),(2144,'1','310','1',1,'Retail Sale Id 2094',4320.00,0.00,0.00,6.00,414.00,'2023-02-09 17:20:39','',''),(2145,'1','310','1',1,'Retail Sale Id 2095',1440.00,0.00,0.00,2.00,138.00,'2023-02-09 17:38:42','',''),(2146,'1','310','1',1,'Retail Sale Id 2096',4320.00,0.00,0.00,6.00,414.00,'2023-02-09 17:40:56','',''),(2147,'1','310','1',1,'Retail Sale Id 2097',9000.00,0.00,0.00,12.50,862.50,'2023-02-09 17:43:17','',''),(2148,'1','310','1',1,'Retail Sale Id 2099',3002.40,0.00,0.00,4.17,287.73,'2023-02-09 17:49:38','',''),(2149,'1','310','1',1,'Retail Sale Id 2100',1000.80,0.00,0.00,1.39,95.91,'2023-02-09 17:51:43','',''),(2150,'1','310','1',1,'Retail Sale Id 2101',1497.60,0.00,0.00,2.08,143.52,'2023-02-09 17:53:08','',''),(2151,'1','310','1',1,'Retail Sale Id 2102',5760.00,0.00,0.00,8.00,552.00,'2023-02-09 17:54:41','',''),(2152,'1','310','1',1,'Retail Sale Id 2103',1101.60,0.00,0.00,1.53,105.57,'2023-02-09 17:55:53','',''),(2153,'1','310','1',1,'Retail Sale Id 2104',9000.00,0.00,0.00,12.50,862.50,'2023-02-09 17:57:59','',''),(2154,'1','310','1',1,'Retail Sale Id 2105',35000.00,0.00,0.00,50.00,2450.00,'2023-02-09 17:59:54','',''),(2155,'1','310','1',1,'Retail Sale Id 2106',1000.80,0.00,0.00,1.39,95.91,'2023-02-09 18:01:27','',''),(2156,'1','310','1',1,'Retail Sale Id 2107',4996.80,0.00,0.00,6.94,478.86,'2023-02-09 18:02:32','',''),(2157,'1','310','1',1,'Retail Sale Id 2108',4320.00,0.00,0.00,6.00,414.00,'2023-02-09 18:03:38','',''),(2158,'1','310','1',1,'Retail Sale Id 2109',3600.00,0.00,0.00,5.00,345.00,'2023-02-09 18:05:14','',''),(2159,'1','310','1',1,'Retail Sale Id 2110',3240.00,0.00,0.00,4.50,310.50,'2023-02-09 18:07:04','',''),(2160,'1','310','1',1,'Retail Sale Id 2111',2203.20,0.00,0.00,3.06,211.14,'2023-02-09 18:08:50','',''),(2161,'1','310','1',1,'Retail Sale Id 2112',3600.00,0.00,0.00,5.00,345.00,'2023-02-09 18:11:49','',''),(2162,'1','310','1',1,'Retail Sale Id 2113',3002.40,0.00,0.00,4.17,287.73,'2023-02-09 18:15:18','',''),(2163,'1','310','1',1,'Retail Sale Id 2114',45500.00,0.00,0.00,65.00,3185.00,'2023-02-09 18:22:13','',''),(2164,'1','310','1',1,'Retail Sale Id 2115',2203.20,0.00,0.00,3.06,211.14,'2023-02-09 18:28:21','',''),(2165,'1','310','1',1,'Retail Sale Id 2116',2001.60,0.00,0.00,2.78,191.82,'2023-02-09 18:29:26','',''),(2166,'1','310','1',1,'Retail Sale Id 2117',2498.40,0.00,0.00,3.47,239.43,'2023-02-09 18:34:45','',''),(2167,'1','310','1',1,'Retail Sale Id 2118',3002.40,0.00,0.00,4.17,287.73,'2023-02-09 18:36:13','',''),(2168,'1','310','1',1,'Retail Sale Id 2119',2160.00,0.00,0.00,3.00,207.00,'2023-02-09 18:37:31','',''),(2169,'1','310','1',1,'Retail Sale Id 2120',3600.00,0.00,0.00,5.00,345.00,'2023-02-09 18:39:12','',''),(2170,'1','310','1',1,'Retail Sale Id 2121',1440.00,0.00,0.00,2.00,138.00,'2023-02-09 19:02:57','',''),(2171,'1','310','1',1,'Retail Sale Id 2122',36.00,0.00,0.00,0.05,3.45,'2023-02-09 19:33:47','',''),(2172,'1','310','1',1,'Retail Sale Id 2123',1497.60,0.00,0.00,2.08,143.52,'2023-02-10 07:46:16','',''),(2173,'1','310','1',1,'Retail Sale Id 2124',4320.00,0.00,0.00,6.00,414.00,'2023-02-10 07:47:31','',''),(2174,'1','310','1',1,'Retail Sale Id 2125',4996.80,0.00,0.00,6.94,478.86,'2023-02-10 08:00:24','',''),(2175,'1','310','1',1,'Retail Sale Id 2126',1000.80,0.00,0.00,1.39,95.91,'2023-02-10 08:01:37','',''),(2176,'1','310','1',1,'Retail Sale Id 2127',4003.20,0.00,0.00,5.56,383.64,'2023-02-10 08:05:36','',''),(2177,'1','310','1',1,'Retail Sale Id 2128',70000.00,0.00,0.00,100.00,4900.00,'2023-02-10 08:14:15','',''),(2178,'1','310','1',1,'Retail Sale Id 2129',4320.00,0.00,0.00,6.00,414.00,'2023-02-10 08:24:42','',''),(2179,'1','310','1',1,'Retail Sale Id 2130',1303.20,0.00,0.00,1.81,124.89,'2023-02-10 08:27:57','',''),(2180,'1','310','1',1,'Retail Sale Id 2131',3002.40,0.00,0.00,4.17,287.73,'2023-02-10 08:32:02','',''),(2181,'1','310','1',1,'Retail Sale Id 2132',1000.80,0.00,0.00,1.39,95.91,'2023-02-10 08:33:38','',''),(2182,'1','310','1',1,'Retail Sale Id 2133',2001.60,0.00,0.00,2.78,191.82,'2023-02-10 08:35:31','',''),(2183,'1','310','1',1,'Retail Sale Id 2134',42000.00,0.00,0.00,60.00,2940.00,'2023-02-10 08:37:18','',''),(2184,'1','310','1',1,'Retail Sale Id 2135',2160.00,0.00,0.00,3.00,207.00,'2023-02-10 08:39:05','',''),(2185,'1','310','1',1,'Retail Sale Id 2136',3600.00,0.00,0.00,5.00,345.00,'2023-02-10 08:40:30','',''),(2186,'1','310','1',1,'Retail Sale Id 2137',2498.40,0.00,0.00,3.47,239.43,'2023-02-10 08:43:45','',''),(2187,'1','310','1',1,'Retail Sale Id 2138',4320.00,0.00,0.00,6.00,414.00,'2023-02-10 08:46:03','',''),(2188,'1','310','1',1,'Retail Sale Id 2139',9000.00,0.00,0.00,12.50,862.50,'2023-02-10 08:47:56','',''),(2189,'1','310','1',1,'Retail Sale Id 2139',9000.00,0.00,0.00,12.50,862.50,'2023-02-10 08:47:57','',''),(2190,'1','310','1',1,'Retail Sale Id 2140',3002.40,0.00,0.00,4.17,287.73,'2023-02-10 08:56:07','',''),(2191,'1','310','1',1,'Return of Retail Sale Id 2140',0.00,3002.40,4.17,0.00,-287.73,'2023-02-10 08:57:27','',''),(2192,'1','310','1',1,'Return of Retail Sale Id 2134',0.00,42000.00,60.00,0.00,-2940.00,'2023-02-10 08:57:59','',''),(2193,'1','310','1',1,'Retail Sale Id 2141',3002.40,0.00,0.00,4.17,287.73,'2023-02-10 08:58:49','',''),(2194,'1','310','1',1,'Retail Sale Id 2143',4320.00,0.00,0.00,6.00,414.00,'2023-02-10 09:01:51','',''),(2195,'1','310','1',1,'Retail Sale Id 2143',9000.00,0.00,0.00,12.50,862.50,'2023-02-10 09:01:51','',''),(2196,'1','310','1',1,'Retail Sale Id 2145',2160.00,0.00,0.00,3.00,207.00,'2023-02-10 09:02:53','',''),(2197,'1','310','1',1,'Retail Sale Id 2146',42000.00,0.00,0.00,60.00,2940.00,'2023-02-10 09:10:12','',''),(2198,'1','310','1',1,'Retail Sale Id 2147',799.20,0.00,0.00,1.11,76.59,'2023-02-10 09:30:12','',''),(2199,'1','310','1',1,'Retail Sale Id 2148',1440.00,0.00,0.00,2.00,138.00,'2023-02-10 09:31:17','',''),(2200,'1','310','1',1,'Retail Sale Id 2150',2880.00,0.00,0.00,4.00,276.00,'2023-02-10 09:37:15','',''),(2201,'1','310','1',1,'Retail Sale Id 2151',3600.00,0.00,0.00,5.00,345.00,'2023-02-10 09:39:54','',''),(2202,'1','310','1',1,'Retail Sale Id 2152',2160.00,0.00,0.00,3.00,207.00,'2023-02-10 09:43:30','',''),(2203,'1','310','1',1,'Retail Sale Id 2152',9000.00,0.00,0.00,12.50,862.50,'2023-02-10 09:43:30','',''),(2204,'1','310','1',1,'Retail Sale Id 2153',4320.00,0.00,0.00,6.00,414.00,'2023-02-10 10:11:19','',''),(2205,'1','310','1',1,'Retail Sale Id 2154',9000.00,0.00,0.00,12.50,862.50,'2023-02-10 10:13:26','',''),(2206,'1','310','1',1,'Retail Sale Id 2155',5997.60,0.00,0.00,8.33,574.77,'2023-02-10 10:29:51','',''),(2207,'1','310','1',1,'Retail Sale Id 2156',3499.20,0.00,0.00,4.86,335.34,'2023-02-10 10:35:53','',''),(2208,'1','310','1',1,'Retail Sale Id 2157',3002.40,0.00,0.00,4.17,287.73,'2023-02-10 10:39:21','',''),(2209,'1','310','1',1,'Retail Sale Id 2158',2498.40,0.00,0.00,3.47,239.43,'2023-02-10 10:53:24','',''),(2210,'1','310','1',1,'Retail Sale Id 2159',70000.00,0.00,0.00,100.00,4900.00,'2023-02-10 11:02:32','',''),(2211,'1','310','1',1,'Retail Sale Id 2160',9000.00,0.00,0.00,12.50,862.50,'2023-02-10 11:10:30','',''),(2212,'1','310','1',1,'Retail Sale Id 2161',43750.00,0.00,0.00,62.50,3062.50,'2023-02-10 11:11:43','',''),(2213,'1','310','1',1,'Retail Sale Id 2162',3600.00,0.00,0.00,5.00,345.00,'2023-02-10 11:14:55','',''),(2214,'1','310','1',1,'Retail Sale Id 2163',2160.00,0.00,0.00,3.00,207.00,'2023-02-10 11:30:07','',''),(2215,'1','310','1',1,'Retail Sale Id 2163',2160.00,0.00,0.00,3.00,207.00,'2023-02-10 11:30:07','',''),(2216,'1','310','1',1,'Retail Sale Id 2164',1497.60,0.00,0.00,2.08,143.52,'2023-02-10 11:39:49','',''),(2217,'1','310','1',1,'Retail Sale Id 2165',35000.00,0.00,0.00,50.00,2450.00,'2023-02-10 11:40:20','',''),(2218,'1','310','1',1,'Retail Sale Id 2166',4320.00,0.00,0.00,6.00,414.00,'2023-02-10 11:44:36','',''),(2219,'1','310','1',1,'Retail Sale Id 2167',1000.80,0.00,0.00,1.39,95.91,'2023-02-10 11:46:06','',''),(2220,'1','310','1',1,'Retail Sale Id 2168',1497.60,0.00,0.00,2.08,143.52,'2023-02-10 11:51:07','',''),(2221,'1','310','1',1,'Retail Sale Id 2169',2498.40,0.00,0.00,3.47,239.43,'2023-02-10 11:58:44','',''),(2222,'1','310','1',1,'Retail Sale Id 2170',7200.00,0.00,0.00,10.00,690.00,'2023-02-10 12:09:53','',''),(2223,'1','310','1',1,'Retail Sale Id 2171',2001.60,0.00,0.00,2.78,191.82,'2023-02-10 12:11:02','',''),(2224,'1','310','1',1,'Retail Sale Id 2172',9000.00,0.00,0.00,12.50,862.50,'2023-02-10 12:12:34','',''),(2225,'1','310','1',1,'Retail Sale Id 2173',1800.00,0.00,0.00,2.50,172.50,'2023-02-10 12:28:57','',''),(2226,'1','310','1',1,'Retail Sale Id 2174',4320.00,0.00,0.00,6.00,414.00,'2023-02-10 12:30:26','',''),(2227,'1','310','1',1,'Retail Sale Id 2176',3398.40,0.00,0.00,4.72,325.68,'2023-02-10 12:52:40','',''),(2228,'1','310','1',1,'Retail Sale Id 2177',2498.40,0.00,0.00,3.47,239.43,'2023-02-10 13:01:10','',''),(2229,'1','310','1',1,'Retail Sale Id 2178',2203.20,0.00,0.00,3.06,211.14,'2023-02-10 13:03:07','',''),(2230,'1','310','1',1,'Retail Sale Id 2179',403.20,0.00,0.00,0.56,38.64,'2023-02-10 13:16:08','',''),(2231,'1','310','1',1,'Retail Sale Id 2179',496.80,0.00,0.00,0.69,47.61,'2023-02-10 13:16:09','',''),(2232,'1','310','1',1,'Retail Sale Id 2180',2100.00,0.00,0.00,3.00,147.00,'2023-02-10 13:31:02','',''),(2233,'1','310','1',1,'Retail Sale Id 2181',2100.00,0.00,0.00,3.00,147.00,'2023-02-10 13:38:04','',''),(2234,'1','310','1',1,'Return of Retail Sale Id 2180',0.00,2100.00,3.00,0.00,-147.00,'2023-02-10 13:39:52','',''),(2235,'1','310','1',1,'Retail Sale Id 2182',2498.40,0.00,0.00,3.47,239.43,'2023-02-10 13:49:43','',''),(2236,'1','310','1',1,'Retail Sale Id 2183',3600.00,0.00,0.00,5.00,345.00,'2023-02-10 14:09:19','',''),(2237,'1','310','1',1,'Retail Sale Id 2184',2160.00,0.00,0.00,3.00,207.00,'2023-02-10 14:18:17','',''),(2238,'1','310','1',1,'Retail Sale Id 2185',9000.00,0.00,0.00,12.50,862.50,'2023-02-10 14:35:55','',''),(2239,'1','310','1',1,'Retail Sale Id 2186',1440.00,0.00,0.00,2.00,138.00,'2023-02-10 14:42:12','',''),(2240,'1','310','1',1,'Retail Sale Id 2187',4320.00,0.00,0.00,6.00,414.00,'2023-02-10 14:58:42','',''),(2241,'1','310','1',1,'Retail Sale Id 2188',3002.40,0.00,0.00,4.17,287.73,'2023-02-10 15:00:09','',''),(2242,'1','310','1',1,'Retail Sale Id 2189',4996.80,0.00,0.00,6.94,478.86,'2023-02-10 15:01:42','',''),(2243,'1','310','1',1,'Retail Sale Id 2190',2160.00,0.00,0.00,3.00,207.00,'2023-02-10 15:09:37','',''),(2244,'1','310','1',1,'Retail Sale Id 2190',9000.00,0.00,0.00,12.50,862.50,'2023-02-10 15:09:37','',''),(2245,'1','310','1',1,'Retail Sale Id 2191',2001.60,0.00,0.00,2.78,191.82,'2023-02-10 15:22:55','',''),(2246,'1','310','1',1,'Retail Sale Id 2192',9000.00,0.00,0.00,12.50,862.50,'2023-02-10 15:34:07','',''),(2247,'1','310','1',1,'Retail Sale Id 2193',2160.00,0.00,0.00,3.00,207.00,'2023-02-10 15:44:45','',''),(2248,'1','310','1',1,'Retail Sale Id 2194',35000.00,0.00,0.00,50.00,2450.00,'2023-02-10 15:52:16','',''),(2249,'1','310','1',1,'Retail Sale Id 2195',4996.80,0.00,0.00,6.94,478.86,'2023-02-10 15:53:41','',''),(2250,'1','310','1',1,'Retail Sale Id 2196',6998.40,0.00,0.00,9.72,670.68,'2023-02-10 15:54:43','',''),(2251,'1','310','1',1,'Retail Sale Id 2196',7200.00,0.00,0.00,10.00,690.00,'2023-02-10 15:54:43','',''),(2252,'1','310','1',1,'Retail Sale Id 2197',4320.00,0.00,0.00,6.00,414.00,'2023-02-10 16:02:57','',''),(2253,'1','310','1',1,'Retail Sale Id 2197',4320.00,0.00,0.00,6.00,414.00,'2023-02-10 16:02:57','',''),(2254,'1','310','1',1,'Retail Sale Id 2197',4320.00,0.00,0.00,6.00,414.00,'2023-02-10 16:02:57','',''),(2255,'1','310','1',1,'Retail Sale Id 2198',2160.00,0.00,0.00,3.00,207.00,'2023-02-10 16:10:22','',''),(2256,'1','310','1',1,'Retail Sale Id 2198',3600.00,0.00,0.00,5.00,345.00,'2023-02-10 16:10:22','',''),(2257,'1','310','1',1,'Retail Sale Id 2199',9000.00,0.00,0.00,12.50,862.50,'2023-02-10 16:13:35','',''),(2258,'1','310','1',1,'Retail Sale Id 2200',2160.00,0.00,0.00,3.00,207.00,'2023-02-10 16:41:25','',''),(2259,'1','310','1',1,'Retail Sale Id 2201',1101.60,0.00,0.00,1.53,105.57,'2023-02-10 16:42:17','',''),(2260,'1','310','1',1,'Retail Sale Id 2202',1440.00,0.00,0.00,2.00,138.00,'2023-02-10 16:58:16','',''),(2261,'1','310','1',1,'Retail Sale Id 2203',1440.00,0.00,0.00,2.00,138.00,'2023-02-10 17:01:32','',''),(2262,'1','310','1',1,'Retail Sale Id 2204',1000.80,0.00,0.00,1.39,95.91,'2023-02-10 17:05:42','',''),(2263,'1','310','1',1,'Retail Sale Id 2205',4320.00,0.00,0.00,6.00,414.00,'2023-02-10 17:20:08','',''),(2264,'1','310','1',1,'Retail Sale Id 2205',9000.00,0.00,0.00,12.50,862.50,'2023-02-10 17:20:08','',''),(2265,'1','310','1',1,'Retail Sale Id 2206',2397.60,0.00,0.00,3.33,229.77,'2023-02-10 17:22:36','',''),(2266,'1','310','1',1,'Retail Sale Id 2207',9000.00,0.00,0.00,12.50,862.50,'2023-02-10 17:26:03','',''),(2267,'1','310','1',1,'Retail Sale Id 2208',3003.00,0.00,0.00,4.29,210.21,'2023-02-10 17:29:12','',''),(2268,'1','310','1',1,'Retail Sale Id 2209',1497.60,0.00,0.00,2.08,143.52,'2023-02-10 17:32:08','',''),(2269,'1','310','1',1,'Retail Sale Id 2210',496.80,0.00,0.00,0.69,47.61,'2023-02-10 17:35:51','',''),(2270,'1','310','1',1,'Retail Sale Id 2211',4320.00,0.00,0.00,6.00,414.00,'2023-02-10 17:44:12','',''),(2271,'1','310','1',1,'Retail Sale Id 2212',7200.00,0.00,0.00,10.00,690.00,'2023-02-10 17:51:58','',''),(2272,'1','310','1',1,'Retail Sale Id 2213',39200.00,0.00,0.00,56.00,2744.00,'2023-02-10 17:56:39','',''),(2273,'1','310','1',1,'Retail Sale Id 2214',1000.80,0.00,0.00,1.39,95.91,'2023-02-10 17:57:24','',''),(2274,'1','310','1',1,'Retail Sale Id 2216',1000.80,0.00,0.00,1.39,95.91,'2023-02-10 18:00:30','',''),(2275,'1','310','1',1,'Retail Sale Id 2218',1497.60,0.00,0.00,2.08,143.52,'2023-02-10 18:05:40','',''),(2276,'1','310','1',1,'Retail Sale Id 2219',2160.00,0.00,0.00,3.00,207.00,'2023-02-10 18:07:24','',''),(2277,'1','310','1',1,'Retail Sale Id 2220',1000.80,0.00,0.00,1.39,95.91,'2023-02-10 18:12:04','',''),(2278,'1','310','1',1,'Retail Sale Id 2221',4320.00,0.00,0.00,6.00,414.00,'2023-02-10 18:14:33','',''),(2279,'1','310','1',1,'Retail Sale Id 2222',4298.40,0.00,0.00,5.97,411.93,'2023-02-10 18:16:09','',''),(2280,'1','310','1',1,'Retail Sale Id 2223',4320.00,0.00,0.00,6.00,414.00,'2023-02-10 18:18:42','',''),(2281,'1','310','1',1,'Retail Sale Id 2224',4320.00,0.00,0.00,6.00,414.00,'2023-02-10 18:25:52','',''),(2282,'1','310','1',1,'Retail Sale Id 2225',35000.00,0.00,0.00,50.00,2450.00,'2023-02-10 18:27:18','',''),(2283,'1','310','1',1,'Retail Sale Id 2226',9000.00,0.00,0.00,12.50,862.50,'2023-02-10 18:34:15','',''),(2284,'1','310','1',1,'Retail Sale Id 2227',1000.80,0.00,0.00,1.39,95.91,'2023-02-10 18:35:15','',''),(2285,'1','310','1',1,'Retail Sale Id 2227',3002.40,0.00,0.00,4.17,287.73,'2023-02-10 18:35:16','',''),(2286,'1','310','1',1,'Retail Sale Id 2228',2498.40,0.00,0.00,3.47,239.43,'2023-02-10 18:36:32','',''),(2287,'1','310','1',1,'Return of Retail Sale Id 2221',0.00,4320.00,6.00,0.00,-414.00,'2023-02-10 18:38:12','',''),(2288,'1','310','1',1,'Retail Sale Id 2229',2160.00,0.00,0.00,3.00,207.00,'2023-02-10 18:41:58','',''),(2289,'1','310','1',1,'Retail Sale Id 2231',1440.00,0.00,0.00,2.00,138.00,'2023-02-10 18:43:51','',''),(2290,'1','310','1',1,'Retail Sale Id 2231',2160.00,0.00,0.00,3.00,207.00,'2023-02-10 18:43:51','',''),(2291,'1','310','1',1,'Retail Sale Id 2232',5500.80,0.00,0.00,7.64,527.16,'2023-02-10 18:45:27','',''),(2292,'1','310','1',1,'Retail Sale Id 2233',9000.00,0.00,0.00,12.50,862.50,'2023-02-10 18:46:01','',''),(2293,'1','310','1',1,'Return of Retail Sale Id 2233',0.00,9000.00,12.50,0.00,-862.50,'2023-02-10 19:03:18','',''),(2294,'1','310','1',1,'Retail Sale Id 2234',1044.00,0.00,0.00,1.45,100.05,'2023-02-10 19:03:57','',''),(2295,'1','310','1',1,'Return of Retail Sale Id 2208',0.00,3003.00,4.29,0.00,-210.21,'2023-02-10 19:04:44','',''),(2296,'1','310','1',1,'Retail Sale Id 2235',3003.00,0.00,0.00,4.29,210.21,'2023-02-10 19:06:12','',''),(2297,'1','310','1',1,'Retail Sale Id 2236',3002.40,0.00,0.00,4.17,287.73,'2023-02-11 07:18:30','',''),(2298,'1','310','1',1,'Retail Sale Id 2237',2001.60,0.00,0.00,2.78,191.82,'2023-02-11 07:28:02','',''),(2299,'1','310','1',1,'Retail Sale Id 2238',41797.00,0.00,0.00,59.71,2925.79,'2023-02-11 07:30:48','',''),(2300,'1','310','1',1,'Retail Sale Id 2240',2160.00,0.00,0.00,3.00,207.00,'2023-02-11 07:32:35','',''),(2301,'1','310','1',1,'Retail Sale Id 2241',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 07:34:14','',''),(2302,'1','310','1',1,'Retail Sale Id 2241',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 07:34:14','',''),(2303,'1','310','1',1,'Retail Sale Id 2242',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 07:57:24','',''),(2304,'1','310','1',1,'Retail Sale Id 2243',1497.60,0.00,0.00,2.08,143.52,'2023-02-11 08:29:06','',''),(2305,'1','310','1',1,'Retail Sale Id 2245',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 08:38:09','',''),(2306,'1','310','1',1,'Retail Sale Id 2245',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 08:38:09','',''),(2307,'1','310','1',1,'Retail Sale Id 2246',2160.00,0.00,0.00,3.00,207.00,'2023-02-11 08:46:21','',''),(2308,'1','310','1',1,'Retail Sale Id 2248',3002.40,0.00,0.00,4.17,287.73,'2023-02-11 08:59:04','',''),(2309,'1','310','1',1,'Retail Sale Id 2249',4320.00,0.00,0.00,6.00,414.00,'2023-02-11 09:01:27','',''),(2310,'1','310','1',1,'Retail Sale Id 2250',2001.60,0.00,0.00,2.78,191.82,'2023-02-11 09:05:21','',''),(2311,'1','310','1',1,'Retail Sale Id 2251',2160.00,0.00,0.00,3.00,207.00,'2023-02-11 09:19:49','',''),(2312,'1','310','1',1,'Retail Sale Id 2251',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 09:19:49','',''),(2313,'1','310','1',1,'Retail Sale Id 2252',2160.00,0.00,0.00,3.00,207.00,'2023-02-11 09:21:21','',''),(2314,'1','310','1',1,'Retail Sale Id 2253',4320.00,0.00,0.00,6.00,414.00,'2023-02-11 09:24:41','',''),(2315,'1','310','1',1,'Retail Sale Id 2254',5040.00,0.00,0.00,7.00,483.00,'2023-02-11 09:33:33','',''),(2316,'1','310','1',1,'Retail Sale Id 2255',2001.60,0.00,0.00,2.78,191.82,'2023-02-11 09:34:46','',''),(2317,'1','310','1',1,'Retail Sale Id 2256',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 09:36:18','',''),(2318,'1','310','1',1,'Retail Sale Id 2257',2901.60,0.00,0.00,4.03,278.07,'2023-02-11 09:38:44','',''),(2319,'1','310','1',1,'Retail Sale Id 2258',2001.60,0.00,0.00,2.78,191.82,'2023-02-11 09:52:14','',''),(2320,'1','310','1',1,'Retail Sale Id 2259',70000.00,0.00,0.00,100.00,4900.00,'2023-02-11 09:59:32','',''),(2321,'1','310','1',1,'Retail Sale Id 2260',2001.60,0.00,0.00,2.78,191.82,'2023-02-11 10:06:24','',''),(2322,'1','310','1',1,'Retail Sale Id 2260',4003.20,0.00,0.00,5.56,383.64,'2023-02-11 10:06:24','',''),(2323,'1','310','1',1,'Retail Sale Id 2261',4200.00,0.00,0.00,6.00,294.00,'2023-02-11 10:07:49','',''),(2324,'1','310','1',1,'Retail Sale Id 2262',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 10:10:48','',''),(2325,'1','310','1',1,'Retail Sale Id 2263',7200.00,0.00,0.00,10.00,690.00,'2023-02-11 10:11:46','',''),(2326,'1','310','1',1,'Retail Sale Id 2264',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 10:16:59','',''),(2327,'1','310','1',1,'Retail Sale Id 2265',35000.00,0.00,0.00,50.00,2450.00,'2023-02-11 10:29:10','',''),(2328,'1','310','1',1,'Retail Sale Id 2266',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 10:31:03','',''),(2329,'1','310','1',1,'Retail Sale Id 2267',1497.60,0.00,0.00,2.08,143.52,'2023-02-11 10:32:01','',''),(2330,'1','310','1',1,'Retail Sale Id 2268',2160.00,0.00,0.00,3.00,207.00,'2023-02-11 10:33:43','',''),(2331,'1','310','1',1,'Retail Sale Id 2269',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 10:35:29','',''),(2332,'1','310','1',1,'Retail Sale Id 2270',1497.60,0.00,0.00,2.08,143.52,'2023-02-11 10:53:23','',''),(2333,'1','310','1',1,'Retail Sale Id 2271',35000.00,0.00,0.00,50.00,2450.00,'2023-02-11 11:09:15','',''),(2334,'1','310','1',1,'Retail Sale Id 2272',2160.00,0.00,0.00,3.00,207.00,'2023-02-11 11:15:55','',''),(2335,'1','310','1',1,'Retail Sale Id 2273',1000.80,0.00,0.00,1.39,95.91,'2023-02-11 11:26:04','',''),(2336,'1','310','1',1,'Retail Sale Id 2274',35000.00,0.00,0.00,50.00,2450.00,'2023-02-11 11:37:16','',''),(2337,'1','310','1',1,'Retail Sale Id 2275',4500.00,0.00,0.00,6.25,431.25,'2023-02-11 11:38:36','',''),(2338,'1','310','1',1,'Retail Sale Id 2276',4003.20,0.00,0.00,5.56,383.64,'2023-02-11 11:41:27','',''),(2339,'1','310','1',1,'Retail Sale Id 2277',2001.60,0.00,0.00,2.78,191.82,'2023-02-11 11:44:32','',''),(2340,'1','310','1',1,'Retail Sale Id 2277',3002.40,0.00,0.00,4.17,287.73,'2023-02-11 11:44:32','',''),(2341,'1','310','1',1,'Retail Sale Id 2278',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 11:46:44','',''),(2342,'1','310','1',1,'Retail Sale Id 2279',4320.00,0.00,0.00,6.00,414.00,'2023-02-11 11:48:38','',''),(2343,'1','310','1',1,'Retail Sale Id 2280',4320.00,0.00,0.00,6.00,414.00,'2023-02-11 11:50:09','',''),(2344,'1','310','1',1,'Retail Sale Id 2281',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 11:51:43','',''),(2345,'1','310','1',1,'Retail Sale Id 2282',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 11:55:02','',''),(2346,'1','310','1',1,'Retail Sale Id 2282',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 11:55:02','',''),(2347,'1','310','1',1,'Retail Sale Id 2283',4298.40,0.00,0.00,5.97,411.93,'2023-02-11 12:02:13','',''),(2348,'1','310','1',1,'Retail Sale Id 2284',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 12:05:48','',''),(2349,'1','310','1',1,'Retail Sale Id 2285',496.80,0.00,0.00,0.69,47.61,'2023-02-11 12:08:16','',''),(2350,'1','310','1',1,'Retail Sale Id 2286',2001.60,0.00,0.00,2.78,191.82,'2023-02-11 12:09:53','',''),(2351,'1','310','1',1,'Retail Sale Id 2287',1497.60,0.00,0.00,2.08,143.52,'2023-02-11 12:12:11','',''),(2352,'1','310','1',1,'Retail Sale Id 2288',2001.60,0.00,0.00,2.78,191.82,'2023-02-11 12:14:21','',''),(2353,'1','310','1',1,'Retail Sale Id 2289',4320.00,0.00,0.00,6.00,414.00,'2023-02-11 12:15:51','',''),(2354,'1','310','1',1,'Retail Sale Id 2290',496.80,0.00,0.00,0.69,47.61,'2023-02-11 12:17:17','',''),(2355,'1','310','1',1,'Retail Sale Id 2291',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 12:36:24','',''),(2356,'1','310','1',1,'Retail Sale Id 2292',496.80,0.00,0.00,0.69,47.61,'2023-02-11 12:37:28','',''),(2357,'1','310','1',1,'Retail Sale Id 2293',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 12:38:21','',''),(2358,'1','310','1',1,'Retail Sale Id 2294',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 12:43:48','',''),(2359,'1','310','1',1,'Retail Sale Id 2295',496.80,0.00,0.00,0.69,47.61,'2023-02-11 12:44:51','',''),(2360,'1','310','1',1,'Retail Sale Id 2296',1000.80,0.00,0.00,1.39,95.91,'2023-02-11 12:49:18','',''),(2361,'1','310','1',1,'Retail Sale Id 2297',77000.00,0.00,0.00,110.00,5390.00,'2023-02-11 12:52:07','',''),(2362,'1','310','1',1,'Retail Sale Id 2298',38500.00,0.00,0.00,55.00,2695.00,'2023-02-11 12:54:20','',''),(2363,'1','310','1',1,'Retail Sale Id 2299',2203.20,0.00,0.00,3.06,211.14,'2023-02-11 13:01:26','',''),(2364,'1','310','1',1,'Retail Sale Id 2300',6480.00,0.00,0.00,9.00,621.00,'2023-02-11 13:04:24','',''),(2365,'1','310','1',1,'Retail Sale Id 2301',2160.00,0.00,0.00,3.00,207.00,'2023-02-11 13:08:10','',''),(2366,'1','310','1',1,'Retail Sale Id 2302',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 13:10:27','',''),(2367,'1','310','1',1,'Retail Sale Id 2302',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 13:10:27','',''),(2368,'1','310','1',1,'Retail Sale Id 2303',1497.60,0.00,0.00,2.08,143.52,'2023-02-11 13:11:46','',''),(2369,'1','310','1',1,'Retail Sale Id 2304',1497.60,0.00,0.00,2.08,143.52,'2023-02-11 13:17:06','',''),(2370,'1','310','1',1,'Retail Sale Id 2305',105000.00,0.00,0.00,150.00,7350.00,'2023-02-11 13:23:41','',''),(2371,'1','310','1',1,'Retail Sale Id 2306',105000.00,0.00,0.00,150.00,7350.00,'2023-02-11 13:24:27','',''),(2372,'1','310','1',1,'Retail Sale Id 2307',2160.00,0.00,0.00,3.00,207.00,'2023-02-11 13:26:02','',''),(2373,'1','310','1',1,'Retail Sale Id 2308',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 13:28:07','',''),(2374,'1','310','1',1,'Retail Sale Id 2308',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 13:28:07','',''),(2375,'1','310','1',1,'Retail Sale Id 2309',2160.00,0.00,0.00,3.00,207.00,'2023-02-11 13:29:31','',''),(2376,'1','310','1',1,'Retail Sale Id 2310',42000.00,0.00,0.00,60.00,2940.00,'2023-02-11 13:32:27','',''),(2377,'1','310','1',1,'Retail Sale Id 2311',2001.60,0.00,0.00,2.78,191.82,'2023-02-11 13:34:19','',''),(2378,'1','310','1',1,'Retail Sale Id 2312',3700.80,0.00,0.00,5.14,354.66,'2023-02-11 13:36:35','',''),(2379,'1','310','1',1,'Retail Sale Id 2313',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 13:37:37','',''),(2380,'1','310','1',1,'Retail Sale Id 2313',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 13:37:37','',''),(2381,'1','310','1',1,'Retail Sale Id 2314',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 13:38:15','',''),(2382,'1','310','1',1,'Retail Sale Id 2316',2001.60,0.00,0.00,2.78,191.82,'2023-02-11 13:48:02','',''),(2383,'1','310','1',1,'Retail Sale Id 2317',900.00,0.00,0.00,1.25,86.25,'2023-02-11 13:52:10','',''),(2384,'1','310','1',1,'Retail Sale Id 2318',4996.80,0.00,0.00,6.94,478.86,'2023-02-11 13:54:24','',''),(2385,'1','310','1',1,'Retail Sale Id 2319',4320.00,0.00,0.00,6.00,414.00,'2023-02-11 13:56:25','',''),(2386,'1','310','1',1,'Retail Sale Id 2320',4320.00,0.00,0.00,6.00,414.00,'2023-02-11 14:07:39','',''),(2387,'1','310','1',1,'Retail Sale Id 2321',1396.80,0.00,0.00,1.94,133.86,'2023-02-11 14:15:25','',''),(2388,'1','310','1',1,'Retail Sale Id 2322',4003.20,0.00,0.00,5.56,383.64,'2023-02-11 14:19:20','',''),(2389,'1','310','1',1,'Retail Sale Id 2323',1440.00,0.00,0.00,2.00,138.00,'2023-02-11 14:20:12','',''),(2390,'1','310','1',1,'Retail Sale Id 2326',77000.00,0.00,0.00,110.00,5390.00,'2023-02-11 14:22:38','',''),(2391,'1','310','1',1,'Retail Sale Id 2327',4320.00,0.00,0.00,6.00,414.00,'2023-02-11 14:23:26','',''),(2392,'1','310','1',1,'Retail Sale Id 2328',3600.00,0.00,0.00,5.00,345.00,'2023-02-11 14:24:09','',''),(2393,'1','310','1',1,'Retail Sale Id 2329',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 14:27:05','',''),(2394,'1','310','1',1,'Retail Sale Id 2330',2498.40,0.00,0.00,3.47,239.43,'2023-02-11 14:31:21','',''),(2395,'1','310','1',1,'Retail Sale Id 2331',3600.00,0.00,0.00,5.00,345.00,'2023-02-11 14:35:22','',''),(2396,'1','310','1',1,'Retail Sale Id 2331',4320.00,0.00,0.00,6.00,414.00,'2023-02-11 14:35:22','',''),(2397,'1','310','1',1,'Retail Sale Id 2332',105000.00,0.00,0.00,150.00,7350.00,'2023-02-11 14:41:04','',''),(2398,'1','310','1',1,'Retail Sale Id 2333',4320.00,0.00,0.00,6.00,414.00,'2023-02-11 14:46:49','',''),(2399,'1','310','1',1,'Retail Sale Id 2334',4320.00,0.00,0.00,6.00,414.00,'2023-02-11 14:49:04','',''),(2400,'1','310','1',1,'Retail Sale Id 2335',2160.00,0.00,0.00,3.00,207.00,'2023-02-11 14:52:56','',''),(2401,'1','310','1',1,'Retail Sale Id 2336',4320.00,0.00,0.00,6.00,414.00,'2023-02-11 14:56:01','',''),(2402,'1','310','1',1,'Retail Sale Id 2337',3600.00,0.00,0.00,5.00,345.00,'2023-02-11 15:09:35','',''),(2403,'1','310','1',1,'Retail Sale Id 2338',3002.40,0.00,0.00,4.17,287.73,'2023-02-11 15:11:45','',''),(2404,'1','310','1',1,'Retail Sale Id 2339',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 15:28:36','',''),(2405,'1','310','1',1,'Retail Sale Id 2341',4320.00,0.00,0.00,6.00,414.00,'2023-02-11 15:29:35','',''),(2406,'1','310','1',1,'Retail Sale Id 2343',3499.20,0.00,0.00,4.86,335.34,'2023-02-11 15:35:01','',''),(2407,'1','310','1',1,'Retail Sale Id 2344',70000.00,0.00,0.00,100.00,4900.00,'2023-02-11 15:37:59','',''),(2408,'1','310','1',1,'Retail Sale Id 2345',2498.40,0.00,0.00,3.47,239.43,'2023-02-11 15:38:55','',''),(2409,'1','310','1',1,'Retail Sale Id 2346',2160.00,0.00,0.00,3.00,207.00,'2023-02-11 15:40:41','',''),(2410,'1','310','1',1,'Retail Sale Id 2347',1000.80,0.00,0.00,1.39,95.91,'2023-02-11 15:41:32','',''),(2411,'1','310','1',1,'Retail Sale Id 2348',4996.80,0.00,0.00,6.94,478.86,'2023-02-11 15:46:57','',''),(2412,'1','310','1',1,'Retail Sale Id 2349',2160.00,0.00,0.00,3.00,207.00,'2023-02-11 15:56:19','',''),(2413,'1','310','1',1,'Retail Sale Id 2349',10800.00,0.00,0.00,15.00,1035.00,'2023-02-11 15:56:19','',''),(2414,'1','310','1',1,'Return of Retail Sale Id 2345',0.00,2498.40,3.47,0.00,-239.43,'2023-02-11 15:57:22','',''),(2415,'1','310','1',1,'Retail Sale Id 2350',2001.60,0.00,0.00,2.78,191.82,'2023-02-11 16:13:44','',''),(2416,'1','310','1',1,'Retail Sale Id 2351',2498.40,0.00,0.00,3.47,239.43,'2023-02-11 16:15:29','',''),(2417,'1','310','1',1,'Retail Sale Id 2352',2001.60,0.00,0.00,2.78,191.82,'2023-02-11 16:16:10','',''),(2418,'1','310','1',1,'Retail Sale Id 2353',70000.00,0.00,0.00,100.00,4900.00,'2023-02-11 16:23:20','',''),(2419,'1','310','1',1,'Retail Sale Id 2354',8750.00,0.00,0.00,12.50,612.50,'2023-02-11 16:25:05','',''),(2420,'1','310','1',1,'Retail Sale Id 2355',17500.00,0.00,0.00,25.00,1225.00,'2023-02-11 16:29:15','',''),(2421,'1','310','1',1,'Retail Sale Id 2356',2160.00,0.00,0.00,3.00,207.00,'2023-02-11 16:32:21','',''),(2422,'1','310','1',1,'Retail Sale Id 2356',4320.00,0.00,0.00,6.00,414.00,'2023-02-11 16:32:21','',''),(2423,'1','310','1',1,'Retail Sale Id 2357',2160.00,0.00,0.00,3.00,207.00,'2023-02-11 16:54:18','',''),(2424,'1','310','1',1,'Retail Sale Id 2358',1000.80,0.00,0.00,1.39,95.91,'2023-02-11 16:55:30','',''),(2425,'1','310','1',1,'Retail Sale Id 2359',2599.20,0.00,0.00,3.61,249.09,'2023-02-11 16:59:54','',''),(2426,'1','310','1',1,'Retail Sale Id 2360',3002.40,0.00,0.00,4.17,287.73,'2023-02-11 17:05:13','',''),(2427,'1','310','1',1,'Retail Sale Id 2362',4320.00,0.00,0.00,6.00,414.00,'2023-02-11 17:08:03','',''),(2428,'1','310','1',1,'Retail Sale Id 2363',1000.80,0.00,0.00,1.39,95.91,'2023-02-11 17:10:21','',''),(2429,'1','310','1',1,'Retail Sale Id 2364',4320.00,0.00,0.00,6.00,414.00,'2023-02-11 17:20:43','',''),(2430,'1','310','1',1,'Retail Sale Id 2365',7200.00,0.00,0.00,10.00,690.00,'2023-02-11 17:22:43','',''),(2431,'1','310','1',1,'Retail Sale Id 2366',3002.40,0.00,0.00,4.17,287.73,'2023-02-11 17:24:02','',''),(2432,'1','310','1',1,'Retail Sale Id 2367',35000.00,0.00,0.00,50.00,2450.00,'2023-02-11 17:29:02','',''),(2433,'1','310','1',1,'Retail Sale Id 2368',720.00,0.00,0.00,1.00,69.00,'2023-02-11 17:30:45','',''),(2434,'1','310','1',1,'Retail Sale Id 2369',2498.40,0.00,0.00,3.47,239.43,'2023-02-11 17:32:56','',''),(2435,'1','310','1',1,'Retail Sale Id 2370',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 17:34:39','',''),(2436,'1','310','1',1,'Retail Sale Id 2371',4320.00,0.00,0.00,6.00,414.00,'2023-02-11 17:35:46','',''),(2437,'1','310','1',1,'Retail Sale Id 2372',4200.00,0.00,0.00,6.00,294.00,'2023-02-11 17:38:04','',''),(2438,'1','310','1',1,'Retail Sale Id 2373',3002.40,0.00,0.00,4.17,287.73,'2023-02-11 17:39:24','',''),(2439,'1','310','1',1,'Retail Sale Id 2374',4320.00,0.00,0.00,6.00,414.00,'2023-02-11 17:43:56','',''),(2440,'1','310','1',1,'Retail Sale Id 2375',2001.60,0.00,0.00,2.78,191.82,'2023-02-11 17:45:57','',''),(2441,'1','310','1',1,'Retail Sale Id 2376',18000.00,0.00,0.00,25.00,1725.00,'2023-02-11 17:47:01','',''),(2442,'1','310','1',1,'Retail Sale Id 2377',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 17:48:15','',''),(2443,'1','310','1',1,'Retail Sale Id 2377',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 17:48:15','',''),(2444,'1','310','1',1,'Retail Sale Id 2378',1497.60,0.00,0.00,2.08,143.52,'2023-02-11 17:50:14','',''),(2445,'1','310','1',1,'Retail Sale Id 2379',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 17:52:57','',''),(2446,'1','310','1',1,'Retail Sale Id 2380',2160.00,0.00,0.00,3.00,207.00,'2023-02-11 17:55:10','',''),(2447,'1','310','1',1,'Retail Sale Id 2382',1000.80,0.00,0.00,1.39,95.91,'2023-02-11 17:57:35','',''),(2448,'1','310','1',1,'Retail Sale Id 2383',1000.80,0.00,0.00,1.39,95.91,'2023-02-11 17:58:34','',''),(2449,'1','310','1',1,'Retail Sale Id 2384',597.60,0.00,0.00,0.83,57.27,'2023-02-11 18:04:40','',''),(2450,'1','310','1',1,'Retail Sale Id 2385',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 18:08:38','',''),(2451,'1','310','1',1,'Retail Sale Id 2386',1000.80,0.00,0.00,1.39,95.91,'2023-02-11 18:10:05','',''),(2452,'1','310','1',1,'Retail Sale Id 2387',2001.60,0.00,0.00,2.78,191.82,'2023-02-11 18:11:23','',''),(2453,'1','310','1',1,'Retail Sale Id 2388',3600.00,0.00,0.00,5.00,345.00,'2023-02-11 18:15:22','',''),(2454,'1','310','1',1,'Retail Sale Id 2389',2001.60,0.00,0.00,2.78,191.82,'2023-02-11 18:18:45','',''),(2455,'1','310','1',1,'Retail Sale Id 2390',2880.00,0.00,0.00,4.00,276.00,'2023-02-11 18:25:30','',''),(2456,'1','310','1',1,'Retail Sale Id 2391',70000.00,0.00,0.00,100.00,4900.00,'2023-02-11 18:29:34','',''),(2457,'1','310','1',1,'Retail Sale Id 2392',4320.00,0.00,0.00,6.00,414.00,'2023-02-11 18:34:04','',''),(2458,'1','310','1',1,'Retail Sale Id 2393',1497.60,0.00,0.00,2.08,143.52,'2023-02-11 18:35:04','',''),(2459,'1','310','1',1,'Return of Retail Sale Id 2370',0.00,9000.00,12.50,0.00,-862.50,'2023-02-11 19:15:55','',''),(2460,'1','310','1',1,'Return of Retail Sale Id 2376',0.00,18000.00,25.00,0.00,-1725.00,'2023-02-11 19:19:12','',''),(2461,'1','310','1',1,'Retail Sale Id 2395',5061.60,0.00,0.00,7.03,485.07,'2023-02-11 19:20:00','',''),(2462,'1','310','1',1,'Return of Retail Sale Id 2385',0.00,9000.00,12.50,0.00,-862.50,'2023-02-11 19:20:29','',''),(2463,'1','310','1',1,'Return of Retail Sale Id 2372',0.00,4200.00,6.00,0.00,-294.00,'2023-02-11 19:21:23','',''),(2464,'1','310','1',1,'Retail Sale Id 2396',9000.00,0.00,0.00,12.50,862.50,'2023-02-11 19:22:20','',''),(2465,'1','310','1',1,'Retail Sale Id 2397',4004.00,0.00,0.00,5.72,280.28,'2023-02-11 19:22:28','',''),(2466,'1','310','1',1,'Retail Sale Id 2398',2102.40,0.00,0.00,2.92,201.48,'2023-02-12 07:30:34','',''),(2467,'1','310','1',1,'Retail Sale Id 2399',1440.00,0.00,0.00,2.00,138.00,'2023-02-12 07:31:59','',''),(2468,'1','310','1',1,'Retail Sale Id 2400',2498.40,0.00,0.00,3.47,239.43,'2023-02-12 07:43:17','',''),(2469,'1','310','1',1,'Retail Sale Id 2401',2152.80,0.00,0.00,2.99,206.31,'2023-02-12 07:47:21','',''),(2470,'1','310','1',1,'Retail Sale Id 2402',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 07:56:23','',''),(2471,'1','310','1',1,'Retail Sale Id 2403',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 08:20:20','',''),(2472,'1','310','1',1,'Retail Sale Id 2404',70000.00,0.00,0.00,100.00,4900.00,'2023-02-12 08:26:15','',''),(2473,'1','310','1',1,'Retail Sale Id 2405',3002.40,0.00,0.00,4.17,287.73,'2023-02-12 08:28:20','',''),(2474,'1','310','1',1,'Retail Sale Id 2406',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 08:42:49','',''),(2475,'1','310','1',1,'Retail Sale Id 2407',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 08:57:12','',''),(2476,'1','310','1',1,'Retail Sale Id 2408',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 09:09:12','',''),(2477,'1','310','1',1,'Retail Sale Id 2409',3002.40,0.00,0.00,4.17,287.73,'2023-02-12 09:15:39','',''),(2478,'1','310','1',1,'Retail Sale Id 2410',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 09:16:50','',''),(2479,'1','310','1',1,'Retail Sale Id 2411',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 09:21:23','',''),(2480,'1','310','1',1,'Retail Sale Id 2412',496.80,0.00,0.00,0.69,47.61,'2023-02-12 09:22:32','',''),(2481,'1','310','1',1,'Retail Sale Id 2413',210000.00,0.00,0.00,300.00,14700.00,'2023-02-12 09:41:11','',''),(2482,'1','310','1',1,'Retail Sale Id 2414',4500.00,0.00,0.00,6.25,431.25,'2023-02-12 10:02:05','',''),(2483,'1','310','1',1,'Retail Sale Id 2415',9000.00,0.00,0.00,12.50,862.50,'2023-02-12 10:08:10','',''),(2484,'1','310','1',1,'Retail Sale Id 2416',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 10:15:54','',''),(2485,'1','310','1',1,'Retail Sale Id 2417',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 10:16:32','',''),(2486,'1','310','1',1,'Retail Sale Id 2418',3600.00,0.00,0.00,5.00,345.00,'2023-02-12 10:24:20','',''),(2487,'1','310','1',1,'Retail Sale Id 2418',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 10:24:20','',''),(2488,'1','310','1',1,'Retail Sale Id 2419',4996.80,0.00,0.00,6.94,478.86,'2023-02-12 10:32:53','',''),(2489,'1','310','1',1,'Retail Sale Id 2420',1497.60,0.00,0.00,2.08,143.52,'2023-02-12 10:33:54','',''),(2490,'1','310','1',1,'Retail Sale Id 2421',1000.80,0.00,0.00,1.39,95.91,'2023-02-12 10:35:05','',''),(2491,'1','310','1',1,'Retail Sale Id 2422',1000.80,0.00,0.00,1.39,95.91,'2023-02-12 10:37:16','',''),(2492,'1','310','1',1,'Retail Sale Id 2423',1000.80,0.00,0.00,1.39,95.91,'2023-02-12 10:49:32','',''),(2493,'1','310','1',1,'Retail Sale Id 2425',3002.40,0.00,0.00,4.17,287.73,'2023-02-12 10:50:39','',''),(2494,'1','310','1',1,'Retail Sale Id 2426',3600.00,0.00,0.00,5.00,345.00,'2023-02-12 10:56:36','',''),(2495,'1','310','1',1,'Retail Sale Id 2426',9000.00,0.00,0.00,12.50,862.50,'2023-02-12 10:56:36','',''),(2496,'1','310','1',1,'Retail Sale Id 2427',1202.40,0.00,0.00,1.67,115.23,'2023-02-12 10:57:39','',''),(2497,'1','310','1',1,'Retail Sale Id 2428',7200.00,0.00,0.00,10.00,690.00,'2023-02-12 11:01:01','',''),(2498,'1','310','1',1,'Retail Sale Id 2428',7200.00,0.00,0.00,10.00,690.00,'2023-02-12 11:01:01','',''),(2499,'1','310','1',1,'Retail Sale Id 2429',1000.80,0.00,0.00,1.39,95.91,'2023-02-12 11:01:37','',''),(2500,'1','310','1',1,'Retail Sale Id 2431',403.20,0.00,0.00,0.56,38.64,'2023-02-12 11:09:46','',''),(2501,'1','310','1',1,'Retail Sale Id 2432',22197.00,0.00,0.00,31.71,1553.79,'2023-02-12 11:14:45','',''),(2502,'1','310','1',1,'Retail Sale Id 2433',3600.00,0.00,0.00,5.00,345.00,'2023-02-12 11:15:29','',''),(2503,'1','310','1',1,'Retail Sale Id 2434',7000.00,0.00,0.00,10.00,490.00,'2023-02-12 11:21:20','',''),(2504,'1','310','1',1,'Retail Sale Id 2435',105000.00,0.00,0.00,150.00,7350.00,'2023-02-12 11:29:47','',''),(2505,'1','310','1',1,'Retail Sale Id 2436',9000.00,0.00,0.00,12.50,862.50,'2023-02-12 11:34:50','',''),(2506,'1','310','1',1,'Retail Sale Id 2437',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 11:36:14','',''),(2507,'1','310','1',1,'Retail Sale Id 2438',3600.00,0.00,0.00,5.00,345.00,'2023-02-12 11:38:28','',''),(2508,'1','310','1',1,'Retail Sale Id 2439',720.00,0.00,0.00,1.00,69.00,'2023-02-12 11:42:19','',''),(2509,'1','310','1',1,'Retail Sale Id 2440',2001.60,0.00,0.00,2.78,191.82,'2023-02-12 11:42:56','',''),(2510,'1','310','1',1,'Retail Sale Id 2441',1000.80,0.00,0.00,1.39,95.91,'2023-02-12 11:58:01','',''),(2511,'1','310','1',1,'Retail Sale Id 2443',2160.00,0.00,0.00,3.00,207.00,'2023-02-12 11:59:54','',''),(2512,'1','310','1',1,'Retail Sale Id 2444',1900.80,0.00,0.00,2.64,182.16,'2023-02-12 12:05:19','',''),(2513,'1','310','1',1,'Retail Sale Id 2445',3002.40,0.00,0.00,4.17,287.73,'2023-02-12 12:06:49','',''),(2514,'1','310','1',1,'Retail Sale Id 2446',1497.60,0.00,0.00,2.08,143.52,'2023-02-12 12:08:22','',''),(2515,'1','310','1',1,'Retail Sale Id 2447',1497.60,0.00,0.00,2.08,143.52,'2023-02-12 12:14:02','',''),(2516,'1','310','1',1,'Retail Sale Id 2448',3600.00,0.00,0.00,5.00,345.00,'2023-02-12 12:16:39','',''),(2517,'1','310','1',1,'Retail Sale Id 2449',9000.00,0.00,0.00,12.50,862.50,'2023-02-12 12:20:50','',''),(2518,'1','310','1',1,'Retail Sale Id 2450',9000.00,0.00,0.00,12.50,862.50,'2023-02-12 12:24:03','',''),(2519,'1','310','1',1,'Retail Sale Id 2451',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 12:51:45','',''),(2520,'1','310','1',1,'Retail Sale Id 2451',9000.00,0.00,0.00,12.50,862.50,'2023-02-12 12:51:45','',''),(2521,'1','310','1',1,'Retail Sale Id 2452',2498.40,0.00,0.00,3.47,239.43,'2023-02-12 12:57:19','',''),(2522,'1','310','1',1,'Retail Sale Id 2453',5040.00,0.00,0.00,7.00,483.00,'2023-02-12 13:07:48','',''),(2523,'1','310','1',1,'Retail Sale Id 2454',2498.40,0.00,0.00,3.47,239.43,'2023-02-12 13:09:54','',''),(2524,'1','310','1',1,'Retail Sale Id 2455',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 13:11:10','',''),(2525,'1','310','1',1,'Retail Sale Id 2456',9000.00,0.00,0.00,12.50,862.50,'2023-02-12 13:15:48','',''),(2526,'1','310','1',1,'Retail Sale Id 2458',1800.00,0.00,0.00,2.50,172.50,'2023-02-12 13:19:12','',''),(2527,'1','310','1',1,'Retail Sale Id 2459',9000.00,0.00,0.00,12.50,862.50,'2023-02-12 13:20:36','',''),(2528,'1','310','1',1,'Retail Sale Id 2460',2001.60,0.00,0.00,2.78,191.82,'2023-02-12 13:23:39','',''),(2529,'1','310','1',1,'Retail Sale Id 2461',9000.00,0.00,0.00,12.50,862.50,'2023-02-12 13:25:12','',''),(2530,'1','310','1',1,'Retail Sale Id 2462',1497.60,0.00,0.00,2.08,143.52,'2023-02-12 13:33:39','',''),(2531,'1','310','1',1,'Retail Sale Id 2463',3002.40,0.00,0.00,4.17,287.73,'2023-02-12 13:35:45','',''),(2532,'1','310','1',1,'Retail Sale Id 2464',2160.00,0.00,0.00,3.00,207.00,'2023-02-12 13:37:36','',''),(2533,'1','310','1',1,'Retail Sale Id 2465',2160.00,0.00,0.00,3.00,207.00,'2023-02-12 13:38:46','',''),(2534,'1','310','1',1,'Retail Sale Id 2466',2160.00,0.00,0.00,3.00,207.00,'2023-02-12 13:41:10','',''),(2535,'1','310','1',1,'Retail Sale Id 2467',2001.60,0.00,0.00,2.78,191.82,'2023-02-12 13:42:49','',''),(2536,'1','310','1',1,'Retail Sale Id 2468',9000.00,0.00,0.00,12.50,862.50,'2023-02-12 13:48:02','',''),(2537,'1','310','1',1,'Retail Sale Id 2469',70000.00,0.00,0.00,100.00,4900.00,'2023-02-12 13:50:40','',''),(2538,'1','310','1',1,'Retail Sale Id 2470',35000.00,0.00,0.00,50.00,2450.00,'2023-02-12 13:53:15','',''),(2539,'1','310','1',1,'Retail Sale Id 2471',2001.60,0.00,0.00,2.78,191.82,'2023-02-12 13:56:10','',''),(2540,'1','310','1',1,'Retail Sale Id 2472',2160.00,0.00,0.00,3.00,207.00,'2023-02-12 13:58:07','',''),(2541,'1','310','1',1,'Retail Sale Id 2473',2160.00,0.00,0.00,3.00,207.00,'2023-02-12 14:01:43','',''),(2542,'1','310','1',1,'Retail Sale Id 2473',9000.00,0.00,0.00,12.50,862.50,'2023-02-12 14:01:43','',''),(2543,'1','310','1',1,'Retail Sale Id 2473',9000.00,0.00,0.00,12.50,862.50,'2023-02-12 14:01:43','',''),(2544,'1','310','1',1,'Retail Sale Id 2474',1000.80,0.00,0.00,1.39,95.91,'2023-02-12 14:02:34','',''),(2545,'1','310','1',1,'Retail Sale Id 2475',2203.20,0.00,0.00,3.06,211.14,'2023-02-12 14:08:52','',''),(2546,'1','310','1',1,'Retail Sale Id 2476',9000.00,0.00,0.00,12.50,862.50,'2023-02-12 14:10:39','',''),(2547,'1','310','1',1,'Retail Sale Id 2477',4298.40,0.00,0.00,5.97,411.93,'2023-02-12 14:14:00','',''),(2548,'1','310','1',1,'Retail Sale Id 2478',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 14:17:58','',''),(2549,'1','310','1',1,'Retail Sale Id 2479',1497.60,0.00,0.00,2.08,143.52,'2023-02-12 14:19:13','',''),(2550,'1','310','1',1,'Retail Sale Id 2480',720.00,0.00,0.00,1.00,69.00,'2023-02-12 14:25:04','',''),(2551,'1','310','1',1,'Retail Sale Id 2480',720.00,0.00,0.00,1.00,69.00,'2023-02-12 14:25:04','',''),(2552,'1','310','1',1,'Retail Sale Id 2481',9000.00,0.00,0.00,12.50,862.50,'2023-02-12 14:26:33','',''),(2553,'1','310','1',1,'Retail Sale Id 2482',1000.80,0.00,0.00,1.39,95.91,'2023-02-12 14:28:09','',''),(2554,'1','310','1',1,'Retail Sale Id 2483',1000.80,0.00,0.00,1.39,95.91,'2023-02-12 14:29:25','',''),(2555,'1','310','1',1,'Retail Sale Id 2484',2901.60,0.00,0.00,4.03,278.07,'2023-02-12 14:30:40','',''),(2556,'1','310','1',1,'Retail Sale Id 2485',1000.80,0.00,0.00,1.39,95.91,'2023-02-12 14:31:38','',''),(2557,'1','310','1',1,'Retail Sale Id 2486',3600.00,0.00,0.00,5.00,345.00,'2023-02-12 14:32:50','',''),(2558,'1','310','1',1,'Retail Sale Id 2487',9000.00,0.00,0.00,12.50,862.50,'2023-02-12 14:42:14','',''),(2559,'1','310','1',1,'Retail Sale Id 2488',7200.00,0.00,0.00,10.00,690.00,'2023-02-12 14:45:22','',''),(2560,'1','310','1',1,'Retail Sale Id 2489',3600.00,0.00,0.00,5.00,345.00,'2023-02-12 14:49:38','',''),(2561,'1','310','1',1,'Retail Sale Id 2490',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 14:57:44','',''),(2562,'1','310','1',1,'Retail Sale Id 2491',1000.80,0.00,0.00,1.39,95.91,'2023-02-12 15:03:00','',''),(2563,'1','310','1',1,'Retail Sale Id 2492',2001.60,0.00,0.00,2.78,191.82,'2023-02-12 15:05:42','',''),(2564,'1','310','1',1,'Retail Sale Id 2493',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 15:12:28','',''),(2565,'1','310','1',1,'Retail Sale Id 2494',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 15:18:34','',''),(2566,'1','310','1',1,'Retail Sale Id 2494',9000.00,0.00,0.00,12.50,862.50,'2023-02-12 15:18:34','',''),(2567,'1','310','1',1,'Retail Sale Id 2495',3600.00,0.00,0.00,5.00,345.00,'2023-02-12 15:23:31','',''),(2568,'1','310','1',1,'Return of Retail Sale Id 2495',0.00,3600.00,5.00,0.00,-345.00,'2023-02-12 15:24:36','',''),(2569,'1','310','1',1,'Retail Sale Id 2497',3002.40,0.00,0.00,4.17,287.73,'2023-02-12 15:28:21','',''),(2570,'1','310','1',1,'Retail Sale Id 2498',2152.80,0.00,0.00,2.99,206.31,'2023-02-12 15:29:15','',''),(2571,'1','310','1',1,'Retail Sale Id 2499',9000.00,0.00,0.00,12.50,862.50,'2023-02-12 15:30:12','',''),(2572,'1','310','1',1,'Retail Sale Id 2501',1000.80,0.00,0.00,1.39,95.91,'2023-02-12 15:35:35','',''),(2573,'1','310','1',1,'Retail Sale Id 2502',2203.20,0.00,0.00,3.06,211.14,'2023-02-12 15:37:18','',''),(2574,'1','310','1',1,'Retail Sale Id 2503',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 15:38:29','',''),(2575,'1','310','1',1,'Retail Sale Id 2504',2160.00,0.00,0.00,3.00,207.00,'2023-02-12 15:39:00','',''),(2576,'1','310','1',1,'Retail Sale Id 2505',7200.00,0.00,0.00,10.00,690.00,'2023-02-12 15:42:43','',''),(2577,'1','310','1',1,'Retail Sale Id 2506',4003.20,0.00,0.00,5.56,383.64,'2023-02-12 15:45:03','',''),(2578,'1','310','1',1,'Retail Sale Id 2507',496.80,0.00,0.00,0.69,47.61,'2023-02-12 15:50:21','',''),(2579,'1','310','1',1,'Retail Sale Id 2508',77000.00,0.00,0.00,110.00,5390.00,'2023-02-12 15:54:09','',''),(2580,'1','310','1',1,'Retail Sale Id 2509',3600.00,0.00,0.00,5.00,345.00,'2023-02-12 15:55:20','',''),(2581,'1','310','1',1,'Retail Sale Id 2510',1497.60,0.00,0.00,2.08,143.52,'2023-02-12 15:57:20','',''),(2582,'1','310','1',1,'Retail Sale Id 2512',16800.00,0.00,0.00,24.00,1176.00,'2023-02-12 16:11:37','',''),(2583,'1','310','1',1,'Retail Sale Id 2513',16800.00,0.00,0.00,24.00,1176.00,'2023-02-12 16:14:21','',''),(2584,'1','310','1',1,'Return of Retail Sale Id 2512',0.00,16800.00,24.00,0.00,-1176.00,'2023-02-12 16:15:34','',''),(2585,'1','310','1',1,'Retail Sale Id 2514',496.80,0.00,0.00,0.69,47.61,'2023-02-12 16:16:17','',''),(2586,'1','310','1',1,'Retail Sale Id 2515',748.80,0.00,0.00,1.04,71.76,'2023-02-12 16:20:39','',''),(2587,'1','310','1',1,'Retail Sale Id 2516',1497.60,0.00,0.00,2.08,143.52,'2023-02-12 16:32:13','',''),(2588,'1','310','1',1,'Retail Sale Id 2517',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 16:46:00','',''),(2589,'1','310','1',1,'Retail Sale Id 2518',2001.60,0.00,0.00,2.78,191.82,'2023-02-12 16:47:41','',''),(2590,'1','310','1',1,'Retail Sale Id 2519',9000.00,0.00,0.00,12.50,862.50,'2023-02-12 16:54:53','',''),(2591,'1','310','1',1,'Retail Sale Id 2520',1497.60,0.00,0.00,2.08,143.52,'2023-02-12 16:55:44','',''),(2592,'1','310','1',1,'Retail Sale Id 2521',9000.00,0.00,0.00,12.50,862.50,'2023-02-12 16:58:46','',''),(2593,'1','310','1',1,'Retail Sale Id 2522',203000.00,0.00,0.00,290.00,14210.00,'2023-02-12 16:59:49','',''),(2594,'1','310','1',1,'Retail Sale Id 2523',1000.80,0.00,0.00,1.39,95.91,'2023-02-12 17:00:32','',''),(2595,'1','310','1',1,'Retail Sale Id 2524',9100.00,0.00,0.00,13.00,637.00,'2023-02-12 17:01:07','',''),(2596,'1','310','1',1,'Retail Sale Id 2525',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 17:02:07','',''),(2597,'1','310','1',1,'Retail Sale Id 2526',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 17:02:44','',''),(2598,'1','310','1',1,'Retail Sale Id 2527',1497.60,0.00,0.00,2.08,143.52,'2023-02-12 17:18:54','',''),(2599,'1','310','1',1,'Retail Sale Id 2528',4003.20,0.00,0.00,5.56,383.64,'2023-02-12 17:19:38','',''),(2600,'1','310','1',1,'Retail Sale Id 2529',1000.80,0.00,0.00,1.39,95.91,'2023-02-12 17:20:22','',''),(2601,'1','310','1',1,'Retail Sale Id 2530',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 17:27:21','',''),(2602,'1','310','1',1,'Retail Sale Id 2531',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 17:29:08','',''),(2603,'1','310','1',1,'Retail Sale Id 2532',748.80,0.00,0.00,1.04,71.76,'2023-02-12 17:31:18','',''),(2604,'1','310','1',1,'Retail Sale Id 2533',3600.00,0.00,0.00,5.00,345.00,'2023-02-12 17:32:55','',''),(2605,'1','310','1',1,'Retail Sale Id 2534',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 17:36:48','',''),(2606,'1','310','1',1,'Retail Sale Id 2535',3600.00,0.00,0.00,5.00,345.00,'2023-02-12 17:38:15','',''),(2607,'1','310','1',1,'Retail Sale Id 2536',4003.20,0.00,0.00,5.56,383.64,'2023-02-12 17:40:43','',''),(2608,'1','310','1',1,'Retail Sale Id 2537',1000.80,0.00,0.00,1.39,95.91,'2023-02-12 17:45:16','',''),(2609,'1','310','1',1,'Retail Sale Id 2538',4996.80,0.00,0.00,6.94,478.86,'2023-02-12 17:49:05','',''),(2610,'1','310','1',1,'Retail Sale Id 2539',45500.00,0.00,0.00,65.00,3185.00,'2023-02-12 18:06:46','',''),(2611,'1','310','1',1,'Retail Sale Id 2540',9000.00,0.00,0.00,12.50,862.50,'2023-02-12 18:09:42','',''),(2612,'1','310','1',1,'Retail Sale Id 2541',5040.00,0.00,0.00,7.00,483.00,'2023-02-12 18:11:56','',''),(2613,'1','310','1',1,'Retail Sale Id 2542',9000.00,0.00,0.00,12.50,862.50,'2023-02-12 18:13:11','',''),(2614,'1','310','1',1,'Retail Sale Id 2543',1000.80,0.00,0.00,1.39,95.91,'2023-02-12 18:13:50','',''),(2615,'1','310','1',1,'Retail Sale Id 2543',1000.80,0.00,0.00,1.39,95.91,'2023-02-12 18:13:50','',''),(2616,'1','310','1',1,'Retail Sale Id 2544',4348.80,0.00,0.00,6.04,416.76,'2023-02-12 18:16:31','',''),(2617,'1','310','1',1,'Retail Sale Id 2545',2203.20,0.00,0.00,3.06,211.14,'2023-02-12 18:17:19','',''),(2618,'1','310','1',1,'Retail Sale Id 2546',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 18:21:39','',''),(2619,'1','310','1',1,'Retail Sale Id 2547',496.80,0.00,0.00,0.69,47.61,'2023-02-12 18:22:47','',''),(2620,'1','310','1',1,'Retail Sale Id 2548',1497.60,0.00,0.00,2.08,143.52,'2023-02-12 18:23:37','',''),(2621,'1','310','1',1,'Retail Sale Id 2549',35000.00,0.00,0.00,50.00,2450.00,'2023-02-12 18:27:20','',''),(2622,'1','310','1',1,'Retail Sale Id 2550',3600.00,0.00,0.00,5.00,345.00,'2023-02-12 18:28:09','',''),(2623,'1','310','1',1,'Retail Sale Id 2551',2160.00,0.00,0.00,3.00,207.00,'2023-02-12 18:34:34','',''),(2624,'1','310','1',1,'Retail Sale Id 2552',1000.80,0.00,0.00,1.39,95.91,'2023-02-12 18:41:20','',''),(2625,'1','310','1',1,'Retail Sale Id 2553',2160.00,0.00,0.00,3.00,207.00,'2023-02-12 18:43:43','',''),(2626,'1','310','1',1,'Retail Sale Id 2554',4320.00,0.00,0.00,6.00,414.00,'2023-02-12 18:44:35','',''),(2627,'1','310','1',1,'Return of Retail Sale Id 2554',0.00,4320.00,6.00,0.00,-414.00,'2023-02-12 19:08:48','',''),(2628,'1','310','1',1,'Retail Sale Id 2555',3722.40,0.00,0.00,5.17,356.73,'2023-02-12 19:09:36','',''),(2629,'1','310','1',1,'Return of Retail Sale Id 2524',0.00,9100.00,13.00,0.00,-637.00,'2023-02-12 19:12:16','',''),(2630,'1','310','1',1,'Retail Sale Id 2556',9107.00,0.00,0.00,13.01,637.49,'2023-02-12 19:14:04','',''),(2631,'1','310','1',1,'Retail Sale Id 2557',42000.00,0.00,0.00,60.00,2940.00,'2023-02-13 07:26:17','',''),(2632,'1','310','1',1,'Retail Sale Id 2558',496.80,0.00,0.00,0.69,47.61,'2023-02-13 07:43:16','',''),(2633,'1','310','1',1,'Retail Sale Id 2559',2152.80,0.00,0.00,2.99,206.31,'2023-02-13 07:58:01','',''),(2634,'1','310','1',1,'Retail Sale Id 2560',2102.40,0.00,0.00,2.92,201.48,'2023-02-13 08:06:41','',''),(2635,'1','310','1',1,'Retail Sale Id 2561',3002.40,0.00,0.00,4.17,287.73,'2023-02-13 08:13:37','',''),(2636,'1','310','1',1,'Retail Sale Id 2562',3600.00,0.00,0.00,5.00,345.00,'2023-02-13 08:27:18','',''),(2637,'1','310','1',1,'Retail Sale Id 2563',2001.60,0.00,0.00,2.78,191.82,'2023-02-13 08:35:21','',''),(2638,'1','310','1',1,'Retail Sale Id 2564',720.00,0.00,0.00,1.00,69.00,'2023-02-13 09:06:49','',''),(2639,'1','310','1',1,'Retail Sale Id 2566',9000.00,0.00,0.00,12.50,862.50,'2023-02-13 09:12:18','',''),(2640,'1','310','1',1,'Retail Sale Id 2567',9000.00,0.00,0.00,12.50,862.50,'2023-02-13 09:28:11','',''),(2641,'1','310','1',1,'Retail Sale Id 2568',748.80,0.00,0.00,1.04,71.76,'2023-02-13 09:31:01','',''),(2642,'1','310','1',1,'Retail Sale Id 2569',4320.00,0.00,0.00,6.00,414.00,'2023-02-13 09:46:34','',''),(2643,'1','310','1',1,'Retail Sale Id 2570',9000.00,0.00,0.00,12.50,862.50,'2023-02-13 09:49:58','',''),(2644,'1','310','1',1,'Retail Sale Id 2571',42000.00,0.00,0.00,60.00,2940.00,'2023-02-13 10:36:14','',''),(2645,'1','310','1',1,'Retail Sale Id 2572',2160.00,0.00,0.00,3.00,207.00,'2023-02-13 11:04:26','',''),(2646,'1','310','1',1,'Retail Sale Id 2572',9000.00,0.00,0.00,12.50,862.50,'2023-02-13 11:04:26','',''),(2647,'1','310','1',1,'Retail Sale Id 2573',4320.00,0.00,0.00,6.00,414.00,'2023-02-13 11:06:38','',''),(2648,'1','310','1',1,'Retail Sale Id 2573',4320.00,0.00,0.00,6.00,414.00,'2023-02-13 11:06:38','',''),(2649,'1','310','1',1,'Retail Sale Id 2574',4298.40,0.00,0.00,5.97,411.93,'2023-02-13 11:27:52','',''),(2650,'1','310','1',1,'Retail Sale Id 2574',7200.00,0.00,0.00,10.00,690.00,'2023-02-13 11:27:52','',''),(2651,'1','310','1',1,'Retail Sale Id 2575',2001.60,0.00,0.00,2.78,191.82,'2023-02-13 11:30:13','',''),(2652,'1','310','1',1,'Retail Sale Id 2576',2160.00,0.00,0.00,3.00,207.00,'2023-02-13 11:33:19','',''),(2653,'1','310','1',1,'Retail Sale Id 2577',2001.60,0.00,0.00,2.78,191.82,'2023-02-13 11:34:29','',''),(2654,'1','310','1',1,'Retail Sale Id 2578',2880.00,0.00,0.00,4.00,276.00,'2023-02-13 11:38:38','',''),(2655,'1','310','1',1,'Retail Sale Id 2579',1497.60,0.00,0.00,2.08,143.52,'2023-02-13 11:39:45','',''),(2656,'1','310','1',1,'Retail Sale Id 2580',3002.40,0.00,0.00,4.17,287.73,'2023-02-13 11:41:20','',''),(2657,'1','310','1',1,'Retail Sale Id 2582',1000.80,0.00,0.00,1.39,95.91,'2023-02-13 12:05:42','',''),(2658,'1','310','1',1,'Retail Sale Id 2583',9000.00,0.00,0.00,12.50,862.50,'2023-02-13 12:07:20','',''),(2659,'1','310','1',1,'Retail Sale Id 2584',1000.80,0.00,0.00,1.39,95.91,'2023-02-13 12:17:39','',''),(2660,'1','310','1',1,'Retail Sale Id 2585',5400.00,0.00,0.00,7.50,517.50,'2023-02-13 12:19:23','',''),(2661,'1','310','1',1,'Retail Sale Id 2585',9000.00,0.00,0.00,12.50,862.50,'2023-02-13 12:19:23','',''),(2662,'1','310','1',1,'Retail Sale Id 2586',9000.00,0.00,0.00,12.50,862.50,'2023-02-13 12:20:17','',''),(2663,'1','310','1',1,'Retail Sale Id 2587',9100.00,0.00,0.00,13.00,637.00,'2023-02-13 12:22:41','',''),(2664,'1','310','1',1,'Retail Sale Id 2588',2001.60,0.00,0.00,2.78,191.82,'2023-02-13 13:50:46','',''),(2665,'1','310','1',1,'Retail Sale Id 2589',9000.00,0.00,0.00,12.50,862.50,'2023-02-13 14:00:08','',''),(2666,'1','310','1',1,'Retail Sale Id 2589',9000.00,0.00,0.00,12.50,862.50,'2023-02-13 14:00:08','',''),(2667,'1','310','1',1,'Retail Sale Id 2590',2880.00,0.00,0.00,4.00,276.00,'2023-02-13 14:14:29','',''),(2668,'1','310','1',1,'Retail Sale Id 2591',105000.00,0.00,0.00,150.00,7350.00,'2023-02-13 14:36:14','',''),(2669,'1','310','1',1,'Retail Sale Id 2592',105000.00,0.00,0.00,150.00,7350.00,'2023-02-13 14:37:33','',''),(2670,'1','310','1',1,'Retail Sale Id 2593',105000.00,0.00,0.00,150.00,7350.00,'2023-02-13 14:38:53','',''),(2671,'1','310','1',1,'Retail Sale Id 2594',5103.00,0.00,0.00,7.29,357.21,'2023-02-13 14:44:23','',''),(2672,'1','310','1',1,'Retail Sale Id 2595',3600.00,0.00,0.00,5.00,345.00,'2023-02-13 14:45:55','',''),(2673,'1','310','1',1,'Retail Sale Id 2596',4003.20,0.00,0.00,5.56,383.64,'2023-02-13 15:02:17','',''),(2674,'1','310','1',1,'Retail Sale Id 2597',2001.60,0.00,0.00,2.78,191.82,'2023-02-13 15:15:27','',''),(2675,'1','310','1',1,'Retail Sale Id 2598',2102.40,0.00,0.00,2.92,201.48,'2023-02-13 15:21:23','',''),(2676,'1','310','1',1,'Retail Sale Id 2599',496.80,0.00,0.00,0.69,47.61,'2023-02-13 15:29:22','',''),(2677,'1','310','1',1,'Retail Sale Id 2600',52500.00,0.00,0.00,75.00,3675.00,'2023-02-13 15:36:52','',''),(2678,'1','310','1',1,'Retail Sale Id 2601',4320.00,0.00,0.00,6.00,414.00,'2023-02-13 15:38:41','',''),(2679,'1','310','1',1,'Retail Sale Id 2602',5040.00,0.00,0.00,7.00,483.00,'2023-02-13 15:40:17','',''),(2680,'1','310','1',1,'Retail Sale Id 2603',3002.40,0.00,0.00,4.17,287.73,'2023-02-13 15:46:56','',''),(2681,'1','310','1',1,'Retail Sale Id 2604',1497.60,0.00,0.00,2.08,143.52,'2023-02-13 15:52:55','',''),(2682,'1','310','1',1,'Retail Sale Id 2605',4320.00,0.00,0.00,6.00,414.00,'2023-02-13 16:07:20','',''),(2683,'1','310','1',1,'Retail Sale Id 2607',4298.40,0.00,0.00,5.97,411.93,'2023-02-13 16:08:44','',''),(2684,'1','310','1',1,'Retail Sale Id 2608',105000.00,0.00,0.00,150.00,7350.00,'2023-02-13 16:24:43','',''),(2685,'1','310','1',1,'Retail Sale Id 2609',496.80,0.00,0.00,0.69,47.61,'2023-02-13 16:25:51','',''),(2686,'1','310','1',1,'Retail Sale Id 2610',1000.80,0.00,0.00,1.39,95.91,'2023-02-13 16:27:16','',''),(2687,'1','310','1',1,'Retail Sale Id 2611',4320.00,0.00,0.00,6.00,414.00,'2023-02-13 16:28:11','',''),(2688,'1','310','1',1,'Retail Sale Id 2612',9000.00,0.00,0.00,12.50,862.50,'2023-02-13 16:29:22','',''),(2689,'1','310','1',1,'Retail Sale Id 2612',9000.00,0.00,0.00,12.50,862.50,'2023-02-13 16:29:22','',''),(2690,'1','310','1',1,'Retail Sale Id 2613',597.60,0.00,0.00,0.83,57.27,'2023-02-13 16:30:12','',''),(2691,'1','310','1',1,'Retail Sale Id 2614',2203.20,0.00,0.00,3.06,211.14,'2023-02-13 16:30:54','',''),(2692,'1','310','1',1,'Retail Sale Id 2615',3002.40,0.00,0.00,4.17,287.73,'2023-02-13 16:31:48','',''),(2693,'1','310','1',1,'Retail Sale Id 2616',496.80,0.00,0.00,0.69,47.61,'2023-02-13 16:45:16','',''),(2694,'1','310','1',1,'Retail Sale Id 2617',1000.80,0.00,0.00,1.39,95.91,'2023-02-13 16:46:02','',''),(2695,'1','310','1',1,'Retail Sale Id 2618',4003.20,0.00,0.00,5.56,383.64,'2023-02-13 16:47:12','',''),(2696,'1','310','1',1,'Retail Sale Id 2619',4320.00,0.00,0.00,6.00,414.00,'2023-02-13 16:48:05','',''),(2697,'1','310','1',1,'Retail Sale Id 2621',2203.20,0.00,0.00,3.06,211.14,'2023-02-13 16:49:07','',''),(2698,'1','310','1',1,'Retail Sale Id 2622',4500.00,0.00,0.00,6.25,431.25,'2023-02-13 16:51:44','',''),(2699,'1','310','1',1,'Retail Sale Id 2623',1497.60,0.00,0.00,2.08,143.52,'2023-02-13 16:52:18','',''),(2700,'1','310','1',1,'Retail Sale Id 2624',35000.00,0.00,0.00,50.00,2450.00,'2023-02-13 16:55:34','',''),(2701,'1','310','1',1,'Retail Sale Id 2626',1000.80,0.00,0.00,1.39,95.91,'2023-02-13 16:56:49','',''),(2702,'1','310','1',1,'Retail Sale Id 2627',4320.00,0.00,0.00,6.00,414.00,'2023-02-13 16:57:41','',''),(2703,'1','310','1',1,'Retail Sale Id 2628',2203.20,0.00,0.00,3.06,211.14,'2023-02-13 17:06:53','',''),(2704,'1','310','1',1,'Retail Sale Id 2629',2160.00,0.00,0.00,3.00,207.00,'2023-02-13 17:10:59','',''),(2705,'1','310','1',1,'Retail Sale Id 2630',2001.60,0.00,0.00,2.78,191.82,'2023-02-13 17:14:15','',''),(2706,'1','310','1',1,'Retail Sale Id 2631',1000.80,0.00,0.00,1.39,95.91,'2023-02-13 17:15:40','',''),(2707,'1','310','1',1,'Retail Sale Id 2632',1000.80,0.00,0.00,1.39,95.91,'2023-02-13 17:20:12','',''),(2708,'1','310','1',1,'Retail Sale Id 2633',9800.00,0.00,0.00,14.00,686.00,'2023-02-13 17:44:02','',''),(2709,'1','310','1',1,'Retail Sale Id 2634',4996.80,0.00,0.00,6.94,478.86,'2023-02-13 17:46:30','',''),(2710,'1','310','1',1,'Retail Sale Id 2635',2001.60,0.00,0.00,2.78,191.82,'2023-02-13 17:49:45','',''),(2711,'1','310','1',1,'Retail Sale Id 2636',698.40,0.00,0.00,0.97,66.93,'2023-02-13 17:53:50','',''),(2712,'1','310','1',1,'Retail Sale Id 2637',1101.60,0.00,0.00,1.53,105.57,'2023-02-13 18:01:56','',''),(2713,'1','310','1',1,'Retail Sale Id 2638',2160.00,0.00,0.00,3.00,207.00,'2023-02-13 18:07:34','',''),(2714,'1','310','1',1,'Retail Sale Id 2639',1000.80,0.00,0.00,1.39,95.91,'2023-02-13 18:08:30','',''),(2715,'1','310','1',1,'Retail Sale Id 2640',3600.00,0.00,0.00,5.00,345.00,'2023-02-13 18:12:15','',''),(2716,'1','310','1',1,'Retail Sale Id 2640',7200.00,0.00,0.00,10.00,690.00,'2023-02-13 18:12:15','',''),(2717,'1','310','1',1,'Retail Sale Id 2641',2001.60,0.00,0.00,2.78,191.82,'2023-02-13 18:13:05','',''),(2718,'1','310','1',1,'Retail Sale Id 2642',1497.60,0.00,0.00,2.08,143.52,'2023-02-13 18:16:57','',''),(2719,'1','310','1',1,'Retail Sale Id 2643',2160.00,0.00,0.00,3.00,207.00,'2023-02-13 18:21:36','',''),(2720,'1','310','1',1,'Retail Sale Id 2644',2160.00,0.00,0.00,3.00,207.00,'2023-02-13 18:23:21','',''),(2721,'1','310','1',1,'Retail Sale Id 2645',5040.00,0.00,0.00,7.00,483.00,'2023-02-13 18:32:49','',''),(2722,'1','310','1',1,'Retail Sale Id 2647',8750.00,0.00,0.00,12.50,612.50,'2023-02-13 18:35:04','',''),(2723,'1','310','1',1,'Retail Sale Id 2648',70000.00,0.00,0.00,100.00,4900.00,'2023-02-13 18:36:03','',''),(2724,'1','310','1',1,'Retail Sale Id 2650',70000.00,0.00,0.00,100.00,4900.00,'2023-02-13 18:37:28','',''),(2725,'1','310','1',1,'Return of Retail Sale Id 2612',0.00,9000.00,12.50,0.00,-862.50,'2023-02-13 19:04:21','',''),(2726,'1','310','1',1,'Return of Retail Sale Id 2612',0.00,9000.00,12.50,0.00,-862.50,'2023-02-13 19:04:21','',''),(2727,'1','310','1',1,'Retail Sale Id 2651',1893.60,0.00,0.00,2.63,181.47,'2023-02-13 19:04:59','',''),(2728,'1','310','1',1,'Return of Retail Sale Id 2594',0.00,5103.00,7.29,0.00,-357.21,'2023-02-13 19:06:05','',''),(2729,'1','310','1',1,'Retail Sale Id 2652',5103.00,0.00,0.00,7.29,357.21,'2023-02-13 19:07:22','',''),(2730,'1','310','1',1,'Retail Sale Id 2653',2001.60,0.00,0.00,2.78,191.82,'2023-02-14 07:37:37','',''),(2731,'1','310','1',1,'Retail Sale Id 2655',2001.60,0.00,0.00,2.78,191.82,'2023-02-14 07:58:07','',''),(2732,'1','310','1',1,'Retail Sale Id 2656',4500.00,0.00,0.00,6.25,431.25,'2023-02-14 08:03:22','',''),(2733,'1','310','1',1,'Retail Sale Id 2657',3600.00,0.00,0.00,5.00,345.00,'2023-02-14 08:11:10','',''),(2734,'1','310','1',1,'Retail Sale Id 2657',9000.00,0.00,0.00,12.50,862.50,'2023-02-14 08:11:10','',''),(2735,'1','310','1',1,'Retail Sale Id 2658',9000.00,0.00,0.00,12.50,862.50,'2023-02-14 08:32:09','',''),(2736,'1','310','1',1,'Retail Sale Id 2659',9000.00,0.00,0.00,12.50,862.50,'2023-02-14 08:33:48','',''),(2737,'1','310','1',1,'Retail Sale Id 2661',1497.60,0.00,0.00,2.08,143.52,'2023-02-14 08:40:21','',''),(2738,'1','310','1',1,'Retail Sale Id 2662',720.00,0.00,0.00,1.00,69.00,'2023-02-14 08:41:52','',''),(2739,'1','310','1',1,'Retail Sale Id 2663',9000.00,0.00,0.00,12.50,862.50,'2023-02-14 09:11:08','',''),(2740,'1','310','1',1,'Retail Sale Id 2665',8400.00,0.00,0.00,12.00,588.00,'2023-02-14 09:18:42','',''),(2741,'1','310','1',1,'Retail Sale Id 2667',4996.80,0.00,0.00,6.94,478.86,'2023-02-14 09:26:09','',''),(2742,'1','310','1',1,'Retail Sale Id 2668',4320.00,0.00,0.00,6.00,414.00,'2023-02-14 09:26:49','',''),(2743,'1','310','1',1,'Retail Sale Id 2669',4320.00,0.00,0.00,6.00,414.00,'2023-02-14 09:28:02','',''),(2744,'1','310','1',1,'Retail Sale Id 2670',2880.00,0.00,0.00,4.00,276.00,'2023-02-14 09:29:16','',''),(2745,'1','310','1',1,'Retail Sale Id 2672',3002.40,0.00,0.00,4.17,287.73,'2023-02-14 09:32:31','',''),(2746,'1','310','1',1,'Retail Sale Id 2673',144900.00,0.00,0.00,207.00,10143.00,'2023-02-14 09:45:19','',''),(2747,'1','310','1',1,'Retail Sale Id 2674',7200.00,0.00,0.00,10.00,690.00,'2023-02-14 09:46:53','',''),(2748,'1','310','1',1,'Retail Sale Id 2675',1000.80,0.00,0.00,1.39,95.91,'2023-02-14 09:53:38','',''),(2749,'1','310','1',1,'Retail Sale Id 2676',4320.00,0.00,0.00,6.00,414.00,'2023-02-14 09:57:18','',''),(2750,'1','310','1',1,'Retail Sale Id 2677',7200.00,0.00,0.00,10.00,690.00,'2023-02-14 10:23:20','',''),(2751,'1','310','1',1,'Retail Sale Id 2678',4003.20,0.00,0.00,5.56,383.64,'2023-02-14 10:24:52','',''),(2752,'1','310','1',1,'Retail Sale Id 2679',9000.00,0.00,0.00,12.50,862.50,'2023-02-14 10:26:00','',''),(2753,'1','310','1',1,'Retail Sale Id 2680',3002.40,0.00,0.00,4.17,287.73,'2023-02-14 10:29:55','',''),(2754,'1','310','1',1,'Retail Sale Id 2681',5760.00,0.00,0.00,8.00,552.00,'2023-02-14 10:31:20','',''),(2755,'1','310','1',1,'Retail Sale Id 2682',4320.00,0.00,0.00,6.00,414.00,'2023-02-14 10:32:25','',''),(2756,'1','310','1',1,'Retail Sale Id 2683',4320.00,0.00,0.00,6.00,414.00,'2023-02-14 10:33:37','',''),(2757,'1','310','1',1,'Retail Sale Id 2684',3600.00,0.00,0.00,5.00,345.00,'2023-02-14 10:35:28','',''),(2758,'1','310','1',1,'Return of Retail Sale Id 2674',0.00,7200.00,10.00,0.00,-690.00,'2023-02-14 10:38:22','',''),(2759,'1','310','1',1,'Retail Sale Id 2685',3600.00,0.00,0.00,5.00,345.00,'2023-02-14 10:41:50','',''),(2760,'1','310','1',1,'Retail Sale Id 2686',2001.60,0.00,0.00,2.78,191.82,'2023-02-14 10:46:58','',''),(2761,'1','310','1',1,'Retail Sale Id 2687',35000.00,0.00,0.00,50.00,2450.00,'2023-02-14 10:48:42','',''),(2762,'1','310','1',1,'Retail Sale Id 2688',4320.00,0.00,0.00,6.00,414.00,'2023-02-14 10:50:57','',''),(2763,'1','310','1',1,'Retail Sale Id 2689',3600.00,0.00,0.00,5.00,345.00,'2023-02-14 10:53:15','',''),(2764,'1','310','1',1,'Retail Sale Id 2690',4320.00,0.00,0.00,6.00,414.00,'2023-02-14 10:59:56','',''),(2765,'1','310','1',1,'Retail Sale Id 2691',4320.00,0.00,0.00,6.00,414.00,'2023-02-14 11:07:45','',''),(2766,'1','310','1',1,'Retail Sale Id 2692',5997.60,0.00,0.00,8.33,574.77,'2023-02-14 11:11:01','',''),(2767,'1','310','1',1,'Retail Sale Id 2692',5997.60,0.00,0.00,8.33,574.77,'2023-02-14 11:11:01','',''),(2768,'1','310','1',1,'Retail Sale Id 2693',3600.00,0.00,0.00,5.00,345.00,'2023-02-14 11:13:45','',''),(2769,'1','310','1',1,'Retail Sale Id 2694',7200.00,0.00,0.00,10.00,690.00,'2023-02-14 11:15:00','',''),(2770,'1','310','1',1,'Retail Sale Id 2695',2880.00,0.00,0.00,4.00,276.00,'2023-02-14 11:16:40','',''),(2771,'1','310','1',1,'Retail Sale Id 2696',4320.00,0.00,0.00,6.00,414.00,'2023-02-14 11:21:38','',''),(2772,'1','310','1',1,'Retail Sale Id 2697',1598.40,0.00,0.00,2.22,153.18,'2023-02-14 11:23:09','',''),(2773,'1','310','1',1,'Retail Sale Id 2698',7200.00,0.00,0.00,10.00,690.00,'2023-02-14 11:24:09','',''),(2774,'1','310','1',1,'Retail Sale Id 2699',3002.40,0.00,0.00,4.17,287.73,'2023-02-14 11:25:01','',''),(2775,'1','310','1',1,'Retail Sale Id 2700',1000.80,0.00,0.00,1.39,95.91,'2023-02-14 11:35:16','',''),(2776,'1','310','1',1,'Retail Sale Id 2701',4003.20,0.00,0.00,5.56,383.64,'2023-02-14 11:42:43','',''),(2777,'1','310','1',1,'Retail Sale Id 2702',1000.80,0.00,0.00,1.39,95.91,'2023-02-14 11:43:34','',''),(2778,'1','310','1',1,'Retail Sale Id 2703',7200.00,0.00,0.00,10.00,690.00,'2023-02-14 11:45:31','',''),(2779,'1','310','1',1,'Retail Sale Id 2704',2001.60,0.00,0.00,2.78,191.82,'2023-02-14 11:53:45','',''),(2780,'1','310','1',1,'Retail Sale Id 2705',9000.00,0.00,0.00,12.50,862.50,'2023-02-14 11:58:45','',''),(2781,'1','310','1',1,'Retail Sale Id 2706',7700.00,0.00,0.00,11.00,539.00,'2023-02-14 12:06:28','',''),(2782,'1','310','1',1,'Retail Sale Id 2708',698.40,0.00,0.00,0.97,66.93,'2023-02-14 12:15:36','',''),(2783,'1','310','1',1,'Retail Sale Id 2709',70000.00,0.00,0.00,100.00,4900.00,'2023-02-14 12:16:25','',''),(2784,'1','310','1',1,'Retail Sale Id 2710',9000.00,0.00,0.00,12.50,862.50,'2023-02-14 12:17:13','',''),(2785,'1','310','1',1,'Retail Sale Id 2711',2001.60,0.00,0.00,2.78,191.82,'2023-02-14 12:17:57','',''),(2786,'1','310','1',1,'Retail Sale Id 2712',1447.20,0.00,0.00,2.01,138.69,'2023-02-14 12:19:03','',''),(2787,'1','310','1',1,'Retail Sale Id 2713',2203.20,0.00,0.00,3.06,211.14,'2023-02-14 12:19:49','',''),(2788,'1','310','1',1,'Retail Sale Id 2714',1000.80,0.00,0.00,1.39,95.91,'2023-02-14 12:21:32','',''),(2789,'1','310','1',1,'Retail Sale Id 2715',2001.60,0.00,0.00,2.78,191.82,'2023-02-14 12:23:17','',''),(2790,'1','310','1',1,'Retail Sale Id 2716',1677.60,0.00,0.00,2.33,160.77,'2023-02-14 12:28:41','',''),(2791,'1','310','1',1,'Retail Sale Id 2717',2152.80,0.00,0.00,2.99,206.31,'2023-02-14 12:32:03','',''),(2792,'1','310','1',1,'Retail Sale Id 2718',1159.20,0.00,0.00,1.61,111.09,'2023-02-14 12:33:32','',''),(2793,'1','310','1',1,'Retail Sale Id 2719',1648.80,0.00,0.00,2.29,158.01,'2023-02-14 12:34:34','',''),(2794,'1','310','1',1,'Return of Retail Sale Id 2718',0.00,1159.20,1.61,0.00,-111.09,'2023-02-14 12:35:55','',''),(2795,'1','310','1',1,'Retail Sale Id 2720',4320.00,0.00,0.00,6.00,414.00,'2023-02-14 12:45:32','',''),(2796,'1','310','1',1,'Retail Sale Id 2721',1447.20,0.00,0.00,2.01,138.69,'2023-02-14 12:48:36','',''),(2797,'1','310','1',1,'Retail Sale Id 2722',2160.00,0.00,0.00,3.00,207.00,'2023-02-14 12:58:39','',''),(2798,'1','310','1',1,'Retail Sale Id 2723',1497.60,0.00,0.00,2.08,143.52,'2023-02-14 12:59:27','',''),(2799,'1','310','1',1,'Retail Sale Id 2724',1497.60,0.00,0.00,2.08,143.52,'2023-02-14 13:00:35','',''),(2800,'1','310','1',1,'Retail Sale Id 2725',9000.00,0.00,0.00,12.50,862.50,'2023-02-14 13:02:10','',''),(2801,'1','310','1',1,'Retail Sale Id 2726',4003.20,0.00,0.00,5.56,383.64,'2023-02-14 13:03:17','',''),(2802,'1','310','1',1,'Retail Sale Id 2727',3002.40,0.00,0.00,4.17,287.73,'2023-02-14 13:05:14','',''),(2803,'1','310','1',1,'Retail Sale Id 2728',1497.60,0.00,0.00,2.08,143.52,'2023-02-14 13:06:28','',''),(2804,'1','310','1',1,'Retail Sale Id 2728',1497.60,0.00,0.00,2.08,143.52,'2023-02-14 13:06:28','',''),(2805,'1','310','1',1,'Retail Sale Id 2729',2160.00,0.00,0.00,3.00,207.00,'2023-02-14 13:09:29','',''),(2806,'1','310','1',1,'Retail Sale Id 2730',2160.00,0.00,0.00,3.00,207.00,'2023-02-14 13:17:03','',''),(2807,'1','310','1',1,'Retail Sale Id 2731',4200.00,0.00,0.00,6.00,294.00,'2023-02-14 13:19:42','',''),(2808,'1','310','1',1,'Retail Sale Id 2732',2498.40,0.00,0.00,3.47,239.43,'2023-02-14 13:21:57','',''),(2809,'1','310','1',1,'Retail Sale Id 2733',2203.20,0.00,0.00,3.06,211.14,'2023-02-14 13:22:49','',''),(2810,'1','310','1',1,'Retail Sale Id 2734',9000.00,0.00,0.00,12.50,862.50,'2023-02-14 13:52:57','',''),(2811,'1','310','1',1,'Retail Sale Id 2734',9000.00,0.00,0.00,12.50,862.50,'2023-02-14 13:52:57','',''),(2812,'1','310','1',1,'Retail Sale Id 2735',4320.00,0.00,0.00,6.00,414.00,'2023-02-14 14:08:52','',''),(2813,'1','310','1',1,'Retail Sale Id 2736',4320.00,0.00,0.00,6.00,414.00,'2023-02-14 14:19:37','',''),(2814,'1','310','1',1,'Retail Sale Id 2737',44100.00,0.00,0.00,63.00,3087.00,'2023-02-14 14:26:51','',''),(2815,'1','310','1',1,'Retail Sale Id 2738',8750.00,0.00,0.00,12.50,612.50,'2023-02-14 14:30:34','',''),(2816,'1','310','1',1,'Retail Sale Id 2739',4500.00,0.00,0.00,6.25,431.25,'2023-02-14 14:46:08','',''),(2817,'1','310','1',1,'Retail Sale Id 2740',9000.00,0.00,0.00,12.50,862.50,'2023-02-14 15:02:04','',''),(2818,'1','310','1',1,'Retail Sale Id 2741',9000.00,0.00,0.00,12.50,862.50,'2023-02-14 15:04:24','',''),(2819,'1','310','1',1,'Retail Sale Id 2742',1000.80,0.00,0.00,1.39,95.91,'2023-02-14 15:10:44','',''),(2820,'1','310','1',1,'Retail Sale Id 2743',1000.80,0.00,0.00,1.39,95.91,'2023-02-14 15:11:54','',''),(2821,'1','310','1',1,'Retail Sale Id 2744',3600.00,0.00,0.00,5.00,345.00,'2023-02-14 15:20:13','',''),(2822,'1','310','1',1,'Retail Sale Id 2745',3600.00,0.00,0.00,5.00,345.00,'2023-02-14 15:20:46','',''),(2823,'1','310','1',1,'Return of Retail Sale Id 2744',0.00,3600.00,5.00,0.00,-345.00,'2023-02-14 15:22:24','',''),(2824,'1','310','1',1,'Retail Sale Id 2746',7200.00,0.00,0.00,10.00,690.00,'2023-02-14 15:26:17','',''),(2825,'1','310','1',1,'Retail Sale Id 2747',1497.60,0.00,0.00,2.08,143.52,'2023-02-14 15:27:16','',''),(2826,'1','310','1',1,'Retail Sale Id 2748',2001.60,0.00,0.00,2.78,191.82,'2023-02-14 15:37:00','',''),(2827,'1','310','1',1,'Retail Sale Id 2749',1202.40,0.00,0.00,1.67,115.23,'2023-02-14 15:46:16','',''),(2828,'1','310','1',1,'Retail Sale Id 2750',1497.60,0.00,0.00,2.08,143.52,'2023-02-14 15:47:33','',''),(2829,'1','310','1',1,'Retail Sale Id 2751',9000.00,0.00,0.00,12.50,862.50,'2023-02-14 15:48:59','',''),(2830,'1','310','1',1,'Retail Sale Id 2752',2203.20,0.00,0.00,3.06,211.14,'2023-02-14 16:12:01','',''),(2831,'1','310','1',1,'Retail Sale Id 2752',7200.00,0.00,0.00,10.00,690.00,'2023-02-14 16:12:01','',''),(2832,'1','310','1',1,'Retail Sale Id 2753',4701.60,0.00,0.00,6.53,450.57,'2023-02-14 18:15:52','',''),(2833,'1','310','1',1,'Retail Sale Id 2754',2001.60,0.00,0.00,2.78,191.82,'2023-02-14 18:18:35','',''),(2834,'1','310','1',1,'Retail Sale Id 2755',70000.00,0.00,0.00,100.00,4900.00,'2023-02-14 18:19:22','',''),(2835,'1','310','1',1,'Retail Sale Id 2756',70000.00,0.00,0.00,100.00,4900.00,'2023-02-14 18:19:58','',''),(2836,'1','310','1',1,'Retail Sale Id 2757',2160.00,0.00,0.00,3.00,207.00,'2023-02-14 18:20:56','',''),(2837,'1','310','1',1,'Retail Sale Id 2757',9000.00,0.00,0.00,12.50,862.50,'2023-02-14 18:20:56','',''),(2838,'1','310','1',1,'Retail Sale Id 2758',140000.00,0.00,0.00,200.00,9800.00,'2023-02-14 18:21:56','',''),(2839,'1','310','1',1,'Return of Retail Sale Id 2756',0.00,70000.00,100.00,0.00,-4900.00,'2023-02-14 18:22:47','',''),(2840,'1','310','1',1,'Return of Retail Sale Id 2755',0.00,70000.00,100.00,0.00,-4900.00,'2023-02-14 18:23:11','',''),(2841,'1','310','1',1,'Retail Sale Id 2759',1497.60,0.00,0.00,2.08,143.52,'2023-02-14 18:26:18','',''),(2842,'1','310','1',1,'Retail Sale Id 2760',2001.60,0.00,0.00,2.78,191.82,'2023-02-14 18:27:28','',''),(2843,'1','310','1',1,'Retail Sale Id 2761',496.80,0.00,0.00,0.69,47.61,'2023-02-14 18:29:11','',''),(2844,'1','310','1',1,'Retail Sale Id 2763',35000.00,0.00,0.00,50.00,2450.00,'2023-02-14 18:34:37','',''),(2845,'1','310','1',1,'Retail Sale Id 2764',1497.60,0.00,0.00,2.08,143.52,'2023-02-14 18:41:20','',''),(2846,'1','310','1',1,'Retail Sale Id 2765',2001.60,0.00,0.00,2.78,191.82,'2023-02-14 18:42:46','',''),(2847,'1','310','1',1,'Retail Sale Id 2765',2001.60,0.00,0.00,2.78,191.82,'2023-02-14 18:42:46','',''),(2848,'1','310','1',1,'Retail Sale Id 2766',1000.80,0.00,0.00,1.39,95.91,'2023-02-14 18:51:46','',''),(2849,'1','310','1',1,'Retail Sale Id 2767',38232.00,0.00,0.00,53.10,3663.90,'2023-02-14 19:46:51','',''),(2850,'1','310','1',1,'Retail Sale Id 2768',9000.00,0.00,0.00,12.50,862.50,'2023-02-15 08:15:55','',''),(2851,'1','310','1',1,'Retail Sale Id 2769',9000.00,0.00,0.00,12.50,862.50,'2023-02-15 08:16:43','',''),(2852,'1','310','1',1,'Retail Sale Id 2770',4320.00,0.00,0.00,6.00,414.00,'2023-02-15 08:18:37','',''),(2853,'1','310','1',1,'Retail Sale Id 2771',42000.00,0.00,0.00,60.00,2940.00,'2023-02-15 08:19:42','',''),(2854,'1','310','1',1,'Retail Sale Id 2772',273000.00,0.00,0.00,390.00,19110.00,'2023-02-15 08:22:04','',''),(2855,'1','310','1',1,'Retail Sale Id 2773',5997.60,0.00,0.00,8.33,574.77,'2023-02-15 08:48:47','',''),(2856,'1','310','1',1,'Retail Sale Id 2774',2160.00,0.00,0.00,3.00,207.00,'2023-02-15 09:00:40','',''),(2857,'1','310','1',1,'Retail Sale Id 2775',9000.00,0.00,0.00,12.50,862.50,'2023-02-15 09:02:11','',''),(2858,'1','310','1',1,'Retail Sale Id 2776',3002.40,0.00,0.00,4.17,287.73,'2023-02-15 09:04:20','',''),(2859,'1','310','1',1,'Retail Sale Id 2777',2203.20,0.00,0.00,3.06,211.14,'2023-02-15 09:11:03','',''),(2860,'1','310','1',1,'Retail Sale Id 2778',3500.00,0.00,0.00,5.00,245.00,'2023-02-15 09:24:57','',''),(2861,'1','310','1',1,'Retail Sale Id 2779',1000.80,0.00,0.00,1.39,95.91,'2023-02-15 09:35:07','',''),(2862,'1','310','1',1,'Retail Sale Id 2780',4320.00,0.00,0.00,6.00,414.00,'2023-02-15 09:37:24','',''),(2863,'1','310','1',1,'Retail Sale Id 2781',1440.00,0.00,0.00,2.00,138.00,'2023-02-15 09:43:05','',''),(2864,'1','310','1',1,'Retail Sale Id 2782',7200.00,0.00,0.00,10.00,690.00,'2023-02-15 09:45:50','',''),(2865,'1','310','1',1,'Retail Sale Id 2783',9000.00,0.00,0.00,12.50,862.50,'2023-02-15 09:53:31','',''),(2866,'1','310','1',1,'Retail Sale Id 2784',1000.80,0.00,0.00,1.39,95.91,'2023-02-15 09:54:32','',''),(2867,'1','310','1',1,'Retail Sale Id 2785',77000.00,0.00,0.00,110.00,5390.00,'2023-02-15 10:00:46','',''),(2868,'1','310','1',1,'Retail Sale Id 2786',175000.00,0.00,0.00,250.00,12250.00,'2023-02-15 10:03:42','',''),(2869,'1','310','1',1,'Retail Sale Id 2787',1497.60,0.00,0.00,2.08,143.52,'2023-02-15 10:08:20','',''),(2870,'1','310','1',1,'Retail Sale Id 2787',2498.40,0.00,0.00,3.47,239.43,'2023-02-15 10:08:20','',''),(2871,'1','310','1',1,'Retail Sale Id 2787',5997.60,0.00,0.00,8.33,574.77,'2023-02-15 10:08:20','',''),(2872,'1','310','1',1,'Retail Sale Id 2788',4320.00,0.00,0.00,6.00,414.00,'2023-02-15 10:16:02','',''),(2873,'1','310','1',1,'Retail Sale Id 2789',2160.00,0.00,0.00,3.00,207.00,'2023-02-15 10:24:56','',''),(2874,'1','310','1',1,'Retail Sale Id 2790',4320.00,0.00,0.00,6.00,414.00,'2023-02-15 10:28:13','',''),(2875,'1','310','1',1,'Retail Sale Id 2791',12950.00,0.00,0.00,18.50,906.50,'2023-02-15 10:32:56','',''),(2876,'1','310','1',1,'Retail Sale Id 2792',4320.00,0.00,0.00,6.00,414.00,'2023-02-15 10:35:28','',''),(2877,'1','310','1',1,'Retail Sale Id 2793',4320.00,0.00,0.00,6.00,414.00,'2023-02-15 10:37:39','',''),(2878,'1','310','1',1,'Retail Sale Id 2793',9000.00,0.00,0.00,12.50,862.50,'2023-02-15 10:37:39','',''),(2879,'1','310','1',1,'Retail Sale Id 2794',3002.40,0.00,0.00,4.17,287.73,'2023-02-15 10:45:25','',''),(2880,'1','310','1',1,'Retail Sale Id 2795',105000.00,0.00,0.00,150.00,7350.00,'2023-02-15 10:53:33','',''),(2881,'1','310','1',1,'Retail Sale Id 2796',3600.00,0.00,0.00,5.00,345.00,'2023-02-15 10:55:07','',''),(2882,'1','310','1',1,'Retail Sale Id 2797',4996.80,0.00,0.00,6.94,478.86,'2023-02-15 10:59:36','',''),(2883,'1','310','1',1,'Retail Sale Id 2798',35000.00,0.00,0.00,50.00,2450.00,'2023-02-15 11:08:00','',''),(2884,'1','310','1',1,'Retail Sale Id 2799',1000.80,0.00,0.00,1.39,95.91,'2023-02-15 11:19:26','',''),(2885,'1','310','1',1,'Retail Sale Id 2800',9000.00,0.00,0.00,12.50,862.50,'2023-02-15 11:22:23','',''),(2886,'1','310','1',1,'Retail Sale Id 2801',2152.80,0.00,0.00,2.99,206.31,'2023-02-15 11:32:19','',''),(2887,'1','310','1',1,'Retail Sale Id 2801',2152.80,0.00,0.00,2.99,206.31,'2023-02-15 11:32:19','',''),(2888,'1','310','1',1,'Retail Sale Id 2802',157500.00,0.00,0.00,225.00,11025.00,'2023-02-15 11:36:50','',''),(2889,'1','310','1',1,'Retail Sale Id 2803',1000.80,0.00,0.00,1.39,95.91,'2023-02-15 11:41:09','',''),(2890,'1','310','1',1,'Retail Sale Id 2804',2160.00,0.00,0.00,3.00,207.00,'2023-02-15 11:55:17','',''),(2891,'1','310','1',1,'Retail Sale Id 2805',3600.00,0.00,0.00,5.00,345.00,'2023-02-15 12:03:51','',''),(2892,'1','310','1',1,'Retail Sale Id 2806',3002.40,0.00,0.00,4.17,287.73,'2023-02-15 12:06:26','',''),(2893,'1','310','1',1,'Retail Sale Id 2807',9000.00,0.00,0.00,12.50,862.50,'2023-02-15 12:12:29','',''),(2894,'1','310','1',1,'Retail Sale Id 2808',2001.60,0.00,0.00,2.78,191.82,'2023-02-15 12:20:18','',''),(2895,'1','310','1',1,'Retail Sale Id 2809',1497.60,0.00,0.00,2.08,143.52,'2023-02-15 12:50:45','',''),(2896,'1','310','1',1,'Retail Sale Id 2810',21000.00,0.00,0.00,30.00,1470.00,'2023-02-15 12:55:38','',''),(2897,'1','310','1',1,'Retail Sale Id 2811',105000.00,0.00,0.00,150.00,7350.00,'2023-02-15 12:59:05','',''),(2898,'1','310','1',1,'Retail Sale Id 2812',52500.00,0.00,0.00,75.00,3675.00,'2023-02-15 13:17:35','',''),(2899,'1','310','1',1,'Retail Sale Id 2813',4320.00,0.00,0.00,6.00,414.00,'2023-02-15 13:29:18','',''),(2900,'1','310','1',1,'Retail Sale Id 2814',3002.40,0.00,0.00,4.17,287.73,'2023-02-15 13:32:28','',''),(2901,'1','310','1',1,'Retail Sale Id 2815',5997.60,0.00,0.00,8.33,574.77,'2023-02-15 13:33:55','',''),(2902,'1','310','1',1,'Retail Sale Id 2816',9000.00,0.00,0.00,12.50,862.50,'2023-02-15 13:41:59','',''),(2903,'1','310','1',1,'Retail Sale Id 2817',2160.00,0.00,0.00,3.00,207.00,'2023-02-15 13:49:23','',''),(2904,'1','310','1',1,'Retail Sale Id 2817',2160.00,0.00,0.00,3.00,207.00,'2023-02-15 13:49:23','',''),(2905,'1','310','1',1,'Retail Sale Id 2818',1000.80,0.00,0.00,1.39,95.91,'2023-02-15 13:50:41','',''),(2906,'1','310','1',1,'Retail Sale Id 2819',4320.00,0.00,0.00,6.00,414.00,'2023-02-15 13:53:17','',''),(2907,'1','310','1',1,'Retail Sale Id 2820',4320.00,0.00,0.00,6.00,414.00,'2023-02-15 14:00:07','',''),(2908,'1','310','1',1,'Retail Sale Id 2821',4320.00,0.00,0.00,6.00,414.00,'2023-02-15 14:28:54','',''),(2909,'1','310','1',1,'Retail Sale Id 2822',2700.00,0.00,0.00,3.75,258.75,'2023-02-15 14:33:18','',''),(2910,'1','310','1',1,'Retail Sale Id 2823',1497.60,0.00,0.00,2.08,143.52,'2023-02-15 14:35:34','',''),(2911,'1','310','1',1,'Retail Sale Id 2824',4320.00,0.00,0.00,6.00,414.00,'2023-02-15 14:41:23','',''),(2912,'1','310','1',1,'Retail Sale Id 2825',1000.80,0.00,0.00,1.39,95.91,'2023-02-15 14:44:30','',''),(2913,'1','310','1',1,'Retail Sale Id 2826',9000.00,0.00,0.00,12.50,862.50,'2023-02-15 14:56:40','',''),(2914,'1','310','1',1,'Retail Sale Id 2827',4320.00,0.00,0.00,6.00,414.00,'2023-02-15 15:01:20','',''),(2915,'1','310','1',1,'Retail Sale Id 2828',4996.80,0.00,0.00,6.94,478.86,'2023-02-15 15:07:40','',''),(2916,'1','310','1',1,'Retail Sale Id 2828',4996.80,0.00,0.00,6.94,478.86,'2023-02-15 15:07:40','',''),(2917,'1','310','1',1,'Retail Sale Id 2829',1000.80,0.00,0.00,1.39,95.91,'2023-02-15 15:19:05','',''),(2918,'1','310','1',1,'Retail Sale Id 2830',2160.00,0.00,0.00,3.00,207.00,'2023-02-15 15:27:46','',''),(2919,'1','310','1',1,'Retail Sale Id 2831',4197.60,0.00,0.00,5.83,402.27,'2023-02-15 15:33:58','',''),(2920,'1','310','1',1,'Retail Sale Id 2832',4003.20,0.00,0.00,5.56,383.64,'2023-02-15 15:35:01','',''),(2921,'1','310','1',1,'Retail Sale Id 2834',3600.00,0.00,0.00,5.00,345.00,'2023-02-15 15:37:08','',''),(2922,'1','310','1',1,'Retail Sale Id 2835',4320.00,0.00,0.00,6.00,414.00,'2023-02-15 15:38:02','',''),(2923,'1','310','1',1,'Retail Sale Id 2836',9000.00,0.00,0.00,12.50,862.50,'2023-02-15 15:52:19','',''),(2924,'1','310','1',1,'Retail Sale Id 2837',1000.80,0.00,0.00,1.39,95.91,'2023-02-15 16:01:03','',''),(2925,'1','310','1',1,'Retail Sale Id 2838',3600.00,0.00,0.00,5.00,345.00,'2023-02-15 16:16:37','',''),(2926,'1','310','1',1,'Retail Sale Id 2839',133000.00,0.00,0.00,190.00,9310.00,'2023-02-15 16:26:09','',''),(2927,'1','310','1',1,'Retail Sale Id 2840',1000.80,0.00,0.00,1.39,95.91,'2023-02-15 16:33:38','',''),(2928,'1','310','1',1,'Retail Sale Id 2841',35000.00,0.00,0.00,50.00,2450.00,'2023-02-15 16:41:17','',''),(2929,'1','310','1',1,'Retail Sale Id 2842',2160.00,0.00,0.00,3.00,207.00,'2023-02-15 16:56:01','',''),(2930,'1','310','1',1,'Retail Sale Id 2843',9000.00,0.00,0.00,12.50,862.50,'2023-02-15 16:56:46','',''),(2931,'1','310','1',1,'Retail Sale Id 2845',7.20,0.00,0.00,0.01,0.69,'2023-02-15 17:06:55','',''),(2932,'1','310','1',1,'Retail Sale Id 2846',3600.00,0.00,0.00,5.00,345.00,'2023-02-15 17:08:21','',''),(2933,'1','310','1',1,'Return of Retail Sale Id 2842',0.00,2160.00,3.00,0.00,-207.00,'2023-02-15 17:11:04','',''),(2934,'1','310','1',1,'Retail Sale Id 2847',7200.00,0.00,0.00,10.00,690.00,'2023-02-15 17:18:15','',''),(2935,'1','310','1',1,'Retail Sale Id 2848',4320.00,0.00,0.00,6.00,414.00,'2023-02-15 17:22:38','',''),(2936,'1','310','1',1,'Retail Sale Id 2849',4320.00,0.00,0.00,6.00,414.00,'2023-02-15 17:28:54','',''),(2937,'1','310','1',1,'Retail Sale Id 2850',9000.00,0.00,0.00,12.50,862.50,'2023-02-15 17:30:01','',''),(2938,'1','310','1',1,'Retail Sale Id 2851',35000.00,0.00,0.00,50.00,2450.00,'2023-02-15 17:32:35','',''),(2939,'1','310','1',1,'Retail Sale Id 2852',4320.00,0.00,0.00,6.00,414.00,'2023-02-15 17:33:42','',''),(2940,'1','310','1',1,'Retail Sale Id 2853',2498.40,0.00,0.00,3.47,239.43,'2023-02-15 17:38:30','',''),(2941,'1','310','1',1,'Retail Sale Id 2855',5760.00,0.00,0.00,8.00,552.00,'2023-02-15 17:48:04','',''),(2942,'1','310','1',1,'Retail Sale Id 2856',4320.00,0.00,0.00,6.00,414.00,'2023-02-15 17:49:40','',''),(2943,'1','310','1',1,'Retail Sale Id 2857',2203.20,0.00,0.00,3.06,211.14,'2023-02-15 17:58:24','',''),(2944,'1','310','1',1,'Retail Sale Id 2860',2450.00,0.00,0.00,3.50,171.50,'2023-02-15 18:01:37','',''),(2945,'1','310','1',1,'Retail Sale Id 2861',1000.80,0.00,0.00,1.39,95.91,'2023-02-15 18:02:30','',''),(2946,'1','310','1',1,'Retail Sale Id 2862',4320.00,0.00,0.00,6.00,414.00,'2023-02-15 18:04:02','',''),(2947,'1','310','1',1,'Retail Sale Id 2863',35000.00,0.00,0.00,50.00,2450.00,'2023-02-15 18:06:30','',''),(2948,'1','310','1',1,'Retail Sale Id 2864',9000.00,0.00,0.00,12.50,862.50,'2023-02-15 18:08:13','',''),(2949,'1','310','1',1,'Retail Sale Id 2865',4320.00,0.00,0.00,6.00,414.00,'2023-02-15 18:11:54','',''),(2950,'1','310','1',1,'Retail Sale Id 2865',5040.00,0.00,0.00,7.00,483.00,'2023-02-15 18:11:54','',''),(2951,'1','310','1',1,'Retail Sale Id 2868',2160.00,0.00,0.00,3.00,207.00,'2023-02-15 18:22:32','',''),(2952,'1','310','1',1,'Retail Sale Id 2869',3499.20,0.00,0.00,4.86,335.34,'2023-02-15 18:23:39','',''),(2953,'1','310','1',1,'Retail Sale Id 2870',9000.00,0.00,0.00,12.50,862.50,'2023-02-15 18:24:31','',''),(2954,'1','310','1',1,'Retail Sale Id 2871',4320.00,0.00,0.00,6.00,414.00,'2023-02-15 18:25:31','',''),(2955,'1','310','1',1,'Retail Sale Id 2872',1000.80,0.00,0.00,1.39,95.91,'2023-02-15 18:26:33','',''),(2956,'1','310','1',1,'Retail Sale Id 2873',9000.00,0.00,0.00,12.50,862.50,'2023-02-15 18:34:47','',''),(2957,'1','310','1',1,'Retail Sale Id 2874',2880.00,0.00,0.00,4.00,276.00,'2023-02-15 18:54:34','',''),(2958,'1','310','1',1,'Retail Sale Id 2875',2160.00,0.00,0.00,3.00,207.00,'2023-02-16 07:56:58','',''),(2959,'1','310','1',1,'Retail Sale Id 2876',2397.60,0.00,0.00,3.33,229.77,'2023-02-16 08:20:08','',''),(2960,'1','310','1',1,'Retail Sale Id 2877',4320.00,0.00,0.00,6.00,414.00,'2023-02-16 08:21:59','',''),(2961,'1','310','1',1,'Retail Sale Id 2877',4320.00,0.00,0.00,6.00,414.00,'2023-02-16 08:21:59','',''),(2962,'1','310','1',1,'Retail Sale Id 2878',1000.80,0.00,0.00,1.39,95.91,'2023-02-16 08:25:53','',''),(2963,'1','310','1',1,'Retail Sale Id 2879',3600.00,0.00,0.00,5.00,345.00,'2023-02-16 08:27:06','',''),(2964,'1','310','1',1,'Retail Sale Id 2880',5997.60,0.00,0.00,8.33,574.77,'2023-02-16 08:45:54','',''),(2965,'1','310','1',1,'Retail Sale Id 2881',2001.60,0.00,0.00,2.78,191.82,'2023-02-16 09:01:31','',''),(2966,'1','310','1',1,'Retail Sale Id 2882',70000.00,0.00,0.00,100.00,4900.00,'2023-02-16 09:07:41','',''),(2967,'1','310','1',1,'Retail Sale Id 2883',3600.00,0.00,0.00,5.00,345.00,'2023-02-16 09:09:10','',''),(2968,'1','310','1',1,'Retail Sale Id 2884',9000.00,0.00,0.00,12.50,862.50,'2023-02-16 09:15:55','',''),(2969,'1','310','1',1,'Retail Sale Id 2885',9000.00,0.00,0.00,12.50,862.50,'2023-02-16 09:17:54','',''),(2970,'1','310','1',1,'Retail Sale Id 2887',3002.40,0.00,0.00,4.17,287.73,'2023-02-16 09:32:45','',''),(2971,'1','310','1',1,'Retail Sale Id 2888',1497.60,0.00,0.00,2.08,143.52,'2023-02-16 09:41:01','',''),(2972,'1','310','1',1,'Retail Sale Id 2889',720.00,0.00,0.00,1.00,69.00,'2023-02-16 09:51:38','',''),(2973,'1','310','1',1,'Retail Sale Id 2890',2160.00,0.00,0.00,3.00,207.00,'2023-02-16 09:53:12','',''),(2974,'1','310','1',1,'Retail Sale Id 2891',3002.40,0.00,0.00,4.17,287.73,'2023-02-16 09:58:33','',''),(2975,'1','310','1',1,'Retail Sale Id 2893',3600.00,0.00,0.00,5.00,345.00,'2023-02-16 10:08:04','',''),(2976,'1','310','1',1,'Retail Sale Id 2894',4320.00,0.00,0.00,6.00,414.00,'2023-02-16 10:11:14','',''),(2977,'1','310','1',1,'Retail Sale Id 2894',4320.00,0.00,0.00,6.00,414.00,'2023-02-16 10:11:14','',''),(2978,'1','310','1',1,'Retail Sale Id 2894',9000.00,0.00,0.00,12.50,862.50,'2023-02-16 10:11:14','',''),(2979,'1','310','1',1,'Retail Sale Id 2895',2160.00,0.00,0.00,3.00,207.00,'2023-02-16 10:12:06','',''),(2980,'1','310','1',1,'Retail Sale Id 2896',2160.00,0.00,0.00,3.00,207.00,'2023-02-16 10:12:48','',''),(2981,'1','310','1',1,'Retail Sale Id 2897',1000.80,0.00,0.00,1.39,95.91,'2023-02-16 10:13:25','',''),(2982,'1','310','1',1,'Retail Sale Id 2898',2001.60,0.00,0.00,2.78,191.82,'2023-02-16 10:16:58','',''),(2983,'1','310','1',1,'Retail Sale Id 2899',2001.60,0.00,0.00,2.78,191.82,'2023-02-16 10:28:38','',''),(2984,'1','310','1',1,'Retail Sale Id 2900',496.80,0.00,0.00,0.69,47.61,'2023-02-16 10:31:31','',''),(2985,'1','310','1',1,'Retail Sale Id 2901',1101.60,0.00,0.00,1.53,105.57,'2023-02-16 10:34:33','',''),(2986,'1','310','1',1,'Retail Sale Id 2901',2203.20,0.00,0.00,3.06,211.14,'2023-02-16 10:34:33','',''),(2987,'1','310','1',1,'Retail Sale Id 2902',2880.00,0.00,0.00,4.00,276.00,'2023-02-16 10:49:49','',''),(2988,'1','310','1',1,'Retail Sale Id 2903',2160.00,0.00,0.00,3.00,207.00,'2023-02-16 10:54:12','',''),(2989,'1','310','1',1,'Retail Sale Id 2904',140000.00,0.00,0.00,200.00,9800.00,'2023-02-16 10:59:14','',''),(2990,'1','310','1',1,'Retail Sale Id 2905',1000.80,0.00,0.00,1.39,95.91,'2023-02-16 11:16:36','',''),(2991,'1','310','1',1,'Retail Sale Id 2906',1000.80,0.00,0.00,1.39,95.91,'2023-02-16 11:26:13','',''),(2992,'1','310','1',1,'Retail Sale Id 2907',35000.00,0.00,0.00,50.00,2450.00,'2023-02-16 11:33:26','',''),(2993,'1','310','1',1,'Retail Sale Id 2908',9000.00,0.00,0.00,12.50,862.50,'2023-02-16 11:40:45','',''),(2994,'1','310','1',1,'Retail Sale Id 2909',4320.00,0.00,0.00,6.00,414.00,'2023-02-16 11:42:13','',''),(2995,'1','310','1',1,'Retail Sale Id 2910',9000.00,0.00,0.00,12.50,862.50,'2023-02-16 11:44:51','',''),(2996,'1','310','1',1,'Retail Sale Id 2911',192500.00,0.00,0.00,275.00,13475.00,'2023-02-16 11:53:18','',''),(2997,'1','310','1',1,'Retail Sale Id 2912',1000.80,0.00,0.00,1.39,95.91,'2023-02-16 12:00:40','',''),(2998,'1','310','1',1,'Retail Sale Id 2913',2160.00,0.00,0.00,3.00,207.00,'2023-02-16 12:05:49','',''),(2999,'1','310','1',1,'Retail Sale Id 2915',2001.60,0.00,0.00,2.78,191.82,'2023-02-16 12:18:58','',''),(3000,'1','310','1',1,'Retail Sale Id 2916',3002.40,0.00,0.00,4.17,287.73,'2023-02-16 12:21:54','',''),(3001,'1','310','1',1,'Retail Sale Id 2917',2001.60,0.00,0.00,2.78,191.82,'2023-02-16 12:25:12','',''),(3002,'1','310','1',1,'Retail Sale Id 2918',3600.00,0.00,0.00,5.00,345.00,'2023-02-16 12:26:48','',''),(3003,'1','310','1',1,'Retail Sale Id 2919',4320.00,0.00,0.00,6.00,414.00,'2023-02-16 12:36:16','',''),(3004,'1','310','1',1,'Retail Sale Id 2920',4996.80,0.00,0.00,6.94,478.86,'2023-02-16 12:43:37','',''),(3005,'1','310','1',1,'Retail Sale Id 2921',2880.00,0.00,0.00,4.00,276.00,'2023-02-16 12:48:34','',''),(3006,'1','310','1',1,'Retail Sale Id 2922',4003.20,0.00,0.00,5.56,383.64,'2023-02-16 13:01:56','',''),(3007,'1','310','1',1,'Retail Sale Id 2923',2001.60,0.00,0.00,2.78,191.82,'2023-02-16 13:06:35','',''),(3008,'1','310','1',1,'Retail Sale Id 2924',1000.80,0.00,0.00,1.39,95.91,'2023-02-16 13:18:04','',''),(3009,'1','310','1',1,'Retail Sale Id 2925',2160.00,0.00,0.00,3.00,207.00,'2023-02-16 13:31:49','',''),(3010,'1','310','1',1,'Retail Sale Id 2926',9000.00,0.00,0.00,12.50,862.50,'2023-02-16 13:42:29','',''),(3011,'1','310','1',1,'Retail Sale Id 2927',2160.00,0.00,0.00,3.00,207.00,'2023-02-16 14:02:19','',''),(3012,'1','310','1',1,'Retail Sale Id 2927',9000.00,0.00,0.00,12.50,862.50,'2023-02-16 14:02:19','',''),(3013,'1','310','1',1,'Retail Sale Id 2928',1000.80,0.00,0.00,1.39,95.91,'2023-02-16 14:05:33','',''),(3014,'1','310','1',1,'Retail Sale Id 2929',1000.80,0.00,0.00,1.39,95.91,'2023-02-16 14:23:39','',''),(3015,'1','310','1',1,'Retail Sale Id 2930',4320.00,0.00,0.00,6.00,414.00,'2023-02-16 14:28:13','',''),(3016,'1','310','1',1,'Retail Sale Id 2930',4320.00,0.00,0.00,6.00,414.00,'2023-02-16 14:28:13','',''),(3017,'1','310','1',1,'Retail Sale Id 2931',3002.40,0.00,0.00,4.17,287.73,'2023-02-16 14:29:08','',''),(3018,'1','310','1',1,'Retail Sale Id 2932',3002.40,0.00,0.00,4.17,287.73,'2023-02-16 14:30:34','',''),(3019,'1','310','1',1,'Retail Sale Id 2933',4320.00,0.00,0.00,6.00,414.00,'2023-02-16 14:32:13','',''),(3020,'1','310','1',1,'Retail Sale Id 2934',21000.00,0.00,0.00,30.00,1470.00,'2023-02-16 14:37:41','',''),(3021,'1','310','1',1,'Retail Sale Id 2935',1000.80,0.00,0.00,1.39,95.91,'2023-02-16 14:45:23','',''),(3022,'1','310','1',1,'Retail Sale Id 2936',1000.80,0.00,0.00,1.39,95.91,'2023-02-16 14:52:30','',''),(3023,'1','310','1',1,'Retail Sale Id 2937',7200.00,0.00,0.00,10.00,690.00,'2023-02-16 14:56:21','',''),(3024,'1','310','1',1,'Retail Sale Id 2937',7200.00,0.00,0.00,10.00,690.00,'2023-02-16 14:56:21','',''),(3025,'1','310','1',1,'Retail Sale Id 2938',70000.00,0.00,0.00,100.00,4900.00,'2023-02-16 14:58:36','',''),(3026,'1','310','1',1,'Retail Sale Id 2939',1000.80,0.00,0.00,1.39,95.91,'2023-02-16 14:59:35','',''),(3027,'1','310','1',1,'Retail Sale Id 2940',9000.00,0.00,0.00,12.50,862.50,'2023-02-16 15:01:42','',''),(3028,'1','310','1',1,'Retail Sale Id 2941',1440.00,0.00,0.00,2.00,138.00,'2023-02-16 15:15:41','',''),(3029,'1','310','1',1,'Retail Sale Id 2942',3600.00,0.00,0.00,5.00,345.00,'2023-02-16 15:19:05','',''),(3030,'1','310','1',1,'Retail Sale Id 2943',2160.00,0.00,0.00,3.00,207.00,'2023-02-16 15:20:17','',''),(3031,'1','310','1',1,'Retail Sale Id 2944',4320.00,0.00,0.00,6.00,414.00,'2023-02-16 15:25:20','',''),(3032,'1','310','1',1,'Retail Sale Id 2945',2160.00,0.00,0.00,3.00,207.00,'2023-02-16 15:28:25','',''),(3033,'1','310','1',1,'Retail Sale Id 2946',698.40,0.00,0.00,0.97,66.93,'2023-02-16 15:30:38','',''),(3034,'1','310','1',1,'Retail Sale Id 2948',9000.00,0.00,0.00,12.50,862.50,'2023-02-16 15:54:34','',''),(3035,'1','310','1',1,'Retail Sale Id 2949',1000.80,0.00,0.00,1.39,95.91,'2023-02-16 15:56:08','',''),(3036,'1','310','1',1,'Retail Sale Id 2950',2160.00,0.00,0.00,3.00,207.00,'2023-02-16 15:58:39','',''),(3037,'1','310','1',1,'Retail Sale Id 2951',1000.80,0.00,0.00,1.39,95.91,'2023-02-16 16:01:39','',''),(3038,'1','310','1',1,'Retail Sale Id 2952',799.20,0.00,0.00,1.11,76.59,'2023-02-16 16:13:29','',''),(3039,'1','310','1',1,'Retail Sale Id 2953',4320.00,0.00,0.00,6.00,414.00,'2023-02-16 16:15:35','',''),(3040,'1','310','1',1,'Retail Sale Id 2954',1000.80,0.00,0.00,1.39,95.91,'2023-02-16 16:16:29','',''),(3041,'1','310','1',1,'Retail Sale Id 2955',3002.40,0.00,0.00,4.17,287.73,'2023-02-16 16:25:01','',''),(3042,'1','310','1',1,'Retail Sale Id 2956',1497.60,0.00,0.00,2.08,143.52,'2023-02-16 16:34:39','',''),(3043,'1','310','1',1,'Retail Sale Id 2957',4320.00,0.00,0.00,6.00,414.00,'2023-02-16 16:37:55','',''),(3044,'1','310','1',1,'Retail Sale Id 2958',9000.00,0.00,0.00,12.50,862.50,'2023-02-16 16:40:31','',''),(3045,'1','310','1',1,'Retail Sale Id 2959',9000.00,0.00,0.00,12.50,862.50,'2023-02-16 16:42:03','',''),(3046,'1','310','1',1,'Retail Sale Id 2960',2160.00,0.00,0.00,3.00,207.00,'2023-02-16 16:43:00','',''),(3047,'1','310','1',1,'Retail Sale Id 2961',1000.80,0.00,0.00,1.39,95.91,'2023-02-16 16:43:50','',''),(3048,'1','310','1',1,'Retail Sale Id 2963',3002.40,0.00,0.00,4.17,287.73,'2023-02-16 16:47:33','',''),(3049,'1','310','1',1,'Retail Sale Id 2964',1497.60,0.00,0.00,2.08,143.52,'2023-02-16 16:48:26','',''),(3050,'1','310','1',1,'Retail Sale Id 2965',4003.20,0.00,0.00,5.56,383.64,'2023-02-16 16:53:08','',''),(3051,'1','310','1',1,'Retail Sale Id 2966',2001.60,0.00,0.00,2.78,191.82,'2023-02-16 17:08:09','',''),(3052,'1','310','1',1,'Retail Sale Id 2966',2001.60,0.00,0.00,2.78,191.82,'2023-02-16 17:08:09','',''),(3053,'1','310','1',1,'Retail Sale Id 2967',4320.00,0.00,0.00,6.00,414.00,'2023-02-16 17:09:42','',''),(3054,'1','310','1',1,'Retail Sale Id 2969',496.80,0.00,0.00,0.69,47.61,'2023-02-16 17:12:35','',''),(3055,'1','310','1',1,'Retail Sale Id 2970',1598.40,0.00,0.00,2.22,153.18,'2023-02-16 17:14:30','',''),(3056,'1','310','1',1,'Retail Sale Id 2971',7798.00,0.00,0.00,11.14,545.86,'2023-02-16 17:17:45','',''),(3057,'1','310','1',1,'Retail Sale Id 2972',1000.80,0.00,0.00,1.39,95.91,'2023-02-16 17:21:00','',''),(3058,'1','310','1',1,'Retail Sale Id 2974',8750.00,0.00,0.00,12.50,612.50,'2023-02-16 17:24:47','',''),(3059,'1','310','1',1,'Retail Sale Id 2975',3600.00,0.00,0.00,5.00,345.00,'2023-02-16 17:27:15','',''),(3060,'1','310','1',1,'Retail Sale Id 2976',1000.80,0.00,0.00,1.39,95.91,'2023-02-16 17:30:47','',''),(3061,'1','310','1',1,'Retail Sale Id 2977',2001.60,0.00,0.00,2.78,191.82,'2023-02-16 17:31:41','',''),(3062,'1','310','1',1,'Retail Sale Id 2978',4320.00,0.00,0.00,6.00,414.00,'2023-02-16 17:33:11','',''),(3063,'1','310','1',1,'Retail Sale Id 2979',1000.80,0.00,0.00,1.39,95.91,'2023-02-16 17:33:58','',''),(3064,'1','310','1',1,'Retail Sale Id 2980',2001.60,0.00,0.00,2.78,191.82,'2023-02-16 17:36:08','',''),(3065,'1','310','1',1,'Retail Sale Id 2981',1000.80,0.00,0.00,1.39,95.91,'2023-02-16 17:38:12','',''),(3066,'1','310','1',1,'Retail Sale Id 2982',3002.40,0.00,0.00,4.17,287.73,'2023-02-16 17:39:09','',''),(3067,'1','310','1',1,'Retail Sale Id 2983',720.00,0.00,0.00,1.00,69.00,'2023-02-16 17:41:08','',''),(3068,'1','310','1',1,'Retail Sale Id 2984',799.20,0.00,0.00,1.11,76.59,'2023-02-16 17:41:56','',''),(3069,'1','310','1',1,'Retail Sale Id 2985',25900.00,0.00,0.00,37.00,1813.00,'2023-02-16 17:42:39','',''),(3070,'1','310','1',1,'Retail Sale Id 2987',1497.60,0.00,0.00,2.08,143.52,'2023-02-16 17:44:00','',''),(3071,'1','310','1',1,'Retail Sale Id 2988',3002.40,0.00,0.00,4.17,287.73,'2023-02-16 17:44:38','',''),(3072,'1','310','1',1,'Retail Sale Id 2989',2001.60,0.00,0.00,2.78,191.82,'2023-02-16 17:45:17','',''),(3073,'1','310','1',1,'Retail Sale Id 2990',3600.00,0.00,0.00,5.00,345.00,'2023-02-16 17:47:00','',''),(3074,'1','310','1',1,'Retail Sale Id 2991',2160.00,0.00,0.00,3.00,207.00,'2023-02-16 17:47:41','',''),(3075,'1','310','1',1,'Retail Sale Id 2992',2160.00,0.00,0.00,3.00,207.00,'2023-02-16 18:02:19','',''),(3076,'1','310','1',1,'Retail Sale Id 2992',9000.00,0.00,0.00,12.50,862.50,'2023-02-16 18:02:19','',''),(3077,'1','310','1',1,'Retail Sale Id 2993',1497.60,0.00,0.00,2.08,143.52,'2023-02-16 18:19:42','',''),(3078,'1','310','1',1,'Retail Sale Id 2994',4996.80,0.00,0.00,6.94,478.86,'2023-02-16 18:20:27','',''),(3079,'1','310','1',1,'Retail Sale Id 2995',2203.20,0.00,0.00,3.06,211.14,'2023-02-16 18:22:56','',''),(3080,'1','310','1',1,'Retail Sale Id 2996',1000.80,0.00,0.00,1.39,95.91,'2023-02-16 18:24:27','',''),(3081,'1','310','1',1,'Retail Sale Id 2997',4320.00,0.00,0.00,6.00,414.00,'2023-02-16 18:34:13','',''),(3082,'1','310','1',1,'Retail Sale Id 2998',4320.00,0.00,0.00,6.00,414.00,'2023-02-16 18:36:21','',''),(3083,'1','310','1',1,'Retail Sale Id 2999',1000.80,0.00,0.00,1.39,95.91,'2023-02-16 18:46:53','',''),(3084,'1','310','1',1,'Retail Sale Id 3000',3600.00,0.00,0.00,5.00,345.00,'2023-02-16 19:04:30','',''),(3085,'1','310','1',1,'Retail Sale Id 3001',3600.00,0.00,0.00,5.00,345.00,'2023-02-16 19:05:20','',''),(3086,'1','310','1',1,'Return of Retail Sale Id 2992',0.00,2160.00,3.00,0.00,-207.00,'2023-02-16 19:12:37','',''),(3087,'1','310','1',1,'Return of Retail Sale Id 2992',0.00,9000.00,12.50,0.00,-862.50,'2023-02-16 19:12:37','',''),(3088,'1','310','1',1,'Return of Retail Sale Id 2994',0.00,4996.80,6.94,0.00,-478.86,'2023-02-16 19:13:09','',''),(3089,'1','310','1',1,'Retail Sale Id 3002',532.80,0.00,0.00,0.74,51.06,'2023-02-16 19:13:42','',''),(3090,'1','310','1',1,'Return of Retail Sale Id 2974',0.00,8750.00,12.50,0.00,-612.50,'2023-02-16 19:15:20','',''),(3091,'1','310','1',1,'Retail Sale Id 3003',8757.00,0.00,0.00,12.51,612.99,'2023-02-16 19:16:03','',''),(3092,'1','310','1',1,'Retail Sale Id 3005',2160.00,0.00,0.00,3.00,207.00,'2023-02-17 07:14:38','',''),(3093,'1','310','1',1,'Retail Sale Id 3005',9000.00,0.00,0.00,12.50,862.50,'2023-02-17 07:14:38','',''),(3094,'1','310','1',1,'Retail Sale Id 3006',2001.60,0.00,0.00,2.78,191.82,'2023-02-17 07:22:07','',''),(3095,'1','310','1',1,'Retail Sale Id 3007',2100.00,0.00,0.00,3.00,147.00,'2023-02-17 08:16:13','',''),(3096,'1','310','1',1,'Retail Sale Id 3008',4320.00,0.00,0.00,6.00,414.00,'2023-02-17 08:18:34','',''),(3097,'1','310','1',1,'Retail Sale Id 3009',3600.00,0.00,0.00,5.00,345.00,'2023-02-17 08:19:59','',''),(3098,'1','310','1',1,'Retail Sale Id 3010',4996.80,0.00,0.00,6.94,478.86,'2023-02-17 08:31:51','',''),(3099,'1','310','1',1,'Retail Sale Id 3011',9000.00,0.00,0.00,12.50,862.50,'2023-02-17 08:46:26','',''),(3100,'1','310','1',1,'Retail Sale Id 3012',4320.00,0.00,0.00,6.00,414.00,'2023-02-17 08:49:07','',''),(3101,'1','310','1',1,'Retail Sale Id 3013',2160.00,0.00,0.00,3.00,207.00,'2023-02-17 09:06:51','',''),(3102,'1','310','1',1,'Retail Sale Id 3015',7200.00,0.00,0.00,10.00,690.00,'2023-02-17 09:09:54','',''),(3103,'1','310','1',1,'Retail Sale Id 3016',1202.40,0.00,0.00,1.67,115.23,'2023-02-17 09:10:27','',''),(3104,'1','310','1',1,'Retail Sale Id 3017',1000.80,0.00,0.00,1.39,95.91,'2023-02-17 09:12:55','',''),(3105,'1','310','1',1,'Retail Sale Id 3018',2160.00,0.00,0.00,3.00,207.00,'2023-02-17 09:14:47','',''),(3106,'1','310','1',1,'Retail Sale Id 3019',4320.00,0.00,0.00,6.00,414.00,'2023-02-17 09:30:27','',''),(3107,'1','310','1',1,'Retail Sale Id 3020',2001.60,0.00,0.00,2.78,191.82,'2023-02-17 09:40:18','',''),(3108,'1','310','1',1,'Retail Sale Id 3021',1000.80,0.00,0.00,1.39,95.91,'2023-02-17 09:45:49','',''),(3109,'1','310','1',1,'Retail Sale Id 3022',2160.00,0.00,0.00,3.00,207.00,'2023-02-17 09:50:36','',''),(3110,'1','310','1',1,'Retail Sale Id 3023',720.00,0.00,0.00,1.00,69.00,'2023-02-17 09:55:04','',''),(3111,'1','310','1',1,'Retail Sale Id 3023',720.00,0.00,0.00,1.00,69.00,'2023-02-17 09:55:04','',''),(3112,'1','310','1',1,'Retail Sale Id 3024',4320.00,0.00,0.00,6.00,414.00,'2023-02-17 10:00:43','',''),(3113,'1','310','1',1,'Retail Sale Id 3025',3600.00,0.00,0.00,5.00,345.00,'2023-02-17 10:05:26','',''),(3114,'1','310','1',1,'Retail Sale Id 3026',1000.80,0.00,0.00,1.39,95.91,'2023-02-17 10:07:52','',''),(3115,'1','310','1',1,'Retail Sale Id 3027',3600.00,0.00,0.00,5.00,345.00,'2023-02-17 10:25:08','',''),(3116,'1','310','1',1,'Retail Sale Id 3028',2001.60,0.00,0.00,2.78,191.82,'2023-02-17 10:26:25','',''),(3117,'1','310','1',1,'Retail Sale Id 3029',2102.40,0.00,0.00,2.92,201.48,'2023-02-17 10:29:01','',''),(3118,'1','310','1',1,'Retail Sale Id 3030',9000.00,0.00,0.00,12.50,862.50,'2023-02-17 10:38:45','',''),(3119,'1','310','1',1,'Retail Sale Id 3031',9000.00,0.00,0.00,12.50,862.50,'2023-02-17 10:41:04','',''),(3120,'1','310','1',1,'Retail Sale Id 3031',9000.00,0.00,0.00,12.50,862.50,'2023-02-17 10:41:04','',''),(3121,'1','310','1',1,'Retail Sale Id 3032',7999.20,0.00,0.00,11.11,766.59,'2023-02-17 10:51:46','',''),(3122,'1','310','1',1,'Retail Sale Id 3033',2498.40,0.00,0.00,3.47,239.43,'2023-02-17 10:56:23','',''),(3123,'1','310','1',1,'Retail Sale Id 3033',2498.40,0.00,0.00,3.47,239.43,'2023-02-17 10:56:23','',''),(3124,'1','310','1',1,'Retail Sale Id 3034',35000.00,0.00,0.00,50.00,2450.00,'2023-02-17 10:58:00','',''),(3125,'1','310','1',1,'Retail Sale Id 3035',1396.80,0.00,0.00,1.94,133.86,'2023-02-17 11:01:12','',''),(3126,'1','310','1',1,'Retail Sale Id 3036',2160.00,0.00,0.00,3.00,207.00,'2023-02-17 11:07:09','',''),(3127,'1','310','1',1,'Retail Sale Id 3037',3600.00,0.00,0.00,5.00,345.00,'2023-02-17 11:18:48','',''),(3128,'1','310','1',1,'Retail Sale Id 3038',4320.00,0.00,0.00,6.00,414.00,'2023-02-17 11:22:08','',''),(3129,'1','310','1',1,'Retail Sale Id 3040',1440.00,0.00,0.00,2.00,138.00,'2023-02-17 11:30:07','',''),(3130,'1','310','1',1,'Retail Sale Id 3041',2001.60,0.00,0.00,2.78,191.82,'2023-02-17 11:33:49','',''),(3131,'1','310','1',1,'Retail Sale Id 3042',2001.60,0.00,0.00,2.78,191.82,'2023-02-17 11:41:17','',''),(3132,'1','310','1',1,'Retail Sale Id 3043',4996.80,0.00,0.00,6.94,478.86,'2023-02-17 11:45:19','',''),(3133,'1','310','1',1,'Retail Sale Id 3044',3600.00,0.00,0.00,5.00,345.00,'2023-02-17 11:47:26','',''),(3134,'1','310','1',1,'Retail Sale Id 3045',1497.60,0.00,0.00,2.08,143.52,'2023-02-17 11:52:10','',''),(3135,'1','310','1',1,'Retail Sale Id 3046',4320.00,0.00,0.00,6.00,414.00,'2023-02-17 11:59:47','',''),(3136,'1','310','1',1,'Retail Sale Id 3047',2880.00,0.00,0.00,4.00,276.00,'2023-02-17 12:03:41','',''),(3137,'1','310','1',1,'Retail Sale Id 3047',4320.00,0.00,0.00,6.00,414.00,'2023-02-17 12:03:41','',''),(3138,'1','310','1',1,'Retail Sale Id 3048',9000.00,0.00,0.00,12.50,862.50,'2023-02-17 12:20:09','',''),(3139,'1','310','1',1,'Retail Sale Id 3049',4298.40,0.00,0.00,5.97,411.93,'2023-02-17 12:26:13','',''),(3140,'1','310','1',1,'Retail Sale Id 3050',2160.00,0.00,0.00,3.00,207.00,'2023-02-17 12:28:08','',''),(3141,'1','310','1',1,'Retail Sale Id 3051',4320.00,0.00,0.00,6.00,414.00,'2023-02-17 12:39:07','',''),(3142,'1','310','1',1,'Retail Sale Id 3052',2001.60,0.00,0.00,2.78,191.82,'2023-02-17 13:01:33','',''),(3143,'1','310','1',1,'Retail Sale Id 3053',210000.00,0.00,0.00,300.00,14700.00,'2023-02-17 13:34:44','',''),(3144,'1','310','1',1,'Retail Sale Id 3054',4320.00,0.00,0.00,6.00,414.00,'2023-02-17 13:51:44','',''),(3145,'1','310','1',1,'Retail Sale Id 3056',2001.60,0.00,0.00,2.78,191.82,'2023-02-17 13:53:45','',''),(3146,'1','310','1',1,'Retail Sale Id 3057',3600.00,0.00,0.00,5.00,345.00,'2023-02-17 13:55:25','',''),(3147,'1','310','1',1,'Retail Sale Id 3057',3600.00,0.00,0.00,5.00,345.00,'2023-02-17 13:55:25','',''),(3148,'1','310','1',1,'Retail Sale Id 3058',4320.00,0.00,0.00,6.00,414.00,'2023-02-17 13:59:54','',''),(3149,'1','310','1',1,'Retail Sale Id 3059',1000.80,0.00,0.00,1.39,95.91,'2023-02-17 14:04:36','',''),(3150,'1','310','1',1,'Retail Sale Id 3060',9000.00,0.00,0.00,12.50,862.50,'2023-02-17 14:20:33','',''),(3151,'1','310','1',1,'Retail Sale Id 3061',1000.80,0.00,0.00,1.39,95.91,'2023-02-17 14:25:51','',''),(3152,'1','310','1',1,'Retail Sale Id 3061',1497.60,0.00,0.00,2.08,143.52,'2023-02-17 14:25:51','',''),(3153,'1','310','1',1,'Retail Sale Id 3062',1497.60,0.00,0.00,2.08,143.52,'2023-02-17 14:34:11','',''),(3154,'1','310','1',1,'Retail Sale Id 3063',5040.00,0.00,0.00,7.00,483.00,'2023-02-17 14:40:21','',''),(3155,'1','310','1',1,'Retail Sale Id 3064',3600.00,0.00,0.00,5.00,345.00,'2023-02-17 14:51:37','',''),(3156,'1','310','1',1,'Retail Sale Id 3066',1800.00,0.00,0.00,2.50,172.50,'2023-02-17 14:55:13','',''),(3157,'1','310','1',1,'Retail Sale Id 3067',9000.00,0.00,0.00,12.50,862.50,'2023-02-17 15:07:10','',''),(3158,'1','310','1',1,'Retail Sale Id 3067',9000.00,0.00,0.00,12.50,862.50,'2023-02-17 15:07:10','',''),(3159,'1','310','1',1,'Retail Sale Id 3067',9000.00,0.00,0.00,12.50,862.50,'2023-02-17 15:07:10','',''),(3160,'1','310','1',1,'Retail Sale Id 3068',3002.40,0.00,0.00,4.17,287.73,'2023-02-17 15:09:56','',''),(3161,'1','310','1',1,'Retail Sale Id 3069',2498.40,0.00,0.00,3.47,239.43,'2023-02-17 15:11:20','',''),(3162,'1','310','1',1,'Retail Sale Id 3070',3600.00,0.00,0.00,5.00,345.00,'2023-02-17 15:25:36','',''),(3163,'1','310','1',1,'Retail Sale Id 3071',1497.60,0.00,0.00,2.08,143.52,'2023-02-17 15:27:26','',''),(3164,'1','310','1',1,'Retail Sale Id 3072',3499.20,0.00,0.00,4.86,335.34,'2023-02-17 15:30:10','',''),(3165,'1','310','1',1,'Retail Sale Id 3073',3600.00,0.00,0.00,5.00,345.00,'2023-02-17 15:36:58','',''),(3166,'1','310','1',1,'Retail Sale Id 3073',9000.00,0.00,0.00,12.50,862.50,'2023-02-17 15:36:58','',''),(3167,'1','310','1',1,'Retail Sale Id 3074',2160.00,0.00,0.00,3.00,207.00,'2023-02-17 15:40:56','',''),(3168,'1','310','1',1,'Retail Sale Id 3075',2203.20,0.00,0.00,3.06,211.14,'2023-02-17 15:44:06','',''),(3169,'1','310','1',1,'Retail Sale Id 3076',2203.20,0.00,0.00,3.06,211.14,'2023-02-17 15:53:02','',''),(3170,'1','310','1',1,'Retail Sale Id 3078',9000.00,0.00,0.00,12.50,862.50,'2023-02-17 15:57:09','',''),(3171,'1','310','1',1,'Retail Sale Id 3079',1497.60,0.00,0.00,2.08,143.52,'2023-02-17 15:57:46','',''),(3172,'1','310','1',1,'Retail Sale Id 3080',6480.00,0.00,0.00,9.00,621.00,'2023-02-17 15:59:13','',''),(3173,'1','310','1',1,'Retail Sale Id 3081',4320.00,0.00,0.00,6.00,414.00,'2023-02-17 16:03:00','',''),(3174,'1','310','1',1,'Retail Sale Id 3082',2001.60,0.00,0.00,2.78,191.82,'2023-02-17 16:04:55','',''),(3175,'1','310','1',1,'Retail Sale Id 3083',2160.00,0.00,0.00,3.00,207.00,'2023-02-17 16:17:08','',''),(3176,'1','310','1',1,'Retail Sale Id 3084',1497.60,0.00,0.00,2.08,143.52,'2023-02-17 16:26:56','',''),(3177,'1','310','1',1,'Retail Sale Id 3085',2001.60,0.00,0.00,2.78,191.82,'2023-02-17 16:30:18','',''),(3178,'1','310','1',1,'Retail Sale Id 3086',148750.00,0.00,0.00,212.50,10412.50,'2023-02-17 16:32:33','',''),(3179,'1','310','1',1,'Retail Sale Id 3087',3002.40,0.00,0.00,4.17,287.73,'2023-02-17 16:34:51','',''),(3180,'1','310','1',1,'Retail Sale Id 3089',2001.60,0.00,0.00,2.78,191.82,'2023-02-17 16:36:23','',''),(3181,'1','310','1',1,'Retail Sale Id 3090',4197.60,0.00,0.00,5.83,402.27,'2023-02-17 16:39:01','',''),(3182,'1','310','1',1,'Retail Sale Id 3091',4200.00,0.00,0.00,6.00,294.00,'2023-02-17 16:40:17','',''),(3183,'1','310','1',1,'Retail Sale Id 3092',1440.00,0.00,0.00,2.00,138.00,'2023-02-17 16:41:09','',''),(3184,'1','310','1',1,'Retail Sale Id 3093',1497.60,0.00,0.00,2.08,143.52,'2023-02-17 16:43:53','',''),(3185,'1','310','1',1,'Retail Sale Id 3094',2001.60,0.00,0.00,2.78,191.82,'2023-02-17 16:45:29','',''),(3186,'1','310','1',1,'Retail Sale Id 3095',9000.00,0.00,0.00,12.50,862.50,'2023-02-17 16:46:36','',''),(3187,'1','310','1',1,'Retail Sale Id 3096',3002.40,0.00,0.00,4.17,287.73,'2023-02-17 16:50:32','',''),(3188,'1','310','1',1,'Retail Sale Id 3097',4320.00,0.00,0.00,6.00,414.00,'2023-02-17 16:52:23','',''),(3189,'1','310','1',1,'Retail Sale Id 3098',2160.00,0.00,0.00,3.00,207.00,'2023-02-17 17:01:39','',''),(3190,'1','310','1',1,'Retail Sale Id 3099',7200.00,0.00,0.00,10.00,690.00,'2023-02-17 17:09:35','',''),(3191,'1','310','1',1,'Retail Sale Id 3100',3002.40,0.00,0.00,4.17,287.73,'2023-02-17 17:11:10','',''),(3192,'1','310','1',1,'Retail Sale Id 3101',1440.00,0.00,0.00,2.00,138.00,'2023-02-17 17:13:09','',''),(3193,'1','310','1',1,'Retail Sale Id 3102',3002.40,0.00,0.00,4.17,287.73,'2023-02-17 17:15:10','',''),(3194,'1','310','1',1,'Retail Sale Id 3103',9000.00,0.00,0.00,12.50,862.50,'2023-02-17 17:36:41','',''),(3195,'1','310','1',1,'Retail Sale Id 3104',4320.00,0.00,0.00,6.00,414.00,'2023-02-17 17:37:22','',''),(3196,'1','310','1',1,'Retail Sale Id 3105',1000.80,0.00,0.00,1.39,95.91,'2023-02-17 17:38:14','',''),(3197,'1','310','1',1,'Retail Sale Id 3106',7999.20,0.00,0.00,11.11,766.59,'2023-02-17 17:39:32','',''),(3198,'1','310','1',1,'Retail Sale Id 3107',2160.00,0.00,0.00,3.00,207.00,'2023-02-17 17:42:48','',''),(3199,'1','310','1',1,'Retail Sale Id 3108',4320.00,0.00,0.00,6.00,414.00,'2023-02-17 17:43:52','',''),(3200,'1','310','1',1,'Retail Sale Id 3109',2001.60,0.00,0.00,2.78,191.82,'2023-02-17 17:44:37','',''),(3201,'1','310','1',1,'Retail Sale Id 3110',35000.00,0.00,0.00,50.00,2450.00,'2023-02-17 17:47:59','',''),(3202,'1','310','1',1,'Retail Sale Id 3111',3600.00,0.00,0.00,5.00,345.00,'2023-02-17 17:50:47','',''),(3203,'1','310','1',1,'Retail Sale Id 3112',1440.00,0.00,0.00,2.00,138.00,'2023-02-17 18:00:33','',''),(3204,'1','310','1',1,'Retail Sale Id 3113',1000.80,0.00,0.00,1.39,95.91,'2023-02-17 18:05:33','',''),(3205,'1','310','1',1,'Retail Sale Id 3114',9000.00,0.00,0.00,12.50,862.50,'2023-02-17 18:06:56','',''),(3206,'1','310','1',1,'Retail Sale Id 3115',4320.00,0.00,0.00,6.00,414.00,'2023-02-17 18:10:08','',''),(3207,'1','310','1',1,'Retail Sale Id 3116',3997.00,0.00,0.00,5.71,279.79,'2023-02-17 18:12:40','',''),(3208,'1','310','1',1,'Retail Sale Id 3117',748.80,0.00,0.00,1.04,71.76,'2023-02-17 18:14:09','',''),(3209,'1','310','1',1,'Retail Sale Id 3118',1396.80,0.00,0.00,1.94,133.86,'2023-02-17 18:51:47','',''),(3210,'1','310','1',1,'Retail Sale Id 3119',1497.60,0.00,0.00,2.08,143.52,'2023-02-17 18:52:52','',''),(3211,'1','310','1',1,'Retail Sale Id 3120',2160.00,0.00,0.00,3.00,207.00,'2023-02-17 18:54:06','',''),(3212,'1','310','1',1,'Retail Sale Id 3121',2001.60,0.00,0.00,2.78,191.82,'2023-02-17 18:59:15','',''),(3213,'1','310','1',1,'Return of Retail Sale Id 3119',0.00,1497.60,2.08,0.00,-143.52,'2023-02-17 19:13:36','',''),(3214,'1','310','1',1,'Retail Sale Id 3122',1252.80,0.00,0.00,1.74,120.06,'2023-02-17 19:14:31','',''),(3215,'1','310','1',1,'Return of Retail Sale Id 3116',0.00,3997.00,5.71,0.00,-279.79,'2023-02-17 19:15:42','',''),(3216,'1','310','1',1,'Retail Sale Id 3123',3997.00,0.00,0.00,5.71,279.79,'2023-02-17 19:16:36','',''),(3217,'1','310','1',1,'Retail Sale Id 3124',3600.00,0.00,0.00,5.00,345.00,'2023-02-18 07:20:35','',''),(3218,'1','310','1',1,'Retail Sale Id 3126',9000.00,0.00,0.00,12.50,862.50,'2023-02-18 07:49:50','',''),(3219,'1','310','1',1,'Retail Sale Id 3126',9000.00,0.00,0.00,12.50,862.50,'2023-02-18 07:49:50','',''),(3220,'1','310','1',1,'Retail Sale Id 3127',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 08:04:35','',''),(3221,'1','310','1',1,'Retail Sale Id 3128',1000.80,0.00,0.00,1.39,95.91,'2023-02-18 08:07:47','',''),(3222,'1','310','1',1,'Retail Sale Id 3129',70000.00,0.00,0.00,100.00,4900.00,'2023-02-18 08:21:01','',''),(3223,'1','310','1',1,'Retail Sale Id 3130',70000.00,0.00,0.00,100.00,4900.00,'2023-02-18 08:29:49','',''),(3224,'1','310','1',1,'Retail Sale Id 3131',2001.60,0.00,0.00,2.78,191.82,'2023-02-18 08:36:39','',''),(3225,'1','310','1',1,'Retail Sale Id 3132',3002.40,0.00,0.00,4.17,287.73,'2023-02-18 08:51:43','',''),(3226,'1','310','1',1,'Retail Sale Id 3133',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 08:55:28','',''),(3227,'1','310','1',1,'Retail Sale Id 3134',2160.00,0.00,0.00,3.00,207.00,'2023-02-18 08:59:12','',''),(3228,'1','310','1',1,'Retail Sale Id 3135',2001.60,0.00,0.00,2.78,191.82,'2023-02-18 09:21:10','',''),(3229,'1','310','1',1,'Retail Sale Id 3136',1202.40,0.00,0.00,1.67,115.23,'2023-02-18 09:25:12','',''),(3230,'1','310','1',1,'Retail Sale Id 3137',2001.60,0.00,0.00,2.78,191.82,'2023-02-18 09:36:51','',''),(3231,'1','310','1',1,'Retail Sale Id 3137',3002.40,0.00,0.00,4.17,287.73,'2023-02-18 09:36:51','',''),(3232,'1','310','1',1,'Retail Sale Id 3138',3002.40,0.00,0.00,4.17,287.73,'2023-02-18 09:40:06','',''),(3233,'1','310','1',1,'Retail Sale Id 3139',1000.80,0.00,0.00,1.39,95.91,'2023-02-18 09:41:26','',''),(3234,'1','310','1',1,'Retail Sale Id 3140',496.80,0.00,0.00,0.69,47.61,'2023-02-18 09:44:12','',''),(3235,'1','310','1',1,'Retail Sale Id 3141',1000.80,0.00,0.00,1.39,95.91,'2023-02-18 10:07:33','',''),(3236,'1','310','1',1,'Retail Sale Id 3142',3600.00,0.00,0.00,5.00,345.00,'2023-02-18 10:09:25','',''),(3237,'1','310','1',1,'Retail Sale Id 3142',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 10:09:25','',''),(3238,'1','310','1',1,'Retail Sale Id 3143',2160.00,0.00,0.00,3.00,207.00,'2023-02-18 10:12:35','',''),(3239,'1','310','1',1,'Retail Sale Id 3144',2001.60,0.00,0.00,2.78,191.82,'2023-02-18 10:15:26','',''),(3240,'1','310','1',1,'Retail Sale Id 3145',3002.40,0.00,0.00,4.17,287.73,'2023-02-18 10:18:34','',''),(3241,'1','310','1',1,'Retail Sale Id 3146',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 10:19:51','',''),(3242,'1','310','1',1,'Retail Sale Id 3147',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 10:21:09','',''),(3243,'1','310','1',1,'Retail Sale Id 3148',3600.00,0.00,0.00,5.00,345.00,'2023-02-18 10:34:07','',''),(3244,'1','310','1',1,'Retail Sale Id 3149',2001.60,0.00,0.00,2.78,191.82,'2023-02-18 10:36:49','',''),(3245,'1','310','1',1,'Retail Sale Id 3150',1497.60,0.00,0.00,2.08,143.52,'2023-02-18 10:37:41','',''),(3246,'1','310','1',1,'Retail Sale Id 3151',2152.80,0.00,0.00,2.99,206.31,'2023-02-18 10:51:22','',''),(3247,'1','310','1',1,'Retail Sale Id 3152',9000.00,0.00,0.00,12.50,862.50,'2023-02-18 11:00:51','',''),(3248,'1','310','1',1,'Retail Sale Id 3153',1000.80,0.00,0.00,1.39,95.91,'2023-02-18 11:03:44','',''),(3249,'1','310','1',1,'Retail Sale Id 3154',35000.00,0.00,0.00,50.00,2450.00,'2023-02-18 11:06:13','',''),(3250,'1','310','1',1,'Retail Sale Id 3155',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 11:07:20','',''),(3251,'1','310','1',1,'Retail Sale Id 3156',42000.00,0.00,0.00,60.00,2940.00,'2023-02-18 11:08:39','',''),(3252,'1','310','1',1,'Retail Sale Id 3157',1000.80,0.00,0.00,1.39,95.91,'2023-02-18 11:09:28','',''),(3253,'1','310','1',1,'Retail Sale Id 3158',9000.00,0.00,0.00,12.50,862.50,'2023-02-18 11:13:17','',''),(3254,'1','310','1',1,'Retail Sale Id 3159',9000.00,0.00,0.00,12.50,862.50,'2023-02-18 11:15:09','',''),(3255,'1','310','1',1,'Retail Sale Id 3160',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 11:51:14','',''),(3256,'1','310','1',1,'Retail Sale Id 3161',170450.00,0.00,0.00,243.50,11931.50,'2023-02-18 11:52:47','',''),(3257,'1','310','1',1,'Retail Sale Id 3162',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 11:56:21','',''),(3258,'1','310','1',1,'Retail Sale Id 3163',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 11:57:50','',''),(3259,'1','310','1',1,'Retail Sale Id 3164',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 12:02:06','',''),(3260,'1','310','1',1,'Retail Sale Id 3164',9000.00,0.00,0.00,12.50,862.50,'2023-02-18 12:02:06','',''),(3261,'1','310','1',1,'Retail Sale Id 3165',434000.00,0.00,0.00,620.00,30380.00,'2023-02-18 12:07:48','',''),(3262,'1','310','1',1,'Retail Sale Id 3166',84000.00,0.00,0.00,120.00,5880.00,'2023-02-18 12:08:53','',''),(3263,'1','310','1',1,'Retail Sale Id 3167',4003.20,0.00,0.00,5.56,383.64,'2023-02-18 12:11:06','',''),(3264,'1','310','1',1,'Retail Sale Id 3169',1000.80,0.00,0.00,1.39,95.91,'2023-02-18 12:23:58','',''),(3265,'1','310','1',1,'Retail Sale Id 3171',4996.80,0.00,0.00,6.94,478.86,'2023-02-18 12:26:54','',''),(3266,'1','310','1',1,'Retail Sale Id 3171',6998.40,0.00,0.00,9.72,670.68,'2023-02-18 12:26:54','',''),(3267,'1','310','1',1,'Retail Sale Id 3172',1440.00,0.00,0.00,2.00,138.00,'2023-02-18 12:27:59','',''),(3268,'1','310','1',1,'Retail Sale Id 3173',4996.80,0.00,0.00,6.94,478.86,'2023-02-18 12:35:25','',''),(3269,'1','310','1',1,'Retail Sale Id 3174',1000.80,0.00,0.00,1.39,95.91,'2023-02-18 12:38:45','',''),(3270,'1','310','1',1,'Retail Sale Id 3175',2160.00,0.00,0.00,3.00,207.00,'2023-02-18 12:57:29','',''),(3271,'1','310','1',1,'Retail Sale Id 3175',9000.00,0.00,0.00,12.50,862.50,'2023-02-18 12:57:29','',''),(3272,'1','310','1',1,'Retail Sale Id 3176',9000.00,0.00,0.00,12.50,862.50,'2023-02-18 12:58:18','',''),(3273,'1','310','1',1,'Retail Sale Id 3177',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 13:03:16','',''),(3274,'1','310','1',1,'Retail Sale Id 3178',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 13:21:22','',''),(3275,'1','310','1',1,'Retail Sale Id 3179',1000.80,0.00,0.00,1.39,95.91,'2023-02-18 13:23:03','',''),(3276,'1','310','1',1,'Retail Sale Id 3180',2160.00,0.00,0.00,3.00,207.00,'2023-02-18 13:38:11','',''),(3277,'1','310','1',1,'Retail Sale Id 3181',1440.00,0.00,0.00,2.00,138.00,'2023-02-18 13:39:25','',''),(3278,'1','310','1',1,'Retail Sale Id 3182',496.80,0.00,0.00,0.69,47.61,'2023-02-18 13:46:04','',''),(3279,'1','310','1',1,'Retail Sale Id 3183',1440.00,0.00,0.00,2.00,138.00,'2023-02-18 13:47:37','',''),(3280,'1','310','1',1,'Retail Sale Id 3184',1000.80,0.00,0.00,1.39,95.91,'2023-02-18 13:50:26','',''),(3281,'1','310','1',1,'Retail Sale Id 3185',4500.00,0.00,0.00,6.25,431.25,'2023-02-18 13:57:12','',''),(3282,'1','310','1',1,'Retail Sale Id 3186',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 14:01:14','',''),(3283,'1','310','1',1,'Retail Sale Id 3187',6998.40,0.00,0.00,9.72,670.68,'2023-02-18 14:02:04','',''),(3284,'1','310','1',1,'Retail Sale Id 3188',140000.00,0.00,0.00,200.00,9800.00,'2023-02-18 14:02:49','',''),(3285,'1','310','1',1,'Return of Retail Sale Id 3185',0.00,4500.00,6.25,0.00,-431.25,'2023-02-18 14:04:52','',''),(3286,'1','310','1',1,'Return of Retail Sale Id 3183',0.00,1440.00,2.00,0.00,-138.00,'2023-02-18 14:05:24','',''),(3287,'1','310','1',1,'Retail Sale Id 3189',2001.60,0.00,0.00,2.78,191.82,'2023-02-18 14:10:02','',''),(3288,'1','310','1',1,'Return of Retail Sale Id 3189',0.00,2001.60,2.78,0.00,-191.82,'2023-02-18 14:10:17','',''),(3289,'1','310','1',1,'Retail Sale Id 3190',2160.00,0.00,0.00,3.00,207.00,'2023-02-18 14:11:54','',''),(3290,'1','310','1',1,'Retail Sale Id 3191',720.00,0.00,0.00,1.00,69.00,'2023-02-18 14:18:26','',''),(3291,'1','310','1',1,'Retail Sale Id 3192',4003.20,0.00,0.00,5.56,383.64,'2023-02-18 14:22:20','',''),(3292,'1','310','1',1,'Retail Sale Id 3193',9000.00,0.00,0.00,12.50,862.50,'2023-02-18 14:33:10','',''),(3293,'1','310','1',1,'Retail Sale Id 3194',2498.40,0.00,0.00,3.47,239.43,'2023-02-18 14:53:28','',''),(3294,'1','310','1',1,'Retail Sale Id 3195',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 14:55:40','',''),(3295,'1','310','1',1,'Retail Sale Id 3196',86800.00,0.00,0.00,124.00,6076.00,'2023-02-18 15:09:25','',''),(3296,'1','310','1',1,'Retail Sale Id 3197',1000.80,0.00,0.00,1.39,95.91,'2023-02-18 15:12:10','',''),(3297,'1','310','1',1,'Retail Sale Id 3198',9450.00,0.00,0.00,13.50,661.50,'2023-02-18 15:21:08','',''),(3298,'1','310','1',1,'Retail Sale Id 3199',2001.60,0.00,0.00,2.78,191.82,'2023-02-18 15:22:14','',''),(3299,'1','310','1',1,'Retail Sale Id 3200',3002.40,0.00,0.00,4.17,287.73,'2023-02-18 15:37:44','',''),(3300,'1','310','1',1,'Retail Sale Id 3201',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 15:43:18','',''),(3301,'1','310','1',1,'Retail Sale Id 3202',1497.60,0.00,0.00,2.08,143.52,'2023-02-18 15:43:55','',''),(3302,'1','310','1',1,'Retail Sale Id 3203',9000.00,0.00,0.00,12.50,862.50,'2023-02-18 15:46:16','',''),(3303,'1','310','1',1,'Retail Sale Id 3204',3002.40,0.00,0.00,4.17,287.73,'2023-02-18 15:47:52','',''),(3304,'1','310','1',1,'Retail Sale Id 3205',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 15:50:38','',''),(3305,'1','310','1',1,'Retail Sale Id 3206',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 15:54:19','',''),(3306,'1','310','1',1,'Retail Sale Id 3206',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 15:54:19','',''),(3307,'1','310','1',1,'Retail Sale Id 3207',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 16:06:39','',''),(3308,'1','310','1',1,'Retail Sale Id 3208',70000.00,0.00,0.00,100.00,4900.00,'2023-02-18 16:08:38','',''),(3309,'1','310','1',1,'Retail Sale Id 3209',70000.00,0.00,0.00,100.00,4900.00,'2023-02-18 16:09:47','',''),(3310,'1','310','1',1,'Retail Sale Id 3210',1000.80,0.00,0.00,1.39,95.91,'2023-02-18 16:15:18','',''),(3311,'1','310','1',1,'Retail Sale Id 3211',2880.00,0.00,0.00,4.00,276.00,'2023-02-18 16:17:33','',''),(3312,'1','310','1',1,'Retail Sale Id 3212',1497.60,0.00,0.00,2.08,143.52,'2023-02-18 16:18:26','',''),(3313,'1','310','1',1,'Retail Sale Id 3213',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 16:31:06','',''),(3314,'1','310','1',1,'Retail Sale Id 3214',2001.60,0.00,0.00,2.78,191.82,'2023-02-18 16:48:29','',''),(3315,'1','310','1',1,'Retail Sale Id 3215',2203.20,0.00,0.00,3.06,211.14,'2023-02-18 16:54:13','',''),(3316,'1','310','1',1,'Retail Sale Id 3216',1497.60,0.00,0.00,2.08,143.52,'2023-02-18 16:55:22','',''),(3317,'1','310','1',1,'Retail Sale Id 3218',2001.60,0.00,0.00,2.78,191.82,'2023-02-18 17:02:53','',''),(3318,'1','310','1',1,'Retail Sale Id 3219',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 17:04:13','',''),(3319,'1','310','1',1,'Retail Sale Id 3219',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 17:04:13','',''),(3320,'1','310','1',1,'Retail Sale Id 3220',35000.00,0.00,0.00,50.00,2450.00,'2023-02-18 17:07:19','',''),(3321,'1','310','1',1,'Retail Sale Id 3221',1497.60,0.00,0.00,2.08,143.52,'2023-02-18 17:08:14','',''),(3322,'1','310','1',1,'Retail Sale Id 3222',2203.20,0.00,0.00,3.06,211.14,'2023-02-18 17:11:18','',''),(3323,'1','310','1',1,'Retail Sale Id 3223',597.60,0.00,0.00,0.83,57.27,'2023-02-18 17:16:40','',''),(3324,'1','310','1',1,'Retail Sale Id 3224',2001.60,0.00,0.00,2.78,191.82,'2023-02-18 17:18:53','',''),(3325,'1','310','1',1,'Retail Sale Id 3225',6998.40,0.00,0.00,9.72,670.68,'2023-02-18 17:22:04','',''),(3326,'1','310','1',1,'Retail Sale Id 3226',5997.60,0.00,0.00,8.33,574.77,'2023-02-18 17:25:01','',''),(3327,'1','310','1',1,'Retail Sale Id 3227',3600.00,0.00,0.00,5.00,345.00,'2023-02-18 17:26:00','',''),(3328,'1','310','1',1,'Return of Retail Sale Id 3225',0.00,6998.40,9.72,0.00,-670.68,'2023-02-18 17:27:38','',''),(3329,'1','310','1',1,'Retail Sale Id 3228',2001.60,0.00,0.00,2.78,191.82,'2023-02-18 17:33:36','',''),(3330,'1','310','1',1,'Retail Sale Id 3229',2160.00,0.00,0.00,3.00,207.00,'2023-02-18 17:34:21','',''),(3331,'1','310','1',1,'Retail Sale Id 3230',799.20,0.00,0.00,1.11,76.59,'2023-02-18 17:35:52','',''),(3332,'1','310','1',1,'Retail Sale Id 3231',9000.00,0.00,0.00,12.50,862.50,'2023-02-18 17:36:49','',''),(3333,'1','310','1',1,'Retail Sale Id 3232',9000.00,0.00,0.00,12.50,862.50,'2023-02-18 17:37:45','',''),(3334,'1','310','1',1,'Retail Sale Id 3233',1000.80,0.00,0.00,1.39,95.91,'2023-02-18 17:38:27','',''),(3335,'1','310','1',1,'Return of Retail Sale Id 3232',0.00,9000.00,12.50,0.00,-862.50,'2023-02-18 17:39:24','',''),(3336,'1','310','1',1,'Retail Sale Id 3234',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 17:43:04','',''),(3337,'1','310','1',1,'Retail Sale Id 3235',1101.60,0.00,0.00,1.53,105.57,'2023-02-18 17:46:51','',''),(3338,'1','310','1',1,'Retail Sale Id 3236',1440.00,0.00,0.00,2.00,138.00,'2023-02-18 17:53:33','',''),(3339,'1','310','1',1,'Retail Sale Id 3237',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 17:55:15','',''),(3340,'1','310','1',1,'Retail Sale Id 3238',1497.60,0.00,0.00,2.08,143.52,'2023-02-18 17:58:13','',''),(3341,'1','310','1',1,'Retail Sale Id 3239',2001.60,0.00,0.00,2.78,191.82,'2023-02-18 17:59:41','',''),(3342,'1','310','1',1,'Retail Sale Id 3240',1000.80,0.00,0.00,1.39,95.91,'2023-02-18 18:01:27','',''),(3343,'1','310','1',1,'Retail Sale Id 3241',9000.00,0.00,0.00,12.50,862.50,'2023-02-18 18:03:02','',''),(3344,'1','310','1',1,'Retail Sale Id 3241',14400.00,0.00,0.00,20.00,1380.00,'2023-02-18 18:03:02','',''),(3345,'1','310','1',1,'Retail Sale Id 3242',3002.40,0.00,0.00,4.17,287.73,'2023-02-18 18:04:50','',''),(3346,'1','310','1',1,'Retail Sale Id 3243',1000.80,0.00,0.00,1.39,95.91,'2023-02-18 18:06:42','',''),(3347,'1','310','1',1,'Retail Sale Id 3244',3002.40,0.00,0.00,4.17,287.73,'2023-02-18 18:07:54','',''),(3348,'1','310','1',1,'Retail Sale Id 3245',9000.00,0.00,0.00,12.50,862.50,'2023-02-18 18:08:48','',''),(3349,'1','310','1',1,'Retail Sale Id 3246',9000.00,0.00,0.00,12.50,862.50,'2023-02-18 18:09:47','',''),(3350,'1','310','1',1,'Retail Sale Id 3247',2001.60,0.00,0.00,2.78,191.82,'2023-02-18 18:10:42','',''),(3351,'1','310','1',1,'Retail Sale Id 3248',2160.00,0.00,0.00,3.00,207.00,'2023-02-18 18:11:21','',''),(3352,'1','310','1',1,'Retail Sale Id 3249',2001.60,0.00,0.00,2.78,191.82,'2023-02-18 18:12:18','',''),(3353,'1','310','1',1,'Retail Sale Id 3250',8280.00,0.00,0.00,11.50,793.50,'2023-02-18 18:13:37','',''),(3354,'1','310','1',1,'Retail Sale Id 3251',1440.00,0.00,0.00,2.00,138.00,'2023-02-18 18:14:21','',''),(3355,'1','310','1',1,'Retail Sale Id 3252',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 18:16:28','',''),(3356,'1','310','1',1,'Retail Sale Id 3254',4399.20,0.00,0.00,6.11,421.59,'2023-02-18 18:17:55','',''),(3357,'1','310','1',1,'Retail Sale Id 3255',5760.00,0.00,0.00,8.00,552.00,'2023-02-18 18:18:48','',''),(3358,'1','310','1',1,'Retail Sale Id 3256',496.80,0.00,0.00,0.69,47.61,'2023-02-18 18:25:48','',''),(3359,'1','310','1',1,'Retail Sale Id 3257',2160.00,0.00,0.00,3.00,207.00,'2023-02-18 18:27:13','',''),(3360,'1','310','1',1,'Retail Sale Id 3258',1303.20,0.00,0.00,1.81,124.89,'2023-02-18 18:29:26','',''),(3361,'1','310','1',1,'Retail Sale Id 3259',3600.00,0.00,0.00,5.00,345.00,'2023-02-18 18:38:06','',''),(3362,'1','310','1',1,'Retail Sale Id 3260',3600.00,0.00,0.00,5.00,345.00,'2023-02-18 18:47:38','',''),(3363,'1','310','1',1,'Retail Sale Id 3262',2160.00,0.00,0.00,3.00,207.00,'2023-02-18 18:51:08','',''),(3364,'1','310','1',1,'Retail Sale Id 3263',1497.60,0.00,0.00,2.08,143.52,'2023-02-18 18:52:16','',''),(3365,'1','310','1',1,'Retail Sale Id 3264',3499.20,0.00,0.00,4.86,335.34,'2023-02-18 18:59:30','',''),(3366,'1','310','1',1,'Retail Sale Id 3265',496.80,0.00,0.00,0.69,47.61,'2023-02-18 19:05:05','',''),(3367,'1','310','1',1,'Retail Sale Id 3266',9000.00,0.00,0.00,12.50,862.50,'2023-02-18 19:09:12','',''),(3368,'1','310','1',1,'Retail Sale Id 3268',4320.00,0.00,0.00,6.00,414.00,'2023-02-18 19:10:56','',''),(3369,'1','310','1',1,'Retail Sale Id 3268',9000.00,0.00,0.00,12.50,862.50,'2023-02-18 19:10:56','',''),(3370,'1','310','1',1,'Return of Retail Sale Id 3262',0.00,2160.00,3.00,0.00,-207.00,'2023-02-18 19:28:46','',''),(3371,'1','310','1',1,'Retail Sale Id 3269',568.80,0.00,0.00,0.79,54.51,'2023-02-18 19:31:03','',''),(3372,'1','310','1',1,'Return of Retail Sale Id 3198',0.00,9450.00,13.50,0.00,-661.50,'2023-02-18 19:35:40','',''),(3373,'1','310','1',1,'Retail Sale Id 3270',9457.00,0.00,0.00,13.51,661.99,'2023-02-18 19:36:36','',''),(3374,'1','310','1',1,'Retail Sale Id 3271',4320.00,0.00,0.00,6.00,414.00,'2023-02-19 07:20:06','',''),(3375,'1','310','1',1,'Retail Sale Id 3272',42000.00,0.00,0.00,60.00,2940.00,'2023-02-19 07:26:29','',''),(3376,'1','310','1',1,'Retail Sale Id 3273',2203.20,0.00,0.00,3.06,211.14,'2023-02-19 07:46:47','',''),(3377,'1','310','1',1,'Retail Sale Id 3274',4320.00,0.00,0.00,6.00,414.00,'2023-02-19 07:52:00','',''),(3378,'1','310','1',1,'Retail Sale Id 3275',1000.80,0.00,0.00,1.39,95.91,'2023-02-19 08:00:38','',''),(3379,'1','310','1',1,'Retail Sale Id 3276',2160.00,0.00,0.00,3.00,207.00,'2023-02-19 08:01:44','',''),(3380,'1','310','1',1,'Retail Sale Id 3277',3002.40,0.00,0.00,4.17,287.73,'2023-02-19 08:18:13','',''),(3381,'1','310','1',1,'Retail Sale Id 3278',4003.20,0.00,0.00,5.56,383.64,'2023-02-19 08:19:51','',''),(3382,'1','310','1',1,'Retail Sale Id 3280',3002.40,0.00,0.00,4.17,287.73,'2023-02-19 08:23:16','',''),(3383,'1','310','1',1,'Retail Sale Id 3281',1800.00,0.00,0.00,2.50,172.50,'2023-02-19 08:28:40','',''),(3384,'1','310','1',1,'Retail Sale Id 3282',3600.00,0.00,0.00,5.00,345.00,'2023-02-19 08:29:47','',''),(3385,'1','310','1',1,'Retail Sale Id 3283',3002.40,0.00,0.00,4.17,287.73,'2023-02-19 08:39:14','',''),(3386,'1','310','1',1,'Retail Sale Id 3284',1497.60,0.00,0.00,2.08,143.52,'2023-02-19 08:40:21','',''),(3387,'1','310','1',1,'Retail Sale Id 3285',18000.00,0.00,0.00,25.00,1725.00,'2023-02-19 08:41:34','',''),(3388,'1','310','1',1,'Retail Sale Id 3286',9000.00,0.00,0.00,12.50,862.50,'2023-02-19 08:49:22','',''),(3389,'1','310','1',1,'Retail Sale Id 3287',1440.00,0.00,0.00,2.00,138.00,'2023-02-19 08:50:18','',''),(3390,'1','310','1',1,'Retail Sale Id 3288',2160.00,0.00,0.00,3.00,207.00,'2023-02-19 08:51:39','',''),(3391,'1','310','1',1,'Retail Sale Id 3289',22498.00,0.00,0.00,32.14,1574.86,'2023-02-19 08:56:41','',''),(3392,'1','310','1',1,'Retail Sale Id 3290',3002.40,0.00,0.00,4.17,287.73,'2023-02-19 08:58:33','',''),(3393,'1','310','1',1,'Retail Sale Id 3291',1000.80,0.00,0.00,1.39,95.91,'2023-02-19 08:59:43','',''),(3394,'1','310','1',1,'Retail Sale Id 3292',2498.40,0.00,0.00,3.47,239.43,'2023-02-19 09:01:48','',''),(3395,'1','310','1',1,'Retail Sale Id 3293',2498.40,0.00,0.00,3.47,239.43,'2023-02-19 09:03:58','',''),(3396,'1','310','1',1,'Retail Sale Id 3294',9000.00,0.00,0.00,12.50,862.50,'2023-02-19 09:05:20','',''),(3397,'1','310','1',1,'Retail Sale Id 3295',2160.00,0.00,0.00,3.00,207.00,'2023-02-19 09:06:49','',''),(3398,'1','310','1',1,'Retail Sale Id 3296',3600.00,0.00,0.00,5.00,345.00,'2023-02-19 09:13:54','',''),(3399,'1','310','1',1,'Retail Sale Id 3297',9000.00,0.00,0.00,12.50,862.50,'2023-02-19 09:19:33','',''),(3400,'1','310','1',1,'Retail Sale Id 3298',4320.00,0.00,0.00,6.00,414.00,'2023-02-19 09:21:15','',''),(3401,'1','310','1',1,'Retail Sale Id 3299',1497.60,0.00,0.00,2.08,143.52,'2023-02-19 09:22:32','',''),(3402,'1','310','1',1,'Retail Sale Id 3300',2160.00,0.00,0.00,3.00,207.00,'2023-02-19 09:34:08','',''),(3403,'1','310','1',1,'Retail Sale Id 3301',3002.40,0.00,0.00,4.17,287.73,'2023-02-19 09:38:29','',''),(3404,'1','310','1',1,'Retail Sale Id 3302',1497.60,0.00,0.00,2.08,143.52,'2023-02-19 09:46:06','',''),(3405,'1','310','1',1,'Retail Sale Id 3303',2001.60,0.00,0.00,2.78,191.82,'2023-02-19 09:51:59','',''),(3406,'1','310','1',1,'Retail Sale Id 3304',2001.60,0.00,0.00,2.78,191.82,'2023-02-19 09:53:42','',''),(3407,'1','310','1',1,'Retail Sale Id 3305',5752.80,0.00,0.00,7.99,551.31,'2023-02-19 10:00:59','',''),(3408,'1','310','1',1,'Retail Sale Id 3306',5040.00,0.00,0.00,7.00,483.00,'2023-02-19 10:03:59','',''),(3409,'1','310','1',1,'Retail Sale Id 3307',1497.60,0.00,0.00,2.08,143.52,'2023-02-19 10:08:57','',''),(3410,'1','310','1',1,'Retail Sale Id 3308',4320.00,0.00,0.00,6.00,414.00,'2023-02-19 10:11:32','',''),(3411,'1','310','1',1,'Retail Sale Id 3309',2001.60,0.00,0.00,2.78,191.82,'2023-02-19 10:12:37','',''),(3412,'1','310','1',1,'Retail Sale Id 3312',4320.00,0.00,0.00,6.00,414.00,'2023-02-19 10:16:04','',''),(3413,'1','310','1',1,'Retail Sale Id 3312',9000.00,0.00,0.00,12.50,862.50,'2023-02-19 10:16:04','',''),(3414,'1','310','1',1,'Retail Sale Id 3313',2160.00,0.00,0.00,3.00,207.00,'2023-02-19 10:23:28','',''),(3415,'1','310','1',1,'Retail Sale Id 3314',2160.00,0.00,0.00,3.00,207.00,'2023-02-19 10:31:11','',''),(3416,'1','310','1',1,'Retail Sale Id 3315',2160.00,0.00,0.00,3.00,207.00,'2023-02-19 10:33:45','',''),(3417,'1','310','1',1,'Retail Sale Id 3316',4996.80,0.00,0.00,6.94,478.86,'2023-02-19 10:39:09','',''),(3418,'1','310','1',1,'Retail Sale Id 3317',4500.00,0.00,0.00,6.25,431.25,'2023-02-19 10:42:26','',''),(3419,'1','310','1',1,'Retail Sale Id 3320',720.00,0.00,0.00,1.00,69.00,'2023-02-19 10:46:16','',''),(3420,'1','310','1',1,'Retail Sale Id 3321',7999.20,0.00,0.00,11.11,766.59,'2023-02-19 10:49:22','',''),(3421,'1','310','1',1,'Retail Sale Id 3322',4320.00,0.00,0.00,6.00,414.00,'2023-02-19 10:53:39','',''),(3422,'1','310','1',1,'Retail Sale Id 3323',2160.00,0.00,0.00,3.00,207.00,'2023-02-19 10:54:33','',''),(3423,'1','310','1',1,'Retail Sale Id 3324',1202.40,0.00,0.00,1.67,115.23,'2023-02-19 11:00:43','',''),(3424,'1','310','1',1,'Retail Sale Id 3325',1000.80,0.00,0.00,1.39,95.91,'2023-02-19 11:02:45','',''),(3425,'1','310','1',1,'Retail Sale Id 3326',7920.00,0.00,0.00,11.00,759.00,'2023-02-19 11:03:47','',''),(3426,'1','310','1',1,'Retail Sale Id 3327',4320.00,0.00,0.00,6.00,414.00,'2023-02-19 11:16:53','',''),(3427,'1','310','1',1,'Retail Sale Id 3328',1497.60,0.00,0.00,2.08,143.52,'2023-02-19 11:18:35','',''),(3428,'1','310','1',1,'Retail Sale Id 3330',9000.00,0.00,0.00,12.50,862.50,'2023-02-19 11:25:41','',''),(3429,'1','310','1',1,'Retail Sale Id 3331',3002.40,0.00,0.00,4.17,287.73,'2023-02-19 11:32:28','',''),(3430,'1','310','1',1,'Retail Sale Id 3332',1497.60,0.00,0.00,2.08,143.52,'2023-02-19 11:35:38','',''),(3431,'1','310','1',1,'Retail Sale Id 3333',9000.00,0.00,0.00,12.50,862.50,'2023-02-19 11:36:56','',''),(3432,'1','310','1',1,'Retail Sale Id 3334',720.00,0.00,0.00,1.00,69.00,'2023-02-19 11:39:44','',''),(3433,'1','310','1',1,'Retail Sale Id 3334',720.00,0.00,0.00,1.00,69.00,'2023-02-19 11:39:44','',''),(3434,'1','310','1',1,'Retail Sale Id 3334',720.00,0.00,0.00,1.00,69.00,'2023-02-19 11:39:44','',''),(3435,'1','310','1',1,'Retail Sale Id 3337',2160.00,0.00,0.00,3.00,207.00,'2023-02-19 11:49:16','',''),(3436,'1','310','1',1,'Retail Sale Id 3338',5760.00,0.00,0.00,8.00,552.00,'2023-02-19 11:51:21','',''),(3437,'1','310','1',1,'Retail Sale Id 3338',9000.00,0.00,0.00,12.50,862.50,'2023-02-19 11:51:21','',''),(3438,'1','310','1',1,'Retail Sale Id 3339',2001.60,0.00,0.00,2.78,191.82,'2023-02-19 12:00:51','',''),(3439,'1','310','1',1,'Retail Sale Id 3340',3600.00,0.00,0.00,5.00,345.00,'2023-02-19 12:03:40','',''),(3440,'1','310','1',1,'Retail Sale Id 3341',2001.60,0.00,0.00,2.78,191.82,'2023-02-19 12:05:38','',''),(3441,'1','310','1',1,'Retail Sale Id 3342',2001.60,0.00,0.00,2.78,191.82,'2023-02-19 12:10:54','',''),(3442,'1','310','1',1,'Retail Sale Id 3343',1800.00,0.00,0.00,2.50,172.50,'2023-02-19 12:11:39','',''),(3443,'1','310','1',1,'Retail Sale Id 3344',4320.00,0.00,0.00,6.00,414.00,'2023-02-19 12:13:30','',''),(3444,'1','310','1',1,'Retail Sale Id 3345',9000.00,0.00,0.00,12.50,862.50,'2023-02-19 12:14:49','',''),(3445,'1','310','1',1,'Retail Sale Id 3346',2160.00,0.00,0.00,3.00,207.00,'2023-02-19 12:17:39','',''),(3446,'1','310','1',1,'Retail Sale Id 3347',21600.00,0.00,0.00,30.00,2070.00,'2023-02-19 12:20:10','',''),(3447,'1','310','1',1,'Retail Sale Id 3348',1000.80,0.00,0.00,1.39,95.91,'2023-02-19 12:21:19','',''),(3448,'1','310','1',1,'Retail Sale Id 3349',4003.20,0.00,0.00,5.56,383.64,'2023-02-19 12:22:06','',''),(3449,'1','310','1',1,'Retail Sale Id 3350',2001.60,0.00,0.00,2.78,191.82,'2023-02-19 12:23:44','',''),(3450,'1','310','1',1,'Retail Sale Id 3351',748.80,0.00,0.00,1.04,71.76,'2023-02-19 12:25:05','',''),(3451,'1','310','1',1,'Retail Sale Id 3352',1440.00,0.00,0.00,2.00,138.00,'2023-02-19 12:26:01','',''),(3452,'1','310','1',1,'Retail Sale Id 3353',2001.60,0.00,0.00,2.78,191.82,'2023-02-19 12:30:54','',''),(3453,'1','310','1',1,'Retail Sale Id 3354',720.00,0.00,0.00,1.00,69.00,'2023-02-19 12:33:32','',''),(3454,'1','310','1',1,'Retail Sale Id 3355',3600.00,0.00,0.00,5.00,345.00,'2023-02-19 12:36:59','',''),(3455,'1','310','1',1,'Retail Sale Id 3356',35000.00,0.00,0.00,50.00,2450.00,'2023-02-19 12:40:05','',''),(3456,'1','310','1',1,'Retail Sale Id 3357',78750.00,0.00,0.00,112.50,5512.50,'2023-02-19 12:41:30','',''),(3457,'1','310','1',1,'Retail Sale Id 3358',1000.80,0.00,0.00,1.39,95.91,'2023-02-19 12:42:33','',''),(3458,'1','310','1',1,'Retail Sale Id 3359',3002.40,0.00,0.00,4.17,287.73,'2023-02-19 12:43:11','',''),(3459,'1','310','1',1,'Retail Sale Id 3360',2001.60,0.00,0.00,2.78,191.82,'2023-02-19 12:45:09','',''),(3460,'1','310','1',1,'Retail Sale Id 3360',2001.60,0.00,0.00,2.78,191.82,'2023-02-19 12:45:09','',''),(3461,'1','310','1',1,'Retail Sale Id 3360',9000.00,0.00,0.00,12.50,862.50,'2023-02-19 12:45:09','',''),(3462,'1','310','1',1,'Retail Sale Id 3361',4320.00,0.00,0.00,6.00,414.00,'2023-02-19 12:47:09','',''),(3463,'1','310','1',1,'Retail Sale Id 3362',3002.40,0.00,0.00,4.17,287.73,'2023-02-19 12:47:59','',''),(3464,'1','310','1',1,'Retail Sale Id 3363',720.00,0.00,0.00,1.00,69.00,'2023-02-19 12:49:39','',''),(3465,'1','310','1',1,'Retail Sale Id 3364',496.80,0.00,0.00,0.69,47.61,'2023-02-19 12:57:28','',''),(3466,'1','310','1',1,'Retail Sale Id 3365',1800.00,0.00,0.00,2.50,172.50,'2023-02-19 13:03:52','',''),(3467,'1','310','1',1,'Retail Sale Id 3366',3600.00,0.00,0.00,5.00,345.00,'2023-02-19 13:04:46','',''),(3468,'1','310','1',1,'Retail Sale Id 3367',1000.80,0.00,0.00,1.39,95.91,'2023-02-19 13:05:42','',''),(3469,'1','310','1',1,'Retail Sale Id 3368',4320.00,0.00,0.00,6.00,414.00,'2023-02-19 13:20:01','',''),(3470,'1','310','1',1,'Retail Sale Id 3369',4500.00,0.00,0.00,6.25,431.25,'2023-02-19 13:21:30','',''),(3471,'1','310','1',1,'Retail Sale Id 3370',9000.00,0.00,0.00,12.50,862.50,'2023-02-19 13:22:27','',''),(3472,'1','310','1',1,'Retail Sale Id 3371',1000.80,0.00,0.00,1.39,95.91,'2023-02-19 13:23:39','',''),(3473,'1','310','1',1,'Retail Sale Id 3372',2160.00,0.00,0.00,3.00,207.00,'2023-02-19 13:24:28','',''),(3474,'1','310','1',1,'Retail Sale Id 3373',3600.00,0.00,0.00,5.00,345.00,'2023-02-19 13:31:27','',''),(3475,'1','310','1',1,'Retail Sale Id 3374',9000.00,0.00,0.00,12.50,862.50,'2023-02-19 13:32:57','',''),(3476,'1','310','1',1,'Retail Sale Id 3375',9000.00,0.00,0.00,12.50,862.50,'2023-02-19 13:34:13','',''),(3477,'1','310','1',1,'Retail Sale Id 3376',4320.00,0.00,0.00,6.00,414.00,'2023-02-19 13:38:37','',''),(3478,'1','310','1',1,'Retail Sale Id 3377',9000.00,0.00,0.00,12.50,862.50,'2023-02-19 13:40:24','',''),(3479,'1','310','1',1,'Retail Sale Id 3378',496.80,0.00,0.00,0.69,47.61,'2023-02-19 14:00:51','',''),(3480,'1','310','1',1,'Retail Sale Id 3379',5040.00,0.00,0.00,7.00,483.00,'2023-02-19 14:07:53','',''),(3481,'1','310','1',1,'Retail Sale Id 3380',8400.00,0.00,0.00,12.00,588.00,'2023-02-19 14:15:38','',''),(3482,'1','310','1',1,'Retail Sale Id 3381',5040.00,0.00,0.00,7.00,483.00,'2023-02-19 14:17:48','',''),(3483,'1','310','1',1,'Retail Sale Id 3382',2160.00,0.00,0.00,3.00,207.00,'2023-02-19 14:18:52','',''),(3484,'1','310','1',1,'Retail Sale Id 3383',1800.00,0.00,0.00,2.50,172.50,'2023-02-19 14:21:11','',''),(3485,'1','310','1',1,'Retail Sale Id 3384',4320.00,0.00,0.00,6.00,414.00,'2023-02-19 14:23:25','',''),(3486,'1','310','1',1,'Retail Sale Id 3385',140000.00,0.00,0.00,200.00,9800.00,'2023-02-19 14:24:50','',''),(3487,'1','310','1',1,'Retail Sale Id 3386',1497.60,0.00,0.00,2.08,143.52,'2023-02-19 14:27:45','',''),(3488,'1','310','1',1,'Retail Sale Id 3387',4320.00,0.00,0.00,6.00,414.00,'2023-02-19 14:36:05','',''),(3489,'1','310','1',1,'Retail Sale Id 3388',4996.80,0.00,0.00,6.94,478.86,'2023-02-19 14:45:48','',''),(3490,'1','310','1',1,'Retail Sale Id 3390',14000.00,0.00,0.00,20.00,980.00,'2023-02-19 14:59:54','',''),(3491,'1','310','1',1,'Retail Sale Id 3391',2001.60,0.00,0.00,2.78,191.82,'2023-02-19 15:07:07','',''),(3492,'1','310','1',1,'Retail Sale Id 3392',4996.80,0.00,0.00,6.94,478.86,'2023-02-19 15:14:48','',''),(3493,'1','310','1',1,'Retail Sale Id 3393',9000.00,0.00,0.00,12.50,862.50,'2023-02-19 15:17:04','',''),(3494,'1','310','1',1,'Retail Sale Id 3393',9000.00,0.00,0.00,12.50,862.50,'2023-02-19 15:17:04','',''),(3495,'1','310','1',1,'Retail Sale Id 3395',1000.80,0.00,0.00,1.39,95.91,'2023-02-19 15:20:51','',''),(3496,'1','310','1',1,'Retail Sale Id 3396',2296.80,0.00,0.00,3.19,220.11,'2023-02-19 15:24:47','',''),(3497,'1','310','1',1,'Retail Sale Id 3397',2001.60,0.00,0.00,2.78,191.82,'2023-02-19 15:26:46','',''),(3498,'1','310','1',1,'Retail Sale Id 3398',2160.00,0.00,0.00,3.00,207.00,'2023-02-19 15:50:05','',''),(3499,'1','310','1',1,'Retail Sale Id 3399',2160.00,0.00,0.00,3.00,207.00,'2023-02-19 15:51:08','',''),(3500,'1','310','1',1,'Retail Sale Id 3400',1440.00,0.00,0.00,2.00,138.00,'2023-02-19 16:15:41','',''),(3501,'1','310','1',1,'Retail Sale Id 3401',4500.00,0.00,0.00,6.25,431.25,'2023-02-19 16:18:05','',''),(3502,'1','310','1',1,'Retail Sale Id 3402',496.80,0.00,0.00,0.69,47.61,'2023-02-19 16:19:00','',''),(3503,'1','310','1',1,'Retail Sale Id 3403',4320.00,0.00,0.00,6.00,414.00,'2023-02-19 16:20:09','',''),(3504,'1','310','1',1,'Retail Sale Id 3404',1440.00,0.00,0.00,2.00,138.00,'2023-02-19 16:21:21','',''),(3505,'1','310','1',1,'Retail Sale Id 3405',1440.00,0.00,0.00,2.00,138.00,'2023-02-19 16:24:16','',''),(3506,'1','310','1',1,'Retail Sale Id 3406',4320.00,0.00,0.00,6.00,414.00,'2023-02-19 16:25:07','',''),(3507,'1','310','1',1,'Retail Sale Id 3407',1497.60,0.00,0.00,2.08,143.52,'2023-02-19 16:27:39','',''),(3508,'1','310','1',1,'Retail Sale Id 3408',1000.80,0.00,0.00,1.39,95.91,'2023-02-19 16:29:41','',''),(3509,'1','310','1',1,'Retail Sale Id 3410',4500.00,0.00,0.00,6.25,431.25,'2023-02-19 16:30:53','',''),(3510,'1','310','1',1,'Retail Sale Id 3411',2160.00,0.00,0.00,3.00,207.00,'2023-02-19 16:31:58','',''),(3511,'1','310','1',1,'Retail Sale Id 3412',2001.60,0.00,0.00,2.78,191.82,'2023-02-19 16:38:31','',''),(3512,'1','310','1',1,'Retail Sale Id 3413',9000.00,0.00,0.00,12.50,862.50,'2023-02-19 16:42:35','',''),(3513,'1','310','1',1,'Retail Sale Id 3414',2001.60,0.00,0.00,2.78,191.82,'2023-02-19 16:43:38','',''),(3514,'1','310','1',1,'Retail Sale Id 3415',3600.00,0.00,0.00,5.00,345.00,'2023-02-19 16:46:03','',''),(3515,'1','310','1',1,'Retail Sale Id 3416',2160.00,0.00,0.00,3.00,207.00,'2023-02-19 16:50:18','',''),(3516,'1','310','1',1,'Retail Sale Id 3417',9000.00,0.00,0.00,12.50,862.50,'2023-02-19 16:51:30','',''),(3517,'1','310','1',1,'Retail Sale Id 3418',2880.00,0.00,0.00,4.00,276.00,'2023-02-19 16:57:10','',''),(3518,'1','310','1',1,'Retail Sale Id 3419',1440.00,0.00,0.00,2.00,138.00,'2023-02-19 17:03:39','',''),(3519,'1','310','1',1,'Retail Sale Id 3420',4320.00,0.00,0.00,6.00,414.00,'2023-02-19 17:18:43','',''),(3520,'1','310','1',1,'Retail Sale Id 3421',9000.00,0.00,0.00,12.50,862.50,'2023-02-19 17:24:18','',''),(3521,'1','310','1',1,'Retail Sale Id 3423',2160.00,0.00,0.00,3.00,207.00,'2023-02-19 17:30:56','',''),(3522,'1','310','1',1,'Retail Sale Id 3424',3002.40,0.00,0.00,4.17,287.73,'2023-02-19 17:32:50','',''),(3523,'1','310','1',1,'Retail Sale Id 3425',2160.00,0.00,0.00,3.00,207.00,'2023-02-19 17:35:08','',''),(3524,'1','310','1',1,'Retail Sale Id 3425',9000.00,0.00,0.00,12.50,862.50,'2023-02-19 17:35:08','',''),(3525,'1','310','1',1,'Retail Sale Id 3426',1000.80,0.00,0.00,1.39,95.91,'2023-02-19 17:36:03','',''),(3526,'1','310','1',1,'Retail Sale Id 3427',3002.40,0.00,0.00,4.17,287.73,'2023-02-19 17:36:57','',''),(3527,'1','310','1',1,'Retail Sale Id 3428',2160.00,0.00,0.00,3.00,207.00,'2023-02-19 17:46:00','',''),(3528,'1','310','1',1,'Retail Sale Id 3429',4320.00,0.00,0.00,6.00,414.00,'2023-02-19 17:51:01','',''),(3529,'1','310','1',1,'Retail Sale Id 3430',2001.60,0.00,0.00,2.78,191.82,'2023-02-19 18:03:27','',''),(3530,'1','310','1',1,'Retail Sale Id 3431',4494.00,0.00,0.00,6.42,314.58,'2023-02-19 18:07:02','',''),(3531,'1','310','1',1,'Retail Sale Id 3432',9000.00,0.00,0.00,12.50,862.50,'2023-02-19 18:08:43','',''),(3532,'1','310','1',1,'Retail Sale Id 3433',1000.80,0.00,0.00,1.39,95.91,'2023-02-19 18:14:36','',''),(3533,'1','310','1',1,'Retail Sale Id 3434',2160.00,0.00,0.00,3.00,207.00,'2023-02-19 18:15:23','',''),(3534,'1','310','1',1,'Retail Sale Id 3435',1000.80,0.00,0.00,1.39,95.91,'2023-02-19 18:21:49','',''),(3535,'1','310','1',1,'Retail Sale Id 3436',799.20,0.00,0.00,1.11,76.59,'2023-02-19 18:25:24','',''),(3536,'1','310','1',1,'Retail Sale Id 3437',27237.60,0.00,0.00,37.83,2610.27,'2023-02-19 19:03:58','',''),(3537,'1','310','1',1,'Return of Retail Sale Id 3431',0.00,4494.00,6.42,0.00,-314.58,'2023-02-19 19:05:39','',''),(3538,'1','310','1',1,'Retail Sale Id 3438',4368.00,0.00,0.00,6.24,305.76,'2023-02-19 19:06:34','',''),(3539,'1','310','1',1,'Retail Sale Id 3439',2001.60,0.00,0.00,2.78,191.82,'2023-02-20 06:56:15','',''),(3540,'1','310','1',1,'Retail Sale Id 3440',1000.80,0.00,0.00,1.39,95.91,'2023-02-20 07:23:01','',''),(3541,'1','310','1',1,'Retail Sale Id 3441',4701.60,0.00,0.00,6.53,450.57,'2023-02-20 07:26:04','',''),(3542,'1','310','1',1,'Retail Sale Id 3442',9000.00,0.00,0.00,12.50,862.50,'2023-02-20 07:28:33','',''),(3543,'1','310','1',1,'Retail Sale Id 3443',2160.00,0.00,0.00,3.00,207.00,'2023-02-20 07:30:16','',''),(3544,'1','310','1',1,'Retail Sale Id 3444',4003.20,0.00,0.00,5.56,383.64,'2023-02-20 07:35:22','',''),(3545,'1','310','1',1,'Retail Sale Id 3445',1000.80,0.00,0.00,1.39,95.91,'2023-02-20 07:48:14','',''),(3546,'1','310','1',1,'Retail Sale Id 3446',8400.00,0.00,0.00,12.00,588.00,'2023-02-20 08:00:26','',''),(3547,'1','310','1',1,'Retail Sale Id 3448',3002.40,0.00,0.00,4.17,287.73,'2023-02-20 08:02:31','',''),(3548,'1','310','1',1,'Retail Sale Id 3449',2001.60,0.00,0.00,2.78,191.82,'2023-02-20 08:14:00','',''),(3549,'1','310','1',1,'Retail Sale Id 3449',3002.40,0.00,0.00,4.17,287.73,'2023-02-20 08:14:00','',''),(3550,'1','310','1',1,'Retail Sale Id 3450',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 08:17:03','',''),(3551,'1','310','1',1,'Retail Sale Id 3450',9000.00,0.00,0.00,12.50,862.50,'2023-02-20 08:17:03','',''),(3552,'1','310','1',1,'Retail Sale Id 3452',1497.60,0.00,0.00,2.08,143.52,'2023-02-20 08:18:50','',''),(3553,'1','310','1',1,'Retail Sale Id 3453',1497.60,0.00,0.00,2.08,143.52,'2023-02-20 08:19:41','',''),(3554,'1','310','1',1,'Retail Sale Id 3455',2160.00,0.00,0.00,3.00,207.00,'2023-02-20 08:31:23','',''),(3555,'1','310','1',1,'Retail Sale Id 3455',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 08:31:23','',''),(3556,'1','310','1',1,'Retail Sale Id 3456',9000.00,0.00,0.00,12.50,862.50,'2023-02-20 08:32:34','',''),(3557,'1','310','1',1,'Retail Sale Id 3457',4996.80,0.00,0.00,6.94,478.86,'2023-02-20 08:38:24','',''),(3558,'1','310','1',1,'Retail Sale Id 3458',1000.80,0.00,0.00,1.39,95.91,'2023-02-20 09:01:39','',''),(3559,'1','310','1',1,'Retail Sale Id 3459',2160.00,0.00,0.00,3.00,207.00,'2023-02-20 09:06:19','',''),(3560,'1','310','1',1,'Retail Sale Id 3460',70000.00,0.00,0.00,100.00,4900.00,'2023-02-20 09:10:39','',''),(3561,'1','310','1',1,'Retail Sale Id 3462',720.00,0.00,0.00,1.00,69.00,'2023-02-20 09:17:28','',''),(3562,'1','310','1',1,'Retail Sale Id 3462',1440.00,0.00,0.00,2.00,138.00,'2023-02-20 09:17:28','',''),(3563,'1','310','1',1,'Retail Sale Id 3463',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 09:21:19','',''),(3564,'1','310','1',1,'Retail Sale Id 3464',8400.00,0.00,0.00,12.00,588.00,'2023-02-20 09:30:07','',''),(3565,'1','310','1',1,'Retail Sale Id 3465',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 09:36:40','',''),(3566,'1','310','1',1,'Retail Sale Id 3466',2001.60,0.00,0.00,2.78,191.82,'2023-02-20 09:37:57','',''),(3567,'1','310','1',1,'Retail Sale Id 3467',2001.60,0.00,0.00,2.78,191.82,'2023-02-20 09:47:41','',''),(3568,'1','310','1',1,'Retail Sale Id 3468',3002.40,0.00,0.00,4.17,287.73,'2023-02-20 09:48:17','',''),(3569,'1','310','1',1,'Retail Sale Id 3469',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 09:49:10','',''),(3570,'1','310','1',1,'Retail Sale Id 3470',35000.00,0.00,0.00,50.00,2450.00,'2023-02-20 09:50:38','',''),(3571,'1','310','1',1,'Retail Sale Id 3471',9000.00,0.00,0.00,12.50,862.50,'2023-02-20 10:01:18','',''),(3572,'1','310','1',1,'Retail Sale Id 3472',2160.00,0.00,0.00,3.00,207.00,'2023-02-20 10:03:38','',''),(3573,'1','310','1',1,'Retail Sale Id 3473',1000.80,0.00,0.00,1.39,95.91,'2023-02-20 10:06:23','',''),(3574,'1','310','1',1,'Retail Sale Id 3475',1497.60,0.00,0.00,2.08,143.52,'2023-02-20 10:18:51','',''),(3575,'1','310','1',1,'Retail Sale Id 3476',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 10:38:45','',''),(3576,'1','310','1',1,'Retail Sale Id 3476',9000.00,0.00,0.00,12.50,862.50,'2023-02-20 10:38:45','',''),(3577,'1','310','1',1,'Retail Sale Id 3476',9000.00,0.00,0.00,12.50,862.50,'2023-02-20 10:38:45','',''),(3578,'1','310','1',1,'Retail Sale Id 3477',4996.80,0.00,0.00,6.94,478.86,'2023-02-20 10:40:18','',''),(3579,'1','310','1',1,'Retail Sale Id 3478',3600.00,0.00,0.00,5.00,345.00,'2023-02-20 11:00:00','',''),(3580,'1','310','1',1,'Retail Sale Id 3478',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 11:00:00','',''),(3581,'1','310','1',1,'Retail Sale Id 3480',1497.60,0.00,0.00,2.08,143.52,'2023-02-20 11:14:25','',''),(3582,'1','310','1',1,'Retail Sale Id 3481',3002.40,0.00,0.00,4.17,287.73,'2023-02-20 11:22:45','',''),(3583,'1','310','1',1,'Retail Sale Id 3483',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 11:28:09','',''),(3584,'1','310','1',1,'Retail Sale Id 3484',4996.80,0.00,0.00,6.94,478.86,'2023-02-20 11:32:08','',''),(3585,'1','310','1',1,'Retail Sale Id 3485',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 11:33:44','',''),(3586,'1','310','1',1,'Retail Sale Id 3486',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 11:36:17','',''),(3587,'1','310','1',1,'Retail Sale Id 3486',9000.00,0.00,0.00,12.50,862.50,'2023-02-20 11:36:17','',''),(3588,'1','310','1',1,'Retail Sale Id 3487',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 11:37:45','',''),(3589,'1','310','1',1,'Retail Sale Id 3488',2160.00,0.00,0.00,3.00,207.00,'2023-02-20 11:38:51','',''),(3590,'1','310','1',1,'Retail Sale Id 3489',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 11:43:27','',''),(3591,'1','310','1',1,'Retail Sale Id 3490',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 11:45:17','',''),(3592,'1','310','1',1,'Retail Sale Id 3491',2052.00,0.00,0.00,2.85,196.65,'2023-02-20 11:46:46','',''),(3593,'1','310','1',1,'Retail Sale Id 3492',1440.00,0.00,0.00,2.00,138.00,'2023-02-20 11:49:41','',''),(3594,'1','310','1',1,'Retail Sale Id 3493',9000.00,0.00,0.00,12.50,862.50,'2023-02-20 12:07:23','',''),(3595,'1','310','1',1,'Retail Sale Id 3494',1900.80,0.00,0.00,2.64,182.16,'2023-02-20 12:11:19','',''),(3596,'1','310','1',1,'Retail Sale Id 3495',1497.60,0.00,0.00,2.08,143.52,'2023-02-20 12:13:10','',''),(3597,'1','310','1',1,'Retail Sale Id 3496',1800.00,0.00,0.00,2.50,172.50,'2023-02-20 12:17:35','',''),(3598,'1','310','1',1,'Return of Retail Sale Id 3494',0.00,1900.80,2.64,0.00,-182.16,'2023-02-20 12:22:25','',''),(3599,'1','310','1',1,'Retail Sale Id 3497',9000.00,0.00,0.00,12.50,862.50,'2023-02-20 12:23:51','',''),(3600,'1','310','1',1,'Return of Retail Sale Id 3497',0.00,9000.00,12.50,0.00,-862.50,'2023-02-20 12:24:03','',''),(3601,'1','310','1',1,'Retail Sale Id 3498',9000.00,0.00,0.00,12.50,862.50,'2023-02-20 12:24:50','',''),(3602,'1','310','1',1,'Retail Sale Id 3499',2001.60,0.00,0.00,2.78,191.82,'2023-02-20 12:35:06','',''),(3603,'1','310','1',1,'Retail Sale Id 3500',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 12:39:33','',''),(3604,'1','310','1',1,'Retail Sale Id 3501',9000.00,0.00,0.00,12.50,862.50,'2023-02-20 12:40:55','',''),(3605,'1','310','1',1,'Retail Sale Id 3501',9000.00,0.00,0.00,12.50,862.50,'2023-02-20 12:40:55','',''),(3606,'1','310','1',1,'Retail Sale Id 3502',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 12:42:33','',''),(3607,'1','310','1',1,'Retail Sale Id 3503',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 12:44:10','',''),(3608,'1','310','1',1,'Retail Sale Id 3504',346500.00,0.00,0.00,495.00,24255.00,'2023-02-20 12:49:47','',''),(3609,'1','310','1',1,'Retail Sale Id 3505',1000.80,0.00,0.00,1.39,95.91,'2023-02-20 12:50:47','',''),(3610,'1','310','1',1,'Retail Sale Id 3507',698.40,0.00,0.00,0.97,66.93,'2023-02-20 13:08:10','',''),(3611,'1','310','1',1,'Retail Sale Id 3507',2160.00,0.00,0.00,3.00,207.00,'2023-02-20 13:08:10','',''),(3612,'1','310','1',1,'Return of Retail Sale Id 3507',0.00,698.40,0.97,0.00,-66.93,'2023-02-20 13:09:02','',''),(3613,'1','310','1',1,'Return of Retail Sale Id 3507',0.00,2160.00,3.00,0.00,-207.00,'2023-02-20 13:09:02','',''),(3614,'1','310','1',1,'Retail Sale Id 3508',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 13:11:41','',''),(3615,'1','310','1',1,'Retail Sale Id 3509',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 13:13:18','',''),(3616,'1','310','1',1,'Retail Sale Id 3510',2160.00,0.00,0.00,3.00,207.00,'2023-02-20 13:14:45','',''),(3617,'1','310','1',1,'Retail Sale Id 3511',496.80,0.00,0.00,0.69,47.61,'2023-02-20 13:15:43','',''),(3618,'1','310','1',1,'Retail Sale Id 3512',9000.00,0.00,0.00,12.50,862.50,'2023-02-20 13:18:00','',''),(3619,'1','310','1',1,'Retail Sale Id 3513',7999.20,0.00,0.00,11.11,766.59,'2023-02-20 13:18:53','',''),(3620,'1','310','1',1,'Retail Sale Id 3514',2001.60,0.00,0.00,2.78,191.82,'2023-02-20 13:20:37','',''),(3621,'1','310','1',1,'Retail Sale Id 3515',1497.60,0.00,0.00,2.08,143.52,'2023-02-20 13:23:05','',''),(3622,'1','310','1',1,'Retail Sale Id 3516',4500.00,0.00,0.00,6.25,431.25,'2023-02-20 13:24:02','',''),(3623,'1','310','1',1,'Retail Sale Id 3518',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 13:28:54','',''),(3624,'1','310','1',1,'Retail Sale Id 3519',9000.00,0.00,0.00,12.50,862.50,'2023-02-20 13:34:35','',''),(3625,'1','310','1',1,'Retail Sale Id 3519',9000.00,0.00,0.00,12.50,862.50,'2023-02-20 13:34:35','',''),(3626,'1','310','1',1,'Retail Sale Id 3519',9000.00,0.00,0.00,12.50,862.50,'2023-02-20 13:34:35','',''),(3627,'1','310','1',1,'Retail Sale Id 3520',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 13:35:50','',''),(3628,'1','310','1',1,'Retail Sale Id 3521',2160.00,0.00,0.00,3.00,207.00,'2023-02-20 13:56:38','',''),(3629,'1','310','1',1,'Retail Sale Id 3523',3002.40,0.00,0.00,4.17,287.73,'2023-02-20 14:04:13','',''),(3630,'1','310','1',1,'Return of Retail Sale Id 3513',0.00,7999.20,11.11,0.00,-766.59,'2023-02-20 14:28:54','',''),(3631,'1','310','1',1,'Retail Sale Id 3524',2995.20,0.00,0.00,4.16,287.04,'2023-02-20 14:29:35','',''),(3632,'1','310','1',1,'Distributed to OPERATIONAL LOSS for sales id:1',1737115.38,0.00,0.00,2668.38,0.00,'2023-02-20 17:19:28','',''),(3633,'1','310',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,16209900.00,24900.00,0.00,0.00,'2023-02-20 17:32:29','',''),(3634,'1','310',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,24900.00,0.00,'2023-02-20 17:36:37','',''),(3635,'1','310','1',1,'Received from bridging 3',0.00,0.00,24900.00,0.00,0.00,'2023-02-20 17:36:37','',''),(3636,'1','310','1',1,'Retail Sale Id 3525',3002.40,0.00,0.00,4.17,287.73,'2023-02-20 17:52:52','',''),(3637,'1','310','1',1,'Retail Sale Id 3526',2160.00,0.00,0.00,3.00,207.00,'2023-02-20 17:54:26','',''),(3638,'1','310','1',1,'Retail Sale Id 3527',1000.80,0.00,0.00,1.39,95.91,'2023-02-20 17:55:26','',''),(3639,'1','310','1',1,'Retail Sale Id 3528',9000.00,0.00,0.00,12.50,862.50,'2023-02-20 17:59:14','',''),(3640,'1','310','1',1,'Retail Sale Id 3529',4003.20,0.00,0.00,5.56,383.64,'2023-02-20 18:02:15','',''),(3641,'1','310','1',1,'Retail Sale Id 3530',3002.40,0.00,0.00,4.17,287.73,'2023-02-20 18:05:04','',''),(3642,'1','310','1',1,'Retail Sale Id 3531',1000.80,0.00,0.00,1.39,95.91,'2023-02-20 18:06:07','',''),(3643,'1','310','1',1,'Retail Sale Id 3532',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 18:08:09','',''),(3644,'1','310','1',1,'Retail Sale Id 3533',1497.60,0.00,0.00,2.08,143.52,'2023-02-20 18:11:34','',''),(3645,'1','310','1',1,'Retail Sale Id 3533',2001.60,0.00,0.00,2.78,191.82,'2023-02-20 18:11:34','',''),(3646,'1','310','1',1,'Retail Sale Id 3534',496.80,0.00,0.00,0.69,47.61,'2023-02-20 18:15:05','',''),(3647,'1','310','1',1,'Retail Sale Id 3535',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 18:16:03','',''),(3648,'1','310','1',1,'Retail Sale Id 3536',1000.80,0.00,0.00,1.39,95.91,'2023-02-20 18:22:15','',''),(3649,'1','310','1',1,'Retail Sale Id 3537',4320.00,0.00,0.00,6.00,414.00,'2023-02-20 18:26:54','',''),(3650,'1','310','1',1,'Retail Sale Id 3538',1000.80,0.00,0.00,1.39,95.91,'2023-02-20 18:33:53','',''),(3651,'1','310','1',1,'Retail Sale Id 3539',2160.00,0.00,0.00,3.00,207.00,'2023-02-20 18:39:09','',''),(3652,'1','310','1',1,'Retail Sale Id 3540',119613.60,0.00,0.00,166.13,11462.97,'2023-02-20 18:54:50','',''),(3653,'1','310','1',1,'Retail Sale Id 3541',146496.00,0.00,0.00,209.28,10254.72,'2023-02-20 19:05:22','',''),(3654,'1','310',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,16248960.00,24960.00,0.00,0.00,'2023-02-20 20:18:02','',''),(3655,'1','310',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,24960.00,0.00,'2023-02-20 20:20:06','',''),(3656,'1','310','1',1,'Received from bridging 4',0.00,0.00,24960.00,0.00,0.00,'2023-02-20 20:20:06','',''),(3657,'1','310','1',1,'Retail Sale Id 3542',2160.00,0.00,0.00,3.00,207.00,'2023-02-21 07:22:49','',''),(3658,'1','310','1',1,'Retail Sale Id 3543',2160.00,0.00,0.00,3.00,207.00,'2023-02-21 07:25:59','',''),(3659,'1','310','1',1,'Retail Sale Id 3544',9450.00,0.00,0.00,13.50,661.50,'2023-02-21 07:49:27','',''),(3660,'1','310','1',1,'Retail Sale Id 3545',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 08:05:42','',''),(3661,'1','310','1',1,'Retail Sale Id 3546',4320.00,0.00,0.00,6.00,414.00,'2023-02-21 08:44:58','',''),(3662,'1','310','1',1,'Retail Sale Id 3547',2160.00,0.00,0.00,3.00,207.00,'2023-02-21 08:47:30','',''),(3663,'1','310','1',1,'Retail Sale Id 3548',3600.00,0.00,0.00,5.00,345.00,'2023-02-21 08:51:59','',''),(3664,'1','310','1',1,'Retail Sale Id 3549',4320.00,0.00,0.00,6.00,414.00,'2023-02-21 09:03:03','',''),(3665,'1','310','1',1,'Retail Sale Id 3550',42000.00,0.00,0.00,60.00,2940.00,'2023-02-21 09:04:01','',''),(3666,'1','310','1',1,'Retail Sale Id 3551',1497.60,0.00,0.00,2.08,143.52,'2023-02-21 09:07:17','',''),(3667,'1','310','1',1,'Retail Sale Id 3552',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 09:23:07','',''),(3668,'1','310','1',1,'Retail Sale Id 3553',21000.00,0.00,0.00,30.00,1470.00,'2023-02-21 09:41:41','',''),(3669,'1','310','1',1,'Retail Sale Id 3554',5040.00,0.00,0.00,7.00,483.00,'2023-02-21 09:42:58','',''),(3670,'1','310','1',1,'Retail Sale Id 3555',3600.00,0.00,0.00,5.00,345.00,'2023-02-21 09:56:49','',''),(3671,'1','310','1',1,'Retail Sale Id 3557',1000.80,0.00,0.00,1.39,95.91,'2023-02-21 10:09:29','',''),(3672,'1','310','1',1,'Retail Sale Id 3558',2160.00,0.00,0.00,3.00,207.00,'2023-02-21 10:11:35','',''),(3673,'1','310','1',1,'Retail Sale Id 3559',7200.00,0.00,0.00,10.00,690.00,'2023-02-21 10:12:26','',''),(3674,'1','310','1',1,'Retail Sale Id 3560',3600.00,0.00,0.00,5.00,345.00,'2023-02-21 10:14:14','',''),(3675,'1','310','1',1,'Retail Sale Id 3561',1000.80,0.00,0.00,1.39,95.91,'2023-02-21 10:15:35','',''),(3676,'1','310','1',1,'Retail Sale Id 3563',2001.60,0.00,0.00,2.78,191.82,'2023-02-21 10:17:17','',''),(3677,'1','310','1',1,'Retail Sale Id 3564',5040.00,0.00,0.00,7.00,483.00,'2023-02-21 10:20:09','',''),(3678,'1','310','1',1,'Retail Sale Id 3565',35000.00,0.00,0.00,50.00,2450.00,'2023-02-21 10:31:46','',''),(3679,'1','310','1',1,'Retail Sale Id 3566',1000.80,0.00,0.00,1.39,95.91,'2023-02-21 10:32:33','',''),(3680,'1','310','1',1,'Retail Sale Id 3567',2160.00,0.00,0.00,3.00,207.00,'2023-02-21 10:33:17','',''),(3681,'1','310','1',1,'Retail Sale Id 3568',3600.00,0.00,0.00,5.00,345.00,'2023-02-21 10:34:28','',''),(3682,'1','310','1',1,'Retail Sale Id 3569',2001.60,0.00,0.00,2.78,191.82,'2023-02-21 10:35:31','',''),(3683,'1','310','1',1,'Retail Sale Id 3570',2001.60,0.00,0.00,2.78,191.82,'2023-02-21 10:39:32','',''),(3684,'1','310','1',1,'Retail Sale Id 3571',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 10:43:21','',''),(3685,'1','310','1',1,'Retail Sale Id 3572',4320.00,0.00,0.00,6.00,414.00,'2023-02-21 10:51:15','',''),(3686,'1','310','1',1,'Retail Sale Id 3573',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 10:54:15','',''),(3687,'1','310','1',1,'Retail Sale Id 3574',1440.00,0.00,0.00,2.00,138.00,'2023-02-21 10:56:58','',''),(3688,'1','310','1',1,'Retail Sale Id 3575',3600.00,0.00,0.00,5.00,345.00,'2023-02-21 11:03:23','',''),(3689,'1','310','1',1,'Retail Sale Id 3576',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 11:05:13','',''),(3690,'1','310','1',1,'Retail Sale Id 3577',1497.60,0.00,0.00,2.08,143.52,'2023-02-21 11:06:16','',''),(3691,'1','310','1',1,'Retail Sale Id 3578',2160.00,0.00,0.00,3.00,207.00,'2023-02-21 11:13:24','',''),(3692,'1','310','1',1,'Retail Sale Id 3579',1000.80,0.00,0.00,1.39,95.91,'2023-02-21 11:14:16','',''),(3693,'1','310','1',1,'Retail Sale Id 3580',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 11:35:25','',''),(3694,'1','310','1',1,'Retail Sale Id 3581',4320.00,0.00,0.00,6.00,414.00,'2023-02-21 11:36:49','',''),(3695,'1','310','1',1,'Retail Sale Id 3582',2880.00,0.00,0.00,4.00,276.00,'2023-02-21 11:40:31','',''),(3696,'1','310','1',1,'Retail Sale Id 3584',1800.00,0.00,0.00,2.50,172.50,'2023-02-21 11:43:58','',''),(3697,'1','310','1',1,'Retail Sale Id 3585',2002.00,0.00,0.00,2.86,140.14,'2023-02-21 11:48:59','',''),(3698,'1','310','1',1,'Retail Sale Id 3586',2160.00,0.00,0.00,3.00,207.00,'2023-02-21 11:50:23','',''),(3699,'1','310','1',1,'Retail Sale Id 3587',2498.40,0.00,0.00,3.47,239.43,'2023-02-21 12:03:58','',''),(3700,'1','310','1',1,'Retail Sale Id 3588',2160.00,0.00,0.00,3.00,207.00,'2023-02-21 12:05:38','',''),(3701,'1','310','1',1,'Retail Sale Id 3589',2001.60,0.00,0.00,2.78,191.82,'2023-02-21 12:08:35','',''),(3702,'1','310','1',1,'Retail Sale Id 3590',2160.00,0.00,0.00,3.00,207.00,'2023-02-21 12:19:30','',''),(3703,'1','310','1',1,'Retail Sale Id 3591',7999.20,0.00,0.00,11.11,766.59,'2023-02-21 12:21:09','',''),(3704,'1','310','1',1,'Retail Sale Id 3592',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 12:23:09','',''),(3705,'1','310','1',1,'Retail Sale Id 3593',4003.20,0.00,0.00,5.56,383.64,'2023-02-21 12:29:01','',''),(3706,'1','310','1',1,'Retail Sale Id 3594',3600.00,0.00,0.00,5.00,345.00,'2023-02-21 12:30:41','',''),(3707,'1','310','1',1,'Retail Sale Id 3595',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 12:32:18','',''),(3708,'1','310','1',1,'Retail Sale Id 3596',70000.00,0.00,0.00,100.00,4900.00,'2023-02-21 12:35:04','',''),(3709,'1','310','1',1,'Retail Sale Id 3597',1000.80,0.00,0.00,1.39,95.91,'2023-02-21 12:36:58','',''),(3710,'1','310','1',1,'Retail Sale Id 3598',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 12:46:55','',''),(3711,'1','310','1',1,'Retail Sale Id 3599',4320.00,0.00,0.00,6.00,414.00,'2023-02-21 12:49:33','',''),(3712,'1','310','1',1,'Retail Sale Id 3600',77000.00,0.00,0.00,110.00,5390.00,'2023-02-21 12:50:49','',''),(3713,'1','310','1',1,'Retail Sale Id 3601',77000.00,0.00,0.00,110.00,5390.00,'2023-02-21 12:52:14','',''),(3714,'1','310','1',1,'Retail Sale Id 3602',4320.00,0.00,0.00,6.00,414.00,'2023-02-21 12:53:23','',''),(3715,'1','310','1',1,'Retail Sale Id 3603',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 12:54:51','',''),(3716,'1','310','1',1,'Retail Sale Id 3604',2203.20,0.00,0.00,3.06,211.14,'2023-02-21 12:56:58','',''),(3717,'1','310','1',1,'Retail Sale Id 3605',2160.00,0.00,0.00,3.00,207.00,'2023-02-21 12:57:48','',''),(3718,'1','310','1',1,'Retail Sale Id 3606',4320.00,0.00,0.00,6.00,414.00,'2023-02-21 13:00:47','',''),(3719,'1','310','1',1,'Retail Sale Id 3606',4320.00,0.00,0.00,6.00,414.00,'2023-02-21 13:00:47','',''),(3720,'1','310','1',1,'Retail Sale Id 3608',2160.00,0.00,0.00,3.00,207.00,'2023-02-21 13:05:30','',''),(3721,'1','310','1',1,'Retail Sale Id 3609',4320.00,0.00,0.00,6.00,414.00,'2023-02-21 13:27:44','',''),(3722,'1','310','1',1,'Retail Sale Id 3610',2001.60,0.00,0.00,2.78,191.82,'2023-02-21 13:28:37','',''),(3723,'1','310','1',1,'Retail Sale Id 3611',1000.80,0.00,0.00,1.39,95.91,'2023-02-21 13:40:18','',''),(3724,'1','310','1',1,'Retail Sale Id 3612',4500.00,0.00,0.00,6.25,431.25,'2023-02-21 13:58:38','',''),(3725,'1','310','1',1,'Retail Sale Id 3613',1497.60,0.00,0.00,2.08,143.52,'2023-02-21 14:06:48','',''),(3726,'1','310','1',1,'Retail Sale Id 3614',4320.00,0.00,0.00,6.00,414.00,'2023-02-21 14:07:57','',''),(3727,'1','310','1',1,'Retail Sale Id 3615',4320.00,0.00,0.00,6.00,414.00,'2023-02-21 14:10:03','',''),(3728,'1','310','1',1,'Retail Sale Id 3616',2002.00,0.00,0.00,2.86,140.14,'2023-02-21 14:16:55','',''),(3729,'1','310','1',1,'Retail Sale Id 3617',720.00,0.00,0.00,1.00,69.00,'2023-02-21 14:18:36','',''),(3730,'1','310','1',1,'Retail Sale Id 3618',4320.00,0.00,0.00,6.00,414.00,'2023-02-21 14:35:33','',''),(3731,'1','310','1',1,'Retail Sale Id 3619',3002.40,0.00,0.00,4.17,287.73,'2023-02-21 14:45:37','',''),(3732,'1','310','1',1,'Retail Sale Id 3620',4320.00,0.00,0.00,6.00,414.00,'2023-02-21 14:52:07','',''),(3733,'1','310','1',1,'Retail Sale Id 3621',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 14:57:55','',''),(3734,'1','310','1',1,'Retail Sale Id 3622',8640.00,0.00,0.00,12.00,828.00,'2023-02-21 14:59:05','',''),(3735,'1','310','1',1,'Retail Sale Id 3623',2160.00,0.00,0.00,3.00,207.00,'2023-02-21 15:00:08','',''),(3736,'1','310','1',1,'Retail Sale Id 3624',2001.60,0.00,0.00,2.78,191.82,'2023-02-21 15:12:41','',''),(3737,'1','310','1',1,'Retail Sale Id 3625',2160.00,0.00,0.00,3.00,207.00,'2023-02-21 15:19:11','',''),(3738,'1','310','1',1,'Retail Sale Id 3626',3500.00,0.00,0.00,5.00,245.00,'2023-02-21 15:24:01','',''),(3739,'1','310','1',1,'Retail Sale Id 3628',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 15:27:07','',''),(3740,'1','310','1',1,'Retail Sale Id 3628',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 15:27:07','',''),(3741,'1','310','1',1,'Retail Sale Id 3629',3002.40,0.00,0.00,4.17,287.73,'2023-02-21 15:28:07','',''),(3742,'1','310','1',1,'Retail Sale Id 3630',3801.60,0.00,0.00,5.28,364.32,'2023-02-21 15:28:53','',''),(3743,'1','310','1',1,'Retail Sale Id 3631',35000.00,0.00,0.00,50.00,2450.00,'2023-02-21 15:30:53','',''),(3744,'1','310','1',1,'Retail Sale Id 3632',5760.00,0.00,0.00,8.00,552.00,'2023-02-21 15:33:47','',''),(3745,'1','310','1',1,'Retail Sale Id 3633',42000.00,0.00,0.00,60.00,2940.00,'2023-02-21 15:36:32','',''),(3746,'1','310','1',1,'Retail Sale Id 3634',3600.00,0.00,0.00,5.00,345.00,'2023-02-21 15:37:44','',''),(3747,'1','310','1',1,'Retail Sale Id 3635',45500.00,0.00,0.00,65.00,3185.00,'2023-02-21 15:47:13','',''),(3748,'1','310','1',1,'Retail Sale Id 3636',4320.00,0.00,0.00,6.00,414.00,'2023-02-21 15:51:18','',''),(3749,'1','310','1',1,'Retail Sale Id 3636',4320.00,0.00,0.00,6.00,414.00,'2023-02-21 15:51:18','',''),(3750,'1','310','1',1,'Retail Sale Id 3637',7999.20,0.00,0.00,11.11,766.59,'2023-02-21 16:00:34','',''),(3751,'1','310','1',1,'Retail Sale Id 3638',2880.00,0.00,0.00,4.00,276.00,'2023-02-21 16:16:27','',''),(3752,'1','310','1',1,'Retail Sale Id 3639',2498.40,0.00,0.00,3.47,239.43,'2023-02-21 16:17:17','',''),(3753,'1','310','1',1,'Retail Sale Id 3640',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 16:19:35','',''),(3754,'1','310','1',1,'Retail Sale Id 3641',4320.00,0.00,0.00,6.00,414.00,'2023-02-21 16:21:41','',''),(3755,'1','310','1',1,'Retail Sale Id 3642',1000.80,0.00,0.00,1.39,95.91,'2023-02-21 16:27:42','',''),(3756,'1','310','1',1,'Retail Sale Id 3643',4320.00,0.00,0.00,6.00,414.00,'2023-02-21 16:29:04','',''),(3757,'1','310','1',1,'Retail Sale Id 3644',2001.60,0.00,0.00,2.78,191.82,'2023-02-21 16:31:32','',''),(3758,'1','310','1',1,'Retail Sale Id 3645',3002.40,0.00,0.00,4.17,287.73,'2023-02-21 16:38:52','',''),(3759,'1','310','1',1,'Retail Sale Id 3646',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 16:40:38','',''),(3760,'1','310','1',1,'Retail Sale Id 3647',2001.60,0.00,0.00,2.78,191.82,'2023-02-21 16:43:19','',''),(3761,'1','310','1',1,'Retail Sale Id 3648',4320.00,0.00,0.00,6.00,414.00,'2023-02-21 16:45:13','',''),(3762,'1','310','1',1,'Retail Sale Id 3649',1000.80,0.00,0.00,1.39,95.91,'2023-02-21 16:46:40','',''),(3763,'1','310','1',1,'Retail Sale Id 3650',4003.20,0.00,0.00,5.56,383.64,'2023-02-21 16:48:16','',''),(3764,'1','310','1',1,'Retail Sale Id 3651',3600.00,0.00,0.00,5.00,345.00,'2023-02-21 16:51:58','',''),(3765,'1','310','1',1,'Retail Sale Id 3651',7200.00,0.00,0.00,10.00,690.00,'2023-02-21 16:51:58','',''),(3766,'1','310','1',1,'Retail Sale Id 3652',1000.80,0.00,0.00,1.39,95.91,'2023-02-21 16:59:11','',''),(3767,'1','310','1',1,'Retail Sale Id 3653',900.00,0.00,0.00,1.25,86.25,'2023-02-21 17:07:59','',''),(3768,'1','310','1',1,'Retail Sale Id 3654',4003.20,0.00,0.00,5.56,383.64,'2023-02-21 17:13:05','',''),(3769,'1','310','1',1,'Retail Sale Id 3655',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 17:17:21','',''),(3770,'1','310','1',1,'Retail Sale Id 3656',4996.80,0.00,0.00,6.94,478.86,'2023-02-21 17:21:27','',''),(3771,'1','310','1',1,'Retail Sale Id 3657',3002.40,0.00,0.00,4.17,287.73,'2023-02-21 17:26:10','',''),(3772,'1','310','1',1,'Retail Sale Id 3658',2001.60,0.00,0.00,2.78,191.82,'2023-02-21 17:32:17','',''),(3773,'1','310','1',1,'Retail Sale Id 3659',4320.00,0.00,0.00,6.00,414.00,'2023-02-21 17:36:01','',''),(3774,'1','310','1',1,'Retail Sale Id 3660',1497.60,0.00,0.00,2.08,143.52,'2023-02-21 17:37:35','',''),(3775,'1','310','1',1,'Retail Sale Id 3661',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 17:39:33','',''),(3776,'1','310','1',1,'Retail Sale Id 3662',3600.00,0.00,0.00,5.00,345.00,'2023-02-21 17:40:30','',''),(3777,'1','310','1',1,'Retail Sale Id 3663',1497.60,0.00,0.00,2.08,143.52,'2023-02-21 17:41:27','',''),(3778,'1','310','1',1,'Retail Sale Id 3664',7300.80,0.00,0.00,10.14,699.66,'2023-02-21 17:43:37','',''),(3779,'1','310','1',1,'Retail Sale Id 3665',2160.00,0.00,0.00,3.00,207.00,'2023-02-21 17:52:12','',''),(3780,'1','310','1',1,'Retail Sale Id 3666',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 17:55:56','',''),(3781,'1','310','1',1,'Retail Sale Id 3667',1440.00,0.00,0.00,2.00,138.00,'2023-02-21 17:57:59','',''),(3782,'1','310','1',1,'Retail Sale Id 3667',2160.00,0.00,0.00,3.00,207.00,'2023-02-21 17:57:59','',''),(3783,'1','310','1',1,'Retail Sale Id 3668',4996.80,0.00,0.00,6.94,478.86,'2023-02-21 18:06:39','',''),(3784,'1','310','1',1,'Retail Sale Id 3669',1000.80,0.00,0.00,1.39,95.91,'2023-02-21 18:10:08','',''),(3785,'1','310','1',1,'Retail Sale Id 3670',2160.00,0.00,0.00,3.00,207.00,'2023-02-21 18:11:03','',''),(3786,'1','310','1',1,'Retail Sale Id 3671',1497.60,0.00,0.00,2.08,143.52,'2023-02-21 18:12:07','',''),(3787,'1','310','1',1,'Retail Sale Id 3672',2160.00,0.00,0.00,3.00,207.00,'2023-02-21 18:18:46','',''),(3788,'1','310','1',1,'Retail Sale Id 3673',4998.00,0.00,0.00,7.14,349.86,'2023-02-21 18:19:47','',''),(3789,'1','310','1',1,'Retail Sale Id 3674',1497.60,0.00,0.00,2.08,143.52,'2023-02-21 18:20:32','',''),(3790,'1','310','1',1,'Retail Sale Id 3675',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 18:21:16','',''),(3791,'1','310','1',1,'Retail Sale Id 3676',799.20,0.00,0.00,1.11,76.59,'2023-02-21 18:22:10','',''),(3792,'1','310','1',1,'Retail Sale Id 3677',748.80,0.00,0.00,1.04,71.76,'2023-02-21 18:26:14','',''),(3793,'1','310','1',1,'Retail Sale Id 3678',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 18:28:58','',''),(3794,'1','310','1',1,'Retail Sale Id 3679',9002.00,0.00,0.00,12.86,630.14,'2023-02-21 18:32:38','',''),(3795,'1','310','1',1,'Retail Sale Id 3680',799.20,0.00,0.00,1.11,76.59,'2023-02-21 18:33:51','',''),(3796,'1','310','1',1,'Retail Sale Id 3681',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 18:35:35','',''),(3797,'1','310','1',1,'Retail Sale Id 3681',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 18:35:35','',''),(3798,'1','310','1',1,'Retail Sale Id 3682',720.00,0.00,0.00,1.00,69.00,'2023-02-21 18:37:09','',''),(3799,'1','310','1',1,'Retail Sale Id 3683',2001.60,0.00,0.00,2.78,191.82,'2023-02-21 18:39:28','',''),(3800,'1','310','1',1,'Retail Sale Id 3684',9000.00,0.00,0.00,12.50,862.50,'2023-02-21 18:57:32','',''),(3801,'1','310','1',1,'Retail Sale Id 3685',2520.00,0.00,0.00,3.50,241.50,'2023-02-21 19:14:36','',''),(3802,'1','310','1',1,'Retail Sale Id 3686',20743.20,0.00,0.00,28.81,1987.89,'2023-02-21 20:05:53','',''),(3803,'1','310','1',1,'Return of Retail Sale Id 3633',0.00,42000.00,60.00,0.00,-2940.00,'2023-02-21 20:07:16','',''),(3804,'1','310','1',1,'Retail Sale Id 3687',6790.00,0.00,0.00,9.70,475.30,'2023-02-21 20:08:36','',''),(3805,'1','310','1',1,'Retail Sale Id 3688',3002.40,0.00,0.00,4.17,287.73,'2023-02-22 07:43:00','',''),(3806,'1','310','1',1,'Retail Sale Id 3689',3600.00,0.00,0.00,5.00,345.00,'2023-02-22 08:24:41','',''),(3807,'1','310','1',1,'Retail Sale Id 3690',4320.00,0.00,0.00,6.00,414.00,'2023-02-22 08:28:33','',''),(3808,'1','310','1',1,'Retail Sale Id 3691',269500.00,0.00,0.00,385.00,18865.00,'2023-02-22 08:31:31','',''),(3809,'1','310','1',1,'Retail Sale Id 3692',3600.00,0.00,0.00,5.00,345.00,'2023-02-22 08:33:00','',''),(3810,'1','310','1',1,'Retail Sale Id 3693',3997.00,0.00,0.00,5.71,279.79,'2023-02-22 08:34:56','',''),(3811,'1','310','1',1,'Retail Sale Id 3694',2160.00,0.00,0.00,3.00,207.00,'2023-02-22 08:38:29','',''),(3812,'1','310','1',1,'Retail Sale Id 3695',4996.80,0.00,0.00,6.94,478.86,'2023-02-22 08:40:00','',''),(3813,'1','310','1',1,'Retail Sale Id 3697',3600.00,0.00,0.00,5.00,345.00,'2023-02-22 08:48:35','',''),(3814,'1','310','1',1,'Retail Sale Id 3698',2498.40,0.00,0.00,3.47,239.43,'2023-02-22 08:49:41','',''),(3815,'1','310','1',1,'Retail Sale Id 3698',3600.00,0.00,0.00,5.00,345.00,'2023-02-22 08:49:41','',''),(3816,'1','310','1',1,'Retail Sale Id 3699',4003.20,0.00,0.00,5.56,383.64,'2023-02-22 08:51:39','',''),(3817,'1','310','1',1,'Retail Sale Id 3700',1440.00,0.00,0.00,2.00,138.00,'2023-02-22 08:54:01','',''),(3818,'1','310','1',1,'Retail Sale Id 3701',3600.00,0.00,0.00,5.00,345.00,'2023-02-22 08:55:51','',''),(3819,'1','310','1',1,'Return of Retail Sale Id 3698',0.00,2498.40,3.47,0.00,-239.43,'2023-02-22 08:56:41','',''),(3820,'1','310','1',1,'Return of Retail Sale Id 3698',0.00,3600.00,5.00,0.00,-345.00,'2023-02-22 08:56:41','',''),(3821,'1','310','1',1,'Retail Sale Id 3702',1202.40,0.00,0.00,1.67,115.23,'2023-02-22 09:02:49','',''),(3822,'1','310','1',1,'Retail Sale Id 3703',2001.60,0.00,0.00,2.78,191.82,'2023-02-22 09:05:31','',''),(3823,'1','310','1',1,'Retail Sale Id 3704',4320.00,0.00,0.00,6.00,414.00,'2023-02-22 09:10:36','',''),(3824,'1','310','1',1,'Retail Sale Id 3705',4320.00,0.00,0.00,6.00,414.00,'2023-02-22 09:24:23','',''),(3825,'1','310','1',1,'Retail Sale Id 3706',1000.80,0.00,0.00,1.39,95.91,'2023-02-22 09:43:51','',''),(3826,'1','310','1',1,'Retail Sale Id 3707',9000.00,0.00,0.00,12.50,862.50,'2023-02-22 10:00:00','',''),(3827,'1','310','1',1,'Retail Sale Id 3708',9000.00,0.00,0.00,12.50,862.50,'2023-02-22 10:01:29','',''),(3828,'1','310','1',1,'Retail Sale Id 3709',4500.00,0.00,0.00,6.25,431.25,'2023-02-22 10:07:05','',''),(3829,'1','310','1',1,'Retail Sale Id 3710',7200.00,0.00,0.00,10.00,690.00,'2023-02-22 10:10:43','',''),(3830,'1','310','1',1,'Return of Retail Sale Id 3709',0.00,4500.00,6.25,0.00,-431.25,'2023-02-22 10:16:18','',''),(3831,'1','310','1',1,'Retail Sale Id 3712',2203.20,0.00,0.00,3.06,211.14,'2023-02-22 10:26:17','',''),(3832,'1','310','1',1,'Retail Sale Id 3714',20001.60,0.00,0.00,27.78,1916.82,'2023-02-22 10:40:42','',''),(3833,'1','310','1',1,'Retail Sale Id 3715',3499.20,0.00,0.00,4.86,335.34,'2023-02-22 10:50:22','',''),(3834,'1','310','1',1,'Retail Sale Id 3716',7200.00,0.00,0.00,10.00,690.00,'2023-02-22 10:53:21','',''),(3835,'1','310','1',1,'Retail Sale Id 3717',9000.00,0.00,0.00,12.50,862.50,'2023-02-22 10:56:57','',''),(3836,'1','310','1',1,'Retail Sale Id 3719',9000.00,0.00,0.00,12.50,862.50,'2023-02-22 10:59:58','',''),(3837,'1','310','1',1,'Retail Sale Id 3720',9000.00,0.00,0.00,12.50,862.50,'2023-02-22 11:01:49','',''),(3838,'1','310','1',1,'Retail Sale Id 3720',9000.00,0.00,0.00,12.50,862.50,'2023-02-22 11:01:49','',''),(3839,'1','310','1',1,'Retail Sale Id 3721',70000.00,0.00,0.00,100.00,4900.00,'2023-02-22 11:06:58','',''),(3840,'1','310','1',1,'Retail Sale Id 3722',4320.00,0.00,0.00,6.00,414.00,'2023-02-22 11:07:55','',''),(3841,'1','310','1',1,'Retail Sale Id 3723',9000.00,0.00,0.00,12.50,862.50,'2023-02-22 11:14:11','',''),(3842,'1','310','1',1,'Retail Sale Id 3724',1000.80,0.00,0.00,1.39,95.91,'2023-02-22 11:15:06','',''),(3843,'1','310','1',1,'Retail Sale Id 3725',315000.00,0.00,0.00,450.00,22050.00,'2023-02-22 11:22:16','',''),(3844,'1','310','1',1,'Retail Sale Id 3726',9000.00,0.00,0.00,12.50,862.50,'2023-02-22 11:42:13','',''),(3845,'1','310','1',1,'Retail Sale Id 3727',2498.40,0.00,0.00,3.47,239.43,'2023-02-22 11:43:37','',''),(3846,'1','310','1',1,'Retail Sale Id 3728',4320.00,0.00,0.00,6.00,414.00,'2023-02-22 11:44:52','',''),(3847,'1','310','1',1,'Retail Sale Id 3729',3600.00,0.00,0.00,5.00,345.00,'2023-02-22 11:48:16','',''),(3848,'1','310','1',1,'Retail Sale Id 3730',9000.00,0.00,0.00,12.50,862.50,'2023-02-22 11:51:23','',''),(3849,'1','310','1',1,'Retail Sale Id 3731',4320.00,0.00,0.00,6.00,414.00,'2023-02-22 11:52:02','',''),(3850,'1','310','1',1,'Return of Retail Sale Id 3730',0.00,9000.00,12.50,0.00,-862.50,'2023-02-22 11:54:07','',''),(3851,'1','310','1',1,'Retail Sale Id 3732',5040.00,0.00,0.00,7.00,483.00,'2023-02-22 11:55:36','',''),(3852,'1','310','1',1,'Retail Sale Id 3733',4320.00,0.00,0.00,6.00,414.00,'2023-02-22 11:57:59','',''),(3853,'1','310','1',1,'Retail Sale Id 3733',4320.00,0.00,0.00,6.00,414.00,'2023-02-22 11:58:00','',''),(3854,'1','310','1',1,'Retail Sale Id 3733',9000.00,0.00,0.00,12.50,862.50,'2023-02-22 11:58:00','',''),(3855,'1','310','1',1,'Retail Sale Id 3734',7200.00,0.00,0.00,10.00,690.00,'2023-02-22 12:03:49','',''),(3856,'1','310','1',1,'Retail Sale Id 3735',2203.20,0.00,0.00,3.06,211.14,'2023-02-22 12:08:29','',''),(3857,'1','310','1',1,'Retail Sale Id 3737',9000.00,0.00,0.00,12.50,862.50,'2023-02-22 12:19:54','',''),(3858,'1','310','1',1,'Retail Sale Id 3738',2203.20,0.00,0.00,3.06,211.14,'2023-02-22 12:25:47','',''),(3859,'1','310','1',1,'Retail Sale Id 3739',4320.00,0.00,0.00,6.00,414.00,'2023-02-22 12:32:24','',''),(3860,'1','310','1',1,'Retail Sale Id 3739',9000.00,0.00,0.00,12.50,862.50,'2023-02-22 12:32:24','',''),(3861,'1','310','1',1,'Retail Sale Id 3740',1000.80,0.00,0.00,1.39,95.91,'2023-02-22 12:59:09','',''),(3862,'1','310','1',1,'Retail Sale Id 3741',4320.00,0.00,0.00,6.00,414.00,'2023-02-22 13:05:00','',''),(3863,'1','310','1',1,'Retail Sale Id 3742',2160.00,0.00,0.00,3.00,207.00,'2023-02-22 13:06:08','',''),(3864,'1','310','1',1,'Retail Sale Id 3743',3600.00,0.00,0.00,5.00,345.00,'2023-02-22 13:07:22','',''),(3865,'1','310','1',1,'Retail Sale Id 3744',4320.00,0.00,0.00,6.00,414.00,'2023-02-22 13:08:48','',''),(3866,'1','310','1',1,'Retail Sale Id 3745',2160.00,0.00,0.00,3.00,207.00,'2023-02-22 13:11:27','',''),(3867,'1','310','1',1,'Retail Sale Id 3746',4320.00,0.00,0.00,6.00,414.00,'2023-02-22 13:12:54','',''),(3868,'1','310','1',1,'Retail Sale Id 3747',1000.80,0.00,0.00,1.39,95.91,'2023-02-22 13:13:48','',''),(3869,'1','310','1',1,'Retail Sale Id 3748',3600.00,0.00,0.00,5.00,345.00,'2023-02-22 13:19:03','',''),(3870,'1','310','1',1,'Retail Sale Id 3749',10800.00,0.00,0.00,15.00,1035.00,'2023-02-22 13:20:57','',''),(3871,'1','310','1',1,'Retail Sale Id 3750',3002.40,0.00,0.00,4.17,287.73,'2023-02-22 13:41:36','',''),(3872,'1','310','1',1,'Retail Sale Id 3752',9000.00,0.00,0.00,12.50,862.50,'2023-02-22 14:01:08','',''),(3873,'1','310','1',1,'Retail Sale Id 3754',748.80,0.00,0.00,1.04,71.76,'2023-02-22 14:15:34','',''),(3874,'1','310','1',1,'Retail Sale Id 3755',3002.40,0.00,0.00,4.17,287.73,'2023-02-22 14:18:02','',''),(3875,'1','310','1',1,'Retail Sale Id 3756',2160.00,0.00,0.00,3.00,207.00,'2023-02-22 14:36:50','',''),(3876,'1','310','1',1,'Retail Sale Id 3757',3500.00,0.00,0.00,5.00,245.00,'2023-02-22 14:44:07','',''),(3877,'1','310','1',1,'Retail Sale Id 3758',3002.40,0.00,0.00,4.17,287.73,'2023-02-22 14:49:30','',''),(3878,'1','310','1',1,'Retail Sale Id 3759',1000.80,0.00,0.00,1.39,95.91,'2023-02-22 14:55:14','',''),(3879,'1','310','1',1,'Retail Sale Id 3760',8750.00,0.00,0.00,12.50,612.50,'2023-02-22 15:13:40','',''),(3880,'1','310','1',1,'Retail Sale Id 3761',748.80,0.00,0.00,1.04,71.76,'2023-02-22 15:53:16','',''),(3881,'1','310','1',1,'Retail Sale Id 3762',4320.00,0.00,0.00,6.00,414.00,'2023-02-22 16:02:55','',''),(3882,'1','310','1',1,'Retail Sale Id 3763',9000.00,0.00,0.00,12.50,862.50,'2023-02-22 16:04:58','',''),(3883,'1','310','1',1,'Retail Sale Id 3764',9000.00,0.00,0.00,12.50,862.50,'2023-02-22 16:15:37','',''),(3884,'1','310','1',1,'Retail Sale Id 3765',9000.00,0.00,0.00,12.50,862.50,'2023-02-22 16:16:50','',''),(3885,'1','310','1',1,'Retail Sale Id 3766',1800.00,0.00,0.00,2.50,172.50,'2023-02-22 16:20:52','',''),(3886,'1','310','1',1,'Retail Sale Id 3767',35000.00,0.00,0.00,50.00,2450.00,'2023-02-22 16:22:22','',''),(3887,'1','310','1',1,'Retail Sale Id 3768',2160.00,0.00,0.00,3.00,207.00,'2023-02-22 16:25:58','',''),(3888,'1','310','1',1,'Retail Sale Id 3769',1000.80,0.00,0.00,1.39,95.91,'2023-02-22 16:28:13','',''),(3889,'1','310','1',1,'Retail Sale Id 3769',4996.80,0.00,0.00,6.94,478.86,'2023-02-22 16:28:13','',''),(3890,'1','310','1',1,'Retail Sale Id 3770',4320.00,0.00,0.00,6.00,414.00,'2023-02-22 16:34:42','',''),(3891,'1','310','1',1,'Retail Sale Id 3771',1000.80,0.00,0.00,1.39,95.91,'2023-02-22 16:43:52','',''),(3892,'1','310','1',1,'Retail Sale Id 3772',2160.00,0.00,0.00,3.00,207.00,'2023-02-22 16:48:39','',''),(3893,'1','310','1',1,'Retail Sale Id 3773',9000.00,0.00,0.00,12.50,862.50,'2023-02-22 16:49:16','',''),(3894,'1','310','1',1,'Retail Sale Id 3774',1900.80,0.00,0.00,2.64,182.16,'2023-02-22 17:03:41','',''),(3895,'1','310','1',1,'Retail Sale Id 3776',1000.80,0.00,0.00,1.39,95.91,'2023-02-22 17:08:40','',''),(3896,'1','310','1',1,'Retail Sale Id 3777',30002.00,0.00,0.00,42.86,2100.14,'2023-02-22 17:09:48','',''),(3897,'1','310','1',1,'Retail Sale Id 3778',1000.80,0.00,0.00,1.39,95.91,'2023-02-22 17:13:30','',''),(3898,'1','310','1',1,'Retail Sale Id 3779',2001.60,0.00,0.00,2.78,191.82,'2023-02-22 17:26:37','',''),(3899,'1','310','1',1,'Retail Sale Id 3780',799.20,0.00,0.00,1.11,76.59,'2023-02-22 17:28:53','',''),(3900,'1','310','1',1,'Retail Sale Id 3781',2001.60,0.00,0.00,2.78,191.82,'2023-02-22 17:34:23','',''),(3901,'1','310','1',1,'Retail Sale Id 3782',3600.00,0.00,0.00,5.00,345.00,'2023-02-22 17:35:19','',''),(3902,'1','310','1',1,'Retail Sale Id 3783',1497.60,0.00,0.00,2.08,143.52,'2023-02-22 17:37:30','',''),(3903,'1','310','1',1,'Retail Sale Id 3784',1000.80,0.00,0.00,1.39,95.91,'2023-02-22 17:39:30','',''),(3904,'1','310','1',1,'Retail Sale Id 3785',5040.00,0.00,0.00,7.00,483.00,'2023-02-22 17:45:04','',''),(3905,'1','310','1',1,'Retail Sale Id 3786',3002.40,0.00,0.00,4.17,287.73,'2023-02-22 17:50:42','',''),(3906,'1','310','1',1,'Retail Sale Id 3787',1000.80,0.00,0.00,1.39,95.91,'2023-02-22 17:51:49','',''),(3907,'1','310','1',1,'Retail Sale Id 3788',10000.80,0.00,0.00,13.89,958.41,'2023-02-22 17:54:50','',''),(3908,'1','310','1',1,'Retail Sale Id 3789',2160.00,0.00,0.00,3.00,207.00,'2023-02-22 17:56:29','',''),(3909,'1','310','1',1,'Retail Sale Id 3790',9000.00,0.00,0.00,12.50,862.50,'2023-02-22 17:57:14','',''),(3910,'1','310','1',1,'Retail Sale Id 3791',9000.00,0.00,0.00,12.50,862.50,'2023-02-22 17:58:20','',''),(3911,'1','310','1',1,'Retail Sale Id 3792',2001.60,0.00,0.00,2.78,191.82,'2023-02-22 18:10:37','',''),(3912,'1','310','1',1,'Retail Sale Id 3793',1000.80,0.00,0.00,1.39,95.91,'2023-02-22 18:14:18','',''),(3913,'1','310','1',1,'Retail Sale Id 3794',3600.00,0.00,0.00,5.00,345.00,'2023-02-22 18:16:11','',''),(3914,'1','310','1',1,'Retail Sale Id 3795',2001.60,0.00,0.00,2.78,191.82,'2023-02-22 18:17:06','',''),(3915,'1','310','1',1,'Retail Sale Id 3796',2160.00,0.00,0.00,3.00,207.00,'2023-02-22 18:18:06','',''),(3916,'1','310','1',1,'Retail Sale Id 3798',2001.60,0.00,0.00,2.78,191.82,'2023-02-22 18:19:21','',''),(3917,'1','310','1',1,'Retail Sale Id 3799',9000.00,0.00,0.00,12.50,862.50,'2023-02-22 18:20:19','',''),(3918,'1','310','1',1,'Retail Sale Id 3800',3002.40,0.00,0.00,4.17,287.73,'2023-02-22 18:21:21','',''),(3919,'1','310','1',1,'Retail Sale Id 3801',3002.40,0.00,0.00,4.17,287.73,'2023-02-22 18:22:32','',''),(3920,'1','310','1',1,'Retail Sale Id 3802',6480.00,0.00,0.00,9.00,621.00,'2023-02-22 18:23:48','',''),(3921,'1','310','1',1,'Retail Sale Id 3803',2160.00,0.00,0.00,3.00,207.00,'2023-02-22 18:24:57','',''),(3922,'1','310','1',1,'Retail Sale Id 3804',9201.60,0.00,0.00,12.78,881.82,'2023-02-22 18:26:09','',''),(3923,'1','310','1',1,'Retail Sale Id 3805',1000.80,0.00,0.00,1.39,95.91,'2023-02-22 18:26:55','',''),(3924,'1','310','1',1,'Retail Sale Id 3806',2498.40,0.00,0.00,3.47,239.43,'2023-02-22 18:27:45','',''),(3925,'1','310','1',1,'Retail Sale Id 3807',4003.20,0.00,0.00,5.56,383.64,'2023-02-22 18:28:34','',''),(3926,'1','310','1',1,'Retail Sale Id 3808',4320.00,0.00,0.00,6.00,414.00,'2023-02-22 18:30:04','',''),(3927,'1','310','1',1,'Retail Sale Id 3809',1497.60,0.00,0.00,2.08,143.52,'2023-02-22 18:31:27','',''),(3928,'1','310','1',1,'Retail Sale Id 3810',1000.80,0.00,0.00,1.39,95.91,'2023-02-22 18:33:59','',''),(3929,'1','310','1',1,'Retail Sale Id 3811',2160.00,0.00,0.00,3.00,207.00,'2023-02-22 18:37:59','',''),(3930,'1','310','1',1,'Retail Sale Id 3812',496.80,0.00,0.00,0.69,47.61,'2023-02-22 18:41:32','',''),(3931,'1','310','1',1,'Retail Sale Id 3813',1497.60,0.00,0.00,2.08,143.52,'2023-02-22 18:45:53','',''),(3932,'1','310','1',1,'Retail Sale Id 3814',4003.20,0.00,0.00,5.56,383.64,'2023-02-22 18:59:51','',''),(3933,'1','310','1',1,'Retail Sale Id 3815',345.60,0.00,0.00,0.48,33.12,'2023-02-22 19:08:50','',''),(3934,'1','310','1',1,'Retail Sale Id 3816',35000.00,0.00,0.00,50.00,2450.00,'2023-02-22 19:09:52','',''),(3935,'1','310','1',1,'Return of Retail Sale Id 3814',0.00,4003.20,5.56,0.00,-383.64,'2023-02-22 19:12:09','',''),(3936,'1','310','1',1,'Retail Sale Id 3817',42000.00,0.00,0.00,60.00,2940.00,'2023-02-23 07:22:10','',''),(3937,'1','310','1',1,'Retail Sale Id 3818',8892.00,0.00,0.00,12.35,852.15,'2023-02-23 07:39:24','',''),(3938,'1','310','1',1,'Retail Sale Id 3819',4320.00,0.00,0.00,6.00,414.00,'2023-02-23 08:07:50','',''),(3939,'1','310','1',1,'Retail Sale Id 3820',1440.00,0.00,0.00,2.00,138.00,'2023-02-23 08:09:18','',''),(3940,'1','310','1',1,'Retail Sale Id 3821',2160.00,0.00,0.00,3.00,207.00,'2023-02-23 08:10:02','',''),(3941,'1','310','1',1,'Retail Sale Id 3822',2498.40,0.00,0.00,3.47,239.43,'2023-02-23 08:14:27','',''),(3942,'1','310','1',1,'Retail Sale Id 3823',2001.60,0.00,0.00,2.78,191.82,'2023-02-23 08:17:27','',''),(3943,'1','310','1',1,'Retail Sale Id 3824',4003.20,0.00,0.00,5.56,383.64,'2023-02-23 08:20:36','',''),(3944,'1','310','1',1,'Retail Sale Id 3825',4320.00,0.00,0.00,6.00,414.00,'2023-02-23 08:22:46','',''),(3945,'1','310','1',1,'Retail Sale Id 3827',4200.00,0.00,0.00,6.00,294.00,'2023-02-23 08:24:16','',''),(3946,'1','310','1',1,'Retail Sale Id 3828',2160.00,0.00,0.00,3.00,207.00,'2023-02-23 08:26:08','',''),(3947,'1','310','1',1,'Retail Sale Id 3829',4320.00,0.00,0.00,6.00,414.00,'2023-02-23 08:27:37','',''),(3948,'1','310','1',1,'Retail Sale Id 3830',2001.60,0.00,0.00,2.78,191.82,'2023-02-23 08:29:44','',''),(3949,'1','310','1',1,'Retail Sale Id 3831',2160.00,0.00,0.00,3.00,207.00,'2023-02-23 08:33:06','',''),(3950,'1','310','1',1,'Retail Sale Id 3832',78400.00,0.00,0.00,112.00,5488.00,'2023-02-23 08:35:02','',''),(3951,'1','310','1',1,'Retail Sale Id 3833',2001.60,0.00,0.00,2.78,191.82,'2023-02-23 08:37:21','',''),(3952,'1','310','1',1,'Retail Sale Id 3833',2001.60,0.00,0.00,2.78,191.82,'2023-02-23 08:37:21','',''),(3953,'1','310','1',1,'Retail Sale Id 3834',2001.60,0.00,0.00,2.78,191.82,'2023-02-23 08:38:58','',''),(3954,'1','310','1',1,'Retail Sale Id 3835',9000.00,0.00,0.00,12.50,862.50,'2023-02-23 08:48:09','',''),(3955,'1','310','1',1,'Retail Sale Id 3836',9000.00,0.00,0.00,12.50,862.50,'2023-02-23 08:48:54','',''),(3956,'1','310','1',1,'Retail Sale Id 3837',2160.00,0.00,0.00,3.00,207.00,'2023-02-23 08:59:15','',''),(3957,'1','310','1',1,'Retail Sale Id 3838',2001.60,0.00,0.00,2.78,191.82,'2023-02-23 09:01:01','',''),(3958,'1','310','1',1,'Retail Sale Id 3839',7000.00,0.00,0.00,10.00,490.00,'2023-02-23 09:10:42','',''),(3959,'1','310','1',1,'Retail Sale Id 3840',2397.60,0.00,0.00,3.33,229.77,'2023-02-23 09:15:33','',''),(3960,'1','310','1',1,'Retail Sale Id 3841',9000.00,0.00,0.00,12.50,862.50,'2023-02-23 09:18:19','',''),(3961,'1','310','1',1,'Retail Sale Id 3841',9000.00,0.00,0.00,12.50,862.50,'2023-02-23 09:18:19','',''),(3962,'1','310','1',1,'Retail Sale Id 3842',4320.00,0.00,0.00,6.00,414.00,'2023-02-23 09:20:57','',''),(3963,'1','310','1',1,'Retail Sale Id 3843',1497.60,0.00,0.00,2.08,143.52,'2023-02-23 09:22:44','',''),(3964,'1','310','1',1,'Retail Sale Id 3844',9000.00,0.00,0.00,12.50,862.50,'2023-02-23 09:24:24','',''),(3965,'1','310','1',1,'Retail Sale Id 3844',9000.00,0.00,0.00,12.50,862.50,'2023-02-23 09:24:24','',''),(3966,'1','310','1',1,'Retail Sale Id 3845',6998.40,0.00,0.00,9.72,670.68,'2023-02-23 09:34:13','',''),(3967,'1','310','1',1,'Retail Sale Id 3846',6480.00,0.00,0.00,9.00,621.00,'2023-02-23 09:36:06','',''),(3968,'1','310','1',1,'Retail Sale Id 3847',1000.80,0.00,0.00,1.39,95.91,'2023-02-23 09:40:04','',''),(3969,'1','310','1',1,'Retail Sale Id 3848',1000.80,0.00,0.00,1.39,95.91,'2023-02-23 09:42:35','',''),(3970,'1','310','1',1,'Retail Sale Id 3849',2001.60,0.00,0.00,2.78,191.82,'2023-02-23 09:50:26','',''),(3971,'1','310','1',1,'Retail Sale Id 3850',9000.00,0.00,0.00,12.50,862.50,'2023-02-23 09:51:29','',''),(3972,'1','310','1',1,'Retail Sale Id 3851',4996.80,0.00,0.00,6.94,478.86,'2023-02-23 09:53:04','',''),(3973,'1','310','1',1,'Retail Sale Id 3852',6998.40,0.00,0.00,9.72,670.68,'2023-02-23 09:54:23','',''),(3974,'1','310','1',1,'Retail Sale Id 3853',2160.00,0.00,0.00,3.00,207.00,'2023-02-23 09:56:00','',''),(3975,'1','310','1',1,'Retail Sale Id 3854',9000.00,0.00,0.00,12.50,862.50,'2023-02-23 09:56:44','',''),(3976,'1','310','1',1,'Retail Sale Id 3855',2160.00,0.00,0.00,3.00,207.00,'2023-02-23 09:58:20','',''),(3977,'1','310','1',1,'Retail Sale Id 3856',2160.00,0.00,0.00,3.00,207.00,'2023-02-23 10:16:19','',''),(3978,'1','310','1',1,'Retail Sale Id 3857',9000.00,0.00,0.00,12.50,862.50,'2023-02-23 10:17:55','',''),(3979,'1','310','1',1,'Retail Sale Id 3858',4320.00,0.00,0.00,6.00,414.00,'2023-02-23 10:19:09','',''),(3980,'1','310','1',1,'Retail Sale Id 3859',5760.00,0.00,0.00,8.00,552.00,'2023-02-23 10:22:27','',''),(3981,'1','310','1',1,'Retail Sale Id 3860',3600.00,0.00,0.00,5.00,345.00,'2023-02-23 10:26:28','',''),(3982,'1','310','1',1,'Retail Sale Id 3861',3600.00,0.00,0.00,5.00,345.00,'2023-02-23 10:29:30','',''),(3983,'1','310','1',1,'Retail Sale Id 3863',3002.40,0.00,0.00,4.17,287.73,'2023-02-23 10:30:50','',''),(3984,'1','310','1',1,'Retail Sale Id 3864',9000.00,0.00,0.00,12.50,862.50,'2023-02-23 10:32:16','',''),(3985,'1','310','1',1,'Retail Sale Id 3866',4320.00,0.00,0.00,6.00,414.00,'2023-02-23 11:06:39','',''),(3986,'1','310','1',1,'Retail Sale Id 3867',4399.20,0.00,0.00,6.11,421.59,'2023-02-23 11:10:44','',''),(3987,'1','310','1',1,'Retail Sale Id 3868',2160.00,0.00,0.00,3.00,207.00,'2023-02-23 11:15:38','',''),(3988,'1','310','1',1,'Retail Sale Id 3869',35000.00,0.00,0.00,50.00,2450.00,'2023-02-23 11:19:19','',''),(3989,'1','310','1',1,'Retail Sale Id 3870',4320.00,0.00,0.00,6.00,414.00,'2023-02-23 11:21:04','',''),(3990,'1','310','1',1,'Retail Sale Id 3871',799.20,0.00,0.00,1.11,76.59,'2023-02-23 11:22:27','',''),(3991,'1','310','1',1,'Retail Sale Id 3872',2160.00,0.00,0.00,3.00,207.00,'2023-02-23 11:26:40','',''),(3992,'1','310','1',1,'Retail Sale Id 3873',4320.00,0.00,0.00,6.00,414.00,'2023-02-23 11:34:38','',''),(3993,'1','310','1',1,'Retail Sale Id 3874',4320.00,0.00,0.00,6.00,414.00,'2023-02-23 11:36:44','',''),(3994,'1','310','1',1,'Retail Sale Id 3875',31500.00,0.00,0.00,45.00,2205.00,'2023-02-23 11:38:32','',''),(3995,'1','310','1',1,'Retail Sale Id 3876',2160.00,0.00,0.00,3.00,207.00,'2023-02-23 11:42:19','',''),(3996,'1','310','1',1,'Retail Sale Id 3877',2160.00,0.00,0.00,3.00,207.00,'2023-02-23 11:45:01','',''),(3997,'1','310','1',1,'Retail Sale Id 3878',3600.00,0.00,0.00,5.00,345.00,'2023-02-23 11:52:35','',''),(3998,'1','310','1',1,'Retail Sale Id 3879',4320.00,0.00,0.00,6.00,414.00,'2023-02-23 11:57:47','',''),(3999,'1','310','1',1,'Retail Sale Id 3880',1800.00,0.00,0.00,2.50,172.50,'2023-02-23 11:58:58','',''),(4000,'1','310','1',1,'Retail Sale Id 3881',7200.00,0.00,0.00,10.00,690.00,'2023-02-23 12:07:54','',''),(4001,'1','310','1',1,'Retail Sale Id 3882',4320.00,0.00,0.00,6.00,414.00,'2023-02-23 12:10:51','',''),(4002,'1','310','1',1,'Retail Sale Id 3883',1497.60,0.00,0.00,2.08,143.52,'2023-02-23 12:12:14','',''),(4003,'1','310','1',1,'Retail Sale Id 3884',4320.00,0.00,0.00,6.00,414.00,'2023-02-23 12:13:00','',''),(4004,'1','310','1',1,'Retail Sale Id 3885',4500.00,0.00,0.00,6.25,431.25,'2023-02-23 12:13:51','',''),(4005,'1','310','1',1,'Retail Sale Id 3887',19999.00,0.00,0.00,28.57,1399.93,'2023-02-23 12:19:02','',''),(4006,'1','310','1',1,'Retail Sale Id 3888',1000.80,0.00,0.00,1.39,95.91,'2023-02-23 12:20:07','',''),(4007,'1','310','1',1,'Retail Sale Id 3889',3002.40,0.00,0.00,4.17,287.73,'2023-02-23 12:21:23','',''),(4008,'1','310','1',1,'Retail Sale Id 3890',4320.00,0.00,0.00,6.00,414.00,'2023-02-23 12:22:07','',''),(4009,'1','310','1',1,'Retail Sale Id 3891',3600.00,0.00,0.00,5.00,345.00,'2023-02-23 12:24:09','',''),(4010,'1','310','1',1,'Retail Sale Id 3892',4996.80,0.00,0.00,6.94,478.86,'2023-02-23 12:28:14','',''),(4011,'1','310','1',1,'Retail Sale Id 3893',2203.20,0.00,0.00,3.06,211.14,'2023-02-23 12:36:52','',''),(4012,'1','310','1',1,'Retail Sale Id 3894',6278.40,0.00,0.00,8.72,601.68,'2023-02-23 12:39:27','',''),(4013,'1','310','1',1,'Retail Sale Id 3895',1000.80,0.00,0.00,1.39,95.91,'2023-02-23 12:50:46','',''),(4014,'1','310','1',1,'Retail Sale Id 3896',5997.60,0.00,0.00,8.33,574.77,'2023-02-23 12:53:17','',''),(4015,'1','310','1',1,'Retail Sale Id 3897',2160.00,0.00,0.00,3.00,207.00,'2023-02-23 12:55:05','',''),(4016,'1','310','1',1,'Retail Sale Id 3898',35000.00,0.00,0.00,50.00,2450.00,'2023-02-23 13:39:04','',''),(4017,'1','310','1',1,'Retail Sale Id 3899',35000.00,0.00,0.00,50.00,2450.00,'2023-02-23 13:41:28','',''),(4018,'1','310','1',1,'Retail Sale Id 3900',6480000.00,0.00,0.00,9000.00,621000.00,'2023-02-23 13:48:53','',''),(4019,'1','310','1',1,'Return of Retail Sale Id 3900',0.00,6480000.00,9000.00,0.00,-621000.00,'2023-02-23 13:53:05','',''),(4020,'1','310','1',1,'Retail Sale Id 3901',9000.00,0.00,0.00,12.50,862.50,'2023-02-23 13:54:18','',''),(4021,'1','310','1',1,'Retail Sale Id 3902',9000.00,0.00,0.00,12.50,862.50,'2023-02-23 13:55:58','',''),(4022,'1','310','1',1,'Retail Sale Id 3903',4320.00,0.00,0.00,6.00,414.00,'2023-02-23 13:58:05','',''),(4023,'1','310','1',1,'Retail Sale Id 3904',720.00,0.00,0.00,1.00,69.00,'2023-02-23 14:00:19','',''),(4024,'1','310','1',1,'Retail Sale Id 3905',9000.00,0.00,0.00,12.50,862.50,'2023-02-23 14:05:22','',''),(4025,'1','310','1',1,'Retail Sale Id 3905',9000.00,0.00,0.00,12.50,862.50,'2023-02-23 14:05:22','',''),(4026,'1','310','1',1,'Retail Sale Id 3906',9000.00,0.00,0.00,12.50,862.50,'2023-02-23 14:10:33','',''),(4027,'1','310','1',1,'Retail Sale Id 3907',3600.00,0.00,0.00,5.00,345.00,'2023-02-23 14:38:47','',''),(4028,'1','310','1',1,'Retail Sale Id 3910',9000.00,0.00,0.00,12.50,862.50,'2023-02-23 14:42:04','',''),(4029,'1','310','1',1,'Retail Sale Id 3910',9000.00,0.00,0.00,12.50,862.50,'2023-02-23 14:42:04','',''),(4030,'1','310','1',1,'Retail Sale Id 3911',3600.00,0.00,0.00,5.00,345.00,'2023-02-23 14:44:59','',''),(4031,'1','310','1',1,'Retail Sale Id 3912',4802.40,0.00,0.00,6.67,460.23,'2023-02-23 14:51:28','',''),(4032,'1','310','1',1,'Retail Sale Id 3913',9000.00,0.00,0.00,12.50,862.50,'2023-02-23 15:14:21','',''),(4033,'1','310','1',1,'Retail Sale Id 3914',47999.00,0.00,0.00,68.57,3359.93,'2023-02-23 15:30:00','',''),(4034,'1','310','1',1,'Retail Sale Id 3915',4320.00,0.00,0.00,6.00,414.00,'2023-02-23 15:32:13','',''),(4035,'1','310','1',1,'Retail Sale Id 3916',2160.00,0.00,0.00,3.00,207.00,'2023-02-23 15:32:56','',''),(4036,'1','310','1',1,'Retail Sale Id 3917',2160.00,0.00,0.00,3.00,207.00,'2023-02-23 15:34:30','',''),(4037,'1','310','1',1,'Retail Sale Id 3917',4320.00,0.00,0.00,6.00,414.00,'2023-02-23 15:34:30','',''),(4038,'1','310','1',1,'Retail Sale Id 3918',3002.40,0.00,0.00,4.17,287.73,'2023-02-23 15:42:55','',''),(4039,'1','310','1',1,'Retail Sale Id 3919',1440.00,0.00,0.00,2.00,138.00,'2023-02-23 15:48:25','',''),(4040,'1','310','1',1,'Retail Sale Id 3920',9000.00,0.00,0.00,12.50,862.50,'2023-02-23 15:51:44','',''),(4041,'1','310','1',1,'Retail Sale Id 3921',3600.00,0.00,0.00,5.00,345.00,'2023-02-23 16:14:05','',''),(4042,'1','310','1',1,'Retail Sale Id 3922',1497.60,0.00,0.00,2.08,143.52,'2023-02-23 16:19:22','',''),(4043,'1','310','1',1,'Retail Sale Id 3923',2001.60,0.00,0.00,2.78,191.82,'2023-02-23 16:23:31','',''),(4044,'1','310','1',1,'Retail Sale Id 3924',4320.00,0.00,0.00,6.00,414.00,'2023-02-23 16:34:10','',''),(4045,'1','310','1',1,'Retail Sale Id 3924',4320.00,0.00,0.00,6.00,414.00,'2023-02-23 16:34:10','',''),(4046,'1','310','1',1,'Retail Sale Id 3925',4320.00,0.00,0.00,6.00,414.00,'2023-02-23 16:35:55','',''),(4047,'1','310','1',1,'Retail Sale Id 3926',4320.00,0.00,0.00,6.00,414.00,'2023-02-23 16:46:55','',''),(4048,'1','310','1',1,'Retail Sale Id 3927',2160.00,0.00,0.00,3.00,207.00,'2023-02-23 16:48:35','',''),(4049,'1','310','1',1,'Retail Sale Id 3928',3600.00,0.00,0.00,5.00,345.00,'2023-02-23 17:06:59','',''),(4050,'1','310','1',1,'Retail Sale Id 3929',9000.00,0.00,0.00,12.50,862.50,'2023-02-23 17:08:14','',''),(4051,'1','310','1',1,'Retail Sale Id 3930',2160.00,0.00,0.00,3.00,207.00,'2023-02-23 17:09:46','',''),(4052,'1','310','1',1,'Retail Sale Id 3931',4320.00,0.00,0.00,6.00,414.00,'2023-02-23 17:19:21','',''),(4053,'1','310','1',1,'Retail Sale Id 3932',2880.00,0.00,0.00,4.00,276.00,'2023-02-23 17:21:01','',''),(4054,'1','310','1',1,'Retail Sale Id 3933',5040.00,0.00,0.00,7.00,483.00,'2023-02-23 17:22:20','',''),(4055,'1','310','1',1,'Retail Sale Id 3934',9000.00,0.00,0.00,12.50,862.50,'2023-02-23 17:23:58','',''),(4056,'1','310','1',1,'Retail Sale Id 3935',3600.00,0.00,0.00,5.00,345.00,'2023-02-23 17:25:23','',''),(4057,'1','310','1',1,'Retail Sale Id 3936',2160.00,0.00,0.00,3.00,207.00,'2023-02-23 17:44:06','',''),(4058,'1','310','1',1,'Retail Sale Id 3936',3038.40,0.00,0.00,4.22,291.18,'2023-02-23 17:44:06','',''),(4059,'1','310','1',1,'Retail Sale Id 3937',9000.00,0.00,0.00,12.50,862.50,'2023-02-23 17:45:09','',''),(4060,'1','310','1',1,'Return of Retail Sale Id 3937',0.00,9000.00,12.50,0.00,-862.50,'2023-02-23 18:07:50','',''),(4061,'1','310','1',1,'Retail Sale Id 3938',1944.00,0.00,0.00,2.70,186.30,'2023-02-23 18:09:28','',''),(4062,'1','310','1',1,'Return of Retail Sale Id 3839',0.00,7000.00,10.00,0.00,-490.00,'2023-02-23 18:12:02','',''),(4063,'1','310','1',1,'Retail Sale Id 3939',7000.00,0.00,0.00,10.00,490.00,'2023-02-23 18:13:06','',''),(4064,'1','310','1',1,'Retail Sale Id 3940',20296.80,0.00,0.00,28.19,1945.11,'2023-02-23 19:29:07','',''),(4065,'1','310','1',1,'Retail Sale Id 3942',1000.80,0.00,0.00,1.39,95.91,'2023-02-24 07:23:16','',''),(4066,'1','310','1',1,'Retail Sale Id 3948',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 07:27:08','',''),(4067,'1','310','1',1,'Retail Sale Id 3949',35000.00,0.00,0.00,50.00,2450.00,'2023-02-24 07:34:53','',''),(4068,'1','310','1',1,'Retail Sale Id 3950',1396.80,0.00,0.00,1.94,133.86,'2023-02-24 07:36:32','',''),(4069,'1','310','1',1,'Retail Sale Id 3951',2001.60,0.00,0.00,2.78,191.82,'2023-02-24 07:41:44','',''),(4070,'1','310','1',1,'Retail Sale Id 3952',2498.40,0.00,0.00,3.47,239.43,'2023-02-24 07:50:16','',''),(4071,'1','310','1',1,'Retail Sale Id 3953',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 07:53:00','',''),(4072,'1','310','1',1,'Retail Sale Id 3954',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 07:58:43','',''),(4073,'1','310','1',1,'Retail Sale Id 3955',2001.60,0.00,0.00,2.78,191.82,'2023-02-24 08:40:44','',''),(4074,'1','310','1',1,'Retail Sale Id 3955',6998.40,0.00,0.00,9.72,670.68,'2023-02-24 08:40:44','',''),(4075,'1','310','1',1,'Retail Sale Id 3956',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 08:42:20','',''),(4076,'1','310','1',1,'Retail Sale Id 3957',35000.00,0.00,0.00,50.00,2450.00,'2023-02-24 08:43:22','',''),(4077,'1','310','1',1,'Retail Sale Id 3958',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 08:44:23','',''),(4078,'1','310','1',1,'Retail Sale Id 3959',3850.00,0.00,0.00,5.50,269.50,'2023-02-24 08:46:45','',''),(4079,'1','310','1',1,'Retail Sale Id 3960',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 08:48:54','',''),(4080,'1','310','1',1,'Retail Sale Id 3960',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 08:48:54','',''),(4081,'1','310','1',1,'Retail Sale Id 3961',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 08:50:14','',''),(4082,'1','310','1',1,'Retail Sale Id 3962',4003.20,0.00,0.00,5.56,383.64,'2023-02-24 08:51:23','',''),(4083,'1','310','1',1,'Retail Sale Id 3963',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 08:54:03','',''),(4084,'1','310','1',1,'Retail Sale Id 3964',4003.20,0.00,0.00,5.56,383.64,'2023-02-24 08:58:00','',''),(4085,'1','310','1',1,'Retail Sale Id 3965',4996.80,0.00,0.00,6.94,478.86,'2023-02-24 08:58:39','',''),(4086,'1','310','1',1,'Retail Sale Id 3966',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 09:00:00','',''),(4087,'1','310','1',1,'Retail Sale Id 3967',2001.60,0.00,0.00,2.78,191.82,'2023-02-24 09:01:00','',''),(4088,'1','310','1',1,'Retail Sale Id 3968',4500.00,0.00,0.00,6.25,431.25,'2023-02-24 09:02:24','',''),(4089,'1','310','1',1,'Retail Sale Id 3969',4003.20,0.00,0.00,5.56,383.64,'2023-02-24 09:03:46','',''),(4090,'1','310','1',1,'Retail Sale Id 3970',1800.00,0.00,0.00,2.50,172.50,'2023-02-24 09:08:28','',''),(4091,'1','310','1',1,'Retail Sale Id 3971',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 09:10:33','',''),(4092,'1','310','1',1,'Retail Sale Id 3972',2203.20,0.00,0.00,3.06,211.14,'2023-02-24 09:12:36','',''),(4093,'1','310','1',1,'Retail Sale Id 3973',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 09:15:54','',''),(4094,'1','310','1',1,'Retail Sale Id 3974',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 09:18:58','',''),(4095,'1','310','1',1,'Retail Sale Id 3975',70000.00,0.00,0.00,100.00,4900.00,'2023-02-24 09:26:08','',''),(4096,'1','310','1',1,'Retail Sale Id 3977',3002.40,0.00,0.00,4.17,287.73,'2023-02-24 09:29:31','',''),(4097,'1','310','1',1,'Retail Sale Id 3977',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 09:29:31','',''),(4098,'1','310','1',1,'Retail Sale Id 3978',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 09:31:09','',''),(4099,'1','310','1',1,'Retail Sale Id 3979',1000.80,0.00,0.00,1.39,95.91,'2023-02-24 09:34:35','',''),(4100,'1','310','1',1,'Retail Sale Id 3980',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 09:38:29','',''),(4101,'1','310','1',1,'Retail Sale Id 3981',4003.20,0.00,0.00,5.56,383.64,'2023-02-24 09:40:30','',''),(4102,'1','310','1',1,'Retail Sale Id 3982',4003.20,0.00,0.00,5.56,383.64,'2023-02-24 09:42:39','',''),(4103,'1','310','1',1,'Retail Sale Id 3983',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 09:44:14','',''),(4104,'1','310','1',1,'Retail Sale Id 3984',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 09:48:36','',''),(4105,'1','310','1',1,'Retail Sale Id 3986',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 09:51:07','',''),(4106,'1','310','1',1,'Retail Sale Id 3987',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 09:52:10','',''),(4107,'1','310','1',1,'Retail Sale Id 3988',4003.20,0.00,0.00,5.56,383.64,'2023-02-24 09:53:11','',''),(4108,'1','310','1',1,'Retail Sale Id 3989',7200.00,0.00,0.00,10.00,690.00,'2023-02-24 09:54:43','',''),(4109,'1','310','1',1,'Retail Sale Id 3990',3499.20,0.00,0.00,4.86,335.34,'2023-02-24 09:55:34','',''),(4110,'1','310','1',1,'Retail Sale Id 3991',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 09:56:56','',''),(4111,'1','310','1',1,'Retail Sale Id 3992',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 09:58:19','',''),(4112,'1','310','1',1,'Retail Sale Id 3993',302.40,0.00,0.00,0.42,28.98,'2023-02-24 10:04:08','',''),(4113,'1','310','1',1,'Retail Sale Id 3994',3002.40,0.00,0.00,4.17,287.73,'2023-02-24 10:04:53','',''),(4114,'1','310','1',1,'Retail Sale Id 3995',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 10:07:09','',''),(4115,'1','310','1',1,'Retail Sale Id 3996',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 10:08:47','',''),(4116,'1','310','1',1,'Retail Sale Id 3997',2001.60,0.00,0.00,2.78,191.82,'2023-02-24 10:09:42','',''),(4117,'1','310','1',1,'Retail Sale Id 3998',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 10:11:16','',''),(4118,'1','310','1',1,'Retail Sale Id 3999',3002.40,0.00,0.00,4.17,287.73,'2023-02-24 10:13:59','',''),(4119,'1','310','1',1,'Retail Sale Id 4000',3196.80,0.00,0.00,4.44,306.36,'2023-02-24 10:14:51','',''),(4120,'1','310','1',1,'Retail Sale Id 4001',140000.00,0.00,0.00,200.00,9800.00,'2023-02-24 10:17:45','',''),(4121,'1','310','1',1,'Retail Sale Id 4002',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 10:19:07','',''),(4122,'1','310','1',1,'Retail Sale Id 4002',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 10:19:07','',''),(4123,'1','310','1',1,'Retail Sale Id 4003',1497.60,0.00,0.00,2.08,143.52,'2023-02-24 10:20:32','',''),(4124,'1','310','1',1,'Retail Sale Id 4003',3499.20,0.00,0.00,4.86,335.34,'2023-02-24 10:20:32','',''),(4125,'1','310','1',1,'Retail Sale Id 4004',4003.20,0.00,0.00,5.56,383.64,'2023-02-24 10:21:18','',''),(4126,'1','310','1',1,'Retail Sale Id 4005',3002.40,0.00,0.00,4.17,287.73,'2023-02-24 10:22:30','',''),(4127,'1','310','1',1,'Return of Retail Sale Id 3996',0.00,3600.00,5.00,0.00,-345.00,'2023-02-24 10:24:16','',''),(4128,'1','310','1',1,'Retail Sale Id 4006',1000.80,0.00,0.00,1.39,95.91,'2023-02-24 10:32:03','',''),(4129,'1','310','1',1,'Return of Retail Sale Id 4006',0.00,1000.80,1.39,0.00,-95.91,'2023-02-24 10:32:18','',''),(4130,'1','310','1',1,'Retail Sale Id 4007',1000.80,0.00,0.00,1.39,95.91,'2023-02-24 10:33:13','',''),(4131,'1','310','1',1,'Retail Sale Id 4008',1440.00,0.00,0.00,2.00,138.00,'2023-02-24 10:37:28','',''),(4132,'1','310','1',1,'Retail Sale Id 4009',70000.00,0.00,0.00,100.00,4900.00,'2023-02-24 10:39:09','',''),(4133,'1','310','1',1,'Retail Sale Id 4010',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 10:39:58','',''),(4134,'1','310','1',1,'Retail Sale Id 4011',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 10:42:54','',''),(4135,'1','310','1',1,'Retail Sale Id 4012',1000.80,0.00,0.00,1.39,95.91,'2023-02-24 10:44:24','',''),(4136,'1','310','1',1,'Retail Sale Id 4013',1000.80,0.00,0.00,1.39,95.91,'2023-02-24 10:49:34','',''),(4137,'1','310','1',1,'Retail Sale Id 4014',3002.40,0.00,0.00,4.17,287.73,'2023-02-24 10:50:34','',''),(4138,'1','310','1',1,'Retail Sale Id 4016',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 10:53:31','',''),(4139,'1','310','1',1,'Retail Sale Id 4017',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 10:55:41','',''),(4140,'1','310','1',1,'Retail Sale Id 4017',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 10:55:41','',''),(4141,'1','310','1',1,'Retail Sale Id 4018',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 10:56:27','',''),(4142,'1','310','1',1,'Retail Sale Id 4019',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 10:58:31','',''),(4143,'1','310','1',1,'Retail Sale Id 4020',1000.80,0.00,0.00,1.39,95.91,'2023-02-24 11:58:33','',''),(4144,'1','310','1',1,'Retail Sale Id 4021',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 12:00:05','',''),(4145,'1','310','1',1,'Retail Sale Id 4022',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 12:01:42','',''),(4146,'1','310','1',1,'Retail Sale Id 4023',5760.00,0.00,0.00,8.00,552.00,'2023-02-24 12:06:32','',''),(4147,'1','310','1',1,'Retail Sale Id 4025',2880.00,0.00,0.00,4.00,276.00,'2023-02-24 12:07:40','',''),(4148,'1','310','1',1,'Retail Sale Id 4026',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 12:09:21','',''),(4149,'1','310','1',1,'Retail Sale Id 4028',1000.80,0.00,0.00,1.39,95.91,'2023-02-24 12:17:28','',''),(4150,'1','310','1',1,'Retail Sale Id 4029',4003.20,0.00,0.00,5.56,383.64,'2023-02-24 12:18:10','',''),(4151,'1','310','1',1,'Retail Sale Id 4030',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 12:21:54','',''),(4152,'1','310','1',1,'Retail Sale Id 4031',140000.00,0.00,0.00,200.00,9800.00,'2023-02-24 12:24:27','',''),(4153,'1','310','1',1,'Retail Sale Id 4032',7000.00,0.00,0.00,10.00,490.00,'2023-02-24 12:27:59','',''),(4154,'1','310','1',1,'Retail Sale Id 4033',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 12:28:48','',''),(4155,'1','310','1',1,'Retail Sale Id 4034',1000.80,0.00,0.00,1.39,95.91,'2023-02-24 12:29:31','',''),(4156,'1','310','1',1,'Retail Sale Id 4035',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 12:30:52','',''),(4157,'1','310','1',1,'Retail Sale Id 4035',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 12:30:52','',''),(4158,'1','310','1',1,'Retail Sale Id 4035',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 12:30:52','',''),(4159,'1','310','1',1,'Retail Sale Id 4036',7999.20,0.00,0.00,11.11,766.59,'2023-02-24 12:31:45','',''),(4160,'1','310','1',1,'Retail Sale Id 4037',1202.40,0.00,0.00,1.67,115.23,'2023-02-24 12:32:29','',''),(4161,'1','310','1',1,'Retail Sale Id 4038',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 12:33:42','',''),(4162,'1','310','1',1,'Retail Sale Id 4039',1497.60,0.00,0.00,2.08,143.52,'2023-02-24 12:34:30','',''),(4163,'1','310','1',1,'Retail Sale Id 4040',900.00,0.00,0.00,1.25,86.25,'2023-02-24 12:35:24','',''),(4164,'1','310','1',1,'Retail Sale Id 4041',4996.80,0.00,0.00,6.94,478.86,'2023-02-24 12:38:37','',''),(4165,'1','310','1',1,'Retail Sale Id 4042',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 12:40:50','',''),(4166,'1','310','1',1,'Retail Sale Id 4042',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 12:40:50','',''),(4167,'1','310','1',1,'Retail Sale Id 4043',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 12:42:43','',''),(4168,'1','310','1',1,'Retail Sale Id 4044',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 12:44:04','',''),(4169,'1','310','1',1,'Retail Sale Id 4045',3499.20,0.00,0.00,4.86,335.34,'2023-02-24 12:44:57','',''),(4170,'1','310','1',1,'Retail Sale Id 4046',4996.80,0.00,0.00,6.94,478.86,'2023-02-24 12:45:39','',''),(4171,'1','310','1',1,'Retail Sale Id 4047',2001.60,0.00,0.00,2.78,191.82,'2023-02-24 12:46:31','',''),(4172,'1','310','1',1,'Retail Sale Id 4047',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 12:46:31','',''),(4173,'1','310','1',1,'Retail Sale Id 4049',1000.80,0.00,0.00,1.39,95.91,'2023-02-24 12:48:11','',''),(4174,'1','310','1',1,'Retail Sale Id 4050',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 12:49:36','',''),(4175,'1','310','1',1,'Retail Sale Id 4050',3002.40,0.00,0.00,4.17,287.73,'2023-02-24 12:49:36','',''),(4176,'1','310','1',1,'Retail Sale Id 4051',2498.40,0.00,0.00,3.47,239.43,'2023-02-24 12:50:42','',''),(4177,'1','310','1',1,'Retail Sale Id 4051',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 12:50:42','',''),(4178,'1','310','1',1,'Retail Sale Id 4051',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 12:50:42','',''),(4179,'1','310','1',1,'Retail Sale Id 4052',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 12:52:40','',''),(4180,'1','310','1',1,'Retail Sale Id 4053',1800.00,0.00,0.00,2.50,172.50,'2023-02-24 12:56:17','',''),(4181,'1','310','1',1,'Retail Sale Id 4054',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 12:58:07','',''),(4182,'1','310','1',1,'Retail Sale Id 4055',2800.80,0.00,0.00,3.89,268.41,'2023-02-24 12:58:54','',''),(4183,'1','310','1',1,'Retail Sale Id 4056',2203.20,0.00,0.00,3.06,211.14,'2023-02-24 13:19:58','',''),(4184,'1','310','1',1,'Retail Sale Id 4057',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 13:37:54','',''),(4185,'1','310','1',1,'Retail Sale Id 4058',4003.20,0.00,0.00,5.56,383.64,'2023-02-24 13:41:20','',''),(4186,'1','310','1',1,'Retail Sale Id 4059',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 13:44:37','',''),(4187,'1','310','1',1,'Retail Sale Id 4060',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 13:47:57','',''),(4188,'1','310','1',1,'Retail Sale Id 4061',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 13:54:24','',''),(4189,'1','310','1',1,'Retail Sale Id 4062',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 13:56:06','',''),(4190,'1','310','1',1,'Retail Sale Id 4063',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 14:00:54','',''),(4191,'1','310','1',1,'Retail Sale Id 4063',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 14:00:54','',''),(4192,'1','310','1',1,'Retail Sale Id 4064',9720.00,0.00,0.00,13.50,931.50,'2023-02-24 14:04:30','',''),(4193,'1','310','1',1,'Retail Sale Id 4065',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 14:05:52','',''),(4194,'1','310','1',1,'Retail Sale Id 4066',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 14:12:55','',''),(4195,'1','310','1',1,'Retail Sale Id 4067',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 14:18:42','',''),(4196,'1','310','1',1,'Retail Sale Id 4068',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 14:19:33','',''),(4197,'1','310','1',1,'Retail Sale Id 4069',2001.60,0.00,0.00,2.78,191.82,'2023-02-24 14:20:57','',''),(4198,'1','310','1',1,'Retail Sale Id 4070',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 14:22:37','',''),(4199,'1','310','1',1,'Retail Sale Id 4071',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 14:29:54','',''),(4200,'1','310','1',1,'Retail Sale Id 4072',3002.40,0.00,0.00,4.17,287.73,'2023-02-24 14:38:19','',''),(4201,'1','310','1',1,'Retail Sale Id 4073',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 14:43:21','',''),(4202,'1','310','1',1,'Retail Sale Id 4075',5997.60,0.00,0.00,8.33,574.77,'2023-02-24 14:46:11','',''),(4203,'1','310','1',1,'Retail Sale Id 4077',3003.00,0.00,0.00,4.29,210.21,'2023-02-24 14:51:21','',''),(4204,'1','310','1',1,'Retail Sale Id 4078',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 14:53:20','',''),(4205,'1','310','1',1,'Retail Sale Id 4080',4298.40,0.00,0.00,5.97,411.93,'2023-02-24 15:02:05','',''),(4206,'1','310','1',1,'Retail Sale Id 4082',6501.60,0.00,0.00,9.03,623.07,'2023-02-24 15:03:13','',''),(4207,'1','310','1',1,'Retail Sale Id 4083',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 15:07:44','',''),(4208,'1','310','1',1,'Retail Sale Id 4083',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 15:07:44','',''),(4209,'1','310','1',1,'Retail Sale Id 4084',11200.00,0.00,0.00,16.00,784.00,'2023-02-24 15:10:25','',''),(4210,'1','310','1',1,'Retail Sale Id 4085',1440.00,0.00,0.00,2.00,138.00,'2023-02-24 15:19:23','',''),(4211,'1','310','1',1,'Retail Sale Id 4086',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 15:25:38','',''),(4212,'1','310','1',1,'Retail Sale Id 4087',70000.00,0.00,0.00,100.00,4900.00,'2023-02-24 15:29:14','',''),(4213,'1','310','1',1,'Retail Sale Id 4088',1000.80,0.00,0.00,1.39,95.91,'2023-02-24 15:30:20','',''),(4214,'1','310','1',1,'Retail Sale Id 4089',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 15:31:08','',''),(4215,'1','310','1',1,'Retail Sale Id 4090',2001.60,0.00,0.00,2.78,191.82,'2023-02-24 15:32:20','',''),(4216,'1','310','1',1,'Retail Sale Id 4091',4003.20,0.00,0.00,5.56,383.64,'2023-02-24 15:34:10','',''),(4217,'1','310','1',1,'Retail Sale Id 4092',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 15:34:43','',''),(4218,'1','310','1',1,'Retail Sale Id 4093',1000.80,0.00,0.00,1.39,95.91,'2023-02-24 15:35:33','',''),(4219,'1','310','1',1,'Retail Sale Id 4094',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 15:37:17','',''),(4220,'1','310','1',1,'Retail Sale Id 4095',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 15:41:17','',''),(4221,'1','310','1',1,'Retail Sale Id 4096',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 15:43:58','',''),(4222,'1','310','1',1,'Retail Sale Id 4097',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 15:45:37','',''),(4223,'1','310','1',1,'Retail Sale Id 4100',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 15:47:34','',''),(4224,'1','310','1',1,'Retail Sale Id 4102',35000.00,0.00,0.00,50.00,2450.00,'2023-02-24 15:52:11','',''),(4225,'1','310','1',1,'Retail Sale Id 4103',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 15:57:33','',''),(4226,'1','310','1',1,'Retail Sale Id 4105',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 15:59:02','',''),(4227,'1','310','1',1,'Retail Sale Id 4106',4200.00,0.00,0.00,6.00,294.00,'2023-02-24 16:00:44','',''),(4228,'1','310','1',1,'Retail Sale Id 4107',105000.00,0.00,0.00,150.00,7350.00,'2023-02-24 16:02:32','',''),(4229,'1','310','1',1,'Retail Sale Id 4108',4996.80,0.00,0.00,6.94,478.86,'2023-02-24 16:05:35','',''),(4230,'1','310','1',1,'Retail Sale Id 4110',7200.00,0.00,0.00,10.00,690.00,'2023-02-24 16:07:48','',''),(4231,'1','310','1',1,'Retail Sale Id 4111',3002.40,0.00,0.00,4.17,287.73,'2023-02-24 16:10:21','',''),(4232,'1','310','1',1,'Retail Sale Id 4112',227500.00,0.00,0.00,325.00,15925.00,'2023-02-24 16:13:01','',''),(4233,'1','310','1',1,'Retail Sale Id 4113',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 16:14:54','',''),(4234,'1','310','1',1,'Retail Sale Id 4114',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 16:18:15','',''),(4235,'1','310','1',1,'Retail Sale Id 4115',7999.20,0.00,0.00,11.11,766.59,'2023-02-24 16:20:45','',''),(4236,'1','310','1',1,'Retail Sale Id 4116',2001.60,0.00,0.00,2.78,191.82,'2023-02-24 16:21:53','',''),(4237,'1','310','1',1,'Retail Sale Id 4119',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 16:27:48','',''),(4238,'1','310','1',1,'Retail Sale Id 4120',2001.60,0.00,0.00,2.78,191.82,'2023-02-24 16:32:23','',''),(4239,'1','310','1',1,'Retail Sale Id 4121',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 16:33:44','',''),(4240,'1','310','1',1,'Retail Sale Id 4122',22773.60,0.00,0.00,31.63,2182.47,'2023-02-24 16:35:25','',''),(4241,'1','310','1',1,'Retail Sale Id 4123',23500.80,0.00,0.00,32.64,2252.16,'2023-02-24 16:36:13','',''),(4242,'1','310','1',1,'Retail Sale Id 4124',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 16:38:36','',''),(4243,'1','310','1',1,'Retail Sale Id 4125',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 16:39:50','',''),(4244,'1','310','1',1,'Retail Sale Id 4126',1497.60,0.00,0.00,2.08,143.52,'2023-02-24 16:40:56','',''),(4245,'1','310','1',1,'Retail Sale Id 4127',3002.40,0.00,0.00,4.17,287.73,'2023-02-24 16:44:51','',''),(4246,'1','310','1',1,'Retail Sale Id 4128',2001.60,0.00,0.00,2.78,191.82,'2023-02-24 16:45:34','',''),(4247,'1','310','1',1,'Retail Sale Id 4129',1497.60,0.00,0.00,2.08,143.52,'2023-02-24 16:49:29','',''),(4248,'1','310','1',1,'Retail Sale Id 4130',14997.60,0.00,0.00,20.83,1437.27,'2023-02-24 16:50:14','',''),(4249,'1','310','1',1,'Retail Sale Id 4131',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 16:52:03','',''),(4250,'1','310','1',1,'Retail Sale Id 4132',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 16:53:00','',''),(4251,'1','310','1',1,'Retail Sale Id 4134',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 17:00:21','',''),(4252,'1','310','1',1,'Retail Sale Id 4135',4003.20,0.00,0.00,5.56,383.64,'2023-02-24 17:02:47','',''),(4253,'1','310','1',1,'Retail Sale Id 4136',70000.00,0.00,0.00,100.00,4900.00,'2023-02-24 17:04:15','',''),(4254,'1','310','1',1,'Retail Sale Id 4137',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 17:05:00','',''),(4255,'1','310','1',1,'Retail Sale Id 4138',4003.20,0.00,0.00,5.56,383.64,'2023-02-24 17:05:40','',''),(4256,'1','310','1',1,'Retail Sale Id 4139',2498.40,0.00,0.00,3.47,239.43,'2023-02-24 17:06:28','',''),(4257,'1','310','1',1,'Retail Sale Id 4140',799.20,0.00,0.00,1.11,76.59,'2023-02-24 17:07:22','',''),(4258,'1','310','1',1,'Retail Sale Id 4141',3002.40,0.00,0.00,4.17,287.73,'2023-02-24 17:10:41','',''),(4259,'1','310','1',1,'Retail Sale Id 4142',12240.00,0.00,0.00,17.00,1173.00,'2023-02-24 17:11:38','',''),(4260,'1','310','1',1,'Retail Sale Id 4143',2001.60,0.00,0.00,2.78,191.82,'2023-02-24 17:17:24','',''),(4261,'1','310','1',1,'Retail Sale Id 4144',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 17:18:18','',''),(4262,'1','310','1',1,'Retail Sale Id 4145',2001.60,0.00,0.00,2.78,191.82,'2023-02-24 17:19:23','',''),(4263,'1','310','1',1,'Retail Sale Id 4146',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 17:20:08','',''),(4264,'1','310','1',1,'Retail Sale Id 4147',219100.00,0.00,0.00,313.00,15337.00,'2023-02-24 17:21:20','',''),(4265,'1','310','1',1,'Retail Sale Id 4148',1000.80,0.00,0.00,1.39,95.91,'2023-02-24 17:23:11','',''),(4266,'1','310','1',1,'Retail Sale Id 4149',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 17:24:13','',''),(4267,'1','310','1',1,'Retail Sale Id 4150',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 17:24:56','',''),(4268,'1','310','1',1,'Retail Sale Id 4151',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 17:26:20','',''),(4269,'1','310','1',1,'Retail Sale Id 4152',496.80,0.00,0.00,0.69,47.61,'2023-02-24 17:27:41','',''),(4270,'1','310','1',1,'Retail Sale Id 4154',698.40,0.00,0.00,0.97,66.93,'2023-02-24 17:28:51','',''),(4271,'1','310','1',1,'Retail Sale Id 4155',1440.00,0.00,0.00,2.00,138.00,'2023-02-24 17:29:51','',''),(4272,'1','310','1',1,'Retail Sale Id 4156',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 17:31:10','',''),(4273,'1','310','1',1,'Retail Sale Id 4157',2880.00,0.00,0.00,4.00,276.00,'2023-02-24 17:32:20','',''),(4274,'1','310','1',1,'Retail Sale Id 4158',7200.00,0.00,0.00,10.00,690.00,'2023-02-24 17:33:24','',''),(4275,'1','310','1',1,'Retail Sale Id 4159',36000.00,0.00,0.00,50.00,3450.00,'2023-02-24 17:34:11','',''),(4276,'1','310','1',1,'Retail Sale Id 4160',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 17:34:59','',''),(4277,'1','310','1',1,'Retail Sale Id 4162',496.80,0.00,0.00,0.69,47.61,'2023-02-24 17:36:49','',''),(4278,'1','310','1',1,'Retail Sale Id 4162',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 17:36:49','',''),(4279,'1','310','1',1,'Retail Sale Id 4163',36000.00,0.00,0.00,50.00,3450.00,'2023-02-24 17:38:00','',''),(4280,'1','310','1',1,'Retail Sale Id 4164',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 17:39:44','',''),(4281,'1','310','1',1,'Retail Sale Id 4164',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 17:39:44','',''),(4282,'1','310','1',1,'Retail Sale Id 4165',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 17:40:26','',''),(4283,'1','310','1',1,'Retail Sale Id 4166',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 17:41:17','',''),(4284,'1','310','1',1,'Retail Sale Id 4167',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 17:43:09','',''),(4285,'1','310','1',1,'Retail Sale Id 4168',7999.20,0.00,0.00,11.11,766.59,'2023-02-24 17:43:45','',''),(4286,'1','310','1',1,'Retail Sale Id 4169',1497.60,0.00,0.00,2.08,143.52,'2023-02-24 17:44:27','',''),(4287,'1','310','1',1,'Retail Sale Id 4171',1497.60,0.00,0.00,2.08,143.52,'2023-02-24 17:45:52','',''),(4288,'1','310','1',1,'Retail Sale Id 4172',3002.40,0.00,0.00,4.17,287.73,'2023-02-24 17:46:34','',''),(4289,'1','310','1',1,'Retail Sale Id 4173',1000.80,0.00,0.00,1.39,95.91,'2023-02-24 17:47:05','',''),(4290,'1','310','1',1,'Retail Sale Id 4174',10800.00,0.00,0.00,15.00,1035.00,'2023-02-24 17:47:59','',''),(4291,'1','310','1',1,'Retail Sale Id 4175',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 17:49:01','',''),(4292,'1','310','1',1,'Retail Sale Id 4175',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 17:49:01','',''),(4293,'1','310','1',1,'Retail Sale Id 4175',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 17:49:01','',''),(4294,'1','310','1',1,'Retail Sale Id 4176',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 17:49:55','',''),(4295,'1','310','1',1,'Retail Sale Id 4176',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 17:49:55','',''),(4296,'1','310','1',1,'Retail Sale Id 4177',3002.40,0.00,0.00,4.17,287.73,'2023-02-24 17:50:35','',''),(4297,'1','310','1',1,'Retail Sale Id 4178',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 17:51:16','',''),(4298,'1','310','1',1,'Retail Sale Id 4179',3002.40,0.00,0.00,4.17,287.73,'2023-02-24 17:52:20','',''),(4299,'1','310','1',1,'Retail Sale Id 4179',3002.40,0.00,0.00,4.17,287.73,'2023-02-24 17:52:20','',''),(4300,'1','310','1',1,'Retail Sale Id 4180',3002.40,0.00,0.00,4.17,287.73,'2023-02-24 17:53:42','',''),(4301,'1','310','1',1,'Retail Sale Id 4181',1497.60,0.00,0.00,2.08,143.52,'2023-02-24 17:54:43','',''),(4302,'1','310','1',1,'Retail Sale Id 4182',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 17:56:35','',''),(4303,'1','310','1',1,'Retail Sale Id 4185',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 18:01:18','',''),(4304,'1','310','1',1,'Retail Sale Id 4185',3672.00,0.00,0.00,5.10,351.90,'2023-02-24 18:01:18','',''),(4305,'1','310','1',1,'Retail Sale Id 4185',9187.20,0.00,0.00,12.76,880.44,'2023-02-24 18:01:18','',''),(4306,'1','310','1',1,'Retail Sale Id 4188',26600.00,0.00,0.00,38.00,1862.00,'2023-02-24 18:04:17','',''),(4307,'1','310','1',1,'Retail Sale Id 4189',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 18:04:54','',''),(4308,'1','310','1',1,'Retail Sale Id 4190',4996.80,0.00,0.00,6.94,478.86,'2023-02-24 18:05:45','',''),(4309,'1','310','1',1,'Retail Sale Id 4191',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 18:06:28','',''),(4310,'1','310','1',1,'Retail Sale Id 4192',3499.20,0.00,0.00,4.86,335.34,'2023-02-24 18:07:22','',''),(4311,'1','310','1',1,'Retail Sale Id 4193',30002.00,0.00,0.00,42.86,2100.14,'2023-02-24 18:09:11','',''),(4312,'1','310','1',1,'Retail Sale Id 4194',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 18:10:34','',''),(4313,'1','310','1',1,'Retail Sale Id 4194',7200.00,0.00,0.00,10.00,690.00,'2023-02-24 18:10:34','',''),(4314,'1','310','1',1,'Retail Sale Id 4194',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 18:10:34','',''),(4315,'1','310','1',1,'Retail Sale Id 4195',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 18:14:51','',''),(4316,'1','310','1',1,'Retail Sale Id 4196',35000.00,0.00,0.00,50.00,2450.00,'2023-02-24 18:15:34','',''),(4317,'1','310','1',1,'Retail Sale Id 4197',1497.60,0.00,0.00,2.08,143.52,'2023-02-24 18:16:14','',''),(4318,'1','310','1',1,'Retail Sale Id 4198',3002.40,0.00,0.00,4.17,287.73,'2023-02-24 18:16:57','',''),(4319,'1','310','1',1,'Retail Sale Id 4199',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 18:20:37','',''),(4320,'1','310','1',1,'Retail Sale Id 4200',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 18:22:22','',''),(4321,'1','310','1',1,'Retail Sale Id 4201',4996.80,0.00,0.00,6.94,478.86,'2023-02-24 18:23:18','',''),(4322,'1','310','1',1,'Retail Sale Id 4202',2001.60,0.00,0.00,2.78,191.82,'2023-02-24 18:24:13','',''),(4323,'1','310','1',1,'Retail Sale Id 4203',1000.80,0.00,0.00,1.39,95.91,'2023-02-24 18:25:19','',''),(4324,'1','310','1',1,'Retail Sale Id 4204',6998.40,0.00,0.00,9.72,670.68,'2023-02-24 18:25:59','',''),(4325,'1','310','1',1,'Retail Sale Id 4205',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 18:26:48','',''),(4326,'1','310','1',1,'Retail Sale Id 4206',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 18:28:16','',''),(4327,'1','310','1',1,'Retail Sale Id 4206',5400.00,0.00,0.00,7.50,517.50,'2023-02-24 18:28:16','',''),(4328,'1','310','1',1,'Retail Sale Id 4206',8640.00,0.00,0.00,12.00,828.00,'2023-02-24 18:28:16','',''),(4329,'1','310','1',1,'Retail Sale Id 4207',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 18:28:59','',''),(4330,'1','310','1',1,'Retail Sale Id 4208',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 18:29:43','',''),(4331,'1','310','1',1,'Retail Sale Id 4209',6480.00,0.00,0.00,9.00,621.00,'2023-02-24 18:30:36','',''),(4332,'1','310','1',1,'Retail Sale Id 4209',6480.00,0.00,0.00,9.00,621.00,'2023-02-24 18:30:36','',''),(4333,'1','310','1',1,'Retail Sale Id 4210',698.40,0.00,0.00,0.97,66.93,'2023-02-24 18:32:03','',''),(4334,'1','310','1',1,'Retail Sale Id 4211',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 18:33:07','',''),(4335,'1','310','1',1,'Retail Sale Id 4211',7200.00,0.00,0.00,10.00,690.00,'2023-02-24 18:33:07','',''),(4336,'1','310','1',1,'Retail Sale Id 4212',2001.60,0.00,0.00,2.78,191.82,'2023-02-24 18:33:58','',''),(4337,'1','310','1',1,'Retail Sale Id 4213',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 18:34:45','',''),(4338,'1','310','1',1,'Retail Sale Id 4214',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 18:35:30','',''),(4339,'1','310','1',1,'Retail Sale Id 4215',1000.80,0.00,0.00,1.39,95.91,'2023-02-24 18:36:10','',''),(4340,'1','310','1',1,'Retail Sale Id 4216',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 18:36:48','',''),(4341,'1','310','1',1,'Retail Sale Id 4217',9499.00,0.00,0.00,13.57,664.93,'2023-02-24 18:37:54','',''),(4342,'1','310','1',1,'Retail Sale Id 4218',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 18:38:44','',''),(4343,'1','310','1',1,'Retail Sale Id 4219',698.40,0.00,0.00,0.97,66.93,'2023-02-24 18:39:37','',''),(4344,'1','310','1',1,'Retail Sale Id 4219',2001.60,0.00,0.00,2.78,191.82,'2023-02-24 18:39:37','',''),(4345,'1','310','1',1,'Retail Sale Id 4220',2160.00,0.00,0.00,3.00,207.00,'2023-02-24 18:40:22','',''),(4346,'1','310','1',1,'Retail Sale Id 4221',1001.00,0.00,0.00,1.43,70.07,'2023-02-24 18:41:28','',''),(4347,'1','310','1',1,'Retail Sale Id 4222',2001.60,0.00,0.00,2.78,191.82,'2023-02-24 18:42:20','',''),(4348,'1','310','1',1,'Retail Sale Id 4223',35000.00,0.00,0.00,50.00,2450.00,'2023-02-24 18:43:10','',''),(4349,'1','310','1',1,'Retail Sale Id 4224',4003.20,0.00,0.00,5.56,383.64,'2023-02-24 18:44:54','',''),(4350,'1','310','1',1,'Retail Sale Id 4224',5997.60,0.00,0.00,8.33,574.77,'2023-02-24 18:44:54','',''),(4351,'1','310','1',1,'Retail Sale Id 4225',4500.00,0.00,0.00,6.25,431.25,'2023-02-24 18:45:35','',''),(4352,'1','310','1',1,'Retail Sale Id 4226',4996.80,0.00,0.00,6.94,478.86,'2023-02-24 18:46:24','',''),(4353,'1','310','1',1,'Retail Sale Id 4227',3600.00,0.00,0.00,5.00,345.00,'2023-02-24 18:47:09','',''),(4354,'1','310','1',1,'Retail Sale Id 4228',9000.00,0.00,0.00,12.50,862.50,'2023-02-24 18:47:49','',''),(4355,'1','310','1',1,'Retail Sale Id 4229',4320.00,0.00,0.00,6.00,414.00,'2023-02-24 18:48:27','',''),(4356,'1','310','1',1,'Retail Sale Id 4230',16941.60,0.00,0.00,23.53,1623.57,'2023-02-24 18:54:32','',''),(4357,'1','310','1',1,'Retail Sale Id 4231',2520.00,0.00,0.00,3.50,241.50,'2023-02-24 19:01:24','',''),(4358,'1','310','1',1,'Retail Sale Id 4232',1800.00,0.00,0.00,2.50,172.50,'2023-02-24 19:02:22','',''),(4359,'1','310','1',1,'Return of Retail Sale Id 4123',0.00,23500.80,32.64,0.00,-2252.16,'2023-02-24 21:42:39','',''),(4360,'1','310','1',1,'Return of Retail Sale Id 4225',0.00,4500.00,6.25,0.00,-431.25,'2023-02-24 21:43:46','',''),(4361,'1','310','1',1,'Retail Sale Id 4233',813.60,0.00,0.00,1.13,77.97,'2023-02-24 21:44:23','',''),(4362,'1','310','1',1,'Return of Retail Sale Id 4217',0.00,9499.00,13.57,0.00,-664.93,'2023-02-24 21:46:18','',''),(4363,'1','310','1',1,'Retail Sale Id 4234',9506.00,0.00,0.00,13.58,665.42,'2023-02-24 21:47:15','',''),(4364,'1','310','1',1,'Retail Sale Id 4235',2001.60,0.00,0.00,2.78,191.82,'2023-02-26 09:00:06','',''),(4365,'1','310','1',1,'Retail Sale Id 4236',2001.60,0.00,0.00,2.78,191.82,'2023-02-26 09:01:03','',''),(4366,'1','310','1',1,'Retail Sale Id 4237',42000.00,0.00,0.00,60.00,2940.00,'2023-02-26 09:01:51','',''),(4367,'1','310','1',1,'Retail Sale Id 4238',1497.60,0.00,0.00,2.08,143.52,'2023-02-26 09:03:13','',''),(4368,'1','310','1',1,'Retail Sale Id 4239',7999.20,0.00,0.00,11.11,766.59,'2023-02-26 09:04:17','',''),(4369,'1','310','1',1,'Retail Sale Id 4240',4996.80,0.00,0.00,6.94,478.86,'2023-02-26 09:05:23','',''),(4370,'1','310','1',1,'Retail Sale Id 4241',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 09:06:27','',''),(4371,'1','310','1',1,'Retail Sale Id 4242',122500.00,0.00,0.00,175.00,8575.00,'2023-02-26 09:11:01','',''),(4372,'1','310','1',1,'Retail Sale Id 4243',2160.00,0.00,0.00,3.00,207.00,'2023-02-26 09:12:09','',''),(4373,'1','310','1',1,'Retail Sale Id 4244',4003.20,0.00,0.00,5.56,383.64,'2023-02-26 09:13:17','',''),(4374,'1','310','1',1,'Retail Sale Id 4245',1000.80,0.00,0.00,1.39,95.91,'2023-02-26 09:18:12','',''),(4375,'1','310','1',1,'Retail Sale Id 4246',1497.60,0.00,0.00,2.08,143.52,'2023-02-26 09:19:24','',''),(4376,'1','310','1',1,'Retail Sale Id 4247',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 09:20:40','',''),(4377,'1','310','1',1,'Retail Sale Id 4248',1000.80,0.00,0.00,1.39,95.91,'2023-02-26 09:21:49','',''),(4378,'1','310','1',1,'Retail Sale Id 4249',2160.00,0.00,0.00,3.00,207.00,'2023-02-26 09:40:08','',''),(4379,'1','310','1',1,'Retail Sale Id 4250',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 09:50:01','',''),(4380,'1','310','1',1,'Retail Sale Id 4251',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 09:51:28','',''),(4381,'1','310','1',1,'Retail Sale Id 4252',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 09:53:08','',''),(4382,'1','310','1',1,'Retail Sale Id 4253',2001.60,0.00,0.00,2.78,191.82,'2023-02-26 09:55:23','',''),(4383,'1','310','1',1,'Retail Sale Id 4254',2498.40,0.00,0.00,3.47,239.43,'2023-02-26 09:57:53','',''),(4384,'1','310','1',1,'Retail Sale Id 4255',35000.00,0.00,0.00,50.00,2450.00,'2023-02-26 10:05:26','',''),(4385,'1','310','1',1,'Retail Sale Id 4256',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 10:06:45','',''),(4386,'1','310','1',1,'Retail Sale Id 4257',1497.60,0.00,0.00,2.08,143.52,'2023-02-26 10:10:33','',''),(4387,'1','310','1',1,'Retail Sale Id 4258',2160.00,0.00,0.00,3.00,207.00,'2023-02-26 10:12:45','',''),(4388,'1','310','1',1,'Retail Sale Id 4258',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 10:12:45','',''),(4389,'1','310','1',1,'Retail Sale Id 4259',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 10:13:34','',''),(4390,'1','310','1',1,'Retail Sale Id 4260',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 10:15:14','',''),(4391,'1','310','1',1,'Retail Sale Id 4260',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 10:15:14','',''),(4392,'1','310','1',1,'Retail Sale Id 4261',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 10:29:03','',''),(4393,'1','310','1',1,'Retail Sale Id 4262',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 10:29:52','',''),(4394,'1','310','1',1,'Retail Sale Id 4263',2160.00,0.00,0.00,3.00,207.00,'2023-02-26 10:31:37','',''),(4395,'1','310','1',1,'Retail Sale Id 4264',2001.60,0.00,0.00,2.78,191.82,'2023-02-26 10:33:56','',''),(4396,'1','310','1',1,'Retail Sale Id 4265',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 10:39:12','',''),(4397,'1','310','1',1,'Retail Sale Id 4266',70000.00,0.00,0.00,100.00,4900.00,'2023-02-26 10:44:53','',''),(4398,'1','310','1',1,'Retail Sale Id 4267',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 11:02:34','',''),(4399,'1','310','1',1,'Retail Sale Id 4268',17997.00,0.00,0.00,25.71,1259.79,'2023-02-26 11:09:38','',''),(4400,'1','310','1',1,'Retail Sale Id 4270',17997.00,0.00,0.00,25.71,1259.79,'2023-02-26 11:14:35','',''),(4401,'1','310','1',1,'Retail Sale Id 4271',3002.40,0.00,0.00,4.17,287.73,'2023-02-26 11:15:41','',''),(4402,'1','310','1',1,'Retail Sale Id 4272',2160.00,0.00,0.00,3.00,207.00,'2023-02-26 11:18:59','',''),(4403,'1','310','1',1,'Retail Sale Id 4273',2001.60,0.00,0.00,2.78,191.82,'2023-02-26 11:21:18','',''),(4404,'1','310','1',1,'Retail Sale Id 4274',1800.00,0.00,0.00,2.50,172.50,'2023-02-26 11:23:40','',''),(4405,'1','310','1',1,'Retail Sale Id 4275',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 11:25:07','',''),(4406,'1','310','1',1,'Retail Sale Id 4276',50400.00,0.00,0.00,72.00,3528.00,'2023-02-26 11:32:39','',''),(4407,'1','310','1',1,'Retail Sale Id 4277',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 11:34:49','',''),(4408,'1','310','1',1,'Retail Sale Id 4277',8640.00,0.00,0.00,12.00,828.00,'2023-02-26 11:34:49','',''),(4409,'1','310','1',1,'Retail Sale Id 4278',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 11:36:06','',''),(4410,'1','310','1',1,'Retail Sale Id 4279',3002.40,0.00,0.00,4.17,287.73,'2023-02-26 11:39:11','',''),(4411,'1','310','1',1,'Retail Sale Id 4280',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 11:40:14','',''),(4412,'1','310','1',1,'Retail Sale Id 4281',2001.60,0.00,0.00,2.78,191.82,'2023-02-26 11:42:28','',''),(4413,'1','310','1',1,'Retail Sale Id 4282',140000.00,0.00,0.00,200.00,9800.00,'2023-02-26 11:49:31','',''),(4414,'1','310','1',1,'Retail Sale Id 4283',1800.00,0.00,0.00,2.50,172.50,'2023-02-26 11:50:13','',''),(4415,'1','310','1',1,'Retail Sale Id 4284',1497.60,0.00,0.00,2.08,143.52,'2023-02-26 11:51:28','',''),(4416,'1','310','1',1,'Retail Sale Id 4285',4500.00,0.00,0.00,6.25,431.25,'2023-02-26 11:52:46','',''),(4417,'1','310','1',1,'Retail Sale Id 4286',1497.60,0.00,0.00,2.08,143.52,'2023-02-26 11:54:38','',''),(4418,'1','310','1',1,'Retail Sale Id 4287',1000.80,0.00,0.00,1.39,95.91,'2023-02-26 11:55:51','',''),(4419,'1','310','1',1,'Retail Sale Id 4288',1497.60,0.00,0.00,2.08,143.52,'2023-02-26 11:56:34','',''),(4420,'1','310','1',1,'Retail Sale Id 4289',3600.00,0.00,0.00,5.00,345.00,'2023-02-26 11:58:40','',''),(4421,'1','310','1',1,'Retail Sale Id 4290',140000.00,0.00,0.00,200.00,9800.00,'2023-02-26 12:00:26','',''),(4422,'1','310','1',1,'Retail Sale Id 4291',19999.00,0.00,0.00,28.57,1399.93,'2023-02-26 12:01:46','',''),(4423,'1','310','1',1,'Retail Sale Id 4292',799.20,0.00,0.00,1.11,76.59,'2023-02-26 12:02:54','',''),(4424,'1','310','1',1,'Retail Sale Id 4293',3002.40,0.00,0.00,4.17,287.73,'2023-02-26 12:04:15','',''),(4425,'1','310','1',1,'Retail Sale Id 4294',2880.00,0.00,0.00,4.00,276.00,'2023-02-26 12:07:24','',''),(4426,'1','310','1',1,'Retail Sale Id 4294',5760.00,0.00,0.00,8.00,552.00,'2023-02-26 12:07:24','',''),(4427,'1','310','1',1,'Retail Sale Id 4295',3600.00,0.00,0.00,5.00,345.00,'2023-02-26 12:07:55','',''),(4428,'1','310','1',1,'Retail Sale Id 4296',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 12:09:35','',''),(4429,'1','310','1',1,'Retail Sale Id 4297',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 12:11:17','',''),(4430,'1','310','1',1,'Retail Sale Id 4298',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 12:12:04','',''),(4431,'1','310','1',1,'Retail Sale Id 4299',2001.60,0.00,0.00,2.78,191.82,'2023-02-26 12:12:47','',''),(4432,'1','310','1',1,'Retail Sale Id 4300',2152.80,0.00,0.00,2.99,206.31,'2023-02-26 12:14:54','',''),(4433,'1','310','1',1,'Retail Sale Id 4301',2160.00,0.00,0.00,3.00,207.00,'2023-02-26 12:15:43','',''),(4434,'1','310','1',1,'Retail Sale Id 4302',2001.60,0.00,0.00,2.78,191.82,'2023-02-26 12:16:31','',''),(4435,'1','310','1',1,'Retail Sale Id 4303',2160.00,0.00,0.00,3.00,207.00,'2023-02-26 12:18:15','',''),(4436,'1','310','1',1,'Retail Sale Id 4304',4996.80,0.00,0.00,6.94,478.86,'2023-02-26 12:19:58','',''),(4437,'1','310','1',1,'Retail Sale Id 4305',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 12:20:57','',''),(4438,'1','310','1',1,'Retail Sale Id 4306',2160.00,0.00,0.00,3.00,207.00,'2023-02-26 12:22:18','',''),(4439,'1','310','1',1,'Retail Sale Id 4307',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 12:25:03','',''),(4440,'1','310','1',1,'Return of Retail Sale Id 4270',0.00,17997.00,25.71,0.00,-1259.79,'2023-02-26 12:27:04','',''),(4441,'1','310','1',1,'Retail Sale Id 4308',1497.60,0.00,0.00,2.08,143.52,'2023-02-26 12:30:16','',''),(4442,'1','310','1',1,'Retail Sale Id 4308',1497.60,0.00,0.00,2.08,143.52,'2023-02-26 12:30:16','',''),(4443,'1','310','1',1,'Retail Sale Id 4309',3600.00,0.00,0.00,5.00,345.00,'2023-02-26 12:33:20','',''),(4444,'1','310','1',1,'Retail Sale Id 4309',3600.00,0.00,0.00,5.00,345.00,'2023-02-26 12:33:20','',''),(4445,'1','310','1',1,'Retail Sale Id 4311',5997.60,0.00,0.00,8.33,574.77,'2023-02-26 12:35:10','',''),(4446,'1','310','1',1,'Retail Sale Id 4312',1000.80,0.00,0.00,1.39,95.91,'2023-02-26 12:35:56','',''),(4447,'1','310','1',1,'Retail Sale Id 4313',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 12:37:32','',''),(4448,'1','310','1',1,'Retail Sale Id 4314',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 12:39:12','',''),(4449,'1','310','1',1,'Retail Sale Id 4315',1497.60,0.00,0.00,2.08,143.52,'2023-02-26 12:39:36','',''),(4450,'1','310','1',1,'Retail Sale Id 4316',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 12:41:31','',''),(4451,'1','310','1',1,'Retail Sale Id 4317',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 12:44:19','',''),(4452,'1','310','1',1,'Retail Sale Id 4318',4003.20,0.00,0.00,5.56,383.64,'2023-02-26 12:45:39','',''),(4453,'1','310','1',1,'Retail Sale Id 4319',5040.00,0.00,0.00,7.00,483.00,'2023-02-26 12:49:52','',''),(4454,'1','310','1',1,'Retail Sale Id 4320',1497.60,0.00,0.00,2.08,143.52,'2023-02-26 12:56:53','',''),(4455,'1','310','1',1,'Retail Sale Id 4321',2160.00,0.00,0.00,3.00,207.00,'2023-02-26 12:58:08','',''),(4456,'1','310','1',1,'Retail Sale Id 4322',3600.00,0.00,0.00,5.00,345.00,'2023-02-26 13:01:08','',''),(4457,'1','310','1',1,'Retail Sale Id 4323',1000.80,0.00,0.00,1.39,95.91,'2023-02-26 13:25:39','',''),(4458,'1','310','1',1,'Retail Sale Id 4324',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 13:30:13','',''),(4459,'1','310','1',1,'Retail Sale Id 4325',2160.00,0.00,0.00,3.00,207.00,'2023-02-26 13:31:19','',''),(4460,'1','310','1',1,'Retail Sale Id 4326',70000.00,0.00,0.00,100.00,4900.00,'2023-02-26 13:32:35','',''),(4461,'1','310','1',1,'Retail Sale Id 4327',2001.60,0.00,0.00,2.78,191.82,'2023-02-26 13:45:34','',''),(4462,'1','310','1',1,'Retail Sale Id 4328',1000.80,0.00,0.00,1.39,95.91,'2023-02-26 13:46:44','',''),(4463,'1','310','1',1,'Retail Sale Id 4329',4996.80,0.00,0.00,6.94,478.86,'2023-02-26 13:50:33','',''),(4464,'1','310','1',1,'Retail Sale Id 4330',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 13:52:42','',''),(4465,'1','310','1',1,'Retail Sale Id 4331',720.00,0.00,0.00,1.00,69.00,'2023-02-26 13:55:04','',''),(4466,'1','310','1',1,'Retail Sale Id 4332',3600.00,0.00,0.00,5.00,345.00,'2023-02-26 13:58:38','',''),(4467,'1','310','1',1,'Retail Sale Id 4333',2001.60,0.00,0.00,2.78,191.82,'2023-02-26 14:01:01','',''),(4468,'1','310','1',1,'Retail Sale Id 4334',3600.00,0.00,0.00,5.00,345.00,'2023-02-26 14:04:07','',''),(4469,'1','310','1',1,'Retail Sale Id 4335',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 14:13:44','',''),(4470,'1','310','1',1,'Retail Sale Id 4336',2160.00,0.00,0.00,3.00,207.00,'2023-02-26 14:20:09','',''),(4471,'1','310','1',1,'Retail Sale Id 4337',140000.00,0.00,0.00,200.00,9800.00,'2023-02-26 14:29:13','',''),(4472,'1','310','1',1,'Retail Sale Id 4338',1000.80,0.00,0.00,1.39,95.91,'2023-02-26 14:43:22','',''),(4473,'1','310','1',1,'Retail Sale Id 4340',1497.60,0.00,0.00,2.08,143.52,'2023-02-26 14:47:03','',''),(4474,'1','310','1',1,'Retail Sale Id 4341',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 14:50:39','',''),(4475,'1','310','1',1,'Retail Sale Id 4342',3600.00,0.00,0.00,5.00,345.00,'2023-02-26 14:52:45','',''),(4476,'1','310','1',1,'Retail Sale Id 4344',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 14:55:32','',''),(4477,'1','310','1',1,'Retail Sale Id 4345',2880.00,0.00,0.00,4.00,276.00,'2023-02-26 15:08:08','',''),(4478,'1','310','1',1,'Retail Sale Id 4346',10800.00,0.00,0.00,15.00,1035.00,'2023-02-26 15:09:11','',''),(4479,'1','310','1',1,'Retail Sale Id 4347',2001.60,0.00,0.00,2.78,191.82,'2023-02-26 15:28:37','',''),(4480,'1','310','1',1,'Retail Sale Id 4347',4003.20,0.00,0.00,5.56,383.64,'2023-02-26 15:28:37','',''),(4481,'1','310','1',1,'Retail Sale Id 4348',2203.20,0.00,0.00,3.06,211.14,'2023-02-26 15:30:48','',''),(4482,'1','310','1',1,'Retail Sale Id 4349',34300.00,0.00,0.00,49.00,2401.00,'2023-02-26 15:33:19','',''),(4483,'1','310','1',1,'Retail Sale Id 4350',1497.60,0.00,0.00,2.08,143.52,'2023-02-26 15:35:58','',''),(4484,'1','310','1',1,'Retail Sale Id 4351',2102.40,0.00,0.00,2.92,201.48,'2023-02-26 15:37:09','',''),(4485,'1','310','1',1,'Retail Sale Id 4352',3002.40,0.00,0.00,4.17,287.73,'2023-02-26 15:39:31','',''),(4486,'1','310','1',1,'Retail Sale Id 4353',2160.00,0.00,0.00,3.00,207.00,'2023-02-26 15:41:32','',''),(4487,'1','310','1',1,'Retail Sale Id 4354',3600.00,0.00,0.00,5.00,345.00,'2023-02-26 15:48:31','',''),(4488,'1','310','1',1,'Retail Sale Id 4355',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 15:54:13','',''),(4489,'1','310','1',1,'Retail Sale Id 4356',3002.40,0.00,0.00,4.17,287.73,'2023-02-26 15:55:40','',''),(4490,'1','310','1',1,'Retail Sale Id 4357',1000.80,0.00,0.00,1.39,95.91,'2023-02-26 15:56:47','',''),(4491,'1','310','1',1,'Retail Sale Id 4358',1000.80,0.00,0.00,1.39,95.91,'2023-02-26 15:57:45','',''),(4492,'1','310','1',1,'Retail Sale Id 4359',3002.40,0.00,0.00,4.17,287.73,'2023-02-26 15:59:26','',''),(4493,'1','310','1',1,'Retail Sale Id 4361',2160.00,0.00,0.00,3.00,207.00,'2023-02-26 16:29:25','',''),(4494,'1','310','1',1,'Retail Sale Id 4363',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 16:32:10','',''),(4495,'1','310','1',1,'Retail Sale Id 4363',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 16:32:10','',''),(4496,'1','310','1',1,'Retail Sale Id 4364',1497.60,0.00,0.00,2.08,143.52,'2023-02-26 16:34:26','',''),(4497,'1','310','1',1,'Retail Sale Id 4365',1497.60,0.00,0.00,2.08,143.52,'2023-02-26 16:39:52','',''),(4498,'1','310','1',1,'Retail Sale Id 4366',4996.80,0.00,0.00,6.94,478.86,'2023-02-26 16:41:45','',''),(4499,'1','310','1',1,'Retail Sale Id 4368',4003.20,0.00,0.00,5.56,383.64,'2023-02-26 16:44:54','',''),(4500,'1','310','1',1,'Retail Sale Id 4370',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 16:46:18','',''),(4501,'1','310','1',1,'Retail Sale Id 4372',1497.60,0.00,0.00,2.08,143.52,'2023-02-26 16:47:07','',''),(4502,'1','310','1',1,'Retail Sale Id 4374',1000.80,0.00,0.00,1.39,95.91,'2023-02-26 16:52:32','',''),(4503,'1','310','1',1,'Retail Sale Id 4374',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 16:52:32','',''),(4504,'1','310','1',1,'Retail Sale Id 4374',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 16:52:32','',''),(4505,'1','310','1',1,'Retail Sale Id 4375',1000.80,0.00,0.00,1.39,95.91,'2023-02-26 16:56:15','',''),(4506,'1','310','1',1,'Retail Sale Id 4376',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 16:57:44','',''),(4507,'1','310','1',1,'Retail Sale Id 4377',10000.80,0.00,0.00,13.89,958.41,'2023-02-26 17:02:44','',''),(4508,'1','310','1',1,'Retail Sale Id 4378',17928.00,0.00,0.00,24.90,1718.10,'2023-02-26 17:06:00','',''),(4509,'1','310','1',1,'Retail Sale Id 4379',496.80,0.00,0.00,0.69,47.61,'2023-02-26 17:08:24','',''),(4510,'1','310','1',1,'Retail Sale Id 4380',2001.60,0.00,0.00,2.78,191.82,'2023-02-26 17:10:31','',''),(4511,'1','310','1',1,'Retail Sale Id 4381',1497.60,0.00,0.00,2.08,143.52,'2023-02-26 17:11:54','',''),(4512,'1','310','1',1,'Retail Sale Id 4382',2160.00,0.00,0.00,3.00,207.00,'2023-02-26 17:14:05','',''),(4513,'1','310','1',1,'Retail Sale Id 4383',6501.60,0.00,0.00,9.03,623.07,'2023-02-26 17:15:10','',''),(4514,'1','310','1',1,'Retail Sale Id 4384',3600.00,0.00,0.00,5.00,345.00,'2023-02-26 17:15:56','',''),(4515,'1','310','1',1,'Retail Sale Id 4386',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 17:19:22','',''),(4516,'1','310','1',1,'Retail Sale Id 4387',2160.00,0.00,0.00,3.00,207.00,'2023-02-26 17:20:34','',''),(4517,'1','310','1',1,'Retail Sale Id 4388',3002.40,0.00,0.00,4.17,287.73,'2023-02-26 17:21:50','',''),(4518,'1','310','1',1,'Retail Sale Id 4389',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 17:24:17','',''),(4519,'1','310','1',1,'Retail Sale Id 4390',1440.00,0.00,0.00,2.00,138.00,'2023-02-26 17:27:54','',''),(4520,'1','310','1',1,'Retail Sale Id 4391',2160.00,0.00,0.00,3.00,207.00,'2023-02-26 17:29:31','',''),(4521,'1','310','1',1,'Retail Sale Id 4392',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 17:30:37','',''),(4522,'1','310','1',1,'Retail Sale Id 4393',3002.40,0.00,0.00,4.17,287.73,'2023-02-26 17:32:08','',''),(4523,'1','310','1',1,'Retail Sale Id 4394',2160.00,0.00,0.00,3.00,207.00,'2023-02-26 17:41:33','',''),(4524,'1','310','1',1,'Retail Sale Id 4395',140000.00,0.00,0.00,200.00,9800.00,'2023-02-26 17:43:11','',''),(4525,'1','310','1',1,'Retail Sale Id 4396',7200.00,0.00,0.00,10.00,690.00,'2023-02-26 17:48:20','',''),(4526,'1','310','1',1,'Retail Sale Id 4398',2001.60,0.00,0.00,2.78,191.82,'2023-02-26 17:51:47','',''),(4527,'1','310','1',1,'Retail Sale Id 4399',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 17:54:11','',''),(4528,'1','310','1',1,'Retail Sale Id 4400',1000.80,0.00,0.00,1.39,95.91,'2023-02-26 18:00:37','',''),(4529,'1','310','1',1,'Retail Sale Id 4401',3600.00,0.00,0.00,5.00,345.00,'2023-02-26 18:02:20','',''),(4530,'1','310','1',1,'Retail Sale Id 4402',2160.00,0.00,0.00,3.00,207.00,'2023-02-26 18:03:32','',''),(4531,'1','310','1',1,'Retail Sale Id 4403',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 18:04:38','',''),(4532,'1','310','1',1,'Retail Sale Id 4403',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 18:04:38','',''),(4533,'1','310','1',1,'Retail Sale Id 4404',5250.00,0.00,0.00,7.50,367.50,'2023-02-26 18:07:08','',''),(4534,'1','310','1',1,'Retail Sale Id 4405',2160.00,0.00,0.00,3.00,207.00,'2023-02-26 18:08:19','',''),(4535,'1','310','1',1,'Retail Sale Id 4406',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 18:09:33','',''),(4536,'1','310','1',1,'Retail Sale Id 4408',496.80,0.00,0.00,0.69,47.61,'2023-02-26 18:12:57','',''),(4537,'1','310','1',1,'Retail Sale Id 4409',2498.40,0.00,0.00,3.47,239.43,'2023-02-26 18:17:31','',''),(4538,'1','310','1',1,'Retail Sale Id 4410',9000.00,0.00,0.00,12.50,862.50,'2023-02-26 18:19:52','',''),(4539,'1','310','1',1,'Retail Sale Id 4411',720.00,0.00,0.00,1.00,69.00,'2023-02-26 18:20:35','',''),(4540,'1','310','1',1,'Retail Sale Id 4412',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 18:28:02','',''),(4541,'1','310','1',1,'Retail Sale Id 4413',3002.40,0.00,0.00,4.17,287.73,'2023-02-26 18:31:11','',''),(4542,'1','310','1',1,'Retail Sale Id 4414',3002.40,0.00,0.00,4.17,287.73,'2023-02-26 18:34:41','',''),(4543,'1','310','1',1,'Retail Sale Id 4415',4320.00,0.00,0.00,6.00,414.00,'2023-02-26 18:35:48','',''),(4544,'1','310','1',1,'Retail Sale Id 4416',9496.80,0.00,0.00,13.19,910.11,'2023-02-26 18:37:46','',''),(4545,'1','310','1',1,'Retail Sale Id 4417',1000.80,0.00,0.00,1.39,95.91,'2023-02-26 18:41:09','',''),(4546,'1','310','1',1,'Return of Retail Sale Id 4378',0.00,17928.00,24.90,0.00,-1718.10,'2023-02-26 18:55:28','',''),(4547,'1','310','1',1,'Return of Retail Sale Id 4386',0.00,9000.00,12.50,0.00,-862.50,'2023-02-26 18:56:01','',''),(4548,'1','310','1',1,'Return of Retail Sale Id 4390',0.00,1440.00,2.00,0.00,-138.00,'2023-02-26 18:56:45','',''),(4549,'1','310','1',1,'Retail Sale Id 4418',856.80,0.00,0.00,1.19,82.11,'2023-02-26 18:57:15','',''),(4550,'1','310','1',1,'Return of Retail Sale Id 4404',0.00,5250.00,7.50,0.00,-367.50,'2023-02-26 18:58:39','',''),(4551,'1','310','1',1,'Retail Sale Id 4419',3339.00,0.00,0.00,4.77,233.73,'2023-02-26 18:59:20','',''),(4552,'1','310','1',1,'Retail Sale Id 4420',4320.00,0.00,0.00,6.00,414.00,'2023-02-27 07:27:01','',''),(4553,'1','310','1',1,'Retail Sale Id 4421',4320.00,0.00,0.00,6.00,414.00,'2023-02-27 07:27:50','',''),(4554,'1','310','1',1,'Retail Sale Id 4422',4320.00,0.00,0.00,6.00,414.00,'2023-02-27 08:12:16','',''),(4555,'1','310','1',1,'Retail Sale Id 4423',2160.00,0.00,0.00,3.00,207.00,'2023-02-27 08:44:38','',''),(4556,'1','310','1',1,'Retail Sale Id 4423',9000.00,0.00,0.00,12.50,862.50,'2023-02-27 08:44:38','',''),(4557,'1','310','1',1,'Retail Sale Id 4424',3600.00,0.00,0.00,5.00,345.00,'2023-02-27 08:45:36','',''),(4558,'1','310','1',1,'Retail Sale Id 4425',2160.00,0.00,0.00,3.00,207.00,'2023-02-27 08:47:20','',''),(4559,'1','310','1',1,'Retail Sale Id 4426',105000.00,0.00,0.00,150.00,7350.00,'2023-02-27 08:48:54','',''),(4560,'1','310','1',1,'Retail Sale Id 4427',4320.00,0.00,0.00,6.00,414.00,'2023-02-27 08:52:23','',''),(4561,'1','310','1',1,'Retail Sale Id 4428',10857.60,0.00,0.00,15.08,1040.52,'2023-02-27 09:01:23','',''),(4562,'1','310','1',1,'Retail Sale Id 4429',2001.60,0.00,0.00,2.78,191.82,'2023-02-27 09:31:19','',''),(4563,'1','310','1',1,'Retail Sale Id 4430',9000.00,0.00,0.00,12.50,862.50,'2023-02-27 09:34:34','',''),(4564,'1','310','1',1,'Retail Sale Id 4431',4996.80,0.00,0.00,6.94,478.86,'2023-02-27 09:35:56','',''),(4565,'1','310','1',1,'Retail Sale Id 4432',4320.00,0.00,0.00,6.00,414.00,'2023-02-27 09:38:37','',''),(4566,'1','310','1',1,'Retail Sale Id 4433',2160.00,0.00,0.00,3.00,207.00,'2023-02-27 09:42:03','',''),(4567,'1','310','1',1,'Retail Sale Id 4434',9000.00,0.00,0.00,12.50,862.50,'2023-02-27 09:49:40','',''),(4568,'1','310','1',1,'Retail Sale Id 4435',4320.00,0.00,0.00,6.00,414.00,'2023-02-27 09:51:59','',''),(4569,'1','310','1',1,'Retail Sale Id 4436',3600.00,0.00,0.00,5.00,345.00,'2023-02-27 09:56:09','',''),(4570,'1','310','1',1,'Retail Sale Id 4437',4500.00,0.00,0.00,6.25,431.25,'2023-02-27 10:27:36','',''),(4571,'1','310','1',1,'Retail Sale Id 4437',4500.00,0.00,0.00,6.25,431.25,'2023-02-27 10:27:36','',''),(4572,'1','310','1',1,'Retail Sale Id 4439',7200.00,0.00,0.00,10.00,690.00,'2023-02-27 10:41:49','',''),(4573,'1','310','1',1,'Retail Sale Id 4440',35000.00,0.00,0.00,50.00,2450.00,'2023-02-27 10:43:10','',''),(4574,'1','310','1',1,'Retail Sale Id 4441',2001.60,0.00,0.00,2.78,191.82,'2023-02-27 10:46:17','',''),(4575,'1','310','1',1,'Retail Sale Id 4442',2160.00,0.00,0.00,3.00,207.00,'2023-02-27 10:53:32','',''),(4576,'1','310','1',1,'Retail Sale Id 4443',1000.80,0.00,0.00,1.39,95.91,'2023-02-27 10:55:13','',''),(4577,'1','310','1',1,'Retail Sale Id 4444',2001.60,0.00,0.00,2.78,191.82,'2023-02-27 10:56:21','',''),(4578,'1','310','1',1,'Retail Sale Id 4445',3600.00,0.00,0.00,5.00,345.00,'2023-02-27 11:04:53','',''),(4579,'1','310','1',1,'Retail Sale Id 4446',4320.00,0.00,0.00,6.00,414.00,'2023-02-27 11:06:19','',''),(4580,'1','310','1',1,'Retail Sale Id 4447',2160.00,0.00,0.00,3.00,207.00,'2023-02-27 11:15:21','',''),(4581,'1','310','1',1,'Retail Sale Id 4448',5997.60,0.00,0.00,8.33,574.77,'2023-02-27 11:16:21','',''),(4582,'1','310','1',1,'Retail Sale Id 4449',4320.00,0.00,0.00,6.00,414.00,'2023-02-27 11:19:29','',''),(4583,'1','310','1',1,'Retail Sale Id 4450',4320.00,0.00,0.00,6.00,414.00,'2023-02-27 11:20:24','',''),(4584,'1','310','1',1,'Retail Sale Id 4451',4996.80,0.00,0.00,6.94,478.86,'2023-02-27 11:22:12','',''),(4585,'1','310','1',1,'Retail Sale Id 4452',4320.00,0.00,0.00,6.00,414.00,'2023-02-27 11:25:34','',''),(4586,'1','310','1',1,'Retail Sale Id 4453',9000.00,0.00,0.00,12.50,862.50,'2023-02-27 11:28:32','',''),(4587,'1','310','1',1,'Retail Sale Id 4454',3700.80,0.00,0.00,5.14,354.66,'2023-02-27 11:29:29','',''),(4588,'1','310','1',1,'Retail Sale Id 4455',105000.00,0.00,0.00,150.00,7350.00,'2023-02-27 11:45:12','',''),(4589,'1','310','1',1,'Retail Sale Id 4456',1202.40,0.00,0.00,1.67,115.23,'2023-02-27 11:48:02','',''),(4590,'1','310','1',1,'Retail Sale Id 4457',4320.00,0.00,0.00,6.00,414.00,'2023-02-27 11:58:18','',''),(4591,'1','310','1',1,'Retail Sale Id 4458',3002.40,0.00,0.00,4.17,287.73,'2023-02-27 12:01:04','',''),(4592,'1','310','1',1,'Retail Sale Id 4459',9000.00,0.00,0.00,12.50,862.50,'2023-02-27 12:03:45','',''),(4593,'1','310','1',1,'Retail Sale Id 4459',9000.00,0.00,0.00,12.50,862.50,'2023-02-27 12:03:45','',''),(4594,'1','310','1',1,'Retail Sale Id 4460',9000.00,0.00,0.00,12.50,862.50,'2023-02-27 12:05:12','',''),(4595,'1','310','1',1,'Retail Sale Id 4461',1440.00,0.00,0.00,2.00,138.00,'2023-02-27 12:06:14','',''),(4596,'1','310','1',1,'Retail Sale Id 4462',2002.00,0.00,0.00,2.86,140.14,'2023-02-27 12:11:28','',''),(4597,'1','310','1',1,'Retail Sale Id 4463',2160.00,0.00,0.00,3.00,207.00,'2023-02-27 12:16:28','',''),(4598,'1','310','1',1,'Retail Sale Id 4464',720.00,0.00,0.00,1.00,69.00,'2023-02-27 12:35:24','',''),(4599,'1','310','1',1,'Retail Sale Id 4465',3600.00,0.00,0.00,5.00,345.00,'2023-02-27 12:42:05','',''),(4600,'1','310','1',1,'Retail Sale Id 4466',9000.00,0.00,0.00,12.50,862.50,'2023-02-27 12:43:48','',''),(4601,'1','310','1',1,'Retail Sale Id 4466',9000.00,0.00,0.00,12.50,862.50,'2023-02-27 12:43:48','',''),(4602,'1','310','1',1,'Retail Sale Id 4467',2160.00,0.00,0.00,3.00,207.00,'2023-02-27 12:44:56','',''),(4603,'1','310','1',1,'Retail Sale Id 4468',2203.20,0.00,0.00,3.06,211.14,'2023-02-27 12:46:53','',''),(4604,'1','310','1',1,'Retail Sale Id 4469',3600.00,0.00,0.00,5.00,345.00,'2023-02-27 12:47:55','',''),(4605,'1','310','1',1,'Retail Sale Id 4470',4320.00,0.00,0.00,6.00,414.00,'2023-02-27 12:54:50','',''),(4606,'1','310','1',1,'Retail Sale Id 4471',3499.20,0.00,0.00,4.86,335.34,'2023-02-27 12:57:12','',''),(4607,'1','310','1',1,'Retail Sale Id 4472',1000.80,0.00,0.00,1.39,95.91,'2023-02-27 13:10:48','',''),(4608,'1','310','1',1,'Retail Sale Id 4473',2001.60,0.00,0.00,2.78,191.82,'2023-02-27 13:15:40','',''),(4609,'1','310','1',1,'Retail Sale Id 4474',4500.00,0.00,0.00,6.25,431.25,'2023-02-27 13:18:37','',''),(4610,'1','310','1',1,'Retail Sale Id 4475',1000.80,0.00,0.00,1.39,95.91,'2023-02-27 13:21:26','',''),(4611,'1','310','1',1,'Retail Sale Id 4477',2203.20,0.00,0.00,3.06,211.14,'2023-02-27 13:24:48','',''),(4612,'1','310','1',1,'Retail Sale Id 4477',2203.20,0.00,0.00,3.06,211.14,'2023-02-27 13:24:48','',''),(4613,'1','310','1',1,'Retail Sale Id 4478',2160.00,0.00,0.00,3.00,207.00,'2023-02-27 13:36:34','',''),(4614,'1','310','1',1,'Retail Sale Id 4479',9000.00,0.00,0.00,12.50,862.50,'2023-02-27 13:38:04','',''),(4615,'1','310','1',1,'Retail Sale Id 4480',9000.00,0.00,0.00,12.50,862.50,'2023-02-27 13:38:53','',''),(4616,'1','310','1',1,'Retail Sale Id 4481',3600.00,0.00,0.00,5.00,345.00,'2023-02-27 13:43:55','',''),(4617,'1','310','1',1,'Retail Sale Id 4482',9000.00,0.00,0.00,12.50,862.50,'2023-02-27 13:46:29','',''),(4618,'1','310','1',1,'Retail Sale Id 4483',35000.00,0.00,0.00,50.00,2450.00,'2023-02-27 13:55:18','',''),(4619,'1','310','1',1,'Retail Sale Id 4484',720.00,0.00,0.00,1.00,69.00,'2023-02-27 13:57:10','',''),(4620,'1','310','1',1,'Retail Sale Id 4485',11200.00,0.00,0.00,16.00,784.00,'2023-02-27 13:59:56','',''),(4621,'1','310','1',1,'Retail Sale Id 4486',720.00,0.00,0.00,1.00,69.00,'2023-02-27 14:02:59','',''),(4622,'1','310','1',1,'Retail Sale Id 4487',1000.80,0.00,0.00,1.39,95.91,'2023-02-27 14:10:07','',''),(4623,'1','310','1',1,'Retail Sale Id 4488',4320.00,0.00,0.00,6.00,414.00,'2023-02-27 14:15:07','',''),(4624,'1','310','1',1,'Retail Sale Id 4489',1800.00,0.00,0.00,2.50,172.50,'2023-02-27 14:17:19','',''),(4625,'1','310','1',1,'Retail Sale Id 4490',2160.00,0.00,0.00,3.00,207.00,'2023-02-27 14:21:51','',''),(4626,'1','310','1',1,'Retail Sale Id 4491',720.00,0.00,0.00,1.00,69.00,'2023-02-27 14:26:13','',''),(4627,'1','310','1',1,'Retail Sale Id 4492',1000.80,0.00,0.00,1.39,95.91,'2023-02-27 14:27:30','',''),(4628,'1','310','1',1,'Retail Sale Id 4493',3600.00,0.00,0.00,5.00,345.00,'2023-02-27 14:36:25','',''),(4629,'1','310','1',1,'Retail Sale Id 4494',2203.20,0.00,0.00,3.06,211.14,'2023-02-27 14:40:23','',''),(4630,'1','310','1',1,'Retail Sale Id 4495',9000.00,0.00,0.00,12.50,862.50,'2023-02-27 14:54:15','',''),(4631,'1','310','1',1,'Retail Sale Id 4496',4003.20,0.00,0.00,5.56,383.64,'2023-02-27 14:59:11','',''),(4632,'1','310','1',1,'Retail Sale Id 4497',9000.00,0.00,0.00,12.50,862.50,'2023-02-27 15:06:50','',''),(4633,'1','310','1',1,'Retail Sale Id 4497',9000.00,0.00,0.00,12.50,862.50,'2023-02-27 15:06:50','',''),(4634,'1','310','1',1,'Retail Sale Id 4498',2001.60,0.00,0.00,2.78,191.82,'2023-02-27 15:19:30','',''),(4635,'1','310','1',1,'Retail Sale Id 4499',4320.00,0.00,0.00,6.00,414.00,'2023-02-27 15:25:40','',''),(4636,'1','310','1',1,'Retail Sale Id 4501',5997.60,0.00,0.00,8.33,574.77,'2023-02-27 15:28:18','',''),(4637,'1','310','1',1,'Retail Sale Id 4502',2001.60,0.00,0.00,2.78,191.82,'2023-02-27 15:35:06','',''),(4638,'1','310','1',1,'Retail Sale Id 4503',720.00,0.00,0.00,1.00,69.00,'2023-02-27 15:45:20','',''),(4639,'1','310','1',1,'Retail Sale Id 4504',9000.00,0.00,0.00,12.50,862.50,'2023-02-27 15:54:33','',''),(4640,'1','310','1',1,'Retail Sale Id 4505',2880.00,0.00,0.00,4.00,276.00,'2023-02-27 15:56:38','',''),(4641,'1','310','1',1,'Retail Sale Id 4506',1497.60,0.00,0.00,2.08,143.52,'2023-02-27 16:01:23','',''),(4642,'1','310','1',1,'Retail Sale Id 4507',748.80,0.00,0.00,1.04,71.76,'2023-02-27 16:18:17','',''),(4643,'1','310','1',1,'Retail Sale Id 4508',9000.00,0.00,0.00,12.50,862.50,'2023-02-27 16:24:41','',''),(4644,'1','310','1',1,'Retail Sale Id 4509',4320.00,0.00,0.00,6.00,414.00,'2023-02-27 16:29:29','',''),(4645,'1','310','1',1,'Retail Sale Id 4510',4320.00,0.00,0.00,6.00,414.00,'2023-02-27 16:35:08','',''),(4646,'1','310','1',1,'Retail Sale Id 4511',3002.40,0.00,0.00,4.17,287.73,'2023-02-27 16:43:19','',''),(4647,'1','310','1',1,'Retail Sale Id 4512',4996.80,0.00,0.00,6.94,478.86,'2023-02-27 16:45:23','',''),(4648,'1','310','1',1,'Retail Sale Id 4513',597.60,0.00,0.00,0.83,57.27,'2023-02-27 16:46:29','',''),(4649,'1','310','1',1,'Retail Sale Id 4514',9000.00,0.00,0.00,12.50,862.50,'2023-02-27 16:52:49','',''),(4650,'1','310','1',1,'Retail Sale Id 4515',4320.00,0.00,0.00,6.00,414.00,'2023-02-27 16:54:56','',''),(4651,'1','310','1',1,'Retail Sale Id 4516',1000.80,0.00,0.00,1.39,95.91,'2023-02-27 16:58:41','',''),(4652,'1','310','1',1,'Retail Sale Id 4517',1000.80,0.00,0.00,1.39,95.91,'2023-02-27 17:03:21','',''),(4653,'1','310','1',1,'Retail Sale Id 4519',2001.60,0.00,0.00,2.78,191.82,'2023-02-27 17:13:14','',''),(4654,'1','310','1',1,'Retail Sale Id 4520',2203.20,0.00,0.00,3.06,211.14,'2023-02-27 17:20:15','',''),(4655,'1','310','1',1,'Retail Sale Id 4521',2160.00,0.00,0.00,3.00,207.00,'2023-02-27 17:50:18','',''),(4656,'1','310','1',1,'Retail Sale Id 4522',1000.80,0.00,0.00,1.39,95.91,'2023-02-27 17:51:27','',''),(4657,'1','310','1',1,'Retail Sale Id 4523',9000.00,0.00,0.00,12.50,862.50,'2023-02-27 17:52:42','',''),(4658,'1','310','1',1,'Retail Sale Id 4524',2160.00,0.00,0.00,3.00,207.00,'2023-02-27 17:53:31','',''),(4659,'1','310','1',1,'Retail Sale Id 4525',496.80,0.00,0.00,0.69,47.61,'2023-02-27 17:54:57','',''),(4660,'1','310','1',1,'Retail Sale Id 4525',496.80,0.00,0.00,0.69,47.61,'2023-02-27 17:54:57','',''),(4661,'1','310','1',1,'Retail Sale Id 4526',9000.00,0.00,0.00,12.50,862.50,'2023-02-27 18:01:44','',''),(4662,'1','310','1',1,'Retail Sale Id 4527',3002.40,0.00,0.00,4.17,287.73,'2023-02-27 18:03:26','',''),(4663,'1','310','1',1,'Retail Sale Id 4528',1497.60,0.00,0.00,2.08,143.52,'2023-02-27 18:11:07','',''),(4664,'1','310','1',1,'Retail Sale Id 4529',3600.00,0.00,0.00,5.00,345.00,'2023-02-27 18:12:16','',''),(4665,'1','310','1',1,'Retail Sale Id 4530',2160.00,0.00,0.00,3.00,207.00,'2023-02-27 18:19:02','',''),(4666,'1','310','1',1,'Retail Sale Id 4531',9000.00,0.00,0.00,12.50,862.50,'2023-02-27 18:20:50','',''),(4667,'1','310','1',1,'Retail Sale Id 4532',1000.80,0.00,0.00,1.39,95.91,'2023-02-27 18:22:43','',''),(4668,'1','310','1',1,'Retail Sale Id 4533',2001.60,0.00,0.00,2.78,191.82,'2023-02-27 18:25:39','',''),(4669,'1','310','1',1,'Retail Sale Id 4534',4003.20,0.00,0.00,5.56,383.64,'2023-02-27 18:27:11','',''),(4670,'1','310','1',1,'Return of Retail Sale Id 4531',0.00,9000.00,12.50,0.00,-862.50,'2023-02-27 18:40:56','',''),(4671,'1','310','1',1,'Return of Retail Sale Id 4529',0.00,3600.00,5.00,0.00,-345.00,'2023-02-27 18:41:38','',''),(4672,'1','310','1',1,'Return of Retail Sale Id 4534',0.00,4003.20,5.56,0.00,-383.64,'2023-02-27 18:42:21','',''),(4673,'1','310','1',1,'Retail Sale Id 4535',921.60,0.00,0.00,1.28,88.32,'2023-02-27 18:43:06','',''),(4674,'1','310','1',1,'Return of Retail Sale Id 4462',0.00,2002.00,2.86,0.00,-140.14,'2023-02-27 18:44:01','',''),(4675,'1','310','1',1,'Retail Sale Id 4536',2002.00,0.00,0.00,2.86,140.14,'2023-02-27 18:44:43','',''),(4676,'1','310','1',1,'Retail Sale Id 4537',4320.00,0.00,0.00,6.00,414.00,'2023-02-28 07:42:48','',''),(4677,'1','310','1',1,'Retail Sale Id 4538',1440.00,0.00,0.00,2.00,138.00,'2023-02-28 07:58:49','',''),(4678,'1','310','1',1,'Retail Sale Id 4539',2001.60,0.00,0.00,2.78,191.82,'2023-02-28 08:00:17','',''),(4679,'1','310','1',1,'Retail Sale Id 4540',2160.00,0.00,0.00,3.00,207.00,'2023-02-28 08:01:42','',''),(4680,'1','310','1',1,'Retail Sale Id 4541',3002.40,0.00,0.00,4.17,287.73,'2023-02-28 08:16:43','',''),(4681,'1','310','1',1,'Retail Sale Id 4542',2001.60,0.00,0.00,2.78,191.82,'2023-02-28 08:18:20','',''),(4682,'1','310','1',1,'Retail Sale Id 4542',3002.40,0.00,0.00,4.17,287.73,'2023-02-28 08:18:20','',''),(4683,'1','310','1',1,'Retail Sale Id 4543',4996.80,0.00,0.00,6.94,478.86,'2023-02-28 08:19:53','',''),(4684,'1','310','1',1,'Retail Sale Id 4544',1202.40,0.00,0.00,1.67,115.23,'2023-02-28 08:35:19','',''),(4685,'1','310','1',1,'Retail Sale Id 4545',4320.00,0.00,0.00,6.00,414.00,'2023-02-28 08:45:15','',''),(4686,'1','310','1',1,'Retail Sale Id 4546',3002.40,0.00,0.00,4.17,287.73,'2023-02-28 08:46:18','',''),(4687,'1','310','1',1,'Retail Sale Id 4547',4320.00,0.00,0.00,6.00,414.00,'2023-02-28 08:57:15','',''),(4688,'1','310','1',1,'Retail Sale Id 4548',8640.00,0.00,0.00,12.00,828.00,'2023-02-28 09:01:23','',''),(4689,'1','310','1',1,'Retail Sale Id 4549',5997.60,0.00,0.00,8.33,574.77,'2023-02-28 09:04:28','',''),(4690,'1','310','1',1,'Retail Sale Id 4550',2160.00,0.00,0.00,3.00,207.00,'2023-02-28 09:20:24','',''),(4691,'1','310','1',1,'Retail Sale Id 4551',2160.00,0.00,0.00,3.00,207.00,'2023-02-28 09:21:57','',''),(4692,'1','310','1',1,'Retail Sale Id 4552',4320.00,0.00,0.00,6.00,414.00,'2023-02-28 09:33:43','',''),(4693,'1','310','1',1,'Retail Sale Id 4553',9000.00,0.00,0.00,12.50,862.50,'2023-02-28 09:34:46','',''),(4694,'1','310','1',1,'Retail Sale Id 4554',2880.00,0.00,0.00,4.00,276.00,'2023-02-28 09:46:11','',''),(4695,'1','310','1',1,'Retail Sale Id 4555',3002.40,0.00,0.00,4.17,287.73,'2023-02-28 09:51:32','',''),(4696,'1','310','1',1,'Retail Sale Id 4556',4320.00,0.00,0.00,6.00,414.00,'2023-02-28 09:57:56','',''),(4697,'1','310','1',1,'Retail Sale Id 4556',4320.00,0.00,0.00,6.00,414.00,'2023-02-28 09:57:56','',''),(4698,'1','310','1',1,'Retail Sale Id 4556',4320.00,0.00,0.00,6.00,414.00,'2023-02-28 09:57:56','',''),(4699,'1','310','1',1,'Retail Sale Id 4557',2160.00,0.00,0.00,3.00,207.00,'2023-02-28 10:11:43','',''),(4700,'1','310','1',1,'Retail Sale Id 4558',9000.00,0.00,0.00,12.50,862.50,'2023-02-28 10:21:58','',''),(4701,'1','310','1',1,'Retail Sale Id 4559',3600.00,0.00,0.00,5.00,345.00,'2023-02-28 10:22:52','',''),(4702,'1','310','1',1,'Retail Sale Id 4560',35000.00,0.00,0.00,50.00,2450.00,'2023-02-28 10:38:18','',''),(4703,'1','310','1',1,'Retail Sale Id 4561',4320.00,0.00,0.00,6.00,414.00,'2023-02-28 10:45:15','',''),(4704,'1','310','1',1,'Retail Sale Id 4562',523600.00,0.00,0.00,748.00,36652.00,'2023-02-28 10:47:15','',''),(4705,'1','310','1',1,'Retail Sale Id 4563',4320.00,0.00,0.00,6.00,414.00,'2023-02-28 11:04:00','',''),(4706,'1','310','1',1,'Retail Sale Id 4564',2498.40,0.00,0.00,3.47,239.43,'2023-02-28 11:06:19','',''),(4707,'1','310','1',1,'Retail Sale Id 4565',3500.00,0.00,0.00,5.00,245.00,'2023-02-28 11:10:33','',''),(4708,'1','310','1',1,'Retail Sale Id 4566',1440.00,0.00,0.00,2.00,138.00,'2023-02-28 11:16:41','',''),(4709,'1','310','1',1,'Retail Sale Id 4566',9000.00,0.00,0.00,12.50,862.50,'2023-02-28 11:16:41','',''),(4710,'1','310','1',1,'Retail Sale Id 4567',2397.60,0.00,0.00,3.33,229.77,'2023-02-28 11:17:53','',''),(4711,'1','310','1',1,'Retail Sale Id 4568',4320.00,0.00,0.00,6.00,414.00,'2023-02-28 11:20:11','',''),(4712,'1','310','1',1,'Retail Sale Id 4569',4320.00,0.00,0.00,6.00,414.00,'2023-02-28 11:22:07','',''),(4713,'1','310','1',1,'Retail Sale Id 4570',7200.00,0.00,0.00,10.00,690.00,'2023-02-28 11:33:15','',''),(4714,'1','310','1',1,'Retail Sale Id 4571',9000.00,0.00,0.00,12.50,862.50,'2023-02-28 11:35:04','',''),(4715,'1','310','1',1,'Retail Sale Id 4572',9000.00,0.00,0.00,12.50,862.50,'2023-02-28 11:36:30','',''),(4716,'1','310','1',1,'Retail Sale Id 4573',496.80,0.00,0.00,0.69,47.61,'2023-02-28 11:40:07','',''),(4717,'1','310','1',1,'Retail Sale Id 4574',1000.80,0.00,0.00,1.39,95.91,'2023-02-28 11:59:44','',''),(4718,'1','310','1',1,'Retail Sale Id 4575',105000.00,0.00,0.00,150.00,7350.00,'2023-02-28 12:05:56','',''),(4719,'1','310','1',1,'Retail Sale Id 4576',2880.00,0.00,0.00,4.00,276.00,'2023-02-28 12:07:00','',''),(4720,'1','310','1',1,'Retail Sale Id 4577',7200.00,0.00,0.00,10.00,690.00,'2023-02-28 12:09:31','',''),(4721,'1','310','1',1,'Retail Sale Id 4578',35000.00,0.00,0.00,50.00,2450.00,'2023-02-28 12:11:57','',''),(4722,'1','310','1',1,'Retail Sale Id 4579',3002.40,0.00,0.00,4.17,287.73,'2023-02-28 12:26:07','',''),(4723,'1','310','1',1,'Retail Sale Id 4580',4320.00,0.00,0.00,6.00,414.00,'2023-02-28 12:30:12','',''),(4724,'1','310','1',1,'Retail Sale Id 4581',4320.00,0.00,0.00,6.00,414.00,'2023-02-28 12:36:14','',''),(4725,'1','310','1',1,'Retail Sale Id 4582',1000.80,0.00,0.00,1.39,95.91,'2023-02-28 12:46:00','',''),(4726,'1','310','1',1,'Retail Sale Id 4583',496.80,0.00,0.00,0.69,47.61,'2023-02-28 12:52:52','',''),(4727,'1','310','1',1,'Retail Sale Id 4584',4996.80,0.00,0.00,6.94,478.86,'2023-02-28 12:53:46','',''),(4728,'1','310','1',1,'Retail Sale Id 4585',2160.00,0.00,0.00,3.00,207.00,'2023-02-28 12:55:38','',''),(4729,'1','310','1',1,'Retail Sale Id 4585',2160.00,0.00,0.00,3.00,207.00,'2023-02-28 12:55:38','',''),(4730,'1','310','1',1,'Retail Sale Id 4586',9000.00,0.00,0.00,12.50,862.50,'2023-02-28 12:56:45','',''),(4731,'1','310','1',1,'Retail Sale Id 4587',2160.00,0.00,0.00,3.00,207.00,'2023-02-28 13:20:35','',''),(4732,'1','310','1',1,'Retail Sale Id 4588',2880.00,0.00,0.00,4.00,276.00,'2023-02-28 13:21:42','',''),(4733,'1','310','1',1,'Retail Sale Id 4589',2001.60,0.00,0.00,2.78,191.82,'2023-02-28 13:30:18','',''),(4734,'1','310','1',1,'Retail Sale Id 4589',2001.60,0.00,0.00,2.78,191.82,'2023-02-28 13:30:18','',''),(4735,'1','310','1',1,'Retail Sale Id 4590',1000.80,0.00,0.00,1.39,95.91,'2023-02-28 13:34:18','',''),(4736,'1','310','1',1,'Retail Sale Id 4591',9000.00,0.00,0.00,12.50,862.50,'2023-02-28 13:46:17','',''),(4737,'1','310','1',1,'Retail Sale Id 4592',2160.00,0.00,0.00,3.00,207.00,'2023-02-28 13:55:31','',''),(4738,'1','310','1',1,'Retail Sale Id 4593',4003.20,0.00,0.00,5.56,383.64,'2023-02-28 14:00:44','',''),(4739,'1','310','1',1,'Retail Sale Id 4594',9000.00,0.00,0.00,12.50,862.50,'2023-02-28 14:06:18','',''),(4740,'1','310','1',1,'Retail Sale Id 4594',9000.00,0.00,0.00,12.50,862.50,'2023-02-28 14:06:18','',''),(4741,'1','310','1',1,'Retail Sale Id 4595',2160.00,0.00,0.00,3.00,207.00,'2023-02-28 14:13:12','',''),(4742,'1','310','1',1,'Retail Sale Id 4596',2203.20,0.00,0.00,3.06,211.14,'2023-02-28 14:27:19','',''),(4743,'1','310','1',1,'Retail Sale Id 4597',9000.00,0.00,0.00,12.50,862.50,'2023-02-28 14:28:02','',''),(4744,'1','310','1',1,'Retail Sale Id 4598',9000.00,0.00,0.00,12.50,862.50,'2023-02-28 14:34:31','',''),(4745,'1','310','1',1,'Retail Sale Id 4599',2160.00,0.00,0.00,3.00,207.00,'2023-02-28 14:36:46','',''),(4746,'1','310','1',1,'Retail Sale Id 4600',1800.00,0.00,0.00,2.50,172.50,'2023-02-28 14:50:21','',''),(4747,'1','310','1',1,'Retail Sale Id 4601',3002.40,0.00,0.00,4.17,287.73,'2023-02-28 14:56:19','',''),(4748,'1','310','1',1,'Retail Sale Id 4602',7200.00,0.00,0.00,10.00,690.00,'2023-02-28 15:17:34','',''),(4749,'1','310','1',1,'Retail Sale Id 4603',2001.60,0.00,0.00,2.78,191.82,'2023-02-28 15:23:14','',''),(4750,'1','310','1',1,'Retail Sale Id 4604',2160.00,0.00,0.00,3.00,207.00,'2023-02-28 15:27:15','',''),(4751,'1','310','1',1,'Retail Sale Id 4605',2001.60,0.00,0.00,2.78,191.82,'2023-02-28 15:28:45','',''),(4752,'1','310','1',1,'Retail Sale Id 4606',2001.60,0.00,0.00,2.78,191.82,'2023-02-28 15:40:09','',''),(4753,'1','310','1',1,'Retail Sale Id 4606',4320.00,0.00,0.00,6.00,414.00,'2023-02-28 15:40:09','',''),(4754,'1','310','1',1,'Retail Sale Id 4607',1497.60,0.00,0.00,2.08,143.52,'2023-02-28 15:48:48','',''),(4755,'1','310','1',1,'Retail Sale Id 4608',2160.00,0.00,0.00,3.00,207.00,'2023-02-28 15:49:55','',''),(4756,'1','310','1',1,'Retail Sale Id 4609',9000.00,0.00,0.00,12.50,862.50,'2023-02-28 15:52:36','',''),(4757,'1','310','1',1,'Retail Sale Id 4610',2001.60,0.00,0.00,2.78,191.82,'2023-02-28 16:12:17','',''),(4758,'1','310','1',1,'Retail Sale Id 4611',496.80,0.00,0.00,0.69,47.61,'2023-02-28 16:15:29','',''),(4759,'1','310','1',1,'Retail Sale Id 4612',2203.20,0.00,0.00,3.06,211.14,'2023-02-28 16:17:24','',''),(4760,'1','310','1',1,'Retail Sale Id 4613',7999.20,0.00,0.00,11.11,766.59,'2023-02-28 16:19:13','',''),(4761,'1','310','1',1,'Retail Sale Id 4615',4320.00,0.00,0.00,6.00,414.00,'2023-02-28 16:30:08','',''),(4762,'1','310','1',1,'Retail Sale Id 4616',5040.00,0.00,0.00,7.00,483.00,'2023-02-28 16:32:48','',''),(4763,'1','310','1',1,'Retail Sale Id 4617',5047.20,0.00,0.00,7.01,483.69,'2023-02-28 16:38:39','',''),(4764,'1','310','1',1,'Retail Sale Id 4618',9000.00,0.00,0.00,12.50,862.50,'2023-02-28 16:40:09','',''),(4765,'1','310','1',1,'Retail Sale Id 4619',2160.00,0.00,0.00,3.00,207.00,'2023-02-28 16:41:54','',''),(4766,'1','310','1',1,'Retail Sale Id 4619',9000.00,0.00,0.00,12.50,862.50,'2023-02-28 16:41:54','',''),(4767,'1','310','1',1,'Retail Sale Id 4620',3002.40,0.00,0.00,4.17,287.73,'2023-02-28 16:50:01','',''),(4768,'1','310','1',1,'Retail Sale Id 4621',2001.60,0.00,0.00,2.78,191.82,'2023-02-28 16:55:06','',''),(4769,'1','310','1',1,'Retail Sale Id 4622',2001.60,0.00,0.00,2.78,191.82,'2023-02-28 16:58:51','',''),(4770,'1','310','1',1,'Retail Sale Id 4623',496.80,0.00,0.00,0.69,47.61,'2023-02-28 17:02:27','',''),(4771,'1','310','1',1,'Retail Sale Id 4624',1000.80,0.00,0.00,1.39,95.91,'2023-02-28 17:04:02','',''),(4772,'1','310','1',1,'Retail Sale Id 4625',4320.00,0.00,0.00,6.00,414.00,'2023-02-28 17:08:16','',''),(4773,'1','310','1',1,'Retail Sale Id 4626',9000.00,0.00,0.00,12.50,862.50,'2023-02-28 17:09:39','',''),(4774,'1','310','1',1,'Retail Sale Id 4627',3600.00,0.00,0.00,5.00,345.00,'2023-02-28 17:13:51','',''),(4775,'1','310','1',1,'Retail Sale Id 4628',1440.00,0.00,0.00,2.00,138.00,'2023-02-28 17:14:42','',''),(4776,'1','310','1',1,'Retail Sale Id 4630',4399.20,0.00,0.00,6.11,421.59,'2023-02-28 17:16:42','',''),(4777,'1','310','1',1,'Retail Sale Id 4632',2002.00,0.00,0.00,2.86,140.14,'2023-02-28 17:25:18','',''),(4778,'1','310','1',1,'Retail Sale Id 4633',2160.00,0.00,0.00,3.00,207.00,'2023-02-28 17:29:23','',''),(4779,'1','310','1',1,'Retail Sale Id 4634',2001.60,0.00,0.00,2.78,191.82,'2023-02-28 17:30:37','',''),(4780,'1','310','1',1,'Retail Sale Id 4635',7200.00,0.00,0.00,10.00,690.00,'2023-02-28 17:31:40','',''),(4781,'1','310','1',1,'Retail Sale Id 4636',2160.00,0.00,0.00,3.00,207.00,'2023-02-28 17:32:29','',''),(4782,'1','310','1',1,'Retail Sale Id 4637',2203.20,0.00,0.00,3.06,211.14,'2023-02-28 17:33:25','',''),(4783,'1','310','1',1,'Retail Sale Id 4638',4320.00,0.00,0.00,6.00,414.00,'2023-02-28 17:34:41','',''),(4784,'1','310','1',1,'Retail Sale Id 4639',105000.00,0.00,0.00,150.00,7350.00,'2023-02-28 17:35:52','',''),(4785,'1','310','1',1,'Retail Sale Id 4640',3002.40,0.00,0.00,4.17,287.73,'2023-02-28 17:37:09','',''),(4786,'1','310','1',1,'Retail Sale Id 4641',4320.00,0.00,0.00,6.00,414.00,'2023-02-28 17:38:08','',''),(4787,'1','310','1',1,'Retail Sale Id 4642',2100.00,0.00,0.00,3.00,147.00,'2023-02-28 17:40:10','',''),(4788,'1','310','1',1,'Retail Sale Id 4643',35000.00,0.00,0.00,50.00,2450.00,'2023-02-28 17:41:32','',''),(4789,'1','310','1',1,'Retail Sale Id 4644',1000.80,0.00,0.00,1.39,95.91,'2023-02-28 17:44:26','',''),(4790,'1','310','1',1,'Retail Sale Id 4645',9000.00,0.00,0.00,12.50,862.50,'2023-02-28 17:50:04','',''),(4791,'1','310','1',1,'Retail Sale Id 4646',4996.80,0.00,0.00,6.94,478.86,'2023-02-28 17:52:43','',''),(4792,'1','310','1',1,'Retail Sale Id 4647',9000.00,0.00,0.00,12.50,862.50,'2023-02-28 17:54:02','',''),(4793,'1','310','1',1,'Retail Sale Id 4648',22001.00,0.00,0.00,31.43,1540.07,'2023-02-28 17:55:08','',''),(4794,'1','310','1',1,'Retail Sale Id 4649',1497.60,0.00,0.00,2.08,143.52,'2023-02-28 17:56:12','',''),(4795,'1','310','1',1,'Retail Sale Id 4650',1440.00,0.00,0.00,2.00,138.00,'2023-02-28 17:58:39','',''),(4796,'1','310','1',1,'Retail Sale Id 4651',2001.60,0.00,0.00,2.78,191.82,'2023-02-28 18:00:30','',''),(4797,'1','310','1',1,'Retail Sale Id 4652',7200.00,0.00,0.00,10.00,690.00,'2023-02-28 18:01:37','',''),(4798,'1','310','1',1,'Retail Sale Id 4653',4320.00,0.00,0.00,6.00,414.00,'2023-02-28 18:02:57','',''),(4799,'1','310','1',1,'Retail Sale Id 4654',4320.00,0.00,0.00,6.00,414.00,'2023-02-28 18:03:50','',''),(4800,'1','310','1',1,'Retail Sale Id 4655',1440.00,0.00,0.00,2.00,138.00,'2023-02-28 18:06:34','',''),(4801,'1','310','1',1,'Retail Sale Id 4658',4320.00,0.00,0.00,6.00,414.00,'2023-02-28 18:08:24','',''),(4802,'1','310','1',1,'Retail Sale Id 4659',2160.00,0.00,0.00,3.00,207.00,'2023-02-28 18:11:58','',''),(4803,'1','310','1',1,'Retail Sale Id 4660',496.80,0.00,0.00,0.69,47.61,'2023-02-28 18:16:45','',''),(4804,'1','310','1',1,'Retail Sale Id 4661',2001.60,0.00,0.00,2.78,191.82,'2023-02-28 18:19:13','',''),(4805,'1','310','1',1,'Retail Sale Id 4662',50.40,0.00,0.00,0.07,4.83,'2023-02-28 18:38:45','',''),(4806,'1','310','1',1,'Return of Retail Sale Id 4642',0.00,2100.00,3.00,0.00,-147.00,'2023-02-28 18:40:46','',''),(4807,'1','310','1',1,'Retail Sale Id 4663',2100.00,0.00,0.00,3.00,147.00,'2023-02-28 18:41:39','',''),(4808,'1','310','1',1,'Retail Sale Id 4664',4320.00,0.00,0.00,6.00,414.00,'2023-02-28 19:00:58','',''),(4809,'1','310','1',1,'Return of Retail Sale Id 4663',0.00,2100.00,3.00,0.00,-147.00,'2023-02-28 19:04:16','',''),(4810,'1','310','1',1,'Retail Sale Id 4665',2044.00,0.00,0.00,2.92,143.08,'2023-02-28 19:04:52','',''),(4811,'1','310','1',1,'Retail Sale Id 4666',1497.60,0.00,0.00,2.08,143.52,'2023-03-01 07:06:13','',''),(4812,'1','310','1',1,'Retail Sale Id 4667',42000.00,0.00,0.00,60.00,2940.00,'2023-03-01 07:24:27','',''),(4813,'1','310','1',1,'Retail Sale Id 4668',5997.60,0.00,0.00,8.33,574.77,'2023-03-01 07:26:46','',''),(4814,'1','310','1',1,'Retail Sale Id 4669',2001.60,0.00,0.00,2.78,191.82,'2023-03-01 07:34:11','',''),(4815,'1','310','1',1,'Retail Sale Id 4670',1000.80,0.00,0.00,1.39,95.91,'2023-03-01 08:12:31','',''),(4816,'1','310','1',1,'Retail Sale Id 4671',2160.00,0.00,0.00,3.00,207.00,'2023-03-01 08:14:35','',''),(4817,'1','310','1',1,'Retail Sale Id 4672',3002.40,0.00,0.00,4.17,287.73,'2023-03-01 08:23:24','',''),(4818,'1','310','1',1,'Retail Sale Id 4673',4320.00,0.00,0.00,6.00,414.00,'2023-03-01 08:27:07','',''),(4819,'1','310','1',1,'Retail Sale Id 4674',1000.80,0.00,0.00,1.39,95.91,'2023-03-01 08:38:59','',''),(4820,'1','310','1',1,'Retail Sale Id 4675',2001.60,0.00,0.00,2.78,191.82,'2023-03-01 08:53:17','',''),(4821,'1','310','1',1,'Retail Sale Id 4676',2001.60,0.00,0.00,2.78,191.82,'2023-03-01 09:13:10','',''),(4822,'1','310','1',1,'Retail Sale Id 4677',2160.00,0.00,0.00,3.00,207.00,'2023-03-01 09:17:59','',''),(4823,'1','310','1',1,'Retail Sale Id 4677',2160.00,0.00,0.00,3.00,207.00,'2023-03-01 09:17:59','',''),(4824,'1','310','1',1,'Retail Sale Id 4678',2203.20,0.00,0.00,3.06,211.14,'2023-03-01 09:21:25','',''),(4825,'1','310','1',1,'Retail Sale Id 4679',4996.80,0.00,0.00,6.94,478.86,'2023-03-01 09:32:00','',''),(4826,'1','310','1',1,'Retail Sale Id 4680',35000.00,0.00,0.00,50.00,2450.00,'2023-03-01 09:36:37','',''),(4827,'1','310','1',1,'Retail Sale Id 4681',4320.00,0.00,0.00,6.00,414.00,'2023-03-01 09:43:07','',''),(4828,'1','310','1',1,'Retail Sale Id 4682',1000.80,0.00,0.00,1.39,95.91,'2023-03-01 09:45:02','',''),(4829,'1','310','1',1,'Retail Sale Id 4683',5040.00,0.00,0.00,7.00,483.00,'2023-03-01 10:00:42','',''),(4830,'1','310','1',1,'Retail Sale Id 4684',35000.00,0.00,0.00,50.00,2450.00,'2023-03-01 10:17:15','',''),(4831,'1','310','1',1,'Retail Sale Id 4685',4320.00,0.00,0.00,6.00,414.00,'2023-03-01 10:22:08','',''),(4832,'1','310','1',1,'Retail Sale Id 4686',1000.80,0.00,0.00,1.39,95.91,'2023-03-01 10:25:15','',''),(4833,'1','310','1',1,'Retail Sale Id 4687',720.00,0.00,0.00,1.00,69.00,'2023-03-01 10:29:02','',''),(4834,'1','310','1',1,'Retail Sale Id 4688',4320.00,0.00,0.00,6.00,414.00,'2023-03-01 10:57:09','',''),(4835,'1','310','1',1,'Retail Sale Id 4689',1000.80,0.00,0.00,1.39,95.91,'2023-03-01 10:58:54','',''),(4836,'1','310','1',1,'Retail Sale Id 4690',4003.20,0.00,0.00,5.56,383.64,'2023-03-01 11:01:58','',''),(4837,'1','310','1',1,'Retail Sale Id 4691',1497.60,0.00,0.00,2.08,143.52,'2023-03-01 11:15:54','',''),(4838,'1','310','1',1,'Retail Sale Id 4692',1000.80,0.00,0.00,1.39,95.91,'2023-03-01 11:18:32','',''),(4839,'1','310','1',1,'Retail Sale Id 4693',720.00,0.00,0.00,1.00,69.00,'2023-03-01 11:19:25','',''),(4840,'1','310','1',1,'Retail Sale Id 4694',1440.00,0.00,0.00,2.00,138.00,'2023-03-01 11:24:34','',''),(4841,'1','310','1',1,'Retail Sale Id 4696',4320.00,0.00,0.00,6.00,414.00,'2023-03-01 11:26:46','',''),(4842,'1','310','1',1,'Retail Sale Id 4697',4320.00,0.00,0.00,6.00,414.00,'2023-03-01 11:27:47','',''),(4843,'1','310','1',1,'Retail Sale Id 4698',1497.60,0.00,0.00,2.08,143.52,'2023-03-01 11:29:19','',''),(4844,'1','310','1',1,'Retail Sale Id 4698',2160.00,0.00,0.00,3.00,207.00,'2023-03-01 11:29:19','',''),(4845,'1','310','1',1,'Retail Sale Id 4699',9000.00,0.00,0.00,12.50,862.50,'2023-03-01 11:31:50','',''),(4846,'1','310','1',1,'Retail Sale Id 4700',6480.00,0.00,0.00,9.00,621.00,'2023-03-01 11:39:49','',''),(4847,'1','310','1',1,'Retail Sale Id 4701',4320.00,0.00,0.00,6.00,414.00,'2023-03-01 11:44:59','',''),(4848,'1','310','1',1,'Retail Sale Id 4702',2001.60,0.00,0.00,2.78,191.82,'2023-03-01 11:46:32','',''),(4849,'1','310','1',1,'Retail Sale Id 4703',3002.40,0.00,0.00,4.17,287.73,'2023-03-01 11:47:40','',''),(4850,'1','310','1',1,'Retail Sale Id 4704',720.00,0.00,0.00,1.00,69.00,'2023-03-01 12:01:20','',''),(4851,'1','310','1',1,'Retail Sale Id 4706',4003.20,0.00,0.00,5.56,383.64,'2023-03-01 12:04:35','',''),(4852,'1','310','1',1,'Retail Sale Id 4707',4320.00,0.00,0.00,6.00,414.00,'2023-03-01 12:08:12','',''),(4853,'1','310','1',1,'Retail Sale Id 4707',4320.00,0.00,0.00,6.00,414.00,'2023-03-01 12:08:12','',''),(4854,'1','310','1',1,'Retail Sale Id 4707',4320.00,0.00,0.00,6.00,414.00,'2023-03-01 12:08:12','',''),(4855,'1','310','1',1,'Retail Sale Id 4708',4320.00,0.00,0.00,6.00,414.00,'2023-03-01 12:09:13','',''),(4856,'1','310','1',1,'Retail Sale Id 4709',2001.60,0.00,0.00,2.78,191.82,'2023-03-01 12:10:15','',''),(4857,'1','310','1',1,'Retail Sale Id 4710',3002.40,0.00,0.00,4.17,287.73,'2023-03-01 12:14:07','',''),(4858,'1','310','1',1,'Retail Sale Id 4711',799.20,0.00,0.00,1.11,76.59,'2023-03-01 12:15:05','',''),(4859,'1','310','1',1,'Retail Sale Id 4712',4320.00,0.00,0.00,6.00,414.00,'2023-03-01 12:23:43','',''),(4860,'1','310','1',1,'Retail Sale Id 4713',403.20,0.00,0.00,0.56,38.64,'2023-03-01 12:32:14','',''),(4861,'1','310','1',1,'Retail Sale Id 4714',496.80,0.00,0.00,0.69,47.61,'2023-03-01 12:33:50','',''),(4862,'1','310','1',1,'Retail Sale Id 4717',2001.60,0.00,0.00,2.78,191.82,'2023-03-01 12:40:58','',''),(4863,'1','310','1',1,'Retail Sale Id 4718',4320.00,0.00,0.00,6.00,414.00,'2023-03-01 12:43:07','',''),(4864,'1','310','1',1,'Retail Sale Id 4719',3002.40,0.00,0.00,4.17,287.73,'2023-03-01 12:44:27','',''),(4865,'1','310','1',1,'Retail Sale Id 4720',35000.00,0.00,0.00,50.00,2450.00,'2023-03-01 12:45:33','',''),(4866,'1','310','1',1,'Retail Sale Id 4721',1000.80,0.00,0.00,1.39,95.91,'2023-03-01 12:46:48','',''),(4867,'1','310','1',1,'Retail Sale Id 4722',1000.80,0.00,0.00,1.39,95.91,'2023-03-01 12:48:41','',''),(4868,'1','310','1',1,'Retail Sale Id 4723',1000.80,0.00,0.00,1.39,95.91,'2023-03-01 12:49:59','',''),(4869,'1','310','1',1,'Retail Sale Id 4724',3002.40,0.00,0.00,4.17,287.73,'2023-03-01 12:52:59','',''),(4870,'1','310','1',1,'Retail Sale Id 4725',3002.40,0.00,0.00,4.17,287.73,'2023-03-01 13:16:55','',''),(4871,'1','310','1',1,'Retail Sale Id 4727',2160.00,0.00,0.00,3.00,207.00,'2023-03-01 13:29:00','',''),(4872,'1','310','1',1,'Retail Sale Id 4728',4320.00,0.00,0.00,6.00,414.00,'2023-03-01 13:30:27','',''),(4873,'1','310','1',1,'Retail Sale Id 4729',4320.00,0.00,0.00,6.00,414.00,'2023-03-01 13:36:07','',''),(4874,'1','310','1',1,'Retail Sale Id 4730',2160.00,0.00,0.00,3.00,207.00,'2023-03-01 13:41:14','',''),(4875,'1','310','1',1,'Retail Sale Id 4731',1440.00,0.00,0.00,2.00,138.00,'2023-03-01 14:02:24','',''),(4876,'1','310','1',1,'Retail Sale Id 4732',2160.00,0.00,0.00,3.00,207.00,'2023-03-01 14:12:28','',''),(4877,'1','310','1',1,'Retail Sale Id 4732',9000.00,0.00,0.00,12.50,862.50,'2023-03-01 14:12:28','',''),(4878,'1','310','1',1,'Retail Sale Id 4733',9000.00,0.00,0.00,12.50,862.50,'2023-03-01 14:14:13','',''),(4879,'1','310','1',1,'Retail Sale Id 4734',3600.00,0.00,0.00,5.00,345.00,'2023-03-01 14:16:19','',''),(4880,'1','310','1',1,'Retail Sale Id 4735',496.80,0.00,0.00,0.69,47.61,'2023-03-01 14:18:20','',''),(4881,'1','310','1',1,'Retail Sale Id 4737',9000.00,0.00,0.00,12.50,862.50,'2023-03-01 14:26:16','',''),(4882,'1','310','1',1,'Retail Sale Id 4738',9000.00,0.00,0.00,12.50,862.50,'2023-03-01 14:37:58','',''),(4883,'1','310','1',1,'Retail Sale Id 4740',9000.00,0.00,0.00,12.50,862.50,'2023-03-01 14:42:13','',''),(4884,'1','310','1',1,'Retail Sale Id 4741',6998.40,0.00,0.00,9.72,670.68,'2023-03-01 15:02:58','',''),(4885,'1','310','1',1,'Retail Sale Id 4742',3500.00,0.00,0.00,5.00,245.00,'2023-03-01 15:16:00','',''),(4886,'1','310','1',1,'Retail Sale Id 4743',25550.00,0.00,0.00,36.50,1788.50,'2023-03-01 15:20:52','',''),(4887,'1','310','1',1,'Retail Sale Id 4744',9000.00,0.00,0.00,12.50,862.50,'2023-03-01 15:22:39','',''),(4888,'1','310','1',1,'Retail Sale Id 4745',4500.00,0.00,0.00,6.25,431.25,'2023-03-01 15:23:49','',''),(4889,'1','310','1',1,'Retail Sale Id 4746',2160.00,0.00,0.00,3.00,207.00,'2023-03-01 15:27:32','',''),(4890,'1','310','1',1,'Retail Sale Id 4747',105000.00,0.00,0.00,150.00,7350.00,'2023-03-01 15:30:27','',''),(4891,'1','310','1',1,'Retail Sale Id 4748',9000.00,0.00,0.00,12.50,862.50,'2023-03-01 15:33:22','',''),(4892,'1','310','1',1,'Retail Sale Id 4749',1000.80,0.00,0.00,1.39,95.91,'2023-03-01 15:37:27','',''),(4893,'1','310','1',1,'Retail Sale Id 4750',140000.00,0.00,0.00,200.00,9800.00,'2023-03-01 15:39:49','',''),(4894,'1','310','1',1,'Retail Sale Id 4751',8100.00,0.00,0.00,11.25,776.25,'2023-03-01 15:40:53','',''),(4895,'1','310','1',1,'Retail Sale Id 4752',7200.00,0.00,0.00,10.00,690.00,'2023-03-01 15:43:05','',''),(4896,'1','310','1',1,'Retail Sale Id 4754',4320.00,0.00,0.00,6.00,414.00,'2023-03-01 16:02:29','',''),(4897,'1','310','1',1,'Retail Sale Id 4755',2160.00,0.00,0.00,3.00,207.00,'2023-03-01 16:03:14','',''),(4898,'1','310','1',1,'Retail Sale Id 4756',2160.00,0.00,0.00,3.00,207.00,'2023-03-01 16:10:14','',''),(4899,'1','310','1',1,'Retail Sale Id 4757',7200.00,0.00,0.00,10.00,690.00,'2023-03-01 16:19:25','',''),(4900,'1','310','1',1,'Retail Sale Id 4758',2160.00,0.00,0.00,3.00,207.00,'2023-03-01 16:23:29','',''),(4901,'1','310','1',1,'Retail Sale Id 4759',4320.00,0.00,0.00,6.00,414.00,'2023-03-01 16:31:06','',''),(4902,'1','310','1',1,'Retail Sale Id 4760',3600.00,0.00,0.00,5.00,345.00,'2023-03-01 16:32:55','',''),(4903,'1','310','1',1,'Retail Sale Id 4761',1000.80,0.00,0.00,1.39,95.91,'2023-03-01 17:06:50','',''),(4904,'1','310','1',1,'Retail Sale Id 4762',2160.00,0.00,0.00,3.00,207.00,'2023-03-01 17:08:52','',''),(4905,'1','310','1',1,'Retail Sale Id 4763',1000.80,0.00,0.00,1.39,95.91,'2023-03-01 17:12:26','',''),(4906,'1','310','1',1,'Retail Sale Id 4764',3600.00,0.00,0.00,5.00,345.00,'2023-03-01 17:16:33','',''),(4907,'1','310','1',1,'Retail Sale Id 4765',9000.00,0.00,0.00,12.50,862.50,'2023-03-01 17:17:46','',''),(4908,'1','310','1',1,'Retail Sale Id 4766',3600.00,0.00,0.00,5.00,345.00,'2023-03-01 17:19:15','',''),(4909,'1','310','1',1,'Retail Sale Id 4767',1440.00,0.00,0.00,2.00,138.00,'2023-03-01 17:25:19','',''),(4910,'1','310','1',1,'Retail Sale Id 4768',4320.00,0.00,0.00,6.00,414.00,'2023-03-01 17:46:49','',''),(4911,'1','310','1',1,'Retail Sale Id 4769',1497.60,0.00,0.00,2.08,143.52,'2023-03-01 17:47:46','',''),(4912,'1','310','1',1,'Retail Sale Id 4770',9000.00,0.00,0.00,12.50,862.50,'2023-03-01 17:49:01','',''),(4913,'1','310','1',1,'Retail Sale Id 4771',9000.00,0.00,0.00,12.50,862.50,'2023-03-01 17:55:16','',''),(4914,'1','310','1',1,'Retail Sale Id 4772',1000.80,0.00,0.00,1.39,95.91,'2023-03-01 18:04:47','',''),(4915,'1','310','1',1,'Retail Sale Id 4773',70000.00,0.00,0.00,100.00,4900.00,'2023-03-01 18:12:13','',''),(4916,'1','310','1',1,'Retail Sale Id 4774',9000.00,0.00,0.00,12.50,862.50,'2023-03-01 18:13:21','',''),(4917,'1','310','1',1,'Retail Sale Id 4775',9000.00,0.00,0.00,12.50,862.50,'2023-03-01 18:16:29','',''),(4918,'1','310','1',1,'Retail Sale Id 4776',4320.00,0.00,0.00,6.00,414.00,'2023-03-01 18:18:06','',''),(4919,'1','310','1',1,'Retail Sale Id 4777',3600.00,0.00,0.00,5.00,345.00,'2023-03-01 18:29:02','',''),(4920,'1','310','1',1,'Return of Retail Sale Id 4775',0.00,9000.00,12.50,0.00,-862.50,'2023-03-01 18:42:22','',''),(4921,'1','310','1',1,'Return of Retail Sale Id 4770',0.00,9000.00,12.50,0.00,-862.50,'2023-03-01 18:42:57','',''),(4922,'1','310','1',1,'Retail Sale Id 4778',1792.80,0.00,0.00,2.49,171.81,'2023-03-01 18:43:37','',''),(4923,'1','310','1',1,'Return of Retail Sale Id 4742',0.00,3500.00,5.00,0.00,-245.00,'2023-03-01 18:44:43','',''),(4924,'1','310','1',1,'Retail Sale Id 4779',3150.00,0.00,0.00,4.50,220.50,'2023-03-01 18:45:41','',''),(4925,'1','310','1',1,'Retail Sale Id 4780',4003.20,0.00,0.00,5.56,383.64,'2023-03-02 07:34:16','',''),(4926,'1','310','1',1,'Retail Sale Id 4781',9000.00,0.00,0.00,12.50,862.50,'2023-03-02 07:35:35','',''),(4927,'1','310','1',1,'Retail Sale Id 4783',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 07:53:08','',''),(4928,'1','310','1',1,'Retail Sale Id 4784',3002.40,0.00,0.00,4.17,287.73,'2023-03-02 07:56:20','',''),(4929,'1','310','1',1,'Retail Sale Id 4785',3600.00,0.00,0.00,5.00,345.00,'2023-03-02 07:57:32','',''),(4930,'1','310','1',1,'Retail Sale Id 4785',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 07:57:32','',''),(4931,'1','310','1',1,'Retail Sale Id 4786',3600.00,0.00,0.00,5.00,345.00,'2023-03-02 07:58:59','',''),(4932,'1','310','1',1,'Retail Sale Id 4788',9000.00,0.00,0.00,12.50,862.50,'2023-03-02 08:25:26','',''),(4933,'1','310','1',1,'Retail Sale Id 4789',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 08:28:18','',''),(4934,'1','310','1',1,'Retail Sale Id 4791',2160.00,0.00,0.00,3.00,207.00,'2023-03-02 08:36:32','',''),(4935,'1','310','1',1,'Retail Sale Id 4792',315000.00,0.00,0.00,450.00,22050.00,'2023-03-02 08:43:59','',''),(4936,'1','310','1',1,'Retail Sale Id 4793',35000.00,0.00,0.00,50.00,2450.00,'2023-03-02 09:00:56','',''),(4937,'1','310','1',1,'Retail Sale Id 4795',70000.00,0.00,0.00,100.00,4900.00,'2023-03-02 09:15:49','',''),(4938,'1','310','1',1,'Retail Sale Id 4796',3002.40,0.00,0.00,4.17,287.73,'2023-03-02 09:16:34','',''),(4939,'1','310','1',1,'Retail Sale Id 4797',17500.00,0.00,0.00,25.00,1225.00,'2023-03-02 09:23:10','',''),(4940,'1','310','1',1,'Retail Sale Id 4798',2001.60,0.00,0.00,2.78,191.82,'2023-03-02 09:24:17','',''),(4941,'1','310','1',1,'Retail Sale Id 4799',2160.00,0.00,0.00,3.00,207.00,'2023-03-02 09:30:22','',''),(4942,'1','310','1',1,'Retail Sale Id 4800',2160.00,0.00,0.00,3.00,207.00,'2023-03-02 09:35:10','',''),(4943,'1','310','1',1,'Retail Sale Id 4801',3600.00,0.00,0.00,5.00,345.00,'2023-03-02 09:47:56','',''),(4944,'1','310','1',1,'Retail Sale Id 4801',10800.00,0.00,0.00,15.00,1035.00,'2023-03-02 09:47:56','',''),(4945,'1','310','1',1,'Retail Sale Id 4802',3600.00,0.00,0.00,5.00,345.00,'2023-03-02 09:50:26','',''),(4946,'1','310','1',1,'Retail Sale Id 4803',3600.00,0.00,0.00,5.00,345.00,'2023-03-02 09:51:41','',''),(4947,'1','310','1',1,'Retail Sale Id 4804',2880.00,0.00,0.00,4.00,276.00,'2023-03-02 09:52:50','',''),(4948,'1','310','1',1,'Retail Sale Id 4805',2160.00,0.00,0.00,3.00,207.00,'2023-03-02 09:54:57','',''),(4949,'1','310','1',1,'Retail Sale Id 4806',9000.00,0.00,0.00,12.50,862.50,'2023-03-02 09:57:39','',''),(4950,'1','310','1',1,'Retail Sale Id 4807',2160.00,0.00,0.00,3.00,207.00,'2023-03-02 10:01:38','',''),(4951,'1','310','1',1,'Retail Sale Id 4808',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 10:06:37','',''),(4952,'1','310','1',1,'Retail Sale Id 4809',4996.80,0.00,0.00,6.94,478.86,'2023-03-02 10:07:21','',''),(4953,'1','310','1',1,'Retail Sale Id 4810',2160.00,0.00,0.00,3.00,207.00,'2023-03-02 10:09:06','',''),(4954,'1','310','1',1,'Retail Sale Id 4811',9000.00,0.00,0.00,12.50,862.50,'2023-03-02 10:10:07','',''),(4955,'1','310','1',1,'Retail Sale Id 4812',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 10:15:00','',''),(4956,'1','310','1',1,'Retail Sale Id 4813',9000.00,0.00,0.00,12.50,862.50,'2023-03-02 10:15:36','',''),(4957,'1','310','1',1,'Retail Sale Id 4814',9800.00,0.00,0.00,14.00,686.00,'2023-03-02 10:28:42','',''),(4958,'1','310','1',1,'Retail Sale Id 4815',9000.00,0.00,0.00,12.50,862.50,'2023-03-02 10:31:38','',''),(4959,'1','310','1',1,'Retail Sale Id 4816',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 10:32:26','',''),(4960,'1','310','1',1,'Retail Sale Id 4817',2160.00,0.00,0.00,3.00,207.00,'2023-03-02 10:35:41','',''),(4961,'1','310','1',1,'Retail Sale Id 4818',77000.00,0.00,0.00,110.00,5390.00,'2023-03-02 10:37:48','',''),(4962,'1','310','1',1,'Retail Sale Id 4819',77000.00,0.00,0.00,110.00,5390.00,'2023-03-02 10:39:01','',''),(4963,'1','310','1',1,'Retail Sale Id 4820',175000.00,0.00,0.00,250.00,12250.00,'2023-03-02 10:40:13','',''),(4964,'1','310','1',1,'Retail Sale Id 4821',3002.40,0.00,0.00,4.17,287.73,'2023-03-02 10:41:08','',''),(4965,'1','310','1',1,'Retail Sale Id 4822',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 10:51:11','',''),(4966,'1','310','1',1,'Retail Sale Id 4822',9000.00,0.00,0.00,12.50,862.50,'2023-03-02 10:51:11','',''),(4967,'1','310','1',1,'Retail Sale Id 4824',2296.80,0.00,0.00,3.19,220.11,'2023-03-02 10:55:36','',''),(4968,'1','310','1',1,'Retail Sale Id 4825',9000.00,0.00,0.00,12.50,862.50,'2023-03-02 10:56:32','',''),(4969,'1','310','1',1,'Retail Sale Id 4826',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 11:05:20','',''),(4970,'1','310','1',1,'Retail Sale Id 4827',2160.00,0.00,0.00,3.00,207.00,'2023-03-02 11:07:20','',''),(4971,'1','310','1',1,'Retail Sale Id 4828',9000.00,0.00,0.00,12.50,862.50,'2023-03-02 11:08:39','',''),(4972,'1','310','1',1,'Retail Sale Id 4829',73500.00,0.00,0.00,105.00,5145.00,'2023-03-02 11:10:01','',''),(4973,'1','310','1',1,'Retail Sale Id 4830',1000.80,0.00,0.00,1.39,95.91,'2023-03-02 11:11:06','',''),(4974,'1','310','1',1,'Retail Sale Id 4831',2160.00,0.00,0.00,3.00,207.00,'2023-03-02 11:15:24','',''),(4975,'1','310','1',1,'Retail Sale Id 4832',14400.00,0.00,0.00,20.00,1380.00,'2023-03-02 11:23:47','',''),(4976,'1','310','1',1,'Retail Sale Id 4833',9000.00,0.00,0.00,12.50,862.50,'2023-03-02 11:27:26','',''),(4977,'1','310','1',1,'Retail Sale Id 4834',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 11:32:51','',''),(4978,'1','310','1',1,'Retail Sale Id 4834',9000.00,0.00,0.00,12.50,862.50,'2023-03-02 11:32:51','',''),(4979,'1','310','1',1,'Retail Sale Id 4835',900.00,0.00,0.00,1.25,86.25,'2023-03-02 11:35:49','',''),(4980,'1','310','1',1,'Retail Sale Id 4836',2599.20,0.00,0.00,3.61,249.09,'2023-03-02 11:41:53','',''),(4981,'1','310','1',1,'Retail Sale Id 4837',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 11:49:32','',''),(4982,'1','310','1',1,'Retail Sale Id 4838',2160.00,0.00,0.00,3.00,207.00,'2023-03-02 11:56:40','',''),(4983,'1','310','1',1,'Retail Sale Id 4839',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 11:57:55','',''),(4984,'1','310','1',1,'Retail Sale Id 4841',4680.00,0.00,0.00,6.50,448.50,'2023-03-02 12:12:52','',''),(4985,'1','310','1',1,'Retail Sale Id 4841',7200.00,0.00,0.00,10.00,690.00,'2023-03-02 12:12:52','',''),(4986,'1','310','1',1,'Retail Sale Id 4842',9800.00,0.00,0.00,14.00,686.00,'2023-03-02 12:18:55','',''),(4987,'1','310','1',1,'Retail Sale Id 4843',2498.40,0.00,0.00,3.47,239.43,'2023-03-02 12:45:58','',''),(4988,'1','310','1',1,'Retail Sale Id 4844',3002.40,0.00,0.00,4.17,287.73,'2023-03-02 12:48:27','',''),(4989,'1','310','1',1,'Retail Sale Id 4845',2001.60,0.00,0.00,2.78,191.82,'2023-03-02 12:58:54','',''),(4990,'1','310','1',1,'Retail Sale Id 4846',1000.80,0.00,0.00,1.39,95.91,'2023-03-02 13:05:00','',''),(4991,'1','310','1',1,'Retail Sale Id 4847',2100.00,0.00,0.00,3.00,147.00,'2023-03-02 13:17:10','',''),(4992,'1','310','1',1,'Retail Sale Id 4848',17500.00,0.00,0.00,25.00,1225.00,'2023-03-02 13:18:24','',''),(4993,'1','310','1',1,'Retail Sale Id 4849',9000.00,0.00,0.00,12.50,862.50,'2023-03-02 13:19:36','',''),(4994,'1','310','1',1,'Retail Sale Id 4849',18000.00,0.00,0.00,25.00,1725.00,'2023-03-02 13:19:36','',''),(4995,'1','310','1',1,'Retail Sale Id 4850',9000.00,0.00,0.00,12.50,862.50,'2023-03-02 13:20:23','',''),(4996,'1','310','1',1,'Retail Sale Id 4851',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 13:21:04','',''),(4997,'1','310','1',1,'Retail Sale Id 4852',9000.00,0.00,0.00,12.50,862.50,'2023-03-02 13:21:45','',''),(4998,'1','310','1',1,'Retail Sale Id 4853',9000.00,0.00,0.00,12.50,862.50,'2023-03-02 13:30:09','',''),(4999,'1','310','1',1,'Retail Sale Id 4854',2160.00,0.00,0.00,3.00,207.00,'2023-03-02 13:33:55','',''),(5000,'1','310','1',1,'Retail Sale Id 4855',70000.00,0.00,0.00,100.00,4900.00,'2023-03-02 13:39:12','',''),(5001,'1','310','1',1,'Retail Sale Id 4856',3002.40,0.00,0.00,4.17,287.73,'2023-03-02 13:52:36','',''),(5002,'1','310','1',1,'Retail Sale Id 4857',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 14:14:57','',''),(5003,'1','310','1',1,'Retail Sale Id 4858',2160.00,0.00,0.00,3.00,207.00,'2023-03-02 14:17:16','',''),(5004,'1','310','1',1,'Retail Sale Id 4859',4003.20,0.00,0.00,5.56,383.64,'2023-03-02 14:24:45','',''),(5005,'1','310','1',1,'Retail Sale Id 4860',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 14:34:23','',''),(5006,'1','310','1',1,'Retail Sale Id 4861',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 14:38:36','',''),(5007,'1','310','1',1,'Return of Retail Sale Id 4860',0.00,4320.00,6.00,0.00,-414.00,'2023-03-02 14:39:52','',''),(5008,'1','310','1',1,'Retail Sale Id 4862',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 14:59:38','',''),(5009,'1','310','1',1,'Retail Sale Id 4863',1000.80,0.00,0.00,1.39,95.91,'2023-03-02 15:25:49','',''),(5010,'1','310','1',1,'Retail Sale Id 4864',1202.40,0.00,0.00,1.67,115.23,'2023-03-02 15:31:34','',''),(5011,'1','310','1',1,'Retail Sale Id 4865',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 15:33:12','',''),(5012,'1','310','1',1,'Retail Sale Id 4866',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 15:39:26','',''),(5013,'1','310','1',1,'Retail Sale Id 4868',3002.40,0.00,0.00,4.17,287.73,'2023-03-02 15:44:48','',''),(5014,'1','310','1',1,'Retail Sale Id 4869',9000.00,0.00,0.00,12.50,862.50,'2023-03-02 15:49:22','',''),(5015,'1','310','1',1,'Retail Sale Id 4870',9000.00,0.00,0.00,12.50,862.50,'2023-03-02 15:59:19','',''),(5016,'1','310','1',1,'Retail Sale Id 4871',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 16:03:10','',''),(5017,'1','310','1',1,'Retail Sale Id 4872',2160.00,0.00,0.00,3.00,207.00,'2023-03-02 16:09:15','',''),(5018,'1','310','1',1,'Retail Sale Id 4873',4996.80,0.00,0.00,6.94,478.86,'2023-03-02 16:32:53','',''),(5019,'1','310','1',1,'Retail Sale Id 4874',720.00,0.00,0.00,1.00,69.00,'2023-03-02 16:38:23','',''),(5020,'1','310','1',1,'Retail Sale Id 4875',9000.00,0.00,0.00,12.50,862.50,'2023-03-02 16:41:28','',''),(5021,'1','310','1',1,'Retail Sale Id 4877',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 16:46:46','',''),(5022,'1','310','1',1,'Retail Sale Id 4878',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 16:49:02','',''),(5023,'1','310','1',1,'Retail Sale Id 4879',2001.60,0.00,0.00,2.78,191.82,'2023-03-02 16:50:05','',''),(5024,'1','310','1',1,'Retail Sale Id 4880',7200.00,0.00,0.00,10.00,690.00,'2023-03-02 16:59:21','',''),(5025,'1','310','1',1,'Retail Sale Id 4881',7200.00,0.00,0.00,10.00,690.00,'2023-03-02 17:05:32','',''),(5026,'1','310','1',1,'Retail Sale Id 4882',9000.00,0.00,0.00,12.50,862.50,'2023-03-02 17:12:48','',''),(5027,'1','310','1',1,'Retail Sale Id 4883',1000.80,0.00,0.00,1.39,95.91,'2023-03-02 17:13:54','',''),(5028,'1','310','1',1,'Retail Sale Id 4884',2160.00,0.00,0.00,3.00,207.00,'2023-03-02 17:14:41','',''),(5029,'1','310','1',1,'Retail Sale Id 4885',1000.80,0.00,0.00,1.39,95.91,'2023-03-02 17:26:00','',''),(5030,'1','310','1',1,'Retail Sale Id 4886',3600.00,0.00,0.00,5.00,345.00,'2023-03-02 17:28:18','',''),(5031,'1','310','1',1,'Retail Sale Id 4887',2001.60,0.00,0.00,2.78,191.82,'2023-03-02 17:31:17','',''),(5032,'1','310','1',1,'Retail Sale Id 4888',5040.00,0.00,0.00,7.00,483.00,'2023-03-02 17:32:50','',''),(5033,'1','310','1',1,'Retail Sale Id 4889',2498.40,0.00,0.00,3.47,239.43,'2023-03-02 17:35:21','',''),(5034,'1','310','1',1,'Retail Sale Id 4890',3600.00,0.00,0.00,5.00,345.00,'2023-03-02 17:37:41','',''),(5035,'1','310','1',1,'Retail Sale Id 4891',9000.00,0.00,0.00,12.50,862.50,'2023-03-02 17:40:12','',''),(5036,'1','310','1',1,'Retail Sale Id 4892',3600.00,0.00,0.00,5.00,345.00,'2023-03-02 17:49:05','',''),(5037,'1','310','1',1,'Retail Sale Id 4894',2160.00,0.00,0.00,3.00,207.00,'2023-03-02 17:51:40','',''),(5038,'1','310','1',1,'Retail Sale Id 4896',3600.00,0.00,0.00,5.00,345.00,'2023-03-02 17:53:39','',''),(5039,'1','310','1',1,'Retail Sale Id 4897',2160.00,0.00,0.00,3.00,207.00,'2023-03-02 17:56:05','',''),(5040,'1','310','1',1,'Retail Sale Id 4898',3002.40,0.00,0.00,4.17,287.73,'2023-03-02 17:57:50','',''),(5041,'1','310','1',1,'Retail Sale Id 4899',2001.60,0.00,0.00,2.78,191.82,'2023-03-02 17:58:55','',''),(5042,'1','310','1',1,'Retail Sale Id 4900',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 18:00:00','',''),(5043,'1','310','1',1,'Retail Sale Id 4901',3600.00,0.00,0.00,5.00,345.00,'2023-03-02 18:01:15','',''),(5044,'1','310','1',1,'Retail Sale Id 4904',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 18:07:06','',''),(5045,'1','310','1',1,'Retail Sale Id 4905',2160.00,0.00,0.00,3.00,207.00,'2023-03-02 18:08:46','',''),(5046,'1','310','1',1,'Retail Sale Id 4906',4320.00,0.00,0.00,6.00,414.00,'2023-03-02 18:09:47','',''),(5047,'1','310','1',1,'Retail Sale Id 4907',1497.60,0.00,0.00,2.08,143.52,'2023-03-02 18:10:42','',''),(5048,'1','310','1',1,'Retail Sale Id 4908',9000.00,0.00,0.00,12.50,862.50,'2023-03-02 18:11:41','',''),(5049,'1','310','1',1,'Retail Sale Id 4909',9000.00,0.00,0.00,12.50,862.50,'2023-03-02 18:13:10','',''),(5050,'1','310','1',1,'Retail Sale Id 4910',2160.00,0.00,0.00,3.00,207.00,'2023-03-02 18:19:24','',''),(5051,'1','310','1',1,'Retail Sale Id 4911',1800.00,0.00,0.00,2.50,172.50,'2023-03-02 18:24:45','',''),(5052,'1','310','1',1,'Retail Sale Id 4912',5760.00,0.00,0.00,8.00,552.00,'2023-03-02 18:26:41','',''),(5053,'1','310','1',1,'Retail Sale Id 4913',3600.00,0.00,0.00,5.00,345.00,'2023-03-02 18:30:02','',''),(5054,'1','310','1',1,'Return of Retail Sale Id 4909',0.00,9000.00,12.50,0.00,-862.50,'2023-03-02 18:46:35','',''),(5055,'1','310','1',1,'Return of Retail Sale Id 4908',0.00,9000.00,12.50,0.00,-862.50,'2023-03-02 18:46:56','',''),(5056,'1','310','1',1,'Return of Retail Sale Id 4912',0.00,5760.00,8.00,0.00,-552.00,'2023-03-02 18:47:46','',''),(5057,'1','310','1',1,'Retail Sale Id 4914',1828.80,0.00,0.00,2.54,175.26,'2023-03-02 18:48:35','',''),(5058,'1','310','1',1,'Retail Sale Id 4915',2001.60,0.00,0.00,2.78,191.82,'2023-03-02 19:05:50','',''),(5059,'1','310','1',1,'Retail Sale Id 4916',0.00,0.00,0.00,0.00,0.00,'2023-03-02 19:12:01','',''),(5060,'1','310','1',1,'Retail Sale Id 4917',2203.20,0.00,0.00,3.06,211.14,'2023-03-03 07:34:11','',''),(5061,'1','310','1',1,'Retail Sale Id 4918',35000.00,0.00,0.00,50.00,2450.00,'2023-03-03 07:36:06','',''),(5062,'1','310','1',1,'Retail Sale Id 4919',3600.00,0.00,0.00,5.00,345.00,'2023-03-03 07:49:01','',''),(5063,'1','310','1',1,'Retail Sale Id 4920',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 08:07:19','',''),(5064,'1','310','1',1,'Retail Sale Id 4922',1497.60,0.00,0.00,2.08,143.52,'2023-03-03 08:11:16','',''),(5065,'1','310','1',1,'Retail Sale Id 4923',9000.00,0.00,0.00,12.50,862.50,'2023-03-03 08:14:34','',''),(5066,'1','310','1',1,'Retail Sale Id 4924',9000.00,0.00,0.00,12.50,862.50,'2023-03-03 08:16:37','',''),(5067,'1','310','1',1,'Retail Sale Id 4926',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 08:22:19','',''),(5068,'1','310','1',1,'Retail Sale Id 4926',7200.00,0.00,0.00,10.00,690.00,'2023-03-03 08:22:19','',''),(5069,'1','310','1',1,'Retail Sale Id 4928',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 08:38:02','',''),(5070,'1','310','1',1,'Retail Sale Id 4929',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 08:46:11','',''),(5071,'1','310','1',1,'Retail Sale Id 4930',9000.00,0.00,0.00,12.50,862.50,'2023-03-03 08:51:17','',''),(5072,'1','310','1',1,'Retail Sale Id 4931',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 08:57:13','',''),(5073,'1','310','1',1,'Retail Sale Id 4932',3002.40,0.00,0.00,4.17,287.73,'2023-03-03 09:04:50','',''),(5074,'1','310','1',1,'Retail Sale Id 4933',2160.00,0.00,0.00,3.00,207.00,'2023-03-03 09:07:18','',''),(5075,'1','310','1',1,'Retail Sale Id 4934',2160.00,0.00,0.00,3.00,207.00,'2023-03-03 09:08:43','',''),(5076,'1','310','1',1,'Retail Sale Id 4935',2880.00,0.00,0.00,4.00,276.00,'2023-03-03 09:33:37','',''),(5077,'1','310','1',1,'Retail Sale Id 4936',3002.40,0.00,0.00,4.17,287.73,'2023-03-03 09:40:46','',''),(5078,'1','310','1',1,'Retail Sale Id 4937',9000.00,0.00,0.00,12.50,862.50,'2023-03-03 09:42:22','',''),(5079,'1','310','1',1,'Retail Sale Id 4938',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 09:43:18','',''),(5080,'1','310','1',1,'Retail Sale Id 4939',9000.00,0.00,0.00,12.50,862.50,'2023-03-03 09:52:58','',''),(5081,'1','310','1',1,'Retail Sale Id 4940',2160.00,0.00,0.00,3.00,207.00,'2023-03-03 09:53:57','',''),(5082,'1','310','1',1,'Retail Sale Id 4941',42000.00,0.00,0.00,60.00,2940.00,'2023-03-03 09:58:29','',''),(5083,'1','310','1',1,'Retail Sale Id 4942',9000.00,0.00,0.00,12.50,862.50,'2023-03-03 10:03:58','',''),(5084,'1','310','1',1,'Retail Sale Id 4942',9000.00,0.00,0.00,12.50,862.50,'2023-03-03 10:03:58','',''),(5085,'1','310','1',1,'Retail Sale Id 4942',9000.00,0.00,0.00,12.50,862.50,'2023-03-03 10:03:58','',''),(5086,'1','310','1',1,'Retail Sale Id 4943',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 10:07:18','',''),(5087,'1','310','1',1,'Retail Sale Id 4943',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 10:07:18','',''),(5088,'1','310','1',1,'Retail Sale Id 4944',1303.20,0.00,0.00,1.81,124.89,'2023-03-03 10:08:41','',''),(5089,'1','310','1',1,'Retail Sale Id 4945',9000.00,0.00,0.00,12.50,862.50,'2023-03-03 10:09:58','',''),(5090,'1','310','1',1,'Retail Sale Id 4946',1000.80,0.00,0.00,1.39,95.91,'2023-03-03 10:19:22','',''),(5091,'1','310','1',1,'Retail Sale Id 4947',900.00,0.00,0.00,1.25,86.25,'2023-03-03 10:20:38','',''),(5092,'1','310','1',1,'Retail Sale Id 4947',1000.80,0.00,0.00,1.39,95.91,'2023-03-03 10:20:38','',''),(5093,'1','310','1',1,'Retail Sale Id 4948',1000.80,0.00,0.00,1.39,95.91,'2023-03-03 10:21:30','',''),(5094,'1','310','1',1,'Retail Sale Id 4949',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 10:25:56','',''),(5095,'1','310','1',1,'Retail Sale Id 4950',1000.80,0.00,0.00,1.39,95.91,'2023-03-03 10:41:11','',''),(5096,'1','310','1',1,'Retail Sale Id 4951',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 10:47:27','',''),(5097,'1','310','1',1,'Retail Sale Id 4952',2160.00,0.00,0.00,3.00,207.00,'2023-03-03 10:50:42','',''),(5098,'1','310','1',1,'Retail Sale Id 4953',4500.00,0.00,0.00,6.25,431.25,'2023-03-03 10:53:56','',''),(5099,'1','310','1',1,'Retail Sale Id 4954',9000.00,0.00,0.00,12.50,862.50,'2023-03-03 10:56:51','',''),(5100,'1','310','1',1,'Retail Sale Id 4955',4348.80,0.00,0.00,6.04,416.76,'2023-03-03 11:03:19','',''),(5101,'1','310','1',1,'Retail Sale Id 4955',4348.80,0.00,0.00,6.04,416.76,'2023-03-03 11:03:19','',''),(5102,'1','310','1',1,'Retail Sale Id 4956',1000.80,0.00,0.00,1.39,95.91,'2023-03-03 11:06:28','',''),(5103,'1','310','1',1,'Retail Sale Id 4957',9000.00,0.00,0.00,12.50,862.50,'2023-03-03 11:07:56','',''),(5104,'1','310','1',1,'Retail Sale Id 4958',9000.00,0.00,0.00,12.50,862.50,'2023-03-03 11:09:32','',''),(5105,'1','310','1',1,'Retail Sale Id 4959',2160.00,0.00,0.00,3.00,207.00,'2023-03-03 11:11:21','',''),(5106,'1','310','1',1,'Retail Sale Id 4959',2160.00,0.00,0.00,3.00,207.00,'2023-03-03 11:11:21','',''),(5107,'1','310','1',1,'Retail Sale Id 4959',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 11:11:21','',''),(5108,'1','310','1',1,'Retail Sale Id 4960',2160.00,0.00,0.00,3.00,207.00,'2023-03-03 11:12:28','',''),(5109,'1','310','1',1,'Retail Sale Id 4961',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 11:30:03','',''),(5110,'1','310','1',1,'Retail Sale Id 4963',3002.40,0.00,0.00,4.17,287.73,'2023-03-03 11:40:31','',''),(5111,'1','310','1',1,'Retail Sale Id 4965',1000.80,0.00,0.00,1.39,95.91,'2023-03-03 11:45:39','',''),(5112,'1','310','1',1,'Retail Sale Id 4966',3600.00,0.00,0.00,5.00,345.00,'2023-03-03 11:50:55','',''),(5113,'1','310','1',1,'Retail Sale Id 4967',7200.00,0.00,0.00,10.00,690.00,'2023-03-03 11:55:18','',''),(5114,'1','310','1',1,'Retail Sale Id 4968',9000.00,0.00,0.00,12.50,862.50,'2023-03-03 11:59:03','',''),(5115,'1','310','1',1,'Retail Sale Id 4969',9000.00,0.00,0.00,12.50,862.50,'2023-03-03 12:00:03','',''),(5116,'1','310','1',1,'Retail Sale Id 4970',9000.00,0.00,0.00,12.50,862.50,'2023-03-03 12:01:14','',''),(5117,'1','310','1',1,'Retail Sale Id 4971',2160.00,0.00,0.00,3.00,207.00,'2023-03-03 12:03:48','',''),(5118,'1','310','1',1,'Retail Sale Id 4972',2160.00,0.00,0.00,3.00,207.00,'2023-03-03 12:04:24','',''),(5119,'1','310','1',1,'Retail Sale Id 4973',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 12:04:50','',''),(5120,'1','310','1',1,'Retail Sale Id 4974',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 12:10:52','',''),(5121,'1','310','1',1,'Retail Sale Id 4975',2880.00,0.00,0.00,4.00,276.00,'2023-03-03 12:18:11','',''),(5122,'1','310','1',1,'Retail Sale Id 4975',3600.00,0.00,0.00,5.00,345.00,'2023-03-03 12:18:11','',''),(5123,'1','310','1',1,'Retail Sale Id 4978',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 12:24:05','',''),(5124,'1','310','1',1,'Retail Sale Id 4979',2296.80,0.00,0.00,3.19,220.11,'2023-03-03 12:27:43','',''),(5125,'1','310','1',1,'Retail Sale Id 4980',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 12:33:09','',''),(5126,'1','310','1',1,'Retail Sale Id 4981',8352.00,0.00,0.00,11.60,800.40,'2023-03-03 12:34:09','',''),(5127,'1','310','1',1,'Retail Sale Id 4982',4003.20,0.00,0.00,5.56,383.64,'2023-03-03 12:35:19','',''),(5128,'1','310','1',1,'Retail Sale Id 4983',1000.80,0.00,0.00,1.39,95.91,'2023-03-03 12:39:30','',''),(5129,'1','310','1',1,'Retail Sale Id 4984',1000.80,0.00,0.00,1.39,95.91,'2023-03-03 12:52:21','',''),(5130,'1','310','1',1,'Retail Sale Id 4985',5040.00,0.00,0.00,7.00,483.00,'2023-03-03 13:33:12','',''),(5131,'1','310','1',1,'Retail Sale Id 4986',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 13:39:09','',''),(5132,'1','310','1',1,'Retail Sale Id 4987',9000.00,0.00,0.00,12.50,862.50,'2023-03-03 13:54:19','',''),(5133,'1','310','1',1,'Retail Sale Id 4988',105000.00,0.00,0.00,150.00,7350.00,'2023-03-03 14:36:27','',''),(5134,'1','310','1',1,'Retail Sale Id 4989',2001.60,0.00,0.00,2.78,191.82,'2023-03-03 14:46:17','',''),(5135,'1','310','1',1,'Retail Sale Id 4990',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 14:47:03','',''),(5136,'1','310','1',1,'Retail Sale Id 4991',3499.20,0.00,0.00,4.86,335.34,'2023-03-03 14:48:37','',''),(5137,'1','310','1',1,'Retail Sale Id 4992',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 14:54:06','',''),(5138,'1','310','1',1,'Retail Sale Id 4993',2203.20,0.00,0.00,3.06,211.14,'2023-03-03 15:00:05','',''),(5139,'1','310','1',1,'Retail Sale Id 4994',1497.60,0.00,0.00,2.08,143.52,'2023-03-03 15:09:09','',''),(5140,'1','310','1',1,'Retail Sale Id 4995',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 15:10:12','',''),(5141,'1','310','1',1,'Retail Sale Id 4996',2203.20,0.00,0.00,3.06,211.14,'2023-03-03 15:11:29','',''),(5142,'1','310','1',1,'Retail Sale Id 4997',2001.60,0.00,0.00,2.78,191.82,'2023-03-03 15:14:10','',''),(5143,'1','310','1',1,'Retail Sale Id 4998',3600.00,0.00,0.00,5.00,345.00,'2023-03-03 15:26:01','',''),(5144,'1','310','1',1,'Retail Sale Id 4999',9000.00,0.00,0.00,12.50,862.50,'2023-03-03 15:31:02','',''),(5145,'1','310','1',1,'Retail Sale Id 5000',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 15:33:15','',''),(5146,'1','310','1',1,'Retail Sale Id 5001',105000.00,0.00,0.00,150.00,7350.00,'2023-03-03 15:38:35','',''),(5147,'1','310','1',1,'Retail Sale Id 5002',9000.00,0.00,0.00,12.50,862.50,'2023-03-03 15:39:25','',''),(5148,'1','310','1',1,'Retail Sale Id 5003',4003.20,0.00,0.00,5.56,383.64,'2023-03-03 15:43:26','',''),(5149,'1','310','1',1,'Retail Sale Id 5005',1000.80,0.00,0.00,1.39,95.91,'2023-03-03 15:47:54','',''),(5150,'1','310','1',1,'Retail Sale Id 5006',720.00,0.00,0.00,1.00,69.00,'2023-03-03 15:53:40','',''),(5151,'1','310','1',1,'Retail Sale Id 5007',3600.00,0.00,0.00,5.00,345.00,'2023-03-03 16:05:43','',''),(5152,'1','310','1',1,'Retail Sale Id 5008',3103.20,0.00,0.00,4.31,297.39,'2023-03-03 16:30:16','',''),(5153,'1','310','1',1,'Retail Sale Id 5009',2001.60,0.00,0.00,2.78,191.82,'2023-03-03 16:35:16','',''),(5154,'1','310','1',1,'Retail Sale Id 5010',2001.60,0.00,0.00,2.78,191.82,'2023-03-03 16:36:17','',''),(5155,'1','310','1',1,'Retail Sale Id 5011',4996.80,0.00,0.00,6.94,478.86,'2023-03-03 16:37:11','',''),(5156,'1','310','1',1,'Retail Sale Id 5012',3600.00,0.00,0.00,5.00,345.00,'2023-03-03 16:42:52','',''),(5157,'1','310','1',1,'Retail Sale Id 5013',2001.60,0.00,0.00,2.78,191.82,'2023-03-03 16:50:06','',''),(5158,'1','310','1',1,'Retail Sale Id 5014',1598.40,0.00,0.00,2.22,153.18,'2023-03-03 16:51:11','',''),(5159,'1','310','1',1,'Retail Sale Id 5015',1396.80,0.00,0.00,1.94,133.86,'2023-03-03 16:53:26','',''),(5160,'1','310','1',1,'Retail Sale Id 5016',1000.80,0.00,0.00,1.39,95.91,'2023-03-03 16:56:05','',''),(5161,'1','310','1',1,'Retail Sale Id 5017',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 16:59:05','',''),(5162,'1','310','1',1,'Retail Sale Id 5018',1799.00,0.00,0.00,2.57,125.93,'2023-03-03 17:01:52','',''),(5163,'1','310','1',1,'Retail Sale Id 5019',6480.00,0.00,0.00,9.00,621.00,'2023-03-03 17:05:38','',''),(5164,'1','310','1',1,'Retail Sale Id 5020',6480.00,0.00,0.00,9.00,621.00,'2023-03-03 17:08:58','',''),(5165,'1','310','1',1,'Retail Sale Id 5021',9000.00,0.00,0.00,12.50,862.50,'2023-03-03 17:10:05','',''),(5166,'1','310','1',1,'Retail Sale Id 5022',1497.60,0.00,0.00,2.08,143.52,'2023-03-03 17:11:24','',''),(5167,'1','310','1',1,'Retail Sale Id 5023',9000.00,0.00,0.00,12.50,862.50,'2023-03-03 17:13:48','',''),(5168,'1','310','1',1,'Retail Sale Id 5024',7200.00,0.00,0.00,10.00,690.00,'2023-03-03 17:16:24','',''),(5169,'1','310','1',1,'Retail Sale Id 5025',3600.00,0.00,0.00,5.00,345.00,'2023-03-03 17:22:33','',''),(5170,'1','310','1',1,'Retail Sale Id 5026',1000.80,0.00,0.00,1.39,95.91,'2023-03-03 17:28:17','',''),(5171,'1','310','1',1,'Retail Sale Id 5027',2160.00,0.00,0.00,3.00,207.00,'2023-03-03 17:35:17','',''),(5172,'1','310','1',1,'Retail Sale Id 5027',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 17:35:17','',''),(5173,'1','310','1',1,'Retail Sale Id 5028',3240.00,0.00,0.00,4.50,310.50,'2023-03-03 17:46:28','',''),(5174,'1','310','1',1,'Retail Sale Id 5029',2160.00,0.00,0.00,3.00,207.00,'2023-03-03 17:49:32','',''),(5175,'1','310','1',1,'Retail Sale Id 5030',2700.00,0.00,0.00,3.75,258.75,'2023-03-03 17:52:23','',''),(5176,'1','310','1',1,'Retail Sale Id 5032',5896.80,0.00,0.00,8.19,565.11,'2023-03-03 17:59:41','',''),(5177,'1','310','1',1,'Retail Sale Id 5033',3196.80,0.00,0.00,4.44,306.36,'2023-03-03 18:06:25','',''),(5178,'1','310','1',1,'Retail Sale Id 5034',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 18:07:21','',''),(5179,'1','310','1',1,'Retail Sale Id 5035',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 18:08:27','',''),(5180,'1','310','1',1,'Retail Sale Id 5036',1497.60,0.00,0.00,2.08,143.52,'2023-03-03 18:14:28','',''),(5181,'1','310','1',1,'Retail Sale Id 5037',4399.20,0.00,0.00,6.11,421.59,'2023-03-03 18:16:56','',''),(5182,'1','310','1',1,'Retail Sale Id 5038',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 18:18:24','',''),(5183,'1','310','1',1,'Retail Sale Id 5039',799.20,0.00,0.00,1.11,76.59,'2023-03-03 18:19:14','',''),(5184,'1','310','1',1,'Retail Sale Id 5040',35000.00,0.00,0.00,50.00,2450.00,'2023-03-03 18:24:38','',''),(5185,'1','310','1',1,'Retail Sale Id 5041',9000.00,0.00,0.00,12.50,862.50,'2023-03-03 18:28:07','',''),(5186,'1','310','1',1,'Retail Sale Id 5042',3600.00,0.00,0.00,5.00,345.00,'2023-03-03 18:32:04','',''),(5187,'1','310','1',1,'Retail Sale Id 5044',2880.00,0.00,0.00,4.00,276.00,'2023-03-03 18:35:21','',''),(5188,'1','310','1',1,'Retail Sale Id 5045',1497.60,0.00,0.00,2.08,143.52,'2023-03-03 18:36:17','',''),(5189,'1','310','1',1,'Retail Sale Id 5046',4996.80,0.00,0.00,6.94,478.86,'2023-03-03 18:37:32','',''),(5190,'1','310','1',1,'Retail Sale Id 5047',4320.00,0.00,0.00,6.00,414.00,'2023-03-03 18:38:26','',''),(5191,'1','310','1',1,'Retail Sale Id 5049',2160.00,0.00,0.00,3.00,207.00,'2023-03-03 18:40:17','',''),(5192,'1','310','1',1,'Retail Sale Id 5050',3600.00,0.00,0.00,5.00,345.00,'2023-03-03 18:42:10','',''),(5193,'1','310','1',1,'Retail Sale Id 5051',7999.20,0.00,0.00,11.11,766.59,'2023-03-03 18:52:32','',''),(5194,'1','310','1',1,'Retail Sale Id 5052',2160.00,0.00,0.00,3.00,207.00,'2023-03-03 18:53:36','',''),(5195,'1','310','1',1,'Retail Sale Id 5054',9496.80,0.00,0.00,13.19,910.11,'2023-03-03 18:56:15','',''),(5196,'1','310','1',1,'Retail Sale Id 5055',17251.20,0.00,0.00,23.96,1653.24,'2023-03-03 19:07:51','',''),(5197,'1','310','1',1,'Return of Retail Sale Id 5055',0.00,17251.20,23.96,0.00,-1653.24,'2023-03-03 19:09:01','',''),(5198,'1','310','1',1,'Return of Retail Sale Id 5050',0.00,3600.00,5.00,0.00,-345.00,'2023-03-03 19:09:34','',''),(5199,'1','310','1',1,'Retail Sale Id 5056',1195.20,0.00,0.00,1.66,114.54,'2023-03-03 19:10:19','',''),(5200,'1','310','1',1,'Retail Sale Id 5057',0.00,0.00,0.00,0.00,0.00,'2023-03-03 19:12:06','',''),(5201,'1','310','1',1,'Return of Retail Sale Id 5018',0.00,1799.00,2.57,0.00,-125.93,'2023-03-03 19:12:49','',''),(5202,'1','310','1',1,'Retail Sale Id 5058',1799.00,0.00,0.00,2.57,125.93,'2023-03-03 19:13:35','',''),(5203,'1','310','1',1,'Retail Sale Id 5059',9000.00,0.00,0.00,12.50,862.50,'2023-03-04 07:15:44','',''),(5204,'1','310','1',1,'Retail Sale Id 5061',2498.40,0.00,0.00,3.47,239.43,'2023-03-04 07:43:23','',''),(5205,'1','310','1',1,'Retail Sale Id 5062',3499.20,0.00,0.00,4.86,335.34,'2023-03-04 07:45:34','',''),(5206,'1','310','1',1,'Retail Sale Id 5063',4320.00,0.00,0.00,6.00,414.00,'2023-03-04 07:46:23','',''),(5207,'1','310','1',1,'Retail Sale Id 5064',4320.00,0.00,0.00,6.00,414.00,'2023-03-04 07:48:59','',''),(5208,'1','310','1',1,'Retail Sale Id 5065',2001.60,0.00,0.00,2.78,191.82,'2023-03-04 07:52:59','',''),(5209,'1','310','1',1,'Retail Sale Id 5066',7700.00,0.00,0.00,11.00,539.00,'2023-03-04 08:04:25','',''),(5210,'1','310','1',1,'Retail Sale Id 5067',3600.00,0.00,0.00,5.00,345.00,'2023-03-04 08:09:07','',''),(5211,'1','310','1',1,'Retail Sale Id 5069',7999.20,0.00,0.00,11.11,766.59,'2023-03-04 08:15:35','',''),(5212,'1','310','1',1,'Retail Sale Id 5070',4320.00,0.00,0.00,6.00,414.00,'2023-03-04 08:17:30','',''),(5213,'1','310','1',1,'Retail Sale Id 5071',2880.00,0.00,0.00,4.00,276.00,'2023-03-04 08:19:22','',''),(5214,'1','310','1',1,'Retail Sale Id 5072',3997.00,0.00,0.00,5.71,279.79,'2023-03-04 08:20:40','',''),(5215,'1','310','1',1,'Retail Sale Id 5073',3600.00,0.00,0.00,5.00,345.00,'2023-03-04 08:21:54','',''),(5216,'1','310','1',1,'Retail Sale Id 5074',4320.00,0.00,0.00,6.00,414.00,'2023-03-04 08:24:40','',''),(5217,'1','310','1',1,'Retail Sale Id 5075',2160.00,0.00,0.00,3.00,207.00,'2023-03-04 08:27:39','',''),(5218,'1','310','1',1,'Retail Sale Id 5075',9000.00,0.00,0.00,12.50,862.50,'2023-03-04 08:27:40','',''),(5219,'1','310','1',1,'Retail Sale Id 5076',9000.00,0.00,0.00,12.50,862.50,'2023-03-04 08:40:42','',''),(5220,'1','310','1',1,'Retail Sale Id 5077',2498.40,0.00,0.00,3.47,239.43,'2023-03-04 08:43:41','',''),(5221,'1','310','1',1,'Retail Sale Id 5078',1440.00,0.00,0.00,2.00,138.00,'2023-03-04 08:47:41','',''),(5222,'1','310','1',1,'Retail Sale Id 5079',1000.80,0.00,0.00,1.39,95.91,'2023-03-04 08:55:05','',''),(5223,'1','310','1',1,'Retail Sale Id 5080',35000.00,0.00,0.00,50.00,2450.00,'2023-03-04 08:59:31','',''),(5224,'1','310','1',1,'Retail Sale Id 5081',9000.00,0.00,0.00,12.50,862.50,'2023-03-04 09:04:54','',''),(5225,'1','310','1',1,'Retail Sale Id 5082',2160.00,0.00,0.00,3.00,207.00,'2023-03-04 09:06:15','',''),(5226,'1','310','1',1,'Retail Sale Id 5083',1000.80,0.00,0.00,1.39,95.91,'2023-03-04 09:22:22','',''),(5227,'1','310','1',1,'Retail Sale Id 5089',2160.00,0.00,0.00,3.00,207.00,'2023-03-04 09:24:25','',''),(5228,'1','310','1',1,'Retail Sale Id 5090',2160.00,0.00,0.00,3.00,207.00,'2023-03-04 09:26:27','',''),(5229,'1','310','1',1,'Retail Sale Id 5091',7200.00,0.00,0.00,10.00,690.00,'2023-03-04 09:28:41','',''),(5230,'1','310','1',1,'Retail Sale Id 5092',4320.00,0.00,0.00,6.00,414.00,'2023-03-04 09:29:58','',''),(5231,'1','310','1',1,'Retail Sale Id 5093',4320.00,0.00,0.00,6.00,414.00,'2023-03-04 09:32:12','',''),(5232,'1','310','1',1,'Retail Sale Id 5095',3002.40,0.00,0.00,4.17,287.73,'2023-03-04 09:33:59','',''),(5233,'1','310','1',1,'Retail Sale Id 5096',1440.00,0.00,0.00,2.00,138.00,'2023-03-04 09:36:40','',''),(5234,'1','310','1',1,'Retail Sale Id 5097',105000.00,0.00,0.00,150.00,7350.00,'2023-03-04 09:37:26','',''),(5235,'1','310','1',1,'Retail Sale Id 5098',9000.00,0.00,0.00,12.50,862.50,'2023-03-04 09:38:21','',''),(5236,'1','310','1',1,'Retail Sale Id 5099',4320.00,0.00,0.00,6.00,414.00,'2023-03-04 09:40:26','',''),(5237,'1','310','1',1,'Retail Sale Id 5100',4348.80,0.00,0.00,6.04,416.76,'2023-03-04 09:46:12','',''),(5238,'1','310','1',1,'Retail Sale Id 5103',3002.40,0.00,0.00,4.17,287.73,'2023-03-04 09:55:55','',''),(5239,'1','310','1',1,'Retail Sale Id 5104',7920.00,0.00,0.00,11.00,759.00,'2023-03-04 10:02:08','',''),(5240,'1','310','1',1,'Retail Sale Id 5104',7920.00,0.00,0.00,11.00,759.00,'2023-03-04 10:02:08','',''),(5241,'1','310','1',1,'Retail Sale Id 5105',1447.20,0.00,0.00,2.01,138.69,'2023-03-04 10:04:57','',''),(5242,'1','310','1',1,'Retail Sale Id 5106',9000.00,0.00,0.00,12.50,862.50,'2023-03-04 10:10:04','',''),(5243,'1','310','1',1,'Retail Sale Id 5107',4320.00,0.00,0.00,6.00,414.00,'2023-03-04 10:11:34','',''),(5244,'1','310','1',1,'Retail Sale Id 5108',3002.40,0.00,0.00,4.17,287.73,'2023-03-04 10:13:06','',''),(5245,'1','310','1',1,'Retail Sale Id 5109',2160.00,0.00,0.00,3.00,207.00,'2023-03-04 10:14:04','',''),(5246,'1','310','1',1,'Retail Sale Id 5110',1440.00,0.00,0.00,2.00,138.00,'2023-03-04 10:14:50','',''),(5247,'1','310','1',1,'Retail Sale Id 5110',1440.00,0.00,0.00,2.00,138.00,'2023-03-04 10:14:50','',''),(5248,'1','310','1',1,'Retail Sale Id 5111',2160.00,0.00,0.00,3.00,207.00,'2023-03-04 10:15:59','',''),(5249,'1','310','1',1,'Retail Sale Id 5112',2160.00,0.00,0.00,3.00,207.00,'2023-03-04 10:16:40','',''),(5250,'1','310','1',1,'Retail Sale Id 5113',10800.00,0.00,0.00,15.00,1035.00,'2023-03-04 10:17:13','',''),(5251,'1','310','1',1,'Return of Retail Sale Id 5108',0.00,3002.40,4.17,0.00,-287.73,'2023-03-04 10:19:42','',''),(5252,'1','310','1',1,'Return of Retail Sale Id 5110',0.00,1440.00,2.00,0.00,-138.00,'2023-03-04 10:20:14','',''),(5253,'1','310','1',1,'Return of Retail Sale Id 5110',0.00,1440.00,2.00,0.00,-138.00,'2023-03-04 10:20:14','',''),(5254,'1','310','1',1,'Retail Sale Id 5114',1000.80,0.00,0.00,1.39,95.91,'2023-03-04 10:25:52','',''),(5255,'1','310','1',1,'Retail Sale Id 5115',4320.00,0.00,0.00,6.00,414.00,'2023-03-04 10:29:25','',''),(5256,'1','310','1',1,'Retail Sale Id 5116',4320.00,0.00,0.00,6.00,414.00,'2023-03-04 10:31:23','',''),(5257,'1','310','1',1,'Retail Sale Id 5117',1497.60,0.00,0.00,2.08,143.52,'2023-03-04 10:32:19','',''),(5258,'1','310','1',1,'Retail Sale Id 5118',4320.00,0.00,0.00,6.00,414.00,'2023-03-04 10:41:12','',''),(5259,'1','310','1',1,'Retail Sale Id 5119',4320.00,0.00,0.00,6.00,414.00,'2023-03-04 10:43:51','',''),(5260,'1','310','1',1,'Retail Sale Id 5120',1000.80,0.00,0.00,1.39,95.91,'2023-03-04 10:46:40','',''),(5261,'1','310','1',1,'Retail Sale Id 5121',35000.00,0.00,0.00,50.00,2450.00,'2023-03-04 10:49:36','',''),(5262,'1','310','1',1,'Retail Sale Id 5122',2450.00,0.00,0.00,3.50,171.50,'2023-03-04 10:50:46','',''),(5263,'1','310','1',1,'Retail Sale Id 5123',9000.00,0.00,0.00,12.50,862.50,'2023-03-04 10:52:47','',''),(5264,'1','310','1',1,'Retail Sale Id 5124',2001.60,0.00,0.00,2.78,191.82,'2023-03-04 10:54:11','',''),(5265,'1','310','1',1,'Retail Sale Id 5126',2001.60,0.00,0.00,2.78,191.82,'2023-03-04 10:58:31','',''),(5266,'1','310','1',1,'Retail Sale Id 5127',2160.00,0.00,0.00,3.00,207.00,'2023-03-04 11:14:50','',''),(5267,'1','310','1',1,'Retail Sale Id 5127',2160.00,0.00,0.00,3.00,207.00,'2023-03-04 11:14:50','',''),(5268,'1','310','1',1,'Retail Sale Id 5127',9000.00,0.00,0.00,12.50,862.50,'2023-03-04 11:14:50','',''),(5269,'1','310','1',1,'Retail Sale Id 5128',2880.00,0.00,0.00,4.00,276.00,'2023-03-04 11:17:32','',''),(5270,'1','310','1',1,'Retail Sale Id 5129',1000.80,0.00,0.00,1.39,95.91,'2023-03-04 11:18:52','',''),(5271,'1','310','1',1,'Retail Sale Id 5130',2160.00,0.00,0.00,3.00,207.00,'2023-03-04 11:19:54','',''),(5272,'1','310','1',1,'Retail Sale Id 5131',2001.60,0.00,0.00,2.78,191.82,'2023-03-04 11:20:58','',''),(5273,'1','310','1',1,'Retail Sale Id 5132',1000.80,0.00,0.00,1.39,95.91,'2023-03-04 11:39:14','',''),(5274,'1','310','1',1,'Retail Sale Id 5133',9000.00,0.00,0.00,12.50,862.50,'2023-03-04 11:57:19','',''),(5275,'1','310','1',1,'Retail Sale Id 5134',2160.00,0.00,0.00,3.00,207.00,'2023-03-04 12:00:32','',''),(5276,'1','310','1',1,'Retail Sale Id 5135',2880.00,0.00,0.00,4.00,276.00,'2023-03-04 12:01:39','',''),(5277,'1','310','1',1,'Retail Sale Id 5136',4500.00,0.00,0.00,6.25,431.25,'2023-03-04 12:05:52','',''),(5278,'1','310','1',1,'Retail Sale Id 5137',35000.00,0.00,0.00,50.00,2450.00,'2023-03-04 12:22:18','',''),(5279,'1','310','1',1,'Retail Sale Id 5138',9000.00,0.00,0.00,12.50,862.50,'2023-03-04 12:23:51','',''),(5280,'1','310','1',1,'Retail Sale Id 5140',2160.00,0.00,0.00,3.00,207.00,'2023-03-04 12:26:40','',''),(5281,'1','310','1',1,'Retail Sale Id 5141',2160.00,0.00,0.00,3.00,207.00,'2023-03-04 12:27:37','',''),(5282,'1','310','1',1,'Retail Sale Id 5143',496.80,0.00,0.00,0.69,47.61,'2023-03-04 12:29:30','',''),(5283,'1','310','1',1,'Retail Sale Id 5144',5997.60,0.00,0.00,8.33,574.77,'2023-03-04 12:32:57','',''),(5284,'1','310','1',1,'Retail Sale Id 5146',4320.00,0.00,0.00,6.00,414.00,'2023-03-04 12:37:23','',''),(5285,'1','310','1',1,'Retail Sale Id 5147',1000.80,0.00,0.00,1.39,95.91,'2023-03-04 12:38:22','',''),(5286,'1','310','1',1,'Retail Sale Id 5148',5673.60,0.00,0.00,7.88,543.72,'2023-03-04 12:40:09','',''),(5287,'1','310','1',1,'Retail Sale Id 5150',496.80,0.00,0.00,0.69,47.61,'2023-03-04 12:45:38','',''),(5288,'1','310','1',1,'Retail Sale Id 5151',2160.00,0.00,0.00,3.00,207.00,'2023-03-04 12:54:22','',''),(5289,'1','310','1',1,'Retail Sale Id 5153',4996.80,0.00,0.00,6.94,478.86,'2023-03-04 13:03:03','',''),(5290,'1','310','1',1,'Retail Sale Id 5154',7200.00,0.00,0.00,10.00,690.00,'2023-03-04 13:11:14','',''),(5291,'1','310','1',1,'Retail Sale Id 5155',9000.00,0.00,0.00,12.50,862.50,'2023-03-04 13:25:30','',''),(5292,'1','310','1',1,'Retail Sale Id 5156',7200.00,0.00,0.00,10.00,690.00,'2023-03-04 13:29:18','',''),(5293,'1','310','1',1,'Retail Sale Id 5157',4320.00,0.00,0.00,6.00,414.00,'2023-03-04 13:31:43','',''),(5294,'1','310','1',1,'Retail Sale Id 5159',4320.00,0.00,0.00,6.00,414.00,'2023-03-04 13:48:04','',''),(5295,'1','310','1',1,'Retail Sale Id 5159',6501.60,0.00,0.00,9.03,623.07,'2023-03-04 13:48:04','',''),(5296,'1','310','1',1,'Retail Sale Id 5160',9000.00,0.00,0.00,12.50,862.50,'2023-03-04 13:51:23','',''),(5297,'1','310','1',1,'Retail Sale Id 5161',1000.80,0.00,0.00,1.39,95.91,'2023-03-04 13:52:50','',''),(5298,'1','310','1',1,'Retail Sale Id 5162',1497.60,0.00,0.00,2.08,143.52,'2023-03-04 13:54:31','',''),(5299,'1','310','1',1,'Retail Sale Id 5163',8539.20,0.00,0.00,11.86,818.34,'2023-03-04 13:59:59','',''),(5300,'1','310','1',1,'Retail Sale Id 5164',9000.00,0.00,0.00,12.50,862.50,'2023-03-04 14:08:41','',''),(5301,'1','310','1',1,'Retail Sale Id 5165',70000.00,0.00,0.00,100.00,4900.00,'2023-03-04 14:10:05','',''),(5302,'1','310','1',1,'Retail Sale Id 5166',4320.00,0.00,0.00,6.00,414.00,'2023-03-04 14:12:52','',''),(5303,'1','310','1',1,'Retail Sale Id 5167',3002.40,0.00,0.00,4.17,287.73,'2023-03-04 14:20:15','',''),(5304,'1','310','1',1,'Retail Sale Id 5168',9000.00,0.00,0.00,12.50,862.50,'2023-03-04 14:30:49','',''),(5305,'1','310','1',1,'Retail Sale Id 5169',496.80,0.00,0.00,0.69,47.61,'2023-03-04 14:34:45','',''),(5306,'1','310','1',1,'Retail Sale Id 5170',105000.00,0.00,0.00,150.00,7350.00,'2023-03-04 14:38:57','',''),(5307,'1','310','1',1,'Retail Sale Id 5171',3600.00,0.00,0.00,5.00,345.00,'2023-03-04 14:44:28','',''),(5308,'1','310','1',1,'Retail Sale Id 5172',4996.80,0.00,0.00,6.94,478.86,'2023-03-04 14:47:08','',''),(5309,'1','310','1',1,'Retail Sale Id 5174',7920.00,0.00,0.00,11.00,759.00,'2023-03-04 14:53:38','',''),(5310,'1','310','1',1,'Retail Sale Id 5175',8503.20,0.00,0.00,11.81,814.89,'2023-03-04 15:00:39','',''),(5311,'1','310','1',1,'Retail Sale Id 5176',1440.00,0.00,0.00,2.00,138.00,'2023-03-04 15:02:43','',''),(5312,'1','310','1',1,'Retail Sale Id 5177',2160.00,0.00,0.00,3.00,207.00,'2023-03-04 15:04:21','',''),(5313,'1','310','1',1,'Retail Sale Id 5178',1000.80,0.00,0.00,1.39,95.91,'2023-03-04 15:14:36','',''),(5314,'1','310','1',1,'Retail Sale Id 5179',2160.00,0.00,0.00,3.00,207.00,'2023-03-04 15:16:21','',''),(5315,'1','310','1',1,'Retail Sale Id 5180',4320.00,0.00,0.00,6.00,414.00,'2023-03-04 15:18:00','',''),(5316,'1','310','1',1,'Retail Sale Id 5181',70000.00,0.00,0.00,100.00,4900.00,'2023-03-04 15:33:42','',''),(5317,'1','310','1',1,'Retail Sale Id 5182',9000.00,0.00,0.00,12.50,862.50,'2023-03-04 16:02:20','',''),(5318,'1','310','1',1,'Retail Sale Id 5183',1000.80,0.00,0.00,1.39,95.91,'2023-03-04 16:03:39','',''),(5319,'1','310','1',1,'Retail Sale Id 5184',346500.00,0.00,0.00,495.00,24255.00,'2023-03-04 16:10:46','',''),(5320,'1','310','1',1,'Retail Sale Id 5185',9000.00,0.00,0.00,12.50,862.50,'2023-03-04 16:20:30','',''),(5321,'1','310','1',1,'Retail Sale Id 5187',2001.60,0.00,0.00,2.78,191.82,'2023-03-04 16:32:48','',''),(5322,'1','310','1',1,'Retail Sale Id 5188',2152.80,0.00,0.00,2.99,206.31,'2023-03-04 16:36:22','',''),(5323,'1','310','1',1,'Retail Sale Id 5189',2160.00,0.00,0.00,3.00,207.00,'2023-03-04 16:37:39','',''),(5324,'1','310','1',1,'Retail Sale Id 5190',4320.00,0.00,0.00,6.00,414.00,'2023-03-04 16:47:42','',''),(5325,'1','310','1',1,'Retail Sale Id 5191',4320.00,0.00,0.00,6.00,414.00,'2023-03-04 16:49:01','',''),(5326,'1','310','1',1,'Retail Sale Id 5192',1202.40,0.00,0.00,1.67,115.23,'2023-03-04 16:57:49','',''),(5327,'1','310','1',1,'Retail Sale Id 5193',3600.00,0.00,0.00,5.00,345.00,'2023-03-04 16:58:33','',''),(5328,'1','310','1',1,'Retail Sale Id 5194',1000.80,0.00,0.00,1.39,95.91,'2023-03-04 17:10:14','',''),(5329,'1','310','1',1,'Retail Sale Id 5195',3240.00,0.00,0.00,4.50,310.50,'2023-03-04 17:14:22','',''),(5330,'1','310','1',1,'Retail Sale Id 5196',52500.00,0.00,0.00,75.00,3675.00,'2023-03-04 17:17:26','',''),(5331,'1','310','1',1,'Retail Sale Id 5197',1000.80,0.00,0.00,1.39,95.91,'2023-03-04 17:33:36','',''),(5332,'1','310','1',1,'Retail Sale Id 5198',2203.20,0.00,0.00,3.06,211.14,'2023-03-04 17:35:27','',''),(5333,'1','310','1',1,'Retail Sale Id 5199',4320.00,0.00,0.00,6.00,414.00,'2023-03-04 17:39:06','',''),(5334,'1','310','1',1,'Retail Sale Id 5200',2160.00,0.00,0.00,3.00,207.00,'2023-03-04 17:41:04','',''),(5335,'1','310','1',1,'Retail Sale Id 5201',3002.40,0.00,0.00,4.17,287.73,'2023-03-04 17:42:12','',''),(5336,'1','310','1',1,'Retail Sale Id 5202',3600.00,0.00,0.00,5.00,345.00,'2023-03-04 17:54:14','',''),(5337,'1','310','1',1,'Retail Sale Id 5203',9000.00,0.00,0.00,12.50,862.50,'2023-03-04 17:56:04','',''),(5338,'1','310','1',1,'Retail Sale Id 5204',1303.20,0.00,0.00,1.81,124.89,'2023-03-04 17:57:49','',''),(5339,'1','310','1',1,'Retail Sale Id 5205',9000.00,0.00,0.00,12.50,862.50,'2023-03-04 17:59:32','',''),(5340,'1','310','1',1,'Retail Sale Id 5206',1497.60,0.00,0.00,2.08,143.52,'2023-03-04 18:02:59','',''),(5341,'1','310','1',1,'Retail Sale Id 5207',2160.00,0.00,0.00,3.00,207.00,'2023-03-04 18:04:44','',''),(5342,'1','310','1',1,'Retail Sale Id 5208',5040.00,0.00,0.00,7.00,483.00,'2023-03-04 18:07:15','',''),(5343,'1','310','1',1,'Retail Sale Id 5209',1497.60,0.00,0.00,2.08,143.52,'2023-03-04 18:09:47','',''),(5344,'1','310','1',1,'Retail Sale Id 5210',4003.20,0.00,0.00,5.56,383.64,'2023-03-04 18:13:58','',''),(5345,'1','310','1',1,'Retail Sale Id 5211',1000.80,0.00,0.00,1.39,95.91,'2023-03-04 18:18:00','',''),(5346,'1','310','1',1,'Retail Sale Id 5212',496.80,0.00,0.00,0.69,47.61,'2023-03-04 18:18:37','',''),(5347,'1','310','1',1,'Retail Sale Id 5213',2160.00,0.00,0.00,3.00,207.00,'2023-03-04 18:19:38','',''),(5348,'1','310','1',1,'Retail Sale Id 5214',2160.00,0.00,0.00,3.00,207.00,'2023-03-04 18:21:08','',''),(5349,'1','310','1',1,'Retail Sale Id 5215',2001.60,0.00,0.00,2.78,191.82,'2023-03-04 18:22:43','',''),(5350,'1','310','1',1,'Retail Sale Id 5217',18000.00,0.00,0.00,25.00,1725.00,'2023-03-04 18:37:04','',''),(5351,'1','310','1',1,'Retail Sale Id 5218',3002.40,0.00,0.00,4.17,287.73,'2023-03-04 18:38:02','',''),(5352,'1','310','1',1,'Retail Sale Id 5219',2001.60,0.00,0.00,2.78,191.82,'2023-03-04 18:39:28','',''),(5353,'1','310','1',1,'Retail Sale Id 5220',4320.00,0.00,0.00,6.00,414.00,'2023-03-04 18:40:40','',''),(5354,'1','310','1',1,'Retail Sale Id 5221',3499.20,0.00,0.00,4.86,335.34,'2023-03-04 18:41:53','',''),(5355,'1','310','1',1,'Retail Sale Id 5222',4996.80,0.00,0.00,6.94,478.86,'2023-03-04 18:42:48','',''),(5356,'1','310','1',1,'Retail Sale Id 5223',35000.00,0.00,0.00,50.00,2450.00,'2023-03-04 18:45:27','',''),(5357,'1','310','1',1,'Retail Sale Id 5224',5040.00,0.00,0.00,7.00,483.00,'2023-03-04 18:46:35','',''),(5358,'1','310','1',1,'Retail Sale Id 5225',4320.00,0.00,0.00,6.00,414.00,'2023-03-04 18:47:56','',''),(5359,'1','310','1',1,'Retail Sale Id 5226',1699.20,0.00,0.00,2.36,162.84,'2023-03-04 18:53:53','',''),(5360,'1','310','1',1,'Return of Retail Sale Id 5217',0.00,18000.00,25.00,0.00,-1725.00,'2023-03-04 19:53:51','',''),(5361,'1','310','1',1,'Retail Sale Id 5227',7495.20,0.00,0.00,10.41,718.29,'2023-03-04 19:54:25','',''),(5362,'1','310','1',1,'Return of Retail Sale Id 5122',0.00,2450.00,3.50,0.00,-171.50,'2023-03-04 19:56:09','',''),(5363,'1','310','1',1,'Retail Sale Id 5228',2436.00,0.00,0.00,3.48,170.52,'2023-03-04 19:57:32','',''),(5364,'1','310','1',1,'Retail Sale Id 5229',42000.00,0.00,0.00,60.00,2940.00,'2023-03-05 07:21:47','',''),(5365,'1','310','1',1,'Retail Sale Id 5230',4996.80,0.00,0.00,6.94,478.86,'2023-03-05 07:34:58','',''),(5366,'1','310','1',1,'Retail Sale Id 5231',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 07:48:46','',''),(5367,'1','310','1',1,'Retail Sale Id 5232',1497.60,0.00,0.00,2.08,143.52,'2023-03-05 07:52:35','',''),(5368,'1','310','1',1,'Retail Sale Id 5233',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 08:23:19','',''),(5369,'1','310','1',1,'Retail Sale Id 5234',2001.60,0.00,0.00,2.78,191.82,'2023-03-05 08:25:00','',''),(5370,'1','310','1',1,'Retail Sale Id 5235',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 08:27:08','',''),(5371,'1','310','1',1,'Retail Sale Id 5235',7200.00,0.00,0.00,10.00,690.00,'2023-03-05 08:27:08','',''),(5372,'1','310','1',1,'Retail Sale Id 5236',4348.80,0.00,0.00,6.04,416.76,'2023-03-05 08:30:48','',''),(5373,'1','310','1',1,'Retail Sale Id 5237',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 08:31:52','',''),(5374,'1','310','1',1,'Retail Sale Id 5238',2498.40,0.00,0.00,3.47,239.43,'2023-03-05 08:33:11','',''),(5375,'1','310','1',1,'Retail Sale Id 5239',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 08:34:36','',''),(5376,'1','310','1',1,'Retail Sale Id 5240',7200.00,0.00,0.00,10.00,690.00,'2023-03-05 08:45:16','',''),(5377,'1','310','1',1,'Retail Sale Id 5241',3600.00,0.00,0.00,5.00,345.00,'2023-03-05 08:56:47','',''),(5378,'1','310','1',1,'Retail Sale Id 5242',2001.60,0.00,0.00,2.78,191.82,'2023-03-05 08:59:04','',''),(5379,'1','310','1',1,'Retail Sale Id 5242',2001.60,0.00,0.00,2.78,191.82,'2023-03-05 08:59:04','',''),(5380,'1','310','1',1,'Retail Sale Id 5243',698.40,0.00,0.00,0.97,66.93,'2023-03-05 08:59:41','',''),(5381,'1','310','1',1,'Retail Sale Id 5244',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 09:00:47','',''),(5382,'1','310','1',1,'Retail Sale Id 5245',2001.60,0.00,0.00,2.78,191.82,'2023-03-05 09:03:57','',''),(5383,'1','310','1',1,'Retail Sale Id 5246',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 09:07:53','',''),(5384,'1','310','1',1,'Retail Sale Id 5247',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 09:09:32','',''),(5385,'1','310','1',1,'Retail Sale Id 5248',1497.60,0.00,0.00,2.08,143.52,'2023-03-05 09:11:23','',''),(5386,'1','310','1',1,'Retail Sale Id 5249',2001.60,0.00,0.00,2.78,191.82,'2023-03-05 09:12:13','',''),(5387,'1','310','1',1,'Retail Sale Id 5250',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 09:13:14','',''),(5388,'1','310','1',1,'Retail Sale Id 5251',3002.40,0.00,0.00,4.17,287.73,'2023-03-05 09:14:13','',''),(5389,'1','310','1',1,'Retail Sale Id 5252',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 09:15:21','',''),(5390,'1','310','1',1,'Retail Sale Id 5253',14700.00,0.00,0.00,21.00,1029.00,'2023-03-05 09:27:58','',''),(5391,'1','310','1',1,'Retail Sale Id 5254',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 09:29:35','',''),(5392,'1','310','1',1,'Retail Sale Id 5255',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 09:39:39','',''),(5393,'1','310','1',1,'Retail Sale Id 5256',1498.00,0.00,0.00,2.14,104.86,'2023-03-05 09:43:48','',''),(5394,'1','310','1',1,'Retail Sale Id 5257',1497.60,0.00,0.00,2.08,143.52,'2023-03-05 09:45:02','',''),(5395,'1','310','1',1,'Retail Sale Id 5258',1000.80,0.00,0.00,1.39,95.91,'2023-03-05 09:50:17','',''),(5396,'1','310','1',1,'Retail Sale Id 5259',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 09:56:02','',''),(5397,'1','310','1',1,'Retail Sale Id 5260',4996.80,0.00,0.00,6.94,478.86,'2023-03-05 09:57:20','',''),(5398,'1','310','1',1,'Retail Sale Id 5261',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 10:02:38','',''),(5399,'1','310','1',1,'Retail Sale Id 5262',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 10:05:05','',''),(5400,'1','310','1',1,'Retail Sale Id 5263',3002.40,0.00,0.00,4.17,287.73,'2023-03-05 10:07:00','',''),(5401,'1','310','1',1,'Retail Sale Id 5264',1598.40,0.00,0.00,2.22,153.18,'2023-03-05 10:10:41','',''),(5402,'1','310','1',1,'Retail Sale Id 5265',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 10:11:50','',''),(5403,'1','310','1',1,'Retail Sale Id 5266',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 10:12:51','',''),(5404,'1','310','1',1,'Retail Sale Id 5267',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 10:14:36','',''),(5405,'1','310','1',1,'Retail Sale Id 5268',77700.00,0.00,0.00,111.00,5439.00,'2023-03-05 10:20:15','',''),(5406,'1','310','1',1,'Retail Sale Id 5269',3600.00,0.00,0.00,5.00,345.00,'2023-03-05 10:21:15','',''),(5407,'1','310','1',1,'Retail Sale Id 5270',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 10:22:29','',''),(5408,'1','310','1',1,'Retail Sale Id 5271',2001.60,0.00,0.00,2.78,191.82,'2023-03-05 10:27:03','',''),(5409,'1','310','1',1,'Retail Sale Id 5272',1000.80,0.00,0.00,1.39,95.91,'2023-03-05 10:27:48','',''),(5410,'1','310','1',1,'Retail Sale Id 5273',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 10:33:58','',''),(5411,'1','310','1',1,'Retail Sale Id 5274',1000.80,0.00,0.00,1.39,95.91,'2023-03-05 10:45:21','',''),(5412,'1','310','1',1,'Retail Sale Id 5275',2296.80,0.00,0.00,3.19,220.11,'2023-03-05 10:47:11','',''),(5413,'1','310','1',1,'Retail Sale Id 5276',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 10:51:18','',''),(5414,'1','310','1',1,'Retail Sale Id 5277',3600.00,0.00,0.00,5.00,345.00,'2023-03-05 10:52:35','',''),(5415,'1','310','1',1,'Retail Sale Id 5278',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 10:53:44','',''),(5416,'1','310','1',1,'Retail Sale Id 5279',3002.40,0.00,0.00,4.17,287.73,'2023-03-05 10:54:49','',''),(5417,'1','310','1',1,'Retail Sale Id 5280',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 11:03:34','',''),(5418,'1','310','1',1,'Retail Sale Id 5281',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 11:07:53','',''),(5419,'1','310','1',1,'Retail Sale Id 5282',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 11:15:13','',''),(5420,'1','310','1',1,'Retail Sale Id 5283',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 11:16:31','',''),(5421,'1','310','1',1,'Retail Sale Id 5284',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 11:17:39','',''),(5422,'1','310','1',1,'Retail Sale Id 5285',2001.60,0.00,0.00,2.78,191.82,'2023-03-05 11:45:06','',''),(5423,'1','310','1',1,'Retail Sale Id 5286',3002.40,0.00,0.00,4.17,287.73,'2023-03-05 11:46:51','',''),(5424,'1','310','1',1,'Retail Sale Id 5287',2001.60,0.00,0.00,2.78,191.82,'2023-03-05 11:49:02','',''),(5425,'1','310','1',1,'Retail Sale Id 5288',2001.60,0.00,0.00,2.78,191.82,'2023-03-05 11:50:55','',''),(5426,'1','310','1',1,'Retail Sale Id 5289',5760.00,0.00,0.00,8.00,552.00,'2023-03-05 11:52:18','',''),(5427,'1','310','1',1,'Retail Sale Id 5290',35000.00,0.00,0.00,50.00,2450.00,'2023-03-05 12:08:52','',''),(5428,'1','310','1',1,'Retail Sale Id 5291',1000.80,0.00,0.00,1.39,95.91,'2023-03-05 12:09:40','',''),(5429,'1','310','1',1,'Retail Sale Id 5292',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 12:20:27','',''),(5430,'1','310','1',1,'Retail Sale Id 5292',3002.40,0.00,0.00,4.17,287.73,'2023-03-05 12:20:27','',''),(5431,'1','310','1',1,'Retail Sale Id 5293',3002.40,0.00,0.00,4.17,287.73,'2023-03-05 12:22:53','',''),(5432,'1','310','1',1,'Retail Sale Id 5293',4003.20,0.00,0.00,5.56,383.64,'2023-03-05 12:22:53','',''),(5433,'1','310','1',1,'Retail Sale Id 5296',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 12:30:05','',''),(5434,'1','310','1',1,'Retail Sale Id 5297',5040.00,0.00,0.00,7.00,483.00,'2023-03-05 12:32:09','',''),(5435,'1','310','1',1,'Retail Sale Id 5298',842.40,0.00,0.00,1.17,80.73,'2023-03-05 12:33:44','',''),(5436,'1','310','1',1,'Retail Sale Id 5299',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 12:34:36','',''),(5437,'1','310','1',1,'Retail Sale Id 5300',3600.00,0.00,0.00,5.00,345.00,'2023-03-05 12:35:46','',''),(5438,'1','310','1',1,'Retail Sale Id 5301',4500.00,0.00,0.00,6.25,431.25,'2023-03-05 12:38:15','',''),(5439,'1','310','1',1,'Retail Sale Id 5302',496.80,0.00,0.00,0.69,47.61,'2023-03-05 12:39:35','',''),(5440,'1','310','1',1,'Retail Sale Id 5303',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 12:54:35','',''),(5441,'1','310','1',1,'Retail Sale Id 5304',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 12:57:05','',''),(5442,'1','310','1',1,'Retail Sale Id 5305',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 13:00:58','',''),(5443,'1','310','1',1,'Retail Sale Id 5306',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 13:02:03','',''),(5444,'1','310','1',1,'Retail Sale Id 5307',2001.60,0.00,0.00,2.78,191.82,'2023-03-05 13:02:53','',''),(5445,'1','310','1',1,'Retail Sale Id 5308',1497.60,0.00,0.00,2.08,143.52,'2023-03-05 13:16:35','',''),(5446,'1','310','1',1,'Retail Sale Id 5309',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 13:17:52','',''),(5447,'1','310','1',1,'Retail Sale Id 5310',4996.80,0.00,0.00,6.94,478.86,'2023-03-05 13:20:26','',''),(5448,'1','310','1',1,'Retail Sale Id 5311',7920.00,0.00,0.00,11.00,759.00,'2023-03-05 13:21:45','',''),(5449,'1','310','1',1,'Retail Sale Id 5312',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 13:24:27','',''),(5450,'1','310','1',1,'Retail Sale Id 5312',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 13:24:27','',''),(5451,'1','310','1',1,'Retail Sale Id 5312',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 13:24:27','',''),(5452,'1','310','1',1,'Retail Sale Id 5313',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 13:25:58','',''),(5453,'1','310','1',1,'Retail Sale Id 5314',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 13:31:08','',''),(5454,'1','310','1',1,'Retail Sale Id 5315',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 13:33:57','',''),(5455,'1','310','1',1,'Retail Sale Id 5316',3600.00,0.00,0.00,5.00,345.00,'2023-03-05 13:35:47','',''),(5456,'1','310','1',1,'Retail Sale Id 5317',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 13:41:27','',''),(5457,'1','310','1',1,'Retail Sale Id 5319',4399.20,0.00,0.00,6.11,421.59,'2023-03-05 13:43:39','',''),(5458,'1','310','1',1,'Retail Sale Id 5320',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 13:45:25','',''),(5459,'1','310','1',1,'Retail Sale Id 5321',2001.60,0.00,0.00,2.78,191.82,'2023-03-05 13:57:11','',''),(5460,'1','310','1',1,'Retail Sale Id 5322',35000.00,0.00,0.00,50.00,2450.00,'2023-03-05 13:58:57','',''),(5461,'1','310','1',1,'Retail Sale Id 5323',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 14:01:54','',''),(5462,'1','310','1',1,'Retail Sale Id 5324',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 14:03:58','',''),(5463,'1','310','1',1,'Retail Sale Id 5324',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 14:03:58','',''),(5464,'1','310','1',1,'Retail Sale Id 5324',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 14:03:58','',''),(5465,'1','310','1',1,'Retail Sale Id 5325',70000.00,0.00,0.00,100.00,4900.00,'2023-03-05 14:15:34','',''),(5466,'1','310','1',1,'Retail Sale Id 5326',4996.80,0.00,0.00,6.94,478.86,'2023-03-05 14:16:30','',''),(5467,'1','310','1',1,'Retail Sale Id 5326',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 14:16:30','',''),(5468,'1','310','1',1,'Retail Sale Id 5327',5760.00,0.00,0.00,8.00,552.00,'2023-03-05 14:27:26','',''),(5469,'1','310','1',1,'Retail Sale Id 5328',720.00,0.00,0.00,1.00,69.00,'2023-03-05 14:34:44','',''),(5470,'1','310','1',1,'Retail Sale Id 5329',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 14:38:42','',''),(5471,'1','310','1',1,'Retail Sale Id 5330',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 14:41:10','',''),(5472,'1','310','1',1,'Retail Sale Id 5330',3600.00,0.00,0.00,5.00,345.00,'2023-03-05 14:41:10','',''),(5473,'1','310','1',1,'Retail Sale Id 5331',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 14:49:54','',''),(5474,'1','310','1',1,'Retail Sale Id 5332',14400.00,0.00,0.00,20.00,1380.00,'2023-03-05 14:52:09','',''),(5475,'1','310','1',1,'Retail Sale Id 5333',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 14:53:51','',''),(5476,'1','310','1',1,'Retail Sale Id 5334',98000.00,0.00,0.00,140.00,6860.00,'2023-03-05 14:57:20','',''),(5477,'1','310','1',1,'Retail Sale Id 5335',720.00,0.00,0.00,1.00,69.00,'2023-03-05 15:00:15','',''),(5478,'1','310','1',1,'Retail Sale Id 5336',3600.00,0.00,0.00,5.00,345.00,'2023-03-05 15:10:07','',''),(5479,'1','310','1',1,'Retail Sale Id 5337',2498.40,0.00,0.00,3.47,239.43,'2023-03-05 15:14:15','',''),(5480,'1','310','1',1,'Retail Sale Id 5338',4996.80,0.00,0.00,6.94,478.86,'2023-03-05 15:16:01','',''),(5481,'1','310','1',1,'Retail Sale Id 5340',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 15:23:20','',''),(5482,'1','310','1',1,'Retail Sale Id 5342',25900.00,0.00,0.00,37.00,1813.00,'2023-03-05 15:37:41','',''),(5483,'1','310','1',1,'Retail Sale Id 5343',3600.00,0.00,0.00,5.00,345.00,'2023-03-05 15:38:37','',''),(5484,'1','310','1',1,'Retail Sale Id 5344',1497.60,0.00,0.00,2.08,143.52,'2023-03-05 15:39:40','',''),(5485,'1','310','1',1,'Retail Sale Id 5345',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 15:49:21','',''),(5486,'1','310','1',1,'Retail Sale Id 5346',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 15:54:58','',''),(5487,'1','310','1',1,'Retail Sale Id 5347',1000.80,0.00,0.00,1.39,95.91,'2023-03-05 15:55:56','',''),(5488,'1','310','1',1,'Retail Sale Id 5348',4003.20,0.00,0.00,5.56,383.64,'2023-03-05 15:57:35','',''),(5489,'1','310','1',1,'Retail Sale Id 5349',3600.00,0.00,0.00,5.00,345.00,'2023-03-05 15:58:21','',''),(5490,'1','310','1',1,'Retail Sale Id 5350',4399.20,0.00,0.00,6.11,421.59,'2023-03-05 16:05:43','',''),(5491,'1','310','1',1,'Retail Sale Id 5351',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 16:09:01','',''),(5492,'1','310','1',1,'Retail Sale Id 5352',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 16:11:29','',''),(5493,'1','310','1',1,'Retail Sale Id 5353',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 16:23:38','',''),(5494,'1','310','1',1,'Retail Sale Id 5353',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 16:23:38','',''),(5495,'1','310','1',1,'Retail Sale Id 5354',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 16:25:18','',''),(5496,'1','310','1',1,'Retail Sale Id 5355',7200.00,0.00,0.00,10.00,690.00,'2023-03-05 16:28:02','',''),(5497,'1','310','1',1,'Retail Sale Id 5356',3002.40,0.00,0.00,4.17,287.73,'2023-03-05 16:38:24','',''),(5498,'1','310','1',1,'Retail Sale Id 5357',4003.20,0.00,0.00,5.56,383.64,'2023-03-05 16:40:52','',''),(5499,'1','310','1',1,'Retail Sale Id 5358',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 16:42:49','',''),(5500,'1','310','1',1,'Retail Sale Id 5360',2498.40,0.00,0.00,3.47,239.43,'2023-03-05 16:46:02','',''),(5501,'1','310','1',1,'Retail Sale Id 5361',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 16:47:27','',''),(5502,'1','310','1',1,'Retail Sale Id 5361',5760.00,0.00,0.00,8.00,552.00,'2023-03-05 16:47:27','',''),(5503,'1','310','1',1,'Retail Sale Id 5362',2001.60,0.00,0.00,2.78,191.82,'2023-03-05 16:48:55','',''),(5504,'1','310','1',1,'Retail Sale Id 5363',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 16:51:02','',''),(5505,'1','310','1',1,'Retail Sale Id 5364',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 16:51:54','',''),(5506,'1','310','1',1,'Retail Sale Id 5365',2001.60,0.00,0.00,2.78,191.82,'2023-03-05 16:55:28','',''),(5507,'1','310','1',1,'Retail Sale Id 5366',1497.60,0.00,0.00,2.08,143.52,'2023-03-05 17:04:41','',''),(5508,'1','310','1',1,'Retail Sale Id 5368',3002.40,0.00,0.00,4.17,287.73,'2023-03-05 17:06:23','',''),(5509,'1','310','1',1,'Retail Sale Id 5369',1000.80,0.00,0.00,1.39,95.91,'2023-03-05 17:11:05','',''),(5510,'1','310','1',1,'Retail Sale Id 5369',2001.60,0.00,0.00,2.78,191.82,'2023-03-05 17:11:05','',''),(5511,'1','310','1',1,'Retail Sale Id 5370',2001.60,0.00,0.00,2.78,191.82,'2023-03-05 17:14:30','',''),(5512,'1','310','1',1,'Retail Sale Id 5371',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 17:15:38','',''),(5513,'1','310','1',1,'Retail Sale Id 5372',3600.00,0.00,0.00,5.00,345.00,'2023-03-05 17:17:05','',''),(5514,'1','310','1',1,'Retail Sale Id 5373',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 17:18:37','',''),(5515,'1','310','1',1,'Retail Sale Id 5374',3002.40,0.00,0.00,4.17,287.73,'2023-03-05 17:25:30','',''),(5516,'1','310','1',1,'Retail Sale Id 5375',1000.80,0.00,0.00,1.39,95.91,'2023-03-05 17:28:13','',''),(5517,'1','310','1',1,'Retail Sale Id 5376',2203.20,0.00,0.00,3.06,211.14,'2023-03-05 17:29:22','',''),(5518,'1','310','1',1,'Retail Sale Id 5377',3002.40,0.00,0.00,4.17,287.73,'2023-03-05 17:30:23','',''),(5519,'1','310','1',1,'Retail Sale Id 5378',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 17:36:16','',''),(5520,'1','310','1',1,'Retail Sale Id 5379',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 17:38:28','',''),(5521,'1','310','1',1,'Retail Sale Id 5380',2001.60,0.00,0.00,2.78,191.82,'2023-03-05 17:40:02','',''),(5522,'1','310','1',1,'Retail Sale Id 5381',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 17:41:20','',''),(5523,'1','310','1',1,'Retail Sale Id 5382',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 17:42:45','',''),(5524,'1','310','1',1,'Retail Sale Id 5383',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 17:43:59','',''),(5525,'1','310','1',1,'Retail Sale Id 5384',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 17:46:23','',''),(5526,'1','310','1',1,'Retail Sale Id 5385',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 17:47:27','',''),(5527,'1','310','1',1,'Retail Sale Id 5386',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 17:48:43','',''),(5528,'1','310','1',1,'Retail Sale Id 5386',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 17:48:43','',''),(5529,'1','310','1',1,'Retail Sale Id 5387',2520.00,0.00,0.00,3.50,241.50,'2023-03-05 17:53:03','',''),(5530,'1','310','1',1,'Retail Sale Id 5388',1497.60,0.00,0.00,2.08,143.52,'2023-03-05 17:54:47','',''),(5531,'1','310','1',1,'Retail Sale Id 5389',2160.00,0.00,0.00,3.00,207.00,'2023-03-05 17:55:54','',''),(5532,'1','310','1',1,'Retail Sale Id 5390',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 17:56:41','',''),(5533,'1','310','1',1,'Retail Sale Id 5391',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 17:57:31','',''),(5534,'1','310','1',1,'Retail Sale Id 5392',2001.60,0.00,0.00,2.78,191.82,'2023-03-05 17:58:19','',''),(5535,'1','310','1',1,'Retail Sale Id 5393',4003.20,0.00,0.00,5.56,383.64,'2023-03-05 17:59:05','',''),(5536,'1','310','1',1,'Retail Sale Id 5394',1497.60,0.00,0.00,2.08,143.52,'2023-03-05 18:03:56','',''),(5537,'1','310','1',1,'Retail Sale Id 5395',3600.00,0.00,0.00,5.00,345.00,'2023-03-05 18:05:04','',''),(5538,'1','310','1',1,'Retail Sale Id 5396',4320.00,0.00,0.00,6.00,414.00,'2023-03-05 18:14:34','',''),(5539,'1','310','1',1,'Retail Sale Id 5397',4996.80,0.00,0.00,6.94,478.86,'2023-03-05 18:15:18','',''),(5540,'1','310','1',1,'Retail Sale Id 5398',3600.00,0.00,0.00,5.00,345.00,'2023-03-05 18:17:22','',''),(5541,'1','310','1',1,'Retail Sale Id 5398',9000.00,0.00,0.00,12.50,862.50,'2023-03-05 18:17:22','',''),(5542,'1','310','1',1,'Retail Sale Id 5399',2001.60,0.00,0.00,2.78,191.82,'2023-03-05 18:35:26','',''),(5543,'1','310','1',1,'Retail Sale Id 5400',21247.20,0.00,0.00,29.51,2036.19,'2023-03-05 19:46:35','',''),(5544,'1','310','1',1,'Return of Retail Sale Id 5360',0.00,2498.40,3.47,0.00,-239.43,'2023-03-05 19:49:06','',''),(5545,'1','310','1',1,'Retail Sale Id 5401',2498.40,0.00,0.00,3.47,239.43,'2023-03-05 19:54:00','',''),(5546,'1','310','1',1,'Return of Retail Sale Id 5256',0.00,1498.00,2.14,0.00,-104.86,'2023-03-05 19:56:41','',''),(5547,'1','310','1',1,'Retail Sale Id 5402',1498.00,0.00,0.00,2.14,104.86,'2023-03-05 19:58:16','',''),(5548,'1','310','1',1,'Retail Sale Id 5403',4320.00,0.00,0.00,6.00,414.00,'2023-03-06 07:37:32','',''),(5549,'1','310','1',1,'Retail Sale Id 5404',9000.00,0.00,0.00,12.50,862.50,'2023-03-06 07:47:31','',''),(5550,'1','310','1',1,'Retail Sale Id 5405',4320.00,0.00,0.00,6.00,414.00,'2023-03-06 07:54:15','',''),(5551,'1','310','1',1,'Retail Sale Id 5406',9000.00,0.00,0.00,12.50,862.50,'2023-03-06 08:07:54','',''),(5552,'1','310','1',1,'Retail Sale Id 5407',3600.00,0.00,0.00,5.00,345.00,'2023-03-06 08:10:42','',''),(5553,'1','310','1',1,'Retail Sale Id 5408',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 08:12:22','',''),(5554,'1','310','1',1,'Retail Sale Id 5409',1440.00,0.00,0.00,2.00,138.00,'2023-03-06 08:24:17','',''),(5555,'1','310','1',1,'Retail Sale Id 5410',30002.00,0.00,0.00,42.86,2100.14,'2023-03-06 08:26:39','',''),(5556,'1','310','1',1,'Retail Sale Id 5411',4320.00,0.00,0.00,6.00,414.00,'2023-03-06 08:33:48','',''),(5557,'1','310','1',1,'Retail Sale Id 5412',4320.00,0.00,0.00,6.00,414.00,'2023-03-06 08:35:43','',''),(5558,'1','310','1',1,'Retail Sale Id 5413',4003.20,0.00,0.00,5.56,383.64,'2023-03-06 08:55:03','',''),(5559,'1','310','1',1,'Retail Sale Id 5414',4996.80,0.00,0.00,6.94,478.86,'2023-03-06 08:58:49','',''),(5560,'1','310','1',1,'Retail Sale Id 5415',1497.60,0.00,0.00,2.08,143.52,'2023-03-06 09:05:42','',''),(5561,'1','310','1',1,'Retail Sale Id 5416',7200.00,0.00,0.00,10.00,690.00,'2023-03-06 09:11:37','',''),(5562,'1','310','1',1,'Retail Sale Id 5417',35000.00,0.00,0.00,50.00,2450.00,'2023-03-06 09:29:29','',''),(5563,'1','310','1',1,'Retail Sale Id 5418',1900.80,0.00,0.00,2.64,182.16,'2023-03-06 09:44:39','',''),(5564,'1','310','1',1,'Retail Sale Id 5419',2001.60,0.00,0.00,2.78,191.82,'2023-03-06 09:49:04','',''),(5565,'1','310','1',1,'Retail Sale Id 5419',3002.40,0.00,0.00,4.17,287.73,'2023-03-06 09:49:04','',''),(5566,'1','310','1',1,'Retail Sale Id 5420',4399.20,0.00,0.00,6.11,421.59,'2023-03-06 09:52:37','',''),(5567,'1','310','1',1,'Retail Sale Id 5421',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 09:53:38','',''),(5568,'1','310','1',1,'Retail Sale Id 5422',9000.00,0.00,0.00,12.50,862.50,'2023-03-06 09:54:50','',''),(5569,'1','310','1',1,'Retail Sale Id 5423',4003.20,0.00,0.00,5.56,383.64,'2023-03-06 10:00:13','',''),(5570,'1','310','1',1,'Retail Sale Id 5424',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 10:06:18','',''),(5571,'1','310','1',1,'Retail Sale Id 5425',2001.60,0.00,0.00,2.78,191.82,'2023-03-06 10:07:45','',''),(5572,'1','310','1',1,'Retail Sale Id 5425',2001.60,0.00,0.00,2.78,191.82,'2023-03-06 10:07:45','',''),(5573,'1','310','1',1,'Retail Sale Id 5426',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 10:14:08','',''),(5574,'1','310','1',1,'Retail Sale Id 5427',3002.40,0.00,0.00,4.17,287.73,'2023-03-06 10:18:22','',''),(5575,'1','310','1',1,'Retail Sale Id 5428',2001.60,0.00,0.00,2.78,191.82,'2023-03-06 10:19:36','',''),(5576,'1','310','1',1,'Retail Sale Id 5429',4320.00,0.00,0.00,6.00,414.00,'2023-03-06 10:25:26','',''),(5577,'1','310','1',1,'Retail Sale Id 5430',496.80,0.00,0.00,0.69,47.61,'2023-03-06 10:30:16','',''),(5578,'1','310','1',1,'Retail Sale Id 5431',3600.00,0.00,0.00,5.00,345.00,'2023-03-06 10:32:53','',''),(5579,'1','310','1',1,'Retail Sale Id 5432',7999.20,0.00,0.00,11.11,766.59,'2023-03-06 10:34:28','',''),(5580,'1','310','1',1,'Retail Sale Id 5434',2901.60,0.00,0.00,4.03,278.07,'2023-03-06 10:47:09','',''),(5581,'1','310','1',1,'Retail Sale Id 5435',1497.60,0.00,0.00,2.08,143.52,'2023-03-06 10:48:02','',''),(5582,'1','310','1',1,'Retail Sale Id 5436',2001.60,0.00,0.00,2.78,191.82,'2023-03-06 10:48:56','',''),(5583,'1','310','1',1,'Retail Sale Id 5437',9000.00,0.00,0.00,12.50,862.50,'2023-03-06 10:54:04','',''),(5584,'1','310','1',1,'Retail Sale Id 5438',4320.00,0.00,0.00,6.00,414.00,'2023-03-06 10:55:35','',''),(5585,'1','310','1',1,'Retail Sale Id 5440',1000.80,0.00,0.00,1.39,95.91,'2023-03-06 10:59:13','',''),(5586,'1','310','1',1,'Retail Sale Id 5441',496.80,0.00,0.00,0.69,47.61,'2023-03-06 11:00:14','',''),(5587,'1','310','1',1,'Retail Sale Id 5442',9000.00,0.00,0.00,12.50,862.50,'2023-03-06 11:01:37','',''),(5588,'1','310','1',1,'Retail Sale Id 5442',9000.00,0.00,0.00,12.50,862.50,'2023-03-06 11:01:37','',''),(5589,'1','310','1',1,'Retail Sale Id 5443',4320.00,0.00,0.00,6.00,414.00,'2023-03-06 11:02:47','',''),(5590,'1','310','1',1,'Retail Sale Id 5444',9360.00,0.00,0.00,13.00,897.00,'2023-03-06 11:04:15','',''),(5591,'1','310','1',1,'Retail Sale Id 5445',4320.00,0.00,0.00,6.00,414.00,'2023-03-06 11:08:09','',''),(5592,'1','310','1',1,'Retail Sale Id 5446',2001.60,0.00,0.00,2.78,191.82,'2023-03-06 11:15:13','',''),(5593,'1','310','1',1,'Retail Sale Id 5447',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 11:19:03','',''),(5594,'1','310','1',1,'Retail Sale Id 5448',9000.00,0.00,0.00,12.50,862.50,'2023-03-06 11:19:52','',''),(5595,'1','310','1',1,'Retail Sale Id 5449',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 11:23:08','',''),(5596,'1','310','1',1,'Retail Sale Id 5450',8400.00,0.00,0.00,12.00,588.00,'2023-03-06 11:25:16','',''),(5597,'1','310','1',1,'Retail Sale Id 5451',2001.60,0.00,0.00,2.78,191.82,'2023-03-06 11:34:48','',''),(5598,'1','310','1',1,'Retail Sale Id 5452',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 11:37:10','',''),(5599,'1','310','1',1,'Retail Sale Id 5453',9000.00,0.00,0.00,12.50,862.50,'2023-03-06 11:37:56','',''),(5600,'1','310','1',1,'Retail Sale Id 5454',4320.00,0.00,0.00,6.00,414.00,'2023-03-06 11:42:12','',''),(5601,'1','310','1',1,'Retail Sale Id 5455',35000.00,0.00,0.00,50.00,2450.00,'2023-03-06 11:47:25','',''),(5602,'1','310','1',1,'Retail Sale Id 5456',4320.00,0.00,0.00,6.00,414.00,'2023-03-06 11:48:23','',''),(5603,'1','310','1',1,'Retail Sale Id 5457',4320.00,0.00,0.00,6.00,414.00,'2023-03-06 11:56:16','',''),(5604,'1','310','1',1,'Retail Sale Id 5458',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 11:59:12','',''),(5605,'1','310','1',1,'Retail Sale Id 5459',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 12:06:22','',''),(5606,'1','310','1',1,'Retail Sale Id 5461',9000.00,0.00,0.00,12.50,862.50,'2023-03-06 12:11:30','',''),(5607,'1','310','1',1,'Retail Sale Id 5462',9000.00,0.00,0.00,12.50,862.50,'2023-03-06 12:25:14','',''),(5608,'1','310','1',1,'Retail Sale Id 5464',3002.40,0.00,0.00,4.17,287.73,'2023-03-06 12:35:24','',''),(5609,'1','310','1',1,'Retail Sale Id 5465',4320.00,0.00,0.00,6.00,414.00,'2023-03-06 12:37:01','',''),(5610,'1','310','1',1,'Retail Sale Id 5466',4320.00,0.00,0.00,6.00,414.00,'2023-03-06 12:40:55','',''),(5611,'1','310','1',1,'Retail Sale Id 5467',1000.80,0.00,0.00,1.39,95.91,'2023-03-06 13:06:52','',''),(5612,'1','310','1',1,'Retail Sale Id 5468',496.80,0.00,0.00,0.69,47.61,'2023-03-06 13:12:31','',''),(5613,'1','310','1',1,'Retail Sale Id 5469',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 13:13:43','',''),(5614,'1','310','1',1,'Retail Sale Id 5470',2001.60,0.00,0.00,2.78,191.82,'2023-03-06 13:14:47','',''),(5615,'1','310','1',1,'Retail Sale Id 5471',1497.60,0.00,0.00,2.08,143.52,'2023-03-06 13:18:31','',''),(5616,'1','310','1',1,'Retail Sale Id 5472',65100.00,0.00,0.00,93.00,4557.00,'2023-03-06 13:20:50','',''),(5617,'1','310','1',1,'Retail Sale Id 5473',9000.00,0.00,0.00,12.50,862.50,'2023-03-06 13:22:19','',''),(5618,'1','310','1',1,'Retail Sale Id 5474',547.20,0.00,0.00,0.76,52.44,'2023-03-06 13:24:50','',''),(5619,'1','310','1',1,'Retail Sale Id 5476',496.80,0.00,0.00,0.69,47.61,'2023-03-06 13:44:18','',''),(5620,'1','310','1',1,'Retail Sale Id 5477',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 13:45:54','',''),(5621,'1','310','1',1,'Retail Sale Id 5478',7200.00,0.00,0.00,10.00,690.00,'2023-03-06 13:49:30','',''),(5622,'1','310','1',1,'Retail Sale Id 5480',7920.00,0.00,0.00,11.00,759.00,'2023-03-06 14:20:31','',''),(5623,'1','310','1',1,'Retail Sale Id 5481',4320.00,0.00,0.00,6.00,414.00,'2023-03-06 14:34:49','',''),(5624,'1','310','1',1,'Retail Sale Id 5482',4320.00,0.00,0.00,6.00,414.00,'2023-03-06 14:37:18','',''),(5625,'1','310','1',1,'Retail Sale Id 5483',70000.00,0.00,0.00,100.00,4900.00,'2023-03-06 14:44:02','',''),(5626,'1','310','1',1,'Retail Sale Id 5484',2498.40,0.00,0.00,3.47,239.43,'2023-03-06 14:47:04','',''),(5627,'1','310','1',1,'Retail Sale Id 5485',9000.00,0.00,0.00,12.50,862.50,'2023-03-06 14:49:42','',''),(5628,'1','310','1',1,'Retail Sale Id 5486',9000.00,0.00,0.00,12.50,862.50,'2023-03-06 14:50:50','',''),(5629,'1','310','1',1,'Retail Sale Id 5487',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 14:56:36','',''),(5630,'1','310','1',1,'Retail Sale Id 5488',1000.80,0.00,0.00,1.39,95.91,'2023-03-06 15:00:59','',''),(5631,'1','310','1',1,'Retail Sale Id 5489',105000.00,0.00,0.00,150.00,7350.00,'2023-03-06 15:14:36','',''),(5632,'1','310','1',1,'Retail Sale Id 5490',21000.00,0.00,0.00,30.00,1470.00,'2023-03-06 15:17:52','',''),(5633,'1','310','1',1,'Retail Sale Id 5491',2001.60,0.00,0.00,2.78,191.82,'2023-03-06 15:31:05','',''),(5634,'1','310','1',1,'Retail Sale Id 5492',1440.00,0.00,0.00,2.00,138.00,'2023-03-06 15:34:36','',''),(5635,'1','310','1',1,'Retail Sale Id 5493',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 15:36:44','',''),(5636,'1','310','1',1,'Retail Sale Id 5494',9000.00,0.00,0.00,12.50,862.50,'2023-03-06 15:47:42','',''),(5637,'1','310','1',1,'Retail Sale Id 5495',1000.80,0.00,0.00,1.39,95.91,'2023-03-06 16:14:44','',''),(5638,'1','310','1',1,'Retail Sale Id 5496',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 16:28:03','',''),(5639,'1','310','1',1,'Retail Sale Id 5497',4320.00,0.00,0.00,6.00,414.00,'2023-03-06 16:41:31','',''),(5640,'1','310','1',1,'Retail Sale Id 5498',1000.80,0.00,0.00,1.39,95.91,'2023-03-06 16:42:52','',''),(5641,'1','310','1',1,'Retail Sale Id 5499',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 16:49:18','',''),(5642,'1','310','1',1,'Retail Sale Id 5500',4320.00,0.00,0.00,6.00,414.00,'2023-03-06 16:52:00','',''),(5643,'1','310','1',1,'Retail Sale Id 5501',1000.80,0.00,0.00,1.39,95.91,'2023-03-06 16:54:42','',''),(5644,'1','310','1',1,'Retail Sale Id 5502',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 17:00:08','',''),(5645,'1','310','1',1,'Retail Sale Id 5503',32400.00,0.00,0.00,45.00,3105.00,'2023-03-06 17:05:20','',''),(5646,'1','310','1',1,'Retail Sale Id 5504',35000.00,0.00,0.00,50.00,2450.00,'2023-03-06 17:06:53','',''),(5647,'1','310','1',1,'Retail Sale Id 5505',2880.00,0.00,0.00,4.00,276.00,'2023-03-06 17:08:33','',''),(5648,'1','310','1',1,'Retail Sale Id 5506',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 17:09:30','',''),(5649,'1','310','1',1,'Retail Sale Id 5507',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 17:12:09','',''),(5650,'1','310','1',1,'Retail Sale Id 5508',9000.00,0.00,0.00,12.50,862.50,'2023-03-06 17:15:07','',''),(5651,'1','310','1',1,'Retail Sale Id 5509',496.80,0.00,0.00,0.69,47.61,'2023-03-06 17:19:09','',''),(5652,'1','310','1',1,'Retail Sale Id 5510',4320.00,0.00,0.00,6.00,414.00,'2023-03-06 17:21:30','',''),(5653,'1','310','1',1,'Retail Sale Id 5511',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 17:25:10','',''),(5654,'1','310','1',1,'Retail Sale Id 5512',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 17:27:08','',''),(5655,'1','310','1',1,'Retail Sale Id 5513',3600.00,0.00,0.00,5.00,345.00,'2023-03-06 17:30:24','',''),(5656,'1','310','1',1,'Retail Sale Id 5514',1000.80,0.00,0.00,1.39,95.91,'2023-03-06 17:41:06','',''),(5657,'1','310','1',1,'Retail Sale Id 5515',4320.00,0.00,0.00,6.00,414.00,'2023-03-06 17:42:31','',''),(5658,'1','310','1',1,'Retail Sale Id 5516',4320.00,0.00,0.00,6.00,414.00,'2023-03-06 17:47:00','',''),(5659,'1','310','1',1,'Retail Sale Id 5517',4320.00,0.00,0.00,6.00,414.00,'2023-03-06 17:48:36','',''),(5660,'1','310','1',1,'Retail Sale Id 5518',1497.60,0.00,0.00,2.08,143.52,'2023-03-06 17:50:04','',''),(5661,'1','310','1',1,'Retail Sale Id 5519',9000.00,0.00,0.00,12.50,862.50,'2023-03-06 17:54:14','',''),(5662,'1','310','1',1,'Retail Sale Id 5520',2001.60,0.00,0.00,2.78,191.82,'2023-03-06 17:55:31','',''),(5663,'1','310','1',1,'Retail Sale Id 5521',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 17:57:24','',''),(5664,'1','310','1',1,'Retail Sale Id 5522',53200.00,0.00,0.00,76.00,3724.00,'2023-03-06 18:15:36','',''),(5665,'1','310','1',1,'Retail Sale Id 5523',7200.00,0.00,0.00,10.00,690.00,'2023-03-06 18:16:38','',''),(5666,'1','310','1',1,'Retail Sale Id 5524',9000.00,0.00,0.00,12.50,862.50,'2023-03-06 18:17:33','',''),(5667,'1','310','1',1,'Retail Sale Id 5525',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 18:18:39','',''),(5668,'1','310','1',1,'Retail Sale Id 5526',2001.60,0.00,0.00,2.78,191.82,'2023-03-06 18:21:36','',''),(5669,'1','310','1',1,'Retail Sale Id 5527',2160.00,0.00,0.00,3.00,207.00,'2023-03-06 18:23:37','',''),(5670,'1','310','1',1,'Retail Sale Id 5528',7200.00,0.00,0.00,10.00,690.00,'2023-03-06 18:28:04','',''),(5671,'1','310','1',1,'Retail Sale Id 5529',3600.00,0.00,0.00,5.00,345.00,'2023-03-06 18:36:22','',''),(5672,'1','310','1',1,'Retail Sale Id 5530',547.20,0.00,0.00,0.76,52.44,'2023-03-06 19:02:55','',''),(5673,'1','310','1',1,'Return of Retail Sale Id 5450',0.00,8400.00,12.00,0.00,-588.00,'2023-03-06 19:05:31','',''),(5674,'1','310','1',1,'Retail Sale Id 5531',8400.00,0.00,0.00,12.00,588.00,'2023-03-06 19:06:35','',''),(5675,'1','310','1',1,'Retail Sale Id 5532',1497.60,0.00,0.00,2.08,143.52,'2023-03-07 07:31:00','',''),(5676,'1','310','1',1,'Retail Sale Id 5533',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 07:48:20','',''),(5677,'1','310','1',1,'Retail Sale Id 5534',4320.00,0.00,0.00,6.00,414.00,'2023-03-07 07:56:43','',''),(5678,'1','310','1',1,'Retail Sale Id 5535',3600.00,0.00,0.00,5.00,345.00,'2023-03-07 08:03:02','',''),(5679,'1','310','1',1,'Retail Sale Id 5536',1000.80,0.00,0.00,1.39,95.91,'2023-03-07 08:24:05','',''),(5680,'1','310','1',1,'Retail Sale Id 5537',4500.00,0.00,0.00,6.25,431.25,'2023-03-07 08:25:34','',''),(5681,'1','310','1',1,'Retail Sale Id 5538',3600.00,0.00,0.00,5.00,345.00,'2023-03-07 08:26:52','',''),(5682,'1','310','1',1,'Retail Sale Id 5539',3499.20,0.00,0.00,4.86,335.34,'2023-03-07 08:41:20','',''),(5683,'1','310','1',1,'Retail Sale Id 5540',105000.00,0.00,0.00,150.00,7350.00,'2023-03-07 08:45:25','',''),(5684,'1','310','1',1,'Retail Sale Id 5541',4003.20,0.00,0.00,5.56,383.64,'2023-03-07 08:49:47','',''),(5685,'1','310','1',1,'Retail Sale Id 5542',2498.40,0.00,0.00,3.47,239.43,'2023-03-07 08:55:42','',''),(5686,'1','310','1',1,'Retail Sale Id 5543',1000.80,0.00,0.00,1.39,95.91,'2023-03-07 08:58:33','',''),(5687,'1','310','1',1,'Retail Sale Id 5544',2001.60,0.00,0.00,2.78,191.82,'2023-03-07 09:01:01','',''),(5688,'1','310','1',1,'Retail Sale Id 5545',3600.00,0.00,0.00,5.00,345.00,'2023-03-07 09:07:23','',''),(5689,'1','310','1',1,'Retail Sale Id 5546',70000.00,0.00,0.00,100.00,4900.00,'2023-03-07 09:20:19','',''),(5690,'1','310','1',1,'Retail Sale Id 5547',2001.60,0.00,0.00,2.78,191.82,'2023-03-07 09:22:21','',''),(5691,'1','310','1',1,'Retail Sale Id 5548',4320.00,0.00,0.00,6.00,414.00,'2023-03-07 09:23:31','',''),(5692,'1','310','1',1,'Retail Sale Id 5549',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 09:25:14','',''),(5693,'1','310','1',1,'Retail Sale Id 5550',1497.60,0.00,0.00,2.08,143.52,'2023-03-07 09:28:21','',''),(5694,'1','310','1',1,'Retail Sale Id 5551',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 09:42:50','',''),(5695,'1','310','1',1,'Retail Sale Id 5552',4500.00,0.00,0.00,6.25,431.25,'2023-03-07 09:53:16','',''),(5696,'1','310','1',1,'Retail Sale Id 5552',4500.00,0.00,0.00,6.25,431.25,'2023-03-07 09:53:16','',''),(5697,'1','310','1',1,'Retail Sale Id 5553',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 09:57:15','',''),(5698,'1','310','1',1,'Retail Sale Id 5554',1000.80,0.00,0.00,1.39,95.91,'2023-03-07 10:00:32','',''),(5699,'1','310','1',1,'Retail Sale Id 5555',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 10:04:22','',''),(5700,'1','310','1',1,'Retail Sale Id 5556',5040.00,0.00,0.00,7.00,483.00,'2023-03-07 10:07:14','',''),(5701,'1','310','1',1,'Retail Sale Id 5557',4320.00,0.00,0.00,6.00,414.00,'2023-03-07 10:09:28','',''),(5702,'1','310','1',1,'Retail Sale Id 5558',1000.80,0.00,0.00,1.39,95.91,'2023-03-07 10:12:04','',''),(5703,'1','310','1',1,'Retail Sale Id 5559',4320.00,0.00,0.00,6.00,414.00,'2023-03-07 10:13:54','',''),(5704,'1','310','1',1,'Retail Sale Id 5560',3600.00,0.00,0.00,5.00,345.00,'2023-03-07 10:16:14','',''),(5705,'1','310','1',1,'Retail Sale Id 5561',3600.00,0.00,0.00,5.00,345.00,'2023-03-07 10:23:55','',''),(5706,'1','310','1',1,'Retail Sale Id 5562',8750.00,0.00,0.00,12.50,612.50,'2023-03-07 10:30:54','',''),(5707,'1','310','1',1,'Retail Sale Id 5563',3600.00,0.00,0.00,5.00,345.00,'2023-03-07 10:31:31','',''),(5708,'1','310','1',1,'Retail Sale Id 5564',2160.00,0.00,0.00,3.00,207.00,'2023-03-07 10:34:06','',''),(5709,'1','310','1',1,'Retail Sale Id 5565',2160.00,0.00,0.00,3.00,207.00,'2023-03-07 10:53:42','',''),(5710,'1','310','1',1,'Retail Sale Id 5566',4320.00,0.00,0.00,6.00,414.00,'2023-03-07 11:02:48','',''),(5711,'1','310','1',1,'Retail Sale Id 5567',4320.00,0.00,0.00,6.00,414.00,'2023-03-07 11:12:19','',''),(5712,'1','310','1',1,'Retail Sale Id 5568',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 11:19:52','',''),(5713,'1','310','1',1,'Retail Sale Id 5569',2001.60,0.00,0.00,2.78,191.82,'2023-03-07 11:23:45','',''),(5714,'1','310','1',1,'Retail Sale Id 5570',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 11:34:36','',''),(5715,'1','310','1',1,'Retail Sale Id 5570',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 11:34:36','',''),(5716,'1','310','1',1,'Retail Sale Id 5571',3002.40,0.00,0.00,4.17,287.73,'2023-03-07 11:35:46','',''),(5717,'1','310','1',1,'Retail Sale Id 5572',1497.60,0.00,0.00,2.08,143.52,'2023-03-07 11:43:52','',''),(5718,'1','310','1',1,'Retail Sale Id 5572',1497.60,0.00,0.00,2.08,143.52,'2023-03-07 11:43:52','',''),(5719,'1','310','1',1,'Retail Sale Id 5573',3002.40,0.00,0.00,4.17,287.73,'2023-03-07 11:49:53','',''),(5720,'1','310','1',1,'Retail Sale Id 5574',1000.80,0.00,0.00,1.39,95.91,'2023-03-07 12:04:28','',''),(5721,'1','310','1',1,'Retail Sale Id 5575',35000.00,0.00,0.00,50.00,2450.00,'2023-03-07 12:15:35','',''),(5722,'1','310','1',1,'Retail Sale Id 5576',3002.40,0.00,0.00,4.17,287.73,'2023-03-07 12:18:16','',''),(5723,'1','310','1',1,'Retail Sale Id 5577',2152.80,0.00,0.00,2.99,206.31,'2023-03-07 12:19:25','',''),(5724,'1','310','1',1,'Retail Sale Id 5578',2001.60,0.00,0.00,2.78,191.82,'2023-03-07 12:22:50','',''),(5725,'1','310','1',1,'Retail Sale Id 5578',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 12:22:50','',''),(5726,'1','310','1',1,'Retail Sale Id 5579',4320.00,0.00,0.00,6.00,414.00,'2023-03-07 12:25:13','',''),(5727,'1','310','1',1,'Retail Sale Id 5580',35000.00,0.00,0.00,50.00,2450.00,'2023-03-07 12:27:29','',''),(5728,'1','310','1',1,'Retail Sale Id 5581',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 12:34:59','',''),(5729,'1','310','1',1,'Retail Sale Id 5582',2001.60,0.00,0.00,2.78,191.82,'2023-03-07 12:36:01','',''),(5730,'1','310','1',1,'Retail Sale Id 5583',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 12:37:11','',''),(5731,'1','310','1',1,'Retail Sale Id 5584',4996.80,0.00,0.00,6.94,478.86,'2023-03-07 12:39:06','',''),(5732,'1','310','1',1,'Retail Sale Id 5585',2160.00,0.00,0.00,3.00,207.00,'2023-03-07 12:52:10','',''),(5733,'1','310','1',1,'Retail Sale Id 5585',4320.00,0.00,0.00,6.00,414.00,'2023-03-07 12:52:10','',''),(5734,'1','310','1',1,'Retail Sale Id 5586',2160.00,0.00,0.00,3.00,207.00,'2023-03-07 13:01:59','',''),(5735,'1','310','1',1,'Retail Sale Id 5587',4320.00,0.00,0.00,6.00,414.00,'2023-03-07 13:03:44','',''),(5736,'1','310','1',1,'Retail Sale Id 5588',1000.80,0.00,0.00,1.39,95.91,'2023-03-07 13:06:25','',''),(5737,'1','310','1',1,'Retail Sale Id 5589',720.00,0.00,0.00,1.00,69.00,'2023-03-07 13:07:33','',''),(5738,'1','310','1',1,'Retail Sale Id 5590',3002.40,0.00,0.00,4.17,287.73,'2023-03-07 13:19:57','',''),(5739,'1','310','1',1,'Retail Sale Id 5591',4298.40,0.00,0.00,5.97,411.93,'2023-03-07 13:40:42','',''),(5740,'1','310','1',1,'Retail Sale Id 5592',4320.00,0.00,0.00,6.00,414.00,'2023-03-07 13:45:43','',''),(5741,'1','310','1',1,'Retail Sale Id 5593',4320.00,0.00,0.00,6.00,414.00,'2023-03-07 13:51:16','',''),(5742,'1','310','1',1,'Retail Sale Id 5594',105000.00,0.00,0.00,150.00,7350.00,'2023-03-07 13:53:05','',''),(5743,'1','310','1',1,'Retail Sale Id 5595',2203.20,0.00,0.00,3.06,211.14,'2023-03-07 13:59:22','',''),(5744,'1','310','1',1,'Retail Sale Id 5596',3499.20,0.00,0.00,4.86,335.34,'2023-03-07 14:04:58','',''),(5745,'1','310','1',1,'Retail Sale Id 5596',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 14:04:58','',''),(5746,'1','310','1',1,'Retail Sale Id 5597',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 14:10:53','',''),(5747,'1','310','1',1,'Retail Sale Id 5598',4003.20,0.00,0.00,5.56,383.64,'2023-03-07 14:14:53','',''),(5748,'1','310','1',1,'Retail Sale Id 5599',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 14:22:27','',''),(5749,'1','310','1',1,'Retail Sale Id 5600',3499.20,0.00,0.00,4.86,335.34,'2023-03-07 14:23:36','',''),(5750,'1','310','1',1,'Retail Sale Id 5600',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 14:23:36','',''),(5751,'1','310','1',1,'Retail Sale Id 5601',3751.20,0.00,0.00,5.21,359.49,'2023-03-07 14:26:54','',''),(5752,'1','310','1',1,'Return of Retail Sale Id 5598',0.00,4003.20,5.56,0.00,-383.64,'2023-03-07 14:28:14','',''),(5753,'1','310','1',1,'Retail Sale Id 5602',2880.00,0.00,0.00,4.00,276.00,'2023-03-07 14:30:08','',''),(5754,'1','310','1',1,'Retail Sale Id 5603',2203.20,0.00,0.00,3.06,211.14,'2023-03-07 14:35:34','',''),(5755,'1','310','1',1,'Retail Sale Id 5604',3002.40,0.00,0.00,4.17,287.73,'2023-03-07 14:36:43','',''),(5756,'1','310','1',1,'Retail Sale Id 5605',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 14:52:05','',''),(5757,'1','310','1',1,'Retail Sale Id 5606',2001.60,0.00,0.00,2.78,191.82,'2023-03-07 14:55:08','',''),(5758,'1','310','1',1,'Retail Sale Id 5607',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 14:56:26','',''),(5759,'1','310','1',1,'Retail Sale Id 5608',2001.60,0.00,0.00,2.78,191.82,'2023-03-07 15:02:36','',''),(5760,'1','310','1',1,'Retail Sale Id 5609',6998.40,0.00,0.00,9.72,670.68,'2023-03-07 15:18:19','',''),(5761,'1','310','1',1,'Retail Sale Id 5610',4320.00,0.00,0.00,6.00,414.00,'2023-03-07 15:20:08','',''),(5762,'1','310','1',1,'Retail Sale Id 5611',3600.00,0.00,0.00,5.00,345.00,'2023-03-07 15:23:33','',''),(5763,'1','310','1',1,'Retail Sale Id 5612',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 15:27:04','',''),(5764,'1','310','1',1,'Retail Sale Id 5613',4320.00,0.00,0.00,6.00,414.00,'2023-03-07 15:30:18','',''),(5765,'1','310','1',1,'Retail Sale Id 5614',3600.00,0.00,0.00,5.00,345.00,'2023-03-07 15:34:33','',''),(5766,'1','310','1',1,'Retail Sale Id 5615',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 15:36:18','',''),(5767,'1','310','1',1,'Retail Sale Id 5616',4996.80,0.00,0.00,6.94,478.86,'2023-03-07 15:37:40','',''),(5768,'1','310','1',1,'Retail Sale Id 5617',30002.00,0.00,0.00,42.86,2100.14,'2023-03-07 15:40:49','',''),(5769,'1','310','1',1,'Retail Sale Id 5618',5500.80,0.00,0.00,7.64,527.16,'2023-03-07 15:41:23','',''),(5770,'1','310','1',1,'Retail Sale Id 5619',4320.00,0.00,0.00,6.00,414.00,'2023-03-07 15:58:00','',''),(5771,'1','310','1',1,'Retail Sale Id 5620',3600.00,0.00,0.00,5.00,345.00,'2023-03-07 16:08:51','',''),(5772,'1','310','1',1,'Retail Sale Id 5621',4320.00,0.00,0.00,6.00,414.00,'2023-03-07 16:11:09','',''),(5773,'1','310','1',1,'Retail Sale Id 5623',35000.00,0.00,0.00,50.00,2450.00,'2023-03-07 16:18:10','',''),(5774,'1','310','1',1,'Retail Sale Id 5624',7200.00,0.00,0.00,10.00,690.00,'2023-03-07 16:20:24','',''),(5775,'1','310','1',1,'Retail Sale Id 5624',7200.00,0.00,0.00,10.00,690.00,'2023-03-07 16:20:24','',''),(5776,'1','310','1',1,'Retail Sale Id 5625',3600.00,0.00,0.00,5.00,345.00,'2023-03-07 16:22:23','',''),(5777,'1','310','1',1,'Retail Sale Id 5626',4320.00,0.00,0.00,6.00,414.00,'2023-03-07 16:24:28','',''),(5778,'1','310','1',1,'Retail Sale Id 5627',1497.60,0.00,0.00,2.08,143.52,'2023-03-07 16:26:24','',''),(5779,'1','310','1',1,'Retail Sale Id 5628',89600.00,0.00,0.00,128.00,6272.00,'2023-03-07 16:35:47','',''),(5780,'1','310','1',1,'Retail Sale Id 5630',4320.00,0.00,0.00,6.00,414.00,'2023-03-07 16:37:50','',''),(5781,'1','310','1',1,'Retail Sale Id 5631',1497.60,0.00,0.00,2.08,143.52,'2023-03-07 16:38:27','',''),(5782,'1','310','1',1,'Retail Sale Id 5632',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 16:39:49','',''),(5783,'1','310','1',1,'Retail Sale Id 5633',1000.80,0.00,0.00,1.39,95.91,'2023-03-07 16:40:56','',''),(5784,'1','310','1',1,'Retail Sale Id 5634',2203.20,0.00,0.00,3.06,211.14,'2023-03-07 16:42:38','',''),(5785,'1','310','1',1,'Retail Sale Id 5635',3002.40,0.00,0.00,4.17,287.73,'2023-03-07 16:44:28','',''),(5786,'1','310','1',1,'Retail Sale Id 5636',2001.60,0.00,0.00,2.78,191.82,'2023-03-07 16:45:08','',''),(5787,'1','310','1',1,'Retail Sale Id 5637',6480.00,0.00,0.00,9.00,621.00,'2023-03-07 16:47:25','',''),(5788,'1','310','1',1,'Retail Sale Id 5638',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 16:51:23','',''),(5789,'1','310','1',1,'Retail Sale Id 5639',3600.00,0.00,0.00,5.00,345.00,'2023-03-07 16:59:17','',''),(5790,'1','310','1',1,'Retail Sale Id 5640',2001.60,0.00,0.00,2.78,191.82,'2023-03-07 17:01:49','',''),(5791,'1','310','1',1,'Retail Sale Id 5641',3002.40,0.00,0.00,4.17,287.73,'2023-03-07 17:05:17','',''),(5792,'1','310','1',1,'Retail Sale Id 5642',4500.00,0.00,0.00,6.25,431.25,'2023-03-07 17:15:43','',''),(5793,'1','310','1',1,'Retail Sale Id 5643',2160.00,0.00,0.00,3.00,207.00,'2023-03-07 17:21:34','',''),(5794,'1','310','1',1,'Retail Sale Id 5644',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 17:25:46','',''),(5795,'1','310','1',1,'Retail Sale Id 5645',4003.20,0.00,0.00,5.56,383.64,'2023-03-07 17:30:39','',''),(5796,'1','310','1',1,'Retail Sale Id 5645',4003.20,0.00,0.00,5.56,383.64,'2023-03-07 17:30:39','',''),(5797,'1','310','1',1,'Retail Sale Id 5645',4996.80,0.00,0.00,6.94,478.86,'2023-03-07 17:30:39','',''),(5798,'1','310','1',1,'Retail Sale Id 5645',4996.80,0.00,0.00,6.94,478.86,'2023-03-07 17:30:39','',''),(5799,'1','310','1',1,'Retail Sale Id 5646',3500.00,0.00,0.00,5.00,245.00,'2023-03-07 17:35:19','',''),(5800,'1','310','1',1,'Retail Sale Id 5647',3600.00,0.00,0.00,5.00,345.00,'2023-03-07 17:38:43','',''),(5801,'1','310','1',1,'Retail Sale Id 5648',175000.00,0.00,0.00,250.00,12250.00,'2023-03-07 17:41:15','',''),(5802,'1','310','1',1,'Retail Sale Id 5649',2160.00,0.00,0.00,3.00,207.00,'2023-03-07 17:45:05','',''),(5803,'1','310','1',1,'Retail Sale Id 5650',2001.60,0.00,0.00,2.78,191.82,'2023-03-07 17:46:42','',''),(5804,'1','310','1',1,'Retail Sale Id 5651',1440.00,0.00,0.00,2.00,138.00,'2023-03-07 17:50:40','',''),(5805,'1','310','1',1,'Retail Sale Id 5652',2160.00,0.00,0.00,3.00,207.00,'2023-03-07 17:52:01','',''),(5806,'1','310','1',1,'Retail Sale Id 5653',4320.00,0.00,0.00,6.00,414.00,'2023-03-07 17:54:43','',''),(5807,'1','310','1',1,'Retail Sale Id 5654',3600.00,0.00,0.00,5.00,345.00,'2023-03-07 18:03:25','',''),(5808,'1','310','1',1,'Retail Sale Id 5654',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 18:03:25','',''),(5809,'1','310','1',1,'Retail Sale Id 5655',720.00,0.00,0.00,1.00,69.00,'2023-03-07 18:07:29','',''),(5810,'1','310','1',1,'Retail Sale Id 5656',2160.00,0.00,0.00,3.00,207.00,'2023-03-07 18:09:22','',''),(5811,'1','310','1',1,'Retail Sale Id 5657',3600.00,0.00,0.00,5.00,345.00,'2023-03-07 18:10:23','',''),(5812,'1','310','1',1,'Retail Sale Id 5657',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 18:10:23','',''),(5813,'1','310','1',1,'Retail Sale Id 5658',1000.80,0.00,0.00,1.39,95.91,'2023-03-07 18:11:09','',''),(5814,'1','310','1',1,'Retail Sale Id 5660',720.00,0.00,0.00,1.00,69.00,'2023-03-07 18:13:27','',''),(5815,'1','310','1',1,'Retail Sale Id 5662',2001.60,0.00,0.00,2.78,191.82,'2023-03-07 18:16:12','',''),(5816,'1','310','1',1,'Retail Sale Id 5663',3600.00,0.00,0.00,5.00,345.00,'2023-03-07 18:16:43','',''),(5817,'1','310','1',1,'Retail Sale Id 5664',1000.80,0.00,0.00,1.39,95.91,'2023-03-07 18:19:18','',''),(5818,'1','310','1',1,'Retail Sale Id 5664',1000.80,0.00,0.00,1.39,95.91,'2023-03-07 18:19:18','',''),(5819,'1','310','1',1,'Retail Sale Id 5665',2160.00,0.00,0.00,3.00,207.00,'2023-03-07 18:20:05','',''),(5820,'1','310','1',1,'Retail Sale Id 5666',3600.00,0.00,0.00,5.00,345.00,'2023-03-07 18:20:34','',''),(5821,'1','310','1',1,'Retail Sale Id 5668',3500.00,0.00,0.00,5.00,245.00,'2023-03-07 18:24:21','',''),(5822,'1','310','1',1,'Retail Sale Id 5669',1000.80,0.00,0.00,1.39,95.91,'2023-03-07 18:24:50','',''),(5823,'1','310','1',1,'Retail Sale Id 5670',698.40,0.00,0.00,0.97,66.93,'2023-03-07 18:28:50','',''),(5824,'1','310','1',1,'Retail Sale Id 5671',1497.60,0.00,0.00,2.08,143.52,'2023-03-07 18:29:51','',''),(5825,'1','310','1',1,'Retail Sale Id 5672',698.40,0.00,0.00,0.97,66.93,'2023-03-07 18:34:28','',''),(5826,'1','310','1',1,'Retail Sale Id 5673',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 18:55:36','',''),(5827,'1','310','1',1,'Retail Sale Id 5674',2001.60,0.00,0.00,2.78,191.82,'2023-03-07 18:57:07','',''),(5828,'1','310','1',1,'Retail Sale Id 5675',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 19:00:08','',''),(5829,'1','310','1',1,'Retail Sale Id 5676',1000.80,0.00,0.00,1.39,95.91,'2023-03-07 19:03:24','',''),(5830,'1','310','1',1,'Retail Sale Id 5676',2160.00,0.00,0.00,3.00,207.00,'2023-03-07 19:03:24','',''),(5831,'1','310','1',1,'Retail Sale Id 5677',9000.00,0.00,0.00,12.50,862.50,'2023-03-07 19:04:25','',''),(5832,'1','310','1',1,'Retail Sale Id 5678',4320.00,0.00,0.00,6.00,414.00,'2023-03-07 19:05:53','',''),(5833,'1','310','1',1,'Retail Sale Id 5680',2203.20,0.00,0.00,3.06,211.14,'2023-03-07 19:18:31','',''),(5834,'1','310','1',1,'Retail Sale Id 5681',3600.00,0.00,0.00,5.00,345.00,'2023-03-07 19:25:33','',''),(5835,'1','310','1',1,'Retail Sale Id 5682',2599.20,0.00,0.00,3.61,249.09,'2023-03-07 19:28:19','',''),(5836,'1','310','1',1,'Retail Sale Id 5683',2160.00,0.00,0.00,3.00,207.00,'2023-03-07 19:33:22','',''),(5837,'1','310','1',1,'Return of Retail Sale Id 5677',0.00,9000.00,12.50,0.00,-862.50,'2023-03-07 20:03:02','',''),(5838,'1','310','1',1,'Return of Retail Sale Id 5675',0.00,9000.00,12.50,0.00,-862.50,'2023-03-07 20:04:03','',''),(5839,'1','310','1',1,'Return of Retail Sale Id 5638',0.00,9000.00,12.50,0.00,-862.50,'2023-03-07 20:07:02','',''),(5840,'1','310','1',1,'Return of Retail Sale Id 5683',0.00,2160.00,3.00,0.00,-207.00,'2023-03-07 20:10:00','',''),(5841,'1','310','1',1,'Retail Sale Id 5684',1677.60,0.00,0.00,2.33,160.77,'2023-03-07 20:11:19','',''),(5842,'1','310','1',1,'Return of Retail Sale Id 5668',0.00,3500.00,5.00,0.00,-245.00,'2023-03-07 20:14:20','',''),(5843,'1','310','1',1,'Retail Sale Id 5685',4004.00,0.00,0.00,5.72,280.28,'2023-03-07 20:20:10','',''),(5844,'1','310','1',1,'Return of Retail Sale Id 5646',0.00,3500.00,5.00,0.00,-245.00,'2023-03-07 20:40:01','',''),(5845,'1','310','1',1,'Retail Sale Id 5687',2996.00,0.00,0.00,4.28,209.72,'2023-03-07 20:42:54','',''),(5846,'1','310','1',1,'Retail Sale Id 5688',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 07:00:47','',''),(5847,'1','310','1',1,'Retail Sale Id 5689',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 07:30:11','',''),(5848,'1','310','1',1,'Retail Sale Id 5690',4003.20,0.00,0.00,5.56,383.64,'2023-03-08 07:38:59','',''),(5849,'1','310','1',1,'Retail Sale Id 5691',1497.60,0.00,0.00,2.08,143.52,'2023-03-08 07:54:08','',''),(5850,'1','310','1',1,'Retail Sale Id 5692',3600.00,0.00,0.00,5.00,345.00,'2023-03-08 08:05:35','',''),(5851,'1','310','1',1,'Retail Sale Id 5694',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 08:08:45','',''),(5852,'1','310','1',1,'Retail Sale Id 5694',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 08:08:45','',''),(5853,'1','310','1',1,'Retail Sale Id 5695',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 08:16:47','',''),(5854,'1','310','1',1,'Retail Sale Id 5696',3600.00,0.00,0.00,5.00,345.00,'2023-03-08 08:21:36','',''),(5855,'1','310','1',1,'Retail Sale Id 5697',2498.40,0.00,0.00,3.47,239.43,'2023-03-08 08:23:04','',''),(5856,'1','310','1',1,'Retail Sale Id 5698',10800.00,0.00,0.00,15.00,1035.00,'2023-03-08 08:32:17','',''),(5857,'1','310','1',1,'Retail Sale Id 5698',10800.00,0.00,0.00,15.00,1035.00,'2023-03-08 08:32:17','',''),(5858,'1','310','1',1,'Retail Sale Id 5699',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 08:33:41','',''),(5859,'1','310','1',1,'Retail Sale Id 5700',2001.60,0.00,0.00,2.78,191.82,'2023-03-08 08:42:04','',''),(5860,'1','310','1',1,'Retail Sale Id 5701',1202.40,0.00,0.00,1.67,115.23,'2023-03-08 08:51:56','',''),(5861,'1','310','1',1,'Retail Sale Id 5702',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 08:55:41','',''),(5862,'1','310','1',1,'Retail Sale Id 5703',7200.00,0.00,0.00,10.00,690.00,'2023-03-08 09:10:57','',''),(5863,'1','310','1',1,'Retail Sale Id 5704',7200.00,0.00,0.00,10.00,690.00,'2023-03-08 09:32:31','',''),(5864,'1','310','1',1,'Retail Sale Id 5705',1000.80,0.00,0.00,1.39,95.91,'2023-03-08 09:43:49','',''),(5865,'1','310','1',1,'Retail Sale Id 5706',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 09:47:33','',''),(5866,'1','310','1',1,'Retail Sale Id 5707',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 09:48:51','',''),(5867,'1','310','1',1,'Retail Sale Id 5708',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 09:53:49','',''),(5868,'1','310','1',1,'Retail Sale Id 5709',7200.00,0.00,0.00,10.00,690.00,'2023-03-08 10:00:43','',''),(5869,'1','310','1',1,'Retail Sale Id 5710',3002.40,0.00,0.00,4.17,287.73,'2023-03-08 10:13:06','',''),(5870,'1','310','1',1,'Retail Sale Id 5711',3398.40,0.00,0.00,4.72,325.68,'2023-03-08 10:32:09','',''),(5871,'1','310','1',1,'Retail Sale Id 5712',35000.00,0.00,0.00,50.00,2450.00,'2023-03-08 10:36:52','',''),(5872,'1','310','1',1,'Retail Sale Id 5713',2160.00,0.00,0.00,3.00,207.00,'2023-03-08 10:42:39','',''),(5873,'1','310','1',1,'Retail Sale Id 5714',1440.00,0.00,0.00,2.00,138.00,'2023-03-08 10:44:41','',''),(5874,'1','310','1',1,'Retail Sale Id 5715',115500.00,0.00,0.00,165.00,8085.00,'2023-03-08 10:53:56','',''),(5875,'1','310','1',1,'Retail Sale Id 5716',35000.00,0.00,0.00,50.00,2450.00,'2023-03-08 10:56:55','',''),(5876,'1','310','1',1,'Retail Sale Id 5717',3002.40,0.00,0.00,4.17,287.73,'2023-03-08 10:58:49','',''),(5877,'1','310','1',1,'Retail Sale Id 5718',7200.00,0.00,0.00,10.00,690.00,'2023-03-08 10:59:59','',''),(5878,'1','310','1',1,'Retail Sale Id 5719',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 11:07:22','',''),(5879,'1','310','1',1,'Retail Sale Id 5720',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 11:09:55','',''),(5880,'1','310','1',1,'Retail Sale Id 5721',35000.00,0.00,0.00,50.00,2450.00,'2023-03-08 11:13:31','',''),(5881,'1','310','1',1,'Retail Sale Id 5722',1400.00,0.00,0.00,2.00,98.00,'2023-03-08 11:15:25','',''),(5882,'1','310','1',1,'Retail Sale Id 5723',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 11:16:32','',''),(5883,'1','310','1',1,'Retail Sale Id 5724',2160.00,0.00,0.00,3.00,207.00,'2023-03-08 11:17:19','',''),(5884,'1','310','1',1,'Retail Sale Id 5725',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 11:18:11','',''),(5885,'1','310','1',1,'Retail Sale Id 5726',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 11:19:41','',''),(5886,'1','310','1',1,'Retail Sale Id 5727',2001.60,0.00,0.00,2.78,191.82,'2023-03-08 11:29:26','',''),(5887,'1','310','1',1,'Retail Sale Id 5728',720.00,0.00,0.00,1.00,69.00,'2023-03-08 11:34:13','',''),(5888,'1','310','1',1,'Retail Sale Id 5729',35000.00,0.00,0.00,50.00,2450.00,'2023-03-08 11:53:17','',''),(5889,'1','310','1',1,'Retail Sale Id 5730',35000.00,0.00,0.00,50.00,2450.00,'2023-03-08 11:54:59','',''),(5890,'1','310','1',1,'Retail Sale Id 5733',21700.00,0.00,0.00,31.00,1519.00,'2023-03-08 12:02:30','',''),(5891,'1','310','1',1,'Return of Retail Sale Id 5730',0.00,35000.00,50.00,0.00,-2450.00,'2023-03-08 12:03:55','',''),(5892,'1','310','1',1,'Retail Sale Id 5734',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 12:05:58','',''),(5893,'1','310','1',1,'Retail Sale Id 5735',8402.40,0.00,0.00,11.67,805.23,'2023-03-08 12:08:11','',''),(5894,'1','310','1',1,'Retail Sale Id 5736',2203.20,0.00,0.00,3.06,211.14,'2023-03-08 12:09:20','',''),(5895,'1','310','1',1,'Retail Sale Id 5737',1497.60,0.00,0.00,2.08,143.52,'2023-03-08 12:16:32','',''),(5896,'1','310','1',1,'Retail Sale Id 5738',2800.00,0.00,0.00,4.00,196.00,'2023-03-08 12:29:43','',''),(5897,'1','310','1',1,'Retail Sale Id 5739',5040.00,0.00,0.00,7.00,483.00,'2023-03-08 12:33:54','',''),(5898,'1','310','1',1,'Retail Sale Id 5740',4298.40,0.00,0.00,5.97,411.93,'2023-03-08 12:56:49','',''),(5899,'1','310','1',1,'Retail Sale Id 5741',1497.60,0.00,0.00,2.08,143.52,'2023-03-08 12:58:03','',''),(5900,'1','310','1',1,'Retail Sale Id 5742',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 12:59:35','',''),(5901,'1','310','1',1,'Retail Sale Id 5743',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 13:09:59','',''),(5902,'1','310','1',1,'Retail Sale Id 5744',2001.60,0.00,0.00,2.78,191.82,'2023-03-08 13:12:16','',''),(5903,'1','310','1',1,'Retail Sale Id 5746',1598.40,0.00,0.00,2.22,153.18,'2023-03-08 13:15:51','',''),(5904,'1','310','1',1,'Retail Sale Id 5747',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 13:19:01','',''),(5905,'1','310','1',1,'Retail Sale Id 5747',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 13:19:01','',''),(5906,'1','310','1',1,'Retail Sale Id 5748',3600.00,0.00,0.00,5.00,345.00,'2023-03-08 13:20:41','',''),(5907,'1','310','1',1,'Retail Sale Id 5749',2160.00,0.00,0.00,3.00,207.00,'2023-03-08 13:21:46','',''),(5908,'1','310','1',1,'Retail Sale Id 5750',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 13:25:22','',''),(5909,'1','310','1',1,'Retail Sale Id 5751',3002.40,0.00,0.00,4.17,287.73,'2023-03-08 13:26:51','',''),(5910,'1','310','1',1,'Retail Sale Id 5752',799.20,0.00,0.00,1.11,76.59,'2023-03-08 13:36:07','',''),(5911,'1','310','1',1,'Retail Sale Id 5753',2880.00,0.00,0.00,4.00,276.00,'2023-03-08 13:40:52','',''),(5912,'1','310','1',1,'Retail Sale Id 5754',5040.00,0.00,0.00,7.00,483.00,'2023-03-08 13:42:21','',''),(5913,'1','310','1',1,'Retail Sale Id 5755',2160.00,0.00,0.00,3.00,207.00,'2023-03-08 13:44:00','',''),(5914,'1','310','1',1,'Retail Sale Id 5756',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 13:55:29','',''),(5915,'1','310','1',1,'Retail Sale Id 5757',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 14:10:12','',''),(5916,'1','310','1',1,'Retail Sale Id 5758',403.20,0.00,0.00,0.56,38.64,'2023-03-08 14:14:30','',''),(5917,'1','310','1',1,'Retail Sale Id 5759',3002.40,0.00,0.00,4.17,287.73,'2023-03-08 14:19:59','',''),(5918,'1','310','1',1,'Retail Sale Id 5760',2001.60,0.00,0.00,2.78,191.82,'2023-03-08 14:26:21','',''),(5919,'1','310','1',1,'Retail Sale Id 5761',3600.00,0.00,0.00,5.00,345.00,'2023-03-08 14:43:00','',''),(5920,'1','310','1',1,'Retail Sale Id 5762',4003.20,0.00,0.00,5.56,383.64,'2023-03-08 14:49:03','',''),(5921,'1','310','1',1,'Retail Sale Id 5763',3600.00,0.00,0.00,5.00,345.00,'2023-03-08 14:51:55','',''),(5922,'1','310','1',1,'Retail Sale Id 5764',2001.60,0.00,0.00,2.78,191.82,'2023-03-08 14:54:04','',''),(5923,'1','310','1',1,'Retail Sale Id 5765',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 14:57:27','',''),(5924,'1','310','1',1,'Retail Sale Id 5766',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 14:58:23','',''),(5925,'1','310','1',1,'Retail Sale Id 5767',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 14:59:12','',''),(5926,'1','310','1',1,'Retail Sale Id 5768',4003.20,0.00,0.00,5.56,383.64,'2023-03-08 15:03:04','',''),(5927,'1','310','1',1,'Retail Sale Id 5769',1000.80,0.00,0.00,1.39,95.91,'2023-03-08 15:07:25','',''),(5928,'1','310','1',1,'Retail Sale Id 5770',1000.80,0.00,0.00,1.39,95.91,'2023-03-08 15:11:26','',''),(5929,'1','310','1',1,'Retail Sale Id 5771',1000.80,0.00,0.00,1.39,95.91,'2023-03-08 15:30:47','',''),(5930,'1','310','1',1,'Retail Sale Id 5772',3499.20,0.00,0.00,4.86,335.34,'2023-03-08 15:46:42','',''),(5931,'1','310','1',1,'Retail Sale Id 5773',3499.20,0.00,0.00,4.86,335.34,'2023-03-08 15:50:00','',''),(5932,'1','310','1',1,'Retail Sale Id 5774',1000.80,0.00,0.00,1.39,95.91,'2023-03-08 15:51:40','',''),(5933,'1','310','1',1,'Retail Sale Id 5775',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 15:52:27','',''),(5934,'1','310','1',1,'Retail Sale Id 5776',2001.60,0.00,0.00,2.78,191.82,'2023-03-08 15:56:17','',''),(5935,'1','310','1',1,'Retail Sale Id 5776',2160.00,0.00,0.00,3.00,207.00,'2023-03-08 15:56:17','',''),(5936,'1','310','1',1,'Retail Sale Id 5777',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 15:57:21','',''),(5937,'1','310','1',1,'Retail Sale Id 5780',3002.40,0.00,0.00,4.17,287.73,'2023-03-08 16:14:22','',''),(5938,'1','310','1',1,'Retail Sale Id 5781',597.60,0.00,0.00,0.83,57.27,'2023-03-08 16:24:53','',''),(5939,'1','310','1',1,'Retail Sale Id 5782',2001.60,0.00,0.00,2.78,191.82,'2023-03-08 16:26:33','',''),(5940,'1','310','1',1,'Retail Sale Id 5783',1000.80,0.00,0.00,1.39,95.91,'2023-03-08 16:29:12','',''),(5941,'1','310','1',1,'Retail Sale Id 5784',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 16:32:02','',''),(5942,'1','310','1',1,'Retail Sale Id 5785',4200.00,0.00,0.00,6.00,294.00,'2023-03-08 16:32:57','',''),(5943,'1','310','1',1,'Retail Sale Id 5786',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 16:37:13','',''),(5944,'1','310','1',1,'Retail Sale Id 5786',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 16:37:13','',''),(5945,'1','310','1',1,'Retail Sale Id 5787',3600.00,0.00,0.00,5.00,345.00,'2023-03-08 16:39:16','',''),(5946,'1','310','1',1,'Retail Sale Id 5788',2160.00,0.00,0.00,3.00,207.00,'2023-03-08 16:43:04','',''),(5947,'1','310','1',1,'Retail Sale Id 5788',2160.00,0.00,0.00,3.00,207.00,'2023-03-08 16:43:04','',''),(5948,'1','310','1',1,'Retail Sale Id 5789',2001.60,0.00,0.00,2.78,191.82,'2023-03-08 16:54:30','',''),(5949,'1','310','1',1,'Retail Sale Id 5790',3600.00,0.00,0.00,5.00,345.00,'2023-03-08 17:14:54','',''),(5950,'1','310','1',1,'Retail Sale Id 5791',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 17:22:27','',''),(5951,'1','310','1',1,'Retail Sale Id 5792',4998.00,0.00,0.00,7.14,349.86,'2023-03-08 17:25:33','',''),(5952,'1','310','1',1,'Retail Sale Id 5793',7200.00,0.00,0.00,10.00,690.00,'2023-03-08 17:26:25','',''),(5953,'1','310','1',1,'Retail Sale Id 5794',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 17:27:27','',''),(5954,'1','310','1',1,'Retail Sale Id 5795',2160.00,0.00,0.00,3.00,207.00,'2023-03-08 17:29:24','',''),(5955,'1','310','1',1,'Retail Sale Id 5795',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 17:29:24','',''),(5956,'1','310','1',1,'Retail Sale Id 5795',5997.60,0.00,0.00,8.33,574.77,'2023-03-08 17:29:24','',''),(5957,'1','310','1',1,'Retail Sale Id 5796',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 17:30:08','',''),(5958,'1','310','1',1,'Retail Sale Id 5797',4996.80,0.00,0.00,6.94,478.86,'2023-03-08 17:35:18','',''),(5959,'1','310','1',1,'Retail Sale Id 5798',496.80,0.00,0.00,0.69,47.61,'2023-03-08 17:39:56','',''),(5960,'1','310','1',1,'Retail Sale Id 5799',2160.00,0.00,0.00,3.00,207.00,'2023-03-08 17:47:40','',''),(5961,'1','310','1',1,'Retail Sale Id 5800',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 17:52:24','',''),(5962,'1','310','1',1,'Retail Sale Id 5800',8280.00,0.00,0.00,11.50,793.50,'2023-03-08 17:52:24','',''),(5963,'1','310','1',1,'Retail Sale Id 5800',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 17:52:24','',''),(5964,'1','310','1',1,'Retail Sale Id 5801',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 17:53:23','',''),(5965,'1','310','1',1,'Retail Sale Id 5802',2160.00,0.00,0.00,3.00,207.00,'2023-03-08 17:55:23','',''),(5966,'1','310','1',1,'Retail Sale Id 5803',3600.00,0.00,0.00,5.00,345.00,'2023-03-08 17:57:10','',''),(5967,'1','310','1',1,'Retail Sale Id 5804',17850.00,0.00,0.00,25.50,1249.50,'2023-03-08 17:59:38','',''),(5968,'1','310','1',1,'Retail Sale Id 5805',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 18:01:12','',''),(5969,'1','310','1',1,'Retail Sale Id 5806',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 18:10:08','',''),(5970,'1','310','1',1,'Retail Sale Id 5806',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 18:10:08','',''),(5971,'1','310','1',1,'Retail Sale Id 5807',2160.00,0.00,0.00,3.00,207.00,'2023-03-08 18:13:08','',''),(5972,'1','310','1',1,'Retail Sale Id 5808',3002.40,0.00,0.00,4.17,287.73,'2023-03-08 18:14:11','',''),(5973,'1','310','1',1,'Retail Sale Id 5809',2001.60,0.00,0.00,2.78,191.82,'2023-03-08 18:14:57','',''),(5974,'1','310','1',1,'Retail Sale Id 5810',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 18:16:10','',''),(5975,'1','310','1',1,'Retail Sale Id 5814',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 18:22:25','',''),(5976,'1','310','1',1,'Retail Sale Id 5814',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 18:22:25','',''),(5977,'1','310','1',1,'Retail Sale Id 5815',2901.60,0.00,0.00,4.03,278.07,'2023-03-08 18:24:24','',''),(5978,'1','310','1',1,'Retail Sale Id 5816',3600.00,0.00,0.00,5.00,345.00,'2023-03-08 18:26:00','',''),(5979,'1','310','1',1,'Retail Sale Id 5817',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 18:27:22','',''),(5980,'1','310','1',1,'Retail Sale Id 5818',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 18:30:25','',''),(5981,'1','310','1',1,'Retail Sale Id 5819',2001.60,0.00,0.00,2.78,191.82,'2023-03-08 18:31:51','',''),(5982,'1','310','1',1,'Retail Sale Id 5820',3002.40,0.00,0.00,4.17,287.73,'2023-03-08 18:34:34','',''),(5983,'1','310','1',1,'Retail Sale Id 5821',4320.00,0.00,0.00,6.00,414.00,'2023-03-08 18:37:16','',''),(5984,'1','310','1',1,'Retail Sale Id 5822',9000.00,0.00,0.00,12.50,862.50,'2023-03-08 18:40:03','',''),(5985,'1','310','1',1,'Retail Sale Id 5823',1000.80,0.00,0.00,1.39,95.91,'2023-03-08 19:02:59','',''),(5986,'1','310','1',1,'Return of Retail Sale Id 5822',0.00,9000.00,12.50,0.00,-862.50,'2023-03-08 19:22:12','',''),(5987,'1','310','1',1,'Retail Sale Id 5824',1353.60,0.00,0.00,1.88,129.72,'2023-03-08 19:23:40','',''),(5988,'1','310','1',1,'Return of Retail Sale Id 5738',0.00,2800.00,4.00,0.00,-196.00,'2023-03-08 19:26:32','',''),(5989,'1','310','1',1,'Retail Sale Id 5825',2793.00,0.00,0.00,3.99,195.51,'2023-03-08 19:28:19','',''),(5990,'1','310','1',1,'Return of Retail Sale Id 5785',0.00,4200.00,6.00,0.00,-294.00,'2023-03-08 19:31:00','',''),(5991,'1','310','1',1,'Retail Sale Id 5826',4200.00,0.00,0.00,6.00,294.00,'2023-03-08 19:32:36','',''),(5992,'1','310','1',1,'Return of Retail Sale Id 5825',0.00,2793.00,3.99,0.00,-195.51,'2023-03-08 19:33:31','',''),(5993,'1','310','1',1,'Retail Sale Id 5829',8400.00,0.00,0.00,12.00,588.00,'2023-03-08 19:36:53','',''),(5994,'1','310','1',1,'Return of Retail Sale Id 5829',0.00,8400.00,12.00,0.00,-588.00,'2023-03-08 19:41:48','',''),(5995,'1','310','1',1,'Retail Sale Id 5830',2800.00,0.00,0.00,4.00,196.00,'2023-03-08 19:43:47','',''),(5996,'1','310','1',1,'Retail Sale Id 5831',1000.80,0.00,0.00,1.39,95.91,'2023-03-09 07:17:58','',''),(5997,'1','310','1',1,'Retail Sale Id 5832',42000.00,0.00,0.00,60.00,2940.00,'2023-03-09 07:19:42','',''),(5998,'1','310','1',1,'Retail Sale Id 5833',3600.00,0.00,0.00,5.00,345.00,'2023-03-09 07:34:04','',''),(5999,'1','310','1',1,'Retail Sale Id 5834',4003.20,0.00,0.00,5.56,383.64,'2023-03-09 07:56:25','',''),(6000,'1','310','1',1,'Retail Sale Id 5835',2001.60,0.00,0.00,2.78,191.82,'2023-03-09 07:57:50','',''),(6001,'1','310','1',1,'Retail Sale Id 5836',4003.20,0.00,0.00,5.56,383.64,'2023-03-09 07:59:09','',''),(6002,'1','310','1',1,'Retail Sale Id 5837',4320.00,0.00,0.00,6.00,414.00,'2023-03-09 08:06:50','',''),(6003,'1','310','1',1,'Retail Sale Id 5838',77000.00,0.00,0.00,110.00,5390.00,'2023-03-09 08:09:27','',''),(6004,'1','310','1',1,'Retail Sale Id 5839',9000.00,0.00,0.00,12.50,862.50,'2023-03-09 08:10:43','',''),(6005,'1','310','1',1,'Retail Sale Id 5840',2160.00,0.00,0.00,3.00,207.00,'2023-03-09 08:20:52','',''),(6006,'1','310','1',1,'Retail Sale Id 5841',35000.00,0.00,0.00,50.00,2450.00,'2023-03-09 08:24:13','',''),(6007,'1','310','1',1,'Retail Sale Id 5842',1000.80,0.00,0.00,1.39,95.91,'2023-03-09 08:29:51','',''),(6008,'1','310','1',1,'Retail Sale Id 5843',2160.00,0.00,0.00,3.00,207.00,'2023-03-09 08:32:30','',''),(6009,'1','310','1',1,'Retail Sale Id 5844',4003.20,0.00,0.00,5.56,383.64,'2023-03-09 08:33:31','',''),(6010,'1','310','1',1,'Retail Sale Id 5845',9000.00,0.00,0.00,12.50,862.50,'2023-03-09 08:39:44','',''),(6011,'1','310','1',1,'Retail Sale Id 5846',4320.00,0.00,0.00,6.00,414.00,'2023-03-09 08:48:49','',''),(6012,'1','310','1',1,'Retail Sale Id 5847',38500.00,0.00,0.00,55.00,2695.00,'2023-03-09 09:00:28','',''),(6013,'1','310','1',1,'Retail Sale Id 5848',1497.60,0.00,0.00,2.08,143.52,'2023-03-09 09:10:55','',''),(6014,'1','310','1',1,'Retail Sale Id 5848',2001.60,0.00,0.00,2.78,191.82,'2023-03-09 09:10:55','',''),(6015,'1','310','1',1,'Retail Sale Id 5849',7200.00,0.00,0.00,10.00,690.00,'2023-03-09 09:14:09','',''),(6016,'1','310','1',1,'Retail Sale Id 5850',3002.40,0.00,0.00,4.17,287.73,'2023-03-09 09:15:30','',''),(6017,'1','310','1',1,'Retail Sale Id 5850',3600.00,0.00,0.00,5.00,345.00,'2023-03-09 09:15:30','',''),(6018,'1','310','1',1,'Retail Sale Id 5851',3002.40,0.00,0.00,4.17,287.73,'2023-03-09 09:18:40','',''),(6019,'1','310','1',1,'Retail Sale Id 5852',7999.20,0.00,0.00,11.11,766.59,'2023-03-09 09:21:10','',''),(6020,'1','310','1',1,'Retail Sale Id 5853',496.80,0.00,0.00,0.69,47.61,'2023-03-09 09:37:45','',''),(6021,'1','310','1',1,'Retail Sale Id 5854',1497.60,0.00,0.00,2.08,143.52,'2023-03-09 09:41:52','',''),(6022,'1','310','1',1,'Retail Sale Id 5855',175000.00,0.00,0.00,250.00,12250.00,'2023-03-09 09:43:46','',''),(6023,'1','310','1',1,'Retail Sale Id 5856',2160.00,0.00,0.00,3.00,207.00,'2023-03-09 09:45:01','',''),(6024,'1','310','1',1,'Retail Sale Id 5857',2498.40,0.00,0.00,3.47,239.43,'2023-03-09 09:51:12','',''),(6025,'1','310','1',1,'Retail Sale Id 5858',1000.80,0.00,0.00,1.39,95.91,'2023-03-09 09:52:45','',''),(6026,'1','310','1',1,'Retail Sale Id 5860',9000.00,0.00,0.00,12.50,862.50,'2023-03-09 10:01:04','',''),(6027,'1','310','1',1,'Retail Sale Id 5861',2001.60,0.00,0.00,2.78,191.82,'2023-03-09 10:04:57','',''),(6028,'1','310','1',1,'Retail Sale Id 5862',7999.20,0.00,0.00,11.11,766.59,'2023-03-09 10:07:29','',''),(6029,'1','310','1',1,'Retail Sale Id 5863',14651.00,0.00,0.00,20.93,1025.57,'2023-03-09 10:10:46','',''),(6030,'1','310','1',1,'Retail Sale Id 5864',9000.00,0.00,0.00,12.50,862.50,'2023-03-09 10:14:03','',''),(6031,'1','310','1',1,'Retail Sale Id 5865',4003.20,0.00,0.00,5.56,383.64,'2023-03-09 10:26:21','',''),(6032,'1','310','1',1,'Retail Sale Id 5866',3600.00,0.00,0.00,5.00,345.00,'2023-03-09 10:31:27','',''),(6033,'1','310','1',1,'Retail Sale Id 5867',4320.00,0.00,0.00,6.00,414.00,'2023-03-09 10:37:25','',''),(6034,'1','310','1',1,'Retail Sale Id 5868',4320.00,0.00,0.00,6.00,414.00,'2023-03-09 10:42:09','',''),(6035,'1','310','1',1,'Retail Sale Id 5869',2160.00,0.00,0.00,3.00,207.00,'2023-03-09 10:56:06','',''),(6036,'1','310','1',1,'Retail Sale Id 5870',2001.60,0.00,0.00,2.78,191.82,'2023-03-09 10:58:46','',''),(6037,'1','310','1',1,'Retail Sale Id 5871',35000.00,0.00,0.00,50.00,2450.00,'2023-03-09 11:00:55','',''),(6038,'1','310','1',1,'Retail Sale Id 5872',1000.80,0.00,0.00,1.39,95.91,'2023-03-09 11:12:12','',''),(6039,'1','310','1',1,'Retail Sale Id 5873',3600.00,0.00,0.00,5.00,345.00,'2023-03-09 11:16:38','',''),(6040,'1','310','1',1,'Retail Sale Id 5874',9000.00,0.00,0.00,12.50,862.50,'2023-03-09 11:17:38','',''),(6041,'1','310','1',1,'Retail Sale Id 5875',9000.00,0.00,0.00,12.50,862.50,'2023-03-09 11:18:50','',''),(6042,'1','310','1',1,'Retail Sale Id 5876',9000.00,0.00,0.00,12.50,862.50,'2023-03-09 11:25:43','',''),(6043,'1','310','1',1,'Retail Sale Id 5876',18000.00,0.00,0.00,25.00,1725.00,'2023-03-09 11:25:43','',''),(6044,'1','310','1',1,'Retail Sale Id 5878',3600.00,0.00,0.00,5.00,345.00,'2023-03-09 11:30:11','',''),(6045,'1','310','1',1,'Retail Sale Id 5879',9000.00,0.00,0.00,12.50,862.50,'2023-03-09 11:38:02','',''),(6046,'1','310','1',1,'Retail Sale Id 5880',1440.00,0.00,0.00,2.00,138.00,'2023-03-09 11:45:10','',''),(6047,'1','310','1',1,'Retail Sale Id 5881',9000.00,0.00,0.00,12.50,862.50,'2023-03-09 11:49:58','',''),(6048,'1','310','1',1,'Retail Sale Id 5882',9000.00,0.00,0.00,12.50,862.50,'2023-03-09 11:56:37','',''),(6049,'1','310','1',1,'Retail Sale Id 5883',9000.00,0.00,0.00,12.50,862.50,'2023-03-09 12:06:26','',''),(6050,'1','310','1',1,'Retail Sale Id 5884',140000.00,0.00,0.00,200.00,9800.00,'2023-03-09 12:08:17','',''),(6051,'1','310','1',1,'Retail Sale Id 5885',9000.00,0.00,0.00,12.50,862.50,'2023-03-09 12:13:14','',''),(6052,'1','310','1',1,'Retail Sale Id 5886',35000.00,0.00,0.00,50.00,2450.00,'2023-03-09 12:17:05','',''),(6053,'1','310','1',1,'Retail Sale Id 5887',1000.80,0.00,0.00,1.39,95.91,'2023-03-09 12:23:29','',''),(6054,'1','310','1',1,'Retail Sale Id 5888',2880.00,0.00,0.00,4.00,276.00,'2023-03-09 12:28:51','',''),(6055,'1','310','1',1,'Retail Sale Id 5889',2160.00,0.00,0.00,3.00,207.00,'2023-03-09 12:30:17','',''),(6056,'1','310','1',1,'Retail Sale Id 5890',4320.00,0.00,0.00,6.00,414.00,'2023-03-09 12:31:48','',''),(6057,'1','310','1',1,'Retail Sale Id 5891',4320.00,0.00,0.00,6.00,414.00,'2023-03-09 12:32:42','',''),(6058,'1','310','1',1,'Retail Sale Id 5892',35000.00,0.00,0.00,50.00,2450.00,'2023-03-09 12:34:36','',''),(6059,'1','310','1',1,'Retail Sale Id 5893',3600.00,0.00,0.00,5.00,345.00,'2023-03-09 13:06:18','',''),(6060,'1','310','1',1,'Retail Sale Id 5894',4320.00,0.00,0.00,6.00,414.00,'2023-03-09 13:11:44','',''),(6061,'1','310','1',1,'Retail Sale Id 5895',2160.00,0.00,0.00,3.00,207.00,'2023-03-09 13:14:29','',''),(6062,'1','310','1',1,'Retail Sale Id 5896',9000.00,0.00,0.00,12.50,862.50,'2023-03-09 13:17:09','',''),(6063,'1','310','1',1,'Retail Sale Id 5897',4320.00,0.00,0.00,6.00,414.00,'2023-03-09 13:20:14','',''),(6064,'1','310','1',1,'Retail Sale Id 5898',2160.00,0.00,0.00,3.00,207.00,'2023-03-09 13:22:28','',''),(6065,'1','310','1',1,'Retail Sale Id 5899',2160.00,0.00,0.00,3.00,207.00,'2023-03-09 13:23:34','',''),(6066,'1','310','1',1,'Retail Sale Id 5900',1440.00,0.00,0.00,2.00,138.00,'2023-03-09 13:29:26','',''),(6067,'1','310','1',1,'Retail Sale Id 5901',3600.00,0.00,0.00,5.00,345.00,'2023-03-09 13:38:47','',''),(6068,'1','310','1',1,'Retail Sale Id 5901',9000.00,0.00,0.00,12.50,862.50,'2023-03-09 13:38:47','',''),(6069,'1','310','1',1,'Retail Sale Id 5902',2160.00,0.00,0.00,3.00,207.00,'2023-03-09 13:46:59','',''),(6070,'1','310','1',1,'Retail Sale Id 5903',2160.00,0.00,0.00,3.00,207.00,'2023-03-09 13:50:27','',''),(6071,'1','310','1',1,'Retail Sale Id 5904',4320.00,0.00,0.00,6.00,414.00,'2023-03-09 13:53:51','',''),(6072,'1','310','1',1,'Retail Sale Id 5905',4200.00,0.00,0.00,6.00,294.00,'2023-03-09 13:59:22','',''),(6073,'1','310','1',1,'Retail Sale Id 5906',1440.00,0.00,0.00,2.00,138.00,'2023-03-09 14:36:11','',''),(6074,'1','310','1',1,'Retail Sale Id 5907',1442.00,0.00,0.00,2.06,100.94,'2023-03-09 14:38:19','',''),(6075,'1','310','1',1,'Retail Sale Id 5908',2160.00,0.00,0.00,3.00,207.00,'2023-03-09 14:51:04','',''),(6076,'1','310','1',1,'Retail Sale Id 5908',4320.00,0.00,0.00,6.00,414.00,'2023-03-09 14:51:04','',''),(6077,'1','310','1',1,'Retail Sale Id 5908',9000.00,0.00,0.00,12.50,862.50,'2023-03-09 14:51:04','',''),(6078,'1','310','1',1,'Retail Sale Id 5909',4200.00,0.00,0.00,6.00,294.00,'2023-03-09 14:52:49','',''),(6079,'1','310','1',1,'Retail Sale Id 5910',3600.00,0.00,0.00,5.00,345.00,'2023-03-09 14:56:53','',''),(6080,'1','310','1',1,'Retail Sale Id 5911',105000.00,0.00,0.00,150.00,7350.00,'2023-03-09 15:08:43','',''),(6081,'1','310','1',1,'Retail Sale Id 5912',70000.00,0.00,0.00,100.00,4900.00,'2023-03-09 15:10:05','',''),(6082,'1','310','1',1,'Retail Sale Id 5913',9000.00,0.00,0.00,12.50,862.50,'2023-03-09 15:14:02','',''),(6083,'1','310','1',1,'Retail Sale Id 5914',1000.80,0.00,0.00,1.39,95.91,'2023-03-09 15:37:01','',''),(6084,'1','310','1',1,'Retail Sale Id 5916',2001.60,0.00,0.00,2.78,191.82,'2023-03-09 15:46:08','',''),(6085,'1','310','1',1,'Retail Sale Id 5917',4320.00,0.00,0.00,6.00,414.00,'2023-03-09 15:47:02','',''),(6086,'1','310','1',1,'Retail Sale Id 5918',698.40,0.00,0.00,0.97,66.93,'2023-03-09 15:49:48','',''),(6087,'1','310','1',1,'Retail Sale Id 5919',1000.80,0.00,0.00,1.39,95.91,'2023-03-09 15:53:31','',''),(6088,'1','310','1',1,'Retail Sale Id 5920',2880.00,0.00,0.00,4.00,276.00,'2023-03-09 16:01:20','',''),(6089,'1','310','1',1,'Retail Sale Id 5921',4320.00,0.00,0.00,6.00,414.00,'2023-03-09 16:03:52','',''),(6090,'1','310','1',1,'Retail Sale Id 5922',2001.60,0.00,0.00,2.78,191.82,'2023-03-09 16:04:43','',''),(6091,'1','310','1',1,'Retail Sale Id 5923',15120.00,0.00,0.00,21.00,1449.00,'2023-03-09 16:06:45','',''),(6092,'1','310','1',1,'Retail Sale Id 5924',1497.60,0.00,0.00,2.08,143.52,'2023-03-09 16:08:20','',''),(6093,'1','310','1',1,'Retail Sale Id 5925',1440.00,0.00,0.00,2.00,138.00,'2023-03-09 16:19:30','',''),(6094,'1','310','1',1,'Retail Sale Id 5926',2880.00,0.00,0.00,4.00,276.00,'2023-03-09 16:21:22','',''),(6095,'1','310','1',1,'Retail Sale Id 5927',3600.00,0.00,0.00,5.00,345.00,'2023-03-09 16:27:14','',''),(6096,'1','310','1',1,'Retail Sale Id 5928',4320.00,0.00,0.00,6.00,414.00,'2023-03-09 16:31:22','',''),(6097,'1','310','1',1,'Retail Sale Id 5929',2160.00,0.00,0.00,3.00,207.00,'2023-03-09 16:38:52','',''),(6098,'1','310','1',1,'Retail Sale Id 5930',9000.00,0.00,0.00,12.50,862.50,'2023-03-09 16:50:37','',''),(6099,'1','310','1',1,'Retail Sale Id 5932',4003.20,0.00,0.00,5.56,383.64,'2023-03-09 16:52:15','',''),(6100,'1','310','1',1,'Retail Sale Id 5934',1000.80,0.00,0.00,1.39,95.91,'2023-03-09 16:58:32','',''),(6101,'1','310','1',1,'Retail Sale Id 5935',9000.00,0.00,0.00,12.50,862.50,'2023-03-09 17:00:05','',''),(6102,'1','310','1',1,'Retail Sale Id 5936',3002.40,0.00,0.00,4.17,287.73,'2023-03-09 17:01:54','',''),(6103,'1','310','1',1,'Retail Sale Id 5937',720.00,0.00,0.00,1.00,69.00,'2023-03-09 17:18:14','',''),(6104,'1','310','1',1,'Retail Sale Id 5938',3600.00,0.00,0.00,5.00,345.00,'2023-03-09 17:21:52','',''),(6105,'1','310','1',1,'Retail Sale Id 5940',4320.00,0.00,0.00,6.00,414.00,'2023-03-09 17:24:06','',''),(6106,'1','310','1',1,'Retail Sale Id 5940',4320.00,0.00,0.00,6.00,414.00,'2023-03-09 17:24:06','',''),(6107,'1','310','1',1,'Retail Sale Id 5941',2001.60,0.00,0.00,2.78,191.82,'2023-03-09 17:24:59','',''),(6108,'1','310','1',1,'Retail Sale Id 5942',35000.00,0.00,0.00,50.00,2450.00,'2023-03-09 17:31:01','',''),(6109,'1','310','1',1,'Retail Sale Id 5943',3002.40,0.00,0.00,4.17,287.73,'2023-03-09 17:33:31','',''),(6110,'1','310','1',1,'Retail Sale Id 5944',4320.00,0.00,0.00,6.00,414.00,'2023-03-09 17:34:06','',''),(6111,'1','310','1',1,'Retail Sale Id 5945',2160.00,0.00,0.00,3.00,207.00,'2023-03-09 17:39:12','',''),(6112,'1','310','1',1,'Retail Sale Id 5946',2001.60,0.00,0.00,2.78,191.82,'2023-03-09 17:48:53','',''),(6113,'1','310','1',1,'Retail Sale Id 5947',1000.80,0.00,0.00,1.39,95.91,'2023-03-09 18:01:21','',''),(6114,'1','310','1',1,'Retail Sale Id 5948',2001.60,0.00,0.00,2.78,191.82,'2023-03-09 18:02:19','',''),(6115,'1','310','1',1,'Retail Sale Id 5949',4320.00,0.00,0.00,6.00,414.00,'2023-03-09 18:03:28','',''),(6116,'1','310','1',1,'Retail Sale Id 5950',1000.80,0.00,0.00,1.39,95.91,'2023-03-09 18:04:16','',''),(6117,'1','310','1',1,'Retail Sale Id 5951',3002.40,0.00,0.00,4.17,287.73,'2023-03-09 18:06:53','',''),(6118,'1','310','1',1,'Retail Sale Id 5952',2160.00,0.00,0.00,3.00,207.00,'2023-03-09 18:14:38','',''),(6119,'1','310','1',1,'Retail Sale Id 5953',4996.80,0.00,0.00,6.94,478.86,'2023-03-09 18:15:31','',''),(6120,'1','310','1',1,'Retail Sale Id 5954',2001.60,0.00,0.00,2.78,191.82,'2023-03-09 18:16:25','',''),(6121,'1','310','1',1,'Retail Sale Id 5955',2160.00,0.00,0.00,3.00,207.00,'2023-03-09 18:17:43','',''),(6122,'1','310','1',1,'Retail Sale Id 5956',1497.60,0.00,0.00,2.08,143.52,'2023-03-09 18:22:50','',''),(6123,'1','310','1',1,'Retail Sale Id 5957',4003.20,0.00,0.00,5.56,383.64,'2023-03-09 18:23:56','',''),(6124,'1','310','1',1,'Retail Sale Id 5958',4320.00,0.00,0.00,6.00,414.00,'2023-03-09 18:25:00','',''),(6125,'1','310','1',1,'Retail Sale Id 5959',2203.20,0.00,0.00,3.06,211.14,'2023-03-09 18:26:53','',''),(6126,'1','310','1',1,'Retail Sale Id 5960',2160.00,0.00,0.00,3.00,207.00,'2023-03-09 18:28:01','',''),(6127,'1','310','1',1,'Retail Sale Id 5961',4320.00,0.00,0.00,6.00,414.00,'2023-03-09 18:31:31','',''),(6128,'1','310','1',1,'Retail Sale Id 5962',9000.00,0.00,0.00,12.50,862.50,'2023-03-09 18:36:23','',''),(6129,'1','310','1',1,'Retail Sale Id 5963',1000.80,0.00,0.00,1.39,95.91,'2023-03-09 18:45:13','',''),(6130,'1','310','1',1,'Retail Sale Id 5964',1497.60,0.00,0.00,2.08,143.52,'2023-03-09 18:54:37','',''),(6131,'1','310','1',1,'Retail Sale Id 5964',2160.00,0.00,0.00,3.00,207.00,'2023-03-09 18:54:37','',''),(6132,'1','310','1',1,'Retail Sale Id 5965',3196.80,0.00,0.00,4.44,306.36,'2023-03-09 18:58:10','',''),(6133,'1','310','1',1,'Retail Sale Id 5966',6480.00,0.00,0.00,9.00,621.00,'2023-03-09 18:59:46','',''),(6134,'1','310','1',1,'Retail Sale Id 5967',9000.00,0.00,0.00,12.50,862.50,'2023-03-09 19:04:58','',''),(6135,'1','310','1',1,'Retail Sale Id 5968',4003.20,0.00,0.00,5.56,383.64,'2023-03-09 19:11:23','',''),(6136,'1','310','1',1,'Return of Retail Sale Id 5907',0.00,1442.00,2.06,0.00,-100.94,'2023-03-09 19:28:35','',''),(6137,'1','310','1',1,'Retail Sale Id 5969',1442.00,0.00,0.00,2.06,100.94,'2023-03-09 19:29:34','',''),(6138,'1','310','1',1,'Return of Retail Sale Id 5962',0.00,9000.00,12.50,0.00,-862.50,'2023-03-09 19:32:43','',''),(6139,'1','310','1',1,'Return of Retail Sale Id 5967',0.00,9000.00,12.50,0.00,-862.50,'2023-03-09 19:33:32','',''),(6140,'1','310','1',1,'Return of Retail Sale Id 5940',0.00,4320.00,6.00,0.00,-414.00,'2023-03-09 19:35:36','',''),(6141,'1','310','1',1,'Return of Retail Sale Id 5940',0.00,4320.00,6.00,0.00,-414.00,'2023-03-09 19:35:36','',''),(6142,'1','310','1',1,'Return of Retail Sale Id 5968',0.00,4003.20,5.56,0.00,-383.64,'2023-03-09 19:36:29','',''),(6143,'1','310','1',1,'Retail Sale Id 5970',3081.60,0.00,0.00,4.28,295.32,'2023-03-09 19:38:50','',''),(6144,'1','310','1',1,'Retail Sale Id 5971',2160.00,0.00,0.00,3.00,207.00,'2023-03-10 07:27:00','',''),(6145,'1','310','1',1,'Retail Sale Id 5972',4003.20,0.00,0.00,5.56,383.64,'2023-03-10 07:27:56','',''),(6146,'1','310','1',1,'Retail Sale Id 5973',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 07:31:34','',''),(6147,'1','310','1',1,'Retail Sale Id 5974',3600.00,0.00,0.00,5.00,345.00,'2023-03-10 07:32:23','',''),(6148,'1','310','1',1,'Retail Sale Id 5975',3002.40,0.00,0.00,4.17,287.73,'2023-03-10 07:44:47','',''),(6149,'1','310','1',1,'Retail Sale Id 5976',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 07:58:29','',''),(6150,'1','310','1',1,'Retail Sale Id 5976',9000.00,0.00,0.00,12.50,862.50,'2023-03-10 07:58:29','',''),(6151,'1','310','1',1,'Retail Sale Id 5977',9000.00,0.00,0.00,12.50,862.50,'2023-03-10 08:02:42','',''),(6152,'1','310','1',1,'Retail Sale Id 5978',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 08:08:44','',''),(6153,'1','310','1',1,'Retail Sale Id 5979',1000.80,0.00,0.00,1.39,95.91,'2023-03-10 08:23:19','',''),(6154,'1','310','1',1,'Retail Sale Id 5981',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 08:24:55','',''),(6155,'1','310','1',1,'Retail Sale Id 5981',9000.00,0.00,0.00,12.50,862.50,'2023-03-10 08:24:55','',''),(6156,'1','310','1',1,'Retail Sale Id 5982',986.40,0.00,0.00,1.37,94.53,'2023-03-10 08:30:40','',''),(6157,'1','310','1',1,'Retail Sale Id 5983',2160.00,0.00,0.00,3.00,207.00,'2023-03-10 08:32:25','',''),(6158,'1','310','1',1,'Retail Sale Id 5984',2001.60,0.00,0.00,2.78,191.82,'2023-03-10 08:33:40','',''),(6159,'1','310','1',1,'Retail Sale Id 5985',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 08:50:56','',''),(6160,'1','310','1',1,'Retail Sale Id 5986',2498.40,0.00,0.00,3.47,239.43,'2023-03-10 08:56:38','',''),(6161,'1','310','1',1,'Retail Sale Id 5987',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 09:06:25','',''),(6162,'1','310','1',1,'Retail Sale Id 5990',2160.00,0.00,0.00,3.00,207.00,'2023-03-10 09:09:20','',''),(6163,'1','310','1',1,'Retail Sale Id 5991',35000.00,0.00,0.00,50.00,2450.00,'2023-03-10 09:12:31','',''),(6164,'1','310','1',1,'Retail Sale Id 5994',1202.40,0.00,0.00,1.67,115.23,'2023-03-10 09:15:10','',''),(6165,'1','310','1',1,'Retail Sale Id 5995',9000.00,0.00,0.00,12.50,862.50,'2023-03-10 09:16:17','',''),(6166,'1','310','1',1,'Retail Sale Id 5996',2203.20,0.00,0.00,3.06,211.14,'2023-03-10 09:19:39','',''),(6167,'1','310','1',1,'Retail Sale Id 6004',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 09:26:55','',''),(6168,'1','310','1',1,'Retail Sale Id 6004',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 09:26:55','',''),(6169,'1','310','1',1,'Retail Sale Id 6005',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 09:28:46','',''),(6170,'1','310','1',1,'Retail Sale Id 6006',4996.80,0.00,0.00,6.94,478.86,'2023-03-10 09:29:33','',''),(6171,'1','310','1',1,'Retail Sale Id 6007',1000.80,0.00,0.00,1.39,95.91,'2023-03-10 09:35:03','',''),(6172,'1','310','1',1,'Retail Sale Id 6008',2160.00,0.00,0.00,3.00,207.00,'2023-03-10 09:37:23','',''),(6173,'1','310','1',1,'Retail Sale Id 6009',2160.00,0.00,0.00,3.00,207.00,'2023-03-10 09:39:01','',''),(6174,'1','310','1',1,'Retail Sale Id 6010',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 09:41:31','',''),(6175,'1','310','1',1,'Retail Sale Id 6011',7200.00,0.00,0.00,10.00,690.00,'2023-03-10 09:54:36','',''),(6176,'1','310','1',1,'Retail Sale Id 6013',496.80,0.00,0.00,0.69,47.61,'2023-03-10 09:56:04','',''),(6177,'1','310','1',1,'Retail Sale Id 6014',17500.00,0.00,0.00,25.00,1225.00,'2023-03-10 09:57:31','',''),(6178,'1','310','1',1,'Retail Sale Id 6015',2160.00,0.00,0.00,3.00,207.00,'2023-03-10 10:04:48','',''),(6179,'1','310','1',1,'Retail Sale Id 6015',2160.00,0.00,0.00,3.00,207.00,'2023-03-10 10:04:48','',''),(6180,'1','310','1',1,'Retail Sale Id 6016',1447.20,0.00,0.00,2.01,138.69,'2023-03-10 10:06:01','',''),(6181,'1','310','1',1,'Retail Sale Id 6017',4003.20,0.00,0.00,5.56,383.64,'2023-03-10 10:09:48','',''),(6182,'1','310','1',1,'Retail Sale Id 6018',3500.00,0.00,0.00,5.00,245.00,'2023-03-10 10:11:36','',''),(6183,'1','310','1',1,'Retail Sale Id 6019',10000.80,0.00,0.00,13.89,958.41,'2023-03-10 10:12:33','',''),(6184,'1','310','1',1,'Retail Sale Id 6020',3002.40,0.00,0.00,4.17,287.73,'2023-03-10 10:27:59','',''),(6185,'1','310','1',1,'Retail Sale Id 6022',3600.00,0.00,0.00,5.00,345.00,'2023-03-10 10:33:42','',''),(6186,'1','310','1',1,'Retail Sale Id 6024',2880.00,0.00,0.00,4.00,276.00,'2023-03-10 10:40:10','',''),(6187,'1','310','1',1,'Retail Sale Id 6025',496.80,0.00,0.00,0.69,47.61,'2023-03-10 10:46:20','',''),(6188,'1','310','1',1,'Retail Sale Id 6028',9000.00,0.00,0.00,12.50,862.50,'2023-03-10 11:02:47','',''),(6189,'1','310','1',1,'Retail Sale Id 6029',4003.20,0.00,0.00,5.56,383.64,'2023-03-10 11:04:11','',''),(6190,'1','310','1',1,'Retail Sale Id 6030',2160.00,0.00,0.00,3.00,207.00,'2023-03-10 11:06:20','',''),(6191,'1','310','1',1,'Retail Sale Id 6031',9000.00,0.00,0.00,12.50,862.50,'2023-03-10 11:07:31','',''),(6192,'1','310','1',1,'Retail Sale Id 6032',3002.40,0.00,0.00,4.17,287.73,'2023-03-10 11:10:08','',''),(6193,'1','310','1',1,'Retail Sale Id 6033',35000.00,0.00,0.00,50.00,2450.00,'2023-03-10 11:19:15','',''),(6194,'1','310','1',1,'Retail Sale Id 6034',1080.00,0.00,0.00,1.50,103.50,'2023-03-10 11:19:51','',''),(6195,'1','310','1',1,'Retail Sale Id 6035',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 11:30:09','',''),(6196,'1','310','1',1,'Retail Sale Id 6038',3600.00,0.00,0.00,5.00,345.00,'2023-03-10 11:45:21','',''),(6197,'1','310','1',1,'Retail Sale Id 6039',3600.00,0.00,0.00,5.00,345.00,'2023-03-10 11:47:57','',''),(6198,'1','310','1',1,'Retail Sale Id 6039',9000.00,0.00,0.00,12.50,862.50,'2023-03-10 11:47:57','',''),(6199,'1','310','1',1,'Retail Sale Id 6040',1598.40,0.00,0.00,2.22,153.18,'2023-03-10 11:49:44','',''),(6200,'1','310','1',1,'Retail Sale Id 6041',9000.00,0.00,0.00,12.50,862.50,'2023-03-10 11:51:18','',''),(6201,'1','310','1',1,'Retail Sale Id 6041',9000.00,0.00,0.00,12.50,862.50,'2023-03-10 11:51:18','',''),(6202,'1','310','1',1,'Retail Sale Id 6042',4500.00,0.00,0.00,6.25,431.25,'2023-03-10 11:52:40','',''),(6203,'1','310','1',1,'Retail Sale Id 6043',3600.00,0.00,0.00,5.00,345.00,'2023-03-10 12:10:52','',''),(6204,'1','310','1',1,'Retail Sale Id 6044',1396.80,0.00,0.00,1.94,133.86,'2023-03-10 12:28:19','',''),(6205,'1','310','1',1,'Retail Sale Id 6045',698.40,0.00,0.00,0.97,66.93,'2023-03-10 12:31:22','',''),(6206,'1','310','1',1,'Retail Sale Id 6046',2880.00,0.00,0.00,4.00,276.00,'2023-03-10 12:53:14','',''),(6207,'1','310','1',1,'Retail Sale Id 6047',2160.00,0.00,0.00,3.00,207.00,'2023-03-10 12:57:45','',''),(6208,'1','310','1',1,'Retail Sale Id 6048',9000.00,0.00,0.00,12.50,862.50,'2023-03-10 12:58:51','',''),(6209,'1','310','1',1,'Retail Sale Id 6049',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 13:01:25','',''),(6210,'1','310','1',1,'Retail Sale Id 6050',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 13:30:01','',''),(6211,'1','310','1',1,'Retail Sale Id 6051',2160.00,0.00,0.00,3.00,207.00,'2023-03-10 13:56:30','',''),(6212,'1','310','1',1,'Retail Sale Id 6052',2001.60,0.00,0.00,2.78,191.82,'2023-03-10 14:23:56','',''),(6213,'1','310','1',1,'Retail Sale Id 6053',2203.20,0.00,0.00,3.06,211.14,'2023-03-10 14:30:02','',''),(6214,'1','310','1',1,'Retail Sale Id 6054',1497.60,0.00,0.00,2.08,143.52,'2023-03-10 14:32:11','',''),(6215,'1','310','1',1,'Retail Sale Id 6054',1497.60,0.00,0.00,2.08,143.52,'2023-03-10 14:32:11','',''),(6216,'1','310','1',1,'Retail Sale Id 6054',1497.60,0.00,0.00,2.08,143.52,'2023-03-10 14:32:11','',''),(6217,'1','310','1',1,'Retail Sale Id 6056',597.60,0.00,0.00,0.83,57.27,'2023-03-10 14:35:24','',''),(6218,'1','310','1',1,'Retail Sale Id 6057',2160.00,0.00,0.00,3.00,207.00,'2023-03-10 14:38:00','',''),(6219,'1','310','1',1,'Retail Sale Id 6057',9000.00,0.00,0.00,12.50,862.50,'2023-03-10 14:38:00','',''),(6220,'1','310','1',1,'Retail Sale Id 6058',3002.40,0.00,0.00,4.17,287.73,'2023-03-10 14:58:44','',''),(6221,'1','310','1',1,'Retail Sale Id 6059',77000.00,0.00,0.00,110.00,5390.00,'2023-03-10 15:02:07','',''),(6222,'1','310','1',1,'Retail Sale Id 6060',2880.00,0.00,0.00,4.00,276.00,'2023-03-10 15:03:21','',''),(6223,'1','310','1',1,'Retail Sale Id 6060',5760.00,0.00,0.00,8.00,552.00,'2023-03-10 15:03:21','',''),(6224,'1','310','1',1,'Retail Sale Id 6061',9000.00,0.00,0.00,12.50,862.50,'2023-03-10 15:04:21','',''),(6225,'1','310','1',1,'Retail Sale Id 6061',9000.00,0.00,0.00,12.50,862.50,'2023-03-10 15:04:21','',''),(6226,'1','310','1',1,'Retail Sale Id 6062',2160.00,0.00,0.00,3.00,207.00,'2023-03-10 15:09:54','',''),(6227,'1','310','1',1,'Retail Sale Id 6063',9000.00,0.00,0.00,12.50,862.50,'2023-03-10 15:13:07','',''),(6228,'1','310','1',1,'Retail Sale Id 6064',5040.00,0.00,0.00,7.00,483.00,'2023-03-10 15:27:06','',''),(6229,'1','310','1',1,'Retail Sale Id 6065',9000.00,0.00,0.00,12.50,862.50,'2023-03-10 15:28:03','',''),(6230,'1','310','1',1,'Retail Sale Id 6066',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 15:28:54','',''),(6231,'1','310','1',1,'Retail Sale Id 6067',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 15:31:07','',''),(6232,'1','310','1',1,'Retail Sale Id 6068',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 15:32:04','',''),(6233,'1','310','1',1,'Retail Sale Id 6069',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 15:33:01','',''),(6234,'1','310','1',1,'Retail Sale Id 6070',35000.00,0.00,0.00,50.00,2450.00,'2023-03-10 15:36:00','',''),(6235,'1','310','1',1,'Retail Sale Id 6071',3002.40,0.00,0.00,4.17,287.73,'2023-03-10 15:38:25','',''),(6236,'1','310','1',1,'Retail Sale Id 6072',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 15:51:31','',''),(6237,'1','310','1',1,'Retail Sale Id 6074',5997.60,0.00,0.00,8.33,574.77,'2023-03-10 15:54:55','',''),(6238,'1','310','1',1,'Retail Sale Id 6075',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 15:57:39','',''),(6239,'1','310','1',1,'Retail Sale Id 6076',1000.80,0.00,0.00,1.39,95.91,'2023-03-10 15:58:38','',''),(6240,'1','310','1',1,'Retail Sale Id 6077',9000.00,0.00,0.00,12.50,862.50,'2023-03-10 15:59:47','',''),(6241,'1','310','1',1,'Retail Sale Id 6078',1497.60,0.00,0.00,2.08,143.52,'2023-03-10 16:06:09','',''),(6242,'1','310','1',1,'Retail Sale Id 6079',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 16:10:38','',''),(6243,'1','310','1',1,'Retail Sale Id 6080',7200.00,0.00,0.00,10.00,690.00,'2023-03-10 16:17:24','',''),(6244,'1','310','1',1,'Retail Sale Id 6080',7200.00,0.00,0.00,10.00,690.00,'2023-03-10 16:17:24','',''),(6245,'1','310','1',1,'Retail Sale Id 6082',2160.00,0.00,0.00,3.00,207.00,'2023-03-10 16:25:24','',''),(6246,'1','310','1',1,'Retail Sale Id 6083',1303.20,0.00,0.00,1.81,124.89,'2023-03-10 16:26:40','',''),(6247,'1','310','1',1,'Retail Sale Id 6085',1497.60,0.00,0.00,2.08,143.52,'2023-03-10 16:35:05','',''),(6248,'1','310','1',1,'Retail Sale Id 6086',2001.60,0.00,0.00,2.78,191.82,'2023-03-10 16:39:20','',''),(6249,'1','310','1',1,'Retail Sale Id 6087',2498.40,0.00,0.00,3.47,239.43,'2023-03-10 16:42:16','',''),(6250,'1','310','1',1,'Retail Sale Id 6088',3499.20,0.00,0.00,4.86,335.34,'2023-03-10 16:43:37','',''),(6251,'1','310','1',1,'Retail Sale Id 6089',10800.00,0.00,0.00,15.00,1035.00,'2023-03-10 16:44:46','',''),(6252,'1','310','1',1,'Retail Sale Id 6090',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 16:46:07','',''),(6253,'1','310','1',1,'Retail Sale Id 6091',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 16:47:28','',''),(6254,'1','310','1',1,'Retail Sale Id 6091',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 16:47:28','',''),(6255,'1','310','1',1,'Retail Sale Id 6092',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 16:48:42','',''),(6256,'1','310','1',1,'Retail Sale Id 6093',9000.00,0.00,0.00,12.50,862.50,'2023-03-10 16:54:46','',''),(6257,'1','310','1',1,'Retail Sale Id 6094',1497.60,0.00,0.00,2.08,143.52,'2023-03-10 16:57:40','',''),(6258,'1','310','1',1,'Retail Sale Id 6095',2160.00,0.00,0.00,3.00,207.00,'2023-03-10 17:07:38','',''),(6259,'1','310','1',1,'Retail Sale Id 6097',105000.00,0.00,0.00,150.00,7350.00,'2023-03-10 17:18:18','',''),(6260,'1','310','1',1,'Retail Sale Id 6098',7920.00,0.00,0.00,11.00,759.00,'2023-03-10 17:19:02','',''),(6261,'1','310','1',1,'Retail Sale Id 6099',1000.80,0.00,0.00,1.39,95.91,'2023-03-10 17:19:44','',''),(6262,'1','310','1',1,'Retail Sale Id 6100',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 17:34:25','',''),(6263,'1','310','1',1,'Retail Sale Id 6102',496.80,0.00,0.00,0.69,47.61,'2023-03-10 17:38:59','',''),(6264,'1','310','1',1,'Retail Sale Id 6103',4996.80,0.00,0.00,6.94,478.86,'2023-03-10 17:40:59','',''),(6265,'1','310','1',1,'Retail Sale Id 6104',2001.60,0.00,0.00,2.78,191.82,'2023-03-10 17:42:30','',''),(6266,'1','310','1',1,'Retail Sale Id 6105',3002.40,0.00,0.00,4.17,287.73,'2023-03-10 17:47:35','',''),(6267,'1','310','1',1,'Retail Sale Id 6106',3002.40,0.00,0.00,4.17,287.73,'2023-03-10 17:49:05','',''),(6268,'1','310','1',1,'Retail Sale Id 6107',1000.80,0.00,0.00,1.39,95.91,'2023-03-10 18:02:17','',''),(6269,'1','310','1',1,'Retail Sale Id 6109',2203.20,0.00,0.00,3.06,211.14,'2023-03-10 18:05:23','',''),(6270,'1','310','1',1,'Retail Sale Id 6110',4003.20,0.00,0.00,5.56,383.64,'2023-03-10 18:09:20','',''),(6271,'1','310','1',1,'Retail Sale Id 6111',7999.20,0.00,0.00,11.11,766.59,'2023-03-10 18:10:30','',''),(6272,'1','310','1',1,'Retail Sale Id 6112',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 18:14:33','',''),(6273,'1','310','1',1,'Retail Sale Id 6112',9000.00,0.00,0.00,12.50,862.50,'2023-03-10 18:14:33','',''),(6274,'1','310','1',1,'Retail Sale Id 6113',9000.00,0.00,0.00,12.50,862.50,'2023-03-10 18:16:12','',''),(6275,'1','310','1',1,'Retail Sale Id 6114',1497.60,0.00,0.00,2.08,143.52,'2023-03-10 18:22:29','',''),(6276,'1','310','1',1,'Retail Sale Id 6116',35000.00,0.00,0.00,50.00,2450.00,'2023-03-10 18:31:49','',''),(6277,'1','310','1',1,'Retail Sale Id 6117',4320.00,0.00,0.00,6.00,414.00,'2023-03-10 18:34:24','',''),(6278,'1','310','1',1,'Retail Sale Id 6118',9000.00,0.00,0.00,12.50,862.50,'2023-03-10 18:35:14','',''),(6279,'1','310','1',1,'Return of Retail Sale Id 6111',0.00,7999.20,11.11,0.00,-766.59,'2023-03-10 19:00:23','',''),(6280,'1','310','1',1,'Retail Sale Id 6120',1605.60,0.00,0.00,2.23,153.87,'2023-03-10 19:01:08','',''),(6281,'1','310','1',1,'Return of Retail Sale Id 6018',0.00,3500.00,5.00,0.00,-245.00,'2023-03-10 19:02:44','',''),(6282,'1','310','1',1,'Retail Sale Id 6121',3493.00,0.00,0.00,4.99,244.51,'2023-03-10 19:03:55','',''),(6283,'1','310','1',1,'Retail Sale Id 6122',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 07:29:10','',''),(6284,'1','310','1',1,'Retail Sale Id 6123',1497.60,0.00,0.00,2.08,143.52,'2023-03-11 08:00:31','',''),(6285,'1','310','1',1,'Retail Sale Id 6124',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 08:05:24','',''),(6286,'1','310','1',1,'Retail Sale Id 6124',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 08:05:24','',''),(6287,'1','310','1',1,'Retail Sale Id 6125',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 08:07:14','',''),(6288,'1','310','1',1,'Retail Sale Id 6126',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 08:27:34','',''),(6289,'1','310','1',1,'Retail Sale Id 6127',1202.40,0.00,0.00,1.67,115.23,'2023-03-11 08:34:54','',''),(6290,'1','310','1',1,'Retail Sale Id 6128',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 08:47:22','',''),(6291,'1','310','1',1,'Retail Sale Id 6129',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 08:59:03','',''),(6292,'1','310','1',1,'Retail Sale Id 6129',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 08:59:03','',''),(6293,'1','310','1',1,'Retail Sale Id 6130',2203.20,0.00,0.00,3.06,211.14,'2023-03-11 09:03:03','',''),(6294,'1','310','1',1,'Retail Sale Id 6131',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 09:06:19','',''),(6295,'1','310','1',1,'Retail Sale Id 6132',2160.00,0.00,0.00,3.00,207.00,'2023-03-11 09:13:56','',''),(6296,'1','310','1',1,'Retail Sale Id 6133',3002.40,0.00,0.00,4.17,287.73,'2023-03-11 09:19:04','',''),(6297,'1','310','1',1,'Retail Sale Id 6134',3002.40,0.00,0.00,4.17,287.73,'2023-03-11 09:20:36','',''),(6298,'1','310','1',1,'Retail Sale Id 6135',3600.00,0.00,0.00,5.00,345.00,'2023-03-11 09:22:30','',''),(6299,'1','310','1',1,'Retail Sale Id 6136',32900.00,0.00,0.00,47.00,2303.00,'2023-03-11 09:25:07','',''),(6300,'1','310','1',1,'Retail Sale Id 6137',1000.80,0.00,0.00,1.39,95.91,'2023-03-11 09:26:00','',''),(6301,'1','310','1',1,'Retail Sale Id 6138',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 09:34:17','',''),(6302,'1','310','1',1,'Retail Sale Id 6139',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 09:35:37','',''),(6303,'1','310','1',1,'Retail Sale Id 6140',42000.00,0.00,0.00,60.00,2940.00,'2023-03-11 09:40:59','',''),(6304,'1','310','1',1,'Retail Sale Id 6141',2160.00,0.00,0.00,3.00,207.00,'2023-03-11 09:41:54','',''),(6305,'1','310','1',1,'Retail Sale Id 6142',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 09:44:48','',''),(6306,'1','310','1',1,'Retail Sale Id 6143',4701.60,0.00,0.00,6.53,450.57,'2023-03-11 09:47:50','',''),(6307,'1','310','1',1,'Retail Sale Id 6144',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 09:51:08','',''),(6308,'1','310','1',1,'Retail Sale Id 6145',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 09:59:25','',''),(6309,'1','310','1',1,'Retail Sale Id 6146',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 10:17:11','',''),(6310,'1','310','1',1,'Retail Sale Id 6147',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 10:18:47','',''),(6311,'1','310','1',1,'Retail Sale Id 6147',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 10:18:47','',''),(6312,'1','310','1',1,'Retail Sale Id 6148',2160.00,0.00,0.00,3.00,207.00,'2023-03-11 10:25:23','',''),(6313,'1','310','1',1,'Retail Sale Id 6150',2498.40,0.00,0.00,3.47,239.43,'2023-03-11 10:33:24','',''),(6314,'1','310','1',1,'Retail Sale Id 6151',7200.00,0.00,0.00,10.00,690.00,'2023-03-11 10:42:00','',''),(6315,'1','310','1',1,'Retail Sale Id 6151',7920.00,0.00,0.00,11.00,759.00,'2023-03-11 10:42:00','',''),(6316,'1','310','1',1,'Retail Sale Id 6152',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 10:43:10','',''),(6317,'1','310','1',1,'Retail Sale Id 6153',7200.00,0.00,0.00,10.00,690.00,'2023-03-11 10:53:36','',''),(6318,'1','310','1',1,'Retail Sale Id 6153',7920.00,0.00,0.00,11.00,759.00,'2023-03-11 10:53:36','',''),(6319,'1','310','1',1,'Retail Sale Id 6154',315000.00,0.00,0.00,450.00,22050.00,'2023-03-11 10:56:55','',''),(6320,'1','310','1',1,'Retail Sale Id 6155',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 11:01:03','',''),(6321,'1','310','1',1,'Retail Sale Id 6156',2160.00,0.00,0.00,3.00,207.00,'2023-03-11 11:03:55','',''),(6322,'1','310','1',1,'Retail Sale Id 6157',2001.60,0.00,0.00,2.78,191.82,'2023-03-11 11:09:49','',''),(6323,'1','310','1',1,'Retail Sale Id 6157',2001.60,0.00,0.00,2.78,191.82,'2023-03-11 11:09:49','',''),(6324,'1','310','1',1,'Retail Sale Id 6158',1778.40,0.00,0.00,2.47,170.43,'2023-03-11 11:12:18','',''),(6325,'1','310','1',1,'Retail Sale Id 6159',4996.80,0.00,0.00,6.94,478.86,'2023-03-11 11:13:31','',''),(6326,'1','310','1',1,'Retail Sale Id 6160',35000.00,0.00,0.00,50.00,2450.00,'2023-03-11 11:15:03','',''),(6327,'1','310','1',1,'Retail Sale Id 6161',3600.00,0.00,0.00,5.00,345.00,'2023-03-11 11:17:23','',''),(6328,'1','310','1',1,'Retail Sale Id 6162',3600.00,0.00,0.00,5.00,345.00,'2023-03-11 11:18:35','',''),(6329,'1','310','1',1,'Retail Sale Id 6163',2160.00,0.00,0.00,3.00,207.00,'2023-03-11 11:19:43','',''),(6330,'1','310','1',1,'Retail Sale Id 6164',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 11:20:49','',''),(6331,'1','310','1',1,'Retail Sale Id 6165',7200.00,0.00,0.00,10.00,690.00,'2023-03-11 11:21:52','',''),(6332,'1','310','1',1,'Retail Sale Id 6166',1497.60,0.00,0.00,2.08,143.52,'2023-03-11 11:28:53','',''),(6333,'1','310','1',1,'Retail Sale Id 6169',1440.00,0.00,0.00,2.00,138.00,'2023-03-11 11:35:27','',''),(6334,'1','310','1',1,'Retail Sale Id 6170',2001.60,0.00,0.00,2.78,191.82,'2023-03-11 11:36:05','',''),(6335,'1','310','1',1,'Retail Sale Id 6171',5997.60,0.00,0.00,8.33,574.77,'2023-03-11 11:37:42','',''),(6336,'1','310','1',1,'Retail Sale Id 6172',3002.40,0.00,0.00,4.17,287.73,'2023-03-11 11:39:54','',''),(6337,'1','310','1',1,'Retail Sale Id 6173',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 11:42:08','',''),(6338,'1','310','1',1,'Retail Sale Id 6174',1000.80,0.00,0.00,1.39,95.91,'2023-03-11 11:43:00','',''),(6339,'1','310','1',1,'Retail Sale Id 6175',3002.40,0.00,0.00,4.17,287.73,'2023-03-11 12:01:23','',''),(6340,'1','310','1',1,'Retail Sale Id 6176',3600.00,0.00,0.00,5.00,345.00,'2023-03-11 12:09:12','',''),(6341,'1','310','1',1,'Retail Sale Id 6176',7999.20,0.00,0.00,11.11,766.59,'2023-03-11 12:09:12','',''),(6342,'1','310','1',1,'Retail Sale Id 6177',2880.00,0.00,0.00,4.00,276.00,'2023-03-11 12:11:14','',''),(6343,'1','310','1',1,'Retail Sale Id 6178',2160.00,0.00,0.00,3.00,207.00,'2023-03-11 12:24:07','',''),(6344,'1','310','1',1,'Retail Sale Id 6178',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 12:24:07','',''),(6345,'1','310','1',1,'Retail Sale Id 6179',3002.40,0.00,0.00,4.17,287.73,'2023-03-11 12:26:07','',''),(6346,'1','310','1',1,'Retail Sale Id 6180',3600.00,0.00,0.00,5.00,345.00,'2023-03-11 12:32:30','',''),(6347,'1','310','1',1,'Retail Sale Id 6181',70000.00,0.00,0.00,100.00,4900.00,'2023-03-11 12:46:40','',''),(6348,'1','310','1',1,'Retail Sale Id 6182',4996.80,0.00,0.00,6.94,478.86,'2023-03-11 12:49:49','',''),(6349,'1','310','1',1,'Retail Sale Id 6183',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 12:57:46','',''),(6350,'1','310','1',1,'Retail Sale Id 6184',1000.80,0.00,0.00,1.39,95.91,'2023-03-11 13:05:03','',''),(6351,'1','310','1',1,'Retail Sale Id 6185',1000.80,0.00,0.00,1.39,95.91,'2023-03-11 13:08:30','',''),(6352,'1','310','1',1,'Retail Sale Id 6186',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 13:12:23','',''),(6353,'1','310','1',1,'Retail Sale Id 6187',4996.80,0.00,0.00,6.94,478.86,'2023-03-11 13:13:58','',''),(6354,'1','310','1',1,'Retail Sale Id 6188',2160.00,0.00,0.00,3.00,207.00,'2023-03-11 13:15:33','',''),(6355,'1','310','1',1,'Retail Sale Id 6189',1497.60,0.00,0.00,2.08,143.52,'2023-03-11 13:17:34','',''),(6356,'1','310','1',1,'Retail Sale Id 6190',4996.80,0.00,0.00,6.94,478.86,'2023-03-11 13:19:12','',''),(6357,'1','310','1',1,'Retail Sale Id 6191',1000.80,0.00,0.00,1.39,95.91,'2023-03-11 13:22:24','',''),(6358,'1','310','1',1,'Retail Sale Id 6192',1440.00,0.00,0.00,2.00,138.00,'2023-03-11 13:24:42','',''),(6359,'1','310','1',1,'Retail Sale Id 6192',2160.00,0.00,0.00,3.00,207.00,'2023-03-11 13:24:42','',''),(6360,'1','310','1',1,'Retail Sale Id 6192',2880.00,0.00,0.00,4.00,276.00,'2023-03-11 13:24:42','',''),(6361,'1','310','1',1,'Retail Sale Id 6193',2160.00,0.00,0.00,3.00,207.00,'2023-03-11 13:26:10','',''),(6362,'1','310','1',1,'Retail Sale Id 6194',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 13:28:57','',''),(6363,'1','310','1',1,'Retail Sale Id 6195',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 13:31:22','',''),(6364,'1','310','1',1,'Retail Sale Id 6196',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 13:32:28','',''),(6365,'1','310','1',1,'Retail Sale Id 6196',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 13:32:28','',''),(6366,'1','310','1',1,'Retail Sale Id 6197',4996.80,0.00,0.00,6.94,478.86,'2023-03-11 13:34:11','',''),(6367,'1','310','1',1,'Retail Sale Id 6198',1000.80,0.00,0.00,1.39,95.91,'2023-03-11 13:35:07','',''),(6368,'1','310','1',1,'Retail Sale Id 6199',1497.60,0.00,0.00,2.08,143.52,'2023-03-11 13:36:40','',''),(6369,'1','310','1',1,'Retail Sale Id 6200',2498.40,0.00,0.00,3.47,239.43,'2023-03-11 13:37:45','',''),(6370,'1','310','1',1,'Retail Sale Id 6201',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 13:38:55','',''),(6371,'1','310','1',1,'Retail Sale Id 6202',2001.60,0.00,0.00,2.78,191.82,'2023-03-11 13:40:19','',''),(6372,'1','310','1',1,'Retail Sale Id 6203',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 13:40:58','',''),(6373,'1','310','1',1,'Retail Sale Id 6204',2160.00,0.00,0.00,3.00,207.00,'2023-03-11 13:42:44','',''),(6374,'1','310','1',1,'Retail Sale Id 6206',2160.00,0.00,0.00,3.00,207.00,'2023-03-11 13:45:45','',''),(6375,'1','310','1',1,'Retail Sale Id 6207',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 13:47:15','',''),(6376,'1','310','1',1,'Retail Sale Id 6208',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 13:55:20','',''),(6377,'1','310','1',1,'Retail Sale Id 6208',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 13:55:20','',''),(6378,'1','310','1',1,'Retail Sale Id 6208',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 13:55:20','',''),(6379,'1','310','1',1,'Retail Sale Id 6209',3002.40,0.00,0.00,4.17,287.73,'2023-03-11 13:56:28','',''),(6380,'1','310','1',1,'Retail Sale Id 6210',2160.00,0.00,0.00,3.00,207.00,'2023-03-11 14:00:33','',''),(6381,'1','310','1',1,'Retail Sale Id 6211',1497.60,0.00,0.00,2.08,143.52,'2023-03-11 14:02:30','',''),(6382,'1','310','1',1,'Retail Sale Id 6212',6480.00,0.00,0.00,9.00,621.00,'2023-03-11 14:04:36','',''),(6383,'1','310','1',1,'Retail Sale Id 6213',6300.00,0.00,0.00,9.00,441.00,'2023-03-11 14:13:10','',''),(6384,'1','310','1',1,'Retail Sale Id 6214',2160.00,0.00,0.00,3.00,207.00,'2023-03-11 14:15:09','',''),(6385,'1','310','1',1,'Retail Sale Id 6216',3628.80,0.00,0.00,5.04,347.76,'2023-03-11 14:27:01','',''),(6386,'1','310','1',1,'Retail Sale Id 6217',4003.20,0.00,0.00,5.56,383.64,'2023-03-11 14:31:54','',''),(6387,'1','310','1',1,'Retail Sale Id 6218',4500.00,0.00,0.00,6.25,431.25,'2023-03-11 14:33:07','',''),(6388,'1','310','1',1,'Retail Sale Id 6218',4500.00,0.00,0.00,6.25,431.25,'2023-03-11 14:33:08','',''),(6389,'1','310','1',1,'Retail Sale Id 6219',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 14:34:15','',''),(6390,'1','310','1',1,'Retail Sale Id 6220',3794.40,0.00,0.00,5.27,363.63,'2023-03-11 14:35:55','',''),(6391,'1','310','1',1,'Retail Sale Id 6220',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 14:35:55','',''),(6392,'1','310','1',1,'Retail Sale Id 6220',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 14:35:55','',''),(6393,'1','310','1',1,'Retail Sale Id 6221',55144.80,0.00,0.00,76.59,5284.71,'2023-03-11 14:38:33','',''),(6394,'1','310','1',1,'Retail Sale Id 6222',1000.80,0.00,0.00,1.39,95.91,'2023-03-11 14:50:43','',''),(6395,'1','310','1',1,'Retail Sale Id 6223',35000.00,0.00,0.00,50.00,2450.00,'2023-03-11 14:53:12','',''),(6396,'1','310','1',1,'Retail Sale Id 6224',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 14:54:40','',''),(6397,'1','310','1',1,'Retail Sale Id 6225',2001.60,0.00,0.00,2.78,191.82,'2023-03-11 14:56:55','',''),(6398,'1','310','1',1,'Retail Sale Id 6225',2001.60,0.00,0.00,2.78,191.82,'2023-03-11 14:56:55','',''),(6399,'1','310','1',1,'Retail Sale Id 6226',2160.00,0.00,0.00,3.00,207.00,'2023-03-11 15:17:23','',''),(6400,'1','310','1',1,'Retail Sale Id 6227',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 15:24:31','',''),(6401,'1','310','1',1,'Retail Sale Id 6228',140000.00,0.00,0.00,200.00,9800.00,'2023-03-11 15:30:05','',''),(6402,'1','310','1',1,'Retail Sale Id 6229',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 15:36:40','',''),(6403,'1','310','1',1,'Retail Sale Id 6230',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 15:39:40','',''),(6404,'1','310','1',1,'Retail Sale Id 6231',2880.00,0.00,0.00,4.00,276.00,'2023-03-11 15:41:11','',''),(6405,'1','310','1',1,'Retail Sale Id 6232',4996.80,0.00,0.00,6.94,478.86,'2023-03-11 15:52:56','',''),(6406,'1','310','1',1,'Retail Sale Id 6233',4996.80,0.00,0.00,6.94,478.86,'2023-03-11 15:55:44','',''),(6407,'1','310','1',1,'Retail Sale Id 6234',1000.80,0.00,0.00,1.39,95.91,'2023-03-11 16:03:50','',''),(6408,'1','310','1',1,'Retail Sale Id 6235',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 16:20:21','',''),(6409,'1','310','1',1,'Retail Sale Id 6235',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 16:20:21','',''),(6410,'1','310','1',1,'Retail Sale Id 6236',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 16:21:32','',''),(6411,'1','310','1',1,'Retail Sale Id 6237',2880.00,0.00,0.00,4.00,276.00,'2023-03-11 16:22:44','',''),(6412,'1','310','1',1,'Retail Sale Id 6238',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 16:23:46','',''),(6413,'1','310','1',1,'Retail Sale Id 6240',2160.00,0.00,0.00,3.00,207.00,'2023-03-11 16:27:46','',''),(6414,'1','310','1',1,'Retail Sale Id 6241',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 16:29:46','',''),(6415,'1','310','1',1,'Retail Sale Id 6242',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 16:34:58','',''),(6416,'1','310','1',1,'Retail Sale Id 6243',3499.20,0.00,0.00,4.86,335.34,'2023-03-11 16:36:42','',''),(6417,'1','310','1',1,'Retail Sale Id 6244',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 16:39:12','',''),(6418,'1','310','1',1,'Retail Sale Id 6245',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 16:44:28','',''),(6419,'1','310','1',1,'Retail Sale Id 6246',1440.00,0.00,0.00,2.00,138.00,'2023-03-11 16:46:06','',''),(6420,'1','310','1',1,'Retail Sale Id 6247',3002.40,0.00,0.00,4.17,287.73,'2023-03-11 16:47:53','',''),(6421,'1','310','1',1,'Retail Sale Id 6248',3319.20,0.00,0.00,4.61,318.09,'2023-03-11 16:50:23','',''),(6422,'1','310','1',1,'Retail Sale Id 6249',1000.80,0.00,0.00,1.39,95.91,'2023-03-11 16:58:30','',''),(6423,'1','310','1',1,'Retail Sale Id 6250',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 16:59:37','',''),(6424,'1','310','1',1,'Retail Sale Id 6251',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 17:01:43','',''),(6425,'1','310','1',1,'Retail Sale Id 6252',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 17:04:54','',''),(6426,'1','310','1',1,'Retail Sale Id 6253',1000.80,0.00,0.00,1.39,95.91,'2023-03-11 17:10:27','',''),(6427,'1','310','1',1,'Retail Sale Id 6254',2160.00,0.00,0.00,3.00,207.00,'2023-03-11 17:11:48','',''),(6428,'1','310','1',1,'Retail Sale Id 6255',2001.60,0.00,0.00,2.78,191.82,'2023-03-11 17:12:46','',''),(6429,'1','310','1',1,'Retail Sale Id 6256',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 17:14:09','',''),(6430,'1','310','1',1,'Retail Sale Id 6257',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 17:17:47','',''),(6431,'1','310','1',1,'Retail Sale Id 6258',1440.00,0.00,0.00,2.00,138.00,'2023-03-11 17:20:27','',''),(6432,'1','310','1',1,'Retail Sale Id 6259',720.00,0.00,0.00,1.00,69.00,'2023-03-11 17:22:40','',''),(6433,'1','310','1',1,'Retail Sale Id 6260',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 17:24:33','',''),(6434,'1','310','1',1,'Retail Sale Id 6261',3002.40,0.00,0.00,4.17,287.73,'2023-03-11 17:27:34','',''),(6435,'1','310','1',1,'Retail Sale Id 6263',496.80,0.00,0.00,0.69,47.61,'2023-03-11 17:32:03','',''),(6436,'1','310','1',1,'Retail Sale Id 6264',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 17:32:58','',''),(6437,'1','310','1',1,'Retail Sale Id 6265',2160.00,0.00,0.00,3.00,207.00,'2023-03-11 17:37:42','',''),(6438,'1','310','1',1,'Retail Sale Id 6266',3600.00,0.00,0.00,5.00,345.00,'2023-03-11 17:39:58','',''),(6439,'1','310','1',1,'Retail Sale Id 6266',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 17:39:58','',''),(6440,'1','310','1',1,'Retail Sale Id 6267',2160.00,0.00,0.00,3.00,207.00,'2023-03-11 17:41:35','',''),(6441,'1','310','1',1,'Retail Sale Id 6268',1497.60,0.00,0.00,2.08,143.52,'2023-03-11 17:42:23','',''),(6442,'1','310','1',1,'Retail Sale Id 6269',1000.80,0.00,0.00,1.39,95.91,'2023-03-11 17:43:41','',''),(6443,'1','310','1',1,'Retail Sale Id 6270',2001.60,0.00,0.00,2.78,191.82,'2023-03-11 17:45:38','',''),(6444,'1','310','1',1,'Retail Sale Id 6271',1000.80,0.00,0.00,1.39,95.91,'2023-03-11 17:47:38','',''),(6445,'1','310','1',1,'Retail Sale Id 6272',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 17:48:52','',''),(6446,'1','310','1',1,'Retail Sale Id 6273',2203.20,0.00,0.00,3.06,211.14,'2023-03-11 17:49:23','',''),(6447,'1','310','1',1,'Retail Sale Id 6274',1000.80,0.00,0.00,1.39,95.91,'2023-03-11 17:50:08','',''),(6448,'1','310','1',1,'Retail Sale Id 6275',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 17:56:01','',''),(6449,'1','310','1',1,'Retail Sale Id 6276',2001.60,0.00,0.00,2.78,191.82,'2023-03-11 17:57:18','',''),(6450,'1','310','1',1,'Retail Sale Id 6277',2880.00,0.00,0.00,4.00,276.00,'2023-03-11 17:58:42','',''),(6451,'1','310','1',1,'Retail Sale Id 6278',9000.00,0.00,0.00,12.50,862.50,'2023-03-11 17:59:45','',''),(6452,'1','310','1',1,'Retail Sale Id 6279',2160.00,0.00,0.00,3.00,207.00,'2023-03-11 18:12:00','',''),(6453,'1','310','1',1,'Retail Sale Id 6280',2001.60,0.00,0.00,2.78,191.82,'2023-03-11 18:16:29','',''),(6454,'1','310','1',1,'Retail Sale Id 6281',3600.00,0.00,0.00,5.00,345.00,'2023-03-11 18:21:39','',''),(6455,'1','310','1',1,'Retail Sale Id 6282',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 18:23:14','',''),(6456,'1','310','1',1,'Retail Sale Id 6283',3600.00,0.00,0.00,5.00,345.00,'2023-03-11 18:27:29','',''),(6457,'1','310','1',1,'Retail Sale Id 6284',748.80,0.00,0.00,1.04,71.76,'2023-03-11 18:30:30','',''),(6458,'1','310','1',1,'Retail Sale Id 6285',496.80,0.00,0.00,0.69,47.61,'2023-03-11 18:32:56','',''),(6459,'1','310','1',1,'Retail Sale Id 6286',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 18:36:19','',''),(6460,'1','310','1',1,'Retail Sale Id 6287',2001.60,0.00,0.00,2.78,191.82,'2023-03-11 18:41:37','',''),(6461,'1','310','1',1,'Retail Sale Id 6287',4320.00,0.00,0.00,6.00,414.00,'2023-03-11 18:41:37','',''),(6462,'1','310','1',1,'Retail Sale Id 6288',2160.00,0.00,0.00,3.00,207.00,'2023-03-11 18:42:54','',''),(6463,'1','310','1',1,'Retail Sale Id 6289',2001.60,0.00,0.00,2.78,191.82,'2023-03-11 18:47:50','',''),(6464,'1','310','1',1,'Retail Sale Id 6290',1000.80,0.00,0.00,1.39,95.91,'2023-03-11 18:59:43','',''),(6465,'1','310','1',1,'Retail Sale Id 6291',1000.80,0.00,0.00,1.39,95.91,'2023-03-11 19:01:48','',''),(6466,'1','310','1',1,'Return of Retail Sale Id 6278',0.00,9000.00,12.50,0.00,-862.50,'2023-03-11 19:22:33','',''),(6467,'1','310','1',1,'Return of Retail Sale Id 6272',0.00,9000.00,12.50,0.00,-862.50,'2023-03-11 19:24:04','',''),(6468,'1','310','1',1,'Retail Sale Id 6292',2923.20,0.00,0.00,4.06,280.14,'2023-03-11 19:25:18','',''),(6469,'1','310','1',1,'Retail Sale Id 6293',2160.00,0.00,0.00,3.00,207.00,'2023-03-12 07:19:35','',''),(6470,'1','310','1',1,'Retail Sale Id 6294',7200.00,0.00,0.00,10.00,690.00,'2023-03-12 07:24:26','',''),(6471,'1','310','1',1,'Retail Sale Id 6295',2001.60,0.00,0.00,2.78,191.82,'2023-03-12 07:27:21','',''),(6472,'1','310','1',1,'Retail Sale Id 6296',77000.00,0.00,0.00,110.00,5390.00,'2023-03-12 07:29:06','',''),(6473,'1','310','1',1,'Retail Sale Id 6297',1001.00,0.00,0.00,1.43,70.07,'2023-03-12 07:30:30','',''),(6474,'1','310','1',1,'Retail Sale Id 6298',2160.00,0.00,0.00,3.00,207.00,'2023-03-12 07:45:30','',''),(6475,'1','310','1',1,'Retail Sale Id 6299',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 07:52:17','',''),(6476,'1','310','1',1,'Retail Sale Id 6300',3002.40,0.00,0.00,4.17,287.73,'2023-03-12 07:56:32','',''),(6477,'1','310','1',1,'Retail Sale Id 6302',1000.80,0.00,0.00,1.39,95.91,'2023-03-12 08:33:42','',''),(6478,'1','310','1',1,'Retail Sale Id 6303',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 08:40:23','',''),(6479,'1','310','1',1,'Retail Sale Id 6304',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 08:57:49','',''),(6480,'1','310','1',1,'Retail Sale Id 6307',42000.00,0.00,0.00,60.00,2940.00,'2023-03-12 09:00:33','',''),(6481,'1','310','1',1,'Retail Sale Id 6308',35000.00,0.00,0.00,50.00,2450.00,'2023-03-12 09:15:42','',''),(6482,'1','310','1',1,'Retail Sale Id 6309',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 09:18:37','',''),(6483,'1','310','1',1,'Retail Sale Id 6310',1000.80,0.00,0.00,1.39,95.91,'2023-03-12 09:19:42','',''),(6484,'1','310','1',1,'Retail Sale Id 6311',1000.80,0.00,0.00,1.39,95.91,'2023-03-12 09:50:11','',''),(6485,'1','310','1',1,'Retail Sale Id 6312',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 09:51:31','',''),(6486,'1','310','1',1,'Retail Sale Id 6313',3002.40,0.00,0.00,4.17,287.73,'2023-03-12 09:53:44','',''),(6487,'1','310','1',1,'Retail Sale Id 6314',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 09:57:54','',''),(6488,'1','310','1',1,'Retail Sale Id 6315',2880.00,0.00,0.00,4.00,276.00,'2023-03-12 10:00:13','',''),(6489,'1','310','1',1,'Retail Sale Id 6316',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 10:01:35','',''),(6490,'1','310','1',1,'Retail Sale Id 6317',2498.40,0.00,0.00,3.47,239.43,'2023-03-12 10:07:20','',''),(6491,'1','310','1',1,'Retail Sale Id 6318',3499.20,0.00,0.00,4.86,335.34,'2023-03-12 10:12:03','',''),(6492,'1','310','1',1,'Retail Sale Id 6318',3499.20,0.00,0.00,4.86,335.34,'2023-03-12 10:12:03','',''),(6493,'1','310','1',1,'Retail Sale Id 6319',2160.00,0.00,0.00,3.00,207.00,'2023-03-12 10:17:34','',''),(6494,'1','310','1',1,'Retail Sale Id 6320',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 10:18:59','',''),(6495,'1','310','1',1,'Retail Sale Id 6321',2160.00,0.00,0.00,3.00,207.00,'2023-03-12 10:20:18','',''),(6496,'1','310','1',1,'Retail Sale Id 6322',2001.60,0.00,0.00,2.78,191.82,'2023-03-12 10:21:37','',''),(6497,'1','310','1',1,'Retail Sale Id 6323',2001.60,0.00,0.00,2.78,191.82,'2023-03-12 10:23:03','',''),(6498,'1','310','1',1,'Retail Sale Id 6324',3600.00,0.00,0.00,5.00,345.00,'2023-03-12 10:24:40','',''),(6499,'1','310','1',1,'Retail Sale Id 6325',3002.40,0.00,0.00,4.17,287.73,'2023-03-12 10:26:20','',''),(6500,'1','310','1',1,'Retail Sale Id 6326',1497.60,0.00,0.00,2.08,143.52,'2023-03-12 10:27:47','',''),(6501,'1','310','1',1,'Retail Sale Id 6327',2498.40,0.00,0.00,3.47,239.43,'2023-03-12 10:29:18','',''),(6502,'1','310','1',1,'Retail Sale Id 6328',4003.20,0.00,0.00,5.56,383.64,'2023-03-12 10:34:52','',''),(6503,'1','310','1',1,'Retail Sale Id 6329',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 10:43:06','',''),(6504,'1','310','1',1,'Retail Sale Id 6330',1497.60,0.00,0.00,2.08,143.52,'2023-03-12 10:46:21','',''),(6505,'1','310','1',1,'Retail Sale Id 6331',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 10:50:21','',''),(6506,'1','310','1',1,'Retail Sale Id 6332',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 10:56:12','',''),(6507,'1','310','1',1,'Retail Sale Id 6334',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 10:59:44','',''),(6508,'1','310','1',1,'Retail Sale Id 6334',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 10:59:44','',''),(6509,'1','310','1',1,'Retail Sale Id 6335',799.20,0.00,0.00,1.11,76.59,'2023-03-12 11:01:01','',''),(6510,'1','310','1',1,'Retail Sale Id 6336',1000.80,0.00,0.00,1.39,95.91,'2023-03-12 11:02:19','',''),(6511,'1','310','1',1,'Retail Sale Id 6337',2160.00,0.00,0.00,3.00,207.00,'2023-03-12 11:03:23','',''),(6512,'1','310','1',1,'Retail Sale Id 6338',5040.00,0.00,0.00,7.00,483.00,'2023-03-12 11:04:19','',''),(6513,'1','310','1',1,'Retail Sale Id 6339',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 11:08:00','',''),(6514,'1','310','1',1,'Retail Sale Id 6339',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 11:08:00','',''),(6515,'1','310','1',1,'Retail Sale Id 6341',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 11:10:07','',''),(6516,'1','310','1',1,'Retail Sale Id 6341',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 11:10:07','',''),(6517,'1','310','1',1,'Retail Sale Id 6342',2160.00,0.00,0.00,3.00,207.00,'2023-03-12 11:11:45','',''),(6518,'1','310','1',1,'Retail Sale Id 6343',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 11:16:06','',''),(6519,'1','310','1',1,'Retail Sale Id 6344',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 11:17:32','',''),(6520,'1','310','1',1,'Retail Sale Id 6345',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 11:21:05','',''),(6521,'1','310','1',1,'Retail Sale Id 6346',4003.20,0.00,0.00,5.56,383.64,'2023-03-12 11:25:07','',''),(6522,'1','310','1',1,'Retail Sale Id 6347',3600.00,0.00,0.00,5.00,345.00,'2023-03-12 11:27:26','',''),(6523,'1','310','1',1,'Retail Sale Id 6347',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 11:27:26','',''),(6524,'1','310','1',1,'Retail Sale Id 6348',77000.00,0.00,0.00,110.00,5390.00,'2023-03-12 11:28:40','',''),(6525,'1','310','1',1,'Retail Sale Id 6349',8001.00,0.00,0.00,11.43,560.07,'2023-03-12 11:30:22','',''),(6526,'1','310','1',1,'Retail Sale Id 6350',1497.60,0.00,0.00,2.08,143.52,'2023-03-12 11:31:51','',''),(6527,'1','310','1',1,'Retail Sale Id 6351',2001.60,0.00,0.00,2.78,191.82,'2023-03-12 11:33:33','',''),(6528,'1','310','1',1,'Retail Sale Id 6352',2203.20,0.00,0.00,3.06,211.14,'2023-03-12 11:34:25','',''),(6529,'1','310','1',1,'Retail Sale Id 6354',496.80,0.00,0.00,0.69,47.61,'2023-03-12 11:36:16','',''),(6530,'1','310','1',1,'Retail Sale Id 6354',2160.00,0.00,0.00,3.00,207.00,'2023-03-12 11:36:16','',''),(6531,'1','310','1',1,'Retail Sale Id 6354',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 11:36:16','',''),(6532,'1','310','1',1,'Retail Sale Id 6355',1497.60,0.00,0.00,2.08,143.52,'2023-03-12 11:37:58','',''),(6533,'1','310','1',1,'Retail Sale Id 6356',2001.60,0.00,0.00,2.78,191.82,'2023-03-12 11:39:03','',''),(6534,'1','310','1',1,'Retail Sale Id 6357',496.80,0.00,0.00,0.69,47.61,'2023-03-12 11:40:05','',''),(6535,'1','310','1',1,'Retail Sale Id 6358',14500.80,0.00,0.00,20.14,1389.66,'2023-03-12 11:41:40','',''),(6536,'1','310','1',1,'Retail Sale Id 6359',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 11:43:50','',''),(6537,'1','310','1',1,'Retail Sale Id 6359',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 11:43:50','',''),(6538,'1','310','1',1,'Retail Sale Id 6360',1000.80,0.00,0.00,1.39,95.91,'2023-03-12 11:44:39','',''),(6539,'1','310','1',1,'Retail Sale Id 6361',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 11:47:55','',''),(6540,'1','310','1',1,'Retail Sale Id 6362',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 11:49:14','',''),(6541,'1','310','1',1,'Retail Sale Id 6363',3600.00,0.00,0.00,5.00,345.00,'2023-03-12 11:50:42','',''),(6542,'1','310','1',1,'Retail Sale Id 6364',2160.00,0.00,0.00,3.00,207.00,'2023-03-12 11:53:01','',''),(6543,'1','310','1',1,'Retail Sale Id 6365',3600.00,0.00,0.00,5.00,345.00,'2023-03-12 11:54:08','',''),(6544,'1','310','1',1,'Retail Sale Id 6366',1000.80,0.00,0.00,1.39,95.91,'2023-03-12 11:55:57','',''),(6545,'1','310','1',1,'Retail Sale Id 6367',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 11:56:45','',''),(6546,'1','310','1',1,'Retail Sale Id 6368',3600.00,0.00,0.00,5.00,345.00,'2023-03-12 11:57:38','',''),(6547,'1','310','1',1,'Retail Sale Id 6369',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 11:58:24','',''),(6548,'1','310','1',1,'Retail Sale Id 6370',161000.00,0.00,0.00,230.00,11270.00,'2023-03-12 11:59:59','',''),(6549,'1','310','1',1,'Retail Sale Id 6371',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 12:01:05','',''),(6550,'1','310','1',1,'Retail Sale Id 6372',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 12:02:03','',''),(6551,'1','310','1',1,'Retail Sale Id 6374',175000.00,0.00,0.00,250.00,12250.00,'2023-03-12 12:04:13','',''),(6552,'1','310','1',1,'Retail Sale Id 6375',2160.00,0.00,0.00,3.00,207.00,'2023-03-12 12:05:39','',''),(6553,'1','310','1',1,'Retail Sale Id 6376',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 12:06:15','',''),(6554,'1','310','1',1,'Retail Sale Id 6377',35000.00,0.00,0.00,50.00,2450.00,'2023-03-12 12:07:10','',''),(6555,'1','310','1',1,'Retail Sale Id 6378',1800.00,0.00,0.00,2.50,172.50,'2023-03-12 12:08:03','',''),(6556,'1','310','1',1,'Retail Sale Id 6379',2160.00,0.00,0.00,3.00,207.00,'2023-03-12 12:08:51','',''),(6557,'1','310','1',1,'Retail Sale Id 6380',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 12:09:30','',''),(6558,'1','310','1',1,'Retail Sale Id 6381',2001.60,0.00,0.00,2.78,191.82,'2023-03-12 12:10:18','',''),(6559,'1','310','1',1,'Retail Sale Id 6382',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 12:11:07','',''),(6560,'1','310','1',1,'Retail Sale Id 6383',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 12:12:06','',''),(6561,'1','310','1',1,'Retail Sale Id 6384',3600.00,0.00,0.00,5.00,345.00,'2023-03-12 12:13:00','',''),(6562,'1','310','1',1,'Retail Sale Id 6385',4500.00,0.00,0.00,6.25,431.25,'2023-03-12 12:14:46','',''),(6563,'1','310','1',1,'Retail Sale Id 6386',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 12:15:46','',''),(6564,'1','310','1',1,'Retail Sale Id 6386',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 12:15:46','',''),(6565,'1','310','1',1,'Retail Sale Id 6387',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 12:16:30','',''),(6566,'1','310','1',1,'Retail Sale Id 6388',4500.00,0.00,0.00,6.25,431.25,'2023-03-12 12:17:06','',''),(6567,'1','310','1',1,'Retail Sale Id 6389',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 12:17:46','',''),(6568,'1','310','1',1,'Retail Sale Id 6390',3600.00,0.00,0.00,5.00,345.00,'2023-03-12 12:18:30','',''),(6569,'1','310','1',1,'Retail Sale Id 6392',2160.00,0.00,0.00,3.00,207.00,'2023-03-12 12:19:48','',''),(6570,'1','310','1',1,'Retail Sale Id 6393',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 12:20:29','',''),(6571,'1','310','1',1,'Retail Sale Id 6394',2001.60,0.00,0.00,2.78,191.82,'2023-03-12 12:27:40','',''),(6572,'1','310','1',1,'Retail Sale Id 6394',4996.80,0.00,0.00,6.94,478.86,'2023-03-12 12:27:40','',''),(6573,'1','310','1',1,'Retail Sale Id 6395',2001.60,0.00,0.00,2.78,191.82,'2023-03-12 12:28:23','',''),(6574,'1','310','1',1,'Retail Sale Id 6396',2001.60,0.00,0.00,2.78,191.82,'2023-03-12 12:29:32','',''),(6575,'1','310','1',1,'Retail Sale Id 6397',2001.60,0.00,0.00,2.78,191.82,'2023-03-12 12:30:22','',''),(6576,'1','310','1',1,'Retail Sale Id 6398',1497.60,0.00,0.00,2.08,143.52,'2023-03-12 12:31:30','',''),(6577,'1','310','1',1,'Retail Sale Id 6399',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 12:32:25','',''),(6578,'1','310','1',1,'Retail Sale Id 6400',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 12:33:21','',''),(6579,'1','310','1',1,'Retail Sale Id 6401',3600.00,0.00,0.00,5.00,345.00,'2023-03-12 12:34:04','',''),(6580,'1','310','1',1,'Retail Sale Id 6402',2001.60,0.00,0.00,2.78,191.82,'2023-03-12 12:35:06','',''),(6581,'1','310','1',1,'Retail Sale Id 6403',4500.00,0.00,0.00,6.25,431.25,'2023-03-12 12:38:01','',''),(6582,'1','310','1',1,'Retail Sale Id 6404',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 12:38:59','',''),(6583,'1','310','1',1,'Retail Sale Id 6406',1497.60,0.00,0.00,2.08,143.52,'2023-03-12 12:41:17','',''),(6584,'1','310','1',1,'Retail Sale Id 6407',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 12:43:12','',''),(6585,'1','310','1',1,'Retail Sale Id 6407',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 12:43:12','',''),(6586,'1','310','1',1,'Retail Sale Id 6408',1000.80,0.00,0.00,1.39,95.91,'2023-03-12 12:45:09','',''),(6587,'1','310','1',1,'Retail Sale Id 6409',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 12:47:21','',''),(6588,'1','310','1',1,'Retail Sale Id 6410',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 12:48:20','',''),(6589,'1','310','1',1,'Retail Sale Id 6411',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 12:51:06','',''),(6590,'1','310','1',1,'Retail Sale Id 6412',2160.00,0.00,0.00,3.00,207.00,'2023-03-12 12:56:59','',''),(6591,'1','310','1',1,'Retail Sale Id 6413',1000.80,0.00,0.00,1.39,95.91,'2023-03-12 12:58:23','',''),(6592,'1','310','1',1,'Retail Sale Id 6414',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 12:59:17','',''),(6593,'1','310','1',1,'Retail Sale Id 6415',1000.80,0.00,0.00,1.39,95.91,'2023-03-12 13:00:54','',''),(6594,'1','310','1',1,'Retail Sale Id 6416',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 13:09:43','',''),(6595,'1','310','1',1,'Retail Sale Id 6416',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 13:09:43','',''),(6596,'1','310','1',1,'Retail Sale Id 6417',2203.20,0.00,0.00,3.06,211.14,'2023-03-12 13:10:42','',''),(6597,'1','310','1',1,'Retail Sale Id 6418',18000.00,0.00,0.00,25.00,1725.00,'2023-03-12 13:15:51','',''),(6598,'1','310','1',1,'Retail Sale Id 6419',2001.60,0.00,0.00,2.78,191.82,'2023-03-12 13:19:39','',''),(6599,'1','310','1',1,'Retail Sale Id 6420',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 13:20:53','',''),(6600,'1','310','1',1,'Retail Sale Id 6421',8640.00,0.00,0.00,12.00,828.00,'2023-03-12 13:23:00','',''),(6601,'1','310','1',1,'Retail Sale Id 6422',91000.00,0.00,0.00,130.00,6370.00,'2023-03-12 13:25:57','',''),(6602,'1','310','1',1,'Retail Sale Id 6423',3002.40,0.00,0.00,4.17,287.73,'2023-03-12 13:32:55','',''),(6603,'1','310','1',1,'Retail Sale Id 6424',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 13:38:33','',''),(6604,'1','310','1',1,'Retail Sale Id 6424',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 13:38:33','',''),(6605,'1','310','1',1,'Retail Sale Id 6425',35000.00,0.00,0.00,50.00,2450.00,'2023-03-12 13:40:27','',''),(6606,'1','310','1',1,'Retail Sale Id 6426',3002.40,0.00,0.00,4.17,287.73,'2023-03-12 13:41:42','',''),(6607,'1','310','1',1,'Retail Sale Id 6427',2160.00,0.00,0.00,3.00,207.00,'2023-03-12 13:43:17','',''),(6608,'1','310','1',1,'Retail Sale Id 6428',7999.20,0.00,0.00,11.11,766.59,'2023-03-12 13:44:22','',''),(6609,'1','310','1',1,'Retail Sale Id 6429',4003.20,0.00,0.00,5.56,383.64,'2023-03-12 13:45:59','',''),(6610,'1','310','1',1,'Retail Sale Id 6430',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 13:47:04','',''),(6611,'1','310','1',1,'Retail Sale Id 6431',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 13:48:22','',''),(6612,'1','310','1',1,'Retail Sale Id 6432',3002.40,0.00,0.00,4.17,287.73,'2023-03-12 13:59:40','',''),(6613,'1','310','1',1,'Retail Sale Id 6433',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 14:04:11','',''),(6614,'1','310','1',1,'Retail Sale Id 6434',4996.80,0.00,0.00,6.94,478.86,'2023-03-12 14:06:31','',''),(6615,'1','310','1',1,'Retail Sale Id 6436',2901.60,0.00,0.00,4.03,278.07,'2023-03-12 14:09:38','',''),(6616,'1','310','1',1,'Retail Sale Id 6437',2160.00,0.00,0.00,3.00,207.00,'2023-03-12 14:12:37','',''),(6617,'1','310','1',1,'Retail Sale Id 6438',799.20,0.00,0.00,1.11,76.59,'2023-03-12 14:13:54','',''),(6618,'1','310','1',1,'Retail Sale Id 6439',2160.00,0.00,0.00,3.00,207.00,'2023-03-12 14:25:00','',''),(6619,'1','310','1',1,'Retail Sale Id 6440',1000.80,0.00,0.00,1.39,95.91,'2023-03-12 14:28:48','',''),(6620,'1','310','1',1,'Retail Sale Id 6441',2001.60,0.00,0.00,2.78,191.82,'2023-03-12 14:36:10','',''),(6621,'1','310','1',1,'Retail Sale Id 6442',3499.20,0.00,0.00,4.86,335.34,'2023-03-12 14:43:08','',''),(6622,'1','310','1',1,'Retail Sale Id 6443',496.80,0.00,0.00,0.69,47.61,'2023-03-12 14:45:01','',''),(6623,'1','310','1',1,'Retail Sale Id 6444',3600.00,0.00,0.00,5.00,345.00,'2023-03-12 14:46:45','',''),(6624,'1','310','1',1,'Retail Sale Id 6445',1497.60,0.00,0.00,2.08,143.52,'2023-03-12 14:59:07','',''),(6625,'1','310','1',1,'Retail Sale Id 6446',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 15:07:20','',''),(6626,'1','310','1',1,'Retail Sale Id 6446',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 15:07:20','',''),(6627,'1','310','1',1,'Retail Sale Id 6447',6480.00,0.00,0.00,9.00,621.00,'2023-03-12 15:08:47','',''),(6628,'1','310','1',1,'Retail Sale Id 6448',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 15:09:58','',''),(6629,'1','310','1',1,'Retail Sale Id 6449',2160.00,0.00,0.00,3.00,207.00,'2023-03-12 15:10:59','',''),(6630,'1','310','1',1,'Retail Sale Id 6449',2160.00,0.00,0.00,3.00,207.00,'2023-03-12 15:10:59','',''),(6631,'1','310','1',1,'Retail Sale Id 6449',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 15:10:59','',''),(6632,'1','310','1',1,'Retail Sale Id 6450',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 15:11:40','',''),(6633,'1','310','1',1,'Retail Sale Id 6451',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 15:12:30','',''),(6634,'1','310','1',1,'Retail Sale Id 6452',2001.60,0.00,0.00,2.78,191.82,'2023-03-12 15:22:29','',''),(6635,'1','310','1',1,'Retail Sale Id 6453',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 15:30:26','',''),(6636,'1','310','1',1,'Retail Sale Id 6454',8400.00,0.00,0.00,12.00,588.00,'2023-03-12 15:36:26','',''),(6637,'1','310','1',1,'Retail Sale Id 6455',7200.00,0.00,0.00,10.00,690.00,'2023-03-12 15:39:50','',''),(6638,'1','310','1',1,'Retail Sale Id 6456',2001.60,0.00,0.00,2.78,191.82,'2023-03-12 15:41:38','',''),(6639,'1','310','1',1,'Retail Sale Id 6456',2160.00,0.00,0.00,3.00,207.00,'2023-03-12 15:41:38','',''),(6640,'1','310','1',1,'Retail Sale Id 6457',2001.60,0.00,0.00,2.78,191.82,'2023-03-12 15:43:41','',''),(6641,'1','310','1',1,'Retail Sale Id 6457',2001.60,0.00,0.00,2.78,191.82,'2023-03-12 15:43:41','',''),(6642,'1','310','1',1,'Retail Sale Id 6458',3103.20,0.00,0.00,4.31,297.39,'2023-03-12 15:47:54','',''),(6643,'1','310','1',1,'Retail Sale Id 6460',35000.00,0.00,0.00,50.00,2450.00,'2023-03-12 15:49:49','',''),(6644,'1','310','1',1,'Retail Sale Id 6461',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 15:54:15','',''),(6645,'1','310','1',1,'Retail Sale Id 6462',2001.60,0.00,0.00,2.78,191.82,'2023-03-12 15:55:17','',''),(6646,'1','310','1',1,'Retail Sale Id 6463',3002.40,0.00,0.00,4.17,287.73,'2023-03-12 15:56:24','',''),(6647,'1','310','1',1,'Retail Sale Id 6464',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 16:21:37','',''),(6648,'1','310','1',1,'Retail Sale Id 6465',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 16:32:27','',''),(6649,'1','310','1',1,'Retail Sale Id 6466',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 16:34:39','',''),(6650,'1','310','1',1,'Retail Sale Id 6467',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 16:38:17','',''),(6651,'1','310','1',1,'Retail Sale Id 6468',1497.60,0.00,0.00,2.08,143.52,'2023-03-12 16:45:11','',''),(6652,'1','310','1',1,'Retail Sale Id 6470',720.00,0.00,0.00,1.00,69.00,'2023-03-12 16:56:33','',''),(6653,'1','310','1',1,'Retail Sale Id 6471',4003.20,0.00,0.00,5.56,383.64,'2023-03-12 16:58:35','',''),(6654,'1','310','1',1,'Retail Sale Id 6472',3600.00,0.00,0.00,5.00,345.00,'2023-03-12 17:03:50','',''),(6655,'1','310','1',1,'Retail Sale Id 6473',1440.00,0.00,0.00,2.00,138.00,'2023-03-12 17:06:16','',''),(6656,'1','310','1',1,'Retail Sale Id 6474',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 17:18:59','',''),(6657,'1','310','1',1,'Retail Sale Id 6475',496.80,0.00,0.00,0.69,47.61,'2023-03-12 17:20:16','',''),(6658,'1','310','1',1,'Retail Sale Id 6476',1497.60,0.00,0.00,2.08,143.52,'2023-03-12 17:24:29','',''),(6659,'1','310','1',1,'Retail Sale Id 6477',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 17:25:26','',''),(6660,'1','310','1',1,'Retail Sale Id 6478',2160.00,0.00,0.00,3.00,207.00,'2023-03-12 17:30:55','',''),(6661,'1','310','1',1,'Retail Sale Id 6479',5997.60,0.00,0.00,8.33,574.77,'2023-03-12 17:32:01','',''),(6662,'1','310','1',1,'Retail Sale Id 6480',482.40,0.00,0.00,0.67,46.23,'2023-03-12 17:33:38','',''),(6663,'1','310','1',1,'Retail Sale Id 6481',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 17:51:22','',''),(6664,'1','310','1',1,'Retail Sale Id 6482',9000.00,0.00,0.00,12.50,862.50,'2023-03-12 17:55:28','',''),(6665,'1','310','1',1,'Retail Sale Id 6483',2001.60,0.00,0.00,2.78,191.82,'2023-03-12 18:01:55','',''),(6666,'1','310','1',1,'Retail Sale Id 6484',2498.40,0.00,0.00,3.47,239.43,'2023-03-12 18:04:38','',''),(6667,'1','310','1',1,'Retail Sale Id 6485',3002.40,0.00,0.00,4.17,287.73,'2023-03-12 18:05:41','',''),(6668,'1','310','1',1,'Retail Sale Id 6486',2498.40,0.00,0.00,3.47,239.43,'2023-03-12 18:07:44','',''),(6669,'1','310','1',1,'Retail Sale Id 6487',1440.00,0.00,0.00,2.00,138.00,'2023-03-12 18:11:57','',''),(6670,'1','310','1',1,'Retail Sale Id 6488',1000.80,0.00,0.00,1.39,95.91,'2023-03-12 18:13:19','',''),(6671,'1','310','1',1,'Retail Sale Id 6489',1497.60,0.00,0.00,2.08,143.52,'2023-03-12 18:16:16','',''),(6672,'1','310','1',1,'Retail Sale Id 6490',1000.80,0.00,0.00,1.39,95.91,'2023-03-12 18:17:26','',''),(6673,'1','310','1',1,'Retail Sale Id 6491',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 18:23:46','',''),(6674,'1','310','1',1,'Retail Sale Id 6492',2001.60,0.00,0.00,2.78,191.82,'2023-03-12 18:37:08','',''),(6675,'1','310','1',1,'Retail Sale Id 6493',1497.60,0.00,0.00,2.08,143.52,'2023-03-12 18:40:29','',''),(6676,'1','310','1',1,'Retail Sale Id 6494',9496.80,0.00,0.00,13.19,910.11,'2023-03-12 18:45:41','',''),(6677,'1','310','1',1,'Retail Sale Id 6495',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 18:49:11','',''),(6678,'1','310','1',1,'Retail Sale Id 6496',2498.40,0.00,0.00,3.47,239.43,'2023-03-12 18:51:42','',''),(6679,'1','310','1',1,'Retail Sale Id 6497',2100.00,0.00,0.00,3.00,147.00,'2023-03-12 19:00:25','',''),(6680,'1','310','1',1,'Retail Sale Id 6498',2160.00,0.00,0.00,3.00,207.00,'2023-03-12 19:05:36','',''),(6681,'1','310','1',1,'Retail Sale Id 6499',1598.40,0.00,0.00,2.22,153.18,'2023-03-12 19:08:18','',''),(6682,'1','310','1',1,'Return of Retail Sale Id 6494',0.00,9496.80,13.19,0.00,-910.11,'2023-03-12 19:13:33','',''),(6683,'1','310','1',1,'Return of Retail Sale Id 6491',0.00,4320.00,6.00,0.00,-414.00,'2023-03-12 19:14:24','',''),(6684,'1','310','1',1,'Retail Sale Id 6500',2750.40,0.00,0.00,3.82,263.58,'2023-03-12 19:25:07','',''),(6685,'1','310','1',1,'Return of Retail Sale Id 6497',0.00,2100.00,3.00,0.00,-147.00,'2023-03-12 19:26:07','',''),(6686,'1','310','1',1,'Retail Sale Id 6501',2093.00,0.00,0.00,2.99,146.51,'2023-03-12 19:28:09','',''),(6687,'1','310','1',1,'Return of Retail Sale Id 6501',0.00,2093.00,2.99,0.00,-146.51,'2023-03-12 19:32:16','',''),(6688,'1','310','1',1,'Retail Sale Id 6502',2093.00,0.00,0.00,2.99,146.51,'2023-03-12 19:35:47','',''),(6689,'1','310','1',1,'Return of Retail Sale Id 6502',0.00,2093.00,2.99,0.00,-146.51,'2023-03-12 19:37:46','',''),(6690,'1','310','1',1,'Retail Sale Id 6503',2095.20,0.00,0.00,2.91,200.79,'2023-03-12 19:39:08','',''),(6691,'1','310','1',1,'Retail Sale Id 6504',4320.00,0.00,0.00,6.00,414.00,'2023-03-12 19:43:35','',''),(6692,'1','310','1',1,'Return of Retail Sale Id 6504',0.00,4320.00,6.00,0.00,-414.00,'2023-03-12 19:46:37','',''),(6693,'1','310','1',1,'Retail Sale Id 6505',42000.00,0.00,0.00,60.00,2940.00,'2023-03-13 07:35:11','',''),(6694,'1','310','1',1,'Retail Sale Id 6506',2160.00,0.00,0.00,3.00,207.00,'2023-03-13 07:38:14','',''),(6695,'1','310','1',1,'Retail Sale Id 6507',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 07:39:50','',''),(6696,'1','310','1',1,'Retail Sale Id 6508',2160.00,0.00,0.00,3.00,207.00,'2023-03-13 08:16:24','',''),(6697,'1','310','1',1,'Retail Sale Id 6508',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 08:16:24','',''),(6698,'1','310','1',1,'Retail Sale Id 6508',8517.60,0.00,0.00,11.83,816.27,'2023-03-13 08:16:24','',''),(6699,'1','310','1',1,'Retail Sale Id 6511',9000.00,0.00,0.00,12.50,862.50,'2023-03-13 08:23:01','',''),(6700,'1','310','1',1,'Retail Sale Id 6512',3600.00,0.00,0.00,5.00,345.00,'2023-03-13 08:25:35','',''),(6701,'1','310','1',1,'Retail Sale Id 6515',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 08:38:24','',''),(6702,'1','310','1',1,'Retail Sale Id 6516',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 08:49:57','',''),(6703,'1','310','1',1,'Retail Sale Id 6517',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 08:59:06','',''),(6704,'1','310','1',1,'Retail Sale Id 6518',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 09:00:51','',''),(6705,'1','310','1',1,'Retail Sale Id 6519',3002.40,0.00,0.00,4.17,287.73,'2023-03-13 09:06:05','',''),(6706,'1','310','1',1,'Retail Sale Id 6520',4003.20,0.00,0.00,5.56,383.64,'2023-03-13 09:18:08','',''),(6707,'1','310','1',1,'Retail Sale Id 6521',9000.00,0.00,0.00,12.50,862.50,'2023-03-13 09:20:08','',''),(6708,'1','310','1',1,'Retail Sale Id 6522',720.00,0.00,0.00,1.00,69.00,'2023-03-13 09:24:28','',''),(6709,'1','310','1',1,'Retail Sale Id 6523',9000.00,0.00,0.00,12.50,862.50,'2023-03-13 09:26:48','',''),(6710,'1','310','1',1,'Retail Sale Id 6524',4003.20,0.00,0.00,5.56,383.64,'2023-03-13 09:28:20','',''),(6711,'1','310','1',1,'Retail Sale Id 6525',3002.40,0.00,0.00,4.17,287.73,'2023-03-13 09:30:24','',''),(6712,'1','310','1',1,'Retail Sale Id 6526',3600.00,0.00,0.00,5.00,345.00,'2023-03-13 09:38:17','',''),(6713,'1','310','1',1,'Retail Sale Id 6527',1000.80,0.00,0.00,1.39,95.91,'2023-03-13 09:39:58','',''),(6714,'1','310','1',1,'Retail Sale Id 6527',3002.40,0.00,0.00,4.17,287.73,'2023-03-13 09:39:58','',''),(6715,'1','310','1',1,'Retail Sale Id 6529',4996.80,0.00,0.00,6.94,478.86,'2023-03-13 09:46:46','',''),(6716,'1','310','1',1,'Retail Sale Id 6530',1202.40,0.00,0.00,1.67,115.23,'2023-03-13 09:48:56','',''),(6717,'1','310','1',1,'Retail Sale Id 6531',720.00,0.00,0.00,1.00,69.00,'2023-03-13 09:51:32','',''),(6718,'1','310','1',1,'Retail Sale Id 6531',9000.00,0.00,0.00,12.50,862.50,'2023-03-13 09:51:32','',''),(6719,'1','310','1',1,'Retail Sale Id 6532',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 09:53:32','',''),(6720,'1','310','1',1,'Retail Sale Id 6533',3600.00,0.00,0.00,5.00,345.00,'2023-03-13 09:54:36','',''),(6721,'1','310','1',1,'Retail Sale Id 6534',597.60,0.00,0.00,0.83,57.27,'2023-03-13 10:03:40','',''),(6722,'1','310','1',1,'Retail Sale Id 6535',1000.80,0.00,0.00,1.39,95.91,'2023-03-13 10:08:16','',''),(6723,'1','310','1',1,'Retail Sale Id 6535',1497.60,0.00,0.00,2.08,143.52,'2023-03-13 10:08:16','',''),(6724,'1','310','1',1,'Retail Sale Id 6536',3499.20,0.00,0.00,4.86,335.34,'2023-03-13 10:10:01','',''),(6725,'1','310','1',1,'Retail Sale Id 6537',8400.00,0.00,0.00,12.00,588.00,'2023-03-13 10:11:32','',''),(6726,'1','310','1',1,'Retail Sale Id 6538',9000.00,0.00,0.00,12.50,862.50,'2023-03-13 10:13:06','',''),(6727,'1','310','1',1,'Retail Sale Id 6539',3600.00,0.00,0.00,5.00,345.00,'2023-03-13 10:14:19','',''),(6728,'1','310','1',1,'Retail Sale Id 6540',4996.80,0.00,0.00,6.94,478.86,'2023-03-13 10:28:55','',''),(6729,'1','310','1',1,'Retail Sale Id 6541',496.80,0.00,0.00,0.69,47.61,'2023-03-13 10:43:25','',''),(6730,'1','310','1',1,'Retail Sale Id 6542',44849.00,0.00,0.00,64.07,3139.43,'2023-03-13 10:57:24','',''),(6731,'1','310','1',1,'Retail Sale Id 6544',1000.80,0.00,0.00,1.39,95.91,'2023-03-13 11:00:34','',''),(6732,'1','310','1',1,'Retail Sale Id 6545',2160.00,0.00,0.00,3.00,207.00,'2023-03-13 11:01:25','',''),(6733,'1','310','1',1,'Retail Sale Id 6546',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 11:04:42','',''),(6734,'1','310','1',1,'Retail Sale Id 6547',4003.20,0.00,0.00,5.56,383.64,'2023-03-13 11:15:46','',''),(6735,'1','310','1',1,'Retail Sale Id 6548',4500.00,0.00,0.00,6.25,431.25,'2023-03-13 11:54:31','',''),(6736,'1','310','1',1,'Retail Sale Id 6549',2160.00,0.00,0.00,3.00,207.00,'2023-03-13 11:58:41','',''),(6737,'1','310','1',1,'Retail Sale Id 6550',4003.20,0.00,0.00,5.56,383.64,'2023-03-13 11:59:48','',''),(6738,'1','310','1',1,'Retail Sale Id 6551',2498.40,0.00,0.00,3.47,239.43,'2023-03-13 12:07:14','',''),(6739,'1','310','1',1,'Retail Sale Id 6552',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 12:08:40','',''),(6740,'1','310','1',1,'Retail Sale Id 6553',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 12:10:13','',''),(6741,'1','310','1',1,'Retail Sale Id 6554',5040.00,0.00,0.00,7.00,483.00,'2023-03-13 12:13:39','',''),(6742,'1','310','1',1,'Retail Sale Id 6555',35000.00,0.00,0.00,50.00,2450.00,'2023-03-13 12:15:10','',''),(6743,'1','310','1',1,'Retail Sale Id 6556',7200.00,0.00,0.00,10.00,690.00,'2023-03-13 12:23:56','',''),(6744,'1','310','1',1,'Retail Sale Id 6557',3002.40,0.00,0.00,4.17,287.73,'2023-03-13 12:27:33','',''),(6745,'1','310','1',1,'Retail Sale Id 6558',2160.00,0.00,0.00,3.00,207.00,'2023-03-13 12:30:35','',''),(6746,'1','310','1',1,'Retail Sale Id 6559',3600.00,0.00,0.00,5.00,345.00,'2023-03-13 12:40:08','',''),(6747,'1','310','1',1,'Retail Sale Id 6560',35000.00,0.00,0.00,50.00,2450.00,'2023-03-13 12:43:13','',''),(6748,'1','310','1',1,'Retail Sale Id 6561',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 12:44:32','',''),(6749,'1','310','1',1,'Retail Sale Id 6562',1440.00,0.00,0.00,2.00,138.00,'2023-03-13 12:57:00','',''),(6750,'1','310','1',1,'Retail Sale Id 6563',9000.00,0.00,0.00,12.50,862.50,'2023-03-13 12:59:54','',''),(6751,'1','310','1',1,'Retail Sale Id 6564',9000.00,0.00,0.00,12.50,862.50,'2023-03-13 13:03:25','',''),(6752,'1','310','1',1,'Retail Sale Id 6565',1000.80,0.00,0.00,1.39,95.91,'2023-03-13 13:04:08','',''),(6753,'1','310','1',1,'Retail Sale Id 6566',2203.20,0.00,0.00,3.06,211.14,'2023-03-13 13:05:06','',''),(6754,'1','310','1',1,'Retail Sale Id 6568',2160.00,0.00,0.00,3.00,207.00,'2023-03-13 13:08:24','',''),(6755,'1','310','1',1,'Retail Sale Id 6569',2203.20,0.00,0.00,3.06,211.14,'2023-03-13 13:09:22','',''),(6756,'1','310','1',1,'Retail Sale Id 6570',3600.00,0.00,0.00,5.00,345.00,'2023-03-13 13:11:12','',''),(6757,'1','310','1',1,'Retail Sale Id 6571',2901.60,0.00,0.00,4.03,278.07,'2023-03-13 13:12:23','',''),(6758,'1','310','1',1,'Retail Sale Id 6573',2160.00,0.00,0.00,3.00,207.00,'2023-03-13 13:23:37','',''),(6759,'1','310','1',1,'Retail Sale Id 6574',3600.00,0.00,0.00,5.00,345.00,'2023-03-13 13:41:19','',''),(6760,'1','310','1',1,'Retail Sale Id 6575',9000.00,0.00,0.00,12.50,862.50,'2023-03-13 13:44:57','',''),(6761,'1','310','1',1,'Retail Sale Id 6576',3600.00,0.00,0.00,5.00,345.00,'2023-03-13 13:49:07','',''),(6762,'1','310','1',1,'Retail Sale Id 6577',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 13:50:47','',''),(6763,'1','310','1',1,'Retail Sale Id 6578',9000.00,0.00,0.00,12.50,862.50,'2023-03-13 13:56:09','',''),(6764,'1','310','1',1,'Retail Sale Id 6579',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 13:57:52','',''),(6765,'1','310','1',1,'Retail Sale Id 6580',2160.00,0.00,0.00,3.00,207.00,'2023-03-13 14:08:46','',''),(6766,'1','310','1',1,'Retail Sale Id 6582',2160.00,0.00,0.00,3.00,207.00,'2023-03-13 14:23:44','',''),(6767,'1','310','1',1,'Retail Sale Id 6584',2001.60,0.00,0.00,2.78,191.82,'2023-03-13 14:32:14','',''),(6768,'1','310','1',1,'Retail Sale Id 6585',1497.60,0.00,0.00,2.08,143.52,'2023-03-13 14:38:05','',''),(6769,'1','310','1',1,'Retail Sale Id 6586',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 14:43:33','',''),(6770,'1','310','1',1,'Retail Sale Id 6586',9000.00,0.00,0.00,12.50,862.50,'2023-03-13 14:43:33','',''),(6771,'1','310','1',1,'Retail Sale Id 6587',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 14:45:05','',''),(6772,'1','310','1',1,'Retail Sale Id 6590',9000.00,0.00,0.00,12.50,862.50,'2023-03-13 15:02:16','',''),(6773,'1','310','1',1,'Retail Sale Id 6591',2001.60,0.00,0.00,2.78,191.82,'2023-03-13 15:04:55','',''),(6774,'1','310','1',1,'Retail Sale Id 6592',1440.00,0.00,0.00,2.00,138.00,'2023-03-13 15:07:18','',''),(6775,'1','310','1',1,'Retail Sale Id 6593',2001.60,0.00,0.00,2.78,191.82,'2023-03-13 15:13:22','',''),(6776,'1','310','1',1,'Retail Sale Id 6593',6998.40,0.00,0.00,9.72,670.68,'2023-03-13 15:13:22','',''),(6777,'1','310','1',1,'Retail Sale Id 6594',2001.60,0.00,0.00,2.78,191.82,'2023-03-13 15:16:44','',''),(6778,'1','310','1',1,'Retail Sale Id 6595',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 15:22:15','',''),(6779,'1','310','1',1,'Retail Sale Id 6596',4003.20,0.00,0.00,5.56,383.64,'2023-03-13 15:39:52','',''),(6780,'1','310','1',1,'Retail Sale Id 6598',4996.80,0.00,0.00,6.94,478.86,'2023-03-13 15:41:35','',''),(6781,'1','310','1',1,'Retail Sale Id 6599',3002.40,0.00,0.00,4.17,287.73,'2023-03-13 15:45:29','',''),(6782,'1','310','1',1,'Retail Sale Id 6600',1497.60,0.00,0.00,2.08,143.52,'2023-03-13 15:47:32','',''),(6783,'1','310','1',1,'Retail Sale Id 6601',2160.00,0.00,0.00,3.00,207.00,'2023-03-13 15:51:29','',''),(6784,'1','310','1',1,'Retail Sale Id 6602',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 16:13:18','',''),(6785,'1','310','1',1,'Retail Sale Id 6603',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 16:14:36','',''),(6786,'1','310','1',1,'Retail Sale Id 6604',2001.60,0.00,0.00,2.78,191.82,'2023-03-13 16:15:28','',''),(6787,'1','310','1',1,'Retail Sale Id 6605',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 16:16:31','',''),(6788,'1','310','1',1,'Retail Sale Id 6606',3002.40,0.00,0.00,4.17,287.73,'2023-03-13 16:17:33','',''),(6789,'1','310','1',1,'Retail Sale Id 6607',2160.00,0.00,0.00,3.00,207.00,'2023-03-13 16:20:21','',''),(6790,'1','310','1',1,'Retail Sale Id 6608',1000.80,0.00,0.00,1.39,95.91,'2023-03-13 16:25:42','',''),(6791,'1','310','1',1,'Retail Sale Id 6609',698.40,0.00,0.00,0.97,66.93,'2023-03-13 16:40:31','',''),(6792,'1','310','1',1,'Retail Sale Id 6610',2160.00,0.00,0.00,3.00,207.00,'2023-03-13 16:55:02','',''),(6793,'1','310','1',1,'Retail Sale Id 6611',9000.00,0.00,0.00,12.50,862.50,'2023-03-13 17:10:26','',''),(6794,'1','310','1',1,'Retail Sale Id 6612',2160.00,0.00,0.00,3.00,207.00,'2023-03-13 17:12:01','',''),(6795,'1','310','1',1,'Retail Sale Id 6613',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 17:13:12','',''),(6796,'1','310','1',1,'Retail Sale Id 6614',3600.00,0.00,0.00,5.00,345.00,'2023-03-13 17:15:12','',''),(6797,'1','310','1',1,'Retail Sale Id 6614',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 17:15:12','',''),(6798,'1','310','1',1,'Retail Sale Id 6615',9000.00,0.00,0.00,12.50,862.50,'2023-03-13 17:21:10','',''),(6799,'1','310','1',1,'Retail Sale Id 6616',3600.00,0.00,0.00,5.00,345.00,'2023-03-13 17:30:05','',''),(6800,'1','310','1',1,'Retail Sale Id 6617',226800.00,0.00,0.00,324.00,15876.00,'2023-03-13 17:34:56','',''),(6801,'1','310','1',1,'Retail Sale Id 6618',2160.00,0.00,0.00,3.00,207.00,'2023-03-13 17:36:20','',''),(6802,'1','310','1',1,'Retail Sale Id 6619',2160.00,0.00,0.00,3.00,207.00,'2023-03-13 17:38:02','',''),(6803,'1','310','1',1,'Retail Sale Id 6620',2160.00,0.00,0.00,3.00,207.00,'2023-03-13 17:40:36','',''),(6804,'1','310','1',1,'Retail Sale Id 6621',4298.40,0.00,0.00,5.97,411.93,'2023-03-13 17:46:23','',''),(6805,'1','310','1',1,'Retail Sale Id 6622',1497.60,0.00,0.00,2.08,143.52,'2023-03-13 17:48:07','',''),(6806,'1','310','1',1,'Retail Sale Id 6623',900.00,0.00,0.00,1.25,86.25,'2023-03-13 17:50:09','',''),(6807,'1','310','1',1,'Retail Sale Id 6624',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 17:53:40','',''),(6808,'1','310','1',1,'Retail Sale Id 6625',3600.00,0.00,0.00,5.00,345.00,'2023-03-13 17:56:27','',''),(6809,'1','310','1',1,'Retail Sale Id 6627',2160.00,0.00,0.00,3.00,207.00,'2023-03-13 17:58:27','',''),(6810,'1','310','1',1,'Retail Sale Id 6628',6998.40,0.00,0.00,9.72,670.68,'2023-03-13 17:59:02','',''),(6811,'1','310','1',1,'Retail Sale Id 6629',3002.40,0.00,0.00,4.17,287.73,'2023-03-13 18:00:30','',''),(6812,'1','310','1',1,'Retail Sale Id 6630',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 18:09:37','',''),(6813,'1','310','1',1,'Retail Sale Id 6631',1000.80,0.00,0.00,1.39,95.91,'2023-03-13 18:11:25','',''),(6814,'1','310','1',1,'Retail Sale Id 6632',2001.60,0.00,0.00,2.78,191.82,'2023-03-13 18:21:27','',''),(6815,'1','310','1',1,'Retail Sale Id 6633',2160.00,0.00,0.00,3.00,207.00,'2023-03-13 18:22:47','',''),(6816,'1','310','1',1,'Retail Sale Id 6634',1396.80,0.00,0.00,1.94,133.86,'2023-03-13 18:23:41','',''),(6817,'1','310','1',1,'Retail Sale Id 6635',1000.80,0.00,0.00,1.39,95.91,'2023-03-13 18:24:27','',''),(6818,'1','310','1',1,'Retail Sale Id 6636',5760.00,0.00,0.00,8.00,552.00,'2023-03-13 18:25:16','',''),(6819,'1','310','1',1,'Retail Sale Id 6637',1000.80,0.00,0.00,1.39,95.91,'2023-03-13 18:31:58','',''),(6820,'1','310','1',1,'Retail Sale Id 6638',720.00,0.00,0.00,1.00,69.00,'2023-03-13 18:34:43','',''),(6821,'1','310','1',1,'Retail Sale Id 6639',4320.00,0.00,0.00,6.00,414.00,'2023-03-13 18:39:40','',''),(6822,'1','310','1',1,'Retail Sale Id 6640',3002.40,0.00,0.00,4.17,287.73,'2023-03-13 18:40:20','',''),(6823,'1','310','1',1,'Retail Sale Id 6641',5198.40,0.00,0.00,7.22,498.18,'2023-03-13 19:04:17','',''),(6824,'1','310','1',1,'Return of Retail Sale Id 6629',0.00,3002.40,4.17,0.00,-287.73,'2023-03-13 19:07:19','',''),(6825,'1','310','1',1,'Return of Retail Sale Id 6628',0.00,6998.40,9.72,0.00,-670.68,'2023-03-13 19:07:47','',''),(6826,'1','310','1',1,'Retail Sale Id 6642',914.40,0.00,0.00,1.27,87.63,'2023-03-13 19:08:25','',''),(6827,'1','310','1',1,'Return of Retail Sale Id 6537',0.00,8400.00,12.00,0.00,-588.00,'2023-03-13 19:09:28','',''),(6828,'1','310','1',1,'Retail Sale Id 6643',8379.00,0.00,0.00,11.97,586.53,'2023-03-13 19:13:21','',''),(6829,'1','310','1',1,'Retail Sale Id 6644',3902.40,0.00,0.00,5.42,373.98,'2023-03-13 19:14:32','',''),(6830,'1','310','1',1,'Retail Sale Id 6645',1000.80,0.00,0.00,1.39,95.91,'2023-03-14 07:15:07','',''),(6831,'1','310','1',1,'Retail Sale Id 6646',9000.00,0.00,0.00,12.50,862.50,'2023-03-14 07:22:00','',''),(6832,'1','310','1',1,'Retail Sale Id 6647',3600.00,0.00,0.00,5.00,345.00,'2023-03-14 07:36:06','',''),(6833,'1','310','1',1,'Retail Sale Id 6648',2001.60,0.00,0.00,2.78,191.82,'2023-03-14 07:40:21','',''),(6834,'1','310','1',1,'Retail Sale Id 6649',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 07:53:01','',''),(6835,'1','310','1',1,'Retail Sale Id 6650',9000.00,0.00,0.00,12.50,862.50,'2023-03-14 07:54:36','',''),(6836,'1','310','1',1,'Retail Sale Id 6651',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 07:56:29','',''),(6837,'1','310','1',1,'Retail Sale Id 6652',4996.80,0.00,0.00,6.94,478.86,'2023-03-14 08:01:14','',''),(6838,'1','310','1',1,'Retail Sale Id 6653',42000.00,0.00,0.00,60.00,2940.00,'2023-03-14 08:18:11','',''),(6839,'1','310','1',1,'Retail Sale Id 6654',3002.40,0.00,0.00,4.17,287.73,'2023-03-14 08:31:54','',''),(6840,'1','310','1',1,'Retail Sale Id 6655',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 09:05:58','',''),(6841,'1','310','1',1,'Retail Sale Id 6656',9000.00,0.00,0.00,12.50,862.50,'2023-03-14 09:12:44','',''),(6842,'1','310','1',1,'Retail Sale Id 6657',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 09:15:45','',''),(6843,'1','310','1',1,'Retail Sale Id 6658',2880.00,0.00,0.00,4.00,276.00,'2023-03-14 09:22:41','',''),(6844,'1','310','1',1,'Retail Sale Id 6659',9000.00,0.00,0.00,12.50,862.50,'2023-03-14 09:24:20','',''),(6845,'1','310','1',1,'Retail Sale Id 6660',1000.80,0.00,0.00,1.39,95.91,'2023-03-14 09:32:31','',''),(6846,'1','310','1',1,'Retail Sale Id 6661',1000.80,0.00,0.00,1.39,95.91,'2023-03-14 09:34:20','',''),(6847,'1','310','1',1,'Retail Sale Id 6662',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 09:39:49','',''),(6848,'1','310','1',1,'Retail Sale Id 6663',1000.80,0.00,0.00,1.39,95.91,'2023-03-14 09:45:14','',''),(6849,'1','310','1',1,'Retail Sale Id 6664',4003.20,0.00,0.00,5.56,383.64,'2023-03-14 09:47:12','',''),(6850,'1','310','1',1,'Retail Sale Id 6665',2160.00,0.00,0.00,3.00,207.00,'2023-03-14 09:48:20','',''),(6851,'1','310','1',1,'Retail Sale Id 6666',2001.60,0.00,0.00,2.78,191.82,'2023-03-14 09:49:38','',''),(6852,'1','310','1',1,'Retail Sale Id 6667',4996.80,0.00,0.00,6.94,478.86,'2023-03-14 09:55:34','',''),(6853,'1','310','1',1,'Retail Sale Id 6668',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 09:56:59','',''),(6854,'1','310','1',1,'Retail Sale Id 6669',70000.00,0.00,0.00,100.00,4900.00,'2023-03-14 10:03:08','',''),(6855,'1','310','1',1,'Retail Sale Id 6670',35000.00,0.00,0.00,50.00,2450.00,'2023-03-14 10:08:07','',''),(6856,'1','310','1',1,'Retail Sale Id 6671',35000.00,0.00,0.00,50.00,2450.00,'2023-03-14 10:15:39','',''),(6857,'1','310','1',1,'Retail Sale Id 6672',9000.00,0.00,0.00,12.50,862.50,'2023-03-14 10:20:32','',''),(6858,'1','310','1',1,'Retail Sale Id 6673',9000.00,0.00,0.00,12.50,862.50,'2023-03-14 10:33:59','',''),(6859,'1','310','1',1,'Retail Sale Id 6674',1000.80,0.00,0.00,1.39,95.91,'2023-03-14 10:36:00','',''),(6860,'1','310','1',1,'Retail Sale Id 6676',4003.20,0.00,0.00,5.56,383.64,'2023-03-14 10:45:50','',''),(6861,'1','310','1',1,'Retail Sale Id 6676',7200.00,0.00,0.00,10.00,690.00,'2023-03-14 10:45:50','',''),(6862,'1','310','1',1,'Retail Sale Id 6677',2152.80,0.00,0.00,2.99,206.31,'2023-03-14 10:52:06','',''),(6863,'1','310','1',1,'Retail Sale Id 6678',2203.20,0.00,0.00,3.06,211.14,'2023-03-14 10:55:07','',''),(6864,'1','310','1',1,'Retail Sale Id 6679',496.80,0.00,0.00,0.69,47.61,'2023-03-14 10:57:28','',''),(6865,'1','310','1',1,'Retail Sale Id 6680',3002.40,0.00,0.00,4.17,287.73,'2023-03-14 11:01:05','',''),(6866,'1','310','1',1,'Retail Sale Id 6681',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 11:13:46','',''),(6867,'1','310','1',1,'Retail Sale Id 6682',3600.00,0.00,0.00,5.00,345.00,'2023-03-14 11:19:49','',''),(6868,'1','310','1',1,'Retail Sale Id 6683',720.00,0.00,0.00,1.00,69.00,'2023-03-14 11:22:33','',''),(6869,'1','310','1',1,'Retail Sale Id 6684',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 11:23:58','',''),(6870,'1','310','1',1,'Retail Sale Id 6685',2001.60,0.00,0.00,2.78,191.82,'2023-03-14 11:25:47','',''),(6871,'1','310','1',1,'Retail Sale Id 6686',35000.00,0.00,0.00,50.00,2450.00,'2023-03-14 11:30:51','',''),(6872,'1','310','1',1,'Retail Sale Id 6687',1497.60,0.00,0.00,2.08,143.52,'2023-03-14 11:33:44','',''),(6873,'1','310','1',1,'Retail Sale Id 6688',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 11:34:41','',''),(6874,'1','310','1',1,'Retail Sale Id 6689',9000.00,0.00,0.00,12.50,862.50,'2023-03-14 11:35:55','',''),(6875,'1','310','1',1,'Retail Sale Id 6690',3002.40,0.00,0.00,4.17,287.73,'2023-03-14 11:36:57','',''),(6876,'1','310','1',1,'Retail Sale Id 6691',1497.60,0.00,0.00,2.08,143.52,'2023-03-14 11:38:05','',''),(6877,'1','310','1',1,'Retail Sale Id 6691',1497.60,0.00,0.00,2.08,143.52,'2023-03-14 11:38:05','',''),(6878,'1','310','1',1,'Retail Sale Id 6692',3600.00,0.00,0.00,5.00,345.00,'2023-03-14 11:41:53','',''),(6879,'1','310','1',1,'Retail Sale Id 6692',9000.00,0.00,0.00,12.50,862.50,'2023-03-14 11:41:53','',''),(6880,'1','310','1',1,'Retail Sale Id 6693',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 11:45:29','',''),(6881,'1','310','1',1,'Retail Sale Id 6694',2160.00,0.00,0.00,3.00,207.00,'2023-03-14 11:56:24','',''),(6882,'1','310','1',1,'Retail Sale Id 6695',105000.00,0.00,0.00,150.00,7350.00,'2023-03-14 11:58:17','',''),(6883,'1','310','1',1,'Retail Sale Id 6696',4550.00,0.00,0.00,6.50,318.50,'2023-03-14 11:59:38','',''),(6884,'1','310','1',1,'Retail Sale Id 6697',9000.00,0.00,0.00,12.50,862.50,'2023-03-14 12:11:51','',''),(6885,'1','310','1',1,'Retail Sale Id 6697',9000.00,0.00,0.00,12.50,862.50,'2023-03-14 12:11:51','',''),(6886,'1','310','1',1,'Retail Sale Id 6698',3600.00,0.00,0.00,5.00,345.00,'2023-03-14 12:14:21','',''),(6887,'1','310','1',1,'Retail Sale Id 6700',9000.00,0.00,0.00,12.50,862.50,'2023-03-14 12:15:38','',''),(6888,'1','310','1',1,'Retail Sale Id 6701',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 12:17:16','',''),(6889,'1','310','1',1,'Retail Sale Id 6703',9000.00,0.00,0.00,12.50,862.50,'2023-03-14 12:35:27','',''),(6890,'1','310','1',1,'Retail Sale Id 6704',9000.00,0.00,0.00,12.50,862.50,'2023-03-14 12:36:43','',''),(6891,'1','310','1',1,'Retail Sale Id 6705',35000.00,0.00,0.00,50.00,2450.00,'2023-03-14 12:43:27','',''),(6892,'1','310','1',1,'Retail Sale Id 6706',9000.00,0.00,0.00,12.50,862.50,'2023-03-14 12:48:22','',''),(6893,'1','310','1',1,'Retail Sale Id 6707',496.80,0.00,0.00,0.69,47.61,'2023-03-14 13:20:32','',''),(6894,'1','310','1',1,'Retail Sale Id 6709',2002.00,0.00,0.00,2.86,140.14,'2023-03-14 13:24:48','',''),(6895,'1','310','1',1,'Retail Sale Id 6710',727.20,0.00,0.00,1.01,69.69,'2023-03-14 13:26:22','',''),(6896,'1','310','1',1,'Retail Sale Id 6711',10000.80,0.00,0.00,13.89,958.41,'2023-03-14 13:28:37','',''),(6897,'1','310','1',1,'Retail Sale Id 6711',10000.80,0.00,0.00,13.89,958.41,'2023-03-14 13:28:37','',''),(6898,'1','310','1',1,'Retail Sale Id 6712',2001.60,0.00,0.00,2.78,191.82,'2023-03-14 13:29:44','',''),(6899,'1','310','1',1,'Retail Sale Id 6713',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 13:33:22','',''),(6900,'1','310','1',1,'Retail Sale Id 6714',1699.20,0.00,0.00,2.36,162.84,'2023-03-14 13:43:34','',''),(6901,'1','310','1',1,'Retail Sale Id 6714',2160.00,0.00,0.00,3.00,207.00,'2023-03-14 13:43:34','',''),(6902,'1','310','1',1,'Retail Sale Id 6715',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 13:47:09','',''),(6903,'1','310','1',1,'Retail Sale Id 6716',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 13:49:05','',''),(6904,'1','310','1',1,'Retail Sale Id 6716',9000.00,0.00,0.00,12.50,862.50,'2023-03-14 13:49:05','',''),(6905,'1','310','1',1,'Retail Sale Id 6717',70000.00,0.00,0.00,100.00,4900.00,'2023-03-14 13:52:17','',''),(6906,'1','310','1',1,'Retail Sale Id 6718',70000.00,0.00,0.00,100.00,4900.00,'2023-03-14 13:56:24','',''),(6907,'1','310','1',1,'Retail Sale Id 6719',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 13:57:15','',''),(6908,'1','310','1',1,'Retail Sale Id 6720',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 13:59:00','',''),(6909,'1','310','1',1,'Retail Sale Id 6721',2001.60,0.00,0.00,2.78,191.82,'2023-03-14 14:01:02','',''),(6910,'1','310','1',1,'Retail Sale Id 6722',1000.80,0.00,0.00,1.39,95.91,'2023-03-14 14:04:16','',''),(6911,'1','310','1',1,'Retail Sale Id 6723',8400.00,0.00,0.00,12.00,588.00,'2023-03-14 14:15:30','',''),(6912,'1','310','1',1,'Retail Sale Id 6724',105000.00,0.00,0.00,150.00,7350.00,'2023-03-14 14:16:47','',''),(6913,'1','310','1',1,'Return of Retail Sale Id 6718',0.00,70000.00,100.00,0.00,-4900.00,'2023-03-14 14:17:44','',''),(6914,'1','310','1',1,'Retail Sale Id 6725',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 14:54:17','',''),(6915,'1','310','1',1,'Retail Sale Id 6725',9000.00,0.00,0.00,12.50,862.50,'2023-03-14 14:54:17','',''),(6916,'1','310','1',1,'Retail Sale Id 6725',9000.00,0.00,0.00,12.50,862.50,'2023-03-14 14:54:17','',''),(6917,'1','310','1',1,'Retail Sale Id 6726',10000.80,0.00,0.00,13.89,958.41,'2023-03-14 15:00:07','',''),(6918,'1','310','1',1,'Retail Sale Id 6727',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 15:04:03','',''),(6919,'1','310','1',1,'Retail Sale Id 6728',2160.00,0.00,0.00,3.00,207.00,'2023-03-14 15:05:40','',''),(6920,'1','310','1',1,'Retail Sale Id 6728',2160.00,0.00,0.00,3.00,207.00,'2023-03-14 15:05:40','',''),(6921,'1','310','1',1,'Retail Sale Id 6729',2160.00,0.00,0.00,3.00,207.00,'2023-03-14 15:32:11','',''),(6922,'1','310','1',1,'Retail Sale Id 6730',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 15:45:45','',''),(6923,'1','310','1',1,'Retail Sale Id 6731',3002.40,0.00,0.00,4.17,287.73,'2023-03-14 15:47:07','',''),(6924,'1','310','1',1,'Retail Sale Id 6732',105000.00,0.00,0.00,150.00,7350.00,'2023-03-14 15:53:38','',''),(6925,'1','310','1',1,'Retail Sale Id 6733',1497.60,0.00,0.00,2.08,143.52,'2023-03-14 15:58:19','',''),(6926,'1','310','1',1,'Retail Sale Id 6734',2160.00,0.00,0.00,3.00,207.00,'2023-03-14 16:14:46','',''),(6927,'1','310','1',1,'Retail Sale Id 6735',1440.00,0.00,0.00,2.00,138.00,'2023-03-14 16:19:08','',''),(6928,'1','310','1',1,'Retail Sale Id 6736',2160.00,0.00,0.00,3.00,207.00,'2023-03-14 16:21:12','',''),(6929,'1','310','1',1,'Retail Sale Id 6737',9000.00,0.00,0.00,12.50,862.50,'2023-03-14 16:26:17','',''),(6930,'1','310','1',1,'Retail Sale Id 6737',9000.00,0.00,0.00,12.50,862.50,'2023-03-14 16:26:17','',''),(6931,'1','310','1',1,'Retail Sale Id 6738',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 16:30:05','',''),(6932,'1','310','1',1,'Retail Sale Id 6739',1396.80,0.00,0.00,1.94,133.86,'2023-03-14 16:32:19','',''),(6933,'1','310','1',1,'Retail Sale Id 6740',1000.80,0.00,0.00,1.39,95.91,'2023-03-14 16:39:53','',''),(6934,'1','310','1',1,'Retail Sale Id 6741',1440.00,0.00,0.00,2.00,138.00,'2023-03-14 16:45:28','',''),(6935,'1','310','1',1,'Retail Sale Id 6742',3600.00,0.00,0.00,5.00,345.00,'2023-03-14 16:54:06','',''),(6936,'1','310','1',1,'Retail Sale Id 6742',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 16:54:06','',''),(6937,'1','310','1',1,'Retail Sale Id 6743',1497.60,0.00,0.00,2.08,143.52,'2023-03-14 16:55:30','',''),(6938,'1','310','1',1,'Retail Sale Id 6744',799.20,0.00,0.00,1.11,76.59,'2023-03-14 17:03:59','',''),(6939,'1','310','1',1,'Retail Sale Id 6745',2160.00,0.00,0.00,3.00,207.00,'2023-03-14 17:06:48','',''),(6940,'1','310','1',1,'Retail Sale Id 6747',2160.00,0.00,0.00,3.00,207.00,'2023-03-14 17:28:08','',''),(6941,'1','310','1',1,'Retail Sale Id 6749',9000.00,0.00,0.00,12.50,862.50,'2023-03-14 17:29:44','',''),(6942,'1','310','1',1,'Retail Sale Id 6749',9000.00,0.00,0.00,12.50,862.50,'2023-03-14 17:29:44','',''),(6943,'1','310','1',1,'Retail Sale Id 6750',3002.40,0.00,0.00,4.17,287.73,'2023-03-14 17:30:51','',''),(6944,'1','310','1',1,'Retail Sale Id 6751',2498.40,0.00,0.00,3.47,239.43,'2023-03-14 17:33:44','',''),(6945,'1','310','1',1,'Retail Sale Id 6752',1800.00,0.00,0.00,2.50,172.50,'2023-03-14 17:50:38','',''),(6946,'1','310','1',1,'Retail Sale Id 6753',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 17:52:59','',''),(6947,'1','310','1',1,'Retail Sale Id 6754',2001.60,0.00,0.00,2.78,191.82,'2023-03-14 17:55:02','',''),(6948,'1','310','1',1,'Retail Sale Id 6755',1000.80,0.00,0.00,1.39,95.91,'2023-03-14 17:59:13','',''),(6949,'1','310','1',1,'Retail Sale Id 6756',3002.40,0.00,0.00,4.17,287.73,'2023-03-14 18:03:13','',''),(6950,'1','310','1',1,'Retail Sale Id 6756',4003.20,0.00,0.00,5.56,383.64,'2023-03-14 18:03:13','',''),(6951,'1','310','1',1,'Retail Sale Id 6757',3240.00,0.00,0.00,4.50,310.50,'2023-03-14 18:04:53','',''),(6952,'1','310','1',1,'Retail Sale Id 6758',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 18:06:07','',''),(6953,'1','310','1',1,'Retail Sale Id 6759',4996.80,0.00,0.00,6.94,478.86,'2023-03-14 18:10:07','',''),(6954,'1','310','1',1,'Retail Sale Id 6760',9000.00,0.00,0.00,12.50,862.50,'2023-03-14 18:11:00','',''),(6955,'1','310','1',1,'Retail Sale Id 6761',2160.00,0.00,0.00,3.00,207.00,'2023-03-14 18:19:49','',''),(6956,'1','310','1',1,'Retail Sale Id 6762',4003.20,0.00,0.00,5.56,383.64,'2023-03-14 18:22:59','',''),(6957,'1','310','1',1,'Retail Sale Id 6763',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 18:24:12','',''),(6958,'1','310','1',1,'Retail Sale Id 6764',1000.80,0.00,0.00,1.39,95.91,'2023-03-14 18:25:58','',''),(6959,'1','310','1',1,'Retail Sale Id 6766',2001.60,0.00,0.00,2.78,191.82,'2023-03-14 18:29:10','',''),(6960,'1','310','1',1,'Retail Sale Id 6767',2160.00,0.00,0.00,3.00,207.00,'2023-03-14 18:34:24','',''),(6961,'1','310','1',1,'Retail Sale Id 6768',1000.80,0.00,0.00,1.39,95.91,'2023-03-14 18:36:09','',''),(6962,'1','310','1',1,'Retail Sale Id 6769',3600.00,0.00,0.00,5.00,345.00,'2023-03-14 18:42:29','',''),(6963,'1','310','1',1,'Retail Sale Id 6770',2498.40,0.00,0.00,3.47,239.43,'2023-03-14 18:44:37','',''),(6964,'1','310','1',1,'Retail Sale Id 6770',3002.40,0.00,0.00,4.17,287.73,'2023-03-14 18:44:37','',''),(6965,'1','310','1',1,'Retail Sale Id 6771',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 18:46:01','',''),(6966,'1','310','1',1,'Retail Sale Id 6772',4320.00,0.00,0.00,6.00,414.00,'2023-03-14 18:47:44','',''),(6967,'1','310','1',1,'Retail Sale Id 6773',1440.00,0.00,0.00,2.00,138.00,'2023-03-14 18:48:17','',''),(6968,'1','310','1',1,'Retail Sale Id 6774',2160.00,0.00,0.00,3.00,207.00,'2023-03-14 18:50:39','',''),(6969,'1','310','1',1,'Retail Sale Id 6775',2001.60,0.00,0.00,2.78,191.82,'2023-03-14 18:51:35','',''),(6970,'1','310','1',1,'Retail Sale Id 6776',7200.00,0.00,0.00,10.00,690.00,'2023-03-14 18:52:14','',''),(6971,'1','310','1',1,'Return of Retail Sale Id 6709',0.00,2002.00,2.86,0.00,-140.14,'2023-03-14 19:22:41','',''),(6972,'1','310','1',1,'Return of Retail Sale Id 6723',0.00,8400.00,12.00,0.00,-588.00,'2023-03-14 19:27:44','',''),(6973,'1','310','1',1,'Retail Sale Id 6777',8946.00,0.00,0.00,12.78,626.22,'2023-03-14 19:29:30','',''),(6974,'1','310','1',1,'Return of Retail Sale Id 6776',0.00,7200.00,10.00,0.00,-690.00,'2023-03-14 19:32:48','',''),(6975,'1','310','1',1,'Return of Retail Sale Id 6760',0.00,9000.00,12.50,0.00,-862.50,'2023-03-14 19:32:49','',''),(6976,'1','310','1',1,'Return of Retail Sale Id 6771',0.00,4320.00,6.00,0.00,-414.00,'2023-03-14 19:33:44','',''),(6977,'1','310','1',1,'Return of Retail Sale Id 6768',0.00,1000.80,1.39,0.00,-95.91,'2023-03-14 19:34:05','',''),(6978,'1','310','1',1,'Return of Retail Sale Id 6749',0.00,9000.00,12.50,0.00,-862.50,'2023-03-14 19:35:09','',''),(6979,'1','310','1',1,'Return of Retail Sale Id 6749',0.00,9000.00,12.50,0.00,-862.50,'2023-03-14 19:35:09','',''),(6980,'1','310','1',1,'Retail Sale Id 6778',5702.40,0.00,0.00,7.92,546.48,'2023-03-14 19:35:25','',''),(6981,'1','310','1',1,'Retail Sale Id 6779',9381.60,0.00,0.00,13.03,899.07,'2023-03-14 19:36:09','',''),(6982,'1','310','1',1,'Retail Sale Id 6780',8618.40,0.00,0.00,11.97,825.93,'2023-03-14 19:38:43','',''),(6983,'1','310','1',1,'Retail Sale Id 6781',4996.80,0.00,0.00,6.94,478.86,'2023-03-15 07:10:17','',''),(6984,'1','310','1',1,'Retail Sale Id 6782',698.40,0.00,0.00,0.97,66.93,'2023-03-15 07:17:43','',''),(6985,'1','310','1',1,'Retail Sale Id 6783',2203.20,0.00,0.00,3.06,211.14,'2023-03-15 07:28:12','',''),(6986,'1','310','1',1,'Retail Sale Id 6784',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 07:55:32','',''),(6987,'1','310','1',1,'Retail Sale Id 6785',2001.60,0.00,0.00,2.78,191.82,'2023-03-15 08:01:03','',''),(6988,'1','310','1',1,'Retail Sale Id 6785',3002.40,0.00,0.00,4.17,287.73,'2023-03-15 08:01:03','',''),(6989,'1','310','1',1,'Retail Sale Id 6786',2001.60,0.00,0.00,2.78,191.82,'2023-03-15 08:26:09','',''),(6990,'1','310','1',1,'Retail Sale Id 6787',2160.00,0.00,0.00,3.00,207.00,'2023-03-15 08:27:20','',''),(6991,'1','310','1',1,'Retail Sale Id 6788',105000.00,0.00,0.00,150.00,7350.00,'2023-03-15 08:29:21','',''),(6992,'1','310','1',1,'Retail Sale Id 6789',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 08:38:24','',''),(6993,'1','310','1',1,'Retail Sale Id 6790',2001.60,0.00,0.00,2.78,191.82,'2023-03-15 08:42:58','',''),(6994,'1','310','1',1,'Retail Sale Id 6791',1800.00,0.00,0.00,2.50,172.50,'2023-03-15 08:44:56','',''),(6995,'1','310','1',1,'Retail Sale Id 6792',9000.00,0.00,0.00,12.50,862.50,'2023-03-15 08:47:44','',''),(6996,'1','310','1',1,'Retail Sale Id 6793',2001.60,0.00,0.00,2.78,191.82,'2023-03-15 08:50:54','',''),(6997,'1','310','1',1,'Retail Sale Id 6794',4996.80,0.00,0.00,6.94,478.86,'2023-03-15 09:02:32','',''),(6998,'1','310','1',1,'Retail Sale Id 6795',70000.00,0.00,0.00,100.00,4900.00,'2023-03-15 09:03:11','',''),(6999,'1','310','1',1,'Retail Sale Id 6797',9000.00,0.00,0.00,12.50,862.50,'2023-03-15 09:09:41','',''),(7000,'1','310','1',1,'Retail Sale Id 6798',2160.00,0.00,0.00,3.00,207.00,'2023-03-15 09:10:45','',''),(7001,'1','310','1',1,'Retail Sale Id 6799',1497.60,0.00,0.00,2.08,143.52,'2023-03-15 09:11:24','',''),(7002,'1','310','1',1,'Retail Sale Id 6800',2160.00,0.00,0.00,3.00,207.00,'2023-03-15 09:15:03','',''),(7003,'1','310','1',1,'Retail Sale Id 6801',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 09:15:36','',''),(7004,'1','310','1',1,'Retail Sale Id 6802',3600.00,0.00,0.00,5.00,345.00,'2023-03-15 09:17:11','',''),(7005,'1','310','1',1,'Retail Sale Id 6803',42000.00,0.00,0.00,60.00,2940.00,'2023-03-15 09:24:20','',''),(7006,'1','310','1',1,'Retail Sale Id 6804',3002.40,0.00,0.00,4.17,287.73,'2023-03-15 09:26:41','',''),(7007,'1','310','1',1,'Retail Sale Id 6805',3499.20,0.00,0.00,4.86,335.34,'2023-03-15 09:28:43','',''),(7008,'1','310','1',1,'Retail Sale Id 6806',70000.00,0.00,0.00,100.00,4900.00,'2023-03-15 09:30:32','',''),(7009,'1','310','1',1,'Retail Sale Id 6808',3600.00,0.00,0.00,5.00,345.00,'2023-03-15 09:38:56','',''),(7010,'1','310','1',1,'Retail Sale Id 6810',3600.00,0.00,0.00,5.00,345.00,'2023-03-15 09:41:38','',''),(7011,'1','310','1',1,'Retail Sale Id 6811',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 09:43:13','',''),(7012,'1','310','1',1,'Retail Sale Id 6812',4996.80,0.00,0.00,6.94,478.86,'2023-03-15 09:45:39','',''),(7013,'1','310','1',1,'Retail Sale Id 6813',4003.20,0.00,0.00,5.56,383.64,'2023-03-15 09:47:13','',''),(7014,'1','310','1',1,'Retail Sale Id 6814',77000.00,0.00,0.00,110.00,5390.00,'2023-03-15 09:48:38','',''),(7015,'1','310','1',1,'Retail Sale Id 6815',2160.00,0.00,0.00,3.00,207.00,'2023-03-15 09:59:05','',''),(7016,'1','310','1',1,'Retail Sale Id 6816',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 10:05:41','',''),(7017,'1','310','1',1,'Retail Sale Id 6817',9000.00,0.00,0.00,12.50,862.50,'2023-03-15 10:16:57','',''),(7018,'1','310','1',1,'Retail Sale Id 6818',3002.40,0.00,0.00,4.17,287.73,'2023-03-15 10:20:24','',''),(7019,'1','310','1',1,'Retail Sale Id 6819',9000.00,0.00,0.00,12.50,862.50,'2023-03-15 10:22:04','',''),(7020,'1','310','1',1,'Retail Sale Id 6820',1440.00,0.00,0.00,2.00,138.00,'2023-03-15 10:26:09','',''),(7021,'1','310','1',1,'Retail Sale Id 6821',70000.00,0.00,0.00,100.00,4900.00,'2023-03-15 10:31:24','',''),(7022,'1','310','1',1,'Retail Sale Id 6822',2160.00,0.00,0.00,3.00,207.00,'2023-03-15 10:34:26','',''),(7023,'1','310','1',1,'Retail Sale Id 6822',3492.00,0.00,0.00,4.85,334.65,'2023-03-15 10:34:26','',''),(7024,'1','310','1',1,'Retail Sale Id 6823',9000.00,0.00,0.00,12.50,862.50,'2023-03-15 10:34:59','',''),(7025,'1','310','1',1,'Retail Sale Id 6824',3600.00,0.00,0.00,5.00,345.00,'2023-03-15 10:38:27','',''),(7026,'1','310','1',1,'Retail Sale Id 6825',9000.00,0.00,0.00,12.50,862.50,'2023-03-15 10:44:14','',''),(7027,'1','310','1',1,'Retail Sale Id 6826',2160.00,0.00,0.00,3.00,207.00,'2023-03-15 10:44:43','',''),(7028,'1','310','1',1,'Retail Sale Id 6827',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 10:50:05','',''),(7029,'1','310','1',1,'Retail Sale Id 6828',5600.00,0.00,0.00,8.00,392.00,'2023-03-15 10:53:34','',''),(7030,'1','310','1',1,'Retail Sale Id 6829',35000.00,0.00,0.00,50.00,2450.00,'2023-03-15 11:18:53','',''),(7031,'1','310','1',1,'Retail Sale Id 6830',210000.00,0.00,0.00,300.00,14700.00,'2023-03-15 11:23:19','',''),(7032,'1','310','1',1,'Retail Sale Id 6831',1440.00,0.00,0.00,2.00,138.00,'2023-03-15 11:25:11','',''),(7033,'1','310','1',1,'Retail Sale Id 6832',2160.00,0.00,0.00,3.00,207.00,'2023-03-15 11:25:54','',''),(7034,'1','310','1',1,'Retail Sale Id 6833',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 11:36:40','',''),(7035,'1','310','1',1,'Retail Sale Id 6834',3600.00,0.00,0.00,5.00,345.00,'2023-03-15 11:39:18','',''),(7036,'1','310','1',1,'Retail Sale Id 6834',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 11:39:18','',''),(7037,'1','310','1',1,'Retail Sale Id 6835',4003.20,0.00,0.00,5.56,383.64,'2023-03-15 11:40:06','',''),(7038,'1','310','1',1,'Retail Sale Id 6836',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 11:41:10','',''),(7039,'1','310','1',1,'Retail Sale Id 6837',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 11:42:10','',''),(7040,'1','310','1',1,'Retail Sale Id 6838',2160.00,0.00,0.00,3.00,207.00,'2023-03-15 11:50:42','',''),(7041,'1','310','1',1,'Retail Sale Id 6838',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 11:50:42','',''),(7042,'1','310','1',1,'Retail Sale Id 6839',3600.00,0.00,0.00,5.00,345.00,'2023-03-15 11:59:13','',''),(7043,'1','310','1',1,'Retail Sale Id 6840',2160.00,0.00,0.00,3.00,207.00,'2023-03-15 11:59:52','',''),(7044,'1','310','1',1,'Retail Sale Id 6841',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 12:05:11','',''),(7045,'1','310','1',1,'Retail Sale Id 6842',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 12:11:07','',''),(7046,'1','310','1',1,'Retail Sale Id 6843',4996.80,0.00,0.00,6.94,478.86,'2023-03-15 12:12:33','',''),(7047,'1','310','1',1,'Retail Sale Id 6844',2160.00,0.00,0.00,3.00,207.00,'2023-03-15 12:15:05','',''),(7048,'1','310','1',1,'Retail Sale Id 6845',2001.60,0.00,0.00,2.78,191.82,'2023-03-15 12:46:14','',''),(7049,'1','310','1',1,'Retail Sale Id 6846',4680.00,0.00,0.00,6.50,448.50,'2023-03-15 12:51:42','',''),(7050,'1','310','1',1,'Retail Sale Id 6846',9000.00,0.00,0.00,12.50,862.50,'2023-03-15 12:51:42','',''),(7051,'1','310','1',1,'Retail Sale Id 6847',381.60,0.00,0.00,0.53,36.57,'2023-03-15 12:56:50','',''),(7052,'1','310','1',1,'Retail Sale Id 6848',35000.00,0.00,0.00,50.00,2450.00,'2023-03-15 12:57:46','',''),(7053,'1','310','1',1,'Retail Sale Id 6849',1497.60,0.00,0.00,2.08,143.52,'2023-03-15 12:58:20','',''),(7054,'1','310','1',1,'Retail Sale Id 6850',2498.40,0.00,0.00,3.47,239.43,'2023-03-15 13:02:21','',''),(7055,'1','310','1',1,'Retail Sale Id 6852',9000.00,0.00,0.00,12.50,862.50,'2023-03-15 13:15:29','',''),(7056,'1','310','1',1,'Retail Sale Id 6853',1598.40,0.00,0.00,2.22,153.18,'2023-03-15 13:18:28','',''),(7057,'1','310','1',1,'Retail Sale Id 6854',2160.00,0.00,0.00,3.00,207.00,'2023-03-15 13:19:14','',''),(7058,'1','310','1',1,'Retail Sale Id 6855',799.20,0.00,0.00,1.11,76.59,'2023-03-15 13:20:08','',''),(7059,'1','310','1',1,'Retail Sale Id 6856',2001.60,0.00,0.00,2.78,191.82,'2023-03-15 13:33:16','',''),(7060,'1','310','1',1,'Retail Sale Id 6857',9000.00,0.00,0.00,12.50,862.50,'2023-03-15 13:37:37','',''),(7061,'1','310','1',1,'Retail Sale Id 6858',3002.40,0.00,0.00,4.17,287.73,'2023-03-15 13:48:21','',''),(7062,'1','310','1',1,'Retail Sale Id 6859',1000.80,0.00,0.00,1.39,95.91,'2023-03-15 13:56:54','',''),(7063,'1','310','1',1,'Retail Sale Id 6860',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 14:06:34','',''),(7064,'1','310','1',1,'Retail Sale Id 6862',7000.00,0.00,0.00,10.00,490.00,'2023-03-15 14:25:28','',''),(7065,'1','310','1',1,'Retail Sale Id 6863',2001.60,0.00,0.00,2.78,191.82,'2023-03-15 14:30:42','',''),(7066,'1','310','1',1,'Retail Sale Id 6864',2498.40,0.00,0.00,3.47,239.43,'2023-03-15 14:37:34','',''),(7067,'1','310','1',1,'Retail Sale Id 6865',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 14:39:26','',''),(7068,'1','310','1',1,'Retail Sale Id 6866',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 14:42:10','',''),(7069,'1','310','1',1,'Retail Sale Id 6867',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 14:46:10','',''),(7070,'1','310','1',1,'Retail Sale Id 6868',1000.80,0.00,0.00,1.39,95.91,'2023-03-15 14:47:45','',''),(7071,'1','310','1',1,'Retail Sale Id 6869',2160.00,0.00,0.00,3.00,207.00,'2023-03-15 15:04:21','',''),(7072,'1','310','1',1,'Retail Sale Id 6870',9000.00,0.00,0.00,12.50,862.50,'2023-03-15 15:23:17','',''),(7073,'1','310','1',1,'Retail Sale Id 6871',3600.00,0.00,0.00,5.00,345.00,'2023-03-15 15:29:15','',''),(7074,'1','310','1',1,'Retail Sale Id 6872',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 15:31:34','',''),(7075,'1','310','1',1,'Retail Sale Id 6873',5997.60,0.00,0.00,8.33,574.77,'2023-03-15 15:34:01','',''),(7076,'1','310','1',1,'Retail Sale Id 6874',496.80,0.00,0.00,0.69,47.61,'2023-03-15 15:34:49','',''),(7077,'1','310','1',1,'Retail Sale Id 6875',12600.00,0.00,0.00,18.00,882.00,'2023-03-15 15:43:20','',''),(7078,'1','310','1',1,'Retail Sale Id 6876',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 15:45:49','',''),(7079,'1','310','1',1,'Retail Sale Id 6876',7200.00,0.00,0.00,10.00,690.00,'2023-03-15 15:45:49','',''),(7080,'1','310','1',1,'Retail Sale Id 6877',2203.20,0.00,0.00,3.06,211.14,'2023-03-15 15:51:56','',''),(7081,'1','310','1',1,'Retail Sale Id 6879',4200.00,0.00,0.00,6.00,294.00,'2023-03-15 15:53:30','',''),(7082,'1','310','1',1,'Retail Sale Id 6880',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 15:54:24','',''),(7083,'1','310','1',1,'Retail Sale Id 6883',4200.00,0.00,0.00,6.00,294.00,'2023-03-15 16:15:35','',''),(7084,'1','310','1',1,'Retail Sale Id 6884',105000.00,0.00,0.00,150.00,7350.00,'2023-03-15 16:22:20','',''),(7085,'1','310','1',1,'Retail Sale Id 6885',2160.00,0.00,0.00,3.00,207.00,'2023-03-15 16:26:00','',''),(7086,'1','310','1',1,'Retail Sale Id 6886',1497.60,0.00,0.00,2.08,143.52,'2023-03-15 16:32:11','',''),(7087,'1','310','1',1,'Retail Sale Id 6887',5997.60,0.00,0.00,8.33,574.77,'2023-03-15 16:37:35','',''),(7088,'1','310','1',1,'Retail Sale Id 6888',35000.00,0.00,0.00,50.00,2450.00,'2023-03-15 16:41:38','',''),(7089,'1','310','1',1,'Retail Sale Id 6889',3499.20,0.00,0.00,4.86,335.34,'2023-03-15 16:44:18','',''),(7090,'1','310','1',1,'Retail Sale Id 6890',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 16:45:13','',''),(7091,'1','310','1',1,'Retail Sale Id 6890',9000.00,0.00,0.00,12.50,862.50,'2023-03-15 16:45:13','',''),(7092,'1','310','1',1,'Retail Sale Id 6891',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 16:46:16','',''),(7093,'1','310','1',1,'Retail Sale Id 6892',2160.00,0.00,0.00,3.00,207.00,'2023-03-15 16:57:15','',''),(7094,'1','310','1',1,'Retail Sale Id 6893',5997.60,0.00,0.00,8.33,574.77,'2023-03-15 16:58:06','',''),(7095,'1','310','1',1,'Retail Sale Id 6895',2160.00,0.00,0.00,3.00,207.00,'2023-03-15 17:09:18','',''),(7096,'1','310','1',1,'Retail Sale Id 6895',2160.00,0.00,0.00,3.00,207.00,'2023-03-15 17:09:18','',''),(7097,'1','310','1',1,'Retail Sale Id 6896',2001.60,0.00,0.00,2.78,191.82,'2023-03-15 17:10:06','',''),(7098,'1','310','1',1,'Retail Sale Id 6897',1497.60,0.00,0.00,2.08,143.52,'2023-03-15 17:11:21','',''),(7099,'1','310','1',1,'Retail Sale Id 6898',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 17:12:30','',''),(7100,'1','310','1',1,'Retail Sale Id 6899',3600.00,0.00,0.00,5.00,345.00,'2023-03-15 17:13:10','',''),(7101,'1','310','1',1,'Retail Sale Id 6900',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 17:13:56','',''),(7102,'1','310','1',1,'Retail Sale Id 6901',3600.00,0.00,0.00,5.00,345.00,'2023-03-15 17:15:09','',''),(7103,'1','310','1',1,'Retail Sale Id 6901',9000.00,0.00,0.00,12.50,862.50,'2023-03-15 17:15:09','',''),(7104,'1','310','1',1,'Retail Sale Id 6901',9000.00,0.00,0.00,12.50,862.50,'2023-03-15 17:15:09','',''),(7105,'1','310','1',1,'Retail Sale Id 6902',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 17:16:11','',''),(7106,'1','310','1',1,'Retail Sale Id 6903',1497.60,0.00,0.00,2.08,143.52,'2023-03-15 17:17:25','',''),(7107,'1','310','1',1,'Retail Sale Id 6904',2160.00,0.00,0.00,3.00,207.00,'2023-03-15 17:20:25','',''),(7108,'1','310','1',1,'Retail Sale Id 6907',4996.80,0.00,0.00,6.94,478.86,'2023-03-15 17:24:06','',''),(7109,'1','310','1',1,'Retail Sale Id 6908',1440.00,0.00,0.00,2.00,138.00,'2023-03-15 17:24:59','',''),(7110,'1','310','1',1,'Retail Sale Id 6909',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 17:25:42','',''),(7111,'1','310','1',1,'Retail Sale Id 6910',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 17:28:31','',''),(7112,'1','310','1',1,'Retail Sale Id 6911',16100.00,0.00,0.00,23.00,1127.00,'2023-03-15 17:33:01','',''),(7113,'1','310','1',1,'Retail Sale Id 6912',2001.60,0.00,0.00,2.78,191.82,'2023-03-15 17:40:01','',''),(7114,'1','310','1',1,'Retail Sale Id 6913',1440.00,0.00,0.00,2.00,138.00,'2023-03-15 17:41:12','',''),(7115,'1','310','1',1,'Retail Sale Id 6915',3600.00,0.00,0.00,5.00,345.00,'2023-03-15 17:49:58','',''),(7116,'1','310','1',1,'Retail Sale Id 6915',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 17:49:58','',''),(7117,'1','310','1',1,'Retail Sale Id 6916',3600.00,0.00,0.00,5.00,345.00,'2023-03-15 17:50:51','',''),(7118,'1','310','1',1,'Retail Sale Id 6916',9000.00,0.00,0.00,12.50,862.50,'2023-03-15 17:50:51','',''),(7119,'1','310','1',1,'Retail Sale Id 6917',9000.00,0.00,0.00,12.50,862.50,'2023-03-15 17:51:31','',''),(7120,'1','310','1',1,'Retail Sale Id 6918',2880.00,0.00,0.00,4.00,276.00,'2023-03-15 17:55:31','',''),(7121,'1','310','1',1,'Retail Sale Id 6918',9000.00,0.00,0.00,12.50,862.50,'2023-03-15 17:55:31','',''),(7122,'1','310','1',1,'Retail Sale Id 6919',7502.40,0.00,0.00,10.42,718.98,'2023-03-15 17:56:36','',''),(7123,'1','310','1',1,'Retail Sale Id 6920',2160.00,0.00,0.00,3.00,207.00,'2023-03-15 17:59:41','',''),(7124,'1','310','1',1,'Retail Sale Id 6921',3600.00,0.00,0.00,5.00,345.00,'2023-03-15 18:00:54','',''),(7125,'1','310','1',1,'Retail Sale Id 6922',9000.00,0.00,0.00,12.50,862.50,'2023-03-15 18:01:59','',''),(7126,'1','310','1',1,'Retail Sale Id 6923',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 18:04:17','',''),(7127,'1','310','1',1,'Retail Sale Id 6923',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 18:04:17','',''),(7128,'1','310','1',1,'Retail Sale Id 6924',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 18:04:54','',''),(7129,'1','310','1',1,'Retail Sale Id 6925',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 18:07:31','',''),(7130,'1','310','1',1,'Retail Sale Id 6926',6998.40,0.00,0.00,9.72,670.68,'2023-03-15 18:11:40','',''),(7131,'1','310','1',1,'Retail Sale Id 6928',1440.00,0.00,0.00,2.00,138.00,'2023-03-15 18:18:13','',''),(7132,'1','310','1',1,'Retail Sale Id 6928',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 18:18:13','',''),(7133,'1','310','1',1,'Retail Sale Id 6930',1699.20,0.00,0.00,2.36,162.84,'2023-03-15 18:19:49','',''),(7134,'1','310','1',1,'Retail Sale Id 6931',4320.00,0.00,0.00,6.00,414.00,'2023-03-15 18:20:23','',''),(7135,'1','310','1',1,'Retail Sale Id 6932',2001.60,0.00,0.00,2.78,191.82,'2023-03-15 18:24:43','',''),(7136,'1','310','1',1,'Retail Sale Id 6933',2160.00,0.00,0.00,3.00,207.00,'2023-03-15 18:29:50','',''),(7137,'1','310','1',1,'Retail Sale Id 6934',1440.00,0.00,0.00,2.00,138.00,'2023-03-15 18:32:49','',''),(7138,'1','310','1',1,'Retail Sale Id 6934',7920.00,0.00,0.00,11.00,759.00,'2023-03-15 18:32:49','',''),(7139,'1','310','1',1,'Retail Sale Id 6935',2880.00,0.00,0.00,4.00,276.00,'2023-03-15 18:39:54','',''),(7140,'1','310','1',1,'Retail Sale Id 6936',1000.80,0.00,0.00,1.39,95.91,'2023-03-15 18:45:08','',''),(7141,'1','310','1',1,'Retail Sale Id 6937',2160.00,0.00,0.00,3.00,207.00,'2023-03-15 18:46:49','',''),(7142,'1','310','1',1,'Retail Sale Id 6937',9000.00,0.00,0.00,12.50,862.50,'2023-03-15 18:46:49','',''),(7143,'1','310','1',1,'Retail Sale Id 6938',1497.60,0.00,0.00,2.08,143.52,'2023-03-15 18:48:35','',''),(7144,'1','310','1',1,'Retail Sale Id 6939',2001.60,0.00,0.00,2.78,191.82,'2023-03-15 18:49:19','',''),(7145,'1','310','1',1,'Retail Sale Id 6941',5831.00,0.00,0.00,8.33,408.17,'2023-03-15 19:22:12','',''),(7146,'1','310','1',1,'Return of Retail Sale Id 6932',0.00,2001.60,2.78,0.00,-191.82,'2023-03-15 19:26:26','',''),(7147,'1','310','1',1,'Return of Retail Sale Id 6937',0.00,2160.00,3.00,0.00,-207.00,'2023-03-15 19:27:16','',''),(7148,'1','310','1',1,'Return of Retail Sale Id 6937',0.00,9000.00,12.50,0.00,-862.50,'2023-03-15 19:27:16','',''),(7149,'1','310','1',1,'Retail Sale Id 6942',1072.80,0.00,0.00,1.49,102.81,'2023-03-15 19:29:20','',''),(7150,'1','310','1',1,'Retail Sale Id 6943',7.20,0.00,0.00,0.01,0.69,'2023-03-15 19:35:18','',''),(7151,'1','310','1',1,'Return of Retail Sale Id 6942',0.00,1072.80,1.49,0.00,-102.81,'2023-03-15 19:41:52','',''),(7152,'1','310','1',1,'Retail Sale Id 6944',1072.80,0.00,0.00,1.49,102.81,'2023-03-15 19:42:30','',''),(7153,'1','310','1',1,'Retail Sale Id 6945',42000.00,0.00,0.00,60.00,2940.00,'2023-03-16 07:04:47','',''),(7154,'1','310','1',1,'Retail Sale Id 6946',2001.60,0.00,0.00,2.78,191.82,'2023-03-16 07:15:29','',''),(7155,'1','310','1',1,'Retail Sale Id 6947',4320.00,0.00,0.00,6.00,414.00,'2023-03-16 07:34:28','',''),(7156,'1','310','1',1,'Retail Sale Id 6948',3997.00,0.00,0.00,5.71,279.79,'2023-03-16 07:44:02','',''),(7157,'1','310','1',1,'Retail Sale Id 6949',4320.00,0.00,0.00,6.00,414.00,'2023-03-16 07:45:59','',''),(7158,'1','310','1',1,'Retail Sale Id 6950',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 07:48:28','',''),(7159,'1','310','1',1,'Retail Sale Id 6952',4320.00,0.00,0.00,6.00,414.00,'2023-03-16 07:54:44','',''),(7160,'1','310','1',1,'Retail Sale Id 6952',4320.00,0.00,0.00,6.00,414.00,'2023-03-16 07:54:44','',''),(7161,'1','310','1',1,'Retail Sale Id 6953',2160.00,0.00,0.00,3.00,207.00,'2023-03-16 07:56:20','',''),(7162,'1','310','1',1,'Retail Sale Id 6955',1497.60,0.00,0.00,2.08,143.52,'2023-03-16 08:00:51','',''),(7163,'1','310','1',1,'Retail Sale Id 6956',2001.60,0.00,0.00,2.78,191.82,'2023-03-16 08:30:34','',''),(7164,'1','310','1',1,'Retail Sale Id 6957',4500.00,0.00,0.00,6.25,431.25,'2023-03-16 08:32:05','',''),(7165,'1','310','1',1,'Retail Sale Id 6958',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 08:33:27','',''),(7166,'1','310','1',1,'Retail Sale Id 6959',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 08:40:03','',''),(7167,'1','310','1',1,'Retail Sale Id 6960',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 08:43:01','',''),(7168,'1','310','1',1,'Retail Sale Id 6960',18000.00,0.00,0.00,25.00,1725.00,'2023-03-16 08:43:01','',''),(7169,'1','310','1',1,'Retail Sale Id 6961',2203.20,0.00,0.00,3.06,211.14,'2023-03-16 09:08:44','',''),(7170,'1','310','1',1,'Retail Sale Id 6962',2001.60,0.00,0.00,2.78,191.82,'2023-03-16 09:25:23','',''),(7171,'1','310','1',1,'Retail Sale Id 6963',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 09:27:29','',''),(7172,'1','310','1',1,'Retail Sale Id 6965',35000.00,0.00,0.00,50.00,2450.00,'2023-03-16 09:34:03','',''),(7173,'1','310','1',1,'Retail Sale Id 6966',1497.60,0.00,0.00,2.08,143.52,'2023-03-16 09:47:14','',''),(7174,'1','310','1',1,'Retail Sale Id 6967',2160.00,0.00,0.00,3.00,207.00,'2023-03-16 10:02:11','',''),(7175,'1','310','1',1,'Retail Sale Id 6968',273000.00,0.00,0.00,390.00,19110.00,'2023-03-16 10:04:12','',''),(7176,'1','310','1',1,'Retail Sale Id 6969',1303.20,0.00,0.00,1.81,124.89,'2023-03-16 10:07:02','',''),(7177,'1','310','1',1,'Retail Sale Id 6970',1497.60,0.00,0.00,2.08,143.52,'2023-03-16 10:09:54','',''),(7178,'1','310','1',1,'Retail Sale Id 6971',1497.60,0.00,0.00,2.08,143.52,'2023-03-16 10:12:13','',''),(7179,'1','310','1',1,'Retail Sale Id 6972',2001.60,0.00,0.00,2.78,191.82,'2023-03-16 10:31:53','',''),(7180,'1','310','1',1,'Retail Sale Id 6973',4003.20,0.00,0.00,5.56,383.64,'2023-03-16 10:39:53','',''),(7181,'1','310','1',1,'Retail Sale Id 6974',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 10:40:44','',''),(7182,'1','310','1',1,'Retail Sale Id 6975',35000.00,0.00,0.00,50.00,2450.00,'2023-03-16 10:41:38','',''),(7183,'1','310','1',1,'Retail Sale Id 6976',3600.00,0.00,0.00,5.00,345.00,'2023-03-16 10:58:05','',''),(7184,'1','310','1',1,'Retail Sale Id 6978',4320.00,0.00,0.00,6.00,414.00,'2023-03-16 10:59:14','',''),(7185,'1','310','1',1,'Retail Sale Id 6979',2001.60,0.00,0.00,2.78,191.82,'2023-03-16 11:12:49','',''),(7186,'1','310','1',1,'Retail Sale Id 6980',2498.40,0.00,0.00,3.47,239.43,'2023-03-16 11:15:27','',''),(7187,'1','310','1',1,'Retail Sale Id 6981',3002.40,0.00,0.00,4.17,287.73,'2023-03-16 11:16:08','',''),(7188,'1','310','1',1,'Retail Sale Id 6982',105000.00,0.00,0.00,150.00,7350.00,'2023-03-16 11:18:12','',''),(7189,'1','310','1',1,'Retail Sale Id 6983',720.00,0.00,0.00,1.00,69.00,'2023-03-16 11:18:52','',''),(7190,'1','310','1',1,'Retail Sale Id 6984',35000.00,0.00,0.00,50.00,2450.00,'2023-03-16 11:24:09','',''),(7191,'1','310','1',1,'Retail Sale Id 6985',1497.60,0.00,0.00,2.08,143.52,'2023-03-16 11:25:09','',''),(7192,'1','310','1',1,'Retail Sale Id 6986',2001.60,0.00,0.00,2.78,191.82,'2023-03-16 11:26:45','',''),(7193,'1','310','1',1,'Retail Sale Id 6987',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 11:31:18','',''),(7194,'1','310','1',1,'Retail Sale Id 6988',4320.00,0.00,0.00,6.00,414.00,'2023-03-16 11:32:03','',''),(7195,'1','310','1',1,'Retail Sale Id 6989',35000.00,0.00,0.00,50.00,2450.00,'2023-03-16 11:38:47','',''),(7196,'1','310','1',1,'Retail Sale Id 6990',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 11:41:36','',''),(7197,'1','310','1',1,'Retail Sale Id 6991',4348.80,0.00,0.00,6.04,416.76,'2023-03-16 11:48:46','',''),(7198,'1','310','1',1,'Retail Sale Id 6992',2001.60,0.00,0.00,2.78,191.82,'2023-03-16 11:49:43','',''),(7199,'1','310','1',1,'Retail Sale Id 6993',1396.80,0.00,0.00,1.94,133.86,'2023-03-16 11:56:07','',''),(7200,'1','310','1',1,'Retail Sale Id 6993',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 11:56:07','',''),(7201,'1','310','1',1,'Retail Sale Id 6994',2160.00,0.00,0.00,3.00,207.00,'2023-03-16 11:59:50','',''),(7202,'1','310','1',1,'Retail Sale Id 6995',993.60,0.00,0.00,1.38,95.22,'2023-03-16 12:00:44','',''),(7203,'1','310','1',1,'Retail Sale Id 6996',799.20,0.00,0.00,1.11,76.59,'2023-03-16 12:02:59','',''),(7204,'1','310','1',1,'Retail Sale Id 6997',2498.40,0.00,0.00,3.47,239.43,'2023-03-16 12:06:42','',''),(7205,'1','310','1',1,'Retail Sale Id 6998',1497.60,0.00,0.00,2.08,143.52,'2023-03-16 12:07:58','',''),(7206,'1','310','1',1,'Retail Sale Id 6999',2880.00,0.00,0.00,4.00,276.00,'2023-03-16 12:09:01','',''),(7207,'1','310','1',1,'Retail Sale Id 7000',4320.00,0.00,0.00,6.00,414.00,'2023-03-16 12:23:53','',''),(7208,'1','310','1',1,'Retail Sale Id 7001',3500.00,0.00,0.00,5.00,245.00,'2023-03-16 12:33:48','',''),(7209,'1','310','1',1,'Retail Sale Id 7002',1000.80,0.00,0.00,1.39,95.91,'2023-03-16 12:37:42','',''),(7210,'1','310','1',1,'Retail Sale Id 7003',2160.00,0.00,0.00,3.00,207.00,'2023-03-16 12:51:11','',''),(7211,'1','310','1',1,'Retail Sale Id 7004',4320.00,0.00,0.00,6.00,414.00,'2023-03-16 12:52:20','',''),(7212,'1','310','1',1,'Retail Sale Id 7005',3600.00,0.00,0.00,5.00,345.00,'2023-03-16 13:01:01','',''),(7213,'1','310','1',1,'Retail Sale Id 7006',720.00,0.00,0.00,1.00,69.00,'2023-03-16 13:12:02','',''),(7214,'1','310','1',1,'Retail Sale Id 7007',70000.00,0.00,0.00,100.00,4900.00,'2023-03-16 13:13:36','',''),(7215,'1','310','1',1,'Retail Sale Id 7008',1440.00,0.00,0.00,2.00,138.00,'2023-03-16 13:14:25','',''),(7216,'1','310','1',1,'Retail Sale Id 7009',1440.00,0.00,0.00,2.00,138.00,'2023-03-16 13:17:20','',''),(7217,'1','310','1',1,'Retail Sale Id 7010',2160.00,0.00,0.00,3.00,207.00,'2023-03-16 13:19:51','',''),(7218,'1','310','1',1,'Retail Sale Id 7011',7920.00,0.00,0.00,11.00,759.00,'2023-03-16 13:27:32','',''),(7219,'1','310','1',1,'Retail Sale Id 7012',1000.80,0.00,0.00,1.39,95.91,'2023-03-16 13:28:28','',''),(7220,'1','310','1',1,'Retail Sale Id 7013',3002.40,0.00,0.00,4.17,287.73,'2023-03-16 13:48:01','',''),(7221,'1','310','1',1,'Retail Sale Id 7014',4320.00,0.00,0.00,6.00,414.00,'2023-03-16 13:52:34','',''),(7222,'1','310','1',1,'Retail Sale Id 7015',2498.40,0.00,0.00,3.47,239.43,'2023-03-16 13:56:38','',''),(7223,'1','310','1',1,'Retail Sale Id 7016',2001.60,0.00,0.00,2.78,191.82,'2023-03-16 13:58:35','',''),(7224,'1','310','1',1,'Retail Sale Id 7017',4320.00,0.00,0.00,6.00,414.00,'2023-03-16 14:03:28','',''),(7225,'1','310','1',1,'Retail Sale Id 7018',2160.00,0.00,0.00,3.00,207.00,'2023-03-16 14:04:35','',''),(7226,'1','310','1',1,'Retail Sale Id 7019',70000.00,0.00,0.00,100.00,4900.00,'2023-03-16 14:16:31','',''),(7227,'1','310','1',1,'Retail Sale Id 7020',1500.00,0.00,0.00,1.00,849.00,'2023-03-16 14:19:42','',''),(7228,'1','310','1',1,'Retail Sale Id 7021',1497.60,0.00,0.00,2.08,143.52,'2023-03-16 14:23:27','',''),(7229,'1','310','1',1,'Return of Retail Sale Id 7020',0.00,1500.00,1.00,0.00,-849.00,'2023-03-16 14:26:11','',''),(7230,'1','310','1',1,'Retail Sale Id 7022',9496.80,0.00,0.00,13.19,910.11,'2023-03-16 14:27:57','',''),(7231,'1','310','1',1,'Retail Sale Id 7023',9520.00,0.00,0.00,13.60,666.40,'2023-03-16 14:35:28','',''),(7232,'1','310','1',1,'Retail Sale Id 7024',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 14:38:08','',''),(7233,'1','310','1',1,'Retail Sale Id 7024',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 14:38:08','',''),(7234,'1','310','1',1,'Retail Sale Id 7025',1497.60,0.00,0.00,2.08,143.52,'2023-03-16 14:41:03','',''),(7235,'1','310','1',1,'Return of Retail Sale Id 7022',0.00,9496.80,13.19,0.00,-910.11,'2023-03-16 14:42:53','',''),(7236,'1','310','1',1,'Retail Sale Id 7026',4320.00,0.00,0.00,6.00,414.00,'2023-03-16 14:47:31','',''),(7237,'1','310','1',1,'Retail Sale Id 7027',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 14:49:09','',''),(7238,'1','310','1',1,'Retail Sale Id 7028',3600.00,0.00,0.00,5.00,345.00,'2023-03-16 14:50:13','',''),(7239,'1','310','1',1,'Retail Sale Id 7029',3002.40,0.00,0.00,4.17,287.73,'2023-03-16 14:54:43','',''),(7240,'1','310','1',1,'Retail Sale Id 7030',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 15:03:57','',''),(7241,'1','310','1',1,'Retail Sale Id 7031',4320.00,0.00,0.00,6.00,414.00,'2023-03-16 15:30:19','',''),(7242,'1','310','1',1,'Retail Sale Id 7031',4320.00,0.00,0.00,6.00,414.00,'2023-03-16 15:30:19','',''),(7243,'1','310','1',1,'Retail Sale Id 7032',2001.60,0.00,0.00,2.78,191.82,'2023-03-16 15:32:13','',''),(7244,'1','310','1',1,'Retail Sale Id 7032',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 15:32:13','',''),(7245,'1','310','1',1,'Retail Sale Id 7033',2160.00,0.00,0.00,3.00,207.00,'2023-03-16 15:33:40','',''),(7246,'1','310','1',1,'Retail Sale Id 7034',3600.00,0.00,0.00,5.00,345.00,'2023-03-16 15:35:19','',''),(7247,'1','310','1',1,'Retail Sale Id 7035',4399.20,0.00,0.00,6.11,421.59,'2023-03-16 15:44:30','',''),(7248,'1','310','1',1,'Retail Sale Id 7036',720.00,0.00,0.00,1.00,69.00,'2023-03-16 15:52:33','',''),(7249,'1','310','1',1,'Retail Sale Id 7037',4320.00,0.00,0.00,6.00,414.00,'2023-03-16 15:56:45','',''),(7250,'1','310','1',1,'Retail Sale Id 7038',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 16:05:07','',''),(7251,'1','310','1',1,'Retail Sale Id 7039',1440.00,0.00,0.00,2.00,138.00,'2023-03-16 16:17:04','',''),(7252,'1','310','1',1,'Retail Sale Id 7040',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 16:18:52','',''),(7253,'1','310','1',1,'Retail Sale Id 7041',3600.00,0.00,0.00,5.00,345.00,'2023-03-16 16:27:06','',''),(7254,'1','310','1',1,'Retail Sale Id 7042',3002.40,0.00,0.00,4.17,287.73,'2023-03-16 16:29:19','',''),(7255,'1','310','1',1,'Retail Sale Id 7043',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 16:30:20','',''),(7256,'1','310','1',1,'Retail Sale Id 7044',2160.00,0.00,0.00,3.00,207.00,'2023-03-16 16:31:17','',''),(7257,'1','310','1',1,'Retail Sale Id 7044',2160.00,0.00,0.00,3.00,207.00,'2023-03-16 16:31:17','',''),(7258,'1','310','1',1,'Retail Sale Id 7045',2001.60,0.00,0.00,2.78,191.82,'2023-03-16 16:31:51','',''),(7259,'1','310','1',1,'Retail Sale Id 7046',1202.40,0.00,0.00,1.67,115.23,'2023-03-16 16:32:54','',''),(7260,'1','310','1',1,'Retail Sale Id 7047',2160.00,0.00,0.00,3.00,207.00,'2023-03-16 16:33:45','',''),(7261,'1','310','1',1,'Retail Sale Id 7048',2160.00,0.00,0.00,3.00,207.00,'2023-03-16 16:37:43','',''),(7262,'1','310','1',1,'Retail Sale Id 7049',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 16:41:08','',''),(7263,'1','310','1',1,'Retail Sale Id 7050',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 16:43:59','',''),(7264,'1','310','1',1,'Retail Sale Id 7051',4320.00,0.00,0.00,6.00,414.00,'2023-03-16 16:46:39','',''),(7265,'1','310','1',1,'Retail Sale Id 7052',2498.40,0.00,0.00,3.47,239.43,'2023-03-16 16:53:31','',''),(7266,'1','310','1',1,'Retail Sale Id 7053',1497.60,0.00,0.00,2.08,143.52,'2023-03-16 16:57:49','',''),(7267,'1','310','1',1,'Retail Sale Id 7054',2160.00,0.00,0.00,3.00,207.00,'2023-03-16 17:05:39','',''),(7268,'1','310','1',1,'Retail Sale Id 7055',3600.00,0.00,0.00,5.00,345.00,'2023-03-16 17:07:36','',''),(7269,'1','310','1',1,'Retail Sale Id 7056',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 17:10:07','',''),(7270,'1','310','1',1,'Retail Sale Id 7056',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 17:10:07','',''),(7271,'1','310','1',1,'Retail Sale Id 7056',36000.00,0.00,0.00,50.00,3450.00,'2023-03-16 17:10:07','',''),(7272,'1','310','1',1,'Retail Sale Id 7057',2498.40,0.00,0.00,3.47,239.43,'2023-03-16 17:19:51','',''),(7273,'1','310','1',1,'Retail Sale Id 7058',4320.00,0.00,0.00,6.00,414.00,'2023-03-16 17:33:39','',''),(7274,'1','310','1',1,'Retail Sale Id 7059',1000.80,0.00,0.00,1.39,95.91,'2023-03-16 17:38:10','',''),(7275,'1','310','1',1,'Retail Sale Id 7060',2160.00,0.00,0.00,3.00,207.00,'2023-03-16 17:39:30','',''),(7276,'1','310','1',1,'Retail Sale Id 7061',4320.00,0.00,0.00,6.00,414.00,'2023-03-16 17:40:10','',''),(7277,'1','310','1',1,'Retail Sale Id 7062',4320.00,0.00,0.00,6.00,414.00,'2023-03-16 17:48:13','',''),(7278,'1','310','1',1,'Retail Sale Id 7063',1000.80,0.00,0.00,1.39,95.91,'2023-03-16 17:49:29','',''),(7279,'1','310','1',1,'Retail Sale Id 7064',4003.20,0.00,0.00,5.56,383.64,'2023-03-16 17:54:46','',''),(7280,'1','310','1',1,'Retail Sale Id 7065',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 17:56:01','',''),(7281,'1','310','1',1,'Retail Sale Id 7066',35000.00,0.00,0.00,50.00,2450.00,'2023-03-16 17:57:24','',''),(7282,'1','310','1',1,'Retail Sale Id 7067',2001.60,0.00,0.00,2.78,191.82,'2023-03-16 18:02:13','',''),(7283,'1','310','1',1,'Retail Sale Id 7068',7200.00,0.00,0.00,10.00,690.00,'2023-03-16 18:04:09','',''),(7284,'1','310','1',1,'Retail Sale Id 7070',3600.00,0.00,0.00,5.00,345.00,'2023-03-16 18:08:28','',''),(7285,'1','310','1',1,'Retail Sale Id 7070',4320.00,0.00,0.00,6.00,414.00,'2023-03-16 18:08:28','',''),(7286,'1','310','1',1,'Retail Sale Id 7072',2001.60,0.00,0.00,2.78,191.82,'2023-03-16 18:15:54','',''),(7287,'1','310','1',1,'Retail Sale Id 7073',3600.00,0.00,0.00,5.00,345.00,'2023-03-16 18:17:13','',''),(7288,'1','310','1',1,'Retail Sale Id 7074',4320.00,0.00,0.00,6.00,414.00,'2023-03-16 18:20:27','',''),(7289,'1','310','1',1,'Retail Sale Id 7075',720.00,0.00,0.00,1.00,69.00,'2023-03-16 18:22:57','',''),(7290,'1','310','1',1,'Retail Sale Id 7076',2001.60,0.00,0.00,2.78,191.82,'2023-03-16 18:30:05','',''),(7291,'1','310','1',1,'Retail Sale Id 7077',2160.00,0.00,0.00,3.00,207.00,'2023-03-16 18:34:10','',''),(7292,'1','310','1',1,'Retail Sale Id 7078',9000.00,0.00,0.00,12.50,862.50,'2023-03-16 19:03:50','',''),(7293,'1','310','1',1,'Return of Retail Sale Id 7001',0.00,3500.00,5.00,0.00,-245.00,'2023-03-16 19:13:48','',''),(7294,'1','310','1',1,'Retail Sale Id 7079',3500.00,0.00,0.00,5.00,245.00,'2023-03-16 19:15:58','',''),(7295,'1','310','1',1,'Return of Retail Sale Id 7075',0.00,720.00,1.00,0.00,-69.00,'2023-03-16 19:18:27','',''),(7296,'1','310','1',1,'Retail Sale Id 7080',475.20,0.00,0.00,0.66,45.54,'2023-03-16 19:19:42','',''),(7297,'1','310','1',1,'Retail Sale Id 7081',367.20,0.00,0.00,0.51,35.19,'2023-03-17 07:11:33','',''),(7298,'1','310','1',1,'Retail Sale Id 7082',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 07:30:37','',''),(7299,'1','310','1',1,'Retail Sale Id 7083',3500.00,0.00,0.00,5.00,245.00,'2023-03-17 07:34:54','',''),(7300,'1','310','1',1,'Retail Sale Id 7084',1497.60,0.00,0.00,2.08,143.52,'2023-03-17 07:37:47','',''),(7301,'1','310','1',1,'Retail Sale Id 7085',2001.60,0.00,0.00,2.78,191.82,'2023-03-17 07:44:44','',''),(7302,'1','310','1',1,'Retail Sale Id 7086',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 08:03:05','',''),(7303,'1','310','1',1,'Retail Sale Id 7087',2160.00,0.00,0.00,3.00,207.00,'2023-03-17 08:04:49','',''),(7304,'1','310','1',1,'Retail Sale Id 7088',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 08:06:13','',''),(7305,'1','310','1',1,'Retail Sale Id 7089',3002.40,0.00,0.00,4.17,287.73,'2023-03-17 08:07:46','',''),(7306,'1','310','1',1,'Retail Sale Id 7090',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 08:09:29','',''),(7307,'1','310','1',1,'Retail Sale Id 7091',3600.00,0.00,0.00,5.00,345.00,'2023-03-17 08:11:14','',''),(7308,'1','310','1',1,'Retail Sale Id 7092',3002.40,0.00,0.00,4.17,287.73,'2023-03-17 08:12:00','',''),(7309,'1','310','1',1,'Retail Sale Id 7093',8750.00,0.00,0.00,12.50,612.50,'2023-03-17 08:19:04','',''),(7310,'1','310','1',1,'Retail Sale Id 7094',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 08:20:44','',''),(7311,'1','310','1',1,'Retail Sale Id 7094',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 08:20:44','',''),(7312,'1','310','1',1,'Retail Sale Id 7095',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 08:33:40','',''),(7313,'1','310','1',1,'Retail Sale Id 7096',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 08:35:51','',''),(7314,'1','310','1',1,'Retail Sale Id 7097',1497.60,0.00,0.00,2.08,143.52,'2023-03-17 08:49:54','',''),(7315,'1','310','1',1,'Retail Sale Id 7098',2160.00,0.00,0.00,3.00,207.00,'2023-03-17 08:53:42','',''),(7316,'1','310','1',1,'Retail Sale Id 7099',9100.00,0.00,0.00,13.00,637.00,'2023-03-17 08:56:55','',''),(7317,'1','310','1',1,'Retail Sale Id 7100',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 08:57:56','',''),(7318,'1','310','1',1,'Retail Sale Id 7101',2160.00,0.00,0.00,3.00,207.00,'2023-03-17 08:59:56','',''),(7319,'1','310','1',1,'Retail Sale Id 7102',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 09:34:05','',''),(7320,'1','310','1',1,'Retail Sale Id 7103',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 09:44:40','',''),(7321,'1','310','1',1,'Retail Sale Id 7104',2001.60,0.00,0.00,2.78,191.82,'2023-03-17 09:48:01','',''),(7322,'1','310','1',1,'Retail Sale Id 7105',70000.00,0.00,0.00,100.00,4900.00,'2023-03-17 09:53:38','',''),(7323,'1','310','1',1,'Retail Sale Id 7106',748.80,0.00,0.00,1.04,71.76,'2023-03-17 09:59:32','',''),(7324,'1','310','1',1,'Retail Sale Id 7106',748.80,0.00,0.00,1.04,71.76,'2023-03-17 09:59:32','',''),(7325,'1','310','1',1,'Retail Sale Id 7107',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 10:00:40','',''),(7326,'1','310','1',1,'Retail Sale Id 7108',3499.20,0.00,0.00,4.86,335.34,'2023-03-17 10:02:33','',''),(7327,'1','310','1',1,'Retail Sale Id 7109',7999.20,0.00,0.00,11.11,766.59,'2023-03-17 10:03:21','',''),(7328,'1','310','1',1,'Retail Sale Id 7110',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 10:05:44','',''),(7329,'1','310','1',1,'Retail Sale Id 7111',112000.00,0.00,0.00,160.00,7840.00,'2023-03-17 10:09:06','',''),(7330,'1','310','1',1,'Retail Sale Id 7112',2160.00,0.00,0.00,3.00,207.00,'2023-03-17 10:09:48','',''),(7331,'1','310','1',1,'Retail Sale Id 7113',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 10:17:01','',''),(7332,'1','310','1',1,'Retail Sale Id 7114',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 10:20:48','',''),(7333,'1','310','1',1,'Retail Sale Id 7115',2203.20,0.00,0.00,3.06,211.14,'2023-03-17 10:21:30','',''),(7334,'1','310','1',1,'Retail Sale Id 7116',3600.00,0.00,0.00,5.00,345.00,'2023-03-17 10:22:42','',''),(7335,'1','310','1',1,'Retail Sale Id 7117',2160.00,0.00,0.00,3.00,207.00,'2023-03-17 10:42:33','',''),(7336,'1','310','1',1,'Retail Sale Id 7117',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 10:42:33','',''),(7337,'1','310','1',1,'Retail Sale Id 7118',7999.20,0.00,0.00,11.11,766.59,'2023-03-17 10:43:18','',''),(7338,'1','310','1',1,'Retail Sale Id 7119',3002.40,0.00,0.00,4.17,287.73,'2023-03-17 10:44:50','',''),(7339,'1','310','1',1,'Retail Sale Id 7120',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 10:51:11','',''),(7340,'1','310','1',1,'Retail Sale Id 7121',17500.00,0.00,0.00,25.00,1225.00,'2023-03-17 10:59:31','',''),(7341,'1','310','1',1,'Retail Sale Id 7122',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 11:01:30','',''),(7342,'1','310','1',1,'Retail Sale Id 7123',35000.00,0.00,0.00,50.00,2450.00,'2023-03-17 11:03:58','',''),(7343,'1','310','1',1,'Retail Sale Id 7124',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 11:07:27','',''),(7344,'1','310','1',1,'Retail Sale Id 7124',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 11:07:27','',''),(7345,'1','310','1',1,'Retail Sale Id 7124',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 11:07:27','',''),(7346,'1','310','1',1,'Retail Sale Id 7124',1497.60,0.00,0.00,2.08,143.52,'2023-03-17 11:07:27','',''),(7347,'1','310','1',1,'Retail Sale Id 7125',4996.80,0.00,0.00,6.94,478.86,'2023-03-17 11:10:01','',''),(7348,'1','310','1',1,'Retail Sale Id 7126',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 11:10:33','',''),(7349,'1','310','1',1,'Retail Sale Id 7127',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 11:14:49','',''),(7350,'1','310','1',1,'Retail Sale Id 7129',2203.20,0.00,0.00,3.06,211.14,'2023-03-17 11:16:48','',''),(7351,'1','310','1',1,'Retail Sale Id 7130',35000.00,0.00,0.00,50.00,2450.00,'2023-03-17 11:19:38','',''),(7352,'1','310','1',1,'Retail Sale Id 7131',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 11:21:32','',''),(7353,'1','310','1',1,'Retail Sale Id 7132',1497.60,0.00,0.00,2.08,143.52,'2023-03-17 11:22:51','',''),(7354,'1','310','1',1,'Retail Sale Id 7133',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 11:25:20','',''),(7355,'1','310','1',1,'Retail Sale Id 7134',105000.00,0.00,0.00,150.00,7350.00,'2023-03-17 11:33:37','',''),(7356,'1','310','1',1,'Retail Sale Id 7135',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 11:38:18','',''),(7357,'1','310','1',1,'Retail Sale Id 7135',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 11:38:18','',''),(7358,'1','310','1',1,'Retail Sale Id 7136',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 11:39:38','',''),(7359,'1','310','1',1,'Retail Sale Id 7137',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 11:40:17','',''),(7360,'1','310','1',1,'Retail Sale Id 7138',4003.20,0.00,0.00,5.56,383.64,'2023-03-17 11:43:21','',''),(7361,'1','310','1',1,'Retail Sale Id 7139',2160.00,0.00,0.00,3.00,207.00,'2023-03-17 11:45:25','',''),(7362,'1','310','1',1,'Retail Sale Id 7140',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 11:46:37','',''),(7363,'1','310','1',1,'Retail Sale Id 7141',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 11:47:51','',''),(7364,'1','310','1',1,'Retail Sale Id 7142',2160.00,0.00,0.00,3.00,207.00,'2023-03-17 11:50:59','',''),(7365,'1','310','1',1,'Retail Sale Id 7143',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 11:52:53','',''),(7366,'1','310','1',1,'Retail Sale Id 7144',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 11:54:50','',''),(7367,'1','310','1',1,'Retail Sale Id 7145',1497.60,0.00,0.00,2.08,143.52,'2023-03-17 11:56:42','',''),(7368,'1','310','1',1,'Retail Sale Id 7146',1440.00,0.00,0.00,2.00,138.00,'2023-03-17 11:58:10','',''),(7369,'1','310','1',1,'Retail Sale Id 7147',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 12:04:03','',''),(7370,'1','310','1',1,'Retail Sale Id 7148',2498.40,0.00,0.00,3.47,239.43,'2023-03-17 12:09:43','',''),(7371,'1','310','1',1,'Retail Sale Id 7149',4500.00,0.00,0.00,6.25,431.25,'2023-03-17 12:11:23','',''),(7372,'1','310','1',1,'Retail Sale Id 7150',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 12:12:07','',''),(7373,'1','310','1',1,'Retail Sale Id 7151',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 12:13:32','',''),(7374,'1','310','1',1,'Retail Sale Id 7151',7200.00,0.00,0.00,10.00,690.00,'2023-03-17 12:13:32','',''),(7375,'1','310','1',1,'Retail Sale Id 7152',3002.40,0.00,0.00,4.17,287.73,'2023-03-17 12:16:36','',''),(7376,'1','310','1',1,'Retail Sale Id 7153',4399.20,0.00,0.00,6.11,421.59,'2023-03-17 12:19:41','',''),(7377,'1','310','1',1,'Retail Sale Id 7155',720.00,0.00,0.00,1.00,69.00,'2023-03-17 12:22:21','',''),(7378,'1','310','1',1,'Retail Sale Id 7155',6480.00,0.00,0.00,9.00,621.00,'2023-03-17 12:22:21','',''),(7379,'1','310','1',1,'Retail Sale Id 7156',4003.20,0.00,0.00,5.56,383.64,'2023-03-17 12:24:27','',''),(7380,'1','310','1',1,'Retail Sale Id 7157',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 12:29:15','',''),(7381,'1','310','1',1,'Retail Sale Id 7158',4500.00,0.00,0.00,6.25,431.25,'2023-03-17 12:31:10','',''),(7382,'1','310','1',1,'Retail Sale Id 7159',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 12:32:00','',''),(7383,'1','310','1',1,'Retail Sale Id 7160',3002.40,0.00,0.00,4.17,287.73,'2023-03-17 12:34:13','',''),(7384,'1','310','1',1,'Retail Sale Id 7161',1440.00,0.00,0.00,2.00,138.00,'2023-03-17 12:41:11','',''),(7385,'1','310','1',1,'Retail Sale Id 7162',3600.00,0.00,0.00,5.00,345.00,'2023-03-17 12:42:49','',''),(7386,'1','310','1',1,'Retail Sale Id 7163',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 12:44:01','',''),(7387,'1','310','1',1,'Retail Sale Id 7164',3196.80,0.00,0.00,4.44,306.36,'2023-03-17 12:46:13','',''),(7388,'1','310','1',1,'Retail Sale Id 7165',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 12:52:40','',''),(7389,'1','310','1',1,'Retail Sale Id 7166',1440.00,0.00,0.00,2.00,138.00,'2023-03-17 12:54:11','',''),(7390,'1','310','1',1,'Retail Sale Id 7167',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 12:56:34','',''),(7391,'1','310','1',1,'Retail Sale Id 7168',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 13:04:32','',''),(7392,'1','310','1',1,'Retail Sale Id 7169',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 13:27:53','',''),(7393,'1','310','1',1,'Retail Sale Id 7170',2001.60,0.00,0.00,2.78,191.82,'2023-03-17 13:29:53','',''),(7394,'1','310','1',1,'Retail Sale Id 7171',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 13:34:39','',''),(7395,'1','310','1',1,'Retail Sale Id 7172',2160.00,0.00,0.00,3.00,207.00,'2023-03-17 13:42:19','',''),(7396,'1','310','1',1,'Retail Sale Id 7173',2160.00,0.00,0.00,3.00,207.00,'2023-03-17 13:48:48','',''),(7397,'1','310','1',1,'Retail Sale Id 7174',3600.00,0.00,0.00,5.00,345.00,'2023-03-17 13:52:47','',''),(7398,'1','310','1',1,'Retail Sale Id 7174',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 13:52:47','',''),(7399,'1','310','1',1,'Retail Sale Id 7174',5760.00,0.00,0.00,8.00,552.00,'2023-03-17 13:52:47','',''),(7400,'1','310','1',1,'Retail Sale Id 7174',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 13:52:47','',''),(7401,'1','310','1',1,'Retail Sale Id 7174',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 13:52:47','',''),(7402,'1','310','1',1,'Retail Sale Id 7174',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 13:52:47','',''),(7403,'1','310','1',1,'Retail Sale Id 7175',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 13:54:12','',''),(7404,'1','310','1',1,'Retail Sale Id 7176',1080.00,0.00,0.00,1.50,103.50,'2023-03-17 14:10:13','',''),(7405,'1','310','1',1,'Retail Sale Id 7177',8640.00,0.00,0.00,12.00,828.00,'2023-03-17 14:12:48','',''),(7406,'1','310','1',1,'Retail Sale Id 7178',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 14:17:32','',''),(7407,'1','310','1',1,'Retail Sale Id 7179',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 14:22:52','',''),(7408,'1','310','1',1,'Retail Sale Id 7180',2001.60,0.00,0.00,2.78,191.82,'2023-03-17 14:28:44','',''),(7409,'1','310','1',1,'Retail Sale Id 7181',4003.20,0.00,0.00,5.56,383.64,'2023-03-17 14:32:25','',''),(7410,'1','310','1',1,'Retail Sale Id 7182',2160.00,0.00,0.00,3.00,207.00,'2023-03-17 14:33:50','',''),(7411,'1','310','1',1,'Retail Sale Id 7183',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 14:35:56','',''),(7412,'1','310','1',1,'Retail Sale Id 7184',4996.80,0.00,0.00,6.94,478.86,'2023-03-17 14:41:15','',''),(7413,'1','310','1',1,'Retail Sale Id 7185',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 14:43:04','',''),(7414,'1','310','1',1,'Retail Sale Id 7186',2160.00,0.00,0.00,3.00,207.00,'2023-03-17 14:44:08','',''),(7415,'1','310','1',1,'Retail Sale Id 7186',2160.00,0.00,0.00,3.00,207.00,'2023-03-17 14:44:08','',''),(7416,'1','310','1',1,'Retail Sale Id 7187',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 14:47:15','',''),(7417,'1','310','1',1,'Retail Sale Id 7188',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 14:52:20','',''),(7418,'1','310','1',1,'Retail Sale Id 7189',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 14:53:41','',''),(7419,'1','310','1',1,'Retail Sale Id 7190',2160.00,0.00,0.00,3.00,207.00,'2023-03-17 15:03:25','',''),(7420,'1','310','1',1,'Retail Sale Id 7191',2001.60,0.00,0.00,2.78,191.82,'2023-03-17 15:10:44','',''),(7421,'1','310','1',1,'Retail Sale Id 7192',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 15:13:16','',''),(7422,'1','310','1',1,'Retail Sale Id 7193',35000.00,0.00,0.00,50.00,2450.00,'2023-03-17 15:14:30','',''),(7423,'1','310','1',1,'Retail Sale Id 7194',4996.80,0.00,0.00,6.94,478.86,'2023-03-17 15:15:54','',''),(7424,'1','310','1',1,'Retail Sale Id 7195',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 15:25:53','',''),(7425,'1','310','1',1,'Retail Sale Id 7196',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 15:32:31','',''),(7426,'1','310','1',1,'Retail Sale Id 7197',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 15:35:50','',''),(7427,'1','310','1',1,'Retail Sale Id 7198',2160.00,0.00,0.00,3.00,207.00,'2023-03-17 15:37:55','',''),(7428,'1','310','1',1,'Retail Sale Id 7199',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 15:39:51','',''),(7429,'1','310','1',1,'Retail Sale Id 7199',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 15:39:51','',''),(7430,'1','310','1',1,'Retail Sale Id 7200',77917.00,0.00,0.00,111.31,5454.19,'2023-03-17 15:43:01','',''),(7431,'1','310','1',1,'Retail Sale Id 7201',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 15:44:09','',''),(7432,'1','310','1',1,'Retail Sale Id 7202',2203.20,0.00,0.00,3.06,211.14,'2023-03-17 15:45:14','',''),(7433,'1','310','1',1,'Retail Sale Id 7203',698.40,0.00,0.00,0.97,66.93,'2023-03-17 15:45:48','',''),(7434,'1','310','1',1,'Retail Sale Id 7204',7999.20,0.00,0.00,11.11,766.59,'2023-03-17 15:48:19','',''),(7435,'1','310','1',1,'Retail Sale Id 7205',2001.60,0.00,0.00,2.78,191.82,'2023-03-17 15:51:22','',''),(7436,'1','310','1',1,'Retail Sale Id 7206',3997.00,0.00,0.00,5.71,279.79,'2023-03-17 15:52:30','',''),(7437,'1','310','1',1,'Retail Sale Id 7207',2001.60,0.00,0.00,2.78,191.82,'2023-03-17 15:53:34','',''),(7438,'1','310','1',1,'Retail Sale Id 7208',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 16:02:06','',''),(7439,'1','310','1',1,'Retail Sale Id 7209',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 16:18:19','',''),(7440,'1','310','1',1,'Retail Sale Id 7210',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 16:20:15','',''),(7441,'1','310','1',1,'Retail Sale Id 7211',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 16:23:55','',''),(7442,'1','310','1',1,'Retail Sale Id 7212',2160.00,0.00,0.00,3.00,207.00,'2023-03-17 16:25:45','',''),(7443,'1','310','1',1,'Retail Sale Id 7213',2160.00,0.00,0.00,3.00,207.00,'2023-03-17 16:27:25','',''),(7444,'1','310','1',1,'Retail Sale Id 7214',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 16:28:51','',''),(7445,'1','310','1',1,'Retail Sale Id 7215',2001.60,0.00,0.00,2.78,191.82,'2023-03-17 16:38:15','',''),(7446,'1','310','1',1,'Retail Sale Id 7216',70000.00,0.00,0.00,100.00,4900.00,'2023-03-17 16:39:48','',''),(7447,'1','310','1',1,'Retail Sale Id 7217',2498.40,0.00,0.00,3.47,239.43,'2023-03-17 16:42:01','',''),(7448,'1','310','1',1,'Retail Sale Id 7218',5760.00,0.00,0.00,8.00,552.00,'2023-03-17 16:42:55','',''),(7449,'1','310','1',1,'Retail Sale Id 7220',3600.00,0.00,0.00,5.00,345.00,'2023-03-17 16:43:48','',''),(7450,'1','310','1',1,'Retail Sale Id 7221',2001.60,0.00,0.00,2.78,191.82,'2023-03-17 16:48:41','',''),(7451,'1','310','1',1,'Retail Sale Id 7222',7200.00,0.00,0.00,10.00,690.00,'2023-03-17 16:55:56','',''),(7452,'1','310','1',1,'Retail Sale Id 7223',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 16:58:53','',''),(7453,'1','310','1',1,'Retail Sale Id 7224',4996.80,0.00,0.00,6.94,478.86,'2023-03-17 17:00:38','',''),(7454,'1','310','1',1,'Retail Sale Id 7225',3600.00,0.00,0.00,5.00,345.00,'2023-03-17 17:02:03','',''),(7455,'1','310','1',1,'Retail Sale Id 7226',2001.60,0.00,0.00,2.78,191.82,'2023-03-17 17:04:39','',''),(7456,'1','310','1',1,'Retail Sale Id 7227',1080.00,0.00,0.00,1.50,103.50,'2023-03-17 17:05:28','',''),(7457,'1','310','1',1,'Retail Sale Id 7228',2001.60,0.00,0.00,2.78,191.82,'2023-03-17 17:06:51','',''),(7458,'1','310','1',1,'Retail Sale Id 7228',2160.00,0.00,0.00,3.00,207.00,'2023-03-17 17:06:51','',''),(7459,'1','310','1',1,'Retail Sale Id 7229',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 17:07:41','',''),(7460,'1','310','1',1,'Retail Sale Id 7230',2001.60,0.00,0.00,2.78,191.82,'2023-03-17 17:08:34','',''),(7461,'1','310','1',1,'Retail Sale Id 7231',7200.00,0.00,0.00,10.00,690.00,'2023-03-17 17:09:21','',''),(7462,'1','310','1',1,'Retail Sale Id 7232',3002.40,0.00,0.00,4.17,287.73,'2023-03-17 17:10:08','',''),(7463,'1','310','1',1,'Retail Sale Id 7233',2160.00,0.00,0.00,3.00,207.00,'2023-03-17 17:11:17','',''),(7464,'1','310','1',1,'Retail Sale Id 7234',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 17:11:49','',''),(7465,'1','310','1',1,'Retail Sale Id 7235',2498.40,0.00,0.00,3.47,239.43,'2023-03-17 17:12:40','',''),(7466,'1','310','1',1,'Retail Sale Id 7236',4003.20,0.00,0.00,5.56,383.64,'2023-03-17 17:14:47','',''),(7467,'1','310','1',1,'Retail Sale Id 7236',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 17:14:47','',''),(7468,'1','310','1',1,'Retail Sale Id 7237',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 17:22:27','',''),(7469,'1','310','1',1,'Retail Sale Id 7238',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 17:23:47','',''),(7470,'1','310','1',1,'Retail Sale Id 7239',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 17:27:40','',''),(7471,'1','310','1',1,'Retail Sale Id 7240',3002.40,0.00,0.00,4.17,287.73,'2023-03-17 17:31:06','',''),(7472,'1','310','1',1,'Retail Sale Id 7242',2001.60,0.00,0.00,2.78,191.82,'2023-03-17 17:32:48','',''),(7473,'1','310','1',1,'Retail Sale Id 7243',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 17:33:30','',''),(7474,'1','310','1',1,'Retail Sale Id 7244',3600.00,0.00,0.00,5.00,345.00,'2023-03-17 17:34:05','',''),(7475,'1','310','1',1,'Retail Sale Id 7245',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 17:37:56','',''),(7476,'1','310','1',1,'Retail Sale Id 7247',3002.40,0.00,0.00,4.17,287.73,'2023-03-17 17:41:51','',''),(7477,'1','310','1',1,'Retail Sale Id 7247',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 17:41:52','',''),(7478,'1','310','1',1,'Retail Sale Id 7248',20160.00,0.00,0.00,28.00,1932.00,'2023-03-17 17:44:19','',''),(7479,'1','310','1',1,'Retail Sale Id 7249',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 17:45:04','',''),(7480,'1','310','1',1,'Retail Sale Id 7250',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 17:48:14','',''),(7481,'1','310','1',1,'Retail Sale Id 7251',1497.60,0.00,0.00,2.08,143.52,'2023-03-17 17:49:03','',''),(7482,'1','310','1',1,'Retail Sale Id 7252',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 17:50:09','',''),(7483,'1','310','1',1,'Retail Sale Id 7253',2160.00,0.00,0.00,3.00,207.00,'2023-03-17 17:50:45','',''),(7484,'1','310','1',1,'Retail Sale Id 7254',3002.40,0.00,0.00,4.17,287.73,'2023-03-17 17:51:21','',''),(7485,'1','310','1',1,'Retail Sale Id 7255',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 17:52:22','',''),(7486,'1','310','1',1,'Retail Sale Id 7256',18000.00,0.00,0.00,25.00,1725.00,'2023-03-17 17:54:43','',''),(7487,'1','310','1',1,'Retail Sale Id 7257',1497.60,0.00,0.00,2.08,143.52,'2023-03-17 18:00:49','',''),(7488,'1','310','1',1,'Retail Sale Id 7258',3002.40,0.00,0.00,4.17,287.73,'2023-03-17 18:02:42','',''),(7489,'1','310','1',1,'Retail Sale Id 7259',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 18:04:33','',''),(7490,'1','310','1',1,'Retail Sale Id 7260',2160.00,0.00,0.00,3.00,207.00,'2023-03-17 18:05:39','',''),(7491,'1','310','1',1,'Retail Sale Id 7261',1497.60,0.00,0.00,2.08,143.52,'2023-03-17 18:07:41','',''),(7492,'1','310','1',1,'Retail Sale Id 7262',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 18:10:29','',''),(7493,'1','310','1',1,'Retail Sale Id 7263',3600.00,0.00,0.00,5.00,345.00,'2023-03-17 18:11:58','',''),(7494,'1','310','1',1,'Retail Sale Id 7264',2001.60,0.00,0.00,2.78,191.82,'2023-03-17 18:17:21','',''),(7495,'1','310','1',1,'Retail Sale Id 7265',1180.80,0.00,0.00,1.64,113.16,'2023-03-17 18:21:43','',''),(7496,'1','310','1',1,'Retail Sale Id 7265',2001.60,0.00,0.00,2.78,191.82,'2023-03-17 18:21:43','',''),(7497,'1','310','1',1,'Retail Sale Id 7265',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 18:21:43','',''),(7498,'1','310','1',1,'Retail Sale Id 7266',3002.40,0.00,0.00,4.17,287.73,'2023-03-17 18:22:25','',''),(7499,'1','310','1',1,'Retail Sale Id 7267',2052.00,0.00,0.00,2.85,196.65,'2023-03-17 18:23:40','',''),(7500,'1','310','1',1,'Retail Sale Id 7268',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 18:25:02','',''),(7501,'1','310','1',1,'Retail Sale Id 7269',4003.20,0.00,0.00,5.56,383.64,'2023-03-17 18:27:30','',''),(7502,'1','310','1',1,'Retail Sale Id 7270',1497.60,0.00,0.00,2.08,143.52,'2023-03-17 18:31:53','',''),(7503,'1','310','1',1,'Retail Sale Id 7271',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 18:32:40','',''),(7504,'1','310','1',1,'Retail Sale Id 7272',720.00,0.00,0.00,1.00,69.00,'2023-03-17 18:33:59','',''),(7505,'1','310','1',1,'Retail Sale Id 7273',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 18:36:39','',''),(7506,'1','310','1',1,'Retail Sale Id 7274',496.80,0.00,0.00,0.69,47.61,'2023-03-17 18:39:37','',''),(7507,'1','310','1',1,'Retail Sale Id 7275',35000.00,0.00,0.00,50.00,2450.00,'2023-03-17 18:41:47','',''),(7508,'1','310','1',1,'Retail Sale Id 7276',2498.40,0.00,0.00,3.47,239.43,'2023-03-17 18:42:51','',''),(7509,'1','310','1',1,'Retail Sale Id 7277',4996.80,0.00,0.00,6.94,478.86,'2023-03-17 18:43:57','',''),(7510,'1','310','1',1,'Retail Sale Id 7277',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 18:43:58','',''),(7511,'1','310','1',1,'Retail Sale Id 7278',1497.60,0.00,0.00,2.08,143.52,'2023-03-17 18:46:48','',''),(7512,'1','310','1',1,'Retail Sale Id 7279',2001.60,0.00,0.00,2.78,191.82,'2023-03-17 18:47:35','',''),(7513,'1','310','1',1,'Retail Sale Id 7280',2160.00,0.00,0.00,3.00,207.00,'2023-03-17 18:54:39','',''),(7514,'1','310','1',1,'Retail Sale Id 7281',4320.00,0.00,0.00,6.00,414.00,'2023-03-17 19:03:02','',''),(7515,'1','310','1',1,'Retail Sale Id 7282',8640.00,0.00,0.00,12.00,828.00,'2023-03-17 19:03:56','',''),(7516,'1','310','1',1,'Retail Sale Id 7283',4500.00,0.00,0.00,6.25,431.25,'2023-03-17 19:04:56','',''),(7517,'1','310','1',1,'Retail Sale Id 7284',70000.00,0.00,0.00,100.00,4900.00,'2023-03-17 19:06:33','',''),(7518,'1','310','1',1,'Retail Sale Id 7285',6998.40,0.00,0.00,9.72,670.68,'2023-03-17 19:12:08','',''),(7519,'1','310','1',1,'Retail Sale Id 7286',3499.20,0.00,0.00,4.86,335.34,'2023-03-17 19:13:59','',''),(7520,'1','310','1',1,'Retail Sale Id 7287',1440.00,0.00,0.00,2.00,138.00,'2023-03-17 19:15:21','',''),(7521,'1','310','1',1,'Retail Sale Id 7288',6998.40,0.00,0.00,9.72,670.68,'2023-03-17 19:16:14','',''),(7522,'1','310','1',1,'Retail Sale Id 7289',9000.00,0.00,0.00,12.50,862.50,'2023-03-17 19:17:59','',''),(7523,'1','310','1',1,'Retail Sale Id 7290',698.40,0.00,0.00,0.97,66.93,'2023-03-17 19:18:53','',''),(7524,'1','310','1',1,'Retail Sale Id 7291',3600.00,0.00,0.00,5.00,345.00,'2023-03-17 19:19:50','',''),(7525,'1','310','1',1,'Retail Sale Id 7292',6998.40,0.00,0.00,9.72,670.68,'2023-03-17 19:20:56','',''),(7526,'1','310','1',1,'Retail Sale Id 7293',3002.40,0.00,0.00,4.17,287.73,'2023-03-17 19:26:41','',''),(7527,'1','310','1',1,'Retail Sale Id 7294',2498.40,0.00,0.00,3.47,239.43,'2023-03-17 19:29:25','',''),(7528,'1','310','1',1,'Retail Sale Id 7295',496.80,0.00,0.00,0.69,47.61,'2023-03-17 19:32:38','',''),(7529,'1','310','1',1,'Retail Sale Id 7296',7200.00,0.00,0.00,10.00,690.00,'2023-03-17 19:33:59','',''),(7530,'1','310','1',1,'Retail Sale Id 7297',3003.00,0.00,0.00,4.29,210.21,'2023-03-17 19:35:27','',''),(7531,'1','310','1',1,'Retail Sale Id 7298',1598.40,0.00,0.00,2.22,153.18,'2023-03-17 19:37:28','',''),(7532,'1','310','1',1,'Retail Sale Id 7299',4003.20,0.00,0.00,5.56,383.64,'2023-03-17 19:41:22','',''),(7533,'1','310','1',1,'Retail Sale Id 7301',6199.20,0.00,0.00,8.61,594.09,'2023-03-17 19:42:30','',''),(7534,'1','310','1',1,'Retail Sale Id 7302',7200.00,0.00,0.00,10.00,690.00,'2023-03-17 19:44:04','',''),(7535,'1','310','1',1,'Retail Sale Id 7303',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 19:46:17','',''),(7536,'1','310','1',1,'Retail Sale Id 7304',1000.80,0.00,0.00,1.39,95.91,'2023-03-17 19:47:46','',''),(7537,'1','310','1',1,'Retail Sale Id 7305',4197.60,0.00,0.00,5.83,402.27,'2023-03-17 19:48:32','',''),(7538,'1','310','1',1,'Retail Sale Id 7306',3002.40,0.00,0.00,4.17,287.73,'2023-03-17 19:49:44','',''),(7539,'1','310','1',1,'Retail Sale Id 7307',3600.00,0.00,0.00,5.00,345.00,'2023-03-17 19:55:06','',''),(7540,'1','310','1',1,'Retail Sale Id 7308',3600.00,0.00,0.00,5.00,345.00,'2023-03-17 19:58:15','',''),(7541,'1','310','1',1,'Retail Sale Id 7309',4003.20,0.00,0.00,5.56,383.64,'2023-03-17 20:05:36','',''),(7542,'1','310','1',1,'Retail Sale Id 7310',2498.40,0.00,0.00,3.47,239.43,'2023-03-17 20:07:38','',''),(7543,'1','310','1',1,'Retail Sale Id 7311',1497.60,0.00,0.00,2.08,143.52,'2023-03-17 20:12:01','',''),(7544,'1','310','1',1,'Retail Sale Id 7312',8001.00,0.00,0.00,11.43,560.07,'2023-03-17 20:18:01','',''),(7545,'1','310','1',1,'Retail Sale Id 7313',89704.80,0.00,0.00,124.59,8596.71,'2023-03-17 20:33:19','',''),(7546,'1','310','1',1,'Return of Retail Sale Id 7297',0.00,3003.00,4.29,0.00,-210.21,'2023-03-17 20:34:20','',''),(7547,'1','310','1',1,'Retail Sale Id 7314',2772.00,0.00,0.00,3.96,194.04,'2023-03-17 20:35:20','',''),(7548,'1','310','1',1,'Retail Sale Id 7315',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 06:57:27','',''),(7549,'1','310','1',1,'Retail Sale Id 7316',10997.00,0.00,0.00,15.71,769.79,'2023-03-19 07:20:44','',''),(7550,'1','310','1',1,'Retail Sale Id 7317',1001.00,0.00,0.00,1.43,70.07,'2023-03-19 07:26:20','',''),(7551,'1','310','1',1,'Retail Sale Id 7318',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 07:31:41','',''),(7552,'1','310','1',1,'Retail Sale Id 7319',19999.00,0.00,0.00,28.57,1399.93,'2023-03-19 08:16:58','',''),(7553,'1','310','1',1,'Retail Sale Id 7320',70000.00,0.00,0.00,100.00,4900.00,'2023-03-19 08:20:56','',''),(7554,'1','310','1',1,'Retail Sale Id 7321',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 08:22:50','',''),(7555,'1','310','1',1,'Retail Sale Id 7322',4003.20,0.00,0.00,5.56,383.64,'2023-03-19 08:30:25','',''),(7556,'1','310','1',1,'Retail Sale Id 7323',3600.00,0.00,0.00,5.00,345.00,'2023-03-19 08:37:19','',''),(7557,'1','310','1',1,'Retail Sale Id 7324',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 08:38:37','',''),(7558,'1','310','1',1,'Retail Sale Id 7325',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 08:42:28','',''),(7559,'1','310','1',1,'Retail Sale Id 7326',3600.00,0.00,0.00,5.00,345.00,'2023-03-19 08:46:22','',''),(7560,'1','310','1',1,'Retail Sale Id 7327',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 08:50:39','',''),(7561,'1','310','1',1,'Retail Sale Id 7327',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 08:50:39','',''),(7562,'1','310','1',1,'Retail Sale Id 7328',3002.40,0.00,0.00,4.17,287.73,'2023-03-19 08:57:51','',''),(7563,'1','310','1',1,'Retail Sale Id 7329',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 09:05:07','',''),(7564,'1','310','1',1,'Retail Sale Id 7330',799.20,0.00,0.00,1.11,76.59,'2023-03-19 09:06:37','',''),(7565,'1','310','1',1,'Retail Sale Id 7331',70000.00,0.00,0.00,100.00,4900.00,'2023-03-19 09:08:37','',''),(7566,'1','310','1',1,'Retail Sale Id 7333',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 09:09:38','',''),(7567,'1','310','1',1,'Retail Sale Id 7334',799.20,0.00,0.00,1.11,76.59,'2023-03-19 09:12:53','',''),(7568,'1','310','1',1,'Retail Sale Id 7335',2203.20,0.00,0.00,3.06,211.14,'2023-03-19 09:14:30','',''),(7569,'1','310','1',1,'Retail Sale Id 7336',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 09:16:47','',''),(7570,'1','310','1',1,'Retail Sale Id 7337',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 09:18:06','',''),(7571,'1','310','1',1,'Retail Sale Id 7338',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 09:21:30','',''),(7572,'1','310','1',1,'Retail Sale Id 7339',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 09:26:37','',''),(7573,'1','310','1',1,'Retail Sale Id 7340',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 09:28:31','',''),(7574,'1','310','1',1,'Retail Sale Id 7340',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 09:28:31','',''),(7575,'1','310','1',1,'Retail Sale Id 7341',2001.60,0.00,0.00,2.78,191.82,'2023-03-19 09:29:33','',''),(7576,'1','310','1',1,'Retail Sale Id 7342',1497.60,0.00,0.00,2.08,143.52,'2023-03-19 09:30:38','',''),(7577,'1','310','1',1,'Retail Sale Id 7343',3600.00,0.00,0.00,5.00,345.00,'2023-03-19 09:35:08','',''),(7578,'1','310','1',1,'Retail Sale Id 7344',1497.60,0.00,0.00,2.08,143.52,'2023-03-19 09:36:06','',''),(7579,'1','310','1',1,'Retail Sale Id 7345',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 09:39:57','',''),(7580,'1','310','1',1,'Retail Sale Id 7346',70000.00,0.00,0.00,100.00,4900.00,'2023-03-19 09:43:38','',''),(7581,'1','310','1',1,'Retail Sale Id 7348',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 09:45:47','',''),(7582,'1','310','1',1,'Retail Sale Id 7349',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 09:50:38','',''),(7583,'1','310','1',1,'Retail Sale Id 7351',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 09:52:14','',''),(7584,'1','310','1',1,'Retail Sale Id 7352',1497.60,0.00,0.00,2.08,143.52,'2023-03-19 09:53:09','',''),(7585,'1','310','1',1,'Retail Sale Id 7353',4996.80,0.00,0.00,6.94,478.86,'2023-03-19 09:54:00','',''),(7586,'1','310','1',1,'Retail Sale Id 7354',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 09:55:25','',''),(7587,'1','310','1',1,'Retail Sale Id 7355',2001.60,0.00,0.00,2.78,191.82,'2023-03-19 10:00:34','',''),(7588,'1','310','1',1,'Retail Sale Id 7356',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 10:01:22','',''),(7589,'1','310','1',1,'Retail Sale Id 7357',2001.60,0.00,0.00,2.78,191.82,'2023-03-19 10:02:57','',''),(7590,'1','310','1',1,'Retail Sale Id 7358',3002.40,0.00,0.00,4.17,287.73,'2023-03-19 10:04:10','',''),(7591,'1','310','1',1,'Retail Sale Id 7358',3002.40,0.00,0.00,4.17,287.73,'2023-03-19 10:04:10','',''),(7592,'1','310','1',1,'Retail Sale Id 7359',2498.40,0.00,0.00,3.47,239.43,'2023-03-19 10:07:56','',''),(7593,'1','310','1',1,'Retail Sale Id 7360',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 10:09:13','',''),(7594,'1','310','1',1,'Retail Sale Id 7361',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 10:15:00','',''),(7595,'1','310','1',1,'Retail Sale Id 7362',3002.40,0.00,0.00,4.17,287.73,'2023-03-19 10:16:18','',''),(7596,'1','310','1',1,'Retail Sale Id 7363',3002.40,0.00,0.00,4.17,287.73,'2023-03-19 10:17:15','',''),(7597,'1','310','1',1,'Retail Sale Id 7364',3600.00,0.00,0.00,5.00,345.00,'2023-03-19 10:28:02','',''),(7598,'1','310','1',1,'Retail Sale Id 7365',4996.80,0.00,0.00,6.94,478.86,'2023-03-19 10:34:12','',''),(7599,'1','310','1',1,'Retail Sale Id 7366',4996.80,0.00,0.00,6.94,478.86,'2023-03-19 10:38:54','',''),(7600,'1','310','1',1,'Retail Sale Id 7367',94402.00,0.00,0.00,134.86,6608.14,'2023-03-19 10:41:39','',''),(7601,'1','310','1',1,'Retail Sale Id 7368',2880.00,0.00,0.00,4.00,276.00,'2023-03-19 10:42:42','',''),(7602,'1','310','1',1,'Retail Sale Id 7369',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 10:51:57','',''),(7603,'1','310','1',1,'Retail Sale Id 7370',3002.40,0.00,0.00,4.17,287.73,'2023-03-19 10:57:38','',''),(7604,'1','310','1',1,'Retail Sale Id 7371',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 10:58:55','',''),(7605,'1','310','1',1,'Retail Sale Id 7372',2001.60,0.00,0.00,2.78,191.82,'2023-03-19 11:00:57','',''),(7606,'1','310','1',1,'Retail Sale Id 7373',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 11:01:44','',''),(7607,'1','310','1',1,'Retail Sale Id 7374',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 11:02:30','',''),(7608,'1','310','1',1,'Retail Sale Id 7375',8400.00,0.00,0.00,12.00,588.00,'2023-03-19 11:03:53','',''),(7609,'1','310','1',1,'Retail Sale Id 7376',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 11:05:37','',''),(7610,'1','310','1',1,'Retail Sale Id 7376',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 11:05:37','',''),(7611,'1','310','1',1,'Retail Sale Id 7377',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 11:06:30','',''),(7612,'1','310','1',1,'Retail Sale Id 7378',35000.00,0.00,0.00,50.00,2450.00,'2023-03-19 11:07:39','',''),(7613,'1','310','1',1,'Retail Sale Id 7379',3002.40,0.00,0.00,4.17,287.73,'2023-03-19 11:08:36','',''),(7614,'1','310','1',1,'Retail Sale Id 7380',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 11:09:36','',''),(7615,'1','310','1',1,'Retail Sale Id 7381',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 11:15:18','',''),(7616,'1','310','1',1,'Retail Sale Id 7382',3600.00,0.00,0.00,5.00,345.00,'2023-03-19 11:16:23','',''),(7617,'1','310','1',1,'Retail Sale Id 7383',4003.20,0.00,0.00,5.56,383.64,'2023-03-19 11:17:23','',''),(7618,'1','310','1',1,'Retail Sale Id 7384',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 11:24:02','',''),(7619,'1','310','1',1,'Retail Sale Id 7385',74200.00,0.00,0.00,106.00,5194.00,'2023-03-19 11:27:04','',''),(7620,'1','310','1',1,'Retail Sale Id 7386',1497.60,0.00,0.00,2.08,143.52,'2023-03-19 11:29:55','',''),(7621,'1','310','1',1,'Retail Sale Id 7388',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 11:31:23','',''),(7622,'1','310','1',1,'Retail Sale Id 7390',3600.00,0.00,0.00,5.00,345.00,'2023-03-19 11:34:39','',''),(7623,'1','310','1',1,'Retail Sale Id 7390',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 11:34:39','',''),(7624,'1','310','1',1,'Retail Sale Id 7390',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 11:34:39','',''),(7625,'1','310','1',1,'Retail Sale Id 7391',3600.00,0.00,0.00,5.00,345.00,'2023-03-19 11:35:33','',''),(7626,'1','310','1',1,'Retail Sale Id 7393',2203.20,0.00,0.00,3.06,211.14,'2023-03-19 11:44:18','',''),(7627,'1','310','1',1,'Retail Sale Id 7394',17500.00,0.00,0.00,25.00,1225.00,'2023-03-19 11:46:06','',''),(7628,'1','310','1',1,'Retail Sale Id 7395',496.80,0.00,0.00,0.69,47.61,'2023-03-19 11:46:52','',''),(7629,'1','310','1',1,'Retail Sale Id 7396',105000.00,0.00,0.00,150.00,7350.00,'2023-03-19 11:48:06','',''),(7630,'1','310','1',1,'Retail Sale Id 7398',3002.40,0.00,0.00,4.17,287.73,'2023-03-19 11:49:02','',''),(7631,'1','310','1',1,'Retail Sale Id 7399',10800.00,0.00,0.00,15.00,1035.00,'2023-03-19 11:53:20','',''),(7632,'1','310','1',1,'Retail Sale Id 7400',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 11:54:55','',''),(7633,'1','310','1',1,'Retail Sale Id 7401',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 11:57:28','',''),(7634,'1','310','1',1,'Retail Sale Id 7402',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 11:59:12','',''),(7635,'1','310','1',1,'Retail Sale Id 7404',2001.60,0.00,0.00,2.78,191.82,'2023-03-19 12:00:48','',''),(7636,'1','310','1',1,'Retail Sale Id 7405',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 12:02:46','',''),(7637,'1','310','1',1,'Retail Sale Id 7406',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 12:08:17','',''),(7638,'1','310','1',1,'Retail Sale Id 7407',4003.20,0.00,0.00,5.56,383.64,'2023-03-19 12:09:32','',''),(7639,'1','310','1',1,'Retail Sale Id 7408',1303.20,0.00,0.00,1.81,124.89,'2023-03-19 12:12:03','',''),(7640,'1','310','1',1,'Retail Sale Id 7409',2001.60,0.00,0.00,2.78,191.82,'2023-03-19 12:13:03','',''),(7641,'1','310','1',1,'Retail Sale Id 7410',3600.00,0.00,0.00,5.00,345.00,'2023-03-19 12:14:40','',''),(7642,'1','310','1',1,'Retail Sale Id 7410',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 12:14:40','',''),(7643,'1','310','1',1,'Retail Sale Id 7410',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 12:14:40','',''),(7644,'1','310','1',1,'Retail Sale Id 7411',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 12:16:10','',''),(7645,'1','310','1',1,'Retail Sale Id 7412',3600.00,0.00,0.00,5.00,345.00,'2023-03-19 12:17:25','',''),(7646,'1','310','1',1,'Retail Sale Id 7413',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 12:19:31','',''),(7647,'1','310','1',1,'Retail Sale Id 7415',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 12:21:14','',''),(7648,'1','310','1',1,'Retail Sale Id 7417',3002.40,0.00,0.00,4.17,287.73,'2023-03-19 12:23:59','',''),(7649,'1','310','1',1,'Retail Sale Id 7418',56000.00,0.00,0.00,80.00,3920.00,'2023-03-19 12:25:07','',''),(7650,'1','310','1',1,'Retail Sale Id 7419',3002.40,0.00,0.00,4.17,287.73,'2023-03-19 12:26:04','',''),(7651,'1','310','1',1,'Retail Sale Id 7421',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 12:32:31','',''),(7652,'1','310','1',1,'Retail Sale Id 7421',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 12:32:31','',''),(7653,'1','310','1',1,'Retail Sale Id 7421',4003.20,0.00,0.00,5.56,383.64,'2023-03-19 12:32:31','',''),(7654,'1','310','1',1,'Retail Sale Id 7422',4996.80,0.00,0.00,6.94,478.86,'2023-03-19 12:33:31','',''),(7655,'1','310','1',1,'Retail Sale Id 7423',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 12:34:56','',''),(7656,'1','310','1',1,'Retail Sale Id 7423',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 12:34:56','',''),(7657,'1','310','1',1,'Retail Sale Id 7424',42000.00,0.00,0.00,60.00,2940.00,'2023-03-19 12:39:58','',''),(7658,'1','310','1',1,'Retail Sale Id 7425',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 12:40:42','',''),(7659,'1','310','1',1,'Retail Sale Id 7426',4996.80,0.00,0.00,6.94,478.86,'2023-03-19 12:41:43','',''),(7660,'1','310','1',1,'Retail Sale Id 7427',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 12:42:56','',''),(7661,'1','310','1',1,'Retail Sale Id 7428',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 12:45:14','',''),(7662,'1','310','1',1,'Retail Sale Id 7430',3499.20,0.00,0.00,4.86,335.34,'2023-03-19 12:46:35','',''),(7663,'1','310','1',1,'Return of Retail Sale Id 7426',0.00,4996.80,6.94,0.00,-478.86,'2023-03-19 12:47:41','',''),(7664,'1','310','1',1,'Retail Sale Id 7431',4996.80,0.00,0.00,6.94,478.86,'2023-03-19 12:50:41','',''),(7665,'1','310','1',1,'Retail Sale Id 7432',3600.00,0.00,0.00,5.00,345.00,'2023-03-19 12:51:49','',''),(7666,'1','310','1',1,'Retail Sale Id 7433',3002.40,0.00,0.00,4.17,287.73,'2023-03-19 12:57:12','',''),(7667,'1','310','1',1,'Retail Sale Id 7434',4996.80,0.00,0.00,6.94,478.86,'2023-03-19 13:01:38','',''),(7668,'1','310','1',1,'Retail Sale Id 7435',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 13:03:14','',''),(7669,'1','310','1',1,'Retail Sale Id 7436',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 13:10:07','',''),(7670,'1','310','1',1,'Retail Sale Id 7437',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 13:11:09','',''),(7671,'1','310','1',1,'Retail Sale Id 7438',496.80,0.00,0.00,0.69,47.61,'2023-03-19 13:11:55','',''),(7672,'1','310','1',1,'Retail Sale Id 7439',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 13:12:46','',''),(7673,'1','310','1',1,'Retail Sale Id 7440',350000.00,0.00,0.00,500.00,24500.00,'2023-03-19 13:21:05','',''),(7674,'1','310','1',1,'Retail Sale Id 7441',70000.00,0.00,0.00,100.00,4900.00,'2023-03-19 13:21:47','',''),(7675,'1','310','1',1,'Retail Sale Id 7442',1497.60,0.00,0.00,2.08,143.52,'2023-03-19 13:23:37','',''),(7676,'1','310','1',1,'Retail Sale Id 7443',8400.00,0.00,0.00,12.00,588.00,'2023-03-19 13:24:44','',''),(7677,'1','310','1',1,'Retail Sale Id 7444',3196.80,0.00,0.00,4.44,306.36,'2023-03-19 13:25:40','',''),(7678,'1','310','1',1,'Retail Sale Id 7445',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 13:26:38','',''),(7679,'1','310','1',1,'Retail Sale Id 7445',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 13:26:38','',''),(7680,'1','310','1',1,'Retail Sale Id 7446',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 13:28:58','',''),(7681,'1','310','1',1,'Retail Sale Id 7447',900.00,0.00,0.00,1.25,86.25,'2023-03-19 13:36:55','',''),(7682,'1','310','1',1,'Retail Sale Id 7448',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 13:38:17','',''),(7683,'1','310','1',1,'Retail Sale Id 7449',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 13:42:01','',''),(7684,'1','310','1',1,'Retail Sale Id 7450',70000.00,0.00,0.00,100.00,4900.00,'2023-03-19 13:44:49','',''),(7685,'1','310','1',1,'Retail Sale Id 7451',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 13:46:24','',''),(7686,'1','310','1',1,'Retail Sale Id 7452',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 13:54:33','',''),(7687,'1','310','1',1,'Retail Sale Id 7453',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 14:07:53','',''),(7688,'1','310','1',1,'Retail Sale Id 7454',7999.20,0.00,0.00,11.11,766.59,'2023-03-19 14:09:35','',''),(7689,'1','310','1',1,'Retail Sale Id 7455',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 14:14:07','',''),(7690,'1','310','1',1,'Retail Sale Id 7455',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 14:14:07','',''),(7691,'1','310','1',1,'Retail Sale Id 7456',6840.00,0.00,0.00,9.50,655.50,'2023-03-19 14:15:13','',''),(7692,'1','310','1',1,'Return of Retail Sale Id 7454',0.00,7999.20,11.11,0.00,-766.59,'2023-03-19 14:17:17','',''),(7693,'1','310','1',1,'Retail Sale Id 7457',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 14:25:58','',''),(7694,'1','310','1',1,'Retail Sale Id 7457',4996.80,0.00,0.00,6.94,478.86,'2023-03-19 14:25:58','',''),(7695,'1','310','1',1,'Retail Sale Id 7458',5600.00,0.00,0.00,8.00,392.00,'2023-03-19 14:27:29','',''),(7696,'1','310','1',1,'Retail Sale Id 7459',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 14:32:28','',''),(7697,'1','310','1',1,'Retail Sale Id 7460',3600.00,0.00,0.00,5.00,345.00,'2023-03-19 14:34:30','',''),(7698,'1','310','1',1,'Retail Sale Id 7461',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 14:36:11','',''),(7699,'1','310','1',1,'Retail Sale Id 7462',6998.40,0.00,0.00,9.72,670.68,'2023-03-19 14:37:48','',''),(7700,'1','310','1',1,'Retail Sale Id 7463',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 14:38:59','',''),(7701,'1','310','1',1,'Retail Sale Id 7464',5997.60,0.00,0.00,8.33,574.77,'2023-03-19 14:40:17','',''),(7702,'1','310','1',1,'Retail Sale Id 7465',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 14:41:22','',''),(7703,'1','310','1',1,'Retail Sale Id 7466',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 14:42:27','',''),(7704,'1','310','1',1,'Retail Sale Id 7467',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 14:43:19','',''),(7705,'1','310','1',1,'Retail Sale Id 7468',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 14:46:45','',''),(7706,'1','310','1',1,'Retail Sale Id 7469',2203.20,0.00,0.00,3.06,211.14,'2023-03-19 14:48:55','',''),(7707,'1','310','1',1,'Retail Sale Id 7470',4003.20,0.00,0.00,5.56,383.64,'2023-03-19 15:02:31','',''),(7708,'1','310','1',1,'Retail Sale Id 7471',70000.00,0.00,0.00,100.00,4900.00,'2023-03-19 15:06:29','',''),(7709,'1','310','1',1,'Retail Sale Id 7472',496.80,0.00,0.00,0.69,47.61,'2023-03-19 15:09:08','',''),(7710,'1','310','1',1,'Retail Sale Id 7473',3600.00,0.00,0.00,5.00,345.00,'2023-03-19 15:09:58','',''),(7711,'1','310','1',1,'Retail Sale Id 7475',2397.60,0.00,0.00,3.33,229.77,'2023-03-19 15:23:13','',''),(7712,'1','310','1',1,'Retail Sale Id 7476',2002.00,0.00,0.00,2.86,140.14,'2023-03-19 15:26:55','',''),(7713,'1','310','1',1,'Retail Sale Id 7477',2203.20,0.00,0.00,3.06,211.14,'2023-03-19 15:36:12','',''),(7714,'1','310','1',1,'Retail Sale Id 7478',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 15:37:32','',''),(7715,'1','310','1',1,'Retail Sale Id 7479',2001.60,0.00,0.00,2.78,191.82,'2023-03-19 15:38:57','',''),(7716,'1','310','1',1,'Retail Sale Id 7480',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 15:40:28','',''),(7717,'1','310','1',1,'Retail Sale Id 7481',1440.00,0.00,0.00,2.00,138.00,'2023-03-19 15:42:48','',''),(7718,'1','310','1',1,'Retail Sale Id 7482',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 15:49:21','',''),(7719,'1','310','1',1,'Retail Sale Id 7483',3002.40,0.00,0.00,4.17,287.73,'2023-03-19 15:52:10','',''),(7720,'1','310','1',1,'Retail Sale Id 7484',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 16:03:58','',''),(7721,'1','310','1',1,'Retail Sale Id 7485',5997.60,0.00,0.00,8.33,574.77,'2023-03-19 16:09:25','',''),(7722,'1','310','1',1,'Retail Sale Id 7486',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 16:13:46','',''),(7723,'1','310','1',1,'Retail Sale Id 7487',3600.00,0.00,0.00,5.00,345.00,'2023-03-19 16:14:30','',''),(7724,'1','310','1',1,'Retail Sale Id 7488',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 16:19:05','',''),(7725,'1','310','1',1,'Retail Sale Id 7489',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 16:24:42','',''),(7726,'1','310','1',1,'Retail Sale Id 7490',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 16:36:00','',''),(7727,'1','310','1',1,'Retail Sale Id 7491',3600.00,0.00,0.00,5.00,345.00,'2023-03-19 16:40:02','',''),(7728,'1','310','1',1,'Retail Sale Id 7492',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 16:41:50','',''),(7729,'1','310','1',1,'Retail Sale Id 7493',2880.00,0.00,0.00,4.00,276.00,'2023-03-19 16:43:05','',''),(7730,'1','310','1',1,'Retail Sale Id 7495',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 16:48:44','',''),(7731,'1','310','1',1,'Retail Sale Id 7496',7200.00,0.00,0.00,10.00,690.00,'2023-03-19 16:50:40','',''),(7732,'1','310','1',1,'Retail Sale Id 7497',2001.60,0.00,0.00,2.78,191.82,'2023-03-19 16:52:08','',''),(7733,'1','310','1',1,'Retail Sale Id 7499',2498.40,0.00,0.00,3.47,239.43,'2023-03-19 16:56:22','',''),(7734,'1','310','1',1,'Retail Sale Id 7500',2498.40,0.00,0.00,3.47,239.43,'2023-03-19 16:57:16','',''),(7735,'1','310','1',1,'Retail Sale Id 7501',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 16:58:19','',''),(7736,'1','310','1',1,'Retail Sale Id 7502',2001.60,0.00,0.00,2.78,191.82,'2023-03-19 16:59:35','',''),(7737,'1','310','1',1,'Retail Sale Id 7504',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 17:05:10','',''),(7738,'1','310','1',1,'Retail Sale Id 7504',3499.20,0.00,0.00,4.86,335.34,'2023-03-19 17:05:10','',''),(7739,'1','310','1',1,'Retail Sale Id 7505',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 17:06:25','',''),(7740,'1','310','1',1,'Retail Sale Id 7506',4996.80,0.00,0.00,6.94,478.86,'2023-03-19 17:09:45','',''),(7741,'1','310','1',1,'Retail Sale Id 7507',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 17:10:53','',''),(7742,'1','310','1',1,'Retail Sale Id 7508',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 17:13:56','',''),(7743,'1','310','1',1,'Retail Sale Id 7509',3600.00,0.00,0.00,5.00,345.00,'2023-03-19 17:17:03','',''),(7744,'1','310','1',1,'Retail Sale Id 7510',3600.00,0.00,0.00,5.00,345.00,'2023-03-19 17:19:45','',''),(7745,'1','310','1',1,'Retail Sale Id 7511',10080.00,0.00,0.00,14.00,966.00,'2023-03-19 17:21:33','',''),(7746,'1','310','1',1,'Retail Sale Id 7512',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 17:22:35','',''),(7747,'1','310','1',1,'Retail Sale Id 7514',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 17:23:40','',''),(7748,'1','310','1',1,'Retail Sale Id 7515',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 17:24:47','',''),(7749,'1','310','1',1,'Retail Sale Id 7516',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 17:25:53','',''),(7750,'1','310','1',1,'Retail Sale Id 7517',3600.00,0.00,0.00,5.00,345.00,'2023-03-19 17:26:59','',''),(7751,'1','310','1',1,'Retail Sale Id 7518',1497.60,0.00,0.00,2.08,143.52,'2023-03-19 17:27:51','',''),(7752,'1','310','1',1,'Retail Sale Id 7519',1447.20,0.00,0.00,2.01,138.69,'2023-03-19 17:28:32','',''),(7753,'1','310','1',1,'Retail Sale Id 7520',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 17:29:12','',''),(7754,'1','310','1',1,'Retail Sale Id 7521',3499.20,0.00,0.00,4.86,335.34,'2023-03-19 17:29:55','',''),(7755,'1','310','1',1,'Retail Sale Id 7522',3002.40,0.00,0.00,4.17,287.73,'2023-03-19 17:30:26','',''),(7756,'1','310','1',1,'Retail Sale Id 7523',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 17:31:27','',''),(7757,'1','310','1',1,'Retail Sale Id 7524',7200.00,0.00,0.00,10.00,690.00,'2023-03-19 17:32:08','',''),(7758,'1','310','1',1,'Retail Sale Id 7525',5760.00,0.00,0.00,8.00,552.00,'2023-03-19 17:32:52','',''),(7759,'1','310','1',1,'Retail Sale Id 7526',4500.00,0.00,0.00,6.25,431.25,'2023-03-19 17:33:30','',''),(7760,'1','310','1',1,'Retail Sale Id 7527',2880.00,0.00,0.00,4.00,276.00,'2023-03-19 17:34:20','',''),(7761,'1','310','1',1,'Retail Sale Id 7528',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 17:34:53','',''),(7762,'1','310','1',1,'Retail Sale Id 7529',2001.60,0.00,0.00,2.78,191.82,'2023-03-19 17:35:32','',''),(7763,'1','310','1',1,'Retail Sale Id 7530',3600.00,0.00,0.00,5.00,345.00,'2023-03-19 17:36:57','',''),(7764,'1','310','1',1,'Retail Sale Id 7530',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 17:36:57','',''),(7765,'1','310','1',1,'Retail Sale Id 7531',1497.60,0.00,0.00,2.08,143.52,'2023-03-19 17:38:21','',''),(7766,'1','310','1',1,'Retail Sale Id 7532',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 17:39:09','',''),(7767,'1','310','1',1,'Retail Sale Id 7533',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 17:39:57','',''),(7768,'1','310','1',1,'Retail Sale Id 7534',496.80,0.00,0.00,0.69,47.61,'2023-03-19 17:44:13','',''),(7769,'1','310','1',1,'Retail Sale Id 7535',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 17:45:09','',''),(7770,'1','310','1',1,'Retail Sale Id 7536',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 17:47:13','',''),(7771,'1','310','1',1,'Retail Sale Id 7538',2001.60,0.00,0.00,2.78,191.82,'2023-03-19 17:48:30','',''),(7772,'1','310','1',1,'Retail Sale Id 7538',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 17:48:30','',''),(7773,'1','310','1',1,'Retail Sale Id 7539',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 17:49:09','',''),(7774,'1','310','1',1,'Retail Sale Id 7540',1497.60,0.00,0.00,2.08,143.52,'2023-03-19 17:50:04','',''),(7775,'1','310','1',1,'Retail Sale Id 7541',4399.20,0.00,0.00,6.11,421.59,'2023-03-19 17:50:47','',''),(7776,'1','310','1',1,'Retail Sale Id 7542',1699.20,0.00,0.00,2.36,162.84,'2023-03-19 17:51:27','',''),(7777,'1','310','1',1,'Retail Sale Id 7543',1497.60,0.00,0.00,2.08,143.52,'2023-03-19 17:52:08','',''),(7778,'1','310','1',1,'Retail Sale Id 7544',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 17:54:09','',''),(7779,'1','310','1',1,'Retail Sale Id 7545',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 17:55:01','',''),(7780,'1','310','1',1,'Retail Sale Id 7546',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 17:57:18','',''),(7781,'1','310','1',1,'Retail Sale Id 7547',12168.00,0.00,0.00,16.90,1166.10,'2023-03-19 17:59:01','',''),(7782,'1','310','1',1,'Retail Sale Id 7548',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 17:59:42','',''),(7783,'1','310','1',1,'Retail Sale Id 7548',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 17:59:42','',''),(7784,'1','310','1',1,'Retail Sale Id 7549',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 18:00:53','',''),(7785,'1','310','1',1,'Retail Sale Id 7550',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 18:01:43','',''),(7786,'1','310','1',1,'Retail Sale Id 7551',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 18:02:47','',''),(7787,'1','310','1',1,'Retail Sale Id 7552',2880.00,0.00,0.00,4.00,276.00,'2023-03-19 18:04:23','',''),(7788,'1','310','1',1,'Retail Sale Id 7553',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 18:08:12','',''),(7789,'1','310','1',1,'Retail Sale Id 7554',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 18:09:00','',''),(7790,'1','310','1',1,'Retail Sale Id 7554',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 18:09:00','',''),(7791,'1','310','1',1,'Retail Sale Id 7555',3002.40,0.00,0.00,4.17,287.73,'2023-03-19 18:09:33','',''),(7792,'1','310','1',1,'Retail Sale Id 7556',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 18:12:39','',''),(7793,'1','310','1',1,'Retail Sale Id 7557',4298.40,0.00,0.00,5.97,411.93,'2023-03-19 18:18:13','',''),(7794,'1','310','1',1,'Retail Sale Id 7558',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 18:23:46','',''),(7795,'1','310','1',1,'Retail Sale Id 7558',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 18:23:46','',''),(7796,'1','310','1',1,'Retail Sale Id 7558',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 18:23:46','',''),(7797,'1','310','1',1,'Retail Sale Id 7559',1000.80,0.00,0.00,1.39,95.91,'2023-03-19 18:25:30','',''),(7798,'1','310','1',1,'Retail Sale Id 7559',1497.60,0.00,0.00,2.08,143.52,'2023-03-19 18:25:30','',''),(7799,'1','310','1',1,'Retail Sale Id 7560',2160.00,0.00,0.00,3.00,207.00,'2023-03-19 18:26:22','',''),(7800,'1','310','1',1,'Retail Sale Id 7560',4320.00,0.00,0.00,6.00,414.00,'2023-03-19 18:26:22','',''),(7801,'1','310','1',1,'Retail Sale Id 7561',2001.60,0.00,0.00,2.78,191.82,'2023-03-19 18:27:07','',''),(7802,'1','310','1',1,'Retail Sale Id 7562',2001.60,0.00,0.00,2.78,191.82,'2023-03-19 18:31:14','',''),(7803,'1','310','1',1,'Retail Sale Id 7563',9000.00,0.00,0.00,12.50,862.50,'2023-03-19 18:33:23','',''),(7804,'1','310','1',1,'Retail Sale Id 7564',4003.20,0.00,0.00,5.56,383.64,'2023-03-19 18:39:43','',''),(7805,'1','310','1',1,'Retail Sale Id 7566',12744.00,0.00,0.00,17.70,1221.30,'2023-03-19 18:55:05','',''),(7806,'1','310','1',1,'Return of Retail Sale Id 7558',0.00,4320.00,6.00,0.00,-414.00,'2023-03-19 18:56:40','',''),(7807,'1','310','1',1,'Return of Retail Sale Id 7558',0.00,4320.00,6.00,0.00,-414.00,'2023-03-19 18:56:40','',''),(7808,'1','310','1',1,'Return of Retail Sale Id 7558',0.00,4320.00,6.00,0.00,-414.00,'2023-03-19 18:56:40','',''),(7809,'1','310','1',1,'Return of Retail Sale Id 7566',0.00,12744.00,17.70,0.00,-1221.30,'2023-03-19 18:57:20','',''),(7810,'1','310','1',1,'Retail Sale Id 7567',216.00,0.00,0.00,0.30,20.70,'2023-03-19 18:57:56','',''),(7811,'1','310','1',1,'Return of Retail Sale Id 7476',0.00,2002.00,2.86,0.00,-140.14,'2023-03-19 18:59:00','',''),(7812,'1','310','1',1,'Retail Sale Id 7568',2002.00,0.00,0.00,2.86,140.14,'2023-03-19 18:59:51','',''),(7813,'1','310','1',1,'Retail Sale Id 7569',3600.00,0.00,0.00,5.00,345.00,'2023-03-20 07:10:35','',''),(7814,'1','310','1',1,'Retail Sale Id 7571',42000.00,0.00,0.00,60.00,2940.00,'2023-03-20 07:13:53','',''),(7815,'1','310','1',1,'Retail Sale Id 7572',2001.60,0.00,0.00,2.78,191.82,'2023-03-20 07:14:48','',''),(7816,'1','310','1',1,'Retail Sale Id 7574',25900.00,0.00,0.00,37.00,1813.00,'2023-03-20 07:39:37','',''),(7817,'1','310','1',1,'Retail Sale Id 7575',9000.00,0.00,0.00,12.50,862.50,'2023-03-20 07:47:35','',''),(7818,'1','310','1',1,'Retail Sale Id 7576',2203.20,0.00,0.00,3.06,211.14,'2023-03-20 07:49:15','',''),(7819,'1','310','1',1,'Retail Sale Id 7577',4003.20,0.00,0.00,5.56,383.64,'2023-03-20 08:05:41','',''),(7820,'1','310','1',1,'Retail Sale Id 7578',9000.00,0.00,0.00,12.50,862.50,'2023-03-20 08:23:20','',''),(7821,'1','310','1',1,'Retail Sale Id 7578',9000.00,0.00,0.00,12.50,862.50,'2023-03-20 08:23:20','',''),(7822,'1','310','1',1,'Retail Sale Id 7581',1000.80,0.00,0.00,1.39,95.91,'2023-03-20 08:40:50','',''),(7823,'1','310','1',1,'Retail Sale Id 7583',4320.00,0.00,0.00,6.00,414.00,'2023-03-20 08:48:09','',''),(7824,'1','310','1',1,'Retail Sale Id 7585',4996.80,0.00,0.00,6.94,478.86,'2023-03-20 08:56:37','',''),(7825,'1','310','1',1,'Retail Sale Id 7586',4320.00,0.00,0.00,6.00,414.00,'2023-03-20 09:04:45','',''),(7826,'1','310','1',1,'Retail Sale Id 7588',68495.00,0.00,0.00,97.85,4794.65,'2023-03-20 09:21:57','',''),(7827,'1','310','1',1,'Retail Sale Id 7589',9000.00,0.00,0.00,12.50,862.50,'2023-03-20 09:23:13','',''),(7828,'1','310','1',1,'Retail Sale Id 7590',4320.00,0.00,0.00,6.00,414.00,'2023-03-20 09:24:33','',''),(7829,'1','310','1',1,'Retail Sale Id 7591',1000.80,0.00,0.00,1.39,95.91,'2023-03-20 09:26:38','',''),(7830,'1','310','1',1,'Retail Sale Id 7592',2160.00,0.00,0.00,3.00,207.00,'2023-03-20 09:33:11','',''),(7831,'1','310','1',1,'Retail Sale Id 7593',10800.00,0.00,0.00,15.00,1035.00,'2023-03-20 09:42:25','',''),(7832,'1','310','1',1,'Retail Sale Id 7594',7.20,0.00,0.00,0.01,0.69,'2023-03-20 09:58:28','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'1','310',1,3860.68,'2023-03-20 09:58:28');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7821 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'1','310',1,'Retail Sale Id 1',0.00,30245.46,720.00,33451.20,3205.74,'2023-01-23 11:34:04'),(2,'1','310',1,'Retail Sale Id 2',0.00,282462.39,700.00,303723.00,21260.61,'2023-01-23 11:39:51'),(3,'1','310',1,'Retail Sale Id 3',0.00,1992.06,720.00,2203.20,211.14,'2023-01-23 11:47:17'),(4,'1','310',1,'Retail Sale Id 3',0.00,61454.40,720.00,67968.00,6513.60,'2023-01-23 11:47:17'),(5,'1','310',1,'Retail Sale Id 3',0.00,96302.43,720.00,106509.60,10207.17,'2023-01-23 11:47:17'),(6,'1','310',1,'Retail Sale Id 4',0.00,369117.00,700.00,396900.00,27783.00,'2023-01-23 11:50:02'),(7,'1','310',1,'Retail Sale Id 5',0.00,65002.35,720.00,71892.00,6889.65,'2023-01-23 11:55:29'),(8,'1','310',1,'Retail Sale Id 5',0.00,149808.12,720.00,165686.40,15878.28,'2023-01-23 11:55:29'),(9,'1','310',1,'Retail Sale Id 6',0.00,403157.79,700.00,433503.00,30345.21,'2023-01-23 11:56:50'),(10,'1','310',1,'Retail Sale Id 8',0.00,344671.95,720.00,381204.00,36532.05,'2023-01-23 11:59:57'),(11,'1','310',1,'Retail Sale Id 9',0.00,807565.50,700.00,868350.00,60784.50,'2023-01-23 12:01:28'),(12,'1','310',1,'Retail Sale Id 10',0.00,1809.78,720.00,2001.60,191.82,'2023-01-23 12:12:33'),(13,'1','310',1,'Retail Sale Id 11',0.00,1809.78,720.00,2001.60,191.82,'2023-01-23 12:14:06'),(14,'1','310',1,'Retail Sale Id 12',0.00,904.89,720.00,1000.80,95.91,'2023-01-23 12:17:21'),(15,'1','310',1,'Retail Sale Id 13',0.00,65100.00,700.00,70000.00,4900.00,'2023-01-23 12:27:09'),(16,'1','310',1,'Retail Sale Id 14',0.00,1953.00,720.00,2160.00,207.00,'2023-01-23 12:37:51'),(17,'1','310',1,'Retail Sale Id 15',0.00,722.61,720.00,799.20,76.59,'2023-01-23 12:44:10'),(18,'1','310',1,'Retail Sale Id 16',0.00,32550.00,700.00,35000.00,2450.00,'2023-01-23 12:56:38'),(19,'1','310',1,'Retail Sale Id 17',0.00,3977.61,720.00,4399.20,421.59,'2023-01-23 12:58:06'),(20,'1','310',1,'Retail Sale Id 18',0.00,32550.00,700.00,35000.00,2450.00,'2023-01-23 12:59:39'),(21,'1','310',1,'Retail Sale Id 19',0.00,8463.00,700.00,9100.00,637.00,'2023-01-23 13:11:45'),(22,'1','310',1,'Retail Sale Id 20',0.00,3255.00,720.00,3600.00,345.00,'2023-01-23 13:18:56'),(23,'1','310',1,'Retail Sale Id 20',0.00,3977.61,720.00,4399.20,421.59,'2023-01-23 13:18:56'),(24,'1','310',1,'Retail Sale Id 21',0.00,1809.78,720.00,2001.60,191.82,'2023-01-23 13:35:31'),(25,'1','310',1,'Retail Sale Id 22',0.00,4068.75,720.00,4500.00,431.25,'2023-01-23 13:36:29'),(26,'1','310',1,'Retail Sale Id 23',0.00,904.89,720.00,1000.80,95.91,'2023-01-23 13:37:53'),(27,'1','310',1,'Retail Sale Id 24',0.00,8137.50,720.00,9000.00,862.50,'2023-01-23 13:45:38'),(28,'1','310',1,'Retail Sale Id 25',0.00,3977.61,720.00,4399.20,421.59,'2023-01-23 14:01:54'),(29,'1','310',1,'Retail Sale Id 26',0.00,904.89,720.00,1000.80,95.91,'2023-01-23 14:05:51'),(30,'1','310',1,'Retail Sale Id 27',0.00,904.89,720.00,1000.80,95.91,'2023-01-23 14:13:46'),(31,'1','310',1,'Retail Sale Id 28',0.00,3977.61,720.00,4399.20,421.59,'2023-01-23 14:20:37'),(32,'1','310',1,'Retail Sale Id 29',0.00,3977.61,720.00,4399.20,421.59,'2023-01-23 14:31:40'),(33,'1','310',1,'Retail Sale Id 30',0.00,8137.50,720.00,9000.00,862.50,'2023-01-23 14:40:14'),(34,'1','310',1,'Retail Sale Id 31',0.00,1992.06,720.00,2203.20,211.14,'2023-01-23 15:33:24'),(35,'1','310',1,'Retail Sale Id 32',0.00,1809.78,720.00,2001.60,191.82,'2023-01-23 15:36:53'),(36,'1','310',1,'Retail Sale Id 33',0.00,3346.14,720.00,3700.80,354.66,'2023-01-23 15:40:03'),(37,'1','310',1,'Retail Sale Id 34',0.00,1992.06,720.00,2203.20,211.14,'2023-01-23 15:40:52'),(38,'1','310',1,'Retail Sale Id 35',0.00,1992.06,720.00,2203.20,211.14,'2023-01-23 15:55:36'),(39,'1','310',1,'Retail Sale Id 36',0.00,904.89,720.00,1000.80,95.91,'2023-01-23 16:08:50'),(40,'1','310',1,'Retail Sale Id 37',0.00,3906.00,720.00,4320.00,414.00,'2023-01-23 16:17:46'),(41,'1','310',1,'Retail Sale Id 38',0.00,3255.00,720.00,3600.00,345.00,'2023-01-23 16:23:19'),(42,'1','310',1,'Retail Sale Id 39',0.00,904.89,720.00,1000.80,95.91,'2023-01-23 16:24:47'),(43,'1','310',1,'Retail Sale Id 40',0.00,2714.67,720.00,3002.40,287.73,'2023-01-23 16:50:39'),(44,'1','310',1,'Retail Sale Id 41',0.00,1992.06,720.00,2203.20,211.14,'2023-01-23 16:58:57'),(45,'1','310',1,'Retail Sale Id 42',0.00,1087.17,720.00,1202.40,115.23,'2023-01-23 17:00:59'),(46,'1','310',1,'Retail Sale Id 43',0.00,1354.08,720.00,1497.60,143.52,'2023-01-23 17:02:45'),(47,'1','310',1,'Retail Sale Id 47',0.00,3619.56,720.00,4003.20,383.64,'2023-01-23 17:09:33'),(48,'1','310',1,'Retail Sale Id 49',0.00,3619.56,720.00,4003.20,383.64,'2023-01-23 17:12:08'),(49,'1','310',1,'Retail Sale Id 50',0.00,3619.56,720.00,4003.20,383.64,'2023-01-23 17:12:51'),(50,'1','310',1,'Retail Sale Id 51',0.00,3619.56,720.00,4003.20,383.64,'2023-01-23 17:13:51'),(51,'1','310',1,'Retail Sale Id 52',0.00,32550.00,700.00,35000.00,2450.00,'2023-01-23 17:15:39'),(52,'1','310',1,'Retail Sale Id 53',0.00,8137.50,700.00,8750.00,612.50,'2023-01-23 17:36:45'),(53,'1','310',1,'Retail Sale Id 54',0.00,3977.61,720.00,4399.20,421.59,'2023-01-23 17:38:47'),(54,'1','310',1,'Retail Sale Id 55',0.00,1354.08,720.00,1497.60,143.52,'2023-01-23 17:41:32'),(55,'1','310',1,'Retail Sale Id 56',0.00,1809.78,720.00,2001.60,191.82,'2023-01-23 17:44:25'),(56,'1','310',1,'Retail Sale Id 56',0.00,3619.56,720.00,4003.20,383.64,'2023-01-23 17:44:26'),(57,'1','310',1,'Retail Sale Id 57',0.00,2714.67,720.00,3002.40,287.73,'2023-01-23 17:54:17'),(58,'1','310',1,'Retail Sale Id 58',0.00,996.03,720.00,1101.60,105.57,'2023-01-23 17:59:18'),(59,'1','310',1,'Retail Sale Id 59',0.00,904.89,720.00,1000.80,95.91,'2023-01-23 18:02:34'),(60,'1','310',1,'Retail Sale Id 60',0.00,8137.50,720.00,9000.00,862.50,'2023-01-23 18:11:06'),(61,'1','310',1,'Retail Sale Id 61',0.00,1992.06,720.00,2203.20,211.14,'2023-01-23 18:12:32'),(62,'1','310',1,'Retail Sale Id 62',0.00,3977.61,720.00,4399.20,421.59,'2023-01-23 18:14:54'),(63,'1','310',1,'Retail Sale Id 63',0.00,1809.78,720.00,2001.60,191.82,'2023-01-23 18:23:19'),(64,'1','310',1,'Retail Sale Id 63',0.00,2714.67,720.00,3002.40,287.73,'2023-01-23 18:23:19'),(65,'1','310',1,'Retail Sale Id 64',0.00,1354.08,720.00,1497.60,143.52,'2023-01-23 18:24:45'),(66,'1','310',1,'Retail Sale Id 65',0.00,2258.97,720.00,2498.40,239.43,'2023-01-23 18:27:38'),(67,'1','310',1,'Retail Sale Id 66',0.00,3255.00,720.00,3600.00,345.00,'2023-01-23 18:30:57'),(68,'1','310',1,'Retail Sale Id 67',0.00,1809.78,720.00,2001.60,191.82,'2023-01-23 18:43:31'),(69,'1','310',1,'Retail Sale Id 68',0.00,116971.68,720.00,129369.60,12397.92,'2023-01-23 19:16:03'),(70,'1','310',1,'Retail Sale Id 69',0.00,154612.50,700.00,166250.00,11637.50,'2023-01-23 19:18:15'),(71,'1','310',1,'Return of Retail Sale Id 68',116971.68,0.00,720.00,-129369.60,-12397.92,'2023-01-23 19:19:47'),(72,'1','310',1,'Retail Sale Id 70',0.00,87767.82,720.00,97070.40,9302.58,'2023-01-23 19:20:27'),(73,'1','310',1,'Retail Sale Id 71',0.00,904.89,720.00,1000.80,95.91,'2023-01-24 07:59:41'),(74,'1','310',1,'Retail Sale Id 72',0.00,8137.50,720.00,9000.00,862.50,'2023-01-24 08:12:48'),(75,'1','310',1,'Retail Sale Id 73',0.00,449.19,720.00,496.80,47.61,'2023-01-24 08:26:10'),(76,'1','310',1,'Retail Sale Id 74',0.00,9765.00,700.00,10500.00,735.00,'2023-01-24 08:37:12'),(77,'1','310',1,'Retail Sale Id 75',0.00,1809.78,720.00,2001.60,191.82,'2023-01-24 08:42:25'),(78,'1','310',1,'Retail Sale Id 76',0.00,78120.00,700.00,84000.00,5880.00,'2023-01-24 08:45:01'),(79,'1','310',1,'Retail Sale Id 77',0.00,2167.83,720.00,2397.60,229.77,'2023-01-24 08:46:57'),(80,'1','310',1,'Retail Sale Id 78',0.00,1809.78,720.00,2001.60,191.82,'2023-01-24 08:48:06'),(81,'1','310',1,'Retail Sale Id 79',0.00,8137.50,720.00,9000.00,862.50,'2023-01-24 08:51:10'),(82,'1','310',1,'Retail Sale Id 80',0.00,8137.50,720.00,9000.00,862.50,'2023-01-24 08:53:24'),(83,'1','310',1,'Retail Sale Id 81',0.00,1354.08,720.00,1497.60,143.52,'2023-01-24 08:55:47'),(84,'1','310',1,'Retail Sale Id 82',0.00,24087.00,700.00,25900.00,1813.00,'2023-01-24 09:23:08'),(85,'1','310',1,'Retail Sale Id 83',0.00,4068.75,720.00,4500.00,431.25,'2023-01-24 09:24:23'),(86,'1','310',1,'Retail Sale Id 84',0.00,3977.61,720.00,4399.20,421.59,'2023-01-24 09:31:12'),(87,'1','310',1,'Retail Sale Id 85',0.00,1809.78,720.00,2001.60,191.82,'2023-01-24 09:33:09'),(88,'1','310',1,'Retail Sale Id 86',0.00,1992.06,720.00,2203.20,211.14,'2023-01-24 09:40:09'),(89,'1','310',1,'Retail Sale Id 86',0.00,3977.61,720.00,4399.20,421.59,'2023-01-24 09:40:09'),(90,'1','310',1,'Retail Sale Id 86',0.00,3977.61,720.00,4399.20,421.59,'2023-01-24 09:40:09'),(91,'1','310',1,'Retail Sale Id 87',0.00,4517.94,720.00,4996.80,478.86,'2023-01-24 09:44:52'),(92,'1','310',1,'Retail Sale Id 88',0.00,904.89,720.00,1000.80,95.91,'2023-01-24 09:53:59'),(93,'1','310',1,'Retail Sale Id 89',0.00,8137.50,720.00,9000.00,862.50,'2023-01-24 10:06:27'),(94,'1','310',1,'Retail Sale Id 90',0.00,4517.94,720.00,4996.80,478.86,'2023-01-24 10:08:05'),(95,'1','310',1,'Retail Sale Id 91',0.00,8137.50,720.00,9000.00,862.50,'2023-01-24 10:16:51'),(96,'1','310',1,'Retail Sale Id 92',0.00,1809.78,720.00,2001.60,191.82,'2023-01-24 10:18:24'),(97,'1','310',1,'Retail Sale Id 93',0.00,1809.78,720.00,2001.60,191.82,'2023-01-24 10:29:12'),(98,'1','310',1,'Retail Sale Id 94',0.00,1445.22,720.00,1598.40,153.18,'2023-01-24 10:30:30'),(99,'1','310',1,'Retail Sale Id 95',0.00,1354.08,720.00,1497.60,143.52,'2023-01-24 10:39:38'),(100,'1','310',1,'Retail Sale Id 96',0.00,3906.00,720.00,4320.00,414.00,'2023-01-24 10:40:50'),(101,'1','310',1,'Retail Sale Id 97',0.00,8137.50,720.00,9000.00,862.50,'2023-01-24 10:45:09'),(102,'1','310',1,'Retail Sale Id 98',0.00,904.89,720.00,1000.80,95.91,'2023-01-24 10:54:48'),(103,'1','310',1,'Retail Sale Id 99',0.00,1953.00,720.00,2160.00,207.00,'2023-01-24 10:57:40'),(104,'1','310',1,'Retail Sale Id 100',0.00,4517.94,720.00,4996.80,478.86,'2023-01-24 11:05:12'),(105,'1','310',1,'Retail Sale Id 101',0.00,292950.00,700.00,315000.00,22050.00,'2023-01-24 11:57:55'),(106,'1','310',1,'Retail Sale Id 102',0.00,8137.50,720.00,9000.00,862.50,'2023-01-24 12:09:35'),(107,'1','310',1,'Retail Sale Id 103',0.00,1354.08,720.00,1497.60,143.52,'2023-01-24 12:19:16'),(108,'1','310',1,'Retail Sale Id 104',0.00,3619.56,720.00,4003.20,383.64,'2023-01-24 12:48:41'),(109,'1','310',1,'Retail Sale Id 106',0.00,1809.78,720.00,2001.60,191.82,'2023-01-24 12:54:50'),(110,'1','310',1,'Retail Sale Id 107',0.00,2714.67,720.00,3002.40,287.73,'2023-01-24 12:56:12'),(111,'1','310',1,'Retail Sale Id 108',0.00,1992.06,720.00,2203.20,211.14,'2023-01-24 13:30:30'),(112,'1','310',1,'Retail Sale Id 109',0.00,65100.00,700.00,70000.00,4900.00,'2023-01-24 13:34:36'),(113,'1','310',1,'Retail Sale Id 110',0.00,904.89,720.00,1000.80,95.91,'2023-01-24 14:31:22'),(114,'1','310',1,'Retail Sale Id 111',0.00,364.56,720.00,403.20,38.64,'2023-01-24 15:02:15'),(115,'1','310',1,'Retail Sale Id 112',0.00,138012.00,700.00,148400.00,10388.00,'2023-01-24 15:21:32'),(116,'1','310',1,'Retail Sale Id 113',0.00,1992.06,720.00,2203.20,211.14,'2023-01-24 15:22:33'),(117,'1','310',1,'Retail Sale Id 114',0.00,3977.61,720.00,4399.20,421.59,'2023-01-24 15:28:30'),(118,'1','310',1,'Retail Sale Id 115',0.00,1809.78,720.00,2001.60,191.82,'2023-01-24 15:37:02'),(119,'1','310',1,'Retail Sale Id 116',0.00,1809.78,720.00,2001.60,191.82,'2023-01-24 16:26:03'),(120,'1','310',1,'Retail Sale Id 117',0.00,2714.67,720.00,3002.40,287.73,'2023-01-24 16:27:01'),(121,'1','310',1,'Retail Sale Id 118',0.00,2714.67,720.00,3002.40,287.73,'2023-01-24 16:49:57'),(122,'1','310',1,'Retail Sale Id 119',0.00,1992.06,720.00,2203.20,211.14,'2023-01-24 16:55:13'),(123,'1','310',1,'Retail Sale Id 120',0.00,904.89,720.00,1000.80,95.91,'2023-01-24 16:56:17'),(124,'1','310',1,'Retail Sale Id 121',0.00,8137.50,720.00,9000.00,862.50,'2023-01-24 16:58:03'),(125,'1','310',1,'Retail Sale Id 122',0.00,9765.00,720.00,10800.00,1035.00,'2023-01-24 17:01:57'),(126,'1','310',1,'Retail Sale Id 123',0.00,904.89,720.00,1000.80,95.91,'2023-01-24 17:03:18'),(127,'1','310',1,'Retail Sale Id 124',0.00,8137.50,720.00,9000.00,862.50,'2023-01-24 17:05:59'),(128,'1','310',1,'Retail Sale Id 125',0.00,1992.06,720.00,2203.20,211.14,'2023-01-24 17:22:21'),(129,'1','310',1,'Retail Sale Id 126',0.00,904.89,720.00,1000.80,95.91,'2023-01-24 17:27:18'),(130,'1','310',1,'Retail Sale Id 127',0.00,1809.78,720.00,2001.60,191.82,'2023-01-24 17:28:56'),(131,'1','310',1,'Retail Sale Id 128',0.00,3906.00,720.00,4320.00,414.00,'2023-01-24 17:35:19'),(132,'1','310',1,'Retail Sale Id 129',0.00,4517.94,720.00,4996.80,478.86,'2023-01-24 17:37:41'),(133,'1','310',1,'Retail Sale Id 129',0.00,4517.94,720.00,4996.80,478.86,'2023-01-24 17:37:41'),(134,'1','310',1,'Retail Sale Id 130',0.00,3255.00,720.00,3600.00,345.00,'2023-01-24 17:41:23'),(135,'1','310',1,'Retail Sale Id 131',0.00,3906.00,720.00,4320.00,414.00,'2023-01-24 17:45:16'),(136,'1','310',1,'Retail Sale Id 132',0.00,1992.06,720.00,2203.20,211.14,'2023-01-24 17:53:54'),(137,'1','310',1,'Retail Sale Id 133',0.00,3906.00,720.00,4320.00,414.00,'2023-01-24 17:56:26'),(138,'1','310',1,'Retail Sale Id 134',0.00,904.89,720.00,1000.80,95.91,'2023-01-24 18:09:01'),(139,'1','310',1,'Retail Sale Id 135',0.00,8371.86,700.00,9002.00,630.14,'2023-01-24 18:11:49'),(140,'1','310',1,'Retail Sale Id 136',0.00,8137.50,720.00,9000.00,862.50,'2023-01-24 18:14:21'),(141,'1','310',1,'Retail Sale Id 136',0.00,8137.50,720.00,9000.00,862.50,'2023-01-24 18:14:21'),(142,'1','310',1,'Retail Sale Id 137',0.00,449.19,720.00,496.80,47.61,'2023-01-24 18:20:35'),(143,'1','310',1,'Retail Sale Id 138',0.00,46845.96,720.00,51811.20,4965.24,'2023-01-24 19:25:08'),(144,'1','310',1,'Return of Retail Sale Id 74',9765.00,0.00,700.00,-10500.00,-735.00,'2023-01-24 19:26:54'),(145,'1','310',1,'Retail Sale Id 139',0.00,950.46,700.00,1022.00,71.54,'2023-01-24 19:28:10'),(146,'1','310',1,'Retail Sale Id 140',0.00,1354.08,720.00,1497.60,143.52,'2023-01-25 07:25:11'),(147,'1','310',1,'Retail Sale Id 141',0.00,74865.00,700.00,80500.00,5635.00,'2023-01-25 07:28:51'),(148,'1','310',1,'Retail Sale Id 142',0.00,1354.08,720.00,1497.60,143.52,'2023-01-25 08:31:19'),(149,'1','310',1,'Retail Sale Id 143',0.00,3619.56,720.00,4003.20,383.64,'2023-01-25 08:32:17'),(150,'1','310',1,'Retail Sale Id 144',0.00,3255.00,720.00,3600.00,345.00,'2023-01-25 08:36:45'),(151,'1','310',1,'Retail Sale Id 145',0.00,2714.67,720.00,3002.40,287.73,'2023-01-25 09:06:56'),(152,'1','310',1,'Retail Sale Id 146',0.00,904.89,720.00,1000.80,95.91,'2023-01-25 09:12:38'),(153,'1','310',1,'Retail Sale Id 147',0.00,4517.94,720.00,4996.80,478.86,'2023-01-25 09:15:24'),(154,'1','310',1,'Retail Sale Id 148',0.00,904.89,720.00,1000.80,95.91,'2023-01-25 09:16:10'),(155,'1','310',1,'Retail Sale Id 151',0.00,1992.06,720.00,2203.20,211.14,'2023-01-25 09:33:50'),(156,'1','310',1,'Retail Sale Id 152',0.00,3906.00,720.00,4320.00,414.00,'2023-01-25 09:36:14'),(157,'1','310',1,'Retail Sale Id 153',0.00,3255.00,720.00,3600.00,345.00,'2023-01-25 10:00:39'),(158,'1','310',1,'Retail Sale Id 154',0.00,3906.00,720.00,4320.00,414.00,'2023-01-25 10:01:36'),(159,'1','310',1,'Retail Sale Id 155',0.00,9042.39,720.00,10000.80,958.41,'2023-01-25 10:02:32'),(160,'1','310',1,'Retail Sale Id 156',0.00,1953.00,720.00,2160.00,207.00,'2023-01-25 10:03:40'),(161,'1','310',1,'Retail Sale Id 157',0.00,1809.78,720.00,2001.60,191.82,'2023-01-25 10:04:35'),(162,'1','310',1,'Retail Sale Id 157',0.00,1809.78,720.00,2001.60,191.82,'2023-01-25 10:04:35'),(163,'1','310',1,'Retail Sale Id 158',0.00,1992.06,720.00,2203.20,211.14,'2023-01-25 10:07:53'),(164,'1','310',1,'Retail Sale Id 159',0.00,1992.06,720.00,2203.20,211.14,'2023-01-25 10:19:20'),(165,'1','310',1,'Retail Sale Id 161',0.00,904.89,720.00,1000.80,95.91,'2023-01-25 10:33:14'),(166,'1','310',1,'Retail Sale Id 168',0.00,42315.00,700.00,45500.00,3185.00,'2023-01-25 10:48:18'),(167,'1','310',1,'Retail Sale Id 169',0.00,3619.56,720.00,4003.20,383.64,'2023-01-25 10:52:04'),(168,'1','310',1,'Retail Sale Id 170',0.00,2805.81,720.00,3103.20,297.39,'2023-01-25 11:00:27'),(169,'1','310',1,'Retail Sale Id 171',0.00,65100.00,700.00,70000.00,4900.00,'2023-01-25 11:01:30'),(170,'1','310',1,'Retail Sale Id 172',0.00,3886.47,720.00,4298.40,411.93,'2023-01-25 11:03:17'),(171,'1','310',1,'Retail Sale Id 173',0.00,3886.47,720.00,4298.40,411.93,'2023-01-25 11:04:52'),(172,'1','310',1,'Retail Sale Id 174',0.00,1809.78,720.00,2001.60,191.82,'2023-01-25 11:05:34'),(173,'1','310',1,'Retail Sale Id 175',0.00,1354.08,720.00,1497.60,143.52,'2023-01-25 11:07:07'),(174,'1','310',1,'Retail Sale Id 176',0.00,3977.61,720.00,4399.20,421.59,'2023-01-25 11:09:05'),(175,'1','310',1,'Retail Sale Id 176',0.00,8137.50,720.00,9000.00,862.50,'2023-01-25 11:09:05'),(176,'1','310',1,'Retail Sale Id 177',0.00,3977.61,720.00,4399.20,421.59,'2023-01-25 11:09:51'),(177,'1','310',1,'Retail Sale Id 178',0.00,3619.56,720.00,4003.20,383.64,'2023-01-25 11:10:26'),(178,'1','310',1,'Retail Sale Id 179',0.00,904.89,720.00,1000.80,95.91,'2023-01-25 11:11:00'),(179,'1','310',1,'Retail Sale Id 180',0.00,3255.00,720.00,3600.00,345.00,'2023-01-25 11:11:36'),(180,'1','310',1,'Retail Sale Id 181',0.00,6510.00,720.00,7200.00,690.00,'2023-01-25 11:12:16'),(181,'1','310',1,'Retail Sale Id 182',0.00,3163.86,720.00,3499.20,335.34,'2023-01-25 11:13:01'),(182,'1','310',1,'Retail Sale Id 183',0.00,3977.61,720.00,4399.20,421.59,'2023-01-25 11:13:48'),(183,'1','310',1,'Retail Sale Id 184',0.00,2604.00,720.00,2880.00,276.00,'2023-01-25 11:16:12'),(184,'1','310',1,'Retail Sale Id 185',0.00,1354.08,720.00,1497.60,143.52,'2023-01-25 11:22:21'),(185,'1','310',1,'Retail Sale Id 185',0.00,1354.08,720.00,1497.60,143.52,'2023-01-25 11:22:21'),(186,'1','310',1,'Retail Sale Id 186',0.00,6510.00,720.00,7200.00,690.00,'2023-01-25 11:24:29'),(187,'1','310',1,'Retail Sale Id 187',0.00,904.89,720.00,1000.80,95.91,'2023-01-25 11:25:57'),(188,'1','310',1,'Retail Sale Id 188',0.00,1627.50,720.00,1800.00,172.50,'2023-01-25 11:26:51'),(189,'1','310',1,'Retail Sale Id 189',0.00,55335.00,700.00,59500.00,4165.00,'2023-01-25 11:34:38'),(190,'1','310',1,'Retail Sale Id 190',0.00,904.89,720.00,1000.80,95.91,'2023-01-25 11:50:34'),(191,'1','310',1,'Retail Sale Id 191',0.00,904.89,720.00,1000.80,95.91,'2023-01-25 11:51:25'),(192,'1','310',1,'Retail Sale Id 192',0.00,81375.00,700.00,87500.00,6125.00,'2023-01-25 11:53:41'),(193,'1','310',1,'Retail Sale Id 193',0.00,8137.50,720.00,9000.00,862.50,'2023-01-25 11:58:41'),(194,'1','310',1,'Retail Sale Id 194',0.00,78120.00,700.00,84000.00,5880.00,'2023-01-25 11:59:31'),(195,'1','310',1,'Retail Sale Id 195',0.00,8137.50,720.00,9000.00,862.50,'2023-01-25 12:05:44'),(196,'1','310',1,'Retail Sale Id 196',0.00,8410.92,720.00,9302.40,891.48,'2023-01-25 12:11:18'),(197,'1','310',1,'Retail Sale Id 197',0.00,3977.61,720.00,4399.20,421.59,'2023-01-25 12:22:08'),(198,'1','310',1,'Retail Sale Id 197',0.00,8137.50,720.00,9000.00,862.50,'2023-01-25 12:22:08'),(199,'1','310',1,'Retail Sale Id 198',0.00,1809.78,720.00,2001.60,191.82,'2023-01-25 12:30:05'),(200,'1','310',1,'Retail Sale Id 199',0.00,1992.06,720.00,2203.20,211.14,'2023-01-25 12:40:51'),(201,'1','310',1,'Retail Sale Id 200',0.00,2532.39,720.00,2800.80,268.41,'2023-01-25 12:54:00'),(202,'1','310',1,'Retail Sale Id 201',0.00,3163.86,720.00,3499.20,335.34,'2023-01-25 13:07:22'),(203,'1','310',1,'Retail Sale Id 202',0.00,6327.72,720.00,6998.40,670.68,'2023-01-25 13:13:01'),(204,'1','310',1,'Retail Sale Id 203',0.00,1953.00,720.00,2160.00,207.00,'2023-01-25 13:14:16'),(205,'1','310',1,'Retail Sale Id 204',0.00,3906.00,720.00,4320.00,414.00,'2023-01-25 13:25:12'),(206,'1','310',1,'Retail Sale Id 205',0.00,1809.78,720.00,2001.60,191.82,'2023-01-25 13:35:38'),(207,'1','310',1,'Retail Sale Id 206',0.00,1953.00,720.00,2160.00,207.00,'2023-01-25 13:36:40'),(208,'1','310',1,'Retail Sale Id 208',0.00,1953.00,720.00,2160.00,207.00,'2023-01-25 13:45:11'),(209,'1','310',1,'Retail Sale Id 209',0.00,3906.00,720.00,4320.00,414.00,'2023-01-25 13:46:01'),(210,'1','310',1,'Retail Sale Id 210',0.00,1992.06,720.00,2203.20,211.14,'2023-01-25 13:48:59'),(211,'1','310',1,'Retail Sale Id 211',0.00,8137.50,720.00,9000.00,862.50,'2023-01-25 13:54:29'),(212,'1','310',1,'Retail Sale Id 212',0.00,16275.00,720.00,18000.00,1725.00,'2023-01-25 14:13:30'),(213,'1','310',1,'Retail Sale Id 213',0.00,8137.50,720.00,9000.00,862.50,'2023-01-25 14:14:27'),(214,'1','310',1,'Retail Sale Id 214',0.00,3906.00,720.00,4320.00,414.00,'2023-01-25 14:15:58'),(215,'1','310',1,'Retail Sale Id 215',0.00,722.61,720.00,799.20,76.59,'2023-01-25 14:17:45'),(216,'1','310',1,'Retail Sale Id 216',0.00,904.89,720.00,1000.80,95.91,'2023-01-25 14:20:54'),(217,'1','310',1,'Retail Sale Id 217',0.00,3977.61,720.00,4399.20,421.59,'2023-01-25 14:29:15'),(218,'1','310',1,'Retail Sale Id 217',0.00,8137.50,720.00,9000.00,862.50,'2023-01-25 14:29:15'),(219,'1','310',1,'Retail Sale Id 218',0.00,3906.00,720.00,4320.00,414.00,'2023-01-25 14:33:27'),(220,'1','310',1,'Retail Sale Id 218',0.00,5859.00,720.00,6480.00,621.00,'2023-01-25 14:33:27'),(221,'1','310',1,'Retail Sale Id 219',0.00,904.89,720.00,1000.80,95.91,'2023-01-25 14:34:27'),(222,'1','310',1,'Retail Sale Id 220',0.00,722.61,720.00,799.20,76.59,'2023-01-25 14:41:22'),(223,'1','310',1,'Retail Sale Id 221',0.00,3255.00,720.00,3600.00,345.00,'2023-01-25 14:53:47'),(224,'1','310',1,'Retail Sale Id 222',0.00,722.61,720.00,799.20,76.59,'2023-01-25 15:01:36'),(225,'1','310',1,'Retail Sale Id 223',0.00,904.89,720.00,1000.80,95.91,'2023-01-25 15:02:22'),(226,'1','310',1,'Retail Sale Id 224',0.00,6510.00,720.00,7200.00,690.00,'2023-01-25 15:14:34'),(227,'1','310',1,'Retail Sale Id 225',0.00,3619.56,720.00,4003.20,383.64,'2023-01-25 15:15:31'),(228,'1','310',1,'Retail Sale Id 226',0.00,904.89,720.00,1000.80,95.91,'2023-01-25 15:17:48'),(229,'1','310',1,'Retail Sale Id 227',0.00,3906.00,720.00,4320.00,414.00,'2023-01-25 15:20:18'),(230,'1','310',1,'Retail Sale Id 228',0.00,8137.50,720.00,9000.00,862.50,'2023-01-25 15:23:06'),(231,'1','310',1,'Retail Sale Id 229',0.00,1953.00,720.00,2160.00,207.00,'2023-01-25 15:53:09'),(232,'1','310',1,'Retail Sale Id 229',0.00,8137.50,720.00,9000.00,862.50,'2023-01-25 15:53:09'),(233,'1','310',1,'Retail Sale Id 230',0.00,1809.78,720.00,2001.60,191.82,'2023-01-25 15:53:51'),(234,'1','310',1,'Retail Sale Id 231',0.00,4517.94,720.00,4996.80,478.86,'2023-01-25 15:54:34'),(235,'1','310',1,'Retail Sale Id 232',0.00,1354.08,720.00,1497.60,143.52,'2023-01-25 15:55:21'),(236,'1','310',1,'Retail Sale Id 232',0.00,1354.08,720.00,1497.60,143.52,'2023-01-25 15:55:21'),(237,'1','310',1,'Retail Sale Id 233',0.00,1953.00,720.00,2160.00,207.00,'2023-01-25 15:56:03'),(238,'1','310',1,'Retail Sale Id 234',0.00,8137.50,720.00,9000.00,862.50,'2023-01-25 15:56:37'),(239,'1','310',1,'Retail Sale Id 236',0.00,1354.08,720.00,1497.60,143.52,'2023-01-25 16:01:09'),(240,'1','310',1,'Retail Sale Id 237',0.00,65100.00,700.00,70000.00,4900.00,'2023-01-25 16:02:44'),(241,'1','310',1,'Retail Sale Id 238',0.00,904.89,720.00,1000.80,95.91,'2023-01-25 16:20:31'),(242,'1','310',1,'Retail Sale Id 239',0.00,1953.00,720.00,2160.00,207.00,'2023-01-25 16:23:06'),(243,'1','310',1,'Retail Sale Id 240',0.00,6510.00,720.00,7200.00,690.00,'2023-01-25 16:25:01'),(244,'1','310',1,'Retail Sale Id 241',0.00,3906.00,720.00,4320.00,414.00,'2023-01-25 16:27:13'),(245,'1','310',1,'Retail Sale Id 241',0.00,3906.00,720.00,4320.00,414.00,'2023-01-25 16:27:13'),(246,'1','310',1,'Retail Sale Id 242',0.00,1992.06,720.00,2203.20,211.14,'2023-01-25 16:35:39'),(247,'1','310',1,'Retail Sale Id 243',0.00,631.47,720.00,698.40,66.93,'2023-01-25 16:37:45'),(248,'1','310',1,'Retail Sale Id 244',0.00,904.89,720.00,1000.80,95.91,'2023-01-25 16:54:01'),(249,'1','310',1,'Retail Sale Id 245',0.00,3906.00,720.00,4320.00,414.00,'2023-01-25 16:55:18'),(250,'1','310',1,'Retail Sale Id 246',0.00,904.89,720.00,1000.80,95.91,'2023-01-25 17:00:40'),(251,'1','310',1,'Retail Sale Id 247',0.00,3255.00,720.00,3600.00,345.00,'2023-01-25 17:02:06'),(252,'1','310',1,'Retail Sale Id 248',0.00,1809.78,720.00,2001.60,191.82,'2023-01-25 17:10:42'),(253,'1','310',1,'Retail Sale Id 248',0.00,8137.50,720.00,9000.00,862.50,'2023-01-25 17:10:42'),(254,'1','310',1,'Retail Sale Id 249',0.00,1809.78,720.00,2001.60,191.82,'2023-01-25 17:11:44'),(255,'1','310',1,'Retail Sale Id 250',0.00,8137.50,720.00,9000.00,862.50,'2023-01-25 17:12:34'),(256,'1','310',1,'Retail Sale Id 251',0.00,1354.08,720.00,1497.60,143.52,'2023-01-25 17:14:58'),(257,'1','310',1,'Retail Sale Id 252',0.00,3906.00,720.00,4320.00,414.00,'2023-01-25 17:22:25'),(258,'1','310',1,'Retail Sale Id 253',0.00,3906.00,720.00,4320.00,414.00,'2023-01-25 17:28:49'),(259,'1','310',1,'Retail Sale Id 254',0.00,3163.86,720.00,3499.20,335.34,'2023-01-25 17:35:08'),(260,'1','310',1,'Retail Sale Id 255',0.00,2258.97,720.00,2498.40,239.43,'2023-01-25 17:36:08'),(261,'1','310',1,'Retail Sale Id 256',0.00,2714.67,720.00,3002.40,287.73,'2023-01-25 17:37:13'),(262,'1','310',1,'Retail Sale Id 257',0.00,904.89,720.00,1000.80,95.91,'2023-01-25 17:40:14'),(263,'1','310',1,'Retail Sale Id 257',0.00,1992.06,720.00,2203.20,211.14,'2023-01-25 17:40:14'),(264,'1','310',1,'Retail Sale Id 258',0.00,2714.67,720.00,3002.40,287.73,'2023-01-25 17:41:05'),(265,'1','310',1,'Retail Sale Id 259',0.00,1992.06,720.00,2203.20,211.14,'2023-01-25 17:42:46'),(266,'1','310',1,'Retail Sale Id 260',0.00,32550.00,700.00,35000.00,2450.00,'2023-01-25 17:51:10'),(267,'1','310',1,'Retail Sale Id 261',0.00,3932.04,720.00,4348.80,416.76,'2023-01-25 17:52:50'),(268,'1','310',1,'Retail Sale Id 262',0.00,8410.92,720.00,9302.40,891.48,'2023-01-25 17:53:43'),(269,'1','310',1,'Retail Sale Id 263',0.00,449.19,720.00,496.80,47.61,'2023-01-25 18:08:13'),(270,'1','310',1,'Retail Sale Id 264',0.00,449.19,720.00,496.80,47.61,'2023-01-25 18:08:51'),(271,'1','310',1,'Retail Sale Id 265',0.00,898.38,720.00,993.60,95.22,'2023-01-25 18:11:57'),(272,'1','310',1,'Return of Retail Sale Id 212',16275.00,0.00,720.00,-18000.00,-1725.00,'2023-01-25 18:39:05'),(273,'1','310',1,'Retail Sale Id 266',0.00,2304.54,720.00,2548.80,244.26,'2023-01-25 18:41:44'),(274,'1','310',1,'Retail Sale Id 267',0.00,1992.06,720.00,2203.20,211.14,'2023-01-26 07:35:46'),(275,'1','310',1,'Retail Sale Id 268',0.00,2623.53,720.00,2901.60,278.07,'2023-01-26 08:49:00'),(276,'1','310',1,'Retail Sale Id 269',0.00,3977.61,720.00,4399.20,421.59,'2023-01-26 08:49:56'),(277,'1','310',1,'Retail Sale Id 270',0.00,2714.67,720.00,3002.40,287.73,'2023-01-26 08:50:49'),(278,'1','310',1,'Retail Sale Id 272',0.00,1178.31,720.00,1303.20,124.89,'2023-01-26 08:52:49'),(279,'1','310',1,'Retail Sale Id 273',0.00,3619.56,720.00,4003.20,383.64,'2023-01-26 08:56:28'),(280,'1','310',1,'Retail Sale Id 274',0.00,1809.78,720.00,2001.60,191.82,'2023-01-26 09:01:00'),(281,'1','310',1,'Retail Sale Id 275',0.00,904.89,720.00,1000.80,95.91,'2023-01-26 09:02:10'),(282,'1','310',1,'Retail Sale Id 276',0.00,97650.00,700.00,105000.00,7350.00,'2023-01-26 09:11:02'),(283,'1','310',1,'Retail Sale Id 277',0.00,97650.00,700.00,105000.00,7350.00,'2023-01-26 09:11:54'),(284,'1','310',1,'Retail Sale Id 278',0.00,97650.00,700.00,105000.00,7350.00,'2023-01-26 09:12:44'),(285,'1','310',1,'Retail Sale Id 279',0.00,3886.47,720.00,4298.40,411.93,'2023-01-26 09:13:55'),(286,'1','310',1,'Retail Sale Id 280',0.00,1809.78,720.00,2001.60,191.82,'2023-01-26 09:15:35'),(287,'1','310',1,'Retail Sale Id 281',0.00,2714.67,720.00,3002.40,287.73,'2023-01-26 09:16:35'),(288,'1','310',1,'Retail Sale Id 282',0.00,1354.08,720.00,1497.60,143.52,'2023-01-26 09:18:12'),(289,'1','310',1,'Retail Sale Id 283',0.00,449.19,720.00,496.80,47.61,'2023-01-26 09:19:29'),(290,'1','310',1,'Retail Sale Id 283',0.00,904.89,720.00,1000.80,95.91,'2023-01-26 09:19:29'),(291,'1','310',1,'Retail Sale Id 284',0.00,3977.61,720.00,4399.20,421.59,'2023-01-26 09:20:57'),(292,'1','310',1,'Retail Sale Id 285',0.00,904.89,720.00,1000.80,95.91,'2023-01-26 09:22:33'),(293,'1','310',1,'Retail Sale Id 286',0.00,3977.61,720.00,4399.20,421.59,'2023-01-26 09:25:00'),(294,'1','310',1,'Retail Sale Id 287',0.00,904.89,720.00,1000.80,95.91,'2023-01-26 09:26:43'),(295,'1','310',1,'Retail Sale Id 288',0.00,904.89,720.00,1000.80,95.91,'2023-01-26 09:28:02'),(296,'1','310',1,'Retail Sale Id 289',0.00,3906.00,720.00,4320.00,414.00,'2023-01-26 09:53:10'),(297,'1','310',1,'Retail Sale Id 290',0.00,3977.61,720.00,4399.20,421.59,'2023-01-26 09:54:49'),(298,'1','310',1,'Retail Sale Id 291',0.00,4517.94,720.00,4996.80,478.86,'2023-01-26 10:04:20'),(299,'1','310',1,'Retail Sale Id 292',0.00,2714.67,720.00,3002.40,287.73,'2023-01-26 10:12:31'),(300,'1','310',1,'Retail Sale Id 293',0.00,1992.06,720.00,2203.20,211.14,'2023-01-26 10:15:54'),(301,'1','310',1,'Retail Sale Id 294',0.00,1809.78,720.00,2001.60,191.82,'2023-01-26 10:24:11'),(302,'1','310',1,'Retail Sale Id 295',0.00,3346.14,720.00,3700.80,354.66,'2023-01-26 10:25:26'),(303,'1','310',1,'Retail Sale Id 297',0.00,4068.75,720.00,4500.00,431.25,'2023-01-26 10:27:54'),(304,'1','310',1,'Retail Sale Id 298',0.00,8137.50,720.00,9000.00,862.50,'2023-01-26 10:36:07'),(305,'1','310',1,'Retail Sale Id 299',0.00,3977.61,720.00,4399.20,421.59,'2023-01-26 11:08:49'),(306,'1','310',1,'Retail Sale Id 300',0.00,996.03,720.00,1101.60,105.57,'2023-01-26 11:10:02'),(307,'1','310',1,'Retail Sale Id 301',0.00,3977.61,720.00,4399.20,421.59,'2023-01-26 11:19:23'),(308,'1','310',1,'Retail Sale Id 302',0.00,8137.50,720.00,9000.00,862.50,'2023-01-26 11:20:24'),(309,'1','310',1,'Retail Sale Id 303',0.00,2714.67,720.00,3002.40,287.73,'2023-01-26 11:22:23'),(310,'1','310',1,'Retail Sale Id 304',0.00,2714.67,720.00,3002.40,287.73,'2023-01-26 11:23:59'),(311,'1','310',1,'Retail Sale Id 305',0.00,1992.06,720.00,2203.20,211.14,'2023-01-26 11:24:54'),(312,'1','310',1,'Retail Sale Id 306',0.00,1354.08,720.00,1497.60,143.52,'2023-01-26 11:28:05'),(313,'1','310',1,'Retail Sale Id 307',0.00,1262.94,720.00,1396.80,133.86,'2023-01-26 11:31:42'),(314,'1','310',1,'Retail Sale Id 308',0.00,2714.67,720.00,3002.40,287.73,'2023-01-26 11:32:57'),(315,'1','310',1,'Retail Sale Id 309',0.00,8137.50,720.00,9000.00,862.50,'2023-01-26 11:36:32'),(316,'1','310',1,'Retail Sale Id 310',0.00,7232.61,720.00,7999.20,766.59,'2023-01-26 11:41:07'),(317,'1','310',1,'Retail Sale Id 311',0.00,1354.08,720.00,1497.60,143.52,'2023-01-26 11:42:33'),(318,'1','310',1,'Retail Sale Id 312',0.00,1809.78,720.00,2001.60,191.82,'2023-01-26 11:53:33'),(319,'1','310',1,'Retail Sale Id 313',0.00,904.89,720.00,1000.80,95.91,'2023-01-26 12:02:20'),(320,'1','310',1,'Retail Sale Id 314',0.00,2714.67,720.00,3002.40,287.73,'2023-01-26 12:06:43'),(321,'1','310',1,'Retail Sale Id 315',0.00,2714.67,720.00,3002.40,287.73,'2023-01-26 12:08:10'),(322,'1','310',1,'Retail Sale Id 316',0.00,3977.61,720.00,4399.20,421.59,'2023-01-26 12:16:49'),(323,'1','310',1,'Retail Sale Id 317',0.00,4068.75,720.00,4500.00,431.25,'2023-01-26 12:47:49'),(324,'1','310',1,'Retail Sale Id 318',0.00,8137.50,720.00,9000.00,862.50,'2023-01-26 13:09:33'),(325,'1','310',1,'Retail Sale Id 319',0.00,1809.78,720.00,2001.60,191.82,'2023-01-26 13:10:52'),(326,'1','310',1,'Retail Sale Id 320',0.00,2714.67,720.00,3002.40,287.73,'2023-01-26 13:32:02'),(327,'1','310',1,'Retail Sale Id 321',0.00,1992.06,720.00,2203.20,211.14,'2023-01-26 13:37:52'),(328,'1','310',1,'Retail Sale Id 322',0.00,1809.78,720.00,2001.60,191.82,'2023-01-26 13:39:10'),(329,'1','310',1,'Retail Sale Id 323',0.00,71610.00,700.00,77000.00,5390.00,'2023-01-26 13:55:58'),(330,'1','310',1,'Retail Sale Id 324',0.00,1809.78,720.00,2001.60,191.82,'2023-01-26 14:03:09'),(331,'1','310',1,'Retail Sale Id 325',0.00,3906.00,720.00,4320.00,414.00,'2023-01-26 14:11:11'),(332,'1','310',1,'Retail Sale Id 326',0.00,1354.08,720.00,1497.60,143.52,'2023-01-26 14:14:22'),(333,'1','310',1,'Retail Sale Id 327',0.00,1354.08,720.00,1497.60,143.52,'2023-01-26 14:24:59'),(334,'1','310',1,'Retail Sale Id 328',0.00,1809.78,720.00,2001.60,191.82,'2023-01-26 14:34:07'),(335,'1','310',1,'Retail Sale Id 329',0.00,904.89,720.00,1000.80,95.91,'2023-01-26 14:40:12'),(336,'1','310',1,'Retail Sale Id 330',0.00,4342.17,720.00,4802.40,460.23,'2023-01-26 14:41:13'),(337,'1','310',1,'Retail Sale Id 331',0.00,494.76,720.00,547.20,52.44,'2023-01-26 14:42:48'),(338,'1','310',1,'Retail Sale Id 332',0.00,32550.00,700.00,35000.00,2450.00,'2023-01-26 14:48:43'),(339,'1','310',1,'Retail Sale Id 333',0.00,2714.67,720.00,3002.40,287.73,'2023-01-26 15:11:54'),(340,'1','310',1,'Retail Sale Id 334',0.00,1809.78,720.00,2001.60,191.82,'2023-01-26 15:12:47'),(341,'1','310',1,'Retail Sale Id 335',0.00,1809.78,720.00,2001.60,191.82,'2023-01-26 15:15:34'),(342,'1','310',1,'Retail Sale Id 336',0.00,279.93,720.00,309.60,29.67,'2023-01-26 15:16:33'),(343,'1','310',1,'Retail Sale Id 337',0.00,3977.61,720.00,4399.20,421.59,'2023-01-26 15:57:58'),(344,'1','310',1,'Retail Sale Id 338',0.00,1809.78,720.00,2001.60,191.82,'2023-01-26 16:12:07'),(345,'1','310',1,'Retail Sale Id 339',0.00,3255.00,720.00,3600.00,345.00,'2023-01-26 16:14:20'),(346,'1','310',1,'Retail Sale Id 340',0.00,904.89,720.00,1000.80,95.91,'2023-01-26 16:36:16'),(347,'1','310',1,'Retail Sale Id 341',0.00,1308.51,720.00,1447.20,138.69,'2023-01-26 16:43:32'),(348,'1','310',1,'Retail Sale Id 342',0.00,1354.08,720.00,1497.60,143.52,'2023-01-26 16:53:18'),(349,'1','310',1,'Retail Sale Id 343',0.00,1627.50,720.00,1800.00,172.50,'2023-01-26 17:15:23'),(350,'1','310',1,'Retail Sale Id 344',0.00,5878.53,720.00,6501.60,623.07,'2023-01-26 17:22:39'),(351,'1','310',1,'Retail Sale Id 345',0.00,631.47,720.00,698.40,66.93,'2023-01-26 17:25:43'),(352,'1','310',1,'Retail Sale Id 346',0.00,3977.61,720.00,4399.20,421.59,'2023-01-26 17:27:13'),(353,'1','310',1,'Retail Sale Id 347',0.00,3977.61,720.00,4399.20,421.59,'2023-01-26 17:34:24'),(354,'1','310',1,'Retail Sale Id 348',0.00,32550.00,700.00,35000.00,2450.00,'2023-01-26 17:39:14'),(355,'1','310',1,'Retail Sale Id 349',0.00,904.89,720.00,1000.80,95.91,'2023-01-26 17:40:18'),(356,'1','310',1,'Retail Sale Id 350',0.00,2258.97,720.00,2498.40,239.43,'2023-01-26 17:42:25'),(357,'1','310',1,'Retail Sale Id 351',0.00,904.89,720.00,1000.80,95.91,'2023-01-26 17:43:54'),(358,'1','310',1,'Retail Sale Id 352',0.00,2714.67,720.00,3002.40,287.73,'2023-01-26 17:44:49'),(359,'1','310',1,'Retail Sale Id 353',0.00,3255.00,720.00,3600.00,345.00,'2023-01-26 17:46:38'),(360,'1','310',1,'Retail Sale Id 354',0.00,1992.06,720.00,2203.20,211.14,'2023-01-26 17:47:24'),(361,'1','310',1,'Retail Sale Id 355',0.00,1992.06,720.00,2203.20,211.14,'2023-01-26 17:50:39'),(362,'1','310',1,'Retail Sale Id 356',0.00,2714.67,720.00,3002.40,287.73,'2023-01-26 18:00:29'),(363,'1','310',1,'Retail Sale Id 357',0.00,1809.78,720.00,2001.60,191.82,'2023-01-26 18:08:19'),(364,'1','310',1,'Retail Sale Id 357',0.00,1809.78,720.00,2001.60,191.82,'2023-01-26 18:08:19'),(365,'1','310',1,'Retail Sale Id 358',0.00,3619.56,720.00,4003.20,383.64,'2023-01-26 18:13:28'),(366,'1','310',1,'Retail Sale Id 358',0.00,8137.50,720.00,9000.00,862.50,'2023-01-26 18:13:28'),(367,'1','310',1,'Retail Sale Id 359',0.00,3977.61,720.00,4399.20,421.59,'2023-01-26 18:14:49'),(368,'1','310',1,'Retail Sale Id 359',0.00,8137.50,720.00,9000.00,862.50,'2023-01-26 18:14:49'),(369,'1','310',1,'Retail Sale Id 360',0.00,13020.00,700.00,14000.00,980.00,'2023-01-26 19:02:00'),(370,'1','310',1,'Return of Retail Sale Id 357',1809.78,0.00,720.00,-2001.60,-191.82,'2023-01-26 19:04:25'),(371,'1','310',1,'Return of Retail Sale Id 357',1809.78,0.00,720.00,-2001.60,-191.82,'2023-01-26 19:04:25'),(372,'1','310',1,'Retail Sale Id 361',0.00,761.67,720.00,842.40,80.73,'2023-01-26 19:05:33'),(373,'1','310',1,'Retail Sale Id 362',0.00,449.19,720.00,496.80,47.61,'2023-01-27 08:01:49'),(374,'1','310',1,'Retail Sale Id 362',0.00,8137.50,720.00,9000.00,862.50,'2023-01-27 08:01:49'),(375,'1','310',1,'Retail Sale Id 363',0.00,3255.00,720.00,3600.00,345.00,'2023-01-27 08:09:04'),(376,'1','310',1,'Retail Sale Id 364',0.00,3619.56,720.00,4003.20,383.64,'2023-01-27 08:46:29'),(377,'1','310',1,'Retail Sale Id 365',0.00,3163.86,720.00,3499.20,335.34,'2023-01-27 08:50:55'),(378,'1','310',1,'Retail Sale Id 366',0.00,56637.00,700.00,60900.00,4263.00,'2023-01-27 08:57:42'),(379,'1','310',1,'Retail Sale Id 367',0.00,904.89,720.00,1000.80,95.91,'2023-01-27 09:03:34'),(380,'1','310',1,'Retail Sale Id 368',0.00,32550.00,700.00,35000.00,2450.00,'2023-01-27 09:07:29'),(381,'1','310',1,'Retail Sale Id 369',0.00,32550.00,700.00,35000.00,2450.00,'2023-01-27 09:08:11'),(382,'1','310',1,'Retail Sale Id 370',0.00,32550.00,700.00,35000.00,2450.00,'2023-01-27 09:09:19'),(383,'1','310',1,'Retail Sale Id 371',0.00,3906.00,720.00,4320.00,414.00,'2023-01-27 09:18:18'),(384,'1','310',1,'Retail Sale Id 372',0.00,904.89,720.00,1000.80,95.91,'2023-01-27 09:21:03'),(385,'1','310',1,'Retail Sale Id 373',0.00,1302.00,720.00,1440.00,138.00,'2023-01-27 09:34:15'),(386,'1','310',1,'Retail Sale Id 374',0.00,2604.00,720.00,2880.00,276.00,'2023-01-27 09:42:22'),(387,'1','310',1,'Retail Sale Id 375',0.00,3906.00,720.00,4320.00,414.00,'2023-01-27 09:43:39'),(388,'1','310',1,'Retail Sale Id 376',0.00,6510.00,700.00,7000.00,490.00,'2023-01-27 09:44:57'),(389,'1','310',1,'Retail Sale Id 377',0.00,1992.06,720.00,2203.20,211.14,'2023-01-27 09:48:50'),(390,'1','310',1,'Retail Sale Id 378',0.00,4973.64,720.00,5500.80,527.16,'2023-01-27 09:55:30'),(391,'1','310',1,'Retail Sale Id 380',0.00,3906.00,720.00,4320.00,414.00,'2023-01-27 09:58:13'),(392,'1','310',1,'Retail Sale Id 381',0.00,70959.00,700.00,76300.00,5341.00,'2023-01-27 09:59:18'),(393,'1','310',1,'Retail Sale Id 382',0.00,3255.00,720.00,3600.00,345.00,'2023-01-27 10:04:32'),(394,'1','310',1,'Retail Sale Id 383',0.00,13950.93,700.00,15001.00,1050.07,'2023-01-27 10:09:41'),(395,'1','310',1,'Retail Sale Id 384',0.00,1087.17,720.00,1202.40,115.23,'2023-01-27 10:11:10'),(396,'1','310',1,'Retail Sale Id 385',0.00,2258.97,720.00,2498.40,239.43,'2023-01-27 10:16:53'),(397,'1','310',1,'Retail Sale Id 385',0.00,8137.50,720.00,9000.00,862.50,'2023-01-27 10:16:53'),(398,'1','310',1,'Retail Sale Id 386',0.00,3906.00,720.00,4320.00,414.00,'2023-01-27 10:30:05'),(399,'1','310',1,'Retail Sale Id 387',0.00,3906.00,720.00,4320.00,414.00,'2023-01-27 10:32:58'),(400,'1','310',1,'Retail Sale Id 388',0.00,1809.78,720.00,2001.60,191.82,'2023-01-27 10:35:29'),(401,'1','310',1,'Retail Sale Id 389',0.00,3977.61,720.00,4399.20,421.59,'2023-01-27 10:39:51'),(402,'1','310',1,'Retail Sale Id 390',0.00,1992.06,720.00,2203.20,211.14,'2023-01-27 10:42:07'),(403,'1','310',1,'Retail Sale Id 391',0.00,97650.00,700.00,105000.00,7350.00,'2023-01-27 10:56:30'),(404,'1','310',1,'Retail Sale Id 392',0.00,97650.00,700.00,105000.00,7350.00,'2023-01-27 10:57:17'),(405,'1','310',1,'Retail Sale Id 393',0.00,97650.00,700.00,105000.00,7350.00,'2023-01-27 10:58:19'),(406,'1','310',1,'Retail Sale Id 394',0.00,78120.00,700.00,84000.00,5880.00,'2023-01-27 10:59:50'),(407,'1','310',1,'Retail Sale Id 395',0.00,32550.00,700.00,35000.00,2450.00,'2023-01-27 11:01:14'),(408,'1','310',1,'Retail Sale Id 396',0.00,32550.00,700.00,35000.00,2450.00,'2023-01-27 11:02:08'),(409,'1','310',1,'Retail Sale Id 397',0.00,32550.00,700.00,35000.00,2450.00,'2023-01-27 11:02:50'),(410,'1','310',1,'Retail Sale Id 398',0.00,3906.00,720.00,4320.00,414.00,'2023-01-27 11:04:52'),(411,'1','310',1,'Retail Sale Id 399',0.00,1354.08,720.00,1497.60,143.52,'2023-01-27 11:05:48'),(412,'1','310',1,'Retail Sale Id 400',0.00,1992.06,720.00,2203.20,211.14,'2023-01-27 11:07:29'),(413,'1','310',1,'Retail Sale Id 401',0.00,722.61,720.00,799.20,76.59,'2023-01-27 11:16:08'),(414,'1','310',1,'Retail Sale Id 402',0.00,4517.94,720.00,4996.80,478.86,'2023-01-27 11:17:06'),(415,'1','310',1,'Retail Sale Id 403',0.00,3906.00,720.00,4320.00,414.00,'2023-01-27 11:21:45'),(416,'1','310',1,'Retail Sale Id 404',0.00,6510.00,700.00,7000.00,490.00,'2023-01-27 11:28:37'),(417,'1','310',1,'Retail Sale Id 405',0.00,3906.00,700.00,4200.00,294.00,'2023-01-27 11:29:56'),(418,'1','310',1,'Retail Sale Id 406',0.00,904.89,720.00,1000.80,95.91,'2023-01-27 11:42:28'),(419,'1','310',1,'Retail Sale Id 407',0.00,3255.00,720.00,3600.00,345.00,'2023-01-27 11:44:49'),(420,'1','310',1,'Retail Sale Id 408',0.00,39060.00,700.00,42000.00,2940.00,'2023-01-27 11:52:45'),(421,'1','310',1,'Retail Sale Id 409',0.00,10604.79,700.00,11403.00,798.21,'2023-01-27 11:56:09'),(422,'1','310',1,'Retail Sale Id 410',0.00,39060.00,700.00,42000.00,2940.00,'2023-01-27 11:57:28'),(423,'1','310',1,'Retail Sale Id 412',0.00,904.89,720.00,1000.80,95.91,'2023-01-27 12:12:31'),(424,'1','310',1,'Retail Sale Id 413',0.00,8137.50,720.00,9000.00,862.50,'2023-01-27 12:20:04'),(425,'1','310',1,'Retail Sale Id 414',0.00,3906.00,720.00,4320.00,414.00,'2023-01-27 12:21:55'),(426,'1','310',1,'Retail Sale Id 415',0.00,2714.67,720.00,3002.40,287.73,'2023-01-27 12:44:50'),(427,'1','310',1,'Retail Sale Id 416',0.00,7232.61,720.00,7999.20,766.59,'2023-01-27 12:47:12'),(428,'1','310',1,'Retail Sale Id 417',0.00,4517.94,720.00,4996.80,478.86,'2023-01-27 12:48:55'),(429,'1','310',1,'Retail Sale Id 418',0.00,2714.67,720.00,3002.40,287.73,'2023-01-27 13:00:14'),(430,'1','310',1,'Retail Sale Id 419',0.00,1992.06,720.00,2203.20,211.14,'2023-01-27 13:09:38'),(431,'1','310',1,'Retail Sale Id 420',0.00,65100.00,700.00,70000.00,4900.00,'2023-01-27 13:42:35'),(432,'1','310',1,'Retail Sale Id 421',0.00,65100.00,700.00,70000.00,4900.00,'2023-01-27 13:43:46'),(433,'1','310',1,'Retail Sale Id 422',0.00,1809.78,720.00,2001.60,191.82,'2023-01-27 14:14:18'),(434,'1','310',1,'Retail Sale Id 423',0.00,904.89,720.00,1000.80,95.91,'2023-01-27 14:24:41'),(435,'1','310',1,'Retail Sale Id 423',0.00,2714.67,720.00,3002.40,287.73,'2023-01-27 14:24:41'),(436,'1','310',1,'Retail Sale Id 424',0.00,162750.00,700.00,175000.00,12250.00,'2023-01-27 14:38:25'),(437,'1','310',1,'Retail Sale Id 425',0.00,1809.78,720.00,2001.60,191.82,'2023-01-27 14:41:51'),(438,'1','310',1,'Retail Sale Id 426',0.00,2714.67,720.00,3002.40,287.73,'2023-01-27 14:43:25'),(439,'1','310',1,'Retail Sale Id 427',0.00,6510.00,720.00,7200.00,690.00,'2023-01-27 14:45:51'),(440,'1','310',1,'Retail Sale Id 428',0.00,1354.08,720.00,1497.60,143.52,'2023-01-27 15:02:51'),(441,'1','310',1,'Retail Sale Id 429',0.00,1809.78,720.00,2001.60,191.82,'2023-01-27 15:17:03'),(442,'1','310',1,'Retail Sale Id 430',0.00,6510.00,720.00,7200.00,690.00,'2023-01-27 15:21:09'),(443,'1','310',1,'Retail Sale Id 430',0.00,6510.00,720.00,7200.00,690.00,'2023-01-27 15:21:09'),(444,'1','310',1,'Retail Sale Id 431',0.00,722.61,720.00,799.20,76.59,'2023-01-27 15:40:34'),(445,'1','310',1,'Retail Sale Id 432',0.00,3977.61,720.00,4399.20,421.59,'2023-01-27 15:51:49'),(446,'1','310',1,'Retail Sale Id 433',0.00,1536.36,720.00,1699.20,162.84,'2023-01-27 15:57:39'),(447,'1','310',1,'Retail Sale Id 434',0.00,3619.56,720.00,4003.20,383.64,'2023-01-27 16:03:18'),(448,'1','310',1,'Retail Sale Id 436',0.00,2714.67,720.00,3002.40,287.73,'2023-01-27 16:43:20'),(449,'1','310',1,'Retail Sale Id 437',0.00,449.19,720.00,496.80,47.61,'2023-01-27 16:44:30'),(450,'1','310',1,'Retail Sale Id 438',0.00,1809.78,720.00,2001.60,191.82,'2023-01-27 16:47:01'),(451,'1','310',1,'Retail Sale Id 439',0.00,8137.50,720.00,9000.00,862.50,'2023-01-27 16:51:22'),(452,'1','310',1,'Retail Sale Id 440',0.00,1953.00,720.00,2160.00,207.00,'2023-01-27 16:52:17'),(453,'1','310',1,'Retail Sale Id 440',0.00,3906.00,720.00,4320.00,414.00,'2023-01-27 16:52:17'),(454,'1','310',1,'Retail Sale Id 441',0.00,904.89,720.00,1000.80,95.91,'2023-01-27 16:57:47'),(455,'1','310',1,'Retail Sale Id 442',0.00,32550.00,700.00,35000.00,2450.00,'2023-01-27 17:03:47'),(456,'1','310',1,'Retail Sale Id 443',0.00,1992.06,720.00,2203.20,211.14,'2023-01-27 17:05:58'),(457,'1','310',1,'Retail Sale Id 444',0.00,3255.00,720.00,3600.00,345.00,'2023-01-27 17:11:38'),(458,'1','310',1,'Retail Sale Id 445',0.00,3977.61,720.00,4399.20,421.59,'2023-01-27 17:12:36'),(459,'1','310',1,'Retail Sale Id 447',0.00,4068.75,720.00,4500.00,431.25,'2023-01-27 17:15:52'),(460,'1','310',1,'Retail Sale Id 448',0.00,1354.08,720.00,1497.60,143.52,'2023-01-27 17:16:45'),(461,'1','310',1,'Retail Sale Id 449',0.00,1354.08,720.00,1497.60,143.52,'2023-01-27 17:17:33'),(462,'1','310',1,'Retail Sale Id 450',0.00,2714.67,720.00,3002.40,287.73,'2023-01-27 17:23:23'),(463,'1','310',1,'Retail Sale Id 451',0.00,904.89,720.00,1000.80,95.91,'2023-01-27 17:31:14'),(464,'1','310',1,'Retail Sale Id 452',0.00,1992.06,720.00,2203.20,211.14,'2023-01-27 17:39:44'),(465,'1','310',1,'Retail Sale Id 453',0.00,904.89,720.00,1000.80,95.91,'2023-01-27 17:41:32'),(466,'1','310',1,'Retail Sale Id 454',0.00,1809.78,720.00,2001.60,191.82,'2023-01-27 17:44:51'),(467,'1','310',1,'Retail Sale Id 455',0.00,3795.33,720.00,4197.60,402.27,'2023-01-27 17:52:03'),(468,'1','310',1,'Retail Sale Id 456',0.00,3977.61,720.00,4399.20,421.59,'2023-01-27 18:00:27'),(469,'1','310',1,'Retail Sale Id 458',0.00,1953.00,720.00,2160.00,207.00,'2023-01-27 18:05:39'),(470,'1','310',1,'Retail Sale Id 458',0.00,1953.00,720.00,2160.00,207.00,'2023-01-27 18:05:39'),(471,'1','310',1,'Retail Sale Id 459',0.00,904.89,720.00,1000.80,95.91,'2023-01-27 18:09:07'),(472,'1','310',1,'Retail Sale Id 460',0.00,904.89,720.00,1000.80,95.91,'2023-01-27 18:22:01'),(473,'1','310',1,'Retail Sale Id 460',0.00,904.89,720.00,1000.80,95.91,'2023-01-27 18:22:01'),(474,'1','310',1,'Retail Sale Id 461',0.00,904.89,720.00,1000.80,95.91,'2023-01-27 18:23:14'),(475,'1','310',1,'Retail Sale Id 461',0.00,904.89,720.00,1000.80,95.91,'2023-01-27 18:23:14'),(476,'1','310',1,'Retail Sale Id 462',0.00,2714.67,720.00,3002.40,287.73,'2023-01-27 18:24:10'),(477,'1','310',1,'Retail Sale Id 463',0.00,722.61,720.00,799.20,76.59,'2023-01-27 18:24:55'),(478,'1','310',1,'Retail Sale Id 464',0.00,8137.50,720.00,9000.00,862.50,'2023-01-27 18:25:41'),(479,'1','310',1,'Retail Sale Id 465',0.00,1536.36,720.00,1699.20,162.84,'2023-01-27 18:26:24'),(480,'1','310',1,'Retail Sale Id 466',0.00,8137.50,720.00,9000.00,862.50,'2023-01-27 18:27:17'),(481,'1','310',1,'Retail Sale Id 467',0.00,1809.78,720.00,2001.60,191.82,'2023-01-27 18:30:13'),(482,'1','310',1,'Return of Retail Sale Id 460',904.89,0.00,720.00,-1000.80,-95.91,'2023-01-27 18:52:35'),(483,'1','310',1,'Return of Retail Sale Id 460',904.89,0.00,720.00,-1000.80,-95.91,'2023-01-27 18:52:35'),(484,'1','310',1,'Retail Sale Id 468',0.00,46221.00,700.00,49700.00,3479.00,'2023-01-27 18:54:23'),(485,'1','310',1,'Return of Retail Sale Id 468',46221.00,0.00,700.00,-49700.00,-3479.00,'2023-01-27 18:54:36'),(486,'1','310',1,'Retail Sale Id 470',0.00,325.50,720.00,360.00,34.50,'2023-01-27 18:56:29'),(487,'1','310',1,'Return of Retail Sale Id 470',325.50,0.00,720.00,-360.00,-34.50,'2023-01-27 18:56:47'),(488,'1','310',1,'Return of Retail Sale Id 467',1809.78,0.00,720.00,-2001.60,-191.82,'2023-01-27 18:57:14'),(489,'1','310',1,'Return of Retail Sale Id 409',10604.79,0.00,700.00,-11403.00,-798.21,'2023-01-27 19:04:50'),(490,'1','310',1,'Retail Sale Id 471',0.00,9751.98,700.00,10486.00,734.02,'2023-01-27 19:05:44'),(491,'1','310',1,'Retail Sale Id 472',0.00,1484.28,720.00,1641.60,157.32,'2023-01-27 19:06:28'),(492,'1','310',1,'Retail Sale Id 473',0.00,8137.50,720.00,9000.00,862.50,'2023-01-28 09:52:11'),(493,'1','310',1,'Retail Sale Id 473',0.00,8137.50,720.00,9000.00,862.50,'2023-01-28 09:52:11'),(494,'1','310',1,'Retail Sale Id 474',0.00,3906.00,720.00,4320.00,414.00,'2023-01-28 10:16:22'),(495,'1','310',1,'Retail Sale Id 475',0.00,4068.75,720.00,4500.00,431.25,'2023-01-28 10:19:51'),(496,'1','310',1,'Retail Sale Id 476',0.00,1953.00,720.00,2160.00,207.00,'2023-01-28 10:27:15'),(497,'1','310',1,'Retail Sale Id 477',0.00,904.89,720.00,1000.80,95.91,'2023-01-28 10:29:07'),(498,'1','310',1,'Retail Sale Id 478',0.00,8137.50,720.00,9000.00,862.50,'2023-01-28 10:31:44'),(499,'1','310',1,'Retail Sale Id 478',0.00,8137.50,720.00,9000.00,862.50,'2023-01-28 10:31:44'),(500,'1','310',1,'Retail Sale Id 479',0.00,904.89,720.00,1000.80,95.91,'2023-01-28 10:42:43'),(501,'1','310',1,'Retail Sale Id 480',0.00,35805.00,700.00,38500.00,2695.00,'2023-01-28 10:53:29'),(502,'1','310',1,'Retail Sale Id 481',0.00,35805.00,700.00,38500.00,2695.00,'2023-01-28 10:54:43'),(503,'1','310',1,'Retail Sale Id 482',0.00,218085.00,700.00,234500.00,16415.00,'2023-01-28 10:56:19'),(504,'1','310',1,'Retail Sale Id 483',0.00,1809.78,720.00,2001.60,191.82,'2023-01-28 10:58:32'),(505,'1','310',1,'Retail Sale Id 484',0.00,1809.78,720.00,2001.60,191.82,'2023-01-28 10:59:21'),(506,'1','310',1,'Retail Sale Id 485',0.00,4068.75,720.00,4500.00,431.25,'2023-01-28 11:07:27'),(507,'1','310',1,'Retail Sale Id 486',0.00,3906.00,720.00,4320.00,414.00,'2023-01-28 11:08:59'),(508,'1','310',1,'Retail Sale Id 488',0.00,3255.00,720.00,3600.00,345.00,'2023-01-28 11:12:14'),(509,'1','310',1,'Retail Sale Id 488',0.00,3906.00,720.00,4320.00,414.00,'2023-01-28 11:12:14'),(510,'1','310',1,'Retail Sale Id 489',0.00,1900.92,720.00,2102.40,201.48,'2023-01-28 11:13:36'),(511,'1','310',1,'Retail Sale Id 490',0.00,4068.75,720.00,4500.00,431.25,'2023-01-28 11:14:50'),(512,'1','310',1,'Retail Sale Id 491',0.00,3906.00,720.00,4320.00,414.00,'2023-01-28 11:17:33'),(513,'1','310',1,'Retail Sale Id 492',0.00,1718.64,720.00,1900.80,182.16,'2023-01-28 11:18:25'),(514,'1','310',1,'Retail Sale Id 493',0.00,1354.08,720.00,1497.60,143.52,'2023-01-28 11:26:48'),(515,'1','310',1,'Retail Sale Id 495',0.00,1262.94,720.00,1396.80,133.86,'2023-01-28 11:29:21'),(516,'1','310',1,'Retail Sale Id 497',0.00,39060.00,700.00,42000.00,2940.00,'2023-01-28 11:32:24'),(517,'1','310',1,'Retail Sale Id 498',0.00,1992.06,720.00,2203.20,211.14,'2023-01-28 11:34:18'),(518,'1','310',1,'Retail Sale Id 499',0.00,1992.06,720.00,2203.20,211.14,'2023-01-28 11:45:59'),(519,'1','310',1,'Retail Sale Id 500',0.00,4068.75,720.00,4500.00,431.25,'2023-01-28 11:53:55'),(520,'1','310',1,'Retail Sale Id 501',0.00,1354.08,720.00,1497.60,143.52,'2023-01-28 11:54:56'),(521,'1','310',1,'Retail Sale Id 502',0.00,3977.61,720.00,4399.20,421.59,'2023-01-28 12:01:53'),(522,'1','310',1,'Retail Sale Id 503',0.00,904.89,720.00,1000.80,95.91,'2023-01-28 12:02:45'),(523,'1','310',1,'Retail Sale Id 505',0.00,8137.50,720.00,9000.00,862.50,'2023-01-28 12:15:09'),(524,'1','310',1,'Retail Sale Id 506',0.00,904.89,720.00,1000.80,95.91,'2023-01-28 12:23:01'),(525,'1','310',1,'Retail Sale Id 507',0.00,651.00,720.00,720.00,69.00,'2023-01-28 12:24:57'),(526,'1','310',1,'Retail Sale Id 508',0.00,8137.50,720.00,9000.00,862.50,'2023-01-28 12:36:26'),(527,'1','310',1,'Retail Sale Id 509',0.00,904.89,720.00,1000.80,95.91,'2023-01-28 12:50:48'),(528,'1','310',1,'Retail Sale Id 510',0.00,9114.00,700.00,9800.00,686.00,'2023-01-28 13:17:40'),(529,'1','310',1,'Retail Sale Id 511',0.00,5878.53,720.00,6501.60,623.07,'2023-01-28 13:20:38'),(530,'1','310',1,'Retail Sale Id 512',0.00,3906.00,720.00,4320.00,414.00,'2023-01-28 13:26:06'),(531,'1','310',1,'Retail Sale Id 512',0.00,6510.00,720.00,7200.00,690.00,'2023-01-28 13:26:06'),(532,'1','310',1,'Retail Sale Id 513',0.00,6510.00,720.00,7200.00,690.00,'2023-01-28 13:32:24'),(533,'1','310',1,'Retail Sale Id 514',0.00,8137.50,720.00,9000.00,862.50,'2023-01-28 13:45:59'),(534,'1','310',1,'Retail Sale Id 515',0.00,3255.00,720.00,3600.00,345.00,'2023-01-28 13:52:19'),(535,'1','310',1,'Retail Sale Id 516',0.00,162750.00,700.00,175000.00,12250.00,'2023-01-28 13:57:53'),(536,'1','310',1,'Retail Sale Id 517',0.00,3977.61,720.00,4399.20,421.59,'2023-01-28 14:17:10'),(537,'1','310',1,'Retail Sale Id 518',0.00,1809.78,720.00,2001.60,191.82,'2023-01-28 14:23:35'),(538,'1','310',1,'Retail Sale Id 520',0.00,8137.50,720.00,9000.00,862.50,'2023-01-28 14:28:53'),(539,'1','310',1,'Retail Sale Id 521',0.00,904.89,720.00,1000.80,95.91,'2023-01-28 14:32:37'),(540,'1','310',1,'Retail Sale Id 522',0.00,1354.08,720.00,1497.60,143.52,'2023-01-28 14:37:08'),(541,'1','310',1,'Retail Sale Id 523',0.00,449.19,720.00,496.80,47.61,'2023-01-28 14:41:22'),(542,'1','310',1,'Retail Sale Id 524',0.00,5422.83,720.00,5997.60,574.77,'2023-01-28 14:52:56'),(543,'1','310',1,'Retail Sale Id 525',0.00,904.89,720.00,1000.80,95.91,'2023-01-28 14:57:23'),(544,'1','310',1,'Retail Sale Id 526',0.00,39060.00,700.00,42000.00,2940.00,'2023-01-28 15:10:17'),(545,'1','310',1,'Retail Sale Id 527',0.00,9765.00,720.00,10800.00,1035.00,'2023-01-28 15:11:35'),(546,'1','310',1,'Retail Sale Id 528',0.00,4517.94,720.00,4996.80,478.86,'2023-01-28 15:17:04'),(547,'1','310',1,'Retail Sale Id 529',0.00,3255.00,720.00,3600.00,345.00,'2023-01-28 15:19:18'),(548,'1','310',1,'Retail Sale Id 530',0.00,3906.00,720.00,4320.00,414.00,'2023-01-28 15:24:25'),(549,'1','310',1,'Retail Sale Id 531',0.00,904.89,720.00,1000.80,95.91,'2023-01-28 15:47:04'),(550,'1','310',1,'Retail Sale Id 532',0.00,5859.00,720.00,6480.00,621.00,'2023-01-28 15:54:52'),(551,'1','310',1,'Retail Sale Id 533',0.00,3255.00,720.00,3600.00,345.00,'2023-01-28 15:59:43'),(552,'1','310',1,'Retail Sale Id 533',0.00,8137.50,720.00,9000.00,862.50,'2023-01-28 15:59:43'),(553,'1','310',1,'Retail Sale Id 534',0.00,2623.53,720.00,2901.60,278.07,'2023-01-28 16:18:39'),(554,'1','310',1,'Retail Sale Id 535',0.00,2714.67,720.00,3002.40,287.73,'2023-01-28 16:26:22'),(555,'1','310',1,'Retail Sale Id 536',0.00,132804.00,700.00,142800.00,9996.00,'2023-01-28 16:36:06'),(556,'1','310',1,'Retail Sale Id 537',0.00,8137.50,720.00,9000.00,862.50,'2023-01-28 16:41:57'),(557,'1','310',1,'Retail Sale Id 538',0.00,904.89,720.00,1000.80,95.91,'2023-01-28 16:42:40'),(558,'1','310',1,'Retail Sale Id 539',0.00,4517.94,720.00,4996.80,478.86,'2023-01-28 16:45:02'),(559,'1','310',1,'Retail Sale Id 540',0.00,1354.08,720.00,1497.60,143.52,'2023-01-28 16:46:07'),(560,'1','310',1,'Retail Sale Id 541',0.00,1992.06,720.00,2203.20,211.14,'2023-01-28 16:56:02'),(561,'1','310',1,'Retail Sale Id 542',0.00,1992.06,720.00,2203.20,211.14,'2023-01-28 16:57:03'),(562,'1','310',1,'Retail Sale Id 543',0.00,2714.67,720.00,3002.40,287.73,'2023-01-28 16:58:16'),(563,'1','310',1,'Retail Sale Id 544',0.00,1809.78,720.00,2001.60,191.82,'2023-01-28 16:59:10'),(564,'1','310',1,'Retail Sale Id 545',0.00,904.89,720.00,1000.80,95.91,'2023-01-28 17:00:54'),(565,'1','310',1,'Retail Sale Id 546',0.00,1992.06,720.00,2203.20,211.14,'2023-01-28 17:01:42'),(566,'1','310',1,'Retail Sale Id 547',0.00,904.89,720.00,1000.80,95.91,'2023-01-28 17:04:45'),(567,'1','310',1,'Retail Sale Id 548',0.00,6510.00,720.00,7200.00,690.00,'2023-01-28 17:08:21'),(568,'1','310',1,'Retail Sale Id 549',0.00,3906.00,720.00,4320.00,414.00,'2023-01-28 17:12:33'),(569,'1','310',1,'Retail Sale Id 550',0.00,3906.00,720.00,4320.00,414.00,'2023-01-28 17:17:51'),(570,'1','310',1,'Retail Sale Id 551',0.00,3255.00,720.00,3600.00,345.00,'2023-01-28 17:27:39'),(571,'1','310',1,'Retail Sale Id 551',0.00,3906.00,720.00,4320.00,414.00,'2023-01-28 17:27:39'),(572,'1','310',1,'Retail Sale Id 552',0.00,4068.75,720.00,4500.00,431.25,'2023-01-28 17:31:48'),(573,'1','310',1,'Retail Sale Id 553',0.00,3906.00,720.00,4320.00,414.00,'2023-01-28 17:36:31'),(574,'1','310',1,'Retail Sale Id 554',0.00,904.89,720.00,1000.80,95.91,'2023-01-28 17:42:01'),(575,'1','310',1,'Retail Sale Id 555',0.00,904.89,720.00,1000.80,95.91,'2023-01-28 17:45:45'),(576,'1','310',1,'Retail Sale Id 556',0.00,677.04,720.00,748.80,71.76,'2023-01-28 17:58:46'),(577,'1','310',1,'Retail Sale Id 557',0.00,1809.78,720.00,2001.60,191.82,'2023-01-28 18:00:31'),(578,'1','310',1,'Retail Sale Id 558',0.00,2258.97,720.00,2498.40,239.43,'2023-01-28 18:03:37'),(579,'1','310',1,'Retail Sale Id 559',0.00,3163.86,720.00,3499.20,335.34,'2023-01-28 18:08:27'),(580,'1','310',1,'Retail Sale Id 560',0.00,1809.78,720.00,2001.60,191.82,'2023-01-28 18:13:56'),(581,'1','310',1,'Retail Sale Id 561',0.00,904.89,720.00,1000.80,95.91,'2023-01-28 18:15:16'),(582,'1','310',1,'Retail Sale Id 561',0.00,1354.08,720.00,1497.60,143.52,'2023-01-28 18:15:16'),(583,'1','310',1,'Retail Sale Id 562',0.00,1953.00,720.00,2160.00,207.00,'2023-01-28 18:16:11'),(584,'1','310',1,'Retail Sale Id 563',0.00,2714.67,720.00,3002.40,287.73,'2023-01-28 18:26:38'),(585,'1','310',1,'Retail Sale Id 564',0.00,826.77,720.00,914.40,87.63,'2023-01-28 19:21:59'),(586,'1','310',1,'Retail Sale Id 565',0.00,39060.00,700.00,42000.00,2940.00,'2023-01-29 07:38:05'),(587,'1','310',1,'Retail Sale Id 566',0.00,8137.50,720.00,9000.00,862.50,'2023-01-29 07:56:54'),(588,'1','310',1,'Retail Sale Id 567',0.00,651.00,720.00,720.00,69.00,'2023-01-29 08:14:10'),(589,'1','310',1,'Retail Sale Id 569',0.00,904.89,720.00,1000.80,95.91,'2023-01-29 08:33:51'),(590,'1','310',1,'Retail Sale Id 570',0.00,4557.00,700.00,4900.00,343.00,'2023-01-29 08:39:08'),(591,'1','310',1,'Retail Sale Id 571',0.00,8137.50,720.00,9000.00,862.50,'2023-01-29 08:42:04'),(592,'1','310',1,'Retail Sale Id 572',0.00,3906.00,720.00,4320.00,414.00,'2023-01-29 08:51:51'),(593,'1','310',1,'Retail Sale Id 573',0.00,3977.61,720.00,4399.20,421.59,'2023-01-29 09:11:21'),(594,'1','310',1,'Retail Sale Id 574',0.00,3255.00,720.00,3600.00,345.00,'2023-01-29 09:12:46'),(595,'1','310',1,'Retail Sale Id 575',0.00,3163.86,720.00,3499.20,335.34,'2023-01-29 09:23:16'),(596,'1','310',1,'Retail Sale Id 576',0.00,32550.00,700.00,35000.00,2450.00,'2023-01-29 09:26:20'),(597,'1','310',1,'Retail Sale Id 577',0.00,32550.00,700.00,35000.00,2450.00,'2023-01-29 09:26:59'),(598,'1','310',1,'Retail Sale Id 578',0.00,32550.00,700.00,35000.00,2450.00,'2023-01-29 09:27:38'),(599,'1','310',1,'Retail Sale Id 579',0.00,2714.67,720.00,3002.40,287.73,'2023-01-29 09:29:29'),(600,'1','310',1,'Retail Sale Id 580',0.00,1809.78,720.00,2001.60,191.82,'2023-01-29 09:40:48'),(601,'1','310',1,'Retail Sale Id 581',0.00,1809.78,720.00,2001.60,191.82,'2023-01-29 09:42:12'),(602,'1','310',1,'Retail Sale Id 582',0.00,904.89,720.00,1000.80,95.91,'2023-01-29 09:43:13'),(603,'1','310',1,'Retail Sale Id 583',0.00,1354.08,720.00,1497.60,143.52,'2023-01-29 09:52:15'),(604,'1','310',1,'Retail Sale Id 584',0.00,8137.50,720.00,9000.00,862.50,'2023-01-29 09:54:34'),(605,'1','310',1,'Retail Sale Id 585',0.00,2714.67,720.00,3002.40,287.73,'2023-01-29 09:57:29'),(606,'1','310',1,'Retail Sale Id 586',0.00,3906.00,720.00,4320.00,414.00,'2023-01-29 09:58:46'),(607,'1','310',1,'Retail Sale Id 587',0.00,1809.78,720.00,2001.60,191.82,'2023-01-29 10:02:12'),(608,'1','310',1,'Retail Sale Id 588',0.00,904.89,720.00,1000.80,95.91,'2023-01-29 10:20:35'),(609,'1','310',1,'Retail Sale Id 589',0.00,3906.00,720.00,4320.00,414.00,'2023-01-29 10:21:10'),(610,'1','310',1,'Retail Sale Id 590',0.00,1354.08,720.00,1497.60,143.52,'2023-01-29 10:21:49'),(611,'1','310',1,'Retail Sale Id 591',0.00,1953.00,720.00,2160.00,207.00,'2023-01-29 10:24:22'),(612,'1','310',1,'Retail Sale Id 592',0.00,3619.56,720.00,4003.20,383.64,'2023-01-29 10:27:12'),(613,'1','310',1,'Retail Sale Id 593',0.00,3255.00,720.00,3600.00,345.00,'2023-01-29 10:29:45'),(614,'1','310',1,'Retail Sale Id 594',0.00,1809.78,720.00,2001.60,191.82,'2023-01-29 10:32:29'),(615,'1','310',1,'Retail Sale Id 595',0.00,3619.56,720.00,4003.20,383.64,'2023-01-29 10:37:53'),(616,'1','310',1,'Retail Sale Id 596',0.00,2714.67,720.00,3002.40,287.73,'2023-01-29 10:39:29'),(617,'1','310',1,'Retail Sale Id 597',0.00,904.89,720.00,1000.80,95.91,'2023-01-29 10:40:24'),(618,'1','310',1,'Retail Sale Id 598',0.00,1992.06,720.00,2203.20,211.14,'2023-01-29 10:41:49'),(619,'1','310',1,'Retail Sale Id 599',0.00,1992.06,720.00,2203.20,211.14,'2023-01-29 10:42:35'),(620,'1','310',1,'Retail Sale Id 600',0.00,3906.00,720.00,4320.00,414.00,'2023-01-29 10:43:37'),(621,'1','310',1,'Retail Sale Id 601',0.00,1953.00,720.00,2160.00,207.00,'2023-01-29 10:47:19'),(622,'1','310',1,'Retail Sale Id 602',0.00,1536.36,720.00,1699.20,162.84,'2023-01-29 10:48:40'),(623,'1','310',1,'Retail Sale Id 603',0.00,3906.00,720.00,4320.00,414.00,'2023-01-29 10:54:07'),(624,'1','310',1,'Return of Retail Sale Id 598',1992.06,0.00,720.00,-2203.20,-211.14,'2023-01-29 11:01:34'),(625,'1','310',1,'Retail Sale Id 604',0.00,4517.94,720.00,4996.80,478.86,'2023-01-29 11:05:20'),(626,'1','310',1,'Retail Sale Id 605',0.00,5859.00,700.00,6300.00,441.00,'2023-01-29 11:08:09'),(627,'1','310',1,'Retail Sale Id 606',0.00,3906.00,720.00,4320.00,414.00,'2023-01-29 11:10:10'),(628,'1','310',1,'Retail Sale Id 607',0.00,1354.08,720.00,1497.60,143.52,'2023-01-29 11:13:19'),(629,'1','310',1,'Retail Sale Id 607',0.00,1809.78,720.00,2001.60,191.82,'2023-01-29 11:13:19'),(630,'1','310',1,'Retail Sale Id 608',0.00,6510.00,720.00,7200.00,690.00,'2023-01-29 11:27:47'),(631,'1','310',1,'Retail Sale Id 609',0.00,2714.67,720.00,3002.40,287.73,'2023-01-29 11:28:39'),(632,'1','310',1,'Retail Sale Id 610',0.00,3619.56,720.00,4003.20,383.64,'2023-01-29 11:29:34'),(633,'1','310',1,'Retail Sale Id 611',0.00,32550.00,700.00,35000.00,2450.00,'2023-01-29 11:34:21'),(634,'1','310',1,'Retail Sale Id 612',0.00,32550.00,700.00,35000.00,2450.00,'2023-01-29 11:35:11'),(635,'1','310',1,'Retail Sale Id 613',0.00,3906.00,720.00,4320.00,414.00,'2023-01-29 11:37:24'),(636,'1','310',1,'Retail Sale Id 614',0.00,2408.70,720.00,2664.00,255.30,'2023-01-29 11:41:50'),(637,'1','310',1,'Retail Sale Id 615',0.00,3906.00,720.00,4320.00,414.00,'2023-01-29 11:43:54'),(638,'1','310',1,'Retail Sale Id 616',0.00,1354.08,720.00,1497.60,143.52,'2023-01-29 11:44:42'),(639,'1','310',1,'Retail Sale Id 617',0.00,3906.00,720.00,4320.00,414.00,'2023-01-29 11:54:58'),(640,'1','310',1,'Retail Sale Id 617',0.00,3906.00,720.00,4320.00,414.00,'2023-01-29 11:54:58'),(641,'1','310',1,'Retail Sale Id 618',0.00,8137.50,720.00,9000.00,862.50,'2023-01-29 11:56:47'),(642,'1','310',1,'Retail Sale Id 619',0.00,8137.50,720.00,9000.00,862.50,'2023-01-29 12:13:38'),(643,'1','310',1,'Retail Sale Id 620',0.00,996.03,720.00,1101.60,105.57,'2023-01-29 12:26:26'),(644,'1','310',1,'Retail Sale Id 621',0.00,1809.78,720.00,2001.60,191.82,'2023-01-29 12:39:33'),(645,'1','310',1,'Retail Sale Id 622',0.00,32550.00,700.00,35000.00,2450.00,'2023-01-29 12:41:56'),(646,'1','310',1,'Retail Sale Id 623',0.00,15624.00,700.00,16800.00,1176.00,'2023-01-29 12:43:13'),(647,'1','310',1,'Retail Sale Id 624',0.00,5208.00,720.00,5760.00,552.00,'2023-01-29 12:45:17'),(648,'1','310',1,'Retail Sale Id 625',0.00,3255.00,720.00,3600.00,345.00,'2023-01-29 12:52:43'),(649,'1','310',1,'Retail Sale Id 626',0.00,7161.00,720.00,7920.00,759.00,'2023-01-29 12:58:12'),(650,'1','310',1,'Retail Sale Id 627',0.00,904.89,720.00,1000.80,95.91,'2023-01-29 13:01:27'),(651,'1','310',1,'Retail Sale Id 628',0.00,8137.50,720.00,9000.00,862.50,'2023-01-29 13:19:35'),(652,'1','310',1,'Retail Sale Id 629',0.00,1809.78,720.00,2001.60,191.82,'2023-01-29 13:22:17'),(653,'1','310',1,'Retail Sale Id 630',0.00,13020.00,700.00,14000.00,980.00,'2023-01-29 14:01:06'),(654,'1','310',1,'Retail Sale Id 631',0.00,1354.08,720.00,1497.60,143.52,'2023-01-29 14:02:00'),(655,'1','310',1,'Retail Sale Id 632',0.00,1809.78,720.00,2001.60,191.82,'2023-01-29 14:04:02'),(656,'1','310',1,'Retail Sale Id 633',0.00,651.00,720.00,720.00,69.00,'2023-01-29 14:09:26'),(657,'1','310',1,'Retail Sale Id 634',0.00,1953.00,720.00,2160.00,207.00,'2023-01-29 14:24:41'),(658,'1','310',1,'Retail Sale Id 635',0.00,8137.50,720.00,9000.00,862.50,'2023-01-29 14:26:09'),(659,'1','310',1,'Retail Sale Id 636',0.00,1953.00,720.00,2160.00,207.00,'2023-01-29 14:27:49'),(660,'1','310',1,'Retail Sale Id 637',0.00,3255.00,720.00,3600.00,345.00,'2023-01-29 14:42:30'),(661,'1','310',1,'Retail Sale Id 638',0.00,3255.00,720.00,3600.00,345.00,'2023-01-29 14:51:28'),(662,'1','310',1,'Retail Sale Id 640',0.00,56962.50,700.00,61250.00,4287.50,'2023-01-29 14:59:59'),(663,'1','310',1,'Retail Sale Id 642',0.00,1178.31,720.00,1303.20,124.89,'2023-01-29 15:01:59'),(664,'1','310',1,'Retail Sale Id 643',0.00,904.89,720.00,1000.80,95.91,'2023-01-29 15:03:37'),(665,'1','310',1,'Retail Sale Id 644',0.00,8137.50,720.00,9000.00,862.50,'2023-01-29 15:12:57'),(666,'1','310',1,'Retail Sale Id 645',0.00,904.89,720.00,1000.80,95.91,'2023-01-29 15:17:01'),(667,'1','310',1,'Retail Sale Id 646',0.00,1953.00,720.00,2160.00,207.00,'2023-01-29 16:11:59'),(668,'1','310',1,'Retail Sale Id 647',0.00,1992.06,720.00,2203.20,211.14,'2023-01-29 16:12:56'),(669,'1','310',1,'Retail Sale Id 648',0.00,904.89,720.00,1000.80,95.91,'2023-01-29 16:15:56'),(670,'1','310',1,'Retail Sale Id 649',0.00,8137.50,720.00,9000.00,862.50,'2023-01-29 16:24:01'),(671,'1','310',1,'Retail Sale Id 650',0.00,1809.78,720.00,2001.60,191.82,'2023-01-29 16:25:57'),(672,'1','310',1,'Retail Sale Id 651',0.00,904.89,720.00,1