-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_308
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_308`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_308` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_308`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,4000,'',0,'22','1','308','PURCHASES','','2022-12-22 02:02:06',5,0.00,0.00,'','479','2022-12-22 02:02:06','479',0,0),(2,7000,'',0,'20','1','308','SALES','','2022-12-22 02:02:18',5,0.00,0.00,'','479','2022-12-22 02:02:18','479',0,0),(3,500,'',0,'6.1','1','308','CASH','','2022-12-22 02:02:36',5,0.00,0.00,'','479','2022-12-22 02:02:36','479',0,0),(4,8000,'',0,'24','1','308','SALARIES & WAGES','','2022-12-22 02:02:54',5,0.00,0.00,'','479','2022-12-22 02:02:54','479',0,0),(5,8001,'',0,'24','1','308','PURCHASES','','2022-12-22 02:03:11',5,0.00,0.00,'','479','2022-12-22 02:03:11','479',0,0),(6,2500,'',0,'2','1','308','ZB(LPG)1014471475','','2022-12-22 02:03:38',5,0.00,0.00,'','479','2022-12-22 02:03:38','479',0,0),(7,2501,'',0,'2','1','308','ZNB E-BILL COLLECTION :1014717','','2022-12-22 02:03:48',5,0.00,0.00,'','479','2022-12-22 02:03:48','479',0,0),(8,2502,'',0,'2','1','308','ZNB-:POS 1015965368','','2022-12-22 02:04:02',5,0.00,0.00,'','479','2022-12-22 02:04:02','479',0,0),(9,2503,'',0,'2','1','308','FID POS COLLECTION-5620141491','','2022-12-22 02:04:22',5,0.00,0.00,'','479','2022-12-22 02:04:22','479',0,0),(10,2504,'',0,'2','1','308','FB(IBAL)2023855223','','2022-12-22 02:04:31',5,0.00,0.00,'','479','2022-12-22 02:04:31','479',0,0),(11,2505,'',0,'2','1','308','E-BILLS 1015372548','','2022-12-22 02:04:58',5,0.00,0.00,'','479','2022-12-22 02:04:58','479',0,0),(12,2506,'',0,'2','1','308','E-BILLS  IBAL 1015372548','','2022-12-22 02:05:09',5,0.00,0.00,'','479','2022-12-22 02:05:09','479',0,0),(13,2507,'',0,'2','1','308','UNITY BANK-0024061656','','2022-12-22 02:05:44',5,0.00,0.00,'','479','2022-12-22 02:05:44','479',0,0),(14,2508,'',0,'2','1','308','UBA-0039769388','','2022-12-22 02:05:54',5,0.00,0.00,'','479','2022-12-22 02:05:54','479',0,0),(15,2509,'',0,'2','1','308','UBA YOLA-1021398099','','2022-12-22 02:06:04',5,0.00,0.00,'','479','2022-12-22 02:06:04','479',0,0),(16,2510,'',0,'2','1','308','UBA-1019882661','','2022-12-22 02:06:14',5,0.00,0.00,'','479','2022-12-22 02:06:14','479',0,0),(17,2511,'',0,'2','1','308','DANKANO-EBILLS:ZNB1014717618','','2022-12-22 02:06:33',5,0.00,0.00,'','479','2022-12-22 02:06:33','479',0,0),(18,2512,'',0,'2','1','308','TAJJ BANK CITY GATE:0001875361','','2022-12-22 02:07:17',5,0.00,0.00,'','479','2022-12-22 02:07:17','479',0,0),(19,2513,'',0,'2','1','308','POLARIS BANK KEBBI:4091417377','','2022-12-22 02:07:29',5,0.00,0.00,'','479','2022-12-22 02:07:29','479',0,0),(20,2514,'',0,'2','1','308','ZNB POS COLL ACCT:-1015965368','ZNB POS COLLECTION ACCOUNT','2023-01-19 17:40:46',5,0.00,0.00,'','792','2023-01-19 17:40:46','792',0,0),(21,2515,'',0,'2','1','308','UBA LPG COLL ACCT:-1020811140','UBA LPG COLLECTION ACCOUNT','2023-01-19 17:41:18',5,0.00,0.00,'','792','2023-01-19 17:41:18','792',0,0),(22,2516,'',0,'2','1','308','ZNB AA RANO NIG LTD:-101471761','ZNB AA RANO NIG LTD','2023-01-19 17:41:54',5,0.00,0.00,'','792','2023-01-19 17:41:54','792',0,0),(23,2517,'',0,'2','1','308','FID POS COLL ACCT:-5620141491','FID POS COLLECTION ACCOUNT','2023-01-19 17:42:29',5,0.00,0.00,'','792','2023-01-19 17:42:29','792',0,0),(24,2518,'',0,'2','1','308','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:19:00',5,0.00,0.00,'','792','2023-02-20 14:19:00','792',0,0),(25,2519,'',0,'2','1','308','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:28:05',5,0.00,0.00,'2023-03-14','792','2023-03-17 12:33:08','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','308','aliyu','aliyu suleja','08162151117','aliyu@gmail.co,m','minna','niger','suleja','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-23 19:48:13',5,'1017','2022-12-23 19:48:13','1017'),(2,'','1','308','MUSTAPHA AGENDA HOTEL','MUSTAPHA GAS','08065521054','aliyu@gmail.co,m','SULEJA','NIGER STATE','AGENDA HOTEL','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-24 14:37:39',5,'1017','2022-12-24 14:37:39','1017'),(3,'','1','308','DARE GAS','DARE ','08066567143','abdul.kyauta@gmail.com','SULEJA','NIGER STATE','V DIVISION','Nigeria',35500.00,0.00,0.00,'0000-00-00','2022-12-28 13:42:15',5,'1017','2022-12-28 13:42:15','1017'),(4,'','1','308','SAMDEEZ','AYOBAMI','08136179507','ogunbayowa59@gmail.com','SULEJA ','NIGER','no22 adamu yahaya close','Nigeria',142000.00,0.00,0.00,'0000-00-00','2022-12-28 14:55:12',5,'1017','2022-12-28 14:55:12','1017'),(5,'','1','308','SOLOMON GAS','EMMANUEL','07039072856','nazirlawan19@gmail.com','SULEJA','NIGER STATE','MADALLAH','Nigeria',45000.00,0.00,0.00,'0000-00-00','2023-01-10 09:03:42',5,'1017','2023-01-10 09:03:42','1017'),(6,'','1','308','CC GAS','CHINANU','08036780833','nazirlawan19@gmail.com','SULEJA','NIGER STATE','MADALLA','Nigeria',60.00,0.00,0.00,'0000-00-00','2023-01-12 08:09:12',5,'1017','2023-01-12 08:09:12','1017'),(7,'','1','308','OPERATIONAL LOSS','OPERATIONAL LOSS','08130334449','aaranosuleja2@gmail.com','SULEJA','NIGER STATE','suleja 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-15 13:15:30',5,'1017','2023-01-15 13:15:30','1017'),(8,'','1','308','AA RANO NIG. LTD','AA RANO','08130334449','aaranosuleja2@gmail.com','SULEJA','NIGER STATE','SULEJA 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-15 13:19:27',5,'1017','2023-01-15 13:19:27','1017'),(9,'','1','308','IBRAHIM GAS','IBRAHIM','09169280359','aaranosuleja2@gmail.com','SULEJA','NIGER STATE','ZUBA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-29 13:43:12',5,'1017','2023-01-29 13:43:12','1017'),(10,'','1','308','SUPREME GAS','SUPREME','07051238140','aaranosuleja2@gmail.com','SULEJA','NIGER STATE','KWANKWASHE','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-31 09:42:24',5,'1017','2023-01-31 09:42:24','1017'),(11,'','1','308','B.M. GAS','BM. GAS','07033146076','aaranosuleja2@gmail.com','ABUJA','FCT','ZUBA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-04 08:24:50',5,'1017','2023-02-04 08:24:50','1017'),(12,'','1','308','KC GAS','FRANCIS','09051176891','kenechifrancis923@gmail.com','SULEJA','NIGER STATE','ZUBA IKWA JUCTION','Nigeria',174.00,0.00,0.00,'0000-00-00','2023-02-20 13:31:35',5,'1017','2023-02-20 13:31:35','1017'),(13,'','1','308','MADAM MG','MADAM MG','08134353089','abdulkyauta1@gmail.com','SULEJA ','NIGER','MINSTER SIM','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-03-02 10:54:02',5,'1017','2023-03-02 10:54:02','1017'),(14,'','1','308','GOOD KITCHEN GAS','INNOCENT','08107707176','aaranosuleja2@gmail.com','SULEJA','NIGER STATE','PULUSA','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-03-05 10:39:15',5,'1017','2023-03-05 10:39:15','1017'),(15,'','1','308','MILANO090','IBB','09015426272','abdul.kyauta@gmail.com','SULEJA','niger','MILANOJUNCTION','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-03-13 09:23:45',5,'1017','2023-03-13 09:23:45','1017'),(16,'','1','308','MANNIRA GAS','MANNIRA','08050613705','abdul.kyauta@gmail.com','ABUJA','ABUJA','ZUBA','Nigeria',50.00,0.00,0.00,'0000-00-00','2023-03-17 15:32:33',5,'1017','2023-03-17 15:32:33','1017');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','308','1',1,'5','LPG NOZZLE 1',15454.02,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','308','1',2,'5','LPG NOZZLE 2',14385.43,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','308',1,'DAILY SALE','2022-12-23','2022-12-23 11:15:43','2022-12-24 11:15:43','1017',0.00,0.00,'1017','2022-12-23 11:47:25','1017','2022-12-23 11:47:44',10,0),('1','308',2,'DAILY SHIFT','2022-12-23','2022-12-23 11:48:41','2022-12-24 11:48:41','1017',0.00,0.00,'1017','2022-12-23 20:01:33','1017','2022-12-23 20:02:25',10,0),('1','308',3,'DAILY SHIFT','2022-12-24','2022-12-24 07:50:15','2022-12-25 07:50:15','1017',0.00,0.00,'1017','2022-12-24 19:25:49','1017','2022-12-24 19:26:06',10,0),('1','308',4,'DAILY SHIFT','2022-12-25','2022-12-25 08:20:43','2022-12-26 08:20:43','1017',0.00,0.00,'1017','2022-12-25 18:32:13','1017','2022-12-25 18:32:35',10,0),('1','308',5,'DAILY SHIFT','2022-12-26','2022-12-26 08:05:38','2022-12-27 08:05:38','1017',0.00,0.00,'1017','2022-12-26 20:55:30','1017','2022-12-26 20:55:50',10,0),('1','308',6,'DAILY SHIFT','2022-12-27','2022-12-27 07:57:57','2022-12-28 07:57:57','1017',0.00,0.00,'1017','2022-12-27 19:57:57','1017','2022-12-27 19:58:18',10,0),('1','308',7,'DAILY SHIFT','2022-12-28','2022-12-28 07:41:19','2022-12-29 07:41:19','1017',0.00,0.00,'1017','2022-12-28 19:11:49','1017','2022-12-28 19:12:13',10,0),('1','308',8,'DAILY SHIFT','2022-12-29','2022-12-29 08:02:19','2022-12-30 08:02:19','1017',0.00,0.00,'1017','2022-12-29 19:26:04','1017','2022-12-29 19:26:30',10,0),('1','308',9,'DAILY SHIFT','2022-12-30','2022-12-30 08:30:29','2022-12-31 08:30:29','1017',0.00,0.00,'1017','2022-12-30 19:15:35','1017','2022-12-30 19:15:59',10,0),('1','308',10,'DAILY SHIFT','2022-12-31','2022-12-31 07:53:51','2023-01-01 07:53:51','1017',0.00,0.00,'1017','2022-12-31 19:16:56','1017','2022-12-31 19:17:20',10,0),('1','308',11,'DAILY SHIFT','2023-01-01','2023-01-01 07:48:05','2023-01-02 07:48:05','1017',0.00,0.00,'1017','2023-01-01 19:45:43','1017','2023-01-01 19:46:17',10,0),('1','308',12,'DAILY SHIFT','2023-01-02','2023-01-02 09:20:23','2023-01-03 09:20:23','1017',0.00,0.00,'1017','2023-01-02 19:28:24','1017','2023-01-02 19:29:04',10,0),('1','308',13,'DAILY SHIFT','2023-01-03','2023-01-03 07:55:09','2023-01-04 07:55:09','1017',0.00,0.00,'1017','2023-01-03 19:13:42','1017','2023-01-03 19:14:41',10,0),('1','308',14,'DAILY SHIFT','2023-01-04','2023-01-04 08:10:44','2023-01-05 08:10:44','1017',0.00,0.00,'1017','2023-01-04 19:37:22','1017','2023-01-04 19:37:46',10,0),('1','308',15,'DAILY SHIFT','2023-01-05','2023-01-05 07:12:10','2023-01-06 07:12:10','1017',0.00,0.00,'1017','2023-01-05 19:48:01','1017','2023-01-05 19:48:23',10,0),('1','308',16,'DAILY SHIFT','2023-01-06','2023-01-06 08:14:47','2023-01-07 08:14:47','1017',0.00,0.00,'1017','2023-01-06 19:51:42','1017','2023-01-06 19:52:48',10,0),('1','308',17,'DAILY SHIFT','2023-01-07','2023-01-07 07:16:10','2023-01-08 07:16:10','1017',0.00,0.00,'1017','2023-01-07 19:25:59','1017','2023-01-07 19:26:28',10,0),('1','308',18,'DAILY SHIFT','2023-01-08','2023-01-08 07:46:47','2023-01-09 07:46:47','1017',0.00,0.00,'1017','2023-01-08 19:13:34','1017','2023-01-08 19:13:55',10,0),('1','308',19,'DAILY SHIFT','2023-01-09','2023-01-09 08:01:20','2023-01-10 08:01:20','1017',0.00,0.00,'1017','2023-01-09 19:30:40','1017','2023-01-09 19:31:05',10,0),('1','308',20,'DAILY SHIFT','2023-01-10','2023-01-10 07:03:02','2023-01-11 07:03:02','1017',0.00,0.00,'1017','2023-01-10 19:39:52','1017','2023-01-10 19:40:12',10,0),('1','308',21,'DAILY SHIFT','2023-01-11','2023-01-11 06:58:09','2023-01-12 06:58:09','1017',0.00,0.00,'1017','2023-01-11 20:10:36','1017','2023-01-11 20:10:58',10,0),('1','308',22,'DAILY SHIFT','2023-01-12','2023-01-12 07:10:34','2023-01-13 07:10:34','1017',0.00,0.00,'1017','2023-01-12 20:04:13','1017','2023-01-12 20:04:38',10,0),('1','308',23,'DAILY SHIFT','2023-01-13','2023-01-13 07:24:56','2023-01-14 07:24:56','1017',0.00,0.00,'1017','2023-01-13 20:20:45','1017','2023-01-13 20:21:09',10,0),('1','308',24,'DAILY SHIFT','2023-01-14','2023-01-14 07:12:43','2023-01-15 07:12:43','1017',0.00,0.00,'1017','2023-01-14 19:40:31','1017','2023-01-14 19:40:46',10,0),('1','308',25,'DAILY SHIFT','2023-01-15','2023-01-15 06:55:52','2023-01-16 06:55:52','1017',0.00,0.00,'1017','2023-01-15 11:28:11','1017','2023-01-15 11:28:30',10,0),('1','308',26,'OPERATIONAL LOSS','2023-01-15','2023-01-15 13:11:22','2023-01-16 13:11:22','1017',0.00,0.00,'1017','2023-01-15 13:22:35','1017','2023-01-15 13:23:02',10,0),('1','308',27,'DAILY SHIFT','2023-01-15','2023-01-15 14:02:52','2023-01-16 14:02:52','1017',0.00,0.00,'1017','2023-01-15 20:22:30','1017','2023-01-15 20:22:58',10,0),('1','308',28,'DAILY SHIFT','2023-01-16','2023-01-16 07:25:04','2023-01-17 07:25:04','1017',0.00,0.00,'1017','2023-01-16 19:33:42','1017','2023-01-16 19:34:29',10,0),('1','308',29,'DAILY SHIFT','2023-01-17','2023-01-17 07:25:48','2023-01-18 07:25:48','1017',0.00,0.00,'1017','2023-01-17 19:42:58','1017','2023-01-17 19:43:15',10,0),('1','308',30,'DAILY SHIFT','2023-01-18','2023-01-18 07:12:21','2023-01-19 07:12:21','1017',0.00,0.00,'1017','2023-01-18 19:43:28','1017','2023-01-18 19:44:07',10,0),('1','308',31,'DAILY SHIFT','2023-01-19','2023-01-19 07:08:11','2023-01-20 07:08:11','1017',0.00,0.00,'1017','2023-01-19 19:48:30','1017','2023-01-19 19:48:55',10,0),('1','308',32,'DAILY SHIFT','2023-01-20','2023-01-20 07:21:15','2023-01-21 07:21:15','1017',0.00,0.00,'1017','2023-01-20 19:45:22','1017','2023-01-20 19:45:46',10,0),('1','308',33,'DAILY SHIFT','2023-01-21','2023-01-21 07:28:56','2023-01-22 07:28:56','1017',0.00,0.00,'1017','2023-01-21 19:44:53','1017','2023-01-21 19:45:21',10,0),('1','308',34,'DAILY SHIFT','2023-01-22','2023-01-22 07:16:10','2023-01-23 07:16:10','1017',0.00,0.00,'1017','2023-01-22 20:00:09','1017','2023-01-22 20:00:40',10,0),('1','308',35,'DAILY SHIFT','2023-01-23','2023-01-23 07:27:21','2023-01-24 07:27:21','1017',0.00,0.00,'1017','2023-01-23 20:21:42','1017','2023-01-23 20:22:20',10,0),('1','308',36,'DAILY SHIFT','2023-01-24','2023-01-24 07:26:12','2023-01-25 07:26:12','1017',0.00,0.00,'1017','2023-01-24 19:56:31','1017','2023-01-24 19:56:53',10,0),('1','308',37,'DAILY SHIFT','2023-01-25','2023-01-25 07:26:46','2023-01-26 07:26:46','1017',0.00,0.00,'1017','2023-01-25 19:19:44','1017','2023-01-25 19:20:05',10,0),('1','308',38,'DAILY SHIFT','2023-01-26','2023-01-26 07:20:54','2023-01-27 07:20:54','1017',0.00,0.00,'1017','2023-01-26 20:28:53','1017','2023-01-26 20:29:51',10,0),('1','308',39,'DAILY SHIFT','2023-01-27','2023-01-27 07:24:19','2023-01-28 07:24:19','1017',0.00,0.00,'1017','2023-01-27 19:19:57','1017','2023-01-27 19:20:17',10,0),('1','308',40,'DAILY SHIFT','2023-01-28','2023-01-28 07:12:24','2023-01-29 07:12:24','1017',0.00,0.00,'1017','2023-01-28 19:24:09','1017','2023-01-28 19:24:29',10,0),('1','308',41,'DAILY SHIFT','2023-01-29','2023-01-29 07:29:26','2023-01-30 07:29:26','1017',0.00,0.00,'1017','2023-01-29 19:46:02','1017','2023-01-29 19:46:22',10,0),('1','308',42,'DAILY SHIFT','2023-01-30','2023-01-30 07:20:14','2023-01-31 07:20:14','1017',0.00,0.00,'1017','2023-01-30 19:33:31','1017','2023-01-30 19:33:50',10,0),('1','308',43,'DAILY SHIFT','2023-01-31','2023-01-31 07:14:35','2023-02-01 07:14:35','1017',0.00,0.00,'1017','2023-01-31 19:46:52','1017','2023-01-31 19:47:11',10,0),('1','308',44,'DAILY SHIFT','2023-02-01','2023-02-01 07:23:44','2023-02-02 07:23:44','1017',0.00,0.00,'1017','2023-02-01 11:30:13','1017','2023-02-01 11:30:29',10,0),('1','308',45,'DAILY SHIFT','2023-02-01','2023-02-01 11:31:13','2023-02-02 11:31:13','1017',0.00,0.00,'1017','2023-02-01 11:37:25','1017','2023-02-01 11:38:13',10,0),('1','308',46,'DAILY SHIFT','2023-02-01','2023-02-01 12:26:08','2023-02-02 12:26:08','1017',0.00,0.00,'1017','2023-02-01 20:25:13','1017','2023-02-01 20:25:36',10,0),('1','308',47,'DAILY SHIFT','2023-02-02','2023-02-02 07:06:16','2023-02-03 07:06:16','1017',0.00,0.00,'1017','2023-02-02 19:47:53','1017','2023-02-02 19:48:09',10,0),('1','308',48,'DAILY SHIFT','2023-02-03','2023-02-03 07:44:15','2023-02-04 07:44:15','1017',0.00,0.00,'1017','2023-02-03 19:34:08','1017','2023-02-03 19:34:36',10,0),('1','308',49,'DAILY SHIFT','2023-02-04','2023-02-04 07:42:40','2023-02-05 07:42:40','1017',0.00,0.00,'1017','2023-02-04 19:50:39','1017','2023-02-04 19:50:54',10,0),('1','308',50,'DAILY SHIFT','2023-02-05','2023-02-05 07:46:58','2023-02-06 07:46:58','1017',0.00,0.00,'1017','2023-02-05 19:21:52','1017','2023-02-05 19:22:06',10,0),('1','308',51,'DAILY SHIFT','2023-02-06','2023-02-06 07:56:56','2023-02-07 07:56:56','1017',0.00,0.00,'1017','2023-02-06 19:13:00','1017','2023-02-06 19:13:29',10,0),('1','308',52,'DAILY SHIFT','2023-02-07','2023-02-07 07:51:10','2023-02-08 07:51:10','1017',0.00,0.00,'1017','2023-02-07 20:00:38','1017','2023-02-07 20:00:54',10,0),('1','308',53,'DAILY SHIFT','2023-02-08','2023-02-08 07:38:14','2023-02-09 07:38:14','1017',0.00,0.00,'1017','2023-02-08 18:45:11','1017','2023-02-08 18:45:28',10,0),('1','308',54,'DAILY SHIFT','2023-02-09','2023-02-09 07:24:32','2023-02-10 07:24:32','1017',0.00,0.00,'1017','2023-02-09 19:47:13','1017','2023-02-09 19:47:41',10,0),('1','308',55,'DAILY SHIFT','2023-02-10','2023-02-10 08:36:09','2023-02-11 08:36:09','1017',0.00,0.00,'1017','2023-02-10 19:38:28','1017','2023-02-10 19:38:49',10,0),('1','308',56,'DAILY SHIFT','2023-02-11','2023-02-11 07:52:04','2023-02-12 07:52:04','1017',0.00,0.00,'1017','2023-02-11 19:16:46','1017','2023-02-11 19:17:05',10,0),('1','308',57,'DAILY SHIFT','2023-02-12','2023-02-12 07:39:21','2023-02-13 07:39:21','1017',0.00,0.00,'1017','2023-02-12 18:16:23','1017','2023-02-12 18:16:40',10,0),('1','308',58,'DAILY SHIFT','2023-02-15','2023-02-15 17:49:24','2023-02-16 17:49:24','1017',0.00,0.00,'1017','2023-02-15 19:34:18','1017','2023-02-15 19:34:37',10,0),('1','308',59,'DAILY SHIFT','2023-02-16','2023-02-16 07:13:57','2023-02-17 07:13:57','1017',0.00,0.00,'1017','2023-02-16 21:09:46','1017','2023-02-16 21:10:07',10,0),('1','308',60,'DAILY SHIFT','2023-02-17','2023-02-17 07:36:11','2023-02-18 07:36:11','1017',0.00,0.00,'1017','2023-02-17 19:15:17','1017','2023-02-17 19:15:37',10,0),('1','308',61,'DAILY SHIFT','2023-02-18','2023-02-18 07:19:18','2023-02-19 07:19:18','1017',0.00,0.00,'1017','2023-02-18 20:12:49','1017','2023-02-18 20:13:15',10,0),('1','308',62,'DAILY SHIFT','2023-02-19','2023-02-19 07:37:35','2023-02-20 07:37:35','1017',0.00,0.00,'1017','2023-02-19 19:48:19','1017','2023-02-19 19:48:42',10,0),('1','308',63,'DAILY SHIFT','2023-02-20','2023-02-20 07:50:43','2023-02-21 07:50:43','1017',0.00,0.00,'1017','2023-02-20 19:48:13','1017','2023-02-20 19:48:33',10,0),('1','308',64,'DAILY SHIFT','2023-02-21','2023-02-21 07:08:28','2023-02-22 07:08:28','1017',0.00,0.00,'1017','2023-02-21 19:30:19','1017','2023-02-21 19:30:35',10,0),('1','308',65,'DAILY SHIFT','2023-02-22','2023-02-22 06:59:24','2023-02-23 06:59:24','1017',0.00,0.00,'1017','2023-02-22 19:56:37','1017','2023-02-22 19:56:53',10,0),('1','308',66,'DAILY SHIFT','2023-02-23','2023-02-23 07:44:07','2023-02-24 07:44:07','1017',0.00,0.00,'1017','2023-02-23 19:07:31','1017','2023-02-23 19:09:28',10,0),('1','308',67,'DAILY SHIFT','2023-02-24','2023-02-24 06:39:24','2023-02-25 06:39:24','1017',0.00,0.00,'1017','2023-02-24 19:56:17','1017','2023-02-24 19:56:33',10,0),('1','308',68,'DAILY SHIFT','2023-02-26','2023-02-26 07:27:20','2023-02-27 07:27:20','1017',0.00,0.00,'1017','2023-02-26 19:13:31','1017','2023-02-26 19:13:48',10,0),('1','308',69,'DAILY SHIFT','2023-02-27','2023-02-27 07:35:53','2023-02-28 07:35:53','1017',0.00,0.00,'1017','2023-02-27 19:26:21','1017','2023-02-27 19:26:40',10,0),('1','308',70,'DAILY SHIFT','2023-02-28','2023-02-28 07:45:28','2023-03-01 07:45:28','1017',0.00,0.00,'1017','2023-02-28 19:14:39','1017','2023-02-28 19:15:01',10,0),('1','308',71,'DAILY SHIFT','2023-03-01','2023-03-01 07:18:43','2023-03-02 07:18:43','1017',0.00,0.00,'1017','2023-03-01 19:35:31','1017','2023-03-01 19:35:51',10,0),('1','308',72,'DAILY SHIFT','2023-03-02','2023-03-02 07:01:03','2023-03-03 07:01:03','1017',0.00,0.00,'1017','2023-03-02 21:08:28','1017','2023-03-02 21:08:47',10,0),('1','308',73,'DAILY SHIFT','2023-03-03','2023-03-03 06:22:17','2023-03-04 06:22:17','1017',0.00,0.00,'1017','2023-03-03 19:53:08','1017','2023-03-03 19:53:29',10,0),('1','308',74,'DAILY SHIFT','2023-03-04','2023-03-04 07:10:40','2023-03-05 07:10:40','1017',0.00,0.00,'1017','2023-03-04 20:28:34','1017','2023-03-04 20:28:56',10,0),('1','308',75,'DAILY SHIFT','2023-03-05','2023-03-05 07:07:25','2023-03-06 07:07:25','1017',0.00,0.00,'1017','2023-03-05 20:53:27','1017','2023-03-05 20:53:57',10,0),('1','308',76,'DAILY SHIFT','2023-03-06','2023-03-06 07:40:12','2023-03-07 07:40:12','1017',0.00,0.00,'1017','2023-03-06 19:49:51','1017','2023-03-06 19:50:16',10,0),('1','308',77,'DAILY SHIFT','2023-03-07','2023-03-07 07:15:56','2023-03-08 07:15:56','1017',0.00,0.00,'1017','2023-03-07 20:30:27','1017','2023-03-07 20:30:53',10,0),('1','308',78,'DAILY SHIFT','2023-03-08','2023-03-08 08:18:37','2023-03-09 08:18:37','1017',0.00,0.00,'1017','2023-03-08 19:28:53','1017','2023-03-08 19:29:09',10,0),('1','308',79,'DAILY SHIFT','2023-03-09','2023-03-09 07:20:28','2023-03-10 07:20:28','1017',0.00,0.00,'1017','2023-03-09 19:30:39','1017','2023-03-09 19:31:00',10,0),('1','308',80,'DAILY SHIFT','2023-03-10','2023-03-10 07:26:17','2023-03-11 07:26:17','1017',0.00,0.00,'1017','2023-03-10 19:34:10','1017','2023-03-10 19:34:28',10,0),('1','308',81,'DAILY SHIFT','2023-03-11','2023-03-11 07:28:31','2023-03-12 07:28:31','1017',0.00,0.00,'1017','2023-03-11 19:05:58','1017','2023-03-11 19:06:16',10,0),('1','308',82,'DAILY SHIFT','2023-03-12','2023-03-12 07:10:10','2023-03-13 07:10:10','1017',0.00,0.00,'1017','2023-03-12 19:28:54','1017','2023-03-12 19:29:19',10,0),('1','308',83,'DAILY SHIFT','2023-03-13','2023-03-13 07:19:22','2023-03-14 07:19:22','1017',0.00,0.00,'1017','2023-03-13 11:38:52','1017','2023-03-13 11:39:11',10,0),('1','308',84,'OPERATIONAL LOSS','2023-03-13','2023-03-13 11:40:17','2023-03-14 11:40:17','1017',0.00,0.00,'1017','2023-03-13 11:45:05','1017','2023-03-13 11:45:23',10,0),('1','308',85,'DAILY SHIFT','2023-03-13','2023-03-13 13:13:01','2023-03-14 13:13:01','1017',0.00,0.00,'1017','2023-03-13 19:32:29','1017','2023-03-13 19:32:50',10,0),('1','308',86,'DAILY SHIFT','2023-03-14','2023-03-14 06:27:19','2023-03-15 06:27:19','1017',0.00,0.00,'1017','2023-03-14 19:27:56','1017','2023-03-14 19:28:14',10,0),('1','308',87,'DAILY SHIFT','2023-03-15','2023-03-15 07:10:44','2023-03-16 07:10:44','1017',0.00,0.00,'1017','2023-03-15 19:27:11','1017','2023-03-15 19:27:28',10,0),('1','308',88,'DAILY SHIFT','2023-03-16','2023-03-16 07:20:39','2023-03-17 07:20:39','1017',0.00,0.00,'1017','2023-03-16 19:32:54','1017','2023-03-16 19:33:12',10,0),('1','308',89,'DAILY SHIFT','2023-03-17','2023-03-17 06:50:31','2023-03-18 06:50:31','1017',0.00,0.00,'1017','2023-03-17 19:41:22','1017','2023-03-17 19:41:46',10,0),('1','308',90,'DAILY SHIFT','2023-03-19','2023-03-19 07:06:41','2023-03-20 07:06:41','1017',0.00,0.00,'1017','2023-03-19 19:16:29','1017','2023-03-19 19:16:52',10,0),('1','308',91,'DAILY SHIFT','2023-03-20','2023-03-20 08:08:42','2023-03-21 08:08:42','1017',0.00,0.00,'1017','2023-03-20 19:19:10','1017','2023-03-20 19:19:30',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=183 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','308','1','1',1,'1','1',0.00,1.00,0.00,0.00,1.00,770.00,0.00,0.00,0.00),('1','308','1','1',2,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','308','1','2',3,'1','1',1.00,7.00,0.00,0.00,6.00,4620.00,0.00,0.00,0.00),('1','308','1','2',4,'2','1',0.00,67.30,0.00,0.00,67.30,49129.00,0.00,0.00,0.00),('1','308','1','3',5,'1','1',7.00,261.79,0.00,0.00,254.79,196188.30,0.00,0.00,0.00),('1','308','1','3',6,'2','1',67.30,120.30,0.00,0.00,53.00,37630.00,0.00,0.00,0.00),('1','308','1','4',7,'1','1',261.79,346.88,0.00,0.00,85.09,65519.30,0.00,0.00,0.00),('1','308','1','4',8,'2','1',120.30,120.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','308','1','5',9,'1','1',346.88,397.47,0.00,0.00,50.59,38954.30,0.00,0.00,0.00),('1','308','1','5',10,'2','1',120.30,120.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','308','1','6',11,'1','1',397.47,458.33,0.00,0.00,60.86,46862.20,0.00,0.00,0.00),('1','308','1','6',12,'2','1',120.30,170.30,0.00,0.00,50.00,35500.00,0.00,0.00,0.00),('1','308','1','7',13,'1','1',458.33,515.33,0.00,0.00,57.00,43890.00,0.00,0.00,0.00),('1','308','1','7',14,'2','1',170.30,420.30,0.00,0.00,250.00,177500.00,0.00,0.00,0.00),('1','308','1','8',15,'1','1',515.33,561.64,0.00,0.00,46.31,35658.70,0.00,0.00,0.00),('1','308','1','8',16,'2','1',420.30,420.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','308','1','9',17,'1','1',561.64,596.59,0.00,0.00,34.95,26911.50,0.00,0.00,0.00),('1','308','1','9',18,'2','1',420.30,520.30,0.00,0.00,100.00,71000.00,0.00,0.00,0.00),('1','308','1','10',19,'1','1',596.59,732.30,0.00,0.00,135.71,104496.70,0.00,0.00,0.00),('1','308','1','10',20,'2','1',520.30,530.30,0.00,0.00,10.00,7100.00,0.00,0.00,0.00),('1','308','1','11',21,'1','1',732.30,822.51,0.00,0.00,90.21,69461.70,0.00,0.00,0.00),('1','308','1','11',22,'2','1',530.30,580.30,0.00,0.00,50.00,35500.00,0.00,0.00,0.00),('1','308','1','12',23,'1','1',822.51,943.13,0.00,0.00,120.62,92877.40,0.00,0.00,0.00),('1','308','1','12',24,'2','1',580.30,630.30,0.00,0.00,50.00,35500.00,0.00,0.00,0.00),('1','308','1','13',25,'1','1',943.13,1057.97,0.00,0.00,114.84,88426.80,0.00,0.00,0.00),('1','308','1','13',26,'2','1',630.30,880.30,0.00,0.00,250.00,177500.00,0.00,0.00,0.00),('1','308','1','14',27,'1','1',1057.97,1150.95,0.00,0.00,92.98,71594.60,0.00,0.00,0.00),('1','308','1','14',28,'2','1',880.30,880.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','308','1','15',29,'1','1',1150.95,1295.53,0.00,0.00,144.58,111326.60,0.00,0.00,0.00),('1','308','1','15',30,'2','1',880.30,947.80,0.00,0.00,67.50,47925.00,0.00,0.00,0.00),('1','308','1','16',31,'1','1',1295.53,1450.61,0.00,0.00,155.08,119411.60,0.00,0.00,0.00),('1','308','1','16',32,'2','1',947.80,947.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','308','1','17',33,'1','1',1450.61,1599.22,0.00,0.00,148.61,114429.70,0.00,0.00,0.00),('1','308','1','17',34,'2','1',947.80,1002.80,0.00,0.00,55.00,39050.00,0.00,0.00,0.00),('1','308','1','18',35,'1','1',1599.22,1832.56,0.00,0.00,233.34,179671.80,0.00,0.00,0.00),('1','308','1','18',36,'2','1',1002.80,1002.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','308','1','19',37,'1','1',1832.56,2086.08,0.00,0.00,253.52,195210.40,0.00,0.00,0.00),('1','308','1','19',38,'2','1',1002.80,1052.80,0.00,0.00,50.00,35500.00,0.00,0.00,0.00),('1','308','1','20',39,'1','1',2086.08,2230.35,0.00,0.00,144.27,111087.90,0.00,0.00,0.00),('1','308','1','20',40,'2','1',1052.80,1160.30,0.00,0.00,107.50,76325.00,0.00,0.00,0.00),('1','308','1','21',41,'1','1',2230.35,2420.96,0.00,0.00,190.61,145365.20,0.00,0.00,0.00),('1','308','1','21',42,'2','1',1160.30,1420.30,0.00,0.00,260.00,184600.00,0.00,0.00,0.00),('1','308','1','22',43,'1','1',2420.96,2674.54,0.00,0.00,253.58,192740.80,0.00,0.00,0.00),('1','308','1','22',44,'2','1',1420.30,1554.82,0.00,0.00,134.52,95509.20,0.00,0.00,0.00),('1','308','1','23',45,'1','1',2674.54,2818.98,0.00,0.00,144.44,109774.40,0.00,0.00,0.00),('1','308','1','23',46,'2','1',1554.82,1639.82,0.00,0.00,85.00,60350.00,0.00,0.00,0.00),('1','308','1','24',47,'1','1',2818.98,3051.21,0.00,0.00,232.23,176494.80,0.00,0.00,0.00),('1','308','1','24',48,'2','1',1639.82,1743.32,0.00,0.00,103.50,73485.00,0.00,0.00,0.00),('1','308','1','25',49,'1','1',3051.21,3116.91,0.00,0.00,65.70,49932.00,0.00,0.00,0.00),('1','308','1','25',50,'2','1',1743.32,1774.71,0.00,0.00,31.39,22286.90,0.00,0.00,0.00),('1','308','1','26',51,'1','1',3116.91,3116.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','308','1','26',52,'2','1',1774.71,1774.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','308','1','27',53,'1','1',3116.91,3240.15,0.00,0.00,123.24,93662.40,0.00,0.00,0.00),('1','308','1','27',54,'2','1',1774.71,1818.32,0.00,0.00,43.61,30963.10,0.00,0.00,0.00),('1','308','1','28',55,'1','1',3240.15,3459.11,0.00,0.00,218.96,163478.20,0.00,0.00,0.00),('1','308','1','28',56,'2','1',1818.32,1919.32,0.00,0.00,101.00,71710.00,0.00,0.00,0.00),('1','308','1','29',57,'1','1',3459.11,3636.77,0.00,0.00,177.66,131468.40,0.00,0.00,0.00),('1','308','1','29',58,'2','1',1919.32,2163.32,0.00,0.00,244.00,173240.00,0.00,0.00,0.00),('1','308','1','30',59,'1','1',3636.77,3876.76,0.00,0.00,239.99,177592.60,0.00,0.00,0.00),('1','308','1','30',60,'2','1',2163.32,2231.32,0.00,0.00,68.00,48280.00,0.00,0.00,0.00),('1','308','1','31',61,'1','1',3876.76,4047.84,0.00,0.00,171.08,126599.20,0.00,0.00,0.00),('1','308','1','31',62,'2','1',2231.32,2256.32,0.00,0.00,25.00,17750.00,0.00,0.00,0.00),('1','308','1','32',63,'1','1',4047.84,4216.61,0.00,0.00,168.77,124889.80,0.00,0.00,0.00),('1','308','1','32',64,'2','1',2256.32,2326.32,0.00,0.00,70.00,49700.00,0.00,0.00,0.00),('1','308','1','33',65,'1','1',4216.61,4398.86,0.00,0.00,182.25,134865.00,0.00,0.00,0.00),('1','308','1','33',66,'2','1',2326.32,2413.49,0.00,0.00,87.17,61890.70,0.00,0.00,0.00),('1','308','1','34',67,'1','1',4398.86,4709.62,0.00,0.00,310.76,229962.40,0.00,0.00,0.00),('1','308','1','34',68,'2','1',2413.49,2468.49,0.00,0.00,55.00,38500.00,0.00,0.00,0.00),('1','308','1','35',69,'1','1',4709.62,4911.12,0.00,0.00,201.50,149110.00,0.00,0.00,0.00),('1','308','1','35',70,'2','1',2468.49,2492.99,0.00,0.00,24.50,17150.00,0.00,0.00,0.00),('1','308','1','36',71,'1','1',4911.12,5088.00,0.00,0.00,176.88,130891.20,0.00,0.00,0.00),('1','308','1','36',72,'2','1',2492.99,2597.99,0.00,0.00,105.00,73700.00,0.00,0.00,0.00),('1','308','1','37',73,'1','1',5088.00,5255.94,0.00,0.00,167.94,124285.60,0.00,0.00,0.00),('1','308','1','37',74,'2','1',2597.99,2697.99,0.00,0.00,100.00,70000.00,0.00,0.00,0.00),('1','308','1','38',75,'1','1',5255.94,5425.14,0.00,0.00,169.20,125208.00,0.00,0.00,0.00),('1','308','1','38',76,'2','1',2697.99,2727.99,0.00,0.00,30.00,21000.00,0.00,0.00,0.00),('1','308','1','39',77,'1','1',5425.14,5537.34,0.00,0.00,112.20,83028.00,0.00,0.00,0.00),('1','308','1','39',78,'2','1',2727.99,2789.71,0.00,0.00,61.72,43204.00,0.00,0.00,0.00),('1','308','1','40',79,'1','1',5537.34,5747.46,0.00,0.00,210.12,155488.80,0.00,0.00,0.00),('1','308','1','40',80,'2','1',2789.71,2834.71,0.00,0.00,45.00,31500.00,0.00,0.00,0.00),('1','308','1','41',81,'1','1',5747.46,5940.20,0.00,0.00,192.74,142627.60,0.00,0.00,0.00),('1','308','1','41',82,'2','1',2834.71,2964.71,0.00,0.00,130.00,91000.00,0.00,0.00,0.00),('1','308','1','42',83,'1','1',5940.20,6103.57,0.00,0.00,163.37,120893.80,0.00,0.00,0.00),('1','308','1','42',84,'2','1',2964.71,3034.71,0.00,0.00,70.00,49000.00,0.00,0.00,0.00),('1','308','1','43',85,'1','1',6103.57,6239.04,0.00,0.00,135.47,100247.80,0.00,0.00,0.00),('1','308','1','43',86,'2','1',3034.71,3484.71,0.00,0.00,450.00,315000.00,0.00,0.00,0.00),('1','308','1','44',87,'1','1',6239.04,6307.56,0.00,0.00,68.52,50704.80,0.00,0.00,0.00),('1','308','1','44',88,'2','1',3484.71,3596.86,0.00,0.00,112.15,78505.00,0.00,0.00,0.00),('1','308','1','45',89,'1','1',6307.56,6307.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','308','1','45',90,'2','1',3596.86,3596.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','308','1','46',91,'1','1',6307.56,6493.24,0.00,0.00,185.68,137403.20,0.00,0.00,0.00),('1','308','1','46',92,'2','1',3596.86,3596.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','308','1','47',93,'1','1',6493.24,6671.86,0.00,0.00,178.62,132178.80,0.00,0.00,0.00),('1','308','1','47',94,'2','1',3596.86,3691.86,0.00,0.00,95.00,66500.00,0.00,0.00,0.00),('1','308','1','48',95,'1','1',6671.86,6853.11,0.00,0.00,181.25,134125.00,0.00,0.00,0.00),('1','308','1','48',96,'2','1',3691.86,3716.86,0.00,0.00,25.00,17500.00,0.00,0.00,0.00),('1','308','1','49',97,'1','1',6853.11,7213.18,0.00,0.00,360.07,266451.80,0.00,0.00,0.00),('1','308','1','49',98,'2','1',3716.86,4094.86,0.00,0.00,378.00,264600.00,0.00,0.00,0.00),('1','308','1','50',99,'1','1',7213.18,7487.75,0.00,0.00,274.57,203181.80,0.00,0.00,0.00),('1','308','1','50',100,'2','1',4094.86,4119.86,0.00,0.00,25.00,17500.00,0.00,0.00,0.00),('1','308','1','51',101,'1','1',7487.75,7646.24,0.00,0.00,158.49,117282.60,0.00,0.00,0.00),('1','308','1','51',102,'2','1',4119.86,4395.58,0.00,0.00,275.72,193004.00,0.00,0.00,0.00),('1','308','1','52',103,'1','1',7646.24,7881.43,0.00,0.00,235.19,174040.60,0.00,0.00,0.00),('1','308','1','52',104,'2','1',4395.58,4865.58,0.00,0.00,470.00,329000.00,0.00,0.00,0.00),('1','308','1','53',105,'1','1',7881.43,8041.88,0.00,0.00,160.45,118733.00,0.00,0.00,0.00),('1','308','1','53',106,'2','1',4865.58,4865.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','308','1','54',107,'1','1',8041.88,8136.55,0.00,0.00,94.67,70055.80,0.00,0.00,0.00),('1','308','1','54',108,'2','1',4865.58,4865.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','308','1','55',109,'1','1',8136.55,8272.47,0.00,0.00,135.92,100580.80,0.00,0.00,0.00),('1','308','1','55',110,'2','1',4865.58,4945.58,0.00,0.00,80.00,54400.00,0.00,0.00,0.00),('1','308','1','56',111,'1','1',8272.47,8532.21,0.00,0.00,259.74,192207.60,0.00,0.00,0.00),('1','308','1','56',112,'2','1',4945.58,5396.58,0.00,0.00,451.00,306680.00,0.00,0.00,0.00),('1','308','1','57',113,'1','1',8532.21,8742.11,0.00,0.00,209.90,155326.00,0.00,0.00,0.00),('1','308','1','57',114,'2','1',5396.58,5596.58,0.00,0.00,200.00,136000.00,0.00,0.00,0.00),('1','308','1','58',115,'1','1',8742.11,8806.85,0.00,0.00,64.74,47907.60,0.00,0.00,0.00),('1','308','1','58',116,'2','1',5596.58,5606.58,0.00,0.00,10.00,6800.00,0.00,0.00,0.00),('1','308','1','59',117,'1','1',8806.85,8954.11,0.00,0.00,147.26,108972.40,0.00,0.00,0.00),('1','308','1','59',118,'2','1',5606.58,5701.58,0.00,0.00,95.00,64600.00,0.00,0.00,0.00),('1','308','1','60',119,'1','1',8954.11,9184.89,0.00,0.00,230.78,170777.20,0.00,0.00,0.00),('1','308','1','60',120,'2','1',5701.58,5718.78,0.00,0.00,17.20,11696.00,0.00,0.00,0.00),('1','308','1','61',121,'1','1',9184.89,9408.33,0.00,0.00,223.44,165345.60,0.00,0.00,0.00),('1','308','1','61',122,'2','1',5718.78,5819.31,0.00,0.00,100.53,68360.40,0.00,0.00,0.00),('1','308','1','62',123,'1','1',9408.33,9642.27,0.00,0.00,233.94,173115.60,0.00,0.00,0.00),('1','308','1','62',124,'2','1',5819.31,6084.61,0.00,0.00,265.30,180404.00,0.00,0.00,0.00),('1','308','1','63',125,'1','1',9642.27,9874.44,0.00,0.00,232.17,170877.12,0.00,0.00,0.00),('1','308','1','63',126,'2','1',6084.61,6533.61,0.00,0.00,449.00,305320.00,0.00,0.00,0.00),('1','308','1','64',127,'1','1',9874.44,10147.08,0.00,0.00,272.64,200663.04,0.00,0.00,0.00),('1','308','1','64',128,'2','1',6533.61,6740.73,0.00,0.00,207.12,140841.60,0.00,0.00,0.00),('1','308','1','65',129,'1','1',10147.08,10499.27,0.00,0.00,352.19,259211.84,0.00,0.00,0.00),('1','308','1','65',130,'2','1',6740.73,7044.70,0.00,0.00,303.97,206699.60,0.00,0.00,0.00),('1','308','1','66',131,'1','1',10499.27,10857.93,0.00,0.00,358.66,263973.76,0.00,0.00,0.00),('1','308','1','66',132,'2','1',7044.70,7213.20,0.00,0.00,168.50,114580.00,0.00,0.00,0.00),('1','308','1','67',133,'1','1',10857.93,11300.64,0.00,0.00,442.71,325834.56,0.00,0.00,0.00),('1','308','1','67',134,'2','1',7213.20,7392.20,0.00,0.00,179.00,121720.00,0.00,0.00,0.00),('1','308','1','68',135,'1','1',11300.64,11451.25,0.00,0.00,150.61,110848.96,0.00,0.00,0.00),('1','308','1','68',136,'2','1',7392.20,7447.20,0.00,0.00,55.00,37400.00,0.00,0.00,0.00),('1','308','1','69',137,'1','1',11451.25,11682.13,0.00,0.00,230.88,169927.68,0.00,0.00,0.00),('1','308','1','69',138,'2','1',7447.20,7502.20,0.00,0.00,55.00,37400.00,0.00,0.00,0.00),('1','308','1','70',139,'1','1',11682.13,12012.46,0.00,0.00,330.33,243122.88,0.00,0.00,0.00),('1','308','1','70',140,'2','1',7502.20,7756.20,0.00,0.00,254.00,172720.00,0.00,0.00,0.00),('1','308','1','71',141,'1','1',12012.46,12186.24,0.00,0.00,173.78,127902.08,0.00,0.00,0.00),('1','308','1','71',142,'2','1',7756.20,8116.20,0.00,0.00,360.00,244800.00,0.00,0.00,0.00),('1','308','1','72',143,'1','1',12186.24,12342.24,0.00,0.00,156.00,114816.00,0.00,0.00,0.00),('1','308','1','72',144,'2','1',8116.20,8424.20,0.00,0.00,308.00,209440.00,0.00,0.00,0.00),('1','308','1','73',145,'1','1',12342.24,12514.98,0.00,0.00,172.74,127136.64,0.00,0.00,0.00),('1','308','1','73',146,'2','1',8424.20,8449.20,0.00,0.00,25.00,17000.00,0.00,0.00,0.00),('1','308','1','74',147,'1','1',12514.98,12697.39,0.00,0.00,182.41,134253.76,0.00,0.00,0.00),('1','308','1','74',148,'2','1',8449.20,8820.20,0.00,0.00,371.00,252280.00,0.00,0.00,0.00),('1','308','1','75',149,'1','1',12697.39,13095.44,0.00,0.00,398.05,292964.80,0.00,0.00,0.00),('1','308','1','75',150,'2','1',8820.20,8882.20,0.00,0.00,62.00,42272.00,0.00,0.00,0.00),('1','308','1','76',151,'1','1',13095.44,13216.17,0.00,0.00,120.73,88899.28,0.00,0.00,0.00),('1','308','1','76',152,'2','1',8882.20,8952.20,0.00,0.00,70.00,47600.00,0.00,0.00,0.00),('1','308','1','77',153,'1','1',13216.17,13400.90,0.00,0.00,184.73,135961.28,0.00,0.00,0.00),('1','308','1','77',154,'2','1',8952.20,9411.72,0.00,0.00,459.52,312473.60,0.00,0.00,0.00),('1','308','1','78',155,'1','1',13400.90,13533.44,0.00,0.00,132.54,95244.00,0.00,0.00,0.00),('1','308','1','78',156,'2','1',9411.72,9720.72,0.00,0.00,309.00,200850.00,0.00,0.00,0.00),('1','308','1','79',157,'1','1',13533.44,13832.88,0.00,0.00,299.44,209608.00,0.00,0.00,0.00),('1','308','1','79',158,'2','1',9720.72,9805.72,0.00,0.00,85.00,55930.00,0.00,0.00,0.00),('1','308','1','80',159,'1','1',13832.88,13952.23,0.00,0.00,119.35,83545.00,0.00,0.00,0.00),('1','308','1','80',160,'2','1',9805.72,9982.72,0.00,0.00,177.00,116466.00,0.00,0.00,0.00),('1','308','1','81',161,'1','1',13952.23,14214.47,0.00,0.00,262.24,183568.00,0.00,0.00,0.00),('1','308','1','81',162,'2','1',9982.72,10308.72,0.00,0.00,326.00,214508.00,0.00,0.00,0.00),('1','308','1','82',163,'1','1',14214.47,14322.33,0.00,0.00,107.86,75502.00,0.00,0.00,0.00),('1','308','1','82',164,'2','1',10308.72,10750.22,0.00,0.00,441.50,290507.00,0.00,0.00,0.00),('1','308','1','83',165,'1','1',14322.33,14374.40,0.00,0.00,52.07,36449.00,0.00,0.00,0.00),('1','308','1','83',166,'2','1',10750.22,11030.08,0.00,0.00,279.86,184147.88,0.00,0.00,0.00),('1','308','1','84',167,'1','1',14374.40,14374.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','308','1','84',168,'2','1',11030.08,11030.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','308','1','85',169,'1','1',14374.40,14522.31,0.00,0.00,147.91,103537.00,0.00,0.00,0.00),('1','308','1','85',170,'2','1',11030.08,11355.09,0.00,0.00,325.01,213856.58,0.00,0.00,0.00),('1','308','1','86',171,'1','1',14522.31,14585.88,0.00,0.00,63.57,44499.00,0.00,0.00,0.00),('1','308','1','86',172,'2','1',11355.09,11552.43,0.00,0.00,197.34,129849.72,0.00,0.00,0.00),('1','308','1','87',173,'1','1',14585.88,14714.89,0.00,0.00,129.01,90307.00,0.00,0.00,0.00),('1','308','1','87',174,'2','1',11552.43,11851.43,0.00,0.00,299.00,196742.00,0.00,0.00,0.00),('1','308','1','88',175,'1','1',14714.89,14849.15,0.00,0.00,134.26,93982.00,0.00,0.00,0.00),('1','308','1','88',176,'2','1',11851.43,12214.43,0.00,0.00,363.00,238854.00,0.00,0.00,0.00),('1','308','1','89',177,'1','1',14849.15,14930.30,0.00,0.00,81.15,56805.00,0.00,0.00,0.00),('1','308','1','89',178,'2','1',12214.43,12810.93,0.00,0.00,596.50,392497.00,0.00,0.00,0.00),('1','308','1','90',179,'1','1',14930.30,15192.95,0.00,0.00,262.65,183855.00,0.00,0.00,0.00),('1','308','1','90',180,'2','1',12810.93,13806.93,0.00,0.00,996.00,647400.00,0.00,0.00,0.00),('1','308','1','91',181,'1','1',15192.95,15454.02,0.00,0.00,261.07,182749.00,0.00,0.00,0.00),('1','308','1','91',182,'2','1',13806.93,14385.43,0.00,0.00,578.50,376025.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','308','1','1',664.00,770.00,0.00,1.00,664.00,770.00,106.00,1),('1','308','2','1',664.00,770.00,0.00,73.30,48671.20,53749.00,5077.80,2),('1','308','3','1',664.00,770.00,0.00,307.79,204372.56,233818.30,29445.74,3),('1','308','4','1',664.00,770.00,0.00,85.09,56499.76,65519.30,9019.54,4),('1','308','5','1',664.00,770.00,0.00,50.59,33591.76,38954.30,5362.54,5),('1','308','6','1',664.00,770.00,0.00,110.86,73611.04,82362.20,8751.16,6),('1','308','7','1',664.00,770.00,0.00,307.00,203848.00,221390.00,17542.00,7),('1','308','8','1',664.00,770.00,0.00,46.31,30749.84,35658.70,4908.86,8),('1','308','9','1',664.00,770.00,0.00,134.95,89606.80,97911.50,8304.70,9),('1','308','10','1',664.00,770.00,0.00,145.71,96751.44,111596.70,14845.26,10),('1','308','11','1',664.00,770.00,0.00,140.21,93099.44,104961.70,11862.26,11),('1','308','12','1',664.00,770.00,0.00,170.62,113291.68,128377.40,15085.72,12),('1','308','13','1',664.00,770.00,0.00,364.84,242253.76,265926.80,23673.04,13),('1','308','14','1',664.00,770.00,0.00,92.98,61738.72,71594.60,9855.88,14),('1','308','15','1',664.00,770.00,0.00,212.08,140821.12,159251.60,18430.48,15),('1','308','16','1',664.00,770.00,0.00,155.08,102973.12,119411.60,16438.48,16),('1','308','17','1',664.00,770.00,0.00,203.61,135197.04,153479.70,18282.66,17),('1','308','18','1',664.00,770.00,0.00,233.34,154937.76,179671.80,24734.04,18),('1','308','19','1',664.00,770.00,0.00,303.52,201537.28,230710.40,29173.12,19),('1','308','20','1',664.00,770.00,0.00,251.77,167175.28,187412.90,20237.62,20),('1','308','21','1',664.00,770.00,0.00,450.61,299205.04,329965.20,30760.16,21),('1','308','22','1',664.00,760.00,0.00,388.10,257698.40,288250.00,30551.60,22),('1','308','23','1',664.00,760.00,0.00,229.44,152348.16,170124.40,17776.24,23),('1','308','24','1',664.00,760.00,0.00,335.73,222924.72,249979.80,27055.08,24),('1','308','25','1',664.00,760.00,0.00,97.09,64467.76,72218.90,7751.14,25),('1','308','26','1',664.00,760.00,0.00,0.00,0.00,0.00,0.00,26),('1','308','27','1',664.00,760.00,0.00,166.85,110788.40,124625.50,13837.10,27),('1','308','28','1',664.00,760.00,0.00,319.96,212453.44,235188.20,22734.76,28),('1','308','29','1',664.00,740.00,0.00,421.66,279982.24,304708.40,24726.16,29),('1','308','30','1',664.00,740.00,0.00,307.99,204505.36,225872.60,21367.24,30),('1','308','31','1',664.00,740.00,0.00,196.08,130197.12,144349.20,14152.08,31),('1','308','32','1',664.00,740.00,0.00,238.77,158543.28,174589.80,16046.52,32),('1','308','33','1',664.00,740.00,0.00,269.42,178677.96,196755.70,18077.74,33),('1','308','34','1',630.00,740.00,0.00,365.76,230428.80,268462.40,38033.60,34),('1','308','35','1',630.00,740.00,0.00,226.00,142380.00,166260.00,23880.00,35),('1','308','36','1',630.00,740.00,0.00,281.88,177584.40,204591.20,27006.80,36),('1','308','37','1',630.00,740.00,0.00,267.94,168802.20,194285.60,25483.40,37),('1','308','38','1',630.00,740.00,0.00,199.20,125496.00,146208.00,20712.00,38),('1','308','39','1',630.00,740.00,0.00,173.92,109569.60,126232.00,16662.40,39),('1','308','40','1',630.00,740.00,0.00,255.12,160725.60,186988.80,26263.20,40),('1','308','41','1',630.00,740.00,0.00,322.74,203326.20,233627.60,30301.40,41),('1','308','42','1',630.00,740.00,0.00,233.37,147023.10,169893.80,22870.70,42),('1','308','43','1',630.00,740.00,0.00,585.47,368846.10,415247.80,46401.70,43),('1','308','44','1',630.00,740.00,0.00,180.67,113822.10,129209.80,15387.70,44),('1','308','45','1',630.00,740.00,0.00,0.00,0.00,0.00,0.00,45),('1','308','46','1',630.00,740.00,0.00,185.68,116978.40,137403.20,20424.80,46),('1','308','47','1',630.00,740.00,0.00,273.62,172380.60,198678.80,26298.20,47),('1','308','48','1',630.00,740.00,0.00,206.25,129937.50,151625.00,21687.50,48),('1','308','49','1',630.00,740.00,0.00,738.07,464984.10,531051.80,66067.70,49),('1','308','50','1',630.00,740.00,0.00,299.57,188729.10,220681.80,31952.70,50),('1','308','51','1',630.00,740.00,0.00,434.21,273552.30,310286.60,36734.30,51),('1','308','52','1',630.00,740.00,0.00,705.19,444269.70,503040.60,58770.90,52),('1','308','53','1',630.00,740.00,0.00,160.45,101083.50,118733.00,17649.50,53),('1','308','54','1',630.00,740.00,0.00,94.67,59642.10,70055.80,10413.70,54),('1','308','55','1',630.00,740.00,0.00,215.92,136029.60,154980.80,18951.20,55),('1','308','56','1',630.00,740.00,0.00,710.74,447766.20,498887.60,51121.40,56),('1','308','57','1',630.00,740.00,0.00,409.90,258237.00,291326.00,33089.00,57),('1','308','58','1',630.00,740.00,0.00,74.74,47086.20,54707.60,7621.40,58),('1','308','59','1',630.00,740.00,0.00,242.26,152623.80,173572.40,20948.60,59),('1','308','60','1',630.00,740.00,0.00,247.98,156227.40,182473.20,26245.80,60),('1','308','61','1',630.00,740.00,0.00,323.97,204101.10,233706.00,29604.90,61),('1','308','62','1',630.00,740.00,0.00,499.24,314521.20,353519.60,38998.40,62),('1','308','63','1',736.00,736.00,0.00,681.17,501341.12,476197.12,-25144.00,63),('1','308','64','1',736.00,736.00,0.00,479.76,353103.36,341504.64,-11598.72,64),('1','308','65','1',736.00,736.00,0.00,656.16,482933.76,465911.44,-17022.32,65),('1','308','66','1',736.00,736.00,0.00,527.16,387989.76,378553.76,-9436.00,66),('1','308','67','1',736.00,736.00,0.00,621.71,457578.56,447554.56,-10024.00,67),('1','308','68','1',736.00,736.00,0.00,205.61,151328.96,148248.96,-3080.00,68),('1','308','69','1',736.00,736.00,0.00,285.88,210407.68,207327.68,-3080.00,69),('1','308','70','1',736.00,736.00,0.00,584.33,430066.88,415842.88,-14224.00,70),('1','308','71','1',736.00,736.00,0.00,533.78,392862.08,372702.08,-20160.00,71),('1','308','72','1',736.00,736.00,0.00,464.00,341504.00,324256.00,-17248.00,72),('1','308','73','1',736.00,736.00,0.00,197.74,145536.64,144136.64,-1400.00,73),('1','308','74','1',736.00,736.00,0.00,553.41,407309.76,386533.76,-20776.00,74),('1','308','75','1',736.00,736.00,0.00,460.05,338596.80,335236.80,-3360.00,75),('1','308','76','1',736.00,736.00,0.00,190.73,140377.28,136499.28,-3878.00,76),('1','308','77','1',736.00,736.00,0.00,644.25,474168.00,448434.88,-25733.12,77),('1','308','78','1',736.00,736.00,0.00,441.54,285431.20,296094.00,10662.80,78),('1','308','79','1',624.00,700.00,0.00,384.44,239890.56,265538.00,25647.44,79),('1','308','80','1',624.00,700.00,0.00,296.35,184922.40,200011.00,15088.60,80),('1','308','81','1',624.00,700.00,0.00,588.24,367061.76,398076.00,31014.24,81),('1','308','82','1',624.00,700.00,0.00,549.36,342800.64,366009.00,23208.36,82),('1','308','83','1',624.00,700.00,0.00,331.93,207124.32,220596.88,13472.56,83),('1','308','84','1',624.00,700.00,0.00,0.00,0.00,0.00,0.00,84),('1','308','85','1',624.00,700.00,0.00,472.92,295102.08,317393.58,22291.50,85),('1','308','86','1',624.00,700.00,0.00,260.91,162807.84,174348.72,11540.88,86),('1','308','87','1',624.00,700.00,0.00,428.01,267078.24,287049.00,19970.76,87),('1','308','88','1',624.00,700.00,0.00,497.26,310290.24,332836.00,22545.76,88),('1','308','89','1',624.00,700.00,0.00,677.65,422853.60,449302.00,26448.40,89),('1','308','90','1',624.00,700.00,0.00,1258.65,792544.50,831255.00,38710.50,90),('1','308','91','1',630.00,700.00,0.00,839.57,528929.10,558774.00,29844.90,91);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'308','LPG TANK ','LPG PRODUCT TANKS.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','308','1',1,1,'1','LPG TANK ',6000.00,0.00,NULL,'LPG PRODUCT TANK.','479','2022-12-22 02:00:44','2022-12-22 02:00:44','479',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','308',1,695.03,'2023-03-20 19:11:31');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=4039 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','308',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,3300080.00,4970.00,0.00,0.00,'2022-12-23 10:57:04','',''),(2,'1','308',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,4970.00,0.00,'2022-12-23 10:59:20','',''),(3,'1','308','1',1,'Received from bridging 1',0.00,0.00,4970.00,0.00,0.00,'2022-12-23 10:59:20','',''),(4,'1','308','1',1,'Retail Sale Id 3',770.00,0.00,0.00,1.00,106.00,'2022-12-23 11:31:06','',''),(5,'1','308','1',1,'Retail Sale Id 4',43200.00,0.00,0.00,60.00,3360.00,'2022-12-23 12:29:11','',''),(6,'1','308','1',1,'Retail Sale Id 5',3850.00,0.00,0.00,5.00,530.00,'2022-12-23 14:49:29','',''),(7,'1','308','1',1,'Retail Sale Id 6',3311.00,0.00,0.00,4.30,455.80,'2022-12-23 17:57:22','',''),(8,'1','308','1',1,'Retail Sale Id 7',1540.00,0.00,0.00,2.00,212.00,'2022-12-23 17:59:33','',''),(9,'1','308','1',1,'Return of Retail Sale Id 7',0.00,1540.00,2.00,0.00,-212.00,'2022-12-23 19:19:32','',''),(10,'1','308','1',1,'Return of Retail Sale Id 4',0.00,43200.00,60.00,0.00,-3360.00,'2022-12-23 19:45:24','',''),(11,'1','308','1',1,'Return of Retail Sale Id 6',0.00,3311.00,4.30,0.00,-455.80,'2022-12-23 19:45:56','',''),(12,'1','308','1',1,'Return of Retail Sale Id 5',0.00,3850.00,5.00,0.00,-530.00,'2022-12-23 19:46:25','',''),(13,'1','308','1',1,'Retail Sale Id 8',49129.00,0.00,0.00,67.30,4441.80,'2022-12-23 19:49:02','',''),(14,'1','308','1',1,'Retail Sale Id 9',4620.00,0.00,0.00,6.00,636.00,'2022-12-23 19:50:22','',''),(15,'1','308','1',1,'Retail Sale Id 10',2348.50,0.00,0.00,3.05,323.30,'2022-12-24 08:35:42','',''),(16,'1','308','1',1,'Retail Sale Id 11',2310.00,0.00,0.00,3.00,318.00,'2022-12-24 08:51:00','',''),(17,'1','308','1',1,'Retail Sale Id 12',2310.00,0.00,0.00,3.00,318.00,'2022-12-24 08:52:31','',''),(18,'1','308','1',1,'Retail Sale Id 13',2310.00,0.00,0.00,3.00,318.00,'2022-12-24 08:53:32','',''),(19,'1','308','1',1,'Retail Sale Id 14',4250.40,0.00,0.00,5.52,585.12,'2022-12-24 09:23:28','',''),(20,'1','308','1',1,'Retail Sale Id 15',4650.80,0.00,0.00,6.04,640.24,'2022-12-24 10:15:28','',''),(21,'1','308','1',1,'Retail Sale Id 16',770.00,0.00,0.00,1.00,106.00,'2022-12-24 10:55:44','',''),(22,'1','308','1',1,'Retail Sale Id 17',2002.00,0.00,0.00,2.60,275.60,'2022-12-24 11:18:41','',''),(23,'1','308','1',1,'Retail Sale Id 18',1501.50,0.00,0.00,1.95,206.70,'2022-12-24 11:41:59','',''),(24,'1','308','1',1,'Retail Sale Id 19',500.50,0.00,0.00,0.65,68.90,'2022-12-24 12:00:01','',''),(25,'1','308','1',1,'Retail Sale Id 20',1540.00,0.00,0.00,2.00,212.00,'2022-12-24 12:27:29','',''),(26,'1','308','1',1,'Retail Sale Id 21',1540.00,0.00,0.00,2.00,212.00,'2022-12-24 12:28:50','',''),(27,'1','308','1',1,'Retail Sale Id 22',1540.00,0.00,0.00,2.00,212.00,'2022-12-24 12:31:59','',''),(28,'1','308','1',1,'Retail Sale Id 23',1540.00,0.00,0.00,2.00,212.00,'2022-12-24 12:39:24','',''),(29,'1','308','1',1,'Retail Sale Id 24',1501.50,0.00,0.00,1.95,206.70,'2022-12-24 12:41:02','',''),(30,'1','308','1',1,'Retail Sale Id 25',2310.00,0.00,0.00,3.00,318.00,'2022-12-24 12:42:47','',''),(31,'1','308','1',1,'Retail Sale Id 26',3080.00,0.00,0.00,4.00,424.00,'2022-12-24 12:47:46','',''),(32,'1','308','1',1,'Retail Sale Id 27',800.80,0.00,0.00,1.04,110.24,'2022-12-24 12:55:13','',''),(33,'1','308','1',1,'Retail Sale Id 28',800.80,0.00,0.00,1.04,110.24,'2022-12-24 12:57:36','',''),(34,'1','308','1',1,'Retail Sale Id 29',2310.00,0.00,0.00,3.00,318.00,'2022-12-24 13:00:07','',''),(35,'1','308','1',1,'Retail Sale Id 30',1540.00,0.00,0.00,2.00,212.00,'2022-12-24 13:03:47','',''),(36,'1','308','1',1,'Retail Sale Id 31',2310.00,0.00,0.00,3.00,318.00,'2022-12-24 13:09:01','',''),(37,'1','308','1',1,'Retail Sale Id 32',3103.10,0.00,0.00,4.03,427.18,'2022-12-24 13:13:18','',''),(38,'1','308','1',1,'Retail Sale Id 33',9648.10,0.00,0.00,12.53,1328.18,'2022-12-24 13:16:38','',''),(39,'1','308','1',1,'Retail Sale Id 34',1540.00,0.00,0.00,2.00,212.00,'2022-12-24 13:22:24','',''),(40,'1','308','1',1,'Retail Sale Id 35',1540.00,0.00,0.00,2.00,212.00,'2022-12-24 13:24:53','',''),(41,'1','308','1',1,'Retail Sale Id 36',800.80,0.00,0.00,1.04,110.24,'2022-12-24 13:25:40','',''),(42,'1','308','1',1,'Retail Sale Id 37',3103.10,0.00,0.00,4.03,427.18,'2022-12-24 13:28:07','',''),(43,'1','308','1',1,'Retail Sale Id 38',1540.00,0.00,0.00,2.00,212.00,'2022-12-24 13:29:40','',''),(44,'1','308','1',1,'Retail Sale Id 39',2310.00,0.00,0.00,3.00,318.00,'2022-12-24 13:32:56','',''),(45,'1','308','1',1,'Retail Sale Id 40',1540.00,0.00,0.00,2.00,212.00,'2022-12-24 13:35:03','',''),(46,'1','308','1',1,'Retail Sale Id 41',800.80,0.00,0.00,1.04,110.24,'2022-12-24 13:36:36','',''),(47,'1','308','1',1,'Retail Sale Id 42',2348.50,0.00,0.00,3.05,323.30,'2022-12-24 13:38:48','',''),(48,'1','308','1',1,'Retail Sale Id 43',3080.00,0.00,0.00,4.00,424.00,'2022-12-24 13:41:19','',''),(49,'1','308','1',1,'Retail Sale Id 44',3850.00,0.00,0.00,5.00,530.00,'2022-12-24 13:42:45','',''),(50,'1','308','1',1,'Retail Sale Id 45',1547.70,0.00,0.00,2.01,213.06,'2022-12-24 13:52:06','',''),(51,'1','308','1',1,'Retail Sale Id 46',1547.70,0.00,0.00,2.01,213.06,'2022-12-24 13:53:39','',''),(52,'1','308','1',1,'Retail Sale Id 47',1501.50,0.00,0.00,1.95,206.70,'2022-12-24 13:56:52','',''),(53,'1','308','1',1,'Retail Sale Id 48',2310.00,0.00,0.00,3.00,318.00,'2022-12-24 13:58:41','',''),(54,'1','308','1',1,'Retail Sale Id 49',3850.00,0.00,0.00,5.00,530.00,'2022-12-24 14:01:17','',''),(55,'1','308','1',1,'Retail Sale Id 50',3103.10,0.00,0.00,4.03,427.18,'2022-12-24 14:05:24','',''),(56,'1','308','1',1,'Retail Sale Id 51',2310.00,0.00,0.00,3.00,318.00,'2022-12-24 14:15:13','',''),(57,'1','308','1',1,'Retail Sale Id 52',3850.00,0.00,0.00,5.00,530.00,'2022-12-24 14:19:47','',''),(58,'1','308','1',1,'Retail Sale Id 53',2302.30,0.00,0.00,2.99,316.94,'2022-12-24 14:20:59','',''),(59,'1','308','1',1,'Retail Sale Id 54',2102.10,0.00,0.00,2.73,289.38,'2022-12-24 14:23:00','',''),(60,'1','308','1',1,'Retail Sale Id 55',2302.30,0.00,0.00,2.99,316.94,'2022-12-24 14:25:05','',''),(61,'1','308','1',1,'Retail Sale Id 56',1501.50,0.00,0.00,1.95,206.70,'2022-12-24 14:27:31','',''),(62,'1','308','1',1,'Retail Sale Id 57',800.80,0.00,0.00,1.04,110.24,'2022-12-24 14:28:24','',''),(63,'1','308','1',1,'Retail Sale Id 58',1501.50,0.00,0.00,1.95,206.70,'2022-12-24 14:35:15','',''),(64,'1','308','1',1,'Retail Sale Id 59',35500.00,0.00,0.00,50.00,2300.00,'2022-12-24 14:38:43','',''),(65,'1','308','1',1,'Retail Sale Id 60',5397.70,0.00,0.00,7.01,743.06,'2022-12-24 14:40:52','',''),(66,'1','308','1',1,'Retail Sale Id 61',4650.80,0.00,0.00,6.04,640.24,'2022-12-24 14:44:37','',''),(67,'1','308','1',1,'Retail Sale Id 62',4697.00,0.00,0.00,6.10,646.60,'2022-12-24 14:46:18','',''),(68,'1','308','1',1,'Retail Sale Id 63',3850.00,0.00,0.00,5.00,530.00,'2022-12-24 14:48:20','',''),(69,'1','308','1',1,'Retail Sale Id 64',1501.50,0.00,0.00,1.95,206.70,'2022-12-24 14:50:17','',''),(70,'1','308','1',1,'Retail Sale Id 65',2202.20,0.00,0.00,2.86,303.16,'2022-12-24 14:52:28','',''),(71,'1','308','1',1,'Retail Sale Id 66',2502.50,0.00,0.00,3.25,344.50,'2022-12-24 15:06:37','',''),(72,'1','308','1',1,'Retail Sale Id 67',1501.50,0.00,0.00,1.95,206.70,'2022-12-24 15:09:10','',''),(73,'1','308','1',1,'Retail Sale Id 68',1501.50,0.00,0.00,1.95,206.70,'2022-12-24 15:10:24','',''),(74,'1','308','1',1,'Retail Sale Id 69',2002.00,0.00,0.00,2.60,275.60,'2022-12-24 15:13:11','',''),(75,'1','308','1',1,'Retail Sale Id 70',1501.50,0.00,0.00,1.95,206.70,'2022-12-24 15:15:05','',''),(76,'1','308','1',1,'Retail Sale Id 71',3003.00,0.00,0.00,3.90,413.40,'2022-12-24 15:17:45','',''),(77,'1','308','1',1,'Retail Sale Id 72',5998.30,0.00,0.00,7.79,825.74,'2022-12-24 15:19:32','',''),(78,'1','308','1',1,'Retail Sale Id 73',2002.00,0.00,0.00,2.60,275.60,'2022-12-24 15:21:34','',''),(79,'1','308','1',1,'Retail Sale Id 74',1540.00,0.00,0.00,2.00,212.00,'2022-12-24 15:36:40','',''),(80,'1','308','1',1,'Retail Sale Id 75',1501.50,0.00,0.00,1.95,206.70,'2022-12-24 15:47:01','',''),(81,'1','308','1',1,'Retail Sale Id 76',800.80,0.00,0.00,1.04,110.24,'2022-12-24 15:47:47','',''),(82,'1','308','1',1,'Retail Sale Id 77',800.80,0.00,0.00,1.04,110.24,'2022-12-24 15:48:42','',''),(83,'1','308','1',1,'Retail Sale Id 78',2310.00,0.00,0.00,3.00,318.00,'2022-12-24 15:50:13','',''),(84,'1','308','1',1,'Retail Sale Id 79',1501.50,0.00,0.00,1.95,206.70,'2022-12-24 15:52:57','',''),(85,'1','308','1',1,'Retail Sale Id 80',1547.70,0.00,0.00,2.01,213.06,'2022-12-24 15:54:28','',''),(86,'1','308','1',1,'Retail Sale Id 81',3850.00,0.00,0.00,5.00,530.00,'2022-12-24 15:59:06','',''),(87,'1','308','1',1,'Retail Sale Id 82',2348.50,0.00,0.00,3.05,323.30,'2022-12-24 16:18:38','',''),(88,'1','308','1',1,'Retail Sale Id 83',2302.30,0.00,0.00,2.99,316.94,'2022-12-24 16:29:55','',''),(89,'1','308','1',1,'Retail Sale Id 84',4650.80,0.00,0.00,6.04,640.24,'2022-12-24 16:35:17','',''),(90,'1','308','1',1,'Retail Sale Id 85',5397.70,0.00,0.00,7.01,743.06,'2022-12-24 16:38:36','',''),(91,'1','308','1',1,'Retail Sale Id 86',2310.00,0.00,0.00,3.00,318.00,'2022-12-24 17:10:28','',''),(92,'1','308','1',1,'Retail Sale Id 87',3103.10,0.00,0.00,4.03,427.18,'2022-12-24 17:28:56','',''),(93,'1','308','1',1,'Retail Sale Id 88',3103.10,0.00,0.00,4.03,427.18,'2022-12-24 17:30:37','',''),(94,'1','308','1',1,'Retail Sale Id 89',800.80,0.00,0.00,1.04,110.24,'2022-12-24 17:38:25','',''),(95,'1','308','1',1,'Retail Sale Id 90',800.80,0.00,0.00,1.04,110.24,'2022-12-24 18:06:29','',''),(96,'1','308','1',1,'Retail Sale Id 91',3103.10,0.00,0.00,4.03,427.18,'2022-12-24 18:07:38','',''),(97,'1','308','1',1,'Retail Sale Id 92',1601.60,0.00,0.00,2.08,220.48,'2022-12-24 18:09:02','',''),(98,'1','308','1',1,'Retail Sale Id 93',1001.00,0.00,0.00,1.30,137.80,'2022-12-24 18:13:38','',''),(99,'1','308','1',1,'Return of Retail Sale Id 59',0.00,35500.00,50.00,0.00,-2300.00,'2022-12-24 19:10:12','',''),(100,'1','308','1',1,'Retail Sale Id 94',37630.00,0.00,0.00,53.00,2438.00,'2022-12-24 19:12:05','',''),(101,'1','308','1',1,'Retail Sale Id 95',2310.00,0.00,0.00,3.00,318.00,'2022-12-25 08:21:36','',''),(102,'1','308','1',1,'Retail Sale Id 96',3103.10,0.00,0.00,4.03,427.18,'2022-12-25 08:40:52','',''),(103,'1','308','1',1,'Retail Sale Id 97',4650.80,0.00,0.00,6.04,640.24,'2022-12-25 08:47:01','',''),(104,'1','308','1',1,'Retail Sale Id 98',7700.00,0.00,0.00,10.00,1060.00,'2022-12-25 09:23:40','',''),(105,'1','308','1',1,'Retail Sale Id 99',1540.00,0.00,0.00,2.00,212.00,'2022-12-25 10:30:13','',''),(106,'1','308','1',1,'Retail Sale Id 100',5998.30,0.00,0.00,7.79,825.74,'2022-12-25 11:47:41','',''),(107,'1','308','1',1,'Retail Sale Id 101',1540.00,0.00,0.00,2.00,212.00,'2022-12-25 11:48:49','',''),(108,'1','308','1',1,'Retail Sale Id 103',1001.00,0.00,0.00,1.30,137.80,'2022-12-25 11:49:51','',''),(109,'1','308','1',1,'Retail Sale Id 104',1540.00,0.00,0.00,2.00,212.00,'2022-12-25 11:51:11','',''),(110,'1','308','1',1,'Retail Sale Id 105',3850.00,0.00,0.00,5.00,530.00,'2022-12-25 11:51:50','',''),(111,'1','308','1',1,'Retail Sale Id 106',793.10,0.00,0.00,1.03,109.18,'2022-12-25 11:54:42','',''),(112,'1','308','1',1,'Retail Sale Id 107',1540.00,0.00,0.00,2.00,212.00,'2022-12-25 11:55:23','',''),(113,'1','308','1',1,'Retail Sale Id 108',4596.90,0.00,0.00,5.97,632.82,'2022-12-25 11:56:16','',''),(114,'1','308','1',1,'Retail Sale Id 109',1540.00,0.00,0.00,2.00,212.00,'2022-12-25 11:56:56','',''),(115,'1','308','1',1,'Retail Sale Id 110',793.10,0.00,0.00,1.03,109.18,'2022-12-25 12:30:56','',''),(116,'1','308','1',1,'Retail Sale Id 111',4650.80,0.00,0.00,6.04,640.24,'2022-12-25 12:40:14','',''),(117,'1','308','1',1,'Retail Sale Id 112',4997.30,0.00,0.00,6.49,687.94,'2022-12-25 15:33:43','',''),(118,'1','308','1',1,'Retail Sale Id 114',2348.50,0.00,0.00,3.05,323.30,'2022-12-25 16:24:06','',''),(119,'1','308','1',1,'Retail Sale Id 115',13028.40,0.00,0.00,16.92,1793.52,'2022-12-25 18:14:49','',''),(120,'1','308','1',1,'Return of Retail Sale Id 115',0.00,13028.40,16.92,0.00,-1793.52,'2022-12-25 18:17:56','',''),(121,'1','308','1',1,'Retail Sale Id 116',11026.40,0.00,0.00,14.32,1517.92,'2022-12-25 18:19:25','',''),(122,'1','308','1',1,'Retail Sale Id 117',2002.00,0.00,0.00,2.60,275.60,'2022-12-25 18:29:25','',''),(123,'1','308','1',1,'Return of Retail Sale Id 117',0.00,2002.00,2.60,0.00,-275.60,'2022-12-25 18:31:23','',''),(124,'1','308','1',1,'Retail Sale Id 118',4658.50,0.00,0.00,6.05,641.30,'2022-12-26 08:07:34','',''),(125,'1','308','1',1,'Retail Sale Id 119',3049.20,0.00,0.00,3.96,419.76,'2022-12-26 09:40:29','',''),(126,'1','308','1',1,'Retail Sale Id 120',1540.00,0.00,0.00,2.00,212.00,'2022-12-26 10:29:27','',''),(127,'1','308','1',1,'Retail Sale Id 121',2302.30,0.00,0.00,2.99,316.94,'2022-12-26 11:00:25','',''),(128,'1','308','1',1,'Retail Sale Id 122',3149.30,0.00,0.00,4.09,433.54,'2022-12-26 14:28:58','',''),(129,'1','308','1',1,'Retail Sale Id 123',3850.00,0.00,0.00,5.00,530.00,'2022-12-26 16:35:34','',''),(130,'1','308','1',1,'Retail Sale Id 127',3850.00,0.00,0.00,5.00,530.00,'2022-12-26 18:12:22','',''),(131,'1','308','1',1,'Retail Sale Id 128',16170.00,0.00,0.00,21.00,2226.00,'2022-12-26 20:48:51','',''),(132,'1','308','1',1,'Retail Sale Id 129',385.00,0.00,0.00,0.50,53.00,'2022-12-26 20:54:26','',''),(133,'1','308','1',1,'Retail Sale Id 130',6167.70,0.00,0.00,8.01,849.06,'2022-12-27 08:34:06','',''),(134,'1','308','1',1,'Retail Sale Id 132',2310.00,0.00,0.00,3.00,318.00,'2022-12-27 09:18:50','',''),(135,'1','308','1',1,'Retail Sale Id 133',1001.00,0.00,0.00,1.30,137.80,'2022-12-27 09:41:15','',''),(136,'1','308','1',1,'Retail Sale Id 134',770.00,0.00,0.00,1.00,106.00,'2022-12-27 10:24:26','',''),(137,'1','308','1',1,'Retail Sale Id 135',4620.00,0.00,0.00,6.00,636.00,'2022-12-27 11:12:56','',''),(138,'1','308','1',1,'Retail Sale Id 136',38500.00,0.00,0.00,50.00,5300.00,'2022-12-27 13:27:52','',''),(139,'1','308','1',1,'Return of Retail Sale Id 136',0.00,38500.00,50.00,0.00,-5300.00,'2022-12-27 13:28:37','',''),(140,'1','308','1',1,'Retail Sale Id 137',35500.00,0.00,0.00,50.00,2300.00,'2022-12-27 13:29:27','',''),(141,'1','308','1',1,'Retail Sale Id 138',4620.00,0.00,0.00,6.00,636.00,'2022-12-27 13:33:30','',''),(142,'1','308','1',1,'Retail Sale Id 139',3850.00,0.00,0.00,5.00,530.00,'2022-12-27 13:37:31','',''),(143,'1','308','1',1,'Retail Sale Id 140',4620.00,0.00,0.00,6.00,636.00,'2022-12-27 13:39:39','',''),(144,'1','308','1',1,'Retail Sale Id 141',1540.00,0.00,0.00,2.00,212.00,'2022-12-27 13:41:43','',''),(145,'1','308','1',1,'Retail Sale Id 142',3080.00,0.00,0.00,4.00,424.00,'2022-12-27 17:39:57','',''),(146,'1','308','1',1,'Retail Sale Id 143',9625.00,0.00,0.00,12.50,1325.00,'2022-12-27 17:41:33','',''),(147,'1','308','1',1,'Retail Sale Id 145',2333.10,0.00,0.00,3.03,321.18,'2022-12-27 18:03:41','',''),(148,'1','308','1',1,'Retail Sale Id 146',3080.00,0.00,0.00,4.00,424.00,'2022-12-27 18:07:38','',''),(149,'1','308','1',1,'Retail Sale Id 147',2310.00,0.00,0.00,3.00,318.00,'2022-12-27 18:18:47','',''),(150,'1','308','1',1,'Return of Retail Sale Id 133',0.00,1001.00,1.30,0.00,-137.80,'2022-12-27 19:49:47','',''),(151,'1','308','1',1,'Return of Retail Sale Id 138',0.00,4620.00,6.00,0.00,-636.00,'2022-12-27 19:55:18','',''),(152,'1','308','1',1,'Retail Sale Id 148',2556.40,0.00,0.00,3.32,351.92,'2022-12-27 19:56:57','',''),(153,'1','308','1',1,'Retail Sale Id 149',770.00,0.00,0.00,1.00,106.00,'2022-12-28 08:57:54','',''),(154,'1','308','1',1,'Retail Sale Id 150',2348.50,0.00,0.00,3.05,323.30,'2022-12-28 09:00:52','',''),(155,'1','308','1',1,'Retail Sale Id 151',1547.70,0.00,0.00,2.01,213.06,'2022-12-28 09:02:30','',''),(156,'1','308','1',1,'Retail Sale Id 152',2002.00,0.00,0.00,2.60,275.60,'2022-12-28 09:21:42','',''),(157,'1','308','1',1,'Retail Sale Id 153',2310.00,0.00,0.00,3.00,318.00,'2022-12-28 09:28:46','',''),(158,'1','308','1',1,'Retail Sale Id 154',4620.00,0.00,0.00,6.00,636.00,'2022-12-28 10:17:28','',''),(159,'1','308','1',1,'Retail Sale Id 155',1001.00,0.00,0.00,1.30,137.80,'2022-12-28 10:18:21','',''),(160,'1','308','1',1,'Retail Sale Id 156',2310.00,0.00,0.00,3.00,318.00,'2022-12-28 10:19:40','',''),(161,'1','308','1',1,'Retail Sale Id 157',35500.00,0.00,0.00,50.00,2300.00,'2022-12-28 13:43:08','',''),(162,'1','308','1',1,'Retail Sale Id 158',2310.00,0.00,0.00,3.00,318.00,'2022-12-28 13:50:12','',''),(163,'1','308','1',1,'Retail Sale Id 159',800.80,0.00,0.00,1.04,110.24,'2022-12-28 13:54:41','',''),(164,'1','308','1',1,'Retail Sale Id 160',800.80,0.00,0.00,1.04,110.24,'2022-12-28 13:58:21','',''),(165,'1','308','1',1,'Retail Sale Id 161',142000.00,0.00,0.00,200.00,9200.00,'2022-12-28 14:57:52','',''),(166,'1','308','1',1,'Retail Sale Id 162',1001.00,0.00,0.00,1.30,137.80,'2022-12-28 16:48:45','',''),(167,'1','308','1',1,'Retail Sale Id 163',3850.00,0.00,0.00,5.00,530.00,'2022-12-28 16:50:15','',''),(168,'1','308','1',1,'Retail Sale Id 164',1547.70,0.00,0.00,2.01,213.06,'2022-12-28 16:53:57','',''),(169,'1','308','1',1,'Retail Sale Id 165',2310.00,0.00,0.00,3.00,318.00,'2022-12-28 16:55:50','',''),(170,'1','308','1',1,'Retail Sale Id 166',7700.00,0.00,0.00,10.00,1060.00,'2022-12-28 16:57:25','',''),(171,'1','308','1',1,'Retail Sale Id 167',1001.00,0.00,0.00,1.30,137.80,'2022-12-28 16:59:00','',''),(172,'1','308','1',1,'Retail Sale Id 168',1540.00,0.00,0.00,2.00,212.00,'2022-12-28 17:06:59','',''),(173,'1','308','1',1,'Retail Sale Id 169',1540.00,0.00,0.00,2.00,212.00,'2022-12-28 17:30:45','',''),(174,'1','308','1',1,'Retail Sale Id 170',2579.50,0.00,0.00,3.35,355.10,'2022-12-28 19:03:50','',''),(175,'1','308','1',1,'Retail Sale Id 171',4650.80,0.00,0.00,6.04,640.24,'2022-12-29 08:24:08','',''),(176,'1','308','1',1,'Retail Sale Id 172',4620.00,0.00,0.00,6.00,636.00,'2022-12-29 10:02:02','',''),(177,'1','308','1',1,'Retail Sale Id 173',2348.50,0.00,0.00,3.05,323.30,'2022-12-29 11:15:18','',''),(178,'1','308','1',1,'Retail Sale Id 174',2002.00,0.00,0.00,2.60,275.60,'2022-12-29 11:30:35','',''),(179,'1','308','1',1,'Retail Sale Id 175',2348.50,0.00,0.00,3.05,323.30,'2022-12-29 13:26:57','',''),(180,'1','308','1',1,'Retail Sale Id 176',1001.00,0.00,0.00,1.30,137.80,'2022-12-29 14:13:35','',''),(181,'1','308','1',1,'Retail Sale Id 177',1001.00,0.00,0.00,1.30,137.80,'2022-12-29 14:15:31','',''),(182,'1','308','1',1,'Retail Sale Id 178',3842.30,0.00,0.00,4.99,528.94,'2022-12-29 16:52:09','',''),(183,'1','308','1',1,'Retail Sale Id 179',4596.90,0.00,0.00,5.97,632.82,'2022-12-29 16:54:21','',''),(184,'1','308','1',1,'Retail Sale Id 180',800.80,0.00,0.00,1.04,110.24,'2022-12-29 17:07:14','',''),(185,'1','308','1',1,'Retail Sale Id 181',4596.90,0.00,0.00,5.97,632.82,'2022-12-29 17:44:05','',''),(186,'1','308','1',1,'Retail Sale Id 182',3850.00,0.00,0.00,5.00,530.00,'2022-12-29 18:07:35','',''),(187,'1','308','1',1,'Retail Sale Id 183',2348.50,0.00,0.00,3.05,323.30,'2022-12-30 09:10:05','',''),(188,'1','308','1',1,'Retail Sale Id 184',4650.80,0.00,0.00,6.04,640.24,'2022-12-30 09:11:27','',''),(189,'1','308','1',1,'Retail Sale Id 185',2348.50,0.00,0.00,3.05,323.30,'2022-12-30 09:31:46','',''),(190,'1','308','1',1,'Retail Sale Id 186',3850.00,0.00,0.00,5.00,530.00,'2022-12-30 09:45:02','',''),(191,'1','308','1',1,'Retail Sale Id 187',1001.00,0.00,0.00,1.30,137.80,'2022-12-30 10:18:10','',''),(192,'1','308','1',1,'Retail Sale Id 188',35500.00,0.00,0.00,50.00,2300.00,'2022-12-30 12:23:32','',''),(193,'1','308','1',1,'Retail Sale Id 189',1540.00,0.00,0.00,2.00,212.00,'2022-12-30 12:26:53','',''),(194,'1','308','1',1,'Retail Sale Id 190',2310.00,0.00,0.00,3.00,318.00,'2022-12-30 12:37:07','',''),(195,'1','308','1',1,'Retail Sale Id 191',500.50,0.00,0.00,0.65,68.90,'2022-12-30 14:43:09','',''),(196,'1','308','1',1,'Retail Sale Id 192',35500.00,0.00,0.00,50.00,2300.00,'2022-12-30 14:52:11','',''),(197,'1','308','1',1,'Retail Sale Id 193',800.80,0.00,0.00,1.04,110.24,'2022-12-30 15:56:12','',''),(198,'1','308','1',1,'Retail Sale Id 194',800.80,0.00,0.00,1.04,110.24,'2022-12-30 15:57:43','',''),(199,'1','308','1',1,'Retail Sale Id 196',746.90,0.00,0.00,0.97,102.82,'2022-12-30 16:02:24','',''),(200,'1','308','1',1,'Retail Sale Id 197',3103.10,0.00,0.00,4.03,427.18,'2022-12-30 17:02:41','',''),(201,'1','308','1',1,'Retail Sale Id 198',4620.00,0.00,0.00,6.00,636.00,'2022-12-30 17:07:57','',''),(202,'1','308','1',1,'Retail Sale Id 200',1547.70,0.00,0.00,2.01,213.06,'2022-12-30 17:26:29','',''),(203,'1','308','1',1,'Return of Retail Sale Id 198',0.00,4620.00,6.00,0.00,-636.00,'2022-12-30 18:12:03','',''),(204,'1','308','1',1,'Retail Sale Id 201',1362.90,0.00,0.00,1.77,187.62,'2022-12-30 18:14:02','',''),(205,'1','308','1',1,'Retail Sale Id 202',800.80,0.00,0.00,1.04,110.24,'2022-12-31 08:28:32','',''),(206,'1','308','1',1,'Retail Sale Id 203',13451.90,0.00,0.00,17.47,1851.82,'2022-12-31 08:29:52','',''),(207,'1','308','1',1,'Retail Sale Id 204',1547.70,0.00,0.00,2.01,213.06,'2022-12-31 09:06:27','',''),(208,'1','308','1',1,'Retail Sale Id 205',1547.70,0.00,0.00,2.01,213.06,'2022-12-31 09:47:36','',''),(209,'1','308','1',1,'Retail Sale Id 206',1547.70,0.00,0.00,2.01,213.06,'2022-12-31 09:55:22','',''),(210,'1','308','1',1,'Retail Sale Id 207',1547.70,0.00,0.00,2.01,213.06,'2022-12-31 09:57:00','',''),(211,'1','308','1',1,'Retail Sale Id 208',3103.10,0.00,0.00,4.03,427.18,'2022-12-31 10:01:02','',''),(212,'1','308','1',1,'Retail Sale Id 209',4620.00,0.00,0.00,6.00,636.00,'2022-12-31 11:26:58','',''),(213,'1','308','1',1,'Retail Sale Id 210',1547.70,0.00,0.00,2.01,213.06,'2022-12-31 12:11:00','',''),(214,'1','308','1',1,'Retail Sale Id 211',2310.00,0.00,0.00,3.00,318.00,'2022-12-31 12:14:41','',''),(215,'1','308','1',1,'Retail Sale Id 212',800.80,0.00,0.00,1.04,110.24,'2022-12-31 12:43:32','',''),(216,'1','308','1',1,'Retail Sale Id 213',1547.70,0.00,0.00,2.01,213.06,'2022-12-31 12:59:08','',''),(217,'1','308','1',1,'Retail Sale Id 214',7100.00,0.00,0.00,10.00,460.00,'2022-12-31 13:56:04','',''),(218,'1','308','1',1,'Retail Sale Id 215',3850.00,0.00,0.00,5.00,530.00,'2022-12-31 14:39:17','',''),(219,'1','308','1',1,'Retail Sale Id 216',6930.00,0.00,0.00,9.00,954.00,'2022-12-31 14:40:39','',''),(220,'1','308','1',1,'Retail Sale Id 217',3103.10,0.00,0.00,4.03,427.18,'2022-12-31 14:48:16','',''),(221,'1','308','1',1,'Retail Sale Id 218',1001.00,0.00,0.00,1.30,137.80,'2022-12-31 14:56:12','',''),(222,'1','308','1',1,'Retail Sale Id 219',9625.00,0.00,0.00,12.50,1325.00,'2022-12-31 15:36:03','',''),(223,'1','308','1',1,'Retail Sale Id 220',3996.30,0.00,0.00,5.19,550.14,'2022-12-31 16:05:25','',''),(224,'1','308','1',1,'Retail Sale Id 221',3103.10,0.00,0.00,4.03,427.18,'2022-12-31 16:12:47','',''),(225,'1','308','1',1,'Retail Sale Id 222',3850.00,0.00,0.00,5.00,530.00,'2022-12-31 16:16:25','',''),(226,'1','308','1',1,'Retail Sale Id 227',3080.00,0.00,0.00,4.00,424.00,'2022-12-31 16:25:59','',''),(227,'1','308','1',1,'Retail Sale Id 228',800.80,0.00,0.00,1.04,110.24,'2022-12-31 16:43:58','',''),(228,'1','308','1',1,'Retail Sale Id 229',2348.50,0.00,0.00,3.05,323.30,'2022-12-31 17:12:15','',''),(229,'1','308','1',1,'Retail Sale Id 230',3996.30,0.00,0.00,5.19,550.14,'2022-12-31 17:44:53','',''),(230,'1','308','1',1,'Retail Sale Id 231',1301.30,0.00,0.00,1.69,179.14,'2022-12-31 17:47:59','',''),(231,'1','308','1',1,'Retail Sale Id 233',9648.10,0.00,0.00,12.53,1328.18,'2022-12-31 18:04:48','',''),(232,'1','308','1',1,'Retail Sale Id 234',3850.00,0.00,0.00,5.00,530.00,'2022-12-31 18:14:03','',''),(233,'1','308','1',1,'Retail Sale Id 235',9648.10,0.00,0.00,12.53,1328.18,'2022-12-31 18:23:27','',''),(234,'1','308','1',1,'Return of Retail Sale Id 231',0.00,1301.30,1.69,0.00,-179.14,'2022-12-31 18:36:18','',''),(235,'1','308','1',1,'Retail Sale Id 236',1293.60,0.00,0.00,1.68,178.08,'2022-12-31 18:37:43','',''),(236,'1','308','1',1,'Retail Sale Id 237',800.80,0.00,0.00,1.04,110.24,'2023-01-01 09:06:22','',''),(237,'1','308','1',1,'Retail Sale Id 238',3850.00,0.00,0.00,5.00,530.00,'2023-01-01 09:14:05','',''),(238,'1','308','1',1,'Retail Sale Id 239',4997.30,0.00,0.00,6.49,687.94,'2023-01-01 09:43:15','',''),(239,'1','308','1',1,'Retail Sale Id 240',800.80,0.00,0.00,1.04,110.24,'2023-01-01 09:44:50','',''),(240,'1','308','1',1,'Retail Sale Id 241',1501.50,0.00,0.00,1.95,206.70,'2023-01-01 09:46:08','',''),(241,'1','308','1',1,'Retail Sale Id 242',9617.30,0.00,0.00,12.49,1323.94,'2023-01-01 09:47:16','',''),(242,'1','308','1',1,'Retail Sale Id 243',5852.00,0.00,0.00,7.60,805.60,'2023-01-01 09:48:54','',''),(243,'1','308','1',1,'Retail Sale Id 244',1547.70,0.00,0.00,2.01,213.06,'2023-01-01 10:05:23','',''),(244,'1','308','1',1,'Retail Sale Id 245',4858.70,0.00,0.00,6.31,668.86,'2023-01-01 10:13:51','',''),(245,'1','308','1',1,'Return of Retail Sale Id 243',0.00,5852.00,7.60,0.00,-805.60,'2023-01-01 10:15:33','',''),(246,'1','308','1',1,'Retail Sale Id 246',3103.10,0.00,0.00,4.03,427.18,'2023-01-01 10:31:54','',''),(247,'1','308','1',1,'Retail Sale Id 247',1547.70,0.00,0.00,2.01,213.06,'2023-01-01 11:00:45','',''),(248,'1','308','1',1,'Retail Sale Id 248',800.80,0.00,0.00,1.04,110.24,'2023-01-01 11:36:57','',''),(249,'1','308','1',1,'Retail Sale Id 249',35500.00,0.00,0.00,50.00,2300.00,'2023-01-01 12:10:45','',''),(250,'1','308','1',1,'Retail Sale Id 250',1547.70,0.00,0.00,2.01,213.06,'2023-01-01 12:17:31','',''),(251,'1','308','1',1,'Retail Sale Id 251',2002.00,0.00,0.00,2.60,275.60,'2023-01-01 12:31:09','',''),(252,'1','308','1',1,'Retail Sale Id 252',4620.00,0.00,0.00,6.00,636.00,'2023-01-01 13:09:49','',''),(253,'1','308','1',1,'Retail Sale Id 253',800.80,0.00,0.00,1.04,110.24,'2023-01-01 13:13:30','',''),(254,'1','308','1',1,'Retail Sale Id 254',1547.70,0.00,0.00,2.01,213.06,'2023-01-01 13:38:48','',''),(255,'1','308','1',1,'Retail Sale Id 255',1547.70,0.00,0.00,2.01,213.06,'2023-01-01 13:45:36','',''),(256,'1','308','1',1,'Retail Sale Id 256',1601.60,0.00,0.00,2.08,220.48,'2023-01-01 13:47:05','',''),(257,'1','308','1',1,'Retail Sale Id 257',2348.50,0.00,0.00,3.05,323.30,'2023-01-01 15:46:41','',''),(258,'1','308','1',1,'Retail Sale Id 258',1901.90,0.00,0.00,2.47,261.82,'2023-01-01 15:51:19','',''),(259,'1','308','1',1,'Retail Sale Id 259',1001.00,0.00,0.00,1.30,137.80,'2023-01-01 15:53:45','',''),(260,'1','308','1',1,'Retail Sale Id 260',4620.00,0.00,0.00,6.00,636.00,'2023-01-01 16:05:54','',''),(261,'1','308','1',1,'Retail Sale Id 261',1601.60,0.00,0.00,2.08,220.48,'2023-01-01 16:07:53','',''),(262,'1','308','1',1,'Retail Sale Id 264',800.80,0.00,0.00,1.04,110.24,'2023-01-01 16:45:23','',''),(263,'1','308','1',1,'Retail Sale Id 265',2348.50,0.00,0.00,3.05,323.30,'2023-01-01 17:06:46','',''),(264,'1','308','1',1,'Retail Sale Id 266',4620.00,0.00,0.00,6.00,636.00,'2023-01-01 17:16:39','',''),(265,'1','308','1',1,'Return of Retail Sale Id 260',0.00,4620.00,6.00,0.00,-636.00,'2023-01-01 17:36:31','',''),(266,'1','308','1',1,'Retail Sale Id 267',5397.70,0.00,0.00,7.01,743.06,'2023-01-01 17:56:45','',''),(267,'1','308','1',1,'Retail Sale Id 268',2348.50,0.00,0.00,3.05,323.30,'2023-01-01 18:10:20','',''),(268,'1','308','1',1,'Retail Sale Id 269',800.80,0.00,0.00,1.04,110.24,'2023-01-02 09:33:50','',''),(269,'1','308','1',1,'Retail Sale Id 272',1547.70,0.00,0.00,2.01,213.06,'2023-01-02 09:45:21','',''),(270,'1','308','1',1,'Retail Sale Id 273',7700.00,0.00,0.00,10.00,1060.00,'2023-01-02 09:49:52','',''),(271,'1','308','1',1,'Retail Sale Id 284',4650.80,0.00,0.00,6.04,640.24,'2023-01-02 10:09:56','',''),(272,'1','308','1',1,'Retail Sale Id 285',11503.80,0.00,0.00,14.94,1583.64,'2023-01-02 10:13:02','',''),(273,'1','308','1',1,'Retail Sale Id 286',4650.80,0.00,0.00,6.04,640.24,'2023-01-02 10:30:05','',''),(274,'1','308','1',1,'Retail Sale Id 287',1547.70,0.00,0.00,2.01,213.06,'2023-01-02 10:41:48','',''),(275,'1','308','1',1,'Retail Sale Id 294',3103.10,0.00,0.00,4.03,427.18,'2023-01-02 10:58:41','',''),(276,'1','308','1',1,'Retail Sale Id 298',4620.00,0.00,0.00,6.00,636.00,'2023-01-02 11:14:32','',''),(277,'1','308','1',1,'Retail Sale Id 299',770.00,0.00,0.00,1.00,106.00,'2023-01-02 11:24:20','',''),(278,'1','308','1',1,'Retail Sale Id 300',1547.70,0.00,0.00,2.01,213.06,'2023-01-02 11:50:03','',''),(279,'1','308','1',1,'Retail Sale Id 301',35500.00,0.00,0.00,50.00,2300.00,'2023-01-02 12:02:25','',''),(280,'1','308','1',1,'Retail Sale Id 302',2348.50,0.00,0.00,3.05,323.30,'2023-01-02 12:08:49','',''),(281,'1','308','1',1,'Retail Sale Id 303',800.80,0.00,0.00,1.04,110.24,'2023-01-02 12:12:47','',''),(282,'1','308','1',1,'Retail Sale Id 304',1540.00,0.00,0.00,2.00,212.00,'2023-01-02 12:14:48','',''),(283,'1','308','1',1,'Retail Sale Id 305',800.80,0.00,0.00,1.04,110.24,'2023-01-02 12:28:00','',''),(284,'1','308','1',1,'Retail Sale Id 306',4620.00,0.00,0.00,6.00,636.00,'2023-01-02 13:57:29','',''),(285,'1','308','1',1,'Retail Sale Id 307',1540.00,0.00,0.00,2.00,212.00,'2023-01-02 13:59:24','',''),(286,'1','308','1',1,'Retail Sale Id 308',1547.70,0.00,0.00,2.01,213.06,'2023-01-02 14:00:59','',''),(287,'1','308','1',1,'Retail Sale Id 309',3850.00,0.00,0.00,5.00,530.00,'2023-01-02 15:28:59','',''),(288,'1','308','1',1,'Retail Sale Id 310',2310.00,0.00,0.00,3.00,318.00,'2023-01-02 15:54:16','',''),(289,'1','308','1',1,'Retail Sale Id 311',2310.00,0.00,0.00,3.00,318.00,'2023-01-02 16:09:28','',''),(290,'1','308','1',1,'Retail Sale Id 312',800.80,0.00,0.00,1.04,110.24,'2023-01-02 16:19:34','',''),(291,'1','308','1',1,'Retail Sale Id 313',4620.00,0.00,0.00,6.00,636.00,'2023-01-02 16:22:57','',''),(292,'1','308','1',1,'Retail Sale Id 314',1547.70,0.00,0.00,2.01,213.06,'2023-01-02 16:46:07','',''),(293,'1','308','1',1,'Retail Sale Id 315',4620.00,0.00,0.00,6.00,636.00,'2023-01-02 17:19:06','',''),(294,'1','308','1',1,'Retail Sale Id 316',1547.70,0.00,0.00,2.01,213.06,'2023-01-02 17:22:04','',''),(295,'1','308','1',1,'Retail Sale Id 317',3080.00,0.00,0.00,4.00,424.00,'2023-01-02 17:28:32','',''),(296,'1','308','1',1,'Retail Sale Id 318',3850.00,0.00,0.00,5.00,530.00,'2023-01-02 17:31:37','',''),(297,'1','308','1',1,'Retail Sale Id 319',4620.00,0.00,0.00,6.00,636.00,'2023-01-02 17:37:01','',''),(298,'1','308','1',1,'Retail Sale Id 323',1001.00,0.00,0.00,1.30,137.80,'2023-01-02 17:42:41','',''),(299,'1','308','1',1,'Retail Sale Id 324',3080.00,0.00,0.00,4.00,424.00,'2023-01-02 18:20:45','',''),(300,'1','308','1',1,'Retail Sale Id 325',3080.00,0.00,0.00,4.00,424.00,'2023-01-03 08:17:49','',''),(301,'1','308','1',1,'Retail Sale Id 326',8500.80,0.00,0.00,11.04,1170.24,'2023-01-03 08:32:48','',''),(302,'1','308','1',1,'Retail Sale Id 327',3850.00,0.00,0.00,5.00,530.00,'2023-01-03 08:57:01','',''),(303,'1','308','1',1,'Retail Sale Id 328',8901.20,0.00,0.00,11.56,1225.36,'2023-01-03 09:00:37','',''),(304,'1','308','1',1,'Retail Sale Id 329',3003.00,0.00,0.00,3.90,413.40,'2023-01-03 09:17:14','',''),(305,'1','308','1',1,'Retail Sale Id 330',1547.70,0.00,0.00,2.01,213.06,'2023-01-03 09:55:57','',''),(306,'1','308','1',1,'Retail Sale Id 331',3103.10,0.00,0.00,4.03,427.18,'2023-01-03 09:57:23','',''),(307,'1','308','1',1,'Retail Sale Id 332',1547.70,0.00,0.00,2.01,213.06,'2023-01-03 10:04:05','',''),(308,'1','308','1',1,'Retail Sale Id 333',1547.70,0.00,0.00,2.01,213.06,'2023-01-03 10:23:03','',''),(309,'1','308','1',1,'Retail Sale Id 334',1547.70,0.00,0.00,2.01,213.06,'2023-01-03 10:43:19','',''),(310,'1','308','1',1,'Retail Sale Id 335',6198.50,0.00,0.00,8.05,853.30,'2023-01-03 10:49:25','',''),(311,'1','308','1',1,'Retail Sale Id 337',3103.10,0.00,0.00,4.03,427.18,'2023-01-03 10:50:21','',''),(312,'1','308','1',1,'Retail Sale Id 338',4650.80,0.00,0.00,6.04,640.24,'2023-01-03 11:08:26','',''),(313,'1','308','1',1,'Retail Sale Id 339',1540.00,0.00,0.00,2.00,212.00,'2023-01-03 11:13:22','',''),(314,'1','308','1',1,'Retail Sale Id 340',4620.00,0.00,0.00,6.00,636.00,'2023-01-03 11:53:34','',''),(315,'1','308','1',1,'Retail Sale Id 341',3850.00,0.00,0.00,5.00,530.00,'2023-01-03 12:25:25','',''),(316,'1','308','1',1,'Retail Sale Id 342',800.80,0.00,0.00,1.04,110.24,'2023-01-03 13:14:42','',''),(317,'1','308','1',1,'Retail Sale Id 344',142000.00,0.00,0.00,200.00,9200.00,'2023-01-03 14:47:05','',''),(318,'1','308','1',1,'Retail Sale Id 345',2348.50,0.00,0.00,3.05,323.30,'2023-01-03 14:52:35','',''),(319,'1','308','1',1,'Retail Sale Id 346',1547.70,0.00,0.00,2.01,213.06,'2023-01-03 15:02:53','',''),(320,'1','308','1',1,'Retail Sale Id 347',800.80,0.00,0.00,1.04,110.24,'2023-01-03 15:09:31','',''),(321,'1','308','1',1,'Retail Sale Id 349',2310.00,0.00,0.00,3.00,318.00,'2023-01-03 15:16:22','',''),(322,'1','308','1',1,'Retail Sale Id 350',3103.10,0.00,0.00,4.03,427.18,'2023-01-03 16:23:22','',''),(323,'1','308','1',1,'Retail Sale Id 351',6160.00,0.00,0.00,8.00,848.00,'2023-01-03 16:32:44','',''),(324,'1','308','1',1,'Retail Sale Id 352',4620.00,0.00,0.00,6.00,636.00,'2023-01-03 16:48:24','',''),(325,'1','308','1',1,'Retail Sale Id 353',35500.00,0.00,0.00,50.00,2300.00,'2023-01-03 17:20:40','',''),(326,'1','308','1',1,'Retail Sale Id 354',1501.50,0.00,0.00,1.95,206.70,'2023-01-03 17:25:50','',''),(327,'1','308','1',1,'Retail Sale Id 355',2302.30,0.00,0.00,2.99,316.94,'2023-01-03 17:32:43','',''),(328,'1','308','1',1,'Retail Sale Id 356',2302.30,0.00,0.00,2.99,316.94,'2023-01-03 18:08:25','',''),(329,'1','308','1',1,'Retail Sale Id 357',38.50,0.00,0.00,0.05,5.30,'2023-01-03 18:31:57','',''),(330,'1','308','1',1,'Retail Sale Id 358',6953.10,0.00,0.00,9.03,957.18,'2023-01-04 09:32:39','',''),(331,'1','308','1',1,'Retail Sale Id 359',8470.00,0.00,0.00,11.00,1166.00,'2023-01-04 09:37:57','',''),(332,'1','308','1',1,'Retail Sale Id 361',1540.00,0.00,0.00,2.00,212.00,'2023-01-04 09:58:57','',''),(333,'1','308','1',1,'Retail Sale Id 362',4620.00,0.00,0.00,6.00,636.00,'2023-01-04 10:15:18','',''),(334,'1','308','1',1,'Retail Sale Id 363',2310.00,0.00,0.00,3.00,318.00,'2023-01-04 11:08:14','',''),(335,'1','308','1',1,'Retail Sale Id 364',3080.00,0.00,0.00,4.00,424.00,'2023-01-04 11:12:05','',''),(336,'1','308','1',1,'Retail Sale Id 365',1540.00,0.00,0.00,2.00,212.00,'2023-01-04 11:19:56','',''),(337,'1','308','1',1,'Retail Sale Id 366',1001.00,0.00,0.00,1.30,137.80,'2023-01-04 13:03:53','',''),(338,'1','308','1',1,'Retail Sale Id 367',1501.50,0.00,0.00,1.95,206.70,'2023-01-04 13:17:49','',''),(339,'1','308','1',1,'Retail Sale Id 370',4620.00,0.00,0.00,6.00,636.00,'2023-01-04 13:53:53','',''),(340,'1','308','1',1,'Retail Sale Id 372',1540.00,0.00,0.00,2.00,212.00,'2023-01-04 14:16:26','',''),(341,'1','308','1',1,'Retail Sale Id 374',2002.00,0.00,0.00,2.60,275.60,'2023-01-04 14:49:33','',''),(342,'1','308','1',1,'Retail Sale Id 375',1540.00,0.00,0.00,2.00,212.00,'2023-01-04 15:23:23','',''),(343,'1','308','1',1,'Retail Sale Id 376',800.80,0.00,0.00,1.04,110.24,'2023-01-04 15:35:18','',''),(344,'1','308','1',1,'Retail Sale Id 378',9625.00,0.00,0.00,12.50,1325.00,'2023-01-04 15:46:53','',''),(345,'1','308','1',1,'Retail Sale Id 379',2310.00,0.00,0.00,3.00,318.00,'2023-01-04 16:05:05','',''),(346,'1','308','1',1,'Retail Sale Id 382',1540.00,0.00,0.00,2.00,212.00,'2023-01-04 16:57:00','',''),(347,'1','308','1',1,'Retail Sale Id 383',2310.00,0.00,0.00,3.00,318.00,'2023-01-04 17:14:37','',''),(348,'1','308','1',1,'Retail Sale Id 385',9625.00,0.00,0.00,12.50,1325.00,'2023-01-04 17:17:24','',''),(349,'1','308','1',1,'Retail Sale Id 386',3080.00,0.00,0.00,4.00,424.00,'2023-01-04 17:33:59','',''),(350,'1','308','1',1,'Retail Sale Id 387',1540.00,0.00,0.00,2.00,212.00,'2023-01-04 17:40:12','',''),(351,'1','308','1',1,'Retail Sale Id 388',46.20,0.00,0.00,0.06,6.36,'2023-01-04 19:05:28','',''),(352,'1','308','1',1,'Retail Sale Id 389',8500.80,0.00,0.00,11.04,1170.24,'2023-01-05 07:59:38','',''),(353,'1','308','1',1,'Retail Sale Id 390',3850.00,0.00,0.00,5.00,530.00,'2023-01-05 08:08:21','',''),(354,'1','308','1',1,'Retail Sale Id 391',2310.00,0.00,0.00,3.00,318.00,'2023-01-05 08:15:11','',''),(355,'1','308','1',1,'Retail Sale Id 392',800.80,0.00,0.00,1.04,110.24,'2023-01-05 08:35:55','',''),(356,'1','308','1',1,'Retail Sale Id 393',4650.80,0.00,0.00,6.04,640.24,'2023-01-05 08:47:33','',''),(357,'1','308','1',1,'Retail Sale Id 394',4620.00,0.00,0.00,6.00,636.00,'2023-01-05 09:13:33','',''),(358,'1','308','1',1,'Retail Sale Id 395',3080.00,0.00,0.00,4.00,424.00,'2023-01-05 09:19:06','',''),(359,'1','308','1',1,'Retail Sale Id 396',2310.00,0.00,0.00,3.00,318.00,'2023-01-05 09:23:40','',''),(360,'1','308','1',1,'Retail Sale Id 397',4620.00,0.00,0.00,6.00,636.00,'2023-01-05 09:26:03','',''),(361,'1','308','1',1,'Retail Sale Id 398',2317.70,0.00,0.00,3.01,319.06,'2023-01-05 09:34:02','',''),(362,'1','308','1',1,'Retail Sale Id 399',1547.70,0.00,0.00,2.01,213.06,'2023-01-05 09:43:55','',''),(363,'1','308','1',1,'Retail Sale Id 400',1547.70,0.00,0.00,2.01,213.06,'2023-01-05 09:57:50','',''),(364,'1','308','1',1,'Retail Sale Id 401',800.80,0.00,0.00,1.04,110.24,'2023-01-05 10:04:09','',''),(365,'1','308','1',1,'Retail Sale Id 402',800.80,0.00,0.00,1.04,110.24,'2023-01-05 10:23:22','',''),(366,'1','308','1',1,'Retail Sale Id 403',3103.10,0.00,0.00,4.03,427.18,'2023-01-05 10:32:06','',''),(367,'1','308','1',1,'Retail Sale Id 404',800.80,0.00,0.00,1.04,110.24,'2023-01-05 11:00:12','',''),(368,'1','308','1',1,'Retail Sale Id 405',3850.00,0.00,0.00,5.00,530.00,'2023-01-05 11:04:12','',''),(369,'1','308','1',1,'Retail Sale Id 406',2302.30,0.00,0.00,2.99,316.94,'2023-01-05 11:06:56','',''),(370,'1','308','1',1,'Retail Sale Id 407',47925.00,0.00,0.00,67.50,3105.00,'2023-01-05 11:46:27','',''),(371,'1','308','1',1,'Retail Sale Id 408',3110.80,0.00,0.00,4.04,428.24,'2023-01-05 12:29:42','',''),(372,'1','308','1',1,'Retail Sale Id 409',770.00,0.00,0.00,1.00,106.00,'2023-01-05 12:30:42','',''),(373,'1','308','1',1,'Retail Sale Id 410',3850.00,0.00,0.00,5.00,530.00,'2023-01-05 12:32:32','',''),(374,'1','308','1',1,'Retail Sale Id 411',1801.80,0.00,0.00,2.34,248.04,'2023-01-05 12:43:19','',''),(375,'1','308','1',1,'Retail Sale Id 412',4650.80,0.00,0.00,6.04,640.24,'2023-01-05 13:15:26','',''),(376,'1','308','1',1,'Retail Sale Id 413',3080.00,0.00,0.00,4.00,424.00,'2023-01-05 13:57:09','',''),(377,'1','308','1',1,'Retail Sale Id 414',3850.00,0.00,0.00,5.00,530.00,'2023-01-05 14:38:03','',''),(378,'1','308','1',1,'Retail Sale Id 415',800.80,0.00,0.00,1.04,110.24,'2023-01-05 16:24:47','',''),(379,'1','308','1',1,'Retail Sale Id 416',770.00,0.00,0.00,1.00,106.00,'2023-01-05 16:39:37','',''),(380,'1','308','1',1,'Retail Sale Id 416',770.00,0.00,0.00,1.00,106.00,'2023-01-05 16:39:37','',''),(381,'1','308','1',1,'Retail Sale Id 417',4620.00,0.00,0.00,6.00,636.00,'2023-01-05 16:41:04','',''),(382,'1','308','1',1,'Retail Sale Id 418',770.00,0.00,0.00,1.00,106.00,'2023-01-05 16:47:57','',''),(383,'1','308','1',1,'Retail Sale Id 419',1501.50,0.00,0.00,1.95,206.70,'2023-01-05 17:04:52','',''),(384,'1','308','1',1,'Retail Sale Id 420',3850.00,0.00,0.00,5.00,530.00,'2023-01-05 17:11:44','',''),(385,'1','308','1',1,'Retail Sale Id 421',9625.00,0.00,0.00,12.50,1325.00,'2023-01-05 17:25:06','',''),(386,'1','308','1',1,'Retail Sale Id 422',4858.70,0.00,0.00,6.31,668.86,'2023-01-05 17:33:34','',''),(387,'1','308','1',1,'Retail Sale Id 423',4620.00,0.00,0.00,6.00,636.00,'2023-01-05 17:51:04','',''),(388,'1','308','1',1,'Retail Sale Id 424',1540.00,0.00,0.00,2.00,212.00,'2023-01-05 18:04:00','',''),(389,'1','308','1',1,'Retail Sale Id 425',2317.70,0.00,0.00,3.01,319.06,'2023-01-05 18:08:28','',''),(390,'1','308','1',1,'Retail Sale Id 426',1547.70,0.00,0.00,2.01,213.06,'2023-01-05 18:23:02','',''),(391,'1','308','1',1,'Retail Sale Id 427',800.80,0.00,0.00,1.04,110.24,'2023-01-05 18:24:13','',''),(392,'1','308','1',1,'Retail Sale Id 428',7.70,0.00,0.00,0.01,1.06,'2023-01-05 19:35:59','',''),(393,'1','308','1',1,'Retail Sale Id 429',9648.10,0.00,0.00,12.53,1328.18,'2023-01-06 08:52:00','',''),(394,'1','308','1',1,'Retail Sale Id 430',3850.00,0.00,0.00,5.00,530.00,'2023-01-06 08:56:57','',''),(395,'1','308','1',1,'Retail Sale Id 431',14630.00,0.00,0.00,19.00,2014.00,'2023-01-06 09:02:17','',''),(396,'1','308','1',1,'Retail Sale Id 432',1547.70,0.00,0.00,2.01,213.06,'2023-01-06 09:32:31','',''),(397,'1','308','1',1,'Retail Sale Id 433',9625.00,0.00,0.00,12.50,1325.00,'2023-01-06 09:46:47','',''),(398,'1','308','1',1,'Retail Sale Id 434',2310.00,0.00,0.00,3.00,318.00,'2023-01-06 09:53:19','',''),(399,'1','308','1',1,'Retail Sale Id 436',3850.00,0.00,0.00,5.00,530.00,'2023-01-06 10:31:24','',''),(400,'1','308','1',1,'Retail Sale Id 437',3850.00,0.00,0.00,5.00,530.00,'2023-01-06 11:01:19','',''),(401,'1','308','1',1,'Retail Sale Id 438',7700.00,0.00,0.00,10.00,1060.00,'2023-01-06 11:14:57','',''),(402,'1','308','1',1,'Retail Sale Id 439',1547.70,0.00,0.00,2.01,213.06,'2023-01-06 11:22:51','',''),(403,'1','308','1',1,'Retail Sale Id 440',4650.80,0.00,0.00,6.04,640.24,'2023-01-06 11:40:10','',''),(404,'1','308','1',1,'Retail Sale Id 441',1547.70,0.00,0.00,2.01,213.06,'2023-01-06 11:46:17','',''),(405,'1','308','1',1,'Retail Sale Id 442',3850.00,0.00,0.00,5.00,530.00,'2023-01-06 12:41:56','',''),(406,'1','308','1',1,'Retail Sale Id 443',3080.00,0.00,0.00,4.00,424.00,'2023-01-06 13:10:03','',''),(407,'1','308','1',1,'Retail Sale Id 444',6160.00,0.00,0.00,8.00,848.00,'2023-01-06 13:12:16','',''),(408,'1','308','1',1,'Retail Sale Id 445',2310.00,0.00,0.00,3.00,318.00,'2023-01-06 13:44:03','',''),(409,'1','308','1',1,'Retail Sale Id 447',3080.00,0.00,0.00,4.00,424.00,'2023-01-06 14:56:45','',''),(410,'1','308','1',1,'Retail Sale Id 448',1501.50,0.00,0.00,1.95,206.70,'2023-01-06 14:59:48','',''),(411,'1','308','1',1,'Retail Sale Id 449',500.50,0.00,0.00,0.65,68.90,'2023-01-06 15:28:09','',''),(412,'1','308','1',1,'Retail Sale Id 450',800.80,0.00,0.00,1.04,110.24,'2023-01-06 16:05:36','',''),(413,'1','308','1',1,'Retail Sale Id 451',1547.70,0.00,0.00,2.01,213.06,'2023-01-06 16:27:38','',''),(414,'1','308','1',1,'Retail Sale Id 452',800.80,0.00,0.00,1.04,110.24,'2023-01-06 16:39:54','',''),(415,'1','308','1',1,'Retail Sale Id 454',1547.70,0.00,0.00,2.01,213.06,'2023-01-06 16:48:05','',''),(416,'1','308','1',1,'Retail Sale Id 455',4650.80,0.00,0.00,6.04,640.24,'2023-01-06 17:04:02','',''),(417,'1','308','1',1,'Retail Sale Id 456',3103.10,0.00,0.00,4.03,427.18,'2023-01-06 17:05:22','',''),(418,'1','308','1',1,'Retail Sale Id 457',7700.00,0.00,0.00,10.00,1060.00,'2023-01-06 17:20:57','',''),(419,'1','308','1',1,'Retail Sale Id 458',1547.70,0.00,0.00,2.01,213.06,'2023-01-06 17:25:18','',''),(420,'1','308','1',1,'Retail Sale Id 459',3103.10,0.00,0.00,4.03,427.18,'2023-01-06 17:34:33','',''),(421,'1','308','1',1,'Retail Sale Id 460',500.50,0.00,0.00,0.65,68.90,'2023-01-06 17:51:06','',''),(422,'1','308','1',1,'Retail Sale Id 461',9247.70,0.00,0.00,12.01,1273.06,'2023-01-06 18:02:32','',''),(423,'1','308','1',1,'Retail Sale Id 462',3850.00,0.00,0.00,5.00,530.00,'2023-01-06 18:16:00','',''),(424,'1','308','1',1,'Return of Retail Sale Id 444',0.00,6160.00,8.00,0.00,-848.00,'2023-01-06 18:29:13','',''),(425,'1','308','1',1,'Retail Sale Id 463',2286.90,0.00,0.00,2.97,314.82,'2023-01-06 18:29:52','',''),(426,'1','308','1',1,'Return of Retail Sale Id 463',0.00,2286.90,2.97,0.00,-314.82,'2023-01-06 19:32:40','',''),(427,'1','308','1',1,'Retail Sale Id 464',1932.70,0.00,0.00,2.51,266.06,'2023-01-06 19:33:45','',''),(428,'1','308','1',1,'Retail Sale Id 465',7700.00,0.00,0.00,10.00,1060.00,'2023-01-07 08:04:35','',''),(429,'1','308','1',1,'Retail Sale Id 466',3996.30,0.00,0.00,5.19,550.14,'2023-01-07 08:05:12','',''),(430,'1','308','1',1,'Retail Sale Id 467',4620.00,0.00,0.00,6.00,636.00,'2023-01-07 08:35:01','',''),(431,'1','308','1',1,'Retail Sale Id 468',2302.30,0.00,0.00,2.99,316.94,'2023-01-07 08:40:47','',''),(432,'1','308','1',1,'Retail Sale Id 469',3103.10,0.00,0.00,4.03,427.18,'2023-01-07 08:46:18','',''),(433,'1','308','1',1,'Retail Sale Id 470',6953.10,0.00,0.00,9.03,957.18,'2023-01-07 08:53:07','',''),(434,'1','308','1',1,'Retail Sale Id 471',4620.00,0.00,0.00,6.00,636.00,'2023-01-07 08:58:41','',''),(435,'1','308','1',1,'Retail Sale Id 472',4620.00,0.00,0.00,6.00,636.00,'2023-01-07 09:09:56','',''),(436,'1','308','1',1,'Retail Sale Id 473',3850.00,0.00,0.00,5.00,530.00,'2023-01-07 10:24:34','',''),(437,'1','308','1',1,'Retail Sale Id 474',1501.50,0.00,0.00,1.95,206.70,'2023-01-07 10:42:34','',''),(438,'1','308','1',1,'Retail Sale Id 475',39050.00,0.00,0.00,55.00,2530.00,'2023-01-07 11:05:49','',''),(439,'1','308','1',1,'Retail Sale Id 476',4620.00,0.00,0.00,6.00,636.00,'2023-01-07 11:21:52','',''),(440,'1','308','1',1,'Retail Sale Id 477',4620.00,0.00,0.00,6.00,636.00,'2023-01-07 11:24:12','',''),(441,'1','308','1',1,'Retail Sale Id 478',4627.70,0.00,0.00,6.01,637.06,'2023-01-07 11:29:11','',''),(442,'1','308','1',1,'Retail Sale Id 479',2310.00,0.00,0.00,3.00,318.00,'2023-01-07 11:50:13','',''),(443,'1','308','1',1,'Retail Sale Id 480',770.00,0.00,0.00,1.00,106.00,'2023-01-07 12:10:21','',''),(444,'1','308','1',1,'Retail Sale Id 481',1540.00,0.00,0.00,2.00,212.00,'2023-01-07 12:33:07','',''),(445,'1','308','1',1,'Retail Sale Id 482',2002.00,0.00,0.00,2.60,275.60,'2023-01-07 12:33:59','',''),(446,'1','308','1',1,'Retail Sale Id 483',770.00,0.00,0.00,1.00,106.00,'2023-01-07 12:46:42','',''),(447,'1','308','1',1,'Retail Sale Id 484',1540.00,0.00,0.00,2.00,212.00,'2023-01-07 13:22:53','',''),(448,'1','308','1',1,'Retail Sale Id 485',3103.10,0.00,0.00,4.03,427.18,'2023-01-07 13:44:57','',''),(449,'1','308','1',1,'Retail Sale Id 486',4620.00,0.00,0.00,6.00,636.00,'2023-01-07 13:46:41','',''),(450,'1','308','1',1,'Retail Sale Id 487',1540.00,0.00,0.00,2.00,212.00,'2023-01-07 14:34:25','',''),(451,'1','308','1',1,'Retail Sale Id 488',800.80,0.00,0.00,1.04,110.24,'2023-01-07 15:33:48','',''),(452,'1','308','1',1,'Retail Sale Id 489',11596.20,0.00,0.00,15.06,1596.36,'2023-01-07 15:39:17','',''),(453,'1','308','1',1,'Retail Sale Id 490',2302.30,0.00,0.00,2.99,316.94,'2023-01-07 15:52:46','',''),(454,'1','308','1',1,'Retail Sale Id 491',800.80,0.00,0.00,1.04,110.24,'2023-01-07 15:53:43','',''),(455,'1','308','1',1,'Retail Sale Id 492',3103.10,0.00,0.00,4.03,427.18,'2023-01-07 15:54:50','',''),(456,'1','308','1',1,'Retail Sale Id 493',2302.30,0.00,0.00,2.99,316.94,'2023-01-07 15:56:22','',''),(457,'1','308','1',1,'Retail Sale Id 494',2310.00,0.00,0.00,3.00,318.00,'2023-01-07 16:11:36','',''),(458,'1','308','1',1,'Retail Sale Id 495',800.80,0.00,0.00,1.04,110.24,'2023-01-07 16:26:27','',''),(459,'1','308','1',1,'Retail Sale Id 496',2302.30,0.00,0.00,2.99,316.94,'2023-01-07 17:16:03','',''),(460,'1','308','1',1,'Retail Sale Id 497',1001.00,0.00,0.00,1.30,137.80,'2023-01-07 17:30:08','',''),(461,'1','308','1',1,'Retail Sale Id 498',2302.30,0.00,0.00,2.99,316.94,'2023-01-07 17:47:41','',''),(462,'1','308','1',1,'Retail Sale Id 499',800.80,0.00,0.00,1.04,110.24,'2023-01-07 17:48:35','',''),(463,'1','308','1',1,'Retail Sale Id 500',770.00,0.00,0.00,1.00,106.00,'2023-01-07 17:52:35','',''),(464,'1','308','1',1,'Retail Sale Id 501',3996.30,0.00,0.00,5.19,550.14,'2023-01-07 17:58:35','',''),(465,'1','308','1',1,'Retail Sale Id 502',2348.50,0.00,0.00,3.05,323.30,'2023-01-07 18:02:03','',''),(466,'1','308','1',1,'Retail Sale Id 503',1547.70,0.00,0.00,2.01,213.06,'2023-01-07 18:17:49','',''),(467,'1','308','1',1,'Retail Sale Id 504',15.40,0.00,0.00,0.02,2.12,'2023-01-07 19:17:04','',''),(468,'1','308','1',1,'Retail Sale Id 505',1547.70,0.00,0.00,2.01,213.06,'2023-01-08 08:32:12','',''),(469,'1','308','1',1,'Retail Sale Id 506',1540.00,0.00,0.00,2.00,212.00,'2023-01-08 08:33:35','',''),(470,'1','308','1',1,'Retail Sale Id 507',3103.10,0.00,0.00,4.03,427.18,'2023-01-08 08:35:31','',''),(471,'1','308','1',1,'Retail Sale Id 508',3850.00,0.00,0.00,5.00,530.00,'2023-01-08 09:24:34','',''),(472,'1','308','1',1,'Retail Sale Id 509',2310.00,0.00,0.00,3.00,318.00,'2023-01-08 09:30:08','',''),(473,'1','308','1',1,'Retail Sale Id 511',800.80,0.00,0.00,1.04,110.24,'2023-01-08 09:40:38','',''),(474,'1','308','1',1,'Retail Sale Id 512',1501.50,0.00,0.00,1.95,206.70,'2023-01-08 09:43:46','',''),(475,'1','308','1',1,'Retail Sale Id 513',9240.00,0.00,0.00,12.00,1272.00,'2023-01-08 10:01:31','',''),(476,'1','308','1',1,'Retail Sale Id 514',2310.00,0.00,0.00,3.00,318.00,'2023-01-08 10:04:53','',''),(477,'1','308','1',1,'Retail Sale Id 517',9625.00,0.00,0.00,12.50,1325.00,'2023-01-08 10:13:26','',''),(478,'1','308','1',1,'Retail Sale Id 518',2002.00,0.00,0.00,2.60,275.60,'2023-01-08 10:15:35','',''),(479,'1','308','1',1,'Retail Sale Id 520',1547.70,0.00,0.00,2.01,213.06,'2023-01-08 10:17:27','',''),(480,'1','308','1',1,'Retail Sale Id 521',2310.00,0.00,0.00,3.00,318.00,'2023-01-08 10:20:25','',''),(481,'1','308','1',1,'Retail Sale Id 523',1547.70,0.00,0.00,2.01,213.06,'2023-01-08 10:38:38','',''),(482,'1','308','1',1,'Retail Sale Id 524',770.00,0.00,0.00,1.00,106.00,'2023-01-08 10:43:05','',''),(483,'1','308','1',1,'Retail Sale Id 525',1547.70,0.00,0.00,2.01,213.06,'2023-01-08 10:44:33','',''),(484,'1','308','1',1,'Retail Sale Id 526',770.00,0.00,0.00,1.00,106.00,'2023-01-08 10:56:08','',''),(485,'1','308','1',1,'Retail Sale Id 527',3080.00,0.00,0.00,4.00,424.00,'2023-01-08 11:09:36','',''),(486,'1','308','1',1,'Retail Sale Id 528',2310.00,0.00,0.00,3.00,318.00,'2023-01-08 11:13:13','',''),(487,'1','308','1',1,'Retail Sale Id 529',1925.00,0.00,0.00,2.50,265.00,'2023-01-08 11:28:46','',''),(488,'1','308','1',1,'Retail Sale Id 530',1001.00,0.00,0.00,1.30,137.80,'2023-01-08 11:35:34','',''),(489,'1','308','1',1,'Retail Sale Id 531',2310.00,0.00,0.00,3.00,318.00,'2023-01-08 11:39:36','',''),(490,'1','308','1',1,'Retail Sale Id 532',9625.00,0.00,0.00,12.50,1325.00,'2023-01-08 11:48:02','',''),(491,'1','308','1',1,'Retail Sale Id 533',700.70,0.00,0.00,0.91,96.46,'2023-01-08 12:06:04','',''),(492,'1','308','1',1,'Retail Sale Id 534',4620.00,0.00,0.00,6.00,636.00,'2023-01-08 12:09:18','',''),(493,'1','308','1',1,'Retail Sale Id 535',2310.00,0.00,0.00,3.00,318.00,'2023-01-08 12:24:24','',''),(494,'1','308','1',1,'Retail Sale Id 536',9625.00,0.00,0.00,12.50,1325.00,'2023-01-08 12:39:56','',''),(495,'1','308','1',1,'Retail Sale Id 537',3996.30,0.00,0.00,5.19,550.14,'2023-01-08 13:13:46','',''),(496,'1','308','1',1,'Retail Sale Id 540',2310.00,0.00,0.00,3.00,318.00,'2023-01-08 13:39:14','',''),(497,'1','308','1',1,'Retail Sale Id 542',4620.00,0.00,0.00,6.00,636.00,'2023-01-08 13:42:35','',''),(498,'1','308','1',1,'Retail Sale Id 543',4620.00,0.00,0.00,6.00,636.00,'2023-01-08 13:48:20','',''),(499,'1','308','1',1,'Return of Retail Sale Id 540',0.00,2310.00,3.00,0.00,-318.00,'2023-01-08 13:54:11','',''),(500,'1','308','1',1,'Retail Sale Id 544',9648.10,0.00,0.00,12.53,1328.18,'2023-01-08 13:56:55','',''),(501,'1','308','1',1,'Retail Sale Id 545',3080.00,0.00,0.00,4.00,424.00,'2023-01-08 13:59:52','',''),(502,'1','308','1',1,'Retail Sale Id 546',3850.00,0.00,0.00,5.00,530.00,'2023-01-08 14:04:22','',''),(503,'1','308','1',1,'Retail Sale Id 547',9648.10,0.00,0.00,12.53,1328.18,'2023-01-08 14:09:24','',''),(504,'1','308','1',1,'Retail Sale Id 548',2310.00,0.00,0.00,3.00,318.00,'2023-01-08 14:18:15','',''),(505,'1','308','1',1,'Retail Sale Id 550',9625.00,0.00,0.00,12.50,1325.00,'2023-01-08 14:26:06','',''),(506,'1','308','1',1,'Retail Sale Id 551',2310.00,0.00,0.00,3.00,318.00,'2023-01-08 14:42:08','',''),(507,'1','308','1',1,'Retail Sale Id 552',2310.00,0.00,0.00,3.00,318.00,'2023-01-08 14:54:32','',''),(508,'1','308','1',1,'Retail Sale Id 553',2310.00,0.00,0.00,3.00,318.00,'2023-01-08 14:55:38','',''),(509,'1','308','1',1,'Retail Sale Id 555',1547.70,0.00,0.00,2.01,213.06,'2023-01-08 15:31:12','',''),(510,'1','308','1',1,'Retail Sale Id 556',770.00,0.00,0.00,1.00,106.00,'2023-01-08 16:03:13','',''),(511,'1','308','1',1,'Retail Sale Id 557',96250.00,0.00,0.00,125.00,13250.00,'2023-01-08 16:09:02','',''),(512,'1','308','1',1,'Retail Sale Id 558',9625.00,0.00,0.00,12.50,1325.00,'2023-01-08 16:12:00','',''),(513,'1','308','1',1,'Retail Sale Id 559',3850.00,0.00,0.00,5.00,530.00,'2023-01-08 16:56:04','',''),(514,'1','308','1',1,'Retail Sale Id 560',3087.70,0.00,0.00,4.01,425.06,'2023-01-08 17:06:31','',''),(515,'1','308','1',1,'Retail Sale Id 561',3850.00,0.00,0.00,5.00,530.00,'2023-01-08 17:12:37','',''),(516,'1','308','1',1,'Return of Retail Sale Id 557',0.00,96250.00,125.00,0.00,-13250.00,'2023-01-08 17:17:55','',''),(517,'1','308','1',1,'Retail Sale Id 562',3850.00,0.00,0.00,5.00,530.00,'2023-01-08 17:19:24','',''),(518,'1','308','1',1,'Retail Sale Id 563',2310.00,0.00,0.00,3.00,318.00,'2023-01-08 17:23:51','',''),(519,'1','308','1',1,'Retail Sale Id 564',2310.00,0.00,0.00,3.00,318.00,'2023-01-08 17:45:40','',''),(520,'1','308','1',1,'Retail Sale Id 565',800.80,0.00,0.00,1.04,110.24,'2023-01-08 17:58:41','',''),(521,'1','308','1',1,'Retail Sale Id 566',5513.20,0.00,0.00,7.16,758.96,'2023-01-08 19:12:32','',''),(522,'1','308','1',1,'Retail Sale Id 567',800.80,0.00,0.00,1.04,110.24,'2023-01-09 08:02:21','',''),(523,'1','308','1',1,'Retail Sale Id 568',800.80,0.00,0.00,1.04,110.24,'2023-01-09 08:13:01','',''),(524,'1','308','1',1,'Retail Sale Id 569',4650.80,0.00,0.00,6.04,640.24,'2023-01-09 08:14:12','',''),(525,'1','308','1',1,'Retail Sale Id 570',2310.00,0.00,0.00,3.00,318.00,'2023-01-09 08:24:17','',''),(526,'1','308','1',1,'Retail Sale Id 571',1547.70,0.00,0.00,2.01,213.06,'2023-01-09 08:25:48','',''),(527,'1','308','1',1,'Retail Sale Id 572',3850.00,0.00,0.00,5.00,530.00,'2023-01-09 08:27:03','',''),(528,'1','308','1',1,'Retail Sale Id 573',1547.70,0.00,0.00,2.01,213.06,'2023-01-09 08:40:38','',''),(529,'1','308','1',1,'Retail Sale Id 574',4620.00,0.00,0.00,6.00,636.00,'2023-01-09 09:02:15','',''),(530,'1','308','1',1,'Retail Sale Id 575',16693.60,0.00,0.00,21.68,2298.08,'2023-01-09 09:04:23','',''),(531,'1','308','1',1,'Retail Sale Id 576',9648.10,0.00,0.00,12.53,1328.18,'2023-01-09 09:08:04','',''),(532,'1','308','1',1,'Retail Sale Id 577',2310.00,0.00,0.00,3.00,318.00,'2023-01-09 09:42:22','',''),(533,'1','308','1',1,'Retail Sale Id 578',2002.00,0.00,0.00,2.60,275.60,'2023-01-09 09:47:48','',''),(534,'1','308','1',1,'Retail Sale Id 579',2109.80,0.00,0.00,2.74,290.44,'2023-01-09 09:48:52','',''),(535,'1','308','1',1,'Retail Sale Id 580',800.80,0.00,0.00,1.04,110.24,'2023-01-09 10:37:04','',''),(536,'1','308','1',1,'Retail Sale Id 581',2348.50,0.00,0.00,3.05,323.30,'2023-01-09 10:52:47','',''),(537,'1','308','1',1,'Retail Sale Id 582',2310.00,0.00,0.00,3.00,318.00,'2023-01-09 11:48:27','',''),(538,'1','308','1',1,'Retail Sale Id 583',4620.00,0.00,0.00,6.00,636.00,'2023-01-09 11:49:44','',''),(539,'1','308','1',1,'Retail Sale Id 584',2310.00,0.00,0.00,3.00,318.00,'2023-01-09 11:52:16','',''),(540,'1','308','1',1,'Retail Sale Id 585',1547.70,0.00,0.00,2.01,213.06,'2023-01-09 11:56:52','',''),(541,'1','308','1',1,'Retail Sale Id 586',2302.30,0.00,0.00,2.99,316.94,'2023-01-09 11:58:16','',''),(542,'1','308','1',1,'Retail Sale Id 587',4620.00,0.00,0.00,6.00,636.00,'2023-01-09 12:24:38','',''),(543,'1','308','1',1,'Retail Sale Id 588',800.80,0.00,0.00,1.04,110.24,'2023-01-09 12:31:34','',''),(544,'1','308','1',1,'Retail Sale Id 589',9247.70,0.00,0.00,12.01,1273.06,'2023-01-09 12:57:39','',''),(545,'1','308','1',1,'Retail Sale Id 590',4596.90,0.00,0.00,5.97,632.82,'2023-01-09 13:18:22','',''),(546,'1','308','1',1,'Retail Sale Id 591',2310.00,0.00,0.00,3.00,318.00,'2023-01-09 14:18:29','',''),(547,'1','308','1',1,'Retail Sale Id 592',3850.00,0.00,0.00,5.00,530.00,'2023-01-09 14:23:13','',''),(548,'1','308','1',1,'Retail Sale Id 593',4620.00,0.00,0.00,6.00,636.00,'2023-01-09 14:49:34','',''),(549,'1','308','1',1,'Retail Sale Id 594',9648.10,0.00,0.00,12.53,1328.18,'2023-01-09 14:50:59','',''),(550,'1','308','1',1,'Retail Sale Id 595',1547.70,0.00,0.00,2.01,213.06,'2023-01-09 14:51:53','',''),(551,'1','308','1',1,'Retail Sale Id 596',3103.10,0.00,0.00,4.03,427.18,'2023-01-09 14:53:16','',''),(552,'1','308','1',1,'Retail Sale Id 597',2302.30,0.00,0.00,2.99,316.94,'2023-01-09 15:01:23','',''),(553,'1','308','1',1,'Retail Sale Id 598',1540.00,0.00,0.00,2.00,212.00,'2023-01-09 16:00:30','',''),(554,'1','308','1',1,'Retail Sale Id 599',1547.70,0.00,0.00,2.01,213.06,'2023-01-09 16:13:35','',''),(555,'1','308','1',1,'Retail Sale Id 600',800.80,0.00,0.00,1.04,110.24,'2023-01-09 16:14:59','',''),(556,'1','308','1',1,'Retail Sale Id 601',3311.00,0.00,0.00,4.30,455.80,'2023-01-09 16:17:20','',''),(557,'1','308','1',1,'Retail Sale Id 602',35500.00,0.00,0.00,50.00,2300.00,'2023-01-09 16:18:46','',''),(558,'1','308','1',1,'Retail Sale Id 603',9240.00,0.00,0.00,12.00,1272.00,'2023-01-09 16:24:07','',''),(559,'1','308','1',1,'Retail Sale Id 604',7700.00,0.00,0.00,10.00,1060.00,'2023-01-09 17:08:30','',''),(560,'1','308','1',1,'Retail Sale Id 605',1540.00,0.00,0.00,2.00,212.00,'2023-01-09 17:16:17','',''),(561,'1','308','1',1,'Retail Sale Id 606',3080.00,0.00,0.00,4.00,424.00,'2023-01-09 17:23:10','',''),(562,'1','308','1',1,'Retail Sale Id 607',10010.00,0.00,0.00,13.00,1378.00,'2023-01-09 17:23:52','',''),(563,'1','308','1',1,'Retail Sale Id 608',2310.00,0.00,0.00,3.00,318.00,'2023-01-09 17:26:04','',''),(564,'1','308','1',1,'Retail Sale Id 609',1540.00,0.00,0.00,2.00,212.00,'2023-01-09 17:34:45','',''),(565,'1','308','1',1,'Retail Sale Id 610',3080.00,0.00,0.00,4.00,424.00,'2023-01-09 17:39:09','',''),(566,'1','308','1',1,'Retail Sale Id 611',4620.00,0.00,0.00,6.00,636.00,'2023-01-09 17:41:10','',''),(567,'1','308','1',1,'Retail Sale Id 612',3850.00,0.00,0.00,5.00,530.00,'2023-01-09 17:44:37','',''),(568,'1','308','1',1,'Retail Sale Id 613',3080.00,0.00,0.00,4.00,424.00,'2023-01-09 17:46:17','',''),(569,'1','308','1',1,'Retail Sale Id 614',2310.00,0.00,0.00,3.00,318.00,'2023-01-09 17:51:53','',''),(570,'1','308','1',1,'Retail Sale Id 615',2310.00,0.00,0.00,3.00,318.00,'2023-01-09 17:53:31','',''),(571,'1','308','1',1,'Retail Sale Id 616',1501.50,0.00,0.00,1.95,206.70,'2023-01-09 18:03:11','',''),(572,'1','308','1',1,'Retail Sale Id 617',9648.10,0.00,0.00,12.53,1328.18,'2023-01-09 18:10:29','',''),(573,'1','308','1',1,'Retail Sale Id 618',800.80,0.00,0.00,1.04,110.24,'2023-01-09 18:16:51','',''),(574,'1','308','1',1,'Retail Sale Id 620',2502.50,0.00,0.00,3.25,344.50,'2023-01-09 18:19:39','',''),(575,'1','308','1',1,'Retail Sale Id 621',1540.00,0.00,0.00,2.00,212.00,'2023-01-09 18:20:36','',''),(576,'1','308','1',1,'Retail Sale Id 622',1501.50,0.00,0.00,1.95,206.70,'2023-01-09 18:28:18','',''),(577,'1','308','1',1,'Retail Sale Id 623',69.30,0.00,0.00,0.09,9.54,'2023-01-09 18:47:11','',''),(578,'1','308','1',1,'Retail Sale Id 624',6930.00,0.00,0.00,9.00,954.00,'2023-01-10 07:27:18','',''),(579,'1','308','1',1,'Retail Sale Id 625',1501.50,0.00,0.00,1.95,206.70,'2023-01-10 07:31:53','',''),(580,'1','308','1',1,'Retail Sale Id 626',2310.00,0.00,0.00,3.00,318.00,'2023-01-10 08:13:36','',''),(581,'1','308','1',1,'Retail Sale Id 627',11519.20,0.00,0.00,14.96,1585.76,'2023-01-10 08:22:51','',''),(582,'1','308','1',1,'Retail Sale Id 628',3850.00,0.00,0.00,5.00,530.00,'2023-01-10 08:41:35','',''),(583,'1','308','1',1,'Retail Sale Id 629',3850.00,0.00,0.00,5.00,530.00,'2023-01-10 08:43:04','',''),(584,'1','308','1',1,'Retail Sale Id 630',800.80,0.00,0.00,1.04,110.24,'2023-01-10 08:59:23','',''),(585,'1','308','1',1,'Retail Sale Id 631',31950.00,0.00,0.00,45.00,2070.00,'2023-01-10 09:05:13','',''),(586,'1','308','1',1,'Retail Sale Id 632',2310.00,0.00,0.00,3.00,318.00,'2023-01-10 10:49:07','',''),(587,'1','308','1',1,'Retail Sale Id 633',3850.00,0.00,0.00,5.00,530.00,'2023-01-10 11:17:31','',''),(588,'1','308','1',1,'Retail Sale Id 634',9625.00,0.00,0.00,12.50,1325.00,'2023-01-10 12:28:18','',''),(589,'1','308','1',1,'Retail Sale Id 635',4620.00,0.00,0.00,6.00,636.00,'2023-01-10 12:31:12','',''),(590,'1','308','1',1,'Retail Sale Id 636',4620.00,0.00,0.00,6.00,636.00,'2023-01-10 12:33:34','',''),(591,'1','308','1',1,'Retail Sale Id 637',3080.00,0.00,0.00,4.00,424.00,'2023-01-10 13:20:18','',''),(592,'1','308','1',1,'Retail Sale Id 638',4620.00,0.00,0.00,6.00,636.00,'2023-01-10 13:23:14','',''),(593,'1','308','1',1,'Retail Sale Id 639',770.00,0.00,0.00,1.00,106.00,'2023-01-10 13:36:32','',''),(594,'1','308','1',1,'Retail Sale Id 640',1540.00,0.00,0.00,2.00,212.00,'2023-01-10 15:37:37','',''),(595,'1','308','1',1,'Retail Sale Id 641',1540.00,0.00,0.00,2.00,212.00,'2023-01-10 15:51:50','',''),(596,'1','308','1',1,'Retail Sale Id 642',1540.00,0.00,0.00,2.00,212.00,'2023-01-10 16:14:15','',''),(597,'1','308','1',1,'Retail Sale Id 643',3080.00,0.00,0.00,4.00,424.00,'2023-01-10 16:30:25','',''),(598,'1','308','1',1,'Retail Sale Id 644',44375.00,0.00,0.00,62.50,2875.00,'2023-01-10 16:37:37','',''),(599,'1','308','1',1,'Retail Sale Id 646',6930.00,0.00,0.00,9.00,954.00,'2023-01-10 16:47:38','',''),(600,'1','308','1',1,'Retail Sale Id 647',3003.00,0.00,0.00,3.90,413.40,'2023-01-10 17:10:57','',''),(601,'1','308','1',1,'Retail Sale Id 648',4650.80,0.00,0.00,6.04,640.24,'2023-01-10 17:31:30','',''),(602,'1','308','1',1,'Retail Sale Id 649',7700.00,0.00,0.00,10.00,1060.00,'2023-01-10 17:33:41','',''),(603,'1','308','1',1,'Retail Sale Id 650',4620.00,0.00,0.00,6.00,636.00,'2023-01-10 17:37:26','',''),(604,'1','308','1',1,'Retail Sale Id 653',1547.70,0.00,0.00,2.01,213.06,'2023-01-10 17:48:36','',''),(605,'1','308','1',1,'Retail Sale Id 654',4620.00,0.00,0.00,6.00,636.00,'2023-01-10 17:53:49','',''),(606,'1','308','1',1,'Retail Sale Id 655',500.50,0.00,0.00,0.65,68.90,'2023-01-10 17:59:16','',''),(607,'1','308','1',1,'Retail Sale Id 656',770.00,0.00,0.00,1.00,106.00,'2023-01-10 18:19:45','',''),(608,'1','308','1',1,'Retail Sale Id 657',800.80,0.00,0.00,1.04,110.24,'2023-01-10 18:22:01','',''),(609,'1','308','1',1,'Retail Sale Id 658',800.80,0.00,0.00,1.04,110.24,'2023-01-10 18:24:21','',''),(610,'1','308','1',1,'Retail Sale Id 659',800.80,0.00,0.00,1.04,110.24,'2023-01-10 18:32:13','',''),(611,'1','308','1',1,'Retail Sale Id 660',2310.00,0.00,0.00,3.00,318.00,'2023-01-10 18:34:53','',''),(612,'1','308','1',1,'Retail Sale Id 661',77.00,0.00,0.00,0.10,10.60,'2023-01-10 19:38:56','',''),(613,'1','308','1',1,'Retail Sale Id 662',3103.10,0.00,0.00,4.03,427.18,'2023-01-11 07:23:14','',''),(614,'1','308','1',1,'Retail Sale Id 663',1570.80,0.00,0.00,2.04,216.24,'2023-01-11 07:26:42','',''),(615,'1','308','1',1,'Retail Sale Id 664',2310.00,0.00,0.00,3.00,318.00,'2023-01-11 07:31:10','',''),(616,'1','308','1',1,'Retail Sale Id 665',1547.70,0.00,0.00,2.01,213.06,'2023-01-11 07:53:47','',''),(617,'1','308','1',1,'Retail Sale Id 666',5397.70,0.00,0.00,7.01,743.06,'2023-01-11 07:55:18','',''),(618,'1','308','1',1,'Retail Sale Id 667',9648.10,0.00,0.00,12.53,1328.18,'2023-01-11 08:36:02','',''),(619,'1','308','1',1,'Retail Sale Id 668',2310.00,0.00,0.00,3.00,318.00,'2023-01-11 08:44:49','',''),(620,'1','308','1',1,'Retail Sale Id 669',1547.70,0.00,0.00,2.01,213.06,'2023-01-11 08:54:07','',''),(621,'1','308','1',1,'Retail Sale Id 670',9648.10,0.00,0.00,12.53,1328.18,'2023-01-11 08:55:18','',''),(622,'1','308','1',1,'Retail Sale Id 671',1540.00,0.00,0.00,2.00,212.00,'2023-01-11 09:11:24','',''),(623,'1','308','1',1,'Retail Sale Id 673',142000.00,0.00,0.00,200.00,9200.00,'2023-01-11 09:52:56','',''),(624,'1','308','1',1,'Retail Sale Id 674',10650.00,0.00,0.00,15.00,690.00,'2023-01-11 10:04:39','',''),(625,'1','308','1',1,'Retail Sale Id 675',3040.00,0.00,0.00,4.00,384.00,'2023-01-11 10:19:38','',''),(626,'1','308','1',1,'Retail Sale Id 676',7600.00,0.00,0.00,10.00,960.00,'2023-01-11 10:36:15','',''),(627,'1','308','1',1,'Retail Sale Id 677',1520.00,0.00,0.00,2.00,192.00,'2023-01-11 10:37:26','',''),(628,'1','308','1',1,'Retail Sale Id 678',1520.00,0.00,0.00,2.00,192.00,'2023-01-11 11:07:01','',''),(629,'1','308','1',1,'Retail Sale Id 679',760.00,0.00,0.00,1.00,96.00,'2023-01-11 11:19:28','',''),(630,'1','308','1',1,'Retail Sale Id 680',1900.00,0.00,0.00,2.50,240.00,'2023-01-11 11:22:46','',''),(631,'1','308','1',1,'Retail Sale Id 681',3800.00,0.00,0.00,5.00,480.00,'2023-01-11 11:40:22','',''),(632,'1','308','1',1,'Retail Sale Id 682',760.00,0.00,0.00,1.00,96.00,'2023-01-11 11:55:40','',''),(633,'1','308','1',1,'Retail Sale Id 683',9120.00,0.00,0.00,12.00,1152.00,'2023-01-11 12:38:57','',''),(634,'1','308','1',1,'Retail Sale Id 684',1003.20,0.00,0.00,1.32,126.72,'2023-01-11 12:53:03','',''),(635,'1','308','1',1,'Retail Sale Id 685',1003.20,0.00,0.00,1.32,126.72,'2023-01-11 12:53:44','',''),(636,'1','308','1',1,'Retail Sale Id 686',4560.00,0.00,0.00,6.00,576.00,'2023-01-11 14:35:03','',''),(637,'1','308','1',1,'Retail Sale Id 687',9500.00,0.00,0.00,12.50,1200.00,'2023-01-11 14:50:11','',''),(638,'1','308','1',1,'Retail Sale Id 688',2280.00,0.00,0.00,3.00,288.00,'2023-01-11 14:57:32','',''),(639,'1','308','1',1,'Retail Sale Id 689',1147.60,0.00,0.00,1.51,144.96,'2023-01-11 15:14:14','',''),(640,'1','308','1',1,'Retail Sale Id 690',3040.00,0.00,0.00,4.00,384.00,'2023-01-11 15:26:44','',''),(641,'1','308','1',1,'Retail Sale Id 691',3040.00,0.00,0.00,4.00,384.00,'2023-01-11 15:48:44','',''),(642,'1','308','1',1,'Retail Sale Id 692',2280.00,0.00,0.00,3.00,288.00,'2023-01-11 16:13:41','',''),(643,'1','308','1',1,'Retail Sale Id 693',3800.00,0.00,0.00,5.00,480.00,'2023-01-11 16:14:37','',''),(644,'1','308','1',1,'Retail Sale Id 694',4499.20,0.00,0.00,5.92,568.32,'2023-01-11 16:20:54','',''),(645,'1','308','1',1,'Retail Sale Id 695',798.00,0.00,0.00,1.05,100.80,'2023-01-11 16:22:11','',''),(646,'1','308','1',1,'Retail Sale Id 696',1520.00,0.00,0.00,2.00,192.00,'2023-01-11 16:23:33','',''),(647,'1','308','1',1,'Retail Sale Id 697',2280.00,0.00,0.00,3.00,288.00,'2023-01-11 16:48:57','',''),(648,'1','308','1',1,'Retail Sale Id 698',760.00,0.00,0.00,1.00,96.00,'2023-01-11 16:53:20','',''),(649,'1','308','1',1,'Retail Sale Id 699',2280.00,0.00,0.00,3.00,288.00,'2023-01-11 17:04:11','',''),(650,'1','308','1',1,'Retail Sale Id 700',3800.00,0.00,0.00,5.00,480.00,'2023-01-11 17:22:59','',''),(651,'1','308','1',1,'Retail Sale Id 701',2280.00,0.00,0.00,3.00,288.00,'2023-01-11 17:28:20','',''),(652,'1','308','1',1,'Retail Sale Id 702',760.00,0.00,0.00,1.00,96.00,'2023-01-11 17:29:36','',''),(653,'1','308','1',1,'Retail Sale Id 703',31950.00,0.00,0.00,45.00,2070.00,'2023-01-11 17:31:38','',''),(654,'1','308','1',1,'Retail Sale Id 704',1520.00,0.00,0.00,2.00,192.00,'2023-01-11 17:34:23','',''),(655,'1','308','1',1,'Retail Sale Id 705',760.00,0.00,0.00,1.00,96.00,'2023-01-11 17:43:43','',''),(656,'1','308','1',1,'Retail Sale Id 706',760.00,0.00,0.00,1.00,96.00,'2023-01-11 17:44:42','',''),(657,'1','308','1',1,'Retail Sale Id 707',4560.00,0.00,0.00,6.00,576.00,'2023-01-11 17:55:15','',''),(658,'1','308','1',1,'Retail Sale Id 708',3800.00,0.00,0.00,5.00,480.00,'2023-01-11 18:14:55','',''),(659,'1','308','1',1,'Retail Sale Id 709',1003.20,0.00,0.00,1.32,126.72,'2023-01-11 18:17:56','',''),(660,'1','308','1',1,'Retail Sale Id 711',9120.00,0.00,0.00,12.00,1152.00,'2023-01-11 18:21:12','',''),(661,'1','308','1',1,'Retail Sale Id 712',4560.00,0.00,0.00,6.00,576.00,'2023-01-11 18:23:30','',''),(662,'1','308','1',1,'Retail Sale Id 713',7.60,0.00,0.00,0.01,0.96,'2023-01-11 19:06:19','',''),(663,'1','308','1',1,'Retail Sale Id 714',1540.00,0.00,0.00,2.00,212.00,'2023-01-12 07:20:00','',''),(664,'1','308','1',1,'Retail Sale Id 715',896.80,0.00,0.00,1.18,113.28,'2023-01-12 07:22:59','',''),(665,'1','308','1',1,'Retail Sale Id 716',3800.00,0.00,0.00,5.00,480.00,'2023-01-12 07:34:28','',''),(666,'1','308','1',1,'Retail Sale Id 717',9500.00,0.00,0.00,12.50,1200.00,'2023-01-12 07:43:41','',''),(667,'1','308','1',1,'Retail Sale Id 718',9500.00,0.00,0.00,12.50,1200.00,'2023-01-12 07:48:54','',''),(668,'1','308','1',1,'Retail Sale Id 719',760.00,0.00,0.00,1.00,96.00,'2023-01-12 07:56:35','',''),(669,'1','308','1',1,'Retail Sale Id 720',42600.00,0.00,0.00,60.00,2760.00,'2023-01-12 08:10:12','',''),(670,'1','308','1',1,'Retail Sale Id 721',3800.00,0.00,0.00,5.00,480.00,'2023-01-12 08:11:31','',''),(671,'1','308','1',1,'Retail Sale Id 722',17395.00,0.00,0.00,24.50,1127.00,'2023-01-12 08:18:35','',''),(672,'1','308','1',1,'Retail Sale Id 723',2280.00,0.00,0.00,3.00,288.00,'2023-01-12 08:33:06','',''),(673,'1','308','1',1,'Retail Sale Id 724',5320.00,0.00,0.00,7.00,672.00,'2023-01-12 09:01:02','',''),(674,'1','308','1',1,'Retail Sale Id 725',4560.00,0.00,0.00,6.00,576.00,'2023-01-12 09:24:52','',''),(675,'1','308','1',1,'Retail Sale Id 726',3040.00,0.00,0.00,4.00,384.00,'2023-01-12 09:53:07','',''),(676,'1','308','1',1,'Retail Sale Id 727',1520.00,0.00,0.00,2.00,192.00,'2023-01-12 09:59:49','',''),(677,'1','308','1',1,'Retail Sale Id 728',3800.00,0.00,0.00,5.00,480.00,'2023-01-12 10:26:35','',''),(678,'1','308','1',1,'Retail Sale Id 729',9500.00,0.00,0.00,12.50,1200.00,'2023-01-12 10:29:17','',''),(679,'1','308','1',1,'Retail Sale Id 730',3800.00,0.00,0.00,5.00,480.00,'2023-01-12 10:31:03','',''),(680,'1','308','1',1,'Retail Sale Id 731',1520.00,0.00,0.00,2.00,192.00,'2023-01-12 10:36:48','',''),(681,'1','308','1',1,'Retail Sale Id 732',4560.00,0.00,0.00,6.00,576.00,'2023-01-12 10:59:29','',''),(682,'1','308','1',1,'Retail Sale Id 733',1520.00,0.00,0.00,2.00,192.00,'2023-01-12 11:18:32','',''),(683,'1','308','1',1,'Retail Sale Id 734',760.00,0.00,0.00,1.00,96.00,'2023-01-12 11:24:11','',''),(684,'1','308','1',1,'Retail Sale Id 735',1520.00,0.00,0.00,2.00,192.00,'2023-01-12 11:38:26','',''),(685,'1','308','1',1,'Retail Sale Id 736',3800.00,0.00,0.00,5.00,480.00,'2023-01-12 12:26:51','',''),(686,'1','308','1',1,'Retail Sale Id 737',4560.00,0.00,0.00,6.00,576.00,'2023-01-12 12:34:47','',''),(687,'1','308','1',1,'Retail Sale Id 738',4560.00,0.00,0.00,6.00,576.00,'2023-01-12 12:42:18','',''),(688,'1','308','1',1,'Retail Sale Id 739',4560.00,0.00,0.00,6.00,576.00,'2023-01-12 12:54:40','',''),(689,'1','308','1',1,'Retail Sale Id 740',3800.00,0.00,0.00,5.00,480.00,'2023-01-12 13:03:39','',''),(690,'1','308','1',1,'Retail Sale Id 741',1520.00,0.00,0.00,2.00,192.00,'2023-01-12 14:01:41','',''),(691,'1','308','1',1,'Retail Sale Id 742',3040.00,0.00,0.00,4.00,384.00,'2023-01-12 14:02:56','',''),(692,'1','308','1',1,'Retail Sale Id 743',2280.00,0.00,0.00,3.00,288.00,'2023-01-12 14:20:17','',''),(693,'1','308','1',1,'Retail Sale Id 744',9120.00,0.00,0.00,12.00,1152.00,'2023-01-12 14:26:37','',''),(694,'1','308','1',1,'Retail Sale Id 745',3040.00,0.00,0.00,4.00,384.00,'2023-01-12 14:48:48','',''),(695,'1','308','1',1,'Retail Sale Id 746',2280.00,0.00,0.00,3.00,288.00,'2023-01-12 14:49:47','',''),(696,'1','308','1',1,'Retail Sale Id 747',798.00,0.00,0.00,1.05,100.80,'2023-01-12 14:53:51','',''),(697,'1','308','1',1,'Retail Sale Id 749',1520.00,0.00,0.00,2.00,192.00,'2023-01-12 14:56:41','',''),(698,'1','308','1',1,'Retail Sale Id 753',1520.00,0.00,0.00,2.00,192.00,'2023-01-12 15:14:28','',''),(699,'1','308','1',1,'Retail Sale Id 754',3800.00,0.00,0.00,5.00,480.00,'2023-01-12 15:15:16','',''),(700,'1','308','1',1,'Retail Sale Id 755',5320.00,0.00,0.00,7.00,672.00,'2023-01-12 15:16:48','',''),(701,'1','308','1',1,'Retail Sale Id 756',35500.00,0.00,0.00,50.00,2300.00,'2023-01-12 15:18:44','',''),(702,'1','308','1',1,'Retail Sale Id 757',2280.00,0.00,0.00,3.00,288.00,'2023-01-12 15:25:31','',''),(703,'1','308','1',1,'Retail Sale Id 758',7600.00,0.00,0.00,10.00,960.00,'2023-01-12 15:27:56','',''),(704,'1','308','1',1,'Retail Sale Id 759',1003.20,0.00,0.00,1.32,126.72,'2023-01-12 15:44:23','',''),(705,'1','308','1',1,'Retail Sale Id 760',1520.00,0.00,0.00,2.00,192.00,'2023-01-12 15:51:17','',''),(706,'1','308','1',1,'Retail Sale Id 761',4560.00,0.00,0.00,6.00,576.00,'2023-01-12 15:56:01','',''),(707,'1','308','1',1,'Retail Sale Id 762',4560.00,0.00,0.00,6.00,576.00,'2023-01-12 16:09:36','',''),(708,'1','308','1',1,'Retail Sale Id 763',1520.00,0.00,0.00,2.00,192.00,'2023-01-12 16:12:50','',''),(709,'1','308','1',1,'Retail Sale Id 764',1520.00,0.00,0.00,2.00,192.00,'2023-01-12 16:19:12','',''),(710,'1','308','1',1,'Retail Sale Id 765',3800.00,0.00,0.00,5.00,480.00,'2023-01-12 16:23:06','',''),(711,'1','308','1',1,'Retail Sale Id 766',3002.00,0.00,0.00,3.95,379.20,'2023-01-12 16:37:43','',''),(712,'1','308','1',1,'Retail Sale Id 767',1520.00,0.00,0.00,2.00,192.00,'2023-01-12 16:40:59','',''),(713,'1','308','1',1,'Retail Sale Id 768',1520.00,0.00,0.00,2.00,192.00,'2023-01-12 16:43:44','',''),(714,'1','308','1',1,'Retail Sale Id 769',9120.00,0.00,0.00,12.00,1152.00,'2023-01-12 16:46:52','',''),(715,'1','308','1',1,'Retail Sale Id 770',4560.00,0.00,0.00,6.00,576.00,'2023-01-12 16:49:07','',''),(716,'1','308','1',1,'Retail Sale Id 771',3002.00,0.00,0.00,3.95,379.20,'2023-01-12 17:00:11','',''),(717,'1','308','1',1,'Retail Sale Id 772',2280.00,0.00,0.00,3.00,288.00,'2023-01-12 17:03:52','',''),(718,'1','308','1',1,'Retail Sale Id 773',3040.00,0.00,0.00,4.00,384.00,'2023-01-12 17:05:53','',''),(719,'1','308','1',1,'Retail Sale Id 774',5000.80,0.00,0.00,6.58,631.68,'2023-01-12 17:30:47','',''),(720,'1','308','1',1,'Return of Retail Sale Id 771',0.00,3002.00,3.95,0.00,-379.20,'2023-01-12 18:00:56','',''),(721,'1','308','1',1,'Retail Sale Id 775',3040.00,0.00,0.00,4.00,384.00,'2023-01-12 18:09:40','',''),(722,'1','308','1',1,'Retail Sale Id 776',2280.00,0.00,0.00,3.00,288.00,'2023-01-12 18:35:18','',''),(723,'1','308','1',1,'Return of Retail Sale Id 722',0.00,17395.00,24.50,0.00,-1127.00,'2023-01-12 20:00:41','',''),(724,'1','308','1',1,'Retail Sale Id 777',17409.20,0.00,0.00,24.52,1127.92,'2023-01-12 20:03:18','',''),(725,'1','308','1',1,'Retail Sale Id 778',4902.00,0.00,0.00,6.45,619.20,'2023-01-13 07:48:56','',''),(726,'1','308','1',1,'Retail Sale Id 779',2302.80,0.00,0.00,3.03,290.88,'2023-01-13 07:49:55','',''),(727,'1','308','1',1,'Retail Sale Id 781',2302.80,0.00,0.00,3.03,290.88,'2023-01-13 08:01:12','',''),(728,'1','308','1',1,'Retail Sale Id 782',9120.00,0.00,0.00,12.00,1152.00,'2023-01-13 08:16:31','',''),(729,'1','308','1',1,'Retail Sale Id 780',2280.00,0.00,0.00,3.00,288.00,'2023-01-13 08:16:56','',''),(730,'1','308','1',1,'Retail Sale Id 784',1497.20,0.00,0.00,1.97,189.12,'2023-01-13 08:43:59','',''),(731,'1','308','1',1,'Retail Sale Id 785',760.00,0.00,0.00,1.00,96.00,'2023-01-13 08:47:01','',''),(732,'1','308','1',1,'Retail Sale Id 786',4560.00,0.00,0.00,6.00,576.00,'2023-01-13 08:52:47','',''),(733,'1','308','1',1,'Retail Sale Id 788',1527.60,0.00,0.00,2.01,192.96,'2023-01-13 09:03:37','',''),(734,'1','308','1',1,'Retail Sale Id 789',3047.60,0.00,0.00,4.01,384.96,'2023-01-13 09:09:54','',''),(735,'1','308','1',1,'Retail Sale Id 790',1497.20,0.00,0.00,1.97,189.12,'2023-01-13 09:13:40','',''),(736,'1','308','1',1,'Retail Sale Id 791',3800.00,0.00,0.00,5.00,480.00,'2023-01-13 10:40:17','',''),(737,'1','308','1',1,'Retail Sale Id 792',1497.20,0.00,0.00,1.97,189.12,'2023-01-13 10:46:28','',''),(738,'1','308','1',1,'Retail Sale Id 793',3800.00,0.00,0.00,5.00,480.00,'2023-01-13 10:54:17','',''),(739,'1','308','1',1,'Retail Sale Id 794',2302.80,0.00,0.00,3.03,290.88,'2023-01-13 11:00:25','',''),(740,'1','308','1',1,'Retail Sale Id 795',2302.80,0.00,0.00,3.03,290.88,'2023-01-13 11:53:20','',''),(741,'1','308','1',1,'Retail Sale Id 796',4560.00,0.00,0.00,6.00,576.00,'2023-01-13 12:00:25','',''),(742,'1','308','1',1,'Retail Sale Id 798',4552.40,0.00,0.00,5.99,575.04,'2023-01-13 12:21:29','',''),(743,'1','308','1',1,'Retail Sale Id 799',760.00,0.00,0.00,1.00,96.00,'2023-01-13 12:25:02','',''),(744,'1','308','1',1,'Retail Sale Id 800',2302.80,0.00,0.00,3.03,290.88,'2023-01-13 12:52:00','',''),(745,'1','308','1',1,'Retail Sale Id 801',3002.00,0.00,0.00,3.95,379.20,'2023-01-13 12:53:05','',''),(746,'1','308','1',1,'Retail Sale Id 802',1497.20,0.00,0.00,1.97,189.12,'2023-01-13 13:13:01','',''),(747,'1','308','1',1,'Retail Sale Id 803',798.00,0.00,0.00,1.05,100.80,'2023-01-13 13:39:46','',''),(748,'1','308','1',1,'Retail Sale Id 804',7600.00,0.00,0.00,10.00,960.00,'2023-01-13 13:41:21','',''),(749,'1','308','1',1,'Retail Sale Id 805',1497.20,0.00,0.00,1.97,189.12,'2023-01-13 14:43:04','',''),(750,'1','308','1',1,'Retail Sale Id 806',798.00,0.00,0.00,1.05,100.80,'2023-01-13 14:50:14','',''),(751,'1','308','1',1,'Retail Sale Id 807',29110.00,0.00,0.00,41.00,1886.00,'2023-01-13 15:05:19','',''),(752,'1','308','1',1,'Retail Sale Id 808',1497.20,0.00,0.00,1.97,189.12,'2023-01-13 15:06:23','',''),(753,'1','308','1',1,'Retail Sale Id 809',4560.00,0.00,0.00,6.00,576.00,'2023-01-13 15:08:51','',''),(754,'1','308','1',1,'Retail Sale Id 810',2280.00,0.00,0.00,3.00,288.00,'2023-01-13 15:41:22','',''),(755,'1','308','1',1,'Retail Sale Id 811',1998.80,0.00,0.00,2.63,252.48,'2023-01-13 16:22:00','',''),(756,'1','308','1',1,'Retail Sale Id 812',2302.80,0.00,0.00,3.03,290.88,'2023-01-13 16:35:47','',''),(757,'1','308','1',1,'Retail Sale Id 813',798.00,0.00,0.00,1.05,100.80,'2023-01-13 16:37:19','',''),(758,'1','308','1',1,'Retail Sale Id 814',760.00,0.00,0.00,1.00,96.00,'2023-01-13 16:39:35','',''),(759,'1','308','1',1,'Retail Sale Id 815',1550.40,0.00,0.00,2.04,195.84,'2023-01-13 17:25:09','',''),(760,'1','308','1',1,'Retail Sale Id 816',31240.00,0.00,0.00,44.00,2024.00,'2023-01-13 17:28:50','',''),(761,'1','308','1',1,'Retail Sale Id 817',760.00,0.00,0.00,1.00,96.00,'2023-01-13 17:58:20','',''),(762,'1','308','1',1,'Retail Sale Id 818',1520.00,0.00,0.00,2.00,192.00,'2023-01-13 17:59:51','',''),(763,'1','308','1',1,'Retail Sale Id 819',2302.80,0.00,0.00,3.03,290.88,'2023-01-13 18:01:59','',''),(764,'1','308','1',1,'Retail Sale Id 820',4552.40,0.00,0.00,5.99,575.04,'2023-01-13 18:05:27','',''),(765,'1','308','1',1,'Retail Sale Id 821',1550.40,0.00,0.00,2.04,195.84,'2023-01-13 18:13:34','',''),(766,'1','308','1',1,'Retail Sale Id 822',4552.40,0.00,0.00,5.99,575.04,'2023-01-13 18:16:41','',''),(767,'1','308','1',1,'Retail Sale Id 823',501.60,0.00,0.00,0.66,63.36,'2023-01-13 18:17:33','',''),(768,'1','308','1',1,'Retail Sale Id 824',3002.00,0.00,0.00,3.95,379.20,'2023-01-13 18:26:45','',''),(769,'1','308','1',1,'Retail Sale Id 825',418.00,0.00,0.00,0.55,52.80,'2023-01-13 18:39:57','',''),(770,'1','308','1',1,'Retail Sale Id 826',9500.00,0.00,0.00,12.50,1200.00,'2023-01-14 07:13:34','',''),(771,'1','308','1',1,'Retail Sale Id 827',2280.00,0.00,0.00,3.00,288.00,'2023-01-14 07:14:31','',''),(772,'1','308','1',1,'Retail Sale Id 828',20147.60,0.00,0.00,26.51,2544.96,'2023-01-14 07:15:31','',''),(773,'1','308','1',1,'Retail Sale Id 829',4560.00,0.00,0.00,6.00,576.00,'2023-01-14 07:21:33','',''),(774,'1','308','1',1,'Retail Sale Id 830',798.00,0.00,0.00,1.05,100.80,'2023-01-14 07:28:37','',''),(775,'1','308','1',1,'Retail Sale Id 833',798.00,0.00,0.00,1.05,100.80,'2023-01-14 07:59:25','',''),(776,'1','308','1',1,'Retail Sale Id 834',3800.00,0.00,0.00,5.00,480.00,'2023-01-14 08:01:24','',''),(777,'1','308','1',1,'Retail Sale Id 835',3800.00,0.00,0.00,5.00,480.00,'2023-01-14 08:10:51','',''),(778,'1','308','1',1,'Retail Sale Id 836',1520.00,0.00,0.00,2.00,192.00,'2023-01-14 08:15:57','',''),(779,'1','308','1',1,'Retail Sale Id 837',4560.00,0.00,0.00,6.00,576.00,'2023-01-14 08:18:04','',''),(780,'1','308','1',1,'Retail Sale Id 838',7600.00,0.00,0.00,10.00,960.00,'2023-01-14 08:46:57','',''),(781,'1','308','1',1,'Retail Sale Id 839',3800.00,0.00,0.00,5.00,480.00,'2023-01-14 08:48:15','',''),(782,'1','308','1',1,'Retail Sale Id 840',9120.00,0.00,0.00,12.00,1152.00,'2023-01-14 08:49:36','',''),(783,'1','308','1',1,'Retail Sale Id 841',7600.00,0.00,0.00,10.00,960.00,'2023-01-14 08:54:46','',''),(784,'1','308','1',1,'Retail Sale Id 842',1520.00,0.00,0.00,2.00,192.00,'2023-01-14 09:04:13','',''),(785,'1','308','1',1,'Retail Sale Id 843',2280.00,0.00,0.00,3.00,288.00,'2023-01-14 09:20:54','',''),(786,'1','308','1',1,'Retail Sale Id 844',1520.00,0.00,0.00,2.00,192.00,'2023-01-14 09:50:42','',''),(787,'1','308','1',1,'Retail Sale Id 845',1520.00,0.00,0.00,2.00,192.00,'2023-01-14 10:12:21','',''),(788,'1','308','1',1,'Retail Sale Id 846',1497.20,0.00,0.00,1.97,189.12,'2023-01-14 10:53:01','',''),(789,'1','308','1',1,'Retail Sale Id 847',8360.00,0.00,0.00,11.00,1056.00,'2023-01-14 11:08:46','',''),(790,'1','308','1',1,'Retail Sale Id 848',4499.20,0.00,0.00,5.92,568.32,'2023-01-14 11:11:36','',''),(791,'1','308','1',1,'Retail Sale Id 849',1520.00,0.00,0.00,2.00,192.00,'2023-01-14 11:13:16','',''),(792,'1','308','1',1,'Retail Sale Id 850',1497.20,0.00,0.00,1.97,189.12,'2023-01-14 12:07:50','',''),(793,'1','308','1',1,'Retail Sale Id 851',3040.00,0.00,0.00,4.00,384.00,'2023-01-14 12:53:39','',''),(794,'1','308','1',1,'Retail Sale Id 852',798.00,0.00,0.00,1.05,100.80,'2023-01-14 13:09:51','',''),(795,'1','308','1',1,'Retail Sale Id 853',2280.00,0.00,0.00,3.00,288.00,'2023-01-14 13:37:58','',''),(796,'1','308','1',1,'Retail Sale Id 856',3800.00,0.00,0.00,5.00,480.00,'2023-01-14 13:50:07','',''),(797,'1','308','1',1,'Retail Sale Id 857',29110.00,0.00,0.00,41.00,1886.00,'2023-01-14 13:58:06','',''),(798,'1','308','1',1,'Retail Sale Id 858',17750.00,0.00,0.00,25.00,1150.00,'2023-01-14 14:10:09','',''),(799,'1','308','1',1,'Retail Sale Id 859',1497.20,0.00,0.00,1.97,189.12,'2023-01-14 14:41:16','',''),(800,'1','308','1',1,'Retail Sale Id 860',798.00,0.00,0.00,1.05,100.80,'2023-01-14 15:00:02','',''),(801,'1','308','1',1,'Retail Sale Id 861',4560.00,0.00,0.00,6.00,576.00,'2023-01-14 15:47:54','',''),(802,'1','308','1',1,'Retail Sale Id 862',1520.00,0.00,0.00,2.00,192.00,'2023-01-14 15:51:45','',''),(803,'1','308','1',1,'Retail Sale Id 863',3040.00,0.00,0.00,4.00,384.00,'2023-01-14 16:07:58','',''),(804,'1','308','1',1,'Retail Sale Id 864',1520.00,0.00,0.00,2.00,192.00,'2023-01-14 16:09:46','',''),(805,'1','308','1',1,'Retail Sale Id 865',760.00,0.00,0.00,1.00,96.00,'2023-01-14 16:11:19','',''),(806,'1','308','1',1,'Retail Sale Id 866',3040.00,0.00,0.00,4.00,384.00,'2023-01-14 16:20:57','',''),(807,'1','308','1',1,'Retail Sale Id 867',9120.00,0.00,0.00,12.00,1152.00,'2023-01-14 16:26:29','',''),(808,'1','308','1',1,'Retail Sale Id 868',1520.00,0.00,0.00,2.00,192.00,'2023-01-14 16:28:28','',''),(809,'1','308','1',1,'Retail Sale Id 869',2280.00,0.00,0.00,3.00,288.00,'2023-01-14 17:25:12','',''),(810,'1','308','1',1,'Retail Sale Id 870',2280.00,0.00,0.00,3.00,288.00,'2023-01-14 17:42:12','',''),(811,'1','308','1',1,'Retail Sale Id 871',26625.00,0.00,0.00,37.50,1725.00,'2023-01-14 17:43:52','',''),(812,'1','308','1',1,'Retail Sale Id 873',760.00,0.00,0.00,1.00,96.00,'2023-01-14 17:47:41','',''),(813,'1','308','1',1,'Retail Sale Id 874',9500.00,0.00,0.00,12.50,1200.00,'2023-01-14 17:57:29','',''),(814,'1','308','1',1,'Retail Sale Id 875',760.00,0.00,0.00,1.00,96.00,'2023-01-14 17:58:54','',''),(815,'1','308','1',1,'Retail Sale Id 876',9500.00,0.00,0.00,12.50,1200.00,'2023-01-14 18:10:04','',''),(816,'1','308','1',1,'Retail Sale Id 877',2401.60,0.00,0.00,3.16,303.36,'2023-01-14 18:13:14','',''),(817,'1','308','1',1,'Retail Sale Id 878',7622.80,0.00,0.00,10.03,962.88,'2023-01-14 19:03:59','',''),(818,'1','308','1',1,'Retail Sale Id 879',2302.80,0.00,0.00,3.03,290.88,'2023-01-15 07:45:50','',''),(819,'1','308','1',1,'Retail Sale Id 880',12160.00,0.00,0.00,16.00,1536.00,'2023-01-15 07:49:57','',''),(820,'1','308','1',1,'Retail Sale Id 881',3047.60,0.00,0.00,4.01,384.96,'2023-01-15 08:02:02','',''),(821,'1','308','1',1,'Retail Sale Id 882',3800.00,0.00,0.00,5.00,480.00,'2023-01-15 08:08:59','',''),(822,'1','308','1',1,'Retail Sale Id 883',1520.00,0.00,0.00,2.00,192.00,'2023-01-15 08:15:10','',''),(823,'1','308','1',1,'Retail Sale Id 884',3047.60,0.00,0.00,4.01,384.96,'2023-01-15 08:18:34','',''),(824,'1','308','1',1,'Retail Sale Id 885',2302.80,0.00,0.00,3.03,290.88,'2023-01-15 08:19:52','',''),(825,'1','308','1',1,'Retail Sale Id 886',3800.00,0.00,0.00,5.00,480.00,'2023-01-15 08:22:53','',''),(826,'1','308','1',1,'Retail Sale Id 887',4560.00,0.00,0.00,6.00,576.00,'2023-01-15 08:43:42','',''),(827,'1','308','1',1,'Retail Sale Id 888',4560.00,0.00,0.00,6.00,576.00,'2023-01-15 09:01:16','',''),(828,'1','308','1',1,'Retail Sale Id 889',2280.00,0.00,0.00,3.00,288.00,'2023-01-15 09:17:10','',''),(829,'1','308','1',1,'Retail Sale Id 890',2302.80,0.00,0.00,3.03,290.88,'2023-01-15 09:53:40','',''),(830,'1','308','1',1,'Retail Sale Id 891',3047.60,0.00,0.00,4.01,384.96,'2023-01-15 09:55:10','',''),(831,'1','308','1',1,'Retail Sale Id 892',1200.80,0.00,0.00,1.58,151.68,'2023-01-15 10:08:16','',''),(832,'1','308','1',1,'Retail Sale Id 893',22286.90,0.00,0.00,31.39,1443.94,'2023-01-15 11:13:06','',''),(833,'1','308','1',1,'Distributed to OPERATIONAL LOSS for sales id:1',52044.32,0.00,0.00,78.38,0.00,'2023-01-15 13:21:55','',''),(834,'1','308',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,664000.00,1000.00,0.00,0.00,'2023-01-15 13:46:26','',''),(835,'1','308',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,1000.00,0.00,'2023-01-15 14:02:13','',''),(836,'1','308','1',1,'Received from bridging 2',0.00,0.00,1000.00,0.00,0.00,'2023-01-15 14:02:13','',''),(837,'1','308','1',1,'Retail Sale Id 894',1520.00,0.00,0.00,2.00,192.00,'2023-01-15 14:27:59','',''),(838,'1','308','1',1,'Retail Sale Id 895',2302.80,0.00,0.00,3.03,290.88,'2023-01-15 14:29:19','',''),(839,'1','308','1',1,'Retail Sale Id 896',1497.20,0.00,0.00,1.97,189.12,'2023-01-15 14:30:45','',''),(840,'1','308','1',1,'Retail Sale Id 897',798.00,0.00,0.00,1.05,100.80,'2023-01-15 14:31:38','',''),(841,'1','308','1',1,'Retail Sale Id 898',4560.00,0.00,0.00,6.00,576.00,'2023-01-15 14:34:33','',''),(842,'1','308','1',1,'Retail Sale Id 899',1497.20,0.00,0.00,1.97,189.12,'2023-01-15 14:36:10','',''),(843,'1','308','1',1,'Retail Sale Id 900',3800.00,0.00,0.00,5.00,480.00,'2023-01-15 14:38:55','',''),(844,'1','308','1',1,'Retail Sale Id 901',9500.00,0.00,0.00,12.50,1200.00,'2023-01-15 14:39:57','',''),(845,'1','308','1',1,'Retail Sale Id 902',2302.80,0.00,0.00,3.03,290.88,'2023-01-15 14:44:20','',''),(846,'1','308','1',1,'Retail Sale Id 903',2302.80,0.00,0.00,3.03,290.88,'2023-01-15 14:48:34','',''),(847,'1','308','1',1,'Retail Sale Id 904',30963.10,0.00,0.00,43.61,2006.06,'2023-01-15 14:52:10','',''),(848,'1','308','1',1,'Retail Sale Id 905',798.00,0.00,0.00,1.05,100.80,'2023-01-15 14:53:45','',''),(849,'1','308','1',1,'Retail Sale Id 906',798.00,0.00,0.00,1.05,100.80,'2023-01-15 14:56:30','',''),(850,'1','308','1',1,'Retail Sale Id 907',3800.00,0.00,0.00,5.00,480.00,'2023-01-15 15:00:46','',''),(851,'1','308','1',1,'Retail Sale Id 908',2280.00,0.00,0.00,3.00,288.00,'2023-01-15 15:17:23','',''),(852,'1','308','1',1,'Retail Sale Id 909',1497.20,0.00,0.00,1.97,189.12,'2023-01-15 15:52:02','',''),(853,'1','308','1',1,'Retail Sale Id 910',2280.00,0.00,0.00,3.00,288.00,'2023-01-15 15:53:12','',''),(854,'1','308','1',1,'Retail Sale Id 911',1998.80,0.00,0.00,2.63,252.48,'2023-01-15 15:56:05','',''),(855,'1','308','1',1,'Retail Sale Id 912',752.40,0.00,0.00,0.99,95.04,'2023-01-15 16:07:36','',''),(856,'1','308',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,2715760.00,4090.00,0.00,0.00,'2023-01-15 16:25:04','',''),(857,'1','308',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,4090.00,0.00,'2023-01-15 16:28:31','',''),(858,'1','308','1',1,'Received from bridging 3',0.00,0.00,4090.00,0.00,0.00,'2023-01-15 16:28:31','',''),(859,'1','308','1',1,'Retail Sale Id 913',2698.00,0.00,0.00,3.55,340.80,'2023-01-15 16:31:23','',''),(860,'1','308','1',1,'Retail Sale Id 914',4560.00,0.00,0.00,6.00,576.00,'2023-01-15 16:33:13','',''),(861,'1','308','1',1,'Retail Sale Id 915',2280.00,0.00,0.00,3.00,288.00,'2023-01-15 16:34:37','',''),(862,'1','308','1',1,'Retail Sale Id 916',3047.60,0.00,0.00,4.01,384.96,'2023-01-15 16:39:31','',''),(863,'1','308','1',1,'Retail Sale Id 917',4560.00,0.00,0.00,6.00,576.00,'2023-01-15 17:07:23','',''),(864,'1','308','1',1,'Retail Sale Id 918',798.00,0.00,0.00,1.05,100.80,'2023-01-15 17:24:19','',''),(865,'1','308','1',1,'Retail Sale Id 919',5000.80,0.00,0.00,6.58,631.68,'2023-01-15 17:28:18','',''),(866,'1','308','1',1,'Retail Sale Id 920',2302.80,0.00,0.00,3.03,290.88,'2023-01-15 17:29:31','',''),(867,'1','308','1',1,'Retail Sale Id 921',1520.00,0.00,0.00,2.00,192.00,'2023-01-15 17:32:22','',''),(868,'1','308','1',1,'Retail Sale Id 923',1520.00,0.00,0.00,2.00,192.00,'2023-01-15 17:34:38','',''),(869,'1','308','1',1,'Retail Sale Id 924',798.00,0.00,0.00,1.05,100.80,'2023-01-15 17:36:22','',''),(870,'1','308','1',1,'Retail Sale Id 925',4552.40,0.00,0.00,5.99,575.04,'2023-01-15 17:40:11','',''),(871,'1','308','1',1,'Retail Sale Id 926',760.00,0.00,0.00,1.00,96.00,'2023-01-15 17:41:27','',''),(872,'1','308','1',1,'Retail Sale Id 927',3047.60,0.00,0.00,4.01,384.96,'2023-01-15 18:03:23','',''),(873,'1','308','1',1,'Retail Sale Id 928',2302.80,0.00,0.00,3.03,290.88,'2023-01-15 18:29:15','',''),(874,'1','308','1',1,'Retail Sale Id 929',1998.80,0.00,0.00,2.63,252.48,'2023-01-15 18:30:16','',''),(875,'1','308','1',1,'Retail Sale Id 930',3800.00,0.00,0.00,5.00,480.00,'2023-01-15 18:31:13','',''),(876,'1','308','1',1,'Retail Sale Id 931',2280.00,0.00,0.00,3.00,288.00,'2023-01-15 18:33:03','',''),(877,'1','308','1',1,'Retail Sale Id 932',1550.40,0.00,0.00,2.04,195.84,'2023-01-15 18:36:51','',''),(878,'1','308','1',1,'Retail Sale Id 933',1520.00,0.00,0.00,2.00,192.00,'2023-01-16 07:45:54','',''),(879,'1','308','1',1,'Retail Sale Id 934',17750.00,0.00,0.00,25.00,1150.00,'2023-01-16 08:06:47','',''),(880,'1','308','1',1,'Retail Sale Id 935',1520.00,0.00,0.00,2.00,192.00,'2023-01-16 08:15:54','',''),(881,'1','308','1',1,'Retail Sale Id 936',31240.00,0.00,0.00,44.00,2024.00,'2023-01-16 08:32:39','',''),(882,'1','308','1',1,'Retail Sale Id 937',4560.00,0.00,0.00,6.00,576.00,'2023-01-16 08:34:28','',''),(883,'1','308','1',1,'Retail Sale Id 938',2280.00,0.00,0.00,3.00,288.00,'2023-01-16 08:38:00','',''),(884,'1','308','1',1,'Retail Sale Id 940',1497.20,0.00,0.00,1.97,189.12,'2023-01-16 08:45:47','',''),(885,'1','308','1',1,'Retail Sale Id 941',2280.00,0.00,0.00,3.00,288.00,'2023-01-16 08:48:02','',''),(886,'1','308','1',1,'Retail Sale Id 943',3047.60,0.00,0.00,4.01,384.96,'2023-01-16 08:51:52','',''),(887,'1','308','1',1,'Retail Sale Id 944',2302.80,0.00,0.00,3.03,290.88,'2023-01-16 08:55:19','',''),(888,'1','308','1',1,'Retail Sale Id 945',1603.60,0.00,0.00,2.11,202.56,'2023-01-16 09:07:49','',''),(889,'1','308','1',1,'Retail Sale Id 946',7600.00,0.00,0.00,10.00,960.00,'2023-01-16 09:18:43','',''),(890,'1','308','1',1,'Retail Sale Id 947',2302.80,0.00,0.00,3.03,290.88,'2023-01-16 09:24:45','',''),(891,'1','308','1',1,'Retail Sale Id 952',9500.00,0.00,0.00,12.50,1200.00,'2023-01-16 10:13:09','',''),(892,'1','308','1',1,'Retail Sale Id 953',1003.20,0.00,0.00,1.32,126.72,'2023-01-16 10:29:54','',''),(893,'1','308','1',1,'Retail Sale Id 954',4499.20,0.00,0.00,5.92,568.32,'2023-01-16 10:36:35','',''),(894,'1','308','1',1,'Retail Sale Id 956',2900.80,0.00,0.00,3.92,297.92,'2023-01-16 11:43:35','',''),(895,'1','308','1',1,'Retail Sale Id 957',2960.00,0.00,0.00,4.00,304.00,'2023-01-16 11:45:22','',''),(896,'1','308','1',1,'Retail Sale Id 958',22720.00,0.00,0.00,32.00,1472.00,'2023-01-16 11:53:34','',''),(897,'1','308','1',1,'Retail Sale Id 959',9250.00,0.00,0.00,12.50,950.00,'2023-01-16 12:05:58','',''),(898,'1','308','1',1,'Retail Sale Id 960',4499.20,0.00,0.00,6.08,462.08,'2023-01-16 12:10:50','',''),(899,'1','308','1',1,'Retail Sale Id 950',9500.00,0.00,0.00,12.50,1200.00,'2023-01-16 12:20:31','',''),(900,'1','308','1',1,'Retail Sale Id 961',1198.80,0.00,0.00,1.62,123.12,'2023-01-16 13:11:12','',''),(901,'1','308','1',1,'Retail Sale Id 962',1480.00,0.00,0.00,2.00,152.00,'2023-01-16 14:29:56','',''),(902,'1','308','1',1,'Retail Sale Id 964',3700.00,0.00,0.00,5.00,380.00,'2023-01-16 14:36:16','',''),(903,'1','308','1',1,'Retail Sale Id 965',2242.20,0.00,0.00,3.03,230.28,'2023-01-16 15:08:37','',''),(904,'1','308','1',1,'Retail Sale Id 966',4447.40,0.00,0.00,6.01,456.76,'2023-01-16 15:19:47','',''),(905,'1','308','1',1,'Retail Sale Id 967',1502.20,0.00,0.00,2.03,154.28,'2023-01-16 15:25:23','',''),(906,'1','308','1',1,'Retail Sale Id 968',799.20,0.00,0.00,1.08,82.08,'2023-01-16 15:26:31','',''),(907,'1','308','1',1,'Retail Sale Id 969',4447.40,0.00,0.00,6.01,456.76,'2023-01-16 15:59:52','',''),(908,'1','308','1',1,'Retail Sale Id 970',1998.00,0.00,0.00,2.70,205.20,'2023-01-16 16:01:13','',''),(909,'1','308','1',1,'Retail Sale Id 971',503.20,0.00,0.00,0.68,51.68,'2023-01-16 16:17:33','',''),(910,'1','308','1',1,'Retail Sale Id 972',3330.00,0.00,0.00,4.50,342.00,'2023-01-16 16:22:21','',''),(911,'1','308','1',1,'Retail Sale Id 973',3500.20,0.00,0.00,4.73,359.48,'2023-01-16 16:23:58','',''),(912,'1','308','1',1,'Retail Sale Id 974',740.00,0.00,0.00,1.00,76.00,'2023-01-16 16:28:43','',''),(913,'1','308','1',1,'Retail Sale Id 975',18500.00,0.00,0.00,25.00,1900.00,'2023-01-16 16:30:16','',''),(914,'1','308','1',1,'Retail Sale Id 976',1502.20,0.00,0.00,2.03,154.28,'2023-01-16 16:39:06','',''),(915,'1','308','1',1,'Retail Sale Id 977',2220.00,0.00,0.00,3.00,228.00,'2023-01-16 16:42:06','',''),(916,'1','308','1',1,'Retail Sale Id 978',1198.80,0.00,0.00,1.62,123.12,'2023-01-16 16:54:39','',''),(917,'1','308','1',1,'Retail Sale Id 979',1480.00,0.00,0.00,2.00,152.00,'2023-01-16 16:59:18','',''),(918,'1','308','1',1,'Retail Sale Id 980',4440.00,0.00,0.00,6.00,456.00,'2023-01-16 17:05:18','',''),(919,'1','308','1',1,'Retail Sale Id 981',2952.60,0.00,0.00,3.99,303.24,'2023-01-16 17:13:07','',''),(920,'1','308','1',1,'Retail Sale Id 982',2960.00,0.00,0.00,4.00,304.00,'2023-01-16 17:15:36','',''),(921,'1','308','1',1,'Retail Sale Id 983',1480.00,0.00,0.00,2.00,152.00,'2023-01-16 17:36:16','',''),(922,'1','308','1',1,'Retail Sale Id 984',4447.40,0.00,0.00,6.01,456.76,'2023-01-16 17:45:40','',''),(923,'1','308','1',1,'Retail Sale Id 985',747.40,0.00,0.00,1.01,76.76,'2023-01-16 17:48:53','',''),(924,'1','308','1',1,'Retail Sale Id 986',9250.00,0.00,0.00,12.50,950.00,'2023-01-16 18:07:17','',''),(925,'1','308','1',1,'Retail Sale Id 987',2997.00,0.00,0.00,4.05,307.80,'2023-01-16 18:20:57','',''),(926,'1','308','1',1,'Retail Sale Id 988',4447.40,0.00,0.00,6.01,456.76,'2023-01-16 18:24:39','',''),(927,'1','308','1',1,'Retail Sale Id 989',340.40,0.00,0.00,0.46,34.96,'2023-01-16 19:31:56','',''),(928,'1','308','1',1,'Retail Sale Id 990',2197.80,0.00,0.00,2.97,225.72,'2023-01-17 07:41:16','',''),(929,'1','308','1',1,'Retail Sale Id 992',3803.60,0.00,0.00,5.14,390.64,'2023-01-17 07:54:12','',''),(930,'1','308','1',1,'Retail Sale Id 993',2249.60,0.00,0.00,3.04,231.04,'2023-01-17 08:02:28','',''),(931,'1','308','1',1,'Retail Sale Id 994',2249.60,0.00,0.00,3.04,231.04,'2023-01-17 08:03:57','',''),(932,'1','308','1',1,'Retail Sale Id 996',6800.60,0.00,0.00,9.19,698.44,'2023-01-17 08:25:16','',''),(933,'1','308','1',1,'Retail Sale Id 997',4447.40,0.00,0.00,6.01,456.76,'2023-01-17 08:42:45','',''),(934,'1','308','1',1,'Retail Sale Id 999',1998.00,0.00,0.00,2.70,205.20,'2023-01-17 09:34:18','',''),(935,'1','308','1',1,'Retail Sale Id 1000',2960.00,0.00,0.00,4.00,304.00,'2023-01-17 09:36:28','',''),(936,'1','308','1',1,'Retail Sale Id 1001',4447.40,0.00,0.00,6.01,456.76,'2023-01-17 09:38:16','',''),(937,'1','308','1',1,'Retail Sale Id 1002',31240.00,0.00,0.00,44.00,2024.00,'2023-01-17 10:16:52','',''),(938,'1','308','1',1,'Retail Sale Id 1003',740.00,0.00,0.00,1.00,76.00,'2023-01-17 10:18:29','',''),(939,'1','308','1',1,'Retail Sale Id 1004',1502.20,0.00,0.00,2.03,154.28,'2023-01-17 10:51:59','',''),(940,'1','308','1',1,'Retail Sale Id 1005',2153.40,0.00,0.00,2.91,221.16,'2023-01-17 11:10:33','',''),(941,'1','308','1',1,'Retail Sale Id 1006',2220.00,0.00,0.00,3.00,228.00,'2023-01-17 12:06:30','',''),(942,'1','308','1',1,'Retail Sale Id 1007',1480.00,0.00,0.00,2.00,152.00,'2023-01-17 12:14:27','',''),(943,'1','308','1',1,'Retail Sale Id 1008',1480.00,0.00,0.00,2.00,152.00,'2023-01-17 12:17:26','',''),(944,'1','308','1',1,'Retail Sale Id 1009',1502.20,0.00,0.00,2.03,154.28,'2023-01-17 12:21:08','',''),(945,'1','308','1',1,'Retail Sale Id 1010',2997.00,0.00,0.00,4.05,307.80,'2023-01-17 12:40:02','',''),(946,'1','308','1',1,'Retail Sale Id 1011',2960.00,0.00,0.00,4.00,304.00,'2023-01-17 13:18:03','',''),(947,'1','308','1',1,'Retail Sale Id 1012',740.00,0.00,0.00,1.00,76.00,'2023-01-17 13:59:07','',''),(948,'1','308','1',1,'Retail Sale Id 1013',1998.00,0.00,0.00,2.70,205.20,'2023-01-17 14:29:03','',''),(949,'1','308','1',1,'Retail Sale Id 1014',1502.20,0.00,0.00,2.03,154.28,'2023-01-17 15:08:37','',''),(950,'1','308','1',1,'Retail Sale Id 1015',1502.20,0.00,0.00,2.03,154.28,'2023-01-17 15:14:05','',''),(951,'1','308','1',1,'Retail Sale Id 1016',1502.20,0.00,0.00,2.03,154.28,'2023-01-17 15:24:12','',''),(952,'1','308','1',1,'Retail Sale Id 1017',1502.20,0.00,0.00,2.03,154.28,'2023-01-17 15:41:02','',''),(953,'1','308','1',1,'Retail Sale Id 1018',999.00,0.00,0.00,1.35,102.60,'2023-01-17 15:55:50','',''),(954,'1','308','1',1,'Retail Sale Id 1019',7400.00,0.00,0.00,10.00,760.00,'2023-01-17 15:58:22','',''),(955,'1','308','1',1,'Retail Sale Id 1020',2960.00,0.00,0.00,4.00,304.00,'2023-01-17 15:59:50','',''),(956,'1','308','1',1,'Retail Sale Id 1021',1480.00,0.00,0.00,2.00,152.00,'2023-01-17 16:01:01','',''),(957,'1','308','1',1,'Retail Sale Id 1022',1502.20,0.00,0.00,2.03,154.28,'2023-01-17 16:19:49','',''),(958,'1','308','1',1,'Retail Sale Id 1024',2220.00,0.00,0.00,3.00,228.00,'2023-01-17 16:27:07','',''),(959,'1','308','1',1,'Retail Sale Id 1025',2220.00,0.00,0.00,3.00,228.00,'2023-01-17 16:35:41','',''),(960,'1','308','1',1,'Retail Sale Id 1026',1502.20,0.00,0.00,2.03,154.28,'2023-01-17 16:36:46','',''),(961,'1','308','1',1,'Retail Sale Id 1027',142000.00,0.00,0.00,200.00,9200.00,'2023-01-17 16:43:04','',''),(962,'1','308','1',1,'Retail Sale Id 1028',747.40,0.00,0.00,1.01,76.76,'2023-01-17 16:54:22','',''),(963,'1','308','1',1,'Retail Sale Id 1029',1502.20,0.00,0.00,2.03,154.28,'2023-01-17 17:02:08','',''),(964,'1','308','1',1,'Retail Sale Id 1030',2249.60,0.00,0.00,3.04,231.04,'2023-01-17 17:03:23','',''),(965,'1','308','1',1,'Retail Sale Id 1031',3700.00,0.00,0.00,5.00,380.00,'2023-01-17 17:04:59','',''),(966,'1','308','1',1,'Retail Sale Id 1032',4447.40,0.00,0.00,6.01,456.76,'2023-01-17 17:06:00','',''),(967,'1','308','1',1,'Retail Sale Id 1033',2220.00,0.00,0.00,3.00,228.00,'2023-01-17 17:07:28','',''),(968,'1','308','1',1,'Retail Sale Id 1034',2220.00,0.00,0.00,3.00,228.00,'2023-01-17 17:08:03','',''),(969,'1','308','1',1,'Retail Sale Id 1035',1502.20,0.00,0.00,2.03,154.28,'2023-01-17 17:22:46','',''),(970,'1','308','1',1,'Retail Sale Id 1036',747.40,0.00,0.00,1.01,76.76,'2023-01-17 17:25:41','',''),(971,'1','308','1',1,'Retail Sale Id 1037',1998.00,0.00,0.00,2.70,205.20,'2023-01-17 17:27:07','',''),(972,'1','308','1',1,'Retail Sale Id 1038',2220.00,0.00,0.00,3.00,228.00,'2023-01-17 17:36:40','',''),(973,'1','308','1',1,'Retail Sale Id 1039',3700.00,0.00,0.00,5.00,380.00,'2023-01-17 17:38:41','',''),(974,'1','308','1',1,'Retail Sale Id 1040',999.00,0.00,0.00,1.35,102.60,'2023-01-17 17:52:21','',''),(975,'1','308','1',1,'Retail Sale Id 1041',2212.60,0.00,0.00,2.99,227.24,'2023-01-17 17:56:01','',''),(976,'1','308','1',1,'Retail Sale Id 1042',2960.00,0.00,0.00,4.00,304.00,'2023-01-17 17:58:49','',''),(977,'1','308','1',1,'Retail Sale Id 1043',1502.20,0.00,0.00,2.03,154.28,'2023-01-17 18:10:55','',''),(978,'1','308','1',1,'Retail Sale Id 1044',4440.00,0.00,0.00,6.00,456.00,'2023-01-17 18:12:16','',''),(979,'1','308','1',1,'Retail Sale Id 1045',2249.60,0.00,0.00,3.04,231.04,'2023-01-17 18:13:58','',''),(980,'1','308','1',1,'Retail Sale Id 1046',1502.20,0.00,0.00,2.03,154.28,'2023-01-17 18:21:09','',''),(981,'1','308','1',1,'Retail Sale Id 1047',1480.00,0.00,0.00,2.00,152.00,'2023-01-17 18:28:38','',''),(982,'1','308','1',1,'Retail Sale Id 1048',1502.20,0.00,0.00,2.03,154.28,'2023-01-17 18:37:09','',''),(983,'1','308','1',1,'Retail Sale Id 1049',8147.40,0.00,0.00,11.01,836.76,'2023-01-17 18:38:14','',''),(984,'1','308','1',1,'Retail Sale Id 1050',2960.00,0.00,0.00,4.00,304.00,'2023-01-18 07:28:46','',''),(985,'1','308','1',1,'Retail Sale Id 1051',3700.00,0.00,0.00,5.00,380.00,'2023-01-18 07:30:41','',''),(986,'1','308','1',1,'Retail Sale Id 1052',1502.20,0.00,0.00,2.03,154.28,'2023-01-18 07:44:35','',''),(987,'1','308','1',1,'Retail Sale Id 1053',999.00,0.00,0.00,1.35,102.60,'2023-01-18 07:59:27','',''),(988,'1','308','1',1,'Retail Sale Id 1054',9250.00,0.00,0.00,12.50,950.00,'2023-01-18 08:07:37','',''),(989,'1','308','1',1,'Retail Sale Id 1055',7400.00,0.00,0.00,10.00,760.00,'2023-01-18 08:08:50','',''),(990,'1','308','1',1,'Retail Sale Id 1056',5498.20,0.00,0.00,7.43,564.68,'2023-01-18 08:16:28','',''),(991,'1','308','1',1,'Retail Sale Id 1057',7000.40,0.00,0.00,9.46,718.96,'2023-01-18 08:30:54','',''),(992,'1','308','1',1,'Retail Sale Id 1058',8880.00,0.00,0.00,12.00,912.00,'2023-01-18 08:46:18','',''),(993,'1','308','1',1,'Retail Sale Id 1059',2220.00,0.00,0.00,3.00,228.00,'2023-01-18 09:01:17','',''),(994,'1','308','1',1,'Retail Sale Id 1060',4003.40,0.00,0.00,5.41,411.16,'2023-01-18 09:08:04','',''),(995,'1','308','1',1,'Retail Sale Id 1061',1480.00,0.00,0.00,2.00,152.00,'2023-01-18 09:14:52','',''),(996,'1','308','1',1,'Retail Sale Id 1062',21300.00,0.00,0.00,30.00,1380.00,'2023-01-18 09:30:53','',''),(997,'1','308','1',1,'Retail Sale Id 1063',6001.40,0.00,0.00,8.11,616.36,'2023-01-18 09:33:25','',''),(998,'1','308','1',1,'Retail Sale Id 1064',2960.00,0.00,0.00,4.00,304.00,'2023-01-18 09:34:51','',''),(999,'1','308','1',1,'Retail Sale Id 1065',2197.80,0.00,0.00,2.97,225.72,'2023-01-18 09:37:00','',''),(1000,'1','308','1',1,'Retail Sale Id 1066',4003.40,0.00,0.00,5.41,411.16,'2023-01-18 10:25:23','',''),(1001,'1','308','1',1,'Retail Sale Id 1067',1502.20,0.00,0.00,2.03,154.28,'2023-01-18 10:28:59','',''),(1002,'1','308','1',1,'Retail Sale Id 1068',1502.20,0.00,0.00,2.03,154.28,'2023-01-18 10:42:43','',''),(1003,'1','308','1',1,'Retail Sale Id 1069',2249.60,0.00,0.00,3.04,231.04,'2023-01-18 11:15:40','',''),(1004,'1','308','1',1,'Retail Sale Id 1070',3700.00,0.00,0.00,5.00,380.00,'2023-01-18 11:41:43','',''),(1005,'1','308','1',1,'Retail Sale Id 1071',4447.40,0.00,0.00,6.01,456.76,'2023-01-18 12:12:09','',''),(1006,'1','308','1',1,'Retail Sale Id 1072',1502.20,0.00,0.00,2.03,154.28,'2023-01-18 12:18:25','',''),(1007,'1','308','1',1,'Retail Sale Id 1073',3700.00,0.00,0.00,5.00,380.00,'2023-01-18 12:22:44','',''),(1008,'1','308','1',1,'Retail Sale Id 1074',747.40,0.00,0.00,1.01,76.76,'2023-01-18 12:47:27','',''),(1009,'1','308','1',1,'Retail Sale Id 1075',1502.20,0.00,0.00,2.03,154.28,'2023-01-18 12:49:14','',''),(1010,'1','308','1',1,'Retail Sale Id 1076',4440.00,0.00,0.00,6.00,456.00,'2023-01-18 13:13:08','',''),(1011,'1','308','1',1,'Retail Sale Id 1077',9250.00,0.00,0.00,12.50,950.00,'2023-01-18 13:22:24','',''),(1012,'1','308','1',1,'Retail Sale Id 1078',1480.00,0.00,0.00,2.00,152.00,'2023-01-18 13:31:34','',''),(1013,'1','308','1',1,'Retail Sale Id 1079',1502.20,0.00,0.00,2.03,154.28,'2023-01-18 13:51:36','',''),(1014,'1','308','1',1,'Retail Sale Id 1080',1502.20,0.00,0.00,2.03,154.28,'2023-01-18 13:59:57','',''),(1015,'1','308','1',1,'Retail Sale Id 1081',1480.00,0.00,0.00,2.00,152.00,'2023-01-18 14:29:10','',''),(1016,'1','308','1',1,'Retail Sale Id 1082',2220.00,0.00,0.00,3.00,228.00,'2023-01-18 14:38:33','',''),(1017,'1','308','1',1,'Retail Sale Id 1083',4440.00,0.00,0.00,6.00,456.00,'2023-01-18 15:14:30','',''),(1018,'1','308','1',1,'Retail Sale Id 1084',1502.20,0.00,0.00,2.03,154.28,'2023-01-18 15:36:49','',''),(1019,'1','308','1',1,'Retail Sale Id 1085',1480.00,0.00,0.00,2.00,152.00,'2023-01-18 15:41:14','',''),(1020,'1','308','1',1,'Retail Sale Id 1086',1502.20,0.00,0.00,2.03,154.28,'2023-01-18 15:46:38','',''),(1021,'1','308','1',1,'Retail Sale Id 1087',1502.20,0.00,0.00,2.03,154.28,'2023-01-18 15:48:11','',''),(1022,'1','308','1',1,'Retail Sale Id 1088',747.40,0.00,0.00,1.01,76.76,'2023-01-18 16:01:26','',''),(1023,'1','308','1',1,'Retail Sale Id 1089',2271.80,0.00,0.00,3.07,233.32,'2023-01-18 16:08:55','',''),(1024,'1','308','1',1,'Retail Sale Id 1090',4440.00,0.00,0.00,6.00,456.00,'2023-01-18 16:24:03','',''),(1025,'1','308','1',1,'Retail Sale Id 1091',2960.00,0.00,0.00,4.00,304.00,'2023-01-18 16:34:00','',''),(1026,'1','308','1',1,'Retail Sale Id 1092',1850.00,0.00,0.00,2.50,190.00,'2023-01-18 16:36:01','',''),(1027,'1','308','1',1,'Retail Sale Id 1093',1480.00,0.00,0.00,2.00,152.00,'2023-01-18 17:03:17','',''),(1028,'1','308','1',1,'Retail Sale Id 1094',2242.20,0.00,0.00,3.03,230.28,'2023-01-18 17:05:51','',''),(1029,'1','308','1',1,'Retail Sale Id 1095',740.00,0.00,0.00,1.00,76.00,'2023-01-18 17:20:22','',''),(1030,'1','308','1',1,'Retail Sale Id 1096',740.00,0.00,0.00,1.00,76.00,'2023-01-18 17:26:49','',''),(1031,'1','308','1',1,'Retail Sale Id 1097',2197.80,0.00,0.00,2.97,225.72,'2023-01-18 17:28:23','',''),(1032,'1','308','1',1,'Retail Sale Id 1098',1480.00,0.00,0.00,2.00,152.00,'2023-01-18 17:41:47','',''),(1033,'1','308','1',1,'Retail Sale Id 1099',740.00,0.00,0.00,1.00,76.00,'2023-01-18 17:44:35','',''),(1034,'1','308','1',1,'Retail Sale Id 1100',2220.00,0.00,0.00,3.00,228.00,'2023-01-18 17:47:21','',''),(1035,'1','308','1',1,'Retail Sale Id 1101',9250.00,0.00,0.00,12.50,950.00,'2023-01-18 17:48:53','',''),(1036,'1','308','1',1,'Retail Sale Id 1102',2960.00,0.00,0.00,4.00,304.00,'2023-01-18 17:50:24','',''),(1037,'1','308','1',1,'Retail Sale Id 1103',740.00,0.00,0.00,1.00,76.00,'2023-01-18 18:01:23','',''),(1038,'1','308','1',1,'Retail Sale Id 1104',1480.00,0.00,0.00,2.00,152.00,'2023-01-18 18:04:39','',''),(1039,'1','308','1',1,'Retail Sale Id 1106',2220.00,0.00,0.00,3.00,228.00,'2023-01-18 18:07:45','',''),(1040,'1','308','1',1,'Retail Sale Id 1107',2249.60,0.00,0.00,3.04,231.04,'2023-01-18 18:10:32','',''),(1041,'1','308','1',1,'Retail Sale Id 1108',999.00,0.00,0.00,1.35,102.60,'2023-01-18 18:13:04','',''),(1042,'1','308','1',1,'Retail Sale Id 1109',3700.00,0.00,0.00,5.00,380.00,'2023-01-18 18:19:09','',''),(1043,'1','308','1',1,'Retail Sale Id 1110',1480.00,0.00,0.00,2.00,152.00,'2023-01-18 18:21:04','',''),(1044,'1','308','1',1,'Retail Sale Id 1111',26980.00,0.00,0.00,38.00,1748.00,'2023-01-18 18:26:24','',''),(1045,'1','308','1',1,'Retail Sale Id 1112',3700.00,0.00,0.00,5.00,380.00,'2023-01-18 18:31:14','',''),(1046,'1','308','1',1,'Retail Sale Id 1113',1494.80,0.00,0.00,2.02,153.52,'2023-01-18 19:42:45','',''),(1047,'1','308','1',1,'Retail Sale Id 1114',1502.20,0.00,0.00,2.03,154.28,'2023-01-19 07:09:16','',''),(1048,'1','308','1',1,'Retail Sale Id 1115',2249.60,0.00,0.00,3.04,231.04,'2023-01-19 07:10:44','',''),(1049,'1','308','1',1,'Retail Sale Id 1116',2952.60,0.00,0.00,3.99,303.24,'2023-01-19 07:12:25','',''),(1050,'1','308','1',1,'Retail Sale Id 1117',747.40,0.00,0.00,1.01,76.76,'2023-01-19 07:19:19','',''),(1051,'1','308','1',1,'Retail Sale Id 1118',9250.00,0.00,0.00,12.50,950.00,'2023-01-19 09:00:23','',''),(1052,'1','308','1',1,'Retail Sale Id 1119',4447.40,0.00,0.00,6.01,456.76,'2023-01-19 09:14:15','',''),(1053,'1','308','1',1,'Retail Sale Id 1120',2197.80,0.00,0.00,2.97,225.72,'2023-01-19 09:17:46','',''),(1054,'1','308','1',1,'Retail Sale Id 1121',4499.20,0.00,0.00,6.08,462.08,'2023-01-19 10:43:58','',''),(1055,'1','308','1',1,'Retail Sale Id 1122',2197.80,0.00,0.00,2.97,225.72,'2023-01-19 12:04:20','',''),(1056,'1','308','1',1,'Retail Sale Id 1123',1502.20,0.00,0.00,2.03,154.28,'2023-01-19 12:06:45','',''),(1057,'1','308','1',1,'Retail Sale Id 1124',1502.20,0.00,0.00,2.03,154.28,'2023-01-19 12:07:28','',''),(1058,'1','308','1',1,'Retail Sale Id 1125',999.00,0.00,0.00,1.35,102.60,'2023-01-19 12:19:52','',''),(1059,'1','308','1',1,'Retail Sale Id 1126',20002.20,0.00,0.00,27.03,2054.28,'2023-01-19 13:56:36','',''),(1060,'1','308','1',1,'Retail Sale Id 1127',4447.40,0.00,0.00,6.01,456.76,'2023-01-19 14:13:12','',''),(1061,'1','308','1',1,'Retail Sale Id 1128',3700.00,0.00,0.00,5.00,380.00,'2023-01-19 14:18:47','',''),(1062,'1','308','1',1,'Retail Sale Id 1129',4447.40,0.00,0.00,6.01,456.76,'2023-01-19 15:21:56','',''),(1063,'1','308','1',1,'Retail Sale Id 1130',1502.20,0.00,0.00,2.03,154.28,'2023-01-19 15:31:03','',''),(1064,'1','308','1',1,'Retail Sale Id 1131',2997.00,0.00,0.00,4.05,307.80,'2023-01-19 16:00:13','',''),(1065,'1','308','1',1,'Retail Sale Id 1132',1502.20,0.00,0.00,2.03,154.28,'2023-01-19 16:15:09','',''),(1066,'1','308','1',1,'Retail Sale Id 1133',2997.00,0.00,0.00,4.05,307.80,'2023-01-19 16:16:09','',''),(1067,'1','308','1',1,'Retail Sale Id 1134',1502.20,0.00,0.00,2.03,154.28,'2023-01-19 16:20:15','',''),(1068,'1','308','1',1,'Retail Sale Id 1135',1502.20,0.00,0.00,2.03,154.28,'2023-01-19 16:59:50','',''),(1069,'1','308','1',1,'Retail Sale Id 1136',747.40,0.00,0.00,1.01,76.76,'2023-01-19 17:05:12','',''),(1070,'1','308','1',1,'Retail Sale Id 1137',3700.00,0.00,0.00,5.00,380.00,'2023-01-19 17:13:16','',''),(1071,'1','308','1',1,'Retail Sale Id 1138',3700.00,0.00,0.00,5.00,380.00,'2023-01-19 17:14:14','',''),(1072,'1','308','1',1,'Retail Sale Id 1139',999.00,0.00,0.00,1.35,102.60,'2023-01-19 17:17:21','',''),(1073,'1','308','1',1,'Retail Sale Id 1140',1502.20,0.00,0.00,2.03,154.28,'2023-01-19 17:19:17','',''),(1074,'1','308','1',1,'Retail Sale Id 1141',5202.20,0.00,0.00,7.03,534.28,'2023-01-19 17:22:54','',''),(1075,'1','308','1',1,'Retail Sale Id 1142',1502.20,0.00,0.00,2.03,154.28,'2023-01-19 17:31:09','',''),(1076,'1','308','1',1,'Retail Sale Id 1143',747.40,0.00,0.00,1.01,76.76,'2023-01-19 17:40:11','',''),(1077,'1','308','1',1,'Retail Sale Id 1144',2997.00,0.00,0.00,4.05,307.80,'2023-01-19 17:42:26','',''),(1078,'1','308','1',1,'Retail Sale Id 1145',2960.00,0.00,0.00,4.00,304.00,'2023-01-19 17:46:09','',''),(1079,'1','308','1',1,'Retail Sale Id 1146',2197.80,0.00,0.00,2.97,225.72,'2023-01-19 17:47:42','',''),(1080,'1','308','1',1,'Retail Sale Id 1147',3700.00,0.00,0.00,5.00,380.00,'2023-01-19 17:51:02','',''),(1081,'1','308','1',1,'Retail Sale Id 1148',2960.00,0.00,0.00,4.00,304.00,'2023-01-19 17:56:09','',''),(1082,'1','308','1',1,'Retail Sale Id 1149',747.40,0.00,0.00,1.01,76.76,'2023-01-19 18:11:50','',''),(1083,'1','308','1',1,'Retail Sale Id 1150',3700.00,0.00,0.00,5.00,380.00,'2023-01-19 18:12:51','',''),(1084,'1','308','1',1,'Retail Sale Id 1151',4499.20,0.00,0.00,6.08,462.08,'2023-01-19 18:39:18','',''),(1085,'1','308','1',1,'Retail Sale Id 1152',17750.00,0.00,0.00,25.00,1150.00,'2023-01-19 18:57:57','',''),(1086,'1','308','1',1,'Retail Sale Id 1153',1502.20,0.00,0.00,2.03,154.28,'2023-01-19 19:08:14','',''),(1087,'1','308','1',1,'Retail Sale Id 1154',4440.00,0.00,0.00,6.00,456.00,'2023-01-19 19:10:34','',''),(1088,'1','308','1',1,'Retail Sale Id 1155',148.00,0.00,0.00,0.20,15.20,'2023-01-19 19:32:21','',''),(1089,'1','308','1',1,'Retail Sale Id 1156',28400.00,0.00,0.00,40.00,1840.00,'2023-01-20 07:36:59','',''),(1090,'1','308','1',1,'Retail Sale Id 1157',1502.20,0.00,0.00,2.03,154.28,'2023-01-20 07:42:54','',''),(1091,'1','308','1',1,'Retail Sale Id 1158',8880.00,0.00,0.00,12.00,912.00,'2023-01-20 08:21:52','',''),(1092,'1','308','1',1,'Retail Sale Id 1159',2960.00,0.00,0.00,4.00,304.00,'2023-01-20 08:59:47','',''),(1093,'1','308','1',1,'Retail Sale Id 1160',21300.00,0.00,0.00,30.00,1380.00,'2023-01-20 09:33:23','',''),(1094,'1','308','1',1,'Retail Sale Id 1161',1480.00,0.00,0.00,2.00,152.00,'2023-01-20 09:36:29','',''),(1095,'1','308','1',1,'Retail Sale Id 1162',4440.00,0.00,0.00,6.00,456.00,'2023-01-20 10:00:03','',''),(1096,'1','308','1',1,'Retail Sale Id 1163',999.00,0.00,0.00,1.35,102.60,'2023-01-20 10:05:21','',''),(1097,'1','308','1',1,'Retail Sale Id 1164',1502.20,0.00,0.00,2.03,154.28,'2023-01-20 10:10:32','',''),(1098,'1','308','1',1,'Retail Sale Id 1165',3700.00,0.00,0.00,5.00,380.00,'2023-01-20 10:45:33','',''),(1099,'1','308','1',1,'Retail Sale Id 1166',2220.00,0.00,0.00,3.00,228.00,'2023-01-20 10:57:31','',''),(1100,'1','308','1',1,'Retail Sale Id 1167',2220.00,0.00,0.00,3.00,228.00,'2023-01-20 11:00:16','',''),(1101,'1','308','1',1,'Retail Sale Id 1168',999.00,0.00,0.00,1.35,102.60,'2023-01-20 11:42:59','',''),(1102,'1','308','1',1,'Retail Sale Id 1169',5180.00,0.00,0.00,7.00,532.00,'2023-01-20 11:48:28','',''),(1103,'1','308','1',1,'Retail Sale Id 1170',4440.00,0.00,0.00,6.00,456.00,'2023-01-20 12:26:26','',''),(1104,'1','308','1',1,'Retail Sale Id 1171',1502.20,0.00,0.00,2.03,154.28,'2023-01-20 12:44:04','',''),(1105,'1','308','1',1,'Retail Sale Id 1172',5180.00,0.00,0.00,7.00,532.00,'2023-01-20 12:50:06','',''),(1106,'1','308','1',1,'Retail Sale Id 1173',5202.20,0.00,0.00,7.03,534.28,'2023-01-20 12:51:43','',''),(1107,'1','308','1',1,'Retail Sale Id 1174',2220.00,0.00,0.00,3.00,228.00,'2023-01-20 12:57:20','',''),(1108,'1','308','1',1,'Retail Sale Id 1175',3700.00,0.00,0.00,5.00,380.00,'2023-01-20 13:10:05','',''),(1109,'1','308','1',1,'Retail Sale Id 1176',747.40,0.00,0.00,1.01,76.76,'2023-01-20 13:14:54','',''),(1110,'1','308','1',1,'Retail Sale Id 1177',2220.00,0.00,0.00,3.00,228.00,'2023-01-20 13:31:32','',''),(1111,'1','308','1',1,'Retail Sale Id 1178',4440.00,0.00,0.00,6.00,456.00,'2023-01-20 14:58:19','',''),(1112,'1','308','1',1,'Retail Sale Id 1179',8880.00,0.00,0.00,12.00,912.00,'2023-01-20 15:15:41','',''),(1113,'1','308','1',1,'Retail Sale Id 1180',1480.00,0.00,0.00,2.00,152.00,'2023-01-20 15:22:05','',''),(1114,'1','308','1',1,'Retail Sale Id 1181',4440.00,0.00,0.00,6.00,456.00,'2023-01-20 15:54:34','',''),(1115,'1','308','1',1,'Retail Sale Id 1182',747.40,0.00,0.00,1.01,76.76,'2023-01-20 16:02:33','',''),(1116,'1','308','1',1,'Retail Sale Id 1183',4440.00,0.00,0.00,6.00,456.00,'2023-01-20 16:24:00','',''),(1117,'1','308','1',1,'Retail Sale Id 1184',2227.40,0.00,0.00,3.01,228.76,'2023-01-20 16:26:54','',''),(1118,'1','308','1',1,'Retail Sale Id 1185',2960.00,0.00,0.00,4.00,304.00,'2023-01-20 16:39:07','',''),(1119,'1','308','1',1,'Retail Sale Id 1186',747.40,0.00,0.00,1.01,76.76,'2023-01-20 16:50:53','',''),(1120,'1','308','1',1,'Retail Sale Id 1187',2301.40,0.00,0.00,3.11,236.36,'2023-01-20 17:03:40','',''),(1121,'1','308','1',1,'Retail Sale Id 1188',1502.20,0.00,0.00,2.03,154.28,'2023-01-20 17:09:35','',''),(1122,'1','308','1',1,'Retail Sale Id 1189',999.00,0.00,0.00,1.35,102.60,'2023-01-20 17:21:49','',''),(1123,'1','308','1',1,'Return of Retail Sale Id 1169',0.00,5180.00,7.00,0.00,-532.00,'2023-01-20 17:30:44','',''),(1124,'1','308','1',1,'Retail Sale Id 1190',2249.60,0.00,0.00,3.04,231.04,'2023-01-20 17:33:07','',''),(1125,'1','308','1',1,'Retail Sale Id 1191',3700.00,0.00,0.00,5.00,380.00,'2023-01-20 17:35:40','',''),(1126,'1','308','1',1,'Retail Sale Id 1192',740.00,0.00,0.00,1.00,76.00,'2023-01-20 17:41:40','',''),(1127,'1','308','1',1,'Retail Sale Id 1194',2960.00,0.00,0.00,4.00,304.00,'2023-01-20 17:43:46','',''),(1128,'1','308','1',1,'Retail Sale Id 1195',2249.60,0.00,0.00,3.04,231.04,'2023-01-20 17:45:14','',''),(1129,'1','308','1',1,'Retail Sale Id 1196',3700.00,0.00,0.00,5.00,380.00,'2023-01-20 17:55:53','',''),(1130,'1','308','1',1,'Retail Sale Id 1197',8998.40,0.00,0.00,12.16,924.16,'2023-01-20 18:05:14','',''),(1131,'1','308','1',1,'Retail Sale Id 1198',2960.00,0.00,0.00,4.00,304.00,'2023-01-20 18:09:11','',''),(1132,'1','308','1',1,'Retail Sale Id 1200',1502.20,0.00,0.00,2.03,154.28,'2023-01-20 18:34:07','',''),(1133,'1','308','1',1,'Retail Sale Id 1201',4588.00,0.00,0.00,6.20,471.20,'2023-01-20 19:09:16','',''),(1134,'1','308','1',1,'Return of Retail Sale Id 1201',0.00,4588.00,6.20,0.00,-471.20,'2023-01-20 19:10:09','',''),(1135,'1','308','1',1,'Retail Sale Id 1202',4551.00,0.00,0.00,6.15,467.40,'2023-01-20 19:12:21','',''),(1136,'1','308','1',1,'Return of Retail Sale Id 1156',0.00,28400.00,40.00,0.00,-1840.00,'2023-01-20 19:29:36','',''),(1137,'1','308','1',1,'Retail Sale Id 1203',27690.00,0.00,0.00,39.00,1794.00,'2023-01-20 19:34:00','',''),(1138,'1','308','1',1,'Return of Retail Sale Id 1203',0.00,27690.00,39.00,0.00,-1794.00,'2023-01-20 19:42:15','',''),(1139,'1','308','1',1,'Retail Sale Id 1204',28400.00,0.00,0.00,40.00,1840.00,'2023-01-20 19:43:06','',''),(1140,'1','308','1',1,'Retail Sale Id 1205',3700.00,0.00,0.00,5.00,380.00,'2023-01-21 07:29:28','',''),(1141,'1','308','1',1,'Retail Sale Id 1206',1502.20,0.00,0.00,2.03,154.28,'2023-01-21 07:32:56','',''),(1142,'1','308','1',1,'Retail Sale Id 1207',5897.80,0.00,0.00,7.97,605.72,'2023-01-21 07:39:00','',''),(1143,'1','308','1',1,'Retail Sale Id 1208',2220.00,0.00,0.00,3.00,228.00,'2023-01-21 07:42:07','',''),(1144,'1','308','1',1,'Retail Sale Id 1209',1502.20,0.00,0.00,2.03,154.28,'2023-01-21 07:58:57','',''),(1145,'1','308','1',1,'Retail Sale Id 1210',1998.00,0.00,0.00,2.70,205.20,'2023-01-21 08:02:27','',''),(1146,'1','308','1',1,'Retail Sale Id 1211',1502.20,0.00,0.00,2.03,154.28,'2023-01-21 08:06:34','',''),(1147,'1','308','1',1,'Retail Sale Id 1212',9250.00,0.00,0.00,12.50,950.00,'2023-01-21 08:54:50','',''),(1148,'1','308','1',1,'Retail Sale Id 1213',1502.20,0.00,0.00,2.03,154.28,'2023-01-21 08:56:50','',''),(1149,'1','308','1',1,'Retail Sale Id 1214',2590.00,0.00,0.00,3.50,266.00,'2023-01-21 09:15:06','',''),(1150,'1','308','1',1,'Retail Sale Id 1215',11100.00,0.00,0.00,15.00,1140.00,'2023-01-21 09:29:35','',''),(1151,'1','308','1',1,'Retail Sale Id 1216',1502.20,0.00,0.00,2.03,154.28,'2023-01-21 09:48:35','',''),(1152,'1','308','1',1,'Retail Sale Id 1217',9250.00,0.00,0.00,12.50,950.00,'2023-01-21 10:15:04','',''),(1153,'1','308','1',1,'Retail Sale Id 1218',2220.00,0.00,0.00,3.00,228.00,'2023-01-21 10:25:53','',''),(1154,'1','308','1',1,'Retail Sale Id 1219',747.40,0.00,0.00,1.01,76.76,'2023-01-21 10:41:26','',''),(1155,'1','308','1',1,'Retail Sale Id 1220',4447.40,0.00,0.00,6.01,456.76,'2023-01-21 11:09:48','',''),(1156,'1','308','1',1,'Retail Sale Id 1221',2227.40,0.00,0.00,3.01,228.76,'2023-01-21 11:18:04','',''),(1157,'1','308','1',1,'Retail Sale Id 1222',2227.40,0.00,0.00,3.01,228.76,'2023-01-21 11:44:20','',''),(1158,'1','308','1',1,'Retail Sale Id 1223',1502.20,0.00,0.00,2.03,154.28,'2023-01-21 11:51:21','',''),(1159,'1','308','1',1,'Retail Sale Id 1224',1502.20,0.00,0.00,2.03,154.28,'2023-01-21 12:05:48','',''),(1160,'1','308','1',1,'Retail Sale Id 1225',2220.00,0.00,0.00,3.00,228.00,'2023-01-21 12:19:07','',''),(1161,'1','308','1',1,'Retail Sale Id 1226',2997.00,0.00,0.00,4.05,307.80,'2023-01-21 12:39:00','',''),(1162,'1','308','1',1,'Retail Sale Id 1227',1502.20,0.00,0.00,2.03,154.28,'2023-01-21 13:32:57','',''),(1163,'1','308','1',1,'Retail Sale Id 1228',28400.00,0.00,0.00,40.00,1840.00,'2023-01-21 13:53:42','',''),(1164,'1','308','1',1,'Retail Sale Id 1229',14910.00,0.00,0.00,21.00,966.00,'2023-01-21 13:55:12','',''),(1165,'1','308','1',1,'Retail Sale Id 1230',4447.40,0.00,0.00,6.01,456.76,'2023-01-21 14:25:02','',''),(1166,'1','308','1',1,'Retail Sale Id 1231',2220.00,0.00,0.00,3.00,228.00,'2023-01-21 14:43:43','',''),(1167,'1','308','1',1,'Retail Sale Id 1232',2997.00,0.00,0.00,4.05,307.80,'2023-01-21 14:48:08','',''),(1168,'1','308','1',1,'Retail Sale Id 1233',747.40,0.00,0.00,1.01,76.76,'2023-01-21 14:50:56','',''),(1169,'1','308','1',1,'Retail Sale Id 1234',2997.00,0.00,0.00,4.05,307.80,'2023-01-21 14:54:20','',''),(1170,'1','308','1',1,'Retail Sale Id 1235',7400.00,0.00,0.00,10.00,760.00,'2023-01-21 15:00:46','',''),(1171,'1','308','1',1,'Retail Sale Id 1236',4447.40,0.00,0.00,6.01,456.76,'2023-01-21 15:05:58','',''),(1172,'1','308','1',1,'Retail Sale Id 1237',799.20,0.00,0.00,1.08,82.08,'2023-01-21 15:08:58','',''),(1173,'1','308','1',1,'Retail Sale Id 1238',2220.00,0.00,0.00,3.00,228.00,'2023-01-21 15:12:35','',''),(1174,'1','308','1',1,'Retail Sale Id 1239',3700.00,0.00,0.00,5.00,380.00,'2023-01-21 15:22:15','',''),(1175,'1','308','1',1,'Retail Sale Id 1240',3700.00,0.00,0.00,5.00,380.00,'2023-01-21 15:32:20','',''),(1176,'1','308','1',1,'Retail Sale Id 1241',17750.00,0.00,0.00,25.00,1150.00,'2023-01-21 15:41:02','',''),(1177,'1','308','1',1,'Retail Sale Id 1242',17750.00,0.00,0.00,25.00,1150.00,'2023-01-21 15:42:51','',''),(1178,'1','308','1',1,'Return of Retail Sale Id 1241',0.00,17750.00,25.00,0.00,-1150.00,'2023-01-21 15:43:33','',''),(1179,'1','308','1',1,'Retail Sale Id 1243',9250.00,0.00,0.00,12.50,950.00,'2023-01-21 16:10:35','',''),(1180,'1','308','1',1,'Retail Sale Id 1244',1502.20,0.00,0.00,2.03,154.28,'2023-01-21 16:11:49','',''),(1181,'1','308','1',1,'Retail Sale Id 1245',2997.00,0.00,0.00,4.05,307.80,'2023-01-21 16:41:31','',''),(1182,'1','308','1',1,'Retail Sale Id 1246',2220.00,0.00,0.00,3.00,228.00,'2023-01-21 16:59:28','',''),(1183,'1','308','1',1,'Retail Sale Id 1247',747.40,0.00,0.00,1.01,76.76,'2023-01-21 17:07:26','',''),(1184,'1','308','1',1,'Retail Sale Id 1248',1502.20,0.00,0.00,2.03,154.28,'2023-01-21 17:25:59','',''),(1185,'1','308','1',1,'Retail Sale Id 1249',503.20,0.00,0.00,0.68,51.68,'2023-01-21 17:44:04','',''),(1186,'1','308','1',1,'Retail Sale Id 1250',1502.20,0.00,0.00,2.03,154.28,'2023-01-21 17:55:51','',''),(1187,'1','308','1',1,'Retail Sale Id 1251',2501.20,0.00,0.00,3.38,371.80,'2023-01-21 18:02:25','',''),(1188,'1','308','1',1,'Retail Sale Id 1252',747.40,0.00,0.00,1.01,111.10,'2023-01-21 18:03:49','',''),(1189,'1','308','1',1,'Retail Sale Id 1253',830.70,0.00,0.00,1.17,93.60,'2023-01-21 19:13:40','',''),(1190,'1','308','1',1,'Retail Sale Id 1254',606.80,0.00,0.00,0.82,90.20,'2023-01-21 19:14:23','',''),(1191,'1','308','1',1,'Retail Sale Id 1255',999.00,0.00,0.00,1.35,148.50,'2023-01-22 07:30:40','',''),(1192,'1','308','1',1,'Retail Sale Id 1256',503.20,0.00,0.00,0.68,74.80,'2023-01-22 07:36:45','',''),(1193,'1','308','1',1,'Retail Sale Id 1257',2249.60,0.00,0.00,3.04,334.40,'2023-01-22 07:40:16','',''),(1194,'1','308','1',1,'Retail Sale Id 1258',4447.40,0.00,0.00,6.01,661.10,'2023-01-22 07:43:56','',''),(1195,'1','308','1',1,'Retail Sale Id 1259',747.40,0.00,0.00,1.01,111.10,'2023-01-22 07:45:27','',''),(1196,'1','308','1',1,'Retail Sale Id 1260',1502.20,0.00,0.00,2.03,223.30,'2023-01-22 08:01:39','',''),(1197,'1','308','1',1,'Retail Sale Id 1261',2997.00,0.00,0.00,4.05,445.50,'2023-01-22 08:12:21','',''),(1198,'1','308','1',1,'Retail Sale Id 1262',1502.20,0.00,0.00,2.03,223.30,'2023-01-22 08:13:09','',''),(1199,'1','308','1',1,'Retail Sale Id 1263',1502.20,0.00,0.00,2.03,223.30,'2023-01-22 08:28:19','',''),(1200,'1','308','1',1,'Retail Sale Id 1264',799.20,0.00,0.00,1.08,118.80,'2023-01-22 08:30:08','',''),(1201,'1','308','1',1,'Retail Sale Id 1265',1502.20,0.00,0.00,2.03,223.30,'2023-01-22 08:46:52','',''),(1202,'1','308','1',1,'Retail Sale Id 1266',4447.40,0.00,0.00,6.01,661.10,'2023-01-22 08:57:25','',''),(1203,'1','308','1',1,'Retail Sale Id 1267',2220.00,0.00,0.00,3.00,330.00,'2023-01-22 09:00:13','',''),(1204,'1','308','1',1,'Retail Sale Id 1268',5920.00,0.00,0.00,8.00,880.00,'2023-01-22 09:32:07','',''),(1205,'1','308','1',1,'Retail Sale Id 1269',2249.60,0.00,0.00,3.04,334.40,'2023-01-22 09:37:00','',''),(1206,'1','308','1',1,'Retail Sale Id 1270',1502.20,0.00,0.00,2.03,223.30,'2023-01-22 09:40:26','',''),(1207,'1','308','1',1,'Retail Sale Id 1271',1502.20,0.00,0.00,2.03,223.30,'2023-01-22 09:47:25','',''),(1208,'1','308','1',1,'Retail Sale Id 1272',4447.40,0.00,0.00,6.01,661.10,'2023-01-22 09:54:06','',''),(1209,'1','308','1',1,'Retail Sale Id 1273',2220.00,0.00,0.00,3.00,330.00,'2023-01-22 10:16:55','',''),(1210,'1','308','1',1,'Retail Sale Id 1274',4447.40,0.00,0.00,6.01,661.10,'2023-01-22 10:26:43','',''),(1211,'1','308','1',1,'Retail Sale Id 1275',2982.20,0.00,0.00,4.03,443.30,'2023-01-22 10:28:30','',''),(1212,'1','308','1',1,'Retail Sale Id 1276',4447.40,0.00,0.00,6.01,661.10,'2023-01-22 10:32:36','',''),(1213,'1','308','1',1,'Retail Sale Id 1277',747.40,0.00,0.00,1.01,111.10,'2023-01-22 10:37:12','',''),(1214,'1','308','1',1,'Retail Sale Id 1278',3700.00,0.00,0.00,5.00,550.00,'2023-01-22 10:39:06','',''),(1215,'1','308','1',1,'Retail Sale Id 1279',9250.00,0.00,0.00,12.50,1375.00,'2023-01-22 10:59:56','',''),(1216,'1','308','1',1,'Retail Sale Id 1280',2220.00,0.00,0.00,3.00,330.00,'2023-01-22 11:13:29','',''),(1217,'1','308','1',1,'Retail Sale Id 1281',740.00,0.00,0.00,1.00,110.00,'2023-01-22 11:15:11','',''),(1218,'1','308','1',1,'Retail Sale Id 1282',3700.00,0.00,0.00,5.00,550.00,'2023-01-22 11:19:54','',''),(1219,'1','308','1',1,'Retail Sale Id 1283',1480.00,0.00,0.00,2.00,220.00,'2023-01-22 11:21:41','',''),(1220,'1','308','1',1,'Retail Sale Id 1284',4447.40,0.00,0.00,6.01,661.10,'2023-01-22 11:49:45','',''),(1221,'1','308','1',1,'Retail Sale Id 1285',740.00,0.00,0.00,1.00,110.00,'2023-01-22 12:07:06','',''),(1222,'1','308','1',1,'Retail Sale Id 1286',740.00,0.00,0.00,1.00,110.00,'2023-01-22 12:09:22','',''),(1223,'1','308','1',1,'Retail Sale Id 1287',38500.00,0.00,0.00,55.00,3850.00,'2023-01-22 12:26:03','',''),(1224,'1','308','1',1,'Retail Sale Id 1288',1480.00,0.00,0.00,2.00,220.00,'2023-01-22 12:55:17','',''),(1225,'1','308','1',1,'Retail Sale Id 1289',4440.00,0.00,0.00,6.00,660.00,'2023-01-22 12:56:24','',''),(1226,'1','308','1',1,'Retail Sale Id 1290',4440.00,0.00,0.00,6.00,660.00,'2023-01-22 12:57:41','',''),(1227,'1','308','1',1,'Retail Sale Id 1291',999.00,0.00,0.00,1.35,148.50,'2023-01-22 13:05:57','',''),(1228,'1','308','1',1,'Retail Sale Id 1292',3700.00,0.00,0.00,5.00,550.00,'2023-01-22 13:19:01','',''),(1229,'1','308','1',1,'Retail Sale Id 1293',4440.00,0.00,0.00,6.00,660.00,'2023-01-22 13:45:05','',''),(1230,'1','308','1',1,'Retail Sale Id 1294',2220.00,0.00,0.00,3.00,330.00,'2023-01-22 13:47:03','',''),(1231,'1','308','1',1,'Retail Sale Id 1295',9250.00,0.00,0.00,12.50,1375.00,'2023-01-22 14:03:07','',''),(1232,'1','308','1',1,'Retail Sale Id 1296',2220.00,0.00,0.00,3.00,330.00,'2023-01-22 14:09:42','',''),(1233,'1','308','1',1,'Retail Sale Id 1297',740.00,0.00,0.00,1.00,110.00,'2023-01-22 14:11:12','',''),(1234,'1','308','1',1,'Retail Sale Id 1298',1480.00,0.00,0.00,2.00,220.00,'2023-01-22 14:15:03','',''),(1235,'1','308','1',1,'Retail Sale Id 1299',5002.40,0.00,0.00,6.76,743.60,'2023-01-22 14:30:32','',''),(1236,'1','308','1',1,'Retail Sale Id 1300',4440.00,0.00,0.00,6.00,660.00,'2023-01-22 14:40:30','',''),(1237,'1','308','1',1,'Retail Sale Id 1301',2220.00,0.00,0.00,3.00,330.00,'2023-01-22 14:42:28','',''),(1238,'1','308','1',1,'Retail Sale Id 1302',740.00,0.00,0.00,1.00,110.00,'2023-01-22 14:44:37','',''),(1239,'1','308','1',1,'Retail Sale Id 1303',1480.00,0.00,0.00,2.00,220.00,'2023-01-22 14:54:25','',''),(1240,'1','308','1',1,'Retail Sale Id 1304',3700.00,0.00,0.00,5.00,550.00,'2023-01-22 15:04:14','',''),(1241,'1','308','1',1,'Retail Sale Id 1305',1480.00,0.00,0.00,2.00,220.00,'2023-01-22 15:06:20','',''),(1242,'1','308','1',1,'Retail Sale Id 1306',2220.00,0.00,0.00,3.00,330.00,'2023-01-22 15:10:17','',''),(1243,'1','308','1',1,'Retail Sale Id 1307',3500.20,0.00,0.00,4.73,520.30,'2023-01-22 15:13:07','',''),(1244,'1','308','1',1,'Retail Sale Id 1308',1480.00,0.00,0.00,2.00,220.00,'2023-01-22 15:29:08','',''),(1245,'1','308','1',1,'Retail Sale Id 1309',2501.20,0.00,0.00,3.38,371.80,'2023-01-22 16:36:47','',''),(1246,'1','308','1',1,'Retail Sale Id 1310',4440.00,0.00,0.00,6.00,660.00,'2023-01-22 16:46:49','',''),(1247,'1','308','1',1,'Retail Sale Id 1311',747.40,0.00,0.00,1.01,111.10,'2023-01-22 16:56:17','',''),(1248,'1','308','1',1,'Retail Sale Id 1312',9250.00,0.00,0.00,12.50,1375.00,'2023-01-22 16:57:23','',''),(1249,'1','308','1',1,'Retail Sale Id 1313',2220.00,0.00,0.00,3.00,330.00,'2023-01-22 17:12:35','',''),(1250,'1','308','1',1,'Retail Sale Id 1314',1480.00,0.00,0.00,2.00,220.00,'2023-01-22 17:30:46','',''),(1251,'1','308','1',1,'Retail Sale Id 1315',2220.00,0.00,0.00,3.00,330.00,'2023-01-22 17:32:51','',''),(1252,'1','308','1',1,'Retail Sale Id 1316',1480.00,0.00,0.00,2.00,220.00,'2023-01-22 17:34:45','',''),(1253,'1','308','1',1,'Retail Sale Id 1317',4440.00,0.00,0.00,6.00,660.00,'2023-01-22 17:39:32','',''),(1254,'1','308','1',1,'Retail Sale Id 1317',4440.00,0.00,0.00,6.00,660.00,'2023-01-22 17:39:32','',''),(1255,'1','308','1',1,'Retail Sale Id 1318',747.40,0.00,0.00,1.01,111.10,'2023-01-22 17:41:14','',''),(1256,'1','308','1',1,'Retail Sale Id 1319',1502.20,0.00,0.00,2.03,223.30,'2023-01-22 17:58:10','',''),(1257,'1','308','1',1,'Retail Sale Id 1320',7400.00,0.00,0.00,10.00,1100.00,'2023-01-22 17:59:44','',''),(1258,'1','308','1',1,'Retail Sale Id 1321',747.40,0.00,0.00,1.01,111.10,'2023-01-22 18:06:26','',''),(1259,'1','308','1',1,'Retail Sale Id 1322',9250.00,0.00,0.00,12.50,1375.00,'2023-01-22 18:08:56','',''),(1260,'1','308','1',1,'Retail Sale Id 1323',1998.00,0.00,0.00,2.70,297.00,'2023-01-22 18:34:51','',''),(1261,'1','308','1',1,'Retail Sale Id 1324',2960.00,0.00,0.00,4.00,440.00,'2023-01-22 18:36:58','',''),(1262,'1','308','1',1,'Retail Sale Id 1325',4440.00,0.00,0.00,6.00,660.00,'2023-01-22 18:42:23','',''),(1263,'1','308','1',1,'Retail Sale Id 1325',4440.00,0.00,0.00,6.00,660.00,'2023-01-22 18:42:23','',''),(1264,'1','308','1',1,'Retail Sale Id 1326',4440.00,0.00,0.00,6.00,660.00,'2023-01-22 18:44:33','',''),(1265,'1','308','1',1,'Retail Sale Id 1327',8998.40,0.00,0.00,12.16,1337.60,'2023-01-22 18:47:23','',''),(1266,'1','308','1',1,'Retail Sale Id 1328',747.40,0.00,0.00,1.01,111.10,'2023-01-22 18:49:28','',''),(1267,'1','308','1',1,'Retail Sale Id 1329',4499.20,0.00,0.00,6.08,668.80,'2023-01-22 18:51:18','',''),(1268,'1','308','1',1,'Retail Sale Id 1330',2960.00,0.00,0.00,4.00,440.00,'2023-01-23 07:29:11','',''),(1269,'1','308','1',1,'Retail Sale Id 1331',2220.00,0.00,0.00,3.00,330.00,'2023-01-23 07:37:35','',''),(1270,'1','308','1',1,'Retail Sale Id 1332',3700.00,0.00,0.00,5.00,550.00,'2023-01-23 07:39:27','',''),(1271,'1','308','1',1,'Retail Sale Id 1333',17150.00,0.00,0.00,24.50,1715.00,'2023-01-23 07:51:40','',''),(1272,'1','308','1',1,'Retail Sale Id 1334',4440.00,0.00,0.00,6.00,660.00,'2023-01-23 07:56:38','',''),(1273,'1','308','1',1,'Retail Sale Id 1335',2197.80,0.00,0.00,2.97,326.70,'2023-01-23 07:59:54','',''),(1274,'1','308','1',1,'Retail Sale Id 1336',3700.00,0.00,0.00,5.00,550.00,'2023-01-23 08:17:21','',''),(1275,'1','308','1',1,'Retail Sale Id 1338',2220.00,0.00,0.00,3.00,330.00,'2023-01-23 08:53:27','',''),(1276,'1','308','1',1,'Retail Sale Id 1339',4440.00,0.00,0.00,6.00,660.00,'2023-01-23 09:27:45','',''),(1277,'1','308','1',1,'Retail Sale Id 1340',2960.00,0.00,0.00,4.00,440.00,'2023-01-23 09:30:13','',''),(1278,'1','308','1',1,'Retail Sale Id 1341',4440.00,0.00,0.00,6.00,660.00,'2023-01-23 09:31:39','',''),(1279,'1','308','1',1,'Retail Sale Id 1342',9250.00,0.00,0.00,12.50,1375.00,'2023-01-23 09:46:14','',''),(1280,'1','308','1',1,'Retail Sale Id 1343',740.00,0.00,0.00,1.00,110.00,'2023-01-23 11:31:17','',''),(1281,'1','308','1',1,'Retail Sale Id 1344',1998.00,0.00,0.00,2.70,297.00,'2023-01-23 11:56:44','',''),(1282,'1','308','1',1,'Retail Sale Id 1345',740.00,0.00,0.00,1.00,110.00,'2023-01-23 11:58:00','',''),(1283,'1','308','1',1,'Retail Sale Id 1346',1480.00,0.00,0.00,2.00,220.00,'2023-01-23 12:04:08','',''),(1284,'1','308','1',1,'Retail Sale Id 1347',1502.20,0.00,0.00,2.03,223.30,'2023-01-23 12:52:51','',''),(1285,'1','308','1',1,'Retail Sale Id 1348',2220.00,0.00,0.00,3.00,330.00,'2023-01-23 12:55:53','',''),(1286,'1','308','1',1,'Retail Sale Id 1349',2220.00,0.00,0.00,3.00,330.00,'2023-01-23 13:52:43','',''),(1287,'1','308','1',1,'Retail Sale Id 1350',999.00,0.00,0.00,1.35,148.50,'2023-01-23 14:07:58','',''),(1288,'1','308','1',1,'Retail Sale Id 1351',503.20,0.00,0.00,0.68,74.80,'2023-01-23 14:09:22','',''),(1289,'1','308','1',1,'Retail Sale Id 1352',4440.00,0.00,0.00,6.00,660.00,'2023-01-23 14:31:26','',''),(1290,'1','308','1',1,'Retail Sale Id 1354',4440.00,0.00,0.00,6.00,660.00,'2023-01-23 14:58:43','',''),(1291,'1','308','1',1,'Retail Sale Id 1355',2220.00,0.00,0.00,3.00,330.00,'2023-01-23 15:51:03','',''),(1292,'1','308','1',1,'Retail Sale Id 1356',2597.40,0.00,0.00,3.51,386.10,'2023-01-23 16:07:55','',''),(1293,'1','308','1',1,'Retail Sale Id 1357',1502.20,0.00,0.00,2.03,223.30,'2023-01-23 16:13:32','',''),(1294,'1','308','1',1,'Retail Sale Id 1358',1480.00,0.00,0.00,2.00,220.00,'2023-01-23 16:19:01','',''),(1295,'1','308','1',1,'Retail Sale Id 1359',3700.00,0.00,0.00,5.00,550.00,'2023-01-23 16:32:03','',''),(1296,'1','308','1',1,'Retail Sale Id 1360',2220.00,0.00,0.00,3.00,330.00,'2023-01-23 16:38:09','',''),(1297,'1','308','1',1,'Retail Sale Id 1361',2220.00,0.00,0.00,3.00,330.00,'2023-01-23 16:41:41','',''),(1298,'1','308','1',1,'Retail Sale Id 1362',2227.40,0.00,0.00,3.01,331.10,'2023-01-23 16:44:52','',''),(1299,'1','308','1',1,'Retail Sale Id 1363',1480.00,0.00,0.00,2.00,220.00,'2023-01-23 16:48:19','',''),(1300,'1','308','1',1,'Retail Sale Id 1364',1480.00,0.00,0.00,2.00,220.00,'2023-01-23 16:57:08','',''),(1301,'1','308','1',1,'Retail Sale Id 1365',1502.20,0.00,0.00,2.03,223.30,'2023-01-23 17:06:38','',''),(1302,'1','308','1',1,'Retail Sale Id 1366',9250.00,0.00,0.00,12.50,1375.00,'2023-01-23 17:19:18','',''),(1303,'1','308','1',1,'Retail Sale Id 1367',1502.20,0.00,0.00,2.03,223.30,'2023-01-23 17:21:01','',''),(1304,'1','308','1',1,'Retail Sale Id 1369',1998.00,0.00,0.00,2.70,297.00,'2023-01-23 17:30:12','',''),(1305,'1','308','1',1,'Retail Sale Id 1370',747.40,0.00,0.00,1.01,111.10,'2023-01-23 17:35:05','',''),(1306,'1','308','1',1,'Retail Sale Id 1371',2197.80,0.00,0.00,2.97,326.70,'2023-01-23 17:38:35','',''),(1307,'1','308','1',1,'Retail Sale Id 1372',4440.00,0.00,0.00,6.00,660.00,'2023-01-23 17:47:52','',''),(1308,'1','308','1',1,'Retail Sale Id 1373',2249.60,0.00,0.00,3.04,334.40,'2023-01-23 17:50:05','',''),(1309,'1','308','1',1,'Retail Sale Id 1374',4440.00,0.00,0.00,6.00,660.00,'2023-01-23 17:54:00','',''),(1310,'1','308','1',1,'Retail Sale Id 1376',3700.00,0.00,0.00,5.00,550.00,'2023-01-23 17:59:20','',''),(1311,'1','308','1',1,'Retail Sale Id 1378',2197.80,0.00,0.00,2.97,326.70,'2023-01-23 18:04:27','',''),(1312,'1','308','1',1,'Retail Sale Id 1379',747.40,0.00,0.00,1.01,111.10,'2023-01-23 18:05:51','',''),(1313,'1','308','1',1,'Retail Sale Id 1380',5180.00,0.00,0.00,7.00,770.00,'2023-01-23 18:07:31','',''),(1314,'1','308','1',1,'Retail Sale Id 1381',1480.00,0.00,0.00,2.00,220.00,'2023-01-23 18:19:56','',''),(1315,'1','308','1',1,'Retail Sale Id 1382',2249.60,0.00,0.00,3.04,334.40,'2023-01-23 18:33:48','',''),(1316,'1','308','1',1,'Retail Sale Id 1383',9250.00,0.00,0.00,12.50,1375.00,'2023-01-23 18:35:17','',''),(1317,'1','308','1',1,'Retail Sale Id 1384',2220.00,0.00,0.00,3.00,330.00,'2023-01-23 18:36:26','',''),(1318,'1','308','1',1,'Retail Sale Id 1385',2220.00,0.00,0.00,3.00,330.00,'2023-01-23 18:38:51','',''),(1319,'1','308','1',1,'Retail Sale Id 1386',2220.00,0.00,0.00,3.00,330.00,'2023-01-23 18:45:39','',''),(1320,'1','308','1',1,'Retail Sale Id 1387',4380.80,0.00,0.00,5.92,651.20,'2023-01-23 19:14:47','',''),(1321,'1','308','1',1,'Retail Sale Id 1388',9250.00,0.00,0.00,12.50,1375.00,'2023-01-24 07:27:09','',''),(1322,'1','308','1',1,'Retail Sale Id 1389',4440.00,0.00,0.00,6.00,660.00,'2023-01-24 07:41:12','',''),(1323,'1','308','1',1,'Retail Sale Id 1390',1502.20,0.00,0.00,2.03,223.30,'2023-01-24 07:56:25','',''),(1324,'1','308','1',1,'Retail Sale Id 1391',2220.00,0.00,0.00,3.00,330.00,'2023-01-24 08:03:26','',''),(1325,'1','308','1',1,'Retail Sale Id 1392',1502.20,0.00,0.00,2.03,223.30,'2023-01-24 08:21:00','',''),(1326,'1','308','1',1,'Retail Sale Id 1393',1502.20,0.00,0.00,2.03,223.30,'2023-01-24 08:33:27','',''),(1327,'1','308','1',1,'Retail Sale Id 1394',4440.00,0.00,0.00,6.00,660.00,'2023-01-24 08:42:54','',''),(1328,'1','308','1',1,'Retail Sale Id 1395',2197.80,0.00,0.00,2.97,326.70,'2023-01-24 09:11:17','',''),(1329,'1','308','1',1,'Retail Sale Id 1396',42000.00,0.00,0.00,60.00,4200.00,'2023-01-24 09:57:52','',''),(1330,'1','308','1',1,'Retail Sale Id 1397',3700.00,0.00,0.00,5.00,550.00,'2023-01-24 10:32:38','',''),(1331,'1','308','1',1,'Retail Sale Id 1398',2960.00,0.00,0.00,4.00,440.00,'2023-01-24 10:48:10','',''),(1332,'1','308','1',1,'Retail Sale Id 1399',3700.00,0.00,0.00,5.00,550.00,'2023-01-24 11:08:26','',''),(1333,'1','308','1',1,'Retail Sale Id 1400',2997.00,0.00,0.00,4.05,445.50,'2023-01-24 11:13:04','',''),(1334,'1','308','1',1,'Retail Sale Id 1401',3700.00,0.00,0.00,5.00,550.00,'2023-01-24 11:42:14','',''),(1335,'1','308','1',1,'Retail Sale Id 1402',2997.00,0.00,0.00,4.05,445.50,'2023-01-24 11:51:04','',''),(1336,'1','308','1',1,'Retail Sale Id 1403',1502.20,0.00,0.00,2.03,223.30,'2023-01-24 11:58:27','',''),(1337,'1','308','1',1,'Retail Sale Id 1404',9250.00,0.00,0.00,12.50,1375.00,'2023-01-24 12:09:02','',''),(1338,'1','308','1',1,'Retail Sale Id 1405',2220.00,0.00,0.00,3.00,330.00,'2023-01-24 12:14:58','',''),(1339,'1','308','1',1,'Retail Sale Id 1406',503.20,0.00,0.00,0.68,74.80,'2023-01-24 12:49:54','',''),(1340,'1','308','1',1,'Retail Sale Id 1407',1502.20,0.00,0.00,2.03,223.30,'2023-01-24 13:34:31','',''),(1341,'1','308','1',1,'Retail Sale Id 1408',2220.00,0.00,0.00,3.00,330.00,'2023-01-24 13:36:20','',''),(1342,'1','308','1',1,'Retail Sale Id 1409',1502.20,0.00,0.00,2.03,223.30,'2023-01-24 14:06:14','',''),(1343,'1','308','1',1,'Retail Sale Id 1410',2220.00,0.00,0.00,3.00,330.00,'2023-01-24 14:11:52','',''),(1344,'1','308','1',1,'Retail Sale Id 1411',2220.00,0.00,0.00,3.00,330.00,'2023-01-24 14:35:36','',''),(1345,'1','308','1',1,'Retail Sale Id 1412',4447.40,0.00,0.00,6.01,661.10,'2023-01-24 14:38:55','',''),(1346,'1','308','1',1,'Retail Sale Id 1413',8880.00,0.00,0.00,12.00,1320.00,'2023-01-24 14:49:55','',''),(1347,'1','308','1',1,'Retail Sale Id 1414',799.20,0.00,0.00,1.08,118.80,'2023-01-24 15:16:30','',''),(1348,'1','308','1',1,'Retail Sale Id 1415',1502.20,0.00,0.00,2.03,223.30,'2023-01-24 15:30:33','',''),(1349,'1','308','1',1,'Retail Sale Id 1416',999.00,0.00,0.00,1.35,148.50,'2023-01-24 15:49:53','',''),(1350,'1','308','1',1,'Retail Sale Id 1417',4447.40,0.00,0.00,6.01,661.10,'2023-01-24 16:24:31','',''),(1351,'1','308','1',1,'Retail Sale Id 1418',2960.00,0.00,0.00,4.00,440.00,'2023-01-24 16:43:00','',''),(1352,'1','308','1',1,'Retail Sale Id 1419',1502.20,0.00,0.00,2.03,223.30,'2023-01-24 16:51:08','',''),(1353,'1','308','1',1,'Retail Sale Id 1420',740.00,0.00,0.00,1.00,110.00,'2023-01-24 16:56:37','',''),(1354,'1','308','1',1,'Retail Sale Id 1421',2220.00,0.00,0.00,3.00,330.00,'2023-01-24 17:00:58','',''),(1355,'1','308','1',1,'Retail Sale Id 1422',1480.00,0.00,0.00,2.00,220.00,'2023-01-24 17:03:57','',''),(1356,'1','308','1',1,'Retail Sale Id 1423',740.00,0.00,0.00,1.00,110.00,'2023-01-24 17:05:15','',''),(1357,'1','308','1',1,'Retail Sale Id 1424',2960.00,0.00,0.00,4.00,440.00,'2023-01-24 17:09:54','',''),(1358,'1','308','1',1,'Retail Sale Id 1425',2197.80,0.00,0.00,2.97,326.70,'2023-01-24 17:21:06','',''),(1359,'1','308','1',1,'Retail Sale Id 1426',1502.20,0.00,0.00,2.03,223.30,'2023-01-24 17:29:42','',''),(1360,'1','308','1',1,'Retail Sale Id 1427',1502.20,0.00,0.00,2.03,223.30,'2023-01-24 17:32:34','',''),(1361,'1','308','1',1,'Retail Sale Id 1428',3700.00,0.00,0.00,5.00,550.00,'2023-01-24 17:34:31','',''),(1362,'1','308','1',1,'Retail Sale Id 1429',28000.00,0.00,0.00,40.00,2800.00,'2023-01-24 17:41:31','',''),(1363,'1','308','1',1,'Retail Sale Id 1430',2952.60,0.00,0.00,3.99,438.90,'2023-01-24 17:51:37','',''),(1364,'1','308','1',1,'Retail Sale Id 1431',740.00,0.00,0.00,1.00,110.00,'2023-01-24 17:54:35','',''),(1365,'1','308','1',1,'Retail Sale Id 1432',1487.40,0.00,0.00,2.01,221.10,'2023-01-24 18:00:44','',''),(1366,'1','308','1',1,'Retail Sale Id 1433',1502.20,0.00,0.00,2.03,223.30,'2023-01-24 18:07:17','',''),(1367,'1','308','1',1,'Retail Sale Id 1434',2997.00,0.00,0.00,4.05,445.50,'2023-01-24 18:19:33','',''),(1368,'1','308','1',1,'Retail Sale Id 1435',2220.00,0.00,0.00,3.00,330.00,'2023-01-24 18:25:54','',''),(1369,'1','308','1',1,'Retail Sale Id 1436',902.80,0.00,0.00,1.22,134.20,'2023-01-24 18:28:01','',''),(1370,'1','308','1',1,'Retail Sale Id 1437',4447.40,0.00,0.00,6.01,661.10,'2023-01-24 18:33:33','',''),(1371,'1','308','1',1,'Retail Sale Id 1438',1502.20,0.00,0.00,2.03,223.30,'2023-01-24 18:34:35','',''),(1372,'1','308','1',1,'Retail Sale Id 1439',3011.80,0.00,0.00,4.07,447.70,'2023-01-24 19:28:13','',''),(1373,'1','308','1',1,'Retail Sale Id 1440',2997.00,0.00,0.00,4.05,445.50,'2023-01-25 07:33:20','',''),(1374,'1','308','1',1,'Retail Sale Id 1441',740.00,0.00,0.00,1.00,110.00,'2023-01-25 07:42:46','',''),(1375,'1','308','1',1,'Retail Sale Id 1442',762.20,0.00,0.00,1.03,113.30,'2023-01-25 07:45:24','',''),(1376,'1','308','1',1,'Retail Sale Id 1443',750.00,0.00,0.00,1.00,120.00,'2023-01-25 08:00:44','',''),(1377,'1','308','1',1,'Retail Sale Id 1444',2997.00,0.00,0.00,4.05,445.50,'2023-01-25 08:04:22','',''),(1378,'1','308','1',1,'Retail Sale Id 1445',2220.00,0.00,0.00,3.00,330.00,'2023-01-25 08:24:29','',''),(1379,'1','308','1',1,'Retail Sale Id 1446',3700.00,0.00,0.00,5.00,550.00,'2023-01-25 08:58:44','',''),(1380,'1','308','1',1,'Retail Sale Id 1447',1798.20,0.00,0.00,2.43,267.30,'2023-01-25 09:07:45','',''),(1381,'1','308','1',1,'Retail Sale Id 1448',2982.20,0.00,0.00,4.03,443.30,'2023-01-25 09:09:37','',''),(1382,'1','308','1',1,'Retail Sale Id 1449',3700.00,0.00,0.00,5.00,550.00,'2023-01-25 09:54:56','',''),(1383,'1','308','1',1,'Retail Sale Id 1450',4447.40,0.00,0.00,6.01,661.10,'2023-01-25 10:12:45','',''),(1384,'1','308','1',1,'Retail Sale Id 1451',1480.00,0.00,0.00,2.00,220.00,'2023-01-25 10:41:52','',''),(1385,'1','308','1',1,'Retail Sale Id 1452',1502.20,0.00,0.00,2.03,223.30,'2023-01-25 10:44:23','',''),(1386,'1','308','1',1,'Retail Sale Id 1453',2101.60,0.00,0.00,2.84,312.40,'2023-01-25 10:46:08','',''),(1387,'1','308','1',1,'Retail Sale Id 1454',2220.00,0.00,0.00,3.00,330.00,'2023-01-25 10:47:16','',''),(1388,'1','308','1',1,'Retail Sale Id 1455',999.00,0.00,0.00,1.35,148.50,'2023-01-25 11:46:17','',''),(1389,'1','308','1',1,'Retail Sale Id 1456',999.00,0.00,0.00,1.35,148.50,'2023-01-25 14:06:03','',''),(1390,'1','308','1',1,'Retail Sale Id 1457',4440.00,0.00,0.00,6.00,660.00,'2023-01-25 14:40:09','',''),(1391,'1','308','1',1,'Retail Sale Id 1458',2960.00,0.00,0.00,4.00,440.00,'2023-01-25 14:42:39','',''),(1392,'1','308','1',1,'Retail Sale Id 1459',3700.00,0.00,0.00,5.00,550.00,'2023-01-25 14:55:55','',''),(1393,'1','308','1',1,'Retail Sale Id 1460',1502.20,0.00,0.00,2.03,223.30,'2023-01-25 15:29:36','',''),(1394,'1','308','1',1,'Retail Sale Id 1461',747.40,0.00,0.00,1.01,111.10,'2023-01-25 15:53:02','',''),(1395,'1','308','1',1,'Retail Sale Id 1462',999.00,0.00,0.00,1.35,148.50,'2023-01-25 15:53:58','',''),(1396,'1','308','1',1,'Retail Sale Id 1463',4447.40,0.00,0.00,6.01,661.10,'2023-01-25 16:04:24','',''),(1397,'1','308','1',1,'Retail Sale Id 1464',2960.00,0.00,0.00,4.00,440.00,'2023-01-25 16:20:05','',''),(1398,'1','308','1',1,'Retail Sale Id 1465',8902.20,0.00,0.00,12.03,1323.30,'2023-01-25 16:22:46','',''),(1399,'1','308','1',1,'Retail Sale Id 1466',3700.00,0.00,0.00,5.00,550.00,'2023-01-25 16:28:28','',''),(1400,'1','308','1',1,'Retail Sale Id 1467',2960.00,0.00,0.00,4.00,440.00,'2023-01-25 16:44:03','',''),(1401,'1','308','1',1,'Retail Sale Id 1468',3700.00,0.00,0.00,5.00,550.00,'2023-01-25 16:46:12','',''),(1402,'1','308','1',1,'Retail Sale Id 1469',3700.00,0.00,0.00,5.00,550.00,'2023-01-25 16:50:20','',''),(1403,'1','308','1',1,'Retail Sale Id 1470',2960.00,0.00,0.00,4.00,440.00,'2023-01-25 16:54:03','',''),(1404,'1','308','1',1,'Retail Sale Id 1471',1502.20,0.00,0.00,2.03,223.30,'2023-01-25 16:59:02','',''),(1405,'1','308','1',1,'Retail Sale Id 1472',3700.00,0.00,0.00,5.00,550.00,'2023-01-25 17:01:45','',''),(1406,'1','308','1',1,'Retail Sale Id 1473',1502.20,0.00,0.00,2.03,223.30,'2023-01-25 17:06:42','',''),(1407,'1','308','1',1,'Retail Sale Id 1474',1502.20,0.00,0.00,2.03,223.30,'2023-01-25 17:16:37','',''),(1408,'1','308','1',1,'Retail Sale Id 1475',9250.00,0.00,0.00,12.50,1375.00,'2023-01-25 17:21:47','',''),(1409,'1','308','1',1,'Retail Sale Id 1476',70000.00,0.00,0.00,100.00,7000.00,'2023-01-25 17:26:07','',''),(1410,'1','308','1',1,'Retail Sale Id 1477',2220.00,0.00,0.00,3.00,330.00,'2023-01-25 17:35:11','',''),(1411,'1','308','1',1,'Retail Sale Id 1478',2249.60,0.00,0.00,3.04,334.40,'2023-01-25 17:41:25','',''),(1412,'1','308','1',1,'Retail Sale Id 1479',2301.40,0.00,0.00,3.11,342.10,'2023-01-25 17:48:30','',''),(1413,'1','308','1',1,'Retail Sale Id 1480',1502.20,0.00,0.00,2.03,223.30,'2023-01-25 17:50:45','',''),(1414,'1','308','1',1,'Retail Sale Id 1481',3700.00,0.00,0.00,5.00,550.00,'2023-01-25 17:51:55','',''),(1415,'1','308','1',1,'Retail Sale Id 1482',22251.80,0.00,0.00,30.07,3307.70,'2023-01-25 18:16:45','',''),(1416,'1','308','1',1,'Return of Retail Sale Id 1482',0.00,22251.80,30.07,0.00,-3307.70,'2023-01-25 18:25:44','',''),(1417,'1','308','1',1,'Retail Sale Id 1483',2960.00,0.00,0.00,4.00,440.00,'2023-01-25 18:27:08','',''),(1418,'1','308','1',1,'Return of Retail Sale Id 1483',0.00,2960.00,4.00,0.00,-440.00,'2023-01-25 18:27:36','',''),(1419,'1','308','1',1,'Retail Sale Id 1484',2900.80,0.00,0.00,3.92,431.20,'2023-01-25 18:28:24','',''),(1420,'1','308','1',1,'Retail Sale Id 1485',2249.60,0.00,0.00,3.04,334.40,'2023-01-25 18:29:30','',''),(1421,'1','308','1',1,'Retail Sale Id 1486',2960.00,0.00,0.00,4.00,440.00,'2023-01-25 18:32:47','',''),(1422,'1','308','1',1,'Retail Sale Id 1487',2671.40,0.00,0.00,3.61,397.10,'2023-01-25 19:11:29','',''),(1423,'1','308','1',1,'Retail Sale Id 1488',1502.20,0.00,0.00,2.03,223.30,'2023-01-26 07:55:06','',''),(1424,'1','308','1',1,'Retail Sale Id 1489',2997.00,0.00,0.00,4.05,445.50,'2023-01-26 08:02:34','',''),(1425,'1','308','1',1,'Retail Sale Id 1490',3700.00,0.00,0.00,5.00,550.00,'2023-01-26 08:14:30','',''),(1426,'1','308','1',1,'Retail Sale Id 1491',9250.00,0.00,0.00,12.50,1375.00,'2023-01-26 08:22:29','',''),(1427,'1','308','1',1,'Retail Sale Id 1492',4447.40,0.00,0.00,6.01,661.10,'2023-01-26 08:31:28','',''),(1428,'1','308','1',1,'Retail Sale Id 1493',4499.20,0.00,0.00,6.08,668.80,'2023-01-26 08:45:55','',''),(1429,'1','308','1',1,'Retail Sale Id 1494',2997.00,0.00,0.00,4.05,445.50,'2023-01-26 09:02:23','',''),(1430,'1','308','1',1,'Retail Sale Id 1495',2960.00,0.00,0.00,4.00,440.00,'2023-01-26 09:04:34','',''),(1431,'1','308','1',1,'Retail Sale Id 1496',2242.20,0.00,0.00,3.03,333.30,'2023-01-26 09:06:47','',''),(1432,'1','308','1',1,'Retail Sale Id 1497',1502.20,0.00,0.00,2.03,223.30,'2023-01-26 09:18:59','',''),(1433,'1','308','1',1,'Retail Sale Id 1498',1502.20,0.00,0.00,2.03,223.30,'2023-01-26 10:01:27','',''),(1434,'1','308','1',1,'Retail Sale Id 1499',4447.40,0.00,0.00,6.01,661.10,'2023-01-26 10:09:26','',''),(1435,'1','308','1',1,'Retail Sale Id 1500',1502.20,0.00,0.00,2.03,223.30,'2023-01-26 10:18:08','',''),(1436,'1','308','1',1,'Retail Sale Id 1502',2249.60,0.00,0.00,3.04,334.40,'2023-01-26 10:56:53','',''),(1437,'1','308','1',1,'Retail Sale Id 1503',4447.40,0.00,0.00,6.01,661.10,'2023-01-26 10:58:59','',''),(1438,'1','308','1',1,'Retail Sale Id 1504',4447.40,0.00,0.00,6.01,661.10,'2023-01-26 11:23:18','',''),(1439,'1','308','1',1,'Retail Sale Id 1505',999.00,0.00,0.00,1.35,148.50,'2023-01-26 12:54:22','',''),(1440,'1','308','1',1,'Retail Sale Id 1506',999.00,0.00,0.00,1.35,148.50,'2023-01-26 12:55:45','',''),(1441,'1','308','1',1,'Retail Sale Id 1507',1502.20,0.00,0.00,2.03,223.30,'2023-01-26 13:17:27','',''),(1442,'1','308','1',1,'Retail Sale Id 1508',3700.00,0.00,0.00,5.00,550.00,'2023-01-26 13:35:58','',''),(1443,'1','308','1',1,'Retail Sale Id 1509',1502.20,0.00,0.00,2.03,223.30,'2023-01-26 14:22:56','',''),(1444,'1','308','1',1,'Retail Sale Id 1510',4447.40,0.00,0.00,6.01,661.10,'2023-01-26 14:25:14','',''),(1445,'1','308','1',1,'Retail Sale Id 1511',21000.00,0.00,0.00,30.00,2100.00,'2023-01-26 14:42:44','',''),(1446,'1','308','1',1,'Retail Sale Id 1512',2249.60,0.00,0.00,3.04,334.40,'2023-01-26 15:08:50','',''),(1447,'1','308','1',1,'Retail Sale Id 1513',4440.00,0.00,0.00,6.00,660.00,'2023-01-26 15:16:52','',''),(1448,'1','308','1',1,'Retail Sale Id 1514',799.20,0.00,0.00,1.08,118.80,'2023-01-26 15:19:20','',''),(1449,'1','308','1',1,'Retail Sale Id 1515',747.40,0.00,0.00,1.01,111.10,'2023-01-26 15:26:39','',''),(1450,'1','308','1',1,'Retail Sale Id 1516',2960.00,0.00,0.00,4.00,440.00,'2023-01-26 15:29:54','',''),(1451,'1','308','1',1,'Retail Sale Id 1517',3700.00,0.00,0.00,5.00,550.00,'2023-01-26 15:57:54','',''),(1452,'1','308','1',1,'Retail Sale Id 1518',2960.00,0.00,0.00,4.00,440.00,'2023-01-26 16:00:38','',''),(1453,'1','308','1',1,'Retail Sale Id 1519',999.00,0.00,0.00,1.35,148.50,'2023-01-26 16:12:05','',''),(1454,'1','308','1',1,'Retail Sale Id 1520',747.40,0.00,0.00,1.01,111.10,'2023-01-26 16:13:48','',''),(1455,'1','308','1',1,'Retail Sale Id 1521',1850.00,0.00,0.00,2.50,275.00,'2023-01-26 16:30:19','',''),(1456,'1','308','1',1,'Retail Sale Id 1522',9250.00,0.00,0.00,12.50,1375.00,'2023-01-26 16:40:38','',''),(1457,'1','308','1',1,'Retail Sale Id 1523',2220.00,0.00,0.00,3.00,330.00,'2023-01-26 16:44:47','',''),(1458,'1','308','1',1,'Retail Sale Id 1524',1502.20,0.00,0.00,2.03,223.30,'2023-01-26 17:19:10','',''),(1459,'1','308','1',1,'Retail Sale Id 1525',1502.20,0.00,0.00,2.03,223.30,'2023-01-26 17:27:09','',''),(1460,'1','308','1',1,'Retail Sale Id 1526',3700.00,0.00,0.00,5.00,550.00,'2023-01-26 17:34:51','',''),(1461,'1','308','1',1,'Retail Sale Id 1527',1502.20,0.00,0.00,2.03,223.30,'2023-01-26 17:39:05','',''),(1462,'1','308','1',1,'Retail Sale Id 1528',1480.00,0.00,0.00,2.00,220.00,'2023-01-26 17:40:33','',''),(1463,'1','308','1',1,'Retail Sale Id 1529',1502.20,0.00,0.00,2.03,223.30,'2023-01-26 18:08:39','',''),(1464,'1','308','1',1,'Retail Sale Id 1530',2960.00,0.00,0.00,4.00,440.00,'2023-01-26 18:21:34','',''),(1465,'1','308','1',1,'Retail Sale Id 1531',2197.80,0.00,0.00,2.97,326.70,'2023-01-26 18:24:11','',''),(1466,'1','308','1',1,'Retail Sale Id 1532',2220.00,0.00,0.00,3.00,330.00,'2023-01-26 18:39:07','',''),(1467,'1','308','1',1,'Retail Sale Id 1534',1480.00,0.00,0.00,2.00,220.00,'2023-01-26 18:40:45','',''),(1468,'1','308','1',1,'Retail Sale Id 1535',2997.00,0.00,0.00,4.05,445.50,'2023-01-26 18:43:41','',''),(1469,'1','308','1',1,'Retail Sale Id 1536',1398.60,0.00,0.00,1.89,207.90,'2023-01-26 19:37:48','',''),(1470,'1','308','1',1,'Retail Sale Id 1537',1398.60,0.00,0.00,1.89,207.90,'2023-01-27 07:25:01','',''),(1471,'1','308','1',1,'Retail Sale Id 1538',999.00,0.00,0.00,1.35,148.50,'2023-01-27 07:27:29','',''),(1472,'1','308','1',1,'Retail Sale Id 1539',999.00,0.00,0.00,1.35,148.50,'2023-01-27 07:45:27','',''),(1473,'1','308','1',1,'Retail Sale Id 1540',2249.60,0.00,0.00,3.04,334.40,'2023-01-27 07:59:59','',''),(1474,'1','308','1',1,'Retail Sale Id 1541',1998.00,0.00,0.00,2.70,297.00,'2023-01-27 08:11:17','',''),(1475,'1','308','1',1,'Retail Sale Id 1542',1398.60,0.00,0.00,1.89,207.90,'2023-01-27 08:12:25','',''),(1476,'1','308','1',1,'Retail Sale Id 1543',43400.00,0.00,0.00,62.00,4340.00,'2023-01-27 08:22:47','',''),(1477,'1','308','1',1,'Retail Sale Id 1544',9250.00,0.00,0.00,12.50,1375.00,'2023-01-27 08:40:51','',''),(1478,'1','308','1',1,'Retail Sale Id 1545',2220.00,0.00,0.00,3.00,330.00,'2023-01-27 08:58:11','',''),(1479,'1','308','1',1,'Retail Sale Id 1546',2997.00,0.00,0.00,4.05,445.50,'2023-01-27 09:36:06','',''),(1480,'1','308','1',1,'Retail Sale Id 1547',4447.40,0.00,0.00,6.01,661.10,'2023-01-27 09:41:02','',''),(1481,'1','308','1',1,'Retail Sale Id 1548',1480.00,0.00,0.00,2.00,220.00,'2023-01-27 10:06:01','',''),(1482,'1','308','1',1,'Retail Sale Id 1549',2249.60,0.00,0.00,3.04,334.40,'2023-01-27 10:17:40','',''),(1483,'1','308','1',1,'Retail Sale Id 1550',2220.00,0.00,0.00,3.00,330.00,'2023-01-27 10:19:07','',''),(1484,'1','308','1',1,'Retail Sale Id 1551',1502.20,0.00,0.00,2.03,223.30,'2023-01-27 11:17:11','',''),(1485,'1','308','1',1,'Retail Sale Id 1552',4447.40,0.00,0.00,6.01,661.10,'2023-01-27 11:18:51','',''),(1486,'1','308','1',1,'Retail Sale Id 1553',4440.00,0.00,0.00,6.00,660.00,'2023-01-27 11:20:10','',''),(1487,'1','308','1',1,'Retail Sale Id 1554',1480.00,0.00,0.00,2.00,220.00,'2023-01-27 11:41:31','',''),(1488,'1','308','1',1,'Retail Sale Id 1555',747.40,0.00,0.00,1.01,111.10,'2023-01-27 12:07:29','',''),(1489,'1','308','1',1,'Retail Sale Id 1556',1998.00,0.00,0.00,2.70,297.00,'2023-01-27 12:34:29','',''),(1490,'1','308','1',1,'Retail Sale Id 1557',1480.00,0.00,0.00,2.00,220.00,'2023-01-27 12:42:04','',''),(1491,'1','308','1',1,'Retail Sale Id 1558',747.40,0.00,0.00,1.01,111.10,'2023-01-27 12:47:19','',''),(1492,'1','308','1',1,'Retail Sale Id 1559',2997.00,0.00,0.00,4.05,445.50,'2023-01-27 12:49:24','',''),(1493,'1','308','1',1,'Retail Sale Id 1560',7400.00,0.00,0.00,10.00,1100.00,'2023-01-27 13:04:24','',''),(1494,'1','308','1',1,'Retail Sale Id 1561',2197.80,0.00,0.00,2.97,326.70,'2023-01-27 13:20:14','',''),(1495,'1','308','1',1,'Retail Sale Id 1562',747.40,0.00,0.00,1.01,111.10,'2023-01-27 13:22:55','',''),(1496,'1','308','1',1,'Retail Sale Id 1563',4802.60,0.00,0.00,6.49,713.90,'2023-01-27 13:31:05','',''),(1497,'1','308','1',1,'Retail Sale Id 1564',2220.00,0.00,0.00,3.00,330.00,'2023-01-27 13:40:53','',''),(1498,'1','308','1',1,'Retail Sale Id 1565',1502.20,0.00,0.00,2.03,223.30,'2023-01-27 14:19:19','',''),(1499,'1','308','1',1,'Retail Sale Id 1566',5202.20,0.00,0.00,7.03,773.30,'2023-01-27 14:29:49','',''),(1500,'1','308','1',1,'Retail Sale Id 1567',1502.20,0.00,0.00,2.03,223.30,'2023-01-27 15:52:46','',''),(1501,'1','308','1',1,'Retail Sale Id 1568',747.40,0.00,0.00,1.01,111.10,'2023-01-27 16:11:36','',''),(1502,'1','308','1',1,'Retail Sale Id 1569',1480.00,0.00,0.00,2.00,220.00,'2023-01-27 17:00:49','',''),(1503,'1','308','1',1,'Retail Sale Id 1570',747.40,0.00,0.00,1.01,111.10,'2023-01-27 18:00:26','',''),(1504,'1','308','1',1,'Retail Sale Id 1571',747.40,0.00,0.00,1.01,111.10,'2023-01-27 18:07:21','',''),(1505,'1','308','1',1,'Return of Retail Sale Id 1543',0.00,43400.00,62.00,0.00,-4340.00,'2023-01-27 18:31:17','',''),(1506,'1','308','1',1,'Retail Sale Id 1572',43204.00,0.00,0.00,61.72,4320.40,'2023-01-27 18:32:18','',''),(1507,'1','308','1',1,'Return of Retail Sale Id 1555',0.00,747.40,1.01,0.00,-111.10,'2023-01-27 18:33:08','',''),(1508,'1','308','1',1,'Retail Sale Id 1573',732.60,0.00,0.00,0.99,108.90,'2023-01-27 18:33:49','',''),(1509,'1','308','1',1,'Retail Sale Id 1574',3700.00,0.00,0.00,5.00,550.00,'2023-01-28 07:51:14','',''),(1510,'1','308','1',1,'Retail Sale Id 1575',2997.00,0.00,0.00,4.05,445.50,'2023-01-28 08:01:46','',''),(1511,'1','308','1',1,'Retail Sale Id 1576',2997.00,0.00,0.00,4.05,445.50,'2023-01-28 08:03:55','',''),(1512,'1','308','1',1,'Retail Sale Id 1577',1998.00,0.00,0.00,2.70,297.00,'2023-01-28 08:11:04','',''),(1513,'1','308','1',1,'Retail Sale Id 1578',2249.60,0.00,0.00,3.04,334.40,'2023-01-28 08:14:35','',''),(1514,'1','308','1',1,'Retail Sale Id 1579',747.40,0.00,0.00,1.01,111.10,'2023-01-28 08:28:30','',''),(1515,'1','308','1',1,'Retail Sale Id 1580',31500.00,0.00,0.00,45.00,3150.00,'2023-01-28 08:33:29','',''),(1516,'1','308','1',1,'Retail Sale Id 1581',2220.00,0.00,0.00,3.00,330.00,'2023-01-28 08:35:00','',''),(1517,'1','308','1',1,'Retail Sale Id 1582',1480.00,0.00,0.00,2.00,220.00,'2023-01-28 08:36:19','',''),(1518,'1','308','1',1,'Retail Sale Id 1583',4440.00,0.00,0.00,6.00,660.00,'2023-01-28 08:40:38','',''),(1519,'1','308','1',1,'Retail Sale Id 1584',1502.20,0.00,0.00,2.03,223.30,'2023-01-28 08:42:04','',''),(1520,'1','308','1',1,'Retail Sale Id 1585',747.40,0.00,0.00,1.01,111.10,'2023-01-28 08:43:20','',''),(1521,'1','308','1',1,'Retail Sale Id 1586',9250.00,0.00,0.00,12.50,1375.00,'2023-01-28 08:46:37','',''),(1522,'1','308','1',1,'Retail Sale Id 1587',1502.20,0.00,0.00,2.03,223.30,'2023-01-28 08:47:45','',''),(1523,'1','308','1',1,'Retail Sale Id 1588',1502.20,0.00,0.00,2.03,223.30,'2023-01-28 08:48:49','',''),(1524,'1','308','1',1,'Retail Sale Id 1589',1502.20,0.00,0.00,2.03,223.30,'2023-01-28 08:58:39','',''),(1525,'1','308','1',1,'Retail Sale Id 1590',2960.00,0.00,0.00,4.00,440.00,'2023-01-28 09:01:42','',''),(1526,'1','308','1',1,'Retail Sale Id 1591',4440.00,0.00,0.00,6.00,660.00,'2023-01-28 09:11:13','',''),(1527,'1','308','1',1,'Retail Sale Id 1592',3700.00,0.00,0.00,5.00,550.00,'2023-01-28 09:18:39','',''),(1528,'1','308','1',1,'Retail Sale Id 1593',2220.00,0.00,0.00,3.00,330.00,'2023-01-28 09:22:57','',''),(1529,'1','308','1',1,'Retail Sale Id 1594',747.40,0.00,0.00,1.01,111.10,'2023-01-28 10:56:10','',''),(1530,'1','308','1',1,'Retail Sale Id 1595',6660.00,0.00,0.00,9.00,990.00,'2023-01-28 11:09:04','',''),(1531,'1','308','1',1,'Retail Sale Id 1596',1502.20,0.00,0.00,2.03,223.30,'2023-01-28 11:20:18','',''),(1532,'1','308','1',1,'Retail Sale Id 1597',4440.00,0.00,0.00,6.00,660.00,'2023-01-28 12:36:12','',''),(1533,'1','308','1',1,'Retail Sale Id 1598',747.40,0.00,0.00,1.01,111.10,'2023-01-28 12:37:46','',''),(1534,'1','308','1',1,'Retail Sale Id 1599',2249.60,0.00,0.00,3.04,334.40,'2023-01-28 12:42:22','',''),(1535,'1','308','1',1,'Retail Sale Id 1600',799.20,0.00,0.00,1.08,118.80,'2023-01-28 12:50:48','',''),(1536,'1','308','1',1,'Retail Sale Id 1601',2701.00,0.00,0.00,3.65,401.50,'2023-01-28 13:17:06','',''),(1537,'1','308','1',1,'Retail Sale Id 1602',2997.00,0.00,0.00,4.05,445.50,'2023-01-28 13:34:49','',''),(1538,'1','308','1',1,'Retail Sale Id 1603',9250.00,0.00,0.00,12.50,1375.00,'2023-01-28 14:21:03','',''),(1539,'1','308','1',1,'Retail Sale Id 1604',9250.00,0.00,0.00,12.50,1375.00,'2023-01-28 14:23:20','',''),(1540,'1','308','1',1,'Retail Sale Id 1605',799.20,0.00,0.00,1.08,118.80,'2023-01-28 14:25:11','',''),(1541,'1','308','1',1,'Retail Sale Id 1606',2997.00,0.00,0.00,4.05,445.50,'2023-01-28 14:30:25','',''),(1542,'1','308','1',1,'Retail Sale Id 1607',1502.20,0.00,0.00,2.03,223.30,'2023-01-28 14:31:42','',''),(1543,'1','308','1',1,'Retail Sale Id 1608',799.20,0.00,0.00,1.08,118.80,'2023-01-28 14:32:59','',''),(1544,'1','308','1',1,'Retail Sale Id 1609',2249.60,0.00,0.00,3.04,334.40,'2023-01-28 14:51:08','',''),(1545,'1','308','1',1,'Retail Sale Id 1610',1502.20,0.00,0.00,2.03,223.30,'2023-01-28 15:10:32','',''),(1546,'1','308','1',1,'Retail Sale Id 1611',2220.00,0.00,0.00,3.00,330.00,'2023-01-28 15:13:20','',''),(1547,'1','308','1',1,'Retail Sale Id 1612',740.00,0.00,0.00,1.00,110.00,'2023-01-28 15:14:51','',''),(1548,'1','308','1',1,'Retail Sale Id 1613',1480.00,0.00,0.00,2.00,220.00,'2023-01-28 16:22:09','',''),(1549,'1','308','1',1,'Retail Sale Id 1614',3700.00,0.00,0.00,5.00,550.00,'2023-01-28 16:45:46','',''),(1550,'1','308','1',1,'Retail Sale Id 1615',3700.00,0.00,0.00,5.00,550.00,'2023-01-28 16:47:41','',''),(1551,'1','308','1',1,'Retail Sale Id 1616',7200.20,0.00,0.00,9.73,1070.30,'2023-01-28 16:58:13','',''),(1552,'1','308','1',1,'Retail Sale Id 1617',3700.00,0.00,0.00,5.00,550.00,'2023-01-28 17:00:52','',''),(1553,'1','308','1',1,'Retail Sale Id 1618',1480.00,0.00,0.00,2.00,220.00,'2023-01-28 17:17:52','',''),(1554,'1','308','1',1,'Retail Sale Id 1619',1502.20,0.00,0.00,2.03,223.30,'2023-01-28 17:19:56','',''),(1555,'1','308','1',1,'Retail Sale Id 1620',4003.40,0.00,0.00,5.41,595.10,'2023-01-28 17:47:01','',''),(1556,'1','308','1',1,'Retail Sale Id 1621',7400.00,0.00,0.00,10.00,1100.00,'2023-01-28 17:49:31','',''),(1557,'1','308','1',1,'Retail Sale Id 1622',9250.00,0.00,0.00,12.50,1375.00,'2023-01-28 17:51:26','',''),(1558,'1','308','1',1,'Retail Sale Id 1623',740.00,0.00,0.00,1.00,110.00,'2023-01-28 18:04:14','',''),(1559,'1','308','1',1,'Retail Sale Id 1624',2997.00,0.00,0.00,4.05,445.50,'2023-01-28 18:11:21','',''),(1560,'1','308','1',1,'Retail Sale Id 1625',3700.00,0.00,0.00,5.00,550.00,'2023-01-28 18:14:44','',''),(1561,'1','308','1',1,'Retail Sale Id 1626',2249.60,0.00,0.00,3.04,334.40,'2023-01-28 18:20:58','',''),(1562,'1','308','1',1,'Return of Retail Sale Id 1597',0.00,4440.00,6.00,0.00,-660.00,'2023-01-28 19:15:53','',''),(1563,'1','308','1',1,'Retail Sale Id 1627',518.00,0.00,0.00,0.70,77.00,'2023-01-28 19:17:42','',''),(1564,'1','308','1',1,'Retail Sale Id 1628',4440.00,0.00,0.00,6.00,660.00,'2023-01-29 07:30:07','',''),(1565,'1','308','1',1,'Retail Sale Id 1629',1502.20,0.00,0.00,2.03,223.30,'2023-01-29 07:48:47','',''),(1566,'1','308','1',1,'Retail Sale Id 1630',4440.00,0.00,0.00,6.00,660.00,'2023-01-29 07:51:11','',''),(1567,'1','308','1',1,'Retail Sale Id 1631',747.40,0.00,0.00,1.01,111.10,'2023-01-29 08:12:18','',''),(1568,'1','308','1',1,'Retail Sale Id 1632',1480.00,0.00,0.00,2.00,220.00,'2023-01-29 08:28:08','',''),(1569,'1','308','1',1,'Retail Sale Id 1633',3700.00,0.00,0.00,5.00,550.00,'2023-01-29 08:42:44','',''),(1570,'1','308','1',1,'Retail Sale Id 1634',747.40,0.00,0.00,1.01,111.10,'2023-01-29 08:46:47','',''),(1571,'1','308','1',1,'Retail Sale Id 1635',1502.20,0.00,0.00,2.03,223.30,'2023-01-29 09:08:12','',''),(1572,'1','308','1',1,'Retail Sale Id 1636',9250.00,0.00,0.00,12.50,1375.00,'2023-01-29 09:15:55','',''),(1573,'1','308','1',1,'Retail Sale Id 1637',2197.80,0.00,0.00,2.97,326.70,'2023-01-29 09:22:54','',''),(1574,'1','308','1',1,'Retail Sale Id 1638',2220.00,0.00,0.00,3.00,330.00,'2023-01-29 09:29:37','',''),(1575,'1','308','1',1,'Retail Sale Id 1639',3700.00,0.00,0.00,5.00,550.00,'2023-01-29 09:55:35','',''),(1576,'1','308','1',1,'Retail Sale Id 1640',1110.00,0.00,0.00,1.50,165.00,'2023-01-29 10:15:37','',''),(1577,'1','308','1',1,'Retail Sale Id 1641',1998.00,0.00,0.00,2.70,297.00,'2023-01-29 10:16:34','',''),(1578,'1','308','1',1,'Retail Sale Id 1642',999.00,0.00,0.00,1.35,148.50,'2023-01-29 10:21:07','',''),(1579,'1','308','1',1,'Retail Sale Id 1643',21000.00,0.00,0.00,30.00,2100.00,'2023-01-29 10:37:35','',''),(1580,'1','308','1',1,'Retail Sale Id 1644',1502.20,0.00,0.00,2.03,223.30,'2023-01-29 10:55:43','',''),(1581,'1','308','1',1,'Retail Sale Id 1645',2279.20,0.00,0.00,3.08,338.80,'2023-01-29 11:34:56','',''),(1582,'1','308','1',1,'Retail Sale Id 1646',2997.00,0.00,0.00,4.05,445.50,'2023-01-29 11:44:08','',''),(1583,'1','308','1',1,'Retail Sale Id 1647',1998.00,0.00,0.00,2.70,297.00,'2023-01-29 12:01:55','',''),(1584,'1','308','1',1,'Retail Sale Id 1648',4447.40,0.00,0.00,6.01,661.10,'2023-01-29 12:03:51','',''),(1585,'1','308','1',1,'Retail Sale Id 1649',2220.00,0.00,0.00,3.00,330.00,'2023-01-29 12:32:35','',''),(1586,'1','308','1',1,'Retail Sale Id 1650',1502.20,0.00,0.00,2.03,223.30,'2023-01-29 12:33:41','',''),(1587,'1','308','1',1,'Retail Sale Id 1651',2960.00,0.00,0.00,4.00,440.00,'2023-01-29 12:39:14','',''),(1588,'1','308','1',1,'Retail Sale Id 1652',2997.00,0.00,0.00,4.05,445.50,'2023-01-29 12:56:02','',''),(1589,'1','308','1',1,'Retail Sale Id 1653',1502.20,0.00,0.00,2.03,223.30,'2023-01-29 12:59:39','',''),(1590,'1','308','1',1,'Retail Sale Id 1654',999.00,0.00,0.00,1.35,148.50,'2023-01-29 13:20:26','',''),(1591,'1','308','1',1,'Retail Sale Id 1655',1502.20,0.00,0.00,2.03,223.30,'2023-01-29 13:37:48','',''),(1592,'1','308','1',1,'Retail Sale Id 1656',2220.00,0.00,0.00,3.00,330.00,'2023-01-29 13:39:17','',''),(1593,'1','308','1',1,'Retail Sale Id 1657',35000.00,0.00,0.00,50.00,3500.00,'2023-01-29 13:43:49','',''),(1594,'1','308','1',1,'Retail Sale Id 1658',9250.00,0.00,0.00,12.50,1375.00,'2023-01-29 14:07:05','',''),(1595,'1','308','1',1,'Retail Sale Id 1659',3700.00,0.00,0.00,5.00,550.00,'2023-01-29 14:11:25','',''),(1596,'1','308','1',1,'Retail Sale Id 1660',2997.00,0.00,0.00,4.05,445.50,'2023-01-29 14:12:03','',''),(1597,'1','308','1',1,'Retail Sale Id 1661',4447.40,0.00,0.00,6.01,661.10,'2023-01-29 14:12:46','',''),(1598,'1','308','1',1,'Retail Sale Id 1662',1502.20,0.00,0.00,2.03,223.30,'2023-01-29 14:21:53','',''),(1599,'1','308','1',1,'Retail Sale Id 1663',4440.00,0.00,0.00,6.00,660.00,'2023-01-29 14:22:37','',''),(1600,'1','308','1',1,'Retail Sale Id 1664',3700.00,0.00,0.00,5.00,550.00,'2023-01-29 14:24:14','',''),(1601,'1','308','1',1,'Retail Sale Id 1665',35000.00,0.00,0.00,50.00,3500.00,'2023-01-29 14:45:22','',''),(1602,'1','308','1',1,'Retail Sale Id 1666',2220.00,0.00,0.00,3.00,330.00,'2023-01-29 14:47:44','',''),(1603,'1','308','1',1,'Retail Sale Id 1667',2220.00,0.00,0.00,3.00,330.00,'2023-01-29 14:48:21','',''),(1604,'1','308','1',1,'Retail Sale Id 1668',999.00,0.00,0.00,1.35,148.50,'2023-01-29 14:57:22','',''),(1605,'1','308','1',1,'Retail Sale Id 1669',2220.00,0.00,0.00,3.00,330.00,'2023-01-29 15:27:10','',''),(1606,'1','308','1',1,'Retail Sale Id 1670',2220.00,0.00,0.00,3.00,330.00,'2023-01-29 15:30:34','',''),(1607,'1','308','1',1,'Retail Sale Id 1671',999.00,0.00,0.00,1.35,148.50,'2023-01-29 16:08:29','',''),(1608,'1','308','1',1,'Retail Sale Id 1672',2220.00,0.00,0.00,3.00,330.00,'2023-01-29 16:19:21','',''),(1609,'1','308','1',1,'Retail Sale Id 1673',999.00,0.00,0.00,1.35,148.50,'2023-01-29 16:46:58','',''),(1610,'1','308','1',1,'Retail Sale Id 1674',2249.60,0.00,0.00,3.04,334.40,'2023-01-29 16:52:35','',''),(1611,'1','308','1',1,'Retail Sale Id 1675',747.40,0.00,0.00,1.01,111.10,'2023-01-29 17:32:56','',''),(1612,'1','308','1',1,'Retail Sale Id 1676',2197.80,0.00,0.00,2.97,326.70,'2023-01-29 17:38:27','',''),(1613,'1','308','1',1,'Retail Sale Id 1677',2249.60,0.00,0.00,3.04,334.40,'2023-01-29 17:44:42','',''),(1614,'1','308','1',1,'Retail Sale Id 1678',9250.00,0.00,0.00,12.50,1375.00,'2023-01-29 18:05:04','',''),(1615,'1','308','1',1,'Retail Sale Id 1679',2220.00,0.00,0.00,3.00,330.00,'2023-01-29 18:08:32','',''),(1616,'1','308','1',1,'Retail Sale Id 1680',2220.00,0.00,0.00,3.00,330.00,'2023-01-29 18:11:03','',''),(1617,'1','308','1',1,'Retail Sale Id 1681',1502.20,0.00,0.00,2.03,223.30,'2023-01-29 18:18:15','',''),(1618,'1','308','1',1,'Retail Sale Id 1682',3700.00,0.00,0.00,5.00,550.00,'2023-01-29 18:24:11','',''),(1619,'1','308','1',1,'Retail Sale Id 1683',2997.00,0.00,0.00,4.05,445.50,'2023-01-29 18:33:14','',''),(1620,'1','308','1',1,'Retail Sale Id 1684',1502.20,0.00,0.00,2.03,223.30,'2023-01-30 07:21:47','',''),(1621,'1','308','1',1,'Retail Sale Id 1685',2220.00,0.00,0.00,3.00,330.00,'2023-01-30 07:24:38','',''),(1622,'1','308','1',1,'Retail Sale Id 1686',1502.20,0.00,0.00,2.03,223.30,'2023-01-30 07:28:05','',''),(1623,'1','308','1',1,'Retail Sale Id 1687',1998.00,0.00,0.00,2.70,297.00,'2023-01-30 07:43:12','',''),(1624,'1','308','1',1,'Retail Sale Id 1688',9250.00,0.00,0.00,12.50,1375.00,'2023-01-30 08:03:38','',''),(1625,'1','308','1',1,'Retail Sale Id 1689',2220.00,0.00,0.00,3.00,330.00,'2023-01-30 08:04:37','',''),(1626,'1','308','1',1,'Retail Sale Id 1690',1502.20,0.00,0.00,2.03,223.30,'2023-01-30 08:28:54','',''),(1627,'1','308','1',1,'Retail Sale Id 1691',2197.80,0.00,0.00,2.97,326.70,'2023-01-30 08:45:01','',''),(1628,'1','308','1',1,'Retail Sale Id 1692',1502.20,0.00,0.00,2.03,223.30,'2023-01-30 08:56:29','',''),(1629,'1','308','1',1,'Retail Sale Id 1693',2197.80,0.00,0.00,2.97,326.70,'2023-01-30 09:25:21','',''),(1630,'1','308','1',1,'Retail Sale Id 1694',2212.60,0.00,0.00,2.99,328.90,'2023-01-30 09:31:30','',''),(1631,'1','308','1',1,'Retail Sale Id 1695',1502.20,0.00,0.00,2.03,223.30,'2023-01-30 09:32:42','',''),(1632,'1','308','1',1,'Retail Sale Id 1696',2960.00,0.00,0.00,4.00,440.00,'2023-01-30 09:41:09','',''),(1633,'1','308','1',1,'Retail Sale Id 1697',1502.20,0.00,0.00,2.03,223.30,'2023-01-30 09:42:48','',''),(1634,'1','308','1',1,'Retail Sale Id 1698',1502.20,0.00,0.00,2.03,223.30,'2023-01-30 11:02:30','',''),(1635,'1','308','1',1,'Retail Sale Id 1699',902.80,0.00,0.00,1.22,134.20,'2023-01-30 11:49:03','',''),(1636,'1','308','1',1,'Retail Sale Id 1700',4440.00,0.00,0.00,6.00,660.00,'2023-01-30 11:58:42','',''),(1637,'1','308','1',1,'Retail Sale Id 1701',1998.00,0.00,0.00,2.70,297.00,'2023-01-30 12:47:38','',''),(1638,'1','308','1',1,'Retail Sale Id 1702',9250.00,0.00,0.00,12.50,1375.00,'2023-01-30 12:55:10','',''),(1639,'1','308','1',1,'Retail Sale Id 1704',2227.40,0.00,0.00,3.01,331.10,'2023-01-30 13:08:31','',''),(1640,'1','308','1',1,'Retail Sale Id 1705',7400.00,0.00,0.00,10.00,1100.00,'2023-01-30 13:18:03','',''),(1641,'1','308','1',1,'Retail Sale Id 1706',4440.00,0.00,0.00,6.00,660.00,'2023-01-30 13:24:15','',''),(1642,'1','308','1',1,'Retail Sale Id 1707',4447.40,0.00,0.00,6.01,661.10,'2023-01-30 13:31:46','',''),(1643,'1','308','1',1,'Retail Sale Id 1708',1502.20,0.00,0.00,2.03,223.30,'2023-01-30 13:43:59','',''),(1644,'1','308','1',1,'Retail Sale Id 1709',999.00,0.00,0.00,1.35,148.50,'2023-01-30 13:46:27','',''),(1645,'1','308','1',1,'Retail Sale Id 1710',2197.80,0.00,0.00,2.97,326.70,'2023-01-30 14:07:10','',''),(1646,'1','308','1',1,'Retail Sale Id 1711',1502.20,0.00,0.00,2.03,223.30,'2023-01-30 15:22:56','',''),(1647,'1','308','1',1,'Retail Sale Id 1712',3700.00,0.00,0.00,5.00,550.00,'2023-01-30 15:44:38','',''),(1648,'1','308','1',1,'Retail Sale Id 1713',999.00,0.00,0.00,1.35,148.50,'2023-01-30 15:50:22','',''),(1649,'1','308','1',1,'Retail Sale Id 1714',2197.80,0.00,0.00,2.97,326.70,'2023-01-30 15:57:47','',''),(1650,'1','308','1',1,'Retail Sale Id 1715',1502.20,0.00,0.00,2.03,223.30,'2023-01-30 16:00:43','',''),(1651,'1','308','1',1,'Retail Sale Id 1716',4003.40,0.00,0.00,5.41,595.10,'2023-01-30 16:04:49','',''),(1652,'1','308','1',1,'Retail Sale Id 1717',1502.20,0.00,0.00,2.03,223.30,'2023-01-30 16:40:44','',''),(1653,'1','308','1',1,'Retail Sale Id 1718',1502.20,0.00,0.00,2.03,223.30,'2023-01-30 16:42:04','',''),(1654,'1','308','1',1,'Retail Sale Id 1719',1998.00,0.00,0.00,2.70,297.00,'2023-01-30 16:47:03','',''),(1655,'1','308','1',1,'Retail Sale Id 1720',1502.20,0.00,0.00,2.03,223.30,'2023-01-30 16:53:11','',''),(1656,'1','308','1',1,'Retail Sale Id 1721',3700.00,0.00,0.00,5.00,550.00,'2023-01-30 17:02:43','',''),(1657,'1','308','1',1,'Retail Sale Id 1722',1502.20,0.00,0.00,2.03,223.30,'2023-01-30 17:16:00','',''),(1658,'1','308','1',1,'Retail Sale Id 1723',1998.00,0.00,0.00,2.70,297.00,'2023-01-30 17:20:05','',''),(1659,'1','308','1',1,'Retail Sale Id 1724',2220.00,0.00,0.00,3.00,330.00,'2023-01-30 17:26:04','',''),(1660,'1','308','1',1,'Retail Sale Id 1725',28000.00,0.00,0.00,40.00,2800.00,'2023-01-30 17:30:00','',''),(1661,'1','308','1',1,'Retail Sale Id 1726',21000.00,0.00,0.00,30.00,2100.00,'2023-01-30 18:18:38','',''),(1662,'1','308','1',1,'Retail Sale Id 1727',747.40,0.00,0.00,1.01,111.10,'2023-01-30 18:26:39','',''),(1663,'1','308','1',1,'Retail Sale Id 1728',4447.40,0.00,0.00,6.01,661.10,'2023-01-30 18:29:43','',''),(1664,'1','308','1',1,'Retail Sale Id 1729',8880.00,0.00,0.00,12.00,1320.00,'2023-01-30 18:37:59','',''),(1665,'1','308','1',1,'Retail Sale Id 1730',1413.40,0.00,0.00,1.91,210.10,'2023-01-30 19:15:29','',''),(1666,'1','308','1',1,'Retail Sale Id 1731',2220.00,0.00,0.00,3.00,330.00,'2023-01-31 07:48:32','',''),(1667,'1','308','1',1,'Retail Sale Id 1732',2997.00,0.00,0.00,4.05,445.50,'2023-01-31 07:53:28','',''),(1668,'1','308','1',1,'Retail Sale Id 1733',1998.00,0.00,0.00,2.70,297.00,'2023-01-31 08:15:56','',''),(1669,'1','308','1',1,'Retail Sale Id 1734',2220.00,0.00,0.00,3.00,330.00,'2023-01-31 08:21:59','',''),(1670,'1','308','1',1,'Retail Sale Id 1735',1502.20,0.00,0.00,2.03,223.30,'2023-01-31 08:31:11','',''),(1671,'1','308','1',1,'Retail Sale Id 1736',35000.00,0.00,0.00,50.00,3500.00,'2023-01-31 08:34:20','',''),(1672,'1','308','1',1,'Retail Sale Id 1737',35000.00,0.00,0.00,50.00,3500.00,'2023-01-31 08:36:53','',''),(1673,'1','308','1',1,'Retail Sale Id 1738',3019.20,0.00,0.00,4.08,448.80,'2023-01-31 09:19:59','',''),(1674,'1','308','1',1,'Retail Sale Id 1739',1502.20,0.00,0.00,2.03,223.30,'2023-01-31 09:26:03','',''),(1675,'1','308','1',1,'Retail Sale Id 1740',105000.00,0.00,0.00,150.00,10500.00,'2023-01-31 09:28:42','',''),(1676,'1','308','1',1,'Retail Sale Id 1741',140000.00,0.00,0.00,200.00,14000.00,'2023-01-31 09:38:58','',''),(1677,'1','308','1',1,'Retail Sale Id 1742',999.00,0.00,0.00,1.35,148.50,'2023-01-31 09:49:08','',''),(1678,'1','308','1',1,'Retail Sale Id 1743',740.00,0.00,0.00,1.00,110.00,'2023-01-31 10:18:48','',''),(1679,'1','308','1',1,'Retail Sale Id 1744',2997.00,0.00,0.00,4.05,445.50,'2023-01-31 10:40:11','',''),(1680,'1','308','1',1,'Retail Sale Id 1745',2249.60,0.00,0.00,3.04,334.40,'2023-01-31 10:50:34','',''),(1681,'1','308','1',1,'Retail Sale Id 1746',1502.20,0.00,0.00,2.03,223.30,'2023-01-31 11:40:25','',''),(1682,'1','308','1',1,'Retail Sale Id 1747',999.00,0.00,0.00,1.35,148.50,'2023-01-31 11:51:09','',''),(1683,'1','308','1',1,'Retail Sale Id 1748',4440.00,0.00,0.00,6.00,660.00,'2023-01-31 11:59:07','',''),(1684,'1','308','1',1,'Retail Sale Id 1749',2997.00,0.00,0.00,4.05,445.50,'2023-01-31 12:44:56','',''),(1685,'1','308','1',1,'Retail Sale Id 1750',9250.00,0.00,0.00,12.50,1375.00,'2023-01-31 12:55:07','',''),(1686,'1','308','1',1,'Retail Sale Id 1751',747.40,0.00,0.00,1.01,111.10,'2023-01-31 12:58:39','',''),(1687,'1','308','1',1,'Retail Sale Id 1753',999.00,0.00,0.00,1.35,148.50,'2023-01-31 13:35:45','',''),(1688,'1','308','1',1,'Retail Sale Id 1754',1480.00,0.00,0.00,2.00,220.00,'2023-01-31 14:04:51','',''),(1689,'1','308','1',1,'Retail Sale Id 1755',999.00,0.00,0.00,1.35,148.50,'2023-01-31 14:41:10','',''),(1690,'1','308','1',1,'Retail Sale Id 1756',1502.20,0.00,0.00,2.03,223.30,'2023-01-31 14:44:29','',''),(1691,'1','308','1',1,'Retail Sale Id 1757',1502.20,0.00,0.00,2.03,223.30,'2023-01-31 14:45:23','',''),(1692,'1','308','1',1,'Retail Sale Id 1752',2960.00,0.00,0.00,4.00,440.00,'2023-01-31 15:37:58','',''),(1693,'1','308','1',1,'Retail Sale Id 1758',7400.00,0.00,0.00,10.00,1100.00,'2023-01-31 15:51:46','',''),(1694,'1','308','1',1,'Retail Sale Id 1759',2960.00,0.00,0.00,4.00,440.00,'2023-01-31 15:55:51','',''),(1695,'1','308','1',1,'Retail Sale Id 1760',2249.60,0.00,0.00,3.04,334.40,'2023-01-31 16:13:06','',''),(1696,'1','308','1',1,'Retail Sale Id 1761',999.00,0.00,0.00,1.35,148.50,'2023-01-31 16:21:41','',''),(1697,'1','308','1',1,'Retail Sale Id 1762',3700.00,0.00,0.00,5.00,550.00,'2023-01-31 16:33:11','',''),(1698,'1','308','1',1,'Retail Sale Id 1763',2249.60,0.00,0.00,3.04,334.40,'2023-01-31 16:38:36','',''),(1699,'1','308','1',1,'Retail Sale Id 1764',1502.20,0.00,0.00,2.03,223.30,'2023-01-31 17:15:45','',''),(1700,'1','308','1',1,'Retail Sale Id 1765',1502.20,0.00,0.00,2.03,223.30,'2023-01-31 17:16:45','',''),(1701,'1','308','1',1,'Retail Sale Id 1766',1502.20,0.00,0.00,2.03,223.30,'2023-01-31 17:17:54','',''),(1702,'1','308','1',1,'Retail Sale Id 1767',2952.60,0.00,0.00,3.99,438.90,'2023-01-31 17:26:07','',''),(1703,'1','308','1',1,'Retail Sale Id 1768',2197.80,0.00,0.00,2.97,326.70,'2023-01-31 17:48:35','',''),(1704,'1','308','1',1,'Retail Sale Id 1769',1502.20,0.00,0.00,2.03,223.30,'2023-01-31 17:52:10','',''),(1705,'1','308','1',1,'Retail Sale Id 1770',747.40,0.00,0.00,1.01,111.10,'2023-01-31 18:14:59','',''),(1706,'1','308','1',1,'Retail Sale Id 1771',2227.40,0.00,0.00,3.01,331.10,'2023-01-31 18:20:05','',''),(1707,'1','308','1',1,'Retail Sale Id 1772',1502.20,0.00,0.00,2.03,223.30,'2023-01-31 18:21:01','',''),(1708,'1','308','1',1,'Retail Sale Id 1773',3700.00,0.00,0.00,5.00,550.00,'2023-01-31 18:23:01','',''),(1709,'1','308','1',1,'Retail Sale Id 1775',1502.20,0.00,0.00,2.03,223.30,'2023-01-31 18:37:51','',''),(1710,'1','308','1',1,'Retail Sale Id 1776',1502.20,0.00,0.00,2.03,223.30,'2023-01-31 18:38:35','',''),(1711,'1','308','1',1,'Retail Sale Id 1777',2997.00,0.00,0.00,4.05,445.50,'2023-01-31 18:40:52','',''),(1712,'1','308','1',1,'Retail Sale Id 1778',1998.00,0.00,0.00,2.70,297.00,'2023-01-31 18:57:07','',''),(1713,'1','308','1',1,'Retail Sale Id 1779',1502.20,0.00,0.00,2.03,223.30,'2023-01-31 19:06:11','',''),(1714,'1','308','1',1,'Retail Sale Id 1780',29.60,0.00,0.00,0.04,4.40,'2023-01-31 19:12:54','',''),(1715,'1','308','1',1,'Retail Sale Id 1781',4440.00,0.00,0.00,6.00,660.00,'2023-02-01 07:26:52','',''),(1716,'1','308','1',1,'Retail Sale Id 1782',2301.40,0.00,0.00,3.11,342.10,'2023-02-01 07:41:13','',''),(1717,'1','308','1',1,'Retail Sale Id 1783',747.40,0.00,0.00,1.01,111.10,'2023-02-01 07:45:38','',''),(1718,'1','308','1',1,'Retail Sale Id 1784',35000.00,0.00,0.00,50.00,3500.00,'2023-02-01 07:53:43','',''),(1719,'1','308','1',1,'Retail Sale Id 1785',3700.00,0.00,0.00,5.00,550.00,'2023-02-01 08:01:53','',''),(1720,'1','308','1',1,'Retail Sale Id 1786',3700.00,0.00,0.00,5.00,550.00,'2023-02-01 08:15:15','',''),(1721,'1','308','1',1,'Retail Sale Id 1787',2249.60,0.00,0.00,3.04,334.40,'2023-02-01 08:45:08','',''),(1722,'1','308','1',1,'Retail Sale Id 1788',2997.00,0.00,0.00,4.05,445.50,'2023-02-01 08:46:30','',''),(1723,'1','308','1',1,'Retail Sale Id 1790',9250.00,0.00,0.00,12.50,1375.00,'2023-02-01 08:48:32','',''),(1724,'1','308','1',1,'Retail Sale Id 1791',2960.00,0.00,0.00,4.00,440.00,'2023-02-01 08:58:41','',''),(1725,'1','308','1',1,'Retail Sale Id 1792',4440.00,0.00,0.00,6.00,660.00,'2023-02-01 09:04:51','',''),(1726,'1','308','1',1,'Retail Sale Id 1793',43750.00,0.00,0.00,62.50,4375.00,'2023-02-01 09:09:25','',''),(1727,'1','308','1',1,'Retail Sale Id 1794',1502.20,0.00,0.00,2.03,223.30,'2023-02-01 09:10:52','',''),(1728,'1','308','1',1,'Retail Sale Id 1795',1302.40,0.00,0.00,1.76,193.60,'2023-02-01 09:12:02','',''),(1729,'1','308','1',1,'Retail Sale Id 1796',747.40,0.00,0.00,1.01,111.10,'2023-02-01 09:24:06','',''),(1730,'1','308','1',1,'Retail Sale Id 1797',2960.00,0.00,0.00,4.00,440.00,'2023-02-01 09:36:24','',''),(1731,'1','308','1',1,'Retail Sale Id 1798',1480.00,0.00,0.00,2.00,220.00,'2023-02-01 09:38:03','',''),(1732,'1','308','1',1,'Retail Sale Id 1799',2220.00,0.00,0.00,3.00,330.00,'2023-02-01 09:43:55','',''),(1733,'1','308','1',1,'Retail Sale Id 1800',2960.00,0.00,0.00,4.00,440.00,'2023-02-01 09:46:41','',''),(1734,'1','308','1',1,'Retail Sale Id 1801',747.40,0.00,0.00,1.01,111.10,'2023-02-01 09:56:39','',''),(1735,'1','308','1',1,'Return of Retail Sale Id 1793',0.00,43750.00,62.50,0.00,-4375.00,'2023-02-01 11:01:48','',''),(1736,'1','308','1',1,'Retail Sale Id 1802',43505.00,0.00,0.00,62.15,4350.50,'2023-02-01 11:03:47','',''),(1737,'1','308','1',1,'Distributed to OPERATIONAL LOSS for sales id:2',48636.00,0.00,0.00,77.20,0.00,'2023-02-01 11:36:54','',''),(1738,'1','308',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,630000.00,1000.00,0.00,0.00,'2023-02-01 12:22:15','',''),(1739,'1','308',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,1000.00,0.00,'2023-02-01 12:23:55','',''),(1740,'1','308','1',1,'Received from bridging 4',0.00,0.00,1000.00,0.00,0.00,'2023-02-01 12:23:55','',''),(1741,'1','308','1',1,'Retail Sale Id 1803',2997.00,0.00,0.00,4.05,445.50,'2023-02-01 12:26:59','',''),(1742,'1','308','1',1,'Retail Sale Id 1804',21489.60,0.00,0.00,29.04,3194.40,'2023-02-01 12:34:50','',''),(1743,'1','308','1',1,'Retail Sale Id 1805',9250.00,0.00,0.00,12.50,1375.00,'2023-02-01 12:58:19','',''),(1744,'1','308','1',1,'Retail Sale Id 1806',3700.00,0.00,0.00,5.00,550.00,'2023-02-01 13:07:47','',''),(1745,'1','308','1',1,'Retail Sale Id 1807',1502.20,0.00,0.00,2.03,223.30,'2023-02-01 13:34:01','',''),(1746,'1','308','1',1,'Retail Sale Id 1808',1650.20,0.00,0.00,2.23,245.30,'2023-02-01 14:21:13','',''),(1747,'1','308','1',1,'Retail Sale Id 1809',2227.40,0.00,0.00,3.01,331.10,'2023-02-01 14:30:05','',''),(1748,'1','308','1',1,'Retail Sale Id 1810',1502.20,0.00,0.00,2.03,223.30,'2023-02-01 14:49:04','',''),(1749,'1','308','1',1,'Retail Sale Id 1811',2197.80,0.00,0.00,2.97,326.70,'2023-02-01 14:54:16','',''),(1750,'1','308','1',1,'Retail Sale Id 1812',9250.00,0.00,0.00,12.50,1375.00,'2023-02-01 14:56:03','',''),(1751,'1','308','1',1,'Retail Sale Id 1813',4440.00,0.00,0.00,6.00,660.00,'2023-02-01 14:56:56','',''),(1752,'1','308','1',1,'Retail Sale Id 1814',2249.60,0.00,0.00,3.04,334.40,'2023-02-01 15:01:58','',''),(1753,'1','308','1',1,'Retail Sale Id 1815',1502.20,0.00,0.00,2.03,223.30,'2023-02-01 15:27:30','',''),(1754,'1','308','1',1,'Retail Sale Id 1816',4447.40,0.00,0.00,6.01,661.10,'2023-02-01 15:30:54','',''),(1755,'1','308','1',1,'Retail Sale Id 1817',999.00,0.00,0.00,1.35,148.50,'2023-02-01 16:25:48','',''),(1756,'1','308','1',1,'Retail Sale Id 1818',2997.00,0.00,0.00,4.05,445.50,'2023-02-01 16:52:00','',''),(1757,'1','308','1',1,'Retail Sale Id 1819',9250.00,0.00,0.00,12.50,1375.00,'2023-02-01 17:05:02','',''),(1758,'1','308','1',1,'Retail Sale Id 1820',2220.00,0.00,0.00,3.00,330.00,'2023-02-01 17:20:02','',''),(1759,'1','308','1',1,'Retail Sale Id 1821',2197.80,0.00,0.00,2.97,326.70,'2023-02-01 17:26:41','',''),(1760,'1','308','1',1,'Retail Sale Id 1822',2249.60,0.00,0.00,3.04,334.40,'2023-02-01 17:32:55','',''),(1761,'1','308','1',1,'Retail Sale Id 1823',1546.60,0.00,0.00,2.09,229.90,'2023-02-01 17:34:36','',''),(1762,'1','308','1',1,'Retail Sale Id 1824',747.40,0.00,0.00,1.01,111.10,'2023-02-01 17:39:30','',''),(1763,'1','308','1',1,'Retail Sale Id 1825',747.40,0.00,0.00,1.01,111.10,'2023-02-01 17:41:46','',''),(1764,'1','308','1',1,'Retail Sale Id 1826',4447.40,0.00,0.00,6.01,661.10,'2023-02-01 17:54:13','',''),(1765,'1','308','1',1,'Retail Sale Id 1827',1502.20,0.00,0.00,2.03,223.30,'2023-02-01 17:59:30','',''),(1766,'1','308','1',1,'Retail Sale Id 1828',5202.20,0.00,0.00,7.03,773.30,'2023-02-01 18:11:54','',''),(1767,'1','308','1',1,'Retail Sale Id 1829',9250.00,0.00,0.00,12.50,1375.00,'2023-02-01 18:23:33','',''),(1768,'1','308','1',1,'Retail Sale Id 1830',4447.40,0.00,0.00,6.01,661.10,'2023-02-01 18:26:48','',''),(1769,'1','308','1',1,'Retail Sale Id 1831',1502.20,0.00,0.00,2.03,223.30,'2023-02-01 18:28:15','',''),(1770,'1','308','1',1,'Retail Sale Id 1832',747.40,0.00,0.00,1.01,111.10,'2023-02-01 18:34:50','',''),(1771,'1','308','1',1,'Retail Sale Id 1833',2501.20,0.00,0.00,3.38,371.80,'2023-02-01 18:39:10','',''),(1772,'1','308','1',1,'Retail Sale Id 1834',2249.60,0.00,0.00,3.04,334.40,'2023-02-01 18:45:30','',''),(1773,'1','308','1',1,'Retail Sale Id 1835',4447.40,0.00,0.00,6.01,661.10,'2023-02-01 18:48:09','',''),(1774,'1','308','1',1,'Retail Sale Id 1836',1502.20,0.00,0.00,2.03,223.30,'2023-02-01 18:49:12','',''),(1775,'1','308','1',1,'Retail Sale Id 1837',1502.20,0.00,0.00,2.03,223.30,'2023-02-01 18:50:34','',''),(1776,'1','308','1',1,'Retail Sale Id 1838',2249.60,0.00,0.00,3.04,334.40,'2023-02-01 18:54:31','',''),(1777,'1','308','1',1,'Retail Sale Id 1839',3700.00,0.00,0.00,5.00,550.00,'2023-02-01 18:56:23','',''),(1778,'1','308','1',1,'Retail Sale Id 1840',3700.00,0.00,0.00,5.00,550.00,'2023-02-01 19:03:56','',''),(1779,'1','308','1',1,'Retail Sale Id 1841',1502.20,0.00,0.00,2.03,223.30,'2023-02-01 19:05:44','',''),(1780,'1','308','1',1,'Return of Retail Sale Id 1835',0.00,4447.40,6.01,0.00,-661.10,'2023-02-01 20:16:45','',''),(1781,'1','308','1',1,'Retail Sale Id 1842',37.00,0.00,0.00,0.05,5.50,'2023-02-01 20:24:20','',''),(1782,'1','308',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,2664900.00,4230.00,0.00,0.00,'2023-02-01 20:32:05','',''),(1783,'1','308',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,4230.00,0.00,'2023-02-01 20:33:11','',''),(1784,'1','308','1',1,'Received from bridging 5',0.00,0.00,4230.00,0.00,0.00,'2023-02-01 20:33:11','',''),(1785,'1','308','1',1,'Retail Sale Id 1843',1502.20,0.00,0.00,2.03,223.30,'2023-02-02 07:53:48','',''),(1786,'1','308','1',1,'Retail Sale Id 1844',4003.40,0.00,0.00,5.41,595.10,'2023-02-02 07:55:02','',''),(1787,'1','308','1',1,'Retail Sale Id 1845',2220.00,0.00,0.00,3.00,330.00,'2023-02-02 08:03:26','',''),(1788,'1','308','1',1,'Retail Sale Id 1846',4440.00,0.00,0.00,6.00,660.00,'2023-02-02 08:12:25','',''),(1789,'1','308','1',1,'Retail Sale Id 1847',9250.00,0.00,0.00,12.50,1375.00,'2023-02-02 08:17:56','',''),(1790,'1','308','1',1,'Retail Sale Id 1848',1502.20,0.00,0.00,2.03,223.30,'2023-02-02 08:28:21','',''),(1791,'1','308','1',1,'Retail Sale Id 1849',4440.00,0.00,0.00,6.00,660.00,'2023-02-02 08:47:35','',''),(1792,'1','308','1',1,'Retail Sale Id 1850',2220.00,0.00,0.00,3.00,330.00,'2023-02-02 08:49:40','',''),(1793,'1','308','1',1,'Retail Sale Id 1851',2249.60,0.00,0.00,3.04,334.40,'2023-02-02 08:51:32','',''),(1794,'1','308','1',1,'Retail Sale Id 1852',9250.00,0.00,0.00,12.50,1375.00,'2023-02-02 08:53:24','',''),(1795,'1','308','1',1,'Retail Sale Id 1853',6660.00,0.00,0.00,9.00,990.00,'2023-02-02 08:56:15','',''),(1796,'1','308','1',1,'Retail Sale Id 1854',4447.40,0.00,0.00,6.01,661.10,'2023-02-02 09:12:49','',''),(1797,'1','308','1',1,'Retail Sale Id 1855',747.40,0.00,0.00,1.01,111.10,'2023-02-02 09:36:41','',''),(1798,'1','308','1',1,'Retail Sale Id 1856',1480.00,0.00,0.00,2.00,220.00,'2023-02-02 09:57:43','',''),(1799,'1','308','1',1,'Retail Sale Id 1857',4440.00,0.00,0.00,6.00,660.00,'2023-02-02 10:24:34','',''),(1800,'1','308','1',1,'Retail Sale Id 1858',4403.00,0.00,0.00,5.95,654.50,'2023-02-02 11:04:09','',''),(1801,'1','308','1',1,'Retail Sale Id 1860',2197.80,0.00,0.00,2.97,326.70,'2023-02-02 11:09:23','',''),(1802,'1','308','1',1,'Retail Sale Id 1861',4403.00,0.00,0.00,5.95,654.50,'2023-02-02 11:11:40','',''),(1803,'1','308','1',1,'Retail Sale Id 1862',2997.00,0.00,0.00,4.05,445.50,'2023-02-02 11:12:29','',''),(1804,'1','308','1',1,'Retail Sale Id 1863',1502.20,0.00,0.00,2.03,223.30,'2023-02-02 11:18:06','',''),(1805,'1','308','1',1,'Retail Sale Id 1864',2960.00,0.00,0.00,4.00,440.00,'2023-02-02 11:45:56','',''),(1806,'1','308','1',1,'Retail Sale Id 1865',2249.60,0.00,0.00,3.04,334.40,'2023-02-02 12:44:54','',''),(1807,'1','308','1',1,'Retail Sale Id 1866',747.40,0.00,0.00,1.01,111.10,'2023-02-02 14:03:02','',''),(1808,'1','308','1',1,'Retail Sale Id 1867',35000.00,0.00,0.00,50.00,3500.00,'2023-02-02 14:30:26','',''),(1809,'1','308','1',1,'Retail Sale Id 1868',1998.00,0.00,0.00,2.70,297.00,'2023-02-02 14:47:04','',''),(1810,'1','308','1',1,'Retail Sale Id 1869',7400.00,0.00,0.00,10.00,1100.00,'2023-02-02 15:02:54','',''),(1811,'1','308','1',1,'Retail Sale Id 1870',747.40,0.00,0.00,1.01,111.10,'2023-02-02 15:35:01','',''),(1812,'1','308','1',1,'Retail Sale Id 1871',999.00,0.00,0.00,1.35,148.50,'2023-02-02 16:18:13','',''),(1813,'1','308','1',1,'Retail Sale Id 1872',1998.00,0.00,0.00,2.70,297.00,'2023-02-02 16:25:20','',''),(1814,'1','308','1',1,'Retail Sale Id 1873',2997.00,0.00,0.00,4.05,445.50,'2023-02-02 16:27:22','',''),(1815,'1','308','1',1,'Retail Sale Id 1874',2997.00,0.00,0.00,4.05,445.50,'2023-02-02 16:31:15','',''),(1816,'1','308','1',1,'Retail Sale Id 1875',1502.20,0.00,0.00,2.03,223.30,'2023-02-02 16:33:43','',''),(1817,'1','308','1',1,'Retail Sale Id 1876',4440.00,0.00,0.00,6.00,660.00,'2023-02-02 16:36:05','',''),(1818,'1','308',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,2123100.00,3370.00,0.00,0.00,'2023-02-02 16:43:22','',''),(1819,'1','308','1',1,'Retail Sale Id 1877',2960.00,0.00,0.00,4.00,440.00,'2023-02-02 17:15:20','',''),(1820,'1','308','1',1,'Retail Sale Id 1878',3700.00,0.00,0.00,5.00,550.00,'2023-02-02 17:48:36','',''),(1821,'1','308','1',1,'Retail Sale Id 1879',747.40,0.00,0.00,1.01,111.10,'2023-02-02 17:49:51','',''),(1822,'1','308','1',1,'Retail Sale Id 1880',1502.20,0.00,0.00,2.03,223.30,'2023-02-02 18:08:52','',''),(1823,'1','308','1',1,'Retail Sale Id 1881',1502.20,0.00,0.00,2.03,223.30,'2023-02-02 18:10:12','',''),(1824,'1','308','1',1,'Retail Sale Id 1882',747.40,0.00,0.00,1.01,111.10,'2023-02-02 18:20:11','',''),(1825,'1','308','1',1,'Retail Sale Id 1883',1502.20,0.00,0.00,2.03,223.30,'2023-02-02 18:29:15','',''),(1826,'1','308','1',1,'Retail Sale Id 1884',503.20,0.00,0.00,0.68,74.80,'2023-02-02 18:39:04','',''),(1827,'1','308','1',1,'Retail Sale Id 1885',3700.00,0.00,0.00,5.00,550.00,'2023-02-02 18:43:46','',''),(1828,'1','308','1',1,'Retail Sale Id 1886',999.00,0.00,0.00,1.35,148.50,'2023-02-02 18:55:27','',''),(1829,'1','308','1',1,'Retail Sale Id 1887',31500.00,0.00,0.00,45.00,3150.00,'2023-02-02 19:03:52','',''),(1830,'1','308','1',1,'Retail Sale Id 1888',4447.40,0.00,0.00,6.01,661.10,'2023-02-02 19:05:47','',''),(1831,'1','308','1',1,'Retail Sale Id 1889',1480.00,0.00,0.00,2.00,220.00,'2023-02-02 19:13:20','',''),(1832,'1','308','1',1,'Retail Sale Id 1890',37.00,0.00,0.00,0.05,5.50,'2023-02-02 19:25:41','',''),(1833,'1','308','1',1,'Return of Retail Sale Id 1867',0.00,35000.00,50.00,0.00,-3500.00,'2023-02-02 19:32:55','',''),(1834,'1','308','1',1,'Retail Sale Id 1891',35000.00,0.00,0.00,50.00,3500.00,'2023-02-02 19:33:31','',''),(1835,'1','308','1',1,'Retail Sale Id 1892',2960.00,0.00,0.00,4.00,440.00,'2023-02-02 19:35:51','',''),(1836,'1','308',NULL,1,'Returned purchase #6 to AA RANO NIGERIA LTD.',2123100.00,0.00,0.00,3370.00,0.00,'2023-02-02 21:58:04','',''),(1837,'1','308','1',1,'Retail Sale Id 1893',5920.00,0.00,0.00,8.00,880.00,'2023-02-03 07:45:43','',''),(1838,'1','308','1',1,'Retail Sale Id 1894',1502.20,0.00,0.00,2.03,223.30,'2023-02-03 08:34:09','',''),(1839,'1','308','1',1,'Retail Sale Id 1895',2220.00,0.00,0.00,3.00,330.00,'2023-02-03 08:39:54','',''),(1840,'1','308','1',1,'Retail Sale Id 1896',4440.00,0.00,0.00,6.00,660.00,'2023-02-03 08:48:26','',''),(1841,'1','308','1',1,'Retail Sale Id 1897',17500.00,0.00,0.00,25.00,1750.00,'2023-02-03 08:51:59','',''),(1842,'1','308','1',1,'Retail Sale Id 1898',1502.20,0.00,0.00,2.03,223.30,'2023-02-03 09:02:43','',''),(1843,'1','308','1',1,'Retail Sale Id 1899',747.40,0.00,0.00,1.01,111.10,'2023-02-03 09:03:39','',''),(1844,'1','308','1',1,'Retail Sale Id 1900',3700.00,0.00,0.00,5.00,550.00,'2023-02-03 09:08:45','',''),(1845,'1','308','1',1,'Retail Sale Id 1901',2220.00,0.00,0.00,3.00,330.00,'2023-02-03 09:11:18','',''),(1846,'1','308','1',1,'Retail Sale Id 1902',5180.00,0.00,0.00,7.00,770.00,'2023-02-03 09:23:47','',''),(1847,'1','308','1',1,'Retail Sale Id 1903',1480.00,0.00,0.00,2.00,220.00,'2023-02-03 09:44:09','',''),(1848,'1','308','1',1,'Retail Sale Id 1904',7400.00,0.00,0.00,10.00,1100.00,'2023-02-03 09:46:57','',''),(1849,'1','308','1',1,'Retail Sale Id 1905',2220.00,0.00,0.00,3.00,330.00,'2023-02-03 10:38:07','',''),(1850,'1','308','1',1,'Retail Sale Id 1906',1502.20,0.00,0.00,2.03,223.30,'2023-02-03 10:43:19','',''),(1851,'1','308','1',1,'Retail Sale Id 1907',4440.00,0.00,0.00,6.00,660.00,'2023-02-03 11:05:55','',''),(1852,'1','308','1',1,'Retail Sale Id 1908',3700.00,0.00,0.00,5.00,550.00,'2023-02-03 11:42:37','',''),(1853,'1','308','1',1,'Retail Sale Id 1909',999.00,0.00,0.00,1.35,148.50,'2023-02-03 11:50:52','',''),(1854,'1','308','1',1,'Retail Sale Id 1910',1502.20,0.00,0.00,2.03,223.30,'2023-02-03 12:16:41','',''),(1855,'1','308','1',1,'Retail Sale Id 1911',4440.00,0.00,0.00,6.00,660.00,'2023-02-03 13:01:03','',''),(1856,'1','308','1',1,'Retail Sale Id 1912',2960.00,0.00,0.00,4.00,440.00,'2023-02-03 13:05:07','',''),(1857,'1','308','1',1,'Retail Sale Id 1914',1480.00,0.00,0.00,2.00,220.00,'2023-02-03 13:22:04','',''),(1858,'1','308','1',1,'Retail Sale Id 1915',2220.00,0.00,0.00,3.00,330.00,'2023-02-03 14:20:34','',''),(1859,'1','308','1',1,'Retail Sale Id 1916',747.40,0.00,0.00,1.01,111.10,'2023-02-03 14:22:08','',''),(1860,'1','308','1',1,'Retail Sale Id 1917',2220.00,0.00,0.00,3.00,330.00,'2023-02-03 14:26:01','',''),(1861,'1','308','1',1,'Retail Sale Id 1918',4440.00,0.00,0.00,6.00,660.00,'2023-02-03 14:30:00','',''),(1862,'1','308','1',1,'Retail Sale Id 1919',4440.00,0.00,0.00,6.00,660.00,'2023-02-03 14:32:47','',''),(1863,'1','308','1',1,'Retail Sale Id 1921',1901.80,0.00,0.00,2.57,282.70,'2023-02-03 15:37:21','',''),(1864,'1','308','1',1,'Retail Sale Id 1922',2997.00,0.00,0.00,4.05,445.50,'2023-02-03 15:43:10','',''),(1865,'1','308','1',1,'Retail Sale Id 1923',2997.00,0.00,0.00,4.05,445.50,'2023-02-03 15:45:02','',''),(1866,'1','308','1',1,'Retail Sale Id 1925',2249.60,0.00,0.00,3.04,334.40,'2023-02-03 15:54:58','',''),(1867,'1','308','1',1,'Retail Sale Id 1926',1502.20,0.00,0.00,2.03,223.30,'2023-02-03 15:56:31','',''),(1868,'1','308','1',1,'Retail Sale Id 1928',2220.00,0.00,0.00,3.00,330.00,'2023-02-03 15:58:49','',''),(1869,'1','308','1',1,'Retail Sale Id 1929',703.00,0.00,0.00,0.95,104.50,'2023-02-03 16:21:48','',''),(1870,'1','308','1',1,'Retail Sale Id 1930',799.20,0.00,0.00,1.08,118.80,'2023-02-03 16:27:47','',''),(1871,'1','308','1',1,'Retail Sale Id 1931',1502.20,0.00,0.00,2.03,223.30,'2023-02-03 16:36:46','',''),(1872,'1','308','1',1,'Retail Sale Id 1933',1502.20,0.00,0.00,2.03,223.30,'2023-02-03 16:45:28','',''),(1873,'1','308','1',1,'Retail Sale Id 1934',747.40,0.00,0.00,1.01,111.10,'2023-02-03 16:49:09','',''),(1874,'1','308','1',1,'Retail Sale Id 1935',3700.00,0.00,0.00,5.00,550.00,'2023-02-03 16:55:05','',''),(1875,'1','308','1',1,'Retail Sale Id 1936',2960.00,0.00,0.00,4.00,440.00,'2023-02-03 16:58:42','',''),(1876,'1','308','1',1,'Retail Sale Id 1937',999.00,0.00,0.00,1.35,148.50,'2023-02-03 16:59:51','',''),(1877,'1','308','1',1,'Retail Sale Id 1939',2220.00,0.00,0.00,3.00,330.00,'2023-02-03 17:10:51','',''),(1878,'1','308','1',1,'Retail Sale Id 1941',1502.20,0.00,0.00,2.03,223.30,'2023-02-03 17:42:23','',''),(1879,'1','308','1',1,'Retail Sale Id 1942',9250.00,0.00,0.00,12.50,1375.00,'2023-02-03 17:47:04','',''),(1880,'1','308','1',1,'Retail Sale Id 1945',7400.00,0.00,0.00,10.00,1100.00,'2023-02-03 17:58:20','',''),(1881,'1','308','1',1,'Retail Sale Id 1946',8880.00,0.00,0.00,12.00,1320.00,'2023-02-03 18:06:17','',''),(1882,'1','308','1',1,'Retail Sale Id 1947',740.00,0.00,0.00,1.00,110.00,'2023-02-03 18:08:28','',''),(1883,'1','308','1',1,'Retail Sale Id 1949',1502.20,0.00,0.00,2.03,223.30,'2023-02-03 19:00:59','',''),(1884,'1','308','1',1,'Retail Sale Id 1950',2227.40,0.00,0.00,3.01,331.10,'2023-02-03 19:03:30','',''),(1885,'1','308','1',1,'Retail Sale Id 1951',2249.60,0.00,0.00,3.04,334.40,'2023-02-04 07:52:29','',''),(1886,'1','308','1',1,'Retail Sale Id 1952',3700.00,0.00,0.00,5.00,550.00,'2023-02-04 07:54:00','',''),(1887,'1','308','1',1,'Retail Sale Id 1953',2997.00,0.00,0.00,4.05,445.50,'2023-02-04 07:55:35','',''),(1888,'1','308','1',1,'Retail Sale Id 1954',2220.00,0.00,0.00,3.00,330.00,'2023-02-04 08:09:48','',''),(1889,'1','308','1',1,'Retail Sale Id 1955',2197.80,0.00,0.00,2.97,326.70,'2023-02-04 08:11:20','',''),(1890,'1','308','1',1,'Retail Sale Id 1956',70000.00,0.00,0.00,100.00,7000.00,'2023-02-04 08:26:06','',''),(1891,'1','308','1',1,'Retail Sale Id 1957',1480.00,0.00,0.00,2.00,220.00,'2023-02-04 08:28:07','',''),(1892,'1','308','1',1,'Retail Sale Id 1958',9250.00,0.00,0.00,12.50,1375.00,'2023-02-04 08:31:09','',''),(1893,'1','308','1',1,'Retail Sale Id 1959',4440.00,0.00,0.00,6.00,660.00,'2023-02-04 08:37:26','',''),(1894,'1','308','1',1,'Retail Sale Id 1960',2249.60,0.00,0.00,3.04,334.40,'2023-02-04 09:07:22','',''),(1895,'1','308','1',1,'Retail Sale Id 1961',999.00,0.00,0.00,1.35,148.50,'2023-02-04 09:08:22','',''),(1896,'1','308','1',1,'Retail Sale Id 1962',3700.00,0.00,0.00,5.00,550.00,'2023-02-04 09:09:30','',''),(1897,'1','308','1',1,'Retail Sale Id 1963',2960.00,0.00,0.00,4.00,440.00,'2023-02-04 09:10:50','',''),(1898,'1','308','1',1,'Retail Sale Id 1964',747.40,0.00,0.00,1.01,111.10,'2023-02-04 09:11:54','',''),(1899,'1','308','1',1,'Retail Sale Id 1965',4447.40,0.00,0.00,6.01,661.10,'2023-02-04 09:13:00','',''),(1900,'1','308','1',1,'Retail Sale Id 1966',1502.20,0.00,0.00,2.03,223.30,'2023-02-04 09:13:53','',''),(1901,'1','308','1',1,'Retail Sale Id 1967',1502.20,0.00,0.00,2.03,223.30,'2023-02-04 09:14:40','',''),(1902,'1','308','1',1,'Retail Sale Id 1968',2997.00,0.00,0.00,4.05,445.50,'2023-02-04 09:16:28','',''),(1903,'1','308','1',1,'Retail Sale Id 1969',35000.00,0.00,0.00,50.00,3500.00,'2023-02-04 09:35:02','',''),(1904,'1','308','1',1,'Retail Sale Id 1970',2220.00,0.00,0.00,3.00,330.00,'2023-02-04 09:48:13','',''),(1905,'1','308','1',1,'Retail Sale Id 1971',747.40,0.00,0.00,1.01,111.10,'2023-02-04 09:49:14','',''),(1906,'1','308','1',1,'Retail Sale Id 1972',31500.00,0.00,0.00,45.00,3150.00,'2023-02-04 10:14:14','',''),(1907,'1','308','1',1,'Retail Sale Id 1973',740.00,0.00,0.00,1.00,110.00,'2023-02-04 10:34:16','',''),(1908,'1','308','1',1,'Retail Sale Id 1974',2220.00,0.00,0.00,3.00,330.00,'2023-02-04 10:35:03','',''),(1909,'1','308','1',1,'Retail Sale Id 1975',2960.00,0.00,0.00,4.00,440.00,'2023-02-04 10:40:05','',''),(1910,'1','308','1',1,'Retail Sale Id 1976',1480.00,0.00,0.00,2.00,220.00,'2023-02-04 10:48:52','',''),(1911,'1','308','1',1,'Retail Sale Id 1977',2997.00,0.00,0.00,4.05,445.50,'2023-02-04 10:57:26','',''),(1912,'1','308','1',1,'Retail Sale Id 1978',747.40,0.00,0.00,1.01,111.10,'2023-02-04 10:59:10','',''),(1913,'1','308','1',1,'Retail Sale Id 1979',747.40,0.00,0.00,1.01,111.10,'2023-02-04 11:00:43','',''),(1914,'1','308','1',1,'Retail Sale Id 1980',2249.60,0.00,0.00,3.04,334.40,'2023-02-04 11:02:13','',''),(1915,'1','308','1',1,'Retail Sale Id 1981',9250.00,0.00,0.00,12.50,1375.00,'2023-02-04 11:11:28','',''),(1916,'1','308','1',1,'Retail Sale Id 1982',4440.00,0.00,0.00,6.00,660.00,'2023-02-04 11:22:15','',''),(1917,'1','308','1',1,'Retail Sale Id 1983',1502.20,0.00,0.00,2.03,223.30,'2023-02-04 11:24:23','',''),(1918,'1','308','1',1,'Retail Sale Id 1984',999.00,0.00,0.00,1.35,148.50,'2023-02-04 11:29:25','',''),(1919,'1','308','1',1,'Retail Sale Id 1985',740.00,0.00,0.00,1.00,110.00,'2023-02-04 11:46:37','',''),(1920,'1','308','1',1,'Retail Sale Id 1986',8880.00,0.00,0.00,12.00,1320.00,'2023-02-04 11:47:59','',''),(1921,'1','308','1',1,'Retail Sale Id 1987',1480.00,0.00,0.00,2.00,220.00,'2023-02-04 11:49:09','',''),(1922,'1','308','1',1,'Retail Sale Id 1988',9250.00,0.00,0.00,12.50,1375.00,'2023-02-04 11:49:59','',''),(1923,'1','308','1',1,'Retail Sale Id 1989',5202.20,0.00,0.00,7.03,773.30,'2023-02-04 11:51:43','',''),(1924,'1','308','1',1,'Retail Sale Id 1990',3700.00,0.00,0.00,5.00,550.00,'2023-02-04 11:53:13','',''),(1925,'1','308','1',1,'Retail Sale Id 1991',3700.00,0.00,0.00,5.00,550.00,'2023-02-04 12:08:24','',''),(1926,'1','308','1',1,'Retail Sale Id 1992',3700.00,0.00,0.00,5.00,550.00,'2023-02-04 12:17:29','',''),(1927,'1','308','1',1,'Retail Sale Id 1993',2960.00,0.00,0.00,4.00,440.00,'2023-02-04 12:19:25','',''),(1928,'1','308','1',1,'Retail Sale Id 1994',7400.00,0.00,0.00,10.00,1100.00,'2023-02-04 12:36:04','',''),(1929,'1','308','1',1,'Retail Sale Id 1995',2220.00,0.00,0.00,3.00,330.00,'2023-02-04 13:06:43','',''),(1930,'1','308','1',1,'Retail Sale Id 1996',17500.00,0.00,0.00,25.00,1750.00,'2023-02-04 13:09:09','',''),(1931,'1','308','1',1,'Retail Sale Id 1997',1480.00,0.00,0.00,2.00,220.00,'2023-02-04 13:10:01','',''),(1932,'1','308','1',1,'Retail Sale Id 1998',40600.00,0.00,0.00,58.00,4060.00,'2023-02-04 13:36:25','',''),(1933,'1','308','1',1,'Retail Sale Id 1999',4447.40,0.00,0.00,6.01,661.10,'2023-02-04 13:37:09','',''),(1934,'1','308','1',1,'Retail Sale Id 2000',1480.00,0.00,0.00,2.00,220.00,'2023-02-04 14:27:43','',''),(1935,'1','308','1',1,'Retail Sale Id 2001',7400.00,0.00,0.00,10.00,1100.00,'2023-02-04 14:29:37','',''),(1936,'1','308','1',1,'Retail Sale Id 2002',1502.20,0.00,0.00,2.03,223.30,'2023-02-04 14:32:57','',''),(1937,'1','308','1',1,'Retail Sale Id 2003',2249.60,0.00,0.00,3.04,334.40,'2023-02-04 14:46:47','',''),(1938,'1','308','1',1,'Retail Sale Id 2005',4447.40,0.00,0.00,6.01,661.10,'2023-02-04 15:18:17','',''),(1939,'1','308','1',1,'Retail Sale Id 2006',747.40,0.00,0.00,1.01,111.10,'2023-02-04 15:19:58','',''),(1940,'1','308','1',1,'Retail Sale Id 2007',2960.00,0.00,0.00,4.00,440.00,'2023-02-04 15:22:27','',''),(1941,'1','308','1',1,'Retail Sale Id 2008',35000.00,0.00,0.00,50.00,3500.00,'2023-02-04 15:38:23','',''),(1942,'1','308','1',1,'Retail Sale Id 2009',747.40,0.00,0.00,1.01,111.10,'2023-02-04 15:40:18','',''),(1943,'1','308','1',1,'Retail Sale Id 2010',2220.00,0.00,0.00,3.00,330.00,'2023-02-04 15:43:57','',''),(1944,'1','308','1',1,'Retail Sale Id 2011',747.40,0.00,0.00,1.01,111.10,'2023-02-04 15:47:57','',''),(1945,'1','308','1',1,'Retail Sale Id 2012',2220.00,0.00,0.00,3.00,330.00,'2023-02-04 16:02:39','',''),(1946,'1','308','1',1,'Retail Sale Id 2013',9250.00,0.00,0.00,12.50,1375.00,'2023-02-04 16:03:17','',''),(1947,'1','308','1',1,'Retail Sale Id 2014',35000.00,0.00,0.00,50.00,3500.00,'2023-02-04 16:05:42','',''),(1948,'1','308','1',1,'Retail Sale Id 2015',9250.00,0.00,0.00,12.50,1375.00,'2023-02-04 16:06:33','',''),(1949,'1','308','1',1,'Retail Sale Id 2016',4440.00,0.00,0.00,6.00,660.00,'2023-02-04 16:13:12','',''),(1950,'1','308','1',1,'Retail Sale Id 2017',4440.00,0.00,0.00,6.00,660.00,'2023-02-04 16:26:15','',''),(1951,'1','308','1',1,'Retail Sale Id 2018',999.00,0.00,0.00,1.35,148.50,'2023-02-04 16:43:05','',''),(1952,'1','308','1',1,'Retail Sale Id 2019',1502.20,0.00,0.00,2.03,223.30,'2023-02-04 16:45:56','',''),(1953,'1','308','1',1,'Retail Sale Id 2020',1998.00,0.00,0.00,2.70,297.00,'2023-02-04 16:48:14','',''),(1954,'1','308','1',1,'Retail Sale Id 2021',2249.60,0.00,0.00,3.04,334.40,'2023-02-04 16:49:09','',''),(1955,'1','308','1',1,'Retail Sale Id 2022',16650.00,0.00,0.00,22.50,2475.00,'2023-02-04 17:10:39','',''),(1956,'1','308','1',1,'Retail Sale Id 2023',2197.80,0.00,0.00,2.97,326.70,'2023-02-04 17:15:03','',''),(1957,'1','308','1',1,'Retail Sale Id 2024',2249.60,0.00,0.00,3.04,334.40,'2023-02-04 17:25:39','',''),(1958,'1','308','1',1,'Retail Sale Id 2025',2997.00,0.00,0.00,4.05,445.50,'2023-02-04 17:26:32','',''),(1959,'1','308','1',1,'Retail Sale Id 2026',2249.60,0.00,0.00,3.04,334.40,'2023-02-04 17:28:00','',''),(1960,'1','308','1',1,'Retail Sale Id 2027',2997.00,0.00,0.00,4.05,445.50,'2023-02-04 17:34:57','',''),(1961,'1','308','1',1,'Retail Sale Id 2028',2997.00,0.00,0.00,4.05,445.50,'2023-02-04 17:40:33','',''),(1962,'1','308','1',1,'Retail Sale Id 2030',1502.20,0.00,0.00,2.03,223.30,'2023-02-04 17:42:17','',''),(1963,'1','308','1',1,'Retail Sale Id 2031',2501.20,0.00,0.00,3.38,371.80,'2023-02-04 17:46:31','',''),(1964,'1','308','1',1,'Retail Sale Id 2032',1502.20,0.00,0.00,2.03,223.30,'2023-02-04 17:47:34','',''),(1965,'1','308','1',1,'Retail Sale Id 2033',747.40,0.00,0.00,1.01,111.10,'2023-02-04 18:13:01','',''),(1966,'1','308','1',1,'Retail Sale Id 2034',1502.20,0.00,0.00,2.03,223.30,'2023-02-04 18:14:33','',''),(1967,'1','308','1',1,'Retail Sale Id 2035',2397.60,0.00,0.00,3.24,356.40,'2023-02-04 18:24:22','',''),(1968,'1','308','1',1,'Retail Sale Id 2036',999.00,0.00,0.00,1.35,148.50,'2023-02-04 18:33:14','',''),(1969,'1','308','1',1,'Retail Sale Id 2037',4003.40,0.00,0.00,5.41,595.10,'2023-02-04 18:36:30','',''),(1970,'1','308','1',1,'Retail Sale Id 2038',1502.20,0.00,0.00,2.03,223.30,'2023-02-04 18:37:25','',''),(1971,'1','308','1',1,'Retail Sale Id 2039',7400.00,0.00,0.00,10.00,1100.00,'2023-02-04 18:38:47','',''),(1972,'1','308','1',1,'Retail Sale Id 2040',3700.00,0.00,0.00,5.00,550.00,'2023-02-04 18:51:29','',''),(1973,'1','308','1',1,'Retail Sale Id 2041',3700.00,0.00,0.00,5.00,550.00,'2023-02-04 18:54:11','',''),(1974,'1','308','1',1,'Retail Sale Id 2042',2960.00,0.00,0.00,4.00,440.00,'2023-02-04 18:55:34','',''),(1975,'1','308','1',1,'Retail Sale Id 2043',747.40,0.00,0.00,1.01,111.10,'2023-02-04 19:11:02','',''),(1976,'1','308','1',1,'Retail Sale Id 2044',13349.60,0.00,0.00,18.04,1984.40,'2023-02-05 09:37:08','',''),(1977,'1','308','1',1,'Retail Sale Id 2045',7400.00,0.00,0.00,10.00,1100.00,'2023-02-05 09:38:11','',''),(1978,'1','308','1',1,'Retail Sale Id 2046',2220.00,0.00,0.00,3.00,330.00,'2023-02-05 09:42:09','',''),(1979,'1','308','1',1,'Retail Sale Id 2047',17500.00,0.00,0.00,25.00,1750.00,'2023-02-05 10:20:50','',''),(1980,'1','308','1',1,'Retail Sale Id 2048',9250.00,0.00,0.00,12.50,1375.00,'2023-02-05 10:32:59','',''),(1981,'1','308','1',1,'Retail Sale Id 2049',4440.00,0.00,0.00,6.00,660.00,'2023-02-05 10:51:29','',''),(1982,'1','308','1',1,'Retail Sale Id 2050',1502.20,0.00,0.00,2.03,223.30,'2023-02-05 11:09:15','',''),(1983,'1','308','1',1,'Retail Sale Id 2052',747.40,0.00,0.00,1.01,111.10,'2023-02-05 11:38:06','',''),(1984,'1','308','1',1,'Retail Sale Id 2053',4454.80,0.00,0.00,6.02,662.20,'2023-02-05 12:14:31','',''),(1985,'1','308','1',1,'Retail Sale Id 2054',22436.80,0.00,0.00,30.32,3335.20,'2023-02-05 13:45:12','',''),(1986,'1','308','1',1,'Retail Sale Id 2055',5202.20,0.00,0.00,7.03,773.30,'2023-02-05 13:57:45','',''),(1987,'1','308','1',1,'Retail Sale Id 2056',77700.00,0.00,0.00,105.00,11550.00,'2023-02-05 14:02:06','',''),(1988,'1','308','1',1,'Retail Sale Id 2058',3751.80,0.00,0.00,5.07,557.70,'2023-02-05 14:32:02','',''),(1989,'1','308','1',1,'Retail Sale Id 2059',41543.60,0.00,0.00,56.14,6175.40,'2023-02-05 17:20:43','',''),(1990,'1','308','1',1,'Retail Sale Id 2060',999.00,0.00,0.00,1.35,148.50,'2023-02-05 17:22:37','',''),(1991,'1','308','1',1,'Retail Sale Id 2061',25685.40,0.00,0.00,34.71,3818.10,'2023-02-05 19:16:54','',''),(1992,'1','308','1',1,'Return of Retail Sale Id 2061',0.00,25685.40,34.71,0.00,-3818.10,'2023-02-05 19:20:04','',''),(1993,'1','308','1',1,'Retail Sale Id 2062',8184.40,0.00,0.00,11.06,1216.60,'2023-02-05 19:21:20','',''),(1994,'1','308','1',1,'Retail Sale Id 2064',2220.00,0.00,0.00,3.00,330.00,'2023-02-06 14:26:34','',''),(1995,'1','308','1',1,'Retail Sale Id 2065',9250.00,0.00,0.00,12.50,1375.00,'2023-02-06 14:29:06','',''),(1996,'1','308','1',1,'Retail Sale Id 2066',2197.80,0.00,0.00,2.97,326.70,'2023-02-06 14:30:02','',''),(1997,'1','308','1',1,'Retail Sale Id 2067',7400.00,0.00,0.00,10.00,1100.00,'2023-02-06 14:30:36','',''),(1998,'1','308','1',1,'Retail Sale Id 2068',5920.00,0.00,0.00,8.00,880.00,'2023-02-06 14:31:44','',''),(1999,'1','308','1',1,'Retail Sale Id 2069',35000.00,0.00,0.00,50.00,3500.00,'2023-02-06 15:56:42','',''),(2000,'1','308','1',1,'Retail Sale Id 2070',4647.20,0.00,0.00,6.28,690.80,'2023-02-06 15:58:06','',''),(2001,'1','308','1',1,'Retail Sale Id 2071',1502.20,0.00,0.00,2.03,223.30,'2023-02-06 15:58:56','',''),(2002,'1','308','1',1,'Retail Sale Id 2072',53605.60,0.00,0.00,72.44,7968.40,'2023-02-06 16:06:56','',''),(2003,'1','308','1',1,'Retail Sale Id 2073',158004.00,0.00,0.00,225.72,15800.40,'2023-02-06 16:10:05','',''),(2004,'1','308','1',1,'Retail Sale Id 2074',740.00,0.00,0.00,1.00,110.00,'2023-02-06 16:13:47','',''),(2005,'1','308','1',1,'Retail Sale Id 2075',2220.00,0.00,0.00,3.00,330.00,'2023-02-06 16:17:26','',''),(2006,'1','308','1',1,'Retail Sale Id 2076',703.00,0.00,0.00,0.95,104.50,'2023-02-06 16:33:07','',''),(2007,'1','308','1',1,'Return of Retail Sale Id 2066',0.00,2197.80,2.97,0.00,-326.70,'2023-02-06 16:35:00','',''),(2008,'1','308','1',1,'Retail Sale Id 2077',2997.00,0.00,0.00,4.05,445.50,'2023-02-06 17:13:16','',''),(2009,'1','308','1',1,'Retail Sale Id 2078',2197.80,0.00,0.00,2.97,326.70,'2023-02-06 17:36:22','',''),(2010,'1','308','1',1,'Retail Sale Id 2079',747.40,0.00,0.00,1.01,111.10,'2023-02-06 17:39:01','',''),(2011,'1','308','1',1,'Retail Sale Id 2080',747.40,0.00,0.00,1.01,111.10,'2023-02-06 17:42:34','',''),(2012,'1','308','1',1,'Retail Sale Id 2081',2227.40,0.00,0.00,3.01,331.10,'2023-02-06 17:48:58','',''),(2013,'1','308','1',1,'Retail Sale Id 2082',1998.00,0.00,0.00,2.70,297.00,'2023-02-06 17:56:47','',''),(2014,'1','308','1',1,'Retail Sale Id 2083',4447.40,0.00,0.00,6.01,661.10,'2023-02-06 18:15:45','',''),(2015,'1','308','1',1,'Retail Sale Id 2084',1502.20,0.00,0.00,2.03,223.30,'2023-02-06 18:25:46','',''),(2016,'1','308','1',1,'Retail Sale Id 2085',9250.00,0.00,0.00,12.50,1375.00,'2023-02-06 18:32:45','',''),(2017,'1','308','1',1,'Retail Sale Id 2086',740.00,0.00,0.00,1.00,110.00,'2023-02-06 18:43:11','',''),(2018,'1','308','1',1,'Retail Sale Id 2087',2220.00,0.00,0.00,3.00,330.00,'2023-02-06 18:43:53','',''),(2019,'1','308','1',1,'Retail Sale Id 2088',2220.00,0.00,0.00,3.00,330.00,'2023-02-07 07:52:21','',''),(2020,'1','308','1',1,'Retail Sale Id 2089',70000.00,0.00,0.00,100.00,7000.00,'2023-02-07 07:59:39','',''),(2021,'1','308','1',1,'Retail Sale Id 2090',9250.00,0.00,0.00,12.50,1375.00,'2023-02-07 08:04:01','',''),(2022,'1','308','1',1,'Retail Sale Id 2091',2301.40,0.00,0.00,3.11,342.10,'2023-02-07 08:06:58','',''),(2023,'1','308','1',1,'Retail Sale Id 2093',2249.60,0.00,0.00,3.04,334.40,'2023-02-07 08:14:20','',''),(2024,'1','308','1',1,'Retail Sale Id 2094',747.40,0.00,0.00,1.01,111.10,'2023-02-07 08:17:50','',''),(2025,'1','308','1',1,'Retail Sale Id 2096',4499.20,0.00,0.00,6.08,668.80,'2023-02-07 08:22:10','',''),(2026,'1','308','1',1,'Retail Sale Id 2099',2249.60,0.00,0.00,3.04,334.40,'2023-02-07 08:27:14','',''),(2027,'1','308','1',1,'Retail Sale Id 2100',2197.80,0.00,0.00,2.97,326.70,'2023-02-07 08:30:37','',''),(2028,'1','308','1',1,'Retail Sale Id 2101',799.20,0.00,0.00,1.08,118.80,'2023-02-07 08:57:22','',''),(2029,'1','308','1',1,'Retail Sale Id 2102',35000.00,0.00,0.00,50.00,3500.00,'2023-02-07 09:09:16','',''),(2030,'1','308','1',1,'Retail Sale Id 2105',2220.00,0.00,0.00,3.00,330.00,'2023-02-07 09:11:45','',''),(2031,'1','308','1',1,'Retail Sale Id 2106',2960.00,0.00,0.00,4.00,440.00,'2023-02-07 09:15:33','',''),(2032,'1','308','1',1,'Retail Sale Id 2107',747.40,0.00,0.00,1.01,111.10,'2023-02-07 09:25:15','',''),(2033,'1','308','1',1,'Retail Sale Id 2109',747.40,0.00,0.00,1.01,111.10,'2023-02-07 09:34:02','',''),(2034,'1','308','1',1,'Retail Sale Id 2111',747.40,0.00,0.00,1.01,111.10,'2023-02-07 09:47:31','',''),(2035,'1','308','1',1,'Retail Sale Id 2113',1502.20,0.00,0.00,2.03,223.30,'2023-02-07 09:50:39','',''),(2036,'1','308','1',1,'Retail Sale Id 2114',8880.00,0.00,0.00,12.00,1320.00,'2023-02-07 09:53:38','',''),(2037,'1','308','1',1,'Retail Sale Id 2116',2960.00,0.00,0.00,4.00,440.00,'2023-02-07 10:37:16','',''),(2038,'1','308','1',1,'Retail Sale Id 2117',2960.00,0.00,0.00,4.00,440.00,'2023-02-07 11:16:57','',''),(2039,'1','308','1',1,'Retail Sale Id 2118',2249.60,0.00,0.00,3.04,334.40,'2023-02-07 11:39:50','',''),(2040,'1','308','1',1,'Retail Sale Id 2119',2997.00,0.00,0.00,4.05,445.50,'2023-02-07 11:43:12','',''),(2041,'1','308','1',1,'Retail Sale Id 2121',799.20,0.00,0.00,1.08,118.80,'2023-02-07 11:48:21','',''),(2042,'1','308','1',1,'Retail Sale Id 2122',4440.00,0.00,0.00,6.00,660.00,'2023-02-07 12:29:43','',''),(2043,'1','308','1',1,'Retail Sale Id 2123',17500.00,0.00,0.00,25.00,1750.00,'2023-02-07 12:34:15','',''),(2044,'1','308','1',1,'Retail Sale Id 2124',3700.00,0.00,0.00,5.00,550.00,'2023-02-07 12:43:52','',''),(2045,'1','308','1',1,'Retail Sale Id 2125',1502.20,0.00,0.00,2.03,223.30,'2023-02-07 12:53:43','',''),(2046,'1','308','1',1,'Retail Sale Id 2126',16650.00,0.00,0.00,22.50,2475.00,'2023-02-07 12:57:38','',''),(2047,'1','308','1',1,'Retail Sale Id 2127',3700.00,0.00,0.00,5.00,550.00,'2023-02-07 13:00:17','',''),(2048,'1','308','1',1,'Retail Sale Id 2128',35000.00,0.00,0.00,50.00,3500.00,'2023-02-07 13:19:14','',''),(2049,'1','308','1',1,'Retail Sale Id 2129',70000.00,0.00,0.00,100.00,7000.00,'2023-02-07 13:37:48','',''),(2050,'1','308','1',1,'Retail Sale Id 2131',3700.00,0.00,0.00,5.00,550.00,'2023-02-07 14:22:53','',''),(2051,'1','308','1',1,'Retail Sale Id 2132',9250.00,0.00,0.00,12.50,1375.00,'2023-02-07 15:04:18','',''),(2052,'1','308','1',1,'Retail Sale Id 2133',9250.00,0.00,0.00,12.50,1375.00,'2023-02-07 15:19:42','',''),(2053,'1','308','1',1,'Retail Sale Id 2134',747.40,0.00,0.00,1.01,111.10,'2023-02-07 15:20:56','',''),(2054,'1','308','1',1,'Retail Sale Id 2135',3700.00,0.00,0.00,5.00,550.00,'2023-02-07 15:32:24','',''),(2055,'1','308','1',1,'Retail Sale Id 2136',8880.00,0.00,0.00,12.00,1320.00,'2023-02-07 16:04:01','',''),(2056,'1','308','1',1,'Retail Sale Id 2137',1502.20,0.00,0.00,2.03,223.30,'2023-02-07 16:23:41','',''),(2057,'1','308','1',1,'Retail Sale Id 2138',70000.00,0.00,0.00,100.00,7000.00,'2023-02-07 16:38:38','',''),(2058,'1','308','1',1,'Retail Sale Id 2139',999.00,0.00,0.00,1.35,148.50,'2023-02-07 16:41:53','',''),(2059,'1','308','1',1,'Retail Sale Id 2140',2249.60,0.00,0.00,3.04,334.40,'2023-02-07 16:47:39','',''),(2060,'1','308','1',1,'Retail Sale Id 2141',2249.60,0.00,0.00,3.04,334.40,'2023-02-07 17:00:11','',''),(2061,'1','308','1',1,'Retail Sale Id 2142',3700.00,0.00,0.00,5.00,550.00,'2023-02-07 17:12:07','',''),(2062,'1','308','1',1,'Retail Sale Id 2143',1502.20,0.00,0.00,2.03,223.30,'2023-02-07 17:27:33','',''),(2063,'1','308','1',1,'Retail Sale Id 2144',2249.60,0.00,0.00,3.04,334.40,'2023-02-07 17:39:43','',''),(2064,'1','308','1',1,'Retail Sale Id 2145',1480.00,0.00,0.00,2.00,220.00,'2023-02-07 17:40:41','',''),(2065,'1','308','1',1,'Retail Sale Id 2146',2997.00,0.00,0.00,4.05,445.50,'2023-02-07 17:52:14','',''),(2066,'1','308','1',1,'Retail Sale Id 2147',3700.00,0.00,0.00,5.00,550.00,'2023-02-07 17:53:04','',''),(2067,'1','308','1',1,'Retail Sale Id 2148',3700.00,0.00,0.00,5.00,550.00,'2023-02-07 17:55:54','',''),(2068,'1','308','1',1,'Retail Sale Id 2149',5920.00,0.00,0.00,8.00,880.00,'2023-02-07 18:04:23','',''),(2069,'1','308','1',1,'Retail Sale Id 2150',2220.00,0.00,0.00,3.00,330.00,'2023-02-07 18:05:07','',''),(2070,'1','308','1',1,'Retail Sale Id 2151',4447.40,0.00,0.00,6.01,661.10,'2023-02-07 18:05:56','',''),(2071,'1','308','1',1,'Retail Sale Id 2152',4440.00,0.00,0.00,6.00,660.00,'2023-02-07 18:16:38','',''),(2072,'1','308','1',1,'Retail Sale Id 2154',31500.00,0.00,0.00,45.00,3150.00,'2023-02-07 18:19:07','',''),(2073,'1','308','1',1,'Retail Sale Id 2155',1502.20,0.00,0.00,2.03,223.30,'2023-02-07 18:20:22','',''),(2074,'1','308','1',1,'Retail Sale Id 2156',3700.00,0.00,0.00,5.00,550.00,'2023-02-07 18:21:16','',''),(2075,'1','308','1',1,'Retail Sale Id 2157',1702.00,0.00,0.00,2.30,253.00,'2023-02-07 19:37:44','',''),(2076,'1','308','1',1,'Retail Sale Id 2158',1975.80,0.00,0.00,2.67,293.70,'2023-02-07 20:00:02','',''),(2077,'1','308','1',1,'Retail Sale Id 2159',2220.00,0.00,0.00,3.00,330.00,'2023-02-08 07:39:04','',''),(2078,'1','308','1',1,'Retail Sale Id 2161',3700.00,0.00,0.00,5.00,550.00,'2023-02-08 08:09:09','',''),(2079,'1','308','1',1,'Retail Sale Id 2162',9250.00,0.00,0.00,12.50,1375.00,'2023-02-08 08:10:17','',''),(2080,'1','308','1',1,'Retail Sale Id 2163',3700.00,0.00,0.00,5.00,550.00,'2023-02-08 08:13:37','',''),(2081,'1','308','1',1,'Retail Sale Id 2164',4440.00,0.00,0.00,6.00,660.00,'2023-02-08 08:18:36','',''),(2082,'1','308','1',1,'Retail Sale Id 2165',1480.00,0.00,0.00,2.00,220.00,'2023-02-08 08:24:24','',''),(2083,'1','308','1',1,'Retail Sale Id 2166',2220.00,0.00,0.00,3.00,330.00,'2023-02-08 08:31:35','',''),(2084,'1','308','1',1,'Retail Sale Id 2167',9250.00,0.00,0.00,12.50,1375.00,'2023-02-08 08:40:01','',''),(2085,'1','308','1',1,'Retail Sale Id 2168',1502.20,0.00,0.00,2.03,223.30,'2023-02-08 09:11:49','',''),(2086,'1','308','1',1,'Retail Sale Id 2170',4447.40,0.00,0.00,6.01,661.10,'2023-02-08 09:16:42','',''),(2087,'1','308','1',1,'Retail Sale Id 2171',3700.00,0.00,0.00,5.00,550.00,'2023-02-08 09:40:32','',''),(2088,'1','308','1',1,'Retail Sale Id 2172',5180.00,0.00,0.00,7.00,770.00,'2023-02-08 09:44:13','',''),(2089,'1','308','1',1,'Retail Sale Id 2173',2249.60,0.00,0.00,3.04,334.40,'2023-02-08 09:47:06','',''),(2090,'1','308','1',1,'Retail Sale Id 2174',2997.00,0.00,0.00,4.05,445.50,'2023-02-08 09:51:42','',''),(2091,'1','308','1',1,'Retail Sale Id 2175',2220.00,0.00,0.00,3.00,330.00,'2023-02-08 10:01:20','',''),(2092,'1','308','1',1,'Retail Sale Id 2176',2220.00,0.00,0.00,3.00,330.00,'2023-02-08 10:10:12','',''),(2093,'1','308','1',1,'Retail Sale Id 2177',8880.00,0.00,0.00,12.00,1320.00,'2023-02-08 11:54:35','',''),(2094,'1','308','1',1,'Retail Sale Id 2179',2227.40,0.00,0.00,3.01,331.10,'2023-02-08 11:57:37','',''),(2095,'1','308','1',1,'Retail Sale Id 2180',747.40,0.00,0.00,1.01,111.10,'2023-02-08 12:10:14','',''),(2096,'1','308','1',1,'Retail Sale Id 2181',5920.00,0.00,0.00,8.00,880.00,'2023-02-08 13:01:36','',''),(2097,'1','308','1',1,'Retail Sale Id 2183',3700.00,0.00,0.00,5.00,550.00,'2023-02-08 13:21:05','',''),(2098,'1','308','1',1,'Retail Sale Id 2186',5920.00,0.00,0.00,8.00,880.00,'2023-02-08 13:37:04','',''),(2099,'1','308','1',1,'Retail Sale Id 2187',5180.00,0.00,0.00,7.00,770.00,'2023-02-08 13:39:21','',''),(2100,'1','308','1',1,'Retail Sale Id 2188',2220.00,0.00,0.00,3.00,330.00,'2023-02-08 14:00:21','',''),(2101,'1','308','1',1,'Retail Sale Id 2189',1998.00,0.00,0.00,2.70,297.00,'2023-02-08 14:36:06','',''),(2102,'1','308','1',1,'Retail Sale Id 2190',9250.00,0.00,0.00,12.50,1375.00,'2023-02-08 14:42:17','',''),(2103,'1','308','1',1,'Retail Sale Id 2191',1502.20,0.00,0.00,2.03,223.30,'2023-02-08 14:57:16','',''),(2104,'1','308','1',1,'Retail Sale Id 2192',747.40,0.00,0.00,1.01,111.10,'2023-02-08 15:12:19','',''),(2105,'1','308','1',1,'Retail Sale Id 2193',2220.00,0.00,0.00,3.00,330.00,'2023-02-08 15:33:16','',''),(2106,'1','308','1',1,'Retail Sale Id 2194',2220.00,0.00,0.00,3.00,330.00,'2023-02-08 15:38:58','',''),(2107,'1','308','1',1,'Retail Sale Id 2196',1502.20,0.00,0.00,2.03,223.30,'2023-02-08 15:50:18','',''),(2108,'1','308','1',1,'Retail Sale Id 2197',2227.40,0.00,0.00,3.01,331.10,'2023-02-08 16:16:27','',''),(2109,'1','308','1',1,'Retail Sale Id 2198',1502.20,0.00,0.00,2.03,223.30,'2023-02-08 17:04:09','',''),(2110,'1','308','1',1,'Retail Sale Id 2199',740.00,0.00,0.00,1.00,110.00,'2023-02-08 17:12:16','',''),(2111,'1','308','1',1,'Retail Sale Id 2200',2997.00,0.00,0.00,4.05,445.50,'2023-02-08 17:16:58','',''),(2112,'1','308','1',1,'Retail Sale Id 2201',4440.00,0.00,0.00,6.00,660.00,'2023-02-08 17:24:00','',''),(2113,'1','308','1',1,'Retail Sale Id 2202',4440.00,0.00,0.00,6.00,660.00,'2023-02-08 17:24:43','',''),(2114,'1','308','1',1,'Retail Sale Id 2203',740.00,0.00,0.00,1.00,110.00,'2023-02-08 17:25:34','',''),(2115,'1','308','1',1,'Return of Retail Sale Id 2190',0.00,9250.00,12.50,0.00,-1375.00,'2023-02-08 18:13:23','',''),(2116,'1','308','1',1,'Return of Retail Sale Id 2170',0.00,4447.40,6.01,0.00,-661.10,'2023-02-08 18:14:33','',''),(2117,'1','308','1',1,'Retail Sale Id 2204',333.00,0.00,0.00,0.45,49.50,'2023-02-08 18:15:23','',''),(2118,'1','308','1',1,'Retail Sale Id 2205',1502.20,0.00,0.00,2.03,223.30,'2023-02-09 08:13:02','',''),(2119,'1','308','1',1,'Retail Sale Id 2209',1502.20,0.00,0.00,2.03,223.30,'2023-02-09 08:26:07','',''),(2120,'1','308','1',1,'Retail Sale Id 2211',5202.20,0.00,0.00,7.03,773.30,'2023-02-09 11:33:24','',''),(2121,'1','308','1',1,'Retail Sale Id 2212',35150.00,0.00,0.00,47.50,5225.00,'2023-02-09 11:35:47','',''),(2122,'1','308','1',1,'Retail Sale Id 2213',6697.00,0.00,0.00,9.05,995.50,'2023-02-09 11:50:28','',''),(2123,'1','308','1',1,'Retail Sale Id 2214',2220.00,0.00,0.00,3.00,330.00,'2023-02-09 18:14:29','',''),(2124,'1','308','1',1,'Retail Sale Id 2215',1198.80,0.00,0.00,1.62,178.20,'2023-02-09 18:18:46','',''),(2125,'1','308','1',1,'Retail Sale Id 2216',747.40,0.00,0.00,1.01,111.10,'2023-02-09 18:19:40','',''),(2126,'1','308','1',1,'Retail Sale Id 2217',2960.00,0.00,0.00,4.00,440.00,'2023-02-09 18:32:04','',''),(2127,'1','308','1',1,'Retail Sale Id 2218',999.00,0.00,0.00,1.35,148.50,'2023-02-09 18:33:40','',''),(2128,'1','308','1',1,'Retail Sale Id 2219',5180.00,0.00,0.00,7.00,770.00,'2023-02-09 18:51:06','',''),(2129,'1','308','1',1,'Retail Sale Id 2220',2249.60,0.00,0.00,3.04,334.40,'2023-02-09 18:56:05','',''),(2130,'1','308','1',1,'Retail Sale Id 2221',4447.40,0.00,0.00,6.01,661.10,'2023-02-09 19:09:45','',''),(2131,'1','308','1',1,'Retail Sale Id 2222',3700.00,0.00,0.00,5.00,550.00,'2023-02-10 08:41:03','',''),(2132,'1','308','1',1,'Retail Sale Id 2224',3700.00,0.00,0.00,5.00,550.00,'2023-02-10 09:15:32','',''),(2133,'1','308','1',1,'Retail Sale Id 2226',2220.00,0.00,0.00,3.00,330.00,'2023-02-10 09:19:31','',''),(2134,'1','308','1',1,'Retail Sale Id 2227',1502.20,0.00,0.00,2.03,223.30,'2023-02-10 09:21:02','',''),(2135,'1','308','1',1,'Retail Sale Id 2228',2220.00,0.00,0.00,3.00,330.00,'2023-02-10 09:23:59','',''),(2136,'1','308','1',1,'Retail Sale Id 2229',2960.00,0.00,0.00,4.00,440.00,'2023-02-10 09:25:30','',''),(2137,'1','308','1',1,'Retail Sale Id 2230',4440.00,0.00,0.00,6.00,660.00,'2023-02-10 09:29:39','',''),(2138,'1','308','1',1,'Retail Sale Id 2232',2220.00,0.00,0.00,3.00,330.00,'2023-02-10 10:24:28','',''),(2139,'1','308','1',1,'Retail Sale Id 2233',1502.20,0.00,0.00,2.03,223.30,'2023-02-10 10:32:51','',''),(2140,'1','308','1',1,'Retail Sale Id 2234',34000.00,0.00,0.00,50.00,2500.00,'2023-02-10 11:02:22','',''),(2141,'1','308','1',1,'Retail Sale Id 2235',2997.00,0.00,0.00,4.05,445.50,'2023-02-10 11:51:12','',''),(2142,'1','308','1',1,'Retail Sale Id 2236',3700.00,0.00,0.00,5.00,550.00,'2023-02-10 12:43:33','',''),(2143,'1','308','1',1,'Retail Sale Id 2237',1502.20,0.00,0.00,2.03,223.30,'2023-02-10 13:11:30','',''),(2144,'1','308','1',1,'Retail Sale Id 2238',4440.00,0.00,0.00,6.00,660.00,'2023-02-10 13:15:05','',''),(2145,'1','308','1',1,'Retail Sale Id 2239',2501.20,0.00,0.00,3.38,371.80,'2023-02-10 13:20:14','',''),(2146,'1','308','1',1,'Retail Sale Id 2240',7400.00,0.00,0.00,10.00,1100.00,'2023-02-10 13:23:39','',''),(2147,'1','308','1',1,'Retail Sale Id 2241',20400.00,0.00,0.00,30.00,1500.00,'2023-02-10 13:58:00','',''),(2148,'1','308','1',1,'Retail Sale Id 2242',1502.20,0.00,0.00,2.03,223.30,'2023-02-10 14:07:37','',''),(2149,'1','308','1',1,'Retail Sale Id 2243',8880.00,0.00,0.00,12.00,1320.00,'2023-02-10 14:23:17','',''),(2150,'1','308','1',1,'Retail Sale Id 2245',747.40,0.00,0.00,1.01,111.10,'2023-02-10 14:50:32','',''),(2151,'1','308','1',1,'Retail Sale Id 2246',3700.00,0.00,0.00,5.00,550.00,'2023-02-10 14:52:45','',''),(2152,'1','308','1',1,'Retail Sale Id 2249',747.40,0.00,0.00,1.01,111.10,'2023-02-10 15:17:20','',''),(2153,'1','308','1',1,'Retail Sale Id 2250',1502.20,0.00,0.00,2.03,223.30,'2023-02-10 15:24:14','',''),(2154,'1','308','1',1,'Retail Sale Id 2251',5920.00,0.00,0.00,8.00,880.00,'2023-02-10 15:35:22','',''),(2155,'1','308','1',1,'Retail Sale Id 2252',2960.00,0.00,0.00,4.00,440.00,'2023-02-10 15:38:00','',''),(2156,'1','308','1',1,'Retail Sale Id 2253',2997.00,0.00,0.00,4.05,445.50,'2023-02-10 15:40:19','',''),(2157,'1','308','1',1,'Retail Sale Id 2254',2997.00,0.00,0.00,4.05,445.50,'2023-02-10 16:23:18','',''),(2158,'1','308','1',1,'Retail Sale Id 2255',2220.00,0.00,0.00,3.00,330.00,'2023-02-10 16:30:16','',''),(2159,'1','308','1',1,'Retail Sale Id 2256',1502.20,0.00,0.00,2.03,223.30,'2023-02-10 16:33:16','',''),(2160,'1','308','1',1,'Retail Sale Id 2257',1502.20,0.00,0.00,2.03,223.30,'2023-02-10 16:35:16','',''),(2161,'1','308','1',1,'Retail Sale Id 2258',747.40,0.00,0.00,1.01,111.10,'2023-02-10 16:54:17','',''),(2162,'1','308','1',1,'Retail Sale Id 2259',2220.00,0.00,0.00,3.00,330.00,'2023-02-10 17:33:23','',''),(2163,'1','308','1',1,'Retail Sale Id 2260',1502.20,0.00,0.00,2.03,223.30,'2023-02-10 17:48:18','',''),(2164,'1','308','1',1,'Retail Sale Id 2261',2220.00,0.00,0.00,3.00,330.00,'2023-02-10 17:54:44','',''),(2165,'1','308','1',1,'Retail Sale Id 2262',2997.00,0.00,0.00,4.05,445.50,'2023-02-10 18:05:39','',''),(2166,'1','308','1',1,'Retail Sale Id 2263',1502.20,0.00,0.00,2.03,223.30,'2023-02-10 18:09:34','',''),(2167,'1','308','1',1,'Retail Sale Id 2264',740.00,0.00,0.00,1.00,110.00,'2023-02-10 18:19:17','',''),(2168,'1','308','1',1,'Retail Sale Id 2265',4469.60,0.00,0.00,6.04,664.40,'2023-02-10 19:37:58','',''),(2169,'1','308','1',1,'Retail Sale Id 2266',4440.00,0.00,0.00,6.00,660.00,'2023-02-11 07:53:32','',''),(2170,'1','308','1',1,'Retail Sale Id 2267',4440.00,0.00,0.00,6.00,660.00,'2023-02-11 07:54:42','',''),(2171,'1','308','1',1,'Retail Sale Id 2268',740.00,0.00,0.00,1.00,110.00,'2023-02-11 07:57:09','',''),(2172,'1','308','1',1,'Retail Sale Id 2270',68000.00,0.00,0.00,100.00,5000.00,'2023-02-11 07:58:50','',''),(2173,'1','308','1',1,'Retail Sale Id 2271',1502.20,0.00,0.00,2.03,223.30,'2023-02-11 07:59:56','',''),(2174,'1','308','1',1,'Retail Sale Id 2272',68000.00,0.00,0.00,100.00,5000.00,'2023-02-11 08:02:47','',''),(2175,'1','308','1',1,'Retail Sale Id 2273',4440.00,0.00,0.00,6.00,660.00,'2023-02-11 08:04:58','',''),(2176,'1','308','1',1,'Retail Sale Id 2276',3700.00,0.00,0.00,5.00,550.00,'2023-02-11 08:07:22','',''),(2177,'1','308','1',1,'Retail Sale Id 2277',9250.00,0.00,0.00,12.50,1375.00,'2023-02-11 08:09:57','',''),(2178,'1','308','1',1,'Retail Sale Id 2279',5180.00,0.00,0.00,7.00,770.00,'2023-02-11 08:14:37','',''),(2179,'1','308','1',1,'Retail Sale Id 2280',68000.00,0.00,0.00,100.00,5000.00,'2023-02-11 08:30:22','',''),(2180,'1','308','1',1,'Retail Sale Id 2281',1502.20,0.00,0.00,2.03,223.30,'2023-02-11 08:41:28','',''),(2181,'1','308','1',1,'Retail Sale Id 2282',3700.00,0.00,0.00,5.00,550.00,'2023-02-11 08:44:10','',''),(2182,'1','308','1',1,'Retail Sale Id 2283',4440.00,0.00,0.00,6.00,660.00,'2023-02-11 08:58:50','',''),(2183,'1','308','1',1,'Retail Sale Id 2285',2220.00,0.00,0.00,3.00,330.00,'2023-02-11 09:01:51','',''),(2184,'1','308','1',1,'Retail Sale Id 2286',2249.60,0.00,0.00,3.04,334.40,'2023-02-11 09:04:07','',''),(2185,'1','308','1',1,'Retail Sale Id 2287',4440.00,0.00,0.00,6.00,660.00,'2023-02-11 09:18:06','',''),(2186,'1','308','1',1,'Retail Sale Id 2288',2220.00,0.00,0.00,3.00,330.00,'2023-02-11 09:27:14','',''),(2187,'1','308','1',1,'Retail Sale Id 2289',1502.20,0.00,0.00,2.03,223.30,'2023-02-11 09:29:16','',''),(2188,'1','308','1',1,'Retail Sale Id 2290',747.40,0.00,0.00,1.01,111.10,'2023-02-11 09:31:50','',''),(2189,'1','308','1',1,'Retail Sale Id 2291',1502.20,0.00,0.00,2.03,223.30,'2023-02-11 09:33:33','',''),(2190,'1','308','1',1,'Retail Sale Id 2293',2997.00,0.00,0.00,4.05,445.50,'2023-02-11 09:35:44','',''),(2191,'1','308','1',1,'Retail Sale Id 2294',4447.40,0.00,0.00,6.01,661.10,'2023-02-11 09:37:41','',''),(2192,'1','308','1',1,'Retail Sale Id 2295',4440.00,0.00,0.00,6.00,660.00,'2023-02-11 09:39:10','',''),(2193,'1','308','1',1,'Retail Sale Id 2296',4440.00,0.00,0.00,6.00,660.00,'2023-02-11 09:46:57','',''),(2194,'1','308','1',1,'Retail Sale Id 2298',4440.00,0.00,0.00,6.00,660.00,'2023-02-11 10:16:30','',''),(2195,'1','308','1',1,'Retail Sale Id 2299',6001.40,0.00,0.00,8.11,892.10,'2023-02-11 10:19:03','',''),(2196,'1','308','1',1,'Retail Sale Id 2300',9250.00,0.00,0.00,12.50,1375.00,'2023-02-11 10:34:30','',''),(2197,'1','308','1',1,'Retail Sale Id 2302',1502.20,0.00,0.00,2.03,223.30,'2023-02-11 10:38:09','',''),(2198,'1','308','1',1,'Return of Retail Sale Id 2299',0.00,6001.40,8.11,0.00,-892.10,'2023-02-11 10:45:15','',''),(2199,'1','308','1',1,'Retail Sale Id 2304',2249.60,0.00,0.00,3.04,334.40,'2023-02-11 10:53:26','',''),(2200,'1','308','1',1,'Retail Sale Id 2305',3700.00,0.00,0.00,5.00,550.00,'2023-02-11 11:14:28','',''),(2201,'1','308','1',1,'Retail Sale Id 2307',1502.20,0.00,0.00,2.03,223.30,'2023-02-11 11:25:14','',''),(2202,'1','308','1',1,'Retail Sale Id 2308',1502.20,0.00,0.00,2.03,223.30,'2023-02-11 11:26:36','',''),(2203,'1','308','1',1,'Retail Sale Id 2309',747.40,0.00,0.00,1.01,111.10,'2023-02-11 11:27:53','',''),(2204,'1','308','1',1,'Retail Sale Id 2310',2960.00,0.00,0.00,4.00,440.00,'2023-02-11 11:30:20','',''),(2205,'1','308','1',1,'Retail Sale Id 2312',5180.00,0.00,0.00,7.00,770.00,'2023-02-11 11:37:28','',''),(2206,'1','308','1',1,'Retail Sale Id 2313',3700.00,0.00,0.00,5.00,550.00,'2023-02-11 11:39:04','',''),(2207,'1','308','1',1,'Retail Sale Id 2314',2960.00,0.00,0.00,4.00,440.00,'2023-02-11 11:41:17','',''),(2208,'1','308','1',1,'Retail Sale Id 2317',1502.20,0.00,0.00,2.03,223.30,'2023-02-11 11:44:46','',''),(2209,'1','308','1',1,'Retail Sale Id 2318',23800.00,0.00,0.00,35.00,1750.00,'2023-02-11 11:49:35','',''),(2210,'1','308','1',1,'Retail Sale Id 2319',34000.00,0.00,0.00,50.00,2500.00,'2023-02-11 11:54:14','',''),(2211,'1','308','1',1,'Retail Sale Id 2320',4440.00,0.00,0.00,6.00,660.00,'2023-02-11 12:03:42','',''),(2212,'1','308','1',1,'Retail Sale Id 2321',78880.00,0.00,0.00,116.00,5800.00,'2023-02-11 12:07:28','',''),(2213,'1','308','1',1,'Retail Sale Id 2323',1502.20,0.00,0.00,2.03,223.30,'2023-02-11 12:11:19','',''),(2214,'1','308','1',1,'Retail Sale Id 2324',9250.00,0.00,0.00,12.50,1375.00,'2023-02-11 12:13:11','',''),(2215,'1','308','1',1,'Retail Sale Id 2325',2220.00,0.00,0.00,3.00,330.00,'2023-02-11 12:15:18','',''),(2216,'1','308','1',1,'Retail Sale Id 2326',2997.00,0.00,0.00,4.05,445.50,'2023-02-11 12:37:07','',''),(2217,'1','308','1',1,'Retail Sale Id 2327',9250.00,0.00,0.00,12.50,1375.00,'2023-02-11 12:41:59','',''),(2218,'1','308','1',1,'Return of Retail Sale Id 2272',0.00,68000.00,100.00,0.00,-5000.00,'2023-02-11 12:47:47','',''),(2219,'1','308','1',1,'Retail Sale Id 2328',4440.00,0.00,0.00,6.00,660.00,'2023-02-11 12:58:11','',''),(2220,'1','308','1',1,'Retail Sale Id 2329',3700.00,0.00,0.00,5.00,550.00,'2023-02-11 12:59:32','',''),(2221,'1','308','1',1,'Retail Sale Id 2330',4447.40,0.00,0.00,6.01,661.10,'2023-02-11 13:08:17','',''),(2222,'1','308','1',1,'Retail Sale Id 2331',4447.40,0.00,0.00,6.01,661.10,'2023-02-11 13:14:52','',''),(2223,'1','308','1',1,'Retail Sale Id 2332',2220.00,0.00,0.00,3.00,330.00,'2023-02-11 13:18:48','',''),(2224,'1','308','1',1,'Retail Sale Id 2333',2960.00,0.00,0.00,4.00,440.00,'2023-02-11 13:37:15','',''),(2225,'1','308','1',1,'Retail Sale Id 2335',1502.20,0.00,0.00,2.03,223.30,'2023-02-11 13:45:53','',''),(2226,'1','308','1',1,'Retail Sale Id 2336',34000.00,0.00,0.00,50.00,2500.00,'2023-02-11 13:52:33','',''),(2227,'1','308','1',1,'Retail Sale Id 2337',7400.00,0.00,0.00,10.00,1100.00,'2023-02-11 13:56:22','',''),(2228,'1','308','1',1,'Retail Sale Id 2338',1502.20,0.00,0.00,2.03,223.30,'2023-02-11 14:11:50','',''),(2229,'1','308','1',1,'Retail Sale Id 2339',4440.00,0.00,0.00,6.00,660.00,'2023-02-11 14:14:12','',''),(2230,'1','308','1',1,'Retail Sale Id 2340',4440.00,0.00,0.00,6.00,660.00,'2023-02-11 14:15:59','',''),(2231,'1','308','1',1,'Retail Sale Id 2341',5313.20,0.00,0.00,7.18,789.80,'2023-02-11 17:38:51','',''),(2232,'1','308','1',1,'Retail Sale Id 2342',1502.20,0.00,0.00,2.03,223.30,'2023-02-12 07:43:09','',''),(2233,'1','308','1',1,'Retail Sale Id 2343',2960.00,0.00,0.00,4.00,440.00,'2023-02-12 07:44:09','',''),(2234,'1','308','1',1,'Retail Sale Id 2344',9250.00,0.00,0.00,12.50,1375.00,'2023-02-12 07:46:57','',''),(2235,'1','308','1',1,'Retail Sale Id 2345',1502.20,0.00,0.00,2.03,223.30,'2023-02-12 07:50:05','',''),(2236,'1','308','1',1,'Retail Sale Id 2346',2960.00,0.00,0.00,4.00,440.00,'2023-02-12 07:52:36','',''),(2237,'1','308','1',1,'Retail Sale Id 2347',9250.00,0.00,0.00,12.50,1375.00,'2023-02-12 07:54:00','',''),(2238,'1','308','1',1,'Retail Sale Id 2348',68000.00,0.00,0.00,100.00,5000.00,'2023-02-12 07:57:44','',''),(2239,'1','308','1',1,'Retail Sale Id 2349',1502.20,0.00,0.00,2.03,223.30,'2023-02-12 07:59:46','',''),(2240,'1','308','1',1,'Retail Sale Id 2350',9250.00,0.00,0.00,12.50,1375.00,'2023-02-12 08:06:45','',''),(2241,'1','308','1',1,'Retail Sale Id 2351',999.00,0.00,0.00,1.35,148.50,'2023-02-12 08:08:06','',''),(2242,'1','308','1',1,'Retail Sale Id 2352',1502.20,0.00,0.00,2.03,223.30,'2023-02-12 08:09:26','',''),(2243,'1','308','1',1,'Retail Sale Id 2353',2960.00,0.00,0.00,4.00,440.00,'2023-02-12 08:11:31','',''),(2244,'1','308','1',1,'Retail Sale Id 2354',2220.00,0.00,0.00,3.00,330.00,'2023-02-12 08:16:19','',''),(2245,'1','308','1',1,'Retail Sale Id 2356',3700.00,0.00,0.00,5.00,550.00,'2023-02-12 08:18:03','',''),(2246,'1','308','1',1,'Retail Sale Id 2357',2501.20,0.00,0.00,3.38,371.80,'2023-02-12 08:19:29','',''),(2247,'1','308','1',1,'Retail Sale Id 2360',2220.00,0.00,0.00,3.00,330.00,'2023-02-12 08:26:56','',''),(2248,'1','308','1',1,'Retail Sale Id 2361',3700.00,0.00,0.00,5.00,550.00,'2023-02-12 08:28:24','',''),(2249,'1','308','1',1,'Retail Sale Id 2362',4440.00,0.00,0.00,6.00,660.00,'2023-02-12 08:33:44','',''),(2250,'1','308','1',1,'Retail Sale Id 2363',1502.20,0.00,0.00,2.03,223.30,'2023-02-12 08:35:04','',''),(2251,'1','308','1',1,'Retail Sale Id 2364',2220.00,0.00,0.00,3.00,330.00,'2023-02-12 08:36:50','',''),(2252,'1','308','1',1,'Retail Sale Id 2365',740.00,0.00,0.00,1.00,110.00,'2023-02-12 08:38:11','',''),(2253,'1','308','1',1,'Retail Sale Id 2366',2997.00,0.00,0.00,4.05,445.50,'2023-02-12 08:39:34','',''),(2254,'1','308','1',1,'Retail Sale Id 2367',4440.00,0.00,0.00,6.00,660.00,'2023-02-12 08:42:39','',''),(2255,'1','308','1',1,'Retail Sale Id 2368',740.00,0.00,0.00,1.00,110.00,'2023-02-12 08:45:58','',''),(2256,'1','308','1',1,'Retail Sale Id 2369',1480.00,0.00,0.00,2.00,220.00,'2023-02-12 08:47:15','',''),(2257,'1','308','1',1,'Retail Sale Id 2371',1502.20,0.00,0.00,2.03,223.30,'2023-02-12 08:52:15','',''),(2258,'1','308','1',1,'Retail Sale Id 2372',747.40,0.00,0.00,1.01,111.10,'2023-02-12 08:53:29','',''),(2259,'1','308','1',1,'Retail Sale Id 2373',2197.80,0.00,0.00,2.97,326.70,'2023-02-12 08:56:24','',''),(2260,'1','308','1',1,'Retail Sale Id 2374',1502.20,0.00,0.00,2.03,223.30,'2023-02-12 08:58:42','',''),(2261,'1','308','1',1,'Retail Sale Id 2375',2220.00,0.00,0.00,3.00,330.00,'2023-02-12 09:01:29','',''),(2262,'1','308','1',1,'Retail Sale Id 2377',2227.40,0.00,0.00,3.01,331.10,'2023-02-12 09:14:54','',''),(2263,'1','308','1',1,'Retail Sale Id 2379',747.40,0.00,0.00,1.01,111.10,'2023-02-12 09:21:47','',''),(2264,'1','308','1',1,'Retail Sale Id 2381',3700.00,0.00,0.00,5.00,550.00,'2023-02-12 09:29:44','',''),(2265,'1','308','1',1,'Retail Sale Id 2387',2997.00,0.00,0.00,4.05,445.50,'2023-02-12 09:42:24','',''),(2266,'1','308','1',1,'Return of Retail Sale Id 2387',0.00,2997.00,4.05,0.00,-445.50,'2023-02-12 09:43:51','',''),(2267,'1','308','1',1,'Retail Sale Id 2389',7400.00,0.00,0.00,10.00,1100.00,'2023-02-12 09:52:27','',''),(2268,'1','308','1',1,'Retail Sale Id 2390',2397.60,0.00,0.00,3.24,356.40,'2023-02-12 09:56:03','',''),(2269,'1','308','1',1,'Retail Sale Id 2392',2220.00,0.00,0.00,3.00,330.00,'2023-02-12 10:09:35','',''),(2270,'1','308','1',1,'Retail Sale Id 2393',1502.20,0.00,0.00,2.03,223.30,'2023-02-12 10:12:45','',''),(2271,'1','308','1',1,'Return of Retail Sale Id 2366',0.00,2997.00,4.05,0.00,-445.50,'2023-02-12 10:17:22','',''),(2272,'1','308','1',1,'Retail Sale Id 2396',4440.00,0.00,0.00,6.00,660.00,'2023-02-12 10:24:28','',''),(2273,'1','308','1',1,'Return of Retail Sale Id 2375',0.00,2220.00,3.00,0.00,-330.00,'2023-02-12 10:26:48','',''),(2274,'1','308','1',1,'Retail Sale Id 2398',2960.00,0.00,0.00,4.00,440.00,'2023-02-12 10:30:20','',''),(2275,'1','308','1',1,'Retail Sale Id 2399',2220.00,0.00,0.00,3.00,330.00,'2023-02-12 10:32:04','',''),(2276,'1','308','1',1,'Retail Sale Id 2403',2960.00,0.00,0.00,4.00,440.00,'2023-02-12 10:39:08','',''),(2277,'1','308','1',1,'Retail Sale Id 2405',13690.00,0.00,0.00,18.50,2035.00,'2023-02-12 10:45:16','',''),(2278,'1','308','1',1,'Return of Retail Sale Id 2403',0.00,2960.00,4.00,0.00,-440.00,'2023-02-12 10:47:22','',''),(2279,'1','308','1',1,'Retail Sale Id 2407',1998.00,0.00,0.00,2.70,297.00,'2023-02-12 10:53:30','',''),(2280,'1','308','1',1,'Retail Sale Id 2408',4447.40,0.00,0.00,6.01,661.10,'2023-02-12 11:06:11','',''),(2281,'1','308','1',1,'Retail Sale Id 2409',2249.60,0.00,0.00,3.04,334.40,'2023-02-12 11:12:56','',''),(2282,'1','308','1',1,'Retail Sale Id 2410',1502.20,0.00,0.00,2.03,223.30,'2023-02-12 11:17:18','',''),(2283,'1','308','1',1,'Retail Sale Id 2411',740.00,0.00,0.00,1.00,110.00,'2023-02-12 11:33:47','',''),(2284,'1','308','1',1,'Retail Sale Id 2412',747.40,0.00,0.00,1.01,111.10,'2023-02-12 11:36:08','',''),(2285,'1','308','1',1,'Retail Sale Id 2414',1502.20,0.00,0.00,2.03,223.30,'2023-02-12 11:37:43','',''),(2286,'1','308','1',1,'Retail Sale Id 2415',12580.00,0.00,0.00,17.00,1870.00,'2023-02-12 12:07:28','',''),(2287,'1','308','1',1,'Retail Sale Id 2416',68000.00,0.00,0.00,100.00,5000.00,'2023-02-12 12:12:49','',''),(2288,'1','308','1',1,'Retail Sale Id 2417',1998.00,0.00,0.00,2.70,297.00,'2023-02-12 12:22:00','',''),(2289,'1','308','1',1,'Retail Sale Id 2418',3700.00,0.00,0.00,5.00,550.00,'2023-02-12 12:23:58','',''),(2290,'1','308','1',1,'Retail Sale Id 2419',3700.00,0.00,0.00,5.00,550.00,'2023-02-12 12:49:03','',''),(2291,'1','308','1',1,'Retail Sale Id 2420',2220.00,0.00,0.00,3.00,330.00,'2023-02-12 12:54:52','',''),(2292,'1','308','1',1,'Return of Retail Sale Id 2420',0.00,2220.00,3.00,0.00,-330.00,'2023-02-12 13:07:20','',''),(2293,'1','308','1',1,'Return of Retail Sale Id 2419',0.00,3700.00,5.00,0.00,-550.00,'2023-02-12 13:07:57','',''),(2294,'1','308','1',1,'Retail Sale Id 2422',865.80,0.00,0.00,1.17,128.70,'2023-02-12 15:44:59','',''),(2295,'1','308','1',1,'Retail Sale Id 2423',9250.00,0.00,0.00,12.50,1375.00,'2023-02-15 17:50:24','',''),(2296,'1','308','1',1,'Retail Sale Id 2424',1502.20,0.00,0.00,2.03,223.30,'2023-02-15 17:51:57','',''),(2297,'1','308','1',1,'Retail Sale Id 2425',1502.20,0.00,0.00,2.03,223.30,'2023-02-15 17:56:45','',''),(2298,'1','308','1',1,'Retail Sale Id 2426',740.00,0.00,0.00,1.00,110.00,'2023-02-15 18:14:01','',''),(2299,'1','308','1',1,'Retail Sale Id 2427',4440.00,0.00,0.00,6.00,660.00,'2023-02-15 18:18:05','',''),(2300,'1','308','1',1,'Retail Sale Id 2428',6800.00,0.00,0.00,10.00,500.00,'2023-02-15 18:20:23','',''),(2301,'1','308','1',1,'Retail Sale Id 2429',4440.00,0.00,0.00,6.00,660.00,'2023-02-15 18:22:46','',''),(2302,'1','308','1',1,'Retail Sale Id 2430',1502.20,0.00,0.00,2.03,223.30,'2023-02-15 18:24:07','',''),(2303,'1','308','1',1,'Retail Sale Id 2431',799.20,0.00,0.00,1.08,118.80,'2023-02-15 18:25:42','',''),(2304,'1','308','1',1,'Retail Sale Id 2432',5180.00,0.00,0.00,7.00,770.00,'2023-02-15 18:27:41','',''),(2305,'1','308','1',1,'Retail Sale Id 2433',1502.20,0.00,0.00,2.03,223.30,'2023-02-15 18:28:34','',''),(2306,'1','308','1',1,'Retail Sale Id 2434',2960.00,0.00,0.00,4.00,440.00,'2023-02-15 18:35:06','',''),(2307,'1','308','1',1,'Retail Sale Id 2435',3700.00,0.00,0.00,5.00,550.00,'2023-02-15 18:42:43','',''),(2308,'1','308','1',1,'Retail Sale Id 2436',2220.00,0.00,0.00,3.00,330.00,'2023-02-15 18:44:56','',''),(2309,'1','308','1',1,'Retail Sale Id 2437',2220.00,0.00,0.00,3.00,330.00,'2023-02-15 18:56:42','',''),(2310,'1','308','1',1,'Retail Sale Id 2438',4440.00,0.00,0.00,6.00,660.00,'2023-02-15 18:59:13','',''),(2311,'1','308','1',1,'Retail Sale Id 2439',1509.60,0.00,0.00,2.04,224.40,'2023-02-15 19:09:58','',''),(2312,'1','308','1',1,'Retail Sale Id 2440',1502.20,0.00,0.00,2.03,223.30,'2023-02-16 07:14:34','',''),(2313,'1','308','1',1,'Retail Sale Id 2441',5180.00,0.00,0.00,7.00,770.00,'2023-02-16 07:21:48','',''),(2314,'1','308','1',1,'Retail Sale Id 2442',1480.00,0.00,0.00,2.00,220.00,'2023-02-16 07:32:01','',''),(2315,'1','308','1',1,'Retail Sale Id 2443',1502.20,0.00,0.00,2.03,223.30,'2023-02-16 07:49:57','',''),(2316,'1','308','1',1,'Retail Sale Id 2445',747.40,0.00,0.00,1.01,111.10,'2023-02-16 08:10:36','',''),(2317,'1','308','1',1,'Retail Sale Id 2446',2997.00,0.00,0.00,4.05,445.50,'2023-02-16 08:27:48','',''),(2318,'1','308','1',1,'Retail Sale Id 2447',4440.00,0.00,0.00,6.00,660.00,'2023-02-16 08:41:25','',''),(2319,'1','308','1',1,'Retail Sale Id 2448',2220.00,0.00,0.00,3.00,330.00,'2023-02-16 08:44:13','',''),(2320,'1','308','1',1,'Retail Sale Id 2449',747.40,0.00,0.00,1.01,111.10,'2023-02-16 08:50:27','',''),(2321,'1','308','1',1,'Return of Retail Sale Id 2448',0.00,2220.00,3.00,0.00,-330.00,'2023-02-16 08:55:17','',''),(2322,'1','308','1',1,'Retail Sale Id 2451',1480.00,0.00,0.00,2.00,220.00,'2023-02-16 09:14:27','',''),(2323,'1','308','1',1,'Retail Sale Id 2452',747.40,0.00,0.00,1.01,111.10,'2023-02-16 09:17:30','',''),(2324,'1','308','1',1,'Retail Sale Id 2453',1480.00,0.00,0.00,2.00,220.00,'2023-02-16 09:23:42','',''),(2325,'1','308','1',1,'Retail Sale Id 2454',34000.00,0.00,0.00,50.00,2500.00,'2023-02-16 09:44:01','',''),(2326,'1','308','1',1,'Retail Sale Id 2455',2220.00,0.00,0.00,3.00,330.00,'2023-02-16 10:07:31','',''),(2327,'1','308','1',1,'Retail Sale Id 2456',799.20,0.00,0.00,1.08,118.80,'2023-02-16 10:08:37','',''),(2328,'1','308','1',1,'Retail Sale Id 2457',4440.00,0.00,0.00,6.00,660.00,'2023-02-16 10:20:17','',''),(2329,'1','308','1',1,'Retail Sale Id 2458',30600.00,0.00,0.00,45.00,2250.00,'2023-02-16 10:44:46','',''),(2330,'1','308','1',1,'Retail Sale Id 2459',4440.00,0.00,0.00,6.00,660.00,'2023-02-16 10:54:50','',''),(2331,'1','308','1',1,'Retail Sale Id 2460',2220.00,0.00,0.00,3.00,330.00,'2023-02-16 10:56:45','',''),(2332,'1','308','1',1,'Retail Sale Id 2461',9250.00,0.00,0.00,12.50,1375.00,'2023-02-16 11:01:01','',''),(2333,'1','308','1',1,'Retail Sale Id 2462',740.00,0.00,0.00,1.00,110.00,'2023-02-16 11:02:49','',''),(2334,'1','308','1',1,'Retail Sale Id 2463',4440.00,0.00,0.00,6.00,660.00,'2023-02-16 11:24:05','',''),(2335,'1','308','1',1,'Retail Sale Id 2464',740.00,0.00,0.00,1.00,110.00,'2023-02-16 11:38:17','',''),(2336,'1','308','1',1,'Retail Sale Id 2465',9250.00,0.00,0.00,12.50,1375.00,'2023-02-16 11:57:46','',''),(2337,'1','308','1',1,'Retail Sale Id 2466',2220.00,0.00,0.00,3.00,330.00,'2023-02-16 12:01:19','',''),(2338,'1','308','1',1,'Retail Sale Id 2467',3700.00,0.00,0.00,5.00,550.00,'2023-02-16 12:28:35','',''),(2339,'1','308','1',1,'Retail Sale Id 2468',2220.00,0.00,0.00,3.00,330.00,'2023-02-16 14:05:12','',''),(2340,'1','308','1',1,'Retail Sale Id 2469',3700.00,0.00,0.00,5.00,550.00,'2023-02-16 15:19:18','',''),(2341,'1','308','1',1,'Retail Sale Id 2470',4440.00,0.00,0.00,6.00,660.00,'2023-02-16 15:36:47','',''),(2342,'1','308','1',1,'Retail Sale Id 2471',1502.20,0.00,0.00,2.03,223.30,'2023-02-16 16:36:32','',''),(2343,'1','308','1',1,'Retail Sale Id 2473',1480.00,0.00,0.00,2.00,220.00,'2023-02-16 17:01:06','',''),(2344,'1','308','1',1,'Retail Sale Id 2474',740.00,0.00,0.00,1.00,110.00,'2023-02-16 17:05:40','',''),(2345,'1','308','1',1,'Retail Sale Id 2475',2960.00,0.00,0.00,4.00,440.00,'2023-02-16 17:07:35','',''),(2346,'1','308','1',1,'Retail Sale Id 2476',2960.00,0.00,0.00,4.00,440.00,'2023-02-16 17:08:48','',''),(2347,'1','308','1',1,'Retail Sale Id 2477',2220.00,0.00,0.00,3.00,330.00,'2023-02-16 17:22:23','',''),(2348,'1','308','1',1,'Retail Sale Id 2478',2220.00,0.00,0.00,3.00,330.00,'2023-02-16 17:27:23','',''),(2349,'1','308','1',1,'Retail Sale Id 2479',747.40,0.00,0.00,1.01,111.10,'2023-02-16 17:36:10','',''),(2350,'1','308','1',1,'Retail Sale Id 2480',1480.00,0.00,0.00,2.00,220.00,'2023-02-16 17:41:17','',''),(2351,'1','308','1',1,'Retail Sale Id 2481',2220.00,0.00,0.00,3.00,330.00,'2023-02-16 17:45:48','',''),(2352,'1','308','1',1,'Retail Sale Id 2482',4440.00,0.00,0.00,6.00,660.00,'2023-02-16 17:47:37','',''),(2353,'1','308','1',1,'Retail Sale Id 2483',2220.00,0.00,0.00,3.00,330.00,'2023-02-16 17:52:09','',''),(2354,'1','308','1',1,'Retail Sale Id 2484',1480.00,0.00,0.00,2.00,220.00,'2023-02-16 17:57:47','',''),(2355,'1','308','1',1,'Retail Sale Id 2485',747.40,0.00,0.00,1.01,111.10,'2023-02-16 18:36:51','',''),(2356,'1','308','1',1,'Retail Sale Id 2486',1502.20,0.00,0.00,2.03,223.30,'2023-02-16 18:39:23','',''),(2357,'1','308','1',1,'Retail Sale Id 2487',1502.20,0.00,0.00,2.03,223.30,'2023-02-16 18:44:01','',''),(2358,'1','308','1',1,'Retail Sale Id 2488',1428.20,0.00,0.00,1.93,212.30,'2023-02-16 21:07:47','',''),(2359,'1','308','1',1,'Retail Sale Id 2489',0.00,0.00,0.00,0.00,0.00,'2023-02-16 21:09:19','',''),(2360,'1','308','1',1,'Retail Sale Id 2490',2220.00,0.00,0.00,3.00,330.00,'2023-02-17 07:37:07','',''),(2361,'1','308','1',1,'Retail Sale Id 2491',8880.00,0.00,0.00,12.00,1320.00,'2023-02-17 07:39:03','',''),(2362,'1','308','1',1,'Retail Sale Id 2492',5920.00,0.00,0.00,8.00,880.00,'2023-02-17 07:40:25','',''),(2363,'1','308','1',1,'Retail Sale Id 2493',2220.00,0.00,0.00,3.00,330.00,'2023-02-17 07:41:57','',''),(2364,'1','308','1',1,'Retail Sale Id 2494',3700.00,0.00,0.00,5.00,550.00,'2023-02-17 07:46:30','',''),(2365,'1','308','1',1,'Retail Sale Id 2495',747.40,0.00,0.00,1.01,111.10,'2023-02-17 07:47:32','',''),(2366,'1','308','1',1,'Retail Sale Id 2496',2960.00,0.00,0.00,4.00,440.00,'2023-02-17 07:49:25','',''),(2367,'1','308','1',1,'Retail Sale Id 2497',2220.00,0.00,0.00,3.00,330.00,'2023-02-17 07:50:44','',''),(2368,'1','308','1',1,'Retail Sale Id 2498',8880.00,0.00,0.00,12.00,1320.00,'2023-02-17 07:52:46','',''),(2369,'1','308','1',1,'Retail Sale Id 2499',4447.40,0.00,0.00,6.01,661.10,'2023-02-17 08:15:47','',''),(2370,'1','308','1',1,'Retail Sale Id 2500',4440.00,0.00,0.00,6.00,660.00,'2023-02-17 08:18:32','',''),(2371,'1','308','1',1,'Retail Sale Id 2501',2960.00,0.00,0.00,4.00,440.00,'2023-02-17 08:21:25','',''),(2372,'1','308','1',1,'Retail Sale Id 2502',4440.00,0.00,0.00,6.00,660.00,'2023-02-17 08:26:57','',''),(2373,'1','308','1',1,'Retail Sale Id 2503',747.40,0.00,0.00,1.01,111.10,'2023-02-17 08:27:59','',''),(2374,'1','308','1',1,'Retail Sale Id 2504',4440.00,0.00,0.00,6.00,660.00,'2023-02-17 08:32:46','',''),(2375,'1','308','1',1,'Retail Sale Id 2505',2220.00,0.00,0.00,3.00,330.00,'2023-02-17 08:44:58','',''),(2376,'1','308','1',1,'Retail Sale Id 2506',4440.00,0.00,0.00,6.00,660.00,'2023-02-17 08:48:23','',''),(2377,'1','308','1',1,'Retail Sale Id 2507',5920.00,0.00,0.00,8.00,880.00,'2023-02-17 08:54:35','',''),(2378,'1','308','1',1,'Retail Sale Id 2508',1480.00,0.00,0.00,2.00,220.00,'2023-02-17 09:07:20','',''),(2379,'1','308','1',1,'Retail Sale Id 2509',2249.60,0.00,0.00,3.04,334.40,'2023-02-17 09:24:02','',''),(2380,'1','308','1',1,'Retail Sale Id 2510',5180.00,0.00,0.00,7.00,770.00,'2023-02-17 09:41:29','',''),(2381,'1','308','1',1,'Retail Sale Id 2511',4440.00,0.00,0.00,6.00,660.00,'2023-02-17 09:46:21','',''),(2382,'1','308','1',1,'Retail Sale Id 2512',2997.00,0.00,0.00,4.05,445.50,'2023-02-17 10:01:54','',''),(2383,'1','308','1',1,'Retail Sale Id 2513',4440.00,0.00,0.00,6.00,660.00,'2023-02-17 10:08:11','',''),(2384,'1','308','1',1,'Retail Sale Id 2514',4440.00,0.00,0.00,6.00,660.00,'2023-02-17 10:19:09','',''),(2385,'1','308','1',1,'Retail Sale Id 2515',3700.00,0.00,0.00,5.00,550.00,'2023-02-17 10:23:00','',''),(2386,'1','308','1',1,'Retail Sale Id 2517',2249.60,0.00,0.00,3.04,334.40,'2023-02-17 11:32:29','',''),(2387,'1','308','1',1,'Retail Sale Id 2518',2960.00,0.00,0.00,4.00,440.00,'2023-02-17 11:41:19','',''),(2388,'1','308','1',1,'Retail Sale Id 2519',11696.00,0.00,0.00,17.20,860.00,'2023-02-17 11:44:47','',''),(2389,'1','308','1',1,'Retail Sale Id 2521',2249.60,0.00,0.00,3.04,334.40,'2023-02-17 12:18:33','',''),(2390,'1','308','1',1,'Retail Sale Id 2522',747.40,0.00,0.00,1.01,111.10,'2023-02-17 12:49:21','',''),(2391,'1','308','1',1,'Retail Sale Id 2523',1480.00,0.00,0.00,2.00,220.00,'2023-02-17 13:07:08','',''),(2392,'1','308','1',1,'Retail Sale Id 2524',1502.20,0.00,0.00,2.03,223.30,'2023-02-17 13:17:27','',''),(2393,'1','308','1',1,'Retail Sale Id 2525',740.00,0.00,0.00,1.00,110.00,'2023-02-17 13:19:12','',''),(2394,'1','308','1',1,'Retail Sale Id 2526',747.40,0.00,0.00,1.01,111.10,'2023-02-17 15:12:09','',''),(2395,'1','308','1',1,'Retail Sale Id 2527',9250.00,0.00,0.00,12.50,1375.00,'2023-02-17 15:17:56','',''),(2396,'1','308','1',1,'Retail Sale Id 2528',8880.00,0.00,0.00,12.00,1320.00,'2023-02-17 15:23:25','',''),(2397,'1','308','1',1,'Retail Sale Id 2529',4447.40,0.00,0.00,6.01,661.10,'2023-02-17 16:18:07','',''),(2398,'1','308','1',1,'Retail Sale Id 2530',1502.20,0.00,0.00,2.03,223.30,'2023-02-17 17:03:03','',''),(2399,'1','308','1',1,'Retail Sale Id 2531',9250.00,0.00,0.00,12.50,1375.00,'2023-02-17 17:10:10','',''),(2400,'1','308','1',1,'Retail Sale Id 2532',3700.00,0.00,0.00,5.00,550.00,'2023-02-17 17:11:35','',''),(2401,'1','308','1',1,'Retail Sale Id 2533',1398.60,0.00,0.00,1.89,207.90,'2023-02-17 17:12:56','',''),(2402,'1','308','1',1,'Retail Sale Id 2534',747.40,0.00,0.00,1.01,111.10,'2023-02-17 17:14:15','',''),(2403,'1','308','1',1,'Retail Sale Id 2535',1480.00,0.00,0.00,2.00,220.00,'2023-02-17 17:15:56','',''),(2404,'1','308','1',1,'Retail Sale Id 2536',2501.20,0.00,0.00,3.38,371.80,'2023-02-17 17:18:21','',''),(2405,'1','308','1',1,'Retail Sale Id 2537',2249.60,0.00,0.00,3.04,334.40,'2023-02-17 17:32:26','',''),(2406,'1','308','1',1,'Retail Sale Id 2538',4499.20,0.00,0.00,6.08,668.80,'2023-02-17 17:37:41','',''),(2407,'1','308','1',1,'Retail Sale Id 2539',747.40,0.00,0.00,1.01,111.10,'2023-02-17 17:39:50','',''),(2408,'1','308','1',1,'Retail Sale Id 2540',2960.00,0.00,0.00,4.00,440.00,'2023-02-17 17:53:51','',''),(2409,'1','308','1',1,'Retail Sale Id 2541',2960.00,0.00,0.00,4.00,440.00,'2023-02-17 17:55:57','',''),(2410,'1','308','1',1,'Retail Sale Id 2542',1502.20,0.00,0.00,2.03,223.30,'2023-02-17 18:20:13','',''),(2411,'1','308','1',1,'Retail Sale Id 2543',2220.00,0.00,0.00,3.00,330.00,'2023-02-17 18:33:38','',''),(2412,'1','308','1',1,'Return of Retail Sale Id 2541',0.00,2960.00,4.00,0.00,-440.00,'2023-02-17 18:40:28','',''),(2413,'1','308','1',1,'Retail Sale Id 2544',37.00,0.00,0.00,0.05,5.50,'2023-02-17 19:10:11','',''),(2414,'1','308','1',1,'Retail Sale Id 2545',2220.00,0.00,0.00,3.00,330.00,'2023-02-18 07:29:25','',''),(2415,'1','308','1',1,'Retail Sale Id 2546',2997.00,0.00,0.00,4.05,445.50,'2023-02-18 07:59:27','',''),(2416,'1','308','1',1,'Retail Sale Id 2547',799.20,0.00,0.00,1.08,118.80,'2023-02-18 08:22:18','',''),(2417,'1','308','1',1,'Retail Sale Id 2548',1502.20,0.00,0.00,2.03,223.30,'2023-02-18 08:35:10','',''),(2418,'1','308','1',1,'Retail Sale Id 2549',30600.00,0.00,0.00,45.00,2250.00,'2023-02-18 08:36:39','',''),(2419,'1','308','1',1,'Retail Sale Id 2550',799.20,0.00,0.00,1.08,118.80,'2023-02-18 08:38:01','',''),(2420,'1','308','1',1,'Retail Sale Id 2551',2997.00,0.00,0.00,4.05,445.50,'2023-02-18 08:42:35','',''),(2421,'1','308','1',1,'Retail Sale Id 2552',799.20,0.00,0.00,1.08,118.80,'2023-02-18 08:51:55','',''),(2422,'1','308','1',1,'Retail Sale Id 2553',799.20,0.00,0.00,1.08,118.80,'2023-02-18 08:52:42','',''),(2423,'1','308','1',1,'Retail Sale Id 2554',17000.00,0.00,0.00,25.00,1250.00,'2023-02-18 08:55:00','',''),(2424,'1','308','1',1,'Retail Sale Id 2555',2997.00,0.00,0.00,4.05,445.50,'2023-02-18 09:11:18','',''),(2425,'1','308','1',1,'Retail Sale Id 2556',5920.00,0.00,0.00,8.00,880.00,'2023-02-18 09:16:25','',''),(2426,'1','308','1',1,'Retail Sale Id 2557',2220.00,0.00,0.00,3.00,330.00,'2023-02-18 09:17:40','',''),(2427,'1','308','1',1,'Retail Sale Id 2558',747.40,0.00,0.00,1.01,111.10,'2023-02-18 09:21:32','',''),(2428,'1','308','1',1,'Return of Retail Sale Id 2552',0.00,799.20,1.08,0.00,-118.80,'2023-02-18 09:27:12','',''),(2429,'1','308','1',1,'Retail Sale Id 2559',2960.00,0.00,0.00,4.00,440.00,'2023-02-18 09:28:18','',''),(2430,'1','308','1',1,'Retail Sale Id 2560',2997.00,0.00,0.00,4.05,445.50,'2023-02-18 09:29:29','',''),(2431,'1','308','1',1,'Retail Sale Id 2561',4440.00,0.00,0.00,6.00,660.00,'2023-02-18 09:33:56','',''),(2432,'1','308','1',1,'Retail Sale Id 2562',4440.00,0.00,0.00,6.00,660.00,'2023-02-18 09:36:59','',''),(2433,'1','308','1',1,'Retail Sale Id 2563',2960.00,0.00,0.00,4.00,440.00,'2023-02-18 09:40:29','',''),(2434,'1','308','1',1,'Retail Sale Id 2564',3700.00,0.00,0.00,5.00,550.00,'2023-02-18 09:45:28','',''),(2435,'1','308','1',1,'Retail Sale Id 2565',21080.00,0.00,0.00,31.00,1550.00,'2023-02-18 10:33:22','',''),(2436,'1','308','1',1,'Retail Sale Id 2566',7400.00,0.00,0.00,10.00,1100.00,'2023-02-18 10:34:36','',''),(2437,'1','308','1',1,'Retail Sale Id 2567',1998.00,0.00,0.00,2.70,297.00,'2023-02-18 10:52:54','',''),(2438,'1','308','1',1,'Retail Sale Id 2568',1502.20,0.00,0.00,2.03,223.30,'2023-02-18 11:08:50','',''),(2439,'1','308','1',1,'Retail Sale Id 2570',2220.00,0.00,0.00,3.00,330.00,'2023-02-18 11:24:13','',''),(2440,'1','308','1',1,'Retail Sale Id 2571',3700.00,0.00,0.00,5.00,550.00,'2023-02-18 12:13:11','',''),(2441,'1','308','1',1,'Retail Sale Id 2572',999.00,0.00,0.00,1.35,148.50,'2023-02-18 12:54:02','',''),(2442,'1','308','1',1,'Retail Sale Id 2573',999.00,0.00,0.00,1.35,148.50,'2023-02-18 13:00:36','',''),(2443,'1','308','1',1,'Retail Sale Id 2574',999.00,0.00,0.00,1.35,148.50,'2023-02-18 13:11:00','',''),(2444,'1','308','1',1,'Retail Sale Id 2575',7999.40,0.00,0.00,10.81,1189.10,'2023-02-18 13:35:08','',''),(2445,'1','308','1',1,'Retail Sale Id 2576',2997.00,0.00,0.00,4.05,445.50,'2023-02-18 13:41:44','',''),(2446,'1','308',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,630000.00,1000.00,0.00,0.00,'2023-02-18 13:56:37','',''),(2447,'1','308',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,1000.00,0.00,'2023-02-18 13:58:12','',''),(2448,'1','308','1',1,'Received from bridging 7',0.00,0.00,1000.00,0.00,0.00,'2023-02-18 13:58:12','',''),(2449,'1','308','1',1,'Retail Sale Id 2577',6660.00,0.00,0.00,9.00,990.00,'2023-02-18 14:58:16','',''),(2450,'1','308','1',1,'Retail Sale Id 2578',1480.00,0.00,0.00,2.00,220.00,'2023-02-18 15:49:34','',''),(2451,'1','308','1',1,'Retail Sale Id 2579',9250.00,0.00,0.00,12.50,1375.00,'2023-02-18 15:55:05','',''),(2452,'1','308','1',1,'Retail Sale Id 2580',2220.00,0.00,0.00,3.00,330.00,'2023-02-18 15:56:09','',''),(2453,'1','308','1',1,'Retail Sale Id 2581',1480.00,0.00,0.00,2.00,220.00,'2023-02-18 16:13:51','',''),(2454,'1','308','1',1,'Retail Sale Id 2582',4440.00,0.00,0.00,6.00,660.00,'2023-02-18 16:30:53','',''),(2455,'1','308','1',1,'Retail Sale Id 2583',2220.00,0.00,0.00,3.00,330.00,'2023-02-18 16:46:24','',''),(2456,'1','308','1',1,'Retail Sale Id 2584',1487.40,0.00,0.00,2.01,221.10,'2023-02-18 16:58:58','',''),(2457,'1','308','1',1,'Retail Sale Id 2585',1480.00,0.00,0.00,2.00,220.00,'2023-02-18 17:07:35','',''),(2458,'1','308','1',1,'Retail Sale Id 2586',4440.00,0.00,0.00,6.00,660.00,'2023-02-18 17:12:21','',''),(2459,'1','308','1',1,'Retail Sale Id 2587',1480.00,0.00,0.00,2.00,220.00,'2023-02-18 17:14:16','',''),(2460,'1','308','1',1,'Retail Sale Id 2588',747.40,0.00,0.00,1.01,111.10,'2023-02-18 17:19:18','',''),(2461,'1','308','1',1,'Retail Sale Id 2589',4440.00,0.00,0.00,6.00,660.00,'2023-02-18 17:22:22','',''),(2462,'1','308','1',1,'Retail Sale Id 2590',799.20,0.00,0.00,1.08,118.80,'2023-02-18 17:39:19','',''),(2463,'1','308','1',1,'Retail Sale Id 2591',8880.00,0.00,0.00,12.00,1320.00,'2023-02-18 18:03:27','',''),(2464,'1','308','1',1,'Retail Sale Id 2592',8880.00,0.00,0.00,12.00,1320.00,'2023-02-18 18:05:32','',''),(2465,'1','308','1',1,'Retail Sale Id 2593',1480.00,0.00,0.00,2.00,220.00,'2023-02-18 18:11:18','',''),(2466,'1','308','1',1,'Retail Sale Id 2594',747.40,0.00,0.00,1.01,111.10,'2023-02-18 18:20:02','',''),(2467,'1','308','1',1,'Retail Sale Id 2595',747.40,0.00,0.00,1.01,111.10,'2023-02-18 18:22:23','',''),(2468,'1','308','1',1,'Retail Sale Id 2597',1502.20,0.00,0.00,2.03,223.30,'2023-02-18 18:28:03','',''),(2469,'1','308','1',1,'Retail Sale Id 2598',4440.00,0.00,0.00,6.00,660.00,'2023-02-18 18:38:11','',''),(2470,'1','308','1',1,'Retail Sale Id 2599',2220.00,0.00,0.00,3.00,330.00,'2023-02-18 19:06:38','',''),(2471,'1','308','1',1,'Retail Sale Id 2600',1502.20,0.00,0.00,2.03,223.30,'2023-02-18 19:08:31','',''),(2472,'1','308','1',1,'Retail Sale Id 2601',2797.20,0.00,0.00,3.78,415.80,'2023-02-18 19:10:56','',''),(2473,'1','308','1',1,'Retail Sale Id 2602',2220.00,0.00,0.00,3.00,330.00,'2023-02-18 19:19:12','',''),(2474,'1','308','1',1,'Retail Sale Id 2603',1480.00,0.00,0.00,2.00,220.00,'2023-02-18 19:20:41','',''),(2475,'1','308','1',1,'Retail Sale Id 2604',2960.00,0.00,0.00,4.00,440.00,'2023-02-18 19:22:38','',''),(2476,'1','308','1',1,'Retail Sale Id 2605',5150.40,0.00,0.00,6.96,765.60,'2023-02-18 19:38:16','',''),(2477,'1','308','1',1,'Retail Sale Id 2606',1406.00,0.00,0.00,1.90,209.00,'2023-02-18 20:04:15','',''),(2478,'1','308','1',1,'Return of Retail Sale Id 2565',0.00,21080.00,31.00,0.00,-1550.00,'2023-02-18 20:07:07','',''),(2479,'1','308','1',1,'Retail Sale Id 2607',20760.40,0.00,0.00,30.53,1526.50,'2023-02-18 20:10:16','',''),(2480,'1','308',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,2677500.00,4250.00,0.00,0.00,'2023-02-19 07:34:21','',''),(2481,'1','308',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,4250.00,0.00,'2023-02-19 07:35:31','',''),(2482,'1','308','1',1,'Received from bridging 8',0.00,0.00,4250.00,0.00,0.00,'2023-02-19 07:35:31','',''),(2483,'1','308','1',1,'Retail Sale Id 2608',68000.00,0.00,0.00,100.00,5000.00,'2023-02-19 07:39:48','',''),(2484,'1','308','1',1,'Retail Sale Id 2609',4447.40,0.00,0.00,6.01,661.10,'2023-02-19 07:46:03','',''),(2485,'1','308','1',1,'Retail Sale Id 2610',2997.00,0.00,0.00,4.05,445.50,'2023-02-19 07:47:00','',''),(2486,'1','308','1',1,'Retail Sale Id 2611',9250.00,0.00,0.00,12.50,1375.00,'2023-02-19 08:11:52','',''),(2487,'1','308','1',1,'Retail Sale Id 2612',1502.20,0.00,0.00,2.03,223.30,'2023-02-19 08:20:22','',''),(2488,'1','308','1',1,'Retail Sale Id 2613',5920.00,0.00,0.00,8.00,880.00,'2023-02-19 08:21:42','',''),(2489,'1','308','1',1,'Retail Sale Id 2614',68000.00,0.00,0.00,100.00,5000.00,'2023-02-19 08:41:02','',''),(2490,'1','308','1',1,'Retail Sale Id 2615',1398.60,0.00,0.00,1.89,207.90,'2023-02-19 09:25:53','',''),(2491,'1','308','1',1,'Retail Sale Id 2616',747.40,0.00,0.00,1.01,111.10,'2023-02-19 09:27:11','',''),(2492,'1','308','1',1,'Retail Sale Id 2617',7400.00,0.00,0.00,10.00,1100.00,'2023-02-19 09:44:37','',''),(2493,'1','308','1',1,'Retail Sale Id 2618',747.40,0.00,0.00,1.01,111.10,'2023-02-19 10:36:41','',''),(2494,'1','308','1',1,'Retail Sale Id 2619',1850.00,0.00,0.00,2.50,275.00,'2023-02-19 11:20:58','',''),(2495,'1','308','1',1,'Retail Sale Id 2620',1480.00,0.00,0.00,2.00,220.00,'2023-02-19 11:23:03','',''),(2496,'1','308','1',1,'Retail Sale Id 2621',4440.00,0.00,0.00,6.00,660.00,'2023-02-19 11:24:02','',''),(2497,'1','308','1',1,'Retail Sale Id 2622',1502.20,0.00,0.00,2.03,223.30,'2023-02-19 11:32:24','',''),(2498,'1','308','1',1,'Retail Sale Id 2623',747.40,0.00,0.00,1.01,111.10,'2023-02-19 11:34:00','',''),(2499,'1','308','1',1,'Retail Sale Id 2624',2220.00,0.00,0.00,3.00,330.00,'2023-02-19 11:35:08','',''),(2500,'1','308','1',1,'Retail Sale Id 2625',4440.00,0.00,0.00,6.00,660.00,'2023-02-19 11:37:14','',''),(2501,'1','308','1',1,'Retail Sale Id 2626',2220.00,0.00,0.00,3.00,330.00,'2023-02-19 11:39:42','',''),(2502,'1','308','1',1,'Retail Sale Id 2627',7451.80,0.00,0.00,10.07,1107.70,'2023-02-19 11:44:09','',''),(2503,'1','308','1',1,'Retail Sale Id 2628',3700.00,0.00,0.00,5.00,550.00,'2023-02-19 11:56:37','',''),(2504,'1','308','1',1,'Retail Sale Id 2629',3700.00,0.00,0.00,5.00,550.00,'2023-02-19 12:17:07','',''),(2505,'1','308','1',1,'Retail Sale Id 2630',4440.00,0.00,0.00,6.00,660.00,'2023-02-19 12:24:19','',''),(2506,'1','308','1',1,'Retail Sale Id 2631',4440.00,0.00,0.00,6.00,660.00,'2023-02-19 12:48:56','',''),(2507,'1','308','1',1,'Retail Sale Id 2632',4440.00,0.00,0.00,6.00,660.00,'2023-02-19 12:56:09','',''),(2508,'1','308','1',1,'Retail Sale Id 2633',2960.00,0.00,0.00,4.00,440.00,'2023-02-19 12:57:35','',''),(2509,'1','308','1',1,'Retail Sale Id 2634',1502.20,0.00,0.00,2.03,223.30,'2023-02-19 13:12:27','',''),(2510,'1','308','1',1,'Retail Sale Id 2635',799.20,0.00,0.00,1.08,118.80,'2023-02-19 13:13:13','',''),(2511,'1','308','1',1,'Retail Sale Id 2636',13804.00,0.00,0.00,20.30,1015.00,'2023-02-19 13:16:24','',''),(2512,'1','308','1',1,'Retail Sale Id 2637',2220.00,0.00,0.00,3.00,330.00,'2023-02-19 13:24:48','',''),(2513,'1','308','1',1,'Retail Sale Id 2638',2960.00,0.00,0.00,4.00,440.00,'2023-02-19 13:29:03','',''),(2514,'1','308','1',1,'Retail Sale Id 2639',4440.00,0.00,0.00,6.00,660.00,'2023-02-19 13:37:17','',''),(2515,'1','308','1',1,'Retail Sale Id 2640',4440.00,0.00,0.00,6.00,660.00,'2023-02-19 13:43:03','',''),(2516,'1','308','1',1,'Retail Sale Id 2641',1502.20,0.00,0.00,2.03,223.30,'2023-02-19 13:44:38','',''),(2517,'1','308','1',1,'Retail Sale Id 2642',2220.00,0.00,0.00,3.00,330.00,'2023-02-19 13:46:38','',''),(2518,'1','308','1',1,'Retail Sale Id 2643',9250.00,0.00,0.00,12.50,1375.00,'2023-02-19 14:00:17','',''),(2519,'1','308','1',1,'Retail Sale Id 2644',7400.00,0.00,0.00,10.00,1100.00,'2023-02-19 14:25:30','',''),(2520,'1','308','1',1,'Retail Sale Id 2645',2249.60,0.00,0.00,3.04,334.40,'2023-02-19 15:58:20','',''),(2521,'1','308','1',1,'Retail Sale Id 2646',747.40,0.00,0.00,1.01,111.10,'2023-02-19 16:36:50','',''),(2522,'1','308','1',1,'Retail Sale Id 2647',30600.00,0.00,0.00,45.00,2250.00,'2023-02-19 16:41:03','',''),(2523,'1','308','1',1,'Retail Sale Id 2648',4440.00,0.00,0.00,6.00,660.00,'2023-02-19 16:48:31','',''),(2524,'1','308','1',1,'Retail Sale Id 2649',4440.00,0.00,0.00,6.00,660.00,'2023-02-19 16:55:36','',''),(2525,'1','308','1',1,'Return of Retail Sale Id 2644',0.00,7400.00,10.00,0.00,-1100.00,'2023-02-19 17:02:38','',''),(2526,'1','308','1',1,'Retail Sale Id 2650',2220.00,0.00,0.00,3.00,330.00,'2023-02-19 17:10:38','',''),(2527,'1','308','1',1,'Retail Sale Id 2651',2220.00,0.00,0.00,3.00,330.00,'2023-02-19 17:16:44','',''),(2528,'1','308','1',1,'Retail Sale Id 2652',3700.00,0.00,0.00,5.00,550.00,'2023-02-19 17:21:48','',''),(2529,'1','308','1',1,'Retail Sale Id 2653',1502.20,0.00,0.00,2.03,223.30,'2023-02-19 17:33:43','',''),(2530,'1','308','1',1,'Retail Sale Id 2654',2220.00,0.00,0.00,3.00,330.00,'2023-02-19 17:37:07','',''),(2531,'1','308','1',1,'Retail Sale Id 2655',1502.20,0.00,0.00,2.03,223.30,'2023-02-19 17:48:29','',''),(2532,'1','308','1',1,'Retail Sale Id 2656',2220.00,0.00,0.00,3.00,330.00,'2023-02-19 17:55:26','',''),(2533,'1','308','1',1,'Retail Sale Id 2657',4440.00,0.00,0.00,6.00,660.00,'2023-02-19 17:58:53','',''),(2534,'1','308','1',1,'Retail Sale Id 2658',1480.00,0.00,0.00,2.00,220.00,'2023-02-19 18:01:36','',''),(2535,'1','308','1',1,'Retail Sale Id 2659',2220.00,0.00,0.00,3.00,330.00,'2023-02-19 18:02:50','',''),(2536,'1','308','1',1,'Retail Sale Id 2660',2220.00,0.00,0.00,3.00,330.00,'2023-02-19 18:03:42','',''),(2537,'1','308','1',1,'Retail Sale Id 2661',2960.00,0.00,0.00,4.00,440.00,'2023-02-19 18:04:34','',''),(2538,'1','308','1',1,'Retail Sale Id 2662',2220.00,0.00,0.00,3.00,330.00,'2023-02-19 18:25:13','',''),(2539,'1','308','1',1,'Retail Sale Id 2663',2960.00,0.00,0.00,4.00,440.00,'2023-02-19 18:29:17','',''),(2540,'1','308','1',1,'Retail Sale Id 2664',2960.00,0.00,0.00,4.00,440.00,'2023-02-19 18:33:29','',''),(2541,'1','308','1',1,'Retail Sale Id 2665',3700.00,0.00,0.00,5.00,550.00,'2023-02-19 18:37:15','',''),(2542,'1','308','1',1,'Retail Sale Id 2666',3700.00,0.00,0.00,5.00,550.00,'2023-02-19 18:42:41','',''),(2543,'1','308','1',1,'Retail Sale Id 2667',1502.20,0.00,0.00,2.03,223.30,'2023-02-19 18:49:32','',''),(2544,'1','308','1',1,'Retail Sale Id 2669',1517.00,0.00,0.00,2.05,225.50,'2023-02-19 18:54:27','',''),(2545,'1','308','1',1,'Retail Sale Id 2670',17000.00,0.00,0.00,25.00,-1400.00,'2023-02-20 08:09:08','',''),(2546,'1','308','1',1,'Retail Sale Id 2671',699.20,0.00,0.00,0.95,0.00,'2023-02-20 08:10:02','',''),(2547,'1','308','1',1,'Retail Sale Id 2672',4416.00,0.00,0.00,6.00,0.00,'2023-02-20 08:18:43','',''),(2548,'1','308','1',1,'Retail Sale Id 2673',7360.00,0.00,0.00,10.00,0.00,'2023-02-20 08:23:05','',''),(2549,'1','308','1',1,'Retail Sale Id 2674',4416.00,0.00,0.00,6.00,0.00,'2023-02-20 08:25:09','',''),(2550,'1','308','1',1,'Retail Sale Id 2675',1472.00,0.00,0.00,2.00,0.00,'2023-02-20 08:42:36','',''),(2551,'1','308','1',1,'Retail Sale Id 2676',8096.00,0.00,0.00,11.00,0.00,'2023-02-20 08:50:15','',''),(2552,'1','308','1',1,'Retail Sale Id 2677',5888.00,0.00,0.00,8.00,0.00,'2023-02-20 09:00:19','',''),(2553,'1','308','1',1,'Retail Sale Id 2678',3680.00,0.00,0.00,5.00,0.00,'2023-02-20 09:36:09','',''),(2554,'1','308','1',1,'Retail Sale Id 2679',1000.96,0.00,0.00,1.36,0.00,'2023-02-20 10:10:59','',''),(2555,'1','308','1',1,'Retail Sale Id 2680',1472.00,0.00,0.00,2.00,0.00,'2023-02-20 10:16:52','',''),(2556,'1','308','1',1,'Retail Sale Id 2681',3680.00,0.00,0.00,5.00,0.00,'2023-02-20 10:48:42','',''),(2557,'1','308','1',1,'Retail Sale Id 2682',1000.96,0.00,0.00,1.36,0.00,'2023-02-20 11:16:08','',''),(2558,'1','308','1',1,'Retail Sale Id 2683',68000.00,0.00,0.00,100.00,-5600.00,'2023-02-20 12:09:25','',''),(2559,'1','308','1',1,'Retail Sale Id 2684',68000.00,0.00,0.00,100.00,-5600.00,'2023-02-20 12:11:53','',''),(2560,'1','308','1',1,'Retail Sale Id 2685',2208.00,0.00,0.00,3.00,0.00,'2023-02-20 12:15:24','',''),(2561,'1','308','1',1,'Retail Sale Id 2687',34000.00,0.00,0.00,50.00,-2800.00,'2023-02-20 12:24:12','',''),(2562,'1','308','1',1,'Retail Sale Id 2688',3002.88,0.00,0.00,4.08,0.00,'2023-02-20 12:34:03','',''),(2563,'1','308','1',1,'Retail Sale Id 2690',2001.92,0.00,0.00,2.72,0.00,'2023-02-20 12:39:05','',''),(2564,'1','308','1',1,'Retail Sale Id 2691',1700.16,0.00,0.00,2.31,0.00,'2023-02-20 12:41:10','',''),(2565,'1','308','1',1,'Retail Sale Id 2692',4416.00,0.00,0.00,6.00,0.00,'2023-02-20 12:49:28','',''),(2566,'1','308','1',1,'Retail Sale Id 2693',2222.72,0.00,0.00,3.02,0.00,'2023-02-20 12:50:46','',''),(2567,'1','308','1',1,'Retail Sale Id 2694',1472.00,0.00,0.00,2.00,0.00,'2023-02-20 13:06:03','',''),(2568,'1','308','1',1,'Retail Sale Id 2695',1501.44,0.00,0.00,2.04,0.00,'2023-02-20 13:37:03','',''),(2569,'1','308','1',1,'Retail Sale Id 2696',118320.00,0.00,0.00,174.00,-9744.00,'2023-02-20 13:51:20','',''),(2570,'1','308','1',1,'Retail Sale Id 2697',2208.00,0.00,0.00,3.00,0.00,'2023-02-20 14:13:28','',''),(2571,'1','308','1',1,'Retail Sale Id 2698',1472.00,0.00,0.00,2.00,0.00,'2023-02-20 14:16:51','',''),(2572,'1','308','1',1,'Retail Sale Id 2699',5152.00,0.00,0.00,7.00,0.00,'2023-02-20 14:34:56','',''),(2573,'1','308','1',1,'Retail Sale Id 2700',2208.00,0.00,0.00,3.00,0.00,'2023-02-20 14:42:17','',''),(2574,'1','308','1',1,'Retail Sale Id 2701',2001.92,0.00,0.00,2.72,0.00,'2023-02-20 15:11:28','',''),(2575,'1','308','1',1,'Retail Sale Id 2702',2944.00,0.00,0.00,4.00,0.00,'2023-02-20 15:27:58','',''),(2576,'1','308','1',1,'Retail Sale Id 2703',2944.00,0.00,0.00,4.00,0.00,'2023-02-20 15:28:54','',''),(2577,'1','308','1',1,'Retail Sale Id 2704',2944.00,0.00,0.00,4.00,0.00,'2023-02-20 15:32:29','',''),(2578,'1','308','1',1,'Retail Sale Id 2705',2208.00,0.00,0.00,3.00,0.00,'2023-02-20 15:39:59','',''),(2579,'1','308','1',1,'Retail Sale Id 2706',2230.08,0.00,0.00,3.03,0.00,'2023-02-20 16:19:25','',''),(2580,'1','308','1',1,'Retail Sale Id 2707',750.72,0.00,0.00,1.02,0.00,'2023-02-20 16:20:54','',''),(2581,'1','308','1',1,'Retail Sale Id 2708',736.00,0.00,0.00,1.00,0.00,'2023-02-20 16:24:44','',''),(2582,'1','308','1',1,'Retail Sale Id 2709',2208.00,0.00,0.00,3.00,0.00,'2023-02-20 16:29:02','',''),(2583,'1','308','1',1,'Retail Sale Id 2710',5152.00,0.00,0.00,7.00,0.00,'2023-02-20 16:46:22','',''),(2584,'1','308','1',1,'Retail Sale Id 2711',1472.00,0.00,0.00,2.00,0.00,'2023-02-20 16:50:48','',''),(2585,'1','308','1',1,'Retail Sale Id 2712',1472.00,0.00,0.00,2.00,0.00,'2023-02-20 16:53:21','',''),(2586,'1','308','1',1,'Retail Sale Id 2713',2208.00,0.00,0.00,3.00,0.00,'2023-02-20 16:58:40','',''),(2587,'1','308','1',1,'Retail Sale Id 2714',3680.00,0.00,0.00,5.00,0.00,'2023-02-20 17:00:39','',''),(2588,'1','308','1',1,'Retail Sale Id 2715',2944.00,0.00,0.00,4.00,0.00,'2023-02-20 17:11:32','',''),(2589,'1','308','1',1,'Retail Sale Id 2716',750.72,0.00,0.00,1.02,0.00,'2023-02-20 17:14:54','',''),(2590,'1','308','1',1,'Retail Sale Id 2717',2208.00,0.00,0.00,3.00,0.00,'2023-02-20 17:39:25','',''),(2591,'1','308','1',1,'Retail Sale Id 2718',7396.80,0.00,0.00,10.05,0.00,'2023-02-20 17:46:15','',''),(2592,'1','308','1',1,'Retail Sale Id 2719',3680.00,0.00,0.00,5.00,0.00,'2023-02-20 17:48:16','',''),(2593,'1','308','1',1,'Retail Sale Id 2720',2208.00,0.00,0.00,3.00,0.00,'2023-02-20 17:52:40','',''),(2594,'1','308','1',1,'Retail Sale Id 2721',3002.88,0.00,0.00,4.08,0.00,'2023-02-20 17:54:22','',''),(2595,'1','308','1',1,'Retail Sale Id 2722',750.72,0.00,0.00,1.02,0.00,'2023-02-20 17:55:50','',''),(2596,'1','308','1',1,'Retail Sale Id 2723',2208.00,0.00,0.00,3.00,0.00,'2023-02-20 18:02:45','',''),(2597,'1','308','1',1,'Retail Sale Id 2724',2944.00,0.00,0.00,4.00,0.00,'2023-02-20 18:05:54','',''),(2598,'1','308','1',1,'Retail Sale Id 2726',4416.00,0.00,0.00,6.00,0.00,'2023-02-20 18:13:01','',''),(2599,'1','308','1',1,'Retail Sale Id 2727',4416.00,0.00,0.00,6.00,0.00,'2023-02-20 18:18:55','',''),(2600,'1','308','1',1,'Retail Sale Id 2728',5203.52,0.00,0.00,7.07,0.00,'2023-02-20 18:21:01','',''),(2601,'1','308','1',1,'Retail Sale Id 2730',3680.00,0.00,0.00,5.00,0.00,'2023-02-20 18:29:47','',''),(2602,'1','308','1',1,'Retail Sale Id 2731',1000.96,0.00,0.00,1.36,0.00,'2023-02-20 18:32:45','',''),(2603,'1','308','1',1,'Retail Sale Id 2732',4416.00,0.00,0.00,6.00,0.00,'2023-02-20 18:35:08','',''),(2604,'1','308','1',1,'Return of Retail Sale Id 2721',0.00,3002.88,4.08,0.00,0.00,'2023-02-20 18:38:22','',''),(2605,'1','308','1',1,'Retail Sale Id 2734',1472.00,0.00,0.00,2.00,0.00,'2023-02-20 18:39:01','',''),(2606,'1','308','1',1,'Retail Sale Id 2735',3680.00,0.00,0.00,5.00,0.00,'2023-02-20 18:42:53','',''),(2607,'1','308','1',1,'Retail Sale Id 2736',3680.00,0.00,0.00,5.00,0.00,'2023-02-20 18:44:10','',''),(2608,'1','308','1',1,'Retail Sale Id 2737',1501.44,0.00,0.00,2.04,0.00,'2023-02-20 18:45:40','',''),(2609,'1','308','1',1,'Retail Sale Id 2738',2208.00,0.00,0.00,3.00,0.00,'2023-02-20 18:55:08','',''),(2610,'1','308','1',1,'Retail Sale Id 2739',2208.00,0.00,0.00,3.00,0.00,'2023-02-20 18:58:00','',''),(2611,'1','308','1',1,'Retail Sale Id 2740',2208.00,0.00,0.00,3.00,0.00,'2023-02-20 19:46:25','',''),(2612,'1','308','1',1,'Retail Sale Id 2741',4416.00,0.00,0.00,6.00,0.00,'2023-02-21 07:46:18','',''),(2613,'1','308','1',1,'Retail Sale Id 2742',68000.00,0.00,0.00,100.00,-5600.00,'2023-02-21 07:49:38','',''),(2614,'1','308','1',1,'Retail Sale Id 2743',2040.00,0.00,0.00,3.00,-168.00,'2023-02-21 07:52:40','',''),(2615,'1','308','1',1,'Retail Sale Id 2744',20400.00,0.00,0.00,30.00,-1680.00,'2023-02-21 07:56:15','',''),(2616,'1','308','1',1,'Retail Sale Id 2745',4416.00,0.00,0.00,6.00,0.00,'2023-02-21 08:10:17','',''),(2617,'1','308','1',1,'Retail Sale Id 2746',5152.00,0.00,0.00,7.00,0.00,'2023-02-21 08:12:49','',''),(2618,'1','308','1',1,'Retail Sale Id 2747',736.00,0.00,0.00,1.00,0.00,'2023-02-21 08:21:23','',''),(2619,'1','308','1',1,'Retail Sale Id 2748',27200.00,0.00,0.00,40.00,-2240.00,'2023-02-21 08:23:12','',''),(2620,'1','308','1',1,'Retail Sale Id 2749',2001.92,0.00,0.00,2.72,0.00,'2023-02-21 08:24:41','',''),(2621,'1','308','1',1,'Retail Sale Id 2750',4416.00,0.00,0.00,6.00,0.00,'2023-02-21 08:46:16','',''),(2622,'1','308','1',1,'Retail Sale Id 2751',1000.96,0.00,0.00,1.36,0.00,'2023-02-21 08:47:44','',''),(2623,'1','308','1',1,'Retail Sale Id 2752',9200.00,0.00,0.00,12.50,0.00,'2023-02-21 09:02:49','',''),(2624,'1','308','1',1,'Retail Sale Id 2753',1472.00,0.00,0.00,2.00,0.00,'2023-02-21 09:25:39','',''),(2625,'1','308','1',1,'Retail Sale Id 2754',9200.00,0.00,0.00,12.50,0.00,'2023-02-21 09:27:19','',''),(2626,'1','308','1',1,'Retail Sale Id 2755',8832.00,0.00,0.00,12.00,0.00,'2023-02-21 09:41:22','',''),(2627,'1','308','1',1,'Retail Sale Id 2756',750.72,0.00,0.00,1.02,0.00,'2023-02-21 09:54:13','',''),(2628,'1','308','1',1,'Retail Sale Id 2757',1472.00,0.00,0.00,2.00,0.00,'2023-02-21 10:16:49','',''),(2629,'1','308','1',1,'Retail Sale Id 2758',2208.00,0.00,0.00,3.00,0.00,'2023-02-21 10:24:05','',''),(2630,'1','308','1',1,'Retail Sale Id 2759',1472.00,0.00,0.00,2.00,0.00,'2023-02-21 10:27:03','',''),(2631,'1','308','1',1,'Retail Sale Id 2760',3680.00,0.00,0.00,5.00,0.00,'2023-02-21 11:11:17','',''),(2632,'1','308','1',1,'Retail Sale Id 2761',1472.00,0.00,0.00,2.00,0.00,'2023-02-21 11:24:28','',''),(2633,'1','308','1',1,'Retail Sale Id 2762',2208.00,0.00,0.00,3.00,0.00,'2023-02-21 11:29:28','',''),(2634,'1','308','1',1,'Retail Sale Id 2763',2208.00,0.00,0.00,3.00,0.00,'2023-02-21 11:46:45','',''),(2635,'1','308','1',1,'Retail Sale Id 2764',9200.00,0.00,0.00,12.50,0.00,'2023-02-21 11:48:28','',''),(2636,'1','308','1',1,'Retail Sale Id 2765',6624.00,0.00,0.00,9.00,0.00,'2023-02-21 12:06:36','',''),(2637,'1','308','1',1,'Retail Sale Id 2766',750.72,0.00,0.00,1.02,0.00,'2023-02-21 12:33:56','',''),(2638,'1','308','1',1,'Retail Sale Id 2767',4416.00,0.00,0.00,6.00,0.00,'2023-02-21 13:03:57','',''),(2639,'1','308','1',1,'Retail Sale Id 2768',2944.00,0.00,0.00,4.00,0.00,'2023-02-21 13:24:05','',''),(2640,'1','308','1',1,'Retail Sale Id 2769',1472.00,0.00,0.00,2.00,0.00,'2023-02-21 13:28:19','',''),(2641,'1','308','1',1,'Retail Sale Id 2770',2944.00,0.00,0.00,4.00,0.00,'2023-02-21 13:34:58','',''),(2642,'1','308','1',1,'Retail Sale Id 2771',5203.52,0.00,0.00,7.07,0.00,'2023-02-21 13:37:07','',''),(2643,'1','308','1',1,'Retail Sale Id 2772',7360.00,0.00,0.00,10.00,0.00,'2023-02-21 13:57:27','',''),(2644,'1','308','1',1,'Retail Sale Id 2774',1472.00,0.00,0.00,2.00,0.00,'2023-02-21 14:08:27','',''),(2645,'1','308','1',1,'Retail Sale Id 2775',736.00,0.00,0.00,1.00,0.00,'2023-02-21 14:09:56','',''),(2646,'1','308','1',1,'Retail Sale Id 2776',2701.12,0.00,0.00,3.67,0.00,'2023-02-21 14:18:41','',''),(2647,'1','308','1',1,'Retail Sale Id 2777',3702.08,0.00,0.00,5.03,0.00,'2023-02-21 14:21:49','',''),(2648,'1','308','1',1,'Retail Sale Id 2778',750.72,0.00,0.00,1.02,0.00,'2023-02-21 14:25:15','',''),(2649,'1','308','1',1,'Retail Sale Id 2779',736.00,0.00,0.00,1.00,0.00,'2023-02-21 14:26:36','',''),(2650,'1','308','1',1,'Retail Sale Id 2780',1472.00,0.00,0.00,2.00,0.00,'2023-02-21 14:40:51','',''),(2651,'1','308','1',1,'Retail Sale Id 2781',2208.00,0.00,0.00,3.00,0.00,'2023-02-21 14:45:53','',''),(2652,'1','308','1',1,'Retail Sale Id 2782',1501.44,0.00,0.00,2.04,0.00,'2023-02-21 14:58:23','',''),(2653,'1','308','1',1,'Retail Sale Id 2783',301.76,0.00,0.00,0.41,0.00,'2023-02-21 15:49:48','',''),(2654,'1','308','1',1,'Retail Sale Id 2784',2502.40,0.00,0.00,3.40,0.00,'2023-02-21 16:16:56','',''),(2655,'1','308','1',1,'Retail Sale Id 2785',4416.00,0.00,0.00,6.00,0.00,'2023-02-21 16:18:14','',''),(2656,'1','308','1',1,'Retail Sale Id 2786',750.72,0.00,0.00,1.02,0.00,'2023-02-21 16:28:25','',''),(2657,'1','308','1',1,'Retail Sale Id 2787',736.00,0.00,0.00,1.00,0.00,'2023-02-21 16:29:38','',''),(2658,'1','308','1',1,'Retail Sale Id 2788',9001.28,0.00,0.00,12.23,0.00,'2023-02-21 16:31:23','',''),(2659,'1','308','1',1,'Retail Sale Id 2789',9200.00,0.00,0.00,12.50,0.00,'2023-02-21 17:18:37','',''),(2660,'1','308','1',1,'Retail Sale Id 2790',2944.00,0.00,0.00,4.00,0.00,'2023-02-21 17:35:42','',''),(2661,'1','308','1',1,'Retail Sale Id 2791',9200.00,0.00,0.00,12.50,0.00,'2023-02-21 17:38:29','',''),(2662,'1','308','1',1,'Retail Sale Id 2792',4416.00,0.00,0.00,6.00,0.00,'2023-02-21 17:39:15','',''),(2663,'1','308','1',1,'Retail Sale Id 2793',750.72,0.00,0.00,1.02,0.00,'2023-02-21 17:43:48','',''),(2664,'1','308','1',1,'Retail Sale Id 2794',4997.44,0.00,0.00,6.79,0.00,'2023-02-21 17:47:45','',''),(2665,'1','308','1',1,'Retail Sale Id 2795',1096.64,0.00,0.00,1.49,0.00,'2023-02-21 17:53:11','',''),(2666,'1','308','1',1,'Retail Sale Id 2796',1398.40,0.00,0.00,1.90,0.00,'2023-02-21 17:54:51','',''),(2667,'1','308','1',1,'Retail Sale Id 2797',23201.60,0.00,0.00,34.12,-1910.72,'2023-02-21 17:59:12','',''),(2668,'1','308','1',1,'Retail Sale Id 2798',5696.64,0.00,0.00,7.74,0.00,'2023-02-21 18:02:51','',''),(2669,'1','308','1',1,'Retail Sale Id 2799',2208.00,0.00,0.00,3.00,0.00,'2023-02-21 18:09:14','',''),(2670,'1','308','1',1,'Retail Sale Id 2800',2208.00,0.00,0.00,3.00,0.00,'2023-02-21 18:11:44','',''),(2671,'1','308','1',1,'Retail Sale Id 2801',3680.00,0.00,0.00,5.00,0.00,'2023-02-21 18:15:31','',''),(2672,'1','308','1',1,'Retail Sale Id 2802',2208.00,0.00,0.00,3.00,0.00,'2023-02-21 18:22:11','',''),(2673,'1','308','1',1,'Retail Sale Id 2803',2208.00,0.00,0.00,3.00,0.00,'2023-02-21 18:23:56','',''),(2674,'1','308','1',1,'Retail Sale Id 2804',1597.12,0.00,0.00,2.17,0.00,'2023-02-21 18:26:38','',''),(2675,'1','308','1',1,'Retail Sale Id 2805',2208.00,0.00,0.00,3.00,0.00,'2023-02-21 18:29:36','',''),(2676,'1','308','1',1,'Retail Sale Id 2806',4416.00,0.00,0.00,6.00,0.00,'2023-02-21 18:33:53','',''),(2677,'1','308','1',1,'Retail Sale Id 2807',14.72,0.00,0.00,0.02,0.00,'2023-02-21 19:29:56','',''),(2678,'1','308','1',1,'Retail Sale Id 2808',2944.00,0.00,0.00,4.00,0.00,'2023-02-22 08:04:19','',''),(2679,'1','308','1',1,'Retail Sale Id 2809',3002.88,0.00,0.00,4.08,0.00,'2023-02-22 08:06:46','',''),(2680,'1','308','1',1,'Retail Sale Id 2810',1000.96,0.00,0.00,1.36,0.00,'2023-02-22 08:08:25','',''),(2681,'1','308','1',1,'Retail Sale Id 2811',1501.44,0.00,0.00,2.04,0.00,'2023-02-22 08:11:05','',''),(2682,'1','308','1',1,'Retail Sale Id 2812',17000.00,0.00,0.00,25.00,-1400.00,'2023-02-22 08:16:49','',''),(2683,'1','308','1',1,'Retail Sale Id 2813',2208.00,0.00,0.00,3.00,0.00,'2023-02-22 08:31:08','',''),(2684,'1','308','1',1,'Retail Sale Id 2814',2944.00,0.00,0.00,4.00,0.00,'2023-02-22 08:34:06','',''),(2685,'1','308','1',1,'Retail Sale Id 2815',2208.00,0.00,0.00,3.00,0.00,'2023-02-22 08:47:19','',''),(2686,'1','308','1',1,'Retail Sale Id 2816',3680.00,0.00,0.00,5.00,0.00,'2023-02-22 08:51:12','',''),(2687,'1','308','1',1,'Retail Sale Id 2817',3680.00,0.00,0.00,5.00,0.00,'2023-02-22 08:52:44','',''),(2688,'1','308','1',1,'Retail Sale Id 2818',4416.00,0.00,0.00,6.00,0.00,'2023-02-22 09:02:37','',''),(2689,'1','308','1',1,'Retail Sale Id 2819',3680.00,0.00,0.00,5.00,0.00,'2023-02-22 09:12:44','',''),(2690,'1','308','1',1,'Retail Sale Id 2820',9200.00,0.00,0.00,12.50,0.00,'2023-02-22 09:16:23','',''),(2691,'1','308','1',1,'Retail Sale Id 2821',2944.00,0.00,0.00,4.00,0.00,'2023-02-22 09:49:29','',''),(2692,'1','308','1',1,'Retail Sale Id 2822',1472.00,0.00,0.00,2.00,0.00,'2023-02-22 10:09:23','',''),(2693,'1','308','1',1,'Retail Sale Id 2823',7360.00,0.00,0.00,10.00,0.00,'2023-02-22 10:12:54','',''),(2694,'1','308','1',1,'Retail Sale Id 2824',3680.00,0.00,0.00,5.00,0.00,'2023-02-22 10:16:07','',''),(2695,'1','308','1',1,'Retail Sale Id 2825',2303.68,0.00,0.00,3.13,0.00,'2023-02-22 10:18:56','',''),(2696,'1','308','1',1,'Retail Sale Id 2826',1501.44,0.00,0.00,2.04,0.00,'2023-02-22 10:20:50','',''),(2697,'1','308','1',1,'Retail Sale Id 2827',3680.00,0.00,0.00,5.00,0.00,'2023-02-22 10:26:03','',''),(2698,'1','308','1',1,'Retail Sale Id 2828',9200.00,0.00,0.00,12.50,0.00,'2023-02-22 10:48:41','',''),(2699,'1','308','1',1,'Retail Sale Id 2829',3680.00,0.00,0.00,5.00,0.00,'2023-02-22 10:53:40','',''),(2700,'1','308','1',1,'Retail Sale Id 2830',5152.00,0.00,0.00,7.00,0.00,'2023-02-22 10:58:52','',''),(2701,'1','308','1',1,'Retail Sale Id 2831',1472.00,0.00,0.00,2.00,0.00,'2023-02-22 11:00:26','',''),(2702,'1','308','1',1,'Retail Sale Id 2832',2944.00,0.00,0.00,4.00,0.00,'2023-02-22 11:02:15','',''),(2703,'1','308','1',1,'Retail Sale Id 2833',1472.00,0.00,0.00,2.00,0.00,'2023-02-22 11:04:03','',''),(2704,'1','308','1',1,'Retail Sale Id 2834',4416.00,0.00,0.00,6.00,0.00,'2023-02-22 11:06:51','',''),(2705,'1','308','1',1,'Retail Sale Id 2835',187000.00,0.00,0.00,275.00,-15400.00,'2023-02-22 11:09:56','',''),(2706,'1','308','1',1,'Retail Sale Id 2836',4416.00,0.00,0.00,6.00,0.00,'2023-02-22 11:40:00','',''),(2707,'1','308','1',1,'Retail Sale Id 2837',4416.00,0.00,0.00,6.00,0.00,'2023-02-22 11:43:06','',''),(2708,'1','308','1',1,'Retail Sale Id 2838',743.36,0.00,0.00,1.01,0.00,'2023-02-22 11:45:19','',''),(2709,'1','308','1',1,'Retail Sale Id 2839',4416.00,0.00,0.00,6.00,0.00,'2023-02-22 11:48:02','',''),(2710,'1','308','1',1,'Retail Sale Id 2840',2944.00,0.00,0.00,4.00,0.00,'2023-02-22 11:50:51','',''),(2711,'1','308','1',1,'Retail Sale Id 2841',2208.00,0.00,0.00,3.00,0.00,'2023-02-22 11:53:33','',''),(2712,'1','308','1',1,'Retail Sale Id 2842',9200.00,0.00,0.00,12.50,0.00,'2023-02-22 11:55:15','',''),(2713,'1','308','1',1,'Retail Sale Id 2843',7360.00,0.00,0.00,10.00,0.00,'2023-02-22 11:58:25','',''),(2714,'1','308','1',1,'Retail Sale Id 2844',4416.00,0.00,0.00,6.00,0.00,'2023-02-22 12:06:00','',''),(2715,'1','308','1',1,'Retail Sale Id 2845',3680.00,0.00,0.00,5.00,0.00,'2023-02-22 12:08:09','',''),(2716,'1','308','1',1,'Retail Sale Id 2846',7360.00,0.00,0.00,10.00,0.00,'2023-02-22 12:11:06','',''),(2717,'1','308','1',1,'Retail Sale Id 2847',2200.64,0.00,0.00,2.99,0.00,'2023-02-22 12:27:50','',''),(2718,'1','308','1',1,'Retail Sale Id 2848',2951.36,0.00,0.00,4.01,0.00,'2023-02-22 12:29:56','',''),(2719,'1','308','1',1,'Retail Sale Id 2849',2951.36,0.00,0.00,4.01,0.00,'2023-02-22 12:31:25','',''),(2720,'1','308','1',1,'Retail Sale Id 2850',2944.00,0.00,0.00,4.00,0.00,'2023-02-22 12:46:27','',''),(2721,'1','308','1',1,'Retail Sale Id 2851',1472.00,0.00,0.00,2.00,0.00,'2023-02-22 13:00:54','',''),(2722,'1','308','1',1,'Retail Sale Id 2852',1472.00,0.00,0.00,2.00,0.00,'2023-02-22 13:10:27','',''),(2723,'1','308','1',1,'Retail Sale Id 2853',2502.40,0.00,0.00,3.40,0.00,'2023-02-22 13:15:20','',''),(2724,'1','308','1',1,'Retail Sale Id 2854',4416.00,0.00,0.00,6.00,0.00,'2023-02-22 13:19:18','',''),(2725,'1','308','1',1,'Retail Sale Id 2855',4416.00,0.00,0.00,6.00,0.00,'2023-02-22 13:21:14','',''),(2726,'1','308','1',1,'Retail Sale Id 2856',1472.00,0.00,0.00,2.00,0.00,'2023-02-22 13:24:12','',''),(2727,'1','308','1',1,'Retail Sale Id 2857',743.36,0.00,0.00,1.01,0.00,'2023-02-22 13:36:37','',''),(2728,'1','308','1',1,'Retail Sale Id 2858',743.36,0.00,0.00,1.01,0.00,'2023-02-22 13:38:33','',''),(2729,'1','308','1',1,'Return of Retail Sale Id 2857',0.00,743.36,1.01,0.00,0.00,'2023-02-22 13:47:16','',''),(2730,'1','308','1',1,'Return of Retail Sale Id 2855',0.00,4416.00,6.00,0.00,0.00,'2023-02-22 13:50:09','',''),(2731,'1','308','1',1,'Retail Sale Id 2863',1501.44,0.00,0.00,2.04,0.00,'2023-02-22 14:39:06','',''),(2732,'1','308','1',1,'Retail Sale Id 2864',1000.96,0.00,0.00,1.36,0.00,'2023-02-22 15:06:07','',''),(2733,'1','308','1',1,'Retail Sale Id 2865',4416.00,0.00,0.00,6.00,0.00,'2023-02-22 15:11:13','',''),(2734,'1','308','1',1,'Retail Sale Id 2866',4496.96,0.00,0.00,6.11,0.00,'2023-02-22 15:12:17','',''),(2735,'1','308','1',1,'Retail Sale Id 2867',55626.88,0.00,0.00,75.58,0.00,'2023-02-22 16:04:54','',''),(2736,'1','308','1',1,'Retail Sale Id 2868',3002.88,0.00,0.00,4.08,0.00,'2023-02-22 16:14:28','',''),(2737,'1','308','1',1,'Retail Sale Id 2869',2944.00,0.00,0.00,4.00,0.00,'2023-02-22 16:26:08','',''),(2738,'1','308','1',1,'Retail Sale Id 2870',743.36,0.00,0.00,1.01,0.00,'2023-02-22 16:53:21','',''),(2739,'1','308','1',1,'Retail Sale Id 2871',1501.44,0.00,0.00,2.04,0.00,'2023-02-22 16:54:43','',''),(2740,'1','308','1',1,'Retail Sale Id 2872',1501.44,0.00,0.00,2.04,0.00,'2023-02-22 16:56:43','',''),(2741,'1','308','1',1,'Retail Sale Id 2873',3702.08,0.00,0.00,5.03,0.00,'2023-02-22 16:58:06','',''),(2742,'1','308','1',1,'Retail Sale Id 2874',2699.60,0.00,0.00,3.97,-222.32,'2023-02-22 17:02:53','',''),(2743,'1','308','1',1,'Retail Sale Id 2875',2208.00,0.00,0.00,3.00,0.00,'2023-02-22 17:04:17','',''),(2744,'1','308','1',1,'Return of Retail Sale Id 2867',0.00,55626.88,75.58,0.00,0.00,'2023-02-22 17:09:40','',''),(2745,'1','308','1',1,'Retail Sale Id 2876',51946.88,0.00,0.00,70.58,0.00,'2023-02-22 17:11:47','',''),(2746,'1','308','1',1,'Retail Sale Id 2877',2208.00,0.00,0.00,3.00,0.00,'2023-02-22 17:12:51','',''),(2747,'1','308','1',1,'Retail Sale Id 2878',2208.00,0.00,0.00,3.00,0.00,'2023-02-22 17:15:00','',''),(2748,'1','308','1',1,'Retail Sale Id 2879',603.52,0.00,0.00,0.82,0.00,'2023-02-22 17:17:22','',''),(2749,'1','308','1',1,'Retail Sale Id 2880',1000.96,0.00,0.00,1.36,0.00,'2023-02-22 17:36:49','',''),(2750,'1','308','1',1,'Retail Sale Id 2881',802.24,0.00,0.00,1.09,0.00,'2023-02-22 18:01:11','',''),(2751,'1','308','1',1,'Retail Sale Id 2882',750.72,0.00,0.00,1.02,0.00,'2023-02-22 18:28:01','',''),(2752,'1','308','1',1,'Retail Sale Id 2883',6646.08,0.00,0.00,9.03,0.00,'2023-02-22 19:42:38','',''),(2753,'1','308','1',1,'Retail Sale Id 2884',4416.00,0.00,0.00,6.00,0.00,'2023-02-23 07:45:36','',''),(2754,'1','308','1',1,'Retail Sale Id 2885',2208.00,0.00,0.00,3.00,0.00,'2023-02-23 07:47:12','',''),(2755,'1','308','1',1,'Retail Sale Id 2886',2001.92,0.00,0.00,2.72,0.00,'2023-02-23 07:48:58','',''),(2756,'1','308','1',1,'Retail Sale Id 2887',1472.00,0.00,0.00,2.00,0.00,'2023-02-23 07:50:55','',''),(2757,'1','308','1',1,'Retail Sale Id 2888',3680.00,0.00,0.00,5.00,0.00,'2023-02-23 07:55:44','',''),(2758,'1','308','1',1,'Retail Sale Id 2889',20400.00,0.00,0.00,30.00,-1680.00,'2023-02-23 07:57:05','',''),(2759,'1','308','1',1,'Retail Sale Id 2890',2944.00,0.00,0.00,4.00,0.00,'2023-02-23 07:58:31','',''),(2760,'1','308','1',1,'Retail Sale Id 2891',4416.00,0.00,0.00,6.00,0.00,'2023-02-23 08:00:41','',''),(2761,'1','308','1',1,'Retail Sale Id 2892',2208.00,0.00,0.00,3.00,0.00,'2023-02-23 08:02:44','',''),(2762,'1','308','1',1,'Retail Sale Id 2893',2208.00,0.00,0.00,3.00,0.00,'2023-02-23 08:11:11','',''),(2763,'1','308','1',1,'Retail Sale Id 2894',2001.92,0.00,0.00,2.72,0.00,'2023-02-23 08:18:19','',''),(2764,'1','308','1',1,'Retail Sale Id 2895',2208.00,0.00,0.00,3.00,0.00,'2023-02-23 08:25:05','',''),(2765,'1','308','1',1,'Retail Sale Id 2896',2944.00,0.00,0.00,4.00,0.00,'2023-02-23 08:30:18','',''),(2766,'1','308','1',1,'Retail Sale Id 2897',4997.44,0.00,0.00,6.79,0.00,'2023-02-23 08:36:50','',''),(2767,'1','308','1',1,'Retail Sale Id 2898',4997.44,0.00,0.00,6.79,0.00,'2023-02-23 08:40:21','',''),(2768,'1','308','1',1,'Retail Sale Id 2899',2502.40,0.00,0.00,3.40,0.00,'2023-02-23 08:42:13','',''),(2769,'1','308','1',1,'Retail Sale Id 2900',4416.00,0.00,0.00,6.00,0.00,'2023-02-23 08:54:20','',''),(2770,'1','308','1',1,'Retail Sale Id 2901',11408.00,0.00,0.00,15.50,0.00,'2023-02-23 09:02:44','',''),(2771,'1','308','1',1,'Retail Sale Id 2902',736.00,0.00,0.00,1.00,0.00,'2023-02-23 09:04:43','',''),(2772,'1','308','1',1,'Retail Sale Id 2903',1472.00,0.00,0.00,2.00,0.00,'2023-02-23 09:06:02','',''),(2773,'1','308','1',1,'Retail Sale Id 2904',2208.00,0.00,0.00,3.00,0.00,'2023-02-23 09:07:13','',''),(2774,'1','308','1',1,'Retail Sale Id 2905',9200.00,0.00,0.00,12.50,0.00,'2023-02-23 09:12:22','',''),(2775,'1','308','1',1,'Retail Sale Id 2906',1472.00,0.00,0.00,2.00,0.00,'2023-02-23 09:13:36','',''),(2776,'1','308','1',1,'Retail Sale Id 2907',2208.00,0.00,0.00,3.00,0.00,'2023-02-23 09:16:18','',''),(2777,'1','308','1',1,'Retail Sale Id 2908',2208.00,0.00,0.00,3.00,0.00,'2023-02-23 09:17:37','',''),(2778,'1','308','1',1,'Retail Sale Id 2909',4416.00,0.00,0.00,6.00,0.00,'2023-02-23 09:18:45','',''),(2779,'1','308','1',1,'Retail Sale Id 2910',8500.00,0.00,0.00,12.50,-700.00,'2023-02-23 09:22:17','',''),(2780,'1','308','1',1,'Retail Sale Id 2911',2208.00,0.00,0.00,3.00,0.00,'2023-02-23 09:27:32','',''),(2781,'1','308','1',1,'Retail Sale Id 2912',2208.00,0.00,0.00,3.00,0.00,'2023-02-23 09:31:51','',''),(2782,'1','308','1',1,'Retail Sale Id 2913',4416.00,0.00,0.00,6.00,0.00,'2023-02-23 09:33:41','',''),(2783,'1','308','1',1,'Retail Sale Id 2914',2208.00,0.00,0.00,3.00,0.00,'2023-02-23 09:38:04','',''),(2784,'1','308','1',1,'Retail Sale Id 2915',1472.00,0.00,0.00,2.00,0.00,'2023-02-23 09:40:39','',''),(2785,'1','308','1',1,'Retail Sale Id 2916',2944.00,0.00,0.00,4.00,0.00,'2023-02-23 09:44:08','',''),(2786,'1','308','1',1,'Retail Sale Id 2917',1501.44,0.00,0.00,2.04,0.00,'2023-02-23 09:49:23','',''),(2787,'1','308','1',1,'Retail Sale Id 2918',1501.44,0.00,0.00,2.04,0.00,'2023-02-23 09:55:35','',''),(2788,'1','308','1',1,'Retail Sale Id 2919',1000.96,0.00,0.00,1.36,0.00,'2023-02-23 10:05:25','',''),(2789,'1','308','1',1,'Retail Sale Id 2920',2502.40,0.00,0.00,3.40,0.00,'2023-02-23 10:09:55','',''),(2790,'1','308','1',1,'Retail Sale Id 2922',2208.00,0.00,0.00,3.00,0.00,'2023-02-23 10:13:58','',''),(2791,'1','308','1',1,'Retail Sale Id 2923',7360.00,0.00,0.00,10.00,0.00,'2023-02-23 10:28:18','',''),(2792,'1','308','1',1,'Retail Sale Id 2924',4416.00,0.00,0.00,6.00,0.00,'2023-02-23 10:31:08','',''),(2793,'1','308','1',1,'Retail Sale Id 2925',5888.00,0.00,0.00,8.00,0.00,'2023-02-23 10:31:47','',''),(2794,'1','308','1',1,'Retail Sale Id 2926',78880.00,0.00,0.00,116.00,-6496.00,'2023-02-23 10:35:37','',''),(2795,'1','308','1',1,'Retail Sale Id 2927',750.72,0.00,0.00,1.02,0.00,'2023-02-23 10:38:19','',''),(2796,'1','308','1',1,'Retail Sale Id 2928',1398.40,0.00,0.00,1.90,0.00,'2023-02-23 10:56:05','',''),(2797,'1','308','1',1,'Retail Sale Id 2929',2944.00,0.00,0.00,4.00,0.00,'2023-02-23 10:58:00','',''),(2798,'1','308','1',1,'Retail Sale Id 2930',9200.00,0.00,0.00,12.50,0.00,'2023-02-23 11:03:37','',''),(2799,'1','308','1',1,'Retail Sale Id 2931',2208.00,0.00,0.00,3.00,0.00,'2023-02-23 11:18:49','',''),(2800,'1','308','1',1,'Retail Sale Id 2932',3680.00,0.00,0.00,5.00,0.00,'2023-02-23 11:21:33','',''),(2801,'1','308','1',1,'Retail Sale Id 2933',750.72,0.00,0.00,1.02,0.00,'2023-02-23 11:29:46','',''),(2802,'1','308','1',1,'Retail Sale Id 2934',1000.96,0.00,0.00,1.36,0.00,'2023-02-23 11:32:37','',''),(2803,'1','308','1',1,'Retail Sale Id 2935',1501.44,0.00,0.00,2.04,0.00,'2023-02-23 11:33:20','',''),(2804,'1','308','1',1,'Retail Sale Id 2936',3702.08,0.00,0.00,5.03,0.00,'2023-02-23 11:36:42','',''),(2805,'1','308','1',1,'Retail Sale Id 2937',3702.08,0.00,0.00,5.03,0.00,'2023-02-23 11:44:02','',''),(2806,'1','308','1',1,'Retail Sale Id 2938',3680.00,0.00,0.00,5.00,0.00,'2023-02-23 12:25:25','',''),(2807,'1','308','1',1,'Retail Sale Id 2939',2208.00,0.00,0.00,3.00,0.00,'2023-02-23 12:28:03','',''),(2808,'1','308','1',1,'Retail Sale Id 2940',3002.88,0.00,0.00,4.08,0.00,'2023-02-23 12:38:42','',''),(2809,'1','308','1',1,'Retail Sale Id 2941',802.24,0.00,0.00,1.09,0.00,'2023-02-23 12:43:04','',''),(2810,'1','308','1',1,'Retail Sale Id 2942',2944.00,0.00,0.00,4.00,0.00,'2023-02-23 13:27:23','',''),(2811,'1','308','1',1,'Retail Sale Id 2943',1472.00,0.00,0.00,2.00,0.00,'2023-02-23 13:29:28','',''),(2812,'1','308','1',1,'Retail Sale Id 2944',3996.48,0.00,0.00,5.43,0.00,'2023-02-23 13:34:03','',''),(2813,'1','308','1',1,'Retail Sale Id 2945',3002.88,0.00,0.00,4.08,0.00,'2023-02-23 13:34:49','',''),(2814,'1','308','1',1,'Retail Sale Id 2946',3002.88,0.00,0.00,4.08,0.00,'2023-02-23 13:36:13','',''),(2815,'1','308','1',1,'Retail Sale Id 2947',4416.00,0.00,0.00,6.00,0.00,'2023-02-23 13:41:44','',''),(2816,'1','308','1',1,'Retail Sale Id 2948',3702.08,0.00,0.00,5.03,0.00,'2023-02-23 13:43:04','',''),(2817,'1','308','1',1,'Retail Sale Id 2949',2208.00,0.00,0.00,3.00,0.00,'2023-02-23 13:44:48','',''),(2818,'1','308','1',1,'Retail Sale Id 2950',7360.00,0.00,0.00,10.00,0.00,'2023-02-23 14:08:12','',''),(2819,'1','308','1',1,'Retail Sale Id 2951',3680.00,0.00,0.00,5.00,0.00,'2023-02-23 14:17:46','',''),(2820,'1','308','1',1,'Retail Sale Id 2952',5888.00,0.00,0.00,8.00,0.00,'2023-02-23 14:19:48','',''),(2821,'1','308','1',1,'Retail Sale Id 2953',2944.00,0.00,0.00,4.00,0.00,'2023-02-23 15:08:10','',''),(2822,'1','308','1',1,'Retail Sale Id 2954',3680.00,0.00,0.00,5.00,0.00,'2023-02-23 15:16:37','',''),(2823,'1','308','1',1,'Retail Sale Id 2955',1472.00,0.00,0.00,2.00,0.00,'2023-02-23 15:21:21','',''),(2824,'1','308','1',1,'Retail Sale Id 2957',2208.00,0.00,0.00,3.00,0.00,'2023-02-23 15:24:30','',''),(2825,'1','308','1',1,'Retail Sale Id 2958',9200.00,0.00,0.00,12.50,0.00,'2023-02-23 15:25:29','',''),(2826,'1','308','1',1,'Retail Sale Id 2959',2208.00,0.00,0.00,3.00,0.00,'2023-02-23 15:29:16','',''),(2827,'1','308','1',1,'Retail Sale Id 2960',2208.00,0.00,0.00,3.00,0.00,'2023-02-23 15:36:40','',''),(2828,'1','308','1',1,'Retail Sale Id 2961',2944.00,0.00,0.00,4.00,0.00,'2023-02-23 15:41:22','',''),(2829,'1','308','1',1,'Retail Sale Id 2962',2944.00,0.00,0.00,4.00,0.00,'2023-02-23 15:56:56','',''),(2830,'1','308','1',1,'Retail Sale Id 2963',1501.44,0.00,0.00,2.04,0.00,'2023-02-23 16:21:54','',''),(2831,'1','308','1',1,'Retail Sale Id 2964',750.72,0.00,0.00,1.02,0.00,'2023-02-23 16:24:34','',''),(2832,'1','308','1',1,'Retail Sale Id 2965',3680.00,0.00,0.00,5.00,0.00,'2023-02-23 17:10:04','',''),(2833,'1','308','1',1,'Retail Sale Id 2966',4416.00,0.00,0.00,6.00,0.00,'2023-02-23 17:11:50','',''),(2834,'1','308','1',1,'Retail Sale Id 2967',2208.00,0.00,0.00,3.00,0.00,'2023-02-23 17:13:11','',''),(2835,'1','308','1',1,'Retail Sale Id 2968',1472.00,0.00,0.00,2.00,0.00,'2023-02-23 17:14:49','',''),(2836,'1','308','1',1,'Retail Sale Id 2969',2944.00,0.00,0.00,4.00,0.00,'2023-02-23 17:34:21','',''),(2837,'1','308','1',1,'Retail Sale Id 2970',2208.00,0.00,0.00,3.00,0.00,'2023-02-23 17:45:49','',''),(2838,'1','308','1',1,'Retail Sale Id 2971',2502.40,0.00,0.00,3.40,0.00,'2023-02-23 17:53:42','',''),(2839,'1','308','1',1,'Retail Sale Id 2972',2200.64,0.00,0.00,2.99,0.00,'2023-02-23 17:55:12','',''),(2840,'1','308','1',1,'Retail Sale Id 2973',6800.00,0.00,0.00,10.00,-560.00,'2023-02-23 18:05:15','',''),(2841,'1','308','1',1,'Retail Sale Id 2974',1501.44,0.00,0.00,2.04,0.00,'2023-02-23 18:22:06','',''),(2842,'1','308','1',1,'Return of Retail Sale Id 2971',0.00,2502.40,3.40,0.00,0.00,'2023-02-23 18:26:04','',''),(2843,'1','308','1',1,'Retail Sale Id 2975',2252.16,0.00,0.00,3.06,0.00,'2023-02-23 18:29:44','',''),(2844,'1','308','1',1,'Retail Sale Id 2976',44.16,0.00,0.00,0.06,0.00,'2023-02-23 18:49:12','',''),(2845,'1','308','1',1,'Retail Sale Id 2977',9200.00,0.00,0.00,12.50,0.00,'2023-02-24 07:32:04','',''),(2846,'1','308','1',1,'Retail Sale Id 2978',1472.00,0.00,0.00,2.00,0.00,'2023-02-24 07:33:45','',''),(2847,'1','308','1',1,'Retail Sale Id 2979',2208.00,0.00,0.00,3.00,0.00,'2023-02-24 07:35:17','',''),(2848,'1','308','1',1,'Retail Sale Id 2980',1472.00,0.00,0.00,2.00,0.00,'2023-02-24 07:36:44','',''),(2849,'1','308','1',1,'Retail Sale Id 2981',2208.00,0.00,0.00,3.00,0.00,'2023-02-24 07:38:25','',''),(2850,'1','308','1',1,'Retail Sale Id 2982',9200.00,0.00,0.00,12.50,0.00,'2023-02-24 07:46:21','',''),(2851,'1','308','1',1,'Retail Sale Id 2983',4416.00,0.00,0.00,6.00,0.00,'2023-02-24 07:56:04','',''),(2852,'1','308','1',1,'Retail Sale Id 2984',9200.00,0.00,0.00,12.50,0.00,'2023-02-24 07:58:03','',''),(2853,'1','308','1',1,'Retail Sale Id 2985',2208.00,0.00,0.00,3.00,0.00,'2023-02-24 07:59:50','',''),(2854,'1','308','1',1,'Retail Sale Id 2986',20400.00,0.00,0.00,30.00,-1680.00,'2023-02-24 08:06:27','',''),(2855,'1','308','1',1,'Retail Sale Id 2987',750.72,0.00,0.00,1.02,0.00,'2023-02-24 08:09:57','',''),(2856,'1','308','1',1,'Retail Sale Id 2988',2944.00,0.00,0.00,4.00,0.00,'2023-02-24 08:27:11','',''),(2857,'1','308','1',1,'Retail Sale Id 2989',2208.00,0.00,0.00,3.00,0.00,'2023-02-24 08:43:29','',''),(2858,'1','308','1',1,'Retail Sale Id 2990',1472.00,0.00,0.00,2.00,0.00,'2023-02-24 08:45:03','',''),(2859,'1','308','1',1,'Retail Sale Id 2991',8832.00,0.00,0.00,12.00,0.00,'2023-02-24 08:46:51','',''),(2860,'1','308','1',1,'Retail Sale Id 2992',2944.00,0.00,0.00,4.00,0.00,'2023-02-24 08:49:03','',''),(2861,'1','308','1',1,'Retail Sale Id 2993',4416.00,0.00,0.00,6.00,0.00,'2023-02-24 08:51:50','',''),(2862,'1','308','1',1,'Retail Sale Id 2994',68000.00,0.00,0.00,100.00,-5600.00,'2023-02-24 08:58:20','',''),(2863,'1','308','1',1,'Retail Sale Id 2995',1472.00,0.00,0.00,2.00,0.00,'2023-02-24 08:59:50','',''),(2864,'1','308','1',1,'Retail Sale Id 2996',2208.00,0.00,0.00,3.00,0.00,'2023-02-24 09:09:29','',''),(2865,'1','308','1',1,'Retail Sale Id 2997',2208.00,0.00,0.00,3.00,0.00,'2023-02-24 09:16:21','',''),(2866,'1','308','1',1,'Retail Sale Id 2998',4416.00,0.00,0.00,6.00,0.00,'2023-02-24 09:22:24','',''),(2867,'1','308','1',1,'Retail Sale Id 2999',9200.00,0.00,0.00,12.50,0.00,'2023-02-24 09:24:15','',''),(2868,'1','308','1',1,'Retail Sale Id 3000',2208.00,0.00,0.00,3.00,0.00,'2023-02-24 09:26:13','',''),(2869,'1','308','1',1,'Retail Sale Id 3001',3002.88,0.00,0.00,4.08,0.00,'2023-02-24 09:27:35','',''),(2870,'1','308','1',1,'Retail Sale Id 3002',2944.00,0.00,0.00,4.00,0.00,'2023-02-24 09:29:54','',''),(2871,'1','308','1',1,'Retail Sale Id 3003',2944.00,0.00,0.00,4.00,0.00,'2023-02-24 09:31:32','',''),(2872,'1','308','1',1,'Retail Sale Id 3005',1501.44,0.00,0.00,2.04,0.00,'2023-02-24 09:36:39','',''),(2873,'1','308','1',1,'Retail Sale Id 3006',2208.00,0.00,0.00,3.00,0.00,'2023-02-24 09:43:07','',''),(2874,'1','308','1',1,'Retail Sale Id 3007',2208.00,0.00,0.00,3.00,0.00,'2023-02-24 09:46:06','',''),(2875,'1','308','1',1,'Retail Sale Id 3008',3680.00,0.00,0.00,5.00,0.00,'2023-02-24 09:49:50','',''),(2876,'1','308','1',1,'Retail Sale Id 3009',1472.00,0.00,0.00,2.00,0.00,'2023-02-24 09:52:20','',''),(2877,'1','308','1',1,'Retail Sale Id 3010',1472.00,0.00,0.00,2.00,0.00,'2023-02-24 09:54:34','',''),(2878,'1','308','1',1,'Retail Sale Id 3011',4416.00,0.00,0.00,6.00,0.00,'2023-02-24 09:59:59','',''),(2879,'1','308','1',1,'Retail Sale Id 3012',2951.36,0.00,0.00,4.01,0.00,'2023-02-24 10:04:32','',''),(2880,'1','308','1',1,'Retail Sale Id 3013',7360.00,0.00,0.00,10.00,0.00,'2023-02-24 10:14:12','',''),(2881,'1','308','1',1,'Retail Sale Id 3014',3680.00,0.00,0.00,5.00,0.00,'2023-02-24 10:17:43','',''),(2882,'1','308','1',1,'Retail Sale Id 3015',1472.00,0.00,0.00,2.00,0.00,'2023-02-24 10:21:27','',''),(2883,'1','308','1',1,'Retail Sale Id 3016',4416.00,0.00,0.00,6.00,0.00,'2023-02-24 10:23:43','',''),(2884,'1','308','1',1,'Retail Sale Id 3017',3680.00,0.00,0.00,5.00,0.00,'2023-02-24 10:29:18','',''),(2885,'1','308','1',1,'Retail Sale Id 3018',2208.00,0.00,0.00,3.00,0.00,'2023-02-24 10:33:37','',''),(2886,'1','308','1',1,'Retail Sale Id 3019',1501.44,0.00,0.00,2.04,0.00,'2023-02-24 10:48:05','',''),(2887,'1','308','1',1,'Retail Sale Id 3020',4416.00,0.00,0.00,6.00,0.00,'2023-02-24 10:50:18','',''),(2888,'1','308','1',1,'Retail Sale Id 3021',2944.00,0.00,0.00,4.00,0.00,'2023-02-24 10:53:00','',''),(2889,'1','308','1',1,'Retail Sale Id 3022',4416.00,0.00,0.00,6.00,0.00,'2023-02-24 10:54:42','',''),(2890,'1','308','1',1,'Retail Sale Id 3023',4416.00,0.00,0.00,6.00,0.00,'2023-02-24 10:57:35','',''),(2891,'1','308','1',1,'Retail Sale Id 3024',4416.00,0.00,0.00,6.00,0.00,'2023-02-24 11:01:57','',''),(2892,'1','308','1',1,'Retail Sale Id 3025',9200.00,0.00,0.00,12.50,0.00,'2023-02-24 11:08:58','',''),(2893,'1','308','1',1,'Retail Sale Id 3026',2944.00,0.00,0.00,4.00,0.00,'2023-02-24 11:10:32','',''),(2894,'1','308','1',1,'Retail Sale Id 3027',3996.48,0.00,0.00,5.43,0.00,'2023-02-24 11:34:07','',''),(2895,'1','308','1',1,'Retail Sale Id 3028',3680.00,0.00,0.00,5.00,0.00,'2023-02-24 11:35:57','',''),(2896,'1','308','1',1,'Retail Sale Id 3029',1472.00,0.00,0.00,2.00,0.00,'2023-02-24 11:38:38','',''),(2897,'1','308','1',1,'Retail Sale Id 3030',4416.00,0.00,0.00,6.00,0.00,'2023-02-24 11:42:25','',''),(2898,'1','308','1',1,'Retail Sale Id 3031',3002.88,0.00,0.00,4.08,0.00,'2023-02-24 11:48:42','',''),(2899,'1','308','1',1,'Retail Sale Id 3032',2502.40,0.00,0.00,3.40,0.00,'2023-02-24 11:50:50','',''),(2900,'1','308','1',1,'Retail Sale Id 3033',2208.00,0.00,0.00,3.00,0.00,'2023-02-24 12:06:44','',''),(2901,'1','308','1',1,'Retail Sale Id 3034',4452.80,0.00,0.00,6.05,0.00,'2023-02-24 12:34:16','',''),(2902,'1','308','1',1,'Retail Sale Id 3035',4416.00,0.00,0.00,6.00,0.00,'2023-02-24 12:44:27','',''),(2903,'1','308','1',1,'Retail Sale Id 3036',4416.00,0.00,0.00,6.00,0.00,'2023-02-24 12:47:03','',''),(2904,'1','308','1',1,'Retail Sale Id 3037',3680.00,0.00,0.00,5.00,0.00,'2023-02-24 12:49:08','',''),(2905,'1','308','1',1,'Retail Sale Id 3038',3680.00,0.00,0.00,5.00,0.00,'2023-02-24 13:07:49','',''),(2906,'1','308','1',1,'Retail Sale Id 3039',2208.00,0.00,0.00,3.00,0.00,'2023-02-24 13:10:23','',''),(2907,'1','308','1',1,'Retail Sale Id 3040',2944.00,0.00,0.00,4.00,0.00,'2023-02-24 13:11:55','',''),(2908,'1','308','1',1,'Retail Sale Id 3041',1472.00,0.00,0.00,2.00,0.00,'2023-02-24 13:13:28','',''),(2909,'1','308','1',1,'Retail Sale Id 3042',3680.00,0.00,0.00,5.00,0.00,'2023-02-24 13:15:10','',''),(2910,'1','308','1',1,'Retail Sale Id 3043',4416.00,0.00,0.00,6.00,0.00,'2023-02-24 13:16:16','',''),(2911,'1','308','1',1,'Retail Sale Id 3044',2944.00,0.00,0.00,4.00,0.00,'2023-02-24 13:22:13','',''),(2912,'1','308','1',1,'Retail Sale Id 3045',2208.00,0.00,0.00,3.00,0.00,'2023-02-24 13:34:00','',''),(2913,'1','308','1',1,'Retail Sale Id 3046',2944.00,0.00,0.00,4.00,0.00,'2023-02-24 13:51:06','',''),(2914,'1','308','1',1,'Retail Sale Id 3047',3680.00,0.00,0.00,5.00,0.00,'2023-02-24 14:12:04','',''),(2915,'1','308','1',1,'Retail Sale Id 3048',2944.00,0.00,0.00,4.00,0.00,'2023-02-24 14:17:44','',''),(2916,'1','308','1',1,'Retail Sale Id 3049',1501.44,0.00,0.00,2.04,0.00,'2023-02-24 14:21:24','',''),(2917,'1','308','1',1,'Retail Sale Id 3050',750.72,0.00,0.00,1.02,0.00,'2023-02-24 15:08:18','',''),(2918,'1','308','1',1,'Retail Sale Id 3051',1501.44,0.00,0.00,2.04,0.00,'2023-02-24 15:11:35','',''),(2919,'1','308','1',1,'Retail Sale Id 3052',7360.00,0.00,0.00,10.00,0.00,'2023-02-24 15:28:13','',''),(2920,'1','308','1',1,'Retail Sale Id 3053',3680.00,0.00,0.00,5.00,0.00,'2023-02-24 15:45:46','',''),(2921,'1','308','1',1,'Retail Sale Id 3054',1104.00,0.00,0.00,1.50,0.00,'2023-02-24 15:54:14','',''),(2922,'1','308','1',1,'Retail Sale Id 3055',17000.00,0.00,0.00,25.00,-1400.00,'2023-02-24 16:04:25','',''),(2923,'1','308','1',1,'Retail Sale Id 3056',2208.00,0.00,0.00,3.00,0.00,'2023-02-24 16:09:58','',''),(2924,'1','308','1',1,'Retail Sale Id 3057',7360.00,0.00,0.00,10.00,0.00,'2023-02-24 16:12:05','',''),(2925,'1','308','1',1,'Retail Sale Id 3058',736.00,0.00,0.00,1.00,0.00,'2023-02-24 16:14:13','',''),(2926,'1','308','1',1,'Retail Sale Id 3059',2001.92,0.00,0.00,2.72,0.00,'2023-02-24 16:17:03','',''),(2927,'1','308','1',1,'Retail Sale Id 3060',3002.88,0.00,0.00,4.08,0.00,'2023-02-24 16:18:19','',''),(2928,'1','308','1',1,'Retail Sale Id 3061',4452.80,0.00,0.00,6.05,0.00,'2023-02-24 16:57:10','',''),(2929,'1','308','1',1,'Retail Sale Id 3062',750.72,0.00,0.00,1.02,0.00,'2023-02-24 17:04:51','',''),(2930,'1','308','1',1,'Retail Sale Id 3063',4416.00,0.00,0.00,6.00,0.00,'2023-02-24 17:27:14','',''),(2931,'1','308','1',1,'Retail Sale Id 3064',5152.00,0.00,0.00,7.00,0.00,'2023-02-24 17:32:49','',''),(2932,'1','308','1',1,'Retail Sale Id 3065',750.72,0.00,0.00,1.02,0.00,'2023-02-24 17:53:24','',''),(2933,'1','308','1',1,'Retail Sale Id 3066',1501.44,0.00,0.00,2.04,0.00,'2023-02-24 18:04:07','',''),(2934,'1','308','1',1,'Retail Sale Id 3067',750.72,0.00,0.00,1.02,0.00,'2023-02-24 18:17:22','',''),(2935,'1','308','1',1,'Retail Sale Id 3068',1501.44,0.00,0.00,2.04,0.00,'2023-02-24 18:20:41','',''),(2936,'1','308','1',1,'Retail Sale Id 3069',2208.00,0.00,0.00,3.00,0.00,'2023-02-24 18:25:27','',''),(2937,'1','308','1',1,'Retail Sale Id 3070',16320.00,0.00,0.00,24.00,-1344.00,'2023-02-24 18:26:28','',''),(2938,'1','308','1',1,'Retail Sale Id 3071',4416.00,0.00,0.00,6.00,0.00,'2023-02-24 18:29:30','',''),(2939,'1','308','1',1,'Retail Sale Id 3072',1000.96,0.00,0.00,1.36,0.00,'2023-02-24 18:37:49','',''),(2940,'1','308','1',1,'Retail Sale Id 3073',750.72,0.00,0.00,1.02,0.00,'2023-02-24 18:38:48','',''),(2941,'1','308','1',1,'Retail Sale Id 3074',9950.72,0.00,0.00,13.52,0.00,'2023-02-24 18:50:45','',''),(2942,'1','308','1',1,'Retail Sale Id 3075',3680.00,0.00,0.00,5.00,0.00,'2023-02-24 18:55:51','',''),(2943,'1','308','1',1,'Retail Sale Id 3076',9200.00,0.00,0.00,12.50,0.00,'2023-02-24 18:57:18','',''),(2944,'1','308','1',1,'Retail Sale Id 3077',51.52,0.00,0.00,0.07,0.00,'2023-02-24 19:37:17','',''),(2945,'1','308','1',1,'Retail Sale Id 3078',4416.00,0.00,0.00,6.00,0.00,'2023-02-26 07:34:41','',''),(2946,'1','308','1',1,'Retail Sale Id 3079',2208.00,0.00,0.00,3.00,0.00,'2023-02-26 07:44:37','',''),(2947,'1','308','1',1,'Retail Sale Id 3080',4416.00,0.00,0.00,6.00,0.00,'2023-02-26 07:49:20','',''),(2948,'1','308','1',1,'Retail Sale Id 3081',1472.00,0.00,0.00,2.00,0.00,'2023-02-26 07:53:11','',''),(2949,'1','308','1',1,'Retail Sale Id 3082',3680.00,0.00,0.00,5.00,0.00,'2023-02-26 07:55:17','',''),(2950,'1','308','1',1,'Retail Sale Id 3083',736.00,0.00,0.00,1.00,0.00,'2023-02-26 08:03:36','',''),(2951,'1','308','1',1,'Retail Sale Id 3084',3002.88,0.00,0.00,4.08,0.00,'2023-02-26 08:17:30','',''),(2952,'1','308','1',1,'Retail Sale Id 3085',2208.00,0.00,0.00,3.00,0.00,'2023-02-26 08:18:31','',''),(2953,'1','308','1',1,'Retail Sale Id 3086',2208.00,0.00,0.00,3.00,0.00,'2023-02-26 08:28:10','',''),(2954,'1','308','1',1,'Retail Sale Id 3087',3680.00,0.00,0.00,5.00,0.00,'2023-02-26 08:33:59','',''),(2955,'1','308','1',1,'Retail Sale Id 3088',1501.44,0.00,0.00,2.04,0.00,'2023-02-26 08:36:25','',''),(2956,'1','308','1',1,'Retail Sale Id 3089',4416.00,0.00,0.00,6.00,0.00,'2023-02-26 08:38:13','',''),(2957,'1','308','1',1,'Retail Sale Id 3090',2944.00,0.00,0.00,4.00,0.00,'2023-02-26 08:46:48','',''),(2958,'1','308','1',1,'Retail Sale Id 3091',2208.00,0.00,0.00,3.00,0.00,'2023-02-26 08:58:48','',''),(2959,'1','308','1',1,'Retail Sale Id 3092',2208.00,0.00,0.00,3.00,0.00,'2023-02-26 09:00:59','',''),(2960,'1','308','1',1,'Retail Sale Id 3093',2944.00,0.00,0.00,4.00,0.00,'2023-02-26 09:12:50','',''),(2961,'1','308','1',1,'Retail Sale Id 3094',9200.00,0.00,0.00,12.50,0.00,'2023-02-26 09:14:14','',''),(2962,'1','308','1',1,'Retail Sale Id 3095',1472.00,0.00,0.00,2.00,0.00,'2023-02-26 09:42:08','',''),(2963,'1','308','1',1,'Retail Sale Id 3096',2944.00,0.00,0.00,4.00,0.00,'2023-02-26 09:44:59','',''),(2964,'1','308','1',1,'Retail Sale Id 3097',3680.00,0.00,0.00,5.00,0.00,'2023-02-26 10:03:46','',''),(2965,'1','308','1',1,'Retail Sale Id 3098',2001.92,0.00,0.00,2.72,0.00,'2023-02-26 10:05:42','',''),(2966,'1','308','1',1,'Retail Sale Id 3099',500.48,0.00,0.00,0.68,0.00,'2023-02-26 10:08:03','',''),(2967,'1','308','1',1,'Retail Sale Id 3100',3680.00,0.00,0.00,5.00,0.00,'2023-02-26 10:10:37','',''),(2968,'1','308','1',1,'Retail Sale Id 3101',4416.00,0.00,0.00,6.00,0.00,'2023-02-26 10:15:01','',''),(2969,'1','308','1',1,'Retail Sale Id 3102',1501.44,0.00,0.00,2.04,0.00,'2023-02-26 10:16:34','',''),(2970,'1','308','1',1,'Retail Sale Id 3103',2208.00,0.00,0.00,3.00,0.00,'2023-02-26 10:17:58','',''),(2971,'1','308','1',1,'Retail Sale Id 3104',1501.44,0.00,0.00,2.04,0.00,'2023-02-26 10:19:09','',''),(2972,'1','308','1',1,'Retail Sale Id 3106',2208.00,0.00,0.00,3.00,0.00,'2023-02-26 10:49:47','',''),(2973,'1','308','1',1,'Retail Sale Id 3107',2001.92,0.00,0.00,2.72,0.00,'2023-02-26 10:56:11','',''),(2974,'1','308','1',1,'Retail Sale Id 3108',2208.00,0.00,0.00,3.00,0.00,'2023-02-26 10:59:38','',''),(2975,'1','308','1',1,'Retail Sale Id 3109',1472.00,0.00,0.00,2.00,0.00,'2023-02-26 11:05:17','',''),(2976,'1','308','1',1,'Retail Sale Id 3110',2208.00,0.00,0.00,3.00,0.00,'2023-02-26 11:13:34','',''),(2977,'1','308','1',1,'Retail Sale Id 3111',2208.00,0.00,0.00,3.00,0.00,'2023-02-26 11:17:50','',''),(2978,'1','308','1',1,'Retail Sale Id 3112',750.72,0.00,0.00,1.02,0.00,'2023-02-26 11:27:27','',''),(2979,'1','308','1',1,'Retail Sale Id 3113',30600.00,0.00,0.00,45.00,-2520.00,'2023-02-26 11:31:42','',''),(2980,'1','308','1',1,'Retail Sale Id 3114',2944.00,0.00,0.00,4.00,0.00,'2023-02-26 11:33:46','',''),(2981,'1','308','1',1,'Retail Sale Id 3115',2208.00,0.00,0.00,3.00,0.00,'2023-02-26 11:35:29','',''),(2982,'1','308','1',1,'Return of Retail Sale Id 3112',0.00,750.72,1.02,0.00,0.00,'2023-02-26 11:55:18','',''),(2983,'1','308','1',1,'Retail Sale Id 3118',1398.40,0.00,0.00,1.90,0.00,'2023-02-26 11:57:39','',''),(2984,'1','308','1',1,'Retail Sale Id 3120',1472.00,0.00,0.00,2.00,0.00,'2023-02-26 12:13:42','',''),(2985,'1','308','1',1,'Retail Sale Id 3121',1000.96,0.00,0.00,1.36,0.00,'2023-02-26 12:39:49','',''),(2986,'1','308','1',1,'Retail Sale Id 3122',743.36,0.00,0.00,1.01,0.00,'2023-02-26 13:05:39','',''),(2987,'1','308','1',1,'Retail Sale Id 3123',1501.44,0.00,0.00,2.04,0.00,'2023-02-26 14:56:17','',''),(2988,'1','308','1',1,'Retail Sale Id 3124',3503.36,0.00,0.00,4.76,0.00,'2023-02-26 15:48:56','',''),(2989,'1','308','1',1,'Retail Sale Id 3125',802.24,0.00,0.00,1.09,0.00,'2023-02-26 16:29:33','',''),(2990,'1','308','1',1,'Retail Sale Id 3126',750.72,0.00,0.00,1.02,0.00,'2023-02-26 16:33:18','',''),(2991,'1','308','1',1,'Retail Sale Id 3127',1501.44,0.00,0.00,2.04,0.00,'2023-02-26 17:42:22','',''),(2992,'1','308','1',1,'Retail Sale Id 3128',750.72,0.00,0.00,1.02,0.00,'2023-02-26 17:45:39','',''),(2993,'1','308','1',1,'Retail Sale Id 3129',1501.44,0.00,0.00,2.04,0.00,'2023-02-26 17:54:55','',''),(2994,'1','308','1',1,'Retail Sale Id 3130',6800.00,0.00,0.00,10.00,-560.00,'2023-02-26 17:57:05','',''),(2995,'1','308','1',1,'Retail Sale Id 3131',500.48,0.00,0.00,0.68,0.00,'2023-02-26 17:57:36','',''),(2996,'1','308','1',1,'Retail Sale Id 3132',610.88,0.00,0.00,0.83,0.00,'2023-02-26 19:12:59','',''),(2997,'1','308','1',1,'Retail Sale Id 3133',7360.00,0.00,0.00,10.00,0.00,'2023-02-27 07:38:31','',''),(2998,'1','308','1',1,'Retail Sale Id 3134',1501.44,0.00,0.00,2.04,0.00,'2023-02-27 07:41:37','',''),(2999,'1','308','1',1,'Retail Sale Id 3135',1501.44,0.00,0.00,2.04,0.00,'2023-02-27 08:18:02','',''),(3000,'1','308','1',1,'Retail Sale Id 3136',3680.00,0.00,0.00,5.00,0.00,'2023-02-27 08:27:48','',''),(3001,'1','308','1',1,'Retail Sale Id 3137',20400.00,0.00,0.00,30.00,-1680.00,'2023-02-27 08:35:51','',''),(3002,'1','308','1',1,'Retail Sale Id 3138',2208.00,0.00,0.00,3.00,0.00,'2023-02-27 08:37:43','',''),(3003,'1','308','1',1,'Retail Sale Id 3139',736.00,0.00,0.00,1.00,0.00,'2023-02-27 08:48:48','',''),(3004,'1','308','1',1,'Retail Sale Id 3140',2944.00,0.00,0.00,4.00,0.00,'2023-02-27 08:50:34','',''),(3005,'1','308','1',1,'Retail Sale Id 3141',4416.00,0.00,0.00,6.00,0.00,'2023-02-27 08:52:24','',''),(3006,'1','308','1',1,'Retail Sale Id 3142',2208.00,0.00,0.00,3.00,0.00,'2023-02-27 09:01:45','',''),(3007,'1','308','1',1,'Retail Sale Id 3143',4416.00,0.00,0.00,6.00,0.00,'2023-02-27 09:16:16','',''),(3008,'1','308','1',1,'Retail Sale Id 3144',1000.96,0.00,0.00,1.36,0.00,'2023-02-27 09:26:17','',''),(3009,'1','308','1',1,'Retail Sale Id 3145',736.00,0.00,0.00,1.00,0.00,'2023-02-27 09:32:32','',''),(3010,'1','308','1',1,'Retail Sale Id 3146',2208.00,0.00,0.00,3.00,0.00,'2023-02-27 09:33:47','',''),(3011,'1','308','1',1,'Retail Sale Id 3147',3680.00,0.00,0.00,5.00,0.00,'2023-02-27 09:42:16','',''),(3012,'1','308','1',1,'Retail Sale Id 3148',1501.44,0.00,0.00,2.04,0.00,'2023-02-27 09:44:43','',''),(3013,'1','308','1',1,'Retail Sale Id 3149',2208.00,0.00,0.00,3.00,0.00,'2023-02-27 09:48:09','',''),(3014,'1','308','1',1,'Retail Sale Id 3150',2001.92,0.00,0.00,2.72,0.00,'2023-02-27 09:52:53','',''),(3015,'1','308','1',1,'Retail Sale Id 3151',3680.00,0.00,0.00,5.00,0.00,'2023-02-27 10:12:50','',''),(3016,'1','308','1',1,'Retail Sale Id 3152',2208.00,0.00,0.00,3.00,0.00,'2023-02-27 10:19:44','',''),(3017,'1','308','1',1,'Retail Sale Id 3153',4416.00,0.00,0.00,6.00,0.00,'2023-02-27 10:26:50','',''),(3018,'1','308','1',1,'Retail Sale Id 3154',9200.00,0.00,0.00,12.50,0.00,'2023-02-27 10:29:40','',''),(3019,'1','308','1',1,'Retail Sale Id 3156',4452.80,0.00,0.00,6.05,0.00,'2023-02-27 10:47:47','',''),(3020,'1','308','1',1,'Retail Sale Id 3157',1472.00,0.00,0.00,2.00,0.00,'2023-02-27 11:20:15','',''),(3021,'1','308','1',1,'Retail Sale Id 3158',17000.00,0.00,0.00,25.00,-1400.00,'2023-02-27 11:31:42','',''),(3022,'1','308','1',1,'Retail Sale Id 3159',2208.00,0.00,0.00,3.00,0.00,'2023-02-27 11:51:10','',''),(3023,'1','308','1',1,'Retail Sale Id 3160',1472.00,0.00,0.00,2.00,0.00,'2023-02-27 12:24:32','',''),(3024,'1','308','1',1,'Retail Sale Id 3161',3680.00,0.00,0.00,5.00,0.00,'2023-02-27 12:31:08','',''),(3025,'1','308','1',1,'Retail Sale Id 3162',1472.00,0.00,0.00,2.00,0.00,'2023-02-27 12:40:49','',''),(3026,'1','308','1',1,'Retail Sale Id 3163',3680.00,0.00,0.00,5.00,0.00,'2023-02-27 12:46:55','',''),(3027,'1','308','1',1,'Retail Sale Id 3164',4997.44,0.00,0.00,6.79,0.00,'2023-02-27 14:58:06','',''),(3028,'1','308','1',1,'Retail Sale Id 3165',6624.00,0.00,0.00,9.00,0.00,'2023-02-27 14:59:19','',''),(3029,'1','308','1',1,'Retail Sale Id 3166',3680.00,0.00,0.00,5.00,0.00,'2023-02-27 15:07:09','',''),(3030,'1','308','1',1,'Retail Sale Id 3167',2208.00,0.00,0.00,3.00,0.00,'2023-02-27 15:20:43','',''),(3031,'1','308','1',1,'Retail Sale Id 3168',9200.00,0.00,0.00,12.50,0.00,'2023-02-27 15:35:44','',''),(3032,'1','308','1',1,'Retail Sale Id 3169',9200.00,0.00,0.00,12.50,0.00,'2023-02-27 15:37:05','',''),(3033,'1','308','1',1,'Retail Sale Id 3170',2944.00,0.00,0.00,4.00,0.00,'2023-02-27 15:38:17','',''),(3034,'1','308','1',1,'Retail Sale Id 3171',1501.44,0.00,0.00,2.04,0.00,'2023-02-27 15:42:54','',''),(3035,'1','308','1',1,'Retail Sale Id 3172',750.72,0.00,0.00,1.02,0.00,'2023-02-27 15:43:55','',''),(3036,'1','308','1',1,'Retail Sale Id 3173',2001.92,0.00,0.00,2.72,0.00,'2023-02-27 15:58:39','',''),(3037,'1','308','1',1,'Retail Sale Id 3174',1501.44,0.00,0.00,2.04,0.00,'2023-02-27 16:22:02','',''),(3038,'1','308','1',1,'Retail Sale Id 3175',2208.00,0.00,0.00,3.00,0.00,'2023-02-27 16:24:53','',''),(3039,'1','308','1',1,'Retail Sale Id 3176',3680.00,0.00,0.00,5.00,0.00,'2023-02-27 16:29:21','',''),(3040,'1','308','1',1,'Retail Sale Id 3177',4416.00,0.00,0.00,6.00,0.00,'2023-02-27 16:32:56','',''),(3041,'1','308','1',1,'Retail Sale Id 3178',2208.00,0.00,0.00,3.00,0.00,'2023-02-27 16:34:45','',''),(3042,'1','308','1',1,'Retail Sale Id 3179',1472.00,0.00,0.00,2.00,0.00,'2023-02-27 16:37:54','',''),(3043,'1','308','1',1,'Retail Sale Id 3180',2944.00,0.00,0.00,4.00,0.00,'2023-02-27 16:43:22','',''),(3044,'1','308','1',1,'Retail Sale Id 3181',2208.00,0.00,0.00,3.00,0.00,'2023-02-27 16:46:22','',''),(3045,'1','308','1',1,'Retail Sale Id 3182',9200.00,0.00,0.00,12.50,0.00,'2023-02-27 16:48:46','',''),(3046,'1','308','1',1,'Retail Sale Id 3183',4416.00,0.00,0.00,6.00,0.00,'2023-02-27 17:21:22','',''),(3047,'1','308','1',1,'Retail Sale Id 3184',4416.00,0.00,0.00,6.00,0.00,'2023-02-27 18:05:39','',''),(3048,'1','308','1',1,'Retail Sale Id 3185',2944.00,0.00,0.00,4.00,0.00,'2023-02-27 18:29:54','',''),(3049,'1','308','1',1,'Retail Sale Id 3186',2944.00,0.00,0.00,4.00,0.00,'2023-02-27 18:31:34','',''),(3050,'1','308','1',1,'Retail Sale Id 3187',14.72,0.00,0.00,0.02,0.00,'2023-02-27 19:18:57','',''),(3051,'1','308','1',1,'Retail Sale Id 3188',17000.00,0.00,0.00,25.00,-1400.00,'2023-02-28 07:46:44','',''),(3052,'1','308','1',1,'Retail Sale Id 3189',3680.00,0.00,0.00,5.00,0.00,'2023-02-28 07:48:37','',''),(3053,'1','308','1',1,'Retail Sale Id 3190',2208.00,0.00,0.00,3.00,0.00,'2023-02-28 07:56:42','',''),(3054,'1','308','1',1,'Retail Sale Id 3191',5998.40,0.00,0.00,8.15,0.00,'2023-02-28 08:00:49','',''),(3055,'1','308','1',1,'Retail Sale Id 3192',20400.00,0.00,0.00,30.00,-1680.00,'2023-02-28 08:03:57','',''),(3056,'1','308','1',1,'Retail Sale Id 3193',5152.00,0.00,0.00,7.00,0.00,'2023-02-28 08:05:43','',''),(3057,'1','308','1',1,'Retail Sale Id 3194',9200.00,0.00,0.00,12.50,0.00,'2023-02-28 08:07:03','',''),(3058,'1','308','1',1,'Retail Sale Id 3195',750.72,0.00,0.00,1.02,0.00,'2023-02-28 08:08:39','',''),(3059,'1','308','1',1,'Retail Sale Id 3196',4416.00,0.00,0.00,6.00,0.00,'2023-02-28 08:10:49','',''),(3060,'1','308','1',1,'Retail Sale Id 3197',736.00,0.00,0.00,1.00,0.00,'2023-02-28 08:12:29','',''),(3061,'1','308','1',1,'Retail Sale Id 3198',2208.00,0.00,0.00,3.00,0.00,'2023-02-28 08:19:17','',''),(3062,'1','308','1',1,'Retail Sale Id 3199',7360.00,0.00,0.00,10.00,0.00,'2023-02-28 08:43:55','',''),(3063,'1','308','1',1,'Retail Sale Id 3200',1472.00,0.00,0.00,2.00,0.00,'2023-02-28 08:48:13','',''),(3064,'1','308','1',1,'Retail Sale Id 3201',4416.00,0.00,0.00,6.00,0.00,'2023-02-28 08:50:43','',''),(3065,'1','308','1',1,'Retail Sale Id 3202',3680.00,0.00,0.00,5.00,0.00,'2023-02-28 08:56:27','',''),(3066,'1','308','1',1,'Retail Sale Id 3203',4416.00,0.00,0.00,6.00,0.00,'2023-02-28 09:07:15','',''),(3067,'1','308','1',1,'Retail Sale Id 3204',4416.00,0.00,0.00,6.00,0.00,'2023-02-28 09:08:51','',''),(3068,'1','308','1',1,'Retail Sale Id 3205',7360.00,0.00,0.00,10.00,0.00,'2023-02-28 09:10:18','',''),(3069,'1','308','1',1,'Retail Sale Id 3206',1000.96,0.00,0.00,1.36,0.00,'2023-02-28 09:12:00','',''),(3070,'1','308','1',1,'Retail Sale Id 3207',4416.00,0.00,0.00,6.00,0.00,'2023-02-28 09:13:37','',''),(3071,'1','308','1',1,'Retail Sale Id 3208',2208.00,0.00,0.00,3.00,0.00,'2023-02-28 09:18:56','',''),(3072,'1','308','1',1,'Retail Sale Id 3209',1199.68,0.00,0.00,1.63,0.00,'2023-02-28 09:23:23','',''),(3073,'1','308','1',1,'Retail Sale Id 3210',1096.64,0.00,0.00,1.49,0.00,'2023-02-28 09:24:32','',''),(3074,'1','308','1',1,'Retail Sale Id 3211',1472.00,0.00,0.00,2.00,0.00,'2023-02-28 09:51:25','',''),(3075,'1','308','1',1,'Retail Sale Id 3212',5888.00,0.00,0.00,8.00,0.00,'2023-02-28 10:05:57','',''),(3076,'1','308','1',1,'Retail Sale Id 3213',3680.00,0.00,0.00,5.00,0.00,'2023-02-28 10:09:20','',''),(3077,'1','308','1',1,'Retail Sale Id 3215',9200.00,0.00,0.00,12.50,0.00,'2023-02-28 10:13:25','',''),(3078,'1','308','1',1,'Retail Sale Id 3216',3680.00,0.00,0.00,5.00,0.00,'2023-02-28 10:15:15','',''),(3079,'1','308','1',1,'Retail Sale Id 3217',8464.00,0.00,0.00,11.50,0.00,'2023-02-28 10:18:12','',''),(3080,'1','308','1',1,'Retail Sale Id 3218',7360.00,0.00,0.00,10.00,0.00,'2023-02-28 10:23:48','',''),(3081,'1','308','1',1,'Retail Sale Id 3219',2208.00,0.00,0.00,3.00,0.00,'2023-02-28 10:33:02','',''),(3082,'1','308','1',1,'Retail Sale Id 3220',1803.20,0.00,0.00,2.45,0.00,'2023-02-28 11:15:19','',''),(3083,'1','308','1',1,'Retail Sale Id 3221',1501.44,0.00,0.00,2.04,0.00,'2023-02-28 12:00:28','',''),(3084,'1','308','1',1,'Retail Sale Id 3222',118320.00,0.00,0.00,174.00,-9744.00,'2023-02-28 12:06:37','',''),(3085,'1','308','1',1,'Retail Sale Id 3223',17000.00,0.00,0.00,25.00,-1400.00,'2023-02-28 12:09:19','',''),(3086,'1','308','1',1,'Retail Sale Id 3224',2944.00,0.00,0.00,4.00,0.00,'2023-02-28 12:13:43','',''),(3087,'1','308','1',1,'Retail Sale Id 3225',2001.92,0.00,0.00,2.72,0.00,'2023-02-28 12:43:46','',''),(3088,'1','308','1',1,'Retail Sale Id 3226',3680.00,0.00,0.00,5.00,0.00,'2023-02-28 12:55:04','',''),(3089,'1','308','1',1,'Retail Sale Id 3227',8832.00,0.00,0.00,12.00,0.00,'2023-02-28 12:56:54','',''),(3090,'1','308','1',1,'Retail Sale Id 3228',2944.00,0.00,0.00,4.00,0.00,'2023-02-28 13:00:44','',''),(3091,'1','308','1',1,'Retail Sale Id 3229',2944.00,0.00,0.00,4.00,0.00,'2023-02-28 13:08:44','',''),(3092,'1','308','1',1,'Retail Sale Id 3230',1472.00,0.00,0.00,2.00,0.00,'2023-02-28 13:17:10','',''),(3093,'1','308','1',1,'Retail Sale Id 3231',5888.00,0.00,0.00,8.00,0.00,'2023-02-28 13:35:09','',''),(3094,'1','308','1',1,'Retail Sale Id 3232',2944.00,0.00,0.00,4.00,0.00,'2023-02-28 13:37:35','',''),(3095,'1','308','1',1,'Retail Sale Id 3233',1000.96,0.00,0.00,1.36,0.00,'2023-02-28 13:49:09','',''),(3096,'1','308','1',1,'Retail Sale Id 3234',2208.00,0.00,0.00,3.00,0.00,'2023-02-28 13:51:09','',''),(3097,'1','308','1',1,'Retail Sale Id 3235',2944.00,0.00,0.00,4.00,0.00,'2023-02-28 13:58:02','',''),(3098,'1','308','1',1,'Retail Sale Id 3236',7360.00,0.00,0.00,10.00,0.00,'2023-02-28 14:01:41','',''),(3099,'1','308','1',1,'Retail Sale Id 3237',1000.96,0.00,0.00,1.36,0.00,'2023-02-28 14:03:45','',''),(3100,'1','308','1',1,'Retail Sale Id 3238',4416.00,0.00,0.00,6.00,0.00,'2023-02-28 14:17:45','',''),(3101,'1','308','1',1,'Retail Sale Id 3239',500.48,0.00,0.00,0.68,0.00,'2023-02-28 14:32:34','',''),(3102,'1','308','1',1,'Retail Sale Id 3241',2208.00,0.00,0.00,3.00,0.00,'2023-02-28 14:53:37','',''),(3103,'1','308','1',1,'Retail Sale Id 3242',3680.00,0.00,0.00,5.00,0.00,'2023-02-28 14:58:52','',''),(3104,'1','308','1',1,'Retail Sale Id 3243',9200.00,0.00,0.00,12.50,0.00,'2023-02-28 15:01:10','',''),(3105,'1','308','1',1,'Retail Sale Id 3244',3680.00,0.00,0.00,5.00,0.00,'2023-02-28 15:09:48','',''),(3106,'1','308','1',1,'Retail Sale Id 3245',2951.36,0.00,0.00,4.01,0.00,'2023-02-28 15:40:58','',''),(3107,'1','308','1',1,'Retail Sale Id 3247',4416.00,0.00,0.00,6.00,0.00,'2023-02-28 15:53:39','',''),(3108,'1','308','1',1,'Retail Sale Id 3248',1472.00,0.00,0.00,2.00,0.00,'2023-02-28 16:14:47','',''),(3109,'1','308','1',1,'Retail Sale Id 3249',2208.00,0.00,0.00,3.00,0.00,'2023-02-28 16:16:27','',''),(3110,'1','308','1',1,'Retail Sale Id 3250',2208.00,0.00,0.00,3.00,0.00,'2023-02-28 16:19:54','',''),(3111,'1','308','1',1,'Retail Sale Id 3251',2944.00,0.00,0.00,4.00,0.00,'2023-02-28 16:23:03','',''),(3112,'1','308','1',1,'Retail Sale Id 3252',1472.00,0.00,0.00,2.00,0.00,'2023-02-28 16:48:34','',''),(3113,'1','308','1',1,'Retail Sale Id 3253',1472.00,0.00,0.00,2.00,0.00,'2023-02-28 16:50:30','',''),(3114,'1','308','1',1,'Retail Sale Id 3255',2208.00,0.00,0.00,3.00,0.00,'2023-02-28 17:17:56','',''),(3115,'1','308','1',1,'Retail Sale Id 3256',1472.00,0.00,0.00,2.00,0.00,'2023-02-28 17:19:36','',''),(3116,'1','308','1',1,'Retail Sale Id 3257',4416.00,0.00,0.00,6.00,0.00,'2023-02-28 17:21:21','',''),(3117,'1','308','1',1,'Retail Sale Id 3258',2208.00,0.00,0.00,3.00,0.00,'2023-02-28 17:24:42','',''),(3118,'1','308','1',1,'Retail Sale Id 3259',1472.00,0.00,0.00,2.00,0.00,'2023-02-28 17:29:47','',''),(3119,'1','308','1',1,'Retail Sale Id 3260',7360.00,0.00,0.00,10.00,0.00,'2023-02-28 17:30:47','',''),(3120,'1','308','1',1,'Retail Sale Id 3262',2208.00,0.00,0.00,3.00,0.00,'2023-02-28 18:04:58','',''),(3121,'1','308','1',1,'Retail Sale Id 3263',3680.00,0.00,0.00,5.00,0.00,'2023-02-28 18:06:43','',''),(3122,'1','308','1',1,'Retail Sale Id 3264',4416.00,0.00,0.00,6.00,0.00,'2023-02-28 18:08:37','',''),(3123,'1','308','1',1,'Retail Sale Id 3265',44.16,0.00,0.00,0.06,0.00,'2023-02-28 19:13:38','',''),(3124,'1','308','1',1,'Retail Sale Id 3266',1472.00,0.00,0.00,2.00,0.00,'2023-03-01 07:21:04','',''),(3125,'1','308','1',1,'Retail Sale Id 3267',2208.00,0.00,0.00,3.00,0.00,'2023-03-01 07:23:05','',''),(3126,'1','308','1',1,'Retail Sale Id 3268',2208.00,0.00,0.00,3.00,0.00,'2023-03-01 07:25:42','',''),(3127,'1','308','1',1,'Retail Sale Id 3270',1472.00,0.00,0.00,2.00,0.00,'2023-03-01 07:58:25','',''),(3128,'1','308','1',1,'Retail Sale Id 3271',9200.00,0.00,0.00,12.50,0.00,'2023-03-01 08:05:57','',''),(3129,'1','308','1',1,'Retail Sale Id 3272',4416.00,0.00,0.00,6.00,0.00,'2023-03-01 08:24:21','',''),(3130,'1','308','1',1,'Retail Sale Id 3273',2208.00,0.00,0.00,3.00,0.00,'2023-03-01 08:26:26','',''),(3131,'1','308','1',1,'Retail Sale Id 3274',1472.00,0.00,0.00,2.00,0.00,'2023-03-01 08:32:43','',''),(3132,'1','308','1',1,'Retail Sale Id 3275',1501.44,0.00,0.00,2.04,0.00,'2023-03-01 08:42:16','',''),(3133,'1','308','1',1,'Retail Sale Id 3276',4416.00,0.00,0.00,6.00,0.00,'2023-03-01 08:49:26','',''),(3134,'1','308','1',1,'Retail Sale Id 3277',2001.92,0.00,0.00,2.72,0.00,'2023-03-01 08:54:34','',''),(3135,'1','308','1',1,'Retail Sale Id 3278',4416.00,0.00,0.00,6.00,0.00,'2023-03-01 08:59:23','',''),(3136,'1','308','1',1,'Retail Sale Id 3279',2208.00,0.00,0.00,3.00,0.00,'2023-03-01 09:00:54','',''),(3137,'1','308','1',1,'Retail Sale Id 3280',2001.92,0.00,0.00,2.72,0.00,'2023-03-01 09:22:49','',''),(3138,'1','308','1',1,'Retail Sale Id 3281',20400.00,0.00,0.00,30.00,-1680.00,'2023-03-01 09:26:55','',''),(3139,'1','308','1',1,'Retail Sale Id 3282',4416.00,0.00,0.00,6.00,0.00,'2023-03-01 09:28:27','',''),(3140,'1','308','1',1,'Retail Sale Id 3283',3680.00,0.00,0.00,5.00,0.00,'2023-03-01 09:34:01','',''),(3141,'1','308','1',1,'Retail Sale Id 3284',1472.00,0.00,0.00,2.00,0.00,'2023-03-01 09:38:30','',''),(3142,'1','308','1',1,'Retail Sale Id 3285',1000.96,0.00,0.00,1.36,0.00,'2023-03-01 09:40:06','',''),(3143,'1','308','1',1,'Retail Sale Id 3286',750.72,0.00,0.00,1.02,0.00,'2023-03-01 09:41:24','',''),(3144,'1','308','1',1,'Retail Sale Id 3287',187000.00,0.00,0.00,275.00,-15400.00,'2023-03-01 10:17:16','',''),(3145,'1','308','1',1,'Retail Sale Id 3288',1501.44,0.00,0.00,2.04,0.00,'2023-03-01 11:23:39','',''),(3146,'1','308','1',1,'Retail Sale Id 3291',1472.00,0.00,0.00,2.00,0.00,'2023-03-01 13:10:25','',''),(3147,'1','308','1',1,'Retail Sale Id 3292',20400.00,0.00,0.00,30.00,-1680.00,'2023-03-01 14:10:51','',''),(3148,'1','308','1',1,'Return of Retail Sale Id 3286',0.00,750.72,1.02,0.00,0.00,'2023-03-01 14:39:38','',''),(3149,'1','308','1',1,'Retail Sale Id 3294',3002.88,0.00,0.00,4.08,0.00,'2023-03-01 14:46:55','',''),(3150,'1','308','1',1,'Retail Sale Id 3295',3002.88,0.00,0.00,4.08,0.00,'2023-03-01 14:48:30','',''),(3151,'1','308','1',1,'Retail Sale Id 3296',1472.00,0.00,0.00,2.00,0.00,'2023-03-01 15:10:51','',''),(3152,'1','308','1',1,'Retail Sale Id 3297',2208.00,0.00,0.00,3.00,0.00,'2023-03-01 16:21:30','',''),(3153,'1','308','1',1,'Retail Sale Id 3298',9200.00,0.00,0.00,12.50,0.00,'2023-03-01 16:26:26','',''),(3154,'1','308','1',1,'Retail Sale Id 3299',1479.36,0.00,0.00,2.01,0.00,'2023-03-01 16:27:39','',''),(3155,'1','308','1',1,'Retail Sale Id 3300',1501.44,0.00,0.00,2.04,0.00,'2023-03-01 16:58:02','',''),(3156,'1','308','1',1,'Retail Sale Id 3301',4423.36,0.00,0.00,6.01,0.00,'2023-03-01 16:58:49','',''),(3157,'1','308','1',1,'Retail Sale Id 3302',17000.00,0.00,0.00,25.00,-1400.00,'2023-03-01 17:03:08','',''),(3158,'1','308','1',1,'Retail Sale Id 3303',3002.88,0.00,0.00,4.08,0.00,'2023-03-01 17:12:13','',''),(3159,'1','308','1',1,'Retail Sale Id 3304',3002.88,0.00,0.00,4.08,0.00,'2023-03-01 17:13:55','',''),(3160,'1','308','1',1,'Retail Sale Id 3305',2208.00,0.00,0.00,3.00,0.00,'2023-03-01 17:18:53','',''),(3161,'1','308','1',1,'Retail Sale Id 3306',3002.88,0.00,0.00,4.08,0.00,'2023-03-01 17:21:04','',''),(3162,'1','308','1',1,'Retail Sale Id 3307',3002.88,0.00,0.00,4.08,0.00,'2023-03-01 17:22:13','',''),(3163,'1','308','1',1,'Retail Sale Id 3308',2944.00,0.00,0.00,4.00,0.00,'2023-03-01 17:33:50','',''),(3164,'1','308','1',1,'Retail Sale Id 3309',1501.44,0.00,0.00,2.04,0.00,'2023-03-01 17:34:50','',''),(3165,'1','308','1',1,'Retail Sale Id 3310',4423.36,0.00,0.00,6.01,0.00,'2023-03-01 17:42:51','',''),(3166,'1','308','1',1,'Retail Sale Id 3311',1501.44,0.00,0.00,2.04,0.00,'2023-03-01 17:51:29','',''),(3167,'1','308','1',1,'Retail Sale Id 3312',2208.00,0.00,0.00,3.00,0.00,'2023-03-01 17:58:34','',''),(3168,'1','308','1',1,'Retail Sale Id 3313',3002.88,0.00,0.00,4.08,0.00,'2023-03-01 18:04:29','',''),(3169,'1','308','1',1,'Retail Sale Id 3314',1501.44,0.00,0.00,2.04,0.00,'2023-03-01 18:13:35','',''),(3170,'1','308','1',1,'Retail Sale Id 3315',3680.00,0.00,0.00,5.00,0.00,'2023-03-01 18:17:45','',''),(3171,'1','308','1',1,'Retail Sale Id 3317',1501.44,0.00,0.00,2.04,0.00,'2023-03-01 18:26:40','',''),(3172,'1','308','1',1,'Retail Sale Id 3318',3680.00,0.00,0.00,5.00,0.00,'2023-03-01 18:29:32','',''),(3173,'1','308','1',1,'Retail Sale Id 3319',1501.44,0.00,0.00,2.04,0.00,'2023-03-01 18:47:18','',''),(3174,'1','308','1',1,'Retail Sale Id 3320',4416.00,0.00,0.00,6.00,0.00,'2023-03-01 18:50:22','',''),(3175,'1','308','1',1,'Retail Sale Id 3321',787.52,0.00,0.00,1.07,0.00,'2023-03-01 19:14:14','',''),(3176,'1','308',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,736000.00,1000.00,0.00,0.00,'2023-03-02 06:59:27','',''),(3177,'1','308',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,1000.00,0.00,'2023-03-02 07:00:27','',''),(3178,'1','308','1',1,'Received from bridging 9',0.00,0.00,1000.00,0.00,0.00,'2023-03-02 07:00:27','',''),(3179,'1','308','1',1,'Retail Sale Id 3323',2208.00,0.00,0.00,3.00,0.00,'2023-03-02 07:54:09','',''),(3180,'1','308','1',1,'Retail Sale Id 3325',1501.44,0.00,0.00,2.04,0.00,'2023-03-02 07:57:04','',''),(3181,'1','308','1',1,'Retail Sale Id 3326',1501.44,0.00,0.00,2.04,0.00,'2023-03-02 07:58:38','',''),(3182,'1','308','1',1,'Retail Sale Id 3327',2208.00,0.00,0.00,3.00,0.00,'2023-03-02 07:59:32','',''),(3183,'1','308','1',1,'Retail Sale Id 3329',1803.20,0.00,0.00,2.45,0.00,'2023-03-02 08:12:25','',''),(3184,'1','308','1',1,'Retail Sale Id 3330',2001.92,0.00,0.00,2.72,0.00,'2023-03-02 08:18:01','',''),(3185,'1','308','1',1,'Retail Sale Id 3331',2944.00,0.00,0.00,4.00,0.00,'2023-03-02 08:25:22','',''),(3186,'1','308','1',1,'Retail Sale Id 3332',2944.00,0.00,0.00,4.00,0.00,'2023-03-02 08:35:09','',''),(3187,'1','308','1',1,'Retail Sale Id 3333',4416.00,0.00,0.00,6.00,0.00,'2023-03-02 08:37:23','',''),(3188,'1','308','1',1,'Retail Sale Id 3334',3680.00,0.00,0.00,5.00,0.00,'2023-03-02 08:45:02','',''),(3189,'1','308','1',1,'Retail Sale Id 3335',4423.36,0.00,0.00,6.01,0.00,'2023-03-02 08:46:25','',''),(3190,'1','308','1',1,'Retail Sale Id 3336',1501.44,0.00,0.00,2.04,0.00,'2023-03-02 08:48:14','',''),(3191,'1','308','1',1,'Retail Sale Id 3338',9200.00,0.00,0.00,12.50,0.00,'2023-03-02 09:16:48','',''),(3192,'1','308','1',1,'Retail Sale Id 3339',603.52,0.00,0.00,0.82,0.00,'2023-03-02 09:18:18','',''),(3193,'1','308','1',1,'Retail Sale Id 3340',9200.00,0.00,0.00,12.50,0.00,'2023-03-02 09:19:35','',''),(3194,'1','308','1',1,'Retail Sale Id 3341',1501.44,0.00,0.00,2.04,0.00,'2023-03-02 09:21:09','',''),(3195,'1','308','1',1,'Retail Sale Id 3342',2001.92,0.00,0.00,2.72,0.00,'2023-03-02 09:37:57','',''),(3196,'1','308','1',1,'Retail Sale Id 3343',1501.44,0.00,0.00,2.04,0.00,'2023-03-02 09:47:50','',''),(3197,'1','308','1',1,'Retail Sale Id 3344',2208.00,0.00,0.00,3.00,0.00,'2023-03-02 09:52:37','',''),(3198,'1','308','1',1,'Retail Sale Id 3345',9200.00,0.00,0.00,12.50,0.00,'2023-03-02 09:58:16','',''),(3199,'1','308','1',1,'Retail Sale Id 3346',4423.36,0.00,0.00,6.01,0.00,'2023-03-02 10:16:44','',''),(3200,'1','308','1',1,'Retail Sale Id 3347',3680.00,0.00,0.00,5.00,0.00,'2023-03-02 10:21:41','',''),(3201,'1','308','1',1,'Retail Sale Id 3348',2208.00,0.00,0.00,3.00,0.00,'2023-03-02 10:23:15','',''),(3202,'1','308','1',1,'Retail Sale Id 3349',2208.00,0.00,0.00,3.00,0.00,'2023-03-02 10:28:50','',''),(3203,'1','308','1',1,'Retail Sale Id 3350',5159.36,0.00,0.00,7.01,0.00,'2023-03-02 10:33:54','',''),(3204,'1','308','1',1,'Retail Sale Id 3351',3996.48,0.00,0.00,5.43,0.00,'2023-03-02 10:40:42','',''),(3205,'1','308','1',1,'Retail Sale Id 3352',4298.24,0.00,0.00,5.84,0.00,'2023-03-02 10:41:55','',''),(3206,'1','308','1',1,'Retail Sale Id 3353',802.24,0.00,0.00,1.09,0.00,'2023-03-02 10:43:43','',''),(3207,'1','308','1',1,'Return of Retail Sale Id 3347',0.00,3680.00,5.00,0.00,0.00,'2023-03-02 10:48:58','',''),(3208,'1','308','1',1,'Retail Sale Id 3354',2208.00,0.00,0.00,3.00,0.00,'2023-03-02 10:54:01','',''),(3209,'1','308','1',1,'Retail Sale Id 3355',1000.96,0.00,0.00,1.36,0.00,'2023-03-02 10:55:10','',''),(3210,'1','308','1',1,'Retail Sale Id 3356',2208.00,0.00,0.00,3.00,0.00,'2023-03-02 10:56:40','',''),(3211,'1','308','1',1,'Retail Sale Id 3357',68000.00,0.00,0.00,100.00,-5600.00,'2023-03-02 10:58:01','',''),(3212,'1','308','1',1,'Retail Sale Id 3358',68000.00,0.00,0.00,100.00,-5600.00,'2023-03-02 11:10:34','',''),(3213,'1','308','1',1,'Retail Sale Id 3359',4416.00,0.00,0.00,6.00,0.00,'2023-03-02 11:43:54','',''),(3214,'1','308','1',1,'Retail Sale Id 3360',750.72,0.00,0.00,1.02,0.00,'2023-03-02 13:48:50','',''),(3215,'1','308','1',1,'Retail Sale Id 3361',5159.36,0.00,0.00,7.01,0.00,'2023-03-02 13:55:23','',''),(3216,'1','308','1',1,'Retail Sale Id 3362',1501.44,0.00,0.00,2.04,0.00,'2023-03-02 14:43:16','',''),(3217,'1','308','1',1,'Retail Sale Id 3363',8103.36,0.00,0.00,11.01,0.00,'2023-03-02 15:01:44','',''),(3218,'1','308','1',1,'Retail Sale Id 3364',2701.12,0.00,0.00,3.67,0.00,'2023-03-02 16:27:52','',''),(3219,'1','308','1',1,'Retail Sale Id 3365',2944.00,0.00,0.00,4.00,0.00,'2023-03-02 17:23:42','',''),(3220,'1','308','1',1,'Retail Sale Id 3366',802.24,0.00,0.00,1.09,0.00,'2023-03-02 17:37:41','',''),(3221,'1','308','1',1,'Retail Sale Id 3367',2944.00,0.00,0.00,4.00,0.00,'2023-03-02 18:20:09','',''),(3222,'1','308','1',1,'Return of Retail Sale Id 3363',0.00,8103.36,11.01,0.00,0.00,'2023-03-02 18:43:00','',''),(3223,'1','308','1',1,'Return of Retail Sale Id 3364',0.00,2701.12,3.67,0.00,0.00,'2023-03-02 18:44:00','',''),(3224,'1','308','1',1,'Retail Sale Id 3368',220.80,0.00,0.00,0.30,0.00,'2023-03-02 18:45:02','',''),(3225,'1','308','1',1,'Retail Sale Id 3369',73440.00,0.00,0.00,108.00,-6048.00,'2023-03-02 18:48:14','',''),(3226,'1','308','1',1,'Retail Sale Id 3370',986.24,0.00,0.00,1.34,0.00,'2023-03-02 18:57:14','',''),(3227,'1','308','1',1,'Retail Sale Id 3371',220.80,0.00,0.00,0.30,0.00,'2023-03-02 19:30:43','',''),(3228,'1','308',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,2966080.00,4030.00,0.00,0.00,'2023-03-02 19:39:33','',''),(3229,'1','308',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,4030.00,0.00,'2023-03-02 19:40:29','',''),(3230,'1','308','1',1,'Received from bridging 10',0.00,0.00,4030.00,0.00,0.00,'2023-03-02 19:40:29','',''),(3231,'1','308','1',1,'Return of Retail Sale Id 3371',0.00,220.80,0.30,0.00,0.00,'2023-03-02 21:06:49','',''),(3232,'1','308','1',1,'Retail Sale Id 3372',29.44,0.00,0.00,0.04,0.00,'2023-03-02 21:07:47','',''),(3233,'1','308','1',1,'Retail Sale Id 3373',1501.44,0.00,0.00,2.04,0.00,'2023-03-03 07:15:34','',''),(3234,'1','308','1',1,'Retail Sale Id 3374',2944.00,0.00,0.00,4.00,0.00,'2023-03-03 07:31:34','',''),(3235,'1','308','1',1,'Retail Sale Id 3375',4416.00,0.00,0.00,6.00,0.00,'2023-03-03 07:33:02','',''),(3236,'1','308','1',1,'Retail Sale Id 3376',1472.00,0.00,0.00,2.00,0.00,'2023-03-03 07:35:19','',''),(3237,'1','308','1',1,'Retail Sale Id 3377',3680.00,0.00,0.00,5.00,0.00,'2023-03-03 07:52:45','',''),(3238,'1','308','1',1,'Retail Sale Id 3378',4416.00,0.00,0.00,6.00,0.00,'2023-03-03 07:55:38','',''),(3239,'1','308','1',1,'Retail Sale Id 3379',3996.48,0.00,0.00,5.43,0.00,'2023-03-03 07:59:17','',''),(3240,'1','308','1',1,'Retail Sale Id 3380',2208.00,0.00,0.00,3.00,0.00,'2023-03-03 08:10:07','',''),(3241,'1','308','1',1,'Retail Sale Id 3381',9200.00,0.00,0.00,12.50,0.00,'2023-03-03 08:45:10','',''),(3242,'1','308','1',1,'Retail Sale Id 3382',2944.00,0.00,0.00,4.00,0.00,'2023-03-03 09:06:36','',''),(3243,'1','308','1',1,'Retail Sale Id 3383',3680.00,0.00,0.00,5.00,0.00,'2023-03-03 09:22:23','',''),(3244,'1','308','1',1,'Retail Sale Id 3384',750.72,0.00,0.00,1.02,0.00,'2023-03-03 09:25:54','',''),(3245,'1','308','1',1,'Retail Sale Id 3385',1501.44,0.00,0.00,2.04,0.00,'2023-03-03 09:27:52','',''),(3246,'1','308','1',1,'Retail Sale Id 3386',1501.44,0.00,0.00,2.04,0.00,'2023-03-03 11:14:10','',''),(3247,'1','308','1',1,'Retail Sale Id 3387',1472.00,0.00,0.00,2.00,0.00,'2023-03-03 11:59:07','',''),(3248,'1','308','1',1,'Retail Sale Id 3388',2208.00,0.00,0.00,3.00,0.00,'2023-03-03 12:07:04','',''),(3249,'1','308','1',1,'Retail Sale Id 3389',17000.00,0.00,0.00,25.00,-1400.00,'2023-03-03 12:14:43','',''),(3250,'1','308','1',1,'Retail Sale Id 3390',2944.00,0.00,0.00,4.00,0.00,'2023-03-03 12:31:04','',''),(3251,'1','308','1',1,'Retail Sale Id 3391',2001.92,0.00,0.00,2.72,0.00,'2023-03-03 13:32:24','',''),(3252,'1','308','1',1,'Retail Sale Id 3392',4416.00,0.00,0.00,6.00,0.00,'2023-03-03 13:49:16','',''),(3253,'1','308','1',1,'Retail Sale Id 3393',1501.44,0.00,0.00,2.04,0.00,'2023-03-03 15:25:22','',''),(3254,'1','308','1',1,'Retail Sale Id 3394',4416.00,0.00,0.00,6.00,0.00,'2023-03-03 16:13:02','',''),(3255,'1','308','1',1,'Retail Sale Id 3395',2944.00,0.00,0.00,4.00,0.00,'2023-03-03 16:37:33','',''),(3256,'1','308','1',1,'Retail Sale Id 3396',2951.36,0.00,0.00,4.01,0.00,'2023-03-03 17:02:34','',''),(3257,'1','308','1',1,'Retail Sale Id 3397',9200.00,0.00,0.00,12.50,0.00,'2023-03-03 17:21:44','',''),(3258,'1','308','1',1,'Retail Sale Id 3398',750.72,0.00,0.00,1.02,0.00,'2023-03-03 17:51:06','',''),(3259,'1','308','1',1,'Retail Sale Id 3399',1501.44,0.00,0.00,2.04,0.00,'2023-03-03 17:54:45','',''),(3260,'1','308','1',1,'Retail Sale Id 3400',2208.00,0.00,0.00,3.00,0.00,'2023-03-03 17:56:54','',''),(3261,'1','308','1',1,'Retail Sale Id 3401',2208.00,0.00,0.00,3.00,0.00,'2023-03-03 18:03:12','',''),(3262,'1','308','1',1,'Retail Sale Id 3402',2001.92,0.00,0.00,2.72,0.00,'2023-03-03 18:05:59','',''),(3263,'1','308','1',1,'Retail Sale Id 3403',2208.00,0.00,0.00,3.00,0.00,'2023-03-03 18:21:00','',''),(3264,'1','308','1',1,'Retail Sale Id 3404',9200.00,0.00,0.00,12.50,0.00,'2023-03-03 18:27:38','',''),(3265,'1','308','1',1,'Retail Sale Id 3405',1501.44,0.00,0.00,2.04,0.00,'2023-03-03 18:49:51','',''),(3266,'1','308','1',1,'Retail Sale Id 3406',9200.00,0.00,0.00,12.50,0.00,'2023-03-03 18:50:38','',''),(3267,'1','308','1',1,'Retail Sale Id 3407',2208.00,0.00,0.00,3.00,0.00,'2023-03-03 18:51:54','',''),(3268,'1','308','1',1,'Retail Sale Id 3408',1501.44,0.00,0.00,2.04,0.00,'2023-03-03 18:53:44','',''),(3269,'1','308','1',1,'Retail Sale Id 3409',2001.92,0.00,0.00,2.72,0.00,'2023-03-03 18:54:47','',''),(3270,'1','308','1',1,'Retail Sale Id 3410',9200.00,0.00,0.00,12.50,0.00,'2023-03-03 18:59:16','',''),(3271,'1','308','1',1,'Retail Sale Id 3411',2944.00,0.00,0.00,4.00,0.00,'2023-03-03 19:31:44','',''),(3272,'1','308','1',1,'Retail Sale Id 3412',235.52,0.00,0.00,0.32,0.00,'2023-03-03 19:44:24','',''),(3273,'1','308','1',1,'Retail Sale Id 3413',9200.00,0.00,0.00,12.50,0.00,'2023-03-04 07:16:42','',''),(3274,'1','308','1',1,'Retail Sale Id 3414',2208.00,0.00,0.00,3.00,0.00,'2023-03-04 07:43:31','',''),(3275,'1','308','1',1,'Retail Sale Id 3415',750.72,0.00,0.00,1.02,0.00,'2023-03-04 07:45:01','',''),(3276,'1','308','1',1,'Retail Sale Id 3416',20400.00,0.00,0.00,30.00,-1680.00,'2023-03-04 08:05:51','',''),(3277,'1','308','1',1,'Retail Sale Id 3417',1501.44,0.00,0.00,2.04,0.00,'2023-03-04 08:09:50','',''),(3278,'1','308','1',1,'Retail Sale Id 3418',2208.00,0.00,0.00,3.00,0.00,'2023-03-04 08:12:19','',''),(3279,'1','308','1',1,'Retail Sale Id 3419',897.92,0.00,0.00,1.22,0.00,'2023-03-04 08:24:06','',''),(3280,'1','308','1',1,'Retail Sale Id 3420',9200.00,0.00,0.00,12.50,0.00,'2023-03-04 08:28:55','',''),(3281,'1','308','1',1,'Retail Sale Id 3421',2502.40,0.00,0.00,3.40,0.00,'2023-03-04 08:36:58','',''),(3282,'1','308','1',1,'Retail Sale Id 3422',3680.00,0.00,0.00,5.00,0.00,'2023-03-04 08:38:27','',''),(3283,'1','308','1',1,'Retail Sale Id 3423',9200.00,0.00,0.00,12.50,0.00,'2023-03-04 08:39:38','',''),(3284,'1','308','1',1,'Retail Sale Id 3424',2944.00,0.00,0.00,4.00,0.00,'2023-03-04 08:41:15','',''),(3285,'1','308','1',1,'Retail Sale Id 3425',2001.92,0.00,0.00,2.72,0.00,'2023-03-04 08:44:36','',''),(3286,'1','308','1',1,'Retail Sale Id 3426',2944.00,0.00,0.00,4.00,0.00,'2023-03-04 08:46:10','',''),(3287,'1','308','1',1,'Retail Sale Id 3427',3680.00,0.00,0.00,5.00,0.00,'2023-03-04 08:47:31','',''),(3288,'1','308','1',1,'Retail Sale Id 3428',2944.00,0.00,0.00,4.00,0.00,'2023-03-04 08:55:40','',''),(3289,'1','308','1',1,'Retail Sale Id 3429',1501.44,0.00,0.00,2.04,0.00,'2023-03-04 08:57:28','',''),(3290,'1','308','1',1,'Retail Sale Id 3430',2208.00,0.00,0.00,3.00,0.00,'2023-03-04 09:01:13','',''),(3291,'1','308','1',1,'Retail Sale Id 3431',1501.44,0.00,0.00,2.04,0.00,'2023-03-04 09:10:21','',''),(3292,'1','308','1',1,'Retail Sale Id 3432',3680.00,0.00,0.00,5.00,0.00,'2023-03-04 09:16:59','',''),(3293,'1','308','1',1,'Retail Sale Id 3433',2208.00,0.00,0.00,3.00,0.00,'2023-03-04 09:21:27','',''),(3294,'1','308','1',1,'Retail Sale Id 3434',1398.40,0.00,0.00,1.90,0.00,'2023-03-04 09:25:42','',''),(3295,'1','308','1',1,'Retail Sale Id 3435',3702.08,0.00,0.00,5.03,0.00,'2023-03-04 09:31:44','',''),(3296,'1','308','1',1,'Retail Sale Id 3436',4416.00,0.00,0.00,6.00,0.00,'2023-03-04 09:37:57','',''),(3297,'1','308','1',1,'Retail Sale Id 3437',2208.00,0.00,0.00,3.00,0.00,'2023-03-04 09:54:28','',''),(3298,'1','308','1',1,'Retail Sale Id 3440',7360.00,0.00,0.00,10.00,0.00,'2023-03-04 10:40:43','',''),(3299,'1','308','1',1,'Retail Sale Id 3441',1000.96,0.00,0.00,1.36,0.00,'2023-03-04 10:50:32','',''),(3300,'1','308','1',1,'Retail Sale Id 3439',1472.00,0.00,0.00,2.00,0.00,'2023-03-04 11:19:11','',''),(3301,'1','308','1',1,'Retail Sale Id 3439',3680.00,0.00,0.00,5.00,0.00,'2023-03-04 11:19:11','',''),(3302,'1','308','1',1,'Retail Sale Id 3442',1840.00,0.00,0.00,2.50,0.00,'2023-03-04 11:22:25','',''),(3303,'1','308','1',1,'Retail Sale Id 3443',1472.00,0.00,0.00,2.00,0.00,'2023-03-04 11:30:10','',''),(3304,'1','308','1',1,'Retail Sale Id 3444',4416.00,0.00,0.00,6.00,0.00,'2023-03-04 13:20:16','',''),(3305,'1','308','1',1,'Retail Sale Id 3445',4416.00,0.00,0.00,6.00,0.00,'2023-03-04 13:25:38','',''),(3306,'1','308','1',1,'Retail Sale Id 3446',2944.00,0.00,0.00,4.00,0.00,'2023-03-04 13:38:36','',''),(3307,'1','308','1',1,'Retail Sale Id 3447',1501.44,0.00,0.00,2.04,0.00,'2023-03-04 13:46:29','',''),(3308,'1','308','1',1,'Retail Sale Id 3448',4416.00,0.00,0.00,6.00,0.00,'2023-03-04 14:10:28','',''),(3309,'1','308','1',1,'Retail Sale Id 3449',1501.44,0.00,0.00,2.04,0.00,'2023-03-04 14:15:50','',''),(3310,'1','308','1',1,'Return of Retail Sale Id 3440',0.00,7360.00,10.00,0.00,0.00,'2023-03-04 14:31:41','',''),(3311,'1','308','1',1,'Retail Sale Id 3450',4416.00,0.00,0.00,6.00,0.00,'2023-03-04 14:39:25','',''),(3312,'1','308','1',1,'Retail Sale Id 3451',1501.44,0.00,0.00,2.04,0.00,'2023-03-04 14:58:54','',''),(3313,'1','308','1',1,'Retail Sale Id 3452',78880.00,0.00,0.00,116.00,-6496.00,'2023-03-04 16:03:52','',''),(3314,'1','308','1',1,'Retail Sale Id 3453',1000.96,0.00,0.00,1.36,0.00,'2023-03-04 16:49:47','',''),(3315,'1','308','1',1,'Retail Sale Id 3454',7360.00,0.00,0.00,10.00,0.00,'2023-03-04 17:08:22','',''),(3316,'1','308','1',1,'Retail Sale Id 3456',1700.16,0.00,0.00,2.31,0.00,'2023-03-04 17:37:00','',''),(3317,'1','308','1',1,'Retail Sale Id 3457',17000.00,0.00,0.00,25.00,-1400.00,'2023-03-04 17:43:13','',''),(3318,'1','308','1',1,'Retail Sale Id 3458',136000.00,0.00,0.00,200.00,-11200.00,'2023-03-04 17:49:38','',''),(3319,'1','308','1',1,'Retail Sale Id 3459',3680.00,0.00,0.00,5.00,0.00,'2023-03-04 17:53:14','',''),(3320,'1','308','1',1,'Retail Sale Id 3460',2208.00,0.00,0.00,3.00,0.00,'2023-03-04 17:57:28','',''),(3321,'1','308','1',1,'Retail Sale Id 3461',5012.16,0.00,0.00,6.81,0.00,'2023-03-04 18:15:36','',''),(3322,'1','308','1',1,'Retail Sale Id 3462',29.44,0.00,0.00,0.04,0.00,'2023-03-04 18:23:58','',''),(3323,'1','308','1',1,'Retail Sale Id 3463',2944.00,0.00,0.00,4.00,0.00,'2023-03-05 07:08:04','',''),(3324,'1','308','1',1,'Retail Sale Id 3464',2208.00,0.00,0.00,3.00,0.00,'2023-03-05 07:10:10','',''),(3325,'1','308','1',1,'Retail Sale Id 3465',5888.00,0.00,0.00,8.00,0.00,'2023-03-05 07:35:49','',''),(3326,'1','308','1',1,'Retail Sale Id 3466',8832.00,0.00,0.00,12.00,0.00,'2023-03-05 07:46:07','',''),(3327,'1','308','1',1,'Retail Sale Id 3467',5152.00,0.00,0.00,7.00,0.00,'2023-03-05 07:51:40','',''),(3328,'1','308','1',1,'Retail Sale Id 3468',7360.00,0.00,0.00,10.00,0.00,'2023-03-05 07:54:32','',''),(3329,'1','308','1',1,'Retail Sale Id 3469',2208.00,0.00,0.00,3.00,0.00,'2023-03-05 07:59:10','',''),(3330,'1','308','1',1,'Retail Sale Id 3470',3002.88,0.00,0.00,4.08,0.00,'2023-03-05 08:03:07','',''),(3331,'1','308','1',1,'Retail Sale Id 3471',5152.00,0.00,0.00,7.00,0.00,'2023-03-05 08:07:51','',''),(3332,'1','308','1',1,'Retail Sale Id 3472',4416.00,0.00,0.00,6.00,0.00,'2023-03-05 08:09:25','',''),(3333,'1','308','1',1,'Retail Sale Id 3473',2944.00,0.00,0.00,4.00,0.00,'2023-03-05 08:12:36','',''),(3334,'1','308','1',1,'Retail Sale Id 3474',4416.00,0.00,0.00,6.00,0.00,'2023-03-05 08:16:58','',''),(3335,'1','308','1',1,'Retail Sale Id 3475',3680.00,0.00,0.00,5.00,0.00,'2023-03-05 08:26:21','',''),(3336,'1','308','1',1,'Retail Sale Id 3476',2208.00,0.00,0.00,3.00,0.00,'2023-03-05 08:53:02','',''),(3337,'1','308','1',1,'Retail Sale Id 3477',3680.00,0.00,0.00,5.00,0.00,'2023-03-05 08:54:41','',''),(3338,'1','308','1',1,'Retail Sale Id 3478',2944.00,0.00,0.00,4.00,0.00,'2023-03-05 08:56:47','',''),(3339,'1','308','1',1,'Retail Sale Id 3480',4416.00,0.00,0.00,6.00,0.00,'2023-03-05 08:58:16','',''),(3340,'1','308','1',1,'Retail Sale Id 3481',4416.00,0.00,0.00,6.00,0.00,'2023-03-05 09:02:30','',''),(3341,'1','308','1',1,'Retail Sale Id 3482',1472.00,0.00,0.00,2.00,0.00,'2023-03-05 09:25:26','',''),(3342,'1','308','1',1,'Retail Sale Id 3483',2208.00,0.00,0.00,3.00,0.00,'2023-03-05 09:31:07','',''),(3343,'1','308','1',1,'Retail Sale Id 3484',8832.00,0.00,0.00,12.00,0.00,'2023-03-05 09:36:57','',''),(3344,'1','308','1',1,'Retail Sale Id 3485',736.00,0.00,0.00,1.00,0.00,'2023-03-05 09:40:20','',''),(3345,'1','308','1',1,'Retail Sale Id 3486',5152.00,0.00,0.00,7.00,0.00,'2023-03-05 09:42:11','',''),(3346,'1','308','1',1,'Retail Sale Id 3487',9200.00,0.00,0.00,12.50,0.00,'2023-03-05 09:48:32','',''),(3347,'1','308','1',1,'Retail Sale Id 3488',1472.00,0.00,0.00,2.00,0.00,'2023-03-05 09:50:25','',''),(3348,'1','308','1',1,'Retail Sale Id 3489',4416.00,0.00,0.00,6.00,0.00,'2023-03-05 10:05:43','',''),(3349,'1','308','1',1,'Retail Sale Id 3490',2208.00,0.00,0.00,3.00,0.00,'2023-03-05 10:07:46','',''),(3350,'1','308','1',1,'Retail Sale Id 3491',736.00,0.00,0.00,1.00,0.00,'2023-03-05 10:25:15','',''),(3351,'1','308','1',1,'Retail Sale Id 3492',3680.00,0.00,0.00,5.00,0.00,'2023-03-05 10:26:59','',''),(3352,'1','308','1',1,'Retail Sale Id 3493',1472.00,0.00,0.00,2.00,0.00,'2023-03-05 10:28:54','',''),(3353,'1','308','1',1,'Retail Sale Id 3494',2208.00,0.00,0.00,3.00,0.00,'2023-03-05 10:30:23','',''),(3354,'1','308','1',1,'Retail Sale Id 3495',743.36,0.00,0.00,1.01,0.00,'2023-03-05 10:36:52','',''),(3355,'1','308','1',1,'Retail Sale Id 3496',68000.00,0.00,0.00,100.00,-5600.00,'2023-03-05 10:39:59','',''),(3356,'1','308','1',1,'Retail Sale Id 3497',736.00,0.00,0.00,1.00,0.00,'2023-03-05 10:42:05','',''),(3357,'1','308','1',1,'Retail Sale Id 3498',3680.00,0.00,0.00,5.00,0.00,'2023-03-05 11:00:15','',''),(3358,'1','308','1',1,'Retail Sale Id 3499',736.00,0.00,0.00,1.00,0.00,'2023-03-05 11:02:31','',''),(3359,'1','308','1',1,'Retail Sale Id 3500',7360.00,0.00,0.00,10.00,0.00,'2023-03-05 11:04:50','',''),(3360,'1','308','1',1,'Retail Sale Id 3501',8832.00,0.00,0.00,12.00,0.00,'2023-03-05 11:20:50','',''),(3361,'1','308','1',1,'Retail Sale Id 3502',1501.44,0.00,0.00,2.04,0.00,'2023-03-05 11:28:20','',''),(3362,'1','308','1',1,'Return of Retail Sale Id 3496',0.00,68000.00,100.00,0.00,5600.00,'2023-03-05 11:28:38','',''),(3363,'1','308','1',1,'Retail Sale Id 3503',4416.00,0.00,0.00,6.00,0.00,'2023-03-05 11:30:48','',''),(3364,'1','308','1',1,'Retail Sale Id 3504',1472.00,0.00,0.00,2.00,0.00,'2023-03-05 11:31:59','',''),(3365,'1','308','1',1,'Retail Sale Id 3505',3680.00,0.00,0.00,5.00,0.00,'2023-03-05 11:38:31','',''),(3366,'1','308','1',1,'Retail Sale Id 3506',750.72,0.00,0.00,1.02,0.00,'2023-03-05 11:50:59','',''),(3367,'1','308','1',1,'Retail Sale Id 3507',2208.00,0.00,0.00,3.00,0.00,'2023-03-05 12:06:21','',''),(3368,'1','308','1',1,'Retail Sale Id 3508',8464.00,0.00,0.00,11.50,0.00,'2023-03-05 12:08:48','',''),(3369,'1','308','1',1,'Retail Sale Id 3509',2001.92,0.00,0.00,2.72,0.00,'2023-03-05 12:19:43','',''),(3370,'1','308','1',1,'Retail Sale Id 3510',5152.00,0.00,0.00,7.00,0.00,'2023-03-05 12:35:29','',''),(3371,'1','308','1',1,'Retail Sale Id 3511',2944.00,0.00,0.00,4.00,0.00,'2023-03-05 12:43:04','',''),(3372,'1','308','1',1,'Retail Sale Id 3512',3680.00,0.00,0.00,5.00,0.00,'2023-03-05 12:50:04','',''),(3373,'1','308','1',1,'Retail Sale Id 3513',1472.00,0.00,0.00,2.00,0.00,'2023-03-05 13:03:27','',''),(3374,'1','308','1',1,'Retail Sale Id 3514',4416.00,0.00,0.00,6.00,0.00,'2023-03-05 13:41:02','',''),(3375,'1','308','1',1,'Retail Sale Id 3515',20400.00,0.00,0.00,30.00,-1680.00,'2023-03-05 14:23:58','',''),(3376,'1','308','1',1,'Retail Sale Id 3516',5888.00,0.00,0.00,8.00,0.00,'2023-03-05 14:53:43','',''),(3377,'1','308','1',1,'Retail Sale Id 3517',1472.00,0.00,0.00,2.00,0.00,'2023-03-05 14:55:40','',''),(3378,'1','308','1',1,'Retail Sale Id 3518',1501.44,0.00,0.00,2.04,0.00,'2023-03-05 14:59:07','',''),(3379,'1','308','1',1,'Retail Sale Id 3519',9200.00,0.00,0.00,12.50,0.00,'2023-03-05 15:08:12','',''),(3380,'1','308','1',1,'Retail Sale Id 3520',4416.00,0.00,0.00,6.00,0.00,'2023-03-05 15:13:34','',''),(3381,'1','308','1',1,'Retail Sale Id 3522',5152.00,0.00,0.00,7.00,0.00,'2023-03-05 15:32:07','',''),(3382,'1','308','1',1,'Retail Sale Id 3523',2208.00,0.00,0.00,3.00,0.00,'2023-03-05 15:39:08','',''),(3383,'1','308','1',1,'Retail Sale Id 3524',20400.00,0.00,0.00,30.00,-1680.00,'2023-03-05 15:45:20','',''),(3384,'1','308','1',1,'Retail Sale Id 3525',2208.00,0.00,0.00,3.00,0.00,'2023-03-05 15:47:11','',''),(3385,'1','308','1',1,'Retail Sale Id 3526',2208.00,0.00,0.00,3.00,0.00,'2023-03-05 15:49:26','',''),(3386,'1','308','1',1,'Retail Sale Id 3527',2208.00,0.00,0.00,3.00,0.00,'2023-03-05 16:08:47','',''),(3387,'1','308','1',1,'Retail Sale Id 3528',1472.00,0.00,0.00,2.00,0.00,'2023-03-05 16:12:11','',''),(3388,'1','308','1',1,'Retail Sale Id 3529',9200.00,0.00,0.00,12.50,0.00,'2023-03-05 16:30:09','',''),(3389,'1','308','1',1,'Retail Sale Id 3530',3002.88,0.00,0.00,4.08,0.00,'2023-03-05 16:41:31','',''),(3390,'1','308','1',1,'Retail Sale Id 3531',4416.00,0.00,0.00,6.00,0.00,'2023-03-05 16:44:16','',''),(3391,'1','308','1',1,'Retail Sale Id 3532',1501.44,0.00,0.00,2.04,0.00,'2023-03-05 16:54:07','',''),(3392,'1','308','1',1,'Retail Sale Id 3533',1398.40,0.00,0.00,1.90,0.00,'2023-03-05 17:02:08','',''),(3393,'1','308','1',1,'Retail Sale Id 3534',4416.00,0.00,0.00,6.00,0.00,'2023-03-05 17:04:34','',''),(3394,'1','308','1',1,'Retail Sale Id 3535',7360.00,0.00,0.00,10.00,0.00,'2023-03-05 17:16:46','',''),(3395,'1','308','1',1,'Retail Sale Id 3536',2944.00,0.00,0.00,4.00,0.00,'2023-03-05 17:22:19','',''),(3396,'1','308','1',1,'Retail Sale Id 3537',736.00,0.00,0.00,1.00,0.00,'2023-03-05 17:35:01','',''),(3397,'1','308','1',1,'Retail Sale Id 3538',2208.00,0.00,0.00,3.00,0.00,'2023-03-05 17:45:29','',''),(3398,'1','308','1',1,'Retail Sale Id 3539',3702.08,0.00,0.00,5.03,0.00,'2023-03-05 18:00:18','',''),(3399,'1','308','1',1,'Retail Sale Id 3540',9200.00,0.00,0.00,12.50,0.00,'2023-03-05 18:13:19','',''),(3400,'1','308','1',1,'Retail Sale Id 3541',4416.00,0.00,0.00,6.00,0.00,'2023-03-05 18:15:02','',''),(3401,'1','308','1',1,'Retail Sale Id 3542',3680.00,0.00,0.00,5.00,0.00,'2023-03-05 18:16:41','',''),(3402,'1','308','1',1,'Retail Sale Id 3543',4416.00,0.00,0.00,6.00,0.00,'2023-03-05 18:17:46','',''),(3403,'1','308','1',1,'Retail Sale Id 3544',7360.00,0.00,0.00,10.00,0.00,'2023-03-05 18:29:28','',''),(3404,'1','308','1',1,'Return of Retail Sale Id 3537',0.00,736.00,1.00,0.00,0.00,'2023-03-05 18:42:38','',''),(3405,'1','308','1',1,'Retail Sale Id 3545',434.24,0.00,0.00,0.59,0.00,'2023-03-05 18:44:02','',''),(3406,'1','308','1',1,'Retail Sale Id 3546',2944.00,0.00,0.00,4.00,0.00,'2023-03-05 18:54:53','',''),(3407,'1','308','1',1,'Retail Sale Id 3547',1501.44,0.00,0.00,2.04,0.00,'2023-03-06 11:35:52','',''),(3408,'1','308','1',1,'Retail Sale Id 3548',2200.64,0.00,0.00,2.99,0.00,'2023-03-06 11:55:52','',''),(3409,'1','308','1',1,'Retail Sale Id 3549',34000.00,0.00,0.00,50.00,-2800.00,'2023-03-06 12:08:47','',''),(3410,'1','308','1',1,'Retail Sale Id 3550',1501.44,0.00,0.00,2.04,0.00,'2023-03-06 12:31:20','',''),(3411,'1','308','1',1,'Retail Sale Id 3551',8096.00,0.00,0.00,11.00,0.00,'2023-03-06 12:52:18','',''),(3412,'1','308','1',1,'Retail Sale Id 3552',1472.00,0.00,0.00,2.00,0.00,'2023-03-06 13:11:53','',''),(3413,'1','308','1',1,'Retail Sale Id 3553',736.00,0.00,0.00,1.00,0.00,'2023-03-06 13:47:25','',''),(3414,'1','308','1',1,'Retail Sale Id 3554',743.36,0.00,0.00,1.01,0.00,'2023-03-06 14:02:38','',''),(3415,'1','308','1',1,'Retail Sale Id 3555',750.72,0.00,0.00,1.02,0.00,'2023-03-06 14:51:22','',''),(3416,'1','308','1',1,'Retail Sale Id 3556',4416.00,0.00,0.00,6.00,0.00,'2023-03-06 15:15:52','',''),(3417,'1','308','1',1,'Retail Sale Id 3557',1000.96,0.00,0.00,1.36,0.00,'2023-03-06 15:47:25','',''),(3418,'1','308','1',1,'Retail Sale Id 3558',1472.00,0.00,0.00,2.00,0.00,'2023-03-06 16:07:08','',''),(3419,'1','308','1',1,'Retail Sale Id 3559',4416.00,0.00,0.00,6.00,0.00,'2023-03-06 16:13:59','',''),(3420,'1','308','1',1,'Retail Sale Id 3560',4416.00,0.00,0.00,6.00,0.00,'2023-03-06 16:21:08','',''),(3421,'1','308','1',1,'Retail Sale Id 3561',2208.00,0.00,0.00,3.00,0.00,'2023-03-06 16:28:42','',''),(3422,'1','308','1',1,'Retail Sale Id 3562',2208.00,0.00,0.00,3.00,0.00,'2023-03-06 16:35:33','',''),(3423,'1','308','1',1,'Retail Sale Id 3563',7360.00,0.00,0.00,10.00,0.00,'2023-03-06 16:56:23','',''),(3424,'1','308','1',1,'Retail Sale Id 3564',4416.00,0.00,0.00,6.00,0.00,'2023-03-06 17:00:48','',''),(3425,'1','308','1',1,'Retail Sale Id 3565',13600.00,0.00,0.00,20.00,-1120.00,'2023-03-06 17:07:28','',''),(3426,'1','308','1',1,'Retail Sale Id 3566',3503.36,0.00,0.00,4.76,0.00,'2023-03-06 17:09:46','',''),(3427,'1','308','1',1,'Retail Sale Id 3567',2208.00,0.00,0.00,3.00,0.00,'2023-03-06 18:04:10','',''),(3428,'1','308','1',1,'Retail Sale Id 3568',2502.40,0.00,0.00,3.40,0.00,'2023-03-06 18:09:28','',''),(3429,'1','308','1',1,'Retail Sale Id 3569',1501.44,0.00,0.00,2.04,0.00,'2023-03-06 18:11:33','',''),(3430,'1','308','1',1,'Retail Sale Id 3570',2250.00,0.00,0.00,3.00,42.00,'2023-03-06 18:21:39','',''),(3431,'1','308','1',1,'Retail Sale Id 3571',750.72,0.00,0.00,1.02,0.00,'2023-03-06 18:22:36','',''),(3432,'1','308','1',1,'Retail Sale Id 3572',2208.00,0.00,0.00,3.00,0.00,'2023-03-06 18:26:12','',''),(3433,'1','308','1',1,'Retail Sale Id 3573',1501.44,0.00,0.00,2.04,0.00,'2023-03-06 18:30:51','',''),(3434,'1','308','1',1,'Retail Sale Id 3574',5888.00,0.00,0.00,8.00,0.00,'2023-03-06 18:33:10','',''),(3435,'1','308','1',1,'Retail Sale Id 3575',9200.00,0.00,0.00,12.50,0.00,'2023-03-06 18:38:26','',''),(3436,'1','308','1',1,'Retail Sale Id 3577',8471.36,0.00,0.00,11.51,0.00,'2023-03-06 19:45:50','',''),(3437,'1','308','1',1,'Retail Sale Id 3578',4416.00,0.00,0.00,6.00,0.00,'2023-03-07 07:39:50','',''),(3438,'1','308','1',1,'Retail Sale Id 3579',2944.00,0.00,0.00,4.00,0.00,'2023-03-07 07:51:46','',''),(3439,'1','308','1',1,'Retail Sale Id 3580',897.92,0.00,0.00,1.22,0.00,'2023-03-07 08:00:45','',''),(3440,'1','308','1',1,'Retail Sale Id 3581',4416.00,0.00,0.00,6.00,0.00,'2023-03-07 08:06:15','',''),(3441,'1','308','1',1,'Retail Sale Id 3582',2944.00,0.00,0.00,4.00,0.00,'2023-03-07 08:10:54','',''),(3442,'1','308','1',1,'Retail Sale Id 3583',2208.00,0.00,0.00,3.00,0.00,'2023-03-07 08:15:54','',''),(3443,'1','308','1',1,'Retail Sale Id 3584',4416.00,0.00,0.00,6.00,0.00,'2023-03-07 08:21:12','',''),(3444,'1','308','1',1,'Retail Sale Id 3586',2208.00,0.00,0.00,3.00,0.00,'2023-03-07 08:30:45','',''),(3445,'1','308','1',1,'Retail Sale Id 3587',1501.44,0.00,0.00,2.04,0.00,'2023-03-07 08:33:27','',''),(3446,'1','308','1',1,'Retail Sale Id 3588',4416.00,0.00,0.00,6.00,0.00,'2023-03-07 08:36:31','',''),(3447,'1','308','1',1,'Retail Sale Id 3589',3002.88,0.00,0.00,4.08,0.00,'2023-03-07 08:42:40','',''),(3448,'1','308','1',1,'Retail Sale Id 3590',20400.00,0.00,0.00,30.00,-1680.00,'2023-03-07 08:46:45','',''),(3449,'1','308','1',1,'Retail Sale Id 3591',2208.00,0.00,0.00,3.00,0.00,'2023-03-07 08:51:09','',''),(3450,'1','308','1',1,'Retail Sale Id 3592',2208.00,0.00,0.00,3.00,0.00,'2023-03-07 08:52:35','',''),(3451,'1','308','1',1,'Retail Sale Id 3593',9200.00,0.00,0.00,12.50,0.00,'2023-03-07 08:54:23','',''),(3452,'1','308','1',1,'Retail Sale Id 3594',3680.00,0.00,0.00,5.00,0.00,'2023-03-07 08:56:16','',''),(3453,'1','308','1',1,'Retail Sale Id 3595',9200.00,0.00,0.00,12.50,0.00,'2023-03-07 09:11:58','',''),(3454,'1','308','1',1,'Retail Sale Id 3597',4416.00,0.00,0.00,6.00,0.00,'2023-03-07 09:26:37','',''),(3455,'1','308','1',1,'Retail Sale Id 3598',2208.00,0.00,0.00,3.00,0.00,'2023-03-07 09:27:42','',''),(3456,'1','308','1',1,'Retail Sale Id 3599',2944.00,0.00,0.00,4.00,0.00,'2023-03-07 09:30:23','',''),(3457,'1','308','1',1,'Retail Sale Id 3600',4416.00,0.00,0.00,6.00,0.00,'2023-03-07 09:32:46','',''),(3458,'1','308','1',1,'Retail Sale Id 3601',1501.44,0.00,0.00,2.04,0.00,'2023-03-07 09:33:56','',''),(3459,'1','308','1',1,'Retail Sale Id 3603',5152.00,0.00,0.00,7.00,0.00,'2023-03-07 09:38:44','',''),(3460,'1','308','1',1,'Retail Sale Id 3602',3503.36,0.00,0.00,4.76,0.00,'2023-03-07 09:46:27','',''),(3461,'1','308','1',1,'Retail Sale Id 3604',750.72,0.00,0.00,1.02,0.00,'2023-03-07 09:48:14','',''),(3462,'1','308','1',1,'Retail Sale Id 3605',3680.00,0.00,0.00,5.00,0.00,'2023-03-07 09:52:46','',''),(3463,'1','308','1',1,'Retail Sale Id 3606',7360.00,0.00,0.00,10.00,0.00,'2023-03-07 10:15:54','',''),(3464,'1','308','1',1,'Retail Sale Id 3607',1501.44,0.00,0.00,2.04,0.00,'2023-03-07 10:18:12','',''),(3465,'1','308','1',1,'Retail Sale Id 3609',20400.00,0.00,0.00,30.00,-1680.00,'2023-03-07 10:21:37','',''),(3466,'1','308','1',1,'Retail Sale Id 3608',3680.00,0.00,0.00,5.00,0.00,'2023-03-07 10:23:02','',''),(3467,'1','308','1',1,'Retail Sale Id 3610',1000.96,0.00,0.00,1.36,0.00,'2023-03-07 10:38:38','',''),(3468,'1','308','1',1,'Retail Sale Id 3611',5888.00,0.00,0.00,8.00,0.00,'2023-03-07 10:49:30','',''),(3469,'1','308','1',1,'Retail Sale Id 3612',187000.00,0.00,0.00,275.00,-15400.00,'2023-03-07 11:31:41','',''),(3470,'1','308','1',1,'Retail Sale Id 3613',1501.44,0.00,0.00,2.04,0.00,'2023-03-07 11:46:03','',''),(3471,'1','308','1',1,'Retail Sale Id 3614',2951.36,0.00,0.00,4.01,0.00,'2023-03-07 11:47:56','',''),(3472,'1','308','1',1,'Retail Sale Id 3615',1501.44,0.00,0.00,2.04,0.00,'2023-03-07 12:18:33','',''),(3473,'1','308','1',1,'Retail Sale Id 3616',2936.64,0.00,0.00,3.99,0.00,'2023-03-07 12:32:02','',''),(3474,'1','308','1',1,'Retail Sale Id 3617',1472.00,0.00,0.00,2.00,0.00,'2023-03-07 12:40:33','',''),(3475,'1','308','1',1,'Retail Sale Id 3618',7360.00,0.00,0.00,10.00,0.00,'2023-03-07 13:34:46','',''),(3476,'1','308','1',1,'Return of Retail Sale Id 3618',0.00,7360.00,10.00,0.00,0.00,'2023-03-07 13:35:40','',''),(3477,'1','308','1',1,'Retail Sale Id 3619',3002.88,0.00,0.00,4.08,0.00,'2023-03-07 14:59:15','',''),(3478,'1','308','1',1,'Retail Sale Id 3620',1000.96,0.00,0.00,1.36,0.00,'2023-03-07 15:51:27','',''),(3479,'1','308','1',1,'Retail Sale Id 3621',3002.88,0.00,0.00,4.08,0.00,'2023-03-07 15:54:50','',''),(3480,'1','308','1',1,'Retail Sale Id 3622',1000.96,0.00,0.00,1.36,0.00,'2023-03-07 16:26:57','',''),(3481,'1','308','1',1,'Retail Sale Id 3623',1501.44,0.00,0.00,2.04,0.00,'2023-03-07 16:48:13','',''),(3482,'1','308','1',1,'Retail Sale Id 3624',736.00,0.00,0.00,1.00,0.00,'2023-03-07 17:40:55','',''),(3483,'1','308','1',1,'Retail Sale Id 3625',84673.60,0.00,0.00,124.52,-6973.12,'2023-03-07 18:25:05','',''),(3484,'1','308','1',1,'Retail Sale Id 3626',7485.12,0.00,0.00,10.17,0.00,'2023-03-07 18:26:39','',''),(3485,'1','308','1',1,'Retail Sale Id 3627',7360.00,0.00,0.00,10.00,0.00,'2023-03-08 08:28:30','',''),(3486,'1','308','1',1,'Retail Sale Id 3628',4416.00,0.00,0.00,6.00,0.00,'2023-03-08 08:30:17','',''),(3487,'1','308','1',1,'Retail Sale Id 3629',7360.00,0.00,0.00,10.00,0.00,'2023-03-08 08:31:52','',''),(3488,'1','308','1',1,'Retail Sale Id 3630',5152.00,0.00,0.00,7.00,0.00,'2023-03-08 08:33:46','',''),(3489,'1','308','1',1,'Retail Sale Id 3631',1472.00,0.00,0.00,2.00,0.00,'2023-03-08 08:37:04','',''),(3490,'1','308','1',1,'Retail Sale Id 3632',7360.00,0.00,0.00,10.00,0.00,'2023-03-08 08:38:51','',''),(3491,'1','308','1',1,'Retail Sale Id 3633',4416.00,0.00,0.00,6.00,0.00,'2023-03-08 08:43:19','',''),(3492,'1','308','1',1,'Retail Sale Id 3634',9200.00,0.00,0.00,12.50,0.00,'2023-03-08 08:46:09','',''),(3493,'1','308','1',1,'Retail Sale Id 3635',3680.00,0.00,0.00,5.00,0.00,'2023-03-08 08:49:42','',''),(3494,'1','308','1',1,'Retail Sale Id 3636',22100.00,0.00,0.00,34.00,680.00,'2023-03-08 09:41:36','',''),(3495,'1','308','1',1,'Retail Sale Id 3637',1400.00,0.00,0.00,2.00,140.00,'2023-03-08 09:44:13','',''),(3496,'1','308','1',1,'Retail Sale Id 3638',7700.00,0.00,0.00,11.00,770.00,'2023-03-08 09:45:13','',''),(3497,'1','308','1',1,'Retail Sale Id 3639',2100.00,0.00,0.00,3.00,210.00,'2023-03-08 09:46:03','',''),(3498,'1','308','1',1,'Retail Sale Id 3640',3500.00,0.00,0.00,5.00,350.00,'2023-03-08 09:46:45','',''),(3499,'1','308','1',1,'Retail Sale Id 3642',8750.00,0.00,0.00,12.50,875.00,'2023-03-08 10:07:24','',''),(3500,'1','308','1',1,'Retail Sale Id 3643',19500.00,0.00,0.00,30.00,600.00,'2023-03-08 10:20:49','',''),(3501,'1','308','1',1,'Retail Sale Id 3644',3500.00,0.00,0.00,5.00,350.00,'2023-03-08 10:22:28','',''),(3502,'1','308','1',1,'Retail Sale Id 3645',4200.00,0.00,0.00,6.00,420.00,'2023-03-08 10:36:40','',''),(3503,'1','308','1',1,'Retail Sale Id 3646',2303.00,0.00,0.00,3.29,230.30,'2023-03-08 10:59:33','',''),(3504,'1','308','1',1,'Retail Sale Id 3648',2002.00,0.00,0.00,2.86,200.20,'2023-03-08 12:03:53','',''),(3505,'1','308','1',1,'Retail Sale Id 3649',8750.00,0.00,0.00,12.50,875.00,'2023-03-08 13:32:40','',''),(3506,'1','308','1',1,'Retail Sale Id 3650',2002.00,0.00,0.00,2.86,200.20,'2023-03-08 14:10:39','',''),(3507,'1','308','1',1,'Retail Sale Id 3651',700.00,0.00,0.00,1.00,70.00,'2023-03-08 15:22:54','',''),(3508,'1','308','1',1,'Retail Sale Id 3652',2800.00,0.00,0.00,4.00,280.00,'2023-03-08 15:45:41','',''),(3509,'1','308','1',1,'Retail Sale Id 3653',4900.00,0.00,0.00,7.00,490.00,'2023-03-08 16:19:24','',''),(3510,'1','308','1',1,'Retail Sale Id 3654',1001.00,0.00,0.00,1.43,100.10,'2023-03-08 16:38:18','',''),(3511,'1','308','1',1,'Retail Sale Id 3655',20800.00,0.00,0.00,32.00,640.00,'2023-03-08 16:45:31','',''),(3512,'1','308','1',1,'Retail Sale Id 3656',2800.00,0.00,0.00,4.00,280.00,'2023-03-08 16:51:28','',''),(3513,'1','308','1',1,'Retail Sale Id 3657',65000.00,0.00,0.00,100.00,2000.00,'2023-03-08 17:37:40','',''),(3514,'1','308','1',1,'Retail Sale Id 3658',700.00,0.00,0.00,1.00,70.00,'2023-03-08 17:47:51','',''),(3515,'1','308','1',1,'Return of Retail Sale Id 3642',0.00,8750.00,12.50,0.00,-875.00,'2023-03-08 19:17:47','',''),(3516,'1','308','1',1,'Return of Retail Sale Id 3640',0.00,3500.00,5.00,0.00,-350.00,'2023-03-08 19:18:42','',''),(3517,'1','308','1',1,'Return of Retail Sale Id 3639',0.00,2100.00,3.00,0.00,-210.00,'2023-03-08 19:19:24','',''),(3518,'1','308','1',1,'Retail Sale Id 3659',56.00,0.00,0.00,0.08,5.60,'2023-03-08 19:20:32','',''),(3519,'1','308','1',1,'Retail Sale Id 3660',73450.00,0.00,0.00,113.00,2260.00,'2023-03-08 19:22:39','',''),(3520,'1','308','1',1,'Return of Retail Sale Id 3659',0.00,56.00,0.08,0.00,-5.60,'2023-03-08 19:27:56','',''),(3521,'1','308','1',1,'Retail Sale Id 3661',70.00,0.00,0.00,0.10,7.00,'2023-03-08 19:28:28','',''),(3522,'1','308','1',1,'Retail Sale Id 3662',4200.00,0.00,0.00,6.00,456.00,'2023-03-09 08:08:25','',''),(3523,'1','308','1',1,'Retail Sale Id 3663',2800.00,0.00,0.00,4.00,304.00,'2023-03-09 08:12:24','',''),(3524,'1','308','1',1,'Retail Sale Id 3664',2100.00,0.00,0.00,3.00,228.00,'2023-03-09 08:19:55','',''),(3525,'1','308','1',1,'Retail Sale Id 3665',2100.00,0.00,0.00,3.00,228.00,'2023-03-09 08:29:38','',''),(3526,'1','308','1',1,'Retail Sale Id 3666',19740.00,0.00,0.00,30.00,1020.00,'2023-03-09 09:01:32','',''),(3527,'1','308','1',1,'Retail Sale Id 3667',2002.00,0.00,0.00,2.86,217.36,'2023-03-09 09:03:39','',''),(3528,'1','308','1',1,'Retail Sale Id 3668',7000.00,0.00,0.00,10.00,760.00,'2023-03-09 09:09:46','',''),(3529,'1','308','1',1,'Retail Sale Id 3669',3500.00,0.00,0.00,5.00,380.00,'2023-03-09 09:12:14','',''),(3530,'1','308','1',1,'Retail Sale Id 3670',8750.00,0.00,0.00,12.50,950.00,'2023-03-09 09:23:39','',''),(3531,'1','308','1',1,'Retail Sale Id 3671',7000.00,0.00,0.00,10.00,760.00,'2023-03-09 09:58:22','',''),(3532,'1','308','1',1,'Retail Sale Id 3672',1400.00,0.00,0.00,2.00,152.00,'2023-03-09 10:28:36','',''),(3533,'1','308','1',1,'Retail Sale Id 3673',1400.00,0.00,0.00,2.00,152.00,'2023-03-09 10:31:04','',''),(3534,'1','308','1',1,'Retail Sale Id 3674',4200.00,0.00,0.00,6.00,456.00,'2023-03-09 10:47:09','',''),(3535,'1','308','1',1,'Retail Sale Id 3675',700.00,0.00,0.00,1.00,76.00,'2023-03-09 10:52:37','',''),(3536,'1','308','1',1,'Retail Sale Id 3676',1400.00,0.00,0.00,2.00,152.00,'2023-03-09 11:27:30','',''),(3537,'1','308','1',1,'Retail Sale Id 3677',3500.00,0.00,0.00,5.00,380.00,'2023-03-09 11:28:30','',''),(3538,'1','308','1',1,'Retail Sale Id 3678',2100.00,0.00,0.00,3.00,228.00,'2023-03-09 11:30:48','',''),(3539,'1','308','1',1,'Retail Sale Id 3679',4200.00,0.00,0.00,6.00,456.00,'2023-03-09 11:56:15','',''),(3540,'1','308','1',1,'Retail Sale Id 3680',2100.00,0.00,0.00,3.00,228.00,'2023-03-09 12:16:27','',''),(3541,'1','308','1',1,'Retail Sale Id 3681',700.00,0.00,0.00,1.00,76.00,'2023-03-09 12:19:13','',''),(3542,'1','308','1',1,'Retail Sale Id 3682',1400.00,0.00,0.00,2.00,152.00,'2023-03-09 12:31:30','',''),(3543,'1','308','1',1,'Retail Sale Id 3683',4200.00,0.00,0.00,6.00,456.00,'2023-03-09 12:57:37','',''),(3544,'1','308','1',1,'Retail Sale Id 3684',2100.00,0.00,0.00,3.00,228.00,'2023-03-09 13:16:36','',''),(3545,'1','308','1',1,'Retail Sale Id 3685',4200.00,0.00,0.00,6.00,456.00,'2023-03-09 14:11:14','',''),(3546,'1','308','1',1,'Retail Sale Id 3686',4200.00,0.00,0.00,6.00,456.00,'2023-03-09 14:14:39','',''),(3547,'1','308','1',1,'Retail Sale Id 3687',2800.00,0.00,0.00,4.00,304.00,'2023-03-09 14:26:11','',''),(3548,'1','308','1',1,'Retail Sale Id 3688',4200.00,0.00,0.00,6.00,456.00,'2023-03-09 15:13:27','',''),(3549,'1','308','1',1,'Retail Sale Id 3689',2100.00,0.00,0.00,3.00,228.00,'2023-03-09 15:16:45','',''),(3550,'1','308','1',1,'Retail Sale Id 3690',3500.00,0.00,0.00,5.00,380.00,'2023-03-09 15:17:51','',''),(3551,'1','308','1',1,'Retail Sale Id 3691',2800.00,0.00,0.00,4.00,304.00,'2023-03-09 15:18:55','',''),(3552,'1','308','1',1,'Retail Sale Id 3692',8750.00,0.00,0.00,12.50,950.00,'2023-03-09 15:20:34','',''),(3553,'1','308','1',1,'Retail Sale Id 3693',1001.00,0.00,0.00,1.43,108.68,'2023-03-09 15:31:15','',''),(3554,'1','308','1',1,'Retail Sale Id 3694',4200.00,0.00,0.00,6.00,456.00,'2023-03-09 15:39:56','',''),(3555,'1','308','1',1,'Retail Sale Id 3695',12250.00,0.00,0.00,17.50,1330.00,'2023-03-09 16:21:53','',''),(3556,'1','308','1',1,'Retail Sale Id 3696',4200.00,0.00,0.00,6.00,456.00,'2023-03-09 16:38:31','',''),(3557,'1','308','1',1,'Retail Sale Id 3697',1400.00,0.00,0.00,2.00,152.00,'2023-03-09 16:45:42','',''),(3558,'1','308','1',1,'Retail Sale Id 3698',16450.00,0.00,0.00,25.00,850.00,'2023-03-09 16:52:06','',''),(3559,'1','308','1',1,'Retail Sale Id 3699',700.00,0.00,0.00,1.00,76.00,'2023-03-09 16:55:13','',''),(3560,'1','308','1',1,'Retail Sale Id 3700',2100.00,0.00,0.00,3.00,228.00,'2023-03-09 16:56:40','',''),(3561,'1','308','1',1,'Retail Sale Id 3701',2100.00,0.00,0.00,3.00,228.00,'2023-03-09 16:59:31','',''),(3562,'1','308','1',1,'Retail Sale Id 3702',1001.00,0.00,0.00,1.43,108.68,'2023-03-09 17:01:35','',''),(3563,'1','308','1',1,'Retail Sale Id 3703',4200.00,0.00,0.00,6.00,456.00,'2023-03-09 17:03:32','',''),(3564,'1','308','1',1,'Retail Sale Id 3704',2800.00,0.00,0.00,4.00,304.00,'2023-03-09 17:21:51','',''),(3565,'1','308','1',1,'Retail Sale Id 3705',19740.00,0.00,0.00,30.00,1020.00,'2023-03-09 17:24:48','',''),(3566,'1','308','1',1,'Retail Sale Id 3706',1302.00,0.00,0.00,1.86,141.36,'2023-03-09 17:28:39','',''),(3567,'1','308','1',1,'Retail Sale Id 3707',2100.00,0.00,0.00,3.00,228.00,'2023-03-09 17:31:17','',''),(3568,'1','308','1',1,'Retail Sale Id 3708',1400.00,0.00,0.00,2.00,152.00,'2023-03-09 17:40:33','',''),(3569,'1','308','1',1,'Retail Sale Id 3709',3500.00,0.00,0.00,5.00,380.00,'2023-03-09 17:42:59','',''),(3570,'1','308','1',1,'Retail Sale Id 3710',2100.00,0.00,0.00,3.00,228.00,'2023-03-09 17:45:46','',''),(3571,'1','308','1',1,'Retail Sale Id 3711',8750.00,0.00,0.00,12.50,950.00,'2023-03-09 17:59:20','',''),(3572,'1','308','1',1,'Retail Sale Id 3712',1400.00,0.00,0.00,2.00,152.00,'2023-03-09 18:02:39','',''),(3573,'1','308','1',1,'Retail Sale Id 3713',3500.00,0.00,0.00,5.00,380.00,'2023-03-09 18:10:08','',''),(3574,'1','308','1',1,'Retail Sale Id 3714',2100.00,0.00,0.00,3.00,228.00,'2023-03-09 18:22:15','',''),(3575,'1','308','1',1,'Retail Sale Id 3715',2100.00,0.00,0.00,3.00,228.00,'2023-03-09 18:23:28','',''),(3576,'1','308','1',1,'Retail Sale Id 3716',2100.00,0.00,0.00,3.00,228.00,'2023-03-09 18:25:29','',''),(3577,'1','308','1',1,'Retail Sale Id 3717',3500.00,0.00,0.00,5.00,380.00,'2023-03-09 18:26:39','',''),(3578,'1','308','1',1,'Retail Sale Id 3718',10500.00,0.00,0.00,15.00,1140.00,'2023-03-09 18:28:51','',''),(3579,'1','308','1',1,'Retail Sale Id 3719',4200.00,0.00,0.00,6.00,456.00,'2023-03-09 18:30:42','',''),(3580,'1','308','1',1,'Retail Sale Id 3720',2100.00,0.00,0.00,3.00,228.00,'2023-03-09 18:32:33','',''),(3581,'1','308','1',1,'Retail Sale Id 3720',2100.00,0.00,0.00,3.00,228.00,'2023-03-09 18:32:33','',''),(3582,'1','308','1',1,'Return of Retail Sale Id 3720',0.00,2100.00,3.00,0.00,-228.00,'2023-03-09 18:33:02','',''),(3583,'1','308','1',1,'Return of Retail Sale Id 3720',0.00,2100.00,3.00,0.00,-228.00,'2023-03-09 18:33:02','',''),(3584,'1','308','1',1,'Retail Sale Id 3721',23702.00,0.00,0.00,33.86,2573.36,'2023-03-09 19:29:14','',''),(3585,'1','308','1',1,'Retail Sale Id 3722',1400.00,0.00,0.00,2.00,152.00,'2023-03-10 07:27:13','',''),(3586,'1','308','1',1,'Retail Sale Id 3724',2100.00,0.00,0.00,3.00,228.00,'2023-03-10 07:29:08','',''),(3587,'1','308','1',1,'Retail Sale Id 3725',4200.00,0.00,0.00,6.00,456.00,'2023-03-10 07:31:29','',''),(3588,'1','308','1',1,'Retail Sale Id 3726',700.00,0.00,0.00,1.00,76.00,'2023-03-10 07:36:58','',''),(3589,'1','308','1',1,'Retail Sale Id 3727',1400.00,0.00,0.00,2.00,152.00,'2023-03-10 07:46:39','',''),(3590,'1','308','1',1,'Retail Sale Id 3728',2800.00,0.00,0.00,4.00,304.00,'2023-03-10 07:48:33','',''),(3591,'1','308','1',1,'Retail Sale Id 3729',3500.00,0.00,0.00,5.00,380.00,'2023-03-10 08:12:12','',''),(3592,'1','308','1',1,'Retail Sale Id 3730',3500.00,0.00,0.00,5.00,380.00,'2023-03-10 08:34:00','',''),(3593,'1','308','1',1,'Retail Sale Id 3731',2100.00,0.00,0.00,3.00,228.00,'2023-03-10 08:38:59','',''),(3594,'1','308','1',1,'Retail Sale Id 3734',700.00,0.00,0.00,1.00,76.00,'2023-03-10 08:42:34','',''),(3595,'1','308','1',1,'Retail Sale Id 3735',7000.00,0.00,0.00,10.00,760.00,'2023-03-10 08:49:07','',''),(3596,'1','308','1',1,'Retail Sale Id 3736',2800.00,0.00,0.00,4.00,304.00,'2023-03-10 08:51:04','',''),(3597,'1','308','1',1,'Retail Sale Id 3737',2002.00,0.00,0.00,2.86,217.36,'2023-03-10 08:52:54','',''),(3598,'1','308','1',1,'Retail Sale Id 3738',6300.00,0.00,0.00,9.00,684.00,'2023-03-10 09:09:24','',''),(3599,'1','308','1',1,'Retail Sale Id 3739',2100.00,0.00,0.00,3.00,228.00,'2023-03-10 09:10:43','',''),(3600,'1','308','1',1,'Retail Sale Id 3740',4200.00,0.00,0.00,6.00,456.00,'2023-03-10 09:26:24','',''),(3601,'1','308','1',1,'Retail Sale Id 3741',42441.00,0.00,0.00,64.50,2193.00,'2023-03-10 11:07:16','',''),(3602,'1','308','1',1,'Retail Sale Id 3742',1001.00,0.00,0.00,1.43,108.68,'2023-03-10 11:17:40','',''),(3603,'1','308','1',1,'Retail Sale Id 3743',1498.00,0.00,0.00,2.14,162.64,'2023-03-10 11:57:27','',''),(3604,'1','308','1',1,'Retail Sale Id 3745',24346.00,0.00,0.00,37.00,1258.00,'2023-03-10 12:51:01','',''),(3605,'1','308','1',1,'Retail Sale Id 3746',4200.00,0.00,0.00,6.00,456.00,'2023-03-10 13:07:41','',''),(3606,'1','308','1',1,'Retail Sale Id 3747',3500.00,0.00,0.00,5.00,380.00,'2023-03-10 13:51:02','',''),(3607,'1','308','1',1,'Retail Sale Id 3748',1400.00,0.00,0.00,2.00,152.00,'2023-03-10 13:59:22','',''),(3608,'1','308','1',1,'Retail Sale Id 3749',700.00,0.00,0.00,1.00,76.00,'2023-03-10 14:00:58','',''),(3609,'1','308','1',1,'Retail Sale Id 3750',700.00,0.00,0.00,1.00,76.00,'2023-03-10 14:12:52','',''),(3610,'1','308','1',1,'Retail Sale Id 3751',4998.00,0.00,0.00,7.14,542.64,'2023-03-10 14:22:29','',''),(3611,'1','308','1',1,'Retail Sale Id 3752',8750.00,0.00,0.00,12.50,950.00,'2023-03-10 14:30:26','',''),(3612,'1','308','1',1,'Retail Sale Id 3753',3003.00,0.00,0.00,4.29,326.04,'2023-03-10 14:52:50','',''),(3613,'1','308','1',1,'Retail Sale Id 3754',1001.00,0.00,0.00,1.43,108.68,'2023-03-10 15:02:24','',''),(3614,'1','308','1',1,'Retail Sale Id 3755',2100.00,0.00,0.00,3.00,228.00,'2023-03-10 15:21:33','',''),(3615,'1','308','1',1,'Retail Sale Id 3756',3500.00,0.00,0.00,5.00,380.00,'2023-03-10 15:49:25','',''),(3616,'1','308','1',1,'Retail Sale Id 3758',1400.00,0.00,0.00,2.00,152.00,'2023-03-10 16:45:35','',''),(3617,'1','308','1',1,'Retail Sale Id 3759',2499.00,0.00,0.00,3.57,271.32,'2023-03-10 17:31:32','',''),(3618,'1','308','1',1,'Return of Retail Sale Id 3752',0.00,8750.00,12.50,0.00,-950.00,'2023-03-10 19:21:29','',''),(3619,'1','308','1',1,'Retail Sale Id 3760',5243.00,0.00,0.00,7.49,569.24,'2023-03-10 19:24:40','',''),(3620,'1','308','1',1,'Retail Sale Id 3761',49679.00,0.00,0.00,75.50,2567.00,'2023-03-10 19:26:36','',''),(3621,'1','308','1',1,'Retail Sale Id 3762',700.00,0.00,0.00,1.00,76.00,'2023-03-11 07:40:58','',''),(3622,'1','308','1',1,'Retail Sale Id 3763',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 07:43:14','',''),(3623,'1','308','1',1,'Retail Sale Id 3764',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 07:55:53','',''),(3624,'1','308','1',1,'Retail Sale Id 3765',700.00,0.00,0.00,1.00,76.00,'2023-03-11 08:00:31','',''),(3625,'1','308','1',1,'Retail Sale Id 3766',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 08:02:00','',''),(3626,'1','308','1',1,'Retail Sale Id 3767',1400.00,0.00,0.00,2.00,152.00,'2023-03-11 08:03:23','',''),(3627,'1','308','1',1,'Retail Sale Id 3768',19740.00,0.00,0.00,30.00,1020.00,'2023-03-11 08:05:43','',''),(3628,'1','308','1',1,'Retail Sale Id 3769',3500.00,0.00,0.00,5.00,380.00,'2023-03-11 08:12:28','',''),(3629,'1','308','1',1,'Retail Sale Id 3770',4200.00,0.00,0.00,6.00,456.00,'2023-03-11 08:15:23','',''),(3630,'1','308','1',1,'Retail Sale Id 3771',3500.00,0.00,0.00,5.00,380.00,'2023-03-11 08:16:48','',''),(3631,'1','308','1',1,'Retail Sale Id 3772',4200.00,0.00,0.00,6.00,456.00,'2023-03-11 08:18:23','',''),(3632,'1','308','1',1,'Retail Sale Id 3773',2002.00,0.00,0.00,2.86,217.36,'2023-03-11 08:20:05','',''),(3633,'1','308','1',1,'Retail Sale Id 3774',8750.00,0.00,0.00,12.50,950.00,'2023-03-11 08:22:49','',''),(3634,'1','308','1',1,'Retail Sale Id 3775',12950.00,0.00,0.00,18.50,1406.00,'2023-03-11 08:25:07','',''),(3635,'1','308','1',1,'Retail Sale Id 3776',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 08:27:03','',''),(3636,'1','308','1',1,'Retail Sale Id 3777',2800.00,0.00,0.00,4.00,304.00,'2023-03-11 08:45:17','',''),(3637,'1','308','1',1,'Retail Sale Id 3778',3500.00,0.00,0.00,5.00,380.00,'2023-03-11 08:51:58','',''),(3638,'1','308','1',1,'Retail Sale Id 3779',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 08:53:32','',''),(3639,'1','308','1',1,'Retail Sale Id 3780',2800.00,0.00,0.00,4.00,304.00,'2023-03-11 08:56:02','',''),(3640,'1','308','1',1,'Retail Sale Id 3781',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 09:17:45','',''),(3641,'1','308','1',1,'Retail Sale Id 3782',4200.00,0.00,0.00,6.00,456.00,'2023-03-11 09:24:50','',''),(3642,'1','308','1',1,'Retail Sale Id 3783',2800.00,0.00,0.00,4.00,304.00,'2023-03-11 09:38:11','',''),(3643,'1','308','1',1,'Retail Sale Id 3784',1400.00,0.00,0.00,2.00,152.00,'2023-03-11 09:42:42','',''),(3644,'1','308','1',1,'Retail Sale Id 3785',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 09:57:41','',''),(3645,'1','308','1',1,'Retail Sale Id 3786',65800.00,0.00,0.00,100.00,3400.00,'2023-03-11 10:02:17','',''),(3646,'1','308','1',1,'Retail Sale Id 3787',2002.00,0.00,0.00,2.86,217.36,'2023-03-11 10:06:19','',''),(3647,'1','308','1',1,'Retail Sale Id 3788',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 10:12:10','',''),(3648,'1','308','1',1,'Retail Sale Id 3789',3500.00,0.00,0.00,5.00,380.00,'2023-03-11 10:16:54','',''),(3649,'1','308','1',1,'Retail Sale Id 3790',8400.00,0.00,0.00,12.00,912.00,'2023-03-11 10:34:40','',''),(3650,'1','308','1',1,'Retail Sale Id 3791',19740.00,0.00,0.00,30.00,1020.00,'2023-03-11 11:06:11','',''),(3651,'1','308','1',1,'Retail Sale Id 3792',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 11:07:36','',''),(3652,'1','308','1',1,'Retail Sale Id 3793',3500.00,0.00,0.00,5.00,380.00,'2023-03-11 11:09:44','',''),(3653,'1','308','1',1,'Retail Sale Id 3794',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 11:24:22','',''),(3654,'1','308','1',1,'Retail Sale Id 3795',8750.00,0.00,0.00,12.50,950.00,'2023-03-11 12:04:10','',''),(3655,'1','308','1',1,'Retail Sale Id 3796',8750.00,0.00,0.00,12.50,950.00,'2023-03-11 12:18:46','',''),(3656,'1','308','1',1,'Retail Sale Id 3797',1498.00,0.00,0.00,2.14,162.64,'2023-03-11 12:21:00','',''),(3657,'1','308','1',1,'Retail Sale Id 3798',1498.00,0.00,0.00,2.14,162.64,'2023-03-11 12:31:03','',''),(3658,'1','308','1',1,'Retail Sale Id 3799',2800.00,0.00,0.00,4.00,304.00,'2023-03-11 12:33:20','',''),(3659,'1','308','1',1,'Retail Sale Id 3800',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 12:42:06','',''),(3660,'1','308','1',1,'Retail Sale Id 3801',3500.00,0.00,0.00,5.00,380.00,'2023-03-11 12:47:28','',''),(3661,'1','308','1',1,'Retail Sale Id 3802',3500.00,0.00,0.00,5.00,380.00,'2023-03-11 12:56:27','',''),(3662,'1','308','1',1,'Retail Sale Id 3803',4200.00,0.00,0.00,6.00,456.00,'2023-03-11 13:13:39','',''),(3663,'1','308','1',1,'Retail Sale Id 3804',76328.00,0.00,0.00,116.00,3944.00,'2023-03-11 13:21:31','',''),(3664,'1','308','1',1,'Retail Sale Id 3805',32900.00,0.00,0.00,50.00,1700.00,'2023-03-11 13:24:21','',''),(3665,'1','308','1',1,'Retail Sale Id 3806',700.00,0.00,0.00,1.00,76.00,'2023-03-11 13:25:45','',''),(3666,'1','308','1',1,'Retail Sale Id 3807',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 13:27:29','',''),(3667,'1','308','1',1,'Retail Sale Id 3808',4200.00,0.00,0.00,6.00,456.00,'2023-03-11 13:38:43','',''),(3668,'1','308','1',1,'Retail Sale Id 3809',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 14:00:39','',''),(3669,'1','308','1',1,'Retail Sale Id 3810',3500.00,0.00,0.00,5.00,380.00,'2023-03-11 14:15:49','',''),(3670,'1','308','1',1,'Retail Sale Id 3811',3997.00,0.00,0.00,5.71,433.96,'2023-03-11 14:33:28','',''),(3671,'1','308','1',1,'Retail Sale Id 3812',8750.00,0.00,0.00,12.50,950.00,'2023-03-11 14:44:11','',''),(3672,'1','308','1',1,'Retail Sale Id 3813',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 15:15:56','',''),(3673,'1','308','1',1,'Retail Sale Id 3814',4200.00,0.00,0.00,6.00,456.00,'2023-03-11 15:23:01','',''),(3674,'1','308','1',1,'Retail Sale Id 3815',2800.00,0.00,0.00,4.00,304.00,'2023-03-11 15:29:56','',''),(3675,'1','308','1',1,'Retail Sale Id 3816',700.00,0.00,0.00,1.00,76.00,'2023-03-11 15:41:22','',''),(3676,'1','308','1',1,'Retail Sale Id 3817',700.00,0.00,0.00,1.00,76.00,'2023-03-11 16:07:18','',''),(3677,'1','308','1',1,'Retail Sale Id 3818',700.00,0.00,0.00,1.00,76.00,'2023-03-11 16:10:08','',''),(3678,'1','308','1',1,'Retail Sale Id 3819',1400.00,0.00,0.00,2.00,152.00,'2023-03-11 16:38:43','',''),(3679,'1','308','1',1,'Retail Sale Id 3820',1400.00,0.00,0.00,2.00,152.00,'2023-03-11 16:49:58','',''),(3680,'1','308','1',1,'Retail Sale Id 3821',1400.00,0.00,0.00,2.00,152.00,'2023-03-11 16:50:51','',''),(3681,'1','308','1',1,'Retail Sale Id 3822',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 17:07:45','',''),(3682,'1','308','1',1,'Retail Sale Id 3823',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 17:20:09','',''),(3683,'1','308','1',1,'Retail Sale Id 3826',4221.00,0.00,0.00,6.03,458.28,'2023-03-11 18:04:32','',''),(3684,'1','308','1',1,'Retail Sale Id 3827',1400.00,0.00,0.00,2.00,152.00,'2023-03-12 07:23:49','',''),(3685,'1','308','1',1,'Retail Sale Id 3828',2100.00,0.00,0.00,3.00,228.00,'2023-03-12 07:25:21','',''),(3686,'1','308','1',1,'Retail Sale Id 3829',4900.00,0.00,0.00,7.00,532.00,'2023-03-12 07:35:48','',''),(3687,'1','308','1',1,'Retail Sale Id 3830',65800.00,0.00,0.00,100.00,3400.00,'2023-03-12 07:50:26','',''),(3688,'1','308','1',1,'Retail Sale Id 3831',1498.00,0.00,0.00,2.14,162.64,'2023-03-12 07:51:29','',''),(3689,'1','308','1',1,'Retail Sale Id 3832',2100.00,0.00,0.00,3.00,228.00,'2023-03-12 07:52:40','',''),(3690,'1','308','1',1,'Retail Sale Id 3833',4200.00,0.00,0.00,6.00,456.00,'2023-03-12 07:53:48','',''),(3691,'1','308','1',1,'Retail Sale Id 3834',3500.00,0.00,0.00,5.00,380.00,'2023-03-12 08:00:59','',''),(3692,'1','308','1',1,'Retail Sale Id 3835',497.00,0.00,0.00,0.71,53.96,'2023-03-12 08:02:02','',''),(3693,'1','308','1',1,'Retail Sale Id 3836',3500.00,0.00,0.00,5.00,380.00,'2023-03-12 08:06:06','',''),(3694,'1','308','1',1,'Retail Sale Id 3837',3003.00,0.00,0.00,4.29,326.04,'2023-03-12 08:11:20','',''),(3695,'1','308','1',1,'Retail Sale Id 3838',1400.00,0.00,0.00,2.00,152.00,'2023-03-12 08:21:07','',''),(3696,'1','308','1',1,'Retail Sale Id 3839',2100.00,0.00,0.00,3.00,228.00,'2023-03-12 08:23:16','',''),(3697,'1','308','1',1,'Retail Sale Id 3840',7000.00,0.00,0.00,10.00,760.00,'2023-03-12 08:40:36','',''),(3698,'1','308','1',1,'Retail Sale Id 3841',700.00,0.00,0.00,1.00,76.00,'2023-03-12 08:49:02','',''),(3699,'1','308','1',1,'Retail Sale Id 3842',2002.00,0.00,0.00,2.86,217.36,'2023-03-12 09:02:18','',''),(3700,'1','308','1',1,'Retail Sale Id 3843',1897.00,0.00,0.00,2.71,205.96,'2023-03-12 09:17:12','',''),(3701,'1','308','1',1,'Retail Sale Id 3844',1400.00,0.00,0.00,2.00,152.00,'2023-03-12 09:27:18','',''),(3702,'1','308','1',1,'Retail Sale Id 3845',5600.00,0.00,0.00,8.00,608.00,'2023-03-12 09:36:45','',''),(3703,'1','308','1',1,'Retail Sale Id 3846',32900.00,0.00,0.00,50.00,1700.00,'2023-03-12 10:54:52','',''),(3704,'1','308','1',1,'Retail Sale Id 3847',46060.00,0.00,0.00,70.00,2380.00,'2023-03-12 12:48:57','',''),(3705,'1','308','1',1,'Retail Sale Id 3848',497.00,0.00,0.00,0.71,53.96,'2023-03-12 13:17:06','',''),(3706,'1','308','1',1,'Retail Sale Id 3849',2800.00,0.00,0.00,4.00,304.00,'2023-03-12 13:37:19','',''),(3707,'1','308','1',1,'Retail Sale Id 3851',1001.00,0.00,0.00,1.43,108.68,'2023-03-12 15:37:11','',''),(3708,'1','308','1',1,'Retail Sale Id 3852',3003.00,0.00,0.00,4.29,326.04,'2023-03-12 15:39:09','',''),(3709,'1','308','1',1,'Retail Sale Id 3853',2100.00,0.00,0.00,3.00,228.00,'2023-03-12 15:52:00','',''),(3710,'1','308','1',1,'Retail Sale Id 3854',52640.00,0.00,0.00,80.00,2720.00,'2023-03-12 16:03:36','',''),(3711,'1','308','1',1,'Retail Sale Id 3855',2499.00,0.00,0.00,3.57,271.32,'2023-03-12 16:16:34','',''),(3712,'1','308','1',1,'Retail Sale Id 3856',7000.00,0.00,0.00,10.00,760.00,'2023-03-12 16:31:09','',''),(3713,'1','308','1',1,'Retail Sale Id 3857',19740.00,0.00,0.00,30.00,1020.00,'2023-03-12 16:44:44','',''),(3714,'1','308','1',1,'Retail Sale Id 3858',32900.00,0.00,0.00,50.00,1700.00,'2023-03-12 16:46:23','',''),(3715,'1','308','1',1,'Retail Sale Id 3859',700.00,0.00,0.00,1.00,76.00,'2023-03-12 17:20:19','',''),(3716,'1','308','1',1,'Retail Sale Id 3860',2100.00,0.00,0.00,3.00,228.00,'2023-03-12 17:38:28','',''),(3717,'1','308','1',1,'Retail Sale Id 3861',700.00,0.00,0.00,1.00,76.00,'2023-03-12 17:39:57','',''),(3718,'1','308','1',1,'Retail Sale Id 3862',2800.00,0.00,0.00,4.00,304.00,'2023-03-12 18:21:50','',''),(3719,'1','308','1',1,'Retail Sale Id 3863',40467.00,0.00,0.00,61.50,2091.00,'2023-03-12 18:43:21','',''),(3720,'1','308','1',1,'Retail Sale Id 3864',1505.00,0.00,0.00,2.15,163.40,'2023-03-12 18:44:13','',''),(3721,'1','308','1',1,'Retail Sale Id 3865',2100.00,0.00,0.00,3.00,228.00,'2023-03-13 07:39:44','',''),(3722,'1','308','1',1,'Retail Sale Id 3866',3003.00,0.00,0.00,4.29,326.04,'2023-03-13 07:41:16','',''),(3723,'1','308','1',1,'Retail Sale Id 3867',2100.00,0.00,0.00,3.00,228.00,'2023-03-13 07:44:20','',''),(3724,'1','308','1',1,'Retail Sale Id 3868',2800.00,0.00,0.00,4.00,304.00,'2023-03-13 07:57:57','',''),(3725,'1','308','1',1,'Retail Sale Id 3869',6300.00,0.00,0.00,9.00,684.00,'2023-03-13 08:01:43','',''),(3726,'1','308','1',1,'Retail Sale Id 3870',1400.00,0.00,0.00,2.00,152.00,'2023-03-13 08:09:08','',''),(3727,'1','308','1',1,'Retail Sale Id 3871',700.00,0.00,0.00,1.00,76.00,'2023-03-13 08:30:37','',''),(3728,'1','308','1',1,'Retail Sale Id 3872',3500.00,0.00,0.00,5.00,380.00,'2023-03-13 08:32:50','',''),(3729,'1','308','1',1,'Retail Sale Id 3873',1400.00,0.00,0.00,2.00,152.00,'2023-03-13 08:57:21','',''),(3730,'1','308','1',1,'Retail Sale Id 3874',65800.00,0.00,0.00,100.00,3400.00,'2023-03-13 09:13:27','',''),(3731,'1','308','1',1,'Retail Sale Id 3875',19740.00,0.00,0.00,30.00,1020.00,'2023-03-13 09:26:07','',''),(3732,'1','308','1',1,'Retail Sale Id 3876',32900.00,0.00,0.00,50.00,1700.00,'2023-03-13 09:27:56','',''),(3733,'1','308','1',1,'Retail Sale Id 3877',7700.00,0.00,0.00,11.00,836.00,'2023-03-13 09:30:29','',''),(3734,'1','308','1',1,'Retail Sale Id 3878',1400.00,0.00,0.00,2.00,152.00,'2023-03-13 09:42:49','',''),(3735,'1','308','1',1,'Retail Sale Id 3879',2100.00,0.00,0.00,3.00,228.00,'2023-03-13 09:53:59','',''),(3736,'1','308','1',1,'Retail Sale Id 3880',65800.00,0.00,0.00,100.00,3400.00,'2023-03-13 10:37:29','',''),(3737,'1','308','1',1,'Retail Sale Id 3881',1946.00,0.00,0.00,2.78,211.28,'2023-03-13 11:07:31','',''),(3738,'1','308','1',1,'Return of Retail Sale Id 3876',0.00,32900.00,50.00,0.00,-1700.00,'2023-03-13 11:36:30','',''),(3739,'1','308','1',1,'Retail Sale Id 3882',32807.88,0.00,0.00,49.86,1695.24,'2023-03-13 11:38:02','',''),(3740,'1','308','1',1,'Distributed to AA RANO NIG. LTD for sales id:3',6202.56,0.00,0.00,9.94,0.00,'2023-03-13 11:44:10','',''),(3741,'1','308',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,624000.00,1000.00,0.00,0.00,'2023-03-13 13:15:12','',''),(3742,'1','308',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,1000.00,0.00,'2023-03-13 13:16:35','',''),(3743,'1','308','1',1,'Received from bridging 11',0.00,0.00,1000.00,0.00,0.00,'2023-03-13 13:16:35','',''),(3744,'1','308','1',1,'Retail Sale Id 3885',4200.00,0.00,0.00,6.00,456.00,'2023-03-13 13:32:01','',''),(3745,'1','308','1',1,'Retail Sale Id 3886',180950.00,0.00,0.00,275.00,9350.00,'2023-03-13 13:34:10','',''),(3746,'1','308','1',1,'Retail Sale Id 3887',8750.00,0.00,0.00,12.50,950.00,'2023-03-13 13:34:47','',''),(3747,'1','308','1',1,'Retail Sale Id 3889',1400.00,0.00,0.00,2.00,152.00,'2023-03-13 14:25:08','',''),(3748,'1','308','1',1,'Retail Sale Id 3890',4200.00,0.00,0.00,6.00,456.00,'2023-03-13 14:38:26','',''),(3749,'1','308',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,2577120.00,4130.00,0.00,0.00,'2023-03-13 14:51:44','',''),(3750,'1','308',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,4130.00,0.00,'2023-03-13 14:52:37','',''),(3751,'1','308','1',1,'Received from bridging 12',0.00,0.00,4130.00,0.00,0.00,'2023-03-13 14:52:37','',''),(3752,'1','308','1',1,'Retail Sale Id 3892',1400.00,0.00,0.00,2.00,152.00,'2023-03-13 14:55:19','',''),(3753,'1','308','1',1,'Retail Sale Id 3893',8400.00,0.00,0.00,12.00,912.00,'2023-03-13 15:12:13','',''),(3754,'1','308','1',1,'Retail Sale Id 3894',3997.00,0.00,0.00,5.71,433.96,'2023-03-13 15:17:51','',''),(3755,'1','308','1',1,'Retail Sale Id 3895',700.00,0.00,0.00,1.00,76.00,'2023-03-13 15:35:12','',''),(3756,'1','308','1',1,'Retail Sale Id 3896',4200.00,0.00,0.00,6.00,456.00,'2023-03-13 15:44:39','',''),(3757,'1','308','1',1,'Retail Sale Id 3897',3500.00,0.00,0.00,5.00,380.00,'2023-03-13 16:00:45','',''),(3758,'1','308','1',1,'Retail Sale Id 3898',1400.00,0.00,0.00,2.00,152.00,'2023-03-13 16:02:03','',''),(3759,'1','308','1',1,'Retail Sale Id 3900',4200.00,0.00,0.00,6.00,456.00,'2023-03-13 16:16:36','',''),(3760,'1','308','1',1,'Retail Sale Id 3901',2198.00,0.00,0.00,3.14,238.64,'2023-03-13 16:19:12','',''),(3761,'1','308','1',1,'Retail Sale Id 3902',700.00,0.00,0.00,1.00,76.00,'2023-03-13 16:28:05','',''),(3762,'1','308','1',1,'Retail Sale Id 3903',1099.00,0.00,0.00,1.57,119.32,'2023-03-13 16:42:58','',''),(3763,'1','308','1',1,'Retail Sale Id 3904',8750.00,0.00,0.00,12.50,950.00,'2023-03-13 16:47:15','',''),(3764,'1','308','1',1,'Retail Sale Id 3905',1400.00,0.00,0.00,2.00,152.00,'2023-03-13 17:13:04','',''),(3765,'1','308','1',1,'Retail Sale Id 3906',4200.00,0.00,0.00,6.00,456.00,'2023-03-13 17:34:46','',''),(3766,'1','308','1',1,'Retail Sale Id 3907',1400.00,0.00,0.00,2.00,152.00,'2023-03-13 17:38:08','',''),(3767,'1','308','1',1,'Retail Sale Id 3908',7000.00,0.00,0.00,10.00,760.00,'2023-03-13 17:40:38','',''),(3768,'1','308','1',1,'Retail Sale Id 3909',8750.00,0.00,0.00,12.50,950.00,'2023-03-13 17:42:08','',''),(3769,'1','308','1',1,'Retail Sale Id 3910',1400.00,0.00,0.00,2.00,152.00,'2023-03-13 17:44:32','',''),(3770,'1','308','1',1,'Retail Sale Id 3911',7000.00,0.00,0.00,10.00,760.00,'2023-03-13 17:51:47','',''),(3771,'1','308','1',1,'Retail Sale Id 3912',2100.00,0.00,0.00,3.00,228.00,'2023-03-13 18:23:59','',''),(3772,'1','308','1',1,'Retail Sale Id 3913',2100.00,0.00,0.00,3.00,228.00,'2023-03-13 18:28:36','',''),(3773,'1','308','1',1,'Retail Sale Id 3914',2100.00,0.00,0.00,3.00,228.00,'2023-03-13 18:31:25','',''),(3774,'1','308','1',1,'Retail Sale Id 3915',2100.00,0.00,0.00,3.00,228.00,'2023-03-13 18:32:48','',''),(3775,'1','308','1',1,'Retail Sale Id 3916',4893.00,0.00,0.00,6.99,531.24,'2023-03-13 19:28:20','',''),(3776,'1','308','1',1,'Retail Sale Id 3917',32906.58,0.00,0.00,50.01,1700.34,'2023-03-13 19:30:47','',''),(3777,'1','308','1',1,'Retail Sale Id 3918',1001.00,0.00,0.00,1.43,108.68,'2023-03-14 07:20:25','',''),(3778,'1','308','1',1,'Retail Sale Id 3919',8750.00,0.00,0.00,12.50,950.00,'2023-03-14 07:21:20','',''),(3779,'1','308','1',1,'Retail Sale Id 3920',1400.00,0.00,0.00,2.00,152.00,'2023-03-14 07:22:44','',''),(3780,'1','308','1',1,'Retail Sale Id 3921',4200.00,0.00,0.00,6.00,456.00,'2023-03-14 07:37:27','',''),(3781,'1','308','1',1,'Retail Sale Id 3922',21056.00,0.00,0.00,32.00,1088.00,'2023-03-14 07:49:08','',''),(3782,'1','308','1',1,'Retail Sale Id 3923',2100.00,0.00,0.00,3.00,228.00,'2023-03-14 07:52:07','',''),(3783,'1','308','1',1,'Retail Sale Id 3924',1498.00,0.00,0.00,2.14,162.64,'2023-03-14 07:55:57','',''),(3784,'1','308','1',1,'Retail Sale Id 3925',2100.00,0.00,0.00,3.00,228.00,'2023-03-14 08:07:00','',''),(3785,'1','308','1',1,'Retail Sale Id 3926',1400.00,0.00,0.00,2.00,152.00,'2023-03-14 08:12:30','',''),(3786,'1','308','1',1,'Retail Sale Id 3927',2800.00,0.00,0.00,4.00,304.00,'2023-03-14 08:21:12','',''),(3787,'1','308','1',1,'Retail Sale Id 3928',700.00,0.00,0.00,1.00,76.00,'2023-03-14 09:24:57','',''),(3788,'1','308','1',1,'Retail Sale Id 3929',1400.00,0.00,0.00,2.00,152.00,'2023-03-14 09:31:47','',''),(3789,'1','308','1',1,'Retail Sale Id 3930',700.00,0.00,0.00,1.00,76.00,'2023-03-14 09:38:55','',''),(3790,'1','308','1',1,'Retail Sale Id 3931',2100.00,0.00,0.00,3.00,228.00,'2023-03-14 09:41:27','',''),(3791,'1','308','1',1,'Retail Sale Id 3932',8750.00,0.00,0.00,12.50,950.00,'2023-03-14 10:02:59','',''),(3792,'1','308','1',1,'Retail Sale Id 3933',1400.00,0.00,0.00,2.00,152.00,'2023-03-14 10:09:19','',''),(3793,'1','308','1',1,'Retail Sale Id 3934',4200.00,0.00,0.00,6.00,456.00,'2023-03-14 10:25:43','',''),(3794,'1','308','1',1,'Retail Sale Id 3935',19740.00,0.00,0.00,30.00,1020.00,'2023-03-14 10:42:53','',''),(3795,'1','308','1',1,'Retail Sale Id 3936',2800.00,0.00,0.00,4.00,304.00,'2023-03-14 15:01:00','',''),(3796,'1','308','1',1,'Retail Sale Id 3937',32900.00,0.00,0.00,50.00,1700.00,'2023-03-14 15:05:06','',''),(3797,'1','308','1',1,'Retail Sale Id 3938',1001.00,0.00,0.00,1.43,108.68,'2023-03-14 18:21:57','',''),(3798,'1','308','1',1,'Retail Sale Id 3939',56153.72,0.00,0.00,85.34,2901.56,'2023-03-14 19:05:47','',''),(3799,'1','308','1',1,'Return of Retail Sale Id 3934',0.00,4200.00,6.00,0.00,-456.00,'2023-03-14 19:07:52','',''),(3800,'1','308','1',1,'Retail Sale Id 3940',399.00,0.00,0.00,0.57,43.32,'2023-03-14 19:09:07','',''),(3801,'1','308','1',1,'Retail Sale Id 3941',3500.00,0.00,0.00,5.00,380.00,'2023-03-15 07:13:26','',''),(3802,'1','308','1',1,'Retail Sale Id 3942',1001.00,0.00,0.00,1.43,108.68,'2023-03-15 07:14:32','',''),(3803,'1','308','1',1,'Retail Sale Id 3943',2100.00,0.00,0.00,3.00,228.00,'2023-03-15 07:15:25','',''),(3804,'1','308','1',1,'Retail Sale Id 3944',2002.00,0.00,0.00,2.86,217.36,'2023-03-15 08:17:21','',''),(3805,'1','308','1',1,'Retail Sale Id 3946',4998.00,0.00,0.00,7.14,542.64,'2023-03-15 08:34:37','',''),(3806,'1','308','1',1,'Retail Sale Id 3947',65800.00,0.00,0.00,100.00,3400.00,'2023-03-15 08:51:05','',''),(3807,'1','308','1',1,'Retail Sale Id 3948',1400.00,0.00,0.00,2.00,152.00,'2023-03-15 08:59:34','',''),(3808,'1','308','1',1,'Retail Sale Id 3949',2800.00,0.00,0.00,4.00,304.00,'2023-03-15 09:12:47','',''),(3809,'1','308','1',1,'Retail Sale Id 3950',1400.00,0.00,0.00,2.00,152.00,'2023-03-15 09:21:18','',''),(3810,'1','308','1',1,'Retail Sale Id 3951',3500.00,0.00,0.00,5.00,380.00,'2023-03-15 09:52:04','',''),(3811,'1','308','1',1,'Retail Sale Id 3952',16450.00,0.00,0.00,25.00,850.00,'2023-03-15 10:08:48','',''),(3812,'1','308','1',1,'Retail Sale Id 3953',32900.00,0.00,0.00,50.00,1700.00,'2023-03-15 10:15:03','',''),(3813,'1','308','1',1,'Retail Sale Id 3954',2100.00,0.00,0.00,3.00,228.00,'2023-03-15 10:16:52','',''),(3814,'1','308','1',1,'Retail Sale Id 3955',4200.00,0.00,0.00,6.00,456.00,'2023-03-15 10:18:32','',''),(3815,'1','308','1',1,'Retail Sale Id 3956',1750.00,0.00,0.00,2.50,190.00,'2023-03-15 10:36:38','',''),(3816,'1','308','1',1,'Retail Sale Id 3957',4102.00,0.00,0.00,5.86,445.36,'2023-03-15 11:06:37','',''),(3817,'1','308','1',1,'Retail Sale Id 3958',5600.00,0.00,0.00,8.00,608.00,'2023-03-15 11:22:59','',''),(3818,'1','308','1',1,'Retail Sale Id 3959',4200.00,0.00,0.00,6.00,456.00,'2023-03-15 11:38:16','',''),(3819,'1','308','1',1,'Retail Sale Id 3960',4200.00,0.00,0.00,6.00,456.00,'2023-03-15 11:54:07','',''),(3820,'1','308','1',1,'Retail Sale Id 3961',4200.00,0.00,0.00,6.00,456.00,'2023-03-15 11:55:24','',''),(3821,'1','308','1',1,'Retail Sale Id 3962',1400.00,0.00,0.00,2.00,152.00,'2023-03-15 12:07:01','',''),(3822,'1','308','1',1,'Retail Sale Id 3963',1498.00,0.00,0.00,2.14,162.64,'2023-03-15 12:11:21','',''),(3823,'1','308','1',1,'Retail Sale Id 3964',4200.00,0.00,0.00,6.00,456.00,'2023-03-15 12:39:18','',''),(3824,'1','308','1',1,'Retail Sale Id 3965',1400.00,0.00,0.00,2.00,152.00,'2023-03-15 12:41:44','',''),(3825,'1','308','1',1,'Return of Retail Sale Id 3964',0.00,4200.00,6.00,0.00,-456.00,'2023-03-15 12:43:29','',''),(3826,'1','308','1',1,'Retail Sale Id 3968',3500.00,0.00,0.00,5.00,380.00,'2023-03-15 13:02:38','',''),(3827,'1','308','1',1,'Retail Sale Id 3969',1400.00,0.00,0.00,2.00,152.00,'2023-03-15 13:06:13','',''),(3828,'1','308','1',1,'Retail Sale Id 3970',3500.00,0.00,0.00,5.00,380.00,'2023-03-15 13:20:26','',''),(3829,'1','308','1',1,'Retail Sale Id 3971',700.00,0.00,0.00,1.00,76.00,'2023-03-15 13:38:39','',''),(3830,'1','308','1',1,'Retail Sale Id 3972',2100.00,0.00,0.00,3.00,228.00,'2023-03-15 13:48:17','',''),(3831,'1','308','1',1,'Retail Sale Id 3973',3500.00,0.00,0.00,5.00,380.00,'2023-03-15 14:17:23','',''),(3832,'1','308','1',1,'Retail Sale Id 3974',2800.00,0.00,0.00,4.00,304.00,'2023-03-15 14:23:06','',''),(3833,'1','308','1',1,'Retail Sale Id 3975',700.00,0.00,0.00,1.00,76.00,'2023-03-15 14:38:15','',''),(3834,'1','308','1',1,'Retail Sale Id 3976',7000.00,0.00,0.00,10.00,760.00,'2023-03-15 14:40:23','',''),(3835,'1','308','1',1,'Retail Sale Id 3977',2100.00,0.00,0.00,3.00,228.00,'2023-03-15 14:46:51','',''),(3836,'1','308','1',1,'Retail Sale Id 3978',1001.00,0.00,0.00,1.43,108.68,'2023-03-15 15:29:02','',''),(3837,'1','308','1',1,'Retail Sale Id 3979',19740.00,0.00,0.00,30.00,1020.00,'2023-03-15 15:38:06','',''),(3838,'1','308','1',1,'Retail Sale Id 3980',13160.00,0.00,0.00,20.00,680.00,'2023-03-15 16:38:23','',''),(3839,'1','308','1',1,'Retail Sale Id 3981',2002.00,0.00,0.00,2.86,217.36,'2023-03-15 18:44:10','',''),(3840,'1','308','1',1,'Retail Sale Id 3982',1197.00,0.00,0.00,1.71,129.96,'2023-03-15 18:48:52','',''),(3841,'1','308','1',1,'Retail Sale Id 3983',48692.00,0.00,0.00,74.00,2516.00,'2023-03-15 19:18:34','',''),(3842,'1','308','1',1,'Retail Sale Id 3984',1456.00,0.00,0.00,2.08,158.08,'2023-03-15 19:22:15','',''),(3843,'1','308','1',1,'Retail Sale Id 3985',2100.00,0.00,0.00,3.00,228.00,'2023-03-16 07:21:28','',''),(3844,'1','308','1',1,'Retail Sale Id 3986',2800.00,0.00,0.00,4.00,304.00,'2023-03-16 07:23:13','',''),(3845,'1','308','1',1,'Retail Sale Id 3987',1400.00,0.00,0.00,2.00,152.00,'2023-03-16 07:24:24','',''),(3846,'1','308','1',1,'Retail Sale Id 3988',4998.00,0.00,0.00,7.14,542.64,'2023-03-16 07:28:29','',''),(3847,'1','308','1',1,'Retail Sale Id 3989',3500.00,0.00,0.00,5.00,380.00,'2023-03-16 08:30:56','',''),(3848,'1','308','1',1,'Retail Sale Id 3990',1400.00,0.00,0.00,2.00,152.00,'2023-03-16 09:00:16','',''),(3849,'1','308','1',1,'Retail Sale Id 3991',8750.00,0.00,0.00,12.50,950.00,'2023-03-16 09:09:05','',''),(3850,'1','308','1',1,'Retail Sale Id 3992',1400.00,0.00,0.00,2.00,152.00,'2023-03-16 09:34:02','',''),(3851,'1','308','1',1,'Retail Sale Id 3993',3500.00,0.00,0.00,5.00,380.00,'2023-03-16 09:35:33','',''),(3852,'1','308','1',1,'Retail Sale Id 3994',3500.00,0.00,0.00,5.00,380.00,'2023-03-16 09:42:04','',''),(3853,'1','308','1',1,'Retail Sale Id 3995',1400.00,0.00,0.00,2.00,152.00,'2023-03-16 09:44:15','',''),(3854,'1','308','1',1,'Retail Sale Id 3996',38164.00,0.00,0.00,58.00,1972.00,'2023-03-16 09:49:10','',''),(3855,'1','308','1',1,'Retail Sale Id 3997',2100.00,0.00,0.00,3.00,228.00,'2023-03-16 09:52:59','',''),(3856,'1','308','1',1,'Retail Sale Id 3998',2100.00,0.00,0.00,3.00,228.00,'2023-03-16 09:58:08','',''),(3857,'1','308','1',1,'Retail Sale Id 3999',1400.00,0.00,0.00,2.00,152.00,'2023-03-16 10:05:52','',''),(3858,'1','308','1',1,'Retail Sale Id 4000',2100.00,0.00,0.00,3.00,228.00,'2023-03-16 10:27:04','',''),(3859,'1','308','1',1,'Retail Sale Id 4001',1400.00,0.00,0.00,2.00,152.00,'2023-03-16 10:52:26','',''),(3860,'1','308','1',1,'Retail Sale Id 4002',1750.00,0.00,0.00,2.50,190.00,'2023-03-16 11:01:48','',''),(3861,'1','308','1',1,'Retail Sale Id 4003',2800.00,0.00,0.00,4.00,304.00,'2023-03-16 11:05:05','',''),(3862,'1','308','1',1,'Retail Sale Id 4004',2100.00,0.00,0.00,3.00,228.00,'2023-03-16 11:15:22','',''),(3863,'1','308','1',1,'Retail Sale Id 4005',3500.00,0.00,0.00,5.00,380.00,'2023-03-16 11:53:29','',''),(3864,'1','308','1',1,'Retail Sale Id 4006',5600.00,0.00,0.00,8.00,608.00,'2023-03-16 12:04:54','',''),(3865,'1','308','1',1,'Retail Sale Id 4007',2800.00,0.00,0.00,4.00,304.00,'2023-03-16 12:19:28','',''),(3866,'1','308','1',1,'Retail Sale Id 4008',2800.00,0.00,0.00,4.00,304.00,'2023-03-16 12:39:21','',''),(3867,'1','308','1',1,'Retail Sale Id 4009',2800.00,0.00,0.00,4.00,304.00,'2023-03-16 12:54:27','',''),(3868,'1','308','1',1,'Retail Sale Id 4010',3500.00,0.00,0.00,5.00,380.00,'2023-03-16 13:04:55','',''),(3869,'1','308','1',1,'Retail Sale Id 4011',700.00,0.00,0.00,1.00,76.00,'2023-03-16 13:43:56','',''),(3870,'1','308','1',1,'Retail Sale Id 4012',4200.00,0.00,0.00,6.00,456.00,'2023-03-16 13:45:27','',''),(3871,'1','308','1',1,'Retail Sale Id 4013',700.00,0.00,0.00,1.00,76.00,'2023-03-16 14:08:04','',''),(3872,'1','308','1',1,'Retail Sale Id 4014',1400.00,0.00,0.00,2.00,152.00,'2023-03-16 14:21:09','',''),(3873,'1','308','1',1,'Retail Sale Id 4015',2100.00,0.00,0.00,3.00,228.00,'2023-03-16 14:33:54','',''),(3874,'1','308','1',1,'Retail Sale Id 4016',2800.00,0.00,0.00,4.00,304.00,'2023-03-16 14:38:13','',''),(3875,'1','308','1',1,'Retail Sale Id 4017',1400.00,0.00,0.00,2.00,152.00,'2023-03-16 14:39:52','',''),(3876,'1','308','1',1,'Retail Sale Id 4019',1400.00,0.00,0.00,2.00,152.00,'2023-03-16 15:06:44','',''),(3877,'1','308','1',1,'Retail Sale Id 4020',1400.00,0.00,0.00,2.00,152.00,'2023-03-16 15:24:46','',''),(3878,'1','308','1',1,'Retail Sale Id 4021',1400.00,0.00,0.00,2.00,152.00,'2023-03-16 15:36:50','',''),(3879,'1','308','1',1,'Retail Sale Id 4022',2100.00,0.00,0.00,3.00,228.00,'2023-03-16 15:38:35','',''),(3880,'1','308','1',1,'Retail Sale Id 4023',2100.00,0.00,0.00,3.00,228.00,'2023-03-16 15:41:09','',''),(3881,'1','308','1',1,'Retail Sale Id 4024',98700.00,0.00,0.00,150.00,5100.00,'2023-03-16 15:43:46','',''),(3882,'1','308','1',1,'Retail Sale Id 4025',700.00,0.00,0.00,1.00,76.00,'2023-03-16 16:01:43','',''),(3883,'1','308','1',1,'Retail Sale Id 4026',8400.00,0.00,0.00,12.00,912.00,'2023-03-16 16:24:41','',''),(3884,'1','308','1',1,'Retail Sale Id 4027',1001.00,0.00,0.00,1.43,108.68,'2023-03-16 17:13:50','',''),(3885,'1','308','1',1,'Retail Sale Id 4028',32900.00,0.00,0.00,50.00,1700.00,'2023-03-16 17:23:29','',''),(3886,'1','308','1',1,'Retail Sale Id 4029',1197.00,0.00,0.00,1.71,129.96,'2023-03-16 18:16:24','',''),(3887,'1','308','1',1,'Return of Retail Sale Id 4007',0.00,2800.00,4.00,0.00,-304.00,'2023-03-16 18:34:34','',''),(3888,'1','308','1',1,'Retail Sale Id 4030',7700.00,0.00,0.00,11.00,836.00,'2023-03-16 18:37:16','',''),(3889,'1','308','1',1,'Return of Retail Sale Id 4026',0.00,8400.00,12.00,0.00,-912.00,'2023-03-16 18:52:15','',''),(3890,'1','308','1',1,'Return of Retail Sale Id 4030',0.00,7700.00,11.00,0.00,-836.00,'2023-03-16 18:52:41','',''),(3891,'1','308','1',1,'Retail Sale Id 4031',69090.00,0.00,0.00,105.00,3570.00,'2023-03-16 18:56:17','',''),(3892,'1','308','1',1,'Retail Sale Id 4032',686.00,0.00,0.00,0.98,74.48,'2023-03-16 19:32:01','',''),(3893,'1','308','1',1,'Retail Sale Id 4033',2800.00,0.00,0.00,4.00,304.00,'2023-03-17 07:21:15','',''),(3894,'1','308','1',1,'Retail Sale Id 4034',1001.00,0.00,0.00,1.43,108.68,'2023-03-17 07:39:48','',''),(3895,'1','308','1',1,'Retail Sale Id 4035',2800.00,0.00,0.00,4.00,304.00,'2023-03-17 08:11:07','',''),(3896,'1','308','1',1,'Retail Sale Id 4036',700.00,0.00,0.00,1.00,76.00,'2023-03-17 08:21:16','',''),(3897,'1','308','1',1,'Retail Sale Id 4037',8400.00,0.00,0.00,12.00,912.00,'2023-03-17 08:29:32','',''),(3898,'1','308','1',1,'Retail Sale Id 4038',1400.00,0.00,0.00,2.00,152.00,'2023-03-17 08:34:12','',''),(3899,'1','308','1',1,'Retail Sale Id 4042',1400.00,0.00,0.00,2.00,152.00,'2023-03-17 08:49:44','',''),(3900,'1','308','1',1,'Retail Sale Id 4043',4200.00,0.00,0.00,6.00,456.00,'2023-03-17 08:50:48','',''),(3901,'1','308','1',1,'Retail Sale Id 4044',4200.00,0.00,0.00,6.00,456.00,'2023-03-17 08:51:55','',''),(3902,'1','308','1',1,'Retail Sale Id 4045',8750.00,0.00,0.00,12.50,950.00,'2023-03-17 09:04:24','',''),(3903,'1','308','1',1,'Retail Sale Id 4046',21056.00,0.00,0.00,32.00,1088.00,'2023-03-17 09:11:18','',''),(3904,'1','308','1',1,'Retail Sale Id 4047',65800.00,0.00,0.00,100.00,3400.00,'2023-03-17 09:13:18','',''),(3905,'1','308','1',1,'Retail Sale Id 4048',2100.00,0.00,0.00,3.00,228.00,'2023-03-17 09:19:12','',''),(3906,'1','308','1',1,'Retail Sale Id 4049',1498.00,0.00,0.00,2.14,162.64,'2023-03-17 09:39:12','',''),(3907,'1','308','1',1,'Retail Sale Id 4051',1001.00,0.00,0.00,1.43,108.68,'2023-03-17 10:00:13','',''),(3908,'1','308','1',1,'Retail Sale Id 4052',3500.00,0.00,0.00,5.00,380.00,'2023-03-17 10:26:17','',''),(3909,'1','308','1',1,'Retail Sale Id 4053',2002.00,0.00,0.00,2.86,217.36,'2023-03-17 10:40:23','',''),(3910,'1','308','1',1,'Retail Sale Id 4054',6300.00,0.00,0.00,9.00,684.00,'2023-03-17 10:51:17','',''),(3911,'1','308','1',1,'Retail Sale Id 4055',7000.00,0.00,0.00,10.00,760.00,'2023-03-17 11:14:06','',''),(3912,'1','308','1',1,'Retail Sale Id 4056',32900.00,0.00,0.00,50.00,1700.00,'2023-03-17 11:16:50','',''),(3913,'1','308','1',1,'Retail Sale Id 4057',65800.00,0.00,0.00,100.00,3400.00,'2023-03-17 12:01:05','',''),(3914,'1','308','1',1,'Retail Sale Id 4058',32900.00,0.00,0.00,50.00,1700.00,'2023-03-17 16:54:49','',''),(3915,'1','308','1',1,'Retail Sale Id 4060',35703.08,0.00,0.00,54.26,1844.84,'2023-03-17 16:59:43','',''),(3916,'1','308','1',1,'Return of Retail Sale Id 4060',0.00,35703.08,54.26,0.00,-1844.84,'2023-03-17 17:09:03','',''),(3917,'1','308','1',1,'Retail Sale Id 4061',38164.00,0.00,0.00,58.00,1972.00,'2023-03-17 17:10:26','',''),(3918,'1','308','1',1,'Retail Sale Id 4062',2800.00,0.00,0.00,4.00,304.00,'2023-03-17 17:17:59','',''),(3919,'1','308','1',1,'Return of Retail Sale Id 4045',0.00,8750.00,12.50,0.00,-950.00,'2023-03-17 17:53:52','',''),(3920,'1','308','1',1,'Retail Sale Id 4063',32900.00,0.00,0.00,50.00,1700.00,'2023-03-17 17:59:35','',''),(3921,'1','308','1',1,'Retail Sale Id 4064',19740.00,0.00,0.00,30.00,1020.00,'2023-03-17 18:10:55','',''),(3922,'1','308','1',1,'Retail Sale Id 4041',1400.00,0.00,0.00,2.00,152.00,'2023-03-17 18:31:29','',''),(3923,'1','308','1',1,'Retail Sale Id 4065',83237.00,0.00,0.00,126.50,4301.00,'2023-03-17 19:10:03','',''),(3924,'1','308','1',1,'Retail Sale Id 4066',2303.00,0.00,0.00,3.29,250.04,'2023-03-17 19:15:30','',''),(3925,'1','308','1',1,'Retail Sale Id 4067',2800.00,0.00,0.00,4.00,304.00,'2023-03-19 07:07:14','',''),(3926,'1','308','1',1,'Retail Sale Id 4068',8750.00,0.00,0.00,12.50,950.00,'2023-03-19 07:08:07','',''),(3927,'1','308','1',1,'Retail Sale Id 4069',4200.00,0.00,0.00,6.00,456.00,'2023-03-19 07:09:39','',''),(3928,'1','308','1',1,'Retail Sale Id 4070',3500.00,0.00,0.00,5.00,380.00,'2023-03-19 07:10:49','',''),(3929,'1','308','1',1,'Retail Sale Id 4071',2100.00,0.00,0.00,3.00,228.00,'2023-03-19 07:11:49','',''),(3930,'1','308','1',1,'Retail Sale Id 4072',700.00,0.00,0.00,1.00,76.00,'2023-03-19 07:13:16','',''),(3931,'1','308','1',1,'Retail Sale Id 4073',1400.00,0.00,0.00,2.00,152.00,'2023-03-19 07:14:20','',''),(3932,'1','308','1',1,'Retail Sale Id 4074',8750.00,0.00,0.00,12.50,950.00,'2023-03-19 07:17:40','',''),(3933,'1','308','1',1,'Retail Sale Id 4074',8750.00,0.00,0.00,12.50,950.00,'2023-03-19 07:17:40','',''),(3934,'1','308','1',1,'Retail Sale Id 4075',1400.00,0.00,0.00,2.00,152.00,'2023-03-19 07:26:04','',''),(3935,'1','308','1',1,'Retail Sale Id 4076',2100.00,0.00,0.00,3.00,228.00,'2023-03-19 07:31:05','',''),(3936,'1','308','1',1,'Retail Sale Id 4077',1400.00,0.00,0.00,2.00,152.00,'2023-03-19 07:35:04','',''),(3937,'1','308','1',1,'Retail Sale Id 4078',1400.00,0.00,0.00,2.00,152.00,'2023-03-19 07:37:16','',''),(3938,'1','308','1',1,'Retail Sale Id 4079',13000.00,0.00,0.00,20.00,400.00,'2023-03-19 07:42:11','',''),(3939,'1','308','1',1,'Retail Sale Id 4080',8750.00,0.00,0.00,12.50,875.00,'2023-03-19 07:43:59','',''),(3940,'1','308','1',1,'Retail Sale Id 4081',32500.00,0.00,0.00,50.00,1000.00,'2023-03-19 07:57:29','',''),(3941,'1','308','1',1,'Retail Sale Id 4082',1400.00,0.00,0.00,2.00,140.00,'2023-03-19 08:00:33','',''),(3942,'1','308','1',1,'Retail Sale Id 4083',2100.00,0.00,0.00,3.00,210.00,'2023-03-19 08:13:00','',''),(3943,'1','308','1',1,'Retail Sale Id 4084',3500.00,0.00,0.00,5.00,350.00,'2023-03-19 08:14:10','',''),(3944,'1','308','1',1,'Retail Sale Id 4085',700.00,0.00,0.00,1.00,70.00,'2023-03-19 08:15:18','',''),(3945,'1','308','1',1,'Retail Sale Id 4086',3500.00,0.00,0.00,5.00,350.00,'2023-03-19 08:16:31','',''),(3946,'1','308','1',1,'Retail Sale Id 4087',32500.00,0.00,0.00,50.00,1000.00,'2023-03-19 08:18:10','',''),(3947,'1','308','1',1,'Retail Sale Id 4088',4900.00,0.00,0.00,7.00,490.00,'2023-03-19 08:19:37','',''),(3948,'1','308','1',1,'Retail Sale Id 4089',2100.00,0.00,0.00,3.00,210.00,'2023-03-19 08:21:34','',''),(3949,'1','308','1',1,'Retail Sale Id 4090',2100.00,0.00,0.00,3.00,210.00,'2023-03-19 08:25:14','',''),(3950,'1','308','1',1,'Retail Sale Id 4091',4200.00,0.00,0.00,6.00,420.00,'2023-03-19 08:26:22','',''),(3951,'1','308','1',1,'Retail Sale Id 4092',4200.00,0.00,0.00,6.00,420.00,'2023-03-19 08:27:59','',''),(3952,'1','308','1',1,'Retail Sale Id 4093',2002.00,0.00,0.00,2.86,200.20,'2023-03-19 08:29:56','',''),(3953,'1','308','1',1,'Retail Sale Id 4094',2800.00,0.00,0.00,4.00,280.00,'2023-03-19 08:31:08','',''),(3954,'1','308','1',1,'Retail Sale Id 4095',8750.00,0.00,0.00,12.50,875.00,'2023-03-19 08:41:41','',''),(3955,'1','308','1',1,'Retail Sale Id 4096',3500.00,0.00,0.00,5.00,350.00,'2023-03-19 08:42:44','',''),(3956,'1','308','1',1,'Retail Sale Id 4097',32500.00,0.00,0.00,50.00,1000.00,'2023-03-19 08:44:35','',''),(3957,'1','308','1',1,'Retail Sale Id 4098',1400.00,0.00,0.00,2.00,140.00,'2023-03-19 09:02:50','',''),(3958,'1','308','1',1,'Retail Sale Id 4099',3500.00,0.00,0.00,5.00,350.00,'2023-03-19 09:04:16','',''),(3959,'1','308','1',1,'Retail Sale Id 4100',2100.00,0.00,0.00,3.00,210.00,'2023-03-19 09:05:46','',''),(3960,'1','308','1',1,'Retail Sale Id 4101',19500.00,0.00,0.00,30.00,600.00,'2023-03-19 09:12:24','',''),(3961,'1','308','1',1,'Retail Sale Id 4102',2800.00,0.00,0.00,4.00,280.00,'2023-03-19 09:14:23','',''),(3962,'1','308','1',1,'Retail Sale Id 4103',35750.00,0.00,0.00,55.00,1100.00,'2023-03-19 09:15:43','',''),(3963,'1','308','1',1,'Retail Sale Id 4104',8750.00,0.00,0.00,12.50,875.00,'2023-03-19 09:26:37','',''),(3964,'1','308','1',1,'Retail Sale Id 4105',2100.00,0.00,0.00,3.00,210.00,'2023-03-19 09:37:56','',''),(3965,'1','308','1',1,'Retail Sale Id 4106',1001.00,0.00,0.00,1.43,100.10,'2023-03-19 09:40:03','',''),(3966,'1','308','1',1,'Retail Sale Id 4107',2100.00,0.00,0.00,3.00,210.00,'2023-03-19 09:52:07','',''),(3967,'1','308','1',1,'Retail Sale Id 4108',2100.00,0.00,0.00,3.00,210.00,'2023-03-19 09:58:13','',''),(3968,'1','308','1',1,'Retail Sale Id 4108',4200.00,0.00,0.00,6.00,420.00,'2023-03-19 09:58:13','',''),(3969,'1','308','1',1,'Retail Sale Id 4109',700.00,0.00,0.00,1.00,70.00,'2023-03-19 11:02:19','',''),(3970,'1','308','1',1,'Retail Sale Id 4110',97500.00,0.00,0.00,150.00,3000.00,'2023-03-19 11:33:11','',''),(3971,'1','308','1',1,'Retail Sale Id 4111',2100.00,0.00,0.00,3.00,210.00,'2023-03-19 11:43:18','',''),(3972,'1','308','1',1,'Retail Sale Id 4112',7000.00,0.00,0.00,10.00,700.00,'2023-03-19 11:48:59','',''),(3973,'1','308','1',1,'Retail Sale Id 4113',19500.00,0.00,0.00,30.00,600.00,'2023-03-19 12:12:53','',''),(3974,'1','308','1',1,'Retail Sale Id 4114',1750.00,0.00,0.00,2.50,175.00,'2023-03-19 12:30:18','',''),(3975,'1','308','1',1,'Retail Sale Id 4114',7700.00,0.00,0.00,11.00,770.00,'2023-03-19 12:30:18','',''),(3976,'1','308','1',1,'Retail Sale Id 4115',700.00,0.00,0.00,1.00,70.00,'2023-03-19 12:48:29','',''),(3977,'1','308','1',1,'Retail Sale Id 4116',97500.00,0.00,0.00,150.00,3000.00,'2023-03-19 13:49:44','',''),(3978,'1','308','1',1,'Retail Sale Id 4117',65000.00,0.00,0.00,100.00,2000.00,'2023-03-19 14:22:33','',''),(3979,'1','308','1',1,'Retail Sale Id 4118',2499.00,0.00,0.00,3.57,249.90,'2023-03-19 14:49:08','',''),(3980,'1','308','1',1,'Return of Retail Sale Id 4095',0.00,8750.00,12.50,0.00,-875.00,'2023-03-19 15:33:21','',''),(3981,'1','308','1',1,'Retail Sale Id 4119',4900.00,0.00,0.00,7.00,490.00,'2023-03-19 15:33:58','',''),(3982,'1','308','1',1,'Retail Sale Id 4120',65000.00,0.00,0.00,100.00,2000.00,'2023-03-19 15:58:54','',''),(3983,'1','308','1',1,'Retail Sale Id 4122',1400.00,0.00,0.00,2.00,140.00,'2023-03-19 17:45:15','',''),(3984,'1','308','1',1,'Retail Sale Id 4123',65000.00,0.00,0.00,100.00,2000.00,'2023-03-19 17:47:18','',''),(3985,'1','308','1',1,'Retail Sale Id 4124',1498.00,0.00,0.00,2.14,149.80,'2023-03-19 17:47:49','',''),(3986,'1','308','1',1,'Retail Sale Id 4125',3500.00,0.00,0.00,5.00,350.00,'2023-03-19 17:48:53','',''),(3987,'1','308','1',1,'Retail Sale Id 4126',42724.50,0.00,0.00,65.73,1314.60,'2023-03-19 17:52:11','',''),(3988,'1','308','1',1,'Retail Sale Id 4127',1400.00,0.00,0.00,2.00,140.00,'2023-03-19 18:00:12','',''),(3989,'1','308','1',1,'Retail Sale Id 4128',2100.00,0.00,0.00,3.00,210.00,'2023-03-19 18:01:17','',''),(3990,'1','308','1',1,'Retail Sale Id 4129',1400.00,0.00,0.00,2.00,140.00,'2023-03-19 18:02:24','',''),(3991,'1','308','1',1,'Retail Sale Id 4130',4200.00,0.00,0.00,6.00,420.00,'2023-03-19 18:04:20','',''),(3992,'1','308','1',1,'Retail Sale Id 4131',7000.00,0.00,0.00,10.00,700.00,'2023-03-19 18:05:28','',''),(3993,'1','308','1',1,'Retail Sale Id 4132',3500.00,0.00,0.00,5.00,350.00,'2023-03-19 18:20:16','',''),(3994,'1','308','1',1,'Retail Sale Id 4133',2100.00,0.00,0.00,3.00,210.00,'2023-03-19 18:23:29','',''),(3995,'1','308','1',1,'Retail Sale Id 4134',700.00,0.00,0.00,1.00,70.00,'2023-03-19 18:28:09','',''),(3996,'1','308','1',1,'Retail Sale Id 4135',1400.00,0.00,0.00,2.00,140.00,'2023-03-19 18:29:53','',''),(3997,'1','308','1',1,'Retail Sale Id 4136',4200.00,0.00,0.00,6.00,420.00,'2023-03-19 18:32:35','',''),(3998,'1','308','1',1,'Retail Sale Id 4137',1400.00,0.00,0.00,2.00,140.00,'2023-03-19 18:36:17','',''),(3999,'1','308','1',1,'Retail Sale Id 4138',29425.50,0.00,0.00,45.27,905.40,'2023-03-19 19:13:28','',''),(4000,'1','308','1',1,'Return of Retail Sale Id 4132',0.00,3500.00,5.00,0.00,-350.00,'2023-03-19 19:14:28','',''),(4001,'1','308','1',1,'Retail Sale Id 4139',1155.00,0.00,0.00,1.65,115.50,'2023-03-19 19:15:31','',''),(4002,'1','308','1',1,'Retail Sale Id 4140',93600.00,0.00,0.00,144.00,2880.00,'2023-03-20 08:19:14','',''),(4003,'1','308','1',1,'Retail Sale Id 4141',178750.00,0.00,0.00,275.00,5500.00,'2023-03-20 13:27:14','',''),(4004,'1','308','1',1,'Retail Sale Id 4142',8750.00,0.00,0.00,12.50,875.00,'2023-03-20 13:45:51','',''),(4005,'1','308','1',1,'Retail Sale Id 4143',106050.00,0.00,0.00,151.50,10605.00,'2023-03-20 13:50:59','',''),(4006,'1','308','1',1,'Retail Sale Id 4144',12201.00,0.00,0.00,17.43,1220.10,'2023-03-20 13:53:08','',''),(4007,'1','308','1',1,'Retail Sale Id 4145',2100.00,0.00,0.00,3.00,210.00,'2023-03-20 13:54:43','',''),(4008,'1','308','1',1,'Retail Sale Id 4146',2100.00,0.00,0.00,3.00,210.00,'2023-03-20 14:05:54','',''),(4009,'1','308','1',1,'Retail Sale Id 4147',2100.00,0.00,0.00,3.00,210.00,'2023-03-20 14:15:53','',''),(4010,'1','308','1',1,'Retail Sale Id 4148',2100.00,0.00,0.00,3.00,210.00,'2023-03-20 14:19:16','',''),(4011,'1','308','1',1,'Retail Sale Id 4149',37700.00,0.00,0.00,58.00,1160.00,'2023-03-20 14:22:40','',''),(4012,'1','308','1',1,'Retail Sale Id 4150',1400.00,0.00,0.00,2.00,140.00,'2023-03-20 14:48:48','',''),(4013,'1','308','1',1,'Retail Sale Id 4151',3500.00,0.00,0.00,5.00,350.00,'2023-03-20 15:29:36','',''),(4014,'1','308','1',1,'Retail Sale Id 4152',2100.00,0.00,0.00,3.00,210.00,'2023-03-20 15:34:05','',''),(4015,'1','308','1',1,'Retail Sale Id 4153',1400.00,0.00,0.00,2.00,140.00,'2023-03-20 15:51:12','',''),(4016,'1','308','1',1,'Retail Sale Id 4154',1400.00,0.00,0.00,2.00,140.00,'2023-03-20 16:14:33','',''),(4017,'1','308','1',1,'Retail Sale Id 4155',8750.00,0.00,0.00,12.50,875.00,'2023-03-20 16:20:30','',''),(4018,'1','308','1',1,'Retail Sale Id 4156',1400.00,0.00,0.00,2.00,140.00,'2023-03-20 16:31:34','',''),(4019,'1','308','1',1,'Retail Sale Id 4157',19500.00,0.00,0.00,30.00,600.00,'2023-03-20 16:32:59','',''),(4020,'1','308','1',1,'Retail Sale Id 4158',3500.00,0.00,0.00,5.00,350.00,'2023-03-20 16:48:33','',''),(4021,'1','308','1',1,'Retail Sale Id 4159',1400.00,0.00,0.00,2.00,140.00,'2023-03-20 16:54:02','',''),(4022,'1','308','1',1,'Retail Sale Id 4160',2100.00,0.00,0.00,3.00,210.00,'2023-03-20 17:01:53','',''),(4023,'1','308','1',1,'Retail Sale Id 4161',700.00,0.00,0.00,1.00,70.00,'2023-03-20 17:03:25','',''),(4024,'1','308','1',1,'Retail Sale Id 4162',1400.00,0.00,0.00,2.00,140.00,'2023-03-20 17:04:53','',''),(4025,'1','308','1',1,'Retail Sale Id 4163',7000.00,0.00,0.00,10.00,700.00,'2023-03-20 17:10:08','',''),(4026,'1','308','1',1,'Retail Sale Id 4164',1498.00,0.00,0.00,2.14,149.80,'2023-03-20 17:11:46','',''),(4027,'1','308','1',1,'Retail Sale Id 4165',1400.00,0.00,0.00,2.00,140.00,'2023-03-20 17:15:14','',''),(4028,'1','308','1',1,'Retail Sale Id 4166',2800.00,0.00,0.00,4.00,280.00,'2023-03-20 17:17:54','',''),(4029,'1','308','1',1,'Retail Sale Id 4167',700.00,0.00,0.00,1.00,70.00,'2023-03-20 17:19:08','',''),(4030,'1','308','1',1,'Retail Sale Id 4168',700.00,0.00,0.00,1.00,70.00,'2023-03-20 17:20:54','',''),(4031,'1','308','1',1,'Retail Sale Id 4169',2100.00,0.00,0.00,3.00,210.00,'2023-03-20 17:24:41','',''),(4032,'1','308','1',1,'Retail Sale Id 4170',2100.00,0.00,0.00,3.00,210.00,'2023-03-20 17:26:27','',''),(4033,'1','308','1',1,'Retail Sale Id 4171',2800.00,0.00,0.00,4.00,280.00,'2023-03-20 17:32:16','',''),(4034,'1','308','1',1,'Retail Sale Id 4172',4200.00,0.00,0.00,6.00,420.00,'2023-03-20 17:33:17','',''),(4035,'1','308','1',1,'Return of Retail Sale Id 4155',0.00,8750.00,12.50,0.00,-875.00,'2023-03-20 17:57:38','',''),(4036,'1','308','1',1,'Return of Retail Sale Id 4144',0.00,12201.00,17.43,0.00,-1220.10,'2023-03-20 17:58:47','',''),(4037,'1','308','1',1,'Retail Sale Id 4173',46475.00,0.00,0.00,71.50,1430.00,'2023-03-20 19:09:42','',''),(4038,'1','308','1',1,'Retail Sale Id 4174',13951.00,0.00,0.00,19.93,1395.10,'2023-03-20 19:11:31','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'1','308',1,695.03,'2023-03-20 19:11:31');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4006 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'1','308',1,'Retail Sale Id 3',0.00,664.00,770.00,770.00,106.00,'2022-12-23 11:31:06'),(2,'1','308',1,'Retail Sale Id 4',0.00,39840.00,720.00,43200.00,3360.00,'2022-12-23 12:29:11'),(3,'1','308',1,'Retail Sale Id 5',0.00,3320.00,770.00,3850.00,530.00,'2022-12-23 14:49:29'),(4,'1','308',1,'Retail Sale Id 6',0.00,2855.20,770.00,3311.00,455.80,'2022-12-23 17:57:22'),(5,'1','308',1,'Retail Sale Id 7',0.00,1328.00,770.00,1540.00,212.00,'2022-12-23 17:59:33'),(6,'1','308',1,'Return of Retail Sale Id 7',1328.00,0.00,770.00,-1540.00,-212.00,'2022-12-23 19:19:32'),(7,'1','308',1,'Return of Retail Sale Id 4',39840.00,0.00,720.00,-43200.00,-3360.00,'2022-12-23 19:45:24'),(8,'1','308',1,'Return of Retail Sale Id 6',2855.20,0.00,770.00,-3311.00,-455.80,'2022-12-23 19:45:56'),(9,'1','308',1,'Return of Retail Sale Id 5',3320.00,0.00,770.00,-3850.00,-530.00,'2022-12-23 19:46:25'),(10,'1','308',1,'Retail Sale Id 8',0.00,44687.20,730.00,49129.00,4441.80,'2022-12-23 19:49:02'),(11,'1','308',1,'Retail Sale Id 9',0.00,3984.00,770.00,4620.00,636.00,'2022-12-23 19:50:22'),(12,'1','308',1,'Retail Sale Id 10',0.00,2025.20,770.00,2348.50,323.30,'2022-12-24 08:35:42'),(13,'1','308',1,'Retail Sale Id 11',0.00,1992.00,770.00,2310.00,318.00,'2022-12-24 08:51:00'),(14,'1','308',1,'Retail Sale Id 12',0.00,1992.00,770.00,2310.00,318.00,'2022-12-24 08:52:31'),(15,'1','308',1,'Retail Sale Id 13',0.00,1992.00,770.00,2310.00,318.00,'2022-12-24 08:53:32'),(16,'1','308',1,'Retail Sale Id 14',0.00,3665.28,770.00,4250.40,585.12,'2022-12-24 09:23:28'),(17,'1','308',1,'Retail Sale Id 15',0.00,4010.56,770.00,4650.80,640.24,'2022-12-24 10:15:28'),(18,'1','308',1,'Retail Sale Id 16',0.00,664.00,770.00,770.00,106.00,'2022-12-24 10:55:44'),(19,'1','308',1,'Retail Sale Id 17',0.00,1726.40,770.00,2002.00,275.60,'2022-12-24 11:18:41'),(20,'1','308',1,'Retail Sale Id 18',0.00,1294.80,770.00,1501.50,206.70,'2022-12-24 11:41:59'),(21,'1','308',1,'Retail Sale Id 19',0.00,431.60,770.00,500.50,68.90,'2022-12-24 12:00:01'),(22,'1','308',1,'Retail Sale Id 20',0.00,1328.00,770.00,1540.00,212.00,'2022-12-24 12:27:29'),(23,'1','308',1,'Retail Sale Id 21',0.00,1328.00,770.00,1540.00,212.00,'2022-12-24 12:28:50'),(24,'1','308',1,'Retail Sale Id 22',0.00,1328.00,770.00,1540.00,212.00,'2022-12-24 12:31:59'),(25,'1','308',1,'Retail Sale Id 23',0.00,1328.00,770.00,1540.00,212.00,'2022-12-24 12:39:24'),(26,'1','308',1,'Retail Sale Id 24',0.00,1294.80,770.00,1501.50,206.70,'2022-12-24 12:41:02'),(27,'1','308',1,'Retail Sale Id 25',0.00,1992.00,770.00,2310.00,318.00,'2022-12-24 12:42:47'),(28,'1','308',1,'Retail Sale Id 26',0.00,2656.00,770.00,3080.00,424.00,'2022-12-24 12:47:46'),(29,'1','308',1,'Retail Sale Id 27',0.00,690.56,770.00,800.80,110.24,'2022-12-24 12:55:13'),(30,'1','308',1,'Retail Sale Id 28',0.00,690.56,770.00,800.80,110.24,'2022-12-24 12:57:36'),(31,'1','308',1,'Retail Sale Id 29',0.00,1992.00,770.00,2310.00,318.00,'2022-12-24 13:00:07'),(32,'1','308',1,'Retail Sale Id 30',0.00,1328.00,770.00,1540.00,212.00,'2022-12-24 13:03:47'),(33,'1','308',1,'Retail Sale Id 31',0.00,1992.00,770.00,2310.00,318.00,'2022-12-24 13:09:01'),(34,'1','308',1,'Retail Sale Id 32',0.00,2675.92,770.00,3103.10,427.18,'2022-12-24 13:13:18'),(35,'1','308',1,'Retail Sale Id 33',0.00,8319.92,770.00,9648.10,1328.18,'2022-12-24 13:16:38'),(36,'1','308',1,'Retail Sale Id 34',0.00,1328.00,770.00,1540.00,212.00,'2022-12-24 13:22:24'),(37,'1','308',1,'Retail Sale Id 35',0.00,1328.00,770.00,1540.00,212.00,'2022-12-24 13:24:53'),(38,'1','308',1,'Retail Sale Id 36',0.00,690.56,770.00,800.80,110.24,'2022-12-24 13:25:40'),(39,'1','308',1,'Retail Sale Id 37',0.00,2675.92,770.00,3103.10,427.18,'2022-12-24 13:28:07'),(40,'1','308',1,'Retail Sale Id 38',0.00,1328.00,770.00,1540.00,212.00,'2022-12-24 13:29:40'),(41,'1','308',1,'Retail Sale Id 39',0.00,1992.00,770.00,2310.00,318.00,'2022-12-24 13:32:56'),(42,'1','308',1,'Retail Sale Id 40',0.00,1328.00,770.00,1540.00,212.00,'2022-12-24 13:35:03'),(43,'1','308',1,'Retail Sale Id 41',0.00,690.56,770.00,800.80,110.24,'2022-12-24 13:36:36'),(44,'1','308',1,'Retail Sale Id 42',0.00,2025.20,770.00,2348.50,323.30,'2022-12-24 13:38:48'),(45,'1','308',1,'Retail Sale Id 43',0.00,2656.00,770.00,3080.00,424.00,'2022-12-24 13:41:19'),(46,'1','308',1,'Retail Sale Id 44',0.00,3320.00,770.00,3850.00,530.00,'2022-12-24 13:42:45'),(47,'1','308',1,'Retail Sale Id 45',0.00,1334.64,770.00,1547.70,213.06,'2022-12-24 13:52:06'),(48,'1','308',1,'Retail Sale Id 46',0.00,1334.64,770.00,1547.70,213.06,'2022-12-24 13:53:39'),(49,'1','308',1,'Retail Sale Id 47',0.00,1294.80,770.00,1501.50,206.70,'2022-12-24 13:56:52'),(50,'1','308',1,'Retail Sale Id 48',0.00,1992.00,770.00,2310.00,318.00,'2022-12-24 13:58:41'),(51,'1','308',1,'Retail Sale Id 49',0.00,3320.00,770.00,3850.00,530.00,'2022-12-24 14:01:17'),(52,'1','308',1,'Retail Sale Id 50',0.00,2675.92,770.00,3103.10,427.18,'2022-12-24 14:05:24'),(53,'1','308',1,'Retail Sale Id 51',0.00,1992.00,770.00,2310.00,318.00,'2022-12-24 14:15:13'),(54,'1','308',1,'Retail Sale Id 52',0.00,3320.00,770.00,3850.00,530.00,'2022-12-24 14:19:47'),(55,'1','308',1,'Retail Sale Id 53',0.00,1985.36,770.00,2302.30,316.94,'2022-12-24 14:20:59'),(56,'1','308',1,'Retail Sale Id 54',0.00,1812.72,770.00,2102.10,289.38,'2022-12-24 14:23:00'),(57,'1','308',1,'Retail Sale Id 55',0.00,1985.36,770.00,2302.30,316.94,'2022-12-24 14:25:05'),(58,'1','308',1,'Retail Sale Id 56',0.00,1294.80,770.00,1501.50,206.70,'2022-12-24 14:27:31'),(59,'1','308',1,'Retail Sale Id 57',0.00,690.56,770.00,800.80,110.24,'2022-12-24 14:28:24'),(60,'1','308',1,'Retail Sale Id 58',0.00,1294.80,770.00,1501.50,206.70,'2022-12-24 14:35:15'),(61,'1','308',1,'Retail Sale Id 59',0.00,33200.00,710.00,35500.00,2300.00,'2022-12-24 14:38:43'),(62,'1','308',1,'Retail Sale Id 60',0.00,4654.64,770.00,5397.70,743.06,'2022-12-24 14:40:52'),(63,'1','308',1,'Retail Sale Id 61',0.00,4010.56,770.00,4650.80,640.24,'2022-12-24 14:44:37'),(64,'1','308',1,'Retail Sale Id 62',0.00,4050.40,770.00,4697.00,646.60,'2022-12-24 14:46:18'),(65,'1','308',1,'Retail Sale Id 63',0.00,3320.00,770.00,3850.00,530.00,'2022-12-24 14:48:20'),(66,'1','308',1,'Retail Sale Id 64',0.00,1294.80,770.00,1501.50,206.70,'2022-12-24 14:50:17'),(67,'1','308',1,'Retail Sale Id 65',0.00,1899.04,770.00,2202.20,303.16,'2022-12-24 14:52:28'),(68,'1','308',1,'Retail Sale Id 66',0.00,2158.00,770.00,2502.50,344.50,'2022-12-24 15:06:37'),(69,'1','308',1,'Retail Sale Id 67',0.00,1294.80,770.00,1501.50,206.70,'2022-12-24 15:09:10'),(70,'1','308',1,'Retail Sale Id 68',0.00,1294.80,770.00,1501.50,206.70,'2022-12-24 15:10:24'),(71,'1','308',1,'Retail Sale Id 69',0.00,1726.40,770.00,2002.00,275.60,'2022-12-24 15:13:11'),(72,'1','308',1,'Retail Sale Id 70',0.00,1294.80,770.00,1501.50,206.70,'2022-12-24 15:15:05'),(73,'1','308',1,'Retail Sale Id 71',0.00,2589.60,770.00,3003.00,413.40,'2022-12-24 15:17:45'),(74,'1','308',1,'Retail Sale Id 72',0.00,5172.56,770.00,5998.30,825.74,'2022-12-24 15:19:32'),(75,'1','308',1,'Retail Sale Id 73',0.00,1726.40,770.00,2002.00,275.60,'2022-12-24 15:21:34'),(76,'1','308',1,'Retail Sale Id 74',0.00,1328.00,770.00,1540.00,212.00,'2022-12-24 15:36:40'),(77,'1','308',1,'Retail Sale Id 75',0.00,1294.80,770.00,1501.50,206.70,'2022-12-24 15:47:01'),(78,'1','308',1,'Retail Sale Id 76',0.00,690.56,770.00,800.80,110.24,'2022-12-24 15:47:47'),(79,'1','308',1,'Retail Sale Id 77',0.00,690.56,770.00,800.80,110.24,'2022-12-24 15:48:42'),(80,'1','308',1,'Retail Sale Id 78',0.00,1992.00,770.00,2310.00,318.00,'2022-12-24 15:50:13'),(81,'1','308',1,'Retail Sale Id 79',0.00,1294.80,770.00,1501.50,206.70,'2022-12-24 15:52:57'),(82,'1','308',1,'Retail Sale Id 80',0.00,1334.64,770.00,1547.70,213.06,'2022-12-24 15:54:28'),(83,'1','308',1,'Retail Sale Id 81',0.00,3320.00,770.00,3850.00,530.00,'2022-12-24 15:59:06'),(84,'1','308',1,'Retail Sale Id 82',0.00,2025.20,770.00,2348.50,323.30,'2022-12-24 16:18:38'),(85,'1','308',1,'Retail Sale Id 83',0.00,1985.36,770.00,2302.30,316.94,'2022-12-24 16:29:55'),(86,'1','308',1,'Retail Sale Id 84',0.00,4010.56,770.00,4650.80,640.24,'2022-12-24 16:35:17'),(87,'1','308',1,'Retail Sale Id 85',0.00,4654.64,770.00,5397.70,743.06,'2022-12-24 16:38:36'),(88,'1','308',1,'Retail Sale Id 86',0.00,1992.00,770.00,2310.00,318.00,'2022-12-24 17:10:28'),(89,'1','308',1,'Retail Sale Id 87',0.00,2675.92,770.00,3103.10,427.18,'2022-12-24 17:28:56'),(90,'1','308',1,'Retail Sale Id 88',0.00,2675.92,770.00,3103.10,427.18,'2022-12-24 17:30:37'),(91,'1','308',1,'Retail Sale Id 89',0.00,690.56,770.00,800.80,110.24,'2022-12-24 17:38:25'),(92,'1','308',1,'Retail Sale Id 90',0.00,690.56,770.00,800.80,110.24,'2022-12-24 18:06:29'),(93,'1','308',1,'Retail Sale Id 91',0.00,2675.92,770.00,3103.10,427.18,'2022-12-24 18:07:38'),(94,'1','308',1,'Retail Sale Id 92',0.00,1381.12,770.00,1601.60,220.48,'2022-12-24 18:09:02'),(95,'1','308',1,'Retail Sale Id 93',0.00,863.20,770.00,1001.00,137.80,'2022-12-24 18:13:38'),(96,'1','308',1,'Return of Retail Sale Id 59',33200.00,0.00,710.00,-35500.00,-2300.00,'2022-12-24 19:10:12'),(97,'1','308',1,'Retail Sale Id 94',0.00,35192.00,710.00,37630.00,2438.00,'2022-12-24 19:12:05'),(98,'1','308',1,'Retail Sale Id 95',0.00,1992.00,770.00,2310.00,318.00,'2022-12-25 08:21:36'),(99,'1','308',1,'Retail Sale Id 96',0.00,2675.92,770.00,3103.10,427.18,'2022-12-25 08:40:52'),(100,'1','308',1,'Retail Sale Id 97',0.00,4010.56,770.00,4650.80,640.24,'2022-12-25 08:47:01'),(101,'1','308',1,'Retail Sale Id 98',0.00,6640.00,770.00,7700.00,1060.00,'2022-12-25 09:23:40'),(102,'1','308',1,'Retail Sale Id 99',0.00,1328.00,770.00,1540.00,212.00,'2022-12-25 10:30:13'),(103,'1','308',1,'Retail Sale Id 100',0.00,5172.56,770.00,5998.30,825.74,'2022-12-25 11:47:41'),(104,'1','308',1,'Retail Sale Id 101',0.00,1328.00,770.00,1540.00,212.00,'2022-12-25 11:48:49'),(105,'1','308',1,'Retail Sale Id 103',0.00,863.20,770.00,1001.00,137.80,'2022-12-25 11:49:51'),(106,'1','308',1,'Retail Sale Id 104',0.00,1328.00,770.00,1540.00,212.00,'2022-12-25 11:51:11'),(107,'1','308',1,'Retail Sale Id 105',0.00,3320.00,770.00,3850.00,530.00,'2022-12-25 11:51:50'),(108,'1','308',1,'Retail Sale Id 106',0.00,683.92,770.00,793.10,109.18,'2022-12-25 11:54:42'),(109,'1','308',1,'Retail Sale Id 107',0.00,1328.00,770.00,1540.00,212.00,'2022-12-25 11:55:23'),(110,'1','308',1,'Retail Sale Id 108',0.00,3964.08,770.00,4596.90,632.82,'2022-12-25 11:56:16'),(111,'1','308',1,'Retail Sale Id 109',0.00,1328.00,770.00,1540.00,212.00,'2022-12-25 11:56:56'),(112,'1','308',1,'Retail Sale Id 110',0.00,683.92,770.00,793.10,109.18,'2022-12-25 12:30:56'),(113,'1','308',1,'Retail Sale Id 111',0.00,4010.56,770.00,4650.80,640.24,'2022-12-25 12:40:14'),(114,'1','308',1,'Retail Sale Id 112',0.00,4309.36,770.00,4997.30,687.94,'2022-12-25 15:33:43'),(115,'1','308',1,'Retail Sale Id 114',0.00,2025.20,770.00,2348.50,323.30,'2022-12-25 16:24:06'),(116,'1','308',1,'Retail Sale Id 115',0.00,11234.88,770.00,13028.40,1793.52,'2022-12-25 18:14:49'),(117,'1','308',1,'Return of Retail Sale Id 115',11234.88,0.00,770.00,-13028.40,-1793.52,'2022-12-25 18:17:56'),(118,'1','308',1,'Retail Sale Id 116',0.00,9508.48,770.00,11026.40,1517.92,'2022-12-25 18:19:25'),(119,'1','308',1,'Retail Sale Id 117',0.00,1726.40,770.00,2002.00,275.60,'2022-12-25 18:29:25'),(120,'1','308',1,'Return of Retail Sale Id 117',1726.40,0.00,770.00,-2002.00,-275.60,'2022-12-25 18:31:23'),(121,'1','308',1,'Retail Sale Id 118',0.00,4017.20,770.00,4658.50,641.30,'2022-12-26 08:07:34'),(122,'1','308',1,'Retail Sale Id 119',0.00,2629.44,770.00,3049.20,419.76,'2022-12-26 09:40:29'),(123,'1','308',1,'Retail Sale Id 120',0.00,1328.00,770.00,1540.00,212.00,'2022-12-26 10:29:27'),(124,'1','308',1,'Retail Sale Id 121',0.00,1985.36,770.00,2302.30,316.94,'2022-12-26 11:00:25'),(125,'1','308',1,'Retail Sale Id 122',0.00,2715.76,770.00,3149.30,433.54,'2022-12-26 14:28:58'),(126,'1','308',1,'Retail Sale Id 123',0.00,3320.00,770.00,3850.00,530.00,'2022-12-26 16:35:34'),(127,'1','308',1,'Retail Sale Id 127',0.00,3320.00,770.00,3850.00,530.00,'2022-12-26 18:12:22'),(128,'1','308',1,'Retail Sale Id 128',0.00,13944.00,770.00,16170.00,2226.00,'2022-12-26 20:48:51'),(129,'1','308',1,'Retail Sale Id 129',0.00,332.00,770.00,385.00,53.00,'2022-12-26 20:54:26'),(130,'1','308',1,'Retail Sale Id 130',0.00,5318.64,770.00,6167.70,849.06,'2022-12-27 08:34:06'),(131,'1','308',1,'Retail Sale Id 132',0.00,1992.00,770.00,2310.00,318.00,'2022-12-27 09:18:50'),(132,'1','308',1,'Retail Sale Id 133',0.00,863.20,770.00,1001.00,137.80,'2022-12-27 09:41:15'),(133,'1','308',1,'Retail Sale Id 134',0.00,664.00,770.00,770.00,106.00,'2022-12-27 10:24:26'),(134,'1','308',1,'Retail Sale Id 135',0.00,3984.00,770.00,4620.00,636.00,'2022-12-27 11:12:56'),(135,'1','308',1,'Retail Sale Id 136',0.00,33200.00,770.00,38500.00,5300.00,'2022-12-27 13:27:52'),(136,'1','308',1,'Return of Retail Sale Id 136',33200.00,0.00,770.00,-38500.00,-5300.00,'2022-12-27 13:28:37'),(137,'1','308',1,'Retail Sale Id 137',0.00,33200.00,710.00,35500.00,2300.00,'2022-12-27 13:29:27'),(138,'1','308',1,'Retail Sale Id 138',0.00,3984.00,770.00,4620.00,636.00,'2022-12-27 13:33:30'),(139,'1','308',1,'Retail Sale Id 139',0.00,3320.00,770.00,3850.00,530.00,'2022-12-27 13:37:31'),(140,'1','308',1,'Retail Sale Id 140',0.00,3984.00,770.00,4620.00,636.00,'2022-12-27 13:39:39'),(141,'1','308',1,'Retail Sale Id 141',0.00,1328.00,770.00,1540.00,212.00,'2022-12-27 13:41:43'),(142,'1','308',1,'Retail Sale Id 142',0.00,2656.00,770.00,3080.00,424.00,'2022-12-27 17:39:57'),(143,'1','308',1,'Retail Sale Id 143',0.00,8300.00,770.00,9625.00,1325.00,'2022-12-27 17:41:33'),(144,'1','308',1,'Retail Sale Id 145',0.00,2011.92,770.00,2333.10,321.18,'2022-12-27 18:03:41'),(145,'1','308',1,'Retail Sale Id 146',0.00,2656.00,770.00,3080.00,424.00,'2022-12-27 18:07:38'),(146,'1','308',1,'Retail Sale Id 147',0.00,1992.00,770.00,2310.00,318.00,'2022-12-27 18:18:47'),(147,'1','308',1,'Return of Retail Sale Id 133',863.20,0.00,770.00,-1001.00,-137.80,'2022-12-27 19:49:47'),(148,'1','308',1,'Return of Retail Sale Id 138',3984.00,0.00,770.00,-4620.00,-636.00,'2022-12-27 19:55:18'),(149,'1','308',1,'Retail Sale Id 148',0.00,2204.48,770.00,2556.40,351.92,'2022-12-27 19:56:57'),(150,'1','308',1,'Retail Sale Id 149',0.00,664.00,770.00,770.00,106.00,'2022-12-28 08:57:54'),(151,'1','308',1,'Retail Sale Id 150',0.00,2025.20,770.00,2348.50,323.30,'2022-12-28 09:00:52'),(152,'1','308',1,'Retail Sale Id 151',0.00,1334.64,770.00,1547.70,213.06,'2022-12-28 09:02:30'),(153,'1','308',1,'Retail Sale Id 152',0.00,1726.40,770.00,2002.00,275.60,'2022-12-28 09:21:42'),(154,'1','308',1,'Retail Sale Id 153',0.00,1992.00,770.00,2310.00,318.00,'2022-12-28 09:28:46'),(155,'1','308',1,'Retail Sale Id 154',0.00,3984.00,770.00,4620.00,636.00,'2022-12-28 10:17:28'),(156,'1','308',1,'Retail Sale Id 155',0.00,863.20,770.00,1001.00,137.80,'2022-12-28 10:18:21'),(157,'1','308',1,'Retail Sale Id 156',0.00,1992.00,770.00,2310.00,318.00,'2022-12-28 10:19:40'),(158,'1','308',1,'Retail Sale Id 157',0.00,33200.00,710.00,35500.00,2300.00,'2022-12-28 13:43:08'),(159,'1','308',1,'Retail Sale Id 158',0.00,1992.00,770.00,2310.00,318.00,'2022-12-28 13:50:12'),(160,'1','308',1,'Retail Sale Id 159',0.00,690.56,770.00,800.80,110.24,'2022-12-28 13:54:41'),(161,'1','308',1,'Retail Sale Id 160',0.00,690.56,770.00,800.80,110.24,'2022-12-28 13:58:21'),(162,'1','308',1,'Retail Sale Id 161',0.00,132800.00,710.00,142000.00,9200.00,'2022-12-28 14:57:52'),(163,'1','308',1,'Retail Sale Id 162',0.00,863.20,770.00,1001.00,137.80,'2022-12-28 16:48:45'),(164,'1','308',1,'Retail Sale Id 163',0.00,3320.00,770.00,3850.00,530.00,'2022-12-28 16:50:15'),(165,'1','308',1,'Retail Sale Id 164',0.00,1334.64,770.00,1547.70,213.06,'2022-12-28 16:53:57'),(166,'1','308',1,'Retail Sale Id 165',0.00,1992.00,770.00,2310.00,318.00,'2022-12-28 16:55:50'),(167,'1','308',1,'Retail Sale Id 166',0.00,6640.00,770.00,7700.00,1060.00,'2022-12-28 16:57:25'),(168,'1','308',1,'Retail Sale Id 167',0.00,863.20,770.00,1001.00,137.80,'2022-12-28 16:59:00'),(169,'1','308',1,'Retail Sale Id 168',0.00,1328.00,770.00,1540.00,212.00,'2022-12-28 17:06:59'),(170,'1','308',1,'Retail Sale Id 169',0.00,1328.00,770.00,1540.00,212.00,'2022-12-28 17:30:45'),(171,'1','308',1,'Retail Sale Id 170',0.00,2224.40,770.00,2579.50,355.10,'2022-12-28 19:03:50'),(172,'1','308',1,'Retail Sale Id 171',0.00,4010.56,770.00,4650.80,640.24,'2022-12-29 08:24:08'),(173,'1','308',1,'Retail Sale Id 172',0.00,3984.00,770.00,4620.00,636.00,'2022-12-29 10:02:02'),(174,'1','308',1,'Retail Sale Id 173',0.00,2025.20,770.00,2348.50,323.30,'2022-12-29 11:15:18'),(175,'1','308',1,'Retail Sale Id 174',0.00,1726.40,770.00,2002.00,275.60,'2022-12-29 11:30:35'),(176,'1','308',1,'Retail Sale Id 175',0.00,2025.20,770.00,2348.50,323.30,'2022-12-29 13:26:57'),(177,'1','308',1,'Retail Sale Id 176',0.00,863.20,770.00,1001.00,137.80,'2022-12-29 14:13:35'),(178,'1','308',1,'Retail Sale Id 177',0.00,863.20,770.00,1001.00,137.80,'2022-12-29 14:15:31'),(179,'1','308',1,'Retail Sale Id 178',0.00,3313.36,770.00,3842.30,528.94,'2022-12-29 16:52:09'),(180,'1','308',1,'Retail Sale Id 179',0.00,3964.08,770.00,4596.90,632.82,'2022-12-29 16:54:21'),(181,'1','308',1,'Retail Sale Id 180',0.00,690.56,770.00,800.80,110.24,'2022-12-29 17:07:14'),(182,'1','308',1,'Retail Sale Id 181',0.00,3964.08,770.00,4596.90,632.82,'2022-12-29 17:44:05'),(183,'1','308',1,'Retail Sale Id 182',0.00,3320.00,770.00,3850.00,530.00,'2022-12-29 18:07:35'),(184,'1','308',1,'Retail Sale Id 183',0.00,2025.20,770.00,2348.50,323.30,'2022-12-30 09:10:05'),(185,'1','308',1,'Retail Sale Id 184',0.00,4010.56,770.00,4650.80,640.24,'2022-12-30 09:11:27'),(186,'1','308',1,'Retail Sale Id 185',0.00,2025.20,770.00,2348.50,323.30,'2022-12-30 09:31:46'),(187,'1','308',1,'Retail Sale Id 186',0.00,3320.00,770.00,3850.00,530.00,'2022-12-30 09:45:02'),(188,'1','308',1,'Retail Sale Id 187',0.00,863.20,770.00,1001.00,137.80,'2022-12-30 10:18:10'),(189,'1','308',1,'Retail Sale Id 188',0.00,33200.00,710.00,35500.00,2300.00,'2022-12-30 12:23:32'),(190,'1','308',1,'Retail Sale Id 189',0.00,1328.00,770.00,1540.00,212.00,'2022-12-30 12:26:53'),(191,'1','308',1,'Retail Sale Id 190',0.00,1992.00,770.00,2310.00,318.00,'2022-12-30 12:37:07'),(192,'1','308',1,'Retail Sale Id 191',0.00,431.60,770.00,500.50,68.90,'2022-12-30 14:43:09'),(193,'1','308',1,'Retail Sale Id 192',0.00,33200.00,710.00,35500.00,2300.00,'2022-12-30 14:52:11'),(194,'1','308',1,'Retail Sale Id 193',0.00,690.56,770.00,800.80,110.24,'2022-12-30 15:56:12'),(195,'1','308',1,'Retail Sale Id 194',0.00,690.56,770.00,800.80,110.24,'2022-12-30 15:57:43'),(196,'1','308',1,'Retail Sale Id 196',0.00,644.08,770.00,746.90,102.82,'2022-12-30 16:02:24'),(197,'1','308',1,'Retail Sale Id 197',0.00,2675.92,770.00,3103.10,427.18,'2022-12-30 17:02:41'),(198,'1','308',1,'Retail Sale Id 198',0.00,3984.00,770.00,4620.00,636.00,'2022-12-30 17:07:57'),(199,'1','308',1,'Retail Sale Id 200',0.00,1334.64,770.00,1547.70,213.06,'2022-12-30 17:26:29'),(200,'1','308',1,'Return of Retail Sale Id 198',3984.00,0.00,770.00,-4620.00,-636.00,'2022-12-30 18:12:03'),(201,'1','308',1,'Retail Sale Id 201',0.00,1175.28,770.00,1362.90,187.62,'2022-12-30 18:14:02'),(202,'1','308',1,'Retail Sale Id 202',0.00,690.56,770.00,800.80,110.24,'2022-12-31 08:28:32'),(203,'1','308',1,'Retail Sale Id 203',0.00,11600.08,770.00,13451.90,1851.82,'2022-12-31 08:29:52'),(204,'1','308',1,'Retail Sale Id 204',0.00,1334.64,770.00,1547.70,213.06,'2022-12-31 09:06:27'),(205,'1','308',1,'Retail Sale Id 205',0.00,1334.64,770.00,1547.70,213.06,'2022-12-31 09:47:36'),(206,'1','308',1,'Retail Sale Id 206',0.00,1334.64,770.00,1547.70,213.06,'2022-12-31 09:55:22'),(207,'1','308',1,'Retail Sale Id 207',0.00,1334.64,770.00,1547.70,213.06,'2022-12-31 09:57:00'),(208,'1','308',1,'Retail Sale Id 208',0.00,2675.92,770.00,3103.10,427.18,'2022-12-31 10:01:02'),(209,'1','308',1,'Retail Sale Id 209',0.00,3984.00,770.00,4620.00,636.00,'2022-12-31 11:26:58'),(210,'1','308',1,'Retail Sale Id 210',0.00,1334.64,770.00,1547.70,213.06,'2022-12-31 12:11:00'),(211,'1','308',1,'Retail Sale Id 211',0.00,1992.00,770.00,2310.00,318.00,'2022-12-31 12:14:41'),(212,'1','308',1,'Retail Sale Id 212',0.00,690.56,770.00,800.80,110.24,'2022-12-31 12:43:32'),(213,'1','308',1,'Retail Sale Id 213',0.00,1334.64,770.00,1547.70,213.06,'2022-12-31 12:59:08'),(214,'1','308',1,'Retail Sale Id 214',0.00,6640.00,710.00,7100.00,460.00,'2022-12-31 13:56:04'),(215,'1','308',1,'Retail Sale Id 215',0.00,3320.00,770.00,3850.00,530.00,'2022-12-31 14:39:17'),(216,'1','308',1,'Retail Sale Id 216',0.00,5976.00,770.00,6930.00,954.00,'2022-12-31 14:40:39'),(217,'1','308',1,'Retail Sale Id 217',0.00,2675.92,770.00,3103.10,427.18,'2022-12-31 14:48:16'),(218,'1','308',1,'Retail Sale Id 218',0.00,863.20,770.00,1001.00,137.80,'2022-12-31 14:56:12'),(219,'1','308',1,'Retail Sale Id 219',0.00,8300.00,770.00,9625.00,1325.00,'2022-12-31 15:36:03'),(220,'1','308',1,'Retail Sale Id 220',0.00,3446.16,770.00,3996.30,550.14,'2022-12-31 16:05:25'),(221,'1','308',1,'Retail Sale Id 221',0.00,2675.92,770.00,3103.10,427.18,'2022-12-31 16:12:47'),(222,'1','308',1,'Retail Sale Id 222',0.00,3320.00,770.00,3850.00,530.00,'2022-12-31 16:16:25'),(223,'1','308',1,'Retail Sale Id 227',0.00,2656.00,770.00,3080.00,424.00,'2022-12-31 16:25:59'),(224,'1','308',1,'Retail Sale Id 228',0.00,690.56,770.00,800.80,110.24,'2022-12-31 16:43:58'),(225,'1','308',1,'Retail Sale Id 229',0.00,2025.20,770.00,2348.50,323.30,'2022-12-31 17:12:15'),(226,'1','308',1,'Retail Sale Id 230',0.00,3446.16,770.00,3996.30,550.14,'2022-12-31 17:44:53'),(227,'1','308',1,'Retail Sale Id 231',0.00,1122.16,770.00,1301.30,179.14,'2022-12-31 17:47:59'),(228,'1','308',1,'Retail Sale Id 233',0.00,8319.92,770.00,9648.10,1328.18,'2022-12-31 18:04:48'),(229,'1','308',1,'Retail Sale Id 234',0.00,3320.00,770.00,3850.00,530.00,'2022-12-31 18:14:03'),(230,'1','308',1,'Retail Sale Id 235',0.00,8319.92,770.00,9648.10,1328.18,'2022-12-31 18:23:27'),(231,'1','308',1,'Return of Retail Sale Id 231',1122.16,0.00,770.00,-1301.30,-179.14,'2022-12-31 18:36:18'),(232,'1','308',1,'Retail Sale Id 236',0.00,1115.52,770.00,1293.60,178.08,'2022-12-31 18:37:43'),(233,'1','308',1,'Retail Sale Id 237',0.00,690.56,770.00,800.80,110.24,'2023-01-01 09:06:22'),(234,'1','308',1,'Retail Sale Id 238',0.00,3320.00,770.00,3850.00,530.00,'2023-01-01 09:14:05'),(235,'1','308',1,'Retail Sale Id 239',0.00,4309.36,770.00,4997.30,687.94,'2023-01-01 09:43:15'),(236,'1','308',1,'Retail Sale Id 240',0.00,690.56,770.00,800.80,110.24,'2023-01-01 09:44:50'),(237,'1','308',1,'Retail Sale Id 241',0.00,1294.80,770.00,1501.50,206.70,'2023-01-01 09:46:08'),(238,'1','308',1,'Retail Sale Id 242',0.00,8293.36,770.00,9617.30,1323.94,'2023-01-01 09:47:16'),(239,'1','308',1,'Retail Sale Id 243',0.00,5046.40,770.00,5852.00,805.60,'2023-01-01 09:48:54'),(240,'1','308',1,'Retail Sale Id 244',0.00,1334.64,770.00,1547.70,213.06,'2023-01-01 10:05:23'),(241,'1','308',1,'Retail Sale Id 245',0.00,4189.84,770.00,4858.70,668.86,'2023-01-01 10:13:51'),(242,'1','308',1,'Return of Retail Sale Id 243',5046.40,0.00,770.00,-5852.00,-805.60,'2023-01-01 10:15:33'),(243,'1','308',1,'Retail Sale Id 246',0.00,2675.92,770.00,3103.10,427.18,'2023-01-01 10:31:54'),(244,'1','308',1,'Retail Sale Id 247',0.00,1334.64,770.00,1547.70,213.06,'2023-01-01 11:00:45'),(245,'1','308',1,'Retail Sale Id 248',0.00,690.56,770.00,800.80,110.24,'2023-01-01 11:36:57'),(246,'1','308',1,'Retail Sale Id 249',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-01 12:10:45'),(247,'1','308',1,'Retail Sale Id 250',0.00,1334.64,770.00,1547.70,213.06,'2023-01-01 12:17:31'),(248,'1','308',1,'Retail Sale Id 251',0.00,1726.40,770.00,2002.00,275.60,'2023-01-01 12:31:09'),(249,'1','308',1,'Retail Sale Id 252',0.00,3984.00,770.00,4620.00,636.00,'2023-01-01 13:09:49'),(250,'1','308',1,'Retail Sale Id 253',0.00,690.56,770.00,800.80,110.24,'2023-01-01 13:13:30'),(251,'1','308',1,'Retail Sale Id 254',0.00,1334.64,770.00,1547.70,213.06,'2023-01-01 13:38:48'),(252,'1','308',1,'Retail Sale Id 255',0.00,1334.64,770.00,1547.70,213.06,'2023-01-01 13:45:36'),(253,'1','308',1,'Retail Sale Id 256',0.00,1381.12,770.00,1601.60,220.48,'2023-01-01 13:47:05'),(254,'1','308',1,'Retail Sale Id 257',0.00,2025.20,770.00,2348.50,323.30,'2023-01-01 15:46:41'),(255,'1','308',1,'Retail Sale Id 258',0.00,1640.08,770.00,1901.90,261.82,'2023-01-01 15:51:19'),(256,'1','308',1,'Retail Sale Id 259',0.00,863.20,770.00,1001.00,137.80,'2023-01-01 15:53:45'),(257,'1','308',1,'Retail Sale Id 260',0.00,3984.00,770.00,4620.00,636.00,'2023-01-01 16:05:54'),(258,'1','308',1,'Retail Sale Id 261',0.00,1381.12,770.00,1601.60,220.48,'2023-01-01 16:07:53'),(259,'1','308',1,'Retail Sale Id 264',0.00,690.56,770.00,800.80,110.24,'2023-01-01 16:45:23'),(260,'1','308',1,'Retail Sale Id 265',0.00,2025.20,770.00,2348.50,323.30,'2023-01-01 17:06:46'),(261,'1','308',1,'Retail Sale Id 266',0.00,3984.00,770.00,4620.00,636.00,'2023-01-01 17:16:39'),(262,'1','308',1,'Return of Retail Sale Id 260',3984.00,0.00,770.00,-4620.00,-636.00,'2023-01-01 17:36:31'),(263,'1','308',1,'Retail Sale Id 267',0.00,4654.64,770.00,5397.70,743.06,'2023-01-01 17:56:45'),(264,'1','308',1,'Retail Sale Id 268',0.00,2025.20,770.00,2348.50,323.30,'2023-01-01 18:10:20'),(265,'1','308',1,'Retail Sale Id 269',0.00,690.56,770.00,800.80,110.24,'2023-01-02 09:33:50'),(266,'1','308',1,'Retail Sale Id 272',0.00,1334.64,770.00,1547.70,213.06,'2023-01-02 09:45:21'),(267,'1','308',1,'Retail Sale Id 273',0.00,6640.00,770.00,7700.00,1060.00,'2023-01-02 09:49:52'),(268,'1','308',1,'Retail Sale Id 284',0.00,4010.56,770.00,4650.80,640.24,'2023-01-02 10:09:56'),(269,'1','308',1,'Retail Sale Id 285',0.00,9920.16,770.00,11503.80,1583.64,'2023-01-02 10:13:02'),(270,'1','308',1,'Retail Sale Id 286',0.00,4010.56,770.00,4650.80,640.24,'2023-01-02 10:30:05'),(271,'1','308',1,'Retail Sale Id 287',0.00,1334.64,770.00,1547.70,213.06,'2023-01-02 10:41:48'),(272,'1','308',1,'Retail Sale Id 294',0.00,2675.92,770.00,3103.10,427.18,'2023-01-02 10:58:41'),(273,'1','308',1,'Retail Sale Id 298',0.00,3984.00,770.00,4620.00,636.00,'2023-01-02 11:14:32'),(274,'1','308',1,'Retail Sale Id 299',0.00,664.00,770.00,770.00,106.00,'2023-01-02 11:24:20'),(275,'1','308',1,'Retail Sale Id 300',0.00,1334.64,770.00,1547.70,213.06,'2023-01-02 11:50:03'),(276,'1','308',1,'Retail Sale Id 301',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-02 12:02:25'),(277,'1','308',1,'Retail Sale Id 302',0.00,2025.20,770.00,2348.50,323.30,'2023-01-02 12:08:49'),(278,'1','308',1,'Retail Sale Id 303',0.00,690.56,770.00,800.80,110.24,'2023-01-02 12:12:47'),(279,'1','308',1,'Retail Sale Id 304',0.00,1328.00,770.00,1540.00,212.00,'2023-01-02 12:14:47'),(280,'1','308',1,'Retail Sale Id 305',0.00,690.56,770.00,800.80,110.24,'2023-01-02 12:28:00'),(281,'1','308',1,'Retail Sale Id 306',0.00,3984.00,770.00,4620.00,636.00,'2023-01-02 13:57:29'),(282,'1','308',1,'Retail Sale Id 307',0.00,1328.00,770.00,1540.00,212.00,'2023-01-02 13:59:24'),(283,'1','308',1,'Retail Sale Id 308',0.00,1334.64,770.00,1547.70,213.06,'2023-01-02 14:00:59'),(284,'1','308',1,'Retail Sale Id 309',0.00,3320.00,770.00,3850.00,530.00,'2023-01-02 15:28:59'),(285,'1','308',1,'Retail Sale Id 310',0.00,1992.00,770.00,2310.00,318.00,'2023-01-02 15:54:16'),(286,'1','308',1,'Retail Sale Id 311',0.00,1992.00,770.00,2310.00,318.00,'2023-01-02 16:09:28'),(287,'1','308',1,'Retail Sale Id 312',0.00,690.56,770.00,800.80,110.24,'2023-01-02 16:19:34'),(288,'1','308',1,'Retail Sale Id 313',0.00,3984.00,770.00,4620.00,636.00,'2023-01-02 16:22:57'),(289,'1','308',1,'Retail Sale Id 314',0.00,1334.64,770.00,1547.70,213.06,'2023-01-02 16:46:07'),(290,'1','308',1,'Retail Sale Id 315',0.00,3984.00,770.00,4620.00,636.00,'2023-01-02 17:19:06'),(291,'1','308',1,'Retail Sale Id 316',0.00,1334.64,770.00,1547.70,213.06,'2023-01-02 17:22:04'),(292,'1','308',1,'Retail Sale Id 317',0.00,2656.00,770.00,3080.00,424.00,'2023-01-02 17:28:32'),(293,'1','308',1,'Retail Sale Id 318',0.00,3320.00,770.00,3850.00,530.00,'2023-01-02 17:31:37'),(294,'1','308',1,'Retail Sale Id 319',0.00,3984.00,770.00,4620.00,636.00,'2023-01-02 17:37:01'),(295,'1','308',1,'Retail Sale Id 323',0.00,863.20,770.00,1001.00,137.80,'2023-01-02 17:42:41'),(296,'1','308',1,'Retail Sale Id 324',0.00,2656.00,770.00,3080.00,424.00,'2023-01-02 18:20:45'),(297,'1','308',1,'Retail Sale Id 325',0.00,2656.00,770.00,3080.00,424.00,'2023-01-03 08:17:49'),(298,'1','308',1,'Retail Sale Id 326',0.00,7330.56,770.00,8500.80,1170.24,'2023-01-03 08:32:48'),(299,'1','308',1,'Retail Sale Id 327',0.00,3320.00,770.00,3850.00,530.00,'2023-01-03 08:57:01'),(300,'1','308',1,'Retail Sale Id 328',0.00,7675.84,770.00,8901.20,1225.36,'2023-01-03 09:00:37'),(301,'1','308',1,'Retail Sale Id 329',0.00,2589.60,770.00,3003.00,413.40,'2023-01-03 09:17:14'),(302,'1','308',1,'Retail Sale Id 330',0.00,1334.64,770.00,1547.70,213.06,'2023-01-03 09:55:57'),(303,'1','308',1,'Retail Sale Id 331',0.00,2675.92,770.00,3103.10,427.18,'2023-01-03 09:57:23'),(304,'1','308',1,'Retail Sale Id 332',0.00,1334.64,770.00,1547.70,213.06,'2023-01-03 10:04:05'),(305,'1','308',1,'Retail Sale Id 333',0.00,1334.64,770.00,1547.70,213.06,'2023-01-03 10:23:03'),(306,'1','308',1,'Retail Sale Id 334',0.00,1334.64,770.00,1547.70,213.06,'2023-01-03 10:43:19'),(307,'1','308',1,'Retail Sale Id 335',0.00,5345.20,770.00,6198.50,853.30,'2023-01-03 10:49:25'),(308,'1','308',1,'Retail Sale Id 337',0.00,2675.92,770.00,3103.10,427.18,'2023-01-03 10:50:21'),(309,'1','308',1,'Retail Sale Id 338',0.00,4010.56,770.00,4650.80,640.24,'2023-01-03 11:08:26'),(310,'1','308',1,'Retail Sale Id 339',0.00,1328.00,770.00,1540.00,212.00,'2023-01-03 11:13:22'),(311,'1','308',1,'Retail Sale Id 340',0.00,3984.00,770.00,4620.00,636.00,'2023-01-03 11:53:34'),(312,'1','308',1,'Retail Sale Id 341',0.00,3320.00,770.00,3850.00,530.00,'2023-01-03 12:25:25'),(313,'1','308',1,'Retail Sale Id 342',0.00,690.56,770.00,800.80,110.24,'2023-01-03 13:14:42'),(314,'1','308',1,'Retail Sale Id 344',0.00,132800.00,710.00,142000.00,9200.00,'2023-01-03 14:47:05'),(315,'1','308',1,'Retail Sale Id 345',0.00,2025.20,770.00,2348.50,323.30,'2023-01-03 14:52:35'),(316,'1','308',1,'Retail Sale Id 346',0.00,1334.64,770.00,1547.70,213.06,'2023-01-03 15:02:53'),(317,'1','308',1,'Retail Sale Id 347',0.00,690.56,770.00,800.80,110.24,'2023-01-03 15:09:31'),(318,'1','308',1,'Retail Sale Id 349',0.00,1992.00,770.00,2310.00,318.00,'2023-01-03 15:16:22'),(319,'1','308',1,'Retail Sale Id 350',0.00,2675.92,770.00,3103.10,427.18,'2023-01-03 16:23:22'),(320,'1','308',1,'Retail Sale Id 351',0.00,5312.00,770.00,6160.00,848.00,'2023-01-03 16:32:44'),(321,'1','308',1,'Retail Sale Id 352',0.00,3984.00,770.00,4620.00,636.00,'2023-01-03 16:48:24'),(322,'1','308',1,'Retail Sale Id 353',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-03 17:20:40'),(323,'1','308',1,'Retail Sale Id 354',0.00,1294.80,770.00,1501.50,206.70,'2023-01-03 17:25:50'),(324,'1','308',1,'Retail Sale Id 355',0.00,1985.36,770.00,2302.30,316.94,'2023-01-03 17:32:43'),(325,'1','308',1,'Retail Sale Id 356',0.00,1985.36,770.00,2302.30,316.94,'2023-01-03 18:08:25'),(326,'1','308',1,'Retail Sale Id 357',0.00,33.20,770.00,38.50,5.30,'2023-01-03 18:31:57'),(327,'1','308',1,'Retail Sale Id 358',0.00,5995.92,770.00,6953.10,957.18,'2023-01-04 09:32:39'),(328,'1','308',1,'Retail Sale Id 359',0.00,7304.00,770.00,8470.00,1166.00,'2023-01-04 09:37:57'),(329,'1','308',1,'Retail Sale Id 361',0.00,1328.00,770.00,1540.00,212.00,'2023-01-04 09:58:57'),(330,'1','308',1,'Retail Sale Id 362',0.00,3984.00,770.00,4620.00,636.00,'2023-01-04 10:15:18'),(331,'1','308',1,'Retail Sale Id 363',0.00,1992.00,770.00,2310.00,318.00,'2023-01-04 11:08:14'),(332,'1','308',1,'Retail Sale Id 364',0.00,2656.00,770.00,3080.00,424.00,'2023-01-04 11:12:05'),(333,'1','308',1,'Retail Sale Id 365',0.00,1328.00,770.00,1540.00,212.00,'2023-01-04 11:19:56'),(334,'1','308',1,'Retail Sale Id 366',0.00,863.20,770.00,1001.00,137.80,'2023-01-04 13:03:53'),(335,'1','308',1,'Retail Sale Id 367',0.00,1294.80,770.00,1501.50,206.70,'2023-01-04 13:17:49'),(336,'1','308',1,'Retail Sale Id 370',0.00,3984.00,770.00,4620.00,636.00,'2023-01-04 13:53:53'),(337,'1','308',1,'Retail Sale Id 372',0.00,1328.00,770.00,1540.00,212.00,'2023-01-04 14:16:26'),(338,'1','308',1,'Retail Sale Id 374',0.00,1726.40,770.00,2002.00,275.60,'2023-01-04 14:49:33'),(339,'1','308',1,'Retail Sale Id 375',0.00,1328.00,770.00,1540.00,212.00,'2023-01-04 15:23:23'),(340,'1','308',1,'Retail Sale Id 376',0.00,690.56,770.00,800.80,110.24,'2023-01-04 15:35:18'),(341,'1','308',1,'Retail Sale Id 378',0.00,8300.00,770.00,9625.00,1325.00,'2023-01-04 15:46:53'),(342,'1','308',1,'Retail Sale Id 379',0.00,1992.00,770.00,2310.00,318.00,'2023-01-04 16:05:05'),(343,'1','308',1,'Retail Sale Id 382',0.00,1328.00,770.00,1540.00,212.00,'2023-01-04 16:57:00'),(344,'1','308',1,'Retail Sale Id 383',0.00,1992.00,770.00,2310.00,318.00,'2023-01-04 17:14:37'),(345,'1','308',1,'Retail Sale Id 385',0.00,8300.00,770.00,9625.00,1325.00,'2023-01-04 17:17:24'),(346,'1','308',1,'Retail Sale Id 386',0.00,2656.00,770.00,3080.00,424.00,'2023-01-04 17:33:59'),(347,'1','308',1,'Retail Sale Id 387',0.00,1328.00,770.00,1540.00,212.00,'2023-01-04 17:40:12'),(348,'1','308',1,'Retail Sale Id 388',0.00,39.84,770.00,46.20,6.36,'2023-01-04 19:05:28'),(349,'1','308',1,'Retail Sale Id 389',0.00,7330.56,770.00,8500.80,1170.24,'2023-01-05 07:59:38'),(350,'1','308',1,'Retail Sale Id 390',0.00,3320.00,770.00,3850.00,530.00,'2023-01-05 08:08:21'),(351,'1','308',1,'Retail Sale Id 391',0.00,1992.00,770.00,2310.00,318.00,'2023-01-05 08:15:11'),(352,'1','308',1,'Retail Sale Id 392',0.00,690.56,770.00,800.80,110.24,'2023-01-05 08:35:55'),(353,'1','308',1,'Retail Sale Id 393',0.00,4010.56,770.00,4650.80,640.24,'2023-01-05 08:47:33'),(354,'1','308',1,'Retail Sale Id 394',0.00,3984.00,770.00,4620.00,636.00,'2023-01-05 09:13:33'),(355,'1','308',1,'Retail Sale Id 395',0.00,2656.00,770.00,3080.00,424.00,'2023-01-05 09:19:06'),(356,'1','308',1,'Retail Sale Id 396',0.00,1992.00,770.00,2310.00,318.00,'2023-01-05 09:23:40'),(357,'1','308',1,'Retail Sale Id 397',0.00,3984.00,770.00,4620.00,636.00,'2023-01-05 09:26:03'),(358,'1','308',1,'Retail Sale Id 398',0.00,1998.64,770.00,2317.70,319.06,'2023-01-05 09:34:02'),(359,'1','308',1,'Retail Sale Id 399',0.00,1334.64,770.00,1547.70,213.06,'2023-01-05 09:43:55'),(360,'1','308',1,'Retail Sale Id 400',0.00,1334.64,770.00,1547.70,213.06,'2023-01-05 09:57:50'),(361,'1','308',1,'Retail Sale Id 401',0.00,690.56,770.00,800.80,110.24,'2023-01-05 10:04:09'),(362,'1','308',1,'Retail Sale Id 402',0.00,690.56,770.00,800.80,110.24,'2023-01-05 10:23:22'),(363,'1','308',1,'Retail Sale Id 403',0.00,2675.92,770.00,3103.10,427.18,'2023-01-05 10:32:06'),(364,'1','308',1,'Retail Sale Id 404',0.00,690.56,770.00,800.80,110.24,'2023-01-05 11:00:12'),(365,'1','308',1,'Retail Sale Id 405',0.00,3320.00,770.00,3850.00,530.00,'2023-01-05 11:04:12'),(366,'1','308',1,'Retail Sale Id 406',0.00,1985.36,770.00,2302.30,316.94,'2023-01-05 11:06:56'),(367,'1','308',1,'Retail Sale Id 407',0.00,44820.00,710.00,47925.00,3105.00,'2023-01-05 11:46:27'),(368,'1','308',1,'Retail Sale Id 408',0.00,2682.56,770.00,3110.80,428.24,'2023-01-05 12:29:42'),(369,'1','308',1,'Retail Sale Id 409',0.00,664.00,770.00,770.00,106.00,'2023-01-05 12:30:42'),(370,'1','308',1,'Retail Sale Id 410',0.00,3320.00,770.00,3850.00,530.00,'2023-01-05 12:32:31'),(371,'1','308',1,'Retail Sale Id 411',0.00,1553.76,770.00,1801.80,248.04,'2023-01-05 12:43:19'),(372,'1','308',1,'Retail Sale Id 412',0.00,4010.56,770.00,4650.80,640.24,'2023-01-05 13:15:26'),(373,'1','308',1,'Retail Sale Id 413',0.00,2656.00,770.00,3080.00,424.00,'2023-01-05 13:57:09'),(374,'1','308',1,'Retail Sale Id 414',0.00,3320.00,770.00,3850.00,530.00,'2023-01-05 14:38:03'),(375,'1','308',1,'Retail Sale Id 415',0.00,690.56,770.00,800.80,110.24,'2023-01-05 16:24:47'),(376,'1','308',1,'Retail Sale Id 416',0.00,664.00,770.00,770.00,106.00,'2023-01-05 16:39:37'),(377,'1','308',1,'Retail Sale Id 416',0.00,664.00,770.00,770.00,106.00,'2023-01-05 16:39:37'),(378,'1','308',1,'Retail Sale Id 417',0.00,3984.00,770.00,4620.00,636.00,'2023-01-05 16:41:04'),(379,'1','308',1,'Retail Sale Id 418',0.00,664.00,770.00,770.00,106.00,'2023-01-05 16:47:57'),(380,'1','308',1,'Retail Sale Id 419',0.00,1294.80,770.00,1501.50,206.70,'2023-01-05 17:04:52'),(381,'1','308',1,'Retail Sale Id 420',0.00,3320.00,770.00,3850.00,530.00,'2023-01-05 17:11:44'),(382,'1','308',1,'Retail Sale Id 421',0.00,8300.00,770.00,9625.00,1325.00,'2023-01-05 17:25:06'),(383,'1','308',1,'Retail Sale Id 422',0.00,4189.84,770.00,4858.70,668.86,'2023-01-05 17:33:34'),(384,'1','308',1,'Retail Sale Id 423',0.00,3984.00,770.00,4620.00,636.00,'2023-01-05 17:51:04'),(385,'1','308',1,'Retail Sale Id 424',0.00,1328.00,770.00,1540.00,212.00,'2023-01-05 18:04:00'),(386,'1','308',1,'Retail Sale Id 425',0.00,1998.64,770.00,2317.70,319.06,'2023-01-05 18:08:28'),(387,'1','308',1,'Retail Sale Id 426',0.00,1334.64,770.00,1547.70,213.06,'2023-01-05 18:23:02'),(388,'1','308',1,'Retail Sale Id 427',0.00,690.56,770.00,800.80,110.24,'2023-01-05 18:24:13'),(389,'1','308',1,'Retail Sale Id 428',0.00,6.64,770.00,7.70,1.06,'2023-01-05 19:35:59'),(390,'1','308',1,'Retail Sale Id 429',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-06 08:52:00'),(391,'1','308',1,'Retail Sale Id 430',0.00,3320.00,770.00,3850.00,530.00,'2023-01-06 08:56:57'),(392,'1','308',1,'Retail Sale Id 431',0.00,12616.00,770.00,14630.00,2014.00,'2023-01-06 09:02:17'),(393,'1','308',1,'Retail Sale Id 432',0.00,1334.64,770.00,1547.70,213.06,'2023-01-06 09:32:31'),(394,'1','308',1,'Retail Sale Id 433',0.00,8300.00,770.00,9625.00,1325.00,'2023-01-06 09:46:47'),(395,'1','308',1,'Retail Sale Id 434',0.00,1992.00,770.00,2310.00,318.00,'2023-01-06 09:53:19'),(396,'1','308',1,'Retail Sale Id 436',0.00,3320.00,770.00,3850.00,530.00,'2023-01-06 10:31:24'),(397,'1','308',1,'Retail Sale Id 437',0.00,3320.00,770.00,3850.00,530.00,'2023-01-06 11:01:19'),(398,'1','308',1,'Retail Sale Id 438',0.00,6640.00,770.00,7700.00,1060.00,'2023-01-06 11:14:57'),(399,'1','308',1,'Retail Sale Id 439',0.00,1334.64,770.00,1547.70,213.06,'2023-01-06 11:22:51'),(400,'1','308',1,'Retail Sale Id 440',0.00,4010.56,770.00,4650.80,640.24,'2023-01-06 11:40:10'),(401,'1','308',1,'Retail Sale Id 441',0.00,1334.64,770.00,1547.70,213.06,'2023-01-06 11:46:17'),(402,'1','308',1,'Retail Sale Id 442',0.00,3320.00,770.00,3850.00,530.00,'2023-01-06 12:41:56'),(403,'1','308',1,'Retail Sale Id 443',0.00,2656.00,770.00,3080.00,424.00,'2023-01-06 13:10:03'),(404,'1','308',1,'Retail Sale Id 444',0.00,5312.00,770.00,6160.00,848.00,'2023-01-06 13:12:16'),(405,'1','308',1,'Retail Sale Id 445',0.00,1992.00,770.00,2310.00,318.00,'2023-01-06 13:44:03'),(406,'1','308',1,'Retail Sale Id 447',0.00,2656.00,770.00,3080.00,424.00,'2023-01-06 14:56:45'),(407,'1','308',1,'Retail Sale Id 448',0.00,1294.80,770.00,1501.50,206.70,'2023-01-06 14:59:48'),(408,'1','308',1,'Retail Sale Id 449',0.00,431.60,770.00,500.50,68.90,'2023-01-06 15:28:09'),(409,'1','308',1,'Retail Sale Id 450',0.00,690.56,770.00,800.80,110.24,'2023-01-06 16:05:36'),(410,'1','308',1,'Retail Sale Id 451',0.00,1334.64,770.00,1547.70,213.06,'2023-01-06 16:27:38'),(411,'1','308',1,'Retail Sale Id 452',0.00,690.56,770.00,800.80,110.24,'2023-01-06 16:39:54'),(412,'1','308',1,'Retail Sale Id 454',0.00,1334.64,770.00,1547.70,213.06,'2023-01-06 16:48:05'),(413,'1','308',1,'Retail Sale Id 455',0.00,4010.56,770.00,4650.80,640.24,'2023-01-06 17:04:02'),(414,'1','308',1,'Retail Sale Id 456',0.00,2675.92,770.00,3103.10,427.18,'2023-01-06 17:05:22'),(415,'1','308',1,'Retail Sale Id 457',0.00,6640.00,770.00,7700.00,1060.00,'2023-01-06 17:20:57'),(416,'1','308',1,'Retail Sale Id 458',0.00,1334.64,770.00,1547.70,213.06,'2023-01-06 17:25:18'),(417,'1','308',1,'Retail Sale Id 459',0.00,2675.92,770.00,3103.10,427.18,'2023-01-06 17:34:33'),(418,'1','308',1,'Retail Sale Id 460',0.00,431.60,770.00,500.50,68.90,'2023-01-06 17:51:06'),(419,'1','308',1,'Retail Sale Id 461',0.00,7974.64,770.00,9247.70,1273.06,'2023-01-06 18:02:32'),(420,'1','308',1,'Retail Sale Id 462',0.00,3320.00,770.00,3850.00,530.00,'2023-01-06 18:16:00'),(421,'1','308',1,'Return of Retail Sale Id 444',5312.00,0.00,770.00,-6160.00,-848.00,'2023-01-06 18:29:13'),(422,'1','308',1,'Retail Sale Id 463',0.00,1972.08,770.00,2286.90,314.82,'2023-01-06 18:29:52'),(423,'1','308',1,'Return of Retail Sale Id 463',1972.08,0.00,770.00,-2286.90,-314.82,'2023-01-06 19:32:40'),(424,'1','308',1,'Retail Sale Id 464',0.00,1666.64,770.00,1932.70,266.06,'2023-01-06 19:33:45'),(425,'1','308',1,'Retail Sale Id 465',0.00,6640.00,770.00,7700.00,1060.00,'2023-01-07 08:04:35'),(426,'1','308',1,'Retail Sale Id 466',0.00,3446.16,770.00,3996.30,550.14,'2023-01-07 08:05:12'),(427,'1','308',1,'Retail Sale Id 467',0.00,3984.00,770.00,4620.00,636.00,'2023-01-07 08:35:01'),(428,'1','308',1,'Retail Sale Id 468',0.00,1985.36,770.00,2302.30,316.94,'2023-01-07 08:40:47'),(429,'1','308',1,'Retail Sale Id 469',0.00,2675.92,770.00,3103.10,427.18,'2023-01-07 08:46:18'),(430,'1','308',1,'Retail Sale Id 470',0.00,5995.92,770.00,6953.10,957.18,'2023-01-07 08:53:07'),(431,'1','308',1,'Retail Sale Id 471',0.00,3984.00,770.00,4620.00,636.00,'2023-01-07 08:58:41'),(432,'1','308',1,'Retail Sale Id 472',0.00,3984.00,770.00,4620.00,636.00,'2023-01-07 09:09:56'),(433,'1','308',1,'Retail Sale Id 473',0.00,3320.00,770.00,3850.00,530.00,'2023-01-07 10:24:34'),(434,'1','308',1,'Retail Sale Id 474',0.00,1294.80,770.00,1501.50,206.70,'2023-01-07 10:42:34'),(435,'1','308',1,'Retail Sale Id 475',0.00,36520.00,710.00,39050.00,2530.00,'2023-01-07 11:05:49'),(436,'1','308',1,'Retail Sale Id 476',0.00,3984.00,770.00,4620.00,636.00,'2023-01-07 11:21:52'),(437,'1','308',1,'Retail Sale Id 477',0.00,3984.00,770.00,4620.00,636.00,'2023-01-07 11:24:12'),(438,'1','308',1,'Retail Sale Id 478',0.00,3990.64,770.00,4627.70,637.06,'2023-01-07 11:29:11'),(439,'1','308',1,'Retail Sale Id 479',0.00,1992.00,770.00,2310.00,318.00,'2023-01-07 11:50:13'),(440,'1','308',1,'Retail Sale Id 480',0.00,664.00,770.00,770.00,106.00,'2023-01-07 12:10:21'),(441,'1','308',1,'Retail Sale Id 481',0.00,1328.00,770.00,1540.00,212.00,'2023-01-07 12:33:07'),(442,'1','308',1,'Retail Sale Id 482',0.00,1726.40,770.00,2002.00,275.60,'2023-01-07 12:33:59'),(443,'1','308',1,'Retail Sale Id 483',0.00,664.00,770.00,770.00,106.00,'2023-01-07 12:46:42'),(444,'1','308',1,'Retail Sale Id 484',0.00,1328.00,770.00,1540.00,212.00,'2023-01-07 13:22:53'),(445,'1','308',1,'Retail Sale Id 485',0.00,2675.92,770.00,3103.10,427.18,'2023-01-07 13:44:57'),(446,'1','308',1,'Retail Sale Id 486',0.00,3984.00,770.00,4620.00,636.00,'2023-01-07 13:46:41'),(447,'1','308',1,'Retail Sale Id 487',0.00,1328.00,770.00,1540.00,212.00,'2023-01-07 14:34:25'),(448,'1','308',1,'Retail Sale Id 488',0.00,690.56,770.00,800.80,110.24,'2023-01-07 15:33:48'),(449,'1','308',1,'Retail Sale Id 489',0.00,9999.84,770.00,11596.20,1596.36,'2023-01-07 15:39:17'),(450,'1','308',1,'Retail Sale Id 490',0.00,1985.36,770.00,2302.30,316.94,'2023-01-07 15:52:46'),(451,'1','308',1,'Retail Sale Id 491',0.00,690.56,770.00,800.80,110.24,'2023-01-07 15:53:43'),(452,'1','308',1,'Retail Sale Id 492',0.00,2675.92,770.00,3103.10,427.18,'2023-01-07 15:54:50'),(453,'1','308',1,'Retail Sale Id 493',0.00,1985.36,770.00,2302.30,316.94,'2023-01-07 15:56:22'),(454,'1','308',1,'Retail Sale Id 494',0.00,1992.00,770.00,2310.00,318.00,'2023-01-07 16:11:36'),(455,'1','308',1,'Retail Sale Id 495',0.00,690.56,770.00,800.80,110.24,'2023-01-07 16:26:27'),(456,'1','308',1,'Retail Sale Id 496',0.00,1985.36,770.00,2302.30,316.94,'2023-01-07 17:16:03'),(457,'1','308',1,'Retail Sale Id 497',0.00,863.20,770.00,1001.00,137.80,'2023-01-07 17:30:08'),(458,'1','308',1,'Retail Sale Id 498',0.00,1985.36,770.00,2302.30,316.94,'2023-01-07 17:47:41'),(459,'1','308',1,'Retail Sale Id 499',0.00,690.56,770.00,800.80,110.24,'2023-01-07 17:48:35'),(460,'1','308',1,'Retail Sale Id 500',0.00,664.00,770.00,770.00,106.00,'2023-01-07 17:52:35'),(461,'1','308',1,'Retail Sale Id 501',0.00,3446.16,770.00,3996.30,550.14,'2023-01-07 17:58:35'),(462,'1','308',1,'Retail Sale Id 502',0.00,2025.20,770.00,2348.50,323.30,'2023-01-07 18:02:03'),(463,'1','308',1,'Retail Sale Id 503',0.00,1334.64,770.00,1547.70,213.06,'2023-01-07 18:17:49'),(464,'1','308',1,'Retail Sale Id 504',0.00,13.28,770.00,15.40,2.12,'2023-01-07 19:17:04'),(465,'1','308',1,'Retail Sale Id 505',0.00,1334.64,770.00,1547.70,213.06,'2023-01-08 08:32:12'),(466,'1','308',1,'Retail Sale Id 506',0.00,1328.00,770.00,1540.00,212.00,'2023-01-08 08:33:35'),(467,'1','308',1,'Retail Sale Id 507',0.00,2675.92,770.00,3103.10,427.18,'2023-01-08 08:35:31'),(468,'1','308',1,'Retail Sale Id 508',0.00,3320.00,770.00,3850.00,530.00,'2023-01-08 09:24:34'),(469,'1','308',1,'Retail Sale Id 509',0.00,1992.00,770.00,2310.00,318.00,'2023-01-08 09:30:08'),(470,'1','308',1,'Retail Sale Id 511',0.00,690.56,770.00,800.80,110.24,'2023-01-08 09:40:38'),(471,'1','308',1,'Retail Sale Id 512',0.00,1294.80,770.00,1501.50,206.70,'2023-01-08 09:43:46'),(472,'1','308',1,'Retail Sale Id 513',0.00,7968.00,770.00,9240.00,1272.00,'2023-01-08 10:01:31'),(473,'1','308',1,'Retail Sale Id 514',0.00,1992.00,770.00,2310.00,318.00,'2023-01-08 10:04:53'),(474,'1','308',1,'Retail Sale Id 517',0.00,8300.00,770.00,9625.00,1325.00,'2023-01-08 10:13:26'),(475,'1','308',1,'Retail Sale Id 518',0.00,1726.40,770.00,2002.00,275.60,'2023-01-08 10:15:35'),(476,'1','308',1,'Retail Sale Id 520',0.00,1334.64,770.00,1547.70,213.06,'2023-01-08 10:17:27'),(477,'1','308',1,'Retail Sale Id 521',0.00,1992.00,770.00,2310.00,318.00,'2023-01-08 10:20:25'),(478,'1','308',1,'Retail Sale Id 523',0.00,1334.64,770.00,1547.70,213.06,'2023-01-08 10:38:38'),(479,'1','308',1,'Retail Sale Id 524',0.00,664.00,770.00,770.00,106.00,'2023-01-08 10:43:05'),(480,'1','308',1,'Retail Sale Id 525',0.00,1334.64,770.00,1547.70,213.06,'2023-01-08 10:44:33'),(481,'1','308',1,'Retail Sale Id 526',0.00,664.00,770.00,770.00,106.00,'2023-01-08 10:56:08'),(482,'1','308',1,'Retail Sale Id 527',0.00,2656.00,770.00,3080.00,424.00,'2023-01-08 11:09:36'),(483,'1','308',1,'Retail Sale Id 528',0.00,1992.00,770.00,2310.00,318.00,'2023-01-08 11:13:13'),(484,'1','308',1,'Retail Sale Id 529',0.00,1660.00,770.00,1925.00,265.00,'2023-01-08 11:28:46'),(485,'1','308',1,'Retail Sale Id 530',0.00,863.20,770.00,1001.00,137.80,'2023-01-08 11:35:34'),(486,'1','308',1,'Retail Sale Id 531',0.00,1992.00,770.00,2310.00,318.00,'2023-01-08 11:39:36'),(487,'1','308',1,'Retail Sale Id 532',0.00,8300.00,770.00,9625.00,1325.00,'2023-01-08 11:48:02'),(488,'1','308',1,'Retail Sale Id 533',0.00,604.24,770.00,700.70,96.46,'2023-01-08 12:06:04'),(489,'1','308',1,'Retail Sale Id 534',0.00,3984.00,770.00,4620.00,636.00,'2023-01-08 12:09:18'),(490,'1','308',1,'Retail Sale Id 535',0.00,1992.00,770.00,2310.00,318.00,'2023-01-08 12:24:24'),(491,'1','308',1,'Retail Sale Id 536',0.00,8300.00,770.00,9625.00,1325.00,'2023-01-08 12:39:56'),(492,'1','308',1,'Retail Sale Id 537',0.00,3446.16,770.00,3996.30,550.14,'2023-01-08 13:13:46'),(493,'1','308',1,'Retail Sale Id 540',0.00,1992.00,770.00,2310.00,318.00,'2023-01-08 13:39:14'),(494,'1','308',1,'Retail Sale Id 542',0.00,3984.00,770.00,4620.00,636.00,'2023-01-08 13:42:35'),(495,'1','308',1,'Retail Sale Id 543',0.00,3984.00,770.00,4620.00,636.00,'2023-01-08 13:48:20'),(496,'1','308',1,'Return of Retail Sale Id 540',1992.00,0.00,770.00,-2310.00,-318.00,'2023-01-08 13:54:11'),(497,'1','308',1,'Retail Sale Id 544',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-08 13:56:55'),(498,'1','308',1,'Retail Sale Id 545',0.00,2656.00,770.00,3080.00,424.00,'2023-01-08 13:59:52'),(499,'1','308',1,'Retail Sale Id 546',0.00,3320.00,770.00,3850.00,530.00,'2023-01-08 14:04:22'),(500,'1','308',1,'Retail Sale Id 547',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-08 14:09:24'),(501,'1','308',1,'Retail Sale Id 548',0.00,1992.00,770.00,2310.00,318.00,'2023-01-08 14:18:15'),(502,'1','308',1,'Retail Sale Id 550',0.00,8300.00,770.00,9625.00,1325.00,'2023-01-08 14:26:06'),(503,'1','308',1,'Retail Sale Id 551',0.00,1992.00,770.00,2310.00,318.00,'2023-01-08 14:42:08'),(504,'1','308',1,'Retail Sale Id 552',0.00,1992.00,770.00,2310.00,318.00,'2023-01-08 14:54:32'),(505,'1','308',1,'Retail Sale Id 553',0.00,1992.00,770.00,2310.00,318.00,'2023-01-08 14:55:38'),(506,'1','308',1,'Retail Sale Id 555',0.00,1334.64,770.00,1547.70,213.06,'2023-01-08 15:31:12'),(507,'1','308',1,'Retail Sale Id 556',0.00,664.00,770.00,770.00,106.00,'2023-01-08 16:03:13'),(508,'1','308',1,'Retail Sale Id 557',0.00,83000.00,770.00,96250.00,13250.00,'2023-01-08 16:09:02'),(509,'1','308',1,'Retail Sale Id 558',0.00,8300.00,770.00,9625.00,1325.00,'2023-01-08 16:12:00'),(510,'1','308',1,'Retail Sale Id 559',0.00,3320.00,770.00,3850.00,530.00,'2023-01-08 16:56:04'),(511,'1','308',1,'Retail Sale Id 560',0.00,2662.64,770.00,3087.70,425.06,'2023-01-08 17:06:31'),(512,'1','308',1,'Retail Sale Id 561',0.00,3320.00,770.00,3850.00,530.00,'2023-01-08 17:12:37'),(513,'1','308',1,'Return of Retail Sale Id 557',83000.00,0.00,770.00,-96250.00,-13250.00,'2023-01-08 17:17:55'),(514,'1','308',1,'Retail Sale Id 562',0.00,3320.00,770.00,3850.00,530.00,'2023-01-08 17:19:24'),(515,'1','308',1,'Retail Sale Id 563',0.00,1992.00,770.00,2310.00,318.00,'2023-01-08 17:23:51'),(516,'1','308',1,'Retail Sale Id 564',0.00,1992.00,770.00,2310.00,318.00,'2023-01-08 17:45:40'),(517,'1','308',1,'Retail Sale Id 565',0.00,690.56,770.00,800.80,110.24,'2023-01-08 17:58:41'),(518,'1','308',1,'Retail Sale Id 566',0.00,4754.24,770.00,5513.20,758.96,'2023-01-08 19:12:32'),(519,'1','308',1,'Retail Sale Id 567',0.00,690.56,770.00,800.80,110.24,'2023-01-09 08:02:21'),(520,'1','308',1,'Retail Sale Id 568',0.00,690.56,770.00,800.80,110.24,'2023-01-09 08:13:01'),(521,'1','308',1,'Retail Sale Id 569',0.00,4010.56,770.00,4650.80,640.24,'2023-01-09 08:14:12'),(522,'1','308',1,'Retail Sale Id 570',0.00,1992.00,770.00,2310.00,318.00,'2023-01-09 08:24:17'),(523,'1','308',1,'Retail Sale Id 571',0.00,1334.64,770.00,1547.70,213.06,'2023-01-09 08:25:48'),(524,'1','308',1,'Retail Sale Id 572',0.00,3320.00,770.00,3850.00,530.00,'2023-01-09 08:27:03'),(525,'1','308',1,'Retail Sale Id 573',0.00,1334.64,770.00,1547.70,213.06,'2023-01-09 08:40:38'),(526,'1','308',1,'Retail Sale Id 574',0.00,3984.00,770.00,4620.00,636.00,'2023-01-09 09:02:15'),(527,'1','308',1,'Retail Sale Id 575',0.00,14395.52,770.00,16693.60,2298.08,'2023-01-09 09:04:23'),(528,'1','308',1,'Retail Sale Id 576',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-09 09:08:04'),(529,'1','308',1,'Retail Sale Id 577',0.00,1992.00,770.00,2310.00,318.00,'2023-01-09 09:42:22'),(530,'1','308',1,'Retail Sale Id 578',0.00,1726.40,770.00,2002.00,275.60,'2023-01-09 09:47:48'),(531,'1','308',1,'Retail Sale Id 579',0.00,1819.36,770.00,2109.80,290.44,'2023-01-09 09:48:52'),(532,'1','308',1,'Retail Sale Id 580',0.00,690.56,770.00,800.80,110.24,'2023-01-09 10:37:04'),(533,'1','308',1,'Retail Sale Id 581',0.00,2025.20,770.00,2348.50,323.30,'2023-01-09 10:52:47'),(534,'1','308',1,'Retail Sale Id 582',0.00,1992.00,770.00,2310.00,318.00,'2023-01-09 11:48:27'),(535,'1','308',1,'Retail Sale Id 583',0.00,3984.00,770.00,4620.00,636.00,'2023-01-09 11:49:44'),(536,'1','308',1,'Retail Sale Id 584',0.00,1992.00,770.00,2310.00,318.00,'2023-01-09 11:52:16'),(537,'1','308',1,'Retail Sale Id 585',0.00,1334.64,770.00,1547.70,213.06,'2023-01-09 11:56:52'),(538,'1','308',1,'Retail Sale Id 586',0.00,1985.36,770.00,2302.30,316.94,'2023-01-09 11:58:16'),(539,'1','308',1,'Retail Sale Id 587',0.00,3984.00,770.00,4620.00,636.00,'2023-01-09 12:24:38'),(540,'1','308',1,'Retail Sale Id 588',0.00,690.56,770.00,800.80,110.24,'2023-01-09 12:31:34'),(541,'1','308',1,'Retail Sale Id 589',0.00,7974.64,770.00,9247.70,1273.06,'2023-01-09 12:57:39'),(542,'1','308',1,'Retail Sale Id 590',0.00,3964.08,770.00,4596.90,632.82,'2023-01-09 13:18:22'),(543,'1','308',1,'Retail Sale Id 591',0.00,1992.00,770.00,2310.00,318.00,'2023-01-09 14:18:29'),(544,'1','308',1,'Retail Sale Id 592',0.00,3320.00,770.00,3850.00,530.00,'2023-01-09 14:23:13'),(545,'1','308',1,'Retail Sale Id 593',0.00,3984.00,770.00,4620.00,636.00,'2023-01-09 14:49:34'),(546,'1','308',1,'Retail Sale Id 594',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-09 14:50:59'),(547,'1','308',1,'Retail Sale Id 595',0.00,1334.64,770.00,1547.70,213.06,'2023-01-09 14:51:53'),(548,'1','308',1,'Retail Sale Id 596',0.00,2675.92,770.00,3103.10,427.18,'2023-01-09 14:53:16'),(549,'1','308',1,'Retail Sale Id 597',0.00,1985.36,770.00,2302.30,316.94,'2023-01-09 15:01:23'),(550,'1','308',1,'Retail Sale Id 598',0.00,1328.00,770.00,1540.00,212.00,'2023-01-09 16:00:30'),(551,'1','308',1,'Retail Sale Id 599',0.00,1334.64,770.00,1547.70,213.06,'2023-01-09 16:13:35'),(552,'1','308',1,'Retail Sale Id 600',0.00,690.56,770.00,800.80,110.24,'2023-01-09 16:14:59'),(553,'1','308',1,'Retail Sale Id 601',0.00,2855.20,770.00,3311.00,455.80,'2023-01-09 16:17:20'),(554,'1','308',1,'Retail Sale Id 602',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-09 16:18:46'),(555,'1','308',1,'Retail Sale Id 603',0.00,7968.00,770.00,9240.00,1272.00,'2023-01-09 16:24:07'),(556,'1','308',1,'Retail Sale Id 604',0.00,6640.00,770.00,7700.00,1060.00,'2023-01-09 17:08:30'),(557,'1','308',1,'Retail Sale Id 605',0.00,1328.00,770.00,1540.00,212.00,'2023-01-09 17:16:17'),(558,'1','308',1,'Retail Sale Id 606',0.00,2656.00,770.00,3080.00,424.00,'2023-01-09 17:23:10'),(559,'1','308',1,'Retail Sale Id 607',0.00,8632.00,770.00,10010.00,1378.00,'2023-01-09 17:23:52'),(560,'1','308',1,'Retail Sale Id 608',0.00,1992.00,770.00,2310.00,318.00,'2023-01-09 17:26:04'),(561,'1','308',1,'Retail Sale Id 609',0.00,1328.00,770.00,1540.00,212.00,'2023-01-09 17:34:45'),(562,'1','308',1,'Retail Sale Id 610',0.00,2656.00,770.00,3080.00,424.00,'2023-01-09 17:39:09'),(563,'1','308',1,'Retail Sale Id 611',0.00,3984.00,770.00,4620.00,636.00,'2023-01-09 17:41:10'),(564,'1','308',1,'Retail Sale Id 612',0.00,3320.00,770.00,3850.00,530.00,'2023-01-09 17:44:37'),(565,'1','308',1,'Retail Sale Id 613',0.00,2656.00,770.00,3080.00,424.00,'2023-01-09 17:46:17'),(566,'1','308',1,'Retail Sale Id 614',0.00,1992.00,770.00,2310.00,318.00,'2023-01-09 17:51:53'),(567,'1','308',1,'Retail Sale Id 615',0.00,1992.00,770.00,2310.00,318.00,'2023-01-09 17:53:31'),(568,'1','308',1,'Retail Sale Id 616',0.00,1294.80,770.00,1501.50,206.70,'2023-01-09 18:03:11'),(569,'1','308',1,'Retail Sale Id 617',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-09 18:10:29'),(570,'1','308',1,'Retail Sale Id 618',0.00,690.56,770.00,800.80,110.24,'2023-01-09 18:16:51'),(571,'1','308',1,'Retail Sale Id 620',0.00,2158.00,770.00,2502.50,344.50,'2023-01-09 18:19:39'),(572,'1','308',1,'Retail Sale Id 621',0.00,1328.00,770.00,1540.00,212.00,'2023-01-09 18:20:36'),(573,'1','308',1,'Retail Sale Id 622',0.00,1294.80,770.00,1501.50,206.70,'2023-01-09 18:28:18'),(574,'1','308',1,'Retail Sale Id 623',0.00,59.76,770.00,69.30,9.54,'2023-01-09 18:47:11'),(575,'1','308',1,'Retail Sale Id 624',0.00,5976.00,770.00,6930.00,954.00,'2023-01-10 07:27:18'),(576,'1','308',1,'Retail Sale Id 625',0.00,1294.80,770.00,1501.50,206.70,'2023-01-10 07:31:53'),(577,'1','308',1,'Retail Sale Id 626',0.00,1992.00,770.00,2310.00,318.00,'2023-01-10 08:13:36'),(578,'1','308',1,'Retail Sale Id 627',0.00,9933.44,770.00,11519.20,1585.76,'2023-01-10 08:22:51'),(579,'1','308',1,'Retail Sale Id 628',0.00,3320.00,770.00,3850.00,530.00,'2023-01-10 08:41:35'),(580,'1','308',1,'Retail Sale Id 629',0.00,3320.00,770.00,3850.00,530.00,'2023-01-10 08:43:04'),(581,'1','308',1,'Retail Sale Id 630',0.00,690.56,770.00,800.80,110.24,'2023-01-10 08:59:23'),(582,'1','308',1,'Retail Sale Id 631',0.00,29880.00,710.00,31950.00,2070.00,'2023-01-10 09:05:13'),(583,'1','308',1,'Retail Sale Id 632',0.00,1992.00,770.00,2310.00,318.00,'2023-01-10 10:49:07'),(584,'1','308',1,'Retail Sale Id 633',0.00,3320.00,770.00,3850.00,530.00,'2023-01-10 11:17:31'),(585,'1','308',1,'Retail Sale Id 634',0.00,8300.00,770.00,9625.00,1325.00,'2023-01-10 12:28:18'),(586,'1','308',1,'Retail Sale Id 635',0.00,3984.00,770.00,4620.00,636.00,'2023-01-10 12:31:12'),(587,'1','308',1,'Retail Sale Id 636',0.00,3984.00,770.00,4620.00,636.00,'2023-01-10 12:33:34'),(588,'1','308',1,'Retail Sale Id 637',0.00,2656.00,770.00,3080.00,424.00,'2023-01-10 13:20:18'),(589,'1','308',1,'Retail Sale Id 638',0.00,3984.00,770.00,4620.00,636.00,'2023-01-10 13:23:14'),(590,'1','308',1,'Retail Sale Id 639',0.00,664.00,770.00,770.00,106.00,'2023-01-10 13:36:32'),(591,'1','308',1,'Retail Sale Id 640',0.00,1328.00,770.00,1540.00,212.00,'2023-01-10 15:37:37'),(592,'1','308',1,'Retail Sale Id 641',0.00,1328.00,770.00,1540.00,212.00,'2023-01-10 15:51:50'),(593,'1','308',1,'Retail Sale Id 642',0.00,1328.00,770.00,1540.00,212.00,'2023-01-10 16:14:15'),(594,'1','308',1,'Retail Sale Id 643',0.00,2656.00,770.00,3080.00,424.00,'2023-01-10 16:30:25'),(595,'1','308',1,'Retail Sale Id 644',0.00,41500.00,710.00,44375.00,2875.00,'2023-01-10 16:37:37'),(596,'1','308',1,'Retail Sale Id 646',0.00,5976.00,770.00,6930.00,954.00,'2023-01-10 16:47:38'),(597,'1','308',1,'Retail Sale Id 647',0.00,2589.60,770.00,3003.00,413.40,'2023-01-10 17:10:57'),(598,'1','308',1,'Retail Sale Id 648',0.00,4010.56,770.00,4650.80,640.24,'2023-01-10 17:31:30'),(599,'1','308',1,'Retail Sale Id 649',0.00,6640.00,770.00,7700.00,1060.00,'2023-01-10 17:33:41'),(600,'1','308',1,'Retail Sale Id 650',0.00,3984.00,770.00,4620.00,636.00,'2023-01-10 17:37:26'),(601,'1','308',1,'Retail Sale Id 653',0.00,1334.64,770.00,1547.70,213.06,'2023-01-10 17:48:36'),(602,'1','308',1,'Retail Sale Id 654',0.00,3984.00,770.00,4620.00,636.00,'2023-01-10 17:53:49'),(603,'1','308',1,'Retail Sale Id 655',0.00,431.60,770.00,500.50,68.90,'2023-01-10 17:59:16'),(604,'1','308',1,'Retail Sale Id 656',0.00,664.00,770.00,770.00,106.00,'2023-01-10 18:19:45'),(605,'1','308',1,'Retail Sale Id 657',0.00,690.56,770.00,800.80,110.24,'2023-01-10 18:22:01'),(606,'1','308',1,'Retail Sale Id 658',0.00,690.56,770.00,800.80,110.24,'2023-01-10 18:24:21'),(607,'1','308',1,'Retail Sale Id 659',0.00,690.56,770.00,800.80,110.24,'2023-01-10 18:32:13'),(608,'1','308',1,'Retail Sale Id 660',0.00,1992.00,770.00,2310.00,318.00,'2023-01-10 18:34:53'),(609,'1','308',1,'Retail Sale Id 661',0.00,66.40,770.00,77.00,10.60,'2023-01-10 19:38:56'),(610,'1','308',1,'Retail Sale Id 662',0.00,2675.92,770.00,3103.10,427.18,'2023-01-11 07:23:14'),(611,'1','308',1,'Retail Sale Id 663',0.00,1354.56,770.00,1570.80,216.24,'2023-01-11 07:26:42'),(612,'1','308',1,'Retail Sale Id 664',0.00,1992.00,770.00,2310.00,318.00,'2023-01-11 07:31:10'),(613,'1','308',1,'Retail Sale Id 665',0.00,1334.64,770.00,1547.70,213.06,'2023-01-11 07:53:47'),(614,'1','308',1,'Retail Sale Id 666',0.00,4654.64,770.00,5397.70,743.06,'2023-01-11 07:55:18'),(615,'1','308',1,'Retail Sale Id 667',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-11 08:36:02'),(616,'1','308',1,'Retail Sale Id 668',0.00,1992.00,770.00,2310.00,318.00,'2023-01-11 08:44:49'),(617,'1','308',1,'Retail Sale Id 669',0.00,1334.64,770.00,1547.70,213.06,'2023-01-11 08:54:07'),(618,'1','308',1,'Retail Sale Id 670',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-11 08:55:18'),(619,'1','308',1,'Retail Sale Id 671',0.00,1328.00,770.00,1540.00,212.00,'2023-01-11 09:11:24'),(620,'1','308',1,'Retail Sale Id 673',0.00,132800.00,710.00,142000.00,9200.00,'2023-01-11 09:52:56'),(621,'1','308',1,'Retail Sale Id 674',0.00,9960.00,710.00,10650.00,690.00,'2023-01-11 10:04:39'),(622,'1','308',1,'Retail Sale Id 675',0.00,2656.00,760.00,3040.00,384.00,'2023-01-11 10:19:38'),(623,'1','308',1,'Retail Sale Id 676',0.00,6640.00,760.00,7600.00,960.00,'2023-01-11 10:36:15'),(624,'1','308',1,'Retail Sale Id 677',0.00,1328.00,760.00,1520.00,192.00,'2023-01-11 10:37:26'),(625,'1','308',1,'Retail Sale Id 678',0.00,1328.00,760.00,1520.00,192.00,'2023-01-11 11:07:01'),(626,'1','308',1,'Retail Sale Id 679',0.00,664.00,760.00,760.00,96.00,'2023-01-11 11:19:28'),(627,'1','308',1,'Retail Sale Id 680',0.00,1660.00,760.00,1900.00,240.00,'2023-01-11 11:22:46'),(628,'1','308',1,'Retail Sale Id 681',0.00,3320.00,760.00,3800.00,480.00,'2023-01-11 11:40:22'),(629,'1','308',1,'Retail Sale Id 682',0.00,664.00,760.00,760.00,96.00,'2023-01-11 11:55:40'),(630,'1','308',1,'Retail Sale Id 683',0.00,7968.00,760.00,9120.00,1152.00,'2023-01-11 12:38:57'),(631,'1','308',1,'Retail Sale Id 684',0.00,876.48,760.00,1003.20,126.72,'2023-01-11 12:53:03'),(632,'1','308',1,'Retail Sale Id 685',0.00,876.48,760.00,1003.20,126.72,'2023-01-11 12:53:44'),(633,'1','308',1,'Retail Sale Id 686',0.00,3984.00,760.00,4560.00,576.00,'2023-01-11 14:35:03'),(634,'1','308',1,'Retail Sale Id 687',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-11 14:50:11'),(635,'1','308',1,'Retail Sale Id 688',0.00,1992.00,760.00,2280.00,288.00,'2023-01-11 14:57:32'),(636,'1','308',1,'Retail Sale Id 689',0.00,1002.64,760.00,1147.60,144.96,'2023-01-11 15:14:14'),(637,'1','308',1,'Retail Sale Id 690',0.00,2656.00,760.00,3040.00,384.00,'2023-01-11 15:26:44'),(638,'1','308',1,'Retail Sale Id 691',0.00,2656.00,760.00,3040.00,384.00,'2023-01-11 15:48:44'),(639,'1','308',1,'Retail Sale Id 692',0.00,1992.00,760.00,2280.00,288.00,'2023-01-11 16:13:41'),(640,'1','308',1,'Retail Sale Id 693',0.00,3320.00,760.00,3800.00,480.00,'2023-01-11 16:14:37'),(641,'1','308',1,'Retail Sale Id 694',0.00,3930.88,760.00,4499.20,568.32,'2023-01-11 16:20:54'),(642,'1','308',1,'Retail Sale Id 695',0.00,697.20,760.00,798.00,100.80,'2023-01-11 16:22:11'),(643,'1','308',1,'Retail Sale Id 696',0.00,1328.00,760.00,1520.00,192.00,'2023-01-11 16:23:33'),(644,'1','308',1,'Retail Sale Id 697',0.00,1992.00,760.00,2280.00,288.00,'2023-01-11 16:48:57'),(645,'1','308',1,'Retail Sale Id 698',0.00,664.00,760.00,760.00,96.00,'2023-01-11 16:53:20'),(646,'1','308',1,'Retail Sale Id 699',0.00,1992.00,760.00,2280.00,288.00,'2023-01-11 17:04:11'),(647,'1','308',1,'Retail Sale Id 700',0.00,3320.00,760.00,3800.00,480.00,'2023-01-11 17:22:59'),(648,'1','308',1,'Retail Sale Id 701',0.00,1992.00,760.00,2280.00,288.00,'2023-01-11 17:28:20'),(649,'1','308',1,'Retail Sale Id 702',0.00,664.00,760.00,760.00,96.00,'2023-01-11 17:29:36'),(650,'1','308',1,'Retail Sale Id 703',0.00,29880.00,710.00,31950.00,2070.00,'2023-01-11 17:31:38'),(651,'1','308',1,'Retail Sale Id 704',0.00,1328.00,760.00,1520.00,192.00,'2023-01-11 17:34:23'),(652,'1','308',1,'Retail Sale Id 705',0.00,664.00,760.00,760.00,96.00,'2023-01-11 17:43:43'),(653,'1','308',1,'Retail Sale Id 706',0.00,664.00,760.00,760.00,96.00,'2023-01-11 17:44:42'),(654,'1','308',1,'Retail Sale Id 707',0.00,3984.00,760.00,4560.00,576.00,'2023-01-11 17:55:15'),(655,'1','308',1,'Retail Sale Id 708',0.00,3320.00,760.00,3800.00,480.00,'2023-01-11 18:14:55'),(656,'1','308',1,'Retail Sale Id 709',0.00,876.48,760.00,1003.20,126.72,'2023-01-11 18:17:56'),(657,'1','308',1,'Retail Sale Id 711',0.00,7968.00,760.00,9120.00,1152.00,'2023-01-11 18:21:12'),(658,'1','308',1,'Retail Sale Id 712',0.00,3984.00,760.00,4560.00,576.00,'2023-01-11 18:23:30'),(659,'1','308',1,'Retail Sale Id 713',0.00,6.64,760.00,7.60,0.96,'2023-01-11 19:06:19'),(660,'1','308',1,'Retail Sale Id 714',0.00,1328.00,770.00,1540.00,212.00,'2023-01-12 07:20:00'),(661,'1','308',1,'Retail Sale Id 715',0.00,783.52,760.00,896.80,113.28,'2023-01-12 07:22:59'),(662,'1','308',1,'Retail Sale Id 716',0.00,3320.00,760.00,3800.00,480.00,'2023-01-12 07:34:28'),(663,'1','308',1,'Retail Sale Id 717',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-12 07:43:41'),(664,'1','308',1,'Retail Sale Id 718',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-12 07:48:54'),(665,'1','308',1,'Retail Sale Id 719',0.00,664.00,760.00,760.00,96.00,'2023-01-12 07:56:35'),(666,'1','308',1,'Retail Sale Id 720',0.00,39840.00,710.00,42600.00,2760.00,'2023-01-12 08:10:12'),(667,'1','308',1,'Retail Sale Id 721',0.00,3320.00,760.00,3800.00,480.00,'2023-01-12 08:11:31'),(668,'1','308',1,'Retail Sale Id 722',0.00,16268.00,710.00,17395.00,1127.00,'2023-01-12 08:18:35'),(669,'1','308',1,'Retail Sale Id 723',0.00,1992.00,760.00,2280.00,288.00,'2023-01-12 08:33:06'),(670,'1','308',1,'Retail Sale Id 724',0.00,4648.00,760.00,5320.00,672.00,'2023-01-12 09:01:02'),(671,'1','308',1,'Retail Sale Id 725',0.00,3984.00,760.00,4560.00,576.00,'2023-01-12 09:24:52'),(672,'1','308',1,'Retail Sale Id 726',0.00,2656.00,760.00,3040.00,384.00,'2023-01-12 09:53:07'),(673,'1','308',1,'Retail Sale Id 727',0.00,1328.00,760.00,1520.00,192.00,'2023-01-12 09:59:49'),(674,'1','308',1,'Retail Sale Id 728',0.00,3320.00,760.00,3800.00,480.00,'2023-01-12 10:26:35'),(675,'1','308',1,'Retail Sale Id 729',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-12 10:29:17'),(676,'1','308',1,'Retail Sale Id 730',0.00,3320.00,760.00,3800.00,480.00,'2023-01-12 10:31:03'),(677,'1','308',1,'Retail Sale Id 731',0.00,1328.00,760.00,1520.00,192.00,'2023-01-12 10:36:48'),(678,'1','308',1,'Retail Sale Id 732',0.00,3984.00,760.00,4560.00,576.00,'2023-01-12 10:59:29'),(679,'1','308',1,'Retail Sale Id 733',0.00,1328.00,760.00,1520.00,192.00,'2023-01-12 11:18:32'),(680,'1','308',1,'Retail Sale Id 734',0.00,664.00,760.00,760.00,96.00,'2023-01-12 11:24:11'),(681,'1','308',1,'Retail Sale Id 735',0.00,1328.00,760.00,1520.00,192.00,'2023-01-12 11:38:26'),(682,'1','308',1,'Retail Sale Id 736',0.00,3320.00,760.00,3800.00,480.00,'2023-01-12 12:26:51'),(683,'1','308',1,'Retail Sale Id 737',0.00,3984.00,760.00,4560.00,576.00,'2023-01-12 12:34:47'),(684,'1','308',1,'Retail Sale Id 738',0.00,3984.00,760.00,4560.00,576.00,'2023-01-12 12:42:18'),(685,'1','308',1,'Retail Sale Id 739',0.00,3984.00,760.00,4560.00,576.00,'2023-01-12 12:54:40'),(686,'1','308',1,'Retail Sale Id 740',0.00,3320.00,760.00,3800.00,480.00,'2023-01-12 13:03:39'),(687,'1','308',1,'Retail Sale Id 741',0.00,1328.00,760.00,1520.00,192.00,'2023-01-12 14:01:41'),(688,'1','308',1,'Retail Sale Id 742',0.00,2656.00,760.00,3040.00,384.00,'2023-01-12 14:02:56'),(689,'1','308',1,'Retail Sale Id 743',0.00,1992.00,760.00,2280.00,288.00,'2023-01-12 14:20:17'),(690,'1','308',1,'Retail Sale Id 744',0.00,7968.00,760.00,9120.00,1152.00,'2023-01-12 14:26:37'),(691,'1','308',1,'Retail Sale Id 745',0.00,2656.00,760.00,3040.00,384.00,'2023-01-12 14:48:48'),(692,'1','308',1,'Retail Sale Id 746',0.00,1992.00,760.00,2280.00,288.00,'2023-01-12 14:49:47'),(693,'1','308',1,'Retail Sale Id 747',0.00,697.20,760.00,798.00,100.80,'2023-01-12 14:53:51'),(694,'1','308',1,'Retail Sale Id 749',0.00,1328.00,760.00,1520.00,192.00,'2023-01-12 14:56:41'),(695,'1','308',1,'Retail Sale Id 753',0.00,1328.00,760.00,1520.00,192.00,'2023-01-12 15:14:28'),(696,'1','308',1,'Retail Sale Id 754',0.00,3320.00,760.00,3800.00,480.00,'2023-01-12 15:15:16'),(697,'1','308',1,'Retail Sale Id 755',0.00,4648.00,760.00,5320.00,672.00,'2023-01-12 15:16:48'),(698,'1','308',1,'Retail Sale Id 756',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-12 15:18:44'),(699,'1','308',1,'Retail Sale Id 757',0.00,1992.00,760.00,2280.00,288.00,'2023-01-12 15:25:31'),(700,'1','308',1,'Retail Sale Id 758',0.00,6640.00,760.00,7600.00,960.00,'2023-01-12 15:27:56'),(701,'1','308',1,'Retail Sale Id 759',0.00,876.48,760.00,1003.20,126.72,'2023-01-12 15:44:23'),(702,'1','308',1,'Retail Sale Id 760',0.00,1328.00,760.00,1520.00,192.00,'2023-01-12 15:51:17'),(703,'1','308',1,'Retail Sale Id 761',0.00,3984.00,760.00,4560.00,576.00,'2023-01-12 15:56:01'),(704,'1','308',1,'Retail Sale Id 762',0.00,3984.00,760.00,4560.00,576.00,'2023-01-12 16:09:36'),(705,'1','308',1,'Retail Sale Id 763',0.00,1328.00,760.00,1520.00,192.00,'2023-01-12 16:12:50'),(706,'1','308',1,'Retail Sale Id 764',0.00,1328.00,760.00,1520.00,192.00,'2023-01-12 16:19:12'),(707,'1','308',1,'Retail Sale Id 765',0.00,3320.00,760.00,3800.00,480.00,'2023-01-12 16:23:06'),(708,'1','308',1,'Retail Sale Id 766',0.00,2622.80,760.00,3002.00,379.20,'2023-01-12 16:37:43'),(709,'1','308',1,'Retail Sale Id 767',0.00,1328.00,760.00,1520.00,192.00,'2023-01-12 16:40:59'),(710,'1','308',1,'Retail Sale Id 768',0.00,1328.00,760.00,1520.00,192.00,'2023-01-12 16:43:44'),(711,'1','308',1,'Retail Sale Id 769',0.00,7968.00,760.00,9120.00,1152.00,'2023-01-12 16:46:52'),(712,'1','308',1,'Retail Sale Id 770',0.00,3984.00,760.00,4560.00,576.00,'2023-01-12 16:49:07'),(713,'1','308',1,'Retail Sale Id 771',0.00,2622.80,760.00,3002.00,379.20,'2023-01-12 17:00:11'),(714,'1','308',1,'Retail Sale Id 772',0.00,1992.00,760.00,2280.00,288.00,'2023-01-12 17:03:52'),(715,'1','308',1,'Retail Sale Id 773',0.00,2656.00,760.00,3040.00,384.00,'2023-01-12 17:05:53'),(716,'1','308',1,'Retail Sale Id 774',0.00,4369.12,760.00,5000.80,631.68,'2023-01-12 17:30:47'),(717,'1','308',1,'Return of Retail Sale Id 771',2622.80,0.00,760.00,-3002.00,-379.20,'2023-01-12 18:00:56'),(718,'1','308',1,'Retail Sale Id 775',0.00,2656.00,760.00,3040.00,384.00,'2023-01-12 18:09:40'),(719,'1','308',1,'Retail Sale Id 776',0.00,1992.00,760.00,2280.00,288.00,'2023-01-12 18:35:18'),(720,'1','308',1,'Return of Retail Sale Id 722',16268.00,0.00,710.00,-17395.00,-1127.00,'2023-01-12 20:00:41'),(721,'1','308',1,'Retail Sale Id 777',0.00,16281.28,710.00,17409.20,1127.92,'2023-01-12 20:03:18'),(722,'1','308',1,'Retail Sale Id 778',0.00,4282.80,760.00,4902.00,619.20,'2023-01-13 07:48:56'),(723,'1','308',1,'Retail Sale Id 779',0.00,2011.92,760.00,2302.80,290.88,'2023-01-13 07:49:55'),(724,'1','308',1,'Retail Sale Id 781',0.00,2011.92,760.00,2302.80,290.88,'2023-01-13 08:01:12'),(725,'1','308',1,'Retail Sale Id 782',0.00,7968.00,760.00,9120.00,1152.00,'2023-01-13 08:16:31'),(726,'1','308',1,'Retail Sale Id 780',0.00,1992.00,760.00,2280.00,288.00,'2023-01-13 08:16:56'),(727,'1','308',1,'Retail Sale Id 784',0.00,1308.08,760.00,1497.20,189.12,'2023-01-13 08:43:59'),(728,'1','308',1,'Retail Sale Id 785',0.00,664.00,760.00,760.00,96.00,'2023-01-13 08:47:01'),(729,'1','308',1,'Retail Sale Id 786',0.00,3984.00,760.00,4560.00,576.00,'2023-01-13 08:52:47'),(730,'1','308',1,'Retail Sale Id 788',0.00,1334.64,760.00,1527.60,192.96,'2023-01-13 09:03:37'),(731,'1','308',1,'Retail Sale Id 789',0.00,2662.64,760.00,3047.60,384.96,'2023-01-13 09:09:54'),(732,'1','308',1,'Retail Sale Id 790',0.00,1308.08,760.00,1497.20,189.12,'2023-01-13 09:13:40'),(733,'1','308',1,'Retail Sale Id 791',0.00,3320.00,760.00,3800.00,480.00,'2023-01-13 10:40:17'),(734,'1','308',1,'Retail Sale Id 792',0.00,1308.08,760.00,1497.20,189.12,'2023-01-13 10:46:28'),(735,'1','308',1,'Retail Sale Id 793',0.00,3320.00,760.00,3800.00,480.00,'2023-01-13 10:54:17'),(736,'1','308',1,'Retail Sale Id 794',0.00,2011.92,760.00,2302.80,290.88,'2023-01-13 11:00:25'),(737,'1','308',1,'Retail Sale Id 795',0.00,2011.92,760.00,2302.80,290.88,'2023-01-13 11:53:20'),(738,'1','308',1,'Retail Sale Id 796',0.00,3984.00,760.00,4560.00,576.00,'2023-01-13 12:00:25'),(739,'1','308',1,'Retail Sale Id 798',0.00,3977.36,760.00,4552.40,575.04,'2023-01-13 12:21:29'),(740,'1','308',1,'Retail Sale Id 799',0.00,664.00,760.00,760.00,96.00,'2023-01-13 12:25:02'),(741,'1','308',1,'Retail Sale Id 800',0.00,2011.92,760.00,2302.80,290.88,'2023-01-13 12:52:00'),(742,'1','308',1,'Retail Sale Id 801',0.00,2622.80,760.00,3002.00,379.20,'2023-01-13 12:53:05'),(743,'1','308',1,'Retail Sale Id 802',0.00,1308.08,760.00,1497.20,189.12,'2023-01-13 13:13:01'),(744,'1','308',1,'Retail Sale Id 803',0.00,697.20,760.00,798.00,100.80,'2023-01-13 13:39:46'),(745,'1','308',1,'Retail Sale Id 804',0.00,6640.00,760.00,7600.00,960.00,'2023-01-13 13:41:21'),(746,'1','308',1,'Retail Sale Id 805',0.00,1308.08,760.00,1497.20,189.12,'2023-01-13 14:43:04'),(747,'1','308',1,'Retail Sale Id 806',0.00,697.20,760.00,798.00,100.80,'2023-01-13 14:50:14'),(748,'1','308',1,'Retail Sale Id 807',0.00,27224.00,710.00,29110.00,1886.00,'2023-01-13 15:05:19'),(749,'1','308',1,'Retail Sale Id 808',0.00,1308.08,760.00,1497.20,189.12,'2023-01-13 15:06:23'),(750,'1','308',1,'Retail Sale Id 809',0.00,3984.00,760.00,4560.00,576.00,'2023-01-13 15:08:51'),(751,'1','308',1,'Retail Sale Id 810',0.00,1992.00,760.00,2280.00,288.00,'2023-01-13 15:41:22'),(752,'1','308',1,'Retail Sale Id 811',0.00,1746.32,760.00,1998.80,252.48,'2023-01-13 16:22:00'),(753,'1','308',1,'Retail Sale Id 812',0.00,2011.92,760.00,2302.80,290.88,'2023-01-13 16:35:47'),(754,'1','308',1,'Retail Sale Id 813',0.00,697.20,760.00,798.00,100.80,'2023-01-13 16:37:19'),(755,'1','308',1,'Retail Sale Id 814',0.00,664.00,760.00,760.00,96.00,'2023-01-13 16:39:35'),(756,'1','308',1,'Retail Sale Id 815',0.00,1354.56,760.00,1550.40,195.84,'2023-01-13 17:25:09'),(757,'1','308',1,'Retail Sale Id 816',0.00,29216.00,710.00,31240.00,2024.00,'2023-01-13 17:28:50'),(758,'1','308',1,'Retail Sale Id 817',0.00,664.00,760.00,760.00,96.00,'2023-01-13 17:58:20'),(759,'1','308',1,'Retail Sale Id 818',0.00,1328.00,760.00,1520.00,192.00,'2023-01-13 17:59:51'),(760,'1','308',1,'Retail Sale Id 819',0.00,2011.92,760.00,2302.80,290.88,'2023-01-13 18:01:59'),(761,'1','308',1,'Retail Sale Id 820',0.00,3977.36,760.00,4552.40,575.04,'2023-01-13 18:05:27'),(762,'1','308',1,'Retail Sale Id 821',0.00,1354.56,760.00,1550.40,195.84,'2023-01-13 18:13:34'),(763,'1','308',1,'Retail Sale Id 822',0.00,3977.36,760.00,4552.40,575.04,'2023-01-13 18:16:41'),(764,'1','308',1,'Retail Sale Id 823',0.00,438.24,760.00,501.60,63.36,'2023-01-13 18:17:33'),(765,'1','308',1,'Retail Sale Id 824',0.00,2622.80,760.00,3002.00,379.20,'2023-01-13 18:26:45'),(766,'1','308',1,'Retail Sale Id 825',0.00,365.20,760.00,418.00,52.80,'2023-01-13 18:39:57'),(767,'1','308',1,'Retail Sale Id 826',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-14 07:13:34'),(768,'1','308',1,'Retail Sale Id 827',0.00,1992.00,760.00,2280.00,288.00,'2023-01-14 07:14:31'),(769,'1','308',1,'Retail Sale Id 828',0.00,17602.64,760.00,20147.60,2544.96,'2023-01-14 07:15:31'),(770,'1','308',1,'Retail Sale Id 829',0.00,3984.00,760.00,4560.00,576.00,'2023-01-14 07:21:33'),(771,'1','308',1,'Retail Sale Id 830',0.00,697.20,760.00,798.00,100.80,'2023-01-14 07:28:37'),(772,'1','308',1,'Retail Sale Id 833',0.00,697.20,760.00,798.00,100.80,'2023-01-14 07:59:25'),(773,'1','308',1,'Retail Sale Id 834',0.00,3320.00,760.00,3800.00,480.00,'2023-01-14 08:01:24'),(774,'1','308',1,'Retail Sale Id 835',0.00,3320.00,760.00,3800.00,480.00,'2023-01-14 08:10:51'),(775,'1','308',1,'Retail Sale Id 836',0.00,1328.00,760.00,1520.00,192.00,'2023-01-14 08:15:57'),(776,'1','308',1,'Retail Sale Id 837',0.00,3984.00,760.00,4560.00,576.00,'2023-01-14 08:18:04'),(777,'1','308',1,'Retail Sale Id 838',0.00,6640.00,760.00,7600.00,960.00,'2023-01-14 08:46:57'),(778,'1','308',1,'Retail Sale Id 839',0.00,3320.00,760.00,3800.00,480.00,'2023-01-14 08:48:15'),(779,'1','308',1,'Retail Sale Id 840',0.00,7968.00,760.00,9120.00,1152.00,'2023-01-14 08:49:36'),(780,'1','308',1,'Retail Sale Id 841',0.00,6640.00,760.00,7600.00,960.00,'2023-01-14 08:54:46'),(781,'1','308',1,'Retail Sale Id 842',0.00,1328.00,760.00,1520.00,192.00,'2023-01-14 09:04:13'),(782,'1','308',1,'Retail Sale Id 843',0.00,1992.00,760.00,2280.00,288.00,'2023-01-14 09:20:54'),(783,'1','308',1,'Retail Sale Id 844',0.00,1328.00,760.00,1520.00,192.00,'2023-01-14 09:50:42'),(784,'1','308',1,'Retail Sale Id 845',0.00,1328.00,760.00,1520.00,192.00,'2023-01-14 10:12:21'),(785,'1','308',1,'Retail Sale Id 846',0.00,1308.08,760.00,1497.20,189.12,'2023-01-14 10:53:01'),(786,'1','308',1,'Retail Sale Id 847',0.00,7304.00,760.00,8360.00,1056.00,'2023-01-14 11:08:46'),(787,'1','308',1,'Retail Sale Id 848',0.00,3930.88,760.00,4499.20,568.32,'2023-01-14 11:11:36'),(788,'1','308',1,'Retail Sale Id 849',0.00,1328.00,760.00,1520.00,192.00,'2023-01-14 11:13:16'),(789,'1','308',1,'Retail Sale Id 850',0.00,1308.08,760.00,1497.20,189.12,'2023-01-14 12:07:50'),(790,'1','308',1,'Retail Sale Id 851',0.00,2656.00,760.00,3040.00,384.00,'2023-01-14 12:53:39'),(791,'1','308',1,'Retail Sale Id 852',0.00,697.20,760.00,798.00,100.80,'2023-01-14 13:09:51'),(792,'1','308',1,'Retail Sale Id 853',0.00,1992.00,760.00,2280.00,288.00,'2023-01-14 13:37:58'),(793,'1','308',1,'Retail Sale Id 856',0.00,3320.00,760.00,3800.00,480.00,'2023-01-14 13:50:07'),(794,'1','308',1,'Retail Sale Id 857',0.00,27224.00,710.00,29110.00,1886.00,'2023-01-14 13:58:06'),(795,'1','308',1,'Retail Sale Id 858',0.00,16600.00,710.00,17750.00,1150.00,'2023-01-14 14:10:09'),(796,'1','308',1,'Retail Sale Id 859',0.00,1308.08,760.00,1497.20,189.12,'2023-01-14 14:41:16'),(797,'1','308',1,'Retail Sale Id 860',0.00,697.20,760.00,798.00,100.80,'2023-01-14 15:00:02'),(798,'1','308',1,'Retail Sale Id 861',0.00,3984.00,760.00,4560.00,576.00,'2023-01-14 15:47:54'),(799,'1','308',1,'Retail Sale Id 862',0.00,1328.00,760.00,1520.00,192.00,'2023-01-14 15:51:45'),(800,'1','308',1,'Retail Sale Id 863',0.00,2656.00,760.00,3040.00,384.00,'2023-01-14 16:07:58'),(801,'1','308',1,'Retail Sale Id 864',0.00,1328.00,760.00,1520.00,192.00,'2023-01-14 16:09:46'),(802,'1','308',1,'Retail Sale Id 865',0.00,664.00,760.00,760.00,96.00,'2023-01-14 16:11:19'),(803,'1','308',1,'Retail Sale Id 866',0.00,2656.00,760.00,3040.00,384.00,'2023-01-14 16:20:57'),(804,'1','308',1,'Retail Sale Id 867',0.00,7968.00,760.00,9120.00,1152.00,'2023-01-14 16:26:29'),(805,'1','308',1,'Retail Sale Id 868',0.00,1328.00,760.00,1520.00,192.00,'2023-01-14 16:28:28'),(806,'1','308',1,'Retail Sale Id 869',0.00,1992.00,760.00,2280.00,288.00,'2023-01-14 17:25:12'),(807,'1','308',1,'Retail Sale Id 870',0.00,1992.00,760.00,2280.00,288.00,'2023-01-14 17:42:12'),(808,'1','308',1,'Retail Sale Id 871',0.00,24900.00,710.00,26625.00,1725.00,'2023-01-14 17:43:52'),(809,'1','308',1,'Retail Sale Id 873',0.00,664.00,760.00,760.00,96.00,'2023-01-14 17:47:41'),(810,'1','308',1,'Retail Sale Id 874',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-14 17:57:29'),(811,'1','308',1,'Retail Sale Id 875',0.00,664.00,760.00,760.00,96.00,'2023-01-14 17:58:54'),(812,'1','308',1,'Retail Sale Id 876',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-14 18:10:04'),(813,'1','308',1,'Retail Sale Id 877',0.00,2098.24,760.00,2401.60,303.36,'2023-01-14 18:13:14'),(814,'1','308',1,'Retail Sale Id 878',0.00,6659.92,760.00,7622.80,962.88,'2023-01-14 19:03:59'),(815,'1','308',1,'Retail Sale Id 879',0.00,2011.92,760.00,2302.80,290.88,'2023-01-15 07:45:50'),(816,'1','308',1,'Retail Sale Id 880',0.00,10624.00,760.00,12160.00,1536.00,'2023-01-15 07:49:57'),(817,'1','308',1,'Retail Sale Id 881',0.00,2662.64,760.00,3047.60,384.96,'2023-01-15 08:02:02'),(818,'1','308',1,'Retail Sale Id 882',0.00,3320.00,760.00,3800.00,480.00,'2023-01-15 08:08:59'),(819,'1','308',1,'Retail Sale Id 883',0.00,1328.00,760.00,1520.00,192.00,'2023-01-15 08:15:10'),(820,'1','308',1,'Retail Sale Id 884',0.00,2662.64,760.00,3047.60,384.96,'2023-01-15 08:18:34'),(821,'1','308',1,'Retail Sale Id 885',0.00,2011.92,760.00,2302.80,290.88,'2023-01-15 08:19:52'),(822,'1','308',1,'Retail Sale Id 886',0.00,3320.00,760.00,3800.00,480.00,'2023-01-15 08:22:53'),(823,'1','308',1,'Retail Sale Id 887',0.00,3984.00,760.00,4560.00,576.00,'2023-01-15 08:43:42'),(824,'1','308',1,'Retail Sale Id 888',0.00,3984.00,760.00,4560.00,576.00,'2023-01-15 09:01:16'),(825,'1','308',1,'Retail Sale Id 889',0.00,1992.00,760.00,2280.00,288.00,'2023-01-15 09:17:10'),(826,'1','308',1,'Retail Sale Id 890',0.00,2011.92,760.00,2302.80,290.88,'2023-01-15 09:53:40'),(827,'1','308',1,'Retail Sale Id 891',0.00,2662.64,760.00,3047.60,384.96,'2023-01-15 09:55:10'),(828,'1','308',1,'Retail Sale Id 892',0.00,1049.12,760.00,1200.80,151.68,'2023-01-15 10:08:16'),(829,'1','308',1,'Retail Sale Id 893',0.00,20842.96,710.00,22286.90,1443.94,'2023-01-15 11:13:06'),(830,'1','308',1,'Sale Id 1',0.00,52044.32,706.00,55336.28,3291.96,'2023-01-15 13:17:33'),(831,'1','308',1,'Retail Sale Id 894',0.00,1328.00,760.00,1520.00,192.00,'2023-01-15 14:27:59'),(832,'1','308',1,'Retail Sale Id 895',0.00,2011.92,760.00,2302.80,290.88,'2023-01-15 14:29:19'),(833,'1','308',1,'Retail Sale Id 896',0.00,1308.08,760.00,1497.20,189.12,'2023-01-15 14:30:45'),(834,'1','308',1,'Retail Sale Id 897',0.00,697.20,760.00,798.00,100.80,'2023-01-15 14:31:38'),(835,'1','308',1,'Retail Sale Id 898',0.00,3984.00,760.00,4560.00,576.00,'2023-01-15 14:34:33'),(836,'1','308',1,'Retail Sale Id 899',0.00,1308.08,760.00,1497.20,189.12,'2023-01-15 14:36:10'),(837,'1','308',1,'Retail Sale Id 900',0.00,3320.00,760.00,3800.00,480.00,'2023-01-15 14:38:55'),(838,'1','308',1,'Retail Sale Id 901',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-15 14:39:57'),(839,'1','308',1,'Retail Sale Id 902',0.00,2011.92,760.00,2302.80,290.88,'2023-01-15 14:44:20'),(840,'1','308',1,'Retail Sale Id 903',0.00,2011.92,760.00,2302.80,290.88,'2023-01-15 14:48:34'),(841,'1','308',1,'Retail Sale Id 904',0.00,28957.04,710.00,30963.10,2006.06,'2023-01-15 14:52:10'),(842,'1','308',1,'Retail Sale Id 905',0.00,697.20,760.00,798.00,100.80,'2023-01-15 14:53:45'),(843,'1','308',1,'Retail Sale Id 906',0.00,697.20,760.00,798.00,100.80,'2023-01-15 14:56:30'),(844,'1','308',1,'Retail Sale Id 907',0.00,3320.00,760.00,3800.00,480.00,'2023-01-15 15:00:46'),(845,'1','308',1,'Retail Sale Id 908',0.00,1992.00,760.00,2280.00,288.00,'2023-01-15 15:17:23'),(846,'1','308',1,'Retail Sale Id 909',0.00,1308.08,760.00,1497.20,189.12,'2023-01-15 15:52:02'),(847,'1','308',1,'Retail Sale Id 910',0.00,1992.00,760.00,2280.00,288.00,'2023-01-15 15:53:12'),(848,'1','308',1,'Retail Sale Id 911',0.00,1746.32,760.00,1998.80,252.48,'2023-01-15 15:56:05'),(849,'1','308',1,'Retail Sale Id 912',0.00,657.36,760.00,752.40,95.04,'2023-01-15 16:07:36'),(850,'1','308',1,'Retail Sale Id 913',0.00,2357.20,760.00,2698.00,340.80,'2023-01-15 16:31:23'),(851,'1','308',1,'Retail Sale Id 914',0.00,3984.00,760.00,4560.00,576.00,'2023-01-15 16:33:13'),(852,'1','308',1,'Retail Sale Id 915',0.00,1992.00,760.00,2280.00,288.00,'2023-01-15 16:34:37'),(853,'1','308',1,'Retail Sale Id 916',0.00,2662.64,760.00,3047.60,384.96,'2023-01-15 16:39:31'),(854,'1','308',1,'Retail Sale Id 917',0.00,3984.00,760.00,4560.00,576.00,'2023-01-15 17:07:23'),(855,'1','308',1,'Retail Sale Id 918',0.00,697.20,760.00,798.00,100.80,'2023-01-15 17:24:19'),(856,'1','308',1,'Retail Sale Id 919',0.00,4369.12,760.00,5000.80,631.68,'2023-01-15 17:28:18'),(857,'1','308',1,'Retail Sale Id 920',0.00,2011.92,760.00,2302.80,290.88,'2023-01-15 17:29:31'),(858,'1','308',1,'Retail Sale Id 921',0.00,1328.00,760.00,1520.00,192.00,'2023-01-15 17:32:22'),(859,'1','308',1,'Retail Sale Id 923',0.00,1328.00,760.00,1520.00,192.00,'2023-01-15 17:34:38'),(860,'1','308',1,'Retail Sale Id 924',0.00,697.20,760.00,798.00,100.80,'2023-01-15 17:36:22'),(861,'1','308',1,'Retail Sale Id 925',0.00,3977.36,760.00,4552.40,575.04,'2023-01-15 17:40:11'),(862,'1','308',1,'Retail Sale Id 926',0.00,664.00,760.00,760.00,96.00,'2023-01-15 17:41:27'),(863,'1','308',1,'Retail Sale Id 927',0.00,2662.64,760.00,3047.60,384.96,'2023-01-15 18:03:22'),(864,'1','308',1,'Retail Sale Id 928',0.00,2011.92,760.00,2302.80,290.88,'2023-01-15 18:29:15'),(865,'1','308',1,'Retail Sale Id 929',0.00,1746.32,760.00,1998.80,252.48,'2023-01-15 18:30:16'),(866,'1','308',1,'Retail Sale Id 930',0.00,3320.00,760.00,3800.00,480.00,'2023-01-15 18:31:13'),(867,'1','308',1,'Retail Sale Id 931',0.00,1992.00,760.00,2280.00,288.00,'2023-01-15 18:33:03'),(868,'1','308',1,'Retail Sale Id 932',0.00,1354.56,760.00,1550.40,195.84,'2023-01-15 18:36:51'),(869,'1','308',1,'Retail Sale Id 933',0.00,1328.00,760.00,1520.00,192.00,'2023-01-16 07:45:54'),(870,'1','308',1,'Retail Sale Id 934',0.00,16600.00,710.00,17750.00,1150.00,'2023-01-16 08:06:47'),(871,'1','308',1,'Retail Sale Id 935',0.00,1328.00,760.00,1520.00,192.00,'2023-01-16 08:15:54'),(872,'1','308',1,'Retail Sale Id 936',0.00,29216.00,710.00,31240.00,2024.00,'2023-01-16 08:32:39'),(873,'1','308',1,'Retail Sale Id 937',0.00,3984.00,760.00,4560.00,576.00,'2023-01-16 08:34:28'),(874,'1','308',1,'Retail Sale Id 938',0.00,1992.00,760.00,2280.00,288.00,'2023-01-16 08:38:00'),(875,'1','308',1,'Retail Sale Id 940',0.00,1308.08,760.00,1497.20,189.12,'2023-01-16 08:45:47'),(876,'1','308',1,'Retail Sale Id 941',0.00,1992.00,760.00,2280.00,288.00,'2023-01-16 08:48:02'),(877,'1','308',1,'Retail Sale Id 943',0.00,2662.64,760.00,3047.60,384.96,'2023-01-16 08:51:52'),(878,'1','308',1,'Retail Sale Id 944',0.00,2011.92,760.00,2302.80,290.88,'2023-01-16 08:55:19'),(879,'1','308',1,'Retail Sale Id 945',0.00,1401.04,760.00,1603.60,202.56,'2023-01-16 09:07:49'),(880,'1','308',1,'Retail Sale Id 946',0.00,6640.00,760.00,7600.00,960.00,'2023-01-16 09:18:43'),(881,'1','308',1,'Retail Sale Id 947',0.00,2011.92,760.00,2302.80,290.88,'2023-01-16 09:24:45'),(882,'1','308',1,'Retail Sale Id 952',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-16 10:13:09'),(883,'1','308',1,'Retail Sale Id 953',0.00,876.48,760.00,1003.20,126.72,'2023-01-16 10:29:54'),(884,'1','308',1,'Retail Sale Id 954',0.00,3930.88,760.00,4499.20,568.32,'2023-01-16 10:36:35'),(885,'1','308',1,'Retail Sale Id 956',0.00,2602.88,740.00,2900.80,297.92,'2023-01-16 11:43:35'),(886,'1','308',1,'Retail Sale Id 957',0.00,2656.00,740.00,2960.00,304.00,'2023-01-16 11:45:22'),(887,'1','308',1,'Retail Sale Id 958',0.00,21248.00,710.00,22720.00,1472.00,'2023-01-16 11:53:34'),(888,'1','308',1,'Retail Sale Id 959',0.00,8300.00,740.00,9250.00,950.00,'2023-01-16 12:05:58'),(889,'1','308',1,'Retail Sale Id 960',0.00,4037.12,740.00,4499.20,462.08,'2023-01-16 12:10:50'),(890,'1','308',1,'Retail Sale Id 950',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-16 12:20:31'),(891,'1','308',1,'Retail Sale Id 961',0.00,1075.68,740.00,1198.80,123.12,'2023-01-16 13:11:12'),(892,'1','308',1,'Retail Sale Id 962',0.00,1328.00,740.00,1480.00,152.00,'2023-01-16 14:29:56'),(893,'1','308',1,'Retail Sale Id 964',0.00,3320.00,740.00,3700.00,380.00,'2023-01-16 14:36:16'),(894,'1','308',1,'Retail Sale Id 965',0.00,2011.92,740.00,2242.20,230.28,'2023-01-16 15:08:37'),(895,'1','308',1,'Retail Sale Id 966',0.00,3990.64,740.00,4447.40,456.76,'2023-01-16 15:19:47'),(896,'1','308',1,'Retail Sale Id 967',0.00,1347.92,740.00,1502.20,154.28,'2023-01-16 15:25:23'),(897,'1','308',1,'Retail Sale Id 968',0.00,717.12,740.00,799.20,82.08,'2023-01-16 15:26:31'),(898,'1','308',1,'Retail Sale Id 969',0.00,3990.64,740.00,4447.40,456.76,'2023-01-16 15:59:52'),(899,'1','308',1,'Retail Sale Id 970',0.00,1792.80,740.00,1998.00,205.20,'2023-01-16 16:01:13'),(900,'1','308',1,'Retail Sale Id 971',0.00,451.52,740.00,503.20,51.68,'2023-01-16 16:17:33'),(901,'1','308',1,'Retail Sale Id 972',0.00,2988.00,740.00,3330.00,342.00,'2023-01-16 16:22:21'),(902,'1','308',1,'Retail Sale Id 973',0.00,3140.72,740.00,3500.20,359.48,'2023-01-16 16:23:58'),(903,'1','308',1,'Retail Sale Id 974',0.00,664.00,740.00,740.00,76.00,'2023-01-16 16:28:43'),(904,'1','308',1,'Retail Sale Id 975',0.00,16600.00,740.00,18500.00,1900.00,'2023-01-16 16:30:16'),(905,'1','308',1,'Retail Sale Id 976',0.00,1347.92,740.00,1502.20,154.28,'2023-01-16 16:39:06'),(906,'1','308',1,'Retail Sale Id 977',0.00,1992.00,740.00,2220.00,228.00,'2023-01-16 16:42:06'),(907,'1','308',1,'Retail Sale Id 978',0.00,1075.68,740.00,1198.80,123.12,'2023-01-16 16:54:39'),(908,'1','308',1,'Retail Sale Id 979',0.00,1328.00,740.00,1480.00,152.00,'2023-01-16 16:59:18'),(909,'1','308',1,'Retail Sale Id 980',0.00,3984.00,740.00,4440.00,456.00,'2023-01-16 17:05:18'),(910,'1','308',1,'Retail Sale Id 981',0.00,2649.36,740.00,2952.60,303.24,'2023-01-16 17:13:07'),(911,'1','308',1,'Retail Sale Id 982',0.00,2656.00,740.00,2960.00,304.00,'2023-01-16 17:15:36'),(912,'1','308',1,'Retail Sale Id 983',0.00,1328.00,740.00,1480.00,152.00,'2023-01-16 17:36:16'),(913,'1','308',1,'Retail Sale Id 984',0.00,3990.64,740.00,4447.40,456.76,'2023-01-16 17:45:40'),(914,'1','308',1,'Retail Sale Id 985',0.00,670.64,740.00,747.40,76.76,'2023-01-16 17:48:53'),(915,'1','308',1,'Retail Sale Id 986',0.00,8300.00,740.00,9250.00,950.00,'2023-01-16 18:07:17'),(916,'1','308',1,'Retail Sale Id 987',0.00,2689.20,740.00,2997.00,307.80,'2023-01-16 18:20:57'),(917,'1','308',1,'Retail Sale Id 988',0.00,3990.64,740.00,4447.40,456.76,'2023-01-16 18:24:39'),(918,'1','308',1,'Retail Sale Id 989',0.00,305.44,740.00,340.40,34.96,'2023-01-16 19:31:56'),(919,'1','308',1,'Retail Sale Id 990',0.00,1972.08,740.00,2197.80,225.72,'2023-01-17 07:41:16'),(920,'1','308',1,'Retail Sale Id 992',0.00,3412.96,740.00,3803.60,390.64,'2023-01-17 07:54:12'),(921,'1','308',1,'Retail Sale Id 993',0.00,2018.56,740.00,2249.60,231.04,'2023-01-17 08:02:28'),(922,'1','308',1,'Retail Sale Id 994',0.00,2018.56,740.00,2249.60,231.04,'2023-01-17 08:03:57'),(923,'1','308',1,'Retail Sale Id 996',0.00,6102.16,740.00,6800.60,698.44,'2023-01-17 08:25:16'),(924,'1','308',1,'Retail Sale Id 997',0.00,3990.64,740.00,4447.40,456.76,'2023-01-17 08:42:45'),(925,'1','308',1,'Retail Sale Id 999',0.00,1792.80,740.00,1998.00,205.20,'2023-01-17 09:34:18'),(926,'1','308',1,'Retail Sale Id 1000',0.00,2656.00,740.00,2960.00,304.00,'2023-01-17 09:36:28'),(927,'1','308',1,'Retail Sale Id 1001',0.00,3990.64,740.00,4447.40,456.76,'2023-01-17 09:38:16'),(928,'1','308',1,'Retail Sale Id 1002',0.00,29216.00,710.00,31240.00,2024.00,'2023-01-17 10:16:52'),(929,'1','308',1,'Retail Sale Id 1003',0.00,664.00,740.00,740.00,76.00,'2023-01-17 10:18:29'),(930,'1','308',1,'Retail Sale Id 1004',0.00,1347.92,740.00,1502.20,154.28,'2023-01-17 10:51:59'),(931,'1','308',1,'Retail Sale Id 1005',0.00,1932.24,740.00,2153.40,221.16,'2023-01-17 11:10:33'),(932,'1','308',1,'Retail Sale Id 1006',0.00,1992.00,740.00,2220.00,228.00,'2023-01-17 12:06:30'),(933,'1','308',1,'Retail Sale Id 1007',0.00,1328.00,740.00,1480.00,152.00,'2023-01-17 12:14:27'),(934,'1','308',1,'Retail Sale Id 1008',0.00,1328.00,740.00,1480.00,152.00,'2023-01-17 12:17:26'),(935,'1','308',1,'Retail Sale Id 1009',0.00,1347.92,740.00,1502.20,154.28,'2023-01-17 12:21:08'),(936,'1','308',1,'Retail Sale Id 1010',0.00,2689.20,740.00,2997.00,307.80,'2023-01-17 12:40:02'),(937,'1','308',1,'Retail Sale Id 1011',0.00,2656.00,740.00,2960.00,304.00,'2023-01-17 13:18:03'),(938,'1','308',1,'Retail Sale Id 1012',0.00,664.00,740.00,740.00,76.00,'2023-01-17 13:59:07'),(939,'1','308',1,'Retail Sale Id 1013',0.00,1792.80,740.00,1998.00,205.20,'2023-01-17 14:29:03'),(940,'1','308',1,'Retail Sale Id 1014',0.00,1347.92,740.00,1502.20,154.28,'2023-01-17 15:08:37'),(941,'1','308',1,'Retail Sale Id 1015',0.00,1347.92,740.00,1502.20,154.28,'2023-01-17 15:14:05'),(942,'1','308',1,'Retail Sale Id 1016',0.00,1347.92,740.00,1502.20,154.28,'2023-01-17 15:24:12'),(943,'1','308',1,'Retail Sale Id 1017',0.00,1347.92,740.00,1502.20,154.28,'2023-01-17 15:41:02'),(944,'1','308',1,'Retail Sale Id 1018',0.00,896.40,740.00,999.00,102.60,'2023-01-17 15:55:50'),(945,'1','308',1,'Retail Sale Id 1019',0.00,6640.00,740.00,7400.00,760.00,'2023-01-17 15:58:22'),(946,'1','308',1,'Retail Sale Id 1020',0.00,2656.00,740.00,2960.00,304.00,'2023-01-17 15:59:50'),(947,'1','308',1,'Retail Sale Id 1021',0.00,1328.00,740.00,1480.00,152.00,'2023-01-17 16:01:01'),(948,'1','308',1,'Retail Sale Id 1022',0.00,1347.92,740.00,1502.20,154.28,'2023-01-17 16:19:49'),(949,'1','308',1,'Retail Sale Id 1024',0.00,1992.00,740.00,2220.00,228.00,'2023-01-17 16:27:07'),(950,'1','308',1,'Retail Sale Id 1025',0.00,1992.00,740.00,2220.00,228.00,'2023-01-17 16:35:41'),(951,'1','308',1,'Retail Sale Id 1026',0.00,1347.92,740.00,1502.20,154.28,'2023-01-17 16:36:46'),(952,'1','308',1,'Retail Sale Id 1027',0.00,132800.00,710.00,142000.00,9200.00,'2023-01-17 16:43:04'),(953,'1','308',1,'Retail Sale Id 1028',0.00,670.64,740.00,747.40,76.76,'2023-01-17 16:54:22'),(954,'1','308',1,'Retail Sale Id 1029',0.00,1347.92,740.00,1502.20,154.28,'2023-01-17 17:02:08'),(955,'1','308',1,'Retail Sale Id 1030',0.00,2018.56,740.00,2249.60,231.04,'2023-01-17 17:03:23'),(956,'1','308',1,'Retail Sale Id 1031',0.00,3320.00,740.00,3700.00,380.00,'2023-01-17 17:04:59'),(957,'1','308',1,'Retail Sale Id 1032',0.00,3990.64,740.00,4447.40,456.76,'2023-01-17 17:06:00'),(958,'1','308',1,'Retail Sale Id 1033',0.00,1992.00,740.00,2220.00,228.00,'2023-01-17 17:07:28'),(959,'1','308',1,'Retail Sale Id 1034',0.00,1992.00,740.00,2220.00,228.00,'2023-01-17 17:08:03'),(960,'1','308',1,'Retail Sale Id 1035',0.00,1347.92,740.00,1502.20,154.28,'2023-01-17 17:22:46'),(961,'1','308',1,'Retail Sale Id 1036',0.00,670.64,740.00,747.40,76.76,'2023-01-17 17:25:41'),(962,'1','308',1,'Retail Sale Id 1037',0.00,1792.80,740.00,1998.00,205.20,'2023-01-17 17:27:07'),(963,'1','308',1,'Retail Sale Id 1038',0.00,1992.00,740.00,2220.00,228.00,'2023-01-17 17:36:40'),(964,'1','308',1,'Retail Sale Id 1039',0.00,3320.00,740.00,3700.00,380.00,'2023-01-17 17:38:41'),(965,'1','308',1,'Retail Sale Id 1040',0.00,896.40,740.00,999.00,102.60,'2023-01-17 17:52:21'),(966,'1','308',1,'Retail Sale Id 1041',0.00,1985.36,740.00,2212.60,227.24,'2023-01-17 17:56:01'),(967,'1','308',1,'Retail Sale Id 1042',0.00,2656.00,740.00,2960.00,304.00,'2023-01-17 17:58:49'),(968,'1','308',1,'Retail Sale Id 1043',0.00,1347.92,740.00,1502.20,154.28,'2023-01-17 18:10:55'),(969,'1','308',1,'Retail Sale Id 1044',0.00,3984.00,740.00,4440.00,456.00,'2023-01-17 18:12:16'),(970,'1','308',1,'Retail Sale Id 1045',0.00,2018.56,740.00,2249.60,231.04,'2023-01-17 18:13:58'),(971,'1','308',1,'Retail Sale Id 1046',0.00,1347.92,740.00,1502.20,154.28,'2023-01-17 18:21:09'),(972,'1','308',1,'Retail Sale Id 1047',0.00,1328.00,740.00,1480.00,152.00,'2023-01-17 18:28:38'),(973,'1','308',1,'Retail Sale Id 1048',0.00,1347.92,740.00,1502.20,154.28,'2023-01-17 18:37:09'),(974,'1','308',1,'Retail Sale Id 1049',0.00,7310.64,740.00,8147.40,836.76,'2023-01-17 18:38:14'),(975,'1','308',1,'Retail Sale Id 1050',0.00,2656.00,740.00,2960.00,304.00,'2023-01-18 07:28:46'),(976,'1','308',1,'Retail Sale Id 1051',0.00,3320.00,740.00,3700.00,380.00,'2023-01-18 07:30:41'),(977,'1','308',1,'Retail Sale Id 1052',0.00,1347.92,740.00,1502.20,154.28,'2023-01-18 07:44:35'),(978,'1','308',1,'Retail Sale Id 1053',0.00,896.40,740.00,999.00,102.60,'2023-01-18 07:59:27'),(979,'1','308',1,'Retail Sale Id 1054',0.00,8300.00,740.00,9250.00,950.00,'2023-01-18 08:07:37'),(980,'1','308',1,'Retail Sale Id 1055',0.00,6640.00,740.00,7400.00,760.00,'2023-01-18 08:08:50'),(981,'1','308',1,'Retail Sale Id 1056',0.00,4933.52,740.00,5498.20,564.68,'2023-01-18 08:16:28'),(982,'1','308',1,'Retail Sale Id 1057',0.00,6281.44,740.00,7000.40,718.96,'2023-01-18 08:30:53'),(983,'1','308',1,'Retail Sale Id 1058',0.00,7968.00,740.00,8880.00,912.00,'2023-01-18 08:46:18'),(984,'1','308',1,'Retail Sale Id 1059',0.00,1992.00,740.00,2220.00,228.00,'2023-01-18 09:01:17'),(985,'1','308',1,'Retail Sale Id 1060',0.00,3592.24,740.00,4003.40,411.16,'2023-01-18 09:08:04'),(986,'1','308',1,'Retail Sale Id 1061',0.00,1328.00,740.00,1480.00,152.00,'2023-01-18 09:14:52'),(987,'1','308',1,'Retail Sale Id 1062',0.00,19920.00,710.00,21300.00,1380.00,'2023-01-18 09:30:53'),(988,'1','308',1,'Retail Sale Id 1063',0.00,5385.04,740.00,6001.40,616.36,'2023-01-18 09:33:25'),(989,'1','308',1,'Retail Sale Id 1064',0.00,2656.00,740.00,2960.00,304.00,'2023-01-18 09:34:51'),(990,'1','308',1,'Retail Sale Id 1065',0.00,1972.08,740.00,2197.80,225.72,'2023-01-18 09:37:00'),(991,'1','308',1,'Retail Sale Id 1066',0.00,3592.24,740.00,4003.40,411.16,'2023-01-18 10:25:23'),(992,'1','308',1,'Retail Sale Id 1067',0.00,1347.92,740.00,1502.20,154.28,'2023-01-18 10:28:59'),(993,'1','308',1,'Retail Sale Id 1068',0.00,1347.92,740.00,1502.20,154.28,'2023-01-18 10:42:43'),(994,'1','308',1,'Retail Sale Id 1069',0.00,2018.56,740.00,2249.60,231.04,'2023-01-18 11:15:40'),(995,'1','308',1,'Retail Sale Id 1070',0.00,3320.00,740.00,3700.00,380.00,'2023-01-18 11:41:43'),(996,'1','308',1,'Retail Sale Id 1071',0.00,3990.64,740.00,4447.40,456.76,'2023-01-18 12:12:09'),(997,'1','308',1,'Retail Sale Id 1072',0.00,1347.92,740.00,1502.20,154.28,'2023-01-18 12:18:25'),(998,'1','308',1,'Retail Sale Id 1073',0.00,3320.00,740.00,3700.00,380.00,'2023-01-18 12:22:44'),(999,'1','308',1,'Retail Sale Id 1074',0.00,670.64,740.00,747.40,76.76,'2023-01-18 12:47:27'),(1000,'1','308',1,'Retail Sale Id 1075',0.00,1347.92,740.00,1502.20,154.28,'2023-01-18 12:49:14'),(1001,'1','308',1,'Retail Sale Id 1076',0.00,3984.00,740.00,4440.00,456.00,'2023-01-18 13:13:08'),(1002,'1','308',1,'Retail Sale Id 1077',0.00,8300.00,740.00,9250.00,950.00,'2023-01-18 13:22:24'),(1003,'1','308',1,'Retail Sale Id 1078',0.00,1328.00,740.00,1480.00,152.00,'2023-01-18 13:31:34'),(1004,'1','308',1,'Retail Sale Id 1079',0.00,1347.92,740.00,1502.20,154.28,'2023-01-18 13:51:36'),(1005,'1','308',1,'Retail Sale Id 1080',0.00,1347.92,740.00,1502.20,154.28,'2023-01-18 13:59:57'),(1006,'1','308',1,'Retail Sale Id 1081',0.00,1328.00,740.00,1480.00,152.00,'2023-01-18 14:29:10'),(1007,'1','308',1,'Retail Sale Id 1082',0.00,1992.00,740.00,2220.00,228.00,'2023-01-18 14:38:33'),(1008,'1','308',1,'Retail Sale Id 1083',0.00,3984.00,740.00,4440.00,456.00,'2023-01-18 15:14:30'),(1009,'1','308',1,'Retail Sale Id 1084',0.00,1347.92,740.00,1502.20,154.28,'2023-01-18 15:36:49'),(1010,'1','308',1,'Retail Sale Id 1085',0.00,1328.00,740.00,1480.00,152.00,'2023-01-18 15:41:14'),(1011,'1','308',1,'Retail Sale Id 1086',0.00,1347.92,740.00,1502.20,154.28,'2023-01-18 15:46:38'),(1012,'1','308',1,'Retail Sale Id 1087',0.00,1347.92,740.00,1502.20,154.28,'2023-01-18 15:48:11'),(1013,'1','308',1,'Retail Sale Id 1088',0.00,670.64,740.00,747.40,76.76,'2023-01-18 16:01:26'),(1014,'1','308',1,'Retail Sale Id 1089',0.00,2038.48,740.00,2271.80,233.32,'2023-01-18 16:08:55'),(1015,'1','308',1,'Retail Sale Id 1090',0.00,3984.00,740.00,4440.00,456.00,'2023-01-18 16:24:03'),(1016,'1','308',1,'Retail Sale Id 1091',0.00,2656.00,740.00,2960.00,304.00,'2023-01-18 16:34:00'),(1017,'1','308',1,'Retail Sale Id 1092',0.00,1660.00,740.00,1850.00,190.00,'2023-01-18 16:36:01'),(1018,'1','308',1,'Retail Sale Id 1093',0.00,1328.00,740.00,1480.00,152.00,'2023-01-18 17:03:17'),(1019,'1','308',1,'Retail Sale Id 1094',0.00,2011.92,740.00,2242.20,230.28,'2023-01-18 17:05:51'),(1020,'1','308',1,'Retail Sale Id 1095',0.00,664.00,740.00,740.00,76.00,'2023-01-18 17:20:22'),(1021,'1','308',1,'Retail Sale Id 1096',0.00,664.00,740.00,740.00,76.00,'2023-01-18 17:26:49'),(1022,'1','308',1,'Retail Sale Id 1097',0.00,1972.08,740.00,2197.80,225.72,'2023-01-18 17:28:23'),(1023,'1','308',1,'Retail Sale Id 1098',0.00,1328.00,740.00,1480.00,152.00,'2023-01-18 17:41:47'),(1024,'1','308',1,'Retail Sale Id 1099',0.00,664.00,740.00,740.00,76.00,'2023-01-18 17:44:35'),(1025,'1','308',1,'Retail Sale Id 1100',0.00,1992.00,740.00,2220.00,228.00,'2023-01-18 17:47:21'),(1026,'1','308',1,'Retail Sale Id 1101',0.00,8300.00,740.00,9250.00,950.00,'2023-01-18 17:48:53'),(1027,'1','308',1,'Retail Sale Id 1102',0.00,2656.00,740.00,2960.00,304.00,'2023-01-18 17:50:24'),(1028,'1','308',1,'Retail Sale Id 1103',0.00,664.00,740.00,740.00,76.00,'2023-01-18 18:01:23'),(1029,'1','308',1,'Retail Sale Id 1104',0.00,1328.00,740.00,1480.00,152.00,'2023-01-18 18:04:39'),(1030,'1','308',1,'Retail Sale Id 1106',0.00,1992.00,740.00,2220.00,228.00,'2023-01-18 18:07:45'),(1031,'1','308',1,'Retail Sale Id 1107',0.00,2018.56,740.00,2249.60,231.04,'2023-01-18 18:10:32'),(1032,'1','308',1,'Retail Sale Id 1108',0.00,896.40,740.00,999.00,102.60,'2023-01-18 18:13:04'),(1033,'1','308',1,'Retail Sale Id 1109',0.00,3320.00,740.00,3700.00,380.00,'2023-01-18 18:19:09'),(1034,'1','308',1,'Retail Sale Id 1110',0.00,1328.00,740.00,1480.00,152.00,'2023-01-18 18:21:04'),(1035,'1','308',1,'Retail Sale Id 1111',0.00,25232.00,710.00,26980.00,1748.00,'2023-01-18 18:26:24'),(1036,'1','308',1,'Retail Sale Id 1112',0.00,3320.00,740.00,3700.00,380.00,'2023-01-18 18:31:14'),(1037,'1','308',1,'Retail Sale Id 1113',0.00,1341.28,740.00,1494.80,153.52,'2023-01-18 19:42:45'),(1038,'1','308',1,'Retail Sale Id 1114',0.00,1347.92,740.00,1502.20,154.28,'2023-01-19 07:09:16'),(1039,'1','308',1,'Retail Sale Id 1115',0.00,2018.56,740.00,2249.60,231.04,'2023-01-19 07:10:44'),(1040,'1','308',1,'Retail Sale Id 1116',0.00,2649.36,740.00,2952.60,303.24,'2023-01-19 07:12:25'),(1041,'1','308',1,'Retail Sale Id 1117',0.00,670.64,740.00,747.40,76.76,'2023-01-19 07:19:19'),(1042,'1','308',1,'Retail Sale Id 1118',0.00,8300.00,740.00,9250.00,950.00,'2023-01-19 09:00:23'),(1043,'1','308',1,'Retail Sale Id 1119',0.00,3990.64,740.00,4447.40,456.76,'2023-01-19 09:14:15'),(1044,'1','308',1,'Retail Sale Id 1120',0.00,1972.08,740.00,2197.80,225.72,'2023-01-19 09:17:46'),(1045,'1','308',1,'Retail Sale Id 1121',0.00,4037.12,740.00,4499.20,462.08,'2023-01-19 10:43:58'),(1046,'1','308',1,'Retail Sale Id 1122',0.00,1972.08,740.00,2197.80,225.72,'2023-01-19 12:04:20'),(1047,'1','308',1,'Retail Sale Id 1123',0.00,1347.92,740.00,1502.20,154.28,'2023-01-19 12:06:45'),(1048,'1','308',1,'Retail Sale Id 1124',0.00,1347.92,740.00,1502.20,154.28,'2023-01-19 12:07:28'),(1049,'1','308',1,'Retail Sale Id 1125',0.00,896.40,740.00,999.00,102.60,'2023-01-19 12:19:52'),(1050,'1','308',1,'Retail Sale Id 1126',0.00,17947.92,740.00,20002.20,2054.28,'2023-01-19 13:56:36'),(1051,'1','308',1,'Retail Sale Id 1127',0.00,3990.64,740.00,4447.40,456.76,'2023-01-19 14:13:12'),(1052,'1','308',1,'Retail Sale Id 1128',0.00,3320.00,740.00,3700.00,380.00,'2023-01-19 14:18:47'),(1053,'1','308',1,'Retail Sale Id 1129',0.00,3990.64,740.00,4447.40,456.76,'2023-01-19 15:21:56'),(1054,'1','308',1,'Retail Sale Id 1130',0.00,1347.92,740.00,1502.20,154.28,'2023-01-19 15:31:03'),(1055,'1','308',1,'Retail Sale Id 1131',0.00,2689.20,740.00,2997.00,307.80,'2023-01-19 16:00:13'),(1056,'1','308',1,'Retail Sale Id 1132',0.00,1347.92,740.00,1502.20,154.28,'2023-01-19 16:15:09'),(1057,'1','308',1,'Retail Sale Id 1133',0.00,2689.20,740.00,2997.00,307.80,'2023-01-19 16:16:09'),(1058,'1','308',1,'Retail Sale Id 1134',0.00,1347.92,740.00,1502.20,154.28,'2023-01-19 16:20:15'),(1059,'1','308',1,'Retail Sale Id 1135',0.00,1347.92,740.00,1502.20,154.28,'2023-01-19 16:59:50'),(1060,'1','308',1,'Retail Sale Id 1136',0.00,670.64,740.00,747.40,76.76,'2023-01-19 17:05:12'),(1061,'1','308',1,'Retail Sale Id 1137',0.00,3320.00,740.00,3700.00,380.00,'2023-01-19 17:13:16'),(1062,'1','308',1,'Retail Sale Id 1138',0.00,3320.00,740.00,3700.00,380.00,'2023-01-19 17:14:14'),(1063,'1','308',1,'Retail Sale Id 1139',0.00,896.40,740.00,999.00,102.60,'2023-01-19 17:17:21'),(1064,'1','308',1,'Retail Sale Id 1140',0.00,1347.92,740.00,1502.20,154.28,'2023-01-19 17:19:17'),(1065,'1','308',1,'Retail Sale Id 1141',0.00,4667.92,740.00,5202.20,534.28,'2023-01-19 17:22:54'),(1066,'1','308',1,'Retail Sale Id 1142',0.00,1347.92,740.00,1502.20,154.28,'2023-01-19 17:31:09'),(1067,'1','308',1,'Retail Sale Id 1143',0.00,670.64,740.00,747.40,76.76,'2023-01-19 17:40:11'),(1068,'1','308',1,'Retail Sale Id 1144',0.00,2689.20,740.00,2997.00,307.80,'2023-01-19 17:42:26'),(1069,'1','308',1,'Retail Sale Id 1145',0.00,2656.00,740.00,2960.00,304.00,'2023-01-19 17:46:09'),(1070,'1','308',1,'Retail Sale Id 1146',0.00,1972.08,740.00,2197.80,225.72,'2023-01-19 17:47:42'),(1071,'1','308',1,'Retail Sale Id 1147',0.00,3320.00,740.00,3700.00,380.00,'2023-01-19 17:51:02'),(1072,'1','308',1,'Retail Sale Id 1148',0.00,2656.00,740.00,2960.00,304.00,'2023-01-19 17:56:09'),(1073,'1','308',1,'Retail Sale Id 1149',0.00,670.64,740.00,747.40,76.76,'2023-01-19 18:11:50'),(1074,'1','308',1,'Retail Sale Id 1150',0.00,3320.00,740.00,3700.00,380.00,'2023-01-19 18:12:51'),(1075,'1','308',1,'Retail Sale Id 1151',0.00,4037.12,740.00,4499.20,462.08,'2023-01-19 18:39:18'),(1076,'1','308',1,'Retail Sale Id 1152',0.00,16600.00,710.00,17750.00,1150.00,'2023-01-19 18:57:57'),(1077,'1','308',1,'Retail Sale Id 1153',0.00,1347.92,740.00,1502.20,154.28,'2023-01-19 19:08:14'),(1078,'1','308',1,'Retail Sale Id 1154',0.00,3984.00,740.00,4440.00,456.00,'2023-01-19 19:10:34'),(1079,'1','308',1,'Retail Sale Id 1155',0.00,132.80,740.00,148.00,15.20,'2023-01-19 19:32:21'),(1080,'1','308',1,'Retail Sale Id 1156',0.00,26560.00,710.00,28400.00,1840.00,'2023-01-20 07:36:59'),(1081,'1','308',1,'Retail Sale Id 1157',0.00,1347.92,740.00,1502.20,154.28,'2023-01-20 07:42:54'),(1082,'1','308',1,'Retail Sale Id 1158',0.00,7968.00,740.00,8880.00,912.00,'2023-01-20 08:21:52'),(1083,'1','308',1,'Retail Sale Id 1159',0.00,2656.00,740.00,2960.00,304.00,'2023-01-20 08:59:47'),(1084,'1','308',1,'Retail Sale Id 1160',0.00,19920.00,710.00,21300.00,1380.00,'2023-01-20 09:33:23'),(1085,'1','308',1,'Retail Sale Id 1161',0.00,1328.00,740.00,1480.00,152.00,'2023-01-20 09:36:29'),(1086,'1','308',1,'Retail Sale Id 1162',0.00,3984.00,740.00,4440.00,456.00,'2023-01-20 10:00:03'),(1087,'1','308',1,'Retail Sale Id 1163',0.00,896.40,740.00,999.00,102.60,'2023-01-20 10:05:21'),(1088,'1','308',1,'Retail Sale Id 1164',0.00,1347.92,740.00,1502.20,154.28,'2023-01-20 10:10:32'),(1089,'1','308',1,'Retail Sale Id 1165',0.00,3320.00,740.00,3700.00,380.00,'2023-01-20 10:45:33'),(1090,'1','308',1,'Retail Sale Id 1166',0.00,1992.00,740.00,2220.00,228.00,'2023-01-20 10:57:31'),(1091,'1','308',1,'Retail Sale Id 1167',0.00,1992.00,740.00,2220.00,228.00,'2023-01-20 11:00:16'),(1092,'1','308',1,'Retail Sale Id 1168',0.00,896.40,740.00,999.00,102.60,'2023-01-20 11:42:59'),(1093,'1','308',1,'Retail Sale Id 1169',0.00,4648.00,740.00,5180.00,532.00,'2023-01-20 11:48:28'),(1094,'1','308',1,'Retail Sale Id 1170',0.00,3984.00,740.00,4440.00,456.00,'2023-01-20 12:26:26'),(1095,'1','308',1,'Retail Sale Id 1171',0.00,1347.92,740.00,1502.20,154.28,'2023-01-20 12:44:04'),(1096,'1','308',1,'Retail Sale Id 1172',0.00,4648.00,740.00,5180.00,532.00,'2023-01-20 12:50:06'),(1097,'1','308',1,'Retail Sale Id 1173',0.00,4667.92,740.00,5202.20,534.28,'2023-01-20 12:51:43'),(1098,'1','308',1,'Retail Sale Id 1174',0.00,1992.00,740.00,2220.00,228.00,'2023-01-20 12:57:20'),(1099,'1','308',1,'Retail Sale Id 1175',0.00,3320.00,740.00,3700.00,380.00,'2023-01-20 13:10:05'),(1100,'1','308',1,'Retail Sale Id 1176',0.00,670.64,740.00,747.40,76.76,'2023-01-20 13:14:54'),(1101,'1','308',1,'Retail Sale Id 1177',0.00,1992.00,740.00,2220.00,228.00,'2023-01-20 13:31:32'),(1102,'1','308',1,'Retail Sale Id 1178',0.00,3984.00,740.00,4440.00,456.00,'2023-01-20 14:58:19'),(1103,'1','308',1,'Retail Sale Id 1179',0.00,7968.00,740.00,8880.00,912.00,'2023-01-20 15:15:41'),(1104,'1','308',1,'Retail Sale Id 1180',0.00,1328.00,740.00,1480.00,152.00,'2023-01-20 15:22:05'),(1105,'1','308',1,'Retail Sale Id 1181',0.00,3984.00,740.00,4440.00,456.00,'2023-01-20 15:54:34'),(1106,'1','308',1,'Retail Sale Id 1182',0.00,670.64,740.00,747.40,76.76,'2023-01-20 16:02:33'),(1107,'1','308',1,'Retail Sale Id 1183',0.00,3984.00,740.00,4440.00,456.00,'2023-01-20 16:24:00'),(1108,'1','308',1,'Retail Sale Id 1184',0.00,1998.64,740.00,2227.40,228.76,'2023-01-20 16:26:54'),(1109,'1','308',1,'Retail Sale Id 1185',0.00,2656.00,740.00,2960.00,304.00,'2023-01-20 16:39:06'),(1110,'1','308',1,'Retail Sale Id 1186',0.00,670.64,740.00,747.40,76.76,'2023-01-20 16:50:53'),(1111,'1','308',1,'Retail Sale Id 1187',0.00,2065.04,740.00,2301.40,236.36,'2023-01-20 17:03:40'),(1112,'1','308',1,'Retail Sale Id 1188',0.00,1347.92,740.00,1502.20,154.28,'2023-01-20 17:09:35'),(1113,'1','308',1,'Retail Sale Id 1189',0.00,896.40,740.00,999.00,102.60,'2023-01-20 17:21:49'),(1114,'1','308',1,'Return of Retail Sale Id 1169',4648.00,0.00,740.00,-5180.00,-532.00,'2023-01-20 17:30:44'),(1115,'1','308',1,'Retail Sale Id 1190',0.00,2018.56,740.00,2249.60,231.04,'2023-01-20 17:33:07'),(1116,'1','308',1,'Retail Sale Id 1191',0.00,3320.00,740.00,3700.00,380.00,'2023-01-20 17:35:40'),(1117,'1','308',1,'Retail Sale Id 1192',0.00,664.00,740.00,740.00,76.00,'2023-01-20 17:41:40'),(1118,'1','308',1,'Retail Sale Id 1194',0.00,2656.00,740.00,2960.00,304.00,'2023-01-20 17:43:46'),(1119,'1','308',1,'Retail Sale Id 1195',0.00,2018.56,740.00,2249.60,231.04,'2023-01-20 17:45:14'),(1120,'1','308',1,'Retail Sale Id 1196',0.00,3320.00,740.00,3700.00,380.00,'2023-01-20 17:55:53'),(1121,'1','308',1,'Retail Sale Id 1197',0.00,8074.24,740.00,8998.40,924.16,'2023-01-20 18:05:14'),(1122,'1','308',1,'Retail Sale Id 1198',0.00,2656.00,740.00,2960.00,304.00,'2023-01-20 18:09:11'),(1123,'1','308',1,'Retail Sale Id 1200',0.00,1347.92,740.00,1502.20,154.28,'2023-01-20 18:34:07'),(1124,'1','308',1,'Retail Sale Id 1201',0.00,4116.80,740.00,4588.00,471.20,'2023-01-20 19:09:16'),(1125,'1','308',1,'Return of Retail Sale Id 1201',4116.80,0.00,740.00,-4588.00,-471.20,'2023-01-20 19:10:09'),(1126,'1','308',1,'Retail Sale Id 1202',0.00,4083.60,740.00,4551.00,467.40,'2023-01-20 19:12:21'),(1127,'1','308',1,'Return of Retail Sale Id 1156',26560.00,0.00,710.00,-28400.00,-1840.00,'2023-01-20 19:29:36'),(1128,'1','308',1,'Retail Sale Id 1203',0.00,25896.00,710.00,27690.00,1794.00,'2023-01-20 19:34:00'),(1129,'1','308',1,'Return of Retail Sale Id 1203',25896.00,0.00,710.00,-27690.00,-1794.00,'2023-01-20 19:42:15'),(1130,'1','308',1,'Retail Sale Id 1204',0.00,26560.00,710.00,28400.00,1840.00,'2023-01-20 19:43:06'),(1131,'1','308',1,'Retail Sale Id 1205',0.00,3320.00,740.00,3700.00,380.00,'2023-01-21 07:29:28'),(1132,'1','308',1,'Retail Sale Id 1206',0.00,1347.92,740.00,1502.20,154.28,'2023-01-21 07:32:56'),(1133,'1','308',1,'Retail Sale Id 1207',0.00,5292.08,740.00,5897.80,605.72,'2023-01-21 07:39:00'),(1134,'1','308',1,'Retail Sale Id 1208',0.00,1992.00,740.00,2220.00,228.00,'2023-01-21 07:42:07'),(1135,'1','308',1,'Retail Sale Id 1209',0.00,1347.92,740.00,1502.20,154.28,'2023-01-21 07:58:57'),(1136,'1','308',1,'Retail Sale Id 1210',0.00,1792.80,740.00,1998.00,205.20,'2023-01-21 08:02:27'),(1137,'1','308',1,'Retail Sale Id 1211',0.00,1347.92,740.00,1502.20,154.28,'2023-01-21 08:06:34'),(1138,'1','308',1,'Retail Sale Id 1212',0.00,8300.00,740.00,9250.00,950.00,'2023-01-21 08:54:50'),(1139,'1','308',1,'Retail Sale Id 1213',0.00,1347.92,740.00,1502.20,154.28,'2023-01-21 08:56:50'),(1140,'1','308',1,'Retail Sale Id 1214',0.00,2324.00,740.00,2590.00,266.00,'2023-01-21 09:15:06'),(1141,'1','308',1,'Retail Sale Id 1215',0.00,9960.00,740.00,11100.00,1140.00,'2023-01-21 09:29:35'),(1142,'1','308',1,'Retail Sale Id 1216',0.00,1347.92,740.00,1502.20,154.28,'2023-01-21 09:48:35'),(1143,'1','308',1,'Retail Sale Id 1217',0.00,8300.00,740.00,9250.00,950.00,'2023-01-21 10:15:04'),(1144,'1','308',1,'Retail Sale Id 1218',0.00,1992.00,740.00,2220.00,228.00,'2023-01-21 10:25:53'),(1145,'1','308',1,'Retail Sale Id 1219',0.00,670.64,740.00,747.40,76.76,'2023-01-21 10:41:26'),(1146,'1','308',1,'Retail Sale Id 1220',0.00,3990.64,740.00,4447.40,456.76,'2023-01-21 11:09:48'),(1147,'1','308',1,'Retail Sale Id 1221',0.00,1998.64,740.00,2227.40,228.76,'2023-01-21 11:18:04'),(1148,'1','308',1,'Retail Sale Id 1222',0.00,1998.64,740.00,2227.40,228.76,'2023-01-21 11:44:20'),(1149,'1','308',1,'Retail Sale Id 1223',0.00,1347.92,740.00,1502.20,154.28,'2023-01-21 11:51:21'),(1150,'1','308',1,'Retail Sale Id 1224',0.00,1347.92,740.00,1502.20,154.28,'2023-01-21 12:05:48'),(1151,'1','308',1,'Retail Sale Id 1225',0.00,1992.00,740.00,2220.00,228.00,'2023-01-21 12:19:07'),(1152,'1','308',1,'Retail Sale Id 1226',0.00,2689.20,740.00,2997.00,307.80,'2023-01-21 12:39:00'),(1153,'1','308',1,'Retail Sale Id 1227',0.00,1347.92,740.00,1502.20,154.28,'2023-01-21 13:32:57'),(1154,'1','308',1,'Retail Sale Id 1228',0.00,26560.00,710.00,28400.00,1840.00,'2023-01-21 13:53:42'),(1155,'1','308',1,'Retail Sale Id 1229',0.00,13944.00,710.00,14910.00,966.00,'2023-01-21 13:55:12'),(1156,'1','308',1,'Retail Sale Id 1230',0.00,3990.64,740.00,4447.40,456.76,'2023-01-21 14:25:02'),(1157,'1','308',1,'Retail Sale Id 1231',0.00,1992.00,740.00,2220.00,228.00,'2023-01-21 14:43:43'),(1158,'1','308',1,'Retail Sale Id 1232',0.00,2689.20,740.00,2997.00,307.80,'2023-01-21 14:48:08'),(1159,'1','308',1,'Retail Sale Id 1233',0.00,670.64,740.00,747.40,76.76,'2023-01-21 14:50:56'),(1160,'1','308',1,'Retail Sale Id 1234',0.00,2689.20,740.00,2997.00,307.80,'2023-01-21 14:54:20'),(1161,'1','308',1,'Retail Sale Id 1235',0.00,6640.00,740.00,7400.00,760.00,'2023-01-21 15:00:46'),(1162,'1','308',1,'Retail Sale Id 1236',0.00,3990.64,740.00,4447.40,456.76,'2023-01-21 15:05:58'),(1163,'1','308',1,'Retail Sale Id 1237',0.00,717.12,740.00,799.20,82.08,'2023-01-21 15:08:58'),(1164,'1','308',1,'Retail Sale Id 1238',0.00,1992.00,740.00,2220.00,228.00,'2023-01-21 15:12:35'),(1165,'1','308',1,'Retail Sale Id 1239',0.00,3320.00,740.00,3700.00,380.00,'2023-01-21 15:22:15'),(1166,'1','308',1,'Retail Sale Id 1240',0.00,3320.00,740.00,3700.00,380.00,'2023-01-21 15:32:20'),(1167,'1','308',1,'Retail Sale Id 1241',0.00,16600.00,710.00,17750.00,1150.00,'2023-01-21 15:41:02'),(1168,'1','308',1,'Retail Sale Id 1242',0.00,16600.00,710.00,17750.00,1150.00,'2023-01-21 15:42:51'),(1169,'1','308',1,'Return of Retail Sale Id 1241',16600.00,0.00,710.00,-17750.00,-1150.00,'2023-01-21 15:43:33'),(1170,'1','308',1,'Retail Sale Id 1243',0.00,8300.00,740.00,9250.00,950.00,'2023-01-21 16:10:35'),(1171,'1','308',1,'Retail Sale Id 1244',0.00,1347.92,740.00,1502.20,154.28,'2023-01-21 16:11:49'),(1172,'1','308',1,'Retail Sale Id 1245',0.00,2689.20,740.00,2997.00,307.80,'2023-01-21 16:41:31'),(1173,'1','308',1,'Retail Sale Id 1246',0.00,1992.00,740.00,2220.00,228.00,'2023-01-21 16:59:28'),(1174,'1','308',1,'Retail Sale Id 1247',0.00,670.64,740.00,747.40,76.76,'2023-01-21 17:07:26'),(1175,'1','308',1,'Retail Sale Id 1248',0.00,1347.92,740.00,1502.20,154.28,'2023-01-21 17:25:59'),(1176,'1','308',1,'Retail Sale Id 1249',0.00,451.52,740.00,503.20,51.68,'2023-01-21 17:44:04'),(1177,'1','308',1,'Retail Sale Id 1250',0.00,1347.92,740.00,1502.20,154.28,'2023-01-21 17:55:51'),(1178,'1','308',1,'Retail Sale Id 1251',0.00,2129.40,740.00,2501.20,371.80,'2023-01-21 18:02:25'),(1179,'1','308',1,'Retail Sale Id 1252',0.00,636.30,740.00,747.40,111.10,'2023-01-21 18:03:49'),(1180,'1','308',1,'Retail Sale Id 1253',0.00,737.10,710.00,830.70,93.60,'2023-01-21 19:13:40'),(1181,'1','308',1,'Retail Sale Id 1254',0.00,516.60,740.00,606.80,90.20,'2023-01-21 19:14:23'),(1182,'1','308',1,'Retail Sale Id 1255',0.00,850.50,740.00,999.00,148.50,'2023-01-22 07:30:40'),(1183,'1','308',1,'Retail Sale Id 1256',0.00,428.40,740.00,503.20,74.80,'2023-01-22 07:36:45'),(1184,'1','308',1,'Retail Sale Id 1257',0.00,1915.20,740.00,2249.60,334.40,'2023-01-22 07:40:16'),(1185,'1','308',1,'Retail Sale Id 1258',0.00,3786.30,740.00,4447.40,661.10,'2023-01-22 07:43:56'),(1186,'1','308',1,'Retail Sale Id 1259',0.00,636.30,740.00,747.40,111.10,'2023-01-22 07:45:27'),(1187,'1','308',1,'Retail Sale Id 1260',0.00,1278.90,740.00,1502.20,223.30,'2023-01-22 08:01:39'),(1188,'1','308',1,'Retail Sale Id 1261',0.00,2551.50,740.00,2997.00,445.50,'2023-01-22 08:12:21'),(1189,'1','308',1,'Retail Sale Id 1262',0.00,1278.90,740.00,1502.20,223.30,'2023-01-22 08:13:09'),(1190,'1','308',1,'Retail Sale Id 1263',0.00,1278.90,740.00,1502.20,223.30,'2023-01-22 08:28:19'),(1191,'1','308',1,'Retail Sale Id 1264',0.00,680.40,740.00,799.20,118.80,'2023-01-22 08:30:08'),(1192,'1','308',1,'Retail Sale Id 1265',0.00,1278.90,740.00,1502.20,223.30,'2023-01-22 08:46:52'),(1193,'1','308',1,'Retail Sale Id 1266',0.00,3786.30,740.00,4447.40,661.10,'2023-01-22 08:57:25'),(1194,'1','308',1,'Retail Sale Id 1267',0.00,1890.00,740.00,2220.00,330.00,'2023-01-22 09:00:13'),(1195,'1','308',1,'Retail Sale Id 1268',0.00,5040.00,740.00,5920.00,880.00,'2023-01-22 09:32:07'),(1196,'1','308',1,'Retail Sale Id 1269',0.00,1915.20,740.00,2249.60,334.40,'2023-01-22 09:37:00'),(1197,'1','308',1,'Retail Sale Id 1270',0.00,1278.90,740.00,1502.20,223.30,'2023-01-22 09:40:26'),(1198,'1','308',1,'Retail Sale Id 1271',0.00,1278.90,740.00,1502.20,223.30,'2023-01-22 09:47:25'),(1199,'1','308',1,'Retail Sale Id 1272',0.00,3786.30,740.00,4447.40,661.10,'2023-01-22 09:54:06'),(1200,'1','308',1,'Retail Sale Id 1273',0.00,1890.00,740.00,2220.00,330.00,'2023-01-22 10:16:55'),(1201,'1','308',1,'Retail Sale Id 1274',0.00,3786.30,740.00,4447.40,661.10,'2023-01-22 10:26:43'),(1202,'1','308',1,'Retail Sale Id 1275',0.00,2538.90,740.00,2982.20,443.30,'2023-01-22 10:28:30'),(1203,'1','308',1,'Retail Sale Id 1276',0.00,3786.30,740.00,4447.40,661.10,'2023-01-22 10:32:36'),(1204,'1','308',1,'Retail Sale Id 1277',0.00,636.30,740.00,747.40,111.10,'2023-01-22 10:37:12'),(1205,'1','308',1,'Retail Sale Id 1278',0.00,3150.00,740.00,3700.00,550.00,'2023-01-22 10:39:06'),(1206,'1','308',1,'Retail Sale Id 1279',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-22 10:59:56'),(1207,'1','308',1,'Retail Sale Id 1280',0.00,1890.00,740.00,2220.00,330.00,'2023-01-22 11:13:29'),(1208,'1','308',1,'Retail Sale Id 1281',0.00,630.00,740.00,740.00,110.00,'2023-01-22 11:15:11'),(1209,'1','308',1,'Retail Sale Id 1282',0.00,3150.00,740.00,3700.00,550.00,'2023-01-22 11:19:54'),(1210,'1','308',1,'Retail Sale Id 1283',0.00,1260.00,740.00,1480.00,220.00,'2023-01-22 11:21:41'),(1211,'1','308',1,'Retail Sale Id 1284',0.00,3786.30,740.00,4447.40,661.10,'2023-01-22 11:49:45'),(1212,'1','308',1,'Retail Sale Id 1285',0.00,630.00,740.00,740.00,110.00,'2023-01-22 12:07:06'),(1213,'1','308',1,'Retail Sale Id 1286',0.00,630.00,740.00,740.00,110.00,'2023-01-22 12:09:22'),(1214,'1','308',1,'Retail Sale Id 1287',0.00,34650.00,700.00,38500.00,3850.00,'2023-01-22 12:26:03'),(1215,'1','308',1,'Retail Sale Id 1288',0.00,1260.00,740.00,1480.00,220.00,'2023-01-22 12:55:17'),(1216,'1','308',1,'Retail Sale Id 1289',0.00,3780.00,740.00,4440.00,660.00,'2023-01-22 12:56:24'),(1217,'1','308',1,'Retail Sale Id 1290',0.00,3780.00,740.00,4440.00,660.00,'2023-01-22 12:57:41'),(1218,'1','308',1,'Retail Sale Id 1291',0.00,850.50,740.00,999.00,148.50,'2023-01-22 13:05:57'),(1219,'1','308',1,'Retail Sale Id 1292',0.00,3150.00,740.00,3700.00,550.00,'2023-01-22 13:19:01'),(1220,'1','308',1,'Retail Sale Id 1293',0.00,3780.00,740.00,4440.00,660.00,'2023-01-22 13:45:05'),(1221,'1','308',1,'Retail Sale Id 1294',0.00,1890.00,740.00,2220.00,330.00,'2023-01-22 13:47:03'),(1222,'1','308',1,'Retail Sale Id 1295',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-22 14:03:07'),(1223,'1','308',1,'Retail Sale Id 1296',0.00,1890.00,740.00,2220.00,330.00,'2023-01-22 14:09:42'),(1224,'1','308',1,'Retail Sale Id 1297',0.00,630.00,740.00,740.00,110.00,'2023-01-22 14:11:12'),(1225,'1','308',1,'Retail Sale Id 1298',0.00,1260.00,740.00,1480.00,220.00,'2023-01-22 14:15:03'),(1226,'1','308',1,'Retail Sale Id 1299',0.00,4258.80,740.00,5002.40,743.60,'2023-01-22 14:30:32'),(1227,'1','308',1,'Retail Sale Id 1300',0.00,3780.00,740.00,4440.00,660.00,'2023-01-22 14:40:30'),(1228,'1','308',1,'Retail Sale Id 1301',0.00,1890.00,740.00,2220.00,330.00,'2023-01-22 14:42:28'),(1229,'1','308',1,'Retail Sale Id 1302',0.00,630.00,740.00,740.00,110.00,'2023-01-22 14:44:37'),(1230,'1','308',1,'Retail Sale Id 1303',0.00,1260.00,740.00,1480.00,220.00,'2023-01-22 14:54:25'),(1231,'1','308',1,'Retail Sale Id 1304',0.00,3150.00,740.00,3700.00,550.00,'2023-01-22 15:04:14'),(1232,'1','308',1,'Retail Sale Id 1305',0.00,1260.00,740.00,1480.00,220.00,'2023-01-22 15:06:20'),(1233,'1','308',1,'Retail Sale Id 1306',0.00,1890.00,740.00,2220.00,330.00,'2023-01-22 15:10:17'),(1234,'1','308',1,'Retail Sale Id 1307',0.00,2979.90,740.00,3500.20,520.30,'2023-01-22 15:13:07'),(1235,'1','308',1,'Retail Sale Id 1308',0.00,1260.00,740.00,1480.00,220.00,'2023-01-22 15:29:08'),(1236,'1','308',1,'Retail Sale Id 1309',0.00,2129.40,740.00,2501.20,371.80,'2023-01-22 16:36:47'),(1237,'1','308',1,'Retail Sale Id 1310',0.00,3780.00,740.00,4440.00,660.00,'2023-01-22 16:46:49'),(1238,'1','308',1,'Retail Sale Id 1311',0.00,636.30,740.00,747.40,111.10,'2023-01-22 16:56:17'),(1239,'1','308',1,'Retail Sale Id 1312',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-22 16:57:23'),(1240,'1','308',1,'Retail Sale Id 1313',0.00,1890.00,740.00,2220.00,330.00,'2023-01-22 17:12:35'),(1241,'1','308',1,'Retail Sale Id 1314',0.00,1260.00,740.00,1480.00,220.00,'2023-01-22 17:30:46'),(1242,'1','308',1,'Retail Sale Id 1315',0.00,1890.00,740.00,2220.00,330.00,'2023-01-22 17:32:51'),(1243,'1','308',1,'Retail Sale Id 1316',0.00,1260.00,740.00,1480.00,220.00,'2023-01-22 17:34:45'),(1244,'1','308',1,'Retail Sale Id 1317',0.00,3780.00,740.00,4440.00,660.00,'2023-01-22 17:39:32'),(1245,'1','308',1,'Retail Sale Id 1317',0.00,3780.00,740.00,4440.00,660.00,'2023-01-22 17:39:32'),(1246,'1','308',1,'Retail Sale Id 1318',0.00,636.30,740.00,747.40,111.10,'2023-01-22 17:41:14'),(1247,'1','308',1,'Retail Sale Id 1319',0.00,1278.90,740.00,1502.20,223.30,'2023-01-22 17:58:10'),(1248,'1','308',1,'Retail Sale Id 1320',0.00,6300.00,740.00,7400.00,1100.00,'2023-01-22 17:59:44'),(1249,'1','308',1,'Retail Sale Id 1321',0.00,636.30,740.00,747.40,111.10,'2023-01-22 18:06:26'),(1250,'1','308',1,'Retail Sale Id 1322',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-22 18:08:56'),(1251,'1','308',1,'Retail Sale Id 1323',0.00,1701.00,740.00,1998.00,297.00,'2023-01-22 18:34:51'),(1252,'1','308',1,'Retail Sale Id 1324',0.00,2520.00,740.00,2960.00,440.00,'2023-01-22 18:36:58'),(1253,'1','308',1,'Retail Sale Id 1325',0.00,3780.00,740.00,4440.00,660.00,'2023-01-22 18:42:23'),(1254,'1','308',1,'Retail Sale Id 1325',0.00,3780.00,740.00,4440.00,660.00,'2023-01-22 18:42:23'),(1255,'1','308',1,'Retail Sale Id 1326',0.00,3780.00,740.00,4440.00,660.00,'2023-01-22 18:44:33'),(1256,'1','308',1,'Retail Sale Id 1327',0.00,7660.80,740.00,8998.40,1337.60,'2023-01-22 18:47:23'),(1257,'1','308',1,'Retail Sale Id 1328',0.00,636.30,740.00,747.40,111.10,'2023-01-22 18:49:28'),(1258,'1','308',1,'Retail Sale Id 1329',0.00,3830.40,740.00,4499.20,668.80,'2023-01-22 18:51:18'),(1259,'1','308',1,'Retail Sale Id 1330',0.00,2520.00,740.00,2960.00,440.00,'2023-01-23 07:29:11'),(1260,'1','308',1,'Retail Sale Id 1331',0.00,1890.00,740.00,2220.00,330.00,'2023-01-23 07:37:35'),(1261,'1','308',1,'Retail Sale Id 1332',0.00,3150.00,740.00,3700.00,550.00,'2023-01-23 07:39:27'),(1262,'1','308',1,'Retail Sale Id 1333',0.00,15435.00,700.00,17150.00,1715.00,'2023-01-23 07:51:40'),(1263,'1','308',1,'Retail Sale Id 1334',0.00,3780.00,740.00,4440.00,660.00,'2023-01-23 07:56:38'),(1264,'1','308',1,'Retail Sale Id 1335',0.00,1871.10,740.00,2197.80,326.70,'2023-01-23 07:59:54'),(1265,'1','308',1,'Retail Sale Id 1336',0.00,3150.00,740.00,3700.00,550.00,'2023-01-23 08:17:21'),(1266,'1','308',1,'Retail Sale Id 1338',0.00,1890.00,740.00,2220.00,330.00,'2023-01-23 08:53:27'),(1267,'1','308',1,'Retail Sale Id 1339',0.00,3780.00,740.00,4440.00,660.00,'2023-01-23 09:27:45'),(1268,'1','308',1,'Retail Sale Id 1340',0.00,2520.00,740.00,2960.00,440.00,'2023-01-23 09:30:13'),(1269,'1','308',1,'Retail Sale Id 1341',0.00,3780.00,740.00,4440.00,660.00,'2023-01-23 09:31:39'),(1270,'1','308',1,'Retail Sale Id 1342',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-23 09:46:14'),(1271,'1','308',1,'Retail Sale Id 1343',0.00,630.00,740.00,740.00,110.00,'2023-01-23 11:31:17'),(1272,'1','308',1,'Retail Sale Id 1344',0.00,1701.00,740.00,1998.00,297.00,'2023-01-23 11:56:44'),(1273,'1','308',1,'Retail Sale Id 1345',0.00,630.00,740.00,740.00,110.00,'2023-01-23 11:58:00'),(1274,'1','308',1,'Retail Sale Id 1346',0.00,1260.00,740.00,1480.00,220.00,'2023-01-23 12:04:08'),(1275,'1','308',1,'Retail Sale Id 1347',0.00,1278.90,740.00,1502.20,223.30,'2023-01-23 12:52:51'),(1276,'1','308',1,'Retail Sale Id 1348',0.00,1890.00,740.00,2220.00,330.00,'2023-01-23 12:55:53'),(1277,'1','308',1,'Retail Sale Id 1349',0.00,1890.00,740.00,2220.00,330.00,'2023-01-23 13:52:43'),(1278,'1','308',1,'Retail Sale Id 1350',0.00,850.50,740.00,999.00,148.50,'2023-01-23 14:07:58'),(1279,'1','308',1,'Retail Sale Id 1351',0.00,428.40,740.00,503.20,74.80,'2023-01-23 14:09:22'),(1280,'1','308',1,'Retail Sale Id 1352',0.00,3780.00,740.00,4440.00,660.00,'2023-01-23 14:31:26'),(1281,'1','308',1,'Retail Sale Id 1354',0.00,3780.00,740.00,4440.00,660.00,'2023-01-23 14:58:43'),(1282,'1','308',1,'Retail Sale Id 1355',0.00,1890.00,740.00,2220.00,330.00,'2023-01-23 15:51:03'),(1283,'1','308',1,'Retail Sale Id 1356',0.00,2211.30,740.00,2597.40,386.10,'2023-01-23 16:07:55'),(1284,'1','308',1,'Retail Sale Id 1357',0.00,1278.90,740.00,1502.20,223.30,'2023-01-23 16:13:32'),(1285,'1','308',1,'Retail Sale Id 1358',0.00,1260.00,740.00,1480.00,220.00,'2023-01-23 16:19:01'),(1286,'1','308',1,'Retail Sale Id 1359',0.00,3150.00,740.00,3700.00,550.00,'2023-01-23 16:32:03'),(1287,'1','308',1,'Retail Sale Id 1360',0.00,1890.00,740.00,2220.00,330.00,'2023-01-23 16:38:09'),(1288,'1','308',1,'Retail Sale Id 1361',0.00,1890.00,740.00,2220.00,330.00,'2023-01-23 16:41:41'),(1289,'1','308',1,'Retail Sale Id 1362',0.00,1896.30,740.00,2227.40,331.10,'2023-01-23 16:44:52'),(1290,'1','308',1,'Retail Sale Id 1363',0.00,1260.00,740.00,1480.00,220.00,'2023-01-23 16:48:19'),(1291,'1','308',1,'Retail Sale Id 1364',0.00,1260.00,740.00,1480.00,220.00,'2023-01-23 16:57:08'),(1292,'1','308',1,'Retail Sale Id 1365',0.00,1278.90,740.00,1502.20,223.30,'2023-01-23 17:06:38'),(1293,'1','308',1,'Retail Sale Id 1366',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-23 17:19:18'),(1294,'1','308',1,'Retail Sale Id 1367',0.00,1278.90,740.00,1502.20,223.30,'2023-01-23 17:21:01'),(1295,'1','308',1,'Retail Sale Id 1369',0.00,1701.00,740.00,1998.00,297.00,'2023-01-23 17:30:12'),(1296,'1','308',1,'Retail Sale Id 1370',0.00,636.30,740.00,747.40,111.10,'2023-01-23 17:35:05'),(1297,'1','308',1,'Retail Sale Id 1371',0.00,1871.10,740.00,2197.80,326.70,'2023-01-23 17:38:35'),(1298,'1','308',1,'Retail Sale Id 1372',0.00,3780.00,740.00,4440.00,660.00,'2023-01-23 17:47:52'),(1299,'1','308',1,'Retail Sale Id 1373',0.00,1915.20,740.00,2249.60,334.40,'2023-01-23 17:50:05'),(1300,'1','308',1,'Retail Sale Id 1374',0.00,3780.00,740.00,4440.00,660.00,'2023-01-23 17:54:00'),(1301,'1','308',1,'Retail Sale Id 1376',0.00,3150.00,740.00,3700.00,550.00,'2023-01-23 17:59:20'),(1302,'1','308',1,'Retail Sale Id 1378',0.00,1871.10,740.00,2197.80,326.70,'2023-01-23 18:04:27'),(1303,'1','308',1,'Retail Sale Id 1379',0.00,636.30,740.00,747.40,111.10,'2023-01-23 18:05:51'),(1304,'1','308',1,'Retail Sale Id 1380',0.00,4410.00,740.00,5180.00,770.00,'2023-01-23 18:07:31'),(1305,'1','308',1,'Retail Sale Id 1381',0.00,1260.00,740.00,1480.00,220.00,'2023-01-23 18:19:56'),(1306,'1','308',1,'Retail Sale Id 1382',0.00,1915.20,740.00,2249.60,334.40,'2023-01-23 18:33:48'),(1307,'1','308',1,'Retail Sale Id 1383',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-23 18:35:17'),(1308,'1','308',1,'Retail Sale Id 1384',0.00,1890.00,740.00,2220.00,330.00,'2023-01-23 18:36:26'),(1309,'1','308',1,'Retail Sale Id 1385',0.00,1890.00,740.00,2220.00,330.00,'2023-01-23 18:38:51'),(1310,'1','308',1,'Retail Sale Id 1386',0.00,1890.00,740.00,2220.00,330.00,'2023-01-23 18:45:39'),(1311,'1','308',1,'Retail Sale Id 1387',0.00,3729.60,740.00,4380.80,651.20,'2023-01-23 19:14:47'),(1312,'1','308',1,'Retail Sale Id 1388',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-24 07:27:09'),(1313,'1','308',1,'Retail Sale Id 1389',0.00,3780.00,740.00,4440.00,660.00,'2023-01-24 07:41:12'),(1314,'1','308',1,'Retail Sale Id 1390',0.00,1278.90,740.00,1502.20,223.30,'2023-01-24 07:56:25'),(1315,'1','308',1,'Retail Sale Id 1391',0.00,1890.00,740.00,2220.00,330.00,'2023-01-24 08:03:26'),(1316,'1','308',1,'Retail Sale Id 1392',0.00,1278.90,740.00,1502.20,223.30,'2023-01-24 08:21:00'),(1317,'1','308',1,'Retail Sale Id 1393',0.00,1278.90,740.00,1502.20,223.30,'2023-01-24 08:33:27'),(1318,'1','308',1,'Retail Sale Id 1394',0.00,3780.00,740.00,4440.00,660.00,'2023-01-24 08:42:54'),(1319,'1','308',1,'Retail Sale Id 1395',0.00,1871.10,740.00,2197.80,326.70,'2023-01-24 09:11:17'),(1320,'1','308',1,'Retail Sale Id 1396',0.00,37800.00,700.00,42000.00,4200.00,'2023-01-24 09:57:52'),(1321,'1','308',1,'Retail Sale Id 1397',0.00,3150.00,740.00,3700.00,550.00,'2023-01-24 10:32:38'),(1322,'1','308',1,'Retail Sale Id 1398',0.00,2520.00,740.00,2960.00,440.00,'2023-01-24 10:48:10'),(1323,'1','308',1,'Retail Sale Id 1399',0.00,3150.00,740.00,3700.00,550.00,'2023-01-24 11:08:26'),(1324,'1','308',1,'Retail Sale Id 1400',0.00,2551.50,740.00,2997.00,445.50,'2023-01-24 11:13:04'),(1325,'1','308',1,'Retail Sale Id 1401',0.00,3150.00,740.00,3700.00,550.00,'2023-01-24 11:42:14'),(1326,'1','308',1,'Retail Sale Id 1402',0.00,2551.50,740.00,2997.00,445.50,'2023-01-24 11:51:04'),(1327,'1','308',1,'Retail Sale Id 1403',0.00,1278.90,740.00,1502.20,223.30,'2023-01-24 11:58:27'),(1328,'1','308',1,'Retail Sale Id 1404',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-24 12:09:02'),(1329,'1','308',1,'Retail Sale Id 1405',0.00,1890.00,740.00,2220.00,330.00,'2023-01-24 12:14:58'),(1330,'1','308',1,'Retail Sale Id 1406',0.00,428.40,740.00,503.20,74.80,'2023-01-24 12:49:54'),(1331,'1','308',1,'Retail Sale Id 1407',0.00,1278.90,740.00,1502.20,223.30,'2023-01-24 13:34:31'),(1332,'1','308',1,'Retail Sale Id 1408',0.00,1890.00,740.00,2220.00,330.00,'2023-01-24 13:36:20'),(1333,'1','308',1,'Retail Sale Id 1409',0.00,1278.90,740.00,1502.20,223.30,'2023-01-24 14:06:14'),(1334,'1','308',1,'Retail Sale Id 1410',0.00,1890.00,740.00,2220.00,330.00,'2023-01-24 14:11:52'),(1335,'1','308',1,'Retail Sale Id 1411',0.00,1890.00,740.00,2220.00,330.00,'2023-01-24 14:35:36'),(1336,'1','308',1,'Retail Sale Id 1412',0.00,3786.30,740.00,4447.40,661.10,'2023-01-24 14:38:55'),(1337,'1','308',1,'Retail Sale Id 1413',0.00,7560.00,740.00,8880.00,1320.00,'2023-01-24 14:49:55'),(1338,'1','308',1,'Retail Sale Id 1414',0.00,680.40,740.00,799.20,118.80,'2023-01-24 15:16:30'),(1339,'1','308',1,'Retail Sale Id 1415',0.00,1278.90,740.00,1502.20,223.30,'2023-01-24 15:30:33'),(1340,'1','308',1,'Retail Sale Id 1416',0.00,850.50,740.00,999.00,148.50,'2023-01-24 15:49:53'),(1341,'1','308',1,'Retail Sale Id 1417',0.00,3786.30,740.00,4447.40,661.10,'2023-01-24 16:24:31'),(1342,'1','308',1,'Retail Sale Id 1418',0.00,2520.00,740.00,2960.00,440.00,'2023-01-24 16:43:00'),(1343,'1','308',1,'Retail Sale Id 1419',0.00,1278.90,740.00,1502.20,223.30,'2023-01-24 16:51:08'),(1344,'1','308',1,'Retail Sale Id 1420',0.00,630.00,740.00,740.00,110.00,'2023-01-24 16:56:37'),(1345,'1','308',1,'Retail Sale Id 1421',0.00,1890.00,740.00,2220.00,330.00,'2023-01-24 17:00:58'),(1346,'1','308',1,'Retail Sale Id 1422',0.00,1260.00,740.00,1480.00,220.00,'2023-01-24 17:03:57'),(1347,'1','308',1,'Retail Sale Id 1423',0.00,630.00,740.00,740.00,110.00,'2023-01-24 17:05:15'),(1348,'1','308',1,'Retail Sale Id 1424',0.00,2520.00,740.00,2960.00,440.00,'2023-01-24 17:09:54'),(1349,'1','308',1,'Retail Sale Id 1425',0.00,1871.10,740.00,2197.80,326.70,'2023-01-24 17:21:06'),(1350,'1','308',1,'Retail Sale Id 1426',0.00,1278.90,740.00,1502.20,223.30,'2023-01-24 17:29:42'),(1351,'1','308',1,'Retail Sale Id 1427',0.00,1278.90,740.00,1502.20,223.30,'2023-01-24 17:32:34'),(1352,'1','308',1,'Retail Sale Id 1428',0.00,3150.00,740.00,3700.00,550.00,'2023-01-24 17:34:31'),(1353,'1','308',1,'Retail Sale Id 1429',0.00,25200.00,700.00,28000.00,2800.00,'2023-01-24 17:41:31'),(1354,'1','308',1,'Retail Sale Id 1430',0.00,2513.70,740.00,2952.60,438.90,'2023-01-24 17:51:37'),(1355,'1','308',1,'Retail Sale Id 1431',0.00,630.00,740.00,740.00,110.00,'2023-01-24 17:54:35'),(1356,'1','308',1,'Retail Sale Id 1432',0.00,1266.30,740.00,1487.40,221.10,'2023-01-24 18:00:44'),(1357,'1','308',1,'Retail Sale Id 1433',0.00,1278.90,740.00,1502.20,223.30,'2023-01-24 18:07:17'),(1358,'1','308',1,'Retail Sale Id 1434',0.00,2551.50,740.00,2997.00,445.50,'2023-01-24 18:19:33'),(1359,'1','308',1,'Retail Sale Id 1435',0.00,1890.00,740.00,2220.00,330.00,'2023-01-24 18:25:54'),(1360,'1','308',1,'Retail Sale Id 1436',0.00,768.60,740.00,902.80,134.20,'2023-01-24 18:28:01'),(1361,'1','308',1,'Retail Sale Id 1437',0.00,3786.30,740.00,4447.40,661.10,'2023-01-24 18:33:33'),(1362,'1','308',1,'Retail Sale Id 1438',0.00,1278.90,740.00,1502.20,223.30,'2023-01-24 18:34:35'),(1363,'1','308',1,'Retail Sale Id 1439',0.00,2564.10,740.00,3011.80,447.70,'2023-01-24 19:28:13'),(1364,'1','308',1,'Retail Sale Id 1440',0.00,2551.50,740.00,2997.00,445.50,'2023-01-25 07:33:20'),(1365,'1','308',1,'Retail Sale Id 1441',0.00,630.00,740.00,740.00,110.00,'2023-01-25 07:42:46'),(1366,'1','308',1,'Retail Sale Id 1442',0.00,648.90,740.00,762.20,113.30,'2023-01-25 07:45:24'),(1367,'1','308',1,'Retail Sale Id 1443',0.00,630.00,750.00,750.00,120.00,'2023-01-25 08:00:44'),(1368,'1','308',1,'Retail Sale Id 1444',0.00,2551.50,740.00,2997.00,445.50,'2023-01-25 08:04:22'),(1369,'1','308',1,'Retail Sale Id 1445',0.00,1890.00,740.00,2220.00,330.00,'2023-01-25 08:24:29'),(1370,'1','308',1,'Retail Sale Id 1446',0.00,3150.00,740.00,3700.00,550.00,'2023-01-25 08:58:44'),(1371,'1','308',1,'Retail Sale Id 1447',0.00,1530.90,740.00,1798.20,267.30,'2023-01-25 09:07:45'),(1372,'1','308',1,'Retail Sale Id 1448',0.00,2538.90,740.00,2982.20,443.30,'2023-01-25 09:09:37'),(1373,'1','308',1,'Retail Sale Id 1449',0.00,3150.00,740.00,3700.00,550.00,'2023-01-25 09:54:56'),(1374,'1','308',1,'Retail Sale Id 1450',0.00,3786.30,740.00,4447.40,661.10,'2023-01-25 10:12:45'),(1375,'1','308',1,'Retail Sale Id 1451',0.00,1260.00,740.00,1480.00,220.00,'2023-01-25 10:41:52'),(1376,'1','308',1,'Retail Sale Id 1452',0.00,1278.90,740.00,1502.20,223.30,'2023-01-25 10:44:23'),(1377,'1','308',1,'Retail Sale Id 1453',0.00,1789.20,740.00,2101.60,312.40,'2023-01-25 10:46:08'),(1378,'1','308',1,'Retail Sale Id 1454',0.00,1890.00,740.00,2220.00,330.00,'2023-01-25 10:47:16'),(1379,'1','308',1,'Retail Sale Id 1455',0.00,850.50,740.00,999.00,148.50,'2023-01-25 11:46:17'),(1380,'1','308',1,'Retail Sale Id 1456',0.00,850.50,740.00,999.00,148.50,'2023-01-25 14:06:03'),(1381,'1','308',1,'Retail Sale Id 1457',0.00,3780.00,740.00,4440.00,660.00,'2023-01-25 14:40:09'),(1382,'1','308',1,'Retail Sale Id 1458',0.00,2520.00,740.00,2960.00,440.00,'2023-01-25 14:42:39'),(1383,'1','308',1,'Retail Sale Id 1459',0.00,3150.00,740.00,3700.00,550.00,'2023-01-25 14:55:55'),(1384,'1','308',1,'Retail Sale Id 1460',0.00,1278.90,740.00,1502.20,223.30,'2023-01-25 15:29:36'),(1385,'1','308',1,'Retail Sale Id 1461',0.00,636.30,740.00,747.40,111.10,'2023-01-25 15:53:02'),(1386,'1','308',1,'Retail Sale Id 1462',0.00,850.50,740.00,999.00,148.50,'2023-01-25 15:53:58'),(1387,'1','308',1,'Retail Sale Id 1463',0.00,3786.30,740.00,4447.40,661.10,'2023-01-25 16:04:24'),(1388,'1','308',1,'Retail Sale Id 1464',0.00,2520.00,740.00,2960.00,440.00,'2023-01-25 16:20:05'),(1389,'1','308',1,'Retail Sale Id 1465',0.00,7578.90,740.00,8902.20,1323.30,'2023-01-25 16:22:46'),(1390,'1','308',1,'Retail Sale Id 1466',0.00,3150.00,740.00,3700.00,550.00,'2023-01-25 16:28:28'),(1391,'1','308',1,'Retail Sale Id 1467',0.00,2520.00,740.00,2960.00,440.00,'2023-01-25 16:44:03'),(1392,'1','308',1,'Retail Sale Id 1468',0.00,3150.00,740.00,3700.00,550.00,'2023-01-25 16:46:12'),(1393,'1','308',1,'Retail Sale Id 1469',0.00,3150.00,740.00,3700.00,550.00,'2023-01-25 16:50:20'),(1394,'1','308',1,'Retail Sale Id 1470',0.00,2520.00,740.00,2960.00,440.00,'2023-01-25 16:54:03'),(1395,'1','308',1,'Retail Sale Id 1471',0.00,1278.90,740.00,1502.20,223.30,'2023-01-25 16:59:02'),(1396,'1','308',1,'Retail Sale Id 1472',0.00,3150.00,740.00,3700.00,550.00,'2023-01-25 17:01:45'),(1397,'1','308',1,'Retail Sale Id 1473',0.00,1278.90,740.00,1502.20,223.30,'2023-01-25 17:06:42'),(1398,'1','308',1,'Retail Sale Id 1474',0.00,1278.90,740.00,1502.20,223.30,'2023-01-25 17:16:37'),(1399,'1','308',1,'Retail Sale Id 1475',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-25 17:21:47'),(1400,'1','308',1,'Retail Sale Id 1476',0.00,63000.00,700.00,70000.00,7000.00,'2023-01-25 17:26:07'),(1401,'1','308',1,'Retail Sale Id 1477',0.00,1890.00,740.00,2220.00,330.00,'2023-01-25 17:35:11'),(1402,'1','308',1,'Retail Sale Id 1478',0.00,1915.20,740.00,2249.60,334.40,'2023-01-25 17:41:25'),(1403,'1','308',1,'Retail Sale Id 1479',0.00,1959.30,740.00,2301.40,342.10,'2023-01-25 17:48:30'),(1404,'1','308',1,'Retail Sale Id 1480',0.00,1278.90,740.00,1502.20,223.30,'2023-01-25 17:50:45'),(1405,'1','308',1,'Retail Sale Id 1481',0.00,3150.00,740.00,3700.00,550.00,'2023-01-25 17:51:55'),(1406,'1','308',1,'Retail Sale Id 1482',0.00,18944.10,740.00,22251.80,3307.70,'2023-01-25 18:16:45'),(1407,'1','308',1,'Return of Retail Sale Id 1482',18944.10,0.00,740.00,-22251.80,-3307.70,'2023-01-25 18:25:44'),(1408,'1','308',1,'Retail Sale Id 1483',0.00,2520.00,740.00,2960.00,440.00,'2023-01-25 18:27:08'),(1409,'1','308',1,'Return of Retail Sale Id 1483',2520.00,0.00,740.00,-2960.00,-440.00,'2023-01-25 18:27:36'),(1410,'1','308',1,'Retail Sale Id 1484',0.00,2469.60,740.00,2900.80,431.20,'2023-01-25 18:28:24'),(1411,'1','308',1,'Retail Sale Id 1485',0.00,1915.20,740.00,2249.60,334.40,'2023-01-25 18:29:30'),(1412,'1','308',1,'Retail Sale Id 1486',0.00,2520.00,740.00,2960.00,440.00,'2023-01-25 18:32:47'),(1413,'1','308',1,'Retail Sale Id 1487',0.00,2274.30,740.00,2671.40,397.10,'2023-01-25 19:11:29'),(1414,'1','308',1,'Retail Sale Id 1488',0.00,1278.90,740.00,1502.20,223.30,'2023-01-26 07:55:06'),(1415,'1','308',1,'Retail Sale Id 1489',0.00,2551.50,740.00,2997.00,445.50,'2023-01-26 08:02:34'),(1416,'1','308',1,'Retail Sale Id 1490',0.00,3150.00,740.00,3700.00,550.00,'2023-01-26 08:14:30'),(1417,'1','308',1,'Retail Sale Id 1491',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-26 08:22:29'),(1418,'1','308',1,'Retail Sale Id 1492',0.00,3786.30,740.00,4447.40,661.10,'2023-01-26 08:31:28'),(1419,'1','308',1,'Retail Sale Id 1493',0.00,3830.40,740.00,4499.20,668.80,'2023-01-26 08:45:55'),(1420,'1','308',1,'Retail Sale Id 1494',0.00,2551.50,740.00,2997.00,445.50,'2023-01-26 09:02:23'),(1421,'1','308',1,'Retail Sale Id 1495',0.00,2520.00,740.00,2960.00,440.00,'2023-01-26 09:04:34'),(1422,'1','308',1,'Retail Sale Id 1496',0.00,1908.90,740.00,2242.20,333.30,'2023-01-26 09:06:47'),(1423,'1','308',1,'Retail Sale Id 1497',0.00,1278.90,740.00,1502.20,223.30,'2023-01-26 09:18:59'),(1424,'1','308',1,'Retail Sale Id 1498',0.00,1278.90,740.00,1502.20,223.30,'2023-01-26 10:01:27'),(1425,'1','308',1,'Retail Sale Id 1499',0.00,3786.30,740.00,4447.40,661.10,'2023-01-26 10:09:26'),(1426,'1','308',1,'Retail Sale Id 1500',0.00,1278.90,740.00,1502.20,223.30,'2023-01-26 10:18:08'),(1427,'1','308',1,'Retail Sale Id 1502',0.00,1915.20,740.00,2249.60,334.40,'2023-01-26 10:56:53'),(1428,'1','308',1,'Retail Sale Id 1503',0.00,3786.30,740.00,4447.40,661.10,'2023-01-26 10:58:59'),(1429,'1','308',1,'Retail Sale Id 1504',0.00,3786.30,740.00,4447.40,661.10,'2023-01-26 11:23:18'),(1430,'1','308',1,'Retail Sale Id 1505',0.00,850.50,740.00,999.00,148.50,'2023-01-26 12:54:22'),(1431,'1','308',1,'Retail Sale Id 1506',0.00,850.50,740.00,999.00,148.50,'2023-01-26 12:55:45'),(1432,'1','308',1,'Retail Sale Id 1507',0.00,1278.90,740.00,1502.20,223.30,'2023-01-26 13:17:27'),(1433,'1','308',1,'Retail Sale Id 1508',0.00,3150.00,740.00,3700.00,550.00,'2023-01-26 13:35:58'),(1434,'1','308',1,'Retail Sale Id 1509',0.00,1278.90,740.00,1502.20,223.30,'2023-01-26 14:22:56'),(1435,'1','308',1,'Retail Sale Id 1510',0.00,3786.30,740.00,4447.40,661.10,'2023-01-26 14:25:14'),(1436,'1','308',1,'Retail Sale Id 1511',0.00,18900.00,700.00,21000.00,2100.00,'2023-01-26 14:42:44'),(1437,'1','308',1,'Retail Sale Id 1512',0.00,1915.20,740.00,2249.60,334.40,'2023-01-26 15:08:50'),(1438,'1','308',1,'Retail Sale Id 1513',0.00,3780.00,740.00,4440.00,660.00,'2023-01-26 15:16:52'),(1439,'1','308',1,'Retail Sale Id 1514',0.00,680.40,740.00,799.20,118.80,'2023-01-26 15:19:20'),(1440,'1','308',1,'Retail Sale Id 1515',0.00,636.30,740.00,747.40,111.10,'2023-01-26 15:26:39'),(1441,'1','308',1,'Retail Sale Id 1516',0.00,2520.00,740.00,2960.00,440.00,'2023-01-26 15:29:54'),(1442,'1','308',1,'Retail Sale Id 1517',0.00,3150.00,740.00,3700.00,550.00,'2023-01-26 15:57:54'),(1443,'1','308',1,'Retail Sale Id 1518',0.00,2520.00,740.00,2960.00,440.00,'2023-01-26 16:00:38'),(1444,'1','308',1,'Retail Sale Id 1519',0.00,850.50,740.00,999.00,148.50,'2023-01-26 16:12:05'),(1445,'1','308',1,'Retail Sale Id 1520',0.00,636.30,740.00,747.40,111.10,'2023-01-26 16:13:48'),(1446,'1','308',1,'Retail Sale Id 1521',0.00,1575.00,740.00,1850.00,275.00,'2023-01-26 16:30:19'),(1447,'1','308',1,'Retail Sale Id 1522',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-26 16:40:38'),(1448,'1','308',1,'Retail Sale Id 1523',0.00,1890.00,740.00,2220.00,330.00,'2023-01-26 16:44:47'),(1449,'1','308',1,'Retail Sale Id 1524',0.00,1278.90,740.00,1502.20,223.30,'2023-01-26 17:19:10'),(1450,'1','308',1,'Retail Sale Id 1525',0.00,1278.90,740.00,1502.20,223.30,'2023-01-26 17:27:09'),(1451,'1','308',1,'Retail Sale Id 1526',0.00,3150.00,740.00,3700.00,550.00,'2023-01-26 17:34:51'),(1452,'1','308',1,'Retail Sale Id 1527',0.00,1278.90,740.00,1502.20,223.30,'2023-01-26 17:39:04'),(1453,'1','308',1,'Retail Sale Id 1528',0.00,1260.00,740.00,1480.00,220.00,'2023-01-26 17:40:33'),(1454,'1','308',1,'Retail Sale Id 1529',0.00,1278.90,740.00,1502.20,223.30,'2023-01-26 18:08:39'),(1455,'1','308',1,'Retail Sale Id 1530',0.00,2520.00,740.00,2960.00,440.00,'2023-01-26 18:21:34'),(1456,'1','308',1,'Retail Sale Id 1531',0.00,1871.10,740.00,2197.80,326.70,'2023-01-26 18:24:11'),(1457,'1','308',1,'Retail Sale Id 1532',0.00,1890.00,740.00,2220.00,330.00,'2023-01-26 18:39:07'),(1458,'1','308',1,'Retail Sale Id 1534',0.00,1260.00,740.00,1480.00,220.00,'2023-01-26 18:40:45'),(1459,'1','308',1,'Retail Sale Id 1535',0.00,2551.50,740.00,2997.00,445.50,'2023-01-26 18:43:41'),(1460,'1','308',1,'Retail Sale Id 1536',0.00,1190.70,740.00,1398.60,207.90,'2023-01-26 19:37:48'),(1461,'1','308',1,'Retail Sale Id 1537',0.00,1190.70,740.00,1398.60,207.90,'2023-01-27 07:25:01'),(1462,'1','308',1,'Retail Sale Id 1538',0.00,850.50,740.00,999.00,148.50,'2023-01-27 07:27:29'),(1463,'1','308',1,'Retail Sale Id 1539',0.00,850.50,740.00,999.00,148.50,'2023-01-27 07:45:27'),(1464,'1','308',1,'Retail Sale Id 1540',0.00,1915.20,740.00,2249.60,334.40,'2023-01-27 07:59:59'),(1465,'1','308',1,'Retail Sale Id 1541',0.00,1701.00,740.00,1998.00,297.00,'2023-01-27 08:11:17'),(1466,'1','308',1,'Retail Sale Id 1542',0.00,1190.70,740.00,1398.60,207.90,'2023-01-27 08:12:25'),(1467,'1','308',1,'Retail Sale Id 1543',0.00,39060.00,700.00,43400.00,4340.00,'2023-01-27 08:22:47'),(1468,'1','308',1,'Retail Sale Id 1544',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-27 08:40:51'),(1469,'1','308',1,'Retail Sale Id 1545',0.00,1890.00,740.00,2220.00,330.00,'2023-01-27 08:58:11'),(1470,'1','308',1,'Retail Sale Id 1546',0.00,2551.50,740.00,2997.00,445.50,'2023-01-27 09:36:06'),(1471,'1','308',1,'Retail Sale Id 1547',0.00,3786.30,740.00,4447.40,661.10,'2023-01-27 09:41:02'),(1472,'1','308',1,'Retail Sale Id 1548',0.00,1260.00,740.00,1480.00,220.00,'2023-01-27 10:06:01'),(1473,'1','308',1,'Retail Sale Id 1549',0.00,1915.20,740.00,2249.60,334.40,'2023-01-27 10:17:40'),(1474,'1','308',1,'Retail Sale Id 1550',0.00,1890.00,740.00,2220.00,330.00,'2023-01-27 10:19:07'),(1475,'1','308',1,'Retail Sale Id 1551',0.00,1278.90,740.00,1502.20,223.30,'2023-01-27 11:17:11'),(1476,'1','308',1,'Retail Sale Id 1552',0.00,3786.30,740.00,4447.40,661.10,'2023-01-27 11:18:51'),(1477,'1','308',1,'Retail Sale Id 1553',0.00,3780.00,740.00,4440.00,660.00,'2023-01-27 11:20:10'),(1478,'1','308',1,'Retail Sale Id 1554',0.00,1260.00,740.00,1480.00,220.00,'2023-01-27 11:41:31'),(1479,'1','308',1,'Retail Sale Id 1555',0.00,636.30,740.00,747.40,111.10,'2023-01-27 12:07:29'),(1480,'1','308',1,'Retail Sale Id 1556',0.00,1701.00,740.00,1998.00,297.00,'2023-01-27 12:34:29'),(1481,'1','308',1,'Retail Sale Id 1557',0.00,1260.00,740.00,1480.00,220.00,'2023-01-27 12:42:04'),(1482,'1','308',1,'Retail Sale Id 1558',0.00,636.30,740.00,747.40,111.10,'2023-01-27 12:47:19'),(1483,'1','308',1,'Retail Sale Id 1559',0.00,2551.50,740.00,2997.00,445.50,'2023-01-27 12:49:24'),(1484,'1','308',1,'Retail Sale Id 1560',0.00,6300.00,740.00,7400.00,1100.00,'2023-01-27 13:04:24'),(1485,'1','308',1,'Retail Sale Id 1561',0.00,1871.10,740.00,2197.80,326.70,'2023-01-27 13:20:14'),(1486,'1','308',1,'Retail Sale Id 1562',0.00,636.30,740.00,747.40,111.10,'2023-01-27 13:22:55'),(1487,'1','308',1,'Retail Sale Id 1563',0.00,4088.70,740.00,4802.60,713.90,'2023-01-27 13:31:05'),(1488,'1','308',1,'Retail Sale Id 1564',0.00,1890.00,740.00,2220.00,330.00,'2023-01-27 13:40:53'),(1489,'1','308',1,'Retail Sale Id 1565',0.00,1278.90,740.00,1502.20,223.30,'2023-01-27 14:19:19'),(1490,'1','308',1,'Retail Sale Id 1566',0.00,4428.90,740.00,5202.20,773.30,'2023-01-27 14:29:49'),(1491,'1','308',1,'Retail Sale Id 1567',0.00,1278.90,740.00,1502.20,223.30,'2023-01-27 15:52:46'),(1492,'1','308',1,'Retail Sale Id 1568',0.00,636.30,740.00,747.40,111.10,'2023-01-27 16:11:36'),(1493,'1','308',1,'Retail Sale Id 1569',0.00,1260.00,740.00,1480.00,220.00,'2023-01-27 17:00:49'),(1494,'1','308',1,'Retail Sale Id 1570',0.00,636.30,740.00,747.40,111.10,'2023-01-27 18:00:26'),(1495,'1','308',1,'Retail Sale Id 1571',0.00,636.30,740.00,747.40,111.10,'2023-01-27 18:07:21'),(1496,'1','308',1,'Return of Retail Sale Id 1543',39060.00,0.00,700.00,-43400.00,-4340.00,'2023-01-27 18:31:17'),(1497,'1','308',1,'Retail Sale Id 1572',0.00,38883.60,700.00,43204.00,4320.40,'2023-01-27 18:32:18'),(1498,'1','308',1,'Return of Retail Sale Id 1555',636.30,0.00,740.00,-747.40,-111.10,'2023-01-27 18:33:08'),(1499,'1','308',1,'Retail Sale Id 1573',0.00,623.70,740.00,732.60,108.90,'2023-01-27 18:33:49'),(1500,'1','308',1,'Retail Sale Id 1574',0.00,3150.00,740.00,3700.00,550.00,'2023-01-28 07:51:14'),(1501,'1','308',1,'Retail Sale Id 1575',0.00,2551.50,740.00,2997.00,445.50,'2023-01-28 08:01:46'),(1502,'1','308',1,'Retail Sale Id 1576',0.00,2551.50,740.00,2997.00,445.50,'2023-01-28 08:03:55'),(1503,'1','308',1,'Retail Sale Id 1577',0.00,1701.00,740.00,1998.00,297.00,'2023-01-28 08:11:04'),(1504,'1','308',1,'Retail Sale Id 1578',0.00,1915.20,740.00,2249.60,334.40,'2023-01-28 08:14:35'),(1505,'1','308',1,'Retail Sale Id 1579',0.00,636.30,740.00,747.40,111.10,'2023-01-28 08:28:30'),(1506,'1','308',1,'Retail Sale Id 1580',0.00,28350.00,700.00,31500.00,3150.00,'2023-01-28 08:33:29'),(1507,'1','308',1,'Retail Sale Id 1581',0.00,1890.00,740.00,2220.00,330.00,'2023-01-28 08:35:00'),(1508,'1','308',1,'Retail Sale Id 1582',0.00,1260.00,740.00,1480.00,220.00,'2023-01-28 08:36:19'),(1509,'1','308',1,'Retail Sale Id 1583',0.00,3780.00,740.00,4440.00,660.00,'2023-01-28 08:40:38'),(1510,'1','308',1,'Retail Sale Id 1584',0.00,1278.90,740.00,1502.20,223.30,'2023-01-28 08:42:04'),(1511,'1','308',1,'Retail Sale Id 1585',0.00,636.30,740.00,747.40,111.10,'2023-01-28 08:43:20'),(1512,'1','308',1,'Retail Sale Id 1586',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-28 08:46:37'),(1513,'1','308',1,'Retail Sale Id 1587',0.00,1278.90,740.00,1502.20,223.30,'2023-01-28 08:47:45'),(1514,'1','308',1,'Retail Sale Id 1588',0.00,1278.90,740.00,1502.20,223.30,'2023-01-28 08:48:49'),(1515,'1','308',1,'Retail Sale Id 1589',0.00,1278.90,740.00,1502.20,223.30,'2023-01-28 08:58:39'),(1516,'1','308',1,'Retail Sale Id 1590',0.00,2520.00,740.00,2960.00,440.00,'2023-01-28 09:01:42'),(1517,'1','308',1,'Retail Sale Id 1591',0.00,3780.00,740.00,4440.00,660.00,'2023-01-28 09:11:13'),(1518,'1','308',1,'Retail Sale Id 1592',0.00,3150.00,740.00,3700.00,550.00,'2023-01-28 09:18:39'),(1519,'1','308',1,'Retail Sale Id 1593',0.00,1890.00,740.00,2220.00,330.00,'2023-01-28 09:22:57'),(1520,'1','308',1,'Retail Sale Id 1594',0.00,636.30,740.00,747.40,111.10,'2023-01-28 10:56:10'),(1521,'1','308',1,'Retail Sale Id 1595',0.00,5670.00,740.00,6660.00,990.00,'2023-01-28 11:09:04'),(1522,'1','308',1,'Retail Sale Id 1596',0.00,1278.90,740.00,1502.20,223.30,'2023-01-28 11:20:18'),(1523,'1','308',1,'Retail Sale Id 1597',0.00,3780.00,740.00,4440.00,660.00,'2023-01-28 12:36:12'),(1524,'1','308',1,'Retail Sale Id 1598',0.00,636.30,740.00,747.40,111.10,'2023-01-28 12:37:46'),(1525,'1','308',1,'Retail Sale Id 1599',0.00,1915.20,740.00,2249.60,334.40,'2023-01-28 12:42:22'),(1526,'1','308',1,'Retail Sale Id 1600',0.00,680.40,740.00,799.20,118.80,'2023-01-28 12:50:48'),(1527,'1','308',1,'Retail Sale Id 1601',0.00,2299.50,740.00,2701.00,401.50,'2023-01-28 13:17:06'),(1528,'1','308',1,'Retail Sale Id 1602',0.00,2551.50,740.00,2997.00,445.50,'2023-01-28 13:34:49'),(1529,'1','308',1,'Retail Sale Id 1603',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-28 14:21:03'),(1530,'1','308',1,'Retail Sale Id 1604',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-28 14:23:20'),(1531,'1','308',1,'Retail Sale Id 1605',0.00,680.40,740.00,799.20,118.80,'2023-01-28 14:25:11'),(1532,'1','308',1,'Retail Sale Id 1606',0.00,2551.50,740.00,2997.00,445.50,'2023-01-28 14:30:25'),(1533,'1','308',1,'Retail Sale Id 1607',0.00,1278.90,740.00,1502.20,223.30,'2023-01-28 14:31:42'),(1534,'1','308',1,'Retail Sale Id 1608',0.00,680.40,740.00,799.20,118.80,'2023-01-28 14:32:59'),(1535,'1','308',1,'Retail Sale Id 1609',0.00,1915.20,740.00,2249.60,334.40,'2023-01-28 14:51:08'),(1536,'1','308',1,'Retail Sale Id 1610',0.00,1278.90,740.00,1502.20,223.30,'2023-01-28 15:10:32'),(1537,'1','308',1,'Retail Sale Id 1611',0.00,1890.00,740.00,2220.00,330.00,'2023-01-28 15:13:20'),(1538,'1','308',1,'Retail Sale Id 1612',0.00,630.00,740.00,740.00,110.00,'2023-01-28 15:14:51'),(1539,'1','308',1,'Retail Sale Id 1613',0.00,1260.00,740.00,1480.00,220.00,'2023-01-28 16:22:09'),(1540,'1','308',1,'Retail Sale Id 1614',0.00,3150.00,740.00,3700.00,550.00,'2023-01-28 16:45:46'),(1541,'1','308',1,'Retail Sale Id 1615',0.00,3150.00,740.00,3700.00,550.00,'2023-01-28 16:47:41'),(1542,'1','308',1,'Retail Sale Id 1616',0.00,6129.90,740.00,7200.20,1070.30,'2023-01-28 16:58:13'),(1543,'1','308',1,'Retail Sale Id 1617',0.00,3150.00,740.00,3700.00,550.00,'2023-01-28 17:00:52'),(1544,'1','308',1,'Retail Sale Id 1618',0.00,1260.00,740.00,1480.00,220.00,'2023-01-28 17:17:52'),(1545,'1','308',1,'Retail Sale Id 1619',0.00,1278.90,740.00,1502.20,223.30,'2023-01-28 17:19:56'),(1546,'1','308',1,'Retail Sale Id 1620',0.00,3408.30,740.00,4003.40,595.10,'2023-01-28 17:47:01'),(1547,'1','308',1,'Retail Sale Id 1621',0.00,6300.00,740.00,7400.00,1100.00,'2023-01-28 17:49:31'),(1548,'1','308',1,'Retail Sale Id 1622',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-28 17:51:26'),(1549,'1','308',1,'Retail Sale Id 1623',0.00,630.00,740.00,740.00,110.00,'2023-01-28 18:04:14'),(1550,'1','308',1,'Retail Sale Id 1624',0.00,2551.50,740.00,2997.00,445.50,'2023-01-28 18:11:21'),(1551,'1','308',1,'Retail Sale Id 1625',0.00,3150.00,740.00,3700.00,550.00,'2023-01-28 18:14:44'),(1552,'1','308',1,'Retail Sale Id 1626',0.00,1915.20,740.00,2249.60,334.40,'2023-01-28 18:20:58'),(1553,'1','308',1,'Return of Retail Sale Id 1597',3780.00,0.00,740.00,-4440.00,-660.00,'2023-01-28 19:15:53'),(1554,'1','308',1,'Retail Sale Id 1627',0.00,441.00,740.00,518.00,77.00,'2023-01-28 19:17:42'),(1555,'1','308',1,'Retail Sale Id 1628',0.00,3780.00,740.00,4440.00,660.00,'2023-01-29 07:30:07'),(1556,'1','308',1,'Retail Sale Id 1629',0.00,1278.90,740.00,1502.20,223.30,'2023-01-29 07:48:47'),(1557,'1','308',1,'Retail Sale Id 1630',0.00,3780.00,740.00,4440.00,660.00,'2023-01-29 07:51:11'),(1558,'1','308',1,'Retail Sale Id 1631',0.00,636.30,740.00,747.40,111.10,'2023-01-29 08:12:18'),(1559,'1','308',1,'Retail Sale Id 1632',0.00,1260.00,740.00,1480.00,220.00,'2023-01-29 08:28:08'),(1560,'1','308',1,'Retail Sale Id 1633',0.00,3150.00,740.00,3700.00,550.00,'2023-01-29 08:42:44'),(1561,'1','308',1,'Retail Sale Id 1634',0.00,636.30,740.00,747.40,111.10,'2023-01-29 08:46:47'),(1562,'1','308',1,'Retail Sale Id 1635',0.00,1278.90,740.00,1502.20,223.30,'2023-01-29 09:08:12'),(1563,'1','308',1,'Retail Sale Id 1636',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-29 09:15:55'),(1564,'1','308',1,'Retail Sale Id 1637',0.00,1871.10,740.00,2197.80,326.70,'2023-01-29 09:22:54'),(1565,'1','308',1,'Retail Sale Id 1638',0.00,1890.00,740.00,2220.00,330.00,'2023-01-29 09:29:37'),(1566,'1','308',1,'Retail Sale Id 1639',0.00,3150.00,740.00,3700.00,550.00,'2023-01-29 09:55:35'),(1567,'1','308',1,'Retail Sale Id 1640',0.00,945.00,740.00,1110.00,165.00,'2023-01-29 10:15:37'),(1568,'1','308',1,'Retail Sale Id 1641',0.00,1701.00,740.00,1998.00,297.00,'2023-01-29 10:16:34'),(1569,'1','308',1,'Retail Sale Id 1642',0.00,850.50,740.00,999.00,148.50,'2023-01-29 10:21:07'),(1570,'1','308',1,'Retail Sale Id 1643',0.00,18900.00,700.00,21000.00,2100.00,'2023-01-29 10:37:35'),(1571,'1','308',1,'Retail Sale Id 1644',0.00,1278.90,740.00,1502.20,223.30,'2023-01-29 10:55:43'),(1572,'1','308',1,'Retail Sale Id 1645',0.00,1940.40,740.00,2279.20,338.80,'2023-01-29 11:34:56'),(1573,'1','308',1,'Retail Sale Id 1646',0.00,2551.50,740.00,2997.00,445.50,'2023-01-29 11:44:08'),(1574,'1','308',1,'Retail Sale Id 1647',0.00,1701.00,740.00,1998.00,297.00,'2023-01-29 12:01:55'),(1575,'1','308',1,'Retail Sale Id 1648',0.00,3786.30,740.00,4447.40,661.10,'2023-01-29 12:03:51'),(1576,'1','308',1,'Retail Sale Id 1649',0.00,1890.00,740.00,2220.00,330.00,'2023-01-29 12:32:35'),(1577,'1','308',1,'Retail Sale Id 1650',0.00,1278.90,740.00,1502.20,223.30,'2023-01-29 12:33:41'),(1578,'1','308',1,'Retail Sale Id 1651',0.00,2520.00,740.00,2960.00,440.00,'2023-01-29 12:39:14'),(1579,'1','308',1,'Retail Sale Id 1652',0.00,2551.50,740.00,2997.00,445.50,'2023-01-29 12:56:02'),(1580,'1','308',1,'Retail Sale Id 1653',0.00,1278.90,740.00,1502.20,223.30,'2023-01-29 12:59:39'),(1581,'1','308',1,'Retail Sale Id 1654',0.00,850.50,740.00,999.00,148.50,'2023-01-29 13:20:26'),(1582,'1','308',1,'Retail Sale Id 1655',0.00,1278.90,740.00,1502.20,223.30,'2023-01-29 13:37:48'),(1583,'1','308',1,'Retail Sale Id 1656',0.00,1890.00,740.00,2220.00,330.00,'2023-01-29 13:39:17'),(1584,'1','308',1,'Retail Sale Id 1657',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-29 13:43:49'),(1585,'1','308',1,'Retail Sale Id 1658',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-29 14:07:05'),(1586,'1','308',1,'Retail Sale Id 1659',0.00,3150.00,740.00,3700.00,550.00,'2023-01-29 14:11:25'),(1587,'1','308',1,'Retail Sale Id 1660',0.00,2551.50,740.00,2997.00,445.50,'2023-01-29 14:12:03'),(1588,'1','308',1,'Retail Sale Id 1661',0.00,3786.30,740.00,4447.40,661.10,'2023-01-29 14:12:46'),(1589,'1','308',1,'Retail Sale Id 1662',0.00,1278.90,740.00,1502.20,223.30,'2023-01-29 14:21:53'),(1590,'1','308',1,'Retail Sale Id 1663',0.00,3780.00,740.00,4440.00,660.00,'2023-01-29 14:22:37'),(1591,'1','308',1,'Retail Sale Id 1664',0.00,3150.00,740.00,3700.00,550.00,'2023-01-29 14:24:14'),(1592,'1','308',1,'Retail Sale Id 1665',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-29 14:45:22'),(1593,'1','308',1,'Retail Sale Id 1666',0.00,1890.00,740.00,2220.00,330.00,'2023-01-29 14:47:44'),(1594,'1','308',1,'Retail Sale Id 1667',0.00,1890.00,740.00,2220.00,330.00,'2023-01-29 14:48:21'),(1595,'1','308',1,'Retail Sale Id 1668',0.00,850.50,740.00,999.00,148.50,'2023-01-29 14:57:22'),(1596,'1','308',1,'Retail Sale Id 1669',0.00,1890.00,740.00,2220.00,330.00,'2023-01-29 15:27:10'),(1597,'1','308',1,'Retail Sale Id 1670',0.00,1890.00,740.00,2220.00,330.00,'2023-01-29 15:30:34'),(1598,'1','308',1,'Retail Sale Id 1671',0.00,850.50,740.00,999.00,148.50,'2023-01-29 16:08:29'),(1599,'1','308',1,'Retail Sale Id 1672',0.00,1890.00,740.00,2220.00,330.00,'2023-01-29 16:19:21'),(1600,'1','308',1,'Retail Sale Id 1673',0.00,850.50,740.00,999.00,148.50,'2023-01-29 16:46:58'),(1601,'1','308',1,'Retail Sale Id 1674',0.00,1915.20,740.00,2249.60,334.40,'2023-01-29 16:52:35'),(1602,'1','308',1,'Retail Sale Id 1675',0.00,636.30,740.00,747.40,111.10,'2023-01-29 17:32:56'),(1603,'1','308',1,'Retail Sale Id 1676',0.00,1871.10,740.00,2197.80,326.70,'2023-01-29 17:38:27'),(1604,'1','308',1,'Retail Sale Id 1677',0.00,1915.20,740.00,2249.60,334.40,'2023-01-29 17:44:42'),(1605,'1','308',1,'Retail Sale Id 1678',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-29 18:05:04'),(1606,'1','308',1,'Retail Sale Id 1679',0.00,1890.00,740.00,2220.00,330.00,'2023-01-29 18:08:32'),(1607,'1','308',1,'Retail Sale Id 1680',0.00,1890.00,740.00,2220.00,330.00,'2023-01-29 18:11:03'),(1608,'1','308',1,'Retail Sale Id 1681',0.00,1278.90,740.00,1502.20,223.30,'2023-01-29 18:18:15'),(1609,'1','308',1,'Retail Sale Id 1682',0.00,3150.00,740.00,3700.00,550.00,'2023-01-29 18:24:11'),(1610,'1','308',1,'Retail Sale Id 1683',0.00,2551.50,740.00,2997.00,445.50,'2023-01-29 18:33:14'),(1611,'1','308',1,'Retail Sale Id 1684',0.00,1278.90,740.00,1502.20,223.30,'2023-01-30 07:21:47'),(1612,'1','308',1,'Retail Sale Id 1685',0.00,1890.00,740.00,2220.00,330.00,'2023-01-30 07:24:38'),(1613,'1','308',1,'Retail Sale Id 1686',0.00,1278.90,740.00,1502.20,223.30,'2023-01-30 07:28:05'),(1614,'1','308',1,'Retail Sale Id 1687',0.00,1701.00,740.00,1998.00,297.00,'2023-01-30 07:43:12'),(1615,'1','308',1,'Retail Sale Id 1688',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-30 08:03:38'),(1616,'1','308',1,'Retail Sale Id 1689',0.00,1890.00,740.00,2220.00,330.00,'2023-01-30 08:04:37'),(1617,'1','308',1,'Retail Sale Id 1690',0.00,1278.90,740.00,1502.20,223.30,'2023-01-30 08:28:54'),(1618,'1','308',1,'Retail Sale Id 1691',0.00,1871.10,740.00,2197.80,326.70,'2023-01-30 08:45:01'),(1619,'1','308',1,'Retail Sale Id 1692',0.00,1278.90,740.00,1502.20,223.30,'2023-01-30 08:56:29'),(1620,'1','308',1,'Retail Sale Id 1693',0.00,1871.10,740.00,2197.80,326.70,'2023-01-30 09:25:21'),(1621,'1','308',1,'Retail Sale Id 1694',0.00,1883.70,740.00,2212.60,328.90,'2023-01-30 09:31:30'),(1622,'1','308',1,'Retail Sale Id 1695',0.00,1278.90,740.00,1502.20,223.30,'2023-01-30 09:32:42'),(1623,'1','308',1,'Retail Sale Id 1696',0.00,2520.00,740.00,2960.00,440.00,'2023-01-30 09:41:09'),(1624,'1','308',1,'Retail Sale Id 1697',0.00,1278.90,740.00,1502.20,223.30,'2023-01-30 09:42:48'),(1625,'1','308',1,'Retail Sale Id 1698',0.00,1278.90,740.00,1502.20,223.30,'2023-01-30 11:02:30'),(1626,'1','308',1,'Retail Sale Id 1699',0.00,768.60,740.00,902.80,134.20,'2023-01-30 11:49:03'),(1627,'1','308',1,'Retail Sale Id 1700',0.00,3780.00,740.00,4440.00,660.00,'2023-01-30 11:58:42'),(1628,'1','308',1,'Retail Sale Id 1701',0.00,1701.00,740.00,1998.00,297.00,'2023-01-30 12:47:38'),(1629,'1','308',1,'Retail Sale Id 1702',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-30 12:55:10'),(1630,'1','308',1,'Retail Sale Id 1704',0.00,1896.30,740.00,2227.40,331.10,'2023-01-30 13:08:31'),(1631,'1','308',1,'Retail Sale Id 1705',0.00,6300.00,740.00,7400.00,1100.00,'2023-01-30 13:18:03'),(1632,'1','308',1,'Retail Sale Id 1706',0.00,3780.00,740.00,4440.00,660.00,'2023-01-30 13:24:15'),(1633,'1','308',1,'Retail Sale Id 1707',0.00,3786.30,740.00,4447.40,661.10,'2023-01-30 13:31:46'),(1634,'1','308',1,'Retail Sale Id 1708',0.00,1278.90,740.00,1502.20,223.30,'2023-01-30 13:43:59'),(1635,'1','308',1,'Retail Sale Id 1709',0.00,850.50,740.00,999.00,148.50,'2023-01-30 13:46:27'),(1636,'1','308',1,'Retail Sale Id 1710',0.00,1871.10,740.00,2197.80,326.70,'2023-01-30 14:07:10'),(1637,'1','308',1,'Retail Sale Id 1711',0.00,1278.90,740.00,1502.20,223.30,'2023-01-30 15:22:56'),(1638,'1','308',1,'Retail Sale Id 1712',0.00,3150.00,740.00,3700.00,550.00,'2023-01-30 15:44:38'),(1639,'1','308',1,'Retail Sale Id 1713',0.00,850.50,740.00,999.00,148.50,'2023-01-30 15:50:22'),(1640,'1','308',1,'Retail Sale Id 1714',0.00,1871.10,740.00,2197.80,326.70,'2023-01-30 15:57:47'),(1641,'1','308',1,'Retail Sale Id 1715',0.00,1278.90,740.00,1502.20,223.30,'2023-01-30 16:00:43'),(1642,'1','308',1,'Retail Sale Id 1716',0.00,3408.30,740.00,4003.40,595.10,'2023-01-30 16:04:49'),(1643,'1','308',1,'Retail Sale Id 1717',0.00,1278.90,740.00,1502.20,223.30,'2023-01-30 16:40:44'),(1644,'1','308',1,'Retail Sale Id 1718',0.00,1278.90,740.00,1502.20,223.30,'2023-01-30 16:42:04'),(1645,'1','308',1,'Retail Sale Id 1719',0.00,1701.00,740.00,1998.00,297.00,'2023-01-30 16:47:03'),(1646,'1','308',1,'Retail Sale Id 1720',0.00,1278.90,740.00,1502.20,223.30,'2023-01-30 16:53:11'),(1647,'1','308',1,'Retail Sale Id 1721',0.00,3150.00,740.00,3700.00,550.00,'2023-01-30 17:02:43'),(1648,'1','308',1,'Retail Sale Id 1722',0.00,1278.90,740.00,1502.20,223.30,'2023-01-30 17:16:00'),(1649,'1','308',1,'Retail Sale Id 1723',0.00,1701.00,740.00,1998.00,297.00,'2023-01-30 17:20:05'),(1650,'1','308',1,'Retail Sale Id 1724',0.00,1890.00,740.00,2220.00,330.00,'2023-01-30 17:26:04'),(1651,'1','308',1,'Retail Sale Id 1725',0.00,25200.00,700.00,28000.00,2800.00,'2023-01-30 17:30:00'),(1652,'1','308',1,'Retail Sale Id 1726',0.00,18900.00,700.00,21000.00,2100.00,'2023-01-30 18:18:38'),(1653,'1','308',1,'Retail Sale Id 1727',0.00,636.30,740.00,747.40,111.10,'2023-01-30 18:26:39'),(1654,'1','308',1,'Retail Sale Id 1728',0.00,3786.30,740.00,4447.40,661.10,'2023-01-30 18:29:43'),(1655,'1','308',1,'Retail Sale Id 1729',0.00,7560.00,740.00,8880.00,1320.00,'2023-01-30 18:37:59'),(1656,'1','308',1,'Retail Sale Id 1730',0.00,1203.30,740.00,1413.40,210.10,'2023-01-30 19:15:29'),(1657,'1','308',1,'Retail Sale Id 1731',0.00,1890.00,740.00,2220.00,330.00,'2023-01-31 07:48:32'),(1658,'1','308',1,'Retail Sale Id 1732',0.00,2551.50,740.00,2997.00,445.50,'2023-01-31 07:53:28'),(1659,'1','308',1,'Retail Sale Id 1733',0.00,1701.00,740.00,1998.00,297.00,'2023-01-31 08:15:56'),(1660,'1','308',1,'Retail Sale Id 1734',0.00,1890.00,740.00,2220.00,330.00,'2023-01-31 08:21:59'),(1661,'1','308',1,'Retail Sale Id 1735',0.00,1278.90,740.00,1502.20,223.30,'2023-01-31 08:31:11'),(1662,'1','308',1,'Retail Sale Id 1736',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-31 08:34:20'),(1663,'1','308',1,'Retail Sale Id 1737',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-31 08:36:53'),(1664,'1','308',1,'Retail Sale Id 1738',0.00,2570.40,740.00,3019.20,448.80,'2023-01-31 09:19:59'),(1665,'1','308',1,'Retail Sale Id 1739',0.00,1278.90,740.00,1502.20,223.30,'2023-01-31 09:26:03'),(1666,'1','308',1,'Retail Sale Id 1740',0.00,94500.00,700.00,105000.00,10500.00,'2023-01-31 09:28:42'),(1667,'1','308',1,'Retail Sale Id 1741',0.00,126000.00,700.00,140000.00,14000.00,'2023-01-31 09:38:58'),(1668,'1','308',1,'Retail Sale Id 1742',0.00,850.50,740.00,999.00,148.50,'2023-01-31 09:49:08'),(1669,'1','308',1,'Retail Sale Id 1743',0.00,630.00,740.00,740.00,110.00,'2023-01-31 10:18:48'),(1670,'1','308',1,'Retail Sale Id 1744',0.00,2551.50,740.00,2997.00,445.50,'2023-01-31 10:40:11'),(1671,'1','308',1,'Retail Sale Id 1745',0.00,1915.20,740.00,2249.60,334.40,'2023-01-31 10:50:34'),(1672,'1','308',1,'Retail Sale Id 1746',0.00,1278.90,740.00,1502.20,223.30,'2023-01-31 11:40:25'),(1673,'1','308',1,'Retail Sale Id 1747',0.00,850.50,740.00,999.00,148.50,'2023-01-31 11:51:09'),(1674,'1','308',1,'Retail Sale Id 1748',0.00,3780.00,740.00,4440.00,660.00,'2023-01-31 11:59:07'),(1675,'1','308',1,'Retail Sale Id 1749',0.00,2551.50,740.00,2997.00,445.50,'2023-01-31 12:44:56'),(1676,'1','308',1,'Retail Sale Id 1750',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-31 12:55:07'),(1677,'1','308',1,'Retail Sale Id 1751',0.00,636.30,740.00,747.40,111.10,'2023-01-31 12:58:39'),(1678,'1','308',1,'Retail Sale Id 1753',0.00,850.50,740.00,999.00,148.50,'2023-01-31 13:35:45'),(1679,'1','308',1,'Retail Sale Id 1754',0.00,1260.00,740.00,1480.00,220.00,'2023-01-31 14:04:51'),(1680,'1','308',1,'Retail Sale Id 1755',0.00,850.50,740.00,999.00,148.50,'2023-01-31 14:41:10'),(1681,'1','308',1,'Retail Sale Id 1756',0.00,1278.90,740.00,1502.20,223.30,'2023-01-31 14:44:29'),(1682,'1','308',1,'Retail Sale Id 1757',0.00,1278.90,740.00,1502.20,223.30,'2023-01-31 14:45:23'),(1683,'1','308',1,'Retail Sale Id 1752',0.00,2520.00,740.00,2960.00,440.00,'2023-01-31 15:37:58'),(1684,'1','308',1,'Retail Sale Id 1758',0.00,6300.00,740.00,7400.00,1100.00,'2023-01-31 15:51:46'),(1685,'1','308',1,'Retail Sale Id 1759',0.00,2520.00,740.00,2960.00,440.00,'2023-01-31 15:55:51'),(1686,'1','308',1,'Retail Sale Id 1760',0.00,1915.20,740.00,2249.60,334.40,'2023-01-31 16:13:06'),(1687,'1','308',1,'Retail Sale Id 1761',0.00,850.50,740.00,999.00,148.50,'2023-01-31 16:21:41'),(1688,'1','308',1,'Retail Sale Id 1762',0.00,3150.00,740.00,3700.00,550.00,'2023-01-31 16:33:11'),(1689,'1','308',1,'Retail Sale Id 1763',0.00,1915.20,740.00,2249.60,334.40,'2023-01-31 16:38:36'),(1690,'1','308',1,'Retail Sale Id 1764',0.00,1278.90,740.00,1502.20,223.30,'2023-01-31 17:15:45'),(1691,'1','308',1,'Retail Sale Id 1765',0.00,1278.90,740.00,1502.20,223.30,'2023-01-31 17:16:45'),(1692,'1','308',1,'Retail Sale Id 1766',0.00,1278.90,740.00,1502.20,223.30,'2023-01-31 17:17:54'),(1693,'1','308',1,'Retail Sale Id 1767',0.00,2513.70,740.00,2952.60,438.90,'2023-01-31 17:26:07'),(1694,'1','308',1,'Retail Sale Id 1768',0.00,1871.10,740.00,2197.80,326.70,'2023-01-31 17:48:35'),(1695,'1','308',1,'Retail Sale Id 1769',0.00,1278.90,740.00,1502.20,223.30,'2023-01-31 17:52:10'),(1696,'1','308',1,'Retail Sale Id 1770',0.00,636.30,740.00,747.40,111.10,'2023-01-31 18:14:59'),(1697,'1','308',1,'Retail Sale Id 1771',0.00,1896.30,740.00,2227.40,331.10,'2023-01-31 18:20:05'),(1698,'1','308',1,'Retail Sale Id 1772',0.00,1278.90,740.00,1502.20,223.30,'2023-01-31 18:21:01'),(1699,'1','308',1,'Retail Sale Id 1773',0.00,3150.00,740.00,3700.00,550.00,'2023-01-31 18:23:01'),(1700,'1','308',1,'Retail Sale Id 1775',0.00,1278.90,740.00,1502.20,223.30,'2023-01-31 18:37:51'),(1701,'1','308',1,'Retail Sale Id 1776',0.00,1278.90,740.00,1502.20,223.30,'2023-01-31 18:38:35'),(1702,'1','308',1,'Retail Sale Id 1777',0.00,2551.50,740.00,2997.00,445.50,'2023-01-31 18:40:52'),(1703,'1','308',1,'Retail Sale Id 1778',0.00,1701.00,740.00,1998.00,297.00,'2023-01-31 18:57:07'),(1704,'1','308',1,'Retail Sale Id 1779',0.00,1278.90,740.00,1502.20,223.30,'2023-01-31 19:06:11'),(1705,'1','308',1,'Retail Sale Id 1780',0.00,25.20,740.00,29.60,4.40,'2023-01-31 19:12:54'),(1706,'1','308',1,'Retail Sale Id 1781',0.00,3780.00,740.00,4440.00,660.00,'2023-02-01 07:26:52'),(1707,'1','308',1,'Retail Sale Id 1782',0.00,1959.30,740.00,2301.40,342.10,'2023-02-01 07:41:13'),(1708,'1','308',1,'Retail Sale Id 1783',0.00,636.30,740.00,747.40,111.10,'2023-02-01 07:45:38'),(1709,'1','308',1,'Retail Sale Id 1784',0.00,31500.00,700.00,35000.00,3500.00,'2023-02-01 07:53:43'),(1710,'1','308',1,'Retail Sale Id 1785',0.00,3150.00,740.00,3700.00,550.00,'2023-02-01 08:01:53'),(1711,'1','308',1,'Retail Sale Id 1786',0.00,3150.00,740.00,3700.00,550.00,'2023-02-01 08:15:15'),(1712,'1','308',1,'Retail Sale Id 1787',0.00,1915.20,740.00,2249.60,334.40,'2023-02-01 08:45:08'),(1713,'1','308',1,'Retail Sale Id 1788',0.00,2551.50,740.00,2997.00,445.50,'2023-02-01 08:46:30'),(1714,'1','308',1,'Retail Sale Id 1790',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-01 08:48:32'),(1715,'1','308',1,'Retail Sale Id 1791',0.00,2520.00,740.00,2960.00,440.00,'2023-02-01 08:58:41'),(1716,'1','308',1,'Retail Sale Id 1792',0.00,3780.00,740.00,4440.00,660.00,'2023-02-01 09:04:51'),(1717,'1','308',1,'Retail Sale Id 1793',0.00,39375.00,700.00,43750.00,4375.00,'2023-02-01 09:09:25'),(1718,'1','308',1,'Retail Sale Id 1794',0.00,1278.90,740.00,1502.20,223.30,'2023-02-01 09:10:52'),(1719,'1','308',1,'Retail Sale Id 1795',0.00,1108.80,740.00,1302.40,193.60,'2023-02-01 09:12:02'),(1720,'1','308',1,'Retail Sale Id 1796',0.00,636.30,740.00,747.40,111.10,'2023-02-01 09:24:06'),(1721,'1','308',1,'Retail Sale Id 1797',0.00,2520.00,740.00,2960.00,440.00,'2023-02-01 09:36:24'),(1722,'1','308',1,'Retail Sale Id 1798',0.00,1260.00,740.00,1480.00,220.00,'2023-02-01 09:38:03'),(1723,'1','308',1,'Retail Sale Id 1799',0.00,1890.00,740.00,2220.00,330.00,'2023-02-01 09:43:55'),(1724,'1','308',1,'Retail Sale Id 1800',0.00,2520.00,740.00,2960.00,440.00,'2023-02-01 09:46:41'),(1725,'1','308',1,'Retail Sale Id 1801',0.00,636.30,740.00,747.40,111.10,'2023-02-01 09:56:39'),(1726,'1','308',1,'Return of Retail Sale Id 1793',39375.00,0.00,700.00,-43750.00,-4375.00,'2023-02-01 11:01:48'),(1727,'1','308',1,'Retail Sale Id 1802',0.00,39154.50,700.00,43505.00,4350.50,'2023-02-01 11:03:47'),(1728,'1','308',1,'Sale Id 2',0.00,48636.00,696.00,53731.20,5095.20,'2023-02-01 11:33:05'),(1729,'1','308',1,'Retail Sale Id 1803',0.00,2551.50,740.00,2997.00,445.50,'2023-02-01 12:26:59'),(1730,'1','308',1,'Retail Sale Id 1804',0.00,18295.20,740.00,21489.60,3194.40,'2023-02-01 12:34:50'),(1731,'1','308',1,'Retail Sale Id 1805',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-01 12:58:19'),(1732,'1','308',1,'Retail Sale Id 1806',0.00,3150.00,740.00,3700.00,550.00,'2023-02-01 13:07:47'),(1733,'1','308',1,'Retail Sale Id 1807',0.00,1278.90,740.00,1502.20,223.30,'2023-02-01 13:34:01'),(1734,'1','308',1,'Retail Sale Id 1808',0.00,1404.90,740.00,1650.20,245.30,'2023-02-01 14:21:13'),(1735,'1','308',1,'Retail Sale Id 1809',0.00,1896.30,740.00,2227.40,331.10,'2023-02-01 14:30:05'),(1736,'1','308',1,'Retail Sale Id 1810',0.00,1278.90,740.00,1502.20,223.30,'2023-02-01 14:49:04'),(1737,'1','308',1,'Retail Sale Id 1811',0.00,1871.10,740.00,2197.80,326.70,'2023-02-01 14:54:16'),(1738,'1','308',1,'Retail Sale Id 1812',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-01 14:56:03'),(1739,'1','308',1,'Retail Sale Id 1813',0.00,3780.00,740.00,4440.00,660.00,'2023-02-01 14:56:56'),(1740,'1','308',1,'Retail Sale Id 1814',0.00,1915.20,740.00,2249.60,334.40,'2023-02-01 15:01:58'),(1741,'1','308',1,'Retail Sale Id 1815',0.00,1278.90,740.00,1502.20,223.30,'2023-02-01 15:27:30'),(1742,'1','308',1,'Retail Sale Id 1816',0.00,3786.30,740.00,4447.40,661.10,'2023-02-01 15:30:54'),(1743,'1','308',1,'Retail Sale Id 1817',0.00,850.50,740.00,999.00,148.50,'2023-02-01 16:25:48'),(1744,'1','308',1,'Retail Sale Id 1818',0.00,2551.50,740.00,2997.00,445.50,'2023-02-01 16:52:00'),(1745,'1','308',1,'Retail Sale Id 1819',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-01 17:05:02'),(1746,'1','308',1,'Retail Sale Id 1820',0.00,1890.00,740.00,2220.00,330.00,'2023-02-01 17:20:02'),(1747,'1','308',1,'Retail Sale Id 1821',0.00,1871.10,740.00,2197.80,326.70,'2023-02-01 17:26:41'),(1748,'1','308',1,'Retail Sale Id 1822',0.00,1915.20,740.00,2249.60,334.40,'2023-02-01 17:32:55'),(1749,'1','308',1,'Retail Sale Id 1823',0.00,1316.70,740.00,1546.60,229.90,'2023-02-01 17:34:36'),(1750,'1','308',1,'Retail Sale Id 1824',0.00,636.30,740.00,747.40,111.10,'2023-02-01 17:39:30'),(1751,'1','308',1,'Retail Sale Id 1825',0.00,636.30,740.00,747.40,111.10,'2023-02-01 17:41:46'),(1752,'1','308',1,'Retail Sale Id 1826',0.00,3786.30,740.00,4447.40,661.10,'2023-02-01 17:54:13'),(1753,'1','308',1,'Retail Sale Id 1827',0.00,1278.90,740.00,1502.20,223.30,'2023-02-01 17:59:30'),(1754,'1','308',1,'Retail Sale Id 1828',0.00,4428.90,740.00,5202.20,773.30,'2023-02-01 18:11:54'),(1755,'1','308',1,'Retail Sale Id 1829',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-01 18:23:33'),(1756,'1','308',1,'Retail Sale Id 1830',0.00,3786.30,740.00,4447.40,661.10,'2023-02-01 18:26:48'),(1757,'1','308',1,'Retail Sale Id 1831',0.00,1278.90,740.00,1502.20,223.30,'2023-02-01 18:28:15'),(1758,'1','308',1,'Retail Sale Id 1832',0.00,636.30,740.00,747.40,111.10,'2023-02-01 18:34:50'),(1759,'1','308',1,'Retail Sale Id 1833',0.00,2129.40,740.00,2501.20,371.80,'2023-02-01 18:39:10'),(1760,'1','308',1,'Retail Sale Id 1834',0.00,1915.20,740.00,2249.60,334.40,'2023-02-01 18:45:30'),(1761,'1','308',1,'Retail Sale Id 1835',0.00,3786.30,740.00,4447.40,661.10,'2023-02-01 18:48:09'),(1762,'1','308',1,'Retail Sale Id 1836',0.00,1278.90,740.00,1502.20,223.30,'2023-02-01 18:49:12'),(1763,'1','308',1,'Retail Sale Id 1837',0.00,1278.90,740.00,1502.20,223.30,'2023-02-01 18:50:34'),(1764,'1','308',1,'Retail Sale Id 1838',0.00,1915.20,740.00,2249.60,334.40,'2023-02-01 18:54:31'),(1765,'1','308',1,'Retail Sale Id 1839',0.00,3150.00,740.00,3700.00,550.00,'2023-02-01 18:56:23'),(1766,'1','308',1,'Retail Sale Id 1840',0.00,3150.00,740.00,3700.00,550.00,'2023-02-01 19:03:56'),(1767,'1','308',1,'Retail Sale Id 1841',0.00,1278.90,740.00,1502.20,223.30,'2023-02-01 19:05:44'),(1768,'1','308',1,'Return of Retail Sale Id 1835',3786.30,0.00,740.00,-4447.40,-661.10,'2023-02-01 20:16:45'),(1769,'1','308',1,'Retail Sale Id 1842',0.00,31.50,740.00,37.00,5.50,'2023-02-01 20:24:20'),(1770,'1','308',1,'Retail Sale Id 1843',0.00,1278.90,740.00,1502.20,223.30,'2023-02-02 07:53:48'),(1771,'1','308',1,'Retail Sale Id 1844',0.00,3408.30,740.00,4003.40,595.10,'2023-02-02 07:55:02'),(1772,'1','308',1,'Retail Sale Id 1845',0.00,1890.00,740.00,2220.00,330.00,'2023-02-02 08:03:26'),(1773,'1','308',1,'Retail Sale Id 1846',0.00,3780.00,740.00,4440.00,660.00,'2023-02-02 08:12:25'),(1774,'1','308',1,'Retail Sale Id 1847',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-02 08:17:56'),(1775,'1','308',1,'Retail Sale Id 1848',0.00,1278.90,740.00,1502.20,223.30,'2023-02-02 08:28:21'),(1776,'1','308',1,'Retail Sale Id 1849',0.00,3780.00,740.00,4440.00,660.00,'2023-02-02 08:47:35'),(1777,'1','308',1,'Retail Sale Id 1850',0.00,1890.00,740.00,2220.00,330.00,'2023-02-02 08:49:40'),(1778,'1','308',1,'Retail Sale Id 1851',0.00,1915.20,740.00,2249.60,334.40,'2023-02-02 08:51:32'),(1779,'1','308',1,'Retail Sale Id 1852',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-02 08:53:24'),(1780,'1','308',1,'Retail Sale Id 1853',0.00,5670.00,740.00,6660.00,990.00,'2023-02-02 08:56:15'),(1781,'1','308',1,'Retail Sale Id 1854',0.00,3786.30,740.00,4447.40,661.10,'2023-02-02 09:12:49'),(1782,'1','308',1,'Retail Sale Id 1855',0.00,636.30,740.00,747.40,111.10,'2023-02-02 09:36:41'),(1783,'1','308',1,'Retail Sale Id 1856',0.00,1260.00,740.00,1480.00,220.00,'2023-02-02 09:57:43'),(1784,'1','308',1,'Retail Sale Id 1857',0.00,3780.00,740.00,4440.00,660.00,'2023-02-02 10:24:34'),(1785,'1','308',1,'Retail Sale Id 1858',0.00,3748.50,740.00,4403.00,654.50,'2023-02-02 11:04:09'),(1786,'1','308',1,'Retail Sale Id 1860',0.00,1871.10,740.00,2197.80,326.70,'2023-02-02 11:09:23'),(1787,'1','308',1,'Retail Sale Id 1861',0.00,3748.50,740.00,4403.00,654.50,'2023-02-02 11:11:40'),(1788,'1','308',1,'Retail Sale Id 1862',0.00,2551.50,740.00,2997.00,445.50,'2023-02-02 11:12:29'),(1789,'1','308',1,'Retail Sale Id 1863',0.00,1278.90,740.00,1502.20,223.30,'2023-02-02 11:18:06'),(1790,'1','308',1,'Retail Sale Id 1864',0.00,2520.00,740.00,2960.00,440.00,'2023-02-02 11:45:56'),(1791,'1','308',1,'Retail Sale Id 1865',0.00,1915.20,740.00,2249.60,334.40,'2023-02-02 12:44:54'),(1792,'1','308',1,'Retail Sale Id 1866',0.00,636.30,740.00,747.40,111.10,'2023-02-02 14:03:02'),(1793,'1','308',1,'Retail Sale Id 1867',0.00,31500.00,700.00,35000.00,3500.00,'2023-02-02 14:30:26'),(1794,'1','308',1,'Retail Sale Id 1868',0.00,1701.00,740.00,1998.00,297.00,'2023-02-02 14:47:04'),(1795,'1','308',1,'Retail Sale Id 1869',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-02 15:02:54'),(1796,'1','308',1,'Retail Sale Id 1870',0.00,636.30,740.00,747.40,111.10,'2023-02-02 15:35:01'),(1797,'1','308',1,'Retail Sale Id 1871',0.00,850.50,740.00,999.00,148.50,'2023-02-02 16:18:13'),(1798,'1','308',1,'Retail Sale Id 1872',0.00,1701.00,740.00,1998.00,297.00,'2023-02-02 16:25:20'),(1799,'1','308',1,'Retail Sale Id 1873',0.00,2551.50,740.00,2997.00,445.50,'2023-02-02 16:27:22'),(1800,'1','308',1,'Retail Sale Id 1874',0.00,2551.50,740.00,2997.00,445.50,'2023-02-02 16:31:15'),(1801,'1','308',1,'Retail Sale Id 1875',0.00,1278.90,740.00,1502.20,223.30,'2023-02-02 16:33:43'),(1802,'1','308',1,'Retail Sale Id 1876',0.00,3780.00,740.00,4440.00,660.00,'2023-02-02 16:36:05'),(1803,'1','308',1,'Retail Sale Id 1877',0.00,2520.00,740.00,2960.00,440.00,'2023-02-02 17:15:20'),(1804,'1','308',1,'Retail Sale Id 1878',0.00,3150.00,740.00,3700.00,550.00,'2023-02-02 17:48:36'),(1805,'1','308',1,'Retail Sale Id 1879',0.00,636.30,740.00,747.40,111.10,'2023-02-02 17:49:51'),(1806,'1','308',1,'Retail Sale Id 1880',0.00,1278.90,740.00,1502.20,223.30,'2023-02-02 18:08:52'),(1807,'1','308',1,'Retail Sale Id 1881',0.00,1278.90,740.00,1502.20,223.30,'2023-02-02 18:10:12'),(1808,'1','308',1,'Retail Sale Id 1882',0.00,636.30,740.00,747.40,111.10,'2023-02-02 18:20:11'),(1809,'1','308',1,'Retail Sale Id 1883',0.00,1278.90,740.00,1502.20,223.30,'2023-02-02 18:29:15'),(1810,'1','308',1,'Retail Sale Id 1884',0.00,428.40,740.00,503.20,74.80,'2023-02-02 18:39:04'),(1811,'1','308',1,'Retail Sale Id 1885',0.00,3150.00,740.00,3700.00,550.00,'2023-02-02 18:43:46'),(1812,'1','308',1,'Retail Sale Id 1886',0.00,850.50,740.00,999.00,148.50,'2023-02-02 18:55:27'),(1813,'1','308',1,'Retail Sale Id 1887',0.00,28350.00,700.00,31500.00,3150.00,'2023-02-02 19:03:52'),(1814,'1','308',1,'Retail Sale Id 1888',0.00,3786.30,740.00,4447.40,661.10,'2023-02-02 19:05:47'),(1815,'1','308',1,'Retail Sale Id 1889',0.00,1260.00,740.00,1480.00,220.00,'2023-02-02 19:13:20'),(1816,'1','308',1,'Retail Sale Id 1890',0.00,31.50,740.00,37.00,5.50,'2023-02-02 19:25:41'),(1817,'1','308',1,'Return of Retail Sale Id 1867',31500.00,0.00,700.00,-35000.00,-3500.00,'2023-02-02 19:32:55'),(1818,'1','308',1,'Retail Sale Id 1891',0.00,31500.00,700.00,35000.00,3500.00,'2023-02-02 19:33:31'),(1819,'1','308',1,'Retail Sale Id 1892',0.00,2520.00,740.00,2960.00,440.00,'2023-02-02 19:35:51'),(1820,'1','308',1,'Retail Sale Id 1893',0.00,5040.00,740.00,5920.00,880.00,'2023-02-03 07:45:43'),(1821,'1','308',1,'Retail Sale Id 1894',0.00,1278.90,740.00,1502.20,223.30,'2023-02-03 08:34:09'),(1822,'1','308',1,'Retail Sale Id 1895',0.00,1890.00,740.00,2220.00,330.00,'2023-02-03 08:39:54'),(1823,'1','308',1,'Retail Sale Id 1896',0.00,3780.00,740.00,4440.00,660.00,'2023-02-03 08:48:26'),(1824,'1','308',1,'Retail Sale Id 1897',0.00,15750.00,700.00,17500.00,1750.00,'2023-02-03 08:51:59'),(1825,'1','308',1,'Retail Sale Id 1898',0.00,1278.90,740.00,1502.20,223.30,'2023-02-03 09:02:43'),(1826,'1','308',1,'Retail Sale Id 1899',0.00,636.30,740.00,747.40,111.10,'2023-02-03 09:03:39'),(1827,'1','308',1,'Retail Sale Id 1900',0.00,3150.00,740.00,3700.00,550.00,'2023-02-03 09:08:45'),(1828,'1','308',1,'Retail Sale Id 1901',0.00,1890.00,740.00,2220.00,330.00,'2023-02-03 09:11:18'),(1829,'1','308',1,'Retail Sale Id 1902',0.00,4410.00,740.00,5180.00,770.00,'2023-02-03 09:23:47'),(1830,'1','308',1,'Retail Sale Id 1903',0.00,1260.00,740.00,1480.00,220.00,'2023-02-03 09:44:09'),(1831,'1','308',1,'Retail Sale Id 1904',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-03 09:46:57'),(1832,'1','308',1,'Retail Sale Id 1905',0.00,1890.00,740.00,2220.00,330.00,'2023-02-03 10:38:07'),(1833,'1','308',1,'Retail Sale Id 1906',0.00,1278.90,740.00,1502.20,223.30,'2023-02-03 10:43:19'),(1834,'1','308',1,'Retail Sale Id 1907',0.00,3780.00,740.00,4440.00,660.00,'2023-02-03 11:05:55'),(1835,'1','308',1,'Retail Sale Id 1908',0.00,3150.00,740.00,3700.00,550.00,'2023-02-03 11:42:37'),(1836,'1','308',1,'Retail Sale Id 1909',0.00,850.50,740.00,999.00,148.50,'2023-02-03 11:50:52'),(1837,'1','308',1,'Retail Sale Id 1910',0.00,1278.90,740.00,1502.20,223.30,'2023-02-03 12:16:41'),(1838,'1','308',1,'Retail Sale Id 1911',0.00,3780.00,740.00,4440.00,660.00,'2023-02-03 13:01:03'),(1839,'1','308',1,'Retail Sale Id 1912',0.00,2520.00,740.00,2960.00,440.00,'2023-02-03 13:05:07'),(1840,'1','308',1,'Retail Sale Id 1914',0.00,1260.00,740.00,1480.00,220.00,'2023-02-03 13:22:04'),(1841,'1','308',1,'Retail Sale Id 1915',0.00,1890.00,740.00,2220.00,330.00,'2023-02-03 14:20:34'),(1842,'1','308',1,'Retail Sale Id 1916',0.00,636.30,740.00,747.40,111.10,'2023-02-03 14:22:08'),(1843,'1','308',1,'Retail Sale Id 1917',0.00,1890.00,740.00,2220.00,330.00,'2023-02-03 14:26:01'),(1844,'1','308',1,'Retail Sale Id 1918',0.00,3780.00,740.00,4440.00,660.00,'2023-02-03 14:30:00'),(1845,'1','308',1,'Retail Sale Id 1919',0.00,3780.00,740.00,4440.00,660.00,'2023-02-03 14:32:47'),(1846,'1','308',1,'Retail Sale Id 1921',0.00,1619.10,740.00,1901.80,282.70,'2023-02-03 15:37:21'),(1847,'1','308',1,'Retail Sale Id 1922',0.00,2551.50,740.00,2997.00,445.50,'2023-02-03 15:43:10'),(1848,'1','308',1,'Retail Sale Id 1923',0.00,2551.50,740.00,2997.00,445.50,'2023-02-03 15:45:02'),(1849,'1','308',1,'Retail Sale Id 1925',0.00,1915.20,740.00,2249.60,334.40,'2023-02-03 15:54:58'),(1850,'1','308',1,'Retail Sale Id 1926',0.00,1278.90,740.00,1502.20,223.30,'2023-02-03 15:56:31'),(1851,'1','308',1,'Retail Sale Id 1928',0.00,1890.00,740.00,2220.00,330.00,'2023-02-03 15:58:49'),(1852,'1','308',1,'Retail Sale Id 1929',0.00,598.50,740.00,703.00,104.50,'2023-02-03 16:21:48'),(1853,'1','308',1,'Retail Sale Id 1930',0.00,680.40,740.00,799.20,118.80,'2023-02-03 16:27:47'),(1854,'1','308',1,'Retail Sale Id 1931',0.00,1278.90,740.00,1502.20,223.30,'2023-02-03 16:36:46'),(1855,'1','308',1,'Retail Sale Id 1933',0.00,1278.90,740.00,1502.20,223.30,'2023-02-03 16:45:28'),(1856,'1','308',1,'Retail Sale Id 1934',0.00,636.30,740.00,747.40,111.10,'2023-02-03 16:49:09'),(1857,'1','308',1,'Retail Sale Id 1935',0.00,3150.00,740.00,3700.00,550.00,'2023-02-03 16:55:05'),(1858,'1','308',1,'Retail Sale Id 1936',0.00,2520.00,740.00,2960.00,440.00,'2023-02-03 16:58:42'),(1859,'1','308',1,'Retail Sale Id 1937',0.00,850.50,740.00,999.00,148.50,'2023-02-03 16:59:51'),(1860,'1','308',1,'Retail Sale Id 1939',0.00,1890.00,740.00,2220.00,330.00,'2023-02-03 17:10:51'),(1861,'1','308',1,'Retail Sale Id 1941',0.00,1278.90,740.00,1502.20,223.30,'2023-02-03 17:42:23'),(1862,'1','308',1,'Retail Sale Id 1942',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-03 17:47:04'),(1863,'1','308',1,'Retail Sale Id 1945',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-03 17:58:20'),(1864,'1','308',1,'Retail Sale Id 1946',0.00,7560.00,740.00,8880.00,1320.00,'2023-02-03 18:06:17'),(1865,'1','308',1,'Retail Sale Id 1947',0.00,630.00,740.00,740.00,110.00,'2023-02-03 18:08:28'),(1866,'1','308',1,'Retail Sale Id 1949',0.00,1278.90,740.00,1502.20,223.30,'2023-02-03 19:00:59'),(1867,'1','308',1,'Retail Sale Id 1950',0.00,1896.30,740.00,2227.40,331.10,'2023-02-03 19:03:30'),(1868,'1','308',1,'Retail Sale Id 1951',0.00,1915.20,740.00,2249.60,334.40,'2023-02-04 07:52:29'),(1869,'1','308',1,'Retail Sale Id 1952',0.00,3150.00,740.00,3700.00,550.00,'2023-02-04 07:54:00'),(1870,'1','308',1,'Retail Sale Id 1953',0.00,2551.50,740.00,2997.00,445.50,'2023-02-04 07:55:35'),(1871,'1','308',1,'Retail Sale Id 1954',0.00,1890.00,740.00,2220.00,330.00,'2023-02-04 08:09:48'),(1872,'1','308',1,'Retail Sale Id 1955',0.00,1871.10,740.00,2197.80,326.70,'2023-02-04 08:11:20'),(1873,'1','308',1,'Retail Sale Id 1956',0.00,63000.00,700.00,70000.00,7000.00,'2023-02-04 08:26:06'),(1874,'1','308',1,'Retail Sale Id 1957',0.00,1260.00,740.00,1480.00,220.00,'2023-02-04 08:28:07'),(1875,'1','308',1,'Retail Sale Id 1958',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-04 08:31:09'),(1876,'1','308',1,'Retail Sale Id 1959',0.00,3780.00,740.00,4440.00,660.00,'2023-02-04 08:37:26'),(1877,'1','308',1,'Retail Sale Id 1960',0.00,1915.20,740.00,2249.60,334.40,'2023-02-04 09:07:22'),(1878,'1','308',1,'Retail Sale Id 1961',0.00,850.50,740.00,999.00,148.50,'2023-02-04 09:08:22'),(1879,'1','308',1,'Retail Sale Id 1962',0.00,3150.00,740.00,3700.00,550.00,'2023-02-04 09:09:30'),(1880,'1','308',1,'Retail Sale Id 1963',0.00,2520.00,740.00,2960.00,440.00,'2023-02-04 09:10:50'),(1881,'1','308',1,'Retail Sale Id 1964',0.00,636.30,740.00,747.40,111.10,'2023-02-04 09:11:54'),(1882,'1','308',1,'Retail Sale Id 1965',0.00,3786.30,740.00,4447.40,661.10,'2023-02-04 09:13:00'),(1883,'1','308',1,'Retail Sale Id 1966',0.00,1278.90,740.00,1502.20,223.30,'2023-02-04 09:13:53'),(1884,'1','308',1,'Retail Sale Id 1967',0.00,1278.90,740.00,1502.20,223.30,'2023-02-04 09:14:40'),(1885,'1','308',1,'Retail Sale Id 1968',0.00,2551.50,740.00,2997.00,445.50,'2023-02-04 09:16:28'),(1886,'1','308',1,'Retail Sale Id 1969',0.00,31500.00,700.00,35000.00,3500.00,'2023-02-04 09:35:02'),(1887,'1','308',1,'Retail Sale Id 1970',0.00,1890.00,740.00,2220.00,330.00,'2023-02-04 09:48:13'),(1888,'1','308',1,'Retail Sale Id 1971',0.00,636.30,740.00,747.40,111.10,'2023-02-04 09:49:14'),(1889,'1','308',1,'Retail Sale Id 1972',0.00,28350.00,700.00,31500.00,3150.00,'2023-02-04 10:14:14'),(1890,'1','308',1,'Retail Sale Id 1973',0.00,630.00,740.00,740.00,110.00,'2023-02-04 10:34:16'),(1891,'1','308',1,'Retail Sale Id 1974',0.00,1890.00,740.00,2220.00,330.00,'2023-02-04 10:35:03'),(1892,'1','308',1,'Retail Sale Id 1975',0.00,2520.00,740.00,2960.00,440.00,'2023-02-04 10:40:05'),(1893,'1','308',1,'Retail Sale Id 1976',0.00,1260.00,740.00,1480.00,220.00,'2023-02-04 10:48:52'),(1894,'1','308',1,'Retail Sale Id 1977',0.00,2551.50,740.00,2997.00,445.50,'2023-02-04 10:57:26'),(1895,'1','308',1,'Retail Sale Id 1978',0.00,636.30,740.00,747.40,111.10,'2023-02-04 10:59:10'),(1896,'1','308',1,'Retail Sale Id 1979',0.00,636.30,740.00,747.40,111.10,'2023-02-04 11:00:43'),(1897,'1','308',1,'Retail Sale Id 1980',0.00,1915.20,740.00,2249.60,334.40,'2023-02-04 11:02:13'),(1898,'1','308',1,'Retail Sale Id 1981',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-04 11:11:27'),(1899,'1','308',1,'Retail Sale Id 1982',0.00,3780.00,740.00,4440.00,660.00,'2023-02-04 11:22:15'),(1900,'1','308',1,'Retail Sale Id 1983',0.00,1278.90,740.00,1502.20,223.30,'2023-02-04 11:24:23'),(1901,'1','308',1,'Retail Sale Id 1984',0.00,850.50,740.00,999.00,148.50,'2023-02-04 11:29:25'),(1902,'1','308',1,'Retail Sale Id 1985',0.00,630.00,740.00,740.00,110.00,'2023-02-04 11:46:37'),(1903,'1','308',1,'Retail Sale Id 1986',0.00,7560.00,740.00,8880.00,1320.00,'2023-02-04 11:47:59'),(1904,'1','308',1,'Retail Sale Id 1987',0.00,1260.00,740.00,1480.00,220.00,'2023-02-04 11:49:09'),(1905,'1','308',1,'Retail Sale Id 1988',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-04 11:49:59'),(1906,'1','308',1,'Retail Sale Id 1989',0.00,4428.90,740.00,5202.20,773.30,'2023-02-04 11:51:43'),(1907,'1','308',1,'Retail Sale Id 1990',0.00,3150.00,740.00,3700.00,550.00,'2023-02-04 11:53:13'),(1908,'1','308',1,'Retail Sale Id 1991',0.00,3150.00,740.00,3700.00,550.00,'2023-02-04 12:08:24'),(1909,'1','308',1,'Retail Sale Id 1992',0.00,3150.00,740.00,3700.00,550.00,'2023-02-04 12:17:29'),(1910,'1','308',1,'Retail Sale Id 1993',0.00,2520.00,740.00,2960.00,440.00,'2023-02-04 12:19:25'),(1911,'1','308',1,'Retail Sale Id 1994',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-04 12:36:04'),(1912,'1','308',1,'Retail Sale Id 1995',0.00,1890.00,740.00,2220.00,330.00,'2023-02-04 13:06:43'),(1913,'1','308',1,'Retail Sale Id 1996',0.00,15750.00,700.00,17500.00,1750.00,'2023-02-04 13:09:09'),(1914,'1','308',1,'Retail Sale Id 1997',0.00,1260.00,740.00,1480.00,220.00,'2023-02-04 13:10:01'),(1915,'1','308',1,'Retail Sale Id 1998',0.00,36540.00,700.00,40600.00,4060.00,'2023-02-04 13:36:25'),(1916,'1','308',1,'Retail Sale Id 1999',0.00,3786.30,740.00,4447.40,661.10,'2023-02-04 13:37:09'),(1917,'1','308',1,'Retail Sale Id 2000',0.00,1260.00,740.00,1480.00,220.00,'2023-02-04 14:27:43'),(1918,'1','308',1,'Retail Sale Id 2001',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-04 14:29:37'),(1919,'1','308',1,'Retail Sale Id 2002',0.00,1278.90,740.00,1502.20,223.30,'2023-02-04 14:32:57'),(1920,'1','308',1,'Retail Sale Id 2003',0.00,1915.20,740.00,2249.60,334.40,'2023-02-04 14:46:47'),(1921,'1','308',1,'Retail Sale Id 2005',0.00,3786.30,740.00,4447.40,661.10,'2023-02-04 15:18:17'),(1922,'1','308',1,'Retail Sale Id 2006',0.00,636.30,740.00,747.40,111.10,'2023-02-04 15:19:58'),(1923,'1','308',1,'Retail Sale Id 2007',0.00,2520.00,740.00,2960.00,440.00,'2023-02-04 15:22:27'),(1924,'1','308',1,'Retail Sale Id 2008',0.00,31500.00,700.00,35000.00,3500.00,'2023-02-04 15:38:23'),(1925,'1','308',1,'Retail Sale Id 2009',0.00,636.30,740.00,747.40,111.10,'2023-02-04 15:40:18'),(1926,'1','308',1,'Retail Sale Id 2010',0.00,1890.00,740.00,2220.00,330.00,'2023-02-04 15:43:57'),(1927,'1','308',1,'Retail Sale Id 2011',0.00,636.30,740.00,747.40,111.10,'2023-02-04 15:47:57'),(1928,'1','308',1,'Retail Sale Id 2012',0.00,1890.00,740.00,2220.00,330.00,'2023-02-04 16:02:39'),(1929,'1','308',1,'Retail Sale Id 2013',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-04 16:03:17'),(1930,'1','308',1,'Retail Sale Id 2014',0.00,31500.00,700.00,35000.00,3500.00,'2023-02-04 16:05:42'),(1931,'1','308',1,'Retail Sale Id 2015',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-04 16:06:33'),(1932,'1','308',1,'Retail Sale Id 2016',0.00,3780.00,740.00,4440.00,660.00,'2023-02-04 16:13:12'),(1933,'1','308',1,'Retail Sale Id 2017',0.00,3780.00,740.00,4440.00,660.00,'2023-02-04 16:26:15'),(1934,'1','308',1,'Retail Sale Id 2018',0.00,850.50,740.00,999.00,148.50,'2023-02-04 16:43:05'),(1935,'1','308',1,'Retail Sale Id 2019',0.00,1278.90,740.00,1502.20,223.30,'2023-02-04 16:45:56'),(1936,'1','308',1,'Retail Sale Id 2020',0.00,1701.00,740.00,1998.00,297.00,'2023-02-04 16:48:14'),(1937,'1','308',1,'Retail Sale Id 2021',0.00,1915.20,740.00,2249.60,334.40,'2023-02-04 16:49:09'),(1938,'1','308',1,'Retail Sale Id 2022',0.00,14175.00,740.00,16650.00,2475.00,'2023-02-04 17:10:39'),(1939,'1','308',1,'Retail Sale Id 2023',0.00,1871.10,740.00,2197.80,326.70,'2023-02-04 17:15:03'),(1940,'1','308',1,'Retail Sale Id 2024',0.00,1915.20,740.00,2249.60,334.40,'2023-02-04 17:25:39'),(1941,'1','308',1,'Retail Sale Id 2025',0.00,2551.50,740.00,2997.00,445.50,'2023-02-04 17:26:32'),(1942,'1','308',1,'Retail Sale Id 2026',0.00,1915.20,740.00,2249.60,334.40,'2023-02-04 17:28:00'),(1943,'1','308',1,'Retail Sale Id 2027',0.00,2551.50,740.00,2997.00,445.50,'2023-02-04 17:34:57'),(1944,'1','308',1,'Retail Sale Id 2028',0.00,2551.50,740.00,2997.00,445.50,'2023-02-04 17:40:33'),(1945,'1','308',1,'Retail Sale Id 2030',0.00,1278.90,740.00,1502.20,223.30,'2023-02-04 17:42:17'),(1946,'1','308',1,'Retail Sale Id 2031',0.00,2129.40,740.00,2501.20,371.80,'2023-02-04 17:46:31'),(1947,'1','308',1,'Retail Sale Id 2032',0.00,1278.90,740.00,1502.20,223.30,'2023-02-04 17:47:34'),(1948,'1','308',1,'Retail Sale Id 2033',0.00,636.30,740.00,747.40,111.10,'2023-02-04 18:13:01'),(1949,'1','308',1,'Retail Sale Id 2034',0.00,1278.90,740.00,1502.20,223.30,'2023-02-04 18:14:33'),(1950,'1','308',1,'Retail Sale Id 2035',0.00,2041.20,740.00,2397.60,356.40,'2023-02-04 18:24:22'),(1951,'1','308',1,'Retail Sale Id 2036',0.00,850.50,740.00,999.00,148.50,'2023-02-04 18:33:14'),(1952,'1','308',1,'Retail Sale Id 2037',0.00,3408.30,740.00,4003.40,595.10,'2023-02-04 18:36:30'),(1953,'1','308',1,'Retail Sale Id 2038',0.00,1278.90,740.00,1502.20,223.30,'2023-02-04 18:37:25'),(1954,'1','308',1,'Retail Sale Id 2039',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-04 18:38:47'),(1955,'1','308',1,'Retail Sale Id 2040',0.00,3150.00,740.00,3700.00,550.00,'2023-02-04 18:51:29'),(1956,'1','308',1,'Retail Sale Id 2041',0.00,3150.00,740.00,3700.00,550.00,'2023-02-04 18:54:11'),(1957,'1','308',1,'Retail Sale Id 2042',0.00,2520.00,740.00,2960.00,440.00,'2023-02-04 18:55:34'),(1958,'1','308',1,'Retail Sale Id 2043',0.00,636.30,740.00,747.40,111.10,'2023-02-04 19:11:02'),(1959,'1','308',1,'Retail Sale Id 2044',0.00,11365.20,740.00,13349.60,1984.40,'2023-02-05 09:37:08'),(1960,'1','308',1,'Retail Sale Id 2045',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-05 09:38:11'),(1961,'1','308',1,'Retail Sale Id 2046',0.00,1890.00,740.00,2220.00,330.00,'2023-02-05 09:42:09'),(1962,'1','308',1,'Retail Sale Id 2047',0.00,15750.00,700.00,17500.00,1750.00,'2023-02-05 10:20:50'),(1963,'1','308',1,'Retail Sale Id 2048',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-05 10:32:59'),(1964,'1','308',1,'Retail Sale Id 2049',0.00,3780.00,740.00,4440.00,660.00,'2023-02-05 10:51:29'),(1965,'1','308',1,'Retail Sale Id 2050',0.00,1278.90,740.00,1502.20,223.30,'2023-02-05 11:09:15'),(1966,'1','308',1,'Retail Sale Id 2052',0.00,636.30,740.00,747.40,111.10,'2023-02-05 11:38:06'),(1967,'1','308',1,'Retail Sale Id 2053',0.00,3792.60,740.00,4454.80,662.20,'2023-02-05 12:14:31'),(1968,'1','308',1,'Retail Sale Id 2054',0.00,19101.60,740.00,22436.80,3335.20,'2023-02-05 13:45:12'),(1969,'1','308',1,'Retail Sale Id 2055',0.00,4428.90,740.00,5202.20,773.30,'2023-02-05 13:57:45'),(1970,'1','308',1,'Retail Sale Id 2056',0.00,66150.00,740.00,77700.00,11550.00,'2023-02-05 14:02:06'),(1971,'1','308',1,'Retail Sale Id 2058',0.00,3194.10,740.00,3751.80,557.70,'2023-02-05 14:32:02'),(1972,'1','308',1,'Retail Sale Id 2059',0.00,35368.20,740.00,41543.60,6175.40,'2023-02-05 17:20:43'),(1973,'1','308',1,'Retail Sale Id 2060',0.00,850.50,740.00,999.00,148.50,'2023-02-05 17:22:37'),(1974,'1','308',1,'Retail Sale Id 2061',0.00,21867.30,740.00,25685.40,3818.10,'2023-02-05 19:16:54'),(1975,'1','308',1,'Return of Retail Sale Id 2061',21867.30,0.00,740.00,-25685.40,-3818.10,'2023-02-05 19:20:04'),(1976,'1','308',1,'Retail Sale Id 2062',0.00,6967.80,740.00,8184.40,1216.60,'2023-02-05 19:21:20'),(1977,'1','308',1,'Retail Sale Id 2064',0.00,1890.00,740.00,2220.00,330.00,'2023-02-06 14:26:34'),(1978,'1','308',1,'Retail Sale Id 2065',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-06 14:29:06'),(1979,'1','308',1,'Retail Sale Id 2066',0.00,1871.10,740.00,2197.80,326.70,'2023-02-06 14:30:02'),(1980,'1','308',1,'Retail Sale Id 2067',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-06 14:30:36'),(1981,'1','308',1,'Retail Sale Id 2068',0.00,5040.00,740.00,5920.00,880.00,'2023-02-06 14:31:44'),(1982,'1','308',1,'Retail Sale Id 2069',0.00,31500.00,700.00,35000.00,3500.00,'2023-02-06 15:56:42'),(1983,'1','308',1,'Retail Sale Id 2070',0.00,3956.40,740.00,4647.20,690.80,'2023-02-06 15:58:06'),(1984,'1','308',1,'Retail Sale Id 2071',0.00,1278.90,740.00,1502.20,223.30,'2023-02-06 15:58:56'),(1985,'1','308',1,'Retail Sale Id 2072',0.00,45637.20,740.00,53605.60,7968.40,'2023-02-06 16:06:56'),(1986,'1','308',1,'Retail Sale Id 2073',0.00,142203.60,700.00,158004.00,15800.40,'2023-02-06 16:10:05'),(1987,'1','308',1,'Retail Sale Id 2074',0.00,630.00,740.00,740.00,110.00,'2023-02-06 16:13:47'),(1988,'1','308',1,'Retail Sale Id 2075',0.00,1890.00,740.00,2220.00,330.00,'2023-02-06 16:17:26'),(1989,'1','308',1,'Retail Sale Id 2076',0.00,598.50,740.00,703.00,104.50,'2023-02-06 16:33:07'),(1990,'1','308',1,'Return of Retail Sale Id 2066',1871.10,0.00,740.00,-2197.80,-326.70,'2023-02-06 16:35:00'),(1991,'1','308',1,'Retail Sale Id 2077',0.00,2551.50,740.00,2997.00,445.50,'2023-02-06 17:13:16'),(1992,'1','308',1,'Retail Sale Id 2078',0.00,1871.10,740.00,2197.80,326.70,'2023-02-06 17:36:22'),(1993,'1','308',1,'Retail Sale Id 2079',0.00,636.30,740.00,747.40,111.10,'2023-02-06 17:39:01'),(1994,'1','308',1,'Retail Sale Id 2080',0.00,636.30,740.00,747.40,111.10,'2023-02-06 17:42:34'),(1995,'1','308',1,'Retail Sale Id 2081',0.00,1896.30,740.00,2227.40,331.10,'2023-02-06 17:48:58'),(1996,'1','308',1,'Retail Sale Id 2082',0.00,1701.00,740.00,1998.00,297.00,'2023-02-06 17:56:47'),(1997,'1','308',1,'Retail Sale Id 2083',0.00,3786.30,740.00,4447.40,661.10,'2023-02-06 18:15:45'),(1998,'1','308',1,'Retail Sale Id 2084',0.00,1278.90,740.00,1502.20,223.30,'2023-02-06 18:25:46'),(1999,'1','308',1,'Retail Sale Id 2085',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-06 18:32:45'),(2000,'1','308',1,'Retail Sale Id 2086',0.00,630.00,740.00,740.00,110.00,'2023-02-06 18:43:11'),(2001,'1','308',1,'Retail Sale Id 2087',0.00,1890.00,740.00,2220.00,330.00,'2023-02-06 18:43:53'),(2002,'1','308',1,'Retail Sale Id 2088',0.00,1890.00,740.00,2220.00,330.00,'2023-02-07 07:52:21'),(2003,'1','308',1,'Retail Sale Id 2089',0.00,63000.00,700.00,70000.00,7000.00,'2023-02-07 07:59:39'),(2004,'1','308',1,'Retail Sale Id 2090',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-07 08:04:01'),(2005,'1','308',1,'Retail Sale Id 2091',0.00,1959.30,740.00,2301.40,342.10,'2023-02-07 08:06:58'),(2006,'1','308',1,'Retail Sale Id 2093',0.00,1915.20,740.00,2249.60,334.40,'2023-02-07 08:14:20'),(2007,'1','308',1,'Retail Sale Id 2094',0.00,636.30,740.00,747.40,111.10,'2023-02-07 08:17:50'),(2008,'1','308',1,'Retail Sale Id 2096',0.00,3830.40,740.00,4499.20,668.80,'2023-02-07 08:22:10'),(2009,'1','308',1,'Retail Sale Id 2099',0.00,1915.20,740.00,2249.60,334.40,'2023-02-07 08:27:13'),(2010,'1','308',1,'Retail Sale Id 2100',0.00,1871.10,740.00,2197.80,326.70,'2023-02-07 08:30:37'),(2011,'1','308',1,'Retail Sale Id 2101',0.00,680.40,740.00,799.20,118.80,'2023-02-07 08:57:22'),(2012,'1','308',1,'Retail Sale Id 2102',0.00,31500.00,700.00,35000.00,3500.00,'2023-02-07 09:09:16'),(2013,'1','308',1,'Retail Sale Id 2105',0.00,1890.00,740.00,2220.00,330.00,'2023-02-07 09:11:45'),(2014,'1','308',1,'Retail Sale Id 2106',0.00,2520.00,740.00,2960.00,440.00,'2023-02-07 09:15:33'),(2015,'1','308',1,'Retail Sale Id 2107',0.00,636.30,740.00,747.40,111.10,'2023-02-07 09:25:15'),(2016,'1','308',1,'Retail Sale Id 2109',0.00,636.30,740.00,747.40,111.10,'2023-02-07 09:34:02'),(2017,'1','308',1,'Retail Sale Id 2111',0.00,636.30,740.00,747.40,111.10,'2023-02-07 09:47:31'),(2018,'1','308',1,'Retail Sale Id 2113',0.00,1278.90,740.00,1502.20,223.30,'2023-02-07 09:50:39'),(2019,'1','308',1,'Retail Sale Id 2114',0.00,7560.00,740.00,8880.00,1320.00,'2023-02-07 09:53:38'),(2020,'1','308',1,'Retail Sale Id 2116',0.00,2520.00,740.00,2960.00,440.00,'2023-02-07 10:37:16'),(2021,'1','308',1,'Retail Sale Id 2117',0.00,2520.00,740.00,2960.00,440.00,'2023-02-07 11:16:57'),(2022,'1','308',1,'Retail Sale Id 2118',0.00,1915.20,740.00,2249.60,334.40,'2023-02-07 11:39:50'),(2023,'1','308',1,'Retail Sale Id 2119',0.00,2551.50,740.00,2997.00,445.50,'2023-02-07 11:43:12'),(2024,'1','308',1,'Retail Sale Id 2121',0.00,680.40,740.00,799.20,118.80,'2023-02-07 11:48:21'),(2025,'1','308',1,'Retail Sale Id 2122',0.00,3780.00,740.00,4440.00,660.00,'2023-02-07 12:29:43'),(2026,'1','308',1,'Retail Sale Id 2123',0.00,15750.00,700.00,17500.00,1750.00,'2023-02-07 12:34:15'),(2027,'1','308',1,'Retail Sale Id 2124',0.00,3150.00,740.00,3700.00,550.00,'2023-02-07 12:43:52'),(2028,'1','308',1,'Retail Sale Id 2125',0.00,1278.90,740.00,1502.20,223.30,'2023-02-07 12:53:43'),(2029,'1','308',1,'Retail Sale Id 2126',0.00,14175.00,740.00,16650.00,2475.00,'2023-02-07 12:57:38'),(2030,'1','308',1,'Retail Sale Id 2127',0.00,3150.00,740.00,3700.00,550.00,'2023-02-07 13:00:17'),(2031,'1','308',1,'Retail Sale Id 2128',0.00,31500.00,700.00,35000.00,3500.00,'2023-02-07 13:19:14'),(2032,'1','308',1,'Retail Sale Id 2129',0.00,63000.00,700.00,70000.00,7000.00,'2023-02-07 13:37:48'),(2033,'1','308',1,'Retail Sale Id 2131',0.00,3150.00,740.00,3700.00,550.00,'2023-02-07 14:22:53'),(2034,'1','308',1,'Retail Sale Id 2132',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-07 15:04:18'),(2035,'1','308',1,'Retail Sale Id 2133',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-07 15:19:42'),(2036,'1','308',1,'Retail Sale Id 2134',0.00,636.30,740.00,747.40,111.10,'2023-02-07 15:20:56'),(2037,'1','308',1,'Retail Sale Id 2135',0.00,3150.00,740.00,3700.00,550.00,'2023-02-07 15:32:24'),(2038,'1','308',1,'Retail Sale Id 2136',0.00,7560.00,740.00,8880.00,1320.00,'2023-02-07 16:04:01'),(2039,'1','308',1,'Retail Sale Id 2137',0.00,1278.90,740.00,1502.20,223.30,'2023-02-07 16:23:41'),(2040,'1','308',1,'Retail Sale Id 2138',0.00,63000.00,700.00,70000.00,7000.00,'2023-02-07 16:38:38'),(2041,'1','308',1,'Retail Sale Id 2139',0.00,850.50,740.00,999.00,148.50,'2023-02-07 16:41:53'),(2042,'1','308',1,'Retail Sale Id 2140',0.00,1915.20,740.00,2249.60,334.40,'2023-02-07 16:47:39'),(2043,'1','308',1,'Retail Sale Id 2141',0.00,1915.20,740.00,2249.60,334.40,'2023-02-07 17:00:11'),(2044,'1','308',1,'Retail Sale Id 2142',0.00,3150.00,740.00,3700.00,550.00,'2023-02-07 17:12:07'),(2045,'1','308',1,'Retail Sale Id 2143',0.00,1278.90,740.00,1502.20,223.30,'2023-02-07 17:27:33'),(2046,'1','308',1,'Retail Sale Id 2144',0.00,1915.20,740.00,2249.60,334.40,'2023-02-07 17:39:42'),(2047,'1','308',1,'Retail Sale Id 2145',0.00,1260.00,740.00,1480.00,220.00,'2023-02-07 17:40:41'),(2048,'1','308',1,'Retail Sale Id 2146',0.00,2551.50,740.00,2997.00,445.50,'2023-02-07 17:52:14'),(2049,'1','308',1,'Retail Sale Id 2147',0.00,3150.00,740.00,3700.00,550.00,'2023-02-07 17:53:04'),(2050,'1','308',1,'Retail Sale Id 2148',0.00,3150.00,740.00,3700.00,550.00,'2023-02-07 17:55:54'),(2051,'1','308',1,'Retail Sale Id 2149',0.00,5040.00,740.00,5920.00,880.00,'2023-02-07 18:04:23'),(2052,'1','308',1,'Retail Sale Id 2150',0.00,1890.00,740.00,2220.00,330.00,'2023-02-07 18:05:07'),(2053,'1','308',1,'Retail Sale Id 2151',0.00,3786.30,740.00,4447.40,661.10,'2023-02-07 18:05:56'),(2054,'1','308',1,'Retail Sale Id 2152',0.00,3780.00,740.00,4440.00,660.00,'2023-02-07 18:16:38'),(2055,'1','308',1,'Retail Sale Id 2154',0.00,28350.00,700.00,31500.00,3150.00,'2023-02-07 18:19:07'),(2056,'1','308',1,'Retail Sale Id 2155',0.00,1278.90,740.00,1502.20,223.30,'2023-02-07 18:20:22'),(2057,'1','308',1,'Retail Sale Id 2156',0.00,3150.00,740.00,3700.00,550.00,'2023-02-07 18:21:16'),(2058,'1','308',1,'Retail Sale Id 2157',0.00,1449.00,740.00,1702.00,253.00,'2023-02-07 19:37:44'),(2059,'1','308',1,'Retail Sale Id 2158',0.00,1682.10,740.00,1975.80,293.70,'2023-02-07 20:00:02'),(2060,'1','308',1,'Retail Sale Id 2159',0.00,1890.00,740.00,2220.00,330.00,'2023-02-08 07:39:04'),(2061,'1','308',1,'Retail Sale Id 2161',0.00,3150.00,740.00,3700.00,550.00,'2023-02-08 08:09:09'),(2062,'1','308',1,'Retail Sale Id 2162',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-08 08:10:17'),(2063,'1','308',1,'Retail Sale Id 2163',0.00,3150.00,740.00,3700.00,550.00,'2023-02-08 08:13:37'),(2064,'1','308',1,'Retail Sale Id 2164',0.00,3780.00,740.00,4440.00,660.00,'2023-02-08 08:18:36'),(2065,'1','308',1,'Retail Sale Id 2165',0.00,1260.00,740.00,1480.00,220.00,'2023-02-08 08:24:24'),(2066,'1','308',1,'Retail Sale Id 2166',0.00,1890.00,740.00,2220.00,330.00,'2023-02-08 08:31:35'),(2067,'1','308',1,'Retail Sale Id 2167',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-08 08:40:01'),(2068,'1','308',1,'Retail Sale Id 2168',0.00,1278.90,740.00,1502.20,223.30,'2023-02-08 09:11:49'),(2069,'1','308',1,'Retail Sale Id 2170',0.00,3786.30,740.00,4447.40,661.10,'2023-02-08 09:16:42'),(2070,'1','308',1,'Retail Sale Id 2171',0.00,3150.00,740.00,3700.00,550.00,'2023-02-08 09:40:32'),(2071,'1','308',1,'Retail Sale Id 2172',0.00,4410.00,740.00,5180.00,770.00,'2023-02-08 09:44:13'),(2072,'1','308',1,'Retail Sale Id 2173',0.00,1915.20,740.00,2249.60,334.40,'2023-02-08 09:47:06'),(2073,'1','308',1,'Retail Sale Id 2174',0.00,2551.50,740.00,2997.00,445.50,'2023-02-08 09:51:42'),(2074,'1','308',1,'Retail Sale Id 2175',0.00,1890.00,740.00,2220.00,330.00,'2023-02-08 10:01:20'),(2075,'1','308',1,'Retail Sale Id 2176',0.00,1890.00,740.00,2220.00,330.00,'2023-02-08 10:10:12'),(2076,'1','308',1,'Retail Sale Id 2177',0.00,7560.00,740.00,8880.00,1320.00,'2023-02-08 11:54:35'),(2077,'1','308',1,'Retail Sale Id 2179',0.00,1896.30,740.00,2227.40,331.10,'2023-02-08 11:57:37'),(2078,'1','308',1,'Retail Sale Id 2180',0.00,636.30,740.00,747.40,111.10,'2023-02-08 12:10:14'),(2079,'1','308',1,'Retail Sale Id 2181',0.00,5040.00,740.00,5920.00,880.00,'2023-02-08 13:01:36'),(2080,'1','308',1,'Retail Sale Id 2183',0.00,3150.00,740.00,3700.00,550.00,'2023-02-08 13:21:05'),(2081,'1','308',1,'Retail Sale Id 2186',0.00,5040.00,740.00,5920.00,880.00,'2023-02-08 13:37:04'),(2082,'1','308',1,'Retail Sale Id 2187',0.00,4410.00,740.00,5180.00,770.00,'2023-02-08 13:39:21'),(2083,'1','308',1,'Retail Sale Id 2188',0.00,1890.00,740.00,2220.00,330.00,'2023-02-08 14:00:21'),(2084,'1','308',1,'Retail Sale Id 2189',0.00,1701.00,740.00,1998.00,297.00,'2023-02-08 14:36:06'),(2085,'1','308',1,'Retail Sale Id 2190',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-08 14:42:16'),(2086,'1','308',1,'Retail Sale Id 2191',0.00,1278.90,740.00,1502.20,223.30,'2023-02-08 14:57:16'),(2087,'1','308',1,'Retail Sale Id 2192',0.00,636.30,740.00,747.40,111.10,'2023-02-08 15:12:19'),(2088,'1','308',1,'Retail Sale Id 2193',0.00,1890.00,740.00,2220.00,330.00,'2023-02-08 15:33:16'),(2089,'1','308',1,'Retail Sale Id 2194',0.00,1890.00,740.00,2220.00,330.00,'2023-02-08 15:38:58'),(2090,'1','308',1,'Retail Sale Id 2196',0.00,1278.90,740.00,1502.20,223.30,'2023-02-08 15:50:18'),(2091,'1','308',1,'Retail Sale Id 2197',0.00,1896.30,740.00,2227.40,331.10,'2023-02-08 16:16:27'),(2092,'1','308',1,'Retail Sale Id 2198',0.00,1278.90,740.00,1502.20,223.30,'2023-02-08 17:04:09'),(2093,'1','308',1,'Retail Sale Id 2199',0.00,630.00,740.00,740.00,110.00,'2023-02-08 17:12:16'),(2094,'1','308',1,'Retail Sale Id 2200',0.00,2551.50,740.00,2997.00,445.50,'2023-02-08 17:16:58'),(2095,'1','308',1,'Retail Sale Id 2201',0.00,3780.00,740.00,4440.00,660.00,'2023-02-08 17:24:00'),(2096,'1','308',1,'Retail Sale Id 2202',0.00,3780.00,740.00,4440.00,660.00,'2023-02-08 17:24:43'),(2097,'1','308',1,'Retail Sale Id 2203',0.00,630.00,740.00,740.00,110.00,'2023-02-08 17:25:34'),(2098,'1','308',1,'Return of Retail Sale Id 2190',7875.00,0.00,740.00,-9250.00,-1375.00,'2023-02-08 18:13:23'),(2099,'1','308',1,'Return of Retail Sale Id 2170',3786.30,0.00,740.00,-4447.40,-661.10,'2023-02-08 18:14:33'),(2100,'1','308',1,'Retail Sale Id 2204',0.00,283.50,740.00,333.00,49.50,'2023-02-08 18:15:23'),(2101,'1','308',1,'Retail Sale Id 2205',0.00,1278.90,740.00,1502.20,223.30,'2023-02-09 08:13:02'),(2102,'1','308',1,'Retail Sale Id 2209',0.00,1278.90,740.00,1502.20,223.30,'2023-02-09 08:26:07'),(2103,'1','308',1,'Retail Sale Id 2211',0.00,4428.90,740.00,5202.20,773.30,'2023-02-09 11:33:24'),(2104,'1','308',1,'Retail Sale Id 2212',0.00,29925.00,740.00,35150.00,5225.00,'2023-02-09 11:35:47'),(2105,'1','308',1,'Retail Sale Id 2213',0.00,5701.50,740.00,6697.00,995.50,'2023-02-09 11:50:27'),(2106,'1','308',1,'Retail Sale Id 2214',0.00,1890.00,740.00,2220.00,330.00,'2023-02-09 18:14:29'),(2107,'1','308',1,'Retail Sale Id 2215',0.00,1020.60,740.00,1198.80,178.20,'2023-02-09 18:18:46'),(2108,'1','308',1,'Retail Sale Id 2216',0.00,636.30,740.00,747.40,111.10,'2023-02-09 18:19:40'),(2109,'1','308',1,'Retail Sale Id 2217',0.00,2520.00,740.00,2960.00,440.00,'2023-02-09 18:32:04'),(2110,'1','308',1,'Retail Sale Id 2218',0.00,850.50,740.00,999.00,148.50,'2023-02-09 18:33:40'),(2111,'1','308',1,'Retail Sale Id 2219',0.00,4410.00,740.00,5180.00,770.00,'2023-02-09 18:51:06'),(2112,'1','308',1,'Retail Sale Id 2220',0.00,1915.20,740.00,2249.60,334.40,'2023-02-09 18:56:05'),(2113,'1','308',1,'Retail Sale Id 2221',0.00,3786.30,740.00,4447.40,661.10,'2023-02-09 19:09:45'),(2114,'1','308',1,'Retail Sale Id 2222',0.00,3150.00,740.00,3700.00,550.00,'2023-02-10 08:41:03'),(2115,'1','308',1,'Retail Sale Id 2224',0.00,3150.00,740.00,3700.00,550.00,'2023-02-10 09:15:32'),(2116,'1','308',1,'Retail Sale Id 2226',0.00,1890.00,740.00,2220.00,330.00,'2023-02-10 09:19:31'),(2117,'1','308',1,'Retail Sale Id 2227',0.00,1278.90,740.00,1502.20,223.30,'2023-02-10 09:21:02'),(2118,'1','308',1,'Retail Sale Id 2228',0.00,1890.00,740.00,2220.00,330.00,'2023-02-10 09:23:59'),(2119,'1','308',1,'Retail Sale Id 2229',0.00,2520.00,740.00,2960.00,440.00,'2023-02-10 09:25:30'),(2120,'1','308',1,'Retail Sale Id 2230',0.00,3780.00,740.00,4440.00,660.00,'2023-02-10 09:29:39'),(2121,'1','308',1,'Retail Sale Id 2232',0.00,1890.00,740.00,2220.00,330.00,'2023-02-10 10:24:28'),(2122,'1','308',1,'Retail Sale Id 2233',0.00,1278.90,740.00,1502.20,223.30,'2023-02-10 10:32:51'),(2123,'1','308',1,'Retail Sale Id 2234',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-10 11:02:22'),(2124,'1','308',1,'Retail Sale Id 2235',0.00,2551.50,740.00,2997.00,445.50,'2023-02-10 11:51:12'),(2125,'1','308',1,'Retail Sale Id 2236',0.00,3150.00,740.00,3700.00,550.00,'2023-02-10 12:43:33'),(2126,'1','308',1,'Retail Sale Id 2237',0.00,1278.90,740.00,1502.20,223.30,'2023-02-10 13:11:30'),(2127,'1','308',1,'Retail Sale Id 2238',0.00,3780.00,740.00,4440.00,660.00,'2023-02-10 13:15:05'),(2128,'1','308',1,'Retail Sale Id 2239',0.00,2129.40,740.00,2501.20,371.80,'2023-02-10 13:20:14'),(2129,'1','308',1,'Retail Sale Id 2240',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-10 13:23:39'),(2130,'1','308',1,'Retail Sale Id 2241',0.00,18900.00,680.00,20400.00,1500.00,'2023-02-10 13:58:00'),(2131,'1','308',1,'Retail Sale Id 2242',0.00,1278.90,740.00,1502.20,223.30,'2023-02-10 14:07:37'),(2132,'1','308',1,'Retail Sale Id 2243',0.00,7560.00,740.00,8880.00,1320.00,'2023-02-10 14:23:17'),(2133,'1','308',1,'Retail Sale Id 2245',0.00,636.30,740.00,747.40,111.10,'2023-02-10 14:50:32'),(2134,'1','308',1,'Retail Sale Id 2246',0.00,3150.00,740.00,3700.00,550.00,'2023-02-10 14:52:45'),(2135,'1','308',1,'Retail Sale Id 2249',0.00,636.30,740.00,747.40,111.10,'2023-02-10 15:17:20'),(2136,'1','308',1,'Retail Sale Id 2250',0.00,1278.90,740.00,1502.20,223.30,'2023-02-10 15:24:14'),(2137,'1','308',1,'Retail Sale Id 2251',0.00,5040.00,740.00,5920.00,880.00,'2023-02-10 15:35:22'),(2138,'1','308',1,'Retail Sale Id 2252',0.00,2520.00,740.00,2960.00,440.00,'2023-02-10 15:38:00'),(2139,'1','308',1,'Retail Sale Id 2253',0.00,2551.50,740.00,2997.00,445.50,'2023-02-10 15:40:19'),(2140,'1','308',1,'Retail Sale Id 2254',0.00,2551.50,740.00,2997.00,445.50,'2023-02-10 16:23:18'),(2141,'1','308',1,'Retail Sale Id 2255',0.00,1890.00,740.00,2220.00,330.00,'2023-02-10 16:30:16'),(2142,'1','308',1,'Retail Sale Id 2256',0.00,1278.90,740.00,1502.20,223.30,'2023-02-10 16:33:16'),(2143,'1','308',1,'Retail Sale Id 2257',0.00,1278.90,740.00,1502.20,223.30,'2023-02-10 16:35:16'),(2144,'1','308',1,'Retail Sale Id 2258',0.00,636.30,740.00,747.40,111.10,'2023-02-10 16:54:17'),(2145,'1','308',1,'Retail Sale Id 2259',0.00,1890.00,740.00,2220.00,330.00,'2023-02-10 17:33:23'),(2146,'1','308',1,'Retail Sale Id 2260',0.00,1278.90,740.00,1502.20,223.30,'2023-02-10 17:48:18'),(2147,'1','308',1,'Retail Sale Id 2261',0.00,1890.00,740.00,2220.00,330.00,'2023-02-10 17:54:44'),(2148,'1','308',1,'Retail Sale Id 2262',0.00,2551.50,740.00,2997.00,445.50,'2023-02-10 18:05:39'),(2149,'1','308',1,'Retail Sale Id 2263',0.00,1278.90,740.00,1502.20,223.30,'2023-02-10 18:09:34'),(2150,'1','308',1,'Retail Sale Id 2264',0.00,630.00,740.00,740.00,110.00,'2023-02-10 18:19:17'),(2151,'1','308',1,'Retail Sale Id 2265',0.00,3805.20,740.00,4469.60,664.40,'2023-02-10 19:37:58'),(2152,'1','308',1,'Retail Sale Id 2266',0.00,3780.00,740.00,4440.00,660.00,'2023-02-11 07:53:32'),(2153,'1','308',1,'Retail Sale Id 2267',0.00,3780.00,740.00,4440.00,660.00,'2023-02-11 07:54:42'),(2154,'1','308',1,'Retail Sale Id 2268',0.00,630.00,740.00,740.00,110.00,'2023-02-11 07:57:09'),(2155,'1','308',1,'Retail Sale Id 2270',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-11 07:58:50'),(2156,'1','308',1,'Retail Sale Id 2271',0.00,1278.90,740.00,1502.20,223.30,'2023-02-11 07:59:56'),(2157,'1','308',1,'Retail Sale Id 2272',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-11 08:02:47'),(2158,'1','308',1,'Retail Sale Id 2273',0.00,3780.00,740.00,4440.00,660.00,'2023-02-11 08:04:58'),(2159,'1','308',1,'Retail Sale Id 2276',0.00,3150.00,740.00,3700.00,550.00,'2023-02-11 08:07:22'),(2160,'1','308',1,'Retail Sale Id 2277',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-11 08:09:57'),(2161,'1','308',1,'Retail Sale Id 2279',0.00,4410.00,740.00,5180.00,770.00,'2023-02-11 08:14:37'),(2162,'1','308',1,'Retail Sale Id 2280',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-11 08:30:22'),(2163,'1','308',1,'Retail Sale Id 2281',0.00,1278.90,740.00,1502.20,223.30,'2023-02-11 08:41:28'),(2164,'1','308',1,'Retail Sale Id 2282',0.00,3150.00,740.00,3700.00,550.00,'2023-02-11 08:44:10'),(2165,'1','308',1,'Retail Sale Id 2283',0.00,3780.00,740.00,4440.00,660.00,'2023-02-11 08:58:50'),(2166,'1','308',1,'Retail Sale Id 2285',0.00,1890.00,740.00,2220.00,330.00,'2023-02-11 09:01:51'),(2167,'1','308',1,'Retail Sale Id 2286',0.00,1915.20,740.00,2249.60,334.40,'2023-02-11 09:04:07'),(2168,'1','308',1,'Retail Sale Id 2287',0.00,3780.00,740.00,4440.00,660.00,'2023-02-11 09:18:06'),(2169,'1','308',1,'Retail Sale Id 2288',0.00,1890.00,740.00,2220.00,330.00,'2023-02-11 09:27:14'),(2170,'1','308',1,'Retail Sale Id 2289',0.00,1278.90,740.00,1502.20,223.30,'2023-02-11 09:29:16'),(2171,'1','308',1,'Retail Sale Id 2290',0.00,636.30,740.00,747.40,111.10,'2023-02-11 09:31:50'),(2172,'1','308',1,'Retail Sale Id 2291',0.00,1278.90,740.00,1502.20,223.30,'2023-02-11 09:33:33'),(2173,'1','308',1,'Retail Sale Id 2293',0.00,2551.50,740.00,2997.00,445.50,'2023-02-11 09:35:44'),(2174,'1','308',1,'Retail Sale Id 2294',0.00,3786.30,740.00,4447.40,661.10,'2023-02-11 09:37:41'),(2175,'1','308',1,'Retail Sale Id 2295',0.00,3780.00,740.00,4440.00,660.00,'2023-02-11 09:39:10'),(2176,'1','308',1,'Retail Sale Id 2296',0.00,3780.00,740.00,4440.00,660.00,'2023-02-11 09:46:57'),(2177,'1','308',1,'Retail Sale Id 2298',0.00,3780.00,740.00,4440.00,660.00,'2023-02-11 10:16:30'),(2178,'1','308',1,'Retail Sale Id 2299',0.00,5109.30,740.00,6001.40,892.10,'2023-02-11 10:19:03'),(2179,'1','308',1,'Retail Sale Id 2300',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-11 10:34:30'),(2180,'1','308',1,'Retail Sale Id 2302',0.00,1278.90,740.00,1502.20,223.30,'2023-02-11 10:38:09'),(2181,'1','308',1,'Return of Retail Sale Id 2299',5109.30,0.00,740.00,-6001.40,-892.10,'2023-02-11 10:45:15'),(2182,'1','308',1,'Retail Sale Id 2304',0.00,1915.20,740.00,2249.60,334.40,'2023-02-11 10:53:26'),(2183,'1','308',1,'Retail Sale Id 2305',0.00,3150.00,740.00,3700.00,550.00,'2023-02-11 11:14:28'),(2184,'1','308',1,'Retail Sale Id 2307',0.00,1278.90,740.00,1502.20,223.30,'2023-02-11 11:25:14'),(2185,'1','308',1,'Retail Sale Id 2308',0.00,1278.90,740.00,1502.20,223.30,'2023-02-11 11:26:36'),(2186,'1','308',1,'Retail Sale Id 2309',0.00,636.30,740.00,747.40,111.10,'2023-02-11 11:27:53'),(2187,'1','308',1,'Retail Sale Id 2310',0.00,2520.00,740.00,2960.00,440.00,'2023-02-11 11:30:20'),(2188,'1','308',1,'Retail Sale Id 2312',0.00,4410.00,740.00,5180.00,770.00,'2023-02-11 11:37:28'),(2189,'1','308',1,'Retail Sale Id 2313',0.00,3150.00,740.00,3700.00,550.00,'2023-02-11 11:39:04'),(2190,'1','308',1,'Retail Sale Id 2314',0.00,2520.00,740.00,2960.00,440.00,'2023-02-11 11:41:17'),(2191,'1','308',1,'Retail Sale Id 2317',0.00,1278.90,740.00,1502.20,223.30,'2023-02-11 11:44:46'),(2192,'1','308',1,'Retail Sale Id 2318',0.00,22050.00,680.00,23800.00,1750.00,'2023-02-11 11:49:35'),(2193,'1','308',1,'Retail Sale Id 2319',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-11 11:54:14'),(2194,'1','308',1,'Retail Sale Id 2320',0.00,3780.00,740.00,4440.00,660.00,'2023-02-11 12:03:42'),(2195,'1','308',1,'Retail Sale Id 2321',0.00,73080.00,680.00,78880.00,5800.00,'2023-02-11 12:07:28'),(2196,'1','308',1,'Retail Sale Id 2323',0.00,1278.90,740.00,1502.20,223.30,'2023-02-11 12:11:19'),(2197,'1','308',1,'Retail Sale Id 2324',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-11 12:13:11'),(2198,'1','308',1,'Retail Sale Id 2325',0.00,1890.00,740.00,2220.00,330.00,'2023-02-11 12:15:18'),(2199,'1','308',1,'Retail Sale Id 2326',0.00,2551.50,740.00,2997.00,445.50,'2023-02-11 12:37:07'),(2200,'1','308',1,'Retail Sale Id 2327',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-11 12:41:59'),(2201,'1','308',1,'Return of Retail Sale Id 2272',63000.00,0.00,680.00,-68000.00,-5000.00,'2023-02-11 12:47:47'),(2202,'1','308',1,'Retail Sale Id 2328',0.00,3780.00,740.00,4440.00,660.00,'2023-02-11 12:58:11'),(2203,'1','308',1,'Retail Sale Id 2329',0.00,3150.00,740.00,3700.00,550.00,'2023-02-11 12:59:32'),(2204,'1','308',1,'Retail Sale Id 2330',0.00,3786.30,740.00,4447.40,661.10,'2023-02-11 13:08:16'),(2205,'1','308',1,'Retail Sale Id 2331',0.00,3786.30,740.00,4447.40,661.10,'2023-02-11 13:14:52'),(2206,'1','308',1,'Retail Sale Id 2332',0.00,1890.00,740.00,2220.00,330.00,'2023-02-11 13:18:48'),(2207,'1','308',1,'Retail Sale Id 2333',0.00,2520.00,740.00,2960.00,440.00,'2023-02-11 13:37:15'),(2208,'1','308',1,'Retail Sale Id 2335',0.00,1278.90,740.00,1502.20,223.30,'2023-02-11 13:45:53'),(2209,'1','308',1,'Retail Sale Id 2336',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-11 13:52:33'),(2210,'1','308',1,'Retail Sale Id 2337',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-11 13:56:22'),(2211,'1','308',1,'Retail Sale Id 2338',0.00,1278.90,740.00,1502.20,223.30,'2023-02-11 14:11:50'),(2212,'1','308',1,'Retail Sale Id 2339',0.00,3780.00,740.00,4440.00,660.00,'2023-02-11 14:14:12'),(2213,'1','308',1,'Retail Sale Id 2340',0.00,3780.00,740.00,4440.00,660.00,'2023-02-11 14:15:59'),(2214,'1','308',1,'Retail Sale Id 2341',0.00,4523.40,740.00,5313.20,789.80,'2023-02-11 17:38:51'),(2215,'1','308',1,'Retail Sale Id 2342',0.00,1278.90,740.00,1502.20,223.30,'2023-02-12 07:43:09'),(2216,'1','308',1,'Retail Sale Id 2343',0.00,2520.00,740.00,2960.00,440.00,'2023-02-12 07:44:09'),(2217,'1','308',1,'Retail Sale Id 2344',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-12 07:46:57'),(2218,'1','308',1,'Retail Sale Id 2345',0.00,1278.90,740.00,1502.20,223.30,'2023-02-12 07:50:05'),(2219,'1','308',1,'Retail Sale Id 2346',0.00,2520.00,740.00,2960.00,440.00,'2023-02-12 07:52:36'),(2220,'1','308',1,'Retail Sale Id 2347',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-12 07:54:00'),(2221,'1','308',1,'Retail Sale Id 2348',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-12 07:57:44'),(2222,'1','308',1,'Retail Sale Id 2349',0.00,1278.90,740.00,1502.20,223.30,'2023-02-12 07:59:46'),(2223,'1','308',1,'Retail Sale Id 2350',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-12 08:06:45'),(2224,'1','308',1,'Retail Sale Id 2351',0.00,850.50,740.00,999.00,148.50,'2023-02-12 08:08:06'),(2225,'1','308',1,'Retail Sale Id 2352',0.00,1278.90,740.00,1502.20,223.30,'2023-02-12 08:09:26'),(2226,'1','308',1,'Retail Sale Id 2353',0.00,2520.00,740.00,2960.00,440.00,'2023-02-12 08:11:31'),(2227,'1','308',1,'Retail Sale Id 2354',0.00,1890.00,740.00,2220.00,330.00,'2023-02-12 08:16:19'),(2228,'1','308',1,'Retail Sale Id 2356',0.00,3150.00,740.00,3700.00,550.00,'2023-02-12 08:18:03'),(2229,'1','308',1,'Retail Sale Id 2357',0.00,2129.40,740.00,2501.20,371.80,'2023-02-12 08:19:29'),(2230,'1','308',1,'Retail Sale Id 2360',0.00,1890.00,740.00,2220.00,330.00,'2023-02-12 08:26:56'),(2231,'1','308',1,'Retail Sale Id 2361',0.00,3150.00,740.00,3700.00,550.00,'2023-02-12 08:28:24'),(2232,'1','308',1,'Retail Sale Id 2362',0.00,3780.00,740.00,4440.00,660.00,'2023-02-12 08:33:44'),(2233,'1','308',1,'Retail Sale Id 2363',0.00,1278.90,740.00,1502.20,223.30,'2023-02-12 08:35:04'),(2234,'1','308',1,'Retail Sale Id 2364',0.00,1890.00,740.00,2220.00,330.00,'2023-02-12 08:36:50'),(2235,'1','308',1,'Retail Sale Id 2365',0.00,630.00,740.00,740.00,110.00,'2023-02-12 08:38:11'),(2236,'1','308',1,'Retail Sale Id 2366',0.00,2551.50,740.00,2997.00,445.50,'2023-02-12 08:39:34'),(2237,'1','308',1,'Retail Sale Id 2367',0.00,3780.00,740.00,4440.00,660.00,'2023-02-12 08:42:39'),(2238,'1','308',1,'Retail Sale Id 2368',0.00,630.00,740.00,740.00,110.00,'2023-02-12 08:45:58'),(2239,'1','308',1,'Retail Sale Id 2369',0.00,1260.00,740.00,1480.00,220.00,'2023-02-12 08:47:15'),(2240,'1','308',1,'Retail Sale Id 2371',0.00,1278.90,740.00,1502.20,223.30,'2023-02-12 08:52:15'),(2241,'1','308',1,'Retail Sale Id 2372',0.00,636.30,740.00,747.40,111.10,'2023-02-12 08:53:29'),(2242,'1','308',1,'Retail Sale Id 2373',0.00,1871.10,740.00,2197.80,326.70,'2023-02-12 08:56:24'),(2243,'1','308',1,'Retail Sale Id 2374',0.00,1278.90,740.00,1502.20,223.30,'2023-02-12 08:58:42'),(2244,'1','308',1,'Retail Sale Id 2375',0.00,1890.00,740.00,2220.00,330.00,'2023-02-12 09:01:29'),(2245,'1','308',1,'Retail Sale Id 2377',0.00,1896.30,740.00,2227.40,331.10,'2023-02-12 09:14:54'),(2246,'1','308',1,'Retail Sale Id 2379',0.00,636.30,740.00,747.40,111.10,'2023-02-12 09:21:47'),(2247,'1','308',1,'Retail Sale Id 2381',0.00,3150.00,740.00,3700.00,550.00,'2023-02-12 09:29:44'),(2248,'1','308',1,'Retail Sale Id 2387',0.00,2551.50,740.00,2997.00,445.50,'2023-02-12 09:42:24'),(2249,'1','308',1,'Return of Retail Sale Id 2387',2551.50,0.00,740.00,-2997.00,-445.50,'2023-02-12 09:43:51'),(2250,'1','308',1,'Retail Sale Id 2389',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-12 09:52:27'),(2251,'1','308',1,'Retail Sale Id 2390',0.00,2041.20,740.00,2397.60,356.40,'2023-02-12 09:56:03'),(2252,'1','308',1,'Retail Sale Id 2392',0.00,1890.00,740.00,2220.00,330.00,'2023-02-12 10:09:35'),(2253,'1','308',1,'Retail Sale Id 2393',0.00,1278.90,740.00,1502.20,223.30,'2023-02-12 10:12:45'),(2254,'1','308',1,'Return of Retail Sale Id 2366',2551.50,0.00,740.00,-2997.00,-445.50,'2023-02-12 10:17:22'),(2255,'1','308',1,'Retail Sale Id 2396',0.00,3780.00,740.00,4440.00,660.00,'2023-02-12 10:24:28'),(2256,'1','308',1,'Return of Retail Sale Id 2375',1890.00,0.00,740.00,-2220.00,-330.00,'2023-02-12 10:26:48'),(2257,'1','308',1,'Retail Sale Id 2398',0.00,2520.00,740.00,2960.00,440.00,'2023-02-12 10:30:20'),(2258,'1','308',1,'Retail Sale Id 2399',0.00,1890.00,740.00,2220.00,330.00,'2023-02-12 10:32:04'),(2259,'1','308',1,'Retail Sale Id 2403',0.00,2520.00,740.00,2960.00,440.00,'2023-02-12 10:39:08'),(2260,'1','308',1,'Retail Sale Id 2405',0.00,11655.00,740.00,13690.00,2035.00,'2023-02-12 10:45:16'),(2261,'1','308',1,'Return of Retail Sale Id 2403',2520.00,0.00,740.00,-2960.00,-440.00,'2023-02-12 10:47:22'),(2262,'1','308',1,'Retail Sale Id 2407',0.00,1701.00,740.00,1998.00,297.00,'2023-02-12 10:53:30'),(2263,'1','308',1,'Retail Sale Id 2408',0.00,3786.30,740.00,4447.40,661.10,'2023-02-12 11:06:11'),(2264,'1','308',1,'Retail Sale Id 2409',0.00,1915.20,740.00,2249.60,334.40,'2023-02-12 11:12:56'),(2265,'1','308',1,'Retail Sale Id 2410',0.00,1278.90,740.00,1502.20,223.30,'2023-02-12 11:17:18'),(2266,'1','308',1,'Retail Sale Id 2411',0.00,630.00,740.00,740.00,110.00,'2023-02-12 11:33:47'),(2267,'1','308',1,'Retail Sale Id 2412',0.00,636.30,740.00,747.40,111.10,'2023-02-12 11:36:08'),(2268,'1','308',1,'Retail Sale Id 2414',0.00,1278.90,740.00,1502.20,223.30,'2023-02-12 11:37:43'),(2269,'1','308',1,'Retail Sale Id 2415',0.00,10710.00,740.00,12580.00,1870.00,'2023-02-12 12:07:28'),(2270,'1','308',1,'Retail Sale Id 2416',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-12 12:12:49'),(2271,'1','308',1,'Retail Sale Id 2417',0.00,1701.00,740.00,1998.00,297.00,'2023-02-12 12:22:00'),(2272,'1','308',1,'Retail Sale Id 2418',0.00,3150.00,740.00,3700.00,550.00,'2023-02-12 12:23:58'),(2273,'1','308',1,'Retail Sale Id 2419',0.00,3150.00,740.00,3700.00,550.00,'2023-02-12 12:49:03'),(2274,'1','308',1,'Retail Sale Id 2420',0.00,1890.00,740.00,2220.00,330.00,'2023-02-12 12:54:52'),(2275,'1','308',1,'Return of Retail Sale Id 2420',1890.00,0.00,740.00,-2220.00,-330.00,'2023-02-12 13:07:19'),(2276,'1','308',1,'Return of Retail Sale Id 2419',3150.00,0.00,740.00,-3700.00,-550.00,'2023-02-12 13:07:57'),(2277,'1','308',1,'Retail Sale Id 2422',0.00,737.10,740.00,865.80,128.70,'2023-02-12 15:44:59'),(2278,'1','308',1,'Retail Sale Id 2423',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-15 17:50:24'),(2279,'1','308',1,'Retail Sale Id 2424',0.00,1278.90,740.00,1502.20,223.30,'2023-02-15 17:51:57'),(2280,'1','308',1,'Retail Sale Id 2425',0.00,1278.90,740.00,1502.20,223.30,'2023-02-15 17:56:45'),(2281,'1','308',1,'Retail Sale Id 2426',0.00,630.00,740.00,740.00,110.00,'2023-02-15 18:14:00'),(2282,'1','308',1,'Retail Sale Id 2427',0.00,3780.00,740.00,4440.00,660.00,'2023-02-15 18:18:05'),(2283,'1','308',1,'Retail Sale Id 2428',0.00,6300.00,680.00,6800.00,500.00,'2023-02-15 18:20:23'),(2284,'1','308',1,'Retail Sale Id 2429',0.00,3780.00,740.00,4440.00,660.00,'2023-02-15 18:22:46'),(2285,'1','308',1,'Retail Sale Id 2430',0.00,1278.90,740.00,1502.20,223.30,'2023-02-15 18:24:07'),(2286,'1','308',1,'Retail Sale Id 2431',0.00,680.40,740.00,799.20,118.80,'2023-02-15 18:25:42'),(2287,'1','308',1,'Retail Sale Id 2432',0.00,4410.00,740.00,5180.00,770.00,'2023-02-15 18:27:41'),(2288,'1','308',1,'Retail Sale Id 2433',0.00,1278.90,740.00,1502.20,223.30,'2023-02-15 18:28:34'),(2289,'1','308',1,'Retail Sale Id 2434',0.00,2520.00,740.00,2960.00,440.00,'2023-02-15 18:35:06'),(2290,'1','308',1,'Retail Sale Id 2435',0.00,3150.00,740.00,3700.00,550.00,'2023-02-15 18:42:43'),(2291,'1','308',1,'Retail Sale Id 2436',0.00,1890.00,740.00,2220.00,330.00,'2023-02-15 18:44:56'),(2292,'1','308',1,'Retail Sale Id 2437',0.00,1890.00,740.00,2220.00,330.00,'2023-02-15 18:56:42'),(2293,'1','308',1,'Retail Sale Id 2438',0.00,3780.00,740.00,4440.00,660.00,'2023-02-15 18:59:13'),(2294,'1','308',1,'Retail Sale Id 2439',0.00,1285.20,740.00,1509.60,224.40,'2023-02-15 19:09:58'),(2295,'1','308',1,'Retail Sale Id 2440',0.00,1278.90,740.00,1502.20,223.30,'2023-02-16 07:14:34'),(2296,'1','308',1,'Retail Sale Id 2441',0.00,4410.00,740.00,5180.00,770.00,'2023-02-16 07:21:48'),(2297,'1','308',1,'Retail Sale Id 2442',0.00,1260.00,740.00,1480.00,220.00,'2023-02-16 07:32:01'),(2298,'1','308',1,'Retail Sale Id 2443',0.00,1278.90,740.00,1502.20,223.30,'2023-02-16 07:49:57'),(2299,'1','308',1,'Retail Sale Id 2445',0.00,636.30,740.00,747.40,111.10,'2023-02-16 08:10:36'),(2300,'1','308',1,'Retail Sale Id 2446',0.00,2551.50,740.00,2997.00,445.50,'2023-02-16 08:27:48'),(2301,'1','308',1,'Retail Sale Id 2447',0.00,3780.00,740.00,4440.00,660.00,'2023-02-16 08:41:25'),(2302,'1','308',1,'Retail Sale Id 2448',0.00,1890.00,740.00,2220.00,330.00,'2023-02-16 08:44:13'),(2303,'1','308',1,'Retail Sale Id 2449',0.00,636.30,740.00,747.40,111.10,'2023-02-16 08:50:27'),(2304,'1','308',1,'Return of Retail Sale Id 2448',1890.00,0.00,740.00,-2220.00,-330.00,'2023-02-16 08:55:17'),(2305,'1','308',1,'Retail Sale Id 2451',0.00,1260.00,740.00,1480.00,220.00,'2023-02-16 09:14:27'),(2306,'1','308',1,'Retail Sale Id 2452',0.00,636.30,740.00,747.40,111.10,'2023-02-16 09:17:30'),(2307,'1','308',1,'Retail Sale Id 2453',0.00,1260.00,740.00,1480.00,220.00,'2023-02-16 09:23:42'),(2308,'1','308',1,'Retail Sale Id 2454',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-16 09:44:01'),(2309,'1','308',1,'Retail Sale Id 2455',0.00,1890.00,740.00,2220.00,330.00,'2023-02-16 10:07:31'),(2310,'1','308',1,'Retail Sale Id 2456',0.00,680.40,740.00,799.20,118.80,'2023-02-16 10:08:37'),(2311,'1','308',1,'Retail Sale Id 2457',0.00,3780.00,740.00,4440.00,660.00,'2023-02-16 10:20:17'),(2312,'1','308',1,'Retail Sale Id 2458',0.00,28350.00,680.00,30600.00,2250.00,'2023-02-16 10:44:46'),(2313,'1','308',1,'Retail Sale Id 2459',0.00,3780.00,740.00,4440.00,660.00,'2023-02-16 10:54:50'),(2314,'1','308',1,'Retail Sale Id 2460',0.00,1890.00,740.00,2220.00,330.00,'2023-02-16 10:56:45'),(2315,'1','308',1,'Retail Sale Id 2461',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-16 11:01:01'),(2316,'1','308',1,'Retail Sale Id 2462',0.00,630.00,740.00,740.00,110.00,'2023-02-16 11:02:49'),(2317,'1','308',1,'Retail Sale Id 2463',0.00,3780.00,740.00,4440.00,660.00,'2023-02-16 11:24:05'),(2318,'1','308',1,'Retail Sale Id 2464',0.00,630.00,740.00,740.00,110.00,'2023-02-16 11:38:17'),(2319,'1','308',1,'Retail Sale Id 2465',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-16 11:57:46'),(2320,'1','308',1,'Retail Sale Id 2466',0.00,1890.00,740.00,2220.00,330.00,'2023-02-16 12:01:19'),(2321,'1','308',1,'Retail Sale Id 2467',0.00,3150.00,740.00,3700.00,550.00,'2023-02-16 12:28:35'),(2322,'1','308',1,'Retail Sale Id 2468',0.00,1890.00,740.00,2220.00,330.00,'2023-02-16 14:05:12'),(2323,'1','308',1,'Retail Sale Id 2469',0.00,3150.00,740.00,3700.00,550.00,'2023-02-16 15:19:18'),(2324,'1','308',1,'Retail Sale Id 2470',0.00,3780.00,740.00,4440.00,660.00,'2023-02-16 15:36:47'),(2325,'1','308',1,'Retail Sale Id 2471',0.00,1278.90,740.00,1502.20,223.30,'2023-02-16 16:36:31'),(2326,'1','308',1,'Retail Sale Id 2473',0.00,1260.00,740.00,1480.00,220.00,'2023-02-16 17:01:06'),(2327,'1','308',1,'Retail Sale Id 2474',0.00,630.00,740.00,740.00,110.00,'2023-02-16 17:05:40'),(2328,'1','308',1,'Retail Sale Id 2475',0.00,2520.00,740.00,2960.00,440.00,'2023-02-16 17:07:35'),(2329,'1','308',1,'Retail Sale Id 2476',0.00,2520.00,740.00,2960.00,440.00,'2023-02-16 17:08:48'),(2330,'1','308',1,'Retail Sale Id 2477',0.00,1890.00,740.00,2220.00,330.00,'2023-02-16 17:22:23'),(2331,'1','308',1,'Retail Sale Id 2478',0.00,1890.00,740.00,2220.00,330.00,'2023-02-16 17:27:23'),(2332,'1','308',1,'Retail Sale Id 2479',0.00,636.30,740.00,747.40,111.10,'2023-02-16 17:36:10'),(2333,'1','308',1,'Retail Sale Id 2480',0.00,1260.00,740.00,1480.00,220.00,'2023-02-16 17:41:17'),(2334,'1','308',1,'Retail Sale Id 2481',0.00,1890.00,740.00,2220.00,330.00,'2023-02-16 17:45:48'),(2335,'1','308',1,'Retail Sale Id 2482',0.00,3780.00,740.00,4440.00,660.00,'2023-02-16 17:47:37'),(2336,'1','308',1,'Retail Sale Id 2483',0.00,1890.00,740.00,2220.00,330.00,'2023-02-16 17:52:09'),(2337,'1','308',1,'Retail Sale Id 2484',0.00,1260.00,740.00,1480.00,220.00,'2023-02-16 17:57:47'),(2338,'1','308',1,'Retail Sale Id 2485',0.00,636.30,740.00,747.40,111.10,'2023-02-16 18:36:51'),(2339,'1','308',1,'Retail Sale Id 2486',0.00,1278.90,740.00,1502.20,223.30,'2023-02-16 18:39:23'),(2340,'1','308',1,'Retail Sale Id 2487',0.00,1278.90,740.00,1502.20,223.30,'2023-02-16 18:44:01'),(2341,'1','308',1,'Retail Sale Id 2488',0.00,1215.90,740.00,1428.20,212.30,'2023-02-16 21:07:47'),(2342,'1','308',1,'Retail Sale Id 2489',0.00,0.00,740.00,0.00,0.00,'2023-02-16 21:09:19'),(2343,'1','308',1,'Retail Sale Id 2490',0.00,1890.00,740.00,2220.00,330.00,'2023-02-17 07:37:07'),(2344,'1','308',1,'Retail Sale Id 2491',0.00,7560.00,740.00,8880.00,1320.00,'2023-02-17 07:39:03'),(2345,'1','308',1,'Retail Sale Id 2492',0.00,5040.00,740.00,5920.00,880.00,'2023-02-17 07:40:25'),(2346,'1','308',1,'Retail Sale Id 2493',0.00,1890.00,740.00,2220.00,330.00,'2023-02-17 07:41:57'),(2347,'1','308',1,'Retail Sale Id 2494',0.00,3150.00,740.00,3700.00,550.00,'2023-02-17 07:46:30'),(2348,'1','308',1,'Retail Sale Id 2495',0.00,636.30,740.00,747.40,111.10,'2023-02-17 07:47:32'),(2349,'1','308',1,'Retail Sale Id 2496',0.00,2520.00,740.00,2960.00,440.00,'2023-02-17 07:49:25'),(2350,'1','308',1,'Retail Sale Id 2497',0.00,1890.00,740.00,2220.00,330.00,'2023-02-17 07:50:44'),(2351,'1','308',1,'Retail Sale Id 2498',0.00,7560.00,740.00,8880.00,1320.00,'2023-02-17 07:52:46'),(2352,'1','308',1,'Retail Sale Id 2499',0.00,3786.30,740.00,4447.40,661.10,'2023-02-17 08:15:47'),(2353,'1','308',1,'Retail Sale Id 2500',0.00,3780.00,740.00,4440.00,660.00,'2023-02-17 08:18:32'),(2354,'1','308',1,'Retail Sale Id 2501',0.00,2520.00,740.00,2960.00,440.00,'2023-02-17 08:21:25'),(2355,'1','308',1,'Retail Sale Id 2502',0.00,3780.00,740.00,4440.00,660.00,'2023-02-17 08:26:57'),(2356,'1','308',1,'Retail Sale Id 2503',0.00,636.30,740.00,747.40,111.10,'2023-02-17 08:27:59'),(2357,'1','308',1,'Retail Sale Id 2504',0.00,3780.00,740.00,4440.00,660.00,'2023-02-17 08:32:46'),(2358,'1','308',1,'Retail Sale Id 2505',0.00,1890.00,740.00,2220.00,330.00,'2023-02-17 08:44:58'),(2359,'1','308',1,'Retail Sale Id 2506',0.00,3780.00,740.00,4440.00,660.00,'2023-02-17 08:48:23'),(2360,'1','308',1,'Retail Sale Id 2507',0.00,5040.00,740.00,5920.00,880.00,'2023-02-17 08:54:35'),(2361,'1','308',1,'Retail Sale Id 2508',0.00,1260.00,740.00,1480.00,220.00,'2023-02-17 09:07:20'),(2362,'1','308',1,'Retail Sale Id 2509',0.00,1915.20,740.00,2249.60,334.40,'2023-02-17 09:24:02'),(2363,'1','308',1,'Retail Sale Id 2510',0.00,4410.00,740.00,5180.00,770.00,'2023-02-17 09:41:29'),(2364,'1','308',1,'Retail Sale Id 2511',0.00,3780.00,740.00,4440.00,660.00,'2023-02-17 09:46:21'),(2365,'1','308',1,'Retail Sale Id 2512',0.00,2551.50,740.00,2997.00,445.50,'2023-02-17 10:01:54'),(2366,'1','308',1,'Retail Sale Id 2513',0.00,3780.00,740.00,4440.00,660.00,'2023-02-17 10:08:11'),(2367,'1','308',1,'Retail Sale Id 2514',0.00,3780.00,740.00,4440.00,660.00,'2023-02-17 10:19:09'),(2368,'1','308',1,'Retail Sale Id 2515',0.00,3150.00,740.00,3700.00,550.00,'2023-02-17 10:23:00'),(2369,'1','308',1,'Retail Sale Id 2517',0.00,1915.20,740.00,2249.60,334.40,'2023-02-17 11:32:29'),(2370,'1','308',1,'Retail Sale Id 2518',0.00,2520.00,740.00,2960.00,440.00,'2023-02-17 11:41:19'),(2371,'1','308',1,'Retail Sale Id 2519',0.00,10836.00,680.00,11696.00,860.00,'2023-02-17 11:44:47'),(2372,'1','308',1,'Retail Sale Id 2521',0.00,1915.20,740.00,2249.60,334.40,'2023-02-17 12:18:33'),(2373,'1','308',1,'Retail Sale Id 2522',0.00,636.30,740.00,747.40,111.10,'2023-02-17 12:49:21'),(2374,'1','308',1,'Retail Sale Id 2523',0.00,1260.00,740.00,1480.00,220.00,'2023-02-17 13:07:08'),(2375,'1','308',1,'Retail Sale Id 2524',0.00,1278.90,740.00,1502.20,223.30,'2023-02-17 13:17:27'),(2376,'1','308',1,'Retail Sale Id 2525',0.00,630.00,740.00,740.00,110.00,'2023-02-17 13:19:12'),(2377,'1','308',1,'Retail Sale Id 2526',0.00,636.30,740.00,747.40,111.10,'2023-02-17 15:12:09'),(2378,'1','308',1,'Retail Sale Id 2527',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-17 15:17:56'),(2379,'1','308',1,'Retail Sale Id 2528',0.00,7560.00,740.00,8880.00,1320.00,'2023-02-17 15:23:25'),(2380,'1','308',1,'Retail Sale Id 2529',0.00,3786.30,740.00,4447.40,661.10,'2023-02-17 16:18:07'),(2381,'1','308',1,'Retail Sale Id 2530',0.00,1278.90,740.00,1502.20,223.30,'2023-02-17 17:03:03'),(2382,'1','308',1,'Retail Sale Id 2531',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-17 17:10:10'),(2383,'1','308',1,'Retail Sale Id 2532',0.00,3150.00,740.00,3700.00,550.00,'2023-02-17 17:11:35'),(2384,'1','308',1,'Retail Sale Id 2533',0.00,1190.70,740.00,1398.60,207.90,'2023-02-17 17:12:56'),(2385,'1','308',1,'Retail Sale Id 2534',0.00,636.30,740.00,747.40,111.10,'2023-02-17 17:14:15'),(2386,'1','308',1,'Retail Sale Id 2535',0.00,1260.00,740.00,1480.00,220.00,'2023-02-17 17:15:56'),(2387,'1','308',1,'Retail Sale Id 2536',0.00,2129.40,740.00,2501.20,371.80,'2023-02-17 17:18:21'),(2388,'1','308',1,'Retail Sale Id 2537',0.00,1915.20,740.00,2249.60,334.40,'2023-02-17 17:32:26'),(2389,'1','308',1,'Retail Sale Id 2538',0.00,3830.40,740.00,4499.20,668.80,'2023-02-17 17:37:41'),(2390,'1','308',1,'Retail Sale Id 2539',0.00,636.30,740.00,747.40,111.10,'2023-02-17 17:39:50'),(2391,'1','308',1,'Retail Sale Id 2540',0.00,2520.00,740.00,2960.00,440.00,'2023-02-17 17:53:51'),(2392,'1','308',1,'Retail Sale Id 2541',0.00,2520.00,740.00,2960.00,440.00,'2023-02-17 17:55:57'),(2393,'1','308',1,'Retail Sale Id 2542',0.00,1278.90,740.00,1502.20,223.30,'2023-02-17 18:20:13'),(2394,'1','308',1,'Retail Sale Id 2543',0.00,1890.00,740.00,2220.00,330.00,'2023-02-17 18:33:38'),(2395,'1','308',1,'Return of Retail Sale Id 2541',2520.00,0.00,740.00,-2960.00,-440.00,'2023-02-17 18:40:28'),(2396,'1','308',1,'Retail Sale Id 2544',0.00,31.50,740.00,37.00,5.50,'2023-02-17 19:10:11'),(2397,'1','308',1,'Retail Sale Id 2545',0.00,1890.00,740.00,2220.00,330.00,'2023-02-18 07:29:25'),(2398,'1','308',1,'Retail Sale Id 2546',0.00,2551.50,740.00,2997.00,445.50,'2023-02-18 07:59:27'),(2399,'1','308',1,'Retail Sale Id 2547',0.00,680.40,740.00,799.20,118.80,'2023-02-18 08:22:18'),(2400,'1','308',1,'Retail Sale Id 2548',0.00,1278.90,740.00,1502.20,223.30,'2023-02-18 08:35:10'),(2401,'1','308',1,'Retail Sale Id 2549',0.00,28350.00,680.00,30600.00,2250.00,'2023-02-18 08:36:39'),(2402,'1','308',1,'Retail Sale Id 2550',0.00,680.40,740.00,799.20,118.80,'2023-02-18 08:38:01'),(2403,'1','308',1,'Retail Sale Id 2551',0.00,2551.50,740.00,2997.00,445.50,'2023-02-18 08:42:35'),(2404,'1','308',1,'Retail Sale Id 2552',0.00,680.40,740.00,799.20,118.80,'2023-02-18 08:51:55'),(2405,'1','308',1,'Retail Sale Id 2553',0.00,680.40,740.00,799.20,118.80,'2023-02-18 08:52:42'),(2406,'1','308',1,'Retail Sale Id 2554',0.00,15750.00,680.00,17000.00,1250.00,'2023-02-18 08:55:00'),(2407,'1','308',1,'Retail Sale Id 2555',0.00,2551.50,740.00,2997.00,445.50,'2023-02-18 09:11:18'),(2408,'1','308',1,'Retail Sale Id 2556',0.00,5040.00,740.00,5920.00,880.00,'2023-02-18 09:16:25'),(2409,'1','308',1,'Retail Sale Id 2557',0.00,1890.00,740.00,2220.00,330.00,'2023-02-18 09:17:40'),(2410,'1','308',1,'Retail Sale Id 2558',0.00,636.30,740.00,747.40,111.10,'2023-02-18 09:21:32'),(2411,'1','308',1,'Return of Retail Sale Id 2552',680.40,0.00,740.00,-799.20,-118.80,'2023-02-18 09:27:12'),(2412,'1','308',1,'Retail Sale Id 2559',0.00,2520.00,740.00,2960.00,440.00,'2023-02-18 09:28:18'),(2413,'1','308',1,'Retail Sale Id 2560',0.00,2551.50,740.00,2997.00,445.50,'2023-02-18 09:29:29'),(2414,'1','308',1,'Retail Sale Id 2561',0.00,3780.00,740.00,4440.00,660.00,'2023-02-18 09:33:56'),(2415,'1','308',1,'Retail Sale Id 2562',0.00,3780.00,740.00,4440.00,660.00,'2023-02-18 09:36:59'),(2416,'1','308',1,'Retail Sale Id 2563',0.00,2520.00,740.00,2960.00,440.00,'2023-02-18 09:40:29'),(2417,'1','308',1,'Retail Sale Id 2564',0.00,3150.00,740.00,3700.00,550.00,'2023-02-18 09:45:28'),(2418,'1','308',1,'Retail Sale Id 2565',0.00,19530.00,680.00,21080.00,1550.00,'2023-02-18 10:33:22'),(2419,'1','308',1,'Retail Sale Id 2566',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-18 10:34:36'),(2420,'1','308',1,'Retail Sale Id 2567',0.00,1701.00,740.00,1998.00,297.00,'2023-02-18 10:52:54'),(2421,'1','308',1,'Retail Sale Id 2568',0.00,1278.90,740.00,1502.20,223.30,'2023-02-18 11:08:50'),(2422,'1','308',1,'Retail Sale Id 2570',0.00,1890.00,740.00,2220.00,330.00,'2023-02-18 11:24:13'),(2423,'1','308',1,'Retail Sale Id 2571',0.00,3150.00,740.00,3700.00,550.00,'2023-02-18 12:13:11'),(2424,'1','308',1,'Retail Sale Id 2572',0.00,850.50,740.00,999.00,148.50,'2023-02-18 12:54:02'),(2425,'1','308',1,'Retail Sale Id 2573',0.00,850.50,740.00,999.00,148.50,'2023-02-18 13:00:36'),(2426,'1','308',1,'Retail Sale Id 2574',0.00,850.50,740.00,999.00,148.50,'2023-02-18 13:11:00'),(2427,'1','308',1,'Retail Sale Id 2575',0.00,6810.30,740.00,7999.40,1189.10,'2023-02-18 13:35:08'),(2428,'1','308',1,'Retail Sale Id 2576',0.00,2551.50,740.00,2997.00,445.50,'2023-02-18 13:41:44'),(2429,'1','308',1,'Retail Sale Id 2577',0.00,5670.00,740.00,6660.00,990.00,'2023-02-18 14:58:15'),(2430,'1','308',1,'Retail Sale Id 2578',0.00,1260.00,740.00,1480.00,220.00,'2023-02-18 15:49:34'),(2431,'1','308',1,'Retail Sale Id 2579',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-18 15:55:05'),(2432,'1','308',1,'Retail Sale Id 2580',0.00,1890.00,740.00,2220.00,330.00,'2023-02-18 15:56:09'),(2433,'1','308',1,'Retail Sale Id 2581',0.00,1260.00,740.00,1480.00,220.00,'2023-02-18 16:13:51'),(2434,'1','308',1,'Retail Sale Id 2582',0.00,3780.00,740.00,4440.00,660.00,'2023-02-18 16:30:53'),(2435,'1','308',1,'Retail Sale Id 2583',0.00,1890.00,740.00,2220.00,330.00,'2023-02-18 16:46:24'),(2436,'1','308',1,'Retail Sale Id 2584',0.00,1266.30,740.00,1487.40,221.10,'2023-02-18 16:58:58'),(2437,'1','308',1,'Retail Sale Id 2585',0.00,1260.00,740.00,1480.00,220.00,'2023-02-18 17:07:35'),(2438,'1','308',1,'Retail Sale Id 2586',0.00,3780.00,740.00,4440.00,660.00,'2023-02-18 17:12:21'),(2439,'1','308',1,'Retail Sale Id 2587',0.00,1260.00,740.00,1480.00,220.00,'2023-02-18 17:14:16'),(2440,'1','308',1,'Retail Sale Id 2588',0.00,636.30,740.00,747.40,111.10,'2023-02-18 17:19:18'),(2441,'1','308',1,'Retail Sale Id 2589',0.00,3780.00,740.00,4440.00,660.00,'2023-02-18 17:22:22'),(2442,'1','308',1,'Retail Sale Id 2590',0.00,680.40,740.00,799.20,118.80,'2023-02-18 17:39:19'),(2443,'1','308',1,'Retail Sale Id 2591',0.00,7560.00,740.00,8880.00,1320.00,'2023-02-18 18:03:27'),(2444,'1','308',1,'Retail Sale Id 2592',0.00,7560.00,740.00,8880.00,1320.00,'2023-02-18 18:05:32'),(2445,'1','308',1,'Retail Sale Id 2593',0.00,1260.00,740.00,1480.00,220.00,'2023-02-18 18:11:18'),(2446,'1','308',1,'Retail Sale Id 2594',0.00,636.30,740.00,747.40,111.10,'2023-02-18 18:20:02'),(2447,'1','308',1,'Retail Sale Id 2595',0.00,636.30,740.00,747.40,111.10,'2023-02-18 18:22:23'),(2448,'1','308',1,'Retail Sale Id 2597',0.00,1278.90,740.00,1502.20,223.30,'2023-02-18 18:28:03'),(2449,'1','308',1,'Retail Sale Id 2598',0.00,3780.00,740.00,4440.00,660.00,'2023-02-18 18:38:11'),(2450,'1','308',1,'Retail Sale Id 2599',0.00,1890.00,740.00,2220.00,330.00,'2023-02-18 19:06:38'),(2451,'1','308',1,'Retail Sale Id 2600',0.00,1278.90,740.00,1502.20,223.30,'2023-02-18 19:08:31'),(2452,'1','308',1,'Retail Sale Id 2601',0.00,2381.40,740.00,2797.20,415.80,'2023-02-18 19:10:56'),(2453,'1','308',1,'Retail Sale Id 2602',0.00,1890.00,740.00,2220.00,330.00,'2023-02-18 19:19:12'),(2454,'1','308',1,'Retail Sale Id 2603',0.00,1260.00,740.00,1480.00,220.00,'2023-02-18 19:20:41'),(2455,'1','308',1,'Retail Sale Id 2604',0.00,2520.00,740.00,2960.00,440.00,'2023-02-18 19:22:38'),(2456,'1','308',1,'Retail Sale Id 2605',0.00,4384.80,740.00,5150.40,765.60,'2023-02-18 19:38:16'),(2457,'1','308',1,'Retail Sale Id 2606',0.00,1197.00,740.00,1406.00,209.00,'2023-02-18 20:04:15'),(2458,'1','308',1,'Return of Retail Sale Id 2565',19530.00,0.00,680.00,-21080.00,-1550.00,'2023-02-18 20:07:07'),(2459,'1','308',1,'Retail Sale Id 2607',0.00,19233.90,680.00,20760.40,1526.50,'2023-02-18 20:10:16'),(2460,'1','308',1,'Retail Sale Id 2608',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-19 07:39:48'),(2461,'1','308',1,'Retail Sale Id 2609',0.00,3786.30,740.00,4447.40,661.10,'2023-02-19 07:46:03'),(2462,'1','308',1,'Retail Sale Id 2610',0.00,2551.50,740.00,2997.00,445.50,'2023-02-19 07:47:00'),(2463,'1','308',1,'Retail Sale Id 2611',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-19 08:11:52'),(2464,'1','308',1,'Retail Sale Id 2612',0.00,1278.90,740.00,1502.20,223.30,'2023-02-19 08:20:22'),(2465,'1','308',1,'Retail Sale Id 2613',0.00,5040.00,740.00,5920.00,880.00,'2023-02-19 08:21:42'),(2466,'1','308',1,'Retail Sale Id 2614',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-19 08:41:02'),(2467,'1','308',1,'Retail Sale Id 2615',0.00,1190.70,740.00,1398.60,207.90,'2023-02-19 09:25:53'),(2468,'1','308',1,'Retail Sale Id 2616',0.00,636.30,740.00,747.40,111.10,'2023-02-19 09:27:11'),(2469,'1','308',1,'Retail Sale Id 2617',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-19 09:44:37'),(2470,'1','308',1,'Retail Sale Id 2618',0.00,636.30,740.00,747.40,111.10,'2023-02-19 10:36:41'),(2471,'1','308',1,'Retail Sale Id 2619',0.00,1575.00,740.00,1850.00,275.00,'2023-02-19 11:20:58'),(2472,'1','308',1,'Retail Sale Id 2620',0.00,1260.00,740.00,1480.00,220.00,'2023-02-19 11:23:03'),(2473,'1','308',1,'Retail Sale Id 2621',0.00,3780.00,740.00,4440.00,660.00,'2023-02-19 11:24:02'),(2474,'1','308',1,'Retail Sale Id 2622',0.00,1278.90,740.00,1502.20,223.30,'2023-02-19 11:32:24'),(2475,'1','308',1,'Retail Sale Id 2623',0.00,636.30,740.00,747.40,111.10,'2023-02-19 11:34:00'),(2476,'1','308',1,'Retail Sale Id 2624',0.00,1890.00,740.00,2220.00,330.00,'2023-02-19 11:35:08'),(2477,'1','308',1,'Retail Sale Id 2625',0.00,3780.00,740.00,4440.00,660.00,'2023-02-19 11:37:14'),(2478,'1','308',1,'Retail Sale Id 2626',0.00,1890.00,740.00,2220.00,330.00,'2023-02-19 11:39:42'),(2479,'1','308',1,'Retail Sale Id 2627',0.00,6344.10,740.00,7451.80,1107.70,'2023-02-19 11:44:09'),(2480,'1','308',1,'Retail Sale Id 2628',0.00,3150.00,740.00,3700.00,550.00,'2023-02-19 11:56:37'),(2481,'1','308',1,'Retail Sale Id 2629',0.00,3150.00,740.00,3700.00,550.00,'2023-02-19 12:17:07'),(2482,'1','308',1,'Retail Sale Id 2630',0.00,3780.00,740.00,4440.00,660.00,'2023-02-19 12:24:19'),(2483,'1','308',1,'Retail Sale Id 2631',0.00,3780.00,740.00,4440.00,660.00,'2023-02-19 12:48:56'),(2484,'1','308',1,'Retail Sale Id 2632',0.00,3780.00,740.00,4440.00,660.00,'2023-02-19 12:56:09'),(2485,'1','308',1,'Retail Sale Id 2633',0.00,2520.00,740.00,2960.00,440.00,'2023-02-19 12:57:35'),(2486,'1','308',1,'Retail Sale Id 2634',0.00,1278.90,740.00,1502.20,223.30,'2023-02-19 13:12:27'),(2487,'1','308',1,'Retail Sale Id 2635',0.00,680.40,740.00,799.20,118.80,'2023-02-19 13:13:12'),(2488,'1','308',1,'Retail Sale Id 2636',0.00,12789.00,680.00,13804.00,1015.00,'2023-02-19 13:16:24'),(2489,'1','308',1,'Retail Sale Id 2637',0.00,1890.00,740.00,2220.00,330.00,'2023-02-19 13:24:48'),(2490,'1','308',1,'Retail Sale Id 2638',0.00,2520.00,740.00,2960.00,440.00,'2023-02-19 13:29:03'),(2491,'1','308',1,'Retail Sale Id 2639',0.00,3780.00,740.00,4440.00,660.00,'2023-02-19 13:37:17'),(2492,'1','308',1,'Retail Sale Id 2640',0.00,3780.00,740.00,4440.00,660.00,'2023-02-19 13:43:03'),(2493,'1','308',1,'Retail Sale Id 2641',0.00,1278.90,740.00,1502.20,223.30,'2023-02-19 13:44:38'),(2494,'1','308',1,'Retail Sale Id 2642',0.00,1890.00,740.00,2220.00,330.00,'2023-02-19 13:46:38'),(2495,'1','308',1,'Retail Sale Id 2643',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-19 14:00:17'),(2496,'1','308',1,'Retail Sale Id 2644',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-19 14:25:30'),(2497,'1','308',1,'Retail Sale Id 2645',0.00,1915.20,740.00,2249.60,334.40,'2023-02-19 15:58:20'),(2498,'1','308',1,'Retail Sale Id 2646',0.00,636.30,740.00,747.40,111.10,'2023-02-19 16:36:50'),(2499,'1','308',1,'Retail Sale Id 2647',0.00,28350.00,680.00,30600.00,2250.00,'2023-02-19 16:41:03'),(2500,'1','308',1,'Retail Sale Id 2648',0.00,3780.00,740.00,4440.00,660.00,'2023-02-19 16:48:31'),(2501,'1','308',1,'Retail Sale Id 2649',0.00,3780.00,740.00,4440.00,660.00,'2023-02-19 16:55:36'),(2502,'1','308',1,'Return of Retail Sale Id 2644',6300.00,0.00,740.00,-7400.00,-1100.00,'2023-02-19 17:02:38'),(2503,'1','308',1,'Retail Sale Id 2650',0.00,1890.00,740.00,2220.00,330.00,'2023-02-19 17:10:38'),(2504,'1','308',1,'Retail Sale Id 2651',0.00,1890.00,740.00,2220.00,330.00,'2023-02-19 17:16:44'),(2505,'1','308',1,'Retail Sale Id 2652',0.00,3150.00,740.00,3700.00,550.00,'2023-02-19 17:21:48'),(2506,'1','308',1,'Retail Sale Id 2653',0.00,1278.90,740.00,1502.20,223.30,'2023-02-19 17:33:43'),(2507,'1','308',1,'Retail Sale Id 2654',0.00,1890.00,740.00,2220.00,330.00,'2023-02-19 17:37:07'),(2508,'1','308',1,'Retail Sale Id 2655',0.00,1278.90,740.00,1502.20,223.30,'2023-02-19 17:48:29'),(2509,'1','308',1,'Retail Sale Id 2656',0.00,1890.00,740.00,2220.00,330.00,'2023-02-19 17:55:26'),(2510,'1','308',1,'Retail Sale Id 2657',0.00,3780.00,740.00,4440.00,660.00,'2023-02-19 17:58:53'),(2511,'1','308',1,'Retail Sale Id 2658',0.00,1260.00,740.00,1480.00,220.00,'2023-02-19 18:01:36'),(2512,'1','308',1,'Retail Sale Id 2659',0.00,1890.00,740.00,2220.00,330.00,'2023-02-19 18:02:50'),(2513,'1','308',1,'Retail Sale Id 2660',0.00,1890.00,740.00,2220.00,330.00,'2023-02-19 18:03:42'),(2514,'1','308',1,'Retail Sale Id 2661',0.00,2520.00,740.00,2960.00,440.00,'2023-02-19 18:04:34'),(2515,'1','308',1,'Retail Sale Id 2662',0.00,1890.00,740.00,2220.00,330.00,'2023-02-19 18:25:13'),(2516,'1','308',1,'Retail Sale Id 2663',0.00,2520.00,740.00,2960.00,440.00,'2023-02-19 18:29:17'),(2517,'1','308',1,'Retail Sale Id 2664',0.00,2520.00,740.00,2960.00,440.00,'2023-02-19 18:33:29'),(2518,'1','308',1,'Retail Sale Id 2665',0.00,3150.00,740.00,3700.00,550.00,'2023-02-19 18:37:15'),(2519,'1','308',1,'Retail Sale Id 2666',0.00,3150.00,740.00,3700.00,550.00,'2023-02-19 18:42:41'),(2520,'1','308',1,'Retail Sale Id 2667',0.00,1278.90,740.00,1502.20,223.30,'2023-02-19 18:49:32'),(2521,'1','308',1,'Retail Sale Id 2669',0.00,1291.50,740.00,1517.00,225.50,'2023-02-19 18:54:27'),(2522,'1','308',1,'Retail Sale Id 2670',0.00,18400.00,680.00,17000.00,-1400.00,'2023-02-20 08:09:08'),(2523,'1','308',1,'Retail Sale Id 2671',0.00,699.20,736.00,699.20,0.00,'2023-02-20 08:10:02'),(2524,'1','308',1,'Retail Sale Id 2672',0.00,4416.00,736.00,4416.00,0.00,'2023-02-20 08:18:43'),(2525,'1','308',1,'Retail Sale Id 2673',0.00,7360.00,736.00,7360.00,0.00,'2023-02-20 08:23:05'),(2526,'1','308',1,'Retail Sale Id 2674',0.00,4416.00,736.00,4416.00,0.00,'2023-02-20 08:25:09'),(2527,'1','308',1,'Retail Sale Id 2675',0.00,1472.00,736.00,1472.00,0.00,'2023-02-20 08:42:36'),(2528,'1','308',1,'Retail Sale Id 2676',0.00,8096.00,736.00,8096.00,0.00,'2023-02-20 08:50:15'),(2529,'1','308',1,'Retail Sale Id 2677',0.00,5888.00,736.00,5888.00,0.00,'2023-02-20 09:00:19'),(2530,'1','308',1,'Retail Sale Id 2678',0.00,3680.00,736.00,3680.00,0.00,'2023-02-20 09:36:09'),(2531,'1','308',1,'Retail Sale Id 2679',0.00,1000.96,736.00,1000.96,0.00,'2023-02-20 10:10:59'),(2532,'1','308',1,'Retail Sale Id 2680',0.00,1472.00,736.00,1472.00,0.00,'2023-02-20 10:16:52'),(2533,'1','308',1,'Retail Sale Id 2681',0.00,3680.00,736.00,3680.00,0.00,'2023-02-20 10:48:42'),(2534,'1','308',1,'Retail Sale Id 2682',0.00,1000.96,736.00,1000.96,0.00,'2023-02-20 11:16:08'),(2535,'1','308',1,'Retail Sale Id 2683',0.00,73600.00,680.00,68000.00,-5600.00,'2023-02-20 12:09:25'),(2536,'1','308',1,'Retail Sale Id 2684',0.00,73600.00,680.00,68000.00,-5600.00,'2023-02-20 12:11:53'),(2537,'1','308',1,'Retail Sale Id 2685',0.00,2208.00,736.00,2208.00,0.00,'2023-02-20 12:15:24'),(2538,'1','308',1,'Retail Sale Id 2687',0.00,36800.00,680.00,34000.00,-2800.00,'2023-02-20 12:24:12'),(2539,'1','308',1,'Retail Sale Id 2688',0.00,3002.88,736.00,3002.88,0.00,'2023-02-20 12:34:03'),(2540,'1','308',1,'Retail Sale Id 2690',0.00,2001.92,736.00,2001.92,0.00,'2023-02-20 12:39:05'),(2541,'1','308',1,'Retail Sale Id 2691',0.00,1700.16,736.00,1700.16,0.00,'2023-02-20 12:41:10'),(2542,'1','308',1,'Retail Sale Id 2692',0.00,4416.00,736.00,4416.00,0.00,'2023-02-20 12:49:28'),(2543,'1','308',1,'Retail Sale Id 2693',0.00,2222.72,736.00,2222.72,0.00,'2023-02-20 12:50:46'),(2544,'1','308',1,'Retail Sale Id 2694',0.00,1472.00,736.00,1472.00,0.00,'2023-02-20 13:06:03'),(2545,'1','308',1,'Retail Sale Id 2695',0.00,1501.44,736.00,1501.44,0.00,'2023-02-20 13:37:03'),(2546,'1','308',1,'Retail Sale Id 2696',0.00,128064.00,680.00,118320.00,-9744.00,'2023-02-20 13:51:20'),(2547,'1','308',1,'Retail Sale Id 2697',0.00,2208.00,736.00,2208.00,0.00,'2023-02-20 14:13:28'),(2548,'1','308',1,'Retail Sale Id 2698',0.00,1472.00,736.00,1472.00,0.00,'2023-02-20 14:16:51'),(2549,'1','308',1,'Retail Sale Id 2699',0.00,5152.00,736.00,5152.00,0.00,'2023-02-20 14:34:56'),(2550,'1','308',1,'Retail Sale Id 2700',0.00,2208.00,736.00,2208.00,0.00,'2023-02-20 14:42:17'),(2551,'1','308',1,'Retail Sale Id 2701',0.00,2001.92,736.00,2001.92,0.00,'2023-02-20 15:11:28'),(2552,'1','308',1,'Retail Sale Id 2702',0.00,2944.00,736.00,2944.00,0.00,'2023-02-20 15:27:58'),(2553,'1','308',1,'Retail Sale Id 2703',0.00,2944.00,736.00,2944.00,0.00,'2023-02-20 15:28:54'),(2554,'1','308',1,'Retail Sale Id 2704',0.00,2944.00,736.00,2944.00,0.00,'2023-02-20 15:32:29'),(2555,'1','308',1,'Retail Sale Id 2705',0.00,2208.00,736.00,2208.00,0.00,'2023-02-20 15:39:59'),(2556,'1','308',1,'Retail Sale Id 2706',0.00,2230.08,736.00,2230.08,0.00,'2023-02-20 16:19:25'),(2557,'1','308',1,'Retail Sale Id 2707',0.00,750.72,736.00,750.72,0.00,'2023-02-20 16:20:54'),(2558,'1','308',1,'Retail Sale Id 2708',0.00,736.00,736.00,736.00,0.00,'2023-02-20 16:24:44'),(2559,'1','308',1,'Retail Sale Id 2709',0.00,2208.00,736.00,2208.00,0.00,'2023-02-20 16:29:02'),(2560,'1','308',1,'Retail Sale Id 2710',0.00,5152.00,736.00,5152.00,0.00,'2023-02-20 16:46:22'),(2561,'1','308',1,'Retail Sale Id 2711',0.00,1472.00,736.00,1472.00,0.00,'2023-02-20 16:50:48'),(2562,'1','308',1,'Retail Sale Id 2712',0.00,1472.00,736.00,1472.00,0.00,'2023-02-20 16:53:21'),(2563,'1','308',1,'Retail Sale Id 2713',0.00,2208.00,736.00,2208.00,0.00,'2023-02-20 16:58:40'),(2564,'1','308',1,'Retail Sale Id 2714',0.00,3680.00,736.00,3680.00,0.00,'2023-02-20 17:00:39'),(2565,'1','308',1,'Retail Sale Id 2715',0.00,2944.00,736.00,2944.00,0.00,'2023-02-20 17:11:32'),(2566,'1','308',1,'Retail Sale Id 2716',0.00,750.72,736.00,750.72,0.00,'2023-02-20 17:14:54'),(2567,'1','308',1,'Retail Sale Id 2717',0.00,2208.00,736.00,2208.00,0.00,'2023-02-20 17:39:25'),(2568,'1','308',1,'Retail Sale Id 2718',0.00,7396.80,736.00,7396.80,0.00,'2023-02-20 17:46:15'),(2569,'1','308',1,'Retail Sale Id 2719',0.00,3680.00,736.00,3680.00,0.00,'2023-02-20 17:48:16'),(2570,'1','308',1,'Retail Sale Id 2720',0.00,2208.00,736.00,2208.00,0.00,'2023-02-20 17:52:40'),(2571,'1','308',1,'Retail Sale Id 2721',0.00,3002.88,736.00,3002.88,0.00,'2023-02-20 17:54:22'),(2572,'1','308',1,'Retail Sale Id 2722',0.00,750.72,736.00,750.72,0.00,'2023-02-20 17:55:50'),(2573,'1','308',1,'Retail Sale Id 2723',0.00,2208.00,736.00,2208.00,0.00,'2023-02-20 18:02:45'),(2574,'1','308',1,'Retail Sale Id 2724',0.00,2944.00,736.00,2944.00,0.00,'2023-02-20 18:05:54'),(2575,'1','308',1,'Retail Sale Id 2726',0.00,4416.00,736.00,4416.00,0.00,'2023-02-20 18:13:01'),(2576,'1','308',1,'Retail Sale Id 2727',0.00,4416.00,736.00,4416.00,0.00,'2023-02-20 18:18:55'),(2577,'1','308',1,'Retail Sale Id 2728',0.00,5203.52,736.00,5203.52,0.00,'2023-02-20 18:21:01'),(2578,'1','308',1,'Retail Sale Id 2730',0.00,3680.00,736.00,3680.00,0.00,'2023-02-20 18:29:47'),(2579,'1','308',1,'Retail Sale Id 2731',0.00,1000.96,736.00,1000.96,0.00,'2023-02-20 18:32:45'),(2580,'1','308',1,'Retail Sale Id 2732',0.00,4416.00,736.00,4416.00,0.00,'2023-02-20 18:35:08'),(2581,'1','308',1,'Return of Retail Sale Id 2721',3002.88,0.00,736.00,-3002.88,0.00,'2023-02-20 18:38:22'),(2582,'1','308',1,'Retail Sale Id 2734',0.00,1472.00,736.00,1472.00,0.00,'2023-02-20 18:39:01'),(2583,'1','308',1,'Retail Sale Id 2735',0.00,3680.00,736.00,3680.00,0.00,'2023-02-20 18:42:53'),(2584,'1','308',1,'Retail Sale Id 2736',0.00,3680.00,736.00,3680.00,0.00,'2023-02-20 18:44:10'),(2585,'1','308',1,'Retail Sale Id 2737',0.00,1501.44,736.00,1501.44,0.00,'2023-02-20 18:45:40'),(2586,'1','308',1,'Retail Sale Id 2738',0.00,2208.00,736.00,2208.00,0.00,'2023-02-20 18:55:08'),(2587,'1','308',1,'Retail Sale Id 2739',0.00,2208.00,736.00,2208.00,0.00,'2023-02-20 18:58:00'),(2588,'1','308',1,'Retail Sale Id 2740',0.00,2208.00,736.00,2208.00,0.00,'2023-02-20 19:46:25'),(2589,'1','308',1,'Retail Sale Id 2741',0.00,4416.00,736.00,4416.00,0.00,'2023-02-21 07:46:18'),(2590,'1','308',1,'Retail Sale Id 2742',0.00,73600.00,680.00,68000.00,-5600.00,'2023-02-21 07:49:38'),(2591,'1','308',1,'Retail Sale Id 2743',0.00,2208.00,680.00,2040.00,-168.00,'2023-02-21 07:52:40'),(2592,'1','308',1,'Retail Sale Id 2744',0.00,22080.00,680.00,20400.00,-1680.00,'2023-02-21 07:56:15'),(2593,'1','308',1,'Retail Sale Id 2745',0.00,4416.00,736.00,4416.00,0.00,'2023-02-21 08:10:17'),(2594,'1','308',1,'Retail Sale Id 2746',0.00,5152.00,736.00,5152.00,0.00,'2023-02-21 08:12:49'),(2595,'1','308',1,'Retail Sale Id 2747',0.00,736.00,736.00,736.00,0.00,'2023-02-21 08:21:23'),(2596,'1','308',1,'Retail Sale Id 2748',0.00,29440.00,680.00,27200.00,-2240.00,'2023-02-21 08:23:12'),(2597,'1','308',1,'Retail Sale Id 2749',0.00,2001.92,736.00,2001.92,0.00,'2023-02-21 08:24:41'),(2598,'1','308',1,'Retail Sale Id 2750',0.00,4416.00,736.00,4416.00,0.00,'2023-02-21 08:46:16'),(2599,'1','308',1,'Retail Sale Id 2751',0.00,1000.96,736.00,1000.96,0.00,'2023-02-21 08:47:44'),(2600,'1','308',1,'Retail Sale Id 2752',0.00,9200.00,736.00,9200.00,0.00,'2023-02-21 09:02:49'),(2601,'1','308',1,'Retail Sale Id 2753',0.00,1472.00,736.00,1472.00,0.00,'2023-02-21 09:25:39'),(2602,'1','308',1,'Retail Sale Id 2754',0.00,9200.00,736.00,9200.00,0.00,'2023-02-21 09:27:19'),(2603,'1','308',1,'Retail Sale Id 2755',0.00,8832.00,736.00,8832.00,0.00,'2023-02-21 09:41:22'),(2604,'1','308',1,'Retail Sale Id 2756',0.00,750.72,736.00,750.72,0.00,'2023-02-21 09:54:13'),(2605,'1','308',1,'Retail Sale Id 2757',0.00,1472.00,736.00,1472.00,0.00,'2023-02-21 10:16:49'),(2606,'1','308',1,'Retail Sale Id 2758',0.00,2208.00,736.00,2208.00,0.00,'2023-02-21 10:24:05'),(2607,'1','308',1,'Retail Sale Id 2759',0.00,1472.00,736.00,1472.00,0.00,'2023-02-21 10:27:03'),(2608,'1','308',1,'Retail Sale Id 2760',0.00,3680.00,736.00,3680.00,0.00,'2023-02-21 11:11:17'),(2609,'1','308',1,'Retail Sale Id 2761',0.00,1472.00,736.00,1472.00,0.00,'2023-02-21 11:24:28'),(2610,'1','308',1,'Retail Sale Id 2762',0.00,2208.00,736.00,2208.00,0.00,'2023-02-21 11:29:28'),(2611,'1','308',1,'Retail Sale Id 2763',0.00,2208.00,736.00,2208.00,0.00,'2023-02-21 11:46:45'),(2612,'1','308',1,'Retail Sale Id 2764',0.00,9200.00,736.00,9200.00,0.00,'2023-02-21 11:48:28'),(2613,'1','308',1,'Retail Sale Id 2765',0.00,6624.00,736.00,6624.00,0.00,'2023-02-21 12:06:36'),(2614,'1','308',1,'Retail Sale Id 2766',0.00,750.72,736.00,750.72,0.00,'2023-02-21 12:33:56'),(2615,'1','308',1,'Retail Sale Id 2767',0.00,4416.00,736.00,4416.00,0.00,'2023-02-21 13:03:57'),(2616,'1','308',1,'Retail Sale Id 2768',0.00,2944.00,736.00,2944.00,0.00,'2023-02-21 13:24:05'),(2617,'1','308',1,'Retail Sale Id 2769',0.00,1472.00,736.00,1472.00,0.00,'2023-02-21 13:28:19'),(2618,'1','308',1,'Retail Sale Id 2770',0.00,2944.00,736.00,2944.00,0.00,'2023-02-21 13:34:58'),(2619,'1','308',1,'Retail Sale Id 2771',0.00,5203.52,736.00,5203.52,0.00,'2023-02-21 13:37:07'),(2620,'1','308',1,'Retail Sale Id 2772',0.00,7360.00,736.00,7360.00,0.00,'2023-02-21 13:57:27'),(2621,'1','308',1,'Retail Sale Id 2774',0.00,1472.00,736.00,1472.00,0.00,'2023-02-21 14:08:27'),(2622,'1','308',1,'Retail Sale Id 2775',0.00,736.00,736.00,736.00,0.00,'2023-02-21 14:09:56'),(2623,'1','308',1,'Retail Sale Id 2776',0.00,2701.12,736.00,2701.12,0.00,'2023-02-21 14:18:41'),(2624,'1','308',1,'Retail Sale Id 2777',0.00,3702.08,736.00,3702.08,0.00,'2023-02-21 14:21:49'),(2625,'1','308',1,'Retail Sale Id 2778',0.00,750.72,736.00,750.72,0.00,'2023-02-21 14:25:15'),(2626,'1','308',1,'Retail Sale Id 2779',0.00,736.00,736.00,736.00,0.00,'2023-02-21 14:26:36'),(2627,'1','308',1,'Retail Sale Id 2780',0.00,1472.00,736.00,1472.00,0.00,'2023-02-21 14:40:51'),(2628,'1','308',1,'Retail Sale Id 2781',0.00,2208.00,736.00,2208.00,0.00,'2023-02-21 14:45:53'),(2629,'1','308',1,'Retail Sale Id 2782',0.00,1501.44,736.00,1501.44,0.00,'2023-02-21 14:58:23'),(2630,'1','308',1,'Retail Sale Id 2783',0.00,301.76,736.00,301.76,0.00,'2023-02-21 15:49:48'),(2631,'1','308',1,'Retail Sale Id 2784',0.00,2502.40,736.00,2502.40,0.00,'2023-02-21 16:16:56'),(2632,'1','308',1,'Retail Sale Id 2785',0.00,4416.00,736.00,4416.00,0.00,'2023-02-21 16:18:14'),(2633,'1','308',1,'Retail Sale Id 2786',0.00,750.72,736.00,750.72,0.00,'2023-02-21 16:28:25'),(2634,'1','308',1,'Retail Sale Id 2787',0.00,736.00,736.00,736.00,0.00,'2023-02-21 16:29:38'),(2635,'1','308',1,'Retail Sale Id 2788',0.00,9001.28,736.00,9001.28,0.00,'2023-02-21 16:31:23'),(2636,'1','308',1,'Retail Sale Id 2789',0.00,9200.00,736.00,9200.00,0.00,'2023-02-21 17:18:37'),(2637,'1','308',1,'Retail Sale Id 2790',0.00,2944.00,736.00,2944.00,0.00,'2023-02-21 17:35:42'),(2638,'1','308',1,'Retail Sale Id 2791',0.00,9200.00,736.00,9200.00,0.00,'2023-02-21 17:38:29'),(2639,'1','308',1,'Retail Sale Id 2792',0.00,4416.00,736.00,4416.00,0.00,'2023-02-21 17:39:15'),(2640,'1','308',1,'Retail Sale Id 2793',0.00,750.72,736.00,750.72,0.00,'2023-02-21 17:43:48'),(2641,'1','308',1,'Retail Sale Id 2794',0.00,4997.44,736.00,4997.44,0.00,'2023-02-21 17:47:45'),(2642,'1','308',1,'Retail Sale Id 2795',0.00,1096.64,736.00,1096.64,0.00,'2023-02-21 17:53:11'),(2643,'1','308',1,'Retail Sale Id 2796',0.00,1398.40,736.00,1398.40,0.00,'2023-02-21 17:54:51'),(2644,'1','308',1,'Retail Sale Id 2797',0.00,25112.32,680.00,23201.60,-1910.72,'2023-02-21 17:59:12'),(2645,'1','308',1,'Retail Sale Id 2798',0.00,5696.64,736.00,5696.64,0.00,'2023-02-21 18:02:51'),(2646,'1','308',1,'Retail Sale Id 2799',0.00,2208.00,736.00,2208.00,0.00,'2023-02-21 18:09:14'),(2647,'1','308',1,'Retail Sale Id 2800',0.00,2208.00,736.00,2208.00,0.00,'2023-02-21 18:11:44'),(2648,'1','308',1,'Retail Sale Id 2801',0.00,3680.00,736.00,3680.00,0.00,'2023-02-21 18:15:31'),(2649,'1','308',1,'Retail Sale Id 2802',0.00,2208.00,736.00,2208.00,0.00,'2023-02-21 18:22:11'),(2650,'1','308',1,'Retail Sale Id 2803',0.00,2208.00,736.00,2208.00,0.00,'2023-02-21 18:23:56'),(2651,'1','308',1,'Retail Sale Id 2804',0.00,1597.12,736.00,1597.12,0.00,'2023-02-21 18:26:38'),(2652,'1','308',1,'Retail Sale Id 2805',0.00,2208.00,736.00,2208.00,0.00,'2023-02-21 18:29:36'),(2653,'1','308',1,'Retail Sale Id 2806',0.00,4416.00,736.00,4416.00,0.00,'2023-02-21 18:33:53'),(2654,'1','308',1,'Retail Sale Id 2807',0.00,14.72,736.00,14.72,0.00,'2023-02-21 19:29:56'),(2655,'1','308',1,'Retail Sale Id 2808',0.00,2944.00,736.00,2944.00,0.00,'2023-02-22 08:04:19'),(2656,'1','308',1,'Retail Sale Id 2809',0.00,3002.88,736.00,3002.88,0.00,'2023-02-22 08:06:46'),(2657,'1','308',1,'Retail Sale Id 2810',0.00,1000.96,736.00,1000.96,0.00,'2023-02-22 08:08:25'),(2658,'1','308',1,'Retail Sale Id 2811',0.00,1501.44,736.00,1501.44,0.00,'2023-02-22 08:11:05'),(2659,'1','308',1,'Retail Sale Id 2812',0.00,18400.00,680.00,17000.00,-1400.00,'2023-02-22 08:16:49'),(2660,'1','308',1,'Retail Sale Id 2813',0.00,2208.00,736.00,2208.00,0.00,'2023-02-22 08:31:08'),(2661,'1','308',1,'Retail Sale Id 2814',0.00,2944.00,736.00,2944.00,0.00,'2023-02-22 08:34:06'),(2662,'1','308',1,'Retail Sale Id 2815',0.00,2208.00,736.00,2208.00,0.00,'2023-02-22 08:47:19'),(2663,'1','308',1,'Retail Sale Id 2816',0.00,3680.00,736.00,3680.00,0.00,'2023-02-22 08:51:12'),(2664,'1','308',1,'Retail Sale Id 2817',0.00,3680.00,736.00,3680.00,0.00,'2023-02-22 08:52:44'),(2665,'1','308',1,'Retail Sale Id 2818',0.00,4416.00,736.00,4416.00,0.00,'2023-02-22 09:02:37'),(2666,'1','308',1,'Retail Sale Id 2819',0.00,3680.00,736.00,3680.00,0.00,'2023-02-22 09:12:44'),(2667,'1','308',1,'Retail Sale Id 2820',0.00,9200.00,736.00,9200.00,0.00,'2023-02-22 09:16:23'),(2668,'1','308',1,'Retail Sale Id 2821',0.00,2944.00,736.00,2944.00,0.00,'2023-02-22 09:49:29'),(2669,'1','308',1,'Retail Sale Id 2822',0.00,1472.00,736.00,1472.00,0.00,'2023-02-22 10:09:23'),(2670,'1','308',1,'Retail Sale Id 2823',0.00,7360.00,736.00,7360.00,0.00,'2023-02-22 10:12:54'),(2671,'1','308',1,'Retail Sale Id 2824',0.00,3680.00,736.00,3680.00,0.00,'2023-02-22 10:16:07'),(2672,'1','308',1,'Retail Sale Id 2825',0.00,2303.68,736.00,2303.68,0.00,'2023-02-22 10:18:56'),(2673,'1','308',1,'Retail Sale Id 2826',0.00,1501.44,736.00,1501.44,0.00,'2023-02-22 10:20:50'),(2674,'1','308',1,'Retail Sale Id 2827',0.00,3680.00,736.00,3680.00,0.00,'2023-02-22 10:26:03'),(2675,'1','308',1,'Retail Sale Id 2828',0.00,9200.00,736.00,9200.00,0.00,'2023-02-22 10:48:41'),(2676,'1','308',1,'Retail Sale Id 2829',0.00,3680.00,736.00,3680.00,0.00,'2023-02-22 10:53:40'),(2677,'1','308',1,'Retail Sale Id 2830',0.00,5152.00,736.00,5152.00,0.00,'2023-02-22 10:58:52'),(2678,'1','308',1,'Retail Sale Id 2831',0.00,1472.00,736.00,1472.00,0.00,'2023-02-22 11:00:26'),(2679,'1','308',1,'Retail Sale Id 2832',0.00,2944.00,736.00,2944.00,0.00,'2023-02-22 11:02:15'),(2680,'1','308',1,'Retail Sale Id 2833',0.00,1472.00,736.00,1472.00,0.00,'2023-02-22 11:04:03'),(2681,'1','308',1,'Retail Sale Id 2834',0.00,4416.00,736.00,4416.00,0.00,'2023-02-22 11:06:51'),(2682,'1','308',1,'Retail Sale Id 2835',0.00,202400.00,680.00,187000.00,-15400.00,'2023-02-22 11:09:56'),(2683,'1','308',1,'Retail Sale Id 2836',0.00,4416.00,736.00,4416.00,0.00,'2023-02-22 11:40:00'),(2684,'1','308',1,'Retail Sale Id 2837',0.00,4416.00,736.00,4416.00,0.00,'2023-02-22 11:43:06'),(2685,'1','308',1,'Retail Sale Id 2838',0.00,743.36,736.00,743.36,0.00,'2023-02-22 11:45:19'),(2686,'1','308',1,'Retail Sale Id 2839',0.00,4416.00,736.00,4416.00,0.00,'2023-02-22 11:48:02'),(2687,'1','308',1,'Retail Sale Id 2840',0.00,2944.00,736.00,2944.00,0.00,'2023-02-22 11:50:51'),(2688,'1','308',1,'Retail Sale Id 2841',0.00,2208.00,736.00,2208.00,0.00,'2023-02-22 11:53:33'),(2689,'1','308',1,'Retail Sale Id 2842',0.00,9200.00,736.00,9200.00,0.00,'2023-02-22 11:55:15'),(2690,'1','308',1,'Retail Sale Id 2843',0.00,7360.00,736.00,7360.00,0.00,'2023-02-22 11:58:25'),(2691,'1','308',1,'Retail Sale Id 2844',0.00,4416.00,736.00,4416.00,0.00,'2023-02-22 12:06:00'),(2692,'1','308',1,'Retail Sale Id 2845',0.00,3680.00,736.00,3680.00,0.00,'2023-02-22 12:08:09'),(2693,'1','308',1,'Retail Sale Id 2846',0.00,7360.00,736.00,7360.00,0.00,'2023-02-22 12:11:06'),(2694,'1','308',1,'Retail Sale Id 2847',0.00,2200.64,736.00,2200.64,0.00,'2023-02-22 12:27:50'),(2695,'1','308',1,'Retail Sale Id 2848',0.00,2951.36,736.00,2951.36,0.00,'2023-02-22 12:29:56'),(2696,'1','308',1,'Retail Sale Id 2849',0.00,2951.36,736.00,2951.36,0.00,'2023-02-22 12:31:25'),(2697,'1','308',1,'Retail Sale Id 2850',0.00,2944.00,736.00,2944.00,0.00,'2023-02-22 12:46:27'),(2698,'1','308',1,'Retail Sale Id 2851',0.00,1472.00,736.00,1472.00,0.00,'2023-02-22 13:00:54'),(2699,'1','308',1,'Retail Sale Id 2852',0.00,1472.00,736.00,1472.00,0.00,'2023-02-22 13:10:27'),(2700,'1','308',1,'Retail Sale Id 2853',0.00,2502.40,736.00,2502.40,0.00,'2023-02-22 13:15:20'),(2701,'1','308',1,'Retail Sale Id 2854',0.00,4416.00,736.00,4416.00,0.00,'2023-02-22 13:19:18'),(2702,'1','308',1,'Retail Sale Id 2855',0.00,4416.00,736.00,4416.00,0.00,'2023-02-22 13:21:14'),(2703,'1','308',1,'Retail Sale Id 2856',0.00,1472.00,736.00,1472.00,0.00,'2023-02-22 13:24:12'),(2704,'1','308',1,'Retail Sale Id 2857',0.00,743.36,736.00,743.36,0.00,'2023-02-22 13:36:37'),(2705,'1','308',1,'Retail Sale Id 2858',0.00,743.36,736.00,743.36,0.00,'2023-02-22 13:38:33'),(2706,'1','308',1,'Return of Retail Sale Id 2857',743.36,0.00,736.00,-743.36,0.00,'2023-02-22 13:47:16'),(2707,'1','308',1,'Return of Retail Sale Id 2855',4416.00,0.00,736.00,-4416.00,0.00,'2023-02-22 13:50:09'),(2708,'1','308',1,'Retail Sale Id 2863',0.00,1501.44,736.00,1501.44,0.00,'2023-02-22 14:39:06'),(2709,'1','308',1,'Retail Sale Id 2864',0.00,1000.96,736.00,1000.96,0.00,'2023-02-22 15:06:07'),(2710,'1','308',1,'Retail Sale Id 2865',0.00,4416.00,736.00,4416.00,0.00,'2023-02-22 15:11:13'),(2711,'1','308',1,'Retail Sale Id 2866',0.00,4496.96,736.00,4496.96,0.00,'2023-02-22 15:12:17'),(2712,'1','308',1,'Retail Sale Id 2867',0.00,55626.88,736.00,55626.88,0.00,'2023-02-22 16:04:54'),(2713,'1','308',1,'Retail Sale Id 2868',0.00,3002.88,736.00,3002.88,0.00,'2023-02-22 16:14:28'),(2714,'1','308',1,'Retail Sale Id 2869',0.00,2944.00,736.00,2944.00,0.00,'2023-02-22 16:26:08'),(2715,'1','308',1,'Retail Sale Id 2870',0.00,743.36,736.00,743.36,0.00,'2023-02-22 16:53:21'),(2716,'1','308',1,'Retail Sale Id 2871',0.00,1501.44,736.00,1501.44,0.00,'2023-02-22 16:54:43'),(2717,'1','308',1,'Retail Sale Id 2872',0.00,1501.44,736.00,1501.44,0.00,'2023-02-22 16:56:43'),(2718,'1','308',1,'Retail Sale Id 2873',0.00,3702.08,736.00,3702.08,0.00,'2023-02-22 16:58:06'),(2719,'1','308',1,'Retail Sale Id 2874',0.00,2921.92,680.00,2699.60,-222.32,'2023-02-22 17:02:53'),(2720,'1','308',1,'Retail Sale Id 2875',0.00,2208.00,736.00,2208.00,0.00,'2023-02-22 17:04:17'),(2721,'1','308',1,'Return of Retail Sale Id 2867',55626.88,0.00,736.00,-55626.88,0.00,'2023-02-22 17:09:40'),(2722,'1','308',1,'Retail Sale Id 2876',0.00,51946.88,736.00,51946.88,0.00,'2023-02-22 17:11:47'),(2723,'1','308',1,'Retail Sale Id 2877',0.00,2208.00,736.00,2208.00,0.00,'2023-02-22 17:12:51'),(2724,'1','308',1,'Retail Sale Id 2878',0.00,2208.00,736.00,2208.00,0.00,'2023-02-22 17:15:00'),(2725,'1','308',1,'Retail Sale Id 2879',0.00,603.52,736.00,603.52,0.00,'2023-02-22 17:17:22'),(2726,'1','308',1,'Retail Sale Id 2880',0.00,1000.96,736.00,1000.96,0.00,'2023-02-22 17:36:49'),(2727,'1','308',1,'Retail Sale Id 2881',0.00,802.24,736.00,802.24,0.00,'2023-02-22 18:01:11'),(2728,'1','308',1,'Retail Sale Id 2882',0.00,750.72,736.00,750.72,0.00,'2023-02-22 18:28:01'),(2729,'1','308',1,'Retail Sale Id 2883',0.00,6646.08,736.00,6646.08,0.00,'2023-02-22 19:42:38'),(2730,'1','308',1,'Retail Sale Id 2884',0.00,4416.00,736.00,4416.00,0.00,'2023-02-23 07:45:36'),(2731,'1','308',1,'Retail Sale Id 2885',0.00,2208.00,736.00,2208.00,0.00,'2023-02-23 07:47:12'),(2732,'1','308',1,'Retail Sale Id 2886',0.00,2001.92,736.00,2001.92,0.00,'2023-02-23 07:48:58'),(2733,'1','308',1,'Retail Sale Id 2887',0.00,1472.00,736.00,1472.00,0.00,'2023-02-23 07:50:55'),(2734,'1','308',1,'Retail Sale Id 2888',0.00,3680.00,736.00,3680.00,0.00,'2023-02-23 07:55:44'),(2735,'1','308',1,'Retail Sale Id 2889',0.00,22080.00,680.00,20400.00,-1680.00,'2023-02-23 07:57:05'),(2736,'1','308',1,'Retail Sale Id 2890',0.00,2944.00,736.00,2944.00,0.00,'2023-02-23 07:58:31'),(2737,'1','308',1,'Retail Sale Id 2891',0.00,4416.00,736.00,4416.00,0.00,'2023-02-23 08:00:41'),(2738,'1','308',1,'Retail Sale Id 2892',0.00,2208.00,736.00,2208.00,0.00,'2023-02-23 08:02:44'),(2739,'1','308',1,'Retail Sale Id 2893',0.00,2208.00,736.00,2208.00,0.00,'2023-02-23 08:11:11'),(2740,'1','308',1,'Retail Sale Id 2894',0.00,2001.92,736.00,2001.92,0.00,'2023-02-23 08:18:19'),(2741,'1','308',1,'Retail Sale Id 2895',0.00,2208.00,736.00,2208.00,0.00,'2023-02-23 08:25:05'),(2742,'1','308',1,'Retail Sale Id 2896',0.00,2944.00,736.00,2944.00,0.00,'2023-02-23 08:30:18'),(2743,'1','308',1,'Retail Sale Id 2897',0.00,4997.44,736.00,4997.44,0.00,'2023-02-23 08:36:50'),(2744,'1','308',1,'Retail Sale Id 2898',0.00,4997.44,736.00,4997.44,0.00,'2023-02-23 08:40:21'),(2745,'1','308',1,'Retail Sale Id 2899',0.00,2502.40,736.00,2502.40,0.00,'2023-02-23 08:42:13'),(2746,'1','308',1,'Retail Sale Id 2900',0.00,4416.00,736.00,4416.00,0.00,'2023-02-23 08:54:20'),(2747,'1','308',1,'Retail Sale Id 2901',0.00,11408.00,736.00,11408.00,0.00,'2023-02-23 09:02:44'),(2748,'1','308',1,'Retail Sale Id 2902',0.00,736.00,736.00,736.00,0.00,'2023-02-23 09:04:43'),(2749,'1','308',1,'Retail Sale Id 2903',0.00,1472.00,736.00,1472.00,0.00,'2023-02-23 09:06:02'),(2750,'1','308',1,'Retail Sale Id 2904',0.00,2208.00,736.00,2208.00,0.00,'2023-02-23 09:07:13'),(2751,'1','308',1,'Retail Sale Id 2905',0.00,9200.00,736.00,9200.00,0.00,'2023-02-23 09:12:22'),(2752,'1','308',1,'Retail Sale Id 2906',0.00,1472.00,736.00,1472.00,0.00,'2023-02-23 09:13:36'),(2753,'1','308',1,'Retail Sale Id 2907',0.00,2208.00,736.00,2208.00,0.00,'2023-02-23 09:16:18'),(2754,'1','308',1,'Retail Sale Id 2908',0.00,2208.00,736.00,2208.00,0.00,'2023-02-23 09:17:37'),(2755,'1','308',1,'Retail Sale Id 2909',0.00,4416.00,736.00,4416.00,0.00,'2023-02-23 09:18:45'),(2756,'1','308',1,'Retail Sale Id 2910',0.00,9200.00,680.00,8500.00,-700.00,'2023-02-23 09:22:17'),(2757,'1','308',1,'Retail Sale Id 2911',0.00,2208.00,736.00,2208.00,0.00,'2023-02-23 09:27:32'),(2758,'1','308',1,'Retail Sale Id 2912',0.00,2208.00,736.00,2208.00,0.00,'2023-02-23 09:31:51'),(2759,'1','308',1,'Retail Sale Id 2913',0.00,4416.00,736.00,4416.00,0.00,'2023-02-23 09:33:41'),(2760,'1','308',1,'Retail Sale Id 2914',0.00,2208.00,736.00,2208.00,0.00,'2023-02-23 09:38:04'),(2761,'1','308',1,'Retail Sale Id 2915',0.00,1472.00,736.00,1472.00,0.00,'2023-02-23 09:40:39'),(2762,'1','308',1,'Retail Sale Id 2916',0.00,2944.00,736.00,2944.00,0.00,'2023-02-23 09:44:08'),(2763,'1','308',1,'Retail Sale Id 2917',0.00,1501.44,736.00,1501.44,0.00,'2023-02-23 09:49:23'),(2764,'1','308',1,'Retail Sale Id 2918',0.00,1501.44,736.00,1501.44,0.00,'2023-02-23 09:55:35'),(2765,'1','308',1,'Retail Sale Id 2919',0.00,1000.96,736.00,1000.96,0.00,'2023-02-23 10:05:25'),(2766,'1','308',1,'Retail Sale Id 2920',0.00,2502.40,736.00,2502.40,0.00,'2023-02-23 10:09:55'),(2767,'1','308',1,'Retail Sale Id 2922',0.00,2208.00,736.00,2208.00,0.00,'2023-02-23 10:13:58'),(2768,'1','308',1,'Retail Sale Id 2923',0.00,7360.00,736.00,7360.00,0.00,'2023-02-23 10:28:18'),(2769,'1','308',1,'Retail Sale Id 2924',0.00,4416.00,736.00,4416.00,0.00,'2023-02-23 10:31:08'),(2770,'1','308',1,'Retail Sale Id 2925',0.00,5888.00,736.00,5888.00,0.00,'2023-02-23 10:31:47'),(2771,'1','308',1,'Retail Sale Id 2926',0.00,85376.00,680.00,78880.00,-6496.00,'2023-02-23 10:35:37'),(2772,'1','308',1,'Retail Sale Id 2927',0.00,750.72,736.00,750.72,0.00,'2023-02-23 10:38:19'),(2773,'1','308',1,'Retail Sale Id 2928',0.00,1398.40,736.00,1398.40,0.00,'2023-02-23 10:56:05'),(2774,'1','308',1,'Retail Sale Id 2929',0.00,2944.00,736.00,2944.00,0.00,'2023-02-23 10:58:00'),(2775,'1','308',1,'Retail Sale Id 2930',0.00,9200.00,736.00,9200.00,0.00,'2023-02-23 11:03:37'),(2776,'1','308',1,'Retail Sale Id 2931',0.00,2208.00,736.00,2208.00,0.00,'2023-02-23 11:18:49'),(2777,'1','308',1,'Retail Sale Id 2932',0.00,3680.00,736.00,3680.00,0.00,'2023-02-23 11:21:33'),(2778,'1','308',1,'Retail Sale Id 2933',0.00,750.72,736.00,750.72,0.00,'2023-02-23 11:29:46'),(2779,'1','308',1,'Retail Sale Id 2934',0.00,1000.96,736.00,1000.96,0.00,'2023-02-23 11:32:37'),(2780,'1','308',1,'Retail Sale Id 2935',0.00,1501.44,736.00,1501.44,0.00,'2023-02-23 11:33:20'),(2781,'1','308',1,'Retail Sale Id 2936',0.00,3702.08,736.00,3702.08,0.00,'2023-02-23 11:36:42'),(2782,'1','308',1,'Retail Sale Id 2937',0.00,3702.08,736.00,3702.08,0.00,'2023-02-23 11:44:02'),(2783,'1','308',1,'Retail Sale Id 2938',0.00,3680.00,736.00,3680.00,0.00,'2023-02-23 12:25:25'),(2784,'1','308',1,'Retail Sale Id 2939',0.00,2208.00,736.00,2208.00,0.00,'2023-02-23 12:28:03'),(2785,'1','308',1,'Retail Sale Id 2940',0.00,3002.88,736.00,3002.88,0.00,'2023-02-23 12:38:42'),(2786,'1','308',1,'Retail Sale Id 2941',0.00,802.24,736.00,802.24,0.00,'2023-02-23 12:43:04'),(2787,'1','308',1,'Retail Sale Id 2942',0.00,2944.00,736.00,2944.00,0.00,'2023-02-23 13:27:23'),(2788,'1','308',1,'Retail Sale Id 2943',0.00,1472.00,736.00,1472.00,0.00,'2023-02-23 13:29:28'),(2789,'1','308',1,'Retail Sale Id 2944',0.00,3996.48,736.00,3996.48,0.00,'2023-02-23 13:34:03'),(2790,'1','308',1,'Retail Sale Id 2945',0.00,3002.88,736.00,3002.88,0.00,'2023-02-23 13:34:49'),(2791,'1','308',1,'Retail Sale Id 2946',0.00,3002.88,736.00,3002.88,0.00,'2023-02-23 13:36:13'),(2792,'1','308',1,'Retail Sale Id 2947',0.00,4416.00,736.00,4416.00,0.00,'2023-02-23 13:41:44'),(2793,'1','308',1,'Retail Sale Id 2948',0.00,3702.08,736.00,3702.08,0.00,'2023-02-23 13:43:04'),(2794,'1','308',1,'Retail Sale Id 2949',0.00,2208.00,736.00,2208.00,0.00,'2023-02-23 13:44:48'),(2795,'1','308',1,'Retail Sale Id 2950',0.00,7360.00,736.00,7360.00,0.00,'2023-02-23 14:08:12'),(2796,'1','308',1,'Retail Sale Id 2951',0.00,3680.00,736.00,3680.00,0.00,'2023-02-23 14:17:46'),(2797,'1','308',1,'Retail Sale Id 2952',0.00,5888.00,736.00,5888.00,0.00,'2023-02-23 14:19:48'),(2798,'1','308',1,'Retail Sale Id 2953',0.00,2944.00,736.00,2944.00,0.00,'2023-02-23 15:08:10'),(2799,'1','308',1,'Retail Sale Id 2954',0.00,3680.00,736.00,3680.00,0.00,'2023-02-23 15:16:37'),(2800,'1','308',1,'Retail Sale Id 2955',0.00,1472.00,736.00,1472.00,0.00,'2023-02-23 15:21:21'),(2801,'1','308',1,'Retail Sale Id 2957',0.00,2208.00,736.00,2208.00,0.00,'2023-02-23 15:24:30'),(2802,'1','308',1,'Retail Sale Id 2958',0.00,9200.00,736.00,9200.00,0.00,'2023-02-23 15:25:29'),(2803,'1','308',1,'Retail Sale Id 2959',0.00,2208.00,736.00,2208.00,0.00,'2023-02-23 15:29:16'),(2804,'1','308',1,'Retail Sale Id 2960',0.00,2208.00,736.00,2208.00,0.00,'2023-02-23 15:36:40'),(2805,'1','308',1,'Retail Sale Id 2961',0.00,2944.00,736.00,2944.00,0.00,'2023-02-23 15:41:22'),(2806,'1','308',1,'Retail Sale Id 2962',0.00,2944.00,736.00,2944.00,0.00,'2023-02-23 15:56:55'),(2807,'1','308',1,'Retail Sale Id 2963',0.00,1501.44,736.00,1501.44,0.00,'2023-02-23 16:21:54'),(2808,'1','308',1,'Retail Sale Id 2964',0.00,750.72,736.00,750.72,0.00,'2023-02-23 16:24:34'),(2809,'1','308',1,'Retail Sale Id 2965',0.00,3680.00,736.00,3680.00,0.00,'2023-02-23 17:10:04'),(2810,'1','308',1,'Retail Sale Id 2966',0.00,4416.00,736.00,4416.00,0.00,'2023-02-23 17:11:50'),(2811,'1','308',1,'Retail Sale Id 2967',0.00,2208.00,736.00,2208.00,0.00,'2023-02-23 17:13:11'),(2812,'1','308',1,'Retail Sale Id 2968',0.00,1472.00,736.00,1472.00,0.00,'2023-02-23 17:14:49'),(2813,'1','308',1,'Retail Sale Id 2969',0.00,2944.00,736.00,2944.00,0.00,'2023-02-23 17:34:21'),(2814,'1','308',1,'Retail Sale Id 2970',0.00,2208.00,736.00,2208.00,0.00,'2023-02-23 17:45:49'),(2815,'1','308',1,'Retail Sale Id 2971',0.00,2502.40,736.00,2502.40,0.00,'2023-02-23 17:53:42'),(2816,'1','308',1,'Retail Sale Id 2972',0.00,2200.64,736.00,2200.64,0.00,'2023-02-23 17:55:12'),(2817,'1','308',1,'Retail Sale Id 2973',0.00,7360.00,680.00,6800.00,-560.00,'2023-02-23 18:05:15'),(2818,'1','308',1,'Retail Sale Id 2974',0.00,1501.44,736.00,1501.44,0.00,'2023-02-23 18:22:06'),(2819,'1','308',1,'Return of Retail Sale Id 2971',2502.40,0.00,736.00,-2502.40,0.00,'2023-02-23 18:26:04'),(2820,'1','308',1,'Retail Sale Id 2975',0.00,2252.16,736.00,2252.16,0.00,'2023-02-23 18:29:44'),(2821,'1','308',1,'Retail Sale Id 2976',0.00,44.16,736.00,44.16,0.00,'2023-02-23 18:49:12'),(2822,'1','308',1,'Retail Sale Id 2977',0.00,9200.00,736.00,9200.00,0.00,'2023-02-24 07:32:04'),(2823,'1','308',1,'Retail Sale Id 2978',0.00,1472.00,736.00,1472.00,0.00,'2023-02-24 07:33:45'),(2824,'1','308',1,'Retail Sale Id 2979',0.00,2208.00,736.00,2208.00,0.00,'2023-02-24 07:35:17'),(2825,'1','308',1,'Retail Sale Id 2980',0.00,1472.00,736.00,1472.00,0.00,'2023-02-24 07:36:44'),(2826,'1','308',1,'Retail Sale Id 2981',0.00,2208.00,736.00,2208.00,0.00,'2023-02-24 07:38:25'),(2827,'1','308',1,'Retail Sale Id 2982',0.00,9200.00,736.00,9200.00,0.00,'2023-02-24 07:46:21'),(2828,'1','308',1,'Retail Sale Id 2983',0.00,4416.00,736.00,4416.00,0.00,'2023-02-24 07:56:04'),(2829,'1','308',1,'Retail Sale Id 2984',0.00,9200.00,736.00,9200.00,0.00,'2023-02-24 07:58:03'),(2830,'1','308',1,'Retail Sale Id 2985',0.00,2208.00,736.00,2208.00,0.00,'2023-02-24 07:59:50'),(2831,'1','308',1,'Retail Sale Id 2986',0.00,22080.00,680.00,20400.00,-1680.00,'2023-02-24 08:06:27'),(2832,'1','308',1,'Retail Sale Id 2987',0.00,750.72,736.00,750.72,0.00,'2023-02-24 08:09:57'),(2833,'1','308',1,'Retail Sale Id 2988',0.00,2944.00,736.00,2944.00,0.00,'2023-02-24 08:27:11'),(2834,'1','308',1,'Retail Sale Id 2989',0.00,2208.00,736.00,2208.00,0.00,'2023-02-24 08:43:29'),(2835,'1','308',1,'Retail Sale Id 2990',0.00,1472.00,736.00,1472.00,0.00,'2023-02-24 08:45:03'),(2836,'1','308',1,'Retail Sale Id 2991',0.00,8832.00,736.00,8832.00,0.00,'2023-02-24 08:46:50'),(2837,'1','308',1,'Retail Sale Id 2992',0.00,2944.00,736.00,2944.00,0.00,'2023-02-24 08:49:03'),(2838,'1','308',1,'Retail Sale Id 2993',0.00,4416.00,736.00,4416.00,0.00,'2023-02-24 08:51:50'),(2839,'1','308',1,'Retail Sale Id 2994',0.00,73600.00,680.00,68000.00,-5600.00,'2023-02-24 08:58:20'),(2840,'1','308',1,'Retail Sale Id 2995',0.00,1472.00,736.00,1472.00,0.00,'2023-02-24 08:59:50'),(2841,'1','308',1,'Retail Sale Id 2996',0.00,2208.00,736.00,2208.00,0.00,'2023-02-24 09:09:29'),(2842,'1','308',1,'Retail Sale Id 2997',0.00,2208.00,736.00,2208.00,0.00,'2023-02-24 09:16:21'),(2843,'1','308',1,'Retail Sale Id 2998',0.00,4416.00,736.00,4416.00,0.00,'2023-02-24 09:22:24'),(2844,'1','308',1,'Retail Sale Id 2999',0.00,9200.00,736.00,9200.00,0.00,'2023-02-24 09:24:15'),(2845,'1','308',1,'Retail Sale Id 3000',0.00,2208.00,736.00,2208.00,0.00,'2023-02-24 09:26:13'),(2846,'1','308',1,'Retail Sale Id 3001',0.00,3002.88,736.00,3002.88,0.00,'2023-02-24 09:27:35'),(2847,'1','308',1,'Retail Sale Id 3002',0.00,2944.00,736.00,2944.00,0.00,'2023-02-24 09:29:54'),(2848,'1','308',1,'Retail Sale Id 3003',0.00,2944.00,736.00,2944.00,0.00,'2023-02-24 09:31:32'),(2849,'1','308',1,'Retail Sale Id 3005',0.00,1501.44,736.00,1501.44,0.00,'2023-02-24 09:36:39'),(2850,'1','308',1,'Retail Sale Id 3006',0.00,2208.00,736.00,2208.00,0.00,'2023-02-24 09:43:07'),(2851,'1','308',1,'Retail Sale Id 3007',0.00,2208.00,736.00,2208.00,0.00,'2023-02-24 09:46:06'),(2852,'1','308',1,'Retail Sale Id 3008',0.00,3680.00,736.00,3680.00,0.00,'2023-02-24 09:49:50'),(2853,'1','308',1,'Retail Sale Id 3009',0.00,1472.00,736.00,1472.00,0.00,'2023-02-24 09:52:20'),(2854,'1','308',1,'Retail Sale Id 3010',0.00,1472.00,736.00,1472.00,0.00,'2023-02-24 09:54:34'),(2855,'1','308',1,'Retail Sale Id 3011',0.00,4416.00,736.00,4416.00,0.00,'2023-02-24 09:59:59'),(2856,'1','308',1,'Retail Sale Id 3012',0.00,2951.36,736.00,2951.36,0.00,'2023-02-24 10:04:32'),(2857,'1','308',1,'Retail Sale Id 3013',0.00,7360.00,736.00,7360.00,0.00,'2023-02-24 10:14:12'),(2858,'1','308',1,'Retail Sale Id 3014',0.00,3680.00,736.00,3680.00,0.00,'2023-02-24 10:17:43'),(2859,'1','308',1,'Retail Sale Id 3015',0.00,1472.00,736.00,1472.00,0.00,'2023-02-24 10:21:27'),(2860,'1','308',1,'Retail Sale Id 3016',0.00,4416.00,736.00,4416.00,0.00,'2023-02-24 10:23:43'),(2861,'1','308',1,'Retail Sale Id 3017',0.00,3680.00,736.00,3680.00,0.00,'2023-02-24 10:29:18'),(2862,'1','308',1,'Retail Sale Id 3018',0.00,2208.00,736.00,2208.00,0.00,'2023-02-24 10:33:37'),(2863,'1','308',1,'Retail Sale Id 3019',0.00,1501.44,736.00,1501.44,0.00,'2023-02-24 10:48:05'),(2864,'1','308',1,'Retail Sale Id 3020',0.00,4416.00,736.00,4416.00,0.00,'2023-02-24 10:50:18'),(2865,'1','308',1,'Retail Sale Id 3021',0.00,2944.00,736.00,2944.00,0.00,'2023-02-24 10:53:00'),(2866,'1','308',1,'Retail Sale Id 3022',0.00,4416.00,736.00,4416.00,0.00,'2023-02-24 10:54:42'),(2867,'1','308',1,'Retail Sale Id 3023',0.00,4416.00,736.00,4416.00,0.00,'2023-02-24 10:57:35'),(2868,'1','308',1,'Retail Sale Id 3024',0.00,4416.00,736.00,4416.00,0.00,'2023-02-24 11:01:57'),(2869,'1','308',1,'Retail Sale Id 3025',0.00,9200.00,736.00,9200.00,0.00,'2023-02-24 11:08:58'),(2870,'1','308',1,'Retail Sale Id 3026',0.00,2944.00,736.00,2944.00,0.00,'2023-02-24 11:10:32'),(2871,'1','308',1,'Retail Sale Id 3027',0.00,3996.48,736.00,3996.48,0.00,'2023-02-24 11:34:07'),(2872,'1','308',1,'Retail Sale Id 3028',0.00,3680.00,736.00,3680.00,0.00,'2023-02-24 11:35:57'),(2873,'1','308',1,'Retail Sale Id 3029',0.00,1472.00,736.00,1472.00,0.00,'2023-02-24 11:38:38'),(2874,'1','308',1,'Retail Sale Id 3030',0.00,4416.00,736.00,4416.00,0.00,'2023-02-24 11:42:25'),(2875,'1','308',1,'Retail Sale Id 3031',0.00,3002.88,736.00,3002.88,0.00,'2023-02-24 11:48:42'),(2876,'1','308',1,'Retail Sale Id 3032',0.00,2502.40,736.00,2502.40,0.00,'2023-02-24 11:50:50'),(2877,'1','308',1,'Retail Sale Id 3033',0.00,2208.00,736.00,2208.00,0.00,'2023-02-24 12:06:44'),(2878,'1','308',1,'Retail Sale Id 3034',0.00,4452.80,736.00,4452.80,0.00,'2023-02-24 12:34:16'),(2879,'1','308',1,'Retail Sale Id 3035',0.00,4416.00,736.00,4416.00,0.00,'2023-02-24 12:44:27'),(2880,'1','308',1,'Retail Sale Id 3036',0.00,4416.00,736.00,4416.00,0.00,'2023-02-24 12:47:03'),(2881,'1','308',1,'Retail Sale Id 3037',0.00,3680.00,736.00,3680.00,0.00,'2023-02-24 12:49:08'),(2882,'1','308',1,'Retail Sale Id 3038',0.00,3680.00,736.00,3680.00,0.00,'2023-02-24 13:07:49'),(2883,'1','308',1,'Retail Sale Id 3039',0.00,2208.00,736.00,2208.00,0.00,'2023-02-24 13:10:23'),(2884,'1','308',1,'Retail Sale Id 3040',0.00,2944.00,736.00,2944.00,0.00,'2023-02-24 13:11:55'),(2885,'1','308',1,'Retail Sale Id 3041',0.00,1472.00,736.00,1472.00,0.00,'2023-02-24 13:13:28'),(2886,'1','308',1,'Retail Sale Id 3042',0.00,3680.00,736.00,3680.00,0.00,'2023-02-24 13:15:10'),(2887,'1','308',1,'Retail Sale Id 3043',0.00,4416.00,736.00,4416.00,0.00,'2023-02-24 13:16:16'),(2888,'1','308',1,'Retail Sale Id 3044',0.00,2944.00,736.00,2944.00,0.00,'2023-02-24 13:22:13'),(2889,'1','308',1,'Retail Sale Id 3045',0.00,2208.00,736.00,2208.00,0.00,'2023-02-24 13:34:00'),(2890,'1','308',1,'Retail Sale Id 3046',0.00,2944.00,736.00,2944.00,0.00,'2023-02-24 13:51:06'),(2891,'1','308',1,'Retail Sale Id 3047',0.00,3680.00,736.00,3680.00,0.00,'2023-02-24 14:12:04'),(2892,'1','308',1,'Retail Sale Id 3048',0.00,2944.00,736.00,2944.00,0.00,'2023-02-24 14:17:44'),(2893,'1','308',1,'Retail Sale Id 3049',0.00,1501.44,736.00,1501.44,0.00,'2023-02-24 14:21:24'),(2894,'1','308',1,'Retail Sale Id 3050',0.00,750.72,736.00,750.72,0.00,'2023-02-24 15:08:17'),(2895,'1','308',1,'Retail Sale Id 3051',0.00,1501.44,736.00,1501.44,0.00,'2023-02-24 15:11:35'),(2896,'1','308',1,'Retail Sale Id 3052',0.00,7360.00,736.00,7360.00,0.00,'2023-02-24 15:28:13'),(2897,'1','308',1,'Retail Sale Id 3053',0.00,3680.00,736.00,3680.00,0.00,'2023-02-24 15:45:46'),(2898,'1','308',1,'Retail Sale Id 3054',0.00,1104.00,736.00,1104.00,0.00,'2023-02-24 15:54:14'),(2899,'1','308',1,'Retail Sale Id 3055',0.00,18400.00,680.00,17000.00,-1400.00,'2023-02-24 16:04:25'),(2900,'1','308',1,'Retail Sale Id 3056',0.00,2208.00,736.00,2208.00,0.00,'2023-02-24 16:09:58'),(2901,'1','308',1,'Retail Sale Id 3057',0.00,7360.00,736.00,7360.00,0.00,'2023-02-24 16:12:05'),(2902,'1','308',1,'Retail Sale Id 3058',0.00,736.00,736.00,736.00,0.00,'2023-02-24 16:14:13'),(2903,'1','308',1,'Retail Sale Id 3059',0.00,2001.92,736.00,2001.92,0.00,'2023-02-24 16:17:03'),(2904,'1','308',1,'Retail Sale Id 3060',0.00,3002.88,736.00,3002.88,0.00,'2023-02-24 16:18:19'),(2905,'1','308',1,'Retail Sale Id 3061',0.00,4452.80,736.00,4452.80,0.00,'2023-02-24 16:57:10'),(2906,'1','308',1,'Retail Sale Id 3062',0.00,750.72,736.00,750.72,0.00,'2023-02-24 17:04:51'),(2907,'1','308',1,'Retail Sale Id 3063',0.00,4416.00,736.00,4416.00,0.00,'2023-02-24 17:27:14'),(2908,'1','308',1,'Retail Sale Id 3064',0.00,5152.00,736.00,5152.00,0.00,'2023-02-24 17:32:49'),(2909,'1','308',1,'Retail Sale Id 3065',0.00,750.72,736.00,750.72,0.00,'2023-02-24 17:53:24'),(2910,'1','308',1,'Retail Sale Id 3066',0.00,1501.44,736.00,1501.44,0.00,'2023-02-24 18:04:07'),(2911,'1','308',1,'Retail Sale Id 3067',0.00,750.72,736.00,750.72,0.00,'2023-02-24 18:17:22'),(2912,'1','308',1,'Retail Sale Id 3068',0.00,1501.44,736.00,1501.44,0.00,'2023-02-24 18:20:41'),(2913,'1','308',1,'Retail Sale Id 3069',0.00,2208.00,736.00,2208.00,0.00,'2023-02-24 18:25:27'),(2914,'1','308',1,'Retail Sale Id 3070',0.00,17664.00,680.00,16320.00,-1344.00,'2023-02-24 18:26:28'),(2915,'1','308',1,'Retail Sale Id 3071',0.00,4416.00,736.00,4416.00,0.00,'2023-02-24 18:29:30'),(2916,'1','308',1,'Retail Sale Id 3072',0.00,1000.96,736.00,1000.96,0.00,'2023-02-24 18:37:49'),(2917,'1','308',1,'Retail Sale Id 3073',0.00,750.72,736.00,750.72,0.00,'2023-02-24 18:38:48'),(2918,'1','308',1,'Retail Sale Id 3074',0.00,9950.72,736.00,9950.72,0.00,'2023-02-24 18:50:45'),(2919,'1','308',1,'Retail Sale Id 3075',0.00,3680.00,736.00,3680.00,0.00,'2023-02-24 18:55:51'),(2920,'1','308',1,'Retail Sale Id 3076',0.00,9200.00,736.00,9200.00,0.00,'2023-02-24 18:57:18'),(2921,'1','308',1,'Retail Sale Id 3077',0.00,51.52,736.00,51.52,0.00,'2023-02-24 19:37:17'),(2922,'1','308',1,'Retail Sale Id 3078',0.00,4416.00,736.00,4416.00,0.00,'2023-02-26 07:34:41'),(2923,'1','308',1,'Retail Sale Id 3079',0.00,2208.00,736.00,2208.00,0.00,'2023-02-26 07:44:37'),(2924,'1','308',1,'Retail Sale Id 3080',0.00,4416.00,736.00,4416.00,0.00,'2023-02-26 07:49:20'),(2925,'1','308',1,'Retail Sale Id 3081',0.00,1472.00,736.00,1472.00,0.00,'2023-02-26 07:53:11'),(2926,'1','308',1,'Retail Sale Id 3082',0.00,3680.00,736.00,3680.00,0.00,'2023-02-26 07:55:17'),(2927,'1','308',1,'Retail Sale Id 3083',0.00,736.00,736.00,736.00,0.00,'2023-02-26 08:03:36'),(2928,'1','308',1,'Retail Sale Id 3084',0.00,3002.88,736.00,3002.88,0.00,'2023-02-26 08:17:30'),(2929,'1','308',1,'Retail Sale Id 3085',0.00,2208.00,736.00,2208.00,0.00,'2023-02-26 08:18:31'),(2930,'1','308',1,'Retail Sale Id 3086',0.00,2208.00,736.00,2208.00,0.00,'2023-02-26 08:28:10'),(2931,'1','308',1,'Retail Sale Id 3087',0.00,3680.00,736.00,3680.00,0.00,'2023-02-26 08:33:59'),(2932,'1','308',1,'Retail Sale Id 3088',0.00,1501.44,736.00,1501.44,0.00,'2023-02-26 08:36:25'),(2933,'1','308',1,'Retail Sale Id 3089',0.00,4416.00,736.00,4416.00,0.00,'2023-02-26 08:38:13'),(2934,'1','308',1,'Retail Sale Id 3090',0.00,2944.00,736.00,2944.00,0.00,'2023-02-26 08:46:48'),(2935,'1','308',1,'Retail Sale Id 3091',0.00,2208.00,736.00,2208.00,0.00,'2023-02-26 08:58:48'),(2936,'1','308',1,'Retail Sale Id 3092',0.00,2208.00,736.00,2208.00,0.00,'2023-02-26 09:00:59'),(2937,'1','308',1,'Retail Sale Id 3093',0.00,2944.00,736.00,2944.00,0.00,'2023-02-26 09:12:50'),(2938,'1','308',1,'Retail Sale Id 3094',0.00,9200.00,736.00,9200.00,0.00,'2023-02-26 09:14:14'),(2939,'1','308',1,'Retail Sale Id 3095',0.00,1472.00,736.00,1472.00,0.00,'2023-02-26 09:42:08'),(2940,'1','308',1,'Retail Sale Id 3096',0.00,2944.00,736.00,2944.00,0.00,'2023-02-26 09:44:59'),(2941,'1','308',1,'Retail Sale Id 3097',0.00,3680.00,736.00,3680.00,0.00,'2023-02-26 10:03:46'),(2942,'1','308',1,'Retail Sale Id 3098',0.00,2001.92,736.00,2001.92,0.00,'2023-02-26 10:05:42'),(2943,'1','308',1,'Retail Sale Id 3099',0.00,500.48,736.00,500.48,0.00,'2023-02-26 10:08:03'),(2944,'1','308',1,'Retail Sale Id 3100',0.00,3680.00,736.00,3680.00,0.00,'2023-02-26 10:10:37'),(2945,'1','308',1,'Retail Sale Id 3101',0.00,4416.00,736.00,4416.00,0.00,'2023-02-26 10:15:01'),(2946,'1','308',1,'Retail Sale Id 3102',0.00,1501.44,736.00,1501.44,0.00,'2023-02-26 10:16:34'),(2947,'1','308',1,'Retail Sale Id 3103',0.00,2208.00,736.00,2208.00,0.00,'2023-02-26 10:17:58'),(2948,'1','308',1,'Retail Sale Id 3104',0.00,1501.44,736.00,1501.44,0.00,'2023-02-26 10:19:09'),(2949,'1','308',1,'Retail Sale Id 3106',0.00,2208.00,736.00,2208.00,0.00,'2023-02-26 10:49:47'),(2950,'1','308',1,'Retail Sale Id 3107',0.00,2001.92,736.00,2001.92,0.00,'2023-02-26 10:56:11'),(2951,'1','308',1,'Retail Sale Id 3108',0.00,2208.00,736.00,2208.00,0.00,'2023-02-26 10:59:38'),(2952,'1','308',1,'Retail Sale Id 3109',0.00,1472.00,736.00,1472.00,0.00,'2023-02-26 11:05:17'),(2953,'1','308',1,'Retail Sale Id 3110',0.00,2208.00,736.00,2208.00,0.00,'2023-02-26 11:13:34'),(2954,'1','308',1,'Retail Sale Id 3111',0.00,2208.00,736.00,2208.00,0.00,'2023-02-26 11:17:50'),(2955,'1','308',1,'Retail Sale Id 3112',0.00,750.72,736.00,750.72,0.00,'2023-02-26 11:27:27'),(2956,'1','308',1,'Retail Sale Id 3113',0.00,33120.00,680.00,30600.00,-2520.00,'2023-02-26 11:31:42'),(2957,'1','308',1,'Retail Sale Id 3114',0.00,2944.00,736.00,2944.00,0.00,'2023-02-26 11:33:46'),(2958,'1','308',1,'Retail Sale Id 3115',0.00,2208.00,736.00,2208.00,0.00,'2023-02-26 11:35:29'),(2959,'1','308',1,'Return of Retail Sale Id 3112',750.72,0.00,736.00,-750.72,0.00,'2023-02-26 11:55:18'),(2960,'1','308',1,'Retail Sale Id 3118',0.00,1398.40,736.00,1398.40,0.00,'2023-02-26 11:57:39'),(2961,'1','308',1,'Retail Sale Id 3120',0.00,1472.00,736.00,1472.00,0.00,'2023-02-26 12:13:42'),(2962,'1','308',1,'Retail Sale Id 3121',0.00,1000.96,736.00,1000.96,0.00,'2023-02-26 12:39:49'),(2963,'1','308',1,'Retail Sale Id 3122',0.00,743.36,736.00,743.36,0.00,'2023-02-26 13:05:39'),(2964,'1','308',1,'Retail Sale Id 3123',0.00,1501.44,736.00,1501.44,0.00,'2023-02-26 14:56:17'),(2965,'1','308',1,'Retail Sale Id 3124',0.00,3503.36,736.00,3503.36,0.00,'2023-02-26 15:48:56'),(2966,'1','308',1,'Retail Sale Id 3125',0.00,802.24,736.00,802.24,0.00,'2023-02-26 16:29:33'),(2967,'1','308',1,'Retail Sale Id 3126',0.00,750.72,736.00,750.72,0.00,'2023-02-26 16:33:18'),(2968,'1','308',1,'Retail Sale Id 3127',0.00,1501.44,736.00,1501.44,0.00,'2023-02-26 17:42:22'),(2969,'1','308',1,'Retail Sale Id 3128',0.00,750.72,736.00,750.72,0.00,'2023-02-26 17:45:39'),(2970,'1','308',1,'Retail Sale Id 3129',0.00,1501.44,736.00,1501.44,0.00,'2023-02-26 17:54:55'),(2971,'1','308',1,'Retail Sale Id 3130',0.00,7360.00,680.00,6800.00,-560.00,'2023-02-26 17:57:05'),(2972,'1','308',1,'Retail Sale Id 3131',0.00,500.48,736.00,500.48,0.00,'2023-02-26 17:57:36'),(2973,'1','308',1,'Retail Sale Id 3132',0.00,610.88,736.00,610.88,0.00,'2023-02-26 19:12:59'),(2974,'1','308',1,'Retail Sale Id 3133',0.00,7360.00,736.00,7360.00,0.00,'2023-02-27 07:38:31'),(2975,'1','308',1,'Retail Sale Id 3134',0.00,1501.44,736.00,1501.44,0.00,'2023-02-27 07:41:37'),(2976,'1','308',1,'Retail Sale Id 3135',0.00,1501.44,736.00,1501.44,0.00,'2023-02-27 08:18:02'),(2977,'1','308',1,'Retail Sale Id 3136',0.00,3680.00,736.00,3680.00,0.00,'2023-02-27 08:27:48'),(2978,'1','308',1,'Retail Sale Id 3137',0.00,22080.00,680.00,20400.00,-1680.00,'2023-02-27 08:35:51'),(2979,'1','308',1,'Retail Sale Id 3138',0.00,2208.00,736.00,2208.00,0.00,'2023-02-27 08:37:43'),(2980,'1','308',1,'Retail Sale Id 3139',0.00,736.00,736.00,736.00,0.00,'2023-02-27 08:48:48'),(2981,'1','308',1,'Retail Sale Id 3140',0.00,2944.00,736.00,2944.00,0.00,'2023-02-27 08:50:34'),(2982,'1','308',1,'Retail Sale Id 3141',0.00,4416.00,736.00,4416.00,0.00,'2023-02-27 08:52:24'),(2983,'1','308',1,'Retail Sale Id 3142',0.00,2208.00,736.00,2208.00,0.00,'2023-02-27 09:01:45'),(2984,'1','308',1,'Retail Sale Id 3143',0.00,4416.00,736.00,4416.00,0.00,'2023-02-27 09:16:16'),(2985,'1','308',1,'Retail Sale Id 3144',0.00,1000.96,736.00,1000.96,0.00,'2023-02-27 09:26:17'),(2986,'1','308',1,'Retail Sale Id 3145',0.00,736.00,736.00,736.00,0.00,'2023-02-27 09:32:32'),(2987,'1','308',1,'Retail Sale Id 3146',0.00,2208.00,736.00,2208.00,0.00,'2023-02-27 09:33:47'),(2988,'1','308',1,'Retail Sale Id 3147',0.00,3680.00,736.00,3680.00,0.00,'2023-02-27 09:42:16'),(2989,'1','308',1,'Retail Sale Id 3148',0.00,1501.44,736.00,1501.44,0.00,'2023-02-27 09:44:43'),(2990,'1','308',1,'Retail Sale Id 3149',0.00,2208.00,736.00,2208.00,0.00,'2023-02-27 09:48:09'),(2991,'1','308',1,'Retail Sale Id 3150',0.00,2001.92,736.00,2001.92,0.00,'2023-02-27 09:52:53'),(2992,'1','308',1,'Retail Sale Id 3151',0.00,3680.00,736.00,3680.00,0.00,'2023-02-27 10:12:50'),(2993,'1','308',1,'Retail Sale Id 3152',0.00,2208.00,736.00,2208.00,0.00,'2023-02-27 10:19:44'),(2994,'1','308',1,'Retail Sale Id 3153',0.00,4416.00,736.00,4416.00,0.00,'2023-02-27 10:26:50'),(2995,'1','308',1,'Retail Sale Id 3154',0.00,9200.00,736.00,9200.00,0.00,'2023-02-27 10:29:40'),(2996,'1','308',1,'Retail Sale Id 3156',0.00,4452.80,736.00,4452.80,0.00,'2023-02-27 10:47:47'),(2997,'1','308',1,'Retail Sale Id 3157',0.00,1472.00,736.00,1472.00,0.00,'2023-02-27 11:20:15'),(2998,'1','308',1,'Retail Sale Id 3158',0.00,18400.00,680.00,17000.00,-1400.00,'2023-02-27 11:31:42'),(2999,'1','308',1,'Retail Sale Id 3159',0.00,2208.00,736.00,2208.00,0.00,'2023-02-27 11:51:10'),(3000,'1','308',1,'Retail Sale Id 3160',0.00,1472.00,736.00,1472.00,0.00,'2023-02-27 12:24:32'),(3001,'1','308',1,'Retail Sale Id 3161',0.00,3680.00,736.00,3680.00,0.00,'2023-02-27 12:31:08'),(3002,'1','308',1,'Retail Sale Id 3162',0.00,1472.00,736.00,1472.00,0.00,'2023-02-27 12:40:49'),(3003,'1','308',1,'Retail Sale Id 3163',0.00,3680.00,736.00,3680.00,0.00,'2023-02-27 12:46:55'),(3004,'1','308',1,'Retail Sale Id 3164',0.00,4997.44,736.00,4997.44,0.00,'2023-02-27 14:58:06'),(3005,'1','308',1,'Retail Sale Id 3165',0.00,6624.00,736.00,6624.00,0.00,'2023-02-27 14:59:19'),(3006,'1','308',1,'Retail Sale Id 3166',0.00,3680.00,736.00,3680.00,0.00,'2023-02-27 15:07:09'),(3007,'1','308',1,'Retail Sale Id 3167',0.00,2208.00,736.00,2208.00,0.00,'2023-02-27 15:20:43'),(3008,'1','308',1,'Retail Sale Id 3168',0.00,9200.00,736.00,9200.00,0.00,'2023-02-27 15:35:44'),(3009,'1','308',1,'Retail Sale Id 3169',0.00,9200.00,736.00,9200.00,0.00,'2023-02-27 15:37:05'),(3010,'1','308',1,'Retail Sale Id 3170',0.00,2944.00,736.00,2944.00,0.00,'2023-02-27 15:38:17'),(3011,'1','308',1,'Retail Sale Id 3171',0.00,1501.44,736.00,1501.44,0.00,'2023-02-27 15:42:54'),(3012,'1','308',1,'Retail Sale Id 3172',0.00,750.72,736.00,750.72,0.00,'2023-02-27 15:43:55'),(3013,'1','308',1,'Retail Sale Id 3173',0.00,2001.92,736.00,2001.92,0.00,'2023-02-27 15:58:39'),(3014,'1','308',1,'Retail Sale Id 3174',0.00,1501.44,736.00,1501.44,0.00,'2023-02-27 16:22:02'),(3015,'1','308',1,'Retail Sale Id 3175',0.00,2208.00,736.00,2208.00,0.00,'2023-02-27 16:24:53'),(3016,'1','308',1,'Retail Sale Id 3176',0.00,3680.00,736.00,3680.00,0.00,'2023-02-27 16:29:21'),(3017,'1','308',1,'Retail Sale Id 3177',0.00,4416.00,736.00,4416.00,0.00,'2023-02-27 16:32:56'),(3018,'1','308',1,'Retail Sale Id 3178',0.00,2208.00,736.00,2208.00,0.00,'2023-02-27 16:34:45'),(3019,'1','308',1,'Retail Sale Id 3179',0.00,1472.00,736.00,1472.00,0.00,'2023-02-27 16:37:54'),(3020,'1','308',1,'Retail Sale Id 3180',0.00,2944.00,736.00,2944.00,0.00,'2023-02-27 16:43:22'),(3021,'1','308',1,'Retail Sale Id 3181',0.00,2208.00,736.00,2208.00,0.00,'2023-02-27 16:46:22'),(3022,'1','308',1,'Retail Sale Id 3182',0.00,9200.00,736.00,9200.00,0.00,'2023-02-27 16:48:46'),(3023,'1','308',1,'Retail Sale Id 3183',0.00,4416.00,736.00,4416.00,0.00,'2023-02-27 17:21:22'),(3024,'1','308',1,'Retail Sale Id 3184',0.00,4416.00,736.00,4416.00,0.00,'2023-02-27 18:05:39'),(3025,'1','308',1,'Retail Sale Id 3185',0.00,2944.00,736.00,2944.00,0.00,'2023-02-27 18:29:54'),(3026,'1','308',1,'Retail Sale Id 3186',0.00,2944.00,736.00,2944.00,0.00,'2023-02-27 18:31:34'),(3027,'1','308',1,'Retail Sale Id 3187',0.00,14.72,736.00,14.72,0.00,'2023-02-27 19:18:57'),(3028,'1','308',1,'Retail Sale Id 3188',0.00,18400.00,680.00,17000.00,-1400.00,'2023-02-28 07:46:44'),(3029,'1','308',1,'Retail Sale Id 3189',0.00,3680.00,736.00,3680.00,0.00,'2023-02-28 07:48:37'),(3030,'1','308',1,'Retail Sale Id 3190',0.00,2208.00,736.00,2208.00,0.00,'2023-02-28 07:56:42'),(3031,'1','308',1,'Retail Sale Id 3191',0.00,5998.40,736.00,5998.40,0.00,'2023-02-28 08:00:49'),(3032,'1','308',1,'Retail Sale Id 3192',0.00,22080.00,680.00,20400.00,-1680.00,'2023-02-28 08:03:57'),(3033,'1','308',1,'Retail Sale Id 3193',0.00,5152.00,736.00,5152.00,0.00,'2023-02-28 08:05:43'),(3034,'1','308',1,'Retail Sale Id 3194',0.00,9200.00,736.00,9200.00,0.00,'2023-02-28 08:07:03'),(3035,'1','308',1,'Retail Sale Id 3195',0.00,750.72,736.00,750.72,0.00,'2023-02-28 08:08:39'),(3036,'1','308',1,'Retail Sale Id 3196',0.00,4416.00,736.00,4416.00,0.00,'2023-02-28 08:10:49'),(3037,'1','308',1,'Retail Sale Id 3197',0.00,736.00,736.00,736.00,0.00,'2023-02-28 08:12:29'),(3038,'1','308',1,'Retail Sale Id 3198',0.00,2208.00,736.00,2208.00,0.00,'2023-02-28 08:19:17'),(3039,'1','308',1,'Retail Sale Id 3199',0.00,7360.00,736.00,7360.00,0.00,'2023-02-28 08:43:55'),(3040,'1','308',1,'Retail Sale Id 3200',0.00,1472.00,736.00,1472.00,0.00,'2023-02-28 08:48:13'),(3041,'1','308',1,'Retail Sale Id 3201',0.00,4416.00,736.00,4416.00,0.00,'2023-02-28 08:50:43'),(3042,'1','308',1,'Retail Sale Id 3202',0.00,3680.00,736.00,3680.00,0.00,'2023-02-28 08:56:27'),(3043,'1','308',1,'Retail Sale Id 3203',0.00,4416.00,736.00,4416.00,0.00,'2023-02-28 09:07:15'),(3044,'1','308',1,'Retail Sale Id 3204',0.00,4416.00,736.00,4416.00,0.00,'2023-02-28 09:08:51'),(3045,'1','308',1,'Retail Sale Id 3205',0.00,7360.00,736.00,7360.00,0.00,'2023-02-28 09:10:18'),(3046,'1','308',1,'Retail Sale Id 3206',0.00,1000.96,736.00,1000.96,0.00,'2023-02-28 09:12:00'),(3047,'1','308',1,'Retail Sale Id 3207',0.00,4416.00,736.00,4416.00,0.00,'2023-02-28 09:13:37'),(3048,'1','308',1,'Retail Sale Id 3208',0.00,2208.00,736.00,2208.00,0.00,'2023-02-28 09:18:56'),(3049,'1','308',1,'Retail Sale Id 3209',0.00,1199.68,736.00,1199.68,0.00,'2023-02-28 09:23:23'),(3050,'1','308',1,'Retail Sale Id 3210',0.00,1096.64,736.00,1096.64,0.00,'2023-02-28 09:24:32'),(3051,'1','308',1,'Retail Sale Id 3211',0.00,1472.00,736.00,1472.00,0.00,'2023-02-28 09:51:25'),(3052,'1','308',1,'Retail Sale Id 3212',0.00,5888.00,736.00,5888.00,0.00,'2023-02-28 10:05:57'),(3053,'1','308',1,'Retail Sale Id 3213',0.00,3680.00,736.00,3680.00,0.00,'2023-02-28 10:09:20'),(3054,'1','308',1,'Retail Sale Id 3215',0.00,9200.00,736.00,9200.00,0.00,'2023-02-28 10:13:25'),(3055,'1','308',1,'Retail Sale Id 3216',0.00,3680.00,736.00,3680.00,0.00,'2023-02-28 10:15:15'),(3056,'1','308',1,'Retail Sale Id 3217',0.00,8464.00,736.00,8464.00,0.00,'2023-02-28 10:18:12'),(3057,'1','308',1,'Retail Sale Id 3218',0.00,7360.00,736.00,7360.00,0.00,'2023-02-28 10:23:48'),(3058,'1','308',1,'Retail Sale Id 3219',0.00,2208.00,736.00,2208.00,0.00,'2023-02-28 10:33:02'),(3059,'1','308',1,'Retail Sale Id 3220',0.00,1803.20,736.00,1803.20,0.00,'2023-02-28 11:15:19'),(3060,'1','308',1,'Retail Sale Id 3221',0.00,1501.44,736.00,1501.44,0.00,'2023-02-28 12:00:28'),(3061,'1','308',1,'Retail Sale Id 3222',0.00,128064.00,680.00,118320.00,-9744.00,'2023-02-28 12:06:36'),(3062,'1','308',1,'Retail Sale Id 3223',0.00,18400.00,680.00,17000.00,-1400.00,'2023-02-28 12:09:19'),(3063,'1','308',1,'Retail Sale Id 3224',0.00,2944.00,736.00,2944.00,0.00,'2023-02-28 12:13:43'),(3064,'1','308',1,'Retail Sale Id 3225',0.00,2001.92,736.00,2001.92,0.00,'2023-02-28 12:43:46'),(3065,'1','308',1,'Retail Sale Id 3226',0.00,3680.00,736.00,3680.00,0.00,'2023-02-28 12:55:04'),(3066,'1','308',1,'Retail Sale Id 3227',0.00,8832.00,736.00,8832.00,0.00,'2023-02-28 12:56:53'),(3067,'1','308',1,'Retail Sale Id 3228',0.00,2944.00,736.00,2944.00,0.00,'2023-02-28 13:00:44'),(3068,'1','308',1,'Retail Sale Id 3229',0.00,2944.00,736.00,2944.00,0.00,'2023-02-28 13:08:44'),(3069,'1','308',1,'Retail Sale Id 3230',0.00,1472.00,736.00,1472.00,0.00,'2023-02-28 13:17:10'),(3070,'1','308',1,'Retail Sale Id 3231',0.00,5888.00,736.00,5888.00,0.00,'2023-02-28 13:35:09'),(3071,'1','308',1,'Retail Sale Id 3232',0.00,2944.00,736.00,2944.00,0.00,'2023-02-28 13:37:35'),(3072,'1','308',1,'Retail Sale Id 3233',0.00,1000.96,736.00,1000.96,0.00,'2023-02-28 13:49:09'),(3073,'1','308',1,'Retail Sale Id 3234',0.00,2208.00,736.00,2208.00,0.00,'2023-02-28 13:51:09'),(3074,'1','308',1,'Retail Sale Id 3235',0.00,2944.00,736.00,2944.00,0.00,'2023-02-28 13:58:02'),(3075,'1','308',1,'Retail Sale Id 3236',0.00,7360.00,736.00,7360.00,0.00,'2023-02-28 14:01:41'),(3076,'1','308',1,'Retail Sale Id 3237',0.00,1000.96,736.00,1000.96,0.00,'2023-02-28 14:03:45'),(3077,'1','308',1,'Retail Sale Id 3238',0.00,4416.00,736.00,4416.00,0.00,'2023-02-28 14:17:45'),(3078,'1','308',1,'Retail Sale Id 3239',0.00,500.48,736.00,500.48,0.00,'2023-02-28 14:32:34'),(3079,'1','308',1,'Retail Sale Id 3241',0.00,2208.00,736.00,2208.00,0.00,'2023-02-28 14:53:37'),(3080,'1','308',1,'Retail Sale Id 3242',0.00,3680.00,736.00,3680.00,0.00,'2023-02-28 14:58:52'),(3081,'1','308',1,'Retail Sale Id 3243',0.00,9200.00,736.00,9200.00,0.00,'2023-02-28 15:01:10'),(3082,'1','308',1,'Retail Sale Id 3244',0.00,3680.00,736.00,3680.00,0.00,'2023-02-28 15:09:48'),(3083,'1','308',1,'Retail Sale Id 3245',0.00,2951.36,736.00,2951.36,0.00,'2023-02-28 15:40:58'),(3084,'1','308',1,'Retail Sale Id 3247',0.00,4416.00,736.00,4416.00,0.00,'2023-02-28 15:53:39'),(3085,'1','308',1,'Retail Sale Id 3248',0.00,1472.00,736.00,1472.00,0.00,'2023-02-28 16:14:47'),(3086,'1','308',1,'Retail Sale Id 3249',0.00,2208.00,736.00,2208.00,0.00,'2023-02-28 16:16:27'),(3087,'1','308',1,'Retail Sale Id 3250',0.00,2208.00,736.00,2208.00,0.00,'2023-02-28 16:19:54'),(3088,'1','308',1,'Retail Sale Id 3251',0.00,2944.00,736.00,2944.00,0.00,'2023-02-28 16:23:03'),(3089,'1','308',1,'Retail Sale Id 3252',0.00,1472.00,736.00,1472.00,0.00,'2023-02-28 16:48:34'),(3090,'1','308',1,'Retail Sale Id 3253',0.00,1472.00,736.00,1472.00,0.00,'2023-02-28 16:50:30'),(3091,'1','308',1,'Retail Sale Id 3255',0.00,2208.00,736.00,2208.00,0.00,'2023-02-28 17:17:56'),(3092,'1','308',1,'Retail Sale Id 3256',0.00,1472.00,736.00,1472.00,0.00,'2023-02-28 17:19:36'),(3093,'1','308',1,'Retail Sale Id 3257',0.00,4416.00,736.00,4416.00,0.00,'2023-02-28 17:21:21'),(3094,'1','308',1,'Retail Sale Id 3258',0.00,2208.00,736.00,2208.00,0.00,'2023-02-28 17:24:42'),(3095,'1','308',1,'Retail Sale Id 3259',0.00,1472.00,736.00,1472.00,0.00,'2023-02-28 17:29:47'),(3096,'1','308',1,'Retail Sale Id 3260',0.00,7360.00,736.00,7360.00,0.00,'2023-02-28 17:30:47'),(3097,'1','308',1,'Retail Sale Id 3262',0.00,2208.00,736.00,2208.00,0.00,'2023-02-28 18:04:58'),(3098,'1','308',1,'Retail Sale Id 3263',0.00,3680.00,736.00,3680.00,0.00,'2023-02-28 18:06:43'),(3099,'1','308',1,'Retail Sale Id 3264',0.00,4416.00,736.00,4416.00,0.00,'2023-02-28 18:08:37'),(3100,'1','308',1,'Retail Sale Id 3265',0.00,44.16,736.00,44.16,0.00,'2023-02-28 19:13:38'),(3101,'1','308',1,'Retail Sale Id 3266',0.00,1472.00,736.00,1472.00,0.00,'2023-03-01 07:21:04'),(3102,'1','308',1,'Retail Sale Id 3267',0.00,2208.00,736.00,2208.00,0.00,'2023-03-01 07:23:05'),(3103,'1','308',1,'Retail Sale Id 3268',0.00,2208.00,736.00,2208.00,0.00,'2023-03-01 07:25:42'),(3104,'1','308',1,'Retail Sale Id 3270',0.00,1472.00,736.00,1472.00,0.00,'2023-03-01 07:58:25'),(3105,'1','308',1,'Retail Sale Id 3271',0.00,9200.00,736.00,9200.00,0.00,'2023-03-01 08:05:57'),(3106,'1','308',1,'Retail Sale Id 3272',0.00,4416.00,736.00,4416.00,0.00,'2023-03-01 08:24:21'),(3107,'1','308',1,'Retail Sale Id 3273',0.00,2208.00,736.00,2208.00,0.00,'2023-03-01 08:26:26'),(3108,'1','308',1,'Retail Sale Id 3274',0.00,1472.00,736.00,1472.00,0.00,'2023-03-01 08:32:43'),(3109,'1','308',1,'Retail Sale Id 3275',0.00,1501.44,736.00,1501.44,0.00,'2023-03-01 08:42:16'),(3110,'1','308',1,'Retail Sale Id 3276',0.00,4416.00,736.00,4416.00,0.00,'2023-03-01 08:49:26'),(3111,'1','308',1,'Retail Sale Id 3277',0.00,2001.92,736.00,2001.92,0.00,'2023-03-01 08:54:34'),(3112,'1','308',1,'Retail Sale Id 3278',0.00,4416.00,736.00,4416.00,0.00,'2023-03-01 08:59:23'),(3113,'1','308',1,'Retail Sale Id 3279',0.00,2208.00,736.00,2208.00,0.00,'2023-03-01 09:00:54'),(3114,'1','308',1,'Retail Sale Id 3280',0.00,2001.92,736.00,2001.92,0.00,'2023-03-01 09:22:49'),(3115,'1','308',1,'Retail Sale Id 3281',0.00,22080.00,680.00,20400.00,-1680.00,'2023-03-01 09:26:55'),(3116,'1','308',1,'Retail Sale Id 3282',0.00,4416.00,736.00,4416.00,0.00,'2023-03-01 09:28:27'),(3117,'1','308',1,'Retail Sale Id 3283',0.00,3680.00,736.00,3680.00,0.00,'2023-03-01 09:34:01'),(3118,'1','308',1,'Retail Sale Id 3284',0.00,1472.00,736.00,1472.00,0.00,'2023-03-01 09:38:30'),(3119,'1','308',1,'Retail Sale Id 3285',0.00,1000.96,736.00,1000.96,0.00,'2023-03-01 09:40:06'),(3120,'1','308',1,'Retail Sale Id 3286',0.00,750.72,736.00,750.72,0.00,'2023-03-01 09:41:24'),(3121,'1','308',1,'Retail Sale Id 3287',0.00,202400.00,680.00,187000.00,-15400.00,'2023-03-01 10:17:16'),(3122,'1','308',1,'Retail Sale Id 3288',0.00,1501.44,736.00,1501.44,0.00,'2023-03-01 11:23:39'),(3123,'1','308',1,'Retail Sale Id 3291',0.00,1472.00,736.00,1472.00,0.00,'2023-03-01 13:10:25'),(3124,'1','308',1,'Retail Sale Id 3292',0.00,22080.00,680.00,20400.00,-1680.00,'2023-03-01 14:10:51'),(3125,'1','308',1,'Return of Retail Sale Id 3286',750.72,0.00,736.00,-750.72,0.00,'2023-03-01 14:39:38'),(3126,'1','308',1,'Retail Sale Id 3294',0.00,3002.88,736.00,3002.88,0.00,'2023-03-01 14:46:55'),(3127,'1','308',1,'Retail Sale Id 3295',0.00,3002.88,736.00,3002.88,0.00,'2023-03-01 14:48:30'),(3128,'1','308',1,'Retail Sale Id 3296',0.00,1472.00,736.00,1472.00,0.00,'2023-03-01 15:10:51'),(3129,'1','308',1,'Retail Sale Id 3297',0.00,2208.00,736.00,2208.00,0.00,'2023-03-01 16:21:30'),(3130,'1','308',1,'Retail Sale Id 3298',0.00,9200.00,736.00,9200.00,0.00,'2023-03-01 16:26:26'),(3131,'1','308',1,'Retail Sale Id 3299',0.00,1479.36,736.00,1479.36,0.00,'2023-03-01 16:27:39'),(3132,'1','308',1,'Retail Sale Id 3300',0.00,1501.44,736.00,1501.44,0.00,'2023-03-01 16:58:02'),(3133,'1','308',1,'Retail Sale Id 3301',0.00,4423.36,736.00,4423.36,0.00,'2023-03-01 16:58:49'),(3134,'1','308',1,'Retail Sale Id 3302',0.00,18400.00,680.00,17000.00,-1400.00,'2023-03-01 17:03:08'),(3135,'1','308',1,'Retail Sale Id 3303',0.00,3002.88,736.00,3002.88,0.00,'2023-03-01 17:12:13'),(3136,'1','308',1,'Retail Sale Id 3304',0.00,3002.88,736.00,3002.88,0.00,'2023-03-01 17:13:55'),(3137,'1','308',1,'Retail Sale Id 3305',0.00,2208.00,736.00,2208.00,0.00,'2023-03-01 17:18:53'),(3138,'1','308',1,'Retail Sale Id 3306',0.00,3002.88,736.00,3002.88,0.00,'2023-03-01 17:21:04'),(3139,'1','308',1,'Retail Sale Id 3307',0.00,3002.88,736.00,3002.88,0.00,'2023-03-01 17:22:13'),(3140,'1','308',1,'Retail Sale Id 3308',0.00,2944.00,736.00,2944.00,0.00,'2023-03-01 17:33:50'),(3141,'1','308',1,'Retail Sale Id 3309',0.00,1501.44,736.00,1501.44,0.00,'2023-03-01 17:34:50'),(3142,'1','308',1,'Retail Sale Id 3310',0.00,4423.36,736.00,4423.36,0.00,'2023-03-01 17:42:51'),(3143,'1','308',1,'Retail Sale Id 3311',0.00,1501.44,736.00,1501.44,0.00,'2023-03-01 17:51:29'),(3144,'1','308',1,'Retail Sale Id 3312',0.00,2208.00,736.00,2208.00,0.00,'2023-03-01 17:58:34'),(3145,'1','308',1,'Retail Sale Id 3313',0.00,3002.88,736.00,3002.88,0.00,'2023-03-01 18:04:29'),(3146,'1','308',1,'Retail Sale Id 3314',0.00,1501.44,736.00,1501.44,0.00,'2023-03-01 18:13:35'),(3147,'1','308',1,'Retail Sale Id 3315',0.00,3680.00,736.00,3680.00,0.00,'2023-03-01 18:17:45'),(3148,'1','308',1,'Retail Sale Id 3317',0.00,1501.44,736.00,1501.44,0.00,'2023-03-01 18:26:40'),(3149,'1','308',1,'Retail Sale Id 3318',0.00,3680.00,736.00,3680.00,0.00,'2023-03-01 18:29:32'),(3150,'1','308',1,'Retail Sale Id 3319',0.00,1501.44,736.00,1501.44,0.00,'2023-03-01 18:47:18'),(3151,'1','308',1,'Retail Sale Id 3320',0.00,4416.00,736.00,4416.00,0.00,'2023-03-01 18:50:22'),(3152,'1','308',1,'Retail Sale Id 3321',0.00,787.52,736.00,787.52,0.00,'2023-03-01 19:14:14'),(3153,'1','308',1,'Retail Sale Id 3323',0.00,2208.00,736.00,2208.00,0.00,'2023-03-02 07:54:09'),(3154,'1','308',1,'Retail Sale Id 3325',0.00,1501.44,736.00,1501.44,0.00,'2023-03-02 07:57:04'),(3155,'1','308',1,'Retail Sale Id 3326',0.00,1501.44,736.00,1501.44,0.00,'2023-03-02 07:58:37'),(3156,'1','308',1,'Retail Sale Id 3327',0.00,2208.00,736.00,2208.00,0.00,'2023-03-02 07:59:32'),(3157,'1','308',1,'Retail Sale Id 3329',0.00,1803.20,736.00,1803.20,0.00,'2023-03-02 08:12:25'),(3158,'1','308',1,'Retail Sale Id 3330',0.00,2001.92,736.00,2001.92,0.00,'2023-03-02 08:18:01'),(3159,'1','308',1,'Retail Sale Id 3331',0.00,2944.00,736.00,2944.00,0.00,'2023-03-02 08:25:22'),(3160,'1','308',1,'Retail Sale Id 3332',0.00,2944.00,736.00,2944.00,0.00,'2023-03-02 08:35:09'),(3161,'1','308',1,'Retail Sale Id 3333',0.00,4416.00,736.00,4416.00,0.00,'2023-03-02 08:37:23'),(3162,'1','308',1,'Retail Sale Id 3334',0.00,3680.00,736.00,3680.00,0.00,'2023-03-02 08:45:02'),(3163,'1','308',1,'Retail Sale Id 3335',0.00,4423.36,736.00,4423.36,0.00,'2023-03-02 08:46:25'),(3164,'1','308',1,'Retail Sale Id 3336',0.00,1501.44,736.00,1501.44,0.00,'2023-03-02 08:48:14'),(3165,'1','308',1,'Retail Sale Id 3338',0.00,9200.00,736.00,9200.00,0.00,'2023-03-02 09:16:48'),(3166,'1','308',1,'Retail Sale Id 3339',0.00,603.52,736.00,603.52,0.00,'2023-03-02 09:18:18'),(3167,'1','308',1,'Retail Sale Id 3340',0.00,9200.00,736.00,9200.00,0.00,'2023-03-02 09:19:35'),(3168,'1','308',1,'Retail Sale Id 3341',0.00,1501.44,736.00,1501.44,0.00,'2023-03-02 09:21:09'),(3169,'1','308',1,'Retail Sale Id 3342',0.00,2001.92,736.00,2001.92,0.00,'2023-03-02 09:37:57'),(3170,'1','308',1,'Retail Sale Id 3343',0.00,1501.44,736.00,1501.44,0.00,'2023-03-02 09:47:50'),(3171,'1','308',1,'Retail Sale Id 3344',0.00,2208.00,736.00,2208.00,0.00,'2023-03-02 09:52:37'),(3172,'1','308',1,'Retail Sale Id 3345',0.00,9200.00,736.00,9200.00,0.00,'2023-03-02 09:58:16'),(3173,'1','308',1,'Retail Sale Id 3346',0.00,4423.36,736.00,4423.36,0.00,'2023-03-02 10:16:44'),(3174,'1','308',1,'Retail Sale Id 3347',0.00,3680.00,736.00,3680.00,0.00,'2023-03-02 10:21:41'),(3175,'1','308',1,'Retail Sale Id 3348',0.00,2208.00,736.00,2208.00,0.00,'2023-03-02 10:23:15'),(3176,'1','308',1,'Retail Sale Id 3349',0.00,2208.00,736.00,2208.00,0.00,'2023-03-02 10:28:50'),(3177,'1','308',1,'Retail Sale Id 3350',0.00,5159.36,736.00,5159.36,0.00,'2023-03-02 10:33:54'),(3178,'1','308',1,'Retail Sale Id 3351',0.00,3996.48,736.00,3996.48,0.00,'2023-03-02 10:40:42'),(3179,'1','308',1,'Retail Sale Id 3352',0.00,4298.24,736.00,4298.24,0.00,'2023-03-02 10:41:55'),(3180,'1','308',1,'Retail Sale Id 3353',0.00,802.24,736.00,802.24,0.00,'2023-03-02 10:43:43'),(3181,'1','308',1,'Return of Retail Sale Id 3347',3680.00,0.00,736.00,-3680.00,0.00,'2023-03-02 10:48:58'),(3182,'1','308',1,'Retail Sale Id 3354',0.00,2208.00,736.00,2208.00,0.00,'2023-03-02 10:54:01'),(3183,'1','308',1,'Retail Sale Id 3355',0.00,1000.96,736.00,1000.96,0.00,'2023-03-02 10:55:10'),(3184,'1','308',1,'Retail Sale Id 3356',0.00,2208.00,736.00,2208.00,0.00,'2023-03-02 10:56:40'),(3185,'1','308',1,'Retail Sale Id 3357',0.00,73600.00,680.00,68000.00,-5600.00,'2023-03-02 10:58:01'),(3186,'1','308',1,'Retail Sale Id 3358',0.00,73600.00,680.00,68000.00,-5600.00,'2023-03-02 11:10:34'),(3187,'1','308',1,'Retail Sale Id 3359',0.00,4416.00,736.00,4416.00,0.00,'2023-03-02 11:43:54'),(3188,'1','308',1,'Retail Sale Id 3360',0.00,750.72,736.00,750.72,0.00,'2023-03-02 13:48:50'),(3189,'1','308',1,'Retail Sale Id 3361',0.00,5159.36,736.00,5159.36,0.00,'2023-03-02 13:55:23'),(3190,'1','308',1,'Retail Sale Id 3362',0.00,1501.44,736.00,1501.44,0.00,'2023-03-02 14:43:16'),(3191,'1','308',1,'Retail Sale Id 3363',0.00,8103.36,736.00,8103.36,0.00,'2023-03-02 15:01:44'),(3192,'1','308',1,'Retail Sale Id 3364',0.00,2701.12,736.00,2701.12,0.00,'2023-03-02 16:27:52'),(3193,'1','308',1,'Retail Sale Id 3365',0.00,2944.00,736.00,2944.00,0.00,'2023-03-02 17:23:42'),(3194,'1','308',1,'Retail Sale Id 3366',0.00,802.24,736.00,802.24,0.00,'2023-03-02 17:37:41'),(3195,'1','308',1,'Retail Sale Id 3367',0.00,2944.00,736.00,2944.00,0.00,'2023-03-02 18:20:09'),(3196,'1','308',1,'Return of Retail Sale Id 3363',8103.36,0.00,736.00,-8103.36,0.00,'2023-03-02 18:43:00'),(3197,'1','308',1,'Return of Retail Sale Id 3364',2701.12,0.00,736.00,-2701.12,0.00,'2023-03-02 18:44:00'),(3198,'1','308',1,'Retail Sale Id 3368',0.00,220.80,736.00,220.80,0.00,'2023-03-02 18:45:02'),(3199,'1','308',1,'Retail Sale Id 3369',0.00,79488.00,680.00,73440.00,-6048.00,'2023-03-02 18:48:14'),(3200,'1','308',1,'Retail Sale Id 3370',0.00,986.24,736.00,986.24,0.00,'2023-03-02 18:57:14'),(3201,'1','308',1,'Retail Sale Id 3371',0.00,220.80,736.00,220.80,0.00,'2023-03-02 19:30:43'),(3202,'1','308',1,'Return of Retail Sale Id 3371',220.80,0.00,736.00,-220.80,0.00,'2023-03-02 21:06:49'),(3203,'1','308',1,'Retail Sale Id 3372',0.00,29.44,736.00,29.44,0.00,'2023-03-02 21:07:47'),(3204,'1','308',1,'Retail Sale Id 3373',0.00,1501.44,736.00,1501.44,0.00,'2023-03-03 07:15:34'),(3205,'1','308',1,'Retail Sale Id 3374',0.00,2944.00,736.00,2944.00,0.00,'2023-03-03 07:31:34'),(3206,'1','308',1,'Retail Sale Id 3375',0.00,4416.00,736.00,4416.00,0.00,'2023-03-03 07:33:02'),(3207,'1','308',1,'Retail Sale Id 3376',0.00,1472.00,736.00,1472.00,0.00,'2023-03-03 07:35:19'),(3208,'1','308',1,'Retail Sale Id 3377',0.00,3680.00,736.00,3680.00,0.00,'2023-03-03 07:52:45'),(3209,'1','308',1,'Retail Sale Id 3378',0.00,4416.00,736.00,4416.00,0.00,'2023-03-03 07:55:38'),(3210,'1','308',1,'Retail Sale Id 3379',0.00,3996.48,736.00,3996.48,0.00,'2023-03-03 07:59:17'),(3211,'1','308',1,'Retail Sale Id 3380',0.00,2208.00,736.00,2208.00,0.00,'2023-03-03 08:10:07'),(3212,'1','308',1,'Retail Sale Id 3381',0.00,9200.00,736.00,9200.00,0.00,'2023-03-03 08:45:10'),(3213,'1','308',1,'Retail Sale Id 3382',0.00,2944.00,736.00,2944.00,0.00,'2023-03-03 09:06:36'),(3214,'1','308',1,'Retail Sale Id 3383',0.00,3680.00,736.00,3680.00,0.00,'2023-03-03 09:22:23'),(3215,'1','308',1,'Retail Sale Id 3384',0.00,750.72,736.00,750.72,0.00,'2023-03-03 09:25:54'),(3216,'1','308',1,'Retail Sale Id 3385',0.00,1501.44,736.00,1501.44,0.00,'2023-03-03 09:27:52'),(3217,'1','308',1,'Retail Sale Id 3386',0.00,1501.44,736.00,1501.44,0.00,'2023-03-03 11:14:10'),(3218,'1','308',1,'Retail Sale Id 3387',0.00,1472.00,736.00,1472.00,0.00,'2023-03-03 11:59:07'),(3219,'1','308',1,'Retail Sale Id 3388',0.00,2208.00,736.00,2208.00,0.00,'2023-03-03 12:07:04'),(3220,'1','308',1,'Retail Sale Id 3389',0.00,18400.00,680.00,17000.00,-1400.00,'2023-03-03 12:14:43'),(3221,'1','308',1,'Retail Sale Id 3390',0.00,2944.00,736.00,2944.00,0.00,'2023-03-03 12:31:03'),(3222,'1','308',1,'Retail Sale Id 3391',0.00,2001.92,736.00,2001.92,0.00,'2023-03-03 13:32:24'),(3223,'1','308',1,'Retail Sale Id 3392',0.00,4416.00,736.00,4416.00,0.00,'2023-03-03 13:49:16'),(3224,'1','308',1,'Retail Sale Id 3393',0.00,1501.44,736.00,1501.44,0.00,'2023-03-03 15:25:22'),(3225,'1','308',1,'Retail Sale Id 3394',0.00,4416.00,736.00,4416.00,0.00,'2023-03-03 16:13:02'),(3226,'1','308',1,'Retail Sale Id 3395',0.00,2944.00,736.00,2944.00,0.00,'2023-03-03 16:37:33'),(3227,'1','308',1,'Retail Sale Id 3396',0.00,2951.36,736.00,2951.36,0.00,'2023-03-03 17:02:34'),(3228,'1','308',1,'Retail Sale Id 3397',0.00,9200.00,736.00,9200.00,0.00,'2023-03-03 17:21:44'),(3229,'1','308',1,'Retail Sale Id 3398',0.00,750.72,736.00,750.72,0.00,'2023-03-03 17:51:06'),(3230,'1','308',1,'Retail Sale Id 3399',0.00,1501.44,736.00,1501.44,0.00,'2023-03-03 17:54:45'),(3231,'1','308',1,'Retail Sale Id 3400',0.00,2208.00,736.00,2208.00,0.00,'2023-03-03 17:56:54'),(3232,'1','308',1,'Retail Sale Id 3401',0.00,2208.00,736.00,2208.00,0.00,'2023-03-03 18:03:12'),(3233,'1','308',1,'Retail Sale Id 3402',0.00,2001.92,736.00,2001.92,0.00,'2023-03-03 18:05:59'),(3234,'1','308',1,'Retail Sale Id 3403',0.00,2208.00,736.00,2208.00,0.00,'2023-03-03 18:21:00'),(3235,'1','308',1,'Retail Sale Id 3404',0.00,9200.00,736.00,9200.00,0.00,'2023-03-03 18:27:38'),(3236,'1','308',1,'Retail Sale Id 3405',0.00,1501.44,736.00,1501.44,0.00,'2023-03-03 18:49:51'),(3237,'1','308',1,'Retail Sale Id 3406',0.00,9200.00,736.00,9200.00,0.00,'2023-03-03 18:50:38'),(3238,'1','308',1,'Retail Sale Id 3407',0.00,2208.00,736.00,2208.00,0.00,'2023-03-03 18:51:54'),(3239,'1','308',1,'Retail Sale Id 3408',0.00,1501.44,736.00,1501.44,0.00,'2023-03-03 18:53:44'),(3240,'1','308',1,'Retail Sale Id 3409',0.00,2001.92,736.00,2001.92,0.00,'2023-03-03 18:54:47'),(3241,'1','308',1,'Retail Sale Id 3410',0.00,9200.00,736.00,9200.00,0.00,'2023-03-03 18:59:16'),(3242,'1','308',1,'Retail Sale Id 3411',0.00,2944.00,736.00,2944.00,0.00,'2023-03-03 19:31:44'),(3243,'1','308',1,'Retail Sale Id 3412',0.00,235.52,736.00,235.52,0.00,'2023-03-03 19:44:24'),(3244,'1','308',1,'Retail Sale Id 3413',0.00,9200.00,736.00,9200.00,0.00,'2023-03-04 07:16:42'),(3245,'1','308',1,'Retail Sale Id 3414',0.00,2208.00,736.00,2208.00,0.00,'2023-03-04 07:43:31'),(3246,'1','308',1,'Retail Sale Id 3415',0.00,750.72,736.00,750.72,0.00,'2023-03-04 07:45:01'),(3247,'1','308',1,'Retail Sale Id 3416',0.00,22080.00,680.00,20400.00,-1680.00,'2023-03-04 08:05:51'),(3248,'1','308',1,'Retail Sale Id 3417',0.00,1501.44,736.00,1501.44,0.00,'2023-03-04 08:09:50'),(3249,'1','308',1,'Retail Sale Id 3418',0.00,2208.00,736.00,2208.00,0.00,'2023-03-04 08:12:19'),(3250,'1','308',1,'Retail Sale Id 3419',0.00,897.92,736.00,897.92,0.00,'2023-03-04 08:24:06'),(3251,'1','308',1,'Retail Sale Id 3420',0.00,9200.00,736.00,9200.00,0.00,'2023-03-04 08:28:55'),(3252,'1','308',1,'Retail Sale Id 3421',0.00,2502.40,736.00,2502.40,0.00,'2023-03-04 08:36:58'),(3253,'1','308',1,'Retail Sale Id 3422',0.00,3680.00,736.00,3680.00,0.00,'2023-03-04 08:38:27'),(3254,'1','308',1,'Retail Sale Id 3423',0.00,9200.00,736.00,9200.00,0.00,'2023-03-04 08:39:38'),(3255,'1','308',1,'Retail Sale Id 3424',0.00,2944.00,736.00,2944.00,0.00,'2023-03-04 08:41:15'),(3256,'1','308',1,'Retail Sale Id 3425',0.00,2001.92,736.00,2001.92,0.00,'2023-03-04 08:44:36'),(3257,'1','308',1,'Retail Sale Id 3426',0.00,2944.00,736.00,2944.00,0.00,'2023-03-04 08:46:10'),(3258,'1','308',1,'Retail Sale Id 3427',0.00,3680.00,736.00,3680.00,0.00,'2023-03-04 08:47:31'),(3259,'1','308',1,'Retail Sale Id 3428',0.00,2944.00,736.00,2944.00,0.00,'2023-03-04 08:55:40'),(3260,'1','308',1,'Retail Sale Id 3429',0.00,1501.44,736.00,1501.44,0.00,'2023-03-04 08:57:28'),(3261,'1','308',1,'Retail Sale Id 3430',0.00,2208.00,736.00,2208.00,0.00,'2023-03-04 09:01:13'),(3262,'1','308',1,'Retail Sale Id 3431',0.00,1501.44,736.00,1501.44,0.00,'2023-03-04 09:10:21'),(3263,'1','308',1,'Retail Sale Id 3432',0.00,3680.00,736.00,3680.00,0.00,'2023-03-04 09:16:59'),(3264,'1','308',1,'Retail Sale Id 3433',0.00,2208.00,736.00,2208.00,0.00,'2023-03-04 09:21:27'),(3265,'1','308',1,'Retail Sale Id 3434',0.00,1398.40,736.00,1398.40,0.00,'2023-03-04 09:25:42'),(3266,'1','308',1,'Retail Sale Id 3435',0.00,3702.08,736.00,3702.08,0.00,'2023-03-04 09:31:44'),(3267,'1','308',1,'Retail Sale Id 3436',0.00,4416.00,736.00,4416.00,0.00,'2023-03-04 09:37:57'),(3268,'1','308',1,'Retail Sale Id 3437',0.00,2208.00,736.00,2208.00,0.00,'2023-03-04 09:54:27'),(3269,'1','308',1,'Retail Sale Id 3440',0.00,7360.00,736.00,7360.00,0.00,'2023-03-04 10:40:43'),(3270,'1','308',1,'Retail Sale Id 3441',0.00,1000.96,736.00,1000.96,0.00,'2023-03-04 10:50:32'),(3271,'1','308',1,'Retail Sale Id 3439',0.00,1472.00,736.00,1472.00,0.00,'2023-03-04 11:19:11'),(3272,'1','308',1,'Retail Sale Id 3439',0.00,3680.00,736.00,3680.00,0.00,'2023-03-04 11:19:11'),(3273,'1','308',1,'Retail Sale Id 3442',0.00,1840.00,736.00,1840.00,0.00,'2023-03-04 11:22:25'),(3274,'1','308',1,'Retail Sale Id 3443',0.00,1472.00,736.00,1472.00,0.00,'2023-03-04 11:30:10'),(3275,'1','308',1,'Retail Sale Id 3444',0.00,4416.00,736.00,4416.00,0.00,'2023-03-04 13:20:16'),(3276,'1','308',1,'Retail Sale Id 3445',0.00,4416.00,736.00,4416.00,0.00,'2023-03-04 13:25:38'),(3277,'1','308',1,'Retail Sale Id 3446',0.00,2944.00,736.00,2944.00,0.00,'2023-03-04 13:38:36'),(3278,'1','308',1,'Retail Sale Id 3447',0.00,1501.44,736.00,1501.44,0.00,'2023-03-04 13:46:29'),(3279,'1','308',1,'Retail Sale Id 3448',0.00,4416.00,736.00,4416.00,0.00,'2023-03-04 14:10:28'),(3280,'1','308',1,'Retail Sale Id 3449',0.00,1501.44,736.00,1501.44,0.00,'2023-03-04 14:15:50'),(3281,'1','308',1,'Return of Retail Sale Id 3440',7360.00,0.00,736.00,-7360.00,0.00,'2023-03-04 14:31:41'),(3282,'1','308',1,'Retail Sale Id 3450',0.00,4416.00,736.00,4416.00,0.00,'2023-03-04 14:39:25'),(3283,'1','308',1,'Retail Sale Id 3451',0.00,1501.44,736.00,1501.44,0.00,'2023-03-04 14:58:54'),(3284,'1','308',1,'Retail Sale Id 3452',0.00,85376.00,680.00,78880.00,-6496.00,'2023-03-04 16:03:52'),(3285,'1','308',1,'Retail Sale Id 3453',0.00,1000.96,736.00,1000.96,0.00,'2023-03-04 16:49:47'),(3286,'1','308',1,'Retail Sale Id 3454',0.00,7360.00,736.00,7360.00,0.00,'2023-03-04 17:08:22'),(3287,'1','308',1,'Retail Sale Id 3456',0.00,1700.16,736.00,1700.16,0.00,'2023-03-04 17:37:00'),(3288,'1','308',1,'Retail Sale Id 3457',0.00,18400.00,680.00,17000.00,-1400.00,'2023-03-04 17:43:13'),(3289,'1','308',1,'Retail Sale Id 3458',0.00,147200.00,680.00,136000.00,-11200.00,'2023-03-04 17:49:38'),(3290,'1','308',1,'Retail Sale Id 3459',0.00,3680.00,736.00,3680.00,0.00,'2023-03-04 17:53:14'),(3291,'1','308',1,'Retail Sale Id 3460',0.00,2208.00,736.00,2208.00,0.00,'2023-03-04 17:57:28'),(3292,'1','308',1,'Retail Sale Id 3461',0.00,5012.16,736.00,5012.16,0.00,'2023-03-04 18:15:36'),(3293,'1','308',1,'Retail Sale Id 3462',0.00,29.44,736.00,29.44,0.00,'2023-03-04 18:23:58'),(3294,'1','308',1,'Retail Sale Id 3463',0.00,2944.00,736.00,2944.00,0.00,'2023-03-05 07:08:04'),(3295,'1','308',1,'Retail Sale Id 3464',0.00,2208.00,736.00,2208.00,0.00,'2023-03-05 07:10:10'),(3296,'1','308',1,'Retail Sale Id 3465',0.00,5888.00,736.00,5888.00,0.00,'2023-03-05 07:35:49'),(3297,'1','308',1,'Retail Sale Id 3466',0.00,8832.00,736.00,8832.00,0.00,'2023-03-05 07:46:07'),(3298,'1','308',1,'Retail Sale Id 3467',0.00,5152.00,736.00,5152.00,0.00,'2023-03-05 07:51:40'),(3299,'1','308',1,'Retail Sale Id 3468',0.00,7360.00,736.00,7360.00,0.00,'2023-03-05 07:54:32'),(3300,'1','308',1,'Retail Sale Id 3469',0.00,2208.00,736.00,2208.00,0.00,'2023-03-05 07:59:10'),(3301,'1','308',1,'Retail Sale Id 3470',0.00,3002.88,736.00,3002.88,0.00,'2023-03-05 08:03:07'),(3302,'1','308',1,'Retail Sale Id 3471',0.00,5152.00,736.00,5152.00,0.00,'2023-03-05 08:07:51'),(3303,'1','308',1,'Retail Sale Id 3472',0.00,4416.00,736.00,4416.00,0.00,'2023-03-05 08:09:25'),(3304,'1','308',1,'Retail Sale Id 3473',0.00,2944.00,736.00,2944.00,0.00,'2023-03-05 08:12:36'),(3305,'1','308',1,'Retail Sale Id 3474',0.00,4416.00,736.00,4416.00,0.00,'2023-03-05 08:16:58'),(3306,'1','308',1,'Retail Sale Id 3475',0.00,3680.00,736.00,3680.00,0.00,'2023-03-05 08:26:21'),(3307,'1','308',1,'Retail Sale Id 3476',0.00,2208.00,736.00,2208.00,0.00,'2023-03-05 08:53:02'),(3308,'1','308',1,'Retail Sale Id 3477',0.00,3680.00,736.00,3680.00,0.00,'2023-03-05 08:54:41'),(3309,'1','308',1,'Retail Sale Id 3478',0.00,2944.00,736.00,2944.00,0.00,'2023-03-05 08:56:47'),(3310,'1','308',1,'Retail Sale Id 3480',0.00,4416.00,736.00,4416.00,0.00,'2023-03-05 08:58:16'),(3311,'1','308',1,'Retail Sale Id 3481',0.00,4416.00,736.00,4416.00,0.00,'2023-03-05 09:02:30'),(3312,'1','308',1,'Retail Sale Id 3482',0.00,1472.00,736.00,1472.00,0.00,'2023-03-05 09:25:26'),(3313,'1','308',1,'Retail Sale Id 3483',0.00,2208.00,736.00,2208.00,0.00,'2023-03-05 09:31:07'),(3314,'1','308',1,'Retail Sale Id 3484',0.00,8832.00,736.00,8832.00,0.00,'2023-03-05 09:36:57'),(3315,'1','308',1,'Retail Sale Id 3485',0.00,736.00,736.00,736.00,0.00,'2023-03-05 09:40:20'),(3316,'1','308',1,'Retail Sale Id 3486',0.00,5152.00,736.00,5152.00,0.00,'2023-03-05 09:42:11'),(3317,'1','308',1,'Retail Sale Id 3487',0.00,9200.00,736.00,9200.00,0.00,'2023-03-05 09:48:32'),(3318,'1','308',1,'Retail Sale Id 3488',0.00,1472.00,736.00,1472.00,0.00,'2023-03-05 09:50:25'),(3319,'1','308',1,'Retail Sale Id 3489',0.00,4416.00,736.00,4416.00,0.00,'2023-03-05 10:05:43'),(3320,'1','308',1,'Retail Sale Id 3490',0.00,2208.00,736.00,2208.00,0.00,'2023-03-05 10:07:46'),(3321,'1','308',1,'Retail Sale Id 3491',0.00,736.00,736.00,736.00,0.00,'2023-03-05 10:25:15'),(3322,'1','308',1,'Retail Sale Id 3492',0.00,3680.00,736.00,3680.00,0.00,'2023-03-05 10:26:59'),(3323,'1','308',1,'Retail Sale Id 3493',0.00,1472.00,736.00,1472.00,0.00,'2023-03-05 10:28:54'),(3324,'1','308',1,'Retail Sale Id 3494',0.00,2208.00,736.00,2208.00,0.00,'2023-03-05 10:30:23'),(3325,'1','308',1,'Retail Sale Id 3495',0.00,743.36,736.00,743.36,0.00,'2023-03-05 10:36:52'),(3326,'1','308',1,'Retail Sale Id 3496',0.00,73600.00,680.00,68000.00,-5600.00,'2023-03-05 10:39:59'),(3327,'1','308',1,'Retail Sale Id 3497',0.00,736.00,736.00,736.00,0.00,'2023-03-05 10:42:05'),(3328,'1','308',1,'Retail Sale Id 3498',0.00,3680.00,736.00,3680.00,0.00,'2023-03-05 11:00:15'),(3329,'1','308',1,'Retail Sale Id 3499',0.00,736.00,736.00,736.00,0.00,'2023-03-05 11:02:31'),(3330,'1','308',1,'Retail Sale Id 3500',0.00,7360.00,736.00,7360.00,0.00,'2023-03-05 11:04:50'),(3331,'1','308',1,'Retail Sale Id 3501',0.00,8832.00,736.00,8832.00,0.00,'2023-03-05 11:20:50'),(3332,'1','308',1,'Retail Sale Id 3502',0.00,1501.44,736.00,1501.44,0.00,'2023-03-05 11:28:20'),(3333,'1','308',1,'Return of Retail Sale Id 3496',73600.00,0.00,680.00,-68000.00,5600.00,'2023-03-05 11:28:38'),(3334,'1','308',1,'Retail Sale Id 3503',0.00,4416.00,736.00,4416.00,0.00,'2023-03-05 11:30:48'),(3335,'1','308',1,'Retail Sale Id 3504',0.00,1472.00,736.00,1472.00,0.00,'2023-03-05 11:31:59'),(3336,'1','308',1,'Retail Sale Id 3505',0.00,3680.00,736.00,3680.00,0.00,'2023-03-05 11:38:31'),(3337,'1','308',1,'Retail Sale Id 3506',0.00,750.72,736.00,750.72,0.00,'2023-03-05 11:50:59'),(3338,'1','308',1,'Retail Sale Id 3507',0.00,2208.00,736.00,2208.00,0.00,'2023-03-05 12:06:21'),(3339,'1','308',1,'Retail Sale Id 3508',0.00,8464.00,736.00,8464.00,0.00,'2023-03-05 12:08:48'),(3340,'1','308',1,'Retail Sale Id 3509',0.00,2001.92,736.00,2001.92,0.00,'2023-03-05 12:19:43'),(3341,'1','308',1,'Retail Sale Id 3510',0.00,5152.00,736.00,5152.00,0.00,'2023-03-05 12:35:29'),(3342,'1','308',1,'Retail Sale Id 3511',0.00,2944.00,736.00,2944.00,0.00,'2023-03-05 12:43:04'),(3343,'1','308',1,'Retail Sale Id 3512',0.00,3680.00,736.00,3680.00,0.00,'2023-03-05 12:50:04'),(3344,'1','308',1,'Retail Sale Id 3513',0.00,1472.00,736.00,1472.00,0.00,'2023-03-05 13:03:27'),(3345,'1','308',1,'Retail Sale Id 3514',0.00,4416.00,736.00,4416.00,0.00,'2023-03-05 13:41:02'),(3346,'1','308',1,'Retail Sale Id 3515',0.00,22080.00,680.00,20400.00,-1680.00,'2023-03-05 14:23:58'),(3347,'1','308',1,'Retail Sale Id 3516',0.00,5888.00,736.00,5888.00,0.00,'2023-03-05 14:53:43'),(3348,'1','308',1,'Retail Sale Id 3517',0.00,1472.00,736.00,1472.00,0.00,'2023-03-05 14:55:40'),(3349,'1','308',1,'Retail Sale Id 3518',0.00,1501.44,736.00,1501.44,0.00,'2023-03-05 14:59:07'),(3350,'1','308',1,'Retail Sale Id 3519',0.00,9200.00,736.00,9200.00,0.00,'2023-03-05 15:08:12'),(3351,'1','308',1,'Retail Sale Id 3520',0.00,4416.00,736.00,4416.00,0.00,'2023-03-05 15:13:34'),(3352,'1','308',1,'Retail Sale Id 3522',0.00,5152.00,736.00,5152.00,0.00,'2023-03-05 15:32:07'),(3353,'1','308',1,'Retail Sale Id 3523',0.00,2208.00,736.00,2208.00,0.00,'2023-03-05 15:39:08'),(3354,'1','308',1,'Retail Sale Id 3524',0.00,22080.00,680.00,20400.00,-1680.00,'2023-03-05 15:45:20'),(3355,'1','308',1,'Retail Sale Id 3525',0.00,2208.00,736.00,2208.00,0.00,'2023-03-05 15:47:11'),(3356,'1','308',1,'Retail Sale Id 3526',0.00,2208.00,736.00,2208.00,0.00,'2023-03-05 15:49:26'),(3357,'1','308',1,'Retail Sale Id 3527',0.00,2208.00,736.00,2208.00,0.00,'2023-03-05 16:08:47'),(3358,'1','308',1,'Retail Sale Id 3528',0.00,1472.00,736.00,1472.00,0.00,'2023-03-05 16:12:11'),(3359,'1','308',1,'Retail Sale Id 3529',0.00,9200.00,736.00,9200.00,0.00,'2023-03-05 16:30:09'),(3360,'1','308',1,'Retail Sale Id 3530',0.00,3002.88,736.00,3002.88,0.00,'2023-03-05 16:41:31'),(3361,'1','308',1,'Retail Sale Id 3531',0.00,4416.00,736.00,4416.00,0.00,'2023-03-05 16:44:16'),(3362,'1','308',1,'Retail Sale Id 3532',0.00,1501.44,736.00,1501.44,0.00,'2023-03-05 16:54:07'),(3363,'1','308',1,'Retail Sale Id 3533',0.00,1398.40,736.00,1398.40,0.00,'2023-03-05 17:02:08'),(3364,'1','308',1,'Retail Sale Id 3534',0.00,4416.00,736.00,4416.00,0.00,'2023-03-05 17:04:34'),(3365,'1','308',1,'Retail Sale Id 3535',0.00,7360.00,736.00,7360.00,0.00,'2023-03-05 17:16:46'),(3366,'1','308',1,'Retail Sale Id 3536',0.00,2944.00,736.00,2944.00,0.00,'2023-03-05 17:22:19'),(3367,'1','308',1,'Retail Sale Id 3537',0.00,736.00,736.00,736.00,0.00,'2023-03-05 17:35:01'),(3368,'1','308',1,'Retail Sale Id 3538',0.00,2208.00,736.00,2208.00,0.00,'2023-03-05 17:45:29'),(3369,'1','308',1,'Retail Sale Id 3539',0.00,3702.08,736.00,3702.08,0.00,'2023-03-05 18:00:18'),(3370,'1','308',1,'Retail Sale Id 3540',0.00,9200.00,736.00,9200.00,0.00,'2023-03-05 18:13:19'),(3371,'1','308',1,'Retail Sale Id 3541',0.00,4416.00,736.00,4416.00,0.00,'2023-03-05 18:15:02'),(3372,'1','308',1,'Retail Sale Id 3542',0.00,3680.00,736.00,3680.00,0.00,'2023-03-05 18:16:41'),(3373,'1','308',1,'Retail Sale Id 3543',0.00,4416.00,736.00,4416.00,0.00,'2023-03-05 18:17:46'),(3374,'1','308',1,'Retail Sale Id 3544',0.00,7360.00,736.00,7360.00,0.00,'2023-03-05 18:29:28'),(3375,'1','308',1,'Return of Retail Sale Id 3537',736.00,0.00,736.00,-736.00,0.00,'2023-03-05 18:42:38'),(3376,'1','308',1,'Retail Sale Id 3545',0.00,434.24,736.00,434.24,0.00,'2023-03-05 18:44:01'),(3377,'1','308',1,'Retail Sale Id 3546',0.00,2944.00,736.00,2944.00,0.00,'2023-03-05 18:54:53'),(3378,'1','308',1,'Retail Sale Id 3547',0.00,1501.44,736.00,1501.44,0.00,'2023-03-06 11:35:52'),(3379,'1','308',1,'Retail Sale Id 3548',0.00,2200.64,736.00,2200.64,0.00,'2023-03-06 11:55:52'),(3380,'1','308',1,'Retail Sale Id 3549',0.00,36800.00,680.00,34000.00,-2800.00,'2023-03-06 12:08:47'),(3381,'1','308',1,'Retail Sale Id 3550',0.00,1501.44,736.00,1501.44,0.00,'2023-03-06 12:31:20'),(3382,'1','308',1,'Retail Sale Id 3551',0.00,8096.00,736.00,8096.00,0.00,'2023-03-06 12:52:18'),(3383,'1','308',1,'Retail Sale Id 3552',0.00,1472.00,736.00,1472.00,0.00,'2023-03-06 13:11:53'),(3384,'1','308',1,'Retail Sale Id 3553',0.00,736.00,736.00,736.00,0.00,'2023-03-06 13:47:25'),(3385,'1','308',1,'Retail Sale Id 3554',0.00,743.36,736.00,743.36,0.00,'2023-03-06 14:02:38'),(3386,'1','308',1,'Retail Sale Id 3555',0.00,750.72,736.00,750.72,0.00,'2023-03-06 14:51:22'),(3387,'1','308',1,'Retail Sale Id 3556',0.00,4416.00,736.00,4416.00,0.00,'2023-03-06 15:15:52'),(3388,'1','308',1,'Retail Sale Id 3557',0.00,1000.96,736.00,1000.96,0.00,'2023-03-06 15:47:25'),(3389,'1','308',1,'Retail Sale Id 3558',0.00,1472.00,736.00,1472.00,0.00,'2023-03-06 16:07:08'),(3390,'1','308',1,'Retail Sale Id 3559',0.00,4416.00,736.00,4416.00,0.00,'2023-03-06 16:13:59'),(3391,'1','308',1,'Retail Sale Id 3560',0.00,4416.00,736.00,4416.00,0.00,'2023-03-06 16:21:08'),(3392,'1','308',1,'Retail Sale Id 3561',0.00,2208.00,736.00,2208.00,0.00,'2023-03-06 16:28:42'),(3393,'1','308',1,'Retail Sale Id 3562',0.00,2208.00,736.00,2208.00,0.00,'2023-03-06 16:35:33'),(3394,'1','308',1,'Retail Sale Id 3563',0.00,7360.00,736.00,7360.00,0.00,'2023-03-06 16:56:23'),(3395,'1','308',1,'Retail Sale Id 3564',0.00,4416.00,736.00,4416.00,0.00,'2023-03-06 17:00:48'),(3396,'1','308',1,'Retail Sale Id 3565',0.00,14720.00,680.00,13600.00,-1120.00,'2023-03-06 17:07:28'),(3397,'1','308',1,'Retail Sale Id 3566',0.00,3503.36,736.00,3503.36,0.00,'2023-03-06 17:09:46'),(3398,'1','308',1,'Retail Sale Id 3567',0.00,2208.00,736.00,2208.00,0.00,'2023-03-06 18:04:10'),(3399,'1','308',1,'Retail Sale Id 3568',0.00,2502.40,736.00,2502.40,0.00,'2023-03-06 18:09:28'),(3400,'1','308',1,'Retail Sale Id 3569',0.00,1501.44,736.00,1501.44,0.00,'2023-03-06 18:11:33'),(3401,'1','308',1,'Retail Sale Id 3570',0.00,2208.00,750.00,2250.00,42.00,'2023-03-06 18:21:39'),(3402,'1','308',1,'Retail Sale Id 3571',0.00,750.72,736.00,750.72,0.00,'2023-03-06 18:22:36'),(3403,'1','308',1,'Retail Sale Id 3572',0.00,2208.00,736.00,2208.00,0.00,'2023-03-06 18:26:12'),(3404,'1','308',1,'Retail Sale Id 3573',0.00,1501.44,736.00,1501.44,0.00,'2023-03-06 18:30:51'),(3405,'1','308',1,'Retail Sale Id 3574',0.00,5888.00,736.00,5888.00,0.00,'2023-03-06 18:33:10'),(3406,'1','308',1,'Retail Sale Id 3575',0.00,9200.00,736.00,9200.00,0.00,'2023-03-06 18:38:26'),(3407,'1','308',1,'Retail Sale Id 3577',0.00,8471.36,736.00,8471.36,0.00,'2023-03-06 19:45:50'),(3408,'1','308',1,'Retail Sale Id 3578',0.00,4416.00,736.00,4416.00,0.00,'2023-03-07 07:39:50'),(3409,'1','308',1,'Retail Sale Id 3579',0.00,2944.00,736.00,2944.00,0.00,'2023-03-07 07:51:46'),(3410,'1','308',1,'Retail Sale Id 3580',0.00,897.92,736.00,897.92,0.00,'2023-03-07 08:00:45'),(3411,'1','308',1,'Retail Sale Id 3581',0.00,4416.00,736.00,4416.00,0.00,'2023-03-07 08:06:15'),(3412,'1','308',1,'Retail Sale Id 3582',0.00,2944.00,736.00,2944.00,0.00,'2023-03-07 08:10:54'),(3413,'1','308',1,'Retail Sale Id 3583',0.00,2208.00,736.00,2208.00,0.00,'2023-03-07 08:15:54'),(3414,'1','308',1,'Retail Sale Id 3584',0.00,4416.00,736.00,4416.00,0.00,'2023-03-07 08:21:12'),(3415,'1','308',1,'Retail Sale Id 3586',0.00,2208.00,736.00,2208.00,0.00,'2023-03-07 08:30:45'),(3416,'1','308',1,'Retail Sale Id 3587',0.00,1501.44,736.00,1501.44,0.00,'2023-03-07 08:33:27'),(3417,'1','308',1,'Retail Sale Id 3588',0.00,4416.00,736.00,4416.00,0.00,'2023-03-07 08:36:31'),(3418,'1','308',1,'Retail Sale Id 3589',0.00,3002.88,736.00,3002.88,0.00,'2023-03-07 08:42:40'),(3419,'1','308',1,'Retail Sale Id 3590',0.00,22080.00,680.00,20400.00,-1680.00,'2023-03-07 08:46:45'),(3420,'1','308',1,'Retail Sale Id 3591',0.00,2208.00,736.00,2208.00,0.00,'2023-03-07 08:51:09'),(3421,'1','308',1,'Retail Sale Id 3592',0.00,2208.00,736.00,2208.00,0.00,'2023-03-07 08:52:35'),(3422,'1','308',1,'Retail Sale Id 3593',0.00,9200.00,736.00,9200.00,0.00,'2023-03-07 08:54:23'),(3423,'1','308',1,'Retail Sale Id 3594',0.00,3680.00,736.00,3680.00,0.00,'2023-03-07 08:56:16'),(3424,'1','308',1,'Retail Sale Id 3595',0.00,9200.00,736.00,9200.00,0.00,'2023-03-07 09:11:58'),(3425,'1','308',1,'Retail Sale Id 3597',0.00,4416.00,736.00,4416.00,0.00,'2023-03-07 09:26:37'),(3426,'1','308',1,'Retail Sale Id 3598',0.00,2208.00,736.00,2208.00,0.00,'2023-03-07 09:27:42'),(3427,'1','308',1,'Retail Sale Id 3599',0.00,2944.00,736.00,2944.00,0.00,'2023-03-07 09:30:23'),(3428,'1','308',1,'Retail Sale Id 3600',0.00,4416.00,736.00,4416.00,0.00,'2023-03-07 09:32:46'),(3429,'1','308',1,'Retail Sale Id 3601',0.00,1501.44,736.00,1501.44,0.00,'2023-03-07 09:33:56'),(3430,'1','308',1,'Retail Sale Id 3603',0.00,5152.00,736.00,5152.00,0.00,'2023-03-07 09:38:44'),(3431,'1','308',1,'Retail Sale Id 3602',0.00,3503.36,736.00,3503.36,0.00,'2023-03-07 09:46:27'),(3432,'1','308',1,'Retail Sale Id 3604',0.00,750.72,736.00,750.72,0.00,'2023-03-07 09:48:14'),(3433,'1','308',1,'Retail Sale Id 3605',0.00,3680.00,736.00,3680.00,0.00,'2023-03-07 09:52:46'),(3434,'1','308',1,'Retail Sale Id 3606',0.00,7360.00,736.00,7360.00,0.00,'2023-03-07 10:15:54'),(3435,'1','308',1,'Retail Sale Id 3607',0.00,1501.44,736.00,1501.44,0.00,'2023-03-07 10:18:12'),(3436,'1','308',1,'Retail Sale Id 3609',0.00,22080.00,680.00,20400.00,-1680.00,'2023-03-07 10:21:37'),(3437,'1','308',1,'Retail Sale Id 3608',0.00,3680.00,736.00,3680.00,0.00,'2023-03-07 10:23:02'),(3438,'1','308',1,'Retail Sale Id 3610',0.00,1000.96,736.00,1000.96,0.00,'2023-03-07 10:38:38'),(3439,'1','308',1,'Retail Sale Id 3611',0.00,5888.00,736.00,5888.00,0.00,'2023-03-07 10:49:30'),(3440,'1','308',1,'Retail Sale Id 3612',0.00,202400.00,680.00,187000.00,-15400.00,'2023-03-07 11:31:41'),(3441,'1','308',1,'Retail Sale Id 3613',0.00,1501.44,736.00,1501.44,0.00,'2023-03-07 11:46:03'),(3442,'1','308',1,'Retail Sale Id 3614',0.00,2951.36,736.00,2951.36,0.00,'2023-03-07 11:47:56'),(3443,'1','308',1,'Retail Sale Id 3615',0.00,1501.44,736.00,1501.44,0.00,'2023-03-07 12:18:33'),(3444,'1','308',1,'Retail Sale Id 3616',0.00,2936.64,736.00,2936.64,0.00,'2023-03-07 12:32:02'),(3445,'1','308',1,'Retail Sale Id 3617',0.00,1472.00,736.00,1472.00,0.00,'2023-03-07 12:40:33'),(3446,'1','308',1,'Retail Sale Id 3618',0.00,7360.00,736.00,7360.00,0.00,'2023-03-07 13:34:46'),(3447,'1','308',1,'Return of Retail Sale Id 3618',7360.00,0.00,736.00,-7360.00,0.00,'2023-03-07 13:35:40'),(3448,'1','308',1,'Retail Sale Id 3619',0.00,3002.88,736.00,3002.88,0.00,'2023-03-07 14:59:15'),(3449,'1','308',1,'Retail Sale Id 3620',0.00,1000.96,736.00,1000.96,0.00,'2023-03-07 15:51:27'),(3450,'1','308',1,'Retail Sale Id 3621',0.00,3002.88,736.00,3002.88,0.00,'2023-03-07 15:54:50'),(3451,'1','308',1,'Retail Sale Id 3622',0.00,1000.96,736.00,1000.96,0.00,'2023-03-07 16:26:57'),(3452,'1','308',1,'Retail Sale Id 3623',0.00,1501.44,736.00,1501.44,0.00,'2023-03-07 16:48:13'),(3453,'1','308',1,'Retail Sale Id 3624',0.00,736.00,736.00,736.00,0.00,'2023-03-07 17:40:55'),(3454,'1','308',1,'Retail Sale Id 3625',0.00,91646.72,680.00,84673.60,-6973.12,'2023-03-07 18:25:05'),(3455,'1','308',1,'Retail Sale Id 3626',0.00,7485.12,736.00,7485.12,0.00,'2023-03-07 18:26:39'),(3456,'1','308',1,'Retail Sale Id 3627',0.00,7360.00,736.00,7360.00,0.00,'2023-03-08 08:28:30'),(3457,'1','308',1,'Retail Sale Id 3628',0.00,4416.00,736.00,4416.00,0.00,'2023-03-08 08:30:17'),(3458,'1','308',1,'Retail Sale Id 3629',0.00,7360.00,736.00,7360.00,0.00,'2023-03-08 08:31:52'),(3459,'1','308',1,'Retail Sale Id 3630',0.00,5152.00,736.00,5152.00,0.00,'2023-03-08 08:33:46'),(3460,'1','308',1,'Retail Sale Id 3631',0.00,1472.00,736.00,1472.00,0.00,'2023-03-08 08:37:04'),(3461,'1','308',1,'Retail Sale Id 3632',0.00,7360.00,736.00,7360.00,0.00,'2023-03-08 08:38:51'),(3462,'1','308',1,'Retail Sale Id 3633',0.00,4416.00,736.00,4416.00,0.00,'2023-03-08 08:43:19'),(3463,'1','308',1,'Retail Sale Id 3634',0.00,9200.00,736.00,9200.00,0.00,'2023-03-08 08:46:09'),(3464,'1','308',1,'Retail Sale Id 3635',0.00,3680.00,736.00,3680.00,0.00,'2023-03-08 08:49:42'),(3465,'1','308',1,'Retail Sale Id 3636',0.00,21420.00,650.00,22100.00,680.00,'2023-03-08 09:41:36'),(3466,'1','308',1,'Retail Sale Id 3637',0.00,1260.00,700.00,1400.00,140.00,'2023-03-08 09:44:13'),(3467,'1','308',1,'Retail Sale Id 3638',0.00,6930.00,700.00,7700.00,770.00,'2023-03-08 09:45:13'),(3468,'1','308',1,'Retail Sale Id 3639',0.00,1890.00,700.00,2100.00,210.00,'2023-03-08 09:46:03'),(3469,'1','308',1,'Retail Sale Id 3640',0.00,3150.00,700.00,3500.00,350.00,'2023-03-08 09:46:45'),(3470,'1','308',1,'Retail Sale Id 3642',0.00,7875.00,700.00,8750.00,875.00,'2023-03-08 10:07:24'),(3471,'1','308',1,'Retail Sale Id 3643',0.00,18900.00,650.00,19500.00,600.00,'2023-03-08 10:20:49'),(3472,'1','308',1,'Retail Sale Id 3644',0.00,3150.00,700.00,3500.00,350.00,'2023-03-08 10:22:28'),(3473,'1','308',1,'Retail Sale Id 3645',0.00,3780.00,700.00,4200.00,420.00,'2023-03-08 10:36:40'),(3474,'1','308',1,'Retail Sale Id 3646',0.00,2072.70,700.00,2303.00,230.30,'2023-03-08 10:59:33'),(3475,'1','308',1,'Retail Sale Id 3648',0.00,1801.80,700.00,2002.00,200.20,'2023-03-08 12:03:53'),(3476,'1','308',1,'Retail Sale Id 3649',0.00,7875.00,700.00,8750.00,875.00,'2023-03-08 13:32:40'),(3477,'1','308',1,'Retail Sale Id 3650',0.00,1801.80,700.00,2002.00,200.20,'2023-03-08 14:10:39'),(3478,'1','308',1,'Retail Sale Id 3651',0.00,630.00,700.00,700.00,70.00,'2023-03-08 15:22:54'),(3479,'1','308',1,'Retail Sale Id 3652',0.00,2520.00,700.00,2800.00,280.00,'2023-03-08 15:45:41'),(3480,'1','308',1,'Retail Sale Id 3653',0.00,4410.00,700.00,4900.00,490.00,'2023-03-08 16:19:24'),(3481,'1','308',1,'Retail Sale Id 3654',0.00,900.90,700.00,1001.00,100.10,'2023-03-08 16:38:18'),(3482,'1','308',1,'Retail Sale Id 3655',0.00,20160.00,650.00,20800.00,640.00,'2023-03-08 16:45:31'),(3483,'1','308',1,'Retail Sale Id 3656',0.00,2520.00,700.00,2800.00,280.00,'2023-03-08 16:51:28'),(3484,'1','308',1,'Retail Sale Id 3657',0.00,63000.00,650.00,65000.00,2000.00,'2023-03-08 17:37:40'),(3485,'1','308',1,'Retail Sale Id 3658',0.00,630.00,700.00,700.00,70.00,'2023-03-08 17:47:51'),(3486,'1','308',1,'Return of Retail Sale Id 3642',7875.00,0.00,700.00,-8750.00,-875.00,'2023-03-08 19:17:47'),(3487,'1','308',1,'Return of Retail Sale Id 3640',3150.00,0.00,700.00,-3500.00,-350.00,'2023-03-08 19:18:42'),(3488,'1','308',1,'Return of Retail Sale Id 3639',1890.00,0.00,700.00,-2100.00,-210.00,'2023-03-08 19:19:24'),(3489,'1','308',1,'Retail Sale Id 3659',0.00,50.40,700.00,56.00,5.60,'2023-03-08 19:20:32'),(3490,'1','308',1,'Retail Sale Id 3660',0.00,71190.00,650.00,73450.00,2260.00,'2023-03-08 19:22:39'),(3491,'1','308',1,'Return of Retail Sale Id 3659',50.40,0.00,700.00,-56.00,-5.60,'2023-03-08 19:27:56'),(3492,'1','308',1,'Retail Sale Id 3661',0.00,63.00,700.00,70.00,7.00,'2023-03-08 19:28:28'),(3493,'1','308',1,'Retail Sale Id 3662',0.00,3744.00,700.00,4200.00,456.00,'2023-03-09 08:08:25'),(3494,'1','308',1,'Retail Sale Id 3663',0.00,2496.00,700.00,2800.00,304.00,'2023-03-09 08:12:24'),(3495,'1','308',1,'Retail Sale Id 3664',0.00,1872.00,700.00,2100.00,228.00,'2023-03-09 08:19:55'),(3496,'1','308',1,'Retail Sale Id 3665',0.00,1872.00,700.00,2100.00,228.00,'2023-03-09 08:29:38'),(3497,'1','308',1,'Retail Sale Id 3666',0.00,18720.00,658.00,19740.00,1020.00,'2023-03-09 09:01:32'),(3498,'1','308',1,'Retail Sale Id 3667',0.00,1784.64,700.00,2002.00,217.36,'2023-03-09 09:03:39'),(3499,'1','308',1,'Retail Sale Id 3668',0.00,6240.00,700.00,7000.00,760.00,'2023-03-09 09:09:46'),(3500,'1','308',1,'Retail Sale Id 3669',0.00,3120.00,700.00,3500.00,380.00,'2023-03-09 09:12:14'),(3501,'1','308',1,'Retail Sale Id 3670',0.00,7800.00,700.00,8750.00,950.00,'2023-03-09 09:23:39'),(3502,'1','308',1,'Retail Sale Id 3671',0.00,6240.00,700.00,7000.00,760.00,'2023-03-09 09:58:22'),(3503,'1','308',1,'Retail Sale Id 3672',0.00,1248.00,700.00,1400.00,152.00,'2023-03-09 10:28:36'),(3504,'1','308',1,'Retail Sale Id 3673',0.00,1248.00,700.00,1400.00,152.00,'2023-03-09 10:31:04'),(3505,'1','308',1,'Retail Sale Id 3674',0.00,3744.00,700.00,4200.00,456.00,'2023-03-09 10:47:09'),(3506,'1','308',1,'Retail Sale Id 3675',0.00,624.00,700.00,700.00,76.00,'2023-03-09 10:52:37'),(3507,'1','308',1,'Retail Sale Id 3676',0.00,1248.00,700.00,1400.00,152.00,'2023-03-09 11:27:30'),(3508,'1','308',1,'Retail Sale Id 3677',0.00,3120.00,700.00,3500.00,380.00,'2023-03-09 11:28:30'),(3509,'1','308',1,'Retail Sale Id 3678',0.00,1872.00,700.00,2100.00,228.00,'2023-03-09 11:30:48'),(3510,'1','308',1,'Retail Sale Id 3679',0.00,3744.00,700.00,4200.00,456.00,'2023-03-09 11:56:15'),(3511,'1','308',1,'Retail Sale Id 3680',0.00,1872.00,700.00,2100.00,228.00,'2023-03-09 12:16:27'),(3512,'1','308',1,'Retail Sale Id 3681',0.00,624.00,700.00,700.00,76.00,'2023-03-09 12:19:13'),(3513,'1','308',1,'Retail Sale Id 3682',0.00,1248.00,700.00,1400.00,152.00,'2023-03-09 12:31:30'),(3514,'1','308',1,'Retail Sale Id 3683',0.00,3744.00,700.00,4200.00,456.00,'2023-03-09 12:57:37'),(3515,'1','308',1,'Retail Sale Id 3684',0.00,1872.00,700.00,2100.00,228.00,'2023-03-09 13:16:36'),(3516,'1','308',1,'Retail Sale Id 3685',0.00,3744.00,700.00,4200.00,456.00,'2023-03-09 14:11:14'),(3517,'1','308',1,'Retail Sale Id 3686',0.00,3744.00,700.00,4200.00,456.00,'2023-03-09 14:14:39'),(3518,'1','308',1,'Retail Sale Id 3687',0.00,2496.00,700.00,2800.00,304.00,'2023-03-09 14:26:11'),(3519,'1','308',1,'Retail Sale Id 3688',0.00,3744.00,700.00,4200.00,456.00,'2023-03-09 15:13:27'),(3520,'1','308',1,'Retail Sale Id 3689',0.00,1872.00,700.00,2100.00,228.00,'2023-03-09 15:16:45'),(3521,'1','308',1,'Retail Sale Id 3690',0.00,3120.00,700.00,3500.00,380.00,'2023-03-09 15:17:51'),(3522,'1','308',1,'Retail Sale Id 3691',0.00,2496.00,700.00,2800.00,304.00,'2023-03-09 15:18:55'),(3523,'1','308',1,'Retail Sale Id 3692',0.00,7800.00,700.00,8750.00,950.00,'2023-03-09 15:20:34'),(3524,'1','308',1,'Retail Sale Id 3693',0.00,892.32,700.00,1001.00,108.68,'2023-03-09 15:31:15'),(3525,'1','308',1,'Retail Sale Id 3694',0.00,3744.00,700.00,4200.00,456.00,'2023-03-09 15:39:56'),(3526,'1','308',1,'Retail Sale Id 3695',0.00,10920.00,700.00,12250.00,1330.00,'2023-03-09 16:21:53'),(3527,'1','308',1,'Retail Sale Id 3696',0.00,3744.00,700.00,4200.00,456.00,'2023-03-09 16:38:31'),(3528,'1','308',1,'Retail Sale Id 3697',0.00,1248.00,700.00,1400.00,152.00,'2023-03-09 16:45:42'),(3529,'1','308',1,'Retail Sale Id 3698',0.00,15600.00,658.00,16450.00,850.00,'2023-03-09 16:52:06'),(3530,'1','308',1,'Retail Sale Id 3699',0.00,624.00,700.00,700.00,76.00,'2023-03-09 16:55:13'),(3531,'1','308',1,'Retail Sale Id 3700',0.00,1872.00,700.00,2100.00,228.00,'2023-03-09 16:56:40'),(3532,'1','308',1,'Retail Sale Id 3701',0.00,1872.00,700.00,2100.00,228.00,'2023-03-09 16:59:31'),(3533,'1','308',1,'Retail Sale Id 3702',0.00,892.32,700.00,1001.00,108.68,'2023-03-09 17:01:35'),(3534,'1','308',1,'Retail Sale Id 3703',0.00,3744.00,700.00,4200.00,456.00,'2023-03-09 17:03:32'),(3535,'1','308',1,'Retail Sale Id 3704',0.00,2496.00,700.00,2800.00,304.00,'2023-03-09 17:21:51'),(3536,'1','308',1,'Retail Sale Id 3705',0.00,18720.00,658.00,19740.00,1020.00,'2023-03-09 17:24:48'),(3537,'1','308',1,'Retail Sale Id 3706',0.00,1160.64,700.00,1302.00,141.36,'2023-03-09 17:28:39'),(3538,'1','308',1,'Retail Sale Id 3707',0.00,1872.00,700.00,2100.00,228.00,'2023-03-09 17:31:17'),(3539,'1','308',1,'Retail Sale Id 3708',0.00,1248.00,700.00,1400.00,152.00,'2023-03-09 17:40:33'),(3540,'1','308',1,'Retail Sale Id 3709',0.00,3120.00,700.00,3500.00,380.00,'2023-03-09 17:42:59'),(3541,'1','308',1,'Retail Sale Id 3710',0.00,1872.00,700.00,2100.00,228.00,'2023-03-09 17:45:46'),(3542,'1','308',1,'Retail Sale Id 3711',0.00,7800.00,700.00,8750.00,950.00,'2023-03-09 17:59:20'),(3543,'1','308',1,'Retail Sale Id 3712',0.00,1248.00,700.00,1400.00,152.00,'2023-03-09 18:02:39'),(3544,'1','308',1,'Retail Sale Id 3713',0.00,3120.00,700.00,3500.00,380.00,'2023-03-09 18:10:08'),(3545,'1','308',1,'Retail Sale Id 3714',0.00,1872.00,700.00,2100.00,228.00,'2023-03-09 18:22:15'),(3546,'1','308',1,'Retail Sale Id 3715',0.00,1872.00,700.00,2100.00,228.00,'2023-03-09 18:23:28'),(3547,'1','308',1,'Retail Sale Id 3716',0.00,1872.00,700.00,2100.00,228.00,'2023-03-09 18:25:29'),(3548,'1','308',1,'Retail Sale Id 3717',0.00,3120.00,700.00,3500.00,380.00,'2023-03-09 18:26:39'),(3549,'1','308',1,'Retail Sale Id 3718',0.00,9360.00,700.00,10500.00,1140.00,'2023-03-09 18:28:51'),(3550,'1','308',1,'Retail Sale Id 3719',0.00,3744.00,700.00,4200.00,456.00,'2023-03-09 18:30:42'),(3551,'1','308',1,'Retail Sale Id 3720',0.00,1872.00,700.00,2100.00,228.00,'2023-03-09 18:32:33'),(3552,'1','308',1,'Retail Sale Id 3720',0.00,1872.00,700.00,2100.00,228.00,'2023-03-09 18:32:33'),(3553,'1','308',1,'Return of Retail Sale Id 3720',1872.00,0.00,700.00,-2100.00,-228.00,'2023-03-09 18:33:02'),(3554,'1','308',1,'Return of Retail Sale Id 3720',1872.00,0.00,700.00,-2100.00,-228.00,'2023-03-09 18:33:02'),(3555,'1','308',1,'Retail Sale Id 3721',0.00,21128.64,700.00,23702.00,2573.36,'2023-03-09 19:29:14'),(3556,'1','308',1,'Retail Sale Id 3722',0.00,1248.00,700.00,1400.00,152.00,'2023-03-10 07:27:13'),(3557,'1','308',1,'Retail Sale Id 3724',0.00,1872.00,700.00,2100.00,228.00,'2023-03-10 07:29:08'),(3558,'1','308',1,'Retail Sale Id 3725',0.00,3744.00,700.00,4200.00,456.00,'2023-03-10 07:31:29'),(3559,'1','308',1,'Retail Sale Id 3726',0.00,624.00,700.00,700.00,76.00,'2023-03-10 07:36:58'),(3560,'1','308',1,'Retail Sale Id 3727',0.00,1248.00,700.00,1400.00,152.00,'2023-03-10 07:46:39'),(3561,'1','308',1,'Retail Sale Id 3728',0.00,2496.00,700.00,2800.00,304.00,'2023-03-10 07:48:33'),(3562,'1','308',1,'Retail Sale Id 3729',0.00,3120.00,700.00,3500.00,380.00,'2023-03-10 08:12:12'),(3563,'1','308',1,'Retail Sale Id 3730',0.00,3120.00,700.00,3500.00,380.00,'2023-03-10 08:34:00'),(3564,'1','308',1,'Retail Sale Id 3731',0.00,1872.00,700.00,2100.00,228.00,'2023-03-10 08:38:59'),(3565,'1','308',1,'Retail Sale Id 3734',0.00,624.00,700.00,700.00,76.00,'2023-03-10 08:42:34'),(3566,'1','308',1,'Retail Sale Id 3735',0.00,6240.00,700.00,7000.00,760.00,'2023-03-10 08:49:07'),(3567,'1','308',1,'Retail Sale Id 3736',0.00,2496.00,700.00,2800.00,304.00,'2023-03-10 08:51:04'),(3568,'1','308',1,'Retail Sale Id 3737',0.00,1784.64,700.00,2002.00,217.36,'2023-03-10 08:52:54'),(3569,'1','308',1,'Retail Sale Id 3738',0.00,5616.00,700.00,6300.00,684.00,'2023-03-10 09:09:24'),(3570,'1','308',1,'Retail Sale Id 3739',0.00,1872.00,700.00,2100.00,228.00,'2023-03-10 09:10:43'),(3571,'1','308',1,'Retail Sale Id 3740',0.00,3744.00,700.00,4200.00,456.00,'2023-03-10 09:26:24'),(3572,'1','308',1,'Retail Sale Id 3741',0.00,40248.00,658.00,42441.00,2193.00,'2023-03-10 11:07:16'),(3573,'1','308',1,'Retail Sale Id 3742',0.00,892.32,700.00,1001.00,108.68,'2023-03-10 11:17:40'),(3574,'1','308',1,'Retail Sale Id 3743',0.00,1335.36,700.00,1498.00,162.64,'2023-03-10 11:57:27'),(3575,'1','308',1,'Retail Sale Id 3745',0.00,23088.00,658.00,24346.00,1258.00,'2023-03-10 12:51:01'),(3576,'1','308',1,'Retail Sale Id 3746',0.00,3744.00,700.00,4200.00,456.00,'2023-03-10 13:07:41'),(3577,'1','308',1,'Retail Sale Id 3747',0.00,3120.00,700.00,3500.00,380.00,'2023-03-10 13:51:02'),(3578,'1','308',1,'Retail Sale Id 3748',0.00,1248.00,700.00,1400.00,152.00,'2023-03-10 13:59:22'),(3579,'1','308',1,'Retail Sale Id 3749',0.00,624.00,700.00,700.00,76.00,'2023-03-10 14:00:58'),(3580,'1','308',1,'Retail Sale Id 3750',0.00,624.00,700.00,700.00,76.00,'2023-03-10 14:12:52'),(3581,'1','308',1,'Retail Sale Id 3751',0.00,4455.36,700.00,4998.00,542.64,'2023-03-10 14:22:29'),(3582,'1','308',1,'Retail Sale Id 3752',0.00,7800.00,700.00,8750.00,950.00,'2023-03-10 14:30:26'),(3583,'1','308',1,'Retail Sale Id 3753',0.00,2676.96,700.00,3003.00,326.04,'2023-03-10 14:52:50'),(3584,'1','308',1,'Retail Sale Id 3754',0.00,892.32,700.00,1001.00,108.68,'2023-03-10 15:02:24'),(3585,'1','308',1,'Retail Sale Id 3755',0.00,1872.00,700.00,2100.00,228.00,'2023-03-10 15:21:33'),(3586,'1','308',1,'Retail Sale Id 3756',0.00,3120.00,700.00,3500.00,380.00,'2023-03-10 15:49:25'),(3587,'1','308',1,'Retail Sale Id 3758',0.00,1248.00,700.00,1400.00,152.00,'2023-03-10 16:45:35'),(3588,'1','308',1,'Retail Sale Id 3759',0.00,2227.68,700.00,2499.00,271.32,'2023-03-10 17:31:32'),(3589,'1','308',1,'Return of Retail Sale Id 3752',7800.00,0.00,700.00,-8750.00,-950.00,'2023-03-10 19:21:29'),(3590,'1','308',1,'Retail Sale Id 3760',0.00,4673.76,700.00,5243.00,569.24,'2023-03-10 19:24:40'),(3591,'1','308',1,'Retail Sale Id 3761',0.00,47112.00,658.00,49679.00,2567.00,'2023-03-10 19:26:36'),(3592,'1','308',1,'Retail Sale Id 3762',0.00,624.00,700.00,700.00,76.00,'2023-03-11 07:40:58'),(3593,'1','308',1,'Retail Sale Id 3763',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 07:43:14'),(3594,'1','308',1,'Retail Sale Id 3764',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 07:55:53'),(3595,'1','308',1,'Retail Sale Id 3765',0.00,624.00,700.00,700.00,76.00,'2023-03-11 08:00:31'),(3596,'1','308',1,'Retail Sale Id 3766',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 08:02:00'),(3597,'1','308',1,'Retail Sale Id 3767',0.00,1248.00,700.00,1400.00,152.00,'2023-03-11 08:03:23'),(3598,'1','308',1,'Retail Sale Id 3768',0.00,18720.00,658.00,19740.00,1020.00,'2023-03-11 08:05:43'),(3599,'1','308',1,'Retail Sale Id 3769',0.00,3120.00,700.00,3500.00,380.00,'2023-03-11 08:12:28'),(3600,'1','308',1,'Retail Sale Id 3770',0.00,3744.00,700.00,4200.00,456.00,'2023-03-11 08:15:23'),(3601,'1','308',1,'Retail Sale Id 3771',0.00,3120.00,700.00,3500.00,380.00,'2023-03-11 08:16:48'),(3602,'1','308',1,'Retail Sale Id 3772',0.00,3744.00,700.00,4200.00,456.00,'2023-03-11 08:18:23'),(3603,'1','308',1,'Retail Sale Id 3773',0.00,1784.64,700.00,2002.00,217.36,'2023-03-11 08:20:05'),(3604,'1','308',1,'Retail Sale Id 3774',0.00,7800.00,700.00,8750.00,950.00,'2023-03-11 08:22:49'),(3605,'1','308',1,'Retail Sale Id 3775',0.00,11544.00,700.00,12950.00,1406.00,'2023-03-11 08:25:07'),(3606,'1','308',1,'Retail Sale Id 3776',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 08:27:03'),(3607,'1','308',1,'Retail Sale Id 3777',0.00,2496.00,700.00,2800.00,304.00,'2023-03-11 08:45:17'),(3608,'1','308',1,'Retail Sale Id 3778',0.00,3120.00,700.00,3500.00,380.00,'2023-03-11 08:51:58'),(3609,'1','308',1,'Retail Sale Id 3779',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 08:53:32'),(3610,'1','308',1,'Retail Sale Id 3780',0.00,2496.00,700.00,2800.00,304.00,'2023-03-11 08:56:02'),(3611,'1','308',1,'Retail Sale Id 3781',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 09:17:45'),(3612,'1','308',1,'Retail Sale Id 3782',0.00,3744.00,700.00,4200.00,456.00,'2023-03-11 09:24:50'),(3613,'1','308',1,'Retail Sale Id 3783',0.00,2496.00,700.00,2800.00,304.00,'2023-03-11 09:38:11'),(3614,'1','308',1,'Retail Sale Id 3784',0.00,1248.00,700.00,1400.00,152.00,'2023-03-11 09:42:42'),(3615,'1','308',1,'Retail Sale Id 3785',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 09:57:41'),(3616,'1','308',1,'Retail Sale Id 3786',0.00,62400.00,658.00,65800.00,3400.00,'2023-03-11 10:02:17'),(3617,'1','308',1,'Retail Sale Id 3787',0.00,1784.64,700.00,2002.00,217.36,'2023-03-11 10:06:19'),(3618,'1','308',1,'Retail Sale Id 3788',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 10:12:10'),(3619,'1','308',1,'Retail Sale Id 3789',0.00,3120.00,700.00,3500.00,380.00,'2023-03-11 10:16:54'),(3620,'1','308',1,'Retail Sale Id 3790',0.00,7488.00,700.00,8400.00,912.00,'2023-03-11 10:34:40'),(3621,'1','308',1,'Retail Sale Id 3791',0.00,18720.00,658.00,19740.00,1020.00,'2023-03-11 11:06:11'),(3622,'1','308',1,'Retail Sale Id 3792',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 11:07:36'),(3623,'1','308',1,'Retail Sale Id 3793',0.00,3120.00,700.00,3500.00,380.00,'2023-03-11 11:09:44'),(3624,'1','308',1,'Retail Sale Id 3794',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 11:24:22'),(3625,'1','308',1,'Retail Sale Id 3795',0.00,7800.00,700.00,8750.00,950.00,'2023-03-11 12:04:10'),(3626,'1','308',1,'Retail Sale Id 3796',0.00,7800.00,700.00,8750.00,950.00,'2023-03-11 12:18:46'),(3627,'1','308',1,'Retail Sale Id 3797',0.00,1335.36,700.00,1498.00,162.64,'2023-03-11 12:21:00'),(3628,'1','308',1,'Retail Sale Id 3798',0.00,1335.36,700.00,1498.00,162.64,'2023-03-11 12:31:03'),(3629,'1','308',1,'Retail Sale Id 3799',0.00,2496.00,700.00,2800.00,304.00,'2023-03-11 12:33:20'),(3630,'1','308',1,'Retail Sale Id 3800',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 12:42:06'),(3631,'1','308',1,'Retail Sale Id 3801',0.00,3120.00,700.00,3500.00,380.00,'2023-03-11 12:47:28'),(3632,'1','308',1,'Retail Sale Id 3802',0.00,3120.00,700.00,3500.00,380.00,'2023-03-11 12:56:27'),(3633,'1','308',1,'Retail Sale Id 3803',0.00,3744.00,700.00,4200.00,456.00,'2023-03-11 13:13:39'),(3634,'1','308',1,'Retail Sale Id 3804',0.00,72384.00,658.00,76328.00,3944.00,'2023-03-11 13:21:31'),(3635,'1','308',1,'Retail Sale Id 3805',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-11 13:24:21'),(3636,'1','308',1,'Retail Sale Id 3806',0.00,624.00,700.00,700.00,76.00,'2023-03-11 13:25:45'),(3637,'1','308',1,'Retail Sale Id 3807',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 13:27:29'),(3638,'1','308',1,'Retail Sale Id 3808',0.00,3744.00,700.00,4200.00,456.00,'2023-03-11 13:38:43'),(3639,'1','308',1,'Retail Sale Id 3809',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 14:00:39'),(3640,'1','308',1,'Retail Sale Id 3810',0.00,3120.00,700.00,3500.00,380.00,'2023-03-11 14:15:49'),(3641,'1','308',1,'Retail Sale Id 3811',0.00,3563.04,700.00,3997.00,433.96,'2023-03-11 14:33:28'),(3642,'1','308',1,'Retail Sale Id 3812',0.00,7800.00,700.00,8750.00,950.00,'2023-03-11 14:44:11'),(3643,'1','308',1,'Retail Sale Id 3813',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 15:15:56'),(3644,'1','308',1,'Retail Sale Id 3814',0.00,3744.00,700.00,4200.00,456.00,'2023-03-11 15:23:01'),(3645,'1','308',1,'Retail Sale Id 3815',0.00,2496.00,700.00,2800.00,304.00,'2023-03-11 15:29:56'),(3646,'1','308',1,'Retail Sale Id 3816',0.00,624.00,700.00,700.00,76.00,'2023-03-11 15:41:22'),(3647,'1','308',1,'Retail Sale Id 3817',0.00,624.00,700.00,700.00,76.00,'2023-03-11 16:07:18'),(3648,'1','308',1,'Retail Sale Id 3818',0.00,624.00,700.00,700.00,76.00,'2023-03-11 16:10:08'),(3649,'1','308',1,'Retail Sale Id 3819',0.00,1248.00,700.00,1400.00,152.00,'2023-03-11 16:38:43'),(3650,'1','308',1,'Retail Sale Id 3820',0.00,1248.00,700.00,1400.00,152.00,'2023-03-11 16:49:58'),(3651,'1','308',1,'Retail Sale Id 3821',0.00,1248.00,700.00,1400.00,152.00,'2023-03-11 16:50:51'),(3652,'1','308',1,'Retail Sale Id 3822',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 17:07:45'),(3653,'1','308',1,'Retail Sale Id 3823',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 17:20:09'),(3654,'1','308',1,'Retail Sale Id 3826',0.00,3762.72,700.00,4221.00,458.28,'2023-03-11 18:04:32'),(3655,'1','308',1,'Retail Sale Id 3827',0.00,1248.00,700.00,1400.00,152.00,'2023-03-12 07:23:49'),(3656,'1','308',1,'Retail Sale Id 3828',0.00,1872.00,700.00,2100.00,228.00,'2023-03-12 07:25:21'),(3657,'1','308',1,'Retail Sale Id 3829',0.00,4368.00,700.00,4900.00,532.00,'2023-03-12 07:35:48'),(3658,'1','308',1,'Retail Sale Id 3830',0.00,62400.00,658.00,65800.00,3400.00,'2023-03-12 07:50:26'),(3659,'1','308',1,'Retail Sale Id 3831',0.00,1335.36,700.00,1498.00,162.64,'2023-03-12 07:51:29'),(3660,'1','308',1,'Retail Sale Id 3832',0.00,1872.00,700.00,2100.00,228.00,'2023-03-12 07:52:40'),(3661,'1','308',1,'Retail Sale Id 3833',0.00,3744.00,700.00,4200.00,456.00,'2023-03-12 07:53:48'),(3662,'1','308',1,'Retail Sale Id 3834',0.00,3120.00,700.00,3500.00,380.00,'2023-03-12 08:00:59'),(3663,'1','308',1,'Retail Sale Id 3835',0.00,443.04,700.00,497.00,53.96,'2023-03-12 08:02:02'),(3664,'1','308',1,'Retail Sale Id 3836',0.00,3120.00,700.00,3500.00,380.00,'2023-03-12 08:06:06'),(3665,'1','308',1,'Retail Sale Id 3837',0.00,2676.96,700.00,3003.00,326.04,'2023-03-12 08:11:20'),(3666,'1','308',1,'Retail Sale Id 3838',0.00,1248.00,700.00,1400.00,152.00,'2023-03-12 08:21:07'),(3667,'1','308',1,'Retail Sale Id 3839',0.00,1872.00,700.00,2100.00,228.00,'2023-03-12 08:23:16'),(3668,'1','308',1,'Retail Sale Id 3840',0.00,6240.00,700.00,7000.00,760.00,'2023-03-12 08:40:36'),(3669,'1','308',1,'Retail Sale Id 3841',0.00,624.00,700.00,700.00,76.00,'2023-03-12 08:49:02'),(3670,'1','308',1,'Retail Sale Id 3842',0.00,1784.64,700.00,2002.00,217.36,'2023-03-12 09:02:18'),(3671,'1','308',1,'Retail Sale Id 3843',0.00,1691.04,700.00,1897.00,205.96,'2023-03-12 09:17:12'),(3672,'1','308',1,'Retail Sale Id 3844',0.00,1248.00,700.00,1400.00,152.00,'2023-03-12 09:27:18'),(3673,'1','308',1,'Retail Sale Id 3845',0.00,4992.00,700.00,5600.00,608.00,'2023-03-12 09:36:45'),(3674,'1','308',1,'Retail Sale Id 3846',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-12 10:54:52'),(3675,'1','308',1,'Retail Sale Id 3847',0.00,43680.00,658.00,46060.00,2380.00,'2023-03-12 12:48:57'),(3676,'1','308',1,'Retail Sale Id 3848',0.00,443.04,700.00,497.00,53.96,'2023-03-12 13:17:06'),(3677,'1','308',1,'Retail Sale Id 3849',0.00,2496.00,700.00,2800.00,304.00,'2023-03-12 13:37:19'),(3678,'1','308',1,'Retail Sale Id 3851',0.00,892.32,700.00,1001.00,108.68,'2023-03-12 15:37:11'),(3679,'1','308',1,'Retail Sale Id 3852',0.00,2676.96,700.00,3003.00,326.04,'2023-03-12 15:39:09'),(3680,'1','308',1,'Retail Sale Id 3853',0.00,1872.00,700.00,2100.00,228.00,'2023-03-12 15:52:00'),(3681,'1','308',1,'Retail Sale Id 3854',0.00,49920.00,658.00,52640.00,2720.00,'2023-03-12 16:03:36'),(3682,'1','308',1,'Retail Sale Id 3855',0.00,2227.68,700.00,2499.00,271.32,'2023-03-12 16:16:34'),(3683,'1','308',1,'Retail Sale Id 3856',0.00,6240.00,700.00,7000.00,760.00,'2023-03-12 16:31:09'),(3684,'1','308',1,'Retail Sale Id 3857',0.00,18720.00,658.00,19740.00,1020.00,'2023-03-12 16:44:44'),(3685,'1','308',1,'Retail Sale Id 3858',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-12 16:46:23'),(3686,'1','308',1,'Retail Sale Id 3859',0.00,624.00,700.00,700.00,76.00,'2023-03-12 17:20:19'),(3687,'1','308',1,'Retail Sale Id 3860',0.00,1872.00,700.00,2100.00,228.00,'2023-03-12 17:38:28'),(3688,'1','308',1,'Retail Sale Id 3861',0.00,624.00,700.00,700.00,76.00,'2023-03-12 17:39:57'),(3689,'1','308',1,'Retail Sale Id 3862',0.00,2496.00,700.00,2800.00,304.00,'2023-03-12 18:21:50'),(3690,'1','308',1,'Retail Sale Id 3863',0.00,38376.00,658.00,40467.00,2091.00,'2023-03-12 18:43:21'),(3691,'1','308',1,'Retail Sale Id 3864',0.00,1341.60,700.00,1505.00,163.40,'2023-03-12 18:44:13'),(3692,'1','308',1,'Retail Sale Id 3865',0.00,1872.00,700.00,2100.00,228.00,'2023-03-13 07:39:44'),(3693,'1','308',1,'Retail Sale Id 3866',0.00,2676.96,700.00,3003.00,326.04,'2023-03-13 07:41:16'),(3694,'1','308',1,'Retail Sale Id 3867',0.00,1872.00,700.00,2100.00,228.00,'2023-03-13 07:44:20'),(3695,'1','308',1,'Retail Sale Id 3868',0.00,2496.00,700.00,2800.00,304.00,'2023-03-13 07:57:57'),(3696,'1','308',1,'Retail Sale Id 3869',0.00,5616.00,700.00,6300.00,684.00,'2023-03-13 08:01:43'),(3697,'1','308',1,'Retail Sale Id 3870',0.00,1248.00,700.00,1400.00,152.00,'2023-03-13 08:09:08'),(3698,'1','308',1,'Retail Sale Id 3871',0.00,624.00,700.00,700.00,76.00,'2023-03-13 08:30:37'),(3699,'1','308',1,'Retail Sale Id 3872',0.00,3120.00,700.00,3500.00,380.00,'2023-03-13 08:32:50'),(3700,'1','308',1,'Retail Sale Id 3873',0.00,1248.00,700.00,1400.00,152.00,'2023-03-13 08:57:21'),(3701,'1','308',1,'Retail Sale Id 3874',0.00,62400.00,658.00,65800.00,3400.00,'2023-03-13 09:13:27'),(3702,'1','308',1,'Retail Sale Id 3875',0.00,18720.00,658.00,19740.00,1020.00,'2023-03-13 09:26:07'),(3703,'1','308',1,'Retail Sale Id 3876',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-13 09:27:56'),(3704,'1','308',1,'Retail Sale Id 3877',0.00,6864.00,700.00,7700.00,836.00,'2023-03-13 09:30:29'),(3705,'1','308',1,'Retail Sale Id 3878',0.00,1248.00,700.00,1400.00,152.00,'2023-03-13 09:42:49'),(3706,'1','308',1,'Retail Sale Id 3879',0.00,1872.00,700.00,2100.00,228.00,'2023-03-13 09:53:59'),(3707,'1','308',1,'Retail Sale Id 3880',0.00,62400.00,658.00,65800.00,3400.00,'2023-03-13 10:37:29'),(3708,'1','308',1,'Retail Sale Id 3881',0.00,1734.72,700.00,1946.00,211.28,'2023-03-13 11:07:31'),(3709,'1','308',1,'Return of Retail Sale Id 3876',31200.00,0.00,658.00,-32900.00,-1700.00,'2023-03-13 11:36:30'),(3710,'1','308',1,'Retail Sale Id 3882',0.00,31112.64,658.00,32807.88,1695.24,'2023-03-13 11:38:02'),(3711,'1','308',1,'Sale Id 3',0.00,6202.56,624.00,6202.56,0.00,'2023-03-13 11:41:28'),(3714,'1','308',1,'Retail Sale Id 3885',0.00,3744.00,700.00,4200.00,456.00,'2023-03-13 13:32:01'),(3715,'1','308',1,'Retail Sale Id 3886',0.00,171600.00,658.00,180950.00,9350.00,'2023-03-13 13:34:10'),(3716,'1','308',1,'Retail Sale Id 3887',0.00,7800.00,700.00,8750.00,950.00,'2023-03-13 13:34:47'),(3717,'1','308',1,'Retail Sale Id 3889',0.00,1248.00,700.00,1400.00,152.00,'2023-03-13 14:25:08'),(3718,'1','308',1,'Retail Sale Id 3890',0.00,3744.00,700.00,4200.00,456.00,'2023-03-13 14:38:26'),(3719,'1','308',1,'Retail Sale Id 3892',0.00,1248.00,700.00,1400.00,152.00,'2023-03-13 14:55:19'),(3720,'1','308',1,'Retail Sale Id 3893',0.00,7488.00,700.00,8400.00,912.00,'2023-03-13 15:12:13'),(3721,'1','308',1,'Retail Sale Id 3894',0.00,3563.04,700.00,3997.00,433.96,'2023-03-13 15:17:51'),(3722,'1','308',1,'Retail Sale Id 3895',0.00,624.00,700.00,700.00,76.00,'2023-03-13 15:35:12'),(3723,'1','308',1,'Retail Sale Id 3896',0.00,3744.00,700.00,4200.00,456.00,'2023-03-13 15:44:39'),(3724,'1','308',1,'Retail Sale Id 3897',0.00,3120.00,700.00,3500.00,380.00,'2023-03-13 16:00:45'),(3725,'1','308',1,'Retail Sale Id 3898',0.00,1248.00,700.00,1400.00,152.00,'2023-03-13 16:02:03'),(3726,'1','308',1,'Retail Sale Id 3900',0.00,3744.00,700.00,4200.00,456.00,'2023-03-13 16:16:36'),(3727,'1','308',1,'Retail Sale Id 3901',0.00,1959.36,700.00,2198.00,238.64,'2023-03-13 16:19:12'),(3728,'1','308',1,'Retail Sale Id 3902',0.00,624.00,700.00,700.00,76.00,'2023-03-13 16:28:05'),(3729,'1','308',1,'Retail Sale Id 3903',0.00,979.68,700.00,1099.00,119.32,'2023-03-13 16:42:58'),(3730,'1','308',1,'Retail Sale Id 3904',0.00,7800.00,700.00,8750.00,950.00,'2023-03-13 16:47:15'),(3731,'1','308',1,'Retail Sale Id 3905',0.00,1248.00,700.00,1400.00,152.00,'2023-03-13 17:13:04'),(3732,'1','308',1,'Retail Sale Id 3906',0.00,3744.00,700.00,4200.00,456.00,'2023-03-13 17:34:46'),(3733,'1','308',1,'Retail Sale Id 3907',0.00,1248.00,700.00,1400.00,152.00,'2023-03-13 17:38:08'),(3734,'1','308',1,'Retail Sale Id 3908',0.00,6240.00,700.00,7000.00,760.00,'2023-03-13 17:40:38'),(3735,'1','308',1,'Retail Sale Id 3909',0.00,7800.00,700.00,8750.00,950.00,'2023-03-13 17:42:08'),(3736,'1','308',1,'Retail Sale Id 3910',0.00,1248.00,700.00,1400.00,152.00,'2023-03-13 17:44:32'),(3737,'1','308',1,'Retail Sale Id 3911',0.00,6240.00,700.00,7000.00,760.00,'2023-03-13 17:51:47'),(3738,'1','308',1,'Retail Sale Id 3912',0.00,1872.00,700.00,2100.00,228.00,'2023-03-13 18:23:59'),(3739,'1','308',1,'Retail Sale Id 3913',0.00,1872.00,700.00,2100.00,228.00,'2023-03-13 18:28:36'),(3740,'1','308',1,'Retail Sale Id 3914',0.00,1872.00,700.00,2100.00,228.00,'2023-03-13 18:31:25'),(3741,'1','308',1,'Retail Sale Id 3915',0.00,1872.00,700.00,2100.00,228.00,'2023-03-13 18:32:48'),(3742,'1','308',1,'Retail Sale Id 3916',0.00,4361.76,700.00,4893.00,531.24,'2023-03-13 19:28:20'),(3743,'1','308',1,'Retail Sale Id 3917',0.00,31206.24,658.00,32906.58,1700.34,'2023-03-13 19:30:47'),(3744,'1','308',1,'Retail Sale Id 3918',0.00,892.32,700.00,1001.00,108.68,'2023-03-14 07:20:25'),(3745,'1','308',1,'Retail Sale Id 3919',0.00,7800.00,700.00,8750.00,950.00,'2023-03-14 07:21:20'),(3746,'1','308',1,'Retail Sale Id 3920',0.00,1248.00,700.00,1400.00,152.00,'2023-03-14 07:22:44'),(3747,'1','308',1,'Retail Sale Id 3921',0.00,3744.00,700.00,4200.00,456.00,'2023-03-14 07:37:27'),(3748,'1','308',1,'Retail Sale Id 3922',0.00,19968.00,658.00,21056.00,1088.00,'2023-03-14 07:49:07'),(3749,'1','308',1,'Retail Sale Id 3923',0.00,1872.00,700.00,2100.00,228.00,'2023-03-14 07:52:07'),(3750,'1','308',1,'Retail Sale Id 3924',0.00,1335.36,700.00,1498.00,162.64,'2023-03-14 07:55:57'),(3751,'1','308',1,'Retail Sale Id 3925',0.00,1872.00,700.00,2100.00,228.00,'2023-03-14 08:07:00'),(3752,'1','308',1,'Retail Sale Id 3926',0.00,1248.00,700.00,1400.00,152.00,'2023-03-14 08:12:30'),(3753,'1','308',1,'Retail Sale Id 3927',0.00,2496.00,700.00,2800.00,304.00,'2023-03-14 08:21:12'),(3754,'1','308',1,'Retail Sale Id 3928',0.00,624.00,700.00,700.00,76.00,'2023-03-14 09:24:57'),(3755,'1','308',1,'Retail Sale Id 3929',0.00,1248.00,700.00,1400.00,152.00,'2023-03-14 09:31:47'),(3756,'1','308',1,'Retail Sale Id 3930',0.00,624.00,700.00,700.00,76.00,'2023-03-14 09:38:55'),(3757,'1','308',1,'Retail Sale Id 3931',0.00,1872.00,700.00,2100.00,228.00,'2023-03-14 09:41:27'),(3758,'1','308',1,'Retail Sale Id 3932',0.00,7800.00,700.00,8750.00,950.00,'2023-03-14 10:02:59'),(3759,'1','308',1,'Retail Sale Id 3933',0.00,1248.00,700.00,1400.00,152.00,'2023-03-14 10:09:19'),(3760,'1','308',1,'Retail Sale Id 3934',0.00,3744.00,700.00,4200.00,456.00,'2023-03-14 10:25:43'),(3761,'1','308',1,'Retail Sale Id 3935',0.00,18720.00,658.00,19740.00,1020.00,'2023-03-14 10:42:53'),(3762,'1','308',1,'Retail Sale Id 3936',0.00,2496.00,700.00,2800.00,304.00,'2023-03-14 15:01:00'),(3763,'1','308',1,'Retail Sale Id 3937',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-14 15:05:06'),(3764,'1','308',1,'Retail Sale Id 3938',0.00,892.32,700.00,1001.00,108.68,'2023-03-14 18:21:57'),(3765,'1','308',1,'Retail Sale Id 3939',0.00,53252.16,658.00,56153.72,2901.56,'2023-03-14 19:05:47'),(3766,'1','308',1,'Return of Retail Sale Id 3934',3744.00,0.00,700.00,-4200.00,-456.00,'2023-03-14 19:07:52'),(3767,'1','308',1,'Retail Sale Id 3940',0.00,355.68,700.00,399.00,43.32,'2023-03-14 19:09:07'),(3768,'1','308',1,'Retail Sale Id 3941',0.00,3120.00,700.00,3500.00,380.00,'2023-03-15 07:13:26'),(3769,'1','308',1,'Retail Sale Id 3942',0.00,892.32,700.00,1001.00,108.68,'2023-03-15 07:14:32'),(3770,'1','308',1,'Retail Sale Id 3943',0.00,1872.00,700.00,2100.00,228.00,'2023-03-15 07:15:25'),(3771,'1','308',1,'Retail Sale Id 3944',0.00,1784.64,700.00,2002.00,217.36,'2023-03-15 08:17:21'),(3772,'1','308',1,'Retail Sale Id 3946',0.00,4455.36,700.00,4998.00,542.64,'2023-03-15 08:34:36'),(3773,'1','308',1,'Retail Sale Id 3947',0.00,62400.00,658.00,65800.00,3400.00,'2023-03-15 08:51:05'),(3774,'1','308',1,'Retail Sale Id 3948',0.00,1248.00,700.00,1400.00,152.00,'2023-03-15 08:59:34'),(3775,'1','308',1,'Retail Sale Id 3949',0.00,2496.00,700.00,2800.00,304.00,'2023-03-15 09:12:47'),(3776,'1','308',1,'Retail Sale Id 3950',0.00,1248.00,700.00,1400.00,152.00,'2023-03-15 09:21:18'),(3777,'1','308',1,'Retail Sale Id 3951',0.00,3120.00,700.00,3500.00,380.00,'2023-03-15 09:52:04'),(3778,'1','308',1,'Retail Sale Id 3952',0.00,15600.00,658.00,16450.00,850.00,'2023-03-15 10:08:48'),(3779,'1','308',1,'Retail Sale Id 3953',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-15 10:15:03'),(3780,'1','308',1,'Retail Sale Id 3954',0.00,1872.00,700.00,2100.00,228.00,'2023-03-15 10:16:52'),(3781,'1','308',1,'Retail Sale Id 3955',0.00,3744.00,700.00,4200.00,456.00,'2023-03-15 10:18:32'),(3782,'1','308',1,'Retail Sale Id 3956',0.00,1560.00,700.00,1750.00,190.00,'2023-03-15 10:36:38'),(3783,'1','308',1,'Retail Sale Id 3957',0.00,3656.64,700.00,4102.00,445.36,'2023-03-15 11:06:37'),(3784,'1','308',1,'Retail Sale Id 3958',0.00,4992.00,700.00,5600.00,608.00,'2023-03-15 11:22:58'),(3785,'1','308',1,'Retail Sale Id 3959',0.00,3744.00,700.00,4200.00,456.00,'2023-03-15 11:38:16'),(3786,'1','308',1,'Retail Sale Id 3960',0.00,3744.00,700.00,4200.00,456.00,'2023-03-15 11:54:07'),(3787,'1','308',1,'Retail Sale Id 3961',0.00,3744.00,700.00,4200.00,456.00,'2023-03-15 11:55:24'),(3788,'1','308',1,'Retail Sale Id 3962',0.00,1248.00,700.00,1400.00,152.00,'2023-03-15 12:07:01'),(3789,'1','308',1,'Retail Sale Id 3963',0.00,1335.36,700.00,1498.00,162.64,'2023-03-15 12:11:21'),(3790,'1','308',1,'Retail Sale Id 3964',0.00,3744.00,700.00,4200.00,456.00,'2023-03-15 12:39:18'),(3791,'1','308',1,'Retail Sale Id 3965',0.00,1248.00,700.00,1400.00,152.00,'2023-03-15 12:41:44'),(3792,'1','308',1,'Return of Retail Sale Id 3964',3744.00,0.00,700.00,-4200.00,-456.00,'2023-03-15 12:43:29'),(3793,'1','308',1,'Retail Sale Id 3968',0.00,3120.00,700.00,3500.00,380.00,'2023-03-15 13:02:38'),(3794,'1','308',1,'Retail Sale Id 3969',0.00,1248.00,700.00,1400.00,152.00,'2023-03-15 13:06:13'),(3795,'1','308',1,'Retail Sale Id 3970',0.00,3120.00,700.00,3500.00,380.00,'2023-03-15 13:20:26'),(3796,'1','308',1,'Retail Sale Id 3971',0.00,624.00,700.00,700.00,76.00,'2023-03-15 13:38:39'),(3797,'1','308',1,'Retail Sale Id 3972',0.00,1872.00,700.00,2100.00,228.00,'2023-03-15 13:48:17'),(3798,'1','308',1,'Retail Sale Id 3973',0.00,3120.00,700.00,3500.00,380.00,'2023-03-15 14:17:23'),(3799,'1','308',1,'Retail Sale Id 3974',0.00,2496.00,700.00,2800.00,304.00,'2023-03-15 14:23:06'),(3800,'1','308',1,'Retail Sale Id 3975',0.00,624.00,700.00,700.00,76.00,'2023-03-15 14:38:15'),(3801,'1','308',1,'Retail Sale Id 3976',0.00,6240.00,700.00,7000.00,760.00,'2023-03-15 14:40:23'),(3802,'1','308',1,'Retail Sale Id 3977',0.00,1872.00,700.00,2100.00,228.00,'2023-03-15 14:46:51'),(3803,'1','308',1,'Retail Sale Id 3978',0.00,892.32,700.00,1001.00,108.68,'2023-03-15 15:29:02'),(3804,'1','308',1,'Retail Sale Id 3979',0.00,18720.00,658.00,19740.00,1020.00,'2023-03-15 15:38:06'),(3805,'1','308',1,'Retail Sale Id 3980',0.00,12480.00,658.00,13160.00,680.00,'2023-03-15 16:38:23'),(3806,'1','308',1,'Retail Sale Id 3981',0.00,1784.64,700.00,2002.00,217.36,'2023-03-15 18:44:10'),(3807,'1','308',1,'Retail Sale Id 3982',0.00,1067.04,700.00,1197.00,129.96,'2023-03-15 18:48:52'),(3808,'1','308',1,'Retail Sale Id 3983',0.00,46176.00,658.00,48692.00,2516.00,'2023-03-15 19:18:34'),(3809,'1','308',1,'Retail Sale Id 3984',0.00,1297.92,700.00,1456.00,158.08,'2023-03-15 19:22:15'),(3810,'1','308',1,'Retail Sale Id 3985',0.00,1872.00,700.00,2100.00,228.00,'2023-03-16 07:21:28'),(3811,'1','308',1,'Retail Sale Id 3986',0.00,2496.00,700.00,2800.00,304.00,'2023-03-16 07:23:13'),(3812,'1','308',1,'Retail Sale Id 3987',0.00,1248.00,700.00,1400.00,152.00,'2023-03-16 07:24:24'),(3813,'1','308',1,'Retail Sale Id 3988',0.00,4455.36,700.00,4998.00,542.64,'2023-03-16 07:28:29'),(3814,'1','308',1,'Retail Sale Id 3989',0.00,3120.00,700.00,3500.00,380.00,'2023-03-16 08:30:56'),(3815,'1','308',1,'Retail Sale Id 3990',0.00,1248.00,700.00,1400.00,152.00,'2023-03-16 09:00:16'),(3816,'1','308',1,'Retail Sale Id 3991',0.00,7800.00,700.00,8750.00,950.00,'2023-03-16 09:09:05'),(3817,'1','308',1,'Retail Sale Id 3992',0.00,1248.00,700.00,1400.00,152.00,'2023-03-16 09:34:02'),(3818,'1','308',1,'Retail Sale Id 3993',0.00,3120.00,700.00,3500.00,380.00,'2023-03-16 09:35:33'),(3819,'1','308',1,'Retail Sale Id 3994',0.00,3120.00,700.00,3500.00,380.00,'2023-03-16 09:42:04'),(3820,'1','308',1,'Retail Sale Id 3995',0.00,1248.00,700.00,1400.00,152.00,'2023-03-16 09:44:15'),(3821,'1','308',1,'Retail Sale Id 3996',0.00,36192.00,658.00,38164.00,1972.00,'2023-03-16 09:49:10'),(3822,'1','308',1,'Retail Sale Id 3997',0.00,1872.00,700.00,2100.00,228.00,'2023-03-16 09:52:59'),(3823,'1','308',1,'Retail Sale Id 3998',0.00,1872.00,700.00,2100.00,228.00,'2023-03-16 09:58:08'),(3824,'1','308',1,'Retail Sale Id 3999',0.00,1248.00,700.00,1400.00,152.00,'2023-03-16 10:05:52'),(3825,'1','308',1,'Retail Sale Id 4000',0.00,1872.00,700.00,2100.00,228.00,'2023-03-16 10:27:04'),(3826,'1','308',1,'Retail Sale Id 4001',0.00,1248.00,700.00,1400.00,152.00,'2023-03-16 10:52:26'),(3827,'1','308',1,'Retail Sale Id 4002',0.00,1560.00,700.00,1750.00,190.00,'2023-03-16 11:01:48'),(3828,'1','308',1,'Retail Sale Id 4003',0.00,2496.00,700.00,2800.00,304.00,'2023-03-16 11:05:05'),(3829,'1','308',1,'Retail Sale Id 4004',0.00,1872.00,700.00,2100.00,228.00,'2023-03-16 11:15:22'),(3830,'1','308',1,'Retail Sale Id 4005',0.00,3120.00,700.00,3500.00,380.00,'2023-03-16 11:53:29'),(3831,'1','308',1,'Retail Sale Id 4006',0.00,4992.00,700.00,5600.00,608.00,'2023-03-16 12:04:54'),(3832,'1','308',1,'Retail Sale Id 4007',0.00,2496.00,700.00,2800.00,304.00,'2023-03-16 12:19:28'),(3833,'1','308',1,'Retail Sale Id 4008',0.00,2496.00,700.00,2800.00,304.00,'2023-03-16 12:39:21'),(3834,'1','308',1,'Retail Sale Id 4009',0.00,2496.00,700.00,2800.00,304.00,'2023-03-16 12:54:27'),(3835,'1','308',1,'Retail Sale Id 4010',0.00,3120.00,700.00,3500.00,380.00,'2023-03-16 13:04:55'),(3836,'1','308',1,'Retail Sale Id 4011',0.00,624.00,700.00,700.00,76.00,'2023-03-16 13:43:56'),(3837,'1','308',1,'Retail Sale Id 4012',0.00,3744.00,700.00,4200.00,456.00,'2023-03-16 13:45:27'),(3838,'1','308',1,'Retail Sale Id 4013',0.00,624.00,700.00,700.00,76.00,'2023-03-16 14:08:04'),(3839,'1','308',1,'Retail Sale Id 4014',0.00,1248.00,700.00,1400.00,152.00,'2023-03-16 14:21:09'),(3840,'1','308',1,'Retail Sale Id 4015',0.00,1872.00,700.00,2100.00,228.00,'2023-03-16 14:33:54'),(3841,'1','308',1,'Retail Sale Id 4016',0.00,2496.00,700.00,2800.00,304.00,'2023-03-16 14:38:13'),(3842,'1','308',1,'Retail Sale Id 4017',0.00,1248.00,700.00,1400.00,152.00,'2023-03-16 14:39:52'),(3843,'1','308',1,'Retail Sale Id 4019',0.00,1248.00,700.00,1400.00,152.00,'2023-03-16 15:06:44'),(3844,'1','308',1,'Retail Sale Id 4020',0.00,1248.00,700.00,1400.00,152.00,'2023-03-16 15:24:46'),(3845,'1','308',1,'Retail Sale Id 4021',0.00,1248.00,700.00,1400.00,152.00,'2023-03-16 15:36:50'),(3846,'1','308',1,'Retail Sale Id 4022',0.00,1872.00,700.00,2100.00,228.00,'2023-03-16 15:38:35'),(3847,'1','308',1,'Retail Sale Id 4023',0.00,1872.00,700.00,2100.00,228.00,'2023-03-16 15:41:09'),(3848,'1','308',1,'Retail Sale Id 4024',0.00,93600.00,658.00,98700.00,5100.00,'2023-03-16 15:43:46'),(3849,'1','308',1,'Retail Sale Id 4025',0.00,624.00,700.00,700.00,76.00,'2023-03-16 16:01:43'),(3850,'1','308',1,'Retail Sale Id 4026',0.00,7488.00,700.00,8400.00,912.00,'2023-03-16 16:24:41'),(3851,'1','308',1,'Retail Sale Id 4027',0.00,892.32,700.00,1001.00,108.68,'2023-03-16 17:13:50'),(3852,'1','308',1,'Retail Sale Id 4028',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-16 17:23:29'),(3853,'1','308',1,'Retail Sale Id 4029',0.00,1067.04,700.00,1197.00,129.96,'2023-03-16 18:16:24'),(3854,'1','308',1,'Return of Retail Sale Id 4007',2496.00,0.00,700.00,-2800.00,-304.00,'2023-03-16 18:34:34'),(3855,'1','308',1,'Retail Sale Id 4030',0.00,6864.00,700.00,7700.00,836.00,'2023-03-16 18:37:16'),(3856,'1','308',1,'Return of Retail Sale Id 4026',7488.00,0.00,700.00,-8400.00,-912.00,'2023-03-16 18:52:15'),(3857,'1','308',1,'Return of Retail Sale Id 4030',6864.00,0.00,700.00,-7700.00,-836.00,'2023-03-16 18:52:41'),(3858,'1','308',1,'Retail Sale Id 4031',0.00,65520.00,658.00,69090.00,3570.00,'2023-03-16 18:56:17'),(3859,'1','308',1,'Retail Sale Id 4032',0.00,611.52,700.00,686.00,74.48,'2023-03-16 19:32:01'),(3860,'1','308',1,'Retail Sale Id 4033',0.00,2496.00,700.00,2800.00,304.00,'2023-03-17 07:21:15'),(3861,'1','308',1,'Retail Sale Id 4034',0.00,892.32,700.00,1001.00,108.68,'2023-03-17 07:39:48'),(3862,'1','308',1,'Retail Sale Id 4035',0.00,2496.00,700.00,2800.00,304.00,'2023-03-17 08:11:07'),(3863,'1','308',1,'Retail Sale Id 4036',0.00,624.00,700.00,700.00,76.00,'2023-03-17 08:21:16'),(3864,'1','308',1,'Retail Sale Id 4037',0.00,7488.00,700.00,8400.00,912.00,'2023-03-17 08:29:32'),(3865,'1','308',1,'Retail Sale Id 4038',0.00,1248.00,700.00,1400.00,152.00,'2023-03-17 08:34:12'),(3866,'1','308',1,'Retail Sale Id 4042',0.00,1248.00,700.00,1400.00,152.00,'2023-03-17 08:49:44'),(3867,'1','308',1,'Retail Sale Id 4043',0.00,3744.00,700.00,4200.00,456.00,'2023-03-17 08:50:48'),(3868,'1','308',1,'Retail Sale Id 4044',0.00,3744.00,700.00,4200.00,456.00,'2023-03-17 08:51:55'),(3869,'1','308',1,'Retail Sale Id 4045',0.00,7800.00,700.00,8750.00,950.00,'2023-03-17 09:04:24'),(3870,'1','308',1,'Retail Sale Id 4046',0.00,19968.00,658.00,21056.00,1088.00,'2023-03-17 09:11:18'),(3871,'1','308',1,'Retail Sale Id 4047',0.00,62400.00,658.00,65800.00,3400.00,'2023-03-17 09:13:18'),(3872,'1','308',1,'Retail Sale Id 4048',0.00,1872.00,700.00,2100.00,228.00,'2023-03-17 09:19:12'),(3873,'1','308',1,'Retail Sale Id 4049',0.00,1335.36,700.00,1498.00,162.64,'2023-03-17 09:39:12'),(3874,'1','308',1,'Retail Sale Id 4051',0.00,892.32,700.00,1001.00,108.68,'2023-03-17 10:00:13'),(3875,'1','308',1,'Retail Sale Id 4052',0.00,3120.00,700.00,3500.00,380.00,'2023-03-17 10:26:17'),(3876,'1','308',1,'Retail Sale Id 4053',0.00,1784.64,700.00,2002.00,217.36,'2023-03-17 10:40:23'),(3877,'1','308',1,'Retail Sale Id 4054',0.00,5616.00,700.00,6300.00,684.00,'2023-03-17 10:51:17'),(3878,'1','308',1,'Retail Sale Id 4055',0.00,6240.00,700.00,7000.00,760.00,'2023-03-17 11:14:06'),(3879,'1','308',1,'Retail Sale Id 4056',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-17 11:16:50'),(3880,'1','308',1,'Retail Sale Id 4057',0.00,62400.00,658.00,65800.00,3400.00,'2023-03-17 12:01:05'),(3881,'1','308',1,'Retail Sale Id 4058',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-17 16:54:49'),(3882,'1','308',1,'Retail Sale Id 4060',0.00,33858.24,658.00,35703.08,1844.84,'2023-03-17 16:59:43'),(3883,'1','308',1,'Return of Retail Sale Id 4060',33858.24,0.00,658.00,-35703.08,-1844.84,'2023-03-17 17:09:03'),(3884,'1','308',1,'Retail Sale Id 4061',0.00,36192.00,658.00,38164.00,1972.00,'2023-03-17 17:10:26'),(3885,'1','308',1,'Retail Sale Id 4062',0.00,2496.00,700.00,2800.00,304.00,'2023-03-17 17:17:59'),(3886,'1','308',1,'Return of Retail Sale Id 4045',7800.00,0.00,700.00,-8750.00,-950.00,'2023-03-17 17:53:52'),(3887,'1','308',1,'Retail Sale Id 4063',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-17 17:59:35'),(3888,'1','308',1,'Retail Sale Id 4064',0.00,18720.00,658.00,19740.00,1020.00,'2023-03-17 18:10:55'),(3889,'1','308',1,'Retail Sale Id 4041',0.00,1248.00,700.00,1400.00,152.00,'2023-03-17 18:31:29'),(3890,'1','308',1,'Retail Sale Id 4065',0.00,78936.00,658.00,83237.00,4301.00,'2023-03-17 19:10:03'),(3891,'1','308',1,'Retail Sale Id 4066',0.00,2052.96,700.00,2303.00,250.04,'2023-03-17 19:15:30'),(3892,'1','308',1,'Retail Sale Id 4067',0.00,2496.00,700.00,2800.00,304.00,'2023-03-19 07:07:14'),(3893,'1','308',1,'Retail Sale Id 4068',0.00,7800.00,700.00,8750.00,950.00,'2023-03-19 07:08:07'),(3894,'1','308',1,'Retail Sale Id 4069',0.00,3744.00,700.00,4200.00,456.00,'2023-03-19 07:09:39'),(3895,'1','308',1,'Retail Sale Id 4070',0.00,3120.00,700.00,3500.00,380.00,'2023-03-19 07:10:49'),(3896,'1','308',1,'Retail Sale Id 4071',0.00,1872.00,700.00,2100.00,228.00,'2023-03-19 07:11:49'),(3897,'1','308',1,'Retail Sale Id 4072',0.00,624.00,700.00,700.00,76.00,'2023-03-19 07:13:16'),(3898,'1','308',1,'Retail Sale Id 4073',0.00,1248.00,700.00,1400.00,152.00,'2023-03-19 07:14:20'),(3899,'1','308',1,'Retail Sale Id 4074',0.00,7800.00,700.00,8750.00,950.00,'2023-03-19 07:17:40'),(3900,'1','308',1,'Retail Sale Id 4074',0.00,7800.00,700.00,8750.00,950.00,'2023-03-19 07:17:40'),(3901,'1','308',1,'Retail Sale Id 4075',0.00,1248.00,700.00,1400.00,152.00,'2023-03-19 07:26:04'),(3902,'1','308',1,'Retail Sale Id 4076',0.00,1872.00,700.00,2100.00,228.00,'2023-03-19 07:31:05'),(3903,'1','308',1,'Retail Sale Id 4077',0.00,1248.00,700.00,1400.00,152.00,'2023-03-19 07:35:04'),(3904,'1','308',1,'Retail Sale Id 4078',0.00,1248.00,700.00,1400.00,152.00,'2023-03-19 07:37:16'),(3905,'1','308',1,'Retail Sale Id 4079',0.00,12600.00,650.00,13000.00,400.00,'2023-03-19 07:42:11'),(3906,'1','308',1,'Retail Sale Id 4080',0.00,7875.00,700.00,8750.00,875.00,'2023-03-19 07:43:59'),(3907,'1','308',1,'Retail Sale Id 4081',0.00,31500.00,650.00,32500.00,1000.00,'2023-03-19 07:57:29'),(3908,'1','308',1,'Retail Sale Id 4082',0.00,1260.00,700.00,1400.00,140.00,'2023-03-19 08:00:33'),(3909,'1','308',1,'Retail Sale Id 4083',0.00,1890.00,700.00,2100.00,210.00,'2023-03-19 08:13:00'),(3910,'1','308',1,'Retail Sale Id 4084',0.00,3150.00,700.00,3500.00,350.00,'2023-03-19 08:14:10'),(3911,'1','308',1,'Retail Sale Id 4085',0.00,630.00,700.00,700.00,70.00,'2023-03-19 08:15:18'),(3912,'1','308',1,'Retail Sale Id 4086',0.00,3150.00,700.00,3500.00,350.00,'2023-03-19 08:16:31'),(3913,'1','308',1,'Retail Sale Id 4087',0.00,31500.00,650.00,32500.00,1000.00,'2023-03-19 08:18:10'),(3914,'1','308',1,'Retail Sale Id 4088',0.00,4410.00,700.00,4900.00,490.00,'2023-03-19 08:19:37'),(3915,'1','308',1,'Retail Sale Id 4089',0.00,1890.00,700.00,2100.00,210.00,'2023-03-19 08:21:34'),(3916,'1','308',1,'Retail Sale Id 4090',0.00,1890.00,700.00,2100.00,210.00,'2023-03-19 08:25:14'),(3917,'1','308',1,'Retail Sale Id 4091',0.00,3780.00,700.00,4200.00,420.00,'2023-03-19 08:26:22'),(3918,'1','308',1,'Retail Sale Id 4092',0.00,3780.00,700.00,4200.00,420.00,'2023-03-19 08:27:59'),(3919,'1','308',1,'Retail Sale Id 4093',0.00,1801.80,700.00,2002.00,200.20,'2023-03-19 08:29:56'),(3920,'1','308',1,'Retail Sale Id 4094',0.00,2520.00,700.00,2800.00,280.00,'2023-03-19 08:31:08'),(3921,'1','308',1,'Retail Sale Id 4095',0.00,7875.00,700.00,8750.00,875.00,'2023-03-19 08:41:41'),(3922,'1','308',1,'Retail Sale Id 4096',0.00,3150.00,700.00,3500.00,350.00,'2023-03-19 08:42:44'),(3923,'1','308',1,'Retail Sale Id 4097',0.00,31500.00,650.00,32500.00,1000.00,'2023-03-19 08:44:35'),(3924,'1','308',1,'Retail Sale Id 4098',0.00,1260.00,700.00,1400.00,140.00,'2023-03-19 09:02:50'),(3925,'1','308',1,'Retail Sale Id 4099',0.00,3150.00,700.00,3500.00,350.00,'2023-03-19 09:04:16'),(3926,'1','308',1,'Retail Sale Id 4100',0.00,1890.00,700.00,2100.00,210.00,'2023-03-19 09:05:46'),(3927,'1','308',1,'Retail Sale Id 4101',0.00,18900.00,650.00,19500.00,600.00,'2023-03-19 09:12:24'),(3928,'1','308',1,'Retail Sale Id 4102',0.00,2520.00,700.00,2800.00,280.00,'2023-03-19 09:14:23'),(3929,'1','308',1,'Retail Sale Id 4103',0.00,34650.00,650.00,35750.00,1100.00,'2023-03-19 09:15:43'),(3930,'1','308',1,'Retail Sale Id 4104',0.00,7875.00,700.00,8750.00,875.00,'2023-03-19 09:26:37'),(3931,'1','308',1,'Retail Sale Id 4105',0.00,1890.00,700.00,2100.00,210.00,'2023-03-19 09:37:56'),(3932,'1','308',1,'Retail Sale Id 4106',0.00,900.90,700.00,1001.00,100.10,'2023-03-19 09:40:03'),(3933,'1','308',1,'Retail Sale Id 4107',0.00,1890.00,700.00,2100.00,210.00,'2023-03-19 09:52:07'),(3934,'1','308',1,'Retail Sale Id 4108',0.00,1890.00,700.00,2100.00,210.00,'2023-03-19 09:58:13'),(3935,'1','308',1,'Retail Sale Id 4108',0.00,3780.00,700.00,4200.00,420.00,'2023-03-19 09:58:13'),(3936,'1','308',1,'Retail Sale Id 4109',0.00,630.00,700.00,700.00,70.00,'2023-03-19 11:02:19'),(3937,'1','308',1,'Retail Sale Id 4110',0.00,94500.00,650.00,97500.00,3000.00,'2023-03-19 11:33:11'),(3938,'1','308',1,'Retail Sale Id 4111',0.00,1890.00,700.00,2100.00,210.00,'2023-03-19 11:43:18'),(3939,'1','308',1,'Retail Sale Id 4112',0.00,6300.00,700.00,7000.00,700.00,'2023-03-19 11:48:59'),(3940,'1','308',1,'Retail Sale Id 4113',0.00,18900.00,650.00,19500.00,600.00,'2023-03-19 12:12:53'),(3941,'1','308',1,'Retail Sale Id 4114',0.00,1575.00,700.00,1750.00,175.00,'2023-03-19 12:30:18'),(3942,'1','308',1,'Retail Sale Id 4114',0.00,6930.00,700.00,7700.00,770.00,'2023-03-19 12:30:18'),(3943,'1','308',1,'Retail Sale Id 4115',0.00,630.00,700.00,700.00,70.00,'2023-03-19 12:48:29'),(3944,'1','308',1,'Retail Sale Id 4116',0.00,94500.00,650.00,97500.00,3000.00,'2023-03-19 13:49:44'),(3945,'1','308',1,'Retail Sale Id 4117',0.00,63000.00,650.00,65000.00,2000.00,'2023-03-19 14:22:33'),(3946,'1','308',1,'Retail Sale Id 4118',0.00,2249.10,700.00,2499.00,249.90,'2023-03-19 14:49:08'),(3947,'1','308',1,'Return of Retail Sale Id 4095',7875.00,0.00,700.00,-8750.00,-875.00,'2023-03-19 15:33:21'),(3948,'1','308',1,'Retail Sale Id 4119',0.00,4410.00,700.00,4900.00,490.00,'2023-03-19 15:33:58'),(3949,'1','308',1,'Retail Sale Id 4120',0.00,63000.00,650.00,65000.00,2000.00,'2023-03-19 15:58:54'),(3950,'1','308',1,'Retail Sale Id 4122',0.00,1260.00,700.00,1400.00,140.00,'2023-03-19 17:45:15'),(3951,'1','308',1,'Retail Sale Id 4123',0.00,63000.00,650.00,65000.00,2000.00,'2023-03-19 17:47:18'),(3952,'1','308',1,'Retail Sale Id 4124',0.00,1348.20,700.00,1498.00,149.80,'2023-03-19 17:47:49'),(3953,'1','308',1,'Retail Sale Id 4125',0.00,3150.00,700.00,3500.00,350.00,'2023-03-19 17:48:53'),(3954,'1','308',1,'Retail Sale Id 4126',0.00,41409.90,650.00,42724.50,1314.60,'2023-03-19 17:52:11'),(3955,'1','308',1,'Retail Sale Id 4127',0.00,1260.00,700.00,1400.00,140.00,'2023-03-19 18:00:12'),(3956,'1','308',1,'Retail Sale Id 4128',0.00,1890.00,700.00,2100.00,210.00,'2023-03-19 18:01:17'),(3957,'1','308',1,'Retail Sale Id 4129',0.00,1260.00,700.00,1400.00,140.00,'2023-03-19 18:02:24'),(3958,'1','308',1,'Retail Sale Id 4130',0.00,3780.00,700.00,4200.00,420.00,'2023-03-19 18:04:20'),(3959,'1','308',1,'Retail Sale Id 4131',0.00,6300.00,700.00,7000.00,700.00,'2023-03-19 18:05:28'),(3960,'1','308',1,'Retail Sale Id 4132',0.00,3150.00,700.00,3500.00,350.00,'2023-03-19 18:20:15'),(3961,'1','308',1,'Retail Sale Id 4133',0.00,1890.00,700.00,2100.00,210.00,'2023-03-19 18:23:29'),(3962,'1','308',1,'Retail Sale Id 4134',0.00,630.00,700.00,700.00,70.00,'2023-03-19 18:28:09'),(3963,'1','308',1,'Retail Sale Id 4135',0.00,1260.00,700.00,1400.00,140.00,'2023-03-19 18:29:53'),(3964,'1','308',1,'Retail Sale Id 4136',0.00,3780.00,700.00,4200.00,420.00,'2023-03-19 18:32:35'),(3965,'1','308',1,'Retail Sale Id 4137',0.00,1260.00,700.00,1400.00,140.00,'2023-03-19 18:36:17'),(3966,'1','308',1,'Retail Sale Id 4138',0.00,28520.10,650.00,29425.50,905.40,'2023-03-19 19:13:28'),(3967,'1','308',1,'Return of Retail Sale Id 4132',3150.00,0.00,700.00,-3500.00,-350.00,'2023-03-19 19:14:28'),(3968,'1','308',1,'Retail Sale Id 4139',0.00,1039.50,700.00,1155.00,115.50,'2023-03-19 19:15:31'),(3969,'1','308',1,'Retail Sale Id 4140',0.00,90720.00,650.00,93600.00,2880.00,'2023-03-20 08:19:14'),(3970,'1','308',1,'Retail Sale Id 4141',0.00,173250.00,650.00,178750.00,5500.00,'2023-03-20 13:27:14'),(3971,'1','308',1,'Retail Sale Id 4142',0.00,7875.00,700.00,8750.00,875.00,'2023-03-20 13:45:51'),(3972,'1','308',1,'Retail Sale Id 4143',0.00,95445.00,700.00,106050.00,10605.00,'2023-03-20 13:50:59'),(3973,'1','308',1,'Retail Sale Id 4144',0.00,10980.90,700.00,12201.00,1220.10,'2023-03-20 13:53:08'),(3974,'1','308',1,'Retail Sale Id 4145',0.00,1890.00,700.00,2100.00,210.00,'2023-03-20 13:54:43'),(3975,'1','308',1,'Retail Sale Id 4146',0.00,1890.00,700.00,2100.00,210.00,'2023-03-20 14:05:54'),(3976,'1','308',1,'Retail Sale Id 4147',0.00,1890.00,700.00,2100.00,210.00,'2023-03-20 14:15:53'),(3977,'1','308',1,'Retail Sale Id 4148',0.00,1890.00,700.00,2100.00,210.00,'2023-03-20 14:19:16'),(3978,'1','308',1,'Retail Sale Id 4149',0.00,36540.00,650.00,37700.00,1160.00,'2023-03-20 14:22:40'),(3979,'1','308',1,'Retail Sale Id 4150',0.00,1260.00,700.00,1400.00,140.00,'2023-03-20 14:48:48'),(3980,'1','308',1,'Retail Sale Id 4151',0.00,3150.00,700.00,3500.00,350.00,'2023-03-20 15:29:36'),(3981,'1','308',1,'Retail Sale Id 4152',0.00,1890.00,700.00,2100.00,210.00,'2023-03-20 15:34:05'),(3982,'1','308',1,'Retail Sale Id 4153',0.00,1260.00,700.00,1400.00,140.00,'2023-03-20 15:51:12'),(3983,'1','308',1,'Retail Sale Id 4154',0.00,1260.00,700.00,1400.00,140.00,'2023-03-20 16:14:33'),(3984,'1','308',1,'Retail Sale Id 4155',0.00,7875.00,700.00,8750.00,875.00,'2023-03-20 16:20:30'),(3985,'1','308',1,'Retail Sale Id 4156',0.00,1260.00,700.00,1400.00,140.00,'2023-03-20 16:31:34'),(3986,'1','308',1,'Retail Sale Id 4157',0.00,18900.00,650.00,19500.00,600.00,'2023-03-20 16:32:59'),(3987,'1','308',1,'Retail Sale Id 4158',0.00,3150.00,700.00,3500.00,350.00,'2023-03-20 16:48:33'),(3988,'1','308',1,'Retail Sale Id 4159',0.00,1260.00,700.00,1400.00,140.00,'2023-03-20 16:54:02'),(3989,'1','308',1,'Retail Sale Id 4160',0.00,1890.00,700.00,2100.00,210.00,'2023-03-20 17:01:53'),(3990,'1','308',1,'Retail Sale Id 4161',0.00,630.00,700.00,700.00,70.00,'2023-03-20 17:03:25'),(3991,'1','308',1,'Retail Sale Id 4162',0.00,1260.00,700.00,1400.00,140.00,'2023-03-20 17:04:53'),(3992,'1','308',1,'Retail Sale Id 4163',0.00,6300.00,700.00,7000.00,700.00,'2023-03-20 17:10:08'),(3993,'1','308',1,'Retail Sale Id 4164',0.00,1348.20,700.00,1498.00,149.80,'2023-03-20 17:11:46'),(3994,'1','308',1,'Retail Sale Id 4165',0.00,1260.00,700.00,1400.00,140.00,'2023-03-20 17:15:14'),(3995,'1','308',1,'Retail Sale Id 4166',0.00,2520.00,700.00,2800.00,280.00,'2023-03-20 17:17:54'),(3996,'1','308',1,'Retail Sale Id 4167',0.00,630.00,700.00,700.00,70.00,'2023-03-20 17:19:08'),(3997,'1','308',1,'Retail Sale Id 4168',0.00,630.00,700.00,700.00,70.00,'2023-03-20 17:20:54'),(3998,'1','308',1,'Retail Sale Id 4169',0.00,1890.00,700.00,2100.00,210.00,'2023-03-20 17:24:41'),(3999,'1','308',1,'Retail Sale Id 4170',0.00,1890.00,700.00,2100.00,210.00,'2023-03-20 17:26:27'),(4000,'1','308',1,'Retail Sale Id 4171',0.00,2520.00,700.00,2800.00,280.00,'2023-03-20 17:32:16'),(4001,'1','308',1,'Retail Sale Id 4172',0.00,3780.00,700.00,4200.00,420.00,'2023-03-20 17:33:17'),(4002,'1','308',1,'Return of Retail Sale Id 4155',7875.00,0.00,700.00,-8750.00,-875.00,'2023-03-20 17:57:38'),(4003,'1','308',1,'Return of Retail Sale Id 4144',10980.90,0.00,700.00,-12201.00,-1220.10,'2023-03-20 17:58:47'),(4004,'1','308',1,'Retail Sale Id 4173',0.00,45045.00,650.00,46475.00,1430.00,'2023-03-20 19:09:42'),(4005,'1','308',1,'Retail Sale Id 4174',0.00,12555.90,700.00,13951.00,1395.10,'2023-03-20 19:11:31');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=8486 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('1','308',1,'','24','5',0.00,3300080.00,'Purchase Id 1 for 4,970.00 litters of Cooking Gas - LPG from AA RANO NIGERIA LTD.','2022-12-23 10:57:04','',''),('1','308',2,'','supplier','1',3300080.00,0.00,'Purchase Id 1 for 4,970.00 litters of Cooking Gas - LPG from AA RANO NIGERIA LTD.','2022-12-23 10:57:04','',''),('1','308',3,'','20','2',770.00,0.00,'Retail Sale Id 3 for 1.00 KG of Cooking Gas @ N770.00','2022-12-23 11:31:06','',''),('1','308',4,'','6.1','3',0.00,770.00,'Retail Sale Id 3 for retail product','2022-12-23 11:31:06','',''),('1','308',5,'','20','2',0.00,0.00,'Sales from shift 1 on 2022-12-23 11:47:44 ','2022-12-23 11:47:44','',''),('1','308',6,'','6.1','3',0.00,0.00,'Sales from shift 1 on 2022-12-23 11:47:44 ','2022-12-23 11:47:44','',''),('1','308',7,'','20','2',43200.00,0.00,'Retail Sale Id 4 for 60.00 KG of Cooking Gas @ N720.00','2022-12-23 12:29:11','',''),('1','308',8,'','6.1','3',0.00,43200.00,'Retail Sale Id 4 for retail product','2022-12-23 12:29:11','',''),('1','308',9,'','20','2',3850.00,0.00,'Retail Sale Id 5 for 5.00 KG of Cooking Gas @ N770.00','2022-12-23 14:49:29','',''),('1','308',10,'','6.1','3',0.00,3850.00,'Retail Sale Id 5 for retail product','2022-12-23 14:49:29','',''),('1','308',11,'','20','2',3311.00,0.00,'Retail Sale Id 6 for 4.30 KG of Cooking Gas @ N770.00','2022-12-23 17:57:22','',''),('1','308',12,'','6.1','3',0.00,3311.00,'Retail Sale Id 6 for retail product','2022-12-23 17:57:22','',''),('1','308',13,'','20','2',1540.00,0.00,'Retail Sale Id 7 for 2.00 KG of Cooking Gas @ N770.00','2022-12-23 17:59:33','',''),('1','308',14,'','6.1','3',0.00,1540.00,'Retail Sale Id 7 for retail product','2022-12-23 17:59:33','',''),('1','308',15,'','20','2',0.00,1540.00,'Return of Retail Sale Id 7 for products','2022-12-23 19:19:32','',''),('1','308',16,'','','',1540.00,0.00,'Return of Retail Sale Id 7 for products','2022-12-23 19:19:32','',''),('1','308',17,'','20','2',0.00,43200.00,'Return of Retail Sale Id 4 for products','2022-12-23 19:45:24','',''),('1','308',18,'','','',43200.00,0.00,'Return of Retail Sale Id 4 for products','2022-12-23 19:45:24','',''),('1','308',19,'','20','2',0.00,3311.00,'Return of Retail Sale Id 6 for products','2022-12-23 19:45:56','',''),('1','308',20,'','','',3311.00,0.00,'Return of Retail Sale Id 6 for products','2022-12-23 19:45:56','',''),('1','308',21,'','20','2',0.00,3850.00,'Return of Retail Sale Id 5 for products','2022-12-23 19:46:25','',''),('1','308',22,'','','',3850.00,0.00,'Return of Retail Sale Id 5 for products','2022-12-23 19:46:25','',''),('1','308',23,'','20','2',49129.00,0.00,'Retail Sale Id 8 for 67.30 KG of Cooking Gas @ N730.00','2022-12-23 19:49:02','',''),('1','308',24,'','6.1','3',0.00,49129.00,'Retail Sale Id 8 for retail product','2022-12-23 19:49:02','',''),('1','308',25,'','20','2',4620.00,0.00,'Retail Sale Id 9 for 6.00 KG of Cooking Gas @ N770.00','2022-12-23 19:50:22','',''),('1','308',26,'','6.1','3',0.00,4620.00,'Retail Sale Id 9 for retail product','2022-12-23 19:50:22','',''),('1','308',27,'','20','2',0.00,0.00,'Sales from shift 2 on 2022-12-23 20:02:25 ','2022-12-23 20:02:25','',''),('1','308',28,'','6.1','3',0.00,0.00,'Sales from shift 2 on 2022-12-23 20:02:25 ','2022-12-23 20:02:25','',''),('1','308',29,'','20','2',2350.00,0.00,'Retail Sale Id 10 for 3.05 KG of Cooking Gas @ N770.00','2022-12-24 08:35:42','',''),('1','308',30,'','6.1','3',0.00,2350.00,'Retail Sale Id 10 for retail product','2022-12-24 08:35:42','',''),('1','308',31,'','20','2',2310.00,0.00,'Retail Sale Id 11 for 3.00 KG of Cooking Gas @ N770.00','2022-12-24 08:51:00','',''),('1','308',32,'','6.1','3',0.00,2310.00,'Retail Sale Id 11 for retail product','2022-12-24 08:51:00','',''),('1','308',33,'','20','2',2310.00,0.00,'Retail Sale Id 12 for 3.00 KG of Cooking Gas @ N770.00','2022-12-24 08:52:31','',''),('1','308',34,'','6.1','3',0.00,2310.00,'Retail Sale Id 12 for retail product','2022-12-24 08:52:31','',''),('1','308',35,'','20','2',2310.00,0.00,'Retail Sale Id 13 for 3.00 KG of Cooking Gas @ N770.00','2022-12-24 08:53:32','',''),('1','308',36,'','6.1','3',0.00,2310.00,'Retail Sale Id 13 for retail product','2022-12-24 08:53:32','',''),('1','308',37,'','20','2',4250.00,0.00,'Retail Sale Id 14 for 5.52 KG of Cooking Gas @ N770.00','2022-12-24 09:23:28','',''),('1','308',38,'','6.1','3',0.00,4250.00,'Retail Sale Id 14 for retail product','2022-12-24 09:23:28','',''),('1','308',39,'','20','2',4650.00,0.00,'Retail Sale Id 15 for 6.04 KG of Cooking Gas @ N770.00','2022-12-24 10:15:28','',''),('1','308',40,'','6.1','3',0.00,4650.00,'Retail Sale Id 15 for retail product','2022-12-24 10:15:28','',''),('1','308',41,'','20','2',770.00,0.00,'Retail Sale Id 16 for 1.00 KG of Cooking Gas @ N770.00','2022-12-24 10:55:44','',''),('1','308',42,'','6.1','3',0.00,770.00,'Retail Sale Id 16 for retail product','2022-12-24 10:55:44','',''),('1','308',43,'','20','2',2000.00,0.00,'Retail Sale Id 17 for 2.60 KG of Cooking Gas @ N770.00','2022-12-24 11:18:41','',''),('1','308',44,'','6.1','3',0.00,2000.00,'Retail Sale Id 17 for retail product','2022-12-24 11:18:41','',''),('1','308',45,'','20','2',1500.00,0.00,'Retail Sale Id 18 for 1.95 KG of Cooking Gas @ N770.00','2022-12-24 11:41:59','',''),('1','308',46,'','6.1','3',0.00,1500.00,'Retail Sale Id 18 for retail product','2022-12-24 11:41:59','',''),('1','308',47,'','20','2',500.00,0.00,'Retail Sale Id 19 for 0.65 KG of Cooking Gas @ N770.00','2022-12-24 12:00:01','',''),('1','308',48,'','6.1','3',0.00,500.00,'Retail Sale Id 19 for retail product','2022-12-24 12:00:01','',''),('1','308',49,'','20','2',1540.00,0.00,'Retail Sale Id 20 for 2.00 KG of Cooking Gas @ N770.00','2022-12-24 12:27:29','',''),('1','308',50,'','6.1','3',0.00,1540.00,'Retail Sale Id 20 for retail product','2022-12-24 12:27:29','',''),('1','308',51,'','20','2',1540.00,0.00,'Retail Sale Id 21 for 2.00 KG of Cooking Gas @ N770.00','2022-12-24 12:28:50','',''),('1','308',52,'','6.1','3',0.00,1540.00,'Retail Sale Id 21 for retail product','2022-12-24 12:28:50','',''),('1','308',53,'','20','2',1540.00,0.00,'Retail Sale Id 22 for 2.00 KG of Cooking Gas @ N770.00','2022-12-24 12:31:59','',''),('1','308',54,'','6.1','3',0.00,1540.00,'Retail Sale Id 22 for retail product','2022-12-24 12:31:59','',''),('1','308',55,'','20','2',1540.00,0.00,'Retail Sale Id 23 for 2.00 KG of Cooking Gas @ N770.00','2022-12-24 12:39:24','',''),('1','308',56,'','6.1','3',0.00,1540.00,'Retail Sale Id 23 for retail product','2022-12-24 12:39:24','',''),('1','308',57,'','20','2',1500.00,0.00,'Retail Sale Id 24 for 1.95 KG of Cooking Gas @ N770.00','2022-12-24 12:41:02','',''),('1','308',58,'','6.1','3',0.00,1500.00,'Retail Sale Id 24 for retail product','2022-12-24 12:41:02','',''),('1','308',59,'','20','2',2310.00,0.00,'Retail Sale Id 25 for 3.00 KG of Cooking Gas @ N770.00','2022-12-24 12:42:47','',''),('1','308',60,'','6.1','3',0.00,2310.00,'Retail Sale Id 25 for retail product','2022-12-24 12:42:47','',''),('1','308',61,'','20','2',3080.00,0.00,'Retail Sale Id 26 for 4.00 KG of Cooking Gas @ N770.00','2022-12-24 12:47:46','',''),('1','308',62,'','6.1','3',0.00,3080.00,'Retail Sale Id 26 for retail product','2022-12-24 12:47:46','',''),('1','308',63,'','20','2',800.00,0.00,'Retail Sale Id 27 for 1.04 KG of Cooking Gas @ N770.00','2022-12-24 12:55:13','',''),('1','308',64,'','6.1','3',0.00,800.00,'Retail Sale Id 27 for retail product','2022-12-24 12:55:13','',''),('1','308',65,'','20','2',800.00,0.00,'Retail Sale Id 28 for 1.04 KG of Cooking Gas @ N770.00','2022-12-24 12:57:36','',''),('1','308',66,'','6.1','3',0.00,800.00,'Retail Sale Id 28 for retail product','2022-12-24 12:57:36','',''),('1','308',67,'','20','2',2310.00,0.00,'Retail Sale Id 29 for 3.00 KG of Cooking Gas @ N770.00','2022-12-24 13:00:07','',''),('1','308',68,'','6.1','3',0.00,2310.00,'Retail Sale Id 29 for retail product','2022-12-24 13:00:07','',''),('1','308',69,'','20','2',1540.00,0.00,'Retail Sale Id 30 for 2.00 KG of Cooking Gas @ N770.00','2022-12-24 13:03:47','',''),('1','308',70,'','6.1','3',0.00,1540.00,'Retail Sale Id 30 for retail product','2022-12-24 13:03:47','',''),('1','308',71,'','20','2',2310.00,0.00,'Retail Sale Id 31 for 3.00 KG of Cooking Gas @ N770.00','2022-12-24 13:09:01','',''),('1','308',72,'','6.1','3',0.00,2310.00,'Retail Sale Id 31 for retail product','2022-12-24 13:09:01','',''),('1','308',73,'','20','2',3100.00,0.00,'Retail Sale Id 32 for 4.03 KG of Cooking Gas @ N770.00','2022-12-24 13:13:18','',''),('1','308',74,'','6.1','3',0.00,3100.00,'Retail Sale Id 32 for retail product','2022-12-24 13:13:18','',''),('1','308',75,'','20','2',9650.00,0.00,'Retail Sale Id 33 for 12.53 KG of Cooking Gas @ N770.00','2022-12-24 13:16:38','',''),('1','308',76,'','6.1','3',0.00,9650.00,'Retail Sale Id 33 for retail product','2022-12-24 13:16:38','',''),('1','308',77,'','20','2',1540.00,0.00,'Retail Sale Id 34 for 2.00 KG of Cooking Gas @ N770.00','2022-12-24 13:22:24','',''),('1','308',78,'','6.1','3',0.00,1540.00,'Retail Sale Id 34 for retail product','2022-12-24 13:22:24','',''),('1','308',79,'','20','2',1540.00,0.00,'Retail Sale Id 35 for 2.00 KG of Cooking Gas @ N770.00','2022-12-24 13:24:53','',''),('1','308',80,'','6.1','3',0.00,1540.00,'Retail Sale Id 35 for retail product','2022-12-24 13:24:53','',''),('1','308',81,'','20','2',800.00,0.00,'Retail Sale Id 36 for 1.04 KG of Cooking Gas @ N770.00','2022-12-24 13:25:40','',''),('1','308',82,'','6.1','3',0.00,800.00,'Retail Sale Id 36 for retail product','2022-12-24 13:25:41','',''),('1','308',83,'','20','2',3100.00,0.00,'Retail Sale Id 37 for 4.03 KG of Cooking Gas @ N770.00','2022-12-24 13:28:07','',''),('1','308',84,'','6.1','3',0.00,3100.00,'Retail Sale Id 37 for retail product','2022-12-24 13:28:07','',''),('1','308',85,'','20','2',1540.00,0.00,'Retail Sale Id 38 for 2.00 KG of Cooking Gas @ N770.00','2022-12-24 13:29:40','',''),('1','308',86,'','6.1','3',0.00,1540.00,'Retail Sale Id 38 for retail product','2022-12-24 13:29:40','',''),('1','308',87,'','20','2',2310.00,0.00,'Retail Sale Id 39 for 3.00 KG of Cooking Gas @ N770.00','2022-12-24 13:32:56','',''),('1','308',88,'','6.1','3',0.00,2310.00,'Retail Sale Id 39 for retail product','2022-12-24 13:32:56','',''),('1','308',89,'','20','2',1540.00,0.00,'Retail Sale Id 40 for 2.00 KG of Cooking Gas @ N770.00','2022-12-24 13:35:03','',''),('1','308',90,'','6.1','3',0.00,1540.00,'Retail Sale Id 40 for retail product','2022-12-24 13:35:03','',''),('1','308',91,'','20','2',800.00,0.00,'Retail Sale Id 41 for 1.04 KG of Cooking Gas @ N770.00','2022-12-24 13:36:36','',''),('1','308',92,'','6.1','3',0.00,800.00,'Retail Sale Id 41 for retail product','2022-12-24 13:36:36','',''),('1','308',93,'','20','2',2350.00,0.00,'Retail Sale Id 42 for 3.05 KG of Cooking Gas @ N770.00','2022-12-24 13:38:48','',''),('1','308',94,'','6.1','3',0.00,2350.00,'Retail Sale Id 42 for retail product','2022-12-24 13:38:48','',''),('1','308',95,'','20','2',3080.00,0.00,'Retail Sale Id 43 for 4.00 KG of Cooking Gas @ N770.00','2022-12-24 13:41:19','',''),('1','308',96,'','6.1','3',0.00,3080.00,'Retail Sale Id 43 for retail product','2022-12-24 13:41:19','',''),('1','308',97,'','20','2',3850.00,0.00,'Retail Sale Id 44 for 5.00 KG of Cooking Gas @ N770.00','2022-12-24 13:42:45','',''),('1','308',98,'','6.1','3',0.00,3850.00,'Retail Sale Id 44 for retail product','2022-12-24 13:42:45','',''),('1','308',99,'','20','2',1550.00,0.00,'Retail Sale Id 45 for 2.01 KG of Cooking Gas @ N770.00','2022-12-24 13:52:06','',''),('1','308',100,'','6.1','3',0.00,1550.00,'Retail Sale Id 45 for retail product','2022-12-24 13:52:06','',''),('1','308',101,'','20','2',1550.00,0.00,'Retail Sale Id 46 for 2.01 KG of Cooking Gas @ N770.00','2022-12-24 13:53:39','',''),('1','308',102,'','6.1','3',0.00,1550.00,'Retail Sale Id 46 for retail product','2022-12-24 13:53:39','',''),('1','308',103,'','20','2',1500.00,0.00,'Retail Sale Id 47 for 1.95 KG of Cooking Gas @ N770.00','2022-12-24 13:56:52','',''),('1','308',104,'','6.1','3',0.00,1500.00,'Retail Sale Id 47 for retail product','2022-12-24 13:56:52','',''),('1','308',105,'','20','2',2310.00,0.00,'Retail Sale Id 48 for 3.00 KG of Cooking Gas @ N770.00','2022-12-24 13:58:41','',''),('1','308',106,'','6.1','3',0.00,2310.00,'Retail Sale Id 48 for retail product','2022-12-24 13:58:41','',''),('1','308',107,'','20','2',3850.00,0.00,'Retail Sale Id 49 for 5.00 KG of Cooking Gas @ N770.00','2022-12-24 14:01:17','',''),('1','308',108,'','6.1','3',0.00,3850.00,'Retail Sale Id 49 for retail product','2022-12-24 14:01:17','',''),('1','308',109,'','20','2',3100.00,0.00,'Retail Sale Id 50 for 4.03 KG of Cooking Gas @ N770.00','2022-12-24 14:05:24','',''),('1','308',110,'','6.1','3',0.00,3100.00,'Retail Sale Id 50 for retail product','2022-12-24 14:05:24','',''),('1','308',111,'','20','2',2310.00,0.00,'Retail Sale Id 51 for 3.00 KG of Cooking Gas @ N770.00','2022-12-24 14:15:13','',''),('1','308',112,'','6.1','3',0.00,2310.00,'Retail Sale Id 51 for retail product','2022-12-24 14:15:13','',''),('1','308',113,'','20','2',3850.00,0.00,'Retail Sale Id 52 for 5.00 KG of Cooking Gas @ N770.00','2022-12-24 14:19:47','',''),('1','308',114,'','6.1','3',0.00,3850.00,'Retail Sale Id 52 for retail product','2022-12-24 14:19:47','',''),('1','308',115,'','20','2',2300.00,0.00,'Retail Sale Id 53 for 2.99 KG of Cooking Gas @ N770.00','2022-12-24 14:20:59','',''),('1','308',116,'','6.1','3',0.00,2300.00,'Retail Sale Id 53 for retail product','2022-12-24 14:20:59','',''),('1','308',117,'','20','2',2100.00,0.00,'Retail Sale Id 54 for 2.73 KG of Cooking Gas @ N770.00','2022-12-24 14:23:00','',''),('1','308',118,'','6.1','3',0.00,2100.00,'Retail Sale Id 54 for retail product','2022-12-24 14:23:00','',''),('1','308',119,'','20','2',2300.00,0.00,'Retail Sale Id 55 for 2.99 KG of Cooking Gas @ N770.00','2022-12-24 14:25:05','',''),('1','308',120,'','6.1','3',0.00,2300.00,'Retail Sale Id 55 for retail product','2022-12-24 14:25:05','',''),('1','308',121,'','20','2',1500.00,0.00,'Retail Sale Id 56 for 1.95 KG of Cooking Gas @ N770.00','2022-12-24 14:27:31','',''),('1','308',122,'','6.1','3',0.00,1500.00,'Retail Sale Id 56 for retail product','2022-12-24 14:27:31','',''),('1','308',123,'','20','2',800.00,0.00,'Retail Sale Id 57 for 1.04 KG of Cooking Gas @ N770.00','2022-12-24 14:28:24','',''),('1','308',124,'','6.1','3',0.00,800.00,'Retail Sale Id 57 for retail product','2022-12-24 14:28:24','',''),('1','308',125,'','20','2',1500.00,0.00,'Retail Sale Id 58 for 1.95 KG of Cooking Gas @ N770.00','2022-12-24 14:35:15','',''),('1','308',126,'','6.1','3',0.00,1500.00,'Retail Sale Id 58 for retail product','2022-12-24 14:35:15','',''),('1','308',127,'','20','2',35500.00,0.00,'Retail Sale Id 59 for 50.00 KG of Cooking Gas @ N710.00','2022-12-24 14:38:43','',''),('1','308',128,'','6.1','3',0.00,35500.00,'Retail Sale Id 59 for retail product','2022-12-24 14:38:43','',''),('1','308',129,'','20','2',5400.00,0.00,'Retail Sale Id 60 for 7.01 KG of Cooking Gas @ N770.00','2022-12-24 14:40:52','',''),('1','308',130,'','6.1','3',0.00,5400.00,'Retail Sale Id 60 for retail product','2022-12-24 14:40:52','',''),('1','308',131,'','20','2',4650.00,0.00,'Retail Sale Id 61 for 6.04 KG of Cooking Gas @ N770.00','2022-12-24 14:44:37','',''),('1','308',132,'','6.1','3',0.00,4650.00,'Retail Sale Id 61 for retail product','2022-12-24 14:44:37','',''),('1','308',133,'','20','2',4700.00,0.00,'Retail Sale Id 62 for 6.10 KG of Cooking Gas @ N770.00','2022-12-24 14:46:18','',''),('1','308',134,'','6.1','3',0.00,4700.00,'Retail Sale Id 62 for retail product','2022-12-24 14:46:18','',''),('1','308',135,'','20','2',3850.00,0.00,'Retail Sale Id 63 for 5.00 KG of Cooking Gas @ N770.00','2022-12-24 14:48:20','',''),('1','308',136,'','6.1','3',0.00,3850.00,'Retail Sale Id 63 for retail product','2022-12-24 14:48:20','',''),('1','308',137,'','20','2',1500.00,0.00,'Retail Sale Id 64 for 1.95 KG of Cooking Gas @ N770.00','2022-12-24 14:50:17','',''),('1','308',138,'','6.1','3',0.00,1500.00,'Retail Sale Id 64 for retail product','2022-12-24 14:50:17','',''),('1','308',139,'','20','2',2200.00,0.00,'Retail Sale Id 65 for 2.86 KG of Cooking Gas @ N770.00','2022-12-24 14:52:28','',''),('1','308',140,'','6.1','3',0.00,2200.00,'Retail Sale Id 65 for retail product','2022-12-24 14:52:28','',''),('1','308',141,'','20','2',2500.00,0.00,'Retail Sale Id 66 for 3.25 KG of Cooking Gas @ N770.00','2022-12-24 15:06:37','',''),('1','308',142,'','6.1','3',0.00,2500.00,'Retail Sale Id 66 for retail product','2022-12-24 15:06:37','',''),('1','308',143,'','20','2',1500.00,0.00,'Retail Sale Id 67 for 1.95 KG of Cooking Gas @ N770.00','2022-12-24 15:09:10','',''),('1','308',144,'','6.1','3',0.00,1500.00,'Retail Sale Id 67 for retail product','2022-12-24 15:09:10','',''),('1','308',145,'','20','2',1500.00,0.00,'Retail Sale Id 68 for 1.95 KG of Cooking Gas @ N770.00','2022-12-24 15:10:24','',''),('1','308',146,'','6.1','3',0.00,1500.00,'Retail Sale Id 68 for retail product','2022-12-24 15:10:24','',''),('1','308',147,'','20','2',2000.00,0.00,'Retail Sale Id 69 for 2.60 KG of Cooking Gas @ N770.00','2022-12-24 15:13:11','',''),('1','308',148,'','6.1','3',0.00,2000.00,'Retail Sale Id 69 for retail product','2022-12-24 15:13:11','',''),('1','308',149,'','20','2',1500.00,0.00,'Retail Sale Id 70 for 1.95 KG of Cooking Gas @ N770.00','2022-12-24 15:15:05','',''),('1','308',150,'','6.1','3',0.00,1500.00,'Retail Sale Id 70 for retail product','2022-12-24 15:15:05','',''),('1','308',151,'','20','2',3000.00,0.00,'Retail Sale Id 71 for 3.90 KG of Cooking Gas @ N770.00','2022-12-24 15:17:45','',''),('1','308',152,'','6.1','3',0.00,3000.00,'Retail Sale Id 71 for retail product','2022-12-24 15:17:45','',''),('1','308',153,'','20','2',6000.00,0.00,'Retail Sale Id 72 for 7.79 KG of Cooking Gas @ N770.00','2022-12-24 15:19:32','',''),('1','308',154,'','6.1','3',0.00,6000.00,'Retail Sale Id 72 for retail product','2022-12-24 15:19:32','',''),('1','308',155,'','20','2',2000.00,0.00,'Retail Sale Id 73 for 2.60 KG of Cooking Gas @ N770.00','2022-12-24 15:21:34','',''),('1','308',156,'','6.1','3',0.00,2000.00,'Retail Sale Id 73 for retail product','2022-12-24 15:21:34','',''),('1','308',157,'','20','2',1540.00,0.00,'Retail Sale Id 74 for 2.00 KG of Cooking Gas @ N770.00','2022-12-24 15:36:40','',''),('1','308',158,'','6.1','3',0.00,1540.00,'Retail Sale Id 74 for retail product','2022-12-24 15:36:40','',''),('1','308',159,'','20','2',1500.00,0.00,'Retail Sale Id 75 for 1.95 KG of Cooking Gas @ N770.00','2022-12-24 15:47:01','',''),('1','308',160,'','6.1','3',0.00,1500.00,'Retail Sale Id 75 for retail product','2022-12-24 15:47:01','',''),('1','308',161,'','20','2',800.00,0.00,'Retail Sale Id 76 for 1.04 KG of Cooking Gas @ N770.00','2022-12-24 15:47:47','',''),('1','308',162,'','6.1','3',0.00,800.00,'Retail Sale Id 76 for retail product','2022-12-24 15:47:47','',''),('1','308',163,'','20','2',800.00,0.00,'Retail Sale Id 77 for 1.04 KG of Cooking Gas @ N770.00','2022-12-24 15:48:42','',''),('1','308',164,'','6.1','3',0.00,800.00,'Retail Sale Id 77 for retail product','2022-12-24 15:48:42','',''),('1','308',165,'','20','2',2310.00,0.00,'Retail Sale Id 78 for 3.00 KG of Cooking Gas @ N770.00','2022-12-24 15:50:13','',''),('1','308',166,'','6.1','3',0.00,2310.00,'Retail Sale Id 78 for retail product','2022-12-24 15:50:13','',''),('1','308',167,'','20','2',1500.00,0.00,'Retail Sale Id 79 for 1.95 KG of Cooking Gas @ N770.00','2022-12-24 15:52:57','',''),('1','308',168,'','6.1','3',0.00,1500.00,'Retail Sale Id 79 for retail product','2022-12-24 15:52:57','',''),('1','308',169,'','20','2',1550.00,0.00,'Retail Sale Id 80 for 2.01 KG of Cooking Gas @ N770.00','2022-12-24 15:54:28','',''),('1','308',170,'','6.1','3',0.00,1550.00,'Retail Sale Id 80 for retail product','2022-12-24 15:54:28','',''),('1','308',171,'','20','2',3850.00,0.00,'Retail Sale Id 81 for 5.00 KG of Cooking Gas @ N770.00','2022-12-24 15:59:06','',''),('1','308',172,'','6.1','3',0.00,3850.00,'Retail Sale Id 81 for retail product','2022-12-24 15:59:06','',''),('1','308',173,'','20','2',2350.00,0.00,'Retail Sale Id 82 for 3.05 KG of Cooking Gas @ N770.00','2022-12-24 16:18:38','',''),('1','308',174,'','6.1','3',0.00,2350.00,'Retail Sale Id 82 for retail product','2022-12-24 16:18:38','',''),('1','308',175,'','20','2',2300.00,0.00,'Retail Sale Id 83 for 2.99 KG of Cooking Gas @ N770.00','2022-12-24 16:29:55','',''),('1','308',176,'','6.1','3',0.00,2300.00,'Retail Sale Id 83 for retail product','2022-12-24 16:29:55','',''),('1','308',177,'','20','2',4650.00,0.00,'Retail Sale Id 84 for 6.04 KG of Cooking Gas @ N770.00','2022-12-24 16:35:17','',''),('1','308',178,'','6.1','3',0.00,4650.00,'Retail Sale Id 84 for retail product','2022-12-24 16:35:17','',''),('1','308',179,'','20','2',5400.00,0.00,'Retail Sale Id 85 for 7.01 KG of Cooking Gas @ N770.00','2022-12-24 16:38:36','',''),('1','308',180,'','6.1','3',0.00,5400.00,'Retail Sale Id 85 for retail product','2022-12-24 16:38:36','',''),('1','308',181,'','20','2',2310.00,0.00,'Retail Sale Id 86 for 3.00 KG of Cooking Gas @ N770.00','2022-12-24 17:10:28','',''),('1','308',182,'','6.1','3',0.00,2310.00,'Retail Sale Id 86 for retail product','2022-12-24 17:10:28','',''),('1','308',183,'','20','2',3100.00,0.00,'Retail Sale Id 87 for 4.03 KG of Cooking Gas @ N770.00','2022-12-24 17:28:56','',''),('1','308',184,'','6.1','3',0.00,3100.00,'Retail Sale Id 87 for retail product','2022-12-24 17:28:56','',''),('1','308',185,'','20','2',3100.00,0.00,'Retail Sale Id 88 for 4.03 KG of Cooking Gas @ N770.00','2022-12-24 17:30:37','',''),('1','308',186,'','6.1','3',0.00,3100.00,'Retail Sale Id 88 for retail product','2022-12-24 17:30:37','',''),('1','308',187,'','20','2',800.00,0.00,'Retail Sale Id 89 for 1.04 KG of Cooking Gas @ N770.00','2022-12-24 17:38:25','',''),('1','308',188,'','6.1','3',0.00,800.00,'Retail Sale Id 89 for retail product','2022-12-24 17:38:25','',''),('1','308',189,'','20','2',800.00,0.00,'Retail Sale Id 90 for 1.04 KG of Cooking Gas @ N770.00','2022-12-24 18:06:29','',''),('1','308',190,'','6.1','3',0.00,800.00,'Retail Sale Id 90 for retail product','2022-12-24 18:06:29','',''),('1','308',191,'','20','2',3100.00,0.00,'Retail Sale Id 91 for 4.03 KG of Cooking Gas @ N770.00','2022-12-24 18:07:38','',''),('1','308',192,'','6.1','3',0.00,3100.00,'Retail Sale Id 91 for retail product','2022-12-24 18:07:38','',''),('1','308',193,'','20','2',1600.00,0.00,'Retail Sale Id 92 for 2.08 KG of Cooking Gas @ N770.00','2022-12-24 18:09:02','',''),('1','308',194,'','6.1','3',0.00,1600.00,'Retail Sale Id 92 for retail product','2022-12-24 18:09:02','',''),('1','308',195,'','20','2',1000.00,0.00,'Retail Sale Id 93 for 1.30 KG of Cooking Gas @ N770.00','2022-12-24 18:13:38','',''),('1','308',196,'','6.1','3',0.00,1000.00,'Retail Sale Id 93 for retail product','2022-12-24 18:13:38','',''),('1','308',197,'','20','2',0.00,35500.00,'Return of Retail Sale Id 59 for products','2022-12-24 19:10:12','',''),('1','308',198,'','','',35500.00,0.00,'Return of Retail Sale Id 59 for products','2022-12-24 19:10:12','',''),('1','308',199,'','20','2',37630.00,0.00,'Retail Sale Id 94 for 53.00 KG of Cooking Gas @ N710.00','2022-12-24 19:12:05','',''),('1','308',200,'','6.1','3',0.00,37630.00,'Retail Sale Id 94 for retail product','2022-12-24 19:12:05','',''),('1','308',201,'','20','2',0.00,0.00,'Sales from shift 3 on 2022-12-24 19:26:06 ','2022-12-24 19:26:06','',''),('1','308',202,'','6.1','3',0.00,0.00,'Sales from shift 3 on 2022-12-24 19:26:06 ','2022-12-24 19:26:06','',''),('1','308',203,'','20','2',2310.00,0.00,'Retail Sale Id 95 for 3.00 KG of Cooking Gas @ N770.00','2022-12-25 08:21:36','',''),('1','308',204,'','6.1','3',0.00,2310.00,'Retail Sale Id 95 for retail product','2022-12-25 08:21:36','',''),('1','308',205,'','20','2',3100.00,0.00,'Retail Sale Id 96 for 4.03 KG of Cooking Gas @ N770.00','2022-12-25 08:40:52','',''),('1','308',206,'','6.1','3',0.00,3100.00,'Retail Sale Id 96 for retail product','2022-12-25 08:40:52','',''),('1','308',207,'','20','2',4650.00,0.00,'Retail Sale Id 97 for 6.04 KG of Cooking Gas @ N770.00','2022-12-25 08:47:01','',''),('1','308',208,'','6.1','3',0.00,4650.00,'Retail Sale Id 97 for retail product','2022-12-25 08:47:01','',''),('1','308',209,'','20','2',7700.00,0.00,'Retail Sale Id 98 for 10.00 KG of Cooking Gas @ N770.00','2022-12-25 09:23:40','',''),('1','308',210,'','6.1','3',0.00,7700.00,'Retail Sale Id 98 for retail product','2022-12-25 09:23:40','',''),('1','308',211,'','20','2',1540.00,0.00,'Retail Sale Id 99 for 2.00 KG of Cooking Gas @ N770.00','2022-12-25 10:30:13','',''),('1','308',212,'','6.1','3',0.00,1540.00,'Retail Sale Id 99 for retail product','2022-12-25 10:30:13','',''),('1','308',213,'','20','2',5998.30,0.00,'Retail Sale Id 100 for 7.79 KG of Cooking Gas @ N770.00','2022-12-25 11:47:41','',''),('1','308',214,'','6.1','3',0.00,5998.30,'Retail Sale Id 100 for retail product','2022-12-25 11:47:41','',''),('1','308',215,'','20','2',1540.00,0.00,'Retail Sale Id 101 for 2.00 KG of Cooking Gas @ N770.00','2022-12-25 11:48:49','',''),('1','308',216,'','6.1','3',0.00,1540.00,'Retail Sale Id 101 for retail product','2022-12-25 11:48:49','',''),('1','308',217,'','20','2',1001.00,0.00,'Retail Sale Id 103 for 1.30 KG of Cooking Gas @ N770.00','2022-12-25 11:49:51','',''),('1','308',218,'','6.1','3',0.00,1001.00,'Retail Sale Id 103 for retail product','2022-12-25 11:49:51','',''),('1','308',219,'','20','2',1540.00,0.00,'Retail Sale Id 104 for 2.00 KG of Cooking Gas @ N770.00','2022-12-25 11:51:11','',''),('1','308',220,'','6.1','3',0.00,1540.00,'Retail Sale Id 104 for retail product','2022-12-25 11:51:11','',''),('1','308',221,'','20','2',3850.00,0.00,'Retail Sale Id 105 for 5.00 KG of Cooking Gas @ N770.00','2022-12-25 11:51:50','',''),('1','308',222,'','6.1','3',0.00,3850.00,'Retail Sale Id 105 for retail product','2022-12-25 11:51:50','',''),('1','308',223,'','20','2',793.10,0.00,'Retail Sale Id 106 for 1.03 KG of Cooking Gas @ N770.00','2022-12-25 11:54:42','',''),('1','308',224,'','6.1','3',0.00,793.10,'Retail Sale Id 106 for retail product','2022-12-25 11:54:42','',''),('1','308',225,'','20','2',1540.00,0.00,'Retail Sale Id 107 for 2.00 KG of Cooking Gas @ N770.00','2022-12-25 11:55:23','',''),('1','308',226,'','6.1','3',0.00,1540.00,'Retail Sale Id 107 for retail product','2022-12-25 11:55:23','',''),('1','308',227,'','20','2',4600.00,0.00,'Retail Sale Id 108 for 5.97 KG of Cooking Gas @ N770.00','2022-12-25 11:56:16','',''),('1','308',228,'','6.1','3',0.00,4600.00,'Retail Sale Id 108 for retail product','2022-12-25 11:56:16','',''),('1','308',229,'','20','2',1540.00,0.00,'Retail Sale Id 109 for 2.00 KG of Cooking Gas @ N770.00','2022-12-25 11:56:56','',''),('1','308',230,'','6.1','3',0.00,1540.00,'Retail Sale Id 109 for retail product','2022-12-25 11:56:56','',''),('1','308',231,'','20','2',793.10,0.00,'Retail Sale Id 110 for 1.03 KG of Cooking Gas @ N770.00','2022-12-25 12:30:56','',''),('1','308',232,'','6.1','3',0.00,793.10,'Retail Sale Id 110 for retail product','2022-12-25 12:30:56','',''),('1','308',233,'','20','2',4650.00,0.00,'Retail Sale Id 111 for 6.04 KG of Cooking Gas @ N770.00','2022-12-25 12:40:14','',''),('1','308',234,'','6.1','3',0.00,4650.00,'Retail Sale Id 111 for retail product','2022-12-25 12:40:14','',''),('1','308',235,'','20','2',5000.00,0.00,'Retail Sale Id 112 for 6.49 KG of Cooking Gas @ N770.00','2022-12-25 15:33:43','',''),('1','308',236,'','6.1','3',0.00,5000.00,'Retail Sale Id 112 for retail product','2022-12-25 15:33:43','',''),('1','308',237,'','20','2',2350.00,0.00,'Retail Sale Id 114 for 3.05 KG of Cooking Gas @ N770.00','2022-12-25 16:24:06','',''),('1','308',238,'','6.1','3',0.00,2350.00,'Retail Sale Id 114 for retail product','2022-12-25 16:24:06','',''),('1','308',239,'','20','2',13028.40,0.00,'Retail Sale Id 115 for 16.92 KG of Cooking Gas @ N770.00','2022-12-25 18:14:49','',''),('1','308',240,'','6.1','3',0.00,13028.40,'Retail Sale Id 115 for retail product','2022-12-25 18:14:49','',''),('1','308',241,'','20','2',0.00,13028.40,'Return of Retail Sale Id 115 for products','2022-12-25 18:17:56','',''),('1','308',242,'','','',13028.40,0.00,'Return of Retail Sale Id 115 for products','2022-12-25 18:17:56','',''),('1','308',243,'','20','2',11024.50,0.00,'Retail Sale Id 116 for 14.32 KG of Cooking Gas @ N770.00','2022-12-25 18:19:25','',''),('1','308',244,'','6.1','3',0.00,11024.50,'Retail Sale Id 116 for retail product','2022-12-25 18:19:25','',''),('1','308',245,'','20','2',2002.00,0.00,'Retail Sale Id 117 for 2.60 KG of Cooking Gas @ N770.00','2022-12-25 18:29:25','',''),('1','308',246,'','6.1','3',0.00,2002.00,'Retail Sale Id 117 for retail product','2022-12-25 18:29:25','',''),('1','308',247,'','20','2',0.00,2002.00,'Return of Retail Sale Id 117 for products','2022-12-25 18:31:23','',''),('1','308',248,'','','',2002.00,0.00,'Return of Retail Sale Id 117 for products','2022-12-25 18:31:23','',''),('1','308',249,'','20','2',0.00,0.00,'Sales from shift 4 on 2022-12-25 18:32:35 ','2022-12-25 18:32:35','',''),('1','308',250,'','6.1','3',0.00,0.00,'Sales from shift 4 on 2022-12-25 18:32:35 ','2022-12-25 18:32:35','',''),('1','308',251,'','20','2',4658.50,0.00,'Retail Sale Id 118 for 6.05 KG of Cooking Gas @ N770.00','2022-12-26 08:07:34','',''),('1','308',252,'','6.1','3',0.00,4658.50,'Retail Sale Id 118 for retail product','2022-12-26 08:07:34','',''),('1','308',253,'','20','2',3050.00,0.00,'Retail Sale Id 119 for 3.96 KG of Cooking Gas @ N770.00','2022-12-26 09:40:29','',''),('1','308',254,'','6.1','3',0.00,3050.00,'Retail Sale Id 119 for retail product','2022-12-26 09:40:29','',''),('1','308',255,'','20','2',1540.00,0.00,'Retail Sale Id 120 for 2.00 KG of Cooking Gas @ N770.00','2022-12-26 10:29:27','',''),('1','308',256,'','6.1','3',0.00,1540.00,'Retail Sale Id 120 for retail product','2022-12-26 10:29:27','',''),('1','308',257,'','20','2',2300.00,0.00,'Retail Sale Id 121 for 2.99 KG of Cooking Gas @ N770.00','2022-12-26 11:00:25','',''),('1','308',258,'','6.1','3',0.00,2300.00,'Retail Sale Id 121 for retail product','2022-12-26 11:00:25','',''),('1','308',259,'','20','2',3150.00,0.00,'Retail Sale Id 122 for 4.09 KG of Cooking Gas @ N770.00','2022-12-26 14:28:58','',''),('1','308',260,'','6.1','3',0.00,3150.00,'Retail Sale Id 122 for retail product','2022-12-26 14:28:58','',''),('1','308',261,'','20','2',3850.00,0.00,'Retail Sale Id 123 for 5.00 KG of Cooking Gas @ N770.00','2022-12-26 16:35:34','',''),('1','308',262,'','6.1','3',0.00,3850.00,'Retail Sale Id 123 for retail product','2022-12-26 16:35:34','',''),('1','308',263,'','20','2',3850.00,0.00,'Retail Sale Id 127 for 5.00 KG of Cooking Gas @ N770.00','2022-12-26 18:12:22','',''),('1','308',264,'','6.1','3',0.00,3850.00,'Retail Sale Id 127 for retail product','2022-12-26 18:12:22','',''),('1','308',265,'','20','2',16171.30,0.00,'Retail Sale Id 128 for 21.00 KG of Cooking Gas @ N770.00','2022-12-26 20:48:51','',''),('1','308',266,'','6.1','3',0.00,16171.30,'Retail Sale Id 128 for retail product','2022-12-26 20:48:51','',''),('1','308',267,'','20','2',384.00,0.00,'Retail Sale Id 129 for 0.50 KG of Cooking Gas @ N770.00','2022-12-26 20:54:26','',''),('1','308',268,'','6.1','3',0.00,384.00,'Retail Sale Id 129 for retail product','2022-12-26 20:54:26','',''),('1','308',269,'','20','2',0.00,0.00,'Sales from shift 5 on 2022-12-26 20:55:50 ','2022-12-26 20:55:50','',''),('1','308',270,'','6.1','3',0.00,0.00,'Sales from shift 5 on 2022-12-26 20:55:50 ','2022-12-26 20:55:50','',''),('1','308',271,'','20','2',6170.00,0.00,'Retail Sale Id 130 for 8.01 KG of Cooking Gas @ N770.00','2022-12-27 08:34:06','',''),('1','308',272,'','6.1','3',0.00,6170.00,'Retail Sale Id 130 for retail product','2022-12-27 08:34:06','',''),('1','308',273,'','20','2',2310.00,0.00,'Retail Sale Id 132 for 3.00 KG of Cooking Gas @ N770.00','2022-12-27 09:18:50','',''),('1','308',274,'','6.1','3',0.00,2310.00,'Retail Sale Id 132 for retail product','2022-12-27 09:18:50','',''),('1','308',275,'','20','2',1000.00,0.00,'Retail Sale Id 133 for 1.30 KG of Cooking Gas @ N770.00','2022-12-27 09:41:15','',''),('1','308',276,'','6.1','3',0.00,1000.00,'Retail Sale Id 133 for retail product','2022-12-27 09:41:15','',''),('1','308',277,'','20','2',770.00,0.00,'Retail Sale Id 134 for 1.00 KG of Cooking Gas @ N770.00','2022-12-27 10:24:26','',''),('1','308',278,'','6.1','3',0.00,770.00,'Retail Sale Id 134 for retail product','2022-12-27 10:24:26','',''),('1','308',279,'','20','2',4620.00,0.00,'Retail Sale Id 135 for 6.00 KG of Cooking Gas @ N770.00','2022-12-27 11:12:56','',''),('1','308',280,'','6.1','3',0.00,4620.00,'Retail Sale Id 135 for retail product','2022-12-27 11:12:56','',''),('1','308',281,'','20','2',38500.00,0.00,'Retail Sale Id 136 for 50.00 KG of Cooking Gas @ N770.00','2022-12-27 13:27:52','',''),('1','308',282,'','6.1','3',0.00,38500.00,'Retail Sale Id 136 for retail product','2022-12-27 13:27:52','',''),('1','308',283,'','20','2',0.00,38500.00,'Return of Retail Sale Id 136 for products','2022-12-27 13:28:37','',''),('1','308',284,'','','',38500.00,0.00,'Return of Retail Sale Id 136 for products','2022-12-27 13:28:37','',''),('1','308',285,'','20','2',35500.00,0.00,'Retail Sale Id 137 for 50.00 KG of Cooking Gas @ N710.00','2022-12-27 13:29:27','',''),('1','308',286,'','6.1','3',0.00,35500.00,'Retail Sale Id 137 for retail product','2022-12-27 13:29:27','',''),('1','308',287,'','20','2',4620.00,0.00,'Retail Sale Id 138 for 6.00 KG of Cooking Gas @ N770.00','2022-12-27 13:33:30','',''),('1','308',288,'','6.1','3',0.00,4620.00,'Retail Sale Id 138 for retail product','2022-12-27 13:33:30','',''),('1','308',289,'','20','2',3850.00,0.00,'Retail Sale Id 139 for 5.00 KG of Cooking Gas @ N770.00','2022-12-27 13:37:31','',''),('1','308',290,'','6.1','3',0.00,3850.00,'Retail Sale Id 139 for retail product','2022-12-27 13:37:31','',''),('1','308',291,'','20','2',4620.00,0.00,'Retail Sale Id 140 for 6.00 KG of Cooking Gas @ N770.00','2022-12-27 13:39:39','',''),('1','308',292,'','6.1','3',0.00,4620.00,'Retail Sale Id 140 for retail product','2022-12-27 13:39:39','',''),('1','308',293,'','20','2',1540.00,0.00,'Retail Sale Id 141 for 2.00 KG of Cooking Gas @ N770.00','2022-12-27 13:41:43','',''),('1','308',294,'','6.1','3',0.00,1540.00,'Retail Sale Id 141 for retail product','2022-12-27 13:41:43','',''),('1','308',295,'','20','2',3080.00,0.00,'Retail Sale Id 142 for 4.00 KG of Cooking Gas @ N770.00','2022-12-27 17:39:57','',''),('1','308',296,'','6.1','3',0.00,3080.00,'Retail Sale Id 142 for retail product','2022-12-27 17:39:57','',''),('1','308',297,'','20','2',9625.00,0.00,'Retail Sale Id 143 for 12.50 KG of Cooking Gas @ N770.00','2022-12-27 17:41:33','',''),('1','308',298,'','6.1','3',0.00,9625.00,'Retail Sale Id 143 for retail product','2022-12-27 17:41:33','',''),('1','308',299,'','20','2',2330.00,0.00,'Retail Sale Id 145 for 3.03 KG of Cooking Gas @ N770.00','2022-12-27 18:03:41','',''),('1','308',300,'','6.1','3',0.00,2330.00,'Retail Sale Id 145 for retail product','2022-12-27 18:03:41','',''),('1','308',301,'','20','2',3080.00,0.00,'Retail Sale Id 146 for 4.00 KG of Cooking Gas @ N770.00','2022-12-27 18:07:38','',''),('1','308',302,'','6.1','3',0.00,3080.00,'Retail Sale Id 146 for retail product','2022-12-27 18:07:38','',''),('1','308',303,'','6.1','3',0.00,3080.00,'Retail Sale Id 146 for retail product','2022-12-27 18:07:38','',''),('1','308',304,'','20','2',2310.00,0.00,'Retail Sale Id 147 for 3.00 KG of Cooking Gas @ N770.00','2022-12-27 18:18:47','',''),('1','308',305,'','6.1','3',0.00,2310.00,'Retail Sale Id 147 for retail product','2022-12-27 18:18:47','',''),('1','308',306,'','20','2',0.00,1000.00,'Return of Retail Sale Id 133 for products','2022-12-27 19:49:47','',''),('1','308',307,'','','',1000.00,0.00,'Return of Retail Sale Id 133 for products','2022-12-27 19:49:47','',''),('1','308',308,'','20','2',0.00,4620.00,'Return of Retail Sale Id 138 for products','2022-12-27 19:55:18','',''),('1','308',309,'','','',4620.00,0.00,'Return of Retail Sale Id 138 for products','2022-12-27 19:55:18','',''),('1','308',310,'','20','2',2555.00,0.00,'Retail Sale Id 148 for 3.32 KG of Cooking Gas @ N770.00','2022-12-27 19:56:57','',''),('1','308',311,'','6.1','3',0.00,2555.00,'Retail Sale Id 148 for retail product','2022-12-27 19:56:57','',''),('1','308',312,'','20','2',0.00,0.00,'Sales from shift 6 on 2022-12-27 19:58:18 ','2022-12-27 19:58:18','',''),('1','308',313,'','6.1','3',0.00,0.00,'Sales from shift 6 on 2022-12-27 19:58:18 ','2022-12-27 19:58:18','',''),('1','308',314,'','20','2',770.00,0.00,'Retail Sale Id 149 for 1.00 KG of Cooking Gas @ N770.00','2022-12-28 08:57:54','',''),('1','308',315,'','6.1','3',0.00,770.00,'Retail Sale Id 149 for retail product','2022-12-28 08:57:54','',''),('1','308',316,'','20','2',2350.00,0.00,'Retail Sale Id 150 for 3.05 KG of Cooking Gas @ N770.00','2022-12-28 09:00:52','',''),('1','308',317,'','6.1','3',0.00,2350.00,'Retail Sale Id 150 for retail product','2022-12-28 09:00:52','',''),('1','308',318,'','20','2',1550.00,0.00,'Retail Sale Id 151 for 2.01 KG of Cooking Gas @ N770.00','2022-12-28 09:02:30','',''),('1','308',319,'','6.1','3',0.00,1550.00,'Retail Sale Id 151 for retail product','2022-12-28 09:02:30','',''),('1','308',320,'','20','2',2000.00,0.00,'Retail Sale Id 152 for 2.60 KG of Cooking Gas @ N770.00','2022-12-28 09:21:42','',''),('1','308',321,'','6.1','3',0.00,2000.00,'Retail Sale Id 152 for retail product','2022-12-28 09:21:42','',''),('1','308',322,'','20','2',2310.00,0.00,'Retail Sale Id 153 for 3.00 KG of Cooking Gas @ N770.00','2022-12-28 09:28:46','',''),('1','308',323,'','6.1','3',0.00,2310.00,'Retail Sale Id 153 for retail product','2022-12-28 09:28:46','',''),('1','308',324,'','20','2',4620.00,0.00,'Retail Sale Id 154 for 6.00 KG of Cooking Gas @ N770.00','2022-12-28 10:17:28','',''),('1','308',325,'','6.1','3',0.00,4620.00,'Retail Sale Id 154 for retail product','2022-12-28 10:17:28','',''),('1','308',326,'','20','2',1000.00,0.00,'Retail Sale Id 155 for 1.30 KG of Cooking Gas @ N770.00','2022-12-28 10:18:21','',''),('1','308',327,'','6.1','3',0.00,1000.00,'Retail Sale Id 155 for retail product','2022-12-28 10:18:21','',''),('1','308',328,'','20','2',2310.00,0.00,'Retail Sale Id 156 for 3.00 KG of Cooking Gas @ N770.00','2022-12-28 10:19:40','',''),('1','308',329,'','6.1','3',0.00,2310.00,'Retail Sale Id 156 for retail product','2022-12-28 10:19:40','',''),('1','308',330,'','20','2',35500.00,0.00,'Retail Sale Id 157 for 50.00 KG of Cooking Gas @ N710.00','2022-12-28 13:43:08','',''),('1','308',331,'','6.1','3',0.00,35500.00,'Retail Sale Id 157 for retail product','2022-12-28 13:43:08','',''),('1','308',332,'','20','2',2310.00,0.00,'Retail Sale Id 158 for 3.00 KG of Cooking Gas @ N770.00','2022-12-28 13:50:12','',''),('1','308',333,'','6.1','3',0.00,2310.00,'Retail Sale Id 158 for retail product','2022-12-28 13:50:12','',''),('1','308',334,'','20','2',800.00,0.00,'Retail Sale Id 159 for 1.04 KG of Cooking Gas @ N770.00','2022-12-28 13:54:41','',''),('1','308',335,'','6.1','3',0.00,800.00,'Retail Sale Id 159 for retail product','2022-12-28 13:54:41','',''),('1','308',336,'','20','2',800.00,0.00,'Retail Sale Id 160 for 1.04 KG of Cooking Gas @ N770.00','2022-12-28 13:58:21','',''),('1','308',337,'','6.1','3',0.00,800.00,'Retail Sale Id 160 for retail product','2022-12-28 13:58:21','',''),('1','308',338,'','20','2',142000.00,0.00,'Retail Sale Id 161 for 200.00 KG of Cooking Gas @ N710.00','2022-12-28 14:57:52','',''),('1','308',339,'','6.1','3',0.00,142000.00,'Retail Sale Id 161 for retail product','2022-12-28 14:57:52','',''),('1','308',340,'','20','2',1000.00,0.00,'Retail Sale Id 162 for 1.30 KG of Cooking Gas @ N770.00','2022-12-28 16:48:45','',''),('1','308',341,'','6.1','3',0.00,1000.00,'Retail Sale Id 162 for retail product','2022-12-28 16:48:45','',''),('1','308',342,'','20','2',3850.00,0.00,'Retail Sale Id 163 for 5.00 KG of Cooking Gas @ N770.00','2022-12-28 16:50:15','',''),('1','308',343,'','6.1','3',0.00,3850.00,'Retail Sale Id 163 for retail product','2022-12-28 16:50:15','',''),('1','308',344,'','20','2',1550.00,0.00,'Retail Sale Id 164 for 2.01 KG of Cooking Gas @ N770.00','2022-12-28 16:53:57','',''),('1','308',345,'','6.1','3',0.00,1550.00,'Retail Sale Id 164 for retail product','2022-12-28 16:53:57','',''),('1','308',346,'','20','2',2310.00,0.00,'Retail Sale Id 165 for 3.00 KG of Cooking Gas @ N770.00','2022-12-28 16:55:50','',''),('1','308',347,'','6.1','3',0.00,2310.00,'Retail Sale Id 165 for retail product','2022-12-28 16:55:50','',''),('1','308',348,'','20','2',7700.00,0.00,'Retail Sale Id 166 for 10.00 KG of Cooking Gas @ N770.00','2022-12-28 16:57:25','',''),('1','308',349,'','6.1','3',0.00,7700.00,'Retail Sale Id 166 for retail product','2022-12-28 16:57:25','',''),('1','308',350,'','20','2',1000.00,0.00,'Retail Sale Id 167 for 1.30 KG of Cooking Gas @ N770.00','2022-12-28 16:59:00','',''),('1','308',351,'','6.1','3',0.00,1000.00,'Retail Sale Id 167 for retail product','2022-12-28 16:59:00','',''),('1','308',352,'','20','2',1540.00,0.00,'Retail Sale Id 168 for 2.00 KG of Cooking Gas @ N770.00','2022-12-28 17:06:59','',''),('1','308',353,'','6.1','3',0.00,1540.00,'Retail Sale Id 168 for retail product','2022-12-28 17:06:59','',''),('1','308',354,'','20','2',1540.00,0.00,'Retail Sale Id 169 for 2.00 KG of Cooking Gas @ N770.00','2022-12-28 17:30:45','',''),('1','308',355,'','6.1','3',0.00,1540.00,'Retail Sale Id 169 for retail product','2022-12-28 17:30:45','',''),('1','308',356,'','20','2',2580.00,0.00,'Retail Sale Id 170 for 3.35 KG of Cooking Gas @ N770.00','2022-12-28 19:03:50','',''),('1','308',357,'','6.1','3',0.00,2580.00,'Retail Sale Id 170 for retail product','2022-12-28 19:03:50','',''),('1','308',358,'','20','2',0.00,0.00,'Sales from shift 7 on 2022-12-28 19:12:13 ','2022-12-28 19:12:13','',''),('1','308',359,'','6.1','3',0.00,0.00,'Sales from shift 7 on 2022-12-28 19:12:13 ','2022-12-28 19:12:13','',''),('1','308',360,'','20','2',4650.00,0.00,'Retail Sale Id 171 for 6.04 KG of Cooking Gas @ N770.00','2022-12-29 08:24:08','',''),('1','308',361,'','6.1','3',0.00,4650.00,'Retail Sale Id 171 for retail product','2022-12-29 08:24:08','',''),('1','308',362,'','20','2',4620.00,0.00,'Retail Sale Id 172 for 6.00 KG of Cooking Gas @ N770.00','2022-12-29 10:02:02','',''),('1','308',363,'','6.1','3',0.00,4620.00,'Retail Sale Id 172 for retail product','2022-12-29 10:02:02','',''),('1','308',364,'','20','2',2350.00,0.00,'Retail Sale Id 173 for 3.05 KG of Cooking Gas @ N770.00','2022-12-29 11:15:18','',''),('1','308',365,'','6.1','3',0.00,2350.00,'Retail Sale Id 173 for retail product','2022-12-29 11:15:18','',''),('1','308',366,'','20','2',2000.00,0.00,'Retail Sale Id 174 for 2.60 KG of Cooking Gas @ N770.00','2022-12-29 11:30:35','',''),('1','308',367,'','6.1','3',0.00,2000.00,'Retail Sale Id 174 for retail product','2022-12-29 11:30:35','',''),('1','308',368,'','20','2',2350.00,0.00,'Retail Sale Id 175 for 3.05 KG of Cooking Gas @ N770.00','2022-12-29 13:26:57','',''),('1','308',369,'','6.1','3',0.00,2350.00,'Retail Sale Id 175 for retail product','2022-12-29 13:26:57','',''),('1','308',370,'','20','2',1000.00,0.00,'Retail Sale Id 176 for 1.30 KG of Cooking Gas @ N770.00','2022-12-29 14:13:35','',''),('1','308',371,'','6.1','3',0.00,1000.00,'Retail Sale Id 176 for retail product','2022-12-29 14:13:35','',''),('1','308',372,'','20','2',1000.00,0.00,'Retail Sale Id 177 for 1.30 KG of Cooking Gas @ N770.00','2022-12-29 14:15:31','',''),('1','308',373,'','6.1','3',0.00,1000.00,'Retail Sale Id 177 for retail product','2022-12-29 14:15:31','',''),('1','308',374,'','20','2',3842.30,0.00,'Retail Sale Id 178 for 4.99 KG of Cooking Gas @ N770.00','2022-12-29 16:52:09','',''),('1','308',375,'','6.1','3',0.00,3842.30,'Retail Sale Id 178 for retail product','2022-12-29 16:52:09','',''),('1','308',376,'','20','2',4600.00,0.00,'Retail Sale Id 179 for 5.97 KG of Cooking Gas @ N770.00','2022-12-29 16:54:21','',''),('1','308',377,'','6.1','3',0.00,4600.00,'Retail Sale Id 179 for retail product','2022-12-29 16:54:21','',''),('1','308',378,'','20','2',800.00,0.00,'Retail Sale Id 180 for 1.04 KG of Cooking Gas @ N770.00','2022-12-29 17:07:14','',''),('1','308',379,'','6.1','3',0.00,800.00,'Retail Sale Id 180 for retail product','2022-12-29 17:07:14','',''),('1','308',380,'','20','2',4600.00,0.00,'Retail Sale Id 181 for 5.97 KG of Cooking Gas @ N770.00','2022-12-29 17:44:05','',''),('1','308',381,'','6.1','3',0.00,4600.00,'Retail Sale Id 181 for retail product','2022-12-29 17:44:05','',''),('1','308',382,'','20','2',3850.00,0.00,'Retail Sale Id 182 for 5.00 KG of Cooking Gas @ N770.00','2022-12-29 18:07:35','',''),('1','308',383,'','6.1','3',0.00,3850.00,'Retail Sale Id 182 for retail product','2022-12-29 18:07:35','',''),('1','308',384,'','20','2',0.00,0.00,'Sales from shift 8 on 2022-12-29 19:26:30 ','2022-12-29 19:26:30','',''),('1','308',385,'','6.1','3',0.00,0.00,'Sales from shift 8 on 2022-12-29 19:26:30 ','2022-12-29 19:26:30','',''),('1','308',386,'','20','2',2350.00,0.00,'Retail Sale Id 183 for 3.05 KG of Cooking Gas @ N770.00','2022-12-30 09:10:05','',''),('1','308',387,'','6.1','3',0.00,2350.00,'Retail Sale Id 183 for retail product','2022-12-30 09:10:05','',''),('1','308',388,'','20','2',4650.00,0.00,'Retail Sale Id 184 for 6.04 KG of Cooking Gas @ N770.00','2022-12-30 09:11:27','',''),('1','308',389,'','6.1','3',0.00,4650.00,'Retail Sale Id 184 for retail product','2022-12-30 09:11:27','',''),('1','308',390,'','20','2',2350.00,0.00,'Retail Sale Id 185 for 3.05 KG of Cooking Gas @ N770.00','2022-12-30 09:31:46','',''),('1','308',391,'','6.1','3',0.00,2350.00,'Retail Sale Id 185 for retail product','2022-12-30 09:31:46','',''),('1','308',392,'','20','2',3850.00,0.00,'Retail Sale Id 186 for 5.00 KG of Cooking Gas @ N770.00','2022-12-30 09:45:02','',''),('1','308',393,'','6.1','3',0.00,3850.00,'Retail Sale Id 186 for retail product','2022-12-30 09:45:02','',''),('1','308',394,'','20','2',1000.00,0.00,'Retail Sale Id 187 for 1.30 KG of Cooking Gas @ N770.00','2022-12-30 10:18:10','',''),('1','308',395,'','6.1','3',0.00,1000.00,'Retail Sale Id 187 for retail product','2022-12-30 10:18:10','',''),('1','308',396,'','20','2',35500.00,0.00,'Retail Sale Id 188 for 50.00 KG of Cooking Gas @ N710.00','2022-12-30 12:23:32','',''),('1','308',397,'','6.1','3',0.00,35500.00,'Retail Sale Id 188 for retail product','2022-12-30 12:23:32','',''),('1','308',398,'','20','2',1540.00,0.00,'Retail Sale Id 189 for 2.00 KG of Cooking Gas @ N770.00','2022-12-30 12:26:53','',''),('1','308',399,'','6.1','3',0.00,1540.00,'Retail Sale Id 189 for retail product','2022-12-30 12:26:53','',''),('1','308',400,'','20','2',2310.00,0.00,'Retail Sale Id 190 for 3.00 KG of Cooking Gas @ N770.00','2022-12-30 12:37:07','',''),('1','308',401,'','6.1','3',0.00,2310.00,'Retail Sale Id 190 for retail product','2022-12-30 12:37:07','',''),('1','308',402,'','20','2',500.00,0.00,'Retail Sale Id 191 for 0.65 KG of Cooking Gas @ N770.00','2022-12-30 14:43:09','',''),('1','308',403,'','6.1','3',0.00,500.00,'Retail Sale Id 191 for retail product','2022-12-30 14:43:09','',''),('1','308',404,'','20','2',35500.00,0.00,'Retail Sale Id 192 for 50.00 KG of Cooking Gas @ N710.00','2022-12-30 14:52:11','',''),('1','308',405,'','6.1','3',0.00,35500.00,'Retail Sale Id 192 for retail product','2022-12-30 14:52:11','',''),('1','308',406,'','20','2',800.00,0.00,'Retail Sale Id 193 for 1.04 KG of Cooking Gas @ N770.00','2022-12-30 15:56:12','',''),('1','308',407,'','6.1','3',0.00,800.00,'Retail Sale Id 193 for retail product','2022-12-30 15:56:12','',''),('1','308',408,'','20','2',800.00,0.00,'Retail Sale Id 194 for 1.04 KG of Cooking Gas @ N770.00','2022-12-30 15:57:43','',''),('1','308',409,'','6.1','3',0.00,800.00,'Retail Sale Id 194 for retail product','2022-12-30 15:57:43','',''),('1','308',410,'','20','2',750.00,0.00,'Retail Sale Id 196 for 0.97 KG of Cooking Gas @ N770.00','2022-12-30 16:02:24','',''),('1','308',411,'','6.1','3',0.00,750.00,'Retail Sale Id 196 for retail product','2022-12-30 16:02:24','',''),('1','308',412,'','20','2',3100.00,0.00,'Retail Sale Id 197 for 4.03 KG of Cooking Gas @ N770.00','2022-12-30 17:02:41','',''),('1','308',413,'','6.1','3',0.00,3100.00,'Retail Sale Id 197 for retail product','2022-12-30 17:02:41','',''),('1','308',414,'','20','2',4620.00,0.00,'Retail Sale Id 198 for 6.00 KG of Cooking Gas @ N770.00','2022-12-30 17:07:57','',''),('1','308',415,'','6.1','3',0.00,4620.00,'Retail Sale Id 198 for retail product','2022-12-30 17:07:57','',''),('1','308',416,'','20','2',1550.00,0.00,'Retail Sale Id 200 for 2.01 KG of Cooking Gas @ N770.00','2022-12-30 17:26:29','',''),('1','308',417,'','6.1','3',0.00,1550.00,'Retail Sale Id 200 for retail product','2022-12-30 17:26:29','',''),('1','308',418,'','20','2',0.00,4620.00,'Return of Retail Sale Id 198 for products','2022-12-30 18:12:03','',''),('1','308',419,'','','',4620.00,0.00,'Return of Retail Sale Id 198 for products','2022-12-30 18:12:03','',''),('1','308',420,'','20','2',1361.00,0.00,'Retail Sale Id 201 for 1.77 KG of Cooking Gas @ N770.00','2022-12-30 18:14:02','',''),('1','308',421,'','6.1','3',0.00,1361.00,'Retail Sale Id 201 for retail product','2022-12-30 18:14:02','',''),('1','308',422,'','20','2',0.00,0.00,'Sales from shift 9 on 2022-12-30 19:15:59 ','2022-12-30 19:15:59','',''),('1','308',423,'','6.1','3',0.00,0.00,'Sales from shift 9 on 2022-12-30 19:15:59 ','2022-12-30 19:15:59','',''),('1','308',424,'','20','2',800.00,0.00,'Retail Sale Id 202 for 1.04 KG of Cooking Gas @ N770.00','2022-12-31 08:28:32','',''),('1','308',425,'','6.1','3',0.00,800.00,'Retail Sale Id 202 for retail product','2022-12-31 08:28:32','',''),('1','308',426,'','20','2',13450.00,0.00,'Retail Sale Id 203 for 17.47 KG of Cooking Gas @ N770.00','2022-12-31 08:29:52','',''),('1','308',427,'','6.1','3',0.00,13450.00,'Retail Sale Id 203 for retail product','2022-12-31 08:29:52','',''),('1','308',428,'','20','2',1550.00,0.00,'Retail Sale Id 204 for 2.01 KG of Cooking Gas @ N770.00','2022-12-31 09:06:27','',''),('1','308',429,'','6.1','3',0.00,1550.00,'Retail Sale Id 204 for retail product','2022-12-31 09:06:27','',''),('1','308',430,'','20','2',1550.00,0.00,'Retail Sale Id 205 for 2.01 KG of Cooking Gas @ N770.00','2022-12-31 09:47:36','',''),('1','308',431,'','6.1','3',0.00,1550.00,'Retail Sale Id 205 for retail product','2022-12-31 09:47:36','',''),('1','308',432,'','20','2',1550.00,0.00,'Retail Sale Id 206 for 2.01 KG of Cooking Gas @ N770.00','2022-12-31 09:55:22','',''),('1','308',433,'','6.1','3',0.00,1550.00,'Retail Sale Id 206 for retail product','2022-12-31 09:55:22','',''),('1','308',434,'','20','2',1550.00,0.00,'Retail Sale Id 207 for 2.01 KG of Cooking Gas @ N770.00','2022-12-31 09:57:00','',''),('1','308',435,'','6.1','3',0.00,1550.00,'Retail Sale Id 207 for retail product','2022-12-31 09:57:00','',''),('1','308',436,'','20','2',3100.00,0.00,'Retail Sale Id 208 for 4.03 KG of Cooking Gas @ N770.00','2022-12-31 10:01:02','',''),('1','308',437,'','6.1','3',0.00,3100.00,'Retail Sale Id 208 for retail product','2022-12-31 10:01:02','',''),('1','308',438,'','20','2',4620.00,0.00,'Retail Sale Id 209 for 6.00 KG of Cooking Gas @ N770.00','2022-12-31 11:26:58','',''),('1','308',439,'','6.1','3',0.00,4620.00,'Retail Sale Id 209 for retail product','2022-12-31 11:26:58','',''),('1','308',440,'','20','2',1550.00,0.00,'Retail Sale Id 210 for 2.01 KG of Cooking Gas @ N770.00','2022-12-31 12:11:00','',''),('1','308',441,'','6.1','3',0.00,1550.00,'Retail Sale Id 210 for retail product','2022-12-31 12:11:00','',''),('1','308',442,'','20','2',2310.00,0.00,'Retail Sale Id 211 for 3.00 KG of Cooking Gas @ N770.00','2022-12-31 12:14:41','',''),('1','308',443,'','6.1','3',0.00,2310.00,'Retail Sale Id 211 for retail product','2022-12-31 12:14:41','',''),('1','308',444,'','20','2',800.00,0.00,'Retail Sale Id 212 for 1.04 KG of Cooking Gas @ N770.00','2022-12-31 12:43:32','',''),('1','308',445,'','6.1','3',0.00,800.00,'Retail Sale Id 212 for retail product','2022-12-31 12:43:32','',''),('1','308',446,'','6.1','3',0.00,800.00,'Retail Sale Id 212 for retail product','2022-12-31 12:43:32','',''),('1','308',447,'','20','2',1550.00,0.00,'Retail Sale Id 213 for 2.01 KG of Cooking Gas @ N770.00','2022-12-31 12:59:08','',''),('1','308',448,'','6.1','3',0.00,1550.00,'Retail Sale Id 213 for retail product','2022-12-31 12:59:08','',''),('1','308',449,'','20','2',7100.00,0.00,'Retail Sale Id 214 for 10.00 KG of Cooking Gas @ N710.00','2022-12-31 13:56:04','',''),('1','308',450,'','6.1','3',0.00,7100.00,'Retail Sale Id 214 for retail product','2022-12-31 13:56:04','',''),('1','308',451,'','20','2',3850.00,0.00,'Retail Sale Id 215 for 5.00 KG of Cooking Gas @ N770.00','2022-12-31 14:39:17','',''),('1','308',452,'','6.1','3',0.00,3850.00,'Retail Sale Id 215 for retail product','2022-12-31 14:39:17','',''),('1','308',453,'','20','2',6930.00,0.00,'Retail Sale Id 216 for 9.00 KG of Cooking Gas @ N770.00','2022-12-31 14:40:39','',''),('1','308',454,'','6.1','3',0.00,6930.00,'Retail Sale Id 216 for retail product','2022-12-31 14:40:39','',''),('1','308',455,'','20','2',3100.00,0.00,'Retail Sale Id 217 for 4.03 KG of Cooking Gas @ N770.00','2022-12-31 14:48:16','',''),('1','308',456,'','6.1','3',0.00,3100.00,'Retail Sale Id 217 for retail product','2022-12-31 14:48:16','',''),('1','308',457,'','20','2',1000.00,0.00,'Retail Sale Id 218 for 1.30 KG of Cooking Gas @ N770.00','2022-12-31 14:56:12','',''),('1','308',458,'','6.1','3',0.00,1000.00,'Retail Sale Id 218 for retail product','2022-12-31 14:56:12','',''),('1','308',459,'','20','2',9625.00,0.00,'Retail Sale Id 219 for 12.50 KG of Cooking Gas @ N770.00','2022-12-31 15:36:03','',''),('1','308',460,'','6.1','3',0.00,9625.00,'Retail Sale Id 219 for retail product','2022-12-31 15:36:03','',''),('1','308',461,'','20','2',4000.00,0.00,'Retail Sale Id 220 for 5.19 KG of Cooking Gas @ N770.00','2022-12-31 16:05:25','',''),('1','308',462,'','6.1','3',0.00,4000.00,'Retail Sale Id 220 for retail product','2022-12-31 16:05:25','',''),('1','308',463,'','20','2',3100.00,0.00,'Retail Sale Id 221 for 4.03 KG of Cooking Gas @ N770.00','2022-12-31 16:12:47','',''),('1','308',464,'','6.1','3',0.00,3100.00,'Retail Sale Id 221 for retail product','2022-12-31 16:12:47','',''),('1','308',465,'','20','2',3850.00,0.00,'Retail Sale Id 222 for 5.00 KG of Cooking Gas @ N770.00','2022-12-31 16:16:25','',''),('1','308',466,'','6.1','3',0.00,3850.00,'Retail Sale Id 222 for retail product','2022-12-31 16:16:25','',''),('1','308',467,'','20','2',3080.00,0.00,'Retail Sale Id 227 for 4.00 KG of Cooking Gas @ N770.00','2022-12-31 16:25:59','',''),('1','308',468,'','6.1','3',0.00,3080.00,'Retail Sale Id 227 for retail product','2022-12-31 16:25:59','',''),('1','308',469,'','20','2',800.00,0.00,'Retail Sale Id 228 for 1.04 KG of Cooking Gas @ N770.00','2022-12-31 16:43:58','',''),('1','308',470,'','6.1','3',0.00,800.00,'Retail Sale Id 228 for retail product','2022-12-31 16:43:58','',''),('1','308',471,'','20','2',2350.00,0.00,'Retail Sale Id 229 for 3.05 KG of Cooking Gas @ N770.00','2022-12-31 17:12:15','',''),('1','308',472,'','6.1','3',0.00,2350.00,'Retail Sale Id 229 for retail product','2022-12-31 17:12:15','',''),('1','308',473,'','20','2',4000.00,0.00,'Retail Sale Id 230 for 5.19 KG of Cooking Gas @ N770.00','2022-12-31 17:44:53','',''),('1','308',474,'','6.1','3',0.00,4000.00,'Retail Sale Id 230 for retail product','2022-12-31 17:44:53','',''),('1','308',475,'','20','2',1300.00,0.00,'Retail Sale Id 231 for 1.69 KG of Cooking Gas @ N770.00','2022-12-31 17:47:59','',''),('1','308',476,'','6.1','3',0.00,1300.00,'Retail Sale Id 231 for retail product','2022-12-31 17:47:59','',''),('1','308',477,'','20','2',9650.00,0.00,'Retail Sale Id 233 for 12.53 KG of Cooking Gas @ N770.00','2022-12-31 18:04:48','',''),('1','308',478,'','6.1','3',0.00,9650.00,'Retail Sale Id 233 for retail product','2022-12-31 18:04:48','',''),('1','308',479,'','20','2',3850.00,0.00,'Retail Sale Id 234 for 5.00 KG of Cooking Gas @ N770.00','2022-12-31 18:14:03','',''),('1','308',480,'','6.1','3',0.00,3850.00,'Retail Sale Id 234 for retail product','2022-12-31 18:14:03','',''),('1','308',481,'','20','2',9650.00,0.00,'Retail Sale Id 235 for 12.53 KG of Cooking Gas @ N770.00','2022-12-31 18:23:27','',''),('1','308',482,'','6.1','3',0.00,9650.00,'Retail Sale Id 235 for retail product','2022-12-31 18:23:27','',''),('1','308',483,'','20','2',0.00,1300.00,'Return of Retail Sale Id 231 for products','2022-12-31 18:36:18','',''),('1','308',484,'','','',1300.00,0.00,'Return of Retail Sale Id 231 for products','2022-12-31 18:36:18','',''),('1','308',485,'','20','2',1293.60,0.00,'Retail Sale Id 236 for 1.68 KG of Cooking Gas @ N770.00','2022-12-31 18:37:43','',''),('1','308',486,'','6.1','3',0.00,1293.60,'Retail Sale Id 236 for retail product','2022-12-31 18:37:43','',''),('1','308',487,'','20','2',0.00,0.00,'Sales from shift 10 on 2022-12-31 19:17:20 ','2022-12-31 19:17:20','',''),('1','308',488,'','6.1','3',0.00,0.00,'Sales from shift 10 on 2022-12-31 19:17:20 ','2022-12-31 19:17:20','',''),('1','308',489,'','20','2',800.00,0.00,'Retail Sale Id 237 for 1.04 KG of Cooking Gas @ N770.00','2023-01-01 09:06:22','',''),('1','308',490,'','6.1','3',0.00,800.00,'Retail Sale Id 237 for retail product','2023-01-01 09:06:22','',''),('1','308',491,'','20','2',3850.00,0.00,'Retail Sale Id 238 for 5.00 KG of Cooking Gas @ N770.00','2023-01-01 09:14:05','',''),('1','308',492,'','6.1','3',0.00,3850.00,'Retail Sale Id 238 for retail product','2023-01-01 09:14:05','',''),('1','308',493,'','20','2',5000.00,0.00,'Retail Sale Id 239 for 6.49 KG of Cooking Gas @ N770.00','2023-01-01 09:43:15','',''),('1','308',494,'','6.1','3',0.00,5000.00,'Retail Sale Id 239 for retail product','2023-01-01 09:43:15','',''),('1','308',495,'','20','2',800.00,0.00,'Retail Sale Id 240 for 1.04 KG of Cooking Gas @ N770.00','2023-01-01 09:44:50','',''),('1','308',496,'','6.1','3',0.00,800.00,'Retail Sale Id 240 for retail product','2023-01-01 09:44:50','',''),('1','308',497,'','20','2',1500.00,0.00,'Retail Sale Id 241 for 1.95 KG of Cooking Gas @ N770.00','2023-01-01 09:46:08','',''),('1','308',498,'','6.1','3',0.00,1500.00,'Retail Sale Id 241 for retail product','2023-01-01 09:46:08','',''),('1','308',499,'','20','2',9620.00,0.00,'Retail Sale Id 242 for 12.49 KG of Cooking Gas @ N770.00','2023-01-01 09:47:16','',''),('1','308',500,'','6.1','3',0.00,9620.00,'Retail Sale Id 242 for retail product','2023-01-01 09:47:16','',''),('1','308',501,'','20','2',5850.00,0.00,'Retail Sale Id 243 for 7.60 KG of Cooking Gas @ N770.00','2023-01-01 09:48:54','',''),('1','308',502,'','6.1','3',0.00,5850.00,'Retail Sale Id 243 for retail product','2023-01-01 09:48:54','',''),('1','308',503,'','20','2',1550.00,0.00,'Retail Sale Id 244 for 2.01 KG of Cooking Gas @ N770.00','2023-01-01 10:05:23','',''),('1','308',504,'','6.1','3',0.00,1550.00,'Retail Sale Id 244 for retail product','2023-01-01 10:05:23','',''),('1','308',505,'','20','2',4855.00,0.00,'Retail Sale Id 245 for 6.31 KG of Cooking Gas @ N770.00','2023-01-01 10:13:51','',''),('1','308',506,'','6.1','3',0.00,4855.00,'Retail Sale Id 245 for retail product','2023-01-01 10:13:51','',''),('1','308',507,'','20','2',0.00,5850.00,'Return of Retail Sale Id 243 for products','2023-01-01 10:15:33','',''),('1','308',508,'','','',5850.00,0.00,'Return of Retail Sale Id 243 for products','2023-01-01 10:15:33','',''),('1','308',509,'','20','2',3100.00,0.00,'Retail Sale Id 246 for 4.03 KG of Cooking Gas @ N770.00','2023-01-01 10:31:54','',''),('1','308',510,'','6.1','3',0.00,3100.00,'Retail Sale Id 246 for retail product','2023-01-01 10:31:54','',''),('1','308',511,'','20','2',1550.00,0.00,'Retail Sale Id 247 for 2.01 KG of Cooking Gas @ N770.00','2023-01-01 11:00:45','',''),('1','308',512,'','6.1','3',0.00,1550.00,'Retail Sale Id 247 for retail product','2023-01-01 11:00:45','',''),('1','308',513,'','20','2',800.00,0.00,'Retail Sale Id 248 for 1.04 KG of Cooking Gas @ N770.00','2023-01-01 11:36:57','',''),('1','308',514,'','6.1','3',0.00,800.00,'Retail Sale Id 248 for retail product','2023-01-01 11:36:57','',''),('1','308',515,'','20','2',35500.00,0.00,'Retail Sale Id 249 for 50.00 KG of Cooking Gas @ N710.00','2023-01-01 12:10:45','',''),('1','308',516,'','6.1','3',0.00,35500.00,'Retail Sale Id 249 for retail product','2023-01-01 12:10:45','',''),('1','308',517,'','20','2',1550.00,0.00,'Retail Sale Id 250 for 2.01 KG of Cooking Gas @ N770.00','2023-01-01 12:17:31','',''),('1','308',518,'','6.1','3',0.00,1550.00,'Retail Sale Id 250 for retail product','2023-01-01 12:17:31','',''),('1','308',519,'','20','2',2000.00,0.00,'Retail Sale Id 251 for 2.60 KG of Cooking Gas @ N770.00','2023-01-01 12:31:09','',''),('1','308',520,'','6.1','3',0.00,2000.00,'Retail Sale Id 251 for retail product','2023-01-01 12:31:09','',''),('1','308',521,'','20','2',4620.00,0.00,'Retail Sale Id 252 for 6.00 KG of Cooking Gas @ N770.00','2023-01-01 13:09:49','',''),('1','308',522,'','6.1','3',0.00,4620.00,'Retail Sale Id 252 for retail product','2023-01-01 13:09:49','',''),('1','308',523,'','20','2',800.00,0.00,'Retail Sale Id 253 for 1.04 KG of Cooking Gas @ N770.00','2023-01-01 13:13:30','',''),('1','308',524,'','6.1','3',0.00,800.00,'Retail Sale Id 253 for retail product','2023-01-01 13:13:30','',''),('1','308',525,'','20','2',1550.00,0.00,'Retail Sale Id 254 for 2.01 KG of Cooking Gas @ N770.00','2023-01-01 13:38:48','',''),('1','308',526,'','6.1','3',0.00,1550.00,'Retail Sale Id 254 for retail product','2023-01-01 13:38:48','',''),('1','308',527,'','20','2',1550.00,0.00,'Retail Sale Id 255 for 2.01 KG of Cooking Gas @ N770.00','2023-01-01 13:45:36','',''),('1','308',528,'','6.1','3',0.00,1550.00,'Retail Sale Id 255 for retail product','2023-01-01 13:45:36','',''),('1','308',529,'','20','2',1600.00,0.00,'Retail Sale Id 256 for 2.08 KG of Cooking Gas @ N770.00','2023-01-01 13:47:05','',''),('1','308',530,'','6.1','3',0.00,1600.00,'Retail Sale Id 256 for retail product','2023-01-01 13:47:05','',''),('1','308',531,'','20','2',2350.00,0.00,'Retail Sale Id 257 for 3.05 KG of Cooking Gas @ N770.00','2023-01-01 15:46:41','',''),('1','308',532,'','6.1','3',0.00,2350.00,'Retail Sale Id 257 for retail product','2023-01-01 15:46:41','',''),('1','308',533,'','20','2',1900.00,0.00,'Retail Sale Id 258 for 2.47 KG of Cooking Gas @ N770.00','2023-01-01 15:51:19','',''),('1','308',534,'','6.1','3',0.00,1900.00,'Retail Sale Id 258 for retail product','2023-01-01 15:51:19','',''),('1','308',535,'','20','2',1000.00,0.00,'Retail Sale Id 259 for 1.30 KG of Cooking Gas @ N770.00','2023-01-01 15:53:45','',''),('1','308',536,'','6.1','3',0.00,1000.00,'Retail Sale Id 259 for retail product','2023-01-01 15:53:45','',''),('1','308',537,'','20','2',4620.00,0.00,'Retail Sale Id 260 for 6.00 KG of Cooking Gas @ N770.00','2023-01-01 16:05:54','',''),('1','308',538,'','6.1','3',0.00,4620.00,'Retail Sale Id 260 for retail product','2023-01-01 16:05:54','',''),('1','308',539,'','20','2',1600.00,0.00,'Retail Sale Id 261 for 2.08 KG of Cooking Gas @ N770.00','2023-01-01 16:07:53','',''),('1','308',540,'','6.1','3',0.00,1600.00,'Retail Sale Id 261 for retail product','2023-01-01 16:07:53','',''),('1','308',541,'','20','2',800.00,0.00,'Retail Sale Id 264 for 1.04 KG of Cooking Gas @ N770.00','2023-01-01 16:45:23','',''),('1','308',542,'','6.1','3',0.00,800.00,'Retail Sale Id 264 for retail product','2023-01-01 16:45:23','',''),('1','308',543,'','20','2',2350.00,0.00,'Retail Sale Id 265 for 3.05 KG of Cooking Gas @ N770.00','2023-01-01 17:06:46','',''),('1','308',544,'','6.1','3',0.00,2350.00,'Retail Sale Id 265 for retail product','2023-01-01 17:06:46','',''),('1','308',545,'','20','2',4620.00,0.00,'Retail Sale Id 266 for 6.00 KG of Cooking Gas @ N770.00','2023-01-01 17:16:39','',''),('1','308',546,'','6.1','3',0.00,4620.00,'Retail Sale Id 266 for retail product','2023-01-01 17:16:39','',''),('1','308',547,'','20','2',0.00,4620.00,'Return of Retail Sale Id 260 for products','2023-01-01 17:36:31','',''),('1','308',548,'','','',4620.00,0.00,'Return of Retail Sale Id 260 for products','2023-01-01 17:36:31','',''),('1','308',549,'','20','2',5400.00,0.00,'Retail Sale Id 267 for 7.01 KG of Cooking Gas @ N770.00','2023-01-01 17:56:45','',''),('1','308',550,'','6.1','3',0.00,5400.00,'Retail Sale Id 267 for retail product','2023-01-01 17:56:45','',''),('1','308',551,'','20','2',2350.00,0.00,'Retail Sale Id 268 for 3.05 KG of Cooking Gas @ N770.00','2023-01-01 18:10:20','',''),('1','308',552,'','6.1','3',0.00,2350.00,'Retail Sale Id 268 for retail product','2023-01-01 18:10:20','',''),('1','308',553,'','20','2',0.00,0.00,'Sales from shift 11 on 2023-01-01 19:46:17 ','2023-01-01 19:46:17','',''),('1','308',554,'','6.1','3',0.00,0.00,'Sales from shift 11 on 2023-01-01 19:46:17 ','2023-01-01 19:46:17','',''),('1','308',555,'','20','2',800.00,0.00,'Retail Sale Id 269 for 1.04 KG of Cooking Gas @ N770.00','2023-01-02 09:33:50','',''),('1','308',556,'','6.1','3',0.00,800.00,'Retail Sale Id 269 for retail product','2023-01-02 09:33:50','',''),('1','308',557,'','20','2',1550.00,0.00,'Retail Sale Id 272 for 2.01 KG of Cooking Gas @ N770.00','2023-01-02 09:45:21','',''),('1','308',558,'','6.1','3',0.00,1550.00,'Retail Sale Id 272 for retail product','2023-01-02 09:45:21','',''),('1','308',559,'','20','2',7700.00,0.00,'Retail Sale Id 273 for 10.00 KG of Cooking Gas @ N770.00','2023-01-02 09:49:52','',''),('1','308',560,'','6.1','3',0.00,7700.00,'Retail Sale Id 273 for retail product','2023-01-02 09:49:52','',''),('1','308',561,'','20','2',4650.00,0.00,'Retail Sale Id 284 for 6.04 KG of Cooking Gas @ N770.00','2023-01-02 10:09:56','',''),('1','308',562,'','6.1','3',0.00,4650.00,'Retail Sale Id 284 for retail product','2023-01-02 10:09:56','',''),('1','308',563,'','20','2',11500.00,0.00,'Retail Sale Id 285 for 14.94 KG of Cooking Gas @ N770.00','2023-01-02 10:13:02','',''),('1','308',564,'','6.1','3',0.00,11500.00,'Retail Sale Id 285 for retail product','2023-01-02 10:13:02','',''),('1','308',565,'','20','2',4650.00,0.00,'Retail Sale Id 286 for 6.04 KG of Cooking Gas @ N770.00','2023-01-02 10:30:05','',''),('1','308',566,'','6.1','3',0.00,4650.00,'Retail Sale Id 286 for retail product','2023-01-02 10:30:05','',''),('1','308',567,'','20','2',1550.00,0.00,'Retail Sale Id 287 for 2.01 KG of Cooking Gas @ N770.00','2023-01-02 10:41:48','',''),('1','308',568,'','6.1','3',0.00,1550.00,'Retail Sale Id 287 for retail product','2023-01-02 10:41:48','',''),('1','308',569,'','20','2',3100.00,0.00,'Retail Sale Id 294 for 4.03 KG of Cooking Gas @ N770.00','2023-01-02 10:58:41','',''),('1','308',570,'','6.1','3',0.00,3100.00,'Retail Sale Id 294 for retail product','2023-01-02 10:58:41','',''),('1','308',571,'','20','2',4620.00,0.00,'Retail Sale Id 298 for 6.00 KG of Cooking Gas @ N770.00','2023-01-02 11:14:32','',''),('1','308',572,'','6.1','3',0.00,4620.00,'Retail Sale Id 298 for retail product','2023-01-02 11:14:32','',''),('1','308',573,'','20','2',770.00,0.00,'Retail Sale Id 299 for 1.00 KG of Cooking Gas @ N770.00','2023-01-02 11:24:20','',''),('1','308',574,'','6.1','3',0.00,770.00,'Retail Sale Id 299 for retail product','2023-01-02 11:24:20','',''),('1','308',575,'','20','2',1550.00,0.00,'Retail Sale Id 300 for 2.01 KG of Cooking Gas @ N770.00','2023-01-02 11:50:03','',''),('1','308',576,'','6.1','3',0.00,1550.00,'Retail Sale Id 300 for retail product','2023-01-02 11:50:03','',''),('1','308',577,'','20','2',35500.00,0.00,'Retail Sale Id 301 for 50.00 KG of Cooking Gas @ N710.00','2023-01-02 12:02:25','',''),('1','308',578,'','6.1','3',0.00,35500.00,'Retail Sale Id 301 for retail product','2023-01-02 12:02:25','',''),('1','308',579,'','20','2',2350.00,0.00,'Retail Sale Id 302 for 3.05 KG of Cooking Gas @ N770.00','2023-01-02 12:08:49','',''),('1','308',580,'','6.1','3',0.00,2350.00,'Retail Sale Id 302 for retail product','2023-01-02 12:08:49','',''),('1','308',581,'','20','2',800.00,0.00,'Retail Sale Id 303 for 1.04 KG of Cooking Gas @ N770.00','2023-01-02 12:12:47','',''),('1','308',582,'','6.1','3',0.00,800.00,'Retail Sale Id 303 for retail product','2023-01-02 12:12:47','',''),('1','308',583,'','20','2',1540.00,0.00,'Retail Sale Id 304 for 2.00 KG of Cooking Gas @ N770.00','2023-01-02 12:14:48','',''),('1','308',584,'','6.1','3',0.00,1540.00,'Retail Sale Id 304 for retail product','2023-01-02 12:14:48','',''),('1','308',585,'','20','2',800.00,0.00,'Retail Sale Id 305 for 1.04 KG of Cooking Gas @ N770.00','2023-01-02 12:28:00','',''),('1','308',586,'','6.1','3',0.00,800.00,'Retail Sale Id 305 for retail product','2023-01-02 12:28:00','',''),('1','308',587,'','20','2',4620.00,0.00,'Retail Sale Id 306 for 6.00 KG of Cooking Gas @ N770.00','2023-01-02 13:57:29','',''),('1','308',588,'','6.1','3',0.00,4620.00,'Retail Sale Id 306 for retail product','2023-01-02 13:57:29','',''),('1','308',589,'','20','2',1540.00,0.00,'Retail Sale Id 307 for 2.00 KG of Cooking Gas @ N770.00','2023-01-02 13:59:24','',''),('1','308',590,'','6.1','3',0.00,1540.00,'Retail Sale Id 307 for retail product','2023-01-02 13:59:24','',''),('1','308',591,'','20','2',1550.00,0.00,'Retail Sale Id 308 for 2.01 KG of Cooking Gas @ N770.00','2023-01-02 14:00:59','',''),('1','308',592,'','6.1','3',0.00,1550.00,'Retail Sale Id 308 for retail product','2023-01-02 14:00:59','',''),('1','308',593,'','20','2',3850.00,0.00,'Retail Sale Id 309 for 5.00 KG of Cooking Gas @ N770.00','2023-01-02 15:28:59','',''),('1','308',594,'','6.1','3',0.00,3850.00,'Retail Sale Id 309 for retail product','2023-01-02 15:28:59','',''),('1','308',595,'','20','2',2310.00,0.00,'Retail Sale Id 310 for 3.00 KG of Cooking Gas @ N770.00','2023-01-02 15:54:16','',''),('1','308',596,'','6.1','3',0.00,2310.00,'Retail Sale Id 310 for retail product','2023-01-02 15:54:16','',''),('1','308',597,'','20','2',2310.00,0.00,'Retail Sale Id 311 for 3.00 KG of Cooking Gas @ N770.00','2023-01-02 16:09:28','',''),('1','308',598,'','6.1','3',0.00,2310.00,'Retail Sale Id 311 for retail product','2023-01-02 16:09:28','',''),('1','308',599,'','20','2',800.00,0.00,'Retail Sale Id 312 for 1.04 KG of Cooking Gas @ N770.00','2023-01-02 16:19:34','',''),('1','308',600,'','6.1','3',0.00,800.00,'Retail Sale Id 312 for retail product','2023-01-02 16:19:34','',''),('1','308',601,'','20','2',4620.00,0.00,'Retail Sale Id 313 for 6.00 KG of Cooking Gas @ N770.00','2023-01-02 16:22:57','',''),('1','308',602,'','6.1','3',0.00,4620.00,'Retail Sale Id 313 for retail product','2023-01-02 16:22:57','',''),('1','308',603,'','20','2',1550.00,0.00,'Retail Sale Id 314 for 2.01 KG of Cooking Gas @ N770.00','2023-01-02 16:46:07','',''),('1','308',604,'','6.1','3',0.00,1550.00,'Retail Sale Id 314 for retail product','2023-01-02 16:46:07','',''),('1','308',605,'','20','2',4620.00,0.00,'Retail Sale Id 315 for 6.00 KG of Cooking Gas @ N770.00','2023-01-02 17:19:06','',''),('1','308',606,'','6.1','3',0.00,4620.00,'Retail Sale Id 315 for retail product','2023-01-02 17:19:06','',''),('1','308',607,'','20','2',1550.00,0.00,'Retail Sale Id 316 for 2.01 KG of Cooking Gas @ N770.00','2023-01-02 17:22:04','',''),('1','308',608,'','6.1','3',0.00,1550.00,'Retail Sale Id 316 for retail product','2023-01-02 17:22:04','',''),('1','308',609,'','20','2',3080.00,0.00,'Retail Sale Id 317 for 4.00 KG of Cooking Gas @ N770.00','2023-01-02 17:28:32','',''),('1','308',610,'','6.1','3',0.00,3080.00,'Retail Sale Id 317 for retail product','2023-01-02 17:28:32','',''),('1','308',611,'','20','2',3850.00,0.00,'Retail Sale Id 318 for 5.00 KG of Cooking Gas @ N770.00','2023-01-02 17:31:37','',''),('1','308',612,'','6.1','3',0.00,3850.00,'Retail Sale Id 318 for retail product','2023-01-02 17:31:37','',''),('1','308',613,'','20','2',4620.00,0.00,'Retail Sale Id 319 for 6.00 KG of Cooking Gas @ N770.00','2023-01-02 17:37:01','',''),('1','308',614,'','6.1','3',0.00,4620.00,'Retail Sale Id 319 for retail product','2023-01-02 17:37:01','',''),('1','308',615,'','6.1','3',0.00,4620.00,'Retail Sale Id 319 for retail product','2023-01-02 17:37:01','',''),('1','308',616,'','6.1','3',0.00,4620.00,'Retail Sale Id 319 for retail product','2023-01-02 17:37:01','',''),('1','308',617,'','20','2',1000.00,0.00,'Retail Sale Id 323 for 1.30 KG of Cooking Gas @ N770.00','2023-01-02 17:42:41','',''),('1','308',618,'','6.1','3',0.00,1000.00,'Retail Sale Id 323 for retail product','2023-01-02 17:42:41','',''),('1','308',619,'','20','2',3080.00,0.00,'Retail Sale Id 324 for 4.00 KG of Cooking Gas @ N770.00','2023-01-02 18:20:45','',''),('1','308',620,'','6.1','3',0.00,3080.00,'Retail Sale Id 324 for retail product','2023-01-02 18:20:45','',''),('1','308',621,'','20','2',0.00,0.00,'Sales from shift 12 on 2023-01-02 19:29:04 ','2023-01-02 19:29:04','',''),('1','308',622,'','6.1','3',0.00,0.00,'Sales from shift 12 on 2023-01-02 19:29:04 ','2023-01-02 19:29:04','',''),('1','308',623,'','20','2',3080.00,0.00,'Retail Sale Id 325 for 4.00 KG of Cooking Gas @ N770.00','2023-01-03 08:17:49','',''),('1','308',624,'','6.1','3',0.00,3080.00,'Retail Sale Id 325 for retail product','2023-01-03 08:17:49','',''),('1','308',625,'','20','2',8500.00,0.00,'Retail Sale Id 326 for 11.04 KG of Cooking Gas @ N770.00','2023-01-03 08:32:48','',''),('1','308',626,'','6.1','3',0.00,8500.00,'Retail Sale Id 326 for retail product','2023-01-03 08:32:48','',''),('1','308',627,'','20','2',3850.00,0.00,'Retail Sale Id 327 for 5.00 KG of Cooking Gas @ N770.00','2023-01-03 08:57:01','',''),('1','308',628,'','6.1','3',0.00,3850.00,'Retail Sale Id 327 for retail product','2023-01-03 08:57:01','',''),('1','308',629,'','20','2',8900.00,0.00,'Retail Sale Id 328 for 11.56 KG of Cooking Gas @ N770.00','2023-01-03 09:00:37','',''),('1','308',630,'','6.1','3',0.00,8900.00,'Retail Sale Id 328 for retail product','2023-01-03 09:00:37','',''),('1','308',631,'','20','2',3000.00,0.00,'Retail Sale Id 329 for 3.90 KG of Cooking Gas @ N770.00','2023-01-03 09:17:14','',''),('1','308',632,'','6.1','3',0.00,3000.00,'Retail Sale Id 329 for retail product','2023-01-03 09:17:14','',''),('1','308',633,'','20','2',1550.00,0.00,'Retail Sale Id 330 for 2.01 KG of Cooking Gas @ N770.00','2023-01-03 09:55:57','',''),('1','308',634,'','6.1','3',0.00,1550.00,'Retail Sale Id 330 for retail product','2023-01-03 09:55:57','',''),('1','308',635,'','20','2',3100.00,0.00,'Retail Sale Id 331 for 4.03 KG of Cooking Gas @ N770.00','2023-01-03 09:57:23','',''),('1','308',636,'','6.1','3',0.00,3100.00,'Retail Sale Id 331 for retail product','2023-01-03 09:57:23','',''),('1','308',637,'','20','2',1550.00,0.00,'Retail Sale Id 332 for 2.01 KG of Cooking Gas @ N770.00','2023-01-03 10:04:05','',''),('1','308',638,'','6.1','3',0.00,1550.00,'Retail Sale Id 332 for retail product','2023-01-03 10:04:05','',''),('1','308',639,'','20','2',1550.00,0.00,'Retail Sale Id 333 for 2.01 KG of Cooking Gas @ N770.00','2023-01-03 10:23:03','',''),('1','308',640,'','6.1','3',0.00,1550.00,'Retail Sale Id 333 for retail product','2023-01-03 10:23:03','',''),('1','308',641,'','20','2',1550.00,0.00,'Retail Sale Id 334 for 2.01 KG of Cooking Gas @ N770.00','2023-01-03 10:43:19','',''),('1','308',642,'','6.1','3',0.00,1550.00,'Retail Sale Id 334 for retail product','2023-01-03 10:43:19','',''),('1','308',643,'','20','2',6200.00,0.00,'Retail Sale Id 335 for 8.05 KG of Cooking Gas @ N770.00','2023-01-03 10:49:25','',''),('1','308',644,'','6.1','3',0.00,6200.00,'Retail Sale Id 335 for retail product','2023-01-03 10:49:25','',''),('1','308',645,'','20','2',3100.00,0.00,'Retail Sale Id 337 for 4.03 KG of Cooking Gas @ N770.00','2023-01-03 10:50:21','',''),('1','308',646,'','6.1','3',0.00,3100.00,'Retail Sale Id 337 for retail product','2023-01-03 10:50:21','',''),('1','308',647,'','20','2',4650.00,0.00,'Retail Sale Id 338 for 6.04 KG of Cooking Gas @ N770.00','2023-01-03 11:08:26','',''),('1','308',648,'','6.1','3',0.00,4650.00,'Retail Sale Id 338 for retail product','2023-01-03 11:08:26','',''),('1','308',649,'','20','2',1540.00,0.00,'Retail Sale Id 339 for 2.00 KG of Cooking Gas @ N770.00','2023-01-03 11:13:22','',''),('1','308',650,'','6.1','3',0.00,1540.00,'Retail Sale Id 339 for retail product','2023-01-03 11:13:22','',''),('1','308',651,'','20','2',4620.00,0.00,'Retail Sale Id 340 for 6.00 KG of Cooking Gas @ N770.00','2023-01-03 11:53:34','',''),('1','308',652,'','6.1','3',0.00,4620.00,'Retail Sale Id 340 for retail product','2023-01-03 11:53:34','',''),('1','308',653,'','20','2',3850.00,0.00,'Retail Sale Id 341 for 5.00 KG of Cooking Gas @ N770.00','2023-01-03 12:25:25','',''),('1','308',654,'','6.1','3',0.00,3850.00,'Retail Sale Id 341 for retail product','2023-01-03 12:25:25','',''),('1','308',655,'','20','2',800.00,0.00,'Retail Sale Id 342 for 1.04 KG of Cooking Gas @ N770.00','2023-01-03 13:14:42','',''),('1','308',656,'','6.1','3',0.00,800.00,'Retail Sale Id 342 for retail product','2023-01-03 13:14:42','',''),('1','308',657,'','20','2',142000.00,0.00,'Retail Sale Id 344 for 200.00 KG of Cooking Gas @ N710.00','2023-01-03 14:47:05','',''),('1','308',658,'','6.1','3',0.00,142000.00,'Retail Sale Id 344 for retail product','2023-01-03 14:47:05','',''),('1','308',659,'','20','2',2350.00,0.00,'Retail Sale Id 345 for 3.05 KG of Cooking Gas @ N770.00','2023-01-03 14:52:35','',''),('1','308',660,'','6.1','3',0.00,2350.00,'Retail Sale Id 345 for retail product','2023-01-03 14:52:35','',''),('1','308',661,'','20','2',1550.00,0.00,'Retail Sale Id 346 for 2.01 KG of Cooking Gas @ N770.00','2023-01-03 15:02:53','',''),('1','308',662,'','6.1','3',0.00,1550.00,'Retail Sale Id 346 for retail product','2023-01-03 15:02:53','',''),('1','308',663,'','20','2',800.00,0.00,'Retail Sale Id 347 for 1.04 KG of Cooking Gas @ N770.00','2023-01-03 15:09:31','',''),('1','308',664,'','6.1','3',0.00,800.00,'Retail Sale Id 347 for retail product','2023-01-03 15:09:31','',''),('1','308',665,'','20','2',2310.00,0.00,'Retail Sale Id 349 for 3.00 KG of Cooking Gas @ N770.00','2023-01-03 15:16:22','',''),('1','308',666,'','6.1','3',0.00,2310.00,'Retail Sale Id 349 for retail product','2023-01-03 15:16:22','',''),('1','308',667,'','20','2',3100.00,0.00,'Retail Sale Id 350 for 4.03 KG of Cooking Gas @ N770.00','2023-01-03 16:23:22','',''),('1','308',668,'','6.1','3',0.00,3100.00,'Retail Sale Id 350 for retail product','2023-01-03 16:23:22','',''),('1','308',669,'','20','2',6160.00,0.00,'Retail Sale Id 351 for 8.00 KG of Cooking Gas @ N770.00','2023-01-03 16:32:44','',''),('1','308',670,'','6.1','3',0.00,6160.00,'Retail Sale Id 351 for retail product','2023-01-03 16:32:44','',''),('1','308',671,'','20','2',4620.00,0.00,'Retail Sale Id 352 for 6.00 KG of Cooking Gas @ N770.00','2023-01-03 16:48:24','',''),('1','308',672,'','6.1','3',0.00,4620.00,'Retail Sale Id 352 for retail product','2023-01-03 16:48:24','',''),('1','308',673,'','20','2',35500.00,0.00,'Retail Sale Id 353 for 50.00 KG of Cooking Gas @ N710.00','2023-01-03 17:20:40','',''),('1','308',674,'','6.1','3',0.00,35500.00,'Retail Sale Id 353 for retail product','2023-01-03 17:20:40','',''),('1','308',675,'','20','2',1500.00,0.00,'Retail Sale Id 354 for 1.95 KG of Cooking Gas @ N770.00','2023-01-03 17:25:50','',''),('1','308',676,'','6.1','3',0.00,1500.00,'Retail Sale Id 354 for retail product','2023-01-03 17:25:50','',''),('1','308',677,'','20','2',2300.00,0.00,'Retail Sale Id 355 for 2.99 KG of Cooking Gas @ N770.00','2023-01-03 17:32:43','',''),('1','308',678,'','6.1','3',0.00,2300.00,'Retail Sale Id 355 for retail product','2023-01-03 17:32:43','',''),('1','308',679,'','20','2',2300.00,0.00,'Retail Sale Id 356 for 2.99 KG of Cooking Gas @ N770.00','2023-01-03 18:08:25','',''),('1','308',680,'','6.1','3',0.00,2300.00,'Retail Sale Id 356 for retail product','2023-01-03 18:08:25','',''),('1','308',681,'','20','2',38.50,0.00,'Retail Sale Id 357 for 0.05 KG of Cooking Gas @ N770.00','2023-01-03 18:31:57','',''),('1','308',682,'','6.1','3',0.00,38.50,'Retail Sale Id 357 for retail product','2023-01-03 18:31:57','',''),('1','308',683,'','20','2',0.00,0.00,'Sales from shift 13 on 2023-01-03 19:14:41 ','2023-01-03 19:14:41','',''),('1','308',684,'','6.1','3',0.00,0.00,'Sales from shift 13 on 2023-01-03 19:14:41 ','2023-01-03 19:14:41','',''),('1','308',685,'','20','2',6950.00,0.00,'Retail Sale Id 358 for 9.03 KG of Cooking Gas @ N770.00','2023-01-04 09:32:39','',''),('1','308',686,'','6.1','3',0.00,6950.00,'Retail Sale Id 358 for retail product','2023-01-04 09:32:39','',''),('1','308',687,'','20','2',8470.00,0.00,'Retail Sale Id 359 for 11.00 KG of Cooking Gas @ N770.00','2023-01-04 09:37:57','',''),('1','308',688,'','6.1','3',0.00,8470.00,'Retail Sale Id 359 for retail product','2023-01-04 09:37:57','',''),('1','308',689,'','20','2',1540.00,0.00,'Retail Sale Id 361 for 2.00 KG of Cooking Gas @ N770.00','2023-01-04 09:58:57','',''),('1','308',690,'','6.1','3',0.00,1540.00,'Retail Sale Id 361 for retail product','2023-01-04 09:58:57','',''),('1','308',691,'','20','2',4620.00,0.00,'Retail Sale Id 362 for 6.00 KG of Cooking Gas @ N770.00','2023-01-04 10:15:18','',''),('1','308',692,'','6.1','3',0.00,4620.00,'Retail Sale Id 362 for retail product','2023-01-04 10:15:18','',''),('1','308',693,'','20','2',2310.00,0.00,'Retail Sale Id 363 for 3.00 KG of Cooking Gas @ N770.00','2023-01-04 11:08:14','',''),('1','308',694,'','6.1','3',0.00,2310.00,'Retail Sale Id 363 for retail product','2023-01-04 11:08:14','',''),('1','308',695,'','20','2',3080.00,0.00,'Retail Sale Id 364 for 4.00 KG of Cooking Gas @ N770.00','2023-01-04 11:12:05','',''),('1','308',696,'','6.1','3',0.00,3080.00,'Retail Sale Id 364 for retail product','2023-01-04 11:12:05','',''),('1','308',697,'','20','2',1540.00,0.00,'Retail Sale Id 365 for 2.00 KG of Cooking Gas @ N770.00','2023-01-04 11:19:56','',''),('1','308',698,'','6.1','3',0.00,1540.00,'Retail Sale Id 365 for retail product','2023-01-04 11:19:56','',''),('1','308',699,'','20','2',1000.00,0.00,'Retail Sale Id 366 for 1.30 KG of Cooking Gas @ N770.00','2023-01-04 13:03:53','',''),('1','308',700,'','6.1','3',0.00,1000.00,'Retail Sale Id 366 for retail product','2023-01-04 13:03:53','',''),('1','308',701,'','20','2',1500.00,0.00,'Retail Sale Id 367 for 1.95 KG of Cooking Gas @ N770.00','2023-01-04 13:17:49','',''),('1','308',702,'','6.1','3',0.00,1500.00,'Retail Sale Id 367 for retail product','2023-01-04 13:17:49','',''),('1','308',703,'','20','2',4620.00,0.00,'Retail Sale Id 370 for 6.00 KG of Cooking Gas @ N770.00','2023-01-04 13:53:53','',''),('1','308',704,'','6.1','3',0.00,4620.00,'Retail Sale Id 370 for retail product','2023-01-04 13:53:53','',''),('1','308',705,'','20','2',1540.00,0.00,'Retail Sale Id 372 for 2.00 KG of Cooking Gas @ N770.00','2023-01-04 14:16:26','',''),('1','308',706,'','6.1','3',0.00,1540.00,'Retail Sale Id 372 for retail product','2023-01-04 14:16:26','',''),('1','308',707,'','20','2',2000.00,0.00,'Retail Sale Id 374 for 2.60 KG of Cooking Gas @ N770.00','2023-01-04 14:49:33','',''),('1','308',708,'','6.1','3',0.00,2000.00,'Retail Sale Id 374 for retail product','2023-01-04 14:49:33','',''),('1','308',709,'','20','2',1540.00,0.00,'Retail Sale Id 375 for 2.00 KG of Cooking Gas @ N770.00','2023-01-04 15:23:23','',''),('1','308',710,'','6.1','3',0.00,1540.00,'Retail Sale Id 375 for retail product','2023-01-04 15:23:23','',''),('1','308',711,'','20','2',800.00,0.00,'Retail Sale Id 376 for 1.04 KG of Cooking Gas @ N770.00','2023-01-04 15:35:18','',''),('1','308',712,'','6.1','3',0.00,800.00,'Retail Sale Id 376 for retail product','2023-01-04 15:35:18','',''),('1','308',713,'','20','2',9625.00,0.00,'Retail Sale Id 378 for 12.50 KG of Cooking Gas @ N770.00','2023-01-04 15:46:53','',''),('1','308',714,'','6.1','3',0.00,9625.00,'Retail Sale Id 378 for retail product','2023-01-04 15:46:53','',''),('1','308',715,'','20','2',2310.00,0.00,'Retail Sale Id 379 for 3.00 KG of Cooking Gas @ N770.00','2023-01-04 16:05:05','',''),('1','308',716,'','6.1','3',0.00,2310.00,'Retail Sale Id 379 for retail product','2023-01-04 16:05:05','',''),('1','308',717,'','20','2',1540.00,0.00,'Retail Sale Id 382 for 2.00 KG of Cooking Gas @ N770.00','2023-01-04 16:57:00','',''),('1','308',718,'','6.1','3',0.00,1540.00,'Retail Sale Id 382 for retail product','2023-01-04 16:57:00','',''),('1','308',719,'','20','2',2310.00,0.00,'Retail Sale Id 383 for 3.00 KG of Cooking Gas @ N770.00','2023-01-04 17:14:37','',''),('1','308',720,'','6.1','3',0.00,2310.00,'Retail Sale Id 383 for retail product','2023-01-04 17:14:38','',''),('1','308',721,'','20','2',9625.00,0.00,'Retail Sale Id 385 for 12.50 KG of Cooking Gas @ N770.00','2023-01-04 17:17:24','',''),('1','308',722,'','6.1','3',0.00,9625.00,'Retail Sale Id 385 for retail product','2023-01-04 17:17:24','',''),('1','308',723,'','20','2',3080.00,0.00,'Retail Sale Id 386 for 4.00 KG of Cooking Gas @ N770.00','2023-01-04 17:33:59','',''),('1','308',724,'','6.1','3',0.00,3080.00,'Retail Sale Id 386 for retail product','2023-01-04 17:33:59','',''),('1','308',725,'','6.1','3',0.00,3080.00,'Retail Sale Id 386 for retail product','2023-01-04 17:33:59','',''),('1','308',726,'','20','2',1540.00,0.00,'Retail Sale Id 387 for 2.00 KG of Cooking Gas @ N770.00','2023-01-04 17:40:12','',''),('1','308',727,'','6.1','3',0.00,1540.00,'Retail Sale Id 387 for retail product','2023-01-04 17:40:12','',''),('1','308',728,'','20','2',46.00,0.00,'Retail Sale Id 388 for 0.06 KG of Cooking Gas @ N770.00','2023-01-04 19:05:28','',''),('1','308',729,'','6.1','3',0.00,46.00,'Retail Sale Id 388 for retail product','2023-01-04 19:05:28','',''),('1','308',730,'','20','2',0.00,0.00,'Sales from shift 14 on 2023-01-04 19:37:46 ','2023-01-04 19:37:46','',''),('1','308',731,'','6.1','3',0.00,0.00,'Sales from shift 14 on 2023-01-04 19:37:46 ','2023-01-04 19:37:46','',''),('1','308',732,'','20','2',8500.00,0.00,'Retail Sale Id 389 for 11.04 KG of Cooking Gas @ N770.00','2023-01-05 07:59:38','',''),('1','308',733,'','6.1','3',0.00,8500.00,'Retail Sale Id 389 for retail product','2023-01-05 07:59:38','',''),('1','308',734,'','20','2',3850.00,0.00,'Retail Sale Id 390 for 5.00 KG of Cooking Gas @ N770.00','2023-01-05 08:08:21','',''),('1','308',735,'','6.1','3',0.00,3850.00,'Retail Sale Id 390 for retail product','2023-01-05 08:08:21','',''),('1','308',736,'','20','2',2310.00,0.00,'Retail Sale Id 391 for 3.00 KG of Cooking Gas @ N770.00','2023-01-05 08:15:11','',''),('1','308',737,'','6.1','3',0.00,2310.00,'Retail Sale Id 391 for retail product','2023-01-05 08:15:11','',''),('1','308',738,'','20','2',800.00,0.00,'Retail Sale Id 392 for 1.04 KG of Cooking Gas @ N770.00','2023-01-05 08:35:55','',''),('1','308',739,'','6.1','3',0.00,800.00,'Retail Sale Id 392 for retail product','2023-01-05 08:35:55','',''),('1','308',740,'','20','2',4650.00,0.00,'Retail Sale Id 393 for 6.04 KG of Cooking Gas @ N770.00','2023-01-05 08:47:33','',''),('1','308',741,'','6.1','3',0.00,4650.00,'Retail Sale Id 393 for retail product','2023-01-05 08:47:33','',''),('1','308',742,'','20','2',4620.00,0.00,'Retail Sale Id 394 for 6.00 KG of Cooking Gas @ N770.00','2023-01-05 09:13:33','',''),('1','308',743,'','6.1','3',0.00,4620.00,'Retail Sale Id 394 for retail product','2023-01-05 09:13:33','',''),('1','308',744,'','20','2',3080.00,0.00,'Retail Sale Id 395 for 4.00 KG of Cooking Gas @ N770.00','2023-01-05 09:19:06','',''),('1','308',745,'','6.1','3',0.00,3080.00,'Retail Sale Id 395 for retail product','2023-01-05 09:19:06','',''),('1','308',746,'','20','2',2310.00,0.00,'Retail Sale Id 396 for 3.00 KG of Cooking Gas @ N770.00','2023-01-05 09:23:40','',''),('1','308',747,'','6.1','3',0.00,2310.00,'Retail Sale Id 396 for retail product','2023-01-05 09:23:40','',''),('1','308',748,'','20','2',4620.00,0.00,'Retail Sale Id 397 for 6.00 KG of Cooking Gas @ N770.00','2023-01-05 09:26:03','',''),('1','308',749,'','6.1','3',0.00,4620.00,'Retail Sale Id 397 for retail product','2023-01-05 09:26:03','',''),('1','308',750,'','20','2',2320.00,0.00,'Retail Sale Id 398 for 3.01 KG of Cooking Gas @ N770.00','2023-01-05 09:34:02','',''),('1','308',751,'','6.1','3',0.00,2320.00,'Retail Sale Id 398 for retail product','2023-01-05 09:34:02','',''),('1','308',752,'','20','2',1550.00,0.00,'Retail Sale Id 399 for 2.01 KG of Cooking Gas @ N770.00','2023-01-05 09:43:55','',''),('1','308',753,'','6.1','3',0.00,1550.00,'Retail Sale Id 399 for retail product','2023-01-05 09:43:55','',''),('1','308',754,'','20','2',1550.00,0.00,'Retail Sale Id 400 for 2.01 KG of Cooking Gas @ N770.00','2023-01-05 09:57:50','',''),('1','308',755,'','6.1','3',0.00,1550.00,'Retail Sale Id 400 for retail product','2023-01-05 09:57:50','',''),('1','308',756,'','20','2',800.00,0.00,'Retail Sale Id 401 for 1.04 KG of Cooking Gas @ N770.00','2023-01-05 10:04:09','',''),('1','308',757,'','6.1','3',0.00,800.00,'Retail Sale Id 401 for retail product','2023-01-05 10:04:09','',''),('1','308',758,'','20','2',800.00,0.00,'Retail Sale Id 402 for 1.04 KG of Cooking Gas @ N770.00','2023-01-05 10:23:22','',''),('1','308',759,'','6.1','3',0.00,800.00,'Retail Sale Id 402 for retail product','2023-01-05 10:23:22','',''),('1','308',760,'','20','2',3100.00,0.00,'Retail Sale Id 403 for 4.03 KG of Cooking Gas @ N770.00','2023-01-05 10:32:06','',''),('1','308',761,'','6.1','3',0.00,3100.00,'Retail Sale Id 403 for retail product','2023-01-05 10:32:06','',''),('1','308',762,'','20','2',800.00,0.00,'Retail Sale Id 404 for 1.04 KG of Cooking Gas @ N770.00','2023-01-05 11:00:12','',''),('1','308',763,'','6.1','3',0.00,800.00,'Retail Sale Id 404 for retail product','2023-01-05 11:00:12','',''),('1','308',764,'','20','2',3850.00,0.00,'Retail Sale Id 405 for 5.00 KG of Cooking Gas @ N770.00','2023-01-05 11:04:12','',''),('1','308',765,'','6.1','3',0.00,3850.00,'Retail Sale Id 405 for retail product','2023-01-05 11:04:12','',''),('1','308',766,'','20','2',2300.00,0.00,'Retail Sale Id 406 for 2.99 KG of Cooking Gas @ N770.00','2023-01-05 11:06:56','',''),('1','308',767,'','6.1','3',0.00,2300.00,'Retail Sale Id 406 for retail product','2023-01-05 11:06:56','',''),('1','308',768,'','20','2',47925.00,0.00,'Retail Sale Id 407 for 67.50 KG of Cooking Gas @ N710.00','2023-01-05 11:46:27','',''),('1','308',769,'','6.1','3',0.00,47925.00,'Retail Sale Id 407 for retail product','2023-01-05 11:46:27','',''),('1','308',770,'','20','2',3110.00,0.00,'Retail Sale Id 408 for 4.04 KG of Cooking Gas @ N770.00','2023-01-05 12:29:42','',''),('1','308',771,'','6.1','3',0.00,3110.00,'Retail Sale Id 408 for retail product','2023-01-05 12:29:42','',''),('1','308',772,'','20','2',770.00,0.00,'Retail Sale Id 409 for 1.00 KG of Cooking Gas @ N770.00','2023-01-05 12:30:42','',''),('1','308',773,'','6.1','3',0.00,770.00,'Retail Sale Id 409 for retail product','2023-01-05 12:30:42','',''),('1','308',774,'','20','2',3850.00,0.00,'Retail Sale Id 410 for 5.00 KG of Cooking Gas @ N770.00','2023-01-05 12:32:32','',''),('1','308',775,'','6.1','3',0.00,3850.00,'Retail Sale Id 410 for retail product','2023-01-05 12:32:32','',''),('1','308',776,'','20','2',1800.00,0.00,'Retail Sale Id 411 for 2.34 KG of Cooking Gas @ N770.00','2023-01-05 12:43:19','',''),('1','308',777,'','6.1','3',0.00,1800.00,'Retail Sale Id 411 for retail product','2023-01-05 12:43:19','',''),('1','308',778,'','20','2',4650.00,0.00,'Retail Sale Id 412 for 6.04 KG of Cooking Gas @ N770.00','2023-01-05 13:15:26','',''),('1','308',779,'','6.1','3',0.00,4650.00,'Retail Sale Id 412 for retail product','2023-01-05 13:15:26','',''),('1','308',780,'','20','2',3080.00,0.00,'Retail Sale Id 413 for 4.00 KG of Cooking Gas @ N770.00','2023-01-05 13:57:09','',''),('1','308',781,'','6.1','3',0.00,3080.00,'Retail Sale Id 413 for retail product','2023-01-05 13:57:09','',''),('1','308',782,'','20','2',3850.00,0.00,'Retail Sale Id 414 for 5.00 KG of Cooking Gas @ N770.00','2023-01-05 14:38:03','',''),('1','308',783,'','6.1','3',0.00,3850.00,'Retail Sale Id 414 for retail product','2023-01-05 14:38:03','',''),('1','308',784,'','20','2',800.00,0.00,'Retail Sale Id 415 for 1.04 KG of Cooking Gas @ N770.00','2023-01-05 16:24:47','',''),('1','308',785,'','6.1','3',0.00,800.00,'Retail Sale Id 415 for retail product','2023-01-05 16:24:47','',''),('1','308',786,'','20','2',1540.00,0.00,'Retail Sale Id 416 for multiple products','2023-01-05 16:39:37','',''),('1','308',787,'','6.1','3',0.00,1540.00,'Retail Sale Id 416 for retail product','2023-01-05 16:39:37','',''),('1','308',788,'','20','2',4620.00,0.00,'Retail Sale Id 417 for 6.00 KG of Cooking Gas @ N770.00','2023-01-05 16:41:04','',''),('1','308',789,'','6.1','3',0.00,4620.00,'Retail Sale Id 417 for retail product','2023-01-05 16:41:04','',''),('1','308',790,'','20','2',770.00,0.00,'Retail Sale Id 418 for 1.00 KG of Cooking Gas @ N770.00','2023-01-05 16:47:57','',''),('1','308',791,'','6.1','3',0.00,770.00,'Retail Sale Id 418 for retail product','2023-01-05 16:47:57','',''),('1','308',792,'','20','2',1500.00,0.00,'Retail Sale Id 419 for 1.95 KG of Cooking Gas @ N770.00','2023-01-05 17:04:52','',''),('1','308',793,'','6.1','3',0.00,1500.00,'Retail Sale Id 419 for retail product','2023-01-05 17:04:52','',''),('1','308',794,'','20','2',3850.00,0.00,'Retail Sale Id 420 for 5.00 KG of Cooking Gas @ N770.00','2023-01-05 17:11:44','',