-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_307
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_307`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_307` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_307`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,4000,'',0,'22','1','307','PURCHASES','','2022-12-22 01:50:39',5,0.00,0.00,'','479','2022-12-22 01:50:39','479',0,0),(2,7000,'',0,'20','1','307','SALES','','2022-12-22 01:50:54',5,0.00,0.00,'','479','2022-12-22 01:50:54','479',0,0),(3,500,'',0,'6.1','1','307','CASH','','2022-12-22 01:51:07',5,0.00,0.00,'','479','2022-12-22 01:51:07','479',0,0),(4,8000,'',0,'24','1','307','SALARIES & WAGES','','2022-12-22 01:51:34',5,0.00,0.00,'','479','2022-12-22 01:51:34','479',0,0),(5,8001,'',0,'24','1','307','PURCHASES','','2022-12-22 01:51:51',5,0.00,0.00,'','479','2022-12-22 01:51:51','479',0,0),(6,2500,'',0,'2','1','307','ZB(LPG)1014471475','','2022-12-22 01:52:10',5,0.00,0.00,'','479','2022-12-22 01:52:10','479',0,0),(7,2501,'',0,'2','1','307','ZNB E-BILL COLLECTION :1014717','','2022-12-22 01:52:26',5,0.00,0.00,'','479','2022-12-22 01:52:26','479',0,0),(8,2502,'',0,'2','1','307','ZNB-:POS 1015965368','','2022-12-22 01:52:36',5,0.00,0.00,'','479','2022-12-22 01:52:36','479',0,0),(9,2503,'',0,'2','1','307','FID POS COLLECTION-5620141491','','2022-12-22 01:52:53',5,0.00,0.00,'','479','2022-12-22 01:52:53','479',0,0),(10,2504,'',0,'2','1','307','FB(IBAL)2023855223','','2022-12-22 01:53:03',5,0.00,0.00,'','479','2022-12-22 01:53:03','479',0,0),(11,2505,'',0,'2','1','307','E-BILLS 1015372548','','2022-12-22 01:53:40',5,0.00,0.00,'','479','2022-12-22 01:53:40','479',0,0),(12,2506,'',0,'2','1','307','E-BILLS  IBAL 1015372548','','2022-12-22 01:53:51',5,0.00,0.00,'','479','2022-12-22 01:53:51','479',0,0),(13,2507,'',0,'2','1','307','UNITY BANK-0024061656','','2022-12-22 01:54:14',5,0.00,0.00,'','479','2022-12-22 01:54:14','479',0,0),(14,2508,'',0,'2','1','307','UBA-0039769388','','2022-12-22 01:54:27',5,0.00,0.00,'','479','2022-12-22 01:54:27','479',0,0),(15,2509,'',0,'2','1','307','UBA YOLA-1021398099','','2022-12-22 01:54:36',5,0.00,0.00,'','479','2022-12-22 01:54:36','479',0,0),(16,2510,'',0,'2','1','307','UBA-1019882661','','2022-12-22 01:54:45',5,0.00,0.00,'','479','2022-12-22 01:54:45','479',0,0),(17,2511,'',0,'2','1','307','DANKANO-EBILLS:ZNB1014717618','','2022-12-22 01:55:00',5,0.00,0.00,'','479','2022-12-22 01:55:00','479',0,0),(18,2512,'',0,'2','1','307','TAJJ BANK CITY GATE:0001875361','','2022-12-22 01:55:16',5,0.00,0.00,'','479','2022-12-22 01:55:16','479',0,0),(19,2513,'',0,'2','1','307','POLARIS BANK KEBBI:4091417377','','2022-12-22 01:55:27',5,0.00,0.00,'','479','2022-12-22 01:55:27','479',0,0),(20,2514,'',0,'2','1','307','ZNB POS COLL ACCT:-1015965368','ZNB POS COLLECTION ACCOUNT','2023-01-19 17:37:10',5,0.00,0.00,'','792','2023-01-19 17:37:10','792',0,0),(21,2515,'',0,'2','1','307','UBA LPG COLL ACCT:-1020811140','UBA LPG COLLECTION ACCOUNT','2023-01-19 17:37:55',5,0.00,0.00,'','792','2023-01-19 17:37:55','792',0,0),(22,2516,'',0,'2','1','307','ZNB AA RANO NIG LTD:-101471761','ZNB AA RANO NIG LTD','2023-01-19 17:38:36',5,0.00,0.00,'','792','2023-01-19 17:38:36','792',0,0),(23,2517,'',0,'2','1','307','FID POS COLL ACCT:-5620141491','FID POS COLLECTION ACCOUNT','2023-01-19 17:39:10',5,0.00,0.00,'','792','2023-01-19 17:39:10','792',0,0),(24,2518,'',0,'2','1','307','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:18:27',5,0.00,0.00,'','792','2023-02-20 14:18:27','792',0,0),(25,2519,'',0,'2','1','307','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:27:34',5,0.00,0.00,'2023-03-15','792','2023-03-17 12:32:15','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','307','alhaji ubale','ubale','08065843215','aal@gmail.com','minna','minna','minna','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-24 16:00:11',5,'1016','2022-12-24 16:00:11','1016'),(2,'','1','307','isa','sulaja','08065843215','aal@gmail.com','minna','niger','kwanba road','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-25 07:36:27',5,'1016','2022-12-25 07:36:27','1016'),(3,'','1','307','GB OIL AND GAS','HARUNA','07013884281','aal@gmail.com','SULEJA','niger','OYUS JUNCTION','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-28 18:19:19',5,'1016','2022-12-28 18:19:19','1016'),(4,'','1','307','HAGU','HAGU','08025923719','aal@gmail.com','SULEJA','NIGER','SULEJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-31 08:00:49',5,'1016','2022-12-31 08:00:49','1016'),(5,'','1','307','UMAR ADAMU',' UMAR ADAMU','07030569748','aal@gmail.com','SULEJA','minna','SULEJA KWAMBA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-31 10:29:21',5,'1016','2022-12-31 10:29:21','1016'),(6,'','1','307','YAU BM','YA\'U','08066553138','aal@gmail.com','SULEJA','NIGER','KWAMBA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-31 12:53:17',5,'1016','2022-12-31 12:53:17','1016'),(7,'','1','307','USATO GAS','USATO ','08060024695','aal@gmail.com','SULEJA','minna','KWAMBA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-31 16:32:42',5,'1016','2022-12-31 16:32:42','1016'),(8,'','1','307','kachallah muhammad','kachallah','07064400444','aal@gmail.com','suleja','niger','kwamba','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-03 08:40:14',5,'1016','2023-01-03 08:40:14','1016'),(9,'','1','307','BCV','BCV','08135359532','aal@gmail.com','SULEJA','NIGER','KWAMBA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-06 10:12:41',5,'1016','2023-01-06 10:12:41','1016'),(10,'','1','307','BIGGI GAS','BIGGI','08060779725','aal@gmail.com','SULEJA','NIGER','KWAMBA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-09 10:32:01',5,'1016','2023-01-09 10:32:01','1016'),(11,'','1','307','J L J','J L J','08060680242','aal@gmail.com','SULEJA','NIGER','SULEJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-20 11:28:35',5,'1016','2023-03-20 08:39:38','1016'),(12,'','1','307','SINPLE MAN','SINPLE MAN','08055177449','aal@gmail.com','SULEJA','NIGER','EMER EDIH STRETT','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-21 13:19:05',5,'1016','2023-01-21 13:19:05','1016'),(13,'','1','307','Happy Gas','Happy','08164102824','aal@gmail.com','SULEJA','NIGER','church road','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-23 15:50:34',5,'1016','2023-01-23 15:50:34','1016'),(14,'','1','307','Operational lost','suleja1 skid','08035687410','sanash2012@gmail.com','suleja','niger','Suleja','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-23 17:06:32',5,'1016','2023-01-23 17:06:32','1016'),(15,'','1','307','A. A. ALLISON','A A ALLISON','08035911552','aal@gmail.com','SULEJA','NIGER','SULEIMAN BARAU TECHNICAL','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-29 10:11:23',5,'1016','2023-02-19 12:44:11','1016'),(16,'','1','307','hajiya halima','hajiya halima','07045242325','aal@gmail.com','SULEJA','minna','PDP QUATERS','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-30 10:44:03',5,'1016','2023-01-30 10:44:03','1016'),(17,'','1','307','RAHMA GAS','RAHMA','08066553138','aal@gmail.com','SULEJA','NIGER','MAIYO\r\n','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-03 11:26:42',5,'1016','2023-02-03 11:26:42','1016'),(18,'','1','307','RONET','RAHINATU','07039780770','aal@gmail.com','SULEJA','NIGER','KWAMBA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-09 15:27:10',5,'1016','2023-02-09 15:27:10','1016'),(19,'','1','307','ADEKUNLE','ADE','08108272227','aal@gmail.com','SULEJA','NIGER','SULEJA KWANBA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-13 14:09:40',5,'1016','2023-02-13 18:05:27','1016'),(20,'','1','307','JUDAN GAS','JUDAN','08036606030','aal@gmail.com','SULEJA','NIGER','RAHAMA PLAZA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-13 17:48:14',5,'1016','2023-02-13 17:48:14','1016'),(21,'','1','307',' SUNNY  GAS','BESIDE FIRST BANK','08134309594','aal@gmail.com','SULEJA','ENUGU','BAKASSI','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-20 10:28:41',5,'1016','2023-02-20 10:28:41','1016'),(22,'','1','307','olu gas','olu gas','08060515260','aal@gmail.comlambata','lambata','osun state','lambata minna road','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 07:29:41',5,'1016','2023-02-21 07:29:41','1016');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','307','1',1,'5','LPG NOZZLE 1',27114.88,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','307','1',2,'5','LPG NOZZLE 2',23717.75,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','307',1,'DAILY SHIFT','2022-12-23','2022-12-23 12:09:39','2022-12-24 12:09:39','1016',0.00,0.00,'1016','2022-12-24 12:42:38','1016','2022-12-24 12:43:38',10,0),('1','307',2,'new shift','2022-12-24','2022-12-24 12:45:03','2022-12-25 12:45:03','1016',0.00,0.00,'1016','2022-12-24 19:21:06','1016','2022-12-24 19:21:28',10,0),('1','307',3,'DAILY SHIFT','2022-12-25','2022-12-25 07:28:14','2022-12-26 07:28:14','1016',0.00,0.00,'1016','2022-12-25 19:16:59','1016','2022-12-25 19:52:57',10,0),('1','307',4,'DAILY SHIFT','2022-12-26','2022-12-26 07:20:38','2022-12-27 07:20:38','1016',0.00,0.00,'1016','2022-12-26 19:24:20','1016','2022-12-27 07:44:50',10,0),('1','307',5,'DAILY SHIFT','2022-12-27','2022-12-27 07:45:27','2022-12-28 07:45:27','1016',0.00,0.00,'1016','2022-12-27 19:06:26','1016','2022-12-27 19:08:06',10,0),('1','307',6,'DAILY SHIFT','2022-12-28','2022-12-28 08:01:23','2022-12-29 08:01:23','1016',0.00,0.00,'1016','2022-12-28 19:04:43','1016','2022-12-28 19:05:20',10,0),('1','307',7,'DAILY SHIFT','2022-12-29','2022-12-29 07:13:35','2022-12-30 07:13:35','1016',0.00,0.00,'1016','2022-12-29 19:01:19','1016','2022-12-29 19:05:00',10,0),('1','307',8,'DAILY SHIFT','2022-12-30','2022-12-30 07:13:33','2022-12-31 07:13:33','1016',0.00,0.00,'1016','2022-12-30 19:06:59','1016','2022-12-30 19:07:28',10,0),('1','307',9,'DAILY SHIFT','2022-12-31','2022-12-31 07:06:28','2023-01-01 07:06:28','1016',0.00,0.00,'1016','2022-12-31 19:32:44','1016','2022-12-31 19:33:24',10,0),('1','307',10,'DAILY SHIFT','2023-01-01','2023-01-01 07:05:52','2023-01-02 07:05:52','1016',0.00,0.00,'1016','2023-01-01 18:49:43','1016','2023-01-01 18:50:11',10,0),('1','307',11,'DAILY SHIFT','2023-01-02','2023-01-02 07:13:54','2023-01-03 07:13:54','1016',0.00,0.00,'1016','2023-01-02 18:57:48','1016','2023-01-02 18:58:32',10,0),('1','307',12,'DAILY SHIFT','2023-01-03','2023-01-03 07:14:09','2023-01-04 07:14:09','1016',0.00,0.00,'1016','2023-01-03 18:49:51','1016','2023-01-03 18:50:27',10,0),('1','307',13,'DAILY SHIFT','2023-01-04','2023-01-04 07:37:37','2023-01-05 07:37:37','1016',0.00,0.00,'1016','2023-01-04 19:03:24','1016','2023-01-04 19:04:17',10,0),('1','307',14,'DAILY SHIFT','2023-01-05','2023-01-05 07:15:33','2023-01-06 07:15:33','1016',0.00,0.00,'1016','2023-01-05 18:51:11','1016','2023-01-05 18:51:38',10,0),('1','307',15,'DAILY SHIFT','2023-01-06','2023-01-06 07:25:42','2023-01-07 07:25:42','1016',0.00,0.00,'1016','2023-01-06 18:55:11','1016','2023-01-06 18:56:11',10,0),('1','307',16,'DAILY SHIFT','2023-01-07','2023-01-07 07:18:21','2023-01-08 07:18:21','1016',0.00,0.00,'1016','2023-01-07 19:08:42','1016','2023-01-07 19:09:25',10,0),('1','307',17,'DAILY SHIFT','2023-01-08','2023-01-08 07:16:21','2023-01-09 07:16:21','1016',0.00,0.00,'1016','2023-01-08 18:52:51','1016','2023-01-08 18:53:13',10,0),('1','307',18,'DAILY SHIFT','2023-01-09','2023-01-09 07:40:02','2023-01-10 07:40:02','1016',0.00,0.00,'1016','2023-01-09 19:07:24','1016','2023-01-09 19:08:14',10,0),('1','307',19,'DAILY SHIFT','2023-01-10','2023-01-10 07:24:00','2023-01-11 07:24:00','1016',0.00,0.00,'1016','2023-01-10 18:57:19','1016','2023-01-10 18:57:52',10,0),('1','307',20,'DAILY SHIFT','2023-01-11','2023-01-11 07:20:26','2023-01-12 07:20:26','1016',0.00,0.00,'1016','2023-01-11 13:42:39','1016','2023-01-11 13:49:23',10,0),('1','307',21,'0perational lost','2023-01-11','2023-01-11 13:50:04','2023-01-12 13:50:04','1016',0.00,0.00,'1016','2023-01-11 14:07:46','1016','2023-01-11 14:08:09',10,0),('1','307',22,'New shift','2023-01-11','2023-01-11 15:43:07','2023-01-12 15:43:07','1016',0.00,0.00,'1016','2023-01-11 18:52:19','1016','2023-01-11 18:52:39',10,0),('1','307',23,'DAILY SALES','2023-01-12','2023-01-12 07:23:35','2023-01-13 07:23:35','1016',0.00,0.00,'1016','2023-01-12 19:00:24','1016','2023-01-12 19:01:27',10,0),('1','307',24,'DAILY SHIFT','2023-01-13','2023-01-13 07:14:31','2023-01-14 07:14:31','1016',0.00,0.00,'1016','2023-01-13 18:58:36','1016','2023-01-13 18:58:59',10,0),('1','307',25,'DAILY SHIFT','2023-01-14','2023-01-14 07:20:54','2023-01-15 07:20:54','1016',0.00,0.00,'1016','2023-01-14 19:14:23','1016','2023-01-14 19:14:48',10,0),('1','307',26,'DAILY SALES','2023-01-15','2023-01-15 07:12:38','2023-01-16 07:12:38','1016',0.00,0.00,'1016','2023-01-15 19:14:14','1016','2023-01-15 19:15:52',10,0),('1','307',27,'DAILY SHIFT','2023-01-16','2023-01-16 07:06:55','2023-01-17 07:06:55','1016',0.00,0.00,'1016','2023-01-16 11:42:16','1016','2023-01-16 11:42:59',10,0),('1','307',28,'DAILY SALES','2023-01-16','2023-01-16 11:45:08','2023-01-17 11:45:08','1016',0.00,0.00,'1016','2023-01-16 19:07:48','1016','2023-01-16 19:08:26',10,0),('1','307',29,'DAILY SHIFT','2023-01-17','2023-01-17 08:05:31','2023-01-18 08:05:31','1016',0.00,0.00,'1016','2023-01-17 18:58:37','1016','2023-01-17 19:00:29',10,0),('1','307',30,'DAILY SHIFT','2023-01-18','2023-01-18 07:12:01','2023-01-19 07:12:01','1016',0.00,0.00,'1016','2023-01-18 18:59:54','1016','2023-01-18 19:00:19',10,0),('1','307',31,'DAILY SHIFT','2023-01-19','2023-01-19 07:16:47','2023-01-20 07:16:47','1016',0.00,0.00,'1016','2023-01-19 19:06:53','1016','2023-01-19 19:07:25',10,0),('1','307',32,'DAILY SHIFT','2023-01-20','2023-01-20 07:26:32','2023-01-21 07:26:32','1016',0.00,0.00,'1016','2023-01-20 18:58:19','1016','2023-01-20 18:58:55',10,0),('1','307',33,'DAILY SHIFT','2023-01-21','2023-01-21 07:25:11','2023-01-22 07:25:11','1016',0.00,0.00,'1016','2023-01-21 19:04:09','1016','2023-01-21 19:04:40',10,0),('1','307',34,'DAILY SHIFT','2023-01-22','2023-01-22 06:35:55','2023-01-23 06:35:55','1016',0.00,0.00,'1016','2023-01-22 18:56:16','1016','2023-01-22 18:56:39',10,0),('1','307',35,'DAILY SHIFT','2023-01-23','2023-01-23 07:24:48','2023-01-24 07:24:48','1016',0.00,0.00,'1016','2023-01-23 17:16:29','1016','2023-01-23 17:16:46',10,0),('1','307',36,'0perational lost','2023-01-23','2023-01-23 17:20:36','2023-01-24 17:20:36','1016',0.00,0.00,'1016','2023-01-23 17:47:13','1016','2023-01-23 17:47:44',10,0),('1','307',37,'DAILY SHIFT','2023-01-23','2023-01-23 17:48:51','2023-01-24 17:48:51','1016',0.00,0.00,'1016','2023-01-23 19:21:08','1016','2023-01-23 19:21:28',10,0),('1','307',38,'DAILY SHIFT','2023-01-24','2023-01-24 07:15:28','2023-01-25 07:15:28','1016',0.00,0.00,'1016','2023-01-24 19:09:37','1016','2023-01-24 19:10:03',10,0),('1','307',39,'DAILY SHIFT','2023-01-25','2023-01-25 07:11:37','2023-01-26 07:11:37','1016',0.00,0.00,'1016','2023-01-25 19:13:32','1016','2023-01-25 19:13:57',10,0),('1','307',40,'DAILY SHIFT','2023-01-26','2023-01-26 07:11:09','2023-01-27 07:11:09','1016',0.00,0.00,'1016','2023-01-26 19:00:37','1016','2023-01-26 19:00:59',10,0),('1','307',41,'DAILY SHIFT','2023-01-27','2023-01-27 07:18:23','2023-01-28 07:18:23','1016',0.00,0.00,'1016','2023-01-27 19:12:42','1016','2023-01-27 19:13:16',10,0),('1','307',42,'DAILY SHIFT','2023-01-28','2023-01-28 07:03:37','2023-01-29 07:03:37','1016',0.00,0.00,'1016','2023-01-28 19:30:50','1016','2023-01-28 19:31:11',10,0),('1','307',43,'DAILY SHIFT','2023-01-29','2023-01-29 07:26:56','2023-01-30 07:26:56','1016',0.00,0.00,'1016','2023-01-29 19:14:17','1016','2023-01-29 19:14:54',10,0),('1','307',44,'DAILY SHIFT','2023-01-30','2023-01-30 07:12:17','2023-01-31 07:12:17','1016',0.00,0.00,'1016','2023-01-30 19:13:49','1016','2023-01-30 19:14:41',10,0),('1','307',45,'DAILY SHIFT','2023-01-31','2023-01-31 07:30:08','2023-02-01 07:30:08','1016',0.00,0.00,'1016','2023-01-31 19:12:23','1016','2023-01-31 19:12:50',10,0),('1','307',46,'DAILY SHIFT','2023-02-01','2023-02-01 07:25:07','2023-02-02 07:25:07','1016',0.00,0.00,'1016','2023-02-01 19:40:10','1016','2023-02-01 19:40:35',10,0),('1','307',47,'0perational lost','2023-02-01','2023-02-02 07:30:21','2023-02-03 07:30:21','1016',0.00,0.00,'1016','2023-02-02 07:37:07','1016','2023-02-02 07:37:25',10,0),('1','307',48,'DAILY SHIFT','2023-02-02','2023-02-02 07:38:07','2023-02-03 07:38:07','1016',0.00,0.00,'1016','2023-02-02 19:27:32','1016','2023-02-02 19:28:02',10,0),('1','307',49,'DAILY SHIFT','2023-02-03','2023-02-03 07:25:30','2023-02-04 07:25:30','1016',0.00,0.00,'1016','2023-02-03 19:07:36','1016','2023-02-03 19:09:08',10,0),('1','307',50,'DAILY SHIFT','2023-02-04','2023-02-04 07:46:51','2023-02-05 07:46:51','1016',0.00,0.00,'1016','2023-02-04 19:33:32','1016','2023-02-04 19:34:00',10,0),('1','307',51,'DAILY SHIFT','2023-02-05','2023-02-05 07:15:17','2023-02-06 07:15:17','1016',0.00,0.00,'1016','2023-02-05 19:14:35','1016','2023-02-05 19:14:54',10,0),('1','307',52,'DAILY SHIFT','2023-02-06','2023-02-06 07:23:14','2023-02-07 07:23:14','1016',0.00,0.00,'1016','2023-02-06 19:32:19','1016','2023-02-06 19:32:37',10,0),('1','307',53,'DAILY SHIFT','2023-02-07','2023-02-07 07:20:44','2023-02-08 07:20:44','1016',0.00,0.00,'1016','2023-02-07 19:05:49','1016','2023-02-07 19:06:11',10,0),('1','307',54,'DAILY SHIFT','2023-02-08','2023-02-08 07:33:36','2023-02-09 07:33:36','1016',0.00,0.00,'1016','2023-02-08 19:13:56','1016','2023-02-08 19:14:27',10,0),('1','307',55,'DAILY SHIFT','2023-02-09','2023-02-09 07:28:12','2023-02-10 07:28:12','1016',0.00,0.00,'1016','2023-02-09 19:16:37','1016','2023-02-09 19:17:01',10,0),('1','307',56,'DAILY SHIFT','2023-02-10','2023-02-10 07:24:21','2023-02-11 07:24:21','1016',0.00,0.00,'1016','2023-02-10 20:00:30','1016','2023-02-10 20:00:50',10,0),('1','307',57,'DAILY SHIFT','2023-02-11','2023-02-11 07:28:24','2023-02-12 07:28:24','1016',0.00,0.00,'1016','2023-02-11 12:10:31','1016','2023-02-11 12:10:56',10,0),('1','307',58,'DAILY SHIFT','2023-02-11','2023-02-11 12:13:52','2023-02-12 12:13:52','1016',0.00,0.00,'1016','2023-02-11 19:53:52','1016','2023-02-11 19:54:14',10,0),('1','307',59,'DAILY SHIFT','2023-02-12','2023-02-12 07:33:15','2023-02-13 07:33:15','1016',0.00,0.00,'1016','2023-02-12 19:25:40','1016','2023-02-12 19:26:01',10,0),('1','307',60,'DAILY SHIFT','2023-02-13','2023-02-13 07:26:37','2023-02-14 07:26:37','1016',0.00,0.00,'1016','2023-02-13 19:19:28','1016','2023-02-13 19:19:48',10,0),('1','307',61,'DAILY SHIFT','2023-02-14','2023-02-14 07:32:17','2023-02-15 07:32:17','1016',0.00,0.00,'1016','2023-02-14 19:32:23','1016','2023-02-14 19:32:48',10,0),('1','307',62,'DAILY SHIFT','2023-02-15','2023-02-15 07:43:26','2023-02-16 07:43:26','1016',0.00,0.00,'1016','2023-02-15 19:18:23','1016','2023-02-15 19:19:11',10,0),('1','307',63,'DAILY SHIFT','2023-02-16','2023-02-16 07:31:30','2023-02-17 07:31:30','1016',0.00,0.00,'1016','2023-02-17 07:30:38','1016','2023-02-17 07:31:21',10,0),('1','307',64,'DAILY SHIFT','2023-02-17','2023-02-17 07:32:10','2023-02-18 07:32:10','1016',0.00,0.00,'1016','2023-02-17 12:30:31','1016','2023-02-17 12:31:49',10,0),('1','307',65,'0perational lost','2023-02-17','2023-02-17 12:32:13','2023-02-18 12:32:13','1016',0.00,0.00,'1016','2023-02-17 12:37:07','1016','2023-02-17 12:37:23',10,0),('1','307',66,'DAILY SHIFT','2023-02-17','2023-02-17 12:38:00','2023-02-18 12:38:00','1016',0.00,0.00,'1016','2023-02-17 19:54:02','1016','2023-02-17 19:54:24',10,0),('1','307',67,'DAILY SHIFT','2023-02-18','2023-02-18 07:39:24','2023-02-19 07:39:24','1016',0.00,0.00,'1016','2023-02-18 19:32:56','1016','2023-02-18 19:33:16',10,0),('1','307',68,'DAILY SHIFT','2023-02-19','2023-02-19 07:34:02','2023-02-20 07:34:02','1016',0.00,0.00,'1016','2023-02-19 21:49:41','1016','2023-02-19 21:50:20',10,0),('1','307',69,'DAILY SHIFT','2023-02-20','2023-02-20 07:25:56','2023-02-21 07:25:56','1016',0.00,0.00,'1016','2023-02-20 19:46:39','1016','2023-02-20 19:47:12',10,0),('1','307',70,'DAILY SHIFT','2023-02-21','2023-02-21 07:24:20','2023-02-22 07:24:20','1016',0.00,0.00,'1016','2023-02-21 19:36:39','1016','2023-02-21 19:37:00',10,0),('1','307',71,'DAILY SHIFT','2023-02-22','2023-02-22 07:50:37','2023-02-23 07:50:37','1016',0.00,0.00,'1016','2023-02-22 19:14:21','1016','2023-02-22 19:14:44',10,0),('1','307',72,'DAILY SHIFT','2023-02-23','2023-02-23 07:23:19','2023-02-24 07:23:19','1016',0.00,0.00,'1016','2023-02-23 17:49:06','1016','2023-02-23 17:49:36',10,0),('1','307',73,'0perational lost','2023-02-23','2023-02-23 17:50:22','2023-02-24 17:50:22','1016',0.00,0.00,'1016','2023-02-23 17:56:39','1016','2023-02-23 17:56:59',10,0),('1','307',74,'DAILY SHIFT','2023-02-24','2023-02-24 07:27:53','2023-02-25 07:27:53','1016',0.00,0.00,'1016','2023-02-25 00:06:35','1016','2023-02-25 00:08:13',10,0),('1','307',75,'DAILY SHIFT','2023-02-26','2023-02-26 07:30:46','2023-02-27 07:30:46','1016',0.00,0.00,'1016','2023-02-26 20:10:11','1016','2023-02-26 20:10:41',10,0),('1','307',76,'DAILY SHIFT','2023-02-27','2023-02-27 07:25:39','2023-02-28 07:25:39','1016',0.00,0.00,'1016','2023-02-27 20:23:31','1016','2023-02-27 20:23:59',10,0),('1','307',77,'DAILY SHIFT','2023-02-28','2023-02-28 07:18:52','2023-03-01 07:18:52','1016',0.00,0.00,'1016','2023-02-28 19:45:29','1016','2023-02-28 19:45:49',10,0),('1','307',78,'DAILY SHIFT','2023-03-01','2023-03-01 07:20:58','2023-03-02 07:20:58','1016',0.00,0.00,'1016','2023-03-01 19:52:23','1016','2023-03-01 19:52:48',10,0),('1','307',79,'DAILY SHIFT','2023-03-02','2023-03-02 07:15:59','2023-03-03 07:15:59','1016',0.00,0.00,'1016','2023-03-02 19:42:12','1016','2023-03-02 19:42:40',10,0),('1','307',80,'DAILY SHIFT','2023-03-03','2023-03-03 07:23:11','2023-03-04 07:23:11','1016',0.00,0.00,'1016','2023-03-03 19:55:51','1016','2023-03-03 19:56:11',10,0),('1','307',81,'DAILY SHIFT','2023-03-04','2023-03-04 07:33:04','2023-03-05 07:33:04','1016',0.00,0.00,'1016','2023-03-04 20:27:46','1016','2023-03-04 20:28:10',10,0),('1','307',82,'DAILY SHIFT','2023-03-05','2023-03-05 07:25:24','2023-03-06 07:25:24','1016',0.00,0.00,'1016','2023-03-05 19:32:20','1016','2023-03-05 19:32:42',10,0),('1','307',83,'DAILY SHIFT','2023-03-06','2023-03-06 07:22:30','2023-03-07 07:22:30','1016',0.00,0.00,'1016','2023-03-07 02:33:26','1016','2023-03-07 02:33:46',10,0),('1','307',84,'DAILY SHIFT','2023-03-07','2023-03-07 07:25:35','2023-03-08 07:25:35','1016',0.00,0.00,'1016','2023-03-07 19:00:59','1016','2023-03-07 19:01:23',10,0),('1','307',85,'DAILY SHIFT','2023-03-08','2023-03-08 07:23:50','2023-03-09 07:23:50','1016',0.00,0.00,'1016','2023-03-08 13:49:12','1016','2023-03-08 13:49:30',10,0),('1','307',86,'0perational lost','2023-03-08','2023-03-08 13:49:53','2023-03-09 13:49:53','1016',0.00,0.00,'1016','2023-03-08 13:53:12','1016','2023-03-08 13:53:28',10,0),('1','307',87,'DAILY SHIFT','2023-03-08','2023-03-08 17:48:57','2023-03-09 17:48:57','1016',0.00,0.00,'1016','2023-03-08 21:46:11','1016','2023-03-08 21:46:32',10,0),('1','307',88,'DAILY SHIFT','2023-03-09','2023-03-09 09:06:24','2023-03-10 09:06:24','1016',0.00,0.00,'1016','2023-03-09 19:06:06','1016','2023-03-09 19:06:26',10,0),('1','307',89,'DAILY SHIFT','2023-03-10','2023-03-10 07:20:47','2023-03-11 07:20:47','1016',0.00,0.00,'1016','2023-03-10 19:25:13','1016','2023-03-10 19:25:33',10,0),('1','307',90,'DAILY SHIFT','2023-03-11','2023-03-11 07:23:50','2023-03-12 07:23:50','1016',0.00,0.00,'1016','2023-03-11 19:55:11','1016','2023-03-11 19:55:30',10,0),('1','307',91,'DAILY SHIFT','2023-03-12','2023-03-12 07:18:12','2023-03-13 07:18:12','1016',0.00,0.00,'1016','2023-03-12 19:20:10','1016','2023-03-12 19:20:29',10,0),('1','307',92,'DAILY SHIFT','2023-03-13','2023-03-13 07:22:00','2023-03-14 07:22:00','1016',0.00,0.00,'1016','2023-03-13 19:20:49','1016','2023-03-13 19:21:10',10,0),('1','307',93,'DAILY SHIFT','2023-03-14','2023-03-14 07:27:38','2023-03-15 07:27:38','1016',0.00,0.00,'1016','2023-03-14 09:40:26','1016','2023-03-14 09:40:48',10,0),('1','307',94,'0perational lost','2023-03-14','2023-03-14 09:41:16','2023-03-15 09:41:16','1016',0.00,0.00,'1016','2023-03-14 09:44:21','1016','2023-03-14 09:44:41',10,0),('1','307',95,'DAILY SHIFT','2023-03-14','2023-03-14 09:45:00','2023-03-15 09:45:00','1016',0.00,0.00,'1016','2023-03-14 19:56:31','1016','2023-03-14 19:57:05',10,0),('1','307',96,'DAILY SHIFT','2023-03-15','2023-03-15 07:17:33','2023-03-16 07:17:33','1016',0.00,0.00,'1016','2023-03-15 19:40:14','1016','2023-03-15 19:40:33',10,0),('1','307',97,'DAILY SHIFT','2023-03-16','2023-03-16 07:11:19','2023-03-17 07:11:19','1016',0.00,0.00,'1016','2023-03-16 19:44:28','1016','2023-03-16 19:44:53',10,0),('1','307',98,'DAILY SHIFT','2023-03-17','2023-03-17 07:14:57','2023-03-18 07:14:57','1016',0.00,0.00,'1016','2023-03-17 19:12:16','1016','2023-03-17 19:12:48',10,0),('1','307',99,'DAILY SHIFT','2023-03-19','2023-03-19 07:18:51','2023-03-20 07:18:51','1016',0.00,0.00,'1016','2023-03-19 19:30:55','1016','2023-03-19 19:31:14',10,0),('1','307',100,'DAILY SHIFT','2023-03-20','2023-03-20 07:15:53','2023-03-21 07:15:53','1016',0.00,0.00,'1016','2023-03-20 19:59:10','1016','2023-03-20 19:59:34',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=201 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','307','1','1',1,'1','1',0.00,7.04,0.00,0.00,7.04,5420.80,0.00,0.00,0.00),('1','307','1','1',2,'2','1',0.00,23.37,0.00,0.00,23.37,17994.90,0.00,0.00,0.00),('1','307','1','2',3,'1','1',7.04,128.41,0.00,0.00,121.37,86172.70,0.00,0.00,0.00),('1','307','1','2',4,'2','1',23.37,155.19,0.00,0.00,131.82,101501.40,0.00,0.00,0.00),('1','307','1','3',5,'1','1',128.41,128.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','307','1','3',6,'2','1',155.19,257.18,0.00,0.00,101.99,78532.30,0.00,0.00,0.00),('1','307','1','4',7,'1','1',128.41,128.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','307','1','4',8,'2','1',257.18,347.79,0.00,0.00,90.61,69769.70,0.00,0.00,0.00),('1','307','1','5',9,'1','1',128.41,180.36,0.00,0.00,51.95,36884.50,0.00,0.00,0.00),('1','307','1','5',10,'2','1',347.79,436.02,0.00,0.00,88.23,67937.10,0.00,0.00,0.00),('1','307','1','6',11,'1','1',180.36,230.20,0.00,0.00,49.84,35386.40,0.00,0.00,0.00),('1','307','1','6',12,'2','1',436.02,511.15,0.00,0.00,75.13,57850.10,0.00,0.00,0.00),('1','307','1','7',13,'1','1',230.20,230.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','307','1','7',14,'2','1',511.15,619.22,0.00,0.00,108.07,83213.90,0.00,0.00,0.00),('1','307','1','8',15,'1','1',230.20,280.03,0.00,0.00,49.83,35379.30,0.00,0.00,0.00),('1','307','1','8',16,'2','1',619.22,830.50,0.00,0.00,211.28,162685.60,0.00,0.00,0.00),('1','307','1','9',17,'1','1',280.03,630.29,0.00,0.00,350.26,248684.60,0.00,0.00,0.00),('1','307','1','9',18,'2','1',830.50,966.69,0.00,0.00,136.19,104866.30,0.00,0.00,0.00),('1','307','1','10',19,'1','1',630.29,996.29,0.00,0.00,366.00,259860.00,0.00,0.00,0.00),('1','307','1','10',20,'2','1',966.69,1145.68,0.00,0.00,178.99,137822.30,0.00,0.00,0.00),('1','307','1','11',21,'1','1',996.29,1196.29,0.00,0.00,200.00,142000.00,0.00,0.00,0.00),('1','307','1','11',22,'2','1',1145.68,1298.00,0.00,0.00,152.32,117286.40,0.00,0.00,0.00),('1','307','1','12',23,'1','1',1196.29,1396.29,0.00,0.00,200.00,142000.00,0.00,0.00,0.00),('1','307','1','12',24,'2','1',1298.00,1403.32,0.00,0.00,105.32,81096.40,0.00,0.00,0.00),('1','307','1','13',25,'1','1',1396.29,1946.29,0.00,0.00,550.00,390500.00,0.00,0.00,0.00),('1','307','1','13',26,'2','1',1403.32,1572.31,0.00,0.00,168.99,130122.30,0.00,0.00,0.00),('1','307','1','14',27,'1','1',1946.29,2046.29,0.00,0.00,100.00,71000.00,0.00,0.00,0.00),('1','307','1','14',28,'2','1',1572.31,1717.19,0.00,0.00,144.88,111557.60,0.00,0.00,0.00),('1','307','1','15',29,'1','1',2046.29,2096.29,0.00,0.00,50.00,35500.00,0.00,0.00,0.00),('1','307','1','15',30,'2','1',1717.19,1857.32,0.00,0.00,140.13,107900.10,0.00,0.00,0.00),('1','307','1','16',31,'1','1',2096.29,2270.29,0.00,0.00,174.00,123540.00,0.00,0.00,0.00),('1','307','1','16',32,'2','1',1857.32,2016.53,0.00,0.00,159.21,122591.70,0.00,0.00,0.00),('1','307','1','17',33,'1','1',2270.29,2270.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','307','1','17',34,'2','1',2016.53,2246.61,0.00,0.00,230.08,177161.60,0.00,0.00,0.00),('1','307','1','18',35,'1','1',2270.29,2420.29,0.00,0.00,150.00,106500.00,0.00,0.00,0.00),('1','307','1','18',36,'2','1',2246.61,2387.12,0.00,0.00,140.51,108192.70,0.00,0.00,0.00),('1','307','1','19',37,'1','1',2420.29,2620.29,0.00,0.00,200.00,142000.00,0.00,0.00,0.00),('1','307','1','19',38,'2','1',2387.12,2475.03,0.00,0.00,87.91,67690.70,0.00,0.00,0.00),('1','307','1','20',39,'1','1',2620.29,2620.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','307','1','20',40,'2','1',2475.03,2597.02,0.00,0.00,121.99,93932.30,0.00,0.00,0.00),('1','307','1','21',41,'1','1',2620.29,2620.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','307','1','21',42,'2','1',2597.02,2597.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','307','1','22',43,'1','1',2620.29,2670.29,0.00,0.00,50.00,35500.00,0.00,0.00,0.00),('1','307','1','22',44,'2','1',2597.02,2678.47,0.00,0.00,81.45,62716.50,0.00,0.00,0.00),('1','307','1','23',45,'1','1',2670.29,2805.29,0.00,0.00,135.00,95850.00,0.00,0.00,0.00),('1','307','1','23',46,'2','1',2678.47,2836.03,0.00,0.00,157.56,119745.60,0.00,0.00,0.00),('1','307','1','24',47,'1','1',2805.29,2980.29,0.00,0.00,175.00,124250.00,0.00,0.00,0.00),('1','307','1','24',48,'2','1',2836.03,3026.54,0.00,0.00,190.51,144787.60,0.00,0.00,0.00),('1','307','1','25',49,'1','1',2980.29,3180.29,0.00,0.00,200.00,142000.00,0.00,0.00,0.00),('1','307','1','25',50,'2','1',3026.54,3300.83,0.00,0.00,274.29,208460.40,0.00,0.00,0.00),('1','307','1','26',51,'1','1',3180.29,3280.29,0.00,0.00,100.00,71000.00,0.00,0.00,0.00),('1','307','1','26',52,'2','1',3300.83,3601.04,0.00,0.00,300.21,228159.60,0.00,0.00,0.00),('1','307','1','27',53,'1','1',3280.29,3405.29,0.00,0.00,125.00,88750.00,0.00,0.00,0.00),('1','307','1','27',54,'2','1',3601.04,3666.15,0.00,0.00,65.11,49483.60,0.00,0.00,0.00),('1','307','1','28',55,'1','1',3405.29,3505.29,0.00,0.00,100.00,71000.00,0.00,0.00,0.00),('1','307','1','28',56,'2','1',3666.15,3781.52,0.00,0.00,115.37,85373.80,0.00,0.00,0.00),('1','307','1','29',57,'1','1',3505.29,3630.29,0.00,0.00,125.00,88750.00,0.00,0.00,0.00),('1','307','1','29',58,'2','1',3781.52,4008.34,0.00,0.00,226.82,167846.80,0.00,0.00,0.00),('1','307','1','30',59,'1','1',3630.29,3630.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','307','1','30',60,'2','1',4008.34,4283.53,0.00,0.00,275.19,203640.60,0.00,0.00,0.00),('1','307','1','31',61,'1','1',3630.29,3755.29,0.00,0.00,125.00,88750.00,0.00,0.00,0.00),('1','307','1','31',62,'2','1',4283.53,4562.14,0.00,0.00,278.61,206171.40,0.00,0.00,0.00),('1','307','1','32',63,'1','1',3755.29,3844.72,0.00,0.00,89.43,63495.30,0.00,0.00,0.00),('1','307','1','32',64,'2','1',4562.14,4730.32,0.00,0.00,168.18,124453.20,0.00,0.00,0.00),('1','307','1','33',65,'1','1',3844.72,4069.72,0.00,0.00,225.00,159750.00,0.00,0.00,0.00),('1','307','1','33',66,'2','1',4730.32,5092.98,0.00,0.00,362.66,268368.40,0.00,0.00,0.00),('1','307','1','34',67,'1','1',4069.72,4519.72,0.00,0.00,450.00,315000.00,0.00,0.00,0.00),('1','307','1','34',68,'2','1',5092.98,5406.75,0.00,0.00,313.77,232189.80,0.00,0.00,0.00),('1','307','1','35',69,'1','1',4519.72,4844.72,0.00,0.00,325.00,227500.00,0.00,0.00,0.00),('1','307','1','35',70,'2','1',5406.75,5608.77,0.00,0.00,202.02,149494.80,0.00,0.00,0.00),('1','307','1','36',71,'1','1',4844.72,4844.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','307','1','36',72,'2','1',5608.77,5608.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','307','1','37',73,'1','1',4844.72,4994.72,0.00,0.00,150.00,105000.00,0.00,0.00,0.00),('1','307','1','37',74,'2','1',5608.77,5670.76,0.00,0.00,61.99,45872.60,0.00,0.00,0.00),('1','307','1','38',75,'1','1',4994.72,5494.72,0.00,0.00,500.00,350000.00,0.00,0.00,0.00),('1','307','1','38',76,'2','1',5670.76,5791.32,0.00,0.00,120.56,89214.40,0.00,0.00,0.00),('1','307','1','39',77,'1','1',5494.72,5919.72,0.00,0.00,425.00,297500.00,0.00,0.00,0.00),('1','307','1','39',78,'2','1',5791.32,6005.05,0.00,0.00,213.73,158160.20,0.00,0.00,0.00),('1','307','1','40',79,'1','1',5919.72,6134.72,0.00,0.00,215.00,150500.00,0.00,0.00,0.00),('1','307','1','40',80,'2','1',6005.05,6302.01,0.00,0.00,296.96,219750.40,0.00,0.00,0.00),('1','307','1','41',81,'1','1',6134.72,6413.29,0.00,0.00,278.57,194999.00,0.00,0.00,0.00),('1','307','1','41',82,'2','1',6302.01,6518.66,0.00,0.00,216.65,160321.00,0.00,0.00,0.00),('1','307','1','42',83,'1','1',6413.29,6536.29,0.00,0.00,123.00,86100.00,0.00,0.00,0.00),('1','307','1','42',84,'2','1',6518.66,6756.61,0.00,0.00,237.95,176083.00,0.00,0.00,0.00),('1','307','1','43',85,'1','1',6536.29,6911.29,0.00,0.00,375.00,262500.00,0.00,0.00,0.00),('1','307','1','43',86,'2','1',6756.61,6984.79,0.00,0.00,228.18,168853.20,0.00,0.00,0.00),('1','307','1','44',87,'1','1',6911.29,7061.29,0.00,0.00,150.00,105000.00,0.00,0.00,0.00),('1','307','1','44',88,'2','1',6984.79,7191.67,0.00,0.00,206.88,153091.20,0.00,0.00,0.00),('1','307','1','45',89,'1','1',7061.29,7406.29,0.00,0.00,345.00,241500.00,0.00,0.00,0.00),('1','307','1','45',90,'2','1',7191.67,7326.87,0.00,0.00,135.20,100048.00,0.00,0.00,0.00),('1','307','1','46',91,'1','1',7406.29,7831.29,0.00,0.00,425.00,297500.00,0.00,0.00,0.00),('1','307','1','46',92,'2','1',7326.87,7549.33,0.00,0.00,222.46,164620.40,0.00,0.00,0.00),('1','307','1','47',93,'1','1',7831.29,7831.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','307','1','47',94,'2','1',7549.33,7549.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','307','1','48',95,'1','1',7831.29,8004.15,0.00,0.00,172.86,121002.00,0.00,0.00,0.00),('1','307','1','48',96,'2','1',7549.33,7758.79,0.00,0.00,209.46,155000.40,0.00,0.00,0.00),('1','307','1','49',97,'1','1',8004.15,8479.15,0.00,0.00,475.00,332500.00,0.00,0.00,0.00),('1','307','1','49',98,'2','1',7758.79,7983.57,0.00,0.00,224.78,166337.20,0.00,0.00,0.00),('1','307','1','50',99,'1','1',8479.15,8629.15,0.00,0.00,150.00,105000.00,0.00,0.00,0.00),('1','307','1','50',100,'2','1',7983.57,8250.90,0.00,0.00,267.33,197824.20,0.00,0.00,0.00),('1','307','1','51',101,'1','1',8629.15,8854.15,0.00,0.00,225.00,157500.00,0.00,0.00,0.00),('1','307','1','51',102,'2','1',8250.90,8623.71,0.00,0.00,372.81,275879.40,0.00,0.00,0.00),('1','307','1','52',103,'1','1',8854.15,9155.38,0.00,0.00,301.23,210861.00,0.00,0.00,0.00),('1','307','1','52',104,'2','1',8623.71,8951.02,0.00,0.00,327.31,242209.40,0.00,0.00,0.00),('1','307','1','53',105,'1','1',9155.38,9320.38,0.00,0.00,165.00,115500.00,0.00,0.00,0.00),('1','307','1','53',106,'2','1',8951.02,9130.72,0.00,0.00,179.70,132978.00,0.00,0.00,0.00),('1','307','1','54',107,'1','1',9320.38,9564.95,0.00,0.00,244.57,171199.00,0.00,0.00,0.00),('1','307','1','54',108,'2','1',9130.72,9480.79,0.00,0.00,350.07,259051.80,0.00,0.00,0.00),('1','307','1','55',109,'1','1',9564.95,10210.83,0.00,0.00,645.88,439198.40,0.00,0.00,0.00),('1','307','1','55',110,'2','1',9480.79,9855.08,0.00,0.00,374.29,276974.60,0.00,0.00,0.00),('1','307','1','56',111,'1','1',10210.83,10488.83,0.00,0.00,278.00,189220.00,0.00,0.00,0.00),('1','307','1','56',112,'2','1',9855.08,10173.22,0.00,0.00,318.14,235423.60,0.00,0.00,0.00),('1','307','1','57',113,'1','1',10488.83,10524.30,0.00,0.00,35.47,24119.60,0.00,0.00,0.00),('1','307','1','57',114,'2','1',10173.22,10238.62,0.00,0.00,65.40,48396.00,0.00,0.00,0.00),('1','307','1','58',115,'1','1',10524.30,10731.83,0.00,0.00,207.53,141120.40,0.00,0.00,0.00),('1','307','1','58',116,'2','1',10238.62,10534.80,0.00,0.00,296.18,219173.20,0.00,0.00,0.00),('1','307','1','59',117,'1','1',10731.83,11376.33,0.00,0.00,644.50,438260.00,0.00,0.00,0.00),('1','307','1','59',118,'2','1',10534.80,10951.33,0.00,0.00,416.53,308232.20,0.00,0.00,0.00),('1','307','1','60',119,'1','1',11376.33,12471.71,0.00,0.00,1095.38,744858.40,0.00,0.00,0.00),('1','307','1','60',120,'2','1',10951.33,11282.72,0.00,0.00,331.39,245228.60,0.00,0.00,0.00),('1','307','1','61',121,'1','1',12471.71,13134.21,0.00,0.00,662.50,450500.00,0.00,0.00,0.00),('1','307','1','61',122,'2','1',11282.72,11578.79,0.00,0.00,296.07,219091.80,0.00,0.00,0.00),('1','307','1','62',123,'1','1',13134.21,13284.21,0.00,0.00,150.00,102000.00,0.00,0.00,0.00),('1','307','1','62',124,'2','1',11578.79,11891.23,0.00,0.00,312.44,231205.60,0.00,0.00,0.00),('1','307','1','63',125,'1','1',13284.21,13699.21,0.00,0.00,415.00,282200.00,0.00,0.00,0.00),('1','307','1','63',126,'2','1',11891.23,12123.59,0.00,0.00,232.36,171016.96,0.00,0.00,0.00),('1','307','1','64',127,'1','1',13699.21,13764.50,0.00,0.00,65.29,44397.20,0.00,0.00,0.00),('1','307','1','64',128,'2','1',12123.59,12225.97,0.00,0.00,102.38,75351.68,0.00,0.00,0.00),('1','307','1','65',129,'1','1',13764.50,13764.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','307','1','65',130,'2','1',12225.97,12225.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','307','1','66',131,'1','1',13764.50,13827.00,0.00,0.00,62.50,42500.00,0.00,0.00,0.00),('1','307','1','66',132,'2','1',12225.97,12400.49,0.00,0.00,174.52,128446.72,0.00,0.00,0.00),('1','307','1','67',133,'1','1',13827.00,14023.00,0.00,0.00,196.00,133280.00,0.00,0.00,0.00),('1','307','1','67',134,'2','1',12400.49,12695.67,0.00,0.00,295.18,217252.48,0.00,0.00,0.00),('1','307','1','68',135,'1','1',14023.00,14438.00,0.00,0.00,415.00,282200.00,0.00,0.00,0.00),('1','307','1','68',136,'2','1',12695.67,13166.56,0.00,0.00,470.89,343775.04,0.00,0.00,0.00),('1','307','1','69',137,'1','1',14438.00,15133.00,0.00,0.00,695.00,472600.00,0.00,0.00,0.00),('1','307','1','69',138,'2','1',13166.56,13566.51,0.00,0.00,399.95,294363.20,0.00,0.00,0.00),('1','307','1','70',139,'1','1',15133.00,15553.50,0.00,0.00,420.50,285940.00,0.00,0.00,0.00),('1','307','1','70',140,'2','1',13566.51,13981.91,0.00,0.00,415.40,305734.40,0.00,0.00,0.00),('1','307','1','71',141,'1','1',15553.50,15878.50,0.00,0.00,325.00,221000.00,0.00,0.00,0.00),('1','307','1','71',142,'2','1',13981.91,14369.42,0.00,0.00,387.51,285207.36,0.00,0.00,0.00),('1','307','1','72',143,'1','1',15878.50,16254.73,0.00,0.00,376.23,255836.40,0.00,0.00,0.00),('1','307','1','72',144,'2','1',14369.42,14776.22,0.00,0.00,406.80,299404.80,0.00,0.00,0.00),('1','307','1','73',145,'1','1',16254.73,16254.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','307','1','73',146,'2','1',14776.22,14776.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','307','1','74',147,'1','1',16254.73,16819.73,0.00,0.00,565.00,384200.00,0.00,0.00,0.00),('1','307','1','74',148,'2','1',14776.22,15392.19,0.00,0.00,615.97,453353.92,0.00,0.00,0.00),('1','307','1','75',149,'1','1',16819.73,17752.73,0.00,0.00,933.00,634440.00,0.00,0.00,0.00),('1','307','1','75',150,'2','1',15392.19,15755.03,0.00,0.00,362.84,267050.24,0.00,0.00,0.00),('1','307','1','76',151,'1','1',17752.73,18376.81,0.00,0.00,624.08,424374.40,0.00,0.00,0.00),('1','307','1','76',152,'2','1',15755.03,16068.15,0.00,0.00,313.12,230456.32,0.00,0.00,0.00),('1','307','1','77',153,'1','1',18376.81,18595.19,0.00,0.00,218.38,148498.40,0.00,0.00,0.00),('1','307','1','77',154,'2','1',16068.15,16415.40,0.00,0.00,347.25,255576.00,0.00,0.00,0.00),('1','307','1','78',155,'1','1',18595.19,18899.96,0.00,0.00,304.77,207243.60,0.00,0.00,0.00),('1','307','1','78',156,'2','1',16415.40,16692.89,0.00,0.00,277.49,204232.64,0.00,0.00,0.00),('1','307','1','79',157,'1','1',18899.96,19128.46,0.00,0.00,228.50,155380.00,0.00,0.00,0.00),('1','307','1','79',158,'2','1',16692.89,16932.06,0.00,0.00,239.17,176029.12,0.00,0.00,0.00),('1','307','1','80',159,'1','1',19128.46,19628.46,0.00,0.00,500.00,340000.00,0.00,0.00,0.00),('1','307','1','80',160,'2','1',16932.06,17228.06,0.00,0.00,296.00,217856.00,0.00,0.00,0.00),('1','307','1','81',161,'1','1',19628.46,20166.70,0.00,0.00,538.24,366003.20,0.00,0.00,0.00),('1','307','1','81',162,'2','1',17228.06,17585.01,0.00,0.00,356.95,262715.20,0.00,0.00,0.00),('1','307','1','82',163,'1','1',20166.70,20822.70,0.00,0.00,656.00,446080.00,0.00,0.00,0.00),('1','307','1','82',164,'2','1',17585.01,18018.45,0.00,0.00,433.44,319011.84,0.00,0.00,0.00),('1','307','1','83',165,'1','1',20822.70,20967.20,0.00,0.00,144.50,98260.00,0.00,0.00,0.00),('1','307','1','83',166,'2','1',18018.45,18268.16,0.00,0.00,249.71,183786.56,0.00,0.00,0.00),('1','307','1','84',167,'1','1',20967.20,21329.70,0.00,0.00,362.50,246500.00,0.00,0.00,0.00),('1','307','1','84',168,'2','1',18268.16,18541.24,0.00,0.00,273.08,200986.88,0.00,0.00,0.00),('1','307','1','85',169,'1','1',21329.70,21846.87,0.00,0.00,517.17,351675.60,0.00,0.00,0.00),('1','307','1','85',170,'2','1',18541.24,18717.36,0.00,0.00,176.12,129624.32,0.00,0.00,0.00),('1','307','1','86',171,'1','1',21846.87,21846.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','307','1','86',172,'2','1',18717.36,18717.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','307','1','87',173,'1','1',21846.87,22001.87,0.00,0.00,155.00,101990.00,0.00,0.00,0.00),('1','307','1','87',174,'2','1',18717.36,18833.73,0.00,0.00,116.37,83946.96,0.00,0.00,0.00),('1','307','1','88',175,'1','1',22001.87,22474.87,0.00,0.00,473.00,311234.00,0.00,0.00,0.00),('1','307','1','88',176,'2','1',18833.73,19130.50,0.00,0.00,296.77,207739.00,0.00,0.00,0.00),('1','307','1','89',177,'1','1',22474.87,22999.38,0.00,0.00,524.51,345127.58,0.00,0.00,0.00),('1','307','1','89',178,'2','1',19130.50,19515.50,0.00,0.00,385.00,269500.00,0.00,0.00,0.00),('1','307','1','90',179,'1','1',22999.38,23559.68,0.00,0.00,560.30,370405.28,0.00,0.00,0.00),('1','307','1','90',180,'2','1',19515.50,20059.10,0.00,0.00,543.60,380520.00,0.00,0.00,0.00),('1','307','1','91',181,'1','1',23559.68,23822.48,0.00,0.00,262.80,172922.40,0.00,0.00,0.00),('1','307','1','91',182,'2','1',20059.10,20521.13,0.00,0.00,462.03,323421.00,0.00,0.00,0.00),('1','307','1','92',183,'1','1',23822.48,24534.48,0.00,0.00,712.00,468496.00,0.00,0.00,0.00),('1','307','1','92',184,'2','1',20521.13,20890.43,0.00,0.00,369.30,258510.00,0.00,0.00,0.00),('1','307','1','93',185,'1','1',24534.48,24534.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','307','1','93',186,'2','1',20890.43,20924.86,0.00,0.00,34.43,24101.00,0.00,0.00,0.00),('1','307','1','94',187,'1','1',24534.48,24534.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','307','1','94',188,'2','1',20924.86,20924.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','307','1','95',189,'1','1',24534.48,24808.48,0.00,0.00,274.00,180292.00,0.00,0.00,0.00),('1','307','1','95',190,'2','1',20924.86,21197.08,0.00,0.00,272.22,209954.00,0.00,0.00,0.00),('1','307','1','96',191,'1','1',24808.48,25242.84,0.00,0.00,434.36,285868.94,0.00,0.00,0.00),('1','307','1','96',192,'2','1',21197.08,21590.87,0.00,0.00,393.79,275653.00,0.00,0.00,0.00),('1','307','1','97',193,'1','1',25242.84,25790.34,0.00,0.00,547.50,360255.00,0.00,0.00,0.00),('1','307','1','97',194,'2','1',21590.87,21931.30,0.00,0.00,340.43,238301.00,0.00,0.00,0.00),('1','307','1','98',195,'1','1',25790.34,26092.84,0.00,0.00,302.50,199045.00,0.00,0.00,0.00),('1','307','1','98',196,'2','1',21931.30,22364.50,0.00,0.00,433.20,303240.00,0.00,0.00,0.00),('1','307','1','99',197,'1','1',26092.84,26717.84,0.00,0.00,625.00,406250.00,0.00,0.00,0.00),('1','307','1','99',198,'2','1',22364.50,23172.39,0.00,0.00,807.89,565523.00,0.00,0.00,0.00),('1','307','1','100',199,'1','1',26717.84,27114.88,0.00,0.00,397.04,258252.32,0.00,0.00,0.00),('1','307','1','100',200,'2','1',23172.39,23717.75,0.00,0.00,545.36,381752.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','307','1','1',664.00,770.00,0.00,30.41,20192.24,23415.70,3223.46,1),('1','307','2','1',664.00,770.00,0.00,253.19,168118.16,187674.10,19555.94,2),('1','307','3','1',664.00,770.00,0.00,101.99,67721.36,78532.30,10810.94,3),('1','307','4','1',664.00,770.00,0.00,90.61,60165.04,69769.70,9604.66,4),('1','307','5','1',664.00,770.00,0.00,140.18,93079.52,104821.60,11742.08,5),('1','307','6','1',664.00,770.00,0.00,124.97,82980.08,93236.50,10256.42,6),('1','307','7','1',664.00,770.00,0.00,108.07,71758.48,83213.90,11455.42,7),('1','307','8','1',664.00,770.00,0.00,261.11,173377.04,198064.90,24687.86,8),('1','307','9','1',664.00,770.00,0.00,486.45,323002.80,353550.90,30548.10,9),('1','307','10','1',664.00,770.00,0.00,544.99,361873.36,397682.30,35808.94,10),('1','307','11','1',664.00,770.00,0.00,352.32,233940.48,259286.40,25345.92,11),('1','307','12','1',664.00,770.00,0.00,305.32,202732.48,223096.40,20363.92,12),('1','307','13','1',664.00,770.00,0.00,718.99,477409.36,520622.30,43212.94,13),('1','307','14','1',664.00,770.00,0.00,244.88,162600.32,182557.60,19957.28,14),('1','307','15','1',664.00,770.00,0.00,190.13,126246.32,143400.10,17153.78,15),('1','307','16','1',664.00,770.00,0.00,333.21,221251.44,246131.70,24880.26,16),('1','307','17','1',664.00,770.00,0.00,230.08,152773.12,177161.60,24388.48,17),('1','307','18','1',664.00,770.00,0.00,290.51,192898.64,214692.70,21794.06,18),('1','307','19','1',664.00,770.00,0.00,287.91,191172.24,209690.70,18518.46,19),('1','307','20','1',664.00,770.00,0.00,121.99,81001.36,93932.30,12930.94,20),('1','307','21','1',664.00,770.00,0.00,0.00,0.00,0.00,0.00,21),('1','307','22','1',664.00,770.00,0.00,131.45,87282.80,98216.50,10933.70,22),('1','307','23','1',664.00,760.00,0.00,292.56,194259.84,215595.60,21335.76,23),('1','307','24','1',664.00,760.00,0.00,365.51,242698.64,269037.60,26338.96,24),('1','307','25','1',664.00,760.00,0.00,474.29,314928.56,350460.40,35531.84,25),('1','307','26','1',664.00,760.00,0.00,400.21,265739.44,299159.60,33420.16,26),('1','307','27','1',664.00,760.00,0.00,190.11,126233.04,138233.60,12000.56,27),('1','307','28','1',664.00,740.00,0.00,215.37,143005.68,156373.80,13368.12,28),('1','307','29','1',664.00,740.00,0.00,351.82,233608.48,256596.80,22988.32,29),('1','307','30','1',664.00,740.00,0.00,275.19,182726.16,203640.60,20914.44,30),('1','307','31','1',664.00,740.00,0.00,403.61,267997.04,294921.40,26924.36,31),('1','307','32','1',664.00,740.00,0.00,257.61,171053.04,187948.50,16895.46,32),('1','307','33','1',664.00,740.00,0.00,587.66,390206.24,428118.40,37912.16,33),('1','307','34','1',664.00,740.00,0.00,763.77,507143.28,547189.80,40046.52,34),('1','307','35','1',664.00,740.00,0.00,527.02,349941.28,376994.80,27053.52,35),('1','307','36','1',664.00,740.00,0.00,0.00,0.00,0.00,0.00,36),('1','307','37','1',664.00,740.00,0.00,211.99,133553.70,150872.60,17318.90,37),('1','307','38','1',630.00,740.00,0.00,620.56,390952.80,439214.40,48261.60,38),('1','307','39','1',630.00,740.00,0.00,638.73,402399.90,455660.20,53260.30,39),('1','307','40','1',630.00,740.00,0.00,511.96,322534.80,370250.40,47715.60,40),('1','307','41','1',630.00,740.00,0.00,495.22,311988.60,355320.00,43331.40,41),('1','307','42','1',630.00,740.00,0.00,360.95,227398.50,262183.00,34784.50,42),('1','307','43','1',630.00,740.00,0.00,603.18,380003.40,431353.20,51349.80,43),('1','307','44','1',630.00,740.00,0.00,356.88,224834.40,258091.20,33256.80,44),('1','307','45','1',630.00,740.00,0.00,480.20,302526.00,341548.00,39022.00,45),('1','307','46','1',630.00,740.00,0.00,647.46,407899.80,462120.40,54220.60,46),('1','307','47','1',630.00,740.00,0.00,0.00,0.00,0.00,0.00,47),('1','307','48','1',630.00,740.00,0.00,382.32,240861.60,276002.40,35140.80,48),('1','307','49','1',630.00,740.00,0.00,699.78,440861.40,498837.20,57975.80,49),('1','307','50','1',630.00,740.00,0.00,417.33,262917.90,302824.20,39906.30,50),('1','307','51','1',630.00,740.00,0.00,597.81,376620.30,433379.40,56759.10,51),('1','307','52','1',630.00,740.00,0.00,628.54,395980.20,453070.40,57090.20,52),('1','307','53','1',630.00,740.00,0.00,344.70,217161.00,248478.00,31317.00,53),('1','307','54','1',630.00,740.00,0.00,594.64,374623.20,430250.80,55627.60,54),('1','307','55','1',630.00,740.00,0.00,1020.17,642707.10,716173.00,73465.90,55),('1','307','56','1',630.00,740.00,0.00,596.14,375568.20,424643.60,49075.40,56),('1','307','57','1',630.00,740.00,0.00,100.87,63548.10,72515.60,8967.50,57),('1','307','58','1',630.00,740.00,0.00,503.71,317337.30,360293.60,42956.30,58),('1','307','59','1',630.00,740.00,0.00,1061.03,668448.90,746492.20,78043.30,59),('1','307','60','1',630.00,740.00,0.00,1426.77,898865.10,990087.00,91221.90,60),('1','307','61','1',630.00,740.00,0.00,958.57,603899.10,669591.80,65692.70,61),('1','307','62','1',630.00,740.00,0.00,462.44,291337.20,333205.60,41868.40,62),('1','307','63','1',630.00,740.00,0.00,647.36,407836.80,453216.96,45380.16,63),('1','307','64','1',630.00,736.00,0.00,167.67,105632.10,119748.88,14116.78,64),('1','307','65','1',630.00,736.00,0.00,0.00,0.00,0.00,0.00,65),('1','307','66','1',630.00,736.00,0.00,237.02,149322.60,170946.72,21624.12,66),('1','307','67','1',630.00,736.00,0.00,491.18,309443.40,350532.48,41089.08,67),('1','307','68','1',630.00,736.00,0.00,885.89,558110.70,625975.04,67864.34,68),('1','307','69','1',630.00,736.00,0.00,1094.95,689818.50,766963.20,77144.70,69),('1','307','70','1',630.00,736.00,0.00,835.90,526617.00,591674.40,65057.40,70),('1','307','71','1',630.00,736.00,0.00,712.51,448881.30,506207.36,57326.06,71),('1','307','72','1',630.00,736.00,0.00,783.03,493308.90,555241.20,61932.30,72),('1','307','73','1',630.00,736.00,0.00,0.00,0.00,0.00,0.00,73),('1','307','74','1',630.00,736.00,0.00,1180.97,744011.10,837553.92,93542.82,74),('1','307','75','1',630.00,736.00,0.00,1295.84,816379.20,901490.24,85111.04,75),('1','307','76','1',630.00,736.00,0.00,937.20,590436.00,654830.72,64394.72,76),('1','307','77','1',630.00,736.00,0.00,565.63,356346.90,404074.40,47727.50,77),('1','307','78','1',630.00,736.00,0.00,582.26,366823.80,411476.24,44652.44,78),('1','307','79','1',630.00,736.00,0.00,467.67,294632.10,331409.12,36777.02,79),('1','307','80','1',630.00,736.00,0.00,796.00,501480.00,557856.00,56376.00,80),('1','307','81','1',630.00,736.00,0.00,895.19,563969.70,628718.40,64748.70,81),('1','307','82','1',630.00,736.00,0.00,1089.44,686347.20,765091.84,78744.64,82),('1','307','83','1',630.00,736.00,0.00,394.21,248352.30,282046.56,33694.26,83),('1','307','84','1',630.00,736.00,0.00,635.58,400415.40,447486.88,47071.48,84),('1','307','85','1',630.00,736.00,0.00,693.29,436772.70,481299.92,44527.22,85),('1','307','86','1',630.00,736.00,0.00,0.00,0.00,0.00,0.00,86),('1','307','87','1',624.00,700.00,0.00,271.37,169334.88,185936.96,16602.08,87),('1','307','88','1',624.00,700.00,0.00,769.77,480336.48,518973.00,38636.52,88),('1','307','89','1',624.00,700.00,0.00,909.51,567534.24,614627.58,47093.34,89),('1','307','90','1',624.00,700.00,0.00,1103.90,688833.60,750925.28,62091.68,90),('1','307','91','1',624.00,700.00,0.00,724.83,452293.92,496343.40,44049.48,91),('1','307','92','1',624.00,700.00,0.00,1081.30,674731.20,727006.00,52274.80,92),('1','307','93','1',624.00,700.00,0.00,34.43,21484.32,24101.00,2616.68,93),('1','307','94','1',624.00,700.00,0.00,0.00,0.00,0.00,0.00,94),('1','307','95','1',624.00,700.00,0.00,546.22,340841.28,390246.00,49404.72,95),('1','307','96','1',624.00,700.00,0.00,828.15,516765.60,561521.94,44756.34,96),('1','307','97','1',624.00,700.00,0.00,887.93,554068.32,598556.00,44487.68,97),('1','307','98','1',624.00,700.00,0.00,735.70,459076.80,502285.00,43208.20,98),('1','307','99','1',624.00,700.00,0.00,1432.89,894123.36,971773.00,77649.64,99),('1','307','100','1',624.00,700.00,0.00,942.40,588057.60,640004.32,51946.72,100);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'307','LPG TANK ','LPG PRODUCT TANKS.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','307','1',1,1,'1','LPG TANK ',6000.00,0.00,NULL,'LPG PRODUCT TANK.','479','2022-12-22 01:49:29','2022-12-22 01:49:29','479',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','307',1,4886.71,'2023-03-20 19:49:06');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=4526 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,3539120.00,5330.00,0.00,0.00,'2022-12-23 12:07:01','',''),(2,'1','307',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,5330.00,0.00,'2022-12-23 12:08:26','',''),(3,'1','307','1',1,'Received from bridging 1',0.00,0.00,5330.00,0.00,0.00,'2022-12-23 12:08:26','',''),(4,'1','307','1',1,'Retail Sale Id 1',770.00,0.00,0.00,1.00,106.00,'2022-12-23 12:11:11','',''),(5,'1','307','1',1,'Retail Sale Id 2',2348.50,0.00,0.00,3.05,323.30,'2022-12-24 11:14:27','',''),(6,'1','307','1',1,'Retail Sale Id 3',5998.30,0.00,0.00,7.79,825.74,'2022-12-24 11:18:40','',''),(7,'1','307','1',1,'Retail Sale Id 5',9001.30,0.00,0.00,11.69,1239.14,'2022-12-24 11:24:13','',''),(8,'1','307','1',1,'Return of Retail Sale Id 5',0.00,9001.30,11.69,0.00,-1239.14,'2022-12-24 11:31:52','',''),(9,'1','307','1',1,'Return of Retail Sale Id 2',0.00,2348.50,3.05,0.00,-323.30,'2022-12-24 11:32:58','',''),(10,'1','307','1',1,'Retail Sale Id 6',2348.50,0.00,0.00,3.05,323.30,'2022-12-24 11:37:09','',''),(11,'1','307','1',1,'Retail Sale Id 7',9648.10,0.00,0.00,12.53,1328.18,'2022-12-24 11:53:06','',''),(12,'1','307','1',1,'Retail Sale Id 8',4650.80,0.00,0.00,6.04,640.24,'2022-12-24 11:54:39','',''),(13,'1','307','1',1,'Retail Sale Id 9',35500.00,0.00,0.00,50.00,2300.00,'2022-12-24 16:01:17','',''),(14,'1','307','1',1,'Retail Sale Id 10',35500.00,0.00,0.00,50.00,2300.00,'2022-12-24 16:53:30','',''),(15,'1','307','1',1,'Return of Retail Sale Id 10',0.00,35500.00,50.00,0.00,-2300.00,'2022-12-24 17:13:04','',''),(16,'1','307','1',1,'Retail Sale Id 11',30501.60,0.00,0.00,42.96,1976.16,'2022-12-24 17:13:53','',''),(17,'1','307','1',1,'Retail Sale Id 12',4620.00,0.00,0.00,6.00,636.00,'2022-12-24 17:34:25','',''),(18,'1','307','1',1,'Retail Sale Id 13',68799.50,0.00,0.00,89.35,9471.10,'2022-12-24 17:36:27','',''),(19,'1','307','1',1,'Return of Retail Sale Id 12',0.00,4620.00,6.00,0.00,-636.00,'2022-12-24 17:38:58','',''),(20,'1','307','1',1,'Retail Sale Id 14',4519.90,0.00,0.00,5.87,622.22,'2022-12-24 17:40:08','',''),(21,'1','307','1',1,'Return of Retail Sale Id 13',0.00,68799.50,89.35,0.00,-9471.10,'2022-12-24 17:41:35','',''),(22,'1','307','1',1,'Retail Sale Id 15',68799.50,0.00,0.00,89.35,9471.10,'2022-12-24 17:42:16','',''),(23,'1','307','1',1,'Retail Sale Id 16',28182.00,0.00,0.00,36.60,3879.60,'2022-12-24 19:16:04','',''),(24,'1','307','1',1,'Retail Sale Id 17',20171.10,0.00,0.00,28.41,1306.86,'2022-12-24 19:20:20','',''),(25,'1','307','1',1,'Retail Sale Id 18',2502.50,0.00,0.00,3.25,344.50,'2022-12-25 07:30:07','',''),(26,'1','307','1',1,'Retail Sale Id 19',35500.00,0.00,0.00,50.00,2300.00,'2022-12-25 07:37:27','',''),(27,'1','307','1',1,'Return of Retail Sale Id 19',0.00,35500.00,50.00,0.00,-2300.00,'2022-12-25 07:38:34','',''),(28,'1','307','1',1,'Retail Sale Id 20',3850.00,0.00,0.00,5.00,530.00,'2022-12-25 07:49:02','',''),(29,'1','307','1',1,'Retail Sale Id 21',2002.00,0.00,0.00,2.60,275.60,'2022-12-25 07:51:36','',''),(30,'1','307','1',1,'Retail Sale Id 22',4650.80,0.00,0.00,6.04,640.24,'2022-12-25 08:00:12','',''),(31,'1','307','1',1,'Retail Sale Id 23',2348.50,0.00,0.00,3.05,323.30,'2022-12-25 08:02:05','',''),(32,'1','307','1',1,'Retail Sale Id 24',4650.80,0.00,0.00,6.04,640.24,'2022-12-25 08:53:31','',''),(33,'1','307','1',1,'Retail Sale Id 25',1501.50,0.00,0.00,1.95,206.70,'2022-12-25 09:11:12','',''),(34,'1','307','1',1,'Retail Sale Id 26',4650.80,0.00,0.00,6.04,640.24,'2022-12-25 10:47:08','',''),(35,'1','307','1',1,'Retail Sale Id 27',1547.70,0.00,0.00,2.01,213.06,'2022-12-25 10:50:08','',''),(36,'1','307','1',1,'Retail Sale Id 28',9648.10,0.00,0.00,12.53,1328.18,'2022-12-25 10:52:00','',''),(37,'1','307','1',1,'Retail Sale Id 29',4620.00,0.00,0.00,6.00,636.00,'2022-12-25 11:08:22','',''),(38,'1','307','1',1,'Retail Sale Id 30',4650.80,0.00,0.00,6.04,640.24,'2022-12-25 11:38:08','',''),(39,'1','307','1',1,'Retail Sale Id 31',9702.00,0.00,0.00,12.60,1335.60,'2022-12-25 12:05:54','',''),(40,'1','307','1',1,'Retail Sale Id 32',2402.40,0.00,0.00,3.12,330.72,'2022-12-25 13:59:11','',''),(41,'1','307','1',1,'Retail Sale Id 33',2402.40,0.00,0.00,3.12,330.72,'2022-12-25 14:41:06','',''),(42,'1','307','1',1,'Retail Sale Id 34',3103.10,0.00,0.00,4.03,427.18,'2022-12-25 15:46:09','',''),(43,'1','307','1',1,'Retail Sale Id 35',4650.80,0.00,0.00,6.04,640.24,'2022-12-25 17:53:01','',''),(44,'1','307','1',1,'Retail Sale Id 36',9648.10,0.00,0.00,12.53,1328.18,'2022-12-25 18:24:28','',''),(45,'1','307','1',1,'Retail Sale Id 40',9648.10,0.00,0.00,12.53,1328.18,'2022-12-26 08:03:43','',''),(46,'1','307','1',1,'Retail Sale Id 41',770.00,0.00,0.00,1.00,106.00,'2022-12-26 08:34:11','',''),(47,'1','307','1',1,'Retail Sale Id 42',4620.00,0.00,0.00,6.00,636.00,'2022-12-26 09:03:49','',''),(48,'1','307','1',1,'Retail Sale Id 43',4620.00,0.00,0.00,6.00,636.00,'2022-12-26 09:36:14','',''),(49,'1','307','1',1,'Retail Sale Id 45',2310.00,0.00,0.00,3.00,318.00,'2022-12-26 09:39:16','',''),(50,'1','307','1',1,'Retail Sale Id 48',2348.50,0.00,0.00,3.05,323.30,'2022-12-26 09:43:07','',''),(51,'1','307','1',1,'Retail Sale Id 49',1547.70,0.00,0.00,2.01,213.06,'2022-12-26 12:04:46','',''),(52,'1','307','1',1,'Retail Sale Id 50',3850.00,0.00,0.00,5.00,530.00,'2022-12-26 12:58:05','',''),(53,'1','307','1',1,'Retail Sale Id 51',3103.10,0.00,0.00,4.03,427.18,'2022-12-26 13:25:07','',''),(54,'1','307','1',1,'Retail Sale Id 52',9648.10,0.00,0.00,12.53,1328.18,'2022-12-26 14:36:44','',''),(55,'1','307','1',1,'Retail Sale Id 54',8500.80,0.00,0.00,11.04,1170.24,'2022-12-26 15:47:52','',''),(56,'1','307','1',1,'Retail Sale Id 55',4650.80,0.00,0.00,6.04,640.24,'2022-12-26 15:50:37','',''),(57,'1','307','1',1,'Retail Sale Id 56',4650.80,0.00,0.00,6.04,640.24,'2022-12-26 16:54:25','',''),(58,'1','307','1',1,'Retail Sale Id 57',9501.80,0.00,0.00,12.34,1308.04,'2022-12-26 18:14:06','',''),(59,'1','307','1',1,'Return of Retail Sale Id 51',0.00,3103.10,4.03,0.00,-427.18,'2022-12-26 18:54:52','',''),(60,'1','307','1',1,'Retail Sale Id 58',3103.10,0.00,0.00,4.03,427.18,'2022-12-26 18:58:33','',''),(61,'1','307','1',1,'Return of Retail Sale Id 57',0.00,9501.80,12.34,0.00,-1308.04,'2022-12-26 19:18:20','',''),(62,'1','307','1',1,'Retail Sale Id 59',9501.80,0.00,0.00,12.34,1308.04,'2022-12-26 19:19:32','',''),(63,'1','307','1',1,'Retail Sale Id 60',2317.70,0.00,0.00,3.01,319.06,'2022-12-27 07:47:48','',''),(64,'1','307','1',1,'Retail Sale Id 61',1547.70,0.00,0.00,2.01,213.06,'2022-12-27 08:29:38','',''),(65,'1','307','1',1,'Retail Sale Id 63',7700.00,0.00,0.00,10.00,1060.00,'2022-12-27 09:27:53','',''),(66,'1','307','1',1,'Retail Sale Id 64',4697.00,0.00,0.00,6.10,646.60,'2022-12-27 09:41:11','',''),(67,'1','307','1',1,'Retail Sale Id 65',2317.70,0.00,0.00,3.01,319.06,'2022-12-27 09:46:01','',''),(68,'1','307','1',1,'Retail Sale Id 66',35500.00,0.00,0.00,50.00,2300.00,'2022-12-27 10:16:43','',''),(69,'1','307','1',1,'Retail Sale Id 67',4620.00,0.00,0.00,6.00,636.00,'2022-12-27 10:24:15','',''),(70,'1','307','1',1,'Return of Retail Sale Id 67',0.00,4620.00,6.00,0.00,-636.00,'2022-12-27 10:25:36','',''),(71,'1','307','1',1,'Retail Sale Id 68',4620.00,0.00,0.00,6.00,636.00,'2022-12-27 10:26:18','',''),(72,'1','307','1',1,'Retail Sale Id 69',4620.00,0.00,0.00,6.00,636.00,'2022-12-27 12:25:20','',''),(73,'1','307','1',1,'Retail Sale Id 70',2002.00,0.00,0.00,2.60,275.60,'2022-12-27 12:43:13','',''),(74,'1','307','1',1,'Retail Sale Id 71',2348.50,0.00,0.00,3.05,323.30,'2022-12-27 12:52:00','',''),(75,'1','307','1',1,'Retail Sale Id 72',2602.60,0.00,0.00,3.38,358.28,'2022-12-27 13:09:38','',''),(76,'1','307','1',1,'Retail Sale Id 73',2348.50,0.00,0.00,3.05,323.30,'2022-12-27 13:20:23','',''),(77,'1','307','1',1,'Retail Sale Id 74',3080.00,0.00,0.00,4.00,424.00,'2022-12-27 14:10:24','',''),(78,'1','307','1',1,'Retail Sale Id 75',3003.00,0.00,0.00,3.90,413.40,'2022-12-27 14:47:08','',''),(79,'1','307','1',1,'Retail Sale Id 76',9648.10,0.00,0.00,12.53,1328.18,'2022-12-27 15:44:17','',''),(80,'1','307','1',1,'Retail Sale Id 77',2348.50,0.00,0.00,3.05,323.30,'2022-12-27 17:19:40','',''),(81,'1','307','1',1,'Retail Sale Id 79',1547.70,0.00,0.00,2.01,213.06,'2022-12-27 17:27:41','',''),(82,'1','307','1',1,'Retail Sale Id 80',1547.70,0.00,0.00,2.01,213.06,'2022-12-27 17:37:54','',''),(83,'1','307','1',1,'Retail Sale Id 81',9648.10,0.00,0.00,12.53,1328.18,'2022-12-27 18:16:33','',''),(84,'1','307','1',1,'Retail Sale Id 82',1384.50,0.00,0.00,1.95,89.70,'2022-12-27 18:31:00','',''),(85,'1','307','1',1,'Retail Sale Id 83',7.70,0.00,0.00,0.01,1.06,'2022-12-27 18:49:19','',''),(86,'1','307','1',1,'Return of Retail Sale Id 80',0.00,1547.70,2.01,0.00,-213.06,'2022-12-27 18:52:28','',''),(87,'1','307','1',1,'Retail Sale Id 84',1532.30,0.00,0.00,1.99,210.94,'2022-12-27 18:54:03','',''),(88,'1','307','1',1,'Return of Retail Sale Id 83',0.00,7.70,0.01,0.00,-1.06,'2022-12-27 18:56:46','',''),(89,'1','307','1',1,'Retail Sale Id 85',7.70,0.00,0.00,0.01,1.06,'2022-12-27 19:01:55','',''),(90,'1','307','1',1,'Retail Sale Id 86',3996.30,0.00,0.00,5.19,550.14,'2022-12-28 08:02:11','',''),(91,'1','307','1',1,'Retail Sale Id 87',2302.30,0.00,0.00,2.99,316.94,'2022-12-28 08:02:54','',''),(92,'1','307','1',1,'Retail Sale Id 88',1001.00,0.00,0.00,1.30,137.80,'2022-12-28 08:07:42','',''),(93,'1','307','1',1,'Retail Sale Id 89',4650.80,0.00,0.00,6.04,640.24,'2022-12-28 08:36:35','',''),(94,'1','307','1',1,'Retail Sale Id 90',2317.70,0.00,0.00,3.01,319.06,'2022-12-28 09:00:43','',''),(95,'1','307','1',1,'Retail Sale Id 91',2333.10,0.00,0.00,3.03,321.18,'2022-12-28 09:32:42','',''),(96,'1','307','1',1,'Retail Sale Id 92',3850.00,0.00,0.00,5.00,530.00,'2022-12-28 10:07:12','',''),(97,'1','307','1',1,'Retail Sale Id 94',4650.80,0.00,0.00,6.04,640.24,'2022-12-28 10:56:40','',''),(98,'1','307','1',1,'Retail Sale Id 95',4650.80,0.00,0.00,6.04,640.24,'2022-12-28 14:29:04','',''),(99,'1','307','1',1,'Retail Sale Id 96',4650.80,0.00,0.00,6.04,640.24,'2022-12-28 16:16:44','',''),(100,'1','307','1',1,'Retail Sale Id 97',3103.10,0.00,0.00,4.03,427.18,'2022-12-28 16:19:35','',''),(101,'1','307','1',1,'Retail Sale Id 98',2002.00,0.00,0.00,2.60,275.60,'2022-12-28 16:27:34','',''),(102,'1','307','1',1,'Retail Sale Id 99',1647.80,0.00,0.00,2.14,226.84,'2022-12-28 16:29:17','',''),(103,'1','307','1',1,'Retail Sale Id 100',9648.10,0.00,0.00,12.53,1328.18,'2022-12-28 16:31:08','',''),(104,'1','307','1',1,'Retail Sale Id 101',1501.50,0.00,0.00,1.95,206.70,'2022-12-28 16:44:55','',''),(105,'1','307','1',1,'Retail Sale Id 102',1547.70,0.00,0.00,2.01,213.06,'2022-12-28 17:16:26','',''),(106,'1','307','1',1,'Retail Sale Id 103',35500.00,0.00,0.00,50.00,2300.00,'2022-12-28 18:22:51','',''),(107,'1','307','1',1,'Retail Sale Id 104',3996.30,0.00,0.00,5.19,550.14,'2022-12-28 18:26:16','',''),(108,'1','307','1',1,'Return of Retail Sale Id 103',0.00,35500.00,50.00,0.00,-2300.00,'2022-12-28 18:44:05','',''),(109,'1','307','1',1,'Retail Sale Id 105',35386.40,0.00,0.00,49.84,2292.64,'2022-12-28 18:46:17','',''),(110,'1','307','1',1,'Retail Sale Id 107',7700.00,0.00,0.00,10.00,1060.00,'2022-12-29 07:35:45','',''),(111,'1','307','1',1,'Retail Sale Id 108',9650.00,0.00,0.00,1.00,8986.00,'2022-12-29 08:20:01','',''),(112,'1','307','1',1,'Retail Sale Id 109',9648.10,0.00,0.00,12.53,1328.18,'2022-12-29 08:24:01','',''),(113,'1','307','1',1,'Return of Retail Sale Id 108',0.00,9650.00,1.00,0.00,-8986.00,'2022-12-29 08:27:26','',''),(114,'1','307','1',1,'Retail Sale Id 110',2502.50,0.00,0.00,3.25,344.50,'2022-12-29 10:13:23','',''),(115,'1','307','1',1,'Retail Sale Id 111',19296.20,0.00,0.00,25.06,2656.36,'2022-12-29 10:20:22','',''),(116,'1','307','1',1,'Retail Sale Id 112',3087.70,0.00,0.00,4.01,425.06,'2022-12-29 10:24:55','',''),(117,'1','307','1',1,'Retail Sale Id 113',2002.00,0.00,0.00,2.60,275.60,'2022-12-29 10:40:45','',''),(118,'1','307','1',1,'Retail Sale Id 114',4650.80,0.00,0.00,6.04,640.24,'2022-12-29 10:46:36','',''),(119,'1','307','1',1,'Retail Sale Id 115',2325.40,0.00,0.00,3.02,320.12,'2022-12-29 10:49:03','',''),(120,'1','307','1',1,'Retail Sale Id 116',2325.40,0.00,0.00,3.02,320.12,'2022-12-29 10:50:20','',''),(121,'1','307','1',1,'Retail Sale Id 117',4650.80,0.00,0.00,6.04,640.24,'2022-12-29 14:27:34','',''),(122,'1','307','1',1,'Retail Sale Id 118',2348.50,0.00,0.00,3.05,323.30,'2022-12-29 15:25:34','',''),(123,'1','307','1',1,'Retail Sale Id 119',2348.50,0.00,0.00,3.05,323.30,'2022-12-29 16:22:26','',''),(124,'1','307','1',1,'Retail Sale Id 120',3080.00,0.00,0.00,4.00,424.00,'2022-12-29 16:42:17','',''),(125,'1','307','1',1,'Retail Sale Id 121',2002.00,0.00,0.00,2.60,275.60,'2022-12-29 17:15:36','',''),(126,'1','307','1',1,'Retail Sale Id 122',2348.50,0.00,0.00,3.05,323.30,'2022-12-29 17:17:14','',''),(127,'1','307','1',1,'Retail Sale Id 123',2502.50,0.00,0.00,3.25,344.50,'2022-12-29 17:19:44','',''),(128,'1','307','1',1,'Retail Sale Id 124',5998.30,0.00,0.00,7.79,825.74,'2022-12-29 18:43:58','',''),(129,'1','307','1',1,'Retail Sale Id 125',4650.80,0.00,0.00,6.04,640.24,'2022-12-29 18:47:53','',''),(130,'1','307','1',1,'Return of Retail Sale Id 121',0.00,2002.00,2.60,0.00,-275.60,'2022-12-29 18:57:24','',''),(131,'1','307','1',1,'Retail Sale Id 126',1747.90,0.00,0.00,2.27,240.62,'2022-12-29 19:00:02','',''),(132,'1','307','1',1,'Retail Sale Id 127',2502.50,0.00,0.00,3.25,344.50,'2022-12-30 07:40:40','',''),(133,'1','307','1',1,'Retail Sale Id 128',2348.50,0.00,0.00,3.05,323.30,'2022-12-30 08:01:02','',''),(134,'1','307','1',1,'Retail Sale Id 129',15400.00,0.00,0.00,20.00,2120.00,'2022-12-30 08:28:28','',''),(135,'1','307','1',1,'Retail Sale Id 130',6822.20,0.00,0.00,8.86,939.16,'2022-12-30 08:50:20','',''),(136,'1','307','1',1,'Retail Sale Id 131',4650.80,0.00,0.00,6.04,640.24,'2022-12-30 09:04:24','',''),(137,'1','307','1',1,'Retail Sale Id 132',2348.50,0.00,0.00,3.05,323.30,'2022-12-30 09:14:41','',''),(138,'1','307','1',1,'Retail Sale Id 133',4496.80,0.00,0.00,5.84,619.04,'2022-12-30 09:47:47','',''),(139,'1','307','1',1,'Retail Sale Id 134',4650.80,0.00,0.00,6.04,640.24,'2022-12-30 10:05:21','',''),(140,'1','307','1',1,'Retail Sale Id 135',2348.50,0.00,0.00,3.05,323.30,'2022-12-30 10:07:00','',''),(141,'1','307','1',1,'Retail Sale Id 136',1801.80,0.00,0.00,2.34,248.04,'2022-12-30 10:44:12','',''),(142,'1','307','1',1,'Retail Sale Id 137',4650.80,0.00,0.00,6.04,640.24,'2022-12-30 10:48:22','',''),(143,'1','307','1',1,'Retail Sale Id 138',2310.00,0.00,0.00,3.00,318.00,'2022-12-30 11:58:46','',''),(144,'1','307','1',1,'Retail Sale Id 139',4650.80,0.00,0.00,6.04,640.24,'2022-12-30 12:40:25','',''),(145,'1','307','1',1,'Retail Sale Id 140',9648.10,0.00,0.00,12.53,1328.18,'2022-12-30 12:43:42','',''),(146,'1','307','1',1,'Retail Sale Id 141',3080.00,0.00,0.00,4.00,424.00,'2022-12-30 13:40:58','',''),(147,'1','307','1',1,'Retail Sale Id 142',3080.00,0.00,0.00,4.00,424.00,'2022-12-30 13:42:18','',''),(148,'1','307','1',1,'Retail Sale Id 143',2310.00,0.00,0.00,3.00,318.00,'2022-12-30 13:59:14','',''),(149,'1','307','1',1,'Retail Sale Id 144',5390.00,0.00,0.00,7.00,742.00,'2022-12-30 14:00:46','',''),(150,'1','307','1',1,'Retail Sale Id 145',1501.50,0.00,0.00,1.95,206.70,'2022-12-30 14:24:51','',''),(151,'1','307','1',1,'Retail Sale Id 147',3850.00,0.00,0.00,5.00,530.00,'2022-12-30 15:05:47','',''),(152,'1','307','1',1,'Retail Sale Id 148',9648.10,0.00,0.00,12.53,1328.18,'2022-12-30 15:41:25','',''),(153,'1','307','1',1,'Retail Sale Id 149',7700.00,0.00,0.00,10.00,1060.00,'2022-12-30 15:47:09','',''),(154,'1','307','1',1,'Retail Sale Id 150',35500.00,0.00,0.00,50.00,2300.00,'2022-12-30 15:49:56','',''),(155,'1','307','1',1,'Retail Sale Id 151',9648.10,0.00,0.00,12.53,1328.18,'2022-12-30 16:15:10','',''),(156,'1','307','1',1,'Retail Sale Id 152',2310.00,0.00,0.00,3.00,318.00,'2022-12-30 16:22:49','',''),(157,'1','307','1',1,'Retail Sale Id 153',2002.00,0.00,0.00,2.60,275.60,'2022-12-30 16:29:14','',''),(158,'1','307','1',1,'Retail Sale Id 154',2002.00,0.00,0.00,2.60,275.60,'2022-12-30 16:38:48','',''),(159,'1','307','1',1,'Retail Sale Id 155',4650.80,0.00,0.00,6.04,640.24,'2022-12-30 17:20:20','',''),(160,'1','307','1',1,'Retail Sale Id 156',4650.80,0.00,0.00,6.04,640.24,'2022-12-30 17:21:59','',''),(161,'1','307','1',1,'Retail Sale Id 157',10010.00,0.00,0.00,13.00,1378.00,'2022-12-30 17:43:22','',''),(162,'1','307','1',1,'Retail Sale Id 158',3850.00,0.00,0.00,5.00,530.00,'2022-12-30 17:45:23','',''),(163,'1','307','1',1,'Retail Sale Id 159',4620.00,0.00,0.00,6.00,636.00,'2022-12-30 17:54:12','',''),(164,'1','307','1',1,'Retail Sale Id 161',9648.10,0.00,0.00,12.53,1328.18,'2022-12-30 18:21:29','',''),(165,'1','307','1',1,'Retail Sale Id 162',3003.00,0.00,0.00,3.90,413.40,'2022-12-30 18:48:15','',''),(166,'1','307','1',1,'Return of Retail Sale Id 150',0.00,35500.00,50.00,0.00,-2300.00,'2022-12-30 18:57:40','',''),(167,'1','307','1',1,'Retail Sale Id 163',35379.30,0.00,0.00,49.83,2292.18,'2022-12-30 19:00:02','',''),(168,'1','307','1',1,'Retail Sale Id 164',1101.10,0.00,0.00,1.43,151.58,'2022-12-30 19:03:13','',''),(169,'1','307','1',1,'Retail Sale Id 166',35500.00,0.00,0.00,50.00,2300.00,'2022-12-31 08:02:03','',''),(170,'1','307','1',1,'Retail Sale Id 167',3996.30,0.00,0.00,5.19,550.14,'2022-12-31 08:36:41','',''),(171,'1','307','1',1,'Retail Sale Id 168',9247.70,0.00,0.00,12.01,1273.06,'2022-12-31 09:48:25','',''),(172,'1','307','1',1,'Retail Sale Id 169',35500.00,0.00,0.00,50.00,2300.00,'2022-12-31 09:52:03','',''),(173,'1','307','1',1,'Retail Sale Id 170',2310.00,0.00,0.00,3.00,318.00,'2022-12-31 10:09:07','',''),(174,'1','307','1',1,'Retail Sale Id 170',2310.00,0.00,0.00,3.00,318.00,'2022-12-31 10:09:07','',''),(175,'1','307','1',1,'Retail Sale Id 171',35365.10,0.00,0.00,49.81,2291.26,'2022-12-31 10:31:53','',''),(176,'1','307','1',1,'Retail Sale Id 172',2202.20,0.00,0.00,2.86,303.16,'2022-12-31 11:21:30','',''),(177,'1','307','1',1,'Retail Sale Id 173',6160.00,0.00,0.00,8.00,848.00,'2022-12-31 11:23:25','',''),(178,'1','307','1',1,'Retail Sale Id 174',3850.00,0.00,0.00,5.00,530.00,'2022-12-31 12:15:28','',''),(179,'1','307','1',1,'Retail Sale Id 175',9648.10,0.00,0.00,12.53,1328.18,'2022-12-31 12:19:30','',''),(180,'1','307','1',1,'Retail Sale Id 176',35500.00,0.00,0.00,50.00,2300.00,'2022-12-31 12:54:28','',''),(181,'1','307','1',1,'Retail Sale Id 177',35500.00,0.00,0.00,50.00,2300.00,'2022-12-31 12:55:39','',''),(182,'1','307','1',1,'Retail Sale Id 178',35500.00,0.00,0.00,50.00,2300.00,'2022-12-31 13:12:15','',''),(183,'1','307','1',1,'Retail Sale Id 179',4650.80,0.00,0.00,6.04,640.24,'2022-12-31 13:14:00','',''),(184,'1','307','1',1,'Retail Sale Id 180',4650.80,0.00,0.00,6.04,640.24,'2022-12-31 15:12:04','',''),(185,'1','307','1',1,'Retail Sale Id 182',3080.00,0.00,0.00,4.00,424.00,'2022-12-31 15:19:01','',''),(186,'1','307','1',1,'Retail Sale Id 183',2348.50,0.00,0.00,3.05,323.30,'2022-12-31 15:30:33','',''),(187,'1','307','1',1,'Retail Sale Id 184',4650.80,0.00,0.00,6.04,640.24,'2022-12-31 15:49:35','',''),(188,'1','307','1',1,'Retail Sale Id 185',9648.10,0.00,0.00,12.53,1328.18,'2022-12-31 16:18:18','',''),(189,'1','307','1',1,'Retail Sale Id 186',2002.00,0.00,0.00,2.60,275.60,'2022-12-31 16:26:14','',''),(190,'1','307','1',1,'Retail Sale Id 187',35500.00,0.00,0.00,50.00,2300.00,'2022-12-31 16:35:18','',''),(191,'1','307','1',1,'Retail Sale Id 188',1547.70,0.00,0.00,2.01,213.06,'2022-12-31 16:57:08','',''),(192,'1','307','1',1,'Retail Sale Id 189',2348.50,0.00,0.00,3.05,323.30,'2022-12-31 17:20:47','',''),(193,'1','307','1',1,'Retail Sale Id 190',770.00,0.00,0.00,1.00,106.00,'2022-12-31 17:29:13','',''),(194,'1','307','1',1,'Retail Sale Id 191',4650.80,0.00,0.00,6.04,640.24,'2022-12-31 17:30:35','',''),(195,'1','307','1',1,'Retail Sale Id 192',9648.10,0.00,0.00,12.53,1328.18,'2022-12-31 18:00:19','',''),(196,'1','307','1',1,'Retail Sale Id 193',1547.70,0.00,0.00,2.01,213.06,'2022-12-31 18:06:44','',''),(197,'1','307','1',1,'Retail Sale Id 194',1547.70,0.00,0.00,2.01,213.06,'2022-12-31 18:19:03','',''),(198,'1','307','1',1,'Retail Sale Id 195',2002.00,0.00,0.00,2.60,275.60,'2022-12-31 18:22:14','',''),(199,'1','307','1',1,'Retail Sale Id 196',10048.50,0.00,0.00,13.05,1383.30,'2022-12-31 19:01:06','',''),(200,'1','307','1',1,'Return of Retail Sale Id 187',0.00,35500.00,50.00,0.00,-2300.00,'2022-12-31 19:22:59','',''),(201,'1','307','1',1,'Retail Sale Id 197',35819.50,0.00,0.00,50.45,2320.70,'2022-12-31 19:25:03','',''),(202,'1','307','1',1,'Retail Sale Id 198',11550.00,0.00,0.00,15.00,1590.00,'2023-01-01 08:11:23','',''),(203,'1','307','1',1,'Retail Sale Id 199',1501.50,0.00,0.00,1.95,206.70,'2023-01-01 08:37:12','',''),(204,'1','307','1',1,'Retail Sale Id 200',177500.00,0.00,0.00,250.00,11500.00,'2023-01-01 08:38:28','',''),(205,'1','307','1',1,'Retail Sale Id 201',2348.50,0.00,0.00,3.05,323.30,'2023-01-01 08:39:47','',''),(206,'1','307','1',1,'Retail Sale Id 202',11550.00,0.00,0.00,15.00,1590.00,'2023-01-01 08:43:56','',''),(207,'1','307','1',1,'Retail Sale Id 203',9648.10,0.00,0.00,12.53,1328.18,'2023-01-01 09:18:31','',''),(208,'1','307','1',1,'Retail Sale Id 204',1547.70,0.00,0.00,2.01,213.06,'2023-01-01 09:21:22','',''),(209,'1','307','1',1,'Retail Sale Id 205',4620.00,0.00,0.00,6.00,636.00,'2023-01-01 10:14:19','',''),(210,'1','307','1',1,'Retail Sale Id 206',11360.00,0.00,0.00,16.00,736.00,'2023-01-01 10:16:44','',''),(211,'1','307','1',1,'Retail Sale Id 207',1547.70,0.00,0.00,2.01,213.06,'2023-01-01 10:25:25','',''),(212,'1','307','1',1,'Retail Sale Id 208',4620.00,0.00,0.00,6.00,636.00,'2023-01-01 10:29:01','',''),(213,'1','307','1',1,'Retail Sale Id 208',4627.70,0.00,0.00,6.01,637.06,'2023-01-01 10:29:01','',''),(214,'1','307','1',1,'Retail Sale Id 209',35500.00,0.00,0.00,50.00,2300.00,'2023-01-01 10:34:40','',''),(215,'1','307','1',1,'Retail Sale Id 210',11360.00,0.00,0.00,16.00,736.00,'2023-01-01 10:36:36','',''),(216,'1','307','1',1,'Retail Sale Id 211',5397.70,0.00,0.00,7.01,743.06,'2023-01-01 10:51:53','',''),(217,'1','307','1',1,'Retail Sale Id 212',4650.80,0.00,0.00,6.04,640.24,'2023-01-01 12:19:41','',''),(218,'1','307','1',1,'Retail Sale Id 213',4650.80,0.00,0.00,6.04,640.24,'2023-01-01 12:45:53','',''),(219,'1','307','1',1,'Return of Retail Sale Id 213',0.00,4650.80,6.04,0.00,-640.24,'2023-01-01 12:46:33','',''),(220,'1','307','1',1,'Retail Sale Id 214',4650.80,0.00,0.00,6.04,640.24,'2023-01-01 12:47:12','',''),(221,'1','307','1',1,'Retail Sale Id 215',9648.10,0.00,0.00,12.53,1328.18,'2023-01-01 13:03:44','',''),(222,'1','307','1',1,'Retail Sale Id 216',5390.00,0.00,0.00,7.00,742.00,'2023-01-01 13:19:21','',''),(223,'1','307','1',1,'Retail Sale Id 217',9648.10,0.00,0.00,12.53,1328.18,'2023-01-01 13:58:15','',''),(224,'1','307','1',1,'Retail Sale Id 218',1563.10,0.00,0.00,2.03,215.18,'2023-01-01 14:06:58','',''),(225,'1','307','1',1,'Retail Sale Id 220',2310.00,0.00,0.00,3.00,318.00,'2023-01-01 15:14:45','',''),(226,'1','307','1',1,'Retail Sale Id 221',4997.30,0.00,0.00,6.49,687.94,'2023-01-01 16:10:03','',''),(227,'1','307','1',1,'Retail Sale Id 222',2348.50,0.00,0.00,3.05,323.30,'2023-01-01 16:11:01','',''),(228,'1','307','1',1,'Retail Sale Id 223',770.00,0.00,0.00,1.00,106.00,'2023-01-01 16:13:18','',''),(229,'1','307','1',1,'Retail Sale Id 224',9648.10,0.00,0.00,12.53,1328.18,'2023-01-01 17:12:20','',''),(230,'1','307','1',1,'Retail Sale Id 225',2348.50,0.00,0.00,3.05,323.30,'2023-01-01 17:27:29','',''),(231,'1','307','1',1,'Retail Sale Id 226',4650.80,0.00,0.00,6.04,640.24,'2023-01-01 17:44:07','',''),(232,'1','307','1',1,'Retail Sale Id 228',2348.50,0.00,0.00,3.05,323.30,'2023-01-01 17:59:32','',''),(233,'1','307','1',1,'Retail Sale Id 229',4650.80,0.00,0.00,6.04,640.24,'2023-01-01 18:22:58','',''),(234,'1','307','1',1,'Retail Sale Id 230',24140.00,0.00,0.00,34.00,1564.00,'2023-01-01 18:35:44','',''),(235,'1','307','1',1,'Return of Retail Sale Id 230',0.00,24140.00,34.00,0.00,-1564.00,'2023-01-01 18:36:43','',''),(236,'1','307','1',1,'Retail Sale Id 231',24140.00,0.00,0.00,34.00,1564.00,'2023-01-01 18:38:07','',''),(237,'1','307','1',1,'Retail Sale Id 232',9240.00,0.00,0.00,12.00,1272.00,'2023-01-01 18:42:54','',''),(238,'1','307','1',1,'Retail Sale Id 233',1501.50,0.00,0.00,1.95,206.70,'2023-01-02 08:30:34','',''),(239,'1','307','1',1,'Retail Sale Id 234',3850.00,0.00,0.00,5.00,530.00,'2023-01-02 08:31:57','',''),(240,'1','307','1',1,'Retail Sale Id 235',2348.50,0.00,0.00,3.05,323.30,'2023-01-02 08:54:10','',''),(241,'1','307','1',1,'Retail Sale Id 236',1001.00,0.00,0.00,1.30,137.80,'2023-01-02 08:57:32','',''),(242,'1','307','1',1,'Retail Sale Id 237',8500.80,0.00,0.00,11.04,1170.24,'2023-01-02 09:02:19','',''),(243,'1','307','1',1,'Retail Sale Id 239',4650.80,0.00,0.00,6.04,640.24,'2023-01-02 09:15:20','',''),(244,'1','307','1',1,'Retail Sale Id 240',4650.80,0.00,0.00,6.04,640.24,'2023-01-02 09:17:06','',''),(245,'1','307','1',1,'Retail Sale Id 241',2002.00,0.00,0.00,2.60,275.60,'2023-01-02 10:24:36','',''),(246,'1','307','1',1,'Retail Sale Id 242',3850.00,0.00,0.00,5.00,530.00,'2023-01-02 11:01:13','',''),(247,'1','307','1',1,'Retail Sale Id 243',1201.20,0.00,0.00,1.56,165.36,'2023-01-02 11:02:42','',''),(248,'1','307','1',1,'Retail Sale Id 244',3850.00,0.00,0.00,5.00,530.00,'2023-01-02 11:03:53','',''),(249,'1','307','1',1,'Retail Sale Id 245',35500.00,0.00,0.00,50.00,2300.00,'2023-01-02 11:21:01','',''),(250,'1','307','1',1,'Retail Sale Id 246',4650.80,0.00,0.00,6.04,640.24,'2023-01-02 11:24:34','',''),(251,'1','307','1',1,'Retail Sale Id 247',3850.00,0.00,0.00,5.00,530.00,'2023-01-02 11:53:15','',''),(252,'1','307','1',1,'Retail Sale Id 248',2348.50,0.00,0.00,3.05,323.30,'2023-01-02 11:54:40','',''),(253,'1','307','1',1,'Retail Sale Id 249',1001.00,0.00,0.00,1.30,137.80,'2023-01-02 12:11:28','',''),(254,'1','307','1',1,'Retail Sale Id 250',6198.50,0.00,0.00,8.05,853.30,'2023-01-02 12:51:09','',''),(255,'1','307','1',1,'Retail Sale Id 251',71000.00,0.00,0.00,100.00,4600.00,'2023-01-02 13:25:56','',''),(256,'1','307','1',1,'Retail Sale Id 252',4650.80,0.00,0.00,6.04,640.24,'2023-01-02 13:38:12','',''),(257,'1','307','1',1,'Retail Sale Id 253',3080.00,0.00,0.00,4.00,424.00,'2023-01-02 13:51:21','',''),(258,'1','307','1',1,'Retail Sale Id 254',2002.00,0.00,0.00,2.60,275.60,'2023-01-02 14:01:12','',''),(259,'1','307','1',1,'Retail Sale Id 255',35500.00,0.00,0.00,50.00,2300.00,'2023-01-02 14:04:03','',''),(260,'1','307','1',1,'Retail Sale Id 256',3103.10,0.00,0.00,4.03,427.18,'2023-01-02 14:05:27','',''),(261,'1','307','1',1,'Retail Sale Id 257',2348.50,0.00,0.00,3.05,323.30,'2023-01-02 14:27:09','',''),(262,'1','307','1',1,'Retail Sale Id 258',3850.00,0.00,0.00,5.00,530.00,'2023-01-02 14:28:09','',''),(263,'1','307','1',1,'Retail Sale Id 259',4650.80,0.00,0.00,6.04,640.24,'2023-01-02 15:29:00','',''),(264,'1','307','1',1,'Retail Sale Id 260',9648.10,0.00,0.00,12.53,1328.18,'2023-01-02 17:49:10','',''),(265,'1','307','1',1,'Retail Sale Id 261',9648.10,0.00,0.00,12.53,1328.18,'2023-01-02 17:50:24','',''),(266,'1','307','1',1,'Retail Sale Id 262',4650.80,0.00,0.00,6.04,640.24,'2023-01-02 17:51:02','',''),(267,'1','307','1',1,'Retail Sale Id 263',1547.70,0.00,0.00,2.01,213.06,'2023-01-02 17:51:45','',''),(268,'1','307','1',1,'Retail Sale Id 264',3003.00,0.00,0.00,3.90,413.40,'2023-01-02 18:16:41','',''),(269,'1','307','1',1,'Retail Sale Id 265',9648.10,0.00,0.00,12.53,1328.18,'2023-01-02 18:25:43','',''),(270,'1','307','1',1,'Retail Sale Id 266',2002.00,0.00,0.00,2.60,275.60,'2023-01-03 08:05:25','',''),(271,'1','307','1',1,'Retail Sale Id 267',3850.00,0.00,0.00,5.00,530.00,'2023-01-03 08:13:45','',''),(272,'1','307','1',1,'Retail Sale Id 269',9648.10,0.00,0.00,12.53,1328.18,'2023-01-03 08:30:43','',''),(273,'1','307','1',1,'Retail Sale Id 270',35500.00,0.00,0.00,50.00,2300.00,'2023-01-03 08:41:34','',''),(274,'1','307','1',1,'Retail Sale Id 271',4650.80,0.00,0.00,6.04,640.24,'2023-01-03 09:32:49','',''),(275,'1','307','1',1,'Retail Sale Id 272',4496.80,0.00,0.00,5.84,619.04,'2023-01-03 09:43:22','',''),(276,'1','307','1',1,'Retail Sale Id 273',35500.00,0.00,0.00,50.00,2300.00,'2023-01-03 09:50:58','',''),(277,'1','307','1',1,'Retail Sale Id 274',35500.00,0.00,0.00,50.00,2300.00,'2023-01-03 09:52:11','',''),(278,'1','307','1',1,'Retail Sale Id 275',6198.50,0.00,0.00,8.05,853.30,'2023-01-03 10:54:27','',''),(279,'1','307','1',1,'Retail Sale Id 276',800.80,0.00,0.00,1.04,110.24,'2023-01-03 12:18:46','',''),(280,'1','307','1',1,'Retail Sale Id 277',4997.30,0.00,0.00,6.49,687.94,'2023-01-03 12:46:58','',''),(281,'1','307','1',1,'Retail Sale Id 278',1501.50,0.00,0.00,1.95,206.70,'2023-01-03 13:03:51','',''),(282,'1','307','1',1,'Retail Sale Id 279',4650.80,0.00,0.00,6.04,640.24,'2023-01-03 13:35:18','',''),(283,'1','307','1',1,'Retail Sale Id 280',4650.80,0.00,0.00,6.04,640.24,'2023-01-03 15:25:45','',''),(284,'1','307','1',1,'Retail Sale Id 281',2348.50,0.00,0.00,3.05,323.30,'2023-01-03 16:37:57','',''),(285,'1','307','1',1,'Retail Sale Id 282',7700.00,0.00,0.00,10.00,1060.00,'2023-01-03 16:39:40','',''),(286,'1','307','1',1,'Retail Sale Id 283',4650.80,0.00,0.00,6.04,640.24,'2023-01-03 17:09:23','',''),(287,'1','307','1',1,'Retail Sale Id 284',4650.80,0.00,0.00,6.04,640.24,'2023-01-03 17:30:08','',''),(288,'1','307','1',1,'Retail Sale Id 285',35500.00,0.00,0.00,50.00,2300.00,'2023-01-03 18:13:58','',''),(289,'1','307','1',1,'Retail Sale Id 286',9648.10,0.00,0.00,12.53,1328.18,'2023-01-03 18:27:06','',''),(290,'1','307','1',1,'Retail Sale Id 287',4650.80,0.00,0.00,6.04,640.24,'2023-01-03 18:30:41','',''),(291,'1','307','1',1,'Retail Sale Id 288',1547.70,0.00,0.00,2.01,213.06,'2023-01-04 07:41:11','',''),(292,'1','307','1',1,'Retail Sale Id 289',2348.50,0.00,0.00,3.05,323.30,'2023-01-04 08:01:21','',''),(293,'1','307','1',1,'Retail Sale Id 290',8500.80,0.00,0.00,11.04,1170.24,'2023-01-04 08:22:54','',''),(294,'1','307','1',1,'Retail Sale Id 291',3850.00,0.00,0.00,5.00,530.00,'2023-01-04 09:02:36','',''),(295,'1','307','1',1,'Retail Sale Id 292',3850.00,0.00,0.00,5.00,530.00,'2023-01-04 09:04:14','',''),(296,'1','307','1',1,'Retail Sale Id 293',35500.00,0.00,0.00,50.00,2300.00,'2023-01-04 09:14:12','',''),(297,'1','307','1',1,'Retail Sale Id 294',4650.80,0.00,0.00,6.04,640.24,'2023-01-04 09:26:21','',''),(298,'1','307','1',1,'Retail Sale Id 295',2310.00,0.00,0.00,3.00,318.00,'2023-01-04 10:15:42','',''),(299,'1','307','1',1,'Retail Sale Id 296',3850.00,0.00,0.00,5.00,530.00,'2023-01-04 10:21:33','',''),(300,'1','307','1',1,'Retail Sale Id 297',4697.00,0.00,0.00,6.10,646.60,'2023-01-04 10:57:18','',''),(301,'1','307','1',1,'Retail Sale Id 298',1547.70,0.00,0.00,2.01,213.06,'2023-01-04 11:19:33','',''),(302,'1','307','1',1,'Retail Sale Id 299',1547.70,0.00,0.00,2.01,213.06,'2023-01-04 11:45:43','',''),(303,'1','307','1',1,'Retail Sale Id 300',3850.00,0.00,0.00,5.00,530.00,'2023-01-04 12:00:20','',''),(304,'1','307','1',1,'Retail Sale Id 301',770.00,0.00,0.00,1.00,106.00,'2023-01-04 12:18:08','',''),(305,'1','307','1',1,'Retail Sale Id 302',19250.00,0.00,0.00,25.00,2650.00,'2023-01-04 12:31:06','',''),(306,'1','307','1',1,'Retail Sale Id 303',3087.70,0.00,0.00,4.01,425.06,'2023-01-04 13:23:50','',''),(307,'1','307','1',1,'Retail Sale Id 304',3850.00,0.00,0.00,5.00,530.00,'2023-01-04 13:27:13','',''),(308,'1','307','1',1,'Retail Sale Id 306',355000.00,0.00,0.00,500.00,23000.00,'2023-01-04 13:57:10','',''),(309,'1','307','1',1,'Retail Sale Id 307',4650.80,0.00,0.00,6.04,640.24,'2023-01-04 14:00:27','',''),(310,'1','307','1',1,'Retail Sale Id 308',4650.80,0.00,0.00,6.04,640.24,'2023-01-04 14:02:08','',''),(311,'1','307','1',1,'Retail Sale Id 309',2949.10,0.00,0.00,3.83,405.98,'2023-01-04 14:50:41','',''),(312,'1','307','1',1,'Retail Sale Id 310',2310.00,0.00,0.00,3.00,318.00,'2023-01-04 15:04:36','',''),(313,'1','307','1',1,'Retail Sale Id 311',4650.80,0.00,0.00,6.04,640.24,'2023-01-04 15:27:04','',''),(314,'1','307','1',1,'Retail Sale Id 312',3850.00,0.00,0.00,5.00,530.00,'2023-01-04 15:45:09','',''),(315,'1','307','1',1,'Retail Sale Id 313',4650.80,0.00,0.00,6.04,640.24,'2023-01-04 17:16:48','',''),(316,'1','307','1',1,'Retail Sale Id 314',9625.00,0.00,0.00,12.50,1325.00,'2023-01-04 17:35:46','',''),(317,'1','307','1',1,'Retail Sale Id 315',3080.00,0.00,0.00,4.00,424.00,'2023-01-04 17:42:55','',''),(318,'1','307','1',1,'Retail Sale Id 316',4997.30,0.00,0.00,6.49,687.94,'2023-01-04 17:46:02','',''),(319,'1','307','1',1,'Retail Sale Id 317',4650.80,0.00,0.00,6.04,640.24,'2023-01-04 18:15:59','',''),(320,'1','307','1',1,'Retail Sale Id 318',3503.50,0.00,0.00,4.55,482.30,'2023-01-04 18:21:10','',''),(321,'1','307','1',1,'Retail Sale Id 319',2348.50,0.00,0.00,3.05,323.30,'2023-01-04 18:48:43','',''),(322,'1','307','1',1,'Retail Sale Id 320',4697.00,0.00,0.00,6.10,646.60,'2023-01-04 18:53:44','',''),(323,'1','307','1',1,'Retail Sale Id 321',5998.30,0.00,0.00,7.79,825.74,'2023-01-05 08:11:25','',''),(324,'1','307','1',1,'Retail Sale Id 322',2002.00,0.00,0.00,2.60,275.60,'2023-01-05 08:17:44','',''),(325,'1','307','1',1,'Retail Sale Id 323',1501.50,0.00,0.00,1.95,206.70,'2023-01-05 08:19:54','',''),(326,'1','307','1',1,'Retail Sale Id 324',9648.10,0.00,0.00,12.53,1328.18,'2023-01-05 08:37:57','',''),(327,'1','307','1',1,'Retail Sale Id 325',1547.70,0.00,0.00,2.01,213.06,'2023-01-05 08:42:30','',''),(328,'1','307','1',1,'Retail Sale Id 326',4650.80,0.00,0.00,6.04,640.24,'2023-01-05 08:45:54','',''),(329,'1','307','1',1,'Retail Sale Id 327',4650.80,0.00,0.00,6.04,640.24,'2023-01-05 08:50:48','',''),(330,'1','307','1',1,'Retail Sale Id 328',2348.50,0.00,0.00,3.05,323.30,'2023-01-05 08:52:26','',''),(331,'1','307','1',1,'Retail Sale Id 329',3850.00,0.00,0.00,5.00,530.00,'2023-01-05 08:56:46','',''),(332,'1','307','1',1,'Retail Sale Id 330',770.00,0.00,0.00,1.00,106.00,'2023-01-05 10:13:53','',''),(333,'1','307','1',1,'Retail Sale Id 331',4650.80,0.00,0.00,6.04,640.24,'2023-01-05 10:22:52','',''),(334,'1','307','1',1,'Retail Sale Id 332',3850.00,0.00,0.00,5.00,530.00,'2023-01-05 10:24:18','',''),(335,'1','307','1',1,'Retail Sale Id 333',3850.00,0.00,0.00,5.00,530.00,'2023-01-05 10:31:08','',''),(336,'1','307','1',1,'Retail Sale Id 334',71000.00,0.00,0.00,100.00,4600.00,'2023-01-05 12:09:06','',''),(337,'1','307','1',1,'Retail Sale Id 335',4650.80,0.00,0.00,6.04,640.24,'2023-01-05 13:26:15','',''),(338,'1','307','1',1,'Retail Sale Id 336',3080.00,0.00,0.00,4.00,424.00,'2023-01-05 15:07:38','',''),(339,'1','307','1',1,'Retail Sale Id 337',7700.00,0.00,0.00,10.00,1060.00,'2023-01-05 15:37:04','',''),(340,'1','307','1',1,'Retail Sale Id 338',9648.10,0.00,0.00,12.53,1328.18,'2023-01-05 15:39:15','',''),(341,'1','307','1',1,'Retail Sale Id 339',4650.80,0.00,0.00,6.04,640.24,'2023-01-05 16:21:42','',''),(342,'1','307','1',1,'Retail Sale Id 340',1540.00,0.00,0.00,2.00,212.00,'2023-01-05 16:23:37','',''),(343,'1','307','1',1,'Retail Sale Id 341',3850.00,0.00,0.00,5.00,530.00,'2023-01-05 16:25:17','',''),(344,'1','307','1',1,'Retail Sale Id 342',2302.30,0.00,0.00,2.99,316.94,'2023-01-05 16:37:44','',''),(345,'1','307','1',1,'Retail Sale Id 343',4650.80,0.00,0.00,6.04,640.24,'2023-01-05 16:43:03','',''),(346,'1','307','1',1,'Retail Sale Id 344',4650.80,0.00,0.00,6.04,640.24,'2023-01-05 16:54:30','',''),(347,'1','307','1',1,'Retail Sale Id 345',7700.00,0.00,0.00,10.00,1060.00,'2023-01-05 17:19:13','',''),(348,'1','307','1',1,'Retail Sale Id 346',7700.00,0.00,0.00,10.00,1060.00,'2023-01-05 17:57:23','',''),(349,'1','307','1',1,'Retail Sale Id 347',115.50,0.00,0.00,0.15,15.90,'2023-01-05 18:50:09','',''),(350,'1','307','1',1,'Retail Sale Id 348',9702.00,0.00,0.00,12.60,1335.60,'2023-01-06 07:32:58','',''),(351,'1','307','1',1,'Retail Sale Id 349',4650.80,0.00,0.00,6.04,640.24,'2023-01-06 08:50:22','',''),(352,'1','307','1',1,'Retail Sale Id 350',2310.00,0.00,0.00,3.00,318.00,'2023-01-06 08:52:15','',''),(353,'1','307','1',1,'Retail Sale Id 351',9001.30,0.00,0.00,11.69,1239.14,'2023-01-06 08:54:07','',''),(354,'1','307','1',1,'Retail Sale Id 352',3080.00,0.00,0.00,4.00,424.00,'2023-01-06 09:15:48','',''),(355,'1','307','1',1,'Retail Sale Id 353',1601.60,0.00,0.00,2.08,220.48,'2023-01-06 09:19:15','',''),(356,'1','307','1',1,'Retail Sale Id 354',1547.70,0.00,0.00,2.01,213.06,'2023-01-06 09:30:30','',''),(357,'1','307','1',1,'Retail Sale Id 355',35500.00,0.00,0.00,50.00,2300.00,'2023-01-06 10:14:10','',''),(358,'1','307','1',1,'Retail Sale Id 356',4620.00,0.00,0.00,6.00,636.00,'2023-01-06 10:15:34','',''),(359,'1','307','1',1,'Retail Sale Id 357',2310.00,0.00,0.00,3.00,318.00,'2023-01-06 11:00:57','',''),(360,'1','307','1',1,'Retail Sale Id 358',2348.50,0.00,0.00,3.05,323.30,'2023-01-06 11:07:44','',''),(361,'1','307','1',1,'Retail Sale Id 359',4650.80,0.00,0.00,6.04,640.24,'2023-01-06 11:09:39','',''),(362,'1','307','1',1,'Retail Sale Id 360',1540.00,0.00,0.00,2.00,212.00,'2023-01-06 11:12:21','',''),(363,'1','307','1',1,'Retail Sale Id 361',3503.50,0.00,0.00,4.55,482.30,'2023-01-06 11:42:18','',''),(364,'1','307','1',1,'Retail Sale Id 362',2348.50,0.00,0.00,3.05,323.30,'2023-01-06 11:43:57','',''),(365,'1','307','1',1,'Retail Sale Id 363',2310.00,0.00,0.00,3.00,318.00,'2023-01-06 11:59:15','',''),(366,'1','307','1',1,'Retail Sale Id 364',2310.00,0.00,0.00,3.00,318.00,'2023-01-06 13:39:59','',''),(367,'1','307','1',1,'Retail Sale Id 365',4997.30,0.00,0.00,6.49,687.94,'2023-01-06 13:55:50','',''),(368,'1','307','1',1,'Retail Sale Id 366',4620.00,0.00,0.00,6.00,636.00,'2023-01-06 15:04:52','',''),(369,'1','307','1',1,'Retail Sale Id 367',4496.80,0.00,0.00,5.84,619.04,'2023-01-06 15:06:17','',''),(370,'1','307','1',1,'Retail Sale Id 368',4620.00,0.00,0.00,6.00,636.00,'2023-01-06 15:39:32','',''),(371,'1','307','1',1,'Retail Sale Id 369',9648.10,0.00,0.00,12.53,1328.18,'2023-01-06 16:14:25','',''),(372,'1','307','1',1,'Retail Sale Id 370',2348.50,0.00,0.00,3.05,323.30,'2023-01-06 16:16:14','',''),(373,'1','307','1',1,'Retail Sale Id 371',3080.00,0.00,0.00,4.00,424.00,'2023-01-06 17:02:06','',''),(374,'1','307','1',1,'Retail Sale Id 372',8500.80,0.00,0.00,11.04,1170.24,'2023-01-06 17:46:59','',''),(375,'1','307','1',1,'Retail Sale Id 373',2348.50,0.00,0.00,3.05,323.30,'2023-01-06 18:04:25','',''),(376,'1','307','1',1,'Retail Sale Id 374',1601.60,0.00,0.00,2.08,220.48,'2023-01-06 18:06:56','',''),(377,'1','307','1',1,'Retail Sale Id 375',3803.80,0.00,0.00,4.94,523.64,'2023-01-06 18:37:06','',''),(378,'1','307','1',1,'Retail Sale Id 376',3850.00,0.00,0.00,5.00,530.00,'2023-01-07 07:26:32','',''),(379,'1','307','1',1,'Retail Sale Id 377',4650.80,0.00,0.00,6.04,640.24,'2023-01-07 07:42:57','',''),(380,'1','307','1',1,'Retail Sale Id 378',3080.00,0.00,0.00,4.00,424.00,'2023-01-07 08:02:27','',''),(381,'1','307','1',1,'Retail Sale Id 379',4620.00,0.00,0.00,6.00,636.00,'2023-01-07 08:04:17','',''),(382,'1','307','1',1,'Retail Sale Id 380',3103.10,0.00,0.00,4.03,427.18,'2023-01-07 08:08:46','',''),(383,'1','307','1',1,'Retail Sale Id 381',2310.00,0.00,0.00,3.00,318.00,'2023-01-07 08:41:09','',''),(384,'1','307','1',1,'Retail Sale Id 382',4620.00,0.00,0.00,6.00,636.00,'2023-01-07 08:44:01','',''),(385,'1','307','1',1,'Retail Sale Id 384',4697.00,0.00,0.00,6.10,646.60,'2023-01-07 08:52:14','',''),(386,'1','307','1',1,'Retail Sale Id 385',2302.30,0.00,0.00,2.99,316.94,'2023-01-07 10:10:09','',''),(387,'1','307','1',1,'Retail Sale Id 386',4496.80,0.00,0.00,5.84,619.04,'2023-01-07 12:10:07','',''),(388,'1','307','1',1,'Retail Sale Id 387',1001.00,0.00,0.00,1.30,137.80,'2023-01-07 12:13:06','',''),(389,'1','307','1',1,'Retail Sale Id 389',1601.60,0.00,0.00,2.08,220.48,'2023-01-07 12:19:41','',''),(390,'1','307','1',1,'Retail Sale Id 390',3503.50,0.00,0.00,4.55,482.30,'2023-01-07 13:08:58','',''),(391,'1','307','1',1,'Retail Sale Id 391',4496.80,0.00,0.00,5.84,619.04,'2023-01-07 13:22:47','',''),(392,'1','307','1',1,'Retail Sale Id 392',800.80,0.00,0.00,1.04,110.24,'2023-01-07 13:33:29','',''),(393,'1','307','1',1,'Retail Sale Id 393',35500.00,0.00,0.00,50.00,2300.00,'2023-01-07 13:47:48','',''),(394,'1','307','1',1,'Retail Sale Id 394',35500.00,0.00,0.00,50.00,2300.00,'2023-01-07 13:49:24','',''),(395,'1','307','1',1,'Retail Sale Id 395',4650.80,0.00,0.00,6.04,640.24,'2023-01-07 13:51:02','',''),(396,'1','307','1',1,'Retail Sale Id 396',4997.30,0.00,0.00,6.49,687.94,'2023-01-07 14:15:33','',''),(397,'1','307','1',1,'Retail Sale Id 397',3850.00,0.00,0.00,5.00,530.00,'2023-01-07 14:50:32','',''),(398,'1','307','1',1,'Retail Sale Id 398',4650.80,0.00,0.00,6.04,640.24,'2023-01-07 14:53:11','',''),(399,'1','307','1',1,'Retail Sale Id 399',4620.00,0.00,0.00,6.00,636.00,'2023-01-07 15:10:51','',''),(400,'1','307','1',1,'Retail Sale Id 400',900.90,0.00,0.00,1.17,124.02,'2023-01-07 15:33:31','',''),(401,'1','307','1',1,'Retail Sale Id 401',770.00,0.00,0.00,1.00,106.00,'2023-01-07 15:36:16','',''),(402,'1','307','1',1,'Retail Sale Id 402',3850.00,0.00,0.00,5.00,530.00,'2023-01-07 15:51:55','',''),(403,'1','307','1',1,'Retail Sale Id 403',4650.80,0.00,0.00,6.04,640.24,'2023-01-07 16:14:10','',''),(404,'1','307','1',1,'Retail Sale Id 404',1547.70,0.00,0.00,2.01,213.06,'2023-01-07 16:29:53','',''),(405,'1','307','1',1,'Retail Sale Id 405',3003.00,0.00,0.00,3.90,413.40,'2023-01-07 17:05:28','',''),(406,'1','307','1',1,'Retail Sale Id 406',2302.30,0.00,0.00,2.99,316.94,'2023-01-07 17:12:55','',''),(407,'1','307','1',1,'Retail Sale Id 407',3080.00,0.00,0.00,4.00,424.00,'2023-01-07 17:26:16','',''),(408,'1','307','1',1,'Retail Sale Id 408',4620.00,0.00,0.00,6.00,636.00,'2023-01-07 17:37:18','',''),(409,'1','307','1',1,'Retail Sale Id 409',2348.50,0.00,0.00,3.05,323.30,'2023-01-07 17:43:48','',''),(410,'1','307','1',1,'Retail Sale Id 410',4650.80,0.00,0.00,6.04,640.24,'2023-01-07 18:03:05','',''),(411,'1','307','1',1,'Retail Sale Id 411',2348.50,0.00,0.00,3.05,323.30,'2023-01-07 18:09:02','',''),(412,'1','307','1',1,'Retail Sale Id 412',1540.00,0.00,0.00,2.00,212.00,'2023-01-07 18:10:36','',''),(413,'1','307','1',1,'Retail Sale Id 413',52540.00,0.00,0.00,74.00,3404.00,'2023-01-07 18:24:07','',''),(414,'1','307','1',1,'Retail Sale Id 414',3080.00,0.00,0.00,4.00,424.00,'2023-01-07 18:33:41','',''),(415,'1','307','1',1,'Retail Sale Id 415',11996.60,0.00,0.00,15.58,1651.48,'2023-01-07 18:48:20','',''),(416,'1','307','1',1,'Retail Sale Id 416',38.50,0.00,0.00,0.05,5.30,'2023-01-07 18:58:18','',''),(417,'1','307','1',1,'Return of Retail Sale Id 416',0.00,38.50,0.05,0.00,-5.30,'2023-01-07 18:59:24','',''),(418,'1','307','1',1,'Retail Sale Id 417',2502.50,0.00,0.00,3.25,344.50,'2023-01-08 07:25:01','',''),(419,'1','307','1',1,'Retail Sale Id 418',500.50,0.00,0.00,0.65,68.90,'2023-01-08 07:27:17','',''),(420,'1','307','1',1,'Retail Sale Id 419',9648.10,0.00,0.00,12.53,1328.18,'2023-01-08 07:54:00','',''),(421,'1','307','1',1,'Retail Sale Id 420',4997.30,0.00,0.00,6.49,687.94,'2023-01-08 09:35:56','',''),(422,'1','307','1',1,'Retail Sale Id 421',3080.00,0.00,0.00,4.00,424.00,'2023-01-08 09:37:59','',''),(423,'1','307','1',1,'Retail Sale Id 422',2310.00,0.00,0.00,3.00,318.00,'2023-01-08 09:39:34','',''),(424,'1','307','1',1,'Retail Sale Id 423',800.80,0.00,0.00,1.04,110.24,'2023-01-08 10:11:26','',''),(425,'1','307','1',1,'Retail Sale Id 424',2348.50,0.00,0.00,3.05,323.30,'2023-01-08 10:16:17','',''),(426,'1','307','1',1,'Retail Sale Id 425',3850.00,0.00,0.00,5.00,530.00,'2023-01-08 10:20:21','',''),(427,'1','307','1',1,'Retail Sale Id 426',4650.80,0.00,0.00,6.04,640.24,'2023-01-08 10:57:58','',''),(428,'1','307','1',1,'Retail Sale Id 429',4650.80,0.00,0.00,6.04,640.24,'2023-01-08 11:18:28','',''),(429,'1','307','1',1,'Retail Sale Id 430',2002.00,0.00,0.00,2.60,275.60,'2023-01-08 11:34:29','',''),(430,'1','307','1',1,'Retail Sale Id 431',3103.10,0.00,0.00,4.03,427.18,'2023-01-08 11:41:08','',''),(431,'1','307','1',1,'Retail Sale Id 432',4620.00,0.00,0.00,6.00,636.00,'2023-01-08 11:53:26','',''),(432,'1','307','1',1,'Retail Sale Id 433',4650.80,0.00,0.00,6.04,640.24,'2023-01-08 11:58:31','',''),(433,'1','307','1',1,'Retail Sale Id 434',3850.00,0.00,0.00,5.00,530.00,'2023-01-08 12:00:56','',''),(434,'1','307','1',1,'Retail Sale Id 435',2348.50,0.00,0.00,3.05,323.30,'2023-01-08 12:05:20','',''),(435,'1','307','1',1,'Retail Sale Id 436',3996.30,0.00,0.00,5.19,550.14,'2023-01-08 12:31:21','',''),(436,'1','307','1',1,'Retail Sale Id 437',6999.30,0.00,0.00,9.09,963.54,'2023-01-08 12:40:44','',''),(437,'1','307','1',1,'Retail Sale Id 438',6160.00,0.00,0.00,8.00,848.00,'2023-01-08 12:42:28','',''),(438,'1','307','1',1,'Retail Sale Id 439',9648.10,0.00,0.00,12.53,1328.18,'2023-01-08 12:50:07','',''),(439,'1','307','1',1,'Retail Sale Id 440',4650.80,0.00,0.00,6.04,640.24,'2023-01-08 13:11:09','',''),(440,'1','307','1',1,'Retail Sale Id 441',3850.00,0.00,0.00,5.00,530.00,'2023-01-08 13:14:47','',''),(441,'1','307','1',1,'Retail Sale Id 442',7700.00,0.00,0.00,10.00,1060.00,'2023-01-08 13:48:59','',''),(442,'1','307','1',1,'Retail Sale Id 443',1701.70,0.00,0.00,2.21,234.26,'2023-01-08 14:07:00','',''),(443,'1','307','1',1,'Retail Sale Id 444',3103.10,0.00,0.00,4.03,427.18,'2023-01-08 14:24:41','',''),(444,'1','307','1',1,'Retail Sale Id 445',4650.80,0.00,0.00,6.04,640.24,'2023-01-08 14:55:49','',''),(445,'1','307','1',1,'Retail Sale Id 446',4596.90,0.00,0.00,5.97,632.82,'2023-01-08 15:11:49','',''),(446,'1','307','1',1,'Retail Sale Id 447',9247.70,0.00,0.00,12.01,1273.06,'2023-01-08 15:25:10','',''),(447,'1','307','1',1,'Retail Sale Id 448',2002.00,0.00,0.00,2.60,275.60,'2023-01-08 15:53:19','',''),(448,'1','307','1',1,'Retail Sale Id 449',2348.50,0.00,0.00,3.05,323.30,'2023-01-08 16:19:01','',''),(449,'1','307','1',1,'Retail Sale Id 450',3850.00,0.00,0.00,5.00,530.00,'2023-01-08 16:22:02','',''),(450,'1','307','1',1,'Retail Sale Id 451',1540.00,0.00,0.00,2.00,212.00,'2023-01-08 16:36:36','',''),(451,'1','307','1',1,'Retail Sale Id 452',1547.70,0.00,0.00,2.01,213.06,'2023-01-08 16:38:43','',''),(452,'1','307','1',1,'Retail Sale Id 453',3080.00,0.00,0.00,4.00,424.00,'2023-01-08 16:40:32','',''),(453,'1','307','1',1,'Retail Sale Id 454',4620.00,0.00,0.00,6.00,636.00,'2023-01-08 17:07:49','',''),(454,'1','307','1',1,'Retail Sale Id 455',9617.30,0.00,0.00,12.49,1323.94,'2023-01-08 17:21:00','',''),(455,'1','307','1',1,'Retail Sale Id 456',1540.00,0.00,0.00,2.00,212.00,'2023-01-08 17:28:16','',''),(456,'1','307','1',1,'Retail Sale Id 457',2310.00,0.00,0.00,3.00,318.00,'2023-01-08 17:38:24','',''),(457,'1','307','1',1,'Retail Sale Id 457',4620.00,0.00,0.00,6.00,636.00,'2023-01-08 17:38:24','',''),(458,'1','307','1',1,'Retail Sale Id 458',770.00,0.00,0.00,1.00,106.00,'2023-01-08 18:04:45','',''),(459,'1','307','1',1,'Retail Sale Id 459',3850.00,0.00,0.00,5.00,530.00,'2023-01-08 18:11:44','',''),(460,'1','307','1',1,'Retail Sale Id 460',3850.00,0.00,0.00,5.00,530.00,'2023-01-08 18:23:24','',''),(461,'1','307','1',1,'Retail Sale Id 461',5397.70,0.00,0.00,7.01,743.06,'2023-01-08 18:33:08','',''),(462,'1','307','1',1,'Retail Sale Id 462',4650.80,0.00,0.00,6.04,640.24,'2023-01-09 08:01:08','',''),(463,'1','307','1',1,'Retail Sale Id 463',2310.00,0.00,0.00,3.00,318.00,'2023-01-09 08:02:30','',''),(464,'1','307','1',1,'Retail Sale Id 465',4650.80,0.00,0.00,6.04,640.24,'2023-01-09 08:17:38','',''),(465,'1','307','1',1,'Retail Sale Id 466',4620.00,0.00,0.00,6.00,636.00,'2023-01-09 08:18:55','',''),(466,'1','307','1',1,'Retail Sale Id 467',9648.10,0.00,0.00,12.53,1328.18,'2023-01-09 08:46:38','',''),(467,'1','307','1',1,'Retail Sale Id 468',1501.50,0.00,0.00,1.95,206.70,'2023-01-09 10:03:34','',''),(468,'1','307','1',1,'Retail Sale Id 469',1501.50,0.00,0.00,1.95,206.70,'2023-01-09 10:26:36','',''),(469,'1','307','1',1,'Retail Sale Id 470',71000.00,0.00,0.00,100.00,4600.00,'2023-01-09 10:33:36','',''),(470,'1','307','1',1,'Retail Sale Id 471',3080.00,0.00,0.00,4.00,424.00,'2023-01-09 13:22:30','',''),(471,'1','307','1',1,'Retail Sale Id 472',7700.00,0.00,0.00,10.00,1060.00,'2023-01-09 13:59:07','',''),(472,'1','307','1',1,'Retail Sale Id 473',3850.00,0.00,0.00,5.00,530.00,'2023-01-09 14:08:39','',''),(473,'1','307','1',1,'Retail Sale Id 474',9640.40,0.00,0.00,12.52,1327.12,'2023-01-09 15:06:38','',''),(474,'1','307','1',1,'Retail Sale Id 475',4620.00,0.00,0.00,6.00,636.00,'2023-01-09 15:17:55','',''),(475,'1','307','1',1,'Retail Sale Id 476',35500.00,0.00,0.00,50.00,2300.00,'2023-01-09 15:36:33','',''),(476,'1','307','1',1,'Retail Sale Id 478',3996.30,0.00,0.00,5.19,550.14,'2023-01-09 15:58:14','',''),(477,'1','307','1',1,'Retail Sale Id 479',3080.00,0.00,0.00,4.00,424.00,'2023-01-09 16:30:33','',''),(478,'1','307','1',1,'Retail Sale Id 480',4650.80,0.00,0.00,6.04,640.24,'2023-01-09 16:38:54','',''),(479,'1','307','1',1,'Retail Sale Id 481',4650.80,0.00,0.00,6.04,640.24,'2023-01-09 16:41:07','',''),(480,'1','307','1',1,'Retail Sale Id 482',3850.00,0.00,0.00,5.00,530.00,'2023-01-09 17:01:07','',''),(481,'1','307','1',1,'Retail Sale Id 483',800.80,0.00,0.00,1.04,110.24,'2023-01-09 17:07:26','',''),(482,'1','307','1',1,'Retail Sale Id 484',4650.80,0.00,0.00,6.04,640.24,'2023-01-09 17:10:14','',''),(483,'1','307','1',1,'Retail Sale Id 485',4620.00,0.00,0.00,6.00,636.00,'2023-01-09 17:23:06','',''),(484,'1','307','1',1,'Retail Sale Id 486',770.00,0.00,0.00,1.00,106.00,'2023-01-09 17:40:32','',''),(485,'1','307','1',1,'Retail Sale Id 487',4997.30,0.00,0.00,6.49,687.94,'2023-01-09 17:58:30','',''),(486,'1','307','1',1,'Retail Sale Id 488',2002.00,0.00,0.00,2.60,275.60,'2023-01-09 17:59:49','',''),(487,'1','307','1',1,'Retail Sale Id 490',2310.00,0.00,0.00,3.00,318.00,'2023-01-09 18:32:22','',''),(488,'1','307','1',1,'Retail Sale Id 491',6160.00,0.00,0.00,8.00,848.00,'2023-01-09 18:36:54','',''),(489,'1','307','1',1,'Retail Sale Id 492',3850.00,0.00,0.00,5.00,530.00,'2023-01-09 18:52:40','',''),(490,'1','307','1',1,'Retail Sale Id 493',30.80,0.00,0.00,0.04,4.24,'2023-01-09 19:02:32','',''),(491,'1','307','1',1,'Retail Sale Id 494',1001.00,0.00,0.00,1.30,137.80,'2023-01-10 07:38:09','',''),(492,'1','307','1',1,'Retail Sale Id 495',2310.00,0.00,0.00,3.00,318.00,'2023-01-10 07:55:08','',''),(493,'1','307','1',1,'Retail Sale Id 496',800.80,0.00,0.00,1.04,110.24,'2023-01-10 08:11:12','',''),(494,'1','307','1',1,'Retail Sale Id 497',2310.00,0.00,0.00,3.00,318.00,'2023-01-10 08:29:15','',''),(495,'1','307','1',1,'Retail Sale Id 498',7700.00,0.00,0.00,10.00,1060.00,'2023-01-10 08:43:31','',''),(496,'1','307','1',1,'Retail Sale Id 499',1547.70,0.00,0.00,2.01,213.06,'2023-01-10 09:28:58','',''),(497,'1','307','1',1,'Retail Sale Id 500',3850.00,0.00,0.00,5.00,530.00,'2023-01-10 10:16:30','',''),(498,'1','307','1',1,'Retail Sale Id 501',4650.80,0.00,0.00,6.04,640.24,'2023-01-10 10:33:11','',''),(499,'1','307','1',1,'Retail Sale Id 502',2348.50,0.00,0.00,3.05,323.30,'2023-01-10 10:58:02','',''),(500,'1','307','1',1,'Retail Sale Id 503',106500.00,0.00,0.00,150.00,6900.00,'2023-01-10 11:38:33','',''),(501,'1','307','1',1,'Retail Sale Id 504',1547.70,0.00,0.00,2.01,213.06,'2023-01-10 11:48:49','',''),(502,'1','307','1',1,'Retail Sale Id 505',2002.00,0.00,0.00,2.60,275.60,'2023-01-10 12:52:37','',''),(503,'1','307','1',1,'Retail Sale Id 506',4650.80,0.00,0.00,6.04,640.24,'2023-01-10 13:25:06','',''),(504,'1','307','1',1,'Retail Sale Id 507',1540.00,0.00,0.00,2.00,212.00,'2023-01-10 13:52:59','',''),(505,'1','307','1',1,'Retail Sale Id 508',2310.00,0.00,0.00,3.00,318.00,'2023-01-10 15:04:06','',''),(506,'1','307','1',1,'Retail Sale Id 509',1547.70,0.00,0.00,2.01,213.06,'2023-01-10 15:05:22','',''),(507,'1','307','1',1,'Retail Sale Id 510',2310.00,0.00,0.00,3.00,318.00,'2023-01-10 15:14:37','',''),(508,'1','307','1',1,'Retail Sale Id 512',1540.00,0.00,0.00,2.00,212.00,'2023-01-10 15:24:45','',''),(509,'1','307','1',1,'Retail Sale Id 513',800.80,0.00,0.00,1.04,110.24,'2023-01-10 15:31:54','',''),(510,'1','307','1',1,'Retail Sale Id 514',770.00,0.00,0.00,1.00,106.00,'2023-01-10 15:33:22','',''),(511,'1','307','1',1,'Retail Sale Id 515',35500.00,0.00,0.00,50.00,2300.00,'2023-01-10 15:51:58','',''),(512,'1','307','1',1,'Retail Sale Id 516',4650.80,0.00,0.00,6.04,640.24,'2023-01-10 16:26:56','',''),(513,'1','307','1',1,'Retail Sale Id 517',2348.50,0.00,0.00,3.05,323.30,'2023-01-10 16:56:20','',''),(514,'1','307','1',1,'Retail Sale Id 518',2302.30,0.00,0.00,2.99,316.94,'2023-01-10 17:41:24','',''),(515,'1','307','1',1,'Retail Sale Id 519',2002.00,0.00,0.00,2.60,275.60,'2023-01-10 17:43:18','',''),(516,'1','307','1',1,'Retail Sale Id 520',1547.70,0.00,0.00,2.01,213.06,'2023-01-10 17:48:53','',''),(517,'1','307','1',1,'Retail Sale Id 521',4650.80,0.00,0.00,6.04,640.24,'2023-01-10 17:50:26','',''),(518,'1','307','1',1,'Retail Sale Id 522',1547.70,0.00,0.00,2.01,213.06,'2023-01-10 18:30:00','',''),(519,'1','307','1',1,'Retail Sale Id 523',3103.10,0.00,0.00,4.03,427.18,'2023-01-10 18:31:54','',''),(520,'1','307','1',1,'Retail Sale Id 524',1547.70,0.00,0.00,2.01,213.06,'2023-01-11 07:34:08','',''),(521,'1','307','1',1,'Retail Sale Id 525',7700.00,0.00,0.00,10.00,1060.00,'2023-01-11 08:20:10','',''),(522,'1','307','1',1,'Retail Sale Id 526',6198.50,0.00,0.00,8.05,853.30,'2023-01-11 08:32:23','',''),(523,'1','307','1',1,'Retail Sale Id 527',7700.00,0.00,0.00,10.00,1060.00,'2023-01-11 08:34:03','',''),(524,'1','307','1',1,'Retail Sale Id 528',2348.50,0.00,0.00,3.05,323.30,'2023-01-11 08:39:31','',''),(525,'1','307','1',1,'Retail Sale Id 529',11550.00,0.00,0.00,15.00,1590.00,'2023-01-11 09:16:28','',''),(526,'1','307','1',1,'Retail Sale Id 530',2348.50,0.00,0.00,3.05,323.30,'2023-01-11 09:38:17','',''),(527,'1','307','1',1,'Retail Sale Id 531',2348.50,0.00,0.00,3.05,323.30,'2023-01-11 09:43:03','',''),(528,'1','307','1',1,'Retail Sale Id 532',4496.80,0.00,0.00,5.84,619.04,'2023-01-11 09:53:52','',''),(529,'1','307','1',1,'Retail Sale Id 533',3103.10,0.00,0.00,4.03,427.18,'2023-01-11 10:02:27','',''),(530,'1','307','1',1,'Retail Sale Id 534',4620.00,0.00,0.00,6.00,636.00,'2023-01-11 10:24:47','',''),(531,'1','307','1',1,'Retail Sale Id 535',2310.00,0.00,0.00,3.00,318.00,'2023-01-11 10:29:16','',''),(532,'1','307','1',1,'Retail Sale Id 536',9648.10,0.00,0.00,12.53,1328.18,'2023-01-11 10:33:00','',''),(533,'1','307','1',1,'Retail Sale Id 537',2348.50,0.00,0.00,3.05,323.30,'2023-01-11 10:36:12','',''),(534,'1','307','1',1,'Retail Sale Id 539',1001.00,0.00,0.00,1.30,137.80,'2023-01-11 11:04:33','',''),(535,'1','307','1',1,'Retail Sale Id 540',7700.00,0.00,0.00,10.00,1060.00,'2023-01-11 11:07:17','',''),(536,'1','307','1',1,'Retail Sale Id 541',3996.30,0.00,0.00,5.19,550.14,'2023-01-11 11:33:52','',''),(537,'1','307','1',1,'Retail Sale Id 542',2310.00,0.00,0.00,3.00,318.00,'2023-01-11 12:29:34','',''),(538,'1','307','1',1,'Retail Sale Id 542',2310.00,0.00,0.00,3.00,318.00,'2023-01-11 12:29:34','',''),(539,'1','307','1',1,'Retail Sale Id 543',1540.00,0.00,0.00,2.00,212.00,'2023-01-11 12:31:06','',''),(540,'1','307','1',1,'Retail Sale Id 544',6806.80,0.00,0.00,8.84,937.04,'2023-01-11 13:37:37','',''),(541,'1','307','1',1,'Distributed to alhaji ubale for sales id:1',74826.16,0.00,0.00,112.69,0.00,'2023-01-11 14:06:21','',''),(542,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,664000.00,1000.00,0.00,0.00,'2023-01-11 15:29:04','',''),(543,'1','307',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,1000.00,0.00,'2023-01-11 15:39:13','',''),(544,'1','307','1',1,'Received from bridging 2',0.00,0.00,1000.00,0.00,0.00,'2023-01-11 15:39:13','',''),(545,'1','307','1',1,'Retail Sale Id 545',2348.50,0.00,0.00,3.05,323.30,'2023-01-11 15:44:06','',''),(546,'1','307','1',1,'Retail Sale Id 546',4650.80,0.00,0.00,6.04,640.24,'2023-01-11 15:46:51','',''),(547,'1','307','1',1,'Retail Sale Id 547',7700.00,0.00,0.00,10.00,1060.00,'2023-01-11 15:48:17','',''),(548,'1','307','1',1,'Retail Sale Id 548',4620.00,0.00,0.00,6.00,636.00,'2023-01-11 15:55:27','',''),(549,'1','307','1',1,'Retail Sale Id 549',4650.80,0.00,0.00,6.04,640.24,'2023-01-11 15:56:20','',''),(550,'1','307','1',1,'Retail Sale Id 550',1547.70,0.00,0.00,2.01,213.06,'2023-01-11 15:59:15','',''),(551,'1','307','1',1,'Retail Sale Id 551',35500.00,0.00,0.00,50.00,2300.00,'2023-01-11 16:16:59','',''),(552,'1','307','1',1,'Retail Sale Id 552',1501.50,0.00,0.00,1.95,206.70,'2023-01-11 16:20:06','',''),(553,'1','307','1',1,'Retail Sale Id 553',1547.70,0.00,0.00,2.01,213.06,'2023-01-11 16:21:37','',''),(554,'1','307','1',1,'Retail Sale Id 554',800.80,0.00,0.00,1.04,110.24,'2023-01-11 16:24:17','',''),(555,'1','307','1',1,'Retail Sale Id 555',5397.70,0.00,0.00,7.01,743.06,'2023-01-11 16:25:41','',''),(556,'1','307','1',1,'Retail Sale Id 556',1501.50,0.00,0.00,1.95,206.70,'2023-01-11 16:31:13','',''),(557,'1','307','1',1,'Retail Sale Id 557',1001.00,0.00,0.00,1.30,137.80,'2023-01-11 16:43:08','',''),(558,'1','307','1',1,'Retail Sale Id 558',770.00,0.00,0.00,1.00,106.00,'2023-01-11 16:54:01','',''),(559,'1','307','1',1,'Retail Sale Id 558',770.00,0.00,0.00,1.00,106.00,'2023-01-11 16:54:01','',''),(560,'1','307','1',1,'Retail Sale Id 559',2310.00,0.00,0.00,3.00,318.00,'2023-01-11 16:58:08','',''),(561,'1','307','1',1,'Retail Sale Id 560',2310.00,0.00,0.00,3.00,318.00,'2023-01-11 17:04:00','',''),(562,'1','307','1',1,'Retail Sale Id 561',1540.00,0.00,0.00,2.00,212.00,'2023-01-11 17:08:32','',''),(563,'1','307','1',1,'Retail Sale Id 562',1601.60,0.00,0.00,2.08,220.48,'2023-01-11 17:58:16','',''),(564,'1','307','1',1,'Retail Sale Id 563',9648.10,0.00,0.00,12.53,1328.18,'2023-01-11 18:06:18','',''),(565,'1','307','1',1,'Retail Sale Id 564',1540.00,0.00,0.00,2.00,212.00,'2023-01-11 18:24:11','',''),(566,'1','307','1',1,'Retail Sale Id 565',770.00,0.00,0.00,1.00,106.00,'2023-01-11 18:26:39','',''),(567,'1','307','1',1,'Retail Sale Id 566',4188.80,0.00,0.00,5.44,576.64,'2023-01-11 18:50:49','',''),(568,'1','307','1',1,'Retail Sale Id 567',42600.00,0.00,0.00,60.00,2760.00,'2023-01-12 07:28:24','',''),(569,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,2861840.00,4310.00,0.00,0.00,'2023-01-12 07:40:44','',''),(570,'1','307',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,4310.00,0.00,'2023-01-12 07:42:49','',''),(571,'1','307','1',1,'Received from bridging 3',0.00,0.00,4310.00,0.00,0.00,'2023-01-12 07:42:49','',''),(572,'1','307','1',1,'Retail Sale Id 568',1998.80,0.00,0.00,2.63,252.48,'2023-01-12 08:27:30','',''),(573,'1','307','1',1,'Retail Sale Id 569',4560.00,0.00,0.00,6.00,576.00,'2023-01-12 08:45:04','',''),(574,'1','307','1',1,'Retail Sale Id 570',2302.80,0.00,0.00,3.03,290.88,'2023-01-12 08:47:04','',''),(575,'1','307','1',1,'Retail Sale Id 571',1520.00,0.00,0.00,2.00,192.00,'2023-01-12 08:55:05','',''),(576,'1','307','1',1,'Retail Sale Id 572',9500.00,0.00,0.00,12.50,1200.00,'2023-01-12 08:58:28','',''),(577,'1','307','1',1,'Retail Sale Id 573',2302.80,0.00,0.00,3.03,290.88,'2023-01-12 09:52:53','',''),(578,'1','307','1',1,'Retail Sale Id 574',2302.80,0.00,0.00,3.03,290.88,'2023-01-12 10:01:45','',''),(579,'1','307','1',1,'Retail Sale Id 574',9500.00,0.00,0.00,12.50,1200.00,'2023-01-12 10:01:45','',''),(580,'1','307','1',1,'Retail Sale Id 575',53250.00,0.00,0.00,75.00,3450.00,'2023-01-12 10:55:15','',''),(581,'1','307','1',1,'Retail Sale Id 576',5000.80,0.00,0.00,6.58,631.68,'2023-01-12 10:58:13','',''),(582,'1','307','1',1,'Retail Sale Id 577',4560.00,0.00,0.00,6.00,576.00,'2023-01-12 11:00:48','',''),(583,'1','307','1',1,'Retail Sale Id 578',3800.00,0.00,0.00,5.00,480.00,'2023-01-12 11:02:25','',''),(584,'1','307','1',1,'Retail Sale Id 579',1998.80,0.00,0.00,2.63,252.48,'2023-01-12 12:43:10','',''),(585,'1','307','1',1,'Retail Sale Id 580',2302.80,0.00,0.00,3.03,290.88,'2023-01-12 12:49:01','',''),(586,'1','307','1',1,'Retail Sale Id 581',2401.60,0.00,0.00,3.16,303.36,'2023-01-12 13:25:16','',''),(587,'1','307','1',1,'Retail Sale Id 582',1550.40,0.00,0.00,2.04,195.84,'2023-01-12 13:34:40','',''),(588,'1','307','1',1,'Retail Sale Id 583',2302.80,0.00,0.00,3.03,290.88,'2023-01-12 13:40:08','',''),(589,'1','307','1',1,'Retail Sale Id 584',4598.00,0.00,0.00,6.05,580.80,'2023-01-12 13:49:56','',''),(590,'1','307','1',1,'Retail Sale Id 585',4560.00,0.00,0.00,6.00,576.00,'2023-01-12 13:51:05','',''),(591,'1','307','1',1,'Retail Sale Id 586',6900.80,0.00,0.00,9.08,871.68,'2023-01-12 13:58:18','',''),(592,'1','307','1',1,'Retail Sale Id 587',4552.40,0.00,0.00,5.99,575.04,'2023-01-12 14:10:21','',''),(593,'1','307','1',1,'Retail Sale Id 588',798.00,0.00,0.00,1.05,100.80,'2023-01-12 15:09:08','',''),(594,'1','307','1',1,'Retail Sale Id 589',4598.00,0.00,0.00,6.05,580.80,'2023-01-12 15:42:52','',''),(595,'1','307','1',1,'Retail Sale Id 590',9500.00,0.00,0.00,12.50,1200.00,'2023-01-12 15:52:11','',''),(596,'1','307','1',1,'Retail Sale Id 591',2302.80,0.00,0.00,3.03,290.88,'2023-01-12 16:15:52','',''),(597,'1','307','1',1,'Retail Sale Id 592',2196.40,0.00,0.00,2.89,277.44,'2023-01-12 16:34:36','',''),(598,'1','307','1',1,'Retail Sale Id 593',2302.80,0.00,0.00,3.03,290.88,'2023-01-12 16:56:11','',''),(599,'1','307','1',1,'Retail Sale Id 594',4560.00,0.00,0.00,6.00,576.00,'2023-01-12 17:17:49','',''),(600,'1','307','1',1,'Retail Sale Id 595',1550.40,0.00,0.00,2.04,195.84,'2023-01-12 17:19:42','',''),(601,'1','307','1',1,'Retail Sale Id 597',3040.00,0.00,0.00,4.00,384.00,'2023-01-12 17:26:33','',''),(602,'1','307','1',1,'Retail Sale Id 598',3002.00,0.00,0.00,3.95,379.20,'2023-01-12 17:57:41','',''),(603,'1','307','1',1,'Retail Sale Id 599',2302.80,0.00,0.00,3.03,290.88,'2023-01-12 18:01:49','',''),(604,'1','307','1',1,'Retail Sale Id 600',2796.80,0.00,0.00,3.68,353.28,'2023-01-12 18:27:43','',''),(605,'1','307','1',1,'Retail Sale Id 601',2280.00,0.00,0.00,3.00,288.00,'2023-01-12 18:37:51','',''),(606,'1','307','1',1,'Retail Sale Id 602',9500.00,0.00,0.00,12.50,1200.00,'2023-01-13 08:28:09','',''),(607,'1','307','1',1,'Retail Sale Id 603',1550.40,0.00,0.00,2.04,195.84,'2023-01-13 08:35:48','',''),(608,'1','307','1',1,'Retail Sale Id 604',3800.00,0.00,0.00,5.00,480.00,'2023-01-13 09:21:02','',''),(609,'1','307','1',1,'Retail Sale Id 604',9500.00,0.00,0.00,12.50,1200.00,'2023-01-13 09:21:02','',''),(610,'1','307','1',1,'Retail Sale Id 605',3800.00,0.00,0.00,5.00,480.00,'2023-01-13 09:26:24','',''),(611,'1','307','1',1,'Retail Sale Id 606',19000.00,0.00,0.00,25.00,2400.00,'2023-01-13 09:27:13','',''),(612,'1','307','1',1,'Retail Sale Id 607',35500.00,0.00,0.00,50.00,2300.00,'2023-01-13 09:32:43','',''),(613,'1','307','1',1,'Retail Sale Id 608',1550.40,0.00,0.00,2.04,195.84,'2023-01-13 09:35:50','',''),(614,'1','307','1',1,'Retail Sale Id 609',2280.00,0.00,0.00,3.00,288.00,'2023-01-13 09:47:23','',''),(615,'1','307','1',1,'Retail Sale Id 610',2302.80,0.00,0.00,3.03,290.88,'2023-01-13 09:51:00','',''),(616,'1','307','1',1,'Retail Sale Id 611',3800.00,0.00,0.00,5.00,480.00,'2023-01-13 09:54:05','',''),(617,'1','307','1',1,'Retail Sale Id 612',4598.00,0.00,0.00,6.05,580.80,'2023-01-13 10:58:00','',''),(618,'1','307','1',1,'Retail Sale Id 613',3800.00,0.00,0.00,5.00,480.00,'2023-01-13 10:59:53','',''),(619,'1','307','1',1,'Retail Sale Id 614',2302.80,0.00,0.00,3.03,290.88,'2023-01-13 11:08:42','',''),(620,'1','307','1',1,'Retail Sale Id 615',3047.60,0.00,0.00,4.01,384.96,'2023-01-13 11:11:25','',''),(621,'1','307','1',1,'Retail Sale Id 616',1520.00,0.00,0.00,2.00,192.00,'2023-01-13 11:31:20','',''),(622,'1','307','1',1,'Retail Sale Id 617',501.60,0.00,0.00,0.66,63.36,'2023-01-13 11:34:50','',''),(623,'1','307','1',1,'Retail Sale Id 618',1550.40,0.00,0.00,2.04,195.84,'2023-01-13 12:01:27','',''),(624,'1','307','1',1,'Retail Sale Id 619',3997.60,0.00,0.00,5.26,504.96,'2023-01-13 12:06:19','',''),(625,'1','307','1',1,'Retail Sale Id 620',2302.80,0.00,0.00,3.03,290.88,'2023-01-13 12:11:05','',''),(626,'1','307','1',1,'Retail Sale Id 621',1998.80,0.00,0.00,2.63,252.48,'2023-01-13 13:22:27','',''),(627,'1','307','1',1,'Retail Sale Id 622',88750.00,0.00,0.00,125.00,5750.00,'2023-01-13 14:07:38','',''),(628,'1','307','1',1,'Retail Sale Id 623',2302.80,0.00,0.00,3.03,290.88,'2023-01-13 14:09:05','',''),(629,'1','307','1',1,'Retail Sale Id 624',2302.80,0.00,0.00,3.03,290.88,'2023-01-13 14:34:53','',''),(630,'1','307','1',1,'Retail Sale Id 625',3800.00,0.00,0.00,5.00,480.00,'2023-01-13 14:36:37','',''),(631,'1','307','1',1,'Retail Sale Id 626',798.00,0.00,0.00,1.05,100.80,'2023-01-13 14:51:16','',''),(632,'1','307','1',1,'Retail Sale Id 627',798.00,0.00,0.00,1.05,100.80,'2023-01-13 15:04:55','',''),(633,'1','307','1',1,'Retail Sale Id 628',9500.00,0.00,0.00,12.50,1200.00,'2023-01-13 16:18:17','',''),(634,'1','307','1',1,'Retail Sale Id 629',2302.80,0.00,0.00,3.03,290.88,'2023-01-13 16:27:49','',''),(635,'1','307','1',1,'Retail Sale Id 630',760.00,0.00,0.00,1.00,96.00,'2023-01-13 16:39:57','',''),(636,'1','307','1',1,'Retail Sale Id 631',1542.80,0.00,0.00,2.03,194.88,'2023-01-13 17:31:56','',''),(637,'1','307','1',1,'Retail Sale Id 632',2196.40,0.00,0.00,2.89,277.44,'2023-01-13 17:33:21','',''),(638,'1','307','1',1,'Retail Sale Id 633',9500.00,0.00,0.00,12.50,1200.00,'2023-01-13 17:39:16','',''),(639,'1','307','1',1,'Retail Sale Id 634',9500.00,0.00,0.00,12.50,1200.00,'2023-01-13 17:43:44','',''),(640,'1','307','1',1,'Retail Sale Id 635',2302.80,0.00,0.00,3.03,290.88,'2023-01-13 17:45:04','',''),(641,'1','307','1',1,'Retail Sale Id 636',1520.00,0.00,0.00,2.00,192.00,'2023-01-13 17:47:38','',''),(642,'1','307','1',1,'Retail Sale Id 636',2280.00,0.00,0.00,3.00,288.00,'2023-01-13 17:47:38','',''),(643,'1','307','1',1,'Retail Sale Id 637',2302.80,0.00,0.00,3.03,290.88,'2023-01-13 18:07:28','',''),(644,'1','307','1',1,'Retail Sale Id 638',5000.80,0.00,0.00,6.58,631.68,'2023-01-13 18:31:42','',''),(645,'1','307','1',1,'Retail Sale Id 639',3374.40,0.00,0.00,4.44,426.24,'2023-01-13 18:57:35','',''),(646,'1','307','1',1,'Retail Sale Id 640',1550.40,0.00,0.00,2.04,195.84,'2023-01-14 08:26:15','',''),(647,'1','307','1',1,'Retail Sale Id 641',7600.00,0.00,0.00,10.00,960.00,'2023-01-14 09:08:12','',''),(648,'1','307','1',1,'Retail Sale Id 642',9500.00,0.00,0.00,12.50,1200.00,'2023-01-14 09:10:59','',''),(649,'1','307','1',1,'Retail Sale Id 643',2302.80,0.00,0.00,3.03,290.88,'2023-01-14 09:12:57','',''),(650,'1','307','1',1,'Retail Sale Id 644',3040.00,0.00,0.00,4.00,384.00,'2023-01-14 09:32:10','',''),(651,'1','307','1',1,'Retail Sale Id 645',1520.00,0.00,0.00,2.00,192.00,'2023-01-14 09:36:37','',''),(652,'1','307','1',1,'Retail Sale Id 646',4598.00,0.00,0.00,6.05,580.80,'2023-01-14 10:40:05','',''),(653,'1','307','1',1,'Retail Sale Id 647',501.60,0.00,0.00,0.66,63.36,'2023-01-14 11:02:40','',''),(654,'1','307','1',1,'Retail Sale Id 648',9500.00,0.00,0.00,12.50,1200.00,'2023-01-14 11:06:13','',''),(655,'1','307','1',1,'Retail Sale Id 649',760.00,0.00,0.00,1.00,96.00,'2023-01-14 11:08:22','',''),(656,'1','307','1',1,'Retail Sale Id 650',3800.00,0.00,0.00,5.00,480.00,'2023-01-14 11:44:26','',''),(657,'1','307','1',1,'Retail Sale Id 651',35500.00,0.00,0.00,50.00,2300.00,'2023-01-14 11:46:53','',''),(658,'1','307','1',1,'Retail Sale Id 653',1497.20,0.00,0.00,1.97,189.12,'2023-01-14 11:51:14','',''),(659,'1','307','1',1,'Retail Sale Id 654',3800.00,0.00,0.00,5.00,480.00,'2023-01-14 11:54:00','',''),(660,'1','307','1',1,'Retail Sale Id 655',2302.80,0.00,0.00,3.03,290.88,'2023-01-14 12:00:05','',''),(661,'1','307','1',1,'Retail Sale Id 656',4560.00,0.00,0.00,6.00,576.00,'2023-01-14 12:11:19','',''),(662,'1','307','1',1,'Retail Sale Id 657',4598.00,0.00,0.00,6.05,580.80,'2023-01-14 12:56:13','',''),(663,'1','307','1',1,'Retail Sale Id 658',2302.80,0.00,0.00,3.03,290.88,'2023-01-14 13:20:19','',''),(664,'1','307','1',1,'Retail Sale Id 659',4598.00,0.00,0.00,6.05,580.80,'2023-01-14 13:37:09','',''),(665,'1','307','1',1,'Retail Sale Id 660',1550.40,0.00,0.00,2.04,195.84,'2023-01-14 13:38:43','',''),(666,'1','307','1',1,'Retail Sale Id 661',2302.80,0.00,0.00,3.03,290.88,'2023-01-14 13:50:00','',''),(667,'1','307','1',1,'Retail Sale Id 662',4598.00,0.00,0.00,6.05,580.80,'2023-01-14 13:55:03','',''),(668,'1','307','1',1,'Retail Sale Id 663',1497.20,0.00,0.00,1.97,189.12,'2023-01-14 14:15:34','',''),(669,'1','307','1',1,'Retail Sale Id 664',6102.80,0.00,0.00,8.03,770.88,'2023-01-14 14:24:41','',''),(670,'1','307','1',1,'Retail Sale Id 665',2302.80,0.00,0.00,3.03,290.88,'2023-01-14 14:38:54','',''),(671,'1','307','1',1,'Retail Sale Id 665',2302.80,0.00,0.00,3.03,290.88,'2023-01-14 14:38:54','',''),(672,'1','307','1',1,'Retail Sale Id 666',1497.20,0.00,0.00,1.97,189.12,'2023-01-14 15:12:08','',''),(673,'1','307','1',1,'Retail Sale Id 667',1603.60,0.00,0.00,2.11,202.56,'2023-01-14 15:13:42','',''),(674,'1','307','1',1,'Retail Sale Id 668',4598.00,0.00,0.00,6.05,580.80,'2023-01-14 15:53:16','',''),(675,'1','307','1',1,'Retail Sale Id 669',2302.80,0.00,0.00,3.03,290.88,'2023-01-14 15:55:36','',''),(676,'1','307','1',1,'Retail Sale Id 670',4598.00,0.00,0.00,6.05,580.80,'2023-01-14 15:57:29','',''),(677,'1','307','1',1,'Retail Sale Id 671',35500.00,0.00,0.00,50.00,2300.00,'2023-01-14 16:00:54','',''),(678,'1','307','1',1,'Retail Sale Id 672',7600.00,0.00,0.00,10.00,960.00,'2023-01-14 16:20:46','',''),(679,'1','307','1',1,'Retail Sale Id 673',1998.80,0.00,0.00,2.63,252.48,'2023-01-14 16:24:08','',''),(680,'1','307','1',1,'Retail Sale Id 674',4598.00,0.00,0.00,6.05,580.80,'2023-01-14 16:25:41','',''),(681,'1','307','1',1,'Retail Sale Id 675',1550.40,0.00,0.00,2.04,195.84,'2023-01-14 16:47:33','',''),(682,'1','307','1',1,'Retail Sale Id 676',4598.00,0.00,0.00,6.05,580.80,'2023-01-14 16:51:43','',''),(683,'1','307','1',1,'Retail Sale Id 677',9500.00,0.00,0.00,12.50,1200.00,'2023-01-14 16:53:54','',''),(684,'1','307','1',1,'Retail Sale Id 678',9500.00,0.00,0.00,12.50,1200.00,'2023-01-14 17:03:10','',''),(685,'1','307','1',1,'Retail Sale Id 679',2302.80,0.00,0.00,3.03,290.88,'2023-01-14 17:07:32','',''),(686,'1','307','1',1,'Retail Sale Id 680',71000.00,0.00,0.00,100.00,4600.00,'2023-01-14 17:09:17','',''),(687,'1','307','1',1,'Retail Sale Id 681',1550.40,0.00,0.00,2.04,195.84,'2023-01-14 17:16:45','',''),(688,'1','307','1',1,'Retail Sale Id 682',2302.80,0.00,0.00,3.03,290.88,'2023-01-14 17:20:17','',''),(689,'1','307','1',1,'Retail Sale Id 683',4499.20,0.00,0.00,5.92,568.32,'2023-01-14 17:29:29','',''),(690,'1','307','1',1,'Retail Sale Id 684',2302.80,0.00,0.00,3.03,290.88,'2023-01-14 17:49:12','',''),(691,'1','307','1',1,'Retail Sale Id 685',3047.60,0.00,0.00,4.01,384.96,'2023-01-14 17:56:09','',''),(692,'1','307','1',1,'Retail Sale Id 686',2796.80,0.00,0.00,3.68,353.28,'2023-01-14 17:57:12','',''),(693,'1','307','1',1,'Retail Sale Id 687',2302.80,0.00,0.00,3.03,290.88,'2023-01-14 18:00:08','',''),(694,'1','307','1',1,'Retail Sale Id 688',4598.00,0.00,0.00,6.05,580.80,'2023-01-14 18:18:41','',''),(695,'1','307','1',1,'Retail Sale Id 689',4598.00,0.00,0.00,6.05,580.80,'2023-01-14 18:21:19','',''),(696,'1','307','1',1,'Retail Sale Id 690',6551.20,0.00,0.00,8.62,827.52,'2023-01-14 19:00:50','',''),(697,'1','307','1',1,'Retail Sale Id 691',28500.00,0.00,0.00,37.50,3600.00,'2023-01-14 19:03:26','',''),(698,'1','307','1',1,'Retail Sale Id 692',174.80,0.00,0.00,0.23,22.08,'2023-01-14 19:12:20','',''),(699,'1','307','1',1,'Retail Sale Id 693',1998.80,0.00,0.00,2.63,252.48,'2023-01-15 07:24:56','',''),(700,'1','307','1',1,'Retail Sale Id 694',3800.00,0.00,0.00,5.00,480.00,'2023-01-15 08:01:46','',''),(701,'1','307','1',1,'Retail Sale Id 695',1520.00,0.00,0.00,2.00,192.00,'2023-01-15 08:11:03','',''),(702,'1','307','1',1,'Retail Sale Id 696',1003.20,0.00,0.00,1.32,126.72,'2023-01-15 09:07:56','',''),(703,'1','307','1',1,'Retail Sale Id 697',1497.20,0.00,0.00,1.97,189.12,'2023-01-15 09:10:07','',''),(704,'1','307','1',1,'Retail Sale Id 698',1801.20,0.00,0.00,2.37,227.52,'2023-01-15 09:28:26','',''),(705,'1','307','1',1,'Retail Sale Id 699',752.40,0.00,0.00,0.99,95.04,'2023-01-15 09:35:25','',''),(706,'1','307','1',1,'Retail Sale Id 700',1550.40,0.00,0.00,2.04,195.84,'2023-01-15 10:04:26','',''),(707,'1','307','1',1,'Retail Sale Id 701',2280.00,0.00,0.00,3.00,288.00,'2023-01-15 10:17:46','',''),(708,'1','307','1',1,'Retail Sale Id 701',2280.00,0.00,0.00,3.00,288.00,'2023-01-15 10:17:46','',''),(709,'1','307','1',1,'Retail Sale Id 702',9500.00,0.00,0.00,12.50,1200.00,'2023-01-15 10:40:38','',''),(710,'1','307','1',1,'Retail Sale Id 703',2500.40,0.00,0.00,3.29,315.84,'2023-01-15 10:41:46','',''),(711,'1','307','1',1,'Retail Sale Id 704',4598.00,0.00,0.00,6.05,580.80,'2023-01-15 10:44:31','',''),(712,'1','307','1',1,'Retail Sale Id 705',5000.80,0.00,0.00,6.58,631.68,'2023-01-15 11:11:15','',''),(713,'1','307','1',1,'Retail Sale Id 706',760.00,0.00,0.00,1.00,96.00,'2023-01-15 11:13:51','',''),(714,'1','307','1',1,'Retail Sale Id 707',4560.00,0.00,0.00,6.00,576.00,'2023-01-15 11:26:28','',''),(715,'1','307','1',1,'Retail Sale Id 708',2302.80,0.00,0.00,3.03,290.88,'2023-01-15 11:35:44','',''),(716,'1','307','1',1,'Retail Sale Id 710',7600.00,0.00,0.00,10.00,960.00,'2023-01-15 11:49:50','',''),(717,'1','307','1',1,'Retail Sale Id 711',2280.00,0.00,0.00,3.00,288.00,'2023-01-15 12:27:28','',''),(718,'1','307','1',1,'Retail Sale Id 712',1550.40,0.00,0.00,2.04,195.84,'2023-01-15 12:31:51','',''),(719,'1','307','1',1,'Retail Sale Id 713',2302.80,0.00,0.00,3.03,290.88,'2023-01-15 13:00:16','',''),(720,'1','307','1',1,'Retail Sale Id 714',1003.20,0.00,0.00,1.32,126.72,'2023-01-15 13:15:58','',''),(721,'1','307','1',1,'Retail Sale Id 715',9500.00,0.00,0.00,12.50,1200.00,'2023-01-15 13:17:46','',''),(722,'1','307','1',1,'Retail Sale Id 716',3002.00,0.00,0.00,3.95,379.20,'2023-01-15 13:27:10','',''),(723,'1','307','1',1,'Retail Sale Id 717',7600.00,0.00,0.00,10.00,960.00,'2023-01-15 13:33:02','',''),(724,'1','307','1',1,'Retail Sale Id 718',1520.00,0.00,0.00,2.00,192.00,'2023-01-15 13:51:01','',''),(725,'1','307','1',1,'Retail Sale Id 719',4560.00,0.00,0.00,6.00,576.00,'2023-01-15 13:52:29','',''),(726,'1','307','1',1,'Retail Sale Id 720',3040.00,0.00,0.00,4.00,384.00,'2023-01-15 13:54:17','',''),(727,'1','307','1',1,'Retail Sale Id 722',4598.00,0.00,0.00,6.05,580.80,'2023-01-15 13:56:14','',''),(728,'1','307','1',1,'Retail Sale Id 723',9500.00,0.00,0.00,12.50,1200.00,'2023-01-15 14:04:13','',''),(729,'1','307','1',1,'Retail Sale Id 724',9500.00,0.00,0.00,12.50,1200.00,'2023-01-15 14:24:20','',''),(730,'1','307','1',1,'Retail Sale Id 725',35500.00,0.00,0.00,50.00,2300.00,'2023-01-15 14:41:02','',''),(731,'1','307','1',1,'Retail Sale Id 726',2280.00,0.00,0.00,3.00,288.00,'2023-01-15 14:43:21','',''),(732,'1','307','1',1,'Retail Sale Id 726',3040.00,0.00,0.00,4.00,384.00,'2023-01-15 14:43:21','',''),(733,'1','307','1',1,'Retail Sale Id 727',9500.00,0.00,0.00,12.50,1200.00,'2023-01-15 15:23:57','',''),(734,'1','307','1',1,'Retail Sale Id 728',798.00,0.00,0.00,1.05,100.80,'2023-01-15 15:25:56','',''),(735,'1','307','1',1,'Retail Sale Id 729',3100.80,0.00,0.00,4.08,391.68,'2023-01-15 15:28:43','',''),(736,'1','307','1',1,'Retail Sale Id 730',3040.00,0.00,0.00,4.00,384.00,'2023-01-15 15:39:45','',''),(737,'1','307','1',1,'Retail Sale Id 731',3800.00,0.00,0.00,5.00,480.00,'2023-01-15 15:46:29','',''),(738,'1','307','1',1,'Retail Sale Id 732',3047.60,0.00,0.00,4.01,384.96,'2023-01-15 16:15:11','',''),(739,'1','307','1',1,'Retail Sale Id 733',2302.80,0.00,0.00,3.03,290.88,'2023-01-15 16:19:52','',''),(740,'1','307','1',1,'Retail Sale Id 734',1520.00,0.00,0.00,2.00,192.00,'2023-01-15 16:46:43','',''),(741,'1','307','1',1,'Retail Sale Id 735',3800.00,0.00,0.00,5.00,480.00,'2023-01-15 16:48:39','',''),(742,'1','307','1',1,'Retail Sale Id 736',3800.00,0.00,0.00,5.00,480.00,'2023-01-15 16:50:13','',''),(743,'1','307','1',1,'Retail Sale Id 737',2302.80,0.00,0.00,3.03,290.88,'2023-01-15 16:55:05','',''),(744,'1','307','1',1,'Retail Sale Id 738',1998.80,0.00,0.00,2.63,252.48,'2023-01-15 17:01:39','',''),(745,'1','307','1',1,'Retail Sale Id 739',1520.00,0.00,0.00,2.00,192.00,'2023-01-15 17:05:36','',''),(746,'1','307','1',1,'Retail Sale Id 740',3800.00,0.00,0.00,5.00,480.00,'2023-01-15 17:08:40','',''),(747,'1','307','1',1,'Retail Sale Id 741',4598.00,0.00,0.00,6.05,580.80,'2023-01-15 17:10:31','',''),(748,'1','307','1',1,'Retail Sale Id 742',9500.00,0.00,0.00,12.50,1200.00,'2023-01-15 17:29:51','',''),(749,'1','307','1',1,'Retail Sale Id 743',2302.80,0.00,0.00,3.03,290.88,'2023-01-15 17:34:26','',''),(750,'1','307','1',1,'Retail Sale Id 744',35500.00,0.00,0.00,50.00,2300.00,'2023-01-15 17:37:25','',''),(751,'1','307','1',1,'Retail Sale Id 745',2302.80,0.00,0.00,3.03,290.88,'2023-01-15 17:48:34','',''),(752,'1','307','1',1,'Retail Sale Id 746',4560.00,0.00,0.00,6.00,576.00,'2023-01-15 17:52:36','',''),(753,'1','307','1',1,'Retail Sale Id 747',4560.00,0.00,0.00,6.00,576.00,'2023-01-15 17:54:07','',''),(754,'1','307','1',1,'Retail Sale Id 748',3002.00,0.00,0.00,3.95,379.20,'2023-01-15 17:57:57','',''),(755,'1','307','1',1,'Retail Sale Id 749',1497.20,0.00,0.00,1.97,189.12,'2023-01-15 18:02:49','',''),(756,'1','307','1',1,'Retail Sale Id 750',3800.00,0.00,0.00,5.00,480.00,'2023-01-15 18:28:19','',''),(757,'1','307','1',1,'Retail Sale Id 751',1550.40,0.00,0.00,2.04,195.84,'2023-01-15 18:29:50','',''),(758,'1','307','1',1,'Retail Sale Id 752',1998.80,0.00,0.00,2.63,252.48,'2023-01-15 18:38:20','',''),(759,'1','307','1',1,'Retail Sale Id 753',9500.00,0.00,0.00,12.50,1200.00,'2023-01-15 18:43:51','',''),(760,'1','307','1',1,'Retail Sale Id 754',9500.00,0.00,0.00,12.50,1200.00,'2023-01-15 18:54:16','',''),(761,'1','307','1',1,'Retail Sale Id 755',2249.60,0.00,0.00,2.96,284.16,'2023-01-15 18:58:46','',''),(762,'1','307','1',1,'Retail Sale Id 756',4628.40,0.00,0.00,6.09,584.64,'2023-01-15 19:04:42','',''),(763,'1','307','1',1,'Return of Retail Sale Id 713',0.00,2302.80,3.03,0.00,-290.88,'2023-01-15 19:11:58','',''),(764,'1','307','1',1,'Retail Sale Id 757',4598.00,0.00,0.00,6.05,580.80,'2023-01-16 07:42:40','',''),(765,'1','307','1',1,'Retail Sale Id 759',88750.00,0.00,0.00,125.00,5750.00,'2023-01-16 08:16:55','',''),(766,'1','307','1',1,'Retail Sale Id 760',1520.00,0.00,0.00,2.00,192.00,'2023-01-16 08:34:34','',''),(767,'1','307','1',1,'Retail Sale Id 761',4560.00,0.00,0.00,6.00,576.00,'2023-01-16 08:37:47','',''),(768,'1','307','1',1,'Retail Sale Id 763',3047.60,0.00,0.00,4.01,384.96,'2023-01-16 09:06:03','',''),(769,'1','307','1',1,'Retail Sale Id 764',1520.00,0.00,0.00,2.00,192.00,'2023-01-16 09:07:30','',''),(770,'1','307','1',1,'Retail Sale Id 765',3040.00,0.00,0.00,4.00,384.00,'2023-01-16 10:03:40','',''),(771,'1','307','1',1,'Retail Sale Id 766',4598.00,0.00,0.00,6.05,580.80,'2023-01-16 10:22:45','',''),(772,'1','307','1',1,'Retail Sale Id 767',6080.00,0.00,0.00,8.00,768.00,'2023-01-16 10:24:32','',''),(773,'1','307','1',1,'Retail Sale Id 768',9500.00,0.00,0.00,12.50,1200.00,'2023-01-16 10:46:17','',''),(774,'1','307','1',1,'Retail Sale Id 769',9500.00,0.00,0.00,12.50,1200.00,'2023-01-16 10:47:27','',''),(775,'1','307','1',1,'Retail Sale Id 770',1520.00,0.00,0.00,2.00,192.00,'2023-01-16 11:26:26','',''),(776,'1','307','1',1,'Retail Sale Id 771',1480.00,0.00,0.00,2.00,152.00,'2023-01-16 12:10:28','',''),(777,'1','307','1',1,'Retail Sale Id 772',4447.40,0.00,0.00,6.01,456.76,'2023-01-16 12:19:01','',''),(778,'1','307','1',1,'Retail Sale Id 773',1502.20,0.00,0.00,2.03,154.28,'2023-01-16 13:37:09','',''),(779,'1','307','1',1,'Retail Sale Id 774',35500.00,0.00,0.00,50.00,2300.00,'2023-01-16 13:59:19','',''),(780,'1','307','1',1,'Retail Sale Id 775',9250.00,0.00,0.00,12.50,950.00,'2023-01-16 14:01:08','',''),(781,'1','307','1',1,'Retail Sale Id 776',1502.20,0.00,0.00,2.03,154.28,'2023-01-16 14:19:51','',''),(782,'1','307','1',1,'Retail Sale Id 777',4447.40,0.00,0.00,6.01,456.76,'2023-01-16 14:22:20','',''),(783,'1','307','1',1,'Retail Sale Id 778',2249.60,0.00,0.00,3.04,231.04,'2023-01-16 14:36:36','',''),(784,'1','307','1',1,'Retail Sale Id 779',999.00,0.00,0.00,1.35,102.60,'2023-01-16 14:47:25','',''),(785,'1','307','1',1,'Retail Sale Id 780',3700.00,0.00,0.00,5.00,380.00,'2023-01-16 14:50:03','',''),(786,'1','307','1',1,'Retail Sale Id 781',4447.40,0.00,0.00,6.01,456.76,'2023-01-16 14:56:21','',''),(787,'1','307','1',1,'Retail Sale Id 782',1502.20,0.00,0.00,2.03,154.28,'2023-01-16 14:58:20','',''),(788,'1','307','1',1,'Retail Sale Id 783',2249.60,0.00,0.00,3.04,231.04,'2023-01-16 15:09:45','',''),(789,'1','307','1',1,'Retail Sale Id 784',2249.60,0.00,0.00,3.04,231.04,'2023-01-16 15:30:53','',''),(790,'1','307','1',1,'Retail Sale Id 785',2997.00,0.00,0.00,4.05,307.80,'2023-01-16 15:32:18','',''),(791,'1','307','1',1,'Retail Sale Id 786',3700.00,0.00,0.00,5.00,380.00,'2023-01-16 15:50:51','',''),(792,'1','307','1',1,'Retail Sale Id 787',747.40,0.00,0.00,1.01,76.76,'2023-01-16 16:31:02','',''),(793,'1','307','1',1,'Retail Sale Id 788',740.00,0.00,0.00,1.00,76.00,'2023-01-16 16:52:31','',''),(794,'1','307','1',1,'Retail Sale Id 788',740.00,0.00,0.00,1.00,76.00,'2023-01-16 16:52:31','',''),(795,'1','307','1',1,'Retail Sale Id 789',35500.00,0.00,0.00,50.00,2300.00,'2023-01-16 17:05:09','',''),(796,'1','307','1',1,'Retail Sale Id 790',3700.00,0.00,0.00,5.00,380.00,'2023-01-16 17:13:32','',''),(797,'1','307','1',1,'Retail Sale Id 791',2197.80,0.00,0.00,2.97,225.72,'2023-01-16 17:14:54','',''),(798,'1','307','1',1,'Retail Sale Id 792',2960.00,0.00,0.00,4.00,304.00,'2023-01-16 17:20:54','',''),(799,'1','307','1',1,'Retail Sale Id 793',4447.40,0.00,0.00,6.01,456.76,'2023-01-16 17:22:26','',''),(800,'1','307','1',1,'Retail Sale Id 794',1998.00,0.00,0.00,2.70,205.20,'2023-01-16 17:30:18','',''),(801,'1','307','1',1,'Retail Sale Id 795',9250.00,0.00,0.00,12.50,950.00,'2023-01-16 17:50:24','',''),(802,'1','307','1',1,'Retail Sale Id 796',2249.60,0.00,0.00,3.04,231.04,'2023-01-16 18:10:40','',''),(803,'1','307','1',1,'Retail Sale Id 797',3700.00,0.00,0.00,5.00,380.00,'2023-01-16 18:12:18','',''),(804,'1','307','1',1,'Retail Sale Id 798',2960.00,0.00,0.00,4.00,304.00,'2023-01-16 18:22:24','',''),(805,'1','307','1',1,'Retail Sale Id 799',2960.00,0.00,0.00,4.00,304.00,'2023-01-16 18:31:22','',''),(806,'1','307','1',1,'Retail Sale Id 800',1480.00,0.00,0.00,2.00,152.00,'2023-01-16 18:59:27','',''),(807,'1','307','1',1,'Return of Retail Sale Id 800',0.00,1480.00,2.00,0.00,-152.00,'2023-01-16 19:06:47','',''),(808,'1','307','1',1,'Retail Sale Id 801',4447.40,0.00,0.00,6.01,456.76,'2023-01-17 08:22:45','',''),(809,'1','307','1',1,'Retail Sale Id 802',4447.40,0.00,0.00,6.01,456.76,'2023-01-17 08:34:25','',''),(810,'1','307','1',1,'Retail Sale Id 803',1998.00,0.00,0.00,2.70,205.20,'2023-01-17 08:54:33','',''),(811,'1','307','1',1,'Retail Sale Id 804',4499.20,0.00,0.00,6.08,462.08,'2023-01-17 08:55:28','',''),(812,'1','307','1',1,'Retail Sale Id 805',2301.40,0.00,0.00,3.11,236.36,'2023-01-17 08:57:03','',''),(813,'1','307','1',1,'Retail Sale Id 806',4447.40,0.00,0.00,6.01,456.76,'2023-01-17 09:00:57','',''),(814,'1','307','1',1,'Retail Sale Id 807',4447.40,0.00,0.00,6.01,456.76,'2023-01-17 09:02:44','',''),(815,'1','307','1',1,'Retail Sale Id 808',2997.00,0.00,0.00,4.05,307.80,'2023-01-17 09:21:11','',''),(816,'1','307','1',1,'Retail Sale Id 809',4447.40,0.00,0.00,6.01,456.76,'2023-01-17 09:24:51','',''),(817,'1','307','1',1,'Retail Sale Id 810',2997.00,0.00,0.00,4.05,307.80,'2023-01-17 09:29:24','',''),(818,'1','307','1',1,'Retail Sale Id 811',4447.40,0.00,0.00,6.01,456.76,'2023-01-17 09:34:55','',''),(819,'1','307','1',1,'Retail Sale Id 812',2249.60,0.00,0.00,3.04,231.04,'2023-01-17 09:45:00','',''),(820,'1','307','1',1,'Retail Sale Id 813',3700.00,0.00,0.00,5.00,380.00,'2023-01-17 10:17:13','',''),(821,'1','307','1',1,'Retail Sale Id 814',9250.00,0.00,0.00,12.50,950.00,'2023-01-17 10:18:54','',''),(822,'1','307','1',1,'Retail Sale Id 815',4447.40,0.00,0.00,6.01,456.76,'2023-01-17 10:33:59','',''),(823,'1','307','1',1,'Retail Sale Id 816',7400.00,0.00,0.00,10.00,760.00,'2023-01-17 10:45:17','',''),(824,'1','307','1',1,'Retail Sale Id 817',740.00,0.00,0.00,1.00,76.00,'2023-01-17 10:55:24','',''),(825,'1','307','1',1,'Retail Sale Id 818',2212.60,0.00,0.00,2.99,227.24,'2023-01-17 10:59:04','',''),(826,'1','307','1',1,'Retail Sale Id 819',2249.60,0.00,0.00,3.04,231.04,'2023-01-17 11:25:26','',''),(827,'1','307','1',1,'Retail Sale Id 820',4447.40,0.00,0.00,6.01,456.76,'2023-01-17 11:28:48','',''),(828,'1','307','1',1,'Retail Sale Id 821',740.00,0.00,0.00,1.00,76.00,'2023-01-17 12:18:58','',''),(829,'1','307','1',1,'Retail Sale Id 822',9250.00,0.00,0.00,12.50,950.00,'2023-01-17 12:19:51','',''),(830,'1','307','1',1,'Retail Sale Id 823',3700.00,0.00,0.00,5.00,380.00,'2023-01-17 12:34:05','',''),(831,'1','307','1',1,'Retail Sale Id 824',88750.00,0.00,0.00,125.00,5750.00,'2023-01-17 12:55:12','',''),(832,'1','307','1',1,'Retail Sale Id 825',9250.00,0.00,0.00,12.50,950.00,'2023-01-17 13:10:32','',''),(833,'1','307','1',1,'Retail Sale Id 826',2249.60,0.00,0.00,3.04,231.04,'2023-01-17 13:22:05','',''),(834,'1','307','1',1,'Retail Sale Id 827',1480.00,0.00,0.00,2.00,152.00,'2023-01-17 13:55:49','',''),(835,'1','307','1',1,'Retail Sale Id 828',3700.00,0.00,0.00,5.00,380.00,'2023-01-17 14:21:42','',''),(836,'1','307','1',1,'Retail Sale Id 828',3700.00,0.00,0.00,5.00,380.00,'2023-01-17 14:21:42','',''),(837,'1','307','1',1,'Retail Sale Id 829',2960.00,0.00,0.00,4.00,304.00,'2023-01-17 14:24:29','',''),(838,'1','307','1',1,'Retail Sale Id 830',4440.00,0.00,0.00,6.00,456.00,'2023-01-17 15:41:29','',''),(839,'1','307','1',1,'Retail Sale Id 831',7400.00,0.00,0.00,10.00,760.00,'2023-01-17 16:13:02','',''),(840,'1','307','1',1,'Retail Sale Id 832',2249.60,0.00,0.00,3.04,231.04,'2023-01-17 16:16:25','',''),(841,'1','307','1',1,'Retail Sale Id 833',503.20,0.00,0.00,0.68,51.68,'2023-01-17 16:19:58','',''),(842,'1','307','1',1,'Retail Sale Id 834',1502.20,0.00,0.00,2.03,154.28,'2023-01-17 16:31:31','',''),(843,'1','307','1',1,'Retail Sale Id 835',2249.60,0.00,0.00,3.04,231.04,'2023-01-17 17:12:35','',''),(844,'1','307','1',1,'Retail Sale Id 836',2220.00,0.00,0.00,3.00,228.00,'2023-01-17 17:17:33','',''),(845,'1','307','1',1,'Retail Sale Id 837',4440.00,0.00,0.00,6.00,456.00,'2023-01-17 17:19:32','',''),(846,'1','307','1',1,'Retail Sale Id 837',4440.00,0.00,0.00,6.00,456.00,'2023-01-17 17:19:32','',''),(847,'1','307','1',1,'Retail Sale Id 838',1502.20,0.00,0.00,2.03,154.28,'2023-01-17 17:21:17','',''),(848,'1','307','1',1,'Retail Sale Id 839',2220.00,0.00,0.00,3.00,228.00,'2023-01-17 17:24:53','',''),(849,'1','307','1',1,'Retail Sale Id 840',747.40,0.00,0.00,1.01,76.76,'2023-01-17 17:38:08','',''),(850,'1','307','1',1,'Retail Sale Id 841',2220.00,0.00,0.00,3.00,228.00,'2023-01-17 17:39:16','',''),(851,'1','307','1',1,'Retail Sale Id 842',5002.40,0.00,0.00,6.76,513.76,'2023-01-17 17:45:30','',''),(852,'1','307','1',1,'Retail Sale Id 843',4447.40,0.00,0.00,6.01,456.76,'2023-01-17 17:51:59','',''),(853,'1','307','1',1,'Retail Sale Id 844',747.40,0.00,0.00,1.01,76.76,'2023-01-17 18:04:02','',''),(854,'1','307','1',1,'Retail Sale Id 845',2220.00,0.00,0.00,3.00,228.00,'2023-01-17 18:12:18','',''),(855,'1','307','1',1,'Retail Sale Id 846',4092.20,0.00,0.00,5.53,420.28,'2023-01-17 18:56:24','',''),(856,'1','307','1',1,'Retail Sale Id 847',4447.40,0.00,0.00,6.01,456.76,'2023-01-18 07:32:07','',''),(857,'1','307','1',1,'Retail Sale Id 848',3700.00,0.00,0.00,5.00,380.00,'2023-01-18 08:15:01','',''),(858,'1','307','1',1,'Retail Sale Id 849',4499.20,0.00,0.00,6.08,462.08,'2023-01-18 08:22:22','',''),(859,'1','307','1',1,'Retail Sale Id 850',4447.40,0.00,0.00,6.01,456.76,'2023-01-18 08:29:37','',''),(860,'1','307','1',1,'Retail Sale Id 851',2997.00,0.00,0.00,4.05,307.80,'2023-01-18 09:26:44','',''),(861,'1','307','1',1,'Retail Sale Id 852',3700.00,0.00,0.00,5.00,380.00,'2023-01-18 09:29:06','',''),(862,'1','307','1',1,'Retail Sale Id 853',2301.40,0.00,0.00,3.11,236.36,'2023-01-18 09:36:51','',''),(863,'1','307','1',1,'Retail Sale Id 854',2997.00,0.00,0.00,4.05,307.80,'2023-01-18 09:49:38','',''),(864,'1','307','1',1,'Retail Sale Id 855',3700.00,0.00,0.00,5.00,380.00,'2023-01-18 10:15:13','',''),(865,'1','307','1',1,'Retail Sale Id 856',4003.40,0.00,0.00,5.41,411.16,'2023-01-18 10:21:08','',''),(866,'1','307','1',1,'Retail Sale Id 857',9250.00,0.00,0.00,12.50,950.00,'2023-01-18 10:38:07','',''),(867,'1','307','1',1,'Retail Sale Id 858',2220.00,0.00,0.00,3.00,228.00,'2023-01-18 10:47:43','',''),(868,'1','307','1',1,'Retail Sale Id 859',4440.00,0.00,0.00,6.00,456.00,'2023-01-18 10:53:39','',''),(869,'1','307','1',1,'Retail Sale Id 860',4499.20,0.00,0.00,6.08,462.08,'2023-01-18 11:03:50','',''),(870,'1','307','1',1,'Retail Sale Id 861',2220.00,0.00,0.00,3.00,228.00,'2023-01-18 11:08:03','',''),(871,'1','307','1',1,'Retail Sale Id 862',1480.00,0.00,0.00,2.00,152.00,'2023-01-18 11:09:45','',''),(872,'1','307','1',1,'Retail Sale Id 863',2220.00,0.00,0.00,3.00,228.00,'2023-01-18 11:10:55','',''),(873,'1','307','1',1,'Retail Sale Id 864',4499.20,0.00,0.00,6.08,462.08,'2023-01-18 11:22:53','',''),(874,'1','307','1',1,'Retail Sale Id 865',9250.00,0.00,0.00,12.50,950.00,'2023-01-18 11:27:58','',''),(875,'1','307','1',1,'Retail Sale Id 866',2997.00,0.00,0.00,4.05,307.80,'2023-01-18 11:29:06','',''),(876,'1','307','1',1,'Retail Sale Id 867',4440.00,0.00,0.00,6.00,456.00,'2023-01-18 11:34:48','',''),(877,'1','307','1',1,'Retail Sale Id 868',2220.00,0.00,0.00,3.00,228.00,'2023-01-18 11:51:30','',''),(878,'1','307','1',1,'Retail Sale Id 869',4499.20,0.00,0.00,6.08,462.08,'2023-01-18 12:10:42','',''),(879,'1','307','1',1,'Retail Sale Id 870',2301.40,0.00,0.00,3.11,236.36,'2023-01-18 12:14:12','',''),(880,'1','307','1',1,'Retail Sale Id 871',2960.00,0.00,0.00,4.00,304.00,'2023-01-18 12:22:34','',''),(881,'1','307','1',1,'Retail Sale Id 872',3700.00,0.00,0.00,5.00,380.00,'2023-01-18 13:04:53','',''),(882,'1','307','1',1,'Retail Sale Id 873',2249.60,0.00,0.00,3.04,231.04,'2023-01-18 13:53:41','',''),(883,'1','307','1',1,'Retail Sale Id 874',2249.60,0.00,0.00,3.04,231.04,'2023-01-18 14:48:21','',''),(884,'1','307','1',1,'Retail Sale Id 875',799.20,0.00,0.00,1.08,82.08,'2023-01-18 15:22:12','',''),(885,'1','307','1',1,'Retail Sale Id 876',3700.00,0.00,0.00,5.00,380.00,'2023-01-18 15:38:46','',''),(886,'1','307','1',1,'Retail Sale Id 877',4447.40,0.00,0.00,6.01,456.76,'2023-01-18 15:45:17','',''),(887,'1','307','1',1,'Retail Sale Id 878',1998.00,0.00,0.00,2.70,205.20,'2023-01-18 16:08:55','',''),(888,'1','307','1',1,'Retail Sale Id 879',3700.00,0.00,0.00,5.00,380.00,'2023-01-18 16:11:03','',''),(889,'1','307','1',1,'Retail Sale Id 880',3100.60,0.00,0.00,4.19,318.44,'2023-01-18 16:13:00','',''),(890,'1','307','1',1,'Retail Sale Id 881',2249.60,0.00,0.00,3.04,231.04,'2023-01-18 16:20:32','',''),(891,'1','307','1',1,'Retail Sale Id 882',3700.00,0.00,0.00,5.00,380.00,'2023-01-18 16:33:21','',''),(892,'1','307','1',1,'Retail Sale Id 883',4440.00,0.00,0.00,6.00,456.00,'2023-01-18 16:43:32','',''),(893,'1','307','1',1,'Retail Sale Id 884',1502.20,0.00,0.00,2.03,154.28,'2023-01-18 16:46:25','',''),(894,'1','307','1',1,'Retail Sale Id 885',1480.00,0.00,0.00,2.00,152.00,'2023-01-18 17:05:09','',''),(895,'1','307','1',1,'Retail Sale Id 886',740.00,0.00,0.00,1.00,76.00,'2023-01-18 17:08:42','',''),(896,'1','307','1',1,'Retail Sale Id 886',740.00,0.00,0.00,1.00,76.00,'2023-01-18 17:08:42','',''),(897,'1','307','1',1,'Retail Sale Id 887',4447.40,0.00,0.00,6.01,456.76,'2023-01-18 17:23:01','',''),(898,'1','307','1',1,'Retail Sale Id 888',4447.40,0.00,0.00,6.01,456.76,'2023-01-18 17:27:06','',''),(899,'1','307','1',1,'Retail Sale Id 889',1502.20,0.00,0.00,2.03,154.28,'2023-01-18 17:28:23','',''),(900,'1','307','1',1,'Retail Sale Id 890',1480.00,0.00,0.00,2.00,152.00,'2023-01-18 17:33:22','',''),(901,'1','307','1',1,'Retail Sale Id 891',2501.20,0.00,0.00,3.38,256.88,'2023-01-18 17:36:13','',''),(902,'1','307','1',1,'Retail Sale Id 892',4499.20,0.00,0.00,6.08,462.08,'2023-01-18 17:42:42','',''),(903,'1','307','1',1,'Retail Sale Id 893',9250.00,0.00,0.00,12.50,950.00,'2023-01-18 17:48:21','',''),(904,'1','307','1',1,'Retail Sale Id 894',1998.00,0.00,0.00,2.70,205.20,'2023-01-18 18:08:39','',''),(905,'1','307','1',1,'Retail Sale Id 894',2997.00,0.00,0.00,4.05,307.80,'2023-01-18 18:08:39','',''),(906,'1','307','1',1,'Retail Sale Id 896',5002.40,0.00,0.00,6.76,513.76,'2023-01-18 18:10:58','',''),(907,'1','307','1',1,'Retail Sale Id 897',6001.40,0.00,0.00,8.11,616.36,'2023-01-18 18:25:40','',''),(908,'1','307','1',1,'Retail Sale Id 898',3500.20,0.00,0.00,4.73,359.48,'2023-01-18 18:27:39','',''),(909,'1','307','1',1,'Retail Sale Id 899',7400.00,0.00,0.00,10.00,760.00,'2023-01-18 18:28:58','',''),(910,'1','307','1',1,'Retail Sale Id 900',2501.20,0.00,0.00,3.38,256.88,'2023-01-18 18:51:49','',''),(911,'1','307','1',1,'Retail Sale Id 901',9028.00,0.00,0.00,12.20,927.20,'2023-01-18 18:57:30','',''),(912,'1','307','1',1,'Retail Sale Id 902',4499.20,0.00,0.00,6.08,462.08,'2023-01-19 08:09:17','',''),(913,'1','307','1',1,'Retail Sale Id 903',4499.20,0.00,0.00,6.08,462.08,'2023-01-19 08:12:28','',''),(914,'1','307','1',1,'Retail Sale Id 904',5920.00,0.00,0.00,8.00,608.00,'2023-01-19 08:14:57','',''),(915,'1','307','1',1,'Retail Sale Id 905',999.00,0.00,0.00,1.35,102.60,'2023-01-19 08:36:02','',''),(916,'1','307','1',1,'Retail Sale Id 906',2249.60,0.00,0.00,3.04,231.04,'2023-01-19 08:39:26','',''),(917,'1','307','1',1,'Retail Sale Id 907',9250.00,0.00,0.00,12.50,950.00,'2023-01-19 08:44:21','',''),(918,'1','307','1',1,'Retail Sale Id 908',2249.60,0.00,0.00,3.04,231.04,'2023-01-19 08:46:51','',''),(919,'1','307','1',1,'Retail Sale Id 909',2197.80,0.00,0.00,2.97,225.72,'2023-01-19 08:54:43','',''),(920,'1','307','1',1,'Retail Sale Id 910',4440.00,0.00,0.00,6.00,456.00,'2023-01-19 09:22:20','',''),(921,'1','307','1',1,'Retail Sale Id 911',7999.40,0.00,0.00,10.81,821.56,'2023-01-19 09:33:23','',''),(922,'1','307','1',1,'Retail Sale Id 912',7503.60,0.00,0.00,10.14,770.64,'2023-01-19 09:33:58','',''),(923,'1','307','1',1,'Retail Sale Id 913',3700.00,0.00,0.00,5.00,380.00,'2023-01-19 09:40:37','',''),(924,'1','307','1',1,'Retail Sale Id 913',9250.00,0.00,0.00,12.50,950.00,'2023-01-19 09:40:37','',''),(925,'1','307','1',1,'Retail Sale Id 914',7400.00,0.00,0.00,10.00,760.00,'2023-01-19 09:42:48','',''),(926,'1','307','1',1,'Retail Sale Id 915',3700.00,0.00,0.00,5.00,380.00,'2023-01-19 10:28:28','',''),(927,'1','307','1',1,'Retail Sale Id 917',4417.80,0.00,0.00,5.97,453.72,'2023-01-19 10:37:04','',''),(928,'1','307','1',1,'Retail Sale Id 918',4440.00,0.00,0.00,6.00,456.00,'2023-01-19 11:36:15','',''),(929,'1','307','1',1,'Retail Sale Id 919',1502.20,0.00,0.00,2.03,154.28,'2023-01-19 11:52:11','',''),(930,'1','307','1',1,'Retail Sale Id 920',1998.00,0.00,0.00,2.70,205.20,'2023-01-19 12:32:07','',''),(931,'1','307','1',1,'Retail Sale Id 921',3700.00,0.00,0.00,5.00,380.00,'2023-01-19 12:33:18','',''),(932,'1','307','1',1,'Retail Sale Id 922',3700.00,0.00,0.00,5.00,380.00,'2023-01-19 12:34:59','',''),(933,'1','307','1',1,'Retail Sale Id 923',1502.20,0.00,0.00,2.03,154.28,'2023-01-19 12:36:33','',''),(934,'1','307','1',1,'Retail Sale Id 924',4447.40,0.00,0.00,6.01,456.76,'2023-01-19 13:37:14','',''),(935,'1','307','1',1,'Retail Sale Id 925',2249.60,0.00,0.00,3.04,231.04,'2023-01-19 13:49:28','',''),(936,'1','307','1',1,'Retail Sale Id 926',2197.80,0.00,0.00,2.97,225.72,'2023-01-19 13:53:33','',''),(937,'1','307','1',1,'Retail Sale Id 927',2249.60,0.00,0.00,3.04,231.04,'2023-01-19 13:56:22','',''),(938,'1','307','1',1,'Retail Sale Id 928',2301.40,0.00,0.00,3.11,236.36,'2023-01-19 14:36:19','',''),(939,'1','307','1',1,'Retail Sale Id 928',7400.00,0.00,0.00,10.00,760.00,'2023-01-19 14:36:19','',''),(940,'1','307','1',1,'Retail Sale Id 929',4447.40,0.00,0.00,6.01,456.76,'2023-01-19 14:49:53','',''),(941,'1','307','1',1,'Retail Sale Id 930',3700.00,0.00,0.00,5.00,380.00,'2023-01-19 15:04:49','',''),(942,'1','307','1',1,'Retail Sale Id 931',5920.00,0.00,0.00,8.00,608.00,'2023-01-19 15:29:09','',''),(943,'1','307','1',1,'Retail Sale Id 932',5002.40,0.00,0.00,6.76,513.76,'2023-01-19 16:05:09','',''),(944,'1','307','1',1,'Retail Sale Id 933',1502.20,0.00,0.00,2.03,154.28,'2023-01-19 16:37:53','',''),(945,'1','307','1',1,'Retail Sale Id 934',9250.00,0.00,0.00,12.50,950.00,'2023-01-19 16:52:17','',''),(946,'1','307','1',1,'Retail Sale Id 935',88750.00,0.00,0.00,125.00,5750.00,'2023-01-19 16:57:28','',''),(947,'1','307','1',1,'Retail Sale Id 936',2960.00,0.00,0.00,4.00,304.00,'2023-01-19 16:59:16','',''),(948,'1','307','1',1,'Retail Sale Id 937',5180.00,0.00,0.00,7.00,532.00,'2023-01-19 17:12:12','',''),(949,'1','307','1',1,'Retail Sale Id 938',1502.20,0.00,0.00,2.03,154.28,'2023-01-19 17:43:10','',''),(950,'1','307','1',1,'Retail Sale Id 939',2397.60,0.00,0.00,3.24,246.24,'2023-01-19 17:49:38','',''),(951,'1','307','1',1,'Retail Sale Id 940',4499.20,0.00,0.00,6.08,462.08,'2023-01-19 17:56:05','',''),(952,'1','307','1',1,'Retail Sale Id 941',2249.60,0.00,0.00,3.04,231.04,'2023-01-19 18:02:23','',''),(953,'1','307','1',1,'Retail Sale Id 942',2249.60,0.00,0.00,3.04,231.04,'2023-01-19 18:09:44','',''),(954,'1','307','1',1,'Retail Sale Id 943',2220.00,0.00,0.00,3.00,228.00,'2023-01-19 18:10:57','',''),(955,'1','307','1',1,'Retail Sale Id 944',4440.00,0.00,0.00,6.00,456.00,'2023-01-19 18:12:44','',''),(956,'1','307','1',1,'Retail Sale Id 945',2197.80,0.00,0.00,2.97,225.72,'2023-01-19 18:14:37','',''),(957,'1','307','1',1,'Retail Sale Id 946',4440.00,0.00,0.00,6.00,456.00,'2023-01-19 18:17:35','',''),(958,'1','307','1',1,'Retail Sale Id 947',3700.00,0.00,0.00,5.00,380.00,'2023-01-19 18:26:01','',''),(959,'1','307','1',1,'Retail Sale Id 947',4440.00,0.00,0.00,6.00,456.00,'2023-01-19 18:26:01','',''),(960,'1','307','1',1,'Retail Sale Id 948',9250.00,0.00,0.00,12.50,950.00,'2023-01-19 18:28:31','',''),(961,'1','307','1',1,'Retail Sale Id 949',2997.00,0.00,0.00,4.05,307.80,'2023-01-19 18:35:24','',''),(962,'1','307','1',1,'Retail Sale Id 950',3663.00,0.00,0.00,4.95,376.20,'2023-01-19 19:00:29','',''),(963,'1','307','1',1,'Retail Sale Id 951',1998.00,0.00,0.00,2.70,205.20,'2023-01-20 08:18:16','',''),(964,'1','307','1',1,'Retail Sale Id 952',5002.40,0.00,0.00,6.76,513.76,'2023-01-20 08:57:02','',''),(965,'1','307','1',1,'Retail Sale Id 953',1502.20,0.00,0.00,2.03,154.28,'2023-01-20 08:58:31','',''),(966,'1','307','1',1,'Retail Sale Id 954',3700.00,0.00,0.00,5.00,380.00,'2023-01-20 09:19:57','',''),(967,'1','307','1',1,'Retail Sale Id 955',9250.00,0.00,0.00,12.50,950.00,'2023-01-20 10:22:59','',''),(968,'1','307','1',1,'Retail Sale Id 956',4447.40,0.00,0.00,6.01,456.76,'2023-01-20 10:46:58','',''),(969,'1','307','1',1,'Retail Sale Id 957',4447.40,0.00,0.00,6.01,456.76,'2023-01-20 10:57:49','',''),(970,'1','307','1',1,'Retail Sale Id 958',2249.60,0.00,0.00,3.04,231.04,'2023-01-20 11:02:14','',''),(971,'1','307','1',1,'Retail Sale Id 959',4447.40,0.00,0.00,6.01,456.76,'2023-01-20 11:10:13','',''),(972,'1','307','1',1,'Retail Sale Id 960',1502.20,0.00,0.00,2.03,154.28,'2023-01-20 11:11:34','',''),(973,'1','307','1',1,'Retail Sale Id 961',3700.00,0.00,0.00,5.00,380.00,'2023-01-20 11:13:58','',''),(974,'1','307','1',1,'Retail Sale Id 962',747.40,0.00,0.00,1.01,76.76,'2023-01-20 11:16:16','',''),(975,'1','307','1',1,'Retail Sale Id 963',27995.30,0.00,0.00,39.43,1813.78,'2023-01-20 11:30:29','',''),(976,'1','307','1',1,'Retail Sale Id 964',3700.00,0.00,0.00,5.00,380.00,'2023-01-20 12:02:09','',''),(977,'1','307','1',1,'Retail Sale Id 965',2997.00,0.00,0.00,4.05,307.80,'2023-01-20 12:13:39','',''),(978,'1','307','1',1,'Retail Sale Id 966',3700.00,0.00,0.00,5.00,380.00,'2023-01-20 14:20:57','',''),(979,'1','307','1',1,'Retail Sale Id 967',2997.00,0.00,0.00,4.05,307.80,'2023-01-20 15:41:07','',''),(980,'1','307','1',1,'Retail Sale Id 968',1502.20,0.00,0.00,2.03,154.28,'2023-01-20 15:56:13','',''),(981,'1','307','1',1,'Retail Sale Id 969',5202.20,0.00,0.00,7.03,534.28,'2023-01-20 16:18:03','',''),(982,'1','307','1',1,'Retail Sale Id 970',4440.00,0.00,0.00,6.00,456.00,'2023-01-20 16:19:24','',''),(983,'1','307','1',1,'Retail Sale Id 971',2220.00,0.00,0.00,3.00,228.00,'2023-01-20 16:21:38','',''),(984,'1','307','1',1,'Retail Sale Id 972',35500.00,0.00,0.00,50.00,2300.00,'2023-01-20 16:26:05','',''),(985,'1','307','1',1,'Retail Sale Id 973',5002.40,0.00,0.00,6.76,513.76,'2023-01-20 16:38:25','',''),(986,'1','307','1',1,'Retail Sale Id 974',6697.00,0.00,0.00,9.05,687.80,'2023-01-20 16:40:29','',''),(987,'1','307','1',1,'Retail Sale Id 975',9250.00,0.00,0.00,12.50,950.00,'2023-01-20 17:12:10','',''),(988,'1','307','1',1,'Retail Sale Id 976',3700.00,0.00,0.00,5.00,380.00,'2023-01-20 17:21:09','',''),(989,'1','307','1',1,'Retail Sale Id 977',2220.00,0.00,0.00,3.00,228.00,'2023-01-20 17:22:22','',''),(990,'1','307','1',1,'Retail Sale Id 978',2249.60,0.00,0.00,3.04,231.04,'2023-01-20 17:23:34','',''),(991,'1','307','1',1,'Retail Sale Id 979',999.00,0.00,0.00,1.35,102.60,'2023-01-20 17:24:41','',''),(992,'1','307','1',1,'Retail Sale Id 980',747.40,0.00,0.00,1.01,76.76,'2023-01-20 17:32:15','',''),(993,'1','307','1',1,'Retail Sale Id 981',3700.00,0.00,0.00,5.00,380.00,'2023-01-20 17:38:43','',''),(994,'1','307','1',1,'Retail Sale Id 982',740.00,0.00,0.00,1.00,76.00,'2023-01-20 17:42:17','',''),(995,'1','307','1',1,'Retail Sale Id 983',9250.00,0.00,0.00,12.50,950.00,'2023-01-20 17:43:44','',''),(996,'1','307','1',1,'Retail Sale Id 984',2220.00,0.00,0.00,3.00,228.00,'2023-01-20 18:10:14','',''),(997,'1','307','1',1,'Retail Sale Id 985',4440.00,0.00,0.00,6.00,456.00,'2023-01-20 18:28:25','',''),(998,'1','307','1',1,'Retail Sale Id 986',3485.40,0.00,0.00,4.71,357.96,'2023-01-20 18:57:13','',''),(999,'1','307','1',1,'Retail Sale Id 987',4447.40,0.00,0.00,6.01,456.76,'2023-01-21 07:44:26','',''),(1000,'1','307','1',1,'Retail Sale Id 988',2220.00,0.00,0.00,3.00,228.00,'2023-01-21 07:55:58','',''),(1001,'1','307','1',1,'Retail Sale Id 989',1998.00,0.00,0.00,2.70,205.20,'2023-01-21 08:12:05','',''),(1002,'1','307','1',1,'Retail Sale Id 990',2220.00,0.00,0.00,3.00,228.00,'2023-01-21 08:15:43','',''),(1003,'1','307','1',1,'Retail Sale Id 991',2997.00,0.00,0.00,4.05,307.80,'2023-01-21 08:19:19','',''),(1004,'1','307','1',1,'Retail Sale Id 992',9250.00,0.00,0.00,12.50,950.00,'2023-01-21 08:35:24','',''),(1005,'1','307','1',1,'Retail Sale Id 993',2220.00,0.00,0.00,3.00,228.00,'2023-01-21 08:36:43','',''),(1006,'1','307','1',1,'Retail Sale Id 994',2301.40,0.00,0.00,3.11,236.36,'2023-01-21 08:48:18','',''),(1007,'1','307','1',1,'Retail Sale Id 995',4447.40,0.00,0.00,6.01,456.76,'2023-01-21 09:04:43','',''),(1008,'1','307','1',1,'Retail Sale Id 996',1502.20,0.00,0.00,2.03,154.28,'2023-01-21 09:06:11','',''),(1009,'1','307','1',1,'Retail Sale Id 997',2997.00,0.00,0.00,4.05,307.80,'2023-01-21 09:15:44','',''),(1010,'1','307','1',1,'Retail Sale Id 998',2227.40,0.00,0.00,3.01,228.76,'2023-01-21 09:21:19','',''),(1011,'1','307','1',1,'Retail Sale Id 999',2220.00,0.00,0.00,3.00,228.00,'2023-01-21 09:33:59','',''),(1012,'1','307','1',1,'Retail Sale Id 1000',2960.00,0.00,0.00,4.00,304.00,'2023-01-21 09:38:44','',''),(1013,'1','307','1',1,'Retail Sale Id 1001',4440.00,0.00,0.00,6.00,456.00,'2023-01-21 09:57:48','',''),(1014,'1','307','1',1,'Retail Sale Id 1001',9250.00,0.00,0.00,12.50,950.00,'2023-01-21 09:57:48','',''),(1015,'1','307','1',1,'Retail Sale Id 1002',2220.00,0.00,0.00,3.00,228.00,'2023-01-21 10:12:45','',''),(1016,'1','307','1',1,'Retail Sale Id 1003',2501.20,0.00,0.00,3.38,256.88,'2023-01-21 10:16:03','',''),(1017,'1','307','1',1,'Retail Sale Id 1004',7400.00,0.00,0.00,10.00,760.00,'2023-01-21 10:37:03','',''),(1018,'1','307','1',1,'Retail Sale Id 1005',88750.00,0.00,0.00,125.00,5750.00,'2023-01-21 10:52:13','',''),(1019,'1','307','1',1,'Retail Sale Id 1006',2997.00,0.00,0.00,4.05,307.80,'2023-01-21 11:08:50','',''),(1020,'1','307','1',1,'Retail Sale Id 1007',9250.00,0.00,0.00,12.50,950.00,'2023-01-21 11:30:13','',''),(1021,'1','307','1',1,'Retail Sale Id 1008',2997.00,0.00,0.00,4.05,307.80,'2023-01-21 11:33:29','',''),(1022,'1','307','1',1,'Retail Sale Id 1009',2220.00,0.00,0.00,3.00,228.00,'2023-01-21 11:58:27','',''),(1023,'1','307','1',1,'Retail Sale Id 1009',2960.00,0.00,0.00,4.00,304.00,'2023-01-21 11:58:27','',''),(1024,'1','307','1',1,'Retail Sale Id 1010',13697.40,0.00,0.00,18.51,1406.76,'2023-01-21 12:37:14','',''),(1025,'1','307','1',1,'Retail Sale Id 1011',2220.00,0.00,0.00,3.00,228.00,'2023-01-21 12:47:26','',''),(1026,'1','307','1',1,'Retail Sale Id 1012',2249.60,0.00,0.00,3.04,231.04,'2023-01-21 12:54:58','',''),(1027,'1','307','1',1,'Retail Sale Id 1013',11499.60,0.00,0.00,15.54,1181.04,'2023-01-21 13:00:15','',''),(1028,'1','307','1',1,'Retail Sale Id 1014',4440.00,0.00,0.00,6.00,456.00,'2023-01-21 13:31:40','',''),(1029,'1','307','1',1,'Retail Sale Id 1015',71000.00,0.00,0.00,100.00,4600.00,'2023-01-21 13:33:34','',''),(1030,'1','307','1',1,'Retail Sale Id 1016',3700.00,0.00,0.00,5.00,380.00,'2023-01-21 13:49:50','',''),(1031,'1','307','1',1,'Retail Sale Id 1017',2997.00,0.00,0.00,4.05,307.80,'2023-01-21 13:51:20','',''),(1032,'1','307','1',1,'Retail Sale Id 1018',2960.00,0.00,0.00,4.00,304.00,'2023-01-21 14:02:12','',''),(1033,'1','307','1',1,'Retail Sale Id 1019',9250.00,0.00,0.00,12.50,950.00,'2023-01-21 14:13:46','',''),(1034,'1','307','1',1,'Retail Sale Id 1020',3700.00,0.00,0.00,5.00,380.00,'2023-01-21 14:18:06','',''),(1035,'1','307','1',1,'Retail Sale Id 1021',747.40,0.00,0.00,1.01,76.76,'2023-01-21 14:18:56','',''),(1036,'1','307','1',1,'Retail Sale Id 1022',2249.60,0.00,0.00,3.04,231.04,'2023-01-21 14:22:11','',''),(1037,'1','307','1',1,'Retail Sale Id 1023',2997.00,0.00,0.00,4.05,307.80,'2023-01-21 14:28:20','',''),(1038,'1','307','1',1,'Retail Sale Id 1024',1502.20,0.00,0.00,2.03,154.28,'2023-01-21 14:43:02','',''),(1039,'1','307','1',1,'Retail Sale Id 1025',2997.00,0.00,0.00,4.05,307.80,'2023-01-21 14:50:14','',''),(1040,'1','307','1',1,'Retail Sale Id 1026',4447.40,0.00,0.00,6.01,456.76,'2023-01-21 14:53:09','',''),(1041,'1','307','1',1,'Retail Sale Id 1027',2997.00,0.00,0.00,4.05,307.80,'2023-01-21 14:56:08','',''),(1042,'1','307','1',1,'Retail Sale Id 1028',2249.60,0.00,0.00,3.04,231.04,'2023-01-21 15:07:49','',''),(1043,'1','307','1',1,'Retail Sale Id 1029',4447.40,0.00,0.00,6.01,456.76,'2023-01-21 15:09:22','',''),(1044,'1','307','1',1,'Retail Sale Id 1030',4447.40,0.00,0.00,6.01,456.76,'2023-01-21 15:21:36','',''),(1045,'1','307','1',1,'Retail Sale Id 1031',747.40,0.00,0.00,1.01,76.76,'2023-01-21 15:23:14','',''),(1046,'1','307','1',1,'Retail Sale Id 1032',4447.40,0.00,0.00,6.01,456.76,'2023-01-21 15:31:54','',''),(1047,'1','307','1',1,'Retail Sale Id 1033',2997.00,0.00,0.00,4.05,307.80,'2023-01-21 15:35:40','',''),(1048,'1','307','1',1,'Retail Sale Id 1034',2501.20,0.00,0.00,3.38,256.88,'2023-01-21 15:49:31','',''),(1049,'1','307','1',1,'Retail Sale Id 1035',1480.00,0.00,0.00,2.00,152.00,'2023-01-21 15:59:28','',''),(1050,'1','307','1',1,'Retail Sale Id 1036',4447.40,0.00,0.00,6.01,456.76,'2023-01-21 16:04:27','',''),(1051,'1','307','1',1,'Retail Sale Id 1037',1998.00,0.00,0.00,2.70,205.20,'2023-01-21 16:24:43','',''),(1052,'1','307','1',1,'Retail Sale Id 1038',747.40,0.00,0.00,1.01,76.76,'2023-01-21 16:42:06','',''),(1053,'1','307','1',1,'Retail Sale Id 1039',9250.00,0.00,0.00,12.50,950.00,'2023-01-21 16:43:14','',''),(1054,'1','307','1',1,'Retail Sale Id 1040',1502.20,0.00,0.00,2.03,154.28,'2023-01-21 17:15:16','',''),(1055,'1','307','1',1,'Retail Sale Id 1041',6697.00,0.00,0.00,9.05,687.80,'2023-01-21 17:17:48','',''),(1056,'1','307','1',1,'Retail Sale Id 1042',2220.00,0.00,0.00,3.00,228.00,'2023-01-21 17:18:50','',''),(1057,'1','307','1',1,'Retail Sale Id 1043',2960.00,0.00,0.00,4.00,304.00,'2023-01-21 17:21:10','',''),(1058,'1','307','1',1,'Retail Sale Id 1044',2220.00,0.00,0.00,3.00,228.00,'2023-01-21 17:25:53','',''),(1059,'1','307','1',1,'Retail Sale Id 1045',3700.00,0.00,0.00,5.00,380.00,'2023-01-21 17:37:38','',''),(1060,'1','307','1',1,'Retail Sale Id 1046',4447.40,0.00,0.00,6.01,456.76,'2023-01-21 17:38:40','',''),(1061,'1','307','1',1,'Retail Sale Id 1047',9250.00,0.00,0.00,12.50,950.00,'2023-01-21 17:45:21','',''),(1062,'1','307','1',1,'Retail Sale Id 1049',4440.00,0.00,0.00,6.00,456.00,'2023-01-21 17:51:03','',''),(1063,'1','307','1',1,'Retail Sale Id 1050',1480.00,0.00,0.00,2.00,152.00,'2023-01-21 17:51:52','',''),(1064,'1','307','1',1,'Retail Sale Id 1051',1502.20,0.00,0.00,2.03,154.28,'2023-01-21 17:55:34','',''),(1065,'1','307','1',1,'Retail Sale Id 1052',2249.60,0.00,0.00,3.04,231.04,'2023-01-21 17:58:28','',''),(1066,'1','307','1',1,'Retail Sale Id 1054',2249.60,0.00,0.00,3.04,231.04,'2023-01-21 18:00:00','',''),(1067,'1','307','1',1,'Retail Sale Id 1055',2997.00,0.00,0.00,4.05,307.80,'2023-01-21 18:13:02','',''),(1068,'1','307','1',1,'Retail Sale Id 1056',1502.20,0.00,0.00,2.03,154.28,'2023-01-21 18:18:43','',''),(1069,'1','307','1',1,'Retail Sale Id 1057',9250.00,0.00,0.00,12.50,950.00,'2023-01-21 18:32:48','',''),(1070,'1','307','1',1,'Retail Sale Id 1058',1502.20,0.00,0.00,2.03,154.28,'2023-01-21 18:34:30','',''),(1071,'1','307','1',1,'Retail Sale Id 1059',7244.60,0.00,0.00,9.79,744.04,'2023-01-21 18:57:38','',''),(1072,'1','307','1',1,'Return of Retail Sale Id 1045',0.00,3700.00,5.00,0.00,-380.00,'2023-01-21 19:02:23','',''),(1073,'1','307','1',1,'Retail Sale Id 1060',4447.40,0.00,0.00,6.01,456.76,'2023-01-22 07:36:31','',''),(1074,'1','307','1',1,'Retail Sale Id 1061',4447.40,0.00,0.00,6.01,456.76,'2023-01-22 07:37:44','',''),(1075,'1','307','1',1,'Retail Sale Id 1062',740.00,0.00,0.00,1.00,76.00,'2023-01-22 07:42:03','',''),(1076,'1','307','1',1,'Retail Sale Id 1063',4499.20,0.00,0.00,6.08,462.08,'2023-01-22 08:05:57','',''),(1077,'1','307','1',1,'Retail Sale Id 1064',2997.00,0.00,0.00,4.05,307.80,'2023-01-22 08:09:43','',''),(1078,'1','307','1',1,'Retail Sale Id 1065',3700.00,0.00,0.00,5.00,380.00,'2023-01-22 08:14:14','',''),(1079,'1','307','1',1,'Retail Sale Id 1066',35000.00,0.00,0.00,50.00,1800.00,'2023-01-22 08:19:38','',''),(1080,'1','307','1',1,'Retail Sale Id 1067',35000.00,0.00,0.00,50.00,1800.00,'2023-01-22 08:21:09','',''),(1081,'1','307','1',1,'Retail Sale Id 1068',8147.40,0.00,0.00,11.01,836.76,'2023-01-22 08:22:50','',''),(1082,'1','307','1',1,'Retail Sale Id 1069',2997.00,0.00,0.00,4.05,307.80,'2023-01-22 08:41:21','',''),(1083,'1','307','1',1,'Retail Sale Id 1070',4440.00,0.00,0.00,6.00,456.00,'2023-01-22 08:43:14','',''),(1084,'1','307','1',1,'Retail Sale Id 1071',105000.00,0.00,0.00,150.00,5400.00,'2023-01-22 09:14:46','',''),(1085,'1','307','1',1,'Retail Sale Id 1072',1998.00,0.00,0.00,2.70,205.20,'2023-01-22 09:19:49','',''),(1086,'1','307','1',1,'Retail Sale Id 1073',2220.00,0.00,0.00,3.00,228.00,'2023-01-22 09:27:47','',''),(1087,'1','307','1',1,'Retail Sale Id 1074',1998.00,0.00,0.00,2.70,205.20,'2023-01-22 09:35:53','',''),(1088,'1','307','1',1,'Retail Sale Id 1075',4447.40,0.00,0.00,6.01,456.76,'2023-01-22 10:28:20','',''),(1089,'1','307','1',1,'Retail Sale Id 1076',3700.00,0.00,0.00,5.00,380.00,'2023-01-22 10:30:11','',''),(1090,'1','307','1',1,'Retail Sale Id 1077',1480.00,0.00,0.00,2.00,152.00,'2023-01-22 10:35:10','',''),(1091,'1','307','1',1,'Retail Sale Id 1078',3700.00,0.00,0.00,5.00,380.00,'2023-01-22 10:51:04','',''),(1092,'1','307','1',1,'Retail Sale Id 1079',4447.40,0.00,0.00,6.01,456.76,'2023-01-22 10:52:59','',''),(1093,'1','307','1',1,'Retail Sale Id 1080',3700.00,0.00,0.00,5.00,380.00,'2023-01-22 10:54:17','',''),(1094,'1','307','1',1,'Retail Sale Id 1081',4440.00,0.00,0.00,6.00,456.00,'2023-01-22 11:24:03','',''),(1095,'1','307','1',1,'Retail Sale Id 1082',4447.40,0.00,0.00,6.01,456.76,'2023-01-22 12:14:44','',''),(1096,'1','307','1',1,'Retail Sale Id 1083',1502.20,0.00,0.00,2.03,154.28,'2023-01-22 12:15:36','',''),(1097,'1','307','1',1,'Retail Sale Id 1084',1998.00,0.00,0.00,2.70,205.20,'2023-01-22 12:26:55','',''),(1098,'1','307','1',1,'Retail Sale Id 1085',2220.00,0.00,0.00,3.00,228.00,'2023-01-22 12:42:37','',''),(1099,'1','307','1',1,'Retail Sale Id 1086',2997.00,0.00,0.00,4.05,307.80,'2023-01-22 12:52:22','',''),(1100,'1','307','1',1,'Retail Sale Id 1087',2301.40,0.00,0.00,3.11,236.36,'2023-01-22 13:19:17','',''),(1101,'1','307','1',1,'Retail Sale Id 1088',2249.60,0.00,0.00,3.04,231.04,'2023-01-22 13:23:34','',''),(1102,'1','307','1',1,'Retail Sale Id 1089',2249.60,0.00,0.00,3.04,231.04,'2023-01-22 13:25:20','',''),(1103,'1','307','1',1,'Retail Sale Id 1090',2997.00,0.00,0.00,4.05,307.80,'2023-01-22 13:39:09','',''),(1104,'1','307','1',1,'Retail Sale Id 1091',2249.60,0.00,0.00,3.04,231.04,'2023-01-22 14:11:22','',''),(1105,'1','307','1',1,'Retail Sale Id 1092',9250.00,0.00,0.00,12.50,950.00,'2023-01-22 14:28:25','',''),(1106,'1','307','1',1,'Retail Sale Id 1093',4499.20,0.00,0.00,6.08,462.08,'2023-01-22 14:32:58','',''),(1107,'1','307','1',1,'Retail Sale Id 1094',4440.00,0.00,0.00,6.00,456.00,'2023-01-22 14:42:37','',''),(1108,'1','307','1',1,'Retail Sale Id 1095',2220.00,0.00,0.00,3.00,228.00,'2023-01-22 14:44:32','',''),(1109,'1','307','1',1,'Retail Sale Id 1096',9250.00,0.00,0.00,12.50,950.00,'2023-01-22 14:57:43','',''),(1110,'1','307','1',1,'Retail Sale Id 1097',1480.00,0.00,0.00,2.00,152.00,'2023-01-22 15:01:03','',''),(1111,'1','307','1',1,'Retail Sale Id 1098',1998.00,0.00,0.00,2.70,205.20,'2023-01-22 15:38:21','',''),(1112,'1','307','1',1,'Retail Sale Id 1099',2197.80,0.00,0.00,2.97,225.72,'2023-01-22 15:41:12','',''),(1113,'1','307','1',1,'Retail Sale Id 1100',5002.40,0.00,0.00,6.76,513.76,'2023-01-22 15:50:52','',''),(1114,'1','307','1',1,'Retail Sale Id 1101',2249.60,0.00,0.00,3.04,231.04,'2023-01-22 16:11:56','',''),(1115,'1','307','1',1,'Retail Sale Id 1102',1998.00,0.00,0.00,2.70,205.20,'2023-01-22 16:13:25','',''),(1116,'1','307','1',1,'Retail Sale Id 1103',1502.20,0.00,0.00,2.03,154.28,'2023-01-22 16:14:07','',''),(1117,'1','307','1',1,'Retail Sale Id 1104',70000.00,0.00,0.00,100.00,3600.00,'2023-01-22 16:20:59','',''),(1118,'1','307','1',1,'Retail Sale Id 1105',1502.20,0.00,0.00,2.03,154.28,'2023-01-22 16:26:10','',''),(1119,'1','307','1',1,'Retail Sale Id 1106',799.20,0.00,0.00,1.08,82.08,'2023-01-22 16:29:16','',''),(1120,'1','307','1',1,'Retail Sale Id 1107',4440.00,0.00,0.00,6.00,456.00,'2023-01-22 16:31:05','',''),(1121,'1','307','1',1,'Retail Sale Id 1107',7400.00,0.00,0.00,10.00,760.00,'2023-01-22 16:31:05','',''),(1122,'1','307','1',1,'Retail Sale Id 1108',2997.00,0.00,0.00,4.05,307.80,'2023-01-22 16:42:59','',''),(1123,'1','307','1',1,'Retail Sale Id 1109',7400.00,0.00,0.00,10.00,760.00,'2023-01-22 16:50:38','',''),(1124,'1','307','1',1,'Retail Sale Id 1110',1502.20,0.00,0.00,2.03,154.28,'2023-01-22 16:52:38','',''),(1125,'1','307','1',1,'Retail Sale Id 1111',747.40,0.00,0.00,1.01,76.76,'2023-01-22 16:55:38','',''),(1126,'1','307','1',1,'Retail Sale Id 1112',35000.00,0.00,0.00,50.00,1800.00,'2023-01-22 16:59:33','',''),(1127,'1','307','1',1,'Retail Sale Id 1113',3700.00,0.00,0.00,5.00,380.00,'2023-01-22 17:02:16','',''),(1128,'1','307','1',1,'Retail Sale Id 1114',4447.40,0.00,0.00,6.01,456.76,'2023-01-22 17:12:16','',''),(1129,'1','307','1',1,'Retail Sale Id 1115',4447.40,0.00,0.00,6.01,456.76,'2023-01-22 17:14:23','',''),(1130,'1','307','1',1,'Retail Sale Id 1116',747.40,0.00,0.00,1.01,76.76,'2023-01-22 17:19:47','',''),(1131,'1','307','1',1,'Retail Sale Id 1117',1502.20,0.00,0.00,2.03,154.28,'2023-01-22 17:22:24','',''),(1132,'1','307','1',1,'Retail Sale Id 1118',9250.00,0.00,0.00,12.50,950.00,'2023-01-22 17:30:24','',''),(1133,'1','307','1',1,'Retail Sale Id 1119',1798.20,0.00,0.00,2.43,184.68,'2023-01-22 17:36:06','',''),(1134,'1','307','1',1,'Retail Sale Id 1120',18500.00,0.00,0.00,25.00,1900.00,'2023-01-22 17:40:55','',''),(1135,'1','307','1',1,'Retail Sale Id 1121',3700.00,0.00,0.00,5.00,380.00,'2023-01-22 17:52:24','',''),(1136,'1','307','1',1,'Retail Sale Id 1122',2501.20,0.00,0.00,3.38,256.88,'2023-01-22 17:56:41','',''),(1137,'1','307','1',1,'Retail Sale Id 1122',2501.20,0.00,0.00,3.38,256.88,'2023-01-22 17:56:41','',''),(1138,'1','307','1',1,'Retail Sale Id 1124',35000.00,0.00,0.00,50.00,1800.00,'2023-01-22 18:16:17','',''),(1139,'1','307','1',1,'Retail Sale Id 1125',3700.00,0.00,0.00,5.00,380.00,'2023-01-22 18:17:50','',''),(1140,'1','307','1',1,'Retail Sale Id 1126',2220.00,0.00,0.00,3.00,228.00,'2023-01-22 18:19:37','',''),(1141,'1','307','1',1,'Retail Sale Id 1127',2249.60,0.00,0.00,3.04,231.04,'2023-01-22 18:26:23','',''),(1142,'1','307','1',1,'Retail Sale Id 1128',4292.00,0.00,0.00,5.80,440.80,'2023-01-22 18:52:54','',''),(1143,'1','307','1',1,'Retail Sale Id 1129',8998.40,0.00,0.00,12.16,924.16,'2023-01-23 07:25:23','',''),(1144,'1','307','1',1,'Retail Sale Id 1130',70000.00,0.00,0.00,100.00,3600.00,'2023-01-23 07:26:01','',''),(1145,'1','307','1',1,'Retail Sale Id 1131',5202.20,0.00,0.00,7.03,534.28,'2023-01-23 07:35:37','',''),(1146,'1','307','1',1,'Retail Sale Id 1132',1998.00,0.00,0.00,2.70,205.20,'2023-01-23 07:49:51','',''),(1147,'1','307','1',1,'Retail Sale Id 1132',1998.00,0.00,0.00,2.70,205.20,'2023-01-23 07:49:51','',''),(1148,'1','307','1',1,'Retail Sale Id 1134',5002.40,0.00,0.00,6.76,513.76,'2023-01-23 08:17:14','',''),(1149,'1','307','1',1,'Retail Sale Id 1135',1502.20,0.00,0.00,2.03,154.28,'2023-01-23 08:38:26','',''),(1150,'1','307','1',1,'Retail Sale Id 1136',2249.60,0.00,0.00,3.04,231.04,'2023-01-23 08:44:54','',''),(1151,'1','307','1',1,'Retail Sale Id 1137',2220.00,0.00,0.00,3.00,228.00,'2023-01-23 09:36:36','',''),(1152,'1','307','1',1,'Retail Sale Id 1138',2220.00,0.00,0.00,3.00,228.00,'2023-01-23 09:45:55','',''),(1153,'1','307','1',1,'Retail Sale Id 1140',2501.20,0.00,0.00,3.38,256.88,'2023-01-23 09:54:40','',''),(1154,'1','307','1',1,'Retail Sale Id 1141',4447.40,0.00,0.00,6.01,456.76,'2023-01-23 10:05:14','',''),(1155,'1','307','1',1,'Retail Sale Id 1142',4447.40,0.00,0.00,6.01,456.76,'2023-01-23 10:09:44','',''),(1156,'1','307','1',1,'Retail Sale Id 1143',1502.20,0.00,0.00,2.03,154.28,'2023-01-23 10:22:05','',''),(1157,'1','307','1',1,'Retail Sale Id 1144',9250.00,0.00,0.00,12.50,950.00,'2023-01-23 10:42:01','',''),(1158,'1','307','1',1,'Retail Sale Id 1145',2997.00,0.00,0.00,4.05,307.80,'2023-01-23 10:50:07','',''),(1159,'1','307','1',1,'Retail Sale Id 1146',35000.00,0.00,0.00,50.00,1800.00,'2023-01-23 10:57:30','',''),(1160,'1','307','1',1,'Retail Sale Id 1147',9250.00,0.00,0.00,12.50,950.00,'2023-01-23 11:06:54','',''),(1161,'1','307','1',1,'Retail Sale Id 1148',7400.00,0.00,0.00,10.00,760.00,'2023-01-23 11:10:37','',''),(1162,'1','307','1',1,'Retail Sale Id 1149',4440.00,0.00,0.00,6.00,456.00,'2023-01-23 11:50:12','',''),(1163,'1','307','1',1,'Retail Sale Id 1150',2220.00,0.00,0.00,3.00,228.00,'2023-01-23 11:57:39','',''),(1164,'1','307','1',1,'Retail Sale Id 1151',2997.00,0.00,0.00,4.05,307.80,'2023-01-23 12:08:58','',''),(1165,'1','307','1',1,'Retail Sale Id 1152',2220.00,0.00,0.00,3.00,228.00,'2023-01-23 12:19:18','',''),(1166,'1','307','1',1,'Retail Sale Id 1152',4440.00,0.00,0.00,6.00,456.00,'2023-01-23 12:19:18','',''),(1167,'1','307','1',1,'Retail Sale Id 1153',87500.00,0.00,0.00,125.00,4500.00,'2023-01-23 12:38:28','',''),(1168,'1','307','1',1,'Retail Sale Id 1154',4440.00,0.00,0.00,6.00,456.00,'2023-01-23 13:18:48','',''),(1169,'1','307','1',1,'Retail Sale Id 1155',2197.80,0.00,0.00,2.97,225.72,'2023-01-23 13:21:32','',''),(1170,'1','307','1',1,'Retail Sale Id 1156',4499.20,0.00,0.00,6.08,462.08,'2023-01-23 14:38:00','',''),(1171,'1','307','1',1,'Retail Sale Id 1157',2197.80,0.00,0.00,2.97,225.72,'2023-01-23 14:44:37','',''),(1172,'1','307','1',1,'Retail Sale Id 1158',2997.00,0.00,0.00,4.05,307.80,'2023-01-23 14:50:51','',''),(1173,'1','307','1',1,'Retail Sale Id 1159',1502.20,0.00,0.00,2.03,154.28,'2023-01-23 14:52:48','',''),(1174,'1','307','1',1,'Retail Sale Id 1161',4499.20,0.00,0.00,6.08,462.08,'2023-01-23 14:54:18','',''),(1175,'1','307','1',1,'Retail Sale Id 1162',1998.00,0.00,0.00,2.70,205.20,'2023-01-23 15:00:21','',''),(1176,'1','307','1',1,'Retail Sale Id 1163',747.40,0.00,0.00,1.01,76.76,'2023-01-23 15:22:59','',''),(1177,'1','307','1',1,'Retail Sale Id 1164',35000.00,0.00,0.00,50.00,1800.00,'2023-01-23 15:51:37','',''),(1178,'1','307','1',1,'Retail Sale Id 1165',3700.00,0.00,0.00,5.00,380.00,'2023-01-23 15:54:15','',''),(1179,'1','307','1',1,'Retail Sale Id 1166',2249.60,0.00,0.00,3.04,231.04,'2023-01-23 15:55:49','',''),(1180,'1','307','1',1,'Retail Sale Id 1167',3700.00,0.00,0.00,5.00,380.00,'2023-01-23 16:02:11','',''),(1181,'1','307','1',1,'Retail Sale Id 1168',2249.60,0.00,0.00,3.04,231.04,'2023-01-23 16:25:01','',''),(1182,'1','307','1',1,'Retail Sale Id 1170',9250.00,0.00,0.00,12.50,950.00,'2023-01-23 16:32:54','',''),(1183,'1','307','1',1,'Retail Sale Id 1171',8140.00,0.00,0.00,11.00,836.00,'2023-01-23 16:40:14','',''),(1184,'1','307','1',1,'Retail Sale Id 1172',3700.00,0.00,0.00,5.00,380.00,'2023-01-23 16:43:28','',''),(1185,'1','307','1',1,'Retail Sale Id 1173',1924.00,0.00,0.00,2.60,197.60,'2023-01-23 17:15:04','',''),(1186,'1','307','1',1,'Distributed to Operational lost for sales id:2',50742.88,0.00,0.00,76.42,0.00,'2023-01-23 17:24:11','',''),(1187,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,1260000.00,2000.00,0.00,0.00,'2023-01-23 18:03:39','',''),(1188,'1','307',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,2000.00,0.00,'2023-01-23 18:05:30','',''),(1189,'1','307','1',1,'Received from bridging 4',0.00,0.00,2000.00,0.00,0.00,'2023-01-23 18:05:30','',''),(1190,'1','307','1',1,'Retail Sale Id 1174',35000.00,0.00,0.00,50.00,3500.00,'2023-01-23 18:20:50','',''),(1191,'1','307','1',1,'Retail Sale Id 1175',1502.20,0.00,0.00,2.03,223.30,'2023-01-23 18:22:19','',''),(1192,'1','307','1',1,'Retail Sale Id 1176',70000.00,0.00,0.00,100.00,7000.00,'2023-01-23 18:57:50','',''),(1193,'1','307','1',1,'Retail Sale Id 1177',3700.00,0.00,0.00,5.00,550.00,'2023-01-23 19:00:39','',''),(1194,'1','307','1',1,'Retail Sale Id 1178',9250.00,0.00,0.00,12.50,1375.00,'2023-01-23 19:13:30','',''),(1195,'1','307','1',1,'Retail Sale Id 1179',9250.00,0.00,0.00,12.50,1375.00,'2023-01-23 19:15:10','',''),(1196,'1','307','1',1,'Retail Sale Id 1180',9250.00,0.00,0.00,12.50,1375.00,'2023-01-23 19:15:41','',''),(1197,'1','307','1',1,'Retail Sale Id 1181',11100.00,0.00,0.00,15.00,1650.00,'2023-01-23 19:16:44','',''),(1198,'1','307','1',1,'Retail Sale Id 1182',1820.40,0.00,0.00,2.46,270.60,'2023-01-23 19:18:29','',''),(1199,'1','307','1',1,'Retail Sale Id 1183',2197.80,0.00,0.00,2.97,326.70,'2023-01-24 08:04:44','',''),(1200,'1','307','1',1,'Retail Sale Id 1184',1502.20,0.00,0.00,2.03,223.30,'2023-01-24 08:25:07','',''),(1201,'1','307','1',1,'Retail Sale Id 1185',70000.00,0.00,0.00,100.00,7000.00,'2023-01-24 08:27:09','',''),(1202,'1','307','1',1,'Retail Sale Id 1186',2249.60,0.00,0.00,3.04,334.40,'2023-01-24 08:28:43','',''),(1203,'1','307','1',1,'Retail Sale Id 1187',9250.00,0.00,0.00,12.50,1375.00,'2023-01-24 09:06:21','',''),(1204,'1','307','1',1,'Retail Sale Id 1188',35000.00,0.00,0.00,50.00,3500.00,'2023-01-24 09:19:56','',''),(1205,'1','307','1',1,'Retail Sale Id 1189',1480.00,0.00,0.00,2.00,220.00,'2023-01-24 09:39:16','',''),(1206,'1','307','1',1,'Retail Sale Id 1190',105000.00,0.00,0.00,150.00,10500.00,'2023-01-24 10:09:35','',''),(1207,'1','307','1',1,'Retail Sale Id 1191',2249.60,0.00,0.00,3.04,334.40,'2023-01-24 11:06:54','',''),(1208,'1','307','1',1,'Retail Sale Id 1192',35000.00,0.00,0.00,50.00,3500.00,'2023-01-24 11:19:13','',''),(1209,'1','307','1',1,'Retail Sale Id 1193',35000.00,0.00,0.00,50.00,3500.00,'2023-01-24 11:31:29','',''),(1210,'1','307','1',1,'Retail Sale Id 1194',35000.00,0.00,0.00,50.00,3500.00,'2023-01-24 11:44:57','',''),(1211,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,1872738.00,2972.60,0.00,0.00,'2023-01-24 12:05:32','',''),(1212,'1','307',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,2972.60,0.00,'2023-01-24 12:09:01','',''),(1213,'1','307','1',1,'Received from bridging 5',0.00,0.00,2972.60,0.00,0.00,'2023-01-24 12:09:01','',''),(1214,'1','307','1',1,'Retail Sale Id 1195',4003.40,0.00,0.00,5.41,595.10,'2023-01-24 12:34:07','',''),(1215,'1','307','1',1,'Retail Sale Id 1196',2220.00,0.00,0.00,3.00,330.00,'2023-01-24 12:38:15','',''),(1216,'1','307','1',1,'Retail Sale Id 1199',2220.00,0.00,0.00,3.00,330.00,'2023-01-24 12:50:06','',''),(1217,'1','307','1',1,'Retail Sale Id 1200',4440.00,0.00,0.00,6.00,660.00,'2023-01-24 13:03:00','',''),(1218,'1','307','1',1,'Retail Sale Id 1201',35000.00,0.00,0.00,50.00,3500.00,'2023-01-24 15:41:55','',''),(1219,'1','307','1',1,'Retail Sale Id 1202',1502.20,0.00,0.00,2.03,223.30,'2023-01-24 15:43:10','',''),(1220,'1','307','1',1,'Retail Sale Id 1203',4447.40,0.00,0.00,6.01,661.10,'2023-01-24 16:44:34','',''),(1221,'1','307','1',1,'Retail Sale Id 1204',3700.00,0.00,0.00,5.00,550.00,'2023-01-24 16:47:14','',''),(1222,'1','307','1',1,'Retail Sale Id 1205',4440.00,0.00,0.00,6.00,660.00,'2023-01-24 16:51:07','',''),(1223,'1','307','1',1,'Retail Sale Id 1206',4440.00,0.00,0.00,6.00,660.00,'2023-01-24 16:53:19','',''),(1224,'1','307','1',1,'Retail Sale Id 1207',999.00,0.00,0.00,1.35,148.50,'2023-01-24 17:02:00','',''),(1225,'1','307','1',1,'Retail Sale Id 1208',999.00,0.00,0.00,1.35,148.50,'2023-01-24 17:26:31','',''),(1226,'1','307','1',1,'Retail Sale Id 1209',2397.60,0.00,0.00,3.24,356.40,'2023-01-24 17:42:38','',''),(1227,'1','307','1',1,'Retail Sale Id 1210',4440.00,0.00,0.00,6.00,660.00,'2023-01-24 17:47:10','',''),(1228,'1','307','1',1,'Retail Sale Id 1211',2997.00,0.00,0.00,4.05,445.50,'2023-01-24 17:51:39','',''),(1229,'1','307','1',1,'Retail Sale Id 1212',4447.40,0.00,0.00,6.01,661.10,'2023-01-24 17:54:19','',''),(1230,'1','307','1',1,'Retail Sale Id 1213',747.40,0.00,0.00,1.01,111.10,'2023-01-24 18:03:55','',''),(1231,'1','307','1',1,'Retail Sale Id 1213',747.40,0.00,0.00,1.01,111.10,'2023-01-24 18:03:55','',''),(1232,'1','307','1',1,'Retail Sale Id 1214',2249.60,0.00,0.00,3.04,334.40,'2023-01-24 18:11:02','',''),(1233,'1','307','1',1,'Retail Sale Id 1215',1502.20,0.00,0.00,2.03,223.30,'2023-01-24 18:20:20','',''),(1234,'1','307','1',1,'Retail Sale Id 1216',7400.00,0.00,0.00,10.00,1100.00,'2023-01-24 18:27:51','',''),(1235,'1','307','1',1,'Retail Sale Id 1217',1998.00,0.00,0.00,2.70,297.00,'2023-01-24 18:31:18','',''),(1236,'1','307','1',1,'Retail Sale Id 1218',4499.20,0.00,0.00,6.08,668.80,'2023-01-24 18:33:10','',''),(1237,'1','307','1',1,'Retail Sale Id 1219',3448.40,0.00,0.00,4.66,512.60,'2023-01-24 19:00:38','',''),(1238,'1','307','1',1,'Retail Sale Id 1222',4440.00,0.00,0.00,6.00,660.00,'2023-01-25 07:44:38','',''),(1239,'1','307','1',1,'Retail Sale Id 1223',1502.20,0.00,0.00,2.03,223.30,'2023-01-25 08:14:51','',''),(1240,'1','307','1',1,'Retail Sale Id 1224',1480.00,0.00,0.00,2.00,220.00,'2023-01-25 08:24:09','',''),(1241,'1','307','1',1,'Retail Sale Id 1225',2249.60,0.00,0.00,3.04,334.40,'2023-01-25 08:42:44','',''),(1242,'1','307','1',1,'Retail Sale Id 1226',2249.60,0.00,0.00,3.04,334.40,'2023-01-25 08:49:03','',''),(1243,'1','307','1',1,'Retail Sale Id 1227',4440.00,0.00,0.00,6.00,660.00,'2023-01-25 08:57:04','',''),(1244,'1','307','1',1,'Retail Sale Id 1228',105000.00,0.00,0.00,150.00,10500.00,'2023-01-25 09:02:36','',''),(1245,'1','307','1',1,'Retail Sale Id 1229',7400.00,0.00,0.00,10.00,1100.00,'2023-01-25 09:13:04','',''),(1246,'1','307','1',1,'Retail Sale Id 1230',4447.40,0.00,0.00,6.01,661.10,'2023-01-25 09:15:16','',''),(1247,'1','307','1',1,'Retail Sale Id 1231',2220.00,0.00,0.00,3.00,330.00,'2023-01-25 10:17:22','',''),(1248,'1','307','1',1,'Retail Sale Id 1232',1998.00,0.00,0.00,2.70,297.00,'2023-01-25 10:32:05','',''),(1249,'1','307','1',1,'Retail Sale Id 1233',4440.00,0.00,0.00,6.00,660.00,'2023-01-25 10:47:01','',''),(1250,'1','307','1',1,'Retail Sale Id 1234',1502.20,0.00,0.00,2.03,223.30,'2023-01-25 10:52:48','',''),(1251,'1','307','1',1,'Retail Sale Id 1235',2249.60,0.00,0.00,3.04,334.40,'2023-01-25 11:33:47','',''),(1252,'1','307','1',1,'Retail Sale Id 1236',2301.40,0.00,0.00,3.11,342.10,'2023-01-25 11:52:30','',''),(1253,'1','307','1',1,'Retail Sale Id 1237',3700.00,0.00,0.00,5.00,550.00,'2023-01-25 12:05:28','',''),(1254,'1','307','1',1,'Retail Sale Id 1238',2249.60,0.00,0.00,3.04,334.40,'2023-01-25 12:17:39','',''),(1255,'1','307','1',1,'Retail Sale Id 1239',35000.00,0.00,0.00,50.00,3500.00,'2023-01-25 12:19:48','',''),(1256,'1','307','1',1,'Retail Sale Id 1240',87500.00,0.00,0.00,125.00,8750.00,'2023-01-25 12:27:20','',''),(1257,'1','307','1',1,'Retail Sale Id 1241',9250.00,0.00,0.00,12.50,1375.00,'2023-01-25 12:30:14','',''),(1258,'1','307','1',1,'Retail Sale Id 1242',8902.20,0.00,0.00,12.03,1323.30,'2023-01-25 15:04:00','',''),(1259,'1','307','1',1,'Retail Sale Id 1243',2249.60,0.00,0.00,3.04,334.40,'2023-01-25 15:14:03','',''),(1260,'1','307','1',1,'Retail Sale Id 1244',4447.40,0.00,0.00,6.01,661.10,'2023-01-25 15:37:07','',''),(1261,'1','307','1',1,'Retail Sale Id 1245',9250.00,0.00,0.00,12.50,1375.00,'2023-01-25 15:49:00','',''),(1262,'1','307','1',1,'Retail Sale Id 1246',2220.00,0.00,0.00,3.00,330.00,'2023-01-25 15:53:29','',''),(1263,'1','307','1',1,'Retail Sale Id 1247',4447.40,0.00,0.00,6.01,661.10,'2023-01-25 15:55:15','',''),(1264,'1','307','1',1,'Retail Sale Id 1248',2997.00,0.00,0.00,4.05,445.50,'2023-01-25 16:16:52','',''),(1265,'1','307','1',1,'Retail Sale Id 1249',35000.00,0.00,0.00,50.00,3500.00,'2023-01-25 16:20:50','',''),(1266,'1','307','1',1,'Retail Sale Id 1250',4447.40,0.00,0.00,6.01,661.10,'2023-01-25 16:22:10','',''),(1267,'1','307','1',1,'Retail Sale Id 1251',4447.40,0.00,0.00,6.01,661.10,'2023-01-25 16:22:54','',''),(1268,'1','307','1',1,'Retail Sale Id 1252',35000.00,0.00,0.00,50.00,3500.00,'2023-01-25 16:24:19','',''),(1269,'1','307','1',1,'Retail Sale Id 1253',2249.60,0.00,0.00,3.04,334.40,'2023-01-25 16:42:28','',''),(1270,'1','307','1',1,'Retail Sale Id 1254',4447.40,0.00,0.00,6.01,661.10,'2023-01-25 16:46:00','',''),(1271,'1','307','1',1,'Retail Sale Id 1255',2249.60,0.00,0.00,3.04,334.40,'2023-01-25 16:46:47','',''),(1272,'1','307','1',1,'Retail Sale Id 1256',1502.20,0.00,0.00,2.03,223.30,'2023-01-25 16:54:05','',''),(1273,'1','307','1',1,'Retail Sale Id 1257',1502.20,0.00,0.00,2.03,223.30,'2023-01-25 17:02:29','',''),(1274,'1','307','1',1,'Retail Sale Id 1258',4499.20,0.00,0.00,6.08,668.80,'2023-01-25 17:04:15','',''),(1275,'1','307','1',1,'Retail Sale Id 1259',2220.00,0.00,0.00,3.00,330.00,'2023-01-25 17:10:09','',''),(1276,'1','307','1',1,'Retail Sale Id 1260',2220.00,0.00,0.00,3.00,330.00,'2023-01-25 17:19:02','',''),(1277,'1','307','1',1,'Retail Sale Id 1261',3700.00,0.00,0.00,5.00,550.00,'2023-01-25 17:57:58','',''),(1278,'1','307','1',1,'Retail Sale Id 1262',4447.40,0.00,0.00,6.01,661.10,'2023-01-25 18:00:20','',''),(1279,'1','307','1',1,'Retail Sale Id 1263',2249.60,0.00,0.00,3.04,334.40,'2023-01-25 18:09:54','',''),(1280,'1','307','1',1,'Retail Sale Id 1264',2997.00,0.00,0.00,4.05,445.50,'2023-01-25 18:27:49','',''),(1281,'1','307','1',1,'Retail Sale Id 1265',1998.00,0.00,0.00,2.70,297.00,'2023-01-25 18:28:27','',''),(1282,'1','307','1',1,'Retail Sale Id 1266',6001.40,0.00,0.00,8.11,892.10,'2023-01-25 18:33:30','',''),(1283,'1','307','1',1,'Retail Sale Id 1267',4447.40,0.00,0.00,6.01,661.10,'2023-01-25 18:47:17','',''),(1284,'1','307','1',1,'Retail Sale Id 1268',9901.20,0.00,0.00,13.38,1471.80,'2023-01-25 19:11:35','',''),(1285,'1','307','1',1,'Retail Sale Id 1269',799.20,0.00,0.00,1.08,118.80,'2023-01-26 07:11:55','',''),(1286,'1','307','1',1,'Retail Sale Id 1270',2249.60,0.00,0.00,3.04,334.40,'2023-01-26 07:30:48','',''),(1287,'1','307','1',1,'Retail Sale Id 1271',9250.00,0.00,0.00,12.50,1375.00,'2023-01-26 07:32:20','',''),(1288,'1','307','1',1,'Retail Sale Id 1272',1998.00,0.00,0.00,2.70,297.00,'2023-01-26 08:02:43','',''),(1289,'1','307','1',1,'Retail Sale Id 1273',7999.40,0.00,0.00,10.81,1189.10,'2023-01-26 08:18:10','',''),(1290,'1','307','1',1,'Retail Sale Id 1274',2301.40,0.00,0.00,3.11,342.10,'2023-01-26 08:27:51','',''),(1291,'1','307','1',1,'Retail Sale Id 1275',1502.20,0.00,0.00,2.03,223.30,'2023-01-26 08:33:38','',''),(1292,'1','307','1',1,'Retail Sale Id 1276',2501.20,0.00,0.00,3.38,371.80,'2023-01-26 08:55:24','',''),(1293,'1','307','1',1,'Retail Sale Id 1277',9250.00,0.00,0.00,12.50,1375.00,'2023-01-26 09:00:03','',''),(1294,'1','307','1',1,'Retail Sale Id 1278',4447.40,0.00,0.00,6.01,661.10,'2023-01-26 09:27:56','',''),(1295,'1','307','1',1,'Retail Sale Id 1279',2249.60,0.00,0.00,3.04,334.40,'2023-01-26 09:29:17','',''),(1296,'1','307','1',1,'Retail Sale Id 1280',28000.00,0.00,0.00,40.00,2800.00,'2023-01-26 09:30:57','',''),(1297,'1','307','1',1,'Retail Sale Id 1281',2997.00,0.00,0.00,4.05,445.50,'2023-01-26 09:44:42','',''),(1298,'1','307','1',1,'Retail Sale Id 1282',9250.00,0.00,0.00,12.50,1375.00,'2023-01-26 09:49:42','',''),(1299,'1','307','1',1,'Retail Sale Id 1283',703.00,0.00,0.00,0.95,104.50,'2023-01-26 09:50:52','',''),(1300,'1','307','1',1,'Retail Sale Id 1284',4440.00,0.00,0.00,6.00,660.00,'2023-01-26 10:03:49','',''),(1301,'1','307','1',1,'Retail Sale Id 1285',1998.00,0.00,0.00,2.70,297.00,'2023-01-26 10:09:54','',''),(1302,'1','307','1',1,'Retail Sale Id 1285',5002.40,0.00,0.00,6.76,743.60,'2023-01-26 10:09:54','',''),(1303,'1','307','1',1,'Retail Sale Id 1286',2997.00,0.00,0.00,4.05,445.50,'2023-01-26 10:11:29','',''),(1304,'1','307','1',1,'Retail Sale Id 1287',4499.20,0.00,0.00,6.08,668.80,'2023-01-26 10:12:49','',''),(1305,'1','307','1',1,'Retail Sale Id 1288',3700.00,0.00,0.00,5.00,550.00,'2023-01-26 10:31:03','',''),(1306,'1','307','1',1,'Retail Sale Id 1289',2301.40,0.00,0.00,3.11,342.10,'2023-01-26 10:39:49','',''),(1307,'1','307','1',1,'Retail Sale Id 1290',1598.40,0.00,0.00,2.16,237.60,'2023-01-26 10:55:18','',''),(1308,'1','307','1',1,'Retail Sale Id 1291',35000.00,0.00,0.00,50.00,3500.00,'2023-01-26 11:12:14','',''),(1309,'1','307','1',1,'Retail Sale Id 1292',740.00,0.00,0.00,1.00,110.00,'2023-01-26 11:17:32','',''),(1310,'1','307','1',1,'Retail Sale Id 1293',9250.00,0.00,0.00,12.50,1375.00,'2023-01-26 11:34:47','',''),(1311,'1','307','1',1,'Retail Sale Id 1294',9250.00,0.00,0.00,12.50,1375.00,'2023-01-26 11:36:12','',''),(1312,'1','307','1',1,'Retail Sale Id 1294',9250.00,0.00,0.00,12.50,1375.00,'2023-01-26 11:36:12','',''),(1313,'1','307','1',1,'Retail Sale Id 1295',4447.40,0.00,0.00,6.01,661.10,'2023-01-26 11:38:43','',''),(1314,'1','307','1',1,'Retail Sale Id 1296',1502.20,0.00,0.00,2.03,223.30,'2023-01-26 11:58:05','',''),(1315,'1','307','1',1,'Retail Sale Id 1297',3700.00,0.00,0.00,5.00,550.00,'2023-01-26 12:15:12','',''),(1316,'1','307','1',1,'Retail Sale Id 1297',3700.00,0.00,0.00,5.00,550.00,'2023-01-26 12:15:12','',''),(1317,'1','307','1',1,'Retail Sale Id 1298',1502.20,0.00,0.00,2.03,223.30,'2023-01-26 12:31:14','',''),(1318,'1','307','1',1,'Retail Sale Id 1299',7000.40,0.00,0.00,9.46,1040.60,'2023-01-26 13:16:32','',''),(1319,'1','307','1',1,'Retail Sale Id 1300',2249.60,0.00,0.00,3.04,334.40,'2023-01-26 13:18:12','',''),(1320,'1','307','1',1,'Retail Sale Id 1301',1998.00,0.00,0.00,2.70,297.00,'2023-01-26 13:19:08','',''),(1321,'1','307','1',1,'Retail Sale Id 1302',2220.00,0.00,0.00,3.00,330.00,'2023-01-26 14:30:00','',''),(1322,'1','307','1',1,'Retail Sale Id 1303',4447.40,0.00,0.00,6.01,661.10,'2023-01-26 14:48:57','',''),(1323,'1','307','1',1,'Retail Sale Id 1304',1502.20,0.00,0.00,2.03,223.30,'2023-01-26 15:13:40','',''),(1324,'1','307','1',1,'Retail Sale Id 1305',747.40,0.00,0.00,1.01,111.10,'2023-01-26 15:14:51','',''),(1325,'1','307','1',1,'Retail Sale Id 1306',1502.20,0.00,0.00,2.03,223.30,'2023-01-26 15:36:28','',''),(1326,'1','307','1',1,'Retail Sale Id 1307',9250.00,0.00,0.00,12.50,1375.00,'2023-01-26 15:42:17','',''),(1327,'1','307','1',1,'Retail Sale Id 1308',52500.00,0.00,0.00,75.00,5250.00,'2023-01-26 15:48:13','',''),(1328,'1','307','1',1,'Retail Sale Id 1309',1302.40,0.00,0.00,1.76,193.60,'2023-01-26 15:55:20','',''),(1329,'1','307','1',1,'Retail Sale Id 1310',4447.40,0.00,0.00,6.01,661.10,'2023-01-26 16:29:21','',''),(1330,'1','307','1',1,'Retail Sale Id 1311',9250.00,0.00,0.00,12.50,1375.00,'2023-01-26 16:35:19','',''),(1331,'1','307','1',1,'Retail Sale Id 1312',4440.00,0.00,0.00,6.00,660.00,'2023-01-26 16:58:44','',''),(1332,'1','307','1',1,'Retail Sale Id 1313',2997.00,0.00,0.00,4.05,445.50,'2023-01-26 17:01:49','',''),(1333,'1','307','1',1,'Retail Sale Id 1314',35000.00,0.00,0.00,50.00,3500.00,'2023-01-26 17:13:51','',''),(1334,'1','307','1',1,'Retail Sale Id 1315',2997.00,0.00,0.00,4.05,445.50,'2023-01-26 17:16:56','',''),(1335,'1','307','1',1,'Retail Sale Id 1316',740.00,0.00,0.00,1.00,110.00,'2023-01-26 17:32:19','',''),(1336,'1','307','1',1,'Retail Sale Id 1317',5180.00,0.00,0.00,7.00,770.00,'2023-01-26 17:34:34','',''),(1337,'1','307','1',1,'Retail Sale Id 1318',4447.40,0.00,0.00,6.01,661.10,'2023-01-26 17:40:22','',''),(1338,'1','307','1',1,'Retail Sale Id 1319',2960.00,0.00,0.00,4.00,440.00,'2023-01-26 17:51:39','',''),(1339,'1','307','1',1,'Retail Sale Id 1320',8199.20,0.00,0.00,11.08,1218.80,'2023-01-26 18:13:21','',''),(1340,'1','307','1',1,'Retail Sale Id 1321',9250.00,0.00,0.00,12.50,1375.00,'2023-01-26 18:33:45','',''),(1341,'1','307','1',1,'Retail Sale Id 1322',3700.00,0.00,0.00,5.00,550.00,'2023-01-26 18:36:04','',''),(1342,'1','307','1',1,'Retail Sale Id 1323',1546.60,0.00,0.00,2.09,229.90,'2023-01-26 18:54:14','',''),(1343,'1','307','1',1,'Retail Sale Id 1324',9250.00,0.00,0.00,12.50,1375.00,'2023-01-27 07:39:41','',''),(1344,'1','307','1',1,'Retail Sale Id 1325',9250.00,0.00,0.00,12.50,1375.00,'2023-01-27 08:03:58','',''),(1345,'1','307','1',1,'Retail Sale Id 1326',2249.60,0.00,0.00,3.04,334.40,'2023-01-27 08:46:54','',''),(1346,'1','307','1',1,'Retail Sale Id 1327',6001.40,0.00,0.00,8.11,892.10,'2023-01-27 09:17:12','',''),(1347,'1','307','1',1,'Retail Sale Id 1328',1502.20,0.00,0.00,2.03,223.30,'2023-01-27 09:25:41','',''),(1348,'1','307','1',1,'Retail Sale Id 1329',2220.00,0.00,0.00,3.00,330.00,'2023-01-27 09:46:14','',''),(1349,'1','307','1',1,'Retail Sale Id 1330',2220.00,0.00,0.00,3.00,330.00,'2023-01-27 10:07:30','',''),(1350,'1','307','1',1,'Retail Sale Id 1331',9250.00,0.00,0.00,12.50,1375.00,'2023-01-27 10:37:48','',''),(1351,'1','307','1',1,'Retail Sale Id 1332',3700.00,0.00,0.00,5.00,550.00,'2023-01-27 10:52:07','',''),(1352,'1','307','1',1,'Retail Sale Id 1333',2249.60,0.00,0.00,3.04,334.40,'2023-01-27 10:59:17','',''),(1353,'1','307','1',1,'Retail Sale Id 1334',19999.00,0.00,0.00,28.57,1999.90,'2023-01-27 11:10:30','',''),(1354,'1','307','1',1,'Retail Sale Id 1335',4447.40,0.00,0.00,6.01,661.10,'2023-01-27 11:27:46','',''),(1355,'1','307','1',1,'Retail Sale Id 1336',4447.40,0.00,0.00,6.01,661.10,'2023-01-27 11:32:51','',''),(1356,'1','307','1',1,'Retail Sale Id 1337',8199.20,0.00,0.00,11.08,1218.80,'2023-01-27 11:51:13','',''),(1357,'1','307','1',1,'Retail Sale Id 1338',3700.00,0.00,0.00,5.00,550.00,'2023-01-27 11:53:12','',''),(1358,'1','307','1',1,'Retail Sale Id 1339',2997.00,0.00,0.00,4.05,445.50,'2023-01-27 11:54:53','',''),(1359,'1','307','1',1,'Retail Sale Id 1340',2220.00,0.00,0.00,3.00,330.00,'2023-01-27 11:59:50','',''),(1360,'1','307','1',1,'Retail Sale Id 1341',4447.40,0.00,0.00,6.01,661.10,'2023-01-27 12:02:56','',''),(1361,'1','307','1',1,'Retail Sale Id 1342',4447.40,0.00,0.00,6.01,661.10,'2023-01-27 12:09:01','',''),(1362,'1','307','1',1,'Retail Sale Id 1343',2197.80,0.00,0.00,2.97,326.70,'2023-01-27 13:59:49','',''),(1363,'1','307','1',1,'Retail Sale Id 1344',3700.00,0.00,0.00,5.00,550.00,'2023-01-27 14:08:13','',''),(1364,'1','307','1',1,'Retail Sale Id 1345',2501.20,0.00,0.00,3.38,371.80,'2023-01-27 14:13:27','',''),(1365,'1','307','1',1,'Retail Sale Id 1346',1502.20,0.00,0.00,2.03,223.30,'2023-01-27 14:18:47','',''),(1366,'1','307','1',1,'Retail Sale Id 1347',70000.00,0.00,0.00,100.00,7000.00,'2023-01-27 15:16:41','',''),(1367,'1','307','1',1,'Retail Sale Id 1348',35000.00,0.00,0.00,50.00,3500.00,'2023-01-27 15:18:53','',''),(1368,'1','307','1',1,'Retail Sale Id 1349',4447.40,0.00,0.00,6.01,661.10,'2023-01-27 15:29:03','',''),(1369,'1','307','1',1,'Retail Sale Id 1350',2220.00,0.00,0.00,3.00,330.00,'2023-01-27 15:54:08','',''),(1370,'1','307','1',1,'Retail Sale Id 1351',2220.00,0.00,0.00,3.00,330.00,'2023-01-27 16:08:12','',''),(1371,'1','307','1',1,'Retail Sale Id 1352',1480.00,0.00,0.00,2.00,220.00,'2023-01-27 16:24:33','',''),(1372,'1','307','1',1,'Retail Sale Id 1353',2997.00,0.00,0.00,4.05,445.50,'2023-01-27 16:34:29','',''),(1373,'1','307','1',1,'Retail Sale Id 1354',3700.00,0.00,0.00,5.00,550.00,'2023-01-27 16:42:44','',''),(1374,'1','307','1',1,'Retail Sale Id 1355',3700.00,0.00,0.00,5.00,550.00,'2023-01-27 16:45:25','',''),(1375,'1','307','1',1,'Retail Sale Id 1356',1502.20,0.00,0.00,2.03,223.30,'2023-01-27 16:48:39','',''),(1376,'1','307','1',1,'Retail Sale Id 1357',4447.40,0.00,0.00,6.01,661.10,'2023-01-27 17:02:25','',''),(1377,'1','307','1',1,'Retail Sale Id 1358',1502.20,0.00,0.00,2.03,223.30,'2023-01-27 17:03:52','',''),(1378,'1','307','1',1,'Retail Sale Id 1359',4447.40,0.00,0.00,6.01,661.10,'2023-01-27 17:13:18','',''),(1379,'1','307','1',1,'Retail Sale Id 1360',2227.40,0.00,0.00,3.01,331.10,'2023-01-27 17:16:10','',''),(1380,'1','307','1',1,'Retail Sale Id 1361',799.20,0.00,0.00,1.08,118.80,'2023-01-27 17:20:27','',''),(1381,'1','307','1',1,'Retail Sale Id 1362',35000.00,0.00,0.00,50.00,3500.00,'2023-01-27 17:32:27','',''),(1382,'1','307','1',1,'Retail Sale Id 1363',2249.60,0.00,0.00,3.04,334.40,'2023-01-27 17:48:17','',''),(1383,'1','307','1',1,'Retail Sale Id 1364',9250.00,0.00,0.00,12.50,1375.00,'2023-01-27 17:50:57','',''),(1384,'1','307','1',1,'Retail Sale Id 1365',1502.20,0.00,0.00,2.03,223.30,'2023-01-27 17:53:32','',''),(1385,'1','307','1',1,'Retail Sale Id 1367',1998.00,0.00,0.00,2.70,297.00,'2023-01-27 17:54:20','',''),(1386,'1','307','1',1,'Retail Sale Id 1368',799.20,0.00,0.00,1.08,118.80,'2023-01-27 18:06:44','',''),(1387,'1','307','1',1,'Retail Sale Id 1369',1998.00,0.00,0.00,2.70,297.00,'2023-01-27 18:14:57','',''),(1388,'1','307','1',1,'Retail Sale Id 1370',2960.00,0.00,0.00,4.00,440.00,'2023-01-27 18:23:19','',''),(1389,'1','307','1',1,'Retail Sale Id 1371',740.00,0.00,0.00,1.00,110.00,'2023-01-27 18:24:45','',''),(1390,'1','307','1',1,'Retail Sale Id 1372',35000.00,0.00,0.00,50.00,3500.00,'2023-01-27 18:50:29','',''),(1391,'1','307','1',1,'Retail Sale Id 1373',4440.00,0.00,0.00,6.00,660.00,'2023-01-27 18:53:12','',''),(1392,'1','307','1',1,'Retail Sale Id 1374',799.20,0.00,0.00,1.08,118.80,'2023-01-27 19:07:09','',''),(1393,'1','307','1',1,'Retail Sale Id 1375',5194.80,0.00,0.00,7.02,772.20,'2023-01-27 19:09:36','',''),(1394,'1','307','1',1,'Retail Sale Id 1376',9250.00,0.00,0.00,12.50,1375.00,'2023-01-28 07:21:13','',''),(1395,'1','307','1',1,'Retail Sale Id 1377',7999.40,0.00,0.00,10.81,1189.10,'2023-01-28 08:12:09','',''),(1396,'1','307','1',1,'Retail Sale Id 1378',2220.00,0.00,0.00,3.00,330.00,'2023-01-28 08:26:47','',''),(1397,'1','307','1',1,'Retail Sale Id 1379',1502.20,0.00,0.00,2.03,223.30,'2023-01-28 08:58:34','',''),(1398,'1','307','1',1,'Retail Sale Id 1380',9250.00,0.00,0.00,12.50,1375.00,'2023-01-28 09:02:40','',''),(1399,'1','307','1',1,'Retail Sale Id 1381',9250.00,0.00,0.00,12.50,1375.00,'2023-01-28 09:14:42','',''),(1400,'1','307','1',1,'Retail Sale Id 1382',9250.00,0.00,0.00,12.50,1375.00,'2023-01-28 09:31:44','',''),(1401,'1','307','1',1,'Retail Sale Id 1383',2997.00,0.00,0.00,4.05,445.50,'2023-01-28 09:32:23','',''),(1402,'1','307','1',1,'Retail Sale Id 1384',35000.00,0.00,0.00,50.00,3500.00,'2023-01-28 10:15:28','',''),(1403,'1','307','1',1,'Retail Sale Id 1385',2220.00,0.00,0.00,3.00,330.00,'2023-01-28 10:19:01','',''),(1404,'1','307','1',1,'Retail Sale Id 1387',2960.00,0.00,0.00,4.00,440.00,'2023-01-28 10:34:05','',''),(1405,'1','307','1',1,'Retail Sale Id 1388',4447.40,0.00,0.00,6.01,661.10,'2023-01-28 10:40:55','',''),(1406,'1','307','1',1,'Retail Sale Id 1389',23800.00,0.00,0.00,34.00,2380.00,'2023-01-28 10:50:35','',''),(1407,'1','307','1',1,'Retail Sale Id 1390',2301.40,0.00,0.00,3.11,342.10,'2023-01-28 11:01:50','',''),(1408,'1','307','1',1,'Retail Sale Id 1391',2220.00,0.00,0.00,3.00,330.00,'2023-01-28 11:09:57','',''),(1409,'1','307','1',1,'Retail Sale Id 1392',2220.00,0.00,0.00,3.00,330.00,'2023-01-28 11:16:17','',''),(1410,'1','307','1',1,'Retail Sale Id 1393',4447.40,0.00,0.00,6.01,661.10,'2023-01-28 11:19:56','',''),(1411,'1','307','1',1,'Retail Sale Id 1394',4447.40,0.00,0.00,6.01,661.10,'2023-01-28 12:04:52','',''),(1412,'1','307','1',1,'Retail Sale Id 1395',1502.20,0.00,0.00,2.03,223.30,'2023-01-28 12:27:06','',''),(1413,'1','307','1',1,'Retail Sale Id 1396',7400.00,0.00,0.00,10.00,1100.00,'2023-01-28 12:52:55','',''),(1414,'1','307','1',1,'Retail Sale Id 1397',9250.00,0.00,0.00,12.50,1375.00,'2023-01-28 13:17:55','',''),(1415,'1','307','1',1,'Retail Sale Id 1398',7400.00,0.00,0.00,10.00,1100.00,'2023-01-28 13:20:31','',''),(1416,'1','307','1',1,'Retail Sale Id 1399',503.20,0.00,0.00,0.68,74.80,'2023-01-28 13:38:47','',''),(1417,'1','307','1',1,'Retail Sale Id 1401',399.60,0.00,0.00,0.54,59.40,'2023-01-28 13:59:55','',''),(1418,'1','307','1',1,'Retail Sale Id 1402',4447.40,0.00,0.00,6.01,661.10,'2023-01-28 14:07:30','',''),(1419,'1','307','1',1,'Retail Sale Id 1403',3700.00,0.00,0.00,5.00,550.00,'2023-01-28 14:34:02','',''),(1420,'1','307','1',1,'Retail Sale Id 1404',2997.00,0.00,0.00,4.05,445.50,'2023-01-28 15:28:59','',''),(1421,'1','307','1',1,'Retail Sale Id 1405',4499.20,0.00,0.00,6.08,668.80,'2023-01-28 15:45:00','',''),(1422,'1','307','1',1,'Retail Sale Id 1406',4447.40,0.00,0.00,6.01,661.10,'2023-01-28 16:19:40','',''),(1423,'1','307','1',1,'Retail Sale Id 1408',1502.20,0.00,0.00,2.03,223.30,'2023-01-28 16:45:45','',''),(1424,'1','307','1',1,'Retail Sale Id 1409',1998.00,0.00,0.00,2.70,297.00,'2023-01-28 17:18:23','',''),(1425,'1','307','1',1,'Retail Sale Id 1410',4447.40,0.00,0.00,6.01,661.10,'2023-01-28 17:26:17','',''),(1426,'1','307','1',1,'Retail Sale Id 1411',6697.00,0.00,0.00,9.05,995.50,'2023-01-28 17:32:23','',''),(1427,'1','307','1',1,'Retail Sale Id 1412',2249.60,0.00,0.00,3.04,334.40,'2023-01-28 17:41:58','',''),(1428,'1','307','1',1,'Retail Sale Id 1413',1998.00,0.00,0.00,2.70,297.00,'2023-01-28 17:45:48','',''),(1429,'1','307','1',1,'Retail Sale Id 1414',799.20,0.00,0.00,1.08,118.80,'2023-01-28 17:51:12','',''),(1430,'1','307','1',1,'Retail Sale Id 1415',2220.00,0.00,0.00,3.00,330.00,'2023-01-28 17:55:33','',''),(1431,'1','307','1',1,'Retail Sale Id 1416',9250.00,0.00,0.00,12.50,1375.00,'2023-01-28 18:13:03','',''),(1432,'1','307','1',1,'Retail Sale Id 1417',3500.20,0.00,0.00,4.73,520.30,'2023-01-28 18:16:59','',''),(1433,'1','307','1',1,'Retail Sale Id 1418',4447.40,0.00,0.00,6.01,661.10,'2023-01-28 18:23:03','',''),(1434,'1','307','1',1,'Retail Sale Id 1419',1502.20,0.00,0.00,2.03,223.30,'2023-01-28 18:26:53','',''),(1435,'1','307','1',1,'Retail Sale Id 1420',1502.20,0.00,0.00,2.03,223.30,'2023-01-28 18:29:04','',''),(1436,'1','307','1',1,'Retail Sale Id 1421',27300.00,0.00,0.00,39.00,2730.00,'2023-01-28 18:30:53','',''),(1437,'1','307','1',1,'Retail Sale Id 1422',4447.40,0.00,0.00,6.01,661.10,'2023-01-28 18:59:14','',''),(1438,'1','307','1',1,'Retail Sale Id 1423',1502.20,0.00,0.00,2.03,223.30,'2023-01-28 19:04:57','',''),(1439,'1','307','1',1,'Retail Sale Id 1423',3700.00,0.00,0.00,5.00,550.00,'2023-01-28 19:04:57','',''),(1440,'1','307','1',1,'Retail Sale Id 1424',791.80,0.00,0.00,1.07,117.70,'2023-01-28 19:29:00','',''),(1441,'1','307','1',1,'Retail Sale Id 1425',2997.00,0.00,0.00,4.05,445.50,'2023-01-29 07:48:40','',''),(1442,'1','307','1',1,'Retail Sale Id 1426',1502.20,0.00,0.00,2.03,223.30,'2023-01-29 08:46:31','',''),(1443,'1','307','1',1,'Retail Sale Id 1427',2997.00,0.00,0.00,4.05,445.50,'2023-01-29 08:57:03','',''),(1444,'1','307','1',1,'Retail Sale Id 1428',3700.00,0.00,0.00,5.00,550.00,'2023-01-29 09:04:39','',''),(1445,'1','307','1',1,'Retail Sale Id 1429',70000.00,0.00,0.00,100.00,7000.00,'2023-01-29 10:13:12','',''),(1446,'1','307','1',1,'Retail Sale Id 1430',7400.00,0.00,0.00,10.00,1100.00,'2023-01-29 10:14:24','',''),(1447,'1','307','1',1,'Retail Sale Id 1431',1998.00,0.00,0.00,2.70,297.00,'2023-01-29 10:19:42','',''),(1448,'1','307','1',1,'Retail Sale Id 1432',9250.00,0.00,0.00,12.50,1375.00,'2023-01-29 10:31:33','',''),(1449,'1','307','1',1,'Retail Sale Id 1433',799.20,0.00,0.00,1.08,118.80,'2023-01-29 10:32:37','',''),(1450,'1','307','1',1,'Retail Sale Id 1434',1998.00,0.00,0.00,2.70,297.00,'2023-01-29 10:49:20','',''),(1451,'1','307','1',1,'Retail Sale Id 1435',999.00,0.00,0.00,1.35,148.50,'2023-01-29 11:00:42','',''),(1452,'1','307','1',1,'Retail Sale Id 1436',2220.00,0.00,0.00,3.00,330.00,'2023-01-29 11:03:27','',''),(1453,'1','307','1',1,'Retail Sale Id 1437',4447.40,0.00,0.00,6.01,661.10,'2023-01-29 11:25:56','',''),(1454,'1','307','1',1,'Retail Sale Id 1438',9250.00,0.00,0.00,12.50,1375.00,'2023-01-29 11:42:20','',''),(1455,'1','307','1',1,'Retail Sale Id 1439',2501.20,0.00,0.00,3.38,371.80,'2023-01-29 11:53:48','',''),(1456,'1','307','1',1,'Retail Sale Id 1440',2249.60,0.00,0.00,3.04,334.40,'2023-01-29 11:55:03','',''),(1457,'1','307','1',1,'Retail Sale Id 1441',1502.20,0.00,0.00,2.03,223.30,'2023-01-29 11:57:08','',''),(1458,'1','307','1',1,'Retail Sale Id 1442',2220.00,0.00,0.00,3.00,330.00,'2023-01-29 12:06:18','',''),(1459,'1','307','1',1,'Retail Sale Id 1443',4447.40,0.00,0.00,6.01,661.10,'2023-01-29 12:47:17','',''),(1460,'1','307','1',1,'Retail Sale Id 1444',3700.00,0.00,0.00,5.00,550.00,'2023-01-29 12:53:47','',''),(1461,'1','307','1',1,'Retail Sale Id 1445',7400.00,0.00,0.00,10.00,1100.00,'2023-01-29 13:39:13','',''),(1462,'1','307','1',1,'Retail Sale Id 1446',2501.20,0.00,0.00,3.38,371.80,'2023-01-29 14:01:39','',''),(1463,'1','307','1',1,'Retail Sale Id 1447',2960.00,0.00,0.00,4.00,440.00,'2023-01-29 14:08:21','',''),(1464,'1','307','1',1,'Retail Sale Id 1448',4447.40,0.00,0.00,6.01,661.10,'2023-01-29 14:11:35','',''),(1465,'1','307','1',1,'Retail Sale Id 1449',3700.00,0.00,0.00,5.00,550.00,'2023-01-29 14:20:00','',''),(1466,'1','307','1',1,'Retail Sale Id 1450',1502.20,0.00,0.00,2.03,223.30,'2023-01-29 14:22:14','',''),(1467,'1','307','1',1,'Retail Sale Id 1451',4447.40,0.00,0.00,6.01,661.10,'2023-01-29 14:30:19','',''),(1468,'1','307','1',1,'Retail Sale Id 1452',3700.00,0.00,0.00,5.00,550.00,'2023-01-29 15:21:33','',''),(1469,'1','307','1',1,'Retail Sale Id 1453',747.40,0.00,0.00,1.01,111.10,'2023-01-29 15:34:53','',''),(1470,'1','307','1',1,'Retail Sale Id 1454',2249.60,0.00,0.00,3.04,334.40,'2023-01-29 15:36:39','',''),(1471,'1','307','1',1,'Retail Sale Id 1455',4447.40,0.00,0.00,6.01,661.10,'2023-01-29 15:39:31','',''),(1472,'1','307','1',1,'Retail Sale Id 1456',3700.00,0.00,0.00,5.00,550.00,'2023-01-29 15:40:22','',''),(1473,'1','307','1',1,'Retail Sale Id 1457',4440.00,0.00,0.00,6.00,660.00,'2023-01-29 15:51:55','',''),(1474,'1','307','1',1,'Retail Sale Id 1458',87500.00,0.00,0.00,125.00,8750.00,'2023-01-29 16:28:40','',''),(1475,'1','307','1',1,'Retail Sale Id 1459',999.00,0.00,0.00,1.35,148.50,'2023-01-29 16:45:13','',''),(1476,'1','307','1',1,'Retail Sale Id 1460',35000.00,0.00,0.00,50.00,3500.00,'2023-01-29 17:20:28','',''),(1477,'1','307','1',1,'Retail Sale Id 1461',4447.40,0.00,0.00,6.01,661.10,'2023-01-29 17:29:29','',''),(1478,'1','307','1',1,'Retail Sale Id 1462',70000.00,0.00,0.00,100.00,7000.00,'2023-01-29 17:41:21','',''),(1479,'1','307','1',1,'Retail Sale Id 1463',2197.80,0.00,0.00,2.97,326.70,'2023-01-29 17:43:05','',''),(1480,'1','307','1',1,'Retail Sale Id 1464',2249.60,0.00,0.00,3.04,334.40,'2023-01-29 17:45:50','',''),(1481,'1','307','1',1,'Retail Sale Id 1465',1502.20,0.00,0.00,2.03,223.30,'2023-01-29 17:51:31','',''),(1482,'1','307','1',1,'Retail Sale Id 1466',902.80,0.00,0.00,1.22,134.20,'2023-01-29 17:58:32','',''),(1483,'1','307','1',1,'Retail Sale Id 1467',4447.40,0.00,0.00,6.01,661.10,'2023-01-29 18:11:25','',''),(1484,'1','307','1',1,'Retail Sale Id 1468',9250.00,0.00,0.00,12.50,1375.00,'2023-01-29 18:13:15','',''),(1485,'1','307','1',1,'Retail Sale Id 1469',4447.40,0.00,0.00,6.01,661.10,'2023-01-29 18:19:19','',''),(1486,'1','307','1',1,'Retail Sale Id 1470',2997.00,0.00,0.00,4.05,445.50,'2023-01-29 18:35:41','',''),(1487,'1','307','1',1,'Retail Sale Id 1471',1502.20,0.00,0.00,2.03,223.30,'2023-01-29 18:36:54','',''),(1488,'1','307','1',1,'Retail Sale Id 1472',9250.00,0.00,0.00,12.50,1375.00,'2023-01-29 18:51:09','',''),(1489,'1','307','1',1,'Retail Sale Id 1473',12239.60,0.00,0.00,16.54,1819.40,'2023-01-29 19:08:35','',''),(1490,'1','307','1',1,'Retail Sale Id 1474',4447.40,0.00,0.00,6.01,661.10,'2023-01-30 07:13:51','',''),(1491,'1','307','1',1,'Retail Sale Id 1475',2249.60,0.00,0.00,3.04,334.40,'2023-01-30 07:30:19','',''),(1492,'1','307','1',1,'Retail Sale Id 1476',9250.00,0.00,0.00,12.50,1375.00,'2023-01-30 07:31:27','',''),(1493,'1','307','1',1,'Retail Sale Id 1477',4447.40,0.00,0.00,6.01,661.10,'2023-01-30 07:35:04','',''),(1494,'1','307','1',1,'Retail Sale Id 1478',2997.00,0.00,0.00,4.05,445.50,'2023-01-30 07:37:58','',''),(1495,'1','307','1',1,'Retail Sale Id 1479',9250.00,0.00,0.00,12.50,1375.00,'2023-01-30 08:24:08','',''),(1496,'1','307','1',1,'Retail Sale Id 1480',4447.40,0.00,0.00,6.01,661.10,'2023-01-30 08:24:46','',''),(1497,'1','307','1',1,'Retail Sale Id 1481',4454.80,0.00,0.00,6.02,662.20,'2023-01-30 08:53:06','',''),(1498,'1','307','1',1,'Retail Sale Id 1482',4447.40,0.00,0.00,6.01,661.10,'2023-01-30 08:55:29','',''),(1499,'1','307','1',1,'Retail Sale Id 1483',902.80,0.00,0.00,1.22,134.20,'2023-01-30 09:27:58','',''),(1500,'1','307','1',1,'Retail Sale Id 1484',35000.00,0.00,0.00,50.00,3500.00,'2023-01-30 10:44:55','',''),(1501,'1','307','1',1,'Retail Sale Id 1485',2997.00,0.00,0.00,4.05,445.50,'2023-01-30 11:06:09','',''),(1502,'1','307','1',1,'Retail Sale Id 1486',3700.00,0.00,0.00,5.00,550.00,'2023-01-30 11:30:16','',''),(1503,'1','307','1',1,'Retail Sale Id 1487',35000.00,0.00,0.00,50.00,3500.00,'2023-01-30 11:40:57','',''),(1504,'1','307','1',1,'Retail Sale Id 1488',3700.00,0.00,0.00,5.00,550.00,'2023-01-30 12:24:46','',''),(1505,'1','307','1',1,'Retail Sale Id 1489',1480.00,0.00,0.00,2.00,220.00,'2023-01-30 12:27:48','',''),(1506,'1','307','1',1,'Retail Sale Id 1490',2301.40,0.00,0.00,3.11,342.10,'2023-01-30 12:34:44','',''),(1507,'1','307','1',1,'Retail Sale Id 1491',9250.00,0.00,0.00,12.50,1375.00,'2023-01-30 12:36:25','',''),(1508,'1','307','1',1,'Retail Sale Id 1492',2997.00,0.00,0.00,4.05,445.50,'2023-01-30 12:44:37','',''),(1509,'1','307','1',1,'Retail Sale Id 1493',4447.40,0.00,0.00,6.01,661.10,'2023-01-30 14:10:42','',''),(1510,'1','307','1',1,'Retail Sale Id 1494',4447.40,0.00,0.00,6.01,661.10,'2023-01-30 14:41:43','',''),(1511,'1','307','1',1,'Retail Sale Id 1495',2997.00,0.00,0.00,4.05,445.50,'2023-01-30 15:30:56','',''),(1512,'1','307','1',1,'Retail Sale Id 1496',1502.20,0.00,0.00,2.03,223.30,'2023-01-30 16:01:19','',''),(1513,'1','307','1',1,'Retail Sale Id 1497',799.20,0.00,0.00,1.08,118.80,'2023-01-30 16:14:36','',''),(1514,'1','307','1',1,'Retail Sale Id 1498',1502.20,0.00,0.00,2.03,223.30,'2023-01-30 16:16:25','',''),(1515,'1','307','1',1,'Retail Sale Id 1499',4447.40,0.00,0.00,6.01,661.10,'2023-01-30 16:34:35','',''),(1516,'1','307','1',1,'Retail Sale Id 1500',4003.40,0.00,0.00,5.41,595.10,'2023-01-30 16:40:01','',''),(1517,'1','307','1',1,'Retail Sale Id 1500',5002.40,0.00,0.00,6.76,743.60,'2023-01-30 16:40:01','',''),(1518,'1','307','1',1,'Retail Sale Id 1501',3500.20,0.00,0.00,4.73,520.30,'2023-01-30 16:55:37','',''),(1519,'1','307','1',1,'Retail Sale Id 1502',2997.00,0.00,0.00,4.05,445.50,'2023-01-30 16:57:24','',''),(1520,'1','307','1',1,'Retail Sale Id 1503',1502.20,0.00,0.00,2.03,223.30,'2023-01-30 17:10:18','',''),(1521,'1','307','1',1,'Retail Sale Id 1504',2997.00,0.00,0.00,4.05,445.50,'2023-01-30 17:25:36','',''),(1522,'1','307','1',1,'Retail Sale Id 1505',2997.00,0.00,0.00,4.05,445.50,'2023-01-30 17:32:44','',''),(1523,'1','307','1',1,'Retail Sale Id 1506',1998.00,0.00,0.00,2.70,297.00,'2023-01-30 17:45:27','',''),(1524,'1','307','1',1,'Retail Sale Id 1507',2249.60,0.00,0.00,3.04,334.40,'2023-01-30 17:47:24','',''),(1525,'1','307','1',1,'Retail Sale Id 1508',2249.60,0.00,0.00,3.04,334.40,'2023-01-30 17:49:58','',''),(1526,'1','307','1',1,'Retail Sale Id 1509',2997.00,0.00,0.00,4.05,445.50,'2023-01-30 18:00:48','',''),(1527,'1','307','1',1,'Retail Sale Id 1510',4447.40,0.00,0.00,6.01,661.10,'2023-01-30 18:04:30','',''),(1528,'1','307','1',1,'Retail Sale Id 1511',3700.00,0.00,0.00,5.00,550.00,'2023-01-30 18:10:37','',''),(1529,'1','307','1',1,'Retail Sale Id 1512',2997.00,0.00,0.00,4.05,445.50,'2023-01-30 18:17:48','',''),(1530,'1','307','1',1,'Retail Sale Id 1513',703.00,0.00,0.00,0.95,104.50,'2023-01-30 18:19:17','',''),(1531,'1','307','1',1,'Retail Sale Id 1514',35000.00,0.00,0.00,50.00,3500.00,'2023-01-30 18:22:00','',''),(1532,'1','307','1',1,'Retail Sale Id 1515',1502.20,0.00,0.00,2.03,223.30,'2023-01-30 18:24:28','',''),(1533,'1','307','1',1,'Retail Sale Id 1516',747.40,0.00,0.00,1.01,111.10,'2023-01-30 18:25:37','',''),(1534,'1','307','1',1,'Retail Sale Id 1517',9250.00,0.00,0.00,12.50,1375.00,'2023-01-30 18:59:33','',''),(1535,'1','307','1',1,'Retail Sale Id 1518',1798.20,0.00,0.00,2.43,267.30,'2023-01-30 19:00:39','',''),(1536,'1','307','1',1,'Retail Sale Id 1519',1990.60,0.00,0.00,2.69,295.90,'2023-01-30 19:12:51','',''),(1537,'1','307','1',1,'Retail Sale Id 1520',4447.40,0.00,0.00,6.01,661.10,'2023-01-31 07:34:42','',''),(1538,'1','307','1',1,'Retail Sale Id 1521',9250.00,0.00,0.00,12.50,1375.00,'2023-01-31 07:56:09','',''),(1539,'1','307','1',1,'Retail Sale Id 1522',1998.00,0.00,0.00,2.70,297.00,'2023-01-31 08:16:50','',''),(1540,'1','307','1',1,'Retail Sale Id 1523',1502.20,0.00,0.00,2.03,223.30,'2023-01-31 08:18:31','',''),(1541,'1','307','1',1,'Retail Sale Id 1524',2997.00,0.00,0.00,4.05,445.50,'2023-01-31 08:23:06','',''),(1542,'1','307','1',1,'Retail Sale Id 1525',70000.00,0.00,0.00,100.00,7000.00,'2023-01-31 08:49:00','',''),(1543,'1','307','1',1,'Retail Sale Id 1526',31500.00,0.00,0.00,45.00,3150.00,'2023-01-31 09:02:53','',''),(1544,'1','307','1',1,'Retail Sale Id 1527',1502.20,0.00,0.00,2.03,223.30,'2023-01-31 09:11:12','',''),(1545,'1','307','1',1,'Retail Sale Id 1528',1502.20,0.00,0.00,2.03,223.30,'2023-01-31 09:12:22','',''),(1546,'1','307','1',1,'Retail Sale Id 1529',2249.60,0.00,0.00,3.04,334.40,'2023-01-31 09:36:33','',''),(1547,'1','307','1',1,'Retail Sale Id 1530',2220.00,0.00,0.00,3.00,330.00,'2023-01-31 09:55:04','',''),(1548,'1','307','1',1,'Retail Sale Id 1531',2997.00,0.00,0.00,4.05,445.50,'2023-01-31 10:00:46','',''),(1549,'1','307','1',1,'Retail Sale Id 1532',2220.00,0.00,0.00,3.00,330.00,'2023-01-31 10:32:33','',''),(1550,'1','307','1',1,'Retail Sale Id 1533',1480.00,0.00,0.00,2.00,220.00,'2023-01-31 11:59:03','',''),(1551,'1','307','1',1,'Retail Sale Id 1534',9250.00,0.00,0.00,12.50,1375.00,'2023-01-31 12:22:47','',''),(1552,'1','307','1',1,'Retail Sale Id 1535',140000.00,0.00,0.00,200.00,14000.00,'2023-01-31 12:28:08','',''),(1553,'1','307','1',1,'Retail Sale Id 1536',2220.00,0.00,0.00,3.00,330.00,'2023-01-31 12:35:26','',''),(1554,'1','307','1',1,'Retail Sale Id 1537',3700.00,0.00,0.00,5.00,550.00,'2023-01-31 13:34:48','',''),(1555,'1','307','1',1,'Retail Sale Id 1538',799.20,0.00,0.00,1.08,118.80,'2023-01-31 14:01:03','',''),(1556,'1','307','1',1,'Retail Sale Id 1539',2249.60,0.00,0.00,3.04,334.40,'2023-01-31 14:55:37','',''),(1557,'1','307','1',1,'Retail Sale Id 1540',9701.40,0.00,0.00,13.11,1442.10,'2023-01-31 15:38:09','',''),(1558,'1','307','1',1,'Retail Sale Id 1541',4447.40,0.00,0.00,6.01,661.10,'2023-01-31 17:29:21','',''),(1559,'1','307','1',1,'Retail Sale Id 1542',4447.40,0.00,0.00,6.01,661.10,'2023-01-31 17:45:41','',''),(1560,'1','307','1',1,'Retail Sale Id 1543',9250.00,0.00,0.00,12.50,1375.00,'2023-01-31 17:56:55','',''),(1561,'1','307','1',1,'Retail Sale Id 1544',1502.20,0.00,0.00,2.03,223.30,'2023-01-31 18:14:42','',''),(1562,'1','307','1',1,'Retail Sale Id 1545',1998.00,0.00,0.00,2.70,297.00,'2023-01-31 18:25:18','',''),(1563,'1','307','1',1,'Retail Sale Id 1545',2997.00,0.00,0.00,4.05,445.50,'2023-01-31 18:25:18','',''),(1564,'1','307','1',1,'Retail Sale Id 1546',1502.20,0.00,0.00,2.03,223.30,'2023-01-31 18:38:48','',''),(1565,'1','307','1',1,'Retail Sale Id 1547',4447.40,0.00,0.00,6.01,661.10,'2023-01-31 18:41:09','',''),(1566,'1','307','1',1,'Retail Sale Id 1548',2220.00,0.00,0.00,3.00,330.00,'2023-01-31 18:47:44','',''),(1567,'1','307','1',1,'Retail Sale Id 1550',4950.60,0.00,0.00,6.69,735.90,'2023-01-31 19:06:57','',''),(1568,'1','307','1',1,'Retail Sale Id 1551',5002.40,0.00,0.00,6.76,743.60,'2023-02-01 07:25:40','',''),(1569,'1','307','1',1,'Retail Sale Id 1552',3700.00,0.00,0.00,5.00,550.00,'2023-02-01 07:27:28','',''),(1570,'1','307','1',1,'Retail Sale Id 1553',1502.20,0.00,0.00,2.03,223.30,'2023-02-01 07:50:34','',''),(1571,'1','307','1',1,'Retail Sale Id 1555',4440.00,0.00,0.00,6.00,660.00,'2023-02-01 07:52:54','',''),(1572,'1','307','1',1,'Retail Sale Id 1556',4003.40,0.00,0.00,5.41,595.10,'2023-02-01 07:53:41','',''),(1573,'1','307','1',1,'Retail Sale Id 1557',1502.20,0.00,0.00,2.03,223.30,'2023-02-01 08:30:01','',''),(1574,'1','307','1',1,'Retail Sale Id 1558',4447.40,0.00,0.00,6.01,661.10,'2023-02-01 09:14:17','',''),(1575,'1','307','1',1,'Retail Sale Id 1559',6001.40,0.00,0.00,8.11,892.10,'2023-02-01 09:16:32','',''),(1576,'1','307','1',1,'Retail Sale Id 1560',8902.20,0.00,0.00,12.03,1323.30,'2023-02-01 09:17:57','',''),(1577,'1','307','1',1,'Retail Sale Id 1561',4447.40,0.00,0.00,6.01,661.10,'2023-02-01 09:18:53','',''),(1578,'1','307','1',1,'Retail Sale Id 1562',35000.00,0.00,0.00,50.00,3500.00,'2023-02-01 09:41:07','',''),(1579,'1','307','1',1,'Retail Sale Id 1563',4447.40,0.00,0.00,6.01,661.10,'2023-02-01 10:25:04','',''),(1580,'1','307','1',1,'Retail Sale Id 1564',1502.20,0.00,0.00,2.03,223.30,'2023-02-01 10:49:58','',''),(1581,'1','307','1',1,'Retail Sale Id 1565',2220.00,0.00,0.00,3.00,330.00,'2023-02-01 10:53:29','',''),(1582,'1','307','1',1,'Retail Sale Id 1566',87500.00,0.00,0.00,125.00,8750.00,'2023-02-01 10:57:06','',''),(1583,'1','307','1',1,'Retail Sale Id 1567',3700.00,0.00,0.00,5.00,550.00,'2023-02-01 11:04:58','',''),(1584,'1','307','1',1,'Retail Sale Id 1568',1502.20,0.00,0.00,2.03,223.30,'2023-02-01 11:05:33','',''),(1585,'1','307','1',1,'Retail Sale Id 1569',9250.00,0.00,0.00,12.50,1375.00,'2023-02-01 12:55:55','',''),(1586,'1','307','1',1,'Retail Sale Id 1570',1480.00,0.00,0.00,2.00,220.00,'2023-02-01 14:55:17','',''),(1587,'1','307','1',1,'Retail Sale Id 1571',2997.00,0.00,0.00,4.05,445.50,'2023-02-01 14:56:41','',''),(1588,'1','307','1',1,'Retail Sale Id 1572',4447.40,0.00,0.00,6.01,661.10,'2023-02-01 15:01:18','',''),(1589,'1','307','1',1,'Retail Sale Id 1573',2220.00,0.00,0.00,3.00,330.00,'2023-02-01 15:13:01','',''),(1590,'1','307','1',1,'Retail Sale Id 1574',1502.20,0.00,0.00,2.03,223.30,'2023-02-01 15:20:55','',''),(1591,'1','307','1',1,'Retail Sale Id 1575',105000.00,0.00,0.00,150.00,10500.00,'2023-02-01 16:15:44','',''),(1592,'1','307','1',1,'Retail Sale Id 1576',4447.40,0.00,0.00,6.01,661.10,'2023-02-01 17:50:52','',''),(1593,'1','307','1',1,'Retail Sale Id 1577',3700.00,0.00,0.00,5.00,550.00,'2023-02-01 17:51:49','',''),(1594,'1','307','1',1,'Retail Sale Id 1578',2220.00,0.00,0.00,3.00,330.00,'2023-02-01 17:52:53','',''),(1595,'1','307','1',1,'Retail Sale Id 1579',747.40,0.00,0.00,1.01,111.10,'2023-02-01 18:00:00','',''),(1596,'1','307','1',1,'Retail Sale Id 1580',35000.00,0.00,0.00,50.00,3500.00,'2023-02-01 18:07:56','',''),(1597,'1','307','1',1,'Retail Sale Id 1581',2249.60,0.00,0.00,3.04,334.40,'2023-02-01 18:14:22','',''),(1598,'1','307','1',1,'Retail Sale Id 1582',4003.40,0.00,0.00,5.41,595.10,'2023-02-01 18:15:27','',''),(1599,'1','307','1',1,'Retail Sale Id 1583',1502.20,0.00,0.00,2.03,223.30,'2023-02-01 18:16:10','',''),(1600,'1','307','1',1,'Retail Sale Id 1584',1502.20,0.00,0.00,2.03,223.30,'2023-02-01 18:24:06','',''),(1601,'1','307','1',1,'Retail Sale Id 1585',9250.00,0.00,0.00,12.50,1375.00,'2023-02-01 18:26:19','',''),(1602,'1','307','1',1,'Retail Sale Id 1586',2249.60,0.00,0.00,3.04,334.40,'2023-02-01 18:31:07','',''),(1603,'1','307','1',1,'Retail Sale Id 1587',4447.40,0.00,0.00,6.01,661.10,'2023-02-01 18:32:11','',''),(1604,'1','307','1',1,'Retail Sale Id 1588',747.40,0.00,0.00,1.01,111.10,'2023-02-01 18:36:01','',''),(1605,'1','307','1',1,'Retail Sale Id 1590',2960.00,0.00,0.00,4.00,440.00,'2023-02-01 18:41:53','',''),(1606,'1','307','1',1,'Retail Sale Id 1591',2997.00,0.00,0.00,4.05,445.50,'2023-02-01 18:46:42','',''),(1607,'1','307','1',1,'Retail Sale Id 1592',35000.00,0.00,0.00,50.00,3500.00,'2023-02-01 18:50:40','',''),(1608,'1','307','1',1,'Retail Sale Id 1593',1502.20,0.00,0.00,2.03,223.30,'2023-02-01 18:51:30','',''),(1609,'1','307','1',1,'Retail Sale Id 1594',24516.20,0.00,0.00,33.13,3644.30,'2023-02-01 19:12:01','',''),(1610,'1','307','1',1,'Retail Sale Id 1595',16361.40,0.00,0.00,22.11,2432.10,'2023-02-01 19:34:35','',''),(1611,'1','307','1',1,'Distributed to Operational lost for sales id:3',27008.10,0.00,0.00,42.87,0.00,'2023-02-02 07:36:13','',''),(1612,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,1260000.00,2000.00,0.00,0.00,'2023-02-02 07:41:16','',''),(1613,'1','307',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,2000.00,0.00,'2023-02-02 07:43:35','',''),(1614,'1','307','1',1,'Received from bridging 6',0.00,0.00,2000.00,0.00,0.00,'2023-02-02 07:43:35','',''),(1615,'1','307','1',1,'Retail Sale Id 1608',7400.00,0.00,0.00,10.00,1100.00,'2023-02-02 13:46:13','',''),(1616,'1','307','1',1,'Retail Sale Id 1609',75132.20,0.00,0.00,101.53,11168.30,'2023-02-02 14:32:10','',''),(1617,'1','307','1',1,'Retail Sale Id 1610',70000.00,0.00,0.00,100.00,7000.00,'2023-02-02 14:34:32','',''),(1618,'1','307','1',1,'Retail Sale Id 1611',51002.00,0.00,0.00,72.86,5100.20,'2023-02-02 14:36:24','',''),(1619,'1','307','1',1,'Retail Sale Id 1612',4447.40,0.00,0.00,6.01,661.10,'2023-02-02 14:51:57','',''),(1620,'1','307','1',1,'Retail Sale Id 1613',3700.00,0.00,0.00,5.00,550.00,'2023-02-02 15:19:49','',''),(1621,'1','307','1',1,'Retail Sale Id 1614',2220.00,0.00,0.00,3.00,330.00,'2023-02-02 15:29:55','',''),(1622,'1','307','1',1,'Retail Sale Id 1615',3700.00,0.00,0.00,5.00,550.00,'2023-02-02 15:30:35','',''),(1623,'1','307','1',1,'Retail Sale Id 1616',9250.00,0.00,0.00,12.50,1375.00,'2023-02-02 16:00:58','',''),(1624,'1','307','1',1,'Retail Sale Id 1617',7400.00,0.00,0.00,10.00,1100.00,'2023-02-02 16:03:06','',''),(1625,'1','307','1',1,'Retail Sale Id 1618',799.20,0.00,0.00,1.08,118.80,'2023-02-02 16:21:31','',''),(1626,'1','307','1',1,'Retail Sale Id 1619',1502.20,0.00,0.00,2.03,223.30,'2023-02-02 16:43:39','',''),(1627,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,2123100.00,3370.00,0.00,0.00,'2023-02-02 16:49:31','',''),(1628,'1','307',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,3370.00,0.00,'2023-02-02 16:51:10','',''),(1629,'1','307','1',1,'Received from bridging 7',0.00,0.00,3370.00,0.00,0.00,'2023-02-02 16:51:10','',''),(1630,'1','307','1',1,'Retail Sale Id 1620',3700.00,0.00,0.00,5.00,550.00,'2023-02-02 16:55:32','',''),(1631,'1','307','1',1,'Retail Sale Id 1621',1998.00,0.00,0.00,2.70,297.00,'2023-02-02 17:07:08','',''),(1632,'1','307','1',1,'Retail Sale Id 1622',4447.40,0.00,0.00,6.01,661.10,'2023-02-02 17:21:41','',''),(1633,'1','307','1',1,'Retail Sale Id 1623',1998.00,0.00,0.00,2.70,297.00,'2023-02-02 17:23:31','',''),(1634,'1','307','1',1,'Retail Sale Id 1624',1502.20,0.00,0.00,2.03,223.30,'2023-02-02 17:50:07','',''),(1635,'1','307','1',1,'Retail Sale Id 1625',4447.40,0.00,0.00,6.01,661.10,'2023-02-02 18:02:20','',''),(1636,'1','307','1',1,'Retail Sale Id 1627',2249.60,0.00,0.00,3.04,334.40,'2023-02-02 18:22:26','',''),(1637,'1','307','1',1,'Retail Sale Id 1628',2997.00,0.00,0.00,4.05,445.50,'2023-02-02 18:37:17','',''),(1638,'1','307','1',1,'Retail Sale Id 1629',747.40,0.00,0.00,1.01,111.10,'2023-02-02 18:39:38','',''),(1639,'1','307','1',1,'Retail Sale Id 1630',5002.40,0.00,0.00,6.76,743.60,'2023-02-02 18:41:11','',''),(1640,'1','307','1',1,'Retail Sale Id 1631',6660.00,0.00,0.00,9.00,990.00,'2023-02-02 19:09:45','',''),(1641,'1','307','1',1,'Retail Sale Id 1632',3700.00,0.00,0.00,5.00,550.00,'2023-02-02 19:26:40','',''),(1642,'1','307','1',1,'Retail Sale Id 1633',4447.40,0.00,0.00,6.01,661.10,'2023-02-03 07:41:00','',''),(1643,'1','307','1',1,'Retail Sale Id 1634',1502.20,0.00,0.00,2.03,223.30,'2023-02-03 07:47:20','',''),(1644,'1','307','1',1,'Retail Sale Id 1635',4003.40,0.00,0.00,5.41,595.10,'2023-02-03 08:19:28','',''),(1645,'1','307','1',1,'Retail Sale Id 1636',9250.00,0.00,0.00,12.50,1375.00,'2023-02-03 08:44:29','',''),(1646,'1','307','1',1,'Retail Sale Id 1637',4003.40,0.00,0.00,5.41,595.10,'2023-02-03 09:07:18','',''),(1647,'1','307','1',1,'Retail Sale Id 1638',747.40,0.00,0.00,1.01,111.10,'2023-02-03 09:26:32','',''),(1648,'1','307','1',1,'Retail Sale Id 1639',2249.60,0.00,0.00,3.04,334.40,'2023-02-03 09:35:18','',''),(1649,'1','307','1',1,'Retail Sale Id 1640',4447.40,0.00,0.00,6.01,661.10,'2023-02-03 09:48:47','',''),(1650,'1','307','1',1,'Retail Sale Id 1641',9250.00,0.00,0.00,12.50,1375.00,'2023-02-03 09:55:06','',''),(1651,'1','307','1',1,'Retail Sale Id 1642',1502.20,0.00,0.00,2.03,223.30,'2023-02-03 10:30:01','',''),(1652,'1','307','1',1,'Retail Sale Id 1643',3700.00,0.00,0.00,5.00,550.00,'2023-02-03 11:00:40','',''),(1653,'1','307','1',1,'Retail Sale Id 1644',3700.00,0.00,0.00,5.00,550.00,'2023-02-03 11:05:22','',''),(1654,'1','307','1',1,'Retail Sale Id 1645',4447.40,0.00,0.00,6.01,661.10,'2023-02-03 11:16:30','',''),(1655,'1','307','1',1,'Retail Sale Id 1646',140000.00,0.00,0.00,200.00,14000.00,'2023-02-03 11:18:14','',''),(1656,'1','307','1',1,'Retail Sale Id 1647',70000.00,0.00,0.00,100.00,7000.00,'2023-02-03 11:27:34','',''),(1657,'1','307','1',1,'Retail Sale Id 1648',2220.00,0.00,0.00,3.00,330.00,'2023-02-03 11:29:20','',''),(1658,'1','307','1',1,'Retail Sale Id 1649',2249.60,0.00,0.00,3.04,334.40,'2023-02-03 12:04:58','',''),(1659,'1','307','1',1,'Retail Sale Id 1650',4003.40,0.00,0.00,5.41,595.10,'2023-02-03 12:12:02','',''),(1660,'1','307','1',1,'Retail Sale Id 1651',999.00,0.00,0.00,1.35,148.50,'2023-02-03 12:13:15','',''),(1661,'1','307','1',1,'Retail Sale Id 1652',9250.00,0.00,0.00,12.50,1375.00,'2023-02-03 12:40:18','',''),(1662,'1','307','1',1,'Retail Sale Id 1653',35000.00,0.00,0.00,50.00,3500.00,'2023-02-03 12:43:20','',''),(1663,'1','307','1',1,'Retail Sale Id 1654',1998.00,0.00,0.00,2.70,297.00,'2023-02-03 12:53:44','',''),(1664,'1','307','1',1,'Retail Sale Id 1655',2249.60,0.00,0.00,3.04,334.40,'2023-02-03 13:02:58','',''),(1665,'1','307','1',1,'Retail Sale Id 1656',747.40,0.00,0.00,1.01,111.10,'2023-02-03 13:04:49','',''),(1666,'1','307','1',1,'Retail Sale Id 1657',1502.20,0.00,0.00,2.03,223.30,'2023-02-03 13:08:25','',''),(1667,'1','307','1',1,'Retail Sale Id 1658',747.40,0.00,0.00,1.01,111.10,'2023-02-03 14:02:52','',''),(1668,'1','307','1',1,'Retail Sale Id 1659',999.00,0.00,0.00,1.35,148.50,'2023-02-03 14:11:57','',''),(1669,'1','307','1',1,'Retail Sale Id 1660',747.40,0.00,0.00,1.01,111.10,'2023-02-03 14:35:05','',''),(1670,'1','307','1',1,'Retail Sale Id 1662',7400.00,0.00,0.00,10.00,1100.00,'2023-02-03 14:54:41','',''),(1671,'1','307','1',1,'Retail Sale Id 1663',9250.00,0.00,0.00,12.50,1375.00,'2023-02-03 15:22:49','',''),(1672,'1','307','1',1,'Retail Sale Id 1664',7400.00,0.00,0.00,10.00,1100.00,'2023-02-03 15:35:57','',''),(1673,'1','307','1',1,'Retail Sale Id 1665',1502.20,0.00,0.00,2.03,223.30,'2023-02-03 15:56:16','',''),(1674,'1','307','1',1,'Retail Sale Id 1666',1998.00,0.00,0.00,2.70,297.00,'2023-02-03 16:01:47','',''),(1675,'1','307','1',1,'Retail Sale Id 1667',4447.40,0.00,0.00,6.01,661.10,'2023-02-03 16:21:02','',''),(1676,'1','307','1',1,'Retail Sale Id 1668',87500.00,0.00,0.00,125.00,8750.00,'2023-02-03 16:44:26','',''),(1677,'1','307','1',1,'Retail Sale Id 1669',1798.20,0.00,0.00,2.43,267.30,'2023-02-03 16:54:52','',''),(1678,'1','307','1',1,'Retail Sale Id 1670',1502.20,0.00,0.00,2.03,223.30,'2023-02-03 17:06:29','',''),(1679,'1','307','1',1,'Retail Sale Id 1670',9250.00,0.00,0.00,12.50,1375.00,'2023-02-03 17:06:29','',''),(1680,'1','307','1',1,'Retail Sale Id 1671',9250.00,0.00,0.00,12.50,1375.00,'2023-02-03 17:13:41','',''),(1681,'1','307','1',1,'Retail Sale Id 1672',14800.00,0.00,0.00,20.00,2200.00,'2023-02-03 17:40:35','',''),(1682,'1','307','1',1,'Retail Sale Id 1674',4447.40,0.00,0.00,6.01,661.10,'2023-02-03 17:46:48','',''),(1683,'1','307','1',1,'Retail Sale Id 1675',2220.00,0.00,0.00,3.00,330.00,'2023-02-03 17:58:31','',''),(1684,'1','307','1',1,'Retail Sale Id 1675',2960.00,0.00,0.00,4.00,440.00,'2023-02-03 17:58:31','',''),(1685,'1','307','1',1,'Retail Sale Id 1677',1502.20,0.00,0.00,2.03,223.30,'2023-02-03 18:00:24','',''),(1686,'1','307','1',1,'Retail Sale Id 1679',1198.80,0.00,0.00,1.62,178.20,'2023-02-03 18:10:03','',''),(1687,'1','307','1',1,'Retail Sale Id 1680',3700.00,0.00,0.00,5.00,550.00,'2023-02-03 18:13:36','',''),(1688,'1','307','1',1,'Retail Sale Id 1683',747.40,0.00,0.00,1.01,111.10,'2023-02-03 18:42:02','',''),(1689,'1','307','1',1,'Retail Sale Id 1684',1998.00,0.00,0.00,2.70,297.00,'2023-02-04 08:08:39','',''),(1690,'1','307','1',1,'Retail Sale Id 1684',1998.00,0.00,0.00,2.70,297.00,'2023-02-04 08:08:39','',''),(1691,'1','307','1',1,'Retail Sale Id 1685',2701.00,0.00,0.00,3.65,401.50,'2023-02-04 08:10:53','',''),(1692,'1','307','1',1,'Retail Sale Id 1686',3700.00,0.00,0.00,5.00,550.00,'2023-02-04 08:25:51','',''),(1693,'1','307','1',1,'Retail Sale Id 1687',1502.20,0.00,0.00,2.03,223.30,'2023-02-04 08:27:01','',''),(1694,'1','307','1',1,'Retail Sale Id 1688',1198.80,0.00,0.00,1.62,178.20,'2023-02-04 08:43:32','',''),(1695,'1','307','1',1,'Retail Sale Id 1689',1502.20,0.00,0.00,2.03,223.30,'2023-02-04 08:49:01','',''),(1696,'1','307','1',1,'Retail Sale Id 1690',35000.00,0.00,0.00,50.00,3500.00,'2023-02-04 09:16:23','',''),(1697,'1','307','1',1,'Retail Sale Id 1691',2997.00,0.00,0.00,4.05,445.50,'2023-02-04 09:46:22','',''),(1698,'1','307','1',1,'Retail Sale Id 1691',4447.40,0.00,0.00,6.01,661.10,'2023-02-04 09:46:22','',''),(1699,'1','307','1',1,'Retail Sale Id 1691',4447.40,0.00,0.00,6.01,661.10,'2023-02-04 09:46:22','',''),(1700,'1','307','1',1,'Retail Sale Id 1692',9250.00,0.00,0.00,12.50,1375.00,'2023-02-04 10:10:45','',''),(1701,'1','307','1',1,'Retail Sale Id 1693',2997.00,0.00,0.00,4.05,445.50,'2023-02-04 10:20:10','',''),(1702,'1','307','1',1,'Retail Sale Id 1694',9250.00,0.00,0.00,12.50,1375.00,'2023-02-04 10:53:59','',''),(1703,'1','307','1',1,'Retail Sale Id 1695',1502.20,0.00,0.00,2.03,223.30,'2023-02-04 11:05:01','',''),(1704,'1','307','1',1,'Retail Sale Id 1696',4447.40,0.00,0.00,6.01,661.10,'2023-02-04 11:15:11','',''),(1705,'1','307','1',1,'Retail Sale Id 1697',1502.20,0.00,0.00,2.03,223.30,'2023-02-04 12:06:39','',''),(1706,'1','307','1',1,'Retail Sale Id 1698',3700.00,0.00,0.00,5.00,550.00,'2023-02-04 12:16:10','',''),(1707,'1','307','1',1,'Retail Sale Id 1699',2997.00,0.00,0.00,4.05,445.50,'2023-02-04 12:18:12','',''),(1708,'1','307','1',1,'Retail Sale Id 1700',4440.00,0.00,0.00,6.00,660.00,'2023-02-04 12:25:20','',''),(1709,'1','307','1',1,'Retail Sale Id 1701',1198.80,0.00,0.00,1.62,178.20,'2023-02-04 12:48:44','',''),(1710,'1','307','1',1,'Retail Sale Id 1702',5202.20,0.00,0.00,7.03,773.30,'2023-02-04 12:56:45','',''),(1711,'1','307','1',1,'Retail Sale Id 1703',9250.00,0.00,0.00,12.50,1375.00,'2023-02-04 13:04:28','',''),(1712,'1','307','1',1,'Retail Sale Id 1704',1502.20,0.00,0.00,2.03,223.30,'2023-02-04 13:09:41','',''),(1713,'1','307','1',1,'Retail Sale Id 1705',4447.40,0.00,0.00,6.01,661.10,'2023-02-04 13:28:51','',''),(1714,'1','307','1',1,'Retail Sale Id 1706',4447.40,0.00,0.00,6.01,661.10,'2023-02-04 13:30:23','',''),(1715,'1','307','1',1,'Retail Sale Id 1707',35000.00,0.00,0.00,50.00,3500.00,'2023-02-04 13:35:07','',''),(1716,'1','307','1',1,'Retail Sale Id 1708',2249.60,0.00,0.00,3.04,334.40,'2023-02-04 13:45:51','',''),(1717,'1','307','1',1,'Retail Sale Id 1709',1502.20,0.00,0.00,2.03,223.30,'2023-02-04 13:49:43','',''),(1718,'1','307','1',1,'Retail Sale Id 1710',799.20,0.00,0.00,1.08,118.80,'2023-02-04 13:58:02','',''),(1719,'1','307','1',1,'Retail Sale Id 1711',747.40,0.00,0.00,1.01,111.10,'2023-02-04 15:08:14','',''),(1720,'1','307','1',1,'Retail Sale Id 1712',35000.00,0.00,0.00,50.00,3500.00,'2023-02-04 15:41:39','',''),(1721,'1','307','1',1,'Retail Sale Id 1713',4447.40,0.00,0.00,6.01,661.10,'2023-02-04 16:01:42','',''),(1722,'1','307','1',1,'Retail Sale Id 1714',4447.40,0.00,0.00,6.01,661.10,'2023-02-04 16:18:35','',''),(1723,'1','307','1',1,'Retail Sale Id 1715',4447.40,0.00,0.00,6.01,661.10,'2023-02-04 16:40:10','',''),(1724,'1','307','1',1,'Retail Sale Id 1716',4447.40,0.00,0.00,6.01,661.10,'2023-02-04 16:42:36','',''),(1725,'1','307','1',1,'Retail Sale Id 1717',1502.20,0.00,0.00,2.03,223.30,'2023-02-04 16:43:38','',''),(1726,'1','307','1',1,'Retail Sale Id 1718',2997.00,0.00,0.00,4.05,445.50,'2023-02-04 16:49:41','',''),(1727,'1','307','1',1,'Retail Sale Id 1719',1502.20,0.00,0.00,2.03,223.30,'2023-02-04 16:53:38','',''),(1728,'1','307','1',1,'Retail Sale Id 1720',999.00,0.00,0.00,1.35,148.50,'2023-02-04 17:04:39','',''),(1729,'1','307','1',1,'Retail Sale Id 1721',2249.60,0.00,0.00,3.04,334.40,'2023-02-04 17:06:46','',''),(1730,'1','307','1',1,'Retail Sale Id 1722',2249.60,0.00,0.00,3.04,334.40,'2023-02-04 17:08:12','',''),(1731,'1','307','1',1,'Retail Sale Id 1723',4447.40,0.00,0.00,6.01,661.10,'2023-02-04 17:09:37','',''),(1732,'1','307','1',1,'Retail Sale Id 1724',4447.40,0.00,0.00,6.01,661.10,'2023-02-04 17:10:50','',''),(1733,'1','307','1',1,'Retail Sale Id 1725',1502.20,0.00,0.00,2.03,223.30,'2023-02-04 17:37:42','',''),(1734,'1','307','1',1,'Retail Sale Id 1726',4003.40,0.00,0.00,5.41,595.10,'2023-02-04 17:45:59','',''),(1735,'1','307','1',1,'Retail Sale Id 1727',5202.20,0.00,0.00,7.03,773.30,'2023-02-04 17:53:24','',''),(1736,'1','307','1',1,'Retail Sale Id 1728',2249.60,0.00,0.00,3.04,334.40,'2023-02-04 18:05:47','',''),(1737,'1','307','1',1,'Retail Sale Id 1729',2249.60,0.00,0.00,3.04,334.40,'2023-02-04 18:07:42','',''),(1738,'1','307','1',1,'Retail Sale Id 1730',2249.60,0.00,0.00,3.04,334.40,'2023-02-04 18:12:44','',''),(1739,'1','307','1',1,'Retail Sale Id 1731',9250.00,0.00,0.00,12.50,1375.00,'2023-02-04 18:17:59','',''),(1740,'1','307','1',1,'Retail Sale Id 1732',3700.00,0.00,0.00,5.00,550.00,'2023-02-04 18:19:25','',''),(1741,'1','307','1',1,'Retail Sale Id 1733',4447.40,0.00,0.00,6.01,661.10,'2023-02-04 18:22:55','',''),(1742,'1','307','1',1,'Retail Sale Id 1734',3300.40,0.00,0.00,4.46,490.60,'2023-02-04 18:24:20','',''),(1743,'1','307','1',1,'Retail Sale Id 1735',4447.40,0.00,0.00,6.01,661.10,'2023-02-04 18:28:42','',''),(1744,'1','307','1',1,'Retail Sale Id 1736',1998.00,0.00,0.00,2.70,297.00,'2023-02-04 18:52:35','',''),(1745,'1','307','1',1,'Retail Sale Id 1737',2249.60,0.00,0.00,3.04,334.40,'2023-02-04 19:10:29','',''),(1746,'1','307','1',1,'Retail Sale Id 1738',4447.40,0.00,0.00,6.01,661.10,'2023-02-04 19:16:46','',''),(1747,'1','307','1',1,'Retail Sale Id 1738',6001.40,0.00,0.00,8.11,892.10,'2023-02-04 19:16:46','',''),(1748,'1','307','1',1,'Retail Sale Id 1739',4417.80,0.00,0.00,5.97,656.70,'2023-02-04 19:26:15','',''),(1749,'1','307','1',1,'Retail Sale Id 1740',4447.40,0.00,0.00,6.01,661.10,'2023-02-05 07:41:42','',''),(1750,'1','307','1',1,'Retail Sale Id 1741',9250.00,0.00,0.00,12.50,1375.00,'2023-02-05 07:53:53','',''),(1751,'1','307','1',1,'Retail Sale Id 1742',9250.00,0.00,0.00,12.50,1375.00,'2023-02-05 08:54:37','',''),(1752,'1','307','1',1,'Retail Sale Id 1743',2220.00,0.00,0.00,3.00,330.00,'2023-02-05 09:10:51','',''),(1753,'1','307','1',1,'Retail Sale Id 1745',2249.60,0.00,0.00,3.04,334.40,'2023-02-05 09:17:29','',''),(1754,'1','307','1',1,'Retail Sale Id 1746',4440.00,0.00,0.00,6.00,660.00,'2023-02-05 09:20:11','',''),(1755,'1','307','1',1,'Retail Sale Id 1747',3700.00,0.00,0.00,5.00,550.00,'2023-02-05 09:26:47','',''),(1756,'1','307','1',1,'Retail Sale Id 1748',5002.40,0.00,0.00,6.76,743.60,'2023-02-05 09:34:46','',''),(1757,'1','307','1',1,'Retail Sale Id 1749',2501.20,0.00,0.00,3.38,371.80,'2023-02-05 09:49:44','',''),(1758,'1','307','1',1,'Retail Sale Id 1750',7400.00,0.00,0.00,10.00,1100.00,'2023-02-05 09:51:03','',''),(1759,'1','307','1',1,'Retail Sale Id 1751',9250.00,0.00,0.00,12.50,1375.00,'2023-02-05 10:07:03','',''),(1760,'1','307','1',1,'Retail Sale Id 1752',70000.00,0.00,0.00,100.00,7000.00,'2023-02-05 10:10:40','',''),(1761,'1','307','1',1,'Retail Sale Id 1753',4447.40,0.00,0.00,6.01,661.10,'2023-02-05 10:15:06','',''),(1762,'1','307','1',1,'Retail Sale Id 1754',2197.80,0.00,0.00,2.97,326.70,'2023-02-05 10:50:19','',''),(1763,'1','307','1',1,'Retail Sale Id 1756',2249.60,0.00,0.00,3.04,334.40,'2023-02-05 10:52:47','',''),(1764,'1','307','1',1,'Retail Sale Id 1757',2249.60,0.00,0.00,3.04,334.40,'2023-02-05 11:03:04','',''),(1765,'1','307','1',1,'Retail Sale Id 1759',1998.00,0.00,0.00,2.70,297.00,'2023-02-05 11:06:15','',''),(1766,'1','307','1',1,'Retail Sale Id 1760',4440.00,0.00,0.00,6.00,660.00,'2023-02-05 11:13:57','',''),(1767,'1','307','1',1,'Retail Sale Id 1761',4440.00,0.00,0.00,6.00,660.00,'2023-02-05 11:23:40','',''),(1768,'1','307','1',1,'Retail Sale Id 1762',5202.20,0.00,0.00,7.03,773.30,'2023-02-05 11:30:15','',''),(1769,'1','307','1',1,'Retail Sale Id 1763',9250.00,0.00,0.00,12.50,1375.00,'2023-02-05 12:01:59','',''),(1770,'1','307','1',1,'Retail Sale Id 1764',9250.00,0.00,0.00,12.50,1375.00,'2023-02-05 12:11:55','',''),(1771,'1','307','1',1,'Retail Sale Id 1765',6001.40,0.00,0.00,8.11,892.10,'2023-02-05 12:14:36','',''),(1772,'1','307','1',1,'Retail Sale Id 1766',2220.00,0.00,0.00,3.00,330.00,'2023-02-05 12:21:20','',''),(1773,'1','307','1',1,'Retail Sale Id 1767',740.00,0.00,0.00,1.00,110.00,'2023-02-05 12:25:37','',''),(1774,'1','307','1',1,'Retail Sale Id 1768',3700.00,0.00,0.00,5.00,550.00,'2023-02-05 12:28:23','',''),(1775,'1','307','1',1,'Retail Sale Id 1769',2249.60,0.00,0.00,3.04,334.40,'2023-02-05 12:34:54','',''),(1776,'1','307','1',1,'Retail Sale Id 1770',799.20,0.00,0.00,1.08,118.80,'2023-02-05 12:35:58','',''),(1777,'1','307','1',1,'Retail Sale Id 1771',1998.00,0.00,0.00,2.70,297.00,'2023-02-05 12:54:17','',''),(1778,'1','307','1',1,'Retail Sale Id 1772',2249.60,0.00,0.00,3.04,334.40,'2023-02-05 12:55:57','',''),(1779,'1','307','1',1,'Retail Sale Id 1773',3700.00,0.00,0.00,5.00,550.00,'2023-02-05 13:07:41','',''),(1780,'1','307','1',1,'Retail Sale Id 1774',2249.60,0.00,0.00,3.04,334.40,'2023-02-05 13:25:07','',''),(1781,'1','307','1',1,'Retail Sale Id 1775',2249.60,0.00,0.00,3.04,334.40,'2023-02-05 13:26:18','',''),(1782,'1','307','1',1,'Retail Sale Id 1776',2997.00,0.00,0.00,4.05,445.50,'2023-02-05 13:28:05','',''),(1783,'1','307','1',1,'Retail Sale Id 1777',4447.40,0.00,0.00,6.01,661.10,'2023-02-05 13:29:50','',''),(1784,'1','307','1',1,'Retail Sale Id 1778',2249.60,0.00,0.00,3.04,334.40,'2023-02-05 13:34:16','',''),(1785,'1','307','1',1,'Retail Sale Id 1779',2220.00,0.00,0.00,3.00,330.00,'2023-02-05 13:35:53','',''),(1786,'1','307','1',1,'Retail Sale Id 1780',2960.00,0.00,0.00,4.00,440.00,'2023-02-05 13:37:57','',''),(1787,'1','307','1',1,'Retail Sale Id 1781',5920.00,0.00,0.00,8.00,880.00,'2023-02-05 13:50:47','',''),(1788,'1','307','1',1,'Retail Sale Id 1782',2960.00,0.00,0.00,4.00,440.00,'2023-02-05 13:51:53','',''),(1789,'1','307','1',1,'Retail Sale Id 1783',1502.20,0.00,0.00,2.03,223.30,'2023-02-05 14:06:42','',''),(1790,'1','307','1',1,'Retail Sale Id 1784',2997.00,0.00,0.00,4.05,445.50,'2023-02-05 14:08:02','',''),(1791,'1','307','1',1,'Retail Sale Id 1785',1502.20,0.00,0.00,2.03,223.30,'2023-02-05 14:10:01','',''),(1792,'1','307','1',1,'Retail Sale Id 1786',2249.60,0.00,0.00,3.04,334.40,'2023-02-05 14:34:15','',''),(1793,'1','307','1',1,'Retail Sale Id 1787',3700.00,0.00,0.00,5.00,550.00,'2023-02-05 14:47:53','',''),(1794,'1','307','1',1,'Retail Sale Id 1788',3700.00,0.00,0.00,5.00,550.00,'2023-02-05 14:49:11','',''),(1795,'1','307','1',1,'Retail Sale Id 1789',2997.00,0.00,0.00,4.05,445.50,'2023-02-05 14:56:09','',''),(1796,'1','307','1',1,'Retail Sale Id 1790',1502.20,0.00,0.00,2.03,223.30,'2023-02-05 15:08:38','',''),(1797,'1','307','1',1,'Retail Sale Id 1791',740.00,0.00,0.00,1.00,110.00,'2023-02-05 15:23:05','',''),(1798,'1','307','1',1,'Retail Sale Id 1792',4440.00,0.00,0.00,6.00,660.00,'2023-02-05 15:24:32','',''),(1799,'1','307','1',1,'Retail Sale Id 1793',7400.00,0.00,0.00,10.00,1100.00,'2023-02-05 15:29:46','',''),(1800,'1','307','1',1,'Retail Sale Id 1794',1480.00,0.00,0.00,2.00,220.00,'2023-02-05 15:35:23','',''),(1801,'1','307','1',1,'Retail Sale Id 1795',3700.00,0.00,0.00,5.00,550.00,'2023-02-05 15:43:23','',''),(1802,'1','307','1',1,'Retail Sale Id 1796',4440.00,0.00,0.00,6.00,660.00,'2023-02-05 15:55:36','',''),(1803,'1','307','1',1,'Retail Sale Id 1797',1480.00,0.00,0.00,2.00,220.00,'2023-02-05 16:16:28','',''),(1804,'1','307','1',1,'Retail Sale Id 1798',2249.60,0.00,0.00,3.04,334.40,'2023-02-05 16:31:49','',''),(1805,'1','307','1',1,'Retail Sale Id 1799',1998.00,0.00,0.00,2.70,297.00,'2023-02-05 16:32:49','',''),(1806,'1','307','1',1,'Retail Sale Id 1800',3700.00,0.00,0.00,5.00,550.00,'2023-02-05 16:40:30','',''),(1807,'1','307','1',1,'Retail Sale Id 1801',4440.00,0.00,0.00,6.00,660.00,'2023-02-05 16:55:58','',''),(1808,'1','307','1',1,'Retail Sale Id 1802',87500.00,0.00,0.00,125.00,8750.00,'2023-02-05 17:01:07','',''),(1809,'1','307','1',1,'Retail Sale Id 1803',1502.20,0.00,0.00,2.03,223.30,'2023-02-05 17:03:36','',''),(1810,'1','307','1',1,'Retail Sale Id 1804',2220.00,0.00,0.00,3.00,330.00,'2023-02-05 17:09:32','',''),(1811,'1','307','1',1,'Retail Sale Id 1805',2220.00,0.00,0.00,3.00,330.00,'2023-02-05 17:13:20','',''),(1812,'1','307','1',1,'Retail Sale Id 1806',1502.20,0.00,0.00,2.03,223.30,'2023-02-05 17:24:19','',''),(1813,'1','307','1',1,'Retail Sale Id 1807',799.20,0.00,0.00,1.08,118.80,'2023-02-05 17:30:59','',''),(1814,'1','307','1',1,'Retail Sale Id 1808',2220.00,0.00,0.00,3.00,330.00,'2023-02-05 17:48:10','',''),(1815,'1','307','1',1,'Retail Sale Id 1809',2249.60,0.00,0.00,3.04,334.40,'2023-02-05 17:50:05','',''),(1816,'1','307','1',1,'Retail Sale Id 1810',747.40,0.00,0.00,1.01,111.10,'2023-02-05 17:53:32','',''),(1817,'1','307','1',1,'Retail Sale Id 1811',7400.00,0.00,0.00,10.00,1100.00,'2023-02-05 17:59:36','',''),(1818,'1','307','1',1,'Retail Sale Id 1812',2960.00,0.00,0.00,4.00,440.00,'2023-02-05 18:00:32','',''),(1819,'1','307','1',1,'Retail Sale Id 1813',2249.60,0.00,0.00,3.04,334.40,'2023-02-05 18:06:13','',''),(1820,'1','307','1',1,'Retail Sale Id 1814',5002.40,0.00,0.00,6.76,743.60,'2023-02-05 18:10:13','',''),(1821,'1','307','1',1,'Retail Sale Id 1815',4447.40,0.00,0.00,6.01,661.10,'2023-02-05 18:20:24','',''),(1822,'1','307','1',1,'Retail Sale Id 1816',3700.00,0.00,0.00,5.00,550.00,'2023-02-05 18:28:44','',''),(1823,'1','307','1',1,'Retail Sale Id 1817',2249.60,0.00,0.00,3.04,334.40,'2023-02-05 18:30:25','',''),(1824,'1','307','1',1,'Retail Sale Id 1818',5180.00,0.00,0.00,7.00,770.00,'2023-02-05 18:33:14','',''),(1825,'1','307','1',1,'Retail Sale Id 1819',2997.00,0.00,0.00,4.05,445.50,'2023-02-05 18:34:41','',''),(1826,'1','307','1',1,'Retail Sale Id 1820',4499.20,0.00,0.00,6.08,668.80,'2023-02-05 18:37:23','',''),(1827,'1','307','1',1,'Retail Sale Id 1821',2220.00,0.00,0.00,3.00,330.00,'2023-02-05 18:38:49','',''),(1828,'1','307','1',1,'Retail Sale Id 1822',5949.60,0.00,0.00,8.04,884.40,'2023-02-05 18:44:47','',''),(1829,'1','307','1',1,'Retail Sale Id 1823',3700.00,0.00,0.00,5.00,550.00,'2023-02-06 07:25:00','',''),(1830,'1','307','1',1,'Retail Sale Id 1823',3700.00,0.00,0.00,5.00,550.00,'2023-02-06 07:25:00','',''),(1831,'1','307','1',1,'Retail Sale Id 1824',9250.00,0.00,0.00,12.50,1375.00,'2023-02-06 07:28:59','',''),(1832,'1','307','1',1,'Retail Sale Id 1825',5002.40,0.00,0.00,6.76,743.60,'2023-02-06 07:57:23','',''),(1833,'1','307','1',1,'Retail Sale Id 1826',4440.00,0.00,0.00,6.00,660.00,'2023-02-06 08:05:31','',''),(1834,'1','307','1',1,'Retail Sale Id 1827',2249.60,0.00,0.00,3.04,334.40,'2023-02-06 08:11:10','',''),(1835,'1','307','1',1,'Retail Sale Id 1828',999.00,0.00,0.00,1.35,148.50,'2023-02-06 08:21:23','',''),(1836,'1','307','1',1,'Retail Sale Id 1829',9250.00,0.00,0.00,12.50,1375.00,'2023-02-06 08:35:37','',''),(1837,'1','307','1',1,'Retail Sale Id 1830',9250.00,0.00,0.00,12.50,1375.00,'2023-02-06 08:57:16','',''),(1838,'1','307','1',1,'Retail Sale Id 1831',2220.00,0.00,0.00,3.00,330.00,'2023-02-06 09:05:23','',''),(1839,'1','307','1',1,'Retail Sale Id 1832',2220.00,0.00,0.00,3.00,330.00,'2023-02-06 09:13:10','',''),(1840,'1','307','1',1,'Retail Sale Id 1832',9250.00,0.00,0.00,12.50,1375.00,'2023-02-06 09:13:10','',''),(1841,'1','307','1',1,'Retail Sale Id 1833',3700.00,0.00,0.00,5.00,550.00,'2023-02-06 09:26:53','',''),(1842,'1','307','1',1,'Retail Sale Id 1834',2197.80,0.00,0.00,2.97,326.70,'2023-02-06 09:34:53','',''),(1843,'1','307','1',1,'Retail Sale Id 1835',140000.00,0.00,0.00,200.00,14000.00,'2023-02-06 09:36:40','',''),(1844,'1','307','1',1,'Retail Sale Id 1836',9250.00,0.00,0.00,12.50,1375.00,'2023-02-06 10:11:02','',''),(1845,'1','307','1',1,'Retail Sale Id 1837',4440.00,0.00,0.00,6.00,660.00,'2023-02-06 10:12:06','',''),(1846,'1','307','1',1,'Retail Sale Id 1838',2960.00,0.00,0.00,4.00,440.00,'2023-02-06 10:13:39','',''),(1847,'1','307','1',1,'Retail Sale Id 1839',740.00,0.00,0.00,1.00,110.00,'2023-02-06 10:14:37','',''),(1848,'1','307','1',1,'Retail Sale Id 1840',2997.00,0.00,0.00,4.05,445.50,'2023-02-06 10:56:17','',''),(1849,'1','307','1',1,'Retail Sale Id 1841',1502.20,0.00,0.00,2.03,223.30,'2023-02-06 10:57:23','',''),(1850,'1','307','1',1,'Retail Sale Id 1842',3700.00,0.00,0.00,5.00,550.00,'2023-02-06 11:15:11','',''),(1851,'1','307','1',1,'Retail Sale Id 1843',740.00,0.00,0.00,1.00,110.00,'2023-02-06 11:44:56','',''),(1852,'1','307','1',1,'Retail Sale Id 1844',2597.40,0.00,0.00,3.51,386.10,'2023-02-06 11:47:39','',''),(1853,'1','307','1',1,'Retail Sale Id 1845',4440.00,0.00,0.00,6.00,660.00,'2023-02-06 12:00:15','',''),(1854,'1','307','1',1,'Retail Sale Id 1846',5002.40,0.00,0.00,6.76,743.60,'2023-02-06 12:08:36','',''),(1855,'1','307','1',1,'Retail Sale Id 1847',9250.00,0.00,0.00,12.50,1375.00,'2023-02-06 12:32:20','',''),(1856,'1','307','1',1,'Retail Sale Id 1847',9250.00,0.00,0.00,12.50,1375.00,'2023-02-06 12:32:20','',''),(1857,'1','307','1',1,'Retail Sale Id 1848',1480.00,0.00,0.00,2.00,220.00,'2023-02-06 13:06:36','',''),(1858,'1','307','1',1,'Retail Sale Id 1849',9250.00,0.00,0.00,12.50,1375.00,'2023-02-06 13:44:31','',''),(1859,'1','307','1',1,'Retail Sale Id 1850',1480.00,0.00,0.00,2.00,220.00,'2023-02-06 14:21:41','',''),(1860,'1','307','1',1,'Retail Sale Id 1851',9250.00,0.00,0.00,12.50,1375.00,'2023-02-06 14:30:55','',''),(1861,'1','307','1',1,'Retail Sale Id 1851',9250.00,0.00,0.00,12.50,1375.00,'2023-02-06 14:30:55','',''),(1862,'1','307','1',1,'Retail Sale Id 1852',1480.00,0.00,0.00,2.00,220.00,'2023-02-06 15:04:18','',''),(1863,'1','307','1',1,'Retail Sale Id 1853',3700.00,0.00,0.00,5.00,550.00,'2023-02-06 15:08:28','',''),(1864,'1','307','1',1,'Retail Sale Id 1854',2220.00,0.00,0.00,3.00,330.00,'2023-02-06 15:30:44','',''),(1865,'1','307','1',1,'Retail Sale Id 1855',4802.60,0.00,0.00,6.49,713.90,'2023-02-06 16:02:00','',''),(1866,'1','307','1',1,'Retail Sale Id 1856',4440.00,0.00,0.00,6.00,660.00,'2023-02-06 16:17:58','',''),(1867,'1','307','1',1,'Retail Sale Id 1857',1480.00,0.00,0.00,2.00,220.00,'2023-02-06 16:19:23','',''),(1868,'1','307','1',1,'Retail Sale Id 1858',740.00,0.00,0.00,1.00,110.00,'2023-02-06 16:20:56','',''),(1869,'1','307','1',1,'Retail Sale Id 1859',999.00,0.00,0.00,1.35,148.50,'2023-02-06 16:26:35','',''),(1870,'1','307','1',1,'Retail Sale Id 1860',2249.60,0.00,0.00,3.04,334.40,'2023-02-06 16:51:57','',''),(1871,'1','307','1',1,'Retail Sale Id 1861',2249.60,0.00,0.00,3.04,334.40,'2023-02-06 16:53:58','',''),(1872,'1','307','1',1,'Retail Sale Id 1862',2220.00,0.00,0.00,3.00,330.00,'2023-02-06 17:01:42','',''),(1873,'1','307','1',1,'Retail Sale Id 1863',4440.00,0.00,0.00,6.00,660.00,'2023-02-06 17:07:03','',''),(1874,'1','307','1',1,'Retail Sale Id 1864',3700.00,0.00,0.00,5.00,550.00,'2023-02-06 17:10:25','',''),(1875,'1','307','1',1,'Retail Sale Id 1865',747.40,0.00,0.00,1.01,111.10,'2023-02-06 17:19:00','',''),(1876,'1','307','1',1,'Retail Sale Id 1866',7400.00,0.00,0.00,10.00,1100.00,'2023-02-06 17:20:59','',''),(1877,'1','307','1',1,'Retail Sale Id 1867',2220.00,0.00,0.00,3.00,330.00,'2023-02-06 17:24:14','',''),(1878,'1','307','1',1,'Retail Sale Id 1867',3700.00,0.00,0.00,5.00,550.00,'2023-02-06 17:24:14','',''),(1879,'1','307','1',1,'Retail Sale Id 1868',2249.60,0.00,0.00,3.04,334.40,'2023-02-06 17:31:07','',''),(1880,'1','307','1',1,'Retail Sale Id 1869',2220.00,0.00,0.00,3.00,330.00,'2023-02-06 17:36:37','',''),(1881,'1','307','1',1,'Retail Sale Id 1870',2960.00,0.00,0.00,4.00,440.00,'2023-02-06 17:38:06','',''),(1882,'1','307','1',1,'Retail Sale Id 1871',1998.00,0.00,0.00,2.70,297.00,'2023-02-06 17:41:59','',''),(1883,'1','307','1',1,'Retail Sale Id 1872',1998.00,0.00,0.00,2.70,297.00,'2023-02-06 17:45:56','',''),(1884,'1','307','1',1,'Retail Sale Id 1873',999.00,0.00,0.00,1.35,148.50,'2023-02-06 17:51:05','',''),(1885,'1','307','1',1,'Retail Sale Id 1874',1480.00,0.00,0.00,2.00,220.00,'2023-02-06 17:52:24','',''),(1886,'1','307','1',1,'Retail Sale Id 1875',2220.00,0.00,0.00,3.00,330.00,'2023-02-06 17:56:00','',''),(1887,'1','307','1',1,'Retail Sale Id 1876',4440.00,0.00,0.00,6.00,660.00,'2023-02-06 17:57:41','',''),(1888,'1','307','1',1,'Retail Sale Id 1877',2960.00,0.00,0.00,4.00,440.00,'2023-02-06 17:59:10','',''),(1889,'1','307','1',1,'Retail Sale Id 1878',3700.00,0.00,0.00,5.00,550.00,'2023-02-06 18:00:54','',''),(1890,'1','307','1',1,'Retail Sale Id 1879',999.00,0.00,0.00,1.35,148.50,'2023-02-06 18:10:52','',''),(1891,'1','307','1',1,'Retail Sale Id 1880',2212.60,0.00,0.00,2.99,328.90,'2023-02-06 18:16:56','',''),(1892,'1','307','1',1,'Retail Sale Id 1881',4440.00,0.00,0.00,6.00,660.00,'2023-02-06 18:26:57','',''),(1893,'1','307','1',1,'Retail Sale Id 1882',70000.00,0.00,0.00,100.00,7000.00,'2023-02-06 18:39:29','',''),(1894,'1','307','1',1,'Retail Sale Id 1883',999.00,0.00,0.00,1.35,148.50,'2023-02-06 19:02:03','',''),(1895,'1','307','1',1,'Retail Sale Id 1884',747.40,0.00,0.00,1.01,111.10,'2023-02-06 19:23:16','',''),(1896,'1','307','1',1,'Retail Sale Id 1885',1790.80,0.00,0.00,2.42,266.20,'2023-02-06 19:26:48','',''),(1897,'1','307','1',1,'Retail Sale Id 1886',861.00,0.00,0.00,1.23,86.10,'2023-02-06 19:31:41','',''),(1898,'1','307','1',1,'Retail Sale Id 1887',1998.00,0.00,0.00,2.70,297.00,'2023-02-07 07:37:18','',''),(1899,'1','307','1',1,'Retail Sale Id 1888',799.20,0.00,0.00,1.08,118.80,'2023-02-07 07:38:28','',''),(1900,'1','307','1',1,'Retail Sale Id 1889',28000.00,0.00,0.00,40.00,2800.00,'2023-02-07 07:56:53','',''),(1901,'1','307','1',1,'Retail Sale Id 1890',1502.20,0.00,0.00,2.03,223.30,'2023-02-07 08:31:45','',''),(1902,'1','307','1',1,'Retail Sale Id 1891',2249.60,0.00,0.00,3.04,334.40,'2023-02-07 08:41:18','',''),(1903,'1','307','1',1,'Retail Sale Id 1892',1502.20,0.00,0.00,2.03,223.30,'2023-02-07 08:51:36','',''),(1904,'1','307','1',1,'Retail Sale Id 1893',3700.00,0.00,0.00,5.00,550.00,'2023-02-07 10:43:20','',''),(1905,'1','307','1',1,'Retail Sale Id 1894',2220.00,0.00,0.00,3.00,330.00,'2023-02-07 11:03:38','',''),(1906,'1','307','1',1,'Retail Sale Id 1895',1502.20,0.00,0.00,2.03,223.30,'2023-02-07 11:08:18','',''),(1907,'1','307','1',1,'Retail Sale Id 1896',1502.20,0.00,0.00,2.03,223.30,'2023-02-07 11:41:44','',''),(1908,'1','307','1',1,'Retail Sale Id 1897',4447.40,0.00,0.00,6.01,661.10,'2023-02-07 11:54:17','',''),(1909,'1','307','1',1,'Retail Sale Id 1898',3700.00,0.00,0.00,5.00,550.00,'2023-02-07 12:00:18','',''),(1910,'1','307','1',1,'Retail Sale Id 1899',87500.00,0.00,0.00,125.00,8750.00,'2023-02-07 12:12:12','',''),(1911,'1','307','1',1,'Retail Sale Id 1900',4447.40,0.00,0.00,6.01,661.10,'2023-02-07 12:13:40','',''),(1912,'1','307','1',1,'Retail Sale Id 1901',4447.40,0.00,0.00,6.01,661.10,'2023-02-07 12:45:41','',''),(1913,'1','307','1',1,'Retail Sale Id 1902',4447.40,0.00,0.00,6.01,661.10,'2023-02-07 13:01:57','',''),(1914,'1','307','1',1,'Retail Sale Id 1903',2997.00,0.00,0.00,4.05,445.50,'2023-02-07 13:03:13','',''),(1915,'1','307','1',1,'Retail Sale Id 1904',999.00,0.00,0.00,1.35,148.50,'2023-02-07 13:24:22','',''),(1916,'1','307','1',1,'Retail Sale Id 1905',2249.60,0.00,0.00,3.04,334.40,'2023-02-07 13:37:27','',''),(1917,'1','307','1',1,'Retail Sale Id 1906',4447.40,0.00,0.00,6.01,661.10,'2023-02-07 13:48:37','',''),(1918,'1','307','1',1,'Retail Sale Id 1907',999.00,0.00,0.00,1.35,148.50,'2023-02-07 14:03:02','',''),(1919,'1','307','1',1,'Retail Sale Id 1908',2220.00,0.00,0.00,3.00,330.00,'2023-02-07 14:09:05','',''),(1920,'1','307','1',1,'Retail Sale Id 1909',1502.20,0.00,0.00,2.03,223.30,'2023-02-07 14:25:32','',''),(1921,'1','307','1',1,'Retail Sale Id 1910',9250.00,0.00,0.00,12.50,1375.00,'2023-02-07 14:31:49','',''),(1922,'1','307','1',1,'Retail Sale Id 1911',2220.00,0.00,0.00,3.00,330.00,'2023-02-07 15:06:15','',''),(1923,'1','307','1',1,'Retail Sale Id 1912',4447.40,0.00,0.00,6.01,661.10,'2023-02-07 15:11:10','',''),(1924,'1','307','1',1,'Retail Sale Id 1913',799.20,0.00,0.00,1.08,118.80,'2023-02-07 15:32:30','',''),(1925,'1','307','1',1,'Retail Sale Id 1914',1702.00,0.00,0.00,2.30,253.00,'2023-02-07 16:07:39','',''),(1926,'1','307','1',1,'Retail Sale Id 1915',1502.20,0.00,0.00,2.03,223.30,'2023-02-07 16:09:07','',''),(1927,'1','307','1',1,'Retail Sale Id 1916',747.40,0.00,0.00,1.01,111.10,'2023-02-07 16:24:21','',''),(1928,'1','307','1',1,'Retail Sale Id 1917',1502.20,0.00,0.00,2.03,223.30,'2023-02-07 16:42:03','',''),(1929,'1','307','1',1,'Retail Sale Id 1918',2220.00,0.00,0.00,3.00,330.00,'2023-02-07 16:54:18','',''),(1930,'1','307','1',1,'Retail Sale Id 1919',9250.00,0.00,0.00,12.50,1375.00,'2023-02-07 16:59:07','',''),(1931,'1','307','1',1,'Retail Sale Id 1919',9250.00,0.00,0.00,12.50,1375.00,'2023-02-07 16:59:07','',''),(1932,'1','307','1',1,'Retail Sale Id 1920',1998.00,0.00,0.00,2.70,297.00,'2023-02-07 17:06:52','',''),(1933,'1','307','1',1,'Retail Sale Id 1920',2997.00,0.00,0.00,4.05,445.50,'2023-02-07 17:06:52','',''),(1934,'1','307','1',1,'Retail Sale Id 1921',9250.00,0.00,0.00,12.50,1375.00,'2023-02-07 17:35:21','',''),(1935,'1','307','1',1,'Retail Sale Id 1922',2960.00,0.00,0.00,4.00,440.00,'2023-02-07 17:44:15','',''),(1936,'1','307','1',1,'Retail Sale Id 1923',2220.00,0.00,0.00,3.00,330.00,'2023-02-07 17:46:42','',''),(1937,'1','307','1',1,'Retail Sale Id 1923',2220.00,0.00,0.00,3.00,330.00,'2023-02-07 17:46:42','',''),(1938,'1','307','1',1,'Retail Sale Id 1924',799.20,0.00,0.00,1.08,118.80,'2023-02-07 18:00:21','',''),(1939,'1','307','1',1,'Retail Sale Id 1925',4447.40,0.00,0.00,6.01,661.10,'2023-02-07 18:14:08','',''),(1940,'1','307','1',1,'Retail Sale Id 1926',2249.60,0.00,0.00,3.04,334.40,'2023-02-07 18:23:01','',''),(1941,'1','307','1',1,'Retail Sale Id 1927',1502.20,0.00,0.00,2.03,223.30,'2023-02-07 18:24:16','',''),(1942,'1','307','1',1,'Retail Sale Id 1928',2249.60,0.00,0.00,3.04,334.40,'2023-02-07 18:36:14','',''),(1943,'1','307','1',1,'Retail Sale Id 1930',1117.40,0.00,0.00,1.51,166.10,'2023-02-07 18:48:02','',''),(1944,'1','307','1',1,'Retail Sale Id 1931',2197.80,0.00,0.00,2.97,326.70,'2023-02-07 18:49:10','',''),(1945,'1','307','1',1,'Retail Sale Id 1932',10700.40,0.00,0.00,14.46,1590.60,'2023-02-08 07:35:31','',''),(1946,'1','307','1',1,'Retail Sale Id 1933',3700.00,0.00,0.00,5.00,550.00,'2023-02-08 08:06:52','',''),(1947,'1','307','1',1,'Retail Sale Id 1934',3700.00,0.00,0.00,5.00,550.00,'2023-02-08 08:22:21','',''),(1948,'1','307','1',1,'Retail Sale Id 1936',70000.00,0.00,0.00,100.00,7000.00,'2023-02-08 08:30:39','',''),(1949,'1','307','1',1,'Retail Sale Id 1937',4447.40,0.00,0.00,6.01,661.10,'2023-02-08 08:32:33','',''),(1950,'1','307','1',1,'Retail Sale Id 1938',31199.00,0.00,0.00,44.57,3119.90,'2023-02-08 08:37:57','',''),(1951,'1','307','1',1,'Retail Sale Id 1939',4440.00,0.00,0.00,6.00,660.00,'2023-02-08 08:44:47','',''),(1952,'1','307','1',1,'Retail Sale Id 1940',2220.00,0.00,0.00,3.00,330.00,'2023-02-08 08:57:21','',''),(1953,'1','307','1',1,'Retail Sale Id 1941',1502.20,0.00,0.00,2.03,223.30,'2023-02-08 09:13:46','',''),(1954,'1','307','1',1,'Retail Sale Id 1942',2249.60,0.00,0.00,3.04,334.40,'2023-02-08 09:20:30','',''),(1955,'1','307','1',1,'Retail Sale Id 1943',3700.00,0.00,0.00,5.00,550.00,'2023-02-08 09:51:44','',''),(1956,'1','307','1',1,'Retail Sale Id 1944',2997.00,0.00,0.00,4.05,445.50,'2023-02-08 10:03:14','',''),(1957,'1','307','1',1,'Retail Sale Id 1945',2220.00,0.00,0.00,3.00,330.00,'2023-02-08 10:11:13','',''),(1958,'1','307','1',1,'Retail Sale Id 1946',2220.00,0.00,0.00,3.00,330.00,'2023-02-08 10:23:57','',''),(1959,'1','307','1',1,'Retail Sale Id 1947',2997.00,0.00,0.00,4.05,445.50,'2023-02-08 10:35:08','',''),(1960,'1','307','1',1,'Retail Sale Id 1948',2997.00,0.00,0.00,4.05,445.50,'2023-02-08 10:38:57','',''),(1961,'1','307','1',1,'Retail Sale Id 1949',3700.00,0.00,0.00,5.00,550.00,'2023-02-08 10:48:21','',''),(1962,'1','307','1',1,'Retail Sale Id 1950',3700.00,0.00,0.00,5.00,550.00,'2023-02-08 10:56:09','',''),(1963,'1','307','1',1,'Retail Sale Id 1951',4447.40,0.00,0.00,6.01,661.10,'2023-02-08 11:11:17','',''),(1964,'1','307','1',1,'Retail Sale Id 1952',1502.20,0.00,0.00,2.03,223.30,'2023-02-08 11:20:35','',''),(1965,'1','307','1',1,'Retail Sale Id 1953',1502.20,0.00,0.00,2.03,223.30,'2023-02-08 11:21:41','',''),(1966,'1','307','1',1,'Retail Sale Id 1954',999.00,0.00,0.00,1.35,148.50,'2023-02-08 11:37:27','',''),(1967,'1','307','1',1,'Retail Sale Id 1955',3700.00,0.00,0.00,5.00,550.00,'2023-02-08 12:28:31','',''),(1968,'1','307','1',1,'Retail Sale Id 1956',4447.40,0.00,0.00,6.01,661.10,'2023-02-08 12:31:02','',''),(1969,'1','307','1',1,'Retail Sale Id 1957',4440.00,0.00,0.00,6.00,660.00,'2023-02-08 12:39:32','',''),(1970,'1','307','1',1,'Retail Sale Id 1958',3700.00,0.00,0.00,5.00,550.00,'2023-02-08 12:57:54','',''),(1971,'1','307','1',1,'Retail Sale Id 1959',1502.20,0.00,0.00,2.03,223.30,'2023-02-08 12:58:54','',''),(1972,'1','307','1',1,'Retail Sale Id 1960',7400.00,0.00,0.00,10.00,1100.00,'2023-02-08 13:08:28','',''),(1973,'1','307','1',1,'Retail Sale Id 1960',9250.00,0.00,0.00,12.50,1375.00,'2023-02-08 13:08:28','',''),(1974,'1','307','1',1,'Retail Sale Id 1961',3700.00,0.00,0.00,5.00,550.00,'2023-02-08 13:13:15','',''),(1975,'1','307','1',1,'Retail Sale Id 1962',4440.00,0.00,0.00,6.00,660.00,'2023-02-08 13:36:03','',''),(1976,'1','307','1',1,'Retail Sale Id 1963',9250.00,0.00,0.00,12.50,1375.00,'2023-02-08 13:48:02','',''),(1977,'1','307','1',1,'Retail Sale Id 1964',2197.80,0.00,0.00,2.97,326.70,'2023-02-08 14:04:08','',''),(1978,'1','307','1',1,'Retail Sale Id 1965',3700.00,0.00,0.00,5.00,550.00,'2023-02-08 14:06:09','',''),(1979,'1','307','1',1,'Retail Sale Id 1966',1998.00,0.00,0.00,2.70,297.00,'2023-02-08 14:10:14','',''),(1980,'1','307','1',1,'Retail Sale Id 1967',1998.00,0.00,0.00,2.70,297.00,'2023-02-08 14:38:48','',''),(1981,'1','307','1',1,'Retail Sale Id 1968',599.40,0.00,0.00,0.81,89.10,'2023-02-08 14:40:44','',''),(1982,'1','307','1',1,'Retail Sale Id 1968',1502.20,0.00,0.00,2.03,223.30,'2023-02-08 14:40:44','',''),(1983,'1','307','1',1,'Retail Sale Id 1969',1502.20,0.00,0.00,2.03,223.30,'2023-02-08 14:42:57','',''),(1984,'1','307','1',1,'Retail Sale Id 1970',70000.00,0.00,0.00,100.00,7000.00,'2023-02-08 14:44:10','',''),(1985,'1','307','1',1,'Retail Sale Id 1971',2997.00,0.00,0.00,4.05,445.50,'2023-02-08 15:07:46','',''),(1986,'1','307','1',1,'Retail Sale Id 1972',4447.40,0.00,0.00,6.01,661.10,'2023-02-08 15:26:31','',''),(1987,'1','307','1',1,'Retail Sale Id 1973',1998.00,0.00,0.00,2.70,297.00,'2023-02-08 15:27:46','',''),(1988,'1','307','1',1,'Retail Sale Id 1974',9250.00,0.00,0.00,12.50,1375.00,'2023-02-08 15:28:49','',''),(1989,'1','307','1',1,'Retail Sale Id 1976',799.20,0.00,0.00,1.08,118.80,'2023-02-08 15:33:50','',''),(1990,'1','307','1',1,'Retail Sale Id 1977',4447.40,0.00,0.00,6.01,661.10,'2023-02-08 15:35:32','',''),(1991,'1','307','1',1,'Retail Sale Id 1978',1998.00,0.00,0.00,2.70,297.00,'2023-02-08 15:38:50','',''),(1992,'1','307','1',1,'Retail Sale Id 1979',2501.20,0.00,0.00,3.38,371.80,'2023-02-08 15:51:16','',''),(1993,'1','307','1',1,'Retail Sale Id 1980',1502.20,0.00,0.00,2.03,223.30,'2023-02-08 16:04:19','',''),(1994,'1','307','1',1,'Retail Sale Id 1981',2249.60,0.00,0.00,3.04,334.40,'2023-02-08 16:25:29','',''),(1995,'1','307','1',1,'Retail Sale Id 1982',5002.40,0.00,0.00,6.76,743.60,'2023-02-08 16:30:55','',''),(1996,'1','307','1',1,'Retail Sale Id 1983',4447.40,0.00,0.00,6.01,661.10,'2023-02-08 16:44:17','',''),(1997,'1','307','1',1,'Retail Sale Id 1984',2997.00,0.00,0.00,4.05,445.50,'2023-02-08 16:47:21','',''),(1998,'1','307','1',1,'Retail Sale Id 1985',2960.00,0.00,0.00,4.00,440.00,'2023-02-08 16:58:06','',''),(1999,'1','307','1',1,'Retail Sale Id 1986',9250.00,0.00,0.00,12.50,1375.00,'2023-02-08 17:05:16','',''),(2000,'1','307','1',1,'Retail Sale Id 1987',2900.80,0.00,0.00,3.92,431.20,'2023-02-08 17:08:31','',''),(2001,'1','307','1',1,'Retail Sale Id 1988',9649.60,0.00,0.00,13.04,1434.40,'2023-02-08 17:12:35','',''),(2002,'1','307','1',1,'Retail Sale Id 1989',703.00,0.00,0.00,0.95,104.50,'2023-02-08 17:14:36','',''),(2003,'1','307','1',1,'Retail Sale Id 1990',9250.00,0.00,0.00,12.50,1375.00,'2023-02-08 17:21:03','',''),(2004,'1','307','1',1,'Retail Sale Id 1991',1398.60,0.00,0.00,1.89,207.90,'2023-02-08 17:23:25','',''),(2005,'1','307','1',1,'Retail Sale Id 1992',6001.40,0.00,0.00,8.11,892.10,'2023-02-08 17:33:10','',''),(2006,'1','307','1',1,'Retail Sale Id 1993',2220.00,0.00,0.00,3.00,330.00,'2023-02-08 17:35:52','',''),(2007,'1','307','1',1,'Retail Sale Id 1994',9250.00,0.00,0.00,12.50,1375.00,'2023-02-08 17:38:55','',''),(2008,'1','307','1',1,'Retail Sale Id 1995',4447.40,0.00,0.00,6.01,661.10,'2023-02-08 17:41:04','',''),(2009,'1','307','1',1,'Retail Sale Id 1996',1502.20,0.00,0.00,2.03,223.30,'2023-02-08 17:52:56','',''),(2010,'1','307','1',1,'Retail Sale Id 1997',4440.00,0.00,0.00,6.00,660.00,'2023-02-08 17:56:40','',''),(2011,'1','307','1',1,'Retail Sale Id 1998',1998.00,0.00,0.00,2.70,297.00,'2023-02-08 18:16:10','',''),(2012,'1','307','1',1,'Retail Sale Id 1999',1502.20,0.00,0.00,2.03,223.30,'2023-02-08 18:30:00','',''),(2013,'1','307','1',1,'Retail Sale Id 2000',2997.00,0.00,0.00,4.05,445.50,'2023-02-08 18:32:27','',''),(2014,'1','307','1',1,'Retail Sale Id 2001',9250.00,0.00,0.00,12.50,1375.00,'2023-02-08 18:47:05','',''),(2015,'1','307','1',1,'Retail Sale Id 2002',747.40,0.00,0.00,1.01,111.10,'2023-02-08 18:53:59','',''),(2016,'1','307','1',1,'Retail Sale Id 2003',2678.80,0.00,0.00,3.62,398.20,'2023-02-08 19:12:31','',''),(2017,'1','307','1',1,'Retail Sale Id 2004',1502.20,0.00,0.00,2.03,223.30,'2023-02-09 07:35:19','',''),(2018,'1','307','1',1,'Retail Sale Id 2005',1502.20,0.00,0.00,2.03,223.30,'2023-02-09 07:37:03','',''),(2019,'1','307','1',1,'Retail Sale Id 2006',799.20,0.00,0.00,1.08,118.80,'2023-02-09 07:42:36','',''),(2020,'1','307','1',1,'Retail Sale Id 2007',9250.00,0.00,0.00,12.50,1375.00,'2023-02-09 07:46:28','',''),(2021,'1','307','1',1,'Retail Sale Id 2008',4447.40,0.00,0.00,6.01,661.10,'2023-02-09 07:56:08','',''),(2022,'1','307','1',1,'Retail Sale Id 2009',5202.20,0.00,0.00,7.03,773.30,'2023-02-09 08:04:29','',''),(2023,'1','307','1',1,'Retail Sale Id 2010',9250.00,0.00,0.00,12.50,1375.00,'2023-02-09 08:06:51','',''),(2024,'1','307','1',1,'Retail Sale Id 2011',5202.20,0.00,0.00,7.03,773.30,'2023-02-09 08:08:03','',''),(2025,'1','307','1',1,'Retail Sale Id 2012',9250.00,0.00,0.00,12.50,1375.00,'2023-02-09 08:10:06','',''),(2026,'1','307','1',1,'Retail Sale Id 2013',2220.00,0.00,0.00,3.00,330.00,'2023-02-09 08:19:10','',''),(2027,'1','307','1',1,'Retail Sale Id 2014',34000.00,0.00,0.00,50.00,2500.00,'2023-02-09 08:22:11','',''),(2028,'1','307','1',1,'Retail Sale Id 2015',9250.00,0.00,0.00,12.50,1375.00,'2023-02-09 08:24:55','',''),(2029,'1','307','1',1,'Retail Sale Id 2016',4440.00,0.00,0.00,6.00,660.00,'2023-02-09 08:28:14','',''),(2030,'1','307','1',1,'Retail Sale Id 2017',4447.40,0.00,0.00,6.01,661.10,'2023-02-09 08:43:15','',''),(2031,'1','307','1',1,'Retail Sale Id 2018',3700.00,0.00,0.00,5.00,550.00,'2023-02-09 08:46:33','',''),(2032,'1','307','1',1,'Retail Sale Id 2019',2997.00,0.00,0.00,4.05,445.50,'2023-02-09 09:07:55','',''),(2033,'1','307','1',1,'Retail Sale Id 2020',4440.00,0.00,0.00,6.00,660.00,'2023-02-09 09:11:36','',''),(2034,'1','307','1',1,'Retail Sale Id 2021',9250.00,0.00,0.00,12.50,1375.00,'2023-02-09 09:15:57','',''),(2035,'1','307','1',1,'Retail Sale Id 2022',9250.00,0.00,0.00,12.50,1375.00,'2023-02-09 09:18:15','',''),(2036,'1','307','1',1,'Retail Sale Id 2024',20998.40,0.00,0.00,30.88,1544.00,'2023-02-09 09:47:13','',''),(2037,'1','307','1',1,'Retail Sale Id 2025',2220.00,0.00,0.00,3.00,330.00,'2023-02-09 09:52:40','',''),(2038,'1','307','1',1,'Retail Sale Id 2026',1502.20,0.00,0.00,2.03,223.30,'2023-02-09 09:56:36','',''),(2039,'1','307','1',1,'Retail Sale Id 2027',2249.60,0.00,0.00,3.04,334.40,'2023-02-09 10:17:18','',''),(2040,'1','307','1',1,'Retail Sale Id 2028',1502.20,0.00,0.00,2.03,223.30,'2023-02-09 10:19:20','',''),(2041,'1','307','1',1,'Retail Sale Id 2029',3700.00,0.00,0.00,5.00,550.00,'2023-02-09 10:20:23','',''),(2042,'1','307','1',1,'Retail Sale Id 2030',2997.00,0.00,0.00,4.05,445.50,'2023-02-09 10:44:17','',''),(2043,'1','307','1',1,'Retail Sale Id 2031',136000.00,0.00,0.00,200.00,10000.00,'2023-02-09 10:59:05','',''),(2044,'1','307','1',1,'Retail Sale Id 2032',2249.60,0.00,0.00,3.04,334.40,'2023-02-09 11:04:56','',''),(2045,'1','307','1',1,'Retail Sale Id 2033',999.00,0.00,0.00,1.35,148.50,'2023-02-09 11:29:04','',''),(2046,'1','307','1',1,'Retail Sale Id 2034',2220.00,0.00,0.00,3.00,330.00,'2023-02-09 12:02:57','',''),(2047,'1','307','1',1,'Retail Sale Id 2035',4447.40,0.00,0.00,6.01,661.10,'2023-02-09 12:15:01','',''),(2048,'1','307','1',1,'Retail Sale Id 2036',3700.00,0.00,0.00,5.00,550.00,'2023-02-09 12:41:40','',''),(2049,'1','307','1',1,'Retail Sale Id 2037',3700.00,0.00,0.00,5.00,550.00,'2023-02-09 12:59:53','',''),(2050,'1','307','1',1,'Retail Sale Id 2038',85000.00,0.00,0.00,125.00,6250.00,'2023-02-09 13:07:51','',''),(2051,'1','307','1',1,'Retail Sale Id 2039',9250.00,0.00,0.00,12.50,1375.00,'2023-02-09 13:14:38','',''),(2052,'1','307','1',1,'Retail Sale Id 2040',4447.40,0.00,0.00,6.01,661.10,'2023-02-09 14:00:16','',''),(2053,'1','307','1',1,'Retail Sale Id 2041',2220.00,0.00,0.00,3.00,330.00,'2023-02-09 14:10:32','',''),(2054,'1','307','1',1,'Retail Sale Id 2042',1480.00,0.00,0.00,2.00,220.00,'2023-02-09 14:13:21','',''),(2055,'1','307','1',1,'Retail Sale Id 2043',9250.00,0.00,0.00,12.50,1375.00,'2023-02-09 14:15:23','',''),(2056,'1','307','1',1,'Retail Sale Id 2044',2249.60,0.00,0.00,3.04,334.40,'2023-02-09 14:32:40','',''),(2057,'1','307','1',1,'Retail Sale Id 2045',1502.20,0.00,0.00,2.03,223.30,'2023-02-09 14:55:39','',''),(2058,'1','307','1',1,'Retail Sale Id 2046',1398.60,0.00,0.00,1.89,207.90,'2023-02-09 14:58:25','',''),(2059,'1','307','1',1,'Retail Sale Id 2047',27200.00,0.00,0.00,40.00,2000.00,'2023-02-09 15:12:36','',''),(2060,'1','307','1',1,'Retail Sale Id 2048',2220.00,0.00,0.00,3.00,330.00,'2023-02-09 15:14:52','',''),(2061,'1','307','1',1,'Retail Sale Id 2049',34000.00,0.00,0.00,50.00,2500.00,'2023-02-09 15:29:04','',''),(2062,'1','307','1',1,'Retail Sale Id 2050',3700.00,0.00,0.00,5.00,550.00,'2023-02-09 15:33:35','',''),(2063,'1','307','1',1,'Retail Sale Id 2051',2997.00,0.00,0.00,4.05,445.50,'2023-02-09 15:46:45','',''),(2064,'1','307','1',1,'Retail Sale Id 2052',3700.00,0.00,0.00,5.00,550.00,'2023-02-09 15:54:09','',''),(2065,'1','307','1',1,'Retail Sale Id 2053',1502.20,0.00,0.00,2.03,223.30,'2023-02-09 16:19:37','',''),(2066,'1','307','1',1,'Retail Sale Id 2054',9250.00,0.00,0.00,12.50,1375.00,'2023-02-09 16:29:43','',''),(2067,'1','307','1',1,'Retail Sale Id 2055',2952.60,0.00,0.00,3.99,438.90,'2023-02-09 16:35:33','',''),(2068,'1','307','1',1,'Retail Sale Id 2056',740.00,0.00,0.00,1.00,110.00,'2023-02-09 16:42:59','',''),(2069,'1','307','1',1,'Retail Sale Id 2057',1502.20,0.00,0.00,2.03,223.30,'2023-02-09 16:45:19','',''),(2070,'1','307','1',1,'Retail Sale Id 2058',9250.00,0.00,0.00,12.50,1375.00,'2023-02-09 16:52:01','',''),(2071,'1','307','1',1,'Retail Sale Id 2059',4440.00,0.00,0.00,6.00,660.00,'2023-02-09 16:56:27','',''),(2072,'1','307','1',1,'Retail Sale Id 2060',1480.00,0.00,0.00,2.00,220.00,'2023-02-09 16:59:05','',''),(2073,'1','307','1',1,'Retail Sale Id 2061',747.40,0.00,0.00,1.01,111.10,'2023-02-09 17:04:44','',''),(2074,'1','307','1',1,'Retail Sale Id 2062',3700.00,0.00,0.00,5.00,550.00,'2023-02-09 17:07:06','',''),(2075,'1','307','1',1,'Retail Sale Id 2063',902.80,0.00,0.00,1.22,134.20,'2023-02-09 17:09:12','',''),(2076,'1','307','1',1,'Retail Sale Id 2064',4447.40,0.00,0.00,6.01,661.10,'2023-02-09 17:18:29','',''),(2077,'1','307','1',1,'Retail Sale Id 2065',3500.20,0.00,0.00,4.73,520.30,'2023-02-09 17:20:02','',''),(2078,'1','307','1',1,'Retail Sale Id 2066',4440.00,0.00,0.00,6.00,660.00,'2023-02-09 17:32:33','',''),(2079,'1','307','1',1,'Retail Sale Id 2066',9250.00,0.00,0.00,12.50,1375.00,'2023-02-09 17:32:33','',''),(2080,'1','307','1',1,'Retail Sale Id 2067',2220.00,0.00,0.00,3.00,330.00,'2023-02-09 17:34:37','',''),(2081,'1','307','1',1,'Retail Sale Id 2068',34000.00,0.00,0.00,50.00,2500.00,'2023-02-09 17:38:33','',''),(2082,'1','307','1',1,'Retail Sale Id 2069',9250.00,0.00,0.00,12.50,1375.00,'2023-02-09 17:50:25','',''),(2083,'1','307','1',1,'Retail Sale Id 2070',1702.00,0.00,0.00,2.30,253.00,'2023-02-09 18:00:45','',''),(2084,'1','307','1',1,'Retail Sale Id 2072',2220.00,0.00,0.00,3.00,330.00,'2023-02-09 18:03:15','',''),(2085,'1','307','1',1,'Retail Sale Id 2073',3700.00,0.00,0.00,5.00,550.00,'2023-02-09 18:05:04','',''),(2086,'1','307','1',1,'Retail Sale Id 2074',2220.00,0.00,0.00,3.00,330.00,'2023-02-09 18:10:04','',''),(2087,'1','307','1',1,'Retail Sale Id 2074',4440.00,0.00,0.00,6.00,660.00,'2023-02-09 18:10:04','',''),(2088,'1','307','1',1,'Retail Sale Id 2075',1502.20,0.00,0.00,2.03,223.30,'2023-02-09 18:12:27','',''),(2089,'1','307','1',1,'Retail Sale Id 2076',2220.00,0.00,0.00,3.00,330.00,'2023-02-09 18:23:20','',''),(2090,'1','307','1',1,'Retail Sale Id 2077',2997.00,0.00,0.00,4.05,445.50,'2023-02-09 18:25:33','',''),(2091,'1','307','1',1,'Retail Sale Id 2078',4440.00,0.00,0.00,6.00,660.00,'2023-02-09 18:27:11','',''),(2092,'1','307','1',1,'Retail Sale Id 2079',2960.00,0.00,0.00,4.00,440.00,'2023-02-09 18:37:32','',''),(2093,'1','307','1',1,'Retail Sale Id 2081',2249.60,0.00,0.00,3.04,334.40,'2023-02-09 18:42:59','',''),(2094,'1','307','1',1,'Retail Sale Id 2082',68000.00,0.00,0.00,100.00,5000.00,'2023-02-09 18:44:51','',''),(2095,'1','307','1',1,'Retail Sale Id 2083',4447.40,0.00,0.00,6.01,661.10,'2023-02-09 19:08:21','',''),(2096,'1','307','1',1,'Retail Sale Id 2084',1502.20,0.00,0.00,2.03,223.30,'2023-02-10 07:45:03','',''),(2097,'1','307','1',1,'Retail Sale Id 2085',2220.00,0.00,0.00,3.00,330.00,'2023-02-10 07:46:27','',''),(2098,'1','307','1',1,'Retail Sale Id 2086',34000.00,0.00,0.00,50.00,2500.00,'2023-02-10 08:13:07','',''),(2099,'1','307','1',1,'Retail Sale Id 2087',4447.40,0.00,0.00,6.01,661.10,'2023-02-10 08:28:08','',''),(2100,'1','307','1',1,'Retail Sale Id 2088',34000.00,0.00,0.00,50.00,2500.00,'2023-02-10 08:31:46','',''),(2101,'1','307','1',1,'Retail Sale Id 2089',4440.00,0.00,0.00,6.00,660.00,'2023-02-10 08:48:21','',''),(2102,'1','307','1',1,'Retail Sale Id 2090',9250.00,0.00,0.00,12.50,1375.00,'2023-02-10 08:49:21','',''),(2103,'1','307','1',1,'Retail Sale Id 2091',2249.60,0.00,0.00,3.04,334.40,'2023-02-10 09:00:21','',''),(2104,'1','307','1',1,'Retail Sale Id 2092',2997.00,0.00,0.00,4.05,445.50,'2023-02-10 09:01:26','',''),(2105,'1','307','1',1,'Retail Sale Id 2093',4003.40,0.00,0.00,5.41,595.10,'2023-02-10 09:17:05','',''),(2106,'1','307','1',1,'Retail Sale Id 2094',1998.00,0.00,0.00,2.70,297.00,'2023-02-10 09:24:27','',''),(2107,'1','307','1',1,'Retail Sale Id 2095',9250.00,0.00,0.00,12.50,1375.00,'2023-02-10 09:39:12','',''),(2108,'1','307','1',1,'Retail Sale Id 2096',3700.00,0.00,0.00,5.00,550.00,'2023-02-10 09:49:50','',''),(2109,'1','307','1',1,'Retail Sale Id 2097',2997.00,0.00,0.00,4.05,445.50,'2023-02-10 09:51:19','',''),(2110,'1','307','1',1,'Retail Sale Id 2098',9250.00,0.00,0.00,12.50,1375.00,'2023-02-10 10:08:03','',''),(2111,'1','307','1',1,'Retail Sale Id 2099',2220.00,0.00,0.00,3.00,330.00,'2023-02-10 10:37:06','',''),(2112,'1','307','1',1,'Retail Sale Id 2100',2997.00,0.00,0.00,4.05,445.50,'2023-02-10 10:44:32','',''),(2113,'1','307','1',1,'Retail Sale Id 2101',2220.00,0.00,0.00,3.00,330.00,'2023-02-10 10:45:56','',''),(2114,'1','307','1',1,'Retail Sale Id 2102',34000.00,0.00,0.00,50.00,2500.00,'2023-02-10 10:58:37','',''),(2115,'1','307','1',1,'Retail Sale Id 2103',4003.40,0.00,0.00,5.41,595.10,'2023-02-10 11:08:47','',''),(2116,'1','307','1',1,'Retail Sale Id 2104',4447.40,0.00,0.00,6.01,661.10,'2023-02-10 11:32:17','',''),(2117,'1','307','1',1,'Retail Sale Id 2105',4440.00,0.00,0.00,6.00,660.00,'2023-02-10 11:46:33','',''),(2118,'1','307','1',1,'Retail Sale Id 2106',4447.40,0.00,0.00,6.01,661.10,'2023-02-10 11:51:11','',''),(2119,'1','307','1',1,'Retail Sale Id 2107',51000.00,0.00,0.00,75.00,3750.00,'2023-02-10 11:53:14','',''),(2120,'1','307','1',1,'Retail Sale Id 2108',34000.00,0.00,0.00,50.00,2500.00,'2023-02-10 12:11:56','',''),(2121,'1','307','1',1,'Retail Sale Id 2109',1502.20,0.00,0.00,2.03,223.30,'2023-02-10 12:15:58','',''),(2122,'1','307','1',1,'Retail Sale Id 2110',2997.00,0.00,0.00,4.05,445.50,'2023-02-10 12:18:50','',''),(2123,'1','307','1',1,'Retail Sale Id 2111',1502.20,0.00,0.00,2.03,223.30,'2023-02-10 12:21:28','',''),(2124,'1','307','1',1,'Retail Sale Id 2112',1502.20,0.00,0.00,2.03,223.30,'2023-02-10 12:23:31','',''),(2125,'1','307','1',1,'Retail Sale Id 2113',3700.00,0.00,0.00,5.00,550.00,'2023-02-10 13:03:31','',''),(2126,'1','307','1',1,'Retail Sale Id 2114',1502.20,0.00,0.00,2.03,223.30,'2023-02-10 13:06:56','',''),(2127,'1','307','1',1,'Retail Sale Id 2115',4440.00,0.00,0.00,6.00,660.00,'2023-02-10 13:08:11','',''),(2128,'1','307','1',1,'Retail Sale Id 2116',1998.00,0.00,0.00,2.70,297.00,'2023-02-10 14:15:38','',''),(2129,'1','307','1',1,'Retail Sale Id 2117',9250.00,0.00,0.00,12.50,1375.00,'2023-02-10 14:47:18','',''),(2130,'1','307','1',1,'Retail Sale Id 2118',2997.00,0.00,0.00,4.05,445.50,'2023-02-10 15:48:36','',''),(2131,'1','307','1',1,'Retail Sale Id 2119',2220.00,0.00,0.00,3.00,330.00,'2023-02-10 16:31:28','',''),(2132,'1','307','1',1,'Retail Sale Id 2120',9250.00,0.00,0.00,12.50,1375.00,'2023-02-10 16:39:51','',''),(2133,'1','307','1',1,'Retail Sale Id 2121',6001.40,0.00,0.00,8.11,892.10,'2023-02-10 16:44:58','',''),(2134,'1','307','1',1,'Retail Sale Id 2122',3700.00,0.00,0.00,5.00,550.00,'2023-02-10 16:58:45','',''),(2135,'1','307','1',1,'Retail Sale Id 2123',9997.40,0.00,0.00,13.51,1486.10,'2023-02-10 17:03:49','',''),(2136,'1','307','1',1,'Retail Sale Id 2124',2249.60,0.00,0.00,3.04,334.40,'2023-02-10 17:17:54','',''),(2137,'1','307','1',1,'Retail Sale Id 2125',7400.00,0.00,0.00,10.00,1100.00,'2023-02-10 17:18:54','',''),(2138,'1','307','1',1,'Retail Sale Id 2126',2197.80,0.00,0.00,2.97,326.70,'2023-02-10 17:25:15','',''),(2139,'1','307','1',1,'Retail Sale Id 2127',1502.20,0.00,0.00,2.03,223.30,'2023-02-10 17:31:32','',''),(2140,'1','307','1',1,'Retail Sale Id 2128',4447.40,0.00,0.00,6.01,661.10,'2023-02-10 17:32:59','',''),(2141,'1','307','1',1,'Retail Sale Id 2129',2220.00,0.00,0.00,3.00,330.00,'2023-02-10 17:34:01','',''),(2142,'1','307','1',1,'Retail Sale Id 2130',9250.00,0.00,0.00,12.50,1375.00,'2023-02-10 17:44:49','',''),(2143,'1','307','1',1,'Retail Sale Id 2132',2220.00,0.00,0.00,3.00,330.00,'2023-02-10 17:49:17','',''),(2144,'1','307','1',1,'Retail Sale Id 2133',3700.00,0.00,0.00,5.00,550.00,'2023-02-10 17:53:51','',''),(2145,'1','307','1',1,'Retail Sale Id 2134',3300.40,0.00,0.00,4.46,490.60,'2023-02-10 18:15:56','',''),(2146,'1','307','1',1,'Retail Sale Id 2135',3700.00,0.00,0.00,5.00,550.00,'2023-02-10 18:16:52','',''),(2147,'1','307','1',1,'Retail Sale Id 2136',1998.00,0.00,0.00,2.70,297.00,'2023-02-10 18:21:20','',''),(2148,'1','307','1',1,'Retail Sale Id 2137',3700.00,0.00,0.00,5.00,550.00,'2023-02-10 18:46:21','',''),(2149,'1','307','1',1,'Retail Sale Id 2138',7400.00,0.00,0.00,10.00,1100.00,'2023-02-10 18:48:07','',''),(2150,'1','307','1',1,'Retail Sale Id 2139',23347.00,0.00,0.00,31.55,3470.50,'2023-02-10 18:50:00','',''),(2151,'1','307','1',1,'Retail Sale Id 2140',2249.60,0.00,0.00,3.04,334.40,'2023-02-10 19:01:29','',''),(2152,'1','307','1',1,'Retail Sale Id 2141',1502.20,0.00,0.00,2.03,223.30,'2023-02-10 19:04:57','',''),(2153,'1','307','1',1,'Retail Sale Id 2142',7400.00,0.00,0.00,10.00,1100.00,'2023-02-10 19:09:22','',''),(2154,'1','307','1',1,'Retail Sale Id 2143',2220.00,0.00,0.00,3.00,330.00,'2023-02-10 19:21:59','',''),(2155,'1','307','1',1,'Retail Sale Id 2144',9250.00,0.00,0.00,12.50,1375.00,'2023-02-11 07:33:17','',''),(2156,'1','307','1',1,'Retail Sale Id 2145',4440.00,0.00,0.00,6.00,660.00,'2023-02-11 07:34:17','',''),(2157,'1','307','1',1,'Retail Sale Id 2146',3700.00,0.00,0.00,5.00,550.00,'2023-02-11 07:49:59','',''),(2158,'1','307','1',1,'Retail Sale Id 2147',999.00,0.00,0.00,1.35,148.50,'2023-02-11 07:53:57','',''),(2159,'1','307','1',1,'Retail Sale Id 2148',2220.00,0.00,0.00,3.00,330.00,'2023-02-11 08:08:24','',''),(2160,'1','307','1',1,'Retail Sale Id 2149',9250.00,0.00,0.00,12.50,1375.00,'2023-02-11 08:26:01','',''),(2161,'1','307','1',1,'Retail Sale Id 2150',2997.00,0.00,0.00,4.05,445.50,'2023-02-11 08:34:12','',''),(2162,'1','307','1',1,'Retail Sale Id 2151',4440.00,0.00,0.00,6.00,660.00,'2023-02-11 08:35:18','',''),(2163,'1','307','1',1,'Retail Sale Id 2152',2220.00,0.00,0.00,3.00,330.00,'2023-02-11 08:46:09','',''),(2164,'1','307','1',1,'Retail Sale Id 2153',2220.00,0.00,0.00,3.00,330.00,'2023-02-11 08:46:55','',''),(2165,'1','307','1',1,'Retail Sale Id 2154',2220.00,0.00,0.00,3.00,330.00,'2023-02-11 08:56:22','',''),(2166,'1','307','1',1,'Retail Sale Id 2155',2220.00,0.00,0.00,3.00,330.00,'2023-02-11 09:13:28','',''),(2167,'1','307','1',1,'Retail Sale Id 2157',2220.00,0.00,0.00,3.00,330.00,'2023-02-11 09:45:32','',''),(2168,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,5859.00,9.30,0.00,0.00,'2023-02-11 10:03:48','',''),(2169,'1','307',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,9.30,0.00,'2023-02-11 10:04:59','',''),(2170,'1','307','1',1,'Received from bridging 8',0.00,0.00,9.30,0.00,0.00,'2023-02-11 10:04:59','',''),(2171,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,1890.00,3.00,0.00,0.00,'2023-02-11 10:07:16','',''),(2172,'1','307',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,3.00,0.00,'2023-02-11 10:08:19','',''),(2173,'1','307','1',1,'Received from bridging 9',0.00,0.00,3.00,0.00,0.00,'2023-02-11 10:08:19','',''),(2174,'1','307','1',1,'Retail Sale Id 2160',24119.60,0.00,0.00,35.47,1773.50,'2023-02-11 10:57:58','',''),(2175,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,1260000.00,2000.00,0.00,0.00,'2023-02-11 12:12:22','',''),(2176,'1','307',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,2000.00,0.00,'2023-02-11 12:13:31','',''),(2177,'1','307','1',1,'Received from bridging 10',0.00,0.00,2000.00,0.00,0.00,'2023-02-11 12:13:31','',''),(2178,'1','307','1',1,'Retail Sale Id 2161',5920.00,0.00,0.00,8.00,880.00,'2023-02-11 12:17:56','',''),(2179,'1','307','1',1,'Retail Sale Id 2162',4447.40,0.00,0.00,6.01,661.10,'2023-02-11 12:20:02','',''),(2180,'1','307','1',1,'Retail Sale Id 2163',2249.60,0.00,0.00,3.04,334.40,'2023-02-11 12:21:11','',''),(2181,'1','307','1',1,'Retail Sale Id 2164',2220.00,0.00,0.00,3.00,330.00,'2023-02-11 12:22:01','',''),(2182,'1','307','1',1,'Retail Sale Id 2165',9620.00,0.00,0.00,13.00,1430.00,'2023-02-11 12:26:34','',''),(2183,'1','307','1',1,'Retail Sale Id 2166',9880.40,0.00,0.00,14.53,726.50,'2023-02-11 12:37:43','',''),(2184,'1','307','1',1,'Retail Sale Id 2167',2997.00,0.00,0.00,4.05,445.50,'2023-02-11 12:39:49','',''),(2185,'1','307','1',1,'Retail Sale Id 2168',34000.00,0.00,0.00,50.00,2500.00,'2023-02-11 12:41:23','',''),(2186,'1','307','1',1,'Retail Sale Id 2169',4447.40,0.00,0.00,6.01,661.10,'2023-02-11 13:16:47','',''),(2187,'1','307','1',1,'Retail Sale Id 2170',999.00,0.00,0.00,1.35,148.50,'2023-02-11 13:19:01','',''),(2188,'1','307','1',1,'Retail Sale Id 2171',4440.00,0.00,0.00,6.00,660.00,'2023-02-11 13:20:23','',''),(2189,'1','307','1',1,'Retail Sale Id 2172',9250.00,0.00,0.00,12.50,1375.00,'2023-02-11 13:21:43','',''),(2190,'1','307','1',1,'Retail Sale Id 2173',4440.00,0.00,0.00,6.00,660.00,'2023-02-11 13:24:58','',''),(2191,'1','307','1',1,'Retail Sale Id 2174',7000.40,0.00,0.00,9.46,1040.60,'2023-02-11 13:26:36','',''),(2192,'1','307','1',1,'Retail Sale Id 2175',2249.60,0.00,0.00,3.04,334.40,'2023-02-11 13:31:22','',''),(2193,'1','307','1',1,'Retail Sale Id 2176',4440.00,0.00,0.00,6.00,660.00,'2023-02-11 13:36:49','',''),(2194,'1','307','1',1,'Retail Sale Id 2177',1502.20,0.00,0.00,2.03,223.30,'2023-02-11 13:39:45','',''),(2195,'1','307','1',1,'Retail Sale Id 2178',4447.40,0.00,0.00,6.01,661.10,'2023-02-11 13:50:43','',''),(2196,'1','307','1',1,'Retail Sale Id 2179',9250.00,0.00,0.00,12.50,1375.00,'2023-02-11 13:55:19','',''),(2197,'1','307','1',1,'Retail Sale Id 2180',999.00,0.00,0.00,1.35,148.50,'2023-02-11 14:14:01','',''),(2198,'1','307','1',1,'Retail Sale Id 2181',4447.40,0.00,0.00,6.01,661.10,'2023-02-11 14:18:42','',''),(2199,'1','307','1',1,'Retail Sale Id 2182',2220.00,0.00,0.00,3.00,330.00,'2023-02-11 14:52:54','',''),(2200,'1','307','1',1,'Retail Sale Id 2183',1502.20,0.00,0.00,2.03,223.30,'2023-02-11 15:18:04','',''),(2201,'1','307','1',1,'Retail Sale Id 2184',1502.20,0.00,0.00,2.03,223.30,'2023-02-11 15:19:39','',''),(2202,'1','307','1',1,'Retail Sale Id 2185',747.40,0.00,0.00,1.01,111.10,'2023-02-11 15:23:41','',''),(2203,'1','307','1',1,'Retail Sale Id 2186',5180.00,0.00,0.00,7.00,770.00,'2023-02-11 15:27:15','',''),(2204,'1','307','1',1,'Retail Sale Id 2187',68000.00,0.00,0.00,100.00,5000.00,'2023-02-11 15:45:27','',''),(2205,'1','307','1',1,'Retail Sale Id 2188',9250.00,0.00,0.00,12.50,1375.00,'2023-02-11 15:52:22','',''),(2206,'1','307','1',1,'Retail Sale Id 2189',3700.00,0.00,0.00,5.00,550.00,'2023-02-11 16:21:03','',''),(2207,'1','307','1',1,'Retail Sale Id 2190',2997.00,0.00,0.00,4.05,445.50,'2023-02-11 16:22:44','',''),(2208,'1','307','1',1,'Retail Sale Id 2191',3700.00,0.00,0.00,5.00,550.00,'2023-02-11 16:24:00','',''),(2209,'1','307','1',1,'Retail Sale Id 2192',9250.00,0.00,0.00,12.50,1375.00,'2023-02-11 16:30:52','',''),(2210,'1','307','1',1,'Retail Sale Id 2193',4440.00,0.00,0.00,6.00,660.00,'2023-02-11 16:42:24','',''),(2211,'1','307','1',1,'Retail Sale Id 2194',1502.20,0.00,0.00,2.03,223.30,'2023-02-11 16:44:12','',''),(2212,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,2053800.00,3260.00,0.00,0.00,'2023-02-11 17:04:44','',''),(2213,'1','307',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,3260.00,0.00,'2023-02-11 17:06:05','',''),(2214,'1','307','1',1,'Received from bridging 11',0.00,0.00,3260.00,0.00,0.00,'2023-02-11 17:06:05','',''),(2215,'1','307','1',1,'Retail Sale Id 2195',1398.60,0.00,0.00,1.89,207.90,'2023-02-11 17:17:55','',''),(2216,'1','307','1',1,'Retail Sale Id 2196',1502.20,0.00,0.00,2.03,223.30,'2023-02-11 17:22:31','',''),(2217,'1','307','1',1,'Retail Sale Id 2197',7400.00,0.00,0.00,10.00,1100.00,'2023-02-11 17:23:47','',''),(2218,'1','307','1',1,'Retail Sale Id 2198',747.40,0.00,0.00,1.01,111.10,'2023-02-11 17:29:20','',''),(2219,'1','307','1',1,'Retail Sale Id 2199',2220.00,0.00,0.00,3.00,330.00,'2023-02-11 17:37:12','',''),(2220,'1','307','1',1,'Retail Sale Id 2200',2249.60,0.00,0.00,3.04,334.40,'2023-02-11 17:43:58','',''),(2221,'1','307','1',1,'Retail Sale Id 2201',2220.00,0.00,0.00,3.00,330.00,'2023-02-11 17:47:56','',''),(2222,'1','307','1',1,'Retail Sale Id 2202',2960.00,0.00,0.00,4.00,440.00,'2023-02-11 17:50:12','',''),(2223,'1','307','1',1,'Retail Sale Id 2203',3700.00,0.00,0.00,5.00,550.00,'2023-02-11 17:51:35','',''),(2224,'1','307','1',1,'Retail Sale Id 2204',2249.60,0.00,0.00,3.04,334.40,'2023-02-11 18:00:15','',''),(2225,'1','307','1',1,'Retail Sale Id 2205',2220.00,0.00,0.00,3.00,330.00,'2023-02-11 18:01:37','',''),(2226,'1','307','1',1,'Retail Sale Id 2206',9250.00,0.00,0.00,12.50,1375.00,'2023-02-11 18:09:07','',''),(2227,'1','307','1',1,'Retail Sale Id 2207',1480.00,0.00,0.00,2.00,220.00,'2023-02-11 18:10:34','',''),(2228,'1','307','1',1,'Retail Sale Id 2208',2997.00,0.00,0.00,4.05,445.50,'2023-02-11 18:17:57','',''),(2229,'1','307','1',1,'Retail Sale Id 2209',4440.00,0.00,0.00,6.00,660.00,'2023-02-11 18:22:49','',''),(2230,'1','307','1',1,'Retail Sale Id 2210',9250.00,0.00,0.00,12.50,1375.00,'2023-02-11 18:33:34','',''),(2231,'1','307','1',1,'Retail Sale Id 2211',3196.80,0.00,0.00,4.32,475.20,'2023-02-11 18:34:54','',''),(2232,'1','307','1',1,'Retail Sale Id 2212',2220.00,0.00,0.00,3.00,330.00,'2023-02-11 18:40:36','',''),(2233,'1','307','1',1,'Retail Sale Id 2213',1998.00,0.00,0.00,2.70,297.00,'2023-02-11 18:44:35','',''),(2234,'1','307','1',1,'Retail Sale Id 2214',2197.80,0.00,0.00,2.97,326.70,'2023-02-11 18:47:56','',''),(2235,'1','307','1',1,'Retail Sale Id 2215',2220.00,0.00,0.00,3.00,330.00,'2023-02-11 18:48:59','',''),(2236,'1','307','1',1,'Retail Sale Id 2216',3500.20,0.00,0.00,4.73,520.30,'2023-02-11 18:50:02','',''),(2237,'1','307','1',1,'Retail Sale Id 2217',2501.20,0.00,0.00,3.38,371.80,'2023-02-11 19:07:25','',''),(2238,'1','307','1',1,'Retail Sale Id 2218',1502.20,0.00,0.00,2.03,223.30,'2023-02-11 19:10:15','',''),(2239,'1','307','1',1,'Retail Sale Id 2219',29240.00,0.00,0.00,43.00,2150.00,'2023-02-11 19:12:44','',''),(2240,'1','307','1',1,'Retail Sale Id 2220',4447.40,0.00,0.00,6.01,661.10,'2023-02-11 19:16:45','',''),(2241,'1','307','1',1,'Retail Sale Id 2221',9250.00,0.00,0.00,12.50,1375.00,'2023-02-11 19:37:12','',''),(2242,'1','307','1',1,'Return of Retail Sale Id 2218',0.00,1502.20,2.03,0.00,-223.30,'2023-02-11 19:51:35','',''),(2243,'1','307','1',1,'Retail Sale Id 2222',4447.40,0.00,0.00,6.01,661.10,'2023-02-12 07:34:11','',''),(2244,'1','307','1',1,'Retail Sale Id 2223',4447.40,0.00,0.00,6.01,661.10,'2023-02-12 07:48:00','',''),(2245,'1','307','1',1,'Retail Sale Id 2224',1502.20,0.00,0.00,2.03,223.30,'2023-02-12 07:52:53','',''),(2246,'1','307','1',1,'Retail Sale Id 2225',4447.40,0.00,0.00,6.01,661.10,'2023-02-12 07:57:50','',''),(2247,'1','307','1',1,'Retail Sale Id 2226',7400.00,0.00,0.00,10.00,1100.00,'2023-02-12 08:30:26','',''),(2248,'1','307','1',1,'Retail Sale Id 2227',4440.00,0.00,0.00,6.00,660.00,'2023-02-12 08:38:12','',''),(2249,'1','307','1',1,'Retail Sale Id 2228',9250.00,0.00,0.00,12.50,1375.00,'2023-02-12 08:48:33','',''),(2250,'1','307','1',1,'Retail Sale Id 2229',4440.00,0.00,0.00,6.00,660.00,'2023-02-12 09:05:38','',''),(2251,'1','307','1',1,'Retail Sale Id 2230',740.00,0.00,0.00,1.00,110.00,'2023-02-12 09:19:15','',''),(2252,'1','307','1',1,'Retail Sale Id 2231',1502.20,0.00,0.00,2.03,223.30,'2023-02-12 09:33:13','',''),(2253,'1','307','1',1,'Retail Sale Id 2232',4447.40,0.00,0.00,6.01,661.10,'2023-02-12 09:40:54','',''),(2254,'1','307','1',1,'Retail Sale Id 2233',13697.40,0.00,0.00,18.51,2036.10,'2023-02-12 09:48:20','',''),(2255,'1','307','1',1,'Retail Sale Id 2234',1502.20,0.00,0.00,2.03,223.30,'2023-02-12 09:59:39','',''),(2256,'1','307','1',1,'Retail Sale Id 2235',2501.20,0.00,0.00,3.38,371.80,'2023-02-12 10:08:00','',''),(2257,'1','307','1',1,'Retail Sale Id 2236',5920.00,0.00,0.00,8.00,880.00,'2023-02-12 10:10:39','',''),(2258,'1','307','1',1,'Retail Sale Id 2237',3700.00,0.00,0.00,5.00,550.00,'2023-02-12 10:11:56','',''),(2259,'1','307','1',1,'Retail Sale Id 2238',3700.00,0.00,0.00,5.00,550.00,'2023-02-12 10:15:43','',''),(2260,'1','307','1',1,'Retail Sale Id 2239',2249.60,0.00,0.00,3.04,334.40,'2023-02-12 10:22:13','',''),(2261,'1','307','1',1,'Retail Sale Id 2240',2220.00,0.00,0.00,3.00,330.00,'2023-02-12 10:36:32','',''),(2262,'1','307','1',1,'Retail Sale Id 2241',3700.00,0.00,0.00,5.00,550.00,'2023-02-12 10:41:50','',''),(2263,'1','307','1',1,'Retail Sale Id 2242',4440.00,0.00,0.00,6.00,660.00,'2023-02-12 10:45:13','',''),(2264,'1','307','1',1,'Retail Sale Id 2243',2249.60,0.00,0.00,3.04,334.40,'2023-02-12 11:06:31','',''),(2265,'1','307','1',1,'Retail Sale Id 2244',3700.00,0.00,0.00,5.00,550.00,'2023-02-12 11:07:29','',''),(2266,'1','307','1',1,'Retail Sale Id 2245',4447.40,0.00,0.00,6.01,661.10,'2023-02-12 11:09:00','',''),(2267,'1','307','1',1,'Retail Sale Id 2246',68000.00,0.00,0.00,100.00,5000.00,'2023-02-12 11:11:41','',''),(2268,'1','307','1',1,'Retail Sale Id 2247',4403.00,0.00,0.00,5.95,654.50,'2023-02-12 11:27:20','',''),(2269,'1','307','1',1,'Retail Sale Id 2248',8880.00,0.00,0.00,12.00,1320.00,'2023-02-12 11:29:57','',''),(2270,'1','307','1',1,'Retail Sale Id 2249',4440.00,0.00,0.00,6.00,660.00,'2023-02-12 11:31:30','',''),(2271,'1','307','1',1,'Retail Sale Id 2250',34000.00,0.00,0.00,50.00,2500.00,'2023-02-12 11:34:17','',''),(2272,'1','307','1',1,'Retail Sale Id 2251',68000.00,0.00,0.00,100.00,5000.00,'2023-02-12 11:47:53','',''),(2273,'1','307','1',1,'Retail Sale Id 2252',999.00,0.00,0.00,1.35,148.50,'2023-02-12 12:01:11','',''),(2274,'1','307','1',1,'Retail Sale Id 2253',1502.20,0.00,0.00,2.03,223.30,'2023-02-12 12:21:51','',''),(2275,'1','307','1',1,'Retail Sale Id 2254',4440.00,0.00,0.00,6.00,660.00,'2023-02-12 12:31:34','',''),(2276,'1','307','1',1,'Retail Sale Id 2255',4447.40,0.00,0.00,6.01,661.10,'2023-02-12 12:34:12','',''),(2277,'1','307','1',1,'Retail Sale Id 2256',1502.20,0.00,0.00,2.03,223.30,'2023-02-12 12:38:51','',''),(2278,'1','307','1',1,'Retail Sale Id 2258',2220.00,0.00,0.00,3.00,330.00,'2023-02-12 12:48:58','',''),(2279,'1','307','1',1,'Retail Sale Id 2259',2249.60,0.00,0.00,3.04,334.40,'2023-02-12 13:17:51','',''),(2280,'1','307','1',1,'Retail Sale Id 2260',3700.00,0.00,0.00,5.00,550.00,'2023-02-12 13:31:19','',''),(2281,'1','307','1',1,'Retail Sale Id 2261',3700.00,0.00,0.00,5.00,550.00,'2023-02-12 13:56:58','',''),(2282,'1','307','1',1,'Retail Sale Id 2263',1102.60,0.00,0.00,1.49,163.90,'2023-02-12 14:00:47','',''),(2283,'1','307','1',1,'Retail Sale Id 2264',2249.60,0.00,0.00,3.04,334.40,'2023-02-12 14:02:26','',''),(2284,'1','307','1',1,'Retail Sale Id 2265',740.00,0.00,0.00,1.00,110.00,'2023-02-12 14:09:16','',''),(2285,'1','307','1',1,'Retail Sale Id 2266',2220.00,0.00,0.00,3.00,330.00,'2023-02-12 14:14:20','',''),(2286,'1','307','1',1,'Retail Sale Id 2267',4440.00,0.00,0.00,6.00,660.00,'2023-02-12 14:19:27','',''),(2287,'1','307','1',1,'Retail Sale Id 2269',9250.00,0.00,0.00,12.50,1375.00,'2023-02-12 14:53:59','',''),(2288,'1','307','1',1,'Retail Sale Id 2270',9250.00,0.00,0.00,12.50,1375.00,'2023-02-12 14:56:38','',''),(2289,'1','307','1',1,'Retail Sale Id 2271',34000.00,0.00,0.00,50.00,2500.00,'2023-02-12 15:00:38','',''),(2290,'1','307','1',1,'Retail Sale Id 2272',2997.00,0.00,0.00,4.05,445.50,'2023-02-12 15:02:52','',''),(2291,'1','307','1',1,'Retail Sale Id 2274',4447.40,0.00,0.00,6.01,661.10,'2023-02-12 15:19:07','',''),(2292,'1','307','1',1,'Retail Sale Id 2275',2249.60,0.00,0.00,3.04,334.40,'2023-02-12 15:22:30','',''),(2293,'1','307','1',1,'Retail Sale Id 2276',3700.00,0.00,0.00,5.00,550.00,'2023-02-12 15:23:45','',''),(2294,'1','307','1',1,'Retail Sale Id 2277',34000.00,0.00,0.00,50.00,2500.00,'2023-02-12 15:28:05','',''),(2295,'1','307','1',1,'Retail Sale Id 2278',47260.00,0.00,0.00,69.50,3475.00,'2023-02-12 15:30:17','',''),(2296,'1','307','1',1,'Retail Sale Id 2279',2220.00,0.00,0.00,3.00,330.00,'2023-02-12 15:36:00','',''),(2297,'1','307','1',1,'Retail Sale Id 2280',4440.00,0.00,0.00,6.00,660.00,'2023-02-12 15:38:16','',''),(2298,'1','307','1',1,'Retail Sale Id 2281',3700.00,0.00,0.00,5.00,550.00,'2023-02-12 15:45:37','',''),(2299,'1','307','1',1,'Retail Sale Id 2281',4447.40,0.00,0.00,6.01,661.10,'2023-02-12 15:45:37','',''),(2300,'1','307','1',1,'Retail Sale Id 2282',4440.00,0.00,0.00,6.00,660.00,'2023-02-12 15:55:01','',''),(2301,'1','307','1',1,'Retail Sale Id 2283',2220.00,0.00,0.00,3.00,330.00,'2023-02-12 16:16:33','',''),(2302,'1','307','1',1,'Retail Sale Id 2284',4440.00,0.00,0.00,6.00,660.00,'2023-02-12 16:20:56','',''),(2303,'1','307','1',1,'Retail Sale Id 2285',7400.00,0.00,0.00,10.00,1100.00,'2023-02-12 16:25:33','',''),(2304,'1','307','1',1,'Retail Sale Id 2286',2249.60,0.00,0.00,3.04,334.40,'2023-02-12 16:32:03','',''),(2305,'1','307','1',1,'Retail Sale Id 2287',4440.00,0.00,0.00,6.00,660.00,'2023-02-12 16:44:46','',''),(2306,'1','307','1',1,'Retail Sale Id 2288',2249.60,0.00,0.00,3.04,334.40,'2023-02-12 16:46:05','',''),(2307,'1','307','1',1,'Retail Sale Id 2289',1998.00,0.00,0.00,2.70,297.00,'2023-02-12 16:50:34','',''),(2308,'1','307','1',1,'Retail Sale Id 2290',4440.00,0.00,0.00,6.00,660.00,'2023-02-12 16:51:55','',''),(2309,'1','307','1',1,'Retail Sale Id 2291',34000.00,0.00,0.00,50.00,2500.00,'2023-02-12 16:54:03','',''),(2310,'1','307','1',1,'Retail Sale Id 2292',3700.00,0.00,0.00,5.00,550.00,'2023-02-12 17:15:11','',''),(2311,'1','307','1',1,'Retail Sale Id 2293',3700.00,0.00,0.00,5.00,550.00,'2023-02-12 17:16:30','',''),(2312,'1','307','1',1,'Retail Sale Id 2294',9250.00,0.00,0.00,12.50,1375.00,'2023-02-12 17:20:29','',''),(2313,'1','307','1',1,'Retail Sale Id 2295',999.00,0.00,0.00,1.35,148.50,'2023-02-12 17:22:25','',''),(2314,'1','307','1',1,'Retail Sale Id 2296',4440.00,0.00,0.00,6.00,660.00,'2023-02-12 17:37:27','',''),(2315,'1','307','1',1,'Retail Sale Id 2297',85000.00,0.00,0.00,125.00,6250.00,'2023-02-12 17:43:22','',''),(2316,'1','307','1',1,'Retail Sale Id 2298',9250.00,0.00,0.00,12.50,1375.00,'2023-02-12 17:52:40','',''),(2317,'1','307','1',1,'Retail Sale Id 2299',2220.00,0.00,0.00,3.00,330.00,'2023-02-12 17:56:24','',''),(2318,'1','307','1',1,'Retail Sale Id 2301',2997.00,0.00,0.00,4.05,445.50,'2023-02-12 17:58:33','',''),(2319,'1','307','1',1,'Retail Sale Id 2302',1502.20,0.00,0.00,2.03,223.30,'2023-02-12 18:01:49','',''),(2320,'1','307','1',1,'Retail Sale Id 2303',1480.00,0.00,0.00,2.00,220.00,'2023-02-12 18:04:00','',''),(2321,'1','307','1',1,'Retail Sale Id 2304',999.00,0.00,0.00,1.35,148.50,'2023-02-12 18:06:02','',''),(2322,'1','307','1',1,'Retail Sale Id 2305',2220.00,0.00,0.00,3.00,330.00,'2023-02-12 18:07:37','',''),(2323,'1','307','1',1,'Retail Sale Id 2306',799.20,0.00,0.00,1.08,118.80,'2023-02-12 18:09:11','',''),(2324,'1','307','1',1,'Retail Sale Id 2307',2220.00,0.00,0.00,3.00,330.00,'2023-02-12 18:14:52','',''),(2325,'1','307','1',1,'Retail Sale Id 2309',747.40,0.00,0.00,1.01,111.10,'2023-02-12 18:22:54','',''),(2326,'1','307','1',1,'Retail Sale Id 2310',2960.00,0.00,0.00,4.00,440.00,'2023-02-12 18:24:03','',''),(2327,'1','307','1',1,'Retail Sale Id 2311',4440.00,0.00,0.00,6.00,660.00,'2023-02-12 18:26:41','',''),(2328,'1','307','1',1,'Retail Sale Id 2312',2249.60,0.00,0.00,3.04,334.40,'2023-02-12 18:29:05','',''),(2329,'1','307','1',1,'Retail Sale Id 2313',2960.00,0.00,0.00,4.00,440.00,'2023-02-12 18:33:35','',''),(2330,'1','307','1',1,'Retail Sale Id 2314',9250.00,0.00,0.00,12.50,1375.00,'2023-02-12 18:37:26','',''),(2331,'1','307','1',1,'Retail Sale Id 2315',503.20,0.00,0.00,0.68,74.80,'2023-02-12 18:39:27','',''),(2332,'1','307','1',1,'Retail Sale Id 2316',4440.00,0.00,0.00,6.00,660.00,'2023-02-12 18:42:08','',''),(2333,'1','307','1',1,'Retail Sale Id 2317',34000.00,0.00,0.00,50.00,2500.00,'2023-02-12 19:20:40','',''),(2334,'1','307','1',1,'Retail Sale Id 2318',1901.80,0.00,0.00,2.57,282.70,'2023-02-13 07:28:23','',''),(2335,'1','307','1',1,'Retail Sale Id 2319',68000.00,0.00,0.00,100.00,5000.00,'2023-02-13 07:30:12','',''),(2336,'1','307','1',1,'Retail Sale Id 2320',3700.00,0.00,0.00,5.00,550.00,'2023-02-13 07:45:04','',''),(2337,'1','307','1',1,'Retail Sale Id 2321',4447.40,0.00,0.00,6.01,661.10,'2023-02-13 07:46:47','',''),(2338,'1','307','1',1,'Retail Sale Id 2322',1998.00,0.00,0.00,2.70,297.00,'2023-02-13 07:48:43','',''),(2339,'1','307','1',1,'Retail Sale Id 2323',5002.40,0.00,0.00,6.76,743.60,'2023-02-13 07:59:24','',''),(2340,'1','307','1',1,'Retail Sale Id 2324',14496.60,0.00,0.00,19.59,2154.90,'2023-02-13 08:09:59','',''),(2341,'1','307','1',1,'Retail Sale Id 2325',7400.00,0.00,0.00,10.00,1100.00,'2023-02-13 08:11:48','',''),(2342,'1','307','1',1,'Retail Sale Id 2326',9250.00,0.00,0.00,12.50,1375.00,'2023-02-13 08:26:17','',''),(2343,'1','307','1',1,'Retail Sale Id 2327',1502.20,0.00,0.00,2.03,223.30,'2023-02-13 09:10:48','',''),(2344,'1','307','1',1,'Retail Sale Id 2328',17346.80,0.00,0.00,25.51,1275.50,'2023-02-13 09:17:44','',''),(2345,'1','307','1',1,'Retail Sale Id 2331',152653.20,0.00,0.00,224.49,11224.50,'2023-02-13 09:30:12','',''),(2346,'1','307','1',1,'Retail Sale Id 2332',4440.00,0.00,0.00,6.00,660.00,'2023-02-13 09:31:44','',''),(2347,'1','307','1',1,'Retail Sale Id 2333',20998.40,0.00,0.00,30.88,1544.00,'2023-02-13 09:42:40','',''),(2348,'1','307','1',1,'Retail Sale Id 2334',1480.00,0.00,0.00,2.00,220.00,'2023-02-13 10:04:35','',''),(2349,'1','307','1',1,'Retail Sale Id 2335',9250.00,0.00,0.00,12.50,1375.00,'2023-02-13 10:13:37','',''),(2350,'1','307','1',1,'Retail Sale Id 2336',3700.00,0.00,0.00,5.00,550.00,'2023-02-13 10:57:33','',''),(2351,'1','307','1',1,'Retail Sale Id 2337',3700.00,0.00,0.00,5.00,550.00,'2023-02-13 11:00:18','',''),(2352,'1','307','1',1,'Retail Sale Id 2338',4447.40,0.00,0.00,6.01,661.10,'2023-02-13 11:09:33','',''),(2353,'1','307','1',1,'Retail Sale Id 2339',3700.00,0.00,0.00,5.00,550.00,'2023-02-13 11:23:20','',''),(2354,'1','307','1',1,'Retail Sale Id 2340',747.40,0.00,0.00,1.01,111.10,'2023-02-13 11:31:54','',''),(2355,'1','307','1',1,'Retail Sale Id 2341',4499.20,0.00,0.00,6.08,668.80,'2023-02-13 11:55:42','',''),(2356,'1','307','1',1,'Retail Sale Id 2342',4440.00,0.00,0.00,6.00,660.00,'2023-02-13 11:59:22','',''),(2357,'1','307','1',1,'Retail Sale Id 2343',2220.00,0.00,0.00,3.00,330.00,'2023-02-13 12:16:06','',''),(2358,'1','307','1',1,'Retail Sale Id 2344',3700.00,0.00,0.00,5.00,550.00,'2023-02-13 12:39:34','',''),(2359,'1','307','1',1,'Retail Sale Id 2346',76500.00,0.00,0.00,112.50,5625.00,'2023-02-13 12:50:48','',''),(2360,'1','307','1',1,'Retail Sale Id 2347',34000.00,0.00,0.00,50.00,2500.00,'2023-02-13 12:53:50','',''),(2361,'1','307','1',1,'Retail Sale Id 2348',8902.20,0.00,0.00,12.03,1323.30,'2023-02-13 12:59:44','',''),(2362,'1','307','1',1,'Retail Sale Id 2349',2220.00,0.00,0.00,3.00,330.00,'2023-02-13 13:38:08','',''),(2363,'1','307','1',1,'Retail Sale Id 2350',2220.00,0.00,0.00,3.00,330.00,'2023-02-13 13:41:55','',''),(2364,'1','307','1',1,'Retail Sale Id 2351',2249.60,0.00,0.00,3.04,334.40,'2023-02-13 13:51:21','',''),(2365,'1','307','1',1,'Retail Sale Id 2353',9997.40,0.00,0.00,13.51,1486.10,'2023-02-13 13:54:52','',''),(2366,'1','307','1',1,'Retail Sale Id 2354',2997.00,0.00,0.00,4.05,445.50,'2023-02-13 13:56:04','',''),(2367,'1','307','1',1,'Retail Sale Id 2355',34000.00,0.00,0.00,50.00,2500.00,'2023-02-13 14:10:37','',''),(2368,'1','307','1',1,'Retail Sale Id 2356',17996.80,0.00,0.00,24.32,2675.20,'2023-02-13 14:16:45','',''),(2369,'1','307','1',1,'Retail Sale Id 2357',2997.00,0.00,0.00,4.05,445.50,'2023-02-13 14:23:52','',''),(2370,'1','307','1',1,'Retail Sale Id 2358',4003.40,0.00,0.00,5.41,595.10,'2023-02-13 15:34:26','',''),(2371,'1','307','1',1,'Retail Sale Id 2359',170000.00,0.00,0.00,250.00,12500.00,'2023-02-13 15:44:33','',''),(2372,'1','307','1',1,'Retail Sale Id 2360',4447.40,0.00,0.00,6.01,661.10,'2023-02-13 15:51:34','',''),(2373,'1','307','1',1,'Retail Sale Id 2361',999.00,0.00,0.00,1.35,148.50,'2023-02-13 15:57:40','',''),(2374,'1','307','1',1,'Retail Sale Id 2362',1998.00,0.00,0.00,2.70,297.00,'2023-02-13 15:58:40','',''),(2375,'1','307','1',1,'Retail Sale Id 2363',1398.60,0.00,0.00,1.89,207.90,'2023-02-13 16:16:02','',''),(2376,'1','307','1',1,'Retail Sale Id 2364',9250.00,0.00,0.00,12.50,1375.00,'2023-02-13 16:21:04','',''),(2377,'1','307','1',1,'Retail Sale Id 2365',4440.00,0.00,0.00,6.00,660.00,'2023-02-13 16:22:56','',''),(2378,'1','307','1',1,'Retail Sale Id 2368',4447.40,0.00,0.00,6.01,661.10,'2023-02-13 16:29:50','',''),(2379,'1','307','1',1,'Retail Sale Id 2369',1480.00,0.00,0.00,2.00,220.00,'2023-02-13 17:12:21','',''),(2380,'1','307','1',1,'Retail Sale Id 2370',1901.80,0.00,0.00,2.57,282.70,'2023-02-13 17:19:02','',''),(2381,'1','307','1',1,'Retail Sale Id 2371',2960.00,0.00,0.00,4.00,440.00,'2023-02-13 17:33:09','',''),(2382,'1','307','1',1,'Retail Sale Id 2372',4440.00,0.00,0.00,6.00,660.00,'2023-02-13 17:34:54','',''),(2383,'1','307','1',1,'Retail Sale Id 2374',2249.60,0.00,0.00,3.04,334.40,'2023-02-13 17:37:00','',''),(2384,'1','307','1',1,'Retail Sale Id 2375',4440.00,0.00,0.00,6.00,660.00,'2023-02-13 17:40:10','',''),(2385,'1','307','1',1,'Retail Sale Id 2376',4447.40,0.00,0.00,6.01,661.10,'2023-02-13 17:43:35','',''),(2386,'1','307','1',1,'Retail Sale Id 2376',4447.40,0.00,0.00,6.01,661.10,'2023-02-13 17:43:35','',''),(2387,'1','307','1',1,'Retail Sale Id 2377',2960.00,0.00,0.00,4.00,440.00,'2023-02-13 17:46:02','',''),(2388,'1','307','1',1,'Retail Sale Id 2377',2960.00,0.00,0.00,4.00,440.00,'2023-02-13 17:46:02','',''),(2389,'1','307','1',1,'Retail Sale Id 2378',999.00,0.00,0.00,1.35,148.50,'2023-02-13 17:54:34','',''),(2390,'1','307','1',1,'Retail Sale Id 2379',3700.00,0.00,0.00,5.00,550.00,'2023-02-13 17:55:43','',''),(2391,'1','307','1',1,'Retail Sale Id 2380',140760.00,0.00,0.00,207.00,10350.00,'2023-02-13 17:57:34','',''),(2392,'1','307','1',1,'Retail Sale Id 2381',4440.00,0.00,0.00,6.00,660.00,'2023-02-13 18:03:15','',''),(2393,'1','307','1',1,'Retail Sale Id 2382',2501.20,0.00,0.00,3.38,371.80,'2023-02-13 18:04:33','',''),(2394,'1','307','1',1,'Retail Sale Id 2383',2220.00,0.00,0.00,3.00,330.00,'2023-02-13 18:05:58','',''),(2395,'1','307','1',1,'Retail Sale Id 2384',2220.00,0.00,0.00,3.00,330.00,'2023-02-13 18:09:38','',''),(2396,'1','307','1',1,'Retail Sale Id 2385',999.00,0.00,0.00,1.35,148.50,'2023-02-13 18:11:35','',''),(2397,'1','307','1',1,'Retail Sale Id 2386',7400.00,0.00,0.00,10.00,1100.00,'2023-02-13 18:18:42','',''),(2398,'1','307','1',1,'Retail Sale Id 2387',4440.00,0.00,0.00,6.00,660.00,'2023-02-13 18:22:04','',''),(2399,'1','307','1',1,'Retail Sale Id 2388',30600.00,0.00,0.00,45.00,2250.00,'2023-02-13 18:25:23','',''),(2400,'1','307','1',1,'Retail Sale Id 2389',4440.00,0.00,0.00,6.00,660.00,'2023-02-13 18:26:54','',''),(2401,'1','307','1',1,'Retail Sale Id 2390',1998.00,0.00,0.00,2.70,297.00,'2023-02-13 18:31:49','',''),(2402,'1','307','1',1,'Retail Sale Id 2393',999.00,0.00,0.00,1.35,148.50,'2023-02-13 18:44:41','',''),(2403,'1','307','1',1,'Retail Sale Id 2394',4003.40,0.00,0.00,5.41,595.10,'2023-02-14 08:02:03','',''),(2404,'1','307','1',1,'Retail Sale Id 2395',999.00,0.00,0.00,1.35,148.50,'2023-02-14 08:27:53','',''),(2405,'1','307','1',1,'Retail Sale Id 2396',2249.60,0.00,0.00,3.04,334.40,'2023-02-14 08:56:44','',''),(2406,'1','307','1',1,'Retail Sale Id 2397',2997.00,0.00,0.00,4.05,445.50,'2023-02-14 09:11:16','',''),(2407,'1','307','1',1,'Retail Sale Id 2398',102000.00,0.00,0.00,150.00,7500.00,'2023-02-14 09:16:28','',''),(2408,'1','307','1',1,'Retail Sale Id 2399',2249.60,0.00,0.00,3.04,334.40,'2023-02-14 09:17:48','',''),(2409,'1','307','1',1,'Retail Sale Id 2400',3700.00,0.00,0.00,5.00,550.00,'2023-02-14 09:23:28','',''),(2410,'1','307','1',1,'Retail Sale Id 2401',7400.00,0.00,0.00,10.00,1100.00,'2023-02-14 09:52:44','',''),(2411,'1','307','1',1,'Retail Sale Id 2402',1502.20,0.00,0.00,2.03,223.30,'2023-02-14 09:54:04','',''),(2412,'1','307','1',1,'Retail Sale Id 2403',1502.20,0.00,0.00,2.03,223.30,'2023-02-14 10:06:04','',''),(2413,'1','307','1',1,'Retail Sale Id 2404',9250.00,0.00,0.00,12.50,1375.00,'2023-02-14 10:10:01','',''),(2414,'1','307','1',1,'Retail Sale Id 2406',4440.00,0.00,0.00,6.00,660.00,'2023-02-14 10:15:09','',''),(2415,'1','307','1',1,'Retail Sale Id 2408',7400.00,0.00,0.00,10.00,1100.00,'2023-02-14 10:28:53','',''),(2416,'1','307','1',1,'Retail Sale Id 2409',5180.00,0.00,0.00,7.00,770.00,'2023-02-14 10:43:28','',''),(2417,'1','307','1',1,'Retail Sale Id 2410',34000.00,0.00,0.00,50.00,2500.00,'2023-02-14 10:53:28','',''),(2418,'1','307','1',1,'Retail Sale Id 2411',2997.00,0.00,0.00,4.05,445.50,'2023-02-14 11:35:08','',''),(2419,'1','307','1',1,'Retail Sale Id 2412',3700.00,0.00,0.00,5.00,550.00,'2023-02-14 11:53:41','',''),(2420,'1','307','1',1,'Retail Sale Id 2413',85000.00,0.00,0.00,125.00,6250.00,'2023-02-14 12:05:59','',''),(2421,'1','307','1',1,'Retail Sale Id 2414',7400.00,0.00,0.00,10.00,1100.00,'2023-02-14 12:09:03','',''),(2422,'1','307','1',1,'Retail Sale Id 2415',2220.00,0.00,0.00,3.00,330.00,'2023-02-14 12:11:17','',''),(2423,'1','307','1',1,'Retail Sale Id 2416',42500.00,0.00,0.00,62.50,3125.00,'2023-02-14 12:17:53','',''),(2424,'1','307','1',1,'Retail Sale Id 2417',9250.00,0.00,0.00,12.50,1375.00,'2023-02-14 12:34:45','',''),(2425,'1','307','1',1,'Retail Sale Id 2418',1480.00,0.00,0.00,2.00,220.00,'2023-02-14 12:51:25','',''),(2426,'1','307','1',1,'Retail Sale Id 2419',102000.00,0.00,0.00,150.00,7500.00,'2023-02-14 12:55:37','',''),(2427,'1','307','1',1,'Retail Sale Id 2420',4440.00,0.00,0.00,6.00,660.00,'2023-02-14 13:06:13','',''),(2428,'1','307','1',1,'Retail Sale Id 2421',9250.00,0.00,0.00,12.50,1375.00,'2023-02-14 13:22:01','',''),(2429,'1','307','1',1,'Retail Sale Id 2422',9250.00,0.00,0.00,12.50,1375.00,'2023-02-14 13:23:28','',''),(2430,'1','307','1',1,'Retail Sale Id 2423',4447.40,0.00,0.00,6.01,661.10,'2023-02-14 13:44:56','',''),(2431,'1','307','1',1,'Retail Sale Id 2424',4447.40,0.00,0.00,6.01,661.10,'2023-02-14 13:59:26','',''),(2432,'1','307','1',1,'Retail Sale Id 2425',6497.20,0.00,0.00,8.78,965.80,'2023-02-14 14:04:13','',''),(2433,'1','307','1',1,'Retail Sale Id 2426',20400.00,0.00,0.00,30.00,1500.00,'2023-02-14 14:06:28','',''),(2434,'1','307','1',1,'Retail Sale Id 2427',1502.20,0.00,0.00,2.03,223.30,'2023-02-14 14:33:40','',''),(2435,'1','307','1',1,'Retail Sale Id 2428',2249.60,0.00,0.00,3.04,334.40,'2023-02-14 14:54:51','',''),(2436,'1','307','1',1,'Retail Sale Id 2429',6660.00,0.00,0.00,9.00,990.00,'2023-02-14 14:57:37','',''),(2437,'1','307','1',1,'Retail Sale Id 2430',2997.00,0.00,0.00,4.05,445.50,'2023-02-14 15:03:30','',''),(2438,'1','307','1',1,'Retail Sale Id 2431',2997.00,0.00,0.00,4.05,445.50,'2023-02-14 15:12:05','',''),(2439,'1','307','1',1,'Retail Sale Id 2433',3700.00,0.00,0.00,5.00,550.00,'2023-02-14 15:22:43','',''),(2440,'1','307','1',1,'Retail Sale Id 2434',9250.00,0.00,0.00,12.50,1375.00,'2023-02-14 15:25:24','',''),(2441,'1','307','1',1,'Retail Sale Id 2435',2220.00,0.00,0.00,3.00,330.00,'2023-02-14 15:26:44','',''),(2442,'1','307','1',1,'Retail Sale Id 2436',4447.40,0.00,0.00,6.01,661.10,'2023-02-14 15:32:58','',''),(2443,'1','307','1',1,'Retail Sale Id 2437',2220.00,0.00,0.00,3.00,330.00,'2023-02-14 15:34:29','',''),(2444,'1','307','1',1,'Retail Sale Id 2438',1998.00,0.00,0.00,2.70,297.00,'2023-02-14 15:42:05','',''),(2445,'1','307','1',1,'Retail Sale Id 2439',999.00,0.00,0.00,1.35,148.50,'2023-02-14 15:44:12','',''),(2446,'1','307','1',1,'Retail Sale Id 2440',44880.00,0.00,0.00,66.00,3300.00,'2023-02-14 15:47:53','',''),(2447,'1','307','1',1,'Retail Sale Id 2441',3700.00,0.00,0.00,5.00,550.00,'2023-02-14 15:58:51','',''),(2448,'1','307','1',1,'Retail Sale Id 2442',747.40,0.00,0.00,1.01,111.10,'2023-02-14 17:33:31','',''),(2449,'1','307','1',1,'Retail Sale Id 2443',1502.20,0.00,0.00,2.03,223.30,'2023-02-14 17:35:25','',''),(2450,'1','307','1',1,'Retail Sale Id 2444',2197.80,0.00,0.00,2.97,326.70,'2023-02-14 17:37:00','',''),(2451,'1','307','1',1,'Retail Sale Id 2445',2220.00,0.00,0.00,3.00,330.00,'2023-02-14 17:38:27','',''),(2452,'1','307','1',1,'Retail Sale Id 2446',2249.60,0.00,0.00,3.04,334.40,'2023-02-14 17:40:54','',''),(2453,'1','307','1',1,'Retail Sale Id 2447',1502.20,0.00,0.00,2.03,223.30,'2023-02-14 17:42:53','',''),(2454,'1','307','1',1,'Retail Sale Id 2448',799.20,0.00,0.00,1.08,118.80,'2023-02-14 17:44:39','',''),(2455,'1','307','1',1,'Retail Sale Id 2449',2249.60,0.00,0.00,3.04,334.40,'2023-02-14 18:02:44','',''),(2456,'1','307','1',1,'Retail Sale Id 2450',2249.60,0.00,0.00,3.04,334.40,'2023-02-14 18:08:08','',''),(2457,'1','307','1',1,'Retail Sale Id 2451',1502.20,0.00,0.00,2.03,223.30,'2023-02-14 18:11:56','',''),(2458,'1','307','1',1,'Retail Sale Id 2452',2997.00,0.00,0.00,4.05,445.50,'2023-02-14 18:20:15','',''),(2459,'1','307','1',1,'Retail Sale Id 2453',3700.00,0.00,0.00,5.00,550.00,'2023-02-14 18:28:56','',''),(2460,'1','307','1',1,'Retail Sale Id 2454',4447.40,0.00,0.00,6.01,661.10,'2023-02-14 18:30:57','',''),(2461,'1','307','1',1,'Retail Sale Id 2455',2249.60,0.00,0.00,3.04,334.40,'2023-02-14 18:34:03','',''),(2462,'1','307','1',1,'Retail Sale Id 2456',1502.20,0.00,0.00,2.03,223.30,'2023-02-14 18:36:45','',''),(2463,'1','307','1',1,'Retail Sale Id 2457',1998.00,0.00,0.00,2.70,297.00,'2023-02-14 18:38:17','',''),(2464,'1','307','1',1,'Retail Sale Id 2458',747.40,0.00,0.00,1.01,111.10,'2023-02-14 18:40:17','',''),(2465,'1','307','1',1,'Retail Sale Id 2459',1998.00,0.00,0.00,2.70,297.00,'2023-02-14 18:43:15','',''),(2466,'1','307','1',1,'Retail Sale Id 2459',2997.00,0.00,0.00,4.05,445.50,'2023-02-14 18:43:15','',''),(2467,'1','307','1',1,'Retail Sale Id 2460',740.00,0.00,0.00,1.00,110.00,'2023-02-14 18:44:40','',''),(2468,'1','307','1',1,'Retail Sale Id 2461',2960.00,0.00,0.00,4.00,440.00,'2023-02-14 18:53:51','',''),(2469,'1','307','1',1,'Retail Sale Id 2462',747.40,0.00,0.00,1.01,111.10,'2023-02-14 19:04:17','',''),(2470,'1','307','1',1,'Retail Sale Id 2463',740.00,0.00,0.00,1.00,110.00,'2023-02-14 19:06:10','',''),(2471,'1','307','1',1,'Retail Sale Id 2464',19720.00,0.00,0.00,29.00,1450.00,'2023-02-14 19:08:05','',''),(2472,'1','307','1',1,'Retail Sale Id 2465',2960.00,0.00,0.00,4.00,440.00,'2023-02-14 19:09:15','',''),(2473,'1','307','1',1,'Retail Sale Id 2466',1502.20,0.00,0.00,2.03,223.30,'2023-02-14 19:11:22','',''),(2474,'1','307','1',1,'Retail Sale Id 2467',2960.00,0.00,0.00,4.00,440.00,'2023-02-14 19:12:51','',''),(2475,'1','307','1',1,'Retail Sale Id 2468',3433.60,0.00,0.00,4.64,510.40,'2023-02-14 19:22:50','',''),(2476,'1','307','1',1,'Retail Sale Id 2469',9250.00,0.00,0.00,12.50,1375.00,'2023-02-15 07:45:17','',''),(2477,'1','307','1',1,'Retail Sale Id 2470',9250.00,0.00,0.00,12.50,1375.00,'2023-02-15 07:47:03','',''),(2478,'1','307','1',1,'Retail Sale Id 2471',4440.00,0.00,0.00,6.00,660.00,'2023-02-15 07:48:18','',''),(2479,'1','307','1',1,'Retail Sale Id 2472',1502.20,0.00,0.00,2.03,223.30,'2023-02-15 07:50:13','',''),(2480,'1','307','1',1,'Retail Sale Id 2473',2960.00,0.00,0.00,4.00,440.00,'2023-02-15 07:52:36','',''),(2481,'1','307','1',1,'Retail Sale Id 2474',4440.00,0.00,0.00,6.00,660.00,'2023-02-15 07:54:50','',''),(2482,'1','307','1',1,'Retail Sale Id 2475',9250.00,0.00,0.00,12.50,1375.00,'2023-02-15 08:25:46','',''),(2483,'1','307','1',1,'Retail Sale Id 2476',2220.00,0.00,0.00,3.00,330.00,'2023-02-15 08:33:23','',''),(2484,'1','307','1',1,'Retail Sale Id 2477',2220.00,0.00,0.00,3.00,330.00,'2023-02-15 08:36:11','',''),(2485,'1','307','1',1,'Retail Sale Id 2478',2220.00,0.00,0.00,3.00,330.00,'2023-02-15 08:39:11','',''),(2486,'1','307','1',1,'Retail Sale Id 2481',9250.00,0.00,0.00,12.50,1375.00,'2023-02-15 08:45:17','',''),(2487,'1','307','1',1,'Retail Sale Id 2482',7400.00,0.00,0.00,10.00,1100.00,'2023-02-15 08:48:15','',''),(2488,'1','307','1',1,'Retail Sale Id 2484',3700.00,0.00,0.00,5.00,550.00,'2023-02-15 08:51:05','',''),(2489,'1','307','1',1,'Retail Sale Id 2485',4499.20,0.00,0.00,6.08,668.80,'2023-02-15 09:32:41','',''),(2490,'1','307','1',1,'Retail Sale Id 2486',4499.20,0.00,0.00,6.08,668.80,'2023-02-15 09:33:49','',''),(2491,'1','307','1',1,'Retail Sale Id 2487',2220.00,0.00,0.00,3.00,330.00,'2023-02-15 09:35:19','',''),(2492,'1','307','1',1,'Retail Sale Id 2488',34000.00,0.00,0.00,50.00,2500.00,'2023-02-15 09:37:38','',''),(2493,'1','307','1',1,'Retail Sale Id 2489',2220.00,0.00,0.00,3.00,330.00,'2023-02-15 09:42:12','',''),(2494,'1','307','1',1,'Retail Sale Id 2490',68000.00,0.00,0.00,100.00,5000.00,'2023-02-15 10:33:42','',''),(2495,'1','307','1',1,'Retail Sale Id 2491',2220.00,0.00,0.00,3.00,330.00,'2023-02-15 10:35:28','',''),(2496,'1','307','1',1,'Retail Sale Id 2492',4440.00,0.00,0.00,6.00,660.00,'2023-02-15 11:09:30','',''),(2497,'1','307','1',1,'Retail Sale Id 2493',5920.00,0.00,0.00,8.00,880.00,'2023-02-15 11:25:56','',''),(2498,'1','307','1',1,'Retail Sale Id 2494',2960.00,0.00,0.00,4.00,440.00,'2023-02-15 11:33:28','',''),(2499,'1','307','1',1,'Retail Sale Id 2495',1480.00,0.00,0.00,2.00,220.00,'2023-02-15 12:31:31','',''),(2500,'1','307','1',1,'Retail Sale Id 2496',1502.20,0.00,0.00,2.03,223.30,'2023-02-15 12:39:45','',''),(2501,'1','307','1',1,'Retail Sale Id 2497',2249.60,0.00,0.00,3.04,334.40,'2023-02-15 12:49:53','',''),(2502,'1','307','1',1,'Retail Sale Id 2498',9250.00,0.00,0.00,12.50,1375.00,'2023-02-15 12:55:48','',''),(2503,'1','307','1',1,'Retail Sale Id 2499',3700.00,0.00,0.00,5.00,550.00,'2023-02-15 13:08:26','',''),(2504,'1','307','1',1,'Retail Sale Id 2500',9250.00,0.00,0.00,12.50,1375.00,'2023-02-15 13:41:08','',''),(2505,'1','307','1',1,'Retail Sale Id 2501',9250.00,0.00,0.00,12.50,1375.00,'2023-02-15 15:20:32','',''),(2506,'1','307','1',1,'Retail Sale Id 2502',1998.00,0.00,0.00,2.70,297.00,'2023-02-15 15:25:54','',''),(2507,'1','307','1',1,'Retail Sale Id 2503',1502.20,0.00,0.00,2.03,223.30,'2023-02-15 15:38:28','',''),(2508,'1','307','1',1,'Retail Sale Id 2504',9250.00,0.00,0.00,12.50,1375.00,'2023-02-15 15:40:22','',''),(2509,'1','307','1',1,'Retail Sale Id 2506',3700.00,0.00,0.00,5.00,550.00,'2023-02-15 15:57:53','',''),(2510,'1','307','1',1,'Retail Sale Id 2507',10878.00,0.00,0.00,14.70,1617.00,'2023-02-15 16:45:04','',''),(2511,'1','307','1',1,'Retail Sale Id 2508',740.00,0.00,0.00,1.00,110.00,'2023-02-15 16:59:35','',''),(2512,'1','307','1',1,'Retail Sale Id 2509',6660.00,0.00,0.00,9.00,990.00,'2023-02-15 17:01:14','',''),(2513,'1','307','1',1,'Retail Sale Id 2510',5202.20,0.00,0.00,7.03,773.30,'2023-02-15 17:02:43','',''),(2514,'1','307','1',1,'Retail Sale Id 2511',13690.00,0.00,0.00,18.50,2035.00,'2023-02-15 17:18:25','',''),(2515,'1','307','1',1,'Retail Sale Id 2512',4440.00,0.00,0.00,6.00,660.00,'2023-02-15 17:28:34','',''),(2516,'1','307','1',1,'Retail Sale Id 2513',4440.00,0.00,0.00,6.00,660.00,'2023-02-15 17:40:04','',''),(2517,'1','307','1',1,'Retail Sale Id 2514',2220.00,0.00,0.00,3.00,330.00,'2023-02-15 17:42:32','',''),(2518,'1','307','1',1,'Retail Sale Id 2515',2220.00,0.00,0.00,3.00,330.00,'2023-02-15 17:45:39','',''),(2519,'1','307','1',1,'Retail Sale Id 2517',2997.00,0.00,0.00,4.05,445.50,'2023-02-15 17:56:29','',''),(2520,'1','307','1',1,'Retail Sale Id 2518',1502.20,0.00,0.00,2.03,223.30,'2023-02-15 17:58:26','',''),(2521,'1','307','1',1,'Retail Sale Id 2519',4440.00,0.00,0.00,6.00,660.00,'2023-02-15 18:05:20','',''),(2522,'1','307','1',1,'Retail Sale Id 2520',3700.00,0.00,0.00,5.00,550.00,'2023-02-15 18:08:03','',''),(2523,'1','307','1',1,'Retail Sale Id 2521',4440.00,0.00,0.00,6.00,660.00,'2023-02-15 18:12:51','',''),(2524,'1','307','1',1,'Retail Sale Id 2522',1502.20,0.00,0.00,2.03,223.30,'2023-02-15 18:24:54','',''),(2525,'1','307','1',1,'Retail Sale Id 2523',2997.00,0.00,0.00,4.05,445.50,'2023-02-15 18:29:27','',''),(2526,'1','307','1',1,'Retail Sale Id 2524',2997.00,0.00,0.00,4.05,445.50,'2023-02-15 18:32:31','',''),(2527,'1','307','1',1,'Retail Sale Id 2525',4447.40,0.00,0.00,6.01,661.10,'2023-02-15 18:39:33','',''),(2528,'1','307','1',1,'Retail Sale Id 2527',1480.00,0.00,0.00,2.00,220.00,'2023-02-15 18:51:30','',''),(2529,'1','307','1',1,'Retail Sale Id 2529',4416.00,0.00,0.00,6.00,636.00,'2023-02-16 08:17:23','',''),(2530,'1','307','1',1,'Retail Sale Id 2531',4416.00,0.00,0.00,6.00,636.00,'2023-02-16 08:52:09','',''),(2531,'1','307','1',1,'Retail Sale Id 2532',1501.44,0.00,0.00,2.04,216.24,'2023-02-16 09:04:39','',''),(2532,'1','307','1',1,'Retail Sale Id 2533',7360.00,0.00,0.00,10.00,1060.00,'2023-02-16 09:34:49','',''),(2533,'1','307','1',1,'Retail Sale Id 2534',7360.00,0.00,0.00,10.00,1060.00,'2023-02-16 09:35:51','',''),(2534,'1','307','1',1,'Retail Sale Id 2535',2944.00,0.00,0.00,4.00,424.00,'2023-02-16 09:46:43','',''),(2535,'1','307','1',1,'Retail Sale Id 2536',102000.00,0.00,0.00,150.00,7500.00,'2023-02-16 09:55:44','',''),(2536,'1','307','1',1,'Retail Sale Id 2537',1472.00,0.00,0.00,2.00,212.00,'2023-02-16 10:08:13','',''),(2537,'1','307','1',1,'Retail Sale Id 2538',3996.48,0.00,0.00,5.43,575.58,'2023-02-16 10:49:41','',''),(2538,'1','307','1',1,'Retail Sale Id 2539',2200.64,0.00,0.00,2.99,316.94,'2023-02-16 11:02:51','',''),(2539,'1','307','1',1,'Retail Sale Id 2540',51000.00,0.00,0.00,75.00,3750.00,'2023-02-16 11:14:22','',''),(2540,'1','307','1',1,'Retail Sale Id 2541',3002.88,0.00,0.00,4.08,432.48,'2023-02-16 11:17:09','',''),(2541,'1','307','1',1,'Retail Sale Id 2542',2208.00,0.00,0.00,3.00,318.00,'2023-02-16 11:22:46','',''),(2542,'1','307','1',1,'Retail Sale Id 2543',4416.00,0.00,0.00,6.00,636.00,'2023-02-16 11:24:56','',''),(2543,'1','307','1',1,'Retail Sale Id 2544',5888.00,0.00,0.00,8.00,848.00,'2023-02-16 11:40:50','',''),(2544,'1','307','1',1,'Retail Sale Id 2545',27200.00,0.00,0.00,40.00,2000.00,'2023-02-16 11:58:25','',''),(2545,'1','307','1',1,'Retail Sale Id 2546',4416.00,0.00,0.00,6.00,636.00,'2023-02-16 12:12:02','',''),(2546,'1','307','1',1,'Retail Sale Id 2547',2502.40,0.00,0.00,3.40,360.40,'2023-02-16 12:21:28','',''),(2547,'1','307','1',1,'Retail Sale Id 2548',1501.44,0.00,0.00,2.04,216.24,'2023-02-16 13:46:49','',''),(2548,'1','307','1',1,'Retail Sale Id 2549',3702.08,0.00,0.00,5.03,533.18,'2023-02-16 14:11:23','',''),(2549,'1','307','1',1,'Retail Sale Id 2550',2944.00,0.00,0.00,4.00,424.00,'2023-02-16 14:15:27','',''),(2550,'1','307','1',1,'Retail Sale Id 2551',1501.44,0.00,0.00,2.04,216.24,'2023-02-16 14:22:34','',''),(2551,'1','307','1',1,'Retail Sale Id 2552',4416.00,0.00,0.00,6.00,636.00,'2023-02-16 14:40:16','',''),(2552,'1','307','1',1,'Retail Sale Id 2553',2208.00,0.00,0.00,3.00,318.00,'2023-02-16 14:46:41','',''),(2553,'1','307','1',1,'Retail Sale Id 2554',6697.60,0.00,0.00,9.10,964.60,'2023-02-16 14:59:58','',''),(2554,'1','307','1',1,'Retail Sale Id 2555',2208.00,0.00,0.00,3.00,318.00,'2023-02-16 15:14:20','',''),(2555,'1','307','1',1,'Retail Sale Id 2556',2951.36,0.00,0.00,4.01,425.06,'2023-02-16 15:34:30','',''),(2556,'1','307','1',1,'Retail Sale Id 2557',34000.00,0.00,0.00,50.00,2500.00,'2023-02-16 15:36:28','',''),(2557,'1','307','1',1,'Retail Sale Id 2558',3503.36,0.00,0.00,4.76,504.56,'2023-02-16 15:38:41','',''),(2558,'1','307','1',1,'Retail Sale Id 2559',4423.36,0.00,0.00,6.01,637.06,'2023-02-16 15:40:03','',''),(2559,'1','307','1',1,'Retail Sale Id 2560',2001.92,0.00,0.00,2.72,288.32,'2023-02-16 15:51:17','',''),(2560,'1','307','1',1,'Retail Sale Id 2561',2001.92,0.00,0.00,2.72,288.32,'2023-02-16 16:03:43','',''),(2561,'1','307','1',1,'Retail Sale Id 2562',4416.00,0.00,0.00,6.00,636.00,'2023-02-16 16:05:37','',''),(2562,'1','307','1',1,'Retail Sale Id 2563',2944.00,0.00,0.00,4.00,424.00,'2023-02-16 16:36:26','',''),(2563,'1','307','1',1,'Retail Sale Id 2564',1501.44,0.00,0.00,2.04,216.24,'2023-02-16 16:50:11','',''),(2564,'1','307','1',1,'Retail Sale Id 2565',2208.00,0.00,0.00,3.00,318.00,'2023-02-16 17:01:18','',''),(2565,'1','307','1',1,'Retail Sale Id 2566',1501.44,0.00,0.00,2.04,216.24,'2023-02-16 17:03:00','',''),(2566,'1','307','1',1,'Retail Sale Id 2567',1501.44,0.00,0.00,2.04,216.24,'2023-02-16 17:09:22','',''),(2567,'1','307','1',1,'Retail Sale Id 2568',68000.00,0.00,0.00,100.00,5000.00,'2023-02-16 17:10:25','',''),(2568,'1','307','1',1,'Retail Sale Id 2569',9597.44,0.00,0.00,13.04,1382.24,'2023-02-16 17:23:57','',''),(2569,'1','307','1',1,'Retail Sale Id 2570',2222.72,0.00,0.00,3.02,320.12,'2023-02-16 17:25:24','',''),(2570,'1','307','1',1,'Retail Sale Id 2571',1000.96,0.00,0.00,1.36,144.16,'2023-02-16 17:28:12','',''),(2571,'1','307','1',1,'Retail Sale Id 2572',2222.72,0.00,0.00,3.02,320.12,'2023-02-16 17:34:34','',''),(2572,'1','307','1',1,'Retail Sale Id 2573',2001.92,0.00,0.00,2.72,288.32,'2023-02-16 17:36:31','',''),(2573,'1','307','1',1,'Retail Sale Id 2574',1501.44,0.00,0.00,2.04,216.24,'2023-02-16 17:45:57','',''),(2574,'1','307','1',1,'Retail Sale Id 2574',2208.00,0.00,0.00,3.00,318.00,'2023-02-16 17:45:57','',''),(2575,'1','307','1',1,'Retail Sale Id 2575',1501.44,0.00,0.00,2.04,216.24,'2023-02-16 18:27:12','',''),(2576,'1','307','1',1,'Retail Sale Id 2576',750.72,0.00,0.00,1.02,108.12,'2023-02-16 18:37:56','',''),(2577,'1','307','1',1,'Retail Sale Id 2577',1501.44,0.00,0.00,2.04,216.24,'2023-02-16 18:49:06','',''),(2578,'1','307','1',1,'Retail Sale Id 2578',1000.96,0.00,0.00,1.36,144.16,'2023-02-16 18:51:02','',''),(2579,'1','307','1',1,'Retail Sale Id 2579',9200.00,0.00,0.00,12.50,1325.00,'2023-02-16 18:53:09','',''),(2580,'1','307','1',1,'Retail Sale Id 2580',3996.48,0.00,0.00,5.43,575.58,'2023-02-16 18:56:09','',''),(2581,'1','307','1',1,'Retail Sale Id 2581',9200.00,0.00,0.00,12.50,1325.00,'2023-02-16 18:57:16','',''),(2582,'1','307','1',1,'Retail Sale Id 2582',9200.00,0.00,0.00,12.50,1325.00,'2023-02-16 19:15:38','',''),(2583,'1','307','1',1,'Retail Sale Id 2583',1678.08,0.00,0.00,2.28,241.68,'2023-02-16 19:21:11','',''),(2584,'1','307','1',1,'Retail Sale Id 2584',4416.00,0.00,0.00,6.00,636.00,'2023-02-17 07:33:14','',''),(2585,'1','307','1',1,'Retail Sale Id 2585',2208.00,0.00,0.00,3.00,318.00,'2023-02-17 07:57:49','',''),(2586,'1','307','1',1,'Retail Sale Id 2586',9200.00,0.00,0.00,12.50,1325.00,'2023-02-17 08:15:09','',''),(2587,'1','307','1',1,'Retail Sale Id 2588',2951.36,0.00,0.00,4.01,425.06,'2023-02-17 08:23:21','',''),(2588,'1','307','1',1,'Retail Sale Id 2589',2001.92,0.00,0.00,2.72,288.32,'2023-02-17 08:25:12','',''),(2589,'1','307','1',1,'Retail Sale Id 2590',4416.00,0.00,0.00,6.00,636.00,'2023-02-17 08:27:58','',''),(2590,'1','307','1',1,'Retail Sale Id 2591',23997.20,0.00,0.00,35.29,1764.50,'2023-02-17 08:36:14','',''),(2591,'1','307','1',1,'Retail Sale Id 2592',1501.44,0.00,0.00,2.04,216.24,'2023-02-17 08:38:07','',''),(2592,'1','307','1',1,'Retail Sale Id 2593',20400.00,0.00,0.00,30.00,1500.00,'2023-02-17 09:01:56','',''),(2593,'1','307','1',1,'Retail Sale Id 2594',1472.00,0.00,0.00,2.00,212.00,'2023-02-17 09:04:21','',''),(2594,'1','307','1',1,'Retail Sale Id 2595',2208.00,0.00,0.00,3.00,318.00,'2023-02-17 09:25:06','',''),(2595,'1','307','1',1,'Retail Sale Id 2596',750.72,0.00,0.00,1.02,108.12,'2023-02-17 09:27:02','',''),(2596,'1','307','1',1,'Retail Sale Id 2597',4416.00,0.00,0.00,6.00,636.00,'2023-02-17 09:33:06','',''),(2597,'1','307','1',1,'Retail Sale Id 2598',14720.00,0.00,0.00,20.00,2120.00,'2023-02-17 09:46:44','',''),(2598,'1','307','1',1,'Retail Sale Id 2599',6999.36,0.00,0.00,9.51,1008.06,'2023-02-17 10:07:29','',''),(2599,'1','307','1',1,'Retail Sale Id 2600',4416.00,0.00,0.00,6.00,636.00,'2023-02-17 10:11:37','',''),(2600,'1','307','1',1,'Retail Sale Id 2602',2252.16,0.00,0.00,3.06,324.36,'2023-02-17 10:17:02','',''),(2601,'1','307','1',1,'Retail Sale Id 2603',4416.00,0.00,0.00,6.00,636.00,'2023-02-17 10:18:09','',''),(2602,'1','307','1',1,'Retail Sale Id 2604',1000.96,0.00,0.00,1.36,144.16,'2023-02-17 10:32:28','',''),(2603,'1','307','1',1,'Retail Sale Id 2605',1501.44,0.00,0.00,2.04,216.24,'2023-02-17 11:11:46','',''),(2604,'1','307','1',1,'Retail Sale Id 2606',1501.44,0.00,0.00,2.04,216.24,'2023-02-17 11:57:21','',''),(2605,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,1260000.00,2000.00,0.00,0.00,'2023-02-17 12:05:37','',''),(2606,'1','307',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,2000.00,0.00,'2023-02-17 12:07:47','',''),(2607,'1','307','1',1,'Received from bridging 12',0.00,0.00,2000.00,0.00,0.00,'2023-02-17 12:07:47','',''),(2608,'1','307','1',1,'Retail Sale Id 2608',3002.88,0.00,0.00,4.08,432.48,'2023-02-17 12:15:58','',''),(2609,'1','307','1',1,'Distributed to Operational lost for sales id:4',3975.30,0.00,0.00,6.31,0.00,'2023-02-17 12:36:20','',''),(2610,'1','307','1',1,'Retail Sale Id 2609',21549.20,0.00,0.00,31.69,1584.50,'2023-02-17 12:42:28','',''),(2611,'1','307','1',1,'Retail Sale Id 2611',12450.80,0.00,0.00,18.31,915.50,'2023-02-17 12:43:57','',''),(2612,'1','307','1',1,'Retail Sale Id 2612',4423.36,0.00,0.00,6.01,637.06,'2023-02-17 12:44:34','',''),(2613,'1','307','1',1,'Retail Sale Id 2613',11776.00,0.00,0.00,16.00,1696.00,'2023-02-17 12:47:44','',''),(2614,'1','307','1',1,'Retail Sale Id 2614',2208.00,0.00,0.00,3.00,318.00,'2023-02-17 13:16:41','',''),(2615,'1','307','1',1,'Retail Sale Id 2615',2208.00,0.00,0.00,3.00,318.00,'2023-02-17 13:18:58','',''),(2616,'1','307','1',1,'Retail Sale Id 2616',9200.00,0.00,0.00,12.50,1325.00,'2023-02-17 13:36:36','',''),(2617,'1','307','1',1,'Retail Sale Id 2617',11776.00,0.00,0.00,16.00,1696.00,'2023-02-17 13:53:49','',''),(2618,'1','307','1',1,'Retail Sale Id 2618',2222.72,0.00,0.00,3.02,320.12,'2023-02-17 14:07:33','',''),(2619,'1','307','1',1,'Retail Sale Id 2619',9200.00,0.00,0.00,12.50,1325.00,'2023-02-17 14:32:10','',''),(2620,'1','307','1',1,'Retail Sale Id 2620',2944.00,0.00,0.00,4.00,424.00,'2023-02-17 14:36:42','',''),(2621,'1','307','1',1,'Retail Sale Id 2621',2502.40,0.00,0.00,3.40,360.40,'2023-02-17 14:51:24','',''),(2622,'1','307','1',1,'Retail Sale Id 2622',2200.64,0.00,0.00,2.99,316.94,'2023-02-17 15:34:59','',''),(2623,'1','307','1',1,'Retail Sale Id 2623',7820.00,0.00,0.00,11.50,575.00,'2023-02-17 15:39:45','',''),(2624,'1','307','1',1,'Retail Sale Id 2624',4423.36,0.00,0.00,6.01,637.06,'2023-02-17 16:06:46','',''),(2625,'1','307','1',1,'Retail Sale Id 2625',1501.44,0.00,0.00,2.04,216.24,'2023-02-17 16:07:48','',''),(2626,'1','307','1',1,'Retail Sale Id 2626',2208.00,0.00,0.00,3.00,318.00,'2023-02-17 16:09:43','',''),(2627,'1','307','1',1,'Retail Sale Id 2627',4997.44,0.00,0.00,6.79,719.74,'2023-02-17 16:11:33','',''),(2628,'1','307','1',1,'Retail Sale Id 2628',1501.44,0.00,0.00,2.04,216.24,'2023-02-17 16:12:48','',''),(2629,'1','307','1',1,'Retail Sale Id 2629',4423.36,0.00,0.00,6.01,637.06,'2023-02-17 16:15:08','',''),(2630,'1','307','1',1,'Retail Sale Id 2630',802.24,0.00,0.00,1.09,115.54,'2023-02-17 16:25:33','',''),(2631,'1','307','1',1,'Retail Sale Id 2631',7360.00,0.00,0.00,10.00,1060.00,'2023-02-17 16:39:47','',''),(2632,'1','307','1',1,'Retail Sale Id 2632',4416.00,0.00,0.00,6.00,636.00,'2023-02-17 16:45:02','',''),(2633,'1','307','1',1,'Retail Sale Id 2633',4423.36,0.00,0.00,6.01,637.06,'2023-02-17 17:03:08','',''),(2634,'1','307','1',1,'Retail Sale Id 2634',5203.52,0.00,0.00,7.07,749.42,'2023-02-17 17:16:15','',''),(2635,'1','307','1',1,'Retail Sale Id 2635',4423.36,0.00,0.00,6.01,637.06,'2023-02-17 17:18:18','',''),(2636,'1','307','1',1,'Retail Sale Id 2636',2951.36,0.00,0.00,4.01,425.06,'2023-02-17 17:34:28','',''),(2637,'1','307','1',1,'Retail Sale Id 2637',2502.40,0.00,0.00,3.40,360.40,'2023-02-17 17:47:29','',''),(2638,'1','307','1',1,'Retail Sale Id 2638',2001.92,0.00,0.00,2.72,288.32,'2023-02-17 17:50:51','',''),(2639,'1','307','1',1,'Retail Sale Id 2639',4423.36,0.00,0.00,6.01,637.06,'2023-02-17 17:55:13','',''),(2640,'1','307','1',1,'Retail Sale Id 2640',2222.72,0.00,0.00,3.02,320.12,'2023-02-17 18:33:42','',''),(2641,'1','307','1',1,'Retail Sale Id 2641',680.00,0.00,0.00,1.00,50.00,'2023-02-17 19:06:21','',''),(2642,'1','307','1',1,'Retail Sale Id 2642',12953.60,0.00,0.00,17.60,1865.60,'2023-02-17 19:33:33','',''),(2643,'1','307','1',1,'Return of Retail Sale Id 2642',0.00,12953.60,17.60,0.00,-1865.60,'2023-02-17 19:44:14','',''),(2644,'1','307','1',1,'Retail Sale Id 2643',8000.32,0.00,0.00,10.87,1152.22,'2023-02-17 19:50:39','',''),(2645,'1','307','1',1,'Retail Sale Id 2644',4496.96,0.00,0.00,6.11,647.66,'2023-02-18 07:44:47','',''),(2646,'1','307','1',1,'Retail Sale Id 2645',4496.96,0.00,0.00,6.11,647.66,'2023-02-18 08:04:38','',''),(2647,'1','307','1',1,'Retail Sale Id 2646',1501.44,0.00,0.00,2.04,216.24,'2023-02-18 08:05:53','',''),(2648,'1','307','1',1,'Retail Sale Id 2648',1501.44,0.00,0.00,2.04,216.24,'2023-02-18 08:18:41','',''),(2649,'1','307','1',1,'Retail Sale Id 2649',897.92,0.00,0.00,1.22,129.32,'2023-02-18 08:25:14','',''),(2650,'1','307','1',1,'Retail Sale Id 2650',9200.00,0.00,0.00,12.50,1325.00,'2023-02-18 08:33:29','',''),(2651,'1','307','1',1,'Retail Sale Id 2651',27200.00,0.00,0.00,40.00,2000.00,'2023-02-18 08:34:56','',''),(2652,'1','307','1',1,'Retail Sale Id 2652',4416.00,0.00,0.00,6.00,636.00,'2023-02-18 09:00:46','',''),(2653,'1','307','1',1,'Retail Sale Id 2653',736.00,0.00,0.00,1.00,106.00,'2023-02-18 09:09:43','',''),(2654,'1','307','1',1,'Retail Sale Id 2654',1501.44,0.00,0.00,2.04,216.24,'2023-02-18 09:23:38','',''),(2655,'1','307','1',1,'Retail Sale Id 2655',1000.96,0.00,0.00,1.36,144.16,'2023-02-18 09:34:42','',''),(2656,'1','307','1',1,'Retail Sale Id 2656',1501.44,0.00,0.00,2.04,216.24,'2023-02-18 09:46:52','',''),(2657,'1','307','1',1,'Retail Sale Id 2657',4496.96,0.00,0.00,6.11,647.66,'2023-02-18 10:00:27','',''),(2658,'1','307','1',1,'Retail Sale Id 2658',2200.64,0.00,0.00,2.99,316.94,'2023-02-18 10:07:48','',''),(2659,'1','307','1',1,'Retail Sale Id 2659',2200.64,0.00,0.00,2.99,316.94,'2023-02-18 10:18:49','',''),(2660,'1','307','1',1,'Retail Sale Id 2660',1597.12,0.00,0.00,2.17,230.02,'2023-02-18 10:37:24','',''),(2661,'1','307','1',1,'Retail Sale Id 2661',9200.00,0.00,0.00,12.50,1325.00,'2023-02-18 10:43:02','',''),(2662,'1','307','1',1,'Retail Sale Id 2663',68000.00,0.00,0.00,100.00,5000.00,'2023-02-18 11:08:12','',''),(2663,'1','307','1',1,'Retail Sale Id 2664',2208.00,0.00,0.00,3.00,318.00,'2023-02-18 11:12:26','',''),(2664,'1','307','1',1,'Retail Sale Id 2665',4496.96,0.00,0.00,6.11,647.66,'2023-02-18 11:16:43','',''),(2665,'1','307','1',1,'Retail Sale Id 2666',3680.00,0.00,0.00,5.00,530.00,'2023-02-18 11:56:19','',''),(2666,'1','307','1',1,'Retail Sale Id 2667',2208.00,0.00,0.00,3.00,318.00,'2023-02-18 12:06:44','',''),(2667,'1','307','1',1,'Retail Sale Id 2668',34000.00,0.00,0.00,50.00,2500.00,'2023-02-18 12:16:24','',''),(2668,'1','307','1',1,'Retail Sale Id 2669',1501.44,0.00,0.00,2.04,216.24,'2023-02-18 13:22:03','',''),(2669,'1','307','1',1,'Retail Sale Id 2670',1501.44,0.00,0.00,2.04,216.24,'2023-02-18 13:43:58','',''),(2670,'1','307','1',1,'Retail Sale Id 2672',2951.36,0.00,0.00,4.01,425.06,'2023-02-18 13:51:32','',''),(2671,'1','307','1',1,'Retail Sale Id 2673',3002.88,0.00,0.00,4.08,432.48,'2023-02-18 14:03:54','',''),(2672,'1','307','1',1,'Retail Sale Id 2674',7360.00,0.00,0.00,10.00,1060.00,'2023-02-18 14:40:03','',''),(2673,'1','307','1',1,'Retail Sale Id 2675',2001.92,0.00,0.00,2.72,288.32,'2023-02-18 14:58:49','',''),(2674,'1','307','1',1,'Retail Sale Id 2676',3002.88,0.00,0.00,4.08,432.48,'2023-02-18 15:03:20','',''),(2675,'1','307','1',1,'Retail Sale Id 2677',1501.44,0.00,0.00,2.04,216.24,'2023-02-18 15:11:42','',''),(2676,'1','307','1',1,'Retail Sale Id 2678',4423.36,0.00,0.00,6.01,637.06,'2023-02-18 15:13:38','',''),(2677,'1','307','1',1,'Retail Sale Id 2679',4423.36,0.00,0.00,6.01,637.06,'2023-02-18 15:15:23','',''),(2678,'1','307','1',1,'Retail Sale Id 2680',4423.36,0.00,0.00,6.01,637.06,'2023-02-18 15:20:41','',''),(2679,'1','307','1',1,'Retail Sale Id 2681',3702.08,0.00,0.00,5.03,533.18,'2023-02-18 15:24:31','',''),(2680,'1','307','1',1,'Retail Sale Id 2682',1700.16,0.00,0.00,2.31,244.86,'2023-02-18 15:55:30','',''),(2681,'1','307','1',1,'Retail Sale Id 2683',1501.44,0.00,0.00,2.04,216.24,'2023-02-18 16:18:31','',''),(2682,'1','307','1',1,'Retail Sale Id 2684',2200.64,0.00,0.00,2.99,316.94,'2023-02-18 16:25:47','',''),(2683,'1','307','1',1,'Retail Sale Id 2685',8103.36,0.00,0.00,11.01,1167.06,'2023-02-18 16:28:57','',''),(2684,'1','307','1',1,'Retail Sale Id 2686',3002.88,0.00,0.00,4.08,432.48,'2023-02-18 16:34:48','',''),(2685,'1','307','1',1,'Retail Sale Id 2687',3650.56,0.00,0.00,4.96,525.76,'2023-02-18 16:52:41','',''),(2686,'1','307','1',1,'Retail Sale Id 2688',2208.00,0.00,0.00,3.00,318.00,'2023-02-18 16:54:16','',''),(2687,'1','307','1',1,'Retail Sale Id 2689',3702.08,0.00,0.00,5.03,533.18,'2023-02-18 16:58:55','',''),(2688,'1','307','1',1,'Retail Sale Id 2690',9200.00,0.00,0.00,12.50,1325.00,'2023-02-18 17:04:40','',''),(2689,'1','307','1',1,'Retail Sale Id 2692',4452.80,0.00,0.00,6.05,641.30,'2023-02-18 17:12:26','',''),(2690,'1','307','1',1,'Retail Sale Id 2693',4423.36,0.00,0.00,6.01,637.06,'2023-02-18 17:17:08','',''),(2691,'1','307','1',1,'Retail Sale Id 2694',1501.44,0.00,0.00,2.04,216.24,'2023-02-18 17:20:09','',''),(2692,'1','307','1',1,'Retail Sale Id 2695',1501.44,0.00,0.00,2.04,216.24,'2023-02-18 17:27:50','',''),(2693,'1','307','1',1,'Retail Sale Id 2696',3680.00,0.00,0.00,5.00,530.00,'2023-02-18 17:37:29','',''),(2694,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,1927800.00,3060.00,0.00,0.00,'2023-02-18 17:38:47','',''),(2695,'1','307','1',1,'Retail Sale Id 2697',2208.00,0.00,0.00,3.00,318.00,'2023-02-18 17:39:09','',''),(2696,'1','307',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,3060.00,0.00,'2023-02-18 17:40:45','',''),(2697,'1','307','1',1,'Received from bridging 13',0.00,0.00,3060.00,0.00,0.00,'2023-02-18 17:40:45','',''),(2698,'1','307','1',1,'Retail Sale Id 2698',2208.00,0.00,0.00,3.00,318.00,'2023-02-18 17:40:59','',''),(2699,'1','307','1',1,'Retail Sale Id 2699',1501.44,0.00,0.00,2.04,216.24,'2023-02-18 17:42:23','',''),(2700,'1','307','1',1,'Retail Sale Id 2700',2001.92,0.00,0.00,2.72,288.32,'2023-02-18 17:47:47','',''),(2701,'1','307','1',1,'Retail Sale Id 2701',2001.92,0.00,0.00,2.72,288.32,'2023-02-18 17:49:13','',''),(2702,'1','307','1',1,'Retail Sale Id 2702',4423.36,0.00,0.00,6.01,637.06,'2023-02-18 18:04:43','',''),(2703,'1','307','1',1,'Retail Sale Id 2703',11452.16,0.00,0.00,15.56,1649.36,'2023-02-18 18:07:31','',''),(2704,'1','307','1',1,'Retail Sale Id 2704',2951.36,0.00,0.00,4.01,425.06,'2023-02-18 18:10:33','',''),(2705,'1','307','1',1,'Retail Sale Id 2705',750.72,0.00,0.00,1.02,108.12,'2023-02-18 18:11:58','',''),(2706,'1','307','1',1,'Retail Sale Id 2706',3702.08,0.00,0.00,5.03,533.18,'2023-02-18 18:17:34','',''),(2707,'1','307','1',1,'Retail Sale Id 2707',4423.36,0.00,0.00,6.01,637.06,'2023-02-18 18:20:58','',''),(2708,'1','307','1',1,'Retail Sale Id 2708',2951.36,0.00,0.00,4.01,425.06,'2023-02-18 18:23:06','',''),(2709,'1','307','1',1,'Retail Sale Id 2709',6800.64,0.00,0.00,9.24,979.44,'2023-02-18 18:36:21','',''),(2710,'1','307','1',1,'Retail Sale Id 2710',4416.00,0.00,0.00,6.00,636.00,'2023-02-18 18:47:01','',''),(2711,'1','307','1',1,'Retail Sale Id 2711',3797.76,0.00,0.00,5.16,546.96,'2023-02-18 18:50:41','',''),(2712,'1','307','1',1,'Retail Sale Id 2712',2208.00,0.00,0.00,3.00,318.00,'2023-02-18 18:55:46','',''),(2713,'1','307','1',1,'Return of Retail Sale Id 2651',0.00,27200.00,40.00,0.00,-2000.00,'2023-02-18 19:27:01','',''),(2714,'1','307','1',1,'Retail Sale Id 2713',31280.00,0.00,0.00,46.00,2300.00,'2023-02-18 19:28:30','',''),(2715,'1','307','1',1,'Retail Sale Id 2714',5291.84,0.00,0.00,7.19,762.14,'2023-02-18 19:31:47','',''),(2716,'1','307','1',1,'Retail Sale Id 2715',1501.44,0.00,0.00,2.04,216.24,'2023-02-19 07:35:18','',''),(2717,'1','307','1',1,'Retail Sale Id 2716',9200.00,0.00,0.00,12.50,1325.00,'2023-02-19 07:38:04','',''),(2718,'1','307','1',1,'Retail Sale Id 2717',2200.64,0.00,0.00,2.99,316.94,'2023-02-19 07:41:50','',''),(2719,'1','307','1',1,'Retail Sale Id 2718',2252.16,0.00,0.00,3.06,324.36,'2023-02-19 07:42:53','',''),(2720,'1','307','1',1,'Retail Sale Id 2719',2208.00,0.00,0.00,3.00,318.00,'2023-02-19 07:44:47','',''),(2721,'1','307','1',1,'Retail Sale Id 2720',1501.44,0.00,0.00,2.04,216.24,'2023-02-19 07:46:03','',''),(2722,'1','307','1',1,'Retail Sale Id 2721',4416.00,0.00,0.00,6.00,636.00,'2023-02-19 07:50:10','',''),(2723,'1','307','1',1,'Retail Sale Id 2722',2208.00,0.00,0.00,3.00,318.00,'2023-02-19 08:05:09','',''),(2724,'1','307','1',1,'Retail Sale Id 2723',4416.00,0.00,0.00,6.00,636.00,'2023-02-19 08:11:48','',''),(2725,'1','307','1',1,'Retail Sale Id 2724',9200.00,0.00,0.00,12.50,1325.00,'2023-02-19 08:13:51','',''),(2726,'1','307','1',1,'Retail Sale Id 2725',2944.00,0.00,0.00,4.00,424.00,'2023-02-19 08:25:56','',''),(2727,'1','307','1',1,'Retail Sale Id 2726',3002.88,0.00,0.00,4.08,432.48,'2023-02-19 08:30:19','',''),(2728,'1','307','1',1,'Retail Sale Id 2727',4416.00,0.00,0.00,6.00,636.00,'2023-02-19 08:31:44','',''),(2729,'1','307','1',1,'Retail Sale Id 2728',4416.00,0.00,0.00,6.00,636.00,'2023-02-19 08:42:10','',''),(2730,'1','307','1',1,'Retail Sale Id 2730',1472.00,0.00,0.00,2.00,212.00,'2023-02-19 08:46:30','',''),(2731,'1','307','1',1,'Retail Sale Id 2731',4416.00,0.00,0.00,6.00,636.00,'2023-02-19 08:49:11','',''),(2732,'1','307','1',1,'Retail Sale Id 2733',5998.40,0.00,0.00,8.15,863.90,'2023-02-19 08:53:39','',''),(2733,'1','307','1',1,'Retail Sale Id 2734',2208.00,0.00,0.00,3.00,318.00,'2023-02-19 08:58:30','',''),(2734,'1','307','1',1,'Retail Sale Id 2735',3680.00,0.00,0.00,5.00,530.00,'2023-02-19 09:26:25','',''),(2735,'1','307','1',1,'Retail Sale Id 2736',4416.00,0.00,0.00,6.00,636.00,'2023-02-19 09:34:24','',''),(2736,'1','307','1',1,'Retail Sale Id 2737',4416.00,0.00,0.00,6.00,636.00,'2023-02-19 10:00:56','',''),(2737,'1','307','1',1,'Retail Sale Id 2738',2502.40,0.00,0.00,3.40,360.40,'2023-02-19 10:04:01','',''),(2738,'1','307','1',1,'Retail Sale Id 2739',68000.00,0.00,0.00,100.00,5000.00,'2023-02-19 10:32:24','',''),(2739,'1','307','1',1,'Retail Sale Id 2740',2252.16,0.00,0.00,3.06,324.36,'2023-02-19 10:35:17','',''),(2740,'1','307','1',1,'Retail Sale Id 2741',2944.00,0.00,0.00,4.00,424.00,'2023-02-19 10:36:08','',''),(2741,'1','307','1',1,'Retail Sale Id 2742',112200.00,0.00,0.00,165.00,8250.00,'2023-02-19 10:39:49','',''),(2742,'1','307','1',1,'Retail Sale Id 2744',6624.00,0.00,0.00,9.00,954.00,'2023-02-19 10:45:32','',''),(2743,'1','307','1',1,'Retail Sale Id 2745',4496.96,0.00,0.00,6.11,647.66,'2023-02-19 10:47:38','',''),(2744,'1','307','1',1,'Retail Sale Id 2746',34000.00,0.00,0.00,50.00,2500.00,'2023-02-19 10:51:44','',''),(2745,'1','307','1',1,'Retail Sale Id 2747',18400.00,0.00,0.00,25.00,2650.00,'2023-02-19 10:57:52','',''),(2746,'1','307','1',1,'Retail Sale Id 2748',750.72,0.00,0.00,1.02,108.12,'2023-02-19 10:59:31','',''),(2747,'1','307','1',1,'Retail Sale Id 2749',9200.00,0.00,0.00,12.50,1325.00,'2023-02-19 11:30:33','',''),(2748,'1','307','1',1,'Retail Sale Id 2750',2502.40,0.00,0.00,3.40,360.40,'2023-02-19 11:37:21','',''),(2749,'1','307','1',1,'Retail Sale Id 2751',2502.40,0.00,0.00,3.40,360.40,'2023-02-19 11:38:15','',''),(2750,'1','307','1',1,'Retail Sale Id 2752',4416.00,0.00,0.00,6.00,636.00,'2023-02-19 11:45:39','',''),(2751,'1','307','1',1,'Retail Sale Id 2753',1000.96,0.00,0.00,1.36,144.16,'2023-02-19 11:47:18','',''),(2752,'1','307','1',1,'Retail Sale Id 2754',4416.00,0.00,0.00,6.00,636.00,'2023-02-19 11:48:43','',''),(2753,'1','307','1',1,'Retail Sale Id 2755',2252.16,0.00,0.00,3.06,324.36,'2023-02-19 11:51:47','',''),(2754,'1','307','1',1,'Retail Sale Id 2756',1501.44,0.00,0.00,2.04,216.24,'2023-02-19 11:53:07','',''),(2755,'1','307','1',1,'Retail Sale Id 2757',3680.00,0.00,0.00,5.00,530.00,'2023-02-19 11:54:58','',''),(2756,'1','307','1',1,'Retail Sale Id 2758',2208.00,0.00,0.00,3.00,318.00,'2023-02-19 12:30:29','',''),(2757,'1','307','1',1,'Retail Sale Id 2759',2208.00,0.00,0.00,3.00,318.00,'2023-02-19 12:36:16','',''),(2758,'1','307','1',1,'Retail Sale Id 2760',68000.00,0.00,0.00,100.00,5000.00,'2023-02-19 12:42:10','',''),(2759,'1','307','1',1,'Retail Sale Id 2761',13623.36,0.00,0.00,18.51,1962.06,'2023-02-19 12:45:31','',''),(2760,'1','307','1',1,'Retail Sale Id 2762',2208.00,0.00,0.00,3.00,318.00,'2023-02-19 13:00:13','',''),(2761,'1','307','1',1,'Retail Sale Id 2763',736.00,0.00,0.00,1.00,106.00,'2023-02-19 13:05:39','',''),(2762,'1','307','1',1,'Retail Sale Id 2764',2208.00,0.00,0.00,3.00,318.00,'2023-02-19 13:33:48','',''),(2763,'1','307','1',1,'Retail Sale Id 2765',4423.36,0.00,0.00,6.01,637.06,'2023-02-19 13:35:47','',''),(2764,'1','307','1',1,'Retail Sale Id 2766',743.36,0.00,0.00,1.01,107.06,'2023-02-19 13:46:36','',''),(2765,'1','307','1',1,'Retail Sale Id 2767',2001.92,0.00,0.00,2.72,288.32,'2023-02-19 13:47:50','',''),(2766,'1','307','1',1,'Retail Sale Id 2768',750.72,0.00,0.00,1.02,108.12,'2023-02-19 14:20:17','',''),(2767,'1','307','1',1,'Retail Sale Id 2769',1000.96,0.00,0.00,1.36,144.16,'2023-02-19 14:36:00','',''),(2768,'1','307','1',1,'Retail Sale Id 2770',17001.60,0.00,0.00,23.10,2448.60,'2023-02-19 14:45:51','',''),(2769,'1','307','1',1,'Retail Sale Id 2771',4423.36,0.00,0.00,6.01,637.06,'2023-02-19 14:54:16','',''),(2770,'1','307','1',1,'Retail Sale Id 2772',4423.36,0.00,0.00,6.01,637.06,'2023-02-19 14:55:32','',''),(2771,'1','307','1',1,'Retail Sale Id 2773',1000.96,0.00,0.00,1.36,144.16,'2023-02-19 15:00:23','',''),(2772,'1','307','1',1,'Retail Sale Id 2774',4423.36,0.00,0.00,6.01,637.06,'2023-02-19 15:15:10','',''),(2773,'1','307','1',1,'Retail Sale Id 2775',1501.44,0.00,0.00,2.04,216.24,'2023-02-19 15:18:10','',''),(2774,'1','307','1',1,'Retail Sale Id 2776',2944.00,0.00,0.00,4.00,424.00,'2023-02-19 15:20:21','',''),(2775,'1','307','1',1,'Retail Sale Id 2777',1501.44,0.00,0.00,2.04,216.24,'2023-02-19 15:35:40','',''),(2776,'1','307','1',1,'Retail Sale Id 2778',3702.08,0.00,0.00,5.03,533.18,'2023-02-19 15:52:16','',''),(2777,'1','307','1',1,'Retail Sale Id 2779',34000.00,0.00,0.00,50.00,2500.00,'2023-02-19 15:59:31','',''),(2778,'1','307','1',1,'Retail Sale Id 2780',1501.44,0.00,0.00,2.04,216.24,'2023-02-19 16:17:34','',''),(2779,'1','307','1',1,'Retail Sale Id 2781',3002.88,0.00,0.00,4.08,432.48,'2023-02-19 16:49:22','',''),(2780,'1','307','1',1,'Retail Sale Id 2782',2208.00,0.00,0.00,3.00,318.00,'2023-02-19 16:50:27','',''),(2781,'1','307','1',1,'Retail Sale Id 2783',3680.00,0.00,0.00,5.00,530.00,'2023-02-19 16:52:07','',''),(2782,'1','307','1',1,'Retail Sale Id 2784',2208.00,0.00,0.00,3.00,318.00,'2023-02-19 16:58:29','',''),(2783,'1','307','1',1,'Retail Sale Id 2785',2502.40,0.00,0.00,3.40,360.40,'2023-02-19 17:04:09','',''),(2784,'1','307','1',1,'Retail Sale Id 2786',3680.00,0.00,0.00,5.00,530.00,'2023-02-19 17:07:47','',''),(2785,'1','307','1',1,'Retail Sale Id 2787',1501.44,0.00,0.00,2.04,216.24,'2023-02-19 17:26:36','',''),(2786,'1','307','1',1,'Retail Sale Id 2788',2944.00,0.00,0.00,4.00,424.00,'2023-02-19 17:28:07','',''),(2787,'1','307','1',1,'Retail Sale Id 2789',4423.36,0.00,0.00,6.01,637.06,'2023-02-19 17:33:14','',''),(2788,'1','307','1',1,'Retail Sale Id 2790',3702.08,0.00,0.00,5.03,533.18,'2023-02-19 17:36:08','',''),(2789,'1','307','1',1,'Retail Sale Id 2791',3002.88,0.00,0.00,4.08,432.48,'2023-02-19 17:38:30','',''),(2790,'1','307','1',1,'Retail Sale Id 2792',11040.00,0.00,0.00,15.00,1590.00,'2023-02-19 17:40:19','',''),(2791,'1','307','1',1,'Retail Sale Id 2793',9200.00,0.00,0.00,12.50,1325.00,'2023-02-19 17:54:51','',''),(2792,'1','307','1',1,'Retail Sale Id 2794',3002.88,0.00,0.00,4.08,432.48,'2023-02-19 17:56:30','',''),(2793,'1','307','1',1,'Retail Sale Id 2795',3996.48,0.00,0.00,5.43,575.58,'2023-02-19 18:06:48','',''),(2794,'1','307','1',1,'Retail Sale Id 2796',1000.96,0.00,0.00,1.36,144.16,'2023-02-19 18:08:33','',''),(2795,'1','307','1',1,'Retail Sale Id 2797',2502.40,0.00,0.00,3.40,360.40,'2023-02-19 18:15:24','',''),(2796,'1','307','1',1,'Retail Sale Id 2798',5998.40,0.00,0.00,8.15,863.90,'2023-02-19 18:24:59','',''),(2797,'1','307','1',1,'Retail Sale Id 2799',9200.00,0.00,0.00,12.50,1325.00,'2023-02-19 18:37:38','',''),(2798,'1','307','1',1,'Retail Sale Id 2800',4416.00,0.00,0.00,6.00,636.00,'2023-02-19 19:05:59','',''),(2799,'1','307','1',1,'Retail Sale Id 2801',2097.60,0.00,0.00,2.85,302.10,'2023-02-19 19:17:01','',''),(2800,'1','307','1',1,'Retail Sale Id 2802',3002.88,0.00,0.00,4.08,432.48,'2023-02-20 07:26:53','',''),(2801,'1','307','1',1,'Retail Sale Id 2803',3680.00,0.00,0.00,5.00,530.00,'2023-02-20 07:33:19','',''),(2802,'1','307','1',1,'Retail Sale Id 2804',9200.00,0.00,0.00,12.50,1325.00,'2023-02-20 07:37:13','',''),(2803,'1','307','1',1,'Retail Sale Id 2805',119000.00,0.00,0.00,175.00,8750.00,'2023-02-20 07:52:52','',''),(2804,'1','307','1',1,'Retail Sale Id 2806',2208.00,0.00,0.00,3.00,318.00,'2023-02-20 07:54:56','',''),(2805,'1','307','1',1,'Retail Sale Id 2807',4416.00,0.00,0.00,6.00,636.00,'2023-02-20 08:10:04','',''),(2806,'1','307','1',1,'Retail Sale Id 2808',8832.00,0.00,0.00,12.00,1272.00,'2023-02-20 08:21:28','',''),(2807,'1','307','1',1,'Retail Sale Id 2809',4416.00,0.00,0.00,6.00,636.00,'2023-02-20 08:23:42','',''),(2808,'1','307','1',1,'Retail Sale Id 2810',7360.00,0.00,0.00,10.00,1060.00,'2023-02-20 08:27:52','',''),(2809,'1','307','1',1,'Retail Sale Id 2811',136000.00,0.00,0.00,200.00,10000.00,'2023-02-20 08:46:47','',''),(2810,'1','307','1',1,'Retail Sale Id 2812',4496.96,0.00,0.00,6.11,647.66,'2023-02-20 09:15:29','',''),(2811,'1','307','1',1,'Retail Sale Id 2813',736.00,0.00,0.00,1.00,106.00,'2023-02-20 09:20:53','',''),(2812,'1','307','1',1,'Retail Sale Id 2814',9200.00,0.00,0.00,12.50,1325.00,'2023-02-20 09:24:48','',''),(2813,'1','307','1',1,'Retail Sale Id 2815',1501.44,0.00,0.00,2.04,216.24,'2023-02-20 09:30:03','',''),(2814,'1','307','1',1,'Retail Sale Id 2816',3680.00,0.00,0.00,5.00,530.00,'2023-02-20 09:40:18','',''),(2815,'1','307','1',1,'Retail Sale Id 2817',68000.00,0.00,0.00,100.00,5000.00,'2023-02-20 09:45:04','',''),(2816,'1','307','1',1,'Retail Sale Id 2818',1000.96,0.00,0.00,1.36,144.16,'2023-02-20 10:02:49','',''),(2817,'1','307','1',1,'Retail Sale Id 2819',2899.84,0.00,0.00,3.94,417.64,'2023-02-20 10:06:00','',''),(2818,'1','307','1',1,'Retail Sale Id 2820',1501.44,0.00,0.00,2.04,216.24,'2023-02-20 10:34:40','',''),(2819,'1','307','1',1,'Retail Sale Id 2821',2200.64,0.00,0.00,2.99,316.94,'2023-02-20 10:58:11','',''),(2820,'1','307','1',1,'Retail Sale Id 2822',34000.00,0.00,0.00,50.00,2500.00,'2023-02-20 11:22:42','',''),(2821,'1','307','1',1,'Retail Sale Id 2823',3002.88,0.00,0.00,4.08,432.48,'2023-02-20 11:42:33','',''),(2822,'1','307','1',1,'Retail Sale Id 2824',2252.16,0.00,0.00,3.06,324.36,'2023-02-20 11:47:10','',''),(2823,'1','307','1',1,'Retail Sale Id 2825',9200.00,0.00,0.00,12.50,1325.00,'2023-02-20 11:48:13','',''),(2824,'1','307','1',1,'Retail Sale Id 2826',4416.00,0.00,0.00,6.00,636.00,'2023-02-20 11:52:36','',''),(2825,'1','307','1',1,'Retail Sale Id 2828',2252.16,0.00,0.00,3.06,324.36,'2023-02-20 11:58:27','',''),(2826,'1','307','1',1,'Retail Sale Id 2830',8802.56,0.00,0.00,11.96,1267.76,'2023-02-20 12:00:21','',''),(2827,'1','307','1',1,'Retail Sale Id 2831',2222.72,0.00,0.00,3.02,320.12,'2023-02-20 12:07:41','',''),(2828,'1','307','1',1,'Retail Sale Id 2832',9200.00,0.00,0.00,12.50,1325.00,'2023-02-20 12:23:58','',''),(2829,'1','307','1',1,'Retail Sale Id 2833',2001.92,0.00,0.00,2.72,288.32,'2023-02-20 12:27:54','',''),(2830,'1','307','1',1,'Retail Sale Id 2834',4416.00,0.00,0.00,6.00,636.00,'2023-02-20 12:58:04','',''),(2831,'1','307','1',1,'Retail Sale Id 2835',2303.68,0.00,0.00,3.13,331.78,'2023-02-20 13:11:25','',''),(2832,'1','307','1',1,'Retail Sale Id 2836',4496.96,0.00,0.00,6.11,647.66,'2023-02-20 13:13:46','',''),(2833,'1','307','1',1,'Retail Sale Id 2837',2944.00,0.00,0.00,4.00,424.00,'2023-02-20 13:15:00','',''),(2834,'1','307','1',1,'Retail Sale Id 2838',4452.80,0.00,0.00,6.05,641.30,'2023-02-20 14:05:54','',''),(2835,'1','307','1',1,'Retail Sale Id 2839',9200.00,0.00,0.00,12.50,1325.00,'2023-02-20 14:08:50','',''),(2836,'1','307','1',1,'Retail Sale Id 2840',500.48,0.00,0.00,0.68,72.08,'2023-02-20 14:15:04','',''),(2837,'1','307','1',1,'Retail Sale Id 2841',2001.92,0.00,0.00,2.72,288.32,'2023-02-20 14:39:34','',''),(2838,'1','307','1',1,'Retail Sale Id 2842',4423.36,0.00,0.00,6.01,637.06,'2023-02-20 15:18:38','',''),(2839,'1','307','1',1,'Retail Sale Id 2843',4423.36,0.00,0.00,6.01,637.06,'2023-02-20 15:21:14','',''),(2840,'1','307','1',1,'Retail Sale Id 2844',34000.00,0.00,0.00,50.00,2500.00,'2023-02-20 15:28:59','',''),(2841,'1','307','1',1,'Retail Sale Id 2845',2208.00,0.00,0.00,3.00,318.00,'2023-02-20 15:36:21','',''),(2842,'1','307','1',1,'Retail Sale Id 2847',4423.36,0.00,0.00,6.01,637.06,'2023-02-20 15:44:01','',''),(2843,'1','307','1',1,'Retail Sale Id 2848',1501.44,0.00,0.00,2.04,216.24,'2023-02-20 16:19:08','',''),(2844,'1','307','1',1,'Retail Sale Id 2849',9200.00,0.00,0.00,12.50,1325.00,'2023-02-20 16:20:33','',''),(2845,'1','307','1',1,'Retail Sale Id 2850',4997.44,0.00,0.00,6.79,719.74,'2023-02-20 16:24:17','',''),(2846,'1','307','1',1,'Retail Sale Id 2851',1501.44,0.00,0.00,2.04,216.24,'2023-02-20 16:26:13','',''),(2847,'1','307','1',1,'Retail Sale Id 2852',3680.00,0.00,0.00,5.00,530.00,'2023-02-20 16:29:28','',''),(2848,'1','307','1',1,'Retail Sale Id 2853',1597.12,0.00,0.00,2.17,230.02,'2023-02-20 16:30:26','',''),(2849,'1','307','1',1,'Retail Sale Id 2854',7360.00,0.00,0.00,10.00,1060.00,'2023-02-20 16:40:29','',''),(2850,'1','307','1',1,'Retail Sale Id 2855',2208.00,0.00,0.00,3.00,318.00,'2023-02-20 16:43:15','',''),(2851,'1','307','1',1,'Retail Sale Id 2857',2208.00,0.00,0.00,3.00,318.00,'2023-02-20 16:48:24','',''),(2852,'1','307','1',1,'Retail Sale Id 2858',2208.00,0.00,0.00,3.00,318.00,'2023-02-20 16:54:00','',''),(2853,'1','307','1',1,'Retail Sale Id 2859',9200.00,0.00,0.00,12.50,1325.00,'2023-02-20 17:00:41','',''),(2854,'1','307','1',1,'Retail Sale Id 2860',500.48,0.00,0.00,0.68,72.08,'2023-02-20 17:03:27','',''),(2855,'1','307','1',1,'Retail Sale Id 2861',2208.00,0.00,0.00,3.00,318.00,'2023-02-20 17:04:34','',''),(2856,'1','307','1',1,'Retail Sale Id 2862',7360.00,0.00,0.00,10.00,1060.00,'2023-02-20 17:12:22','',''),(2857,'1','307','1',1,'Retail Sale Id 2863',3702.08,0.00,0.00,5.03,533.18,'2023-02-20 17:28:47','',''),(2858,'1','307','1',1,'Retail Sale Id 2864',13600.00,0.00,0.00,20.00,1000.00,'2023-02-20 17:37:29','',''),(2859,'1','307','1',1,'Retail Sale Id 2865',3702.08,0.00,0.00,5.03,533.18,'2023-02-20 17:39:34','',''),(2860,'1','307','1',1,'Retail Sale Id 2866',7360.00,0.00,0.00,10.00,1060.00,'2023-02-20 17:41:49','',''),(2861,'1','307','1',1,'Retail Sale Id 2867',4423.36,0.00,0.00,6.01,637.06,'2023-02-20 17:48:17','',''),(2862,'1','307','1',1,'Retail Sale Id 2868',4423.36,0.00,0.00,6.01,637.06,'2023-02-20 18:28:12','',''),(2863,'1','307','1',1,'Retail Sale Id 2869',7360.00,0.00,0.00,10.00,1060.00,'2023-02-20 18:29:39','',''),(2864,'1','307','1',1,'Retail Sale Id 2870',897.92,0.00,0.00,1.22,129.32,'2023-02-20 18:31:00','',''),(2865,'1','307','1',1,'Retail Sale Id 2871',18179.20,0.00,0.00,24.70,2618.20,'2023-02-20 18:34:50','',''),(2866,'1','307','1',1,'Retail Sale Id 2872',802.24,0.00,0.00,1.09,115.54,'2023-02-20 18:40:56','',''),(2867,'1','307','1',1,'Retail Sale Id 2873',2001.92,0.00,0.00,2.72,288.32,'2023-02-20 18:42:03','',''),(2868,'1','307','1',1,'Retail Sale Id 2874',3996.48,0.00,0.00,5.43,575.58,'2023-02-20 18:45:26','',''),(2869,'1','307','1',1,'Retail Sale Id 2875',4423.36,0.00,0.00,6.01,637.06,'2023-02-20 18:53:24','',''),(2870,'1','307','1',1,'Retail Sale Id 2876',3702.08,0.00,0.00,5.03,533.18,'2023-02-20 18:59:30','',''),(2871,'1','307','1',1,'Retail Sale Id 2877',1501.44,0.00,0.00,2.04,216.24,'2023-02-20 19:03:44','',''),(2872,'1','307','1',1,'Retail Sale Id 2878',9200.00,0.00,0.00,12.50,1325.00,'2023-02-20 19:08:01','',''),(2873,'1','307','1',1,'Retail Sale Id 2879',68000.00,0.00,0.00,100.00,5000.00,'2023-02-20 19:26:14','',''),(2874,'1','307','1',1,'Retail Sale Id 2880',3481.28,0.00,0.00,4.73,501.38,'2023-02-20 19:42:36','',''),(2875,'1','307','1',1,'Retail Sale Id 2881',3481.28,0.00,0.00,4.73,501.38,'2023-02-20 19:43:55','',''),(2876,'1','307','1',1,'Return of Retail Sale Id 2881',0.00,3481.28,4.73,0.00,-501.38,'2023-02-20 19:45:44','',''),(2877,'1','307','1',1,'Retail Sale Id 2882',4416.00,0.00,0.00,6.00,636.00,'2023-02-21 07:30:59','',''),(2878,'1','307','1',1,'Retail Sale Id 2883',2208.00,0.00,0.00,3.00,318.00,'2023-02-21 07:34:54','',''),(2879,'1','307','1',1,'Retail Sale Id 2884',9200.00,0.00,0.00,12.50,1325.00,'2023-02-21 07:36:35','',''),(2880,'1','307','1',1,'Retail Sale Id 2885',2208.00,0.00,0.00,3.00,318.00,'2023-02-21 07:37:27','',''),(2881,'1','307','1',1,'Retail Sale Id 2886',2208.00,0.00,0.00,3.00,318.00,'2023-02-21 07:44:56','',''),(2882,'1','307','1',1,'Retail Sale Id 2888',37400.00,0.00,0.00,55.00,2750.00,'2023-02-21 07:57:02','',''),(2883,'1','307','1',1,'Retail Sale Id 2889',750.72,0.00,0.00,1.02,108.12,'2023-02-21 08:00:56','',''),(2884,'1','307','1',1,'Retail Sale Id 2890',4423.36,0.00,0.00,6.01,637.06,'2023-02-21 08:03:18','',''),(2885,'1','307','1',1,'Retail Sale Id 2891',2944.00,0.00,0.00,4.00,424.00,'2023-02-21 08:06:41','',''),(2886,'1','307','1',1,'Retail Sale Id 2892',4416.00,0.00,0.00,6.00,636.00,'2023-02-21 08:24:11','',''),(2887,'1','307','1',1,'Retail Sale Id 2893',9200.00,0.00,0.00,12.50,1325.00,'2023-02-21 08:37:07','',''),(2888,'1','307','1',1,'Retail Sale Id 2894',2001.92,0.00,0.00,2.72,288.32,'2023-02-21 08:39:48','',''),(2889,'1','307','1',1,'Retail Sale Id 2895',2252.16,0.00,0.00,3.06,324.36,'2023-02-21 08:40:43','',''),(2890,'1','307','1',1,'Retail Sale Id 2896',7360.00,0.00,0.00,10.00,1060.00,'2023-02-21 08:49:37','',''),(2891,'1','307','1',1,'Retail Sale Id 2897',2200.64,0.00,0.00,2.99,316.94,'2023-02-21 09:21:21','',''),(2892,'1','307','1',1,'Retail Sale Id 2898',4997.44,0.00,0.00,6.79,719.74,'2023-02-21 09:22:29','',''),(2893,'1','307','1',1,'Retail Sale Id 2899',2208.00,0.00,0.00,3.00,318.00,'2023-02-21 09:23:51','',''),(2894,'1','307','1',1,'Retail Sale Id 2900',2208.00,0.00,0.00,3.00,318.00,'2023-02-21 09:26:00','',''),(2895,'1','307','1',1,'Retail Sale Id 2901',36040.00,0.00,0.00,53.00,2650.00,'2023-02-21 09:45:50','',''),(2896,'1','307','1',1,'Retail Sale Id 2902',2208.00,0.00,0.00,3.00,318.00,'2023-02-21 09:51:28','',''),(2897,'1','307','1',1,'Retail Sale Id 2903',1501.44,0.00,0.00,2.04,216.24,'2023-02-21 09:54:05','',''),(2898,'1','307','1',1,'Retail Sale Id 2904',2252.16,0.00,0.00,3.06,324.36,'2023-02-21 09:56:46','',''),(2899,'1','307','1',1,'Retail Sale Id 2905',2208.00,0.00,0.00,3.00,318.00,'2023-02-21 09:58:17','',''),(2900,'1','307','1',1,'Retail Sale Id 2906',4997.44,0.00,0.00,6.79,719.74,'2023-02-21 09:59:41','',''),(2901,'1','307','1',1,'Retail Sale Id 2907',34000.00,0.00,0.00,50.00,2500.00,'2023-02-21 10:29:20','',''),(2902,'1','307','1',1,'Retail Sale Id 2908',4416.00,0.00,0.00,6.00,636.00,'2023-02-21 10:31:51','',''),(2903,'1','307','1',1,'Retail Sale Id 2909',170000.00,0.00,0.00,250.00,12500.00,'2023-02-21 10:34:06','',''),(2904,'1','307','1',1,'Retail Sale Id 2910',4416.00,0.00,0.00,6.00,636.00,'2023-02-21 10:42:35','',''),(2905,'1','307','1',1,'Retail Sale Id 2911',750.72,0.00,0.00,1.02,108.12,'2023-02-21 10:43:54','',''),(2906,'1','307','1',1,'Retail Sale Id 2912',3002.88,0.00,0.00,4.08,432.48,'2023-02-21 10:44:53','',''),(2907,'1','307','1',1,'Retail Sale Id 2913',4401.28,0.00,0.00,5.98,633.88,'2023-02-21 10:47:43','',''),(2908,'1','307','1',1,'Retail Sale Id 2914',3680.00,0.00,0.00,5.00,530.00,'2023-02-21 10:49:51','',''),(2909,'1','307','1',1,'Retail Sale Id 2915',4416.00,0.00,0.00,6.00,636.00,'2023-02-21 11:17:06','',''),(2910,'1','307','1',1,'Retail Sale Id 2916',1501.44,0.00,0.00,2.04,216.24,'2023-02-21 11:18:17','',''),(2911,'1','307','1',1,'Retail Sale Id 2917',4416.00,0.00,0.00,6.00,636.00,'2023-02-21 11:19:34','',''),(2912,'1','307','1',1,'Retail Sale Id 2918',1501.44,0.00,0.00,2.04,216.24,'2023-02-21 11:21:01','',''),(2913,'1','307','1',1,'Retail Sale Id 2919',2001.92,0.00,0.00,2.72,288.32,'2023-02-21 11:56:34','',''),(2914,'1','307','1',1,'Retail Sale Id 2920',2944.00,0.00,0.00,4.00,424.00,'2023-02-21 12:01:04','',''),(2915,'1','307','1',1,'Retail Sale Id 2921',2208.00,0.00,0.00,3.00,318.00,'2023-02-21 12:06:47','',''),(2916,'1','307','1',1,'Retail Sale Id 2922',4496.96,0.00,0.00,6.11,647.66,'2023-02-21 12:19:46','',''),(2917,'1','307','1',1,'Retail Sale Id 2923',4416.00,0.00,0.00,6.00,636.00,'2023-02-21 12:33:57','',''),(2918,'1','307','1',1,'Retail Sale Id 2924',3996.48,0.00,0.00,5.43,575.58,'2023-02-21 13:22:19','',''),(2919,'1','307','1',1,'Retail Sale Id 2926',3002.88,0.00,0.00,4.08,432.48,'2023-02-21 13:37:21','',''),(2920,'1','307','1',1,'Retail Sale Id 2927',2001.92,0.00,0.00,2.72,288.32,'2023-02-21 14:14:03','',''),(2921,'1','307','1',1,'Retail Sale Id 2928',4423.36,0.00,0.00,6.01,637.06,'2023-02-21 14:15:38','',''),(2922,'1','307','1',1,'Retail Sale Id 2929',4423.36,0.00,0.00,6.01,637.06,'2023-02-21 14:17:23','',''),(2923,'1','307','1',1,'Retail Sale Id 2930',1501.44,0.00,0.00,2.04,216.24,'2023-02-21 14:18:56','',''),(2924,'1','307','1',1,'Retail Sale Id 2931',4997.44,0.00,0.00,6.79,719.74,'2023-02-21 14:39:21','',''),(2925,'1','307','1',1,'Retail Sale Id 2932',1597.12,0.00,0.00,2.17,230.02,'2023-02-21 14:44:31','',''),(2926,'1','307','1',1,'Retail Sale Id 2933',4452.80,0.00,0.00,6.05,641.30,'2023-02-21 14:55:29','',''),(2927,'1','307','1',1,'Retail Sale Id 2934',13623.36,0.00,0.00,18.51,1962.06,'2023-02-21 14:58:05','',''),(2928,'1','307','1',1,'Retail Sale Id 2935',4423.36,0.00,0.00,6.01,637.06,'2023-02-21 15:02:43','',''),(2929,'1','307','1',1,'Retail Sale Id 2936',2951.36,0.00,0.00,4.01,425.06,'2023-02-21 15:22:46','',''),(2930,'1','307','1',1,'Retail Sale Id 2937',8500.00,0.00,0.00,12.50,625.00,'2023-02-21 15:25:49','',''),(2931,'1','307','1',1,'Retail Sale Id 2938',4423.36,0.00,0.00,6.01,637.06,'2023-02-21 15:31:01','',''),(2932,'1','307','1',1,'Retail Sale Id 2939',2252.16,0.00,0.00,3.06,324.36,'2023-02-21 15:39:23','',''),(2933,'1','307','1',1,'Retail Sale Id 2940',2208.00,0.00,0.00,3.00,318.00,'2023-02-21 15:47:46','',''),(2934,'1','307','1',1,'Retail Sale Id 2941',12144.00,0.00,0.00,16.50,1749.00,'2023-02-21 16:22:42','',''),(2935,'1','307','1',1,'Retail Sale Id 2942',1501.44,0.00,0.00,2.04,216.24,'2023-02-21 16:23:53','',''),(2936,'1','307','1',1,'Retail Sale Id 2943',2208.00,0.00,0.00,3.00,318.00,'2023-02-21 16:29:23','',''),(2937,'1','307','1',1,'Retail Sale Id 2944',10701.44,0.00,0.00,14.54,1541.24,'2023-02-21 16:30:20','',''),(2938,'1','307','1',1,'Retail Sale Id 2945',1501.44,0.00,0.00,2.04,216.24,'2023-02-21 16:33:45','',''),(2939,'1','307','1',1,'Retail Sale Id 2946',3702.08,0.00,0.00,5.03,533.18,'2023-02-21 16:34:51','',''),(2940,'1','307','1',1,'Retail Sale Id 2947',1457.28,0.00,0.00,1.98,209.88,'2023-02-21 16:46:06','',''),(2941,'1','307','1',1,'Retail Sale Id 2948',9663.68,0.00,0.00,13.13,1391.78,'2023-02-21 16:58:55','',''),(2942,'1','307','1',1,'Retail Sale Id 2949',1501.44,0.00,0.00,2.04,216.24,'2023-02-21 17:01:06','',''),(2943,'1','307','1',1,'Retail Sale Id 2950',4423.36,0.00,0.00,6.01,637.06,'2023-02-21 17:05:17','',''),(2944,'1','307','1',1,'Retail Sale Id 2951',2252.16,0.00,0.00,3.06,324.36,'2023-02-21 17:07:38','',''),(2945,'1','307','1',1,'Retail Sale Id 2952',4423.36,0.00,0.00,6.01,637.06,'2023-02-21 17:09:19','',''),(2946,'1','307','1',1,'Retail Sale Id 2953',9200.00,0.00,0.00,12.50,1325.00,'2023-02-21 17:11:55','',''),(2947,'1','307','1',1,'Retail Sale Id 2954',3002.88,0.00,0.00,4.08,432.48,'2023-02-21 17:32:12','',''),(2948,'1','307','1',1,'Retail Sale Id 2955',3002.88,0.00,0.00,4.08,432.48,'2023-02-21 17:35:09','',''),(2949,'1','307','1',1,'Retail Sale Id 2956',4423.36,0.00,0.00,6.01,637.06,'2023-02-21 17:55:20','',''),(2950,'1','307','1',1,'Retail Sale Id 2957',2951.36,0.00,0.00,4.01,425.06,'2023-02-21 18:04:48','',''),(2951,'1','307','1',1,'Retail Sale Id 2958',3702.08,0.00,0.00,5.03,533.18,'2023-02-21 18:05:44','',''),(2952,'1','307','1',1,'Retail Sale Id 2959',1501.44,0.00,0.00,2.04,216.24,'2023-02-21 18:13:09','',''),(2953,'1','307','1',1,'Retail Sale Id 2960',5696.64,0.00,0.00,7.74,820.44,'2023-02-21 18:33:08','',''),(2954,'1','307','1',1,'Retail Sale Id 2961',12151.36,0.00,0.00,16.51,1750.06,'2023-02-21 18:37:33','',''),(2955,'1','307','1',1,'Retail Sale Id 2962',3208.96,0.00,0.00,4.36,462.16,'2023-02-21 19:13:08','',''),(2956,'1','307','1',1,'Retail Sale Id 2963',14197.44,0.00,0.00,19.29,2044.74,'2023-02-21 19:19:34','',''),(2957,'1','307','1',1,'Retail Sale Id 2964',2208.00,0.00,0.00,3.00,318.00,'2023-02-22 07:51:32','',''),(2958,'1','307','1',1,'Retail Sale Id 2965',2944.00,0.00,0.00,4.00,424.00,'2023-02-22 07:52:36','',''),(2959,'1','307','1',1,'Retail Sale Id 2966',4416.00,0.00,0.00,6.00,636.00,'2023-02-22 07:55:53','',''),(2960,'1','307','1',1,'Retail Sale Id 2967',2944.00,0.00,0.00,4.00,424.00,'2023-02-22 07:58:59','',''),(2961,'1','307','1',1,'Retail Sale Id 2968',3002.88,0.00,0.00,4.08,432.48,'2023-02-22 08:00:46','',''),(2962,'1','307','1',1,'Retail Sale Id 2969',9200.00,0.00,0.00,12.50,1325.00,'2023-02-22 08:04:17','',''),(2963,'1','307','1',1,'Retail Sale Id 2970',802.24,0.00,0.00,1.09,115.54,'2023-02-22 08:09:03','',''),(2964,'1','307','1',1,'Retail Sale Id 2971',3996.48,0.00,0.00,5.43,575.58,'2023-02-22 08:13:04','',''),(2965,'1','307','1',1,'Retail Sale Id 2972',3680.00,0.00,0.00,5.00,530.00,'2023-02-22 08:19:19','',''),(2966,'1','307','1',1,'Retail Sale Id 2973',9200.00,0.00,0.00,12.50,1325.00,'2023-02-22 08:31:24','',''),(2967,'1','307','1',1,'Retail Sale Id 2974',2001.92,0.00,0.00,2.72,288.32,'2023-02-22 08:35:13','',''),(2968,'1','307','1',1,'Retail Sale Id 2975',4416.00,0.00,0.00,6.00,636.00,'2023-02-22 08:36:46','',''),(2969,'1','307','1',1,'Retail Sale Id 2976',2208.00,0.00,0.00,3.00,318.00,'2023-02-22 08:40:04','',''),(2970,'1','307','1',1,'Retail Sale Id 2977',4416.00,0.00,0.00,6.00,636.00,'2023-02-22 08:47:29','',''),(2971,'1','307','1',1,'Retail Sale Id 2978',9200.00,0.00,0.00,12.50,1325.00,'2023-02-22 08:49:40','',''),(2972,'1','307','1',1,'Retail Sale Id 2979',8096.00,0.00,0.00,11.00,1166.00,'2023-02-22 08:51:41','',''),(2973,'1','307','1',1,'Retail Sale Id 2980',4416.00,0.00,0.00,6.00,636.00,'2023-02-22 08:53:29','',''),(2974,'1','307','1',1,'Retail Sale Id 2981',8832.00,0.00,0.00,12.00,1272.00,'2023-02-22 09:03:48','',''),(2975,'1','307','1',1,'Retail Sale Id 2982',1501.44,0.00,0.00,2.04,216.24,'2023-02-22 09:04:41','',''),(2976,'1','307','1',1,'Retail Sale Id 2983',1501.44,0.00,0.00,2.04,216.24,'2023-02-22 09:06:40','',''),(2977,'1','307','1',1,'Retail Sale Id 2984',750.72,0.00,0.00,1.02,108.12,'2023-02-22 09:13:37','',''),(2978,'1','307','1',1,'Retail Sale Id 2985',2208.00,0.00,0.00,3.00,318.00,'2023-02-22 09:14:48','',''),(2979,'1','307','1',1,'Retail Sale Id 2986',3680.00,0.00,0.00,5.00,530.00,'2023-02-22 09:20:27','',''),(2980,'1','307','1',1,'Retail Sale Id 2987',2001.92,0.00,0.00,2.72,288.32,'2023-02-22 09:22:11','',''),(2981,'1','307','1',1,'Retail Sale Id 2988',4416.00,0.00,0.00,6.00,636.00,'2023-02-22 09:24:09','',''),(2982,'1','307','1',1,'Retail Sale Id 2989',1472.00,0.00,0.00,2.00,212.00,'2023-02-22 09:30:12','',''),(2983,'1','307','1',1,'Retail Sale Id 2990',3002.88,0.00,0.00,4.08,432.48,'2023-02-22 09:37:11','',''),(2984,'1','307','1',1,'Retail Sale Id 2991',4416.00,0.00,0.00,6.00,636.00,'2023-02-22 09:50:29','',''),(2985,'1','307','1',1,'Retail Sale Id 2992',2944.00,0.00,0.00,4.00,424.00,'2023-02-22 09:55:34','',''),(2986,'1','307','1',1,'Retail Sale Id 2993',68000.00,0.00,0.00,100.00,5000.00,'2023-02-22 10:17:32','',''),(2987,'1','307','1',1,'Retail Sale Id 2994',34000.00,0.00,0.00,50.00,2500.00,'2023-02-22 10:23:31','',''),(2988,'1','307','1',1,'Retail Sale Id 2995',2303.68,0.00,0.00,3.13,331.78,'2023-02-22 10:25:15','',''),(2989,'1','307','1',1,'Retail Sale Id 2996',4416.00,0.00,0.00,6.00,636.00,'2023-02-22 10:41:09','',''),(2990,'1','307','1',1,'Retail Sale Id 2997',4416.00,0.00,0.00,6.00,636.00,'2023-02-22 10:48:04','',''),(2991,'1','307','1',1,'Retail Sale Id 2998',2208.00,0.00,0.00,3.00,318.00,'2023-02-22 10:56:11','',''),(2992,'1','307','1',1,'Retail Sale Id 2999',34000.00,0.00,0.00,50.00,2500.00,'2023-02-22 11:03:40','',''),(2993,'1','307','1',1,'Retail Sale Id 3000',2502.40,0.00,0.00,3.40,360.40,'2023-02-22 11:29:33','',''),(2994,'1','307','1',1,'Retail Sale Id 3001',4416.00,0.00,0.00,6.00,636.00,'2023-02-22 11:36:47','',''),(2995,'1','307','1',1,'Retail Sale Id 3002',4496.96,0.00,0.00,6.11,647.66,'2023-02-22 11:39:38','',''),(2996,'1','307','1',1,'Retail Sale Id 3003',2303.68,0.00,0.00,3.13,331.78,'2023-02-22 11:46:54','',''),(2997,'1','307','1',1,'Retail Sale Id 3004',9200.00,0.00,0.00,12.50,1325.00,'2023-02-22 11:51:10','',''),(2998,'1','307','1',1,'Retail Sale Id 3005',9200.00,0.00,0.00,12.50,1325.00,'2023-02-22 11:55:14','',''),(2999,'1','307','1',1,'Retail Sale Id 3006',2208.00,0.00,0.00,3.00,318.00,'2023-02-22 11:58:28','',''),(3000,'1','307','1',1,'Retail Sale Id 3007',2208.00,0.00,0.00,3.00,318.00,'2023-02-22 11:59:22','',''),(3001,'1','307','1',1,'Retail Sale Id 3008',2208.00,0.00,0.00,3.00,318.00,'2023-02-22 12:05:37','',''),(3002,'1','307','1',1,'Retail Sale Id 3009',2208.00,0.00,0.00,3.00,318.00,'2023-02-22 12:09:53','',''),(3003,'1','307','1',1,'Retail Sale Id 3010',34000.00,0.00,0.00,50.00,2500.00,'2023-02-22 12:26:29','',''),(3004,'1','307','1',1,'Retail Sale Id 3011',51000.00,0.00,0.00,75.00,3750.00,'2023-02-22 12:35:24','',''),(3005,'1','307','1',1,'Retail Sale Id 3012',4416.00,0.00,0.00,6.00,636.00,'2023-02-22 12:49:43','',''),(3006,'1','307','1',1,'Retail Sale Id 3013',2208.00,0.00,0.00,3.00,318.00,'2023-02-22 12:51:41','',''),(3007,'1','307','1',1,'Retail Sale Id 3014',4416.00,0.00,0.00,6.00,636.00,'2023-02-22 12:53:50','',''),(3008,'1','307','1',1,'Retail Sale Id 3015',3996.48,0.00,0.00,5.43,575.58,'2023-02-22 12:55:41','',''),(3009,'1','307','1',1,'Retail Sale Id 3016',2252.16,0.00,0.00,3.06,324.36,'2023-02-22 13:52:02','',''),(3010,'1','307','1',1,'Retail Sale Id 3017',4423.36,0.00,0.00,6.01,637.06,'2023-02-22 13:53:39','',''),(3011,'1','307','1',1,'Retail Sale Id 3018',2208.00,0.00,0.00,3.00,318.00,'2023-02-22 13:54:52','',''),(3012,'1','307','1',1,'Retail Sale Id 3019',3702.08,0.00,0.00,5.03,533.18,'2023-02-22 13:56:55','',''),(3013,'1','307','1',1,'Retail Sale Id 3020',4423.36,0.00,0.00,6.01,637.06,'2023-02-22 14:26:22','',''),(3014,'1','307','1',1,'Retail Sale Id 3021',1501.44,0.00,0.00,2.04,216.24,'2023-02-22 14:32:32','',''),(3015,'1','307','1',1,'Retail Sale Id 3022',1501.44,0.00,0.00,2.04,216.24,'2023-02-22 14:46:01','',''),(3016,'1','307','1',1,'Retail Sale Id 3023',4423.36,0.00,0.00,6.01,637.06,'2023-02-22 14:47:12','',''),(3017,'1','307','1',1,'Retail Sale Id 3024',4423.36,0.00,0.00,6.01,637.06,'2023-02-22 15:14:10','',''),(3018,'1','307','1',1,'Retail Sale Id 3025',4423.36,0.00,0.00,6.01,637.06,'2023-02-22 15:15:19','',''),(3019,'1','307','1',1,'Retail Sale Id 3026',2208.00,0.00,0.00,3.00,318.00,'2023-02-22 15:20:11','',''),(3020,'1','307','1',1,'Retail Sale Id 3027',3503.36,0.00,0.00,4.76,504.56,'2023-02-22 16:02:41','',''),(3021,'1','307','1',1,'Retail Sale Id 3028',9200.00,0.00,0.00,12.50,1325.00,'2023-02-22 16:23:54','',''),(3022,'1','307','1',1,'Retail Sale Id 3029',2208.00,0.00,0.00,3.00,318.00,'2023-02-22 16:25:11','',''),(3023,'1','307','1',1,'Retail Sale Id 3030',4423.36,0.00,0.00,6.01,637.06,'2023-02-22 16:34:14','',''),(3024,'1','307','1',1,'Retail Sale Id 3031',3702.08,0.00,0.00,5.03,533.18,'2023-02-22 16:39:04','',''),(3025,'1','307','1',1,'Retail Sale Id 3032',2208.00,0.00,0.00,3.00,318.00,'2023-02-22 16:55:50','',''),(3026,'1','307','1',1,'Retail Sale Id 3033',1000.96,0.00,0.00,1.36,144.16,'2023-02-22 16:56:55','',''),(3027,'1','307','1',1,'Retail Sale Id 3035',750.72,0.00,0.00,1.02,108.12,'2023-02-22 16:58:23','',''),(3028,'1','307','1',1,'Retail Sale Id 3036',2222.72,0.00,0.00,3.02,320.12,'2023-02-22 17:28:40','',''),(3029,'1','307','1',1,'Retail Sale Id 3037',2001.92,0.00,0.00,2.72,288.32,'2023-02-22 17:38:11','',''),(3030,'1','307','1',1,'Retail Sale Id 3038',750.72,0.00,0.00,1.02,108.12,'2023-02-22 17:53:50','',''),(3031,'1','307','1',1,'Retail Sale Id 3039',3680.00,0.00,0.00,5.00,530.00,'2023-02-22 18:27:04','',''),(3032,'1','307','1',1,'Retail Sale Id 3040',736.00,0.00,0.00,1.00,106.00,'2023-02-22 18:30:52','',''),(3033,'1','307','1',1,'Retail Sale Id 3041',397.44,0.00,0.00,0.54,57.24,'2023-02-22 18:34:11','',''),(3034,'1','307','1',1,'Retail Sale Id 3042',9200.00,0.00,0.00,12.50,1325.00,'2023-02-22 18:42:18','',''),(3035,'1','307','1',1,'Retail Sale Id 3043',12850.56,0.00,0.00,17.46,1850.76,'2023-02-22 19:09:47','',''),(3036,'1','307','1',1,'Retail Sale Id 3044',7676.48,0.00,0.00,10.43,1105.58,'2023-02-22 19:11:32','',''),(3037,'1','307','1',1,'Retail Sale Id 3045',1472.00,0.00,0.00,2.00,212.00,'2023-02-23 07:24:10','',''),(3038,'1','307','1',1,'Retail Sale Id 3046',3002.88,0.00,0.00,4.08,432.48,'2023-02-23 07:25:13','',''),(3039,'1','307','1',1,'Retail Sale Id 3047',9200.00,0.00,0.00,12.50,1325.00,'2023-02-23 07:28:09','',''),(3040,'1','307','1',1,'Retail Sale Id 3048',1472.00,0.00,0.00,2.00,212.00,'2023-02-23 07:34:16','',''),(3041,'1','307','1',1,'Retail Sale Id 3049',1501.44,0.00,0.00,2.04,216.24,'2023-02-23 07:36:59','',''),(3042,'1','307','1',1,'Retail Sale Id 3050',736.00,0.00,0.00,1.00,106.00,'2023-02-23 07:38:08','',''),(3043,'1','307','1',1,'Retail Sale Id 3051',1501.44,0.00,0.00,2.04,216.24,'2023-02-23 07:40:29','',''),(3044,'1','307','1',1,'Retail Sale Id 3052',3680.00,0.00,0.00,5.00,530.00,'2023-02-23 08:09:20','',''),(3045,'1','307','1',1,'Retail Sale Id 3053',4416.00,0.00,0.00,6.00,636.00,'2023-02-23 08:11:26','',''),(3046,'1','307','1',1,'Retail Sale Id 3054',3702.08,0.00,0.00,5.03,533.18,'2023-02-23 08:19:29','',''),(3047,'1','307','1',1,'Retail Sale Id 3055',9200.00,0.00,0.00,12.50,1325.00,'2023-02-23 08:25:19','',''),(3048,'1','307','1',1,'Retail Sale Id 3056',2208.00,0.00,0.00,3.00,318.00,'2023-02-23 08:34:10','',''),(3049,'1','307','1',1,'Retail Sale Id 3057',9200.00,0.00,0.00,12.50,1325.00,'2023-02-23 08:36:27','',''),(3050,'1','307','1',1,'Retail Sale Id 3058',2208.00,0.00,0.00,3.00,318.00,'2023-02-23 08:37:51','',''),(3051,'1','307','1',1,'Retail Sale Id 3059',4416.00,0.00,0.00,6.00,636.00,'2023-02-23 08:39:29','',''),(3052,'1','307','1',1,'Retail Sale Id 3060',736.00,0.00,0.00,1.00,106.00,'2023-02-23 08:40:52','',''),(3053,'1','307','1',1,'Retail Sale Id 3061',1501.44,0.00,0.00,2.04,216.24,'2023-02-23 08:43:13','',''),(3054,'1','307','1',1,'Retail Sale Id 3062',4416.00,0.00,0.00,6.00,636.00,'2023-02-23 08:49:30','',''),(3055,'1','307','1',1,'Retail Sale Id 3063',2222.72,0.00,0.00,3.02,320.12,'2023-02-23 08:52:58','',''),(3056,'1','307','1',1,'Retail Sale Id 3064',2208.00,0.00,0.00,3.00,318.00,'2023-02-23 08:55:13','',''),(3057,'1','307','1',1,'Retail Sale Id 3065',2208.00,0.00,0.00,3.00,318.00,'2023-02-23 08:57:28','',''),(3058,'1','307','1',1,'Retail Sale Id 3067',34000.00,0.00,0.00,50.00,2500.00,'2023-02-23 08:59:04','',''),(3059,'1','307','1',1,'Retail Sale Id 3068',736.00,0.00,0.00,1.00,106.00,'2023-02-23 09:00:49','',''),(3060,'1','307','1',1,'Retail Sale Id 3069',2097.60,0.00,0.00,2.85,302.10,'2023-02-23 09:11:39','',''),(3061,'1','307','1',1,'Retail Sale Id 3070',2944.00,0.00,0.00,4.00,424.00,'2023-02-23 09:14:59','',''),(3062,'1','307','1',1,'Retail Sale Id 3071',2208.00,0.00,0.00,3.00,318.00,'2023-02-23 09:16:34','',''),(3063,'1','307','1',1,'Retail Sale Id 3072',2208.00,0.00,0.00,3.00,318.00,'2023-02-23 09:18:19','',''),(3064,'1','307','1',1,'Retail Sale Id 3073',2001.92,0.00,0.00,2.72,288.32,'2023-02-23 09:19:26','',''),(3065,'1','307','1',1,'Retail Sale Id 3074',3680.00,0.00,0.00,5.00,530.00,'2023-02-23 09:24:14','',''),(3066,'1','307','1',1,'Retail Sale Id 3075',68000.00,0.00,0.00,100.00,5000.00,'2023-02-23 09:32:19','',''),(3067,'1','307','1',1,'Retail Sale Id 3076',30001.60,0.00,0.00,44.12,2206.00,'2023-02-23 09:36:47','',''),(3068,'1','307','1',1,'Retail Sale Id 3077',1501.44,0.00,0.00,2.04,216.24,'2023-02-23 09:38:27','',''),(3069,'1','307','1',1,'Retail Sale Id 3078',2001.92,0.00,0.00,2.72,288.32,'2023-02-23 09:41:07','',''),(3070,'1','307','1',1,'Retail Sale Id 3079',9200.00,0.00,0.00,12.50,1325.00,'2023-02-23 09:48:12','',''),(3071,'1','307','1',1,'Retail Sale Id 3081',3680.00,0.00,0.00,5.00,530.00,'2023-02-23 09:50:50','',''),(3072,'1','307','1',1,'Retail Sale Id 3082',2200.64,0.00,0.00,2.99,316.94,'2023-02-23 09:58:00','',''),(3073,'1','307','1',1,'Retail Sale Id 3084',2208.00,0.00,0.00,3.00,318.00,'2023-02-23 10:02:44','',''),(3074,'1','307','1',1,'Retail Sale Id 3085',9200.00,0.00,0.00,12.50,1325.00,'2023-02-23 10:38:55','',''),(3075,'1','307','1',1,'Retail Sale Id 3086',4416.00,0.00,0.00,6.00,636.00,'2023-02-23 10:40:36','',''),(3076,'1','307','1',1,'Retail Sale Id 3087',2944.00,0.00,0.00,4.00,424.00,'2023-02-23 10:54:33','',''),(3077,'1','307','1',1,'Retail Sale Id 3088',4452.80,0.00,0.00,6.05,641.30,'2023-02-23 10:56:54','',''),(3078,'1','307','1',1,'Retail Sale Id 3089',4997.44,0.00,0.00,6.79,719.74,'2023-02-23 10:58:06','',''),(3079,'1','307','1',1,'Retail Sale Id 3090',1000.96,0.00,0.00,1.36,144.16,'2023-02-23 11:07:47','',''),(3080,'1','307','1',1,'Retail Sale Id 3091',4496.96,0.00,0.00,6.11,647.66,'2023-02-23 11:35:48','',''),(3081,'1','307','1',1,'Retail Sale Id 3092',4496.96,0.00,0.00,6.11,647.66,'2023-02-23 11:56:56','',''),(3082,'1','307','1',1,'Retail Sale Id 3093',4416.00,0.00,0.00,6.00,636.00,'2023-02-23 12:08:26','',''),(3083,'1','307','1',1,'Retail Sale Id 3094',1472.00,0.00,0.00,2.00,212.00,'2023-02-23 12:26:31','',''),(3084,'1','307','1',1,'Retail Sale Id 3095',34000.00,0.00,0.00,50.00,2500.00,'2023-02-23 12:27:42','',''),(3085,'1','307','1',1,'Retail Sale Id 3096',3680.00,0.00,0.00,5.00,530.00,'2023-02-23 12:32:19','',''),(3086,'1','307','1',1,'Retail Sale Id 3097',3002.88,0.00,0.00,4.08,432.48,'2023-02-23 12:48:25','',''),(3087,'1','307','1',1,'Retail Sale Id 3098',6624.00,0.00,0.00,9.00,954.00,'2023-02-23 13:00:49','',''),(3088,'1','307','1',1,'Retail Sale Id 3099',2208.00,0.00,0.00,3.00,318.00,'2023-02-23 13:01:41','',''),(3089,'1','307','1',1,'Retail Sale Id 3100',2208.00,0.00,0.00,3.00,318.00,'2023-02-23 13:23:06','',''),(3090,'1','307','1',1,'Retail Sale Id 3101',1472.00,0.00,0.00,2.00,212.00,'2023-02-23 13:30:50','',''),(3091,'1','307','1',1,'Retail Sale Id 3102',3002.88,0.00,0.00,4.08,432.48,'2023-02-23 13:48:03','',''),(3092,'1','307','1',1,'Retail Sale Id 3103',2200.64,0.00,0.00,2.99,316.94,'2023-02-23 13:57:48','',''),(3093,'1','307','1',1,'Retail Sale Id 3104',1501.44,0.00,0.00,2.04,216.24,'2023-02-23 14:11:02','',''),(3094,'1','307','1',1,'Retail Sale Id 3105',4416.00,0.00,0.00,6.00,636.00,'2023-02-23 14:12:34','',''),(3095,'1','307','1',1,'Retail Sale Id 3106',4452.80,0.00,0.00,6.05,641.30,'2023-02-23 14:33:09','',''),(3096,'1','307','1',1,'Retail Sale Id 3107',18400.00,0.00,0.00,25.00,2650.00,'2023-02-23 14:37:09','',''),(3097,'1','307','1',1,'Retail Sale Id 3108',4423.36,0.00,0.00,6.01,637.06,'2023-02-23 14:41:04','',''),(3098,'1','307','1',1,'Retail Sale Id 3109',2208.00,0.00,0.00,3.00,318.00,'2023-02-23 14:43:12','',''),(3099,'1','307','1',1,'Retail Sale Id 3110',2944.00,0.00,0.00,4.00,424.00,'2023-02-23 14:52:44','',''),(3100,'1','307','1',1,'Retail Sale Id 3111',9200.00,0.00,0.00,12.50,1325.00,'2023-02-23 14:54:16','',''),(3101,'1','307','1',1,'Retail Sale Id 3112',4423.36,0.00,0.00,6.01,637.06,'2023-02-23 14:56:37','',''),(3102,'1','307','1',1,'Retail Sale Id 3113',4423.36,0.00,0.00,6.01,637.06,'2023-02-23 15:05:20','',''),(3103,'1','307','1',1,'Retail Sale Id 3114',2951.36,0.00,0.00,4.01,425.06,'2023-02-23 15:07:21','',''),(3104,'1','307','1',1,'Retail Sale Id 3115',3702.08,0.00,0.00,5.03,533.18,'2023-02-23 15:09:08','',''),(3105,'1','307','1',1,'Retail Sale Id 3116',750.72,0.00,0.00,1.02,108.12,'2023-02-23 15:23:08','',''),(3106,'1','307','1',1,'Retail Sale Id 3117',2208.00,0.00,0.00,3.00,318.00,'2023-02-23 15:31:02','',''),(3107,'1','307','1',1,'Retail Sale Id 3118',9200.00,0.00,0.00,12.50,1325.00,'2023-02-23 15:36:14','',''),(3108,'1','307','1',1,'Retail Sale Id 3119',2951.36,0.00,0.00,4.01,425.06,'2023-02-23 15:38:11','',''),(3109,'1','307','1',1,'Retail Sale Id 3120',9200.00,0.00,0.00,12.50,1325.00,'2023-02-23 15:54:43','',''),(3110,'1','307','1',1,'Retail Sale Id 3121',4423.36,0.00,0.00,6.01,637.06,'2023-02-23 15:55:53','',''),(3111,'1','307','1',1,'Retail Sale Id 3122',68000.00,0.00,0.00,100.00,5000.00,'2023-02-23 16:00:54','',''),(3112,'1','307','1',1,'Retail Sale Id 3123',1501.44,0.00,0.00,2.04,216.24,'2023-02-23 16:01:57','',''),(3113,'1','307','1',1,'Retail Sale Id 3124',3702.08,0.00,0.00,5.03,533.18,'2023-02-23 16:09:48','',''),(3114,'1','307','1',1,'Retail Sale Id 3125',3680.00,0.00,0.00,5.00,530.00,'2023-02-23 16:22:36','',''),(3115,'1','307','1',1,'Retail Sale Id 3126',4423.36,0.00,0.00,6.01,637.06,'2023-02-23 16:24:02','',''),(3116,'1','307','1',1,'Retail Sale Id 3127',2208.00,0.00,0.00,3.00,318.00,'2023-02-23 16:25:12','',''),(3117,'1','307','1',1,'Retail Sale Id 3128',1501.44,0.00,0.00,2.04,216.24,'2023-02-23 16:26:24','',''),(3118,'1','307','1',1,'Retail Sale Id 3129',2208.00,0.00,0.00,3.00,318.00,'2023-02-23 16:27:26','',''),(3119,'1','307','1',1,'Retail Sale Id 3130',1501.44,0.00,0.00,2.04,216.24,'2023-02-23 16:40:34','',''),(3120,'1','307','1',1,'Retail Sale Id 3131',34000.00,0.00,0.00,50.00,2500.00,'2023-02-23 16:43:13','',''),(3121,'1','307','1',1,'Retail Sale Id 3132',2502.40,0.00,0.00,3.40,360.40,'2023-02-23 16:44:53','',''),(3122,'1','307','1',1,'Return of Retail Sale Id 3132',0.00,2502.40,3.40,0.00,-360.40,'2023-02-23 17:24:44','',''),(3123,'1','307','1',1,'Return of Retail Sale Id 3130',0.00,1501.44,2.04,0.00,-216.24,'2023-02-23 17:26:25','',''),(3124,'1','307','1',1,'Return of Retail Sale Id 3131',0.00,34000.00,50.00,0.00,-2500.00,'2023-02-23 17:27:05','',''),(3125,'1','307','1',1,'Retail Sale Id 3133',21834.80,0.00,0.00,32.11,1605.50,'2023-02-23 17:47:09','',''),(3126,'1','307','1',1,'Retail Sale Id 3134',14234.24,0.00,0.00,19.34,2050.04,'2023-02-23 17:48:27','',''),(3127,'1','307','1',1,'Distributed to Operational lost for sales id:5',28765.80,0.00,0.00,45.66,0.00,'2023-02-23 17:52:37','',''),(3128,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,1260000.00,2000.00,0.00,0.00,'2023-02-23 19:23:42','',''),(3129,'1','307',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,2000.00,0.00,'2023-02-23 19:27:00','',''),(3130,'1','307','1',1,'Received from bridging 14',0.00,0.00,2000.00,0.00,0.00,'2023-02-23 19:27:00','',''),(3131,'1','307','1',1,'Retail Sale Id 3135',20291.52,0.00,0.00,27.57,2922.42,'2023-02-24 07:31:05','',''),(3132,'1','307','1',1,'Retail Sale Id 3136',10156.80,0.00,0.00,13.80,1462.80,'2023-02-24 07:45:52','',''),(3133,'1','307','1',1,'Retail Sale Id 3137',18046.72,0.00,0.00,24.52,2599.12,'2023-02-24 07:54:27','',''),(3134,'1','307','1',1,'Retail Sale Id 3138',2944.00,0.00,0.00,4.00,424.00,'2023-02-24 07:59:08','',''),(3135,'1','307','1',1,'Retail Sale Id 3139',3680.00,0.00,0.00,5.00,530.00,'2023-02-24 08:26:03','',''),(3136,'1','307','1',1,'Retail Sale Id 3140',1501.44,0.00,0.00,2.04,216.24,'2023-02-24 08:27:56','',''),(3137,'1','307','1',1,'Retail Sale Id 3141',9200.00,0.00,0.00,12.50,1325.00,'2023-02-24 08:29:48','',''),(3138,'1','307','1',1,'Retail Sale Id 3142',2208.00,0.00,0.00,3.00,318.00,'2023-02-24 08:40:48','',''),(3139,'1','307','1',1,'Retail Sale Id 3143',4997.44,0.00,0.00,6.79,719.74,'2023-02-24 08:43:03','',''),(3140,'1','307','1',1,'Retail Sale Id 3144',1501.44,0.00,0.00,2.04,216.24,'2023-02-24 08:44:38','',''),(3141,'1','307','1',1,'Retail Sale Id 3145',3996.48,0.00,0.00,5.43,575.58,'2023-02-24 08:54:33','',''),(3142,'1','307','1',1,'Retail Sale Id 3146',4423.36,0.00,0.00,6.01,637.06,'2023-02-24 08:57:30','',''),(3143,'1','307','1',1,'Retail Sale Id 3147',9200.00,0.00,0.00,12.50,1325.00,'2023-02-24 08:58:58','',''),(3144,'1','307','1',1,'Retail Sale Id 3148',34000.00,0.00,0.00,50.00,2500.00,'2023-02-24 09:00:34','',''),(3145,'1','307','1',1,'Retail Sale Id 3149',2208.00,0.00,0.00,3.00,318.00,'2023-02-24 09:06:35','',''),(3146,'1','307','1',1,'Retail Sale Id 3150',1501.44,0.00,0.00,2.04,216.24,'2023-02-24 09:20:01','',''),(3147,'1','307','1',1,'Retail Sale Id 3151',4423.36,0.00,0.00,6.01,637.06,'2023-02-24 09:32:42','',''),(3148,'1','307','1',1,'Retail Sale Id 3152',1501.44,0.00,0.00,2.04,216.24,'2023-02-24 09:38:21','',''),(3149,'1','307','1',1,'Retail Sale Id 3153',3680.00,0.00,0.00,5.00,530.00,'2023-02-24 09:43:36','',''),(3150,'1','307','1',1,'Retail Sale Id 3154',4496.96,0.00,0.00,6.11,647.66,'2023-02-24 09:46:52','',''),(3151,'1','307','1',1,'Retail Sale Id 3155',4423.36,0.00,0.00,6.01,637.06,'2023-02-24 09:49:12','',''),(3152,'1','307','1',1,'Retail Sale Id 3156',1398.40,0.00,0.00,1.90,201.40,'2023-02-24 09:50:32','',''),(3153,'1','307','1',1,'Retail Sale Id 3157',1000.96,0.00,0.00,1.36,144.16,'2023-02-24 09:51:32','',''),(3154,'1','307','1',1,'Retail Sale Id 3158',4423.36,0.00,0.00,6.01,637.06,'2023-02-24 10:18:51','',''),(3155,'1','307','1',1,'Retail Sale Id 3159',2001.92,0.00,0.00,2.72,288.32,'2023-02-24 10:29:31','',''),(3156,'1','307','1',1,'Retail Sale Id 3160',112200.00,0.00,0.00,165.00,8250.00,'2023-02-24 10:34:15','',''),(3157,'1','307','1',1,'Retail Sale Id 3161',3002.88,0.00,0.00,4.08,432.48,'2023-02-24 10:35:36','',''),(3158,'1','307','1',1,'Retail Sale Id 3162',1501.44,0.00,0.00,2.04,216.24,'2023-02-24 10:40:06','',''),(3159,'1','307','1',1,'Retail Sale Id 3163',7360.00,0.00,0.00,10.00,1060.00,'2023-02-24 10:45:41','',''),(3160,'1','307','1',1,'Retail Sale Id 3164',5998.40,0.00,0.00,8.15,863.90,'2023-02-24 10:47:07','',''),(3161,'1','307','1',1,'Retail Sale Id 3165',3002.88,0.00,0.00,4.08,432.48,'2023-02-24 10:49:01','',''),(3162,'1','307','1',1,'Retail Sale Id 3166',9200.00,0.00,0.00,12.50,1325.00,'2023-02-24 10:51:59','',''),(3163,'1','307','1',1,'Retail Sale Id 3167',4423.36,0.00,0.00,6.01,637.06,'2023-02-24 10:55:26','',''),(3164,'1','307','1',1,'Retail Sale Id 3168',34000.00,0.00,0.00,50.00,2500.00,'2023-02-24 10:58:56','',''),(3165,'1','307','1',1,'Retail Sale Id 3169',4423.36,0.00,0.00,6.01,637.06,'2023-02-24 11:36:36','',''),(3166,'1','307','1',1,'Retail Sale Id 3170',3680.00,0.00,0.00,5.00,530.00,'2023-02-24 11:56:35','',''),(3167,'1','307','1',1,'Retail Sale Id 3171',1501.44,0.00,0.00,2.04,216.24,'2023-02-24 12:03:34','',''),(3168,'1','307','1',1,'Retail Sale Id 3172',34000.00,0.00,0.00,50.00,2500.00,'2023-02-24 12:49:25','',''),(3169,'1','307','1',1,'Retail Sale Id 3173',7396.80,0.00,0.00,10.05,1065.30,'2023-02-24 12:51:23','',''),(3170,'1','307','1',1,'Retail Sale Id 3174',1000.96,0.00,0.00,1.36,144.16,'2023-02-24 12:52:18','',''),(3171,'1','307','1',1,'Retail Sale Id 3175',4423.36,0.00,0.00,6.01,637.06,'2023-02-24 12:54:36','',''),(3172,'1','307','1',1,'Retail Sale Id 3176',1000.96,0.00,0.00,1.36,144.16,'2023-02-24 12:56:33','',''),(3173,'1','307','1',1,'Retail Sale Id 3177',9501.76,0.00,0.00,12.91,1368.46,'2023-02-24 13:39:22','',''),(3174,'1','307','1',1,'Retail Sale Id 3178',12563.52,0.00,0.00,17.07,1809.42,'2023-02-24 14:06:34','',''),(3175,'1','307','1',1,'Retail Sale Id 3179',68000.00,0.00,0.00,100.00,5000.00,'2023-02-24 14:15:54','',''),(3176,'1','307','1',1,'Retail Sale Id 3180',1501.44,0.00,0.00,2.04,216.24,'2023-02-24 14:28:37','',''),(3177,'1','307','1',1,'Retail Sale Id 3181',4496.96,0.00,0.00,6.11,647.66,'2023-02-24 14:32:05','',''),(3178,'1','307','1',1,'Retail Sale Id 3182',3002.88,0.00,0.00,4.08,432.48,'2023-02-24 14:38:16','',''),(3179,'1','307','1',1,'Retail Sale Id 3183',5203.52,0.00,0.00,7.07,749.42,'2023-02-24 14:46:40','',''),(3180,'1','307','1',1,'Retail Sale Id 3184',4416.00,0.00,0.00,6.00,636.00,'2023-02-24 14:49:15','',''),(3181,'1','307','1',1,'Retail Sale Id 3185',2200.64,0.00,0.00,2.99,316.94,'2023-02-24 14:51:14','',''),(3182,'1','307','1',1,'Retail Sale Id 3186',2237.44,0.00,0.00,3.04,322.24,'2023-02-24 14:52:48','',''),(3183,'1','307','1',1,'Retail Sale Id 3187',2208.00,0.00,0.00,3.00,318.00,'2023-02-24 15:29:25','',''),(3184,'1','307','1',1,'Retail Sale Id 3188',11408.00,0.00,0.00,15.50,1643.00,'2023-02-24 15:31:50','',''),(3185,'1','307','1',1,'Retail Sale Id 3189',3002.88,0.00,0.00,4.08,432.48,'2023-02-24 15:32:42','',''),(3186,'1','307','1',1,'Retail Sale Id 3190',34000.00,0.00,0.00,50.00,2500.00,'2023-02-24 15:37:16','',''),(3187,'1','307','1',1,'Retail Sale Id 3191',1501.44,0.00,0.00,2.04,216.24,'2023-02-24 15:42:24','',''),(3188,'1','307','1',1,'Retail Sale Id 3192',2951.36,0.00,0.00,4.01,425.06,'2023-02-24 15:45:19','',''),(3189,'1','307','1',1,'Retail Sale Id 3193',28740.80,0.00,0.00,39.05,4139.30,'2023-02-24 16:29:40','',''),(3190,'1','307','1',1,'Retail Sale Id 3194',2951.36,0.00,0.00,4.01,425.06,'2023-02-24 16:32:28','',''),(3191,'1','307','1',1,'Retail Sale Id 3195',3002.88,0.00,0.00,4.08,432.48,'2023-02-24 16:34:33','',''),(3192,'1','307','1',1,'Retail Sale Id 3196',2222.72,0.00,0.00,3.02,320.12,'2023-02-24 16:50:38','',''),(3193,'1','307','1',1,'Retail Sale Id 3197',1000.96,0.00,0.00,1.36,144.16,'2023-02-24 16:53:58','',''),(3194,'1','307','1',1,'Retail Sale Id 3198',4423.36,0.00,0.00,6.01,637.06,'2023-02-24 16:55:13','',''),(3195,'1','307','1',1,'Retail Sale Id 3199',5203.52,0.00,0.00,7.07,749.42,'2023-02-24 17:05:10','',''),(3196,'1','307','1',1,'Retail Sale Id 3200',2208.00,0.00,0.00,3.00,318.00,'2023-02-24 17:10:04','',''),(3197,'1','307','1',1,'Retail Sale Id 3201',2208.00,0.00,0.00,3.00,318.00,'2023-02-24 17:17:04','',''),(3198,'1','307','1',1,'Retail Sale Id 3201',3996.48,0.00,0.00,5.43,575.58,'2023-02-24 17:17:04','',''),(3199,'1','307','1',1,'Retail Sale Id 3202',1501.44,0.00,0.00,2.04,216.24,'2023-02-24 17:33:00','',''),(3200,'1','307','1',1,'Retail Sale Id 3203',13343.68,0.00,0.00,18.13,1921.78,'2023-02-24 17:34:38','',''),(3201,'1','307','1',1,'Retail Sale Id 3204',2208.00,0.00,0.00,3.00,318.00,'2023-02-24 17:38:02','',''),(3202,'1','307','1',1,'Retail Sale Id 3205',34000.00,0.00,0.00,50.00,2500.00,'2023-02-24 17:40:07','',''),(3203,'1','307','1',1,'Retail Sale Id 3206',1096.64,0.00,0.00,1.49,157.94,'2023-02-24 17:45:34','',''),(3204,'1','307','1',1,'Retail Sale Id 3207',11783.36,0.00,0.00,16.01,1697.06,'2023-02-24 17:48:25','',''),(3205,'1','307','1',1,'Retail Sale Id 3208',1501.44,0.00,0.00,2.04,216.24,'2023-02-24 18:19:30','',''),(3206,'1','307','1',1,'Retail Sale Id 3209',4416.00,0.00,0.00,6.00,636.00,'2023-02-24 18:22:34','',''),(3207,'1','307','1',1,'Retail Sale Id 3210',2001.92,0.00,0.00,2.72,288.32,'2023-02-24 18:26:49','',''),(3208,'1','307','1',1,'Retail Sale Id 3211',63980.48,0.00,0.00,86.93,9214.58,'2023-02-24 18:30:18','',''),(3209,'1','307','1',1,'Retail Sale Id 3212',3702.08,0.00,0.00,5.03,533.18,'2023-02-24 18:40:58','',''),(3210,'1','307','1',1,'Retail Sale Id 3213',34000.00,0.00,0.00,50.00,2500.00,'2023-02-24 18:53:02','',''),(3211,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,630000.00,1000.00,0.00,0.00,'2023-02-24 19:02:44','',''),(3212,'1','307',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,1000.00,0.00,'2023-02-24 19:03:45','',''),(3213,'1','307','1',1,'Received from bridging 15',0.00,0.00,1000.00,0.00,0.00,'2023-02-24 19:03:45','',''),(3214,'1','307','1',1,'Retail Sale Id 3214',1501.44,0.00,0.00,2.04,216.24,'2023-02-24 19:05:06','',''),(3215,'1','307','1',1,'Retail Sale Id 3215',11408.00,0.00,0.00,15.50,1643.00,'2023-02-24 19:06:59','',''),(3216,'1','307','1',1,'Retail Sale Id 3216',2208.00,0.00,0.00,3.00,318.00,'2023-02-24 19:08:39','',''),(3217,'1','307','1',1,'Retail Sale Id 3217',29425.28,0.00,0.00,39.98,4237.88,'2023-02-24 19:32:27','',''),(3218,'1','307','1',1,'Retail Sale Id 3218',4416.00,0.00,0.00,6.00,636.00,'2023-02-26 07:32:31','',''),(3219,'1','307','1',1,'Retail Sale Id 3219',220.80,0.00,0.00,0.30,31.80,'2023-02-26 07:46:11','',''),(3220,'1','307','1',1,'Retail Sale Id 3220',802.24,0.00,0.00,1.09,115.54,'2023-02-26 07:47:16','',''),(3221,'1','307','1',1,'Retail Sale Id 3221',210800.00,0.00,0.00,310.00,15500.00,'2023-02-26 07:51:17','',''),(3222,'1','307','1',1,'Retail Sale Id 3222',2208.00,0.00,0.00,3.00,318.00,'2023-02-26 08:19:54','',''),(3223,'1','307','1',1,'Retail Sale Id 3224',8832.00,0.00,0.00,12.00,1272.00,'2023-02-26 08:22:17','',''),(3224,'1','307','1',1,'Retail Sale Id 3226',9200.00,0.00,0.00,12.50,1325.00,'2023-02-26 08:26:22','',''),(3225,'1','307','1',1,'Retail Sale Id 3225',2208.00,0.00,0.00,3.00,318.00,'2023-02-26 08:26:50','',''),(3226,'1','307','1',1,'Retail Sale Id 3227',7360.00,0.00,0.00,10.00,1060.00,'2023-02-26 08:42:35','',''),(3227,'1','307','1',1,'Retail Sale Id 3228',4416.00,0.00,0.00,6.00,636.00,'2023-02-26 09:17:32','',''),(3228,'1','307','1',1,'Retail Sale Id 3229',3680.00,0.00,0.00,5.00,530.00,'2023-02-26 09:18:28','',''),(3229,'1','307','1',1,'Retail Sale Id 3230',750.72,0.00,0.00,1.02,108.12,'2023-02-26 09:21:28','',''),(3230,'1','307','1',1,'Retail Sale Id 3231',34000.00,0.00,0.00,50.00,2500.00,'2023-02-26 09:31:57','',''),(3231,'1','307','1',1,'Retail Sale Id 3232',68000.00,0.00,0.00,100.00,5000.00,'2023-02-26 10:02:56','',''),(3232,'1','307','1',1,'Retail Sale Id 3233',6999.36,0.00,0.00,9.51,1008.06,'2023-02-26 10:08:08','',''),(3233,'1','307','1',1,'Retail Sale Id 3234',750.72,0.00,0.00,1.02,108.12,'2023-02-26 10:09:21','',''),(3234,'1','307','1',1,'Retail Sale Id 3235',4997.44,0.00,0.00,6.79,719.74,'2023-02-26 10:11:52','',''),(3235,'1','307','1',1,'Retail Sale Id 3236',4416.00,0.00,0.00,6.00,636.00,'2023-02-26 10:20:18','',''),(3236,'1','307','1',1,'Retail Sale Id 3237',3503.36,0.00,0.00,4.76,504.56,'2023-02-26 10:21:15','',''),(3237,'1','307','1',1,'Retail Sale Id 3238',68000.00,0.00,0.00,100.00,5000.00,'2023-02-26 10:28:04','',''),(3238,'1','307','1',1,'Retail Sale Id 3239',6498.88,0.00,0.00,8.83,935.98,'2023-02-26 10:36:01','',''),(3239,'1','307','1',1,'Retail Sale Id 3240',4496.96,0.00,0.00,6.11,647.66,'2023-02-26 11:29:41','',''),(3240,'1','307','1',1,'Retail Sale Id 3241',1000.96,0.00,0.00,1.36,144.16,'2023-02-26 11:35:55','',''),(3241,'1','307','1',1,'Retail Sale Id 3242',2944.00,0.00,0.00,4.00,424.00,'2023-02-26 11:46:27','',''),(3242,'1','307','1',1,'Retail Sale Id 3243',4416.00,0.00,0.00,6.00,636.00,'2023-02-26 11:51:44','',''),(3243,'1','307','1',1,'Retail Sale Id 3244',1472.00,0.00,0.00,2.00,212.00,'2023-02-26 11:56:04','',''),(3244,'1','307','1',1,'Retail Sale Id 3245',8832.00,0.00,0.00,12.00,1272.00,'2023-02-26 12:03:59','',''),(3245,'1','307','1',1,'Retail Sale Id 3246',4416.00,0.00,0.00,6.00,636.00,'2023-02-26 12:09:31','',''),(3246,'1','307','1',1,'Retail Sale Id 3247',4416.00,0.00,0.00,6.00,636.00,'2023-02-26 12:11:54','',''),(3247,'1','307','1',1,'Retail Sale Id 3248',28063.68,0.00,0.00,38.13,4041.78,'2023-02-26 14:30:04','',''),(3248,'1','307','1',1,'Retail Sale Id 3249',85000.00,0.00,0.00,125.00,6250.00,'2023-02-26 14:31:09','',''),(3249,'1','307','1',1,'Retail Sale Id 3250',68000.00,0.00,0.00,100.00,5000.00,'2023-02-26 14:32:13','',''),(3250,'1','307','1',1,'Retail Sale Id 3251',7140.00,0.00,0.00,10.50,525.00,'2023-02-26 15:51:33','',''),(3251,'1','307','1',1,'Retail Sale Id 3252',4423.36,0.00,0.00,6.01,637.06,'2023-02-26 15:54:51','',''),(3252,'1','307','1',1,'Retail Sale Id 3253',1501.44,0.00,0.00,2.04,216.24,'2023-02-26 15:56:30','',''),(3253,'1','307','1',1,'Retail Sale Id 3254',3680.00,0.00,0.00,5.00,530.00,'2023-02-26 15:59:26','',''),(3254,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,630000.00,1000.00,0.00,0.00,'2023-02-26 16:41:44','',''),(3255,'1','307',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,1000.00,0.00,'2023-02-26 16:43:09','',''),(3256,'1','307','1',1,'Received from bridging 16',0.00,0.00,1000.00,0.00,0.00,'2023-02-26 16:43:09','',''),(3257,'1','307','1',1,'Retail Sale Id 3255',93500.00,0.00,0.00,137.50,6875.00,'2023-02-26 16:47:02','',''),(3258,'1','307','1',1,'Retail Sale Id 3256',2252.16,0.00,0.00,3.06,324.36,'2023-02-26 17:02:06','',''),(3259,'1','307','1',1,'Retail Sale Id 3257',4423.36,0.00,0.00,6.01,637.06,'2023-02-26 17:17:16','',''),(3260,'1','307','1',1,'Retail Sale Id 3258',18348.48,0.00,0.00,24.93,2642.58,'2023-02-26 17:46:17','',''),(3261,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,554400.00,880.00,0.00,0.00,'2023-02-26 18:43:36','',''),(3262,'1','307',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,880.00,0.00,'2023-02-26 18:45:41','',''),(3263,'1','307','1',1,'Received from bridging 17',0.00,0.00,880.00,0.00,0.00,'2023-02-26 18:45:41','',''),(3264,'1','307','1',1,'Retail Sale Id 3259',101104.32,0.00,0.00,137.37,14561.22,'2023-02-26 19:18:56','',''),(3265,'1','307','1',1,'Retail Sale Id 3260',3680.00,0.00,0.00,5.00,530.00,'2023-02-27 07:26:45','',''),(3266,'1','307','1',1,'Retail Sale Id 3261',1501.44,0.00,0.00,2.04,216.24,'2023-02-27 07:59:00','',''),(3267,'1','307','1',1,'Retail Sale Id 3262',2001.92,0.00,0.00,2.72,288.32,'2023-02-27 07:59:40','',''),(3268,'1','307','1',1,'Retail Sale Id 3263',2001.92,0.00,0.00,2.72,288.32,'2023-02-27 08:10:15','',''),(3269,'1','307','1',1,'Retail Sale Id 3264',9200.00,0.00,0.00,12.50,1325.00,'2023-02-27 08:34:40','',''),(3270,'1','307','1',1,'Retail Sale Id 3265',736.00,0.00,0.00,1.00,106.00,'2023-02-27 08:39:51','',''),(3271,'1','307','1',1,'Retail Sale Id 3266',136000.00,0.00,0.00,200.00,10000.00,'2023-02-27 08:43:15','',''),(3272,'1','307','1',1,'Retail Sale Id 3267',2208.00,0.00,0.00,3.00,318.00,'2023-02-27 08:51:58','',''),(3273,'1','307','1',1,'Retail Sale Id 3268',1501.44,0.00,0.00,2.04,216.24,'2023-02-27 08:57:48','',''),(3274,'1','307','1',1,'Retail Sale Id 3269',9200.00,0.00,0.00,12.50,1325.00,'2023-02-27 08:59:20','',''),(3275,'1','307','1',1,'Retail Sale Id 3270',4496.96,0.00,0.00,6.11,647.66,'2023-02-27 09:03:41','',''),(3276,'1','307','1',1,'Retail Sale Id 3271',4416.00,0.00,0.00,6.00,636.00,'2023-02-27 11:14:44','',''),(3277,'1','307','1',1,'Retail Sale Id 3272',2208.00,0.00,0.00,3.00,318.00,'2023-02-27 11:19:56','',''),(3278,'1','307','1',1,'Retail Sale Id 3273',4423.36,0.00,0.00,6.01,637.06,'2023-02-27 11:28:04','',''),(3279,'1','307','1',1,'Retail Sale Id 3274',2951.36,0.00,0.00,4.01,425.06,'2023-02-27 11:29:40','',''),(3280,'1','307','1',1,'Retail Sale Id 3275',1501.44,0.00,0.00,2.04,216.24,'2023-02-27 11:30:33','',''),(3281,'1','307','1',1,'Retail Sale Id 3276',2200.64,0.00,0.00,2.99,316.94,'2023-02-27 11:38:23','',''),(3282,'1','307','1',1,'Retail Sale Id 3277',34000.00,0.00,0.00,50.00,2500.00,'2023-02-27 11:39:48','',''),(3283,'1','307','1',1,'Retail Sale Id 3278',2208.00,0.00,0.00,3.00,318.00,'2023-02-27 11:41:28','',''),(3284,'1','307','1',1,'Retail Sale Id 3279',2208.00,0.00,0.00,3.00,318.00,'2023-02-27 11:53:23','',''),(3285,'1','307','1',1,'Retail Sale Id 3280',2200.64,0.00,0.00,2.99,316.94,'2023-02-27 11:54:34','',''),(3286,'1','307','1',1,'Retail Sale Id 3281',4496.96,0.00,0.00,6.11,647.66,'2023-02-27 11:58:04','',''),(3287,'1','307','1',1,'Retail Sale Id 3282',4416.00,0.00,0.00,6.00,636.00,'2023-02-27 12:07:06','',''),(3288,'1','307','1',1,'Retail Sale Id 3283',2208.00,0.00,0.00,3.00,318.00,'2023-02-27 12:17:11','',''),(3289,'1','307','1',1,'Retail Sale Id 3284',4416.00,0.00,0.00,6.00,636.00,'2023-02-27 12:21:43','',''),(3290,'1','307','1',1,'Retail Sale Id 3285',34000.00,0.00,0.00,50.00,2500.00,'2023-02-27 12:22:55','',''),(3291,'1','307','1',1,'Retail Sale Id 3286',1501.44,0.00,0.00,2.04,216.24,'2023-02-27 12:24:37','',''),(3292,'1','307','1',1,'Retail Sale Id 3287',32803.20,0.00,0.00,48.24,2412.00,'2023-02-27 12:30:12','',''),(3293,'1','307','1',1,'Retail Sale Id 3288',9200.00,0.00,0.00,12.50,1325.00,'2023-02-27 12:31:09','',''),(3294,'1','307','1',1,'Retail Sale Id 3289',68000.00,0.00,0.00,100.00,5000.00,'2023-02-27 12:40:53','',''),(3295,'1','307','1',1,'Retail Sale Id 3290',1501.44,0.00,0.00,2.04,216.24,'2023-02-27 12:48:47','',''),(3296,'1','307','1',1,'Retail Sale Id 3291',2001.92,0.00,0.00,2.72,288.32,'2023-02-27 12:53:27','',''),(3297,'1','307','1',1,'Retail Sale Id 3292',4496.96,0.00,0.00,6.11,647.66,'2023-02-27 12:54:36','',''),(3298,'1','307','1',1,'Retail Sale Id 3293',4496.96,0.00,0.00,6.11,647.66,'2023-02-27 12:57:13','',''),(3299,'1','307','1',1,'Retail Sale Id 3294',68000.00,0.00,0.00,100.00,5000.00,'2023-02-27 13:10:47','',''),(3300,'1','307','1',1,'Retail Sale Id 3295',20502.00,0.00,0.00,30.15,1507.50,'2023-02-27 15:39:42','',''),(3301,'1','307','1',1,'Retail Sale Id 3296',1501.44,0.00,0.00,2.04,216.24,'2023-02-27 17:17:55','',''),(3302,'1','307','1',1,'Retail Sale Id 3297',3680.00,0.00,0.00,5.00,530.00,'2023-02-27 17:25:35','',''),(3303,'1','307','1',1,'Retail Sale Id 3298',4423.36,0.00,0.00,6.01,637.06,'2023-02-27 17:29:15','',''),(3304,'1','307','1',1,'Retail Sale Id 3299',20400.00,0.00,0.00,30.00,1500.00,'2023-02-27 17:36:34','',''),(3305,'1','307','1',1,'Retail Sale Id 3300',9200.00,0.00,0.00,12.50,1325.00,'2023-02-27 17:38:47','',''),(3306,'1','307','1',1,'Retail Sale Id 3301',1501.44,0.00,0.00,2.04,216.24,'2023-02-27 17:41:03','',''),(3307,'1','307','1',1,'Retail Sale Id 3302',2951.36,0.00,0.00,4.01,425.06,'2023-02-27 17:49:01','',''),(3308,'1','307','1',1,'Retail Sale Id 3303',3002.88,0.00,0.00,4.08,432.48,'2023-02-27 17:51:04','',''),(3309,'1','307','1',1,'Retail Sale Id 3304',1000.96,0.00,0.00,1.36,144.16,'2023-02-27 17:52:23','',''),(3310,'1','307','1',1,'Retail Sale Id 3305',103614.08,0.00,0.00,140.78,14922.68,'2023-02-27 18:50:00','',''),(3311,'1','307','1',1,'Retail Sale Id 3306',10669.20,0.00,0.00,15.69,784.50,'2023-02-27 18:52:48','',''),(3312,'1','307','1',1,'Retail Sale Id 3307',9568.00,0.00,0.00,13.00,1378.00,'2023-02-28 07:27:30','',''),(3313,'1','307','1',1,'Retail Sale Id 3308',2208.00,0.00,0.00,3.00,318.00,'2023-02-28 07:57:11','',''),(3314,'1','307','1',1,'Retail Sale Id 3309',7499.84,0.00,0.00,10.19,1080.14,'2023-02-28 08:20:40','',''),(3315,'1','307','1',1,'Retail Sale Id 3310',4416.00,0.00,0.00,6.00,636.00,'2023-02-28 08:28:25','',''),(3316,'1','307','1',1,'Retail Sale Id 3311',4496.96,0.00,0.00,6.11,647.66,'2023-02-28 08:29:21','',''),(3317,'1','307','1',1,'Retail Sale Id 3312',68000.00,0.00,0.00,100.00,5000.00,'2023-02-28 08:35:33','',''),(3318,'1','307','1',1,'Retail Sale Id 3313',4416.00,0.00,0.00,6.00,636.00,'2023-02-28 08:48:36','',''),(3319,'1','307','1',1,'Retail Sale Id 3314',4416.00,0.00,0.00,6.00,636.00,'2023-02-28 08:50:02','',''),(3320,'1','307','1',1,'Retail Sale Id 3315',2001.92,0.00,0.00,2.72,288.32,'2023-02-28 08:57:14','',''),(3321,'1','307','1',1,'Retail Sale Id 3316',1472.00,0.00,0.00,2.00,212.00,'2023-02-28 09:38:34','',''),(3322,'1','307','1',1,'Retail Sale Id 3317',36800.00,0.00,0.00,50.00,5300.00,'2023-02-28 09:39:30','',''),(3323,'1','307','1',1,'Retail Sale Id 3318',2208.00,0.00,0.00,3.00,318.00,'2023-02-28 09:50:57','',''),(3324,'1','307','1',1,'Retail Sale Id 3319',34000.00,0.00,0.00,50.00,2500.00,'2023-02-28 09:55:25','',''),(3325,'1','307','1',1,'Retail Sale Id 3320',3002.88,0.00,0.00,4.08,432.48,'2023-02-28 10:18:31','',''),(3326,'1','307','1',1,'Retail Sale Id 3321',2944.00,0.00,0.00,4.00,424.00,'2023-02-28 10:20:10','',''),(3327,'1','307','1',1,'Retail Sale Id 3322',4416.00,0.00,0.00,6.00,636.00,'2023-02-28 10:22:49','',''),(3328,'1','307','1',1,'Retail Sale Id 3323',1472.00,0.00,0.00,2.00,212.00,'2023-02-28 10:29:47','',''),(3329,'1','307','1',1,'Retail Sale Id 3324',5520.00,0.00,0.00,7.50,795.00,'2023-02-28 10:34:03','',''),(3330,'1','307','1',1,'Retail Sale Id 3325',4416.00,0.00,0.00,6.00,636.00,'2023-02-28 10:44:14','',''),(3331,'1','307','1',1,'Retail Sale Id 3326',3002.88,0.00,0.00,4.08,432.48,'2023-02-28 10:55:53','',''),(3332,'1','307','1',1,'Retail Sale Id 3327',2222.72,0.00,0.00,3.02,320.12,'2023-02-28 10:57:36','',''),(3333,'1','307','1',1,'Retail Sale Id 3328',2200.64,0.00,0.00,2.99,316.94,'2023-02-28 10:59:42','',''),(3334,'1','307','1',1,'Retail Sale Id 3329',2944.00,0.00,0.00,4.00,424.00,'2023-02-28 11:08:11','',''),(3335,'1','307','1',1,'Retail Sale Id 3330',16618.88,0.00,0.00,22.58,2393.48,'2023-02-28 11:28:22','',''),(3336,'1','307','1',1,'Retail Sale Id 3331',12497.28,0.00,0.00,16.98,1799.88,'2023-02-28 11:31:40','',''),(3337,'1','307','1',1,'Retail Sale Id 3332',9200.00,0.00,0.00,12.50,1325.00,'2023-02-28 11:37:36','',''),(3338,'1','307','1',1,'Retail Sale Id 3333',4416.00,0.00,0.00,6.00,636.00,'2023-02-28 12:07:07','',''),(3339,'1','307','1',1,'Retail Sale Id 3334',750.72,0.00,0.00,1.02,108.12,'2023-02-28 12:31:46','',''),(3340,'1','307','1',1,'Retail Sale Id 3335',1472.00,0.00,0.00,2.00,212.00,'2023-02-28 12:50:03','',''),(3341,'1','307','1',1,'Retail Sale Id 3336',1501.44,0.00,0.00,2.04,216.24,'2023-02-28 12:55:25','',''),(3342,'1','307','1',1,'Retail Sale Id 3337',2208.00,0.00,0.00,3.00,318.00,'2023-02-28 12:59:37','',''),(3343,'1','307','1',1,'Retail Sale Id 3338',4416.00,0.00,0.00,6.00,636.00,'2023-02-28 13:00:51','',''),(3344,'1','307','1',1,'Retail Sale Id 3339',1000.96,0.00,0.00,1.36,144.16,'2023-02-28 14:31:29','',''),(3345,'1','307','1',1,'Retail Sale Id 3340',3680.00,0.00,0.00,5.00,530.00,'2023-02-28 14:34:37','',''),(3346,'1','307','1',1,'Retail Sale Id 3341',1501.44,0.00,0.00,2.04,216.24,'2023-02-28 14:36:53','',''),(3347,'1','307','1',1,'Retail Sale Id 3342',4423.36,0.00,0.00,6.01,637.06,'2023-02-28 14:40:04','',''),(3348,'1','307','1',1,'Retail Sale Id 3343',4452.80,0.00,0.00,6.05,641.30,'2023-02-28 16:08:56','',''),(3349,'1','307','1',1,'Retail Sale Id 3344',4423.36,0.00,0.00,6.01,637.06,'2023-02-28 16:16:57','',''),(3350,'1','307','1',1,'Retail Sale Id 3345',3002.88,0.00,0.00,4.08,432.48,'2023-02-28 16:19:18','',''),(3351,'1','307','1',1,'Retail Sale Id 3346',4202.56,0.00,0.00,5.71,605.26,'2023-02-28 17:08:18','',''),(3352,'1','307','1',1,'Retail Sale Id 3347',9200.00,0.00,0.00,12.50,1325.00,'2023-02-28 17:12:30','',''),(3353,'1','307','1',1,'Retail Sale Id 3349',2951.36,0.00,0.00,4.01,425.06,'2023-02-28 17:28:42','',''),(3354,'1','307','1',1,'Retail Sale Id 3350',34000.00,0.00,0.00,50.00,2500.00,'2023-02-28 17:32:04','',''),(3355,'1','307','1',1,'Retail Sale Id 3351',1501.44,0.00,0.00,2.04,216.24,'2023-02-28 17:34:35','',''),(3356,'1','307','1',1,'Retail Sale Id 3352',6624.00,0.00,0.00,9.00,954.00,'2023-02-28 17:35:57','',''),(3357,'1','307','1',1,'Retail Sale Id 3353',1501.44,0.00,0.00,2.04,216.24,'2023-02-28 18:06:07','',''),(3358,'1','307','1',1,'Retail Sale Id 3354',42386.24,0.00,0.00,57.59,6104.54,'2023-02-28 18:55:18','',''),(3359,'1','307','1',1,'Retail Sale Id 3355',12498.40,0.00,0.00,18.38,919.00,'2023-02-28 18:57:50','',''),(3360,'1','307','1',1,'Return of Retail Sale Id 3319',0.00,34000.00,50.00,0.00,-2500.00,'2023-02-28 19:19:17','',''),(3361,'1','307','1',1,'Retail Sale Id 3356',34000.00,0.00,0.00,50.00,2500.00,'2023-02-28 19:20:11','',''),(3362,'1','307','1',1,'Retail Sale Id 3357',2502.40,0.00,0.00,3.40,360.40,'2023-03-01 08:28:07','',''),(3363,'1','307','1',1,'Retail Sale Id 3358',4416.00,0.00,0.00,6.00,636.00,'2023-03-01 08:29:54','',''),(3364,'1','307','1',1,'Retail Sale Id 3360',1472.00,0.00,0.00,2.00,212.00,'2023-03-01 08:32:19','',''),(3365,'1','307','1',1,'Retail Sale Id 3361',2208.00,0.00,0.00,3.00,318.00,'2023-03-01 08:52:52','',''),(3366,'1','307','1',1,'Retail Sale Id 3362',9200.00,0.00,0.00,12.50,1325.00,'2023-03-01 08:59:55','',''),(3367,'1','307','1',1,'Retail Sale Id 3363',102000.00,0.00,0.00,150.00,7500.00,'2023-03-01 09:04:32','',''),(3368,'1','307','1',1,'Retail Sale Id 3364',9200.00,0.00,0.00,12.50,1325.00,'2023-03-01 09:34:15','',''),(3369,'1','307','1',1,'Retail Sale Id 3365',9200.00,0.00,0.00,12.50,1325.00,'2023-03-01 09:38:54','',''),(3370,'1','307','1',1,'Retail Sale Id 3366',44880.00,0.00,0.00,66.00,3300.00,'2023-03-01 10:50:27','',''),(3371,'1','307','1',1,'Retail Sale Id 3367',7360.00,0.00,0.00,10.00,1060.00,'2023-03-01 10:51:37','',''),(3372,'1','307','1',1,'Retail Sale Id 3368',728.64,0.00,0.00,0.99,104.94,'2023-03-01 11:13:27','',''),(3373,'1','307','1',1,'Retail Sale Id 3369',2208.00,0.00,0.00,3.00,318.00,'2023-03-01 11:28:09','',''),(3374,'1','307','1',1,'Retail Sale Id 3370',4416.00,0.00,0.00,6.00,636.00,'2023-03-01 11:34:09','',''),(3375,'1','307','1',1,'Retail Sale Id 3371',9200.00,0.00,0.00,12.50,1325.00,'2023-03-01 11:53:10','',''),(3376,'1','307','1',1,'Retail Sale Id 3372',1501.44,0.00,0.00,2.04,216.24,'2023-03-01 12:09:53','',''),(3377,'1','307','1',1,'Retail Sale Id 3373',3680.00,0.00,0.00,5.00,530.00,'2023-03-01 12:27:35','',''),(3378,'1','307','1',1,'Retail Sale Id 3374',4416.00,0.00,0.00,6.00,636.00,'2023-03-01 12:44:16','',''),(3379,'1','307','1',1,'Retail Sale Id 3375',4496.96,0.00,0.00,6.11,647.66,'2023-03-01 13:14:21','',''),(3380,'1','307','1',1,'Retail Sale Id 3376',2208.00,0.00,0.00,3.00,318.00,'2023-03-01 13:21:27','',''),(3381,'1','307','1',1,'Retail Sale Id 3377',9200.00,0.00,0.00,12.50,1325.00,'2023-03-01 13:23:12','',''),(3382,'1','307','1',1,'Retail Sale Id 3379',758.08,0.00,0.00,1.03,109.18,'2023-03-01 13:40:21','',''),(3383,'1','307','1',1,'Retail Sale Id 3380',2200.64,0.00,0.00,2.99,316.94,'2023-03-01 13:50:00','',''),(3384,'1','307','1',1,'Retail Sale Id 3381',3002.88,0.00,0.00,4.08,432.48,'2023-03-01 14:13:58','',''),(3385,'1','307','1',1,'Retail Sale Id 3382',1501.44,0.00,0.00,2.04,216.24,'2023-03-01 16:15:30','',''),(3386,'1','307','1',1,'Retail Sale Id 3383',2944.00,0.00,0.00,4.00,424.00,'2023-03-01 16:19:05','',''),(3387,'1','307','1',1,'Retail Sale Id 3384',2951.36,0.00,0.00,4.01,425.06,'2023-03-01 16:21:09','',''),(3388,'1','307','1',1,'Retail Sale Id 3385',9001.28,0.00,0.00,12.23,1296.38,'2023-03-01 16:22:40','',''),(3389,'1','307','1',1,'Retail Sale Id 3386',18400.00,0.00,0.00,25.00,2650.00,'2023-03-01 16:24:08','',''),(3390,'1','307','1',1,'Retail Sale Id 3387',60363.60,0.00,0.00,88.77,4438.50,'2023-03-01 17:57:58','',''),(3391,'1','307','1',1,'Retail Sale Id 3388',9303.04,0.00,0.00,12.64,1339.84,'2023-03-01 18:03:11','',''),(3392,'1','307','1',1,'Retail Sale Id 3389',7360.00,0.00,0.00,10.00,1060.00,'2023-03-01 18:44:42','',''),(3393,'1','307','1',1,'Retail Sale Id 3390',1501.44,0.00,0.00,2.04,216.24,'2023-03-01 18:47:23','',''),(3394,'1','307','1',1,'Retail Sale Id 3391',19231.68,0.00,0.00,26.13,2769.78,'2023-03-01 19:25:21','',''),(3395,'1','307','1',1,'Retail Sale Id 3392',19003.52,0.00,0.00,25.82,2736.92,'2023-03-01 19:27:31','',''),(3396,'1','307','1',1,'Retail Sale Id 3393',19459.84,0.00,0.00,26.44,2802.64,'2023-03-01 19:32:36','',''),(3397,'1','307','1',1,'Retail Sale Id 3394',46240.00,0.00,0.00,68.00,3400.00,'2023-03-02 07:19:09','',''),(3398,'1','307','1',1,'Retail Sale Id 3395',1501.44,0.00,0.00,2.04,216.24,'2023-03-02 07:37:32','',''),(3399,'1','307','1',1,'Retail Sale Id 3396',4416.00,0.00,0.00,6.00,636.00,'2023-03-02 08:35:12','',''),(3400,'1','307','1',1,'Retail Sale Id 3397',2259.52,0.00,0.00,3.07,325.42,'2023-03-02 08:55:06','',''),(3401,'1','307','1',1,'Retail Sale Id 3399',5152.00,0.00,0.00,7.00,742.00,'2023-03-02 08:58:07','',''),(3402,'1','307','1',1,'Retail Sale Id 3400',4496.96,0.00,0.00,6.11,647.66,'2023-03-02 09:12:25','',''),(3403,'1','307','1',1,'Retail Sale Id 3401',9200.00,0.00,0.00,12.50,1325.00,'2023-03-02 09:15:59','',''),(3404,'1','307','1',1,'Retail Sale Id 3402',4997.44,0.00,0.00,6.79,719.74,'2023-03-02 09:19:45','',''),(3405,'1','307','1',1,'Retail Sale Id 3403',1472.00,0.00,0.00,2.00,212.00,'2023-03-02 10:10:53','',''),(3406,'1','307','1',1,'Retail Sale Id 3404',1472.00,0.00,0.00,2.00,212.00,'2023-03-02 10:12:22','',''),(3407,'1','307','1',1,'Retail Sale Id 3405',736.00,0.00,0.00,1.00,106.00,'2023-03-02 10:13:22','',''),(3408,'1','307','1',1,'Retail Sale Id 3406',2200.64,0.00,0.00,2.99,316.94,'2023-03-02 10:14:38','',''),(3409,'1','307','1',1,'Retail Sale Id 3407',1501.44,0.00,0.00,2.04,216.24,'2023-03-02 10:15:25','',''),(3410,'1','307','1',1,'Retail Sale Id 3408',2001.92,0.00,0.00,2.72,288.32,'2023-03-02 10:16:20','',''),(3411,'1','307','1',1,'Retail Sale Id 3409',4416.00,0.00,0.00,6.00,636.00,'2023-03-02 10:19:56','',''),(3412,'1','307','1',1,'Retail Sale Id 3410',750.72,0.00,0.00,1.02,108.12,'2023-03-02 10:28:44','',''),(3413,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,1260000.00,2000.00,0.00,0.00,'2023-03-02 10:30:17','',''),(3414,'1','307','1',1,'Retail Sale Id 3411',2266.88,0.00,0.00,3.08,326.48,'2023-03-02 10:31:14','',''),(3415,'1','307',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,2000.00,0.00,'2023-03-02 10:31:22','',''),(3416,'1','307','1',1,'Received from bridging 18',0.00,0.00,2000.00,0.00,0.00,'2023-03-02 10:31:22','',''),(3417,'1','307','1',1,'Retail Sale Id 3412',2208.00,0.00,0.00,3.00,318.00,'2023-03-02 10:44:24','',''),(3418,'1','307','1',1,'Retail Sale Id 3413',2200.64,0.00,0.00,2.99,316.94,'2023-03-02 10:59:26','',''),(3419,'1','307','1',1,'Retail Sale Id 3415',11492.00,0.00,0.00,16.90,845.00,'2023-03-02 11:03:26','',''),(3420,'1','307','1',1,'Retail Sale Id 3416',9200.00,0.00,0.00,12.50,1325.00,'2023-03-02 11:24:32','',''),(3421,'1','307','1',1,'Retail Sale Id 3417',1472.00,0.00,0.00,2.00,212.00,'2023-03-02 11:29:06','',''),(3422,'1','307','1',1,'Retail Sale Id 3418',4416.00,0.00,0.00,6.00,636.00,'2023-03-02 11:33:32','',''),(3423,'1','307','1',1,'Retail Sale Id 3419',4496.96,0.00,0.00,6.11,647.66,'2023-03-02 11:41:08','',''),(3424,'1','307','1',1,'Retail Sale Id 3420',750.72,0.00,0.00,1.02,108.12,'2023-03-02 11:48:14','',''),(3425,'1','307','1',1,'Retail Sale Id 3421',3002.88,0.00,0.00,4.08,432.48,'2023-03-02 11:56:12','',''),(3426,'1','307','1',1,'Retail Sale Id 3422',9200.00,0.00,0.00,12.50,1325.00,'2023-03-02 12:01:48','',''),(3427,'1','307','1',1,'Retail Sale Id 3423',4416.00,0.00,0.00,6.00,636.00,'2023-03-02 12:07:36','',''),(3428,'1','307','1',1,'Retail Sale Id 3424',1000.96,0.00,0.00,1.36,144.16,'2023-03-02 12:13:18','',''),(3429,'1','307','1',1,'Retail Sale Id 3425',1501.44,0.00,0.00,2.04,216.24,'2023-03-02 12:23:51','',''),(3430,'1','307','1',1,'Retail Sale Id 3426',10348.16,0.00,0.00,14.06,1490.36,'2023-03-02 12:29:47','',''),(3431,'1','307','1',1,'Retail Sale Id 3427',9200.00,0.00,0.00,12.50,1325.00,'2023-03-02 13:32:02','',''),(3432,'1','307','1',1,'Retail Sale Id 3428',3002.88,0.00,0.00,4.08,432.48,'2023-03-02 13:34:48','',''),(3433,'1','307','1',1,'Retail Sale Id 3429',13196.48,0.00,0.00,17.93,1900.58,'2023-03-02 15:01:08','',''),(3434,'1','307','1',1,'Retail Sale Id 3430',3996.48,0.00,0.00,5.43,575.58,'2023-03-02 15:13:00','',''),(3435,'1','307','1',1,'Retail Sale Id 3431',2208.00,0.00,0.00,3.00,318.00,'2023-03-02 15:14:38','',''),(3436,'1','307','1',1,'Retail Sale Id 3432',2208.00,0.00,0.00,3.00,318.00,'2023-03-02 15:19:24','',''),(3437,'1','307','1',1,'Retail Sale Id 3433',802.24,0.00,0.00,1.09,115.54,'2023-03-02 18:34:15','',''),(3438,'1','307','1',1,'Retail Sale Id 3434',2200.64,0.00,0.00,2.99,316.94,'2023-03-02 18:35:38','',''),(3439,'1','307','1',1,'Retail Sale Id 3435',1501.44,0.00,0.00,2.04,216.24,'2023-03-02 18:37:21','',''),(3440,'1','307','1',1,'Retail Sale Id 3436',2208.00,0.00,0.00,3.00,318.00,'2023-03-02 18:38:39','',''),(3441,'1','307','1',1,'Retail Sale Id 3437',1501.44,0.00,0.00,2.04,216.24,'2023-03-02 18:41:22','',''),(3442,'1','307','1',1,'Retail Sale Id 3438',2001.92,0.00,0.00,2.72,288.32,'2023-03-02 18:43:11','',''),(3443,'1','307','1',1,'Retail Sale Id 3439',1898.88,0.00,0.00,2.58,273.48,'2023-03-02 18:49:55','',''),(3444,'1','307','1',1,'Retail Sale Id 3440',500.48,0.00,0.00,0.68,72.08,'2023-03-02 18:56:27','',''),(3445,'1','307','1',1,'Retail Sale Id 3441',3702.08,0.00,0.00,5.03,533.18,'2023-03-02 18:57:36','',''),(3446,'1','307','1',1,'Retail Sale Id 3442',23800.00,0.00,0.00,35.00,1750.00,'2023-03-02 19:06:58','',''),(3447,'1','307','1',1,'Retail Sale Id 3443',73848.00,0.00,0.00,108.60,5430.00,'2023-03-02 19:31:48','',''),(3448,'1','307','1',1,'Retail Sale Id 3444',22845.44,0.00,0.00,31.04,3290.24,'2023-03-02 19:34:43','',''),(3449,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,1745100.00,2770.00,0.00,0.00,'2023-03-02 19:44:23','',''),(3450,'1','307',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,2770.00,0.00,'2023-03-02 19:45:27','',''),(3451,'1','307','1',1,'Received from bridging 19',0.00,0.00,2770.00,0.00,0.00,'2023-03-02 19:45:27','',''),(3452,'1','307','1',1,'Retail Sale Id 3445',3680.00,0.00,0.00,5.00,530.00,'2023-03-03 07:39:59','',''),(3453,'1','307','1',1,'Retail Sale Id 3446',170000.00,0.00,0.00,250.00,12500.00,'2023-03-03 07:42:17','',''),(3454,'1','307','1',1,'Retail Sale Id 3447',2208.00,0.00,0.00,3.00,318.00,'2023-03-03 07:45:30','',''),(3455,'1','307','1',1,'Retail Sale Id 3448',9200.00,0.00,0.00,12.50,1325.00,'2023-03-03 08:05:22','',''),(3456,'1','307','1',1,'Retail Sale Id 3449',4416.00,0.00,0.00,6.00,636.00,'2023-03-03 08:08:59','',''),(3457,'1','307','1',1,'Retail Sale Id 3451',4496.96,0.00,0.00,6.11,647.66,'2023-03-03 08:22:51','',''),(3458,'1','307','1',1,'Retail Sale Id 3452',1501.44,0.00,0.00,2.04,216.24,'2023-03-03 08:25:45','',''),(3459,'1','307','1',1,'Retail Sale Id 3453',4997.44,0.00,0.00,6.79,719.74,'2023-03-03 08:27:30','',''),(3460,'1','307','1',1,'Retail Sale Id 3454',4416.00,0.00,0.00,6.00,636.00,'2023-03-03 08:29:42','',''),(3461,'1','307','1',1,'Retail Sale Id 3455',500.48,0.00,0.00,0.68,72.08,'2023-03-03 08:44:43','',''),(3462,'1','307','1',1,'Retail Sale Id 3456',68000.00,0.00,0.00,100.00,5000.00,'2023-03-03 08:47:27','',''),(3463,'1','307','1',1,'Retail Sale Id 3457',3002.88,0.00,0.00,4.08,432.48,'2023-03-03 08:50:17','',''),(3464,'1','307','1',1,'Retail Sale Id 3458',34000.00,0.00,0.00,50.00,2500.00,'2023-03-03 09:00:30','',''),(3465,'1','307','1',1,'Retail Sale Id 3459',2208.00,0.00,0.00,3.00,318.00,'2023-03-03 09:04:42','',''),(3466,'1','307','1',1,'Retail Sale Id 3460',1501.44,0.00,0.00,2.04,216.24,'2023-03-03 09:13:40','',''),(3467,'1','307','1',1,'Retail Sale Id 3462',3702.08,0.00,0.00,5.03,533.18,'2023-03-03 09:18:10','',''),(3468,'1','307','1',1,'Retail Sale Id 3463',3002.88,0.00,0.00,4.08,432.48,'2023-03-03 09:19:02','',''),(3469,'1','307','1',1,'Retail Sale Id 3464',2208.00,0.00,0.00,3.00,318.00,'2023-03-03 09:31:18','',''),(3470,'1','307','1',1,'Retail Sale Id 3465',2208.00,0.00,0.00,3.00,318.00,'2023-03-03 09:37:33','',''),(3471,'1','307','1',1,'Retail Sale Id 3466',8832.00,0.00,0.00,12.00,1272.00,'2023-03-03 09:43:02','',''),(3472,'1','307','1',1,'Retail Sale Id 3467',2944.00,0.00,0.00,4.00,424.00,'2023-03-03 09:46:02','',''),(3473,'1','307','1',1,'Retail Sale Id 3468',4496.96,0.00,0.00,6.11,647.66,'2023-03-03 10:05:32','',''),(3474,'1','307','1',1,'Retail Sale Id 3470',2208.00,0.00,0.00,3.00,318.00,'2023-03-03 10:18:04','',''),(3475,'1','307','1',1,'Retail Sale Id 3471',9200.00,0.00,0.00,12.50,1325.00,'2023-03-03 10:27:14','',''),(3476,'1','307','1',1,'Retail Sale Id 3472',2200.64,0.00,0.00,2.99,316.94,'2023-03-03 10:46:58','',''),(3477,'1','307','1',1,'Retail Sale Id 3473',7360.00,0.00,0.00,10.00,1060.00,'2023-03-03 10:52:29','',''),(3478,'1','307','1',1,'Retail Sale Id 3474',4416.00,0.00,0.00,6.00,636.00,'2023-03-03 11:19:00','',''),(3479,'1','307','1',1,'Retail Sale Id 3475',802.24,0.00,0.00,1.09,115.54,'2023-03-03 11:35:15','',''),(3480,'1','307','1',1,'Retail Sale Id 3476',2944.00,0.00,0.00,4.00,424.00,'2023-03-03 12:00:42','',''),(3481,'1','307','1',1,'Retail Sale Id 3477',2001.92,0.00,0.00,2.72,288.32,'2023-03-03 12:11:51','',''),(3482,'1','307','1',1,'Retail Sale Id 3478',1501.44,0.00,0.00,2.04,216.24,'2023-03-03 12:19:29','',''),(3483,'1','307','1',1,'Retail Sale Id 3479',1000.96,0.00,0.00,1.36,144.16,'2023-03-03 12:41:41','',''),(3484,'1','307','1',1,'Retail Sale Id 3480',9200.00,0.00,0.00,12.50,1325.00,'2023-03-03 13:01:46','',''),(3485,'1','307','1',1,'Retail Sale Id 3481',9200.00,0.00,0.00,12.50,1325.00,'2023-03-03 13:09:40','',''),(3486,'1','307','1',1,'Retail Sale Id 3482',2208.00,0.00,0.00,3.00,318.00,'2023-03-03 13:25:06','',''),(3487,'1','307','1',1,'Retail Sale Id 3483',3996.48,0.00,0.00,5.43,575.58,'2023-03-03 13:58:17','',''),(3488,'1','307','1',1,'Retail Sale Id 3484',4423.36,0.00,0.00,6.01,637.06,'2023-03-03 13:59:17','',''),(3489,'1','307','1',1,'Retail Sale Id 3485',802.24,0.00,0.00,1.09,115.54,'2023-03-03 14:54:18','',''),(3490,'1','307','1',1,'Retail Sale Id 3486',2252.16,0.00,0.00,3.06,324.36,'2023-03-03 14:56:03','',''),(3491,'1','307','1',1,'Retail Sale Id 3487',68000.00,0.00,0.00,100.00,5000.00,'2023-03-03 15:09:12','',''),(3492,'1','307','1',1,'Retail Sale Id 3488',8118.08,0.00,0.00,11.03,1169.18,'2023-03-03 15:14:27','',''),(3493,'1','307','1',1,'Retail Sale Id 3489',4452.80,0.00,0.00,6.05,641.30,'2023-03-03 15:23:38','',''),(3494,'1','307','1',1,'Retail Sale Id 3490',25458.24,0.00,0.00,34.59,3666.54,'2023-03-03 18:23:57','',''),(3495,'1','307','1',1,'Retail Sale Id 3491',9200.00,0.00,0.00,12.50,1325.00,'2023-03-03 18:44:16','',''),(3496,'1','307','1',1,'Retail Sale Id 3492',35386.88,0.00,0.00,48.08,5096.48,'2023-03-03 19:31:30','',''),(3497,'1','307','1',1,'Retail Sale Id 3493',2208.00,0.00,0.00,3.00,318.00,'2023-03-04 07:36:10','',''),(3498,'1','307','1',1,'Retail Sale Id 3494',3002.88,0.00,0.00,4.08,432.48,'2023-03-04 07:54:49','',''),(3499,'1','307','1',1,'Retail Sale Id 3495',1501.44,0.00,0.00,2.04,216.24,'2023-03-04 08:22:00','',''),(3500,'1','307','1',1,'Retail Sale Id 3496',7360.00,0.00,0.00,10.00,1060.00,'2023-03-04 08:34:57','',''),(3501,'1','307','1',1,'Retail Sale Id 3497',9200.00,0.00,0.00,12.50,1325.00,'2023-03-04 08:37:21','',''),(3502,'1','307','1',1,'Retail Sale Id 3498',34000.00,0.00,0.00,50.00,2500.00,'2023-03-04 08:38:28','',''),(3503,'1','307','1',1,'Retail Sale Id 3499',9200.00,0.00,0.00,12.50,1325.00,'2023-03-04 08:41:39','',''),(3504,'1','307','1',1,'Retail Sale Id 3500',3680.00,0.00,0.00,5.00,530.00,'2023-03-04 08:45:46','',''),(3505,'1','307','1',1,'Retail Sale Id 3501',2208.00,0.00,0.00,3.00,318.00,'2023-03-04 08:47:04','',''),(3506,'1','307','1',1,'Retail Sale Id 3502',4401.28,0.00,0.00,5.98,633.88,'2023-03-04 09:06:38','',''),(3507,'1','307','1',1,'Retail Sale Id 3503',34000.00,0.00,0.00,50.00,2500.00,'2023-03-04 09:09:13','',''),(3508,'1','307','1',1,'Retail Sale Id 3504',4416.00,0.00,0.00,6.00,636.00,'2023-03-04 09:21:10','',''),(3509,'1','307','1',1,'Retail Sale Id 3505',9200.00,0.00,0.00,12.50,1325.00,'2023-03-04 09:22:06','',''),(3510,'1','307','1',1,'Retail Sale Id 3506',2208.00,0.00,0.00,3.00,318.00,'2023-03-04 09:23:23','',''),(3511,'1','307','1',1,'Retail Sale Id 3507',3680.00,0.00,0.00,5.00,530.00,'2023-03-04 09:28:13','',''),(3512,'1','307','1',1,'Retail Sale Id 3508',8832.00,0.00,0.00,12.00,1272.00,'2023-03-04 09:36:01','',''),(3513,'1','307','1',1,'Retail Sale Id 3509',2208.00,0.00,0.00,3.00,318.00,'2023-03-04 09:36:57','',''),(3514,'1','307','1',1,'Retail Sale Id 3510',1501.44,0.00,0.00,2.04,216.24,'2023-03-04 09:38:13','',''),(3515,'1','307','1',1,'Retail Sale Id 3511',1501.44,0.00,0.00,2.04,216.24,'2023-03-04 09:39:05','',''),(3516,'1','307','1',1,'Retail Sale Id 3512',3680.00,0.00,0.00,5.00,530.00,'2023-03-04 09:43:38','',''),(3517,'1','307','1',1,'Retail Sale Id 3513',4416.00,0.00,0.00,6.00,636.00,'2023-03-04 09:46:28','',''),(3518,'1','307','1',1,'Retail Sale Id 3514',2208.00,0.00,0.00,3.00,318.00,'2023-03-04 09:54:57','',''),(3519,'1','307','1',1,'Retail Sale Id 3515',3680.00,0.00,0.00,5.00,530.00,'2023-03-04 10:11:41','',''),(3520,'1','307','1',1,'Retail Sale Id 3516',4496.96,0.00,0.00,6.11,647.66,'2023-03-04 10:23:24','',''),(3521,'1','307','1',1,'Retail Sale Id 3517',2208.00,0.00,0.00,3.00,318.00,'2023-03-04 10:26:44','',''),(3522,'1','307','1',1,'Retail Sale Id 3518',2208.00,0.00,0.00,3.00,318.00,'2023-03-04 10:40:19','',''),(3523,'1','307','1',1,'Retail Sale Id 3519',2208.00,0.00,0.00,3.00,318.00,'2023-03-04 10:52:19','',''),(3524,'1','307','1',1,'Retail Sale Id 3520',2208.00,0.00,0.00,3.00,318.00,'2023-03-04 10:53:00','',''),(3525,'1','307','1',1,'Retail Sale Id 3521',1501.44,0.00,0.00,2.04,216.24,'2023-03-04 10:53:51','',''),(3526,'1','307','1',1,'Retail Sale Id 3522',4416.00,0.00,0.00,6.00,636.00,'2023-03-04 10:56:43','',''),(3527,'1','307','1',1,'Retail Sale Id 3523',21501.60,0.00,0.00,31.62,1581.00,'2023-03-04 11:00:15','',''),(3528,'1','307','1',1,'Retail Sale Id 3524',3680.00,0.00,0.00,5.00,530.00,'2023-03-04 11:02:26','',''),(3529,'1','307','1',1,'Retail Sale Id 3525',1501.44,0.00,0.00,2.04,216.24,'2023-03-04 11:09:51','',''),(3530,'1','307','1',1,'Retail Sale Id 3526',1000.96,0.00,0.00,1.36,144.16,'2023-03-04 11:18:49','',''),(3531,'1','307','1',1,'Retail Sale Id 3528',2252.16,0.00,0.00,3.06,324.36,'2023-03-04 11:31:59','',''),(3532,'1','307','1',1,'Retail Sale Id 3530',2208.00,0.00,0.00,3.00,318.00,'2023-03-04 11:39:19','',''),(3533,'1','307','1',1,'Retail Sale Id 3532',9200.00,0.00,0.00,12.50,1325.00,'2023-03-04 11:50:21','',''),(3534,'1','307','1',1,'Retail Sale Id 3533',9200.00,0.00,0.00,12.50,1325.00,'2023-03-04 11:51:22','',''),(3535,'1','307','1',1,'Retail Sale Id 3534',3680.00,0.00,0.00,5.00,530.00,'2023-03-04 11:52:52','',''),(3536,'1','307','1',1,'Retail Sale Id 3535',500.48,0.00,0.00,0.68,72.08,'2023-03-04 11:53:42','',''),(3537,'1','307','1',1,'Retail Sale Id 3536',2208.00,0.00,0.00,3.00,318.00,'2023-03-04 12:14:29','',''),(3538,'1','307','1',1,'Retail Sale Id 3537',2944.00,0.00,0.00,4.00,424.00,'2023-03-04 12:32:18','',''),(3539,'1','307','1',1,'Retail Sale Id 3538',2944.00,0.00,0.00,4.00,424.00,'2023-03-04 12:34:27','',''),(3540,'1','307','1',1,'Retail Sale Id 3539',1501.44,0.00,0.00,2.04,216.24,'2023-03-04 12:39:26','',''),(3541,'1','307','1',1,'Retail Sale Id 3540',4416.00,0.00,0.00,6.00,636.00,'2023-03-04 13:33:19','',''),(3542,'1','307','1',1,'Retail Sale Id 3541',4423.36,0.00,0.00,6.01,637.06,'2023-03-04 14:17:47','',''),(3543,'1','307','1',1,'Retail Sale Id 3542',2208.00,0.00,0.00,3.00,318.00,'2023-03-04 14:18:57','',''),(3544,'1','307','1',1,'Retail Sale Id 3543',4423.36,0.00,0.00,6.01,637.06,'2023-03-04 14:53:21','',''),(3545,'1','307','1',1,'Retail Sale Id 3544',2951.36,0.00,0.00,4.01,425.06,'2023-03-04 15:03:53','',''),(3546,'1','307','1',1,'Retail Sale Id 3545',38501.60,0.00,0.00,56.62,2831.00,'2023-03-04 15:06:35','',''),(3547,'1','307','1',1,'Retail Sale Id 3546',1501.44,0.00,0.00,2.04,216.24,'2023-03-04 15:08:24','',''),(3548,'1','307','1',1,'Retail Sale Id 3547',16699.84,0.00,0.00,22.69,2405.14,'2023-03-04 15:12:41','',''),(3549,'1','307','1',1,'Retail Sale Id 3548',9200.00,0.00,0.00,12.50,1325.00,'2023-03-04 15:19:55','',''),(3550,'1','307','1',1,'Retail Sale Id 3549',2208.00,0.00,0.00,3.00,318.00,'2023-03-04 15:33:25','',''),(3551,'1','307','1',1,'Retail Sale Id 3550',2208.00,0.00,0.00,3.00,318.00,'2023-03-04 16:20:41','',''),(3552,'1','307','1',1,'Retail Sale Id 3551',13991.36,0.00,0.00,19.01,2015.06,'2023-03-04 16:22:07','',''),(3553,'1','307','1',1,'Retail Sale Id 3552',17303.36,0.00,0.00,23.51,2492.06,'2023-03-04 17:19:09','',''),(3554,'1','307','1',1,'Retail Sale Id 3553',170000.00,0.00,0.00,250.00,12500.00,'2023-03-04 17:43:21','',''),(3555,'1','307','1',1,'Retail Sale Id 3554',2208.00,0.00,0.00,3.00,318.00,'2023-03-04 17:58:01','',''),(3556,'1','307','1',1,'Retail Sale Id 3555',68000.00,0.00,0.00,100.00,5000.00,'2023-03-04 18:37:09','',''),(3557,'1','307','1',1,'Retail Sale Id 3556',26613.76,0.00,0.00,36.16,3832.96,'2023-03-04 18:44:25','',''),(3558,'1','307','1',1,'Retail Sale Id 3557',1000.96,0.00,0.00,1.36,144.16,'2023-03-05 07:45:50','',''),(3559,'1','307','1',1,'Retail Sale Id 3558',4423.36,0.00,0.00,6.01,637.06,'2023-03-05 08:06:15','',''),(3560,'1','307','1',1,'Retail Sale Id 3559',7360.00,0.00,0.00,10.00,1060.00,'2023-03-05 08:07:55','',''),(3561,'1','307','1',1,'Retail Sale Id 3560',1501.44,0.00,0.00,2.04,216.24,'2023-03-05 08:09:39','',''),(3562,'1','307','1',1,'Retail Sale Id 3561',2001.92,0.00,0.00,2.72,288.32,'2023-03-05 08:18:21','',''),(3563,'1','307','1',1,'Retail Sale Id 3562',4416.00,0.00,0.00,6.00,636.00,'2023-03-05 08:23:36','',''),(3564,'1','307','1',1,'Retail Sale Id 3563',4416.00,0.00,0.00,6.00,636.00,'2023-03-05 08:38:50','',''),(3565,'1','307','1',1,'Retail Sale Id 3564',9200.00,0.00,0.00,12.50,1325.00,'2023-03-05 08:41:49','',''),(3566,'1','307','1',1,'Retail Sale Id 3565',3002.88,0.00,0.00,4.08,432.48,'2023-03-05 08:55:30','',''),(3567,'1','307','1',1,'Retail Sale Id 3566',1501.44,0.00,0.00,2.04,216.24,'2023-03-05 09:03:56','',''),(3568,'1','307','1',1,'Retail Sale Id 3567',3002.88,0.00,0.00,4.08,432.48,'2023-03-05 09:23:18','',''),(3569,'1','307','1',1,'Retail Sale Id 3568',3996.48,0.00,0.00,5.43,575.58,'2023-03-05 09:25:35','',''),(3570,'1','307','1',1,'Retail Sale Id 3569',68000.00,0.00,0.00,100.00,5000.00,'2023-03-05 09:27:50','',''),(3571,'1','307','1',1,'Retail Sale Id 3570',2944.00,0.00,0.00,4.00,424.00,'2023-03-05 09:29:20','',''),(3572,'1','307','1',1,'Retail Sale Id 3571',3680.00,0.00,0.00,5.00,530.00,'2023-03-05 09:30:55','',''),(3573,'1','307','1',1,'Retail Sale Id 3572',3002.88,0.00,0.00,4.08,432.48,'2023-03-05 09:47:37','',''),(3574,'1','307','1',1,'Retail Sale Id 3573',750.72,0.00,0.00,1.02,108.12,'2023-03-05 09:58:12','',''),(3575,'1','307','1',1,'Retail Sale Id 3574',4416.00,0.00,0.00,6.00,636.00,'2023-03-05 10:16:37','',''),(3576,'1','307','1',1,'Retail Sale Id 3575',3680.00,0.00,0.00,5.00,530.00,'2023-03-05 10:18:00','',''),(3577,'1','307','1',1,'Retail Sale Id 3576',2502.40,0.00,0.00,3.40,360.40,'2023-03-05 10:21:40','',''),(3578,'1','307','1',1,'Retail Sale Id 3577',1472.00,0.00,0.00,2.00,212.00,'2023-03-05 10:29:57','',''),(3579,'1','307','1',1,'Retail Sale Id 3578',9200.00,0.00,0.00,12.50,1325.00,'2023-03-05 10:57:30','',''),(3580,'1','307','1',1,'Retail Sale Id 3579',2208.00,0.00,0.00,3.00,318.00,'2023-03-05 10:58:58','',''),(3581,'1','307','1',1,'Retail Sale Id 3580',106080.00,0.00,0.00,156.00,7800.00,'2023-03-05 11:03:17','',''),(3582,'1','307','1',1,'Retail Sale Id 3581',4416.00,0.00,0.00,6.00,636.00,'2023-03-05 11:05:46','',''),(3583,'1','307','1',1,'Retail Sale Id 3582',3680.00,0.00,0.00,5.00,530.00,'2023-03-05 11:10:08','',''),(3584,'1','307','1',1,'Retail Sale Id 3583',2208.00,0.00,0.00,3.00,318.00,'2023-03-05 11:13:30','',''),(3585,'1','307','1',1,'Retail Sale Id 3584',4496.96,0.00,0.00,6.11,647.66,'2023-03-05 11:18:12','',''),(3586,'1','307','1',1,'Retail Sale Id 3585',4416.00,0.00,0.00,6.00,636.00,'2023-03-05 11:24:16','',''),(3587,'1','307','1',1,'Retail Sale Id 3586',2944.00,0.00,0.00,4.00,424.00,'2023-03-05 11:25:30','',''),(3588,'1','307','1',1,'Retail Sale Id 3587',9200.00,0.00,0.00,12.50,1325.00,'2023-03-05 11:26:48','',''),(3589,'1','307','1',1,'Retail Sale Id 3588',2001.92,0.00,0.00,2.72,288.32,'2023-03-05 11:28:16','',''),(3590,'1','307','1',1,'Retail Sale Id 3589',7360.00,0.00,0.00,10.00,1060.00,'2023-03-05 11:30:47','',''),(3591,'1','307','1',1,'Retail Sale Id 3590',3680.00,0.00,0.00,5.00,530.00,'2023-03-05 11:34:26','',''),(3592,'1','307','1',1,'Retail Sale Id 3591',4496.96,0.00,0.00,6.11,647.66,'2023-03-05 11:42:14','',''),(3593,'1','307','1',1,'Retail Sale Id 3592',2208.00,0.00,0.00,3.00,318.00,'2023-03-05 11:44:36','',''),(3594,'1','307','1',1,'Retail Sale Id 3593',2208.00,0.00,0.00,3.00,318.00,'2023-03-05 11:52:52','',''),(3595,'1','307','1',1,'Retail Sale Id 3594',2944.00,0.00,0.00,4.00,424.00,'2023-03-05 12:07:05','',''),(3596,'1','307','1',1,'Retail Sale Id 3595',2252.16,0.00,0.00,3.06,324.36,'2023-03-05 12:15:58','',''),(3597,'1','307','1',1,'Retail Sale Id 3596',2208.00,0.00,0.00,3.00,318.00,'2023-03-05 12:27:30','',''),(3598,'1','307','1',1,'Retail Sale Id 3597',2208.00,0.00,0.00,3.00,318.00,'2023-03-05 12:29:50','',''),(3599,'1','307','1',1,'Retail Sale Id 3598',2208.00,0.00,0.00,3.00,318.00,'2023-03-05 12:32:48','',''),(3600,'1','307','1',1,'Retail Sale Id 3599',4416.00,0.00,0.00,6.00,636.00,'2023-03-05 12:34:49','',''),(3601,'1','307','1',1,'Retail Sale Id 3600',4416.00,0.00,0.00,6.00,636.00,'2023-03-05 12:50:25','',''),(3602,'1','307','1',1,'Retail Sale Id 3601',2001.92,0.00,0.00,2.72,288.32,'2023-03-05 13:11:49','',''),(3603,'1','307','1',1,'Retail Sale Id 3602',3680.00,0.00,0.00,5.00,530.00,'2023-03-05 13:41:42','',''),(3604,'1','307','1',1,'Retail Sale Id 3603',2208.00,0.00,0.00,3.00,318.00,'2023-03-05 13:53:06','',''),(3605,'1','307','1',1,'Retail Sale Id 3604',7389.44,0.00,0.00,10.04,1064.24,'2023-03-05 14:29:45','',''),(3606,'1','307','1',1,'Retail Sale Id 3605',750.72,0.00,0.00,1.02,108.12,'2023-03-05 14:33:11','',''),(3607,'1','307','1',1,'Retail Sale Id 3606',25303.68,0.00,0.00,34.38,3644.28,'2023-03-05 15:01:08','',''),(3608,'1','307','1',1,'Retail Sale Id 3607',9597.44,0.00,0.00,13.04,1382.24,'2023-03-05 15:10:47','',''),(3609,'1','307','1',1,'Retail Sale Id 3608',2951.36,0.00,0.00,4.01,425.06,'2023-03-05 15:13:36','',''),(3610,'1','307','1',1,'Retail Sale Id 3609',4423.36,0.00,0.00,6.01,637.06,'2023-03-05 15:49:12','',''),(3611,'1','307','1',1,'Retail Sale Id 3611',20585.92,0.00,0.00,27.97,2964.82,'2023-03-05 16:30:14','',''),(3612,'1','307','1',1,'Retail Sale Id 3612',34000.00,0.00,0.00,50.00,2500.00,'2023-03-05 16:31:33','',''),(3613,'1','307','1',1,'Retail Sale Id 3613',2001.92,0.00,0.00,2.72,288.32,'2023-03-05 16:38:41','',''),(3614,'1','307','1',1,'Retail Sale Id 3614',3996.48,0.00,0.00,5.43,575.58,'2023-03-05 16:40:39','',''),(3615,'1','307','1',1,'Retail Sale Id 3615',2208.00,0.00,0.00,3.00,318.00,'2023-03-05 16:45:57','',''),(3616,'1','307','1',1,'Retail Sale Id 3616',6727.04,0.00,0.00,9.14,968.84,'2023-03-05 17:02:49','',''),(3617,'1','307','1',1,'Retail Sale Id 3617',5203.52,0.00,0.00,7.07,749.42,'2023-03-05 17:11:42','',''),(3618,'1','307','1',1,'Retail Sale Id 3618',4423.36,0.00,0.00,6.01,637.06,'2023-03-05 17:13:41','',''),(3619,'1','307','1',1,'Retail Sale Id 3619',1000.96,0.00,0.00,1.36,144.16,'2023-03-05 17:34:36','',''),(3620,'1','307','1',1,'Retail Sale Id 3620',2001.92,0.00,0.00,2.72,288.32,'2023-03-05 17:37:30','',''),(3621,'1','307','1',1,'Retail Sale Id 3621',238000.00,0.00,0.00,350.00,17500.00,'2023-03-05 17:39:07','',''),(3622,'1','307','1',1,'Retail Sale Id 3622',2001.92,0.00,0.00,2.72,288.32,'2023-03-05 18:18:37','',''),(3623,'1','307','1',1,'Retail Sale Id 3623',4423.36,0.00,0.00,6.01,637.06,'2023-03-05 18:22:10','',''),(3624,'1','307','1',1,'Retail Sale Id 3624',2001.92,0.00,0.00,2.72,288.32,'2023-03-05 18:24:46','',''),(3625,'1','307','1',1,'Retail Sale Id 3625',2951.36,0.00,0.00,4.01,425.06,'2023-03-05 18:26:16','',''),(3626,'1','307','1',1,'Retail Sale Id 3626',47530.88,0.00,0.00,64.58,6845.48,'2023-03-05 18:53:13','',''),(3627,'1','307','1',1,'Retail Sale Id 3627',2208.00,0.00,0.00,3.00,318.00,'2023-03-06 07:32:00','',''),(3628,'1','307','1',1,'Retail Sale Id 3628',1472.00,0.00,0.00,2.00,212.00,'2023-03-06 07:33:30','',''),(3629,'1','307','1',1,'Retail Sale Id 3629',9200.00,0.00,0.00,12.50,1325.00,'2023-03-06 07:34:58','',''),(3630,'1','307','1',1,'Retail Sale Id 3630',2208.00,0.00,0.00,3.00,318.00,'2023-03-06 07:36:17','',''),(3631,'1','307','1',1,'Retail Sale Id 3631',1501.44,0.00,0.00,2.04,216.24,'2023-03-06 07:46:33','',''),(3632,'1','307','1',1,'Retail Sale Id 3632',2502.40,0.00,0.00,3.40,360.40,'2023-03-06 08:15:13','',''),(3633,'1','307','1',1,'Retail Sale Id 3633',3680.00,0.00,0.00,5.00,530.00,'2023-03-06 08:21:12','',''),(3634,'1','307','1',1,'Retail Sale Id 3634',1501.44,0.00,0.00,2.04,216.24,'2023-03-06 08:24:09','',''),(3635,'1','307','1',1,'Retail Sale Id 3635',2944.00,0.00,0.00,4.00,424.00,'2023-03-06 08:36:24','',''),(3636,'1','307','1',1,'Retail Sale Id 3636',7418.88,0.00,0.00,10.08,1068.48,'2023-03-06 08:38:00','',''),(3637,'1','307','1',1,'Retail Sale Id 3637',4416.00,0.00,0.00,6.00,636.00,'2023-03-06 08:44:15','',''),(3638,'1','307','1',1,'Retail Sale Id 3638',2200.64,0.00,0.00,2.99,316.94,'2023-03-06 08:54:33','',''),(3639,'1','307','1',1,'Retail Sale Id 3639',2944.00,0.00,0.00,4.00,424.00,'2023-03-06 09:09:32','',''),(3640,'1','307','1',1,'Retail Sale Id 3640',2208.00,0.00,0.00,3.00,318.00,'2023-03-06 09:11:09','',''),(3641,'1','307','1',1,'Retail Sale Id 3641',34000.00,0.00,0.00,50.00,2500.00,'2023-03-06 09:24:05','',''),(3642,'1','307','1',1,'Retail Sale Id 3642',2944.00,0.00,0.00,4.00,424.00,'2023-03-06 09:52:40','',''),(3643,'1','307','1',1,'Retail Sale Id 3643',2001.92,0.00,0.00,2.72,288.32,'2023-03-06 10:10:00','',''),(3644,'1','307','1',1,'Retail Sale Id 3644',3680.00,0.00,0.00,5.00,530.00,'2023-03-06 10:48:00','',''),(3645,'1','307','1',1,'Retail Sale Id 3645',1000.96,0.00,0.00,1.36,144.16,'2023-03-06 10:48:48','',''),(3646,'1','307','1',1,'Retail Sale Id 3646',9200.00,0.00,0.00,12.50,1325.00,'2023-03-06 11:09:30','',''),(3647,'1','307','1',1,'Retail Sale Id 3647',3002.88,0.00,0.00,4.08,432.48,'2023-03-06 11:47:10','',''),(3648,'1','307','1',1,'Retail Sale Id 3648',2944.00,0.00,0.00,4.00,424.00,'2023-03-06 12:59:35','',''),(3649,'1','307','1',1,'Retail Sale Id 3649',12210.24,0.00,0.00,16.59,1758.54,'2023-03-06 13:30:49','',''),(3650,'1','307','1',1,'Retail Sale Id 3650',64260.00,0.00,0.00,94.50,4725.00,'2023-03-06 15:00:09','',''),(3651,'1','307','1',1,'Retail Sale Id 3651',1501.44,0.00,0.00,2.04,216.24,'2023-03-06 16:15:49','',''),(3652,'1','307','1',1,'Retail Sale Id 3652',5917.44,0.00,0.00,8.04,852.24,'2023-03-06 16:17:06','',''),(3653,'1','307','1',1,'Retail Sale Id 3653',7360.00,0.00,0.00,10.00,1060.00,'2023-03-06 16:30:34','',''),(3654,'1','307','1',1,'Retail Sale Id 3654',3680.00,0.00,0.00,5.00,530.00,'2023-03-06 16:40:41','',''),(3655,'1','307','1',1,'Retail Sale Id 3655',4423.36,0.00,0.00,6.01,637.06,'2023-03-06 16:50:26','',''),(3656,'1','307','1',1,'Retail Sale Id 3656',23147.20,0.00,0.00,31.45,3333.70,'2023-03-06 17:45:34','',''),(3657,'1','307','1',1,'Retail Sale Id 3657',2208.00,0.00,0.00,3.00,318.00,'2023-03-06 17:48:06','',''),(3658,'1','307','1',1,'Retail Sale Id 3658',10348.16,0.00,0.00,14.06,1490.36,'2023-03-06 18:06:53','',''),(3659,'1','307','1',1,'Retail Sale Id 3659',1597.12,0.00,0.00,2.17,230.02,'2023-03-06 18:12:38','',''),(3660,'1','307','1',1,'Retail Sale Id 3660',7360.00,0.00,0.00,10.00,1060.00,'2023-03-06 18:17:07','',''),(3661,'1','307','1',1,'Retail Sale Id 3661',2208.00,0.00,0.00,3.00,318.00,'2023-03-06 18:19:05','',''),(3662,'1','307','1',1,'Retail Sale Id 3662',1501.44,0.00,0.00,2.04,216.24,'2023-03-06 18:20:59','',''),(3663,'1','307','1',1,'Retail Sale Id 3663',5917.44,0.00,0.00,8.04,852.24,'2023-03-06 18:28:59','',''),(3664,'1','307','1',1,'Retail Sale Id 3664',2208.00,0.00,0.00,3.00,318.00,'2023-03-06 18:33:59','',''),(3665,'1','307','1',1,'Retail Sale Id 3665',21020.16,0.00,0.00,28.56,3027.36,'2023-03-06 18:43:23','',''),(3666,'1','307','1',1,'Retail Sale Id 3666',1597.12,0.00,0.00,2.17,230.02,'2023-03-07 07:36:56','',''),(3667,'1','307','1',1,'Retail Sale Id 3667',2944.00,0.00,0.00,4.00,424.00,'2023-03-07 07:39:31','',''),(3668,'1','307','1',1,'Retail Sale Id 3668',34000.00,0.00,0.00,50.00,2500.00,'2023-03-07 07:53:40','',''),(3669,'1','307','1',1,'Retail Sale Id 3669',9200.00,0.00,0.00,12.50,1325.00,'2023-03-07 08:18:45','',''),(3670,'1','307','1',1,'Retail Sale Id 3670',2944.00,0.00,0.00,4.00,424.00,'2023-03-07 08:25:19','',''),(3671,'1','307','1',1,'Retail Sale Id 3671',736.00,0.00,0.00,1.00,106.00,'2023-03-07 08:32:50','',''),(3672,'1','307','1',1,'Retail Sale Id 3672',2208.00,0.00,0.00,3.00,318.00,'2023-03-07 08:49:34','',''),(3673,'1','307','1',1,'Retail Sale Id 3673',1472.00,0.00,0.00,2.00,212.00,'2023-03-07 09:02:12','',''),(3674,'1','307','1',1,'Retail Sale Id 3674',178500.00,0.00,0.00,262.50,13125.00,'2023-03-07 09:30:22','',''),(3675,'1','307','1',1,'Retail Sale Id 3675',3680.00,0.00,0.00,5.00,530.00,'2023-03-07 10:04:19','',''),(3676,'1','307','1',1,'Retail Sale Id 3676',3996.48,0.00,0.00,5.43,575.58,'2023-03-07 10:20:30','',''),(3677,'1','307','1',1,'Retail Sale Id 3677',1000.96,0.00,0.00,1.36,144.16,'2023-03-07 10:21:19','',''),(3678,'1','307','1',1,'Retail Sale Id 3678',2200.64,0.00,0.00,2.99,316.94,'2023-03-07 10:31:01','',''),(3679,'1','307','1',1,'Retail Sale Id 3679',2208.00,0.00,0.00,3.00,318.00,'2023-03-07 10:36:41','',''),(3680,'1','307','1',1,'Retail Sale Id 3680',1000.96,0.00,0.00,1.36,144.16,'2023-03-07 11:36:37','',''),(3681,'1','307','1',1,'Retail Sale Id 3681',2944.00,0.00,0.00,4.00,424.00,'2023-03-07 12:00:52','',''),(3682,'1','307','1',1,'Retail Sale Id 3682',750.72,0.00,0.00,1.02,108.12,'2023-03-07 12:05:12','',''),(3683,'1','307','1',1,'Retail Sale Id 3683',4416.00,0.00,0.00,6.00,636.00,'2023-03-07 12:44:46','',''),(3684,'1','307','1',1,'Retail Sale Id 3684',2208.00,0.00,0.00,3.00,318.00,'2023-03-07 12:58:16','',''),(3685,'1','307','1',1,'Retail Sale Id 3685',4416.00,0.00,0.00,6.00,636.00,'2023-03-07 13:05:37','',''),(3686,'1','307','1',1,'Retail Sale Id 3686',4416.00,0.00,0.00,6.00,636.00,'2023-03-07 13:36:47','',''),(3687,'1','307','1',1,'Retail Sale Id 3687',34000.00,0.00,0.00,50.00,2500.00,'2023-03-07 13:37:53','',''),(3688,'1','307','1',1,'Retail Sale Id 3688',3680.00,0.00,0.00,5.00,530.00,'2023-03-07 14:02:43','',''),(3689,'1','307','1',1,'Retail Sale Id 3689',1472.00,0.00,0.00,2.00,212.00,'2023-03-07 14:53:03','',''),(3690,'1','307','1',1,'Retail Sale Id 3690',2001.92,0.00,0.00,2.72,288.32,'2023-03-07 14:55:31','',''),(3691,'1','307','1',1,'Retail Sale Id 3691',4452.80,0.00,0.00,6.05,641.30,'2023-03-07 15:18:37','',''),(3692,'1','307','1',1,'Retail Sale Id 3692',3002.88,0.00,0.00,4.08,432.48,'2023-03-07 15:35:58','',''),(3693,'1','307','1',1,'Retail Sale Id 3693',8103.36,0.00,0.00,11.01,1167.06,'2023-03-07 15:38:17','',''),(3694,'1','307','1',1,'Retail Sale Id 3694',14197.44,0.00,0.00,19.29,2044.74,'2023-03-07 15:54:13','',''),(3695,'1','307','1',1,'Retail Sale Id 3695',4416.00,0.00,0.00,6.00,636.00,'2023-03-07 16:02:31','',''),(3696,'1','307','1',1,'Retail Sale Id 3696',5998.40,0.00,0.00,8.15,863.90,'2023-03-07 16:06:32','',''),(3697,'1','307','1',1,'Retail Sale Id 3697',2200.64,0.00,0.00,2.99,316.94,'2023-03-07 16:46:51','',''),(3698,'1','307','1',1,'Retail Sale Id 3698',2951.36,0.00,0.00,4.01,425.06,'2023-03-07 16:49:37','',''),(3699,'1','307','1',1,'Retail Sale Id 3699',13696.96,0.00,0.00,18.61,1972.66,'2023-03-07 16:53:23','',''),(3700,'1','307','1',1,'Retail Sale Id 3700',4423.36,0.00,0.00,6.01,637.06,'2023-03-07 16:56:20','',''),(3701,'1','307','1',1,'Retail Sale Id 3701',2951.36,0.00,0.00,4.01,425.06,'2023-03-07 17:00:15','',''),(3702,'1','307','1',1,'Retail Sale Id 3702',2208.00,0.00,0.00,3.00,318.00,'2023-03-07 17:56:00','',''),(3703,'1','307','1',1,'Retail Sale Id 3703',2222.72,0.00,0.00,3.02,320.12,'2023-03-07 17:58:30','',''),(3704,'1','307','1',1,'Retail Sale Id 3704',2951.36,0.00,0.00,4.01,425.06,'2023-03-07 18:00:15','',''),(3705,'1','307','1',1,'Retail Sale Id 3705',1501.44,0.00,0.00,2.04,216.24,'2023-03-07 18:01:34','',''),(3706,'1','307','1',1,'Retail Sale Id 3706',4496.96,0.00,0.00,6.11,647.66,'2023-03-07 18:10:55','',''),(3707,'1','307','1',1,'Retail Sale Id 3707',2951.36,0.00,0.00,4.01,425.06,'2023-03-07 18:29:56','',''),(3708,'1','307','1',1,'Retail Sale Id 3708',56767.68,0.00,0.00,77.13,8175.78,'2023-03-07 18:57:10','',''),(3709,'1','307','1',1,'Retail Sale Id 3709',4496.96,0.00,0.00,6.11,647.66,'2023-03-08 07:26:14','',''),(3710,'1','307','1',1,'Retail Sale Id 3710',4416.00,0.00,0.00,6.00,636.00,'2023-03-08 07:29:07','',''),(3711,'1','307','1',1,'Retail Sale Id 3711',1501.44,0.00,0.00,2.04,216.24,'2023-03-08 07:32:43','',''),(3712,'1','307','1',1,'Retail Sale Id 3712',3002.88,0.00,0.00,4.08,432.48,'2023-03-08 07:34:03','',''),(3713,'1','307','1',1,'Retail Sale Id 3713',2944.00,0.00,0.00,4.00,424.00,'2023-03-08 07:55:04','',''),(3714,'1','307','1',1,'Retail Sale Id 3714',7360.00,0.00,0.00,10.00,1060.00,'2023-03-08 08:01:36','',''),(3715,'1','307','1',1,'Retail Sale Id 3715',4416.00,0.00,0.00,6.00,636.00,'2023-03-08 08:39:33','',''),(3716,'1','307','1',1,'Retail Sale Id 3716',2200.64,0.00,0.00,2.99,316.94,'2023-03-08 09:01:19','',''),(3717,'1','307','1',1,'Retail Sale Id 3717',68000.00,0.00,0.00,100.00,5000.00,'2023-03-08 09:08:16','',''),(3718,'1','307','1',1,'Retail Sale Id 3718',3002.88,0.00,0.00,4.08,432.48,'2023-03-08 09:12:10','',''),(3719,'1','307','1',1,'Retail Sale Id 3719',1501.44,0.00,0.00,2.04,216.24,'2023-03-08 09:13:34','',''),(3720,'1','307','1',1,'Retail Sale Id 3720',2208.00,0.00,0.00,3.00,318.00,'2023-03-08 09:20:28','',''),(3721,'1','307','1',1,'Retail Sale Id 3721',4416.00,0.00,0.00,6.00,636.00,'2023-03-08 09:25:09','',''),(3722,'1','307','1',1,'Retail Sale Id 3722',4416.00,0.00,0.00,6.00,636.00,'2023-03-08 09:31:26','',''),(3723,'1','307','1',1,'Retail Sale Id 3723',4416.00,0.00,0.00,6.00,636.00,'2023-03-08 09:33:28','',''),(3724,'1','307','1',1,'Retail Sale Id 3724',1472.00,0.00,0.00,2.00,212.00,'2023-03-08 09:35:52','',''),(3725,'1','307','1',1,'Retail Sale Id 3725',4416.00,0.00,0.00,6.00,636.00,'2023-03-08 09:46:46','',''),(3726,'1','307','1',1,'Retail Sale Id 3726',68000.00,0.00,0.00,100.00,5000.00,'2023-03-08 09:55:08','',''),(3727,'1','307','1',1,'Retail Sale Id 3727',4416.00,0.00,0.00,6.00,636.00,'2023-03-08 09:56:40','',''),(3728,'1','307','1',1,'Retail Sale Id 3728',170000.00,0.00,0.00,250.00,12500.00,'2023-03-08 10:27:11','',''),(3729,'1','307','1',1,'Retail Sale Id 3729',4416.00,0.00,0.00,6.00,636.00,'2023-03-08 10:41:00','',''),(3730,'1','307','1',1,'Retail Sale Id 3730',2208.00,0.00,0.00,3.00,318.00,'2023-03-08 10:42:47','',''),(3731,'1','307','1',1,'Retail Sale Id 3731',4416.00,0.00,0.00,6.00,636.00,'2023-03-08 10:44:18','',''),(3732,'1','307','1',1,'Retail Sale Id 3732',2208.00,0.00,0.00,3.00,318.00,'2023-03-08 10:46:39','',''),(3733,'1','307','1',1,'Retail Sale Id 3733',2208.00,0.00,0.00,3.00,318.00,'2023-03-08 10:50:01','',''),(3734,'1','307','1',1,'Retail Sale Id 3734',27200.00,0.00,0.00,40.00,2000.00,'2023-03-08 10:53:43','',''),(3735,'1','307','1',1,'Retail Sale Id 3735',1472.00,0.00,0.00,2.00,212.00,'2023-03-08 11:24:54','',''),(3736,'1','307','1',1,'Retail Sale Id 3736',2208.00,0.00,0.00,3.00,318.00,'2023-03-08 11:31:42','',''),(3737,'1','307','1',1,'Retail Sale Id 3737',9200.00,0.00,0.00,12.50,1325.00,'2023-03-08 11:57:19','',''),(3738,'1','307','1',1,'Retail Sale Id 3738',2944.00,0.00,0.00,4.00,424.00,'2023-03-08 11:59:40','',''),(3739,'1','307','1',1,'Retail Sale Id 3739',9200.00,0.00,0.00,12.50,1325.00,'2023-03-08 12:00:59','',''),(3740,'1','307','1',1,'Retail Sale Id 3740',16302.40,0.00,0.00,22.15,2347.90,'2023-03-08 12:09:38','',''),(3741,'1','307','1',1,'Retail Sale Id 3742',7360.00,0.00,0.00,10.00,1060.00,'2023-03-08 12:36:18','',''),(3742,'1','307','1',1,'Retail Sale Id 3743',7889.92,0.00,0.00,10.72,1136.32,'2023-03-08 12:39:15','',''),(3743,'1','307','1',1,'Retail Sale Id 3744',34000.00,0.00,0.00,50.00,2500.00,'2023-03-08 12:42:39','',''),(3744,'1','307','1',1,'Retail Sale Id 3745',34000.00,0.00,0.00,50.00,2500.00,'2023-03-08 12:57:33','',''),(3745,'1','307','1',1,'Return of Retail Sale Id 3742',0.00,7360.00,10.00,0.00,-1060.00,'2023-03-08 13:20:16','',''),(3746,'1','307','1',1,'Retail Sale Id 3746',2708.48,0.00,0.00,3.68,390.08,'2023-03-08 13:22:57','',''),(3747,'1','307','1',1,'Return of Retail Sale Id 3745',0.00,34000.00,50.00,0.00,-2500.00,'2023-03-08 13:30:24','',''),(3748,'1','307','1',1,'Return of Retail Sale Id 3744',0.00,34000.00,50.00,0.00,-2500.00,'2023-03-08 13:31:57','',''),(3749,'1','307','1',1,'Retail Sale Id 3747',18475.60,0.00,0.00,27.17,1358.50,'2023-03-08 13:37:25','',''),(3750,'1','307','1',1,'Retail Sale Id 3748',1641.28,0.00,0.00,2.23,236.38,'2023-03-08 13:41:13','',''),(3751,'1','307','1',1,'Distributed to Operational lost for sales id:6',73533.60,0.00,0.00,116.72,0.00,'2023-03-08 13:52:40','',''),(3752,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,1248000.00,2000.00,0.00,0.00,'2023-03-08 17:53:51','',''),(3753,'1','307',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,2000.00,0.00,'2023-03-08 17:55:06','',''),(3754,'1','307','1',1,'Received from bridging 20',0.00,0.00,2000.00,0.00,0.00,'2023-03-08 17:55:06','',''),(3755,'1','307','1',1,'Retail Sale Id 3749',700.00,0.00,0.00,1.00,76.00,'2023-03-08 18:00:14','',''),(3756,'1','307','1',1,'Retail Sale Id 3750',3997.00,0.00,0.00,5.71,433.96,'2023-03-08 18:03:50','',''),(3757,'1','307','1',1,'Retail Sale Id 3752',9200.00,0.00,0.00,12.50,1400.00,'2023-03-08 18:13:15','',''),(3758,'1','307','1',1,'Retail Sale Id 3753',1501.44,0.00,0.00,2.04,228.48,'2023-03-08 18:15:06','',''),(3759,'1','307','1',1,'Retail Sale Id 3754',1501.44,0.00,0.00,2.04,228.48,'2023-03-08 18:16:36','',''),(3760,'1','307','1',1,'Retail Sale Id 3756',20400.00,0.00,0.00,30.00,1680.00,'2023-03-08 18:20:25','',''),(3761,'1','307','1',1,'Retail Sale Id 3757',51000.00,0.00,0.00,75.00,4200.00,'2023-03-08 18:22:06','',''),(3762,'1','307','1',1,'Retail Sale Id 3758',34000.00,0.00,0.00,50.00,2800.00,'2023-03-08 18:25:06','',''),(3763,'1','307','1',1,'Retail Sale Id 3759',27960.64,0.00,0.00,37.99,4254.88,'2023-03-08 18:30:00','',''),(3764,'1','307','1',1,'Retail Sale Id 3761',9200.00,0.00,0.00,12.50,1400.00,'2023-03-08 18:40:33','',''),(3765,'1','307','1',1,'Retail Sale Id 3762',1501.44,0.00,0.00,2.04,228.48,'2023-03-08 18:42:58','',''),(3766,'1','307','1',1,'Retail Sale Id 3763',32464.96,0.00,0.00,44.11,4940.32,'2023-03-08 19:41:14','',''),(3767,'1','307','1',1,'Return of Retail Sale Id 3749',0.00,700.00,1.00,0.00,-76.00,'2023-03-08 19:53:30','',''),(3768,'1','307','1',1,'Return of Retail Sale Id 3758',0.00,34000.00,50.00,0.00,-2800.00,'2023-03-08 19:56:24','',''),(3769,'1','307','1',1,'Return of Retail Sale Id 3757',0.00,51000.00,75.00,0.00,-4200.00,'2023-03-08 19:57:37','',''),(3770,'1','307','1',1,'Return of Retail Sale Id 3756',0.00,20400.00,30.00,0.00,-1680.00,'2023-03-08 19:58:14','',''),(3771,'1','307','1',1,'Retail Sale Id 3764',32900.00,0.00,0.00,50.00,1700.00,'2023-03-08 20:05:12','',''),(3772,'1','307','1',1,'Retail Sale Id 3765',69090.00,0.00,0.00,105.00,3570.00,'2023-03-08 20:06:29','',''),(3773,'1','307','1',1,'Return of Retail Sale Id 3763',0.00,32464.96,44.11,0.00,-4940.32,'2023-03-08 20:07:32','',''),(3774,'1','307','1',1,'Retail Sale Id 3766',29085.00,0.00,0.00,41.55,3157.80,'2023-03-08 20:09:50','',''),(3775,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,1809600.00,2900.00,0.00,0.00,'2023-03-09 10:05:08','',''),(3776,'1','307',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,2900.00,0.00,'2023-03-09 10:06:10','',''),(3777,'1','307','1',1,'Received from bridging 21',0.00,0.00,2900.00,0.00,0.00,'2023-03-09 10:06:10','',''),(3778,'1','307','1',1,'Retail Sale Id 3767',5712.00,0.00,0.00,8.16,620.16,'2023-03-09 11:58:52','',''),(3779,'1','307','1',1,'Retail Sale Id 3768',36190.00,0.00,0.00,55.00,1870.00,'2023-03-09 11:59:25','',''),(3780,'1','307','1',1,'Retail Sale Id 3769',8750.00,0.00,0.00,12.50,950.00,'2023-03-09 13:25:06','',''),(3781,'1','307','1',1,'Retail Sale Id 3770',3500.00,0.00,0.00,5.00,380.00,'2023-03-09 13:28:27','',''),(3782,'1','307','1',1,'Retail Sale Id 3771',2100.00,0.00,0.00,3.00,228.00,'2023-03-09 13:34:42','',''),(3783,'1','307','1',1,'Retail Sale Id 3772',2100.00,0.00,0.00,3.00,228.00,'2023-03-09 13:35:46','',''),(3784,'1','307','1',1,'Retail Sale Id 3773',2100.00,0.00,0.00,3.00,228.00,'2023-03-09 13:43:23','',''),(3785,'1','307','1',1,'Retail Sale Id 3774',4200.00,0.00,0.00,6.00,456.00,'2023-03-09 13:51:24','',''),(3786,'1','307','1',1,'Retail Sale Id 3775',3500.00,0.00,0.00,5.00,380.00,'2023-03-09 13:52:52','',''),(3787,'1','307','1',1,'Retail Sale Id 3776',4200.00,0.00,0.00,6.00,456.00,'2023-03-09 14:01:36','',''),(3788,'1','307','1',1,'Retail Sale Id 3777',3500.00,0.00,0.00,5.00,380.00,'2023-03-09 14:02:51','',''),(3789,'1','307','1',1,'Retail Sale Id 3778',1400.00,0.00,0.00,2.00,152.00,'2023-03-09 14:05:43','',''),(3790,'1','307','1',1,'Retail Sale Id 3779',2100.00,0.00,0.00,3.00,228.00,'2023-03-09 14:10:13','',''),(3791,'1','307','1',1,'Retail Sale Id 3780',2100.00,0.00,0.00,3.00,228.00,'2023-03-09 14:11:01','',''),(3792,'1','307','1',1,'Retail Sale Id 3781',4200.00,0.00,0.00,6.00,456.00,'2023-03-09 14:18:32','',''),(3793,'1','307','1',1,'Retail Sale Id 3782',1400.00,0.00,0.00,2.00,152.00,'2023-03-09 14:25:15','',''),(3794,'1','307','1',1,'Retail Sale Id 3783',1400.00,0.00,0.00,2.00,152.00,'2023-03-09 14:28:37','',''),(3795,'1','307','1',1,'Retail Sale Id 3784',798.00,0.00,0.00,1.14,86.64,'2023-03-09 14:49:04','',''),(3796,'1','307','1',1,'Retail Sale Id 3785',24899.00,0.00,0.00,35.57,2703.32,'2023-03-09 15:42:54','',''),(3797,'1','307','1',1,'Retail Sale Id 3786',25004.00,0.00,0.00,38.00,1292.00,'2023-03-09 16:37:30','',''),(3798,'1','307','1',1,'Retail Sale Id 3787',19250.00,0.00,0.00,27.50,2090.00,'2023-03-09 16:39:59','',''),(3799,'1','307','1',1,'Retail Sale Id 3788',65800.00,0.00,0.00,100.00,3400.00,'2023-03-09 16:41:02','',''),(3800,'1','307','1',1,'Retail Sale Id 3789',32900.00,0.00,0.00,50.00,1700.00,'2023-03-09 16:43:22','',''),(3801,'1','307','1',1,'Retail Sale Id 3790',14700.00,0.00,0.00,21.00,1596.00,'2023-03-09 16:55:53','',''),(3802,'1','307','1',1,'Retail Sale Id 3791',65800.00,0.00,0.00,100.00,3400.00,'2023-03-09 17:03:44','',''),(3803,'1','307','1',1,'Retail Sale Id 3792',2100.00,0.00,0.00,3.00,228.00,'2023-03-09 17:11:22','',''),(3804,'1','307','1',1,'Retail Sale Id 3793',700.00,0.00,0.00,1.00,76.00,'2023-03-09 17:14:14','',''),(3805,'1','307','1',1,'Retail Sale Id 3793',4200.00,0.00,0.00,6.00,456.00,'2023-03-09 17:14:14','',''),(3806,'1','307','1',1,'Retail Sale Id 3794',1400.00,0.00,0.00,2.00,152.00,'2023-03-09 17:22:25','',''),(3807,'1','307','1',1,'Retail Sale Id 3795',1498.00,0.00,0.00,2.14,162.64,'2023-03-09 17:24:15','',''),(3808,'1','307','1',1,'Retail Sale Id 3796',3500.00,0.00,0.00,5.00,380.00,'2023-03-09 17:26:30','',''),(3809,'1','307','1',1,'Retail Sale Id 3797',3997.00,0.00,0.00,5.71,433.96,'2023-03-09 17:28:19','',''),(3810,'1','307','1',1,'Retail Sale Id 3798',2800.00,0.00,0.00,4.00,304.00,'2023-03-09 17:31:04','',''),(3811,'1','307','1',1,'Retail Sale Id 3799',5600.00,0.00,0.00,8.00,608.00,'2023-03-09 17:32:55','',''),(3812,'1','307','1',1,'Retail Sale Id 3800',65800.00,0.00,0.00,100.00,3400.00,'2023-03-09 17:35:09','',''),(3813,'1','307','1',1,'Retail Sale Id 3801',4200.00,0.00,0.00,6.00,456.00,'2023-03-09 17:37:56','',''),(3814,'1','307','1',1,'Retail Sale Id 3802',2100.00,0.00,0.00,3.00,228.00,'2023-03-09 17:40:36','',''),(3815,'1','307','1',1,'Retail Sale Id 3803',13097.00,0.00,0.00,18.71,1421.96,'2023-03-09 17:56:37','',''),(3816,'1','307','1',1,'Retail Sale Id 3804',19740.00,0.00,0.00,30.00,1020.00,'2023-03-09 17:58:31','',''),(3817,'1','307','1',1,'Retail Sale Id 3805',4200.00,0.00,0.00,6.00,456.00,'2023-03-09 17:59:27','',''),(3818,'1','307','1',1,'Retail Sale Id 3806',15652.00,0.00,0.00,22.36,1699.36,'2023-03-09 18:29:13','',''),(3819,'1','307','1',1,'Retail Sale Id 3807',15652.00,0.00,0.00,22.36,1699.36,'2023-03-09 18:30:18','',''),(3820,'1','307','1',1,'Retail Sale Id 3808',15134.00,0.00,0.00,21.62,1643.12,'2023-03-09 18:47:58','',''),(3821,'1','307','1',1,'Retail Sale Id 3809',2100.00,0.00,0.00,3.00,228.00,'2023-03-10 07:26:56','',''),(3822,'1','307','1',1,'Retail Sale Id 3810',4900.00,0.00,0.00,7.00,532.00,'2023-03-10 07:36:26','',''),(3823,'1','307','1',1,'Retail Sale Id 3811',1001.00,0.00,0.00,1.43,108.68,'2023-03-10 07:51:09','',''),(3824,'1','307','1',1,'Retail Sale Id 3812',3500.00,0.00,0.00,5.00,380.00,'2023-03-10 07:53:36','',''),(3825,'1','307','1',1,'Retail Sale Id 3813',65800.00,0.00,0.00,100.00,3400.00,'2023-03-10 08:15:15','',''),(3826,'1','307','1',1,'Retail Sale Id 3814',65800.00,0.00,0.00,100.00,3400.00,'2023-03-10 08:16:25','',''),(3827,'1','307','1',1,'Retail Sale Id 3815',8750.00,0.00,0.00,12.50,950.00,'2023-03-10 08:17:24','',''),(3828,'1','307','1',1,'Retail Sale Id 3816',7700.00,0.00,0.00,11.00,836.00,'2023-03-10 08:18:11','',''),(3829,'1','307','1',1,'Retail Sale Id 3817',2800.00,0.00,0.00,4.00,304.00,'2023-03-10 08:19:09','',''),(3830,'1','307','1',1,'Retail Sale Id 3818',2800.00,0.00,0.00,4.00,304.00,'2023-03-10 08:21:31','',''),(3831,'1','307','1',1,'Retail Sale Id 3819',2100.00,0.00,0.00,3.00,228.00,'2023-03-10 08:29:43','',''),(3832,'1','307','1',1,'Retail Sale Id 3820',2100.00,0.00,0.00,3.00,228.00,'2023-03-10 08:30:37','',''),(3833,'1','307','1',1,'Retail Sale Id 3821',1400.00,0.00,0.00,2.00,152.00,'2023-03-10 08:31:43','',''),(3834,'1','307','1',1,'Retail Sale Id 3822',1001.00,0.00,0.00,1.43,108.68,'2023-03-10 08:32:36','',''),(3835,'1','307','1',1,'Retail Sale Id 3823',1400.00,0.00,0.00,2.00,152.00,'2023-03-10 08:33:48','',''),(3836,'1','307','1',1,'Retail Sale Id 3824',4200.00,0.00,0.00,6.00,456.00,'2023-03-10 08:34:47','',''),(3837,'1','307','1',1,'Retail Sale Id 3825',8750.00,0.00,0.00,12.50,950.00,'2023-03-10 08:39:40','',''),(3838,'1','307','1',1,'Retail Sale Id 3826',4200.00,0.00,0.00,6.00,456.00,'2023-03-10 08:53:11','',''),(3839,'1','307','1',1,'Retail Sale Id 3827',2800.00,0.00,0.00,4.00,304.00,'2023-03-10 09:21:50','',''),(3840,'1','307','1',1,'Retail Sale Id 3828',8750.00,0.00,0.00,12.50,950.00,'2023-03-10 09:34:16','',''),(3841,'1','307','1',1,'Retail Sale Id 3829',19950.00,0.00,0.00,28.50,2166.00,'2023-03-10 10:55:59','',''),(3842,'1','307','1',1,'Retail Sale Id 3830',3500.00,0.00,0.00,5.00,380.00,'2023-03-10 11:19:17','',''),(3843,'1','307','1',1,'Retail Sale Id 3831',1400.00,0.00,0.00,2.00,152.00,'2023-03-10 11:21:46','',''),(3844,'1','307','1',1,'Retail Sale Id 3832',2100.00,0.00,0.00,3.00,228.00,'2023-03-10 11:23:45','',''),(3845,'1','307','1',1,'Retail Sale Id 3833',1400.00,0.00,0.00,2.00,152.00,'2023-03-10 11:27:54','',''),(3846,'1','307','1',1,'Retail Sale Id 3834',1498.00,0.00,0.00,2.14,162.64,'2023-03-10 11:41:26','',''),(3847,'1','307','1',1,'Retail Sale Id 3835',4200.00,0.00,0.00,6.00,456.00,'2023-03-10 11:51:12','',''),(3848,'1','307','1',1,'Retail Sale Id 3836',8750.00,0.00,0.00,12.50,950.00,'2023-03-10 12:02:36','',''),(3849,'1','307','1',1,'Retail Sale Id 3837',4200.00,0.00,0.00,6.00,456.00,'2023-03-10 12:05:35','',''),(3850,'1','307','1',1,'Retail Sale Id 3838',4200.00,0.00,0.00,6.00,456.00,'2023-03-10 12:14:01','',''),(3851,'1','307','1',1,'Retail Sale Id 3839',32900.00,0.00,0.00,50.00,1700.00,'2023-03-10 12:20:29','',''),(3852,'1','307','1',1,'Retail Sale Id 3840',8750.00,0.00,0.00,12.50,950.00,'2023-03-10 12:22:17','',''),(3853,'1','307','1',1,'Retail Sale Id 3841',4200.00,0.00,0.00,6.00,456.00,'2023-03-10 12:23:40','',''),(3854,'1','307','1',1,'Retail Sale Id 3842',700000.00,0.00,0.00,1000.00,76000.00,'2023-03-10 12:38:20','',''),(3855,'1','307','1',1,'Retail Sale Id 3843',4200.00,0.00,0.00,6.00,456.00,'2023-03-10 12:48:48','',''),(3856,'1','307','1',1,'Return of Retail Sale Id 3842',0.00,700000.00,1000.00,0.00,-76000.00,'2023-03-10 12:52:19','',''),(3857,'1','307','1',1,'Retail Sale Id 3844',1001.00,0.00,0.00,1.43,108.68,'2023-03-10 12:53:14','',''),(3858,'1','307','1',1,'Retail Sale Id 3845',17002.72,0.00,0.00,25.84,878.56,'2023-03-10 13:14:09','',''),(3859,'1','307','1',1,'Retail Sale Id 3846',4200.00,0.00,0.00,6.00,456.00,'2023-03-10 13:37:31','',''),(3860,'1','307','1',1,'Retail Sale Id 3847',8750.00,0.00,0.00,12.50,950.00,'2023-03-10 13:38:20','',''),(3861,'1','307','1',1,'Retail Sale Id 3848',4200.00,0.00,0.00,6.00,456.00,'2023-03-10 13:39:07','',''),(3862,'1','307','1',1,'Retail Sale Id 3849',2800.00,0.00,0.00,4.00,304.00,'2023-03-10 13:42:17','',''),(3863,'1','307','1',1,'Retail Sale Id 3850',2100.00,0.00,0.00,3.00,228.00,'2023-03-10 14:06:57','',''),(3864,'1','307','1',1,'Retail Sale Id 3851',6300.00,0.00,0.00,9.00,684.00,'2023-03-10 15:20:52','',''),(3865,'1','307','1',1,'Retail Sale Id 3852',41125.00,0.00,0.00,62.50,2125.00,'2023-03-10 15:33:00','',''),(3866,'1','307','1',1,'Retail Sale Id 3853',32900.00,0.00,0.00,50.00,1700.00,'2023-03-10 15:38:15','',''),(3867,'1','307','1',1,'Retail Sale Id 3854',1400.00,0.00,0.00,2.00,152.00,'2023-03-10 15:39:30','',''),(3868,'1','307','1',1,'Retail Sale Id 3855',8050.00,0.00,0.00,11.50,874.00,'2023-03-10 15:40:46','',''),(3869,'1','307','1',1,'Retail Sale Id 3856',4200.00,0.00,0.00,6.00,456.00,'2023-03-10 15:56:42','',''),(3870,'1','307','1',1,'Retail Sale Id 3857',2100.00,0.00,0.00,3.00,228.00,'2023-03-10 16:00:32','',''),(3871,'1','307','1',1,'Retail Sale Id 3858',700.00,0.00,0.00,1.00,76.00,'2023-03-10 16:07:41','',''),(3872,'1','307','1',1,'Retail Sale Id 3859',4200.00,0.00,0.00,6.00,456.00,'2023-03-10 16:24:06','',''),(3873,'1','307','1',1,'Retail Sale Id 3860',22400.00,0.00,0.00,32.00,2432.00,'2023-03-10 16:51:42','',''),(3874,'1','307','1',1,'Retail Sale Id 3861',2100.00,0.00,0.00,3.00,228.00,'2023-03-10 17:20:35','',''),(3875,'1','307','1',1,'Retail Sale Id 3862',7000.00,0.00,0.00,10.00,760.00,'2023-03-10 17:34:28','',''),(3876,'1','307','1',1,'Retail Sale Id 3863',23799.86,0.00,0.00,36.17,1229.78,'2023-03-10 17:47:14','',''),(3877,'1','307','1',1,'Retail Sale Id 3865',2100.00,0.00,0.00,3.00,228.00,'2023-03-10 17:49:12','',''),(3878,'1','307','1',1,'Retail Sale Id 3866',12950.00,0.00,0.00,18.50,1406.00,'2023-03-10 18:09:38','',''),(3879,'1','307','1',1,'Retail Sale Id 3867',65800.00,0.00,0.00,100.00,3400.00,'2023-03-10 18:13:43','',''),(3880,'1','307','1',1,'Retail Sale Id 3868',8750.00,0.00,0.00,12.50,950.00,'2023-03-10 18:24:08','',''),(3881,'1','307','1',1,'Retail Sale Id 3869',24199.00,0.00,0.00,34.57,2627.32,'2023-03-10 18:43:39','',''),(3882,'1','307','1',1,'Retail Sale Id 3870',1400.00,0.00,0.00,2.00,152.00,'2023-03-10 19:24:26','',''),(3883,'1','307','1',1,'Retail Sale Id 3871',10850.00,0.00,0.00,15.50,1178.00,'2023-03-11 07:25:50','',''),(3884,'1','307','1',1,'Retail Sale Id 3872',4200.00,0.00,0.00,6.00,456.00,'2023-03-11 07:33:03','',''),(3885,'1','307','1',1,'Retail Sale Id 3873',4200.00,0.00,0.00,6.00,456.00,'2023-03-11 07:59:54','',''),(3886,'1','307','1',1,'Retail Sale Id 3874',8750.00,0.00,0.00,12.50,950.00,'2023-03-11 08:06:06','',''),(3887,'1','307','1',1,'Retail Sale Id 3875',8750.00,0.00,0.00,12.50,950.00,'2023-03-11 08:16:17','',''),(3888,'1','307','1',1,'Retail Sale Id 3876',2800.00,0.00,0.00,4.00,304.00,'2023-03-11 08:20:32','',''),(3889,'1','307','1',1,'Retail Sale Id 3877',3500.00,0.00,0.00,5.00,380.00,'2023-03-11 08:29:19','',''),(3890,'1','307','1',1,'Retail Sale Id 3878',700.00,0.00,0.00,1.00,76.00,'2023-03-11 08:33:41','',''),(3891,'1','307','1',1,'Retail Sale Id 3880',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 08:36:08','',''),(3892,'1','307','1',1,'Retail Sale Id 3881',1498.00,0.00,0.00,2.14,162.64,'2023-03-11 08:41:54','',''),(3893,'1','307','1',1,'Retail Sale Id 3882',1001.00,0.00,0.00,1.43,108.68,'2023-03-11 08:44:33','',''),(3894,'1','307','1',1,'Retail Sale Id 3883',3500.00,0.00,0.00,5.00,380.00,'2023-03-11 09:02:08','',''),(3895,'1','307','1',1,'Retail Sale Id 3884',4200.00,0.00,0.00,6.00,456.00,'2023-03-11 09:04:50','',''),(3896,'1','307','1',1,'Retail Sale Id 3885',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 09:07:03','',''),(3897,'1','307','1',1,'Retail Sale Id 3886',65800.00,0.00,0.00,100.00,3400.00,'2023-03-11 09:16:27','',''),(3898,'1','307','1',1,'Retail Sale Id 3887',1400.00,0.00,0.00,2.00,152.00,'2023-03-11 09:21:17','',''),(3899,'1','307','1',1,'Retail Sale Id 3888',2499.00,0.00,0.00,3.57,271.32,'2023-03-11 09:30:24','',''),(3900,'1','307','1',1,'Retail Sale Id 3889',2002.00,0.00,0.00,2.86,217.36,'2023-03-11 09:31:48','',''),(3901,'1','307','1',1,'Retail Sale Id 3890',8750.00,0.00,0.00,12.50,950.00,'2023-03-11 09:34:27','',''),(3902,'1','307','1',1,'Retail Sale Id 3891',2800.00,0.00,0.00,4.00,304.00,'2023-03-11 09:36:43','',''),(3903,'1','307','1',1,'Retail Sale Id 3892',4900.00,0.00,0.00,7.00,532.00,'2023-03-11 09:56:32','',''),(3904,'1','307','1',1,'Retail Sale Id 3893',2800.00,0.00,0.00,4.00,304.00,'2023-03-11 10:02:26','',''),(3905,'1','307','1',1,'Retail Sale Id 3894',2800.00,0.00,0.00,4.00,304.00,'2023-03-11 10:24:54','',''),(3906,'1','307','1',1,'Retail Sale Id 3896',3500.00,0.00,0.00,5.00,380.00,'2023-03-11 10:26:23','',''),(3907,'1','307','1',1,'Retail Sale Id 3897',15002.40,0.00,0.00,22.80,775.20,'2023-03-11 10:28:57','',''),(3908,'1','307','1',1,'Retail Sale Id 3898',4200.00,0.00,0.00,6.00,456.00,'2023-03-11 10:29:48','',''),(3909,'1','307','1',1,'Retail Sale Id 3899',32900.00,0.00,0.00,50.00,1700.00,'2023-03-11 10:32:02','',''),(3910,'1','307','1',1,'Retail Sale Id 3900',1001.00,0.00,0.00,1.43,108.68,'2023-03-11 10:36:23','',''),(3911,'1','307','1',1,'Retail Sale Id 3901',4200.00,0.00,0.00,6.00,456.00,'2023-03-11 10:40:00','',''),(3912,'1','307','1',1,'Retail Sale Id 3902',4200.00,0.00,0.00,6.00,456.00,'2023-03-11 10:53:01','',''),(3913,'1','307','1',1,'Retail Sale Id 3903',4200.00,0.00,0.00,6.00,456.00,'2023-03-11 10:58:49','',''),(3914,'1','307','1',1,'Retail Sale Id 3904',2800.00,0.00,0.00,4.00,304.00,'2023-03-11 11:00:16','',''),(3915,'1','307','1',1,'Retail Sale Id 3905',131600.00,0.00,0.00,200.00,6800.00,'2023-03-11 11:04:49','',''),(3916,'1','307','1',1,'Retail Sale Id 3906',8750.00,0.00,0.00,12.50,950.00,'2023-03-11 11:29:45','',''),(3917,'1','307','1',1,'Retail Sale Id 3907',1197.00,0.00,0.00,1.71,129.96,'2023-03-11 11:31:05','',''),(3918,'1','307','1',1,'Retail Sale Id 3908',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 12:00:35','',''),(3919,'1','307','1',1,'Retail Sale Id 3909',4200.00,0.00,0.00,6.00,456.00,'2023-03-11 12:04:25','',''),(3920,'1','307','1',1,'Retail Sale Id 3910',4900.00,0.00,0.00,7.00,532.00,'2023-03-11 12:09:38','',''),(3921,'1','307','1',1,'Retail Sale Id 3911',49350.00,0.00,0.00,75.00,2550.00,'2023-03-11 12:16:40','',''),(3922,'1','307','1',1,'Retail Sale Id 3912',4200.00,0.00,0.00,6.00,456.00,'2023-03-11 12:35:35','',''),(3923,'1','307','1',1,'Retail Sale Id 3913',32900.00,0.00,0.00,50.00,1700.00,'2023-03-11 12:38:41','',''),(3924,'1','307','1',1,'Retail Sale Id 3914',4900.00,0.00,0.00,7.00,532.00,'2023-03-11 12:40:31','',''),(3925,'1','307','1',1,'Retail Sale Id 3915',4200.00,0.00,0.00,6.00,456.00,'2023-03-11 12:41:22','',''),(3926,'1','307','1',1,'Retail Sale Id 3916',9100.00,0.00,0.00,13.00,988.00,'2023-03-11 12:44:13','',''),(3927,'1','307','1',1,'Retail Sale Id 3917',2800.00,0.00,0.00,4.00,304.00,'2023-03-11 12:54:09','',''),(3928,'1','307','1',1,'Retail Sale Id 3918',8750.00,0.00,0.00,12.50,950.00,'2023-03-11 13:27:00','',''),(3929,'1','307','1',1,'Retail Sale Id 3919',4200.00,0.00,0.00,6.00,456.00,'2023-03-11 13:31:06','',''),(3930,'1','307','1',1,'Retail Sale Id 3920',8750.00,0.00,0.00,12.50,950.00,'2023-03-11 13:36:58','',''),(3931,'1','307','1',1,'Retail Sale Id 3921',7700.00,0.00,0.00,11.00,836.00,'2023-03-11 13:47:36','',''),(3932,'1','307','1',1,'Retail Sale Id 3922',3500.00,0.00,0.00,5.00,380.00,'2023-03-11 13:49:48','',''),(3933,'1','307','1',1,'Retail Sale Id 3923',1001.00,0.00,0.00,1.43,108.68,'2023-03-11 14:08:42','',''),(3934,'1','307','1',1,'Retail Sale Id 3924',4200.00,0.00,0.00,6.00,456.00,'2023-03-11 14:18:38','',''),(3935,'1','307','1',1,'Retail Sale Id 3925',1400.00,0.00,0.00,2.00,152.00,'2023-03-11 14:56:29','',''),(3936,'1','307','1',1,'Retail Sale Id 3926',41098.68,0.00,0.00,62.46,2123.64,'2023-03-11 15:00:47','',''),(3937,'1','307','1',1,'Retail Sale Id 3927',7000.00,0.00,0.00,10.00,760.00,'2023-03-11 15:03:34','',''),(3938,'1','307','1',1,'Retail Sale Id 3928',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 15:06:07','',''),(3939,'1','307','1',1,'Retail Sale Id 3929',4200.00,0.00,0.00,6.00,456.00,'2023-03-11 15:16:46','',''),(3940,'1','307','1',1,'Retail Sale Id 3930',10003.00,0.00,0.00,14.29,1086.04,'2023-03-11 16:01:38','',''),(3941,'1','307','1',1,'Retail Sale Id 3931',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 16:02:42','',''),(3942,'1','307','1',1,'Retail Sale Id 3932',5600.00,0.00,0.00,8.00,608.00,'2023-03-11 16:04:12','',''),(3943,'1','307','1',1,'Retail Sale Id 3933',8750.00,0.00,0.00,12.50,950.00,'2023-03-11 16:15:08','',''),(3944,'1','307','1',1,'Retail Sale Id 3934',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 16:16:15','',''),(3945,'1','307','1',1,'Retail Sale Id 3935',2800.00,0.00,0.00,4.00,304.00,'2023-03-11 16:17:15','',''),(3946,'1','307','1',1,'Retail Sale Id 3936',1400.00,0.00,0.00,2.00,152.00,'2023-03-11 16:18:58','',''),(3947,'1','307','1',1,'Retail Sale Id 3937',8750.00,0.00,0.00,12.50,950.00,'2023-03-11 16:57:28','',''),(3948,'1','307','1',1,'Retail Sale Id 3938',28798.00,0.00,0.00,41.14,3126.64,'2023-03-11 16:59:49','',''),(3949,'1','307','1',1,'Retail Sale Id 3939',13650.00,0.00,0.00,19.50,1482.00,'2023-03-11 17:18:32','',''),(3950,'1','307','1',1,'Retail Sale Id 3940',19600.00,0.00,0.00,28.00,2128.00,'2023-03-11 17:59:40','',''),(3951,'1','307','1',1,'Retail Sale Id 3941',19600.00,0.00,0.00,28.00,2128.00,'2023-03-11 18:00:34','',''),(3952,'1','307','1',1,'Retail Sale Id 3942',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 18:01:43','',''),(3953,'1','307','1',1,'Retail Sale Id 3943',8750.00,0.00,0.00,12.50,950.00,'2023-03-11 18:05:22','',''),(3954,'1','307','1',1,'Retail Sale Id 3944',4200.00,0.00,0.00,6.00,456.00,'2023-03-11 18:32:35','',''),(3955,'1','307','1',1,'Retail Sale Id 3945',4900.00,0.00,0.00,7.00,532.00,'2023-03-11 18:33:44','',''),(3956,'1','307','1',1,'Retail Sale Id 3946',2100.00,0.00,0.00,3.00,228.00,'2023-03-11 18:35:03','',''),(3957,'1','307','1',1,'Retail Sale Id 3947',8750.00,0.00,0.00,12.50,950.00,'2023-03-11 18:36:05','',''),(3958,'1','307','1',1,'Return of Retail Sale Id 3926',0.00,41098.68,62.46,0.00,-2123.64,'2023-03-11 18:53:15','',''),(3959,'1','307','1',1,'Retail Sale Id 3948',14054.88,0.00,0.00,21.36,726.24,'2023-03-11 18:55:31','',''),(3960,'1','307','1',1,'Retail Sale Id 3949',47068.00,0.00,0.00,67.24,5110.24,'2023-03-11 19:12:17','',''),(3961,'1','307','1',1,'Return of Retail Sale Id 3949',0.00,47068.00,67.24,0.00,-5110.24,'2023-03-11 19:24:53','',''),(3962,'1','307','1',1,'Retail Sale Id 3950',15687.00,0.00,0.00,22.41,1703.16,'2023-03-11 19:30:45','',''),(3963,'1','307','1',1,'Retail Sale Id 3951',15687.00,0.00,0.00,22.41,1703.16,'2023-03-11 19:31:39','',''),(3964,'1','307','1',1,'Retail Sale Id 3953',15694.00,0.00,0.00,22.42,1703.92,'2023-03-11 19:33:57','',''),(3965,'1','307','1',1,'Return of Retail Sale Id 3936',0.00,1400.00,2.00,0.00,-152.00,'2023-03-11 19:51:18','',''),(3966,'1','307','1',1,'Return of Retail Sale Id 3942',0.00,2100.00,3.00,0.00,-228.00,'2023-03-11 19:53:23','',''),(3967,'1','307','1',1,'Retail Sale Id 3954',2450.00,0.00,0.00,3.50,266.00,'2023-03-11 19:54:35','',''),(3968,'1','307','1',1,'Retail Sale Id 3955',4200.00,0.00,0.00,6.00,456.00,'2023-03-12 07:22:51','',''),(3969,'1','307','1',1,'Retail Sale Id 3956',3500.00,0.00,0.00,5.00,380.00,'2023-03-12 07:24:50','',''),(3970,'1','307','1',1,'Retail Sale Id 3957',4200.00,0.00,0.00,6.00,456.00,'2023-03-12 07:34:28','',''),(3971,'1','307','1',1,'Retail Sale Id 3958',1400.00,0.00,0.00,2.00,152.00,'2023-03-12 08:06:36','',''),(3972,'1','307','1',1,'Return of Retail Sale Id 3958',0.00,1400.00,2.00,0.00,-152.00,'2023-03-12 08:07:32','',''),(3973,'1','307','1',1,'Retail Sale Id 3959',1400.00,0.00,0.00,2.00,152.00,'2023-03-12 08:08:13','',''),(3974,'1','307','1',1,'Retail Sale Id 3960',11900.00,0.00,0.00,17.00,1292.00,'2023-03-12 08:22:33','',''),(3975,'1','307','1',1,'Retail Sale Id 3961',1400.00,0.00,0.00,2.00,152.00,'2023-03-12 08:49:08','',''),(3976,'1','307','1',1,'Retail Sale Id 3962',41125.00,0.00,0.00,62.50,2125.00,'2023-03-12 08:57:39','',''),(3977,'1','307','1',1,'Retail Sale Id 3963',3500.00,0.00,0.00,5.00,380.00,'2023-03-12 09:01:30','',''),(3978,'1','307','1',1,'Retail Sale Id 3964',2800.00,0.00,0.00,4.00,304.00,'2023-03-12 09:05:43','',''),(3979,'1','307','1',1,'Retail Sale Id 3965',4200.00,0.00,0.00,6.00,456.00,'2023-03-12 09:08:56','',''),(3980,'1','307','1',1,'Retail Sale Id 3966',8750.00,0.00,0.00,12.50,950.00,'2023-03-12 09:10:53','',''),(3981,'1','307','1',1,'Retail Sale Id 3967',700.00,0.00,0.00,1.00,76.00,'2023-03-12 09:12:09','',''),(3982,'1','307','1',1,'Retail Sale Id 3968',4200.00,0.00,0.00,6.00,456.00,'2023-03-12 09:14:46','',''),(3983,'1','307','1',1,'Retail Sale Id 3969',8750.00,0.00,0.00,12.50,950.00,'2023-03-12 09:19:00','',''),(3984,'1','307','1',1,'Retail Sale Id 3970',65800.00,0.00,0.00,100.00,3400.00,'2023-03-12 09:30:53','',''),(3985,'1','307','1',1,'Retail Sale Id 3971',9100.00,0.00,0.00,13.00,988.00,'2023-03-12 09:40:41','',''),(3986,'1','307','1',1,'Retail Sale Id 3972',3500.00,0.00,0.00,5.00,380.00,'2023-03-12 09:48:35','',''),(3987,'1','307','1',1,'Retail Sale Id 3973',4200.00,0.00,0.00,6.00,456.00,'2023-03-12 09:49:53','',''),(3988,'1','307','1',1,'Retail Sale Id 3974',12950.00,0.00,0.00,18.50,1406.00,'2023-03-12 10:13:23','',''),(3989,'1','307','1',1,'Retail Sale Id 3975',1400.00,0.00,0.00,2.00,152.00,'2023-03-12 10:18:45','',''),(3990,'1','307','1',1,'Retail Sale Id 3976',2002.00,0.00,0.00,2.86,217.36,'2023-03-12 10:27:49','',''),(3991,'1','307','1',1,'Retail Sale Id 3977',19600.00,0.00,0.00,28.00,2128.00,'2023-03-12 10:30:08','',''),(3992,'1','307','1',1,'Retail Sale Id 3978',4200.00,0.00,0.00,6.00,456.00,'2023-03-12 10:45:02','',''),(3993,'1','307','1',1,'Retail Sale Id 3979',1400.00,0.00,0.00,2.00,152.00,'2023-03-12 10:46:37','',''),(3994,'1','307','1',1,'Retail Sale Id 3980',3500.00,0.00,0.00,5.00,380.00,'2023-03-12 10:50:48','',''),(3995,'1','307','1',1,'Retail Sale Id 3981',8750.00,0.00,0.00,12.50,950.00,'2023-03-12 10:52:24','',''),(3996,'1','307','1',1,'Retail Sale Id 3983',33097.40,0.00,0.00,50.30,1710.20,'2023-03-12 10:55:42','',''),(3997,'1','307','1',1,'Retail Sale Id 3984',8750.00,0.00,0.00,12.50,950.00,'2023-03-12 11:17:22','',''),(3998,'1','307','1',1,'Retail Sale Id 3985',3500.00,0.00,0.00,5.00,380.00,'2023-03-12 11:19:59','',''),(3999,'1','307','1',1,'Retail Sale Id 3986',2100.00,0.00,0.00,3.00,228.00,'2023-03-12 11:24:27','',''),(4000,'1','307','1',1,'Retail Sale Id 3987',2800.00,0.00,0.00,4.00,304.00,'2023-03-12 11:32:08','',''),(4001,'1','307','1',1,'Retail Sale Id 3988',1001.00,0.00,0.00,1.43,108.68,'2023-03-12 11:35:03','',''),(4002,'1','307','1',1,'Retail Sale Id 3989',9450.00,0.00,0.00,13.50,1026.00,'2023-03-12 11:37:00','',''),(4003,'1','307','1',1,'Retail Sale Id 3990',2100.00,0.00,0.00,3.00,228.00,'2023-03-12 11:38:08','',''),(4004,'1','307','1',1,'Retail Sale Id 3991',4900.00,0.00,0.00,7.00,532.00,'2023-03-12 11:44:34','',''),(4005,'1','307','1',1,'Retail Sale Id 3992',4200.00,0.00,0.00,6.00,456.00,'2023-03-12 12:42:27','',''),(4006,'1','307','1',1,'Retail Sale Id 3993',2100.00,0.00,0.00,3.00,228.00,'2023-03-12 12:52:29','',''),(4007,'1','307','1',1,'Retail Sale Id 3994',4200.00,0.00,0.00,6.00,456.00,'2023-03-12 12:56:20','',''),(4008,'1','307','1',1,'Retail Sale Id 3995',700.00,0.00,0.00,1.00,76.00,'2023-03-12 13:07:15','',''),(4009,'1','307','1',1,'Retail Sale Id 3996',4200.00,0.00,0.00,6.00,456.00,'2023-03-12 13:28:07','',''),(4010,'1','307','1',1,'Retail Sale Id 3997',9002.00,0.00,0.00,12.86,977.36,'2023-03-12 13:29:32','',''),(4011,'1','307','1',1,'Retail Sale Id 3998',2100.00,0.00,0.00,3.00,228.00,'2023-03-12 13:30:22','',''),(4012,'1','307','1',1,'Retail Sale Id 3999',2100.00,0.00,0.00,3.00,228.00,'2023-03-12 13:38:47','',''),(4013,'1','307','1',1,'Retail Sale Id 4000',4200.00,0.00,0.00,6.00,456.00,'2023-03-12 13:40:59','',''),(4014,'1','307','1',1,'Retail Sale Id 4001',3500.00,0.00,0.00,5.00,380.00,'2023-03-12 14:16:36','',''),(4015,'1','307','1',1,'Retail Sale Id 4002',2100.00,0.00,0.00,3.00,228.00,'2023-03-12 14:22:38','',''),(4016,'1','307','1',1,'Retail Sale Id 4003',2100.00,0.00,0.00,3.00,228.00,'2023-03-12 14:29:38','',''),(4017,'1','307','1',1,'Retail Sale Id 4004',700.00,0.00,0.00,1.00,76.00,'2023-03-12 14:42:09','',''),(4018,'1','307','1',1,'Retail Sale Id 4005',8750.00,0.00,0.00,12.50,950.00,'2023-03-12 14:43:51','',''),(4019,'1','307','1',1,'Retail Sale Id 4006',4200.00,0.00,0.00,6.00,456.00,'2023-03-12 15:07:35','',''),(4020,'1','307','1',1,'Retail Sale Id 4007',2100.00,0.00,0.00,3.00,228.00,'2023-03-12 15:10:40','',''),(4021,'1','307','1',1,'Retail Sale Id 4008',3997.00,0.00,0.00,5.71,433.96,'2023-03-12 15:25:40','',''),(4022,'1','307','1',1,'Retail Sale Id 4009',6300.00,0.00,0.00,9.00,684.00,'2023-03-12 15:34:17','',''),(4023,'1','307','1',1,'Retail Sale Id 4010',3500.00,0.00,0.00,5.00,380.00,'2023-03-12 15:36:39','',''),(4024,'1','307','1',1,'Retail Sale Id 4011',8750.00,0.00,0.00,12.50,950.00,'2023-03-12 16:16:08','',''),(4025,'1','307','1',1,'Retail Sale Id 4012',3003.00,0.00,0.00,4.29,326.04,'2023-03-12 16:22:36','',''),(4026,'1','307','1',1,'Retail Sale Id 4013',4200.00,0.00,0.00,6.00,456.00,'2023-03-12 16:23:37','',''),(4027,'1','307','1',1,'Retail Sale Id 4014',10500.00,0.00,0.00,15.00,1140.00,'2023-03-12 16:27:57','',''),(4028,'1','307','1',1,'Retail Sale Id 4015',4200.00,0.00,0.00,6.00,456.00,'2023-03-12 17:03:55','',''),(4029,'1','307','1',1,'Retail Sale Id 4016',3500.00,0.00,0.00,5.00,380.00,'2023-03-12 17:05:07','',''),(4030,'1','307','1',1,'Retail Sale Id 4017',2002.00,0.00,0.00,2.86,217.36,'2023-03-12 17:08:31','',''),(4031,'1','307','1',1,'Retail Sale Id 4018',2100.00,0.00,0.00,3.00,228.00,'2023-03-12 17:10:24','',''),(4032,'1','307','1',1,'Retail Sale Id 4019',2100.00,0.00,0.00,3.00,228.00,'2023-03-12 17:11:52','',''),(4033,'1','307','1',1,'Retail Sale Id 4020',3500.00,0.00,0.00,5.00,380.00,'2023-03-12 17:15:57','',''),(4034,'1','307','1',1,'Retail Sale Id 4021',2100.00,0.00,0.00,3.00,228.00,'2023-03-12 17:21:43','',''),(4035,'1','307','1',1,'Retail Sale Id 4022',6503.00,0.00,0.00,9.29,706.04,'2023-03-12 17:40:29','',''),(4036,'1','307','1',1,'Retail Sale Id 4023',700.00,0.00,0.00,1.00,76.00,'2023-03-12 17:41:25','',''),(4037,'1','307','1',1,'Retail Sale Id 4024',2002.00,0.00,0.00,2.86,217.36,'2023-03-12 17:48:43','',''),(4038,'1','307','1',1,'Retail Sale Id 4025',32900.00,0.00,0.00,50.00,1700.00,'2023-03-12 17:55:26','',''),(4039,'1','307','1',1,'Retail Sale Id 4026',3500.00,0.00,0.00,5.00,380.00,'2023-03-12 18:03:14','',''),(4040,'1','307','1',1,'Retail Sale Id 4027',12600.00,0.00,0.00,18.00,1368.00,'2023-03-12 18:25:41','',''),(4041,'1','307','1',1,'Retail Sale Id 4028',8750.00,0.00,0.00,12.50,950.00,'2023-03-12 18:31:54','',''),(4042,'1','307','1',1,'Retail Sale Id 4029',2100.00,0.00,0.00,3.00,228.00,'2023-03-12 18:45:52','',''),(4043,'1','307','1',1,'Retail Sale Id 4030',1197.00,0.00,0.00,1.71,129.96,'2023-03-12 18:51:36','',''),(4044,'1','307','1',1,'Retail Sale Id 4031',5362.00,0.00,0.00,7.66,582.16,'2023-03-12 19:14:44','',''),(4045,'1','307','1',1,'Retail Sale Id 4032',2800.00,0.00,0.00,4.00,304.00,'2023-03-13 07:22:48','',''),(4046,'1','307','1',1,'Retail Sale Id 4033',131600.00,0.00,0.00,200.00,6800.00,'2023-03-13 07:32:10','',''),(4047,'1','307','1',1,'Retail Sale Id 4034',6300.00,0.00,0.00,9.00,684.00,'2023-03-13 07:37:43','',''),(4048,'1','307','1',1,'Retail Sale Id 4035',4200.00,0.00,0.00,6.00,456.00,'2023-03-13 07:38:57','',''),(4049,'1','307','1',1,'Retail Sale Id 4037',3003.00,0.00,0.00,4.29,326.04,'2023-03-13 07:41:45','',''),(4050,'1','307','1',1,'Retail Sale Id 4038',3500.00,0.00,0.00,5.00,380.00,'2023-03-13 07:51:31','',''),(4051,'1','307','1',1,'Retail Sale Id 4039',4200.00,0.00,0.00,6.00,456.00,'2023-03-13 07:59:30','',''),(4052,'1','307','1',1,'Retail Sale Id 4040',2100.00,0.00,0.00,3.00,228.00,'2023-03-13 08:00:42','',''),(4053,'1','307','1',1,'Retail Sale Id 4041',4200.00,0.00,0.00,6.00,456.00,'2023-03-13 08:03:20','',''),(4054,'1','307','1',1,'Retail Sale Id 4042',4200.00,0.00,0.00,6.00,456.00,'2023-03-13 08:15:21','',''),(4055,'1','307','1',1,'Retail Sale Id 4043',14000.00,0.00,0.00,20.00,1520.00,'2023-03-13 08:17:05','',''),(4056,'1','307','1',1,'Retail Sale Id 4044',1400.00,0.00,0.00,2.00,152.00,'2023-03-13 08:27:01','',''),(4057,'1','307','1',1,'Retail Sale Id 4045',1001.00,0.00,0.00,1.43,108.68,'2023-03-13 08:50:07','',''),(4058,'1','307','1',1,'Retail Sale Id 4046',8750.00,0.00,0.00,12.50,950.00,'2023-03-13 08:52:08','',''),(4059,'1','307','1',1,'Retail Sale Id 4047',2002.00,0.00,0.00,2.86,217.36,'2023-03-13 08:59:55','',''),(4060,'1','307','1',1,'Retail Sale Id 4048',32900.00,0.00,0.00,50.00,1700.00,'2023-03-13 09:01:58','',''),(4061,'1','307','1',1,'Retail Sale Id 4049',2100.00,0.00,0.00,3.00,228.00,'2023-03-13 09:14:00','',''),(4062,'1','307','1',1,'Retail Sale Id 4050',4200.00,0.00,0.00,6.00,456.00,'2023-03-13 09:15:46','',''),(4063,'1','307','1',1,'Retail Sale Id 4051',131600.00,0.00,0.00,200.00,6800.00,'2023-03-13 09:27:02','',''),(4064,'1','307','1',1,'Retail Sale Id 4052',3500.00,0.00,0.00,5.00,380.00,'2023-03-13 09:31:22','',''),(4065,'1','307','1',1,'Retail Sale Id 4053',2100.00,0.00,0.00,3.00,228.00,'2023-03-13 09:45:34','',''),(4066,'1','307','1',1,'Retail Sale Id 4054',2303.00,0.00,0.00,3.29,250.04,'2023-03-13 10:03:32','',''),(4067,'1','307','1',1,'Retail Sale Id 4056',5600.00,0.00,0.00,8.00,608.00,'2023-03-13 10:06:19','',''),(4068,'1','307','1',1,'Retail Sale Id 4057',3003.00,0.00,0.00,4.29,326.04,'2023-03-13 10:09:52','',''),(4069,'1','307','1',1,'Retail Sale Id 4058',8750.00,0.00,0.00,12.50,950.00,'2023-03-13 10:14:54','',''),(4070,'1','307','1',1,'Retail Sale Id 4059',4200.00,0.00,0.00,6.00,456.00,'2023-03-13 10:18:17','',''),(4071,'1','307','1',1,'Retail Sale Id 4060',1001.00,0.00,0.00,1.43,108.68,'2023-03-13 10:25:50','',''),(4072,'1','307','1',1,'Retail Sale Id 4061',2100.00,0.00,0.00,3.00,228.00,'2023-03-13 10:43:11','',''),(4073,'1','307','1',1,'Retail Sale Id 4062',65800.00,0.00,0.00,100.00,3400.00,'2023-03-13 10:44:21','',''),(4074,'1','307','1',1,'Retail Sale Id 4063',4200.00,0.00,0.00,6.00,456.00,'2023-03-13 10:48:46','',''),(4075,'1','307','1',1,'Retail Sale Id 4064',4200.00,0.00,0.00,6.00,456.00,'2023-03-13 10:55:49','',''),(4076,'1','307','1',1,'Retail Sale Id 4065',2800.00,0.00,0.00,4.00,304.00,'2023-03-13 11:41:21','',''),(4077,'1','307','1',1,'Retail Sale Id 4066',1400.00,0.00,0.00,2.00,152.00,'2023-03-13 11:47:55','',''),(4078,'1','307','1',1,'Retail Sale Id 4067',3500.00,0.00,0.00,5.00,380.00,'2023-03-13 11:50:05','',''),(4079,'1','307','1',1,'Retail Sale Id 4069',1400.00,0.00,0.00,2.00,152.00,'2023-03-13 12:00:50','',''),(4080,'1','307','1',1,'Retail Sale Id 4070',8750.00,0.00,0.00,12.50,950.00,'2023-03-13 12:12:12','',''),(4081,'1','307','1',1,'Retail Sale Id 4071',3500.00,0.00,0.00,5.00,380.00,'2023-03-13 12:13:04','',''),(4082,'1','307','1',1,'Retail Sale Id 4072',41125.00,0.00,0.00,62.50,2125.00,'2023-03-13 12:14:10','',''),(4083,'1','307','1',1,'Retail Sale Id 4073',4200.00,0.00,0.00,6.00,456.00,'2023-03-13 12:45:39','',''),(4084,'1','307','1',1,'Retail Sale Id 4074',2800.00,0.00,0.00,4.00,304.00,'2023-03-13 13:04:10','',''),(4085,'1','307','1',1,'Retail Sale Id 4075',1001.00,0.00,0.00,1.43,108.68,'2023-03-13 13:33:35','',''),(4086,'1','307','1',1,'Retail Sale Id 4076',1498.00,0.00,0.00,2.14,162.64,'2023-03-13 13:50:31','',''),(4087,'1','307','1',1,'Retail Sale Id 4077',2100.00,0.00,0.00,3.00,228.00,'2023-03-13 14:03:56','',''),(4088,'1','307','1',1,'Retail Sale Id 4078',4200.00,0.00,0.00,6.00,456.00,'2023-03-13 14:48:54','',''),(4089,'1','307','1',1,'Retail Sale Id 4079',1400.00,0.00,0.00,2.00,152.00,'2023-03-13 14:57:05','',''),(4090,'1','307','1',1,'Retail Sale Id 4080',32900.00,0.00,0.00,50.00,1700.00,'2023-03-13 14:58:11','',''),(4091,'1','307','1',1,'Retail Sale Id 4081',7000.00,0.00,0.00,10.00,760.00,'2023-03-13 15:01:58','',''),(4092,'1','307','1',1,'Retail Sale Id 4082',1498.00,0.00,0.00,2.14,162.64,'2023-03-13 15:21:40','',''),(4093,'1','307','1',1,'Retail Sale Id 4083',3500.00,0.00,0.00,5.00,380.00,'2023-03-13 15:46:16','',''),(4094,'1','307','1',1,'Retail Sale Id 4084',8750.00,0.00,0.00,12.50,950.00,'2023-03-13 15:47:25','',''),(4095,'1','307','1',1,'Retail Sale Id 4085',798.00,0.00,0.00,1.14,86.64,'2023-03-13 15:54:43','',''),(4096,'1','307','1',1,'Retail Sale Id 4086',1400.00,0.00,0.00,2.00,152.00,'2023-03-13 16:12:37','',''),(4097,'1','307','1',1,'Retail Sale Id 4087',5600.00,0.00,0.00,8.00,608.00,'2023-03-13 16:15:46','',''),(4098,'1','307','1',1,'Retail Sale Id 4088',1400.00,0.00,0.00,2.00,152.00,'2023-03-13 16:16:50','',''),(4099,'1','307','1',1,'Retail Sale Id 4089',12999.00,0.00,0.00,18.57,1411.32,'2023-03-13 18:10:35','',''),(4100,'1','307','1',1,'Retail Sale Id 4090',12999.00,0.00,0.00,18.57,1411.32,'2023-03-13 18:11:27','',''),(4101,'1','307','1',1,'Retail Sale Id 4091',12950.00,0.00,0.00,18.50,1406.00,'2023-03-13 18:12:43','',''),(4102,'1','307','1',1,'Retail Sale Id 4092',6300.00,0.00,0.00,9.00,684.00,'2023-03-13 18:28:38','',''),(4103,'1','307','1',1,'Retail Sale Id 4093',28623.00,0.00,0.00,43.50,1479.00,'2023-03-13 18:29:59','',''),(4104,'1','307','1',1,'Retail Sale Id 4094',3948.00,0.00,0.00,6.00,204.00,'2023-03-13 18:48:01','',''),(4105,'1','307','1',1,'Retail Sale Id 4095',9100.00,0.00,0.00,13.00,988.00,'2023-03-13 18:49:32','',''),(4106,'1','307','1',1,'Retail Sale Id 4097',13377.00,0.00,0.00,19.11,1452.36,'2023-03-13 19:15:54','',''),(4107,'1','307','1',1,'Retail Sale Id 4098',13377.00,0.00,0.00,19.11,1452.36,'2023-03-13 19:17:49','',''),(4108,'1','307','1',1,'Retail Sale Id 4099',6300.00,0.00,0.00,9.00,684.00,'2023-03-14 08:17:11','',''),(4109,'1','307','1',1,'Retail Sale Id 4101',7000.00,0.00,0.00,10.00,760.00,'2023-03-14 08:38:32','',''),(4110,'1','307','1',1,'Retail Sale Id 4102',2800.00,0.00,0.00,4.00,304.00,'2023-03-14 08:44:34','',''),(4111,'1','307','1',1,'Retail Sale Id 4103',4900.00,0.00,0.00,7.00,532.00,'2023-03-14 09:04:14','',''),(4112,'1','307','1',1,'Retail Sale Id 4104',2100.00,0.00,0.00,3.00,228.00,'2023-03-14 09:10:50','',''),(4113,'1','307','1',1,'Retail Sale Id 4105',1001.00,0.00,0.00,1.43,108.68,'2023-03-14 09:17:24','',''),(4114,'1','307','1',1,'Distributed to Operational lost for sales id:7',3051.36,0.00,0.00,4.89,0.00,'2023-03-14 09:43:49','',''),(4115,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,1248000.00,2000.00,0.00,0.00,'2023-03-14 10:08:43','',''),(4116,'1','307',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,2000.00,0.00,'2023-03-14 10:09:38','',''),(4117,'1','307','1',1,'Received from bridging 22',0.00,0.00,2000.00,0.00,0.00,'2023-03-14 10:09:38','',''),(4118,'1','307','1',1,'Retail Sale Id 4106',4200.00,0.00,0.00,6.00,456.00,'2023-03-14 10:10:31','',''),(4119,'1','307','1',1,'Retail Sale Id 4107',1400.00,0.00,0.00,2.00,152.00,'2023-03-14 10:11:58','',''),(4120,'1','307','1',1,'Retail Sale Id 4108',2100.00,0.00,0.00,3.00,228.00,'2023-03-14 10:12:53','',''),(4121,'1','307','1',1,'Retail Sale Id 4109',32900.00,0.00,0.00,50.00,1700.00,'2023-03-14 10:14:46','',''),(4122,'1','307','1',1,'Retail Sale Id 4110',6202.00,0.00,0.00,8.86,673.36,'2023-03-14 10:15:54','',''),(4123,'1','307','1',1,'Retail Sale Id 4111',3500.00,0.00,0.00,5.00,380.00,'2023-03-14 10:22:19','',''),(4124,'1','307','1',1,'Retail Sale Id 4112',32900.00,0.00,0.00,50.00,1700.00,'2023-03-14 10:24:01','',''),(4125,'1','307','1',1,'Retail Sale Id 4113',15792.00,0.00,0.00,24.00,816.00,'2023-03-14 10:27:21','',''),(4126,'1','307','1',1,'Retail Sale Id 4114',4200.00,0.00,0.00,6.00,456.00,'2023-03-14 10:33:13','',''),(4127,'1','307','1',1,'Retail Sale Id 4115',4200.00,0.00,0.00,6.00,456.00,'2023-03-14 10:51:28','',''),(4128,'1','307','1',1,'Retail Sale Id 4116',8750.00,0.00,0.00,12.50,950.00,'2023-03-14 10:58:02','',''),(4129,'1','307','1',1,'Retail Sale Id 4117',2499.00,0.00,0.00,3.57,271.32,'2023-03-14 11:17:40','',''),(4130,'1','307','1',1,'Retail Sale Id 4118',4200.00,0.00,0.00,6.00,456.00,'2023-03-14 11:25:46','',''),(4131,'1','307','1',1,'Retail Sale Id 4119',8750.00,0.00,0.00,12.50,950.00,'2023-03-14 11:55:48','',''),(4132,'1','307','1',1,'Retail Sale Id 4120',6202.00,0.00,0.00,8.86,673.36,'2023-03-14 12:05:04','',''),(4133,'1','307','1',1,'Retail Sale Id 4121',2100.00,0.00,0.00,3.00,228.00,'2023-03-14 12:28:59','',''),(4134,'1','307','1',1,'Retail Sale Id 4122',2100.00,0.00,0.00,3.00,228.00,'2023-03-14 12:55:50','',''),(4135,'1','307','1',1,'Retail Sale Id 4123',65800.00,0.00,0.00,100.00,3400.00,'2023-03-14 13:05:27','',''),(4136,'1','307','1',1,'Retail Sale Id 4124',2800.00,0.00,0.00,4.00,304.00,'2023-03-14 13:25:16','',''),(4137,'1','307','1',1,'Retail Sale Id 4125',4200.00,0.00,0.00,6.00,456.00,'2023-03-14 13:26:42','',''),(4138,'1','307','1',1,'Retail Sale Id 4126',2100.00,0.00,0.00,3.00,228.00,'2023-03-14 13:33:19','',''),(4139,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,1984320.00,3180.00,0.00,0.00,'2023-03-14 13:47:38','',''),(4140,'1','307',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,3180.00,0.00,'2023-03-14 13:48:56','',''),(4141,'1','307','1',1,'Received from bridging 23',0.00,0.00,3180.00,0.00,0.00,'2023-03-14 13:48:56','',''),(4142,'1','307','1',1,'Retail Sale Id 4127',2800.00,0.00,0.00,4.00,304.00,'2023-03-14 13:59:54','',''),(4143,'1','307','1',1,'Retail Sale Id 4128',7000.00,0.00,0.00,10.00,760.00,'2023-03-14 14:01:11','',''),(4144,'1','307','1',1,'Retail Sale Id 4129',2100.00,0.00,0.00,3.00,228.00,'2023-03-14 14:17:00','',''),(4145,'1','307','1',1,'Retail Sale Id 4130',2100.00,0.00,0.00,3.00,228.00,'2023-03-14 14:31:38','',''),(4146,'1','307','1',1,'Retail Sale Id 4131',32900.00,0.00,0.00,50.00,1700.00,'2023-03-14 14:44:09','',''),(4147,'1','307','1',1,'Retail Sale Id 4132',2100.00,0.00,0.00,3.00,228.00,'2023-03-14 14:52:46','',''),(4148,'1','307','1',1,'Retail Sale Id 4133',4200.00,0.00,0.00,6.00,456.00,'2023-03-14 14:54:01','',''),(4149,'1','307','1',1,'Retail Sale Id 4134',17948.00,0.00,0.00,25.64,1948.64,'2023-03-14 15:30:34','',''),(4150,'1','307','1',1,'Retail Sale Id 4135',5999.00,0.00,0.00,8.57,651.32,'2023-03-14 15:44:50','',''),(4151,'1','307','1',1,'Retail Sale Id 4136',7903.00,0.00,0.00,11.29,858.04,'2023-03-14 15:45:41','',''),(4152,'1','307','1',1,'Retail Sale Id 4137',4998.00,0.00,0.00,7.14,542.64,'2023-03-14 16:17:00','',''),(4153,'1','307','1',1,'Retail Sale Id 4138',15302.00,0.00,0.00,21.86,1661.36,'2023-03-14 18:14:41','',''),(4154,'1','307','1',1,'Retail Sale Id 4139',15400.00,0.00,0.00,22.00,1672.00,'2023-03-14 18:15:24','',''),(4155,'1','307','1',1,'Retail Sale Id 4140',15400.00,0.00,0.00,22.00,1672.00,'2023-03-14 18:16:11','',''),(4156,'1','307','1',1,'Retail Sale Id 4141',4200.00,0.00,0.00,6.00,456.00,'2023-03-14 18:18:27','',''),(4157,'1','307','1',1,'Retail Sale Id 4142',4200.00,0.00,0.00,6.00,456.00,'2023-03-14 18:19:22','',''),(4158,'1','307','1',1,'Retail Sale Id 4143',3003.00,0.00,0.00,4.29,326.04,'2023-03-14 18:21:20','',''),(4159,'1','307','1',1,'Retail Sale Id 4144',7000.00,0.00,0.00,10.00,760.00,'2023-03-14 18:22:15','',''),(4160,'1','307','1',1,'Retail Sale Id 4145',9548.00,0.00,0.00,13.64,1036.64,'2023-03-14 18:39:22','',''),(4161,'1','307','1',1,'Retail Sale Id 4146',11200.00,0.00,0.00,16.00,1216.00,'2023-03-14 19:08:26','',''),(4162,'1','307','1',1,'Retail Sale Id 4147',11200.00,0.00,0.00,16.00,1216.00,'2023-03-14 19:09:10','',''),(4163,'1','307','1',1,'Retail Sale Id 4148',11298.00,0.00,0.00,16.14,1226.64,'2023-03-14 19:09:58','',''),(4164,'1','307','1',1,'Return of Retail Sale Id 4139',0.00,15400.00,22.00,0.00,-1672.00,'2023-03-14 19:45:33','',''),(4165,'1','307','1',1,'Return of Retail Sale Id 4146',0.00,11200.00,16.00,0.00,-1216.00,'2023-03-14 19:47:31','',''),(4166,'1','307','1',1,'Retail Sale Id 4149',20100.00,0.00,0.00,1.00,19476.00,'2023-03-14 19:49:01','',''),(4167,'1','307','1',1,'Return of Retail Sale Id 4134',0.00,17948.00,25.64,0.00,-1948.64,'2023-03-14 19:55:32','',''),(4168,'1','307','1',1,'Retail Sale Id 4150',3003.00,0.00,0.00,4.29,326.04,'2023-03-15 07:21:38','',''),(4169,'1','307','1',1,'Retail Sale Id 4151',7000.00,0.00,0.00,10.00,760.00,'2023-03-15 07:29:08','',''),(4170,'1','307','1',1,'Retail Sale Id 4152',4200.00,0.00,0.00,6.00,456.00,'2023-03-15 07:31:02','',''),(4171,'1','307','1',1,'Retail Sale Id 4153',4200.00,0.00,0.00,6.00,456.00,'2023-03-15 07:36:07','',''),(4172,'1','307','1',1,'Retail Sale Id 4154',1498.00,0.00,0.00,2.14,162.64,'2023-03-15 07:41:47','',''),(4173,'1','307','1',1,'Retail Sale Id 4155',2100.00,0.00,0.00,3.00,228.00,'2023-03-15 07:43:40','',''),(4174,'1','307','1',1,'Retail Sale Id 4156',8750.00,0.00,0.00,12.50,950.00,'2023-03-15 07:45:52','',''),(4175,'1','307','1',1,'Retail Sale Id 4157',4200.00,0.00,0.00,6.00,456.00,'2023-03-15 08:09:18','',''),(4176,'1','307','1',1,'Retail Sale Id 4158',3500.00,0.00,0.00,5.00,380.00,'2023-03-15 08:14:43','',''),(4177,'1','307','1',1,'Retail Sale Id 4159',3997.00,0.00,0.00,5.71,433.96,'2023-03-15 08:15:36','',''),(4178,'1','307','1',1,'Retail Sale Id 4160',8750.00,0.00,0.00,12.50,950.00,'2023-03-15 08:18:10','',''),(4179,'1','307','1',1,'Retail Sale Id 4161',497.00,0.00,0.00,0.71,53.96,'2023-03-15 08:21:47','',''),(4180,'1','307','1',1,'Retail Sale Id 4162',2499.00,0.00,0.00,3.57,271.32,'2023-03-15 08:23:11','',''),(4181,'1','307','1',1,'Retail Sale Id 4163',4200.00,0.00,0.00,6.00,456.00,'2023-03-15 08:24:29','',''),(4182,'1','307','1',1,'Retail Sale Id 4164',1498.00,0.00,0.00,2.14,162.64,'2023-03-15 08:25:36','',''),(4183,'1','307','1',1,'Retail Sale Id 4165',1498.00,0.00,0.00,2.14,162.64,'2023-03-15 08:26:27','',''),(4184,'1','307','1',1,'Retail Sale Id 4166',4200.00,0.00,0.00,6.00,456.00,'2023-03-15 08:29:19','',''),(4185,'1','307','1',1,'Return of Retail Sale Id 4164',0.00,1498.00,2.14,0.00,-162.64,'2023-03-15 08:31:04','',''),(4186,'1','307','1',1,'Retail Sale Id 4167',32900.00,0.00,0.00,50.00,1700.00,'2023-03-15 08:35:43','',''),(4187,'1','307','1',1,'Retail Sale Id 4168',2800.00,0.00,0.00,4.00,304.00,'2023-03-15 08:49:07','',''),(4188,'1','307','1',1,'Retail Sale Id 4169',2800.00,0.00,0.00,4.00,304.00,'2023-03-15 08:56:39','',''),(4189,'1','307','1',1,'Retail Sale Id 4170',3500.00,0.00,0.00,5.00,380.00,'2023-03-15 09:10:51','',''),(4190,'1','307','1',1,'Retail Sale Id 4172',1400.00,0.00,0.00,2.00,152.00,'2023-03-15 09:24:26','',''),(4191,'1','307','1',1,'Retail Sale Id 4173',12950.00,0.00,0.00,18.50,1406.00,'2023-03-15 09:34:28','',''),(4192,'1','307','1',1,'Retail Sale Id 4174',1001.00,0.00,0.00,1.43,108.68,'2023-03-15 09:37:04','',''),(4193,'1','307','1',1,'Retail Sale Id 4175',2100.00,0.00,0.00,3.00,228.00,'2023-03-15 09:39:27','',''),(4194,'1','307','1',1,'Retail Sale Id 4176',3500.00,0.00,0.00,5.00,380.00,'2023-03-15 09:48:00','',''),(4195,'1','307','1',1,'Retail Sale Id 4177',4200.00,0.00,0.00,6.00,456.00,'2023-03-15 09:54:21','',''),(4196,'1','307','1',1,'Retail Sale Id 4178',3500.00,0.00,0.00,5.00,380.00,'2023-03-15 10:10:44','',''),(4197,'1','307','1',1,'Retail Sale Id 4179',2100.00,0.00,0.00,3.00,228.00,'2023-03-15 10:21:34','',''),(4198,'1','307','1',1,'Retail Sale Id 4181',1400.00,0.00,0.00,2.00,152.00,'2023-03-15 10:26:19','',''),(4199,'1','307','1',1,'Retail Sale Id 4183',4200.00,0.00,0.00,6.00,456.00,'2023-03-15 10:54:40','',''),(4200,'1','307','1',1,'Retail Sale Id 4184',2800.00,0.00,0.00,4.00,304.00,'2023-03-15 11:15:09','',''),(4201,'1','307','1',1,'Retail Sale Id 4185',2100.00,0.00,0.00,3.00,228.00,'2023-03-15 11:17:12','',''),(4202,'1','307','1',1,'Retail Sale Id 4186',700.00,0.00,0.00,1.00,76.00,'2023-03-15 11:18:41','',''),(4203,'1','307','1',1,'Retail Sale Id 4187',2100.00,0.00,0.00,3.00,228.00,'2023-03-15 11:19:59','',''),(4204,'1','307','1',1,'Retail Sale Id 4188',8750.00,0.00,0.00,12.50,950.00,'2023-03-15 11:29:46','',''),(4205,'1','307','1',1,'Retail Sale Id 4189',8750.00,0.00,0.00,12.50,950.00,'2023-03-15 11:31:50','',''),(4206,'1','307','1',1,'Retail Sale Id 4190',1001.00,0.00,0.00,1.43,108.68,'2023-03-15 12:00:32','',''),(4207,'1','307','1',1,'Retail Sale Id 4191',8750.00,0.00,0.00,12.50,950.00,'2023-03-15 12:07:23','',''),(4208,'1','307','1',1,'Retail Sale Id 4192',3500.00,0.00,0.00,5.00,380.00,'2023-03-15 12:17:51','',''),(4209,'1','307','1',1,'Retail Sale Id 4193',1001.00,0.00,0.00,1.43,108.68,'2023-03-15 12:26:13','',''),(4210,'1','307','1',1,'Retail Sale Id 4194',41125.00,0.00,0.00,62.50,2125.00,'2023-03-15 12:35:24','',''),(4211,'1','307','1',1,'Retail Sale Id 4195',4200.00,0.00,0.00,6.00,456.00,'2023-03-15 12:44:02','',''),(4212,'1','307','1',1,'Retail Sale Id 4196',1400.00,0.00,0.00,2.00,152.00,'2023-03-15 13:23:58','',''),(4213,'1','307','1',1,'Retail Sale Id 4197',4200.00,0.00,0.00,6.00,456.00,'2023-03-15 13:27:15','',''),(4214,'1','307','1',1,'Retail Sale Id 4198',8750.00,0.00,0.00,12.50,950.00,'2023-03-15 13:29:43','',''),(4215,'1','307','1',1,'Retail Sale Id 4199',1400.00,0.00,0.00,2.00,152.00,'2023-03-15 13:35:21','',''),(4216,'1','307','1',1,'Retail Sale Id 4200',3500.00,0.00,0.00,5.00,380.00,'2023-03-15 13:51:10','',''),(4217,'1','307','1',1,'Retail Sale Id 4201',6503.00,0.00,0.00,9.29,706.04,'2023-03-15 13:52:37','',''),(4218,'1','307','1',1,'Retail Sale Id 4202',1400.00,0.00,0.00,2.00,152.00,'2023-03-15 14:05:55','',''),(4219,'1','307','1',1,'Retail Sale Id 4203',9597.00,0.00,0.00,13.71,1041.96,'2023-03-15 14:29:21','',''),(4220,'1','307','1',1,'Retail Sale Id 4204',2100.00,0.00,0.00,3.00,228.00,'2023-03-15 14:55:02','',''),(4221,'1','307','1',1,'Retail Sale Id 4205',8750.00,0.00,0.00,12.50,950.00,'2023-03-15 15:04:38','',''),(4222,'1','307','1',1,'Retail Sale Id 4206',10500.00,0.00,0.00,15.00,1140.00,'2023-03-15 16:19:36','',''),(4223,'1','307','1',1,'Retail Sale Id 4207',2800.00,0.00,0.00,4.00,304.00,'2023-03-15 18:42:10','',''),(4224,'1','307','1',1,'Retail Sale Id 4208',3500.00,0.00,0.00,5.00,380.00,'2023-03-15 18:43:28','',''),(4225,'1','307','1',1,'Retail Sale Id 4209',11501.00,0.00,0.00,16.43,1248.68,'2023-03-15 18:46:12','',''),(4226,'1','307','1',1,'Retail Sale Id 4210',145042.94,0.00,0.00,220.43,7494.62,'2023-03-15 18:51:36','',''),(4227,'1','307','1',1,'Retail Sale Id 4211',65800.00,0.00,0.00,100.00,3400.00,'2023-03-15 18:52:27','',''),(4228,'1','307','1',1,'Retail Sale Id 4212',8400.00,0.00,0.00,12.00,912.00,'2023-03-15 19:07:22','',''),(4229,'1','307','1',1,'Retail Sale Id 4213',5600.00,0.00,0.00,8.00,608.00,'2023-03-15 19:08:31','',''),(4230,'1','307','1',1,'Retail Sale Id 4214',4200.00,0.00,0.00,6.00,456.00,'2023-03-15 19:09:29','',''),(4231,'1','307','1',1,'Retail Sale Id 4215',8708.00,0.00,0.00,12.44,945.44,'2023-03-15 19:13:47','',''),(4232,'1','307','1',1,'Retail Sale Id 4216',7700.00,0.00,0.00,11.00,836.00,'2023-03-15 19:30:06','',''),(4233,'1','307','1',1,'Retail Sale Id 4218',8750.00,0.00,0.00,12.50,950.00,'2023-03-15 19:32:24','',''),(4234,'1','307','1',1,'Retail Sale Id 4219',4200.00,0.00,0.00,6.00,456.00,'2023-03-15 19:36:14','',''),(4235,'1','307','1',1,'Retail Sale Id 4220',65800.00,0.00,0.00,100.00,3400.00,'2023-03-16 07:23:47','',''),(4236,'1','307','1',1,'Retail Sale Id 4221',8750.00,0.00,0.00,12.50,950.00,'2023-03-16 07:27:45','',''),(4237,'1','307','1',1,'Retail Sale Id 4222',4200.00,0.00,0.00,6.00,456.00,'2023-03-16 08:00:14','',''),(4238,'1','307','1',1,'Retail Sale Id 4223',44415.00,0.00,0.00,67.50,2295.00,'2023-03-16 08:18:54','',''),(4239,'1','307','1',1,'Retail Sale Id 4224',2100.00,0.00,0.00,3.00,228.00,'2023-03-16 08:20:06','',''),(4240,'1','307','1',1,'Retail Sale Id 4225',2100.00,0.00,0.00,3.00,228.00,'2023-03-16 08:21:06','',''),(4241,'1','307','1',1,'Retail Sale Id 4226',65800.00,0.00,0.00,100.00,3400.00,'2023-03-16 08:32:24','',''),(4242,'1','307','1',1,'Retail Sale Id 4227',2800.00,0.00,0.00,4.00,304.00,'2023-03-16 08:35:45','',''),(4243,'1','307','1',1,'Retail Sale Id 4228',4200.00,0.00,0.00,6.00,456.00,'2023-03-16 08:37:41','',''),(4244,'1','307','1',1,'Retail Sale Id 4229',7000.00,0.00,0.00,10.00,760.00,'2023-03-16 08:44:19','',''),(4245,'1','307','1',1,'Retail Sale Id 4230',1400.00,0.00,0.00,2.00,152.00,'2023-03-16 08:47:44','',''),(4246,'1','307','1',1,'Retail Sale Id 4231',4200.00,0.00,0.00,6.00,456.00,'2023-03-16 08:55:42','',''),(4247,'1','307','1',1,'Retail Sale Id 4232',1400.00,0.00,0.00,2.00,152.00,'2023-03-16 09:13:13','',''),(4248,'1','307','1',1,'Retail Sale Id 4233',8750.00,0.00,0.00,12.50,950.00,'2023-03-16 09:14:51','',''),(4249,'1','307','1',1,'Retail Sale Id 4234',3003.00,0.00,0.00,4.29,326.04,'2023-03-16 09:25:34','',''),(4250,'1','307','1',1,'Retail Sale Id 4235',4200.00,0.00,0.00,6.00,456.00,'2023-03-16 09:28:25','',''),(4251,'1','307','1',1,'Retail Sale Id 4236',2100.00,0.00,0.00,3.00,228.00,'2023-03-16 09:31:17','',''),(4252,'1','307','1',1,'Retail Sale Id 4237',2100.00,0.00,0.00,3.00,228.00,'2023-03-16 09:38:06','',''),(4253,'1','307','1',1,'Retail Sale Id 4238',36190.00,0.00,0.00,55.00,1870.00,'2023-03-16 09:51:43','',''),(4254,'1','307','1',1,'Retail Sale Id 4239',1400.00,0.00,0.00,2.00,152.00,'2023-03-16 09:58:04','',''),(4255,'1','307','1',1,'Retail Sale Id 4240',12600.00,0.00,0.00,18.00,1368.00,'2023-03-16 10:49:16','',''),(4256,'1','307','1',1,'Retail Sale Id 4241',2100.00,0.00,0.00,3.00,228.00,'2023-03-16 10:58:58','',''),(4257,'1','307','1',1,'Retail Sale Id 4242',2100.00,0.00,0.00,3.00,228.00,'2023-03-16 11:08:08','',''),(4258,'1','307','1',1,'Retail Sale Id 4243',1400.00,0.00,0.00,2.00,152.00,'2023-03-16 11:20:40','',''),(4259,'1','307','1',1,'Retail Sale Id 4244',32900.00,0.00,0.00,50.00,1700.00,'2023-03-16 11:25:52','',''),(4260,'1','307','1',1,'Retail Sale Id 4245',32900.00,0.00,0.00,50.00,1700.00,'2023-03-16 11:28:55','',''),(4261,'1','307','1',1,'Retail Sale Id 4246',2800.00,0.00,0.00,4.00,304.00,'2023-03-16 12:29:12','',''),(4262,'1','307','1',1,'Retail Sale Id 4247',4200.00,0.00,0.00,6.00,456.00,'2023-03-16 12:55:59','',''),(4263,'1','307','1',1,'Retail Sale Id 4248',2002.00,0.00,0.00,2.86,217.36,'2023-03-16 13:04:04','',''),(4264,'1','307','1',1,'Retail Sale Id 4249',1400.00,0.00,0.00,2.00,152.00,'2023-03-16 13:23:26','',''),(4265,'1','307','1',1,'Retail Sale Id 4250',7000.00,0.00,0.00,10.00,760.00,'2023-03-16 13:31:26','',''),(4266,'1','307','1',1,'Retail Sale Id 4251',3500.00,0.00,0.00,5.00,380.00,'2023-03-16 13:34:51','',''),(4267,'1','307','1',1,'Retail Sale Id 4252',5502.00,0.00,0.00,7.86,597.36,'2023-03-16 13:36:39','',''),(4268,'1','307','1',1,'Retail Sale Id 4253',49350.00,0.00,0.00,75.00,2550.00,'2023-03-16 14:08:01','',''),(4269,'1','307','1',1,'Retail Sale Id 4254',2100.00,0.00,0.00,3.00,228.00,'2023-03-16 15:58:01','',''),(4270,'1','307','1',1,'Retail Sale Id 4255',2100.00,0.00,0.00,3.00,228.00,'2023-03-16 16:12:27','',''),(4271,'1','307','1',1,'Retail Sale Id 4256',8001.00,0.00,0.00,11.43,868.68,'2023-03-16 16:15:10','',''),(4272,'1','307','1',1,'Retail Sale Id 4257',8001.00,0.00,0.00,11.43,868.68,'2023-03-16 16:16:51','',''),(4273,'1','307','1',1,'Retail Sale Id 4259',8001.00,0.00,0.00,11.43,868.68,'2023-03-16 16:19:43','',''),(4274,'1','307','1',1,'Retail Sale Id 4260',3850.00,0.00,0.00,5.50,418.00,'2023-03-16 16:44:52','',''),(4275,'1','307','1',1,'Retail Sale Id 4261',7000.00,0.00,0.00,10.00,760.00,'2023-03-16 16:50:26','',''),(4276,'1','307','1',1,'Retail Sale Id 4262',1498.00,0.00,0.00,2.14,162.64,'2023-03-16 17:29:09','',''),(4277,'1','307','1',1,'Retail Sale Id 4263',9702.00,0.00,0.00,13.86,1053.36,'2023-03-16 17:30:41','',''),(4278,'1','307','1',1,'Retail Sale Id 4264',32900.00,0.00,0.00,50.00,1700.00,'2023-03-16 17:40:11','',''),(4279,'1','307','1',1,'Retail Sale Id 4265',4200.00,0.00,0.00,6.00,456.00,'2023-03-16 17:43:02','',''),(4280,'1','307','1',1,'Retail Sale Id 4266',6300.00,0.00,0.00,9.00,684.00,'2023-03-16 17:54:58','',''),(4281,'1','307','1',1,'Retail Sale Id 4267',3500.00,0.00,0.00,5.00,380.00,'2023-03-16 18:36:57','',''),(4282,'1','307','1',1,'Retail Sale Id 4268',14000.00,0.00,0.00,20.00,1520.00,'2023-03-16 18:39:42','',''),(4283,'1','307','1',1,'Retail Sale Id 4269',4900.00,0.00,0.00,7.00,532.00,'2023-03-16 18:47:48','',''),(4284,'1','307','1',1,'Retail Sale Id 4270',8750.00,0.00,0.00,12.50,950.00,'2023-03-16 18:50:56','',''),(4285,'1','307','1',1,'Retail Sale Id 4271',16450.00,0.00,0.00,23.50,1786.00,'2023-03-16 19:19:08','',''),(4286,'1','307','1',1,'Retail Sale Id 4272',25641.00,0.00,0.00,36.63,2783.88,'2023-03-16 19:26:58','',''),(4287,'1','307','1',1,'Retail Sale Id 4273',2100.00,0.00,0.00,3.00,228.00,'2023-03-17 07:17:03','',''),(4288,'1','307','1',1,'Retail Sale Id 4274',8750.00,0.00,0.00,12.50,950.00,'2023-03-17 07:48:09','',''),(4289,'1','307','1',1,'Retail Sale Id 4275',2100.00,0.00,0.00,3.00,228.00,'2023-03-17 07:52:15','',''),(4290,'1','307','1',1,'Retail Sale Id 4276',4200.00,0.00,0.00,6.00,456.00,'2023-03-17 07:54:42','',''),(4291,'1','307','1',1,'Retail Sale Id 4277',2100.00,0.00,0.00,3.00,228.00,'2023-03-17 07:58:20','',''),(4292,'1','307','1',1,'Retail Sale Id 4278',5803.00,0.00,0.00,8.29,630.04,'2023-03-17 08:01:22','',''),(4293,'1','307','1',1,'Retail Sale Id 4279',3500.00,0.00,0.00,5.00,380.00,'2023-03-17 08:07:42','',''),(4294,'1','307','1',1,'Retail Sale Id 4280',4200.00,0.00,0.00,6.00,456.00,'2023-03-17 08:14:18','',''),(4295,'1','307','1',1,'Retail Sale Id 4281',4200.00,0.00,0.00,6.00,456.00,'2023-03-17 08:15:26','',''),(4296,'1','307','1',1,'Retail Sale Id 4282',7000.00,0.00,0.00,10.00,760.00,'2023-03-17 08:20:16','',''),(4297,'1','307','1',1,'Retail Sale Id 4283',8750.00,0.00,0.00,12.50,950.00,'2023-03-17 08:26:42','',''),(4298,'1','307','1',1,'Retail Sale Id 4284',32900.00,0.00,0.00,50.00,1700.00,'2023-03-17 08:29:43','',''),(4299,'1','307','1',1,'Retail Sale Id 4285',2100.00,0.00,0.00,3.00,228.00,'2023-03-17 08:36:49','',''),(4300,'1','307','1',1,'Retail Sale Id 4286',8750.00,0.00,0.00,12.50,950.00,'2023-03-17 08:38:44','',''),(4301,'1','307','1',1,'Retail Sale Id 4287',4200.00,0.00,0.00,6.00,456.00,'2023-03-17 08:43:46','',''),(4302,'1','307','1',1,'Retail Sale Id 4288',4200.00,0.00,0.00,6.00,456.00,'2023-03-17 08:48:07','',''),(4303,'1','307','1',1,'Retail Sale Id 4289',3500.00,0.00,0.00,5.00,380.00,'2023-03-17 08:49:15','',''),(4304,'1','307','1',1,'Retail Sale Id 4291',2100.00,0.00,0.00,3.00,228.00,'2023-03-17 08:59:26','',''),(4305,'1','307','1',1,'Retail Sale Id 4292',2800.00,0.00,0.00,4.00,304.00,'2023-03-17 09:06:05','',''),(4306,'1','307','1',1,'Retail Sale Id 4293',2800.00,0.00,0.00,4.00,304.00,'2023-03-17 09:09:15','',''),(4307,'1','307','1',1,'Retail Sale Id 4294',4200.00,0.00,0.00,6.00,456.00,'2023-03-17 09:15:09','',''),(4308,'1','307','1',1,'Retail Sale Id 4295',2100.00,0.00,0.00,3.00,228.00,'2023-03-17 09:16:39','',''),(4309,'1','307','1',1,'Retail Sale Id 4296',2002.00,0.00,0.00,2.86,217.36,'2023-03-17 09:28:58','',''),(4310,'1','307','1',1,'Retail Sale Id 4297',2100.00,0.00,0.00,3.00,228.00,'2023-03-17 09:48:48','',''),(4311,'1','307','1',1,'Retail Sale Id 4299',12250.00,0.00,0.00,17.50,1330.00,'2023-03-17 10:24:15','',''),(4312,'1','307','1',1,'Retail Sale Id 4300',4200.00,0.00,0.00,6.00,456.00,'2023-03-17 10:40:00','',''),(4313,'1','307','1',1,'Retail Sale Id 4301',2800.00,0.00,0.00,4.00,304.00,'2023-03-17 11:00:41','',''),(4314,'1','307','1',1,'Retail Sale Id 4302',2100.00,0.00,0.00,3.00,228.00,'2023-03-17 11:01:28','',''),(4315,'1','307','1',1,'Retail Sale Id 4303',1400.00,0.00,0.00,2.00,152.00,'2023-03-17 11:04:42','',''),(4316,'1','307','1',1,'Retail Sale Id 4304',2100.00,0.00,0.00,3.00,228.00,'2023-03-17 11:11:29','',''),(4317,'1','307','1',1,'Retail Sale Id 4305',8400.00,0.00,0.00,12.00,912.00,'2023-03-17 11:35:32','',''),(4318,'1','307','1',1,'Retail Sale Id 4306',32900.00,0.00,0.00,50.00,1700.00,'2023-03-17 11:40:25','',''),(4319,'1','307','1',1,'Retail Sale Id 4307',3500.00,0.00,0.00,5.00,380.00,'2023-03-17 11:52:07','',''),(4320,'1','307','1',1,'Retail Sale Id 4308',1400.00,0.00,0.00,2.00,152.00,'2023-03-17 11:52:57','',''),(4321,'1','307','1',1,'Retail Sale Id 4309',34545.00,0.00,0.00,52.50,1785.00,'2023-03-17 12:21:26','',''),(4322,'1','307','1',1,'Retail Sale Id 4310',2002.00,0.00,0.00,2.86,217.36,'2023-03-17 12:24:06','',''),(4323,'1','307','1',1,'Retail Sale Id 4311',14000.00,0.00,0.00,20.00,1520.00,'2023-03-17 13:19:25','',''),(4324,'1','307','1',1,'Retail Sale Id 4312',2100.00,0.00,0.00,3.00,228.00,'2023-03-17 13:54:44','',''),(4325,'1','307','1',1,'Retail Sale Id 4313',4200.00,0.00,0.00,6.00,456.00,'2023-03-17 13:55:40','',''),(4326,'1','307','1',1,'Retail Sale Id 4314',1400.00,0.00,0.00,2.00,152.00,'2023-03-17 14:09:26','',''),(4327,'1','307','1',1,'Retail Sale Id 4315',1400.00,0.00,0.00,2.00,152.00,'2023-03-17 14:10:13','',''),(4328,'1','307','1',1,'Retail Sale Id 4316',2100.00,0.00,0.00,3.00,228.00,'2023-03-17 14:25:33','',''),(4329,'1','307','1',1,'Retail Sale Id 4317',2499.00,0.00,0.00,3.57,271.32,'2023-03-17 14:28:01','',''),(4330,'1','307','1',1,'Retail Sale Id 4318',11550.00,0.00,0.00,16.50,1254.00,'2023-03-17 14:29:16','',''),(4331,'1','307','1',1,'Retail Sale Id 4319',3500.00,0.00,0.00,5.00,380.00,'2023-03-17 14:31:33','',''),(4332,'1','307','1',1,'Retail Sale Id 4320',2499.00,0.00,0.00,3.57,271.32,'2023-03-17 14:37:59','',''),(4333,'1','307','1',1,'Retail Sale Id 4321',2100.00,0.00,0.00,3.00,228.00,'2023-03-17 14:45:49','',''),(4334,'1','307','1',1,'Retail Sale Id 4322',4200.00,0.00,0.00,6.00,456.00,'2023-03-17 15:02:03','',''),(4335,'1','307','1',1,'Retail Sale Id 4323',2800.00,0.00,0.00,4.00,304.00,'2023-03-17 15:08:08','',''),(4336,'1','307','1',1,'Retail Sale Id 4324',8750.00,0.00,0.00,12.50,950.00,'2023-03-17 15:22:00','',''),(4337,'1','307','1',1,'Retail Sale Id 4325',2100.00,0.00,0.00,3.00,228.00,'2023-03-17 15:25:57','',''),(4338,'1','307','1',1,'Retail Sale Id 4326',7000.00,0.00,0.00,10.00,760.00,'2023-03-17 15:33:31','',''),(4339,'1','307','1',1,'Retail Sale Id 4327',65800.00,0.00,0.00,100.00,3400.00,'2023-03-17 15:41:24','',''),(4340,'1','307','1',1,'Retail Sale Id 4328',4200.00,0.00,0.00,6.00,456.00,'2023-03-17 16:15:34','',''),(4341,'1','307','1',1,'Retail Sale Id 4329',1498.00,0.00,0.00,2.14,162.64,'2023-03-17 16:17:48','',''),(4342,'1','307','1',1,'Retail Sale Id 4330',8603.00,0.00,0.00,12.29,934.04,'2023-03-17 17:11:23','',''),(4343,'1','307','1',1,'Retail Sale Id 4331',32900.00,0.00,0.00,50.00,1700.00,'2023-03-17 17:12:47','',''),(4344,'1','307','1',1,'Retail Sale Id 4332',4200.00,0.00,0.00,6.00,456.00,'2023-03-17 17:20:57','',''),(4345,'1','307','1',1,'Retail Sale Id 4333',2002.00,0.00,0.00,2.86,217.36,'2023-03-17 17:27:26','',''),(4346,'1','307','1',1,'Retail Sale Id 4334',5600.00,0.00,0.00,8.00,608.00,'2023-03-17 17:28:25','',''),(4347,'1','307','1',1,'Retail Sale Id 4335',17703.00,0.00,0.00,25.29,1922.04,'2023-03-17 17:52:25','',''),(4348,'1','307','1',1,'Retail Sale Id 4336',18298.00,0.00,0.00,26.14,1986.64,'2023-03-17 18:14:24','',''),(4349,'1','307','1',1,'Retail Sale Id 4337',2800.00,0.00,0.00,4.00,304.00,'2023-03-17 18:15:17','',''),(4350,'1','307','1',1,'Retail Sale Id 4338',10199.00,0.00,0.00,14.57,1107.32,'2023-03-17 18:33:52','',''),(4351,'1','307','1',1,'Retail Sale Id 4339',12950.00,0.00,0.00,18.50,1406.00,'2023-03-17 18:34:47','',''),(4352,'1','307','1',1,'Retail Sale Id 4340',9282.00,0.00,0.00,13.26,1007.76,'2023-03-17 19:10:18','',''),(4353,'1','307','1',1,'Retail Sale Id 4341',2100.00,0.00,0.00,3.00,228.00,'2023-03-19 08:06:13','',''),(4354,'1','307','1',1,'Retail Sale Id 4342',8750.00,0.00,0.00,12.50,950.00,'2023-03-19 08:08:04','',''),(4355,'1','307','1',1,'Retail Sale Id 4343',4200.00,0.00,0.00,6.00,456.00,'2023-03-19 08:11:10','',''),(4356,'1','307','1',1,'Retail Sale Id 4344',1400.00,0.00,0.00,2.00,152.00,'2023-03-19 08:26:18','',''),(4357,'1','307','1',1,'Retail Sale Id 4345',3003.00,0.00,0.00,4.29,326.04,'2023-03-19 08:29:05','',''),(4358,'1','307','1',1,'Retail Sale Id 4346',4200.00,0.00,0.00,6.00,456.00,'2023-03-19 08:31:28','',''),(4359,'1','307','1',1,'Retail Sale Id 4347',4998.00,0.00,0.00,7.14,542.64,'2023-03-19 08:43:42','',''),(4360,'1','307','1',1,'Retail Sale Id 4348',3500.00,0.00,0.00,5.00,380.00,'2023-03-19 08:51:12','',''),(4361,'1','307','1',1,'Retail Sale Id 4349',3003.00,0.00,0.00,4.29,326.04,'2023-03-19 08:52:25','',''),(4362,'1','307','1',1,'Retail Sale Id 4350',2800.00,0.00,0.00,4.00,304.00,'2023-03-19 08:55:06','',''),(4363,'1','307','1',1,'Retail Sale Id 4351',4200.00,0.00,0.00,6.00,456.00,'2023-03-19 09:08:24','',''),(4364,'1','307','1',1,'Retail Sale Id 4352',4200.00,0.00,0.00,6.00,456.00,'2023-03-19 09:09:21','',''),(4365,'1','307','1',1,'Retail Sale Id 4353',1498.00,0.00,0.00,2.14,162.64,'2023-03-19 09:12:48','',''),(4366,'1','307','1',1,'Retail Sale Id 4354',2002.00,0.00,0.00,2.86,217.36,'2023-03-19 09:30:25','',''),(4367,'1','307','1',1,'Retail Sale Id 4355',4200.00,0.00,0.00,6.00,456.00,'2023-03-19 09:35:35','',''),(4368,'1','307','1',1,'Retail Sale Id 4356',1799.00,0.00,0.00,2.57,195.32,'2023-03-19 09:39:17','',''),(4369,'1','307','1',1,'Retail Sale Id 4357',2100.00,0.00,0.00,3.00,228.00,'2023-03-19 10:00:09','',''),(4370,'1','307','1',1,'Retail Sale Id 4358',1400.00,0.00,0.00,2.00,152.00,'2023-03-19 10:06:23','',''),(4371,'1','307','1',1,'Retail Sale Id 4359',3500.00,0.00,0.00,5.00,380.00,'2023-03-19 10:13:27','',''),(4372,'1','307','1',1,'Retail Sale Id 4360',2100.00,0.00,0.00,3.00,228.00,'2023-03-19 10:16:45','',''),(4373,'1','307','1',1,'Retail Sale Id 4361',2002.00,0.00,0.00,2.86,217.36,'2023-03-19 10:22:05','',''),(4374,'1','307','1',1,'Retail Sale Id 4362',4200.00,0.00,0.00,6.00,456.00,'2023-03-19 10:25:40','',''),(4375,'1','307','1',1,'Retail Sale Id 4363',8750.00,0.00,0.00,12.50,950.00,'2023-03-19 10:26:55','',''),(4376,'1','307','1',1,'Retail Sale Id 4364',3500.00,0.00,0.00,5.00,380.00,'2023-03-19 10:35:55','',''),(4377,'1','307','1',1,'Retail Sale Id 4365',3997.00,0.00,0.00,5.71,433.96,'2023-03-19 11:06:03','',''),(4378,'1','307','1',1,'Retail Sale Id 4366',3500.00,0.00,0.00,5.00,380.00,'2023-03-19 11:17:44','',''),(4379,'1','307','1',1,'Retail Sale Id 4367',3003.00,0.00,0.00,4.29,326.04,'2023-03-19 11:20:38','',''),(4380,'1','307','1',1,'Retail Sale Id 4368',2100.00,0.00,0.00,3.00,228.00,'2023-03-19 11:34:45','',''),(4381,'1','307','1',1,'Retail Sale Id 4369',1400.00,0.00,0.00,2.00,152.00,'2023-03-19 11:35:44','',''),(4382,'1','307','1',1,'Retail Sale Id 4370',3500.00,0.00,0.00,5.00,380.00,'2023-03-19 11:37:36','',''),(4383,'1','307','1',1,'Retail Sale Id 4371',1400.00,0.00,0.00,2.00,152.00,'2023-03-19 11:39:00','',''),(4384,'1','307','1',1,'Retail Sale Id 4372',3997.00,0.00,0.00,5.71,433.96,'2023-03-19 11:42:05','',''),(4385,'1','307','1',1,'Retail Sale Id 4373',4200.00,0.00,0.00,6.00,456.00,'2023-03-19 11:44:58','',''),(4386,'1','307','1',1,'Retail Sale Id 4374',3003.00,0.00,0.00,4.29,326.04,'2023-03-19 11:46:47','',''),(4387,'1','307','1',1,'Retail Sale Id 4375',2100.00,0.00,0.00,3.00,228.00,'2023-03-19 11:52:11','',''),(4388,'1','307','1',1,'Retail Sale Id 4376',2100.00,0.00,0.00,3.00,228.00,'2023-03-19 11:53:46','',''),(4389,'1','307','1',1,'Retail Sale Id 4377',1498.00,0.00,0.00,2.14,162.64,'2023-03-19 12:05:24','',''),(4390,'1','307','1',1,'Retail Sale Id 4378',4200.00,0.00,0.00,6.00,456.00,'2023-03-19 13:20:30','',''),(4391,'1','307','1',1,'Retail Sale Id 4379',2800.00,0.00,0.00,4.00,304.00,'2023-03-19 13:22:04','',''),(4392,'1','307','1',1,'Retail Sale Id 4380',497.00,0.00,0.00,0.71,53.96,'2023-03-19 13:27:55','',''),(4393,'1','307','1',1,'Retail Sale Id 4381',8750.00,0.00,0.00,12.50,950.00,'2023-03-19 13:28:44','',''),(4394,'1','307','1',1,'Retail Sale Id 4382',8750.00,0.00,0.00,12.50,950.00,'2023-03-19 13:30:09','',''),(4395,'1','307','1',1,'Retail Sale Id 4383',8750.00,0.00,0.00,12.50,950.00,'2023-03-19 13:32:06','',''),(4396,'1','307','1',1,'Retail Sale Id 4384',2800.00,0.00,0.00,4.00,304.00,'2023-03-19 13:36:53','',''),(4397,'1','307','1',1,'Retail Sale Id 4385',53802.00,0.00,0.00,76.86,5841.36,'2023-03-19 13:42:59','',''),(4398,'1','307','1',1,'Retail Sale Id 4386',8750.00,0.00,0.00,12.50,950.00,'2023-03-19 13:46:50','',''),(4399,'1','307','1',1,'Retail Sale Id 4387',2100.00,0.00,0.00,3.00,228.00,'2023-03-19 13:49:43','',''),(4400,'1','307','1',1,'Retail Sale Id 4388',1498.00,0.00,0.00,2.14,162.64,'2023-03-19 14:26:52','',''),(4401,'1','307','1',1,'Retail Sale Id 4389',12950.00,0.00,0.00,18.50,1406.00,'2023-03-19 14:31:41','',''),(4402,'1','307','1',1,'Retail Sale Id 4390',700.00,0.00,0.00,1.00,76.00,'2023-03-19 14:33:27','',''),(4403,'1','307','1',1,'Retail Sale Id 4391',1400.00,0.00,0.00,2.00,152.00,'2023-03-19 14:35:41','',''),(4404,'1','307','1',1,'Retail Sale Id 4392',2100.00,0.00,0.00,3.00,228.00,'2023-03-19 14:43:07','',''),(4405,'1','307','1',1,'Retail Sale Id 4393',180509.00,0.00,0.00,257.87,19598.12,'2023-03-19 14:44:37','',''),(4406,'1','307','1',1,'Retail Sale Id 4394',2800.00,0.00,0.00,4.00,304.00,'2023-03-19 14:46:08','',''),(4407,'1','307','1',1,'Retail Sale Id 4395',8302.00,0.00,0.00,11.86,901.36,'2023-03-19 15:01:07','',''),(4408,'1','307','1',1,'Retail Sale Id 4396',4200.00,0.00,0.00,6.00,456.00,'2023-03-19 15:07:38','',''),(4409,'1','307','1',1,'Retail Sale Id 4397',3500.00,0.00,0.00,5.00,380.00,'2023-03-19 15:28:00','',''),(4410,'1','307','1',1,'Retail Sale Id 4398',32500.00,0.00,0.00,50.00,1300.00,'2023-03-19 16:13:29','',''),(4411,'1','307','1',1,'Retail Sale Id 4399',65000.00,0.00,0.00,100.00,2600.00,'2023-03-19 16:14:34','',''),(4412,'1','307','1',1,'Retail Sale Id 4400',130000.00,0.00,0.00,200.00,5200.00,'2023-03-19 16:16:19','',''),(4413,'1','307','1',1,'Retail Sale Id 4401',12698.00,0.00,0.00,18.14,1378.64,'2023-03-19 17:06:41','',''),(4414,'1','307','1',1,'Retail Sale Id 4402',12698.00,0.00,0.00,18.14,1378.64,'2023-03-19 17:07:59','',''),(4415,'1','307','1',1,'Retail Sale Id 4403',12698.00,0.00,0.00,18.14,1378.64,'2023-03-19 17:10:04','',''),(4416,'1','307','1',1,'Retail Sale Id 4404',17500.00,0.00,0.00,25.00,1900.00,'2023-03-19 17:11:16','',''),(4417,'1','307','1',1,'Retail Sale Id 4405',32500.00,0.00,0.00,50.00,1300.00,'2023-03-19 17:13:25','',''),(4418,'1','307','1',1,'Retail Sale Id 4406',749.00,0.00,0.00,1.07,81.32,'2023-03-19 17:14:20','',''),(4419,'1','307','1',1,'Retail Sale Id 4407',700.00,0.00,0.00,1.00,76.00,'2023-03-19 17:15:38','',''),(4420,'1','307','1',1,'Retail Sale Id 4408',3997.00,0.00,0.00,5.71,433.96,'2023-03-19 17:18:23','',''),(4421,'1','307','1',1,'Retail Sale Id 4409',32500.00,0.00,0.00,50.00,1300.00,'2023-03-19 17:20:07','',''),(4422,'1','307','1',1,'Retail Sale Id 4410',48750.00,0.00,0.00,75.00,1950.00,'2023-03-19 17:21:01','',''),(4423,'1','307','1',1,'Retail Sale Id 4411',4998.00,0.00,0.00,7.14,542.64,'2023-03-19 17:26:57','',''),(4424,'1','307','1',1,'Retail Sale Id 4412',65000.00,0.00,0.00,100.00,2600.00,'2023-03-19 17:57:20','',''),(4425,'1','307','1',1,'Retail Sale Id 4413',8750.00,0.00,0.00,12.50,950.00,'2023-03-19 17:58:10','',''),(4426,'1','307','1',1,'Retail Sale Id 4414',12950.00,0.00,0.00,18.50,1406.00,'2023-03-19 17:59:24','',''),(4427,'1','307','1',1,'Retail Sale Id 4415',15400.00,0.00,0.00,22.00,1672.00,'2023-03-19 18:00:38','',''),(4428,'1','307','1',1,'Retail Sale Id 4416',1799.00,0.00,0.00,2.57,195.32,'2023-03-19 18:03:34','',''),(4429,'1','307','1',1,'Retail Sale Id 4417',2002.00,0.00,0.00,2.86,217.36,'2023-03-19 18:22:15','',''),(4430,'1','307','1',1,'Retail Sale Id 4418',2100.00,0.00,0.00,3.00,228.00,'2023-03-19 18:24:03','',''),(4431,'1','307','1',1,'Retail Sale Id 4419',4200.00,0.00,0.00,6.00,456.00,'2023-03-19 18:25:16','',''),(4432,'1','307','1',1,'Retail Sale Id 4420',2800.00,0.00,0.00,4.00,304.00,'2023-03-19 18:40:54','',''),(4433,'1','307','1',1,'Retail Sale Id 4421',5824.00,0.00,0.00,8.32,632.32,'2023-03-19 19:02:17','',''),(4434,'1','307','1',1,'Retail Sale Id 4422',4900.00,0.00,0.00,7.00,532.00,'2023-03-19 19:25:13','',''),(4435,'1','307','1',1,'Return of Retail Sale Id 4422',0.00,4900.00,7.00,0.00,-532.00,'2023-03-19 19:28:42','',''),(4436,'1','307','1',1,'Retail Sale Id 4423',5299.00,0.00,0.00,7.57,575.32,'2023-03-19 19:30:15','',''),(4437,'1','307','1',1,'Retail Sale Id 4424',4200.00,0.00,0.00,6.00,456.00,'2023-03-20 07:17:13','',''),(4438,'1','307','1',1,'Retail Sale Id 4425',9100.00,0.00,0.00,13.00,988.00,'2023-03-20 07:36:49','',''),(4439,'1','307','1',1,'Retail Sale Id 4426',2100.00,0.00,0.00,3.00,228.00,'2023-03-20 07:52:36','',''),(4440,'1','307','1',1,'Retail Sale Id 4427',4200.00,0.00,0.00,6.00,456.00,'2023-03-20 08:08:21','',''),(4441,'1','307','1',1,'Retail Sale Id 4428',3500.00,0.00,0.00,5.00,380.00,'2023-03-20 08:18:36','',''),(4442,'1','307','1',1,'Retail Sale Id 4429',2800.00,0.00,0.00,4.00,304.00,'2023-03-20 08:32:27','',''),(4443,'1','307','1',1,'Retail Sale Id 4430',1400.00,0.00,0.00,2.00,152.00,'2023-03-20 08:33:30','',''),(4444,'1','307','1',1,'Retail Sale Id 4431',4200.00,0.00,0.00,6.00,456.00,'2023-03-20 08:36:28','',''),(4445,'1','307','1',1,'Retail Sale Id 4433',700.00,0.00,0.00,1.00,76.00,'2023-03-20 08:43:01','',''),(4446,'1','307','1',1,'Retail Sale Id 4434',7000.00,0.00,0.00,10.00,760.00,'2023-03-20 08:59:34','',''),(4447,'1','307','1',1,'Retail Sale Id 4435',14502.32,0.00,0.00,22.04,749.36,'2023-03-20 09:08:28','',''),(4448,'1','307','1',1,'Retail Sale Id 4436',602.00,0.00,0.00,0.86,65.36,'2023-03-20 09:09:20','',''),(4449,'1','307','1',1,'Retail Sale Id 4437',4200.00,0.00,0.00,6.00,456.00,'2023-03-20 09:15:06','',''),(4450,'1','307','1',1,'Retail Sale Id 4438',2100.00,0.00,0.00,3.00,228.00,'2023-03-20 09:27:57','',''),(4451,'1','307','1',1,'Retail Sale Id 4439',12600.00,0.00,0.00,18.00,1368.00,'2023-03-20 09:29:34','',''),(4452,'1','307','1',1,'Retail Sale Id 4440',65000.00,0.00,0.00,100.00,2600.00,'2023-03-20 09:39:22','',''),(4453,'1','307','1',1,'Retail Sale Id 4441',32500.00,0.00,0.00,50.00,1300.00,'2023-03-20 09:40:28','',''),(4454,'1','307','1',1,'Retail Sale Id 4442',32500.00,0.00,0.00,50.00,1300.00,'2023-03-20 09:41:24','',''),(4455,'1','307','1',1,'Retail Sale Id 4443',8750.00,0.00,0.00,12.50,950.00,'2023-03-20 09:47:48','',''),(4456,'1','307','1',1,'Retail Sale Id 4444',2100.00,0.00,0.00,3.00,228.00,'2023-03-20 09:52:50','',''),(4457,'1','307','1',1,'Retail Sale Id 4445',10150.00,0.00,0.00,14.50,1102.00,'2023-03-20 10:02:13','',''),(4458,'1','307','1',1,'Retail Sale Id 4446',2100.00,0.00,0.00,3.00,228.00,'2023-03-20 10:09:45','',''),(4459,'1','307','1',1,'Retail Sale Id 4447',8750.00,0.00,0.00,12.50,950.00,'2023-03-20 10:45:10','',''),(4460,'1','307','1',1,'Retail Sale Id 4448',3500.00,0.00,0.00,5.00,380.00,'2023-03-20 10:53:39','',''),(4461,'1','307','1',1,'Retail Sale Id 4450',8750.00,0.00,0.00,12.50,950.00,'2023-03-20 11:57:12','',''),(4462,'1','307','1',1,'Retail Sale Id 4451',4200.00,0.00,0.00,6.00,456.00,'2023-03-20 11:58:04','',''),(4463,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,1248000.00,2000.00,0.00,0.00,'2023-03-20 12:07:49','',''),(4464,'1','307',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,2000.00,0.00,'2023-03-20 12:08:44','',''),(4465,'1','307','1',1,'Received from bridging 24',0.00,0.00,2000.00,0.00,0.00,'2023-03-20 12:08:44','',''),(4466,'1','307','1',1,'Retail Sale Id 4452',2002.00,0.00,0.00,2.86,217.36,'2023-03-20 12:08:59','',''),(4467,'1','307','1',1,'Retail Sale Id 4453',4200.00,0.00,0.00,6.00,456.00,'2023-03-20 12:15:36','',''),(4468,'1','307','1',1,'Retail Sale Id 4454',10500.00,0.00,0.00,15.00,1140.00,'2023-03-20 13:25:01','',''),(4469,'1','307','1',1,'Retail Sale Id 4455',4200.00,0.00,0.00,6.00,456.00,'2023-03-20 13:26:16','',''),(4470,'1','307','1',1,'Retail Sale Id 4456',7700.00,0.00,0.00,11.00,836.00,'2023-03-20 13:27:33','',''),(4471,'1','307',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,1921920.00,3080.00,0.00,0.00,'2023-03-20 13:46:49','',''),(4472,'1','307',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,3080.00,0.00,'2023-03-20 13:47:45','',''),(4473,'1','307','1',1,'Received from bridging 25',0.00,0.00,3080.00,0.00,0.00,'2023-03-20 13:47:45','',''),(4474,'1','307','1',1,'Retail Sale Id 4457',65000.00,0.00,0.00,100.00,2600.00,'2023-03-20 13:50:14','',''),(4475,'1','307','1',1,'Retail Sale Id 4458',7000.00,0.00,0.00,10.00,760.00,'2023-03-20 13:56:14','',''),(4476,'1','307','1',1,'Retail Sale Id 4459',4200.00,0.00,0.00,6.00,456.00,'2023-03-20 13:58:02','',''),(4477,'1','307','1',1,'Retail Sale Id 4460',2100.00,0.00,0.00,3.00,228.00,'2023-03-20 14:03:15','',''),(4478,'1','307','1',1,'Retail Sale Id 4461',2100.00,0.00,0.00,3.00,228.00,'2023-03-20 14:38:03','',''),(4479,'1','307','1',1,'Retail Sale Id 4462',4200.00,0.00,0.00,6.00,456.00,'2023-03-20 14:39:45','',''),(4480,'1','307','1',1,'Retail Sale Id 4463',798.00,0.00,0.00,1.14,86.64,'2023-03-20 14:41:39','',''),(4481,'1','307','1',1,'Retail Sale Id 4464',1400.00,0.00,0.00,2.00,152.00,'2023-03-20 14:43:50','',''),(4482,'1','307','1',1,'Retail Sale Id 4465',4200.00,0.00,0.00,6.00,456.00,'2023-03-20 14:45:15','',''),(4483,'1','307','1',1,'Retail Sale Id 4466',10850.00,0.00,0.00,15.50,1178.00,'2023-03-20 15:13:02','',''),(4484,'1','307','1',1,'Retail Sale Id 4467',2100.00,0.00,0.00,3.00,228.00,'2023-03-20 15:14:13','',''),(4485,'1','307','1',1,'Retail Sale Id 4468',4200.00,0.00,0.00,6.00,456.00,'2023-03-20 15:47:04','',''),(4486,'1','307','1',1,'Retail Sale Id 4469',2100.00,0.00,0.00,3.00,228.00,'2023-03-20 15:48:22','',''),(4487,'1','307','1',1,'Retail Sale Id 4470',40625.00,0.00,0.00,62.50,1625.00,'2023-03-20 15:51:08','',''),(4488,'1','307','1',1,'Retail Sale Id 4471',2100.00,0.00,0.00,3.00,228.00,'2023-03-20 16:18:51','',''),(4489,'1','307','1',1,'Retail Sale Id 4472',2100.00,0.00,0.00,3.00,228.00,'2023-03-20 16:22:10','',''),(4490,'1','307','1',1,'Retail Sale Id 4473',10850.00,0.00,0.00,15.50,1178.00,'2023-03-20 16:31:39','',''),(4491,'1','307','1',1,'Retail Sale Id 4474',3500.00,0.00,0.00,5.00,380.00,'2023-03-20 16:32:33','',''),(4492,'1','307','1',1,'Retail Sale Id 4475',4200.00,0.00,0.00,6.00,456.00,'2023-03-20 16:58:00','',''),(4493,'1','307','1',1,'Retail Sale Id 4476',4200.00,0.00,0.00,6.00,456.00,'2023-03-20 16:59:45','',''),(4494,'1','307','1',1,'Retail Sale Id 4477',8750.00,0.00,0.00,12.50,950.00,'2023-03-20 17:03:22','',''),(4495,'1','307','1',1,'Retail Sale Id 4478',3500.00,0.00,0.00,5.00,380.00,'2023-03-20 17:06:27','',''),(4496,'1','307','1',1,'Retail Sale Id 4479',2100.00,0.00,0.00,3.00,228.00,'2023-03-20 17:12:15','',''),(4497,'1','307','1',1,'Retail Sale Id 4480',2100.00,0.00,0.00,3.00,228.00,'2023-03-20 17:14:02','',''),(4498,'1','307','1',1,'Retail Sale Id 4481',8750.00,0.00,0.00,12.50,950.00,'2023-03-20 17:20:19','',''),(4499,'1','307','1',1,'Retail Sale Id 4482',8750.00,0.00,0.00,12.50,950.00,'2023-03-20 17:26:37','',''),(4500,'1','307','1',1,'Retail Sale Id 4483',8750.00,0.00,0.00,12.50,950.00,'2023-03-20 17:29:38','',''),(4501,'1','307','1',1,'Retail Sale Id 4484',3500.00,0.00,0.00,5.00,380.00,'2023-03-20 17:34:45','',''),(4502,'1','307','1',1,'Retail Sale Id 4485',2800.00,0.00,0.00,4.00,304.00,'2023-03-20 17:35:41','',''),(4503,'1','307','1',1,'Retail Sale Id 4486',11200.00,0.00,0.00,16.00,1216.00,'2023-03-20 17:45:15','',''),(4504,'1','307','1',1,'Retail Sale Id 4487',7203.00,0.00,0.00,10.29,782.04,'2023-03-20 17:47:24','',''),(4505,'1','307','1',1,'Retail Sale Id 4488',8400.00,0.00,0.00,12.00,912.00,'2023-03-20 17:48:22','',''),(4506,'1','307','1',1,'Retail Sale Id 4489',1400.00,0.00,0.00,2.00,152.00,'2023-03-20 17:51:09','',''),(4507,'1','307','1',1,'Retail Sale Id 4490',700.00,0.00,0.00,1.00,76.00,'2023-03-20 18:00:10','',''),(4508,'1','307','1',1,'Retail Sale Id 4491',2800.00,0.00,0.00,4.00,304.00,'2023-03-20 18:05:12','',''),(4509,'1','307','1',1,'Retail Sale Id 4492',2100.00,0.00,0.00,3.00,228.00,'2023-03-20 18:06:21','',''),(4510,'1','307','1',1,'Retail Sale Id 4493',3500.00,0.00,0.00,5.00,380.00,'2023-03-20 18:08:50','',''),(4511,'1','307','1',1,'Retail Sale Id 4494',2100.00,0.00,0.00,3.00,228.00,'2023-03-20 18:13:56','',''),(4512,'1','307','1',1,'Retail Sale Id 4495',3500.00,0.00,0.00,5.00,380.00,'2023-03-20 18:17:29','',''),(4513,'1','307','1',1,'Retail Sale Id 4496',700.00,0.00,0.00,1.00,76.00,'2023-03-20 18:35:04','',''),(4514,'1','307','1',1,'Retail Sale Id 4497',8400.00,0.00,0.00,12.00,912.00,'2023-03-20 18:36:19','',''),(4515,'1','307','1',1,'Retail Sale Id 4498',2100.00,0.00,0.00,3.00,228.00,'2023-03-20 18:48:59','',''),(4516,'1','307','1',1,'Retail Sale Id 4499',21252.00,0.00,0.00,30.36,2307.36,'2023-03-20 18:50:48','',''),(4517,'1','307','1',1,'Retail Sale Id 4500',8125.00,0.00,0.00,12.50,325.00,'2023-03-20 18:51:58','',''),(4518,'1','307','1',1,'Retail Sale Id 4501',2100.00,0.00,0.00,3.00,228.00,'2023-03-20 18:53:02','',''),(4519,'1','307','1',1,'Retail Sale Id 4502',2002.00,0.00,0.00,2.86,217.36,'2023-03-20 19:09:17','',''),(4520,'1','307','1',1,'Retail Sale Id 4503',14000.00,0.00,0.00,20.00,1520.00,'2023-03-20 19:21:55','',''),(4521,'1','307','1',1,'Retail Sale Id 4504',14441.00,0.00,0.00,20.63,1567.88,'2023-03-20 19:22:49','',''),(4522,'1','307','1',1,'Retail Sale Id 4505',8750.00,0.00,0.00,12.50,950.00,'2023-03-20 19:23:43','',''),(4523,'1','307','1',1,'Retail Sale Id 4506',5600.00,0.00,0.00,8.00,608.00,'2023-03-20 19:32:09','',''),(4524,'1','307','1',1,'Retail Sale Id 4508',700.00,0.00,0.00,1.00,76.00,'2023-03-20 19:39:47','',''),(4525,'1','307','1',1,'Retail Sale Id 4510',2002.00,0.00,0.00,2.86,217.36,'2023-03-20 19:49:06','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'1','307',1,4886.71,'2023-03-20 19:49:06');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4464 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'1','307',1,'Retail Sale Id 1',0.00,664.00,770.00,770.00,106.00,'2022-12-23 12:11:11'),(2,'1','307',1,'Retail Sale Id 2',0.00,2025.20,770.00,2348.50,323.30,'2022-12-24 11:14:27'),(3,'1','307',1,'Retail Sale Id 3',0.00,5172.56,770.00,5998.30,825.74,'2022-12-24 11:18:40'),(4,'1','307',1,'Retail Sale Id 5',0.00,7762.16,770.00,9001.30,1239.14,'2022-12-24 11:24:13'),(5,'1','307',1,'Return of Retail Sale Id 5',7762.16,0.00,770.00,-9001.30,-1239.14,'2022-12-24 11:31:52'),(6,'1','307',1,'Return of Retail Sale Id 2',2025.20,0.00,770.00,-2348.50,-323.30,'2022-12-24 11:32:58'),(7,'1','307',1,'Retail Sale Id 6',0.00,2025.20,770.00,2348.50,323.30,'2022-12-24 11:37:09'),(8,'1','307',1,'Retail Sale Id 7',0.00,8319.92,770.00,9648.10,1328.18,'2022-12-24 11:53:06'),(9,'1','307',1,'Retail Sale Id 8',0.00,4010.56,770.00,4650.80,640.24,'2022-12-24 11:54:39'),(10,'1','307',1,'Retail Sale Id 9',0.00,33200.00,710.00,35500.00,2300.00,'2022-12-24 16:01:17'),(11,'1','307',1,'Retail Sale Id 10',0.00,33200.00,710.00,35500.00,2300.00,'2022-12-24 16:53:30'),(12,'1','307',1,'Return of Retail Sale Id 10',33200.00,0.00,710.00,-35500.00,-2300.00,'2022-12-24 17:13:04'),(13,'1','307',1,'Retail Sale Id 11',0.00,28525.44,710.00,30501.60,1976.16,'2022-12-24 17:13:53'),(14,'1','307',1,'Retail Sale Id 12',0.00,3984.00,770.00,4620.00,636.00,'2022-12-24 17:34:25'),(15,'1','307',1,'Retail Sale Id 13',0.00,59328.40,770.00,68799.50,9471.10,'2022-12-24 17:36:27'),(16,'1','307',1,'Return of Retail Sale Id 12',3984.00,0.00,770.00,-4620.00,-636.00,'2022-12-24 17:38:58'),(17,'1','307',1,'Retail Sale Id 14',0.00,3897.68,770.00,4519.90,622.22,'2022-12-24 17:40:08'),(18,'1','307',1,'Return of Retail Sale Id 13',59328.40,0.00,770.00,-68799.50,-9471.10,'2022-12-24 17:41:35'),(19,'1','307',1,'Retail Sale Id 15',0.00,59328.40,770.00,68799.50,9471.10,'2022-12-24 17:42:16'),(20,'1','307',1,'Retail Sale Id 16',0.00,24302.40,770.00,28182.00,3879.60,'2022-12-24 19:16:04'),(21,'1','307',1,'Retail Sale Id 17',0.00,18864.24,710.00,20171.10,1306.86,'2022-12-24 19:20:20'),(22,'1','307',1,'Retail Sale Id 18',0.00,2158.00,770.00,2502.50,344.50,'2022-12-25 07:30:07'),(23,'1','307',1,'Retail Sale Id 19',0.00,33200.00,710.00,35500.00,2300.00,'2022-12-25 07:37:27'),(24,'1','307',1,'Return of Retail Sale Id 19',33200.00,0.00,710.00,-35500.00,-2300.00,'2022-12-25 07:38:34'),(25,'1','307',1,'Retail Sale Id 20',0.00,3320.00,770.00,3850.00,530.00,'2022-12-25 07:49:02'),(26,'1','307',1,'Retail Sale Id 21',0.00,1726.40,770.00,2002.00,275.60,'2022-12-25 07:51:36'),(27,'1','307',1,'Retail Sale Id 22',0.00,4010.56,770.00,4650.80,640.24,'2022-12-25 08:00:12'),(28,'1','307',1,'Retail Sale Id 23',0.00,2025.20,770.00,2348.50,323.30,'2022-12-25 08:02:05'),(29,'1','307',1,'Retail Sale Id 24',0.00,4010.56,770.00,4650.80,640.24,'2022-12-25 08:53:31'),(30,'1','307',1,'Retail Sale Id 25',0.00,1294.80,770.00,1501.50,206.70,'2022-12-25 09:11:12'),(31,'1','307',1,'Retail Sale Id 26',0.00,4010.56,770.00,4650.80,640.24,'2022-12-25 10:47:08'),(32,'1','307',1,'Retail Sale Id 27',0.00,1334.64,770.00,1547.70,213.06,'2022-12-25 10:50:08'),(33,'1','307',1,'Retail Sale Id 28',0.00,8319.92,770.00,9648.10,1328.18,'2022-12-25 10:52:00'),(34,'1','307',1,'Retail Sale Id 29',0.00,3984.00,770.00,4620.00,636.00,'2022-12-25 11:08:22'),(35,'1','307',1,'Retail Sale Id 30',0.00,4010.56,770.00,4650.80,640.24,'2022-12-25 11:38:08'),(36,'1','307',1,'Retail Sale Id 31',0.00,8366.40,770.00,9702.00,1335.60,'2022-12-25 12:05:54'),(37,'1','307',1,'Retail Sale Id 32',0.00,2071.68,770.00,2402.40,330.72,'2022-12-25 13:59:11'),(38,'1','307',1,'Retail Sale Id 33',0.00,2071.68,770.00,2402.40,330.72,'2022-12-25 14:41:06'),(39,'1','307',1,'Retail Sale Id 34',0.00,2675.92,770.00,3103.10,427.18,'2022-12-25 15:46:09'),(40,'1','307',1,'Retail Sale Id 35',0.00,4010.56,770.00,4650.80,640.24,'2022-12-25 17:53:01'),(41,'1','307',1,'Retail Sale Id 36',0.00,8319.92,770.00,9648.10,1328.18,'2022-12-25 18:24:28'),(42,'1','307',1,'Retail Sale Id 40',0.00,8319.92,770.00,9648.10,1328.18,'2022-12-26 08:03:43'),(43,'1','307',1,'Retail Sale Id 41',0.00,664.00,770.00,770.00,106.00,'2022-12-26 08:34:11'),(44,'1','307',1,'Retail Sale Id 42',0.00,3984.00,770.00,4620.00,636.00,'2022-12-26 09:03:49'),(45,'1','307',1,'Retail Sale Id 43',0.00,3984.00,770.00,4620.00,636.00,'2022-12-26 09:36:14'),(46,'1','307',1,'Retail Sale Id 45',0.00,1992.00,770.00,2310.00,318.00,'2022-12-26 09:39:16'),(47,'1','307',1,'Retail Sale Id 48',0.00,2025.20,770.00,2348.50,323.30,'2022-12-26 09:43:07'),(48,'1','307',1,'Retail Sale Id 49',0.00,1334.64,770.00,1547.70,213.06,'2022-12-26 12:04:46'),(49,'1','307',1,'Retail Sale Id 50',0.00,3320.00,770.00,3850.00,530.00,'2022-12-26 12:58:05'),(50,'1','307',1,'Retail Sale Id 51',0.00,2675.92,770.00,3103.10,427.18,'2022-12-26 13:25:07'),(51,'1','307',1,'Retail Sale Id 52',0.00,8319.92,770.00,9648.10,1328.18,'2022-12-26 14:36:44'),(52,'1','307',1,'Retail Sale Id 54',0.00,7330.56,770.00,8500.80,1170.24,'2022-12-26 15:47:52'),(53,'1','307',1,'Retail Sale Id 55',0.00,4010.56,770.00,4650.80,640.24,'2022-12-26 15:50:37'),(54,'1','307',1,'Retail Sale Id 56',0.00,4010.56,770.00,4650.80,640.24,'2022-12-26 16:54:25'),(55,'1','307',1,'Retail Sale Id 57',0.00,8193.76,770.00,9501.80,1308.04,'2022-12-26 18:14:06'),(56,'1','307',1,'Return of Retail Sale Id 51',2675.92,0.00,770.00,-3103.10,-427.18,'2022-12-26 18:54:52'),(57,'1','307',1,'Retail Sale Id 58',0.00,2675.92,770.00,3103.10,427.18,'2022-12-26 18:58:33'),(58,'1','307',1,'Return of Retail Sale Id 57',8193.76,0.00,770.00,-9501.80,-1308.04,'2022-12-26 19:18:20'),(59,'1','307',1,'Retail Sale Id 59',0.00,8193.76,770.00,9501.80,1308.04,'2022-12-26 19:19:32'),(60,'1','307',1,'Retail Sale Id 60',0.00,1998.64,770.00,2317.70,319.06,'2022-12-27 07:47:48'),(61,'1','307',1,'Retail Sale Id 61',0.00,1334.64,770.00,1547.70,213.06,'2022-12-27 08:29:38'),(62,'1','307',1,'Retail Sale Id 63',0.00,6640.00,770.00,7700.00,1060.00,'2022-12-27 09:27:53'),(63,'1','307',1,'Retail Sale Id 64',0.00,4050.40,770.00,4697.00,646.60,'2022-12-27 09:41:11'),(64,'1','307',1,'Retail Sale Id 65',0.00,1998.64,770.00,2317.70,319.06,'2022-12-27 09:46:01'),(65,'1','307',1,'Retail Sale Id 66',0.00,33200.00,710.00,35500.00,2300.00,'2022-12-27 10:16:43'),(66,'1','307',1,'Retail Sale Id 67',0.00,3984.00,770.00,4620.00,636.00,'2022-12-27 10:24:15'),(67,'1','307',1,'Return of Retail Sale Id 67',3984.00,0.00,770.00,-4620.00,-636.00,'2022-12-27 10:25:36'),(68,'1','307',1,'Retail Sale Id 68',0.00,3984.00,770.00,4620.00,636.00,'2022-12-27 10:26:18'),(69,'1','307',1,'Retail Sale Id 69',0.00,3984.00,770.00,4620.00,636.00,'2022-12-27 12:25:20'),(70,'1','307',1,'Retail Sale Id 70',0.00,1726.40,770.00,2002.00,275.60,'2022-12-27 12:43:13'),(71,'1','307',1,'Retail Sale Id 71',0.00,2025.20,770.00,2348.50,323.30,'2022-12-27 12:52:00'),(72,'1','307',1,'Retail Sale Id 72',0.00,2244.32,770.00,2602.60,358.28,'2022-12-27 13:09:38'),(73,'1','307',1,'Retail Sale Id 73',0.00,2025.20,770.00,2348.50,323.30,'2022-12-27 13:20:23'),(74,'1','307',1,'Retail Sale Id 74',0.00,2656.00,770.00,3080.00,424.00,'2022-12-27 14:10:24'),(75,'1','307',1,'Retail Sale Id 75',0.00,2589.60,770.00,3003.00,413.40,'2022-12-27 14:47:08'),(76,'1','307',1,'Retail Sale Id 76',0.00,8319.92,770.00,9648.10,1328.18,'2022-12-27 15:44:17'),(77,'1','307',1,'Retail Sale Id 77',0.00,2025.20,770.00,2348.50,323.30,'2022-12-27 17:19:40'),(78,'1','307',1,'Retail Sale Id 79',0.00,1334.64,770.00,1547.70,213.06,'2022-12-27 17:27:41'),(79,'1','307',1,'Retail Sale Id 80',0.00,1334.64,770.00,1547.70,213.06,'2022-12-27 17:37:54'),(80,'1','307',1,'Retail Sale Id 81',0.00,8319.92,770.00,9648.10,1328.18,'2022-12-27 18:16:33'),(81,'1','307',1,'Retail Sale Id 82',0.00,1294.80,710.00,1384.50,89.70,'2022-12-27 18:31:00'),(82,'1','307',1,'Retail Sale Id 83',0.00,6.64,770.00,7.70,1.06,'2022-12-27 18:49:19'),(83,'1','307',1,'Return of Retail Sale Id 80',1334.64,0.00,770.00,-1547.70,-213.06,'2022-12-27 18:52:28'),(84,'1','307',1,'Retail Sale Id 84',0.00,1321.36,770.00,1532.30,210.94,'2022-12-27 18:54:03'),(85,'1','307',1,'Return of Retail Sale Id 83',6.64,0.00,770.00,-7.70,-1.06,'2022-12-27 18:56:46'),(86,'1','307',1,'Retail Sale Id 85',0.00,6.64,770.00,7.70,1.06,'2022-12-27 19:01:55'),(87,'1','307',1,'Retail Sale Id 86',0.00,3446.16,770.00,3996.30,550.14,'2022-12-28 08:02:11'),(88,'1','307',1,'Retail Sale Id 87',0.00,1985.36,770.00,2302.30,316.94,'2022-12-28 08:02:54'),(89,'1','307',1,'Retail Sale Id 88',0.00,863.20,770.00,1001.00,137.80,'2022-12-28 08:07:42'),(90,'1','307',1,'Retail Sale Id 89',0.00,4010.56,770.00,4650.80,640.24,'2022-12-28 08:36:35'),(91,'1','307',1,'Retail Sale Id 90',0.00,1998.64,770.00,2317.70,319.06,'2022-12-28 09:00:43'),(92,'1','307',1,'Retail Sale Id 91',0.00,2011.92,770.00,2333.10,321.18,'2022-12-28 09:32:42'),(93,'1','307',1,'Retail Sale Id 92',0.00,3320.00,770.00,3850.00,530.00,'2022-12-28 10:07:12'),(94,'1','307',1,'Retail Sale Id 94',0.00,4010.56,770.00,4650.80,640.24,'2022-12-28 10:56:40'),(95,'1','307',1,'Retail Sale Id 95',0.00,4010.56,770.00,4650.80,640.24,'2022-12-28 14:29:04'),(96,'1','307',1,'Retail Sale Id 96',0.00,4010.56,770.00,4650.80,640.24,'2022-12-28 16:16:44'),(97,'1','307',1,'Retail Sale Id 97',0.00,2675.92,770.00,3103.10,427.18,'2022-12-28 16:19:35'),(98,'1','307',1,'Retail Sale Id 98',0.00,1726.40,770.00,2002.00,275.60,'2022-12-28 16:27:34'),(99,'1','307',1,'Retail Sale Id 99',0.00,1420.96,770.00,1647.80,226.84,'2022-12-28 16:29:17'),(100,'1','307',1,'Retail Sale Id 100',0.00,8319.92,770.00,9648.10,1328.18,'2022-12-28 16:31:08'),(101,'1','307',1,'Retail Sale Id 101',0.00,1294.80,770.00,1501.50,206.70,'2022-12-28 16:44:55'),(102,'1','307',1,'Retail Sale Id 102',0.00,1334.64,770.00,1547.70,213.06,'2022-12-28 17:16:26'),(103,'1','307',1,'Retail Sale Id 103',0.00,33200.00,710.00,35500.00,2300.00,'2022-12-28 18:22:51'),(104,'1','307',1,'Retail Sale Id 104',0.00,3446.16,770.00,3996.30,550.14,'2022-12-28 18:26:16'),(105,'1','307',1,'Return of Retail Sale Id 103',33200.00,0.00,710.00,-35500.00,-2300.00,'2022-12-28 18:44:05'),(106,'1','307',1,'Retail Sale Id 105',0.00,33093.76,710.00,35386.40,2292.64,'2022-12-28 18:46:17'),(107,'1','307',1,'Retail Sale Id 107',0.00,6640.00,770.00,7700.00,1060.00,'2022-12-29 07:35:45'),(108,'1','307',1,'Retail Sale Id 108',0.00,664.00,9650.00,9650.00,8986.00,'2022-12-29 08:20:01'),(109,'1','307',1,'Retail Sale Id 109',0.00,8319.92,770.00,9648.10,1328.18,'2022-12-29 08:24:01'),(110,'1','307',1,'Return of Retail Sale Id 108',664.00,0.00,9650.00,-9650.00,-8986.00,'2022-12-29 08:27:26'),(111,'1','307',1,'Retail Sale Id 110',0.00,2158.00,770.00,2502.50,344.50,'2022-12-29 10:13:23'),(112,'1','307',1,'Retail Sale Id 111',0.00,16639.84,770.00,19296.20,2656.36,'2022-12-29 10:20:22'),(113,'1','307',1,'Retail Sale Id 112',0.00,2662.64,770.00,3087.70,425.06,'2022-12-29 10:24:55'),(114,'1','307',1,'Retail Sale Id 113',0.00,1726.40,770.00,2002.00,275.60,'2022-12-29 10:40:45'),(115,'1','307',1,'Retail Sale Id 114',0.00,4010.56,770.00,4650.80,640.24,'2022-12-29 10:46:36'),(116,'1','307',1,'Retail Sale Id 115',0.00,2005.28,770.00,2325.40,320.12,'2022-12-29 10:49:03'),(117,'1','307',1,'Retail Sale Id 116',0.00,2005.28,770.00,2325.40,320.12,'2022-12-29 10:50:20'),(118,'1','307',1,'Retail Sale Id 117',0.00,4010.56,770.00,4650.80,640.24,'2022-12-29 14:27:34'),(119,'1','307',1,'Retail Sale Id 118',0.00,2025.20,770.00,2348.50,323.30,'2022-12-29 15:25:34'),(120,'1','307',1,'Retail Sale Id 119',0.00,2025.20,770.00,2348.50,323.30,'2022-12-29 16:22:26'),(121,'1','307',1,'Retail Sale Id 120',0.00,2656.00,770.00,3080.00,424.00,'2022-12-29 16:42:17'),(122,'1','307',1,'Retail Sale Id 121',0.00,1726.40,770.00,2002.00,275.60,'2022-12-29 17:15:36'),(123,'1','307',1,'Retail Sale Id 122',0.00,2025.20,770.00,2348.50,323.30,'2022-12-29 17:17:14'),(124,'1','307',1,'Retail Sale Id 123',0.00,2158.00,770.00,2502.50,344.50,'2022-12-29 17:19:44'),(125,'1','307',1,'Retail Sale Id 124',0.00,5172.56,770.00,5998.30,825.74,'2022-12-29 18:43:58'),(126,'1','307',1,'Retail Sale Id 125',0.00,4010.56,770.00,4650.80,640.24,'2022-12-29 18:47:53'),(127,'1','307',1,'Return of Retail Sale Id 121',1726.40,0.00,770.00,-2002.00,-275.60,'2022-12-29 18:57:24'),(128,'1','307',1,'Retail Sale Id 126',0.00,1507.28,770.00,1747.90,240.62,'2022-12-29 19:00:02'),(129,'1','307',1,'Retail Sale Id 127',0.00,2158.00,770.00,2502.50,344.50,'2022-12-30 07:40:40'),(130,'1','307',1,'Retail Sale Id 128',0.00,2025.20,770.00,2348.50,323.30,'2022-12-30 08:01:02'),(131,'1','307',1,'Retail Sale Id 129',0.00,13280.00,770.00,15400.00,2120.00,'2022-12-30 08:28:28'),(132,'1','307',1,'Retail Sale Id 130',0.00,5883.04,770.00,6822.20,939.16,'2022-12-30 08:50:20'),(133,'1','307',1,'Retail Sale Id 131',0.00,4010.56,770.00,4650.80,640.24,'2022-12-30 09:04:24'),(134,'1','307',1,'Retail Sale Id 132',0.00,2025.20,770.00,2348.50,323.30,'2022-12-30 09:14:41'),(135,'1','307',1,'Retail Sale Id 133',0.00,3877.76,770.00,4496.80,619.04,'2022-12-30 09:47:47'),(136,'1','307',1,'Retail Sale Id 134',0.00,4010.56,770.00,4650.80,640.24,'2022-12-30 10:05:21'),(137,'1','307',1,'Retail Sale Id 135',0.00,2025.20,770.00,2348.50,323.30,'2022-12-30 10:07:00'),(138,'1','307',1,'Retail Sale Id 136',0.00,1553.76,770.00,1801.80,248.04,'2022-12-30 10:44:12'),(139,'1','307',1,'Retail Sale Id 137',0.00,4010.56,770.00,4650.80,640.24,'2022-12-30 10:48:22'),(140,'1','307',1,'Retail Sale Id 138',0.00,1992.00,770.00,2310.00,318.00,'2022-12-30 11:58:46'),(141,'1','307',1,'Retail Sale Id 139',0.00,4010.56,770.00,4650.80,640.24,'2022-12-30 12:40:25'),(142,'1','307',1,'Retail Sale Id 140',0.00,8319.92,770.00,9648.10,1328.18,'2022-12-30 12:43:42'),(143,'1','307',1,'Retail Sale Id 141',0.00,2656.00,770.00,3080.00,424.00,'2022-12-30 13:40:58'),(144,'1','307',1,'Retail Sale Id 142',0.00,2656.00,770.00,3080.00,424.00,'2022-12-30 13:42:18'),(145,'1','307',1,'Retail Sale Id 143',0.00,1992.00,770.00,2310.00,318.00,'2022-12-30 13:59:14'),(146,'1','307',1,'Retail Sale Id 144',0.00,4648.00,770.00,5390.00,742.00,'2022-12-30 14:00:46'),(147,'1','307',1,'Retail Sale Id 145',0.00,1294.80,770.00,1501.50,206.70,'2022-12-30 14:24:51'),(148,'1','307',1,'Retail Sale Id 147',0.00,3320.00,770.00,3850.00,530.00,'2022-12-30 15:05:47'),(149,'1','307',1,'Retail Sale Id 148',0.00,8319.92,770.00,9648.10,1328.18,'2022-12-30 15:41:25'),(150,'1','307',1,'Retail Sale Id 149',0.00,6640.00,770.00,7700.00,1060.00,'2022-12-30 15:47:09'),(151,'1','307',1,'Retail Sale Id 150',0.00,33200.00,710.00,35500.00,2300.00,'2022-12-30 15:49:56'),(152,'1','307',1,'Retail Sale Id 151',0.00,8319.92,770.00,9648.10,1328.18,'2022-12-30 16:15:10'),(153,'1','307',1,'Retail Sale Id 152',0.00,1992.00,770.00,2310.00,318.00,'2022-12-30 16:22:49'),(154,'1','307',1,'Retail Sale Id 153',0.00,1726.40,770.00,2002.00,275.60,'2022-12-30 16:29:14'),(155,'1','307',1,'Retail Sale Id 154',0.00,1726.40,770.00,2002.00,275.60,'2022-12-30 16:38:48'),(156,'1','307',1,'Retail Sale Id 155',0.00,4010.56,770.00,4650.80,640.24,'2022-12-30 17:20:20'),(157,'1','307',1,'Retail Sale Id 156',0.00,4010.56,770.00,4650.80,640.24,'2022-12-30 17:21:59'),(158,'1','307',1,'Retail Sale Id 157',0.00,8632.00,770.00,10010.00,1378.00,'2022-12-30 17:43:22'),(159,'1','307',1,'Retail Sale Id 158',0.00,3320.00,770.00,3850.00,530.00,'2022-12-30 17:45:23'),(160,'1','307',1,'Retail Sale Id 159',0.00,3984.00,770.00,4620.00,636.00,'2022-12-30 17:54:12'),(161,'1','307',1,'Retail Sale Id 161',0.00,8319.92,770.00,9648.10,1328.18,'2022-12-30 18:21:29'),(162,'1','307',1,'Retail Sale Id 162',0.00,2589.60,770.00,3003.00,413.40,'2022-12-30 18:48:15'),(163,'1','307',1,'Return of Retail Sale Id 150',33200.00,0.00,710.00,-35500.00,-2300.00,'2022-12-30 18:57:40'),(164,'1','307',1,'Retail Sale Id 163',0.00,33087.12,710.00,35379.30,2292.18,'2022-12-30 19:00:02'),(165,'1','307',1,'Retail Sale Id 164',0.00,949.52,770.00,1101.10,151.58,'2022-12-30 19:03:13'),(166,'1','307',1,'Retail Sale Id 166',0.00,33200.00,710.00,35500.00,2300.00,'2022-12-31 08:02:03'),(167,'1','307',1,'Retail Sale Id 167',0.00,3446.16,770.00,3996.30,550.14,'2022-12-31 08:36:41'),(168,'1','307',1,'Retail Sale Id 168',0.00,7974.64,770.00,9247.70,1273.06,'2022-12-31 09:48:25'),(169,'1','307',1,'Retail Sale Id 169',0.00,33200.00,710.00,35500.00,2300.00,'2022-12-31 09:52:03'),(170,'1','307',1,'Retail Sale Id 170',0.00,1992.00,770.00,2310.00,318.00,'2022-12-31 10:09:07'),(171,'1','307',1,'Retail Sale Id 170',0.00,1992.00,770.00,2310.00,318.00,'2022-12-31 10:09:07'),(172,'1','307',1,'Retail Sale Id 171',0.00,33073.84,710.00,35365.10,2291.26,'2022-12-31 10:31:53'),(173,'1','307',1,'Retail Sale Id 172',0.00,1899.04,770.00,2202.20,303.16,'2022-12-31 11:21:30'),(174,'1','307',1,'Retail Sale Id 173',0.00,5312.00,770.00,6160.00,848.00,'2022-12-31 11:23:25'),(175,'1','307',1,'Retail Sale Id 174',0.00,3320.00,770.00,3850.00,530.00,'2022-12-31 12:15:28'),(176,'1','307',1,'Retail Sale Id 175',0.00,8319.92,770.00,9648.10,1328.18,'2022-12-31 12:19:30'),(177,'1','307',1,'Retail Sale Id 176',0.00,33200.00,710.00,35500.00,2300.00,'2022-12-31 12:54:28'),(178,'1','307',1,'Retail Sale Id 177',0.00,33200.00,710.00,35500.00,2300.00,'2022-12-31 12:55:39'),(179,'1','307',1,'Retail Sale Id 178',0.00,33200.00,710.00,35500.00,2300.00,'2022-12-31 13:12:15'),(180,'1','307',1,'Retail Sale Id 179',0.00,4010.56,770.00,4650.80,640.24,'2022-12-31 13:14:00'),(181,'1','307',1,'Retail Sale Id 180',0.00,4010.56,770.00,4650.80,640.24,'2022-12-31 15:12:04'),(182,'1','307',1,'Retail Sale Id 182',0.00,2656.00,770.00,3080.00,424.00,'2022-12-31 15:19:01'),(183,'1','307',1,'Retail Sale Id 183',0.00,2025.20,770.00,2348.50,323.30,'2022-12-31 15:30:33'),(184,'1','307',1,'Retail Sale Id 184',0.00,4010.56,770.00,4650.80,640.24,'2022-12-31 15:49:35'),(185,'1','307',1,'Retail Sale Id 185',0.00,8319.92,770.00,9648.10,1328.18,'2022-12-31 16:18:18'),(186,'1','307',1,'Retail Sale Id 186',0.00,1726.40,770.00,2002.00,275.60,'2022-12-31 16:26:14'),(187,'1','307',1,'Retail Sale Id 187',0.00,33200.00,710.00,35500.00,2300.00,'2022-12-31 16:35:18'),(188,'1','307',1,'Retail Sale Id 188',0.00,1334.64,770.00,1547.70,213.06,'2022-12-31 16:57:08'),(189,'1','307',1,'Retail Sale Id 189',0.00,2025.20,770.00,2348.50,323.30,'2022-12-31 17:20:47'),(190,'1','307',1,'Retail Sale Id 190',0.00,664.00,770.00,770.00,106.00,'2022-12-31 17:29:13'),(191,'1','307',1,'Retail Sale Id 191',0.00,4010.56,770.00,4650.80,640.24,'2022-12-31 17:30:35'),(192,'1','307',1,'Retail Sale Id 192',0.00,8319.92,770.00,9648.10,1328.18,'2022-12-31 18:00:19'),(193,'1','307',1,'Retail Sale Id 193',0.00,1334.64,770.00,1547.70,213.06,'2022-12-31 18:06:44'),(194,'1','307',1,'Retail Sale Id 194',0.00,1334.64,770.00,1547.70,213.06,'2022-12-31 18:19:03'),(195,'1','307',1,'Retail Sale Id 195',0.00,1726.40,770.00,2002.00,275.60,'2022-12-31 18:22:14'),(196,'1','307',1,'Retail Sale Id 196',0.00,8665.20,770.00,10048.50,1383.30,'2022-12-31 19:01:06'),(197,'1','307',1,'Return of Retail Sale Id 187',33200.00,0.00,710.00,-35500.00,-2300.00,'2022-12-31 19:22:59'),(198,'1','307',1,'Retail Sale Id 197',0.00,33498.80,710.00,35819.50,2320.70,'2022-12-31 19:25:03'),(199,'1','307',1,'Retail Sale Id 198',0.00,9960.00,770.00,11550.00,1590.00,'2023-01-01 08:11:23'),(200,'1','307',1,'Retail Sale Id 199',0.00,1294.80,770.00,1501.50,206.70,'2023-01-01 08:37:12'),(201,'1','307',1,'Retail Sale Id 200',0.00,166000.00,710.00,177500.00,11500.00,'2023-01-01 08:38:28'),(202,'1','307',1,'Retail Sale Id 201',0.00,2025.20,770.00,2348.50,323.30,'2023-01-01 08:39:47'),(203,'1','307',1,'Retail Sale Id 202',0.00,9960.00,770.00,11550.00,1590.00,'2023-01-01 08:43:56'),(204,'1','307',1,'Retail Sale Id 203',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-01 09:18:31'),(205,'1','307',1,'Retail Sale Id 204',0.00,1334.64,770.00,1547.70,213.06,'2023-01-01 09:21:22'),(206,'1','307',1,'Retail Sale Id 205',0.00,3984.00,770.00,4620.00,636.00,'2023-01-01 10:14:19'),(207,'1','307',1,'Retail Sale Id 206',0.00,10624.00,710.00,11360.00,736.00,'2023-01-01 10:16:44'),(208,'1','307',1,'Retail Sale Id 207',0.00,1334.64,770.00,1547.70,213.06,'2023-01-01 10:25:25'),(209,'1','307',1,'Retail Sale Id 208',0.00,3984.00,770.00,4620.00,636.00,'2023-01-01 10:29:01'),(210,'1','307',1,'Retail Sale Id 208',0.00,3990.64,770.00,4627.70,637.06,'2023-01-01 10:29:01'),(211,'1','307',1,'Retail Sale Id 209',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-01 10:34:40'),(212,'1','307',1,'Retail Sale Id 210',0.00,10624.00,710.00,11360.00,736.00,'2023-01-01 10:36:36'),(213,'1','307',1,'Retail Sale Id 211',0.00,4654.64,770.00,5397.70,743.06,'2023-01-01 10:51:53'),(214,'1','307',1,'Retail Sale Id 212',0.00,4010.56,770.00,4650.80,640.24,'2023-01-01 12:19:41'),(215,'1','307',1,'Retail Sale Id 213',0.00,4010.56,770.00,4650.80,640.24,'2023-01-01 12:45:53'),(216,'1','307',1,'Return of Retail Sale Id 213',4010.56,0.00,770.00,-4650.80,-640.24,'2023-01-01 12:46:33'),(217,'1','307',1,'Retail Sale Id 214',0.00,4010.56,770.00,4650.80,640.24,'2023-01-01 12:47:12'),(218,'1','307',1,'Retail Sale Id 215',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-01 13:03:44'),(219,'1','307',1,'Retail Sale Id 216',0.00,4648.00,770.00,5390.00,742.00,'2023-01-01 13:19:21'),(220,'1','307',1,'Retail Sale Id 217',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-01 13:58:15'),(221,'1','307',1,'Retail Sale Id 218',0.00,1347.92,770.00,1563.10,215.18,'2023-01-01 14:06:58'),(222,'1','307',1,'Retail Sale Id 220',0.00,1992.00,770.00,2310.00,318.00,'2023-01-01 15:14:45'),(223,'1','307',1,'Retail Sale Id 221',0.00,4309.36,770.00,4997.30,687.94,'2023-01-01 16:10:03'),(224,'1','307',1,'Retail Sale Id 222',0.00,2025.20,770.00,2348.50,323.30,'2023-01-01 16:11:01'),(225,'1','307',1,'Retail Sale Id 223',0.00,664.00,770.00,770.00,106.00,'2023-01-01 16:13:18'),(226,'1','307',1,'Retail Sale Id 224',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-01 17:12:20'),(227,'1','307',1,'Retail Sale Id 225',0.00,2025.20,770.00,2348.50,323.30,'2023-01-01 17:27:29'),(228,'1','307',1,'Retail Sale Id 226',0.00,4010.56,770.00,4650.80,640.24,'2023-01-01 17:44:07'),(229,'1','307',1,'Retail Sale Id 228',0.00,2025.20,770.00,2348.50,323.30,'2023-01-01 17:59:32'),(230,'1','307',1,'Retail Sale Id 229',0.00,4010.56,770.00,4650.80,640.24,'2023-01-01 18:22:58'),(231,'1','307',1,'Retail Sale Id 230',0.00,22576.00,710.00,24140.00,1564.00,'2023-01-01 18:35:44'),(232,'1','307',1,'Return of Retail Sale Id 230',22576.00,0.00,710.00,-24140.00,-1564.00,'2023-01-01 18:36:43'),(233,'1','307',1,'Retail Sale Id 231',0.00,22576.00,710.00,24140.00,1564.00,'2023-01-01 18:38:07'),(234,'1','307',1,'Retail Sale Id 232',0.00,7968.00,770.00,9240.00,1272.00,'2023-01-01 18:42:54'),(235,'1','307',1,'Retail Sale Id 233',0.00,1294.80,770.00,1501.50,206.70,'2023-01-02 08:30:34'),(236,'1','307',1,'Retail Sale Id 234',0.00,3320.00,770.00,3850.00,530.00,'2023-01-02 08:31:57'),(237,'1','307',1,'Retail Sale Id 235',0.00,2025.20,770.00,2348.50,323.30,'2023-01-02 08:54:10'),(238,'1','307',1,'Retail Sale Id 236',0.00,863.20,770.00,1001.00,137.80,'2023-01-02 08:57:32'),(239,'1','307',1,'Retail Sale Id 237',0.00,7330.56,770.00,8500.80,1170.24,'2023-01-02 09:02:19'),(240,'1','307',1,'Retail Sale Id 239',0.00,4010.56,770.00,4650.80,640.24,'2023-01-02 09:15:20'),(241,'1','307',1,'Retail Sale Id 240',0.00,4010.56,770.00,4650.80,640.24,'2023-01-02 09:17:06'),(242,'1','307',1,'Retail Sale Id 241',0.00,1726.40,770.00,2002.00,275.60,'2023-01-02 10:24:36'),(243,'1','307',1,'Retail Sale Id 242',0.00,3320.00,770.00,3850.00,530.00,'2023-01-02 11:01:13'),(244,'1','307',1,'Retail Sale Id 243',0.00,1035.84,770.00,1201.20,165.36,'2023-01-02 11:02:42'),(245,'1','307',1,'Retail Sale Id 244',0.00,3320.00,770.00,3850.00,530.00,'2023-01-02 11:03:53'),(246,'1','307',1,'Retail Sale Id 245',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-02 11:21:01'),(247,'1','307',1,'Retail Sale Id 246',0.00,4010.56,770.00,4650.80,640.24,'2023-01-02 11:24:34'),(248,'1','307',1,'Retail Sale Id 247',0.00,3320.00,770.00,3850.00,530.00,'2023-01-02 11:53:15'),(249,'1','307',1,'Retail Sale Id 248',0.00,2025.20,770.00,2348.50,323.30,'2023-01-02 11:54:40'),(250,'1','307',1,'Retail Sale Id 249',0.00,863.20,770.00,1001.00,137.80,'2023-01-02 12:11:28'),(251,'1','307',1,'Retail Sale Id 250',0.00,5345.20,770.00,6198.50,853.30,'2023-01-02 12:51:09'),(252,'1','307',1,'Retail Sale Id 251',0.00,66400.00,710.00,71000.00,4600.00,'2023-01-02 13:25:56'),(253,'1','307',1,'Retail Sale Id 252',0.00,4010.56,770.00,4650.80,640.24,'2023-01-02 13:38:12'),(254,'1','307',1,'Retail Sale Id 253',0.00,2656.00,770.00,3080.00,424.00,'2023-01-02 13:51:21'),(255,'1','307',1,'Retail Sale Id 254',0.00,1726.40,770.00,2002.00,275.60,'2023-01-02 14:01:12'),(256,'1','307',1,'Retail Sale Id 255',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-02 14:04:03'),(257,'1','307',1,'Retail Sale Id 256',0.00,2675.92,770.00,3103.10,427.18,'2023-01-02 14:05:27'),(258,'1','307',1,'Retail Sale Id 257',0.00,2025.20,770.00,2348.50,323.30,'2023-01-02 14:27:09'),(259,'1','307',1,'Retail Sale Id 258',0.00,3320.00,770.00,3850.00,530.00,'2023-01-02 14:28:09'),(260,'1','307',1,'Retail Sale Id 259',0.00,4010.56,770.00,4650.80,640.24,'2023-01-02 15:29:00'),(261,'1','307',1,'Retail Sale Id 260',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-02 17:49:10'),(262,'1','307',1,'Retail Sale Id 261',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-02 17:50:24'),(263,'1','307',1,'Retail Sale Id 262',0.00,4010.56,770.00,4650.80,640.24,'2023-01-02 17:51:02'),(264,'1','307',1,'Retail Sale Id 263',0.00,1334.64,770.00,1547.70,213.06,'2023-01-02 17:51:45'),(265,'1','307',1,'Retail Sale Id 264',0.00,2589.60,770.00,3003.00,413.40,'2023-01-02 18:16:41'),(266,'1','307',1,'Retail Sale Id 265',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-02 18:25:43'),(267,'1','307',1,'Retail Sale Id 266',0.00,1726.40,770.00,2002.00,275.60,'2023-01-03 08:05:25'),(268,'1','307',1,'Retail Sale Id 267',0.00,3320.00,770.00,3850.00,530.00,'2023-01-03 08:13:45'),(269,'1','307',1,'Retail Sale Id 269',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-03 08:30:43'),(270,'1','307',1,'Retail Sale Id 270',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-03 08:41:34'),(271,'1','307',1,'Retail Sale Id 271',0.00,4010.56,770.00,4650.80,640.24,'2023-01-03 09:32:49'),(272,'1','307',1,'Retail Sale Id 272',0.00,3877.76,770.00,4496.80,619.04,'2023-01-03 09:43:22'),(273,'1','307',1,'Retail Sale Id 273',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-03 09:50:58'),(274,'1','307',1,'Retail Sale Id 274',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-03 09:52:11'),(275,'1','307',1,'Retail Sale Id 275',0.00,5345.20,770.00,6198.50,853.30,'2023-01-03 10:54:27'),(276,'1','307',1,'Retail Sale Id 276',0.00,690.56,770.00,800.80,110.24,'2023-01-03 12:18:46'),(277,'1','307',1,'Retail Sale Id 277',0.00,4309.36,770.00,4997.30,687.94,'2023-01-03 12:46:58'),(278,'1','307',1,'Retail Sale Id 278',0.00,1294.80,770.00,1501.50,206.70,'2023-01-03 13:03:51'),(279,'1','307',1,'Retail Sale Id 279',0.00,4010.56,770.00,4650.80,640.24,'2023-01-03 13:35:18'),(280,'1','307',1,'Retail Sale Id 280',0.00,4010.56,770.00,4650.80,640.24,'2023-01-03 15:25:45'),(281,'1','307',1,'Retail Sale Id 281',0.00,2025.20,770.00,2348.50,323.30,'2023-01-03 16:37:57'),(282,'1','307',1,'Retail Sale Id 282',0.00,6640.00,770.00,7700.00,1060.00,'2023-01-03 16:39:40'),(283,'1','307',1,'Retail Sale Id 283',0.00,4010.56,770.00,4650.80,640.24,'2023-01-03 17:09:23'),(284,'1','307',1,'Retail Sale Id 284',0.00,4010.56,770.00,4650.80,640.24,'2023-01-03 17:30:08'),(285,'1','307',1,'Retail Sale Id 285',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-03 18:13:58'),(286,'1','307',1,'Retail Sale Id 286',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-03 18:27:06'),(287,'1','307',1,'Retail Sale Id 287',0.00,4010.56,770.00,4650.80,640.24,'2023-01-03 18:30:41'),(288,'1','307',1,'Retail Sale Id 288',0.00,1334.64,770.00,1547.70,213.06,'2023-01-04 07:41:11'),(289,'1','307',1,'Retail Sale Id 289',0.00,2025.20,770.00,2348.50,323.30,'2023-01-04 08:01:21'),(290,'1','307',1,'Retail Sale Id 290',0.00,7330.56,770.00,8500.80,1170.24,'2023-01-04 08:22:54'),(291,'1','307',1,'Retail Sale Id 291',0.00,3320.00,770.00,3850.00,530.00,'2023-01-04 09:02:36'),(292,'1','307',1,'Retail Sale Id 292',0.00,3320.00,770.00,3850.00,530.00,'2023-01-04 09:04:14'),(293,'1','307',1,'Retail Sale Id 293',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-04 09:14:12'),(294,'1','307',1,'Retail Sale Id 294',0.00,4010.56,770.00,4650.80,640.24,'2023-01-04 09:26:21'),(295,'1','307',1,'Retail Sale Id 295',0.00,1992.00,770.00,2310.00,318.00,'2023-01-04 10:15:42'),(296,'1','307',1,'Retail Sale Id 296',0.00,3320.00,770.00,3850.00,530.00,'2023-01-04 10:21:33'),(297,'1','307',1,'Retail Sale Id 297',0.00,4050.40,770.00,4697.00,646.60,'2023-01-04 10:57:18'),(298,'1','307',1,'Retail Sale Id 298',0.00,1334.64,770.00,1547.70,213.06,'2023-01-04 11:19:33'),(299,'1','307',1,'Retail Sale Id 299',0.00,1334.64,770.00,1547.70,213.06,'2023-01-04 11:45:43'),(300,'1','307',1,'Retail Sale Id 300',0.00,3320.00,770.00,3850.00,530.00,'2023-01-04 12:00:20'),(301,'1','307',1,'Retail Sale Id 301',0.00,664.00,770.00,770.00,106.00,'2023-01-04 12:18:08'),(302,'1','307',1,'Retail Sale Id 302',0.00,16600.00,770.00,19250.00,2650.00,'2023-01-04 12:31:06'),(303,'1','307',1,'Retail Sale Id 303',0.00,2662.64,770.00,3087.70,425.06,'2023-01-04 13:23:50'),(304,'1','307',1,'Retail Sale Id 304',0.00,3320.00,770.00,3850.00,530.00,'2023-01-04 13:27:13'),(305,'1','307',1,'Retail Sale Id 306',0.00,332000.00,710.00,355000.00,23000.00,'2023-01-04 13:57:10'),(306,'1','307',1,'Retail Sale Id 307',0.00,4010.56,770.00,4650.80,640.24,'2023-01-04 14:00:27'),(307,'1','307',1,'Retail Sale Id 308',0.00,4010.56,770.00,4650.80,640.24,'2023-01-04 14:02:08'),(308,'1','307',1,'Retail Sale Id 309',0.00,2543.12,770.00,2949.10,405.98,'2023-01-04 14:50:41'),(309,'1','307',1,'Retail Sale Id 310',0.00,1992.00,770.00,2310.00,318.00,'2023-01-04 15:04:36'),(310,'1','307',1,'Retail Sale Id 311',0.00,4010.56,770.00,4650.80,640.24,'2023-01-04 15:27:04'),(311,'1','307',1,'Retail Sale Id 312',0.00,3320.00,770.00,3850.00,530.00,'2023-01-04 15:45:09'),(312,'1','307',1,'Retail Sale Id 313',0.00,4010.56,770.00,4650.80,640.24,'2023-01-04 17:16:48'),(313,'1','307',1,'Retail Sale Id 314',0.00,8300.00,770.00,9625.00,1325.00,'2023-01-04 17:35:46'),(314,'1','307',1,'Retail Sale Id 315',0.00,2656.00,770.00,3080.00,424.00,'2023-01-04 17:42:55'),(315,'1','307',1,'Retail Sale Id 316',0.00,4309.36,770.00,4997.30,687.94,'2023-01-04 17:46:02'),(316,'1','307',1,'Retail Sale Id 317',0.00,4010.56,770.00,4650.80,640.24,'2023-01-04 18:15:59'),(317,'1','307',1,'Retail Sale Id 318',0.00,3021.20,770.00,3503.50,482.30,'2023-01-04 18:21:10'),(318,'1','307',1,'Retail Sale Id 319',0.00,2025.20,770.00,2348.50,323.30,'2023-01-04 18:48:43'),(319,'1','307',1,'Retail Sale Id 320',0.00,4050.40,770.00,4697.00,646.60,'2023-01-04 18:53:44'),(320,'1','307',1,'Retail Sale Id 321',0.00,5172.56,770.00,5998.30,825.74,'2023-01-05 08:11:25'),(321,'1','307',1,'Retail Sale Id 322',0.00,1726.40,770.00,2002.00,275.60,'2023-01-05 08:17:44'),(322,'1','307',1,'Retail Sale Id 323',0.00,1294.80,770.00,1501.50,206.70,'2023-01-05 08:19:54'),(323,'1','307',1,'Retail Sale Id 324',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-05 08:37:57'),(324,'1','307',1,'Retail Sale Id 325',0.00,1334.64,770.00,1547.70,213.06,'2023-01-05 08:42:30'),(325,'1','307',1,'Retail Sale Id 326',0.00,4010.56,770.00,4650.80,640.24,'2023-01-05 08:45:54'),(326,'1','307',1,'Retail Sale Id 327',0.00,4010.56,770.00,4650.80,640.24,'2023-01-05 08:50:48'),(327,'1','307',1,'Retail Sale Id 328',0.00,2025.20,770.00,2348.50,323.30,'2023-01-05 08:52:26'),(328,'1','307',1,'Retail Sale Id 329',0.00,3320.00,770.00,3850.00,530.00,'2023-01-05 08:56:46'),(329,'1','307',1,'Retail Sale Id 330',0.00,664.00,770.00,770.00,106.00,'2023-01-05 10:13:53'),(330,'1','307',1,'Retail Sale Id 331',0.00,4010.56,770.00,4650.80,640.24,'2023-01-05 10:22:52'),(331,'1','307',1,'Retail Sale Id 332',0.00,3320.00,770.00,3850.00,530.00,'2023-01-05 10:24:18'),(332,'1','307',1,'Retail Sale Id 333',0.00,3320.00,770.00,3850.00,530.00,'2023-01-05 10:31:08'),(333,'1','307',1,'Retail Sale Id 334',0.00,66400.00,710.00,71000.00,4600.00,'2023-01-05 12:09:06'),(334,'1','307',1,'Retail Sale Id 335',0.00,4010.56,770.00,4650.80,640.24,'2023-01-05 13:26:15'),(335,'1','307',1,'Retail Sale Id 336',0.00,2656.00,770.00,3080.00,424.00,'2023-01-05 15:07:38'),(336,'1','307',1,'Retail Sale Id 337',0.00,6640.00,770.00,7700.00,1060.00,'2023-01-05 15:37:04'),(337,'1','307',1,'Retail Sale Id 338',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-05 15:39:15'),(338,'1','307',1,'Retail Sale Id 339',0.00,4010.56,770.00,4650.80,640.24,'2023-01-05 16:21:42'),(339,'1','307',1,'Retail Sale Id 340',0.00,1328.00,770.00,1540.00,212.00,'2023-01-05 16:23:37'),(340,'1','307',1,'Retail Sale Id 341',0.00,3320.00,770.00,3850.00,530.00,'2023-01-05 16:25:17'),(341,'1','307',1,'Retail Sale Id 342',0.00,1985.36,770.00,2302.30,316.94,'2023-01-05 16:37:44'),(342,'1','307',1,'Retail Sale Id 343',0.00,4010.56,770.00,4650.80,640.24,'2023-01-05 16:43:03'),(343,'1','307',1,'Retail Sale Id 344',0.00,4010.56,770.00,4650.80,640.24,'2023-01-05 16:54:30'),(344,'1','307',1,'Retail Sale Id 345',0.00,6640.00,770.00,7700.00,1060.00,'2023-01-05 17:19:13'),(345,'1','307',1,'Retail Sale Id 346',0.00,6640.00,770.00,7700.00,1060.00,'2023-01-05 17:57:23'),(346,'1','307',1,'Retail Sale Id 347',0.00,99.60,770.00,115.50,15.90,'2023-01-05 18:50:09'),(347,'1','307',1,'Retail Sale Id 348',0.00,8366.40,770.00,9702.00,1335.60,'2023-01-06 07:32:58'),(348,'1','307',1,'Retail Sale Id 349',0.00,4010.56,770.00,4650.80,640.24,'2023-01-06 08:50:22'),(349,'1','307',1,'Retail Sale Id 350',0.00,1992.00,770.00,2310.00,318.00,'2023-01-06 08:52:15'),(350,'1','307',1,'Retail Sale Id 351',0.00,7762.16,770.00,9001.30,1239.14,'2023-01-06 08:54:07'),(351,'1','307',1,'Retail Sale Id 352',0.00,2656.00,770.00,3080.00,424.00,'2023-01-06 09:15:48'),(352,'1','307',1,'Retail Sale Id 353',0.00,1381.12,770.00,1601.60,220.48,'2023-01-06 09:19:15'),(353,'1','307',1,'Retail Sale Id 354',0.00,1334.64,770.00,1547.70,213.06,'2023-01-06 09:30:30'),(354,'1','307',1,'Retail Sale Id 355',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-06 10:14:10'),(355,'1','307',1,'Retail Sale Id 356',0.00,3984.00,770.00,4620.00,636.00,'2023-01-06 10:15:34'),(356,'1','307',1,'Retail Sale Id 357',0.00,1992.00,770.00,2310.00,318.00,'2023-01-06 11:00:57'),(357,'1','307',1,'Retail Sale Id 358',0.00,2025.20,770.00,2348.50,323.30,'2023-01-06 11:07:44'),(358,'1','307',1,'Retail Sale Id 359',0.00,4010.56,770.00,4650.80,640.24,'2023-01-06 11:09:39'),(359,'1','307',1,'Retail Sale Id 360',0.00,1328.00,770.00,1540.00,212.00,'2023-01-06 11:12:21'),(360,'1','307',1,'Retail Sale Id 361',0.00,3021.20,770.00,3503.50,482.30,'2023-01-06 11:42:18'),(361,'1','307',1,'Retail Sale Id 362',0.00,2025.20,770.00,2348.50,323.30,'2023-01-06 11:43:57'),(362,'1','307',1,'Retail Sale Id 363',0.00,1992.00,770.00,2310.00,318.00,'2023-01-06 11:59:15'),(363,'1','307',1,'Retail Sale Id 364',0.00,1992.00,770.00,2310.00,318.00,'2023-01-06 13:39:59'),(364,'1','307',1,'Retail Sale Id 365',0.00,4309.36,770.00,4997.30,687.94,'2023-01-06 13:55:50'),(365,'1','307',1,'Retail Sale Id 366',0.00,3984.00,770.00,4620.00,636.00,'2023-01-06 15:04:52'),(366,'1','307',1,'Retail Sale Id 367',0.00,3877.76,770.00,4496.80,619.04,'2023-01-06 15:06:17'),(367,'1','307',1,'Retail Sale Id 368',0.00,3984.00,770.00,4620.00,636.00,'2023-01-06 15:39:32'),(368,'1','307',1,'Retail Sale Id 369',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-06 16:14:25'),(369,'1','307',1,'Retail Sale Id 370',0.00,2025.20,770.00,2348.50,323.30,'2023-01-06 16:16:14'),(370,'1','307',1,'Retail Sale Id 371',0.00,2656.00,770.00,3080.00,424.00,'2023-01-06 17:02:06'),(371,'1','307',1,'Retail Sale Id 372',0.00,7330.56,770.00,8500.80,1170.24,'2023-01-06 17:46:59'),(372,'1','307',1,'Retail Sale Id 373',0.00,2025.20,770.00,2348.50,323.30,'2023-01-06 18:04:25'),(373,'1','307',1,'Retail Sale Id 374',0.00,1381.12,770.00,1601.60,220.48,'2023-01-06 18:06:56'),(374,'1','307',1,'Retail Sale Id 375',0.00,3280.16,770.00,3803.80,523.64,'2023-01-06 18:37:06'),(375,'1','307',1,'Retail Sale Id 376',0.00,3320.00,770.00,3850.00,530.00,'2023-01-07 07:26:32'),(376,'1','307',1,'Retail Sale Id 377',0.00,4010.56,770.00,4650.80,640.24,'2023-01-07 07:42:57'),(377,'1','307',1,'Retail Sale Id 378',0.00,2656.00,770.00,3080.00,424.00,'2023-01-07 08:02:27'),(378,'1','307',1,'Retail Sale Id 379',0.00,3984.00,770.00,4620.00,636.00,'2023-01-07 08:04:17'),(379,'1','307',1,'Retail Sale Id 380',0.00,2675.92,770.00,3103.10,427.18,'2023-01-07 08:08:46'),(380,'1','307',1,'Retail Sale Id 381',0.00,1992.00,770.00,2310.00,318.00,'2023-01-07 08:41:09'),(381,'1','307',1,'Retail Sale Id 382',0.00,3984.00,770.00,4620.00,636.00,'2023-01-07 08:44:01'),(382,'1','307',1,'Retail Sale Id 384',0.00,4050.40,770.00,4697.00,646.60,'2023-01-07 08:52:14'),(383,'1','307',1,'Retail Sale Id 385',0.00,1985.36,770.00,2302.30,316.94,'2023-01-07 10:10:09'),(384,'1','307',1,'Retail Sale Id 386',0.00,3877.76,770.00,4496.80,619.04,'2023-01-07 12:10:07'),(385,'1','307',1,'Retail Sale Id 387',0.00,863.20,770.00,1001.00,137.80,'2023-01-07 12:13:06'),(386,'1','307',1,'Retail Sale Id 389',0.00,1381.12,770.00,1601.60,220.48,'2023-01-07 12:19:41'),(387,'1','307',1,'Retail Sale Id 390',0.00,3021.20,770.00,3503.50,482.30,'2023-01-07 13:08:58'),(388,'1','307',1,'Retail Sale Id 391',0.00,3877.76,770.00,4496.80,619.04,'2023-01-07 13:22:47'),(389,'1','307',1,'Retail Sale Id 392',0.00,690.56,770.00,800.80,110.24,'2023-01-07 13:33:29'),(390,'1','307',1,'Retail Sale Id 393',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-07 13:47:48'),(391,'1','307',1,'Retail Sale Id 394',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-07 13:49:24'),(392,'1','307',1,'Retail Sale Id 395',0.00,4010.56,770.00,4650.80,640.24,'2023-01-07 13:51:02'),(393,'1','307',1,'Retail Sale Id 396',0.00,4309.36,770.00,4997.30,687.94,'2023-01-07 14:15:33'),(394,'1','307',1,'Retail Sale Id 397',0.00,3320.00,770.00,3850.00,530.00,'2023-01-07 14:50:32'),(395,'1','307',1,'Retail Sale Id 398',0.00,4010.56,770.00,4650.80,640.24,'2023-01-07 14:53:11'),(396,'1','307',1,'Retail Sale Id 399',0.00,3984.00,770.00,4620.00,636.00,'2023-01-07 15:10:51'),(397,'1','307',1,'Retail Sale Id 400',0.00,776.88,770.00,900.90,124.02,'2023-01-07 15:33:31'),(398,'1','307',1,'Retail Sale Id 401',0.00,664.00,770.00,770.00,106.00,'2023-01-07 15:36:16'),(399,'1','307',1,'Retail Sale Id 402',0.00,3320.00,770.00,3850.00,530.00,'2023-01-07 15:51:55'),(400,'1','307',1,'Retail Sale Id 403',0.00,4010.56,770.00,4650.80,640.24,'2023-01-07 16:14:10'),(401,'1','307',1,'Retail Sale Id 404',0.00,1334.64,770.00,1547.70,213.06,'2023-01-07 16:29:53'),(402,'1','307',1,'Retail Sale Id 405',0.00,2589.60,770.00,3003.00,413.40,'2023-01-07 17:05:28'),(403,'1','307',1,'Retail Sale Id 406',0.00,1985.36,770.00,2302.30,316.94,'2023-01-07 17:12:55'),(404,'1','307',1,'Retail Sale Id 407',0.00,2656.00,770.00,3080.00,424.00,'2023-01-07 17:26:16'),(405,'1','307',1,'Retail Sale Id 408',0.00,3984.00,770.00,4620.00,636.00,'2023-01-07 17:37:18'),(406,'1','307',1,'Retail Sale Id 409',0.00,2025.20,770.00,2348.50,323.30,'2023-01-07 17:43:48'),(407,'1','307',1,'Retail Sale Id 410',0.00,4010.56,770.00,4650.80,640.24,'2023-01-07 18:03:05'),(408,'1','307',1,'Retail Sale Id 411',0.00,2025.20,770.00,2348.50,323.30,'2023-01-07 18:09:02'),(409,'1','307',1,'Retail Sale Id 412',0.00,1328.00,770.00,1540.00,212.00,'2023-01-07 18:10:36'),(410,'1','307',1,'Retail Sale Id 413',0.00,49136.00,710.00,52540.00,3404.00,'2023-01-07 18:24:07'),(411,'1','307',1,'Retail Sale Id 414',0.00,2656.00,770.00,3080.00,424.00,'2023-01-07 18:33:41'),(412,'1','307',1,'Retail Sale Id 415',0.00,10345.12,770.00,11996.60,1651.48,'2023-01-07 18:48:20'),(413,'1','307',1,'Retail Sale Id 416',0.00,33.20,770.00,38.50,5.30,'2023-01-07 18:58:18'),(414,'1','307',1,'Return of Retail Sale Id 416',33.20,0.00,770.00,-38.50,-5.30,'2023-01-07 18:59:24'),(415,'1','307',1,'Retail Sale Id 417',0.00,2158.00,770.00,2502.50,344.50,'2023-01-08 07:25:01'),(416,'1','307',1,'Retail Sale Id 418',0.00,431.60,770.00,500.50,68.90,'2023-01-08 07:27:17'),(417,'1','307',1,'Retail Sale Id 419',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-08 07:54:00'),(418,'1','307',1,'Retail Sale Id 420',0.00,4309.36,770.00,4997.30,687.94,'2023-01-08 09:35:56'),(419,'1','307',1,'Retail Sale Id 421',0.00,2656.00,770.00,3080.00,424.00,'2023-01-08 09:37:59'),(420,'1','307',1,'Retail Sale Id 422',0.00,1992.00,770.00,2310.00,318.00,'2023-01-08 09:39:34'),(421,'1','307',1,'Retail Sale Id 423',0.00,690.56,770.00,800.80,110.24,'2023-01-08 10:11:26'),(422,'1','307',1,'Retail Sale Id 424',0.00,2025.20,770.00,2348.50,323.30,'2023-01-08 10:16:17'),(423,'1','307',1,'Retail Sale Id 425',0.00,3320.00,770.00,3850.00,530.00,'2023-01-08 10:20:21'),(424,'1','307',1,'Retail Sale Id 426',0.00,4010.56,770.00,4650.80,640.24,'2023-01-08 10:57:58'),(425,'1','307',1,'Retail Sale Id 429',0.00,4010.56,770.00,4650.80,640.24,'2023-01-08 11:18:28'),(426,'1','307',1,'Retail Sale Id 430',0.00,1726.40,770.00,2002.00,275.60,'2023-01-08 11:34:29'),(427,'1','307',1,'Retail Sale Id 431',0.00,2675.92,770.00,3103.10,427.18,'2023-01-08 11:41:08'),(428,'1','307',1,'Retail Sale Id 432',0.00,3984.00,770.00,4620.00,636.00,'2023-01-08 11:53:26'),(429,'1','307',1,'Retail Sale Id 433',0.00,4010.56,770.00,4650.80,640.24,'2023-01-08 11:58:31'),(430,'1','307',1,'Retail Sale Id 434',0.00,3320.00,770.00,3850.00,530.00,'2023-01-08 12:00:56'),(431,'1','307',1,'Retail Sale Id 435',0.00,2025.20,770.00,2348.50,323.30,'2023-01-08 12:05:20'),(432,'1','307',1,'Retail Sale Id 436',0.00,3446.16,770.00,3996.30,550.14,'2023-01-08 12:31:21'),(433,'1','307',1,'Retail Sale Id 437',0.00,6035.76,770.00,6999.30,963.54,'2023-01-08 12:40:44'),(434,'1','307',1,'Retail Sale Id 438',0.00,5312.00,770.00,6160.00,848.00,'2023-01-08 12:42:28'),(435,'1','307',1,'Retail Sale Id 439',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-08 12:50:07'),(436,'1','307',1,'Retail Sale Id 440',0.00,4010.56,770.00,4650.80,640.24,'2023-01-08 13:11:09'),(437,'1','307',1,'Retail Sale Id 441',0.00,3320.00,770.00,3850.00,530.00,'2023-01-08 13:14:47'),(438,'1','307',1,'Retail Sale Id 442',0.00,6640.00,770.00,7700.00,1060.00,'2023-01-08 13:48:59'),(439,'1','307',1,'Retail Sale Id 443',0.00,1467.44,770.00,1701.70,234.26,'2023-01-08 14:07:00'),(440,'1','307',1,'Retail Sale Id 444',0.00,2675.92,770.00,3103.10,427.18,'2023-01-08 14:24:41'),(441,'1','307',1,'Retail Sale Id 445',0.00,4010.56,770.00,4650.80,640.24,'2023-01-08 14:55:49'),(442,'1','307',1,'Retail Sale Id 446',0.00,3964.08,770.00,4596.90,632.82,'2023-01-08 15:11:49'),(443,'1','307',1,'Retail Sale Id 447',0.00,7974.64,770.00,9247.70,1273.06,'2023-01-08 15:25:10'),(444,'1','307',1,'Retail Sale Id 448',0.00,1726.40,770.00,2002.00,275.60,'2023-01-08 15:53:19'),(445,'1','307',1,'Retail Sale Id 449',0.00,2025.20,770.00,2348.50,323.30,'2023-01-08 16:19:01'),(446,'1','307',1,'Retail Sale Id 450',0.00,3320.00,770.00,3850.00,530.00,'2023-01-08 16:22:02'),(447,'1','307',1,'Retail Sale Id 451',0.00,1328.00,770.00,1540.00,212.00,'2023-01-08 16:36:36'),(448,'1','307',1,'Retail Sale Id 452',0.00,1334.64,770.00,1547.70,213.06,'2023-01-08 16:38:43'),(449,'1','307',1,'Retail Sale Id 453',0.00,2656.00,770.00,3080.00,424.00,'2023-01-08 16:40:32'),(450,'1','307',1,'Retail Sale Id 454',0.00,3984.00,770.00,4620.00,636.00,'2023-01-08 17:07:49'),(451,'1','307',1,'Retail Sale Id 455',0.00,8293.36,770.00,9617.30,1323.94,'2023-01-08 17:21:00'),(452,'1','307',1,'Retail Sale Id 456',0.00,1328.00,770.00,1540.00,212.00,'2023-01-08 17:28:16'),(453,'1','307',1,'Retail Sale Id 457',0.00,1992.00,770.00,2310.00,318.00,'2023-01-08 17:38:24'),(454,'1','307',1,'Retail Sale Id 457',0.00,3984.00,770.00,4620.00,636.00,'2023-01-08 17:38:24'),(455,'1','307',1,'Retail Sale Id 458',0.00,664.00,770.00,770.00,106.00,'2023-01-08 18:04:45'),(456,'1','307',1,'Retail Sale Id 459',0.00,3320.00,770.00,3850.00,530.00,'2023-01-08 18:11:44'),(457,'1','307',1,'Retail Sale Id 460',0.00,3320.00,770.00,3850.00,530.00,'2023-01-08 18:23:24'),(458,'1','307',1,'Retail Sale Id 461',0.00,4654.64,770.00,5397.70,743.06,'2023-01-08 18:33:08'),(459,'1','307',1,'Retail Sale Id 462',0.00,4010.56,770.00,4650.80,640.24,'2023-01-09 08:01:08'),(460,'1','307',1,'Retail Sale Id 463',0.00,1992.00,770.00,2310.00,318.00,'2023-01-09 08:02:30'),(461,'1','307',1,'Retail Sale Id 465',0.00,4010.56,770.00,4650.80,640.24,'2023-01-09 08:17:38'),(462,'1','307',1,'Retail Sale Id 466',0.00,3984.00,770.00,4620.00,636.00,'2023-01-09 08:18:55'),(463,'1','307',1,'Retail Sale Id 467',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-09 08:46:38'),(464,'1','307',1,'Retail Sale Id 468',0.00,1294.80,770.00,1501.50,206.70,'2023-01-09 10:03:34'),(465,'1','307',1,'Retail Sale Id 469',0.00,1294.80,770.00,1501.50,206.70,'2023-01-09 10:26:36'),(466,'1','307',1,'Retail Sale Id 470',0.00,66400.00,710.00,71000.00,4600.00,'2023-01-09 10:33:36'),(467,'1','307',1,'Retail Sale Id 471',0.00,2656.00,770.00,3080.00,424.00,'2023-01-09 13:22:30'),(468,'1','307',1,'Retail Sale Id 472',0.00,6640.00,770.00,7700.00,1060.00,'2023-01-09 13:59:07'),(469,'1','307',1,'Retail Sale Id 473',0.00,3320.00,770.00,3850.00,530.00,'2023-01-09 14:08:39'),(470,'1','307',1,'Retail Sale Id 474',0.00,8313.28,770.00,9640.40,1327.12,'2023-01-09 15:06:38'),(471,'1','307',1,'Retail Sale Id 475',0.00,3984.00,770.00,4620.00,636.00,'2023-01-09 15:17:55'),(472,'1','307',1,'Retail Sale Id 476',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-09 15:36:33'),(473,'1','307',1,'Retail Sale Id 478',0.00,3446.16,770.00,3996.30,550.14,'2023-01-09 15:58:14'),(474,'1','307',1,'Retail Sale Id 479',0.00,2656.00,770.00,3080.00,424.00,'2023-01-09 16:30:33'),(475,'1','307',1,'Retail Sale Id 480',0.00,4010.56,770.00,4650.80,640.24,'2023-01-09 16:38:54'),(476,'1','307',1,'Retail Sale Id 481',0.00,4010.56,770.00,4650.80,640.24,'2023-01-09 16:41:07'),(477,'1','307',1,'Retail Sale Id 482',0.00,3320.00,770.00,3850.00,530.00,'2023-01-09 17:01:07'),(478,'1','307',1,'Retail Sale Id 483',0.00,690.56,770.00,800.80,110.24,'2023-01-09 17:07:26'),(479,'1','307',1,'Retail Sale Id 484',0.00,4010.56,770.00,4650.80,640.24,'2023-01-09 17:10:14'),(480,'1','307',1,'Retail Sale Id 485',0.00,3984.00,770.00,4620.00,636.00,'2023-01-09 17:23:06'),(481,'1','307',1,'Retail Sale Id 486',0.00,664.00,770.00,770.00,106.00,'2023-01-09 17:40:32'),(482,'1','307',1,'Retail Sale Id 487',0.00,4309.36,770.00,4997.30,687.94,'2023-01-09 17:58:30'),(483,'1','307',1,'Retail Sale Id 488',0.00,1726.40,770.00,2002.00,275.60,'2023-01-09 17:59:49'),(484,'1','307',1,'Retail Sale Id 490',0.00,1992.00,770.00,2310.00,318.00,'2023-01-09 18:32:22'),(485,'1','307',1,'Retail Sale Id 491',0.00,5312.00,770.00,6160.00,848.00,'2023-01-09 18:36:54'),(486,'1','307',1,'Retail Sale Id 492',0.00,3320.00,770.00,3850.00,530.00,'2023-01-09 18:52:40'),(487,'1','307',1,'Retail Sale Id 493',0.00,26.56,770.00,30.80,4.24,'2023-01-09 19:02:32'),(488,'1','307',1,'Retail Sale Id 494',0.00,863.20,770.00,1001.00,137.80,'2023-01-10 07:38:09'),(489,'1','307',1,'Retail Sale Id 495',0.00,1992.00,770.00,2310.00,318.00,'2023-01-10 07:55:08'),(490,'1','307',1,'Retail Sale Id 496',0.00,690.56,770.00,800.80,110.24,'2023-01-10 08:11:12'),(491,'1','307',1,'Retail Sale Id 497',0.00,1992.00,770.00,2310.00,318.00,'2023-01-10 08:29:15'),(492,'1','307',1,'Retail Sale Id 498',0.00,6640.00,770.00,7700.00,1060.00,'2023-01-10 08:43:31'),(493,'1','307',1,'Retail Sale Id 499',0.00,1334.64,770.00,1547.70,213.06,'2023-01-10 09:28:58'),(494,'1','307',1,'Retail Sale Id 500',0.00,3320.00,770.00,3850.00,530.00,'2023-01-10 10:16:30'),(495,'1','307',1,'Retail Sale Id 501',0.00,4010.56,770.00,4650.80,640.24,'2023-01-10 10:33:11'),(496,'1','307',1,'Retail Sale Id 502',0.00,2025.20,770.00,2348.50,323.30,'2023-01-10 10:58:02'),(497,'1','307',1,'Retail Sale Id 503',0.00,99600.00,710.00,106500.00,6900.00,'2023-01-10 11:38:33'),(498,'1','307',1,'Retail Sale Id 504',0.00,1334.64,770.00,1547.70,213.06,'2023-01-10 11:48:49'),(499,'1','307',1,'Retail Sale Id 505',0.00,1726.40,770.00,2002.00,275.60,'2023-01-10 12:52:37'),(500,'1','307',1,'Retail Sale Id 506',0.00,4010.56,770.00,4650.80,640.24,'2023-01-10 13:25:06'),(501,'1','307',1,'Retail Sale Id 507',0.00,1328.00,770.00,1540.00,212.00,'2023-01-10 13:52:59'),(502,'1','307',1,'Retail Sale Id 508',0.00,1992.00,770.00,2310.00,318.00,'2023-01-10 15:04:06'),(503,'1','307',1,'Retail Sale Id 509',0.00,1334.64,770.00,1547.70,213.06,'2023-01-10 15:05:22'),(504,'1','307',1,'Retail Sale Id 510',0.00,1992.00,770.00,2310.00,318.00,'2023-01-10 15:14:37'),(505,'1','307',1,'Retail Sale Id 512',0.00,1328.00,770.00,1540.00,212.00,'2023-01-10 15:24:45'),(506,'1','307',1,'Retail Sale Id 513',0.00,690.56,770.00,800.80,110.24,'2023-01-10 15:31:54'),(507,'1','307',1,'Retail Sale Id 514',0.00,664.00,770.00,770.00,106.00,'2023-01-10 15:33:22'),(508,'1','307',1,'Retail Sale Id 515',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-10 15:51:58'),(509,'1','307',1,'Retail Sale Id 516',0.00,4010.56,770.00,4650.80,640.24,'2023-01-10 16:26:56'),(510,'1','307',1,'Retail Sale Id 517',0.00,2025.20,770.00,2348.50,323.30,'2023-01-10 16:56:20'),(511,'1','307',1,'Retail Sale Id 518',0.00,1985.36,770.00,2302.30,316.94,'2023-01-10 17:41:24'),(512,'1','307',1,'Retail Sale Id 519',0.00,1726.40,770.00,2002.00,275.60,'2023-01-10 17:43:18'),(513,'1','307',1,'Retail Sale Id 520',0.00,1334.64,770.00,1547.70,213.06,'2023-01-10 17:48:53'),(514,'1','307',1,'Retail Sale Id 521',0.00,4010.56,770.00,4650.80,640.24,'2023-01-10 17:50:26'),(515,'1','307',1,'Retail Sale Id 522',0.00,1334.64,770.00,1547.70,213.06,'2023-01-10 18:30:00'),(516,'1','307',1,'Retail Sale Id 523',0.00,2675.92,770.00,3103.10,427.18,'2023-01-10 18:31:54'),(517,'1','307',1,'Retail Sale Id 524',0.00,1334.64,770.00,1547.70,213.06,'2023-01-11 07:34:08'),(518,'1','307',1,'Retail Sale Id 525',0.00,6640.00,770.00,7700.00,1060.00,'2023-01-11 08:20:10'),(519,'1','307',1,'Retail Sale Id 526',0.00,5345.20,770.00,6198.50,853.30,'2023-01-11 08:32:23'),(520,'1','307',1,'Retail Sale Id 527',0.00,6640.00,770.00,7700.00,1060.00,'2023-01-11 08:34:03'),(521,'1','307',1,'Retail Sale Id 528',0.00,2025.20,770.00,2348.50,323.30,'2023-01-11 08:39:31'),(522,'1','307',1,'Retail Sale Id 529',0.00,9960.00,770.00,11550.00,1590.00,'2023-01-11 09:16:28'),(523,'1','307',1,'Retail Sale Id 530',0.00,2025.20,770.00,2348.50,323.30,'2023-01-11 09:38:17'),(524,'1','307',1,'Retail Sale Id 531',0.00,2025.20,770.00,2348.50,323.30,'2023-01-11 09:43:03'),(525,'1','307',1,'Retail Sale Id 532',0.00,3877.76,770.00,4496.80,619.04,'2023-01-11 09:53:52'),(526,'1','307',1,'Retail Sale Id 533',0.00,2675.92,770.00,3103.10,427.18,'2023-01-11 10:02:27'),(527,'1','307',1,'Retail Sale Id 534',0.00,3984.00,770.00,4620.00,636.00,'2023-01-11 10:24:47'),(528,'1','307',1,'Retail Sale Id 535',0.00,1992.00,770.00,2310.00,318.00,'2023-01-11 10:29:16'),(529,'1','307',1,'Retail Sale Id 536',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-11 10:33:00'),(530,'1','307',1,'Retail Sale Id 537',0.00,2025.20,770.00,2348.50,323.30,'2023-01-11 10:36:12'),(531,'1','307',1,'Retail Sale Id 539',0.00,863.20,770.00,1001.00,137.80,'2023-01-11 11:04:33'),(532,'1','307',1,'Retail Sale Id 540',0.00,6640.00,770.00,7700.00,1060.00,'2023-01-11 11:07:17'),(533,'1','307',1,'Retail Sale Id 541',0.00,3446.16,770.00,3996.30,550.14,'2023-01-11 11:33:52'),(534,'1','307',1,'Retail Sale Id 542',0.00,1992.00,770.00,2310.00,318.00,'2023-01-11 12:29:34'),(535,'1','307',1,'Retail Sale Id 542',0.00,1992.00,770.00,2310.00,318.00,'2023-01-11 12:29:34'),(536,'1','307',1,'Retail Sale Id 543',0.00,1328.00,770.00,1540.00,212.00,'2023-01-11 12:31:06'),(537,'1','307',1,'Retail Sale Id 544',0.00,5869.76,770.00,6806.80,937.04,'2023-01-11 13:37:37'),(538,'1','307',1,'Sale Id 1',0.00,74826.16,770.00,86771.30,11945.14,'2023-01-11 14:03:02'),(539,'1','307',1,'Retail Sale Id 545',0.00,2025.20,770.00,2348.50,323.30,'2023-01-11 15:44:06'),(540,'1','307',1,'Retail Sale Id 546',0.00,4010.56,770.00,4650.80,640.24,'2023-01-11 15:46:51'),(541,'1','307',1,'Retail Sale Id 547',0.00,6640.00,770.00,7700.00,1060.00,'2023-01-11 15:48:17'),(542,'1','307',1,'Retail Sale Id 548',0.00,3984.00,770.00,4620.00,636.00,'2023-01-11 15:55:27'),(543,'1','307',1,'Retail Sale Id 549',0.00,4010.56,770.00,4650.80,640.24,'2023-01-11 15:56:20'),(544,'1','307',1,'Retail Sale Id 550',0.00,1334.64,770.00,1547.70,213.06,'2023-01-11 15:59:15'),(545,'1','307',1,'Retail Sale Id 551',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-11 16:16:59'),(546,'1','307',1,'Retail Sale Id 552',0.00,1294.80,770.00,1501.50,206.70,'2023-01-11 16:20:06'),(547,'1','307',1,'Retail Sale Id 553',0.00,1334.64,770.00,1547.70,213.06,'2023-01-11 16:21:37'),(548,'1','307',1,'Retail Sale Id 554',0.00,690.56,770.00,800.80,110.24,'2023-01-11 16:24:17'),(549,'1','307',1,'Retail Sale Id 555',0.00,4654.64,770.00,5397.70,743.06,'2023-01-11 16:25:41'),(550,'1','307',1,'Retail Sale Id 556',0.00,1294.80,770.00,1501.50,206.70,'2023-01-11 16:31:13'),(551,'1','307',1,'Retail Sale Id 557',0.00,863.20,770.00,1001.00,137.80,'2023-01-11 16:43:08'),(552,'1','307',1,'Retail Sale Id 558',0.00,664.00,770.00,770.00,106.00,'2023-01-11 16:54:01'),(553,'1','307',1,'Retail Sale Id 558',0.00,664.00,770.00,770.00,106.00,'2023-01-11 16:54:01'),(554,'1','307',1,'Retail Sale Id 559',0.00,1992.00,770.00,2310.00,318.00,'2023-01-11 16:58:08'),(555,'1','307',1,'Retail Sale Id 560',0.00,1992.00,770.00,2310.00,318.00,'2023-01-11 17:04:00'),(556,'1','307',1,'Retail Sale Id 561',0.00,1328.00,770.00,1540.00,212.00,'2023-01-11 17:08:32'),(557,'1','307',1,'Retail Sale Id 562',0.00,1381.12,770.00,1601.60,220.48,'2023-01-11 17:58:16'),(558,'1','307',1,'Retail Sale Id 563',0.00,8319.92,770.00,9648.10,1328.18,'2023-01-11 18:06:18'),(559,'1','307',1,'Retail Sale Id 564',0.00,1328.00,770.00,1540.00,212.00,'2023-01-11 18:24:11'),(560,'1','307',1,'Retail Sale Id 565',0.00,664.00,770.00,770.00,106.00,'2023-01-11 18:26:39'),(561,'1','307',1,'Retail Sale Id 566',0.00,3612.16,770.00,4188.80,576.64,'2023-01-11 18:50:49'),(562,'1','307',1,'Retail Sale Id 567',0.00,39840.00,710.00,42600.00,2760.00,'2023-01-12 07:28:24'),(563,'1','307',1,'Retail Sale Id 568',0.00,1746.32,760.00,1998.80,252.48,'2023-01-12 08:27:30'),(564,'1','307',1,'Retail Sale Id 569',0.00,3984.00,760.00,4560.00,576.00,'2023-01-12 08:45:04'),(565,'1','307',1,'Retail Sale Id 570',0.00,2011.92,760.00,2302.80,290.88,'2023-01-12 08:47:04'),(566,'1','307',1,'Retail Sale Id 571',0.00,1328.00,760.00,1520.00,192.00,'2023-01-12 08:55:05'),(567,'1','307',1,'Retail Sale Id 572',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-12 08:58:28'),(568,'1','307',1,'Retail Sale Id 573',0.00,2011.92,760.00,2302.80,290.88,'2023-01-12 09:52:53'),(569,'1','307',1,'Retail Sale Id 574',0.00,2011.92,760.00,2302.80,290.88,'2023-01-12 10:01:45'),(570,'1','307',1,'Retail Sale Id 574',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-12 10:01:45'),(571,'1','307',1,'Retail Sale Id 575',0.00,49800.00,710.00,53250.00,3450.00,'2023-01-12 10:55:15'),(572,'1','307',1,'Retail Sale Id 576',0.00,4369.12,760.00,5000.80,631.68,'2023-01-12 10:58:13'),(573,'1','307',1,'Retail Sale Id 577',0.00,3984.00,760.00,4560.00,576.00,'2023-01-12 11:00:48'),(574,'1','307',1,'Retail Sale Id 578',0.00,3320.00,760.00,3800.00,480.00,'2023-01-12 11:02:25'),(575,'1','307',1,'Retail Sale Id 579',0.00,1746.32,760.00,1998.80,252.48,'2023-01-12 12:43:10'),(576,'1','307',1,'Retail Sale Id 580',0.00,2011.92,760.00,2302.80,290.88,'2023-01-12 12:49:01'),(577,'1','307',1,'Retail Sale Id 581',0.00,2098.24,760.00,2401.60,303.36,'2023-01-12 13:25:16'),(578,'1','307',1,'Retail Sale Id 582',0.00,1354.56,760.00,1550.40,195.84,'2023-01-12 13:34:40'),(579,'1','307',1,'Retail Sale Id 583',0.00,2011.92,760.00,2302.80,290.88,'2023-01-12 13:40:08'),(580,'1','307',1,'Retail Sale Id 584',0.00,4017.20,760.00,4598.00,580.80,'2023-01-12 13:49:56'),(581,'1','307',1,'Retail Sale Id 585',0.00,3984.00,760.00,4560.00,576.00,'2023-01-12 13:51:05'),(582,'1','307',1,'Retail Sale Id 586',0.00,6029.12,760.00,6900.80,871.68,'2023-01-12 13:58:18'),(583,'1','307',1,'Retail Sale Id 587',0.00,3977.36,760.00,4552.40,575.04,'2023-01-12 14:10:21'),(584,'1','307',1,'Retail Sale Id 588',0.00,697.20,760.00,798.00,100.80,'2023-01-12 15:09:08'),(585,'1','307',1,'Retail Sale Id 589',0.00,4017.20,760.00,4598.00,580.80,'2023-01-12 15:42:52'),(586,'1','307',1,'Retail Sale Id 590',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-12 15:52:11'),(587,'1','307',1,'Retail Sale Id 591',0.00,2011.92,760.00,2302.80,290.88,'2023-01-12 16:15:52'),(588,'1','307',1,'Retail Sale Id 592',0.00,1918.96,760.00,2196.40,277.44,'2023-01-12 16:34:36'),(589,'1','307',1,'Retail Sale Id 593',0.00,2011.92,760.00,2302.80,290.88,'2023-01-12 16:56:11'),(590,'1','307',1,'Retail Sale Id 594',0.00,3984.00,760.00,4560.00,576.00,'2023-01-12 17:17:49'),(591,'1','307',1,'Retail Sale Id 595',0.00,1354.56,760.00,1550.40,195.84,'2023-01-12 17:19:42'),(592,'1','307',1,'Retail Sale Id 597',0.00,2656.00,760.00,3040.00,384.00,'2023-01-12 17:26:33'),(593,'1','307',1,'Retail Sale Id 598',0.00,2622.80,760.00,3002.00,379.20,'2023-01-12 17:57:41'),(594,'1','307',1,'Retail Sale Id 599',0.00,2011.92,760.00,2302.80,290.88,'2023-01-12 18:01:49'),(595,'1','307',1,'Retail Sale Id 600',0.00,2443.52,760.00,2796.80,353.28,'2023-01-12 18:27:43'),(596,'1','307',1,'Retail Sale Id 601',0.00,1992.00,760.00,2280.00,288.00,'2023-01-12 18:37:51'),(597,'1','307',1,'Retail Sale Id 602',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-13 08:28:09'),(598,'1','307',1,'Retail Sale Id 603',0.00,1354.56,760.00,1550.40,195.84,'2023-01-13 08:35:48'),(599,'1','307',1,'Retail Sale Id 604',0.00,3320.00,760.00,3800.00,480.00,'2023-01-13 09:21:02'),(600,'1','307',1,'Retail Sale Id 604',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-13 09:21:02'),(601,'1','307',1,'Retail Sale Id 605',0.00,3320.00,760.00,3800.00,480.00,'2023-01-13 09:26:24'),(602,'1','307',1,'Retail Sale Id 606',0.00,16600.00,760.00,19000.00,2400.00,'2023-01-13 09:27:13'),(603,'1','307',1,'Retail Sale Id 607',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-13 09:32:43'),(604,'1','307',1,'Retail Sale Id 608',0.00,1354.56,760.00,1550.40,195.84,'2023-01-13 09:35:50'),(605,'1','307',1,'Retail Sale Id 609',0.00,1992.00,760.00,2280.00,288.00,'2023-01-13 09:47:23'),(606,'1','307',1,'Retail Sale Id 610',0.00,2011.92,760.00,2302.80,290.88,'2023-01-13 09:51:00'),(607,'1','307',1,'Retail Sale Id 611',0.00,3320.00,760.00,3800.00,480.00,'2023-01-13 09:54:05'),(608,'1','307',1,'Retail Sale Id 612',0.00,4017.20,760.00,4598.00,580.80,'2023-01-13 10:58:00'),(609,'1','307',1,'Retail Sale Id 613',0.00,3320.00,760.00,3800.00,480.00,'2023-01-13 10:59:53'),(610,'1','307',1,'Retail Sale Id 614',0.00,2011.92,760.00,2302.80,290.88,'2023-01-13 11:08:42'),(611,'1','307',1,'Retail Sale Id 615',0.00,2662.64,760.00,3047.60,384.96,'2023-01-13 11:11:25'),(612,'1','307',1,'Retail Sale Id 616',0.00,1328.00,760.00,1520.00,192.00,'2023-01-13 11:31:20'),(613,'1','307',1,'Retail Sale Id 617',0.00,438.24,760.00,501.60,63.36,'2023-01-13 11:34:50'),(614,'1','307',1,'Retail Sale Id 618',0.00,1354.56,760.00,1550.40,195.84,'2023-01-13 12:01:27'),(615,'1','307',1,'Retail Sale Id 619',0.00,3492.64,760.00,3997.60,504.96,'2023-01-13 12:06:19'),(616,'1','307',1,'Retail Sale Id 620',0.00,2011.92,760.00,2302.80,290.88,'2023-01-13 12:11:05'),(617,'1','307',1,'Retail Sale Id 621',0.00,1746.32,760.00,1998.80,252.48,'2023-01-13 13:22:27'),(618,'1','307',1,'Retail Sale Id 622',0.00,83000.00,710.00,88750.00,5750.00,'2023-01-13 14:07:38'),(619,'1','307',1,'Retail Sale Id 623',0.00,2011.92,760.00,2302.80,290.88,'2023-01-13 14:09:05'),(620,'1','307',1,'Retail Sale Id 624',0.00,2011.92,760.00,2302.80,290.88,'2023-01-13 14:34:53'),(621,'1','307',1,'Retail Sale Id 625',0.00,3320.00,760.00,3800.00,480.00,'2023-01-13 14:36:37'),(622,'1','307',1,'Retail Sale Id 626',0.00,697.20,760.00,798.00,100.80,'2023-01-13 14:51:16'),(623,'1','307',1,'Retail Sale Id 627',0.00,697.20,760.00,798.00,100.80,'2023-01-13 15:04:55'),(624,'1','307',1,'Retail Sale Id 628',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-13 16:18:17'),(625,'1','307',1,'Retail Sale Id 629',0.00,2011.92,760.00,2302.80,290.88,'2023-01-13 16:27:49'),(626,'1','307',1,'Retail Sale Id 630',0.00,664.00,760.00,760.00,96.00,'2023-01-13 16:39:57'),(627,'1','307',1,'Retail Sale Id 631',0.00,1347.92,760.00,1542.80,194.88,'2023-01-13 17:31:56'),(628,'1','307',1,'Retail Sale Id 632',0.00,1918.96,760.00,2196.40,277.44,'2023-01-13 17:33:21'),(629,'1','307',1,'Retail Sale Id 633',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-13 17:39:16'),(630,'1','307',1,'Retail Sale Id 634',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-13 17:43:44'),(631,'1','307',1,'Retail Sale Id 635',0.00,2011.92,760.00,2302.80,290.88,'2023-01-13 17:45:04'),(632,'1','307',1,'Retail Sale Id 636',0.00,1328.00,760.00,1520.00,192.00,'2023-01-13 17:47:38'),(633,'1','307',1,'Retail Sale Id 636',0.00,1992.00,760.00,2280.00,288.00,'2023-01-13 17:47:38'),(634,'1','307',1,'Retail Sale Id 637',0.00,2011.92,760.00,2302.80,290.88,'2023-01-13 18:07:28'),(635,'1','307',1,'Retail Sale Id 638',0.00,4369.12,760.00,5000.80,631.68,'2023-01-13 18:31:42'),(636,'1','307',1,'Retail Sale Id 639',0.00,2948.16,760.00,3374.40,426.24,'2023-01-13 18:57:35'),(637,'1','307',1,'Retail Sale Id 640',0.00,1354.56,760.00,1550.40,195.84,'2023-01-14 08:26:15'),(638,'1','307',1,'Retail Sale Id 641',0.00,6640.00,760.00,7600.00,960.00,'2023-01-14 09:08:12'),(639,'1','307',1,'Retail Sale Id 642',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-14 09:10:59'),(640,'1','307',1,'Retail Sale Id 643',0.00,2011.92,760.00,2302.80,290.88,'2023-01-14 09:12:57'),(641,'1','307',1,'Retail Sale Id 644',0.00,2656.00,760.00,3040.00,384.00,'2023-01-14 09:32:10'),(642,'1','307',1,'Retail Sale Id 645',0.00,1328.00,760.00,1520.00,192.00,'2023-01-14 09:36:37'),(643,'1','307',1,'Retail Sale Id 646',0.00,4017.20,760.00,4598.00,580.80,'2023-01-14 10:40:05'),(644,'1','307',1,'Retail Sale Id 647',0.00,438.24,760.00,501.60,63.36,'2023-01-14 11:02:40'),(645,'1','307',1,'Retail Sale Id 648',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-14 11:06:13'),(646,'1','307',1,'Retail Sale Id 649',0.00,664.00,760.00,760.00,96.00,'2023-01-14 11:08:22'),(647,'1','307',1,'Retail Sale Id 650',0.00,3320.00,760.00,3800.00,480.00,'2023-01-14 11:44:26'),(648,'1','307',1,'Retail Sale Id 651',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-14 11:46:53'),(649,'1','307',1,'Retail Sale Id 653',0.00,1308.08,760.00,1497.20,189.12,'2023-01-14 11:51:14'),(650,'1','307',1,'Retail Sale Id 654',0.00,3320.00,760.00,3800.00,480.00,'2023-01-14 11:54:00'),(651,'1','307',1,'Retail Sale Id 655',0.00,2011.92,760.00,2302.80,290.88,'2023-01-14 12:00:05'),(652,'1','307',1,'Retail Sale Id 656',0.00,3984.00,760.00,4560.00,576.00,'2023-01-14 12:11:19'),(653,'1','307',1,'Retail Sale Id 657',0.00,4017.20,760.00,4598.00,580.80,'2023-01-14 12:56:13'),(654,'1','307',1,'Retail Sale Id 658',0.00,2011.92,760.00,2302.80,290.88,'2023-01-14 13:20:19'),(655,'1','307',1,'Retail Sale Id 659',0.00,4017.20,760.00,4598.00,580.80,'2023-01-14 13:37:09'),(656,'1','307',1,'Retail Sale Id 660',0.00,1354.56,760.00,1550.40,195.84,'2023-01-14 13:38:43'),(657,'1','307',1,'Retail Sale Id 661',0.00,2011.92,760.00,2302.80,290.88,'2023-01-14 13:50:00'),(658,'1','307',1,'Retail Sale Id 662',0.00,4017.20,760.00,4598.00,580.80,'2023-01-14 13:55:03'),(659,'1','307',1,'Retail Sale Id 663',0.00,1308.08,760.00,1497.20,189.12,'2023-01-14 14:15:34'),(660,'1','307',1,'Retail Sale Id 664',0.00,5331.92,760.00,6102.80,770.88,'2023-01-14 14:24:41'),(661,'1','307',1,'Retail Sale Id 665',0.00,2011.92,760.00,2302.80,290.88,'2023-01-14 14:38:54'),(662,'1','307',1,'Retail Sale Id 665',0.00,2011.92,760.00,2302.80,290.88,'2023-01-14 14:38:54'),(663,'1','307',1,'Retail Sale Id 666',0.00,1308.08,760.00,1497.20,189.12,'2023-01-14 15:12:08'),(664,'1','307',1,'Retail Sale Id 667',0.00,1401.04,760.00,1603.60,202.56,'2023-01-14 15:13:42'),(665,'1','307',1,'Retail Sale Id 668',0.00,4017.20,760.00,4598.00,580.80,'2023-01-14 15:53:16'),(666,'1','307',1,'Retail Sale Id 669',0.00,2011.92,760.00,2302.80,290.88,'2023-01-14 15:55:36'),(667,'1','307',1,'Retail Sale Id 670',0.00,4017.20,760.00,4598.00,580.80,'2023-01-14 15:57:29'),(668,'1','307',1,'Retail Sale Id 671',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-14 16:00:54'),(669,'1','307',1,'Retail Sale Id 672',0.00,6640.00,760.00,7600.00,960.00,'2023-01-14 16:20:46'),(670,'1','307',1,'Retail Sale Id 673',0.00,1746.32,760.00,1998.80,252.48,'2023-01-14 16:24:08'),(671,'1','307',1,'Retail Sale Id 674',0.00,4017.20,760.00,4598.00,580.80,'2023-01-14 16:25:41'),(672,'1','307',1,'Retail Sale Id 675',0.00,1354.56,760.00,1550.40,195.84,'2023-01-14 16:47:33'),(673,'1','307',1,'Retail Sale Id 676',0.00,4017.20,760.00,4598.00,580.80,'2023-01-14 16:51:43'),(674,'1','307',1,'Retail Sale Id 677',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-14 16:53:54'),(675,'1','307',1,'Retail Sale Id 678',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-14 17:03:10'),(676,'1','307',1,'Retail Sale Id 679',0.00,2011.92,760.00,2302.80,290.88,'2023-01-14 17:07:32'),(677,'1','307',1,'Retail Sale Id 680',0.00,66400.00,710.00,71000.00,4600.00,'2023-01-14 17:09:17'),(678,'1','307',1,'Retail Sale Id 681',0.00,1354.56,760.00,1550.40,195.84,'2023-01-14 17:16:45'),(679,'1','307',1,'Retail Sale Id 682',0.00,2011.92,760.00,2302.80,290.88,'2023-01-14 17:20:17'),(680,'1','307',1,'Retail Sale Id 683',0.00,3930.88,760.00,4499.20,568.32,'2023-01-14 17:29:29'),(681,'1','307',1,'Retail Sale Id 684',0.00,2011.92,760.00,2302.80,290.88,'2023-01-14 17:49:12'),(682,'1','307',1,'Retail Sale Id 685',0.00,2662.64,760.00,3047.60,384.96,'2023-01-14 17:56:09'),(683,'1','307',1,'Retail Sale Id 686',0.00,2443.52,760.00,2796.80,353.28,'2023-01-14 17:57:12'),(684,'1','307',1,'Retail Sale Id 687',0.00,2011.92,760.00,2302.80,290.88,'2023-01-14 18:00:08'),(685,'1','307',1,'Retail Sale Id 688',0.00,4017.20,760.00,4598.00,580.80,'2023-01-14 18:18:41'),(686,'1','307',1,'Retail Sale Id 689',0.00,4017.20,760.00,4598.00,580.80,'2023-01-14 18:21:19'),(687,'1','307',1,'Retail Sale Id 690',0.00,5723.68,760.00,6551.20,827.52,'2023-01-14 19:00:50'),(688,'1','307',1,'Retail Sale Id 691',0.00,24900.00,760.00,28500.00,3600.00,'2023-01-14 19:03:26'),(689,'1','307',1,'Retail Sale Id 692',0.00,152.72,760.00,174.80,22.08,'2023-01-14 19:12:20'),(690,'1','307',1,'Retail Sale Id 693',0.00,1746.32,760.00,1998.80,252.48,'2023-01-15 07:24:56'),(691,'1','307',1,'Retail Sale Id 694',0.00,3320.00,760.00,3800.00,480.00,'2023-01-15 08:01:46'),(692,'1','307',1,'Retail Sale Id 695',0.00,1328.00,760.00,1520.00,192.00,'2023-01-15 08:11:03'),(693,'1','307',1,'Retail Sale Id 696',0.00,876.48,760.00,1003.20,126.72,'2023-01-15 09:07:56'),(694,'1','307',1,'Retail Sale Id 697',0.00,1308.08,760.00,1497.20,189.12,'2023-01-15 09:10:07'),(695,'1','307',1,'Retail Sale Id 698',0.00,1573.68,760.00,1801.20,227.52,'2023-01-15 09:28:26'),(696,'1','307',1,'Retail Sale Id 699',0.00,657.36,760.00,752.40,95.04,'2023-01-15 09:35:25'),(697,'1','307',1,'Retail Sale Id 700',0.00,1354.56,760.00,1550.40,195.84,'2023-01-15 10:04:26'),(698,'1','307',1,'Retail Sale Id 701',0.00,1992.00,760.00,2280.00,288.00,'2023-01-15 10:17:46'),(699,'1','307',1,'Retail Sale Id 701',0.00,1992.00,760.00,2280.00,288.00,'2023-01-15 10:17:46'),(700,'1','307',1,'Retail Sale Id 702',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-15 10:40:38'),(701,'1','307',1,'Retail Sale Id 703',0.00,2184.56,760.00,2500.40,315.84,'2023-01-15 10:41:46'),(702,'1','307',1,'Retail Sale Id 704',0.00,4017.20,760.00,4598.00,580.80,'2023-01-15 10:44:31'),(703,'1','307',1,'Retail Sale Id 705',0.00,4369.12,760.00,5000.80,631.68,'2023-01-15 11:11:15'),(704,'1','307',1,'Retail Sale Id 706',0.00,664.00,760.00,760.00,96.00,'2023-01-15 11:13:51'),(705,'1','307',1,'Retail Sale Id 707',0.00,3984.00,760.00,4560.00,576.00,'2023-01-15 11:26:28'),(706,'1','307',1,'Retail Sale Id 708',0.00,2011.92,760.00,2302.80,290.88,'2023-01-15 11:35:44'),(707,'1','307',1,'Retail Sale Id 710',0.00,6640.00,760.00,7600.00,960.00,'2023-01-15 11:49:50'),(708,'1','307',1,'Retail Sale Id 711',0.00,1992.00,760.00,2280.00,288.00,'2023-01-15 12:27:28'),(709,'1','307',1,'Retail Sale Id 712',0.00,1354.56,760.00,1550.40,195.84,'2023-01-15 12:31:51'),(710,'1','307',1,'Retail Sale Id 713',0.00,2011.92,760.00,2302.80,290.88,'2023-01-15 13:00:16'),(711,'1','307',1,'Retail Sale Id 714',0.00,876.48,760.00,1003.20,126.72,'2023-01-15 13:15:58'),(712,'1','307',1,'Retail Sale Id 715',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-15 13:17:46'),(713,'1','307',1,'Retail Sale Id 716',0.00,2622.80,760.00,3002.00,379.20,'2023-01-15 13:27:10'),(714,'1','307',1,'Retail Sale Id 717',0.00,6640.00,760.00,7600.00,960.00,'2023-01-15 13:33:02'),(715,'1','307',1,'Retail Sale Id 718',0.00,1328.00,760.00,1520.00,192.00,'2023-01-15 13:51:01'),(716,'1','307',1,'Retail Sale Id 719',0.00,3984.00,760.00,4560.00,576.00,'2023-01-15 13:52:29'),(717,'1','307',1,'Retail Sale Id 720',0.00,2656.00,760.00,3040.00,384.00,'2023-01-15 13:54:17'),(718,'1','307',1,'Retail Sale Id 722',0.00,4017.20,760.00,4598.00,580.80,'2023-01-15 13:56:14'),(719,'1','307',1,'Retail Sale Id 723',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-15 14:04:13'),(720,'1','307',1,'Retail Sale Id 724',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-15 14:24:20'),(721,'1','307',1,'Retail Sale Id 725',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-15 14:41:02'),(722,'1','307',1,'Retail Sale Id 726',0.00,1992.00,760.00,2280.00,288.00,'2023-01-15 14:43:21'),(723,'1','307',1,'Retail Sale Id 726',0.00,2656.00,760.00,3040.00,384.00,'2023-01-15 14:43:21'),(724,'1','307',1,'Retail Sale Id 727',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-15 15:23:57'),(725,'1','307',1,'Retail Sale Id 728',0.00,697.20,760.00,798.00,100.80,'2023-01-15 15:25:56'),(726,'1','307',1,'Retail Sale Id 729',0.00,2709.12,760.00,3100.80,391.68,'2023-01-15 15:28:43'),(727,'1','307',1,'Retail Sale Id 730',0.00,2656.00,760.00,3040.00,384.00,'2023-01-15 15:39:45'),(728,'1','307',1,'Retail Sale Id 731',0.00,3320.00,760.00,3800.00,480.00,'2023-01-15 15:46:29'),(729,'1','307',1,'Retail Sale Id 732',0.00,2662.64,760.00,3047.60,384.96,'2023-01-15 16:15:11'),(730,'1','307',1,'Retail Sale Id 733',0.00,2011.92,760.00,2302.80,290.88,'2023-01-15 16:19:52'),(731,'1','307',1,'Retail Sale Id 734',0.00,1328.00,760.00,1520.00,192.00,'2023-01-15 16:46:43'),(732,'1','307',1,'Retail Sale Id 735',0.00,3320.00,760.00,3800.00,480.00,'2023-01-15 16:48:39'),(733,'1','307',1,'Retail Sale Id 736',0.00,3320.00,760.00,3800.00,480.00,'2023-01-15 16:50:13'),(734,'1','307',1,'Retail Sale Id 737',0.00,2011.92,760.00,2302.80,290.88,'2023-01-15 16:55:05'),(735,'1','307',1,'Retail Sale Id 738',0.00,1746.32,760.00,1998.80,252.48,'2023-01-15 17:01:39'),(736,'1','307',1,'Retail Sale Id 739',0.00,1328.00,760.00,1520.00,192.00,'2023-01-15 17:05:36'),(737,'1','307',1,'Retail Sale Id 740',0.00,3320.00,760.00,3800.00,480.00,'2023-01-15 17:08:40'),(738,'1','307',1,'Retail Sale Id 741',0.00,4017.20,760.00,4598.00,580.80,'2023-01-15 17:10:31'),(739,'1','307',1,'Retail Sale Id 742',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-15 17:29:51'),(740,'1','307',1,'Retail Sale Id 743',0.00,2011.92,760.00,2302.80,290.88,'2023-01-15 17:34:26'),(741,'1','307',1,'Retail Sale Id 744',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-15 17:37:25'),(742,'1','307',1,'Retail Sale Id 745',0.00,2011.92,760.00,2302.80,290.88,'2023-01-15 17:48:34'),(743,'1','307',1,'Retail Sale Id 746',0.00,3984.00,760.00,4560.00,576.00,'2023-01-15 17:52:36'),(744,'1','307',1,'Retail Sale Id 747',0.00,3984.00,760.00,4560.00,576.00,'2023-01-15 17:54:07'),(745,'1','307',1,'Retail Sale Id 748',0.00,2622.80,760.00,3002.00,379.20,'2023-01-15 17:57:57'),(746,'1','307',1,'Retail Sale Id 749',0.00,1308.08,760.00,1497.20,189.12,'2023-01-15 18:02:49'),(747,'1','307',1,'Retail Sale Id 750',0.00,3320.00,760.00,3800.00,480.00,'2023-01-15 18:28:19'),(748,'1','307',1,'Retail Sale Id 751',0.00,1354.56,760.00,1550.40,195.84,'2023-01-15 18:29:50'),(749,'1','307',1,'Retail Sale Id 752',0.00,1746.32,760.00,1998.80,252.48,'2023-01-15 18:38:20'),(750,'1','307',1,'Retail Sale Id 753',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-15 18:43:51'),(751,'1','307',1,'Retail Sale Id 754',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-15 18:54:16'),(752,'1','307',1,'Retail Sale Id 755',0.00,1965.44,760.00,2249.60,284.16,'2023-01-15 18:58:46'),(753,'1','307',1,'Retail Sale Id 756',0.00,4043.76,760.00,4628.40,584.64,'2023-01-15 19:04:42'),(754,'1','307',1,'Return of Retail Sale Id 713',2011.92,0.00,760.00,-2302.80,-290.88,'2023-01-15 19:11:58'),(755,'1','307',1,'Retail Sale Id 757',0.00,4017.20,760.00,4598.00,580.80,'2023-01-16 07:42:40'),(756,'1','307',1,'Retail Sale Id 759',0.00,83000.00,710.00,88750.00,5750.00,'2023-01-16 08:16:55'),(757,'1','307',1,'Retail Sale Id 760',0.00,1328.00,760.00,1520.00,192.00,'2023-01-16 08:34:34'),(758,'1','307',1,'Retail Sale Id 761',0.00,3984.00,760.00,4560.00,576.00,'2023-01-16 08:37:47'),(759,'1','307',1,'Retail Sale Id 763',0.00,2662.64,760.00,3047.60,384.96,'2023-01-16 09:06:03'),(760,'1','307',1,'Retail Sale Id 764',0.00,1328.00,760.00,1520.00,192.00,'2023-01-16 09:07:30'),(761,'1','307',1,'Retail Sale Id 765',0.00,2656.00,760.00,3040.00,384.00,'2023-01-16 10:03:40'),(762,'1','307',1,'Retail Sale Id 766',0.00,4017.20,760.00,4598.00,580.80,'2023-01-16 10:22:45'),(763,'1','307',1,'Retail Sale Id 767',0.00,5312.00,760.00,6080.00,768.00,'2023-01-16 10:24:32'),(764,'1','307',1,'Retail Sale Id 768',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-16 10:46:17'),(765,'1','307',1,'Retail Sale Id 769',0.00,8300.00,760.00,9500.00,1200.00,'2023-01-16 10:47:27'),(766,'1','307',1,'Retail Sale Id 770',0.00,1328.00,760.00,1520.00,192.00,'2023-01-16 11:26:26'),(767,'1','307',1,'Retail Sale Id 771',0.00,1328.00,740.00,1480.00,152.00,'2023-01-16 12:10:28'),(768,'1','307',1,'Retail Sale Id 772',0.00,3990.64,740.00,4447.40,456.76,'2023-01-16 12:19:01'),(769,'1','307',1,'Retail Sale Id 773',0.00,1347.92,740.00,1502.20,154.28,'2023-01-16 13:37:09'),(770,'1','307',1,'Retail Sale Id 774',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-16 13:59:19'),(771,'1','307',1,'Retail Sale Id 775',0.00,8300.00,740.00,9250.00,950.00,'2023-01-16 14:01:08'),(772,'1','307',1,'Retail Sale Id 776',0.00,1347.92,740.00,1502.20,154.28,'2023-01-16 14:19:51'),(773,'1','307',1,'Retail Sale Id 777',0.00,3990.64,740.00,4447.40,456.76,'2023-01-16 14:22:20'),(774,'1','307',1,'Retail Sale Id 778',0.00,2018.56,740.00,2249.60,231.04,'2023-01-16 14:36:36'),(775,'1','307',1,'Retail Sale Id 779',0.00,896.40,740.00,999.00,102.60,'2023-01-16 14:47:25'),(776,'1','307',1,'Retail Sale Id 780',0.00,3320.00,740.00,3700.00,380.00,'2023-01-16 14:50:03'),(777,'1','307',1,'Retail Sale Id 781',0.00,3990.64,740.00,4447.40,456.76,'2023-01-16 14:56:21'),(778,'1','307',1,'Retail Sale Id 782',0.00,1347.92,740.00,1502.20,154.28,'2023-01-16 14:58:20'),(779,'1','307',1,'Retail Sale Id 783',0.00,2018.56,740.00,2249.60,231.04,'2023-01-16 15:09:45'),(780,'1','307',1,'Retail Sale Id 784',0.00,2018.56,740.00,2249.60,231.04,'2023-01-16 15:30:53'),(781,'1','307',1,'Retail Sale Id 785',0.00,2689.20,740.00,2997.00,307.80,'2023-01-16 15:32:18'),(782,'1','307',1,'Retail Sale Id 786',0.00,3320.00,740.00,3700.00,380.00,'2023-01-16 15:50:51'),(783,'1','307',1,'Retail Sale Id 787',0.00,670.64,740.00,747.40,76.76,'2023-01-16 16:31:02'),(784,'1','307',1,'Retail Sale Id 788',0.00,664.00,740.00,740.00,76.00,'2023-01-16 16:52:31'),(785,'1','307',1,'Retail Sale Id 788',0.00,664.00,740.00,740.00,76.00,'2023-01-16 16:52:31'),(786,'1','307',1,'Retail Sale Id 789',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-16 17:05:09'),(787,'1','307',1,'Retail Sale Id 790',0.00,3320.00,740.00,3700.00,380.00,'2023-01-16 17:13:32'),(788,'1','307',1,'Retail Sale Id 791',0.00,1972.08,740.00,2197.80,225.72,'2023-01-16 17:14:54'),(789,'1','307',1,'Retail Sale Id 792',0.00,2656.00,740.00,2960.00,304.00,'2023-01-16 17:20:54'),(790,'1','307',1,'Retail Sale Id 793',0.00,3990.64,740.00,4447.40,456.76,'2023-01-16 17:22:26'),(791,'1','307',1,'Retail Sale Id 794',0.00,1792.80,740.00,1998.00,205.20,'2023-01-16 17:30:18'),(792,'1','307',1,'Retail Sale Id 795',0.00,8300.00,740.00,9250.00,950.00,'2023-01-16 17:50:24'),(793,'1','307',1,'Retail Sale Id 796',0.00,2018.56,740.00,2249.60,231.04,'2023-01-16 18:10:40'),(794,'1','307',1,'Retail Sale Id 797',0.00,3320.00,740.00,3700.00,380.00,'2023-01-16 18:12:18'),(795,'1','307',1,'Retail Sale Id 798',0.00,2656.00,740.00,2960.00,304.00,'2023-01-16 18:22:24'),(796,'1','307',1,'Retail Sale Id 799',0.00,2656.00,740.00,2960.00,304.00,'2023-01-16 18:31:22'),(797,'1','307',1,'Retail Sale Id 800',0.00,1328.00,740.00,1480.00,152.00,'2023-01-16 18:59:27'),(798,'1','307',1,'Return of Retail Sale Id 800',1328.00,0.00,740.00,-1480.00,-152.00,'2023-01-16 19:06:47'),(799,'1','307',1,'Retail Sale Id 801',0.00,3990.64,740.00,4447.40,456.76,'2023-01-17 08:22:45'),(800,'1','307',1,'Retail Sale Id 802',0.00,3990.64,740.00,4447.40,456.76,'2023-01-17 08:34:25'),(801,'1','307',1,'Retail Sale Id 803',0.00,1792.80,740.00,1998.00,205.20,'2023-01-17 08:54:33'),(802,'1','307',1,'Retail Sale Id 804',0.00,4037.12,740.00,4499.20,462.08,'2023-01-17 08:55:28'),(803,'1','307',1,'Retail Sale Id 805',0.00,2065.04,740.00,2301.40,236.36,'2023-01-17 08:57:03'),(804,'1','307',1,'Retail Sale Id 806',0.00,3990.64,740.00,4447.40,456.76,'2023-01-17 09:00:57'),(805,'1','307',1,'Retail Sale Id 807',0.00,3990.64,740.00,4447.40,456.76,'2023-01-17 09:02:44'),(806,'1','307',1,'Retail Sale Id 808',0.00,2689.20,740.00,2997.00,307.80,'2023-01-17 09:21:11'),(807,'1','307',1,'Retail Sale Id 809',0.00,3990.64,740.00,4447.40,456.76,'2023-01-17 09:24:51'),(808,'1','307',1,'Retail Sale Id 810',0.00,2689.20,740.00,2997.00,307.80,'2023-01-17 09:29:24'),(809,'1','307',1,'Retail Sale Id 811',0.00,3990.64,740.00,4447.40,456.76,'2023-01-17 09:34:55'),(810,'1','307',1,'Retail Sale Id 812',0.00,2018.56,740.00,2249.60,231.04,'2023-01-17 09:45:00'),(811,'1','307',1,'Retail Sale Id 813',0.00,3320.00,740.00,3700.00,380.00,'2023-01-17 10:17:13'),(812,'1','307',1,'Retail Sale Id 814',0.00,8300.00,740.00,9250.00,950.00,'2023-01-17 10:18:54'),(813,'1','307',1,'Retail Sale Id 815',0.00,3990.64,740.00,4447.40,456.76,'2023-01-17 10:33:59'),(814,'1','307',1,'Retail Sale Id 816',0.00,6640.00,740.00,7400.00,760.00,'2023-01-17 10:45:17'),(815,'1','307',1,'Retail Sale Id 817',0.00,664.00,740.00,740.00,76.00,'2023-01-17 10:55:24'),(816,'1','307',1,'Retail Sale Id 818',0.00,1985.36,740.00,2212.60,227.24,'2023-01-17 10:59:04'),(817,'1','307',1,'Retail Sale Id 819',0.00,2018.56,740.00,2249.60,231.04,'2023-01-17 11:25:26'),(818,'1','307',1,'Retail Sale Id 820',0.00,3990.64,740.00,4447.40,456.76,'2023-01-17 11:28:48'),(819,'1','307',1,'Retail Sale Id 821',0.00,664.00,740.00,740.00,76.00,'2023-01-17 12:18:58'),(820,'1','307',1,'Retail Sale Id 822',0.00,8300.00,740.00,9250.00,950.00,'2023-01-17 12:19:51'),(821,'1','307',1,'Retail Sale Id 823',0.00,3320.00,740.00,3700.00,380.00,'2023-01-17 12:34:05'),(822,'1','307',1,'Retail Sale Id 824',0.00,83000.00,710.00,88750.00,5750.00,'2023-01-17 12:55:12'),(823,'1','307',1,'Retail Sale Id 825',0.00,8300.00,740.00,9250.00,950.00,'2023-01-17 13:10:32'),(824,'1','307',1,'Retail Sale Id 826',0.00,2018.56,740.00,2249.60,231.04,'2023-01-17 13:22:05'),(825,'1','307',1,'Retail Sale Id 827',0.00,1328.00,740.00,1480.00,152.00,'2023-01-17 13:55:49'),(826,'1','307',1,'Retail Sale Id 828',0.00,3320.00,740.00,3700.00,380.00,'2023-01-17 14:21:42'),(827,'1','307',1,'Retail Sale Id 828',0.00,3320.00,740.00,3700.00,380.00,'2023-01-17 14:21:42'),(828,'1','307',1,'Retail Sale Id 829',0.00,2656.00,740.00,2960.00,304.00,'2023-01-17 14:24:29'),(829,'1','307',1,'Retail Sale Id 830',0.00,3984.00,740.00,4440.00,456.00,'2023-01-17 15:41:29'),(830,'1','307',1,'Retail Sale Id 831',0.00,6640.00,740.00,7400.00,760.00,'2023-01-17 16:13:02'),(831,'1','307',1,'Retail Sale Id 832',0.00,2018.56,740.00,2249.60,231.04,'2023-01-17 16:16:25'),(832,'1','307',1,'Retail Sale Id 833',0.00,451.52,740.00,503.20,51.68,'2023-01-17 16:19:58'),(833,'1','307',1,'Retail Sale Id 834',0.00,1347.92,740.00,1502.20,154.28,'2023-01-17 16:31:31'),(834,'1','307',1,'Retail Sale Id 835',0.00,2018.56,740.00,2249.60,231.04,'2023-01-17 17:12:35'),(835,'1','307',1,'Retail Sale Id 836',0.00,1992.00,740.00,2220.00,228.00,'2023-01-17 17:17:33'),(836,'1','307',1,'Retail Sale Id 837',0.00,3984.00,740.00,4440.00,456.00,'2023-01-17 17:19:32'),(837,'1','307',1,'Retail Sale Id 837',0.00,3984.00,740.00,4440.00,456.00,'2023-01-17 17:19:32'),(838,'1','307',1,'Retail Sale Id 838',0.00,1347.92,740.00,1502.20,154.28,'2023-01-17 17:21:17'),(839,'1','307',1,'Retail Sale Id 839',0.00,1992.00,740.00,2220.00,228.00,'2023-01-17 17:24:53'),(840,'1','307',1,'Retail Sale Id 840',0.00,670.64,740.00,747.40,76.76,'2023-01-17 17:38:08'),(841,'1','307',1,'Retail Sale Id 841',0.00,1992.00,740.00,2220.00,228.00,'2023-01-17 17:39:16'),(842,'1','307',1,'Retail Sale Id 842',0.00,4488.64,740.00,5002.40,513.76,'2023-01-17 17:45:30'),(843,'1','307',1,'Retail Sale Id 843',0.00,3990.64,740.00,4447.40,456.76,'2023-01-17 17:51:59'),(844,'1','307',1,'Retail Sale Id 844',0.00,670.64,740.00,747.40,76.76,'2023-01-17 18:04:02'),(845,'1','307',1,'Retail Sale Id 845',0.00,1992.00,740.00,2220.00,228.00,'2023-01-17 18:12:18'),(846,'1','307',1,'Retail Sale Id 846',0.00,3671.92,740.00,4092.20,420.28,'2023-01-17 18:56:24'),(847,'1','307',1,'Retail Sale Id 847',0.00,3990.64,740.00,4447.40,456.76,'2023-01-18 07:32:07'),(848,'1','307',1,'Retail Sale Id 848',0.00,3320.00,740.00,3700.00,380.00,'2023-01-18 08:15:01'),(849,'1','307',1,'Retail Sale Id 849',0.00,4037.12,740.00,4499.20,462.08,'2023-01-18 08:22:22'),(850,'1','307',1,'Retail Sale Id 850',0.00,3990.64,740.00,4447.40,456.76,'2023-01-18 08:29:37'),(851,'1','307',1,'Retail Sale Id 851',0.00,2689.20,740.00,2997.00,307.80,'2023-01-18 09:26:44'),(852,'1','307',1,'Retail Sale Id 852',0.00,3320.00,740.00,3700.00,380.00,'2023-01-18 09:29:06'),(853,'1','307',1,'Retail Sale Id 853',0.00,2065.04,740.00,2301.40,236.36,'2023-01-18 09:36:51'),(854,'1','307',1,'Retail Sale Id 854',0.00,2689.20,740.00,2997.00,307.80,'2023-01-18 09:49:38'),(855,'1','307',1,'Retail Sale Id 855',0.00,3320.00,740.00,3700.00,380.00,'2023-01-18 10:15:13'),(856,'1','307',1,'Retail Sale Id 856',0.00,3592.24,740.00,4003.40,411.16,'2023-01-18 10:21:08'),(857,'1','307',1,'Retail Sale Id 857',0.00,8300.00,740.00,9250.00,950.00,'2023-01-18 10:38:07'),(858,'1','307',1,'Retail Sale Id 858',0.00,1992.00,740.00,2220.00,228.00,'2023-01-18 10:47:43'),(859,'1','307',1,'Retail Sale Id 859',0.00,3984.00,740.00,4440.00,456.00,'2023-01-18 10:53:39'),(860,'1','307',1,'Retail Sale Id 860',0.00,4037.12,740.00,4499.20,462.08,'2023-01-18 11:03:50'),(861,'1','307',1,'Retail Sale Id 861',0.00,1992.00,740.00,2220.00,228.00,'2023-01-18 11:08:03'),(862,'1','307',1,'Retail Sale Id 862',0.00,1328.00,740.00,1480.00,152.00,'2023-01-18 11:09:45'),(863,'1','307',1,'Retail Sale Id 863',0.00,1992.00,740.00,2220.00,228.00,'2023-01-18 11:10:55'),(864,'1','307',1,'Retail Sale Id 864',0.00,4037.12,740.00,4499.20,462.08,'2023-01-18 11:22:53'),(865,'1','307',1,'Retail Sale Id 865',0.00,8300.00,740.00,9250.00,950.00,'2023-01-18 11:27:58'),(866,'1','307',1,'Retail Sale Id 866',0.00,2689.20,740.00,2997.00,307.80,'2023-01-18 11:29:06'),(867,'1','307',1,'Retail Sale Id 867',0.00,3984.00,740.00,4440.00,456.00,'2023-01-18 11:34:48'),(868,'1','307',1,'Retail Sale Id 868',0.00,1992.00,740.00,2220.00,228.00,'2023-01-18 11:51:30'),(869,'1','307',1,'Retail Sale Id 869',0.00,4037.12,740.00,4499.20,462.08,'2023-01-18 12:10:42'),(870,'1','307',1,'Retail Sale Id 870',0.00,2065.04,740.00,2301.40,236.36,'2023-01-18 12:14:12'),(871,'1','307',1,'Retail Sale Id 871',0.00,2656.00,740.00,2960.00,304.00,'2023-01-18 12:22:34'),(872,'1','307',1,'Retail Sale Id 872',0.00,3320.00,740.00,3700.00,380.00,'2023-01-18 13:04:53'),(873,'1','307',1,'Retail Sale Id 873',0.00,2018.56,740.00,2249.60,231.04,'2023-01-18 13:53:41'),(874,'1','307',1,'Retail Sale Id 874',0.00,2018.56,740.00,2249.60,231.04,'2023-01-18 14:48:21'),(875,'1','307',1,'Retail Sale Id 875',0.00,717.12,740.00,799.20,82.08,'2023-01-18 15:22:12'),(876,'1','307',1,'Retail Sale Id 876',0.00,3320.00,740.00,3700.00,380.00,'2023-01-18 15:38:46'),(877,'1','307',1,'Retail Sale Id 877',0.00,3990.64,740.00,4447.40,456.76,'2023-01-18 15:45:17'),(878,'1','307',1,'Retail Sale Id 878',0.00,1792.80,740.00,1998.00,205.20,'2023-01-18 16:08:55'),(879,'1','307',1,'Retail Sale Id 879',0.00,3320.00,740.00,3700.00,380.00,'2023-01-18 16:11:03'),(880,'1','307',1,'Retail Sale Id 880',0.00,2782.16,740.00,3100.60,318.44,'2023-01-18 16:13:00'),(881,'1','307',1,'Retail Sale Id 881',0.00,2018.56,740.00,2249.60,231.04,'2023-01-18 16:20:32'),(882,'1','307',1,'Retail Sale Id 882',0.00,3320.00,740.00,3700.00,380.00,'2023-01-18 16:33:21'),(883,'1','307',1,'Retail Sale Id 883',0.00,3984.00,740.00,4440.00,456.00,'2023-01-18 16:43:32'),(884,'1','307',1,'Retail Sale Id 884',0.00,1347.92,740.00,1502.20,154.28,'2023-01-18 16:46:25'),(885,'1','307',1,'Retail Sale Id 885',0.00,1328.00,740.00,1480.00,152.00,'2023-01-18 17:05:09'),(886,'1','307',1,'Retail Sale Id 886',0.00,664.00,740.00,740.00,76.00,'2023-01-18 17:08:42'),(887,'1','307',1,'Retail Sale Id 886',0.00,664.00,740.00,740.00,76.00,'2023-01-18 17:08:42'),(888,'1','307',1,'Retail Sale Id 887',0.00,3990.64,740.00,4447.40,456.76,'2023-01-18 17:23:01'),(889,'1','307',1,'Retail Sale Id 888',0.00,3990.64,740.00,4447.40,456.76,'2023-01-18 17:27:06'),(890,'1','307',1,'Retail Sale Id 889',0.00,1347.92,740.00,1502.20,154.28,'2023-01-18 17:28:23'),(891,'1','307',1,'Retail Sale Id 890',0.00,1328.00,740.00,1480.00,152.00,'2023-01-18 17:33:22'),(892,'1','307',1,'Retail Sale Id 891',0.00,2244.32,740.00,2501.20,256.88,'2023-01-18 17:36:13'),(893,'1','307',1,'Retail Sale Id 892',0.00,4037.12,740.00,4499.20,462.08,'2023-01-18 17:42:42'),(894,'1','307',1,'Retail Sale Id 893',0.00,8300.00,740.00,9250.00,950.00,'2023-01-18 17:48:21'),(895,'1','307',1,'Retail Sale Id 894',0.00,1792.80,740.00,1998.00,205.20,'2023-01-18 18:08:39'),(896,'1','307',1,'Retail Sale Id 894',0.00,2689.20,740.00,2997.00,307.80,'2023-01-18 18:08:39'),(897,'1','307',1,'Retail Sale Id 896',0.00,4488.64,740.00,5002.40,513.76,'2023-01-18 18:10:58'),(898,'1','307',1,'Retail Sale Id 897',0.00,5385.04,740.00,6001.40,616.36,'2023-01-18 18:25:40'),(899,'1','307',1,'Retail Sale Id 898',0.00,3140.72,740.00,3500.20,359.48,'2023-01-18 18:27:39'),(900,'1','307',1,'Retail Sale Id 899',0.00,6640.00,740.00,7400.00,760.00,'2023-01-18 18:28:58'),(901,'1','307',1,'Retail Sale Id 900',0.00,2244.32,740.00,2501.20,256.88,'2023-01-18 18:51:49'),(902,'1','307',1,'Retail Sale Id 901',0.00,8100.80,740.00,9028.00,927.20,'2023-01-18 18:57:30'),(903,'1','307',1,'Retail Sale Id 902',0.00,4037.12,740.00,4499.20,462.08,'2023-01-19 08:09:17'),(904,'1','307',1,'Retail Sale Id 903',0.00,4037.12,740.00,4499.20,462.08,'2023-01-19 08:12:28'),(905,'1','307',1,'Retail Sale Id 904',0.00,5312.00,740.00,5920.00,608.00,'2023-01-19 08:14:57'),(906,'1','307',1,'Retail Sale Id 905',0.00,896.40,740.00,999.00,102.60,'2023-01-19 08:36:02'),(907,'1','307',1,'Retail Sale Id 906',0.00,2018.56,740.00,2249.60,231.04,'2023-01-19 08:39:26'),(908,'1','307',1,'Retail Sale Id 907',0.00,8300.00,740.00,9250.00,950.00,'2023-01-19 08:44:21'),(909,'1','307',1,'Retail Sale Id 908',0.00,2018.56,740.00,2249.60,231.04,'2023-01-19 08:46:51'),(910,'1','307',1,'Retail Sale Id 909',0.00,1972.08,740.00,2197.80,225.72,'2023-01-19 08:54:43'),(911,'1','307',1,'Retail Sale Id 910',0.00,3984.00,740.00,4440.00,456.00,'2023-01-19 09:22:20'),(912,'1','307',1,'Retail Sale Id 911',0.00,7177.84,740.00,7999.40,821.56,'2023-01-19 09:33:23'),(913,'1','307',1,'Retail Sale Id 912',0.00,6732.96,740.00,7503.60,770.64,'2023-01-19 09:33:58'),(914,'1','307',1,'Retail Sale Id 913',0.00,3320.00,740.00,3700.00,380.00,'2023-01-19 09:40:37'),(915,'1','307',1,'Retail Sale Id 913',0.00,8300.00,740.00,9250.00,950.00,'2023-01-19 09:40:37'),(916,'1','307',1,'Retail Sale Id 914',0.00,6640.00,740.00,7400.00,760.00,'2023-01-19 09:42:48'),(917,'1','307',1,'Retail Sale Id 915',0.00,3320.00,740.00,3700.00,380.00,'2023-01-19 10:28:28'),(918,'1','307',1,'Retail Sale Id 917',0.00,3964.08,740.00,4417.80,453.72,'2023-01-19 10:37:04'),(919,'1','307',1,'Retail Sale Id 918',0.00,3984.00,740.00,4440.00,456.00,'2023-01-19 11:36:15'),(920,'1','307',1,'Retail Sale Id 919',0.00,1347.92,740.00,1502.20,154.28,'2023-01-19 11:52:11'),(921,'1','307',1,'Retail Sale Id 920',0.00,1792.80,740.00,1998.00,205.20,'2023-01-19 12:32:07'),(922,'1','307',1,'Retail Sale Id 921',0.00,3320.00,740.00,3700.00,380.00,'2023-01-19 12:33:18'),(923,'1','307',1,'Retail Sale Id 922',0.00,3320.00,740.00,3700.00,380.00,'2023-01-19 12:34:59'),(924,'1','307',1,'Retail Sale Id 923',0.00,1347.92,740.00,1502.20,154.28,'2023-01-19 12:36:33'),(925,'1','307',1,'Retail Sale Id 924',0.00,3990.64,740.00,4447.40,456.76,'2023-01-19 13:37:14'),(926,'1','307',1,'Retail Sale Id 925',0.00,2018.56,740.00,2249.60,231.04,'2023-01-19 13:49:28'),(927,'1','307',1,'Retail Sale Id 926',0.00,1972.08,740.00,2197.80,225.72,'2023-01-19 13:53:33'),(928,'1','307',1,'Retail Sale Id 927',0.00,2018.56,740.00,2249.60,231.04,'2023-01-19 13:56:22'),(929,'1','307',1,'Retail Sale Id 928',0.00,2065.04,740.00,2301.40,236.36,'2023-01-19 14:36:19'),(930,'1','307',1,'Retail Sale Id 928',0.00,6640.00,740.00,7400.00,760.00,'2023-01-19 14:36:19'),(931,'1','307',1,'Retail Sale Id 929',0.00,3990.64,740.00,4447.40,456.76,'2023-01-19 14:49:53'),(932,'1','307',1,'Retail Sale Id 930',0.00,3320.00,740.00,3700.00,380.00,'2023-01-19 15:04:49'),(933,'1','307',1,'Retail Sale Id 931',0.00,5312.00,740.00,5920.00,608.00,'2023-01-19 15:29:09'),(934,'1','307',1,'Retail Sale Id 932',0.00,4488.64,740.00,5002.40,513.76,'2023-01-19 16:05:09'),(935,'1','307',1,'Retail Sale Id 933',0.00,1347.92,740.00,1502.20,154.28,'2023-01-19 16:37:53'),(936,'1','307',1,'Retail Sale Id 934',0.00,8300.00,740.00,9250.00,950.00,'2023-01-19 16:52:17'),(937,'1','307',1,'Retail Sale Id 935',0.00,83000.00,710.00,88750.00,5750.00,'2023-01-19 16:57:28'),(938,'1','307',1,'Retail Sale Id 936',0.00,2656.00,740.00,2960.00,304.00,'2023-01-19 16:59:16'),(939,'1','307',1,'Retail Sale Id 937',0.00,4648.00,740.00,5180.00,532.00,'2023-01-19 17:12:12'),(940,'1','307',1,'Retail Sale Id 938',0.00,1347.92,740.00,1502.20,154.28,'2023-01-19 17:43:10'),(941,'1','307',1,'Retail Sale Id 939',0.00,2151.36,740.00,2397.60,246.24,'2023-01-19 17:49:38'),(942,'1','307',1,'Retail Sale Id 940',0.00,4037.12,740.00,4499.20,462.08,'2023-01-19 17:56:05'),(943,'1','307',1,'Retail Sale Id 941',0.00,2018.56,740.00,2249.60,231.04,'2023-01-19 18:02:23'),(944,'1','307',1,'Retail Sale Id 942',0.00,2018.56,740.00,2249.60,231.04,'2023-01-19 18:09:44'),(945,'1','307',1,'Retail Sale Id 943',0.00,1992.00,740.00,2220.00,228.00,'2023-01-19 18:10:57'),(946,'1','307',1,'Retail Sale Id 944',0.00,3984.00,740.00,4440.00,456.00,'2023-01-19 18:12:44'),(947,'1','307',1,'Retail Sale Id 945',0.00,1972.08,740.00,2197.80,225.72,'2023-01-19 18:14:37'),(948,'1','307',1,'Retail Sale Id 946',0.00,3984.00,740.00,4440.00,456.00,'2023-01-19 18:17:35'),(949,'1','307',1,'Retail Sale Id 947',0.00,3320.00,740.00,3700.00,380.00,'2023-01-19 18:26:01'),(950,'1','307',1,'Retail Sale Id 947',0.00,3984.00,740.00,4440.00,456.00,'2023-01-19 18:26:01'),(951,'1','307',1,'Retail Sale Id 948',0.00,8300.00,740.00,9250.00,950.00,'2023-01-19 18:28:31'),(952,'1','307',1,'Retail Sale Id 949',0.00,2689.20,740.00,2997.00,307.80,'2023-01-19 18:35:24'),(953,'1','307',1,'Retail Sale Id 950',0.00,3286.80,740.00,3663.00,376.20,'2023-01-19 19:00:29'),(954,'1','307',1,'Retail Sale Id 951',0.00,1792.80,740.00,1998.00,205.20,'2023-01-20 08:18:16'),(955,'1','307',1,'Retail Sale Id 952',0.00,4488.64,740.00,5002.40,513.76,'2023-01-20 08:57:02'),(956,'1','307',1,'Retail Sale Id 953',0.00,1347.92,740.00,1502.20,154.28,'2023-01-20 08:58:31'),(957,'1','307',1,'Retail Sale Id 954',0.00,3320.00,740.00,3700.00,380.00,'2023-01-20 09:19:57'),(958,'1','307',1,'Retail Sale Id 955',0.00,8300.00,740.00,9250.00,950.00,'2023-01-20 10:22:59'),(959,'1','307',1,'Retail Sale Id 956',0.00,3990.64,740.00,4447.40,456.76,'2023-01-20 10:46:58'),(960,'1','307',1,'Retail Sale Id 957',0.00,3990.64,740.00,4447.40,456.76,'2023-01-20 10:57:49'),(961,'1','307',1,'Retail Sale Id 958',0.00,2018.56,740.00,2249.60,231.04,'2023-01-20 11:02:14'),(962,'1','307',1,'Retail Sale Id 959',0.00,3990.64,740.00,4447.40,456.76,'2023-01-20 11:10:13'),(963,'1','307',1,'Retail Sale Id 960',0.00,1347.92,740.00,1502.20,154.28,'2023-01-20 11:11:34'),(964,'1','307',1,'Retail Sale Id 961',0.00,3320.00,740.00,3700.00,380.00,'2023-01-20 11:13:57'),(965,'1','307',1,'Retail Sale Id 962',0.00,670.64,740.00,747.40,76.76,'2023-01-20 11:16:16'),(966,'1','307',1,'Retail Sale Id 963',0.00,26181.52,710.00,27995.30,1813.78,'2023-01-20 11:30:29'),(967,'1','307',1,'Retail Sale Id 964',0.00,3320.00,740.00,3700.00,380.00,'2023-01-20 12:02:09'),(968,'1','307',1,'Retail Sale Id 965',0.00,2689.20,740.00,2997.00,307.80,'2023-01-20 12:13:39'),(969,'1','307',1,'Retail Sale Id 966',0.00,3320.00,740.00,3700.00,380.00,'2023-01-20 14:20:57'),(970,'1','307',1,'Retail Sale Id 967',0.00,2689.20,740.00,2997.00,307.80,'2023-01-20 15:41:07'),(971,'1','307',1,'Retail Sale Id 968',0.00,1347.92,740.00,1502.20,154.28,'2023-01-20 15:56:13'),(972,'1','307',1,'Retail Sale Id 969',0.00,4667.92,740.00,5202.20,534.28,'2023-01-20 16:18:03'),(973,'1','307',1,'Retail Sale Id 970',0.00,3984.00,740.00,4440.00,456.00,'2023-01-20 16:19:24'),(974,'1','307',1,'Retail Sale Id 971',0.00,1992.00,740.00,2220.00,228.00,'2023-01-20 16:21:38'),(975,'1','307',1,'Retail Sale Id 972',0.00,33200.00,710.00,35500.00,2300.00,'2023-01-20 16:26:05'),(976,'1','307',1,'Retail Sale Id 973',0.00,4488.64,740.00,5002.40,513.76,'2023-01-20 16:38:25'),(977,'1','307',1,'Retail Sale Id 974',0.00,6009.20,740.00,6697.00,687.80,'2023-01-20 16:40:29'),(978,'1','307',1,'Retail Sale Id 975',0.00,8300.00,740.00,9250.00,950.00,'2023-01-20 17:12:10'),(979,'1','307',1,'Retail Sale Id 976',0.00,3320.00,740.00,3700.00,380.00,'2023-01-20 17:21:09'),(980,'1','307',1,'Retail Sale Id 977',0.00,1992.00,740.00,2220.00,228.00,'2023-01-20 17:22:22'),(981,'1','307',1,'Retail Sale Id 978',0.00,2018.56,740.00,2249.60,231.04,'2023-01-20 17:23:34'),(982,'1','307',1,'Retail Sale Id 979',0.00,896.40,740.00,999.00,102.60,'2023-01-20 17:24:41'),(983,'1','307',1,'Retail Sale Id 980',0.00,670.64,740.00,747.40,76.76,'2023-01-20 17:32:15'),(984,'1','307',1,'Retail Sale Id 981',0.00,3320.00,740.00,3700.00,380.00,'2023-01-20 17:38:43'),(985,'1','307',1,'Retail Sale Id 982',0.00,664.00,740.00,740.00,76.00,'2023-01-20 17:42:17'),(986,'1','307',1,'Retail Sale Id 983',0.00,8300.00,740.00,9250.00,950.00,'2023-01-20 17:43:44'),(987,'1','307',1,'Retail Sale Id 984',0.00,1992.00,740.00,2220.00,228.00,'2023-01-20 18:10:14'),(988,'1','307',1,'Retail Sale Id 985',0.00,3984.00,740.00,4440.00,456.00,'2023-01-20 18:28:25'),(989,'1','307',1,'Retail Sale Id 986',0.00,3127.44,740.00,3485.40,357.96,'2023-01-20 18:57:13'),(990,'1','307',1,'Retail Sale Id 987',0.00,3990.64,740.00,4447.40,456.76,'2023-01-21 07:44:26'),(991,'1','307',1,'Retail Sale Id 988',0.00,1992.00,740.00,2220.00,228.00,'2023-01-21 07:55:58'),(992,'1','307',1,'Retail Sale Id 989',0.00,1792.80,740.00,1998.00,205.20,'2023-01-21 08:12:05'),(993,'1','307',1,'Retail Sale Id 990',0.00,1992.00,740.00,2220.00,228.00,'2023-01-21 08:15:43'),(994,'1','307',1,'Retail Sale Id 991',0.00,2689.20,740.00,2997.00,307.80,'2023-01-21 08:19:19'),(995,'1','307',1,'Retail Sale Id 992',0.00,8300.00,740.00,9250.00,950.00,'2023-01-21 08:35:24'),(996,'1','307',1,'Retail Sale Id 993',0.00,1992.00,740.00,2220.00,228.00,'2023-01-21 08:36:43'),(997,'1','307',1,'Retail Sale Id 994',0.00,2065.04,740.00,2301.40,236.36,'2023-01-21 08:48:18'),(998,'1','307',1,'Retail Sale Id 995',0.00,3990.64,740.00,4447.40,456.76,'2023-01-21 09:04:43'),(999,'1','307',1,'Retail Sale Id 996',0.00,1347.92,740.00,1502.20,154.28,'2023-01-21 09:06:11'),(1000,'1','307',1,'Retail Sale Id 997',0.00,2689.20,740.00,2997.00,307.80,'2023-01-21 09:15:44'),(1001,'1','307',1,'Retail Sale Id 998',0.00,1998.64,740.00,2227.40,228.76,'2023-01-21 09:21:19'),(1002,'1','307',1,'Retail Sale Id 999',0.00,1992.00,740.00,2220.00,228.00,'2023-01-21 09:33:59'),(1003,'1','307',1,'Retail Sale Id 1000',0.00,2656.00,740.00,2960.00,304.00,'2023-01-21 09:38:44'),(1004,'1','307',1,'Retail Sale Id 1001',0.00,3984.00,740.00,4440.00,456.00,'2023-01-21 09:57:48'),(1005,'1','307',1,'Retail Sale Id 1001',0.00,8300.00,740.00,9250.00,950.00,'2023-01-21 09:57:48'),(1006,'1','307',1,'Retail Sale Id 1002',0.00,1992.00,740.00,2220.00,228.00,'2023-01-21 10:12:45'),(1007,'1','307',1,'Retail Sale Id 1003',0.00,2244.32,740.00,2501.20,256.88,'2023-01-21 10:16:03'),(1008,'1','307',1,'Retail Sale Id 1004',0.00,6640.00,740.00,7400.00,760.00,'2023-01-21 10:37:03'),(1009,'1','307',1,'Retail Sale Id 1005',0.00,83000.00,710.00,88750.00,5750.00,'2023-01-21 10:52:13'),(1010,'1','307',1,'Retail Sale Id 1006',0.00,2689.20,740.00,2997.00,307.80,'2023-01-21 11:08:50'),(1011,'1','307',1,'Retail Sale Id 1007',0.00,8300.00,740.00,9250.00,950.00,'2023-01-21 11:30:13'),(1012,'1','307',1,'Retail Sale Id 1008',0.00,2689.20,740.00,2997.00,307.80,'2023-01-21 11:33:29'),(1013,'1','307',1,'Retail Sale Id 1009',0.00,1992.00,740.00,2220.00,228.00,'2023-01-21 11:58:27'),(1014,'1','307',1,'Retail Sale Id 1009',0.00,2656.00,740.00,2960.00,304.00,'2023-01-21 11:58:27'),(1015,'1','307',1,'Retail Sale Id 1010',0.00,12290.64,740.00,13697.40,1406.76,'2023-01-21 12:37:14'),(1016,'1','307',1,'Retail Sale Id 1011',0.00,1992.00,740.00,2220.00,228.00,'2023-01-21 12:47:26'),(1017,'1','307',1,'Retail Sale Id 1012',0.00,2018.56,740.00,2249.60,231.04,'2023-01-21 12:54:58'),(1018,'1','307',1,'Retail Sale Id 1013',0.00,10318.56,740.00,11499.60,1181.04,'2023-01-21 13:00:15'),(1019,'1','307',1,'Retail Sale Id 1014',0.00,3984.00,740.00,4440.00,456.00,'2023-01-21 13:31:40'),(1020,'1','307',1,'Retail Sale Id 1015',0.00,66400.00,710.00,71000.00,4600.00,'2023-01-21 13:33:34'),(1021,'1','307',1,'Retail Sale Id 1016',0.00,3320.00,740.00,3700.00,380.00,'2023-01-21 13:49:50'),(1022,'1','307',1,'Retail Sale Id 1017',0.00,2689.20,740.00,2997.00,307.80,'2023-01-21 13:51:20'),(1023,'1','307',1,'Retail Sale Id 1018',0.00,2656.00,740.00,2960.00,304.00,'2023-01-21 14:02:12'),(1024,'1','307',1,'Retail Sale Id 1019',0.00,8300.00,740.00,9250.00,950.00,'2023-01-21 14:13:46'),(1025,'1','307',1,'Retail Sale Id 1020',0.00,3320.00,740.00,3700.00,380.00,'2023-01-21 14:18:06'),(1026,'1','307',1,'Retail Sale Id 1021',0.00,670.64,740.00,747.40,76.76,'2023-01-21 14:18:56'),(1027,'1','307',1,'Retail Sale Id 1022',0.00,2018.56,740.00,2249.60,231.04,'2023-01-21 14:22:11'),(1028,'1','307',1,'Retail Sale Id 1023',0.00,2689.20,740.00,2997.00,307.80,'2023-01-21 14:28:20'),(1029,'1','307',1,'Retail Sale Id 1024',0.00,1347.92,740.00,1502.20,154.28,'2023-01-21 14:43:02'),(1030,'1','307',1,'Retail Sale Id 1025',0.00,2689.20,740.00,2997.00,307.80,'2023-01-21 14:50:14'),(1031,'1','307',1,'Retail Sale Id 1026',0.00,3990.64,740.00,4447.40,456.76,'2023-01-21 14:53:09'),(1032,'1','307',1,'Retail Sale Id 1027',0.00,2689.20,740.00,2997.00,307.80,'2023-01-21 14:56:08'),(1033,'1','307',1,'Retail Sale Id 1028',0.00,2018.56,740.00,2249.60,231.04,'2023-01-21 15:07:49'),(1034,'1','307',1,'Retail Sale Id 1029',0.00,3990.64,740.00,4447.40,456.76,'2023-01-21 15:09:22'),(1035,'1','307',1,'Retail Sale Id 1030',0.00,3990.64,740.00,4447.40,456.76,'2023-01-21 15:21:36'),(1036,'1','307',1,'Retail Sale Id 1031',0.00,670.64,740.00,747.40,76.76,'2023-01-21 15:23:14'),(1037,'1','307',1,'Retail Sale Id 1032',0.00,3990.64,740.00,4447.40,456.76,'2023-01-21 15:31:54'),(1038,'1','307',1,'Retail Sale Id 1033',0.00,2689.20,740.00,2997.00,307.80,'2023-01-21 15:35:40'),(1039,'1','307',1,'Retail Sale Id 1034',0.00,2244.32,740.00,2501.20,256.88,'2023-01-21 15:49:31'),(1040,'1','307',1,'Retail Sale Id 1035',0.00,1328.00,740.00,1480.00,152.00,'2023-01-21 15:59:28'),(1041,'1','307',1,'Retail Sale Id 1036',0.00,3990.64,740.00,4447.40,456.76,'2023-01-21 16:04:27'),(1042,'1','307',1,'Retail Sale Id 1037',0.00,1792.80,740.00,1998.00,205.20,'2023-01-21 16:24:43'),(1043,'1','307',1,'Retail Sale Id 1038',0.00,670.64,740.00,747.40,76.76,'2023-01-21 16:42:06'),(1044,'1','307',1,'Retail Sale Id 1039',0.00,8300.00,740.00,9250.00,950.00,'2023-01-21 16:43:14'),(1045,'1','307',1,'Retail Sale Id 1040',0.00,1347.92,740.00,1502.20,154.28,'2023-01-21 17:15:16'),(1046,'1','307',1,'Retail Sale Id 1041',0.00,6009.20,740.00,6697.00,687.80,'2023-01-21 17:17:48'),(1047,'1','307',1,'Retail Sale Id 1042',0.00,1992.00,740.00,2220.00,228.00,'2023-01-21 17:18:50'),(1048,'1','307',1,'Retail Sale Id 1043',0.00,2656.00,740.00,2960.00,304.00,'2023-01-21 17:21:10'),(1049,'1','307',1,'Retail Sale Id 1044',0.00,1992.00,740.00,2220.00,228.00,'2023-01-21 17:25:53'),(1050,'1','307',1,'Retail Sale Id 1045',0.00,3320.00,740.00,3700.00,380.00,'2023-01-21 17:37:38'),(1051,'1','307',1,'Retail Sale Id 1046',0.00,3990.64,740.00,4447.40,456.76,'2023-01-21 17:38:40'),(1052,'1','307',1,'Retail Sale Id 1047',0.00,8300.00,740.00,9250.00,950.00,'2023-01-21 17:45:21'),(1053,'1','307',1,'Retail Sale Id 1049',0.00,3984.00,740.00,4440.00,456.00,'2023-01-21 17:51:03'),(1054,'1','307',1,'Retail Sale Id 1050',0.00,1328.00,740.00,1480.00,152.00,'2023-01-21 17:51:52'),(1055,'1','307',1,'Retail Sale Id 1051',0.00,1347.92,740.00,1502.20,154.28,'2023-01-21 17:55:34'),(1056,'1','307',1,'Retail Sale Id 1052',0.00,2018.56,740.00,2249.60,231.04,'2023-01-21 17:58:28'),(1057,'1','307',1,'Retail Sale Id 1054',0.00,2018.56,740.00,2249.60,231.04,'2023-01-21 18:00:00'),(1058,'1','307',1,'Retail Sale Id 1055',0.00,2689.20,740.00,2997.00,307.80,'2023-01-21 18:13:02'),(1059,'1','307',1,'Retail Sale Id 1056',0.00,1347.92,740.00,1502.20,154.28,'2023-01-21 18:18:43'),(1060,'1','307',1,'Retail Sale Id 1057',0.00,8300.00,740.00,9250.00,950.00,'2023-01-21 18:32:48'),(1061,'1','307',1,'Retail Sale Id 1058',0.00,1347.92,740.00,1502.20,154.28,'2023-01-21 18:34:30'),(1062,'1','307',1,'Retail Sale Id 1059',0.00,6500.56,740.00,7244.60,744.04,'2023-01-21 18:57:38'),(1063,'1','307',1,'Return of Retail Sale Id 1045',3320.00,0.00,740.00,-3700.00,-380.00,'2023-01-21 19:02:23'),(1064,'1','307',1,'Retail Sale Id 1060',0.00,3990.64,740.00,4447.40,456.76,'2023-01-22 07:36:31'),(1065,'1','307',1,'Retail Sale Id 1061',0.00,3990.64,740.00,4447.40,456.76,'2023-01-22 07:37:44'),(1066,'1','307',1,'Retail Sale Id 1062',0.00,664.00,740.00,740.00,76.00,'2023-01-22 07:42:03'),(1067,'1','307',1,'Retail Sale Id 1063',0.00,4037.12,740.00,4499.20,462.08,'2023-01-22 08:05:57'),(1068,'1','307',1,'Retail Sale Id 1064',0.00,2689.20,740.00,2997.00,307.80,'2023-01-22 08:09:43'),(1069,'1','307',1,'Retail Sale Id 1065',0.00,3320.00,740.00,3700.00,380.00,'2023-01-22 08:14:14'),(1070,'1','307',1,'Retail Sale Id 1066',0.00,33200.00,700.00,35000.00,1800.00,'2023-01-22 08:19:38'),(1071,'1','307',1,'Retail Sale Id 1067',0.00,33200.00,700.00,35000.00,1800.00,'2023-01-22 08:21:09'),(1072,'1','307',1,'Retail Sale Id 1068',0.00,7310.64,740.00,8147.40,836.76,'2023-01-22 08:22:50'),(1073,'1','307',1,'Retail Sale Id 1069',0.00,2689.20,740.00,2997.00,307.80,'2023-01-22 08:41:21'),(1074,'1','307',1,'Retail Sale Id 1070',0.00,3984.00,740.00,4440.00,456.00,'2023-01-22 08:43:14'),(1075,'1','307',1,'Retail Sale Id 1071',0.00,99600.00,700.00,105000.00,5400.00,'2023-01-22 09:14:46'),(1076,'1','307',1,'Retail Sale Id 1072',0.00,1792.80,740.00,1998.00,205.20,'2023-01-22 09:19:49'),(1077,'1','307',1,'Retail Sale Id 1073',0.00,1992.00,740.00,2220.00,228.00,'2023-01-22 09:27:47'),(1078,'1','307',1,'Retail Sale Id 1074',0.00,1792.80,740.00,1998.00,205.20,'2023-01-22 09:35:53'),(1079,'1','307',1,'Retail Sale Id 1075',0.00,3990.64,740.00,4447.40,456.76,'2023-01-22 10:28:20'),(1080,'1','307',1,'Retail Sale Id 1076',0.00,3320.00,740.00,3700.00,380.00,'2023-01-22 10:30:11'),(1081,'1','307',1,'Retail Sale Id 1077',0.00,1328.00,740.00,1480.00,152.00,'2023-01-22 10:35:10'),(1082,'1','307',1,'Retail Sale Id 1078',0.00,3320.00,740.00,3700.00,380.00,'2023-01-22 10:51:04'),(1083,'1','307',1,'Retail Sale Id 1079',0.00,3990.64,740.00,4447.40,456.76,'2023-01-22 10:52:59'),(1084,'1','307',1,'Retail Sale Id 1080',0.00,3320.00,740.00,3700.00,380.00,'2023-01-22 10:54:17'),(1085,'1','307',1,'Retail Sale Id 1081',0.00,3984.00,740.00,4440.00,456.00,'2023-01-22 11:24:03'),(1086,'1','307',1,'Retail Sale Id 1082',0.00,3990.64,740.00,4447.40,456.76,'2023-01-22 12:14:44'),(1087,'1','307',1,'Retail Sale Id 1083',0.00,1347.92,740.00,1502.20,154.28,'2023-01-22 12:15:36'),(1088,'1','307',1,'Retail Sale Id 1084',0.00,1792.80,740.00,1998.00,205.20,'2023-01-22 12:26:55'),(1089,'1','307',1,'Retail Sale Id 1085',0.00,1992.00,740.00,2220.00,228.00,'2023-01-22 12:42:37'),(1090,'1','307',1,'Retail Sale Id 1086',0.00,2689.20,740.00,2997.00,307.80,'2023-01-22 12:52:22'),(1091,'1','307',1,'Retail Sale Id 1087',0.00,2065.04,740.00,2301.40,236.36,'2023-01-22 13:19:17'),(1092,'1','307',1,'Retail Sale Id 1088',0.00,2018.56,740.00,2249.60,231.04,'2023-01-22 13:23:34'),(1093,'1','307',1,'Retail Sale Id 1089',0.00,2018.56,740.00,2249.60,231.04,'2023-01-22 13:25:20'),(1094,'1','307',1,'Retail Sale Id 1090',0.00,2689.20,740.00,2997.00,307.80,'2023-01-22 13:39:09'),(1095,'1','307',1,'Retail Sale Id 1091',0.00,2018.56,740.00,2249.60,231.04,'2023-01-22 14:11:22'),(1096,'1','307',1,'Retail Sale Id 1092',0.00,8300.00,740.00,9250.00,950.00,'2023-01-22 14:28:25'),(1097,'1','307',1,'Retail Sale Id 1093',0.00,4037.12,740.00,4499.20,462.08,'2023-01-22 14:32:58'),(1098,'1','307',1,'Retail Sale Id 1094',0.00,3984.00,740.00,4440.00,456.00,'2023-01-22 14:42:37'),(1099,'1','307',1,'Retail Sale Id 1095',0.00,1992.00,740.00,2220.00,228.00,'2023-01-22 14:44:32'),(1100,'1','307',1,'Retail Sale Id 1096',0.00,8300.00,740.00,9250.00,950.00,'2023-01-22 14:57:43'),(1101,'1','307',1,'Retail Sale Id 1097',0.00,1328.00,740.00,1480.00,152.00,'2023-01-22 15:01:03'),(1102,'1','307',1,'Retail Sale Id 1098',0.00,1792.80,740.00,1998.00,205.20,'2023-01-22 15:38:21'),(1103,'1','307',1,'Retail Sale Id 1099',0.00,1972.08,740.00,2197.80,225.72,'2023-01-22 15:41:12'),(1104,'1','307',1,'Retail Sale Id 1100',0.00,4488.64,740.00,5002.40,513.76,'2023-01-22 15:50:52'),(1105,'1','307',1,'Retail Sale Id 1101',0.00,2018.56,740.00,2249.60,231.04,'2023-01-22 16:11:56'),(1106,'1','307',1,'Retail Sale Id 1102',0.00,1792.80,740.00,1998.00,205.20,'2023-01-22 16:13:25'),(1107,'1','307',1,'Retail Sale Id 1103',0.00,1347.92,740.00,1502.20,154.28,'2023-01-22 16:14:07'),(1108,'1','307',1,'Retail Sale Id 1104',0.00,66400.00,700.00,70000.00,3600.00,'2023-01-22 16:20:59'),(1109,'1','307',1,'Retail Sale Id 1105',0.00,1347.92,740.00,1502.20,154.28,'2023-01-22 16:26:10'),(1110,'1','307',1,'Retail Sale Id 1106',0.00,717.12,740.00,799.20,82.08,'2023-01-22 16:29:16'),(1111,'1','307',1,'Retail Sale Id 1107',0.00,3984.00,740.00,4440.00,456.00,'2023-01-22 16:31:05'),(1112,'1','307',1,'Retail Sale Id 1107',0.00,6640.00,740.00,7400.00,760.00,'2023-01-22 16:31:05'),(1113,'1','307',1,'Retail Sale Id 1108',0.00,2689.20,740.00,2997.00,307.80,'2023-01-22 16:42:59'),(1114,'1','307',1,'Retail Sale Id 1109',0.00,6640.00,740.00,7400.00,760.00,'2023-01-22 16:50:38'),(1115,'1','307',1,'Retail Sale Id 1110',0.00,1347.92,740.00,1502.20,154.28,'2023-01-22 16:52:38'),(1116,'1','307',1,'Retail Sale Id 1111',0.00,670.64,740.00,747.40,76.76,'2023-01-22 16:55:38'),(1117,'1','307',1,'Retail Sale Id 1112',0.00,33200.00,700.00,35000.00,1800.00,'2023-01-22 16:59:33'),(1118,'1','307',1,'Retail Sale Id 1113',0.00,3320.00,740.00,3700.00,380.00,'2023-01-22 17:02:16'),(1119,'1','307',1,'Retail Sale Id 1114',0.00,3990.64,740.00,4447.40,456.76,'2023-01-22 17:12:16'),(1120,'1','307',1,'Retail Sale Id 1115',0.00,3990.64,740.00,4447.40,456.76,'2023-01-22 17:14:23'),(1121,'1','307',1,'Retail Sale Id 1116',0.00,670.64,740.00,747.40,76.76,'2023-01-22 17:19:47'),(1122,'1','307',1,'Retail Sale Id 1117',0.00,1347.92,740.00,1502.20,154.28,'2023-01-22 17:22:24'),(1123,'1','307',1,'Retail Sale Id 1118',0.00,8300.00,740.00,9250.00,950.00,'2023-01-22 17:30:24'),(1124,'1','307',1,'Retail Sale Id 1119',0.00,1613.52,740.00,1798.20,184.68,'2023-01-22 17:36:06'),(1125,'1','307',1,'Retail Sale Id 1120',0.00,16600.00,740.00,18500.00,1900.00,'2023-01-22 17:40:55'),(1126,'1','307',1,'Retail Sale Id 1121',0.00,3320.00,740.00,3700.00,380.00,'2023-01-22 17:52:24'),(1127,'1','307',1,'Retail Sale Id 1122',0.00,2244.32,740.00,2501.20,256.88,'2023-01-22 17:56:41'),(1128,'1','307',1,'Retail Sale Id 1122',0.00,2244.32,740.00,2501.20,256.88,'2023-01-22 17:56:41'),(1129,'1','307',1,'Retail Sale Id 1124',0.00,33200.00,700.00,35000.00,1800.00,'2023-01-22 18:16:17'),(1130,'1','307',1,'Retail Sale Id 1125',0.00,3320.00,740.00,3700.00,380.00,'2023-01-22 18:17:50'),(1131,'1','307',1,'Retail Sale Id 1126',0.00,1992.00,740.00,2220.00,228.00,'2023-01-22 18:19:37'),(1132,'1','307',1,'Retail Sale Id 1127',0.00,2018.56,740.00,2249.60,231.04,'2023-01-22 18:26:23'),(1133,'1','307',1,'Retail Sale Id 1128',0.00,3851.20,740.00,4292.00,440.80,'2023-01-22 18:52:54'),(1134,'1','307',1,'Retail Sale Id 1129',0.00,8074.24,740.00,8998.40,924.16,'2023-01-23 07:25:23'),(1135,'1','307',1,'Retail Sale Id 1130',0.00,66400.00,700.00,70000.00,3600.00,'2023-01-23 07:26:01'),(1136,'1','307',1,'Retail Sale Id 1131',0.00,4667.92,740.00,5202.20,534.28,'2023-01-23 07:35:37'),(1137,'1','307',1,'Retail Sale Id 1132',0.00,1792.80,740.00,1998.00,205.20,'2023-01-23 07:49:51'),(1138,'1','307',1,'Retail Sale Id 1132',0.00,1792.80,740.00,1998.00,205.20,'2023-01-23 07:49:51'),(1139,'1','307',1,'Retail Sale Id 1134',0.00,4488.64,740.00,5002.40,513.76,'2023-01-23 08:17:14'),(1140,'1','307',1,'Retail Sale Id 1135',0.00,1347.92,740.00,1502.20,154.28,'2023-01-23 08:38:26'),(1141,'1','307',1,'Retail Sale Id 1136',0.00,2018.56,740.00,2249.60,231.04,'2023-01-23 08:44:54'),(1142,'1','307',1,'Retail Sale Id 1137',0.00,1992.00,740.00,2220.00,228.00,'2023-01-23 09:36:36'),(1143,'1','307',1,'Retail Sale Id 1138',0.00,1992.00,740.00,2220.00,228.00,'2023-01-23 09:45:55'),(1144,'1','307',1,'Retail Sale Id 1140',0.00,2244.32,740.00,2501.20,256.88,'2023-01-23 09:54:40'),(1145,'1','307',1,'Retail Sale Id 1141',0.00,3990.64,740.00,4447.40,456.76,'2023-01-23 10:05:14'),(1146,'1','307',1,'Retail Sale Id 1142',0.00,3990.64,740.00,4447.40,456.76,'2023-01-23 10:09:44'),(1147,'1','307',1,'Retail Sale Id 1143',0.00,1347.92,740.00,1502.20,154.28,'2023-01-23 10:22:05'),(1148,'1','307',1,'Retail Sale Id 1144',0.00,8300.00,740.00,9250.00,950.00,'2023-01-23 10:42:01'),(1149,'1','307',1,'Retail Sale Id 1145',0.00,2689.20,740.00,2997.00,307.80,'2023-01-23 10:50:07'),(1150,'1','307',1,'Retail Sale Id 1146',0.00,33200.00,700.00,35000.00,1800.00,'2023-01-23 10:57:30'),(1151,'1','307',1,'Retail Sale Id 1147',0.00,8300.00,740.00,9250.00,950.00,'2023-01-23 11:06:54'),(1152,'1','307',1,'Retail Sale Id 1148',0.00,6640.00,740.00,7400.00,760.00,'2023-01-23 11:10:37'),(1153,'1','307',1,'Retail Sale Id 1149',0.00,3984.00,740.00,4440.00,456.00,'2023-01-23 11:50:12'),(1154,'1','307',1,'Retail Sale Id 1150',0.00,1992.00,740.00,2220.00,228.00,'2023-01-23 11:57:39'),(1155,'1','307',1,'Retail Sale Id 1151',0.00,2689.20,740.00,2997.00,307.80,'2023-01-23 12:08:58'),(1156,'1','307',1,'Retail Sale Id 1152',0.00,1992.00,740.00,2220.00,228.00,'2023-01-23 12:19:18'),(1157,'1','307',1,'Retail Sale Id 1152',0.00,3984.00,740.00,4440.00,456.00,'2023-01-23 12:19:18'),(1158,'1','307',1,'Retail Sale Id 1153',0.00,83000.00,700.00,87500.00,4500.00,'2023-01-23 12:38:28'),(1159,'1','307',1,'Retail Sale Id 1154',0.00,3984.00,740.00,4440.00,456.00,'2023-01-23 13:18:48'),(1160,'1','307',1,'Retail Sale Id 1155',0.00,1972.08,740.00,2197.80,225.72,'2023-01-23 13:21:32'),(1161,'1','307',1,'Retail Sale Id 1156',0.00,4037.12,740.00,4499.20,462.08,'2023-01-23 14:38:00'),(1162,'1','307',1,'Retail Sale Id 1157',0.00,1972.08,740.00,2197.80,225.72,'2023-01-23 14:44:37'),(1163,'1','307',1,'Retail Sale Id 1158',0.00,2689.20,740.00,2997.00,307.80,'2023-01-23 14:50:51'),(1164,'1','307',1,'Retail Sale Id 1159',0.00,1347.92,740.00,1502.20,154.28,'2023-01-23 14:52:48'),(1165,'1','307',1,'Retail Sale Id 1161',0.00,4037.12,740.00,4499.20,462.08,'2023-01-23 14:54:18'),(1166,'1','307',1,'Retail Sale Id 1162',0.00,1792.80,740.00,1998.00,205.20,'2023-01-23 15:00:21'),(1167,'1','307',1,'Retail Sale Id 1163',0.00,670.64,740.00,747.40,76.76,'2023-01-23 15:22:59'),(1168,'1','307',1,'Retail Sale Id 1164',0.00,33200.00,700.00,35000.00,1800.00,'2023-01-23 15:51:37'),(1169,'1','307',1,'Retail Sale Id 1165',0.00,3320.00,740.00,3700.00,380.00,'2023-01-23 15:54:15'),(1170,'1','307',1,'Retail Sale Id 1166',0.00,2018.56,740.00,2249.60,231.04,'2023-01-23 15:55:49'),(1171,'1','307',1,'Retail Sale Id 1167',0.00,3320.00,740.00,3700.00,380.00,'2023-01-23 16:02:11'),(1172,'1','307',1,'Retail Sale Id 1168',0.00,2018.56,740.00,2249.60,231.04,'2023-01-23 16:25:01'),(1173,'1','307',1,'Retail Sale Id 1170',0.00,8300.00,740.00,9250.00,950.00,'2023-01-23 16:32:54'),(1174,'1','307',1,'Retail Sale Id 1171',0.00,7304.00,740.00,8140.00,836.00,'2023-01-23 16:40:14'),(1175,'1','307',1,'Retail Sale Id 1172',0.00,3320.00,740.00,3700.00,380.00,'2023-01-23 16:43:28'),(1176,'1','307',1,'Retail Sale Id 1173',0.00,1726.40,740.00,1924.00,197.60,'2023-01-23 17:15:04'),(1177,'1','307',1,'Sale Id 2',0.00,50742.88,740.00,56550.80,5807.92,'2023-01-23 17:22:45'),(1178,'1','307',1,'Retail Sale Id 1174',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-23 18:20:50'),(1179,'1','307',1,'Retail Sale Id 1175',0.00,1278.90,740.00,1502.20,223.30,'2023-01-23 18:22:19'),(1180,'1','307',1,'Retail Sale Id 1176',0.00,63000.00,700.00,70000.00,7000.00,'2023-01-23 18:57:50'),(1181,'1','307',1,'Retail Sale Id 1177',0.00,3150.00,740.00,3700.00,550.00,'2023-01-23 19:00:39'),(1182,'1','307',1,'Retail Sale Id 1178',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-23 19:13:30'),(1183,'1','307',1,'Retail Sale Id 1179',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-23 19:15:10'),(1184,'1','307',1,'Retail Sale Id 1180',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-23 19:15:41'),(1185,'1','307',1,'Retail Sale Id 1181',0.00,9450.00,740.00,11100.00,1650.00,'2023-01-23 19:16:44'),(1186,'1','307',1,'Retail Sale Id 1182',0.00,1549.80,740.00,1820.40,270.60,'2023-01-23 19:18:29'),(1187,'1','307',1,'Retail Sale Id 1183',0.00,1871.10,740.00,2197.80,326.70,'2023-01-24 08:04:44'),(1188,'1','307',1,'Retail Sale Id 1184',0.00,1278.90,740.00,1502.20,223.30,'2023-01-24 08:25:07'),(1189,'1','307',1,'Retail Sale Id 1185',0.00,63000.00,700.00,70000.00,7000.00,'2023-01-24 08:27:09'),(1190,'1','307',1,'Retail Sale Id 1186',0.00,1915.20,740.00,2249.60,334.40,'2023-01-24 08:28:43'),(1191,'1','307',1,'Retail Sale Id 1187',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-24 09:06:21'),(1192,'1','307',1,'Retail Sale Id 1188',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-24 09:19:56'),(1193,'1','307',1,'Retail Sale Id 1189',0.00,1260.00,740.00,1480.00,220.00,'2023-01-24 09:39:16'),(1194,'1','307',1,'Retail Sale Id 1190',0.00,94500.00,700.00,105000.00,10500.00,'2023-01-24 10:09:35'),(1195,'1','307',1,'Retail Sale Id 1191',0.00,1915.20,740.00,2249.60,334.40,'2023-01-24 11:06:54'),(1196,'1','307',1,'Retail Sale Id 1192',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-24 11:19:13'),(1197,'1','307',1,'Retail Sale Id 1193',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-24 11:31:29'),(1198,'1','307',1,'Retail Sale Id 1194',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-24 11:44:57'),(1199,'1','307',1,'Retail Sale Id 1195',0.00,3408.30,740.00,4003.40,595.10,'2023-01-24 12:34:07'),(1200,'1','307',1,'Retail Sale Id 1196',0.00,1890.00,740.00,2220.00,330.00,'2023-01-24 12:38:15'),(1201,'1','307',1,'Retail Sale Id 1199',0.00,1890.00,740.00,2220.00,330.00,'2023-01-24 12:50:06'),(1202,'1','307',1,'Retail Sale Id 1200',0.00,3780.00,740.00,4440.00,660.00,'2023-01-24 13:03:00'),(1203,'1','307',1,'Retail Sale Id 1201',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-24 15:41:55'),(1204,'1','307',1,'Retail Sale Id 1202',0.00,1278.90,740.00,1502.20,223.30,'2023-01-24 15:43:10'),(1205,'1','307',1,'Retail Sale Id 1203',0.00,3786.30,740.00,4447.40,661.10,'2023-01-24 16:44:34'),(1206,'1','307',1,'Retail Sale Id 1204',0.00,3150.00,740.00,3700.00,550.00,'2023-01-24 16:47:14'),(1207,'1','307',1,'Retail Sale Id 1205',0.00,3780.00,740.00,4440.00,660.00,'2023-01-24 16:51:07'),(1208,'1','307',1,'Retail Sale Id 1206',0.00,3780.00,740.00,4440.00,660.00,'2023-01-24 16:53:19'),(1209,'1','307',1,'Retail Sale Id 1207',0.00,850.50,740.00,999.00,148.50,'2023-01-24 17:02:00'),(1210,'1','307',1,'Retail Sale Id 1208',0.00,850.50,740.00,999.00,148.50,'2023-01-24 17:26:31'),(1211,'1','307',1,'Retail Sale Id 1209',0.00,2041.20,740.00,2397.60,356.40,'2023-01-24 17:42:38'),(1212,'1','307',1,'Retail Sale Id 1210',0.00,3780.00,740.00,4440.00,660.00,'2023-01-24 17:47:10'),(1213,'1','307',1,'Retail Sale Id 1211',0.00,2551.50,740.00,2997.00,445.50,'2023-01-24 17:51:39'),(1214,'1','307',1,'Retail Sale Id 1212',0.00,3786.30,740.00,4447.40,661.10,'2023-01-24 17:54:19'),(1215,'1','307',1,'Retail Sale Id 1213',0.00,636.30,740.00,747.40,111.10,'2023-01-24 18:03:55'),(1216,'1','307',1,'Retail Sale Id 1213',0.00,636.30,740.00,747.40,111.10,'2023-01-24 18:03:55'),(1217,'1','307',1,'Retail Sale Id 1214',0.00,1915.20,740.00,2249.60,334.40,'2023-01-24 18:11:02'),(1218,'1','307',1,'Retail Sale Id 1215',0.00,1278.90,740.00,1502.20,223.30,'2023-01-24 18:20:20'),(1219,'1','307',1,'Retail Sale Id 1216',0.00,6300.00,740.00,7400.00,1100.00,'2023-01-24 18:27:51'),(1220,'1','307',1,'Retail Sale Id 1217',0.00,1701.00,740.00,1998.00,297.00,'2023-01-24 18:31:18'),(1221,'1','307',1,'Retail Sale Id 1218',0.00,3830.40,740.00,4499.20,668.80,'2023-01-24 18:33:10'),(1222,'1','307',1,'Retail Sale Id 1219',0.00,2935.80,740.00,3448.40,512.60,'2023-01-24 19:00:38'),(1223,'1','307',1,'Retail Sale Id 1222',0.00,3780.00,740.00,4440.00,660.00,'2023-01-25 07:44:38'),(1224,'1','307',1,'Retail Sale Id 1223',0.00,1278.90,740.00,1502.20,223.30,'2023-01-25 08:14:51'),(1225,'1','307',1,'Retail Sale Id 1224',0.00,1260.00,740.00,1480.00,220.00,'2023-01-25 08:24:09'),(1226,'1','307',1,'Retail Sale Id 1225',0.00,1915.20,740.00,2249.60,334.40,'2023-01-25 08:42:44'),(1227,'1','307',1,'Retail Sale Id 1226',0.00,1915.20,740.00,2249.60,334.40,'2023-01-25 08:49:03'),(1228,'1','307',1,'Retail Sale Id 1227',0.00,3780.00,740.00,4440.00,660.00,'2023-01-25 08:57:04'),(1229,'1','307',1,'Retail Sale Id 1228',0.00,94500.00,700.00,105000.00,10500.00,'2023-01-25 09:02:36'),(1230,'1','307',1,'Retail Sale Id 1229',0.00,6300.00,740.00,7400.00,1100.00,'2023-01-25 09:13:04'),(1231,'1','307',1,'Retail Sale Id 1230',0.00,3786.30,740.00,4447.40,661.10,'2023-01-25 09:15:16'),(1232,'1','307',1,'Retail Sale Id 1231',0.00,1890.00,740.00,2220.00,330.00,'2023-01-25 10:17:22'),(1233,'1','307',1,'Retail Sale Id 1232',0.00,1701.00,740.00,1998.00,297.00,'2023-01-25 10:32:05'),(1234,'1','307',1,'Retail Sale Id 1233',0.00,3780.00,740.00,4440.00,660.00,'2023-01-25 10:47:01'),(1235,'1','307',1,'Retail Sale Id 1234',0.00,1278.90,740.00,1502.20,223.30,'2023-01-25 10:52:48'),(1236,'1','307',1,'Retail Sale Id 1235',0.00,1915.20,740.00,2249.60,334.40,'2023-01-25 11:33:47'),(1237,'1','307',1,'Retail Sale Id 1236',0.00,1959.30,740.00,2301.40,342.10,'2023-01-25 11:52:30'),(1238,'1','307',1,'Retail Sale Id 1237',0.00,3150.00,740.00,3700.00,550.00,'2023-01-25 12:05:28'),(1239,'1','307',1,'Retail Sale Id 1238',0.00,1915.20,740.00,2249.60,334.40,'2023-01-25 12:17:39'),(1240,'1','307',1,'Retail Sale Id 1239',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-25 12:19:48'),(1241,'1','307',1,'Retail Sale Id 1240',0.00,78750.00,700.00,87500.00,8750.00,'2023-01-25 12:27:20'),(1242,'1','307',1,'Retail Sale Id 1241',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-25 12:30:14'),(1243,'1','307',1,'Retail Sale Id 1242',0.00,7578.90,740.00,8902.20,1323.30,'2023-01-25 15:04:00'),(1244,'1','307',1,'Retail Sale Id 1243',0.00,1915.20,740.00,2249.60,334.40,'2023-01-25 15:14:03'),(1245,'1','307',1,'Retail Sale Id 1244',0.00,3786.30,740.00,4447.40,661.10,'2023-01-25 15:37:07'),(1246,'1','307',1,'Retail Sale Id 1245',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-25 15:49:00'),(1247,'1','307',1,'Retail Sale Id 1246',0.00,1890.00,740.00,2220.00,330.00,'2023-01-25 15:53:29'),(1248,'1','307',1,'Retail Sale Id 1247',0.00,3786.30,740.00,4447.40,661.10,'2023-01-25 15:55:15'),(1249,'1','307',1,'Retail Sale Id 1248',0.00,2551.50,740.00,2997.00,445.50,'2023-01-25 16:16:52'),(1250,'1','307',1,'Retail Sale Id 1249',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-25 16:20:50'),(1251,'1','307',1,'Retail Sale Id 1250',0.00,3786.30,740.00,4447.40,661.10,'2023-01-25 16:22:10'),(1252,'1','307',1,'Retail Sale Id 1251',0.00,3786.30,740.00,4447.40,661.10,'2023-01-25 16:22:54'),(1253,'1','307',1,'Retail Sale Id 1252',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-25 16:24:19'),(1254,'1','307',1,'Retail Sale Id 1253',0.00,1915.20,740.00,2249.60,334.40,'2023-01-25 16:42:28'),(1255,'1','307',1,'Retail Sale Id 1254',0.00,3786.30,740.00,4447.40,661.10,'2023-01-25 16:46:00'),(1256,'1','307',1,'Retail Sale Id 1255',0.00,1915.20,740.00,2249.60,334.40,'2023-01-25 16:46:47'),(1257,'1','307',1,'Retail Sale Id 1256',0.00,1278.90,740.00,1502.20,223.30,'2023-01-25 16:54:05'),(1258,'1','307',1,'Retail Sale Id 1257',0.00,1278.90,740.00,1502.20,223.30,'2023-01-25 17:02:29'),(1259,'1','307',1,'Retail Sale Id 1258',0.00,3830.40,740.00,4499.20,668.80,'2023-01-25 17:04:15'),(1260,'1','307',1,'Retail Sale Id 1259',0.00,1890.00,740.00,2220.00,330.00,'2023-01-25 17:10:09'),(1261,'1','307',1,'Retail Sale Id 1260',0.00,1890.00,740.00,2220.00,330.00,'2023-01-25 17:19:02'),(1262,'1','307',1,'Retail Sale Id 1261',0.00,3150.00,740.00,3700.00,550.00,'2023-01-25 17:57:58'),(1263,'1','307',1,'Retail Sale Id 1262',0.00,3786.30,740.00,4447.40,661.10,'2023-01-25 18:00:20'),(1264,'1','307',1,'Retail Sale Id 1263',0.00,1915.20,740.00,2249.60,334.40,'2023-01-25 18:09:54'),(1265,'1','307',1,'Retail Sale Id 1264',0.00,2551.50,740.00,2997.00,445.50,'2023-01-25 18:27:49'),(1266,'1','307',1,'Retail Sale Id 1265',0.00,1701.00,740.00,1998.00,297.00,'2023-01-25 18:28:27'),(1267,'1','307',1,'Retail Sale Id 1266',0.00,5109.30,740.00,6001.40,892.10,'2023-01-25 18:33:30'),(1268,'1','307',1,'Retail Sale Id 1267',0.00,3786.30,740.00,4447.40,661.10,'2023-01-25 18:47:17'),(1269,'1','307',1,'Retail Sale Id 1268',0.00,8429.40,740.00,9901.20,1471.80,'2023-01-25 19:11:35'),(1270,'1','307',1,'Retail Sale Id 1269',0.00,680.40,740.00,799.20,118.80,'2023-01-26 07:11:55'),(1271,'1','307',1,'Retail Sale Id 1270',0.00,1915.20,740.00,2249.60,334.40,'2023-01-26 07:30:48'),(1272,'1','307',1,'Retail Sale Id 1271',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-26 07:32:20'),(1273,'1','307',1,'Retail Sale Id 1272',0.00,1701.00,740.00,1998.00,297.00,'2023-01-26 08:02:43'),(1274,'1','307',1,'Retail Sale Id 1273',0.00,6810.30,740.00,7999.40,1189.10,'2023-01-26 08:18:10'),(1275,'1','307',1,'Retail Sale Id 1274',0.00,1959.30,740.00,2301.40,342.10,'2023-01-26 08:27:51'),(1276,'1','307',1,'Retail Sale Id 1275',0.00,1278.90,740.00,1502.20,223.30,'2023-01-26 08:33:38'),(1277,'1','307',1,'Retail Sale Id 1276',0.00,2129.40,740.00,2501.20,371.80,'2023-01-26 08:55:24'),(1278,'1','307',1,'Retail Sale Id 1277',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-26 09:00:03'),(1279,'1','307',1,'Retail Sale Id 1278',0.00,3786.30,740.00,4447.40,661.10,'2023-01-26 09:27:56'),(1280,'1','307',1,'Retail Sale Id 1279',0.00,1915.20,740.00,2249.60,334.40,'2023-01-26 09:29:17'),(1281,'1','307',1,'Retail Sale Id 1280',0.00,25200.00,700.00,28000.00,2800.00,'2023-01-26 09:30:57'),(1282,'1','307',1,'Retail Sale Id 1281',0.00,2551.50,740.00,2997.00,445.50,'2023-01-26 09:44:42'),(1283,'1','307',1,'Retail Sale Id 1282',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-26 09:49:42'),(1284,'1','307',1,'Retail Sale Id 1283',0.00,598.50,740.00,703.00,104.50,'2023-01-26 09:50:52'),(1285,'1','307',1,'Retail Sale Id 1284',0.00,3780.00,740.00,4440.00,660.00,'2023-01-26 10:03:49'),(1286,'1','307',1,'Retail Sale Id 1285',0.00,1701.00,740.00,1998.00,297.00,'2023-01-26 10:09:54'),(1287,'1','307',1,'Retail Sale Id 1285',0.00,4258.80,740.00,5002.40,743.60,'2023-01-26 10:09:54'),(1288,'1','307',1,'Retail Sale Id 1286',0.00,2551.50,740.00,2997.00,445.50,'2023-01-26 10:11:29'),(1289,'1','307',1,'Retail Sale Id 1287',0.00,3830.40,740.00,4499.20,668.80,'2023-01-26 10:12:49'),(1290,'1','307',1,'Retail Sale Id 1288',0.00,3150.00,740.00,3700.00,550.00,'2023-01-26 10:31:03'),(1291,'1','307',1,'Retail Sale Id 1289',0.00,1959.30,740.00,2301.40,342.10,'2023-01-26 10:39:49'),(1292,'1','307',1,'Retail Sale Id 1290',0.00,1360.80,740.00,1598.40,237.60,'2023-01-26 10:55:18'),(1293,'1','307',1,'Retail Sale Id 1291',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-26 11:12:14'),(1294,'1','307',1,'Retail Sale Id 1292',0.00,630.00,740.00,740.00,110.00,'2023-01-26 11:17:32'),(1295,'1','307',1,'Retail Sale Id 1293',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-26 11:34:47'),(1296,'1','307',1,'Retail Sale Id 1294',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-26 11:36:12'),(1297,'1','307',1,'Retail Sale Id 1294',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-26 11:36:12'),(1298,'1','307',1,'Retail Sale Id 1295',0.00,3786.30,740.00,4447.40,661.10,'2023-01-26 11:38:43'),(1299,'1','307',1,'Retail Sale Id 1296',0.00,1278.90,740.00,1502.20,223.30,'2023-01-26 11:58:05'),(1300,'1','307',1,'Retail Sale Id 1297',0.00,3150.00,740.00,3700.00,550.00,'2023-01-26 12:15:12'),(1301,'1','307',1,'Retail Sale Id 1297',0.00,3150.00,740.00,3700.00,550.00,'2023-01-26 12:15:12'),(1302,'1','307',1,'Retail Sale Id 1298',0.00,1278.90,740.00,1502.20,223.30,'2023-01-26 12:31:14'),(1303,'1','307',1,'Retail Sale Id 1299',0.00,5959.80,740.00,7000.40,1040.60,'2023-01-26 13:16:32'),(1304,'1','307',1,'Retail Sale Id 1300',0.00,1915.20,740.00,2249.60,334.40,'2023-01-26 13:18:12'),(1305,'1','307',1,'Retail Sale Id 1301',0.00,1701.00,740.00,1998.00,297.00,'2023-01-26 13:19:08'),(1306,'1','307',1,'Retail Sale Id 1302',0.00,1890.00,740.00,2220.00,330.00,'2023-01-26 14:30:00'),(1307,'1','307',1,'Retail Sale Id 1303',0.00,3786.30,740.00,4447.40,661.10,'2023-01-26 14:48:57'),(1308,'1','307',1,'Retail Sale Id 1304',0.00,1278.90,740.00,1502.20,223.30,'2023-01-26 15:13:40'),(1309,'1','307',1,'Retail Sale Id 1305',0.00,636.30,740.00,747.40,111.10,'2023-01-26 15:14:51'),(1310,'1','307',1,'Retail Sale Id 1306',0.00,1278.90,740.00,1502.20,223.30,'2023-01-26 15:36:28'),(1311,'1','307',1,'Retail Sale Id 1307',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-26 15:42:17'),(1312,'1','307',1,'Retail Sale Id 1308',0.00,47250.00,700.00,52500.00,5250.00,'2023-01-26 15:48:13'),(1313,'1','307',1,'Retail Sale Id 1309',0.00,1108.80,740.00,1302.40,193.60,'2023-01-26 15:55:20'),(1314,'1','307',1,'Retail Sale Id 1310',0.00,3786.30,740.00,4447.40,661.10,'2023-01-26 16:29:21'),(1315,'1','307',1,'Retail Sale Id 1311',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-26 16:35:19'),(1316,'1','307',1,'Retail Sale Id 1312',0.00,3780.00,740.00,4440.00,660.00,'2023-01-26 16:58:44'),(1317,'1','307',1,'Retail Sale Id 1313',0.00,2551.50,740.00,2997.00,445.50,'2023-01-26 17:01:49'),(1318,'1','307',1,'Retail Sale Id 1314',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-26 17:13:51'),(1319,'1','307',1,'Retail Sale Id 1315',0.00,2551.50,740.00,2997.00,445.50,'2023-01-26 17:16:56'),(1320,'1','307',1,'Retail Sale Id 1316',0.00,630.00,740.00,740.00,110.00,'2023-01-26 17:32:19'),(1321,'1','307',1,'Retail Sale Id 1317',0.00,4410.00,740.00,5180.00,770.00,'2023-01-26 17:34:34'),(1322,'1','307',1,'Retail Sale Id 1318',0.00,3786.30,740.00,4447.40,661.10,'2023-01-26 17:40:22'),(1323,'1','307',1,'Retail Sale Id 1319',0.00,2520.00,740.00,2960.00,440.00,'2023-01-26 17:51:39'),(1324,'1','307',1,'Retail Sale Id 1320',0.00,6980.40,740.00,8199.20,1218.80,'2023-01-26 18:13:21'),(1325,'1','307',1,'Retail Sale Id 1321',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-26 18:33:45'),(1326,'1','307',1,'Retail Sale Id 1322',0.00,3150.00,740.00,3700.00,550.00,'2023-01-26 18:36:04'),(1327,'1','307',1,'Retail Sale Id 1323',0.00,1316.70,740.00,1546.60,229.90,'2023-01-26 18:54:14'),(1328,'1','307',1,'Retail Sale Id 1324',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-27 07:39:41'),(1329,'1','307',1,'Retail Sale Id 1325',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-27 08:03:58'),(1330,'1','307',1,'Retail Sale Id 1326',0.00,1915.20,740.00,2249.60,334.40,'2023-01-27 08:46:54'),(1331,'1','307',1,'Retail Sale Id 1327',0.00,5109.30,740.00,6001.40,892.10,'2023-01-27 09:17:12'),(1332,'1','307',1,'Retail Sale Id 1328',0.00,1278.90,740.00,1502.20,223.30,'2023-01-27 09:25:41'),(1333,'1','307',1,'Retail Sale Id 1329',0.00,1890.00,740.00,2220.00,330.00,'2023-01-27 09:46:14'),(1334,'1','307',1,'Retail Sale Id 1330',0.00,1890.00,740.00,2220.00,330.00,'2023-01-27 10:07:30'),(1335,'1','307',1,'Retail Sale Id 1331',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-27 10:37:48'),(1336,'1','307',1,'Retail Sale Id 1332',0.00,3150.00,740.00,3700.00,550.00,'2023-01-27 10:52:07'),(1337,'1','307',1,'Retail Sale Id 1333',0.00,1915.20,740.00,2249.60,334.40,'2023-01-27 10:59:17'),(1338,'1','307',1,'Retail Sale Id 1334',0.00,17999.10,700.00,19999.00,1999.90,'2023-01-27 11:10:30'),(1339,'1','307',1,'Retail Sale Id 1335',0.00,3786.30,740.00,4447.40,661.10,'2023-01-27 11:27:46'),(1340,'1','307',1,'Retail Sale Id 1336',0.00,3786.30,740.00,4447.40,661.10,'2023-01-27 11:32:51'),(1341,'1','307',1,'Retail Sale Id 1337',0.00,6980.40,740.00,8199.20,1218.80,'2023-01-27 11:51:13'),(1342,'1','307',1,'Retail Sale Id 1338',0.00,3150.00,740.00,3700.00,550.00,'2023-01-27 11:53:12'),(1343,'1','307',1,'Retail Sale Id 1339',0.00,2551.50,740.00,2997.00,445.50,'2023-01-27 11:54:53'),(1344,'1','307',1,'Retail Sale Id 1340',0.00,1890.00,740.00,2220.00,330.00,'2023-01-27 11:59:50'),(1345,'1','307',1,'Retail Sale Id 1341',0.00,3786.30,740.00,4447.40,661.10,'2023-01-27 12:02:56'),(1346,'1','307',1,'Retail Sale Id 1342',0.00,3786.30,740.00,4447.40,661.10,'2023-01-27 12:09:01'),(1347,'1','307',1,'Retail Sale Id 1343',0.00,1871.10,740.00,2197.80,326.70,'2023-01-27 13:59:49'),(1348,'1','307',1,'Retail Sale Id 1344',0.00,3150.00,740.00,3700.00,550.00,'2023-01-27 14:08:13'),(1349,'1','307',1,'Retail Sale Id 1345',0.00,2129.40,740.00,2501.20,371.80,'2023-01-27 14:13:27'),(1350,'1','307',1,'Retail Sale Id 1346',0.00,1278.90,740.00,1502.20,223.30,'2023-01-27 14:18:47'),(1351,'1','307',1,'Retail Sale Id 1347',0.00,63000.00,700.00,70000.00,7000.00,'2023-01-27 15:16:41'),(1352,'1','307',1,'Retail Sale Id 1348',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-27 15:18:53'),(1353,'1','307',1,'Retail Sale Id 1349',0.00,3786.30,740.00,4447.40,661.10,'2023-01-27 15:29:03'),(1354,'1','307',1,'Retail Sale Id 1350',0.00,1890.00,740.00,2220.00,330.00,'2023-01-27 15:54:08'),(1355,'1','307',1,'Retail Sale Id 1351',0.00,1890.00,740.00,2220.00,330.00,'2023-01-27 16:08:12'),(1356,'1','307',1,'Retail Sale Id 1352',0.00,1260.00,740.00,1480.00,220.00,'2023-01-27 16:24:33'),(1357,'1','307',1,'Retail Sale Id 1353',0.00,2551.50,740.00,2997.00,445.50,'2023-01-27 16:34:29'),(1358,'1','307',1,'Retail Sale Id 1354',0.00,3150.00,740.00,3700.00,550.00,'2023-01-27 16:42:44'),(1359,'1','307',1,'Retail Sale Id 1355',0.00,3150.00,740.00,3700.00,550.00,'2023-01-27 16:45:25'),(1360,'1','307',1,'Retail Sale Id 1356',0.00,1278.90,740.00,1502.20,223.30,'2023-01-27 16:48:39'),(1361,'1','307',1,'Retail Sale Id 1357',0.00,3786.30,740.00,4447.40,661.10,'2023-01-27 17:02:25'),(1362,'1','307',1,'Retail Sale Id 1358',0.00,1278.90,740.00,1502.20,223.30,'2023-01-27 17:03:52'),(1363,'1','307',1,'Retail Sale Id 1359',0.00,3786.30,740.00,4447.40,661.10,'2023-01-27 17:13:18'),(1364,'1','307',1,'Retail Sale Id 1360',0.00,1896.30,740.00,2227.40,331.10,'2023-01-27 17:16:10'),(1365,'1','307',1,'Retail Sale Id 1361',0.00,680.40,740.00,799.20,118.80,'2023-01-27 17:20:27'),(1366,'1','307',1,'Retail Sale Id 1362',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-27 17:32:27'),(1367,'1','307',1,'Retail Sale Id 1363',0.00,1915.20,740.00,2249.60,334.40,'2023-01-27 17:48:17'),(1368,'1','307',1,'Retail Sale Id 1364',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-27 17:50:57'),(1369,'1','307',1,'Retail Sale Id 1365',0.00,1278.90,740.00,1502.20,223.30,'2023-01-27 17:53:32'),(1370,'1','307',1,'Retail Sale Id 1367',0.00,1701.00,740.00,1998.00,297.00,'2023-01-27 17:54:20'),(1371,'1','307',1,'Retail Sale Id 1368',0.00,680.40,740.00,799.20,118.80,'2023-01-27 18:06:44'),(1372,'1','307',1,'Retail Sale Id 1369',0.00,1701.00,740.00,1998.00,297.00,'2023-01-27 18:14:57'),(1373,'1','307',1,'Retail Sale Id 1370',0.00,2520.00,740.00,2960.00,440.00,'2023-01-27 18:23:19'),(1374,'1','307',1,'Retail Sale Id 1371',0.00,630.00,740.00,740.00,110.00,'2023-01-27 18:24:45'),(1375,'1','307',1,'Retail Sale Id 1372',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-27 18:50:29'),(1376,'1','307',1,'Retail Sale Id 1373',0.00,3780.00,740.00,4440.00,660.00,'2023-01-27 18:53:12'),(1377,'1','307',1,'Retail Sale Id 1374',0.00,680.40,740.00,799.20,118.80,'2023-01-27 19:07:09'),(1378,'1','307',1,'Retail Sale Id 1375',0.00,4422.60,740.00,5194.80,772.20,'2023-01-27 19:09:36'),(1379,'1','307',1,'Retail Sale Id 1376',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-28 07:21:13'),(1380,'1','307',1,'Retail Sale Id 1377',0.00,6810.30,740.00,7999.40,1189.10,'2023-01-28 08:12:09'),(1381,'1','307',1,'Retail Sale Id 1378',0.00,1890.00,740.00,2220.00,330.00,'2023-01-28 08:26:47'),(1382,'1','307',1,'Retail Sale Id 1379',0.00,1278.90,740.00,1502.20,223.30,'2023-01-28 08:58:34'),(1383,'1','307',1,'Retail Sale Id 1380',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-28 09:02:40'),(1384,'1','307',1,'Retail Sale Id 1381',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-28 09:14:42'),(1385,'1','307',1,'Retail Sale Id 1382',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-28 09:31:43'),(1386,'1','307',1,'Retail Sale Id 1383',0.00,2551.50,740.00,2997.00,445.50,'2023-01-28 09:32:23'),(1387,'1','307',1,'Retail Sale Id 1384',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-28 10:15:28'),(1388,'1','307',1,'Retail Sale Id 1385',0.00,1890.00,740.00,2220.00,330.00,'2023-01-28 10:19:01'),(1389,'1','307',1,'Retail Sale Id 1387',0.00,2520.00,740.00,2960.00,440.00,'2023-01-28 10:34:05'),(1390,'1','307',1,'Retail Sale Id 1388',0.00,3786.30,740.00,4447.40,661.10,'2023-01-28 10:40:55'),(1391,'1','307',1,'Retail Sale Id 1389',0.00,21420.00,700.00,23800.00,2380.00,'2023-01-28 10:50:35'),(1392,'1','307',1,'Retail Sale Id 1390',0.00,1959.30,740.00,2301.40,342.10,'2023-01-28 11:01:50'),(1393,'1','307',1,'Retail Sale Id 1391',0.00,1890.00,740.00,2220.00,330.00,'2023-01-28 11:09:57'),(1394,'1','307',1,'Retail Sale Id 1392',0.00,1890.00,740.00,2220.00,330.00,'2023-01-28 11:16:17'),(1395,'1','307',1,'Retail Sale Id 1393',0.00,3786.30,740.00,4447.40,661.10,'2023-01-28 11:19:56'),(1396,'1','307',1,'Retail Sale Id 1394',0.00,3786.30,740.00,4447.40,661.10,'2023-01-28 12:04:52'),(1397,'1','307',1,'Retail Sale Id 1395',0.00,1278.90,740.00,1502.20,223.30,'2023-01-28 12:27:06'),(1398,'1','307',1,'Retail Sale Id 1396',0.00,6300.00,740.00,7400.00,1100.00,'2023-01-28 12:52:55'),(1399,'1','307',1,'Retail Sale Id 1397',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-28 13:17:55'),(1400,'1','307',1,'Retail Sale Id 1398',0.00,6300.00,740.00,7400.00,1100.00,'2023-01-28 13:20:31'),(1401,'1','307',1,'Retail Sale Id 1399',0.00,428.40,740.00,503.20,74.80,'2023-01-28 13:38:47'),(1402,'1','307',1,'Retail Sale Id 1401',0.00,340.20,740.00,399.60,59.40,'2023-01-28 13:59:55'),(1403,'1','307',1,'Retail Sale Id 1402',0.00,3786.30,740.00,4447.40,661.10,'2023-01-28 14:07:30'),(1404,'1','307',1,'Retail Sale Id 1403',0.00,3150.00,740.00,3700.00,550.00,'2023-01-28 14:34:02'),(1405,'1','307',1,'Retail Sale Id 1404',0.00,2551.50,740.00,2997.00,445.50,'2023-01-28 15:28:59'),(1406,'1','307',1,'Retail Sale Id 1405',0.00,3830.40,740.00,4499.20,668.80,'2023-01-28 15:45:00'),(1407,'1','307',1,'Retail Sale Id 1406',0.00,3786.30,740.00,4447.40,661.10,'2023-01-28 16:19:40'),(1408,'1','307',1,'Retail Sale Id 1408',0.00,1278.90,740.00,1502.20,223.30,'2023-01-28 16:45:45'),(1409,'1','307',1,'Retail Sale Id 1409',0.00,1701.00,740.00,1998.00,297.00,'2023-01-28 17:18:23'),(1410,'1','307',1,'Retail Sale Id 1410',0.00,3786.30,740.00,4447.40,661.10,'2023-01-28 17:26:17'),(1411,'1','307',1,'Retail Sale Id 1411',0.00,5701.50,740.00,6697.00,995.50,'2023-01-28 17:32:23'),(1412,'1','307',1,'Retail Sale Id 1412',0.00,1915.20,740.00,2249.60,334.40,'2023-01-28 17:41:58'),(1413,'1','307',1,'Retail Sale Id 1413',0.00,1701.00,740.00,1998.00,297.00,'2023-01-28 17:45:48'),(1414,'1','307',1,'Retail Sale Id 1414',0.00,680.40,740.00,799.20,118.80,'2023-01-28 17:51:12'),(1415,'1','307',1,'Retail Sale Id 1415',0.00,1890.00,740.00,2220.00,330.00,'2023-01-28 17:55:33'),(1416,'1','307',1,'Retail Sale Id 1416',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-28 18:13:03'),(1417,'1','307',1,'Retail Sale Id 1417',0.00,2979.90,740.00,3500.20,520.30,'2023-01-28 18:16:59'),(1418,'1','307',1,'Retail Sale Id 1418',0.00,3786.30,740.00,4447.40,661.10,'2023-01-28 18:23:03'),(1419,'1','307',1,'Retail Sale Id 1419',0.00,1278.90,740.00,1502.20,223.30,'2023-01-28 18:26:53'),(1420,'1','307',1,'Retail Sale Id 1420',0.00,1278.90,740.00,1502.20,223.30,'2023-01-28 18:29:04'),(1421,'1','307',1,'Retail Sale Id 1421',0.00,24570.00,700.00,27300.00,2730.00,'2023-01-28 18:30:53'),(1422,'1','307',1,'Retail Sale Id 1422',0.00,3786.30,740.00,4447.40,661.10,'2023-01-28 18:59:14'),(1423,'1','307',1,'Retail Sale Id 1423',0.00,1278.90,740.00,1502.20,223.30,'2023-01-28 19:04:57'),(1424,'1','307',1,'Retail Sale Id 1423',0.00,3150.00,740.00,3700.00,550.00,'2023-01-28 19:04:57'),(1425,'1','307',1,'Retail Sale Id 1424',0.00,674.10,740.00,791.80,117.70,'2023-01-28 19:29:00'),(1426,'1','307',1,'Retail Sale Id 1425',0.00,2551.50,740.00,2997.00,445.50,'2023-01-29 07:48:40'),(1427,'1','307',1,'Retail Sale Id 1426',0.00,1278.90,740.00,1502.20,223.30,'2023-01-29 08:46:31'),(1428,'1','307',1,'Retail Sale Id 1427',0.00,2551.50,740.00,2997.00,445.50,'2023-01-29 08:57:03'),(1429,'1','307',1,'Retail Sale Id 1428',0.00,3150.00,740.00,3700.00,550.00,'2023-01-29 09:04:39'),(1430,'1','307',1,'Retail Sale Id 1429',0.00,63000.00,700.00,70000.00,7000.00,'2023-01-29 10:13:12'),(1431,'1','307',1,'Retail Sale Id 1430',0.00,6300.00,740.00,7400.00,1100.00,'2023-01-29 10:14:24'),(1432,'1','307',1,'Retail Sale Id 1431',0.00,1701.00,740.00,1998.00,297.00,'2023-01-29 10:19:42'),(1433,'1','307',1,'Retail Sale Id 1432',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-29 10:31:33'),(1434,'1','307',1,'Retail Sale Id 1433',0.00,680.40,740.00,799.20,118.80,'2023-01-29 10:32:37'),(1435,'1','307',1,'Retail Sale Id 1434',0.00,1701.00,740.00,1998.00,297.00,'2023-01-29 10:49:20'),(1436,'1','307',1,'Retail Sale Id 1435',0.00,850.50,740.00,999.00,148.50,'2023-01-29 11:00:42'),(1437,'1','307',1,'Retail Sale Id 1436',0.00,1890.00,740.00,2220.00,330.00,'2023-01-29 11:03:27'),(1438,'1','307',1,'Retail Sale Id 1437',0.00,3786.30,740.00,4447.40,661.10,'2023-01-29 11:25:56'),(1439,'1','307',1,'Retail Sale Id 1438',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-29 11:42:20'),(1440,'1','307',1,'Retail Sale Id 1439',0.00,2129.40,740.00,2501.20,371.80,'2023-01-29 11:53:48'),(1441,'1','307',1,'Retail Sale Id 1440',0.00,1915.20,740.00,2249.60,334.40,'2023-01-29 11:55:03'),(1442,'1','307',1,'Retail Sale Id 1441',0.00,1278.90,740.00,1502.20,223.30,'2023-01-29 11:57:08'),(1443,'1','307',1,'Retail Sale Id 1442',0.00,1890.00,740.00,2220.00,330.00,'2023-01-29 12:06:18'),(1444,'1','307',1,'Retail Sale Id 1443',0.00,3786.30,740.00,4447.40,661.10,'2023-01-29 12:47:17'),(1445,'1','307',1,'Retail Sale Id 1444',0.00,3150.00,740.00,3700.00,550.00,'2023-01-29 12:53:47'),(1446,'1','307',1,'Retail Sale Id 1445',0.00,6300.00,740.00,7400.00,1100.00,'2023-01-29 13:39:13'),(1447,'1','307',1,'Retail Sale Id 1446',0.00,2129.40,740.00,2501.20,371.80,'2023-01-29 14:01:39'),(1448,'1','307',1,'Retail Sale Id 1447',0.00,2520.00,740.00,2960.00,440.00,'2023-01-29 14:08:21'),(1449,'1','307',1,'Retail Sale Id 1448',0.00,3786.30,740.00,4447.40,661.10,'2023-01-29 14:11:35'),(1450,'1','307',1,'Retail Sale Id 1449',0.00,3150.00,740.00,3700.00,550.00,'2023-01-29 14:20:00'),(1451,'1','307',1,'Retail Sale Id 1450',0.00,1278.90,740.00,1502.20,223.30,'2023-01-29 14:22:14'),(1452,'1','307',1,'Retail Sale Id 1451',0.00,3786.30,740.00,4447.40,661.10,'2023-01-29 14:30:19'),(1453,'1','307',1,'Retail Sale Id 1452',0.00,3150.00,740.00,3700.00,550.00,'2023-01-29 15:21:33'),(1454,'1','307',1,'Retail Sale Id 1453',0.00,636.30,740.00,747.40,111.10,'2023-01-29 15:34:53'),(1455,'1','307',1,'Retail Sale Id 1454',0.00,1915.20,740.00,2249.60,334.40,'2023-01-29 15:36:39'),(1456,'1','307',1,'Retail Sale Id 1455',0.00,3786.30,740.00,4447.40,661.10,'2023-01-29 15:39:31'),(1457,'1','307',1,'Retail Sale Id 1456',0.00,3150.00,740.00,3700.00,550.00,'2023-01-29 15:40:22'),(1458,'1','307',1,'Retail Sale Id 1457',0.00,3780.00,740.00,4440.00,660.00,'2023-01-29 15:51:55'),(1459,'1','307',1,'Retail Sale Id 1458',0.00,78750.00,700.00,87500.00,8750.00,'2023-01-29 16:28:40'),(1460,'1','307',1,'Retail Sale Id 1459',0.00,850.50,740.00,999.00,148.50,'2023-01-29 16:45:13'),(1461,'1','307',1,'Retail Sale Id 1460',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-29 17:20:28'),(1462,'1','307',1,'Retail Sale Id 1461',0.00,3786.30,740.00,4447.40,661.10,'2023-01-29 17:29:29'),(1463,'1','307',1,'Retail Sale Id 1462',0.00,63000.00,700.00,70000.00,7000.00,'2023-01-29 17:41:21'),(1464,'1','307',1,'Retail Sale Id 1463',0.00,1871.10,740.00,2197.80,326.70,'2023-01-29 17:43:05'),(1465,'1','307',1,'Retail Sale Id 1464',0.00,1915.20,740.00,2249.60,334.40,'2023-01-29 17:45:50'),(1466,'1','307',1,'Retail Sale Id 1465',0.00,1278.90,740.00,1502.20,223.30,'2023-01-29 17:51:31'),(1467,'1','307',1,'Retail Sale Id 1466',0.00,768.60,740.00,902.80,134.20,'2023-01-29 17:58:32'),(1468,'1','307',1,'Retail Sale Id 1467',0.00,3786.30,740.00,4447.40,661.10,'2023-01-29 18:11:25'),(1469,'1','307',1,'Retail Sale Id 1468',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-29 18:13:15'),(1470,'1','307',1,'Retail Sale Id 1469',0.00,3786.30,740.00,4447.40,661.10,'2023-01-29 18:19:19'),(1471,'1','307',1,'Retail Sale Id 1470',0.00,2551.50,740.00,2997.00,445.50,'2023-01-29 18:35:41'),(1472,'1','307',1,'Retail Sale Id 1471',0.00,1278.90,740.00,1502.20,223.30,'2023-01-29 18:36:54'),(1473,'1','307',1,'Retail Sale Id 1472',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-29 18:51:09'),(1474,'1','307',1,'Retail Sale Id 1473',0.00,10420.20,740.00,12239.60,1819.40,'2023-01-29 19:08:35'),(1475,'1','307',1,'Retail Sale Id 1474',0.00,3786.30,740.00,4447.40,661.10,'2023-01-30 07:13:51'),(1476,'1','307',1,'Retail Sale Id 1475',0.00,1915.20,740.00,2249.60,334.40,'2023-01-30 07:30:19'),(1477,'1','307',1,'Retail Sale Id 1476',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-30 07:31:27'),(1478,'1','307',1,'Retail Sale Id 1477',0.00,3786.30,740.00,4447.40,661.10,'2023-01-30 07:35:04'),(1479,'1','307',1,'Retail Sale Id 1478',0.00,2551.50,740.00,2997.00,445.50,'2023-01-30 07:37:58'),(1480,'1','307',1,'Retail Sale Id 1479',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-30 08:24:08'),(1481,'1','307',1,'Retail Sale Id 1480',0.00,3786.30,740.00,4447.40,661.10,'2023-01-30 08:24:46'),(1482,'1','307',1,'Retail Sale Id 1481',0.00,3792.60,740.00,4454.80,662.20,'2023-01-30 08:53:06'),(1483,'1','307',1,'Retail Sale Id 1482',0.00,3786.30,740.00,4447.40,661.10,'2023-01-30 08:55:29'),(1484,'1','307',1,'Retail Sale Id 1483',0.00,768.60,740.00,902.80,134.20,'2023-01-30 09:27:58'),(1485,'1','307',1,'Retail Sale Id 1484',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-30 10:44:55'),(1486,'1','307',1,'Retail Sale Id 1485',0.00,2551.50,740.00,2997.00,445.50,'2023-01-30 11:06:09'),(1487,'1','307',1,'Retail Sale Id 1486',0.00,3150.00,740.00,3700.00,550.00,'2023-01-30 11:30:16'),(1488,'1','307',1,'Retail Sale Id 1487',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-30 11:40:57'),(1489,'1','307',1,'Retail Sale Id 1488',0.00,3150.00,740.00,3700.00,550.00,'2023-01-30 12:24:46'),(1490,'1','307',1,'Retail Sale Id 1489',0.00,1260.00,740.00,1480.00,220.00,'2023-01-30 12:27:48'),(1491,'1','307',1,'Retail Sale Id 1490',0.00,1959.30,740.00,2301.40,342.10,'2023-01-30 12:34:44'),(1492,'1','307',1,'Retail Sale Id 1491',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-30 12:36:25'),(1493,'1','307',1,'Retail Sale Id 1492',0.00,2551.50,740.00,2997.00,445.50,'2023-01-30 12:44:37'),(1494,'1','307',1,'Retail Sale Id 1493',0.00,3786.30,740.00,4447.40,661.10,'2023-01-30 14:10:42'),(1495,'1','307',1,'Retail Sale Id 1494',0.00,3786.30,740.00,4447.40,661.10,'2023-01-30 14:41:43'),(1496,'1','307',1,'Retail Sale Id 1495',0.00,2551.50,740.00,2997.00,445.50,'2023-01-30 15:30:56'),(1497,'1','307',1,'Retail Sale Id 1496',0.00,1278.90,740.00,1502.20,223.30,'2023-01-30 16:01:19'),(1498,'1','307',1,'Retail Sale Id 1497',0.00,680.40,740.00,799.20,118.80,'2023-01-30 16:14:36'),(1499,'1','307',1,'Retail Sale Id 1498',0.00,1278.90,740.00,1502.20,223.30,'2023-01-30 16:16:25'),(1500,'1','307',1,'Retail Sale Id 1499',0.00,3786.30,740.00,4447.40,661.10,'2023-01-30 16:34:35'),(1501,'1','307',1,'Retail Sale Id 1500',0.00,3408.30,740.00,4003.40,595.10,'2023-01-30 16:40:01'),(1502,'1','307',1,'Retail Sale Id 1500',0.00,4258.80,740.00,5002.40,743.60,'2023-01-30 16:40:01'),(1503,'1','307',1,'Retail Sale Id 1501',0.00,2979.90,740.00,3500.20,520.30,'2023-01-30 16:55:37'),(1504,'1','307',1,'Retail Sale Id 1502',0.00,2551.50,740.00,2997.00,445.50,'2023-01-30 16:57:24'),(1505,'1','307',1,'Retail Sale Id 1503',0.00,1278.90,740.00,1502.20,223.30,'2023-01-30 17:10:18'),(1506,'1','307',1,'Retail Sale Id 1504',0.00,2551.50,740.00,2997.00,445.50,'2023-01-30 17:25:36'),(1507,'1','307',1,'Retail Sale Id 1505',0.00,2551.50,740.00,2997.00,445.50,'2023-01-30 17:32:44'),(1508,'1','307',1,'Retail Sale Id 1506',0.00,1701.00,740.00,1998.00,297.00,'2023-01-30 17:45:27'),(1509,'1','307',1,'Retail Sale Id 1507',0.00,1915.20,740.00,2249.60,334.40,'2023-01-30 17:47:24'),(1510,'1','307',1,'Retail Sale Id 1508',0.00,1915.20,740.00,2249.60,334.40,'2023-01-30 17:49:58'),(1511,'1','307',1,'Retail Sale Id 1509',0.00,2551.50,740.00,2997.00,445.50,'2023-01-30 18:00:48'),(1512,'1','307',1,'Retail Sale Id 1510',0.00,3786.30,740.00,4447.40,661.10,'2023-01-30 18:04:30'),(1513,'1','307',1,'Retail Sale Id 1511',0.00,3150.00,740.00,3700.00,550.00,'2023-01-30 18:10:37'),(1514,'1','307',1,'Retail Sale Id 1512',0.00,2551.50,740.00,2997.00,445.50,'2023-01-30 18:17:48'),(1515,'1','307',1,'Retail Sale Id 1513',0.00,598.50,740.00,703.00,104.50,'2023-01-30 18:19:17'),(1516,'1','307',1,'Retail Sale Id 1514',0.00,31500.00,700.00,35000.00,3500.00,'2023-01-30 18:22:00'),(1517,'1','307',1,'Retail Sale Id 1515',0.00,1278.90,740.00,1502.20,223.30,'2023-01-30 18:24:28'),(1518,'1','307',1,'Retail Sale Id 1516',0.00,636.30,740.00,747.40,111.10,'2023-01-30 18:25:37'),(1519,'1','307',1,'Retail Sale Id 1517',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-30 18:59:33'),(1520,'1','307',1,'Retail Sale Id 1518',0.00,1530.90,740.00,1798.20,267.30,'2023-01-30 19:00:39'),(1521,'1','307',1,'Retail Sale Id 1519',0.00,1694.70,740.00,1990.60,295.90,'2023-01-30 19:12:51'),(1522,'1','307',1,'Retail Sale Id 1520',0.00,3786.30,740.00,4447.40,661.10,'2023-01-31 07:34:42'),(1523,'1','307',1,'Retail Sale Id 1521',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-31 07:56:09'),(1524,'1','307',1,'Retail Sale Id 1522',0.00,1701.00,740.00,1998.00,297.00,'2023-01-31 08:16:50'),(1525,'1','307',1,'Retail Sale Id 1523',0.00,1278.90,740.00,1502.20,223.30,'2023-01-31 08:18:31'),(1526,'1','307',1,'Retail Sale Id 1524',0.00,2551.50,740.00,2997.00,445.50,'2023-01-31 08:23:06'),(1527,'1','307',1,'Retail Sale Id 1525',0.00,63000.00,700.00,70000.00,7000.00,'2023-01-31 08:49:00'),(1528,'1','307',1,'Retail Sale Id 1526',0.00,28350.00,700.00,31500.00,3150.00,'2023-01-31 09:02:53'),(1529,'1','307',1,'Retail Sale Id 1527',0.00,1278.90,740.00,1502.20,223.30,'2023-01-31 09:11:12'),(1530,'1','307',1,'Retail Sale Id 1528',0.00,1278.90,740.00,1502.20,223.30,'2023-01-31 09:12:22'),(1531,'1','307',1,'Retail Sale Id 1529',0.00,1915.20,740.00,2249.60,334.40,'2023-01-31 09:36:33'),(1532,'1','307',1,'Retail Sale Id 1530',0.00,1890.00,740.00,2220.00,330.00,'2023-01-31 09:55:04'),(1533,'1','307',1,'Retail Sale Id 1531',0.00,2551.50,740.00,2997.00,445.50,'2023-01-31 10:00:46'),(1534,'1','307',1,'Retail Sale Id 1532',0.00,1890.00,740.00,2220.00,330.00,'2023-01-31 10:32:33'),(1535,'1','307',1,'Retail Sale Id 1533',0.00,1260.00,740.00,1480.00,220.00,'2023-01-31 11:59:03'),(1536,'1','307',1,'Retail Sale Id 1534',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-31 12:22:47'),(1537,'1','307',1,'Retail Sale Id 1535',0.00,126000.00,700.00,140000.00,14000.00,'2023-01-31 12:28:08'),(1538,'1','307',1,'Retail Sale Id 1536',0.00,1890.00,740.00,2220.00,330.00,'2023-01-31 12:35:26'),(1539,'1','307',1,'Retail Sale Id 1537',0.00,3150.00,740.00,3700.00,550.00,'2023-01-31 13:34:48'),(1540,'1','307',1,'Retail Sale Id 1538',0.00,680.40,740.00,799.20,118.80,'2023-01-31 14:01:03'),(1541,'1','307',1,'Retail Sale Id 1539',0.00,1915.20,740.00,2249.60,334.40,'2023-01-31 14:55:37'),(1542,'1','307',1,'Retail Sale Id 1540',0.00,8259.30,740.00,9701.40,1442.10,'2023-01-31 15:38:09'),(1543,'1','307',1,'Retail Sale Id 1541',0.00,3786.30,740.00,4447.40,661.10,'2023-01-31 17:29:21'),(1544,'1','307',1,'Retail Sale Id 1542',0.00,3786.30,740.00,4447.40,661.10,'2023-01-31 17:45:41'),(1545,'1','307',1,'Retail Sale Id 1543',0.00,7875.00,740.00,9250.00,1375.00,'2023-01-31 17:56:55'),(1546,'1','307',1,'Retail Sale Id 1544',0.00,1278.90,740.00,1502.20,223.30,'2023-01-31 18:14:42'),(1547,'1','307',1,'Retail Sale Id 1545',0.00,1701.00,740.00,1998.00,297.00,'2023-01-31 18:25:18'),(1548,'1','307',1,'Retail Sale Id 1545',0.00,2551.50,740.00,2997.00,445.50,'2023-01-31 18:25:18'),(1549,'1','307',1,'Retail Sale Id 1546',0.00,1278.90,740.00,1502.20,223.30,'2023-01-31 18:38:48'),(1550,'1','307',1,'Retail Sale Id 1547',0.00,3786.30,740.00,4447.40,661.10,'2023-01-31 18:41:09'),(1551,'1','307',1,'Retail Sale Id 1548',0.00,1890.00,740.00,2220.00,330.00,'2023-01-31 18:47:44'),(1552,'1','307',1,'Retail Sale Id 1550',0.00,4214.70,740.00,4950.60,735.90,'2023-01-31 19:06:57'),(1553,'1','307',1,'Retail Sale Id 1551',0.00,4258.80,740.00,5002.40,743.60,'2023-02-01 07:25:40'),(1554,'1','307',1,'Retail Sale Id 1552',0.00,3150.00,740.00,3700.00,550.00,'2023-02-01 07:27:28'),(1555,'1','307',1,'Retail Sale Id 1553',0.00,1278.90,740.00,1502.20,223.30,'2023-02-01 07:50:34'),(1556,'1','307',1,'Retail Sale Id 1555',0.00,3780.00,740.00,4440.00,660.00,'2023-02-01 07:52:54'),(1557,'1','307',1,'Retail Sale Id 1556',0.00,3408.30,740.00,4003.40,595.10,'2023-02-01 07:53:41'),(1558,'1','307',1,'Retail Sale Id 1557',0.00,1278.90,740.00,1502.20,223.30,'2023-02-01 08:30:01'),(1559,'1','307',1,'Retail Sale Id 1558',0.00,3786.30,740.00,4447.40,661.10,'2023-02-01 09:14:17'),(1560,'1','307',1,'Retail Sale Id 1559',0.00,5109.30,740.00,6001.40,892.10,'2023-02-01 09:16:32'),(1561,'1','307',1,'Retail Sale Id 1560',0.00,7578.90,740.00,8902.20,1323.30,'2023-02-01 09:17:57'),(1562,'1','307',1,'Retail Sale Id 1561',0.00,3786.30,740.00,4447.40,661.10,'2023-02-01 09:18:53'),(1563,'1','307',1,'Retail Sale Id 1562',0.00,31500.00,700.00,35000.00,3500.00,'2023-02-01 09:41:07'),(1564,'1','307',1,'Retail Sale Id 1563',0.00,3786.30,740.00,4447.40,661.10,'2023-02-01 10:25:04'),(1565,'1','307',1,'Retail Sale Id 1564',0.00,1278.90,740.00,1502.20,223.30,'2023-02-01 10:49:58'),(1566,'1','307',1,'Retail Sale Id 1565',0.00,1890.00,740.00,2220.00,330.00,'2023-02-01 10:53:29'),(1567,'1','307',1,'Retail Sale Id 1566',0.00,78750.00,700.00,87500.00,8750.00,'2023-02-01 10:57:06'),(1568,'1','307',1,'Retail Sale Id 1567',0.00,3150.00,740.00,3700.00,550.00,'2023-02-01 11:04:58'),(1569,'1','307',1,'Retail Sale Id 1568',0.00,1278.90,740.00,1502.20,223.30,'2023-02-01 11:05:33'),(1570,'1','307',1,'Retail Sale Id 1569',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-01 12:55:55'),(1571,'1','307',1,'Retail Sale Id 1570',0.00,1260.00,740.00,1480.00,220.00,'2023-02-01 14:55:17'),(1572,'1','307',1,'Retail Sale Id 1571',0.00,2551.50,740.00,2997.00,445.50,'2023-02-01 14:56:41'),(1573,'1','307',1,'Retail Sale Id 1572',0.00,3786.30,740.00,4447.40,661.10,'2023-02-01 15:01:18'),(1574,'1','307',1,'Retail Sale Id 1573',0.00,1890.00,740.00,2220.00,330.00,'2023-02-01 15:13:01'),(1575,'1','307',1,'Retail Sale Id 1574',0.00,1278.90,740.00,1502.20,223.30,'2023-02-01 15:20:55'),(1576,'1','307',1,'Retail Sale Id 1575',0.00,94500.00,700.00,105000.00,10500.00,'2023-02-01 16:15:43'),(1577,'1','307',1,'Retail Sale Id 1576',0.00,3786.30,740.00,4447.40,661.10,'2023-02-01 17:50:52'),(1578,'1','307',1,'Retail Sale Id 1577',0.00,3150.00,740.00,3700.00,550.00,'2023-02-01 17:51:49'),(1579,'1','307',1,'Retail Sale Id 1578',0.00,1890.00,740.00,2220.00,330.00,'2023-02-01 17:52:53'),(1580,'1','307',1,'Retail Sale Id 1579',0.00,636.30,740.00,747.40,111.10,'2023-02-01 18:00:00'),(1581,'1','307',1,'Retail Sale Id 1580',0.00,31500.00,700.00,35000.00,3500.00,'2023-02-01 18:07:56'),(1582,'1','307',1,'Retail Sale Id 1581',0.00,1915.20,740.00,2249.60,334.40,'2023-02-01 18:14:22'),(1583,'1','307',1,'Retail Sale Id 1582',0.00,3408.30,740.00,4003.40,595.10,'2023-02-01 18:15:27'),(1584,'1','307',1,'Retail Sale Id 1583',0.00,1278.90,740.00,1502.20,223.30,'2023-02-01 18:16:10'),(1585,'1','307',1,'Retail Sale Id 1584',0.00,1278.90,740.00,1502.20,223.30,'2023-02-01 18:24:06'),(1586,'1','307',1,'Retail Sale Id 1585',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-01 18:26:19'),(1587,'1','307',1,'Retail Sale Id 1586',0.00,1915.20,740.00,2249.60,334.40,'2023-02-01 18:31:07'),(1588,'1','307',1,'Retail Sale Id 1587',0.00,3786.30,740.00,4447.40,661.10,'2023-02-01 18:32:11'),(1589,'1','307',1,'Retail Sale Id 1588',0.00,636.30,740.00,747.40,111.10,'2023-02-01 18:36:01'),(1590,'1','307',1,'Retail Sale Id 1590',0.00,2520.00,740.00,2960.00,440.00,'2023-02-01 18:41:53'),(1591,'1','307',1,'Retail Sale Id 1591',0.00,2551.50,740.00,2997.00,445.50,'2023-02-01 18:46:42'),(1592,'1','307',1,'Retail Sale Id 1592',0.00,31500.00,700.00,35000.00,3500.00,'2023-02-01 18:50:40'),(1593,'1','307',1,'Retail Sale Id 1593',0.00,1278.90,740.00,1502.20,223.30,'2023-02-01 18:51:30'),(1594,'1','307',1,'Retail Sale Id 1594',0.00,20871.90,740.00,24516.20,3644.30,'2023-02-01 19:12:01'),(1595,'1','307',1,'Retail Sale Id 1595',0.00,13929.30,740.00,16361.40,2432.10,'2023-02-01 19:34:35'),(1596,'1','307',1,'Sale Id 3',0.00,27008.10,740.00,31723.80,4715.70,'2023-02-02 07:32:28'),(1608,'1','307',1,'Retail Sale Id 1608',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-02 13:46:13'),(1609,'1','307',1,'Retail Sale Id 1609',0.00,63963.90,740.00,75132.20,11168.30,'2023-02-02 14:32:10'),(1610,'1','307',1,'Retail Sale Id 1610',0.00,63000.00,700.00,70000.00,7000.00,'2023-02-02 14:34:32'),(1611,'1','307',1,'Retail Sale Id 1611',0.00,45901.80,700.00,51002.00,5100.20,'2023-02-02 14:36:24'),(1612,'1','307',1,'Retail Sale Id 1612',0.00,3786.30,740.00,4447.40,661.10,'2023-02-02 14:51:57'),(1613,'1','307',1,'Retail Sale Id 1613',0.00,3150.00,740.00,3700.00,550.00,'2023-02-02 15:19:49'),(1614,'1','307',1,'Retail Sale Id 1614',0.00,1890.00,740.00,2220.00,330.00,'2023-02-02 15:29:55'),(1615,'1','307',1,'Retail Sale Id 1615',0.00,3150.00,740.00,3700.00,550.00,'2023-02-02 15:30:35'),(1616,'1','307',1,'Retail Sale Id 1616',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-02 16:00:58'),(1617,'1','307',1,'Retail Sale Id 1617',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-02 16:03:06'),(1618,'1','307',1,'Retail Sale Id 1618',0.00,680.40,740.00,799.20,118.80,'2023-02-02 16:21:31'),(1619,'1','307',1,'Retail Sale Id 1619',0.00,1278.90,740.00,1502.20,223.30,'2023-02-02 16:43:39'),(1620,'1','307',1,'Retail Sale Id 1620',0.00,3150.00,740.00,3700.00,550.00,'2023-02-02 16:55:32'),(1621,'1','307',1,'Retail Sale Id 1621',0.00,1701.00,740.00,1998.00,297.00,'2023-02-02 17:07:08'),(1622,'1','307',1,'Retail Sale Id 1622',0.00,3786.30,740.00,4447.40,661.10,'2023-02-02 17:21:41'),(1623,'1','307',1,'Retail Sale Id 1623',0.00,1701.00,740.00,1998.00,297.00,'2023-02-02 17:23:31'),(1624,'1','307',1,'Retail Sale Id 1624',0.00,1278.90,740.00,1502.20,223.30,'2023-02-02 17:50:07'),(1625,'1','307',1,'Retail Sale Id 1625',0.00,3786.30,740.00,4447.40,661.10,'2023-02-02 18:02:20'),(1626,'1','307',1,'Retail Sale Id 1627',0.00,1915.20,740.00,2249.60,334.40,'2023-02-02 18:22:26'),(1627,'1','307',1,'Retail Sale Id 1628',0.00,2551.50,740.00,2997.00,445.50,'2023-02-02 18:37:17'),(1628,'1','307',1,'Retail Sale Id 1629',0.00,636.30,740.00,747.40,111.10,'2023-02-02 18:39:38'),(1629,'1','307',1,'Retail Sale Id 1630',0.00,4258.80,740.00,5002.40,743.60,'2023-02-02 18:41:11'),(1630,'1','307',1,'Retail Sale Id 1631',0.00,5670.00,740.00,6660.00,990.00,'2023-02-02 19:09:45'),(1631,'1','307',1,'Retail Sale Id 1632',0.00,3150.00,740.00,3700.00,550.00,'2023-02-02 19:26:40'),(1632,'1','307',1,'Retail Sale Id 1633',0.00,3786.30,740.00,4447.40,661.10,'2023-02-03 07:41:00'),(1633,'1','307',1,'Retail Sale Id 1634',0.00,1278.90,740.00,1502.20,223.30,'2023-02-03 07:47:20'),(1634,'1','307',1,'Retail Sale Id 1635',0.00,3408.30,740.00,4003.40,595.10,'2023-02-03 08:19:28'),(1635,'1','307',1,'Retail Sale Id 1636',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-03 08:44:29'),(1636,'1','307',1,'Retail Sale Id 1637',0.00,3408.30,740.00,4003.40,595.10,'2023-02-03 09:07:18'),(1637,'1','307',1,'Retail Sale Id 1638',0.00,636.30,740.00,747.40,111.10,'2023-02-03 09:26:32'),(1638,'1','307',1,'Retail Sale Id 1639',0.00,1915.20,740.00,2249.60,334.40,'2023-02-03 09:35:18'),(1639,'1','307',1,'Retail Sale Id 1640',0.00,3786.30,740.00,4447.40,661.10,'2023-02-03 09:48:47'),(1640,'1','307',1,'Retail Sale Id 1641',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-03 09:55:06'),(1641,'1','307',1,'Retail Sale Id 1642',0.00,1278.90,740.00,1502.20,223.30,'2023-02-03 10:30:01'),(1642,'1','307',1,'Retail Sale Id 1643',0.00,3150.00,740.00,3700.00,550.00,'2023-02-03 11:00:40'),(1643,'1','307',1,'Retail Sale Id 1644',0.00,3150.00,740.00,3700.00,550.00,'2023-02-03 11:05:22'),(1644,'1','307',1,'Retail Sale Id 1645',0.00,3786.30,740.00,4447.40,661.10,'2023-02-03 11:16:30'),(1645,'1','307',1,'Retail Sale Id 1646',0.00,126000.00,700.00,140000.00,14000.00,'2023-02-03 11:18:14'),(1646,'1','307',1,'Retail Sale Id 1647',0.00,63000.00,700.00,70000.00,7000.00,'2023-02-03 11:27:34'),(1647,'1','307',1,'Retail Sale Id 1648',0.00,1890.00,740.00,2220.00,330.00,'2023-02-03 11:29:20'),(1648,'1','307',1,'Retail Sale Id 1649',0.00,1915.20,740.00,2249.60,334.40,'2023-02-03 12:04:58'),(1649,'1','307',1,'Retail Sale Id 1650',0.00,3408.30,740.00,4003.40,595.10,'2023-02-03 12:12:02'),(1650,'1','307',1,'Retail Sale Id 1651',0.00,850.50,740.00,999.00,148.50,'2023-02-03 12:13:15'),(1651,'1','307',1,'Retail Sale Id 1652',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-03 12:40:18'),(1652,'1','307',1,'Retail Sale Id 1653',0.00,31500.00,700.00,35000.00,3500.00,'2023-02-03 12:43:20'),(1653,'1','307',1,'Retail Sale Id 1654',0.00,1701.00,740.00,1998.00,297.00,'2023-02-03 12:53:44'),(1654,'1','307',1,'Retail Sale Id 1655',0.00,1915.20,740.00,2249.60,334.40,'2023-02-03 13:02:58'),(1655,'1','307',1,'Retail Sale Id 1656',0.00,636.30,740.00,747.40,111.10,'2023-02-03 13:04:49'),(1656,'1','307',1,'Retail Sale Id 1657',0.00,1278.90,740.00,1502.20,223.30,'2023-02-03 13:08:25'),(1657,'1','307',1,'Retail Sale Id 1658',0.00,636.30,740.00,747.40,111.10,'2023-02-03 14:02:52'),(1658,'1','307',1,'Retail Sale Id 1659',0.00,850.50,740.00,999.00,148.50,'2023-02-03 14:11:57'),(1659,'1','307',1,'Retail Sale Id 1660',0.00,636.30,740.00,747.40,111.10,'2023-02-03 14:35:05'),(1660,'1','307',1,'Retail Sale Id 1662',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-03 14:54:41'),(1661,'1','307',1,'Retail Sale Id 1663',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-03 15:22:49'),(1662,'1','307',1,'Retail Sale Id 1664',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-03 15:35:57'),(1663,'1','307',1,'Retail Sale Id 1665',0.00,1278.90,740.00,1502.20,223.30,'2023-02-03 15:56:16'),(1664,'1','307',1,'Retail Sale Id 1666',0.00,1701.00,740.00,1998.00,297.00,'2023-02-03 16:01:47'),(1665,'1','307',1,'Retail Sale Id 1667',0.00,3786.30,740.00,4447.40,661.10,'2023-02-03 16:21:02'),(1666,'1','307',1,'Retail Sale Id 1668',0.00,78750.00,700.00,87500.00,8750.00,'2023-02-03 16:44:26'),(1667,'1','307',1,'Retail Sale Id 1669',0.00,1530.90,740.00,1798.20,267.30,'2023-02-03 16:54:52'),(1668,'1','307',1,'Retail Sale Id 1670',0.00,1278.90,740.00,1502.20,223.30,'2023-02-03 17:06:29'),(1669,'1','307',1,'Retail Sale Id 1670',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-03 17:06:29'),(1670,'1','307',1,'Retail Sale Id 1671',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-03 17:13:41'),(1671,'1','307',1,'Retail Sale Id 1672',0.00,12600.00,740.00,14800.00,2200.00,'2023-02-03 17:40:35'),(1672,'1','307',1,'Retail Sale Id 1674',0.00,3786.30,740.00,4447.40,661.10,'2023-02-03 17:46:48'),(1673,'1','307',1,'Retail Sale Id 1675',0.00,1890.00,740.00,2220.00,330.00,'2023-02-03 17:58:31'),(1674,'1','307',1,'Retail Sale Id 1675',0.00,2520.00,740.00,2960.00,440.00,'2023-02-03 17:58:31'),(1675,'1','307',1,'Retail Sale Id 1677',0.00,1278.90,740.00,1502.20,223.30,'2023-02-03 18:00:24'),(1676,'1','307',1,'Retail Sale Id 1679',0.00,1020.60,740.00,1198.80,178.20,'2023-02-03 18:10:03'),(1677,'1','307',1,'Retail Sale Id 1680',0.00,3150.00,740.00,3700.00,550.00,'2023-02-03 18:13:36'),(1678,'1','307',1,'Retail Sale Id 1683',0.00,636.30,740.00,747.40,111.10,'2023-02-03 18:42:02'),(1679,'1','307',1,'Retail Sale Id 1684',0.00,1701.00,740.00,1998.00,297.00,'2023-02-04 08:08:39'),(1680,'1','307',1,'Retail Sale Id 1684',0.00,1701.00,740.00,1998.00,297.00,'2023-02-04 08:08:39'),(1681,'1','307',1,'Retail Sale Id 1685',0.00,2299.50,740.00,2701.00,401.50,'2023-02-04 08:10:53'),(1682,'1','307',1,'Retail Sale Id 1686',0.00,3150.00,740.00,3700.00,550.00,'2023-02-04 08:25:51'),(1683,'1','307',1,'Retail Sale Id 1687',0.00,1278.90,740.00,1502.20,223.30,'2023-02-04 08:27:01'),(1684,'1','307',1,'Retail Sale Id 1688',0.00,1020.60,740.00,1198.80,178.20,'2023-02-04 08:43:32'),(1685,'1','307',1,'Retail Sale Id 1689',0.00,1278.90,740.00,1502.20,223.30,'2023-02-04 08:49:01'),(1686,'1','307',1,'Retail Sale Id 1690',0.00,31500.00,700.00,35000.00,3500.00,'2023-02-04 09:16:23'),(1687,'1','307',1,'Retail Sale Id 1691',0.00,2551.50,740.00,2997.00,445.50,'2023-02-04 09:46:22'),(1688,'1','307',1,'Retail Sale Id 1691',0.00,3786.30,740.00,4447.40,661.10,'2023-02-04 09:46:22'),(1689,'1','307',1,'Retail Sale Id 1691',0.00,3786.30,740.00,4447.40,661.10,'2023-02-04 09:46:22'),(1690,'1','307',1,'Retail Sale Id 1692',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-04 10:10:45'),(1691,'1','307',1,'Retail Sale Id 1693',0.00,2551.50,740.00,2997.00,445.50,'2023-02-04 10:20:10'),(1692,'1','307',1,'Retail Sale Id 1694',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-04 10:53:59'),(1693,'1','307',1,'Retail Sale Id 1695',0.00,1278.90,740.00,1502.20,223.30,'2023-02-04 11:05:01'),(1694,'1','307',1,'Retail Sale Id 1696',0.00,3786.30,740.00,4447.40,661.10,'2023-02-04 11:15:11'),(1695,'1','307',1,'Retail Sale Id 1697',0.00,1278.90,740.00,1502.20,223.30,'2023-02-04 12:06:39'),(1696,'1','307',1,'Retail Sale Id 1698',0.00,3150.00,740.00,3700.00,550.00,'2023-02-04 12:16:10'),(1697,'1','307',1,'Retail Sale Id 1699',0.00,2551.50,740.00,2997.00,445.50,'2023-02-04 12:18:12'),(1698,'1','307',1,'Retail Sale Id 1700',0.00,3780.00,740.00,4440.00,660.00,'2023-02-04 12:25:20'),(1699,'1','307',1,'Retail Sale Id 1701',0.00,1020.60,740.00,1198.80,178.20,'2023-02-04 12:48:44'),(1700,'1','307',1,'Retail Sale Id 1702',0.00,4428.90,740.00,5202.20,773.30,'2023-02-04 12:56:45'),(1701,'1','307',1,'Retail Sale Id 1703',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-04 13:04:28'),(1702,'1','307',1,'Retail Sale Id 1704',0.00,1278.90,740.00,1502.20,223.30,'2023-02-04 13:09:41'),(1703,'1','307',1,'Retail Sale Id 1705',0.00,3786.30,740.00,4447.40,661.10,'2023-02-04 13:28:51'),(1704,'1','307',1,'Retail Sale Id 1706',0.00,3786.30,740.00,4447.40,661.10,'2023-02-04 13:30:23'),(1705,'1','307',1,'Retail Sale Id 1707',0.00,31500.00,700.00,35000.00,3500.00,'2023-02-04 13:35:07'),(1706,'1','307',1,'Retail Sale Id 1708',0.00,1915.20,740.00,2249.60,334.40,'2023-02-04 13:45:51'),(1707,'1','307',1,'Retail Sale Id 1709',0.00,1278.90,740.00,1502.20,223.30,'2023-02-04 13:49:43'),(1708,'1','307',1,'Retail Sale Id 1710',0.00,680.40,740.00,799.20,118.80,'2023-02-04 13:58:02'),(1709,'1','307',1,'Retail Sale Id 1711',0.00,636.30,740.00,747.40,111.10,'2023-02-04 15:08:14'),(1710,'1','307',1,'Retail Sale Id 1712',0.00,31500.00,700.00,35000.00,3500.00,'2023-02-04 15:41:39'),(1711,'1','307',1,'Retail Sale Id 1713',0.00,3786.30,740.00,4447.40,661.10,'2023-02-04 16:01:42'),(1712,'1','307',1,'Retail Sale Id 1714',0.00,3786.30,740.00,4447.40,661.10,'2023-02-04 16:18:35'),(1713,'1','307',1,'Retail Sale Id 1715',0.00,3786.30,740.00,4447.40,661.10,'2023-02-04 16:40:10'),(1714,'1','307',1,'Retail Sale Id 1716',0.00,3786.30,740.00,4447.40,661.10,'2023-02-04 16:42:36'),(1715,'1','307',1,'Retail Sale Id 1717',0.00,1278.90,740.00,1502.20,223.30,'2023-02-04 16:43:38'),(1716,'1','307',1,'Retail Sale Id 1718',0.00,2551.50,740.00,2997.00,445.50,'2023-02-04 16:49:41'),(1717,'1','307',1,'Retail Sale Id 1719',0.00,1278.90,740.00,1502.20,223.30,'2023-02-04 16:53:38'),(1718,'1','307',1,'Retail Sale Id 1720',0.00,850.50,740.00,999.00,148.50,'2023-02-04 17:04:39'),(1719,'1','307',1,'Retail Sale Id 1721',0.00,1915.20,740.00,2249.60,334.40,'2023-02-04 17:06:46'),(1720,'1','307',1,'Retail Sale Id 1722',0.00,1915.20,740.00,2249.60,334.40,'2023-02-04 17:08:12'),(1721,'1','307',1,'Retail Sale Id 1723',0.00,3786.30,740.00,4447.40,661.10,'2023-02-04 17:09:37'),(1722,'1','307',1,'Retail Sale Id 1724',0.00,3786.30,740.00,4447.40,661.10,'2023-02-04 17:10:50'),(1723,'1','307',1,'Retail Sale Id 1725',0.00,1278.90,740.00,1502.20,223.30,'2023-02-04 17:37:42'),(1724,'1','307',1,'Retail Sale Id 1726',0.00,3408.30,740.00,4003.40,595.10,'2023-02-04 17:45:59'),(1725,'1','307',1,'Retail Sale Id 1727',0.00,4428.90,740.00,5202.20,773.30,'2023-02-04 17:53:24'),(1726,'1','307',1,'Retail Sale Id 1728',0.00,1915.20,740.00,2249.60,334.40,'2023-02-04 18:05:47'),(1727,'1','307',1,'Retail Sale Id 1729',0.00,1915.20,740.00,2249.60,334.40,'2023-02-04 18:07:42'),(1728,'1','307',1,'Retail Sale Id 1730',0.00,1915.20,740.00,2249.60,334.40,'2023-02-04 18:12:44'),(1729,'1','307',1,'Retail Sale Id 1731',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-04 18:17:59'),(1730,'1','307',1,'Retail Sale Id 1732',0.00,3150.00,740.00,3700.00,550.00,'2023-02-04 18:19:25'),(1731,'1','307',1,'Retail Sale Id 1733',0.00,3786.30,740.00,4447.40,661.10,'2023-02-04 18:22:55'),(1732,'1','307',1,'Retail Sale Id 1734',0.00,2809.80,740.00,3300.40,490.60,'2023-02-04 18:24:20'),(1733,'1','307',1,'Retail Sale Id 1735',0.00,3786.30,740.00,4447.40,661.10,'2023-02-04 18:28:42'),(1734,'1','307',1,'Retail Sale Id 1736',0.00,1701.00,740.00,1998.00,297.00,'2023-02-04 18:52:35'),(1735,'1','307',1,'Retail Sale Id 1737',0.00,1915.20,740.00,2249.60,334.40,'2023-02-04 19:10:29'),(1736,'1','307',1,'Retail Sale Id 1738',0.00,3786.30,740.00,4447.40,661.10,'2023-02-04 19:16:46'),(1737,'1','307',1,'Retail Sale Id 1738',0.00,5109.30,740.00,6001.40,892.10,'2023-02-04 19:16:46'),(1738,'1','307',1,'Retail Sale Id 1739',0.00,3761.10,740.00,4417.80,656.70,'2023-02-04 19:26:15'),(1739,'1','307',1,'Retail Sale Id 1740',0.00,3786.30,740.00,4447.40,661.10,'2023-02-05 07:41:42'),(1740,'1','307',1,'Retail Sale Id 1741',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-05 07:53:53'),(1741,'1','307',1,'Retail Sale Id 1742',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-05 08:54:37'),(1742,'1','307',1,'Retail Sale Id 1743',0.00,1890.00,740.00,2220.00,330.00,'2023-02-05 09:10:51'),(1743,'1','307',1,'Retail Sale Id 1745',0.00,1915.20,740.00,2249.60,334.40,'2023-02-05 09:17:29'),(1744,'1','307',1,'Retail Sale Id 1746',0.00,3780.00,740.00,4440.00,660.00,'2023-02-05 09:20:11'),(1745,'1','307',1,'Retail Sale Id 1747',0.00,3150.00,740.00,3700.00,550.00,'2023-02-05 09:26:47'),(1746,'1','307',1,'Retail Sale Id 1748',0.00,4258.80,740.00,5002.40,743.60,'2023-02-05 09:34:46'),(1747,'1','307',1,'Retail Sale Id 1749',0.00,2129.40,740.00,2501.20,371.80,'2023-02-05 09:49:44'),(1748,'1','307',1,'Retail Sale Id 1750',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-05 09:51:03'),(1749,'1','307',1,'Retail Sale Id 1751',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-05 10:07:03'),(1750,'1','307',1,'Retail Sale Id 1752',0.00,63000.00,700.00,70000.00,7000.00,'2023-02-05 10:10:40'),(1751,'1','307',1,'Retail Sale Id 1753',0.00,3786.30,740.00,4447.40,661.10,'2023-02-05 10:15:06'),(1752,'1','307',1,'Retail Sale Id 1754',0.00,1871.10,740.00,2197.80,326.70,'2023-02-05 10:50:19'),(1753,'1','307',1,'Retail Sale Id 1756',0.00,1915.20,740.00,2249.60,334.40,'2023-02-05 10:52:47'),(1754,'1','307',1,'Retail Sale Id 1757',0.00,1915.20,740.00,2249.60,334.40,'2023-02-05 11:03:04'),(1755,'1','307',1,'Retail Sale Id 1759',0.00,1701.00,740.00,1998.00,297.00,'2023-02-05 11:06:15'),(1756,'1','307',1,'Retail Sale Id 1760',0.00,3780.00,740.00,4440.00,660.00,'2023-02-05 11:13:57'),(1757,'1','307',1,'Retail Sale Id 1761',0.00,3780.00,740.00,4440.00,660.00,'2023-02-05 11:23:40'),(1758,'1','307',1,'Retail Sale Id 1762',0.00,4428.90,740.00,5202.20,773.30,'2023-02-05 11:30:15'),(1759,'1','307',1,'Retail Sale Id 1763',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-05 12:01:59'),(1760,'1','307',1,'Retail Sale Id 1764',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-05 12:11:55'),(1761,'1','307',1,'Retail Sale Id 1765',0.00,5109.30,740.00,6001.40,892.10,'2023-02-05 12:14:36'),(1762,'1','307',1,'Retail Sale Id 1766',0.00,1890.00,740.00,2220.00,330.00,'2023-02-05 12:21:20'),(1763,'1','307',1,'Retail Sale Id 1767',0.00,630.00,740.00,740.00,110.00,'2023-02-05 12:25:37'),(1764,'1','307',1,'Retail Sale Id 1768',0.00,3150.00,740.00,3700.00,550.00,'2023-02-05 12:28:23'),(1765,'1','307',1,'Retail Sale Id 1769',0.00,1915.20,740.00,2249.60,334.40,'2023-02-05 12:34:54'),(1766,'1','307',1,'Retail Sale Id 1770',0.00,680.40,740.00,799.20,118.80,'2023-02-05 12:35:58'),(1767,'1','307',1,'Retail Sale Id 1771',0.00,1701.00,740.00,1998.00,297.00,'2023-02-05 12:54:17'),(1768,'1','307',1,'Retail Sale Id 1772',0.00,1915.20,740.00,2249.60,334.40,'2023-02-05 12:55:57'),(1769,'1','307',1,'Retail Sale Id 1773',0.00,3150.00,740.00,3700.00,550.00,'2023-02-05 13:07:41'),(1770,'1','307',1,'Retail Sale Id 1774',0.00,1915.20,740.00,2249.60,334.40,'2023-02-05 13:25:07'),(1771,'1','307',1,'Retail Sale Id 1775',0.00,1915.20,740.00,2249.60,334.40,'2023-02-05 13:26:18'),(1772,'1','307',1,'Retail Sale Id 1776',0.00,2551.50,740.00,2997.00,445.50,'2023-02-05 13:28:05'),(1773,'1','307',1,'Retail Sale Id 1777',0.00,3786.30,740.00,4447.40,661.10,'2023-02-05 13:29:50'),(1774,'1','307',1,'Retail Sale Id 1778',0.00,1915.20,740.00,2249.60,334.40,'2023-02-05 13:34:16'),(1775,'1','307',1,'Retail Sale Id 1779',0.00,1890.00,740.00,2220.00,330.00,'2023-02-05 13:35:53'),(1776,'1','307',1,'Retail Sale Id 1780',0.00,2520.00,740.00,2960.00,440.00,'2023-02-05 13:37:57'),(1777,'1','307',1,'Retail Sale Id 1781',0.00,5040.00,740.00,5920.00,880.00,'2023-02-05 13:50:47'),(1778,'1','307',1,'Retail Sale Id 1782',0.00,2520.00,740.00,2960.00,440.00,'2023-02-05 13:51:53'),(1779,'1','307',1,'Retail Sale Id 1783',0.00,1278.90,740.00,1502.20,223.30,'2023-02-05 14:06:42'),(1780,'1','307',1,'Retail Sale Id 1784',0.00,2551.50,740.00,2997.00,445.50,'2023-02-05 14:08:02'),(1781,'1','307',1,'Retail Sale Id 1785',0.00,1278.90,740.00,1502.20,223.30,'2023-02-05 14:10:01'),(1782,'1','307',1,'Retail Sale Id 1786',0.00,1915.20,740.00,2249.60,334.40,'2023-02-05 14:34:15'),(1783,'1','307',1,'Retail Sale Id 1787',0.00,3150.00,740.00,3700.00,550.00,'2023-02-05 14:47:53'),(1784,'1','307',1,'Retail Sale Id 1788',0.00,3150.00,740.00,3700.00,550.00,'2023-02-05 14:49:11'),(1785,'1','307',1,'Retail Sale Id 1789',0.00,2551.50,740.00,2997.00,445.50,'2023-02-05 14:56:09'),(1786,'1','307',1,'Retail Sale Id 1790',0.00,1278.90,740.00,1502.20,223.30,'2023-02-05 15:08:38'),(1787,'1','307',1,'Retail Sale Id 1791',0.00,630.00,740.00,740.00,110.00,'2023-02-05 15:23:05'),(1788,'1','307',1,'Retail Sale Id 1792',0.00,3780.00,740.00,4440.00,660.00,'2023-02-05 15:24:32'),(1789,'1','307',1,'Retail Sale Id 1793',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-05 15:29:46'),(1790,'1','307',1,'Retail Sale Id 1794',0.00,1260.00,740.00,1480.00,220.00,'2023-02-05 15:35:23'),(1791,'1','307',1,'Retail Sale Id 1795',0.00,3150.00,740.00,3700.00,550.00,'2023-02-05 15:43:23'),(1792,'1','307',1,'Retail Sale Id 1796',0.00,3780.00,740.00,4440.00,660.00,'2023-02-05 15:55:36'),(1793,'1','307',1,'Retail Sale Id 1797',0.00,1260.00,740.00,1480.00,220.00,'2023-02-05 16:16:28'),(1794,'1','307',1,'Retail Sale Id 1798',0.00,1915.20,740.00,2249.60,334.40,'2023-02-05 16:31:49'),(1795,'1','307',1,'Retail Sale Id 1799',0.00,1701.00,740.00,1998.00,297.00,'2023-02-05 16:32:49'),(1796,'1','307',1,'Retail Sale Id 1800',0.00,3150.00,740.00,3700.00,550.00,'2023-02-05 16:40:30'),(1797,'1','307',1,'Retail Sale Id 1801',0.00,3780.00,740.00,4440.00,660.00,'2023-02-05 16:55:58'),(1798,'1','307',1,'Retail Sale Id 1802',0.00,78750.00,700.00,87500.00,8750.00,'2023-02-05 17:01:07'),(1799,'1','307',1,'Retail Sale Id 1803',0.00,1278.90,740.00,1502.20,223.30,'2023-02-05 17:03:36'),(1800,'1','307',1,'Retail Sale Id 1804',0.00,1890.00,740.00,2220.00,330.00,'2023-02-05 17:09:32'),(1801,'1','307',1,'Retail Sale Id 1805',0.00,1890.00,740.00,2220.00,330.00,'2023-02-05 17:13:20'),(1802,'1','307',1,'Retail Sale Id 1806',0.00,1278.90,740.00,1502.20,223.30,'2023-02-05 17:24:19'),(1803,'1','307',1,'Retail Sale Id 1807',0.00,680.40,740.00,799.20,118.80,'2023-02-05 17:30:59'),(1804,'1','307',1,'Retail Sale Id 1808',0.00,1890.00,740.00,2220.00,330.00,'2023-02-05 17:48:10'),(1805,'1','307',1,'Retail Sale Id 1809',0.00,1915.20,740.00,2249.60,334.40,'2023-02-05 17:50:05'),(1806,'1','307',1,'Retail Sale Id 1810',0.00,636.30,740.00,747.40,111.10,'2023-02-05 17:53:32'),(1807,'1','307',1,'Retail Sale Id 1811',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-05 17:59:36'),(1808,'1','307',1,'Retail Sale Id 1812',0.00,2520.00,740.00,2960.00,440.00,'2023-02-05 18:00:32'),(1809,'1','307',1,'Retail Sale Id 1813',0.00,1915.20,740.00,2249.60,334.40,'2023-02-05 18:06:13'),(1810,'1','307',1,'Retail Sale Id 1814',0.00,4258.80,740.00,5002.40,743.60,'2023-02-05 18:10:13'),(1811,'1','307',1,'Retail Sale Id 1815',0.00,3786.30,740.00,4447.40,661.10,'2023-02-05 18:20:24'),(1812,'1','307',1,'Retail Sale Id 1816',0.00,3150.00,740.00,3700.00,550.00,'2023-02-05 18:28:44'),(1813,'1','307',1,'Retail Sale Id 1817',0.00,1915.20,740.00,2249.60,334.40,'2023-02-05 18:30:25'),(1814,'1','307',1,'Retail Sale Id 1818',0.00,4410.00,740.00,5180.00,770.00,'2023-02-05 18:33:13'),(1815,'1','307',1,'Retail Sale Id 1819',0.00,2551.50,740.00,2997.00,445.50,'2023-02-05 18:34:41'),(1816,'1','307',1,'Retail Sale Id 1820',0.00,3830.40,740.00,4499.20,668.80,'2023-02-05 18:37:23'),(1817,'1','307',1,'Retail Sale Id 1821',0.00,1890.00,740.00,2220.00,330.00,'2023-02-05 18:38:49'),(1818,'1','307',1,'Retail Sale Id 1822',0.00,5065.20,740.00,5949.60,884.40,'2023-02-05 18:44:47'),(1819,'1','307',1,'Retail Sale Id 1823',0.00,3150.00,740.00,3700.00,550.00,'2023-02-06 07:25:00'),(1820,'1','307',1,'Retail Sale Id 1823',0.00,3150.00,740.00,3700.00,550.00,'2023-02-06 07:25:00'),(1821,'1','307',1,'Retail Sale Id 1824',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-06 07:28:59'),(1822,'1','307',1,'Retail Sale Id 1825',0.00,4258.80,740.00,5002.40,743.60,'2023-02-06 07:57:23'),(1823,'1','307',1,'Retail Sale Id 1826',0.00,3780.00,740.00,4440.00,660.00,'2023-02-06 08:05:31'),(1824,'1','307',1,'Retail Sale Id 1827',0.00,1915.20,740.00,2249.60,334.40,'2023-02-06 08:11:10'),(1825,'1','307',1,'Retail Sale Id 1828',0.00,850.50,740.00,999.00,148.50,'2023-02-06 08:21:23'),(1826,'1','307',1,'Retail Sale Id 1829',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-06 08:35:37'),(1827,'1','307',1,'Retail Sale Id 1830',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-06 08:57:16'),(1828,'1','307',1,'Retail Sale Id 1831',0.00,1890.00,740.00,2220.00,330.00,'2023-02-06 09:05:23'),(1829,'1','307',1,'Retail Sale Id 1832',0.00,1890.00,740.00,2220.00,330.00,'2023-02-06 09:13:10'),(1830,'1','307',1,'Retail Sale Id 1832',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-06 09:13:10'),(1831,'1','307',1,'Retail Sale Id 1833',0.00,3150.00,740.00,3700.00,550.00,'2023-02-06 09:26:53'),(1832,'1','307',1,'Retail Sale Id 1834',0.00,1871.10,740.00,2197.80,326.70,'2023-02-06 09:34:53'),(1833,'1','307',1,'Retail Sale Id 1835',0.00,126000.00,700.00,140000.00,14000.00,'2023-02-06 09:36:40'),(1834,'1','307',1,'Retail Sale Id 1836',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-06 10:11:02'),(1835,'1','307',1,'Retail Sale Id 1837',0.00,3780.00,740.00,4440.00,660.00,'2023-02-06 10:12:06'),(1836,'1','307',1,'Retail Sale Id 1838',0.00,2520.00,740.00,2960.00,440.00,'2023-02-06 10:13:39'),(1837,'1','307',1,'Retail Sale Id 1839',0.00,630.00,740.00,740.00,110.00,'2023-02-06 10:14:37'),(1838,'1','307',1,'Retail Sale Id 1840',0.00,2551.50,740.00,2997.00,445.50,'2023-02-06 10:56:17'),(1839,'1','307',1,'Retail Sale Id 1841',0.00,1278.90,740.00,1502.20,223.30,'2023-02-06 10:57:23'),(1840,'1','307',1,'Retail Sale Id 1842',0.00,3150.00,740.00,3700.00,550.00,'2023-02-06 11:15:11'),(1841,'1','307',1,'Retail Sale Id 1843',0.00,630.00,740.00,740.00,110.00,'2023-02-06 11:44:56'),(1842,'1','307',1,'Retail Sale Id 1844',0.00,2211.30,740.00,2597.40,386.10,'2023-02-06 11:47:39'),(1843,'1','307',1,'Retail Sale Id 1845',0.00,3780.00,740.00,4440.00,660.00,'2023-02-06 12:00:15'),(1844,'1','307',1,'Retail Sale Id 1846',0.00,4258.80,740.00,5002.40,743.60,'2023-02-06 12:08:36'),(1845,'1','307',1,'Retail Sale Id 1847',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-06 12:32:20'),(1846,'1','307',1,'Retail Sale Id 1847',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-06 12:32:20'),(1847,'1','307',1,'Retail Sale Id 1848',0.00,1260.00,740.00,1480.00,220.00,'2023-02-06 13:06:36'),(1848,'1','307',1,'Retail Sale Id 1849',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-06 13:44:31'),(1849,'1','307',1,'Retail Sale Id 1850',0.00,1260.00,740.00,1480.00,220.00,'2023-02-06 14:21:41'),(1850,'1','307',1,'Retail Sale Id 1851',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-06 14:30:55'),(1851,'1','307',1,'Retail Sale Id 1851',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-06 14:30:55'),(1852,'1','307',1,'Retail Sale Id 1852',0.00,1260.00,740.00,1480.00,220.00,'2023-02-06 15:04:18'),(1853,'1','307',1,'Retail Sale Id 1853',0.00,3150.00,740.00,3700.00,550.00,'2023-02-06 15:08:28'),(1854,'1','307',1,'Retail Sale Id 1854',0.00,1890.00,740.00,2220.00,330.00,'2023-02-06 15:30:44'),(1855,'1','307',1,'Retail Sale Id 1855',0.00,4088.70,740.00,4802.60,713.90,'2023-02-06 16:02:00'),(1856,'1','307',1,'Retail Sale Id 1856',0.00,3780.00,740.00,4440.00,660.00,'2023-02-06 16:17:58'),(1857,'1','307',1,'Retail Sale Id 1857',0.00,1260.00,740.00,1480.00,220.00,'2023-02-06 16:19:23'),(1858,'1','307',1,'Retail Sale Id 1858',0.00,630.00,740.00,740.00,110.00,'2023-02-06 16:20:56'),(1859,'1','307',1,'Retail Sale Id 1859',0.00,850.50,740.00,999.00,148.50,'2023-02-06 16:26:35'),(1860,'1','307',1,'Retail Sale Id 1860',0.00,1915.20,740.00,2249.60,334.40,'2023-02-06 16:51:57'),(1861,'1','307',1,'Retail Sale Id 1861',0.00,1915.20,740.00,2249.60,334.40,'2023-02-06 16:53:58'),(1862,'1','307',1,'Retail Sale Id 1862',0.00,1890.00,740.00,2220.00,330.00,'2023-02-06 17:01:42'),(1863,'1','307',1,'Retail Sale Id 1863',0.00,3780.00,740.00,4440.00,660.00,'2023-02-06 17:07:03'),(1864,'1','307',1,'Retail Sale Id 1864',0.00,3150.00,740.00,3700.00,550.00,'2023-02-06 17:10:25'),(1865,'1','307',1,'Retail Sale Id 1865',0.00,636.30,740.00,747.40,111.10,'2023-02-06 17:19:00'),(1866,'1','307',1,'Retail Sale Id 1866',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-06 17:20:59'),(1867,'1','307',1,'Retail Sale Id 1867',0.00,1890.00,740.00,2220.00,330.00,'2023-02-06 17:24:14'),(1868,'1','307',1,'Retail Sale Id 1867',0.00,3150.00,740.00,3700.00,550.00,'2023-02-06 17:24:14'),(1869,'1','307',1,'Retail Sale Id 1868',0.00,1915.20,740.00,2249.60,334.40,'2023-02-06 17:31:07'),(1870,'1','307',1,'Retail Sale Id 1869',0.00,1890.00,740.00,2220.00,330.00,'2023-02-06 17:36:37'),(1871,'1','307',1,'Retail Sale Id 1870',0.00,2520.00,740.00,2960.00,440.00,'2023-02-06 17:38:06'),(1872,'1','307',1,'Retail Sale Id 1871',0.00,1701.00,740.00,1998.00,297.00,'2023-02-06 17:41:59'),(1873,'1','307',1,'Retail Sale Id 1872',0.00,1701.00,740.00,1998.00,297.00,'2023-02-06 17:45:56'),(1874,'1','307',1,'Retail Sale Id 1873',0.00,850.50,740.00,999.00,148.50,'2023-02-06 17:51:05'),(1875,'1','307',1,'Retail Sale Id 1874',0.00,1260.00,740.00,1480.00,220.00,'2023-02-06 17:52:24'),(1876,'1','307',1,'Retail Sale Id 1875',0.00,1890.00,740.00,2220.00,330.00,'2023-02-06 17:56:00'),(1877,'1','307',1,'Retail Sale Id 1876',0.00,3780.00,740.00,4440.00,660.00,'2023-02-06 17:57:41'),(1878,'1','307',1,'Retail Sale Id 1877',0.00,2520.00,740.00,2960.00,440.00,'2023-02-06 17:59:10'),(1879,'1','307',1,'Retail Sale Id 1878',0.00,3150.00,740.00,3700.00,550.00,'2023-02-06 18:00:54'),(1880,'1','307',1,'Retail Sale Id 1879',0.00,850.50,740.00,999.00,148.50,'2023-02-06 18:10:52'),(1881,'1','307',1,'Retail Sale Id 1880',0.00,1883.70,740.00,2212.60,328.90,'2023-02-06 18:16:56'),(1882,'1','307',1,'Retail Sale Id 1881',0.00,3780.00,740.00,4440.00,660.00,'2023-02-06 18:26:57'),(1883,'1','307',1,'Retail Sale Id 1882',0.00,63000.00,700.00,70000.00,7000.00,'2023-02-06 18:39:29'),(1884,'1','307',1,'Retail Sale Id 1883',0.00,850.50,740.00,999.00,148.50,'2023-02-06 19:02:03'),(1885,'1','307',1,'Retail Sale Id 1884',0.00,636.30,740.00,747.40,111.10,'2023-02-06 19:23:16'),(1886,'1','307',1,'Retail Sale Id 1885',0.00,1524.60,740.00,1790.80,266.20,'2023-02-06 19:26:48'),(1887,'1','307',1,'Retail Sale Id 1886',0.00,774.90,700.00,861.00,86.10,'2023-02-06 19:31:41'),(1888,'1','307',1,'Retail Sale Id 1887',0.00,1701.00,740.00,1998.00,297.00,'2023-02-07 07:37:18'),(1889,'1','307',1,'Retail Sale Id 1888',0.00,680.40,740.00,799.20,118.80,'2023-02-07 07:38:28'),(1890,'1','307',1,'Retail Sale Id 1889',0.00,25200.00,700.00,28000.00,2800.00,'2023-02-07 07:56:53'),(1891,'1','307',1,'Retail Sale Id 1890',0.00,1278.90,740.00,1502.20,223.30,'2023-02-07 08:31:45'),(1892,'1','307',1,'Retail Sale Id 1891',0.00,1915.20,740.00,2249.60,334.40,'2023-02-07 08:41:18'),(1893,'1','307',1,'Retail Sale Id 1892',0.00,1278.90,740.00,1502.20,223.30,'2023-02-07 08:51:36'),(1894,'1','307',1,'Retail Sale Id 1893',0.00,3150.00,740.00,3700.00,550.00,'2023-02-07 10:43:20'),(1895,'1','307',1,'Retail Sale Id 1894',0.00,1890.00,740.00,2220.00,330.00,'2023-02-07 11:03:38'),(1896,'1','307',1,'Retail Sale Id 1895',0.00,1278.90,740.00,1502.20,223.30,'2023-02-07 11:08:18'),(1897,'1','307',1,'Retail Sale Id 1896',0.00,1278.90,740.00,1502.20,223.30,'2023-02-07 11:41:44'),(1898,'1','307',1,'Retail Sale Id 1897',0.00,3786.30,740.00,4447.40,661.10,'2023-02-07 11:54:17'),(1899,'1','307',1,'Retail Sale Id 1898',0.00,3150.00,740.00,3700.00,550.00,'2023-02-07 12:00:18'),(1900,'1','307',1,'Retail Sale Id 1899',0.00,78750.00,700.00,87500.00,8750.00,'2023-02-07 12:12:12'),(1901,'1','307',1,'Retail Sale Id 1900',0.00,3786.30,740.00,4447.40,661.10,'2023-02-07 12:13:40'),(1902,'1','307',1,'Retail Sale Id 1901',0.00,3786.30,740.00,4447.40,661.10,'2023-02-07 12:45:41'),(1903,'1','307',1,'Retail Sale Id 1902',0.00,3786.30,740.00,4447.40,661.10,'2023-02-07 13:01:57'),(1904,'1','307',1,'Retail Sale Id 1903',0.00,2551.50,740.00,2997.00,445.50,'2023-02-07 13:03:13'),(1905,'1','307',1,'Retail Sale Id 1904',0.00,850.50,740.00,999.00,148.50,'2023-02-07 13:24:22'),(1906,'1','307',1,'Retail Sale Id 1905',0.00,1915.20,740.00,2249.60,334.40,'2023-02-07 13:37:27'),(1907,'1','307',1,'Retail Sale Id 1906',0.00,3786.30,740.00,4447.40,661.10,'2023-02-07 13:48:37'),(1908,'1','307',1,'Retail Sale Id 1907',0.00,850.50,740.00,999.00,148.50,'2023-02-07 14:03:02'),(1909,'1','307',1,'Retail Sale Id 1908',0.00,1890.00,740.00,2220.00,330.00,'2023-02-07 14:09:05'),(1910,'1','307',1,'Retail Sale Id 1909',0.00,1278.90,740.00,1502.20,223.30,'2023-02-07 14:25:32'),(1911,'1','307',1,'Retail Sale Id 1910',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-07 14:31:49'),(1912,'1','307',1,'Retail Sale Id 1911',0.00,1890.00,740.00,2220.00,330.00,'2023-02-07 15:06:15'),(1913,'1','307',1,'Retail Sale Id 1912',0.00,3786.30,740.00,4447.40,661.10,'2023-02-07 15:11:10'),(1914,'1','307',1,'Retail Sale Id 1913',0.00,680.40,740.00,799.20,118.80,'2023-02-07 15:32:30'),(1915,'1','307',1,'Retail Sale Id 1914',0.00,1449.00,740.00,1702.00,253.00,'2023-02-07 16:07:38'),(1916,'1','307',1,'Retail Sale Id 1915',0.00,1278.90,740.00,1502.20,223.30,'2023-02-07 16:09:07'),(1917,'1','307',1,'Retail Sale Id 1916',0.00,636.30,740.00,747.40,111.10,'2023-02-07 16:24:21'),(1918,'1','307',1,'Retail Sale Id 1917',0.00,1278.90,740.00,1502.20,223.30,'2023-02-07 16:42:03'),(1919,'1','307',1,'Retail Sale Id 1918',0.00,1890.00,740.00,2220.00,330.00,'2023-02-07 16:54:18'),(1920,'1','307',1,'Retail Sale Id 1919',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-07 16:59:07'),(1921,'1','307',1,'Retail Sale Id 1919',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-07 16:59:07'),(1922,'1','307',1,'Retail Sale Id 1920',0.00,1701.00,740.00,1998.00,297.00,'2023-02-07 17:06:52'),(1923,'1','307',1,'Retail Sale Id 1920',0.00,2551.50,740.00,2997.00,445.50,'2023-02-07 17:06:52'),(1924,'1','307',1,'Retail Sale Id 1921',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-07 17:35:21'),(1925,'1','307',1,'Retail Sale Id 1922',0.00,2520.00,740.00,2960.00,440.00,'2023-02-07 17:44:15'),(1926,'1','307',1,'Retail Sale Id 1923',0.00,1890.00,740.00,2220.00,330.00,'2023-02-07 17:46:42'),(1927,'1','307',1,'Retail Sale Id 1923',0.00,1890.00,740.00,2220.00,330.00,'2023-02-07 17:46:42'),(1928,'1','307',1,'Retail Sale Id 1924',0.00,680.40,740.00,799.20,118.80,'2023-02-07 18:00:21'),(1929,'1','307',1,'Retail Sale Id 1925',0.00,3786.30,740.00,4447.40,661.10,'2023-02-07 18:14:08'),(1930,'1','307',1,'Retail Sale Id 1926',0.00,1915.20,740.00,2249.60,334.40,'2023-02-07 18:23:01'),(1931,'1','307',1,'Retail Sale Id 1927',0.00,1278.90,740.00,1502.20,223.30,'2023-02-07 18:24:16'),(1932,'1','307',1,'Retail Sale Id 1928',0.00,1915.20,740.00,2249.60,334.40,'2023-02-07 18:36:14'),(1933,'1','307',1,'Retail Sale Id 1930',0.00,951.30,740.00,1117.40,166.10,'2023-02-07 18:48:02'),(1934,'1','307',1,'Retail Sale Id 1931',0.00,1871.10,740.00,2197.80,326.70,'2023-02-07 18:49:10'),(1935,'1','307',1,'Retail Sale Id 1932',0.00,9109.80,740.00,10700.40,1590.60,'2023-02-08 07:35:31'),(1936,'1','307',1,'Retail Sale Id 1933',0.00,3150.00,740.00,3700.00,550.00,'2023-02-08 08:06:52'),(1937,'1','307',1,'Retail Sale Id 1934',0.00,3150.00,740.00,3700.00,550.00,'2023-02-08 08:22:21'),(1938,'1','307',1,'Retail Sale Id 1936',0.00,63000.00,700.00,70000.00,7000.00,'2023-02-08 08:30:39'),(1939,'1','307',1,'Retail Sale Id 1937',0.00,3786.30,740.00,4447.40,661.10,'2023-02-08 08:32:33'),(1940,'1','307',1,'Retail Sale Id 1938',0.00,28079.10,700.00,31199.00,3119.90,'2023-02-08 08:37:57'),(1941,'1','307',1,'Retail Sale Id 1939',0.00,3780.00,740.00,4440.00,660.00,'2023-02-08 08:44:47'),(1942,'1','307',1,'Retail Sale Id 1940',0.00,1890.00,740.00,2220.00,330.00,'2023-02-08 08:57:21'),(1943,'1','307',1,'Retail Sale Id 1941',0.00,1278.90,740.00,1502.20,223.30,'2023-02-08 09:13:46'),(1944,'1','307',1,'Retail Sale Id 1942',0.00,1915.20,740.00,2249.60,334.40,'2023-02-08 09:20:30'),(1945,'1','307',1,'Retail Sale Id 1943',0.00,3150.00,740.00,3700.00,550.00,'2023-02-08 09:51:43'),(1946,'1','307',1,'Retail Sale Id 1944',0.00,2551.50,740.00,2997.00,445.50,'2023-02-08 10:03:14'),(1947,'1','307',1,'Retail Sale Id 1945',0.00,1890.00,740.00,2220.00,330.00,'2023-02-08 10:11:13'),(1948,'1','307',1,'Retail Sale Id 1946',0.00,1890.00,740.00,2220.00,330.00,'2023-02-08 10:23:57'),(1949,'1','307',1,'Retail Sale Id 1947',0.00,2551.50,740.00,2997.00,445.50,'2023-02-08 10:35:08'),(1950,'1','307',1,'Retail Sale Id 1948',0.00,2551.50,740.00,2997.00,445.50,'2023-02-08 10:38:57'),(1951,'1','307',1,'Retail Sale Id 1949',0.00,3150.00,740.00,3700.00,550.00,'2023-02-08 10:48:21'),(1952,'1','307',1,'Retail Sale Id 1950',0.00,3150.00,740.00,3700.00,550.00,'2023-02-08 10:56:09'),(1953,'1','307',1,'Retail Sale Id 1951',0.00,3786.30,740.00,4447.40,661.10,'2023-02-08 11:11:17'),(1954,'1','307',1,'Retail Sale Id 1952',0.00,1278.90,740.00,1502.20,223.30,'2023-02-08 11:20:35'),(1955,'1','307',1,'Retail Sale Id 1953',0.00,1278.90,740.00,1502.20,223.30,'2023-02-08 11:21:41'),(1956,'1','307',1,'Retail Sale Id 1954',0.00,850.50,740.00,999.00,148.50,'2023-02-08 11:37:27'),(1957,'1','307',1,'Retail Sale Id 1955',0.00,3150.00,740.00,3700.00,550.00,'2023-02-08 12:28:31'),(1958,'1','307',1,'Retail Sale Id 1956',0.00,3786.30,740.00,4447.40,661.10,'2023-02-08 12:31:02'),(1959,'1','307',1,'Retail Sale Id 1957',0.00,3780.00,740.00,4440.00,660.00,'2023-02-08 12:39:31'),(1960,'1','307',1,'Retail Sale Id 1958',0.00,3150.00,740.00,3700.00,550.00,'2023-02-08 12:57:54'),(1961,'1','307',1,'Retail Sale Id 1959',0.00,1278.90,740.00,1502.20,223.30,'2023-02-08 12:58:54'),(1962,'1','307',1,'Retail Sale Id 1960',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-08 13:08:28'),(1963,'1','307',1,'Retail Sale Id 1960',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-08 13:08:28'),(1964,'1','307',1,'Retail Sale Id 1961',0.00,3150.00,740.00,3700.00,550.00,'2023-02-08 13:13:15'),(1965,'1','307',1,'Retail Sale Id 1962',0.00,3780.00,740.00,4440.00,660.00,'2023-02-08 13:36:03'),(1966,'1','307',1,'Retail Sale Id 1963',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-08 13:48:02'),(1967,'1','307',1,'Retail Sale Id 1964',0.00,1871.10,740.00,2197.80,326.70,'2023-02-08 14:04:08'),(1968,'1','307',1,'Retail Sale Id 1965',0.00,3150.00,740.00,3700.00,550.00,'2023-02-08 14:06:09'),(1969,'1','307',1,'Retail Sale Id 1966',0.00,1701.00,740.00,1998.00,297.00,'2023-02-08 14:10:14'),(1970,'1','307',1,'Retail Sale Id 1967',0.00,1701.00,740.00,1998.00,297.00,'2023-02-08 14:38:48'),(1971,'1','307',1,'Retail Sale Id 1968',0.00,510.30,740.00,599.40,89.10,'2023-02-08 14:40:44'),(1972,'1','307',1,'Retail Sale Id 1968',0.00,1278.90,740.00,1502.20,223.30,'2023-02-08 14:40:44'),(1973,'1','307',1,'Retail Sale Id 1969',0.00,1278.90,740.00,1502.20,223.30,'2023-02-08 14:42:57'),(1974,'1','307',1,'Retail Sale Id 1970',0.00,63000.00,700.00,70000.00,7000.00,'2023-02-08 14:44:10'),(1975,'1','307',1,'Retail Sale Id 1971',0.00,2551.50,740.00,2997.00,445.50,'2023-02-08 15:07:46'),(1976,'1','307',1,'Retail Sale Id 1972',0.00,3786.30,740.00,4447.40,661.10,'2023-02-08 15:26:31'),(1977,'1','307',1,'Retail Sale Id 1973',0.00,1701.00,740.00,1998.00,297.00,'2023-02-08 15:27:46'),(1978,'1','307',1,'Retail Sale Id 1974',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-08 15:28:49'),(1979,'1','307',1,'Retail Sale Id 1976',0.00,680.40,740.00,799.20,118.80,'2023-02-08 15:33:50'),(1980,'1','307',1,'Retail Sale Id 1977',0.00,3786.30,740.00,4447.40,661.10,'2023-02-08 15:35:32'),(1981,'1','307',1,'Retail Sale Id 1978',0.00,1701.00,740.00,1998.00,297.00,'2023-02-08 15:38:50'),(1982,'1','307',1,'Retail Sale Id 1979',0.00,2129.40,740.00,2501.20,371.80,'2023-02-08 15:51:16'),(1983,'1','307',1,'Retail Sale Id 1980',0.00,1278.90,740.00,1502.20,223.30,'2023-02-08 16:04:19'),(1984,'1','307',1,'Retail Sale Id 1981',0.00,1915.20,740.00,2249.60,334.40,'2023-02-08 16:25:29'),(1985,'1','307',1,'Retail Sale Id 1982',0.00,4258.80,740.00,5002.40,743.60,'2023-02-08 16:30:55'),(1986,'1','307',1,'Retail Sale Id 1983',0.00,3786.30,740.00,4447.40,661.10,'2023-02-08 16:44:17'),(1987,'1','307',1,'Retail Sale Id 1984',0.00,2551.50,740.00,2997.00,445.50,'2023-02-08 16:47:20'),(1988,'1','307',1,'Retail Sale Id 1985',0.00,2520.00,740.00,2960.00,440.00,'2023-02-08 16:58:06'),(1989,'1','307',1,'Retail Sale Id 1986',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-08 17:05:16'),(1990,'1','307',1,'Retail Sale Id 1987',0.00,2469.60,740.00,2900.80,431.20,'2023-02-08 17:08:31'),(1991,'1','307',1,'Retail Sale Id 1988',0.00,8215.20,740.00,9649.60,1434.40,'2023-02-08 17:12:35'),(1992,'1','307',1,'Retail Sale Id 1989',0.00,598.50,740.00,703.00,104.50,'2023-02-08 17:14:36'),(1993,'1','307',1,'Retail Sale Id 1990',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-08 17:21:03'),(1994,'1','307',1,'Retail Sale Id 1991',0.00,1190.70,740.00,1398.60,207.90,'2023-02-08 17:23:25'),(1995,'1','307',1,'Retail Sale Id 1992',0.00,5109.30,740.00,6001.40,892.10,'2023-02-08 17:33:10'),(1996,'1','307',1,'Retail Sale Id 1993',0.00,1890.00,740.00,2220.00,330.00,'2023-02-08 17:35:52'),(1997,'1','307',1,'Retail Sale Id 1994',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-08 17:38:55'),(1998,'1','307',1,'Retail Sale Id 1995',0.00,3786.30,740.00,4447.40,661.10,'2023-02-08 17:41:04'),(1999,'1','307',1,'Retail Sale Id 1996',0.00,1278.90,740.00,1502.20,223.30,'2023-02-08 17:52:56'),(2000,'1','307',1,'Retail Sale Id 1997',0.00,3780.00,740.00,4440.00,660.00,'2023-02-08 17:56:40'),(2001,'1','307',1,'Retail Sale Id 1998',0.00,1701.00,740.00,1998.00,297.00,'2023-02-08 18:16:10'),(2002,'1','307',1,'Retail Sale Id 1999',0.00,1278.90,740.00,1502.20,223.30,'2023-02-08 18:30:00'),(2003,'1','307',1,'Retail Sale Id 2000',0.00,2551.50,740.00,2997.00,445.50,'2023-02-08 18:32:27'),(2004,'1','307',1,'Retail Sale Id 2001',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-08 18:47:05'),(2005,'1','307',1,'Retail Sale Id 2002',0.00,636.30,740.00,747.40,111.10,'2023-02-08 18:53:59'),(2006,'1','307',1,'Retail Sale Id 2003',0.00,2280.60,740.00,2678.80,398.20,'2023-02-08 19:12:31'),(2007,'1','307',1,'Retail Sale Id 2004',0.00,1278.90,740.00,1502.20,223.30,'2023-02-09 07:35:19'),(2008,'1','307',1,'Retail Sale Id 2005',0.00,1278.90,740.00,1502.20,223.30,'2023-02-09 07:37:03'),(2009,'1','307',1,'Retail Sale Id 2006',0.00,680.40,740.00,799.20,118.80,'2023-02-09 07:42:36'),(2010,'1','307',1,'Retail Sale Id 2007',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-09 07:46:28'),(2011,'1','307',1,'Retail Sale Id 2008',0.00,3786.30,740.00,4447.40,661.10,'2023-02-09 07:56:08'),(2012,'1','307',1,'Retail Sale Id 2009',0.00,4428.90,740.00,5202.20,773.30,'2023-02-09 08:04:29'),(2013,'1','307',1,'Retail Sale Id 2010',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-09 08:06:51'),(2014,'1','307',1,'Retail Sale Id 2011',0.00,4428.90,740.00,5202.20,773.30,'2023-02-09 08:08:03'),(2015,'1','307',1,'Retail Sale Id 2012',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-09 08:10:06'),(2016,'1','307',1,'Retail Sale Id 2013',0.00,1890.00,740.00,2220.00,330.00,'2023-02-09 08:19:10'),(2017,'1','307',1,'Retail Sale Id 2014',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-09 08:22:11'),(2018,'1','307',1,'Retail Sale Id 2015',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-09 08:24:55'),(2019,'1','307',1,'Retail Sale Id 2016',0.00,3780.00,740.00,4440.00,660.00,'2023-02-09 08:28:14'),(2020,'1','307',1,'Retail Sale Id 2017',0.00,3786.30,740.00,4447.40,661.10,'2023-02-09 08:43:15'),(2021,'1','307',1,'Retail Sale Id 2018',0.00,3150.00,740.00,3700.00,550.00,'2023-02-09 08:46:33'),(2022,'1','307',1,'Retail Sale Id 2019',0.00,2551.50,740.00,2997.00,445.50,'2023-02-09 09:07:55'),(2023,'1','307',1,'Retail Sale Id 2020',0.00,3780.00,740.00,4440.00,660.00,'2023-02-09 09:11:36'),(2024,'1','307',1,'Retail Sale Id 2021',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-09 09:15:57'),(2025,'1','307',1,'Retail Sale Id 2022',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-09 09:18:15'),(2026,'1','307',1,'Retail Sale Id 2024',0.00,19454.40,680.00,20998.40,1544.00,'2023-02-09 09:47:13'),(2027,'1','307',1,'Retail Sale Id 2025',0.00,1890.00,740.00,2220.00,330.00,'2023-02-09 09:52:40'),(2028,'1','307',1,'Retail Sale Id 2026',0.00,1278.90,740.00,1502.20,223.30,'2023-02-09 09:56:36'),(2029,'1','307',1,'Retail Sale Id 2027',0.00,1915.20,740.00,2249.60,334.40,'2023-02-09 10:17:18'),(2030,'1','307',1,'Retail Sale Id 2028',0.00,1278.90,740.00,1502.20,223.30,'2023-02-09 10:19:20'),(2031,'1','307',1,'Retail Sale Id 2029',0.00,3150.00,740.00,3700.00,550.00,'2023-02-09 10:20:23'),(2032,'1','307',1,'Retail Sale Id 2030',0.00,2551.50,740.00,2997.00,445.50,'2023-02-09 10:44:17'),(2033,'1','307',1,'Retail Sale Id 2031',0.00,126000.00,680.00,136000.00,10000.00,'2023-02-09 10:59:05'),(2034,'1','307',1,'Retail Sale Id 2032',0.00,1915.20,740.00,2249.60,334.40,'2023-02-09 11:04:55'),(2035,'1','307',1,'Retail Sale Id 2033',0.00,850.50,740.00,999.00,148.50,'2023-02-09 11:29:04'),(2036,'1','307',1,'Retail Sale Id 2034',0.00,1890.00,740.00,2220.00,330.00,'2023-02-09 12:02:57'),(2037,'1','307',1,'Retail Sale Id 2035',0.00,3786.30,740.00,4447.40,661.10,'2023-02-09 12:15:01'),(2038,'1','307',1,'Retail Sale Id 2036',0.00,3150.00,740.00,3700.00,550.00,'2023-02-09 12:41:39'),(2039,'1','307',1,'Retail Sale Id 2037',0.00,3150.00,740.00,3700.00,550.00,'2023-02-09 12:59:53'),(2040,'1','307',1,'Retail Sale Id 2038',0.00,78750.00,680.00,85000.00,6250.00,'2023-02-09 13:07:51'),(2041,'1','307',1,'Retail Sale Id 2039',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-09 13:14:38'),(2042,'1','307',1,'Retail Sale Id 2040',0.00,3786.30,740.00,4447.40,661.10,'2023-02-09 14:00:16'),(2043,'1','307',1,'Retail Sale Id 2041',0.00,1890.00,740.00,2220.00,330.00,'2023-02-09 14:10:32'),(2044,'1','307',1,'Retail Sale Id 2042',0.00,1260.00,740.00,1480.00,220.00,'2023-02-09 14:13:21'),(2045,'1','307',1,'Retail Sale Id 2043',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-09 14:15:23'),(2046,'1','307',1,'Retail Sale Id 2044',0.00,1915.20,740.00,2249.60,334.40,'2023-02-09 14:32:40'),(2047,'1','307',1,'Retail Sale Id 2045',0.00,1278.90,740.00,1502.20,223.30,'2023-02-09 14:55:39'),(2048,'1','307',1,'Retail Sale Id 2046',0.00,1190.70,740.00,1398.60,207.90,'2023-02-09 14:58:25'),(2049,'1','307',1,'Retail Sale Id 2047',0.00,25200.00,680.00,27200.00,2000.00,'2023-02-09 15:12:36'),(2050,'1','307',1,'Retail Sale Id 2048',0.00,1890.00,740.00,2220.00,330.00,'2023-02-09 15:14:52'),(2051,'1','307',1,'Retail Sale Id 2049',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-09 15:29:04'),(2052,'1','307',1,'Retail Sale Id 2050',0.00,3150.00,740.00,3700.00,550.00,'2023-02-09 15:33:35'),(2053,'1','307',1,'Retail Sale Id 2051',0.00,2551.50,740.00,2997.00,445.50,'2023-02-09 15:46:45'),(2054,'1','307',1,'Retail Sale Id 2052',0.00,3150.00,740.00,3700.00,550.00,'2023-02-09 15:54:09'),(2055,'1','307',1,'Retail Sale Id 2053',0.00,1278.90,740.00,1502.20,223.30,'2023-02-09 16:19:37'),(2056,'1','307',1,'Retail Sale Id 2054',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-09 16:29:43'),(2057,'1','307',1,'Retail Sale Id 2055',0.00,2513.70,740.00,2952.60,438.90,'2023-02-09 16:35:33'),(2058,'1','307',1,'Retail Sale Id 2056',0.00,630.00,740.00,740.00,110.00,'2023-02-09 16:42:59'),(2059,'1','307',1,'Retail Sale Id 2057',0.00,1278.90,740.00,1502.20,223.30,'2023-02-09 16:45:19'),(2060,'1','307',1,'Retail Sale Id 2058',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-09 16:52:01'),(2061,'1','307',1,'Retail Sale Id 2059',0.00,3780.00,740.00,4440.00,660.00,'2023-02-09 16:56:27'),(2062,'1','307',1,'Retail Sale Id 2060',0.00,1260.00,740.00,1480.00,220.00,'2023-02-09 16:59:05'),(2063,'1','307',1,'Retail Sale Id 2061',0.00,636.30,740.00,747.40,111.10,'2023-02-09 17:04:44'),(2064,'1','307',1,'Retail Sale Id 2062',0.00,3150.00,740.00,3700.00,550.00,'2023-02-09 17:07:06'),(2065,'1','307',1,'Retail Sale Id 2063',0.00,768.60,740.00,902.80,134.20,'2023-02-09 17:09:12'),(2066,'1','307',1,'Retail Sale Id 2064',0.00,3786.30,740.00,4447.40,661.10,'2023-02-09 17:18:29'),(2067,'1','307',1,'Retail Sale Id 2065',0.00,2979.90,740.00,3500.20,520.30,'2023-02-09 17:20:02'),(2068,'1','307',1,'Retail Sale Id 2066',0.00,3780.00,740.00,4440.00,660.00,'2023-02-09 17:32:33'),(2069,'1','307',1,'Retail Sale Id 2066',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-09 17:32:33'),(2070,'1','307',1,'Retail Sale Id 2067',0.00,1890.00,740.00,2220.00,330.00,'2023-02-09 17:34:37'),(2071,'1','307',1,'Retail Sale Id 2068',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-09 17:38:33'),(2072,'1','307',1,'Retail Sale Id 2069',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-09 17:50:25'),(2073,'1','307',1,'Retail Sale Id 2070',0.00,1449.00,740.00,1702.00,253.00,'2023-02-09 18:00:45'),(2074,'1','307',1,'Retail Sale Id 2072',0.00,1890.00,740.00,2220.00,330.00,'2023-02-09 18:03:15'),(2075,'1','307',1,'Retail Sale Id 2073',0.00,3150.00,740.00,3700.00,550.00,'2023-02-09 18:05:04'),(2076,'1','307',1,'Retail Sale Id 2074',0.00,1890.00,740.00,2220.00,330.00,'2023-02-09 18:10:04'),(2077,'1','307',1,'Retail Sale Id 2074',0.00,3780.00,740.00,4440.00,660.00,'2023-02-09 18:10:04'),(2078,'1','307',1,'Retail Sale Id 2075',0.00,1278.90,740.00,1502.20,223.30,'2023-02-09 18:12:27'),(2079,'1','307',1,'Retail Sale Id 2076',0.00,1890.00,740.00,2220.00,330.00,'2023-02-09 18:23:20'),(2080,'1','307',1,'Retail Sale Id 2077',0.00,2551.50,740.00,2997.00,445.50,'2023-02-09 18:25:33'),(2081,'1','307',1,'Retail Sale Id 2078',0.00,3780.00,740.00,4440.00,660.00,'2023-02-09 18:27:11'),(2082,'1','307',1,'Retail Sale Id 2079',0.00,2520.00,740.00,2960.00,440.00,'2023-02-09 18:37:32'),(2083,'1','307',1,'Retail Sale Id 2081',0.00,1915.20,740.00,2249.60,334.40,'2023-02-09 18:42:59'),(2084,'1','307',1,'Retail Sale Id 2082',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-09 18:44:51'),(2085,'1','307',1,'Retail Sale Id 2083',0.00,3786.30,740.00,4447.40,661.10,'2023-02-09 19:08:20'),(2086,'1','307',1,'Retail Sale Id 2084',0.00,1278.90,740.00,1502.20,223.30,'2023-02-10 07:45:03'),(2087,'1','307',1,'Retail Sale Id 2085',0.00,1890.00,740.00,2220.00,330.00,'2023-02-10 07:46:27'),(2088,'1','307',1,'Retail Sale Id 2086',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-10 08:13:07'),(2089,'1','307',1,'Retail Sale Id 2087',0.00,3786.30,740.00,4447.40,661.10,'2023-02-10 08:28:08'),(2090,'1','307',1,'Retail Sale Id 2088',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-10 08:31:46'),(2091,'1','307',1,'Retail Sale Id 2089',0.00,3780.00,740.00,4440.00,660.00,'2023-02-10 08:48:21'),(2092,'1','307',1,'Retail Sale Id 2090',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-10 08:49:21'),(2093,'1','307',1,'Retail Sale Id 2091',0.00,1915.20,740.00,2249.60,334.40,'2023-02-10 09:00:21'),(2094,'1','307',1,'Retail Sale Id 2092',0.00,2551.50,740.00,2997.00,445.50,'2023-02-10 09:01:26'),(2095,'1','307',1,'Retail Sale Id 2093',0.00,3408.30,740.00,4003.40,595.10,'2023-02-10 09:17:05'),(2096,'1','307',1,'Retail Sale Id 2094',0.00,1701.00,740.00,1998.00,297.00,'2023-02-10 09:24:27'),(2097,'1','307',1,'Retail Sale Id 2095',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-10 09:39:12'),(2098,'1','307',1,'Retail Sale Id 2096',0.00,3150.00,740.00,3700.00,550.00,'2023-02-10 09:49:50'),(2099,'1','307',1,'Retail Sale Id 2097',0.00,2551.50,740.00,2997.00,445.50,'2023-02-10 09:51:19'),(2100,'1','307',1,'Retail Sale Id 2098',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-10 10:08:03'),(2101,'1','307',1,'Retail Sale Id 2099',0.00,1890.00,740.00,2220.00,330.00,'2023-02-10 10:37:06'),(2102,'1','307',1,'Retail Sale Id 2100',0.00,2551.50,740.00,2997.00,445.50,'2023-02-10 10:44:32'),(2103,'1','307',1,'Retail Sale Id 2101',0.00,1890.00,740.00,2220.00,330.00,'2023-02-10 10:45:56'),(2104,'1','307',1,'Retail Sale Id 2102',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-10 10:58:37'),(2105,'1','307',1,'Retail Sale Id 2103',0.00,3408.30,740.00,4003.40,595.10,'2023-02-10 11:08:47'),(2106,'1','307',1,'Retail Sale Id 2104',0.00,3786.30,740.00,4447.40,661.10,'2023-02-10 11:32:17'),(2107,'1','307',1,'Retail Sale Id 2105',0.00,3780.00,740.00,4440.00,660.00,'2023-02-10 11:46:33'),(2108,'1','307',1,'Retail Sale Id 2106',0.00,3786.30,740.00,4447.40,661.10,'2023-02-10 11:51:11'),(2109,'1','307',1,'Retail Sale Id 2107',0.00,47250.00,680.00,51000.00,3750.00,'2023-02-10 11:53:14'),(2110,'1','307',1,'Retail Sale Id 2108',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-10 12:11:56'),(2111,'1','307',1,'Retail Sale Id 2109',0.00,1278.90,740.00,1502.20,223.30,'2023-02-10 12:15:58'),(2112,'1','307',1,'Retail Sale Id 2110',0.00,2551.50,740.00,2997.00,445.50,'2023-02-10 12:18:50'),(2113,'1','307',1,'Retail Sale Id 2111',0.00,1278.90,740.00,1502.20,223.30,'2023-02-10 12:21:28'),(2114,'1','307',1,'Retail Sale Id 2112',0.00,1278.90,740.00,1502.20,223.30,'2023-02-10 12:23:31'),(2115,'1','307',1,'Retail Sale Id 2113',0.00,3150.00,740.00,3700.00,550.00,'2023-02-10 13:03:31'),(2116,'1','307',1,'Retail Sale Id 2114',0.00,1278.90,740.00,1502.20,223.30,'2023-02-10 13:06:56'),(2117,'1','307',1,'Retail Sale Id 2115',0.00,3780.00,740.00,4440.00,660.00,'2023-02-10 13:08:11'),(2118,'1','307',1,'Retail Sale Id 2116',0.00,1701.00,740.00,1998.00,297.00,'2023-02-10 14:15:38'),(2119,'1','307',1,'Retail Sale Id 2117',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-10 14:47:18'),(2120,'1','307',1,'Retail Sale Id 2118',0.00,2551.50,740.00,2997.00,445.50,'2023-02-10 15:48:36'),(2121,'1','307',1,'Retail Sale Id 2119',0.00,1890.00,740.00,2220.00,330.00,'2023-02-10 16:31:28'),(2122,'1','307',1,'Retail Sale Id 2120',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-10 16:39:51'),(2123,'1','307',1,'Retail Sale Id 2121',0.00,5109.30,740.00,6001.40,892.10,'2023-02-10 16:44:58'),(2124,'1','307',1,'Retail Sale Id 2122',0.00,3150.00,740.00,3700.00,550.00,'2023-02-10 16:58:45'),(2125,'1','307',1,'Retail Sale Id 2123',0.00,8511.30,740.00,9997.40,1486.10,'2023-02-10 17:03:49'),(2126,'1','307',1,'Retail Sale Id 2124',0.00,1915.20,740.00,2249.60,334.40,'2023-02-10 17:17:54'),(2127,'1','307',1,'Retail Sale Id 2125',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-10 17:18:54'),(2128,'1','307',1,'Retail Sale Id 2126',0.00,1871.10,740.00,2197.80,326.70,'2023-02-10 17:25:15'),(2129,'1','307',1,'Retail Sale Id 2127',0.00,1278.90,740.00,1502.20,223.30,'2023-02-10 17:31:32'),(2130,'1','307',1,'Retail Sale Id 2128',0.00,3786.30,740.00,4447.40,661.10,'2023-02-10 17:32:59'),(2131,'1','307',1,'Retail Sale Id 2129',0.00,1890.00,740.00,2220.00,330.00,'2023-02-10 17:34:01'),(2132,'1','307',1,'Retail Sale Id 2130',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-10 17:44:49'),(2133,'1','307',1,'Retail Sale Id 2132',0.00,1890.00,740.00,2220.00,330.00,'2023-02-10 17:49:17'),(2134,'1','307',1,'Retail Sale Id 2133',0.00,3150.00,740.00,3700.00,550.00,'2023-02-10 17:53:51'),(2135,'1','307',1,'Retail Sale Id 2134',0.00,2809.80,740.00,3300.40,490.60,'2023-02-10 18:15:56'),(2136,'1','307',1,'Retail Sale Id 2135',0.00,3150.00,740.00,3700.00,550.00,'2023-02-10 18:16:52'),(2137,'1','307',1,'Retail Sale Id 2136',0.00,1701.00,740.00,1998.00,297.00,'2023-02-10 18:21:20'),(2138,'1','307',1,'Retail Sale Id 2137',0.00,3150.00,740.00,3700.00,550.00,'2023-02-10 18:46:21'),(2139,'1','307',1,'Retail Sale Id 2138',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-10 18:48:07'),(2140,'1','307',1,'Retail Sale Id 2139',0.00,19876.50,740.00,23347.00,3470.50,'2023-02-10 18:50:00'),(2141,'1','307',1,'Retail Sale Id 2140',0.00,1915.20,740.00,2249.60,334.40,'2023-02-10 19:01:29'),(2142,'1','307',1,'Retail Sale Id 2141',0.00,1278.90,740.00,1502.20,223.30,'2023-02-10 19:04:57'),(2143,'1','307',1,'Retail Sale Id 2142',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-10 19:09:22'),(2144,'1','307',1,'Retail Sale Id 2143',0.00,1890.00,740.00,2220.00,330.00,'2023-02-10 19:21:59'),(2145,'1','307',1,'Retail Sale Id 2144',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-11 07:33:17'),(2146,'1','307',1,'Retail Sale Id 2145',0.00,3780.00,740.00,4440.00,660.00,'2023-02-11 07:34:17'),(2147,'1','307',1,'Retail Sale Id 2146',0.00,3150.00,740.00,3700.00,550.00,'2023-02-11 07:49:58'),(2148,'1','307',1,'Retail Sale Id 2147',0.00,850.50,740.00,999.00,148.50,'2023-02-11 07:53:57'),(2149,'1','307',1,'Retail Sale Id 2148',0.00,1890.00,740.00,2220.00,330.00,'2023-02-11 08:08:24'),(2150,'1','307',1,'Retail Sale Id 2149',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-11 08:26:01'),(2151,'1','307',1,'Retail Sale Id 2150',0.00,2551.50,740.00,2997.00,445.50,'2023-02-11 08:34:12'),(2152,'1','307',1,'Retail Sale Id 2151',0.00,3780.00,740.00,4440.00,660.00,'2023-02-11 08:35:18'),(2153,'1','307',1,'Retail Sale Id 2152',0.00,1890.00,740.00,2220.00,330.00,'2023-02-11 08:46:08'),(2154,'1','307',1,'Retail Sale Id 2153',0.00,1890.00,740.00,2220.00,330.00,'2023-02-11 08:46:55'),(2155,'1','307',1,'Retail Sale Id 2154',0.00,1890.00,740.00,2220.00,330.00,'2023-02-11 08:56:22'),(2156,'1','307',1,'Retail Sale Id 2155',0.00,1890.00,740.00,2220.00,330.00,'2023-02-11 09:13:28'),(2157,'1','307',1,'Retail Sale Id 2157',0.00,1890.00,740.00,2220.00,330.00,'2023-02-11 09:45:32'),(2160,'1','307',1,'Retail Sale Id 2160',0.00,22346.10,680.00,24119.60,1773.50,'2023-02-11 10:57:58'),(2161,'1','307',1,'Retail Sale Id 2161',0.00,5040.00,740.00,5920.00,880.00,'2023-02-11 12:17:56'),(2162,'1','307',1,'Retail Sale Id 2162',0.00,3786.30,740.00,4447.40,661.10,'2023-02-11 12:20:02'),(2163,'1','307',1,'Retail Sale Id 2163',0.00,1915.20,740.00,2249.60,334.40,'2023-02-11 12:21:11'),(2164,'1','307',1,'Retail Sale Id 2164',0.00,1890.00,740.00,2220.00,330.00,'2023-02-11 12:22:01'),(2165,'1','307',1,'Retail Sale Id 2165',0.00,8190.00,740.00,9620.00,1430.00,'2023-02-11 12:26:34'),(2166,'1','307',1,'Retail Sale Id 2166',0.00,9153.90,680.00,9880.40,726.50,'2023-02-11 12:37:43'),(2167,'1','307',1,'Retail Sale Id 2167',0.00,2551.50,740.00,2997.00,445.50,'2023-02-11 12:39:49'),(2168,'1','307',1,'Retail Sale Id 2168',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-11 12:41:23'),(2169,'1','307',1,'Retail Sale Id 2169',0.00,3786.30,740.00,4447.40,661.10,'2023-02-11 13:16:47'),(2170,'1','307',1,'Retail Sale Id 2170',0.00,850.50,740.00,999.00,148.50,'2023-02-11 13:19:01'),(2171,'1','307',1,'Retail Sale Id 2171',0.00,3780.00,740.00,4440.00,660.00,'2023-02-11 13:20:23'),(2172,'1','307',1,'Retail Sale Id 2172',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-11 13:21:43'),(2173,'1','307',1,'Retail Sale Id 2173',0.00,3780.00,740.00,4440.00,660.00,'2023-02-11 13:24:58'),(2174,'1','307',1,'Retail Sale Id 2174',0.00,5959.80,740.00,7000.40,1040.60,'2023-02-11 13:26:36'),(2175,'1','307',1,'Retail Sale Id 2175',0.00,1915.20,740.00,2249.60,334.40,'2023-02-11 13:31:22'),(2176,'1','307',1,'Retail Sale Id 2176',0.00,3780.00,740.00,4440.00,660.00,'2023-02-11 13:36:49'),(2177,'1','307',1,'Retail Sale Id 2177',0.00,1278.90,740.00,1502.20,223.30,'2023-02-11 13:39:45'),(2178,'1','307',1,'Retail Sale Id 2178',0.00,3786.30,740.00,4447.40,661.10,'2023-02-11 13:50:43'),(2179,'1','307',1,'Retail Sale Id 2179',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-11 13:55:19'),(2180,'1','307',1,'Retail Sale Id 2180',0.00,850.50,740.00,999.00,148.50,'2023-02-11 14:14:01'),(2181,'1','307',1,'Retail Sale Id 2181',0.00,3786.30,740.00,4447.40,661.10,'2023-02-11 14:18:42'),(2182,'1','307',1,'Retail Sale Id 2182',0.00,1890.00,740.00,2220.00,330.00,'2023-02-11 14:52:54'),(2183,'1','307',1,'Retail Sale Id 2183',0.00,1278.90,740.00,1502.20,223.30,'2023-02-11 15:18:04'),(2184,'1','307',1,'Retail Sale Id 2184',0.00,1278.90,740.00,1502.20,223.30,'2023-02-11 15:19:39'),(2185,'1','307',1,'Retail Sale Id 2185',0.00,636.30,740.00,747.40,111.10,'2023-02-11 15:23:41'),(2186,'1','307',1,'Retail Sale Id 2186',0.00,4410.00,740.00,5180.00,770.00,'2023-02-11 15:27:15'),(2187,'1','307',1,'Retail Sale Id 2187',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-11 15:45:27'),(2188,'1','307',1,'Retail Sale Id 2188',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-11 15:52:22'),(2189,'1','307',1,'Retail Sale Id 2189',0.00,3150.00,740.00,3700.00,550.00,'2023-02-11 16:21:03'),(2190,'1','307',1,'Retail Sale Id 2190',0.00,2551.50,740.00,2997.00,445.50,'2023-02-11 16:22:44'),(2191,'1','307',1,'Retail Sale Id 2191',0.00,3150.00,740.00,3700.00,550.00,'2023-02-11 16:24:00'),(2192,'1','307',1,'Retail Sale Id 2192',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-11 16:30:52'),(2193,'1','307',1,'Retail Sale Id 2193',0.00,3780.00,740.00,4440.00,660.00,'2023-02-11 16:42:24'),(2194,'1','307',1,'Retail Sale Id 2194',0.00,1278.90,740.00,1502.20,223.30,'2023-02-11 16:44:12'),(2195,'1','307',1,'Retail Sale Id 2195',0.00,1190.70,740.00,1398.60,207.90,'2023-02-11 17:17:55'),(2196,'1','307',1,'Retail Sale Id 2196',0.00,1278.90,740.00,1502.20,223.30,'2023-02-11 17:22:31'),(2197,'1','307',1,'Retail Sale Id 2197',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-11 17:23:47'),(2198,'1','307',1,'Retail Sale Id 2198',0.00,636.30,740.00,747.40,111.10,'2023-02-11 17:29:20'),(2199,'1','307',1,'Retail Sale Id 2199',0.00,1890.00,740.00,2220.00,330.00,'2023-02-11 17:37:12'),(2200,'1','307',1,'Retail Sale Id 2200',0.00,1915.20,740.00,2249.60,334.40,'2023-02-11 17:43:58'),(2201,'1','307',1,'Retail Sale Id 2201',0.00,1890.00,740.00,2220.00,330.00,'2023-02-11 17:47:56'),(2202,'1','307',1,'Retail Sale Id 2202',0.00,2520.00,740.00,2960.00,440.00,'2023-02-11 17:50:12'),(2203,'1','307',1,'Retail Sale Id 2203',0.00,3150.00,740.00,3700.00,550.00,'2023-02-11 17:51:35'),(2204,'1','307',1,'Retail Sale Id 2204',0.00,1915.20,740.00,2249.60,334.40,'2023-02-11 18:00:15'),(2205,'1','307',1,'Retail Sale Id 2205',0.00,1890.00,740.00,2220.00,330.00,'2023-02-11 18:01:37'),(2206,'1','307',1,'Retail Sale Id 2206',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-11 18:09:07'),(2207,'1','307',1,'Retail Sale Id 2207',0.00,1260.00,740.00,1480.00,220.00,'2023-02-11 18:10:34'),(2208,'1','307',1,'Retail Sale Id 2208',0.00,2551.50,740.00,2997.00,445.50,'2023-02-11 18:17:57'),(2209,'1','307',1,'Retail Sale Id 2209',0.00,3780.00,740.00,4440.00,660.00,'2023-02-11 18:22:49'),(2210,'1','307',1,'Retail Sale Id 2210',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-11 18:33:34'),(2211,'1','307',1,'Retail Sale Id 2211',0.00,2721.60,740.00,3196.80,475.20,'2023-02-11 18:34:54'),(2212,'1','307',1,'Retail Sale Id 2212',0.00,1890.00,740.00,2220.00,330.00,'2023-02-11 18:40:36'),(2213,'1','307',1,'Retail Sale Id 2213',0.00,1701.00,740.00,1998.00,297.00,'2023-02-11 18:44:35'),(2214,'1','307',1,'Retail Sale Id 2214',0.00,1871.10,740.00,2197.80,326.70,'2023-02-11 18:47:56'),(2215,'1','307',1,'Retail Sale Id 2215',0.00,1890.00,740.00,2220.00,330.00,'2023-02-11 18:48:59'),(2216,'1','307',1,'Retail Sale Id 2216',0.00,2979.90,740.00,3500.20,520.30,'2023-02-11 18:50:02'),(2217,'1','307',1,'Retail Sale Id 2217',0.00,2129.40,740.00,2501.20,371.80,'2023-02-11 19:07:25'),(2218,'1','307',1,'Retail Sale Id 2218',0.00,1278.90,740.00,1502.20,223.30,'2023-02-11 19:10:15'),(2219,'1','307',1,'Retail Sale Id 2219',0.00,27090.00,680.00,29240.00,2150.00,'2023-02-11 19:12:44'),(2220,'1','307',1,'Retail Sale Id 2220',0.00,3786.30,740.00,4447.40,661.10,'2023-02-11 19:16:45'),(2221,'1','307',1,'Retail Sale Id 2221',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-11 19:37:12'),(2222,'1','307',1,'Return of Retail Sale Id 2218',1278.90,0.00,740.00,-1502.20,-223.30,'2023-02-11 19:51:35'),(2223,'1','307',1,'Retail Sale Id 2222',0.00,3786.30,740.00,4447.40,661.10,'2023-02-12 07:34:11'),(2224,'1','307',1,'Retail Sale Id 2223',0.00,3786.30,740.00,4447.40,661.10,'2023-02-12 07:48:00'),(2225,'1','307',1,'Retail Sale Id 2224',0.00,1278.90,740.00,1502.20,223.30,'2023-02-12 07:52:53'),(2226,'1','307',1,'Retail Sale Id 2225',0.00,3786.30,740.00,4447.40,661.10,'2023-02-12 07:57:50'),(2227,'1','307',1,'Retail Sale Id 2226',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-12 08:30:26'),(2228,'1','307',1,'Retail Sale Id 2227',0.00,3780.00,740.00,4440.00,660.00,'2023-02-12 08:38:12'),(2229,'1','307',1,'Retail Sale Id 2228',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-12 08:48:33'),(2230,'1','307',1,'Retail Sale Id 2229',0.00,3780.00,740.00,4440.00,660.00,'2023-02-12 09:05:38'),(2231,'1','307',1,'Retail Sale Id 2230',0.00,630.00,740.00,740.00,110.00,'2023-02-12 09:19:15'),(2232,'1','307',1,'Retail Sale Id 2231',0.00,1278.90,740.00,1502.20,223.30,'2023-02-12 09:33:13'),(2233,'1','307',1,'Retail Sale Id 2232',0.00,3786.30,740.00,4447.40,661.10,'2023-02-12 09:40:54'),(2234,'1','307',1,'Retail Sale Id 2233',0.00,11661.30,740.00,13697.40,2036.10,'2023-02-12 09:48:20'),(2235,'1','307',1,'Retail Sale Id 2234',0.00,1278.90,740.00,1502.20,223.30,'2023-02-12 09:59:39'),(2236,'1','307',1,'Retail Sale Id 2235',0.00,2129.40,740.00,2501.20,371.80,'2023-02-12 10:08:00'),(2237,'1','307',1,'Retail Sale Id 2236',0.00,5040.00,740.00,5920.00,880.00,'2023-02-12 10:10:39'),(2238,'1','307',1,'Retail Sale Id 2237',0.00,3150.00,740.00,3700.00,550.00,'2023-02-12 10:11:56'),(2239,'1','307',1,'Retail Sale Id 2238',0.00,3150.00,740.00,3700.00,550.00,'2023-02-12 10:15:43'),(2240,'1','307',1,'Retail Sale Id 2239',0.00,1915.20,740.00,2249.60,334.40,'2023-02-12 10:22:13'),(2241,'1','307',1,'Retail Sale Id 2240',0.00,1890.00,740.00,2220.00,330.00,'2023-02-12 10:36:32'),(2242,'1','307',1,'Retail Sale Id 2241',0.00,3150.00,740.00,3700.00,550.00,'2023-02-12 10:41:50'),(2243,'1','307',1,'Retail Sale Id 2242',0.00,3780.00,740.00,4440.00,660.00,'2023-02-12 10:45:13'),(2244,'1','307',1,'Retail Sale Id 2243',0.00,1915.20,740.00,2249.60,334.40,'2023-02-12 11:06:31'),(2245,'1','307',1,'Retail Sale Id 2244',0.00,3150.00,740.00,3700.00,550.00,'2023-02-12 11:07:29'),(2246,'1','307',1,'Retail Sale Id 2245',0.00,3786.30,740.00,4447.40,661.10,'2023-02-12 11:09:00'),(2247,'1','307',1,'Retail Sale Id 2246',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-12 11:11:41'),(2248,'1','307',1,'Retail Sale Id 2247',0.00,3748.50,740.00,4403.00,654.50,'2023-02-12 11:27:20'),(2249,'1','307',1,'Retail Sale Id 2248',0.00,7560.00,740.00,8880.00,1320.00,'2023-02-12 11:29:57'),(2250,'1','307',1,'Retail Sale Id 2249',0.00,3780.00,740.00,4440.00,660.00,'2023-02-12 11:31:30'),(2251,'1','307',1,'Retail Sale Id 2250',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-12 11:34:17'),(2252,'1','307',1,'Retail Sale Id 2251',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-12 11:47:53'),(2253,'1','307',1,'Retail Sale Id 2252',0.00,850.50,740.00,999.00,148.50,'2023-02-12 12:01:11'),(2254,'1','307',1,'Retail Sale Id 2253',0.00,1278.90,740.00,1502.20,223.30,'2023-02-12 12:21:51'),(2255,'1','307',1,'Retail Sale Id 2254',0.00,3780.00,740.00,4440.00,660.00,'2023-02-12 12:31:34'),(2256,'1','307',1,'Retail Sale Id 2255',0.00,3786.30,740.00,4447.40,661.10,'2023-02-12 12:34:12'),(2257,'1','307',1,'Retail Sale Id 2256',0.00,1278.90,740.00,1502.20,223.30,'2023-02-12 12:38:51'),(2258,'1','307',1,'Retail Sale Id 2258',0.00,1890.00,740.00,2220.00,330.00,'2023-02-12 12:48:58'),(2259,'1','307',1,'Retail Sale Id 2259',0.00,1915.20,740.00,2249.60,334.40,'2023-02-12 13:17:51'),(2260,'1','307',1,'Retail Sale Id 2260',0.00,3150.00,740.00,3700.00,550.00,'2023-02-12 13:31:19'),(2261,'1','307',1,'Retail Sale Id 2261',0.00,3150.00,740.00,3700.00,550.00,'2023-02-12 13:56:58'),(2262,'1','307',1,'Retail Sale Id 2263',0.00,938.70,740.00,1102.60,163.90,'2023-02-12 14:00:47'),(2263,'1','307',1,'Retail Sale Id 2264',0.00,1915.20,740.00,2249.60,334.40,'2023-02-12 14:02:26'),(2264,'1','307',1,'Retail Sale Id 2265',0.00,630.00,740.00,740.00,110.00,'2023-02-12 14:09:16'),(2265,'1','307',1,'Retail Sale Id 2266',0.00,1890.00,740.00,2220.00,330.00,'2023-02-12 14:14:20'),(2266,'1','307',1,'Retail Sale Id 2267',0.00,3780.00,740.00,4440.00,660.00,'2023-02-12 14:19:27'),(2267,'1','307',1,'Retail Sale Id 2269',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-12 14:53:59'),(2268,'1','307',1,'Retail Sale Id 2270',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-12 14:56:38'),(2269,'1','307',1,'Retail Sale Id 2271',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-12 15:00:38'),(2270,'1','307',1,'Retail Sale Id 2272',0.00,2551.50,740.00,2997.00,445.50,'2023-02-12 15:02:52'),(2271,'1','307',1,'Retail Sale Id 2274',0.00,3786.30,740.00,4447.40,661.10,'2023-02-12 15:19:07'),(2272,'1','307',1,'Retail Sale Id 2275',0.00,1915.20,740.00,2249.60,334.40,'2023-02-12 15:22:30'),(2273,'1','307',1,'Retail Sale Id 2276',0.00,3150.00,740.00,3700.00,550.00,'2023-02-12 15:23:45'),(2274,'1','307',1,'Retail Sale Id 2277',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-12 15:28:05'),(2275,'1','307',1,'Retail Sale Id 2278',0.00,43785.00,680.00,47260.00,3475.00,'2023-02-12 15:30:17'),(2276,'1','307',1,'Retail Sale Id 2279',0.00,1890.00,740.00,2220.00,330.00,'2023-02-12 15:36:00'),(2277,'1','307',1,'Retail Sale Id 2280',0.00,3780.00,740.00,4440.00,660.00,'2023-02-12 15:38:16'),(2278,'1','307',1,'Retail Sale Id 2281',0.00,3150.00,740.00,3700.00,550.00,'2023-02-12 15:45:37'),(2279,'1','307',1,'Retail Sale Id 2281',0.00,3786.30,740.00,4447.40,661.10,'2023-02-12 15:45:37'),(2280,'1','307',1,'Retail Sale Id 2282',0.00,3780.00,740.00,4440.00,660.00,'2023-02-12 15:55:01'),(2281,'1','307',1,'Retail Sale Id 2283',0.00,1890.00,740.00,2220.00,330.00,'2023-02-12 16:16:33'),(2282,'1','307',1,'Retail Sale Id 2284',0.00,3780.00,740.00,4440.00,660.00,'2023-02-12 16:20:56'),(2283,'1','307',1,'Retail Sale Id 2285',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-12 16:25:33'),(2284,'1','307',1,'Retail Sale Id 2286',0.00,1915.20,740.00,2249.60,334.40,'2023-02-12 16:32:03'),(2285,'1','307',1,'Retail Sale Id 2287',0.00,3780.00,740.00,4440.00,660.00,'2023-02-12 16:44:46'),(2286,'1','307',1,'Retail Sale Id 2288',0.00,1915.20,740.00,2249.60,334.40,'2023-02-12 16:46:05'),(2287,'1','307',1,'Retail Sale Id 2289',0.00,1701.00,740.00,1998.00,297.00,'2023-02-12 16:50:34'),(2288,'1','307',1,'Retail Sale Id 2290',0.00,3780.00,740.00,4440.00,660.00,'2023-02-12 16:51:55'),(2289,'1','307',1,'Retail Sale Id 2291',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-12 16:54:03'),(2290,'1','307',1,'Retail Sale Id 2292',0.00,3150.00,740.00,3700.00,550.00,'2023-02-12 17:15:11'),(2291,'1','307',1,'Retail Sale Id 2293',0.00,3150.00,740.00,3700.00,550.00,'2023-02-12 17:16:30'),(2292,'1','307',1,'Retail Sale Id 2294',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-12 17:20:29'),(2293,'1','307',1,'Retail Sale Id 2295',0.00,850.50,740.00,999.00,148.50,'2023-02-12 17:22:25'),(2294,'1','307',1,'Retail Sale Id 2296',0.00,3780.00,740.00,4440.00,660.00,'2023-02-12 17:37:27'),(2295,'1','307',1,'Retail Sale Id 2297',0.00,78750.00,680.00,85000.00,6250.00,'2023-02-12 17:43:22'),(2296,'1','307',1,'Retail Sale Id 2298',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-12 17:52:40'),(2297,'1','307',1,'Retail Sale Id 2299',0.00,1890.00,740.00,2220.00,330.00,'2023-02-12 17:56:24'),(2298,'1','307',1,'Retail Sale Id 2301',0.00,2551.50,740.00,2997.00,445.50,'2023-02-12 17:58:33'),(2299,'1','307',1,'Retail Sale Id 2302',0.00,1278.90,740.00,1502.20,223.30,'2023-02-12 18:01:49'),(2300,'1','307',1,'Retail Sale Id 2303',0.00,1260.00,740.00,1480.00,220.00,'2023-02-12 18:04:00'),(2301,'1','307',1,'Retail Sale Id 2304',0.00,850.50,740.00,999.00,148.50,'2023-02-12 18:06:02'),(2302,'1','307',1,'Retail Sale Id 2305',0.00,1890.00,740.00,2220.00,330.00,'2023-02-12 18:07:37'),(2303,'1','307',1,'Retail Sale Id 2306',0.00,680.40,740.00,799.20,118.80,'2023-02-12 18:09:11'),(2304,'1','307',1,'Retail Sale Id 2307',0.00,1890.00,740.00,2220.00,330.00,'2023-02-12 18:14:52'),(2305,'1','307',1,'Retail Sale Id 2309',0.00,636.30,740.00,747.40,111.10,'2023-02-12 18:22:54'),(2306,'1','307',1,'Retail Sale Id 2310',0.00,2520.00,740.00,2960.00,440.00,'2023-02-12 18:24:03'),(2307,'1','307',1,'Retail Sale Id 2311',0.00,3780.00,740.00,4440.00,660.00,'2023-02-12 18:26:41'),(2308,'1','307',1,'Retail Sale Id 2312',0.00,1915.20,740.00,2249.60,334.40,'2023-02-12 18:29:05'),(2309,'1','307',1,'Retail Sale Id 2313',0.00,2520.00,740.00,2960.00,440.00,'2023-02-12 18:33:35'),(2310,'1','307',1,'Retail Sale Id 2314',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-12 18:37:26'),(2311,'1','307',1,'Retail Sale Id 2315',0.00,428.40,740.00,503.20,74.80,'2023-02-12 18:39:27'),(2312,'1','307',1,'Retail Sale Id 2316',0.00,3780.00,740.00,4440.00,660.00,'2023-02-12 18:42:08'),(2313,'1','307',1,'Retail Sale Id 2317',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-12 19:20:40'),(2314,'1','307',1,'Retail Sale Id 2318',0.00,1619.10,740.00,1901.80,282.70,'2023-02-13 07:28:23'),(2315,'1','307',1,'Retail Sale Id 2319',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-13 07:30:12'),(2316,'1','307',1,'Retail Sale Id 2320',0.00,3150.00,740.00,3700.00,550.00,'2023-02-13 07:45:04'),(2317,'1','307',1,'Retail Sale Id 2321',0.00,3786.30,740.00,4447.40,661.10,'2023-02-13 07:46:47'),(2318,'1','307',1,'Retail Sale Id 2322',0.00,1701.00,740.00,1998.00,297.00,'2023-02-13 07:48:43'),(2319,'1','307',1,'Retail Sale Id 2323',0.00,4258.80,740.00,5002.40,743.60,'2023-02-13 07:59:24'),(2320,'1','307',1,'Retail Sale Id 2324',0.00,12341.70,740.00,14496.60,2154.90,'2023-02-13 08:09:59'),(2321,'1','307',1,'Retail Sale Id 2325',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-13 08:11:48'),(2322,'1','307',1,'Retail Sale Id 2326',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-13 08:26:17'),(2323,'1','307',1,'Retail Sale Id 2327',0.00,1278.90,740.00,1502.20,223.30,'2023-02-13 09:10:48'),(2324,'1','307',1,'Retail Sale Id 2328',0.00,16071.30,680.00,17346.80,1275.50,'2023-02-13 09:17:44'),(2325,'1','307',1,'Retail Sale Id 2331',0.00,141428.70,680.00,152653.20,11224.50,'2023-02-13 09:30:12'),(2326,'1','307',1,'Retail Sale Id 2332',0.00,3780.00,740.00,4440.00,660.00,'2023-02-13 09:31:44'),(2327,'1','307',1,'Retail Sale Id 2333',0.00,19454.40,680.00,20998.40,1544.00,'2023-02-13 09:42:40'),(2328,'1','307',1,'Retail Sale Id 2334',0.00,1260.00,740.00,1480.00,220.00,'2023-02-13 10:04:35'),(2329,'1','307',1,'Retail Sale Id 2335',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-13 10:13:36'),(2330,'1','307',1,'Retail Sale Id 2336',0.00,3150.00,740.00,3700.00,550.00,'2023-02-13 10:57:33'),(2331,'1','307',1,'Retail Sale Id 2337',0.00,3150.00,740.00,3700.00,550.00,'2023-02-13 11:00:18'),(2332,'1','307',1,'Retail Sale Id 2338',0.00,3786.30,740.00,4447.40,661.10,'2023-02-13 11:09:33'),(2333,'1','307',1,'Retail Sale Id 2339',0.00,3150.00,740.00,3700.00,550.00,'2023-02-13 11:23:20'),(2334,'1','307',1,'Retail Sale Id 2340',0.00,636.30,740.00,747.40,111.10,'2023-02-13 11:31:54'),(2335,'1','307',1,'Retail Sale Id 2341',0.00,3830.40,740.00,4499.20,668.80,'2023-02-13 11:55:42'),(2336,'1','307',1,'Retail Sale Id 2342',0.00,3780.00,740.00,4440.00,660.00,'2023-02-13 11:59:22'),(2337,'1','307',1,'Retail Sale Id 2343',0.00,1890.00,740.00,2220.00,330.00,'2023-02-13 12:16:06'),(2338,'1','307',1,'Retail Sale Id 2344',0.00,3150.00,740.00,3700.00,550.00,'2023-02-13 12:39:34'),(2339,'1','307',1,'Retail Sale Id 2346',0.00,70875.00,680.00,76500.00,5625.00,'2023-02-13 12:50:48'),(2340,'1','307',1,'Retail Sale Id 2347',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-13 12:53:50'),(2341,'1','307',1,'Retail Sale Id 2348',0.00,7578.90,740.00,8902.20,1323.30,'2023-02-13 12:59:44'),(2342,'1','307',1,'Retail Sale Id 2349',0.00,1890.00,740.00,2220.00,330.00,'2023-02-13 13:38:08'),(2343,'1','307',1,'Retail Sale Id 2350',0.00,1890.00,740.00,2220.00,330.00,'2023-02-13 13:41:55'),(2344,'1','307',1,'Retail Sale Id 2351',0.00,1915.20,740.00,2249.60,334.40,'2023-02-13 13:51:21'),(2345,'1','307',1,'Retail Sale Id 2353',0.00,8511.30,740.00,9997.40,1486.10,'2023-02-13 13:54:52'),(2346,'1','307',1,'Retail Sale Id 2354',0.00,2551.50,740.00,2997.00,445.50,'2023-02-13 13:56:04'),(2347,'1','307',1,'Retail Sale Id 2355',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-13 14:10:37'),(2348,'1','307',1,'Retail Sale Id 2356',0.00,15321.60,740.00,17996.80,2675.20,'2023-02-13 14:16:45'),(2349,'1','307',1,'Retail Sale Id 2357',0.00,2551.50,740.00,2997.00,445.50,'2023-02-13 14:23:52'),(2350,'1','307',1,'Retail Sale Id 2358',0.00,3408.30,740.00,4003.40,595.10,'2023-02-13 15:34:26'),(2351,'1','307',1,'Retail Sale Id 2359',0.00,157500.00,680.00,170000.00,12500.00,'2023-02-13 15:44:33'),(2352,'1','307',1,'Retail Sale Id 2360',0.00,3786.30,740.00,4447.40,661.10,'2023-02-13 15:51:34'),(2353,'1','307',1,'Retail Sale Id 2361',0.00,850.50,740.00,999.00,148.50,'2023-02-13 15:57:40'),(2354,'1','307',1,'Retail Sale Id 2362',0.00,1701.00,740.00,1998.00,297.00,'2023-02-13 15:58:40'),(2355,'1','307',1,'Retail Sale Id 2363',0.00,1190.70,740.00,1398.60,207.90,'2023-02-13 16:16:02'),(2356,'1','307',1,'Retail Sale Id 2364',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-13 16:21:04'),(2357,'1','307',1,'Retail Sale Id 2365',0.00,3780.00,740.00,4440.00,660.00,'2023-02-13 16:22:56'),(2358,'1','307',1,'Retail Sale Id 2368',0.00,3786.30,740.00,4447.40,661.10,'2023-02-13 16:29:50'),(2359,'1','307',1,'Retail Sale Id 2369',0.00,1260.00,740.00,1480.00,220.00,'2023-02-13 17:12:21'),(2360,'1','307',1,'Retail Sale Id 2370',0.00,1619.10,740.00,1901.80,282.70,'2023-02-13 17:19:02'),(2361,'1','307',1,'Retail Sale Id 2371',0.00,2520.00,740.00,2960.00,440.00,'2023-02-13 17:33:09'),(2362,'1','307',1,'Retail Sale Id 2372',0.00,3780.00,740.00,4440.00,660.00,'2023-02-13 17:34:54'),(2363,'1','307',1,'Retail Sale Id 2374',0.00,1915.20,740.00,2249.60,334.40,'2023-02-13 17:37:00'),(2364,'1','307',1,'Retail Sale Id 2375',0.00,3780.00,740.00,4440.00,660.00,'2023-02-13 17:40:09'),(2365,'1','307',1,'Retail Sale Id 2376',0.00,3786.30,740.00,4447.40,661.10,'2023-02-13 17:43:35'),(2366,'1','307',1,'Retail Sale Id 2376',0.00,3786.30,740.00,4447.40,661.10,'2023-02-13 17:43:35'),(2367,'1','307',1,'Retail Sale Id 2377',0.00,2520.00,740.00,2960.00,440.00,'2023-02-13 17:46:02'),(2368,'1','307',1,'Retail Sale Id 2377',0.00,2520.00,740.00,2960.00,440.00,'2023-02-13 17:46:02'),(2369,'1','307',1,'Retail Sale Id 2378',0.00,850.50,740.00,999.00,148.50,'2023-02-13 17:54:34'),(2370,'1','307',1,'Retail Sale Id 2379',0.00,3150.00,740.00,3700.00,550.00,'2023-02-13 17:55:43'),(2371,'1','307',1,'Retail Sale Id 2380',0.00,130410.00,680.00,140760.00,10350.00,'2023-02-13 17:57:34'),(2372,'1','307',1,'Retail Sale Id 2381',0.00,3780.00,740.00,4440.00,660.00,'2023-02-13 18:03:15'),(2373,'1','307',1,'Retail Sale Id 2382',0.00,2129.40,740.00,2501.20,371.80,'2023-02-13 18:04:33'),(2374,'1','307',1,'Retail Sale Id 2383',0.00,1890.00,740.00,2220.00,330.00,'2023-02-13 18:05:58'),(2375,'1','307',1,'Retail Sale Id 2384',0.00,1890.00,740.00,2220.00,330.00,'2023-02-13 18:09:38'),(2376,'1','307',1,'Retail Sale Id 2385',0.00,850.50,740.00,999.00,148.50,'2023-02-13 18:11:35'),(2377,'1','307',1,'Retail Sale Id 2386',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-13 18:18:42'),(2378,'1','307',1,'Retail Sale Id 2387',0.00,3780.00,740.00,4440.00,660.00,'2023-02-13 18:22:04'),(2379,'1','307',1,'Retail Sale Id 2388',0.00,28350.00,680.00,30600.00,2250.00,'2023-02-13 18:25:23'),(2380,'1','307',1,'Retail Sale Id 2389',0.00,3780.00,740.00,4440.00,660.00,'2023-02-13 18:26:54'),(2381,'1','307',1,'Retail Sale Id 2390',0.00,1701.00,740.00,1998.00,297.00,'2023-02-13 18:31:49'),(2382,'1','307',1,'Retail Sale Id 2393',0.00,850.50,740.00,999.00,148.50,'2023-02-13 18:44:41'),(2383,'1','307',1,'Retail Sale Id 2394',0.00,3408.30,740.00,4003.40,595.10,'2023-02-14 08:02:03'),(2384,'1','307',1,'Retail Sale Id 2395',0.00,850.50,740.00,999.00,148.50,'2023-02-14 08:27:53'),(2385,'1','307',1,'Retail Sale Id 2396',0.00,1915.20,740.00,2249.60,334.40,'2023-02-14 08:56:44'),(2386,'1','307',1,'Retail Sale Id 2397',0.00,2551.50,740.00,2997.00,445.50,'2023-02-14 09:11:16'),(2387,'1','307',1,'Retail Sale Id 2398',0.00,94500.00,680.00,102000.00,7500.00,'2023-02-14 09:16:28'),(2388,'1','307',1,'Retail Sale Id 2399',0.00,1915.20,740.00,2249.60,334.40,'2023-02-14 09:17:48'),(2389,'1','307',1,'Retail Sale Id 2400',0.00,3150.00,740.00,3700.00,550.00,'2023-02-14 09:23:28'),(2390,'1','307',1,'Retail Sale Id 2401',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-14 09:52:44'),(2391,'1','307',1,'Retail Sale Id 2402',0.00,1278.90,740.00,1502.20,223.30,'2023-02-14 09:54:04'),(2392,'1','307',1,'Retail Sale Id 2403',0.00,1278.90,740.00,1502.20,223.30,'2023-02-14 10:06:04'),(2393,'1','307',1,'Retail Sale Id 2404',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-14 10:10:01'),(2394,'1','307',1,'Retail Sale Id 2406',0.00,3780.00,740.00,4440.00,660.00,'2023-02-14 10:15:09'),(2395,'1','307',1,'Retail Sale Id 2408',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-14 10:28:53'),(2396,'1','307',1,'Retail Sale Id 2409',0.00,4410.00,740.00,5180.00,770.00,'2023-02-14 10:43:28'),(2397,'1','307',1,'Retail Sale Id 2410',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-14 10:53:28'),(2398,'1','307',1,'Retail Sale Id 2411',0.00,2551.50,740.00,2997.00,445.50,'2023-02-14 11:35:08'),(2399,'1','307',1,'Retail Sale Id 2412',0.00,3150.00,740.00,3700.00,550.00,'2023-02-14 11:53:41'),(2400,'1','307',1,'Retail Sale Id 2413',0.00,78750.00,680.00,85000.00,6250.00,'2023-02-14 12:05:59'),(2401,'1','307',1,'Retail Sale Id 2414',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-14 12:09:03'),(2402,'1','307',1,'Retail Sale Id 2415',0.00,1890.00,740.00,2220.00,330.00,'2023-02-14 12:11:17'),(2403,'1','307',1,'Retail Sale Id 2416',0.00,39375.00,680.00,42500.00,3125.00,'2023-02-14 12:17:53'),(2404,'1','307',1,'Retail Sale Id 2417',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-14 12:34:45'),(2405,'1','307',1,'Retail Sale Id 2418',0.00,1260.00,740.00,1480.00,220.00,'2023-02-14 12:51:25'),(2406,'1','307',1,'Retail Sale Id 2419',0.00,94500.00,680.00,102000.00,7500.00,'2023-02-14 12:55:37'),(2407,'1','307',1,'Retail Sale Id 2420',0.00,3780.00,740.00,4440.00,660.00,'2023-02-14 13:06:13'),(2408,'1','307',1,'Retail Sale Id 2421',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-14 13:22:01'),(2409,'1','307',1,'Retail Sale Id 2422',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-14 13:23:28'),(2410,'1','307',1,'Retail Sale Id 2423',0.00,3786.30,740.00,4447.40,661.10,'2023-02-14 13:44:56'),(2411,'1','307',1,'Retail Sale Id 2424',0.00,3786.30,740.00,4447.40,661.10,'2023-02-14 13:59:26'),(2412,'1','307',1,'Retail Sale Id 2425',0.00,5531.40,740.00,6497.20,965.80,'2023-02-14 14:04:13'),(2413,'1','307',1,'Retail Sale Id 2426',0.00,18900.00,680.00,20400.00,1500.00,'2023-02-14 14:06:28'),(2414,'1','307',1,'Retail Sale Id 2427',0.00,1278.90,740.00,1502.20,223.30,'2023-02-14 14:33:40'),(2415,'1','307',1,'Retail Sale Id 2428',0.00,1915.20,740.00,2249.60,334.40,'2023-02-14 14:54:51'),(2416,'1','307',1,'Retail Sale Id 2429',0.00,5670.00,740.00,6660.00,990.00,'2023-02-14 14:57:37'),(2417,'1','307',1,'Retail Sale Id 2430',0.00,2551.50,740.00,2997.00,445.50,'2023-02-14 15:03:30'),(2418,'1','307',1,'Retail Sale Id 2431',0.00,2551.50,740.00,2997.00,445.50,'2023-02-14 15:12:05'),(2419,'1','307',1,'Retail Sale Id 2433',0.00,3150.00,740.00,3700.00,550.00,'2023-02-14 15:22:43'),(2420,'1','307',1,'Retail Sale Id 2434',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-14 15:25:24'),(2421,'1','307',1,'Retail Sale Id 2435',0.00,1890.00,740.00,2220.00,330.00,'2023-02-14 15:26:44'),(2422,'1','307',1,'Retail Sale Id 2436',0.00,3786.30,740.00,4447.40,661.10,'2023-02-14 15:32:58'),(2423,'1','307',1,'Retail Sale Id 2437',0.00,1890.00,740.00,2220.00,330.00,'2023-02-14 15:34:29'),(2424,'1','307',1,'Retail Sale Id 2438',0.00,1701.00,740.00,1998.00,297.00,'2023-02-14 15:42:05'),(2425,'1','307',1,'Retail Sale Id 2439',0.00,850.50,740.00,999.00,148.50,'2023-02-14 15:44:12'),(2426,'1','307',1,'Retail Sale Id 2440',0.00,41580.00,680.00,44880.00,3300.00,'2023-02-14 15:47:53'),(2427,'1','307',1,'Retail Sale Id 2441',0.00,3150.00,740.00,3700.00,550.00,'2023-02-14 15:58:51'),(2428,'1','307',1,'Retail Sale Id 2442',0.00,636.30,740.00,747.40,111.10,'2023-02-14 17:33:31'),(2429,'1','307',1,'Retail Sale Id 2443',0.00,1278.90,740.00,1502.20,223.30,'2023-02-14 17:35:25'),(2430,'1','307',1,'Retail Sale Id 2444',0.00,1871.10,740.00,2197.80,326.70,'2023-02-14 17:37:00'),(2431,'1','307',1,'Retail Sale Id 2445',0.00,1890.00,740.00,2220.00,330.00,'2023-02-14 17:38:27'),(2432,'1','307',1,'Retail Sale Id 2446',0.00,1915.20,740.00,2249.60,334.40,'2023-02-14 17:40:53'),(2433,'1','307',1,'Retail Sale Id 2447',0.00,1278.90,740.00,1502.20,223.30,'2023-02-14 17:42:53'),(2434,'1','307',1,'Retail Sale Id 2448',0.00,680.40,740.00,799.20,118.80,'2023-02-14 17:44:39'),(2435,'1','307',1,'Retail Sale Id 2449',0.00,1915.20,740.00,2249.60,334.40,'2023-02-14 18:02:44'),(2436,'1','307',1,'Retail Sale Id 2450',0.00,1915.20,740.00,2249.60,334.40,'2023-02-14 18:08:08'),(2437,'1','307',1,'Retail Sale Id 2451',0.00,1278.90,740.00,1502.20,223.30,'2023-02-14 18:11:56'),(2438,'1','307',1,'Retail Sale Id 2452',0.00,2551.50,740.00,2997.00,445.50,'2023-02-14 18:20:15'),(2439,'1','307',1,'Retail Sale Id 2453',0.00,3150.00,740.00,3700.00,550.00,'2023-02-14 18:28:56'),(2440,'1','307',1,'Retail Sale Id 2454',0.00,3786.30,740.00,4447.40,661.10,'2023-02-14 18:30:57'),(2441,'1','307',1,'Retail Sale Id 2455',0.00,1915.20,740.00,2249.60,334.40,'2023-02-14 18:34:03'),(2442,'1','307',1,'Retail Sale Id 2456',0.00,1278.90,740.00,1502.20,223.30,'2023-02-14 18:36:45'),(2443,'1','307',1,'Retail Sale Id 2457',0.00,1701.00,740.00,1998.00,297.00,'2023-02-14 18:38:17'),(2444,'1','307',1,'Retail Sale Id 2458',0.00,636.30,740.00,747.40,111.10,'2023-02-14 18:40:17'),(2445,'1','307',1,'Retail Sale Id 2459',0.00,1701.00,740.00,1998.00,297.00,'2023-02-14 18:43:15'),(2446,'1','307',1,'Retail Sale Id 2459',0.00,2551.50,740.00,2997.00,445.50,'2023-02-14 18:43:15'),(2447,'1','307',1,'Retail Sale Id 2460',0.00,630.00,740.00,740.00,110.00,'2023-02-14 18:44:40'),(2448,'1','307',1,'Retail Sale Id 2461',0.00,2520.00,740.00,2960.00,440.00,'2023-02-14 18:53:51'),(2449,'1','307',1,'Retail Sale Id 2462',0.00,636.30,740.00,747.40,111.10,'2023-02-14 19:04:17'),(2450,'1','307',1,'Retail Sale Id 2463',0.00,630.00,740.00,740.00,110.00,'2023-02-14 19:06:10'),(2451,'1','307',1,'Retail Sale Id 2464',0.00,18270.00,680.00,19720.00,1450.00,'2023-02-14 19:08:05'),(2452,'1','307',1,'Retail Sale Id 2465',0.00,2520.00,740.00,2960.00,440.00,'2023-02-14 19:09:15'),(2453,'1','307',1,'Retail Sale Id 2466',0.00,1278.90,740.00,1502.20,223.30,'2023-02-14 19:11:22'),(2454,'1','307',1,'Retail Sale Id 2467',0.00,2520.00,740.00,2960.00,440.00,'2023-02-14 19:12:51'),(2455,'1','307',1,'Retail Sale Id 2468',0.00,2923.20,740.00,3433.60,510.40,'2023-02-14 19:22:50'),(2456,'1','307',1,'Retail Sale Id 2469',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-15 07:45:17'),(2457,'1','307',1,'Retail Sale Id 2470',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-15 07:47:03'),(2458,'1','307',1,'Retail Sale Id 2471',0.00,3780.00,740.00,4440.00,660.00,'2023-02-15 07:48:18'),(2459,'1','307',1,'Retail Sale Id 2472',0.00,1278.90,740.00,1502.20,223.30,'2023-02-15 07:50:13'),(2460,'1','307',1,'Retail Sale Id 2473',0.00,2520.00,740.00,2960.00,440.00,'2023-02-15 07:52:36'),(2461,'1','307',1,'Retail Sale Id 2474',0.00,3780.00,740.00,4440.00,660.00,'2023-02-15 07:54:50'),(2462,'1','307',1,'Retail Sale Id 2475',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-15 08:25:46'),(2463,'1','307',1,'Retail Sale Id 2476',0.00,1890.00,740.00,2220.00,330.00,'2023-02-15 08:33:23'),(2464,'1','307',1,'Retail Sale Id 2477',0.00,1890.00,740.00,2220.00,330.00,'2023-02-15 08:36:11'),(2465,'1','307',1,'Retail Sale Id 2478',0.00,1890.00,740.00,2220.00,330.00,'2023-02-15 08:39:11'),(2466,'1','307',1,'Retail Sale Id 2481',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-15 08:45:17'),(2467,'1','307',1,'Retail Sale Id 2482',0.00,6300.00,740.00,7400.00,1100.00,'2023-02-15 08:48:15'),(2468,'1','307',1,'Retail Sale Id 2484',0.00,3150.00,740.00,3700.00,550.00,'2023-02-15 08:51:05'),(2469,'1','307',1,'Retail Sale Id 2485',0.00,3830.40,740.00,4499.20,668.80,'2023-02-15 09:32:41'),(2470,'1','307',1,'Retail Sale Id 2486',0.00,3830.40,740.00,4499.20,668.80,'2023-02-15 09:33:49'),(2471,'1','307',1,'Retail Sale Id 2487',0.00,1890.00,740.00,2220.00,330.00,'2023-02-15 09:35:19'),(2472,'1','307',1,'Retail Sale Id 2488',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-15 09:37:38'),(2473,'1','307',1,'Retail Sale Id 2489',0.00,1890.00,740.00,2220.00,330.00,'2023-02-15 09:42:12'),(2474,'1','307',1,'Retail Sale Id 2490',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-15 10:33:42'),(2475,'1','307',1,'Retail Sale Id 2491',0.00,1890.00,740.00,2220.00,330.00,'2023-02-15 10:35:28'),(2476,'1','307',1,'Retail Sale Id 2492',0.00,3780.00,740.00,4440.00,660.00,'2023-02-15 11:09:30'),(2477,'1','307',1,'Retail Sale Id 2493',0.00,5040.00,740.00,5920.00,880.00,'2023-02-15 11:25:56'),(2478,'1','307',1,'Retail Sale Id 2494',0.00,2520.00,740.00,2960.00,440.00,'2023-02-15 11:33:28'),(2479,'1','307',1,'Retail Sale Id 2495',0.00,1260.00,740.00,1480.00,220.00,'2023-02-15 12:31:31'),(2480,'1','307',1,'Retail Sale Id 2496',0.00,1278.90,740.00,1502.20,223.30,'2023-02-15 12:39:45'),(2481,'1','307',1,'Retail Sale Id 2497',0.00,1915.20,740.00,2249.60,334.40,'2023-02-15 12:49:53'),(2482,'1','307',1,'Retail Sale Id 2498',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-15 12:55:48'),(2483,'1','307',1,'Retail Sale Id 2499',0.00,3150.00,740.00,3700.00,550.00,'2023-02-15 13:08:26'),(2484,'1','307',1,'Retail Sale Id 2500',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-15 13:41:08'),(2485,'1','307',1,'Retail Sale Id 2501',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-15 15:20:32'),(2486,'1','307',1,'Retail Sale Id 2502',0.00,1701.00,740.00,1998.00,297.00,'2023-02-15 15:25:54'),(2487,'1','307',1,'Retail Sale Id 2503',0.00,1278.90,740.00,1502.20,223.30,'2023-02-15 15:38:28'),(2488,'1','307',1,'Retail Sale Id 2504',0.00,7875.00,740.00,9250.00,1375.00,'2023-02-15 15:40:22'),(2489,'1','307',1,'Retail Sale Id 2506',0.00,3150.00,740.00,3700.00,550.00,'2023-02-15 15:57:53'),(2490,'1','307',1,'Retail Sale Id 2507',0.00,9261.00,740.00,10878.00,1617.00,'2023-02-15 16:45:04'),(2491,'1','307',1,'Retail Sale Id 2508',0.00,630.00,740.00,740.00,110.00,'2023-02-15 16:59:35'),(2492,'1','307',1,'Retail Sale Id 2509',0.00,5670.00,740.00,6660.00,990.00,'2023-02-15 17:01:14'),(2493,'1','307',1,'Retail Sale Id 2510',0.00,4428.90,740.00,5202.20,773.30,'2023-02-15 17:02:43'),(2494,'1','307',1,'Retail Sale Id 2511',0.00,11655.00,740.00,13690.00,2035.00,'2023-02-15 17:18:25'),(2495,'1','307',1,'Retail Sale Id 2512',0.00,3780.00,740.00,4440.00,660.00,'2023-02-15 17:28:34'),(2496,'1','307',1,'Retail Sale Id 2513',0.00,3780.00,740.00,4440.00,660.00,'2023-02-15 17:40:04'),(2497,'1','307',1,'Retail Sale Id 2514',0.00,1890.00,740.00,2220.00,330.00,'2023-02-15 17:42:32'),(2498,'1','307',1,'Retail Sale Id 2515',0.00,1890.00,740.00,2220.00,330.00,'2023-02-15 17:45:39'),(2499,'1','307',1,'Retail Sale Id 2517',0.00,2551.50,740.00,2997.00,445.50,'2023-02-15 17:56:29'),(2500,'1','307',1,'Retail Sale Id 2518',0.00,1278.90,740.00,1502.20,223.30,'2023-02-15 17:58:26'),(2501,'1','307',1,'Retail Sale Id 2519',0.00,3780.00,740.00,4440.00,660.00,'2023-02-15 18:05:20'),(2502,'1','307',1,'Retail Sale Id 2520',0.00,3150.00,740.00,3700.00,550.00,'2023-02-15 18:08:03'),(2503,'1','307',1,'Retail Sale Id 2521',0.00,3780.00,740.00,4440.00,660.00,'2023-02-15 18:12:51'),(2504,'1','307',1,'Retail Sale Id 2522',0.00,1278.90,740.00,1502.20,223.30,'2023-02-15 18:24:54'),(2505,'1','307',1,'Retail Sale Id 2523',0.00,2551.50,740.00,2997.00,445.50,'2023-02-15 18:29:27'),(2506,'1','307',1,'Retail Sale Id 2524',0.00,2551.50,740.00,2997.00,445.50,'2023-02-15 18:32:31'),(2507,'1','307',1,'Retail Sale Id 2525',0.00,3786.30,740.00,4447.40,661.10,'2023-02-15 18:39:33'),(2508,'1','307',1,'Retail Sale Id 2527',0.00,1260.00,740.00,1480.00,220.00,'2023-02-15 18:51:30'),(2509,'1','307',1,'Retail Sale Id 2529',0.00,3780.00,736.00,4416.00,636.00,'2023-02-16 08:17:23'),(2510,'1','307',1,'Retail Sale Id 2531',0.00,3780.00,736.00,4416.00,636.00,'2023-02-16 08:52:09'),(2511,'1','307',1,'Retail Sale Id 2532',0.00,1285.20,736.00,1501.44,216.24,'2023-02-16 09:04:39'),(2512,'1','307',1,'Retail Sale Id 2533',0.00,6300.00,736.00,7360.00,1060.00,'2023-02-16 09:34:49'),(2513,'1','307',1,'Retail Sale Id 2534',0.00,6300.00,736.00,7360.00,1060.00,'2023-02-16 09:35:51'),(2514,'1','307',1,'Retail Sale Id 2535',0.00,2520.00,736.00,2944.00,424.00,'2023-02-16 09:46:43'),(2515,'1','307',1,'Retail Sale Id 2536',0.00,94500.00,680.00,102000.00,7500.00,'2023-02-16 09:55:44'),(2516,'1','307',1,'Retail Sale Id 2537',0.00,1260.00,736.00,1472.00,212.00,'2023-02-16 10:08:13'),(2517,'1','307',1,'Retail Sale Id 2538',0.00,3420.90,736.00,3996.48,575.58,'2023-02-16 10:49:41'),(2518,'1','307',1,'Retail Sale Id 2539',0.00,1883.70,736.00,2200.64,316.94,'2023-02-16 11:02:51'),(2519,'1','307',1,'Retail Sale Id 2540',0.00,47250.00,680.00,51000.00,3750.00,'2023-02-16 11:14:22'),(2520,'1','307',1,'Retail Sale Id 2541',0.00,2570.40,736.00,3002.88,432.48,'2023-02-16 11:17:09'),(2521,'1','307',1,'Retail Sale Id 2542',0.00,1890.00,736.00,2208.00,318.00,'2023-02-16 11:22:46'),(2522,'1','307',1,'Retail Sale Id 2543',0.00,3780.00,736.00,4416.00,636.00,'2023-02-16 11:24:56'),(2523,'1','307',1,'Retail Sale Id 2544',0.00,5040.00,736.00,5888.00,848.00,'2023-02-16 11:40:50'),(2524,'1','307',1,'Retail Sale Id 2545',0.00,25200.00,680.00,27200.00,2000.00,'2023-02-16 11:58:25'),(2525,'1','307',1,'Retail Sale Id 2546',0.00,3780.00,736.00,4416.00,636.00,'2023-02-16 12:12:02'),(2526,'1','307',1,'Retail Sale Id 2547',0.00,2142.00,736.00,2502.40,360.40,'2023-02-16 12:21:28'),(2527,'1','307',1,'Retail Sale Id 2548',0.00,1285.20,736.00,1501.44,216.24,'2023-02-16 13:46:49'),(2528,'1','307',1,'Retail Sale Id 2549',0.00,3168.90,736.00,3702.08,533.18,'2023-02-16 14:11:23'),(2529,'1','307',1,'Retail Sale Id 2550',0.00,2520.00,736.00,2944.00,424.00,'2023-02-16 14:15:27'),(2530,'1','307',1,'Retail Sale Id 2551',0.00,1285.20,736.00,1501.44,216.24,'2023-02-16 14:22:34'),(2531,'1','307',1,'Retail Sale Id 2552',0.00,3780.00,736.00,4416.00,636.00,'2023-02-16 14:40:16'),(2532,'1','307',1,'Retail Sale Id 2553',0.00,1890.00,736.00,2208.00,318.00,'2023-02-16 14:46:41'),(2533,'1','307',1,'Retail Sale Id 2554',0.00,5733.00,736.00,6697.60,964.60,'2023-02-16 14:59:58'),(2534,'1','307',1,'Retail Sale Id 2555',0.00,1890.00,736.00,2208.00,318.00,'2023-02-16 15:14:20'),(2535,'1','307',1,'Retail Sale Id 2556',0.00,2526.30,736.00,2951.36,425.06,'2023-02-16 15:34:30'),(2536,'1','307',1,'Retail Sale Id 2557',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-16 15:36:28'),(2537,'1','307',1,'Retail Sale Id 2558',0.00,2998.80,736.00,3503.36,504.56,'2023-02-16 15:38:41'),(2538,'1','307',1,'Retail Sale Id 2559',0.00,3786.30,736.00,4423.36,637.06,'2023-02-16 15:40:03'),(2539,'1','307',1,'Retail Sale Id 2560',0.00,1713.60,736.00,2001.92,288.32,'2023-02-16 15:51:17'),(2540,'1','307',1,'Retail Sale Id 2561',0.00,1713.60,736.00,2001.92,288.32,'2023-02-16 16:03:43'),(2541,'1','307',1,'Retail Sale Id 2562',0.00,3780.00,736.00,4416.00,636.00,'2023-02-16 16:05:37'),(2542,'1','307',1,'Retail Sale Id 2563',0.00,2520.00,736.00,2944.00,424.00,'2023-02-16 16:36:26'),(2543,'1','307',1,'Retail Sale Id 2564',0.00,1285.20,736.00,1501.44,216.24,'2023-02-16 16:50:11'),(2544,'1','307',1,'Retail Sale Id 2565',0.00,1890.00,736.00,2208.00,318.00,'2023-02-16 17:01:18'),(2545,'1','307',1,'Retail Sale Id 2566',0.00,1285.20,736.00,1501.44,216.24,'2023-02-16 17:03:00'),(2546,'1','307',1,'Retail Sale Id 2567',0.00,1285.20,736.00,1501.44,216.24,'2023-02-16 17:09:22'),(2547,'1','307',1,'Retail Sale Id 2568',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-16 17:10:25'),(2548,'1','307',1,'Retail Sale Id 2569',0.00,8215.20,736.00,9597.44,1382.24,'2023-02-16 17:23:57'),(2549,'1','307',1,'Retail Sale Id 2570',0.00,1902.60,736.00,2222.72,320.12,'2023-02-16 17:25:24'),(2550,'1','307',1,'Retail Sale Id 2571',0.00,856.80,736.00,1000.96,144.16,'2023-02-16 17:28:12'),(2551,'1','307',1,'Retail Sale Id 2572',0.00,1902.60,736.00,2222.72,320.12,'2023-02-16 17:34:34'),(2552,'1','307',1,'Retail Sale Id 2573',0.00,1713.60,736.00,2001.92,288.32,'2023-02-16 17:36:31'),(2553,'1','307',1,'Retail Sale Id 2574',0.00,1285.20,736.00,1501.44,216.24,'2023-02-16 17:45:57'),(2554,'1','307',1,'Retail Sale Id 2574',0.00,1890.00,736.00,2208.00,318.00,'2023-02-16 17:45:57'),(2555,'1','307',1,'Retail Sale Id 2575',0.00,1285.20,736.00,1501.44,216.24,'2023-02-16 18:27:12'),(2556,'1','307',1,'Retail Sale Id 2576',0.00,642.60,736.00,750.72,108.12,'2023-02-16 18:37:56'),(2557,'1','307',1,'Retail Sale Id 2577',0.00,1285.20,736.00,1501.44,216.24,'2023-02-16 18:49:06'),(2558,'1','307',1,'Retail Sale Id 2578',0.00,856.80,736.00,1000.96,144.16,'2023-02-16 18:51:02'),(2559,'1','307',1,'Retail Sale Id 2579',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-16 18:53:09'),(2560,'1','307',1,'Retail Sale Id 2580',0.00,3420.90,736.00,3996.48,575.58,'2023-02-16 18:56:09'),(2561,'1','307',1,'Retail Sale Id 2581',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-16 18:57:16'),(2562,'1','307',1,'Retail Sale Id 2582',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-16 19:15:38'),(2563,'1','307',1,'Retail Sale Id 2583',0.00,1436.40,736.00,1678.08,241.68,'2023-02-16 19:21:11'),(2564,'1','307',1,'Retail Sale Id 2584',0.00,3780.00,736.00,4416.00,636.00,'2023-02-17 07:33:14'),(2565,'1','307',1,'Retail Sale Id 2585',0.00,1890.00,736.00,2208.00,318.00,'2023-02-17 07:57:49'),(2566,'1','307',1,'Retail Sale Id 2586',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-17 08:15:09'),(2567,'1','307',1,'Retail Sale Id 2588',0.00,2526.30,736.00,2951.36,425.06,'2023-02-17 08:23:21'),(2568,'1','307',1,'Retail Sale Id 2589',0.00,1713.60,736.00,2001.92,288.32,'2023-02-17 08:25:12'),(2569,'1','307',1,'Retail Sale Id 2590',0.00,3780.00,736.00,4416.00,636.00,'2023-02-17 08:27:58'),(2570,'1','307',1,'Retail Sale Id 2591',0.00,22232.70,680.00,23997.20,1764.50,'2023-02-17 08:36:14'),(2571,'1','307',1,'Retail Sale Id 2592',0.00,1285.20,736.00,1501.44,216.24,'2023-02-17 08:38:07'),(2572,'1','307',1,'Retail Sale Id 2593',0.00,18900.00,680.00,20400.00,1500.00,'2023-02-17 09:01:56'),(2573,'1','307',1,'Retail Sale Id 2594',0.00,1260.00,736.00,1472.00,212.00,'2023-02-17 09:04:21'),(2574,'1','307',1,'Retail Sale Id 2595',0.00,1890.00,736.00,2208.00,318.00,'2023-02-17 09:25:06'),(2575,'1','307',1,'Retail Sale Id 2596',0.00,642.60,736.00,750.72,108.12,'2023-02-17 09:27:02'),(2576,'1','307',1,'Retail Sale Id 2597',0.00,3780.00,736.00,4416.00,636.00,'2023-02-17 09:33:06'),(2577,'1','307',1,'Retail Sale Id 2598',0.00,12600.00,736.00,14720.00,2120.00,'2023-02-17 09:46:44'),(2578,'1','307',1,'Retail Sale Id 2599',0.00,5991.30,736.00,6999.36,1008.06,'2023-02-17 10:07:29'),(2579,'1','307',1,'Retail Sale Id 2600',0.00,3780.00,736.00,4416.00,636.00,'2023-02-17 10:11:37'),(2580,'1','307',1,'Retail Sale Id 2602',0.00,1927.80,736.00,2252.16,324.36,'2023-02-17 10:17:02'),(2581,'1','307',1,'Retail Sale Id 2603',0.00,3780.00,736.00,4416.00,636.00,'2023-02-17 10:18:09'),(2582,'1','307',1,'Retail Sale Id 2604',0.00,856.80,736.00,1000.96,144.16,'2023-02-17 10:32:28'),(2583,'1','307',1,'Retail Sale Id 2605',0.00,1285.20,736.00,1501.44,216.24,'2023-02-17 11:11:46'),(2584,'1','307',1,'Retail Sale Id 2606',0.00,1285.20,736.00,1501.44,216.24,'2023-02-17 11:57:21'),(2585,'1','307',1,'Retail Sale Id 2608',0.00,2570.40,736.00,3002.88,432.48,'2023-02-17 12:15:58'),(2586,'1','307',1,'Sale Id 4',0.00,3975.30,736.00,4644.16,668.86,'2023-02-17 12:34:56'),(2587,'1','307',1,'Retail Sale Id 2609',0.00,19964.70,680.00,21549.20,1584.50,'2023-02-17 12:42:28'),(2588,'1','307',1,'Retail Sale Id 2611',0.00,11535.30,680.00,12450.80,915.50,'2023-02-17 12:43:57'),(2589,'1','307',1,'Retail Sale Id 2612',0.00,3786.30,736.00,4423.36,637.06,'2023-02-17 12:44:34'),(2590,'1','307',1,'Retail Sale Id 2613',0.00,10080.00,736.00,11776.00,1696.00,'2023-02-17 12:47:44'),(2591,'1','307',1,'Retail Sale Id 2614',0.00,1890.00,736.00,2208.00,318.00,'2023-02-17 13:16:41'),(2592,'1','307',1,'Retail Sale Id 2615',0.00,1890.00,736.00,2208.00,318.00,'2023-02-17 13:18:58'),(2593,'1','307',1,'Retail Sale Id 2616',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-17 13:36:36'),(2594,'1','307',1,'Retail Sale Id 2617',0.00,10080.00,736.00,11776.00,1696.00,'2023-02-17 13:53:49'),(2595,'1','307',1,'Retail Sale Id 2618',0.00,1902.60,736.00,2222.72,320.12,'2023-02-17 14:07:33'),(2596,'1','307',1,'Retail Sale Id 2619',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-17 14:32:10'),(2597,'1','307',1,'Retail Sale Id 2620',0.00,2520.00,736.00,2944.00,424.00,'2023-02-17 14:36:42'),(2598,'1','307',1,'Retail Sale Id 2621',0.00,2142.00,736.00,2502.40,360.40,'2023-02-17 14:51:24'),(2599,'1','307',1,'Retail Sale Id 2622',0.00,1883.70,736.00,2200.64,316.94,'2023-02-17 15:34:59'),(2600,'1','307',1,'Retail Sale Id 2623',0.00,7245.00,680.00,7820.00,575.00,'2023-02-17 15:39:45'),(2601,'1','307',1,'Retail Sale Id 2624',0.00,3786.30,736.00,4423.36,637.06,'2023-02-17 16:06:46'),(2602,'1','307',1,'Retail Sale Id 2625',0.00,1285.20,736.00,1501.44,216.24,'2023-02-17 16:07:48'),(2603,'1','307',1,'Retail Sale Id 2626',0.00,1890.00,736.00,2208.00,318.00,'2023-02-17 16:09:43'),(2604,'1','307',1,'Retail Sale Id 2627',0.00,4277.70,736.00,4997.44,719.74,'2023-02-17 16:11:33'),(2605,'1','307',1,'Retail Sale Id 2628',0.00,1285.20,736.00,1501.44,216.24,'2023-02-17 16:12:48'),(2606,'1','307',1,'Retail Sale Id 2629',0.00,3786.30,736.00,4423.36,637.06,'2023-02-17 16:15:08'),(2607,'1','307',1,'Retail Sale Id 2630',0.00,686.70,736.00,802.24,115.54,'2023-02-17 16:25:33'),(2608,'1','307',1,'Retail Sale Id 2631',0.00,6300.00,736.00,7360.00,1060.00,'2023-02-17 16:39:47'),(2609,'1','307',1,'Retail Sale Id 2632',0.00,3780.00,736.00,4416.00,636.00,'2023-02-17 16:45:02'),(2610,'1','307',1,'Retail Sale Id 2633',0.00,3786.30,736.00,4423.36,637.06,'2023-02-17 17:03:08'),(2611,'1','307',1,'Retail Sale Id 2634',0.00,4454.10,736.00,5203.52,749.42,'2023-02-17 17:16:15'),(2612,'1','307',1,'Retail Sale Id 2635',0.00,3786.30,736.00,4423.36,637.06,'2023-02-17 17:18:18'),(2613,'1','307',1,'Retail Sale Id 2636',0.00,2526.30,736.00,2951.36,425.06,'2023-02-17 17:34:28'),(2614,'1','307',1,'Retail Sale Id 2637',0.00,2142.00,736.00,2502.40,360.40,'2023-02-17 17:47:29'),(2615,'1','307',1,'Retail Sale Id 2638',0.00,1713.60,736.00,2001.92,288.32,'2023-02-17 17:50:51'),(2616,'1','307',1,'Retail Sale Id 2639',0.00,3786.30,736.00,4423.36,637.06,'2023-02-17 17:55:13'),(2617,'1','307',1,'Retail Sale Id 2640',0.00,1902.60,736.00,2222.72,320.12,'2023-02-17 18:33:42'),(2618,'1','307',1,'Retail Sale Id 2641',0.00,630.00,680.00,680.00,50.00,'2023-02-17 19:06:21'),(2619,'1','307',1,'Retail Sale Id 2642',0.00,11088.00,736.00,12953.60,1865.60,'2023-02-17 19:33:33'),(2620,'1','307',1,'Return of Retail Sale Id 2642',11088.00,0.00,736.00,-12953.60,-1865.60,'2023-02-17 19:44:14'),(2621,'1','307',1,'Retail Sale Id 2643',0.00,6848.10,736.00,8000.32,1152.22,'2023-02-17 19:50:39'),(2622,'1','307',1,'Retail Sale Id 2644',0.00,3849.30,736.00,4496.96,647.66,'2023-02-18 07:44:47'),(2623,'1','307',1,'Retail Sale Id 2645',0.00,3849.30,736.00,4496.96,647.66,'2023-02-18 08:04:38'),(2624,'1','307',1,'Retail Sale Id 2646',0.00,1285.20,736.00,1501.44,216.24,'2023-02-18 08:05:53'),(2625,'1','307',1,'Retail Sale Id 2648',0.00,1285.20,736.00,1501.44,216.24,'2023-02-18 08:18:41'),(2626,'1','307',1,'Retail Sale Id 2649',0.00,768.60,736.00,897.92,129.32,'2023-02-18 08:25:14'),(2627,'1','307',1,'Retail Sale Id 2650',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-18 08:33:29'),(2628,'1','307',1,'Retail Sale Id 2651',0.00,25200.00,680.00,27200.00,2000.00,'2023-02-18 08:34:56'),(2629,'1','307',1,'Retail Sale Id 2652',0.00,3780.00,736.00,4416.00,636.00,'2023-02-18 09:00:46'),(2630,'1','307',1,'Retail Sale Id 2653',0.00,630.00,736.00,736.00,106.00,'2023-02-18 09:09:43'),(2631,'1','307',1,'Retail Sale Id 2654',0.00,1285.20,736.00,1501.44,216.24,'2023-02-18 09:23:38'),(2632,'1','307',1,'Retail Sale Id 2655',0.00,856.80,736.00,1000.96,144.16,'2023-02-18 09:34:42'),(2633,'1','307',1,'Retail Sale Id 2656',0.00,1285.20,736.00,1501.44,216.24,'2023-02-18 09:46:52'),(2634,'1','307',1,'Retail Sale Id 2657',0.00,3849.30,736.00,4496.96,647.66,'2023-02-18 10:00:27'),(2635,'1','307',1,'Retail Sale Id 2658',0.00,1883.70,736.00,2200.64,316.94,'2023-02-18 10:07:48'),(2636,'1','307',1,'Retail Sale Id 2659',0.00,1883.70,736.00,2200.64,316.94,'2023-02-18 10:18:49'),(2637,'1','307',1,'Retail Sale Id 2660',0.00,1367.10,736.00,1597.12,230.02,'2023-02-18 10:37:24'),(2638,'1','307',1,'Retail Sale Id 2661',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-18 10:43:02'),(2639,'1','307',1,'Retail Sale Id 2663',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-18 11:08:12'),(2640,'1','307',1,'Retail Sale Id 2664',0.00,1890.00,736.00,2208.00,318.00,'2023-02-18 11:12:26'),(2641,'1','307',1,'Retail Sale Id 2665',0.00,3849.30,736.00,4496.96,647.66,'2023-02-18 11:16:43'),(2642,'1','307',1,'Retail Sale Id 2666',0.00,3150.00,736.00,3680.00,530.00,'2023-02-18 11:56:19'),(2643,'1','307',1,'Retail Sale Id 2667',0.00,1890.00,736.00,2208.00,318.00,'2023-02-18 12:06:44'),(2644,'1','307',1,'Retail Sale Id 2668',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-18 12:16:24'),(2645,'1','307',1,'Retail Sale Id 2669',0.00,1285.20,736.00,1501.44,216.24,'2023-02-18 13:22:03'),(2646,'1','307',1,'Retail Sale Id 2670',0.00,1285.20,736.00,1501.44,216.24,'2023-02-18 13:43:58'),(2647,'1','307',1,'Retail Sale Id 2672',0.00,2526.30,736.00,2951.36,425.06,'2023-02-18 13:51:32'),(2648,'1','307',1,'Retail Sale Id 2673',0.00,2570.40,736.00,3002.88,432.48,'2023-02-18 14:03:54'),(2649,'1','307',1,'Retail Sale Id 2674',0.00,6300.00,736.00,7360.00,1060.00,'2023-02-18 14:40:03'),(2650,'1','307',1,'Retail Sale Id 2675',0.00,1713.60,736.00,2001.92,288.32,'2023-02-18 14:58:49'),(2651,'1','307',1,'Retail Sale Id 2676',0.00,2570.40,736.00,3002.88,432.48,'2023-02-18 15:03:20'),(2652,'1','307',1,'Retail Sale Id 2677',0.00,1285.20,736.00,1501.44,216.24,'2023-02-18 15:11:42'),(2653,'1','307',1,'Retail Sale Id 2678',0.00,3786.30,736.00,4423.36,637.06,'2023-02-18 15:13:38'),(2654,'1','307',1,'Retail Sale Id 2679',0.00,3786.30,736.00,4423.36,637.06,'2023-02-18 15:15:23'),(2655,'1','307',1,'Retail Sale Id 2680',0.00,3786.30,736.00,4423.36,637.06,'2023-02-18 15:20:41'),(2656,'1','307',1,'Retail Sale Id 2681',0.00,3168.90,736.00,3702.08,533.18,'2023-02-18 15:24:31'),(2657,'1','307',1,'Retail Sale Id 2682',0.00,1455.30,736.00,1700.16,244.86,'2023-02-18 15:55:30'),(2658,'1','307',1,'Retail Sale Id 2683',0.00,1285.20,736.00,1501.44,216.24,'2023-02-18 16:18:31'),(2659,'1','307',1,'Retail Sale Id 2684',0.00,1883.70,736.00,2200.64,316.94,'2023-02-18 16:25:47'),(2660,'1','307',1,'Retail Sale Id 2685',0.00,6936.30,736.00,8103.36,1167.06,'2023-02-18 16:28:57'),(2661,'1','307',1,'Retail Sale Id 2686',0.00,2570.40,736.00,3002.88,432.48,'2023-02-18 16:34:48'),(2662,'1','307',1,'Retail Sale Id 2687',0.00,3124.80,736.00,3650.56,525.76,'2023-02-18 16:52:41'),(2663,'1','307',1,'Retail Sale Id 2688',0.00,1890.00,736.00,2208.00,318.00,'2023-02-18 16:54:16'),(2664,'1','307',1,'Retail Sale Id 2689',0.00,3168.90,736.00,3702.08,533.18,'2023-02-18 16:58:55'),(2665,'1','307',1,'Retail Sale Id 2690',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-18 17:04:40'),(2666,'1','307',1,'Retail Sale Id 2692',0.00,3811.50,736.00,4452.80,641.30,'2023-02-18 17:12:26'),(2667,'1','307',1,'Retail Sale Id 2693',0.00,3786.30,736.00,4423.36,637.06,'2023-02-18 17:17:08'),(2668,'1','307',1,'Retail Sale Id 2694',0.00,1285.20,736.00,1501.44,216.24,'2023-02-18 17:20:09'),(2669,'1','307',1,'Retail Sale Id 2695',0.00,1285.20,736.00,1501.44,216.24,'2023-02-18 17:27:50'),(2670,'1','307',1,'Retail Sale Id 2696',0.00,3150.00,736.00,3680.00,530.00,'2023-02-18 17:37:29'),(2671,'1','307',1,'Retail Sale Id 2697',0.00,1890.00,736.00,2208.00,318.00,'2023-02-18 17:39:09'),(2672,'1','307',1,'Retail Sale Id 2698',0.00,1890.00,736.00,2208.00,318.00,'2023-02-18 17:40:59'),(2673,'1','307',1,'Retail Sale Id 2699',0.00,1285.20,736.00,1501.44,216.24,'2023-02-18 17:42:23'),(2674,'1','307',1,'Retail Sale Id 2700',0.00,1713.60,736.00,2001.92,288.32,'2023-02-18 17:47:47'),(2675,'1','307',1,'Retail Sale Id 2701',0.00,1713.60,736.00,2001.92,288.32,'2023-02-18 17:49:13'),(2676,'1','307',1,'Retail Sale Id 2702',0.00,3786.30,736.00,4423.36,637.06,'2023-02-18 18:04:43'),(2677,'1','307',1,'Retail Sale Id 2703',0.00,9802.80,736.00,11452.16,1649.36,'2023-02-18 18:07:31'),(2678,'1','307',1,'Retail Sale Id 2704',0.00,2526.30,736.00,2951.36,425.06,'2023-02-18 18:10:33'),(2679,'1','307',1,'Retail Sale Id 2705',0.00,642.60,736.00,750.72,108.12,'2023-02-18 18:11:58'),(2680,'1','307',1,'Retail Sale Id 2706',0.00,3168.90,736.00,3702.08,533.18,'2023-02-18 18:17:34'),(2681,'1','307',1,'Retail Sale Id 2707',0.00,3786.30,736.00,4423.36,637.06,'2023-02-18 18:20:58'),(2682,'1','307',1,'Retail Sale Id 2708',0.00,2526.30,736.00,2951.36,425.06,'2023-02-18 18:23:06'),(2683,'1','307',1,'Retail Sale Id 2709',0.00,5821.20,736.00,6800.64,979.44,'2023-02-18 18:36:21'),(2684,'1','307',1,'Retail Sale Id 2710',0.00,3780.00,736.00,4416.00,636.00,'2023-02-18 18:47:01'),(2685,'1','307',1,'Retail Sale Id 2711',0.00,3250.80,736.00,3797.76,546.96,'2023-02-18 18:50:41'),(2686,'1','307',1,'Retail Sale Id 2712',0.00,1890.00,736.00,2208.00,318.00,'2023-02-18 18:55:46'),(2687,'1','307',1,'Return of Retail Sale Id 2651',25200.00,0.00,680.00,-27200.00,-2000.00,'2023-02-18 19:27:01'),(2688,'1','307',1,'Retail Sale Id 2713',0.00,28980.00,680.00,31280.00,2300.00,'2023-02-18 19:28:30'),(2689,'1','307',1,'Retail Sale Id 2714',0.00,4529.70,736.00,5291.84,762.14,'2023-02-18 19:31:47'),(2690,'1','307',1,'Retail Sale Id 2715',0.00,1285.20,736.00,1501.44,216.24,'2023-02-19 07:35:18'),(2691,'1','307',1,'Retail Sale Id 2716',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-19 07:38:04'),(2692,'1','307',1,'Retail Sale Id 2717',0.00,1883.70,736.00,2200.64,316.94,'2023-02-19 07:41:50'),(2693,'1','307',1,'Retail Sale Id 2718',0.00,1927.80,736.00,2252.16,324.36,'2023-02-19 07:42:53'),(2694,'1','307',1,'Retail Sale Id 2719',0.00,1890.00,736.00,2208.00,318.00,'2023-02-19 07:44:47'),(2695,'1','307',1,'Retail Sale Id 2720',0.00,1285.20,736.00,1501.44,216.24,'2023-02-19 07:46:03'),(2696,'1','307',1,'Retail Sale Id 2721',0.00,3780.00,736.00,4416.00,636.00,'2023-02-19 07:50:10'),(2697,'1','307',1,'Retail Sale Id 2722',0.00,1890.00,736.00,2208.00,318.00,'2023-02-19 08:05:09'),(2698,'1','307',1,'Retail Sale Id 2723',0.00,3780.00,736.00,4416.00,636.00,'2023-02-19 08:11:48'),(2699,'1','307',1,'Retail Sale Id 2724',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-19 08:13:51'),(2700,'1','307',1,'Retail Sale Id 2725',0.00,2520.00,736.00,2944.00,424.00,'2023-02-19 08:25:56'),(2701,'1','307',1,'Retail Sale Id 2726',0.00,2570.40,736.00,3002.88,432.48,'2023-02-19 08:30:19'),(2702,'1','307',1,'Retail Sale Id 2727',0.00,3780.00,736.00,4416.00,636.00,'2023-02-19 08:31:44'),(2703,'1','307',1,'Retail Sale Id 2728',0.00,3780.00,736.00,4416.00,636.00,'2023-02-19 08:42:10'),(2704,'1','307',1,'Retail Sale Id 2730',0.00,1260.00,736.00,1472.00,212.00,'2023-02-19 08:46:30'),(2705,'1','307',1,'Retail Sale Id 2731',0.00,3780.00,736.00,4416.00,636.00,'2023-02-19 08:49:11'),(2706,'1','307',1,'Retail Sale Id 2733',0.00,5134.50,736.00,5998.40,863.90,'2023-02-19 08:53:39'),(2707,'1','307',1,'Retail Sale Id 2734',0.00,1890.00,736.00,2208.00,318.00,'2023-02-19 08:58:30'),(2708,'1','307',1,'Retail Sale Id 2735',0.00,3150.00,736.00,3680.00,530.00,'2023-02-19 09:26:25'),(2709,'1','307',1,'Retail Sale Id 2736',0.00,3780.00,736.00,4416.00,636.00,'2023-02-19 09:34:24'),(2710,'1','307',1,'Retail Sale Id 2737',0.00,3780.00,736.00,4416.00,636.00,'2023-02-19 10:00:56'),(2711,'1','307',1,'Retail Sale Id 2738',0.00,2142.00,736.00,2502.40,360.40,'2023-02-19 10:04:01'),(2712,'1','307',1,'Retail Sale Id 2739',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-19 10:32:24'),(2713,'1','307',1,'Retail Sale Id 2740',0.00,1927.80,736.00,2252.16,324.36,'2023-02-19 10:35:17'),(2714,'1','307',1,'Retail Sale Id 2741',0.00,2520.00,736.00,2944.00,424.00,'2023-02-19 10:36:08'),(2715,'1','307',1,'Retail Sale Id 2742',0.00,103950.00,680.00,112200.00,8250.00,'2023-02-19 10:39:49'),(2716,'1','307',1,'Retail Sale Id 2744',0.00,5670.00,736.00,6624.00,954.00,'2023-02-19 10:45:32'),(2717,'1','307',1,'Retail Sale Id 2745',0.00,3849.30,736.00,4496.96,647.66,'2023-02-19 10:47:38'),(2718,'1','307',1,'Retail Sale Id 2746',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-19 10:51:44'),(2719,'1','307',1,'Retail Sale Id 2747',0.00,15750.00,736.00,18400.00,2650.00,'2023-02-19 10:57:52'),(2720,'1','307',1,'Retail Sale Id 2748',0.00,642.60,736.00,750.72,108.12,'2023-02-19 10:59:31'),(2721,'1','307',1,'Retail Sale Id 2749',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-19 11:30:33'),(2722,'1','307',1,'Retail Sale Id 2750',0.00,2142.00,736.00,2502.40,360.40,'2023-02-19 11:37:21'),(2723,'1','307',1,'Retail Sale Id 2751',0.00,2142.00,736.00,2502.40,360.40,'2023-02-19 11:38:15'),(2724,'1','307',1,'Retail Sale Id 2752',0.00,3780.00,736.00,4416.00,636.00,'2023-02-19 11:45:39'),(2725,'1','307',1,'Retail Sale Id 2753',0.00,856.80,736.00,1000.96,144.16,'2023-02-19 11:47:18'),(2726,'1','307',1,'Retail Sale Id 2754',0.00,3780.00,736.00,4416.00,636.00,'2023-02-19 11:48:43'),(2727,'1','307',1,'Retail Sale Id 2755',0.00,1927.80,736.00,2252.16,324.36,'2023-02-19 11:51:47'),(2728,'1','307',1,'Retail Sale Id 2756',0.00,1285.20,736.00,1501.44,216.24,'2023-02-19 11:53:07'),(2729,'1','307',1,'Retail Sale Id 2757',0.00,3150.00,736.00,3680.00,530.00,'2023-02-19 11:54:58'),(2730,'1','307',1,'Retail Sale Id 2758',0.00,1890.00,736.00,2208.00,318.00,'2023-02-19 12:30:29'),(2731,'1','307',1,'Retail Sale Id 2759',0.00,1890.00,736.00,2208.00,318.00,'2023-02-19 12:36:16'),(2732,'1','307',1,'Retail Sale Id 2760',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-19 12:42:10'),(2733,'1','307',1,'Retail Sale Id 2761',0.00,11661.30,736.00,13623.36,1962.06,'2023-02-19 12:45:31'),(2734,'1','307',1,'Retail Sale Id 2762',0.00,1890.00,736.00,2208.00,318.00,'2023-02-19 13:00:13'),(2735,'1','307',1,'Retail Sale Id 2763',0.00,630.00,736.00,736.00,106.00,'2023-02-19 13:05:39'),(2736,'1','307',1,'Retail Sale Id 2764',0.00,1890.00,736.00,2208.00,318.00,'2023-02-19 13:33:48'),(2737,'1','307',1,'Retail Sale Id 2765',0.00,3786.30,736.00,4423.36,637.06,'2023-02-19 13:35:47'),(2738,'1','307',1,'Retail Sale Id 2766',0.00,636.30,736.00,743.36,107.06,'2023-02-19 13:46:36'),(2739,'1','307',1,'Retail Sale Id 2767',0.00,1713.60,736.00,2001.92,288.32,'2023-02-19 13:47:50'),(2740,'1','307',1,'Retail Sale Id 2768',0.00,642.60,736.00,750.72,108.12,'2023-02-19 14:20:17'),(2741,'1','307',1,'Retail Sale Id 2769',0.00,856.80,736.00,1000.96,144.16,'2023-02-19 14:36:00'),(2742,'1','307',1,'Retail Sale Id 2770',0.00,14553.00,736.00,17001.60,2448.60,'2023-02-19 14:45:51'),(2743,'1','307',1,'Retail Sale Id 2771',0.00,3786.30,736.00,4423.36,637.06,'2023-02-19 14:54:16'),(2744,'1','307',1,'Retail Sale Id 2772',0.00,3786.30,736.00,4423.36,637.06,'2023-02-19 14:55:32'),(2745,'1','307',1,'Retail Sale Id 2773',0.00,856.80,736.00,1000.96,144.16,'2023-02-19 15:00:23'),(2746,'1','307',1,'Retail Sale Id 2774',0.00,3786.30,736.00,4423.36,637.06,'2023-02-19 15:15:10'),(2747,'1','307',1,'Retail Sale Id 2775',0.00,1285.20,736.00,1501.44,216.24,'2023-02-19 15:18:10'),(2748,'1','307',1,'Retail Sale Id 2776',0.00,2520.00,736.00,2944.00,424.00,'2023-02-19 15:20:21'),(2749,'1','307',1,'Retail Sale Id 2777',0.00,1285.20,736.00,1501.44,216.24,'2023-02-19 15:35:40'),(2750,'1','307',1,'Retail Sale Id 2778',0.00,3168.90,736.00,3702.08,533.18,'2023-02-19 15:52:16'),(2751,'1','307',1,'Retail Sale Id 2779',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-19 15:59:31'),(2752,'1','307',1,'Retail Sale Id 2780',0.00,1285.20,736.00,1501.44,216.24,'2023-02-19 16:17:34'),(2753,'1','307',1,'Retail Sale Id 2781',0.00,2570.40,736.00,3002.88,432.48,'2023-02-19 16:49:22'),(2754,'1','307',1,'Retail Sale Id 2782',0.00,1890.00,736.00,2208.00,318.00,'2023-02-19 16:50:27'),(2755,'1','307',1,'Retail Sale Id 2783',0.00,3150.00,736.00,3680.00,530.00,'2023-02-19 16:52:07'),(2756,'1','307',1,'Retail Sale Id 2784',0.00,1890.00,736.00,2208.00,318.00,'2023-02-19 16:58:29'),(2757,'1','307',1,'Retail Sale Id 2785',0.00,2142.00,736.00,2502.40,360.40,'2023-02-19 17:04:09'),(2758,'1','307',1,'Retail Sale Id 2786',0.00,3150.00,736.00,3680.00,530.00,'2023-02-19 17:07:47'),(2759,'1','307',1,'Retail Sale Id 2787',0.00,1285.20,736.00,1501.44,216.24,'2023-02-19 17:26:36'),(2760,'1','307',1,'Retail Sale Id 2788',0.00,2520.00,736.00,2944.00,424.00,'2023-02-19 17:28:07'),(2761,'1','307',1,'Retail Sale Id 2789',0.00,3786.30,736.00,4423.36,637.06,'2023-02-19 17:33:14'),(2762,'1','307',1,'Retail Sale Id 2790',0.00,3168.90,736.00,3702.08,533.18,'2023-02-19 17:36:08'),(2763,'1','307',1,'Retail Sale Id 2791',0.00,2570.40,736.00,3002.88,432.48,'2023-02-19 17:38:30'),(2764,'1','307',1,'Retail Sale Id 2792',0.00,9450.00,736.00,11040.00,1590.00,'2023-02-19 17:40:19'),(2765,'1','307',1,'Retail Sale Id 2793',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-19 17:54:51'),(2766,'1','307',1,'Retail Sale Id 2794',0.00,2570.40,736.00,3002.88,432.48,'2023-02-19 17:56:30'),(2767,'1','307',1,'Retail Sale Id 2795',0.00,3420.90,736.00,3996.48,575.58,'2023-02-19 18:06:47'),(2768,'1','307',1,'Retail Sale Id 2796',0.00,856.80,736.00,1000.96,144.16,'2023-02-19 18:08:33'),(2769,'1','307',1,'Retail Sale Id 2797',0.00,2142.00,736.00,2502.40,360.40,'2023-02-19 18:15:24'),(2770,'1','307',1,'Retail Sale Id 2798',0.00,5134.50,736.00,5998.40,863.90,'2023-02-19 18:24:59'),(2771,'1','307',1,'Retail Sale Id 2799',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-19 18:37:38'),(2772,'1','307',1,'Retail Sale Id 2800',0.00,3780.00,736.00,4416.00,636.00,'2023-02-19 19:05:59'),(2773,'1','307',1,'Retail Sale Id 2801',0.00,1795.50,736.00,2097.60,302.10,'2023-02-19 19:17:01'),(2774,'1','307',1,'Retail Sale Id 2802',0.00,2570.40,736.00,3002.88,432.48,'2023-02-20 07:26:53'),(2775,'1','307',1,'Retail Sale Id 2803',0.00,3150.00,736.00,3680.00,530.00,'2023-02-20 07:33:19'),(2776,'1','307',1,'Retail Sale Id 2804',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-20 07:37:13'),(2777,'1','307',1,'Retail Sale Id 2805',0.00,110250.00,680.00,119000.00,8750.00,'2023-02-20 07:52:52'),(2778,'1','307',1,'Retail Sale Id 2806',0.00,1890.00,736.00,2208.00,318.00,'2023-02-20 07:54:56'),(2779,'1','307',1,'Retail Sale Id 2807',0.00,3780.00,736.00,4416.00,636.00,'2023-02-20 08:10:04'),(2780,'1','307',1,'Retail Sale Id 2808',0.00,7560.00,736.00,8832.00,1272.00,'2023-02-20 08:21:28'),(2781,'1','307',1,'Retail Sale Id 2809',0.00,3780.00,736.00,4416.00,636.00,'2023-02-20 08:23:42'),(2782,'1','307',1,'Retail Sale Id 2810',0.00,6300.00,736.00,7360.00,1060.00,'2023-02-20 08:27:52'),(2783,'1','307',1,'Retail Sale Id 2811',0.00,126000.00,680.00,136000.00,10000.00,'2023-02-20 08:46:47'),(2784,'1','307',1,'Retail Sale Id 2812',0.00,3849.30,736.00,4496.96,647.66,'2023-02-20 09:15:29'),(2785,'1','307',1,'Retail Sale Id 2813',0.00,630.00,736.00,736.00,106.00,'2023-02-20 09:20:53'),(2786,'1','307',1,'Retail Sale Id 2814',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-20 09:24:48'),(2787,'1','307',1,'Retail Sale Id 2815',0.00,1285.20,736.00,1501.44,216.24,'2023-02-20 09:30:03'),(2788,'1','307',1,'Retail Sale Id 2816',0.00,3150.00,736.00,3680.00,530.00,'2023-02-20 09:40:18'),(2789,'1','307',1,'Retail Sale Id 2817',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-20 09:45:04'),(2790,'1','307',1,'Retail Sale Id 2818',0.00,856.80,736.00,1000.96,144.16,'2023-02-20 10:02:49'),(2791,'1','307',1,'Retail Sale Id 2819',0.00,2482.20,736.00,2899.84,417.64,'2023-02-20 10:06:00'),(2792,'1','307',1,'Retail Sale Id 2820',0.00,1285.20,736.00,1501.44,216.24,'2023-02-20 10:34:40'),(2793,'1','307',1,'Retail Sale Id 2821',0.00,1883.70,736.00,2200.64,316.94,'2023-02-20 10:58:11'),(2794,'1','307',1,'Retail Sale Id 2822',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-20 11:22:42'),(2795,'1','307',1,'Retail Sale Id 2823',0.00,2570.40,736.00,3002.88,432.48,'2023-02-20 11:42:33'),(2796,'1','307',1,'Retail Sale Id 2824',0.00,1927.80,736.00,2252.16,324.36,'2023-02-20 11:47:10'),(2797,'1','307',1,'Retail Sale Id 2825',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-20 11:48:13'),(2798,'1','307',1,'Retail Sale Id 2826',0.00,3780.00,736.00,4416.00,636.00,'2023-02-20 11:52:36'),(2799,'1','307',1,'Retail Sale Id 2828',0.00,1927.80,736.00,2252.16,324.36,'2023-02-20 11:58:27'),(2800,'1','307',1,'Retail Sale Id 2830',0.00,7534.80,736.00,8802.56,1267.76,'2023-02-20 12:00:21'),(2801,'1','307',1,'Retail Sale Id 2831',0.00,1902.60,736.00,2222.72,320.12,'2023-02-20 12:07:41'),(2802,'1','307',1,'Retail Sale Id 2832',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-20 12:23:58'),(2803,'1','307',1,'Retail Sale Id 2833',0.00,1713.60,736.00,2001.92,288.32,'2023-02-20 12:27:54'),(2804,'1','307',1,'Retail Sale Id 2834',0.00,3780.00,736.00,4416.00,636.00,'2023-02-20 12:58:04'),(2805,'1','307',1,'Retail Sale Id 2835',0.00,1971.90,736.00,2303.68,331.78,'2023-02-20 13:11:25'),(2806,'1','307',1,'Retail Sale Id 2836',0.00,3849.30,736.00,4496.96,647.66,'2023-02-20 13:13:46'),(2807,'1','307',1,'Retail Sale Id 2837',0.00,2520.00,736.00,2944.00,424.00,'2023-02-20 13:15:00'),(2808,'1','307',1,'Retail Sale Id 2838',0.00,3811.50,736.00,4452.80,641.30,'2023-02-20 14:05:54'),(2809,'1','307',1,'Retail Sale Id 2839',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-20 14:08:50'),(2810,'1','307',1,'Retail Sale Id 2840',0.00,428.40,736.00,500.48,72.08,'2023-02-20 14:15:04'),(2811,'1','307',1,'Retail Sale Id 2841',0.00,1713.60,736.00,2001.92,288.32,'2023-02-20 14:39:34'),(2812,'1','307',1,'Retail Sale Id 2842',0.00,3786.30,736.00,4423.36,637.06,'2023-02-20 15:18:38'),(2813,'1','307',1,'Retail Sale Id 2843',0.00,3786.30,736.00,4423.36,637.06,'2023-02-20 15:21:14'),(2814,'1','307',1,'Retail Sale Id 2844',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-20 15:28:59'),(2815,'1','307',1,'Retail Sale Id 2845',0.00,1890.00,736.00,2208.00,318.00,'2023-02-20 15:36:21'),(2816,'1','307',1,'Retail Sale Id 2847',0.00,3786.30,736.00,4423.36,637.06,'2023-02-20 15:44:01'),(2817,'1','307',1,'Retail Sale Id 2848',0.00,1285.20,736.00,1501.44,216.24,'2023-02-20 16:19:08'),(2818,'1','307',1,'Retail Sale Id 2849',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-20 16:20:33'),(2819,'1','307',1,'Retail Sale Id 2850',0.00,4277.70,736.00,4997.44,719.74,'2023-02-20 16:24:17'),(2820,'1','307',1,'Retail Sale Id 2851',0.00,1285.20,736.00,1501.44,216.24,'2023-02-20 16:26:13'),(2821,'1','307',1,'Retail Sale Id 2852',0.00,3150.00,736.00,3680.00,530.00,'2023-02-20 16:29:28'),(2822,'1','307',1,'Retail Sale Id 2853',0.00,1367.10,736.00,1597.12,230.02,'2023-02-20 16:30:26'),(2823,'1','307',1,'Retail Sale Id 2854',0.00,6300.00,736.00,7360.00,1060.00,'2023-02-20 16:40:29'),(2824,'1','307',1,'Retail Sale Id 2855',0.00,1890.00,736.00,2208.00,318.00,'2023-02-20 16:43:15'),(2825,'1','307',1,'Retail Sale Id 2857',0.00,1890.00,736.00,2208.00,318.00,'2023-02-20 16:48:24'),(2826,'1','307',1,'Retail Sale Id 2858',0.00,1890.00,736.00,2208.00,318.00,'2023-02-20 16:54:00'),(2827,'1','307',1,'Retail Sale Id 2859',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-20 17:00:41'),(2828,'1','307',1,'Retail Sale Id 2860',0.00,428.40,736.00,500.48,72.08,'2023-02-20 17:03:27'),(2829,'1','307',1,'Retail Sale Id 2861',0.00,1890.00,736.00,2208.00,318.00,'2023-02-20 17:04:34'),(2830,'1','307',1,'Retail Sale Id 2862',0.00,6300.00,736.00,7360.00,1060.00,'2023-02-20 17:12:22'),(2831,'1','307',1,'Retail Sale Id 2863',0.00,3168.90,736.00,3702.08,533.18,'2023-02-20 17:28:47'),(2832,'1','307',1,'Retail Sale Id 2864',0.00,12600.00,680.00,13600.00,1000.00,'2023-02-20 17:37:29'),(2833,'1','307',1,'Retail Sale Id 2865',0.00,3168.90,736.00,3702.08,533.18,'2023-02-20 17:39:34'),(2834,'1','307',1,'Retail Sale Id 2866',0.00,6300.00,736.00,7360.00,1060.00,'2023-02-20 17:41:49'),(2835,'1','307',1,'Retail Sale Id 2867',0.00,3786.30,736.00,4423.36,637.06,'2023-02-20 17:48:17'),(2836,'1','307',1,'Retail Sale Id 2868',0.00,3786.30,736.00,4423.36,637.06,'2023-02-20 18:28:12'),(2837,'1','307',1,'Retail Sale Id 2869',0.00,6300.00,736.00,7360.00,1060.00,'2023-02-20 18:29:39'),(2838,'1','307',1,'Retail Sale Id 2870',0.00,768.60,736.00,897.92,129.32,'2023-02-20 18:31:00'),(2839,'1','307',1,'Retail Sale Id 2871',0.00,15561.00,736.00,18179.20,2618.20,'2023-02-20 18:34:50'),(2840,'1','307',1,'Retail Sale Id 2872',0.00,686.70,736.00,802.24,115.54,'2023-02-20 18:40:56'),(2841,'1','307',1,'Retail Sale Id 2873',0.00,1713.60,736.00,2001.92,288.32,'2023-02-20 18:42:03'),(2842,'1','307',1,'Retail Sale Id 2874',0.00,3420.90,736.00,3996.48,575.58,'2023-02-20 18:45:26'),(2843,'1','307',1,'Retail Sale Id 2875',0.00,3786.30,736.00,4423.36,637.06,'2023-02-20 18:53:24'),(2844,'1','307',1,'Retail Sale Id 2876',0.00,3168.90,736.00,3702.08,533.18,'2023-02-20 18:59:30'),(2845,'1','307',1,'Retail Sale Id 2877',0.00,1285.20,736.00,1501.44,216.24,'2023-02-20 19:03:44'),(2846,'1','307',1,'Retail Sale Id 2878',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-20 19:08:01'),(2847,'1','307',1,'Retail Sale Id 2879',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-20 19:26:14'),(2848,'1','307',1,'Retail Sale Id 2880',0.00,2979.90,736.00,3481.28,501.38,'2023-02-20 19:42:36'),(2849,'1','307',1,'Retail Sale Id 2881',0.00,2979.90,736.00,3481.28,501.38,'2023-02-20 19:43:55'),(2850,'1','307',1,'Return of Retail Sale Id 2881',2979.90,0.00,736.00,-3481.28,-501.38,'2023-02-20 19:45:44'),(2851,'1','307',1,'Retail Sale Id 2882',0.00,3780.00,736.00,4416.00,636.00,'2023-02-21 07:30:59'),(2852,'1','307',1,'Retail Sale Id 2883',0.00,1890.00,736.00,2208.00,318.00,'2023-02-21 07:34:54'),(2853,'1','307',1,'Retail Sale Id 2884',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-21 07:36:35'),(2854,'1','307',1,'Retail Sale Id 2885',0.00,1890.00,736.00,2208.00,318.00,'2023-02-21 07:37:27'),(2855,'1','307',1,'Retail Sale Id 2886',0.00,1890.00,736.00,2208.00,318.00,'2023-02-21 07:44:56'),(2856,'1','307',1,'Retail Sale Id 2888',0.00,34650.00,680.00,37400.00,2750.00,'2023-02-21 07:57:02'),(2857,'1','307',1,'Retail Sale Id 2889',0.00,642.60,736.00,750.72,108.12,'2023-02-21 08:00:56'),(2858,'1','307',1,'Retail Sale Id 2890',0.00,3786.30,736.00,4423.36,637.06,'2023-02-21 08:03:18'),(2859,'1','307',1,'Retail Sale Id 2891',0.00,2520.00,736.00,2944.00,424.00,'2023-02-21 08:06:41'),(2860,'1','307',1,'Retail Sale Id 2892',0.00,3780.00,736.00,4416.00,636.00,'2023-02-21 08:24:11'),(2861,'1','307',1,'Retail Sale Id 2893',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-21 08:37:07'),(2862,'1','307',1,'Retail Sale Id 2894',0.00,1713.60,736.00,2001.92,288.32,'2023-02-21 08:39:48'),(2863,'1','307',1,'Retail Sale Id 2895',0.00,1927.80,736.00,2252.16,324.36,'2023-02-21 08:40:43'),(2864,'1','307',1,'Retail Sale Id 2896',0.00,6300.00,736.00,7360.00,1060.00,'2023-02-21 08:49:37'),(2865,'1','307',1,'Retail Sale Id 2897',0.00,1883.70,736.00,2200.64,316.94,'2023-02-21 09:21:21'),(2866,'1','307',1,'Retail Sale Id 2898',0.00,4277.70,736.00,4997.44,719.74,'2023-02-21 09:22:29'),(2867,'1','307',1,'Retail Sale Id 2899',0.00,1890.00,736.00,2208.00,318.00,'2023-02-21 09:23:51'),(2868,'1','307',1,'Retail Sale Id 2900',0.00,1890.00,736.00,2208.00,318.00,'2023-02-21 09:26:00'),(2869,'1','307',1,'Retail Sale Id 2901',0.00,33390.00,680.00,36040.00,2650.00,'2023-02-21 09:45:50'),(2870,'1','307',1,'Retail Sale Id 2902',0.00,1890.00,736.00,2208.00,318.00,'2023-02-21 09:51:28'),(2871,'1','307',1,'Retail Sale Id 2903',0.00,1285.20,736.00,1501.44,216.24,'2023-02-21 09:54:05'),(2872,'1','307',1,'Retail Sale Id 2904',0.00,1927.80,736.00,2252.16,324.36,'2023-02-21 09:56:46'),(2873,'1','307',1,'Retail Sale Id 2905',0.00,1890.00,736.00,2208.00,318.00,'2023-02-21 09:58:17'),(2874,'1','307',1,'Retail Sale Id 2906',0.00,4277.70,736.00,4997.44,719.74,'2023-02-21 09:59:41'),(2875,'1','307',1,'Retail Sale Id 2907',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-21 10:29:20'),(2876,'1','307',1,'Retail Sale Id 2908',0.00,3780.00,736.00,4416.00,636.00,'2023-02-21 10:31:51'),(2877,'1','307',1,'Retail Sale Id 2909',0.00,157500.00,680.00,170000.00,12500.00,'2023-02-21 10:34:06'),(2878,'1','307',1,'Retail Sale Id 2910',0.00,3780.00,736.00,4416.00,636.00,'2023-02-21 10:42:35'),(2879,'1','307',1,'Retail Sale Id 2911',0.00,642.60,736.00,750.72,108.12,'2023-02-21 10:43:54'),(2880,'1','307',1,'Retail Sale Id 2912',0.00,2570.40,736.00,3002.88,432.48,'2023-02-21 10:44:53'),(2881,'1','307',1,'Retail Sale Id 2913',0.00,3767.40,736.00,4401.28,633.88,'2023-02-21 10:47:43'),(2882,'1','307',1,'Retail Sale Id 2914',0.00,3150.00,736.00,3680.00,530.00,'2023-02-21 10:49:51'),(2883,'1','307',1,'Retail Sale Id 2915',0.00,3780.00,736.00,4416.00,636.00,'2023-02-21 11:17:06'),(2884,'1','307',1,'Retail Sale Id 2916',0.00,1285.20,736.00,1501.44,216.24,'2023-02-21 11:18:17'),(2885,'1','307',1,'Retail Sale Id 2917',0.00,3780.00,736.00,4416.00,636.00,'2023-02-21 11:19:34'),(2886,'1','307',1,'Retail Sale Id 2918',0.00,1285.20,736.00,1501.44,216.24,'2023-02-21 11:21:01'),(2887,'1','307',1,'Retail Sale Id 2919',0.00,1713.60,736.00,2001.92,288.32,'2023-02-21 11:56:34'),(2888,'1','307',1,'Retail Sale Id 2920',0.00,2520.00,736.00,2944.00,424.00,'2023-02-21 12:01:04'),(2889,'1','307',1,'Retail Sale Id 2921',0.00,1890.00,736.00,2208.00,318.00,'2023-02-21 12:06:47'),(2890,'1','307',1,'Retail Sale Id 2922',0.00,3849.30,736.00,4496.96,647.66,'2023-02-21 12:19:46'),(2891,'1','307',1,'Retail Sale Id 2923',0.00,3780.00,736.00,4416.00,636.00,'2023-02-21 12:33:57'),(2892,'1','307',1,'Retail Sale Id 2924',0.00,3420.90,736.00,3996.48,575.58,'2023-02-21 13:22:19'),(2893,'1','307',1,'Retail Sale Id 2926',0.00,2570.40,736.00,3002.88,432.48,'2023-02-21 13:37:21'),(2894,'1','307',1,'Retail Sale Id 2927',0.00,1713.60,736.00,2001.92,288.32,'2023-02-21 14:14:03'),(2895,'1','307',1,'Retail Sale Id 2928',0.00,3786.30,736.00,4423.36,637.06,'2023-02-21 14:15:38'),(2896,'1','307',1,'Retail Sale Id 2929',0.00,3786.30,736.00,4423.36,637.06,'2023-02-21 14:17:23'),(2897,'1','307',1,'Retail Sale Id 2930',0.00,1285.20,736.00,1501.44,216.24,'2023-02-21 14:18:56'),(2898,'1','307',1,'Retail Sale Id 2931',0.00,4277.70,736.00,4997.44,719.74,'2023-02-21 14:39:21'),(2899,'1','307',1,'Retail Sale Id 2932',0.00,1367.10,736.00,1597.12,230.02,'2023-02-21 14:44:31'),(2900,'1','307',1,'Retail Sale Id 2933',0.00,3811.50,736.00,4452.80,641.30,'2023-02-21 14:55:29'),(2901,'1','307',1,'Retail Sale Id 2934',0.00,11661.30,736.00,13623.36,1962.06,'2023-02-21 14:58:05'),(2902,'1','307',1,'Retail Sale Id 2935',0.00,3786.30,736.00,4423.36,637.06,'2023-02-21 15:02:43'),(2903,'1','307',1,'Retail Sale Id 2936',0.00,2526.30,736.00,2951.36,425.06,'2023-02-21 15:22:46'),(2904,'1','307',1,'Retail Sale Id 2937',0.00,7875.00,680.00,8500.00,625.00,'2023-02-21 15:25:49'),(2905,'1','307',1,'Retail Sale Id 2938',0.00,3786.30,736.00,4423.36,637.06,'2023-02-21 15:31:01'),(2906,'1','307',1,'Retail Sale Id 2939',0.00,1927.80,736.00,2252.16,324.36,'2023-02-21 15:39:23'),(2907,'1','307',1,'Retail Sale Id 2940',0.00,1890.00,736.00,2208.00,318.00,'2023-02-21 15:47:46'),(2908,'1','307',1,'Retail Sale Id 2941',0.00,10395.00,736.00,12144.00,1749.00,'2023-02-21 16:22:42'),(2909,'1','307',1,'Retail Sale Id 2942',0.00,1285.20,736.00,1501.44,216.24,'2023-02-21 16:23:53'),(2910,'1','307',1,'Retail Sale Id 2943',0.00,1890.00,736.00,2208.00,318.00,'2023-02-21 16:29:23'),(2911,'1','307',1,'Retail Sale Id 2944',0.00,9160.20,736.00,10701.44,1541.24,'2023-02-21 16:30:20'),(2912,'1','307',1,'Retail Sale Id 2945',0.00,1285.20,736.00,1501.44,216.24,'2023-02-21 16:33:45'),(2913,'1','307',1,'Retail Sale Id 2946',0.00,3168.90,736.00,3702.08,533.18,'2023-02-21 16:34:51'),(2914,'1','307',1,'Retail Sale Id 2947',0.00,1247.40,736.00,1457.28,209.88,'2023-02-21 16:46:06'),(2915,'1','307',1,'Retail Sale Id 2948',0.00,8271.90,736.00,9663.68,1391.78,'2023-02-21 16:58:55'),(2916,'1','307',1,'Retail Sale Id 2949',0.00,1285.20,736.00,1501.44,216.24,'2023-02-21 17:01:06'),(2917,'1','307',1,'Retail Sale Id 2950',0.00,3786.30,736.00,4423.36,637.06,'2023-02-21 17:05:17'),(2918,'1','307',1,'Retail Sale Id 2951',0.00,1927.80,736.00,2252.16,324.36,'2023-02-21 17:07:38'),(2919,'1','307',1,'Retail Sale Id 2952',0.00,3786.30,736.00,4423.36,637.06,'2023-02-21 17:09:19'),(2920,'1','307',1,'Retail Sale Id 2953',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-21 17:11:55'),(2921,'1','307',1,'Retail Sale Id 2954',0.00,2570.40,736.00,3002.88,432.48,'2023-02-21 17:32:12'),(2922,'1','307',1,'Retail Sale Id 2955',0.00,2570.40,736.00,3002.88,432.48,'2023-02-21 17:35:09'),(2923,'1','307',1,'Retail Sale Id 2956',0.00,3786.30,736.00,4423.36,637.06,'2023-02-21 17:55:20'),(2924,'1','307',1,'Retail Sale Id 2957',0.00,2526.30,736.00,2951.36,425.06,'2023-02-21 18:04:48'),(2925,'1','307',1,'Retail Sale Id 2958',0.00,3168.90,736.00,3702.08,533.18,'2023-02-21 18:05:44'),(2926,'1','307',1,'Retail Sale Id 2959',0.00,1285.20,736.00,1501.44,216.24,'2023-02-21 18:13:09'),(2927,'1','307',1,'Retail Sale Id 2960',0.00,4876.20,736.00,5696.64,820.44,'2023-02-21 18:33:08'),(2928,'1','307',1,'Retail Sale Id 2961',0.00,10401.30,736.00,12151.36,1750.06,'2023-02-21 18:37:33'),(2929,'1','307',1,'Retail Sale Id 2962',0.00,2746.80,736.00,3208.96,462.16,'2023-02-21 19:13:08'),(2930,'1','307',1,'Retail Sale Id 2963',0.00,12152.70,736.00,14197.44,2044.74,'2023-02-21 19:19:34'),(2931,'1','307',1,'Retail Sale Id 2964',0.00,1890.00,736.00,2208.00,318.00,'2023-02-22 07:51:32'),(2932,'1','307',1,'Retail Sale Id 2965',0.00,2520.00,736.00,2944.00,424.00,'2023-02-22 07:52:36'),(2933,'1','307',1,'Retail Sale Id 2966',0.00,3780.00,736.00,4416.00,636.00,'2023-02-22 07:55:53'),(2934,'1','307',1,'Retail Sale Id 2967',0.00,2520.00,736.00,2944.00,424.00,'2023-02-22 07:58:59'),(2935,'1','307',1,'Retail Sale Id 2968',0.00,2570.40,736.00,3002.88,432.48,'2023-02-22 08:00:46'),(2936,'1','307',1,'Retail Sale Id 2969',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-22 08:04:17'),(2937,'1','307',1,'Retail Sale Id 2970',0.00,686.70,736.00,802.24,115.54,'2023-02-22 08:09:03'),(2938,'1','307',1,'Retail Sale Id 2971',0.00,3420.90,736.00,3996.48,575.58,'2023-02-22 08:13:04'),(2939,'1','307',1,'Retail Sale Id 2972',0.00,3150.00,736.00,3680.00,530.00,'2023-02-22 08:19:19'),(2940,'1','307',1,'Retail Sale Id 2973',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-22 08:31:24'),(2941,'1','307',1,'Retail Sale Id 2974',0.00,1713.60,736.00,2001.92,288.32,'2023-02-22 08:35:13'),(2942,'1','307',1,'Retail Sale Id 2975',0.00,3780.00,736.00,4416.00,636.00,'2023-02-22 08:36:46'),(2943,'1','307',1,'Retail Sale Id 2976',0.00,1890.00,736.00,2208.00,318.00,'2023-02-22 08:40:04'),(2944,'1','307',1,'Retail Sale Id 2977',0.00,3780.00,736.00,4416.00,636.00,'2023-02-22 08:47:29'),(2945,'1','307',1,'Retail Sale Id 2978',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-22 08:49:40'),(2946,'1','307',1,'Retail Sale Id 2979',0.00,6930.00,736.00,8096.00,1166.00,'2023-02-22 08:51:41'),(2947,'1','307',1,'Retail Sale Id 2980',0.00,3780.00,736.00,4416.00,636.00,'2023-02-22 08:53:29'),(2948,'1','307',1,'Retail Sale Id 2981',0.00,7560.00,736.00,8832.00,1272.00,'2023-02-22 09:03:48'),(2949,'1','307',1,'Retail Sale Id 2982',0.00,1285.20,736.00,1501.44,216.24,'2023-02-22 09:04:41'),(2950,'1','307',1,'Retail Sale Id 2983',0.00,1285.20,736.00,1501.44,216.24,'2023-02-22 09:06:40'),(2951,'1','307',1,'Retail Sale Id 2984',0.00,642.60,736.00,750.72,108.12,'2023-02-22 09:13:37'),(2952,'1','307',1,'Retail Sale Id 2985',0.00,1890.00,736.00,2208.00,318.00,'2023-02-22 09:14:48'),(2953,'1','307',1,'Retail Sale Id 2986',0.00,3150.00,736.00,3680.00,530.00,'2023-02-22 09:20:27'),(2954,'1','307',1,'Retail Sale Id 2987',0.00,1713.60,736.00,2001.92,288.32,'2023-02-22 09:22:11'),(2955,'1','307',1,'Retail Sale Id 2988',0.00,3780.00,736.00,4416.00,636.00,'2023-02-22 09:24:09'),(2956,'1','307',1,'Retail Sale Id 2989',0.00,1260.00,736.00,1472.00,212.00,'2023-02-22 09:30:12'),(2957,'1','307',1,'Retail Sale Id 2990',0.00,2570.40,736.00,3002.88,432.48,'2023-02-22 09:37:11'),(2958,'1','307',1,'Retail Sale Id 2991',0.00,3780.00,736.00,4416.00,636.00,'2023-02-22 09:50:29'),(2959,'1','307',1,'Retail Sale Id 2992',0.00,2520.00,736.00,2944.00,424.00,'2023-02-22 09:55:34'),(2960,'1','307',1,'Retail Sale Id 2993',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-22 10:17:32'),(2961,'1','307',1,'Retail Sale Id 2994',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-22 10:23:31'),(2962,'1','307',1,'Retail Sale Id 2995',0.00,1971.90,736.00,2303.68,331.78,'2023-02-22 10:25:15'),(2963,'1','307',1,'Retail Sale Id 2996',0.00,3780.00,736.00,4416.00,636.00,'2023-02-22 10:41:09'),(2964,'1','307',1,'Retail Sale Id 2997',0.00,3780.00,736.00,4416.00,636.00,'2023-02-22 10:48:04'),(2965,'1','307',1,'Retail Sale Id 2998',0.00,1890.00,736.00,2208.00,318.00,'2023-02-22 10:56:11'),(2966,'1','307',1,'Retail Sale Id 2999',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-22 11:03:40'),(2967,'1','307',1,'Retail Sale Id 3000',0.00,2142.00,736.00,2502.40,360.40,'2023-02-22 11:29:33'),(2968,'1','307',1,'Retail Sale Id 3001',0.00,3780.00,736.00,4416.00,636.00,'2023-02-22 11:36:47'),(2969,'1','307',1,'Retail Sale Id 3002',0.00,3849.30,736.00,4496.96,647.66,'2023-02-22 11:39:38'),(2970,'1','307',1,'Retail Sale Id 3003',0.00,1971.90,736.00,2303.68,331.78,'2023-02-22 11:46:54'),(2971,'1','307',1,'Retail Sale Id 3004',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-22 11:51:10'),(2972,'1','307',1,'Retail Sale Id 3005',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-22 11:55:14'),(2973,'1','307',1,'Retail Sale Id 3006',0.00,1890.00,736.00,2208.00,318.00,'2023-02-22 11:58:28'),(2974,'1','307',1,'Retail Sale Id 3007',0.00,1890.00,736.00,2208.00,318.00,'2023-02-22 11:59:22'),(2975,'1','307',1,'Retail Sale Id 3008',0.00,1890.00,736.00,2208.00,318.00,'2023-02-22 12:05:37'),(2976,'1','307',1,'Retail Sale Id 3009',0.00,1890.00,736.00,2208.00,318.00,'2023-02-22 12:09:53'),(2977,'1','307',1,'Retail Sale Id 3010',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-22 12:26:29'),(2978,'1','307',1,'Retail Sale Id 3011',0.00,47250.00,680.00,51000.00,3750.00,'2023-02-22 12:35:24'),(2979,'1','307',1,'Retail Sale Id 3012',0.00,3780.00,736.00,4416.00,636.00,'2023-02-22 12:49:43'),(2980,'1','307',1,'Retail Sale Id 3013',0.00,1890.00,736.00,2208.00,318.00,'2023-02-22 12:51:41'),(2981,'1','307',1,'Retail Sale Id 3014',0.00,3780.00,736.00,4416.00,636.00,'2023-02-22 12:53:50'),(2982,'1','307',1,'Retail Sale Id 3015',0.00,3420.90,736.00,3996.48,575.58,'2023-02-22 12:55:41'),(2983,'1','307',1,'Retail Sale Id 3016',0.00,1927.80,736.00,2252.16,324.36,'2023-02-22 13:52:02'),(2984,'1','307',1,'Retail Sale Id 3017',0.00,3786.30,736.00,4423.36,637.06,'2023-02-22 13:53:39'),(2985,'1','307',1,'Retail Sale Id 3018',0.00,1890.00,736.00,2208.00,318.00,'2023-02-22 13:54:52'),(2986,'1','307',1,'Retail Sale Id 3019',0.00,3168.90,736.00,3702.08,533.18,'2023-02-22 13:56:55'),(2987,'1','307',1,'Retail Sale Id 3020',0.00,3786.30,736.00,4423.36,637.06,'2023-02-22 14:26:22'),(2988,'1','307',1,'Retail Sale Id 3021',0.00,1285.20,736.00,1501.44,216.24,'2023-02-22 14:32:32'),(2989,'1','307',1,'Retail Sale Id 3022',0.00,1285.20,736.00,1501.44,216.24,'2023-02-22 14:46:01'),(2990,'1','307',1,'Retail Sale Id 3023',0.00,3786.30,736.00,4423.36,637.06,'2023-02-22 14:47:12'),(2991,'1','307',1,'Retail Sale Id 3024',0.00,3786.30,736.00,4423.36,637.06,'2023-02-22 15:14:10'),(2992,'1','307',1,'Retail Sale Id 3025',0.00,3786.30,736.00,4423.36,637.06,'2023-02-22 15:15:19'),(2993,'1','307',1,'Retail Sale Id 3026',0.00,1890.00,736.00,2208.00,318.00,'2023-02-22 15:20:11'),(2994,'1','307',1,'Retail Sale Id 3027',0.00,2998.80,736.00,3503.36,504.56,'2023-02-22 16:02:41'),(2995,'1','307',1,'Retail Sale Id 3028',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-22 16:23:54'),(2996,'1','307',1,'Retail Sale Id 3029',0.00,1890.00,736.00,2208.00,318.00,'2023-02-22 16:25:11'),(2997,'1','307',1,'Retail Sale Id 3030',0.00,3786.30,736.00,4423.36,637.06,'2023-02-22 16:34:14'),(2998,'1','307',1,'Retail Sale Id 3031',0.00,3168.90,736.00,3702.08,533.18,'2023-02-22 16:39:04'),(2999,'1','307',1,'Retail Sale Id 3032',0.00,1890.00,736.00,2208.00,318.00,'2023-02-22 16:55:50'),(3000,'1','307',1,'Retail Sale Id 3033',0.00,856.80,736.00,1000.96,144.16,'2023-02-22 16:56:55'),(3001,'1','307',1,'Retail Sale Id 3035',0.00,642.60,736.00,750.72,108.12,'2023-02-22 16:58:23'),(3002,'1','307',1,'Retail Sale Id 3036',0.00,1902.60,736.00,2222.72,320.12,'2023-02-22 17:28:40'),(3003,'1','307',1,'Retail Sale Id 3037',0.00,1713.60,736.00,2001.92,288.32,'2023-02-22 17:38:11'),(3004,'1','307',1,'Retail Sale Id 3038',0.00,642.60,736.00,750.72,108.12,'2023-02-22 17:53:50'),(3005,'1','307',1,'Retail Sale Id 3039',0.00,3150.00,736.00,3680.00,530.00,'2023-02-22 18:27:04'),(3006,'1','307',1,'Retail Sale Id 3040',0.00,630.00,736.00,736.00,106.00,'2023-02-22 18:30:52'),(3007,'1','307',1,'Retail Sale Id 3041',0.00,340.20,736.00,397.44,57.24,'2023-02-22 18:34:11'),(3008,'1','307',1,'Retail Sale Id 3042',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-22 18:42:18'),(3009,'1','307',1,'Retail Sale Id 3043',0.00,10999.80,736.00,12850.56,1850.76,'2023-02-22 19:09:47'),(3010,'1','307',1,'Retail Sale Id 3044',0.00,6570.90,736.00,7676.48,1105.58,'2023-02-22 19:11:32'),(3011,'1','307',1,'Retail Sale Id 3045',0.00,1260.00,736.00,1472.00,212.00,'2023-02-23 07:24:10'),(3012,'1','307',1,'Retail Sale Id 3046',0.00,2570.40,736.00,3002.88,432.48,'2023-02-23 07:25:13'),(3013,'1','307',1,'Retail Sale Id 3047',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-23 07:28:09'),(3014,'1','307',1,'Retail Sale Id 3048',0.00,1260.00,736.00,1472.00,212.00,'2023-02-23 07:34:16'),(3015,'1','307',1,'Retail Sale Id 3049',0.00,1285.20,736.00,1501.44,216.24,'2023-02-23 07:36:59'),(3016,'1','307',1,'Retail Sale Id 3050',0.00,630.00,736.00,736.00,106.00,'2023-02-23 07:38:08'),(3017,'1','307',1,'Retail Sale Id 3051',0.00,1285.20,736.00,1501.44,216.24,'2023-02-23 07:40:29'),(3018,'1','307',1,'Retail Sale Id 3052',0.00,3150.00,736.00,3680.00,530.00,'2023-02-23 08:09:20'),(3019,'1','307',1,'Retail Sale Id 3053',0.00,3780.00,736.00,4416.00,636.00,'2023-02-23 08:11:26'),(3020,'1','307',1,'Retail Sale Id 3054',0.00,3168.90,736.00,3702.08,533.18,'2023-02-23 08:19:29'),(3021,'1','307',1,'Retail Sale Id 3055',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-23 08:25:19'),(3022,'1','307',1,'Retail Sale Id 3056',0.00,1890.00,736.00,2208.00,318.00,'2023-02-23 08:34:10'),(3023,'1','307',1,'Retail Sale Id 3057',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-23 08:36:27'),(3024,'1','307',1,'Retail Sale Id 3058',0.00,1890.00,736.00,2208.00,318.00,'2023-02-23 08:37:51'),(3025,'1','307',1,'Retail Sale Id 3059',0.00,3780.00,736.00,4416.00,636.00,'2023-02-23 08:39:29'),(3026,'1','307',1,'Retail Sale Id 3060',0.00,630.00,736.00,736.00,106.00,'2023-02-23 08:40:52'),(3027,'1','307',1,'Retail Sale Id 3061',0.00,1285.20,736.00,1501.44,216.24,'2023-02-23 08:43:13'),(3028,'1','307',1,'Retail Sale Id 3062',0.00,3780.00,736.00,4416.00,636.00,'2023-02-23 08:49:30'),(3029,'1','307',1,'Retail Sale Id 3063',0.00,1902.60,736.00,2222.72,320.12,'2023-02-23 08:52:58'),(3030,'1','307',1,'Retail Sale Id 3064',0.00,1890.00,736.00,2208.00,318.00,'2023-02-23 08:55:13'),(3031,'1','307',1,'Retail Sale Id 3065',0.00,1890.00,736.00,2208.00,318.00,'2023-02-23 08:57:28'),(3032,'1','307',1,'Retail Sale Id 3067',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-23 08:59:04'),(3033,'1','307',1,'Retail Sale Id 3068',0.00,630.00,736.00,736.00,106.00,'2023-02-23 09:00:49'),(3034,'1','307',1,'Retail Sale Id 3069',0.00,1795.50,736.00,2097.60,302.10,'2023-02-23 09:11:39'),(3035,'1','307',1,'Retail Sale Id 3070',0.00,2520.00,736.00,2944.00,424.00,'2023-02-23 09:14:59'),(3036,'1','307',1,'Retail Sale Id 3071',0.00,1890.00,736.00,2208.00,318.00,'2023-02-23 09:16:34'),(3037,'1','307',1,'Retail Sale Id 3072',0.00,1890.00,736.00,2208.00,318.00,'2023-02-23 09:18:19'),(3038,'1','307',1,'Retail Sale Id 3073',0.00,1713.60,736.00,2001.92,288.32,'2023-02-23 09:19:26'),(3039,'1','307',1,'Retail Sale Id 3074',0.00,3150.00,736.00,3680.00,530.00,'2023-02-23 09:24:14'),(3040,'1','307',1,'Retail Sale Id 3075',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-23 09:32:19'),(3041,'1','307',1,'Retail Sale Id 3076',0.00,27795.60,680.00,30001.60,2206.00,'2023-02-23 09:36:47'),(3042,'1','307',1,'Retail Sale Id 3077',0.00,1285.20,736.00,1501.44,216.24,'2023-02-23 09:38:27'),(3043,'1','307',1,'Retail Sale Id 3078',0.00,1713.60,736.00,2001.92,288.32,'2023-02-23 09:41:07'),(3044,'1','307',1,'Retail Sale Id 3079',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-23 09:48:12'),(3045,'1','307',1,'Retail Sale Id 3081',0.00,3150.00,736.00,3680.00,530.00,'2023-02-23 09:50:50'),(3046,'1','307',1,'Retail Sale Id 3082',0.00,1883.70,736.00,2200.64,316.94,'2023-02-23 09:58:00'),(3047,'1','307',1,'Retail Sale Id 3084',0.00,1890.00,736.00,2208.00,318.00,'2023-02-23 10:02:44'),(3048,'1','307',1,'Retail Sale Id 3085',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-23 10:38:55'),(3049,'1','307',1,'Retail Sale Id 3086',0.00,3780.00,736.00,4416.00,636.00,'2023-02-23 10:40:36'),(3050,'1','307',1,'Retail Sale Id 3087',0.00,2520.00,736.00,2944.00,424.00,'2023-02-23 10:54:33'),(3051,'1','307',1,'Retail Sale Id 3088',0.00,3811.50,736.00,4452.80,641.30,'2023-02-23 10:56:54'),(3052,'1','307',1,'Retail Sale Id 3089',0.00,4277.70,736.00,4997.44,719.74,'2023-02-23 10:58:06'),(3053,'1','307',1,'Retail Sale Id 3090',0.00,856.80,736.00,1000.96,144.16,'2023-02-23 11:07:47'),(3054,'1','307',1,'Retail Sale Id 3091',0.00,3849.30,736.00,4496.96,647.66,'2023-02-23 11:35:48'),(3055,'1','307',1,'Retail Sale Id 3092',0.00,3849.30,736.00,4496.96,647.66,'2023-02-23 11:56:56'),(3056,'1','307',1,'Retail Sale Id 3093',0.00,3780.00,736.00,4416.00,636.00,'2023-02-23 12:08:26'),(3057,'1','307',1,'Retail Sale Id 3094',0.00,1260.00,736.00,1472.00,212.00,'2023-02-23 12:26:31'),(3058,'1','307',1,'Retail Sale Id 3095',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-23 12:27:42'),(3059,'1','307',1,'Retail Sale Id 3096',0.00,3150.00,736.00,3680.00,530.00,'2023-02-23 12:32:19'),(3060,'1','307',1,'Retail Sale Id 3097',0.00,2570.40,736.00,3002.88,432.48,'2023-02-23 12:48:25'),(3061,'1','307',1,'Retail Sale Id 3098',0.00,5670.00,736.00,6624.00,954.00,'2023-02-23 13:00:49'),(3062,'1','307',1,'Retail Sale Id 3099',0.00,1890.00,736.00,2208.00,318.00,'2023-02-23 13:01:41'),(3063,'1','307',1,'Retail Sale Id 3100',0.00,1890.00,736.00,2208.00,318.00,'2023-02-23 13:23:06'),(3064,'1','307',1,'Retail Sale Id 3101',0.00,1260.00,736.00,1472.00,212.00,'2023-02-23 13:30:50'),(3065,'1','307',1,'Retail Sale Id 3102',0.00,2570.40,736.00,3002.88,432.48,'2023-02-23 13:48:03'),(3066,'1','307',1,'Retail Sale Id 3103',0.00,1883.70,736.00,2200.64,316.94,'2023-02-23 13:57:48'),(3067,'1','307',1,'Retail Sale Id 3104',0.00,1285.20,736.00,1501.44,216.24,'2023-02-23 14:11:02'),(3068,'1','307',1,'Retail Sale Id 3105',0.00,3780.00,736.00,4416.00,636.00,'2023-02-23 14:12:34'),(3069,'1','307',1,'Retail Sale Id 3106',0.00,3811.50,736.00,4452.80,641.30,'2023-02-23 14:33:09'),(3070,'1','307',1,'Retail Sale Id 3107',0.00,15750.00,736.00,18400.00,2650.00,'2023-02-23 14:37:09'),(3071,'1','307',1,'Retail Sale Id 3108',0.00,3786.30,736.00,4423.36,637.06,'2023-02-23 14:41:04'),(3072,'1','307',1,'Retail Sale Id 3109',0.00,1890.00,736.00,2208.00,318.00,'2023-02-23 14:43:12'),(3073,'1','307',1,'Retail Sale Id 3110',0.00,2520.00,736.00,2944.00,424.00,'2023-02-23 14:52:44'),(3074,'1','307',1,'Retail Sale Id 3111',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-23 14:54:16'),(3075,'1','307',1,'Retail Sale Id 3112',0.00,3786.30,736.00,4423.36,637.06,'2023-02-23 14:56:37'),(3076,'1','307',1,'Retail Sale Id 3113',0.00,3786.30,736.00,4423.36,637.06,'2023-02-23 15:05:20'),(3077,'1','307',1,'Retail Sale Id 3114',0.00,2526.30,736.00,2951.36,425.06,'2023-02-23 15:07:21'),(3078,'1','307',1,'Retail Sale Id 3115',0.00,3168.90,736.00,3702.08,533.18,'2023-02-23 15:09:08'),(3079,'1','307',1,'Retail Sale Id 3116',0.00,642.60,736.00,750.72,108.12,'2023-02-23 15:23:08'),(3080,'1','307',1,'Retail Sale Id 3117',0.00,1890.00,736.00,2208.00,318.00,'2023-02-23 15:31:02'),(3081,'1','307',1,'Retail Sale Id 3118',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-23 15:36:14'),(3082,'1','307',1,'Retail Sale Id 3119',0.00,2526.30,736.00,2951.36,425.06,'2023-02-23 15:38:11'),(3083,'1','307',1,'Retail Sale Id 3120',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-23 15:54:43'),(3084,'1','307',1,'Retail Sale Id 3121',0.00,3786.30,736.00,4423.36,637.06,'2023-02-23 15:55:53'),(3085,'1','307',1,'Retail Sale Id 3122',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-23 16:00:54'),(3086,'1','307',1,'Retail Sale Id 3123',0.00,1285.20,736.00,1501.44,216.24,'2023-02-23 16:01:57'),(3087,'1','307',1,'Retail Sale Id 3124',0.00,3168.90,736.00,3702.08,533.18,'2023-02-23 16:09:48'),(3088,'1','307',1,'Retail Sale Id 3125',0.00,3150.00,736.00,3680.00,530.00,'2023-02-23 16:22:36'),(3089,'1','307',1,'Retail Sale Id 3126',0.00,3786.30,736.00,4423.36,637.06,'2023-02-23 16:24:02'),(3090,'1','307',1,'Retail Sale Id 3127',0.00,1890.00,736.00,2208.00,318.00,'2023-02-23 16:25:12'),(3091,'1','307',1,'Retail Sale Id 3128',0.00,1285.20,736.00,1501.44,216.24,'2023-02-23 16:26:24'),(3092,'1','307',1,'Retail Sale Id 3129',0.00,1890.00,736.00,2208.00,318.00,'2023-02-23 16:27:26'),(3093,'1','307',1,'Retail Sale Id 3130',0.00,1285.20,736.00,1501.44,216.24,'2023-02-23 16:40:34'),(3094,'1','307',1,'Retail Sale Id 3131',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-23 16:43:13'),(3095,'1','307',1,'Retail Sale Id 3132',0.00,2142.00,736.00,2502.40,360.40,'2023-02-23 16:44:53'),(3096,'1','307',1,'Return of Retail Sale Id 3132',2142.00,0.00,736.00,-2502.40,-360.40,'2023-02-23 17:24:44'),(3097,'1','307',1,'Return of Retail Sale Id 3130',1285.20,0.00,736.00,-1501.44,-216.24,'2023-02-23 17:26:25'),(3098,'1','307',1,'Return of Retail Sale Id 3131',31500.00,0.00,680.00,-34000.00,-2500.00,'2023-02-23 17:27:05'),(3099,'1','307',1,'Retail Sale Id 3133',0.00,20229.30,680.00,21834.80,1605.50,'2023-02-23 17:47:09'),(3100,'1','307',1,'Retail Sale Id 3134',0.00,12184.20,736.00,14234.24,2050.04,'2023-02-23 17:48:27'),(3101,'1','307',1,'Sale Id 5',0.00,28765.80,736.00,33605.76,4839.96,'2023-02-23 17:51:31'),(3102,'1','307',1,'Retail Sale Id 3135',0.00,17369.10,736.00,20291.52,2922.42,'2023-02-24 07:31:05'),(3103,'1','307',1,'Retail Sale Id 3136',0.00,8694.00,736.00,10156.80,1462.80,'2023-02-24 07:45:52'),(3104,'1','307',1,'Retail Sale Id 3137',0.00,15447.60,736.00,18046.72,2599.12,'2023-02-24 07:54:27'),(3105,'1','307',1,'Retail Sale Id 3138',0.00,2520.00,736.00,2944.00,424.00,'2023-02-24 07:59:08'),(3106,'1','307',1,'Retail Sale Id 3139',0.00,3150.00,736.00,3680.00,530.00,'2023-02-24 08:26:03'),(3107,'1','307',1,'Retail Sale Id 3140',0.00,1285.20,736.00,1501.44,216.24,'2023-02-24 08:27:56'),(3108,'1','307',1,'Retail Sale Id 3141',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-24 08:29:48'),(3109,'1','307',1,'Retail Sale Id 3142',0.00,1890.00,736.00,2208.00,318.00,'2023-02-24 08:40:48'),(3110,'1','307',1,'Retail Sale Id 3143',0.00,4277.70,736.00,4997.44,719.74,'2023-02-24 08:43:03'),(3111,'1','307',1,'Retail Sale Id 3144',0.00,1285.20,736.00,1501.44,216.24,'2023-02-24 08:44:38'),(3112,'1','307',1,'Retail Sale Id 3145',0.00,3420.90,736.00,3996.48,575.58,'2023-02-24 08:54:33'),(3113,'1','307',1,'Retail Sale Id 3146',0.00,3786.30,736.00,4423.36,637.06,'2023-02-24 08:57:30'),(3114,'1','307',1,'Retail Sale Id 3147',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-24 08:58:58'),(3115,'1','307',1,'Retail Sale Id 3148',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-24 09:00:34'),(3116,'1','307',1,'Retail Sale Id 3149',0.00,1890.00,736.00,2208.00,318.00,'2023-02-24 09:06:35'),(3117,'1','307',1,'Retail Sale Id 3150',0.00,1285.20,736.00,1501.44,216.24,'2023-02-24 09:20:01'),(3118,'1','307',1,'Retail Sale Id 3151',0.00,3786.30,736.00,4423.36,637.06,'2023-02-24 09:32:42'),(3119,'1','307',1,'Retail Sale Id 3152',0.00,1285.20,736.00,1501.44,216.24,'2023-02-24 09:38:21'),(3120,'1','307',1,'Retail Sale Id 3153',0.00,3150.00,736.00,3680.00,530.00,'2023-02-24 09:43:36'),(3121,'1','307',1,'Retail Sale Id 3154',0.00,3849.30,736.00,4496.96,647.66,'2023-02-24 09:46:52'),(3122,'1','307',1,'Retail Sale Id 3155',0.00,3786.30,736.00,4423.36,637.06,'2023-02-24 09:49:12'),(3123,'1','307',1,'Retail Sale Id 3156',0.00,1197.00,736.00,1398.40,201.40,'2023-02-24 09:50:32'),(3124,'1','307',1,'Retail Sale Id 3157',0.00,856.80,736.00,1000.96,144.16,'2023-02-24 09:51:32'),(3125,'1','307',1,'Retail Sale Id 3158',0.00,3786.30,736.00,4423.36,637.06,'2023-02-24 10:18:51'),(3126,'1','307',1,'Retail Sale Id 3159',0.00,1713.60,736.00,2001.92,288.32,'2023-02-24 10:29:31'),(3127,'1','307',1,'Retail Sale Id 3160',0.00,103950.00,680.00,112200.00,8250.00,'2023-02-24 10:34:15'),(3128,'1','307',1,'Retail Sale Id 3161',0.00,2570.40,736.00,3002.88,432.48,'2023-02-24 10:35:36'),(3129,'1','307',1,'Retail Sale Id 3162',0.00,1285.20,736.00,1501.44,216.24,'2023-02-24 10:40:06'),(3130,'1','307',1,'Retail Sale Id 3163',0.00,6300.00,736.00,7360.00,1060.00,'2023-02-24 10:45:41'),(3131,'1','307',1,'Retail Sale Id 3164',0.00,5134.50,736.00,5998.40,863.90,'2023-02-24 10:47:07'),(3132,'1','307',1,'Retail Sale Id 3165',0.00,2570.40,736.00,3002.88,432.48,'2023-02-24 10:49:01'),(3133,'1','307',1,'Retail Sale Id 3166',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-24 10:51:59'),(3134,'1','307',1,'Retail Sale Id 3167',0.00,3786.30,736.00,4423.36,637.06,'2023-02-24 10:55:26'),(3135,'1','307',1,'Retail Sale Id 3168',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-24 10:58:56'),(3136,'1','307',1,'Retail Sale Id 3169',0.00,3786.30,736.00,4423.36,637.06,'2023-02-24 11:36:36'),(3137,'1','307',1,'Retail Sale Id 3170',0.00,3150.00,736.00,3680.00,530.00,'2023-02-24 11:56:35'),(3138,'1','307',1,'Retail Sale Id 3171',0.00,1285.20,736.00,1501.44,216.24,'2023-02-24 12:03:34'),(3139,'1','307',1,'Retail Sale Id 3172',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-24 12:49:25'),(3140,'1','307',1,'Retail Sale Id 3173',0.00,6331.50,736.00,7396.80,1065.30,'2023-02-24 12:51:23'),(3141,'1','307',1,'Retail Sale Id 3174',0.00,856.80,736.00,1000.96,144.16,'2023-02-24 12:52:18'),(3142,'1','307',1,'Retail Sale Id 3175',0.00,3786.30,736.00,4423.36,637.06,'2023-02-24 12:54:36'),(3143,'1','307',1,'Retail Sale Id 3176',0.00,856.80,736.00,1000.96,144.16,'2023-02-24 12:56:33'),(3144,'1','307',1,'Retail Sale Id 3177',0.00,8133.30,736.00,9501.76,1368.46,'2023-02-24 13:39:22'),(3145,'1','307',1,'Retail Sale Id 3178',0.00,10754.10,736.00,12563.52,1809.42,'2023-02-24 14:06:34'),(3146,'1','307',1,'Retail Sale Id 3179',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-24 14:15:54'),(3147,'1','307',1,'Retail Sale Id 3180',0.00,1285.20,736.00,1501.44,216.24,'2023-02-24 14:28:37'),(3148,'1','307',1,'Retail Sale Id 3181',0.00,3849.30,736.00,4496.96,647.66,'2023-02-24 14:32:05'),(3149,'1','307',1,'Retail Sale Id 3182',0.00,2570.40,736.00,3002.88,432.48,'2023-02-24 14:38:16'),(3150,'1','307',1,'Retail Sale Id 3183',0.00,4454.10,736.00,5203.52,749.42,'2023-02-24 14:46:40'),(3151,'1','307',1,'Retail Sale Id 3184',0.00,3780.00,736.00,4416.00,636.00,'2023-02-24 14:49:15'),(3152,'1','307',1,'Retail Sale Id 3185',0.00,1883.70,736.00,2200.64,316.94,'2023-02-24 14:51:14'),(3153,'1','307',1,'Retail Sale Id 3186',0.00,1915.20,736.00,2237.44,322.24,'2023-02-24 14:52:48'),(3154,'1','307',1,'Retail Sale Id 3187',0.00,1890.00,736.00,2208.00,318.00,'2023-02-24 15:29:25'),(3155,'1','307',1,'Retail Sale Id 3188',0.00,9765.00,736.00,11408.00,1643.00,'2023-02-24 15:31:50'),(3156,'1','307',1,'Retail Sale Id 3189',0.00,2570.40,736.00,3002.88,432.48,'2023-02-24 15:32:42'),(3157,'1','307',1,'Retail Sale Id 3190',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-24 15:37:16'),(3158,'1','307',1,'Retail Sale Id 3191',0.00,1285.20,736.00,1501.44,216.24,'2023-02-24 15:42:24'),(3159,'1','307',1,'Retail Sale Id 3192',0.00,2526.30,736.00,2951.36,425.06,'2023-02-24 15:45:19'),(3160,'1','307',1,'Retail Sale Id 3193',0.00,24601.50,736.00,28740.80,4139.30,'2023-02-24 16:29:40'),(3161,'1','307',1,'Retail Sale Id 3194',0.00,2526.30,736.00,2951.36,425.06,'2023-02-24 16:32:28'),(3162,'1','307',1,'Retail Sale Id 3195',0.00,2570.40,736.00,3002.88,432.48,'2023-02-24 16:34:33'),(3163,'1','307',1,'Retail Sale Id 3196',0.00,1902.60,736.00,2222.72,320.12,'2023-02-24 16:50:38'),(3164,'1','307',1,'Retail Sale Id 3197',0.00,856.80,736.00,1000.96,144.16,'2023-02-24 16:53:58'),(3165,'1','307',1,'Retail Sale Id 3198',0.00,3786.30,736.00,4423.36,637.06,'2023-02-24 16:55:13'),(3166,'1','307',1,'Retail Sale Id 3199',0.00,4454.10,736.00,5203.52,749.42,'2023-02-24 17:05:10'),(3167,'1','307',1,'Retail Sale Id 3200',0.00,1890.00,736.00,2208.00,318.00,'2023-02-24 17:10:04'),(3168,'1','307',1,'Retail Sale Id 3201',0.00,1890.00,736.00,2208.00,318.00,'2023-02-24 17:17:04'),(3169,'1','307',1,'Retail Sale Id 3201',0.00,3420.90,736.00,3996.48,575.58,'2023-02-24 17:17:04'),(3170,'1','307',1,'Retail Sale Id 3202',0.00,1285.20,736.00,1501.44,216.24,'2023-02-24 17:33:00'),(3171,'1','307',1,'Retail Sale Id 3203',0.00,11421.90,736.00,13343.68,1921.78,'2023-02-24 17:34:38'),(3172,'1','307',1,'Retail Sale Id 3204',0.00,1890.00,736.00,2208.00,318.00,'2023-02-24 17:38:02'),(3173,'1','307',1,'Retail Sale Id 3205',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-24 17:40:07'),(3174,'1','307',1,'Retail Sale Id 3206',0.00,938.70,736.00,1096.64,157.94,'2023-02-24 17:45:34'),(3175,'1','307',1,'Retail Sale Id 3207',0.00,10086.30,736.00,11783.36,1697.06,'2023-02-24 17:48:25'),(3176,'1','307',1,'Retail Sale Id 3208',0.00,1285.20,736.00,1501.44,216.24,'2023-02-24 18:19:30'),(3177,'1','307',1,'Retail Sale Id 3209',0.00,3780.00,736.00,4416.00,636.00,'2023-02-24 18:22:34'),(3178,'1','307',1,'Retail Sale Id 3210',0.00,1713.60,736.00,2001.92,288.32,'2023-02-24 18:26:49'),(3179,'1','307',1,'Retail Sale Id 3211',0.00,54765.90,736.00,63980.48,9214.58,'2023-02-24 18:30:18'),(3180,'1','307',1,'Retail Sale Id 3212',0.00,3168.90,736.00,3702.08,533.18,'2023-02-24 18:40:58'),(3181,'1','307',1,'Retail Sale Id 3213',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-24 18:53:02'),(3182,'1','307',1,'Retail Sale Id 3214',0.00,1285.20,736.00,1501.44,216.24,'2023-02-24 19:05:06'),(3183,'1','307',1,'Retail Sale Id 3215',0.00,9765.00,736.00,11408.00,1643.00,'2023-02-24 19:06:59'),(3184,'1','307',1,'Retail Sale Id 3216',0.00,1890.00,736.00,2208.00,318.00,'2023-02-24 19:08:39'),(3185,'1','307',1,'Retail Sale Id 3217',0.00,25187.40,736.00,29425.28,4237.88,'2023-02-24 19:32:27'),(3186,'1','307',1,'Retail Sale Id 3218',0.00,3780.00,736.00,4416.00,636.00,'2023-02-26 07:32:31'),(3187,'1','307',1,'Retail Sale Id 3219',0.00,189.00,736.00,220.80,31.80,'2023-02-26 07:46:11'),(3188,'1','307',1,'Retail Sale Id 3220',0.00,686.70,736.00,802.24,115.54,'2023-02-26 07:47:15'),(3189,'1','307',1,'Retail Sale Id 3221',0.00,195300.00,680.00,210800.00,15500.00,'2023-02-26 07:51:17'),(3190,'1','307',1,'Retail Sale Id 3222',0.00,1890.00,736.00,2208.00,318.00,'2023-02-26 08:19:54'),(3191,'1','307',1,'Retail Sale Id 3224',0.00,7560.00,736.00,8832.00,1272.00,'2023-02-26 08:22:17'),(3192,'1','307',1,'Retail Sale Id 3226',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-26 08:26:22'),(3193,'1','307',1,'Retail Sale Id 3225',0.00,1890.00,736.00,2208.00,318.00,'2023-02-26 08:26:50'),(3194,'1','307',1,'Retail Sale Id 3227',0.00,6300.00,736.00,7360.00,1060.00,'2023-02-26 08:42:35'),(3195,'1','307',1,'Retail Sale Id 3228',0.00,3780.00,736.00,4416.00,636.00,'2023-02-26 09:17:32'),(3196,'1','307',1,'Retail Sale Id 3229',0.00,3150.00,736.00,3680.00,530.00,'2023-02-26 09:18:28'),(3197,'1','307',1,'Retail Sale Id 3230',0.00,642.60,736.00,750.72,108.12,'2023-02-26 09:21:28'),(3198,'1','307',1,'Retail Sale Id 3231',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-26 09:31:57'),(3199,'1','307',1,'Retail Sale Id 3232',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-26 10:02:56'),(3200,'1','307',1,'Retail Sale Id 3233',0.00,5991.30,736.00,6999.36,1008.06,'2023-02-26 10:08:08'),(3201,'1','307',1,'Retail Sale Id 3234',0.00,642.60,736.00,750.72,108.12,'2023-02-26 10:09:21'),(3202,'1','307',1,'Retail Sale Id 3235',0.00,4277.70,736.00,4997.44,719.74,'2023-02-26 10:11:52'),(3203,'1','307',1,'Retail Sale Id 3236',0.00,3780.00,736.00,4416.00,636.00,'2023-02-26 10:20:18'),(3204,'1','307',1,'Retail Sale Id 3237',0.00,2998.80,736.00,3503.36,504.56,'2023-02-26 10:21:15'),(3205,'1','307',1,'Retail Sale Id 3238',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-26 10:28:04'),(3206,'1','307',1,'Retail Sale Id 3239',0.00,5562.90,736.00,6498.88,935.98,'2023-02-26 10:36:01'),(3207,'1','307',1,'Retail Sale Id 3240',0.00,3849.30,736.00,4496.96,647.66,'2023-02-26 11:29:41'),(3208,'1','307',1,'Retail Sale Id 3241',0.00,856.80,736.00,1000.96,144.16,'2023-02-26 11:35:55'),(3209,'1','307',1,'Retail Sale Id 3242',0.00,2520.00,736.00,2944.00,424.00,'2023-02-26 11:46:27'),(3210,'1','307',1,'Retail Sale Id 3243',0.00,3780.00,736.00,4416.00,636.00,'2023-02-26 11:51:44'),(3211,'1','307',1,'Retail Sale Id 3244',0.00,1260.00,736.00,1472.00,212.00,'2023-02-26 11:56:04'),(3212,'1','307',1,'Retail Sale Id 3245',0.00,7560.00,736.00,8832.00,1272.00,'2023-02-26 12:03:59'),(3213,'1','307',1,'Retail Sale Id 3246',0.00,3780.00,736.00,4416.00,636.00,'2023-02-26 12:09:31'),(3214,'1','307',1,'Retail Sale Id 3247',0.00,3780.00,736.00,4416.00,636.00,'2023-02-26 12:11:54'),(3215,'1','307',1,'Retail Sale Id 3248',0.00,24021.90,736.00,28063.68,4041.78,'2023-02-26 14:30:04'),(3216,'1','307',1,'Retail Sale Id 3249',0.00,78750.00,680.00,85000.00,6250.00,'2023-02-26 14:31:09'),(3217,'1','307',1,'Retail Sale Id 3250',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-26 14:32:13'),(3218,'1','307',1,'Retail Sale Id 3251',0.00,6615.00,680.00,7140.00,525.00,'2023-02-26 15:51:33'),(3219,'1','307',1,'Retail Sale Id 3252',0.00,3786.30,736.00,4423.36,637.06,'2023-02-26 15:54:51'),(3220,'1','307',1,'Retail Sale Id 3253',0.00,1285.20,736.00,1501.44,216.24,'2023-02-26 15:56:30'),(3221,'1','307',1,'Retail Sale Id 3254',0.00,3150.00,736.00,3680.00,530.00,'2023-02-26 15:59:26'),(3222,'1','307',1,'Retail Sale Id 3255',0.00,86625.00,680.00,93500.00,6875.00,'2023-02-26 16:47:02'),(3223,'1','307',1,'Retail Sale Id 3256',0.00,1927.80,736.00,2252.16,324.36,'2023-02-26 17:02:06'),(3224,'1','307',1,'Retail Sale Id 3257',0.00,3786.30,736.00,4423.36,637.06,'2023-02-26 17:17:16'),(3225,'1','307',1,'Retail Sale Id 3258',0.00,15705.90,736.00,18348.48,2642.58,'2023-02-26 17:46:17'),(3226,'1','307',1,'Retail Sale Id 3259',0.00,86543.10,736.00,101104.32,14561.22,'2023-02-26 19:18:56'),(3227,'1','307',1,'Retail Sale Id 3260',0.00,3150.00,736.00,3680.00,530.00,'2023-02-27 07:26:45'),(3228,'1','307',1,'Retail Sale Id 3261',0.00,1285.20,736.00,1501.44,216.24,'2023-02-27 07:59:00'),(3229,'1','307',1,'Retail Sale Id 3262',0.00,1713.60,736.00,2001.92,288.32,'2023-02-27 07:59:40'),(3230,'1','307',1,'Retail Sale Id 3263',0.00,1713.60,736.00,2001.92,288.32,'2023-02-27 08:10:15'),(3231,'1','307',1,'Retail Sale Id 3264',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-27 08:34:40'),(3232,'1','307',1,'Retail Sale Id 3265',0.00,630.00,736.00,736.00,106.00,'2023-02-27 08:39:51'),(3233,'1','307',1,'Retail Sale Id 3266',0.00,126000.00,680.00,136000.00,10000.00,'2023-02-27 08:43:15'),(3234,'1','307',1,'Retail Sale Id 3267',0.00,1890.00,736.00,2208.00,318.00,'2023-02-27 08:51:58'),(3235,'1','307',1,'Retail Sale Id 3268',0.00,1285.20,736.00,1501.44,216.24,'2023-02-27 08:57:48'),(3236,'1','307',1,'Retail Sale Id 3269',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-27 08:59:20'),(3237,'1','307',1,'Retail Sale Id 3270',0.00,3849.30,736.00,4496.96,647.66,'2023-02-27 09:03:41'),(3238,'1','307',1,'Retail Sale Id 3271',0.00,3780.00,736.00,4416.00,636.00,'2023-02-27 11:14:44'),(3239,'1','307',1,'Retail Sale Id 3272',0.00,1890.00,736.00,2208.00,318.00,'2023-02-27 11:19:56'),(3240,'1','307',1,'Retail Sale Id 3273',0.00,3786.30,736.00,4423.36,637.06,'2023-02-27 11:28:04'),(3241,'1','307',1,'Retail Sale Id 3274',0.00,2526.30,736.00,2951.36,425.06,'2023-02-27 11:29:40'),(3242,'1','307',1,'Retail Sale Id 3275',0.00,1285.20,736.00,1501.44,216.24,'2023-02-27 11:30:33'),(3243,'1','307',1,'Retail Sale Id 3276',0.00,1883.70,736.00,2200.64,316.94,'2023-02-27 11:38:23'),(3244,'1','307',1,'Retail Sale Id 3277',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-27 11:39:48'),(3245,'1','307',1,'Retail Sale Id 3278',0.00,1890.00,736.00,2208.00,318.00,'2023-02-27 11:41:28'),(3246,'1','307',1,'Retail Sale Id 3279',0.00,1890.00,736.00,2208.00,318.00,'2023-02-27 11:53:23'),(3247,'1','307',1,'Retail Sale Id 3280',0.00,1883.70,736.00,2200.64,316.94,'2023-02-27 11:54:34'),(3248,'1','307',1,'Retail Sale Id 3281',0.00,3849.30,736.00,4496.96,647.66,'2023-02-27 11:58:04'),(3249,'1','307',1,'Retail Sale Id 3282',0.00,3780.00,736.00,4416.00,636.00,'2023-02-27 12:07:06'),(3250,'1','307',1,'Retail Sale Id 3283',0.00,1890.00,736.00,2208.00,318.00,'2023-02-27 12:17:11'),(3251,'1','307',1,'Retail Sale Id 3284',0.00,3780.00,736.00,4416.00,636.00,'2023-02-27 12:21:43'),(3252,'1','307',1,'Retail Sale Id 3285',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-27 12:22:55'),(3253,'1','307',1,'Retail Sale Id 3286',0.00,1285.20,736.00,1501.44,216.24,'2023-02-27 12:24:37'),(3254,'1','307',1,'Retail Sale Id 3287',0.00,30391.20,680.00,32803.20,2412.00,'2023-02-27 12:30:12'),(3255,'1','307',1,'Retail Sale Id 3288',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-27 12:31:09'),(3256,'1','307',1,'Retail Sale Id 3289',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-27 12:40:53'),(3257,'1','307',1,'Retail Sale Id 3290',0.00,1285.20,736.00,1501.44,216.24,'2023-02-27 12:48:47'),(3258,'1','307',1,'Retail Sale Id 3291',0.00,1713.60,736.00,2001.92,288.32,'2023-02-27 12:53:27'),(3259,'1','307',1,'Retail Sale Id 3292',0.00,3849.30,736.00,4496.96,647.66,'2023-02-27 12:54:36'),(3260,'1','307',1,'Retail Sale Id 3293',0.00,3849.30,736.00,4496.96,647.66,'2023-02-27 12:57:13'),(3261,'1','307',1,'Retail Sale Id 3294',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-27 13:10:47'),(3262,'1','307',1,'Retail Sale Id 3295',0.00,18994.50,680.00,20502.00,1507.50,'2023-02-27 15:39:42'),(3263,'1','307',1,'Retail Sale Id 3296',0.00,1285.20,736.00,1501.44,216.24,'2023-02-27 17:17:55'),(3264,'1','307',1,'Retail Sale Id 3297',0.00,3150.00,736.00,3680.00,530.00,'2023-02-27 17:25:35'),(3265,'1','307',1,'Retail Sale Id 3298',0.00,3786.30,736.00,4423.36,637.06,'2023-02-27 17:29:15'),(3266,'1','307',1,'Retail Sale Id 3299',0.00,18900.00,680.00,20400.00,1500.00,'2023-02-27 17:36:34'),(3267,'1','307',1,'Retail Sale Id 3300',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-27 17:38:47'),(3268,'1','307',1,'Retail Sale Id 3301',0.00,1285.20,736.00,1501.44,216.24,'2023-02-27 17:41:03'),(3269,'1','307',1,'Retail Sale Id 3302',0.00,2526.30,736.00,2951.36,425.06,'2023-02-27 17:49:01'),(3270,'1','307',1,'Retail Sale Id 3303',0.00,2570.40,736.00,3002.88,432.48,'2023-02-27 17:51:04'),(3271,'1','307',1,'Retail Sale Id 3304',0.00,856.80,736.00,1000.96,144.16,'2023-02-27 17:52:23'),(3272,'1','307',1,'Retail Sale Id 3305',0.00,88691.40,736.00,103614.08,14922.68,'2023-02-27 18:50:00'),(3273,'1','307',1,'Retail Sale Id 3306',0.00,9884.70,680.00,10669.20,784.50,'2023-02-27 18:52:48'),(3274,'1','307',1,'Retail Sale Id 3307',0.00,8190.00,736.00,9568.00,1378.00,'2023-02-28 07:27:30'),(3275,'1','307',1,'Retail Sale Id 3308',0.00,1890.00,736.00,2208.00,318.00,'2023-02-28 07:57:11'),(3276,'1','307',1,'Retail Sale Id 3309',0.00,6419.70,736.00,7499.84,1080.14,'2023-02-28 08:20:40'),(3277,'1','307',1,'Retail Sale Id 3310',0.00,3780.00,736.00,4416.00,636.00,'2023-02-28 08:28:25'),(3278,'1','307',1,'Retail Sale Id 3311',0.00,3849.30,736.00,4496.96,647.66,'2023-02-28 08:29:21'),(3279,'1','307',1,'Retail Sale Id 3312',0.00,63000.00,680.00,68000.00,5000.00,'2023-02-28 08:35:33'),(3280,'1','307',1,'Retail Sale Id 3313',0.00,3780.00,736.00,4416.00,636.00,'2023-02-28 08:48:36'),(3281,'1','307',1,'Retail Sale Id 3314',0.00,3780.00,736.00,4416.00,636.00,'2023-02-28 08:50:02'),(3282,'1','307',1,'Retail Sale Id 3315',0.00,1713.60,736.00,2001.92,288.32,'2023-02-28 08:57:14'),(3283,'1','307',1,'Retail Sale Id 3316',0.00,1260.00,736.00,1472.00,212.00,'2023-02-28 09:38:34'),(3284,'1','307',1,'Retail Sale Id 3317',0.00,31500.00,736.00,36800.00,5300.00,'2023-02-28 09:39:30'),(3285,'1','307',1,'Retail Sale Id 3318',0.00,1890.00,736.00,2208.00,318.00,'2023-02-28 09:50:57'),(3286,'1','307',1,'Retail Sale Id 3319',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-28 09:55:25'),(3287,'1','307',1,'Retail Sale Id 3320',0.00,2570.40,736.00,3002.88,432.48,'2023-02-28 10:18:31'),(3288,'1','307',1,'Retail Sale Id 3321',0.00,2520.00,736.00,2944.00,424.00,'2023-02-28 10:20:10'),(3289,'1','307',1,'Retail Sale Id 3322',0.00,3780.00,736.00,4416.00,636.00,'2023-02-28 10:22:49'),(3290,'1','307',1,'Retail Sale Id 3323',0.00,1260.00,736.00,1472.00,212.00,'2023-02-28 10:29:47'),(3291,'1','307',1,'Retail Sale Id 3324',0.00,4725.00,736.00,5520.00,795.00,'2023-02-28 10:34:03'),(3292,'1','307',1,'Retail Sale Id 3325',0.00,3780.00,736.00,4416.00,636.00,'2023-02-28 10:44:14'),(3293,'1','307',1,'Retail Sale Id 3326',0.00,2570.40,736.00,3002.88,432.48,'2023-02-28 10:55:53'),(3294,'1','307',1,'Retail Sale Id 3327',0.00,1902.60,736.00,2222.72,320.12,'2023-02-28 10:57:36'),(3295,'1','307',1,'Retail Sale Id 3328',0.00,1883.70,736.00,2200.64,316.94,'2023-02-28 10:59:42'),(3296,'1','307',1,'Retail Sale Id 3329',0.00,2520.00,736.00,2944.00,424.00,'2023-02-28 11:08:11'),(3297,'1','307',1,'Retail Sale Id 3330',0.00,14225.40,736.00,16618.88,2393.48,'2023-02-28 11:28:22'),(3298,'1','307',1,'Retail Sale Id 3331',0.00,10697.40,736.00,12497.28,1799.88,'2023-02-28 11:31:40'),(3299,'1','307',1,'Retail Sale Id 3332',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-28 11:37:36'),(3300,'1','307',1,'Retail Sale Id 3333',0.00,3780.00,736.00,4416.00,636.00,'2023-02-28 12:07:07'),(3301,'1','307',1,'Retail Sale Id 3334',0.00,642.60,736.00,750.72,108.12,'2023-02-28 12:31:46'),(3302,'1','307',1,'Retail Sale Id 3335',0.00,1260.00,736.00,1472.00,212.00,'2023-02-28 12:50:03'),(3303,'1','307',1,'Retail Sale Id 3336',0.00,1285.20,736.00,1501.44,216.24,'2023-02-28 12:55:25'),(3304,'1','307',1,'Retail Sale Id 3337',0.00,1890.00,736.00,2208.00,318.00,'2023-02-28 12:59:37'),(3305,'1','307',1,'Retail Sale Id 3338',0.00,3780.00,736.00,4416.00,636.00,'2023-02-28 13:00:51'),(3306,'1','307',1,'Retail Sale Id 3339',0.00,856.80,736.00,1000.96,144.16,'2023-02-28 14:31:29'),(3307,'1','307',1,'Retail Sale Id 3340',0.00,3150.00,736.00,3680.00,530.00,'2023-02-28 14:34:37'),(3308,'1','307',1,'Retail Sale Id 3341',0.00,1285.20,736.00,1501.44,216.24,'2023-02-28 14:36:53'),(3309,'1','307',1,'Retail Sale Id 3342',0.00,3786.30,736.00,4423.36,637.06,'2023-02-28 14:40:04'),(3310,'1','307',1,'Retail Sale Id 3343',0.00,3811.50,736.00,4452.80,641.30,'2023-02-28 16:08:56'),(3311,'1','307',1,'Retail Sale Id 3344',0.00,3786.30,736.00,4423.36,637.06,'2023-02-28 16:16:57'),(3312,'1','307',1,'Retail Sale Id 3345',0.00,2570.40,736.00,3002.88,432.48,'2023-02-28 16:19:18'),(3313,'1','307',1,'Retail Sale Id 3346',0.00,3597.30,736.00,4202.56,605.26,'2023-02-28 17:08:18'),(3314,'1','307',1,'Retail Sale Id 3347',0.00,7875.00,736.00,9200.00,1325.00,'2023-02-28 17:12:30'),(3315,'1','307',1,'Retail Sale Id 3349',0.00,2526.30,736.00,2951.36,425.06,'2023-02-28 17:28:42'),(3316,'1','307',1,'Retail Sale Id 3350',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-28 17:32:04'),(3317,'1','307',1,'Retail Sale Id 3351',0.00,1285.20,736.00,1501.44,216.24,'2023-02-28 17:34:35'),(3318,'1','307',1,'Retail Sale Id 3352',0.00,5670.00,736.00,6624.00,954.00,'2023-02-28 17:35:57'),(3319,'1','307',1,'Retail Sale Id 3353',0.00,1285.20,736.00,1501.44,216.24,'2023-02-28 18:06:07'),(3320,'1','307',1,'Retail Sale Id 3354',0.00,36281.70,736.00,42386.24,6104.54,'2023-02-28 18:55:18'),(3321,'1','307',1,'Retail Sale Id 3355',0.00,11579.40,680.00,12498.40,919.00,'2023-02-28 18:57:50'),(3322,'1','307',1,'Return of Retail Sale Id 3319',31500.00,0.00,680.00,-34000.00,-2500.00,'2023-02-28 19:19:17'),(3323,'1','307',1,'Retail Sale Id 3356',0.00,31500.00,680.00,34000.00,2500.00,'2023-02-28 19:20:11'),(3324,'1','307',1,'Retail Sale Id 3357',0.00,2142.00,736.00,2502.40,360.40,'2023-03-01 08:28:07'),(3325,'1','307',1,'Retail Sale Id 3358',0.00,3780.00,736.00,4416.00,636.00,'2023-03-01 08:29:54'),(3326,'1','307',1,'Retail Sale Id 3360',0.00,1260.00,736.00,1472.00,212.00,'2023-03-01 08:32:19'),(3327,'1','307',1,'Retail Sale Id 3361',0.00,1890.00,736.00,2208.00,318.00,'2023-03-01 08:52:52'),(3328,'1','307',1,'Retail Sale Id 3362',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-01 08:59:55'),(3329,'1','307',1,'Retail Sale Id 3363',0.00,94500.00,680.00,102000.00,7500.00,'2023-03-01 09:04:32'),(3330,'1','307',1,'Retail Sale Id 3364',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-01 09:34:15'),(3331,'1','307',1,'Retail Sale Id 3365',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-01 09:38:54'),(3332,'1','307',1,'Retail Sale Id 3366',0.00,41580.00,680.00,44880.00,3300.00,'2023-03-01 10:50:27'),(3333,'1','307',1,'Retail Sale Id 3367',0.00,6300.00,736.00,7360.00,1060.00,'2023-03-01 10:51:37'),(3334,'1','307',1,'Retail Sale Id 3368',0.00,623.70,736.00,728.64,104.94,'2023-03-01 11:13:27'),(3335,'1','307',1,'Retail Sale Id 3369',0.00,1890.00,736.00,2208.00,318.00,'2023-03-01 11:28:09'),(3336,'1','307',1,'Retail Sale Id 3370',0.00,3780.00,736.00,4416.00,636.00,'2023-03-01 11:34:09'),(3337,'1','307',1,'Retail Sale Id 3371',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-01 11:53:10'),(3338,'1','307',1,'Retail Sale Id 3372',0.00,1285.20,736.00,1501.44,216.24,'2023-03-01 12:09:53'),(3339,'1','307',1,'Retail Sale Id 3373',0.00,3150.00,736.00,3680.00,530.00,'2023-03-01 12:27:35'),(3340,'1','307',1,'Retail Sale Id 3374',0.00,3780.00,736.00,4416.00,636.00,'2023-03-01 12:44:16'),(3341,'1','307',1,'Retail Sale Id 3375',0.00,3849.30,736.00,4496.96,647.66,'2023-03-01 13:14:21'),(3342,'1','307',1,'Retail Sale Id 3376',0.00,1890.00,736.00,2208.00,318.00,'2023-03-01 13:21:27'),(3343,'1','307',1,'Retail Sale Id 3377',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-01 13:23:12'),(3344,'1','307',1,'Retail Sale Id 3379',0.00,648.90,736.00,758.08,109.18,'2023-03-01 13:40:21'),(3345,'1','307',1,'Retail Sale Id 3380',0.00,1883.70,736.00,2200.64,316.94,'2023-03-01 13:50:00'),(3346,'1','307',1,'Retail Sale Id 3381',0.00,2570.40,736.00,3002.88,432.48,'2023-03-01 14:13:58'),(3347,'1','307',1,'Retail Sale Id 3382',0.00,1285.20,736.00,1501.44,216.24,'2023-03-01 16:15:30'),(3348,'1','307',1,'Retail Sale Id 3383',0.00,2520.00,736.00,2944.00,424.00,'2023-03-01 16:19:05'),(3349,'1','307',1,'Retail Sale Id 3384',0.00,2526.30,736.00,2951.36,425.06,'2023-03-01 16:21:09'),(3350,'1','307',1,'Retail Sale Id 3385',0.00,7704.90,736.00,9001.28,1296.38,'2023-03-01 16:22:40'),(3351,'1','307',1,'Retail Sale Id 3386',0.00,15750.00,736.00,18400.00,2650.00,'2023-03-01 16:24:08'),(3352,'1','307',1,'Retail Sale Id 3387',0.00,55925.10,680.00,60363.60,4438.50,'2023-03-01 17:57:58'),(3353,'1','307',1,'Retail Sale Id 3388',0.00,7963.20,736.00,9303.04,1339.84,'2023-03-01 18:03:11'),(3354,'1','307',1,'Retail Sale Id 3389',0.00,6300.00,736.00,7360.00,1060.00,'2023-03-01 18:44:42'),(3355,'1','307',1,'Retail Sale Id 3390',0.00,1285.20,736.00,1501.44,216.24,'2023-03-01 18:47:23'),(3356,'1','307',1,'Retail Sale Id 3391',0.00,16461.90,736.00,19231.68,2769.78,'2023-03-01 19:25:21'),(3357,'1','307',1,'Retail Sale Id 3392',0.00,16266.60,736.00,19003.52,2736.92,'2023-03-01 19:27:31'),(3358,'1','307',1,'Retail Sale Id 3393',0.00,16657.20,736.00,19459.84,2802.64,'2023-03-01 19:32:36'),(3359,'1','307',1,'Retail Sale Id 3394',0.00,42840.00,680.00,46240.00,3400.00,'2023-03-02 07:19:09'),(3360,'1','307',1,'Retail Sale Id 3395',0.00,1285.20,736.00,1501.44,216.24,'2023-03-02 07:37:32'),(3361,'1','307',1,'Retail Sale Id 3396',0.00,3780.00,736.00,4416.00,636.00,'2023-03-02 08:35:12'),(3362,'1','307',1,'Retail Sale Id 3397',0.00,1934.10,736.00,2259.52,325.42,'2023-03-02 08:55:06'),(3363,'1','307',1,'Retail Sale Id 3399',0.00,4410.00,736.00,5152.00,742.00,'2023-03-02 08:58:07'),(3364,'1','307',1,'Retail Sale Id 3400',0.00,3849.30,736.00,4496.96,647.66,'2023-03-02 09:12:25'),(3365,'1','307',1,'Retail Sale Id 3401',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-02 09:15:59'),(3366,'1','307',1,'Retail Sale Id 3402',0.00,4277.70,736.00,4997.44,719.74,'2023-03-02 09:19:45'),(3367,'1','307',1,'Retail Sale Id 3403',0.00,1260.00,736.00,1472.00,212.00,'2023-03-02 10:10:53'),(3368,'1','307',1,'Retail Sale Id 3404',0.00,1260.00,736.00,1472.00,212.00,'2023-03-02 10:12:22'),(3369,'1','307',1,'Retail Sale Id 3405',0.00,630.00,736.00,736.00,106.00,'2023-03-02 10:13:22'),(3370,'1','307',1,'Retail Sale Id 3406',0.00,1883.70,736.00,2200.64,316.94,'2023-03-02 10:14:38'),(3371,'1','307',1,'Retail Sale Id 3407',0.00,1285.20,736.00,1501.44,216.24,'2023-03-02 10:15:25'),(3372,'1','307',1,'Retail Sale Id 3408',0.00,1713.60,736.00,2001.92,288.32,'2023-03-02 10:16:20'),(3373,'1','307',1,'Retail Sale Id 3409',0.00,3780.00,736.00,4416.00,636.00,'2023-03-02 10:19:56'),(3374,'1','307',1,'Retail Sale Id 3410',0.00,642.60,736.00,750.72,108.12,'2023-03-02 10:28:44'),(3375,'1','307',1,'Retail Sale Id 3411',0.00,1940.40,736.00,2266.88,326.48,'2023-03-02 10:31:14'),(3376,'1','307',1,'Retail Sale Id 3412',0.00,1890.00,736.00,2208.00,318.00,'2023-03-02 10:44:24'),(3377,'1','307',1,'Retail Sale Id 3413',0.00,1883.70,736.00,2200.64,316.94,'2023-03-02 10:59:26'),(3378,'1','307',1,'Retail Sale Id 3415',0.00,10647.00,680.00,11492.00,845.00,'2023-03-02 11:03:26'),(3379,'1','307',1,'Retail Sale Id 3416',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-02 11:24:32'),(3380,'1','307',1,'Retail Sale Id 3417',0.00,1260.00,736.00,1472.00,212.00,'2023-03-02 11:29:06'),(3381,'1','307',1,'Retail Sale Id 3418',0.00,3780.00,736.00,4416.00,636.00,'2023-03-02 11:33:32'),(3382,'1','307',1,'Retail Sale Id 3419',0.00,3849.30,736.00,4496.96,647.66,'2023-03-02 11:41:08'),(3383,'1','307',1,'Retail Sale Id 3420',0.00,642.60,736.00,750.72,108.12,'2023-03-02 11:48:14'),(3384,'1','307',1,'Retail Sale Id 3421',0.00,2570.40,736.00,3002.88,432.48,'2023-03-02 11:56:12'),(3385,'1','307',1,'Retail Sale Id 3422',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-02 12:01:48'),(3386,'1','307',1,'Retail Sale Id 3423',0.00,3780.00,736.00,4416.00,636.00,'2023-03-02 12:07:36'),(3387,'1','307',1,'Retail Sale Id 3424',0.00,856.80,736.00,1000.96,144.16,'2023-03-02 12:13:18'),(3388,'1','307',1,'Retail Sale Id 3425',0.00,1285.20,736.00,1501.44,216.24,'2023-03-02 12:23:51'),(3389,'1','307',1,'Retail Sale Id 3426',0.00,8857.80,736.00,10348.16,1490.36,'2023-03-02 12:29:47'),(3390,'1','307',1,'Retail Sale Id 3427',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-02 13:32:02'),(3391,'1','307',1,'Retail Sale Id 3428',0.00,2570.40,736.00,3002.88,432.48,'2023-03-02 13:34:48'),(3392,'1','307',1,'Retail Sale Id 3429',0.00,11295.90,736.00,13196.48,1900.58,'2023-03-02 15:01:08'),(3393,'1','307',1,'Retail Sale Id 3430',0.00,3420.90,736.00,3996.48,575.58,'2023-03-02 15:13:00'),(3394,'1','307',1,'Retail Sale Id 3431',0.00,1890.00,736.00,2208.00,318.00,'2023-03-02 15:14:38'),(3395,'1','307',1,'Retail Sale Id 3432',0.00,1890.00,736.00,2208.00,318.00,'2023-03-02 15:19:24'),(3396,'1','307',1,'Retail Sale Id 3433',0.00,686.70,736.00,802.24,115.54,'2023-03-02 18:34:15'),(3397,'1','307',1,'Retail Sale Id 3434',0.00,1883.70,736.00,2200.64,316.94,'2023-03-02 18:35:38'),(3398,'1','307',1,'Retail Sale Id 3435',0.00,1285.20,736.00,1501.44,216.24,'2023-03-02 18:37:21'),(3399,'1','307',1,'Retail Sale Id 3436',0.00,1890.00,736.00,2208.00,318.00,'2023-03-02 18:38:39'),(3400,'1','307',1,'Retail Sale Id 3437',0.00,1285.20,736.00,1501.44,216.24,'2023-03-02 18:41:22'),(3401,'1','307',1,'Retail Sale Id 3438',0.00,1713.60,736.00,2001.92,288.32,'2023-03-02 18:43:11'),(3402,'1','307',1,'Retail Sale Id 3439',0.00,1625.40,736.00,1898.88,273.48,'2023-03-02 18:49:55'),(3403,'1','307',1,'Retail Sale Id 3440',0.00,428.40,736.00,500.48,72.08,'2023-03-02 18:56:27'),(3404,'1','307',1,'Retail Sale Id 3441',0.00,3168.90,736.00,3702.08,533.18,'2023-03-02 18:57:36'),(3405,'1','307',1,'Retail Sale Id 3442',0.00,22050.00,680.00,23800.00,1750.00,'2023-03-02 19:06:58'),(3406,'1','307',1,'Retail Sale Id 3443',0.00,68418.00,680.00,73848.00,5430.00,'2023-03-02 19:31:48'),(3407,'1','307',1,'Retail Sale Id 3444',0.00,19555.20,736.00,22845.44,3290.24,'2023-03-02 19:34:43'),(3408,'1','307',1,'Retail Sale Id 3445',0.00,3150.00,736.00,3680.00,530.00,'2023-03-03 07:39:59'),(3409,'1','307',1,'Retail Sale Id 3446',0.00,157500.00,680.00,170000.00,12500.00,'2023-03-03 07:42:17'),(3410,'1','307',1,'Retail Sale Id 3447',0.00,1890.00,736.00,2208.00,318.00,'2023-03-03 07:45:30'),(3411,'1','307',1,'Retail Sale Id 3448',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-03 08:05:22'),(3412,'1','307',1,'Retail Sale Id 3449',0.00,3780.00,736.00,4416.00,636.00,'2023-03-03 08:08:59'),(3413,'1','307',1,'Retail Sale Id 3451',0.00,3849.30,736.00,4496.96,647.66,'2023-03-03 08:22:51'),(3414,'1','307',1,'Retail Sale Id 3452',0.00,1285.20,736.00,1501.44,216.24,'2023-03-03 08:25:45'),(3415,'1','307',1,'Retail Sale Id 3453',0.00,4277.70,736.00,4997.44,719.74,'2023-03-03 08:27:30'),(3416,'1','307',1,'Retail Sale Id 3454',0.00,3780.00,736.00,4416.00,636.00,'2023-03-03 08:29:42'),(3417,'1','307',1,'Retail Sale Id 3455',0.00,428.40,736.00,500.48,72.08,'2023-03-03 08:44:43'),(3418,'1','307',1,'Retail Sale Id 3456',0.00,63000.00,680.00,68000.00,5000.00,'2023-03-03 08:47:27'),(3419,'1','307',1,'Retail Sale Id 3457',0.00,2570.40,736.00,3002.88,432.48,'2023-03-03 08:50:17'),(3420,'1','307',1,'Retail Sale Id 3458',0.00,31500.00,680.00,34000.00,2500.00,'2023-03-03 09:00:30'),(3421,'1','307',1,'Retail Sale Id 3459',0.00,1890.00,736.00,2208.00,318.00,'2023-03-03 09:04:42'),(3422,'1','307',1,'Retail Sale Id 3460',0.00,1285.20,736.00,1501.44,216.24,'2023-03-03 09:13:40'),(3423,'1','307',1,'Retail Sale Id 3462',0.00,3168.90,736.00,3702.08,533.18,'2023-03-03 09:18:10'),(3424,'1','307',1,'Retail Sale Id 3463',0.00,2570.40,736.00,3002.88,432.48,'2023-03-03 09:19:02'),(3425,'1','307',1,'Retail Sale Id 3464',0.00,1890.00,736.00,2208.00,318.00,'2023-03-03 09:31:18'),(3426,'1','307',1,'Retail Sale Id 3465',0.00,1890.00,736.00,2208.00,318.00,'2023-03-03 09:37:33'),(3427,'1','307',1,'Retail Sale Id 3466',0.00,7560.00,736.00,8832.00,1272.00,'2023-03-03 09:43:02'),(3428,'1','307',1,'Retail Sale Id 3467',0.00,2520.00,736.00,2944.00,424.00,'2023-03-03 09:46:02'),(3429,'1','307',1,'Retail Sale Id 3468',0.00,3849.30,736.00,4496.96,647.66,'2023-03-03 10:05:32'),(3430,'1','307',1,'Retail Sale Id 3470',0.00,1890.00,736.00,2208.00,318.00,'2023-03-03 10:18:04'),(3431,'1','307',1,'Retail Sale Id 3471',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-03 10:27:14'),(3432,'1','307',1,'Retail Sale Id 3472',0.00,1883.70,736.00,2200.64,316.94,'2023-03-03 10:46:58'),(3433,'1','307',1,'Retail Sale Id 3473',0.00,6300.00,736.00,7360.00,1060.00,'2023-03-03 10:52:29'),(3434,'1','307',1,'Retail Sale Id 3474',0.00,3780.00,736.00,4416.00,636.00,'2023-03-03 11:19:00'),(3435,'1','307',1,'Retail Sale Id 3475',0.00,686.70,736.00,802.24,115.54,'2023-03-03 11:35:15'),(3436,'1','307',1,'Retail Sale Id 3476',0.00,2520.00,736.00,2944.00,424.00,'2023-03-03 12:00:41'),(3437,'1','307',1,'Retail Sale Id 3477',0.00,1713.60,736.00,2001.92,288.32,'2023-03-03 12:11:51'),(3438,'1','307',1,'Retail Sale Id 3478',0.00,1285.20,736.00,1501.44,216.24,'2023-03-03 12:19:29'),(3439,'1','307',1,'Retail Sale Id 3479',0.00,856.80,736.00,1000.96,144.16,'2023-03-03 12:41:41'),(3440,'1','307',1,'Retail Sale Id 3480',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-03 13:01:46'),(3441,'1','307',1,'Retail Sale Id 3481',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-03 13:09:40'),(3442,'1','307',1,'Retail Sale Id 3482',0.00,1890.00,736.00,2208.00,318.00,'2023-03-03 13:25:06'),(3443,'1','307',1,'Retail Sale Id 3483',0.00,3420.90,736.00,3996.48,575.58,'2023-03-03 13:58:17'),(3444,'1','307',1,'Retail Sale Id 3484',0.00,3786.30,736.00,4423.36,637.06,'2023-03-03 13:59:17'),(3445,'1','307',1,'Retail Sale Id 3485',0.00,686.70,736.00,802.24,115.54,'2023-03-03 14:54:18'),(3446,'1','307',1,'Retail Sale Id 3486',0.00,1927.80,736.00,2252.16,324.36,'2023-03-03 14:56:03'),(3447,'1','307',1,'Retail Sale Id 3487',0.00,63000.00,680.00,68000.00,5000.00,'2023-03-03 15:09:12'),(3448,'1','307',1,'Retail Sale Id 3488',0.00,6948.90,736.00,8118.08,1169.18,'2023-03-03 15:14:27'),(3449,'1','307',1,'Retail Sale Id 3489',0.00,3811.50,736.00,4452.80,641.30,'2023-03-03 15:23:38'),(3450,'1','307',1,'Retail Sale Id 3490',0.00,21791.70,736.00,25458.24,3666.54,'2023-03-03 18:23:57'),(3451,'1','307',1,'Retail Sale Id 3491',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-03 18:44:16'),(3452,'1','307',1,'Retail Sale Id 3492',0.00,30290.40,736.00,35386.88,5096.48,'2023-03-03 19:31:30'),(3453,'1','307',1,'Retail Sale Id 3493',0.00,1890.00,736.00,2208.00,318.00,'2023-03-04 07:36:10'),(3454,'1','307',1,'Retail Sale Id 3494',0.00,2570.40,736.00,3002.88,432.48,'2023-03-04 07:54:49'),(3455,'1','307',1,'Retail Sale Id 3495',0.00,1285.20,736.00,1501.44,216.24,'2023-03-04 08:22:00'),(3456,'1','307',1,'Retail Sale Id 3496',0.00,6300.00,736.00,7360.00,1060.00,'2023-03-04 08:34:57'),(3457,'1','307',1,'Retail Sale Id 3497',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-04 08:37:21'),(3458,'1','307',1,'Retail Sale Id 3498',0.00,31500.00,680.00,34000.00,2500.00,'2023-03-04 08:38:28'),(3459,'1','307',1,'Retail Sale Id 3499',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-04 08:41:39'),(3460,'1','307',1,'Retail Sale Id 3500',0.00,3150.00,736.00,3680.00,530.00,'2023-03-04 08:45:46'),(3461,'1','307',1,'Retail Sale Id 3501',0.00,1890.00,736.00,2208.00,318.00,'2023-03-04 08:47:04'),(3462,'1','307',1,'Retail Sale Id 3502',0.00,3767.40,736.00,4401.28,633.88,'2023-03-04 09:06:38'),(3463,'1','307',1,'Retail Sale Id 3503',0.00,31500.00,680.00,34000.00,2500.00,'2023-03-04 09:09:13'),(3464,'1','307',1,'Retail Sale Id 3504',0.00,3780.00,736.00,4416.00,636.00,'2023-03-04 09:21:10'),(3465,'1','307',1,'Retail Sale Id 3505',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-04 09:22:06'),(3466,'1','307',1,'Retail Sale Id 3506',0.00,1890.00,736.00,2208.00,318.00,'2023-03-04 09:23:23'),(3467,'1','307',1,'Retail Sale Id 3507',0.00,3150.00,736.00,3680.00,530.00,'2023-03-04 09:28:13'),(3468,'1','307',1,'Retail Sale Id 3508',0.00,7560.00,736.00,8832.00,1272.00,'2023-03-04 09:36:01'),(3469,'1','307',1,'Retail Sale Id 3509',0.00,1890.00,736.00,2208.00,318.00,'2023-03-04 09:36:57'),(3470,'1','307',1,'Retail Sale Id 3510',0.00,1285.20,736.00,1501.44,216.24,'2023-03-04 09:38:13'),(3471,'1','307',1,'Retail Sale Id 3511',0.00,1285.20,736.00,1501.44,216.24,'2023-03-04 09:39:05'),(3472,'1','307',1,'Retail Sale Id 3512',0.00,3150.00,736.00,3680.00,530.00,'2023-03-04 09:43:38'),(3473,'1','307',1,'Retail Sale Id 3513',0.00,3780.00,736.00,4416.00,636.00,'2023-03-04 09:46:28'),(3474,'1','307',1,'Retail Sale Id 3514',0.00,1890.00,736.00,2208.00,318.00,'2023-03-04 09:54:57'),(3475,'1','307',1,'Retail Sale Id 3515',0.00,3150.00,736.00,3680.00,530.00,'2023-03-04 10:11:41'),(3476,'1','307',1,'Retail Sale Id 3516',0.00,3849.30,736.00,4496.96,647.66,'2023-03-04 10:23:24'),(3477,'1','307',1,'Retail Sale Id 3517',0.00,1890.00,736.00,2208.00,318.00,'2023-03-04 10:26:44'),(3478,'1','307',1,'Retail Sale Id 3518',0.00,1890.00,736.00,2208.00,318.00,'2023-03-04 10:40:19'),(3479,'1','307',1,'Retail Sale Id 3519',0.00,1890.00,736.00,2208.00,318.00,'2023-03-04 10:52:19'),(3480,'1','307',1,'Retail Sale Id 3520',0.00,1890.00,736.00,2208.00,318.00,'2023-03-04 10:53:00'),(3481,'1','307',1,'Retail Sale Id 3521',0.00,1285.20,736.00,1501.44,216.24,'2023-03-04 10:53:51'),(3482,'1','307',1,'Retail Sale Id 3522',0.00,3780.00,736.00,4416.00,636.00,'2023-03-04 10:56:43'),(3483,'1','307',1,'Retail Sale Id 3523',0.00,19920.60,680.00,21501.60,1581.00,'2023-03-04 11:00:15'),(3484,'1','307',1,'Retail Sale Id 3524',0.00,3150.00,736.00,3680.00,530.00,'2023-03-04 11:02:26'),(3485,'1','307',1,'Retail Sale Id 3525',0.00,1285.20,736.00,1501.44,216.24,'2023-03-04 11:09:51'),(3486,'1','307',1,'Retail Sale Id 3526',0.00,856.80,736.00,1000.96,144.16,'2023-03-04 11:18:49'),(3487,'1','307',1,'Retail Sale Id 3528',0.00,1927.80,736.00,2252.16,324.36,'2023-03-04 11:31:59'),(3488,'1','307',1,'Retail Sale Id 3530',0.00,1890.00,736.00,2208.00,318.00,'2023-03-04 11:39:19'),(3489,'1','307',1,'Retail Sale Id 3532',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-04 11:50:21'),(3490,'1','307',1,'Retail Sale Id 3533',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-04 11:51:22'),(3491,'1','307',1,'Retail Sale Id 3534',0.00,3150.00,736.00,3680.00,530.00,'2023-03-04 11:52:52'),(3492,'1','307',1,'Retail Sale Id 3535',0.00,428.40,736.00,500.48,72.08,'2023-03-04 11:53:42'),(3493,'1','307',1,'Retail Sale Id 3536',0.00,1890.00,736.00,2208.00,318.00,'2023-03-04 12:14:29'),(3494,'1','307',1,'Retail Sale Id 3537',0.00,2520.00,736.00,2944.00,424.00,'2023-03-04 12:32:18'),(3495,'1','307',1,'Retail Sale Id 3538',0.00,2520.00,736.00,2944.00,424.00,'2023-03-04 12:34:27'),(3496,'1','307',1,'Retail Sale Id 3539',0.00,1285.20,736.00,1501.44,216.24,'2023-03-04 12:39:26'),(3497,'1','307',1,'Retail Sale Id 3540',0.00,3780.00,736.00,4416.00,636.00,'2023-03-04 13:33:19'),(3498,'1','307',1,'Retail Sale Id 3541',0.00,3786.30,736.00,4423.36,637.06,'2023-03-04 14:17:47'),(3499,'1','307',1,'Retail Sale Id 3542',0.00,1890.00,736.00,2208.00,318.00,'2023-03-04 14:18:57'),(3500,'1','307',1,'Retail Sale Id 3543',0.00,3786.30,736.00,4423.36,637.06,'2023-03-04 14:53:21'),(3501,'1','307',1,'Retail Sale Id 3544',0.00,2526.30,736.00,2951.36,425.06,'2023-03-04 15:03:53'),(3502,'1','307',1,'Retail Sale Id 3545',0.00,35670.60,680.00,38501.60,2831.00,'2023-03-04 15:06:35'),(3503,'1','307',1,'Retail Sale Id 3546',0.00,1285.20,736.00,1501.44,216.24,'2023-03-04 15:08:24'),(3504,'1','307',1,'Retail Sale Id 3547',0.00,14294.70,736.00,16699.84,2405.14,'2023-03-04 15:12:41'),(3505,'1','307',1,'Retail Sale Id 3548',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-04 15:19:55'),(3506,'1','307',1,'Retail Sale Id 3549',0.00,1890.00,736.00,2208.00,318.00,'2023-03-04 15:33:25'),(3507,'1','307',1,'Retail Sale Id 3550',0.00,1890.00,736.00,2208.00,318.00,'2023-03-04 16:20:41'),(3508,'1','307',1,'Retail Sale Id 3551',0.00,11976.30,736.00,13991.36,2015.06,'2023-03-04 16:22:07'),(3509,'1','307',1,'Retail Sale Id 3552',0.00,14811.30,736.00,17303.36,2492.06,'2023-03-04 17:19:09'),(3510,'1','307',1,'Retail Sale Id 3553',0.00,157500.00,680.00,170000.00,12500.00,'2023-03-04 17:43:21'),(3511,'1','307',1,'Retail Sale Id 3554',0.00,1890.00,736.00,2208.00,318.00,'2023-03-04 17:58:01'),(3512,'1','307',1,'Retail Sale Id 3555',0.00,63000.00,680.00,68000.00,5000.00,'2023-03-04 18:37:09'),(3513,'1','307',1,'Retail Sale Id 3556',0.00,22780.80,736.00,26613.76,3832.96,'2023-03-04 18:44:25'),(3514,'1','307',1,'Retail Sale Id 3557',0.00,856.80,736.00,1000.96,144.16,'2023-03-05 07:45:50'),(3515,'1','307',1,'Retail Sale Id 3558',0.00,3786.30,736.00,4423.36,637.06,'2023-03-05 08:06:15'),(3516,'1','307',1,'Retail Sale Id 3559',0.00,6300.00,736.00,7360.00,1060.00,'2023-03-05 08:07:55'),(3517,'1','307',1,'Retail Sale Id 3560',0.00,1285.20,736.00,1501.44,216.24,'2023-03-05 08:09:39'),(3518,'1','307',1,'Retail Sale Id 3561',0.00,1713.60,736.00,2001.92,288.32,'2023-03-05 08:18:21'),(3519,'1','307',1,'Retail Sale Id 3562',0.00,3780.00,736.00,4416.00,636.00,'2023-03-05 08:23:36'),(3520,'1','307',1,'Retail Sale Id 3563',0.00,3780.00,736.00,4416.00,636.00,'2023-03-05 08:38:50'),(3521,'1','307',1,'Retail Sale Id 3564',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-05 08:41:49'),(3522,'1','307',1,'Retail Sale Id 3565',0.00,2570.40,736.00,3002.88,432.48,'2023-03-05 08:55:30'),(3523,'1','307',1,'Retail Sale Id 3566',0.00,1285.20,736.00,1501.44,216.24,'2023-03-05 09:03:56'),(3524,'1','307',1,'Retail Sale Id 3567',0.00,2570.40,736.00,3002.88,432.48,'2023-03-05 09:23:18'),(3525,'1','307',1,'Retail Sale Id 3568',0.00,3420.90,736.00,3996.48,575.58,'2023-03-05 09:25:35'),(3526,'1','307',1,'Retail Sale Id 3569',0.00,63000.00,680.00,68000.00,5000.00,'2023-03-05 09:27:50'),(3527,'1','307',1,'Retail Sale Id 3570',0.00,2520.00,736.00,2944.00,424.00,'2023-03-05 09:29:20'),(3528,'1','307',1,'Retail Sale Id 3571',0.00,3150.00,736.00,3680.00,530.00,'2023-03-05 09:30:55'),(3529,'1','307',1,'Retail Sale Id 3572',0.00,2570.40,736.00,3002.88,432.48,'2023-03-05 09:47:37'),(3530,'1','307',1,'Retail Sale Id 3573',0.00,642.60,736.00,750.72,108.12,'2023-03-05 09:58:12'),(3531,'1','307',1,'Retail Sale Id 3574',0.00,3780.00,736.00,4416.00,636.00,'2023-03-05 10:16:37'),(3532,'1','307',1,'Retail Sale Id 3575',0.00,3150.00,736.00,3680.00,530.00,'2023-03-05 10:18:00'),(3533,'1','307',1,'Retail Sale Id 3576',0.00,2142.00,736.00,2502.40,360.40,'2023-03-05 10:21:40'),(3534,'1','307',1,'Retail Sale Id 3577',0.00,1260.00,736.00,1472.00,212.00,'2023-03-05 10:29:57'),(3535,'1','307',1,'Retail Sale Id 3578',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-05 10:57:30'),(3536,'1','307',1,'Retail Sale Id 3579',0.00,1890.00,736.00,2208.00,318.00,'2023-03-05 10:58:58'),(3537,'1','307',1,'Retail Sale Id 3580',0.00,98280.00,680.00,106080.00,7800.00,'2023-03-05 11:03:17'),(3538,'1','307',1,'Retail Sale Id 3581',0.00,3780.00,736.00,4416.00,636.00,'2023-03-05 11:05:45'),(3539,'1','307',1,'Retail Sale Id 3582',0.00,3150.00,736.00,3680.00,530.00,'2023-03-05 11:10:08'),(3540,'1','307',1,'Retail Sale Id 3583',0.00,1890.00,736.00,2208.00,318.00,'2023-03-05 11:13:30'),(3541,'1','307',1,'Retail Sale Id 3584',0.00,3849.30,736.00,4496.96,647.66,'2023-03-05 11:18:12'),(3542,'1','307',1,'Retail Sale Id 3585',0.00,3780.00,736.00,4416.00,636.00,'2023-03-05 11:24:16'),(3543,'1','307',1,'Retail Sale Id 3586',0.00,2520.00,736.00,2944.00,424.00,'2023-03-05 11:25:30'),(3544,'1','307',1,'Retail Sale Id 3587',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-05 11:26:48'),(3545,'1','307',1,'Retail Sale Id 3588',0.00,1713.60,736.00,2001.92,288.32,'2023-03-05 11:28:16'),(3546,'1','307',1,'Retail Sale Id 3589',0.00,6300.00,736.00,7360.00,1060.00,'2023-03-05 11:30:47'),(3547,'1','307',1,'Retail Sale Id 3590',0.00,3150.00,736.00,3680.00,530.00,'2023-03-05 11:34:26'),(3548,'1','307',1,'Retail Sale Id 3591',0.00,3849.30,736.00,4496.96,647.66,'2023-03-05 11:42:14'),(3549,'1','307',1,'Retail Sale Id 3592',0.00,1890.00,736.00,2208.00,318.00,'2023-03-05 11:44:36'),(3550,'1','307',1,'Retail Sale Id 3593',0.00,1890.00,736.00,2208.00,318.00,'2023-03-05 11:52:52'),(3551,'1','307',1,'Retail Sale Id 3594',0.00,2520.00,736.00,2944.00,424.00,'2023-03-05 12:07:05'),(3552,'1','307',1,'Retail Sale Id 3595',0.00,1927.80,736.00,2252.16,324.36,'2023-03-05 12:15:57'),(3553,'1','307',1,'Retail Sale Id 3596',0.00,1890.00,736.00,2208.00,318.00,'2023-03-05 12:27:30'),(3554,'1','307',1,'Retail Sale Id 3597',0.00,1890.00,736.00,2208.00,318.00,'2023-03-05 12:29:50'),(3555,'1','307',1,'Retail Sale Id 3598',0.00,1890.00,736.00,2208.00,318.00,'2023-03-05 12:32:48'),(3556,'1','307',1,'Retail Sale Id 3599',0.00,3780.00,736.00,4416.00,636.00,'2023-03-05 12:34:49'),(3557,'1','307',1,'Retail Sale Id 3600',0.00,3780.00,736.00,4416.00,636.00,'2023-03-05 12:50:25'),(3558,'1','307',1,'Retail Sale Id 3601',0.00,1713.60,736.00,2001.92,288.32,'2023-03-05 13:11:49'),(3559,'1','307',1,'Retail Sale Id 3602',0.00,3150.00,736.00,3680.00,530.00,'2023-03-05 13:41:42'),(3560,'1','307',1,'Retail Sale Id 3603',0.00,1890.00,736.00,2208.00,318.00,'2023-03-05 13:53:06'),(3561,'1','307',1,'Retail Sale Id 3604',0.00,6325.20,736.00,7389.44,1064.24,'2023-03-05 14:29:45'),(3562,'1','307',1,'Retail Sale Id 3605',0.00,642.60,736.00,750.72,108.12,'2023-03-05 14:33:11'),(3563,'1','307',1,'Retail Sale Id 3606',0.00,21659.40,736.00,25303.68,3644.28,'2023-03-05 15:01:08'),(3564,'1','307',1,'Retail Sale Id 3607',0.00,8215.20,736.00,9597.44,1382.24,'2023-03-05 15:10:47'),(3565,'1','307',1,'Retail Sale Id 3608',0.00,2526.30,736.00,2951.36,425.06,'2023-03-05 15:13:36'),(3566,'1','307',1,'Retail Sale Id 3609',0.00,3786.30,736.00,4423.36,637.06,'2023-03-05 15:49:12'),(3567,'1','307',1,'Retail Sale Id 3611',0.00,17621.10,736.00,20585.92,2964.82,'2023-03-05 16:30:14'),(3568,'1','307',1,'Retail Sale Id 3612',0.00,31500.00,680.00,34000.00,2500.00,'2023-03-05 16:31:33'),(3569,'1','307',1,'Retail Sale Id 3613',0.00,1713.60,736.00,2001.92,288.32,'2023-03-05 16:38:41'),(3570,'1','307',1,'Retail Sale Id 3614',0.00,3420.90,736.00,3996.48,575.58,'2023-03-05 16:40:39'),(3571,'1','307',1,'Retail Sale Id 3615',0.00,1890.00,736.00,2208.00,318.00,'2023-03-05 16:45:57'),(3572,'1','307',1,'Retail Sale Id 3616',0.00,5758.20,736.00,6727.04,968.84,'2023-03-05 17:02:49'),(3573,'1','307',1,'Retail Sale Id 3617',0.00,4454.10,736.00,5203.52,749.42,'2023-03-05 17:11:42'),(3574,'1','307',1,'Retail Sale Id 3618',0.00,3786.30,736.00,4423.36,637.06,'2023-03-05 17:13:41'),(3575,'1','307',1,'Retail Sale Id 3619',0.00,856.80,736.00,1000.96,144.16,'2023-03-05 17:34:36'),(3576,'1','307',1,'Retail Sale Id 3620',0.00,1713.60,736.00,2001.92,288.32,'2023-03-05 17:37:30'),(3577,'1','307',1,'Retail Sale Id 3621',0.00,220500.00,680.00,238000.00,17500.00,'2023-03-05 17:39:07'),(3578,'1','307',1,'Retail Sale Id 3622',0.00,1713.60,736.00,2001.92,288.32,'2023-03-05 18:18:37'),(3579,'1','307',1,'Retail Sale Id 3623',0.00,3786.30,736.00,4423.36,637.06,'2023-03-05 18:22:10'),(3580,'1','307',1,'Retail Sale Id 3624',0.00,1713.60,736.00,2001.92,288.32,'2023-03-05 18:24:46'),(3581,'1','307',1,'Retail Sale Id 3625',0.00,2526.30,736.00,2951.36,425.06,'2023-03-05 18:26:16'),(3582,'1','307',1,'Retail Sale Id 3626',0.00,40685.40,736.00,47530.88,6845.48,'2023-03-05 18:53:13'),(3583,'1','307',1,'Retail Sale Id 3627',0.00,1890.00,736.00,2208.00,318.00,'2023-03-06 07:32:00'),(3584,'1','307',1,'Retail Sale Id 3628',0.00,1260.00,736.00,1472.00,212.00,'2023-03-06 07:33:30'),(3585,'1','307',1,'Retail Sale Id 3629',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-06 07:34:58'),(3586,'1','307',1,'Retail Sale Id 3630',0.00,1890.00,736.00,2208.00,318.00,'2023-03-06 07:36:17'),(3587,'1','307',1,'Retail Sale Id 3631',0.00,1285.20,736.00,1501.44,216.24,'2023-03-06 07:46:33'),(3588,'1','307',1,'Retail Sale Id 3632',0.00,2142.00,736.00,2502.40,360.40,'2023-03-06 08:15:13'),(3589,'1','307',1,'Retail Sale Id 3633',0.00,3150.00,736.00,3680.00,530.00,'2023-03-06 08:21:12'),(3590,'1','307',1,'Retail Sale Id 3634',0.00,1285.20,736.00,1501.44,216.24,'2023-03-06 08:24:09'),(3591,'1','307',1,'Retail Sale Id 3635',0.00,2520.00,736.00,2944.00,424.00,'2023-03-06 08:36:24'),(3592,'1','307',1,'Retail Sale Id 3636',0.00,6350.40,736.00,7418.88,1068.48,'2023-03-06 08:38:00'),(3593,'1','307',1,'Retail Sale Id 3637',0.00,3780.00,736.00,4416.00,636.00,'2023-03-06 08:44:15'),(3594,'1','307',1,'Retail Sale Id 3638',0.00,1883.70,736.00,2200.64,316.94,'2023-03-06 08:54:33'),(3595,'1','307',1,'Retail Sale Id 3639',0.00,2520.00,736.00,2944.00,424.00,'2023-03-06 09:09:32'),(3596,'1','307',1,'Retail Sale Id 3640',0.00,1890.00,736.00,2208.00,318.00,'2023-03-06 09:11:09'),(3597,'1','307',1,'Retail Sale Id 3641',0.00,31500.00,680.00,34000.00,2500.00,'2023-03-06 09:24:05'),(3598,'1','307',1,'Retail Sale Id 3642',0.00,2520.00,736.00,2944.00,424.00,'2023-03-06 09:52:40'),(3599,'1','307',1,'Retail Sale Id 3643',0.00,1713.60,736.00,2001.92,288.32,'2023-03-06 10:10:00'),(3600,'1','307',1,'Retail Sale Id 3644',0.00,3150.00,736.00,3680.00,530.00,'2023-03-06 10:48:00'),(3601,'1','307',1,'Retail Sale Id 3645',0.00,856.80,736.00,1000.96,144.16,'2023-03-06 10:48:48'),(3602,'1','307',1,'Retail Sale Id 3646',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-06 11:09:30'),(3603,'1','307',1,'Retail Sale Id 3647',0.00,2570.40,736.00,3002.88,432.48,'2023-03-06 11:47:10'),(3604,'1','307',1,'Retail Sale Id 3648',0.00,2520.00,736.00,2944.00,424.00,'2023-03-06 12:59:35'),(3605,'1','307',1,'Retail Sale Id 3649',0.00,10451.70,736.00,12210.24,1758.54,'2023-03-06 13:30:49'),(3606,'1','307',1,'Retail Sale Id 3650',0.00,59535.00,680.00,64260.00,4725.00,'2023-03-06 15:00:09'),(3607,'1','307',1,'Retail Sale Id 3651',0.00,1285.20,736.00,1501.44,216.24,'2023-03-06 16:15:49'),(3608,'1','307',1,'Retail Sale Id 3652',0.00,5065.20,736.00,5917.44,852.24,'2023-03-06 16:17:06'),(3609,'1','307',1,'Retail Sale Id 3653',0.00,6300.00,736.00,7360.00,1060.00,'2023-03-06 16:30:34'),(3610,'1','307',1,'Retail Sale Id 3654',0.00,3150.00,736.00,3680.00,530.00,'2023-03-06 16:40:41'),(3611,'1','307',1,'Retail Sale Id 3655',0.00,3786.30,736.00,4423.36,637.06,'2023-03-06 16:50:25'),(3612,'1','307',1,'Retail Sale Id 3656',0.00,19813.50,736.00,23147.20,3333.70,'2023-03-06 17:45:34'),(3613,'1','307',1,'Retail Sale Id 3657',0.00,1890.00,736.00,2208.00,318.00,'2023-03-06 17:48:06'),(3614,'1','307',1,'Retail Sale Id 3658',0.00,8857.80,736.00,10348.16,1490.36,'2023-03-06 18:06:53'),(3615,'1','307',1,'Retail Sale Id 3659',0.00,1367.10,736.00,1597.12,230.02,'2023-03-06 18:12:38'),(3616,'1','307',1,'Retail Sale Id 3660',0.00,6300.00,736.00,7360.00,1060.00,'2023-03-06 18:17:07'),(3617,'1','307',1,'Retail Sale Id 3661',0.00,1890.00,736.00,2208.00,318.00,'2023-03-06 18:19:05'),(3618,'1','307',1,'Retail Sale Id 3662',0.00,1285.20,736.00,1501.44,216.24,'2023-03-06 18:20:59'),(3619,'1','307',1,'Retail Sale Id 3663',0.00,5065.20,736.00,5917.44,852.24,'2023-03-06 18:28:59'),(3620,'1','307',1,'Retail Sale Id 3664',0.00,1890.00,736.00,2208.00,318.00,'2023-03-06 18:33:59'),(3621,'1','307',1,'Retail Sale Id 3665',0.00,17992.80,736.00,21020.16,3027.36,'2023-03-06 18:43:23'),(3622,'1','307',1,'Retail Sale Id 3666',0.00,1367.10,736.00,1597.12,230.02,'2023-03-07 07:36:56'),(3623,'1','307',1,'Retail Sale Id 3667',0.00,2520.00,736.00,2944.00,424.00,'2023-03-07 07:39:31'),(3624,'1','307',1,'Retail Sale Id 3668',0.00,31500.00,680.00,34000.00,2500.00,'2023-03-07 07:53:40'),(3625,'1','307',1,'Retail Sale Id 3669',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-07 08:18:45'),(3626,'1','307',1,'Retail Sale Id 3670',0.00,2520.00,736.00,2944.00,424.00,'2023-03-07 08:25:19'),(3627,'1','307',1,'Retail Sale Id 3671',0.00,630.00,736.00,736.00,106.00,'2023-03-07 08:32:50'),(3628,'1','307',1,'Retail Sale Id 3672',0.00,1890.00,736.00,2208.00,318.00,'2023-03-07 08:49:34'),(3629,'1','307',1,'Retail Sale Id 3673',0.00,1260.00,736.00,1472.00,212.00,'2023-03-07 09:02:12'),(3630,'1','307',1,'Retail Sale Id 3674',0.00,165375.00,680.00,178500.00,13125.00,'2023-03-07 09:30:22'),(3631,'1','307',1,'Retail Sale Id 3675',0.00,3150.00,736.00,3680.00,530.00,'2023-03-07 10:04:19'),(3632,'1','307',1,'Retail Sale Id 3676',0.00,3420.90,736.00,3996.48,575.58,'2023-03-07 10:20:30'),(3633,'1','307',1,'Retail Sale Id 3677',0.00,856.80,736.00,1000.96,144.16,'2023-03-07 10:21:19'),(3634,'1','307',1,'Retail Sale Id 3678',0.00,1883.70,736.00,2200.64,316.94,'2023-03-07 10:31:01'),(3635,'1','307',1,'Retail Sale Id 3679',0.00,1890.00,736.00,2208.00,318.00,'2023-03-07 10:36:41'),(3636,'1','307',1,'Retail Sale Id 3680',0.00,856.80,736.00,1000.96,144.16,'2023-03-07 11:36:37'),(3637,'1','307',1,'Retail Sale Id 3681',0.00,2520.00,736.00,2944.00,424.00,'2023-03-07 12:00:52'),(3638,'1','307',1,'Retail Sale Id 3682',0.00,642.60,736.00,750.72,108.12,'2023-03-07 12:05:12'),(3639,'1','307',1,'Retail Sale Id 3683',0.00,3780.00,736.00,4416.00,636.00,'2023-03-07 12:44:46'),(3640,'1','307',1,'Retail Sale Id 3684',0.00,1890.00,736.00,2208.00,318.00,'2023-03-07 12:58:16'),(3641,'1','307',1,'Retail Sale Id 3685',0.00,3780.00,736.00,4416.00,636.00,'2023-03-07 13:05:37'),(3642,'1','307',1,'Retail Sale Id 3686',0.00,3780.00,736.00,4416.00,636.00,'2023-03-07 13:36:47'),(3643,'1','307',1,'Retail Sale Id 3687',0.00,31500.00,680.00,34000.00,2500.00,'2023-03-07 13:37:53'),(3644,'1','307',1,'Retail Sale Id 3688',0.00,3150.00,736.00,3680.00,530.00,'2023-03-07 14:02:43'),(3645,'1','307',1,'Retail Sale Id 3689',0.00,1260.00,736.00,1472.00,212.00,'2023-03-07 14:53:03'),(3646,'1','307',1,'Retail Sale Id 3690',0.00,1713.60,736.00,2001.92,288.32,'2023-03-07 14:55:31'),(3647,'1','307',1,'Retail Sale Id 3691',0.00,3811.50,736.00,4452.80,641.30,'2023-03-07 15:18:37'),(3648,'1','307',1,'Retail Sale Id 3692',0.00,2570.40,736.00,3002.88,432.48,'2023-03-07 15:35:58'),(3649,'1','307',1,'Retail Sale Id 3693',0.00,6936.30,736.00,8103.36,1167.06,'2023-03-07 15:38:17'),(3650,'1','307',1,'Retail Sale Id 3694',0.00,12152.70,736.00,14197.44,2044.74,'2023-03-07 15:54:13'),(3651,'1','307',1,'Retail Sale Id 3695',0.00,3780.00,736.00,4416.00,636.00,'2023-03-07 16:02:31'),(3652,'1','307',1,'Retail Sale Id 3696',0.00,5134.50,736.00,5998.40,863.90,'2023-03-07 16:06:32'),(3653,'1','307',1,'Retail Sale Id 3697',0.00,1883.70,736.00,2200.64,316.94,'2023-03-07 16:46:51'),(3654,'1','307',1,'Retail Sale Id 3698',0.00,2526.30,736.00,2951.36,425.06,'2023-03-07 16:49:37'),(3655,'1','307',1,'Retail Sale Id 3699',0.00,11724.30,736.00,13696.96,1972.66,'2023-03-07 16:53:23'),(3656,'1','307',1,'Retail Sale Id 3700',0.00,3786.30,736.00,4423.36,637.06,'2023-03-07 16:56:20'),(3657,'1','307',1,'Retail Sale Id 3701',0.00,2526.30,736.00,2951.36,425.06,'2023-03-07 17:00:15'),(3658,'1','307',1,'Retail Sale Id 3702',0.00,1890.00,736.00,2208.00,318.00,'2023-03-07 17:56:00'),(3659,'1','307',1,'Retail Sale Id 3703',0.00,1902.60,736.00,2222.72,320.12,'2023-03-07 17:58:29'),(3660,'1','307',1,'Retail Sale Id 3704',0.00,2526.30,736.00,2951.36,425.06,'2023-03-07 18:00:15'),(3661,'1','307',1,'Retail Sale Id 3705',0.00,1285.20,736.00,1501.44,216.24,'2023-03-07 18:01:34'),(3662,'1','307',1,'Retail Sale Id 3706',0.00,3849.30,736.00,4496.96,647.66,'2023-03-07 18:10:55'),(3663,'1','307',1,'Retail Sale Id 3707',0.00,2526.30,736.00,2951.36,425.06,'2023-03-07 18:29:56'),(3664,'1','307',1,'Retail Sale Id 3708',0.00,48591.90,736.00,56767.68,8175.78,'2023-03-07 18:57:10'),(3665,'1','307',1,'Retail Sale Id 3709',0.00,3849.30,736.00,4496.96,647.66,'2023-03-08 07:26:14'),(3666,'1','307',1,'Retail Sale Id 3710',0.00,3780.00,736.00,4416.00,636.00,'2023-03-08 07:29:07'),(3667,'1','307',1,'Retail Sale Id 3711',0.00,1285.20,736.00,1501.44,216.24,'2023-03-08 07:32:43'),(3668,'1','307',1,'Retail Sale Id 3712',0.00,2570.40,736.00,3002.88,432.48,'2023-03-08 07:34:03'),(3669,'1','307',1,'Retail Sale Id 3713',0.00,2520.00,736.00,2944.00,424.00,'2023-03-08 07:55:04'),(3670,'1','307',1,'Retail Sale Id 3714',0.00,6300.00,736.00,7360.00,1060.00,'2023-03-08 08:01:36'),(3671,'1','307',1,'Retail Sale Id 3715',0.00,3780.00,736.00,4416.00,636.00,'2023-03-08 08:39:33'),(3672,'1','307',1,'Retail Sale Id 3716',0.00,1883.70,736.00,2200.64,316.94,'2023-03-08 09:01:19'),(3673,'1','307',1,'Retail Sale Id 3717',0.00,63000.00,680.00,68000.00,5000.00,'2023-03-08 09:08:16'),(3674,'1','307',1,'Retail Sale Id 3718',0.00,2570.40,736.00,3002.88,432.48,'2023-03-08 09:12:10'),(3675,'1','307',1,'Retail Sale Id 3719',0.00,1285.20,736.00,1501.44,216.24,'2023-03-08 09:13:34'),(3676,'1','307',1,'Retail Sale Id 3720',0.00,1890.00,736.00,2208.00,318.00,'2023-03-08 09:20:28'),(3677,'1','307',1,'Retail Sale Id 3721',0.00,3780.00,736.00,4416.00,636.00,'2023-03-08 09:25:09'),(3678,'1','307',1,'Retail Sale Id 3722',0.00,3780.00,736.00,4416.00,636.00,'2023-03-08 09:31:26'),(3679,'1','307',1,'Retail Sale Id 3723',0.00,3780.00,736.00,4416.00,636.00,'2023-03-08 09:33:28'),(3680,'1','307',1,'Retail Sale Id 3724',0.00,1260.00,736.00,1472.00,212.00,'2023-03-08 09:35:52'),(3681,'1','307',1,'Retail Sale Id 3725',0.00,3780.00,736.00,4416.00,636.00,'2023-03-08 09:46:46'),(3682,'1','307',1,'Retail Sale Id 3726',0.00,63000.00,680.00,68000.00,5000.00,'2023-03-08 09:55:08'),(3683,'1','307',1,'Retail Sale Id 3727',0.00,3780.00,736.00,4416.00,636.00,'2023-03-08 09:56:40'),(3684,'1','307',1,'Retail Sale Id 3728',0.00,157500.00,680.00,170000.00,12500.00,'2023-03-08 10:27:11'),(3685,'1','307',1,'Retail Sale Id 3729',0.00,3780.00,736.00,4416.00,636.00,'2023-03-08 10:41:00'),(3686,'1','307',1,'Retail Sale Id 3730',0.00,1890.00,736.00,2208.00,318.00,'2023-03-08 10:42:47'),(3687,'1','307',1,'Retail Sale Id 3731',0.00,3780.00,736.00,4416.00,636.00,'2023-03-08 10:44:18'),(3688,'1','307',1,'Retail Sale Id 3732',0.00,1890.00,736.00,2208.00,318.00,'2023-03-08 10:46:39'),(3689,'1','307',1,'Retail Sale Id 3733',0.00,1890.00,736.00,2208.00,318.00,'2023-03-08 10:50:01'),(3690,'1','307',1,'Retail Sale Id 3734',0.00,25200.00,680.00,27200.00,2000.00,'2023-03-08 10:53:43'),(3691,'1','307',1,'Retail Sale Id 3735',0.00,1260.00,736.00,1472.00,212.00,'2023-03-08 11:24:54'),(3692,'1','307',1,'Retail Sale Id 3736',0.00,1890.00,736.00,2208.00,318.00,'2023-03-08 11:31:42'),(3693,'1','307',1,'Retail Sale Id 3737',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-08 11:57:19'),(3694,'1','307',1,'Retail Sale Id 3738',0.00,2520.00,736.00,2944.00,424.00,'2023-03-08 11:59:40'),(3695,'1','307',1,'Retail Sale Id 3739',0.00,7875.00,736.00,9200.00,1325.00,'2023-03-08 12:00:59'),(3696,'1','307',1,'Retail Sale Id 3740',0.00,13954.50,736.00,16302.40,2347.90,'2023-03-08 12:09:38'),(3697,'1','307',1,'Retail Sale Id 3742',0.00,6300.00,736.00,7360.00,1060.00,'2023-03-08 12:36:18'),(3698,'1','307',1,'Retail Sale Id 3743',0.00,6753.60,736.00,7889.92,1136.32,'2023-03-08 12:39:15'),(3699,'1','307',1,'Retail Sale Id 3744',0.00,31500.00,680.00,34000.00,2500.00,'2023-03-08 12:42:39'),(3700,'1','307',1,'Retail Sale Id 3745',0.00,31500.00,680.00,34000.00,2500.00,'2023-03-08 12:57:33'),(3701,'1','307',1,'Return of Retail Sale Id 3742',6300.00,0.00,736.00,-7360.00,-1060.00,'2023-03-08 13:20:16'),(3702,'1','307',1,'Retail Sale Id 3746',0.00,2318.40,736.00,2708.48,390.08,'2023-03-08 13:22:57'),(3703,'1','307',1,'Return of Retail Sale Id 3745',31500.00,0.00,680.00,-34000.00,-2500.00,'2023-03-08 13:30:24'),(3704,'1','307',1,'Return of Retail Sale Id 3744',31500.00,0.00,680.00,-34000.00,-2500.00,'2023-03-08 13:31:57'),(3705,'1','307',1,'Retail Sale Id 3747',0.00,17117.10,680.00,18475.60,1358.50,'2023-03-08 13:37:25'),(3706,'1','307',1,'Retail Sale Id 3748',0.00,1404.90,736.00,1641.28,236.38,'2023-03-08 13:41:13'),(3707,'1','307',1,'Sale Id 6',0.00,73533.60,736.00,85905.92,12372.32,'2023-03-08 13:51:28'),(3708,'1','307',1,'Retail Sale Id 3749',0.00,624.00,700.00,700.00,76.00,'2023-03-08 18:00:14'),(3709,'1','307',1,'Retail Sale Id 3750',0.00,3563.04,700.00,3997.00,433.96,'2023-03-08 18:03:50'),(3710,'1','307',1,'Retail Sale Id 3752',0.00,7800.00,736.00,9200.00,1400.00,'2023-03-08 18:13:15'),(3711,'1','307',1,'Retail Sale Id 3753',0.00,1272.96,736.00,1501.44,228.48,'2023-03-08 18:15:06'),(3712,'1','307',1,'Retail Sale Id 3754',0.00,1272.96,736.00,1501.44,228.48,'2023-03-08 18:16:36'),(3713,'1','307',1,'Retail Sale Id 3756',0.00,18720.00,680.00,20400.00,1680.00,'2023-03-08 18:20:25'),(3714,'1','307',1,'Retail Sale Id 3757',0.00,46800.00,680.00,51000.00,4200.00,'2023-03-08 18:22:06'),(3715,'1','307',1,'Retail Sale Id 3758',0.00,31200.00,680.00,34000.00,2800.00,'2023-03-08 18:25:06'),(3716,'1','307',1,'Retail Sale Id 3759',0.00,23705.76,736.00,27960.64,4254.88,'2023-03-08 18:30:00'),(3717,'1','307',1,'Retail Sale Id 3761',0.00,7800.00,736.00,9200.00,1400.00,'2023-03-08 18:40:33'),(3718,'1','307',1,'Retail Sale Id 3762',0.00,1272.96,736.00,1501.44,228.48,'2023-03-08 18:42:58'),(3719,'1','307',1,'Retail Sale Id 3763',0.00,27524.64,736.00,32464.96,4940.32,'2023-03-08 19:41:14'),(3720,'1','307',1,'Return of Retail Sale Id 3749',624.00,0.00,700.00,-700.00,-76.00,'2023-03-08 19:53:30'),(3721,'1','307',1,'Return of Retail Sale Id 3758',31200.00,0.00,680.00,-34000.00,-2800.00,'2023-03-08 19:56:24'),(3722,'1','307',1,'Return of Retail Sale Id 3757',46800.00,0.00,680.00,-51000.00,-4200.00,'2023-03-08 19:57:37'),(3723,'1','307',1,'Return of Retail Sale Id 3756',18720.00,0.00,680.00,-20400.00,-1680.00,'2023-03-08 19:58:14'),(3724,'1','307',1,'Retail Sale Id 3764',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-08 20:05:12'),(3725,'1','307',1,'Retail Sale Id 3765',0.00,65520.00,658.00,69090.00,3570.00,'2023-03-08 20:06:29'),(3726,'1','307',1,'Return of Retail Sale Id 3763',27524.64,0.00,736.00,-32464.96,-4940.32,'2023-03-08 20:07:32'),(3727,'1','307',1,'Retail Sale Id 3766',0.00,25927.20,700.00,29085.00,3157.80,'2023-03-08 20:09:50'),(3728,'1','307',1,'Retail Sale Id 3767',0.00,5091.84,700.00,5712.00,620.16,'2023-03-09 11:58:52'),(3729,'1','307',1,'Retail Sale Id 3768',0.00,34320.00,658.00,36190.00,1870.00,'2023-03-09 11:59:25'),(3730,'1','307',1,'Retail Sale Id 3769',0.00,7800.00,700.00,8750.00,950.00,'2023-03-09 13:25:06'),(3731,'1','307',1,'Retail Sale Id 3770',0.00,3120.00,700.00,3500.00,380.00,'2023-03-09 13:28:27'),(3732,'1','307',1,'Retail Sale Id 3771',0.00,1872.00,700.00,2100.00,228.00,'2023-03-09 13:34:42'),(3733,'1','307',1,'Retail Sale Id 3772',0.00,1872.00,700.00,2100.00,228.00,'2023-03-09 13:35:46'),(3734,'1','307',1,'Retail Sale Id 3773',0.00,1872.00,700.00,2100.00,228.00,'2023-03-09 13:43:23'),(3735,'1','307',1,'Retail Sale Id 3774',0.00,3744.00,700.00,4200.00,456.00,'2023-03-09 13:51:24'),(3736,'1','307',1,'Retail Sale Id 3775',0.00,3120.00,700.00,3500.00,380.00,'2023-03-09 13:52:52'),(3737,'1','307',1,'Retail Sale Id 3776',0.00,3744.00,700.00,4200.00,456.00,'2023-03-09 14:01:36'),(3738,'1','307',1,'Retail Sale Id 3777',0.00,3120.00,700.00,3500.00,380.00,'2023-03-09 14:02:51'),(3739,'1','307',1,'Retail Sale Id 3778',0.00,1248.00,700.00,1400.00,152.00,'2023-03-09 14:05:43'),(3740,'1','307',1,'Retail Sale Id 3779',0.00,1872.00,700.00,2100.00,228.00,'2023-03-09 14:10:13'),(3741,'1','307',1,'Retail Sale Id 3780',0.00,1872.00,700.00,2100.00,228.00,'2023-03-09 14:11:01'),(3742,'1','307',1,'Retail Sale Id 3781',0.00,3744.00,700.00,4200.00,456.00,'2023-03-09 14:18:32'),(3743,'1','307',1,'Retail Sale Id 3782',0.00,1248.00,700.00,1400.00,152.00,'2023-03-09 14:25:15'),(3744,'1','307',1,'Retail Sale Id 3783',0.00,1248.00,700.00,1400.00,152.00,'2023-03-09 14:28:37'),(3745,'1','307',1,'Retail Sale Id 3784',0.00,711.36,700.00,798.00,86.64,'2023-03-09 14:49:04'),(3746,'1','307',1,'Retail Sale Id 3785',0.00,22195.68,700.00,24899.00,2703.32,'2023-03-09 15:42:54'),(3747,'1','307',1,'Retail Sale Id 3786',0.00,23712.00,658.00,25004.00,1292.00,'2023-03-09 16:37:30'),(3748,'1','307',1,'Retail Sale Id 3787',0.00,17160.00,700.00,19250.00,2090.00,'2023-03-09 16:39:59'),(3749,'1','307',1,'Retail Sale Id 3788',0.00,62400.00,658.00,65800.00,3400.00,'2023-03-09 16:41:02'),(3750,'1','307',1,'Retail Sale Id 3789',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-09 16:43:22'),(3751,'1','307',1,'Retail Sale Id 3790',0.00,13104.00,700.00,14700.00,1596.00,'2023-03-09 16:55:53'),(3752,'1','307',1,'Retail Sale Id 3791',0.00,62400.00,658.00,65800.00,3400.00,'2023-03-09 17:03:44'),(3753,'1','307',1,'Retail Sale Id 3792',0.00,1872.00,700.00,2100.00,228.00,'2023-03-09 17:11:22'),(3754,'1','307',1,'Retail Sale Id 3793',0.00,624.00,700.00,700.00,76.00,'2023-03-09 17:14:14'),(3755,'1','307',1,'Retail Sale Id 3793',0.00,3744.00,700.00,4200.00,456.00,'2023-03-09 17:14:14'),(3756,'1','307',1,'Retail Sale Id 3794',0.00,1248.00,700.00,1400.00,152.00,'2023-03-09 17:22:25'),(3757,'1','307',1,'Retail Sale Id 3795',0.00,1335.36,700.00,1498.00,162.64,'2023-03-09 17:24:15'),(3758,'1','307',1,'Retail Sale Id 3796',0.00,3120.00,700.00,3500.00,380.00,'2023-03-09 17:26:30'),(3759,'1','307',1,'Retail Sale Id 3797',0.00,3563.04,700.00,3997.00,433.96,'2023-03-09 17:28:19'),(3760,'1','307',1,'Retail Sale Id 3798',0.00,2496.00,700.00,2800.00,304.00,'2023-03-09 17:31:04'),(3761,'1','307',1,'Retail Sale Id 3799',0.00,4992.00,700.00,5600.00,608.00,'2023-03-09 17:32:55'),(3762,'1','307',1,'Retail Sale Id 3800',0.00,62400.00,658.00,65800.00,3400.00,'2023-03-09 17:35:09'),(3763,'1','307',1,'Retail Sale Id 3801',0.00,3744.00,700.00,4200.00,456.00,'2023-03-09 17:37:56'),(3764,'1','307',1,'Retail Sale Id 3802',0.00,1872.00,700.00,2100.00,228.00,'2023-03-09 17:40:36'),(3765,'1','307',1,'Retail Sale Id 3803',0.00,11675.04,700.00,13097.00,1421.96,'2023-03-09 17:56:37'),(3766,'1','307',1,'Retail Sale Id 3804',0.00,18720.00,658.00,19740.00,1020.00,'2023-03-09 17:58:31'),(3767,'1','307',1,'Retail Sale Id 3805',0.00,3744.00,700.00,4200.00,456.00,'2023-03-09 17:59:27'),(3768,'1','307',1,'Retail Sale Id 3806',0.00,13952.64,700.00,15652.00,1699.36,'2023-03-09 18:29:13'),(3769,'1','307',1,'Retail Sale Id 3807',0.00,13952.64,700.00,15652.00,1699.36,'2023-03-09 18:30:18'),(3770,'1','307',1,'Retail Sale Id 3808',0.00,13490.88,700.00,15134.00,1643.12,'2023-03-09 18:47:58'),(3771,'1','307',1,'Retail Sale Id 3809',0.00,1872.00,700.00,2100.00,228.00,'2023-03-10 07:26:56'),(3772,'1','307',1,'Retail Sale Id 3810',0.00,4368.00,700.00,4900.00,532.00,'2023-03-10 07:36:26'),(3773,'1','307',1,'Retail Sale Id 3811',0.00,892.32,700.00,1001.00,108.68,'2023-03-10 07:51:09'),(3774,'1','307',1,'Retail Sale Id 3812',0.00,3120.00,700.00,3500.00,380.00,'2023-03-10 07:53:36'),(3775,'1','307',1,'Retail Sale Id 3813',0.00,62400.00,658.00,65800.00,3400.00,'2023-03-10 08:15:15'),(3776,'1','307',1,'Retail Sale Id 3814',0.00,62400.00,658.00,65800.00,3400.00,'2023-03-10 08:16:25'),(3777,'1','307',1,'Retail Sale Id 3815',0.00,7800.00,700.00,8750.00,950.00,'2023-03-10 08:17:24'),(3778,'1','307',1,'Retail Sale Id 3816',0.00,6864.00,700.00,7700.00,836.00,'2023-03-10 08:18:11'),(3779,'1','307',1,'Retail Sale Id 3817',0.00,2496.00,700.00,2800.00,304.00,'2023-03-10 08:19:09'),(3780,'1','307',1,'Retail Sale Id 3818',0.00,2496.00,700.00,2800.00,304.00,'2023-03-10 08:21:31'),(3781,'1','307',1,'Retail Sale Id 3819',0.00,1872.00,700.00,2100.00,228.00,'2023-03-10 08:29:43'),(3782,'1','307',1,'Retail Sale Id 3820',0.00,1872.00,700.00,2100.00,228.00,'2023-03-10 08:30:37'),(3783,'1','307',1,'Retail Sale Id 3821',0.00,1248.00,700.00,1400.00,152.00,'2023-03-10 08:31:43'),(3784,'1','307',1,'Retail Sale Id 3822',0.00,892.32,700.00,1001.00,108.68,'2023-03-10 08:32:36'),(3785,'1','307',1,'Retail Sale Id 3823',0.00,1248.00,700.00,1400.00,152.00,'2023-03-10 08:33:48'),(3786,'1','307',1,'Retail Sale Id 3824',0.00,3744.00,700.00,4200.00,456.00,'2023-03-10 08:34:47'),(3787,'1','307',1,'Retail Sale Id 3825',0.00,7800.00,700.00,8750.00,950.00,'2023-03-10 08:39:40'),(3788,'1','307',1,'Retail Sale Id 3826',0.00,3744.00,700.00,4200.00,456.00,'2023-03-10 08:53:11'),(3789,'1','307',1,'Retail Sale Id 3827',0.00,2496.00,700.00,2800.00,304.00,'2023-03-10 09:21:50'),(3790,'1','307',1,'Retail Sale Id 3828',0.00,7800.00,700.00,8750.00,950.00,'2023-03-10 09:34:16'),(3791,'1','307',1,'Retail Sale Id 3829',0.00,17784.00,700.00,19950.00,2166.00,'2023-03-10 10:55:59'),(3792,'1','307',1,'Retail Sale Id 3830',0.00,3120.00,700.00,3500.00,380.00,'2023-03-10 11:19:17'),(3793,'1','307',1,'Retail Sale Id 3831',0.00,1248.00,700.00,1400.00,152.00,'2023-03-10 11:21:46'),(3794,'1','307',1,'Retail Sale Id 3832',0.00,1872.00,700.00,2100.00,228.00,'2023-03-10 11:23:45'),(3795,'1','307',1,'Retail Sale Id 3833',0.00,1248.00,700.00,1400.00,152.00,'2023-03-10 11:27:54'),(3796,'1','307',1,'Retail Sale Id 3834',0.00,1335.36,700.00,1498.00,162.64,'2023-03-10 11:41:26'),(3797,'1','307',1,'Retail Sale Id 3835',0.00,3744.00,700.00,4200.00,456.00,'2023-03-10 11:51:12'),(3798,'1','307',1,'Retail Sale Id 3836',0.00,7800.00,700.00,8750.00,950.00,'2023-03-10 12:02:36'),(3799,'1','307',1,'Retail Sale Id 3837',0.00,3744.00,700.00,4200.00,456.00,'2023-03-10 12:05:35'),(3800,'1','307',1,'Retail Sale Id 3838',0.00,3744.00,700.00,4200.00,456.00,'2023-03-10 12:14:01'),(3801,'1','307',1,'Retail Sale Id 3839',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-10 12:20:29'),(3802,'1','307',1,'Retail Sale Id 3840',0.00,7800.00,700.00,8750.00,950.00,'2023-03-10 12:22:17'),(3803,'1','307',1,'Retail Sale Id 3841',0.00,3744.00,700.00,4200.00,456.00,'2023-03-10 12:23:40'),(3804,'1','307',1,'Retail Sale Id 3842',0.00,624000.00,700.00,700000.00,76000.00,'2023-03-10 12:38:20'),(3805,'1','307',1,'Retail Sale Id 3843',0.00,3744.00,700.00,4200.00,456.00,'2023-03-10 12:48:48'),(3806,'1','307',1,'Return of Retail Sale Id 3842',624000.00,0.00,700.00,-700000.00,-76000.00,'2023-03-10 12:52:19'),(3807,'1','307',1,'Retail Sale Id 3844',0.00,892.32,700.00,1001.00,108.68,'2023-03-10 12:53:14'),(3808,'1','307',1,'Retail Sale Id 3845',0.00,16124.16,658.00,17002.72,878.56,'2023-03-10 13:14:09'),(3809,'1','307',1,'Retail Sale Id 3846',0.00,3744.00,700.00,4200.00,456.00,'2023-03-10 13:37:31'),(3810,'1','307',1,'Retail Sale Id 3847',0.00,7800.00,700.00,8750.00,950.00,'2023-03-10 13:38:20'),(3811,'1','307',1,'Retail Sale Id 3848',0.00,3744.00,700.00,4200.00,456.00,'2023-03-10 13:39:07'),(3812,'1','307',1,'Retail Sale Id 3849',0.00,2496.00,700.00,2800.00,304.00,'2023-03-10 13:42:17'),(3813,'1','307',1,'Retail Sale Id 3850',0.00,1872.00,700.00,2100.00,228.00,'2023-03-10 14:06:57'),(3814,'1','307',1,'Retail Sale Id 3851',0.00,5616.00,700.00,6300.00,684.00,'2023-03-10 15:20:52'),(3815,'1','307',1,'Retail Sale Id 3852',0.00,39000.00,658.00,41125.00,2125.00,'2023-03-10 15:33:00'),(3816,'1','307',1,'Retail Sale Id 3853',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-10 15:38:15'),(3817,'1','307',1,'Retail Sale Id 3854',0.00,1248.00,700.00,1400.00,152.00,'2023-03-10 15:39:30'),(3818,'1','307',1,'Retail Sale Id 3855',0.00,7176.00,700.00,8050.00,874.00,'2023-03-10 15:40:46'),(3819,'1','307',1,'Retail Sale Id 3856',0.00,3744.00,700.00,4200.00,456.00,'2023-03-10 15:56:42'),(3820,'1','307',1,'Retail Sale Id 3857',0.00,1872.00,700.00,2100.00,228.00,'2023-03-10 16:00:32'),(3821,'1','307',1,'Retail Sale Id 3858',0.00,624.00,700.00,700.00,76.00,'2023-03-10 16:07:41'),(3822,'1','307',1,'Retail Sale Id 3859',0.00,3744.00,700.00,4200.00,456.00,'2023-03-10 16:24:06'),(3823,'1','307',1,'Retail Sale Id 3860',0.00,19968.00,700.00,22400.00,2432.00,'2023-03-10 16:51:42'),(3824,'1','307',1,'Retail Sale Id 3861',0.00,1872.00,700.00,2100.00,228.00,'2023-03-10 17:20:35'),(3825,'1','307',1,'Retail Sale Id 3862',0.00,6240.00,700.00,7000.00,760.00,'2023-03-10 17:34:28'),(3826,'1','307',1,'Retail Sale Id 3863',0.00,22570.08,658.00,23799.86,1229.78,'2023-03-10 17:47:14'),(3827,'1','307',1,'Retail Sale Id 3865',0.00,1872.00,700.00,2100.00,228.00,'2023-03-10 17:49:12'),(3828,'1','307',1,'Retail Sale Id 3866',0.00,11544.00,700.00,12950.00,1406.00,'2023-03-10 18:09:38'),(3829,'1','307',1,'Retail Sale Id 3867',0.00,62400.00,658.00,65800.00,3400.00,'2023-03-10 18:13:43'),(3830,'1','307',1,'Retail Sale Id 3868',0.00,7800.00,700.00,8750.00,950.00,'2023-03-10 18:24:08'),(3831,'1','307',1,'Retail Sale Id 3869',0.00,21571.68,700.00,24199.00,2627.32,'2023-03-10 18:43:39'),(3832,'1','307',1,'Retail Sale Id 3870',0.00,1248.00,700.00,1400.00,152.00,'2023-03-10 19:24:26'),(3833,'1','307',1,'Retail Sale Id 3871',0.00,9672.00,700.00,10850.00,1178.00,'2023-03-11 07:25:50'),(3834,'1','307',1,'Retail Sale Id 3872',0.00,3744.00,700.00,4200.00,456.00,'2023-03-11 07:33:03'),(3835,'1','307',1,'Retail Sale Id 3873',0.00,3744.00,700.00,4200.00,456.00,'2023-03-11 07:59:54'),(3836,'1','307',1,'Retail Sale Id 3874',0.00,7800.00,700.00,8750.00,950.00,'2023-03-11 08:06:06'),(3837,'1','307',1,'Retail Sale Id 3875',0.00,7800.00,700.00,8750.00,950.00,'2023-03-11 08:16:17'),(3838,'1','307',1,'Retail Sale Id 3876',0.00,2496.00,700.00,2800.00,304.00,'2023-03-11 08:20:32'),(3839,'1','307',1,'Retail Sale Id 3877',0.00,3120.00,700.00,3500.00,380.00,'2023-03-11 08:29:19'),(3840,'1','307',1,'Retail Sale Id 3878',0.00,624.00,700.00,700.00,76.00,'2023-03-11 08:33:41'),(3841,'1','307',1,'Retail Sale Id 3880',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 08:36:08'),(3842,'1','307',1,'Retail Sale Id 3881',0.00,1335.36,700.00,1498.00,162.64,'2023-03-11 08:41:54'),(3843,'1','307',1,'Retail Sale Id 3882',0.00,892.32,700.00,1001.00,108.68,'2023-03-11 08:44:33'),(3844,'1','307',1,'Retail Sale Id 3883',0.00,3120.00,700.00,3500.00,380.00,'2023-03-11 09:02:08'),(3845,'1','307',1,'Retail Sale Id 3884',0.00,3744.00,700.00,4200.00,456.00,'2023-03-11 09:04:50'),(3846,'1','307',1,'Retail Sale Id 3885',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 09:07:03'),(3847,'1','307',1,'Retail Sale Id 3886',0.00,62400.00,658.00,65800.00,3400.00,'2023-03-11 09:16:27'),(3848,'1','307',1,'Retail Sale Id 3887',0.00,1248.00,700.00,1400.00,152.00,'2023-03-11 09:21:17'),(3849,'1','307',1,'Retail Sale Id 3888',0.00,2227.68,700.00,2499.00,271.32,'2023-03-11 09:30:24'),(3850,'1','307',1,'Retail Sale Id 3889',0.00,1784.64,700.00,2002.00,217.36,'2023-03-11 09:31:48'),(3851,'1','307',1,'Retail Sale Id 3890',0.00,7800.00,700.00,8750.00,950.00,'2023-03-11 09:34:27'),(3852,'1','307',1,'Retail Sale Id 3891',0.00,2496.00,700.00,2800.00,304.00,'2023-03-11 09:36:43'),(3853,'1','307',1,'Retail Sale Id 3892',0.00,4368.00,700.00,4900.00,532.00,'2023-03-11 09:56:32'),(3854,'1','307',1,'Retail Sale Id 3893',0.00,2496.00,700.00,2800.00,304.00,'2023-03-11 10:02:26'),(3855,'1','307',1,'Retail Sale Id 3894',0.00,2496.00,700.00,2800.00,304.00,'2023-03-11 10:24:54'),(3856,'1','307',1,'Retail Sale Id 3896',0.00,3120.00,700.00,3500.00,380.00,'2023-03-11 10:26:23'),(3857,'1','307',1,'Retail Sale Id 3897',0.00,14227.20,658.00,15002.40,775.20,'2023-03-11 10:28:57'),(3858,'1','307',1,'Retail Sale Id 3898',0.00,3744.00,700.00,4200.00,456.00,'2023-03-11 10:29:48'),(3859,'1','307',1,'Retail Sale Id 3899',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-11 10:32:02'),(3860,'1','307',1,'Retail Sale Id 3900',0.00,892.32,700.00,1001.00,108.68,'2023-03-11 10:36:23'),(3861,'1','307',1,'Retail Sale Id 3901',0.00,3744.00,700.00,4200.00,456.00,'2023-03-11 10:40:00'),(3862,'1','307',1,'Retail Sale Id 3902',0.00,3744.00,700.00,4200.00,456.00,'2023-03-11 10:53:01'),(3863,'1','307',1,'Retail Sale Id 3903',0.00,3744.00,700.00,4200.00,456.00,'2023-03-11 10:58:49'),(3864,'1','307',1,'Retail Sale Id 3904',0.00,2496.00,700.00,2800.00,304.00,'2023-03-11 11:00:16'),(3865,'1','307',1,'Retail Sale Id 3905',0.00,124800.00,658.00,131600.00,6800.00,'2023-03-11 11:04:49'),(3866,'1','307',1,'Retail Sale Id 3906',0.00,7800.00,700.00,8750.00,950.00,'2023-03-11 11:29:45'),(3867,'1','307',1,'Retail Sale Id 3907',0.00,1067.04,700.00,1197.00,129.96,'2023-03-11 11:31:05'),(3868,'1','307',1,'Retail Sale Id 3908',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 12:00:34'),(3869,'1','307',1,'Retail Sale Id 3909',0.00,3744.00,700.00,4200.00,456.00,'2023-03-11 12:04:25'),(3870,'1','307',1,'Retail Sale Id 3910',0.00,4368.00,700.00,4900.00,532.00,'2023-03-11 12:09:38'),(3871,'1','307',1,'Retail Sale Id 3911',0.00,46800.00,658.00,49350.00,2550.00,'2023-03-11 12:16:40'),(3872,'1','307',1,'Retail Sale Id 3912',0.00,3744.00,700.00,4200.00,456.00,'2023-03-11 12:35:35'),(3873,'1','307',1,'Retail Sale Id 3913',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-11 12:38:41'),(3874,'1','307',1,'Retail Sale Id 3914',0.00,4368.00,700.00,4900.00,532.00,'2023-03-11 12:40:31'),(3875,'1','307',1,'Retail Sale Id 3915',0.00,3744.00,700.00,4200.00,456.00,'2023-03-11 12:41:22'),(3876,'1','307',1,'Retail Sale Id 3916',0.00,8112.00,700.00,9100.00,988.00,'2023-03-11 12:44:13'),(3877,'1','307',1,'Retail Sale Id 3917',0.00,2496.00,700.00,2800.00,304.00,'2023-03-11 12:54:09'),(3878,'1','307',1,'Retail Sale Id 3918',0.00,7800.00,700.00,8750.00,950.00,'2023-03-11 13:27:00'),(3879,'1','307',1,'Retail Sale Id 3919',0.00,3744.00,700.00,4200.00,456.00,'2023-03-11 13:31:06'),(3880,'1','307',1,'Retail Sale Id 3920',0.00,7800.00,700.00,8750.00,950.00,'2023-03-11 13:36:58'),(3881,'1','307',1,'Retail Sale Id 3921',0.00,6864.00,700.00,7700.00,836.00,'2023-03-11 13:47:36'),(3882,'1','307',1,'Retail Sale Id 3922',0.00,3120.00,700.00,3500.00,380.00,'2023-03-11 13:49:48'),(3883,'1','307',1,'Retail Sale Id 3923',0.00,892.32,700.00,1001.00,108.68,'2023-03-11 14:08:42'),(3884,'1','307',1,'Retail Sale Id 3924',0.00,3744.00,700.00,4200.00,456.00,'2023-03-11 14:18:38'),(3885,'1','307',1,'Retail Sale Id 3925',0.00,1248.00,700.00,1400.00,152.00,'2023-03-11 14:56:29'),(3886,'1','307',1,'Retail Sale Id 3926',0.00,38975.04,658.00,41098.68,2123.64,'2023-03-11 15:00:47'),(3887,'1','307',1,'Retail Sale Id 3927',0.00,6240.00,700.00,7000.00,760.00,'2023-03-11 15:03:34'),(3888,'1','307',1,'Retail Sale Id 3928',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 15:06:07'),(3889,'1','307',1,'Retail Sale Id 3929',0.00,3744.00,700.00,4200.00,456.00,'2023-03-11 15:16:46'),(3890,'1','307',1,'Retail Sale Id 3930',0.00,8916.96,700.00,10003.00,1086.04,'2023-03-11 16:01:38'),(3891,'1','307',1,'Retail Sale Id 3931',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 16:02:42'),(3892,'1','307',1,'Retail Sale Id 3932',0.00,4992.00,700.00,5600.00,608.00,'2023-03-11 16:04:12'),(3893,'1','307',1,'Retail Sale Id 3933',0.00,7800.00,700.00,8750.00,950.00,'2023-03-11 16:15:08'),(3894,'1','307',1,'Retail Sale Id 3934',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 16:16:15'),(3895,'1','307',1,'Retail Sale Id 3935',0.00,2496.00,700.00,2800.00,304.00,'2023-03-11 16:17:15'),(3896,'1','307',1,'Retail Sale Id 3936',0.00,1248.00,700.00,1400.00,152.00,'2023-03-11 16:18:58'),(3897,'1','307',1,'Retail Sale Id 3937',0.00,7800.00,700.00,8750.00,950.00,'2023-03-11 16:57:28'),(3898,'1','307',1,'Retail Sale Id 3938',0.00,25671.36,700.00,28798.00,3126.64,'2023-03-11 16:59:49'),(3899,'1','307',1,'Retail Sale Id 3939',0.00,12168.00,700.00,13650.00,1482.00,'2023-03-11 17:18:32'),(3900,'1','307',1,'Retail Sale Id 3940',0.00,17472.00,700.00,19600.00,2128.00,'2023-03-11 17:59:40'),(3901,'1','307',1,'Retail Sale Id 3941',0.00,17472.00,700.00,19600.00,2128.00,'2023-03-11 18:00:34'),(3902,'1','307',1,'Retail Sale Id 3942',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 18:01:43'),(3903,'1','307',1,'Retail Sale Id 3943',0.00,7800.00,700.00,8750.00,950.00,'2023-03-11 18:05:22'),(3904,'1','307',1,'Retail Sale Id 3944',0.00,3744.00,700.00,4200.00,456.00,'2023-03-11 18:32:35'),(3905,'1','307',1,'Retail Sale Id 3945',0.00,4368.00,700.00,4900.00,532.00,'2023-03-11 18:33:44'),(3906,'1','307',1,'Retail Sale Id 3946',0.00,1872.00,700.00,2100.00,228.00,'2023-03-11 18:35:03'),(3907,'1','307',1,'Retail Sale Id 3947',0.00,7800.00,700.00,8750.00,950.00,'2023-03-11 18:36:05'),(3908,'1','307',1,'Return of Retail Sale Id 3926',38975.04,0.00,658.00,-41098.68,-2123.64,'2023-03-11 18:53:15'),(3909,'1','307',1,'Retail Sale Id 3948',0.00,13328.64,658.00,14054.88,726.24,'2023-03-11 18:55:31'),(3910,'1','307',1,'Retail Sale Id 3949',0.00,41957.76,700.00,47068.00,5110.24,'2023-03-11 19:12:17'),(3911,'1','307',1,'Return of Retail Sale Id 3949',41957.76,0.00,700.00,-47068.00,-5110.24,'2023-03-11 19:24:53'),(3912,'1','307',1,'Retail Sale Id 3950',0.00,13983.84,700.00,15687.00,1703.16,'2023-03-11 19:30:45'),(3913,'1','307',1,'Retail Sale Id 3951',0.00,13983.84,700.00,15687.00,1703.16,'2023-03-11 19:31:39'),(3914,'1','307',1,'Retail Sale Id 3953',0.00,13990.08,700.00,15694.00,1703.92,'2023-03-11 19:33:57'),(3915,'1','307',1,'Return of Retail Sale Id 3936',1248.00,0.00,700.00,-1400.00,-152.00,'2023-03-11 19:51:18'),(3916,'1','307',1,'Return of Retail Sale Id 3942',1872.00,0.00,700.00,-2100.00,-228.00,'2023-03-11 19:53:23'),(3917,'1','307',1,'Retail Sale Id 3954',0.00,2184.00,700.00,2450.00,266.00,'2023-03-11 19:54:35'),(3918,'1','307',1,'Retail Sale Id 3955',0.00,3744.00,700.00,4200.00,456.00,'2023-03-12 07:22:51'),(3919,'1','307',1,'Retail Sale Id 3956',0.00,3120.00,700.00,3500.00,380.00,'2023-03-12 07:24:50'),(3920,'1','307',1,'Retail Sale Id 3957',0.00,3744.00,700.00,4200.00,456.00,'2023-03-12 07:34:28'),(3921,'1','307',1,'Retail Sale Id 3958',0.00,1248.00,700.00,1400.00,152.00,'2023-03-12 08:06:36'),(3922,'1','307',1,'Return of Retail Sale Id 3958',1248.00,0.00,700.00,-1400.00,-152.00,'2023-03-12 08:07:32'),(3923,'1','307',1,'Retail Sale Id 3959',0.00,1248.00,700.00,1400.00,152.00,'2023-03-12 08:08:13'),(3924,'1','307',1,'Retail Sale Id 3960',0.00,10608.00,700.00,11900.00,1292.00,'2023-03-12 08:22:33'),(3925,'1','307',1,'Retail Sale Id 3961',0.00,1248.00,700.00,1400.00,152.00,'2023-03-12 08:49:08'),(3926,'1','307',1,'Retail Sale Id 3962',0.00,39000.00,658.00,41125.00,2125.00,'2023-03-12 08:57:39'),(3927,'1','307',1,'Retail Sale Id 3963',0.00,3120.00,700.00,3500.00,380.00,'2023-03-12 09:01:30'),(3928,'1','307',1,'Retail Sale Id 3964',0.00,2496.00,700.00,2800.00,304.00,'2023-03-12 09:05:43'),(3929,'1','307',1,'Retail Sale Id 3965',0.00,3744.00,700.00,4200.00,456.00,'2023-03-12 09:08:56'),(3930,'1','307',1,'Retail Sale Id 3966',0.00,7800.00,700.00,8750.00,950.00,'2023-03-12 09:10:53'),(3931,'1','307',1,'Retail Sale Id 3967',0.00,624.00,700.00,700.00,76.00,'2023-03-12 09:12:09'),(3932,'1','307',1,'Retail Sale Id 3968',0.00,3744.00,700.00,4200.00,456.00,'2023-03-12 09:14:46'),(3933,'1','307',1,'Retail Sale Id 3969',0.00,7800.00,700.00,8750.00,950.00,'2023-03-12 09:19:00'),(3934,'1','307',1,'Retail Sale Id 3970',0.00,62400.00,658.00,65800.00,3400.00,'2023-03-12 09:30:53'),(3935,'1','307',1,'Retail Sale Id 3971',0.00,8112.00,700.00,9100.00,988.00,'2023-03-12 09:40:41'),(3936,'1','307',1,'Retail Sale Id 3972',0.00,3120.00,700.00,3500.00,380.00,'2023-03-12 09:48:35'),(3937,'1','307',1,'Retail Sale Id 3973',0.00,3744.00,700.00,4200.00,456.00,'2023-03-12 09:49:53'),(3938,'1','307',1,'Retail Sale Id 3974',0.00,11544.00,700.00,12950.00,1406.00,'2023-03-12 10:13:23'),(3939,'1','307',1,'Retail Sale Id 3975',0.00,1248.00,700.00,1400.00,152.00,'2023-03-12 10:18:45'),(3940,'1','307',1,'Retail Sale Id 3976',0.00,1784.64,700.00,2002.00,217.36,'2023-03-12 10:27:49'),(3941,'1','307',1,'Retail Sale Id 3977',0.00,17472.00,700.00,19600.00,2128.00,'2023-03-12 10:30:08'),(3942,'1','307',1,'Retail Sale Id 3978',0.00,3744.00,700.00,4200.00,456.00,'2023-03-12 10:45:02'),(3943,'1','307',1,'Retail Sale Id 3979',0.00,1248.00,700.00,1400.00,152.00,'2023-03-12 10:46:37'),(3944,'1','307',1,'Retail Sale Id 3980',0.00,3120.00,700.00,3500.00,380.00,'2023-03-12 10:50:48'),(3945,'1','307',1,'Retail Sale Id 3981',0.00,7800.00,700.00,8750.00,950.00,'2023-03-12 10:52:24'),(3946,'1','307',1,'Retail Sale Id 3983',0.00,31387.20,658.00,33097.40,1710.20,'2023-03-12 10:55:42'),(3947,'1','307',1,'Retail Sale Id 3984',0.00,7800.00,700.00,8750.00,950.00,'2023-03-12 11:17:22'),(3948,'1','307',1,'Retail Sale Id 3985',0.00,3120.00,700.00,3500.00,380.00,'2023-03-12 11:19:59'),(3949,'1','307',1,'Retail Sale Id 3986',0.00,1872.00,700.00,2100.00,228.00,'2023-03-12 11:24:27'),(3950,'1','307',1,'Retail Sale Id 3987',0.00,2496.00,700.00,2800.00,304.00,'2023-03-12 11:32:08'),(3951,'1','307',1,'Retail Sale Id 3988',0.00,892.32,700.00,1001.00,108.68,'2023-03-12 11:35:03'),(3952,'1','307',1,'Retail Sale Id 3989',0.00,8424.00,700.00,9450.00,1026.00,'2023-03-12 11:37:00'),(3953,'1','307',1,'Retail Sale Id 3990',0.00,1872.00,700.00,2100.00,228.00,'2023-03-12 11:38:08'),(3954,'1','307',1,'Retail Sale Id 3991',0.00,4368.00,700.00,4900.00,532.00,'2023-03-12 11:44:34'),(3955,'1','307',1,'Retail Sale Id 3992',0.00,3744.00,700.00,4200.00,456.00,'2023-03-12 12:42:27'),(3956,'1','307',1,'Retail Sale Id 3993',0.00,1872.00,700.00,2100.00,228.00,'2023-03-12 12:52:29'),(3957,'1','307',1,'Retail Sale Id 3994',0.00,3744.00,700.00,4200.00,456.00,'2023-03-12 12:56:20'),(3958,'1','307',1,'Retail Sale Id 3995',0.00,624.00,700.00,700.00,76.00,'2023-03-12 13:07:15'),(3959,'1','307',1,'Retail Sale Id 3996',0.00,3744.00,700.00,4200.00,456.00,'2023-03-12 13:28:07'),(3960,'1','307',1,'Retail Sale Id 3997',0.00,8024.64,700.00,9002.00,977.36,'2023-03-12 13:29:32'),(3961,'1','307',1,'Retail Sale Id 3998',0.00,1872.00,700.00,2100.00,228.00,'2023-03-12 13:30:22'),(3962,'1','307',1,'Retail Sale Id 3999',0.00,1872.00,700.00,2100.00,228.00,'2023-03-12 13:38:47'),(3963,'1','307',1,'Retail Sale Id 4000',0.00,3744.00,700.00,4200.00,456.00,'2023-03-12 13:40:59'),(3964,'1','307',1,'Retail Sale Id 4001',0.00,3120.00,700.00,3500.00,380.00,'2023-03-12 14:16:36'),(3965,'1','307',1,'Retail Sale Id 4002',0.00,1872.00,700.00,2100.00,228.00,'2023-03-12 14:22:38'),(3966,'1','307',1,'Retail Sale Id 4003',0.00,1872.00,700.00,2100.00,228.00,'2023-03-12 14:29:38'),(3967,'1','307',1,'Retail Sale Id 4004',0.00,624.00,700.00,700.00,76.00,'2023-03-12 14:42:09'),(3968,'1','307',1,'Retail Sale Id 4005',0.00,7800.00,700.00,8750.00,950.00,'2023-03-12 14:43:51'),(3969,'1','307',1,'Retail Sale Id 4006',0.00,3744.00,700.00,4200.00,456.00,'2023-03-12 15:07:35'),(3970,'1','307',1,'Retail Sale Id 4007',0.00,1872.00,700.00,2100.00,228.00,'2023-03-12 15:10:40'),(3971,'1','307',1,'Retail Sale Id 4008',0.00,3563.04,700.00,3997.00,433.96,'2023-03-12 15:25:40'),(3972,'1','307',1,'Retail Sale Id 4009',0.00,5616.00,700.00,6300.00,684.00,'2023-03-12 15:34:17'),(3973,'1','307',1,'Retail Sale Id 4010',0.00,3120.00,700.00,3500.00,380.00,'2023-03-12 15:36:39'),(3974,'1','307',1,'Retail Sale Id 4011',0.00,7800.00,700.00,8750.00,950.00,'2023-03-12 16:16:08'),(3975,'1','307',1,'Retail Sale Id 4012',0.00,2676.96,700.00,3003.00,326.04,'2023-03-12 16:22:36'),(3976,'1','307',1,'Retail Sale Id 4013',0.00,3744.00,700.00,4200.00,456.00,'2023-03-12 16:23:37'),(3977,'1','307',1,'Retail Sale Id 4014',0.00,9360.00,700.00,10500.00,1140.00,'2023-03-12 16:27:57'),(3978,'1','307',1,'Retail Sale Id 4015',0.00,3744.00,700.00,4200.00,456.00,'2023-03-12 17:03:55'),(3979,'1','307',1,'Retail Sale Id 4016',0.00,3120.00,700.00,3500.00,380.00,'2023-03-12 17:05:07'),(3980,'1','307',1,'Retail Sale Id 4017',0.00,1784.64,700.00,2002.00,217.36,'2023-03-12 17:08:31'),(3981,'1','307',1,'Retail Sale Id 4018',0.00,1872.00,700.00,2100.00,228.00,'2023-03-12 17:10:24'),(3982,'1','307',1,'Retail Sale Id 4019',0.00,1872.00,700.00,2100.00,228.00,'2023-03-12 17:11:52'),(3983,'1','307',1,'Retail Sale Id 4020',0.00,3120.00,700.00,3500.00,380.00,'2023-03-12 17:15:57'),(3984,'1','307',1,'Retail Sale Id 4021',0.00,1872.00,700.00,2100.00,228.00,'2023-03-12 17:21:43'),(3985,'1','307',1,'Retail Sale Id 4022',0.00,5796.96,700.00,6503.00,706.04,'2023-03-12 17:40:29'),(3986,'1','307',1,'Retail Sale Id 4023',0.00,624.00,700.00,700.00,76.00,'2023-03-12 17:41:25'),(3987,'1','307',1,'Retail Sale Id 4024',0.00,1784.64,700.00,2002.00,217.36,'2023-03-12 17:48:43'),(3988,'1','307',1,'Retail Sale Id 4025',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-12 17:55:26'),(3989,'1','307',1,'Retail Sale Id 4026',0.00,3120.00,700.00,3500.00,380.00,'2023-03-12 18:03:14'),(3990,'1','307',1,'Retail Sale Id 4027',0.00,11232.00,700.00,12600.00,1368.00,'2023-03-12 18:25:41'),(3991,'1','307',1,'Retail Sale Id 4028',0.00,7800.00,700.00,8750.00,950.00,'2023-03-12 18:31:54'),(3992,'1','307',1,'Retail Sale Id 4029',0.00,1872.00,700.00,2100.00,228.00,'2023-03-12 18:45:52'),(3993,'1','307',1,'Retail Sale Id 4030',0.00,1067.04,700.00,1197.00,129.96,'2023-03-12 18:51:36'),(3994,'1','307',1,'Retail Sale Id 4031',0.00,4779.84,700.00,5362.00,582.16,'2023-03-12 19:14:44'),(3995,'1','307',1,'Retail Sale Id 4032',0.00,2496.00,700.00,2800.00,304.00,'2023-03-13 07:22:48'),(3996,'1','307',1,'Retail Sale Id 4033',0.00,124800.00,658.00,131600.00,6800.00,'2023-03-13 07:32:10'),(3997,'1','307',1,'Retail Sale Id 4034',0.00,5616.00,700.00,6300.00,684.00,'2023-03-13 07:37:43'),(3998,'1','307',1,'Retail Sale Id 4035',0.00,3744.00,700.00,4200.00,456.00,'2023-03-13 07:38:57'),(3999,'1','307',1,'Retail Sale Id 4037',0.00,2676.96,700.00,3003.00,326.04,'2023-03-13 07:41:45'),(4000,'1','307',1,'Retail Sale Id 4038',0.00,3120.00,700.00,3500.00,380.00,'2023-03-13 07:51:31'),(4001,'1','307',1,'Retail Sale Id 4039',0.00,3744.00,700.00,4200.00,456.00,'2023-03-13 07:59:30'),(4002,'1','307',1,'Retail Sale Id 4040',0.00,1872.00,700.00,2100.00,228.00,'2023-03-13 08:00:42'),(4003,'1','307',1,'Retail Sale Id 4041',0.00,3744.00,700.00,4200.00,456.00,'2023-03-13 08:03:20'),(4004,'1','307',1,'Retail Sale Id 4042',0.00,3744.00,700.00,4200.00,456.00,'2023-03-13 08:15:21'),(4005,'1','307',1,'Retail Sale Id 4043',0.00,12480.00,700.00,14000.00,1520.00,'2023-03-13 08:17:05'),(4006,'1','307',1,'Retail Sale Id 4044',0.00,1248.00,700.00,1400.00,152.00,'2023-03-13 08:27:01'),(4007,'1','307',1,'Retail Sale Id 4045',0.00,892.32,700.00,1001.00,108.68,'2023-03-13 08:50:07'),(4008,'1','307',1,'Retail Sale Id 4046',0.00,7800.00,700.00,8750.00,950.00,'2023-03-13 08:52:08'),(4009,'1','307',1,'Retail Sale Id 4047',0.00,1784.64,700.00,2002.00,217.36,'2023-03-13 08:59:55'),(4010,'1','307',1,'Retail Sale Id 4048',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-13 09:01:58'),(4011,'1','307',1,'Retail Sale Id 4049',0.00,1872.00,700.00,2100.00,228.00,'2023-03-13 09:14:00'),(4012,'1','307',1,'Retail Sale Id 4050',0.00,3744.00,700.00,4200.00,456.00,'2023-03-13 09:15:46'),(4013,'1','307',1,'Retail Sale Id 4051',0.00,124800.00,658.00,131600.00,6800.00,'2023-03-13 09:27:02'),(4014,'1','307',1,'Retail Sale Id 4052',0.00,3120.00,700.00,3500.00,380.00,'2023-03-13 09:31:22'),(4015,'1','307',1,'Retail Sale Id 4053',0.00,1872.00,700.00,2100.00,228.00,'2023-03-13 09:45:34'),(4016,'1','307',1,'Retail Sale Id 4054',0.00,2052.96,700.00,2303.00,250.04,'2023-03-13 10:03:32'),(4017,'1','307',1,'Retail Sale Id 4056',0.00,4992.00,700.00,5600.00,608.00,'2023-03-13 10:06:19'),(4018,'1','307',1,'Retail Sale Id 4057',0.00,2676.96,700.00,3003.00,326.04,'2023-03-13 10:09:52'),(4019,'1','307',1,'Retail Sale Id 4058',0.00,7800.00,700.00,8750.00,950.00,'2023-03-13 10:14:54'),(4020,'1','307',1,'Retail Sale Id 4059',0.00,3744.00,700.00,4200.00,456.00,'2023-03-13 10:18:17'),(4021,'1','307',1,'Retail Sale Id 4060',0.00,892.32,700.00,1001.00,108.68,'2023-03-13 10:25:50'),(4022,'1','307',1,'Retail Sale Id 4061',0.00,1872.00,700.00,2100.00,228.00,'2023-03-13 10:43:11'),(4023,'1','307',1,'Retail Sale Id 4062',0.00,62400.00,658.00,65800.00,3400.00,'2023-03-13 10:44:21'),(4024,'1','307',1,'Retail Sale Id 4063',0.00,3744.00,700.00,4200.00,456.00,'2023-03-13 10:48:46'),(4025,'1','307',1,'Retail Sale Id 4064',0.00,3744.00,700.00,4200.00,456.00,'2023-03-13 10:55:49'),(4026,'1','307',1,'Retail Sale Id 4065',0.00,2496.00,700.00,2800.00,304.00,'2023-03-13 11:41:21'),(4027,'1','307',1,'Retail Sale Id 4066',0.00,1248.00,700.00,1400.00,152.00,'2023-03-13 11:47:55'),(4028,'1','307',1,'Retail Sale Id 4067',0.00,3120.00,700.00,3500.00,380.00,'2023-03-13 11:50:05'),(4029,'1','307',1,'Retail Sale Id 4069',0.00,1248.00,700.00,1400.00,152.00,'2023-03-13 12:00:50'),(4030,'1','307',1,'Retail Sale Id 4070',0.00,7800.00,700.00,8750.00,950.00,'2023-03-13 12:12:12'),(4031,'1','307',1,'Retail Sale Id 4071',0.00,3120.00,700.00,3500.00,380.00,'2023-03-13 12:13:04'),(4032,'1','307',1,'Retail Sale Id 4072',0.00,39000.00,658.00,41125.00,2125.00,'2023-03-13 12:14:10'),(4033,'1','307',1,'Retail Sale Id 4073',0.00,3744.00,700.00,4200.00,456.00,'2023-03-13 12:45:39'),(4034,'1','307',1,'Retail Sale Id 4074',0.00,2496.00,700.00,2800.00,304.00,'2023-03-13 13:04:10'),(4035,'1','307',1,'Retail Sale Id 4075',0.00,892.32,700.00,1001.00,108.68,'2023-03-13 13:33:35'),(4036,'1','307',1,'Retail Sale Id 4076',0.00,1335.36,700.00,1498.00,162.64,'2023-03-13 13:50:31'),(4037,'1','307',1,'Retail Sale Id 4077',0.00,1872.00,700.00,2100.00,228.00,'2023-03-13 14:03:56'),(4038,'1','307',1,'Retail Sale Id 4078',0.00,3744.00,700.00,4200.00,456.00,'2023-03-13 14:48:53'),(4039,'1','307',1,'Retail Sale Id 4079',0.00,1248.00,700.00,1400.00,152.00,'2023-03-13 14:57:05'),(4040,'1','307',1,'Retail Sale Id 4080',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-13 14:58:11'),(4041,'1','307',1,'Retail Sale Id 4081',0.00,6240.00,700.00,7000.00,760.00,'2023-03-13 15:01:58'),(4042,'1','307',1,'Retail Sale Id 4082',0.00,1335.36,700.00,1498.00,162.64,'2023-03-13 15:21:40'),(4043,'1','307',1,'Retail Sale Id 4083',0.00,3120.00,700.00,3500.00,380.00,'2023-03-13 15:46:16'),(4044,'1','307',1,'Retail Sale Id 4084',0.00,7800.00,700.00,8750.00,950.00,'2023-03-13 15:47:25'),(4045,'1','307',1,'Retail Sale Id 4085',0.00,711.36,700.00,798.00,86.64,'2023-03-13 15:54:43'),(4046,'1','307',1,'Retail Sale Id 4086',0.00,1248.00,700.00,1400.00,152.00,'2023-03-13 16:12:37'),(4047,'1','307',1,'Retail Sale Id 4087',0.00,4992.00,700.00,5600.00,608.00,'2023-03-13 16:15:46'),(4048,'1','307',1,'Retail Sale Id 4088',0.00,1248.00,700.00,1400.00,152.00,'2023-03-13 16:16:50'),(4049,'1','307',1,'Retail Sale Id 4089',0.00,11587.68,700.00,12999.00,1411.32,'2023-03-13 18:10:35'),(4050,'1','307',1,'Retail Sale Id 4090',0.00,11587.68,700.00,12999.00,1411.32,'2023-03-13 18:11:27'),(4051,'1','307',1,'Retail Sale Id 4091',0.00,11544.00,700.00,12950.00,1406.00,'2023-03-13 18:12:43'),(4052,'1','307',1,'Retail Sale Id 4092',0.00,5616.00,700.00,6300.00,684.00,'2023-03-13 18:28:38'),(4053,'1','307',1,'Retail Sale Id 4093',0.00,27144.00,658.00,28623.00,1479.00,'2023-03-13 18:29:59'),(4054,'1','307',1,'Retail Sale Id 4094',0.00,3744.00,658.00,3948.00,204.00,'2023-03-13 18:48:01'),(4055,'1','307',1,'Retail Sale Id 4095',0.00,8112.00,700.00,9100.00,988.00,'2023-03-13 18:49:32'),(4056,'1','307',1,'Retail Sale Id 4097',0.00,11924.64,700.00,13377.00,1452.36,'2023-03-13 19:15:54'),(4057,'1','307',1,'Retail Sale Id 4098',0.00,11924.64,700.00,13377.00,1452.36,'2023-03-13 19:17:49'),(4058,'1','307',1,'Retail Sale Id 4099',0.00,5616.00,700.00,6300.00,684.00,'2023-03-14 08:17:11'),(4059,'1','307',1,'Retail Sale Id 4101',0.00,6240.00,700.00,7000.00,760.00,'2023-03-14 08:38:32'),(4060,'1','307',1,'Retail Sale Id 4102',0.00,2496.00,700.00,2800.00,304.00,'2023-03-14 08:44:34'),(4061,'1','307',1,'Retail Sale Id 4103',0.00,4368.00,700.00,4900.00,532.00,'2023-03-14 09:04:14'),(4062,'1','307',1,'Retail Sale Id 4104',0.00,1872.00,700.00,2100.00,228.00,'2023-03-14 09:10:50'),(4063,'1','307',1,'Retail Sale Id 4105',0.00,892.32,700.00,1001.00,108.68,'2023-03-14 09:17:24'),(4064,'1','307',1,'Sale Id 7',0.00,3051.36,700.00,3423.00,371.64,'2023-03-14 09:42:53'),(4065,'1','307',1,'Retail Sale Id 4106',0.00,3744.00,700.00,4200.00,456.00,'2023-03-14 10:10:31'),(4066,'1','307',1,'Retail Sale Id 4107',0.00,1248.00,700.00,1400.00,152.00,'2023-03-14 10:11:58'),(4067,'1','307',1,'Retail Sale Id 4108',0.00,1872.00,700.00,2100.00,228.00,'2023-03-14 10:12:53'),(4068,'1','307',1,'Retail Sale Id 4109',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-14 10:14:46'),(4069,'1','307',1,'Retail Sale Id 4110',0.00,5528.64,700.00,6202.00,673.36,'2023-03-14 10:15:54'),(4070,'1','307',1,'Retail Sale Id 4111',0.00,3120.00,700.00,3500.00,380.00,'2023-03-14 10:22:19'),(4071,'1','307',1,'Retail Sale Id 4112',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-14 10:24:01'),(4072,'1','307',1,'Retail Sale Id 4113',0.00,14976.00,658.00,15792.00,816.00,'2023-03-14 10:27:21'),(4073,'1','307',1,'Retail Sale Id 4114',0.00,3744.00,700.00,4200.00,456.00,'2023-03-14 10:33:13'),(4074,'1','307',1,'Retail Sale Id 4115',0.00,3744.00,700.00,4200.00,456.00,'2023-03-14 10:51:28'),(4075,'1','307',1,'Retail Sale Id 4116',0.00,7800.00,700.00,8750.00,950.00,'2023-03-14 10:58:02'),(4076,'1','307',1,'Retail Sale Id 4117',0.00,2227.68,700.00,2499.00,271.32,'2023-03-14 11:17:40'),(4077,'1','307',1,'Retail Sale Id 4118',0.00,3744.00,700.00,4200.00,456.00,'2023-03-14 11:25:46'),(4078,'1','307',1,'Retail Sale Id 4119',0.00,7800.00,700.00,8750.00,950.00,'2023-03-14 11:55:48'),(4079,'1','307',1,'Retail Sale Id 4120',0.00,5528.64,700.00,6202.00,673.36,'2023-03-14 12:05:04'),(4080,'1','307',1,'Retail Sale Id 4121',0.00,1872.00,700.00,2100.00,228.00,'2023-03-14 12:28:59'),(4081,'1','307',1,'Retail Sale Id 4122',0.00,1872.00,700.00,2100.00,228.00,'2023-03-14 12:55:50'),(4082,'1','307',1,'Retail Sale Id 4123',0.00,62400.00,658.00,65800.00,3400.00,'2023-03-14 13:05:27'),(4083,'1','307',1,'Retail Sale Id 4124',0.00,2496.00,700.00,2800.00,304.00,'2023-03-14 13:25:16'),(4084,'1','307',1,'Retail Sale Id 4125',0.00,3744.00,700.00,4200.00,456.00,'2023-03-14 13:26:42'),(4085,'1','307',1,'Retail Sale Id 4126',0.00,1872.00,700.00,2100.00,228.00,'2023-03-14 13:33:19'),(4086,'1','307',1,'Retail Sale Id 4127',0.00,2496.00,700.00,2800.00,304.00,'2023-03-14 13:59:54'),(4087,'1','307',1,'Retail Sale Id 4128',0.00,6240.00,700.00,7000.00,760.00,'2023-03-14 14:01:11'),(4088,'1','307',1,'Retail Sale Id 4129',0.00,1872.00,700.00,2100.00,228.00,'2023-03-14 14:17:00'),(4089,'1','307',1,'Retail Sale Id 4130',0.00,1872.00,700.00,2100.00,228.00,'2023-03-14 14:31:38'),(4090,'1','307',1,'Retail Sale Id 4131',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-14 14:44:09'),(4091,'1','307',1,'Retail Sale Id 4132',0.00,1872.00,700.00,2100.00,228.00,'2023-03-14 14:52:46'),(4092,'1','307',1,'Retail Sale Id 4133',0.00,3744.00,700.00,4200.00,456.00,'2023-03-14 14:54:01'),(4093,'1','307',1,'Retail Sale Id 4134',0.00,15999.36,700.00,17948.00,1948.64,'2023-03-14 15:30:34'),(4094,'1','307',1,'Retail Sale Id 4135',0.00,5347.68,700.00,5999.00,651.32,'2023-03-14 15:44:50'),(4095,'1','307',1,'Retail Sale Id 4136',0.00,7044.96,700.00,7903.00,858.04,'2023-03-14 15:45:41'),(4096,'1','307',1,'Retail Sale Id 4137',0.00,4455.36,700.00,4998.00,542.64,'2023-03-14 16:17:00'),(4097,'1','307',1,'Retail Sale Id 4138',0.00,13640.64,700.00,15302.00,1661.36,'2023-03-14 18:14:41'),(4098,'1','307',1,'Retail Sale Id 4139',0.00,13728.00,700.00,15400.00,1672.00,'2023-03-14 18:15:24'),(4099,'1','307',1,'Retail Sale Id 4140',0.00,13728.00,700.00,15400.00,1672.00,'2023-03-14 18:16:11'),(4100,'1','307',1,'Retail Sale Id 4141',0.00,3744.00,700.00,4200.00,456.00,'2023-03-14 18:18:27'),(4101,'1','307',1,'Retail Sale Id 4142',0.00,3744.00,700.00,4200.00,456.00,'2023-03-14 18:19:22'),(4102,'1','307',1,'Retail Sale Id 4143',0.00,2676.96,700.00,3003.00,326.04,'2023-03-14 18:21:20'),(4103,'1','307',1,'Retail Sale Id 4144',0.00,6240.00,700.00,7000.00,760.00,'2023-03-14 18:22:15'),(4104,'1','307',1,'Retail Sale Id 4145',0.00,8511.36,700.00,9548.00,1036.64,'2023-03-14 18:39:22'),(4105,'1','307',1,'Retail Sale Id 4146',0.00,9984.00,700.00,11200.00,1216.00,'2023-03-14 19:08:26'),(4106,'1','307',1,'Retail Sale Id 4147',0.00,9984.00,700.00,11200.00,1216.00,'2023-03-14 19:09:10'),(4107,'1','307',1,'Retail Sale Id 4148',0.00,10071.36,700.00,11298.00,1226.64,'2023-03-14 19:09:58'),(4108,'1','307',1,'Return of Retail Sale Id 4139',13728.00,0.00,700.00,-15400.00,-1672.00,'2023-03-14 19:45:33'),(4109,'1','307',1,'Return of Retail Sale Id 4146',9984.00,0.00,700.00,-11200.00,-1216.00,'2023-03-14 19:47:31'),(4110,'1','307',1,'Retail Sale Id 4149',0.00,624.00,20100.00,20100.00,19476.00,'2023-03-14 19:49:01'),(4111,'1','307',1,'Return of Retail Sale Id 4134',15999.36,0.00,700.00,-17948.00,-1948.64,'2023-03-14 19:55:32'),(4112,'1','307',1,'Retail Sale Id 4150',0.00,2676.96,700.00,3003.00,326.04,'2023-03-15 07:21:38'),(4113,'1','307',1,'Retail Sale Id 4151',0.00,6240.00,700.00,7000.00,760.00,'2023-03-15 07:29:08'),(4114,'1','307',1,'Retail Sale Id 4152',0.00,3744.00,700.00,4200.00,456.00,'2023-03-15 07:31:02'),(4115,'1','307',1,'Retail Sale Id 4153',0.00,3744.00,700.00,4200.00,456.00,'2023-03-15 07:36:07'),(4116,'1','307',1,'Retail Sale Id 4154',0.00,1335.36,700.00,1498.00,162.64,'2023-03-15 07:41:47'),(4117,'1','307',1,'Retail Sale Id 4155',0.00,1872.00,700.00,2100.00,228.00,'2023-03-15 07:43:39'),(4118,'1','307',1,'Retail Sale Id 4156',0.00,7800.00,700.00,8750.00,950.00,'2023-03-15 07:45:52'),(4119,'1','307',1,'Retail Sale Id 4157',0.00,3744.00,700.00,4200.00,456.00,'2023-03-15 08:09:18'),(4120,'1','307',1,'Retail Sale Id 4158',0.00,3120.00,700.00,3500.00,380.00,'2023-03-15 08:14:43'),(4121,'1','307',1,'Retail Sale Id 4159',0.00,3563.04,700.00,3997.00,433.96,'2023-03-15 08:15:36'),(4122,'1','307',1,'Retail Sale Id 4160',0.00,7800.00,700.00,8750.00,950.00,'2023-03-15 08:18:10'),(4123,'1','307',1,'Retail Sale Id 4161',0.00,443.04,700.00,497.00,53.96,'2023-03-15 08:21:47'),(4124,'1','307',1,'Retail Sale Id 4162',0.00,2227.68,700.00,2499.00,271.32,'2023-03-15 08:23:11'),(4125,'1','307',1,'Retail Sale Id 4163',0.00,3744.00,700.00,4200.00,456.00,'2023-03-15 08:24:29'),(4126,'1','307',1,'Retail Sale Id 4164',0.00,1335.36,700.00,1498.00,162.64,'2023-03-15 08:25:36'),(4127,'1','307',1,'Retail Sale Id 4165',0.00,1335.36,700.00,1498.00,162.64,'2023-03-15 08:26:27'),(4128,'1','307',1,'Retail Sale Id 4166',0.00,3744.00,700.00,4200.00,456.00,'2023-03-15 08:29:19'),(4129,'1','307',1,'Return of Retail Sale Id 4164',1335.36,0.00,700.00,-1498.00,-162.64,'2023-03-15 08:31:04'),(4130,'1','307',1,'Retail Sale Id 4167',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-15 08:35:43'),(4131,'1','307',1,'Retail Sale Id 4168',0.00,2496.00,700.00,2800.00,304.00,'2023-03-15 08:49:06'),(4132,'1','307',1,'Retail Sale Id 4169',0.00,2496.00,700.00,2800.00,304.00,'2023-03-15 08:56:39'),(4133,'1','307',1,'Retail Sale Id 4170',0.00,3120.00,700.00,3500.00,380.00,'2023-03-15 09:10:51'),(4134,'1','307',1,'Retail Sale Id 4172',0.00,1248.00,700.00,1400.00,152.00,'2023-03-15 09:24:26'),(4135,'1','307',1,'Retail Sale Id 4173',0.00,11544.00,700.00,12950.00,1406.00,'2023-03-15 09:34:28'),(4136,'1','307',1,'Retail Sale Id 4174',0.00,892.32,700.00,1001.00,108.68,'2023-03-15 09:37:04'),(4137,'1','307',1,'Retail Sale Id 4175',0.00,1872.00,700.00,2100.00,228.00,'2023-03-15 09:39:27'),(4138,'1','307',1,'Retail Sale Id 4176',0.00,3120.00,700.00,3500.00,380.00,'2023-03-15 09:48:00'),(4139,'1','307',1,'Retail Sale Id 4177',0.00,3744.00,700.00,4200.00,456.00,'2023-03-15 09:54:21'),(4140,'1','307',1,'Retail Sale Id 4178',0.00,3120.00,700.00,3500.00,380.00,'2023-03-15 10:10:44'),(4141,'1','307',1,'Retail Sale Id 4179',0.00,1872.00,700.00,2100.00,228.00,'2023-03-15 10:21:34'),(4142,'1','307',1,'Retail Sale Id 4181',0.00,1248.00,700.00,1400.00,152.00,'2023-03-15 10:26:19'),(4143,'1','307',1,'Retail Sale Id 4183',0.00,3744.00,700.00,4200.00,456.00,'2023-03-15 10:54:40'),(4144,'1','307',1,'Retail Sale Id 4184',0.00,2496.00,700.00,2800.00,304.00,'2023-03-15 11:15:09'),(4145,'1','307',1,'Retail Sale Id 4185',0.00,1872.00,700.00,2100.00,228.00,'2023-03-15 11:17:12'),(4146,'1','307',1,'Retail Sale Id 4186',0.00,624.00,700.00,700.00,76.00,'2023-03-15 11:18:41'),(4147,'1','307',1,'Retail Sale Id 4187',0.00,1872.00,700.00,2100.00,228.00,'2023-03-15 11:19:59'),(4148,'1','307',1,'Retail Sale Id 4188',0.00,7800.00,700.00,8750.00,950.00,'2023-03-15 11:29:46'),(4149,'1','307',1,'Retail Sale Id 4189',0.00,7800.00,700.00,8750.00,950.00,'2023-03-15 11:31:50'),(4150,'1','307',1,'Retail Sale Id 4190',0.00,892.32,700.00,1001.00,108.68,'2023-03-15 12:00:32'),(4151,'1','307',1,'Retail Sale Id 4191',0.00,7800.00,700.00,8750.00,950.00,'2023-03-15 12:07:23'),(4152,'1','307',1,'Retail Sale Id 4192',0.00,3120.00,700.00,3500.00,380.00,'2023-03-15 12:17:51'),(4153,'1','307',1,'Retail Sale Id 4193',0.00,892.32,700.00,1001.00,108.68,'2023-03-15 12:26:13'),(4154,'1','307',1,'Retail Sale Id 4194',0.00,39000.00,658.00,41125.00,2125.00,'2023-03-15 12:35:24'),(4155,'1','307',1,'Retail Sale Id 4195',0.00,3744.00,700.00,4200.00,456.00,'2023-03-15 12:44:02'),(4156,'1','307',1,'Retail Sale Id 4196',0.00,1248.00,700.00,1400.00,152.00,'2023-03-15 13:23:58'),(4157,'1','307',1,'Retail Sale Id 4197',0.00,3744.00,700.00,4200.00,456.00,'2023-03-15 13:27:15'),(4158,'1','307',1,'Retail Sale Id 4198',0.00,7800.00,700.00,8750.00,950.00,'2023-03-15 13:29:43'),(4159,'1','307',1,'Retail Sale Id 4199',0.00,1248.00,700.00,1400.00,152.00,'2023-03-15 13:35:21'),(4160,'1','307',1,'Retail Sale Id 4200',0.00,3120.00,700.00,3500.00,380.00,'2023-03-15 13:51:10'),(4161,'1','307',1,'Retail Sale Id 4201',0.00,5796.96,700.00,6503.00,706.04,'2023-03-15 13:52:37'),(4162,'1','307',1,'Retail Sale Id 4202',0.00,1248.00,700.00,1400.00,152.00,'2023-03-15 14:05:55'),(4163,'1','307',1,'Retail Sale Id 4203',0.00,8555.04,700.00,9597.00,1041.96,'2023-03-15 14:29:21'),(4164,'1','307',1,'Retail Sale Id 4204',0.00,1872.00,700.00,2100.00,228.00,'2023-03-15 14:55:02'),(4165,'1','307',1,'Retail Sale Id 4205',0.00,7800.00,700.00,8750.00,950.00,'2023-03-15 15:04:38'),(4166,'1','307',1,'Retail Sale Id 4206',0.00,9360.00,700.00,10500.00,1140.00,'2023-03-15 16:19:36'),(4167,'1','307',1,'Retail Sale Id 4207',0.00,2496.00,700.00,2800.00,304.00,'2023-03-15 18:42:10'),(4168,'1','307',1,'Retail Sale Id 4208',0.00,3120.00,700.00,3500.00,380.00,'2023-03-15 18:43:28'),(4169,'1','307',1,'Retail Sale Id 4209',0.00,10252.32,700.00,11501.00,1248.68,'2023-03-15 18:46:12'),(4170,'1','307',1,'Retail Sale Id 4210',0.00,137548.32,658.00,145042.94,7494.62,'2023-03-15 18:51:36'),(4171,'1','307',1,'Retail Sale Id 4211',0.00,62400.00,658.00,65800.00,3400.00,'2023-03-15 18:52:27'),(4172,'1','307',1,'Retail Sale Id 4212',0.00,7488.00,700.00,8400.00,912.00,'2023-03-15 19:07:22'),(4173,'1','307',1,'Retail Sale Id 4213',0.00,4992.00,700.00,5600.00,608.00,'2023-03-15 19:08:31'),(4174,'1','307',1,'Retail Sale Id 4214',0.00,3744.00,700.00,4200.00,456.00,'2023-03-15 19:09:29'),(4175,'1','307',1,'Retail Sale Id 4215',0.00,7762.56,700.00,8708.00,945.44,'2023-03-15 19:13:47'),(4176,'1','307',1,'Retail Sale Id 4216',0.00,6864.00,700.00,7700.00,836.00,'2023-03-15 19:30:06'),(4177,'1','307',1,'Retail Sale Id 4218',0.00,7800.00,700.00,8750.00,950.00,'2023-03-15 19:32:24'),(4178,'1','307',1,'Retail Sale Id 4219',0.00,3744.00,700.00,4200.00,456.00,'2023-03-15 19:36:14'),(4179,'1','307',1,'Retail Sale Id 4220',0.00,62400.00,658.00,65800.00,3400.00,'2023-03-16 07:23:47'),(4180,'1','307',1,'Retail Sale Id 4221',0.00,7800.00,700.00,8750.00,950.00,'2023-03-16 07:27:45'),(4181,'1','307',1,'Retail Sale Id 4222',0.00,3744.00,700.00,4200.00,456.00,'2023-03-16 08:00:14'),(4182,'1','307',1,'Retail Sale Id 4223',0.00,42120.00,658.00,44415.00,2295.00,'2023-03-16 08:18:54'),(4183,'1','307',1,'Retail Sale Id 4224',0.00,1872.00,700.00,2100.00,228.00,'2023-03-16 08:20:06'),(4184,'1','307',1,'Retail Sale Id 4225',0.00,1872.00,700.00,2100.00,228.00,'2023-03-16 08:21:06'),(4185,'1','307',1,'Retail Sale Id 4226',0.00,62400.00,658.00,65800.00,3400.00,'2023-03-16 08:32:24'),(4186,'1','307',1,'Retail Sale Id 4227',0.00,2496.00,700.00,2800.00,304.00,'2023-03-16 08:35:45'),(4187,'1','307',1,'Retail Sale Id 4228',0.00,3744.00,700.00,4200.00,456.00,'2023-03-16 08:37:41'),(4188,'1','307',1,'Retail Sale Id 4229',0.00,6240.00,700.00,7000.00,760.00,'2023-03-16 08:44:19'),(4189,'1','307',1,'Retail Sale Id 4230',0.00,1248.00,700.00,1400.00,152.00,'2023-03-16 08:47:44'),(4190,'1','307',1,'Retail Sale Id 4231',0.00,3744.00,700.00,4200.00,456.00,'2023-03-16 08:55:42'),(4191,'1','307',1,'Retail Sale Id 4232',0.00,1248.00,700.00,1400.00,152.00,'2023-03-16 09:13:13'),(4192,'1','307',1,'Retail Sale Id 4233',0.00,7800.00,700.00,8750.00,950.00,'2023-03-16 09:14:51'),(4193,'1','307',1,'Retail Sale Id 4234',0.00,2676.96,700.00,3003.00,326.04,'2023-03-16 09:25:34'),(4194,'1','307',1,'Retail Sale Id 4235',0.00,3744.00,700.00,4200.00,456.00,'2023-03-16 09:28:25'),(4195,'1','307',1,'Retail Sale Id 4236',0.00,1872.00,700.00,2100.00,228.00,'2023-03-16 09:31:17'),(4196,'1','307',1,'Retail Sale Id 4237',0.00,1872.00,700.00,2100.00,228.00,'2023-03-16 09:38:06'),(4197,'1','307',1,'Retail Sale Id 4238',0.00,34320.00,658.00,36190.00,1870.00,'2023-03-16 09:51:43'),(4198,'1','307',1,'Retail Sale Id 4239',0.00,1248.00,700.00,1400.00,152.00,'2023-03-16 09:58:04'),(4199,'1','307',1,'Retail Sale Id 4240',0.00,11232.00,700.00,12600.00,1368.00,'2023-03-16 10:49:16'),(4200,'1','307',1,'Retail Sale Id 4241',0.00,1872.00,700.00,2100.00,228.00,'2023-03-16 10:58:58'),(4201,'1','307',1,'Retail Sale Id 4242',0.00,1872.00,700.00,2100.00,228.00,'2023-03-16 11:08:08'),(4202,'1','307',1,'Retail Sale Id 4243',0.00,1248.00,700.00,1400.00,152.00,'2023-03-16 11:20:40'),(4203,'1','307',1,'Retail Sale Id 4244',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-16 11:25:52'),(4204,'1','307',1,'Retail Sale Id 4245',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-16 11:28:55'),(4205,'1','307',1,'Retail Sale Id 4246',0.00,2496.00,700.00,2800.00,304.00,'2023-03-16 12:29:12'),(4206,'1','307',1,'Retail Sale Id 4247',0.00,3744.00,700.00,4200.00,456.00,'2023-03-16 12:55:59'),(4207,'1','307',1,'Retail Sale Id 4248',0.00,1784.64,700.00,2002.00,217.36,'2023-03-16 13:04:04'),(4208,'1','307',1,'Retail Sale Id 4249',0.00,1248.00,700.00,1400.00,152.00,'2023-03-16 13:23:26'),(4209,'1','307',1,'Retail Sale Id 4250',0.00,6240.00,700.00,7000.00,760.00,'2023-03-16 13:31:26'),(4210,'1','307',1,'Retail Sale Id 4251',0.00,3120.00,700.00,3500.00,380.00,'2023-03-16 13:34:51'),(4211,'1','307',1,'Retail Sale Id 4252',0.00,4904.64,700.00,5502.00,597.36,'2023-03-16 13:36:39'),(4212,'1','307',1,'Retail Sale Id 4253',0.00,46800.00,658.00,49350.00,2550.00,'2023-03-16 14:08:01'),(4213,'1','307',1,'Retail Sale Id 4254',0.00,1872.00,700.00,2100.00,228.00,'2023-03-16 15:58:01'),(4214,'1','307',1,'Retail Sale Id 4255',0.00,1872.00,700.00,2100.00,228.00,'2023-03-16 16:12:27'),(4215,'1','307',1,'Retail Sale Id 4256',0.00,7132.32,700.00,8001.00,868.68,'2023-03-16 16:15:10'),(4216,'1','307',1,'Retail Sale Id 4257',0.00,7132.32,700.00,8001.00,868.68,'2023-03-16 16:16:51'),(4217,'1','307',1,'Retail Sale Id 4259',0.00,7132.32,700.00,8001.00,868.68,'2023-03-16 16:19:43'),(4218,'1','307',1,'Retail Sale Id 4260',0.00,3432.00,700.00,3850.00,418.00,'2023-03-16 16:44:52'),(4219,'1','307',1,'Retail Sale Id 4261',0.00,6240.00,700.00,7000.00,760.00,'2023-03-16 16:50:26'),(4220,'1','307',1,'Retail Sale Id 4262',0.00,1335.36,700.00,1498.00,162.64,'2023-03-16 17:29:09'),(4221,'1','307',1,'Retail Sale Id 4263',0.00,8648.64,700.00,9702.00,1053.36,'2023-03-16 17:30:41'),(4222,'1','307',1,'Retail Sale Id 4264',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-16 17:40:11'),(4223,'1','307',1,'Retail Sale Id 4265',0.00,3744.00,700.00,4200.00,456.00,'2023-03-16 17:43:02'),(4224,'1','307',1,'Retail Sale Id 4266',0.00,5616.00,700.00,6300.00,684.00,'2023-03-16 17:54:58'),(4225,'1','307',1,'Retail Sale Id 4267',0.00,3120.00,700.00,3500.00,380.00,'2023-03-16 18:36:57'),(4226,'1','307',1,'Retail Sale Id 4268',0.00,12480.00,700.00,14000.00,1520.00,'2023-03-16 18:39:42'),(4227,'1','307',1,'Retail Sale Id 4269',0.00,4368.00,700.00,4900.00,532.00,'2023-03-16 18:47:48'),(4228,'1','307',1,'Retail Sale Id 4270',0.00,7800.00,700.00,8750.00,950.00,'2023-03-16 18:50:56'),(4229,'1','307',1,'Retail Sale Id 4271',0.00,14664.00,700.00,16450.00,1786.00,'2023-03-16 19:19:08'),(4230,'1','307',1,'Retail Sale Id 4272',0.00,22857.12,700.00,25641.00,2783.88,'2023-03-16 19:26:58'),(4231,'1','307',1,'Retail Sale Id 4273',0.00,1872.00,700.00,2100.00,228.00,'2023-03-17 07:17:03'),(4232,'1','307',1,'Retail Sale Id 4274',0.00,7800.00,700.00,8750.00,950.00,'2023-03-17 07:48:09'),(4233,'1','307',1,'Retail Sale Id 4275',0.00,1872.00,700.00,2100.00,228.00,'2023-03-17 07:52:15'),(4234,'1','307',1,'Retail Sale Id 4276',0.00,3744.00,700.00,4200.00,456.00,'2023-03-17 07:54:42'),(4235,'1','307',1,'Retail Sale Id 4277',0.00,1872.00,700.00,2100.00,228.00,'2023-03-17 07:58:20'),(4236,'1','307',1,'Retail Sale Id 4278',0.00,5172.96,700.00,5803.00,630.04,'2023-03-17 08:01:22'),(4237,'1','307',1,'Retail Sale Id 4279',0.00,3120.00,700.00,3500.00,380.00,'2023-03-17 08:07:42'),(4238,'1','307',1,'Retail Sale Id 4280',0.00,3744.00,700.00,4200.00,456.00,'2023-03-17 08:14:18'),(4239,'1','307',1,'Retail Sale Id 4281',0.00,3744.00,700.00,4200.00,456.00,'2023-03-17 08:15:26'),(4240,'1','307',1,'Retail Sale Id 4282',0.00,6240.00,700.00,7000.00,760.00,'2023-03-17 08:20:16'),(4241,'1','307',1,'Retail Sale Id 4283',0.00,7800.00,700.00,8750.00,950.00,'2023-03-17 08:26:42'),(4242,'1','307',1,'Retail Sale Id 4284',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-17 08:29:43'),(4243,'1','307',1,'Retail Sale Id 4285',0.00,1872.00,700.00,2100.00,228.00,'2023-03-17 08:36:49'),(4244,'1','307',1,'Retail Sale Id 4286',0.00,7800.00,700.00,8750.00,950.00,'2023-03-17 08:38:44'),(4245,'1','307',1,'Retail Sale Id 4287',0.00,3744.00,700.00,4200.00,456.00,'2023-03-17 08:43:46'),(4246,'1','307',1,'Retail Sale Id 4288',0.00,3744.00,700.00,4200.00,456.00,'2023-03-17 08:48:07'),(4247,'1','307',1,'Retail Sale Id 4289',0.00,3120.00,700.00,3500.00,380.00,'2023-03-17 08:49:15'),(4248,'1','307',1,'Retail Sale Id 4291',0.00,1872.00,700.00,2100.00,228.00,'2023-03-17 08:59:26'),(4249,'1','307',1,'Retail Sale Id 4292',0.00,2496.00,700.00,2800.00,304.00,'2023-03-17 09:06:05'),(4250,'1','307',1,'Retail Sale Id 4293',0.00,2496.00,700.00,2800.00,304.00,'2023-03-17 09:09:15'),(4251,'1','307',1,'Retail Sale Id 4294',0.00,3744.00,700.00,4200.00,456.00,'2023-03-17 09:15:09'),(4252,'1','307',1,'Retail Sale Id 4295',0.00,1872.00,700.00,2100.00,228.00,'2023-03-17 09:16:39'),(4253,'1','307',1,'Retail Sale Id 4296',0.00,1784.64,700.00,2002.00,217.36,'2023-03-17 09:28:58'),(4254,'1','307',1,'Retail Sale Id 4297',0.00,1872.00,700.00,2100.00,228.00,'2023-03-17 09:48:48'),(4255,'1','307',1,'Retail Sale Id 4299',0.00,10920.00,700.00,12250.00,1330.00,'2023-03-17 10:24:15'),(4256,'1','307',1,'Retail Sale Id 4300',0.00,3744.00,700.00,4200.00,456.00,'2023-03-17 10:40:00'),(4257,'1','307',1,'Retail Sale Id 4301',0.00,2496.00,700.00,2800.00,304.00,'2023-03-17 11:00:41'),(4258,'1','307',1,'Retail Sale Id 4302',0.00,1872.00,700.00,2100.00,228.00,'2023-03-17 11:01:28'),(4259,'1','307',1,'Retail Sale Id 4303',0.00,1248.00,700.00,1400.00,152.00,'2023-03-17 11:04:42'),(4260,'1','307',1,'Retail Sale Id 4304',0.00,1872.00,700.00,2100.00,228.00,'2023-03-17 11:11:29'),(4261,'1','307',1,'Retail Sale Id 4305',0.00,7488.00,700.00,8400.00,912.00,'2023-03-17 11:35:32'),(4262,'1','307',1,'Retail Sale Id 4306',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-17 11:40:25'),(4263,'1','307',1,'Retail Sale Id 4307',0.00,3120.00,700.00,3500.00,380.00,'2023-03-17 11:52:07'),(4264,'1','307',1,'Retail Sale Id 4308',0.00,1248.00,700.00,1400.00,152.00,'2023-03-17 11:52:57'),(4265,'1','307',1,'Retail Sale Id 4309',0.00,32760.00,658.00,34545.00,1785.00,'2023-03-17 12:21:26'),(4266,'1','307',1,'Retail Sale Id 4310',0.00,1784.64,700.00,2002.00,217.36,'2023-03-17 12:24:06'),(4267,'1','307',1,'Retail Sale Id 4311',0.00,12480.00,700.00,14000.00,1520.00,'2023-03-17 13:19:25'),(4268,'1','307',1,'Retail Sale Id 4312',0.00,1872.00,700.00,2100.00,228.00,'2023-03-17 13:54:44'),(4269,'1','307',1,'Retail Sale Id 4313',0.00,3744.00,700.00,4200.00,456.00,'2023-03-17 13:55:40'),(4270,'1','307',1,'Retail Sale Id 4314',0.00,1248.00,700.00,1400.00,152.00,'2023-03-17 14:09:26'),(4271,'1','307',1,'Retail Sale Id 4315',0.00,1248.00,700.00,1400.00,152.00,'2023-03-17 14:10:13'),(4272,'1','307',1,'Retail Sale Id 4316',0.00,1872.00,700.00,2100.00,228.00,'2023-03-17 14:25:33'),(4273,'1','307',1,'Retail Sale Id 4317',0.00,2227.68,700.00,2499.00,271.32,'2023-03-17 14:28:01'),(4274,'1','307',1,'Retail Sale Id 4318',0.00,10296.00,700.00,11550.00,1254.00,'2023-03-17 14:29:16'),(4275,'1','307',1,'Retail Sale Id 4319',0.00,3120.00,700.00,3500.00,380.00,'2023-03-17 14:31:33'),(4276,'1','307',1,'Retail Sale Id 4320',0.00,2227.68,700.00,2499.00,271.32,'2023-03-17 14:37:59'),(4277,'1','307',1,'Retail Sale Id 4321',0.00,1872.00,700.00,2100.00,228.00,'2023-03-17 14:45:49'),(4278,'1','307',1,'Retail Sale Id 4322',0.00,3744.00,700.00,4200.00,456.00,'2023-03-17 15:02:03'),(4279,'1','307',1,'Retail Sale Id 4323',0.00,2496.00,700.00,2800.00,304.00,'2023-03-17 15:08:08'),(4280,'1','307',1,'Retail Sale Id 4324',0.00,7800.00,700.00,8750.00,950.00,'2023-03-17 15:22:00'),(4281,'1','307',1,'Retail Sale Id 4325',0.00,1872.00,700.00,2100.00,228.00,'2023-03-17 15:25:57'),(4282,'1','307',1,'Retail Sale Id 4326',0.00,6240.00,700.00,7000.00,760.00,'2023-03-17 15:33:31'),(4283,'1','307',1,'Retail Sale Id 4327',0.00,62400.00,658.00,65800.00,3400.00,'2023-03-17 15:41:24'),(4284,'1','307',1,'Retail Sale Id 4328',0.00,3744.00,700.00,4200.00,456.00,'2023-03-17 16:15:34'),(4285,'1','307',1,'Retail Sale Id 4329',0.00,1335.36,700.00,1498.00,162.64,'2023-03-17 16:17:48'),(4286,'1','307',1,'Retail Sale Id 4330',0.00,7668.96,700.00,8603.00,934.04,'2023-03-17 17:11:23'),(4287,'1','307',1,'Retail Sale Id 4331',0.00,31200.00,658.00,32900.00,1700.00,'2023-03-17 17:12:47'),(4288,'1','307',1,'Retail Sale Id 4332',0.00,3744.00,700.00,4200.00,456.00,'2023-03-17 17:20:57'),(4289,'1','307',1,'Retail Sale Id 4333',0.00,1784.64,700.00,2002.00,217.36,'2023-03-17 17:27:26'),(4290,'1','307',1,'Retail Sale Id 4334',0.00,4992.00,700.00,5600.00,608.00,'2023-03-17 17:28:25'),(4291,'1','307',1,'Retail Sale Id 4335',0.00,15780.96,700.00,17703.00,1922.04,'2023-03-17 17:52:25'),(4292,'1','307',1,'Retail Sale Id 4336',0.00,16311.36,700.00,18298.00,1986.64,'2023-03-17 18:14:24'),(4293,'1','307',1,'Retail Sale Id 4337',0.00,2496.00,700.00,2800.00,304.00,'2023-03-17 18:15:17'),(4294,'1','307',1,'Retail Sale Id 4338',0.00,9091.68,700.00,10199.00,1107.32,'2023-03-17 18:33:52'),(4295,'1','307',1,'Retail Sale Id 4339',0.00,11544.00,700.00,12950.00,1406.00,'2023-03-17 18:34:47'),(4296,'1','307',1,'Retail Sale Id 4340',0.00,8274.24,700.00,9282.00,1007.76,'2023-03-17 19:10:18'),(4297,'1','307',1,'Retail Sale Id 4341',0.00,1872.00,700.00,2100.00,228.00,'2023-03-19 08:06:13'),(4298,'1','307',1,'Retail Sale Id 4342',0.00,7800.00,700.00,8750.00,950.00,'2023-03-19 08:08:04'),(4299,'1','307',1,'Retail Sale Id 4343',0.00,3744.00,700.00,4200.00,456.00,'2023-03-19 08:11:10'),(4300,'1','307',1,'Retail Sale Id 4344',0.00,1248.00,700.00,1400.00,152.00,'2023-03-19 08:26:18'),(4301,'1','307',1,'Retail Sale Id 4345',0.00,2676.96,700.00,3003.00,326.04,'2023-03-19 08:29:05'),(4302,'1','307',1,'Retail Sale Id 4346',0.00,3744.00,700.00,4200.00,456.00,'2023-03-19 08:31:28'),(4303,'1','307',1,'Retail Sale Id 4347',0.00,4455.36,700.00,4998.00,542.64,'2023-03-19 08:43:42'),(4304,'1','307',1,'Retail Sale Id 4348',0.00,3120.00,700.00,3500.00,380.00,'2023-03-19 08:51:12'),(4305,'1','307',1,'Retail Sale Id 4349',0.00,2676.96,700.00,3003.00,326.04,'2023-03-19 08:52:25'),(4306,'1','307',1,'Retail Sale Id 4350',0.00,2496.00,700.00,2800.00,304.00,'2023-03-19 08:55:06'),(4307,'1','307',1,'Retail Sale Id 4351',0.00,3744.00,700.00,4200.00,456.00,'2023-03-19 09:08:24'),(4308,'1','307',1,'Retail Sale Id 4352',0.00,3744.00,700.00,4200.00,456.00,'2023-03-19 09:09:21'),(4309,'1','307',1,'Retail Sale Id 4353',0.00,1335.36,700.00,1498.00,162.64,'2023-03-19 09:12:48'),(4310,'1','307',1,'Retail Sale Id 4354',0.00,1784.64,700.00,2002.00,217.36,'2023-03-19 09:30:25'),(4311,'1','307',1,'Retail Sale Id 4355',0.00,3744.00,700.00,4200.00,456.00,'2023-03-19 09:35:35'),(4312,'1','307',1,'Retail Sale Id 4356',0.00,1603.68,700.00,1799.00,195.32,'2023-03-19 09:39:17'),(4313,'1','307',1,'Retail Sale Id 4357',0.00,1872.00,700.00,2100.00,228.00,'2023-03-19 10:00:09'),(4314,'1','307',1,'Retail Sale Id 4358',0.00,1248.00,700.00,1400.00,152.00,'2023-03-19 10:06:23'),(4315,'1','307',1,'Retail Sale Id 4359',0.00,3120.00,700.00,3500.00,380.00,'2023-03-19 10:13:27'),(4316,'1','307',1,'Retail Sale Id 4360',0.00,1872.00,700.00,2100.00,228.00,'2023-03-19 10:16:45'),(4317,'1','307',1,'Retail Sale Id 4361',0.00,1784.64,700.00,2002.00,217.36,'2023-03-19 10:22:05'),(4318,'1','307',1,'Retail Sale Id 4362',0.00,3744.00,700.00,4200.00,456.00,'2023-03-19 10:25:40'),(4319,'1','307',1,'Retail Sale Id 4363',0.00,7800.00,700.00,8750.00,950.00,'2023-03-19 10:26:55'),(4320,'1','307',1,'Retail Sale Id 4364',0.00,3120.00,700.00,3500.00,380.00,'2023-03-19 10:35:55'),(4321,'1','307',1,'Retail Sale Id 4365',0.00,3563.04,700.00,3997.00,433.96,'2023-03-19 11:06:03'),(4322,'1','307',1,'Retail Sale Id 4366',0.00,3120.00,700.00,3500.00,380.00,'2023-03-19 11:17:44'),(4323,'1','307',1,'Retail Sale Id 4367',0.00,2676.96,700.00,3003.00,326.04,'2023-03-19 11:20:38'),(4324,'1','307',1,'Retail Sale Id 4368',0.00,1872.00,700.00,2100.00,228.00,'2023-03-19 11:34:45'),(4325,'1','307',1,'Retail Sale Id 4369',0.00,1248.00,700.00,1400.00,152.00,'2023-03-19 11:35:44'),(4326,'1','307',1,'Retail Sale Id 4370',0.00,3120.00,700.00,3500.00,380.00,'2023-03-19 11:37:36'),(4327,'1','307',1,'Retail Sale Id 4371',0.00,1248.00,700.00,1400.00,152.00,'2023-03-19 11:39:00'),(4328,'1','307',1,'Retail Sale Id 4372',0.00,3563.04,700.00,3997.00,433.96,'2023-03-19 11:42:05'),(4329,'1','307',1,'Retail Sale Id 4373',0.00,3744.00,700.00,4200.00,456.00,'2023-03-19 11:44:58'),(4330,'1','307',1,'Retail Sale Id 4374',0.00,2676.96,700.00,3003.00,326.04,'2023-03-19 11:46:47'),(4331,'1','307',1,'Retail Sale Id 4375',0.00,1872.00,700.00,2100.00,228.00,'2023-03-19 11:52:11'),(4332,'1','307',1,'Retail Sale Id 4376',0.00,1872.00,700.00,2100.00,228.00,'2023-03-19 11:53:46'),(4333,'1','307',1,'Retail Sale Id 4377',0.00,1335.36,700.00,1498.00,162.64,'2023-03-19 12:05:24'),(4334,'1','307',1,'Retail Sale Id 4378',0.00,3744.00,700.00,4200.00,456.00,'2023-03-19 13:20:30'),(4335,'1','307',1,'Retail Sale Id 4379',0.00,2496.00,700.00,2800.00,304.00,'2023-03-19 13:22:04'),(4336,'1','307',1,'Retail Sale Id 4380',0.00,443.04,700.00,497.00,53.96,'2023-03-19 13:27:55'),(4337,'1','307',1,'Retail Sale Id 4381',0.00,7800.00,700.00,8750.00,950.00,'2023-03-19 13:28:44'),(4338,'1','307',1,'Retail Sale Id 4382',0.00,7800.00,700.00,8750.00,950.00,'2023-03-19 13:30:09'),(4339,'1','307',1,'Retail Sale Id 4383',0.00,7800.00,700.00,8750.00,950.00,'2023-03-19 13:32:06'),(4340,'1','307',1,'Retail Sale Id 4384',0.00,2496.00,700.00,2800.00,304.00,'2023-03-19 13:36:53'),(4341,'1','307',1,'Retail Sale Id 4385',0.00,47960.64,700.00,53802.00,5841.36,'2023-03-19 13:42:59'),(4342,'1','307',1,'Retail Sale Id 4386',0.00,7800.00,700.00,8750.00,950.00,'2023-03-19 13:46:50'),(4343,'1','307',1,'Retail Sale Id 4387',0.00,1872.00,700.00,2100.00,228.00,'2023-03-19 13:49:43'),(4344,'1','307',1,'Retail Sale Id 4388',0.00,1335.36,700.00,1498.00,162.64,'2023-03-19 14:26:52'),(4345,'1','307',1,'Retail Sale Id 4389',0.00,11544.00,700.00,12950.00,1406.00,'2023-03-19 14:31:41'),(4346,'1','307',1,'Retail Sale Id 4390',0.00,624.00,700.00,700.00,76.00,'2023-03-19 14:33:27'),(4347,'1','307',1,'Retail Sale Id 4391',0.00,1248.00,700.00,1400.00,152.00,'2023-03-19 14:35:41'),(4348,'1','307',1,'Retail Sale Id 4392',0.00,1872.00,700.00,2100.00,228.00,'2023-03-19 14:43:07'),(4349,'1','307',1,'Retail Sale Id 4393',0.00,160910.88,700.00,180509.00,19598.12,'2023-03-19 14:44:37'),(4350,'1','307',1,'Retail Sale Id 4394',0.00,2496.00,700.00,2800.00,304.00,'2023-03-19 14:46:08'),(4351,'1','307',1,'Retail Sale Id 4395',0.00,7400.64,700.00,8302.00,901.36,'2023-03-19 15:01:07'),(4352,'1','307',1,'Retail Sale Id 4396',0.00,3744.00,700.00,4200.00,456.00,'2023-03-19 15:07:38'),(4353,'1','307',1,'Retail Sale Id 4397',0.00,3120.00,700.00,3500.00,380.00,'2023-03-19 15:28:00'),(4354,'1','307',1,'Retail Sale Id 4398',0.00,31200.00,650.00,32500.00,1300.00,'2023-03-19 16:13:29'),(4355,'1','307',1,'Retail Sale Id 4399',0.00,62400.00,650.00,65000.00,2600.00,'2023-03-19 16:14:3