-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_306
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_306`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_306` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_306`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,4000,'',0,'22','1','306','PURCHASES','','2022-12-22 01:38:25',5,0.00,0.00,'','479','2022-12-22 01:38:25','479',0,0),(2,7000,'',0,'20','1','306','SALES','','2022-12-22 01:38:39',5,0.00,0.00,'','479','2022-12-22 01:38:39','479',0,0),(3,500,'',0,'6.1','1','306','CASH','','2022-12-22 01:38:52',5,0.00,0.00,'','479','2022-12-22 01:38:52','479',0,0),(4,8000,'',0,'24','1','306','SALARIES & WAGES','','2022-12-22 01:39:09',5,0.00,0.00,'','479','2022-12-22 01:39:09','479',0,0),(5,8001,'',0,'24','1','306','PURCHASES','','2022-12-22 01:39:26',5,0.00,0.00,'','479','2022-12-22 01:39:26','479',0,0),(6,2500,'',0,'2','1','306','ZB(LPG)1014471475','','2022-12-22 01:41:11',5,0.00,0.00,'','479','2022-12-22 01:41:11','479',0,0),(7,2501,'',0,'2','1','306','ZNB E-BILL COLLECTION :1014717','','2022-12-22 01:41:26',5,0.00,0.00,'','479','2022-12-22 01:41:26','479',0,0),(8,2502,'',0,'2','1','306','ZNB-:POS 1015965368','','2022-12-22 01:41:44',5,0.00,0.00,'','479','2022-12-22 01:41:44','479',0,0),(9,2503,'',0,'2','1','306','FID POS COLLECTION-5620141491','','2022-12-22 01:41:59',5,0.00,0.00,'','479','2022-12-22 01:41:59','479',0,0),(10,2504,'',0,'2','1','306','FB(IBAL)2023855223','','2022-12-22 01:42:09',5,0.00,0.00,'','479','2022-12-22 01:42:09','479',0,0),(11,2505,'',0,'2','1','306','E-BILLS 1015372548','','2022-12-22 01:42:43',5,0.00,0.00,'','479','2022-12-22 01:42:43','479',0,0),(12,2506,'',0,'2','1','306','E-BILLS  IBAL 1015372548','','2022-12-22 01:42:53',5,0.00,0.00,'','479','2022-12-22 01:42:53','479',0,0),(13,2507,'',0,'2','1','306','UNITY BANK-0024061656','','2022-12-22 01:43:25',5,0.00,0.00,'','479','2022-12-22 01:43:25','479',0,0),(14,2508,'',0,'2','1','306','UBA-0039769388','','2022-12-22 01:43:36',5,0.00,0.00,'','479','2022-12-22 01:43:36','479',0,0),(15,2509,'',0,'2','1','306','UBA YOLA-1021398099','','2022-12-22 01:43:46',5,0.00,0.00,'','479','2022-12-22 01:43:46','479',0,0),(16,2510,'',0,'2','1','306','UBA-1019882661','','2022-12-22 01:43:56',5,0.00,0.00,'','479','2022-12-22 01:43:56','479',0,0),(17,2511,'',0,'2','1','306','DANKANO-EBILLS:ZNB1014717618','','2022-12-22 01:44:09',5,0.00,0.00,'','479','2022-12-22 01:44:09','479',0,0),(18,2512,'',0,'2','1','306','TAJJ BANK CITY GATE:0001875361','','2022-12-22 01:44:39',5,0.00,0.00,'','479','2022-12-22 01:44:39','479',0,0),(19,2513,'',0,'2','1','306','POLARIS BANK KEBBI:4091417377','','2022-12-22 01:44:53',5,0.00,0.00,'','479','2022-12-22 01:44:53','479',0,0),(20,2514,'',0,'2','1','306','ZNB POS COLL ACCT:-1015965368','ZNB POS COLLECTION ACCOUNT','2023-01-19 17:44:25',5,0.00,0.00,'','792','2023-01-19 17:44:25','792',0,0),(21,2515,'',0,'2','1','306','UBA LPG COLL ACCT:-1020811140','UBA LPG COLLECTION ACCOUNT','2023-01-19 17:44:55',5,0.00,0.00,'','792','2023-01-19 17:44:55','792',0,0),(22,2516,'',0,'2','1','306','ZNB AA RANO NIG LTD:-101471761','ZNB AA RANO NIG LTD','2023-01-19 17:45:23',5,0.00,0.00,'','792','2023-01-19 17:45:23','792',0,0),(23,2517,'',0,'2','1','306','FID POS COLL ACCT:-5620141491','FID POS COLLECTION ACCOUNT','2023-01-19 17:45:57',5,0.00,0.00,'','792','2023-01-19 17:45:57','792',0,0),(24,2518,'',0,'2','1','306','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:12:19',5,0.00,0.00,'','792','2023-02-20 14:12:19','792',0,0),(25,2519,'',0,'2','1','306','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:24:45',5,0.00,0.00,'2023-03-15','792','2023-03-17 12:28:04','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','306','ALL DEALER','AA RANO','07063600300','hygaya@aaranonigerialimited','KADUNA','KADUNA','COMMAND JUNCTION KADUNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-22 19:11:11',5,'1015','2022-12-22 19:11:11','1015'),(2,'','1','306','SOLO GAS','SOLO ','08035871190','sologas@gmil.com','kadun','kaduna  state','kaduna','Nigeria',50.00,0.00,0.00,'0000-00-00','2023-01-11 15:51:27',5,'1015','2023-01-11 15:51:27','1015'),(3,'','1','306','TAMCY  GAS','TAMCY ','08023760894','sologas@gmil.com','KADUNA','KADUNA','KADUNA SABO','Nigeria',50.00,0.00,0.00,'0000-00-00','2023-01-11 15:52:57',5,'1015','2023-01-11 15:52:57','1015'),(4,'','1','306','E U GAS','E U','08065154400','sologas@gmil.com','KADUNA','kaduna  state','KADUNA','Nigeria',50.00,0.00,0.00,'0000-00-00','2023-01-11 15:54:07',5,'1015','2023-01-11 15:54:07','1015'),(5,'','1','306','YELLOW  GAS','YELLOW','08036155170','sologas@gmil.com','KADUNA','kaduna  state','KADUNA','Nigeria',50.00,0.00,0.00,'0000-00-00','2023-01-11 15:56:06',5,'1015','2023-01-11 15:56:06','1015'),(6,'','1','306','WAZIRI  GAS','WAZIRI','07037753973','sologas@gmil.com','KADUNA','kaduna  state','KADUNA  ','Nigeria',50.00,0.00,0.00,'0000-00-00','2023-01-11 15:57:18',5,'1015','2023-01-11 15:57:18','1015'),(7,'','1','306','C M G GAS','C M G','08177551415','cmggas@mail.com','KADUNA','kaduna  state','kaduna','Nigeria',50.00,0.00,0.00,'0000-00-00','2023-01-11 16:14:32',5,'1015','2023-01-11 16:14:32','1015'),(8,'','1','306','C J L GAS','CJL','08037873248','cmggas@mail.com','KADUNA','kaduna  state','KADUNA','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-01-11 16:16:27',5,'1015','2023-01-11 16:16:27','1015'),(9,'','1','306','ECKOVERSS  GAS','ECKOVERSE','07050517775','sologas@gmil.com','KADUNA','kaduna  state','KADUNA','Nigeria',150.00,0.00,0.00,'0000-00-00','2023-01-11 16:19:01',5,'1015','2023-01-11 16:19:01','1015'),(10,'','1','306','JOWIN  GAS','JOWIN','08131868651','cmggas@mail.com','KADUNA','kaduna  state','KADUNA  TAKURI','Nigeria',200.00,0.00,0.00,'0000-00-00','2023-01-11 16:21:43',5,'1015','2023-01-11 16:21:43','1015'),(11,'','1','306','WILL  GAS','WILL','08035908893','sologas@gmil.com','KADUNA','kaduna  state','KADUNA','Nigeria',50.00,0.00,0.00,'0000-00-00','2023-01-11 16:23:28',5,'1015','2023-01-11 16:23:28','1015'),(12,'','1','306','SANI  GAS','SANI GAS','09020392737','sologas@gmil.com','KADUNA','kaduna  state','KADUNA','Nigeria',50.00,0.00,0.00,'0000-00-00','2023-01-11 17:45:42',5,'1015','2023-01-11 17:45:42','1015'),(13,'','1','306','ABDUL GAS','ABDUL','08180044514','abdul@mil.com','KADUNA','kaduna  state','KADUNA  BARNAWA','Nigeria',100.00,0.00,0.00,'0000-00-00','2023-01-12 11:58:02',5,'1015','2023-01-12 11:58:02','1015'),(14,'','1','306','U/ADIESON','U/ADIESON','07068952646','cmggas@mail.com','KADUNA','kaduna  state','KADUNA','Nigeria',50.00,0.00,0.00,'0000-00-00','2023-01-12 15:39:39',5,'1015','2023-01-12 15:39:39','1015'),(15,'','1','306','HATAKIZMAN','HATAKIZMAN ','08035864464','cmggas@mail.com','KADUNA','kaduna  state','KADUNA','Nigeria',150.00,0.00,0.00,'0000-00-00','2023-01-13 11:18:02',5,'1015','2023-01-13 11:18:02','1015'),(16,'','1','306','SAGIR GAS','SAGIR','08024971015','cmggas@mail.com','KADUNA','kaduna  state','KADUNA','Nigeria',200.00,0.00,0.00,'0000-00-00','2023-01-13 11:39:10',5,'1015','2023-01-13 11:39:10','1015'),(17,'','1','306','IKON ALLAH GAS','IKON ALLAH','08036136997','sologas@gmil.com','KADUNA','kaduna  state','KADUNA','Nigeria',50.00,0.00,0.00,'0000-00-00','2023-01-18 17:06:17',5,'1015','2023-01-18 17:06:17','1015'),(18,'','1','306','J A GAS','JA J A','08023111085','cmggas@mail.com','KADUNA','kaduna  state','KADUNA','Nigeria',50.00,0.00,0.00,'0000-00-00','2023-01-18 17:32:16',5,'1015','2023-01-18 17:32:16','1015'),(19,'','1','306','HASSAN GAS','HASSAN','08065307137','cmggas@mail.com','KADUNA','kaduna  state','KADUNA','Nigeria',50.00,0.00,0.00,'0000-00-00','2023-01-18 17:33:06',5,'1015','2023-01-18 17:33:06','1015'),(20,'','1','306','911 GAS','RONI','08095500911','cmggas@mail.com','KADUNA','kaduna  state','OPP JAWAKO  POLICE  STATION','Nigeria',200.00,0.00,0.00,'0000-00-00','2023-01-19 12:43:36',5,'1015','2023-01-19 12:43:36','1015'),(21,'','1','306','MARVIS GAS','MARVIS','07015663525','sologas@gmil.com','KADUNA','kaduna  state','KADUNA','Nigeria',50.00,0.00,0.00,'0000-00-00','2023-01-19 15:19:29',5,'1015','2023-01-19 15:19:29','1015'),(22,'','1','306','I G  GAS','I G GAS','09016940939','cmggas@mail.com','KADUNA','kaduna  state','KADUNA','Nigeria',50.00,0.00,0.00,'0000-00-00','2023-01-20 11:39:44',5,'1015','2023-01-20 11:39:44','1015'),(23,'','1','306','PAY LESS GAS','PAY LESS','08063452316','cmggas@mail.com','KADUNA','kaduna  state','KADUNA','Nigeria',200.00,0.00,0.00,'0000-00-00','2023-01-20 11:41:48',5,'1015','2023-01-20 11:41:48','1015'),(24,'','1','306','SUNNY GAS','SUNNY ','08036013325','cmggas@mail.com','KADUNA','kaduna  state','KADUNA','Nigeria',50.00,0.00,0.00,'0000-00-00','2023-01-21 10:32:05',5,'1015','2023-01-21 10:32:05','1015'),(25,'','1','306','BAWA  GAS','BAWA     ','08028434542','cmggas@mail.com','KADUNA','kaduna  state','KADUNA','Nigeria',50.00,0.00,0.00,'0000-00-00','2023-01-21 12:21:42',5,'1015','2023-01-21 12:21:42','1015'),(26,'','1','306','CHAMPION   GAS ','CHAMPION ','08064688200','sologas@gmil.com','KADUNA','kaduna  state','KADUNA  ','Nigeria',50.00,0.00,0.00,'0000-00-00','2023-02-18 15:44:51',5,'1015','2023-02-18 15:44:51','1015'),(27,'','1','306','MARY GAS','MARY','09066817023','sologas@gmil.com','KADUNA','kaduna  state','KADUNA  KARATUDU','Nigeria',50.00,0.00,0.00,'0000-00-00','2023-03-11 17:03:06',5,'1015','2023-03-11 17:03:06','1015');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','306','1',1,'5','LPG NOZZLE 1',25780.04,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','306','1',2,'5','LPG NOZZLE 2',56682.02,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','306',1,'DAILY SALES','2022-12-22','2022-12-22 11:51:15','2022-12-23 11:51:15','1015',0.00,0.00,'1015','2022-12-22 19:25:44','1015','2022-12-22 19:26:02',10,0),('1','306',2,'DAILY','2022-12-23','2022-12-23 07:53:00','2022-12-24 07:53:00','1015',0.00,0.00,'1015','2022-12-23 19:01:25','1015','2022-12-23 19:01:48',10,0),('1','306',3,'daily','2022-12-24','2022-12-24 07:53:26','2022-12-25 07:53:26','1015',0.00,0.00,'1015','2022-12-24 17:50:33','1015','2022-12-24 17:50:59',10,0),('1','306',4,'daily','2022-12-25','2022-12-25 08:22:36','2022-12-26 08:22:36','1015',0.00,0.00,'1015','2022-12-25 18:31:48','1015','2022-12-25 18:32:14',10,0),('1','306',5,'DAILY','2022-12-26','2022-12-26 07:56:19','2022-12-27 07:56:19','1015',0.00,0.00,'1015','2022-12-26 19:07:15','1015','2022-12-26 19:07:36',10,0),('1','306',6,'DAILY','2022-12-27','2022-12-27 07:57:30','2022-12-28 07:57:30','1015',0.00,0.00,'1015','2022-12-27 18:43:39','1015','2022-12-27 18:43:56',10,0),('1','306',7,'DAILY','2022-12-28','2022-12-28 07:40:11','2022-12-29 07:40:11','1015',0.00,0.00,'1015','2022-12-28 18:41:43','1015','2022-12-28 18:42:05',10,0),('1','306',8,'DAILY','2022-12-29','2022-12-29 07:36:17','2022-12-30 07:36:17','1015',0.00,0.00,'1015','2022-12-29 18:37:53','1015','2022-12-29 18:38:07',10,0),('1','306',9,'DAILY','2022-12-30','2022-12-30 08:12:49','2022-12-31 08:12:49','1015',0.00,0.00,'1015','2022-12-30 18:33:51','1015','2022-12-30 18:34:09',10,0),('1','306',10,'DAILY','2022-12-31','2022-12-31 07:14:58','2023-01-01 07:14:58','1015',0.00,0.00,'1015','2022-12-31 14:20:52','1015','2022-12-31 14:21:09',10,0),('1','306',11,'DAILY','2022-12-31','2022-12-31 14:44:04','2023-01-01 14:44:04','1015',0.00,0.00,'1015','2022-12-31 18:27:26','1015','2022-12-31 18:27:46',10,0),('1','306',12,'DAILY','2023-01-01','2023-01-01 07:28:30','2023-01-02 07:28:30','1015',0.00,0.00,'1015','2023-01-01 18:20:46','1015','2023-01-01 18:21:04',10,0),('1','306',13,'DAILY','2023-01-02','2023-01-02 06:59:54','2023-01-03 06:59:54','1015',0.00,0.00,'1015','2023-01-02 18:55:10','1015','2023-01-02 18:55:27',10,0),('1','306',14,'DAILY','2023-01-03','2023-01-03 06:53:52','2023-01-04 06:53:52','1015',0.00,0.00,'1015','2023-01-03 19:12:19','1015','2023-01-03 19:12:39',10,0),('1','306',15,'DAILY','2023-01-04','2023-01-04 07:18:47','2023-01-05 07:18:47','1015',0.00,0.00,'1015','2023-01-04 18:19:23','1015','2023-01-04 18:19:39',10,0),('1','306',16,'DAILY','2023-01-05','2023-01-05 07:05:59','2023-01-06 07:05:59','1015',0.00,0.00,'1015','2023-01-05 12:22:13','1015','2023-01-05 12:22:35',10,0),('1','306',17,'DAILY','2023-01-05','2023-01-05 12:23:46','2023-01-06 12:23:46','1015',0.00,0.00,'1015','2023-01-05 18:17:26','1015','2023-01-05 18:17:43',10,0),('1','306',18,'DAILY','2023-01-06','2023-01-06 07:03:12','2023-01-07 07:03:12','1015',0.00,0.00,'1015','2023-01-06 18:42:51','1015','2023-01-06 18:43:13',10,0),('1','306',19,'DAILY','2023-01-07','2023-01-07 07:27:28','2023-01-08 07:27:28','1015',0.00,0.00,'1015','2023-01-07 18:48:07','1015','2023-01-07 18:48:25',10,0),('1','306',20,'DAILY','2023-01-08','2023-01-08 06:58:29','2023-01-09 06:58:29','1015',0.00,0.00,'1015','2023-01-08 18:45:10','1015','2023-01-08 18:45:28',10,0),('1','306',21,'DAILY','2023-01-09','2023-01-09 07:03:50','2023-01-10 07:03:50','1015',0.00,0.00,'1015','2023-01-09 18:58:32','1015','2023-01-09 18:58:58',10,0),('1','306',22,'DAILY','2023-01-10','2023-01-10 06:54:53','2023-01-11 06:54:53','1015',0.00,0.00,'1015','2023-01-10 10:18:01','1015','2023-01-10 10:18:49',10,0),('1','306',23,'DAILY','2023-01-10','2023-01-10 10:28:53','2023-01-11 10:28:53','1015',0.00,0.00,'1015','2023-01-10 10:40:59','1015','2023-01-10 10:41:34',10,0),('1','306',24,'DAILY','2023-01-10','2023-01-10 10:42:00','2023-01-11 10:42:00','1015',0.00,0.00,'1015','2023-01-10 18:16:42','1015','2023-01-10 18:17:07',10,0),('1','306',25,'DAILY','2023-01-11','2023-01-11 06:56:09','2023-01-12 06:56:09','1015',0.00,0.00,'1015','2023-01-11 18:35:58','1015','2023-01-11 18:36:21',10,0),('1','306',26,'DAILY','2023-01-12','2023-01-12 07:07:50','2023-01-13 07:07:50','1015',0.00,0.00,'1015','2023-01-12 18:56:45','1015','2023-01-12 18:57:00',10,0),('1','306',27,'DAILY','2023-01-13','2023-01-13 07:13:19','2023-01-14 07:13:19','1015',0.00,0.00,'1015','2023-01-13 18:31:02','1015','2023-01-13 18:31:17',10,0),('1','306',28,'DAILY','2023-01-14','2023-01-14 07:06:01','2023-01-15 07:06:01','1015',0.00,0.00,'1015','2023-01-14 14:44:39','1015','2023-01-14 14:44:55',10,0),('1','306',29,'DAILY','2023-01-15','2023-01-15 07:43:29','2023-01-16 07:43:29','1015',0.00,0.00,'1015','2023-01-15 18:29:08','1015','2023-01-15 18:29:25',10,0),('1','306',30,'DAILY','2023-01-16','2023-01-16 07:00:21','2023-01-17 07:00:21','1015',0.00,0.00,'1015','2023-01-16 18:46:06','1015','2023-01-16 18:46:27',10,0),('1','306',31,'DAILY','2023-01-17','2023-01-17 06:59:11','2023-01-18 06:59:11','1015',0.00,0.00,'1015','2023-01-17 18:50:17','1015','2023-01-17 18:50:38',10,0),('1','306',32,'DAILY','2023-01-18','2023-01-18 06:54:42','2023-01-19 06:54:42','1015',0.00,0.00,'1015','2023-01-18 18:52:10','1015','2023-01-18 18:52:32',10,0),('1','306',33,'DAILY','2023-01-19','2023-01-19 07:10:50','2023-01-20 07:10:50','1015',0.00,0.00,'1015','2023-01-19 14:29:51','1015','2023-01-19 14:30:08',10,0),('1','306',34,'DAILY','2023-01-19','2023-01-19 14:30:28','2023-01-20 14:30:28','1015',0.00,0.00,'1015','2023-01-19 18:25:25','1015','2023-01-19 18:25:42',10,0),('1','306',35,'DAILY','2023-01-20','2023-01-20 07:00:07','2023-01-21 07:00:07','1015',0.00,0.00,'1015','2023-01-20 18:51:34','1015','2023-01-20 18:51:50',10,0),('1','306',36,'Daily','2023-01-21','2023-01-21 06:32:20','2023-01-22 06:32:20','1015',0.00,0.00,'1015','2023-01-21 18:52:10','1015','2023-01-21 18:52:50',10,0),('1','306',37,'DAILY','2023-01-22','2023-01-22 07:00:36','2023-01-23 07:00:36','1015',0.00,0.00,'1015','2023-01-22 18:39:39','1015','2023-01-22 18:39:56',10,0),('1','306',38,'DAILY','2023-01-23','2023-01-23 06:18:50','2023-01-24 06:18:50','1015',0.00,0.00,'1015','2023-01-23 15:51:38','1015','2023-01-23 15:51:54',10,0),('1','306',39,'DAILY','2023-01-25','2023-01-25 07:01:57','2023-01-26 07:01:57','1015',0.00,0.00,'1015','2023-01-25 19:02:13','1015','2023-01-25 19:02:32',10,0),('1','306',40,'DAILY','2023-01-26','2023-01-26 06:57:08','2023-01-27 06:57:08','1015',0.00,0.00,'1015','2023-01-26 18:58:07','1015','2023-01-26 18:58:31',10,0),('1','306',41,'DAILY','2023-01-27','2023-01-27 06:57:34','2023-01-28 06:57:34','1015',0.00,0.00,'1015','2023-01-27 18:40:13','1015','2023-01-27 18:40:31',10,0),('1','306',42,'DAILY','2023-01-28','2023-01-28 07:13:45','2023-01-29 07:13:45','1015',0.00,0.00,'1015','2023-01-28 17:13:29','1015','2023-01-28 17:13:49',10,0),('1','306',43,'DAILY','2023-01-28','2023-01-28 17:16:15','2023-01-29 17:16:15','1015',0.00,0.00,'1015','2023-01-28 17:20:56','1015','2023-01-28 17:21:13',10,0),('1','306',44,'DAILY','2023-01-29','2023-01-29 06:54:09','2023-01-30 06:54:09','1015',0.00,0.00,'1015','2023-01-29 18:49:34','1015','2023-01-29 18:49:53',10,0),('1','306',45,'DAILY','2023-01-30','2023-01-30 07:01:38','2023-01-31 07:01:38','1015',0.00,0.00,'1015','2023-01-30 18:49:36','1015','2023-01-30 18:49:58',10,0),('1','306',46,'DAILY','2023-01-31','2023-01-31 06:54:57','2023-02-01 06:54:57','1015',0.00,0.00,'1015','2023-01-31 18:55:21','1015','2023-01-31 18:55:41',10,0),('1','306',47,'DAILY','2023-02-01','2023-02-01 07:00:31','2023-02-02 07:00:31','1015',0.00,0.00,'1015','2023-02-01 19:10:56','1015','2023-02-01 19:11:13',10,0),('1','306',48,'DAILY','2023-02-02','2023-02-02 06:46:09','2023-02-03 06:46:09','1015',0.00,0.00,'1015','2023-02-02 19:41:58','1015','2023-02-02 19:42:26',10,0),('1','306',49,'DAILY','2023-02-03','2023-02-03 07:00:21','2023-02-04 07:00:21','1015',0.00,0.00,'1015','2023-02-03 18:16:47','1015','2023-02-03 18:17:26',10,0),('1','306',50,'DAILY','2023-02-03','2023-02-03 18:20:16','2023-02-04 18:20:16','1015',0.00,0.00,'1015','2023-02-03 18:23:50','1015','2023-02-03 18:24:17',10,0),('1','306',51,'DAILY','2023-02-04','2023-02-04 06:08:53','2023-02-05 06:08:53','1015',0.00,0.00,'1015','2023-02-04 19:01:13','1015','2023-02-04 19:01:29',10,0),('1','306',52,'DAILY','2023-02-05','2023-02-05 07:07:25','2023-02-06 07:07:25','1015',0.00,0.00,'1015','2023-02-05 19:05:10','1015','2023-02-05 19:05:50',10,0),('1','306',53,'DAILY','2023-02-06','2023-02-06 07:08:52','2023-02-07 07:08:52','1015',0.00,0.00,'1015','2023-02-06 17:03:37','1015','2023-02-06 17:03:53',10,0),('1','306',54,'DAILY','2023-02-07','2023-02-07 13:03:57','2023-02-08 13:03:57','1015',0.00,0.00,'1015','2023-02-07 18:50:22','1015','2023-02-07 18:50:38',10,0),('1','306',55,'DAILY','2023-02-08','2023-02-08 07:17:50','2023-02-09 07:17:50','1015',0.00,0.00,'1015','2023-02-08 17:24:31','1015','2023-02-08 17:24:46',10,0),('1','306',56,'DAILY','2023-02-08','2023-02-08 17:33:07','2023-02-09 17:33:07','1015',0.00,0.00,'1015','2023-02-08 17:36:29','1015','2023-02-08 17:36:45',10,0),('1','306',57,'DAILY','2023-02-09','2023-02-09 07:23:04','2023-02-10 07:23:04','1015',0.00,0.00,'1015','2023-02-09 19:02:05','1015','2023-02-09 19:02:32',10,0),('1','306',58,'DAILY','2023-02-10','2023-02-10 06:59:00','2023-02-11 06:59:00','1015',0.00,0.00,'1015','2023-02-10 18:59:47','1015','2023-02-10 19:00:02',10,0),('1','306',59,'DAILY','2023-02-11','2023-02-11 07:04:00','2023-02-12 07:04:00','1015',0.00,0.00,'1015','2023-02-11 18:57:59','1015','2023-02-11 18:58:32',10,0),('1','306',60,'DAILY','2023-02-12','2023-02-12 07:07:19','2023-02-13 07:07:19','1015',0.00,0.00,'1015','2023-02-12 18:47:33','1015','2023-02-12 18:47:50',10,0),('1','306',61,'DAILY','2023-02-13','2023-02-13 06:58:54','2023-02-14 06:58:54','1015',0.00,0.00,'1015','2023-02-13 19:01:51','1015','2023-02-13 19:02:12',10,0),('1','306',62,'DAILY','2023-02-14','2023-02-14 07:09:54','2023-02-15 07:09:54','1015',0.00,0.00,'1015','2023-02-14 13:23:34','1015','2023-02-14 13:23:57',10,0),('1','306',63,'DAILY','2023-02-14','2023-02-14 13:26:34','2023-02-15 13:26:34','1015',0.00,0.00,'1015','2023-02-14 13:31:01','1015','2023-02-14 13:31:28',10,0),('1','306',64,'DAILY','2023-02-14','2023-02-14 14:18:34','2023-02-15 14:18:34','1015',0.00,0.00,'1015','2023-02-14 18:32:59','1015','2023-02-14 18:33:30',10,0),('1','306',65,'DAILY','2023-02-15','2023-02-15 07:00:25','2023-02-16 07:00:25','1015',0.00,0.00,'1015','2023-02-15 18:56:20','1015','2023-02-15 18:56:38',10,0),('1','306',66,'DAILY','2023-02-16','2023-02-16 06:53:06','2023-02-17 06:53:06','1015',0.00,0.00,'1015','2023-02-16 18:46:16','1015','2023-02-16 18:46:36',10,0),('1','306',67,'DAILY','2023-02-17','2023-02-17 07:01:59','2023-02-18 07:01:59','1015',0.00,0.00,'1015','2023-02-17 18:59:03','1015','2023-02-17 18:59:23',10,0),('1','306',68,'DAILY','2023-02-18','2023-02-18 07:04:29','2023-02-19 07:04:29','1015',0.00,0.00,'1015','2023-02-18 18:46:06','1015','2023-02-18 18:46:25',10,0),('1','306',69,'DAILY','2023-02-19','2023-02-19 06:58:06','2023-02-20 06:58:06','1015',0.00,0.00,'1015','2023-02-19 09:50:15','1015','2023-02-19 09:50:42',10,0),('1','306',70,'DAILY','2023-02-19','2023-02-19 09:53:04','2023-02-20 09:53:04','1015',0.00,0.00,'1015','2023-02-19 09:59:26','1015','2023-02-19 09:59:41',10,0),('1','306',71,'DAILY','2023-02-19','2023-02-19 10:42:54','2023-02-20 10:42:54','1015',0.00,0.00,'1015','2023-02-19 19:05:14','1015','2023-02-19 19:05:36',10,0),('1','306',72,'DAILY','2023-02-20','2023-02-20 07:02:31','2023-02-21 07:02:31','1015',0.00,0.00,'1015','2023-02-20 19:06:07','1015','2023-02-20 19:06:27',10,0),('1','306',73,'DAILY','2023-02-21','2023-02-21 06:58:32','2023-02-22 06:58:32','1015',0.00,0.00,'1015','2023-02-21 19:02:24','1015','2023-02-21 19:03:06',10,0),('1','306',74,'DAILY','2023-02-22','2023-02-22 07:04:42','2023-02-23 07:04:42','1015',0.00,0.00,'1015','2023-02-22 19:18:03','1015','2023-02-22 19:18:20',10,0),('1','306',75,'DAILY','2023-02-23','2023-02-23 07:05:43','2023-02-24 07:05:43','1015',0.00,0.00,'1015','2023-02-23 10:36:52','1015','2023-02-23 10:37:09',10,0),('1','306',76,'DAILY','2023-02-23','2023-02-23 10:39:34','2023-02-24 10:39:34','1015',0.00,0.00,'1015','2023-02-23 10:54:15','1015','2023-02-23 10:55:05',10,0),('1','306',77,'DAILY','2023-02-23','2023-02-23 10:55:28','2023-02-24 10:55:28','1015',0.00,0.00,'1015','2023-02-23 18:34:25','1015','2023-02-23 18:34:47',10,0),('1','306',78,'DAILY','2023-02-24','2023-02-24 17:07:16','2023-02-25 17:07:16','1015',0.00,0.00,'1015','2023-02-24 21:04:33','1015','2023-02-24 21:05:02',10,0),('1','306',79,'DAILY','2023-02-26','2023-02-26 08:59:04','2023-02-27 08:59:04','1015',0.00,0.00,'1015','2023-02-26 18:18:52','1015','2023-02-26 18:19:42',10,0),('1','306',80,'DAILY','2023-02-27','2023-02-27 07:02:44','2023-02-28 07:02:44','1015',0.00,0.00,'1015','2023-02-27 15:20:35','1015','2023-02-27 15:20:52',10,0),('1','306',81,'DAILY','2023-02-28','2023-02-28 07:02:14','2023-03-01 07:02:14','1015',0.00,0.00,'1015','2023-02-28 19:34:08','1015','2023-02-28 19:34:26',10,0),('1','306',82,'DAILY','2023-03-01','2023-03-01 07:04:21','2023-03-02 07:04:21','1015',0.00,0.00,'1015','2023-03-01 19:07:09','1015','2023-03-01 19:07:28',10,0),('1','306',83,'DAILY','2023-03-02','2023-03-02 06:57:48','2023-03-03 06:57:48','1015',0.00,0.00,'1015','2023-03-02 17:40:00','1015','2023-03-02 17:40:39',10,0),('1','306',84,'DAILY','2023-03-03','2023-03-03 07:00:48','2023-03-04 07:00:48','1015',0.00,0.00,'1015','2023-03-03 19:03:35','1015','2023-03-03 19:03:59',10,0),('1','306',85,'DAILY','2023-03-04','2023-03-04 07:00:00','2023-03-05 07:00:00','1015',0.00,0.00,'1015','2023-03-04 18:43:55','1015','2023-03-04 18:44:10',10,0),('1','306',86,'DAILY','2023-03-05','2023-03-05 07:12:08','2023-03-06 07:12:08','1015',0.00,0.00,'1015','2023-03-05 18:43:36','1015','2023-03-05 18:43:51',10,0),('1','306',87,'DAILY','2023-03-06','2023-03-06 07:00:30','2023-03-07 07:00:30','1015',0.00,0.00,'1015','2023-03-06 18:59:15','1015','2023-03-06 18:59:39',10,0),('1','306',88,'DAILY','2023-03-07','2023-03-07 06:49:18','2023-03-08 06:49:18','1015',0.00,0.00,'1015','2023-03-07 12:20:35','1015','2023-03-07 12:20:52',10,0),('1','306',89,'DAILY','2023-03-07','2023-03-07 12:21:59','2023-03-08 12:21:59','1015',0.00,0.00,'1015','2023-03-07 12:27:28','1015','2023-03-07 12:28:04',10,0),('1','306',90,'DAILY','2023-03-07','2023-03-07 15:13:34','2023-03-08 15:13:34','1015',0.00,0.00,'1015','2023-03-07 19:01:00','1015','2023-03-07 19:01:14',10,0),('1','306',91,'DAILY','2023-03-08','2023-03-08 06:57:50','2023-03-09 06:57:50','1015',0.00,0.00,'1015','2023-03-08 19:16:17','1015','2023-03-08 19:16:41',10,0),('1','306',92,'DAILY','2023-03-09','2023-03-09 07:36:14','2023-03-10 07:36:14','1015',0.00,0.00,'1015','2023-03-09 18:46:40','1015','2023-03-09 18:46:55',10,0),('1','306',93,'DAILY','2023-03-10','2023-03-10 06:49:03','2023-03-11 06:49:03','1015',0.00,0.00,'1015','2023-03-10 15:41:29','1015','2023-03-10 15:41:44',10,0),('1','306',94,'DAILY','2023-03-10','2023-03-10 15:42:39','2023-03-11 15:42:39','1015',0.00,0.00,'1015','2023-03-10 15:48:15','1015','2023-03-10 15:48:32',10,0),('1','306',95,'DAILY','2023-03-11','2023-03-11 11:42:20','2023-03-12 11:42:20','1015',0.00,0.00,'1015','2023-03-11 18:48:28','1015','2023-03-11 18:48:43',10,0),('1','306',96,'DAILY','2023-03-12','2023-03-12 07:08:26','2023-03-13 07:08:26','1015',0.00,0.00,'1015','2023-03-12 18:54:37','1015','2023-03-12 18:54:52',10,0),('1','306',97,'DAILY','2023-03-13','2023-03-13 07:01:11','2023-03-14 07:01:11','1015',0.00,0.00,'1015','2023-03-13 19:37:08','1015','2023-03-13 19:37:22',10,0),('1','306',98,'DAILY','2023-03-14','2023-03-14 06:57:33','2023-03-15 06:57:33','1015',0.00,0.00,'1015','2023-03-14 19:28:06','1015','2023-03-14 19:28:36',10,0),('1','306',99,'DAILY','2023-03-14','2023-03-14 19:32:29','2023-03-15 19:32:29','1015',0.00,0.00,'1015','2023-03-14 19:35:16','1015','2023-03-14 19:35:33',10,0),('1','306',100,'DAILY','2023-03-15','2023-03-15 06:55:26','2023-03-16 06:55:26','1015',0.00,0.00,'1015','2023-03-15 18:48:42','1015','2023-03-15 18:48:59',10,0),('1','306',101,'DAILY','2023-03-16','2023-03-16 06:55:18','2023-03-17 06:55:18','1015',0.00,0.00,'1015','2023-03-16 19:02:25','1015','2023-03-16 19:03:05',10,0),('1','306',102,'DAILY','2023-03-17','2023-03-17 07:29:21','2023-03-18 07:29:21','1015',0.00,0.00,'1015','2023-03-17 20:41:26','1015','2023-03-17 20:42:33',10,0),('1','306',103,'DAILY','2023-03-19','2023-03-19 09:20:52','2023-03-20 09:20:52','1015',0.00,0.00,'1015','2023-03-19 12:36:43','1015','2023-03-19 12:37:39',10,0),('1','306',104,'DAILY','2023-03-19','2023-03-19 13:10:35','2023-03-20 13:10:35','1015',0.00,0.00,'1015','2023-03-19 13:14:38','1015','2023-03-19 13:14:58',10,0),('1','306',105,'DAILY','2023-03-20','2023-03-20 07:51:31','2023-03-21 07:51:31','1015',0.00,0.00,'1015','2023-03-20 16:49:05','1015','2023-03-20 16:49:26',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=211 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','306','1','1',1,'1','1',0.00,521.00,0.00,0.00,521.00,375120.00,0.00,0.00,0.00),('1','306','1','1',2,'2','1',0.00,124.31,0.00,0.00,124.31,93481.12,0.00,0.00,0.00),('1','306','1','2',3,'1','1',521.00,621.00,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','306','1','2',4,'2','1',124.31,397.95,0.00,0.00,273.64,205777.28,0.00,0.00,0.00),('1','306','1','3',5,'1','1',621.00,1021.50,0.00,0.00,400.50,288360.00,0.00,0.00,0.00),('1','306','1','3',6,'2','1',397.95,770.00,0.00,0.00,372.05,279781.60,0.00,0.00,0.00),('1','306','1','4',7,'1','1',1021.50,1408.87,0.00,0.00,387.37,278906.40,0.00,0.00,0.00),('1','306','1','4',8,'2','1',770.00,1154.59,0.00,0.00,384.59,289211.68,0.00,0.00,0.00),('1','306','1','5',9,'1','1',1408.87,2123.87,0.00,0.00,715.00,514800.00,0.00,0.00,0.00),('1','306','1','5',10,'2','1',1154.59,1701.30,0.00,0.00,546.71,411125.92,0.00,0.00,0.00),('1','306','1','6',11,'1','1',2123.87,2183.87,0.00,0.00,60.00,43200.00,0.00,0.00,0.00),('1','306','1','6',12,'2','1',1701.30,1939.15,0.00,0.00,237.85,178863.20,0.00,0.00,0.00),('1','306','1','7',13,'1','1',2183.87,2441.87,0.00,0.00,258.00,185760.00,0.00,0.00,0.00),('1','306','1','7',14,'2','1',1939.15,2104.98,0.00,0.00,165.83,124704.16,0.00,0.00,0.00),('1','306','1','8',15,'1','1',2441.87,2481.87,0.00,0.00,40.00,28800.00,0.00,0.00,0.00),('1','306','1','8',16,'2','1',2104.98,2381.45,0.00,0.00,276.47,207905.44,0.00,0.00,0.00),('1','306','1','9',17,'1','1',2481.87,2646.87,0.00,0.00,165.00,118800.00,0.00,0.00,0.00),('1','306','1','9',18,'2','1',2381.45,2631.46,0.00,0.00,250.01,188007.52,0.00,0.00,0.00),('1','306','1','10',19,'1','1',2646.87,2691.37,0.00,0.00,44.50,32040.00,0.00,0.00,0.00),('1','306','1','10',20,'2','1',2631.46,2808.14,0.00,0.00,176.68,132863.36,0.00,0.00,0.00),('1','306','1','11',21,'1','1',2691.37,2811.37,0.00,0.00,120.00,86400.00,0.00,0.00,0.00),('1','306','1','11',22,'2','1',2808.14,3039.97,0.00,0.00,231.83,174336.16,0.00,0.00,0.00),('1','306','1','12',23,'1','1',2811.37,2860.37,0.00,0.00,49.00,35280.00,0.00,0.00,0.00),('1','306','1','12',24,'2','1',3039.97,3550.30,0.00,0.00,510.33,383768.16,0.00,0.00,0.00),('1','306','1','13',25,'1','1',2860.37,3814.28,0.00,0.00,953.91,688668.32,0.00,0.00,0.00),('1','306','1','13',26,'2','1',3550.30,4368.93,0.00,0.00,818.63,613753.76,0.00,0.00,0.00),('1','306','1','14',27,'1','1',3814.28,4195.21,0.00,0.00,380.93,274269.60,0.00,0.00,0.00),('1','306','1','14',28,'2','1',4368.93,4743.57,0.00,0.00,374.64,281729.28,0.00,0.00,0.00),('1','306','1','15',29,'1','1',4195.21,4788.21,0.00,0.00,593.00,426960.00,0.00,0.00,0.00),('1','306','1','15',30,'2','1',4743.57,5045.81,0.00,0.00,302.24,227284.48,0.00,0.00,0.00),('1','306','1','16',31,'1','1',4788.21,4848.71,0.00,0.00,60.50,43560.00,0.00,0.00,0.00),('1','306','1','16',32,'2','1',5045.81,5259.85,0.00,0.00,214.04,160958.08,0.00,0.00,0.00),('1','306','1','17',33,'1','1',4848.71,5385.71,0.00,0.00,537.00,386640.00,0.00,0.00,0.00),('1','306','1','17',34,'2','1',5259.85,5461.90,0.00,0.00,202.05,151941.60,0.00,0.00,0.00),('1','306','1','18',35,'1','1',5385.71,5561.21,0.00,0.00,175.50,126360.00,0.00,0.00,0.00),('1','306','1','18',36,'2','1',5461.90,5879.80,0.00,0.00,417.90,314260.80,0.00,0.00,0.00),('1','306','1','19',37,'1','1',5561.21,6499.71,0.00,0.00,938.50,675720.00,0.00,0.00,0.00),('1','306','1','19',38,'2','1',5879.80,6493.32,0.00,0.00,613.52,461367.04,0.00,0.00,0.00),('1','306','1','20',39,'1','1',6499.71,6655.71,0.00,0.00,156.00,112320.00,0.00,0.00,0.00),('1','306','1','20',40,'2','1',6493.32,6917.91,0.00,0.00,424.59,319291.68,0.00,0.00,0.00),('1','306','1','21',41,'1','1',6655.71,7163.71,0.00,0.00,508.00,365760.00,0.00,0.00,0.00),('1','306','1','21',42,'2','1',6917.91,7574.15,0.00,0.00,656.24,493492.48,0.00,0.00,0.00),('1','306','1','22',43,'1','1',7163.71,7334.21,0.00,0.00,170.50,122760.00,0.00,0.00,0.00),('1','306','1','22',44,'2','1',7574.15,7679.93,0.00,0.00,105.78,79546.56,0.00,0.00,0.00),('1','306','1','23',45,'1','1',7334.21,7334.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','23',46,'2','1',7679.93,7679.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','24',47,'1','1',7334.21,7598.96,0.00,0.00,264.75,190620.00,0.00,0.00,0.00),('1','306','1','24',48,'2','1',7679.93,8185.50,0.00,0.00,505.57,380188.64,0.00,0.00,0.00),('1','306','1','25',49,'1','1',7598.96,7728.96,0.00,0.00,130.00,93600.00,0.00,0.00,0.00),('1','306','1','25',50,'2','1',8185.50,8670.68,0.00,0.00,485.18,364855.36,0.00,0.00,0.00),('1','306','1','26',51,'1','1',7728.96,8296.26,0.00,0.00,567.30,408456.00,0.00,0.00,0.00),('1','306','1','26',52,'2','1',8670.68,9175.35,0.00,0.00,504.67,379511.84,0.00,0.00,0.00),('1','306','1','27',53,'1','1',8296.26,9111.48,0.00,0.00,815.22,586958.40,0.00,0.00,0.00),('1','306','1','27',54,'2','1',9175.35,9994.28,0.00,0.00,818.93,615835.36,0.00,0.00,0.00),('1','306','1','28',55,'1','1',9111.48,9243.53,0.00,0.00,132.05,95076.00,0.00,0.00,0.00),('1','306','1','28',56,'2','1',9994.28,10645.03,0.00,0.00,650.75,489364.00,0.00,0.00,0.00),('1','306','1','29',57,'1','1',9243.53,9390.26,0.00,0.00,146.73,107112.90,0.00,0.00,0.00),('1','306','1','29',58,'2','1',10645.03,11150.30,0.00,0.00,505.27,389057.90,0.00,0.00,0.00),('1','306','1','30',59,'1','1',9390.26,9942.26,0.00,0.00,552.00,402960.00,0.00,0.00,0.00),('1','306','1','30',60,'2','1',11150.30,11870.18,0.00,0.00,719.88,554307.60,0.00,0.00,0.00),('1','306','1','31',61,'1','1',9942.26,10496.25,0.00,0.00,553.99,404412.70,0.00,0.00,0.00),('1','306','1','31',62,'2','1',11870.18,12602.78,0.00,0.00,732.60,564102.00,0.00,0.00,0.00),('1','306','1','32',63,'1','1',10496.25,10886.25,0.00,0.00,390.00,284820.00,0.00,0.00,0.00),('1','306','1','32',64,'2','1',12602.78,13297.68,0.00,0.00,694.90,535073.00,0.00,0.00,0.00),('1','306','1','33',65,'1','1',10886.25,11148.66,0.00,0.00,262.41,191559.30,0.00,0.00,0.00),('1','306','1','33',66,'2','1',13297.68,13668.97,0.00,0.00,371.29,285893.30,0.00,0.00,0.00),('1','306','1','34',67,'1','1',11148.66,11455.66,0.00,0.00,307.00,224110.00,0.00,0.00,0.00),('1','306','1','34',68,'2','1',13668.97,13951.24,0.00,0.00,282.27,217347.90,0.00,0.00,0.00),('1','306','1','35',69,'1','1',11455.66,11933.16,0.00,0.00,477.50,348575.00,0.00,0.00,0.00),('1','306','1','35',70,'2','1',13951.24,14707.07,0.00,0.00,755.83,581989.10,0.00,0.00,0.00),('1','306','1','36',71,'1','1',11933.16,12422.16,0.00,0.00,489.00,356970.00,0.00,0.00,0.00),('1','306','1','36',72,'2','1',14707.07,15737.38,0.00,0.00,1030.31,793338.70,0.00,0.00,0.00),('1','306','1','37',73,'1','1',12422.16,12464.66,0.00,0.00,42.50,31025.00,0.00,0.00,0.00),('1','306','1','37',74,'2','1',15737.38,16226.93,0.00,0.00,489.55,376953.50,0.00,0.00,0.00),('1','306','1','38',75,'1','1',12464.66,12942.16,0.00,0.00,477.50,348575.00,0.00,0.00,0.00),('1','306','1','38',76,'2','1',16226.93,16732.04,0.00,0.00,505.11,388934.70,0.00,0.00,0.00),('1','306','1','39',77,'1','1',12942.16,13360.16,0.00,0.00,418.00,305301.20,0.00,0.00,0.00),('1','306','1','39',78,'2','1',16732.04,17442.85,0.00,0.00,710.81,547323.70,0.00,0.00,0.00),('1','306','1','40',79,'1','1',13360.16,13818.40,0.00,0.00,458.24,334515.20,0.00,0.00,0.00),('1','306','1','40',80,'2','1',17442.85,18087.20,0.00,0.00,644.35,496149.50,0.00,0.00,0.00),('1','306','1','41',81,'1','1',13818.40,14104.40,0.00,0.00,286.00,208780.00,0.00,0.00,0.00),('1','306','1','41',82,'2','1',18087.20,18891.42,0.00,0.00,804.22,619249.40,0.00,0.00,0.00),('1','306','1','42',83,'1','1',14104.40,14541.90,0.00,0.00,437.50,319375.00,0.00,0.00,0.00),('1','306','1','42',84,'2','1',18891.42,19607.08,0.00,0.00,715.66,551058.20,0.00,0.00,0.00),('1','306','1','43',85,'1','1',14541.90,14541.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','43',86,'2','1',19607.08,19607.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','44',87,'1','1',14541.90,14623.40,0.00,0.00,81.50,59495.00,0.00,0.00,0.00),('1','306','1','44',88,'2','1',19607.08,20059.01,0.00,0.00,451.93,347986.10,0.00,0.00,0.00),('1','306','1','45',89,'1','1',14623.40,14810.40,0.00,0.00,187.00,136510.00,0.00,0.00,0.00),('1','306','1','45',90,'2','1',20059.01,20611.32,0.00,0.00,552.31,425278.70,0.00,0.00,0.00),('1','306','1','46',91,'1','1',14810.40,15431.90,0.00,0.00,621.50,453695.00,0.00,0.00,0.00),('1','306','1','46',92,'2','1',20611.32,21207.20,0.00,0.00,595.88,458827.60,0.00,0.00,0.00),('1','306','1','47',93,'1','1',15431.90,15638.40,0.00,0.00,206.50,150745.00,0.00,0.00,0.00),('1','306','1','47',94,'2','1',21207.20,21832.30,0.00,0.00,625.10,481327.00,0.00,0.00,0.00),('1','306','1','48',95,'1','1',15638.40,16085.90,0.00,0.00,447.50,326675.00,0.00,0.00,0.00),('1','306','1','48',96,'2','1',21832.30,22731.26,0.00,0.00,898.96,692199.20,0.00,0.00,0.00),('1','306','1','49',97,'1','1',16085.90,16176.90,0.00,0.00,91.00,66430.00,0.00,0.00,0.00),('1','306','1','49',98,'2','1',22731.26,23343.69,0.00,0.00,612.43,471571.10,0.00,0.00,0.00),('1','306','1','50',99,'1','1',16176.90,16176.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','50',100,'2','1',23343.69,23343.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','51',101,'1','1',16176.90,16656.90,0.00,0.00,480.00,350400.00,0.00,0.00,0.00),('1','306','1','51',102,'2','1',23343.69,24220.07,0.00,0.00,876.38,674812.60,0.00,0.00,0.00),('1','306','1','52',103,'1','1',16656.90,16656.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','52',104,'2','1',24220.07,24744.08,0.00,0.00,524.01,403487.70,0.00,0.00,0.00),('1','306','1','53',105,'1','1',16656.90,16893.40,0.00,0.00,236.50,172645.00,0.00,0.00,0.00),('1','306','1','53',106,'2','1',24744.08,25226.02,0.00,0.00,481.94,371093.80,0.00,0.00,0.00),('1','306','1','54',107,'1','1',16893.40,16893.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','54',108,'2','1',25226.02,25545.02,0.00,0.00,319.00,245630.00,0.00,0.00,0.00),('1','306','1','55',109,'1','1',16893.40,16985.40,0.00,0.00,92.00,67160.00,0.00,0.00,0.00),('1','306','1','55',110,'2','1',25545.02,26225.49,0.00,0.00,680.47,523961.90,0.00,0.00,0.00),('1','306','1','56',111,'1','1',16985.40,16985.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','56',112,'2','1',26225.49,26225.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','57',113,'1','1',16985.40,17313.91,0.00,0.00,328.51,236527.20,0.00,0.00,0.00),('1','306','1','57',114,'2','1',26225.49,26810.55,0.00,0.00,585.06,444645.60,0.00,0.00,0.00),('1','306','1','58',115,'1','1',17313.91,17313.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','58',116,'2','1',26810.55,26969.50,0.00,0.00,158.95,120802.00,0.00,0.00,0.00),('1','306','1','59',117,'1','1',17313.91,17528.91,0.00,0.00,215.00,154800.00,0.00,0.00,0.00),('1','306','1','59',118,'2','1',26969.50,27978.22,0.00,0.00,1008.72,766627.20,0.00,0.00,0.00),('1','306','1','60',119,'1','1',17528.91,17645.11,0.00,0.00,116.20,83664.00,0.00,0.00,0.00),('1','306','1','60',120,'2','1',27978.22,28807.72,0.00,0.00,829.50,630420.00,0.00,0.00,0.00),('1','306','1','61',121,'1','1',17645.11,17808.11,0.00,0.00,163.00,117360.00,0.00,0.00,0.00),('1','306','1','61',122,'2','1',28807.72,29620.50,0.00,0.00,812.78,617712.80,0.00,0.00,0.00),('1','306','1','62',123,'1','1',17808.11,17970.61,0.00,0.00,162.50,117000.00,0.00,0.00,0.00),('1','306','1','62',124,'2','1',29620.50,30036.63,0.00,0.00,416.13,316258.80,0.00,0.00,0.00),('1','306','1','63',125,'1','1',17970.61,17970.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','63',126,'2','1',30036.63,30036.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','64',127,'1','1',17970.61,17993.82,0.00,0.00,23.21,16711.20,0.00,0.00,0.00),('1','306','1','64',128,'2','1',30036.63,30150.11,0.00,0.00,113.48,86244.80,0.00,0.00,0.00),('1','306','1','65',129,'1','1',17993.82,18154.03,0.00,0.00,160.21,115591.20,0.00,0.00,0.00),('1','306','1','65',130,'2','1',30150.11,30980.41,0.00,0.00,830.30,631028.00,0.00,0.00,0.00),('1','306','1','66',131,'1','1',18154.03,18626.03,0.00,0.00,472.00,339840.00,0.00,0.00,0.00),('1','306','1','66',132,'2','1',30980.41,31878.89,0.00,0.00,898.48,682844.80,0.00,0.00,0.00),('1','306','1','67',133,'1','1',18626.03,19059.68,0.00,0.00,433.65,312228.00,0.00,0.00,0.00),('1','306','1','67',134,'2','1',31878.89,32591.32,0.00,0.00,712.43,541446.80,0.00,0.00,0.00),('1','306','1','68',135,'1','1',19059.68,19336.68,0.00,0.00,277.00,199440.00,0.00,0.00,0.00),('1','306','1','68',136,'2','1',32591.32,33321.96,0.00,0.00,730.64,555286.40,0.00,0.00,0.00),('1','306','1','69',137,'1','1',19336.68,19368.68,0.00,0.00,32.00,23040.00,0.00,0.00,0.00),('1','306','1','69',138,'2','1',33321.96,33419.10,0.00,0.00,97.14,73826.40,0.00,0.00,0.00),('1','306','1','70',139,'1','1',19368.68,19368.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','70',140,'2','1',33419.10,33419.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','71',141,'1','1',19368.68,19368.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','71',142,'2','1',33419.10,34151.12,0.00,0.00,732.02,556335.20,0.00,0.00,0.00),('1','306','1','72',143,'1','1',19368.68,19522.68,0.00,0.00,154.00,110880.00,0.00,0.00,0.00),('1','306','1','72',144,'2','1',34151.12,34897.63,0.00,0.00,746.51,567347.60,0.00,0.00,0.00),('1','306','1','73',145,'1','1',19522.68,19895.68,0.00,0.00,373.00,268560.00,0.00,0.00,0.00),('1','306','1','73',146,'2','1',34897.63,35972.93,0.00,0.00,1075.30,817228.00,0.00,0.00,0.00),('1','306','1','74',147,'1','1',19895.68,19980.68,0.00,0.00,85.00,61200.00,0.00,0.00,0.00),('1','306','1','74',148,'2','1',35972.93,36872.68,0.00,0.00,899.75,683810.00,0.00,0.00,0.00),('1','306','1','75',149,'1','1',19980.68,20153.68,0.00,0.00,173.00,124560.00,0.00,0.00,0.00),('1','306','1','75',150,'2','1',36872.68,37183.16,0.00,0.00,310.48,235964.80,0.00,0.00,0.00),('1','306','1','76',151,'1','1',20153.68,20153.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','76',152,'2','1',37183.16,37183.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','77',153,'1','1',20153.68,20178.68,0.00,0.00,25.00,18000.00,0.00,0.00,0.00),('1','306','1','77',154,'2','1',37183.16,37493.15,0.00,0.00,309.99,235592.40,0.00,0.00,0.00),('1','306','1','78',155,'1','1',20178.68,20216.13,0.00,0.00,37.45,26964.00,0.00,0.00,0.00),('1','306','1','78',156,'2','1',37493.15,37769.48,0.00,0.00,276.33,210010.80,0.00,0.00,0.00),('1','306','1','79',157,'1','1',20216.13,20616.13,0.00,0.00,400.00,288000.00,0.00,0.00,0.00),('1','306','1','79',158,'2','1',37769.48,38717.40,0.00,0.00,947.92,720419.20,0.00,0.00,0.00),('1','306','1','80',159,'1','1',20616.13,20752.13,0.00,0.00,136.00,97920.00,0.00,0.00,0.00),('1','306','1','80',160,'2','1',38717.40,39406.49,0.00,0.00,689.09,523708.40,0.00,0.00,0.00),('1','306','1','81',161,'1','1',20752.13,21219.13,0.00,0.00,467.00,336240.00,0.00,0.00,0.00),('1','306','1','81',162,'2','1',39406.49,40891.74,0.00,0.00,1485.25,1128790.00,0.00,0.00,0.00),('1','306','1','82',163,'1','1',21219.13,21490.88,0.00,0.00,271.75,195660.00,0.00,0.00,0.00),('1','306','1','82',164,'2','1',40891.74,41893.15,0.00,0.00,1001.41,761071.60,0.00,0.00,0.00),('1','306','1','83',165,'1','1',21490.88,22128.88,0.00,0.00,638.00,459360.00,0.00,0.00,0.00),('1','306','1','83',166,'2','1',41893.15,42590.80,0.00,0.00,697.65,530214.00,0.00,0.00,0.00),('1','306','1','84',167,'1','1',22128.88,22169.88,0.00,0.00,41.00,29520.00,0.00,0.00,0.00),('1','306','1','84',168,'2','1',42590.80,43350.49,0.00,0.00,759.69,577364.40,0.00,0.00,0.00),('1','306','1','85',169,'1','1',22169.88,22259.22,0.00,0.00,89.34,64324.80,0.00,0.00,0.00),('1','306','1','85',170,'2','1',43350.49,44780.77,0.00,0.00,1430.28,1087012.80,0.00,0.00,0.00),('1','306','1','86',171,'1','1',22259.22,22262.22,0.00,0.00,3.00,2160.00,0.00,0.00,0.00),('1','306','1','86',172,'2','1',44780.77,45359.32,0.00,0.00,578.55,439698.00,0.00,0.00,0.00),('1','306','1','87',173,'1','1',22262.22,22262.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','87',174,'2','1',45359.32,46232.87,0.00,0.00,873.55,663898.00,0.00,0.00,0.00),('1','306','1','88',175,'1','1',22262.22,22387.22,0.00,0.00,125.00,90000.00,0.00,0.00,0.00),('1','306','1','88',176,'2','1',46232.87,46611.68,0.00,0.00,378.81,287895.60,0.00,0.00,0.00),('1','306','1','89',177,'1','1',22387.22,22387.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','89',178,'2','1',46611.68,46611.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','90',179,'1','1',22387.22,22387.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','90',180,'2','1',46611.68,46881.44,0.00,0.00,269.76,205017.60,0.00,0.00,0.00),('1','306','1','91',181,'1','1',22387.22,22550.22,0.00,0.00,163.00,110840.00,0.00,0.00,0.00),('1','306','1','91',182,'2','1',46881.44,47732.41,0.00,0.00,850.97,646737.20,0.00,0.00,0.00),('1','306','1','92',183,'1','1',22550.22,22941.51,0.00,0.00,391.29,266077.20,0.00,0.00,0.00),('1','306','1','92',184,'2','1',47732.41,48600.08,0.00,0.00,867.67,659429.20,0.00,0.00,0.00),('1','306','1','93',185,'1','1',22941.51,23116.51,0.00,0.00,175.00,119000.00,0.00,0.00,0.00),('1','306','1','93',186,'2','1',48600.08,49132.03,0.00,0.00,531.95,404282.00,0.00,0.00,0.00),('1','306','1','94',187,'1','1',23116.51,23116.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','94',188,'2','1',49132.03,49132.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','95',189,'1','1',23116.51,23628.99,0.00,0.00,512.48,348486.40,0.00,0.00,0.00),('1','306','1','95',190,'2','1',49132.03,49781.72,0.00,0.00,649.69,493764.40,0.00,0.00,0.00),('1','306','1','96',191,'1','1',23628.99,23628.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','96',192,'2','1',49781.72,50533.80,0.00,0.00,752.08,571580.80,0.00,0.00,0.00),('1','306','1','97',193,'1','1',23628.99,24193.90,0.00,0.00,564.91,384138.80,0.00,0.00,0.00),('1','306','1','97',194,'2','1',50533.80,51378.44,0.00,0.00,844.64,641926.40,0.00,0.00,0.00),('1','306','1','98',195,'1','1',24193.90,24421.90,0.00,0.00,228.00,155040.00,0.00,0.00,0.00),('1','306','1','98',196,'2','1',51378.44,52327.17,0.00,0.00,948.73,721034.80,0.00,0.00,0.00),('1','306','1','99',197,'1','1',24421.90,24421.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','99',198,'2','1',52327.17,52327.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','100',199,'1','1',24421.90,24671.89,0.00,0.00,249.99,169993.20,0.00,0.00,0.00),('1','306','1','100',200,'2','1',52327.17,53311.36,0.00,0.00,984.19,747984.40,0.00,0.00,0.00),('1','306','1','101',201,'1','1',24671.89,24752.79,0.00,0.00,80.90,55012.00,0.00,0.00,0.00),('1','306','1','101',202,'2','1',53311.36,54384.02,0.00,0.00,1072.66,815221.60,0.00,0.00,0.00),('1','306','1','102',203,'1','1',24752.79,25106.27,0.00,0.00,353.48,240366.40,0.00,0.00,0.00),('1','306','1','102',204,'2','1',54384.02,55716.40,0.00,0.00,1332.38,1012608.80,0.00,0.00,0.00),('1','306','1','103',205,'1','1',25106.27,25281.77,0.00,0.00,175.50,119340.00,0.00,0.00,0.00),('1','306','1','103',206,'2','1',55716.40,55955.00,0.00,0.00,238.60,181336.00,0.00,0.00,0.00),('1','306','1','104',207,'1','1',25281.77,25281.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','104',208,'2','1',55955.00,55955.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','306','1','105',209,'1','1',25281.77,25780.04,0.00,0.00,498.27,338823.60,0.00,0.00,0.00),('1','306','1','105',210,'2','1',55955.00,56682.02,0.00,0.00,727.02,552535.20,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','306','1','1',666.00,0.00,0.00,645.31,429776.46,468601.12,38824.66,1),('1','306','2','1',666.00,752.00,0.00,373.64,248844.24,277777.28,28933.04,2),('1','306','3','1',666.00,752.00,0.00,772.55,514518.30,568141.60,53623.30,3),('1','306','4','1',666.00,752.00,0.00,771.96,514125.36,568118.08,53992.72,4),('1','306','5','1',666.00,752.00,0.00,1261.71,840298.86,925925.92,85627.06,5),('1','306','6','1',666.00,752.00,0.00,297.85,198368.10,222063.20,23695.10,6),('1','306','7','1',666.00,752.00,0.00,423.83,282270.78,310464.16,28193.38,7),('1','306','8','1',666.00,752.00,0.00,316.47,210769.02,236705.44,25936.42,8),('1','306','9','1',666.00,752.00,0.00,415.01,276396.66,306807.52,30410.86,9),('1','306','10','1',666.00,752.00,0.00,221.18,147305.88,164903.36,17597.48,10),('1','306','11','1',666.00,752.00,0.00,351.83,234318.78,260736.16,26417.38,11),('1','306','12','1',666.00,752.00,0.00,559.33,372513.78,419048.16,46534.38,12),('1','306','13','1',666.00,752.00,0.00,1772.54,1180511.64,1302422.08,121910.44,13),('1','306','14','1',666.00,752.00,0.00,755.57,503209.62,555998.88,52789.26,14),('1','306','15','1',666.00,752.00,0.00,895.24,596229.84,654244.48,58014.64,15),('1','306','16','1',666.00,752.00,0.00,274.54,182843.64,204518.08,21674.44,16),('1','306','17','1',666.00,752.00,0.00,739.05,492207.30,538581.60,46374.30,17),('1','306','18','1',666.00,752.00,0.00,593.40,395204.40,440620.80,45416.40,18),('1','306','19','1',666.00,752.00,0.00,1552.02,1033645.32,1137087.04,103441.72,19),('1','306','20','1',666.00,752.00,0.00,580.59,386672.94,431611.68,44938.74,20),('1','306','21','1',666.00,752.00,0.00,1164.24,775383.84,859252.48,83868.64,21),('1','306','22','1',666.00,752.00,0.00,276.28,184002.48,202306.56,18304.08,22),('1','306','23','1',666.00,752.00,0.00,0.00,0.00,0.00,0.00,23),('1','306','24','1',666.00,752.00,0.00,770.32,513033.12,570808.64,57775.52,24),('1','306','25','1',666.00,752.00,0.00,615.18,409709.88,458455.36,48745.48,25),('1','306','26','1',666.00,752.00,0.00,1071.97,713932.02,787967.84,74035.82,26),('1','306','27','1',666.00,752.00,0.00,1634.15,1088343.90,1202793.76,114449.86,27),('1','306','28','1',666.00,752.00,0.00,782.80,521344.80,584440.00,63095.20,28),('1','306','29','1',666.00,752.00,0.00,652.00,434232.00,496170.80,61938.80,29),('1','306','30','1',666.00,770.00,0.00,1271.88,847072.08,957267.60,110195.52,30),('1','306','31','1',666.00,770.00,0.00,1286.59,856868.94,968514.70,111645.76,31),('1','306','32','1',666.00,770.00,0.00,1084.90,722543.40,819893.00,97349.60,32),('1','306','33','1',666.00,770.00,0.00,633.70,422044.20,477452.60,55408.40,33),('1','306','34','1',666.00,770.00,0.00,589.27,392453.82,441457.90,49004.08,34),('1','306','35','1',666.00,770.00,0.00,1233.33,821397.78,930564.10,109166.32,35),('1','306','36','1',666.00,770.00,0.00,1519.31,1011860.46,1150308.70,138448.24,36),('1','306','37','1',666.00,770.00,0.00,532.05,354345.30,407978.50,53633.20,37),('1','306','38','1',666.00,770.00,0.00,982.61,654418.26,737509.70,83091.44,38),('1','306','39','1',666.00,770.00,0.00,1128.81,721309.59,852624.90,131315.31,39),('1','306','40','1',639.00,770.00,0.00,1102.59,704555.01,830664.70,126109.69,40),('1','306','41','1',639.00,770.00,0.00,1090.22,696650.58,828029.40,131378.82,41),('1','306','42','1',639.00,770.00,0.00,1153.16,736869.24,870433.20,133563.96,42),('1','306','43','1',639.00,770.00,0.00,0.00,0.00,0.00,0.00,43),('1','306','44','1',639.00,770.00,0.00,533.43,340861.77,407481.10,66619.33,44),('1','306','45','1',639.00,770.00,0.00,739.31,472419.09,561788.70,89369.61,45),('1','306','46','1',639.00,770.00,0.00,1217.38,777905.82,912522.60,134616.78,46),('1','306','47','1',639.00,770.00,0.00,831.60,531392.40,632072.00,100679.60,47),('1','306','48','1',639.00,770.00,0.00,1346.46,860387.94,1018874.20,158486.26,48),('1','306','49','1',639.00,770.00,0.00,703.43,449491.77,538001.10,88509.33,49),('1','306','50','1',639.00,770.00,0.00,0.00,0.00,0.00,0.00,50),('1','306','51','1',649.00,770.00,0.00,1356.38,880290.62,1025212.60,144921.98,51),('1','306','52','1',649.00,770.00,0.00,524.01,340082.49,403487.70,63405.21,52),('1','306','53','1',649.00,770.00,0.00,718.44,466267.56,543738.80,77471.24,53),('1','306','54','1',649.00,770.00,0.00,319.00,207031.00,245630.00,38599.00,54),('1','306','55','1',649.00,770.00,0.00,772.47,501333.03,591121.90,89788.87,55),('1','306','56','1',649.00,770.00,0.00,0.00,0.00,0.00,0.00,56),('1','306','57','1',649.00,760.00,0.00,913.57,592906.93,681172.80,88265.87,57),('1','306','58','1',649.00,760.00,0.00,158.95,103158.55,120802.00,17643.45,58),('1','306','59','1',649.00,760.00,0.00,1223.72,794194.28,921427.20,127232.92,59),('1','306','60','1',649.00,760.00,0.00,945.70,613759.30,714084.00,100324.70,60),('1','306','61','1',649.00,760.00,0.00,975.78,633281.22,735072.80,101791.58,61),('1','306','62','1',649.00,760.00,0.00,578.63,375530.87,433258.80,57727.93,62),('1','306','63','1',649.00,760.00,0.00,0.00,0.00,0.00,0.00,63),('1','306','64','1',644.00,760.00,0.00,136.69,88028.36,102956.00,14927.64,64),('1','306','65','1',644.00,760.00,0.00,990.51,637888.44,746619.20,108730.76,65),('1','306','66','1',644.00,760.00,0.00,1370.48,882589.12,1022684.80,140095.68,66),('1','306','67','1',644.00,760.00,0.00,1146.08,738075.52,853674.80,115599.28,67),('1','306','68','1',644.00,760.00,0.00,1007.64,648920.16,754726.40,105806.24,68),('1','306','69','1',644.00,760.00,0.00,129.14,83166.16,96866.40,13700.24,69),('1','306','70','1',644.00,760.00,0.00,0.00,0.00,0.00,0.00,70),('1','306','71','1',644.00,760.00,0.00,732.02,471420.88,556335.20,84914.32,71),('1','306','72','1',644.00,760.00,0.00,900.51,579928.44,678227.60,98299.16,72),('1','306','73','1',644.00,760.00,0.00,1448.30,932705.20,1085788.00,153082.80,73),('1','306','74','1',644.00,760.00,0.00,984.75,634179.00,745010.00,110831.00,74),('1','306','75','1',644.00,760.00,0.00,483.48,311361.12,360524.80,49163.68,75),('1','306','76','1',644.00,760.00,0.00,0.00,0.00,0.00,0.00,76),('1','306','77','1',644.00,760.00,0.00,334.99,215733.56,253592.40,37858.84,77),('1','306','78','1',644.00,760.00,0.00,313.78,202074.32,236974.80,34900.48,78),('1','306','79','1',644.00,760.00,0.00,1347.92,868060.48,1008419.20,140358.72,79),('1','306','80','1',644.00,760.00,0.00,825.09,531357.96,621628.40,90270.44,80),('1','306','81','1',644.00,760.00,0.00,1952.25,1257249.00,1465030.00,207781.00,81),('1','306','82','1',644.00,760.00,0.00,1273.16,819915.04,956731.60,136816.56,82),('1','306','83','1',644.00,760.00,0.00,1335.65,860158.60,989574.00,129415.40,83),('1','306','84','1',644.00,760.00,0.00,800.69,515644.36,606884.40,91240.04,84),('1','306','85','1',644.00,760.00,0.00,1519.62,978635.28,1151337.60,172702.32,85),('1','306','86','1',644.00,760.00,0.00,581.55,374518.20,441858.00,67339.80,86),('1','306','87','1',644.00,760.00,0.00,873.55,562566.20,663898.00,101331.80,87),('1','306','88','1',644.00,760.00,0.00,503.81,324453.64,377895.60,53441.96,88),('1','306','89','1',644.00,760.00,0.00,0.00,0.00,0.00,0.00,89),('1','306','90','1',640.00,760.00,0.00,269.76,172646.40,205017.60,32371.20,90),('1','306','91','1',640.00,760.00,0.00,1013.97,648940.80,757577.20,108636.40,91),('1','306','92','1',640.00,760.00,0.00,1258.96,805734.40,925506.40,119772.00,92),('1','306','93','1',640.00,760.00,0.00,706.95,452448.00,523282.00,70834.00,93),('1','306','94','1',640.00,760.00,0.00,0.00,0.00,0.00,0.00,94),('1','306','95','1',640.00,760.00,0.00,1162.17,743788.80,842250.80,98462.00,95),('1','306','96','1',640.00,760.00,0.00,752.08,481331.20,571580.80,90249.60,96),('1','306','97','1',640.00,760.00,0.00,1409.55,902112.00,1026065.20,123953.20,97),('1','306','98','1',640.00,760.00,0.00,1176.73,753107.20,876074.80,122967.60,98),('1','306','99','1',640.00,760.00,0.00,0.00,0.00,0.00,0.00,99),('1','306','100','1',640.00,760.00,0.00,1234.18,789875.20,917977.60,128102.40,100),('1','306','101','1',640.00,760.00,0.00,1153.56,738278.40,870233.60,131955.20,101),('1','306','102','1',640.00,760.00,0.00,1685.86,1078950.40,1252975.20,174024.80,102),('1','306','103','1',640.00,760.00,0.00,414.10,265024.00,300676.00,35652.00,103),('1','306','104','1',640.00,760.00,0.00,0.00,0.00,0.00,0.00,104),('1','306','105','1',634.00,760.00,0.00,1225.29,776833.86,891358.80,114524.94,105);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'306','LPG TANKS ','LPG PRODUCT TANKS.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','306','1',1,1,'1','LPG TANK ',6000.00,0.00,NULL,'LPG PRODUCT TANK.','479','2022-12-22 01:31:20','2022-12-22 01:31:20','479',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','306',1,2474.71,'2023-03-20 16:44:12');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=10606 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','306',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,3663000.00,5500.00,0.00,0.00,'2022-12-22 11:24:27','',''),(2,'1','306',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,5500.00,0.00,'2022-12-22 11:26:28','',''),(3,'1','306','1',1,'Received from bridging 1',0.00,0.00,5500.00,0.00,0.00,'2022-12-22 11:26:28','',''),(4,'1','306','1',1,'Retail Sale Id 1',4512.00,0.00,0.00,6.00,516.00,'2022-12-22 12:10:47','',''),(5,'1','306','1',1,'Retail Sale Id 2',375120.00,0.00,0.00,521.00,28134.00,'2022-12-22 19:12:42','',''),(6,'1','306','1',1,'Return of Retail Sale Id 1',0.00,4512.00,6.00,0.00,-516.00,'2022-12-22 19:14:26','',''),(7,'1','306','1',1,'Retail Sale Id 3',93481.12,0.00,0.00,124.31,10690.66,'2022-12-22 19:16:16','',''),(8,'1','306','1',1,'Retail Sale Id 4',7497.44,0.00,0.00,9.97,857.42,'2022-12-23 07:53:37','',''),(9,'1','306','1',1,'Retail Sale Id 5',7001.12,0.00,0.00,9.31,800.66,'2022-12-23 07:56:51','',''),(10,'1','306','1',1,'Retail Sale Id 6',2248.48,0.00,0.00,2.99,257.14,'2022-12-23 08:18:24','',''),(11,'1','306','1',1,'Retail Sale Id 7',4549.60,0.00,0.00,6.05,520.30,'2022-12-23 08:19:40','',''),(12,'1','306','1',1,'Retail Sale Id 8',9001.44,0.00,0.00,11.97,1029.42,'2022-12-23 08:26:07','',''),(13,'1','306','1',1,'Retail Sale Id 9',2248.48,0.00,0.00,2.99,257.14,'2022-12-23 08:35:35','',''),(14,'1','306','1',1,'Retail Sale Id 10',2248.48,0.00,0.00,2.99,257.14,'2022-12-23 08:53:49','',''),(15,'1','306','1',1,'Retail Sale Id 11',4496.96,0.00,0.00,5.98,514.28,'2022-12-23 10:05:57','',''),(16,'1','306','1',1,'Retail Sale Id 13',5000.80,0.00,0.00,6.65,571.90,'2022-12-23 10:40:48','',''),(17,'1','306','1',1,'Retail Sale Id 14',2248.48,0.00,0.00,2.99,257.14,'2022-12-23 10:53:17','',''),(18,'1','306','1',1,'Retail Sale Id 15',6000.96,0.00,0.00,7.98,686.28,'2022-12-23 10:56:36','',''),(19,'1','306','1',1,'Retail Sale Id 16',3496.80,0.00,0.00,4.65,399.90,'2022-12-23 11:03:46','',''),(20,'1','306','1',1,'Retail Sale Id 17',3699.84,0.00,0.00,4.92,423.12,'2022-12-23 11:05:05','',''),(21,'1','306','1',1,'Return of Retail Sale Id 4',0.00,7497.44,9.97,0.00,-857.42,'2022-12-23 11:20:42','',''),(22,'1','306','1',1,'Retail Sale Id 18',11302.56,0.00,0.00,15.03,1292.58,'2022-12-23 11:33:25','',''),(23,'1','306','1',1,'Retail Sale Id 19',1797.28,0.00,0.00,2.39,205.54,'2022-12-23 11:44:41','',''),(24,'1','306','1',1,'Retail Sale Id 20',1797.28,0.00,0.00,2.39,205.54,'2022-12-23 11:48:58','',''),(25,'1','306','1',1,'Retail Sale Id 21',4496.96,0.00,0.00,5.98,514.28,'2022-12-23 11:55:57','',''),(26,'1','306','1',1,'Retail Sale Id 22',4496.96,0.00,0.00,5.98,514.28,'2022-12-23 11:57:23','',''),(27,'1','306','1',1,'Retail Sale Id 23',1496.48,0.00,0.00,1.99,171.14,'2022-12-23 12:12:07','',''),(28,'1','306','1',1,'Retail Sale Id 24',4496.96,0.00,0.00,5.98,514.28,'2022-12-23 12:17:22','',''),(29,'1','306','1',1,'Retail Sale Id 25',3000.48,0.00,0.00,3.99,343.14,'2022-12-23 12:38:27','',''),(30,'1','306','1',1,'Retail Sale Id 26',3000.48,0.00,0.00,3.99,343.14,'2022-12-23 12:40:31','',''),(31,'1','306','1',1,'Retail Sale Id 27',7001.12,0.00,0.00,9.31,800.66,'2022-12-23 12:51:59','',''),(32,'1','306','1',1,'Retail Sale Id 28',4496.96,0.00,0.00,5.98,514.28,'2022-12-23 13:17:12','',''),(33,'1','306','1',1,'Retail Sale Id 30',4549.60,0.00,0.00,6.05,520.30,'2022-12-23 14:09:01','',''),(34,'1','306','1',1,'Retail Sale Id 32',6000.96,0.00,0.00,7.98,686.28,'2022-12-23 14:21:10','',''),(35,'1','306','1',1,'Retail Sale Id 33',9400.00,0.00,0.00,12.50,1075.00,'2022-12-23 14:44:44','',''),(36,'1','306','1',1,'Retail Sale Id 34',9400.00,0.00,0.00,12.50,1075.00,'2022-12-23 14:52:01','',''),(37,'1','306','1',1,'Retail Sale Id 36',2000.32,0.00,0.00,2.66,228.76,'2022-12-23 15:12:34','',''),(38,'1','306','1',1,'Retail Sale Id 38',2248.48,0.00,0.00,2.99,257.14,'2022-12-23 15:18:45','',''),(39,'1','306','1',1,'Retail Sale Id 39',72000.00,0.00,0.00,100.00,5400.00,'2022-12-23 15:39:33','',''),(40,'1','306','1',1,'Retail Sale Id 40',1496.48,0.00,0.00,1.99,171.14,'2022-12-23 15:48:23','',''),(41,'1','306','1',1,'Retail Sale Id 41',4496.96,0.00,0.00,5.98,514.28,'2022-12-23 16:02:31','',''),(42,'1','306','1',1,'Retail Sale Id 42',4496.96,0.00,0.00,5.98,514.28,'2022-12-23 16:06:55','',''),(43,'1','306','1',1,'Retail Sale Id 43',2301.12,0.00,0.00,3.06,263.16,'2022-12-23 16:08:54','',''),(44,'1','306','1',1,'Retail Sale Id 44',9497.76,0.00,0.00,12.63,1086.18,'2022-12-23 16:27:07','',''),(45,'1','306','1',1,'Retail Sale Id 45',3760.00,0.00,0.00,5.00,430.00,'2022-12-23 16:28:01','',''),(46,'1','306','1',1,'Retail Sale Id 46',9400.00,0.00,0.00,12.50,1075.00,'2022-12-23 16:41:40','',''),(47,'1','306','1',1,'Retail Sale Id 47',4000.64,0.00,0.00,5.32,457.52,'2022-12-23 16:46:45','',''),(48,'1','306','1',1,'Retail Sale Id 48',2248.48,0.00,0.00,2.99,257.14,'2022-12-23 16:51:40','',''),(49,'1','306','1',1,'Retail Sale Id 49',4496.96,0.00,0.00,5.98,514.28,'2022-12-23 16:56:05','',''),(50,'1','306','1',1,'Retail Sale Id 50',1496.48,0.00,0.00,1.99,171.14,'2022-12-23 16:57:38','',''),(51,'1','306','1',1,'Retail Sale Id 50',2248.48,0.00,0.00,2.99,257.14,'2022-12-23 16:57:38','',''),(52,'1','306','1',1,'Retail Sale Id 51',1496.48,0.00,0.00,1.99,171.14,'2022-12-23 17:32:34','',''),(53,'1','306','1',1,'Retail Sale Id 51',4496.96,0.00,0.00,5.98,514.28,'2022-12-23 17:32:34','',''),(54,'1','306','1',1,'Retail Sale Id 53',3000.48,0.00,0.00,3.99,343.14,'2022-12-23 17:35:22','',''),(55,'1','306','1',1,'Retail Sale Id 53',4496.96,0.00,0.00,5.98,514.28,'2022-12-23 17:35:22','',''),(56,'1','306','1',1,'Retail Sale Id 54',3797.60,0.00,0.00,5.05,434.30,'2022-12-23 17:38:32','',''),(57,'1','306','1',1,'Retail Sale Id 54',4496.96,0.00,0.00,5.98,514.28,'2022-12-23 17:38:32','',''),(58,'1','306','1',1,'Retail Sale Id 55',827.20,0.00,0.00,1.10,94.60,'2022-12-23 18:56:28','',''),(59,'1','306','1',1,'Retail Sale Id 56',1496.48,0.00,0.00,1.99,171.14,'2022-12-24 07:55:50','',''),(60,'1','306','1',1,'Retail Sale Id 57',9400.00,0.00,0.00,12.50,1075.00,'2022-12-24 08:02:58','',''),(61,'1','306','1',1,'Retail Sale Id 58',7497.44,0.00,0.00,9.97,857.42,'2022-12-24 08:20:15','',''),(62,'1','306','1',1,'Retail Sale Id 59',7497.44,0.00,0.00,9.97,857.42,'2022-12-24 08:35:58','',''),(63,'1','306','1',1,'Retail Sale Id 60',3000.48,0.00,0.00,3.99,343.14,'2022-12-24 08:39:25','',''),(64,'1','306','1',1,'Retail Sale Id 61',4000.64,0.00,0.00,5.32,457.52,'2022-12-24 08:44:32','',''),(65,'1','306','1',1,'Retail Sale Id 62',2496.64,0.00,0.00,3.32,285.52,'2022-12-24 08:48:42','',''),(66,'1','306','1',1,'Retail Sale Id 63',3760.00,0.00,0.00,5.00,430.00,'2022-12-24 08:50:25','',''),(67,'1','306','1',1,'Retail Sale Id 65',4000.64,0.00,0.00,5.32,457.52,'2022-12-24 08:53:51','',''),(68,'1','306','1',1,'Retail Sale Id 66',4496.96,0.00,0.00,5.98,514.28,'2022-12-24 08:55:51','',''),(69,'1','306','1',1,'Retail Sale Id 67',2256.00,0.00,0.00,3.00,258.00,'2022-12-24 09:00:36','',''),(70,'1','306','1',1,'Retail Sale Id 68',4512.00,0.00,0.00,6.00,516.00,'2022-12-24 09:02:29','',''),(71,'1','306','1',1,'Retail Sale Id 69',3760.00,0.00,0.00,5.00,430.00,'2022-12-24 09:10:02','',''),(72,'1','306','1',1,'Retail Sale Id 69',3760.00,0.00,0.00,5.00,430.00,'2022-12-24 09:10:02','',''),(73,'1','306','1',1,'Retail Sale Id 70',2301.12,0.00,0.00,3.06,263.16,'2022-12-24 09:12:21','',''),(74,'1','306','1',1,'Retail Sale Id 71',4496.96,0.00,0.00,5.98,514.28,'2022-12-24 09:13:35','',''),(75,'1','306','1',1,'Retail Sale Id 72',4496.96,0.00,0.00,5.98,514.28,'2022-12-24 09:17:01','',''),(76,'1','306','1',1,'Retail Sale Id 73',2301.12,0.00,0.00,3.06,263.16,'2022-12-24 09:30:52','',''),(77,'1','306','1',1,'Retail Sale Id 74',3496.80,0.00,0.00,4.65,399.90,'2022-12-24 09:33:35','',''),(78,'1','306','1',1,'Retail Sale Id 75',4496.96,0.00,0.00,5.98,514.28,'2022-12-24 09:36:30','',''),(79,'1','306','1',1,'Retail Sale Id 76',9400.00,0.00,0.00,12.50,1075.00,'2022-12-24 09:52:40','',''),(80,'1','306','1',1,'Retail Sale Id 77',1880.00,0.00,0.00,2.50,215.00,'2022-12-24 09:56:09','',''),(81,'1','306','1',1,'Retail Sale Id 78',4512.00,0.00,0.00,6.00,516.00,'2022-12-24 09:57:28','',''),(82,'1','306','1',1,'Retail Sale Id 79',3760.00,0.00,0.00,5.00,430.00,'2022-12-24 09:58:16','',''),(83,'1','306','1',1,'Retail Sale Id 80',3760.00,0.00,0.00,5.00,430.00,'2022-12-24 09:59:03','',''),(84,'1','306','1',1,'Retail Sale Id 81',5264.00,0.00,0.00,7.00,602.00,'2022-12-24 10:02:43','',''),(85,'1','306','1',1,'Retail Sale Id 82',4496.96,0.00,0.00,5.98,514.28,'2022-12-24 10:03:43','',''),(86,'1','306','1',1,'Retail Sale Id 83',3496.80,0.00,0.00,4.65,399.90,'2022-12-24 10:05:45','',''),(87,'1','306','1',1,'Retail Sale Id 84',3008.00,0.00,0.00,4.00,344.00,'2022-12-24 10:06:39','',''),(88,'1','306','1',1,'Retail Sale Id 85',849.76,0.00,0.00,1.13,97.18,'2022-12-24 10:08:00','',''),(89,'1','306','1',1,'Retail Sale Id 86',2301.12,0.00,0.00,3.06,263.16,'2022-12-24 10:09:34','',''),(90,'1','306','1',1,'Retail Sale Id 87',4496.96,0.00,0.00,5.98,514.28,'2022-12-24 10:10:43','',''),(91,'1','306','1',1,'Retail Sale Id 88',6016.00,0.00,0.00,8.00,688.00,'2022-12-24 10:12:32','',''),(92,'1','306','1',1,'Retail Sale Id 89',2301.12,0.00,0.00,3.06,263.16,'2022-12-24 10:14:24','',''),(93,'1','306','1',1,'Retail Sale Id 90',167040.00,0.00,0.00,232.00,12528.00,'2022-12-24 10:27:19','',''),(94,'1','306','1',1,'Retail Sale Id 91',4496.96,0.00,0.00,5.98,514.28,'2022-12-24 10:28:46','',''),(95,'1','306','1',1,'Retail Sale Id 93',167040.00,0.00,0.00,232.00,12528.00,'2022-12-24 10:32:23','',''),(96,'1','306','1',1,'Retail Sale Id 94',2301.12,0.00,0.00,3.06,263.16,'2022-12-24 10:38:49','',''),(97,'1','306','1',1,'Retail Sale Id 95',3008.00,0.00,0.00,4.00,344.00,'2022-12-24 10:40:53','',''),(98,'1','306','1',1,'Retail Sale Id 97',9400.00,0.00,0.00,12.50,1075.00,'2022-12-24 10:42:52','',''),(99,'1','306','1',1,'Retail Sale Id 98',4496.96,0.00,0.00,5.98,514.28,'2022-12-24 10:46:43','',''),(100,'1','306','1',1,'Retail Sale Id 99',1496.48,0.00,0.00,1.99,171.14,'2022-12-24 10:47:56','',''),(101,'1','306','1',1,'Retail Sale Id 100',3496.80,0.00,0.00,4.65,399.90,'2022-12-24 10:56:53','',''),(102,'1','306','1',1,'Return of Retail Sale Id 93',0.00,167040.00,232.00,0.00,-12528.00,'2022-12-24 10:57:09','',''),(103,'1','306','1',1,'Return of Retail Sale Id 90',0.00,167040.00,232.00,0.00,-12528.00,'2022-12-24 11:00:56','',''),(104,'1','306','1',1,'Retail Sale Id 101',167040.00,0.00,0.00,232.00,12528.00,'2022-12-24 11:04:55','',''),(105,'1','306','1',1,'Retail Sale Id 102',3752.48,0.00,0.00,4.99,429.14,'2022-12-24 11:08:41','',''),(106,'1','306','1',1,'Retail Sale Id 103',1496.48,0.00,0.00,1.99,171.14,'2022-12-24 11:09:56','',''),(107,'1','306','1',1,'Retail Sale Id 104',5301.60,0.00,0.00,7.05,606.30,'2022-12-24 11:15:56','',''),(108,'1','306','1',1,'Retail Sale Id 105',2496.64,0.00,0.00,3.32,285.52,'2022-12-24 11:17:10','',''),(109,'1','306','1',1,'Retail Sale Id 106',4496.96,0.00,0.00,5.98,514.28,'2022-12-24 11:19:31','',''),(110,'1','306','1',1,'Retail Sale Id 107',5264.00,0.00,0.00,7.00,602.00,'2022-12-24 11:32:00','',''),(111,'1','306','1',1,'Retail Sale Id 109',5264.00,0.00,0.00,7.00,602.00,'2022-12-24 11:33:02','',''),(112,'1','306','1',1,'Retail Sale Id 110',4496.96,0.00,0.00,5.98,514.28,'2022-12-24 11:37:39','',''),(113,'1','306','1',1,'Retail Sale Id 111',1496.48,0.00,0.00,1.99,171.14,'2022-12-24 11:46:28','',''),(114,'1','306','1',1,'Retail Sale Id 113',3000.48,0.00,0.00,3.99,343.14,'2022-12-24 12:02:25','',''),(115,'1','306','1',1,'Retail Sale Id 114',1496.48,0.00,0.00,1.99,171.14,'2022-12-24 12:03:29','',''),(116,'1','306','1',1,'Retail Sale Id 115',9400.00,0.00,0.00,12.50,1075.00,'2022-12-24 12:07:03','',''),(117,'1','306','1',1,'Retail Sale Id 116',2496.64,0.00,0.00,3.32,285.52,'2022-12-24 12:37:33','',''),(118,'1','306','1',1,'Retail Sale Id 117',1496.48,0.00,0.00,1.99,171.14,'2022-12-24 12:48:54','',''),(119,'1','306','1',1,'Retail Sale Id 118',6000.96,0.00,0.00,7.98,686.28,'2022-12-24 12:50:20','',''),(120,'1','306','1',1,'Retail Sale Id 119',7497.44,0.00,0.00,9.97,857.42,'2022-12-24 12:53:07','',''),(121,'1','306','1',1,'Retail Sale Id 119',7497.44,0.00,0.00,9.97,857.42,'2022-12-24 12:53:07','',''),(122,'1','306','1',1,'Retail Sale Id 120',100800.00,0.00,0.00,140.00,7560.00,'2022-12-24 13:01:33','',''),(123,'1','306','1',1,'Retail Sale Id 121',9400.00,0.00,0.00,12.50,1075.00,'2022-12-24 13:04:50','',''),(124,'1','306','1',1,'Retail Sale Id 122',2797.44,0.00,0.00,3.72,319.92,'2022-12-24 13:06:00','',''),(125,'1','306','1',1,'Retail Sale Id 123',3000.48,0.00,0.00,3.99,343.14,'2022-12-24 13:09:35','',''),(126,'1','306','1',1,'Retail Sale Id 124',2496.64,0.00,0.00,3.32,285.52,'2022-12-24 13:10:51','',''),(127,'1','306','1',1,'Retail Sale Id 125',2256.00,0.00,0.00,3.00,258.00,'2022-12-24 13:12:53','',''),(128,'1','306','1',1,'Retail Sale Id 126',10800.00,0.00,0.00,15.00,810.00,'2022-12-24 13:16:28','',''),(129,'1','306','1',1,'Retail Sale Id 127',9000.00,0.00,0.00,12.50,675.00,'2022-12-24 13:17:38','',''),(130,'1','306','1',1,'Retail Sale Id 128',1504.00,0.00,0.00,2.00,172.00,'2022-12-24 13:25:22','',''),(131,'1','306','1',1,'Retail Sale Id 128',2256.00,0.00,0.00,3.00,258.00,'2022-12-24 13:25:22','',''),(132,'1','306','1',1,'Retail Sale Id 129',9024.00,0.00,0.00,12.00,1032.00,'2022-12-24 13:27:36','',''),(133,'1','306','1',1,'Retail Sale Id 130',1800.00,0.00,0.00,2.50,135.00,'2022-12-24 13:40:03','',''),(134,'1','306','1',1,'Retail Sale Id 131',3760.00,0.00,0.00,5.00,430.00,'2022-12-24 13:43:30','',''),(135,'1','306','1',1,'Retail Sale Id 132',2000.32,0.00,0.00,2.66,228.76,'2022-12-24 13:48:30','',''),(136,'1','306','1',1,'Retail Sale Id 133',2203.36,0.00,0.00,2.93,251.98,'2022-12-24 13:57:34','',''),(137,'1','306','1',1,'Retail Sale Id 134',1496.48,0.00,0.00,1.99,171.14,'2022-12-24 14:09:41','',''),(138,'1','306','1',1,'Retail Sale Id 135',4496.96,0.00,0.00,5.98,514.28,'2022-12-24 14:17:15','',''),(139,'1','306','1',1,'Return of Retail Sale Id 134',0.00,1496.48,1.99,0.00,-171.14,'2022-12-24 14:29:56','',''),(140,'1','306','1',1,'Return of Retail Sale Id 135',0.00,4496.96,5.98,0.00,-514.28,'2022-12-24 14:30:29','',''),(141,'1','306','1',1,'Return of Retail Sale Id 132',0.00,2000.32,2.66,0.00,-228.76,'2022-12-24 17:36:46','',''),(142,'1','306','1',1,'Retail Sale Id 136',368.48,0.00,0.00,0.49,42.14,'2022-12-24 17:38:24','',''),(143,'1','306','1',1,'Return of Retail Sale Id 130',0.00,1800.00,2.50,0.00,-135.00,'2022-12-24 17:40:33','',''),(144,'1','306','1',1,'Retail Sale Id 137',720.00,0.00,0.00,1.00,54.00,'2022-12-24 17:42:24','',''),(145,'1','306','1',1,'Retail Sale Id 138',2496.64,0.00,0.00,3.32,285.52,'2022-12-25 08:26:25','',''),(146,'1','306','1',1,'Retail Sale Id 139',3496.80,0.00,0.00,4.65,399.90,'2022-12-25 08:28:03','',''),(147,'1','306','1',1,'Retail Sale Id 140',1496.48,0.00,0.00,1.99,171.14,'2022-12-25 08:29:18','',''),(148,'1','306','1',1,'Retail Sale Id 141',752.00,0.00,0.00,1.00,86.00,'2022-12-25 08:31:55','',''),(149,'1','306','1',1,'Retail Sale Id 141',752.00,0.00,0.00,1.00,86.00,'2022-12-25 08:31:55','',''),(150,'1','306','1',1,'Retail Sale Id 143',2203.36,0.00,0.00,2.93,251.98,'2022-12-25 08:36:40','',''),(151,'1','306','1',1,'Retail Sale Id 144',19251.20,0.00,0.00,25.60,2201.60,'2022-12-25 08:44:55','',''),(152,'1','306','1',1,'Retail Sale Id 145',2000.32,0.00,0.00,2.66,228.76,'2022-12-25 08:50:30','',''),(153,'1','306','1',1,'Retail Sale Id 146',1496.48,0.00,0.00,1.99,171.14,'2022-12-25 08:53:25','',''),(154,'1','306','1',1,'Retail Sale Id 147',4496.96,0.00,0.00,5.98,514.28,'2022-12-25 08:54:56','',''),(155,'1','306','1',1,'Retail Sale Id 148',4496.96,0.00,0.00,5.98,514.28,'2022-12-25 09:01:56','',''),(156,'1','306','1',1,'Retail Sale Id 149',4496.96,0.00,0.00,5.98,514.28,'2022-12-25 09:07:35','',''),(157,'1','306','1',1,'Retail Sale Id 150',1496.48,0.00,0.00,1.99,171.14,'2022-12-25 09:08:33','',''),(158,'1','306','1',1,'Retail Sale Id 151',4496.96,0.00,0.00,5.98,514.28,'2022-12-25 09:21:21','',''),(159,'1','306','1',1,'Retail Sale Id 152',4496.96,0.00,0.00,5.98,514.28,'2022-12-25 09:22:59','',''),(160,'1','306','1',1,'Retail Sale Id 153',3000.48,0.00,0.00,3.99,343.14,'2022-12-25 09:32:52','',''),(161,'1','306','1',1,'Retail Sale Id 154',3000.48,0.00,0.00,3.99,343.14,'2022-12-25 09:40:43','',''),(162,'1','306','1',1,'Retail Sale Id 155',3000.48,0.00,0.00,3.99,343.14,'2022-12-25 09:46:35','',''),(163,'1','306','1',1,'Retail Sale Id 156',1496.48,0.00,0.00,1.99,171.14,'2022-12-25 09:50:41','',''),(164,'1','306','1',1,'Retail Sale Id 157',2203.36,0.00,0.00,2.93,251.98,'2022-12-25 09:52:27','',''),(165,'1','306','1',1,'Retail Sale Id 158',5497.12,0.00,0.00,7.31,628.66,'2022-12-25 09:58:12','',''),(166,'1','306','1',1,'Retail Sale Id 159',7520.00,0.00,0.00,10.00,860.00,'2022-12-25 10:17:40','',''),(167,'1','306','1',1,'Retail Sale Id 160',4512.00,0.00,0.00,6.00,516.00,'2022-12-25 10:28:18','',''),(168,'1','306','1',1,'Retail Sale Id 161',4496.96,0.00,0.00,5.98,514.28,'2022-12-25 10:34:06','',''),(169,'1','306','1',1,'Retail Sale Id 162',9400.00,0.00,0.00,12.50,1075.00,'2022-12-25 10:36:42','',''),(170,'1','306','1',1,'Retail Sale Id 163',4512.00,0.00,0.00,6.00,516.00,'2022-12-25 10:42:24','',''),(171,'1','306','1',1,'Retail Sale Id 164',2248.48,0.00,0.00,2.99,257.14,'2022-12-25 10:55:32','',''),(172,'1','306','1',1,'Retail Sale Id 165',3000.48,0.00,0.00,3.99,343.14,'2022-12-25 11:02:21','',''),(173,'1','306','1',1,'Retail Sale Id 166',1000.16,0.00,0.00,1.33,114.38,'2022-12-25 11:03:45','',''),(174,'1','306','1',1,'Retail Sale Id 166',6000.96,0.00,0.00,7.98,686.28,'2022-12-25 11:03:45','',''),(175,'1','306','1',1,'Retail Sale Id 167',1496.48,0.00,0.00,1.99,171.14,'2022-12-25 11:04:53','',''),(176,'1','306','1',1,'Retail Sale Id 168',4496.96,0.00,0.00,5.98,514.28,'2022-12-25 11:17:59','',''),(177,'1','306','1',1,'Retail Sale Id 169',3000.48,0.00,0.00,3.99,343.14,'2022-12-25 11:20:32','',''),(178,'1','306','1',1,'Retail Sale Id 170',1496.48,0.00,0.00,1.99,171.14,'2022-12-25 11:34:21','',''),(179,'1','306','1',1,'Retail Sale Id 171',4496.96,0.00,0.00,5.98,514.28,'2022-12-25 11:38:20','',''),(180,'1','306','1',1,'Retail Sale Id 172',7520.00,0.00,0.00,10.00,860.00,'2022-12-25 11:46:29','',''),(181,'1','306','1',1,'Retail Sale Id 173',6000.96,0.00,0.00,7.98,686.28,'2022-12-25 11:49:34','',''),(182,'1','306','1',1,'Retail Sale Id 174',3797.60,0.00,0.00,5.05,434.30,'2022-12-25 11:51:42','',''),(183,'1','306','1',1,'Retail Sale Id 175',3000.48,0.00,0.00,3.99,343.14,'2022-12-25 11:52:59','',''),(184,'1','306','1',1,'Retail Sale Id 176',83520.00,0.00,0.00,116.00,6264.00,'2022-12-25 11:55:51','',''),(185,'1','306','1',1,'Retail Sale Id 177',4496.96,0.00,0.00,5.98,514.28,'2022-12-25 12:05:59','',''),(186,'1','306','1',1,'Retail Sale Id 178',3000.48,0.00,0.00,3.99,343.14,'2022-12-25 12:22:39','',''),(187,'1','306','1',1,'Retail Sale Id 179',4496.96,0.00,0.00,5.98,514.28,'2022-12-25 12:29:49','',''),(188,'1','306','1',1,'Retail Sale Id 180',9400.00,0.00,0.00,12.50,1075.00,'2022-12-25 12:38:59','',''),(189,'1','306','1',1,'Retail Sale Id 181',4496.96,0.00,0.00,5.98,514.28,'2022-12-25 12:51:46','',''),(190,'1','306','1',1,'Retail Sale Id 182',6000.96,0.00,0.00,7.98,686.28,'2022-12-25 13:13:23','',''),(191,'1','306','1',1,'Retail Sale Id 183',9400.00,0.00,0.00,12.50,1075.00,'2022-12-25 13:26:31','',''),(192,'1','306','1',1,'Retail Sale Id 184',29520.00,0.00,0.00,41.00,2214.00,'2022-12-25 13:29:45','',''),(193,'1','306','1',1,'Retail Sale Id 185',167040.00,0.00,0.00,232.00,12528.00,'2022-12-25 13:44:59','',''),(194,'1','306','1',1,'Retail Sale Id 186',3797.60,0.00,0.00,5.05,434.30,'2022-12-25 13:54:09','',''),(195,'1','306','1',1,'Retail Sale Id 188',2256.00,0.00,0.00,3.00,258.00,'2022-12-25 13:57:03','',''),(196,'1','306','1',1,'Retail Sale Id 188',2256.00,0.00,0.00,3.00,258.00,'2022-12-25 13:57:03','',''),(197,'1','306','1',1,'Retail Sale Id 189',797.12,0.00,0.00,1.06,91.16,'2022-12-25 13:59:50','',''),(198,'1','306','1',1,'Retail Sale Id 190',3000.48,0.00,0.00,3.99,343.14,'2022-12-25 14:11:47','',''),(199,'1','306','1',1,'Retail Sale Id 191',3496.80,0.00,0.00,4.65,399.90,'2022-12-25 14:12:52','',''),(200,'1','306','1',1,'Retail Sale Id 192',2000.32,0.00,0.00,2.66,228.76,'2022-12-25 14:27:41','',''),(201,'1','306','1',1,'Retail Sale Id 193',9302.24,0.00,0.00,12.37,1063.82,'2022-12-25 14:31:06','',''),(202,'1','306','1',1,'Retail Sale Id 194',3797.60,0.00,0.00,5.05,434.30,'2022-12-25 14:32:30','',''),(203,'1','306','1',1,'Retail Sale Id 195',2301.12,0.00,0.00,3.06,263.16,'2022-12-25 14:47:37','',''),(204,'1','306','1',1,'Retail Sale Id 196',2301.12,0.00,0.00,3.06,263.16,'2022-12-25 15:07:04','',''),(205,'1','306','1',1,'Retail Sale Id 199',721.92,0.00,0.00,0.96,82.56,'2022-12-25 15:11:14','',''),(206,'1','306','1',1,'Retail Sale Id 200',9400.00,0.00,0.00,12.50,1075.00,'2022-12-25 15:13:35','',''),(207,'1','306','1',1,'Retail Sale Id 201',9497.76,0.00,0.00,12.63,1086.18,'2022-12-25 15:14:45','',''),(208,'1','306','1',1,'Retail Sale Id 202',9400.00,0.00,0.00,12.50,1075.00,'2022-12-25 15:27:19','',''),(209,'1','306','1',1,'Retail Sale Id 203',1496.48,0.00,0.00,1.99,171.14,'2022-12-25 15:53:55','',''),(210,'1','306','1',1,'Retail Sale Id 204',2256.00,0.00,0.00,3.00,258.00,'2022-12-25 16:13:56','',''),(211,'1','306','1',1,'Retail Sale Id 204',4512.00,0.00,0.00,6.00,516.00,'2022-12-25 16:13:56','',''),(212,'1','306','1',1,'Retail Sale Id 205',3496.80,0.00,0.00,4.65,399.90,'2022-12-25 16:40:32','',''),(213,'1','306','1',1,'Retail Sale Id 208',3797.60,0.00,0.00,5.05,434.30,'2022-12-25 17:02:51','',''),(214,'1','306','1',1,'Retail Sale Id 209',9400.00,0.00,0.00,12.50,1075.00,'2022-12-25 17:08:11','',''),(215,'1','306','1',1,'Retail Sale Id 210',4496.96,0.00,0.00,5.98,514.28,'2022-12-25 17:18:00','',''),(216,'1','306','1',1,'Retail Sale Id 211',1173.60,0.00,0.00,1.63,88.02,'2022-12-25 18:16:22','',''),(217,'1','306','1',1,'Return of Retail Sale Id 211',0.00,1173.60,1.63,0.00,-88.02,'2022-12-25 18:18:16','',''),(218,'1','306','1',1,'Return of Retail Sale Id 185',0.00,167040.00,232.00,0.00,-12528.00,'2022-12-25 18:19:46','',''),(219,'1','306','1',1,'Retail Sale Id 212',165866.40,0.00,0.00,230.37,12439.98,'2022-12-25 18:21:10','',''),(220,'1','306','1',1,'Return of Retail Sale Id 210',0.00,4496.96,5.98,0.00,-514.28,'2022-12-25 18:22:17','',''),(221,'1','306','1',1,'Retail Sale Id 213',4512.00,0.00,0.00,6.00,516.00,'2022-12-25 18:23:56','',''),(222,'1','306','1',1,'Retail Sale Id 214',1504.00,0.00,0.00,2.00,172.00,'2022-12-26 08:02:18','',''),(223,'1','306','1',1,'Retail Sale Id 215',1496.48,0.00,0.00,1.99,171.14,'2022-12-26 08:03:35','',''),(224,'1','306','1',1,'Retail Sale Id 216',2210.88,0.00,0.00,2.94,252.84,'2022-12-26 08:04:57','',''),(225,'1','306','1',1,'Retail Sale Id 217',4496.96,0.00,0.00,5.98,514.28,'2022-12-26 08:10:13','',''),(226,'1','306','1',1,'Retail Sale Id 221',797.12,0.00,0.00,1.06,91.16,'2022-12-26 09:12:58','',''),(227,'1','306','1',1,'Retail Sale Id 222',24597.92,0.00,0.00,32.71,2813.06,'2022-12-26 09:43:08','',''),(228,'1','306','1',1,'Retail Sale Id 223',10302.40,0.00,0.00,13.70,1178.20,'2022-12-26 09:45:56','',''),(229,'1','306','1',1,'Retail Sale Id 224',2000.32,0.00,0.00,2.66,228.76,'2022-12-26 09:49:52','',''),(230,'1','306','1',1,'Retail Sale Id 225',9400.00,0.00,0.00,12.50,1075.00,'2022-12-26 09:53:52','',''),(231,'1','306','1',1,'Retail Sale Id 226',1000.16,0.00,0.00,1.33,114.38,'2022-12-26 10:05:37','',''),(232,'1','306','1',1,'Retail Sale Id 227',1496.48,0.00,0.00,1.99,171.14,'2022-12-26 10:09:07','',''),(233,'1','306','1',1,'Retail Sale Id 228',1496.48,0.00,0.00,1.99,171.14,'2022-12-26 10:24:42','',''),(234,'1','306','1',1,'Retail Sale Id 229',2256.00,0.00,0.00,3.00,258.00,'2022-12-26 10:26:11','',''),(235,'1','306','1',1,'Retail Sale Id 230',4496.96,0.00,0.00,5.98,514.28,'2022-12-26 10:27:25','',''),(236,'1','306','1',1,'Retail Sale Id 231',3760.00,0.00,0.00,5.00,430.00,'2022-12-26 10:29:22','',''),(237,'1','306','1',1,'Retail Sale Id 231',3760.00,0.00,0.00,5.00,430.00,'2022-12-26 10:29:22','',''),(238,'1','306','1',1,'Retail Sale Id 233',2398.88,0.00,0.00,3.19,274.34,'2022-12-26 10:33:58','',''),(239,'1','306','1',1,'Retail Sale Id 234',9400.00,0.00,0.00,12.50,1075.00,'2022-12-26 10:35:29','',''),(240,'1','306','1',1,'Retail Sale Id 235',2301.12,0.00,0.00,3.06,263.16,'2022-12-26 10:36:29','',''),(241,'1','306','1',1,'Retail Sale Id 236',43200.00,0.00,0.00,60.00,3240.00,'2022-12-26 10:40:15','',''),(242,'1','306','1',1,'Retail Sale Id 237',4496.96,0.00,0.00,5.98,514.28,'2022-12-26 10:42:26','',''),(243,'1','306','1',1,'Retail Sale Id 238',2000.32,0.00,0.00,2.66,228.76,'2022-12-26 10:43:48','',''),(244,'1','306','1',1,'Retail Sale Id 239',3000.48,0.00,0.00,3.99,343.14,'2022-12-26 10:45:07','',''),(245,'1','306','1',1,'Retail Sale Id 240',1496.48,0.00,0.00,1.99,171.14,'2022-12-26 10:47:18','',''),(246,'1','306','1',1,'Retail Sale Id 241',2248.48,0.00,0.00,2.99,257.14,'2022-12-26 10:48:33','',''),(247,'1','306','1',1,'Retail Sale Id 242',5301.60,0.00,0.00,7.05,606.30,'2022-12-26 10:51:34','',''),(248,'1','306','1',1,'Retail Sale Id 244',9001.44,0.00,0.00,11.97,1029.42,'2022-12-26 10:55:47','',''),(249,'1','306','1',1,'Retail Sale Id 245',5000.80,0.00,0.00,6.65,571.90,'2022-12-26 11:07:05','',''),(250,'1','306','1',1,'Retail Sale Id 246',2150.72,0.00,0.00,2.86,245.96,'2022-12-26 11:18:31','',''),(251,'1','306','1',1,'Retail Sale Id 247',4496.96,0.00,0.00,5.98,514.28,'2022-12-26 11:22:05','',''),(252,'1','306','1',1,'Retail Sale Id 248',7497.44,0.00,0.00,9.97,857.42,'2022-12-26 11:34:01','',''),(253,'1','306','1',1,'Retail Sale Id 249',5196.32,0.00,0.00,6.91,594.26,'2022-12-26 11:35:45','',''),(254,'1','306','1',1,'Retail Sale Id 250',6000.96,0.00,0.00,7.98,686.28,'2022-12-26 11:36:16','',''),(255,'1','306','1',1,'Retail Sale Id 251',4000.64,0.00,0.00,5.32,457.52,'2022-12-26 11:37:16','',''),(256,'1','306','1',1,'Retail Sale Id 252',1496.48,0.00,0.00,1.99,171.14,'2022-12-26 11:38:48','',''),(257,'1','306','1',1,'Retail Sale Id 254',2203.36,0.00,0.00,2.93,251.98,'2022-12-26 11:40:29','',''),(258,'1','306','1',1,'Retail Sale Id 255',2301.12,0.00,0.00,3.06,263.16,'2022-12-26 11:44:33','',''),(259,'1','306','1',1,'Retail Sale Id 256',240480.00,0.00,0.00,334.00,18036.00,'2022-12-26 11:54:15','',''),(260,'1','306','1',1,'Retail Sale Id 257',4496.96,0.00,0.00,5.98,514.28,'2022-12-26 11:59:54','',''),(261,'1','306','1',1,'Retail Sale Id 258',3760.00,0.00,0.00,5.00,430.00,'2022-12-26 12:01:34','',''),(262,'1','306','1',1,'Retail Sale Id 259',3797.60,0.00,0.00,5.05,434.30,'2022-12-26 12:02:49','',''),(263,'1','306','1',1,'Retail Sale Id 260',797.12,0.00,0.00,1.06,91.16,'2022-12-26 12:03:57','',''),(264,'1','306','1',1,'Retail Sale Id 261',4496.96,0.00,0.00,5.98,514.28,'2022-12-26 12:04:58','',''),(265,'1','306','1',1,'Retail Sale Id 262',4496.96,0.00,0.00,5.98,514.28,'2022-12-26 12:06:14','',''),(266,'1','306','1',1,'Retail Sale Id 263',1496.48,0.00,0.00,1.99,171.14,'2022-12-26 12:07:45','',''),(267,'1','306','1',1,'Retail Sale Id 265',4496.96,0.00,0.00,5.98,514.28,'2022-12-26 12:16:05','',''),(268,'1','306','1',1,'Retail Sale Id 266',1496.48,0.00,0.00,1.99,171.14,'2022-12-26 12:17:04','',''),(269,'1','306','1',1,'Retail Sale Id 267',3000.48,0.00,0.00,3.99,343.14,'2022-12-26 12:24:21','',''),(270,'1','306','1',1,'Retail Sale Id 268',9497.76,0.00,0.00,12.63,1086.18,'2022-12-26 12:26:27','',''),(271,'1','306','1',1,'Retail Sale Id 269',797.12,0.00,0.00,1.06,91.16,'2022-12-26 12:27:50','',''),(272,'1','306','1',1,'Retail Sale Id 270',1496.48,0.00,0.00,1.99,171.14,'2022-12-26 12:34:06','',''),(273,'1','306','1',1,'Retail Sale Id 271',797.12,0.00,0.00,1.06,91.16,'2022-12-26 12:35:25','',''),(274,'1','306','1',1,'Retail Sale Id 272',4496.96,0.00,0.00,5.98,514.28,'2022-12-26 12:37:53','',''),(275,'1','306','1',1,'Retail Sale Id 273',4496.96,0.00,0.00,5.98,514.28,'2022-12-26 12:58:15','',''),(276,'1','306','1',1,'Retail Sale Id 275',4512.00,0.00,0.00,6.00,516.00,'2022-12-26 13:07:49','',''),(277,'1','306','1',1,'Retail Sale Id 276',110544.00,0.00,0.00,147.00,12642.00,'2022-12-26 13:10:47','',''),(278,'1','306','1',1,'Retail Sale Id 277',699.36,0.00,0.00,0.93,79.98,'2022-12-26 13:15:26','',''),(279,'1','306','1',1,'Retail Sale Id 278',2301.12,0.00,0.00,3.06,263.16,'2022-12-26 13:24:28','',''),(280,'1','306','1',1,'Retail Sale Id 279',5000.80,0.00,0.00,6.65,571.90,'2022-12-26 13:32:12','',''),(281,'1','306','1',1,'Retail Sale Id 280',2398.88,0.00,0.00,3.19,274.34,'2022-12-26 13:33:44','',''),(282,'1','306','1',1,'Retail Sale Id 281',3008.00,0.00,0.00,4.00,344.00,'2022-12-26 14:03:35','',''),(283,'1','306','1',1,'Retail Sale Id 282',2203.36,0.00,0.00,2.93,251.98,'2022-12-26 14:11:03','',''),(284,'1','306','1',1,'Retail Sale Id 283',752.00,0.00,0.00,1.00,86.00,'2022-12-26 14:22:12','',''),(285,'1','306','1',1,'Retail Sale Id 284',2000.32,0.00,0.00,2.66,228.76,'2022-12-26 15:11:49','',''),(286,'1','306','1',1,'Retail Sale Id 285',1504.00,0.00,0.00,2.00,172.00,'2022-12-26 15:18:58','',''),(287,'1','306','1',1,'Retail Sale Id 286',1496.48,0.00,0.00,1.99,171.14,'2022-12-26 15:45:04','',''),(288,'1','306','1',1,'Retail Sale Id 287',1496.48,0.00,0.00,1.99,171.14,'2022-12-26 15:46:43','',''),(289,'1','306','1',1,'Retail Sale Id 288',2301.12,0.00,0.00,3.06,263.16,'2022-12-26 15:51:51','',''),(290,'1','306','1',1,'Retail Sale Id 289',3797.60,0.00,0.00,5.05,434.30,'2022-12-26 16:22:04','',''),(291,'1','306','1',1,'Retail Sale Id 290',4496.96,0.00,0.00,5.98,514.28,'2022-12-26 16:28:13','',''),(292,'1','306','1',1,'Retail Sale Id 292',226080.00,0.00,0.00,314.00,16956.00,'2022-12-26 16:39:07','',''),(293,'1','306','1',1,'Retail Sale Id 294',4512.00,0.00,0.00,6.00,516.00,'2022-12-26 16:41:54','',''),(294,'1','306','1',1,'Retail Sale Id 294',9024.00,0.00,0.00,12.00,1032.00,'2022-12-26 16:41:54','',''),(295,'1','306','1',1,'Retail Sale Id 295',3797.60,0.00,0.00,5.05,434.30,'2022-12-26 16:47:50','',''),(296,'1','306','1',1,'Retail Sale Id 296',6798.08,0.00,0.00,9.04,777.44,'2022-12-26 16:56:58','',''),(297,'1','306','1',1,'Retail Sale Id 297',4496.96,0.00,0.00,5.98,514.28,'2022-12-26 16:58:30','',''),(298,'1','306','1',1,'Retail Sale Id 298',1496.48,0.00,0.00,1.99,171.14,'2022-12-26 16:59:46','',''),(299,'1','306','1',1,'Retail Sale Id 299',4496.96,0.00,0.00,5.98,514.28,'2022-12-26 17:02:37','',''),(300,'1','306','1',1,'Retail Sale Id 300',2000.32,0.00,0.00,2.66,228.76,'2022-12-26 17:04:58','',''),(301,'1','306','1',1,'Retail Sale Id 300',4512.00,0.00,0.00,6.00,516.00,'2022-12-26 17:04:58','',''),(302,'1','306','1',1,'Retail Sale Id 301',5040.00,0.00,0.00,7.00,378.00,'2022-12-26 17:36:45','',''),(303,'1','306','1',1,'Retail Sale Id 303',18401.44,0.00,0.00,24.47,2104.42,'2022-12-26 18:15:47','',''),(304,'1','306','1',1,'Return of Retail Sale Id 303',0.00,18401.44,24.47,0.00,-2104.42,'2022-12-26 19:04:42','',''),(305,'1','306','1',1,'Retail Sale Id 304',10497.92,0.00,0.00,13.96,1200.56,'2022-12-26 19:05:52','',''),(306,'1','306','1',1,'Retail Sale Id 305',3647.20,0.00,0.00,4.85,417.10,'2022-12-27 07:59:53','',''),(307,'1','306','1',1,'Retail Sale Id 306',3008.00,0.00,0.00,4.00,344.00,'2022-12-27 08:08:46','',''),(308,'1','306','1',1,'Retail Sale Id 307',2256.00,0.00,0.00,3.00,258.00,'2022-12-27 08:20:35','',''),(309,'1','306','1',1,'Retail Sale Id 309',4496.96,0.00,0.00,5.98,514.28,'2022-12-27 08:23:41','',''),(310,'1','306','1',1,'Retail Sale Id 310',4000.64,0.00,0.00,5.32,457.52,'2022-12-27 08:33:05','',''),(311,'1','306','1',1,'Retail Sale Id 311',3000.48,0.00,0.00,3.99,343.14,'2022-12-27 08:55:51','',''),(312,'1','306','1',1,'Retail Sale Id 312',2248.48,0.00,0.00,2.99,257.14,'2022-12-27 08:58:48','',''),(313,'1','306','1',1,'Retail Sale Id 313',797.12,0.00,0.00,1.06,91.16,'2022-12-27 09:21:53','',''),(314,'1','306','1',1,'Retail Sale Id 314',3000.48,0.00,0.00,3.99,343.14,'2022-12-27 09:32:26','',''),(315,'1','306','1',1,'Retail Sale Id 315',2248.48,0.00,0.00,2.99,257.14,'2022-12-27 09:34:32','',''),(316,'1','306','1',1,'Retail Sale Id 316',797.12,0.00,0.00,1.06,91.16,'2022-12-27 09:37:22','',''),(317,'1','306','1',1,'Retail Sale Id 317',9400.00,0.00,0.00,12.50,1075.00,'2022-12-27 09:42:51','',''),(318,'1','306','1',1,'Retail Sale Id 318',1880.00,0.00,0.00,2.50,215.00,'2022-12-27 09:44:12','',''),(319,'1','306','1',1,'Retail Sale Id 319',9400.00,0.00,0.00,12.50,1075.00,'2022-12-27 09:45:54','',''),(320,'1','306','1',1,'Retail Sale Id 321',8272.00,0.00,0.00,11.00,946.00,'2022-12-27 09:57:29','',''),(321,'1','306','1',1,'Retail Sale Id 323',3797.60,0.00,0.00,5.05,434.30,'2022-12-27 10:03:45','',''),(322,'1','306','1',1,'Retail Sale Id 324',3760.00,0.00,0.00,5.00,430.00,'2022-12-27 10:05:36','',''),(323,'1','306','1',1,'Retail Sale Id 325',1496.48,0.00,0.00,1.99,171.14,'2022-12-27 10:13:02','',''),(324,'1','306','1',1,'Retail Sale Id 327',7520.00,0.00,0.00,10.00,860.00,'2022-12-27 10:27:40','',''),(325,'1','306','1',1,'Retail Sale Id 328',2301.12,0.00,0.00,3.06,263.16,'2022-12-27 10:29:38','',''),(326,'1','306','1',1,'Retail Sale Id 329',43200.00,0.00,0.00,60.00,3240.00,'2022-12-27 10:34:07','',''),(327,'1','306','1',1,'Retail Sale Id 331',1496.48,0.00,0.00,1.99,171.14,'2022-12-27 10:37:37','',''),(328,'1','306','1',1,'Retail Sale Id 332',3000.48,0.00,0.00,3.99,343.14,'2022-12-27 10:49:23','',''),(329,'1','306','1',1,'Retail Sale Id 334',9400.00,0.00,0.00,12.50,1075.00,'2022-12-27 12:31:46','',''),(330,'1','306','1',1,'Retail Sale Id 335',9400.00,0.00,0.00,12.50,1075.00,'2022-12-27 12:32:40','',''),(331,'1','306','1',1,'Retail Sale Id 336',30049.92,0.00,0.00,39.96,3436.56,'2022-12-27 12:36:06','',''),(332,'1','306','1',1,'Retail Sale Id 337',9400.00,0.00,0.00,12.50,1075.00,'2022-12-27 12:41:10','',''),(333,'1','306','1',1,'Retail Sale Id 338',797.12,0.00,0.00,1.06,91.16,'2022-12-27 12:42:00','',''),(334,'1','306','1',1,'Retail Sale Id 339',4496.96,0.00,0.00,5.98,514.28,'2022-12-27 12:49:42','',''),(335,'1','306','1',1,'Retail Sale Id 340',752.00,0.00,0.00,1.00,86.00,'2022-12-27 13:05:22','',''),(336,'1','306','1',1,'Retail Sale Id 341',752.00,0.00,0.00,1.00,86.00,'2022-12-27 13:40:50','',''),(337,'1','306','1',1,'Retail Sale Id 341',752.00,0.00,0.00,1.00,86.00,'2022-12-27 13:40:50','',''),(338,'1','306','1',1,'Retail Sale Id 342',1496.48,0.00,0.00,1.99,171.14,'2022-12-27 13:51:44','',''),(339,'1','306','1',1,'Retail Sale Id 343',4000.64,0.00,0.00,5.32,457.52,'2022-12-27 14:08:54','',''),(340,'1','306','1',1,'Retail Sale Id 344',2000.32,0.00,0.00,2.66,228.76,'2022-12-27 14:18:33','',''),(341,'1','306','1',1,'Retail Sale Id 345',3000.48,0.00,0.00,3.99,343.14,'2022-12-27 14:22:06','',''),(342,'1','306','1',1,'Retail Sale Id 346',3000.48,0.00,0.00,3.99,343.14,'2022-12-27 14:31:53','',''),(343,'1','306','1',1,'Retail Sale Id 346',3000.48,0.00,0.00,3.99,343.14,'2022-12-27 14:31:53','',''),(344,'1','306','1',1,'Retail Sale Id 347',2000.32,0.00,0.00,2.66,228.76,'2022-12-27 14:36:37','',''),(345,'1','306','1',1,'Retail Sale Id 348',1496.48,0.00,0.00,1.99,171.14,'2022-12-27 15:10:25','',''),(346,'1','306','1',1,'Retail Sale Id 349',797.12,0.00,0.00,1.06,91.16,'2022-12-27 15:29:45','',''),(347,'1','306','1',1,'Retail Sale Id 350',2203.36,0.00,0.00,2.93,251.98,'2022-12-27 15:53:42','',''),(348,'1','306','1',1,'Retail Sale Id 351',752.00,0.00,0.00,1.00,86.00,'2022-12-27 16:24:07','',''),(349,'1','306','1',1,'Retail Sale Id 352',3000.48,0.00,0.00,3.99,343.14,'2022-12-27 16:58:53','',''),(350,'1','306','1',1,'Retail Sale Id 353',4496.96,0.00,0.00,5.98,514.28,'2022-12-27 17:33:34','',''),(351,'1','306','1',1,'Return of Retail Sale Id 353',0.00,4496.96,5.98,0.00,-514.28,'2022-12-27 18:27:56','',''),(352,'1','306','1',1,'Retail Sale Id 354',4489.44,0.00,0.00,5.97,513.42,'2022-12-27 18:29:18','',''),(353,'1','306','1',1,'Retail Sale Id 355',2496.64,0.00,0.00,3.32,285.52,'2022-12-28 08:09:03','',''),(354,'1','306','1',1,'Retail Sale Id 356',40320.00,0.00,0.00,56.00,3024.00,'2022-12-28 08:13:10','',''),(355,'1','306','1',1,'Retail Sale Id 357',3000.48,0.00,0.00,3.99,343.14,'2022-12-28 09:04:12','',''),(356,'1','306','1',1,'Retail Sale Id 358',3797.60,0.00,0.00,5.05,434.30,'2022-12-28 09:07:37','',''),(357,'1','306','1',1,'Retail Sale Id 360',7497.44,0.00,0.00,9.97,857.42,'2022-12-28 09:29:08','',''),(358,'1','306','1',1,'Retail Sale Id 361',2256.00,0.00,0.00,3.00,258.00,'2022-12-28 09:54:56','',''),(359,'1','306','1',1,'Retail Sale Id 362',3098.24,0.00,0.00,4.12,354.32,'2022-12-28 10:04:59','',''),(360,'1','306','1',1,'Retail Sale Id 363',3000.48,0.00,0.00,3.99,343.14,'2022-12-28 10:15:21','',''),(361,'1','306','1',1,'Retail Sale Id 364',1504.00,0.00,0.00,2.00,172.00,'2022-12-28 10:28:56','',''),(362,'1','306','1',1,'Retail Sale Id 365',9400.00,0.00,0.00,12.50,1075.00,'2022-12-28 10:32:00','',''),(363,'1','306','1',1,'Retail Sale Id 366',109440.00,0.00,0.00,152.00,8208.00,'2022-12-28 10:39:40','',''),(364,'1','306','1',1,'Retail Sale Id 367',3008.00,0.00,0.00,4.00,344.00,'2022-12-28 10:55:19','',''),(365,'1','306','1',1,'Retail Sale Id 368',3797.60,0.00,0.00,5.05,434.30,'2022-12-28 11:17:10','',''),(366,'1','306','1',1,'Retail Sale Id 370',3008.00,0.00,0.00,4.00,344.00,'2022-12-28 11:41:37','',''),(367,'1','306','1',1,'Retail Sale Id 371',1504.00,0.00,0.00,2.00,172.00,'2022-12-28 11:43:28','',''),(368,'1','306','1',1,'Retail Sale Id 372',1496.48,0.00,0.00,1.99,171.14,'2022-12-28 11:54:18','',''),(369,'1','306','1',1,'Retail Sale Id 374',4496.96,0.00,0.00,5.98,514.28,'2022-12-28 12:02:24','',''),(370,'1','306','1',1,'Retail Sale Id 375',3000.48,0.00,0.00,3.99,343.14,'2022-12-28 12:17:41','',''),(371,'1','306','1',1,'Retail Sale Id 376',3000.48,0.00,0.00,3.99,343.14,'2022-12-28 12:47:34','',''),(372,'1','306','1',1,'Retail Sale Id 377',1504.00,0.00,0.00,2.00,172.00,'2022-12-28 12:51:42','',''),(373,'1','306','1',1,'Retail Sale Id 378',4496.96,0.00,0.00,5.98,514.28,'2022-12-28 13:44:30','',''),(374,'1','306','1',1,'Retail Sale Id 379',2301.12,0.00,0.00,3.06,263.16,'2022-12-28 13:45:46','',''),(375,'1','306','1',1,'Retail Sale Id 380',9400.00,0.00,0.00,12.50,1075.00,'2022-12-28 14:55:57','',''),(376,'1','306','1',1,'Retail Sale Id 381',2203.36,0.00,0.00,2.93,251.98,'2022-12-28 14:59:22','',''),(377,'1','306','1',1,'Retail Sale Id 382',2496.64,0.00,0.00,3.32,285.52,'2022-12-28 15:47:15','',''),(378,'1','306','1',1,'Retail Sale Id 383',3797.60,0.00,0.00,5.05,434.30,'2022-12-28 16:39:29','',''),(379,'1','306','1',1,'Retail Sale Id 384',3797.60,0.00,0.00,5.05,434.30,'2022-12-28 16:43:05','',''),(380,'1','306','1',1,'Retail Sale Id 385',4301.44,0.00,0.00,5.72,491.92,'2022-12-28 16:44:43','',''),(381,'1','306','1',1,'Retail Sale Id 386',7497.44,0.00,0.00,9.97,857.42,'2022-12-28 16:51:52','',''),(382,'1','306','1',1,'Retail Sale Id 387',36000.00,0.00,0.00,50.00,2700.00,'2022-12-28 17:28:13','',''),(383,'1','306','1',1,'Retail Sale Id 388',4512.00,0.00,0.00,6.00,516.00,'2022-12-28 17:44:17','',''),(384,'1','306','1',1,'Retail Sale Id 389',4496.96,0.00,0.00,5.98,514.28,'2022-12-28 17:46:25','',''),(385,'1','306','1',1,'Retail Sale Id 390',1496.48,0.00,0.00,1.99,171.14,'2022-12-28 17:54:38','',''),(386,'1','306','1',1,'Retail Sale Id 391',4496.96,0.00,0.00,5.98,514.28,'2022-12-28 18:01:19','',''),(387,'1','306','1',1,'Retail Sale Id 392',3008.00,0.00,0.00,4.00,344.00,'2022-12-28 18:04:25','',''),(388,'1','306','1',1,'Retail Sale Id 393',3000.48,0.00,0.00,3.99,343.14,'2022-12-28 18:12:06','',''),(389,'1','306','1',1,'Retail Sale Id 394',2534.24,0.00,0.00,3.37,289.82,'2022-12-28 18:40:53','',''),(390,'1','306','1',1,'Retail Sale Id 395',2256.00,0.00,0.00,3.00,258.00,'2022-12-29 07:39:52','',''),(391,'1','306','1',1,'Retail Sale Id 396',2496.64,0.00,0.00,3.32,285.52,'2022-12-29 07:40:24','',''),(392,'1','306','1',1,'Retail Sale Id 397',752.00,0.00,0.00,1.00,86.00,'2022-12-29 07:54:30','',''),(393,'1','306','1',1,'Retail Sale Id 398',797.12,0.00,0.00,1.06,91.16,'2022-12-29 08:20:39','',''),(394,'1','306','1',1,'Retail Sale Id 399',4496.96,0.00,0.00,5.98,514.28,'2022-12-29 08:30:50','',''),(395,'1','306','1',1,'Retail Sale Id 400',4000.64,0.00,0.00,5.32,457.52,'2022-12-29 08:49:53','',''),(396,'1','306','1',1,'Retail Sale Id 401',3008.00,0.00,0.00,4.00,344.00,'2022-12-29 09:17:08','',''),(397,'1','306','1',1,'Retail Sale Id 402',3496.80,0.00,0.00,4.65,399.90,'2022-12-29 09:23:40','',''),(398,'1','306','1',1,'Retail Sale Id 403',9497.76,0.00,0.00,12.63,1086.18,'2022-12-29 09:25:47','',''),(399,'1','306','1',1,'Retail Sale Id 404',3496.80,0.00,0.00,4.65,399.90,'2022-12-29 09:41:02','',''),(400,'1','306','1',1,'Retail Sale Id 405',4496.96,0.00,0.00,5.98,514.28,'2022-12-29 09:42:52','',''),(401,'1','306','1',1,'Retail Sale Id 407',4000.64,0.00,0.00,5.32,457.52,'2022-12-29 09:47:53','',''),(402,'1','306','1',1,'Retail Sale Id 408',4496.96,0.00,0.00,5.98,514.28,'2022-12-29 09:53:11','',''),(403,'1','306','1',1,'Retail Sale Id 409',2203.36,0.00,0.00,2.93,251.98,'2022-12-29 09:59:02','',''),(404,'1','306','1',1,'Retail Sale Id 410',6000.96,0.00,0.00,7.98,686.28,'2022-12-29 10:00:12','',''),(405,'1','306','1',1,'Retail Sale Id 411',2496.64,0.00,0.00,3.32,285.52,'2022-12-29 10:19:31','',''),(406,'1','306','1',1,'Retail Sale Id 412',3496.80,0.00,0.00,4.65,399.90,'2022-12-29 10:34:25','',''),(407,'1','306','1',1,'Retail Sale Id 413',797.12,0.00,0.00,1.06,91.16,'2022-12-29 10:51:12','',''),(408,'1','306','1',1,'Retail Sale Id 415',6016.00,0.00,0.00,8.00,688.00,'2022-12-29 10:54:52','',''),(409,'1','306','1',1,'Retail Sale Id 416',9497.76,0.00,0.00,12.63,1086.18,'2022-12-29 10:56:27','',''),(410,'1','306','1',1,'Retail Sale Id 417',1000.16,0.00,0.00,1.33,114.38,'2022-12-29 10:57:36','',''),(411,'1','306','1',1,'Retail Sale Id 418',3008.00,0.00,0.00,4.00,344.00,'2022-12-29 10:59:50','',''),(412,'1','306','1',1,'Retail Sale Id 419',2256.00,0.00,0.00,3.00,258.00,'2022-12-29 11:01:00','',''),(413,'1','306','1',1,'Retail Sale Id 419',3760.00,0.00,0.00,5.00,430.00,'2022-12-29 11:01:00','',''),(414,'1','306','1',1,'Retail Sale Id 421',28800.00,0.00,0.00,40.00,2160.00,'2022-12-29 11:17:28','',''),(415,'1','306','1',1,'Retail Sale Id 422',9196.96,0.00,0.00,12.23,1051.78,'2022-12-29 11:20:10','',''),(416,'1','306','1',1,'Retail Sale Id 423',797.12,0.00,0.00,1.06,91.16,'2022-12-29 11:25:26','',''),(417,'1','306','1',1,'Retail Sale Id 424',3699.84,0.00,0.00,4.92,423.12,'2022-12-29 12:01:44','',''),(418,'1','306','1',1,'Retail Sale Id 425',2301.12,0.00,0.00,3.06,263.16,'2022-12-29 12:04:01','',''),(419,'1','306','1',1,'Retail Sale Id 426',9497.76,0.00,0.00,12.63,1086.18,'2022-12-29 13:13:32','',''),(420,'1','306','1',1,'Retail Sale Id 427',2248.48,0.00,0.00,2.99,257.14,'2022-12-29 13:14:03','',''),(421,'1','306','1',1,'Retail Sale Id 428',5497.12,0.00,0.00,7.31,628.66,'2022-12-29 13:14:38','',''),(422,'1','306','1',1,'Retail Sale Id 429',4496.96,0.00,0.00,5.98,514.28,'2022-12-29 13:16:28','',''),(423,'1','306','1',1,'Retail Sale Id 430',3000.48,0.00,0.00,3.99,343.14,'2022-12-29 13:30:54','',''),(424,'1','306','1',1,'Retail Sale Id 431',4549.60,0.00,0.00,6.05,520.30,'2022-12-29 13:44:44','',''),(425,'1','306','1',1,'Retail Sale Id 432',9400.00,0.00,0.00,12.50,1075.00,'2022-12-29 14:20:39','',''),(426,'1','306','1',1,'Retail Sale Id 433',2301.12,0.00,0.00,3.06,263.16,'2022-12-29 14:31:43','',''),(427,'1','306','1',1,'Retail Sale Id 434',2256.00,0.00,0.00,3.00,258.00,'2022-12-29 14:32:49','',''),(428,'1','306','1',1,'Retail Sale Id 435',4496.96,0.00,0.00,5.98,514.28,'2022-12-29 14:42:11','',''),(429,'1','306','1',1,'Retail Sale Id 437',3008.00,0.00,0.00,4.00,344.00,'2022-12-29 14:49:14','',''),(430,'1','306','1',1,'Retail Sale Id 438',1496.48,0.00,0.00,1.99,171.14,'2022-12-29 15:04:07','',''),(431,'1','306','1',1,'Retail Sale Id 439',2256.00,0.00,0.00,3.00,258.00,'2022-12-29 15:08:07','',''),(432,'1','306','1',1,'Retail Sale Id 440',2301.12,0.00,0.00,3.06,263.16,'2022-12-29 15:21:01','',''),(433,'1','306','1',1,'Retail Sale Id 441',2301.12,0.00,0.00,3.06,263.16,'2022-12-29 15:26:06','',''),(434,'1','306','1',1,'Retail Sale Id 444',4496.96,0.00,0.00,5.98,514.28,'2022-12-29 15:51:28','',''),(435,'1','306','1',1,'Retail Sale Id 446',4602.24,0.00,0.00,6.12,526.32,'2022-12-29 16:16:28','',''),(436,'1','306','1',1,'Retail Sale Id 447',2248.48,0.00,0.00,2.99,257.14,'2022-12-29 16:42:05','',''),(437,'1','306','1',1,'Retail Sale Id 448',1496.48,0.00,0.00,1.99,171.14,'2022-12-29 16:43:08','',''),(438,'1','306','1',1,'Retail Sale Id 449',9400.00,0.00,0.00,12.50,1075.00,'2022-12-29 16:44:15','',''),(439,'1','306','1',1,'Retail Sale Id 451',2248.48,0.00,0.00,2.99,257.14,'2022-12-29 16:48:30','',''),(440,'1','306','1',1,'Retail Sale Id 452',3797.60,0.00,0.00,5.05,434.30,'2022-12-29 16:54:05','',''),(441,'1','306','1',1,'Retail Sale Id 453',6000.96,0.00,0.00,7.98,686.28,'2022-12-29 16:58:31','',''),(442,'1','306','1',1,'Retail Sale Id 454',2248.48,0.00,0.00,2.99,257.14,'2022-12-29 17:02:54','',''),(443,'1','306','1',1,'Retail Sale Id 455',1496.48,0.00,0.00,1.99,171.14,'2022-12-29 17:04:37','',''),(444,'1','306','1',1,'Retail Sale Id 456',2256.00,0.00,0.00,3.00,258.00,'2022-12-29 17:10:34','',''),(445,'1','306','1',1,'Retail Sale Id 457',4496.96,0.00,0.00,5.98,514.28,'2022-12-29 17:44:44','',''),(446,'1','306','1',1,'Retail Sale Id 458',4496.96,0.00,0.00,5.98,514.28,'2022-12-29 17:52:01','',''),(447,'1','306','1',1,'Retail Sale Id 459',1496.48,0.00,0.00,1.99,171.14,'2022-12-29 18:00:19','',''),(448,'1','306','1',1,'Return of Retail Sale Id 458',0.00,4496.96,5.98,0.00,-514.28,'2022-12-29 18:20:08','',''),(449,'1','306','1',1,'Return of Retail Sale Id 457',0.00,4496.96,5.98,0.00,-514.28,'2022-12-29 18:21:05','',''),(450,'1','306','1',1,'Retail Sale Id 460',3188.48,0.00,0.00,4.24,364.64,'2022-12-29 18:22:30','',''),(451,'1','306','1',1,'Retail Sale Id 461',2301.12,0.00,0.00,3.06,263.16,'2022-12-30 08:14:48','',''),(452,'1','306','1',1,'Retail Sale Id 462',4496.96,0.00,0.00,5.98,514.28,'2022-12-30 08:15:49','',''),(453,'1','306','1',1,'Retail Sale Id 463',1496.48,0.00,0.00,1.99,171.14,'2022-12-30 08:19:12','',''),(454,'1','306','1',1,'Retail Sale Id 465',4496.96,0.00,0.00,5.98,514.28,'2022-12-30 09:08:50','',''),(455,'1','306','1',1,'Retail Sale Id 466',1880.00,0.00,0.00,2.50,215.00,'2022-12-30 09:09:55','',''),(456,'1','306','1',1,'Return of Retail Sale Id 466',0.00,1880.00,2.50,0.00,-215.00,'2022-12-30 09:11:25','',''),(457,'1','306','1',1,'Retail Sale Id 467',2000.32,0.00,0.00,2.66,228.76,'2022-12-30 09:12:33','',''),(458,'1','306','1',1,'Retail Sale Id 468',2000.32,0.00,0.00,2.66,228.76,'2022-12-30 09:13:43','',''),(459,'1','306','1',1,'Retail Sale Id 469',9400.00,0.00,0.00,12.50,1075.00,'2022-12-30 09:15:13','',''),(460,'1','306','1',1,'Retail Sale Id 470',797.12,0.00,0.00,1.06,91.16,'2022-12-30 09:20:56','',''),(461,'1','306','1',1,'Retail Sale Id 471',1496.48,0.00,0.00,1.99,171.14,'2022-12-30 09:27:29','',''),(462,'1','306','1',1,'Retail Sale Id 473',5248.96,0.00,0.00,6.98,600.28,'2022-12-30 09:31:08','',''),(463,'1','306','1',1,'Retail Sale Id 474',2256.00,0.00,0.00,3.00,258.00,'2022-12-30 09:37:52','',''),(464,'1','306','1',1,'Retail Sale Id 474',2256.00,0.00,0.00,3.00,258.00,'2022-12-30 09:37:52','',''),(465,'1','306','1',1,'Retail Sale Id 475',90000.00,0.00,0.00,125.00,6750.00,'2022-12-30 10:22:10','',''),(466,'1','306','1',1,'Retail Sale Id 476',752.00,0.00,0.00,1.00,86.00,'2022-12-30 10:23:21','',''),(467,'1','306','1',1,'Retail Sale Id 477',1496.48,0.00,0.00,1.99,171.14,'2022-12-30 10:24:16','',''),(468,'1','306','1',1,'Retail Sale Id 478',3797.60,0.00,0.00,5.05,434.30,'2022-12-30 10:30:30','',''),(469,'1','306','1',1,'Retail Sale Id 479',2256.00,0.00,0.00,3.00,258.00,'2022-12-30 10:35:28','',''),(470,'1','306','1',1,'Retail Sale Id 480',2256.00,0.00,0.00,3.00,258.00,'2022-12-30 10:37:09','',''),(471,'1','306','1',1,'Retail Sale Id 481',4496.96,0.00,0.00,5.98,514.28,'2022-12-30 10:41:25','',''),(472,'1','306','1',1,'Retail Sale Id 482',4496.96,0.00,0.00,5.98,514.28,'2022-12-30 10:49:47','',''),(473,'1','306','1',1,'Retail Sale Id 483',4496.96,0.00,0.00,5.98,514.28,'2022-12-30 10:50:40','',''),(474,'1','306','1',1,'Retail Sale Id 484',9400.00,0.00,0.00,12.50,1075.00,'2022-12-30 11:06:47','',''),(475,'1','306','1',1,'Retail Sale Id 485',28800.00,0.00,0.00,40.00,2160.00,'2022-12-30 11:20:46','',''),(476,'1','306','1',1,'Retail Sale Id 486',3000.48,0.00,0.00,3.99,343.14,'2022-12-30 11:35:01','',''),(477,'1','306','1',1,'Retail Sale Id 487',26011.68,0.00,0.00,34.59,2974.74,'2022-12-30 12:13:48','',''),(478,'1','306','1',1,'Retail Sale Id 488',1880.00,0.00,0.00,2.50,215.00,'2022-12-30 12:40:35','',''),(479,'1','306','1',1,'Retail Sale Id 489',7520.00,0.00,0.00,10.00,860.00,'2022-12-30 12:51:20','',''),(480,'1','306','1',1,'Retail Sale Id 490',2632.00,0.00,0.00,3.50,301.00,'2022-12-30 13:03:49','',''),(481,'1','306','1',1,'Retail Sale Id 491',699.36,0.00,0.00,0.93,79.98,'2022-12-30 13:31:12','',''),(482,'1','306','1',1,'Retail Sale Id 492',1496.48,0.00,0.00,1.99,171.14,'2022-12-30 13:31:59','',''),(483,'1','306','1',1,'Retail Sale Id 493',2301.12,0.00,0.00,3.06,263.16,'2022-12-30 13:41:53','',''),(484,'1','306','1',1,'Retail Sale Id 494',4000.64,0.00,0.00,5.32,457.52,'2022-12-30 13:50:10','',''),(485,'1','306','1',1,'Retail Sale Id 495',2301.12,0.00,0.00,3.06,263.16,'2022-12-30 14:21:58','',''),(486,'1','306','1',1,'Retail Sale Id 496',2496.64,0.00,0.00,3.32,285.52,'2022-12-30 14:22:52','',''),(487,'1','306','1',1,'Retail Sale Id 497',2000.32,0.00,0.00,2.66,228.76,'2022-12-30 14:37:51','',''),(488,'1','306','1',1,'Retail Sale Id 498',7520.00,0.00,0.00,10.00,860.00,'2022-12-30 14:58:15','',''),(489,'1','306','1',1,'Retail Sale Id 499',6000.96,0.00,0.00,7.98,686.28,'2022-12-30 15:04:54','',''),(490,'1','306','1',1,'Retail Sale Id 501',6392.00,0.00,0.00,8.50,731.00,'2022-12-30 15:28:51','',''),(491,'1','306','1',1,'Retail Sale Id 502',2301.12,0.00,0.00,3.06,263.16,'2022-12-30 15:39:31','',''),(492,'1','306','1',1,'Retail Sale Id 503',1496.48,0.00,0.00,1.99,171.14,'2022-12-30 15:50:36','',''),(493,'1','306','1',1,'Retail Sale Id 504',1511.52,0.00,0.00,2.01,172.86,'2022-12-30 15:56:02','',''),(494,'1','306','1',1,'Retail Sale Id 505',4496.96,0.00,0.00,5.98,514.28,'2022-12-30 16:16:11','',''),(495,'1','306','1',1,'Retail Sale Id 506',1496.48,0.00,0.00,1.99,171.14,'2022-12-30 16:33:46','',''),(496,'1','306','1',1,'Retail Sale Id 507',4496.96,0.00,0.00,5.98,514.28,'2022-12-30 16:50:20','',''),(497,'1','306','1',1,'Retail Sale Id 508',797.12,0.00,0.00,1.06,91.16,'2022-12-30 16:51:12','',''),(498,'1','306','1',1,'Retail Sale Id 509',7497.44,0.00,0.00,9.97,857.42,'2022-12-30 16:52:48','',''),(499,'1','306','1',1,'Retail Sale Id 510',1000.16,0.00,0.00,1.33,114.38,'2022-12-30 17:25:46','',''),(500,'1','306','1',1,'Retail Sale Id 511',4549.60,0.00,0.00,6.05,520.30,'2022-12-30 17:31:26','',''),(501,'1','306','1',1,'Retail Sale Id 512',2301.12,0.00,0.00,3.06,263.16,'2022-12-30 17:41:58','',''),(502,'1','306','1',1,'Retail Sale Id 513',4496.96,0.00,0.00,5.98,514.28,'2022-12-30 17:45:54','',''),(503,'1','306','1',1,'Retail Sale Id 515',3760.00,0.00,0.00,5.00,430.00,'2022-12-30 17:56:57','',''),(504,'1','306','1',1,'Return of Retail Sale Id 512',0.00,2301.12,3.06,0.00,-263.16,'2022-12-30 18:24:52','',''),(505,'1','306','1',1,'Retail Sale Id 516',2158.24,0.00,0.00,2.87,246.82,'2022-12-30 18:26:01','',''),(506,'1','306','1',1,'Retail Sale Id 517',3797.60,0.00,0.00,5.05,434.30,'2022-12-31 07:46:29','',''),(507,'1','306','1',1,'Retail Sale Id 518',2301.12,0.00,0.00,3.06,263.16,'2022-12-31 07:55:55','',''),(508,'1','306','1',1,'Retail Sale Id 519',5000.80,0.00,0.00,6.65,571.90,'2022-12-31 07:57:05','',''),(509,'1','306','1',1,'Retail Sale Id 520',4496.96,0.00,0.00,5.98,514.28,'2022-12-31 08:03:21','',''),(510,'1','306','1',1,'Retail Sale Id 521',2256.00,0.00,0.00,3.00,258.00,'2022-12-31 08:05:33','',''),(511,'1','306','1',1,'Retail Sale Id 522',2256.00,0.00,0.00,3.00,258.00,'2022-12-31 08:06:43','',''),(512,'1','306','1',1,'Retail Sale Id 523',3760.00,0.00,0.00,5.00,430.00,'2022-12-31 08:27:43','',''),(513,'1','306','1',1,'Retail Sale Id 523',7520.00,0.00,0.00,10.00,860.00,'2022-12-31 08:27:43','',''),(514,'1','306','1',1,'Retail Sale Id 524',9000.00,0.00,0.00,12.50,675.00,'2022-12-31 08:29:24','',''),(515,'1','306','1',1,'Retail Sale Id 525',1000.16,0.00,0.00,1.33,114.38,'2022-12-31 08:34:57','',''),(516,'1','306','1',1,'Retail Sale Id 526',2301.12,0.00,0.00,3.06,263.16,'2022-12-31 08:36:12','',''),(517,'1','306','1',1,'Retail Sale Id 527',1496.48,0.00,0.00,1.99,171.14,'2022-12-31 08:39:55','',''),(518,'1','306','1',1,'Retail Sale Id 528',4496.96,0.00,0.00,5.98,514.28,'2022-12-31 08:58:42','',''),(519,'1','306','1',1,'Retail Sale Id 530',1496.48,0.00,0.00,1.99,171.14,'2022-12-31 09:25:50','',''),(520,'1','306','1',1,'Retail Sale Id 531',9400.00,0.00,0.00,12.50,1075.00,'2022-12-31 09:33:26','',''),(521,'1','306','1',1,'Retail Sale Id 532',10800.00,0.00,0.00,15.00,810.00,'2022-12-31 09:41:06','',''),(522,'1','306','1',1,'Retail Sale Id 533',1496.48,0.00,0.00,1.99,171.14,'2022-12-31 09:42:23','',''),(523,'1','306','1',1,'Retail Sale Id 534',3000.48,0.00,0.00,3.99,343.14,'2022-12-31 09:43:41','',''),(524,'1','306','1',1,'Retail Sale Id 535',2301.12,0.00,0.00,3.06,263.16,'2022-12-31 09:45:04','',''),(525,'1','306','1',1,'Retail Sale Id 536',5000.80,0.00,0.00,6.65,571.90,'2022-12-31 09:46:56','',''),(526,'1','306','1',1,'Retail Sale Id 537',2301.12,0.00,0.00,3.06,263.16,'2022-12-31 09:51:18','',''),(527,'1','306','1',1,'Retail Sale Id 538',2301.12,0.00,0.00,3.06,263.16,'2022-12-31 09:57:29','',''),(528,'1','306','1',1,'Retail Sale Id 539',4496.96,0.00,0.00,5.98,514.28,'2022-12-31 10:03:53','',''),(529,'1','306','1',1,'Retail Sale Id 540',1496.48,0.00,0.00,1.99,171.14,'2022-12-31 10:09:37','',''),(530,'1','306','1',1,'Retail Sale Id 541',4496.96,0.00,0.00,5.98,514.28,'2022-12-31 10:10:38','',''),(531,'1','306','1',1,'Return of Retail Sale Id 534',0.00,3000.48,3.99,0.00,-343.14,'2022-12-31 10:15:16','',''),(532,'1','306','1',1,'Retail Sale Id 542',4496.96,0.00,0.00,5.98,514.28,'2022-12-31 10:25:39','',''),(533,'1','306','1',1,'Retail Sale Id 543',2301.12,0.00,0.00,3.06,263.16,'2022-12-31 10:33:19','',''),(534,'1','306','1',1,'Retail Sale Id 544',3797.60,0.00,0.00,5.05,434.30,'2022-12-31 10:35:15','',''),(535,'1','306','1',1,'Retail Sale Id 545',3797.60,0.00,0.00,5.05,434.30,'2022-12-31 10:36:45','',''),(536,'1','306','1',1,'Retail Sale Id 546',4496.96,0.00,0.00,5.98,514.28,'2022-12-31 10:37:47','',''),(537,'1','306','1',1,'Retail Sale Id 547',1496.48,0.00,0.00,1.99,171.14,'2022-12-31 10:57:54','',''),(538,'1','306','1',1,'Retail Sale Id 548',4496.96,0.00,0.00,5.98,514.28,'2022-12-31 11:00:34','',''),(539,'1','306','1',1,'Retail Sale Id 549',3000.48,0.00,0.00,3.99,343.14,'2022-12-31 11:03:16','',''),(540,'1','306','1',1,'Retail Sale Id 550',797.12,0.00,0.00,1.06,91.16,'2022-12-31 11:31:42','',''),(541,'1','306','1',1,'Retail Sale Id 551',2301.12,0.00,0.00,3.06,263.16,'2022-12-31 11:39:11','',''),(542,'1','306','1',1,'Retail Sale Id 552',752.00,0.00,0.00,1.00,86.00,'2022-12-31 12:11:24','',''),(543,'1','306','1',1,'Retail Sale Id 553',797.12,0.00,0.00,1.06,91.16,'2022-12-31 12:32:07','',''),(544,'1','306','1',1,'Retail Sale Id 554',1496.48,0.00,0.00,1.99,171.14,'2022-12-31 12:36:57','',''),(545,'1','306','1',1,'Retail Sale Id 555',2301.12,0.00,0.00,3.06,263.16,'2022-12-31 12:48:49','',''),(546,'1','306','1',1,'Retail Sale Id 556',2496.64,0.00,0.00,3.32,285.52,'2022-12-31 12:52:51','',''),(547,'1','306','1',1,'Retail Sale Id 557',7920.00,0.00,0.00,11.00,594.00,'2022-12-31 12:57:13','',''),(548,'1','306','1',1,'Retail Sale Id 558',3000.48,0.00,0.00,3.99,343.14,'2022-12-31 13:31:01','',''),(549,'1','306','1',1,'Retail Sale Id 560',6016.00,0.00,0.00,8.00,688.00,'2022-12-31 13:32:51','',''),(550,'1','306','1',1,'Retail Sale Id 561',2256.00,0.00,0.00,3.00,258.00,'2022-12-31 13:34:01','',''),(551,'1','306','1',1,'Retail Sale Id 562',1496.48,0.00,0.00,1.99,171.14,'2022-12-31 14:01:34','',''),(552,'1','306','1',1,'Retail Sale Id 563',2000.32,0.00,0.00,2.66,228.76,'2022-12-31 14:02:16','',''),(553,'1','306','1',1,'Retail Sale Id 564',1496.48,0.00,0.00,1.99,171.14,'2022-12-31 14:08:26','',''),(554,'1','306','1',1,'Retail Sale Id 565',2301.12,0.00,0.00,3.06,263.16,'2022-12-31 14:09:48','',''),(555,'1','306','1',1,'Retail Sale Id 566',4320.00,0.00,0.00,6.00,324.00,'2022-12-31 14:11:51','',''),(556,'1','306',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,3028302.00,4547.00,0.00,0.00,'2022-12-31 14:22:49','',''),(557,'1','306',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,4547.00,0.00,'2022-12-31 14:25:19','',''),(558,'1','306','1',1,'Received from bridging 2',0.00,0.00,4547.00,0.00,0.00,'2022-12-31 14:25:19','',''),(559,'1','306','1',1,'Retail Sale Id 567',4512.00,0.00,0.00,6.00,516.00,'2022-12-31 14:53:51','',''),(560,'1','306','1',1,'Retail Sale Id 568',2301.12,0.00,0.00,3.06,263.16,'2022-12-31 14:54:42','',''),(561,'1','306','1',1,'Retail Sale Id 569',3496.80,0.00,0.00,4.65,399.90,'2022-12-31 14:55:32','',''),(562,'1','306','1',1,'Retail Sale Id 570',3008.00,0.00,0.00,4.00,344.00,'2022-12-31 14:56:51','',''),(563,'1','306','1',1,'Retail Sale Id 571',2496.64,0.00,0.00,3.32,285.52,'2022-12-31 14:59:26','',''),(564,'1','306','1',1,'Retail Sale Id 572',1000.16,0.00,0.00,1.33,114.38,'2022-12-31 15:02:41','',''),(565,'1','306','1',1,'Return of Retail Sale Id 572',0.00,1000.16,1.33,0.00,-114.38,'2022-12-31 15:04:26','',''),(566,'1','306','1',1,'Retail Sale Id 573',902.40,0.00,0.00,1.20,103.20,'2022-12-31 15:05:01','',''),(567,'1','306','1',1,'Retail Sale Id 574',43200.00,0.00,0.00,60.00,3240.00,'2022-12-31 15:06:16','',''),(568,'1','306','1',1,'Retail Sale Id 575',1496.48,0.00,0.00,1.99,171.14,'2022-12-31 15:12:30','',''),(569,'1','306','1',1,'Retail Sale Id 576',2301.12,0.00,0.00,3.06,263.16,'2022-12-31 15:15:56','',''),(570,'1','306','1',1,'Retail Sale Id 577',2256.00,0.00,0.00,3.00,258.00,'2022-12-31 15:17:38','',''),(571,'1','306','1',1,'Retail Sale Id 577',4512.00,0.00,0.00,6.00,516.00,'2022-12-31 15:17:38','',''),(572,'1','306','1',1,'Retail Sale Id 578',3008.00,0.00,0.00,4.00,344.00,'2022-12-31 15:19:20','',''),(573,'1','306','1',1,'Retail Sale Id 579',2301.12,0.00,0.00,3.06,263.16,'2022-12-31 15:23:08','',''),(574,'1','306','1',1,'Retail Sale Id 580',1549.12,0.00,0.00,2.06,177.16,'2022-12-31 15:24:12','',''),(575,'1','306','1',1,'Retail Sale Id 581',2203.36,0.00,0.00,2.93,251.98,'2022-12-31 15:29:15','',''),(576,'1','306','1',1,'Retail Sale Id 582',1504.00,0.00,0.00,2.00,172.00,'2022-12-31 15:31:51','',''),(577,'1','306','1',1,'Retail Sale Id 583',1496.48,0.00,0.00,1.99,171.14,'2022-12-31 15:38:34','',''),(578,'1','306','1',1,'Retail Sale Id 584',2256.00,0.00,0.00,3.00,258.00,'2022-12-31 15:52:19','',''),(579,'1','306','1',1,'Retail Sale Id 585',3760.00,0.00,0.00,5.00,430.00,'2022-12-31 15:54:39','',''),(580,'1','306','1',1,'Retail Sale Id 586',3008.00,0.00,0.00,4.00,344.00,'2022-12-31 15:57:25','',''),(581,'1','306','1',1,'Retail Sale Id 586',3760.00,0.00,0.00,5.00,430.00,'2022-12-31 15:57:25','',''),(582,'1','306','1',1,'Retail Sale Id 587',1496.48,0.00,0.00,1.99,171.14,'2022-12-31 15:58:26','',''),(583,'1','306','1',1,'Retail Sale Id 588',3797.60,0.00,0.00,5.05,434.30,'2022-12-31 15:59:37','',''),(584,'1','306','1',1,'Retail Sale Id 589',2256.00,0.00,0.00,3.00,258.00,'2022-12-31 16:00:47','',''),(585,'1','306','1',1,'Retail Sale Id 590',4496.96,0.00,0.00,5.98,514.28,'2022-12-31 16:09:43','',''),(586,'1','306','1',1,'Retail Sale Id 591',1496.48,0.00,0.00,1.99,171.14,'2022-12-31 16:12:17','',''),(587,'1','306','1',1,'Retail Sale Id 592',43200.00,0.00,0.00,60.00,3240.00,'2022-12-31 16:17:17','',''),(588,'1','306','1',1,'Retail Sale Id 593',4000.64,0.00,0.00,5.32,457.52,'2022-12-31 16:27:20','',''),(589,'1','306','1',1,'Retail Sale Id 594',9400.00,0.00,0.00,12.50,1075.00,'2022-12-31 16:29:13','',''),(590,'1','306','1',1,'Retail Sale Id 594',9400.00,0.00,0.00,12.50,1075.00,'2022-12-31 16:29:13','',''),(591,'1','306','1',1,'Retail Sale Id 595',2256.00,0.00,0.00,3.00,258.00,'2022-12-31 16:30:45','',''),(592,'1','306','1',1,'Retail Sale Id 596',2496.64,0.00,0.00,3.32,285.52,'2022-12-31 16:34:15','',''),(593,'1','306','1',1,'Retail Sale Id 597',797.12,0.00,0.00,1.06,91.16,'2022-12-31 16:37:04','',''),(594,'1','306','1',1,'Retail Sale Id 598',4496.96,0.00,0.00,5.98,514.28,'2022-12-31 16:38:21','',''),(595,'1','306','1',1,'Retail Sale Id 599',2301.12,0.00,0.00,3.06,263.16,'2022-12-31 16:42:26','',''),(596,'1','306','1',1,'Retail Sale Id 600',4512.00,0.00,0.00,6.00,516.00,'2022-12-31 16:43:33','',''),(597,'1','306','1',1,'Retail Sale Id 601',3797.60,0.00,0.00,5.05,434.30,'2022-12-31 16:49:08','',''),(598,'1','306','1',1,'Retail Sale Id 602',7497.44,0.00,0.00,9.97,857.42,'2022-12-31 16:52:11','',''),(599,'1','306','1',1,'Retail Sale Id 603',2496.64,0.00,0.00,3.32,285.52,'2022-12-31 17:10:00','',''),(600,'1','306','1',1,'Retail Sale Id 604',3496.80,0.00,0.00,4.65,399.90,'2022-12-31 17:11:29','',''),(601,'1','306','1',1,'Retail Sale Id 605',9400.00,0.00,0.00,12.50,1075.00,'2022-12-31 17:34:12','',''),(602,'1','306','1',1,'Retail Sale Id 607',3008.00,0.00,0.00,4.00,344.00,'2022-12-31 17:37:36','',''),(603,'1','306','1',1,'Retail Sale Id 607',3760.00,0.00,0.00,5.00,430.00,'2022-12-31 17:37:36','',''),(604,'1','306','1',1,'Retail Sale Id 608',1496.48,0.00,0.00,1.99,171.14,'2022-12-31 17:39:21','',''),(605,'1','306','1',1,'Retail Sale Id 610',1504.00,0.00,0.00,2.00,172.00,'2022-12-31 17:40:47','',''),(606,'1','306','1',1,'Retail Sale Id 611',4512.00,0.00,0.00,6.00,516.00,'2022-12-31 17:42:21','',''),(607,'1','306','1',1,'Retail Sale Id 612',2248.48,0.00,0.00,2.99,257.14,'2022-12-31 17:43:43','',''),(608,'1','306','1',1,'Retail Sale Id 613',2301.12,0.00,0.00,3.06,263.16,'2022-12-31 17:44:57','',''),(609,'1','306','1',1,'Retail Sale Id 614',4496.96,0.00,0.00,5.98,514.28,'2022-12-31 17:50:44','',''),(610,'1','306','1',1,'Retail Sale Id 615',3496.80,0.00,0.00,4.65,399.90,'2022-12-31 17:55:16','',''),(611,'1','306','1',1,'Retail Sale Id 616',9400.00,0.00,0.00,12.50,1075.00,'2022-12-31 17:57:44','',''),(612,'1','306','1',1,'Retail Sale Id 617',4512.00,0.00,0.00,6.00,516.00,'2022-12-31 17:59:27','',''),(613,'1','306','1',1,'Retail Sale Id 618',2000.32,0.00,0.00,2.66,228.76,'2022-12-31 18:06:49','',''),(614,'1','306','1',1,'Return of Retail Sale Id 616',0.00,9400.00,12.50,0.00,-1075.00,'2022-12-31 18:24:27','',''),(615,'1','306','1',1,'Retail Sale Id 619',8978.88,0.00,0.00,11.94,1026.84,'2022-12-31 18:26:27','',''),(616,'1','306','1',1,'Retail Sale Id 620',3008.00,0.00,0.00,4.00,344.00,'2023-01-01 08:06:57','',''),(617,'1','306','1',1,'Retail Sale Id 621',1000.16,0.00,0.00,1.33,114.38,'2023-01-01 08:10:50','',''),(618,'1','306','1',1,'Retail Sale Id 622',4496.96,0.00,0.00,5.98,514.28,'2023-01-01 08:24:43','',''),(619,'1','306','1',1,'Retail Sale Id 623',2256.00,0.00,0.00,3.00,258.00,'2023-01-01 08:36:28','',''),(620,'1','306','1',1,'Retail Sale Id 624',3008.00,0.00,0.00,4.00,344.00,'2023-01-01 08:47:04','',''),(621,'1','306','1',1,'Retail Sale Id 625',35280.00,0.00,0.00,49.00,2646.00,'2023-01-01 08:52:48','',''),(622,'1','306','1',1,'Retail Sale Id 626',3000.48,0.00,0.00,3.99,343.14,'2023-01-01 09:13:14','',''),(623,'1','306','1',1,'Retail Sale Id 627',3000.48,0.00,0.00,3.99,343.14,'2023-01-01 09:15:53','',''),(624,'1','306','1',1,'Retail Sale Id 628',1496.48,0.00,0.00,1.99,171.14,'2023-01-01 09:29:23','',''),(625,'1','306','1',1,'Retail Sale Id 629',4496.96,0.00,0.00,5.98,514.28,'2023-01-01 09:34:12','',''),(626,'1','306','1',1,'Retail Sale Id 630',7520.00,0.00,0.00,10.00,860.00,'2023-01-01 10:00:38','',''),(627,'1','306','1',1,'Retail Sale Id 631',6016.00,0.00,0.00,8.00,688.00,'2023-01-01 10:02:33','',''),(628,'1','306','1',1,'Retail Sale Id 632',9400.00,0.00,0.00,12.50,1075.00,'2023-01-01 10:04:18','',''),(629,'1','306','1',1,'Retail Sale Id 633',4496.96,0.00,0.00,5.98,514.28,'2023-01-01 10:10:07','',''),(630,'1','306','1',1,'Retail Sale Id 634',1000.16,0.00,0.00,1.33,114.38,'2023-01-01 10:12:05','',''),(631,'1','306','1',1,'Retail Sale Id 635',4496.96,0.00,0.00,5.98,514.28,'2023-01-01 10:13:54','',''),(632,'1','306','1',1,'Retail Sale Id 636',2496.64,0.00,0.00,3.32,285.52,'2023-01-01 10:15:06','',''),(633,'1','306','1',1,'Retail Sale Id 637',2301.12,0.00,0.00,3.06,263.16,'2023-01-01 10:17:33','',''),(634,'1','306','1',1,'Retail Sale Id 638',9400.00,0.00,0.00,12.50,1075.00,'2023-01-01 10:18:27','',''),(635,'1','306','1',1,'Retail Sale Id 639',1496.48,0.00,0.00,1.99,171.14,'2023-01-01 10:29:54','',''),(636,'1','306','1',1,'Retail Sale Id 640',2000.32,0.00,0.00,2.66,228.76,'2023-01-01 10:32:57','',''),(637,'1','306','1',1,'Retail Sale Id 641',3000.48,0.00,0.00,3.99,343.14,'2023-01-01 10:38:09','',''),(638,'1','306','1',1,'Retail Sale Id 642',4496.96,0.00,0.00,5.98,514.28,'2023-01-01 10:39:15','',''),(639,'1','306','1',1,'Retail Sale Id 643',3008.00,0.00,0.00,4.00,344.00,'2023-01-01 10:45:52','',''),(640,'1','306','1',1,'Retail Sale Id 644',2000.32,0.00,0.00,2.66,228.76,'2023-01-01 10:51:57','',''),(641,'1','306','1',1,'Retail Sale Id 646',1504.00,0.00,0.00,2.00,172.00,'2023-01-01 11:07:24','',''),(642,'1','306','1',1,'Retail Sale Id 646',3760.00,0.00,0.00,5.00,430.00,'2023-01-01 11:07:24','',''),(643,'1','306','1',1,'Retail Sale Id 647',3797.60,0.00,0.00,5.05,434.30,'2023-01-01 11:09:05','',''),(644,'1','306','1',1,'Retail Sale Id 648',2699.68,0.00,0.00,3.59,308.74,'2023-01-01 11:10:30','',''),(645,'1','306','1',1,'Retail Sale Id 649',3760.00,0.00,0.00,5.00,430.00,'2023-01-01 11:14:24','',''),(646,'1','306','1',1,'Retail Sale Id 650',9400.00,0.00,0.00,12.50,1075.00,'2023-01-01 11:19:18','',''),(647,'1','306','1',1,'Retail Sale Id 651',1496.48,0.00,0.00,1.99,171.14,'2023-01-01 11:26:25','',''),(648,'1','306','1',1,'Retail Sale Id 652',797.12,0.00,0.00,1.06,91.16,'2023-01-01 11:31:35','',''),(649,'1','306','1',1,'Retail Sale Id 653',1496.48,0.00,0.00,1.99,171.14,'2023-01-01 11:32:59','',''),(650,'1','306','1',1,'Retail Sale Id 654',797.12,0.00,0.00,1.06,91.16,'2023-01-01 11:34:52','',''),(651,'1','306','1',1,'Retail Sale Id 655',9497.76,0.00,0.00,12.63,1086.18,'2023-01-01 11:40:47','',''),(652,'1','306','1',1,'Retail Sale Id 656',797.12,0.00,0.00,1.06,91.16,'2023-01-01 11:49:09','',''),(653,'1','306','1',1,'Retail Sale Id 658',9497.76,0.00,0.00,12.63,1086.18,'2023-01-01 11:55:47','',''),(654,'1','306','1',1,'Retail Sale Id 659',9400.00,0.00,0.00,12.50,1075.00,'2023-01-01 12:13:20','',''),(655,'1','306','1',1,'Retail Sale Id 660',3797.60,0.00,0.00,5.05,434.30,'2023-01-01 12:14:23','',''),(656,'1','306','1',1,'Retail Sale Id 661',4496.96,0.00,0.00,5.98,514.28,'2023-01-01 12:15:27','',''),(657,'1','306','1',1,'Retail Sale Id 663',1000.16,0.00,0.00,1.33,114.38,'2023-01-01 12:16:46','',''),(658,'1','306','1',1,'Retail Sale Id 664',9400.00,0.00,0.00,12.50,1075.00,'2023-01-01 12:20:10','',''),(659,'1','306','1',1,'Retail Sale Id 665',7520.00,0.00,0.00,10.00,860.00,'2023-01-01 12:24:14','',''),(660,'1','306','1',1,'Retail Sale Id 666',2301.12,0.00,0.00,3.06,263.16,'2023-01-01 12:31:25','',''),(661,'1','306','1',1,'Retail Sale Id 667',3053.12,0.00,0.00,4.06,349.16,'2023-01-01 12:32:57','',''),(662,'1','306','1',1,'Retail Sale Id 668',3008.00,0.00,0.00,4.00,344.00,'2023-01-01 12:34:57','',''),(663,'1','306','1',1,'Retail Sale Id 669',4512.00,0.00,0.00,6.00,516.00,'2023-01-01 12:36:13','',''),(664,'1','306','1',1,'Retail Sale Id 670',1496.48,0.00,0.00,1.99,171.14,'2023-01-01 12:48:15','',''),(665,'1','306','1',1,'Retail Sale Id 671',4496.96,0.00,0.00,5.98,514.28,'2023-01-01 12:52:31','',''),(666,'1','306','1',1,'Retail Sale Id 672',1496.48,0.00,0.00,1.99,171.14,'2023-01-01 13:05:28','',''),(667,'1','306','1',1,'Retail Sale Id 673',3760.00,0.00,0.00,5.00,430.00,'2023-01-01 13:08:20','',''),(668,'1','306','1',1,'Retail Sale Id 674',3797.60,0.00,0.00,5.05,434.30,'2023-01-01 13:09:28','',''),(669,'1','306','1',1,'Retail Sale Id 675',3000.48,0.00,0.00,3.99,343.14,'2023-01-01 13:17:16','',''),(670,'1','306','1',1,'Retail Sale Id 676',2353.76,0.00,0.00,3.13,269.18,'2023-01-01 13:22:04','',''),(671,'1','306','1',1,'Retail Sale Id 677',6000.96,0.00,0.00,7.98,686.28,'2023-01-01 13:26:08','',''),(672,'1','306','1',1,'Retail Sale Id 678',4496.96,0.00,0.00,5.98,514.28,'2023-01-01 13:27:13','',''),(673,'1','306','1',1,'Retail Sale Id 679',4000.64,0.00,0.00,5.32,457.52,'2023-01-01 13:28:23','',''),(674,'1','306','1',1,'Retail Sale Id 680',4496.96,0.00,0.00,5.98,514.28,'2023-01-01 13:29:27','',''),(675,'1','306','1',1,'Retail Sale Id 681',2256.00,0.00,0.00,3.00,258.00,'2023-01-01 13:31:18','',''),(676,'1','306','1',1,'Retail Sale Id 682',2301.12,0.00,0.00,3.06,263.16,'2023-01-01 13:36:22','',''),(677,'1','306','1',1,'Retail Sale Id 683',2797.44,0.00,0.00,3.72,319.92,'2023-01-01 13:38:44','',''),(678,'1','306','1',1,'Retail Sale Id 684',4496.96,0.00,0.00,5.98,514.28,'2023-01-01 13:41:19','',''),(679,'1','306','1',1,'Retail Sale Id 685',9400.00,0.00,0.00,12.50,1075.00,'2023-01-01 13:48:32','',''),(680,'1','306','1',1,'Retail Sale Id 686',9497.76,0.00,0.00,12.63,1086.18,'2023-01-01 13:51:19','',''),(681,'1','306','1',1,'Retail Sale Id 687',1496.48,0.00,0.00,1.99,171.14,'2023-01-01 14:09:51','',''),(682,'1','306','1',1,'Retail Sale Id 688',1496.48,0.00,0.00,1.99,171.14,'2023-01-01 14:21:22','',''),(683,'1','306','1',1,'Retail Sale Id 689',1000.16,0.00,0.00,1.33,114.38,'2023-01-01 14:23:38','',''),(684,'1','306','1',1,'Retail Sale Id 690',752.00,0.00,0.00,1.00,86.00,'2023-01-01 14:35:14','',''),(685,'1','306','1',1,'Retail Sale Id 690',752.00,0.00,0.00,1.00,86.00,'2023-01-01 14:35:14','',''),(686,'1','306','1',1,'Retail Sale Id 691',4496.96,0.00,0.00,5.98,514.28,'2023-01-01 14:39:57','',''),(687,'1','306','1',1,'Retail Sale Id 692',9497.76,0.00,0.00,12.63,1086.18,'2023-01-01 14:46:48','',''),(688,'1','306','1',1,'Retail Sale Id 693',9400.00,0.00,0.00,12.50,1075.00,'2023-01-01 15:12:57','',''),(689,'1','306','1',1,'Retail Sale Id 694',18800.00,0.00,0.00,25.00,2150.00,'2023-01-01 15:15:43','',''),(690,'1','306','1',1,'Retail Sale Id 695',10001.60,0.00,0.00,13.30,1143.80,'2023-01-01 15:16:55','',''),(691,'1','306','1',1,'Retail Sale Id 696',699.36,0.00,0.00,0.93,79.98,'2023-01-01 15:21:38','',''),(692,'1','306','1',1,'Retail Sale Id 697',9497.76,0.00,0.00,12.63,1086.18,'2023-01-01 15:32:56','',''),(693,'1','306','1',1,'Retail Sale Id 698',1496.48,0.00,0.00,1.99,171.14,'2023-01-01 15:41:58','',''),(694,'1','306','1',1,'Retail Sale Id 699',4203.68,0.00,0.00,5.59,480.74,'2023-01-01 16:04:31','',''),(695,'1','306','1',1,'Retail Sale Id 700',9400.00,0.00,0.00,12.50,1075.00,'2023-01-01 16:17:26','',''),(696,'1','306','1',1,'Retail Sale Id 701',797.12,0.00,0.00,1.06,91.16,'2023-01-01 16:25:03','',''),(697,'1','306','1',1,'Retail Sale Id 702',9400.00,0.00,0.00,12.50,1075.00,'2023-01-01 16:29:23','',''),(698,'1','306','1',1,'Retail Sale Id 703',3797.60,0.00,0.00,5.05,434.30,'2023-01-01 16:32:14','',''),(699,'1','306','1',1,'Retail Sale Id 704',4512.00,0.00,0.00,6.00,516.00,'2023-01-01 16:44:45','',''),(700,'1','306','1',1,'Retail Sale Id 705',4000.64,0.00,0.00,5.32,457.52,'2023-01-01 16:52:01','',''),(701,'1','306','1',1,'Retail Sale Id 706',9400.00,0.00,0.00,12.50,1075.00,'2023-01-01 17:01:10','',''),(702,'1','306','1',1,'Retail Sale Id 707',2301.12,0.00,0.00,3.06,263.16,'2023-01-01 17:24:38','',''),(703,'1','306','1',1,'Retail Sale Id 708',797.12,0.00,0.00,1.06,91.16,'2023-01-01 17:32:58','',''),(704,'1','306','1',1,'Retail Sale Id 709',9400.00,0.00,0.00,12.50,1075.00,'2023-01-01 18:07:32','',''),(705,'1','306','1',1,'Return of Retail Sale Id 709',0.00,9400.00,12.50,0.00,-1075.00,'2023-01-01 18:12:05','',''),(706,'1','306','1',1,'Retail Sale Id 710',8941.28,0.00,0.00,11.89,1022.54,'2023-01-01 18:13:13','',''),(707,'1','306','1',1,'Retail Sale Id 711',4496.96,0.00,0.00,5.98,514.28,'2023-01-02 08:26:36','',''),(708,'1','306','1',1,'Retail Sale Id 712',3000.48,0.00,0.00,3.99,343.14,'2023-01-02 08:33:07','',''),(709,'1','306','1',1,'Retail Sale Id 713',4496.96,0.00,0.00,5.98,514.28,'2023-01-02 08:34:31','',''),(710,'1','306','1',1,'Retail Sale Id 714',1496.48,0.00,0.00,1.99,171.14,'2023-01-02 08:41:31','',''),(711,'1','306','1',1,'Retail Sale Id 715',9497.76,0.00,0.00,12.63,1086.18,'2023-01-02 08:55:00','',''),(712,'1','306','1',1,'Retail Sale Id 716',4512.00,0.00,0.00,6.00,516.00,'2023-01-02 08:57:38','',''),(713,'1','306','1',1,'Retail Sale Id 717',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 09:02:18','',''),(714,'1','306','1',1,'Retail Sale Id 718',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 09:20:01','',''),(715,'1','306','1',1,'Retail Sale Id 719',3496.80,0.00,0.00,4.65,399.90,'2023-01-02 09:25:31','',''),(716,'1','306','1',1,'Retail Sale Id 720',43200.00,0.00,0.00,60.00,3240.00,'2023-01-02 09:31:57','',''),(717,'1','306','1',1,'Retail Sale Id 721',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 09:33:30','',''),(718,'1','306','1',1,'Retail Sale Id 722',1496.48,0.00,0.00,1.99,171.14,'2023-01-02 09:36:24','',''),(719,'1','306','1',1,'Retail Sale Id 723',797.12,0.00,0.00,1.06,91.16,'2023-01-02 09:41:56','',''),(720,'1','306','1',1,'Retail Sale Id 724',1496.48,0.00,0.00,1.99,171.14,'2023-01-02 09:43:10','',''),(721,'1','306','1',1,'Retail Sale Id 725',2301.12,0.00,0.00,3.06,263.16,'2023-01-02 09:56:53','',''),(722,'1','306','1',1,'Retail Sale Id 726',1496.48,0.00,0.00,1.99,171.14,'2023-01-02 09:58:00','',''),(723,'1','306','1',1,'Retail Sale Id 727',4496.96,0.00,0.00,5.98,514.28,'2023-01-02 09:59:00','',''),(724,'1','306','1',1,'Retail Sale Id 728',2301.12,0.00,0.00,3.06,263.16,'2023-01-02 10:08:28','',''),(725,'1','306','1',1,'Retail Sale Id 730',3797.60,0.00,0.00,5.05,434.30,'2023-01-02 10:13:11','',''),(726,'1','306','1',1,'Retail Sale Id 731',4496.96,0.00,0.00,5.98,514.28,'2023-01-02 10:14:17','',''),(727,'1','306','1',1,'Retail Sale Id 732',3797.60,0.00,0.00,5.05,434.30,'2023-01-02 10:20:56','',''),(728,'1','306','1',1,'Retail Sale Id 733',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 10:30:02','',''),(729,'1','306','1',1,'Retail Sale Id 734',4496.96,0.00,0.00,5.98,514.28,'2023-01-02 10:33:13','',''),(730,'1','306','1',1,'Retail Sale Id 735',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 10:36:17','',''),(731,'1','306','1',1,'Retail Sale Id 736',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 10:37:15','',''),(732,'1','306','1',1,'Retail Sale Id 737',4512.00,0.00,0.00,6.00,516.00,'2023-01-02 10:41:00','',''),(733,'1','306','1',1,'Retail Sale Id 737',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 10:41:00','',''),(734,'1','306','1',1,'Retail Sale Id 738',2496.64,0.00,0.00,3.32,285.52,'2023-01-02 10:42:03','',''),(735,'1','306','1',1,'Retail Sale Id 739',7497.44,0.00,0.00,9.97,857.42,'2023-01-02 10:42:56','',''),(736,'1','306','1',1,'Retail Sale Id 740',5248.96,0.00,0.00,6.98,600.28,'2023-01-02 10:44:10','',''),(737,'1','306','1',1,'Retail Sale Id 741',2601.92,0.00,0.00,3.46,297.56,'2023-01-02 10:45:40','',''),(738,'1','306','1',1,'Retail Sale Id 742',18000.00,0.00,0.00,25.00,1350.00,'2023-01-02 10:47:03','',''),(739,'1','306','1',1,'Retail Sale Id 743',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 10:48:26','',''),(740,'1','306','1',1,'Retail Sale Id 744',2496.64,0.00,0.00,3.32,285.52,'2023-01-02 10:49:55','',''),(741,'1','306','1',1,'Retail Sale Id 745',3797.60,0.00,0.00,5.05,434.30,'2023-01-02 10:51:15','',''),(742,'1','306','1',1,'Retail Sale Id 746',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 10:52:23','',''),(743,'1','306','1',1,'Retail Sale Id 747',4496.96,0.00,0.00,5.98,514.28,'2023-01-02 10:53:23','',''),(744,'1','306','1',1,'Retail Sale Id 748',3797.60,0.00,0.00,5.05,434.30,'2023-01-02 10:54:30','',''),(745,'1','306','1',1,'Retail Sale Id 751',2000.32,0.00,0.00,2.66,228.76,'2023-01-02 10:59:05','',''),(746,'1','306','1',1,'Retail Sale Id 751',4000.64,0.00,0.00,5.32,457.52,'2023-01-02 10:59:05','',''),(747,'1','306','1',1,'Retail Sale Id 752',226080.00,0.00,0.00,314.00,16956.00,'2023-01-02 11:04:45','',''),(748,'1','306','1',1,'Retail Sale Id 753',3797.60,0.00,0.00,5.05,434.30,'2023-01-02 11:05:41','',''),(749,'1','306','1',1,'Retail Sale Id 754',43200.00,0.00,0.00,60.00,3240.00,'2023-01-02 11:07:48','',''),(750,'1','306','1',1,'Retail Sale Id 755',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 11:09:43','',''),(751,'1','306','1',1,'Retail Sale Id 756',41760.00,0.00,0.00,58.00,3132.00,'2023-01-02 11:11:22','',''),(752,'1','306','1',1,'Retail Sale Id 757',1496.48,0.00,0.00,1.99,171.14,'2023-01-02 11:12:34','',''),(753,'1','306','1',1,'Retail Sale Id 758',4496.96,0.00,0.00,5.98,514.28,'2023-01-02 11:13:42','',''),(754,'1','306','1',1,'Retail Sale Id 759',2301.12,0.00,0.00,3.06,263.16,'2023-01-02 11:15:57','',''),(755,'1','306','1',1,'Retail Sale Id 760',3752.48,0.00,0.00,4.99,429.14,'2023-01-02 11:17:11','',''),(756,'1','306','1',1,'Retail Sale Id 761',2301.12,0.00,0.00,3.06,263.16,'2023-01-02 11:18:17','',''),(757,'1','306','1',1,'Retail Sale Id 762',2301.12,0.00,0.00,3.06,263.16,'2023-01-02 11:19:27','',''),(758,'1','306','1',1,'Retail Sale Id 763',5301.60,0.00,0.00,7.05,606.30,'2023-01-02 11:20:54','',''),(759,'1','306','1',1,'Retail Sale Id 764',10080.00,0.00,0.00,14.00,756.00,'2023-01-02 11:22:29','',''),(760,'1','306','1',1,'Retail Sale Id 765',2256.00,0.00,0.00,3.00,258.00,'2023-01-02 11:25:08','',''),(761,'1','306','1',1,'Retail Sale Id 766',4519.52,0.00,0.00,6.01,516.86,'2023-01-02 11:30:01','',''),(762,'1','306','1',1,'Retail Sale Id 767',1496.48,0.00,0.00,1.99,171.14,'2023-01-02 11:31:05','',''),(763,'1','306','1',1,'Retail Sale Id 768',4000.64,0.00,0.00,5.32,457.52,'2023-01-02 11:32:54','',''),(764,'1','306','1',1,'Retail Sale Id 768',6000.96,0.00,0.00,7.98,686.28,'2023-01-02 11:32:54','',''),(765,'1','306','1',1,'Retail Sale Id 769',68400.00,0.00,0.00,95.00,5130.00,'2023-01-02 11:42:54','',''),(766,'1','306','1',1,'Retail Sale Id 770',2256.00,0.00,0.00,3.00,258.00,'2023-01-02 11:46:14','',''),(767,'1','306','1',1,'Retail Sale Id 770',2256.00,0.00,0.00,3.00,258.00,'2023-01-02 11:46:14','',''),(768,'1','306','1',1,'Retail Sale Id 771',2301.12,0.00,0.00,3.06,263.16,'2023-01-02 11:47:38','',''),(769,'1','306','1',1,'Retail Sale Id 772',9497.76,0.00,0.00,12.63,1086.18,'2023-01-02 11:48:37','',''),(770,'1','306','1',1,'Retail Sale Id 773',4512.00,0.00,0.00,6.00,516.00,'2023-01-02 11:50:53','',''),(771,'1','306','1',1,'Retail Sale Id 774',3797.60,0.00,0.00,5.05,434.30,'2023-01-02 11:52:47','',''),(772,'1','306','1',1,'Retail Sale Id 775',7520.00,0.00,0.00,10.00,860.00,'2023-01-02 12:05:47','',''),(773,'1','306','1',1,'Retail Sale Id 776',4512.00,0.00,0.00,6.00,516.00,'2023-01-02 12:08:55','',''),(774,'1','306','1',1,'Retail Sale Id 777',2301.12,0.00,0.00,3.06,263.16,'2023-01-02 12:34:23','',''),(775,'1','306','1',1,'Retail Sale Id 778',105840.00,0.00,0.00,147.00,7938.00,'2023-01-02 12:48:39','',''),(776,'1','306','1',1,'Retail Sale Id 780',9798.56,0.00,0.00,13.03,1120.58,'2023-01-02 13:01:57','',''),(777,'1','306','1',1,'Retail Sale Id 781',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 13:03:35','',''),(778,'1','306','1',1,'Retail Sale Id 782',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 13:04:19','',''),(779,'1','306','1',1,'Retail Sale Id 783',2000.32,0.00,0.00,2.66,228.76,'2023-01-02 13:12:55','',''),(780,'1','306','1',1,'Retail Sale Id 784',7497.44,0.00,0.00,9.97,857.42,'2023-01-02 13:14:00','',''),(781,'1','306','1',1,'Retail Sale Id 785',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 13:18:05','',''),(782,'1','306','1',1,'Retail Sale Id 786',3000.48,0.00,0.00,3.99,343.14,'2023-01-02 13:21:26','',''),(783,'1','306','1',1,'Retail Sale Id 787',4512.00,0.00,0.00,6.00,516.00,'2023-01-02 13:28:14','',''),(784,'1','306','1',1,'Retail Sale Id 788',41760.00,0.00,0.00,58.00,3132.00,'2023-01-02 13:30:29','',''),(785,'1','306','1',1,'Retail Sale Id 789',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 13:34:32','',''),(786,'1','306','1',1,'Retail Sale Id 791',6000.96,0.00,0.00,7.98,686.28,'2023-01-02 13:36:45','',''),(787,'1','306','1',1,'Retail Sale Id 792',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 13:46:52','',''),(788,'1','306','1',1,'Retail Sale Id 793',2301.12,0.00,0.00,3.06,263.16,'2023-01-02 13:48:21','',''),(789,'1','306','1',1,'Retail Sale Id 794',3797.60,0.00,0.00,5.05,434.30,'2023-01-02 13:49:42','',''),(790,'1','306','1',1,'Retail Sale Id 795',4496.96,0.00,0.00,5.98,514.28,'2023-01-02 13:59:44','',''),(791,'1','306','1',1,'Retail Sale Id 796',2256.00,0.00,0.00,3.00,258.00,'2023-01-02 14:00:44','',''),(792,'1','306','1',1,'Retail Sale Id 797',3000.48,0.00,0.00,3.99,343.14,'2023-01-02 14:01:56','',''),(793,'1','306','1',1,'Retail Sale Id 798',699.36,0.00,0.00,0.93,79.98,'2023-01-02 14:08:25','',''),(794,'1','306','1',1,'Retail Sale Id 799',1496.48,0.00,0.00,1.99,171.14,'2023-01-02 14:10:52','',''),(795,'1','306','1',1,'Retail Sale Id 800',4496.96,0.00,0.00,5.98,514.28,'2023-01-02 14:11:54','',''),(796,'1','306','1',1,'Retail Sale Id 801',1496.48,0.00,0.00,1.99,171.14,'2023-01-02 14:12:46','',''),(797,'1','306','1',1,'Retail Sale Id 802',4496.96,0.00,0.00,5.98,514.28,'2023-01-02 14:16:59','',''),(798,'1','306','1',1,'Retail Sale Id 803',3008.00,0.00,0.00,4.00,344.00,'2023-01-02 14:19:47','',''),(799,'1','306','1',1,'Retail Sale Id 804',1496.48,0.00,0.00,1.99,171.14,'2023-01-02 14:20:46','',''),(800,'1','306','1',1,'Retail Sale Id 805',2301.12,0.00,0.00,3.06,263.16,'2023-01-02 14:21:47','',''),(801,'1','306','1',1,'Retail Sale Id 806',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 14:23:02','',''),(802,'1','306','1',1,'Retail Sale Id 807',4496.96,0.00,0.00,5.98,514.28,'2023-01-02 14:23:56','',''),(803,'1','306','1',1,'Retail Sale Id 808',3000.48,0.00,0.00,3.99,343.14,'2023-01-02 14:24:53','',''),(804,'1','306','1',1,'Retail Sale Id 809',3000.48,0.00,0.00,3.99,343.14,'2023-01-02 14:25:52','',''),(805,'1','306','1',1,'Retail Sale Id 810',2301.12,0.00,0.00,3.06,263.16,'2023-01-02 14:26:59','',''),(806,'1','306','1',1,'Retail Sale Id 811',4496.96,0.00,0.00,5.98,514.28,'2023-01-02 14:28:33','',''),(807,'1','306','1',1,'Retail Sale Id 812',3699.84,0.00,0.00,4.92,423.12,'2023-01-02 14:30:33','',''),(808,'1','306','1',1,'Retail Sale Id 813',9497.76,0.00,0.00,12.63,1086.18,'2023-01-02 14:31:57','',''),(809,'1','306','1',1,'Retail Sale Id 814',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 14:40:25','',''),(810,'1','306','1',1,'Retail Sale Id 815',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 14:43:48','',''),(811,'1','306','1',1,'Retail Sale Id 815',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 14:43:48','',''),(812,'1','306','1',1,'Retail Sale Id 816',2000.32,0.00,0.00,2.66,228.76,'2023-01-02 14:44:51','',''),(813,'1','306','1',1,'Retail Sale Id 817',5000.80,0.00,0.00,6.65,571.90,'2023-01-02 14:50:01','',''),(814,'1','306','1',1,'Retail Sale Id 818',2256.00,0.00,0.00,3.00,258.00,'2023-01-02 14:52:10','',''),(815,'1','306','1',1,'Retail Sale Id 819',3760.00,0.00,0.00,5.00,430.00,'2023-01-02 15:02:24','',''),(816,'1','306','1',1,'Retail Sale Id 820',4512.00,0.00,0.00,6.00,516.00,'2023-01-02 15:03:45','',''),(817,'1','306','1',1,'Retail Sale Id 821',3000.48,0.00,0.00,3.99,343.14,'2023-01-02 15:09:52','',''),(818,'1','306','1',1,'Retail Sale Id 822',4512.00,0.00,0.00,6.00,516.00,'2023-01-02 15:11:28','',''),(819,'1','306','1',1,'Retail Sale Id 823',752.00,0.00,0.00,1.00,86.00,'2023-01-02 15:19:12','',''),(820,'1','306','1',1,'Retail Sale Id 823',752.00,0.00,0.00,1.00,86.00,'2023-01-02 15:19:12','',''),(821,'1','306','1',1,'Retail Sale Id 824',2000.32,0.00,0.00,2.66,228.76,'2023-01-02 15:27:50','',''),(822,'1','306','1',1,'Retail Sale Id 825',41760.00,0.00,0.00,58.00,3132.00,'2023-01-02 15:31:08','',''),(823,'1','306','1',1,'Retail Sale Id 826',1496.48,0.00,0.00,1.99,171.14,'2023-01-02 15:32:09','',''),(824,'1','306','1',1,'Retail Sale Id 827',1504.00,0.00,0.00,2.00,172.00,'2023-01-02 15:33:19','',''),(825,'1','306','1',1,'Retail Sale Id 828',3399.04,0.00,0.00,4.52,388.72,'2023-01-02 15:43:04','',''),(826,'1','306','1',1,'Retail Sale Id 829',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 15:44:28','',''),(827,'1','306','1',1,'Retail Sale Id 830',4496.96,0.00,0.00,5.98,514.28,'2023-01-02 15:45:18','',''),(828,'1','306','1',1,'Retail Sale Id 831',14400.00,0.00,0.00,20.00,1080.00,'2023-01-02 15:49:34','',''),(829,'1','306','1',1,'Retail Sale Id 832',2301.12,0.00,0.00,3.06,263.16,'2023-01-02 15:51:20','',''),(830,'1','306','1',1,'Retail Sale Id 833',2000.32,0.00,0.00,2.66,228.76,'2023-01-02 15:56:08','',''),(831,'1','306','1',1,'Retail Sale Id 834',2301.12,0.00,0.00,3.06,263.16,'2023-01-02 15:57:03','',''),(832,'1','306','1',1,'Retail Sale Id 835',4496.96,0.00,0.00,5.98,514.28,'2023-01-02 16:07:02','',''),(833,'1','306','1',1,'Retail Sale Id 836',1496.48,0.00,0.00,1.99,171.14,'2023-01-02 16:09:33','',''),(834,'1','306','1',1,'Retail Sale Id 837',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 16:10:35','',''),(835,'1','306','1',1,'Retail Sale Id 838',32400.00,0.00,0.00,45.00,2430.00,'2023-01-02 16:16:09','',''),(836,'1','306','1',1,'Retail Sale Id 839',2301.12,0.00,0.00,3.06,263.16,'2023-01-02 16:18:13','',''),(837,'1','306','1',1,'Retail Sale Id 840',4496.96,0.00,0.00,5.98,514.28,'2023-01-02 16:19:23','',''),(838,'1','306','1',1,'Retail Sale Id 841',1000.16,0.00,0.00,1.33,114.38,'2023-01-02 16:21:14','',''),(839,'1','306','1',1,'Retail Sale Id 842',3797.60,0.00,0.00,5.05,434.30,'2023-01-02 16:28:01','',''),(840,'1','306','1',1,'Retail Sale Id 843',2203.36,0.00,0.00,2.93,251.98,'2023-01-02 16:29:16','',''),(841,'1','306','1',1,'Retail Sale Id 844',4512.00,0.00,0.00,6.00,516.00,'2023-01-02 16:31:07','',''),(842,'1','306','1',1,'Retail Sale Id 845',3699.84,0.00,0.00,4.92,423.12,'2023-01-02 16:32:44','',''),(843,'1','306','1',1,'Retail Sale Id 847',2256.00,0.00,0.00,3.00,258.00,'2023-01-02 16:34:21','',''),(844,'1','306','1',1,'Retail Sale Id 848',2256.00,0.00,0.00,3.00,258.00,'2023-01-02 16:35:25','',''),(845,'1','306','1',1,'Retail Sale Id 849',3797.60,0.00,0.00,5.05,434.30,'2023-01-02 16:37:38','',''),(846,'1','306','1',1,'Retail Sale Id 850',2301.12,0.00,0.00,3.06,263.16,'2023-01-02 16:50:43','',''),(847,'1','306','1',1,'Retail Sale Id 852',2496.64,0.00,0.00,3.32,285.52,'2023-01-02 16:54:12','',''),(848,'1','306','1',1,'Retail Sale Id 853',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 16:58:17','',''),(849,'1','306','1',1,'Retail Sale Id 854',9400.00,0.00,0.00,12.50,1075.00,'2023-01-02 16:59:57','',''),(850,'1','306','1',1,'Retail Sale Id 855',7497.44,0.00,0.00,9.97,857.42,'2023-01-02 17:11:19','',''),(851,'1','306','1',1,'Retail Sale Id 856',4512.00,0.00,0.00,6.00,516.00,'2023-01-02 17:31:08','',''),(852,'1','306','1',1,'Retail Sale Id 857',797.12,0.00,0.00,1.06,91.16,'2023-01-02 17:33:19','',''),(853,'1','306','1',1,'Retail Sale Id 858',2248.48,0.00,0.00,2.99,257.14,'2023-01-02 17:34:29','',''),(854,'1','306','1',1,'Retail Sale Id 859',2301.12,0.00,0.00,3.06,263.16,'2023-01-02 17:35:28','',''),(855,'1','306','1',1,'Retail Sale Id 860',752.00,0.00,0.00,1.00,86.00,'2023-01-02 17:38:57','',''),(856,'1','306','1',1,'Retail Sale Id 861',2496.64,0.00,0.00,3.32,285.52,'2023-01-02 17:40:26','',''),(857,'1','306','1',1,'Retail Sale Id 862',797.12,0.00,0.00,1.06,91.16,'2023-01-02 17:51:56','',''),(858,'1','306','1',1,'Retail Sale Id 863',1496.48,0.00,0.00,1.99,171.14,'2023-01-02 18:06:15','',''),(859,'1','306','1',1,'Retail Sale Id 864',3797.60,0.00,0.00,5.05,434.30,'2023-01-02 18:16:55','',''),(860,'1','306','1',1,'Retail Sale Id 865',1496.48,0.00,0.00,1.99,171.14,'2023-01-02 18:17:47','',''),(861,'1','306','1',1,'Retail Sale Id 866',43548.32,0.00,0.00,57.91,4980.26,'2023-01-02 18:45:59','',''),(862,'1','306','1',1,'Return of Retail Sale Id 853',0.00,9400.00,12.50,0.00,-1075.00,'2023-01-02 18:47:07','',''),(863,'1','306','1',1,'Return of Retail Sale Id 854',0.00,9400.00,12.50,0.00,-1075.00,'2023-01-02 18:47:35','',''),(864,'1','306','1',1,'Return of Retail Sale Id 800',0.00,4496.96,5.98,0.00,-514.28,'2023-01-02 18:48:41','',''),(865,'1','306','1',1,'Return of Retail Sale Id 861',0.00,2496.64,3.32,0.00,-285.52,'2023-01-02 18:49:15','',''),(866,'1','306','1',1,'Return of Retail Sale Id 855',0.00,7497.44,9.97,0.00,-857.42,'2023-01-02 18:50:27','',''),(867,'1','306','1',1,'Return of Retail Sale Id 815',0.00,9400.00,12.50,0.00,-1075.00,'2023-01-02 18:51:04','',''),(868,'1','306','1',1,'Return of Retail Sale Id 815',0.00,9400.00,12.50,0.00,-1075.00,'2023-01-02 18:51:04','',''),(869,'1','306','1',1,'Return of Retail Sale Id 814',0.00,9400.00,12.50,0.00,-1075.00,'2023-01-02 18:51:47','',''),(870,'1','306','1',1,'Retail Sale Id 867',15393.44,0.00,0.00,20.47,1760.42,'2023-01-02 18:53:56','',''),(871,'1','306','1',1,'Retail Sale Id 868',2000.32,0.00,0.00,2.66,228.76,'2023-01-03 07:42:10','',''),(872,'1','306','1',1,'Retail Sale Id 869',4496.96,0.00,0.00,5.98,514.28,'2023-01-03 07:45:32','',''),(873,'1','306','1',1,'Retail Sale Id 870',2000.32,0.00,0.00,2.66,228.76,'2023-01-03 08:18:09','',''),(874,'1','306','1',1,'Retail Sale Id 870',2000.32,0.00,0.00,2.66,228.76,'2023-01-03 08:18:09','',''),(875,'1','306','1',1,'Retail Sale Id 871',4496.96,0.00,0.00,5.98,514.28,'2023-01-03 08:31:07','',''),(876,'1','306','1',1,'Retail Sale Id 872',3000.48,0.00,0.00,3.99,343.14,'2023-01-03 08:32:38','',''),(877,'1','306','1',1,'Retail Sale Id 873',1496.48,0.00,0.00,1.99,171.14,'2023-01-03 08:33:53','',''),(878,'1','306','1',1,'Retail Sale Id 874',797.12,0.00,0.00,1.06,91.16,'2023-01-03 08:46:17','',''),(879,'1','306','1',1,'Retail Sale Id 875',2301.12,0.00,0.00,3.06,263.16,'2023-01-03 08:48:45','',''),(880,'1','306','1',1,'Retail Sale Id 876',4496.96,0.00,0.00,5.98,514.28,'2023-01-03 08:51:19','',''),(881,'1','306','1',1,'Retail Sale Id 877',2256.00,0.00,0.00,3.00,258.00,'2023-01-03 08:54:04','',''),(882,'1','306','1',1,'Retail Sale Id 878',752.00,0.00,0.00,1.00,86.00,'2023-01-03 08:55:56','',''),(883,'1','306','1',1,'Retail Sale Id 879',3797.60,0.00,0.00,5.05,434.30,'2023-01-03 09:03:59','',''),(884,'1','306','1',1,'Retail Sale Id 880',2301.12,0.00,0.00,3.06,263.16,'2023-01-03 09:05:18','',''),(885,'1','306','1',1,'Retail Sale Id 881',2256.00,0.00,0.00,3.00,258.00,'2023-01-03 09:11:54','',''),(886,'1','306','1',1,'Retail Sale Id 882',1797.28,0.00,0.00,2.39,205.54,'2023-01-03 09:28:58','',''),(887,'1','306','1',1,'Retail Sale Id 883',4496.96,0.00,0.00,5.98,514.28,'2023-01-03 09:29:54','',''),(888,'1','306','1',1,'Retail Sale Id 884',3760.00,0.00,0.00,5.00,430.00,'2023-01-03 09:32:21','',''),(889,'1','306','1',1,'Retail Sale Id 885',752.00,0.00,0.00,1.00,86.00,'2023-01-03 09:33:42','',''),(890,'1','306','1',1,'Retail Sale Id 886',2398.88,0.00,0.00,3.19,274.34,'2023-01-03 09:39:06','',''),(891,'1','306','1',1,'Retail Sale Id 887',4496.96,0.00,0.00,5.98,514.28,'2023-01-03 09:40:12','',''),(892,'1','306','1',1,'Retail Sale Id 888',2256.00,0.00,0.00,3.00,258.00,'2023-01-03 09:41:32','',''),(893,'1','306','1',1,'Retail Sale Id 889',3797.60,0.00,0.00,5.05,434.30,'2023-01-03 09:49:23','',''),(894,'1','306','1',1,'Retail Sale Id 890',1496.48,0.00,0.00,1.99,171.14,'2023-01-03 09:50:04','',''),(895,'1','306','1',1,'Retail Sale Id 891',2301.12,0.00,0.00,3.06,263.16,'2023-01-03 09:50:59','',''),(896,'1','306','1',1,'Retail Sale Id 892',752.00,0.00,0.00,1.00,86.00,'2023-01-03 09:52:56','',''),(897,'1','306','1',1,'Retail Sale Id 893',9497.76,0.00,0.00,12.63,1086.18,'2023-01-03 09:55:41','',''),(898,'1','306','1',1,'Retail Sale Id 894',2301.12,0.00,0.00,3.06,263.16,'2023-01-03 10:00:02','',''),(899,'1','306','1',1,'Retail Sale Id 895',1496.48,0.00,0.00,1.99,171.14,'2023-01-03 10:00:59','',''),(900,'1','306','1',1,'Retail Sale Id 896',1000.16,0.00,0.00,1.33,114.38,'2023-01-03 10:05:38','',''),(901,'1','306','1',1,'Retail Sale Id 897',752.00,0.00,0.00,1.00,86.00,'2023-01-03 10:08:33','',''),(902,'1','306','1',1,'Retail Sale Id 898',1000.16,0.00,0.00,1.33,114.38,'2023-01-03 10:11:32','',''),(903,'1','306','1',1,'Retail Sale Id 899',4512.00,0.00,0.00,6.00,516.00,'2023-01-03 10:13:29','',''),(904,'1','306','1',1,'Retail Sale Id 900',2496.64,0.00,0.00,3.32,285.52,'2023-01-03 10:14:21','',''),(905,'1','306','1',1,'Retail Sale Id 901',4512.00,0.00,0.00,6.00,516.00,'2023-01-03 10:17:09','',''),(906,'1','306','1',1,'Retail Sale Id 902',2301.12,0.00,0.00,3.06,263.16,'2023-01-03 10:23:43','',''),(907,'1','306','1',1,'Retail Sale Id 903',2000.32,0.00,0.00,2.66,228.76,'2023-01-03 10:26:01','',''),(908,'1','306','1',1,'Retail Sale Id 904',3000.48,0.00,0.00,3.99,343.14,'2023-01-03 10:26:53','',''),(909,'1','306','1',1,'Retail Sale Id 905',4000.64,0.00,0.00,5.32,457.52,'2023-01-03 10:34:54','',''),(910,'1','306','1',1,'Retail Sale Id 906',3000.48,0.00,0.00,3.99,343.14,'2023-01-03 10:44:27','',''),(911,'1','306','1',1,'Retail Sale Id 907',4512.00,0.00,0.00,6.00,516.00,'2023-01-03 10:50:24','',''),(912,'1','306','1',1,'Retail Sale Id 908',2256.00,0.00,0.00,3.00,258.00,'2023-01-03 10:52:13','',''),(913,'1','306','1',1,'Retail Sale Id 909',4496.96,0.00,0.00,5.98,514.28,'2023-01-03 10:54:57','',''),(914,'1','306','1',1,'Retail Sale Id 910',2256.00,0.00,0.00,3.00,258.00,'2023-01-03 10:56:22','',''),(915,'1','306','1',1,'Retail Sale Id 911',4496.96,0.00,0.00,5.98,514.28,'2023-01-03 11:25:15','',''),(916,'1','306','1',1,'Retail Sale Id 913',187920.00,0.00,0.00,261.00,14094.00,'2023-01-03 11:29:53','',''),(917,'1','306','1',1,'Retail Sale Id 914',9497.76,0.00,0.00,12.63,1086.18,'2023-01-03 11:31:20','',''),(918,'1','306','1',1,'Retail Sale Id 915',2301.12,0.00,0.00,3.06,263.16,'2023-01-03 11:34:00','',''),(919,'1','306','1',1,'Retail Sale Id 917',5640.00,0.00,0.00,7.50,645.00,'2023-01-03 11:39:21','',''),(920,'1','306','1',1,'Retail Sale Id 918',50400.00,0.00,0.00,70.00,3780.00,'2023-01-03 11:42:03','',''),(921,'1','306','1',1,'Retail Sale Id 919',1496.48,0.00,0.00,1.99,171.14,'2023-01-03 11:49:10','',''),(922,'1','306','1',1,'Retail Sale Id 920',3000.48,0.00,0.00,3.99,343.14,'2023-01-03 12:10:33','',''),(923,'1','306','1',1,'Retail Sale Id 921',2301.12,0.00,0.00,3.06,263.16,'2023-01-03 12:20:53','',''),(924,'1','306','1',1,'Retail Sale Id 922',2256.00,0.00,0.00,3.00,258.00,'2023-01-03 12:22:34','',''),(925,'1','306','1',1,'Retail Sale Id 923',699.36,0.00,0.00,0.93,79.98,'2023-01-03 12:25:46','',''),(926,'1','306','1',1,'Retail Sale Id 924',3098.24,0.00,0.00,4.12,354.32,'2023-01-03 12:26:39','',''),(927,'1','306','1',1,'Retail Sale Id 925',752.00,0.00,0.00,1.00,86.00,'2023-01-03 12:27:43','',''),(928,'1','306','1',1,'Retail Sale Id 926',2301.12,0.00,0.00,3.06,263.16,'2023-01-03 12:30:34','',''),(929,'1','306','1',1,'Retail Sale Id 927',4512.00,0.00,0.00,6.00,516.00,'2023-01-03 12:37:58','',''),(930,'1','306','1',1,'Retail Sale Id 928',4496.96,0.00,0.00,5.98,514.28,'2023-01-03 12:39:20','',''),(931,'1','306','1',1,'Retail Sale Id 929',797.12,0.00,0.00,1.06,91.16,'2023-01-03 12:40:56','',''),(932,'1','306','1',1,'Retail Sale Id 930',2256.00,0.00,0.00,3.00,258.00,'2023-01-03 12:42:31','',''),(933,'1','306','1',1,'Retail Sale Id 931',3797.60,0.00,0.00,5.05,434.30,'2023-01-03 12:48:12','',''),(934,'1','306','1',1,'Retail Sale Id 932',2301.12,0.00,0.00,3.06,263.16,'2023-01-03 13:13:27','',''),(935,'1','306','1',1,'Retail Sale Id 933',3797.60,0.00,0.00,5.05,434.30,'2023-01-03 13:48:09','',''),(936,'1','306','1',1,'Retail Sale Id 934',2301.12,0.00,0.00,3.06,263.16,'2023-01-03 13:53:15','',''),(937,'1','306','1',1,'Retail Sale Id 935',1496.48,0.00,0.00,1.99,171.14,'2023-01-03 13:54:42','',''),(938,'1','306','1',1,'Retail Sale Id 936',9400.00,0.00,0.00,12.50,1075.00,'2023-01-03 14:09:16','',''),(939,'1','306','1',1,'Retail Sale Id 937',9001.44,0.00,0.00,11.97,1029.42,'2023-01-03 14:10:50','',''),(940,'1','306','1',1,'Retail Sale Id 938',2000.32,0.00,0.00,2.66,228.76,'2023-01-03 14:11:37','',''),(941,'1','306','1',1,'Retail Sale Id 939',752.00,0.00,0.00,1.00,86.00,'2023-01-03 14:19:02','',''),(942,'1','306','1',1,'Retail Sale Id 940',4496.96,0.00,0.00,5.98,514.28,'2023-01-03 14:37:33','',''),(943,'1','306','1',1,'Retail Sale Id 941',4512.00,0.00,0.00,6.00,516.00,'2023-01-03 14:39:43','',''),(944,'1','306','1',1,'Retail Sale Id 942',4512.00,0.00,0.00,6.00,516.00,'2023-01-03 14:42:43','',''),(945,'1','306','1',1,'Retail Sale Id 943',1496.48,0.00,0.00,1.99,171.14,'2023-01-03 14:43:28','',''),(946,'1','306','1',1,'Retail Sale Id 944',3008.00,0.00,0.00,4.00,344.00,'2023-01-03 15:17:28','',''),(947,'1','306','1',1,'Retail Sale Id 946',3000.48,0.00,0.00,3.99,343.14,'2023-01-03 15:19:28','',''),(948,'1','306','1',1,'Retail Sale Id 947',36000.00,0.00,0.00,50.00,2700.00,'2023-01-03 15:33:23','',''),(949,'1','306','1',1,'Retail Sale Id 948',752.00,0.00,0.00,1.00,86.00,'2023-01-03 15:34:41','',''),(950,'1','306','1',1,'Retail Sale Id 948',752.00,0.00,0.00,1.00,86.00,'2023-01-03 15:34:41','',''),(951,'1','306','1',1,'Retail Sale Id 949',2301.12,0.00,0.00,3.06,263.16,'2023-01-03 15:42:33','',''),(952,'1','306','1',1,'Retail Sale Id 950',1496.48,0.00,0.00,1.99,171.14,'2023-01-03 15:43:20','',''),(953,'1','306','1',1,'Retail Sale Id 951',2301.12,0.00,0.00,3.06,263.16,'2023-01-03 16:07:19','',''),(954,'1','306','1',1,'Retail Sale Id 952',4512.00,0.00,0.00,6.00,516.00,'2023-01-03 16:28:36','',''),(955,'1','306','1',1,'Retail Sale Id 953',12032.00,0.00,0.00,16.00,1376.00,'2023-01-03 16:32:14','',''),(956,'1','306','1',1,'Retail Sale Id 954',4512.00,0.00,0.00,6.00,516.00,'2023-01-03 16:34:05','',''),(957,'1','306','1',1,'Retail Sale Id 955',2203.36,0.00,0.00,2.93,251.98,'2023-01-03 16:42:35','',''),(958,'1','306','1',1,'Retail Sale Id 956',2301.12,0.00,0.00,3.06,263.16,'2023-01-03 16:43:09','',''),(959,'1','306','1',1,'Return of Retail Sale Id 953',0.00,12032.00,16.00,0.00,-1376.00,'2023-01-03 16:47:53','',''),(960,'1','306','1',1,'Retail Sale Id 957',1000.16,0.00,0.00,1.33,114.38,'2023-01-03 16:50:02','',''),(961,'1','306','1',1,'Retail Sale Id 958',752.00,0.00,0.00,1.00,86.00,'2023-01-03 16:52:53','',''),(962,'1','306','1',1,'Retail Sale Id 959',4496.96,0.00,0.00,5.98,514.28,'2023-01-03 16:54:11','',''),(963,'1','306','1',1,'Retail Sale Id 960',2248.48,0.00,0.00,2.99,257.14,'2023-01-03 16:55:06','',''),(964,'1','306','1',1,'Retail Sale Id 961',3000.48,0.00,0.00,3.99,343.14,'2023-01-03 16:56:22','',''),(965,'1','306','1',1,'Retail Sale Id 962',1496.48,0.00,0.00,1.99,171.14,'2023-01-03 17:08:39','',''),(966,'1','306','1',1,'Retail Sale Id 963',2000.32,0.00,0.00,2.66,228.76,'2023-01-03 17:09:50','',''),(967,'1','306','1',1,'Retail Sale Id 964',5000.80,0.00,0.00,6.65,571.90,'2023-01-03 17:16:56','',''),(968,'1','306','1',1,'Retail Sale Id 965',3008.00,0.00,0.00,4.00,344.00,'2023-01-03 17:24:28','',''),(969,'1','306','1',1,'Retail Sale Id 966',3797.60,0.00,0.00,5.05,434.30,'2023-01-03 17:26:29','',''),(970,'1','306','1',1,'Return of Retail Sale Id 965',0.00,3008.00,4.00,0.00,-344.00,'2023-01-03 17:30:03','',''),(971,'1','306','1',1,'Retail Sale Id 967',3008.00,0.00,0.00,4.00,344.00,'2023-01-03 17:45:18','',''),(972,'1','306','1',1,'Retail Sale Id 968',3000.48,0.00,0.00,3.99,343.14,'2023-01-03 17:55:53','',''),(973,'1','306','1',1,'Retail Sale Id 969',4512.00,0.00,0.00,6.00,516.00,'2023-01-03 18:02:20','',''),(974,'1','306','1',1,'Retail Sale Id 970',1496.48,0.00,0.00,1.99,171.14,'2023-01-03 18:03:16','',''),(975,'1','306','1',1,'Return of Retail Sale Id 970',0.00,1496.48,1.99,0.00,-171.14,'2023-01-03 19:05:30','',''),(976,'1','306','1',1,'Return of Retail Sale Id 947',0.00,36000.00,50.00,0.00,-2700.00,'2023-01-03 19:06:06','',''),(977,'1','306','1',1,'Retail Sale Id 971',35949.60,0.00,0.00,49.93,2696.22,'2023-01-03 19:07:49','',''),(978,'1','306','1',1,'Return of Retail Sale Id 964',0.00,5000.80,6.65,0.00,-571.90,'2023-01-03 19:08:46','',''),(979,'1','306','1',1,'Return of Retail Sale Id 966',0.00,3797.60,5.05,0.00,-434.30,'2023-01-03 19:09:11','',''),(980,'1','306','1',1,'Retail Sale Id 972',7159.04,0.00,0.00,9.52,818.72,'2023-01-03 19:10:14','',''),(981,'1','306','1',1,'Retail Sale Id 973',2203.36,0.00,0.00,2.93,251.98,'2023-01-04 07:53:31','',''),(982,'1','306','1',1,'Retail Sale Id 974',2301.12,0.00,0.00,3.06,263.16,'2023-01-04 08:19:02','',''),(983,'1','306','1',1,'Retail Sale Id 975',3496.80,0.00,0.00,4.65,399.90,'2023-01-04 08:28:01','',''),(984,'1','306','1',1,'Retail Sale Id 976',2301.12,0.00,0.00,3.06,263.16,'2023-01-04 08:45:01','',''),(985,'1','306','1',1,'Retail Sale Id 977',2301.12,0.00,0.00,3.06,263.16,'2023-01-04 09:00:15','',''),(986,'1','306','1',1,'Retail Sale Id 979',797.12,0.00,0.00,1.06,91.16,'2023-01-04 09:01:35','',''),(987,'1','306','1',1,'Retail Sale Id 980',4496.96,0.00,0.00,5.98,514.28,'2023-01-04 09:02:31','',''),(988,'1','306','1',1,'Retail Sale Id 981',4512.00,0.00,0.00,6.00,516.00,'2023-01-04 09:07:18','',''),(989,'1','306','1',1,'Retail Sale Id 982',7200.00,0.00,0.00,10.00,540.00,'2023-01-04 09:16:18','',''),(990,'1','306','1',1,'Retail Sale Id 983',1496.48,0.00,0.00,1.99,171.14,'2023-01-04 09:18:01','',''),(991,'1','306','1',1,'Retail Sale Id 984',2301.12,0.00,0.00,3.06,263.16,'2023-01-04 09:24:43','',''),(992,'1','306','1',1,'Retail Sale Id 985',1496.48,0.00,0.00,1.99,171.14,'2023-01-04 09:26:54','',''),(993,'1','306','1',1,'Retail Sale Id 986',4496.96,0.00,0.00,5.98,514.28,'2023-01-04 09:29:34','',''),(994,'1','306','1',1,'Retail Sale Id 987',27360.00,0.00,0.00,38.00,2052.00,'2023-01-04 09:31:10','',''),(995,'1','306','1',1,'Retail Sale Id 988',4512.00,0.00,0.00,6.00,516.00,'2023-01-04 09:32:12','',''),(996,'1','306','1',1,'Retail Sale Id 989',2256.00,0.00,0.00,3.00,258.00,'2023-01-04 09:33:22','',''),(997,'1','306','1',1,'Retail Sale Id 990',1496.48,0.00,0.00,1.99,171.14,'2023-01-04 09:34:18','',''),(998,'1','306','1',1,'Retail Sale Id 991',1496.48,0.00,0.00,1.99,171.14,'2023-01-04 09:40:14','',''),(999,'1','306','1',1,'Retail Sale Id 992',797.12,0.00,0.00,1.06,91.16,'2023-01-04 09:41:19','',''),(1000,'1','306','1',1,'Retail Sale Id 993',28080.00,0.00,0.00,39.00,2106.00,'2023-01-04 09:43:30','',''),(1001,'1','306','1',1,'Retail Sale Id 994',2301.12,0.00,0.00,3.06,263.16,'2023-01-04 09:54:56','',''),(1002,'1','306','1',1,'Retail Sale Id 995',3797.60,0.00,0.00,5.05,434.30,'2023-01-04 10:01:57','',''),(1003,'1','306','1',1,'Retail Sale Id 997',72000.00,0.00,0.00,100.00,5400.00,'2023-01-04 10:20:25','',''),(1004,'1','306','1',1,'Retail Sale Id 998',2256.00,0.00,0.00,3.00,258.00,'2023-01-04 10:22:26','',''),(1005,'1','306','1',1,'Retail Sale Id 999',70560.00,0.00,0.00,98.00,5292.00,'2023-01-04 10:24:58','',''),(1006,'1','306','1',1,'Retail Sale Id 1000',2301.12,0.00,0.00,3.06,263.16,'2023-01-04 10:26:41','',''),(1007,'1','306','1',1,'Retail Sale Id 1001',2301.12,0.00,0.00,3.06,263.16,'2023-01-04 10:27:34','',''),(1008,'1','306','1',1,'Retail Sale Id 1002',3797.60,0.00,0.00,5.05,434.30,'2023-01-04 10:29:20','',''),(1009,'1','306','1',1,'Retail Sale Id 1003',59760.00,0.00,0.00,83.00,4482.00,'2023-01-04 10:36:02','',''),(1010,'1','306','1',1,'Retail Sale Id 1004',1496.48,0.00,0.00,1.99,171.14,'2023-01-04 10:42:28','',''),(1011,'1','306','1',1,'Retail Sale Id 1005',4512.00,0.00,0.00,6.00,516.00,'2023-01-04 10:45:48','',''),(1012,'1','306','1',1,'Retail Sale Id 1006',2301.12,0.00,0.00,3.06,263.16,'2023-01-04 10:47:23','',''),(1013,'1','306','1',1,'Retail Sale Id 1007',797.12,0.00,0.00,1.06,91.16,'2023-01-04 11:06:22','',''),(1014,'1','306','1',1,'Retail Sale Id 1008',2301.12,0.00,0.00,3.06,263.16,'2023-01-04 11:11:01','',''),(1015,'1','306','1',1,'Retail Sale Id 1009',9400.00,0.00,0.00,12.50,1075.00,'2023-01-04 11:17:44','',''),(1016,'1','306','1',1,'Retail Sale Id 1010',2301.12,0.00,0.00,3.06,263.16,'2023-01-04 11:35:05','',''),(1017,'1','306','1',1,'Retail Sale Id 1011',7497.44,0.00,0.00,9.97,857.42,'2023-01-04 11:56:35','',''),(1018,'1','306','1',1,'Retail Sale Id 1012',2301.12,0.00,0.00,3.06,263.16,'2023-01-04 11:59:15','',''),(1019,'1','306','1',1,'Retail Sale Id 1013',1496.48,0.00,0.00,1.99,171.14,'2023-01-04 12:08:17','',''),(1020,'1','306','1',1,'Retail Sale Id 1014',3797.60,0.00,0.00,5.05,434.30,'2023-01-04 12:22:01','',''),(1021,'1','306','1',1,'Retail Sale Id 1015',797.12,0.00,0.00,1.06,91.16,'2023-01-04 12:23:04','',''),(1022,'1','306','1',1,'Retail Sale Id 1016',14400.00,0.00,0.00,20.00,1080.00,'2023-01-04 12:28:51','',''),(1023,'1','306','1',1,'Retail Sale Id 1017',6016.00,0.00,0.00,8.00,688.00,'2023-01-04 12:49:52','',''),(1024,'1','306','1',1,'Retail Sale Id 1018',2256.00,0.00,0.00,3.00,258.00,'2023-01-04 13:01:05','',''),(1025,'1','306','1',1,'Retail Sale Id 1018',2256.00,0.00,0.00,3.00,258.00,'2023-01-04 13:01:05','',''),(1026,'1','306','1',1,'Retail Sale Id 1019',3797.60,0.00,0.00,5.05,434.30,'2023-01-04 13:02:26','',''),(1027,'1','306','1',1,'Retail Sale Id 1020',2256.00,0.00,0.00,3.00,258.00,'2023-01-04 13:07:41','',''),(1028,'1','306','1',1,'Retail Sale Id 1021',3752.48,0.00,0.00,4.99,429.14,'2023-01-04 13:29:45','',''),(1029,'1','306','1',1,'Retail Sale Id 1022',3000.48,0.00,0.00,3.99,343.14,'2023-01-04 13:31:04','',''),(1030,'1','306','1',1,'Retail Sale Id 1023',2301.12,0.00,0.00,3.06,263.16,'2023-01-04 13:45:22','',''),(1031,'1','306','1',1,'Retail Sale Id 1024',4496.96,0.00,0.00,5.98,514.28,'2023-01-04 13:47:09','',''),(1032,'1','306','1',1,'Retail Sale Id 1025',9400.00,0.00,0.00,12.50,1075.00,'2023-01-04 13:53:03','',''),(1033,'1','306','1',1,'Retail Sale Id 1026',797.12,0.00,0.00,1.06,91.16,'2023-01-04 14:20:09','',''),(1034,'1','306','1',1,'Retail Sale Id 1027',2301.12,0.00,0.00,3.06,263.16,'2023-01-04 14:31:55','',''),(1035,'1','306','1',1,'Retail Sale Id 1028',129600.00,0.00,0.00,180.00,9720.00,'2023-01-04 14:42:49','',''),(1036,'1','306','1',1,'Retail Sale Id 1029',9497.76,0.00,0.00,12.63,1086.18,'2023-01-04 14:47:49','',''),(1037,'1','306','1',1,'Retail Sale Id 1030',8497.60,0.00,0.00,11.30,971.80,'2023-01-04 15:01:59','',''),(1038,'1','306','1',1,'Retail Sale Id 1031',1496.48,0.00,0.00,1.99,171.14,'2023-01-04 15:05:44','',''),(1039,'1','306','1',1,'Retail Sale Id 1032',3008.00,0.00,0.00,4.00,344.00,'2023-01-04 16:04:20','',''),(1040,'1','306','1',1,'Retail Sale Id 1033',4496.96,0.00,0.00,5.98,514.28,'2023-01-04 16:10:34','',''),(1041,'1','306','1',1,'Retail Sale Id 1034',2256.00,0.00,0.00,3.00,258.00,'2023-01-04 16:17:57','',''),(1042,'1','306','1',1,'Retail Sale Id 1034',9400.00,0.00,0.00,12.50,1075.00,'2023-01-04 16:17:57','',''),(1043,'1','306','1',1,'Retail Sale Id 1035',9497.76,0.00,0.00,12.63,1086.18,'2023-01-04 16:23:41','',''),(1044,'1','306','1',1,'Retail Sale Id 1036',2301.12,0.00,0.00,3.06,263.16,'2023-01-04 16:26:51','',''),(1045,'1','306','1',1,'Retail Sale Id 1037',5264.00,0.00,0.00,7.00,602.00,'2023-01-04 16:28:18','',''),(1046,'1','306','1',1,'Retail Sale Id 1038',4496.96,0.00,0.00,5.98,514.28,'2023-01-04 16:37:37','',''),(1047,'1','306','1',1,'Retail Sale Id 1039',18000.00,0.00,0.00,25.00,1350.00,'2023-01-04 16:44:57','',''),(1048,'1','306','1',1,'Retail Sale Id 1040',4797.76,0.00,0.00,6.38,548.68,'2023-01-04 16:52:20','',''),(1049,'1','306','1',1,'Retail Sale Id 1041',3760.00,0.00,0.00,5.00,430.00,'2023-01-04 17:16:34','',''),(1050,'1','306','1',1,'Retail Sale Id 1042',1496.48,0.00,0.00,1.99,171.14,'2023-01-04 17:17:46','',''),(1051,'1','306','1',1,'Retail Sale Id 1043',1496.48,0.00,0.00,1.99,171.14,'2023-01-04 17:25:38','',''),(1052,'1','306','1',1,'Retail Sale Id 1044',2301.12,0.00,0.00,3.06,263.16,'2023-01-04 17:28:44','',''),(1053,'1','306','1',1,'Retail Sale Id 1045',2248.48,0.00,0.00,2.99,257.14,'2023-01-04 17:31:45','',''),(1054,'1','306','1',1,'Retail Sale Id 1046',2301.12,0.00,0.00,3.06,263.16,'2023-01-04 17:42:47','',''),(1055,'1','306','1',1,'Retail Sale Id 1047',4000.64,0.00,0.00,5.32,457.52,'2023-01-04 17:59:59','',''),(1056,'1','306','1',1,'Retail Sale Id 1048',4496.96,0.00,0.00,5.98,514.28,'2023-01-04 18:04:04','',''),(1057,'1','306','1',1,'Return of Retail Sale Id 1048',0.00,4496.96,5.98,0.00,-514.28,'2023-01-04 18:16:03','',''),(1058,'1','306','1',1,'Retail Sale Id 1049',3526.88,0.00,0.00,4.69,403.34,'2023-01-04 18:17:20','',''),(1059,'1','306','1',1,'Retail Sale Id 1050',797.12,0.00,0.00,1.06,91.16,'2023-01-05 07:20:30','',''),(1060,'1','306','1',1,'Retail Sale Id 1051',3000.48,0.00,0.00,3.99,343.14,'2023-01-05 08:16:22','',''),(1061,'1','306','1',1,'Retail Sale Id 1052',3797.60,0.00,0.00,5.05,434.30,'2023-01-05 08:23:35','',''),(1062,'1','306','1',1,'Retail Sale Id 1053',5264.00,0.00,0.00,7.00,602.00,'2023-01-05 08:34:03','',''),(1063,'1','306','1',1,'Retail Sale Id 1055',2256.00,0.00,0.00,3.00,258.00,'2023-01-05 08:40:59','',''),(1064,'1','306','1',1,'Retail Sale Id 1056',1496.48,0.00,0.00,1.99,171.14,'2023-01-05 08:53:03','',''),(1065,'1','306','1',1,'Retail Sale Id 1057',4512.00,0.00,0.00,6.00,516.00,'2023-01-05 09:04:50','',''),(1066,'1','306','1',1,'Retail Sale Id 1058',4512.00,0.00,0.00,6.00,516.00,'2023-01-05 09:05:36','',''),(1067,'1','306','1',1,'Retail Sale Id 1059',3000.48,0.00,0.00,3.99,343.14,'2023-01-05 09:14:31','',''),(1068,'1','306','1',1,'Retail Sale Id 1060',2301.12,0.00,0.00,3.06,263.16,'2023-01-05 09:20:41','',''),(1069,'1','306','1',1,'Retail Sale Id 1061',2301.12,0.00,0.00,3.06,263.16,'2023-01-05 09:22:12','',''),(1070,'1','306','1',1,'Retail Sale Id 1062',3797.60,0.00,0.00,5.05,434.30,'2023-01-05 09:28:15','',''),(1071,'1','306','1',1,'Retail Sale Id 1063',797.12,0.00,0.00,1.06,91.16,'2023-01-05 09:47:48','',''),(1072,'1','306','1',1,'Retail Sale Id 1063',3301.28,0.00,0.00,4.39,377.54,'2023-01-05 09:47:48','',''),(1073,'1','306','1',1,'Retail Sale Id 1064',3797.60,0.00,0.00,5.05,434.30,'2023-01-05 09:58:30','',''),(1074,'1','306','1',1,'Retail Sale Id 1065',20160.00,0.00,0.00,28.00,1512.00,'2023-01-05 09:59:35','',''),(1075,'1','306','1',1,'Retail Sale Id 1069',1496.48,0.00,0.00,1.99,171.14,'2023-01-05 10:34:01','',''),(1076,'1','306','1',1,'Retail Sale Id 1069',8272.00,0.00,0.00,11.00,946.00,'2023-01-05 10:34:01','',''),(1077,'1','306','1',1,'Retail Sale Id 1072',7497.44,0.00,0.00,9.97,857.42,'2023-01-05 10:39:47','',''),(1078,'1','306','1',1,'Retail Sale Id 1074',4496.96,0.00,0.00,5.98,514.28,'2023-01-05 10:41:15','',''),(1079,'1','306','1',1,'Retail Sale Id 1075',14400.00,0.00,0.00,20.00,1080.00,'2023-01-05 10:42:55','',''),(1080,'1','306','1',1,'Retail Sale Id 1076',7497.44,0.00,0.00,9.97,857.42,'2023-01-05 10:44:47','',''),(1081,'1','306','1',1,'Retail Sale Id 1077',7497.44,0.00,0.00,9.97,857.42,'2023-01-05 10:46:28','',''),(1082,'1','306','1',1,'Retail Sale Id 1078',2203.36,0.00,0.00,2.93,251.98,'2023-01-05 10:48:59','',''),(1083,'1','306','1',1,'Retail Sale Id 1079',1496.48,0.00,0.00,1.99,171.14,'2023-01-05 10:50:34','',''),(1084,'1','306','1',1,'Retail Sale Id 1080',23996.32,0.00,0.00,31.91,2744.26,'2023-01-05 10:52:44','',''),(1085,'1','306','1',1,'Retail Sale Id 1081',3797.60,0.00,0.00,5.05,434.30,'2023-01-05 11:03:02','',''),(1086,'1','306','1',1,'Retail Sale Id 1083',9000.00,0.00,0.00,12.50,675.00,'2023-01-05 11:04:27','',''),(1087,'1','306','1',1,'Retail Sale Id 1084',1481.44,0.00,0.00,1.97,169.42,'2023-01-05 11:14:54','',''),(1088,'1','306',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,40998.96,61.56,0.00,0.00,'2023-01-05 12:18:26','',''),(1089,'1','306',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,61.56,0.00,'2023-01-05 12:19:29','',''),(1090,'1','306','1',1,'Received from bridging 3',0.00,0.00,61.56,0.00,0.00,'2023-01-05 12:19:29','',''),(1091,'1','306','1',1,'Retail Sale Id 1085',46293.12,0.00,0.00,61.56,5294.16,'2023-01-05 12:21:36','',''),(1092,'1','306',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,3663000.00,5500.00,0.00,0.00,'2023-01-05 13:27:20','',''),(1093,'1','306',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,5500.00,0.00,'2023-01-05 13:28:26','',''),(1094,'1','306','1',1,'Received from bridging 4',0.00,0.00,5500.00,0.00,0.00,'2023-01-05 13:28:26','',''),(1095,'1','306','1',1,'Retail Sale Id 1086',349200.00,0.00,0.00,485.00,26190.00,'2023-01-05 13:30:34','',''),(1096,'1','306','1',1,'Retail Sale Id 1087',9400.00,0.00,0.00,12.50,1075.00,'2023-01-05 13:32:16','',''),(1097,'1','306','1',1,'Retail Sale Id 1088',4496.96,0.00,0.00,5.98,514.28,'2023-01-05 13:33:28','',''),(1098,'1','306','1',1,'Retail Sale Id 1089',797.12,0.00,0.00,1.06,91.16,'2023-01-05 13:34:44','',''),(1099,'1','306','1',1,'Retail Sale Id 1090',3000.48,0.00,0.00,3.99,343.14,'2023-01-05 13:35:54','',''),(1100,'1','306','1',1,'Retail Sale Id 1091',2496.64,0.00,0.00,3.32,285.52,'2023-01-05 13:36:46','',''),(1101,'1','306','1',1,'Retail Sale Id 1092',3000.48,0.00,0.00,3.99,343.14,'2023-01-05 13:37:35','',''),(1102,'1','306','1',1,'Retail Sale Id 1093',3000.48,0.00,0.00,3.99,343.14,'2023-01-05 13:38:28','',''),(1103,'1','306','1',1,'Retail Sale Id 1094',1496.48,0.00,0.00,1.99,171.14,'2023-01-05 13:39:11','',''),(1104,'1','306','1',1,'Retail Sale Id 1095',2496.64,0.00,0.00,3.32,285.52,'2023-01-05 13:40:06','',''),(1105,'1','306','1',1,'Retail Sale Id 1096',2496.64,0.00,0.00,3.32,285.52,'2023-01-05 13:41:10','',''),(1106,'1','306','1',1,'Retail Sale Id 1097',4496.96,0.00,0.00,5.98,514.28,'2023-01-05 13:43:16','',''),(1107,'1','306','1',1,'Retail Sale Id 1098',9497.76,0.00,0.00,12.63,1086.18,'2023-01-05 13:45:01','',''),(1108,'1','306','1',1,'Retail Sale Id 1099',23040.00,0.00,0.00,32.00,1728.00,'2023-01-05 14:01:32','',''),(1109,'1','306','1',1,'Retail Sale Id 1100',2301.12,0.00,0.00,3.06,263.16,'2023-01-05 14:02:59','',''),(1110,'1','306','1',1,'Retail Sale Id 1101',2301.12,0.00,0.00,3.06,263.16,'2023-01-05 14:04:17','',''),(1111,'1','306','1',1,'Retail Sale Id 1102',1496.48,0.00,0.00,1.99,171.14,'2023-01-05 14:05:27','',''),(1112,'1','306','1',1,'Retail Sale Id 1103',4512.00,0.00,0.00,6.00,516.00,'2023-01-05 14:06:24','',''),(1113,'1','306','1',1,'Retail Sale Id 1104',2496.64,0.00,0.00,3.32,285.52,'2023-01-05 14:19:17','',''),(1114,'1','306','1',1,'Retail Sale Id 1105',3000.48,0.00,0.00,3.99,343.14,'2023-01-05 14:23:52','',''),(1115,'1','306','1',1,'Retail Sale Id 1106',1797.28,0.00,0.00,2.39,205.54,'2023-01-05 14:25:53','',''),(1116,'1','306','1',1,'Retail Sale Id 1107',2203.36,0.00,0.00,2.93,251.98,'2023-01-05 14:29:45','',''),(1117,'1','306','1',1,'Retail Sale Id 1108',2256.00,0.00,0.00,3.00,258.00,'2023-01-05 14:30:43','',''),(1118,'1','306','1',1,'Retail Sale Id 1109',14400.00,0.00,0.00,20.00,1080.00,'2023-01-05 14:38:10','',''),(1119,'1','306','1',1,'Retail Sale Id 1110',3797.60,0.00,0.00,5.05,434.30,'2023-01-05 15:32:17','',''),(1120,'1','306','1',1,'Retail Sale Id 1111',3797.60,0.00,0.00,5.05,434.30,'2023-01-05 15:39:42','',''),(1121,'1','306','1',1,'Retail Sale Id 1112',2301.12,0.00,0.00,3.06,263.16,'2023-01-05 15:47:24','',''),(1122,'1','306','1',1,'Retail Sale Id 1113',13002.08,0.00,0.00,17.29,1486.94,'2023-01-05 15:49:03','',''),(1123,'1','306','1',1,'Retail Sale Id 1114',2000.32,0.00,0.00,2.66,228.76,'2023-01-05 15:50:46','',''),(1124,'1','306','1',1,'Retail Sale Id 1115',7520.00,0.00,0.00,10.00,860.00,'2023-01-05 15:52:23','',''),(1125,'1','306','1',1,'Retail Sale Id 1116',3797.60,0.00,0.00,5.05,434.30,'2023-01-05 15:54:29','',''),(1126,'1','306','1',1,'Retail Sale Id 1117',9400.00,0.00,0.00,12.50,1075.00,'2023-01-05 15:58:05','',''),(1127,'1','306','1',1,'Retail Sale Id 1118',3008.00,0.00,0.00,4.00,344.00,'2023-01-05 15:59:00','',''),(1128,'1','306','1',1,'Retail Sale Id 1119',3797.60,0.00,0.00,5.05,434.30,'2023-01-05 16:05:51','',''),(1129,'1','306','1',1,'Retail Sale Id 1120',4512.00,0.00,0.00,6.00,516.00,'2023-01-05 16:08:06','',''),(1130,'1','306','1',1,'Retail Sale Id 1121',2256.00,0.00,0.00,3.00,258.00,'2023-01-05 16:09:14','',''),(1131,'1','306','1',1,'Retail Sale Id 1122',2301.12,0.00,0.00,3.06,263.16,'2023-01-05 16:27:25','',''),(1132,'1','306','1',1,'Retail Sale Id 1123',4496.96,0.00,0.00,5.98,514.28,'2023-01-05 16:29:52','',''),(1133,'1','306','1',1,'Retail Sale Id 1124',797.12,0.00,0.00,1.06,91.16,'2023-01-05 16:47:08','',''),(1134,'1','306','1',1,'Retail Sale Id 1125',1496.48,0.00,0.00,1.99,171.14,'2023-01-05 16:52:23','',''),(1135,'1','306','1',1,'Retail Sale Id 1126',2301.12,0.00,0.00,3.06,263.16,'2023-01-05 17:02:27','',''),(1136,'1','306','1',1,'Retail Sale Id 1127',4496.96,0.00,0.00,5.98,514.28,'2023-01-05 17:03:29','',''),(1137,'1','306','1',1,'Retail Sale Id 1128',3797.60,0.00,0.00,5.05,434.30,'2023-01-05 17:05:15','',''),(1138,'1','306','1',1,'Retail Sale Id 1129',2496.64,0.00,0.00,3.32,285.52,'2023-01-05 17:18:13','',''),(1139,'1','306','1',1,'Retail Sale Id 1130',2301.12,0.00,0.00,3.06,263.16,'2023-01-05 17:38:26','',''),(1140,'1','306','1',1,'Retail Sale Id 1131',1496.48,0.00,0.00,1.99,171.14,'2023-01-05 17:39:20','',''),(1141,'1','306','1',1,'Return of Retail Sale Id 1123',0.00,4496.96,5.98,0.00,-514.28,'2023-01-05 18:15:23','',''),(1142,'1','306','1',1,'Retail Sale Id 1132',2225.92,0.00,0.00,2.96,254.56,'2023-01-05 18:16:40','',''),(1143,'1','306','1',1,'Retail Sale Id 1133',1496.48,0.00,0.00,1.99,171.14,'2023-01-06 08:02:03','',''),(1144,'1','306','1',1,'Retail Sale Id 1134',2240.96,0.00,0.00,2.98,256.28,'2023-01-06 08:37:42','',''),(1145,'1','306','1',1,'Retail Sale Id 1135',1000.16,0.00,0.00,1.33,114.38,'2023-01-06 08:38:27','',''),(1146,'1','306','1',1,'Retail Sale Id 1136',3699.84,0.00,0.00,4.92,423.12,'2023-01-06 08:50:03','',''),(1147,'1','306','1',1,'Retail Sale Id 1138',5000.80,0.00,0.00,6.65,571.90,'2023-01-06 08:55:34','',''),(1148,'1','306','1',1,'Retail Sale Id 1139',1504.00,0.00,0.00,2.00,172.00,'2023-01-06 09:00:40','',''),(1149,'1','306','1',1,'Retail Sale Id 1140',2256.00,0.00,0.00,3.00,258.00,'2023-01-06 09:05:06','',''),(1150,'1','306','1',1,'Retail Sale Id 1141',3797.60,0.00,0.00,5.05,434.30,'2023-01-06 09:06:15','',''),(1151,'1','306','1',1,'Retail Sale Id 1142',1496.48,0.00,0.00,1.99,171.14,'2023-01-06 09:20:23','',''),(1152,'1','306','1',1,'Retail Sale Id 1143',3797.60,0.00,0.00,5.05,434.30,'2023-01-06 09:23:48','',''),(1153,'1','306','1',1,'Retail Sale Id 1144',1496.48,0.00,0.00,1.99,171.14,'2023-01-06 09:24:39','',''),(1154,'1','306','1',1,'Retail Sale Id 1145',6000.96,0.00,0.00,7.98,686.28,'2023-01-06 09:44:38','',''),(1155,'1','306','1',1,'Retail Sale Id 1146',7520.00,0.00,0.00,10.00,860.00,'2023-01-06 09:46:23','',''),(1156,'1','306','1',1,'Retail Sale Id 1147',3008.00,0.00,0.00,4.00,344.00,'2023-01-06 09:50:32','',''),(1157,'1','306','1',1,'Retail Sale Id 1148',3008.00,0.00,0.00,4.00,344.00,'2023-01-06 09:57:53','',''),(1158,'1','306','1',1,'Retail Sale Id 1149',5497.12,0.00,0.00,7.31,628.66,'2023-01-06 09:59:41','',''),(1159,'1','306','1',1,'Retail Sale Id 1150',2301.12,0.00,0.00,3.06,263.16,'2023-01-06 10:04:27','',''),(1160,'1','306','1',1,'Retail Sale Id 1152',2256.00,0.00,0.00,3.00,258.00,'2023-01-06 10:10:14','',''),(1161,'1','306','1',1,'Retail Sale Id 1153',2301.12,0.00,0.00,3.06,263.16,'2023-01-06 10:12:46','',''),(1162,'1','306','1',1,'Retail Sale Id 1154',3797.60,0.00,0.00,5.05,434.30,'2023-01-06 10:13:45','',''),(1163,'1','306','1',1,'Retail Sale Id 1155',4512.00,0.00,0.00,6.00,516.00,'2023-01-06 10:16:27','',''),(1164,'1','306','1',1,'Retail Sale Id 1156',3797.60,0.00,0.00,5.05,434.30,'2023-01-06 10:17:58','',''),(1165,'1','306','1',1,'Retail Sale Id 1157',3699.84,0.00,0.00,4.92,423.12,'2023-01-06 10:23:14','',''),(1166,'1','306','1',1,'Retail Sale Id 1158',4496.96,0.00,0.00,5.98,514.28,'2023-01-06 10:27:57','',''),(1167,'1','306','1',1,'Retail Sale Id 1160',3797.60,0.00,0.00,5.05,434.30,'2023-01-06 10:29:18','',''),(1168,'1','306','1',1,'Retail Sale Id 1161',2301.12,0.00,0.00,3.06,263.16,'2023-01-06 10:31:25','',''),(1169,'1','306','1',1,'Retail Sale Id 1162',2000.32,0.00,0.00,2.66,228.76,'2023-01-06 10:34:01','',''),(1170,'1','306','1',1,'Retail Sale Id 1162',5000.80,0.00,0.00,6.65,571.90,'2023-01-06 10:34:01','',''),(1171,'1','306','1',1,'Retail Sale Id 1163',3008.00,0.00,0.00,4.00,344.00,'2023-01-06 10:41:30','',''),(1172,'1','306','1',1,'Retail Sale Id 1164',43200.00,0.00,0.00,60.00,3240.00,'2023-01-06 10:49:08','',''),(1173,'1','306','1',1,'Retail Sale Id 1165',2301.12,0.00,0.00,3.06,263.16,'2023-01-06 11:02:16','',''),(1174,'1','306','1',1,'Retail Sale Id 1166',4496.96,0.00,0.00,5.98,514.28,'2023-01-06 11:03:42','',''),(1175,'1','306','1',1,'Retail Sale Id 1167',4496.96,0.00,0.00,5.98,514.28,'2023-01-06 11:08:50','',''),(1176,'1','306','1',1,'Retail Sale Id 1168',797.12,0.00,0.00,1.06,91.16,'2023-01-06 11:09:59','',''),(1177,'1','306','1',1,'Retail Sale Id 1169',4496.96,0.00,0.00,5.98,514.28,'2023-01-06 11:13:47','',''),(1178,'1','306','1',1,'Retail Sale Id 1170',20160.00,0.00,0.00,28.00,1512.00,'2023-01-06 11:20:09','',''),(1179,'1','306','1',1,'Retail Sale Id 1171',18000.00,0.00,0.00,25.00,1350.00,'2023-01-06 11:22:10','',''),(1180,'1','306','1',1,'Retail Sale Id 1172',797.12,0.00,0.00,1.06,91.16,'2023-01-06 11:24:16','',''),(1181,'1','306','1',1,'Retail Sale Id 1173',6000.96,0.00,0.00,7.98,686.28,'2023-01-06 11:38:17','',''),(1182,'1','306','1',1,'Retail Sale Id 1174',2203.36,0.00,0.00,2.93,251.98,'2023-01-06 11:39:38','',''),(1183,'1','306','1',1,'Retail Sale Id 1175',9400.00,0.00,0.00,12.50,1075.00,'2023-01-06 11:40:59','',''),(1184,'1','306','1',1,'Retail Sale Id 1175',9400.00,0.00,0.00,12.50,1075.00,'2023-01-06 11:40:59','',''),(1185,'1','306','1',1,'Retail Sale Id 1176',4496.96,0.00,0.00,5.98,514.28,'2023-01-06 11:41:54','',''),(1186,'1','306','1',1,'Retail Sale Id 1177',1496.48,0.00,0.00,1.99,171.14,'2023-01-06 11:47:45','',''),(1187,'1','306','1',1,'Retail Sale Id 1178',8272.00,0.00,0.00,11.00,946.00,'2023-01-06 12:08:01','',''),(1188,'1','306','1',1,'Retail Sale Id 1179',1000.16,0.00,0.00,1.33,114.38,'2023-01-06 12:11:04','',''),(1189,'1','306','1',1,'Retail Sale Id 1180',3000.48,0.00,0.00,3.99,343.14,'2023-01-06 12:12:10','',''),(1190,'1','306','1',1,'Retail Sale Id 1181',2256.00,0.00,0.00,3.00,258.00,'2023-01-06 12:16:30','',''),(1191,'1','306','1',1,'Retail Sale Id 1182',797.12,0.00,0.00,1.06,91.16,'2023-01-06 12:30:43','',''),(1192,'1','306','1',1,'Retail Sale Id 1183',2248.48,0.00,0.00,2.99,257.14,'2023-01-06 12:38:53','',''),(1193,'1','306','1',1,'Retail Sale Id 1184',4512.00,0.00,0.00,6.00,516.00,'2023-01-06 12:45:06','',''),(1194,'1','306','1',1,'Retail Sale Id 1185',2301.12,0.00,0.00,3.06,263.16,'2023-01-06 12:47:49','',''),(1195,'1','306','1',1,'Retail Sale Id 1186',1496.48,0.00,0.00,1.99,171.14,'2023-01-06 12:51:44','',''),(1196,'1','306','1',1,'Retail Sale Id 1187',36000.00,0.00,0.00,50.00,2700.00,'2023-01-06 12:58:20','',''),(1197,'1','306','1',1,'Retail Sale Id 1188',7497.44,0.00,0.00,9.97,857.42,'2023-01-06 13:14:22','',''),(1198,'1','306','1',1,'Retail Sale Id 1189',1496.48,0.00,0.00,1.99,171.14,'2023-01-06 13:16:01','',''),(1199,'1','306','1',1,'Retail Sale Id 1190',4512.00,0.00,0.00,6.00,516.00,'2023-01-06 13:22:24','',''),(1200,'1','306','1',1,'Retail Sale Id 1190',9400.00,0.00,0.00,12.50,1075.00,'2023-01-06 13:22:24','',''),(1201,'1','306','1',1,'Retail Sale Id 1191',2496.64,0.00,0.00,3.32,285.52,'2023-01-06 13:26:48','',''),(1202,'1','306','1',1,'Retail Sale Id 1192',9497.76,0.00,0.00,12.63,1086.18,'2023-01-06 13:41:29','',''),(1203,'1','306','1',1,'Retail Sale Id 1193',3000.48,0.00,0.00,3.99,343.14,'2023-01-06 13:51:03','',''),(1204,'1','306','1',1,'Retail Sale Id 1194',7497.44,0.00,0.00,9.97,857.42,'2023-01-06 15:12:05','',''),(1205,'1','306','1',1,'Retail Sale Id 1195',9400.00,0.00,0.00,12.50,1075.00,'2023-01-06 15:13:28','',''),(1206,'1','306','1',1,'Retail Sale Id 1196',3797.60,0.00,0.00,5.05,434.30,'2023-01-06 15:22:01','',''),(1207,'1','306','1',1,'Retail Sale Id 1197',2301.12,0.00,0.00,3.06,263.16,'2023-01-06 15:26:33','',''),(1208,'1','306','1',1,'Retail Sale Id 1198',3752.48,0.00,0.00,4.99,429.14,'2023-01-06 15:39:54','',''),(1209,'1','306','1',1,'Retail Sale Id 1199',2301.12,0.00,0.00,3.06,263.16,'2023-01-06 15:43:28','',''),(1210,'1','306','1',1,'Retail Sale Id 1200',2203.36,0.00,0.00,2.93,251.98,'2023-01-06 15:45:53','',''),(1211,'1','306','1',1,'Retail Sale Id 1201',3797.60,0.00,0.00,5.05,434.30,'2023-01-06 15:50:11','',''),(1212,'1','306','1',1,'Retail Sale Id 1202',1496.48,0.00,0.00,1.99,171.14,'2023-01-06 15:53:11','',''),(1213,'1','306','1',1,'Retail Sale Id 1203',1504.00,0.00,0.00,2.00,172.00,'2023-01-06 15:55:30','',''),(1214,'1','306','1',1,'Retail Sale Id 1203',1504.00,0.00,0.00,2.00,172.00,'2023-01-06 15:55:30','',''),(1215,'1','306','1',1,'Retail Sale Id 1203',1504.00,0.00,0.00,2.00,172.00,'2023-01-06 15:55:30','',''),(1216,'1','306','1',1,'Retail Sale Id 1204',6000.96,0.00,0.00,7.98,686.28,'2023-01-06 15:56:29','',''),(1217,'1','306','1',1,'Retail Sale Id 1205',1496.48,0.00,0.00,1.99,171.14,'2023-01-06 16:03:34','',''),(1218,'1','306','1',1,'Retail Sale Id 1206',797.12,0.00,0.00,1.06,91.16,'2023-01-06 16:12:22','',''),(1219,'1','306','1',1,'Retail Sale Id 1207',1496.48,0.00,0.00,1.99,171.14,'2023-01-06 16:23:42','',''),(1220,'1','306','1',1,'Retail Sale Id 1208',4000.64,0.00,0.00,5.32,457.52,'2023-01-06 16:33:33','',''),(1221,'1','306','1',1,'Retail Sale Id 1209',9497.76,0.00,0.00,12.63,1086.18,'2023-01-06 16:34:46','',''),(1222,'1','306','1',1,'Retail Sale Id 1210',2496.64,0.00,0.00,3.32,285.52,'2023-01-06 16:36:17','',''),(1223,'1','306','1',1,'Retail Sale Id 1211',2248.48,0.00,0.00,2.99,257.14,'2023-01-06 16:44:25','',''),(1224,'1','306','1',1,'Retail Sale Id 1212',2248.48,0.00,0.00,2.99,257.14,'2023-01-06 16:48:56','',''),(1225,'1','306','1',1,'Retail Sale Id 1213',5000.80,0.00,0.00,6.65,571.90,'2023-01-06 16:49:36','',''),(1226,'1','306','1',1,'Retail Sale Id 1214',1496.48,0.00,0.00,1.99,171.14,'2023-01-06 16:50:28','',''),(1227,'1','306','1',1,'Retail Sale Id 1215',1496.48,0.00,0.00,1.99,171.14,'2023-01-06 17:02:57','',''),(1228,'1','306','1',1,'Retail Sale Id 1216',4496.96,0.00,0.00,5.98,514.28,'2023-01-06 17:19:07','',''),(1229,'1','306','1',1,'Retail Sale Id 1217',2301.12,0.00,0.00,3.06,263.16,'2023-01-06 17:21:38','',''),(1230,'1','306','1',1,'Retail Sale Id 1218',4000.64,0.00,0.00,5.32,457.52,'2023-01-06 17:29:21','',''),(1231,'1','306','1',1,'Retail Sale Id 1219',2301.12,0.00,0.00,3.06,263.16,'2023-01-06 17:36:25','',''),(1232,'1','306','1',1,'Retail Sale Id 1220',9000.00,0.00,0.00,12.50,675.00,'2023-01-06 17:39:04','',''),(1233,'1','306','1',1,'Retail Sale Id 1221',3000.48,0.00,0.00,3.99,343.14,'2023-01-06 18:07:54','',''),(1234,'1','306','1',1,'Retail Sale Id 1222',1496.48,0.00,0.00,1.99,171.14,'2023-01-06 18:14:55','',''),(1235,'1','306','1',1,'Retail Sale Id 1223',1496.48,0.00,0.00,1.99,171.14,'2023-01-06 18:16:05','',''),(1236,'1','306','1',1,'Retail Sale Id 1224',3000.48,0.00,0.00,3.99,343.14,'2023-01-06 18:22:48','',''),(1237,'1','306','1',1,'Retail Sale Id 1225',3000.48,0.00,0.00,3.99,343.14,'2023-01-06 18:29:55','',''),(1238,'1','306','1',1,'Return of Retail Sale Id 1225',0.00,3000.48,3.99,0.00,-343.14,'2023-01-06 18:32:50','',''),(1239,'1','306','1',1,'Retail Sale Id 1226',2571.84,0.00,0.00,3.42,294.12,'2023-01-06 18:34:35','',''),(1240,'1','306','1',1,'Retail Sale Id 1227',4512.00,0.00,0.00,6.00,516.00,'2023-01-07 07:52:19','',''),(1241,'1','306','1',1,'Retail Sale Id 1228',1496.48,0.00,0.00,1.99,171.14,'2023-01-07 07:53:20','',''),(1242,'1','306','1',1,'Retail Sale Id 1229',752.00,0.00,0.00,1.00,86.00,'2023-01-07 08:13:27','',''),(1243,'1','306','1',1,'Retail Sale Id 1230',3000.48,0.00,0.00,3.99,343.14,'2023-01-07 08:14:14','',''),(1244,'1','306','1',1,'Retail Sale Id 1231',36000.00,0.00,0.00,50.00,2700.00,'2023-01-07 08:15:11','',''),(1245,'1','306','1',1,'Retail Sale Id 1232',4496.96,0.00,0.00,5.98,514.28,'2023-01-07 08:18:16','',''),(1246,'1','306','1',1,'Retail Sale Id 1233',4496.96,0.00,0.00,5.98,514.28,'2023-01-07 08:21:21','',''),(1247,'1','306','1',1,'Retail Sale Id 1234',4496.96,0.00,0.00,5.98,514.28,'2023-01-07 08:22:36','',''),(1248,'1','306','1',1,'Retail Sale Id 1235',3699.84,0.00,0.00,4.92,423.12,'2023-01-07 08:27:15','',''),(1249,'1','306','1',1,'Retail Sale Id 1236',3000.48,0.00,0.00,3.99,343.14,'2023-01-07 08:27:55','',''),(1250,'1','306','1',1,'Retail Sale Id 1237',2301.12,0.00,0.00,3.06,263.16,'2023-01-07 08:33:51','',''),(1251,'1','306','1',1,'Retail Sale Id 1238',4496.96,0.00,0.00,5.98,514.28,'2023-01-07 08:35:04','',''),(1252,'1','306','1',1,'Retail Sale Id 1239',4512.00,0.00,0.00,6.00,516.00,'2023-01-07 08:39:41','',''),(1253,'1','306','1',1,'Retail Sale Id 1240',2301.12,0.00,0.00,3.06,263.16,'2023-01-07 08:45:16','',''),(1254,'1','306','1',1,'Retail Sale Id 1241',1496.48,0.00,0.00,1.99,171.14,'2023-01-07 08:56:02','',''),(1255,'1','306','1',1,'Retail Sale Id 1243',9497.76,0.00,0.00,12.63,1086.18,'2023-01-07 08:59:51','',''),(1256,'1','306','1',1,'Retail Sale Id 1244',7001.12,0.00,0.00,9.31,800.66,'2023-01-07 09:01:09','',''),(1257,'1','306','1',1,'Retail Sale Id 1245',752.00,0.00,0.00,1.00,86.00,'2023-01-07 09:02:00','',''),(1258,'1','306','1',1,'Retail Sale Id 1246',4496.96,0.00,0.00,5.98,514.28,'2023-01-07 09:03:11','',''),(1259,'1','306','1',1,'Retail Sale Id 1247',2301.12,0.00,0.00,3.06,263.16,'2023-01-07 09:04:12','',''),(1260,'1','306','1',1,'Retail Sale Id 1248',4496.96,0.00,0.00,5.98,514.28,'2023-01-07 09:05:25','',''),(1261,'1','306','1',1,'Retail Sale Id 1249',752.00,0.00,0.00,1.00,86.00,'2023-01-07 09:07:28','',''),(1262,'1','306','1',1,'Retail Sale Id 1250',19440.00,0.00,0.00,27.00,1458.00,'2023-01-07 09:11:36','',''),(1263,'1','306','1',1,'Retail Sale Id 1252',9400.00,0.00,0.00,12.50,1075.00,'2023-01-07 09:13:56','',''),(1264,'1','306','1',1,'Retail Sale Id 1253',4496.96,0.00,0.00,5.98,514.28,'2023-01-07 09:15:17','',''),(1265,'1','306','1',1,'Retail Sale Id 1254',1496.48,0.00,0.00,1.99,171.14,'2023-01-07 09:19:20','',''),(1266,'1','306','1',1,'Retail Sale Id 1255',3797.60,0.00,0.00,5.05,434.30,'2023-01-07 09:24:37','',''),(1267,'1','306','1',1,'Retail Sale Id 1256',2301.12,0.00,0.00,3.06,263.16,'2023-01-07 09:35:24','',''),(1268,'1','306','1',1,'Retail Sale Id 1257',752.00,0.00,0.00,1.00,86.00,'2023-01-07 09:39:03','',''),(1269,'1','306','1',1,'Retail Sale Id 1258',3797.60,0.00,0.00,5.05,434.30,'2023-01-07 09:47:07','',''),(1270,'1','306','1',1,'Retail Sale Id 1259',4496.96,0.00,0.00,5.98,514.28,'2023-01-07 09:48:55','',''),(1271,'1','306','1',1,'Retail Sale Id 1260',2301.12,0.00,0.00,3.06,263.16,'2023-01-07 09:54:11','',''),(1272,'1','306','1',1,'Retail Sale Id 1261',3000.48,0.00,0.00,3.99,343.14,'2023-01-07 09:55:32','',''),(1273,'1','306','1',1,'Retail Sale Id 1264',3760.00,0.00,0.00,5.00,430.00,'2023-01-07 09:57:38','',''),(1274,'1','306','1',1,'Retail Sale Id 1265',1496.48,0.00,0.00,1.99,171.14,'2023-01-07 09:58:53','',''),(1275,'1','306','1',1,'Retail Sale Id 1266',797.12,0.00,0.00,1.06,91.16,'2023-01-07 10:00:05','',''),(1276,'1','306','1',1,'Retail Sale Id 1267',2301.12,0.00,0.00,3.06,263.16,'2023-01-07 10:01:41','',''),(1277,'1','306','1',1,'Retail Sale Id 1268',1496.48,0.00,0.00,1.99,171.14,'2023-01-07 10:03:26','',''),(1278,'1','306','1',1,'Retail Sale Id 1269',2301.12,0.00,0.00,3.06,263.16,'2023-01-07 10:06:43','',''),(1279,'1','306','1',1,'Retail Sale Id 1270',3760.00,0.00,0.00,5.00,430.00,'2023-01-07 10:20:42','',''),(1280,'1','306','1',1,'Retail Sale Id 1271',2248.48,0.00,0.00,2.99,257.14,'2023-01-07 10:22:10','',''),(1281,'1','306','1',1,'Retail Sale Id 1272',1496.48,0.00,0.00,1.99,171.14,'2023-01-07 10:25:39','',''),(1282,'1','306','1',1,'Retail Sale Id 1273',4496.96,0.00,0.00,5.98,514.28,'2023-01-07 10:26:57','',''),(1283,'1','306','1',1,'Retail Sale Id 1274',1496.48,0.00,0.00,1.99,171.14,'2023-01-07 10:27:51','',''),(1284,'1','306','1',1,'Retail Sale Id 1275',4496.96,0.00,0.00,5.98,514.28,'2023-01-07 10:29:20','',''),(1285,'1','306','1',1,'Retail Sale Id 1276',2256.00,0.00,0.00,3.00,258.00,'2023-01-07 10:31:50','',''),(1286,'1','306','1',1,'Retail Sale Id 1277',83520.00,0.00,0.00,116.00,6264.00,'2023-01-07 10:39:34','',''),(1287,'1','306','1',1,'Retail Sale Id 1278',9400.00,0.00,0.00,12.50,1075.00,'2023-01-07 10:41:45','',''),(1288,'1','306','1',1,'Retail Sale Id 1279',1496.48,0.00,0.00,1.99,171.14,'2023-01-07 10:43:24','',''),(1289,'1','306','1',1,'Retail Sale Id 1280',2203.36,0.00,0.00,2.93,251.98,'2023-01-07 10:44:55','',''),(1290,'1','306','1',1,'Retail Sale Id 1281',3000.48,0.00,0.00,3.99,343.14,'2023-01-07 10:46:25','',''),(1291,'1','306','1',1,'Retail Sale Id 1282',1496.48,0.00,0.00,1.99,171.14,'2023-01-07 10:47:52','',''),(1292,'1','306','1',1,'Retail Sale Id 1283',7001.12,0.00,0.00,9.31,800.66,'2023-01-07 10:49:16','',''),(1293,'1','306','1',1,'Retail Sale Id 1284',86400.00,0.00,0.00,120.00,6480.00,'2023-01-07 10:52:52','',''),(1294,'1','306','1',1,'Retail Sale Id 1285',3000.48,0.00,0.00,3.99,343.14,'2023-01-07 10:54:56','',''),(1295,'1','306','1',1,'Retail Sale Id 1286',2601.92,0.00,0.00,3.46,297.56,'2023-01-07 10:56:34','',''),(1296,'1','306','1',1,'Retail Sale Id 1287',2301.12,0.00,0.00,3.06,263.16,'2023-01-07 10:57:56','',''),(1297,'1','306','1',1,'Retail Sale Id 1288',85680.00,0.00,0.00,119.00,6426.00,'2023-01-07 11:04:06','',''),(1298,'1','306','1',1,'Retail Sale Id 1289',25200.00,0.00,0.00,35.00,1890.00,'2023-01-07 11:08:09','',''),(1299,'1','306','1',1,'Retail Sale Id 1290',3008.00,0.00,0.00,4.00,344.00,'2023-01-07 11:08:57','',''),(1300,'1','306','1',1,'Retail Sale Id 1291',4512.00,0.00,0.00,6.00,516.00,'2023-01-07 11:10:37','',''),(1301,'1','306','1',1,'Retail Sale Id 1292',4496.96,0.00,0.00,5.98,514.28,'2023-01-07 11:17:08','',''),(1302,'1','306','1',1,'Retail Sale Id 1293',3008.00,0.00,0.00,4.00,344.00,'2023-01-07 11:18:24','',''),(1303,'1','306','1',1,'Retail Sale Id 1294',4496.96,0.00,0.00,5.98,514.28,'2023-01-07 11:24:05','',''),(1304,'1','306','1',1,'Retail Sale Id 1295',2256.00,0.00,0.00,3.00,258.00,'2023-01-07 11:25:58','',''),(1305,'1','306','1',1,'Retail Sale Id 1296',6000.96,0.00,0.00,7.98,686.28,'2023-01-07 11:26:57','',''),(1306,'1','306','1',1,'Retail Sale Id 1297',201600.00,0.00,0.00,280.00,15120.00,'2023-01-07 11:31:41','',''),(1307,'1','306','1',1,'Retail Sale Id 1298',1496.48,0.00,0.00,1.99,171.14,'2023-01-07 11:34:21','',''),(1308,'1','306','1',1,'Retail Sale Id 1298',2256.00,0.00,0.00,3.00,258.00,'2023-01-07 11:34:22','',''),(1309,'1','306','1',1,'Retail Sale Id 1299',7520.00,0.00,0.00,10.00,860.00,'2023-01-07 11:37:13','',''),(1310,'1','306','1',1,'Retail Sale Id 1300',3000.48,0.00,0.00,3.99,343.14,'2023-01-07 11:39:02','',''),(1311,'1','306','1',1,'Retail Sale Id 1301',4000.64,0.00,0.00,5.32,457.52,'2023-01-07 11:40:31','',''),(1312,'1','306','1',1,'Retail Sale Id 1302',19440.00,0.00,0.00,27.00,1458.00,'2023-01-07 11:43:42','',''),(1313,'1','306','1',1,'Retail Sale Id 1303',2301.12,0.00,0.00,3.06,263.16,'2023-01-07 11:45:07','',''),(1314,'1','306','1',1,'Retail Sale Id 1304',50400.00,0.00,0.00,70.00,3780.00,'2023-01-07 11:57:09','',''),(1315,'1','306','1',1,'Retail Sale Id 1305',752.00,0.00,0.00,1.00,86.00,'2023-01-07 12:00:49','',''),(1316,'1','306','1',1,'Retail Sale Id 1306',1496.48,0.00,0.00,1.99,171.14,'2023-01-07 12:04:24','',''),(1317,'1','306','1',1,'Retail Sale Id 1307',2000.32,0.00,0.00,2.66,228.76,'2023-01-07 12:07:01','',''),(1318,'1','306','1',1,'Retail Sale Id 1308',7497.44,0.00,0.00,9.97,857.42,'2023-01-07 12:08:43','',''),(1319,'1','306','1',1,'Retail Sale Id 1309',797.12,0.00,0.00,1.06,91.16,'2023-01-07 12:20:06','',''),(1320,'1','306','1',1,'Retail Sale Id 1310',2256.00,0.00,0.00,3.00,258.00,'2023-01-07 12:21:45','',''),(1321,'1','306','1',1,'Retail Sale Id 1310',3760.00,0.00,0.00,5.00,430.00,'2023-01-07 12:21:45','',''),(1322,'1','306','1',1,'Retail Sale Id 1311',4496.96,0.00,0.00,5.98,514.28,'2023-01-07 12:23:23','',''),(1323,'1','306','1',1,'Retail Sale Id 1312',1496.48,0.00,0.00,1.99,171.14,'2023-01-07 12:39:57','',''),(1324,'1','306','1',1,'Retail Sale Id 1313',9001.44,0.00,0.00,11.97,1029.42,'2023-01-07 12:41:13','',''),(1325,'1','306','1',1,'Retail Sale Id 1314',9000.00,0.00,0.00,12.50,675.00,'2023-01-07 12:48:52','',''),(1326,'1','306','1',1,'Retail Sale Id 1315',3000.48,0.00,0.00,3.99,343.14,'2023-01-07 12:58:55','',''),(1327,'1','306','1',1,'Retail Sale Id 1316',3008.00,0.00,0.00,4.00,344.00,'2023-01-07 13:00:16','',''),(1328,'1','306','1',1,'Retail Sale Id 1317',2301.12,0.00,0.00,3.06,263.16,'2023-01-07 13:08:23','',''),(1329,'1','306','1',1,'Retail Sale Id 1318',21600.00,0.00,0.00,30.00,1620.00,'2023-01-07 13:11:06','',''),(1330,'1','306','1',1,'Retail Sale Id 1319',797.12,0.00,0.00,1.06,91.16,'2023-01-07 13:28:00','',''),(1331,'1','306','1',1,'Retail Sale Id 1320',2256.00,0.00,0.00,3.00,258.00,'2023-01-07 13:29:32','',''),(1332,'1','306','1',1,'Retail Sale Id 1321',2203.36,0.00,0.00,2.93,251.98,'2023-01-07 13:30:27','',''),(1333,'1','306','1',1,'Retail Sale Id 1322',1880.00,0.00,0.00,2.50,215.00,'2023-01-07 13:36:24','',''),(1334,'1','306','1',1,'Retail Sale Id 1323',4512.00,0.00,0.00,6.00,516.00,'2023-01-07 13:38:46','',''),(1335,'1','306','1',1,'Retail Sale Id 1324',4512.00,0.00,0.00,6.00,516.00,'2023-01-07 13:43:57','',''),(1336,'1','306','1',1,'Retail Sale Id 1325',1496.48,0.00,0.00,1.99,171.14,'2023-01-07 13:44:57','',''),(1337,'1','306','1',1,'Retail Sale Id 1326',1496.48,0.00,0.00,1.99,171.14,'2023-01-07 13:48:52','',''),(1338,'1','306','1',1,'Retail Sale Id 1327',1496.48,0.00,0.00,1.99,171.14,'2023-01-07 13:49:44','',''),(1339,'1','306','1',1,'Retail Sale Id 1328',3008.00,0.00,0.00,4.00,344.00,'2023-01-07 14:28:12','',''),(1340,'1','306','1',1,'Retail Sale Id 1329',2301.12,0.00,0.00,3.06,263.16,'2023-01-07 14:29:30','',''),(1341,'1','306','1',1,'Retail Sale Id 1330',4512.00,0.00,0.00,6.00,516.00,'2023-01-07 14:31:21','',''),(1342,'1','306','1',1,'Retail Sale Id 1331',1496.48,0.00,0.00,1.99,171.14,'2023-01-07 14:39:36','',''),(1343,'1','306','1',1,'Retail Sale Id 1332',2256.00,0.00,0.00,3.00,258.00,'2023-01-07 14:44:42','',''),(1344,'1','306','1',1,'Retail Sale Id 1333',2301.12,0.00,0.00,3.06,263.16,'2023-01-07 14:47:25','',''),(1345,'1','306','1',1,'Retail Sale Id 1334',7497.44,0.00,0.00,9.97,857.42,'2023-01-07 14:51:05','',''),(1346,'1','306','1',1,'Retail Sale Id 1335',2301.12,0.00,0.00,3.06,263.16,'2023-01-07 14:57:28','',''),(1347,'1','306','1',1,'Retail Sale Id 1336',4496.96,0.00,0.00,5.98,514.28,'2023-01-07 15:07:04','',''),(1348,'1','306','1',1,'Retail Sale Id 1337',797.12,0.00,0.00,1.06,91.16,'2023-01-07 15:08:01','',''),(1349,'1','306','1',1,'Retail Sale Id 1338',2256.00,0.00,0.00,3.00,258.00,'2023-01-07 15:13:26','',''),(1350,'1','306','1',1,'Retail Sale Id 1339',9400.00,0.00,0.00,12.50,1075.00,'2023-01-07 15:21:04','',''),(1351,'1','306','1',1,'Retail Sale Id 1340',797.12,0.00,0.00,1.06,91.16,'2023-01-07 15:25:21','',''),(1352,'1','306','1',1,'Retail Sale Id 1341',1496.48,0.00,0.00,1.99,171.14,'2023-01-07 15:26:09','',''),(1353,'1','306','1',1,'Retail Sale Id 1342',3797.60,0.00,0.00,5.05,434.30,'2023-01-07 15:30:49','',''),(1354,'1','306','1',1,'Retail Sale Id 1343',1496.48,0.00,0.00,1.99,171.14,'2023-01-07 15:32:09','',''),(1355,'1','306','1',1,'Retail Sale Id 1344',2301.12,0.00,0.00,3.06,263.16,'2023-01-07 15:39:43','',''),(1356,'1','306','1',1,'Retail Sale Id 1345',3000.48,0.00,0.00,3.99,343.14,'2023-01-07 15:42:23','',''),(1357,'1','306','1',1,'Retail Sale Id 1346',5000.80,0.00,0.00,6.65,571.90,'2023-01-07 15:59:45','',''),(1358,'1','306','1',1,'Retail Sale Id 1347',2263.52,0.00,0.00,3.01,258.86,'2023-01-07 16:02:58','',''),(1359,'1','306','1',1,'Retail Sale Id 1348',3000.48,0.00,0.00,3.99,343.14,'2023-01-07 16:14:17','',''),(1360,'1','306','1',1,'Retail Sale Id 1349',2248.48,0.00,0.00,2.99,257.14,'2023-01-07 16:15:15','',''),(1361,'1','306','1',1,'Retail Sale Id 1350',6798.08,0.00,0.00,9.04,777.44,'2023-01-07 16:27:15','',''),(1362,'1','306','1',1,'Retail Sale Id 1351',5196.32,0.00,0.00,6.91,594.26,'2023-01-07 16:28:31','',''),(1363,'1','306','1',1,'Retail Sale Id 1352',9497.76,0.00,0.00,12.63,1086.18,'2023-01-07 16:33:03','',''),(1364,'1','306','1',1,'Retail Sale Id 1353',2248.48,0.00,0.00,2.99,257.14,'2023-01-07 16:34:13','',''),(1365,'1','306','1',1,'Retail Sale Id 1354',3000.48,0.00,0.00,3.99,343.14,'2023-01-07 16:38:44','',''),(1366,'1','306','1',1,'Retail Sale Id 1355',3000.48,0.00,0.00,3.99,343.14,'2023-01-07 16:39:34','',''),(1367,'1','306','1',1,'Retail Sale Id 1356',3000.48,0.00,0.00,3.99,343.14,'2023-01-07 16:40:35','',''),(1368,'1','306','1',1,'Retail Sale Id 1357',4496.96,0.00,0.00,5.98,514.28,'2023-01-07 16:43:58','',''),(1369,'1','306','1',1,'Retail Sale Id 1358',12240.00,0.00,0.00,17.00,918.00,'2023-01-07 16:55:39','',''),(1370,'1','306','1',1,'Retail Sale Id 1359',1601.76,0.00,0.00,2.13,183.18,'2023-01-07 16:56:36','',''),(1371,'1','306','1',1,'Retail Sale Id 1360',2301.12,0.00,0.00,3.06,263.16,'2023-01-07 16:57:33','',''),(1372,'1','306','1',1,'Retail Sale Id 1361',1496.48,0.00,0.00,1.99,171.14,'2023-01-07 16:58:37','',''),(1373,'1','306','1',1,'Retail Sale Id 1362',1496.48,0.00,0.00,1.99,171.14,'2023-01-07 17:00:17','',''),(1374,'1','306','1',1,'Retail Sale Id 1363',3797.60,0.00,0.00,5.05,434.30,'2023-01-07 17:03:40','',''),(1375,'1','306','1',1,'Retail Sale Id 1364',1504.00,0.00,0.00,2.00,172.00,'2023-01-07 17:06:21','',''),(1376,'1','306','1',1,'Retail Sale Id 1364',3008.00,0.00,0.00,4.00,344.00,'2023-01-07 17:06:21','',''),(1377,'1','306','1',1,'Retail Sale Id 1365',797.12,0.00,0.00,1.06,91.16,'2023-01-07 17:10:42','',''),(1378,'1','306','1',1,'Retail Sale Id 1366',2301.12,0.00,0.00,3.06,263.16,'2023-01-07 17:21:17','',''),(1379,'1','306','1',1,'Retail Sale Id 1367',2301.12,0.00,0.00,3.06,263.16,'2023-01-07 17:26:33','',''),(1380,'1','306','1',1,'Retail Sale Id 1368',2301.12,0.00,0.00,3.06,263.16,'2023-01-07 17:31:13','',''),(1381,'1','306','1',1,'Retail Sale Id 1369',2301.12,0.00,0.00,3.06,263.16,'2023-01-07 17:35:05','',''),(1382,'1','306','1',1,'Retail Sale Id 1371',4496.96,0.00,0.00,5.98,514.28,'2023-01-07 17:47:17','',''),(1383,'1','306','1',1,'Retail Sale Id 1372',3496.80,0.00,0.00,4.65,399.90,'2023-01-07 17:55:16','',''),(1384,'1','306','1',1,'Retail Sale Id 1373',4496.96,0.00,0.00,5.98,514.28,'2023-01-07 18:01:38','',''),(1385,'1','306','1',1,'Retail Sale Id 1374',4496.96,0.00,0.00,5.98,514.28,'2023-01-07 18:03:31','',''),(1386,'1','306','1',1,'Retail Sale Id 1375',4496.96,0.00,0.00,5.98,514.28,'2023-01-07 18:04:50','',''),(1387,'1','306','1',1,'Retail Sale Id 1376',25200.00,0.00,0.00,35.00,1890.00,'2023-01-07 18:09:10','',''),(1388,'1','306','1',1,'Retail Sale Id 1377',4496.96,0.00,0.00,5.98,514.28,'2023-01-07 18:10:02','',''),(1389,'1','306','1',1,'Retail Sale Id 1378',1496.48,0.00,0.00,1.99,171.14,'2023-01-07 18:12:03','',''),(1390,'1','306','1',1,'Retail Sale Id 1379',4496.96,0.00,0.00,5.98,514.28,'2023-01-07 18:13:17','',''),(1391,'1','306','1',1,'Retail Sale Id 1380',4496.96,0.00,0.00,5.98,514.28,'2023-01-07 18:14:12','',''),(1392,'1','306','1',1,'Retail Sale Id 1381',9400.00,0.00,0.00,12.50,1075.00,'2023-01-07 18:26:57','',''),(1393,'1','306','1',1,'Return of Retail Sale Id 1381',0.00,9400.00,12.50,0.00,-1075.00,'2023-01-07 18:36:18','',''),(1394,'1','306','1',1,'Retail Sale Id 1382',8452.48,0.00,0.00,11.24,966.64,'2023-01-07 18:37:26','',''),(1395,'1','306','1',1,'Retail Sale Id 1383',2000.32,0.00,0.00,2.66,228.76,'2023-01-08 07:50:51','',''),(1396,'1','306','1',1,'Retail Sale Id 1384',2699.68,0.00,0.00,3.59,308.74,'2023-01-08 07:55:09','',''),(1397,'1','306','1',1,'Retail Sale Id 1385',496.32,0.00,0.00,0.66,56.76,'2023-01-08 07:56:11','',''),(1398,'1','306','1',1,'Retail Sale Id 1386',9497.76,0.00,0.00,12.63,1086.18,'2023-01-08 08:02:38','',''),(1399,'1','306','1',1,'Retail Sale Id 1387',4496.96,0.00,0.00,5.98,514.28,'2023-01-08 08:08:06','',''),(1400,'1','306','1',1,'Retail Sale Id 1388',4549.60,0.00,0.00,6.05,520.30,'2023-01-08 08:15:34','',''),(1401,'1','306','1',1,'Retail Sale Id 1389',2000.32,0.00,0.00,2.66,228.76,'2023-01-08 08:22:36','',''),(1402,'1','306','1',1,'Retail Sale Id 1390',4496.96,0.00,0.00,5.98,514.28,'2023-01-08 08:30:16','',''),(1403,'1','306','1',1,'Retail Sale Id 1391',4512.00,0.00,0.00,6.00,516.00,'2023-01-08 08:31:02','',''),(1404,'1','306','1',1,'Retail Sale Id 1392',1496.48,0.00,0.00,1.99,171.14,'2023-01-08 08:56:05','',''),(1405,'1','306','1',1,'Retail Sale Id 1393',2256.00,0.00,0.00,3.00,258.00,'2023-01-08 08:58:03','',''),(1406,'1','306','1',1,'Retail Sale Id 1394',3797.60,0.00,0.00,5.05,434.30,'2023-01-08 08:59:57','',''),(1407,'1','306','1',1,'Retail Sale Id 1395',4496.96,0.00,0.00,5.98,514.28,'2023-01-08 09:09:15','',''),(1408,'1','306','1',1,'Retail Sale Id 1396',9400.00,0.00,0.00,12.50,1075.00,'2023-01-08 09:13:16','',''),(1409,'1','306','1',1,'Retail Sale Id 1397',3000.48,0.00,0.00,3.99,343.14,'2023-01-08 09:14:37','',''),(1410,'1','306','1',1,'Retail Sale Id 1398',7497.44,0.00,0.00,9.97,857.42,'2023-01-08 09:15:50','',''),(1411,'1','306','1',1,'Retail Sale Id 1399',1496.48,0.00,0.00,1.99,171.14,'2023-01-08 09:22:35','',''),(1412,'1','306','1',1,'Retail Sale Id 1400',3797.60,0.00,0.00,5.05,434.30,'2023-01-08 09:26:41','',''),(1413,'1','306','1',1,'Retail Sale Id 1401',4496.96,0.00,0.00,5.98,514.28,'2023-01-08 09:28:48','',''),(1414,'1','306','1',1,'Retail Sale Id 1402',3008.00,0.00,0.00,4.00,344.00,'2023-01-08 09:33:59','',''),(1415,'1','306','1',1,'Retail Sale Id 1403',2301.12,0.00,0.00,3.06,263.16,'2023-01-08 09:39:13','',''),(1416,'1','306','1',1,'Retail Sale Id 1404',4496.96,0.00,0.00,5.98,514.28,'2023-01-08 09:40:36','',''),(1417,'1','306','1',1,'Retail Sale Id 1405',797.12,0.00,0.00,1.06,91.16,'2023-01-08 09:44:11','',''),(1418,'1','306','1',1,'Retail Sale Id 1406',3760.00,0.00,0.00,5.00,430.00,'2023-01-08 09:52:52','',''),(1419,'1','306','1',1,'Retail Sale Id 1407',6016.00,0.00,0.00,8.00,688.00,'2023-01-08 10:06:10','',''),(1420,'1','306','1',1,'Retail Sale Id 1407',9400.00,0.00,0.00,12.50,1075.00,'2023-01-08 10:06:10','',''),(1421,'1','306','1',1,'Retail Sale Id 1408',1000.16,0.00,0.00,1.33,114.38,'2023-01-08 10:07:35','',''),(1422,'1','306','1',1,'Retail Sale Id 1409',2000.32,0.00,0.00,2.66,228.76,'2023-01-08 10:28:46','',''),(1423,'1','306','1',1,'Retail Sale Id 1410',3008.00,0.00,0.00,4.00,344.00,'2023-01-08 10:30:55','',''),(1424,'1','306','1',1,'Retail Sale Id 1411',4496.96,0.00,0.00,5.98,514.28,'2023-01-08 10:31:52','',''),(1425,'1','306','1',1,'Retail Sale Id 1412',4496.96,0.00,0.00,5.98,514.28,'2023-01-08 10:37:13','',''),(1426,'1','306','1',1,'Retail Sale Id 1413',797.12,0.00,0.00,1.06,91.16,'2023-01-08 10:54:36','',''),(1427,'1','306','1',1,'Retail Sale Id 1415',496.32,0.00,0.00,0.66,56.76,'2023-01-08 11:07:55','',''),(1428,'1','306','1',1,'Retail Sale Id 1415',2301.12,0.00,0.00,3.06,263.16,'2023-01-08 11:07:55','',''),(1429,'1','306','1',1,'Retail Sale Id 1416',797.12,0.00,0.00,1.06,91.16,'2023-01-08 11:11:25','',''),(1430,'1','306','1',1,'Retail Sale Id 1417',2301.12,0.00,0.00,3.06,263.16,'2023-01-08 11:15:39','',''),(1431,'1','306','1',1,'Retail Sale Id 1418',3000.48,0.00,0.00,3.99,343.14,'2023-01-08 11:18:41','',''),(1432,'1','306','1',1,'Retail Sale Id 1419',699.36,0.00,0.00,0.93,79.98,'2023-01-08 11:23:42','',''),(1433,'1','306','1',1,'Retail Sale Id 1420',797.12,0.00,0.00,1.06,91.16,'2023-01-08 11:24:53','',''),(1434,'1','306','1',1,'Retail Sale Id 1421',3699.84,0.00,0.00,4.92,423.12,'2023-01-08 11:37:27','',''),(1435,'1','306','1',1,'Retail Sale Id 1422',6000.96,0.00,0.00,7.98,686.28,'2023-01-08 11:39:57','',''),(1436,'1','306','1',1,'Retail Sale Id 1423',9497.76,0.00,0.00,12.63,1086.18,'2023-01-08 11:41:35','',''),(1437,'1','306','1',1,'Retail Sale Id 1424',3797.60,0.00,0.00,5.05,434.30,'2023-01-08 11:48:51','',''),(1438,'1','306','1',1,'Retail Sale Id 1425',4496.96,0.00,0.00,5.98,514.28,'2023-01-08 11:50:57','',''),(1439,'1','306','1',1,'Retail Sale Id 1426',7520.00,0.00,0.00,10.00,860.00,'2023-01-08 11:56:20','',''),(1440,'1','306','1',1,'Retail Sale Id 1427',4496.96,0.00,0.00,5.98,514.28,'2023-01-08 12:02:37','',''),(1441,'1','306','1',1,'Retail Sale Id 1428',1496.48,0.00,0.00,1.99,171.14,'2023-01-08 12:09:02','',''),(1442,'1','306','1',1,'Return of Retail Sale Id 1422',0.00,6000.96,7.98,0.00,-686.28,'2023-01-08 12:09:39','',''),(1443,'1','306','1',1,'Retail Sale Id 1429',4512.00,0.00,0.00,6.00,516.00,'2023-01-08 12:13:00','',''),(1444,'1','306','1',1,'Retail Sale Id 1430',2203.36,0.00,0.00,2.93,251.98,'2023-01-08 12:25:51','',''),(1445,'1','306','1',1,'Retail Sale Id 1431',9497.76,0.00,0.00,12.63,1086.18,'2023-01-08 12:29:08','',''),(1446,'1','306','1',1,'Retail Sale Id 1432',2496.64,0.00,0.00,3.32,285.52,'2023-01-08 12:52:13','',''),(1447,'1','306','1',1,'Retail Sale Id 1433',9400.00,0.00,0.00,12.50,1075.00,'2023-01-08 12:53:50','',''),(1448,'1','306','1',1,'Retail Sale Id 1434',4512.00,0.00,0.00,6.00,516.00,'2023-01-08 13:18:45','',''),(1449,'1','306','1',1,'Retail Sale Id 1435',3000.48,0.00,0.00,3.99,343.14,'2023-01-08 13:22:51','',''),(1450,'1','306','1',1,'Retail Sale Id 1436',9497.76,0.00,0.00,12.63,1086.18,'2023-01-08 13:30:16','',''),(1451,'1','306','1',1,'Retail Sale Id 1437',4496.96,0.00,0.00,5.98,514.28,'2023-01-08 13:45:41','',''),(1452,'1','306','1',1,'Retail Sale Id 1438',797.12,0.00,0.00,1.06,91.16,'2023-01-08 13:46:53','',''),(1453,'1','306','1',1,'Retail Sale Id 1439',3797.60,0.00,0.00,5.05,434.30,'2023-01-08 14:04:22','',''),(1454,'1','306','1',1,'Retail Sale Id 1440',752.00,0.00,0.00,1.00,86.00,'2023-01-08 14:10:32','',''),(1455,'1','306','1',1,'Retail Sale Id 1440',752.00,0.00,0.00,1.00,86.00,'2023-01-08 14:10:32','',''),(1456,'1','306','1',1,'Retail Sale Id 1441',2203.36,0.00,0.00,2.93,251.98,'2023-01-08 14:25:37','',''),(1457,'1','306','1',1,'Retail Sale Id 1442',9400.00,0.00,0.00,12.50,1075.00,'2023-01-08 14:47:16','',''),(1458,'1','306','1',1,'Retail Sale Id 1443',2301.12,0.00,0.00,3.06,263.16,'2023-01-08 14:52:12','',''),(1459,'1','306','1',1,'Retail Sale Id 1444',1496.48,0.00,0.00,1.99,171.14,'2023-01-08 14:53:03','',''),(1460,'1','306','1',1,'Retail Sale Id 1445',3797.60,0.00,0.00,5.05,434.30,'2023-01-08 15:02:18','',''),(1461,'1','306','1',1,'Retail Sale Id 1446',21600.00,0.00,0.00,30.00,1620.00,'2023-01-08 15:08:35','',''),(1462,'1','306','1',1,'Retail Sale Id 1447',1496.48,0.00,0.00,1.99,171.14,'2023-01-08 15:16:44','',''),(1463,'1','306','1',1,'Retail Sale Id 1448',83520.00,0.00,0.00,116.00,6264.00,'2023-01-08 15:26:16','',''),(1464,'1','306','1',1,'Retail Sale Id 1449',7200.00,0.00,0.00,10.00,540.00,'2023-01-08 15:28:00','',''),(1465,'1','306','1',1,'Retail Sale Id 1450',9400.00,0.00,0.00,12.50,1075.00,'2023-01-08 15:30:04','',''),(1466,'1','306','1',1,'Retail Sale Id 1451',2256.00,0.00,0.00,3.00,258.00,'2023-01-08 15:33:48','',''),(1467,'1','306','1',1,'Retail Sale Id 1452',797.12,0.00,0.00,1.06,91.16,'2023-01-08 15:36:09','',''),(1468,'1','306','1',1,'Retail Sale Id 1453',752.00,0.00,0.00,1.00,86.00,'2023-01-08 15:39:32','',''),(1469,'1','306','1',1,'Retail Sale Id 1454',2301.12,0.00,0.00,3.06,263.16,'2023-01-08 15:58:40','',''),(1470,'1','306','1',1,'Retail Sale Id 1455',3496.80,0.00,0.00,4.65,399.90,'2023-01-08 16:09:27','',''),(1471,'1','306','1',1,'Retail Sale Id 1456',4512.00,0.00,0.00,6.00,516.00,'2023-01-08 16:35:23','',''),(1472,'1','306','1',1,'Retail Sale Id 1457',3797.60,0.00,0.00,5.05,434.30,'2023-01-08 16:39:40','',''),(1473,'1','306','1',1,'Retail Sale Id 1458',5000.80,0.00,0.00,6.65,571.90,'2023-01-08 16:41:06','',''),(1474,'1','306','1',1,'Retail Sale Id 1459',2301.12,0.00,0.00,3.06,263.16,'2023-01-08 16:54:24','',''),(1475,'1','306','1',1,'Retail Sale Id 1461',7497.44,0.00,0.00,9.97,857.42,'2023-01-08 16:55:59','',''),(1476,'1','306','1',1,'Retail Sale Id 1462',4496.96,0.00,0.00,5.98,514.28,'2023-01-08 17:09:11','',''),(1477,'1','306','1',1,'Retail Sale Id 1462',7497.44,0.00,0.00,9.97,857.42,'2023-01-08 17:09:11','',''),(1478,'1','306','1',1,'Retail Sale Id 1463',2248.48,0.00,0.00,2.99,257.14,'2023-01-08 17:13:56','',''),(1479,'1','306','1',1,'Retail Sale Id 1464',2248.48,0.00,0.00,2.99,257.14,'2023-01-08 17:22:53','',''),(1480,'1','306','1',1,'Retail Sale Id 1465',4496.96,0.00,0.00,5.98,514.28,'2023-01-08 17:28:09','',''),(1481,'1','306','1',1,'Retail Sale Id 1466',4496.96,0.00,0.00,5.98,514.28,'2023-01-08 17:33:35','',''),(1482,'1','306','1',1,'Retail Sale Id 1467',4000.64,0.00,0.00,5.32,457.52,'2023-01-08 17:36:27','',''),(1483,'1','306','1',1,'Retail Sale Id 1468',4000.64,0.00,0.00,5.32,457.52,'2023-01-08 17:39:45','',''),(1484,'1','306','1',1,'Retail Sale Id 1469',2248.48,0.00,0.00,2.99,257.14,'2023-01-08 17:44:43','',''),(1485,'1','306','1',1,'Retail Sale Id 1470',797.12,0.00,0.00,1.06,91.16,'2023-01-08 17:45:30','',''),(1486,'1','306','1',1,'Retail Sale Id 1471',2496.64,0.00,0.00,3.32,285.52,'2023-01-08 18:06:46','',''),(1487,'1','306','1',1,'Return of Retail Sale Id 1462',0.00,4496.96,5.98,0.00,-514.28,'2023-01-08 18:42:00','',''),(1488,'1','306','1',1,'Return of Retail Sale Id 1462',0.00,7497.44,9.97,0.00,-857.42,'2023-01-08 18:42:00','',''),(1489,'1','306','1',1,'Retail Sale Id 1472',6271.68,0.00,0.00,8.34,717.24,'2023-01-08 18:44:16','',''),(1490,'1','306','1',1,'Retail Sale Id 1473',9497.76,0.00,0.00,12.63,1086.18,'2023-01-09 08:43:33','',''),(1491,'1','306','1',1,'Retail Sale Id 1474',9497.76,0.00,0.00,12.63,1086.18,'2023-01-09 08:44:48','',''),(1492,'1','306','1',1,'Retail Sale Id 1475',2256.00,0.00,0.00,3.00,258.00,'2023-01-09 08:46:36','',''),(1493,'1','306','1',1,'Retail Sale Id 1476',3000.48,0.00,0.00,3.99,343.14,'2023-01-09 08:47:28','',''),(1494,'1','306','1',1,'Retail Sale Id 1477',3760.00,0.00,0.00,5.00,430.00,'2023-01-09 08:48:47','',''),(1495,'1','306','1',1,'Retail Sale Id 1478',226080.00,0.00,0.00,314.00,16956.00,'2023-01-09 08:52:11','',''),(1496,'1','306','1',1,'Retail Sale Id 1479',4000.64,0.00,0.00,5.32,457.52,'2023-01-09 08:52:57','',''),(1497,'1','306','1',1,'Retail Sale Id 1480',2203.36,0.00,0.00,2.93,251.98,'2023-01-09 08:54:37','',''),(1498,'1','306','1',1,'Retail Sale Id 1481',1496.48,0.00,0.00,1.99,171.14,'2023-01-09 08:56:07','',''),(1499,'1','306','1',1,'Retail Sale Id 1482',1496.48,0.00,0.00,1.99,171.14,'2023-01-09 08:56:54','',''),(1500,'1','306','1',1,'Retail Sale Id 1483',3008.00,0.00,0.00,4.00,344.00,'2023-01-09 08:58:18','',''),(1501,'1','306','1',1,'Retail Sale Id 1483',7520.00,0.00,0.00,10.00,860.00,'2023-01-09 08:58:18','',''),(1502,'1','306','1',1,'Retail Sale Id 1484',797.12,0.00,0.00,1.06,91.16,'2023-01-09 08:59:38','',''),(1503,'1','306','1',1,'Retail Sale Id 1485',2000.32,0.00,0.00,2.66,228.76,'2023-01-09 09:00:44','',''),(1504,'1','306','1',1,'Retail Sale Id 1486',3496.80,0.00,0.00,4.65,399.90,'2023-01-09 09:01:59','',''),(1505,'1','306','1',1,'Retail Sale Id 1487',2301.12,0.00,0.00,3.06,263.16,'2023-01-09 09:02:59','',''),(1506,'1','306','1',1,'Retail Sale Id 1488',4512.00,0.00,0.00,6.00,516.00,'2023-01-09 09:06:12','',''),(1507,'1','306','1',1,'Retail Sale Id 1489',3000.48,0.00,0.00,3.99,343.14,'2023-01-09 09:07:11','',''),(1508,'1','306','1',1,'Retail Sale Id 1490',3000.48,0.00,0.00,3.99,343.14,'2023-01-09 09:08:20','',''),(1509,'1','306','1',1,'Retail Sale Id 1491',3797.60,0.00,0.00,5.05,434.30,'2023-01-09 09:09:20','',''),(1510,'1','306','1',1,'Retail Sale Id 1492',6000.96,0.00,0.00,7.98,686.28,'2023-01-09 09:10:24','',''),(1511,'1','306','1',1,'Retail Sale Id 1493',1496.48,0.00,0.00,1.99,171.14,'2023-01-09 09:11:15','',''),(1512,'1','306','1',1,'Retail Sale Id 1494',2301.12,0.00,0.00,3.06,263.16,'2023-01-09 09:12:27','',''),(1513,'1','306','1',1,'Retail Sale Id 1495',2301.12,0.00,0.00,3.06,263.16,'2023-01-09 09:14:04','',''),(1514,'1','306','1',1,'Retail Sale Id 1496',9400.00,0.00,0.00,12.50,1075.00,'2023-01-09 09:16:03','',''),(1515,'1','306','1',1,'Retail Sale Id 1497',9400.00,0.00,0.00,12.50,1075.00,'2023-01-09 09:21:15','',''),(1516,'1','306','1',1,'Retail Sale Id 1498',1496.48,0.00,0.00,1.99,171.14,'2023-01-09 09:22:31','',''),(1517,'1','306','1',1,'Retail Sale Id 1500',2496.64,0.00,0.00,3.32,285.52,'2023-01-09 09:30:08','',''),(1518,'1','306','1',1,'Retail Sale Id 1501',2496.64,0.00,0.00,3.32,285.52,'2023-01-09 09:30:52','',''),(1519,'1','306','1',1,'Retail Sale Id 1502',2301.12,0.00,0.00,3.06,263.16,'2023-01-09 09:32:17','',''),(1520,'1','306','1',1,'Retail Sale Id 1503',4496.96,0.00,0.00,5.98,514.28,'2023-01-09 09:37:38','',''),(1521,'1','306','1',1,'Retail Sale Id 1504',14400.00,0.00,0.00,20.00,1080.00,'2023-01-09 09:45:47','',''),(1522,'1','306','1',1,'Retail Sale Id 1505',752.00,0.00,0.00,1.00,86.00,'2023-01-09 09:52:55','',''),(1523,'1','306','1',1,'Retail Sale Id 1506',4512.00,0.00,0.00,6.00,516.00,'2023-01-09 10:00:47','',''),(1524,'1','306','1',1,'Retail Sale Id 1507',9400.00,0.00,0.00,12.50,1075.00,'2023-01-09 10:06:04','',''),(1525,'1','306','1',1,'Retail Sale Id 1508',1496.48,0.00,0.00,1.99,171.14,'2023-01-09 10:07:10','',''),(1526,'1','306','1',1,'Retail Sale Id 1509',1496.48,0.00,0.00,1.99,171.14,'2023-01-09 10:29:42','',''),(1527,'1','306','1',1,'Retail Sale Id 1510',4512.00,0.00,0.00,6.00,516.00,'2023-01-09 10:43:59','',''),(1528,'1','306','1',1,'Retail Sale Id 1511',1496.48,0.00,0.00,1.99,171.14,'2023-01-09 10:48:00','',''),(1529,'1','306','1',1,'Retail Sale Id 1512',3797.60,0.00,0.00,5.05,434.30,'2023-01-09 10:51:15','',''),(1530,'1','306','1',1,'Retail Sale Id 1513',5000.80,0.00,0.00,6.65,571.90,'2023-01-09 10:52:28','',''),(1531,'1','306','1',1,'Retail Sale Id 1514',4549.60,0.00,0.00,6.05,520.30,'2023-01-09 10:55:22','',''),(1532,'1','306','1',1,'Retail Sale Id 1515',2301.12,0.00,0.00,3.06,263.16,'2023-01-09 10:56:54','',''),(1533,'1','306','1',1,'Retail Sale Id 1516',3203.52,0.00,0.00,4.26,366.36,'2023-01-09 10:58:58','',''),(1534,'1','306','1',1,'Retail Sale Id 1517',2000.32,0.00,0.00,2.66,228.76,'2023-01-09 10:59:56','',''),(1535,'1','306','1',1,'Retail Sale Id 1518',1496.48,0.00,0.00,1.99,171.14,'2023-01-09 11:00:52','',''),(1536,'1','306','1',1,'Retail Sale Id 1519',797.12,0.00,0.00,1.06,91.16,'2023-01-09 11:02:02','',''),(1537,'1','306','1',1,'Retail Sale Id 1520',3797.60,0.00,0.00,5.05,434.30,'2023-01-09 11:03:52','',''),(1538,'1','306','1',1,'Retail Sale Id 1521',2301.12,0.00,0.00,3.06,263.16,'2023-01-09 11:17:34','',''),(1539,'1','306','1',1,'Retail Sale Id 1522',3008.00,0.00,0.00,4.00,344.00,'2023-01-09 11:19:21','',''),(1540,'1','306','1',1,'Retail Sale Id 1522',4512.00,0.00,0.00,6.00,516.00,'2023-01-09 11:19:21','',''),(1541,'1','306','1',1,'Retail Sale Id 1523',1496.48,0.00,0.00,1.99,171.14,'2023-01-09 11:27:33','',''),(1542,'1','306','1',1,'Retail Sale Id 1524',1496.48,0.00,0.00,1.99,171.14,'2023-01-09 11:33:15','',''),(1543,'1','306','1',1,'Retail Sale Id 1525',7497.44,0.00,0.00,9.97,857.42,'2023-01-09 11:34:23','',''),(1544,'1','306','1',1,'Retail Sale Id 1526',2000.32,0.00,0.00,2.66,228.76,'2023-01-09 11:35:27','',''),(1545,'1','306','1',1,'Retail Sale Id 1527',2256.00,0.00,0.00,3.00,258.00,'2023-01-09 11:42:39','',''),(1546,'1','306','1',1,'Retail Sale Id 1528',14400.00,0.00,0.00,20.00,1080.00,'2023-01-09 11:57:29','',''),(1547,'1','306','1',1,'Retail Sale Id 1529',797.12,0.00,0.00,1.06,91.16,'2023-01-09 12:00:32','',''),(1548,'1','306','1',1,'Retail Sale Id 1530',752.00,0.00,0.00,1.00,86.00,'2023-01-09 12:01:52','',''),(1549,'1','306','1',1,'Retail Sale Id 1531',9400.00,0.00,0.00,12.50,1075.00,'2023-01-09 12:04:56','',''),(1550,'1','306','1',1,'Retail Sale Id 1532',1496.48,0.00,0.00,1.99,171.14,'2023-01-09 12:06:02','',''),(1551,'1','306','1',1,'Retail Sale Id 1533',1496.48,0.00,0.00,1.99,171.14,'2023-01-09 12:07:05','',''),(1552,'1','306','1',1,'Retail Sale Id 1534',3008.00,0.00,0.00,4.00,344.00,'2023-01-09 12:08:23','',''),(1553,'1','306','1',1,'Retail Sale Id 1535',4496.96,0.00,0.00,5.98,514.28,'2023-01-09 12:15:26','',''),(1554,'1','306','1',1,'Retail Sale Id 1536',4512.00,0.00,0.00,6.00,516.00,'2023-01-09 12:16:47','',''),(1555,'1','306','1',1,'Retail Sale Id 1537',3000.48,0.00,0.00,3.99,343.14,'2023-01-09 12:18:32','',''),(1556,'1','306','1',1,'Retail Sale Id 1539',3000.48,0.00,0.00,3.99,343.14,'2023-01-09 12:19:45','',''),(1557,'1','306','1',1,'Retail Sale Id 1540',4496.96,0.00,0.00,5.98,514.28,'2023-01-09 12:22:29','',''),(1558,'1','306','1',1,'Retail Sale Id 1541',2301.12,0.00,0.00,3.06,263.16,'2023-01-09 12:23:29','',''),(1559,'1','306','1',1,'Retail Sale Id 1542',2301.12,0.00,0.00,3.06,263.16,'2023-01-09 12:36:35','',''),(1560,'1','306','1',1,'Retail Sale Id 1543',9400.00,0.00,0.00,12.50,1075.00,'2023-01-09 12:38:06','',''),(1561,'1','306','1',1,'Retail Sale Id 1544',96480.00,0.00,0.00,134.00,7236.00,'2023-01-09 12:58:07','',''),(1562,'1','306','1',1,'Retail Sale Id 1546',6768.00,0.00,0.00,9.00,774.00,'2023-01-09 13:00:22','',''),(1563,'1','306','1',1,'Retail Sale Id 1547',3000.48,0.00,0.00,3.99,343.14,'2023-01-09 13:33:59','',''),(1564,'1','306','1',1,'Retail Sale Id 1548',752.00,0.00,0.00,1.00,86.00,'2023-01-09 13:36:10','',''),(1565,'1','306','1',1,'Retail Sale Id 1548',752.00,0.00,0.00,1.00,86.00,'2023-01-09 13:36:10','',''),(1566,'1','306','1',1,'Retail Sale Id 1549',3000.48,0.00,0.00,3.99,343.14,'2023-01-09 13:37:03','',''),(1567,'1','306','1',1,'Retail Sale Id 1550',3000.48,0.00,0.00,3.99,343.14,'2023-01-09 13:38:21','',''),(1568,'1','306','1',1,'Retail Sale Id 1551',3496.80,0.00,0.00,4.65,399.90,'2023-01-09 13:39:29','',''),(1569,'1','306','1',1,'Retail Sale Id 1552',4549.60,0.00,0.00,6.05,520.30,'2023-01-09 13:43:51','',''),(1570,'1','306','1',1,'Retail Sale Id 1553',5301.60,0.00,0.00,7.05,606.30,'2023-01-09 13:46:17','',''),(1571,'1','306','1',1,'Retail Sale Id 1554',14400.00,0.00,0.00,20.00,1080.00,'2023-01-09 14:01:37','',''),(1572,'1','306','1',1,'Retail Sale Id 1555',2496.64,0.00,0.00,3.32,285.52,'2023-01-09 14:06:10','',''),(1573,'1','306','1',1,'Retail Sale Id 1556',3301.28,0.00,0.00,4.39,377.54,'2023-01-09 14:07:58','',''),(1574,'1','306','1',1,'Retail Sale Id 1557',3797.60,0.00,0.00,5.05,434.30,'2023-01-09 14:09:02','',''),(1575,'1','306','1',1,'Retail Sale Id 1558',4496.96,0.00,0.00,5.98,514.28,'2023-01-09 14:09:52','',''),(1576,'1','306','1',1,'Retail Sale Id 1559',3699.84,0.00,0.00,4.92,423.12,'2023-01-09 14:13:42','',''),(1577,'1','306','1',1,'Retail Sale Id 1561',2398.88,0.00,0.00,3.19,274.34,'2023-01-09 14:17:15','',''),(1578,'1','306','1',1,'Retail Sale Id 1562',9497.76,0.00,0.00,12.63,1086.18,'2023-01-09 14:22:48','',''),(1579,'1','306','1',1,'Retail Sale Id 1563',3008.00,0.00,0.00,4.00,344.00,'2023-01-09 14:25:06','',''),(1580,'1','306','1',1,'Retail Sale Id 1564',2000.32,0.00,0.00,2.66,228.76,'2023-01-09 14:34:36','',''),(1581,'1','306','1',1,'Retail Sale Id 1565',752.00,0.00,0.00,1.00,86.00,'2023-01-09 14:35:40','',''),(1582,'1','306','1',1,'Retail Sale Id 1566',13197.60,0.00,0.00,17.55,1509.30,'2023-01-09 14:38:00','',''),(1583,'1','306','1',1,'Retail Sale Id 1567',9497.76,0.00,0.00,12.63,1086.18,'2023-01-09 14:41:21','',''),(1584,'1','306','1',1,'Return of Retail Sale Id 1551',0.00,3496.80,4.65,0.00,-399.90,'2023-01-09 14:42:01','',''),(1585,'1','306','1',1,'Retail Sale Id 1568',2301.12,0.00,0.00,3.06,263.16,'2023-01-09 14:42:47','',''),(1586,'1','306','1',1,'Retail Sale Id 1569',2301.12,0.00,0.00,3.06,263.16,'2023-01-09 14:50:48','',''),(1587,'1','306','1',1,'Retail Sale Id 1570',1496.48,0.00,0.00,1.99,171.14,'2023-01-09 14:59:06','',''),(1588,'1','306','1',1,'Retail Sale Id 1571',2000.32,0.00,0.00,2.66,228.76,'2023-01-09 15:00:59','',''),(1589,'1','306','1',1,'Retail Sale Id 1572',2000.32,0.00,0.00,2.66,228.76,'2023-01-09 15:16:56','',''),(1590,'1','306','1',1,'Retail Sale Id 1573',2000.32,0.00,0.00,2.66,228.76,'2023-01-09 15:17:51','',''),(1591,'1','306','1',1,'Retail Sale Id 1574',3496.80,0.00,0.00,4.65,399.90,'2023-01-09 15:20:54','',''),(1592,'1','306','1',1,'Retail Sale Id 1575',2000.32,0.00,0.00,2.66,228.76,'2023-01-09 15:23:26','',''),(1593,'1','306','1',1,'Retail Sale Id 1576',2556.80,0.00,0.00,3.40,292.40,'2023-01-09 15:27:30','',''),(1594,'1','306','1',1,'Return of Retail Sale Id 1576',0.00,2556.80,3.40,0.00,-292.40,'2023-01-09 15:29:39','',''),(1595,'1','306','1',1,'Retail Sale Id 1577',2301.12,0.00,0.00,3.06,263.16,'2023-01-09 15:30:10','',''),(1596,'1','306','1',1,'Retail Sale Id 1578',2263.52,0.00,0.00,3.01,258.86,'2023-01-09 15:32:03','',''),(1597,'1','306','1',1,'Retail Sale Id 1580',1496.48,0.00,0.00,1.99,171.14,'2023-01-09 15:33:56','',''),(1598,'1','306','1',1,'Retail Sale Id 1581',4000.64,0.00,0.00,5.32,457.52,'2023-01-09 15:35:25','',''),(1599,'1','306','1',1,'Retail Sale Id 1582',9497.76,0.00,0.00,12.63,1086.18,'2023-01-09 15:37:16','',''),(1600,'1','306','1',1,'Retail Sale Id 1583',5000.80,0.00,0.00,6.65,571.90,'2023-01-09 15:38:17','',''),(1601,'1','306','1',1,'Retail Sale Id 1584',2000.32,0.00,0.00,2.66,228.76,'2023-01-09 15:41:05','',''),(1602,'1','306','1',1,'Retail Sale Id 1585',9400.00,0.00,0.00,12.50,1075.00,'2023-01-09 15:47:58','',''),(1603,'1','306','1',1,'Retail Sale Id 1586',18499.20,0.00,0.00,24.60,2115.60,'2023-01-09 15:51:21','',''),(1604,'1','306','1',1,'Retail Sale Id 1587',797.12,0.00,0.00,1.06,91.16,'2023-01-09 15:58:56','',''),(1605,'1','306','1',1,'Retail Sale Id 1588',8497.60,0.00,0.00,11.30,971.80,'2023-01-09 16:01:37','',''),(1606,'1','306','1',1,'Retail Sale Id 1589',2301.12,0.00,0.00,3.06,263.16,'2023-01-09 16:08:11','',''),(1607,'1','306','1',1,'Retail Sale Id 1590',1496.48,0.00,0.00,1.99,171.14,'2023-01-09 16:09:07','',''),(1608,'1','306','1',1,'Retail Sale Id 1591',2256.00,0.00,0.00,3.00,258.00,'2023-01-09 16:10:44','',''),(1609,'1','306','1',1,'Retail Sale Id 1592',8497.60,0.00,0.00,11.30,971.80,'2023-01-09 16:14:19','',''),(1610,'1','306','1',1,'Retail Sale Id 1593',2203.36,0.00,0.00,2.93,251.98,'2023-01-09 16:16:27','',''),(1611,'1','306','1',1,'Retail Sale Id 1595',4549.60,0.00,0.00,6.05,520.30,'2023-01-09 16:18:41','',''),(1612,'1','306','1',1,'Retail Sale Id 1596',2301.12,0.00,0.00,3.06,263.16,'2023-01-09 16:23:05','',''),(1613,'1','306','1',1,'Retail Sale Id 1597',2301.12,0.00,0.00,3.06,263.16,'2023-01-09 16:45:21','',''),(1614,'1','306','1',1,'Retail Sale Id 1598',2301.12,0.00,0.00,3.06,263.16,'2023-01-09 16:46:43','',''),(1615,'1','306','1',1,'Retail Sale Id 1599',2248.48,0.00,0.00,2.99,257.14,'2023-01-09 16:51:03','',''),(1616,'1','306','1',1,'Retail Sale Id 1600',2301.12,0.00,0.00,3.06,263.16,'2023-01-09 16:53:38','',''),(1617,'1','306','1',1,'Retail Sale Id 1601',2301.12,0.00,0.00,3.06,263.16,'2023-01-09 16:54:59','',''),(1618,'1','306','1',1,'Retail Sale Id 1602',9400.00,0.00,0.00,12.50,1075.00,'2023-01-09 16:56:38','',''),(1619,'1','306','1',1,'Retail Sale Id 1603',1797.28,0.00,0.00,2.39,205.54,'2023-01-09 17:06:27','',''),(1620,'1','306','1',1,'Retail Sale Id 1604',2000.32,0.00,0.00,2.66,228.76,'2023-01-09 17:12:46','',''),(1621,'1','306','1',1,'Retail Sale Id 1605',4496.96,0.00,0.00,5.98,514.28,'2023-01-09 17:33:01','',''),(1622,'1','306','1',1,'Retail Sale Id 1606',4512.00,0.00,0.00,6.00,516.00,'2023-01-09 17:35:36','',''),(1623,'1','306','1',1,'Retail Sale Id 1607',1496.48,0.00,0.00,1.99,171.14,'2023-01-09 17:36:31','',''),(1624,'1','306','1',1,'Retail Sale Id 1608',4512.00,0.00,0.00,6.00,516.00,'2023-01-09 17:40:00','',''),(1625,'1','306','1',1,'Retail Sale Id 1609',2271.04,0.00,0.00,3.02,259.72,'2023-01-09 17:41:57','',''),(1626,'1','306','1',1,'Retail Sale Id 1610',2000.32,0.00,0.00,2.66,228.76,'2023-01-09 17:42:44','',''),(1627,'1','306','1',1,'Return of Retail Sale Id 1609',0.00,2271.04,3.02,0.00,-259.72,'2023-01-09 17:43:24','',''),(1628,'1','306','1',1,'Retail Sale Id 1611',3008.00,0.00,0.00,4.00,344.00,'2023-01-09 17:46:32','',''),(1629,'1','306','1',1,'Retail Sale Id 1612',1000.16,0.00,0.00,1.33,114.38,'2023-01-09 17:47:19','',''),(1630,'1','306','1',1,'Retail Sale Id 1614',2203.36,0.00,0.00,2.93,251.98,'2023-01-09 17:49:32','',''),(1631,'1','306','1',1,'Retail Sale Id 1615',2301.12,0.00,0.00,3.06,263.16,'2023-01-09 17:50:39','',''),(1632,'1','306','1',1,'Retail Sale Id 1616',1496.48,0.00,0.00,1.99,171.14,'2023-01-09 17:51:26','',''),(1633,'1','306','1',1,'Retail Sale Id 1618',1203.20,0.00,0.00,1.60,137.60,'2023-01-09 17:54:59','',''),(1634,'1','306','1',1,'Retail Sale Id 1619',1496.48,0.00,0.00,1.99,171.14,'2023-01-09 18:01:54','',''),(1635,'1','306','1',1,'Retail Sale Id 1620',4496.96,0.00,0.00,5.98,514.28,'2023-01-09 18:09:36','',''),(1636,'1','306','1',1,'Retail Sale Id 1621',1496.48,0.00,0.00,1.99,171.14,'2023-01-09 18:12:41','',''),(1637,'1','306','1',1,'Retail Sale Id 1622',3797.60,0.00,0.00,5.05,434.30,'2023-01-09 18:14:03','',''),(1638,'1','306','1',1,'Retail Sale Id 1623',1496.48,0.00,0.00,1.99,171.14,'2023-01-09 18:16:24','',''),(1639,'1','306','1',1,'Retail Sale Id 1624',2496.64,0.00,0.00,3.32,285.52,'2023-01-09 18:17:27','',''),(1640,'1','306','1',1,'Retail Sale Id 1625',2248.48,0.00,0.00,2.99,257.14,'2023-01-09 18:26:25','',''),(1641,'1','306','1',1,'Retail Sale Id 1626',4496.96,0.00,0.00,5.98,514.28,'2023-01-09 18:28:46','',''),(1642,'1','306','1',1,'Retail Sale Id 1627',3008.00,0.00,0.00,4.00,344.00,'2023-01-09 18:34:08','',''),(1643,'1','306','1',1,'Return of Retail Sale Id 1622',0.00,3797.60,5.05,0.00,-434.30,'2023-01-09 18:49:06','',''),(1644,'1','306','1',1,'Return of Retail Sale Id 1626',0.00,4496.96,5.98,0.00,-514.28,'2023-01-09 18:49:43','',''),(1645,'1','306','1',1,'Return of Retail Sale Id 1608',0.00,4512.00,6.00,0.00,-516.00,'2023-01-09 18:50:35','',''),(1646,'1','306','1',1,'Return of Retail Sale Id 1620',0.00,4496.96,5.98,0.00,-514.28,'2023-01-09 18:51:19','',''),(1647,'1','306','1',1,'Retail Sale Id 1628',2188.32,0.00,0.00,2.91,250.26,'2023-01-09 18:56:59','',''),(1648,'1','306','1',1,'Retail Sale Id 1629',2271.04,0.00,0.00,3.02,259.72,'2023-01-10 07:20:42','',''),(1649,'1','306','1',1,'Retail Sale Id 1630',1496.48,0.00,0.00,1.99,171.14,'2023-01-10 07:31:28','',''),(1650,'1','306','1',1,'Retail Sale Id 1631',9400.00,0.00,0.00,12.50,1075.00,'2023-01-10 07:41:04','',''),(1651,'1','306','1',1,'Retail Sale Id 1632',1496.48,0.00,0.00,1.99,171.14,'2023-01-10 07:44:01','',''),(1652,'1','306','1',1,'Retail Sale Id 1633',68400.00,0.00,0.00,95.00,5130.00,'2023-01-10 07:47:44','',''),(1653,'1','306','1',1,'Retail Sale Id 1634',2000.32,0.00,0.00,2.66,228.76,'2023-01-10 07:50:38','',''),(1654,'1','306','1',1,'Retail Sale Id 1635',68400.00,0.00,0.00,95.00,5130.00,'2023-01-10 07:52:13','',''),(1655,'1','306','1',1,'Retail Sale Id 1636',2301.12,0.00,0.00,3.06,263.16,'2023-01-10 07:54:21','',''),(1656,'1','306','1',1,'Retail Sale Id 1637',752.00,0.00,0.00,1.00,86.00,'2023-01-10 08:01:55','',''),(1657,'1','306','1',1,'Retail Sale Id 1638',3000.48,0.00,0.00,3.99,343.14,'2023-01-10 08:04:55','',''),(1658,'1','306','1',1,'Retail Sale Id 1639',3797.60,0.00,0.00,5.05,434.30,'2023-01-10 08:13:33','',''),(1659,'1','306','1',1,'Retail Sale Id 1640',4000.64,0.00,0.00,5.32,457.52,'2023-01-10 08:14:56','',''),(1660,'1','306','1',1,'Retail Sale Id 1641',4549.60,0.00,0.00,6.05,520.30,'2023-01-10 08:16:15','',''),(1661,'1','306','1',1,'Retail Sale Id 1642',9400.00,0.00,0.00,12.50,1075.00,'2023-01-10 08:18:02','',''),(1662,'1','306','1',1,'Retail Sale Id 1643',3797.60,0.00,0.00,5.05,434.30,'2023-01-10 08:27:19','',''),(1663,'1','306','1',1,'Retail Sale Id 1644',4549.60,0.00,0.00,6.05,520.30,'2023-01-10 08:38:19','',''),(1664,'1','306','1',1,'Retail Sale Id 1644',9400.00,0.00,0.00,12.50,1075.00,'2023-01-10 08:38:19','',''),(1665,'1','306','1',1,'Retail Sale Id 1645',11160.00,0.00,0.00,15.50,837.00,'2023-01-10 08:44:07','',''),(1666,'1','306','1',1,'Retail Sale Id 1646',2000.32,0.00,0.00,2.66,228.76,'2023-01-10 08:51:25','',''),(1667,'1','306','1',1,'Retail Sale Id 1647',4512.00,0.00,0.00,6.00,516.00,'2023-01-10 08:54:29','',''),(1668,'1','306','1',1,'Retail Sale Id 1648',3000.48,0.00,0.00,3.99,343.14,'2023-01-10 08:55:31','',''),(1669,'1','306','1',1,'Retail Sale Id 1649',3797.60,0.00,0.00,5.05,434.30,'2023-01-10 08:56:55','',''),(1670,'1','306','1',1,'Retail Sale Id 1650',43200.00,0.00,0.00,60.00,3240.00,'2023-01-10 08:59:50','',''),(1671,'1','306','1',1,'Retail Sale Id 1652',15840.00,0.00,0.00,22.00,1188.00,'2023-01-10 09:03:55','',''),(1672,'1','306','1',1,'Retail Sale Id 1653',4512.00,0.00,0.00,6.00,516.00,'2023-01-10 09:06:22','',''),(1673,'1','306','1',1,'Return of Retail Sale Id 1652',0.00,15840.00,22.00,0.00,-1188.00,'2023-01-10 09:21:13','',''),(1674,'1','306','1',1,'Return of Retail Sale Id 1635',0.00,68400.00,95.00,0.00,-5130.00,'2023-01-10 09:28:46','',''),(1675,'1','306','1',1,'Return of Retail Sale Id 1642',0.00,9400.00,12.50,0.00,-1075.00,'2023-01-10 09:50:42','',''),(1676,'1','306','1',1,'Retail Sale Id 1654',8911.20,0.00,0.00,11.85,1019.10,'2023-01-10 09:52:48','',''),(1677,'1','306','1',1,'Distributed to ALL DEALER for sales id:1',395883.72,0.00,0.00,594.42,0.00,'2023-01-10 10:33:26','',''),(1678,'1','306',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,3196800.00,4800.00,0.00,0.00,'2023-01-10 11:20:28','',''),(1679,'1','306',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,4800.00,0.00,'2023-01-10 11:21:25','',''),(1680,'1','306','1',1,'Received from bridging 5',0.00,0.00,4800.00,0.00,0.00,'2023-01-10 11:21:25','',''),(1681,'1','306','1',1,'Retail Sale Id 1657',15840.00,0.00,0.00,22.00,1188.00,'2023-01-10 11:21:41','',''),(1682,'1','306','1',1,'Retail Sale Id 1658',2000.32,0.00,0.00,2.66,228.76,'2023-01-10 11:23:51','',''),(1683,'1','306','1',1,'Retail Sale Id 1659',1496.48,0.00,0.00,1.99,171.14,'2023-01-10 11:24:44','',''),(1684,'1','306','1',1,'Retail Sale Id 1660',2000.32,0.00,0.00,2.66,228.76,'2023-01-10 11:25:29','',''),(1685,'1','306','1',1,'Retail Sale Id 1661',2301.12,0.00,0.00,3.06,263.16,'2023-01-10 11:26:21','',''),(1686,'1','306','1',1,'Retail Sale Id 1662',3496.80,0.00,0.00,4.65,399.90,'2023-01-10 11:27:20','',''),(1687,'1','306','1',1,'Retail Sale Id 1663',4549.60,0.00,0.00,6.05,520.30,'2023-01-10 11:28:10','',''),(1688,'1','306','1',1,'Retail Sale Id 1664',3000.48,0.00,0.00,3.99,343.14,'2023-01-10 11:28:55','',''),(1689,'1','306','1',1,'Retail Sale Id 1665',3000.48,0.00,0.00,3.99,343.14,'2023-01-10 11:29:38','',''),(1690,'1','306','1',1,'Retail Sale Id 1666',2203.36,0.00,0.00,2.93,251.98,'2023-01-10 11:30:54','',''),(1691,'1','306','1',1,'Retail Sale Id 1667',1496.48,0.00,0.00,1.99,171.14,'2023-01-10 11:31:39','',''),(1692,'1','306','1',1,'Retail Sale Id 1668',1496.48,0.00,0.00,1.99,171.14,'2023-01-10 11:32:20','',''),(1693,'1','306','1',1,'Retail Sale Id 1669',6480.00,0.00,0.00,9.00,486.00,'2023-01-10 11:33:14','',''),(1694,'1','306','1',1,'Retail Sale Id 1670',4496.96,0.00,0.00,5.98,514.28,'2023-01-10 11:34:23','',''),(1695,'1','306','1',1,'Retail Sale Id 1672',4512.00,0.00,0.00,6.00,516.00,'2023-01-10 11:35:46','',''),(1696,'1','306','1',1,'Retail Sale Id 1673',2301.12,0.00,0.00,3.06,263.16,'2023-01-10 11:37:13','',''),(1697,'1','306','1',1,'Retail Sale Id 1674',1496.48,0.00,0.00,1.99,171.14,'2023-01-10 11:39:01','',''),(1698,'1','306','1',1,'Retail Sale Id 1675',1398.72,0.00,0.00,1.86,159.96,'2023-01-10 11:40:06','',''),(1699,'1','306','1',1,'Retail Sale Id 1676',797.12,0.00,0.00,1.06,91.16,'2023-01-10 11:40:52','',''),(1700,'1','306','1',1,'Retail Sale Id 1677',3797.60,0.00,0.00,5.05,434.30,'2023-01-10 11:41:49','',''),(1701,'1','306','1',1,'Retail Sale Id 1678',4512.00,0.00,0.00,6.00,516.00,'2023-01-10 11:42:50','',''),(1702,'1','306','1',1,'Retail Sale Id 1679',4496.96,0.00,0.00,5.98,514.28,'2023-01-10 11:46:00','',''),(1703,'1','306','1',1,'Retail Sale Id 1680',6016.00,0.00,0.00,8.00,688.00,'2023-01-10 11:48:38','',''),(1704,'1','306','1',1,'Return of Retail Sale Id 1669',0.00,6480.00,9.00,0.00,-486.00,'2023-01-10 11:50:30','',''),(1705,'1','306','1',1,'Retail Sale Id 1681',1496.48,0.00,0.00,1.99,171.14,'2023-01-10 11:53:11','',''),(1706,'1','306','1',1,'Retail Sale Id 1682',752.00,0.00,0.00,1.00,86.00,'2023-01-10 11:55:16','',''),(1707,'1','306','1',1,'Retail Sale Id 1683',18000.00,0.00,0.00,25.00,1350.00,'2023-01-10 11:59:30','',''),(1708,'1','306','1',1,'Retail Sale Id 1684',1000.16,0.00,0.00,1.33,114.38,'2023-01-10 12:09:13','',''),(1709,'1','306','1',1,'Retail Sale Id 1685',2256.00,0.00,0.00,3.00,258.00,'2023-01-10 12:12:49','',''),(1710,'1','306','1',1,'Retail Sale Id 1686',2301.12,0.00,0.00,3.06,263.16,'2023-01-10 12:14:29','',''),(1711,'1','306','1',1,'Retail Sale Id 1687',4549.60,0.00,0.00,6.05,520.30,'2023-01-10 12:21:22','',''),(1712,'1','306','1',1,'Retail Sale Id 1688',1902.56,0.00,0.00,2.53,217.58,'2023-01-10 12:25:48','',''),(1713,'1','306','1',1,'Retail Sale Id 1689',79200.00,0.00,0.00,110.00,5940.00,'2023-01-10 12:37:18','',''),(1714,'1','306','1',1,'Retail Sale Id 1690',3023.04,0.00,0.00,4.02,345.72,'2023-01-10 12:38:39','',''),(1715,'1','306','1',1,'Retail Sale Id 1691',2496.64,0.00,0.00,3.32,285.52,'2023-01-10 12:39:37','',''),(1716,'1','306','1',1,'Retail Sale Id 1692',3797.60,0.00,0.00,5.05,434.30,'2023-01-10 12:47:32','',''),(1717,'1','306','1',1,'Retail Sale Id 1693',3496.80,0.00,0.00,4.65,399.90,'2023-01-10 12:50:16','',''),(1718,'1','306','1',1,'Retail Sale Id 1694',3008.00,0.00,0.00,4.00,344.00,'2023-01-10 12:53:25','',''),(1719,'1','306','1',1,'Retail Sale Id 1695',1496.48,0.00,0.00,1.99,171.14,'2023-01-10 12:59:54','',''),(1720,'1','306','1',1,'Retail Sale Id 1696',1496.48,0.00,0.00,1.99,171.14,'2023-01-10 13:19:45','',''),(1721,'1','306','1',1,'Retail Sale Id 1697',38540.00,0.00,0.00,51.25,4407.50,'2023-01-10 13:39:17','',''),(1722,'1','306','1',1,'Retail Sale Id 1698',28800.00,0.00,0.00,40.00,2160.00,'2023-01-10 13:40:42','',''),(1723,'1','306','1',1,'Retail Sale Id 1699',1496.48,0.00,0.00,1.99,171.14,'2023-01-10 13:44:10','',''),(1724,'1','306','1',1,'Retail Sale Id 1700',2256.00,0.00,0.00,3.00,258.00,'2023-01-10 13:46:32','',''),(1725,'1','306','1',1,'Retail Sale Id 1700',9400.00,0.00,0.00,12.50,1075.00,'2023-01-10 13:46:32','',''),(1726,'1','306','1',1,'Retail Sale Id 1701',2256.00,0.00,0.00,3.00,258.00,'2023-01-10 13:47:56','',''),(1727,'1','306','1',1,'Retail Sale Id 1702',27360.00,0.00,0.00,38.00,2052.00,'2023-01-10 13:50:48','',''),(1728,'1','306','1',1,'Retail Sale Id 1703',2301.12,0.00,0.00,3.06,263.16,'2023-01-10 13:54:33','',''),(1729,'1','306','1',1,'Retail Sale Id 1704',9400.00,0.00,0.00,12.50,1075.00,'2023-01-10 14:04:38','',''),(1730,'1','306','1',1,'Retail Sale Id 1704',9400.00,0.00,0.00,12.50,1075.00,'2023-01-10 14:04:38','',''),(1731,'1','306','1',1,'Retail Sale Id 1705',3000.48,0.00,0.00,3.99,343.14,'2023-01-10 14:05:44','',''),(1732,'1','306','1',1,'Retail Sale Id 1706',2496.64,0.00,0.00,3.32,285.52,'2023-01-10 14:07:32','',''),(1733,'1','306','1',1,'Retail Sale Id 1707',9400.00,0.00,0.00,12.50,1075.00,'2023-01-10 14:08:35','',''),(1734,'1','306','1',1,'Retail Sale Id 1708',797.12,0.00,0.00,1.06,91.16,'2023-01-10 14:09:38','',''),(1735,'1','306','1',1,'Retail Sale Id 1709',4512.00,0.00,0.00,6.00,516.00,'2023-01-10 14:20:18','',''),(1736,'1','306','1',1,'Retail Sale Id 1710',2301.12,0.00,0.00,3.06,263.16,'2023-01-10 14:21:37','',''),(1737,'1','306','1',1,'Retail Sale Id 1711',4549.60,0.00,0.00,6.05,520.30,'2023-01-10 14:26:55','',''),(1738,'1','306','1',1,'Retail Sale Id 1712',3797.60,0.00,0.00,5.05,434.30,'2023-01-10 14:34:09','',''),(1739,'1','306','1',1,'Retail Sale Id 1713',4496.96,0.00,0.00,5.98,514.28,'2023-01-10 14:46:41','',''),(1740,'1','306','1',1,'Retail Sale Id 1714',21600.00,0.00,0.00,30.00,1620.00,'2023-01-10 14:48:41','',''),(1741,'1','306','1',1,'Retail Sale Id 1715',1496.48,0.00,0.00,1.99,171.14,'2023-01-10 14:49:56','',''),(1742,'1','306','1',1,'Retail Sale Id 1716',3797.60,0.00,0.00,5.05,434.30,'2023-01-10 14:55:41','',''),(1743,'1','306','1',1,'Retail Sale Id 1717',2000.32,0.00,0.00,2.66,228.76,'2023-01-10 14:56:55','',''),(1744,'1','306','1',1,'Retail Sale Id 1718',752.00,0.00,0.00,1.00,86.00,'2023-01-10 14:58:53','',''),(1745,'1','306','1',1,'Retail Sale Id 1718',752.00,0.00,0.00,1.00,86.00,'2023-01-10 14:58:53','',''),(1746,'1','306','1',1,'Retail Sale Id 1719',2301.12,0.00,0.00,3.06,263.16,'2023-01-10 15:10:22','',''),(1747,'1','306','1',1,'Retail Sale Id 1720',4903.04,0.00,0.00,6.52,560.72,'2023-01-10 15:18:31','',''),(1748,'1','306','1',1,'Retail Sale Id 1721',4496.96,0.00,0.00,5.98,514.28,'2023-01-10 15:20:26','',''),(1749,'1','306','1',1,'Retail Sale Id 1722',3760.00,0.00,0.00,5.00,430.00,'2023-01-10 15:31:18','',''),(1750,'1','306','1',1,'Retail Sale Id 1723',3098.24,0.00,0.00,4.12,354.32,'2023-01-10 15:32:46','',''),(1751,'1','306','1',1,'Retail Sale Id 1724',2301.12,0.00,0.00,3.06,263.16,'2023-01-10 15:34:10','',''),(1752,'1','306','1',1,'Retail Sale Id 1725',5000.80,0.00,0.00,6.65,571.90,'2023-01-10 15:36:06','',''),(1753,'1','306','1',1,'Retail Sale Id 1726',1496.48,0.00,0.00,1.99,171.14,'2023-01-10 15:44:15','',''),(1754,'1','306','1',1,'Retail Sale Id 1727',2301.12,0.00,0.00,3.06,263.16,'2023-01-10 15:46:30','',''),(1755,'1','306','1',1,'Retail Sale Id 1728',1496.48,0.00,0.00,1.99,171.14,'2023-01-10 15:51:07','',''),(1756,'1','306','1',1,'Retail Sale Id 1729',3000.48,0.00,0.00,3.99,343.14,'2023-01-10 15:52:25','',''),(1757,'1','306','1',1,'Retail Sale Id 1730',3797.60,0.00,0.00,5.05,434.30,'2023-01-10 15:53:33','',''),(1758,'1','306','1',1,'Retail Sale Id 1731',4496.96,0.00,0.00,5.98,514.28,'2023-01-10 15:55:15','',''),(1759,'1','306','1',1,'Retail Sale Id 1732',2301.12,0.00,0.00,3.06,263.16,'2023-01-10 15:57:18','',''),(1760,'1','306','1',1,'Retail Sale Id 1733',1496.48,0.00,0.00,1.99,171.14,'2023-01-10 16:00:35','',''),(1761,'1','306','1',1,'Retail Sale Id 1734',4496.96,0.00,0.00,5.98,514.28,'2023-01-10 16:02:19','',''),(1762,'1','306','1',1,'Retail Sale Id 1736',3008.00,0.00,0.00,4.00,344.00,'2023-01-10 16:05:34','',''),(1763,'1','306','1',1,'Retail Sale Id 1737',3797.60,0.00,0.00,5.05,434.30,'2023-01-10 16:07:27','',''),(1764,'1','306','1',1,'Retail Sale Id 1738',1496.48,0.00,0.00,1.99,171.14,'2023-01-10 16:18:47','',''),(1765,'1','306','1',1,'Retail Sale Id 1739',9400.00,0.00,0.00,12.50,1075.00,'2023-01-10 16:23:18','',''),(1766,'1','306','1',1,'Retail Sale Id 1740',3797.60,0.00,0.00,5.05,434.30,'2023-01-10 16:24:22','',''),(1767,'1','306','1',1,'Retail Sale Id 1741',2203.36,0.00,0.00,2.93,251.98,'2023-01-10 16:25:56','',''),(1768,'1','306','1',1,'Retail Sale Id 1742',4496.96,0.00,0.00,5.98,514.28,'2023-01-10 16:26:57','',''),(1769,'1','306','1',1,'Retail Sale Id 1743',4496.96,0.00,0.00,5.98,514.28,'2023-01-10 16:28:27','',''),(1770,'1','306','1',1,'Retail Sale Id 1744',3008.00,0.00,0.00,4.00,344.00,'2023-01-10 16:32:46','',''),(1771,'1','306','1',1,'Retail Sale Id 1745',1496.48,0.00,0.00,1.99,171.14,'2023-01-10 16:33:56','',''),(1772,'1','306','1',1,'Retail Sale Id 1746',2301.12,0.00,0.00,3.06,263.16,'2023-01-10 16:37:29','',''),(1773,'1','306','1',1,'Retail Sale Id 1747',1496.48,0.00,0.00,1.99,171.14,'2023-01-10 16:39:03','',''),(1774,'1','306','1',1,'Retail Sale Id 1748',3000.48,0.00,0.00,3.99,343.14,'2023-01-10 16:43:14','',''),(1775,'1','306','1',1,'Retail Sale Id 1749',2301.12,0.00,0.00,3.06,263.16,'2023-01-10 16:47:07','',''),(1776,'1','306','1',1,'Retail Sale Id 1750',9400.00,0.00,0.00,12.50,1075.00,'2023-01-10 16:53:34','',''),(1777,'1','306','1',1,'Retail Sale Id 1751',9497.76,0.00,0.00,12.63,1086.18,'2023-01-10 16:55:16','',''),(1778,'1','306','1',1,'Retail Sale Id 1752',2301.12,0.00,0.00,3.06,263.16,'2023-01-10 16:58:34','',''),(1779,'1','306','1',1,'Retail Sale Id 1753',1496.48,0.00,0.00,1.99,171.14,'2023-01-10 17:00:24','',''),(1780,'1','306','1',1,'Retail Sale Id 1754',4496.96,0.00,0.00,5.98,514.28,'2023-01-10 17:10:07','',''),(1781,'1','306','1',1,'Retail Sale Id 1755',2301.12,0.00,0.00,3.06,263.16,'2023-01-10 17:11:21','',''),(1782,'1','306','1',1,'Retail Sale Id 1756',1496.48,0.00,0.00,1.99,171.14,'2023-01-10 17:12:29','',''),(1783,'1','306','1',1,'Retail Sale Id 1757',3797.60,0.00,0.00,5.05,434.30,'2023-01-10 17:22:33','',''),(1784,'1','306','1',1,'Retail Sale Id 1758',3797.60,0.00,0.00,5.05,434.30,'2023-01-10 17:24:14','',''),(1785,'1','306','1',1,'Retail Sale Id 1759',2301.12,0.00,0.00,3.06,263.16,'2023-01-10 17:25:33','',''),(1786,'1','306','1',1,'Retail Sale Id 1760',7497.44,0.00,0.00,9.97,857.42,'2023-01-10 17:31:08','',''),(1787,'1','306','1',1,'Retail Sale Id 1761',3000.48,0.00,0.00,3.99,343.14,'2023-01-10 17:32:41','',''),(1788,'1','306','1',1,'Retail Sale Id 1762',1496.48,0.00,0.00,1.99,171.14,'2023-01-10 17:34:15','',''),(1789,'1','306','1',1,'Retail Sale Id 1763',4512.00,0.00,0.00,6.00,516.00,'2023-01-10 17:35:32','',''),(1790,'1','306','1',1,'Retail Sale Id 1764',1000.16,0.00,0.00,1.33,114.38,'2023-01-10 17:40:41','',''),(1791,'1','306','1',1,'Retail Sale Id 1766',3797.60,0.00,0.00,5.05,434.30,'2023-01-10 17:43:00','',''),(1792,'1','306','1',1,'Retail Sale Id 1767',1496.48,0.00,0.00,1.99,171.14,'2023-01-10 17:47:18','',''),(1793,'1','306','1',1,'Retail Sale Id 1768',752.00,0.00,0.00,1.00,86.00,'2023-01-10 17:57:58','',''),(1794,'1','306','1',1,'Retail Sale Id 1769',4512.00,0.00,0.00,6.00,516.00,'2023-01-10 17:59:43','',''),(1795,'1','306','1',1,'Retail Sale Id 1770',1496.48,0.00,0.00,1.99,171.14,'2023-01-10 18:00:59','',''),(1796,'1','306','1',1,'Retail Sale Id 1771',1504.00,0.00,0.00,2.00,172.00,'2023-01-10 18:03:03','',''),(1797,'1','306','1',1,'Return of Retail Sale Id 1771',0.00,1504.00,2.00,0.00,-172.00,'2023-01-10 18:03:42','',''),(1798,'1','306','1',1,'Retail Sale Id 1772',1000.16,0.00,0.00,1.33,114.38,'2023-01-10 18:03:47','',''),(1799,'1','306','1',1,'Return of Retail Sale Id 1763',0.00,4512.00,6.00,0.00,-516.00,'2023-01-10 18:12:04','',''),(1800,'1','306','1',1,'Return of Retail Sale Id 1760',0.00,7497.44,9.97,0.00,-857.42,'2023-01-10 18:12:30','',''),(1801,'1','306','1',1,'Return of Retail Sale Id 1714',0.00,21600.00,30.00,0.00,-1620.00,'2023-01-10 18:13:26','',''),(1802,'1','306','1',1,'Retail Sale Id 1773',21420.00,0.00,0.00,29.75,1606.50,'2023-01-10 18:14:47','',''),(1803,'1','306','1',1,'Retail Sale Id 1774',10565.60,0.00,0.00,14.05,1208.30,'2023-01-10 18:15:57','',''),(1804,'1','306','1',1,'Retail Sale Id 1775',699.36,0.00,0.00,0.93,79.98,'2023-01-11 07:52:46','',''),(1805,'1','306','1',1,'Retail Sale Id 1776',3000.48,0.00,0.00,3.99,343.14,'2023-01-11 08:07:13','',''),(1806,'1','306','1',1,'Retail Sale Id 1777',4000.64,0.00,0.00,5.32,457.52,'2023-01-11 08:08:27','',''),(1807,'1','306','1',1,'Retail Sale Id 1779',2000.32,0.00,0.00,2.66,228.76,'2023-01-11 08:31:29','',''),(1808,'1','306','1',1,'Retail Sale Id 1780',4000.64,0.00,0.00,5.32,457.52,'2023-01-11 08:32:40','',''),(1809,'1','306','1',1,'Retail Sale Id 1782',2263.52,0.00,0.00,3.01,258.86,'2023-01-11 08:34:19','',''),(1810,'1','306','1',1,'Retail Sale Id 1783',3760.00,0.00,0.00,5.00,430.00,'2023-01-11 08:37:07','',''),(1811,'1','306','1',1,'Retail Sale Id 1784',3008.00,0.00,0.00,4.00,344.00,'2023-01-11 08:43:50','',''),(1812,'1','306','1',1,'Retail Sale Id 1785',3000.48,0.00,0.00,3.99,343.14,'2023-01-11 08:44:54','',''),(1813,'1','306','1',1,'Retail Sale Id 1786',3797.60,0.00,0.00,5.05,434.30,'2023-01-11 08:49:56','',''),(1814,'1','306','1',1,'Retail Sale Id 1787',4496.96,0.00,0.00,5.98,514.28,'2023-01-11 08:51:10','',''),(1815,'1','306','1',1,'Retail Sale Id 1788',4496.96,0.00,0.00,5.98,514.28,'2023-01-11 08:52:20','',''),(1816,'1','306','1',1,'Retail Sale Id 1789',4496.96,0.00,0.00,5.98,514.28,'2023-01-11 08:54:43','',''),(1817,'1','306','1',1,'Retail Sale Id 1791',9497.76,0.00,0.00,12.63,1086.18,'2023-01-11 09:02:35','',''),(1818,'1','306','1',1,'Retail Sale Id 1792',4527.04,0.00,0.00,6.02,517.72,'2023-01-11 09:06:23','',''),(1819,'1','306','1',1,'Retail Sale Id 1793',4000.64,0.00,0.00,5.32,457.52,'2023-01-11 09:09:30','',''),(1820,'1','306','1',1,'Retail Sale Id 1794',2323.68,0.00,0.00,3.09,265.74,'2023-01-11 09:11:49','',''),(1821,'1','306','1',1,'Retail Sale Id 1795',2271.04,0.00,0.00,3.02,259.72,'2023-01-11 09:17:26','',''),(1822,'1','306','1',1,'Retail Sale Id 1796',21600.00,0.00,0.00,30.00,1620.00,'2023-01-11 09:18:53','',''),(1823,'1','306','1',1,'Retail Sale Id 1797',10001.60,0.00,0.00,13.30,1143.80,'2023-01-11 09:28:50','',''),(1824,'1','306','1',1,'Retail Sale Id 1798',797.12,0.00,0.00,1.06,91.16,'2023-01-11 09:30:44','',''),(1825,'1','306','1',1,'Retail Sale Id 1799',4496.96,0.00,0.00,5.98,514.28,'2023-01-11 09:32:07','',''),(1826,'1','306','1',1,'Retail Sale Id 1801',2496.64,0.00,0.00,3.32,285.52,'2023-01-11 09:40:27','',''),(1827,'1','306','1',1,'Retail Sale Id 1802',3496.80,0.00,0.00,4.65,399.90,'2023-01-11 09:42:06','',''),(1828,'1','306','1',1,'Retail Sale Id 1804',7520.00,0.00,0.00,10.00,860.00,'2023-01-11 09:52:42','',''),(1829,'1','306','1',1,'Retail Sale Id 1805',3000.48,0.00,0.00,3.99,343.14,'2023-01-11 09:59:07','',''),(1830,'1','306','1',1,'Retail Sale Id 1806',2263.52,0.00,0.00,3.01,258.86,'2023-01-11 10:06:30','',''),(1831,'1','306','1',1,'Retail Sale Id 1807',3752.48,0.00,0.00,4.99,429.14,'2023-01-11 10:11:18','',''),(1832,'1','306','1',1,'Retail Sale Id 1808',1511.52,0.00,0.00,2.01,172.86,'2023-01-11 10:23:58','',''),(1833,'1','306','1',1,'Retail Sale Id 1809',3000.48,0.00,0.00,3.99,343.14,'2023-01-11 10:25:13','',''),(1834,'1','306','1',1,'Retail Sale Id 1810',9400.00,0.00,0.00,12.50,1075.00,'2023-01-11 10:29:21','',''),(1835,'1','306','1',1,'Retail Sale Id 1811',2000.32,0.00,0.00,2.66,228.76,'2023-01-11 10:38:16','',''),(1836,'1','306','1',1,'Retail Sale Id 1812',4496.96,0.00,0.00,5.98,514.28,'2023-01-11 10:50:42','',''),(1837,'1','306','1',1,'Retail Sale Id 1813',1496.48,0.00,0.00,1.99,171.14,'2023-01-11 10:53:47','',''),(1838,'1','306','1',1,'Retail Sale Id 1814',4000.64,0.00,0.00,5.32,457.52,'2023-01-11 10:57:45','',''),(1839,'1','306','1',1,'Retail Sale Id 1815',32400.00,0.00,0.00,45.00,2430.00,'2023-01-11 11:10:29','',''),(1840,'1','306','1',1,'Retail Sale Id 1816',3008.00,0.00,0.00,4.00,344.00,'2023-01-11 11:25:31','',''),(1841,'1','306','1',1,'Retail Sale Id 1817',2301.12,0.00,0.00,3.06,263.16,'2023-01-11 11:35:30','',''),(1842,'1','306','1',1,'Retail Sale Id 1818',3496.80,0.00,0.00,4.65,399.90,'2023-01-11 11:36:46','',''),(1843,'1','306','1',1,'Retail Sale Id 1819',2000.32,0.00,0.00,2.66,228.76,'2023-01-11 11:37:52','',''),(1844,'1','306','1',1,'Retail Sale Id 1820',1496.48,0.00,0.00,1.99,171.14,'2023-01-11 11:39:24','',''),(1845,'1','306','1',1,'Retail Sale Id 1821',4000.64,0.00,0.00,5.32,457.52,'2023-01-11 11:41:19','',''),(1846,'1','306','1',1,'Retail Sale Id 1822',8497.60,0.00,0.00,11.30,971.80,'2023-01-11 11:45:24','',''),(1847,'1','306','1',1,'Retail Sale Id 1824',849.76,0.00,0.00,1.13,97.18,'2023-01-11 11:46:43','',''),(1848,'1','306','1',1,'Retail Sale Id 1825',2271.04,0.00,0.00,3.02,259.72,'2023-01-11 11:59:49','',''),(1849,'1','306','1',1,'Retail Sale Id 1826',9001.44,0.00,0.00,11.97,1029.42,'2023-01-11 12:03:11','',''),(1850,'1','306','1',1,'Retail Sale Id 1827',2496.64,0.00,0.00,3.32,285.52,'2023-01-11 12:08:54','',''),(1851,'1','306','1',1,'Retail Sale Id 1828',3000.48,0.00,0.00,3.99,343.14,'2023-01-11 12:16:07','',''),(1852,'1','306','1',1,'Retail Sale Id 1829',7497.44,0.00,0.00,9.97,857.42,'2023-01-11 12:22:42','',''),(1853,'1','306','1',1,'Retail Sale Id 1830',2256.00,0.00,0.00,3.00,258.00,'2023-01-11 12:25:40','',''),(1854,'1','306','1',1,'Retail Sale Id 1830',3767.52,0.00,0.00,5.01,430.86,'2023-01-11 12:25:40','',''),(1855,'1','306','1',1,'Retail Sale Id 1831',3000.48,0.00,0.00,3.99,343.14,'2023-01-11 12:30:34','',''),(1856,'1','306','1',1,'Retail Sale Id 1833',4000.64,0.00,0.00,5.32,457.52,'2023-01-11 12:42:37','',''),(1857,'1','306','1',1,'Retail Sale Id 1834',752.00,0.00,0.00,1.00,86.00,'2023-01-11 12:45:47','',''),(1858,'1','306','1',1,'Retail Sale Id 1835',8497.60,0.00,0.00,11.30,971.80,'2023-01-11 12:47:30','',''),(1859,'1','306','1',1,'Retail Sale Id 1837',752.00,0.00,0.00,1.00,86.00,'2023-01-11 13:06:48','',''),(1860,'1','306','1',1,'Retail Sale Id 1837',752.00,0.00,0.00,1.00,86.00,'2023-01-11 13:06:48','',''),(1861,'1','306','1',1,'Retail Sale Id 1838',4496.96,0.00,0.00,5.98,514.28,'2023-01-11 13:25:46','',''),(1862,'1','306','1',1,'Retail Sale Id 1839',2301.12,0.00,0.00,3.06,263.16,'2023-01-11 13:30:42','',''),(1863,'1','306','1',1,'Retail Sale Id 1841',6798.08,0.00,0.00,9.04,777.44,'2023-01-11 13:52:47','',''),(1864,'1','306','1',1,'Retail Sale Id 1842',2000.32,0.00,0.00,2.66,228.76,'2023-01-11 13:57:31','',''),(1865,'1','306','1',1,'Retail Sale Id 1843',4000.64,0.00,0.00,5.32,457.52,'2023-01-11 14:00:58','',''),(1866,'1','306','1',1,'Retail Sale Id 1844',2496.64,0.00,0.00,3.32,285.52,'2023-01-11 14:02:25','',''),(1867,'1','306','1',1,'Retail Sale Id 1845',2496.64,0.00,0.00,3.32,285.52,'2023-01-11 14:06:53','',''),(1868,'1','306','1',1,'Retail Sale Id 1846',6000.96,0.00,0.00,7.98,686.28,'2023-01-11 14:12:55','',''),(1869,'1','306','1',1,'Retail Sale Id 1847',1496.48,0.00,0.00,1.99,171.14,'2023-01-11 14:18:45','',''),(1870,'1','306','1',1,'Retail Sale Id 1848',1496.48,0.00,0.00,1.99,171.14,'2023-01-11 14:25:04','',''),(1871,'1','306','1',1,'Retail Sale Id 1849',4000.64,0.00,0.00,5.32,457.52,'2023-01-11 14:25:49','',''),(1872,'1','306','1',1,'Retail Sale Id 1850',3000.48,0.00,0.00,3.99,343.14,'2023-01-11 14:40:39','',''),(1873,'1','306','1',1,'Retail Sale Id 1851',3850.24,0.00,0.00,5.12,440.32,'2023-01-11 14:50:06','',''),(1874,'1','306','1',1,'Retail Sale Id 1852',4000.64,0.00,0.00,5.32,457.52,'2023-01-11 14:52:25','',''),(1875,'1','306','1',1,'Retail Sale Id 1853',4549.60,0.00,0.00,6.05,520.30,'2023-01-11 14:59:07','',''),(1876,'1','306','1',1,'Retail Sale Id 1854',2301.12,0.00,0.00,3.06,263.16,'2023-01-11 15:02:44','',''),(1877,'1','306','1',1,'Retail Sale Id 1855',2301.12,0.00,0.00,3.06,263.16,'2023-01-11 15:03:53','',''),(1878,'1','306','1',1,'Retail Sale Id 1856',4519.52,0.00,0.00,6.01,516.86,'2023-01-11 15:06:16','',''),(1879,'1','306','1',1,'Retail Sale Id 1857',1000.16,0.00,0.00,1.33,114.38,'2023-01-11 15:09:26','',''),(1880,'1','306','1',1,'Retail Sale Id 1858',5000.80,0.00,0.00,6.65,571.90,'2023-01-11 15:11:07','',''),(1881,'1','306','1',1,'Retail Sale Id 1859',2000.32,0.00,0.00,2.66,228.76,'2023-01-11 15:31:01','',''),(1882,'1','306','1',1,'Retail Sale Id 1860',4496.96,0.00,0.00,5.98,514.28,'2023-01-11 15:34:00','',''),(1883,'1','306','1',1,'Retail Sale Id 1861',1496.48,0.00,0.00,1.99,171.14,'2023-01-11 15:45:07','',''),(1884,'1','306','1',1,'Retail Sale Id 1863',1511.52,0.00,0.00,2.01,172.86,'2023-01-11 15:52:37','',''),(1885,'1','306','1',1,'Retail Sale Id 1864',2000.32,0.00,0.00,2.66,228.76,'2023-01-11 16:04:16','',''),(1886,'1','306','1',1,'Retail Sale Id 1865',752.00,0.00,0.00,1.00,86.00,'2023-01-11 16:05:52','',''),(1887,'1','306','1',1,'Retail Sale Id 1866',9400.00,0.00,0.00,12.50,1075.00,'2023-01-11 16:07:20','',''),(1888,'1','306','1',1,'Retail Sale Id 1867',1496.48,0.00,0.00,1.99,171.14,'2023-01-11 16:19:54','',''),(1889,'1','306','1',1,'Retail Sale Id 1868',3797.60,0.00,0.00,5.05,434.30,'2023-01-11 16:21:10','',''),(1890,'1','306','1',1,'Retail Sale Id 1869',2361.28,0.00,0.00,3.14,270.04,'2023-01-11 16:30:35','',''),(1891,'1','306','1',1,'Retail Sale Id 1870',2301.12,0.00,0.00,3.06,263.16,'2023-01-11 16:39:45','',''),(1892,'1','306','1',1,'Retail Sale Id 1871',3496.80,0.00,0.00,4.65,399.90,'2023-01-11 16:43:10','',''),(1893,'1','306','1',1,'Retail Sale Id 1872',2203.36,0.00,0.00,2.93,251.98,'2023-01-11 16:52:28','',''),(1894,'1','306','1',1,'Retail Sale Id 1873',9400.00,0.00,0.00,12.50,1075.00,'2023-01-11 16:53:56','',''),(1895,'1','306','1',1,'Retail Sale Id 1874',1496.48,0.00,0.00,1.99,171.14,'2023-01-11 16:59:26','',''),(1896,'1','306','1',1,'Retail Sale Id 1875',2301.12,0.00,0.00,3.06,263.16,'2023-01-11 17:00:53','',''),(1897,'1','306','1',1,'Retail Sale Id 1876',3053.12,0.00,0.00,4.06,349.16,'2023-01-11 17:05:17','',''),(1898,'1','306','1',1,'Retail Sale Id 1877',4496.96,0.00,0.00,5.98,514.28,'2023-01-11 17:09:07','',''),(1899,'1','306','1',1,'Retail Sale Id 1878',3000.48,0.00,0.00,3.99,343.14,'2023-01-11 17:11:25','',''),(1900,'1','306','1',1,'Retail Sale Id 1879',4496.96,0.00,0.00,5.98,514.28,'2023-01-11 17:15:03','',''),(1901,'1','306','1',1,'Retail Sale Id 1880',752.00,0.00,0.00,1.00,86.00,'2023-01-11 17:18:02','',''),(1902,'1','306','1',1,'Retail Sale Id 1881',4602.24,0.00,0.00,6.12,526.32,'2023-01-11 17:20:04','',''),(1903,'1','306','1',1,'Retail Sale Id 1882',2000.32,0.00,0.00,2.66,228.76,'2023-01-11 17:26:33','',''),(1904,'1','306','1',1,'Retail Sale Id 1884',18000.00,0.00,0.00,25.00,1350.00,'2023-01-11 17:30:20','',''),(1905,'1','306','1',1,'Retail Sale Id 1885',21600.00,0.00,0.00,30.00,1620.00,'2023-01-11 17:33:07','',''),(1906,'1','306','1',1,'Retail Sale Id 1886',7497.44,0.00,0.00,9.97,857.42,'2023-01-11 17:36:17','',''),(1907,'1','306','1',1,'Retail Sale Id 1887',3496.80,0.00,0.00,4.65,399.90,'2023-01-11 17:39:04','',''),(1908,'1','306','1',1,'Retail Sale Id 1888',2301.12,0.00,0.00,3.06,263.16,'2023-01-11 17:43:20','',''),(1909,'1','306','1',1,'Retail Sale Id 1889',3000.48,0.00,0.00,3.99,343.14,'2023-01-11 17:44:49','',''),(1910,'1','306','1',1,'Retail Sale Id 1890',1496.48,0.00,0.00,1.99,171.14,'2023-01-11 18:01:02','',''),(1911,'1','306','1',1,'Retail Sale Id 1891',3000.48,0.00,0.00,3.99,343.14,'2023-01-11 18:06:33','',''),(1912,'1','306','1',1,'Return of Retail Sale Id 1891',0.00,3000.48,3.99,0.00,-343.14,'2023-01-11 18:26:35','',''),(1913,'1','306','1',1,'Retail Sale Id 1892',10490.40,0.00,0.00,13.95,1199.70,'2023-01-11 18:30:28','',''),(1914,'1','306','1',1,'Return of Retail Sale Id 1892',0.00,10490.40,13.95,0.00,-1199.70,'2023-01-11 18:31:25','',''),(1915,'1','306','1',1,'Retail Sale Id 1893',2970.40,0.00,0.00,3.95,339.70,'2023-01-11 18:33:58','',''),(1916,'1','306','1',1,'Retail Sale Id 1894',8272.00,0.00,0.00,11.00,946.00,'2023-01-12 07:52:00','',''),(1917,'1','306','1',1,'Retail Sale Id 1895',1496.48,0.00,0.00,1.99,171.14,'2023-01-12 08:10:08','',''),(1918,'1','306','1',1,'Retail Sale Id 1896',4496.96,0.00,0.00,5.98,514.28,'2023-01-12 08:17:44','',''),(1919,'1','306','1',1,'Retail Sale Id 1897',4549.60,0.00,0.00,6.05,520.30,'2023-01-12 08:19:19','',''),(1920,'1','306','1',1,'Retail Sale Id 1898',2301.12,0.00,0.00,3.06,263.16,'2023-01-12 08:36:07','',''),(1921,'1','306','1',1,'Retail Sale Id 1900',1496.48,0.00,0.00,1.99,171.14,'2023-01-12 08:38:29','',''),(1922,'1','306','1',1,'Retail Sale Id 1900',3000.48,0.00,0.00,3.99,343.14,'2023-01-12 08:38:29','',''),(1923,'1','306','1',1,'Retail Sale Id 1901',3000.48,0.00,0.00,3.99,343.14,'2023-01-12 08:43:28','',''),(1924,'1','306','1',1,'Retail Sale Id 1902',9400.00,0.00,0.00,12.50,1075.00,'2023-01-12 08:48:38','',''),(1925,'1','306','1',1,'Retail Sale Id 1903',1496.48,0.00,0.00,1.99,171.14,'2023-01-12 08:49:46','',''),(1926,'1','306','1',1,'Retail Sale Id 1904',3797.60,0.00,0.00,5.05,434.30,'2023-01-12 08:52:10','',''),(1927,'1','306','1',1,'Retail Sale Id 1906',1496.48,0.00,0.00,1.99,171.14,'2023-01-12 08:56:50','',''),(1928,'1','306','1',1,'Retail Sale Id 1907',3496.80,0.00,0.00,4.65,399.90,'2023-01-12 09:10:46','',''),(1929,'1','306','1',1,'Retail Sale Id 1908',4519.52,0.00,0.00,6.01,516.86,'2023-01-12 09:16:08','',''),(1930,'1','306','1',1,'Retail Sale Id 1909',20520.00,0.00,0.00,28.50,1539.00,'2023-01-12 09:30:51','',''),(1931,'1','306','1',1,'Retail Sale Id 1910',2301.12,0.00,0.00,3.06,263.16,'2023-01-12 09:33:13','',''),(1932,'1','306','1',1,'Retail Sale Id 1911',2000.32,0.00,0.00,2.66,228.76,'2023-01-12 09:35:28','',''),(1933,'1','306','1',1,'Retail Sale Id 1911',29997.28,0.00,0.00,39.89,3430.54,'2023-01-12 09:35:28','',''),(1934,'1','306','1',1,'Retail Sale Id 1912',2263.52,0.00,0.00,3.01,258.86,'2023-01-12 09:39:41','',''),(1935,'1','306','1',1,'Retail Sale Id 1913',3008.00,0.00,0.00,4.00,344.00,'2023-01-12 09:43:25','',''),(1936,'1','306','1',1,'Retail Sale Id 1914',2398.88,0.00,0.00,3.19,274.34,'2023-01-12 09:53:18','',''),(1937,'1','306','1',1,'Retail Sale Id 1915',8001.28,0.00,0.00,10.64,915.04,'2023-01-12 09:54:33','',''),(1938,'1','306','1',1,'Retail Sale Id 1916',4549.60,0.00,0.00,6.05,520.30,'2023-01-12 09:56:09','',''),(1939,'1','306','1',1,'Retail Sale Id 1917',4549.60,0.00,0.00,6.05,520.30,'2023-01-12 09:56:52','',''),(1940,'1','306','1',1,'Retail Sale Id 1918',2301.12,0.00,0.00,3.06,263.16,'2023-01-12 09:58:06','',''),(1941,'1','306','1',1,'Retail Sale Id 1920',797.12,0.00,0.00,1.06,91.16,'2023-01-12 09:59:41','',''),(1942,'1','306','1',1,'Retail Sale Id 1921',4512.00,0.00,0.00,6.00,516.00,'2023-01-12 10:08:50','',''),(1943,'1','306','1',1,'Retail Sale Id 1922',699.36,0.00,0.00,0.93,79.98,'2023-01-12 10:14:47','',''),(1944,'1','306','1',1,'Retail Sale Id 1923',2301.12,0.00,0.00,3.06,263.16,'2023-01-12 10:17:12','',''),(1945,'1','306','1',1,'Retail Sale Id 1924',4496.96,0.00,0.00,5.98,514.28,'2023-01-12 10:29:54','',''),(1946,'1','306','1',1,'Retail Sale Id 1925',797.12,0.00,0.00,1.06,91.16,'2023-01-12 10:30:53','',''),(1947,'1','306','1',1,'Retail Sale Id 1926',3008.00,0.00,0.00,4.00,344.00,'2023-01-12 10:31:57','',''),(1948,'1','306','1',1,'Retail Sale Id 1927',699.36,0.00,0.00,0.93,79.98,'2023-01-12 10:35:04','',''),(1949,'1','306','1',1,'Retail Sale Id 1928',4496.96,0.00,0.00,5.98,514.28,'2023-01-12 10:44:08','',''),(1950,'1','306','1',1,'Retail Sale Id 1929',7520.00,0.00,0.00,10.00,860.00,'2023-01-12 10:48:22','',''),(1951,'1','306','1',1,'Retail Sale Id 1930',1504.00,0.00,0.00,2.00,172.00,'2023-01-12 10:54:18','',''),(1952,'1','306','1',1,'Retail Sale Id 1931',3797.60,0.00,0.00,5.05,434.30,'2023-01-12 10:57:29','',''),(1953,'1','306','1',1,'Retail Sale Id 1932',3008.00,0.00,0.00,4.00,344.00,'2023-01-12 11:13:07','',''),(1954,'1','306','1',1,'Retail Sale Id 1933',4496.96,0.00,0.00,5.98,514.28,'2023-01-12 11:14:20','',''),(1955,'1','306','1',1,'Retail Sale Id 1934',43200.00,0.00,0.00,60.00,3240.00,'2023-01-12 11:23:09','',''),(1956,'1','306','1',1,'Retail Sale Id 1935',13320.00,0.00,0.00,18.50,999.00,'2023-01-12 11:24:59','',''),(1957,'1','306','1',1,'Retail Sale Id 1936',1000.16,0.00,0.00,1.33,114.38,'2023-01-12 11:26:30','',''),(1958,'1','306','1',1,'Retail Sale Id 1937',9400.00,0.00,0.00,12.50,1075.00,'2023-01-12 11:40:55','',''),(1959,'1','306','1',1,'Retail Sale Id 1938',218880.00,0.00,0.00,304.00,16416.00,'2023-01-12 11:51:29','',''),(1960,'1','306','1',1,'Retail Sale Id 1939',2256.00,0.00,0.00,3.00,258.00,'2023-01-12 11:54:02','',''),(1961,'1','306','1',1,'Retail Sale Id 1940',36000.00,0.00,0.00,50.00,2700.00,'2023-01-12 11:58:59','',''),(1962,'1','306','1',1,'Retail Sale Id 1941',4700.00,0.00,0.00,6.25,537.50,'2023-01-12 12:03:09','',''),(1963,'1','306','1',1,'Retail Sale Id 1943',3008.00,0.00,0.00,4.00,344.00,'2023-01-12 12:05:16','',''),(1964,'1','306','1',1,'Retail Sale Id 1944',3008.00,0.00,0.00,4.00,344.00,'2023-01-12 12:10:20','',''),(1965,'1','306','1',1,'Retail Sale Id 1945',1504.00,0.00,0.00,2.00,172.00,'2023-01-12 12:14:26','',''),(1966,'1','306','1',1,'Retail Sale Id 1947',2256.00,0.00,0.00,3.00,258.00,'2023-01-12 12:20:00','',''),(1967,'1','306','1',1,'Retail Sale Id 1948',2263.52,0.00,0.00,3.01,258.86,'2023-01-12 12:32:52','',''),(1968,'1','306','1',1,'Retail Sale Id 1949',5000.80,0.00,0.00,6.65,571.90,'2023-01-12 12:42:26','',''),(1969,'1','306','1',1,'Retail Sale Id 1950',1496.48,0.00,0.00,1.99,171.14,'2023-01-12 12:44:51','',''),(1970,'1','306','1',1,'Retail Sale Id 1951',2203.36,0.00,0.00,2.93,251.98,'2023-01-12 12:46:03','',''),(1971,'1','306','1',1,'Retail Sale Id 1952',2263.52,0.00,0.00,3.01,258.86,'2023-01-12 12:52:19','',''),(1972,'1','306','1',1,'Retail Sale Id 1954',2240.96,0.00,0.00,2.98,256.28,'2023-01-12 13:06:36','',''),(1973,'1','306','1',1,'Retail Sale Id 1954',3760.00,0.00,0.00,5.00,430.00,'2023-01-12 13:06:36','',''),(1974,'1','306','1',1,'Retail Sale Id 1955',752.00,0.00,0.00,1.00,86.00,'2023-01-12 13:08:44','',''),(1975,'1','306','1',1,'Retail Sale Id 1955',752.00,0.00,0.00,1.00,86.00,'2023-01-12 13:08:44','',''),(1976,'1','306','1',1,'Retail Sale Id 1956',2301.12,0.00,0.00,3.06,263.16,'2023-01-12 13:14:06','',''),(1977,'1','306','1',1,'Retail Sale Id 1957',3000.48,0.00,0.00,3.99,343.14,'2023-01-12 13:17:48','',''),(1978,'1','306','1',1,'Retail Sale Id 1958',1000.16,0.00,0.00,1.33,114.38,'2023-01-12 13:33:36','',''),(1979,'1','306','1',1,'Retail Sale Id 1959',2301.12,0.00,0.00,3.06,263.16,'2023-01-12 13:44:59','',''),(1980,'1','306','1',1,'Retail Sale Id 1960',2000.32,0.00,0.00,2.66,228.76,'2023-01-12 13:54:13','',''),(1981,'1','306','1',1,'Retail Sale Id 1961',9400.00,0.00,0.00,12.50,1075.00,'2023-01-12 13:56:04','',''),(1982,'1','306','1',1,'Retail Sale Id 1962',2301.12,0.00,0.00,3.06,263.16,'2023-01-12 14:02:53','',''),(1983,'1','306','1',1,'Retail Sale Id 1963',4496.96,0.00,0.00,5.98,514.28,'2023-01-12 14:05:29','',''),(1984,'1','306','1',1,'Retail Sale Id 1964',2301.12,0.00,0.00,3.06,263.16,'2023-01-12 14:16:22','',''),(1985,'1','306','1',1,'Retail Sale Id 1965',2301.12,0.00,0.00,3.06,263.16,'2023-01-12 14:17:32','',''),(1986,'1','306','1',1,'Retail Sale Id 1966',4512.00,0.00,0.00,6.00,516.00,'2023-01-12 14:40:46','',''),(1987,'1','306','1',1,'Retail Sale Id 1967',9400.00,0.00,0.00,12.50,1075.00,'2023-01-12 14:52:03','',''),(1988,'1','306','1',1,'Retail Sale Id 1968',1496.48,0.00,0.00,1.99,171.14,'2023-01-12 14:53:24','',''),(1989,'1','306','1',1,'Retail Sale Id 1970',3496.80,0.00,0.00,4.65,399.90,'2023-01-12 14:55:53','',''),(1990,'1','306','1',1,'Retail Sale Id 1971',3699.84,0.00,0.00,4.92,423.12,'2023-01-12 15:06:52','',''),(1991,'1','306','1',1,'Retail Sale Id 1972',2902.72,0.00,0.00,3.86,331.96,'2023-01-12 15:10:41','',''),(1992,'1','306','1',1,'Retail Sale Id 1973',2301.12,0.00,0.00,3.06,263.16,'2023-01-12 15:13:58','',''),(1993,'1','306','1',1,'Retail Sale Id 1974',25200.00,0.00,0.00,35.00,1890.00,'2023-01-12 15:23:55','',''),(1994,'1','306','1',1,'Retail Sale Id 1975',14400.00,0.00,0.00,20.00,1080.00,'2023-01-12 15:26:52','',''),(1995,'1','306','1',1,'Retail Sale Id 1976',5000.80,0.00,0.00,6.65,571.90,'2023-01-12 15:30:57','',''),(1996,'1','306','1',1,'Retail Sale Id 1977',2278.56,0.00,0.00,3.03,260.58,'2023-01-12 15:32:33','',''),(1997,'1','306','1',1,'Retail Sale Id 1978',2301.12,0.00,0.00,3.06,263.16,'2023-01-12 15:37:50','',''),(1998,'1','306','1',1,'Retail Sale Id 1979',1511.52,0.00,0.00,2.01,172.86,'2023-01-12 15:40:00','',''),(1999,'1','306','1',1,'Retail Sale Id 1980',7497.44,0.00,0.00,9.97,857.42,'2023-01-12 15:45:33','',''),(2000,'1','306','1',1,'Retail Sale Id 1981',1496.48,0.00,0.00,1.99,171.14,'2023-01-12 15:48:43','',''),(2001,'1','306','1',1,'Retail Sale Id 1983',4512.00,0.00,0.00,6.00,516.00,'2023-01-12 15:53:47','',''),(2002,'1','306','1',1,'Retail Sale Id 1985',1797.28,0.00,0.00,2.39,205.54,'2023-01-12 15:55:58','',''),(2003,'1','306','1',1,'Retail Sale Id 1986',752.00,0.00,0.00,1.00,86.00,'2023-01-12 16:00:10','',''),(2004,'1','306','1',1,'Retail Sale Id 1987',4496.96,0.00,0.00,5.98,514.28,'2023-01-12 16:04:56','',''),(2005,'1','306','1',1,'Retail Sale Id 1988',3008.00,0.00,0.00,4.00,344.00,'2023-01-12 16:16:14','',''),(2006,'1','306','1',1,'Retail Sale Id 1989',1496.48,0.00,0.00,1.99,171.14,'2023-01-12 16:19:39','',''),(2007,'1','306','1',1,'Retail Sale Id 1991',2000.32,0.00,0.00,2.66,228.76,'2023-01-12 16:32:47','',''),(2008,'1','306','1',1,'Retail Sale Id 1992',4496.96,0.00,0.00,5.98,514.28,'2023-01-12 16:42:57','',''),(2009,'1','306','1',1,'Retail Sale Id 1993',3098.24,0.00,0.00,4.12,354.32,'2023-01-12 16:45:16','',''),(2010,'1','306','1',1,'Retail Sale Id 1995',2699.68,0.00,0.00,3.59,308.74,'2023-01-12 16:48:41','',''),(2011,'1','306','1',1,'Retail Sale Id 1996',3000.48,0.00,0.00,3.99,343.14,'2023-01-12 16:52:07','',''),(2012,'1','306','1',1,'Retail Sale Id 1997',4519.52,0.00,0.00,6.01,516.86,'2023-01-12 17:05:26','',''),(2013,'1','306','1',1,'Retail Sale Id 1998',1511.52,0.00,0.00,2.01,172.86,'2023-01-12 17:09:23','',''),(2014,'1','306','1',1,'Retail Sale Id 1999',1511.52,0.00,0.00,2.01,172.86,'2023-01-12 17:16:40','',''),(2015,'1','306','1',1,'Retail Sale Id 2000',5000.80,0.00,0.00,6.65,571.90,'2023-01-12 17:17:36','',''),(2016,'1','306','1',1,'Retail Sale Id 2001',2301.12,0.00,0.00,3.06,263.16,'2023-01-12 17:21:56','',''),(2017,'1','306','1',1,'Retail Sale Id 2002',3000.48,0.00,0.00,3.99,343.14,'2023-01-12 17:22:50','',''),(2018,'1','306','1',1,'Retail Sale Id 2003',2000.32,0.00,0.00,2.66,228.76,'2023-01-12 17:23:47','',''),(2019,'1','306','1',1,'Retail Sale Id 2004',5000.80,0.00,0.00,6.65,571.90,'2023-01-12 17:25:11','',''),(2020,'1','306','1',1,'Retail Sale Id 2005',1496.48,0.00,0.00,1.99,171.14,'2023-01-12 17:30:04','',''),(2021,'1','306','1',1,'Retail Sale Id 2006',2647.04,0.00,0.00,3.52,302.72,'2023-01-12 17:37:24','',''),(2022,'1','306','1',1,'Retail Sale Id 2007',6023.52,0.00,0.00,8.01,688.86,'2023-01-12 17:41:34','',''),(2023,'1','306','1',1,'Retail Sale Id 2008',797.12,0.00,0.00,1.06,91.16,'2023-01-12 17:47:24','',''),(2024,'1','306','1',1,'Retail Sale Id 2009',2301.12,0.00,0.00,3.06,263.16,'2023-01-12 17:50:27','',''),(2025,'1','306','1',1,'Retail Sale Id 2010',1496.48,0.00,0.00,1.99,171.14,'2023-01-12 17:52:43','',''),(2026,'1','306','1',1,'Retail Sale Id 2011',3760.00,0.00,0.00,5.00,430.00,'2023-01-12 17:54:58','',''),(2027,'1','306','1',1,'Retail Sale Id 2012',4496.96,0.00,0.00,5.98,514.28,'2023-01-12 18:05:02','',''),(2028,'1','306','1',1,'Retail Sale Id 2013',3000.48,0.00,0.00,3.99,343.14,'2023-01-12 18:10:57','',''),(2029,'1','306','1',1,'Retail Sale Id 2014',2301.12,0.00,0.00,3.06,263.16,'2023-01-12 18:12:10','',''),(2030,'1','306','1',1,'Retail Sale Id 2015',33336.00,0.00,0.00,46.30,2500.20,'2023-01-12 18:16:20','',''),(2031,'1','306','1',1,'Retail Sale Id 2016',3600.00,0.00,0.00,5.00,270.00,'2023-01-12 18:20:15','',''),(2032,'1','306','1',1,'Retail Sale Id 2017',9400.00,0.00,0.00,12.50,1075.00,'2023-01-12 18:27:32','',''),(2033,'1','306','1',1,'Retail Sale Id 2018',2301.12,0.00,0.00,3.06,263.16,'2023-01-12 18:32:29','',''),(2034,'1','306','1',1,'Return of Retail Sale Id 2018',0.00,2301.12,3.06,0.00,-263.16,'2023-01-12 18:54:55','',''),(2035,'1','306','1',1,'Retail Sale Id 2019',2098.08,0.00,0.00,2.79,239.94,'2023-01-12 18:55:57','',''),(2036,'1','306','1',1,'Retail Sale Id 2020',7001.12,0.00,0.00,9.31,800.66,'2023-01-13 07:43:27','',''),(2037,'1','306','1',1,'Retail Sale Id 2021',2970.40,0.00,0.00,3.95,339.70,'2023-01-13 07:45:16','',''),(2038,'1','306','1',1,'Retail Sale Id 2022',2248.48,0.00,0.00,2.99,257.14,'2023-01-13 07:54:53','',''),(2039,'1','306','1',1,'Retail Sale Id 2023',2496.64,0.00,0.00,3.32,285.52,'2023-01-13 07:56:55','',''),(2040,'1','306','1',1,'Retail Sale Id 2024',797.12,0.00,0.00,1.06,91.16,'2023-01-13 07:59:20','',''),(2041,'1','306','1',1,'Retail Sale Id 2025',2000.32,0.00,0.00,2.66,228.76,'2023-01-13 08:07:07','',''),(2042,'1','306','1',1,'Retail Sale Id 2026',2000.32,0.00,0.00,2.66,228.76,'2023-01-13 08:08:59','',''),(2043,'1','306','1',1,'Retail Sale Id 2027',9497.76,0.00,0.00,12.63,1086.18,'2023-01-13 08:14:57','',''),(2044,'1','306','1',1,'Retail Sale Id 2028',2256.00,0.00,0.00,3.00,258.00,'2023-01-13 08:17:21','',''),(2045,'1','306','1',1,'Retail Sale Id 2030',2301.12,0.00,0.00,3.06,263.16,'2023-01-13 08:21:52','',''),(2046,'1','306','1',1,'Retail Sale Id 2031',7550.08,0.00,0.00,10.04,863.44,'2023-01-13 08:24:54','',''),(2047,'1','306','1',1,'Retail Sale Id 2032',797.12,0.00,0.00,1.06,91.16,'2023-01-13 08:26:07','',''),(2048,'1','306','1',1,'Retail Sale Id 2033',9001.44,0.00,0.00,11.97,1029.42,'2023-01-13 08:27:10','',''),(2049,'1','306','1',1,'Retail Sale Id 2034',2263.52,0.00,0.00,3.01,258.86,'2023-01-13 08:28:22','',''),(2050,'1','306','1',1,'Retail Sale Id 2035',3797.60,0.00,0.00,5.05,434.30,'2023-01-13 08:35:27','',''),(2051,'1','306','1',1,'Retail Sale Id 2036',4496.96,0.00,0.00,5.98,514.28,'2023-01-13 08:37:40','',''),(2052,'1','306','1',1,'Retail Sale Id 2037',9400.00,0.00,0.00,12.50,1075.00,'2023-01-13 08:40:22','',''),(2053,'1','306','1',1,'Retail Sale Id 2038',2301.12,0.00,0.00,3.06,263.16,'2023-01-13 08:41:28','',''),(2054,'1','306','1',1,'Retail Sale Id 2039',1496.48,0.00,0.00,1.99,171.14,'2023-01-13 08:42:33','',''),(2055,'1','306','1',1,'Retail Sale Id 2040',797.12,0.00,0.00,1.06,91.16,'2023-01-13 08:47:28','',''),(2056,'1','306','1',1,'Retail Sale Id 2041',1496.48,0.00,0.00,1.99,171.14,'2023-01-13 08:49:30','',''),(2057,'1','306','1',1,'Retail Sale Id 2042',2263.52,0.00,0.00,3.01,258.86,'2023-01-13 08:58:23','',''),(2058,'1','306','1',1,'Retail Sale Id 2043',797.12,0.00,0.00,1.06,91.16,'2023-01-13 09:08:51','',''),(2059,'1','306','1',1,'Retail Sale Id 2045',1000.16,0.00,0.00,1.33,114.38,'2023-01-13 09:09:54','',''),(2060,'1','306','1',1,'Retail Sale Id 2046',7602.72,0.00,0.00,10.11,869.46,'2023-01-13 09:11:14','',''),(2061,'1','306','1',1,'Retail Sale Id 2047',8497.60,0.00,0.00,11.30,971.80,'2023-01-13 09:13:23','',''),(2062,'1','306','1',1,'Retail Sale Id 2048',1496.48,0.00,0.00,1.99,171.14,'2023-01-13 09:20:31','',''),(2063,'1','306','1',1,'Retail Sale Id 2049',1496.48,0.00,0.00,1.99,171.14,'2023-01-13 09:21:33','',''),(2064,'1','306','1',1,'Retail Sale Id 2052',4519.52,0.00,0.00,6.01,516.86,'2023-01-13 09:23:09','',''),(2065,'1','306','1',1,'Retail Sale Id 2053',9001.44,0.00,0.00,11.97,1029.42,'2023-01-13 09:25:48','',''),(2066,'1','306','1',1,'Retail Sale Id 2054',9400.00,0.00,0.00,12.50,1075.00,'2023-01-13 09:26:42','',''),(2067,'1','306','1',1,'Retail Sale Id 2055',2301.12,0.00,0.00,3.06,263.16,'2023-01-13 09:29:28','',''),(2068,'1','306','1',1,'Retail Sale Id 2056',2248.48,0.00,0.00,2.99,257.14,'2023-01-13 09:30:37','',''),(2069,'1','306','1',1,'Retail Sale Id 2057',797.12,0.00,0.00,1.06,91.16,'2023-01-13 09:32:04','',''),(2070,'1','306','1',1,'Retail Sale Id 2058',7001.12,0.00,0.00,9.31,800.66,'2023-01-13 09:33:40','',''),(2071,'1','306','1',1,'Retail Sale Id 2059',3797.60,0.00,0.00,5.05,434.30,'2023-01-13 09:35:56','',''),(2072,'1','306','1',1,'Retail Sale Id 2060',5264.00,0.00,0.00,7.00,602.00,'2023-01-13 09:38:29','',''),(2073,'1','306','1',1,'Retail Sale Id 2061',7520.00,0.00,0.00,10.00,860.00,'2023-01-13 09:39:39','',''),(2074,'1','306','1',1,'Return of Retail Sale Id 2058',0.00,7001.12,9.31,0.00,-800.66,'2023-01-13 09:51:16','',''),(2075,'1','306','1',1,'Return of Retail Sale Id 2053',0.00,9001.44,11.97,0.00,-1029.42,'2023-01-13 09:52:11','',''),(2076,'1','306','1',1,'Retail Sale Id 2062',1496.48,0.00,0.00,1.99,171.14,'2023-01-13 09:53:36','',''),(2077,'1','306','1',1,'Retail Sale Id 2063',3797.60,0.00,0.00,5.05,434.30,'2023-01-13 09:54:42','',''),(2078,'1','306','1',1,'Retail Sale Id 2064',1511.52,0.00,0.00,2.01,172.86,'2023-01-13 09:55:41','',''),(2079,'1','306','1',1,'Retail Sale Id 2065',9400.00,0.00,0.00,12.50,1075.00,'2023-01-13 09:56:48','',''),(2080,'1','306','1',1,'Retail Sale Id 2066',3797.60,0.00,0.00,5.05,434.30,'2023-01-13 09:58:27','',''),(2081,'1','306','1',1,'Retail Sale Id 2067',7001.12,0.00,0.00,9.31,800.66,'2023-01-13 10:01:29','',''),(2082,'1','306','1',1,'Retail Sale Id 2068',2000.32,0.00,0.00,2.66,228.76,'2023-01-13 10:02:22','',''),(2083,'1','306','1',1,'Retail Sale Id 2069',2301.12,0.00,0.00,3.06,263.16,'2023-01-13 10:06:18','',''),(2084,'1','306','1',1,'Retail Sale Id 2070',3008.00,0.00,0.00,4.00,344.00,'2023-01-13 10:12:59','',''),(2085,'1','306','1',1,'Retail Sale Id 2071',4519.52,0.00,0.00,6.01,516.86,'2023-01-13 10:14:55','',''),(2086,'1','306','1',1,'Retail Sale Id 2072',5000.80,0.00,0.00,6.65,571.90,'2023-01-13 10:17:31','',''),(2087,'1','306','1',1,'Retail Sale Id 2073',10800.00,0.00,0.00,15.00,810.00,'2023-01-13 10:27:42','',''),(2088,'1','306','1',1,'Retail Sale Id 2074',2301.12,0.00,0.00,3.06,263.16,'2023-01-13 10:31:19','',''),(2089,'1','306','1',1,'Retail Sale Id 2075',5000.80,0.00,0.00,6.65,571.90,'2023-01-13 10:33:03','',''),(2090,'1','306','1',1,'Retail Sale Id 2076',2301.12,0.00,0.00,3.06,263.16,'2023-01-13 10:35:54','',''),(2091,'1','306','1',1,'Retail Sale Id 2077',1511.52,0.00,0.00,2.01,172.86,'2023-01-13 10:36:49','',''),(2092,'1','306','1',1,'Retail Sale Id 2078',1000.16,0.00,0.00,1.33,114.38,'2023-01-13 10:37:56','',''),(2093,'1','306','1',1,'Retail Sale Id 2079',1511.52,0.00,0.00,2.01,172.86,'2023-01-13 10:39:55','',''),(2094,'1','306','1',1,'Retail Sale Id 2080',41760.00,0.00,0.00,58.00,3132.00,'2023-01-13 10:44:23','',''),(2095,'1','306','1',1,'Retail Sale Id 2081',3000.48,0.00,0.00,3.99,343.14,'2023-01-13 10:46:54','',''),(2096,'1','306','1',1,'Retail Sale Id 2082',3000.48,0.00,0.00,3.99,343.14,'2023-01-13 10:53:12','',''),(2097,'1','306','1',1,'Retail Sale Id 2084',1511.52,0.00,0.00,2.01,172.86,'2023-01-13 10:59:12','',''),(2098,'1','306','1',1,'Retail Sale Id 2085',4519.52,0.00,0.00,6.01,516.86,'2023-01-13 11:09:57','',''),(2099,'1','306','1',1,'Retail Sale Id 2086',699.36,0.00,0.00,0.93,79.98,'2023-01-13 11:10:59','',''),(2100,'1','306','1',1,'Retail Sale Id 2089',4519.52,0.00,0.00,6.01,516.86,'2023-01-13 11:12:07','',''),(2101,'1','306','1',1,'Retail Sale Id 2090',4519.52,0.00,0.00,6.01,516.86,'2023-01-13 11:13:05','',''),(2102,'1','306','1',1,'Retail Sale Id 2091',3797.60,0.00,0.00,5.05,434.30,'2023-01-13 11:19:25','',''),(2103,'1','306','1',1,'Retail Sale Id 2093',117312.00,0.00,0.00,156.00,13416.00,'2023-01-13 11:23:28','',''),(2104,'1','306','1',1,'Retail Sale Id 2094',2263.52,0.00,0.00,3.01,258.86,'2023-01-13 11:24:28','',''),(2105,'1','306','1',1,'Retail Sale Id 2095',3760.00,0.00,0.00,5.00,430.00,'2023-01-13 11:28:29','',''),(2106,'1','306','1',1,'Retail Sale Id 2096',4000.64,0.00,0.00,5.32,457.52,'2023-01-13 11:29:34','',''),(2107,'1','306','1',1,'Retail Sale Id 2097',2398.88,0.00,0.00,3.19,274.34,'2023-01-13 11:30:51','',''),(2108,'1','306','1',1,'Retail Sale Id 2099',9497.76,0.00,0.00,12.63,1086.18,'2023-01-13 11:32:18','',''),(2109,'1','306','1',1,'Retail Sale Id 2101',2496.64,0.00,0.00,3.32,285.52,'2023-01-13 11:35:21','',''),(2110,'1','306','1',1,'Retail Sale Id 2102',9400.00,0.00,0.00,12.50,1075.00,'2023-01-13 11:36:16','',''),(2111,'1','306','1',1,'Retail Sale Id 2103',9497.76,0.00,0.00,12.63,1086.18,'2023-01-13 11:37:27','',''),(2112,'1','306','1',1,'Return of Retail Sale Id 2102',0.00,9400.00,12.50,0.00,-1075.00,'2023-01-13 11:40:19','',''),(2113,'1','306','1',1,'Retail Sale Id 2104',197640.00,0.00,0.00,274.50,14823.00,'2023-01-13 11:40:58','',''),(2114,'1','306','1',1,'Retail Sale Id 2105',4519.52,0.00,0.00,6.01,516.86,'2023-01-13 11:41:54','',''),(2115,'1','306','1',1,'Retail Sale Id 2106',3000.48,0.00,0.00,3.99,343.14,'2023-01-13 11:47:43','',''),(2116,'1','306','1',1,'Retail Sale Id 2107',7200.00,0.00,0.00,10.00,540.00,'2023-01-13 11:49:20','',''),(2117,'1','306','1',1,'Retail Sale Id 2108',1511.52,0.00,0.00,2.01,172.86,'2023-01-13 11:51:02','',''),(2118,'1','306','1',1,'Return of Retail Sale Id 2093',0.00,117312.00,156.00,0.00,-13416.00,'2023-01-13 12:09:59','',''),(2119,'1','306','1',1,'Retail Sale Id 2109',112320.00,0.00,0.00,156.00,8424.00,'2023-01-13 12:11:38','',''),(2120,'1','306','1',1,'Retail Sale Id 2110',3760.00,0.00,0.00,5.00,430.00,'2023-01-13 12:16:34','',''),(2121,'1','306','1',1,'Retail Sale Id 2111',43200.00,0.00,0.00,60.00,3240.00,'2023-01-13 12:20:35','',''),(2122,'1','306','1',1,'Retail Sale Id 2113',3098.24,0.00,0.00,4.12,354.32,'2023-01-13 12:37:44','',''),(2123,'1','306','1',1,'Retail Sale Id 2114',1902.56,0.00,0.00,2.53,217.58,'2023-01-13 12:41:30','',''),(2124,'1','306','1',1,'Retail Sale Id 2115',3797.60,0.00,0.00,5.05,434.30,'2023-01-13 12:46:03','',''),(2125,'1','306','1',1,'Retail Sale Id 2116',174240.00,0.00,0.00,242.00,13068.00,'2023-01-13 12:51:36','',''),(2126,'1','306','1',1,'Retail Sale Id 2117',752.00,0.00,0.00,1.00,86.00,'2023-01-13 12:52:52','',''),(2127,'1','306','1',1,'Retail Sale Id 2117',752.00,0.00,0.00,1.00,86.00,'2023-01-13 12:52:52','',''),(2128,'1','306','1',1,'Retail Sale Id 2118',3496.80,0.00,0.00,4.65,399.90,'2023-01-13 12:53:53','',''),(2129,'1','306','1',1,'Retail Sale Id 2119',1496.48,0.00,0.00,1.99,171.14,'2023-01-13 13:02:14','',''),(2130,'1','306','1',1,'Retail Sale Id 2120',3797.60,0.00,0.00,5.05,434.30,'2023-01-13 13:07:24','',''),(2131,'1','306','1',1,'Retail Sale Id 2121',174240.00,0.00,0.00,242.00,13068.00,'2023-01-13 13:12:16','',''),(2132,'1','306','1',1,'Retail Sale Id 2122',1511.52,0.00,0.00,2.01,172.86,'2023-01-13 13:14:47','',''),(2133,'1','306','1',1,'Retail Sale Id 2123',4000.64,0.00,0.00,5.32,457.52,'2023-01-13 13:16:14','',''),(2134,'1','306','1',1,'Return of Retail Sale Id 2116',0.00,174240.00,242.00,0.00,-13068.00,'2023-01-13 13:18:16','',''),(2135,'1','306','1',1,'Retail Sale Id 2124',1496.48,0.00,0.00,1.99,171.14,'2023-01-13 13:27:10','',''),(2136,'1','306','1',1,'Retail Sale Id 2125',2000.32,0.00,0.00,2.66,228.76,'2023-01-13 13:28:08','',''),(2137,'1','306','1',1,'Retail Sale Id 2126',3797.60,0.00,0.00,5.05,434.30,'2023-01-13 13:39:15','',''),(2138,'1','306','1',1,'Retail Sale Id 2127',4496.96,0.00,0.00,5.98,514.28,'2023-01-13 13:40:56','',''),(2139,'1','306','1',1,'Retail Sale Id 2128',2248.48,0.00,0.00,2.99,257.14,'2023-01-13 13:43:10','',''),(2140,'1','306','1',1,'Retail Sale Id 2129',4519.52,0.00,0.00,6.01,516.86,'2023-01-13 13:50:15','',''),(2141,'1','306','1',1,'Retail Sale Id 2130',4000.64,0.00,0.00,5.32,457.52,'2023-01-13 13:51:40','',''),(2142,'1','306','1',1,'Retail Sale Id 2132',1504.00,0.00,0.00,2.00,172.00,'2023-01-13 13:53:08','',''),(2143,'1','306','1',1,'Retail Sale Id 2133',2301.12,0.00,0.00,3.06,263.16,'2023-01-13 13:54:40','',''),(2144,'1','306','1',1,'Retail Sale Id 2134',3797.60,0.00,0.00,5.05,434.30,'2023-01-13 14:00:04','',''),(2145,'1','306','1',1,'Retail Sale Id 2135',2301.12,0.00,0.00,3.06,263.16,'2023-01-13 14:04:13','',''),(2146,'1','306','1',1,'Retail Sale Id 2136',2256.00,0.00,0.00,3.00,258.00,'2023-01-13 14:06:57','',''),(2147,'1','306','1',1,'Retail Sale Id 2136',2256.00,0.00,0.00,3.00,258.00,'2023-01-13 14:06:57','',''),(2148,'1','306','1',1,'Retail Sale Id 2136',9400.00,0.00,0.00,12.50,1075.00,'2023-01-13 14:06:57','',''),(2149,'1','306','1',1,'Retail Sale Id 2137',2301.12,0.00,0.00,3.06,263.16,'2023-01-13 14:13:14','',''),(2150,'1','306','1',1,'Retail Sale Id 2138',2256.00,0.00,0.00,3.00,258.00,'2023-01-13 14:14:26','',''),(2151,'1','306','1',1,'Retail Sale Id 2139',3000.48,0.00,0.00,3.99,343.14,'2023-01-13 14:24:49','',''),(2152,'1','306','1',1,'Retail Sale Id 2140',3797.60,0.00,0.00,5.05,434.30,'2023-01-13 14:26:12','',''),(2153,'1','306','1',1,'Retail Sale Id 2141',2301.12,0.00,0.00,3.06,263.16,'2023-01-13 14:31:24','',''),(2154,'1','306','1',1,'Retail Sale Id 2142',1496.48,0.00,0.00,1.99,171.14,'2023-01-13 14:36:27','',''),(2155,'1','306','1',1,'Retail Sale Id 2143',3000.48,0.00,0.00,3.99,343.14,'2023-01-13 14:40:39','',''),(2156,'1','306','1',1,'Retail Sale Id 2144',1000.16,0.00,0.00,1.33,114.38,'2023-01-13 14:47:31','',''),(2157,'1','306','1',1,'Retail Sale Id 2145',3496.80,0.00,0.00,4.65,399.90,'2023-01-13 14:49:01','',''),(2158,'1','306','1',1,'Retail Sale Id 2146',3008.00,0.00,0.00,4.00,344.00,'2023-01-13 14:55:26','',''),(2159,'1','306','1',1,'Retail Sale Id 2147',2301.12,0.00,0.00,3.06,263.16,'2023-01-13 14:57:02','',''),(2160,'1','306','1',1,'Retail Sale Id 2148',9400.00,0.00,0.00,12.50,1075.00,'2023-01-13 15:01:57','',''),(2161,'1','306','1',1,'Retail Sale Id 2149',1496.48,0.00,0.00,1.99,171.14,'2023-01-13 15:03:08','',''),(2162,'1','306','1',1,'Retail Sale Id 2150',112800.00,0.00,0.00,150.00,12900.00,'2023-01-13 15:07:37','',''),(2163,'1','306','1',1,'Retail Sale Id 2151',4496.96,0.00,0.00,5.98,514.28,'2023-01-13 15:09:52','',''),(2164,'1','306','1',1,'Retail Sale Id 2152',2301.12,0.00,0.00,3.06,263.16,'2023-01-13 15:11:31','',''),(2165,'1','306','1',1,'Retail Sale Id 2153',4496.96,0.00,0.00,5.98,514.28,'2023-01-13 15:16:47','',''),(2166,'1','306','1',1,'Retail Sale Id 2154',797.12,0.00,0.00,1.06,91.16,'2023-01-13 15:19:09','',''),(2167,'1','306','1',1,'Retail Sale Id 2155',1496.48,0.00,0.00,1.99,171.14,'2023-01-13 15:21:39','',''),(2168,'1','306','1',1,'Retail Sale Id 2156',4301.44,0.00,0.00,5.72,491.92,'2023-01-13 15:34:54','',''),(2169,'1','306','1',1,'Retail Sale Id 2157',4519.52,0.00,0.00,6.01,516.86,'2023-01-13 15:36:47','',''),(2170,'1','306','1',1,'Retail Sale Id 2158',9400.00,0.00,0.00,12.50,1075.00,'2023-01-13 15:38:17','',''),(2171,'1','306','1',1,'Retail Sale Id 2159',4519.52,0.00,0.00,6.01,516.86,'2023-01-13 15:41:41','',''),(2172,'1','306','1',1,'Retail Sale Id 2160',2263.52,0.00,0.00,3.01,258.86,'2023-01-13 15:42:52','',''),(2173,'1','306','1',1,'Retail Sale Id 2161',3008.00,0.00,0.00,4.00,344.00,'2023-01-13 15:54:52','',''),(2174,'1','306','1',1,'Retail Sale Id 2162',2248.48,0.00,0.00,2.99,257.14,'2023-01-13 15:57:14','',''),(2175,'1','306','1',1,'Retail Sale Id 2162',3752.48,0.00,0.00,4.99,429.14,'2023-01-13 15:57:14','',''),(2176,'1','306','1',1,'Retail Sale Id 2163',2301.12,0.00,0.00,3.06,263.16,'2023-01-13 16:05:23','',''),(2177,'1','306','1',1,'Retail Sale Id 2164',2301.12,0.00,0.00,3.06,263.16,'2023-01-13 16:11:25','',''),(2178,'1','306','1',1,'Retail Sale Id 2165',2301.12,0.00,0.00,3.06,263.16,'2023-01-13 16:12:26','',''),(2179,'1','306','1',1,'Retail Sale Id 2166',1496.48,0.00,0.00,1.99,171.14,'2023-01-13 16:16:19','',''),(2180,'1','306','1',1,'Retail Sale Id 2167',3000.48,0.00,0.00,3.99,343.14,'2023-01-13 16:17:50','',''),(2181,'1','306','1',1,'Retail Sale Id 2168',2000.32,0.00,0.00,2.66,228.76,'2023-01-13 16:23:15','',''),(2182,'1','306','1',1,'Retail Sale Id 2169',797.12,0.00,0.00,1.06,91.16,'2023-01-13 16:24:07','',''),(2183,'1','306','1',1,'Retail Sale Id 2170',3000.48,0.00,0.00,3.99,343.14,'2023-01-13 16:26:38','',''),(2184,'1','306','1',1,'Retail Sale Id 2171',3797.60,0.00,0.00,5.05,434.30,'2023-01-13 16:28:06','',''),(2185,'1','306','1',1,'Retail Sale Id 2172',2699.68,0.00,0.00,3.59,308.74,'2023-01-13 16:37:36','',''),(2186,'1','306','1',1,'Retail Sale Id 2173',4519.52,0.00,0.00,6.01,516.86,'2023-01-13 16:41:54','',''),(2187,'1','306','1',1,'Retail Sale Id 2174',3000.48,0.00,0.00,3.99,343.14,'2023-01-13 16:52:30','',''),(2188,'1','306','1',1,'Retail Sale Id 2175',1496.48,0.00,0.00,1.99,171.14,'2023-01-13 16:53:35','',''),(2189,'1','306','1',1,'Retail Sale Id 2176',1496.48,0.00,0.00,1.99,171.14,'2023-01-13 17:03:27','',''),(2190,'1','306','1',1,'Retail Sale Id 2177',797.12,0.00,0.00,1.06,91.16,'2023-01-13 17:08:09','',''),(2191,'1','306','1',1,'Retail Sale Id 2178',4496.96,0.00,0.00,5.98,514.28,'2023-01-13 17:11:01','',''),(2192,'1','306','1',1,'Retail Sale Id 2179',797.12,0.00,0.00,1.06,91.16,'2023-01-13 17:12:34','',''),(2193,'1','306','1',1,'Retail Sale Id 2180',3797.60,0.00,0.00,5.05,434.30,'2023-01-13 17:13:49','',''),(2194,'1','306','1',1,'Retail Sale Id 2181',3000.48,0.00,0.00,3.99,343.14,'2023-01-13 17:15:04','',''),(2195,'1','306','1',1,'Retail Sale Id 2182',2301.12,0.00,0.00,3.06,263.16,'2023-01-13 17:16:38','',''),(2196,'1','306','1',1,'Retail Sale Id 2183',1496.48,0.00,0.00,1.99,171.14,'2023-01-13 17:24:28','',''),(2197,'1','306','1',1,'Retail Sale Id 2185',3000.48,0.00,0.00,3.99,343.14,'2023-01-13 17:31:47','',''),(2198,'1','306','1',1,'Retail Sale Id 2186',4000.64,0.00,0.00,5.32,457.52,'2023-01-13 17:32:53','',''),(2199,'1','306','1',1,'Retail Sale Id 2187',2301.12,0.00,0.00,3.06,263.16,'2023-01-13 17:33:48','',''),(2200,'1','306','1',1,'Retail Sale Id 2188',1496.48,0.00,0.00,1.99,171.14,'2023-01-13 17:34:48','',''),(2201,'1','306','1',1,'Retail Sale Id 2189',2301.12,0.00,0.00,3.06,263.16,'2023-01-13 17:36:04','',''),(2202,'1','306','1',1,'Retail Sale Id 2190',1496.48,0.00,0.00,1.99,171.14,'2023-01-13 17:36:57','',''),(2203,'1','306','1',1,'Retail Sale Id 2191',2301.12,0.00,0.00,3.06,263.16,'2023-01-13 17:40:30','',''),(2204,'1','306','1',1,'Retail Sale Id 2192',797.12,0.00,0.00,1.06,91.16,'2023-01-13 17:42:16','',''),(2205,'1','306','1',1,'Retail Sale Id 2193',3797.60,0.00,0.00,5.05,434.30,'2023-01-13 17:50:08','',''),(2206,'1','306','1',1,'Retail Sale Id 2194',2301.12,0.00,0.00,3.06,263.16,'2023-01-13 18:02:37','',''),(2207,'1','306','1',1,'Retail Sale Id 2195',1504.00,0.00,0.00,2.00,172.00,'2023-01-13 18:11:25','',''),(2208,'1','306','1',1,'Retail Sale Id 2197',4496.96,0.00,0.00,5.98,514.28,'2023-01-13 18:13:09','',''),(2209,'1','306','1',1,'Return of Retail Sale Id 2197',0.00,4496.96,5.98,0.00,-514.28,'2023-01-13 18:27:20','',''),(2210,'1','306','1',1,'Return of Retail Sale Id 2107',0.00,7200.00,10.00,0.00,-540.00,'2023-01-13 18:27:46','',''),(2211,'1','306','1',1,'Retail Sale Id 2198',6998.40,0.00,0.00,9.72,524.88,'2023-01-13 18:29:03','',''),(2212,'1','306','1',1,'Retail Sale Id 2199',3699.84,0.00,0.00,4.92,423.12,'2023-01-13 18:30:13','',''),(2213,'1','306','1',1,'Retail Sale Id 2200',3000.48,0.00,0.00,3.99,343.14,'2023-01-14 07:55:37','',''),(2214,'1','306','1',1,'Retail Sale Id 2201',2000.32,0.00,0.00,2.66,228.76,'2023-01-14 08:00:03','',''),(2215,'1','306','1',1,'Retail Sale Id 2202',1496.48,0.00,0.00,1.99,171.14,'2023-01-14 08:02:13','',''),(2216,'1','306','1',1,'Retail Sale Id 2204',2256.00,0.00,0.00,3.00,258.00,'2023-01-14 08:05:56','',''),(2217,'1','306','1',1,'Retail Sale Id 2205',752.00,0.00,0.00,1.00,86.00,'2023-01-14 08:07:34','',''),(2218,'1','306','1',1,'Retail Sale Id 2206',797.12,0.00,0.00,1.06,91.16,'2023-01-14 08:16:54','',''),(2219,'1','306','1',1,'Retail Sale Id 2207',9400.00,0.00,0.00,12.50,1075.00,'2023-01-14 08:24:57','',''),(2220,'1','306','1',1,'Retail Sale Id 2209',4519.52,0.00,0.00,6.01,516.86,'2023-01-14 08:34:41','',''),(2221,'1','306','1',1,'Retail Sale Id 2210',3496.80,0.00,0.00,4.65,399.90,'2023-01-14 08:35:59','',''),(2222,'1','306','1',1,'Retail Sale Id 2211',2301.12,0.00,0.00,3.06,263.16,'2023-01-14 08:37:05','',''),(2223,'1','306','1',1,'Retail Sale Id 2212',4496.96,0.00,0.00,5.98,514.28,'2023-01-14 08:39:43','',''),(2224,'1','306','1',1,'Retail Sale Id 2213',1496.48,0.00,0.00,1.99,171.14,'2023-01-14 08:40:30','',''),(2225,'1','306','1',1,'Retail Sale Id 2214',2248.48,0.00,0.00,2.99,257.14,'2023-01-14 08:53:34','',''),(2226,'1','306','1',1,'Retail Sale Id 2215',1496.48,0.00,0.00,1.99,171.14,'2023-01-14 08:58:34','',''),(2227,'1','306','1',1,'Retail Sale Id 2216',2301.12,0.00,0.00,3.06,263.16,'2023-01-14 08:59:49','',''),(2228,'1','306','1',1,'Retail Sale Id 2217',4519.52,0.00,0.00,6.01,516.86,'2023-01-14 09:08:32','',''),(2229,'1','306','1',1,'Retail Sale Id 2218',3797.60,0.00,0.00,5.05,434.30,'2023-01-14 09:13:27','',''),(2230,'1','306','1',1,'Retail Sale Id 2219',1496.48,0.00,0.00,1.99,171.14,'2023-01-14 09:14:21','',''),(2231,'1','306','1',1,'Retail Sale Id 2220',18800.00,0.00,0.00,25.00,2150.00,'2023-01-14 09:15:36','',''),(2232,'1','306','1',1,'Retail Sale Id 2221',2301.12,0.00,0.00,3.06,263.16,'2023-01-14 09:17:57','',''),(2233,'1','306','1',1,'Retail Sale Id 2222',2301.12,0.00,0.00,3.06,263.16,'2023-01-14 09:18:53','',''),(2234,'1','306','1',1,'Retail Sale Id 2224',2263.52,0.00,0.00,3.01,258.86,'2023-01-14 09:20:50','',''),(2235,'1','306','1',1,'Retail Sale Id 2225',2301.12,0.00,0.00,3.06,263.16,'2023-01-14 09:22:49','',''),(2236,'1','306','1',1,'Retail Sale Id 2226',3496.80,0.00,0.00,4.65,399.90,'2023-01-14 09:23:57','',''),(2237,'1','306','1',1,'Retail Sale Id 2227',3008.00,0.00,0.00,4.00,344.00,'2023-01-14 09:25:09','',''),(2238,'1','306','1',1,'Retail Sale Id 2228',3000.48,0.00,0.00,3.99,343.14,'2023-01-14 09:30:40','',''),(2239,'1','306','1',1,'Retail Sale Id 2229',2301.12,0.00,0.00,3.06,263.16,'2023-01-14 09:36:38','',''),(2240,'1','306','1',1,'Retail Sale Id 2230',2248.48,0.00,0.00,2.99,257.14,'2023-01-14 09:37:54','',''),(2241,'1','306','1',1,'Retail Sale Id 2231',4519.52,0.00,0.00,6.01,516.86,'2023-01-14 09:42:26','',''),(2242,'1','306','1',1,'Retail Sale Id 2232',1511.52,0.00,0.00,2.01,172.86,'2023-01-14 09:43:46','',''),(2243,'1','306','1',1,'Retail Sale Id 2233',4000.64,0.00,0.00,5.32,457.52,'2023-01-14 09:45:17','',''),(2244,'1','306','1',1,'Retail Sale Id 2234',4519.52,0.00,0.00,6.01,516.86,'2023-01-14 09:53:14','',''),(2245,'1','306','1',1,'Retail Sale Id 2235',1519.04,0.00,0.00,2.02,173.72,'2023-01-14 09:54:23','',''),(2246,'1','306','1',1,'Retail Sale Id 2236',2301.12,0.00,0.00,3.06,263.16,'2023-01-14 09:56:14','',''),(2247,'1','306','1',1,'Retail Sale Id 2237',4496.96,0.00,0.00,5.98,514.28,'2023-01-14 09:57:12','',''),(2248,'1','306','1',1,'Retail Sale Id 2238',2263.52,0.00,0.00,3.01,258.86,'2023-01-14 10:00:23','',''),(2249,'1','306','1',1,'Retail Sale Id 2239',3053.12,0.00,0.00,4.06,349.16,'2023-01-14 10:01:39','',''),(2250,'1','306','1',1,'Retail Sale Id 2240',4496.96,0.00,0.00,5.98,514.28,'2023-01-14 10:10:20','',''),(2251,'1','306','1',1,'Retail Sale Id 2241',3797.60,0.00,0.00,5.05,434.30,'2023-01-14 10:11:20','',''),(2252,'1','306','1',1,'Retail Sale Id 2242',7520.00,0.00,0.00,10.00,860.00,'2023-01-14 10:13:15','',''),(2253,'1','306','1',1,'Retail Sale Id 2243',3000.48,0.00,0.00,3.99,343.14,'2023-01-14 10:26:35','',''),(2254,'1','306','1',1,'Retail Sale Id 2244',3797.60,0.00,0.00,5.05,434.30,'2023-01-14 10:38:10','',''),(2255,'1','306','1',1,'Retail Sale Id 2245',4549.60,0.00,0.00,6.05,520.30,'2023-01-14 10:39:30','',''),(2256,'1','306','1',1,'Retail Sale Id 2246',2301.12,0.00,0.00,3.06,263.16,'2023-01-14 10:47:13','',''),(2257,'1','306','1',1,'Retail Sale Id 2247',9430.08,0.00,0.00,12.54,1078.44,'2023-01-14 10:49:20','',''),(2258,'1','306','1',1,'Retail Sale Id 2248',2301.12,0.00,0.00,3.06,263.16,'2023-01-14 10:52:53','',''),(2259,'1','306','1',1,'Retail Sale Id 2249',1519.04,0.00,0.00,2.02,173.72,'2023-01-14 10:54:08','',''),(2260,'1','306','1',1,'Retail Sale Id 2250',4519.52,0.00,0.00,6.01,516.86,'2023-01-14 10:57:42','',''),(2261,'1','306','1',1,'Retail Sale Id 2251',2301.12,0.00,0.00,3.06,263.16,'2023-01-14 10:59:06','',''),(2262,'1','306','1',1,'Retail Sale Id 2252',3008.00,0.00,0.00,4.00,344.00,'2023-01-14 11:01:14','',''),(2263,'1','306','1',1,'Retail Sale Id 2254',30080.00,0.00,0.00,40.00,3440.00,'2023-01-14 11:04:24','',''),(2264,'1','306','1',1,'Retail Sale Id 2256',1128.00,0.00,0.00,1.50,129.00,'2023-01-14 11:07:41','',''),(2265,'1','306','1',1,'Retail Sale Id 2257',2263.52,0.00,0.00,3.01,258.86,'2023-01-14 11:09:10','',''),(2266,'1','306','1',1,'Retail Sale Id 2258',4512.00,0.00,0.00,6.00,516.00,'2023-01-14 11:10:59','',''),(2267,'1','306','1',1,'Retail Sale Id 2258',8272.00,0.00,0.00,11.00,946.00,'2023-01-14 11:10:59','',''),(2268,'1','306','1',1,'Retail Sale Id 2260',11280.00,0.00,0.00,15.00,1290.00,'2023-01-14 11:12:43','',''),(2269,'1','306','1',1,'Retail Sale Id 2261',3000.48,0.00,0.00,3.99,343.14,'2023-01-14 11:16:05','',''),(2270,'1','306','1',1,'Retail Sale Id 2262',4496.96,0.00,0.00,5.98,514.28,'2023-01-14 11:17:27','',''),(2271,'1','306','1',1,'Retail Sale Id 2264',2308.64,0.00,0.00,3.07,264.02,'2023-01-14 11:19:56','',''),(2272,'1','306','1',1,'Retail Sale Id 2265',9497.76,0.00,0.00,12.63,1086.18,'2023-01-14 11:21:06','',''),(2273,'1','306','1',1,'Retail Sale Id 2266',797.12,0.00,0.00,1.06,91.16,'2023-01-14 11:23:38','',''),(2274,'1','306','1',1,'Retail Sale Id 2267',4000.64,0.00,0.00,5.32,457.52,'2023-01-14 11:24:44','',''),(2275,'1','306','1',1,'Retail Sale Id 2268',2203.36,0.00,0.00,2.93,251.98,'2023-01-14 11:25:56','',''),(2276,'1','306','1',1,'Retail Sale Id 2271',4519.52,0.00,0.00,6.01,516.86,'2023-01-14 11:28:17','',''),(2277,'1','306','1',1,'Retail Sale Id 2273',2278.56,0.00,0.00,3.03,260.58,'2023-01-14 11:30:30','',''),(2278,'1','306','1',1,'Retail Sale Id 2273',4519.52,0.00,0.00,6.01,516.86,'2023-01-14 11:30:30','',''),(2279,'1','306','1',1,'Retail Sale Id 2274',3797.60,0.00,0.00,5.05,434.30,'2023-01-14 11:31:56','',''),(2280,'1','306','1',1,'Retail Sale Id 2275',4496.96,0.00,0.00,5.98,514.28,'2023-01-14 11:32:55','',''),(2281,'1','306','1',1,'Retail Sale Id 2276',21600.00,0.00,0.00,30.00,1620.00,'2023-01-14 11:34:14','',''),(2282,'1','306','1',1,'Retail Sale Id 2277',2880.00,0.00,0.00,4.00,216.00,'2023-01-14 11:36:14','',''),(2283,'1','306','1',1,'Retail Sale Id 2278',8497.60,0.00,0.00,11.30,971.80,'2023-01-14 11:37:08','',''),(2284,'1','306','1',1,'Retail Sale Id 2279',3000.48,0.00,0.00,3.99,343.14,'2023-01-14 11:39:55','',''),(2285,'1','306','1',1,'Retail Sale Id 2280',902.40,0.00,0.00,1.20,103.20,'2023-01-14 11:42:41','',''),(2286,'1','306','1',1,'Retail Sale Id 2281',21845.60,0.00,0.00,29.05,2498.30,'2023-01-14 11:51:37','',''),(2287,'1','306','1',1,'Retail Sale Id 2282',37600.00,0.00,0.00,50.00,4300.00,'2023-01-14 11:55:55','',''),(2288,'1','306','1',1,'Retail Sale Id 2282',37600.00,0.00,0.00,50.00,4300.00,'2023-01-14 11:55:55','',''),(2289,'1','306','1',1,'Retail Sale Id 2283',4519.52,0.00,0.00,6.01,516.86,'2023-01-14 11:57:33','',''),(2290,'1','306','1',1,'Retail Sale Id 2284',4000.64,0.00,0.00,5.32,457.52,'2023-01-14 11:59:03','',''),(2291,'1','306','1',1,'Retail Sale Id 2285',2263.52,0.00,0.00,3.01,258.86,'2023-01-14 12:02:43','',''),(2292,'1','306','1',1,'Retail Sale Id 2286',7550.08,0.00,0.00,10.04,863.44,'2023-01-14 12:09:10','',''),(2293,'1','306','1',1,'Retail Sale Id 2287',25200.00,0.00,0.00,35.00,1890.00,'2023-01-14 12:16:55','',''),(2294,'1','306','1',1,'Retail Sale Id 2288',46080.00,0.00,0.00,64.00,3456.00,'2023-01-14 12:18:25','',''),(2295,'1','306','1',1,'Retail Sale Id 2289',1519.04,0.00,0.00,2.02,173.72,'2023-01-14 12:19:18','',''),(2296,'1','306','1',1,'Return of Retail Sale Id 2276',0.00,21600.00,30.00,0.00,-1620.00,'2023-01-14 12:20:48','',''),(2297,'1','306','1',1,'Return of Retail Sale Id 2281',0.00,21845.60,29.05,0.00,-2498.30,'2023-01-14 12:21:41','',''),(2298,'1','306','1',1,'Retail Sale Id 2291',4549.60,0.00,0.00,6.05,520.30,'2023-01-14 12:25:52','',''),(2299,'1','306','1',1,'Retail Sale Id 2292',20916.00,0.00,0.00,29.05,1568.70,'2023-01-14 12:28:00','',''),(2300,'1','306','1',1,'Retail Sale Id 2293',3902.88,0.00,0.00,5.19,446.34,'2023-01-14 12:33:10','',''),(2301,'1','306','1',1,'Retail Sale Id 2294',1496.48,0.00,0.00,1.99,171.14,'2023-01-14 12:34:09','',''),(2302,'1','306','1',1,'Retail Sale Id 2295',4000.64,0.00,0.00,5.32,457.52,'2023-01-14 12:35:08','',''),(2303,'1','306','1',1,'Retail Sale Id 2296',2301.12,0.00,0.00,3.06,263.16,'2023-01-14 12:38:01','',''),(2304,'1','306','1',1,'Retail Sale Id 2297',2301.12,0.00,0.00,3.06,263.16,'2023-01-14 12:40:06','',''),(2305,'1','306','1',1,'Retail Sale Id 2298',1511.52,0.00,0.00,2.01,172.86,'2023-01-14 12:44:16','',''),(2306,'1','306','1',1,'Retail Sale Id 2300',1519.04,0.00,0.00,2.02,173.72,'2023-01-14 12:47:53','',''),(2307,'1','306','1',1,'Retail Sale Id 2301',4519.52,0.00,0.00,6.01,516.86,'2023-01-14 12:53:45','',''),(2308,'1','306','1',1,'Retail Sale Id 2302',1496.48,0.00,0.00,1.99,171.14,'2023-01-14 13:04:47','',''),(2309,'1','306','1',1,'Retail Sale Id 2303',2496.64,0.00,0.00,3.32,285.52,'2023-01-14 13:07:46','',''),(2310,'1','306','1',1,'Retail Sale Id 2304',2000.32,0.00,0.00,2.66,228.76,'2023-01-14 13:09:05','',''),(2311,'1','306','1',1,'Retail Sale Id 2305',15776.96,0.00,0.00,20.98,1804.28,'2023-01-14 13:15:43','',''),(2312,'1','306',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,49563.72,74.42,0.00,0.00,'2023-01-14 14:41:07','',''),(2313,'1','306',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,74.42,0.00,'2023-01-14 14:42:20','',''),(2314,'1','306','1',1,'Received from bridging 6',0.00,0.00,74.42,0.00,0.00,'2023-01-14 14:42:20','',''),(2315,'1','306','1',1,'Retail Sale Id 2306',55963.84,0.00,0.00,74.42,6400.12,'2023-01-14 14:43:44','',''),(2316,'1','306',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,3196800.00,4800.00,0.00,0.00,'2023-01-15 11:00:13','',''),(2317,'1','306',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,4800.00,0.00,'2023-01-15 11:01:16','',''),(2318,'1','306','1',1,'Received from bridging 7',0.00,0.00,4800.00,0.00,0.00,'2023-01-15 11:01:16','',''),(2319,'1','306','1',1,'Retail Sale Id 2307',1540.00,0.00,0.00,2.00,208.00,'2023-01-15 11:23:26','',''),(2320,'1','306','1',1,'Retail Sale Id 2308',4620.00,0.00,0.00,6.00,624.00,'2023-01-15 11:24:35','',''),(2321,'1','306','1',1,'Retail Sale Id 2309',2310.00,0.00,0.00,3.00,312.00,'2023-01-15 11:28:31','',''),(2322,'1','306','1',1,'Retail Sale Id 2310',9625.00,0.00,0.00,12.50,1300.00,'2023-01-15 11:29:17','',''),(2323,'1','306','1',1,'Retail Sale Id 2311',3003.00,0.00,0.00,3.90,405.60,'2023-01-15 11:40:05','',''),(2324,'1','306','1',1,'Retail Sale Id 2312',5998.30,0.00,0.00,7.79,810.16,'2023-01-15 11:41:34','',''),(2325,'1','306','1',1,'Retail Sale Id 2313',2202.20,0.00,0.00,2.86,297.44,'2023-01-15 11:43:03','',''),(2326,'1','306','1',1,'Retail Sale Id 2314',9001.30,0.00,0.00,11.69,1215.76,'2023-01-15 11:43:44','',''),(2327,'1','306','1',1,'Retail Sale Id 2315',7499.80,0.00,0.00,9.74,1012.96,'2023-01-15 11:44:25','',''),(2328,'1','306','1',1,'Retail Sale Id 2316',2402.40,0.00,0.00,3.12,324.48,'2023-01-15 11:45:06','',''),(2329,'1','306','1',1,'Retail Sale Id 2317',1601.60,0.00,0.00,2.08,216.32,'2023-01-15 11:45:50','',''),(2330,'1','306','1',1,'Retail Sale Id 2318',2502.50,0.00,0.00,3.25,338.00,'2023-01-15 11:46:50','',''),(2331,'1','306','1',1,'Retail Sale Id 2319',3503.50,0.00,0.00,4.55,473.20,'2023-01-15 11:47:41','',''),(2332,'1','306','1',1,'Retail Sale Id 2320',9001.30,0.00,0.00,11.69,1215.76,'2023-01-15 11:48:24','',''),(2333,'1','306','1',1,'Retail Sale Id 2321',2302.30,0.00,0.00,2.99,310.96,'2023-01-15 11:49:03','',''),(2334,'1','306','1',1,'Retail Sale Id 2322',1501.50,0.00,0.00,1.95,202.80,'2023-01-15 11:50:21','',''),(2335,'1','306','1',1,'Retail Sale Id 2323',2302.30,0.00,0.00,2.99,310.96,'2023-01-15 11:51:15','',''),(2336,'1','306','1',1,'Retail Sale Id 2324',1201.20,0.00,0.00,1.56,162.24,'2023-01-15 11:52:16','',''),(2337,'1','306','1',1,'Retail Sale Id 2325',9501.80,0.00,0.00,12.34,1283.36,'2023-01-15 11:53:25','',''),(2338,'1','306','1',1,'Retail Sale Id 2326',2302.30,0.00,0.00,2.99,310.96,'2023-01-15 11:54:14','',''),(2339,'1','306','1',1,'Retail Sale Id 2327',2302.30,0.00,0.00,2.99,310.96,'2023-01-15 11:56:21','',''),(2340,'1','306','1',1,'Retail Sale Id 2329',1670.90,0.00,0.00,2.17,225.68,'2023-01-15 11:57:27','',''),(2341,'1','306','1',1,'Retail Sale Id 2330',3080.00,0.00,0.00,4.00,416.00,'2023-01-15 11:59:00','',''),(2342,'1','306','1',1,'Retail Sale Id 2331',3803.80,0.00,0.00,4.94,513.76,'2023-01-15 12:00:18','',''),(2343,'1','306','1',1,'Retail Sale Id 2332',2302.30,0.00,0.00,2.99,310.96,'2023-01-15 12:01:36','',''),(2344,'1','306','1',1,'Retail Sale Id 2333',3850.00,0.00,0.00,5.00,520.00,'2023-01-15 12:04:22','',''),(2345,'1','306','1',1,'Retail Sale Id 2333',9625.00,0.00,0.00,12.50,1300.00,'2023-01-15 12:04:22','',''),(2346,'1','306','1',1,'Retail Sale Id 2334',1501.50,0.00,0.00,1.95,202.80,'2023-01-15 12:06:11','',''),(2347,'1','306','1',1,'Retail Sale Id 2335',4997.30,0.00,0.00,6.49,674.96,'2023-01-15 12:08:26','',''),(2348,'1','306','1',1,'Retail Sale Id 2336',9702.00,0.00,0.00,12.60,1310.40,'2023-01-15 12:09:41','',''),(2349,'1','306','1',1,'Retail Sale Id 2337',4496.80,0.00,0.00,5.84,607.36,'2023-01-15 12:11:04','',''),(2350,'1','306','1',1,'Retail Sale Id 2338',2002.00,0.00,0.00,2.60,270.40,'2023-01-15 12:23:38','',''),(2351,'1','306','1',1,'Retail Sale Id 2340',9702.00,0.00,0.00,12.60,1310.40,'2023-01-15 12:28:31','',''),(2352,'1','306','1',1,'Retail Sale Id 2341',746.90,0.00,0.00,0.97,100.88,'2023-01-15 12:29:43','',''),(2353,'1','306','1',1,'Retail Sale Id 2342',2310.00,0.00,0.00,3.00,312.00,'2023-01-15 12:31:47','',''),(2354,'1','306','1',1,'Retail Sale Id 2343',9240.00,0.00,0.00,12.00,1248.00,'2023-01-15 12:34:44','',''),(2355,'1','306','1',1,'Retail Sale Id 2344',2302.30,0.00,0.00,2.99,310.96,'2023-01-15 12:39:04','',''),(2356,'1','306','1',1,'Retail Sale Id 2345',3850.00,0.00,0.00,5.00,520.00,'2023-01-15 12:40:27','',''),(2357,'1','306','1',1,'Retail Sale Id 2346',2302.30,0.00,0.00,2.99,310.96,'2023-01-15 12:45:31','',''),(2358,'1','306','1',1,'Retail Sale Id 2347',2502.50,0.00,0.00,3.25,338.00,'2023-01-15 12:47:02','',''),(2359,'1','306','1',1,'Retail Sale Id 2348',5005.00,0.00,0.00,6.50,676.00,'2023-01-15 12:49:26','',''),(2360,'1','306','1',1,'Return of Retail Sale Id 2330',0.00,3080.00,4.00,0.00,-416.00,'2023-01-15 12:55:28','',''),(2361,'1','306','1',1,'Retail Sale Id 2349',2310.00,0.00,0.00,3.00,312.00,'2023-01-15 13:14:39','',''),(2362,'1','306','1',1,'Retail Sale Id 2351',4596.90,0.00,0.00,5.97,620.88,'2023-01-15 13:38:15','',''),(2363,'1','306','1',1,'Retail Sale Id 2352',1540.00,0.00,0.00,2.00,208.00,'2023-01-15 13:41:28','',''),(2364,'1','306','1',1,'Retail Sale Id 2354',16060.00,0.00,0.00,22.00,1408.00,'2023-01-15 13:45:35','',''),(2365,'1','306','1',1,'Retail Sale Id 2355',5005.00,0.00,0.00,6.50,676.00,'2023-01-15 13:48:47','',''),(2366,'1','306','1',1,'Retail Sale Id 2356',800.80,0.00,0.00,1.04,108.16,'2023-01-15 13:50:03','',''),(2367,'1','306','1',1,'Retail Sale Id 2357',3996.30,0.00,0.00,5.19,539.76,'2023-01-15 13:52:17','',''),(2368,'1','306','1',1,'Retail Sale Id 2358',1540.00,0.00,0.00,2.00,208.00,'2023-01-15 13:53:06','',''),(2369,'1','306','1',1,'Retail Sale Id 2359',2310.00,0.00,0.00,3.00,312.00,'2023-01-15 13:55:18','',''),(2370,'1','306','1',1,'Retail Sale Id 2360',4620.00,0.00,0.00,6.00,624.00,'2023-01-15 14:03:21','',''),(2371,'1','306','1',1,'Retail Sale Id 2361',3080.00,0.00,0.00,4.00,416.00,'2023-01-15 14:05:21','',''),(2372,'1','306','1',1,'Retail Sale Id 2362',4620.00,0.00,0.00,6.00,624.00,'2023-01-15 14:06:43','',''),(2373,'1','306','1',1,'Retail Sale Id 2363',3003.00,0.00,0.00,3.90,405.60,'2023-01-15 14:12:01','',''),(2374,'1','306','1',1,'Retail Sale Id 2364',28097.30,0.00,0.00,36.49,3794.96,'2023-01-15 14:12:57','',''),(2375,'1','306','1',1,'Retail Sale Id 2365',3996.30,0.00,0.00,5.19,539.76,'2023-01-15 14:14:08','',''),(2376,'1','306','1',1,'Retail Sale Id 2366',36500.00,0.00,0.00,50.00,3200.00,'2023-01-15 14:15:32','',''),(2377,'1','306','1',1,'Retail Sale Id 2367',54750.00,0.00,0.00,75.00,4800.00,'2023-01-15 14:17:06','',''),(2378,'1','306','1',1,'Retail Sale Id 2368',4620.00,0.00,0.00,6.00,624.00,'2023-01-15 14:28:56','',''),(2379,'1','306','1',1,'Retail Sale Id 2369',2302.30,0.00,0.00,2.99,310.96,'2023-01-15 14:35:08','',''),(2380,'1','306','1',1,'Retail Sale Id 2370',3850.00,0.00,0.00,5.00,520.00,'2023-01-15 14:39:58','',''),(2381,'1','306','1',1,'Retail Sale Id 2371',4620.00,0.00,0.00,6.00,624.00,'2023-01-15 14:44:17','',''),(2382,'1','306','1',1,'Retail Sale Id 2373',2310.00,0.00,0.00,3.00,312.00,'2023-01-15 14:50:59','',''),(2383,'1','306','1',1,'Retail Sale Id 2374',1001.00,0.00,0.00,1.30,135.20,'2023-01-15 14:53:33','',''),(2384,'1','306','1',1,'Retail Sale Id 2375',5390.00,0.00,0.00,7.00,728.00,'2023-01-15 16:08:08','',''),(2385,'1','306','1',1,'Retail Sale Id 2376',7700.00,0.00,0.00,10.00,1040.00,'2023-01-15 16:10:13','',''),(2386,'1','306','1',1,'Retail Sale Id 2377',4620.00,0.00,0.00,6.00,624.00,'2023-01-15 16:12:03','',''),(2387,'1','306','1',1,'Retail Sale Id 2378',1540.00,0.00,0.00,2.00,208.00,'2023-01-15 16:13:52','',''),(2388,'1','306','1',1,'Retail Sale Id 2378',2310.00,0.00,0.00,3.00,312.00,'2023-01-15 16:13:52','',''),(2389,'1','306','1',1,'Retail Sale Id 2379',1001.00,0.00,0.00,1.30,135.20,'2023-01-15 16:14:50','',''),(2390,'1','306','1',1,'Retail Sale Id 2380',3003.00,0.00,0.00,3.90,405.60,'2023-01-15 16:15:50','',''),(2391,'1','306','1',1,'Retail Sale Id 2382',2002.00,0.00,0.00,2.60,270.40,'2023-01-15 16:16:43','',''),(2392,'1','306','1',1,'Retail Sale Id 2383',2310.00,0.00,0.00,3.00,312.00,'2023-01-15 16:18:17','',''),(2393,'1','306','1',1,'Retail Sale Id 2384',2310.00,0.00,0.00,3.00,312.00,'2023-01-15 16:19:19','',''),(2394,'1','306','1',1,'Retail Sale Id 2385',1501.50,0.00,0.00,1.95,202.80,'2023-01-15 16:20:19','',''),(2395,'1','306','1',1,'Retail Sale Id 2386',1501.50,0.00,0.00,1.95,202.80,'2023-01-15 16:21:17','',''),(2396,'1','306','1',1,'Retail Sale Id 2387',3003.00,0.00,0.00,3.90,405.60,'2023-01-15 16:25:33','',''),(2397,'1','306','1',1,'Retail Sale Id 2388',2302.30,0.00,0.00,2.99,310.96,'2023-01-15 16:38:34','',''),(2398,'1','306','1',1,'Retail Sale Id 2389',2310.00,0.00,0.00,3.00,312.00,'2023-01-15 16:41:58','',''),(2399,'1','306','1',1,'Retail Sale Id 2390',800.80,0.00,0.00,1.04,108.16,'2023-01-15 16:43:18','',''),(2400,'1','306','1',1,'Retail Sale Id 2391',1540.00,0.00,0.00,2.00,208.00,'2023-01-15 16:52:25','',''),(2401,'1','306','1',1,'Retail Sale Id 2392',4596.90,0.00,0.00,5.97,620.88,'2023-01-15 16:54:34','',''),(2402,'1','306','1',1,'Retail Sale Id 2393',1540.00,0.00,0.00,2.00,208.00,'2023-01-15 16:56:03','',''),(2403,'1','306','1',1,'Retail Sale Id 2394',3996.30,0.00,0.00,5.19,539.76,'2023-01-15 16:57:28','',''),(2404,'1','306','1',1,'Retail Sale Id 2395',3896.20,0.00,0.00,5.06,526.24,'2023-01-15 16:59:07','',''),(2405,'1','306','1',1,'Retail Sale Id 2396',800.80,0.00,0.00,1.04,108.16,'2023-01-15 17:01:16','',''),(2406,'1','306','1',1,'Retail Sale Id 2397',9501.80,0.00,0.00,12.34,1283.36,'2023-01-15 17:08:52','',''),(2407,'1','306','1',1,'Retail Sale Id 2398',3996.30,0.00,0.00,5.19,539.76,'2023-01-15 17:11:31','',''),(2408,'1','306','1',1,'Retail Sale Id 2399',3996.30,0.00,0.00,5.19,539.76,'2023-01-15 17:12:24','',''),(2409,'1','306','1',1,'Retail Sale Id 2400',3403.40,0.00,0.00,4.42,459.68,'2023-01-15 17:16:54','',''),(2410,'1','306','1',1,'Retail Sale Id 2401',800.80,0.00,0.00,1.04,108.16,'2023-01-15 17:18:48','',''),(2411,'1','306','1',1,'Retail Sale Id 2402',3996.30,0.00,0.00,5.19,539.76,'2023-01-15 17:23:18','',''),(2412,'1','306','1',1,'Retail Sale Id 2403',4997.30,0.00,0.00,6.49,674.96,'2023-01-15 17:26:42','',''),(2413,'1','306','1',1,'Retail Sale Id 2404',1540.00,0.00,0.00,2.00,208.00,'2023-01-15 17:38:22','',''),(2414,'1','306','1',1,'Retail Sale Id 2405',4620.00,0.00,0.00,6.00,624.00,'2023-01-15 17:42:09','',''),(2415,'1','306','1',1,'Retail Sale Id 2406',4620.00,0.00,0.00,6.00,624.00,'2023-01-15 17:47:38','',''),(2416,'1','306','1',1,'Retail Sale Id 2407',4620.00,0.00,0.00,6.00,624.00,'2023-01-15 17:49:15','',''),(2417,'1','306','1',1,'Retail Sale Id 2408',1501.50,0.00,0.00,1.95,202.80,'2023-01-15 17:51:31','',''),(2418,'1','306','1',1,'Retail Sale Id 2410',10002.30,0.00,0.00,12.99,1350.96,'2023-01-15 17:58:46','',''),(2419,'1','306','1',1,'Retail Sale Id 2411',1501.50,0.00,0.00,1.95,202.80,'2023-01-15 17:59:53','',''),(2420,'1','306','1',1,'Retail Sale Id 2412',10002.30,0.00,0.00,12.99,1350.96,'2023-01-15 18:12:46','',''),(2421,'1','306','1',1,'Retail Sale Id 2413',3996.30,0.00,0.00,5.19,539.76,'2023-01-15 18:13:47','',''),(2422,'1','306','1',1,'Return of Retail Sale Id 2411',0.00,1501.50,1.95,0.00,-202.80,'2023-01-15 18:25:35','',''),(2423,'1','306','1',1,'Return of Retail Sale Id 2354',0.00,16060.00,22.00,0.00,-1408.00,'2023-01-15 18:26:06','',''),(2424,'1','306','1',1,'Retail Sale Id 2414',15862.90,0.00,0.00,21.73,1390.72,'2023-01-15 18:27:24','',''),(2425,'1','306','1',1,'Retail Sale Id 2415',1131.90,0.00,0.00,1.47,152.88,'2023-01-15 18:28:21','',''),(2426,'1','306','1',1,'Retail Sale Id 2416',1501.50,0.00,0.00,1.95,202.80,'2023-01-16 07:20:04','',''),(2427,'1','306','1',1,'Retail Sale Id 2417',229220.00,0.00,0.00,314.00,20096.00,'2023-01-16 07:27:35','',''),(2428,'1','306','1',1,'Retail Sale Id 2419',2502.50,0.00,0.00,3.25,338.00,'2023-01-16 07:44:47','',''),(2429,'1','306','1',1,'Retail Sale Id 2421',4496.80,0.00,0.00,5.84,607.36,'2023-01-16 07:46:39','',''),(2430,'1','306','1',1,'Retail Sale Id 2422',2402.40,0.00,0.00,3.12,324.48,'2023-01-16 07:48:06','',''),(2431,'1','306','1',1,'Retail Sale Id 2423',800.80,0.00,0.00,1.04,108.16,'2023-01-16 07:50:19','',''),(2432,'1','306','1',1,'Retail Sale Id 2424',2310.00,0.00,0.00,3.00,312.00,'2023-01-16 07:51:38','',''),(2433,'1','306','1',1,'Retail Sale Id 2425',3650.00,0.00,0.00,5.00,320.00,'2023-01-16 07:53:36','',''),(2434,'1','306','1',1,'Retail Sale Id 2426',2310.00,0.00,0.00,3.00,312.00,'2023-01-16 07:57:40','',''),(2435,'1','306','1',1,'Retail Sale Id 2427',2502.50,0.00,0.00,3.25,338.00,'2023-01-16 08:06:05','',''),(2436,'1','306','1',1,'Retail Sale Id 2428',9501.80,0.00,0.00,12.34,1283.36,'2023-01-16 08:08:32','',''),(2437,'1','306','1',1,'Retail Sale Id 2429',3503.50,0.00,0.00,4.55,473.20,'2023-01-16 08:13:16','',''),(2438,'1','306','1',1,'Retail Sale Id 2430',4997.30,0.00,0.00,6.49,674.96,'2023-01-16 08:14:26','',''),(2439,'1','306','1',1,'Retail Sale Id 2431',4620.00,0.00,0.00,6.00,624.00,'2023-01-16 08:16:54','',''),(2440,'1','306','1',1,'Retail Sale Id 2432',4596.90,0.00,0.00,5.97,620.88,'2023-01-16 08:20:24','',''),(2441,'1','306','1',1,'Retail Sale Id 2433',9625.00,0.00,0.00,12.50,1300.00,'2023-01-16 08:22:27','',''),(2442,'1','306','1',1,'Retail Sale Id 2434',40150.00,0.00,0.00,55.00,3520.00,'2023-01-16 08:26:15','',''),(2443,'1','306','1',1,'Retail Sale Id 2435',2310.00,0.00,0.00,3.00,312.00,'2023-01-16 08:34:17','',''),(2444,'1','306','1',1,'Retail Sale Id 2436',27740.00,0.00,0.00,38.00,2432.00,'2023-01-16 08:37:43','',''),(2445,'1','306','1',1,'Retail Sale Id 2437',2302.30,0.00,0.00,2.99,310.96,'2023-01-16 08:39:14','',''),(2446,'1','306','1',1,'Retail Sale Id 2438',2302.30,0.00,0.00,2.99,310.96,'2023-01-16 08:40:43','',''),(2447,'1','306','1',1,'Retail Sale Id 2439',2302.30,0.00,0.00,2.99,310.96,'2023-01-16 08:50:14','',''),(2448,'1','306','1',1,'Retail Sale Id 2440',9601.90,0.00,0.00,12.47,1296.88,'2023-01-16 09:00:22','',''),(2449,'1','306','1',1,'Retail Sale Id 2441',9625.00,0.00,0.00,12.50,1300.00,'2023-01-16 09:01:01','',''),(2450,'1','306','1',1,'Retail Sale Id 2442',2310.00,0.00,0.00,3.00,312.00,'2023-01-16 09:02:30','',''),(2451,'1','306','1',1,'Retail Sale Id 2443',1540.00,0.00,0.00,2.00,208.00,'2023-01-16 09:06:36','',''),(2452,'1','306','1',1,'Retail Sale Id 2444',9301.60,0.00,0.00,12.08,1256.32,'2023-01-16 09:07:58','',''),(2453,'1','306','1',1,'Retail Sale Id 2445',3103.10,0.00,0.00,4.03,419.12,'2023-01-16 09:10:31','',''),(2454,'1','306','1',1,'Retail Sale Id 2446',2002.00,0.00,0.00,2.60,270.40,'2023-01-16 09:17:59','',''),(2455,'1','306','1',1,'Retail Sale Id 2447',1001.00,0.00,0.00,1.30,135.20,'2023-01-16 09:27:27','',''),(2456,'1','306','1',1,'Retail Sale Id 2448',7700.00,0.00,0.00,10.00,1040.00,'2023-01-16 09:30:16','',''),(2457,'1','306','1',1,'Retail Sale Id 2449',3996.30,0.00,0.00,5.19,539.76,'2023-01-16 09:31:22','',''),(2458,'1','306','1',1,'Retail Sale Id 2450',7700.00,0.00,0.00,10.00,1040.00,'2023-01-16 09:32:47','',''),(2459,'1','306','1',1,'Retail Sale Id 2452',4620.00,0.00,0.00,6.00,624.00,'2023-01-16 09:34:32','',''),(2460,'1','306','1',1,'Retail Sale Id 2453',2302.30,0.00,0.00,2.99,310.96,'2023-01-16 09:41:09','',''),(2461,'1','306','1',1,'Retail Sale Id 2454',4797.10,0.00,0.00,6.23,647.92,'2023-01-16 09:46:33','',''),(2462,'1','306','1',1,'Retail Sale Id 2455',2402.40,0.00,0.00,3.12,324.48,'2023-01-16 09:48:18','',''),(2463,'1','306','1',1,'Retail Sale Id 2456',4596.90,0.00,0.00,5.97,620.88,'2023-01-16 09:51:37','',''),(2464,'1','306','1',1,'Retail Sale Id 2457',43800.00,0.00,0.00,60.00,3840.00,'2023-01-16 10:06:35','',''),(2465,'1','306','1',1,'Retail Sale Id 2458',13140.00,0.00,0.00,18.00,1152.00,'2023-01-16 10:07:59','',''),(2466,'1','306','1',1,'Retail Sale Id 2459',1501.50,0.00,0.00,1.95,202.80,'2023-01-16 10:11:09','',''),(2467,'1','306','1',1,'Retail Sale Id 2460',1540.00,0.00,0.00,2.00,208.00,'2023-01-16 10:14:22','',''),(2468,'1','306','1',1,'Retail Sale Id 2461',4596.90,0.00,0.00,5.97,620.88,'2023-01-16 10:30:06','',''),(2469,'1','306','1',1,'Retail Sale Id 2462',9501.80,0.00,0.00,12.34,1283.36,'2023-01-16 10:37:11','',''),(2470,'1','306','1',1,'Retail Sale Id 2463',3080.00,0.00,0.00,4.00,416.00,'2023-01-16 10:38:56','',''),(2471,'1','306','1',1,'Retail Sale Id 2464',2302.30,0.00,0.00,2.99,310.96,'2023-01-16 10:40:18','',''),(2472,'1','306','1',1,'Retail Sale Id 2465',1501.50,0.00,0.00,1.95,202.80,'2023-01-16 10:41:35','',''),(2473,'1','306','1',1,'Retail Sale Id 2466',9301.60,0.00,0.00,12.08,1256.32,'2023-01-16 10:43:33','',''),(2474,'1','306','1',1,'Retail Sale Id 2467',3103.10,0.00,0.00,4.03,419.12,'2023-01-16 10:45:06','',''),(2475,'1','306','1',1,'Retail Sale Id 2468',3103.10,0.00,0.00,4.03,419.12,'2023-01-16 10:51:52','',''),(2476,'1','306','1',1,'Retail Sale Id 2469',3003.00,0.00,0.00,3.90,405.60,'2023-01-16 11:21:30','',''),(2477,'1','306','1',1,'Retail Sale Id 2470',2302.30,0.00,0.00,2.99,310.96,'2023-01-16 11:22:57','',''),(2478,'1','306','1',1,'Retail Sale Id 2471',3850.00,0.00,0.00,5.00,520.00,'2023-01-16 11:24:29','',''),(2479,'1','306','1',1,'Retail Sale Id 2472',3103.10,0.00,0.00,4.03,419.12,'2023-01-16 11:27:05','',''),(2480,'1','306','1',1,'Retail Sale Id 2473',4596.90,0.00,0.00,5.97,620.88,'2023-01-16 11:30:49','',''),(2481,'1','306','1',1,'Retail Sale Id 2474',6198.50,0.00,0.00,8.05,837.20,'2023-01-16 11:40:32','',''),(2482,'1','306','1',1,'Retail Sale Id 2475',1540.00,0.00,0.00,2.00,208.00,'2023-01-16 11:41:50','',''),(2483,'1','306','1',1,'Retail Sale Id 2476',1601.60,0.00,0.00,2.08,216.32,'2023-01-16 11:46:39','',''),(2484,'1','306','1',1,'Retail Sale Id 2477',2310.00,0.00,0.00,3.00,312.00,'2023-01-16 11:48:18','',''),(2485,'1','306','1',1,'Retail Sale Id 2478',4620.00,0.00,0.00,6.00,624.00,'2023-01-16 11:53:48','',''),(2486,'1','306','1',1,'Retail Sale Id 2479',2302.30,0.00,0.00,2.99,310.96,'2023-01-16 11:58:40','',''),(2487,'1','306','1',1,'Retail Sale Id 2480',3503.50,0.00,0.00,4.55,473.20,'2023-01-16 12:05:54','',''),(2488,'1','306','1',1,'Retail Sale Id 2482',1401.40,0.00,0.00,1.82,189.28,'2023-01-16 12:08:16','',''),(2489,'1','306','1',1,'Retail Sale Id 2483',2310.00,0.00,0.00,3.00,312.00,'2023-01-16 12:09:51','',''),(2490,'1','306','1',1,'Retail Sale Id 2483',2310.00,0.00,0.00,3.00,312.00,'2023-01-16 12:09:51','',''),(2491,'1','306','1',1,'Retail Sale Id 2484',14600.00,0.00,0.00,20.00,1280.00,'2023-01-16 12:12:00','',''),(2492,'1','306','1',1,'Retail Sale Id 2485',3080.00,0.00,0.00,4.00,416.00,'2023-01-16 12:18:53','',''),(2493,'1','306','1',1,'Retail Sale Id 2486',1540.00,0.00,0.00,2.00,208.00,'2023-01-16 12:20:18','',''),(2494,'1','306','1',1,'Retail Sale Id 2487',770.00,0.00,0.00,1.00,104.00,'2023-01-16 12:22:15','',''),(2495,'1','306','1',1,'Retail Sale Id 2488',7700.00,0.00,0.00,10.00,1040.00,'2023-01-16 12:24:05','',''),(2496,'1','306','1',1,'Retail Sale Id 2489',2310.00,0.00,0.00,3.00,312.00,'2023-01-16 12:30:41','',''),(2497,'1','306','1',1,'Retail Sale Id 2490',9501.80,0.00,0.00,12.34,1283.36,'2023-01-16 12:32:57','',''),(2498,'1','306','1',1,'Retail Sale Id 2491',800.80,0.00,0.00,1.04,108.16,'2023-01-16 12:37:35','',''),(2499,'1','306','1',1,'Retail Sale Id 2492',3080.00,0.00,0.00,4.00,416.00,'2023-01-16 12:39:31','',''),(2500,'1','306','1',1,'Retail Sale Id 2493',3996.30,0.00,0.00,5.19,539.76,'2023-01-16 12:49:20','',''),(2501,'1','306','1',1,'Retail Sale Id 2494',4620.00,0.00,0.00,6.00,624.00,'2023-01-16 12:59:27','',''),(2502,'1','306','1',1,'Retail Sale Id 2495',7300.00,0.00,0.00,10.00,640.00,'2023-01-16 13:11:19','',''),(2503,'1','306','1',1,'Retail Sale Id 2496',6930.00,0.00,0.00,9.00,936.00,'2023-01-16 13:12:27','',''),(2504,'1','306','1',1,'Retail Sale Id 2497',5497.80,0.00,0.00,7.14,742.56,'2023-01-16 13:15:15','',''),(2505,'1','306','1',1,'Retail Sale Id 2498',6570.00,0.00,0.00,9.00,576.00,'2023-01-16 13:17:13','',''),(2506,'1','306','1',1,'Retail Sale Id 2499',770.00,0.00,0.00,1.00,104.00,'2023-01-16 13:19:04','',''),(2507,'1','306','1',1,'Retail Sale Id 2501',1501.50,0.00,0.00,1.95,202.80,'2023-01-16 13:25:05','',''),(2508,'1','306','1',1,'Retail Sale Id 2502',2302.30,0.00,0.00,2.99,310.96,'2023-01-16 13:26:31','',''),(2509,'1','306','1',1,'Retail Sale Id 2503',3896.20,0.00,0.00,5.06,526.24,'2023-01-16 13:28:00','',''),(2510,'1','306','1',1,'Retail Sale Id 2504',800.80,0.00,0.00,1.04,108.16,'2023-01-16 13:31:07','',''),(2511,'1','306','1',1,'Retail Sale Id 2505',1540.00,0.00,0.00,2.00,208.00,'2023-01-16 13:32:31','',''),(2512,'1','306','1',1,'Retail Sale Id 2506',1501.50,0.00,0.00,1.95,202.80,'2023-01-16 13:33:26','',''),(2513,'1','306','1',1,'Retail Sale Id 2507',2402.40,0.00,0.00,3.12,324.48,'2023-01-16 13:44:27','',''),(2514,'1','306','1',1,'Retail Sale Id 2508',3103.10,0.00,0.00,4.03,419.12,'2023-01-16 13:47:27','',''),(2515,'1','306','1',1,'Retail Sale Id 2509',2248.40,0.00,0.00,2.92,303.68,'2023-01-16 13:48:59','',''),(2516,'1','306','1',1,'Retail Sale Id 2510',3003.00,0.00,0.00,3.90,405.60,'2023-01-16 13:53:59','',''),(2517,'1','306','1',1,'Retail Sale Id 2511',800.80,0.00,0.00,1.04,108.16,'2023-01-16 13:56:04','',''),(2518,'1','306','1',1,'Retail Sale Id 2512',4620.00,0.00,0.00,6.00,624.00,'2023-01-16 14:02:10','',''),(2519,'1','306','1',1,'Retail Sale Id 2513',2002.00,0.00,0.00,2.60,270.40,'2023-01-16 14:04:01','',''),(2520,'1','306','1',1,'Retail Sale Id 2514',3103.10,0.00,0.00,4.03,419.12,'2023-01-16 14:06:08','',''),(2521,'1','306','1',1,'Return of Retail Sale Id 2496',0.00,6930.00,9.00,0.00,-936.00,'2023-01-16 14:07:02','',''),(2522,'1','306','1',1,'Retail Sale Id 2515',800.80,0.00,0.00,1.04,108.16,'2023-01-16 14:10:38','',''),(2523,'1','306','1',1,'Retail Sale Id 2516',3080.00,0.00,0.00,4.00,416.00,'2023-01-16 14:22:41','',''),(2524,'1','306','1',1,'Retail Sale Id 2517',800.80,0.00,0.00,1.04,108.16,'2023-01-16 14:25:12','',''),(2525,'1','306','1',1,'Retail Sale Id 2518',1540.00,0.00,0.00,2.00,208.00,'2023-01-16 14:30:29','',''),(2526,'1','306','1',1,'Retail Sale Id 2519',2302.30,0.00,0.00,2.99,310.96,'2023-01-16 14:33:57','',''),(2527,'1','306','1',1,'Retail Sale Id 2520',2302.30,0.00,0.00,2.99,310.96,'2023-01-16 14:35:35','',''),(2528,'1','306','1',1,'Retail Sale Id 2521',2310.00,0.00,0.00,3.00,312.00,'2023-01-16 14:36:11','',''),(2529,'1','306','1',1,'Retail Sale Id 2522',2302.30,0.00,0.00,2.99,310.96,'2023-01-16 14:58:42','',''),(2530,'1','306','1',1,'Retail Sale Id 2523',9501.80,0.00,0.00,12.34,1283.36,'2023-01-16 15:00:27','',''),(2531,'1','306','1',1,'Retail Sale Id 2524',2310.00,0.00,0.00,3.00,312.00,'2023-01-16 15:01:34','',''),(2532,'1','306','1',1,'Retail Sale Id 2525',2302.30,0.00,0.00,2.99,310.96,'2023-01-16 15:03:24','',''),(2533,'1','306','1',1,'Retail Sale Id 2526',1516.90,0.00,0.00,1.97,204.88,'2023-01-16 15:17:55','',''),(2534,'1','306','1',1,'Retail Sale Id 2527',4496.80,0.00,0.00,5.84,607.36,'2023-01-16 15:19:59','',''),(2535,'1','306','1',1,'Retail Sale Id 2530',2002.00,0.00,0.00,2.60,270.40,'2023-01-16 15:21:48','',''),(2536,'1','306','1',1,'Retail Sale Id 2531',3103.10,0.00,0.00,4.03,419.12,'2023-01-16 15:22:51','',''),(2537,'1','306','1',1,'Retail Sale Id 2532',9501.80,0.00,0.00,12.34,1283.36,'2023-01-16 15:24:15','',''),(2538,'1','306','1',1,'Retail Sale Id 2533',1501.50,0.00,0.00,1.95,202.80,'2023-01-16 15:25:42','',''),(2539,'1','306','1',1,'Retail Sale Id 2534',3003.00,0.00,0.00,3.90,405.60,'2023-01-16 15:28:00','',''),(2540,'1','306','1',1,'Retail Sale Id 2535',1547.70,0.00,0.00,2.01,209.04,'2023-01-16 15:29:00','',''),(2541,'1','306','1',1,'Retail Sale Id 2536',2302.30,0.00,0.00,2.99,310.96,'2023-01-16 15:31:00','',''),(2542,'1','306','1',1,'Retail Sale Id 2537',800.80,0.00,0.00,1.04,108.16,'2023-01-16 15:36:17','',''),(2543,'1','306','1',1,'Retail Sale Id 2538',800.80,0.00,0.00,1.04,108.16,'2023-01-16 15:50:54','',''),(2544,'1','306','1',1,'Retail Sale Id 2539',3003.00,0.00,0.00,3.90,405.60,'2023-01-16 15:59:18','',''),(2545,'1','306','1',1,'Retail Sale Id 2540',3896.20,0.00,0.00,5.06,526.24,'2023-01-16 16:00:23','',''),(2546,'1','306','1',1,'Retail Sale Id 2541',3203.20,0.00,0.00,4.16,432.64,'2023-01-16 16:01:23','',''),(2547,'1','306','1',1,'Retail Sale Id 2542',2310.00,0.00,0.00,3.00,312.00,'2023-01-16 16:02:19','',''),(2548,'1','306','1',1,'Retail Sale Id 2543',7700.00,0.00,0.00,10.00,1040.00,'2023-01-16 16:04:23','',''),(2549,'1','306','1',1,'Retail Sale Id 2544',1001.00,0.00,0.00,1.30,135.20,'2023-01-16 16:07:46','',''),(2550,'1','306','1',1,'Retail Sale Id 2545',800.80,0.00,0.00,1.04,108.16,'2023-01-16 16:19:49','',''),(2551,'1','306','1',1,'Retail Sale Id 2546',3080.00,0.00,0.00,4.00,416.00,'2023-01-16 16:21:13','',''),(2552,'1','306','1',1,'Retail Sale Id 2547',3850.00,0.00,0.00,5.00,520.00,'2023-01-16 16:22:12','',''),(2553,'1','306','1',1,'Retail Sale Id 2548',800.80,0.00,0.00,1.04,108.16,'2023-01-16 16:23:16','',''),(2554,'1','306','1',1,'Retail Sale Id 2549',2002.00,0.00,0.00,2.60,270.40,'2023-01-16 16:24:11','',''),(2555,'1','306','1',1,'Retail Sale Id 2550',2302.30,0.00,0.00,2.99,310.96,'2023-01-16 16:25:31','',''),(2556,'1','306','1',1,'Retail Sale Id 2551',3850.00,0.00,0.00,5.00,520.00,'2023-01-16 16:26:27','',''),(2557,'1','306','1',1,'Retail Sale Id 2552',2310.00,0.00,0.00,3.00,312.00,'2023-01-16 16:28:09','',''),(2558,'1','306','1',1,'Retail Sale Id 2553',6999.30,0.00,0.00,9.09,945.36,'2023-01-16 16:30:21','',''),(2559,'1','306','1',1,'Retail Sale Id 2554',8500.80,0.00,0.00,11.04,1148.16,'2023-01-16 16:36:28','',''),(2560,'1','306','1',1,'Retail Sale Id 2555',3850.00,0.00,0.00,5.00,520.00,'2023-01-16 16:37:35','',''),(2561,'1','306','1',1,'Retail Sale Id 2556',1540.00,0.00,0.00,2.00,208.00,'2023-01-16 16:39:49','',''),(2562,'1','306','1',1,'Retail Sale Id 2557',2302.30,0.00,0.00,2.99,310.96,'2023-01-16 16:43:34','',''),(2563,'1','306','1',1,'Retail Sale Id 2558',9240.00,0.00,0.00,12.00,1248.00,'2023-01-16 16:46:26','',''),(2564,'1','306','1',1,'Retail Sale Id 2559',4620.00,0.00,0.00,6.00,624.00,'2023-01-16 16:48:03','',''),(2565,'1','306','1',1,'Retail Sale Id 2560',1801.80,0.00,0.00,2.34,243.36,'2023-01-16 16:49:32','',''),(2566,'1','306','1',1,'Retail Sale Id 2561',3080.00,0.00,0.00,4.00,416.00,'2023-01-16 16:50:58','',''),(2567,'1','306','1',1,'Retail Sale Id 2562',6160.00,0.00,0.00,8.00,832.00,'2023-01-16 16:52:09','',''),(2568,'1','306','1',1,'Retail Sale Id 2563',1501.50,0.00,0.00,1.95,202.80,'2023-01-16 16:53:31','',''),(2569,'1','306','1',1,'Retail Sale Id 2564',8500.80,0.00,0.00,11.04,1148.16,'2023-01-16 16:58:29','',''),(2570,'1','306','1',1,'Retail Sale Id 2565',1540.00,0.00,0.00,2.00,208.00,'2023-01-16 17:00:30','',''),(2571,'1','306','1',1,'Retail Sale Id 2566',2502.50,0.00,0.00,3.25,338.00,'2023-01-16 17:01:32','',''),(2572,'1','306','1',1,'Retail Sale Id 2568',4620.00,0.00,0.00,6.00,624.00,'2023-01-16 17:05:23','',''),(2573,'1','306','1',1,'Retail Sale Id 2569',1501.50,0.00,0.00,1.95,202.80,'2023-01-16 17:06:48','',''),(2574,'1','306','1',1,'Retail Sale Id 2570',1547.70,0.00,0.00,2.01,209.04,'2023-01-16 17:08:00','',''),(2575,'1','306','1',1,'Retail Sale Id 2571',4496.80,0.00,0.00,5.84,607.36,'2023-01-16 17:09:18','',''),(2576,'1','306','1',1,'Retail Sale Id 2572',6999.30,0.00,0.00,9.09,945.36,'2023-01-16 17:12:07','',''),(2577,'1','306','1',1,'Retail Sale Id 2573',4620.00,0.00,0.00,6.00,624.00,'2023-01-16 17:13:50','',''),(2578,'1','306','1',1,'Retail Sale Id 2574',2302.30,0.00,0.00,2.99,310.96,'2023-01-16 17:15:36','',''),(2579,'1','306','1',1,'Retail Sale Id 2575',24090.00,0.00,0.00,33.00,2112.00,'2023-01-16 17:16:59','',''),(2580,'1','306','1',1,'Retail Sale Id 2576',3896.20,0.00,0.00,5.06,526.24,'2023-01-16 17:18:10','',''),(2581,'1','306','1',1,'Retail Sale Id 2577',800.80,0.00,0.00,1.04,108.16,'2023-01-16 17:19:10','',''),(2582,'1','306','1',1,'Retail Sale Id 2578',3003.00,0.00,0.00,3.90,405.60,'2023-01-16 17:21:05','',''),(2583,'1','306','1',1,'Retail Sale Id 2579',2302.30,0.00,0.00,2.99,310.96,'2023-01-16 17:23:10','',''),(2584,'1','306','1',1,'Retail Sale Id 2581',2302.30,0.00,0.00,2.99,310.96,'2023-01-16 17:25:58','',''),(2585,'1','306','1',1,'Retail Sale Id 2582',3850.00,0.00,0.00,5.00,520.00,'2023-01-16 17:26:57','',''),(2586,'1','306','1',1,'Retail Sale Id 2584',2302.30,0.00,0.00,2.99,310.96,'2023-01-16 17:28:41','',''),(2587,'1','306','1',1,'Retail Sale Id 2585',4620.00,0.00,0.00,6.00,624.00,'2023-01-16 17:30:45','',''),(2588,'1','306','1',1,'Retail Sale Id 2586',2502.50,0.00,0.00,3.25,338.00,'2023-01-16 17:32:44','',''),(2589,'1','306','1',1,'Retail Sale Id 2587',3850.00,0.00,0.00,5.00,520.00,'2023-01-16 17:35:24','',''),(2590,'1','306','1',1,'Retail Sale Id 2588',1540.00,0.00,0.00,2.00,208.00,'2023-01-16 17:36:37','',''),(2591,'1','306','1',1,'Retail Sale Id 2589',3896.20,0.00,0.00,5.06,526.24,'2023-01-16 17:37:35','',''),(2592,'1','306','1',1,'Retail Sale Id 2590',3803.80,0.00,0.00,4.94,513.76,'2023-01-16 17:38:51','',''),(2593,'1','306','1',1,'Retail Sale Id 2591',4620.00,0.00,0.00,6.00,624.00,'2023-01-16 17:42:12','',''),(2594,'1','306','1',1,'Retail Sale Id 2592',9702.00,0.00,0.00,12.60,1310.40,'2023-01-16 17:43:32','',''),(2595,'1','306','1',1,'Retail Sale Id 2593',1501.50,0.00,0.00,1.95,202.80,'2023-01-16 17:44:38','',''),(2596,'1','306','1',1,'Retail Sale Id 2594',6160.00,0.00,0.00,8.00,832.00,'2023-01-16 17:46:47','',''),(2597,'1','306','1',1,'Retail Sale Id 2595',1501.50,0.00,0.00,1.95,202.80,'2023-01-16 17:48:48','',''),(2598,'1','306','1',1,'Retail Sale Id 2596',2002.00,0.00,0.00,2.60,270.40,'2023-01-16 17:49:42','',''),(2599,'1','306','1',1,'Retail Sale Id 2597',2310.00,0.00,0.00,3.00,312.00,'2023-01-16 17:51:49','',''),(2600,'1','306','1',1,'Retail Sale Id 2598',3003.00,0.00,0.00,3.90,405.60,'2023-01-16 17:58:28','',''),(2601,'1','306','1',1,'Retail Sale Id 2599',800.80,0.00,0.00,1.04,108.16,'2023-01-16 18:01:00','',''),(2602,'1','306','1',1,'Retail Sale Id 2600',1001.00,0.00,0.00,1.30,135.20,'2023-01-16 18:09:41','',''),(2603,'1','306','1',1,'Retail Sale Id 2601',2310.00,0.00,0.00,3.00,312.00,'2023-01-16 18:17:37','',''),(2604,'1','306','1',1,'Retail Sale Id 2603',1547.70,0.00,0.00,2.01,209.04,'2023-01-16 18:19:47','',''),(2605,'1','306','1',1,'Retail Sale Id 2605',3080.00,0.00,0.00,4.00,416.00,'2023-01-16 18:21:48','',''),(2606,'1','306','1',1,'Return of Retail Sale Id 2592',0.00,9702.00,12.60,0.00,-1310.40,'2023-01-16 18:32:57','',''),(2607,'1','306','1',1,'Return of Retail Sale Id 2589',0.00,3896.20,5.06,0.00,-526.24,'2023-01-16 18:33:21','',''),(2608,'1','306','1',1,'Return of Retail Sale Id 2498',0.00,6570.00,9.00,0.00,-576.00,'2023-01-16 18:33:51','',''),(2609,'1','306','1',1,'Return of Retail Sale Id 2591',0.00,4620.00,6.00,0.00,-624.00,'2023-01-16 18:34:34','',''),(2610,'1','306','1',1,'Return of Retail Sale Id 2495',0.00,7300.00,10.00,0.00,-640.00,'2023-01-16 18:34:55','',''),(2611,'1','306','1',1,'Retail Sale Id 2606',6570.00,0.00,0.00,9.00,576.00,'2023-01-16 18:44:16','',''),(2612,'1','306','1',1,'Retail Sale Id 2607',3388.00,0.00,0.00,4.40,457.60,'2023-01-16 18:45:12','',''),(2613,'1','306','1',1,'Retail Sale Id 2608',43800.00,0.00,0.00,60.00,3840.00,'2023-01-17 07:39:57','',''),(2614,'1','306','1',1,'Retail Sale Id 2609',3896.20,0.00,0.00,5.06,526.24,'2023-01-17 07:45:24','',''),(2615,'1','306','1',1,'Retail Sale Id 2610',770.00,0.00,0.00,1.00,104.00,'2023-01-17 08:00:26','',''),(2616,'1','306','1',1,'Retail Sale Id 2611',1547.70,0.00,0.00,2.01,209.04,'2023-01-17 08:08:43','',''),(2617,'1','306','1',1,'Retail Sale Id 2612',1301.30,0.00,0.00,1.69,175.76,'2023-01-17 08:11:15','',''),(2618,'1','306','1',1,'Retail Sale Id 2613',3850.00,0.00,0.00,5.00,520.00,'2023-01-17 08:17:06','',''),(2619,'1','306','1',1,'Retail Sale Id 2614',3850.00,0.00,0.00,5.00,520.00,'2023-01-17 08:19:10','',''),(2620,'1','306','1',1,'Retail Sale Id 2615',800.80,0.00,0.00,1.04,108.16,'2023-01-17 08:25:39','',''),(2621,'1','306','1',1,'Retail Sale Id 2616',2310.00,0.00,0.00,3.00,312.00,'2023-01-17 08:27:48','',''),(2622,'1','306','1',1,'Retail Sale Id 2617',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 08:29:43','',''),(2623,'1','306','1',1,'Retail Sale Id 2618',500.50,0.00,0.00,0.65,67.60,'2023-01-17 08:30:43','',''),(2624,'1','306','1',1,'Retail Sale Id 2619',1501.50,0.00,0.00,1.95,202.80,'2023-01-17 08:32:50','',''),(2625,'1','306','1',1,'Retail Sale Id 2620',9625.00,0.00,0.00,12.50,1300.00,'2023-01-17 08:36:24','',''),(2626,'1','306','1',1,'Retail Sale Id 2621',800.80,0.00,0.00,1.04,108.16,'2023-01-17 08:37:42','',''),(2627,'1','306','1',1,'Retail Sale Id 2622',6160.00,0.00,0.00,8.00,832.00,'2023-01-17 08:39:29','',''),(2628,'1','306','1',1,'Retail Sale Id 2623',1501.50,0.00,0.00,1.95,202.80,'2023-01-17 08:46:51','',''),(2629,'1','306','1',1,'Retail Sale Id 2624',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 08:48:17','',''),(2630,'1','306','1',1,'Retail Sale Id 2626',2310.00,0.00,0.00,3.00,312.00,'2023-01-17 09:06:55','',''),(2631,'1','306','1',1,'Retail Sale Id 2627',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 09:12:26','',''),(2632,'1','306','1',1,'Retail Sale Id 2628',2310.00,0.00,0.00,3.00,312.00,'2023-01-17 09:19:25','',''),(2633,'1','306','1',1,'Retail Sale Id 2629',9625.00,0.00,0.00,12.50,1300.00,'2023-01-17 09:21:12','',''),(2634,'1','306','1',1,'Retail Sale Id 2630',9501.80,0.00,0.00,12.34,1283.36,'2023-01-17 09:22:43','',''),(2635,'1','306','1',1,'Retail Sale Id 2631',1501.50,0.00,0.00,1.95,202.80,'2023-01-17 09:26:23','',''),(2636,'1','306','1',1,'Retail Sale Id 2632',746.90,0.00,0.00,0.97,100.88,'2023-01-17 09:27:45','',''),(2637,'1','306','1',1,'Retail Sale Id 2633',3850.00,0.00,0.00,5.00,520.00,'2023-01-17 09:34:00','',''),(2638,'1','306','1',1,'Retail Sale Id 2634',3850.00,0.00,0.00,5.00,520.00,'2023-01-17 09:36:03','',''),(2639,'1','306','1',1,'Retail Sale Id 2635',4697.00,0.00,0.00,6.10,634.40,'2023-01-17 09:38:00','',''),(2640,'1','306','1',1,'Retail Sale Id 2636',800.80,0.00,0.00,1.04,108.16,'2023-01-17 09:40:56','',''),(2641,'1','306','1',1,'Retail Sale Id 2637',20440.00,0.00,0.00,28.00,1792.00,'2023-01-17 09:43:23','',''),(2642,'1','306','1',1,'Retail Sale Id 2638',7700.00,0.00,0.00,10.00,1040.00,'2023-01-17 09:44:44','',''),(2643,'1','306','1',1,'Retail Sale Id 2639',3896.20,0.00,0.00,5.06,526.24,'2023-01-17 09:46:33','',''),(2644,'1','306','1',1,'Retail Sale Id 2640',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 09:47:30','',''),(2645,'1','306','1',1,'Retail Sale Id 2641',3003.00,0.00,0.00,3.90,405.60,'2023-01-17 09:50:10','',''),(2646,'1','306','1',1,'Retail Sale Id 2642',2310.00,0.00,0.00,3.00,312.00,'2023-01-17 09:51:28','',''),(2647,'1','306','1',1,'Retail Sale Id 2643',1501.50,0.00,0.00,1.95,202.80,'2023-01-17 09:53:45','',''),(2648,'1','306','1',1,'Retail Sale Id 2644',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 09:55:32','',''),(2649,'1','306','1',1,'Retail Sale Id 2645',3896.20,0.00,0.00,5.06,526.24,'2023-01-17 09:56:39','',''),(2650,'1','306','1',1,'Retail Sale Id 2646',7700.00,0.00,0.00,10.00,1040.00,'2023-01-17 09:58:09','',''),(2651,'1','306','1',1,'Retail Sale Id 2647',11550.00,0.00,0.00,15.00,1560.00,'2023-01-17 10:01:50','',''),(2652,'1','306','1',1,'Retail Sale Id 2648',1540.00,0.00,0.00,2.00,208.00,'2023-01-17 10:05:28','',''),(2653,'1','306','1',1,'Retail Sale Id 2648',1540.00,0.00,0.00,2.00,208.00,'2023-01-17 10:05:28','',''),(2654,'1','306','1',1,'Retail Sale Id 2649',1501.50,0.00,0.00,1.95,202.80,'2023-01-17 10:11:07','',''),(2655,'1','306','1',1,'Retail Sale Id 2650',1540.00,0.00,0.00,2.00,208.00,'2023-01-17 10:13:30','',''),(2656,'1','306','1',1,'Retail Sale Id 2651',4697.00,0.00,0.00,6.10,634.40,'2023-01-17 10:16:05','',''),(2657,'1','306','1',1,'Retail Sale Id 2652',1501.50,0.00,0.00,1.95,202.80,'2023-01-17 10:19:48','',''),(2658,'1','306','1',1,'Retail Sale Id 2653',4496.80,0.00,0.00,5.84,607.36,'2023-01-17 10:24:19','',''),(2659,'1','306','1',1,'Retail Sale Id 2654',1540.00,0.00,0.00,2.00,208.00,'2023-01-17 10:27:38','',''),(2660,'1','306','1',1,'Retail Sale Id 2655',3080.00,0.00,0.00,4.00,416.00,'2023-01-17 10:29:17','',''),(2661,'1','306','1',1,'Retail Sale Id 2656',2310.00,0.00,0.00,3.00,312.00,'2023-01-17 10:31:11','',''),(2662,'1','306','1',1,'Retail Sale Id 2657',2310.00,0.00,0.00,3.00,312.00,'2023-01-17 10:34:43','',''),(2663,'1','306','1',1,'Retail Sale Id 2658',1540.00,0.00,0.00,2.00,208.00,'2023-01-17 10:35:53','',''),(2664,'1','306','1',1,'Retail Sale Id 2660',2310.00,0.00,0.00,3.00,312.00,'2023-01-17 10:38:07','',''),(2665,'1','306','1',1,'Retail Sale Id 2661',4697.00,0.00,0.00,6.10,634.40,'2023-01-17 10:39:14','',''),(2666,'1','306','1',1,'Retail Sale Id 2662',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 10:40:30','',''),(2667,'1','306','1',1,'Retail Sale Id 2663',43800.00,0.00,0.00,60.00,3840.00,'2023-01-17 10:47:51','',''),(2668,'1','306','1',1,'Retail Sale Id 2664',18250.00,0.00,0.00,25.00,1600.00,'2023-01-17 10:49:47','',''),(2669,'1','306','1',1,'Retail Sale Id 2665',3003.00,0.00,0.00,3.90,405.60,'2023-01-17 10:52:41','',''),(2670,'1','306','1',1,'Retail Sale Id 2666',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 10:57:10','',''),(2671,'1','306','1',1,'Retail Sale Id 2667',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 11:13:51','',''),(2672,'1','306','1',1,'Retail Sale Id 2668',73000.00,0.00,0.00,100.00,6400.00,'2023-01-17 11:17:52','',''),(2673,'1','306','1',1,'Retail Sale Id 2669',9702.00,0.00,0.00,12.60,1310.40,'2023-01-17 11:35:27','',''),(2674,'1','306','1',1,'Retail Sale Id 2670',9240.00,0.00,0.00,12.00,1248.00,'2023-01-17 11:42:01','',''),(2675,'1','306','1',1,'Retail Sale Id 2671',3850.00,0.00,0.00,5.00,520.00,'2023-01-17 11:43:33','',''),(2676,'1','306','1',1,'Retail Sale Id 2672',2310.00,0.00,0.00,3.00,312.00,'2023-01-17 11:44:57','',''),(2677,'1','306','1',1,'Retail Sale Id 2673',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 11:46:03','',''),(2678,'1','306','1',1,'Retail Sale Id 2674',3080.00,0.00,0.00,4.00,416.00,'2023-01-17 11:49:01','',''),(2679,'1','306','1',1,'Retail Sale Id 2675',2002.00,0.00,0.00,2.60,270.40,'2023-01-17 11:51:15','',''),(2680,'1','306','1',1,'Retail Sale Id 2676',8500.80,0.00,0.00,11.04,1148.16,'2023-01-17 11:53:28','',''),(2681,'1','306','1',1,'Retail Sale Id 2677',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 11:59:01','',''),(2682,'1','306','1',1,'Retail Sale Id 2678',3850.00,0.00,0.00,5.00,520.00,'2023-01-17 12:01:54','',''),(2683,'1','306','1',1,'Retail Sale Id 2679',4697.00,0.00,0.00,6.10,634.40,'2023-01-17 12:07:17','',''),(2684,'1','306','1',1,'Retail Sale Id 2680',3080.00,0.00,0.00,4.00,416.00,'2023-01-17 12:08:42','',''),(2685,'1','306','1',1,'Retail Sale Id 2681',3850.00,0.00,0.00,5.00,520.00,'2023-01-17 12:09:53','',''),(2686,'1','306','1',1,'Retail Sale Id 2682',4620.00,0.00,0.00,6.00,624.00,'2023-01-17 12:21:36','',''),(2687,'1','306','1',1,'Retail Sale Id 2683',8500.80,0.00,0.00,11.04,1148.16,'2023-01-17 12:23:19','',''),(2688,'1','306','1',1,'Retail Sale Id 2684',2310.00,0.00,0.00,3.00,312.00,'2023-01-17 12:24:33','',''),(2689,'1','306','1',1,'Retail Sale Id 2685',3103.10,0.00,0.00,4.03,419.12,'2023-01-17 12:27:08','',''),(2690,'1','306','1',1,'Retail Sale Id 2686',102200.00,0.00,0.00,140.00,8960.00,'2023-01-17 12:30:13','',''),(2691,'1','306','1',1,'Retail Sale Id 2687',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 12:31:07','',''),(2692,'1','306','1',1,'Retail Sale Id 2688',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 12:32:11','',''),(2693,'1','306','1',1,'Retail Sale Id 2689',3103.10,0.00,0.00,4.03,419.12,'2023-01-17 12:33:30','',''),(2694,'1','306','1',1,'Retail Sale Id 2690',3103.10,0.00,0.00,4.03,419.12,'2023-01-17 12:34:36','',''),(2695,'1','306','1',1,'Retail Sale Id 2691',3003.00,0.00,0.00,3.90,405.60,'2023-01-17 12:36:40','',''),(2696,'1','306','1',1,'Retail Sale Id 2692',1001.00,0.00,0.00,1.30,135.20,'2023-01-17 12:37:30','',''),(2697,'1','306','1',1,'Retail Sale Id 2693',3850.00,0.00,0.00,5.00,520.00,'2023-01-17 12:43:12','',''),(2698,'1','306','1',1,'Retail Sale Id 2694',1547.70,0.00,0.00,2.01,209.04,'2023-01-17 12:45:17','',''),(2699,'1','306','1',1,'Retail Sale Id 2695',3850.00,0.00,0.00,5.00,520.00,'2023-01-17 12:46:28','',''),(2700,'1','306','1',1,'Retail Sale Id 2696',1460.00,0.00,0.00,2.00,128.00,'2023-01-17 12:48:16','',''),(2701,'1','306','1',1,'Retail Sale Id 2697',4697.00,0.00,0.00,6.10,634.40,'2023-01-17 12:53:48','',''),(2702,'1','306','1',1,'Retail Sale Id 2698',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 13:01:18','',''),(2703,'1','306','1',1,'Retail Sale Id 2699',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 13:02:32','',''),(2704,'1','306','1',1,'Retail Sale Id 2700',800.80,0.00,0.00,1.04,108.16,'2023-01-17 13:03:43','',''),(2705,'1','306','1',1,'Retail Sale Id 2701',1601.60,0.00,0.00,2.08,216.32,'2023-01-17 13:07:35','',''),(2706,'1','306','1',1,'Retail Sale Id 2702',3850.00,0.00,0.00,5.00,520.00,'2023-01-17 13:24:56','',''),(2707,'1','306','1',1,'Retail Sale Id 2703',800.80,0.00,0.00,1.04,108.16,'2023-01-17 13:26:22','',''),(2708,'1','306','1',1,'Retail Sale Id 2704',1540.00,0.00,0.00,2.00,208.00,'2023-01-17 13:34:50','',''),(2709,'1','306','1',1,'Retail Sale Id 2705',1001.00,0.00,0.00,1.30,135.20,'2023-01-17 13:35:31','',''),(2710,'1','306','1',1,'Retail Sale Id 2706',800.80,0.00,0.00,1.04,108.16,'2023-01-17 13:38:40','',''),(2711,'1','306','1',1,'Retail Sale Id 2707',4620.00,0.00,0.00,6.00,624.00,'2023-01-17 13:46:40','',''),(2712,'1','306','1',1,'Retail Sale Id 2708',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 13:47:48','',''),(2713,'1','306','1',1,'Retail Sale Id 2709',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 13:48:47','',''),(2714,'1','306','1',1,'Retail Sale Id 2710',1547.70,0.00,0.00,2.01,209.04,'2023-01-17 13:57:31','',''),(2715,'1','306','1',1,'Retail Sale Id 2711',4620.00,0.00,0.00,6.00,624.00,'2023-01-17 13:58:33','',''),(2716,'1','306','1',1,'Retail Sale Id 2712',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 14:00:34','',''),(2717,'1','306','1',1,'Retail Sale Id 2713',9501.80,0.00,0.00,12.34,1283.36,'2023-01-17 14:05:04','',''),(2718,'1','306','1',1,'Retail Sale Id 2714',3103.10,0.00,0.00,4.03,419.12,'2023-01-17 14:06:26','',''),(2719,'1','306','1',1,'Retail Sale Id 2715',800.80,0.00,0.00,1.04,108.16,'2023-01-17 14:14:22','',''),(2720,'1','306','1',1,'Retail Sale Id 2716',4620.00,0.00,0.00,6.00,624.00,'2023-01-17 14:25:47','',''),(2721,'1','306','1',1,'Retail Sale Id 2717',4596.90,0.00,0.00,5.97,620.88,'2023-01-17 14:35:25','',''),(2722,'1','306','1',1,'Retail Sale Id 2718',1501.50,0.00,0.00,1.95,202.80,'2023-01-17 14:37:01','',''),(2723,'1','306','1',1,'Retail Sale Id 2719',1540.00,0.00,0.00,2.00,208.00,'2023-01-17 14:39:21','',''),(2724,'1','306','1',1,'Retail Sale Id 2720',2310.00,0.00,0.00,3.00,312.00,'2023-01-17 14:44:00','',''),(2725,'1','306','1',1,'Retail Sale Id 2721',4620.00,0.00,0.00,6.00,624.00,'2023-01-17 14:45:51','',''),(2726,'1','306','1',1,'Retail Sale Id 2722',2310.00,0.00,0.00,3.00,312.00,'2023-01-17 14:56:31','',''),(2727,'1','306','1',1,'Retail Sale Id 2723',9240.00,0.00,0.00,12.00,1248.00,'2023-01-17 14:58:52','',''),(2728,'1','306','1',1,'Retail Sale Id 2724',3996.30,0.00,0.00,5.19,539.76,'2023-01-17 15:02:53','',''),(2729,'1','306','1',1,'Retail Sale Id 2725',3003.00,0.00,0.00,3.90,405.60,'2023-01-17 15:04:04','',''),(2730,'1','306','1',1,'Retail Sale Id 2726',2502.50,0.00,0.00,3.25,338.00,'2023-01-17 15:05:12','',''),(2731,'1','306','1',1,'Return of Retail Sale Id 2725',0.00,3003.00,3.90,0.00,-405.60,'2023-01-17 15:05:39','',''),(2732,'1','306','1',1,'Retail Sale Id 2729',1501.50,0.00,0.00,1.95,202.80,'2023-01-17 15:06:41','',''),(2733,'1','306','1',1,'Retail Sale Id 2730',2310.00,0.00,0.00,3.00,312.00,'2023-01-17 15:10:05','',''),(2734,'1','306','1',1,'Return of Retail Sale Id 2724',0.00,3996.30,5.19,0.00,-539.76,'2023-01-17 15:10:07','',''),(2735,'1','306','1',1,'Retail Sale Id 2731',3850.00,0.00,0.00,5.00,520.00,'2023-01-17 15:13:17','',''),(2736,'1','306','1',1,'Retail Sale Id 2732',1501.50,0.00,0.00,1.95,202.80,'2023-01-17 15:21:26','',''),(2737,'1','306','1',1,'Retail Sale Id 2733',8500.80,0.00,0.00,11.04,1148.16,'2023-01-17 15:24:27','',''),(2738,'1','306','1',1,'Retail Sale Id 2734',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 15:25:47','',''),(2739,'1','306','1',1,'Retail Sale Id 2735',3850.00,0.00,0.00,5.00,520.00,'2023-01-17 15:31:38','',''),(2740,'1','306','1',1,'Retail Sale Id 2736',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 15:32:26','',''),(2741,'1','306','1',1,'Retail Sale Id 2737',4620.00,0.00,0.00,6.00,624.00,'2023-01-17 15:33:48','',''),(2742,'1','306','1',1,'Retail Sale Id 2737',9625.00,0.00,0.00,12.50,1300.00,'2023-01-17 15:33:48','',''),(2743,'1','306','1',1,'Retail Sale Id 2738',4496.80,0.00,0.00,5.84,607.36,'2023-01-17 15:42:50','',''),(2744,'1','306','1',1,'Retail Sale Id 2739',9247.70,0.00,0.00,12.01,1249.04,'2023-01-17 15:44:31','',''),(2745,'1','306','1',1,'Retail Sale Id 2740',3850.00,0.00,0.00,5.00,520.00,'2023-01-17 15:46:05','',''),(2746,'1','306','1',1,'Retail Sale Id 2741',6160.00,0.00,0.00,8.00,832.00,'2023-01-17 15:48:41','',''),(2747,'1','306','1',1,'Retail Sale Id 2742',6160.00,0.00,0.00,8.00,832.00,'2023-01-17 15:51:00','',''),(2748,'1','306','1',1,'Retail Sale Id 2743',4620.00,0.00,0.00,6.00,624.00,'2023-01-17 15:53:02','',''),(2749,'1','306','1',1,'Retail Sale Id 2743',9625.00,0.00,0.00,12.50,1300.00,'2023-01-17 15:53:02','',''),(2750,'1','306','1',1,'Retail Sale Id 2744',5998.30,0.00,0.00,7.79,810.16,'2023-01-17 15:53:55','',''),(2751,'1','306','1',1,'Retail Sale Id 2745',800.80,0.00,0.00,1.04,108.16,'2023-01-17 15:55:20','',''),(2752,'1','306','1',1,'Retail Sale Id 2746',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 15:56:33','',''),(2753,'1','306','1',1,'Retail Sale Id 2747',2310.00,0.00,0.00,3.00,312.00,'2023-01-17 15:58:48','',''),(2754,'1','306','1',1,'Retail Sale Id 2748',1501.50,0.00,0.00,1.95,202.80,'2023-01-17 16:03:31','',''),(2755,'1','306','1',1,'Retail Sale Id 2749',1501.50,0.00,0.00,1.95,202.80,'2023-01-17 16:04:44','',''),(2756,'1','306','1',1,'Retail Sale Id 2750',2310.00,0.00,0.00,3.00,312.00,'2023-01-17 16:05:40','',''),(2757,'1','306','1',1,'Retail Sale Id 2751',2310.00,0.00,0.00,3.00,312.00,'2023-01-17 16:07:56','',''),(2758,'1','306','1',1,'Retail Sale Id 2752',29930.00,0.00,0.00,41.00,2624.00,'2023-01-17 16:12:10','',''),(2759,'1','306','1',1,'Retail Sale Id 2753',1001.00,0.00,0.00,1.30,135.20,'2023-01-17 16:12:52','',''),(2760,'1','306','1',1,'Retail Sale Id 2754',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 16:13:52','',''),(2761,'1','306','1',1,'Retail Sale Id 2755',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 16:17:16','',''),(2762,'1','306','1',1,'Retail Sale Id 2756',1501.50,0.00,0.00,1.95,202.80,'2023-01-17 16:18:59','',''),(2763,'1','306','1',1,'Retail Sale Id 2757',1501.50,0.00,0.00,1.95,202.80,'2023-01-17 16:22:51','',''),(2764,'1','306','1',1,'Retail Sale Id 2758',2310.00,0.00,0.00,3.00,312.00,'2023-01-17 16:28:40','',''),(2765,'1','306','1',1,'Retail Sale Id 2759',4620.00,0.00,0.00,6.00,624.00,'2023-01-17 16:34:09','',''),(2766,'1','306','1',1,'Retail Sale Id 2760',3080.00,0.00,0.00,4.00,416.00,'2023-01-17 16:35:11','',''),(2767,'1','306','1',1,'Retail Sale Id 2761',800.80,0.00,0.00,1.04,108.16,'2023-01-17 16:37:00','',''),(2768,'1','306','1',1,'Retail Sale Id 2762',4620.00,0.00,0.00,6.00,624.00,'2023-01-17 16:39:18','',''),(2769,'1','306','1',1,'Retail Sale Id 2763',21900.00,0.00,0.00,30.00,1920.00,'2023-01-17 16:41:53','',''),(2770,'1','306','1',1,'Retail Sale Id 2764',5840.00,0.00,0.00,8.00,512.00,'2023-01-17 16:45:08','',''),(2771,'1','306','1',1,'Retail Sale Id 2765',1547.70,0.00,0.00,2.01,209.04,'2023-01-17 16:46:01','',''),(2772,'1','306','1',1,'Retail Sale Id 2766',800.80,0.00,0.00,1.04,108.16,'2023-01-17 16:47:17','',''),(2773,'1','306','1',1,'Retail Sale Id 2767',800.80,0.00,0.00,1.04,108.16,'2023-01-17 16:48:02','',''),(2774,'1','306','1',1,'Retail Sale Id 2768',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 16:54:21','',''),(2775,'1','306','1',1,'Retail Sale Id 2769',2310.00,0.00,0.00,3.00,312.00,'2023-01-17 16:59:04','',''),(2776,'1','306','1',1,'Retail Sale Id 2770',4620.00,0.00,0.00,6.00,624.00,'2023-01-17 17:00:17','',''),(2777,'1','306','1',1,'Retail Sale Id 2771',1540.00,0.00,0.00,2.00,208.00,'2023-01-17 17:01:22','',''),(2778,'1','306','1',1,'Retail Sale Id 2772',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 17:03:45','',''),(2779,'1','306','1',1,'Retail Sale Id 2773',1501.50,0.00,0.00,1.95,202.80,'2023-01-17 17:04:59','',''),(2780,'1','306','1',1,'Return of Retail Sale Id 2773',0.00,1501.50,1.95,0.00,-202.80,'2023-01-17 17:07:44','',''),(2781,'1','306','1',1,'Retail Sale Id 2774',1540.00,0.00,0.00,2.00,208.00,'2023-01-17 17:07:54','',''),(2782,'1','306','1',1,'Retail Sale Id 2775',3850.00,0.00,0.00,5.00,520.00,'2023-01-17 17:12:06','',''),(2783,'1','306','1',1,'Retail Sale Id 2776',800.80,0.00,0.00,1.04,108.16,'2023-01-17 17:15:52','',''),(2784,'1','306','1',1,'Retail Sale Id 2777',3803.80,0.00,0.00,4.94,513.76,'2023-01-17 17:18:34','',''),(2785,'1','306','1',1,'Retail Sale Id 2778',1501.50,0.00,0.00,1.95,202.80,'2023-01-17 17:20:57','',''),(2786,'1','306','1',1,'Retail Sale Id 2779',4620.00,0.00,0.00,6.00,624.00,'2023-01-17 17:25:28','',''),(2787,'1','306','1',1,'Retail Sale Id 2780',3103.10,0.00,0.00,4.03,419.12,'2023-01-17 17:27:03','',''),(2788,'1','306','1',1,'Retail Sale Id 2781',800.80,0.00,0.00,1.04,108.16,'2023-01-17 17:27:58','',''),(2789,'1','306','1',1,'Retail Sale Id 2782',800.80,0.00,0.00,1.04,108.16,'2023-01-17 17:29:36','',''),(2790,'1','306','1',1,'Retail Sale Id 2783',3850.00,0.00,0.00,5.00,520.00,'2023-01-17 17:33:05','',''),(2791,'1','306','1',1,'Retail Sale Id 2785',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 17:34:12','',''),(2792,'1','306','1',1,'Retail Sale Id 2786',1501.50,0.00,0.00,1.95,202.80,'2023-01-17 17:35:22','',''),(2793,'1','306','1',1,'Retail Sale Id 2787',2302.30,0.00,0.00,2.99,310.96,'2023-01-17 17:36:16','',''),(2794,'1','306','1',1,'Retail Sale Id 2788',3003.00,0.00,0.00,3.90,405.60,'2023-01-17 17:37:15','',''),(2795,'1','306','1',1,'Retail Sale Id 2789',43800.00,0.00,0.00,60.00,3840.00,'2023-01-17 17:39:56','',''),(2796,'1','306','1',1,'Retail Sale Id 2790',1501.50,0.00,0.00,1.95,202.80,'2023-01-17 17:41:16','',''),(2797,'1','306','1',1,'Retail Sale Id 2792',800.80,0.00,0.00,1.04,108.16,'2023-01-17 17:49:30','',''),(2798,'1','306','1',1,'Retail Sale Id 2793',3080.00,0.00,0.00,4.00,416.00,'2023-01-17 17:52:20','',''),(2799,'1','306','1',1,'Retail Sale Id 2793',3080.00,0.00,0.00,4.00,416.00,'2023-01-17 17:52:20','',''),(2800,'1','306','1',1,'Retail Sale Id 2794',800.80,0.00,0.00,1.04,108.16,'2023-01-17 17:53:28','',''),(2801,'1','306','1',1,'Retail Sale Id 2795',1301.30,0.00,0.00,1.69,175.76,'2023-01-17 17:55:22','',''),(2802,'1','306','1',1,'Retail Sale Id 2796',1601.60,0.00,0.00,2.08,216.32,'2023-01-17 17:56:55','',''),(2803,'1','306','1',1,'Return of Retail Sale Id 2787',0.00,2302.30,2.99,0.00,-310.96,'2023-01-17 17:58:33','',''),(2804,'1','306','1',1,'Retail Sale Id 2797',3996.30,0.00,0.00,5.19,539.76,'2023-01-17 18:02:46','',''),(2805,'1','306','1',1,'Retail Sale Id 2798',800.80,0.00,0.00,1.04,108.16,'2023-01-17 18:07:53','',''),(2806,'1','306','1',1,'Retail Sale Id 2799',1540.00,0.00,0.00,2.00,208.00,'2023-01-17 18:18:23','',''),(2807,'1','306','1',1,'Retail Sale Id 2800',9702.00,0.00,0.00,12.60,1310.40,'2023-01-17 18:22:53','',''),(2808,'1','306','1',1,'Return of Retail Sale Id 2800',0.00,9702.00,12.60,0.00,-1310.40,'2023-01-17 18:35:30','',''),(2809,'1','306','1',1,'Return of Retail Sale Id 2696',0.00,1460.00,2.00,0.00,-128.00,'2023-01-17 18:36:24','',''),(2810,'1','306','1',1,'Retail Sale Id 2801',1452.70,0.00,0.00,1.99,127.36,'2023-01-17 18:38:27','',''),(2811,'1','306','1',1,'Retail Sale Id 2802',9709.70,0.00,0.00,12.61,1311.44,'2023-01-17 18:39:45','',''),(2812,'1','306','1',1,'Retail Sale Id 2803',4620.00,0.00,0.00,6.00,624.00,'2023-01-18 07:06:19','',''),(2813,'1','306','1',1,'Retail Sale Id 2804',1547.70,0.00,0.00,2.01,209.04,'2023-01-18 07:43:54','',''),(2814,'1','306','1',1,'Retail Sale Id 2805',9702.00,0.00,0.00,12.60,1310.40,'2023-01-18 07:53:32','',''),(2815,'1','306','1',1,'Retail Sale Id 2806',3996.30,0.00,0.00,5.19,539.76,'2023-01-18 08:00:03','',''),(2816,'1','306','1',1,'Retail Sale Id 2807',9001.30,0.00,0.00,11.69,1215.76,'2023-01-18 08:01:16','',''),(2817,'1','306','1',1,'Retail Sale Id 2808',1501.50,0.00,0.00,1.95,202.80,'2023-01-18 08:05:35','',''),(2818,'1','306','1',1,'Retail Sale Id 2809',3996.30,0.00,0.00,5.19,539.76,'2023-01-18 08:07:45','',''),(2819,'1','306','1',1,'Retail Sale Id 2810',9501.80,0.00,0.00,12.34,1283.36,'2023-01-18 08:12:42','',''),(2820,'1','306','1',1,'Retail Sale Id 2811',3203.20,0.00,0.00,4.16,432.64,'2023-01-18 08:20:44','',''),(2821,'1','306','1',1,'Retail Sale Id 2812',9501.80,0.00,0.00,12.34,1283.36,'2023-01-18 08:23:55','',''),(2822,'1','306','1',1,'Retail Sale Id 2813',800.80,0.00,0.00,1.04,108.16,'2023-01-18 08:25:37','',''),(2823,'1','306','1',1,'Retail Sale Id 2814',3850.00,0.00,0.00,5.00,520.00,'2023-01-18 08:26:53','',''),(2824,'1','306','1',1,'Retail Sale Id 2815',2302.30,0.00,0.00,2.99,310.96,'2023-01-18 08:27:55','',''),(2825,'1','306','1',1,'Retail Sale Id 2816',9501.80,0.00,0.00,12.34,1283.36,'2023-01-18 08:29:41','',''),(2826,'1','306','1',1,'Retail Sale Id 2818',3103.10,0.00,0.00,4.03,419.12,'2023-01-18 08:31:25','',''),(2827,'1','306','1',1,'Retail Sale Id 2819',4620.00,0.00,0.00,6.00,624.00,'2023-01-18 08:32:54','',''),(2828,'1','306','1',1,'Retail Sale Id 2820',4697.00,0.00,0.00,6.10,634.40,'2023-01-18 08:35:09','',''),(2829,'1','306','1',1,'Retail Sale Id 2821',3996.30,0.00,0.00,5.19,539.76,'2023-01-18 08:36:48','',''),(2830,'1','306','1',1,'Retail Sale Id 2822',13870.00,0.00,0.00,19.00,1216.00,'2023-01-18 08:38:40','',''),(2831,'1','306','1',1,'Retail Sale Id 2823',4620.00,0.00,0.00,6.00,624.00,'2023-01-18 08:40:56','',''),(2832,'1','306','1',1,'Retail Sale Id 2824',746.90,0.00,0.00,0.97,100.88,'2023-01-18 08:49:03','',''),(2833,'1','306','1',1,'Retail Sale Id 2825',2002.00,0.00,0.00,2.60,270.40,'2023-01-18 08:52:26','',''),(2834,'1','306','1',1,'Retail Sale Id 2826',2502.50,0.00,0.00,3.25,338.00,'2023-01-18 08:59:44','',''),(2835,'1','306','1',1,'Retail Sale Id 2828',3072.30,0.00,0.00,3.99,414.96,'2023-01-18 09:02:34','',''),(2836,'1','306','1',1,'Retail Sale Id 2829',9625.00,0.00,0.00,12.50,1300.00,'2023-01-18 09:04:59','',''),(2837,'1','306','1',1,'Retail Sale Id 2830',4235.00,0.00,0.00,5.50,572.00,'2023-01-18 09:06:51','',''),(2838,'1','306','1',1,'Retail Sale Id 2831',1601.60,0.00,0.00,2.08,216.32,'2023-01-18 09:08:04','',''),(2839,'1','306','1',1,'Retail Sale Id 2832',2302.30,0.00,0.00,2.99,310.96,'2023-01-18 09:14:01','',''),(2840,'1','306','1',1,'Retail Sale Id 2833',2502.50,0.00,0.00,3.25,338.00,'2023-01-18 09:15:31','',''),(2841,'1','306','1',1,'Retail Sale Id 2834',1501.50,0.00,0.00,1.95,202.80,'2023-01-18 09:16:42','',''),(2842,'1','306','1',1,'Retail Sale Id 2835',1301.30,0.00,0.00,1.69,175.76,'2023-01-18 09:23:47','',''),(2843,'1','306','1',1,'Retail Sale Id 2836',1501.50,0.00,0.00,1.95,202.80,'2023-01-18 09:29:27','',''),(2844,'1','306','1',1,'Retail Sale Id 2837',9247.70,0.00,0.00,12.01,1249.04,'2023-01-18 09:34:16','',''),(2845,'1','306','1',1,'Retail Sale Id 2838',3080.00,0.00,0.00,4.00,416.00,'2023-01-18 09:37:14','',''),(2846,'1','306','1',1,'Retail Sale Id 2839',3996.30,0.00,0.00,5.19,539.76,'2023-01-18 09:41:06','',''),(2847,'1','306','1',1,'Retail Sale Id 2840',1501.50,0.00,0.00,1.95,202.80,'2023-01-18 09:44:13','',''),(2848,'1','306','1',1,'Retail Sale Id 2841',2002.00,0.00,0.00,2.60,270.40,'2023-01-18 09:45:08','',''),(2849,'1','306','1',1,'Retail Sale Id 2842',3850.00,0.00,0.00,5.00,520.00,'2023-01-18 09:47:50','',''),(2850,'1','306','1',1,'Retail Sale Id 2843',9617.30,0.00,0.00,12.49,1298.96,'2023-01-18 09:53:31','',''),(2851,'1','306','1',1,'Retail Sale Id 2844',2310.00,0.00,0.00,3.00,312.00,'2023-01-18 09:58:31','',''),(2852,'1','306','1',1,'Retail Sale Id 2845',1501.50,0.00,0.00,1.95,202.80,'2023-01-18 09:59:33','',''),(2853,'1','306','1',1,'Retail Sale Id 2846',1501.50,0.00,0.00,1.95,202.80,'2023-01-18 10:02:13','',''),(2854,'1','306','1',1,'Retail Sale Id 2847',2302.30,0.00,0.00,2.99,310.96,'2023-01-18 10:13:41','',''),(2855,'1','306','1',1,'Retail Sale Id 2848',800.80,0.00,0.00,1.04,108.16,'2023-01-18 10:19:56','',''),(2856,'1','306','1',1,'Retail Sale Id 2849',9501.80,0.00,0.00,12.34,1283.36,'2023-01-18 10:22:02','',''),(2857,'1','306','1',1,'Retail Sale Id 2850',109500.00,0.00,0.00,150.00,9600.00,'2023-01-18 10:25:03','',''),(2858,'1','306','1',1,'Retail Sale Id 2851',1501.50,0.00,0.00,1.95,202.80,'2023-01-18 10:34:05','',''),(2859,'1','306','1',1,'Retail Sale Id 2852',2310.00,0.00,0.00,3.00,312.00,'2023-01-18 10:35:14','',''),(2860,'1','306','1',1,'Retail Sale Id 2853',2310.00,0.00,0.00,3.00,312.00,'2023-01-18 10:36:04','',''),(2861,'1','306','1',1,'Retail Sale Id 2854',33580.00,0.00,0.00,46.00,2944.00,'2023-01-18 10:38:12','',''),(2862,'1','306','1',1,'Retail Sale Id 2855',2310.00,0.00,0.00,3.00,312.00,'2023-01-18 10:39:18','',''),(2863,'1','306','1',1,'Retail Sale Id 2856',1547.70,0.00,0.00,2.01,209.04,'2023-01-18 10:40:27','',''),(2864,'1','306','1',1,'Retail Sale Id 2857',800.80,0.00,0.00,1.04,108.16,'2023-01-18 10:45:20','',''),(2865,'1','306','1',1,'Retail Sale Id 2858',9625.00,0.00,0.00,12.50,1300.00,'2023-01-18 10:46:48','',''),(2866,'1','306','1',1,'Retail Sale Id 2859',3080.00,0.00,0.00,4.00,416.00,'2023-01-18 10:52:55','',''),(2867,'1','306','1',1,'Retail Sale Id 2860',7700.00,0.00,0.00,10.00,1040.00,'2023-01-18 10:54:19','',''),(2868,'1','306','1',1,'Retail Sale Id 2861',800.80,0.00,0.00,1.04,108.16,'2023-01-18 10:55:54','',''),(2869,'1','306','1',1,'Retail Sale Id 2862',3850.00,0.00,0.00,5.00,520.00,'2023-01-18 10:57:03','',''),(2870,'1','306','1',1,'Retail Sale Id 2863',35770.00,0.00,0.00,49.00,3136.00,'2023-01-18 11:06:04','',''),(2871,'1','306','1',1,'Retail Sale Id 2864',14600.00,0.00,0.00,20.00,1280.00,'2023-01-18 11:10:49','',''),(2872,'1','306','1',1,'Retail Sale Id 2865',4620.00,0.00,0.00,6.00,624.00,'2023-01-18 11:13:38','',''),(2873,'1','306','1',1,'Retail Sale Id 2866',9501.80,0.00,0.00,12.34,1283.36,'2023-01-18 11:15:26','',''),(2874,'1','306','1',1,'Retail Sale Id 2867',7300.00,0.00,0.00,10.00,640.00,'2023-01-18 11:16:51','',''),(2875,'1','306','1',1,'Retail Sale Id 2868',1540.00,0.00,0.00,2.00,208.00,'2023-01-18 11:19:55','',''),(2876,'1','306','1',1,'Retail Sale Id 2868',4620.00,0.00,0.00,6.00,624.00,'2023-01-18 11:19:55','',''),(2877,'1','306','1',1,'Retail Sale Id 2869',4496.80,0.00,0.00,5.84,607.36,'2023-01-18 11:21:34','',''),(2878,'1','306','1',1,'Retail Sale Id 2870',4697.00,0.00,0.00,6.10,634.40,'2023-01-18 11:22:50','',''),(2879,'1','306','1',1,'Retail Sale Id 2871',9802.10,0.00,0.00,12.73,1323.92,'2023-01-18 11:24:24','',''),(2880,'1','306','1',1,'Retail Sale Id 2872',4620.00,0.00,0.00,6.00,624.00,'2023-01-18 11:25:44','',''),(2881,'1','306','1',1,'Retail Sale Id 2873',9802.10,0.00,0.00,12.73,1323.92,'2023-01-18 11:27:52','',''),(2882,'1','306','1',1,'Retail Sale Id 2874',3049.20,0.00,0.00,3.96,411.84,'2023-01-18 11:30:01','',''),(2883,'1','306','1',1,'Retail Sale Id 2875',4697.00,0.00,0.00,6.10,634.40,'2023-01-18 11:31:11','',''),(2884,'1','306','1',1,'Retail Sale Id 2876',1501.50,0.00,0.00,1.95,202.80,'2023-01-18 11:32:46','',''),(2885,'1','306','1',1,'Retail Sale Id 2877',2002.00,0.00,0.00,2.60,270.40,'2023-01-18 11:36:22','',''),(2886,'1','306','1',1,'Retail Sale Id 2878',2310.00,0.00,0.00,3.00,312.00,'2023-01-18 11:40:47','',''),(2887,'1','306','1',1,'Retail Sale Id 2879',4697.00,0.00,0.00,6.10,634.40,'2023-01-18 11:42:15','',''),(2888,'1','306','1',1,'Retail Sale Id 2880',3996.30,0.00,0.00,5.19,539.76,'2023-01-18 11:43:23','',''),(2889,'1','306','1',1,'Retail Sale Id 2881',3003.00,0.00,0.00,3.90,405.60,'2023-01-18 11:45:52','',''),(2890,'1','306','1',1,'Retail Sale Id 2882',2302.30,0.00,0.00,2.99,310.96,'2023-01-18 11:53:07','',''),(2891,'1','306','1',1,'Retail Sale Id 2883',800.80,0.00,0.00,1.04,108.16,'2023-01-18 11:57:32','',''),(2892,'1','306','1',1,'Retail Sale Id 2884',2310.00,0.00,0.00,3.00,312.00,'2023-01-18 12:01:12','',''),(2893,'1','306','1',1,'Retail Sale Id 2885',4496.80,0.00,0.00,5.84,607.36,'2023-01-18 12:08:14','',''),(2894,'1','306','1',1,'Retail Sale Id 2886',9201.50,0.00,0.00,11.95,1242.80,'2023-01-18 12:14:06','',''),(2895,'1','306','1',1,'Retail Sale Id 2887',2302.30,0.00,0.00,2.99,310.96,'2023-01-18 12:15:56','',''),(2896,'1','306','1',1,'Retail Sale Id 2888',3850.00,0.00,0.00,5.00,520.00,'2023-01-18 12:17:40','',''),(2897,'1','306','1',1,'Retail Sale Id 2889',800.80,0.00,0.00,1.04,108.16,'2023-01-18 12:24:16','',''),(2898,'1','306','1',1,'Retail Sale Id 2890',2310.00,0.00,0.00,3.00,312.00,'2023-01-18 12:28:36','',''),(2899,'1','306','1',1,'Retail Sale Id 2891',2310.00,0.00,0.00,3.00,312.00,'2023-01-18 12:30:40','',''),(2900,'1','306','1',1,'Retail Sale Id 2892',4496.80,0.00,0.00,5.84,607.36,'2023-01-18 12:41:50','',''),(2901,'1','306','1',1,'Retail Sale Id 2893',1501.50,0.00,0.00,1.95,202.80,'2023-01-18 12:45:22','',''),(2902,'1','306','1',1,'Retail Sale Id 2894',3850.00,0.00,0.00,5.00,520.00,'2023-01-18 12:47:31','',''),(2903,'1','306','1',1,'Retail Sale Id 2895',2302.30,0.00,0.00,2.99,310.96,'2023-01-18 12:48:48','',''),(2904,'1','306','1',1,'Retail Sale Id 2896',4997.30,0.00,0.00,6.49,674.96,'2023-01-18 12:54:07','',''),(2905,'1','306','1',1,'Retail Sale Id 2897',1001.00,0.00,0.00,1.30,135.20,'2023-01-18 13:01:02','',''),(2906,'1','306','1',1,'Retail Sale Id 2898',9501.80,0.00,0.00,12.34,1283.36,'2023-01-18 13:04:49','',''),(2907,'1','306','1',1,'Retail Sale Id 2900',1501.50,0.00,0.00,1.95,202.80,'2023-01-18 13:06:37','',''),(2908,'1','306','1',1,'Retail Sale Id 2901',1501.50,0.00,0.00,1.95,202.80,'2023-01-18 13:07:38','',''),(2909,'1','306','1',1,'Retail Sale Id 2902',2202.20,0.00,0.00,2.86,297.44,'2023-01-18 13:08:37','',''),(2910,'1','306','1',1,'Retail Sale Id 2903',3003.00,0.00,0.00,3.90,405.60,'2023-01-18 13:28:50','',''),(2911,'1','306','1',1,'Retail Sale Id 2904',4620.00,0.00,0.00,6.00,624.00,'2023-01-18 13:30:12','',''),(2912,'1','306','1',1,'Retail Sale Id 2905',2310.00,0.00,0.00,3.00,312.00,'2023-01-18 13:31:04','',''),(2913,'1','306','1',1,'Retail Sale Id 2906',2002.00,0.00,0.00,2.60,270.40,'2023-01-18 13:34:49','',''),(2914,'1','306','1',1,'Retail Sale Id 2907',2502.50,0.00,0.00,3.25,338.00,'2023-01-18 13:49:57','',''),(2915,'1','306','1',1,'Retail Sale Id 2908',3850.00,0.00,0.00,5.00,520.00,'2023-01-18 13:53:50','',''),(2916,'1','306','1',1,'Retail Sale Id 2908',11550.00,0.00,0.00,15.00,1560.00,'2023-01-18 13:53:50','',''),(2917,'1','306','1',1,'Retail Sale Id 2909',800.80,0.00,0.00,1.04,108.16,'2023-01-18 13:55:00','',''),(2918,'1','306','1',1,'Retail Sale Id 2910',3003.00,0.00,0.00,3.90,405.60,'2023-01-18 14:01:46','',''),(2919,'1','306','1',1,'Retail Sale Id 2911',2310.00,0.00,0.00,3.00,312.00,'2023-01-18 14:16:35','',''),(2920,'1','306','1',1,'Retail Sale Id 2911',3850.00,0.00,0.00,5.00,520.00,'2023-01-18 14:16:35','',''),(2921,'1','306','1',1,'Retail Sale Id 2912',2302.30,0.00,0.00,2.99,310.96,'2023-01-18 14:22:14','',''),(2922,'1','306','1',1,'Retail Sale Id 2913',4650.80,0.00,0.00,6.04,628.16,'2023-01-18 14:27:08','',''),(2923,'1','306','1',1,'Retail Sale Id 2914',3996.30,0.00,0.00,5.19,539.76,'2023-01-18 14:29:35','',''),(2924,'1','306','1',1,'Retail Sale Id 2915',9240.00,0.00,0.00,12.00,1248.00,'2023-01-18 14:32:11','',''),(2925,'1','306','1',1,'Retail Sale Id 2916',3103.10,0.00,0.00,4.03,419.12,'2023-01-18 14:33:06','',''),(2926,'1','306','1',1,'Retail Sale Id 2917',3080.00,0.00,0.00,4.00,416.00,'2023-01-18 14:43:46','',''),(2927,'1','306','1',1,'Retail Sale Id 2918',2310.00,0.00,0.00,3.00,312.00,'2023-01-18 14:47:21','',''),(2928,'1','306','1',1,'Retail Sale Id 2919',2302.30,0.00,0.00,2.99,310.96,'2023-01-18 14:47:48','',''),(2929,'1','306','1',1,'Retail Sale Id 2920',5005.00,0.00,0.00,6.50,676.00,'2023-01-18 14:50:53','',''),(2930,'1','306','1',1,'Retail Sale Id 2921',3719.10,0.00,0.00,4.83,502.32,'2023-01-18 15:01:43','',''),(2931,'1','306','1',1,'Retail Sale Id 2922',2310.00,0.00,0.00,3.00,312.00,'2023-01-18 15:10:42','',''),(2932,'1','306','1',1,'Retail Sale Id 2923',4596.90,0.00,0.00,5.97,620.88,'2023-01-18 15:12:24','',''),(2933,'1','306','1',1,'Retail Sale Id 2924',4596.90,0.00,0.00,5.97,620.88,'2023-01-18 15:25:47','',''),(2934,'1','306','1',1,'Retail Sale Id 2925',4620.00,0.00,0.00,6.00,624.00,'2023-01-18 15:27:27','',''),(2935,'1','306','1',1,'Retail Sale Id 2926',800.80,0.00,0.00,1.04,108.16,'2023-01-18 15:37:44','',''),(2936,'1','306','1',1,'Retail Sale Id 2927',2502.50,0.00,0.00,3.25,338.00,'2023-01-18 15:45:55','',''),(2937,'1','306','1',1,'Retail Sale Id 2928',4596.90,0.00,0.00,5.97,620.88,'2023-01-18 15:52:01','',''),(2938,'1','306','1',1,'Retail Sale Id 2929',4620.00,0.00,0.00,6.00,624.00,'2023-01-18 15:53:30','',''),(2939,'1','306','1',1,'Retail Sale Id 2930',3850.00,0.00,0.00,5.00,520.00,'2023-01-18 15:54:38','',''),(2940,'1','306','1',1,'Retail Sale Id 2932',9501.80,0.00,0.00,12.34,1283.36,'2023-01-18 16:06:07','',''),(2941,'1','306','1',1,'Retail Sale Id 2933',9001.30,0.00,0.00,11.69,1215.76,'2023-01-18 16:07:31','',''),(2942,'1','306','1',1,'Retail Sale Id 2934',2302.30,0.00,0.00,2.99,310.96,'2023-01-18 16:11:39','',''),(2943,'1','306','1',1,'Retail Sale Id 2935',4496.80,0.00,0.00,5.84,607.36,'2023-01-18 16:14:36','',''),(2944,'1','306','1',1,'Retail Sale Id 2936',2202.20,0.00,0.00,2.86,297.44,'2023-01-18 16:20:42','',''),(2945,'1','306','1',1,'Retail Sale Id 2937',4620.00,0.00,0.00,6.00,624.00,'2023-01-18 16:22:32','',''),(2946,'1','306','1',1,'Retail Sale Id 2938',4620.00,0.00,0.00,6.00,624.00,'2023-01-18 16:24:10','',''),(2947,'1','306','1',1,'Retail Sale Id 2939',800.80,0.00,0.00,1.04,108.16,'2023-01-18 16:25:06','',''),(2948,'1','306','1',1,'Retail Sale Id 2940',3850.00,0.00,0.00,5.00,520.00,'2023-01-18 16:29:45','',''),(2949,'1','306','1',1,'Retail Sale Id 2941',18980.00,0.00,0.00,26.00,1664.00,'2023-01-18 16:55:25','',''),(2950,'1','306','1',1,'Retail Sale Id 2942',800.80,0.00,0.00,1.04,108.16,'2023-01-18 16:58:34','',''),(2951,'1','306','1',1,'Retail Sale Id 2943',800.80,0.00,0.00,1.04,108.16,'2023-01-18 17:08:21','',''),(2952,'1','306','1',1,'Retail Sale Id 2944',3080.00,0.00,0.00,4.00,416.00,'2023-01-18 17:14:07','',''),(2953,'1','306','1',1,'Retail Sale Id 2945',1540.00,0.00,0.00,2.00,208.00,'2023-01-18 17:21:58','',''),(2954,'1','306','1',1,'Retail Sale Id 2946',1540.00,0.00,0.00,2.00,208.00,'2023-01-18 17:25:45','',''),(2955,'1','306','1',1,'Retail Sale Id 2947',36500.00,0.00,0.00,50.00,3200.00,'2023-01-18 17:29:09','',''),(2956,'1','306','1',1,'Retail Sale Id 2948',2302.30,0.00,0.00,2.99,310.96,'2023-01-18 17:39:28','',''),(2957,'1','306','1',1,'Retail Sale Id 2949',2310.00,0.00,0.00,3.00,312.00,'2023-01-18 17:45:12','',''),(2958,'1','306','1',1,'Retail Sale Id 2950',2310.00,0.00,0.00,3.00,312.00,'2023-01-18 17:45:52','',''),(2959,'1','306','1',1,'Retail Sale Id 2951',800.80,0.00,0.00,1.04,108.16,'2023-01-18 17:47:22','',''),(2960,'1','306','1',1,'Retail Sale Id 2953',2310.00,0.00,0.00,3.00,312.00,'2023-01-18 17:49:38','',''),(2961,'1','306','1',1,'Retail Sale Id 2954',14600.00,0.00,0.00,20.00,1280.00,'2023-01-18 17:53:05','',''),(2962,'1','306','1',1,'Retail Sale Id 2955',1501.50,0.00,0.00,1.95,202.80,'2023-01-18 17:57:11','',''),(2963,'1','306','1',1,'Retail Sale Id 2956',3080.00,0.00,0.00,4.00,416.00,'2023-01-18 18:04:13','',''),(2964,'1','306','1',1,'Retail Sale Id 2958',4997.30,0.00,0.00,6.49,674.96,'2023-01-18 18:16:32','',''),(2965,'1','306','1',1,'Return of Retail Sale Id 2954',0.00,14600.00,20.00,0.00,-1280.00,'2023-01-18 18:28:38','',''),(2966,'1','306','1',1,'Return of Retail Sale Id 2958',0.00,4997.30,6.49,0.00,-674.96,'2023-01-18 18:29:10','',''),(2967,'1','306','1',1,'Retail Sale Id 2959',12410.00,0.00,0.00,17.00,1088.00,'2023-01-18 18:30:39','',''),(2968,'1','306','1',1,'Retail Sale Id 2960',5105.10,0.00,0.00,6.63,689.52,'2023-01-18 18:31:43','',''),(2969,'1','306','1',1,'Retail Sale Id 2961',1501.50,0.00,0.00,1.95,202.80,'2023-01-19 07:29:43','',''),(2970,'1','306','1',1,'Retail Sale Id 2962',2002.00,0.00,0.00,2.60,270.40,'2023-01-19 07:49:28','',''),(2971,'1','306','1',1,'Retail Sale Id 2963',10002.30,0.00,0.00,12.99,1350.96,'2023-01-19 08:02:23','',''),(2972,'1','306','1',1,'Retail Sale Id 2964',3996.30,0.00,0.00,5.19,539.76,'2023-01-19 08:03:33','',''),(2973,'1','306','1',1,'Retail Sale Id 2965',3103.10,0.00,0.00,4.03,419.12,'2023-01-19 08:11:23','',''),(2974,'1','306','1',1,'Retail Sale Id 2966',1501.50,0.00,0.00,1.95,202.80,'2023-01-19 08:14:12','',''),(2975,'1','306','1',1,'Retail Sale Id 2967',10002.30,0.00,0.00,12.99,1350.96,'2023-01-19 08:15:31','',''),(2976,'1','306','1',1,'Retail Sale Id 2968',800.80,0.00,0.00,1.04,108.16,'2023-01-19 08:17:02','',''),(2977,'1','306','1',1,'Retail Sale Id 2969',4620.00,0.00,0.00,6.00,624.00,'2023-01-19 08:21:04','',''),(2978,'1','306','1',1,'Retail Sale Id 2971',4697.00,0.00,0.00,6.10,634.40,'2023-01-19 08:25:50','',''),(2979,'1','306','1',1,'Retail Sale Id 2972',3103.10,0.00,0.00,4.03,419.12,'2023-01-19 08:28:15','',''),(2980,'1','306','1',1,'Retail Sale Id 2973',6198.50,0.00,0.00,8.05,837.20,'2023-01-19 08:33:55','',''),(2981,'1','306','1',1,'Retail Sale Id 2974',4697.00,0.00,0.00,6.10,634.40,'2023-01-19 08:39:10','',''),(2982,'1','306','1',1,'Retail Sale Id 2975',3103.10,0.00,0.00,4.03,419.12,'2023-01-19 08:40:07','',''),(2983,'1','306','1',1,'Retail Sale Id 2977',3103.10,0.00,0.00,4.03,419.12,'2023-01-19 08:41:41','',''),(2984,'1','306','1',1,'Retail Sale Id 2978',10220.00,0.00,0.00,14.00,896.00,'2023-01-19 08:42:55','',''),(2985,'1','306','1',1,'Retail Sale Id 2979',2310.00,0.00,0.00,3.00,312.00,'2023-01-19 08:45:26','',''),(2986,'1','306','1',1,'Retail Sale Id 2980',2302.30,0.00,0.00,2.99,310.96,'2023-01-19 08:49:21','',''),(2987,'1','306','1',1,'Retail Sale Id 2981',2310.00,0.00,0.00,3.00,312.00,'2023-01-19 08:51:09','',''),(2988,'1','306','1',1,'Retail Sale Id 2982',3850.00,0.00,0.00,5.00,520.00,'2023-01-19 08:52:43','',''),(2989,'1','306','1',1,'Retail Sale Id 2983',2302.30,0.00,0.00,2.99,310.96,'2023-01-19 09:05:33','',''),(2990,'1','306','1',1,'Retail Sale Id 2984',800.80,0.00,0.00,1.04,108.16,'2023-01-19 09:09:26','',''),(2991,'1','306','1',1,'Retail Sale Id 2985',800.80,0.00,0.00,1.04,108.16,'2023-01-19 09:13:33','',''),(2992,'1','306','1',1,'Retail Sale Id 2986',3850.00,0.00,0.00,5.00,520.00,'2023-01-19 09:20:24','',''),(2993,'1','306','1',1,'Retail Sale Id 2987',1501.50,0.00,0.00,1.95,202.80,'2023-01-19 09:21:20','',''),(2994,'1','306','1',1,'Retail Sale Id 2988',2002.00,0.00,0.00,2.60,270.40,'2023-01-19 09:22:09','',''),(2995,'1','306','1',1,'Return of Retail Sale Id 2987',0.00,1501.50,1.95,0.00,-202.80,'2023-01-19 09:23:07','',''),(2996,'1','306','1',1,'Retail Sale Id 2990',2317.70,0.00,0.00,3.01,313.04,'2023-01-19 09:29:16','',''),(2997,'1','306','1',1,'Retail Sale Id 2991',2002.00,0.00,0.00,2.60,270.40,'2023-01-19 09:33:25','',''),(2998,'1','306','1',1,'Retail Sale Id 2992',746.90,0.00,0.00,0.97,100.88,'2023-01-19 09:34:40','',''),(2999,'1','306','1',1,'Retail Sale Id 2993',9702.00,0.00,0.00,12.60,1310.40,'2023-01-19 09:41:08','',''),(3000,'1','306','1',1,'Retail Sale Id 2994',42340.00,0.00,0.00,58.00,3712.00,'2023-01-19 09:42:28','',''),(3001,'1','306','1',1,'Retail Sale Id 2995',2502.50,0.00,0.00,3.25,338.00,'2023-01-19 09:46:25','',''),(3002,'1','306','1',1,'Retail Sale Id 2996',1501.50,0.00,0.00,1.95,202.80,'2023-01-19 09:53:17','',''),(3003,'1','306','1',1,'Retail Sale Id 2997',9702.00,0.00,0.00,12.60,1310.40,'2023-01-19 09:55:18','',''),(3004,'1','306','1',1,'Retail Sale Id 3002',4697.00,0.00,0.00,6.10,634.40,'2023-01-19 09:58:19','',''),(3005,'1','306','1',1,'Retail Sale Id 3003',4550.70,0.00,0.00,5.91,614.64,'2023-01-19 10:00:08','',''),(3006,'1','306','1',1,'Retail Sale Id 3004',770.00,0.00,0.00,1.00,104.00,'2023-01-19 10:01:42','',''),(3007,'1','306','1',1,'Retail Sale Id 3006',2310.00,0.00,0.00,3.00,312.00,'2023-01-19 10:04:32','',''),(3008,'1','306','1',1,'Retail Sale Id 3007',9702.00,0.00,0.00,12.60,1310.40,'2023-01-19 10:06:01','',''),(3009,'1','306','1',1,'Retail Sale Id 3008',2402.40,0.00,0.00,3.12,324.48,'2023-01-19 10:12:24','',''),(3010,'1','306','1',1,'Retail Sale Id 3009',2310.00,0.00,0.00,3.00,312.00,'2023-01-19 10:21:24','',''),(3011,'1','306','1',1,'Retail Sale Id 3010',3080.00,0.00,0.00,4.00,416.00,'2023-01-19 10:22:54','',''),(3012,'1','306','1',1,'Retail Sale Id 3011',24090.00,0.00,0.00,33.00,2112.00,'2023-01-19 10:24:17','',''),(3013,'1','306','1',1,'Retail Sale Id 3012',4997.30,0.00,0.00,6.49,674.96,'2023-01-19 10:26:01','',''),(3014,'1','306','1',1,'Retail Sale Id 3013',2302.30,0.00,0.00,2.99,310.96,'2023-01-19 10:32:43','',''),(3015,'1','306','1',1,'Retail Sale Id 3014',4620.00,0.00,0.00,6.00,624.00,'2023-01-19 10:34:44','',''),(3016,'1','306','1',1,'Retail Sale Id 3015',1547.70,0.00,0.00,2.01,209.04,'2023-01-19 10:45:17','',''),(3017,'1','306','1',1,'Retail Sale Id 3016',2310.00,0.00,0.00,3.00,312.00,'2023-01-19 10:46:34','',''),(3018,'1','306','1',1,'Retail Sale Id 3017',3003.00,0.00,0.00,3.90,405.60,'2023-01-19 10:52:52','',''),(3019,'1','306','1',1,'Retail Sale Id 3018',3080.00,0.00,0.00,4.00,416.00,'2023-01-19 10:53:38','',''),(3020,'1','306','1',1,'Return of Retail Sale Id 3017',0.00,3003.00,3.90,0.00,-405.60,'2023-01-19 10:54:20','',''),(3021,'1','306','1',1,'Retail Sale Id 3019',2310.00,0.00,0.00,3.00,312.00,'2023-01-19 10:57:39','',''),(3022,'1','306','1',1,'Retail Sale Id 3019',3850.00,0.00,0.00,5.00,520.00,'2023-01-19 10:57:39','',''),(3023,'1','306','1',1,'Retail Sale Id 3020',8000.30,0.00,0.00,10.39,1080.56,'2023-01-19 10:59:08','',''),(3024,'1','306','1',1,'Retail Sale Id 3021',2310.00,0.00,0.00,3.00,312.00,'2023-01-19 11:00:43','',''),(3025,'1','306','1',1,'Retail Sale Id 3022',4620.00,0.00,0.00,6.00,624.00,'2023-01-19 11:02:53','',''),(3026,'1','306','1',1,'Retail Sale Id 3023',2310.00,0.00,0.00,3.00,312.00,'2023-01-19 11:04:14','',''),(3027,'1','306','1',1,'Retail Sale Id 3024',1601.60,0.00,0.00,2.08,216.32,'2023-01-19 11:10:22','',''),(3028,'1','306','1',1,'Retail Sale Id 3025',14600.00,0.00,0.00,20.00,1280.00,'2023-01-19 11:15:50','',''),(3029,'1','306','1',1,'Retail Sale Id 3026',1540.00,0.00,0.00,2.00,208.00,'2023-01-19 11:18:05','',''),(3030,'1','306','1',1,'Retail Sale Id 3028',4596.90,0.00,0.00,5.97,620.88,'2023-01-19 11:23:44','',''),(3031,'1','306','1',1,'Retail Sale Id 3030',4650.80,0.00,0.00,6.04,628.16,'2023-01-19 11:28:13','',''),(3032,'1','306','1',1,'Retail Sale Id 3031',2302.30,0.00,0.00,2.99,310.96,'2023-01-19 11:31:30','',''),(3033,'1','306','1',1,'Retail Sale Id 3032',2310.00,0.00,0.00,3.00,312.00,'2023-01-19 11:32:45','',''),(3034,'1','306','1',1,'Retail Sale Id 3033',4620.00,0.00,0.00,6.00,624.00,'2023-01-19 11:40:46','',''),(3035,'1','306','1',1,'Retail Sale Id 3034',2310.00,0.00,0.00,3.00,312.00,'2023-01-19 11:45:07','',''),(3036,'1','306','1',1,'Retail Sale Id 3035',3080.00,0.00,0.00,4.00,416.00,'2023-01-19 11:50:56','',''),(3037,'1','306','1',1,'Retail Sale Id 3036',1547.70,0.00,0.00,2.01,209.04,'2023-01-19 11:54:47','',''),(3038,'1','306','1',1,'Retail Sale Id 3037',4620.00,0.00,0.00,6.00,624.00,'2023-01-19 11:57:52','',''),(3039,'1','306','1',1,'Retail Sale Id 3038',2348.50,0.00,0.00,3.05,317.20,'2023-01-19 12:01:06','',''),(3040,'1','306','1',1,'Retail Sale Id 3039',2310.00,0.00,0.00,3.00,312.00,'2023-01-19 12:08:21','',''),(3041,'1','306','1',1,'Retail Sale Id 3040',3080.00,0.00,0.00,4.00,416.00,'2023-01-19 12:15:22','',''),(3042,'1','306','1',1,'Retail Sale Id 3041',3996.30,0.00,0.00,5.19,539.76,'2023-01-19 12:17:28','',''),(3043,'1','306','1',1,'Retail Sale Id 3042',2302.30,0.00,0.00,2.99,310.96,'2023-01-19 12:18:57','',''),(3044,'1','306','1',1,'Retail Sale Id 3043',1201.20,0.00,0.00,1.56,162.24,'2023-01-19 12:20:08','',''),(3045,'1','306','1',1,'Retail Sale Id 3044',4620.00,0.00,0.00,6.00,624.00,'2023-01-19 12:23:28','',''),(3046,'1','306','1',1,'Retail Sale Id 3045',2310.00,0.00,0.00,3.00,312.00,'2023-01-19 12:25:29','',''),(3047,'1','306','1',1,'Retail Sale Id 3046',1501.50,0.00,0.00,1.95,202.80,'2023-01-19 12:26:19','',''),(3048,'1','306','1',1,'Retail Sale Id 3047',2310.00,0.00,0.00,3.00,312.00,'2023-01-19 12:27:55','',''),(3049,'1','306','1',1,'Retail Sale Id 3048',2310.00,0.00,0.00,3.00,312.00,'2023-01-19 12:28:45','',''),(3050,'1','306','1',1,'Retail Sale Id 3049',3850.00,0.00,0.00,5.00,520.00,'2023-01-19 12:31:47','',''),(3051,'1','306','1',1,'Retail Sale Id 3050',5497.80,0.00,0.00,7.14,742.56,'2023-01-19 12:35:43','',''),(3052,'1','306','1',1,'Retail Sale Id 3051',35989.00,0.00,0.00,49.30,3155.20,'2023-01-19 12:46:47','',''),(3053,'1','306','1',1,'Retail Sale Id 3052',23.10,0.00,0.00,0.03,3.12,'2023-01-19 12:48:49','',''),(3054,'1','306',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,85960.62,129.07,0.00,0.00,'2023-01-19 14:24:31','',''),(3055,'1','306',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,129.07,0.00,'2023-01-19 14:25:44','',''),(3056,'1','306','1',1,'Received from bridging 8',0.00,0.00,129.07,0.00,0.00,'2023-01-19 14:25:44','',''),(3057,'1','306','1',1,'Retail Sale Id 3053',64320.30,0.00,0.00,88.11,5639.04,'2023-01-19 14:26:38','',''),(3058,'1','306','1',1,'Retail Sale Id 3054',31539.20,0.00,0.00,40.96,4259.84,'2023-01-19 14:27:25','',''),(3059,'1','306',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,3196800.00,4800.00,0.00,0.00,'2023-01-19 15:02:22','',''),(3060,'1','306',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,4800.00,0.00,'2023-01-19 15:03:18','',''),(3061,'1','306','1',1,'Received from bridging 9',0.00,0.00,4800.00,0.00,0.00,'2023-01-19 15:03:18','',''),(3062,'1','306','1',1,'Retail Sale Id 3057',2302.30,0.00,0.00,2.99,310.96,'2023-01-19 15:05:30','',''),(3063,'1','306','1',1,'Retail Sale Id 3058',746.90,0.00,0.00,0.97,100.88,'2023-01-19 15:06:25','',''),(3064,'1','306','1',1,'Retail Sale Id 3059',1501.50,0.00,0.00,1.95,202.80,'2023-01-19 15:07:10','',''),(3065,'1','306','1',1,'Retail Sale Id 3060',3080.00,0.00,0.00,4.00,416.00,'2023-01-19 15:08:04','',''),(3066,'1','306','1',1,'Retail Sale Id 3062',8000.30,0.00,0.00,10.39,1080.56,'2023-01-19 15:09:45','',''),(3067,'1','306','1',1,'Retail Sale Id 3063',4620.00,0.00,0.00,6.00,624.00,'2023-01-19 15:10:38','',''),(3068,'1','306','1',1,'Retail Sale Id 3064',1540.00,0.00,0.00,2.00,208.00,'2023-01-19 15:11:27','',''),(3069,'1','306','1',1,'Retail Sale Id 3065',2340.80,0.00,0.00,3.04,316.16,'2023-01-19 15:13:01','',''),(3070,'1','306','1',1,'Retail Sale Id 3066',3850.00,0.00,0.00,5.00,520.00,'2023-01-19 15:14:09','',''),(3071,'1','306','1',1,'Retail Sale Id 3067',1547.70,0.00,0.00,2.01,209.04,'2023-01-19 15:15:54','',''),(3072,'1','306','1',1,'Retail Sale Id 3068',3850.00,0.00,0.00,5.00,520.00,'2023-01-19 15:16:33','',''),(3073,'1','306','1',1,'Retail Sale Id 3069',2310.00,0.00,0.00,3.00,312.00,'2023-01-19 15:18:57','',''),(3074,'1','306','1',1,'Retail Sale Id 3070',2302.30,0.00,0.00,2.99,310.96,'2023-01-19 15:20:21','',''),(3075,'1','306','1',1,'Retail Sale Id 3072',2402.40,0.00,0.00,3.12,324.48,'2023-01-19 15:22:41','',''),(3076,'1','306','1',1,'Retail Sale Id 3073',36500.00,0.00,0.00,50.00,3200.00,'2023-01-19 15:24:09','',''),(3077,'1','306','1',1,'Retail Sale Id 3074',4620.00,0.00,0.00,6.00,624.00,'2023-01-19 15:25:14','',''),(3078,'1','306','1',1,'Retail Sale Id 3075',3850.00,0.00,0.00,5.00,520.00,'2023-01-19 15:25:58','',''),(3079,'1','306','1',1,'Retail Sale Id 3077',2502.50,0.00,0.00,3.25,338.00,'2023-01-19 15:26:57','',''),(3080,'1','306','1',1,'Retail Sale Id 3078',1547.70,0.00,0.00,2.01,209.04,'2023-01-19 15:27:52','',''),(3081,'1','306','1',1,'Retail Sale Id 3079',3850.00,0.00,0.00,5.00,520.00,'2023-01-19 15:32:02','',''),(3082,'1','306','1',1,'Retail Sale Id 3080',2310.00,0.00,0.00,3.00,312.00,'2023-01-19 15:35:30','',''),(3083,'1','306','1',1,'Retail Sale Id 3082',9625.00,0.00,0.00,12.50,1300.00,'2023-01-19 15:37:25','',''),(3084,'1','306','1',1,'Retail Sale Id 3082',9625.00,0.00,0.00,12.50,1300.00,'2023-01-19 15:37:25','',''),(3085,'1','306','1',1,'Retail Sale Id 3083',3080.00,0.00,0.00,4.00,416.00,'2023-01-19 15:40:05','',''),(3086,'1','306','1',1,'Retail Sale Id 3084',2302.30,0.00,0.00,2.99,310.96,'2023-01-19 15:43:12','',''),(3087,'1','306','1',1,'Retail Sale Id 3085',3080.00,0.00,0.00,4.00,416.00,'2023-01-19 15:43:59','',''),(3088,'1','306','1',1,'Retail Sale Id 3086',1501.50,0.00,0.00,1.95,202.80,'2023-01-19 15:45:34','',''),(3089,'1','306','1',1,'Retail Sale Id 3087',14600.00,0.00,0.00,20.00,1280.00,'2023-01-19 15:47:00','',''),(3090,'1','306','1',1,'Retail Sale Id 3088',1501.50,0.00,0.00,1.95,202.80,'2023-01-19 15:48:51','',''),(3091,'1','306','1',1,'Retail Sale Id 3089',4620.00,0.00,0.00,6.00,624.00,'2023-01-19 15:50:30','',''),(3092,'1','306','1',1,'Retail Sale Id 3090',1540.00,0.00,0.00,2.00,208.00,'2023-01-19 15:53:36','',''),(3093,'1','306','1',1,'Retail Sale Id 3092',4596.90,0.00,0.00,5.97,620.88,'2023-01-19 15:56:29','',''),(3094,'1','306','1',1,'Retail Sale Id 3094',2695.00,0.00,0.00,3.50,364.00,'2023-01-19 15:59:12','',''),(3095,'1','306','1',1,'Retail Sale Id 3095',2302.30,0.00,0.00,2.99,310.96,'2023-01-19 16:00:19','',''),(3096,'1','306','1',1,'Retail Sale Id 3096',3003.00,0.00,0.00,3.90,405.60,'2023-01-19 16:14:02','',''),(3097,'1','306','1',1,'Retail Sale Id 3097',3850.00,0.00,0.00,5.00,520.00,'2023-01-19 16:20:28','',''),(3098,'1','306','1',1,'Retail Sale Id 3098',2302.30,0.00,0.00,2.99,310.96,'2023-01-19 16:23:09','',''),(3099,'1','306','1',1,'Retail Sale Id 3099',2310.00,0.00,0.00,3.00,312.00,'2023-01-19 16:26:14','',''),(3100,'1','306','1',1,'Retail Sale Id 3100',4620.00,0.00,0.00,6.00,624.00,'2023-01-19 16:31:23','',''),(3101,'1','306','1',1,'Retail Sale Id 3101',3103.10,0.00,0.00,4.03,419.12,'2023-01-19 16:32:34','',''),(3102,'1','306','1',1,'Retail Sale Id 3102',1501.50,0.00,0.00,1.95,202.80,'2023-01-19 16:34:05','',''),(3103,'1','306','1',1,'Retail Sale Id 3103',2317.70,0.00,0.00,3.01,313.04,'2023-01-19 16:38:51','',''),(3104,'1','306','1',1,'Retail Sale Id 3104',2502.50,0.00,0.00,3.25,338.00,'2023-01-19 16:39:45','',''),(3105,'1','306','1',1,'Retail Sale Id 3105',3896.20,0.00,0.00,5.06,526.24,'2023-01-19 16:40:48','',''),(3106,'1','306','1',1,'Retail Sale Id 3106',43800.00,0.00,0.00,60.00,3840.00,'2023-01-19 16:42:23','',''),(3107,'1','306','1',1,'Retail Sale Id 3107',2310.00,0.00,0.00,3.00,312.00,'2023-01-19 16:50:10','',''),(3108,'1','306','1',1,'Retail Sale Id 3108',2348.50,0.00,0.00,3.05,317.20,'2023-01-19 16:51:20','',''),(3109,'1','306','1',1,'Retail Sale Id 3109',81760.00,0.00,0.00,112.00,7168.00,'2023-01-19 16:52:51','',''),(3110,'1','306','1',1,'Retail Sale Id 3110',3850.00,0.00,0.00,5.00,520.00,'2023-01-19 16:55:15','',''),(3111,'1','306','1',1,'Retail Sale Id 3111',9240.00,0.00,0.00,12.00,1248.00,'2023-01-19 16:57:32','',''),(3112,'1','306','1',1,'Retail Sale Id 3113',8500.80,0.00,0.00,11.04,1148.16,'2023-01-19 16:59:35','',''),(3113,'1','306','1',1,'Retail Sale Id 3114',1601.60,0.00,0.00,2.08,216.32,'2023-01-19 17:00:43','',''),(3114,'1','306','1',1,'Retail Sale Id 3115',3103.10,0.00,0.00,4.03,419.12,'2023-01-19 17:01:35','',''),(3115,'1','306','1',1,'Retail Sale Id 3116',3850.00,0.00,0.00,5.00,520.00,'2023-01-19 17:02:39','',''),(3116,'1','306','1',1,'Retail Sale Id 3117',9648.10,0.00,0.00,12.53,1303.12,'2023-01-19 17:06:06','',''),(3117,'1','306','1',1,'Retail Sale Id 3118',1601.60,0.00,0.00,2.08,216.32,'2023-01-19 17:07:05','',''),(3118,'1','306','1',1,'Retail Sale Id 3119',3080.00,0.00,0.00,4.00,416.00,'2023-01-19 17:13:19','',''),(3119,'1','306','1',1,'Retail Sale Id 3120',2002.00,0.00,0.00,2.60,270.40,'2023-01-19 17:14:00','',''),(3120,'1','306','1',1,'Retail Sale Id 3121',1601.60,0.00,0.00,2.08,216.32,'2023-01-19 17:16:23','',''),(3121,'1','306','1',1,'Retail Sale Id 3122',2302.30,0.00,0.00,2.99,310.96,'2023-01-19 17:18:48','',''),(3122,'1','306','1',1,'Retail Sale Id 3123',25550.00,0.00,0.00,35.00,2240.00,'2023-01-19 17:25:09','',''),(3123,'1','306','1',1,'Retail Sale Id 3124',2602.60,0.00,0.00,3.38,351.52,'2023-01-19 17:26:00','',''),(3124,'1','306','1',1,'Retail Sale Id 3125',1501.50,0.00,0.00,1.95,202.80,'2023-01-19 17:30:43','',''),(3125,'1','306','1',1,'Retail Sale Id 3126',2202.20,0.00,0.00,2.86,297.44,'2023-01-19 17:32:06','',''),(3126,'1','306','1',1,'Retail Sale Id 3127',2002.00,0.00,0.00,2.60,270.40,'2023-01-19 17:40:31','',''),(3127,'1','306','1',1,'Retail Sale Id 3128',1501.50,0.00,0.00,1.95,202.80,'2023-01-19 17:41:20','',''),(3128,'1','306','1',1,'Retail Sale Id 3129',1540.00,0.00,0.00,2.00,208.00,'2023-01-19 17:42:21','',''),(3129,'1','306','1',1,'Retail Sale Id 3130',1001.00,0.00,0.00,1.30,135.20,'2023-01-19 17:43:59','',''),(3130,'1','306','1',1,'Retail Sale Id 3131',2348.50,0.00,0.00,3.05,317.20,'2023-01-19 17:44:55','',''),(3131,'1','306','1',1,'Retail Sale Id 3132',800.80,0.00,0.00,1.04,108.16,'2023-01-19 17:45:54','',''),(3132,'1','306','1',1,'Retail Sale Id 3133',2348.50,0.00,0.00,3.05,317.20,'2023-01-19 17:46:55','',''),(3133,'1','306','1',1,'Retail Sale Id 3134',1001.00,0.00,0.00,1.30,135.20,'2023-01-19 17:47:55','',''),(3134,'1','306','1',1,'Retail Sale Id 3135',21900.00,0.00,0.00,30.00,1920.00,'2023-01-19 17:52:30','',''),(3135,'1','306','1',1,'Retail Sale Id 3137',3103.10,0.00,0.00,4.03,419.12,'2023-01-19 18:05:44','',''),(3136,'1','306','1',1,'Retail Sale Id 3138',1001.00,0.00,0.00,1.30,135.20,'2023-01-19 18:06:58','',''),(3137,'1','306','1',1,'Retail Sale Id 3139',800.80,0.00,0.00,1.04,108.16,'2023-01-19 18:08:18','',''),(3138,'1','306','1',1,'Retail Sale Id 3140',1501.50,0.00,0.00,1.95,202.80,'2023-01-19 18:09:27','',''),(3139,'1','306','1',1,'Return of Retail Sale Id 3138',0.00,1001.00,1.30,0.00,-135.20,'2023-01-19 18:10:26','',''),(3140,'1','306','1',1,'Retail Sale Id 3141',3103.10,0.00,0.00,4.03,419.12,'2023-01-19 18:14:13','',''),(3141,'1','306','1',1,'Retail Sale Id 3142',4997.30,0.00,0.00,6.49,674.96,'2023-01-20 07:51:40','',''),(3142,'1','306','1',1,'Retail Sale Id 3143',2310.00,0.00,0.00,3.00,312.00,'2023-01-20 07:54:06','',''),(3143,'1','306','1',1,'Retail Sale Id 3144',4620.00,0.00,0.00,6.00,624.00,'2023-01-20 07:56:46','',''),(3144,'1','306','1',1,'Retail Sale Id 3145',9501.80,0.00,0.00,12.34,1283.36,'2023-01-20 08:02:00','',''),(3145,'1','306','1',1,'Retail Sale Id 3146',3850.00,0.00,0.00,5.00,520.00,'2023-01-20 08:03:25','',''),(3146,'1','306','1',1,'Retail Sale Id 3147',9702.00,0.00,0.00,12.60,1310.40,'2023-01-20 08:09:08','',''),(3147,'1','306','1',1,'Retail Sale Id 3148',3103.10,0.00,0.00,4.03,419.12,'2023-01-20 08:10:29','',''),(3148,'1','306','1',1,'Retail Sale Id 3149',4596.90,0.00,0.00,5.97,620.88,'2023-01-20 08:12:47','',''),(3149,'1','306','1',1,'Retail Sale Id 3150',9247.70,0.00,0.00,12.01,1249.04,'2023-01-20 08:15:37','',''),(3150,'1','306','1',1,'Retail Sale Id 3151',3103.10,0.00,0.00,4.03,419.12,'2023-01-20 08:16:50','',''),(3151,'1','306','1',1,'Retail Sale Id 3152',8000.30,0.00,0.00,10.39,1080.56,'2023-01-20 08:17:52','',''),(3152,'1','306','1',1,'Retail Sale Id 3153',9702.00,0.00,0.00,12.60,1310.40,'2023-01-20 08:20:23','',''),(3153,'1','306','1',1,'Retail Sale Id 3154',4697.00,0.00,0.00,6.10,634.40,'2023-01-20 08:22:00','',''),(3154,'1','306','1',1,'Retail Sale Id 3155',2317.70,0.00,0.00,3.01,313.04,'2023-01-20 08:23:01','',''),(3155,'1','306','1',1,'Retail Sale Id 3156',4596.90,0.00,0.00,5.97,620.88,'2023-01-20 08:25:38','',''),(3156,'1','306','1',1,'Retail Sale Id 3157',3003.00,0.00,0.00,3.90,405.60,'2023-01-20 08:26:54','',''),(3157,'1','306','1',1,'Retail Sale Id 3158',3850.00,0.00,0.00,5.00,520.00,'2023-01-20 08:36:40','',''),(3158,'1','306','1',1,'Retail Sale Id 3159',43800.00,0.00,0.00,60.00,3840.00,'2023-01-20 08:37:59','',''),(3159,'1','306','1',1,'Retail Sale Id 3160',3650.00,0.00,0.00,5.00,320.00,'2023-01-20 08:40:06','',''),(3160,'1','306','1',1,'Retail Sale Id 3162',2402.40,0.00,0.00,3.12,324.48,'2023-01-20 08:42:31','',''),(3161,'1','306','1',1,'Retail Sale Id 3163',2502.50,0.00,0.00,3.25,338.00,'2023-01-20 08:43:31','',''),(3162,'1','306','1',1,'Retail Sale Id 3164',73000.00,0.00,0.00,100.00,6400.00,'2023-01-20 08:45:07','',''),(3163,'1','306','1',1,'Retail Sale Id 3165',1540.00,0.00,0.00,2.00,208.00,'2023-01-20 08:46:29','',''),(3164,'1','306','1',1,'Retail Sale Id 3166',4596.90,0.00,0.00,5.97,620.88,'2023-01-20 08:47:38','',''),(3165,'1','306','1',1,'Retail Sale Id 3167',3850.00,0.00,0.00,5.00,520.00,'2023-01-20 08:48:45','',''),(3166,'1','306','1',1,'Retail Sale Id 3168',4650.80,0.00,0.00,6.04,628.16,'2023-01-20 08:50:57','',''),(3167,'1','306','1',1,'Retail Sale Id 3169',1540.00,0.00,0.00,2.00,208.00,'2023-01-20 08:52:30','',''),(3168,'1','306','1',1,'Retail Sale Id 3170',6999.30,0.00,0.00,9.09,945.36,'2023-01-20 08:54:43','',''),(3169,'1','306','1',1,'Retail Sale Id 3171',4620.00,0.00,0.00,6.00,624.00,'2023-01-20 08:55:49','',''),(3170,'1','306','1',1,'Retail Sale Id 3171',9625.00,0.00,0.00,12.50,1300.00,'2023-01-20 08:55:49','',''),(3171,'1','306','1',1,'Retail Sale Id 3172',9625.00,0.00,0.00,12.50,1300.00,'2023-01-20 08:57:15','',''),(3172,'1','306','1',1,'Retail Sale Id 3173',4620.00,0.00,0.00,6.00,624.00,'2023-01-20 08:57:51','',''),(3173,'1','306','1',1,'Return of Retail Sale Id 3171',0.00,4620.00,6.00,0.00,-624.00,'2023-01-20 08:59:46','',''),(3174,'1','306','1',1,'Return of Retail Sale Id 3171',0.00,9625.00,12.50,0.00,-1300.00,'2023-01-20 08:59:46','',''),(3175,'1','306','1',1,'Retail Sale Id 3174',3850.00,0.00,0.00,5.00,520.00,'2023-01-20 09:08:19','',''),(3176,'1','306','1',1,'Retail Sale Id 3175',800.80,0.00,0.00,1.04,108.16,'2023-01-20 09:10:07','',''),(3177,'1','306','1',1,'Retail Sale Id 3176',3003.00,0.00,0.00,3.90,405.60,'2023-01-20 09:13:49','',''),(3178,'1','306','1',1,'Retail Sale Id 3177',3996.30,0.00,0.00,5.19,539.76,'2023-01-20 09:14:36','',''),(3179,'1','306','1',1,'Retail Sale Id 3178',2310.00,0.00,0.00,3.00,312.00,'2023-01-20 09:16:35','',''),(3180,'1','306','1',1,'Retail Sale Id 3179',800.80,0.00,0.00,1.04,108.16,'2023-01-20 09:17:25','',''),(3181,'1','306','1',1,'Retail Sale Id 3180',2402.40,0.00,0.00,3.12,324.48,'2023-01-20 09:18:23','',''),(3182,'1','306','1',1,'Return of Retail Sale Id 3176',0.00,3003.00,3.90,0.00,-405.60,'2023-01-20 09:19:49','',''),(3183,'1','306','1',1,'Retail Sale Id 3181',2310.00,0.00,0.00,3.00,312.00,'2023-01-20 09:20:47','',''),(3184,'1','306','1',1,'Retail Sale Id 3182',800.80,0.00,0.00,1.04,108.16,'2023-01-20 09:28:30','',''),(3185,'1','306','1',1,'Retail Sale Id 3183',90520.00,0.00,0.00,124.00,7936.00,'2023-01-20 09:30:13','',''),(3186,'1','306','1',1,'Retail Sale Id 3184',3850.00,0.00,0.00,5.00,520.00,'2023-01-20 09:33:02','',''),(3187,'1','306','1',1,'Retail Sale Id 3185',3203.20,0.00,0.00,4.16,432.64,'2023-01-20 09:36:51','',''),(3188,'1','306','1',1,'Retail Sale Id 3186',2302.30,0.00,0.00,2.99,310.96,'2023-01-20 09:44:57','',''),(3189,'1','306','1',1,'Retail Sale Id 3187',1001.00,0.00,0.00,1.30,135.20,'2023-01-20 09:46:19','',''),(3190,'1','306','1',1,'Retail Sale Id 3189',770.00,0.00,0.00,1.00,104.00,'2023-01-20 09:47:45','',''),(3191,'1','306','1',1,'Retail Sale Id 3189',770.00,0.00,0.00,1.00,104.00,'2023-01-20 09:47:45','',''),(3192,'1','306','1',1,'Retail Sale Id 3190',6999.30,0.00,0.00,9.09,945.36,'2023-01-20 09:49:55','',''),(3193,'1','306','1',1,'Retail Sale Id 3191',9625.00,0.00,0.00,12.50,1300.00,'2023-01-20 09:51:44','',''),(3194,'1','306','1',1,'Retail Sale Id 3192',1501.50,0.00,0.00,1.95,202.80,'2023-01-20 10:13:40','',''),(3195,'1','306','1',1,'Retail Sale Id 3193',4596.90,0.00,0.00,5.97,620.88,'2023-01-20 10:14:50','',''),(3196,'1','306','1',1,'Retail Sale Id 3194',3803.80,0.00,0.00,4.94,513.76,'2023-01-20 10:15:35','',''),(3197,'1','306','1',1,'Retail Sale Id 3195',1001.00,0.00,0.00,1.30,135.20,'2023-01-20 10:18:16','',''),(3198,'1','306','1',1,'Retail Sale Id 3196',2310.00,0.00,0.00,3.00,312.00,'2023-01-20 10:22:01','',''),(3199,'1','306','1',1,'Retail Sale Id 3197',4496.80,0.00,0.00,5.84,607.36,'2023-01-20 10:33:46','',''),(3200,'1','306','1',1,'Retail Sale Id 3199',4627.70,0.00,0.00,6.01,625.04,'2023-01-20 10:36:04','',''),(3201,'1','306','1',1,'Retail Sale Id 3200',3996.30,0.00,0.00,5.19,539.76,'2023-01-20 10:37:46','',''),(3202,'1','306','1',1,'Retail Sale Id 3201',4612.30,0.00,0.00,5.99,622.96,'2023-01-20 10:40:01','',''),(3203,'1','306','1',1,'Retail Sale Id 3202',5998.30,0.00,0.00,7.79,810.16,'2023-01-20 10:41:16','',''),(3204,'1','306','1',1,'Retail Sale Id 3203',800.80,0.00,0.00,1.04,108.16,'2023-01-20 10:43:26','',''),(3205,'1','306','1',1,'Retail Sale Id 3204',3996.30,0.00,0.00,5.19,539.76,'2023-01-20 10:44:29','',''),(3206,'1','306','1',1,'Retail Sale Id 3205',3103.10,0.00,0.00,4.03,419.12,'2023-01-20 10:45:43','',''),(3207,'1','306','1',1,'Retail Sale Id 3206',1547.70,0.00,0.00,2.01,209.04,'2023-01-20 10:46:46','',''),(3208,'1','306','1',1,'Retail Sale Id 3207',3850.00,0.00,0.00,5.00,520.00,'2023-01-20 10:53:44','',''),(3209,'1','306','1',1,'Retail Sale Id 3208',2348.50,0.00,0.00,3.05,317.20,'2023-01-20 10:57:18','',''),(3210,'1','306','1',1,'Retail Sale Id 3209',3896.20,0.00,0.00,5.06,526.24,'2023-01-20 11:07:29','',''),(3211,'1','306','1',1,'Retail Sale Id 3210',2302.30,0.00,0.00,2.99,310.96,'2023-01-20 11:10:27','',''),(3212,'1','306','1',1,'Retail Sale Id 3211',3896.20,0.00,0.00,5.06,526.24,'2023-01-20 11:33:09','',''),(3213,'1','306','1',1,'Retail Sale Id 3212',2302.30,0.00,0.00,2.99,310.96,'2023-01-20 11:35:41','',''),(3214,'1','306','1',1,'Retail Sale Id 3213',14600.00,0.00,0.00,20.00,1280.00,'2023-01-20 11:40:58','',''),(3215,'1','306','1',1,'Retail Sale Id 3214',2310.00,0.00,0.00,3.00,312.00,'2023-01-20 11:49:50','',''),(3216,'1','306','1',1,'Retail Sale Id 3215',2310.00,0.00,0.00,3.00,312.00,'2023-01-20 11:52:20','',''),(3217,'1','306','1',1,'Retail Sale Id 3216',770.00,0.00,0.00,1.00,104.00,'2023-01-20 12:03:00','',''),(3218,'1','306','1',1,'Retail Sale Id 3217',2302.30,0.00,0.00,2.99,310.96,'2023-01-20 12:05:56','',''),(3219,'1','306','1',1,'Retail Sale Id 3218',2348.50,0.00,0.00,3.05,317.20,'2023-01-20 12:07:26','',''),(3220,'1','306','1',1,'Retail Sale Id 3219',1501.50,0.00,0.00,1.95,202.80,'2023-01-20 12:10:28','',''),(3221,'1','306','1',1,'Retail Sale Id 3220',2502.50,0.00,0.00,3.25,338.00,'2023-01-20 12:18:12','',''),(3222,'1','306','1',1,'Retail Sale Id 3221',4997.30,0.00,0.00,6.49,674.96,'2023-01-20 12:20:14','',''),(3223,'1','306','1',1,'Retail Sale Id 3222',1540.00,0.00,0.00,2.00,208.00,'2023-01-20 12:27:20','',''),(3224,'1','306','1',1,'Retail Sale Id 3224',2502.50,0.00,0.00,3.25,338.00,'2023-01-20 12:28:38','',''),(3225,'1','306','1',1,'Retail Sale Id 3225',3003.00,0.00,0.00,3.90,405.60,'2023-01-20 12:31:33','',''),(3226,'1','306','1',1,'Return of Retail Sale Id 3225',0.00,3003.00,3.90,0.00,-405.60,'2023-01-20 12:32:54','',''),(3227,'1','306','1',1,'Retail Sale Id 3226',3203.20,0.00,0.00,4.16,432.64,'2023-01-20 12:33:42','',''),(3228,'1','306','1',1,'Retail Sale Id 3227',3803.80,0.00,0.00,4.94,513.76,'2023-01-20 12:38:04','',''),(3229,'1','306','1',1,'Retail Sale Id 3228',3080.00,0.00,0.00,4.00,416.00,'2023-01-20 12:39:08','',''),(3230,'1','306','1',1,'Retail Sale Id 3229',4496.80,0.00,0.00,5.84,607.36,'2023-01-20 12:40:10','',''),(3231,'1','306','1',1,'Retail Sale Id 3230',9625.00,0.00,0.00,12.50,1300.00,'2023-01-20 12:42:12','',''),(3232,'1','306','1',1,'Retail Sale Id 3232',2502.50,0.00,0.00,3.25,338.00,'2023-01-20 12:53:35','',''),(3233,'1','306','1',1,'Retail Sale Id 3233',1547.70,0.00,0.00,2.01,209.04,'2023-01-20 13:00:38','',''),(3234,'1','306','1',1,'Retail Sale Id 3234',4697.00,0.00,0.00,6.10,634.40,'2023-01-20 13:13:52','',''),(3235,'1','306','1',1,'Retail Sale Id 3235',47450.00,0.00,0.00,65.00,4160.00,'2023-01-20 13:15:54','',''),(3236,'1','306','1',1,'Retail Sale Id 3236',2555.00,0.00,0.00,3.50,224.00,'2023-01-20 13:19:37','',''),(3237,'1','306','1',1,'Retail Sale Id 3237',4697.00,0.00,0.00,6.10,634.40,'2023-01-20 13:26:32','',''),(3238,'1','306','1',1,'Retail Sale Id 3238',1501.50,0.00,0.00,1.95,202.80,'2023-01-20 13:34:11','',''),(3239,'1','306','1',1,'Retail Sale Id 3239',27740.00,0.00,0.00,38.00,2432.00,'2023-01-20 13:38:31','',''),(3240,'1','306','1',1,'Retail Sale Id 3240',4620.00,0.00,0.00,6.00,624.00,'2023-01-20 13:40:49','',''),(3241,'1','306','1',1,'Retail Sale Id 3241',3080.00,0.00,0.00,4.00,416.00,'2023-01-20 13:43:49','',''),(3242,'1','306','1',1,'Retail Sale Id 3242',3080.00,0.00,0.00,4.00,416.00,'2023-01-20 13:53:08','',''),(3243,'1','306','1',1,'Retail Sale Id 3243',3003.00,0.00,0.00,3.90,405.60,'2023-01-20 13:57:55','',''),(3244,'1','306','1',1,'Retail Sale Id 3244',3003.00,0.00,0.00,3.90,405.60,'2023-01-20 14:12:04','',''),(3245,'1','306','1',1,'Retail Sale Id 3245',2202.20,0.00,0.00,2.86,297.44,'2023-01-20 14:15:10','',''),(3246,'1','306','1',1,'Retail Sale Id 3246',2302.30,0.00,0.00,2.99,310.96,'2023-01-20 14:16:11','',''),(3247,'1','306','1',1,'Retail Sale Id 3247',9601.90,0.00,0.00,12.47,1296.88,'2023-01-20 14:18:08','',''),(3248,'1','306','1',1,'Retail Sale Id 3248',2402.40,0.00,0.00,3.12,324.48,'2023-01-20 14:20:48','',''),(3249,'1','306','1',1,'Retail Sale Id 3249',2002.00,0.00,0.00,2.60,270.40,'2023-01-20 14:21:48','',''),(3250,'1','306','1',1,'Retail Sale Id 3250',4997.30,0.00,0.00,6.49,674.96,'2023-01-20 14:26:33','',''),(3251,'1','306','1',1,'Retail Sale Id 3251',3996.30,0.00,0.00,5.19,539.76,'2023-01-20 14:27:34','',''),(3252,'1','306','1',1,'Retail Sale Id 3252',3103.10,0.00,0.00,4.03,419.12,'2023-01-20 14:28:29','',''),(3253,'1','306','1',1,'Retail Sale Id 3253',2310.00,0.00,0.00,3.00,312.00,'2023-01-20 14:29:15','',''),(3254,'1','306','1',1,'Retail Sale Id 3254',4620.00,0.00,0.00,6.00,624.00,'2023-01-20 14:31:04','',''),(3255,'1','306','1',1,'Retail Sale Id 3254',4620.00,0.00,0.00,6.00,624.00,'2023-01-20 14:31:04','',''),(3256,'1','306','1',1,'Retail Sale Id 3255',800.80,0.00,0.00,1.04,108.16,'2023-01-20 14:37:03','',''),(3257,'1','306','1',1,'Retail Sale Id 3256',2348.50,0.00,0.00,3.05,317.20,'2023-01-20 14:58:06','',''),(3258,'1','306','1',1,'Return of Retail Sale Id 3256',0.00,2348.50,3.05,0.00,-317.20,'2023-01-20 14:58:38','',''),(3259,'1','306','1',1,'Retail Sale Id 3257',2502.50,0.00,0.00,3.25,338.00,'2023-01-20 14:59:13','',''),(3260,'1','306','1',1,'Retail Sale Id 3258',7499.80,0.00,0.00,9.74,1012.96,'2023-01-20 15:05:55','',''),(3261,'1','306','1',1,'Retail Sale Id 3259',9702.00,0.00,0.00,12.60,1310.40,'2023-01-20 15:07:28','',''),(3262,'1','306','1',1,'Retail Sale Id 3260',1547.70,0.00,0.00,2.01,209.04,'2023-01-20 15:13:21','',''),(3263,'1','306','1',1,'Retail Sale Id 3261',7700.00,0.00,0.00,10.00,1040.00,'2023-01-20 15:14:24','',''),(3264,'1','306','1',1,'Retail Sale Id 3262',2310.00,0.00,0.00,3.00,312.00,'2023-01-20 15:19:34','',''),(3265,'1','306','1',1,'Retail Sale Id 3263',3080.00,0.00,0.00,4.00,416.00,'2023-01-20 15:20:34','',''),(3266,'1','306','1',1,'Retail Sale Id 3264',2002.00,0.00,0.00,2.60,270.40,'2023-01-20 15:27:51','',''),(3267,'1','306','1',1,'Retail Sale Id 3265',2502.50,0.00,0.00,3.25,338.00,'2023-01-20 15:36:18','',''),(3268,'1','306','1',1,'Retail Sale Id 3266',4997.30,0.00,0.00,6.49,674.96,'2023-01-20 15:38:52','',''),(3269,'1','306','1',1,'Retail Sale Id 3267',800.80,0.00,0.00,1.04,108.16,'2023-01-20 15:47:12','',''),(3270,'1','306','1',1,'Retail Sale Id 3270',1601.60,0.00,0.00,2.08,216.32,'2023-01-20 15:50:15','',''),(3271,'1','306','1',1,'Retail Sale Id 3271',4620.00,0.00,0.00,6.00,624.00,'2023-01-20 15:52:01','',''),(3272,'1','306','1',1,'Retail Sale Id 3272',2310.00,0.00,0.00,3.00,312.00,'2023-01-20 15:53:21','',''),(3273,'1','306','1',1,'Retail Sale Id 3273',3850.00,0.00,0.00,5.00,520.00,'2023-01-20 15:58:01','',''),(3274,'1','306','1',1,'Retail Sale Id 3274',1501.50,0.00,0.00,1.95,202.80,'2023-01-20 16:01:34','',''),(3275,'1','306','1',1,'Retail Sale Id 3275',3850.00,0.00,0.00,5.00,520.00,'2023-01-20 16:04:43','',''),(3276,'1','306','1',1,'Retail Sale Id 3276',2310.00,0.00,0.00,3.00,312.00,'2023-01-20 16:06:05','',''),(3277,'1','306','1',1,'Retail Sale Id 3285',4697.00,0.00,0.00,6.10,634.40,'2023-01-20 16:08:17','',''),(3278,'1','306','1',1,'Retail Sale Id 3286',1601.60,0.00,0.00,2.08,216.32,'2023-01-20 16:16:29','',''),(3279,'1','306','1',1,'Retail Sale Id 3287',5497.80,0.00,0.00,7.14,742.56,'2023-01-20 16:27:41','',''),(3280,'1','306','1',1,'Retail Sale Id 3288',3080.00,0.00,0.00,4.00,416.00,'2023-01-20 16:30:38','',''),(3281,'1','306','1',1,'Retail Sale Id 3289',1540.00,0.00,0.00,2.00,208.00,'2023-01-20 16:38:49','',''),(3282,'1','306','1',1,'Retail Sale Id 3289',15400.00,0.00,0.00,20.00,2080.00,'2023-01-20 16:38:49','',''),(3283,'1','306','1',1,'Retail Sale Id 3290',9625.00,0.00,0.00,12.50,1300.00,'2023-01-20 16:40:30','',''),(3284,'1','306','1',1,'Retail Sale Id 3291',19710.00,0.00,0.00,27.00,1728.00,'2023-01-20 16:44:43','',''),(3285,'1','306','1',1,'Retail Sale Id 3292',3850.00,0.00,0.00,5.00,520.00,'2023-01-20 16:47:32','',''),(3286,'1','306','1',1,'Retail Sale Id 3294',4496.80,0.00,0.00,5.84,607.36,'2023-01-20 16:53:34','',''),(3287,'1','306','1',1,'Retail Sale Id 3295',4596.90,0.00,0.00,5.97,620.88,'2023-01-20 17:01:36','',''),(3288,'1','306','1',1,'Retail Sale Id 3296',2302.30,0.00,0.00,2.99,310.96,'2023-01-20 17:02:42','',''),(3289,'1','306','1',1,'Retail Sale Id 3297',800.80,0.00,0.00,1.04,108.16,'2023-01-20 17:04:00','',''),(3290,'1','306','1',1,'Retail Sale Id 3298',8500.80,0.00,0.00,11.04,1148.16,'2023-01-20 17:05:31','',''),(3291,'1','306','1',1,'Retail Sale Id 3299',2310.00,0.00,0.00,3.00,312.00,'2023-01-20 17:07:07','',''),(3292,'1','306','1',1,'Retail Sale Id 3300',1001.00,0.00,0.00,1.30,135.20,'2023-01-20 17:07:56','',''),(3293,'1','306','1',1,'Retail Sale Id 3301',4650.80,0.00,0.00,6.04,628.16,'2023-01-20 17:09:01','',''),(3294,'1','306','1',1,'Retail Sale Id 3302',3850.00,0.00,0.00,5.00,520.00,'2023-01-20 17:10:46','',''),(3295,'1','306','1',1,'Retail Sale Id 3303',1501.50,0.00,0.00,1.95,202.80,'2023-01-20 17:12:24','',''),(3296,'1','306','1',1,'Retail Sale Id 3304',25550.00,0.00,0.00,35.00,2240.00,'2023-01-20 17:13:31','',''),(3297,'1','306','1',1,'Retail Sale Id 3305',9702.00,0.00,0.00,12.60,1310.40,'2023-01-20 17:17:21','',''),(3298,'1','306','1',1,'Retail Sale Id 3306',2310.00,0.00,0.00,3.00,312.00,'2023-01-20 17:18:53','',''),(3299,'1','306','1',1,'Retail Sale Id 3307',4620.00,0.00,0.00,6.00,624.00,'2023-01-20 17:20:21','',''),(3300,'1','306','1',1,'Retail Sale Id 3308',2310.00,0.00,0.00,3.00,312.00,'2023-01-20 17:21:43','',''),(3301,'1','306','1',1,'Retail Sale Id 3309',1540.00,0.00,0.00,2.00,208.00,'2023-01-20 17:22:50','',''),(3302,'1','306','1',1,'Retail Sale Id 3310',800.80,0.00,0.00,1.04,108.16,'2023-01-20 17:23:57','',''),(3303,'1','306','1',1,'Retail Sale Id 3311',3850.00,0.00,0.00,5.00,520.00,'2023-01-20 17:24:52','',''),(3304,'1','306','1',1,'Retail Sale Id 3312',4697.00,0.00,0.00,6.10,634.40,'2023-01-20 17:27:44','',''),(3305,'1','306','1',1,'Retail Sale Id 3313',9702.00,0.00,0.00,12.60,1310.40,'2023-01-20 17:34:32','',''),(3306,'1','306','1',1,'Retail Sale Id 3314',3080.00,0.00,0.00,4.00,416.00,'2023-01-20 17:35:50','',''),(3307,'1','306','1',1,'Retail Sale Id 3315',3850.00,0.00,0.00,5.00,520.00,'2023-01-20 17:37:02','',''),(3308,'1','306','1',1,'Retail Sale Id 3316',3850.00,0.00,0.00,5.00,520.00,'2023-01-20 17:41:31','',''),(3309,'1','306','1',1,'Retail Sale Id 3317',1201.20,0.00,0.00,1.56,162.24,'2023-01-20 17:45:54','',''),(3310,'1','306','1',1,'Retail Sale Id 3318',3850.00,0.00,0.00,5.00,520.00,'2023-01-20 17:51:49','',''),(3311,'1','306','1',1,'Retail Sale Id 3319',5497.80,0.00,0.00,7.14,742.56,'2023-01-20 17:54:27','',''),(3312,'1','306','1',1,'Retail Sale Id 3320',4997.30,0.00,0.00,6.49,674.96,'2023-01-20 17:56:01','',''),(3313,'1','306','1',1,'Retail Sale Id 3321',3850.00,0.00,0.00,5.00,520.00,'2023-01-20 18:08:00','',''),(3314,'1','306','1',1,'Retail Sale Id 3322',2002.00,0.00,0.00,2.60,270.40,'2023-01-20 18:22:13','',''),(3315,'1','306','1',1,'Retail Sale Id 3323',1501.50,0.00,0.00,1.95,202.80,'2023-01-21 07:12:10','',''),(3316,'1','306','1',1,'Retail Sale Id 3324',3996.30,0.00,0.00,5.19,539.76,'2023-01-21 07:14:27','',''),(3317,'1','306','1',1,'Retail Sale Id 3325',2002.00,0.00,0.00,2.60,270.40,'2023-01-21 07:16:07','',''),(3318,'1','306','1',1,'Retail Sale Id 3326',3003.00,0.00,0.00,3.90,405.60,'2023-01-21 07:23:35','',''),(3319,'1','306','1',1,'Retail Sale Id 3327',4620.00,0.00,0.00,6.00,624.00,'2023-01-21 07:25:37','',''),(3320,'1','306','1',1,'Retail Sale Id 3328',3996.30,0.00,0.00,5.19,539.76,'2023-01-21 07:28:26','',''),(3321,'1','306','1',1,'Retail Sale Id 3329',3080.00,0.00,0.00,4.00,416.00,'2023-01-21 07:35:20','',''),(3322,'1','306','1',1,'Retail Sale Id 3330',4620.00,0.00,0.00,6.00,624.00,'2023-01-21 07:55:50','',''),(3323,'1','306','1',1,'Retail Sale Id 3331',4612.30,0.00,0.00,5.99,622.96,'2023-01-21 08:01:19','',''),(3324,'1','306','1',1,'Retail Sale Id 3332',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 08:02:44','',''),(3325,'1','306','1',1,'Retail Sale Id 3333',4620.00,0.00,0.00,6.00,624.00,'2023-01-21 08:04:41','',''),(3326,'1','306','1',1,'Retail Sale Id 3334',3996.30,0.00,0.00,5.19,539.76,'2023-01-21 08:14:19','',''),(3327,'1','306','1',1,'Retail Sale Id 3335',9702.00,0.00,0.00,12.60,1310.40,'2023-01-21 08:19:27','',''),(3328,'1','306','1',1,'Retail Sale Id 3337',1540.00,0.00,0.00,2.00,208.00,'2023-01-21 08:20:34','',''),(3329,'1','306','1',1,'Retail Sale Id 3338',800.80,0.00,0.00,1.04,108.16,'2023-01-21 08:22:10','',''),(3330,'1','306','1',1,'Retail Sale Id 3339',1501.50,0.00,0.00,1.95,202.80,'2023-01-21 08:24:10','',''),(3331,'1','306','1',1,'Retail Sale Id 3340',3103.10,0.00,0.00,4.03,419.12,'2023-01-21 08:25:28','',''),(3332,'1','306','1',1,'Retail Sale Id 3341',800.80,0.00,0.00,1.04,108.16,'2023-01-21 08:26:37','',''),(3333,'1','306','1',1,'Retail Sale Id 3342',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 08:31:33','',''),(3334,'1','306','1',1,'Retail Sale Id 3343',1501.50,0.00,0.00,1.95,202.80,'2023-01-21 08:34:29','',''),(3335,'1','306','1',1,'Retail Sale Id 3344',4620.00,0.00,0.00,6.00,624.00,'2023-01-21 08:40:55','',''),(3336,'1','306','1',1,'Retail Sale Id 3345',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 08:41:49','',''),(3337,'1','306','1',1,'Retail Sale Id 3346',9401.70,0.00,0.00,12.21,1269.84,'2023-01-21 08:42:59','',''),(3338,'1','306','1',1,'Retail Sale Id 3347',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 08:43:42','',''),(3339,'1','306','1',1,'Retail Sale Id 3348',3103.10,0.00,0.00,4.03,419.12,'2023-01-21 08:44:36','',''),(3340,'1','306','1',1,'Retail Sale Id 3349',4596.90,0.00,0.00,5.97,620.88,'2023-01-21 08:45:17','',''),(3341,'1','306','1',1,'Retail Sale Id 3350',7700.00,0.00,0.00,10.00,1040.00,'2023-01-21 08:46:12','',''),(3342,'1','306','1',1,'Retail Sale Id 3351',3103.10,0.00,0.00,4.03,419.12,'2023-01-21 08:46:49','',''),(3343,'1','306','1',1,'Retail Sale Id 3352',3896.20,0.00,0.00,5.06,526.24,'2023-01-21 08:47:33','',''),(3344,'1','306','1',1,'Retail Sale Id 3353',1501.50,0.00,0.00,1.95,202.80,'2023-01-21 08:48:14','',''),(3345,'1','306','1',1,'Retail Sale Id 3354',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 08:48:52','',''),(3346,'1','306','1',1,'Retail Sale Id 3355',1501.50,0.00,0.00,1.95,202.80,'2023-01-21 08:49:25','',''),(3347,'1','306','1',1,'Retail Sale Id 3356',1547.70,0.00,0.00,2.01,209.04,'2023-01-21 08:50:02','',''),(3348,'1','306','1',1,'Retail Sale Id 3357',1001.00,0.00,0.00,1.30,135.20,'2023-01-21 08:50:48','',''),(3349,'1','306','1',1,'Retail Sale Id 3358',4650.80,0.00,0.00,6.04,628.16,'2023-01-21 08:51:57','',''),(3350,'1','306','1',1,'Retail Sale Id 3359',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 08:52:55','',''),(3351,'1','306','1',1,'Retail Sale Id 3360',2502.50,0.00,0.00,3.25,338.00,'2023-01-21 08:53:45','',''),(3352,'1','306','1',1,'Retail Sale Id 3361',1540.00,0.00,0.00,2.00,208.00,'2023-01-21 08:54:59','',''),(3353,'1','306','1',1,'Retail Sale Id 3362',4596.90,0.00,0.00,5.97,620.88,'2023-01-21 08:59:11','',''),(3354,'1','306','1',1,'Retail Sale Id 3363',2002.00,0.00,0.00,2.60,270.40,'2023-01-21 09:04:28','',''),(3355,'1','306','1',1,'Retail Sale Id 3364',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 09:08:56','',''),(3356,'1','306','1',1,'Retail Sale Id 3365',4596.90,0.00,0.00,5.97,620.88,'2023-01-21 09:10:59','',''),(3357,'1','306','1',1,'Retail Sale Id 3366',4697.00,0.00,0.00,6.10,634.40,'2023-01-21 09:11:34','',''),(3358,'1','306','1',1,'Retail Sale Id 3367',3850.00,0.00,0.00,5.00,520.00,'2023-01-21 09:17:01','',''),(3359,'1','306','1',1,'Retail Sale Id 3368',3850.00,0.00,0.00,5.00,520.00,'2023-01-21 09:18:10','',''),(3360,'1','306','1',1,'Retail Sale Id 3369',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 09:20:09','',''),(3361,'1','306','1',1,'Retail Sale Id 3370',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 09:22:20','',''),(3362,'1','306','1',1,'Retail Sale Id 3370',9625.00,0.00,0.00,12.50,1300.00,'2023-01-21 09:22:20','',''),(3363,'1','306','1',1,'Retail Sale Id 3371',2002.00,0.00,0.00,2.60,270.40,'2023-01-21 09:24:59','',''),(3364,'1','306','1',1,'Retail Sale Id 3372',10002.30,0.00,0.00,12.99,1350.96,'2023-01-21 09:29:58','',''),(3365,'1','306','1',1,'Retail Sale Id 3373',1540.00,0.00,0.00,2.00,208.00,'2023-01-21 09:31:11','',''),(3366,'1','306','1',1,'Retail Sale Id 3374',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 09:32:42','',''),(3367,'1','306','1',1,'Retail Sale Id 3375',2402.40,0.00,0.00,3.12,324.48,'2023-01-21 09:34:25','',''),(3368,'1','306','1',1,'Retail Sale Id 3376',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 09:36:37','',''),(3369,'1','306','1',1,'Retail Sale Id 3377',1501.50,0.00,0.00,1.95,202.80,'2023-01-21 09:45:37','',''),(3370,'1','306','1',1,'Retail Sale Id 3378',2502.50,0.00,0.00,3.25,338.00,'2023-01-21 09:49:19','',''),(3371,'1','306','1',1,'Retail Sale Id 3379',4596.90,0.00,0.00,5.97,620.88,'2023-01-21 09:53:47','',''),(3372,'1','306','1',1,'Retail Sale Id 3380',3003.00,0.00,0.00,3.90,405.60,'2023-01-21 10:03:42','',''),(3373,'1','306','1',1,'Retail Sale Id 3381',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 10:05:13','',''),(3374,'1','306','1',1,'Retail Sale Id 3382',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 10:07:52','',''),(3375,'1','306','1',1,'Retail Sale Id 3383',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 10:11:35','',''),(3376,'1','306','1',1,'Retail Sale Id 3384',6160.00,0.00,0.00,8.00,832.00,'2023-01-21 10:13:09','',''),(3377,'1','306','1',1,'Retail Sale Id 3386',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 10:14:23','',''),(3378,'1','306','1',1,'Retail Sale Id 3387',3080.00,0.00,0.00,4.00,416.00,'2023-01-21 10:15:52','',''),(3379,'1','306','1',1,'Retail Sale Id 3388',3850.00,0.00,0.00,5.00,520.00,'2023-01-21 10:17:52','',''),(3380,'1','306','1',1,'Retail Sale Id 3389',3080.00,0.00,0.00,4.00,416.00,'2023-01-21 10:19:13','',''),(3381,'1','306','1',1,'Retail Sale Id 3390',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 10:20:26','',''),(3382,'1','306','1',1,'Retail Sale Id 3391',800.80,0.00,0.00,1.04,108.16,'2023-01-21 10:22:57','',''),(3383,'1','306','1',1,'Retail Sale Id 3392',18250.00,0.00,0.00,25.00,1600.00,'2023-01-21 10:24:01','',''),(3384,'1','306','1',1,'Retail Sale Id 3393',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 10:26:11','',''),(3385,'1','306','1',1,'Retail Sale Id 3394',65700.00,0.00,0.00,90.00,5760.00,'2023-01-21 10:27:07','',''),(3386,'1','306','1',1,'Retail Sale Id 3395',3080.00,0.00,0.00,4.00,416.00,'2023-01-21 10:28:54','',''),(3387,'1','306','1',1,'Retail Sale Id 3396',25550.00,0.00,0.00,35.00,2240.00,'2023-01-21 10:30:58','',''),(3388,'1','306','1',1,'Retail Sale Id 3397',21900.00,0.00,0.00,30.00,1920.00,'2023-01-21 10:34:18','',''),(3389,'1','306','1',1,'Retail Sale Id 3398',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 10:35:11','',''),(3390,'1','306','1',1,'Retail Sale Id 3399',4496.80,0.00,0.00,5.84,607.36,'2023-01-21 10:36:28','',''),(3391,'1','306','1',1,'Retail Sale Id 3400',7700.00,0.00,0.00,10.00,1040.00,'2023-01-21 10:41:26','',''),(3392,'1','306','1',1,'Retail Sale Id 3401',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 10:43:08','',''),(3393,'1','306','1',1,'Retail Sale Id 3402',13870.00,0.00,0.00,19.00,1216.00,'2023-01-21 10:46:25','',''),(3394,'1','306','1',1,'Retail Sale Id 3403',3996.30,0.00,0.00,5.19,539.76,'2023-01-21 10:48:53','',''),(3395,'1','306','1',1,'Retail Sale Id 3404',4620.00,0.00,0.00,6.00,624.00,'2023-01-21 10:50:19','',''),(3396,'1','306','1',1,'Retail Sale Id 3405',3850.00,0.00,0.00,5.00,520.00,'2023-01-21 10:51:30','',''),(3397,'1','306','1',1,'Retail Sale Id 3406',2402.40,0.00,0.00,3.12,324.48,'2023-01-21 10:54:51','',''),(3398,'1','306','1',1,'Retail Sale Id 3407',9625.00,0.00,0.00,12.50,1300.00,'2023-01-21 10:56:02','',''),(3399,'1','306','1',1,'Retail Sale Id 3408',99280.00,0.00,0.00,136.00,8704.00,'2023-01-21 10:59:55','',''),(3400,'1','306','1',1,'Retail Sale Id 3409',3850.00,0.00,0.00,5.00,520.00,'2023-01-21 11:00:58','',''),(3401,'1','306','1',1,'Retail Sale Id 3410',5497.80,0.00,0.00,7.14,742.56,'2023-01-21 11:02:47','',''),(3402,'1','306','1',1,'Retail Sale Id 3411',4596.90,0.00,0.00,5.97,620.88,'2023-01-21 11:03:47','',''),(3403,'1','306','1',1,'Retail Sale Id 3412',3803.80,0.00,0.00,4.94,513.76,'2023-01-21 11:05:04','',''),(3404,'1','306','1',1,'Retail Sale Id 3413',9702.00,0.00,0.00,12.60,1310.40,'2023-01-21 11:09:22','',''),(3405,'1','306','1',1,'Retail Sale Id 3415',3850.00,0.00,0.00,5.00,520.00,'2023-01-21 11:10:41','',''),(3406,'1','306','1',1,'Retail Sale Id 3416',9301.60,0.00,0.00,12.08,1256.32,'2023-01-21 11:11:51','',''),(3407,'1','306','1',1,'Retail Sale Id 3419',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 11:13:25','',''),(3408,'1','306','1',1,'Retail Sale Id 3420',2502.50,0.00,0.00,3.25,338.00,'2023-01-21 11:14:57','',''),(3409,'1','306','1',1,'Retail Sale Id 3421',4697.00,0.00,0.00,6.10,634.40,'2023-01-21 11:21:00','',''),(3410,'1','306','1',1,'Retail Sale Id 3422',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 11:23:37','',''),(3411,'1','306','1',1,'Retail Sale Id 3423',2402.40,0.00,0.00,3.12,324.48,'2023-01-21 11:27:52','',''),(3412,'1','306','1',1,'Retail Sale Id 3424',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 11:32:23','',''),(3413,'1','306','1',1,'Retail Sale Id 3426',9702.00,0.00,0.00,12.60,1310.40,'2023-01-21 11:38:11','',''),(3414,'1','306','1',1,'Retail Sale Id 3427',1601.60,0.00,0.00,2.08,216.32,'2023-01-21 11:39:22','',''),(3415,'1','306','1',1,'Retail Sale Id 3428',4997.30,0.00,0.00,6.49,674.96,'2023-01-21 11:41:36','',''),(3416,'1','306','1',1,'Retail Sale Id 3429',1501.50,0.00,0.00,1.95,202.80,'2023-01-21 11:47:37','',''),(3417,'1','306','1',1,'Retail Sale Id 3430',1540.00,0.00,0.00,2.00,208.00,'2023-01-21 11:48:29','',''),(3418,'1','306','1',1,'Retail Sale Id 3431',6930.00,0.00,0.00,9.00,936.00,'2023-01-21 11:54:19','',''),(3419,'1','306','1',1,'Retail Sale Id 3432',43800.00,0.00,0.00,60.00,3840.00,'2023-01-21 11:55:47','',''),(3420,'1','306','1',1,'Retail Sale Id 3433',4380.00,0.00,0.00,6.00,384.00,'2023-01-21 11:57:10','',''),(3421,'1','306','1',1,'Retail Sale Id 3434',3080.00,0.00,0.00,4.00,416.00,'2023-01-21 11:58:57','',''),(3422,'1','306','1',1,'Retail Sale Id 3435',800.80,0.00,0.00,1.04,108.16,'2023-01-21 11:59:53','',''),(3423,'1','306','1',1,'Retail Sale Id 3436',1601.60,0.00,0.00,2.08,216.32,'2023-01-21 12:03:59','',''),(3424,'1','306','1',1,'Retail Sale Id 3438',3896.20,0.00,0.00,5.06,526.24,'2023-01-21 12:07:44','',''),(3425,'1','306','1',1,'Retail Sale Id 3439',3080.00,0.00,0.00,4.00,416.00,'2023-01-21 12:08:41','',''),(3426,'1','306','1',1,'Retail Sale Id 3440',800.80,0.00,0.00,1.04,108.16,'2023-01-21 12:16:26','',''),(3427,'1','306','1',1,'Retail Sale Id 3441',2502.50,0.00,0.00,3.25,338.00,'2023-01-21 12:17:31','',''),(3428,'1','306','1',1,'Retail Sale Id 3442',1501.50,0.00,0.00,1.95,202.80,'2023-01-21 12:19:21','',''),(3429,'1','306','1',1,'Retail Sale Id 3443',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 12:20:48','',''),(3430,'1','306','1',1,'Retail Sale Id 3444',800.80,0.00,0.00,1.04,108.16,'2023-01-21 12:21:36','',''),(3431,'1','306','1',1,'Retail Sale Id 3445',4496.80,0.00,0.00,5.84,607.36,'2023-01-21 12:25:42','',''),(3432,'1','306','1',1,'Retail Sale Id 3446',3850.00,0.00,0.00,5.00,520.00,'2023-01-21 12:27:52','',''),(3433,'1','306','1',1,'Retail Sale Id 3447',4596.90,0.00,0.00,5.97,620.88,'2023-01-21 12:32:05','',''),(3434,'1','306','1',1,'Retail Sale Id 3449',5497.80,0.00,0.00,7.14,742.56,'2023-01-21 12:33:21','',''),(3435,'1','306','1',1,'Retail Sale Id 3450',3850.00,0.00,0.00,5.00,520.00,'2023-01-21 12:35:58','',''),(3436,'1','306','1',1,'Retail Sale Id 3451',9001.30,0.00,0.00,11.69,1215.76,'2023-01-21 12:37:54','',''),(3437,'1','306','1',1,'Retail Sale Id 3452',1501.50,0.00,0.00,1.95,202.80,'2023-01-21 12:38:39','',''),(3438,'1','306','1',1,'Retail Sale Id 3453',8500.80,0.00,0.00,11.04,1148.16,'2023-01-21 12:40:37','',''),(3439,'1','306','1',1,'Retail Sale Id 3454',1701.70,0.00,0.00,2.21,229.84,'2023-01-21 12:43:32','',''),(3440,'1','306','1',1,'Retail Sale Id 3455',1601.60,0.00,0.00,2.08,216.32,'2023-01-21 12:44:44','',''),(3441,'1','306','1',1,'Retail Sale Id 3456',1540.00,0.00,0.00,2.00,208.00,'2023-01-21 12:50:59','',''),(3442,'1','306','1',1,'Retail Sale Id 3456',1540.00,0.00,0.00,2.00,208.00,'2023-01-21 12:50:59','',''),(3443,'1','306','1',1,'Retail Sale Id 3457',3080.00,0.00,0.00,4.00,416.00,'2023-01-21 12:52:20','',''),(3444,'1','306','1',1,'Retail Sale Id 3458',4620.00,0.00,0.00,6.00,624.00,'2023-01-21 12:53:16','',''),(3445,'1','306','1',1,'Retail Sale Id 3459',2348.50,0.00,0.00,3.05,317.20,'2023-01-21 12:59:12','',''),(3446,'1','306','1',1,'Retail Sale Id 3460',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 13:00:51','',''),(3447,'1','306','1',1,'Retail Sale Id 3461',1540.00,0.00,0.00,2.00,208.00,'2023-01-21 13:03:27','',''),(3448,'1','306','1',1,'Retail Sale Id 3462',3850.00,0.00,0.00,5.00,520.00,'2023-01-21 13:04:56','',''),(3449,'1','306','1',1,'Retail Sale Id 3463',43800.00,0.00,0.00,60.00,3840.00,'2023-01-21 13:12:18','',''),(3450,'1','306','1',1,'Retail Sale Id 3464',3080.00,0.00,0.00,4.00,416.00,'2023-01-21 13:13:55','',''),(3451,'1','306','1',1,'Retail Sale Id 3465',3003.00,0.00,0.00,3.90,405.60,'2023-01-21 13:15:54','',''),(3452,'1','306','1',1,'Return of Retail Sale Id 3465',0.00,3003.00,3.90,0.00,-405.60,'2023-01-21 13:16:22','',''),(3453,'1','306','1',1,'Retail Sale Id 3466',2802.80,0.00,0.00,3.64,378.56,'2023-01-21 13:17:30','',''),(3454,'1','306','1',1,'Retail Sale Id 3467',3896.20,0.00,0.00,5.06,526.24,'2023-01-21 13:18:56','',''),(3455,'1','306','1',1,'Retail Sale Id 3468',2502.50,0.00,0.00,3.25,338.00,'2023-01-21 13:19:38','',''),(3456,'1','306','1',1,'Retail Sale Id 3469',3003.00,0.00,0.00,3.90,405.60,'2023-01-21 13:20:23','',''),(3457,'1','306','1',1,'Retail Sale Id 3471',1547.70,0.00,0.00,2.01,209.04,'2023-01-21 13:24:53','',''),(3458,'1','306','1',1,'Retail Sale Id 3472',4496.80,0.00,0.00,5.84,607.36,'2023-01-21 13:26:22','',''),(3459,'1','306','1',1,'Retail Sale Id 3473',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 13:27:28','',''),(3460,'1','306','1',1,'Retail Sale Id 3474',1601.60,0.00,0.00,2.08,216.32,'2023-01-21 13:28:47','',''),(3461,'1','306','1',1,'Retail Sale Id 3475',8500.80,0.00,0.00,11.04,1148.16,'2023-01-21 13:30:20','',''),(3462,'1','306','1',1,'Retail Sale Id 3476',7700.00,0.00,0.00,10.00,1040.00,'2023-01-21 13:40:20','',''),(3463,'1','306','1',1,'Retail Sale Id 3477',4596.90,0.00,0.00,5.97,620.88,'2023-01-21 13:43:52','',''),(3464,'1','306','1',1,'Retail Sale Id 3478',3080.00,0.00,0.00,4.00,416.00,'2023-01-21 13:45:40','',''),(3465,'1','306','1',1,'Retail Sale Id 3479',1540.00,0.00,0.00,2.00,208.00,'2023-01-21 13:48:29','',''),(3466,'1','306','1',1,'Retail Sale Id 3481',8470.00,0.00,0.00,11.00,1144.00,'2023-01-21 14:02:24','',''),(3467,'1','306','1',1,'Retail Sale Id 3482',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 14:06:47','',''),(3468,'1','306','1',1,'Retail Sale Id 3483',3850.00,0.00,0.00,5.00,520.00,'2023-01-21 14:08:54','',''),(3469,'1','306','1',1,'Retail Sale Id 3484',7700.00,0.00,0.00,10.00,1040.00,'2023-01-21 14:09:46','',''),(3470,'1','306','1',1,'Retail Sale Id 3485',847.00,0.00,0.00,1.10,114.40,'2023-01-21 14:27:04','',''),(3471,'1','306','1',1,'Retail Sale Id 3486',1540.00,0.00,0.00,2.00,208.00,'2023-01-21 14:27:49','',''),(3472,'1','306','1',1,'Retail Sale Id 3487',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 14:33:58','',''),(3473,'1','306','1',1,'Retail Sale Id 3488',3080.00,0.00,0.00,4.00,416.00,'2023-01-21 14:37:09','',''),(3474,'1','306','1',1,'Retail Sale Id 3489',4620.00,0.00,0.00,6.00,624.00,'2023-01-21 14:38:24','',''),(3475,'1','306','1',1,'Retail Sale Id 3490',9501.80,0.00,0.00,12.34,1283.36,'2023-01-21 14:39:55','',''),(3476,'1','306','1',1,'Return of Retail Sale Id 3490',0.00,9501.80,12.34,0.00,-1283.36,'2023-01-21 14:40:34','',''),(3477,'1','306','1',1,'Retail Sale Id 3491',9001.30,0.00,0.00,11.69,1215.76,'2023-01-21 14:41:08','',''),(3478,'1','306','1',1,'Retail Sale Id 3492',7700.00,0.00,0.00,10.00,1040.00,'2023-01-21 14:44:26','',''),(3479,'1','306','1',1,'Retail Sale Id 3493',3850.00,0.00,0.00,5.00,520.00,'2023-01-21 14:45:02','',''),(3480,'1','306','1',1,'Retail Sale Id 3494',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 14:47:58','',''),(3481,'1','306','1',1,'Retail Sale Id 3495',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 14:48:39','',''),(3482,'1','306','1',1,'Retail Sale Id 3496',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 14:55:40','',''),(3483,'1','306','1',1,'Retail Sale Id 3497',1501.50,0.00,0.00,1.95,202.80,'2023-01-21 14:58:18','',''),(3484,'1','306','1',1,'Retail Sale Id 3498',800.80,0.00,0.00,1.04,108.16,'2023-01-21 15:02:05','',''),(3485,'1','306','1',1,'Retail Sale Id 3499',9702.00,0.00,0.00,12.60,1310.40,'2023-01-21 15:03:25','',''),(3486,'1','306','1',1,'Retail Sale Id 3500',800.80,0.00,0.00,1.04,108.16,'2023-01-21 15:04:13','',''),(3487,'1','306','1',1,'Retail Sale Id 3501',1540.00,0.00,0.00,2.00,208.00,'2023-01-21 15:05:09','',''),(3488,'1','306','1',1,'Retail Sale Id 3502',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 15:06:20','',''),(3489,'1','306','1',1,'Retail Sale Id 3503',3080.00,0.00,0.00,4.00,416.00,'2023-01-21 15:12:10','',''),(3490,'1','306','1',1,'Retail Sale Id 3504',4620.00,0.00,0.00,6.00,624.00,'2023-01-21 15:23:05','',''),(3491,'1','306','1',1,'Retail Sale Id 3505',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 15:25:12','',''),(3492,'1','306','1',1,'Retail Sale Id 3506',4697.00,0.00,0.00,6.10,634.40,'2023-01-21 15:26:12','',''),(3493,'1','306','1',1,'Retail Sale Id 3507',3080.00,0.00,0.00,4.00,416.00,'2023-01-21 15:32:32','',''),(3494,'1','306','1',1,'Retail Sale Id 3508',4620.00,0.00,0.00,6.00,624.00,'2023-01-21 15:33:37','',''),(3495,'1','306','1',1,'Retail Sale Id 3510',4697.00,0.00,0.00,6.10,634.40,'2023-01-21 15:42:17','',''),(3496,'1','306','1',1,'Retail Sale Id 3511',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 15:49:35','',''),(3497,'1','306','1',1,'Retail Sale Id 3512',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 15:50:40','',''),(3498,'1','306','1',1,'Retail Sale Id 3513',1540.00,0.00,0.00,2.00,208.00,'2023-01-21 15:53:01','',''),(3499,'1','306','1',1,'Retail Sale Id 3514',3850.00,0.00,0.00,5.00,520.00,'2023-01-21 15:53:45','',''),(3500,'1','306','1',1,'Retail Sale Id 3515',1001.00,0.00,0.00,1.30,135.20,'2023-01-21 15:54:42','',''),(3501,'1','306','1',1,'Retail Sale Id 3515',1001.00,0.00,0.00,1.30,135.20,'2023-01-21 15:54:42','',''),(3502,'1','306','1',1,'Retail Sale Id 3516',3850.00,0.00,0.00,5.00,520.00,'2023-01-21 15:55:46','',''),(3503,'1','306','1',1,'Retail Sale Id 3517',2002.00,0.00,0.00,2.60,270.40,'2023-01-21 15:59:37','',''),(3504,'1','306','1',1,'Retail Sale Id 3517',2002.00,0.00,0.00,2.60,270.40,'2023-01-21 15:59:37','',''),(3505,'1','306','1',1,'Retail Sale Id 3518',4620.00,0.00,0.00,6.00,624.00,'2023-01-21 16:01:49','',''),(3506,'1','306','1',1,'Retail Sale Id 3519',3850.00,0.00,0.00,5.00,520.00,'2023-01-21 16:05:41','',''),(3507,'1','306','1',1,'Retail Sale Id 3519',9625.00,0.00,0.00,12.50,1300.00,'2023-01-21 16:05:41','',''),(3508,'1','306','1',1,'Retail Sale Id 3520',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 16:07:26','',''),(3509,'1','306','1',1,'Retail Sale Id 3521',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 16:08:34','',''),(3510,'1','306','1',1,'Retail Sale Id 3522',4620.00,0.00,0.00,6.00,624.00,'2023-01-21 16:12:47','',''),(3511,'1','306','1',1,'Retail Sale Id 3523',3850.00,0.00,0.00,5.00,520.00,'2023-01-21 16:21:20','',''),(3512,'1','306','1',1,'Retail Sale Id 3524',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 16:22:58','',''),(3513,'1','306','1',1,'Retail Sale Id 3525',2202.20,0.00,0.00,2.86,297.44,'2023-01-21 16:39:06','',''),(3514,'1','306','1',1,'Retail Sale Id 3526',1540.00,0.00,0.00,2.00,208.00,'2023-01-21 16:41:31','',''),(3515,'1','306','1',1,'Retail Sale Id 3526',1540.00,0.00,0.00,2.00,208.00,'2023-01-21 16:41:31','',''),(3516,'1','306','1',1,'Retail Sale Id 3527',3803.80,0.00,0.00,4.94,513.76,'2023-01-21 16:43:00','',''),(3517,'1','306','1',1,'Retail Sale Id 3528',2002.00,0.00,0.00,2.60,270.40,'2023-01-21 16:46:40','',''),(3518,'1','306','1',1,'Retail Sale Id 3529',3080.00,0.00,0.00,4.00,416.00,'2023-01-21 16:51:31','',''),(3519,'1','306','1',1,'Retail Sale Id 3530',20440.00,0.00,0.00,28.00,1792.00,'2023-01-21 16:57:42','',''),(3520,'1','306','1',1,'Retail Sale Id 3531',10002.30,0.00,0.00,12.99,1350.96,'2023-01-21 17:00:18','',''),(3521,'1','306','1',1,'Retail Sale Id 3532',3003.00,0.00,0.00,3.90,405.60,'2023-01-21 17:01:10','',''),(3522,'1','306','1',1,'Retail Sale Id 3533',7700.00,0.00,0.00,10.00,1040.00,'2023-01-21 17:02:21','',''),(3523,'1','306','1',1,'Retail Sale Id 3534',7700.00,0.00,0.00,10.00,1040.00,'2023-01-21 17:03:20','',''),(3524,'1','306','1',1,'Retail Sale Id 3535',3850.00,0.00,0.00,5.00,520.00,'2023-01-21 17:04:09','',''),(3525,'1','306','1',1,'Retail Sale Id 3536',4620.00,0.00,0.00,6.00,624.00,'2023-01-21 17:05:42','',''),(3526,'1','306','1',1,'Retail Sale Id 3538',3080.00,0.00,0.00,4.00,416.00,'2023-01-21 17:07:05','',''),(3527,'1','306','1',1,'Retail Sale Id 3539',2002.00,0.00,0.00,2.60,270.40,'2023-01-21 17:13:07','',''),(3528,'1','306','1',1,'Retail Sale Id 3540',800.80,0.00,0.00,1.04,108.16,'2023-01-21 17:14:02','',''),(3529,'1','306','1',1,'Retail Sale Id 3542',1501.50,0.00,0.00,1.95,202.80,'2023-01-21 17:15:07','',''),(3530,'1','306','1',1,'Retail Sale Id 3543',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 17:16:10','',''),(3531,'1','306','1',1,'Retail Sale Id 3544',1540.00,0.00,0.00,2.00,208.00,'2023-01-21 17:17:27','',''),(3532,'1','306','1',1,'Retail Sale Id 3545',3850.00,0.00,0.00,5.00,520.00,'2023-01-21 17:19:55','',''),(3533,'1','306','1',1,'Retail Sale Id 3546',1540.00,0.00,0.00,2.00,208.00,'2023-01-21 17:21:29','',''),(3534,'1','306','1',1,'Retail Sale Id 3547',4620.00,0.00,0.00,6.00,624.00,'2023-01-21 17:24:44','',''),(3535,'1','306','1',1,'Retail Sale Id 3548',4620.00,0.00,0.00,6.00,624.00,'2023-01-21 17:26:27','',''),(3536,'1','306','1',1,'Retail Sale Id 3549',1540.00,0.00,0.00,2.00,208.00,'2023-01-21 17:27:16','',''),(3537,'1','306','1',1,'Retail Sale Id 3550',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 17:27:55','',''),(3538,'1','306','1',1,'Retail Sale Id 3551',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 17:29:35','',''),(3539,'1','306','1',1,'Retail Sale Id 3552',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 17:31:04','',''),(3540,'1','306','1',1,'Retail Sale Id 3553',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 17:32:07','',''),(3541,'1','306','1',1,'Retail Sale Id 3555',1540.00,0.00,0.00,2.00,208.00,'2023-01-21 17:36:19','',''),(3542,'1','306','1',1,'Retail Sale Id 3556',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 17:37:34','',''),(3543,'1','306','1',1,'Retail Sale Id 3557',800.80,0.00,0.00,1.04,108.16,'2023-01-21 17:39:34','',''),(3544,'1','306','1',1,'Retail Sale Id 3558',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 17:40:55','',''),(3545,'1','306','1',1,'Retail Sale Id 3559',9625.00,0.00,0.00,12.50,1300.00,'2023-01-21 17:44:08','',''),(3546,'1','306','1',1,'Retail Sale Id 3560',1540.00,0.00,0.00,2.00,208.00,'2023-01-21 17:45:06','',''),(3547,'1','306','1',1,'Retail Sale Id 3561',7700.00,0.00,0.00,10.00,1040.00,'2023-01-21 17:47:35','',''),(3548,'1','306','1',1,'Retail Sale Id 3562',2302.30,0.00,0.00,2.99,310.96,'2023-01-21 17:48:44','',''),(3549,'1','306','1',1,'Retail Sale Id 3563',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 17:53:18','',''),(3550,'1','306','1',1,'Retail Sale Id 3564',4620.00,0.00,0.00,6.00,624.00,'2023-01-21 17:59:11','',''),(3551,'1','306','1',1,'Retail Sale Id 3565',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 18:06:51','',''),(3552,'1','306','1',1,'Retail Sale Id 3566',4620.00,0.00,0.00,6.00,624.00,'2023-01-21 18:11:07','',''),(3553,'1','306','1',1,'Retail Sale Id 3567',600.60,0.00,0.00,0.78,81.12,'2023-01-21 18:11:55','',''),(3554,'1','306','1',1,'Retail Sale Id 3568',4496.80,0.00,0.00,5.84,607.36,'2023-01-21 18:12:45','',''),(3555,'1','306','1',1,'Retail Sale Id 3569',2310.00,0.00,0.00,3.00,312.00,'2023-01-21 18:14:16','',''),(3556,'1','306','1',1,'Retail Sale Id 3570',2802.80,0.00,0.00,3.64,378.56,'2023-01-21 18:16:24','',''),(3557,'1','306','1',1,'Retail Sale Id 3571',4697.00,0.00,0.00,6.10,634.40,'2023-01-21 18:22:21','',''),(3558,'1','306','1',1,'Retail Sale Id 3572',4620.00,0.00,0.00,6.00,624.00,'2023-01-21 18:30:52','',''),(3559,'1','306','1',1,'Return of Retail Sale Id 3572',0.00,4620.00,6.00,0.00,-624.00,'2023-01-21 18:48:04','',''),(3560,'1','306','1',1,'Return of Retail Sale Id 3566',0.00,4620.00,6.00,0.00,-624.00,'2023-01-21 18:48:33','',''),(3561,'1','306','1',1,'Return of Retail Sale Id 3559',0.00,9625.00,12.50,0.00,-1300.00,'2023-01-21 18:49:00','',''),(3562,'1','306','1',1,'Retail Sale Id 3573',12912.90,0.00,0.00,16.77,1744.08,'2023-01-21 18:50:12','',''),(3563,'1','306','1',1,'Retail Sale Id 3574',4596.90,0.00,0.00,5.97,620.88,'2023-01-22 07:25:19','',''),(3564,'1','306','1',1,'Retail Sale Id 3575',4496.80,0.00,0.00,5.84,607.36,'2023-01-22 07:47:39','',''),(3565,'1','306','1',1,'Retail Sale Id 3576',3103.10,0.00,0.00,4.03,419.12,'2023-01-22 08:04:36','',''),(3566,'1','306','1',1,'Retail Sale Id 3578',2310.00,0.00,0.00,3.00,312.00,'2023-01-22 08:07:14','',''),(3567,'1','306','1',1,'Retail Sale Id 3579',2502.50,0.00,0.00,3.25,338.00,'2023-01-22 08:18:56','',''),(3568,'1','306','1',1,'Retail Sale Id 3580',3996.30,0.00,0.00,5.19,539.76,'2023-01-22 08:20:15','',''),(3569,'1','306','1',1,'Retail Sale Id 3581',4650.80,0.00,0.00,6.04,628.16,'2023-01-22 08:31:45','',''),(3570,'1','306','1',1,'Retail Sale Id 3582',11315.00,0.00,0.00,15.50,992.00,'2023-01-22 08:33:30','',''),(3571,'1','306','1',1,'Retail Sale Id 3583',1501.50,0.00,0.00,1.95,202.80,'2023-01-22 08:35:23','',''),(3572,'1','306','1',1,'Retail Sale Id 3584',2002.00,0.00,0.00,2.60,270.40,'2023-01-22 08:36:20','',''),(3573,'1','306','1',1,'Retail Sale Id 3585',1601.60,0.00,0.00,2.08,216.32,'2023-01-22 08:49:07','',''),(3574,'1','306','1',1,'Retail Sale Id 3586',2502.50,0.00,0.00,3.25,338.00,'2023-01-22 08:50:16','',''),(3575,'1','306','1',1,'Retail Sale Id 3587',2002.00,0.00,0.00,2.60,270.40,'2023-01-22 08:52:09','',''),(3576,'1','306','1',1,'Retail Sale Id 3588',2310.00,0.00,0.00,3.00,312.00,'2023-01-22 09:09:53','',''),(3577,'1','306','1',1,'Retail Sale Id 3589',4620.00,0.00,0.00,6.00,624.00,'2023-01-22 09:18:21','',''),(3578,'1','306','1',1,'Retail Sale Id 3590',3080.00,0.00,0.00,4.00,416.00,'2023-01-22 09:20:01','',''),(3579,'1','306','1',1,'Retail Sale Id 3591',2002.00,0.00,0.00,2.60,270.40,'2023-01-22 09:21:17','',''),(3580,'1','306','1',1,'Retail Sale Id 3592',1501.50,0.00,0.00,1.95,202.80,'2023-01-22 09:26:55','',''),(3581,'1','306','1',1,'Retail Sale Id 3593',800.80,0.00,0.00,1.04,108.16,'2023-01-22 09:45:26','',''),(3582,'1','306','1',1,'Retail Sale Id 3594',2310.00,0.00,0.00,3.00,312.00,'2023-01-22 09:46:36','',''),(3583,'1','306','1',1,'Retail Sale Id 3595',800.80,0.00,0.00,1.04,108.16,'2023-01-22 09:49:01','',''),(3584,'1','306','1',1,'Retail Sale Id 3596',3103.10,0.00,0.00,4.03,419.12,'2023-01-22 10:05:02','',''),(3585,'1','306','1',1,'Retail Sale Id 3597',3080.00,0.00,0.00,4.00,416.00,'2023-01-22 10:17:29','',''),(3586,'1','306','1',1,'Retail Sale Id 3598',10002.30,0.00,0.00,12.99,1350.96,'2023-01-22 10:30:03','',''),(3587,'1','306','1',1,'Retail Sale Id 3600',1501.50,0.00,0.00,1.95,202.80,'2023-01-22 10:48:26','',''),(3588,'1','306','1',1,'Retail Sale Id 3601',2310.00,0.00,0.00,3.00,312.00,'2023-01-22 10:59:31','',''),(3589,'1','306','1',1,'Retail Sale Id 3602',2310.00,0.00,0.00,3.00,312.00,'2023-01-22 11:00:13','',''),(3590,'1','306','1',1,'Retail Sale Id 3603',1540.00,0.00,0.00,2.00,208.00,'2023-01-22 11:06:22','',''),(3591,'1','306','1',1,'Retail Sale Id 3604',3103.10,0.00,0.00,4.03,419.12,'2023-01-22 11:08:36','',''),(3592,'1','306','1',1,'Retail Sale Id 3605',800.80,0.00,0.00,1.04,108.16,'2023-01-22 11:21:12','',''),(3593,'1','306','1',1,'Retail Sale Id 3606',1001.00,0.00,0.00,1.30,135.20,'2023-01-22 11:23:18','',''),(3594,'1','306','1',1,'Retail Sale Id 3607',1540.00,0.00,0.00,2.00,208.00,'2023-01-22 11:24:51','',''),(3595,'1','306','1',1,'Retail Sale Id 3608',2310.00,0.00,0.00,3.00,312.00,'2023-01-22 11:26:01','',''),(3596,'1','306','1',1,'Retail Sale Id 3609',2302.30,0.00,0.00,2.99,310.96,'2023-01-22 11:35:04','',''),(3597,'1','306','1',1,'Retail Sale Id 3610',4620.00,0.00,0.00,6.00,624.00,'2023-01-22 11:39:13','',''),(3598,'1','306','1',1,'Retail Sale Id 3611',1540.00,0.00,0.00,2.00,208.00,'2023-01-22 11:41:28','',''),(3599,'1','306','1',1,'Retail Sale Id 3612',5390.00,0.00,0.00,7.00,728.00,'2023-01-22 11:55:43','',''),(3600,'1','306','1',1,'Retail Sale Id 3613',2310.00,0.00,0.00,3.00,312.00,'2023-01-22 11:59:08','',''),(3601,'1','306','1',1,'Retail Sale Id 3615',2310.00,0.00,0.00,3.00,312.00,'2023-01-22 12:04:24','',''),(3602,'1','306','1',1,'Retail Sale Id 3616',3850.00,0.00,0.00,5.00,520.00,'2023-01-22 12:06:06','',''),(3603,'1','306','1',1,'Retail Sale Id 3617',1501.50,0.00,0.00,1.95,202.80,'2023-01-22 12:07:19','',''),(3604,'1','306','1',1,'Retail Sale Id 3618',4620.00,0.00,0.00,6.00,624.00,'2023-01-22 12:12:41','',''),(3605,'1','306','1',1,'Retail Sale Id 3619',1540.00,0.00,0.00,2.00,208.00,'2023-01-22 12:13:59','',''),(3606,'1','306','1',1,'Retail Sale Id 3620',1540.00,0.00,0.00,2.00,208.00,'2023-01-22 12:17:18','',''),(3607,'1','306','1',1,'Retail Sale Id 3621',1540.00,0.00,0.00,2.00,208.00,'2023-01-22 12:21:51','',''),(3608,'1','306','1',1,'Retail Sale Id 3622',8000.30,0.00,0.00,10.39,1080.56,'2023-01-22 12:23:14','',''),(3609,'1','306','1',1,'Retail Sale Id 3623',9625.00,0.00,0.00,12.50,1300.00,'2023-01-22 12:25:43','',''),(3610,'1','306','1',1,'Retail Sale Id 3624',800.80,0.00,0.00,1.04,108.16,'2023-01-22 12:27:33','',''),(3611,'1','306','1',1,'Retail Sale Id 3625',770.00,0.00,0.00,1.00,104.00,'2023-01-22 12:31:13','',''),(3612,'1','306','1',1,'Retail Sale Id 3627',10002.30,0.00,0.00,12.99,1350.96,'2023-01-22 12:34:13','',''),(3613,'1','306','1',1,'Retail Sale Id 3628',1001.00,0.00,0.00,1.30,135.20,'2023-01-22 12:36:14','',''),(3614,'1','306','1',1,'Retail Sale Id 3629',2310.00,0.00,0.00,3.00,312.00,'2023-01-22 12:56:47','',''),(3615,'1','306','1',1,'Retail Sale Id 3630',3850.00,0.00,0.00,5.00,520.00,'2023-01-22 13:00:09','',''),(3616,'1','306','1',1,'Retail Sale Id 3631',1601.60,0.00,0.00,2.08,216.32,'2023-01-22 13:02:41','',''),(3617,'1','306','1',1,'Retail Sale Id 3632',800.80,0.00,0.00,1.04,108.16,'2023-01-22 13:04:24','',''),(3618,'1','306','1',1,'Retail Sale Id 3633',3850.00,0.00,0.00,5.00,520.00,'2023-01-22 13:05:56','',''),(3619,'1','306','1',1,'Retail Sale Id 3634',2310.00,0.00,0.00,3.00,312.00,'2023-01-22 13:07:38','',''),(3620,'1','306','1',1,'Retail Sale Id 3635',3803.80,0.00,0.00,4.94,513.76,'2023-01-22 13:08:59','',''),(3621,'1','306','1',1,'Retail Sale Id 3636',2310.00,0.00,0.00,3.00,312.00,'2023-01-22 13:14:35','',''),(3622,'1','306','1',1,'Retail Sale Id 3637',4620.00,0.00,0.00,6.00,624.00,'2023-01-22 13:21:14','',''),(3623,'1','306','1',1,'Retail Sale Id 3638',3996.30,0.00,0.00,5.19,539.76,'2023-01-22 13:22:43','',''),(3624,'1','306','1',1,'Retail Sale Id 3639',3080.00,0.00,0.00,4.00,416.00,'2023-01-22 13:23:33','',''),(3625,'1','306','1',1,'Retail Sale Id 3640',2310.00,0.00,0.00,3.00,312.00,'2023-01-22 13:47:55','',''),(3626,'1','306','1',1,'Retail Sale Id 3641',1540.00,0.00,0.00,2.00,208.00,'2023-01-22 13:49:10','',''),(3627,'1','306','1',1,'Retail Sale Id 3642',1540.00,0.00,0.00,2.00,208.00,'2023-01-22 13:51:50','',''),(3628,'1','306','1',1,'Retail Sale Id 3643',2310.00,0.00,0.00,3.00,312.00,'2023-01-22 13:54:32','',''),(3629,'1','306','1',1,'Retail Sale Id 3644',9625.00,0.00,0.00,12.50,1300.00,'2023-01-22 13:55:43','',''),(3630,'1','306','1',1,'Retail Sale Id 3645',9240.00,0.00,0.00,12.00,1248.00,'2023-01-22 14:05:50','',''),(3631,'1','306','1',1,'Retail Sale Id 3646',2310.00,0.00,0.00,3.00,312.00,'2023-01-22 14:09:33','',''),(3632,'1','306','1',1,'Retail Sale Id 3647',4643.10,0.00,0.00,6.03,627.12,'2023-01-22 14:22:25','',''),(3633,'1','306','1',1,'Return of Retail Sale Id 3647',0.00,4643.10,6.03,0.00,-627.12,'2023-01-22 14:22:58','',''),(3634,'1','306','1',1,'Retail Sale Id 3649',4697.00,0.00,0.00,6.10,634.40,'2023-01-22 14:23:51','',''),(3635,'1','306','1',1,'Retail Sale Id 3650',1540.00,0.00,0.00,2.00,208.00,'2023-01-22 14:24:45','',''),(3636,'1','306','1',1,'Retail Sale Id 3652',5197.50,0.00,0.00,6.75,702.00,'2023-01-22 14:31:09','',''),(3637,'1','306','1',1,'Retail Sale Id 3653',9625.00,0.00,0.00,12.50,1300.00,'2023-01-22 14:53:31','',''),(3638,'1','306','1',1,'Retail Sale Id 3654',2302.30,0.00,0.00,2.99,310.96,'2023-01-22 15:07:21','',''),(3639,'1','306','1',1,'Retail Sale Id 3655',2302.30,0.00,0.00,2.99,310.96,'2023-01-22 15:10:26','',''),(3640,'1','306','1',1,'Retail Sale Id 3656',2302.30,0.00,0.00,2.99,310.96,'2023-01-22 15:16:42','',''),(3641,'1','306','1',1,'Retail Sale Id 3657',4596.90,0.00,0.00,5.97,620.88,'2023-01-22 15:40:16','',''),(3642,'1','306','1',1,'Retail Sale Id 3658',4620.00,0.00,0.00,6.00,624.00,'2023-01-22 15:41:44','',''),(3643,'1','306','1',1,'Retail Sale Id 3659',19710.00,0.00,0.00,27.00,1728.00,'2023-01-22 15:44:42','',''),(3644,'1','306','1',1,'Retail Sale Id 3660',770.00,0.00,0.00,1.00,104.00,'2023-01-22 15:54:46','',''),(3645,'1','306','1',1,'Retail Sale Id 3661',2302.30,0.00,0.00,2.99,310.96,'2023-01-22 16:13:54','',''),(3646,'1','306','1',1,'Retail Sale Id 3662',4697.00,0.00,0.00,6.10,634.40,'2023-01-22 16:19:50','',''),(3647,'1','306','1',1,'Retail Sale Id 3663',4697.00,0.00,0.00,6.10,634.40,'2023-01-22 16:23:35','',''),(3648,'1','306','1',1,'Retail Sale Id 3664',4596.90,0.00,0.00,5.97,620.88,'2023-01-22 16:27:20','',''),(3649,'1','306','1',1,'Retail Sale Id 3665',6999.30,0.00,0.00,9.09,945.36,'2023-01-22 16:30:54','',''),(3650,'1','306','1',1,'Retail Sale Id 3666',3080.00,0.00,0.00,4.00,416.00,'2023-01-22 16:34:18','',''),(3651,'1','306','1',1,'Retail Sale Id 3666',9625.00,0.00,0.00,12.50,1300.00,'2023-01-22 16:34:18','',''),(3652,'1','306','1',1,'Retail Sale Id 3667',9501.80,0.00,0.00,12.34,1283.36,'2023-01-22 16:35:35','',''),(3653,'1','306','1',1,'Retail Sale Id 3668',1501.50,0.00,0.00,1.95,202.80,'2023-01-22 16:40:50','',''),(3654,'1','306','1',1,'Retail Sale Id 3669',2002.00,0.00,0.00,2.60,270.40,'2023-01-22 16:41:31','',''),(3655,'1','306','1',1,'Retail Sale Id 3670',2310.00,0.00,0.00,3.00,312.00,'2023-01-22 16:48:53','',''),(3656,'1','306','1',1,'Retail Sale Id 3671',3103.10,0.00,0.00,4.03,419.12,'2023-01-22 16:55:22','',''),(3657,'1','306','1',1,'Retail Sale Id 3672',2302.30,0.00,0.00,2.99,310.96,'2023-01-22 16:56:08','',''),(3658,'1','306','1',1,'Retail Sale Id 3673',1540.00,0.00,0.00,2.00,208.00,'2023-01-22 16:57:10','',''),(3659,'1','306','1',1,'Retail Sale Id 3674',2302.30,0.00,0.00,2.99,310.96,'2023-01-22 16:58:36','',''),(3660,'1','306','1',1,'Retail Sale Id 3675',770.00,0.00,0.00,1.00,104.00,'2023-01-22 17:02:12','',''),(3661,'1','306','1',1,'Retail Sale Id 3676',9702.00,0.00,0.00,12.60,1310.40,'2023-01-22 17:04:14','',''),(3662,'1','306','1',1,'Retail Sale Id 3677',2310.00,0.00,0.00,3.00,312.00,'2023-01-22 17:06:40','',''),(3663,'1','306','1',1,'Retail Sale Id 3678',2310.00,0.00,0.00,3.00,312.00,'2023-01-22 17:14:23','',''),(3664,'1','306','1',1,'Retail Sale Id 3679',900.90,0.00,0.00,1.17,121.68,'2023-01-22 17:15:44','',''),(3665,'1','306','1',1,'Retail Sale Id 3679',1801.80,0.00,0.00,2.34,243.36,'2023-01-22 17:15:44','',''),(3666,'1','306','1',1,'Retail Sale Id 3680',800.80,0.00,0.00,1.04,108.16,'2023-01-22 17:16:58','',''),(3667,'1','306','1',1,'Retail Sale Id 3681',4620.00,0.00,0.00,6.00,624.00,'2023-01-22 17:29:31','',''),(3668,'1','306','1',1,'Retail Sale Id 3682',800.80,0.00,0.00,1.04,108.16,'2023-01-22 17:32:04','',''),(3669,'1','306','1',1,'Retail Sale Id 3684',3896.20,0.00,0.00,5.06,526.24,'2023-01-22 17:34:09','',''),(3670,'1','306','1',1,'Retail Sale Id 3685',1001.00,0.00,0.00,1.30,135.20,'2023-01-22 17:35:01','',''),(3671,'1','306','1',1,'Retail Sale Id 3686',2002.00,0.00,0.00,2.60,270.40,'2023-01-22 17:41:47','',''),(3672,'1','306','1',1,'Retail Sale Id 3687',2502.50,0.00,0.00,3.25,338.00,'2023-01-22 17:43:49','',''),(3673,'1','306','1',1,'Retail Sale Id 3688',4697.00,0.00,0.00,6.10,634.40,'2023-01-22 17:49:54','',''),(3674,'1','306','1',1,'Retail Sale Id 3689',2310.00,0.00,0.00,3.00,312.00,'2023-01-22 18:01:30','',''),(3675,'1','306','1',1,'Retail Sale Id 3689',2310.00,0.00,0.00,3.00,312.00,'2023-01-22 18:01:30','',''),(3676,'1','306','1',1,'Retail Sale Id 3689',2310.00,0.00,0.00,3.00,312.00,'2023-01-22 18:01:30','',''),(3677,'1','306','1',1,'Retail Sale Id 3690',2310.00,0.00,0.00,3.00,312.00,'2023-01-22 18:08:03','',''),(3678,'1','306','1',1,'Retail Sale Id 3691',1540.00,0.00,0.00,2.00,208.00,'2023-01-22 18:09:16','',''),(3679,'1','306','1',1,'Retail Sale Id 3692',5390.00,0.00,0.00,7.00,728.00,'2023-01-22 18:10:15','',''),(3680,'1','306','1',1,'Retail Sale Id 3693',4620.00,0.00,0.00,6.00,624.00,'2023-01-22 18:11:44','',''),(3681,'1','306','1',1,'Retail Sale Id 3694',4620.00,0.00,0.00,6.00,624.00,'2023-01-22 18:19:21','',''),(3682,'1','306','1',1,'Retail Sale Id 3695',4997.30,0.00,0.00,6.49,674.96,'2023-01-22 18:25:34','',''),(3683,'1','306','1',1,'Return of Retail Sale Id 3690',0.00,2310.00,3.00,0.00,-312.00,'2023-01-22 18:36:11','',''),(3684,'1','306','1',1,'Return of Retail Sale Id 3687',0.00,2502.50,3.25,0.00,-338.00,'2023-01-22 18:36:39','',''),(3685,'1','306','1',1,'Retail Sale Id 3696',4766.30,0.00,0.00,6.19,643.76,'2023-01-22 18:38:27','',''),(3686,'1','306','1',1,'Retail Sale Id 3697',3996.30,0.00,0.00,5.19,539.76,'2023-01-23 07:18:55','',''),(3687,'1','306','1',1,'Retail Sale Id 3698',2310.00,0.00,0.00,3.00,312.00,'2023-01-23 07:43:06','',''),(3688,'1','306','1',1,'Retail Sale Id 3699',9625.00,0.00,0.00,12.50,1300.00,'2023-01-23 07:57:18','',''),(3689,'1','306','1',1,'Retail Sale Id 3700',4596.90,0.00,0.00,5.97,620.88,'2023-01-23 08:04:04','',''),(3690,'1','306','1',1,'Retail Sale Id 3701',3003.00,0.00,0.00,3.90,405.60,'2023-01-23 08:08:18','',''),(3691,'1','306','1',1,'Retail Sale Id 3702',8000.30,0.00,0.00,10.39,1080.56,'2023-01-23 08:09:25','',''),(3692,'1','306','1',1,'Retail Sale Id 3703',9702.00,0.00,0.00,12.60,1310.40,'2023-01-23 08:17:54','',''),(3693,'1','306','1',1,'Retail Sale Id 3704',9501.80,0.00,0.00,12.34,1283.36,'2023-01-23 08:19:23','',''),(3694,'1','306','1',1,'Retail Sale Id 3705',3503.50,0.00,0.00,4.55,473.20,'2023-01-23 08:20:26','',''),(3695,'1','306','1',1,'Retail Sale Id 3706',1501.50,0.00,0.00,1.95,202.80,'2023-01-23 08:21:47','',''),(3696,'1','306','1',1,'Retail Sale Id 3707',3503.50,0.00,0.00,4.55,473.20,'2023-01-23 08:30:11','',''),(3697,'1','306','1',1,'Retail Sale Id 3708',2302.30,0.00,0.00,2.99,310.96,'2023-01-23 08:31:14','',''),(3698,'1','306','1',1,'Retail Sale Id 3709',3996.30,0.00,0.00,5.19,539.76,'2023-01-23 08:33:17','',''),(3699,'1','306','1',1,'Retail Sale Id 3710',1501.50,0.00,0.00,1.95,202.80,'2023-01-23 08:39:03','',''),(3700,'1','306','1',1,'Retail Sale Id 3711',9625.00,0.00,0.00,12.50,1300.00,'2023-01-23 08:42:42','',''),(3701,'1','306','1',1,'Retail Sale Id 3712',9201.50,0.00,0.00,11.95,1242.80,'2023-01-23 08:44:07','',''),(3702,'1','306','1',1,'Retail Sale Id 3713',800.80,0.00,0.00,1.04,108.16,'2023-01-23 08:55:07','',''),(3703,'1','306','1',1,'Retail Sale Id 3714',3850.00,0.00,0.00,5.00,520.00,'2023-01-23 08:56:10','',''),(3704,'1','306','1',1,'Retail Sale Id 3715',2302.30,0.00,0.00,2.99,310.96,'2023-01-23 08:57:18','',''),(3705,'1','306','1',1,'Retail Sale Id 3716',4496.80,0.00,0.00,5.84,607.36,'2023-01-23 09:20:51','',''),(3706,'1','306','1',1,'Retail Sale Id 3717',2310.00,0.00,0.00,3.00,312.00,'2023-01-23 09:22:09','',''),(3707,'1','306','1',1,'Retail Sale Id 3718',10002.30,0.00,0.00,12.99,1350.96,'2023-01-23 09:23:21','',''),(3708,'1','306','1',1,'Retail Sale Id 3719',3850.00,0.00,0.00,5.00,520.00,'2023-01-23 09:28:17','',''),(3709,'1','306','1',1,'Retail Sale Id 3720',800.80,0.00,0.00,1.04,108.16,'2023-01-23 09:36:37','',''),(3710,'1','306','1',1,'Retail Sale Id 3721',2002.00,0.00,0.00,2.60,270.40,'2023-01-23 09:42:55','',''),(3711,'1','306','1',1,'Retail Sale Id 3722',3996.30,0.00,0.00,5.19,539.76,'2023-01-23 09:44:17','',''),(3712,'1','306','1',1,'Retail Sale Id 3723',5397.70,0.00,0.00,7.01,729.04,'2023-01-23 09:47:34','',''),(3713,'1','306','1',1,'Retail Sale Id 3724',2302.30,0.00,0.00,2.99,310.96,'2023-01-23 09:50:04','',''),(3714,'1','306','1',1,'Retail Sale Id 3725',4496.80,0.00,0.00,5.84,607.36,'2023-01-23 09:51:41','',''),(3715,'1','306','1',1,'Retail Sale Id 3726',2302.30,0.00,0.00,2.99,310.96,'2023-01-23 09:55:03','',''),(3716,'1','306','1',1,'Retail Sale Id 3727',2310.00,0.00,0.00,3.00,312.00,'2023-01-23 10:03:59','',''),(3717,'1','306','1',1,'Retail Sale Id 3728',7700.00,0.00,0.00,10.00,1040.00,'2023-01-23 10:05:44','',''),(3718,'1','306','1',1,'Retail Sale Id 3729',770.00,0.00,0.00,1.00,104.00,'2023-01-23 10:12:41','',''),(3719,'1','306','1',1,'Retail Sale Id 3730',2302.30,0.00,0.00,2.99,310.96,'2023-01-23 10:15:11','',''),(3720,'1','306','1',1,'Retail Sale Id 3731',1501.50,0.00,0.00,1.95,202.80,'2023-01-23 10:17:49','',''),(3721,'1','306','1',1,'Retail Sale Id 3732',4620.00,0.00,0.00,6.00,624.00,'2023-01-23 10:21:14','',''),(3722,'1','306','1',1,'Retail Sale Id 3733',3996.30,0.00,0.00,5.19,539.76,'2023-01-23 10:22:10','',''),(3723,'1','306','1',1,'Retail Sale Id 3734',2302.30,0.00,0.00,2.99,310.96,'2023-01-23 10:23:10','',''),(3724,'1','306','1',1,'Retail Sale Id 3735',3850.00,0.00,0.00,5.00,520.00,'2023-01-23 10:24:20','',''),(3725,'1','306','1',1,'Retail Sale Id 3736',2310.00,0.00,0.00,3.00,312.00,'2023-01-23 10:25:34','',''),(3726,'1','306','1',1,'Retail Sale Id 3737',1501.50,0.00,0.00,1.95,202.80,'2023-01-23 10:26:43','',''),(3727,'1','306','1',1,'Retail Sale Id 3738',3850.00,0.00,0.00,5.00,520.00,'2023-01-23 10:27:42','',''),(3728,'1','306','1',1,'Retail Sale Id 3739',2310.00,0.00,0.00,3.00,312.00,'2023-01-23 10:50:02','',''),(3729,'1','306','1',1,'Retail Sale Id 3740',4620.00,0.00,0.00,6.00,624.00,'2023-01-23 10:51:04','',''),(3730,'1','306','1',1,'Retail Sale Id 3741',3080.00,0.00,0.00,4.00,416.00,'2023-01-23 11:03:58','',''),(3731,'1','306','1',1,'Retail Sale Id 3742',700.70,0.00,0.00,0.91,94.64,'2023-01-23 11:10:18','',''),(3732,'1','306','1',1,'Retail Sale Id 3743',19710.00,0.00,0.00,27.00,1728.00,'2023-01-23 11:16:08','',''),(3733,'1','306','1',1,'Retail Sale Id 3744',1501.50,0.00,0.00,1.95,202.80,'2023-01-23 11:18:42','',''),(3734,'1','306','1',1,'Retail Sale Id 3745',9625.00,0.00,0.00,12.50,1300.00,'2023-01-23 11:24:29','',''),(3735,'1','306','1',1,'Retail Sale Id 3746',3103.10,0.00,0.00,4.03,419.12,'2023-01-23 11:26:22','',''),(3736,'1','306','1',1,'Retail Sale Id 3747',1547.70,0.00,0.00,2.01,209.04,'2023-01-23 11:27:09','',''),(3737,'1','306','1',1,'Retail Sale Id 3748',2302.30,0.00,0.00,2.99,310.96,'2023-01-23 11:40:14','',''),(3738,'1','306','1',1,'Retail Sale Id 3749',1501.50,0.00,0.00,1.95,202.80,'2023-01-23 11:41:05','',''),(3739,'1','306','1',1,'Retail Sale Id 3750',3003.00,0.00,0.00,3.90,405.60,'2023-01-23 11:41:47','',''),(3740,'1','306','1',1,'Retail Sale Id 3751',2302.30,0.00,0.00,2.99,310.96,'2023-01-23 11:42:46','',''),(3741,'1','306','1',1,'Retail Sale Id 3752',3896.20,0.00,0.00,5.06,526.24,'2023-01-23 11:44:36','',''),(3742,'1','306','1',1,'Retail Sale Id 3753',2402.40,0.00,0.00,3.12,324.48,'2023-01-23 11:45:30','',''),(3743,'1','306','1',1,'Retail Sale Id 3754',500.50,0.00,0.00,0.65,67.60,'2023-01-23 11:48:30','',''),(3744,'1','306','1',1,'Retail Sale Id 3755',9648.10,0.00,0.00,12.53,1303.12,'2023-01-23 12:03:11','',''),(3745,'1','306','1',1,'Retail Sale Id 3756',7800.10,0.00,0.00,10.13,1053.52,'2023-01-23 12:09:08','',''),(3746,'1','306','1',1,'Retail Sale Id 3757',3080.00,0.00,0.00,4.00,416.00,'2023-01-23 12:10:39','',''),(3747,'1','306','1',1,'Retail Sale Id 3758',186880.00,0.00,0.00,256.00,16384.00,'2023-01-23 12:14:37','',''),(3748,'1','306','1',1,'Retail Sale Id 3759',68985.00,0.00,0.00,94.50,6048.00,'2023-01-23 12:20:14','',''),(3749,'1','306','1',1,'Retail Sale Id 3760',9625.00,0.00,0.00,12.50,1300.00,'2023-01-23 12:21:53','',''),(3750,'1','306','1',1,'Retail Sale Id 3761',4596.90,0.00,0.00,5.97,620.88,'2023-01-23 12:23:13','',''),(3751,'1','306','1',1,'Retail Sale Id 3762',2310.00,0.00,0.00,3.00,312.00,'2023-01-23 12:24:06','',''),(3752,'1','306','1',1,'Retail Sale Id 3763',800.80,0.00,0.00,1.04,108.16,'2023-01-23 12:29:16','',''),(3753,'1','306','1',1,'Retail Sale Id 3764',1540.00,0.00,0.00,2.00,208.00,'2023-01-23 12:36:46','',''),(3754,'1','306','1',1,'Retail Sale Id 3765',4620.00,0.00,0.00,6.00,624.00,'2023-01-23 12:39:12','',''),(3755,'1','306','1',1,'Retail Sale Id 3766',8470.00,0.00,0.00,11.00,1144.00,'2023-01-23 12:45:11','',''),(3756,'1','306','1',1,'Retail Sale Id 3767',5497.80,0.00,0.00,7.14,742.56,'2023-01-23 12:46:53','',''),(3757,'1','306','1',1,'Retail Sale Id 3768',9625.00,0.00,0.00,12.50,1300.00,'2023-01-23 13:00:07','',''),(3758,'1','306','1',1,'Retail Sale Id 3768',9625.00,0.00,0.00,12.50,1300.00,'2023-01-23 13:00:07','',''),(3759,'1','306','1',1,'Retail Sale Id 3769',73000.00,0.00,0.00,100.00,6400.00,'2023-01-23 13:09:01','',''),(3760,'1','306','1',1,'Retail Sale Id 3771',746.90,0.00,0.00,0.97,100.88,'2023-01-23 13:10:31','',''),(3761,'1','306','1',1,'Retail Sale Id 3772',1501.50,0.00,0.00,1.95,202.80,'2023-01-23 13:11:44','',''),(3762,'1','306','1',1,'Retail Sale Id 3773',4496.80,0.00,0.00,5.84,607.36,'2023-01-23 13:12:51','',''),(3763,'1','306','1',1,'Retail Sale Id 3774',1501.50,0.00,0.00,1.95,202.80,'2023-01-23 13:20:57','',''),(3764,'1','306','1',1,'Retail Sale Id 3775',3996.30,0.00,0.00,5.19,539.76,'2023-01-23 13:21:43','',''),(3765,'1','306','1',1,'Retail Sale Id 3777',3103.10,0.00,0.00,4.03,419.12,'2023-01-23 13:29:33','',''),(3766,'1','306','1',1,'Retail Sale Id 3778',9625.00,0.00,0.00,12.50,1300.00,'2023-01-23 13:36:39','',''),(3767,'1','306','1',1,'Retail Sale Id 3779',4620.00,0.00,0.00,6.00,624.00,'2023-01-23 13:37:55','',''),(3768,'1','306','1',1,'Retail Sale Id 3780',4620.00,0.00,0.00,6.00,624.00,'2023-01-23 13:39:06','',''),(3769,'1','306','1',1,'Retail Sale Id 3781',2310.00,0.00,0.00,3.00,312.00,'2023-01-23 13:40:39','',''),(3770,'1','306','1',1,'Retail Sale Id 3782',4496.80,0.00,0.00,5.84,607.36,'2023-01-23 13:42:09','',''),(3771,'1','306','1',1,'Retail Sale Id 3783',4620.00,0.00,0.00,6.00,624.00,'2023-01-23 13:43:49','',''),(3772,'1','306','1',1,'Retail Sale Id 3784',3996.30,0.00,0.00,5.19,539.76,'2023-01-23 13:55:54','',''),(3773,'1','306','1',1,'Retail Sale Id 3785',3003.00,0.00,0.00,3.90,405.60,'2023-01-23 15:04:46','',''),(3774,'1','306','1',1,'Retail Sale Id 3786',1309.00,0.00,0.00,1.70,176.80,'2023-01-23 15:32:03','',''),(3775,'1','306',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,37675.62,56.57,0.00,0.00,'2023-01-23 15:48:48','',''),(3776,'1','306',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,56.57,0.00,'2023-01-23 15:49:54','',''),(3777,'1','306','1',1,'Received from bridging 10',0.00,0.00,56.57,0.00,0.00,'2023-01-23 15:49:54','',''),(3778,'1','306','1',1,'Retail Sale Id 3787',43558.90,0.00,0.00,56.57,5883.28,'2023-01-23 15:50:39','',''),(3779,'1','306',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,2905533.00,4547.00,0.00,0.00,'2023-01-25 07:06:42','',''),(3780,'1','306',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,4547.00,0.00,'2023-01-25 07:08:43','',''),(3781,'1','306','1',1,'Received from bridging 11',0.00,0.00,4547.00,0.00,0.00,'2023-01-25 07:08:43','',''),(3782,'1','306','1',1,'Retail Sale Id 3788',9601.90,0.00,0.00,12.47,1633.57,'2023-01-25 07:32:12','',''),(3783,'1','306','1',1,'Retail Sale Id 3789',8000.30,0.00,0.00,10.39,1361.09,'2023-01-25 07:33:49','',''),(3784,'1','306','1',1,'Retail Sale Id 3790',9501.80,0.00,0.00,12.34,1616.54,'2023-01-25 07:38:09','',''),(3785,'1','306','1',1,'Retail Sale Id 3791',2502.50,0.00,0.00,3.25,425.75,'2023-01-25 07:42:04','',''),(3786,'1','306','1',1,'Retail Sale Id 3792',8000.30,0.00,0.00,10.39,1361.09,'2023-01-25 07:57:39','',''),(3787,'1','306','1',1,'Retail Sale Id 3793',4697.00,0.00,0.00,6.10,799.10,'2023-01-25 08:10:32','',''),(3788,'1','306','1',1,'Retail Sale Id 3794',9501.80,0.00,0.00,12.34,1616.54,'2023-01-25 08:14:57','',''),(3789,'1','306','1',1,'Retail Sale Id 3795',4496.80,0.00,0.00,5.84,765.04,'2023-01-25 08:17:13','',''),(3790,'1','306','1',1,'Retail Sale Id 3796',3303.30,0.00,0.00,4.29,561.99,'2023-01-25 08:18:51','',''),(3791,'1','306','1',1,'Retail Sale Id 3797',2502.50,0.00,0.00,3.25,425.75,'2023-01-25 08:19:55','',''),(3792,'1','306','1',1,'Retail Sale Id 3798',4496.80,0.00,0.00,5.84,765.04,'2023-01-25 08:21:02','',''),(3793,'1','306','1',1,'Retail Sale Id 3800',3203.20,0.00,0.00,4.16,544.96,'2023-01-25 08:22:32','',''),(3794,'1','306','1',1,'Retail Sale Id 3801',54750.00,0.00,0.00,75.00,6825.00,'2023-01-25 08:29:57','',''),(3795,'1','306','1',1,'Retail Sale Id 3802',2302.30,0.00,0.00,2.99,391.69,'2023-01-25 08:33:45','',''),(3796,'1','306','1',1,'Retail Sale Id 3803',6999.30,0.00,0.00,9.09,1190.79,'2023-01-25 08:35:33','',''),(3797,'1','306','1',1,'Retail Sale Id 3804',3103.10,0.00,0.00,4.03,527.93,'2023-01-25 08:47:30','',''),(3798,'1','306','1',1,'Retail Sale Id 3805',1501.50,0.00,0.00,1.95,255.45,'2023-01-25 08:51:30','',''),(3799,'1','306','1',1,'Retail Sale Id 3806',4620.00,0.00,0.00,6.00,786.00,'2023-01-25 08:56:56','',''),(3800,'1','306','1',1,'Retail Sale Id 3807',2302.30,0.00,0.00,2.99,391.69,'2023-01-25 08:58:37','',''),(3801,'1','306','1',1,'Retail Sale Id 3808',9625.00,0.00,0.00,12.50,1637.50,'2023-01-25 08:59:43','',''),(3802,'1','306','1',1,'Retail Sale Id 3809',4496.80,0.00,0.00,5.84,765.04,'2023-01-25 09:01:30','',''),(3803,'1','306','1',1,'Retail Sale Id 3810',4596.90,0.00,0.00,5.97,782.07,'2023-01-25 09:03:01','',''),(3804,'1','306','1',1,'Retail Sale Id 3811',3103.10,0.00,0.00,4.03,527.93,'2023-01-25 09:04:34','',''),(3805,'1','306','1',1,'Retail Sale Id 3812',4620.00,0.00,0.00,6.00,786.00,'2023-01-25 09:08:13','',''),(3806,'1','306','1',1,'Retail Sale Id 3813',4620.00,0.00,0.00,6.00,786.00,'2023-01-25 09:08:46','',''),(3807,'1','306','1',1,'Retail Sale Id 3814',1601.60,0.00,0.00,2.08,272.48,'2023-01-25 09:12:11','',''),(3808,'1','306','1',1,'Retail Sale Id 3815',4496.80,0.00,0.00,5.84,765.04,'2023-01-25 09:13:12','',''),(3809,'1','306','1',1,'Retail Sale Id 3816',2002.00,0.00,0.00,2.60,340.60,'2023-01-25 09:13:59','',''),(3810,'1','306','1',1,'Retail Sale Id 3817',800.80,0.00,0.00,1.04,136.24,'2023-01-25 09:15:38','',''),(3811,'1','306','1',1,'Retail Sale Id 3818',9601.90,0.00,0.00,12.47,1633.57,'2023-01-25 09:23:43','',''),(3812,'1','306','1',1,'Retail Sale Id 3819',1540.00,0.00,0.00,2.00,262.00,'2023-01-25 09:25:25','',''),(3813,'1','306','1',1,'Retail Sale Id 3820',1501.50,0.00,0.00,1.95,255.45,'2023-01-25 09:33:10','',''),(3814,'1','306','1',1,'Retail Sale Id 3821',77380.00,0.00,0.00,106.00,9646.00,'2023-01-25 09:34:26','',''),(3815,'1','306','1',1,'Retail Sale Id 3822',9601.90,0.00,0.00,12.47,1633.57,'2023-01-25 09:39:51','',''),(3816,'1','306','1',1,'Retail Sale Id 3823',800.80,0.00,0.00,1.04,136.24,'2023-01-25 09:53:42','',''),(3817,'1','306','1',1,'Retail Sale Id 3824',3003.00,0.00,0.00,3.90,510.90,'2023-01-25 09:54:58','',''),(3818,'1','306','1',1,'Retail Sale Id 3825',3896.20,0.00,0.00,5.06,662.86,'2023-01-25 10:04:52','',''),(3819,'1','306','1',1,'Retail Sale Id 3826',9240.00,0.00,0.00,12.00,1572.00,'2023-01-25 10:06:12','',''),(3820,'1','306','1',1,'Retail Sale Id 3827',2302.30,0.00,0.00,2.99,391.69,'2023-01-25 10:16:52','',''),(3821,'1','306','1',1,'Retail Sale Id 3828',7700.00,0.00,0.00,10.00,1310.00,'2023-01-25 10:17:34','',''),(3822,'1','306','1',1,'Retail Sale Id 3829',13870.00,0.00,0.00,19.00,1729.00,'2023-01-25 10:19:37','',''),(3823,'1','306','1',1,'Retail Sale Id 3830',1501.50,0.00,0.00,1.95,255.45,'2023-01-25 10:24:21','',''),(3824,'1','306','1',1,'Retail Sale Id 3831',1501.50,0.00,0.00,1.95,255.45,'2023-01-25 10:26:05','',''),(3825,'1','306','1',1,'Retail Sale Id 3832',4620.00,0.00,0.00,6.00,786.00,'2023-01-25 10:26:55','',''),(3826,'1','306','1',1,'Retail Sale Id 3833',2302.30,0.00,0.00,2.99,391.69,'2023-01-25 10:35:15','',''),(3827,'1','306','1',1,'Retail Sale Id 3834',25550.00,0.00,0.00,35.00,3185.00,'2023-01-25 10:36:54','',''),(3828,'1','306','1',1,'Retail Sale Id 3836',9501.80,0.00,0.00,12.34,1616.54,'2023-01-25 10:38:34','',''),(3829,'1','306','1',1,'Retail Sale Id 3837',4496.80,0.00,0.00,5.84,765.04,'2023-01-25 10:45:14','',''),(3830,'1','306','1',1,'Retail Sale Id 3838',2248.40,0.00,0.00,2.92,382.52,'2023-01-25 10:54:08','',''),(3831,'1','306','1',1,'Retail Sale Id 3839',2102.10,0.00,0.00,2.73,357.63,'2023-01-25 10:56:16','',''),(3832,'1','306','1',1,'Retail Sale Id 3840',4620.00,0.00,0.00,6.00,786.00,'2023-01-25 11:23:50','',''),(3833,'1','306','1',1,'Retail Sale Id 3841',770.00,0.00,0.00,1.00,131.00,'2023-01-25 11:30:44','',''),(3834,'1','306','1',1,'Retail Sale Id 3841',800.80,0.00,0.00,1.04,136.24,'2023-01-25 11:30:44','',''),(3835,'1','306','1',1,'Retail Sale Id 3841',1540.00,0.00,0.00,2.00,262.00,'2023-01-25 11:30:44','',''),(3836,'1','306','1',1,'Retail Sale Id 3842',3503.50,0.00,0.00,4.55,596.05,'2023-01-25 11:31:48','',''),(3837,'1','306','1',1,'Retail Sale Id 3843',4620.00,0.00,0.00,6.00,786.00,'2023-01-25 11:39:50','',''),(3838,'1','306','1',1,'Retail Sale Id 3844',3080.00,0.00,0.00,4.00,524.00,'2023-01-25 11:41:39','',''),(3839,'1','306','1',1,'Retail Sale Id 3845',54750.00,0.00,0.00,75.00,6825.00,'2023-01-25 11:45:51','',''),(3840,'1','306','1',1,'Retail Sale Id 3846',9625.00,0.00,0.00,12.50,1637.50,'2023-01-25 11:48:03','',''),(3841,'1','306','1',1,'Retail Sale Id 3847',42340.00,0.00,0.00,58.00,5278.00,'2023-01-25 11:50:35','',''),(3842,'1','306','1',1,'Retail Sale Id 3848',2310.00,0.00,0.00,3.00,393.00,'2023-01-25 11:53:51','',''),(3843,'1','306','1',1,'Retail Sale Id 3849',1540.00,0.00,0.00,2.00,262.00,'2023-01-25 11:54:57','',''),(3844,'1','306','1',1,'Retail Sale Id 3850',2302.30,0.00,0.00,2.99,391.69,'2023-01-25 11:56:29','',''),(3845,'1','306','1',1,'Retail Sale Id 3851',770.00,0.00,0.00,1.00,131.00,'2023-01-25 11:58:06','',''),(3846,'1','306','1',1,'Retail Sale Id 3852',2310.00,0.00,0.00,3.00,393.00,'2023-01-25 11:59:04','',''),(3847,'1','306','1',1,'Retail Sale Id 3853',9240.00,0.00,0.00,12.00,1572.00,'2023-01-25 12:00:46','',''),(3848,'1','306','1',1,'Retail Sale Id 3854',4496.80,0.00,0.00,5.84,765.04,'2023-01-25 12:02:30','',''),(3849,'1','306','1',1,'Retail Sale Id 3855',4620.00,0.00,0.00,6.00,786.00,'2023-01-25 12:09:13','',''),(3850,'1','306','1',1,'Retail Sale Id 3856',4596.90,0.00,0.00,5.97,782.07,'2023-01-25 12:26:06','',''),(3851,'1','306','1',1,'Retail Sale Id 3857',2302.30,0.00,0.00,2.99,391.69,'2023-01-25 12:30:08','',''),(3852,'1','306','1',1,'Retail Sale Id 3858',3503.50,0.00,0.00,4.55,596.05,'2023-01-25 12:39:06','',''),(3853,'1','306','1',1,'Retail Sale Id 3859',2002.00,0.00,0.00,2.60,340.60,'2023-01-25 12:43:41','',''),(3854,'1','306','1',1,'Retail Sale Id 3860',800.80,0.00,0.00,1.04,136.24,'2023-01-25 12:44:54','',''),(3855,'1','306','1',1,'Retail Sale Id 3861',3080.00,0.00,0.00,4.00,524.00,'2023-01-25 13:02:59','',''),(3856,'1','306','1',1,'Retail Sale Id 3862',4496.80,0.00,0.00,5.84,765.04,'2023-01-25 13:06:53','',''),(3857,'1','306','1',1,'Retail Sale Id 3863',2302.30,0.00,0.00,2.99,391.69,'2023-01-25 13:07:36','',''),(3858,'1','306','1',1,'Retail Sale Id 3864',2002.00,0.00,0.00,2.60,340.60,'2023-01-25 13:08:57','',''),(3859,'1','306','1',1,'Retail Sale Id 3865',3080.00,0.00,0.00,4.00,524.00,'2023-01-25 13:10:37','',''),(3860,'1','306','1',1,'Retail Sale Id 3866',2310.00,0.00,0.00,3.00,393.00,'2023-01-25 13:14:46','',''),(3861,'1','306','1',1,'Retail Sale Id 3867',9125.00,0.00,0.00,12.50,1137.50,'2023-01-25 13:38:03','',''),(3862,'1','306','1',1,'Retail Sale Id 3868',4697.00,0.00,0.00,6.10,799.10,'2023-01-25 13:51:56','',''),(3863,'1','306','1',1,'Retail Sale Id 3869',8470.00,0.00,0.00,11.00,1441.00,'2023-01-25 13:53:24','',''),(3864,'1','306','1',1,'Retail Sale Id 3871',4697.00,0.00,0.00,6.10,799.10,'2023-01-25 13:59:05','',''),(3865,'1','306','1',1,'Retail Sale Id 3872',3803.80,0.00,0.00,4.94,647.14,'2023-01-25 14:11:23','',''),(3866,'1','306','1',1,'Retail Sale Id 3873',1501.50,0.00,0.00,1.95,255.45,'2023-01-25 14:14:11','',''),(3867,'1','306','1',1,'Retail Sale Id 3874',3850.00,0.00,0.00,5.00,655.00,'2023-01-25 14:15:23','',''),(3868,'1','306','1',1,'Retail Sale Id 3875',7700.00,0.00,0.00,10.00,1310.00,'2023-01-25 14:26:41','',''),(3869,'1','306','1',1,'Retail Sale Id 3877',1001.00,0.00,0.00,1.30,170.30,'2023-01-25 14:28:37','',''),(3870,'1','306','1',1,'Retail Sale Id 3878',1001.00,0.00,0.00,1.30,170.30,'2023-01-25 14:30:07','',''),(3871,'1','306','1',1,'Retail Sale Id 3879',9625.00,0.00,0.00,12.50,1637.50,'2023-01-25 14:37:50','',''),(3872,'1','306','1',1,'Retail Sale Id 3880',4650.80,0.00,0.00,6.04,791.24,'2023-01-25 14:50:30','',''),(3873,'1','306','1',1,'Retail Sale Id 3881',770.00,0.00,0.00,1.00,131.00,'2023-01-25 15:00:10','',''),(3874,'1','306','1',1,'Retail Sale Id 3882',1501.50,0.00,0.00,1.95,255.45,'2023-01-25 15:10:18','',''),(3875,'1','306','1',1,'Retail Sale Id 3883',9240.00,0.00,0.00,12.00,1572.00,'2023-01-25 15:22:10','',''),(3876,'1','306','1',1,'Retail Sale Id 3884',9625.00,0.00,0.00,12.50,1637.50,'2023-01-25 15:24:40','',''),(3877,'1','306','1',1,'Retail Sale Id 3885',1501.50,0.00,0.00,1.95,255.45,'2023-01-25 15:25:29','',''),(3878,'1','306','1',1,'Retail Sale Id 3886',2302.30,0.00,0.00,2.99,391.69,'2023-01-25 15:33:13','',''),(3879,'1','306','1',1,'Retail Sale Id 3887',9301.60,0.00,0.00,12.08,1582.48,'2023-01-25 15:34:58','',''),(3880,'1','306','1',1,'Retail Sale Id 3888',9625.00,0.00,0.00,12.50,1637.50,'2023-01-25 15:51:31','',''),(3881,'1','306','1',1,'Retail Sale Id 3889',800.80,0.00,0.00,1.04,136.24,'2023-01-25 15:58:59','',''),(3882,'1','306','1',1,'Retail Sale Id 3891',1601.60,0.00,0.00,2.08,272.48,'2023-01-25 16:00:13','',''),(3883,'1','306','1',1,'Retail Sale Id 3892',4620.00,0.00,0.00,6.00,786.00,'2023-01-25 16:02:06','',''),(3884,'1','306','1',1,'Retail Sale Id 3893',1501.50,0.00,0.00,1.95,255.45,'2023-01-25 16:06:09','',''),(3885,'1','306','1',1,'Retail Sale Id 3894',3080.00,0.00,0.00,4.00,524.00,'2023-01-25 16:13:27','',''),(3886,'1','306','1',1,'Retail Sale Id 3895',2002.00,0.00,0.00,2.60,340.60,'2023-01-25 16:16:42','',''),(3887,'1','306','1',1,'Retail Sale Id 3896',4997.30,0.00,0.00,6.49,850.19,'2023-01-25 16:19:49','',''),(3888,'1','306','1',1,'Retail Sale Id 3897',2002.00,0.00,0.00,2.60,340.60,'2023-01-25 16:22:09','',''),(3889,'1','306','1',1,'Retail Sale Id 3898',2302.30,0.00,0.00,2.99,391.69,'2023-01-25 16:23:17','',''),(3890,'1','306','1',1,'Retail Sale Id 3899',8470.00,0.00,0.00,11.00,1441.00,'2023-01-25 16:25:32','',''),(3891,'1','306','1',1,'Retail Sale Id 3900',9625.00,0.00,0.00,12.50,1637.50,'2023-01-25 16:35:19','',''),(3892,'1','306','1',1,'Retail Sale Id 3901',36500.00,0.00,0.00,50.00,4550.00,'2023-01-25 16:36:30','',''),(3893,'1','306','1',1,'Retail Sale Id 3902',3203.20,0.00,0.00,4.16,544.96,'2023-01-25 16:39:23','',''),(3894,'1','306','1',1,'Retail Sale Id 3903',1547.70,0.00,0.00,2.01,263.31,'2023-01-25 16:43:41','',''),(3895,'1','306','1',1,'Retail Sale Id 3904',3850.00,0.00,0.00,5.00,655.00,'2023-01-25 16:45:25','',''),(3896,'1','306','1',1,'Retail Sale Id 3905',2302.30,0.00,0.00,2.99,391.69,'2023-01-25 16:46:39','',''),(3897,'1','306','1',1,'Retail Sale Id 3907',7800.10,0.00,0.00,10.13,1327.03,'2023-01-25 16:57:13','',''),(3898,'1','306','1',1,'Retail Sale Id 3908',1701.70,0.00,0.00,2.21,289.51,'2023-01-25 17:05:19','',''),(3899,'1','306','1',1,'Retail Sale Id 3909',3103.10,0.00,0.00,4.03,527.93,'2023-01-25 17:06:48','',''),(3900,'1','306','1',1,'Retail Sale Id 3910',1540.00,0.00,0.00,2.00,262.00,'2023-01-25 17:07:48','',''),(3901,'1','306','1',1,'Retail Sale Id 3911',3080.00,0.00,0.00,4.00,524.00,'2023-01-25 17:09:19','',''),(3902,'1','306','1',1,'Retail Sale Id 3912',4496.80,0.00,0.00,5.84,765.04,'2023-01-25 17:10:16','',''),(3903,'1','306','1',1,'Retail Sale Id 3913',9240.00,0.00,0.00,12.00,1572.00,'2023-01-25 17:13:26','',''),(3904,'1','306','1',1,'Retail Sale Id 3913',9240.00,0.00,0.00,12.00,1572.00,'2023-01-25 17:13:26','',''),(3905,'1','306','1',1,'Retail Sale Id 3914',2302.30,0.00,0.00,2.99,391.69,'2023-01-25 17:19:11','',''),(3906,'1','306','1',1,'Retail Sale Id 3915',2310.00,0.00,0.00,3.00,393.00,'2023-01-25 17:23:10','',''),(3907,'1','306','1',1,'Retail Sale Id 3916',4596.90,0.00,0.00,5.97,782.07,'2023-01-25 17:24:42','',''),(3908,'1','306','1',1,'Retail Sale Id 3917',3850.00,0.00,0.00,5.00,655.00,'2023-01-25 17:26:04','',''),(3909,'1','306','1',1,'Retail Sale Id 3918',800.80,0.00,0.00,1.04,136.24,'2023-01-25 17:28:08','',''),(3910,'1','306','1',1,'Retail Sale Id 3919',1501.50,0.00,0.00,1.95,255.45,'2023-01-25 17:29:56','',''),(3911,'1','306','1',1,'Retail Sale Id 3920',4620.00,0.00,0.00,6.00,786.00,'2023-01-25 17:31:04','',''),(3912,'1','306','1',1,'Retail Sale Id 3921',4496.80,0.00,0.00,5.84,765.04,'2023-01-25 17:32:03','',''),(3913,'1','306','1',1,'Retail Sale Id 3923',2002.00,0.00,0.00,2.60,340.60,'2023-01-25 17:33:36','',''),(3914,'1','306','1',1,'Retail Sale Id 3925',4620.00,0.00,0.00,6.00,786.00,'2023-01-25 17:35:27','',''),(3915,'1','306','1',1,'Retail Sale Id 3926',1301.30,0.00,0.00,1.69,221.39,'2023-01-25 17:37:35','',''),(3916,'1','306','1',1,'Retail Sale Id 3926',1301.30,0.00,0.00,1.69,221.39,'2023-01-25 17:37:35','',''),(3917,'1','306','1',1,'Retail Sale Id 3927',3080.00,0.00,0.00,4.00,524.00,'2023-01-25 17:53:37','',''),(3918,'1','306','1',1,'Retail Sale Id 3928',3003.00,0.00,0.00,3.90,510.90,'2023-01-25 17:55:05','',''),(3919,'1','306','1',1,'Retail Sale Id 3930',7700.00,0.00,0.00,10.00,1310.00,'2023-01-25 18:10:25','',''),(3920,'1','306','1',1,'Retail Sale Id 3931',1601.60,0.00,0.00,2.08,272.48,'2023-01-25 18:15:50','',''),(3921,'1','306','1',1,'Retail Sale Id 3932',2302.30,0.00,0.00,2.99,391.69,'2023-01-25 18:19:14','',''),(3922,'1','306','1',1,'Retail Sale Id 3933',1540.00,0.00,0.00,2.00,262.00,'2023-01-25 18:22:37','',''),(3923,'1','306','1',1,'Retail Sale Id 3934',3072.30,0.00,0.00,3.99,522.69,'2023-01-25 18:27:10','',''),(3924,'1','306','1',1,'Return of Retail Sale Id 3901',0.00,36500.00,50.00,0.00,-4550.00,'2023-01-25 18:55:53','',''),(3925,'1','306','1',1,'Retail Sale Id 3935',24433.10,0.00,0.00,33.47,3045.77,'2023-01-25 18:59:57','',''),(3926,'1','306','1',1,'Retail Sale Id 3936',12766.60,0.00,0.00,16.58,2171.98,'2023-01-25 19:00:51','',''),(3927,'1','306','1',1,'Retail Sale Id 3937',4997.30,0.00,0.00,6.49,850.19,'2023-01-26 07:11:05','',''),(3928,'1','306','1',1,'Retail Sale Id 3938',1001.00,0.00,0.00,1.30,170.30,'2023-01-26 07:15:00','',''),(3929,'1','306','1',1,'Retail Sale Id 3939',2002.00,0.00,0.00,2.60,340.60,'2023-01-26 07:52:14','',''),(3930,'1','306','1',1,'Retail Sale Id 3941',9001.30,0.00,0.00,11.69,1531.39,'2023-01-26 07:56:36','',''),(3931,'1','306','1',1,'Retail Sale Id 3942',2202.20,0.00,0.00,2.86,374.66,'2023-01-26 07:57:56','',''),(3932,'1','306','1',1,'Retail Sale Id 3943',2348.50,0.00,0.00,3.05,399.55,'2023-01-26 08:16:53','',''),(3933,'1','306','1',1,'Retail Sale Id 3944',3996.30,0.00,0.00,5.19,679.89,'2023-01-26 08:20:49','',''),(3934,'1','306','1',1,'Retail Sale Id 3945',3950.10,0.00,0.00,5.13,672.03,'2023-01-26 08:25:49','',''),(3935,'1','306','1',1,'Retail Sale Id 3947',7300.00,0.00,0.00,10.00,910.00,'2023-01-26 08:27:49','',''),(3936,'1','306','1',1,'Retail Sale Id 3948',3850.00,0.00,0.00,5.00,655.00,'2023-01-26 08:35:15','',''),(3937,'1','306','1',1,'Retail Sale Id 3949',500.50,0.00,0.00,0.65,85.15,'2023-01-26 08:39:14','',''),(3938,'1','306','1',1,'Retail Sale Id 3950',3103.10,0.00,0.00,4.03,527.93,'2023-01-26 08:43:53','',''),(3939,'1','306','1',1,'Retail Sale Id 3951',4620.00,0.00,0.00,6.00,786.00,'2023-01-26 08:45:44','',''),(3940,'1','306','1',1,'Retail Sale Id 3952',1540.00,0.00,0.00,2.00,262.00,'2023-01-26 08:47:47','',''),(3941,'1','306','1',1,'Retail Sale Id 3953',4620.00,0.00,0.00,6.00,786.00,'2023-01-26 08:49:41','',''),(3942,'1','306','1',1,'Retail Sale Id 3954',2310.00,0.00,0.00,3.00,393.00,'2023-01-26 08:50:32','',''),(3943,'1','306','1',1,'Retail Sale Id 3955',2310.00,0.00,0.00,3.00,393.00,'2023-01-26 08:53:11','',''),(3944,'1','306','1',1,'Retail Sale Id 3956',2310.00,0.00,0.00,3.00,393.00,'2023-01-26 08:54:30','',''),(3945,'1','306','1',1,'Return of Retail Sale Id 3956',0.00,2310.00,3.00,0.00,-393.00,'2023-01-26 08:54:58','',''),(3946,'1','306','1',1,'Retail Sale Id 3958',3080.00,0.00,0.00,4.00,524.00,'2023-01-26 08:55:42','',''),(3947,'1','306','1',1,'Retail Sale Id 3959',1540.00,0.00,0.00,2.00,262.00,'2023-01-26 08:56:53','',''),(3948,'1','306','1',1,'Retail Sale Id 3960',3850.00,0.00,0.00,5.00,655.00,'2023-01-26 08:59:06','',''),(3949,'1','306','1',1,'Retail Sale Id 3961',2402.40,0.00,0.00,3.12,408.72,'2023-01-26 09:02:12','',''),(3950,'1','306','1',1,'Retail Sale Id 3962',9625.00,0.00,0.00,12.50,1637.50,'2023-01-26 09:05:11','',''),(3951,'1','306','1',1,'Retail Sale Id 3963',1540.00,0.00,0.00,2.00,262.00,'2023-01-26 09:26:25','',''),(3952,'1','306','1',1,'Retail Sale Id 3964',1540.00,0.00,0.00,2.00,262.00,'2023-01-26 09:27:04','',''),(3953,'1','306','1',1,'Retail Sale Id 3965',4596.90,0.00,0.00,5.97,782.07,'2023-01-26 09:28:24','',''),(3954,'1','306','1',1,'Retail Sale Id 3966',1540.00,0.00,0.00,2.00,262.00,'2023-01-26 09:29:18','',''),(3955,'1','306','1',1,'Retail Sale Id 3966',2310.00,0.00,0.00,3.00,393.00,'2023-01-26 09:29:18','',''),(3956,'1','306','1',1,'Retail Sale Id 3967',4596.90,0.00,0.00,5.97,782.07,'2023-01-26 09:30:54','',''),(3957,'1','306','1',1,'Retail Sale Id 3968',2310.00,0.00,0.00,3.00,393.00,'2023-01-26 09:31:37','',''),(3958,'1','306','1',1,'Retail Sale Id 3969',1540.00,0.00,0.00,2.00,262.00,'2023-01-26 09:33:42','',''),(3959,'1','306','1',1,'Retail Sale Id 3970',4620.00,0.00,0.00,6.00,786.00,'2023-01-26 09:34:53','',''),(3960,'1','306','1',1,'Retail Sale Id 3971',5390.00,0.00,0.00,7.00,917.00,'2023-01-26 09:35:53','',''),(3961,'1','306','1',1,'Retail Sale Id 3972',9247.70,0.00,0.00,12.01,1573.31,'2023-01-26 09:38:25','',''),(3962,'1','306','1',1,'Retail Sale Id 3974',4496.80,0.00,0.00,5.84,765.04,'2023-01-26 09:39:53','',''),(3963,'1','306','1',1,'Retail Sale Id 3975',800.80,0.00,0.00,1.04,136.24,'2023-01-26 09:40:44','',''),(3964,'1','306','1',1,'Retail Sale Id 3977',2317.70,0.00,0.00,3.01,394.31,'2023-01-26 09:41:52','',''),(3965,'1','306','1',1,'Retail Sale Id 3978',1547.70,0.00,0.00,2.01,263.31,'2023-01-26 09:43:28','',''),(3966,'1','306','1',1,'Return of Retail Sale Id 3978',0.00,1547.70,2.01,0.00,-263.31,'2023-01-26 09:44:20','',''),(3967,'1','306','1',1,'Retail Sale Id 3979',1501.50,0.00,0.00,1.95,255.45,'2023-01-26 09:45:01','',''),(3968,'1','306','1',1,'Retail Sale Id 3980',4620.00,0.00,0.00,6.00,786.00,'2023-01-26 09:49:00','',''),(3969,'1','306','1',1,'Retail Sale Id 3981',4620.00,0.00,0.00,6.00,786.00,'2023-01-26 09:51:59','',''),(3970,'1','306','1',1,'Retail Sale Id 3982',2002.00,0.00,0.00,2.60,340.60,'2023-01-26 09:53:04','',''),(3971,'1','306','1',1,'Retail Sale Id 3983',3996.30,0.00,0.00,5.19,679.89,'2023-01-26 09:54:34','',''),(3972,'1','306','1',1,'Retail Sale Id 3984',2310.00,0.00,0.00,3.00,393.00,'2023-01-26 09:59:25','',''),(3973,'1','306','1',1,'Retail Sale Id 3986',2310.00,0.00,0.00,3.00,393.00,'2023-01-26 10:05:20','',''),(3974,'1','306','1',1,'Retail Sale Id 3988',1547.70,0.00,0.00,2.01,263.31,'2023-01-26 10:07:10','',''),(3975,'1','306','1',1,'Retail Sale Id 3989',1501.50,0.00,0.00,1.95,255.45,'2023-01-26 10:09:35','',''),(3976,'1','306','1',1,'Retail Sale Id 3990',2402.40,0.00,0.00,3.12,408.72,'2023-01-26 10:13:09','',''),(3977,'1','306','1',1,'Retail Sale Id 3991',2002.00,0.00,0.00,2.60,340.60,'2023-01-26 10:14:57','',''),(3978,'1','306','1',1,'Retail Sale Id 3992',1001.00,0.00,0.00,1.30,170.30,'2023-01-26 10:15:55','',''),(3979,'1','306','1',1,'Retail Sale Id 3993',1501.50,0.00,0.00,1.95,255.45,'2023-01-26 10:23:44','',''),(3980,'1','306','1',1,'Retail Sale Id 3994',91250.00,0.00,0.00,125.00,11375.00,'2023-01-26 10:24:39','',''),(3981,'1','306','1',1,'Retail Sale Id 3995',2248.40,0.00,0.00,2.92,382.52,'2023-01-26 10:28:49','',''),(3982,'1','306','1',1,'Retail Sale Id 3996',16940.00,0.00,0.00,22.00,2882.00,'2023-01-26 10:35:34','',''),(3983,'1','306','1',1,'Retail Sale Id 3997',1540.00,0.00,0.00,2.00,262.00,'2023-01-26 10:39:11','',''),(3984,'1','306','1',1,'Retail Sale Id 3998',4997.30,0.00,0.00,6.49,850.19,'2023-01-26 10:41:17','',''),(3985,'1','306','1',1,'Retail Sale Id 3999',167170.00,0.00,0.00,229.00,20839.00,'2023-01-26 10:46:13','',''),(3986,'1','306','1',1,'Retail Sale Id 4000',3850.00,0.00,0.00,5.00,655.00,'2023-01-26 10:47:09','',''),(3987,'1','306','1',1,'Retail Sale Id 4001',2302.30,0.00,0.00,2.99,391.69,'2023-01-26 10:52:56','',''),(3988,'1','306','1',1,'Retail Sale Id 4002',2310.00,0.00,0.00,3.00,393.00,'2023-01-26 11:06:07','',''),(3989,'1','306','1',1,'Retail Sale Id 4003',3850.00,0.00,0.00,5.00,655.00,'2023-01-26 11:09:43','',''),(3990,'1','306','1',1,'Retail Sale Id 4004',5390.00,0.00,0.00,7.00,917.00,'2023-01-26 11:11:53','',''),(3991,'1','306','1',1,'Retail Sale Id 4005',32850.00,0.00,0.00,45.00,4095.00,'2023-01-26 11:13:10','',''),(3992,'1','306','1',1,'Retail Sale Id 4006',3996.30,0.00,0.00,5.19,679.89,'2023-01-26 11:15:10','',''),(3993,'1','306','1',1,'Retail Sale Id 4007',1547.70,0.00,0.00,2.01,263.31,'2023-01-26 11:28:29','',''),(3994,'1','306','1',1,'Retail Sale Id 4008',9625.00,0.00,0.00,12.50,1637.50,'2023-01-26 11:37:13','',''),(3995,'1','306','1',1,'Retail Sale Id 4008',9625.00,0.00,0.00,12.50,1637.50,'2023-01-26 11:37:13','',''),(3996,'1','306','1',1,'Retail Sale Id 4009',3996.30,0.00,0.00,5.19,679.89,'2023-01-26 11:38:51','',''),(3997,'1','306','1',1,'Retail Sale Id 4010',7700.00,0.00,0.00,10.00,1310.00,'2023-01-26 11:47:00','',''),(3998,'1','306','1',1,'Retail Sale Id 4011',2310.00,0.00,0.00,3.00,393.00,'2023-01-26 11:54:20','',''),(3999,'1','306','1',1,'Retail Sale Id 4012',2310.00,0.00,0.00,3.00,393.00,'2023-01-26 11:56:33','',''),(4000,'1','306','1',1,'Retail Sale Id 4013',1001.00,0.00,0.00,1.30,170.30,'2023-01-26 12:15:59','',''),(4001,'1','306','1',1,'Retail Sale Id 4014',1540.00,0.00,0.00,2.00,262.00,'2023-01-26 12:18:29','',''),(4002,'1','306','1',1,'Retail Sale Id 4015',9125.00,0.00,0.00,12.50,1137.50,'2023-01-26 12:20:23','',''),(4003,'1','306','1',1,'Retail Sale Id 4017',770.00,0.00,0.00,1.00,131.00,'2023-01-26 12:22:45','',''),(4004,'1','306','1',1,'Retail Sale Id 4018',10010.00,0.00,0.00,13.00,1703.00,'2023-01-26 12:23:45','',''),(4005,'1','306','1',1,'Retail Sale Id 4019',2002.00,0.00,0.00,2.60,340.60,'2023-01-26 12:25:51','',''),(4006,'1','306','1',1,'Retail Sale Id 4020',9625.00,0.00,0.00,12.50,1637.50,'2023-01-26 12:26:49','',''),(4007,'1','306','1',1,'Retail Sale Id 4021',2000.20,0.00,0.00,2.74,249.34,'2023-01-26 12:28:29','',''),(4008,'1','306','1',1,'Retail Sale Id 4022',9240.00,0.00,0.00,12.00,1572.00,'2023-01-26 12:29:10','',''),(4009,'1','306','1',1,'Retail Sale Id 4024',7700.00,0.00,0.00,10.00,1310.00,'2023-01-26 12:30:34','',''),(4010,'1','306','1',1,'Retail Sale Id 4025',4620.00,0.00,0.00,6.00,786.00,'2023-01-26 12:33:52','',''),(4011,'1','306','1',1,'Return of Retail Sale Id 4019',0.00,2002.00,2.60,0.00,-340.60,'2023-01-26 12:39:07','',''),(4012,'1','306','1',1,'Retail Sale Id 4026',4997.30,0.00,0.00,6.49,850.19,'2023-01-26 12:52:16','',''),(4013,'1','306','1',1,'Retail Sale Id 4027',1540.00,0.00,0.00,2.00,262.00,'2023-01-26 12:59:21','',''),(4014,'1','306','1',1,'Retail Sale Id 4028',7700.00,0.00,0.00,10.00,1310.00,'2023-01-26 13:00:14','',''),(4015,'1','306','1',1,'Retail Sale Id 4029',1540.00,0.00,0.00,2.00,262.00,'2023-01-26 13:02:47','',''),(4016,'1','306','1',1,'Retail Sale Id 4030',4997.30,0.00,0.00,6.49,850.19,'2023-01-26 13:22:22','',''),(4017,'1','306','1',1,'Retail Sale Id 4031',2310.00,0.00,0.00,3.00,393.00,'2023-01-26 13:23:24','',''),(4018,'1','306','1',1,'Retail Sale Id 4032',9625.00,0.00,0.00,12.50,1637.50,'2023-01-26 13:27:31','',''),(4019,'1','306','1',1,'Retail Sale Id 4033',4620.00,0.00,0.00,6.00,786.00,'2023-01-26 13:36:52','',''),(4020,'1','306','1',1,'Retail Sale Id 4034',2302.30,0.00,0.00,2.99,391.69,'2023-01-26 13:37:53','',''),(4021,'1','306','1',1,'Retail Sale Id 4035',500.50,0.00,0.00,0.65,85.15,'2023-01-26 13:44:05','',''),(4022,'1','306','1',1,'Retail Sale Id 4036',7700.00,0.00,0.00,10.00,1310.00,'2023-01-26 13:53:36','',''),(4023,'1','306','1',1,'Retail Sale Id 4037',2310.00,0.00,0.00,3.00,393.00,'2023-01-26 14:10:15','',''),(4024,'1','306','1',1,'Retail Sale Id 4038',2302.30,0.00,0.00,2.99,391.69,'2023-01-26 14:12:00','',''),(4025,'1','306','1',1,'Retail Sale Id 4039',9201.50,0.00,0.00,11.95,1565.45,'2023-01-26 14:15:39','',''),(4026,'1','306','1',1,'Retail Sale Id 4040',3850.00,0.00,0.00,5.00,655.00,'2023-01-26 14:22:05','',''),(4027,'1','306','1',1,'Retail Sale Id 4041',746.90,0.00,0.00,0.97,127.07,'2023-01-26 14:26:39','',''),(4028,'1','306','1',1,'Retail Sale Id 4042',1001.00,0.00,0.00,1.30,170.30,'2023-01-26 14:29:23','',''),(4029,'1','306','1',1,'Retail Sale Id 4043',3803.80,0.00,0.00,4.94,647.14,'2023-01-26 14:41:22','',''),(4030,'1','306','1',1,'Retail Sale Id 4044',770.00,0.00,0.00,1.00,131.00,'2023-01-26 14:45:22','',''),(4031,'1','306','1',1,'Retail Sale Id 4045',3850.00,0.00,0.00,5.00,655.00,'2023-01-26 15:02:51','',''),(4032,'1','306','1',1,'Retail Sale Id 4046',3850.00,0.00,0.00,5.00,655.00,'2023-01-26 15:12:43','',''),(4033,'1','306','1',1,'Retail Sale Id 4047',3080.00,0.00,0.00,4.00,524.00,'2023-01-26 15:21:33','',''),(4034,'1','306','1',1,'Retail Sale Id 4048',6930.00,0.00,0.00,9.00,1179.00,'2023-01-26 15:41:13','',''),(4035,'1','306','1',1,'Retail Sale Id 4049',7700.00,0.00,0.00,10.00,1310.00,'2023-01-26 15:43:17','',''),(4036,'1','306','1',1,'Retail Sale Id 4051',2302.30,0.00,0.00,2.99,391.69,'2023-01-26 15:46:18','',''),(4037,'1','306','1',1,'Retail Sale Id 4052',9702.00,0.00,0.00,12.60,1650.60,'2023-01-26 17:05:24','',''),(4038,'1','306','1',1,'Retail Sale Id 4053',1501.50,0.00,0.00,1.95,255.45,'2023-01-26 17:06:13','',''),(4039,'1','306','1',1,'Retail Sale Id 4054',9648.10,0.00,0.00,12.53,1641.43,'2023-01-26 17:11:16','',''),(4040,'1','306','1',1,'Retail Sale Id 4055',2310.00,0.00,0.00,3.00,393.00,'2023-01-26 17:14:41','',''),(4041,'1','306','1',1,'Retail Sale Id 4056',4697.00,0.00,0.00,6.10,799.10,'2023-01-26 17:20:16','',''),(4042,'1','306','1',1,'Retail Sale Id 4057',2002.00,0.00,0.00,2.60,340.60,'2023-01-26 17:21:07','',''),(4043,'1','306','1',1,'Retail Sale Id 4058',2348.50,0.00,0.00,3.05,399.55,'2023-01-26 17:24:58','',''),(4044,'1','306','1',1,'Retail Sale Id 4059',2402.40,0.00,0.00,3.12,408.72,'2023-01-26 17:34:51','',''),(4045,'1','306','1',1,'Retail Sale Id 4060',9702.00,0.00,0.00,12.60,1650.60,'2023-01-26 17:37:01','',''),(4046,'1','306','1',1,'Retail Sale Id 4061',3080.00,0.00,0.00,4.00,524.00,'2023-01-26 17:48:08','',''),(4047,'1','306','1',1,'Retail Sale Id 4062',3103.10,0.00,0.00,4.03,527.93,'2023-01-26 17:50:46','',''),(4048,'1','306','1',1,'Retail Sale Id 4063',3003.00,0.00,0.00,3.90,510.90,'2023-01-26 17:54:13','',''),(4049,'1','306','1',1,'Retail Sale Id 4064',9702.00,0.00,0.00,12.60,1650.60,'2023-01-26 17:57:13','',''),(4050,'1','306','1',1,'Retail Sale Id 4065',3203.20,0.00,0.00,4.16,544.96,'2023-01-26 18:03:25','',''),(4051,'1','306','1',1,'Retail Sale Id 4066',3003.00,0.00,0.00,3.90,510.90,'2023-01-26 18:05:00','',''),(4052,'1','306','1',1,'Retail Sale Id 4067',800.80,0.00,0.00,1.04,136.24,'2023-01-26 18:07:57','',''),(4053,'1','306','1',1,'Retail Sale Id 4068',9702.00,0.00,0.00,12.60,1650.60,'2023-01-26 18:09:24','',''),(4054,'1','306','1',1,'Retail Sale Id 4069',24820.00,0.00,0.00,34.00,3094.00,'2023-01-26 18:10:55','',''),(4055,'1','306','1',1,'Retail Sale Id 4070',3080.00,0.00,0.00,4.00,524.00,'2023-01-26 18:13:21','',''),(4056,'1','306','1',1,'Retail Sale Id 4071',9802.10,0.00,0.00,12.73,1667.63,'2023-01-26 18:16:11','',''),(4057,'1','306','1',1,'Retail Sale Id 4072',4596.90,0.00,0.00,5.97,782.07,'2023-01-26 18:17:18','',''),(4058,'1','306','1',1,'Retail Sale Id 4074',9001.30,0.00,0.00,11.69,1531.39,'2023-01-26 18:20:32','',''),(4059,'1','306','1',1,'Retail Sale Id 4075',8000.30,0.00,0.00,10.39,1361.09,'2023-01-26 18:21:56','',''),(4060,'1','306','1',1,'Retail Sale Id 4076',2310.00,0.00,0.00,3.00,393.00,'2023-01-26 18:32:06','',''),(4061,'1','306','1',1,'Return of Retail Sale Id 4067',0.00,800.80,1.04,0.00,-136.24,'2023-01-26 18:56:16','',''),(4062,'1','306','1',1,'Retail Sale Id 4077',662.20,0.00,0.00,0.86,112.66,'2023-01-26 18:57:21','',''),(4063,'1','306','1',1,'Retail Sale Id 4078',1547.70,0.00,0.00,2.01,263.31,'2023-01-27 07:16:27','',''),(4064,'1','306','1',1,'Retail Sale Id 4079',6999.30,0.00,0.00,9.09,1190.79,'2023-01-27 07:35:53','',''),(4065,'1','306','1',1,'Retail Sale Id 4080',3503.50,0.00,0.00,4.55,596.05,'2023-01-27 07:49:26','',''),(4066,'1','306','1',1,'Retail Sale Id 4082',3850.00,0.00,0.00,5.00,655.00,'2023-01-27 07:55:02','',''),(4067,'1','306','1',1,'Retail Sale Id 4083',3850.00,0.00,0.00,5.00,655.00,'2023-01-27 07:57:14','',''),(4068,'1','306','1',1,'Retail Sale Id 4084',1547.70,0.00,0.00,2.01,263.31,'2023-01-27 07:59:27','',''),(4069,'1','306','1',1,'Retail Sale Id 4085',4650.80,0.00,0.00,6.04,791.24,'2023-01-27 08:14:16','',''),(4070,'1','306','1',1,'Retail Sale Id 4086',2302.30,0.00,0.00,2.99,391.69,'2023-01-27 08:16:47','',''),(4071,'1','306','1',1,'Retail Sale Id 4087',2302.30,0.00,0.00,2.99,391.69,'2023-01-27 08:18:41','',''),(4072,'1','306','1',1,'Retail Sale Id 4090',4650.80,0.00,0.00,6.04,791.24,'2023-01-27 08:21:53','',''),(4073,'1','306','1',1,'Retail Sale Id 4091',1001.00,0.00,0.00,1.30,170.30,'2023-01-27 08:22:39','',''),(4074,'1','306','1',1,'Retail Sale Id 4092',9601.90,0.00,0.00,12.47,1633.57,'2023-01-27 08:28:15','',''),(4075,'1','306','1',1,'Retail Sale Id 4093',1547.70,0.00,0.00,2.01,263.31,'2023-01-27 08:31:34','',''),(4076,'1','306','1',1,'Retail Sale Id 4094',2302.30,0.00,0.00,2.99,391.69,'2023-01-27 08:35:46','',''),(4077,'1','306','1',1,'Retail Sale Id 4095',7499.80,0.00,0.00,9.74,1275.94,'2023-01-27 08:38:31','',''),(4078,'1','306','1',1,'Retail Sale Id 4096',1501.50,0.00,0.00,1.95,255.45,'2023-01-27 08:39:50','',''),(4079,'1','306','1',1,'Retail Sale Id 4097',26280.00,0.00,0.00,36.00,3276.00,'2023-01-27 08:43:15','',''),(4080,'1','306','1',1,'Retail Sale Id 4098',800.80,0.00,0.00,1.04,136.24,'2023-01-27 08:47:05','',''),(4081,'1','306','1',1,'Retail Sale Id 4099',6999.30,0.00,0.00,9.09,1190.79,'2023-01-27 08:49:17','',''),(4082,'1','306','1',1,'Retail Sale Id 4100',1501.50,0.00,0.00,1.95,255.45,'2023-01-27 08:52:37','',''),(4083,'1','306','1',1,'Retail Sale Id 4101',3080.00,0.00,0.00,4.00,524.00,'2023-01-27 08:54:30','',''),(4084,'1','306','1',1,'Retail Sale Id 4102',9625.00,0.00,0.00,12.50,1637.50,'2023-01-27 08:55:46','',''),(4085,'1','306','1',1,'Retail Sale Id 4103',4620.00,0.00,0.00,6.00,786.00,'2023-01-27 09:04:25','',''),(4086,'1','306','1',1,'Retail Sale Id 4104',9625.00,0.00,0.00,12.50,1637.50,'2023-01-27 09:07:42','',''),(4087,'1','306','1',1,'Retail Sale Id 4105',9625.00,0.00,0.00,12.50,1637.50,'2023-01-27 09:10:51','',''),(4088,'1','306','1',1,'Retail Sale Id 4106',3850.00,0.00,0.00,5.00,655.00,'2023-01-27 09:11:43','',''),(4089,'1','306','1',1,'Retail Sale Id 4107',2695.00,0.00,0.00,3.50,458.50,'2023-01-27 09:12:35','',''),(4090,'1','306','1',1,'Retail Sale Id 4108',3503.50,0.00,0.00,4.55,596.05,'2023-01-27 09:13:41','',''),(4091,'1','306','1',1,'Retail Sale Id 4109',3850.00,0.00,0.00,5.00,655.00,'2023-01-27 09:14:29','',''),(4092,'1','306','1',1,'Retail Sale Id 4110',3850.00,0.00,0.00,5.00,655.00,'2023-01-27 09:16:19','',''),(4093,'1','306','1',1,'Retail Sale Id 4111',6160.00,0.00,0.00,8.00,1048.00,'2023-01-27 09:18:46','',''),(4094,'1','306','1',1,'Retail Sale Id 4112',4620.00,0.00,0.00,6.00,786.00,'2023-01-27 09:22:49','',''),(4095,'1','306','1',1,'Retail Sale Id 4113',4620.00,0.00,0.00,6.00,786.00,'2023-01-27 09:43:22','',''),(4096,'1','306','1',1,'Retail Sale Id 4114',2310.00,0.00,0.00,3.00,393.00,'2023-01-27 09:44:40','',''),(4097,'1','306','1',1,'Retail Sale Id 4115',3850.00,0.00,0.00,5.00,655.00,'2023-01-27 09:50:52','',''),(4098,'1','306','1',1,'Retail Sale Id 4116',7700.00,0.00,0.00,10.00,1310.00,'2023-01-27 09:52:39','',''),(4099,'1','306','1',1,'Retail Sale Id 4117',2310.00,0.00,0.00,3.00,393.00,'2023-01-27 09:53:55','',''),(4100,'1','306','1',1,'Retail Sale Id 4118',9625.00,0.00,0.00,12.50,1637.50,'2023-01-27 09:55:05','',''),(4101,'1','306','1',1,'Retail Sale Id 4119',6160.00,0.00,0.00,8.00,1048.00,'2023-01-27 09:57:28','',''),(4102,'1','306','1',1,'Retail Sale Id 4120',38500.00,0.00,0.00,50.00,6550.00,'2023-01-27 09:58:54','',''),(4103,'1','306','1',1,'Retail Sale Id 4121',85410.00,0.00,0.00,117.00,10647.00,'2023-01-27 10:01:11','',''),(4104,'1','306','1',1,'Retail Sale Id 4122',7700.00,0.00,0.00,10.00,1310.00,'2023-01-27 10:04:34','',''),(4105,'1','306','1',1,'Retail Sale Id 4123',4620.00,0.00,0.00,6.00,786.00,'2023-01-27 10:05:40','',''),(4106,'1','306','1',1,'Retail Sale Id 4125',2002.00,0.00,0.00,2.60,340.60,'2023-01-27 10:10:33','',''),(4107,'1','306','1',1,'Retail Sale Id 4126',9625.00,0.00,0.00,12.50,1637.50,'2023-01-27 10:24:45','',''),(4108,'1','306','1',1,'Retail Sale Id 4127',1501.50,0.00,0.00,1.95,255.45,'2023-01-27 10:31:19','',''),(4109,'1','306','1',1,'Retail Sale Id 4128',3850.00,0.00,0.00,5.00,655.00,'2023-01-27 10:32:16','',''),(4110,'1','306','1',1,'Retail Sale Id 4130',3996.30,0.00,0.00,5.19,679.89,'2023-01-27 10:34:21','',''),(4111,'1','306','1',1,'Retail Sale Id 4131',9490.00,0.00,0.00,13.00,1183.00,'2023-01-27 10:43:47','',''),(4112,'1','306','1',1,'Retail Sale Id 4132',4620.00,0.00,0.00,6.00,786.00,'2023-01-27 10:52:15','',''),(4113,'1','306','1',1,'Retail Sale Id 4133',4620.00,0.00,0.00,6.00,786.00,'2023-01-27 10:56:29','',''),(4114,'1','306','1',1,'Retail Sale Id 4134',2310.00,0.00,0.00,3.00,393.00,'2023-01-27 10:59:24','',''),(4115,'1','306','1',1,'Retail Sale Id 4135',7700.00,0.00,0.00,10.00,1310.00,'2023-01-27 11:01:27','',''),(4116,'1','306','1',1,'Retail Sale Id 4136',3996.30,0.00,0.00,5.19,679.89,'2023-01-27 11:02:23','',''),(4117,'1','306','1',1,'Retail Sale Id 4137',800.80,0.00,0.00,1.04,136.24,'2023-01-27 11:03:10','',''),(4118,'1','306','1',1,'Retail Sale Id 4138',18250.00,0.00,0.00,25.00,2275.00,'2023-01-27 11:09:42','',''),(4119,'1','306','1',1,'Retail Sale Id 4139',9625.00,0.00,0.00,12.50,1637.50,'2023-01-27 11:14:37','',''),(4120,'1','306','1',1,'Retail Sale Id 4140',9240.00,0.00,0.00,12.00,1572.00,'2023-01-27 11:16:31','',''),(4121,'1','306','1',1,'Retail Sale Id 4141',3080.00,0.00,0.00,4.00,524.00,'2023-01-27 11:17:33','',''),(4122,'1','306','1',1,'Retail Sale Id 4142',1155.00,0.00,0.00,1.50,196.50,'2023-01-27 11:18:44','',''),(4123,'1','306','1',1,'Retail Sale Id 4143',1540.00,0.00,0.00,2.00,262.00,'2023-01-27 11:21:33','',''),(4124,'1','306','1',1,'Retail Sale Id 4144',1501.50,0.00,0.00,1.95,255.45,'2023-01-27 11:22:20','',''),(4125,'1','306','1',1,'Return of Retail Sale Id 4143',0.00,1540.00,2.00,0.00,-262.00,'2023-01-27 11:23:11','',''),(4126,'1','306','1',1,'Retail Sale Id 4145',4620.00,0.00,0.00,6.00,786.00,'2023-01-27 11:28:33','',''),(4127,'1','306','1',1,'Retail Sale Id 4146',3850.00,0.00,0.00,5.00,655.00,'2023-01-27 11:43:57','',''),(4128,'1','306','1',1,'Retail Sale Id 4147',4496.80,0.00,0.00,5.84,765.04,'2023-01-27 11:45:43','',''),(4129,'1','306','1',1,'Retail Sale Id 4148',3850.00,0.00,0.00,5.00,655.00,'2023-01-27 12:02:21','',''),(4130,'1','306','1',1,'Retail Sale Id 4149',2002.00,0.00,0.00,2.60,340.60,'2023-01-27 12:08:07','',''),(4131,'1','306','1',1,'Retail Sale Id 4150',1540.00,0.00,0.00,2.00,262.00,'2023-01-27 12:16:21','',''),(4132,'1','306','1',1,'Retail Sale Id 4151',1501.50,0.00,0.00,1.95,255.45,'2023-01-27 12:18:54','',''),(4133,'1','306','1',1,'Retail Sale Id 4153',2310.00,0.00,0.00,3.00,393.00,'2023-01-27 12:26:24','',''),(4134,'1','306','1',1,'Retail Sale Id 4154',3080.00,0.00,0.00,4.00,524.00,'2023-01-27 12:30:49','',''),(4135,'1','306','1',1,'Retail Sale Id 4155',20020.00,0.00,0.00,26.00,3406.00,'2023-01-27 12:32:44','',''),(4136,'1','306','1',1,'Retail Sale Id 4156',2310.00,0.00,0.00,3.00,393.00,'2023-01-27 12:34:53','',''),(4137,'1','306','1',1,'Retail Sale Id 4157',3850.00,0.00,0.00,5.00,655.00,'2023-01-27 12:39:02','',''),(4138,'1','306','1',1,'Retail Sale Id 4158',2310.00,0.00,0.00,3.00,393.00,'2023-01-27 12:46:21','',''),(4139,'1','306','1',1,'Retail Sale Id 4159',4620.00,0.00,0.00,6.00,786.00,'2023-01-27 12:59:28','',''),(4140,'1','306','1',1,'Retail Sale Id 4160',2310.00,0.00,0.00,3.00,393.00,'2023-01-27 13:02:28','',''),(4141,'1','306','1',1,'Retail Sale Id 4161',800.80,0.00,0.00,1.04,136.24,'2023-01-27 13:04:51','',''),(4142,'1','306','1',1,'Retail Sale Id 4162',1501.50,0.00,0.00,1.95,255.45,'2023-01-27 13:12:12','',''),(4143,'1','306','1',1,'Retail Sale Id 4163',4620.00,0.00,0.00,6.00,786.00,'2023-01-27 13:13:00','',''),(4144,'1','306','1',1,'Retail Sale Id 4164',3850.00,0.00,0.00,5.00,655.00,'2023-01-27 13:19:05','',''),(4145,'1','306','1',1,'Retail Sale Id 4165',1501.50,0.00,0.00,1.95,255.45,'2023-01-27 14:40:34','',''),(4146,'1','306','1',1,'Retail Sale Id 4166',4620.00,0.00,0.00,6.00,786.00,'2023-01-27 14:41:41','',''),(4147,'1','306','1',1,'Retail Sale Id 4167',9625.00,0.00,0.00,12.50,1637.50,'2023-01-27 14:43:03','',''),(4148,'1','306','1',1,'Retail Sale Id 4168',3080.00,0.00,0.00,4.00,524.00,'2023-01-27 14:53:42','',''),(4149,'1','306','1',1,'Retail Sale Id 4170',2310.00,0.00,0.00,3.00,393.00,'2023-01-27 14:58:45','',''),(4150,'1','306','1',1,'Retail Sale Id 4171',4620.00,0.00,0.00,6.00,786.00,'2023-01-27 15:00:27','',''),(4151,'1','306','1',1,'Return of Retail Sale Id 4171',0.00,4620.00,6.00,0.00,-786.00,'2023-01-27 15:01:17','',''),(4152,'1','306','1',1,'Retail Sale Id 4172',4650.80,0.00,0.00,6.04,791.24,'2023-01-27 15:01:39','',''),(4153,'1','306','1',1,'Retail Sale Id 4174',2310.00,0.00,0.00,3.00,393.00,'2023-01-27 15:04:22','',''),(4154,'1','306','1',1,'Retail Sale Id 4175',1547.70,0.00,0.00,2.01,263.31,'2023-01-27 15:06:48','',''),(4155,'1','306','1',1,'Retail Sale Id 4176',1540.00,0.00,0.00,2.00,262.00,'2023-01-27 15:10:12','',''),(4156,'1','306','1',1,'Retail Sale Id 4177',4620.00,0.00,0.00,6.00,786.00,'2023-01-27 15:14:15','',''),(4157,'1','306','1',1,'Retail Sale Id 4178',3850.00,0.00,0.00,5.00,655.00,'2023-01-27 15:15:10','',''),(4158,'1','306','1',1,'Retail Sale Id 4179',4697.00,0.00,0.00,6.10,799.10,'2023-01-27 15:17:00','',''),(4159,'1','306','1',1,'Retail Sale Id 4180',600.60,0.00,0.00,0.78,102.18,'2023-01-27 15:17:45','',''),(4160,'1','306','1',1,'Retail Sale Id 4181',2310.00,0.00,0.00,3.00,393.00,'2023-01-27 15:24:32','',''),(4161,'1','306','1',1,'Retail Sale Id 4182',9702.00,0.00,0.00,12.60,1650.60,'2023-01-27 15:40:52','',''),(4162,'1','306','1',1,'Retail Sale Id 4183',4697.00,0.00,0.00,6.10,799.10,'2023-01-27 15:45:57','',''),(4163,'1','306','1',1,'Retail Sale Id 4184',4620.00,0.00,0.00,6.00,786.00,'2023-01-27 15:47:02','',''),(4164,'1','306','1',1,'Retail Sale Id 4185',1540.00,0.00,0.00,2.00,262.00,'2023-01-27 15:47:51','',''),(4165,'1','306','1',1,'Retail Sale Id 4186',9601.90,0.00,0.00,12.47,1633.57,'2023-01-27 15:49:12','',''),(4166,'1','306','1',1,'Retail Sale Id 4187',5390.00,0.00,0.00,7.00,917.00,'2023-01-27 15:50:18','',''),(4167,'1','306','1',1,'Retail Sale Id 4189',3080.00,0.00,0.00,4.00,524.00,'2023-01-27 15:51:44','',''),(4168,'1','306','1',1,'Retail Sale Id 4190',9625.00,0.00,0.00,12.50,1637.50,'2023-01-27 15:56:30','',''),(4169,'1','306','1',1,'Retail Sale Id 4191',4620.00,0.00,0.00,6.00,786.00,'2023-01-27 15:59:20','',''),(4170,'1','306','1',1,'Retail Sale Id 4192',1401.40,0.00,0.00,1.82,238.42,'2023-01-27 16:00:05','',''),(4171,'1','306','1',1,'Retail Sale Id 4193',3080.00,0.00,0.00,4.00,524.00,'2023-01-27 16:01:02','',''),(4172,'1','306','1',1,'Retail Sale Id 4194',3080.00,0.00,0.00,4.00,524.00,'2023-01-27 16:06:57','',''),(4173,'1','306','1',1,'Retail Sale Id 4195',3080.00,0.00,0.00,4.00,524.00,'2023-01-27 16:08:45','',''),(4174,'1','306','1',1,'Retail Sale Id 4196',4620.00,0.00,0.00,6.00,786.00,'2023-01-27 16:15:42','',''),(4175,'1','306','1',1,'Retail Sale Id 4197',4620.00,0.00,0.00,6.00,786.00,'2023-01-27 16:18:31','',''),(4176,'1','306','1',1,'Retail Sale Id 4198',1601.60,0.00,0.00,2.08,272.48,'2023-01-27 16:29:34','',''),(4177,'1','306','1',1,'Retail Sale Id 4200',777.70,0.00,0.00,1.01,132.31,'2023-01-27 16:30:50','',''),(4178,'1','306','1',1,'Retail Sale Id 4201',2310.00,0.00,0.00,3.00,393.00,'2023-01-27 16:31:37','',''),(4179,'1','306','1',1,'Retail Sale Id 4203',1601.60,0.00,0.00,2.08,272.48,'2023-01-27 16:32:48','',''),(4180,'1','306','1',1,'Retail Sale Id 4204',800.80,0.00,0.00,1.04,136.24,'2023-01-27 16:35:29','',''),(4181,'1','306','1',1,'Retail Sale Id 4205',2310.00,0.00,0.00,3.00,393.00,'2023-01-27 16:36:13','',''),(4182,'1','306','1',1,'Retail Sale Id 4206',2302.30,0.00,0.00,2.99,391.69,'2023-01-27 16:40:02','',''),(4183,'1','306','1',1,'Retail Sale Id 4209',4650.80,0.00,0.00,6.04,791.24,'2023-01-27 16:44:26','',''),(4184,'1','306','1',1,'Retail Sale Id 4212',2002.00,0.00,0.00,2.60,340.60,'2023-01-27 16:45:44','',''),(4185,'1','306','1',1,'Retail Sale Id 4213',2002.00,0.00,0.00,2.60,340.60,'2023-01-27 16:47:48','',''),(4186,'1','306','1',1,'Retail Sale Id 4214',5390.00,0.00,0.00,7.00,917.00,'2023-01-27 16:49:19','',''),(4187,'1','306','1',1,'Retail Sale Id 4215',69350.00,0.00,0.00,95.00,8645.00,'2023-01-27 16:50:55','',''),(4188,'1','306','1',1,'Retail Sale Id 4217',9702.00,0.00,0.00,12.60,1650.60,'2023-01-27 16:52:04','',''),(4189,'1','306','1',1,'Retail Sale Id 4218',2310.00,0.00,0.00,3.00,393.00,'2023-01-27 16:54:23','',''),(4190,'1','306','1',1,'Retail Sale Id 4219',3850.00,0.00,0.00,5.00,655.00,'2023-01-27 17:02:09','',''),(4191,'1','306','1',1,'Retail Sale Id 4221',2310.00,0.00,0.00,3.00,393.00,'2023-01-27 17:15:23','',''),(4192,'1','306','1',1,'Retail Sale Id 4222',4496.80,0.00,0.00,5.84,765.04,'2023-01-27 17:16:41','',''),(4193,'1','306','1',1,'Retail Sale Id 4223',3080.00,0.00,0.00,4.00,524.00,'2023-01-27 17:20:10','',''),(4194,'1','306','1',1,'Retail Sale Id 4224',1601.60,0.00,0.00,2.08,272.48,'2023-01-27 17:21:10','',''),(4195,'1','306','1',1,'Retail Sale Id 4225',4596.90,0.00,0.00,5.97,782.07,'2023-01-27 17:22:26','',''),(4196,'1','306','1',1,'Retail Sale Id 4226',2202.20,0.00,0.00,2.86,374.66,'2023-01-27 17:23:54','',''),(4197,'1','306','1',1,'Retail Sale Id 4227',9702.00,0.00,0.00,12.60,1650.60,'2023-01-27 17:25:19','',''),(4198,'1','306','1',1,'Retail Sale Id 4228',2348.50,0.00,0.00,3.05,399.55,'2023-01-27 17:28:28','',''),(4199,'1','306','1',1,'Retail Sale Id 4229',2310.00,0.00,0.00,3.00,393.00,'2023-01-27 17:29:28','',''),(4200,'1','306','1',1,'Retail Sale Id 4230',3850.00,0.00,0.00,5.00,655.00,'2023-01-27 17:34:34','',''),(4201,'1','306','1',1,'Retail Sale Id 4231',2310.00,0.00,0.00,3.00,393.00,'2023-01-27 17:36:35','',''),(4202,'1','306','1',1,'Retail Sale Id 4232',800.80,0.00,0.00,1.04,136.24,'2023-01-27 17:41:08','',''),(4203,'1','306','1',1,'Retail Sale Id 4233',2502.50,0.00,0.00,3.25,425.75,'2023-01-27 17:52:31','',''),(4204,'1','306','1',1,'Retail Sale Id 4234',38500.00,0.00,0.00,50.00,6550.00,'2023-01-27 17:53:53','',''),(4205,'1','306','1',1,'Retail Sale Id 4235',1540.00,0.00,0.00,2.00,262.00,'2023-01-27 17:54:55','',''),(4206,'1','306','1',1,'Retail Sale Id 4236',4997.30,0.00,0.00,6.49,850.19,'2023-01-27 17:58:12','',''),(4207,'1','306','1',1,'Retail Sale Id 4237',3850.00,0.00,0.00,5.00,655.00,'2023-01-27 17:59:15','',''),(4208,'1','306','1',1,'Retail Sale Id 4238',3080.00,0.00,0.00,4.00,524.00,'2023-01-27 18:08:28','',''),(4209,'1','306','1',1,'Return of Retail Sale Id 4235',0.00,1540.00,2.00,0.00,-262.00,'2023-01-27 18:38:01','',''),(4210,'1','306','1',1,'Retail Sale Id 4239',1555.40,0.00,0.00,2.02,264.62,'2023-01-27 18:39:17','',''),(4211,'1','306','1',1,'Retail Sale Id 4240',4273.50,0.00,0.00,5.55,727.05,'2023-01-28 07:21:44','',''),(4212,'1','306','1',1,'Retail Sale Id 4241',400.40,0.00,0.00,0.52,68.12,'2023-01-28 07:43:40','',''),(4213,'1','306','1',1,'Retail Sale Id 4242',4620.00,0.00,0.00,6.00,786.00,'2023-01-28 07:45:45','',''),(4214,'1','306','1',1,'Retail Sale Id 4243',7700.00,0.00,0.00,10.00,1310.00,'2023-01-28 07:48:45','',''),(4215,'1','306','1',1,'Retail Sale Id 4244',2310.00,0.00,0.00,3.00,393.00,'2023-01-28 07:58:48','',''),(4216,'1','306','1',1,'Retail Sale Id 4245',800.80,0.00,0.00,1.04,136.24,'2023-01-28 08:02:24','',''),(4217,'1','306','1',1,'Retail Sale Id 4246',3850.00,0.00,0.00,5.00,655.00,'2023-01-28 08:07:31','',''),(4218,'1','306','1',1,'Retail Sale Id 4247',1540.00,0.00,0.00,2.00,262.00,'2023-01-28 08:08:06','',''),(4219,'1','306','1',1,'Retail Sale Id 4248',2310.00,0.00,0.00,3.00,393.00,'2023-01-28 08:09:08','',''),(4220,'1','306','1',1,'Retail Sale Id 4249',4620.00,0.00,0.00,6.00,786.00,'2023-01-28 08:13:43','',''),(4221,'1','306','1',1,'Retail Sale Id 4250',9601.90,0.00,0.00,12.47,1633.57,'2023-01-28 08:17:16','',''),(4222,'1','306','1',1,'Retail Sale Id 4251',1601.60,0.00,0.00,2.08,272.48,'2023-01-28 08:22:16','',''),(4223,'1','306','1',1,'Retail Sale Id 4253',2302.30,0.00,0.00,2.99,391.69,'2023-01-28 08:24:31','',''),(4224,'1','306','1',1,'Retail Sale Id 4255',2302.30,0.00,0.00,2.99,391.69,'2023-01-28 08:25:37','',''),(4225,'1','306','1',1,'Retail Sale Id 4256',2310.00,0.00,0.00,3.00,393.00,'2023-01-28 08:27:40','',''),(4226,'1','306','1',1,'Retail Sale Id 4257',2310.00,0.00,0.00,3.00,393.00,'2023-01-28 08:32:21','',''),(4227,'1','306','1',1,'Retail Sale Id 4258',2002.00,0.00,0.00,2.60,340.60,'2023-01-28 08:33:13','',''),(4228,'1','306','1',1,'Retail Sale Id 4259',800.80,0.00,0.00,1.04,136.24,'2023-01-28 08:35:03','',''),(4229,'1','306','1',1,'Retail Sale Id 4260',4620.00,0.00,0.00,6.00,786.00,'2023-01-28 08:36:18','',''),(4230,'1','306','1',1,'Retail Sale Id 4261',4496.80,0.00,0.00,5.84,765.04,'2023-01-28 08:38:20','',''),(4231,'1','306','1',1,'Retail Sale Id 4262',4596.90,0.00,0.00,5.97,782.07,'2023-01-28 08:47:48','',''),(4232,'1','306','1',1,'Retail Sale Id 4263',8500.80,0.00,0.00,11.04,1446.24,'2023-01-28 08:48:40','',''),(4233,'1','306','1',1,'Retail Sale Id 4265',4596.90,0.00,0.00,5.97,782.07,'2023-01-28 08:49:57','',''),(4234,'1','306','1',1,'Retail Sale Id 4266',2310.00,0.00,0.00,3.00,393.00,'2023-01-28 08:54:00','',''),(4235,'1','306','1',1,'Retail Sale Id 4267',2302.30,0.00,0.00,2.99,391.69,'2023-01-28 08:57:09','',''),(4236,'1','306','1',1,'Retail Sale Id 4268',3080.00,0.00,0.00,4.00,524.00,'2023-01-28 09:02:08','',''),(4237,'1','306','1',1,'Retail Sale Id 4269',1540.00,0.00,0.00,2.00,262.00,'2023-01-28 09:03:15','',''),(4238,'1','306','1',1,'Retail Sale Id 4270',3503.50,0.00,0.00,4.55,596.05,'2023-01-28 09:11:10','',''),(4239,'1','306','1',1,'Retail Sale Id 4271',35040.00,0.00,0.00,48.00,4368.00,'2023-01-28 09:12:43','',''),(4240,'1','306','1',1,'Retail Sale Id 4272',4620.00,0.00,0.00,6.00,786.00,'2023-01-28 09:16:16','',''),(4241,'1','306','1',1,'Retail Sale Id 4273',1501.50,0.00,0.00,1.95,255.45,'2023-01-28 09:17:48','',''),(4242,'1','306','1',1,'Retail Sale Id 4274',9240.00,0.00,0.00,12.00,1572.00,'2023-01-28 09:30:02','',''),(4243,'1','306','1',1,'Retail Sale Id 4275',2002.00,0.00,0.00,2.60,340.60,'2023-01-28 09:31:59','',''),(4244,'1','306','1',1,'Retail Sale Id 4276',3080.00,0.00,0.00,4.00,524.00,'2023-01-28 09:32:50','',''),(4245,'1','306','1',1,'Retail Sale Id 4277',9625.00,0.00,0.00,12.50,1637.50,'2023-01-28 09:36:01','',''),(4246,'1','306','1',1,'Retail Sale Id 4278',3080.00,0.00,0.00,4.00,524.00,'2023-01-28 09:38:09','',''),(4247,'1','306','1',1,'Retail Sale Id 4279',4596.90,0.00,0.00,5.97,782.07,'2023-01-28 09:39:29','',''),(4248,'1','306','1',1,'Retail Sale Id 4280',2302.30,0.00,0.00,2.99,391.69,'2023-01-28 09:42:16','',''),(4249,'1','306','1',1,'Retail Sale Id 4281',9601.90,0.00,0.00,12.47,1633.57,'2023-01-28 09:44:39','',''),(4250,'1','306','1',1,'Retail Sale Id 4282',3850.00,0.00,0.00,5.00,655.00,'2023-01-28 09:46:01','',''),(4251,'1','306','1',1,'Retail Sale Id 4283',2302.30,0.00,0.00,2.99,391.69,'2023-01-28 09:49:57','',''),(4252,'1','306','1',1,'Retail Sale Id 4284',3803.80,0.00,0.00,4.94,647.14,'2023-01-28 09:51:06','',''),(4253,'1','306','1',1,'Retail Sale Id 4285',2310.00,0.00,0.00,3.00,393.00,'2023-01-28 09:52:24','',''),(4254,'1','306','1',1,'Retail Sale Id 4286',3850.00,0.00,0.00,5.00,655.00,'2023-01-28 09:53:29','',''),(4255,'1','306','1',1,'Retail Sale Id 4287',3080.00,0.00,0.00,4.00,524.00,'2023-01-28 09:55:49','',''),(4256,'1','306','1',1,'Retail Sale Id 4288',800.80,0.00,0.00,1.04,136.24,'2023-01-28 10:08:11','',''),(4257,'1','306','1',1,'Retail Sale Id 4289',4596.90,0.00,0.00,5.97,782.07,'2023-01-28 10:11:30','',''),(4258,'1','306','1',1,'Retail Sale Id 4290',2348.50,0.00,0.00,3.05,399.55,'2023-01-28 10:12:29','',''),(4259,'1','306','1',1,'Retail Sale Id 4291',800.80,0.00,0.00,1.04,136.24,'2023-01-28 10:14:53','',''),(4260,'1','306','1',1,'Retail Sale Id 4292',1501.50,0.00,0.00,1.95,255.45,'2023-01-28 10:19:45','',''),(4261,'1','306','1',1,'Retail Sale Id 4293',4596.90,0.00,0.00,5.97,782.07,'2023-01-28 10:21:46','',''),(4262,'1','306','1',1,'Retail Sale Id 4294',4697.00,0.00,0.00,6.10,799.10,'2023-01-28 10:23:00','',''),(4263,'1','306','1',1,'Retail Sale Id 4295',9601.90,0.00,0.00,12.47,1633.57,'2023-01-28 10:24:10','',''),(4264,'1','306','1',1,'Retail Sale Id 4296',3003.00,0.00,0.00,3.90,510.90,'2023-01-28 10:25:07','',''),(4265,'1','306','1',1,'Retail Sale Id 4298',1001.00,0.00,0.00,1.30,170.30,'2023-01-28 10:28:17','',''),(4266,'1','306','1',1,'Retail Sale Id 4299',2310.00,0.00,0.00,3.00,393.00,'2023-01-28 10:29:09','',''),(4267,'1','306','1',1,'Retail Sale Id 4300',2310.00,0.00,0.00,3.00,393.00,'2023-01-28 10:30:19','',''),(4268,'1','306','1',1,'Retail Sale Id 4301',43800.00,0.00,0.00,60.00,5460.00,'2023-01-28 10:31:25','',''),(4269,'1','306','1',1,'Retail Sale Id 4302',1501.50,0.00,0.00,1.95,255.45,'2023-01-28 10:33:03','',''),(4270,'1','306','1',1,'Retail Sale Id 4303',2502.50,0.00,0.00,3.25,425.75,'2023-01-28 10:40:37','',''),(4271,'1','306','1',1,'Retail Sale Id 4304',85410.00,0.00,0.00,117.00,10647.00,'2023-01-28 10:43:45','',''),(4272,'1','306','1',1,'Retail Sale Id 4305',2302.30,0.00,0.00,2.99,391.69,'2023-01-28 10:47:43','',''),(4273,'1','306','1',1,'Retail Sale Id 4306',7700.00,0.00,0.00,10.00,1310.00,'2023-01-28 10:49:07','',''),(4274,'1','306','1',1,'Retail Sale Id 4307',3896.20,0.00,0.00,5.06,662.86,'2023-01-28 11:08:44','',''),(4275,'1','306','1',1,'Retail Sale Id 4308',2348.50,0.00,0.00,3.05,399.55,'2023-01-28 11:12:34','',''),(4276,'1','306','1',1,'Retail Sale Id 4309',4697.00,0.00,0.00,6.10,799.10,'2023-01-28 11:14:06','',''),(4277,'1','306','1',1,'Retail Sale Id 4310',2310.00,0.00,0.00,3.00,393.00,'2023-01-28 11:26:44','',''),(4278,'1','306','1',1,'Retail Sale Id 4311',2310.00,0.00,0.00,3.00,393.00,'2023-01-28 11:27:30','',''),(4279,'1','306','1',1,'Retail Sale Id 4312',2302.30,0.00,0.00,2.99,391.69,'2023-01-28 11:28:44','',''),(4280,'1','306','1',1,'Retail Sale Id 4313',4620.00,0.00,0.00,6.00,786.00,'2023-01-28 11:29:46','',''),(4281,'1','306','1',1,'Retail Sale Id 4314',6930.00,0.00,0.00,9.00,1179.00,'2023-01-28 11:31:43','',''),(4282,'1','306','1',1,'Retail Sale Id 4315',3850.00,0.00,0.00,5.00,655.00,'2023-01-28 11:36:54','',''),(4283,'1','306','1',1,'Retail Sale Id 4316',3850.00,0.00,0.00,5.00,655.00,'2023-01-28 11:45:19','',''),(4284,'1','306','1',1,'Retail Sale Id 4317',4620.00,0.00,0.00,6.00,786.00,'2023-01-28 11:46:41','',''),(4285,'1','306','1',1,'Retail Sale Id 4318',9601.90,0.00,0.00,12.47,1633.57,'2023-01-28 11:52:03','',''),(4286,'1','306','1',1,'Retail Sale Id 4319',2502.50,0.00,0.00,3.25,425.75,'2023-01-28 11:53:25','',''),(4287,'1','306','1',1,'Retail Sale Id 4320',2302.30,0.00,0.00,2.99,391.69,'2023-01-28 11:55:27','',''),(4288,'1','306','1',1,'Retail Sale Id 4321',18250.00,0.00,0.00,25.00,2275.00,'2023-01-28 11:59:22','',''),(4289,'1','306','1',1,'Retail Sale Id 4322',2502.50,0.00,0.00,3.25,425.75,'2023-01-28 12:02:30','',''),(4290,'1','306','1',1,'Retail Sale Id 4323',4620.00,0.00,0.00,6.00,786.00,'2023-01-28 12:03:19','',''),(4291,'1','306','1',1,'Retail Sale Id 4324',2310.00,0.00,0.00,3.00,393.00,'2023-01-28 12:12:13','',''),(4292,'1','306','1',1,'Retail Sale Id 4326',2302.30,0.00,0.00,2.99,391.69,'2023-01-28 12:15:15','',''),(4293,'1','306','1',1,'Retail Sale Id 4327',3803.80,0.00,0.00,4.94,647.14,'2023-01-28 12:24:06','',''),(4294,'1','306','1',1,'Retail Sale Id 4328',3896.20,0.00,0.00,5.06,662.86,'2023-01-28 12:26:11','',''),(4295,'1','306','1',1,'Retail Sale Id 4329',2502.50,0.00,0.00,3.25,425.75,'2023-01-28 12:36:13','',''),(4296,'1','306','1',1,'Retail Sale Id 4330',3080.00,0.00,0.00,4.00,524.00,'2023-01-28 12:45:28','',''),(4297,'1','306','1',1,'Retail Sale Id 4331',85045.00,0.00,0.00,116.50,10601.50,'2023-01-28 12:50:55','',''),(4298,'1','306','1',1,'Retail Sale Id 4332',3080.00,0.00,0.00,4.00,524.00,'2023-01-28 12:51:42','',''),(4299,'1','306','1',1,'Retail Sale Id 4333',2310.00,0.00,0.00,3.00,393.00,'2023-01-28 12:54:05','',''),(4300,'1','306','1',1,'Retail Sale Id 4334',4596.90,0.00,0.00,5.97,782.07,'2023-01-28 12:58:22','',''),(4301,'1','306','1',1,'Retail Sale Id 4335',1001.00,0.00,0.00,1.30,170.30,'2023-01-28 13:02:40','',''),(4302,'1','306','1',1,'Retail Sale Id 4336',4596.90,0.00,0.00,5.97,782.07,'2023-01-28 13:04:29','',''),(4303,'1','306','1',1,'Retail Sale Id 4337',5390.00,0.00,0.00,7.00,917.00,'2023-01-28 13:06:20','',''),(4304,'1','306','1',1,'Retail Sale Id 4338',2310.00,0.00,0.00,3.00,393.00,'2023-01-28 13:12:10','',''),(4305,'1','306','1',1,'Retail Sale Id 4338',4620.00,0.00,0.00,6.00,786.00,'2023-01-28 13:12:11','',''),(4306,'1','306','1',1,'Retail Sale Id 4339',3080.00,0.00,0.00,4.00,524.00,'2023-01-28 13:29:51','',''),(4307,'1','306','1',1,'Retail Sale Id 4340',2002.00,0.00,0.00,2.60,340.60,'2023-01-28 13:34:57','',''),(4308,'1','306','1',1,'Retail Sale Id 4341',3003.00,0.00,0.00,3.90,510.90,'2023-01-28 13:41:28','',''),(4309,'1','306','1',1,'Retail Sale Id 4342',3103.10,0.00,0.00,4.03,527.93,'2023-01-28 13:43:54','',''),(4310,'1','306','1',1,'Retail Sale Id 4343',9702.00,0.00,0.00,12.60,1650.60,'2023-01-28 13:51:35','',''),(4311,'1','306','1',1,'Retail Sale Id 4344',3103.10,0.00,0.00,4.03,527.93,'2023-01-28 13:56:03','',''),(4312,'1','306','1',1,'Retail Sale Id 4345',1501.50,0.00,0.00,1.95,255.45,'2023-01-28 13:57:04','',''),(4313,'1','306','1',1,'Retail Sale Id 4346',4620.00,0.00,0.00,6.00,786.00,'2023-01-28 14:00:06','',''),(4314,'1','306','1',1,'Retail Sale Id 4347',1001.00,0.00,0.00,1.30,170.30,'2023-01-28 14:06:47','',''),(4315,'1','306','1',1,'Retail Sale Id 4348',5390.00,0.00,0.00,7.00,917.00,'2023-01-28 14:09:18','',''),(4316,'1','306','1',1,'Retail Sale Id 4349',8801.10,0.00,0.00,11.43,1497.33,'2023-01-28 14:12:14','',''),(4317,'1','306','1',1,'Retail Sale Id 4350',9301.60,0.00,0.00,12.08,1582.48,'2023-01-28 14:20:49','',''),(4318,'1','306','1',1,'Retail Sale Id 4351',9501.80,0.00,0.00,12.34,1616.54,'2023-01-28 14:23:54','',''),(4319,'1','306','1',1,'Retail Sale Id 4354',3996.30,0.00,0.00,5.19,679.89,'2023-01-28 14:33:07','',''),(4320,'1','306','1',1,'Retail Sale Id 4355',1001.00,0.00,0.00,1.30,170.30,'2023-01-28 14:33:58','',''),(4321,'1','306','1',1,'Retail Sale Id 4356',3003.00,0.00,0.00,3.90,510.90,'2023-01-28 14:35:00','',''),(4322,'1','306','1',1,'Retail Sale Id 4357',2348.50,0.00,0.00,3.05,399.55,'2023-01-28 14:35:54','',''),(4323,'1','306','1',1,'Retail Sale Id 4358',1547.70,0.00,0.00,2.01,263.31,'2023-01-28 14:42:04','',''),(4324,'1','306','1',1,'Retail Sale Id 4359',1547.70,0.00,0.00,2.01,263.31,'2023-01-28 14:44:06','',''),(4325,'1','306','1',1,'Retail Sale Id 4360',1540.00,0.00,0.00,2.00,262.00,'2023-01-28 14:45:18','',''),(4326,'1','306','1',1,'Retail Sale Id 4361',2310.00,0.00,0.00,3.00,393.00,'2023-01-28 14:46:32','',''),(4327,'1','306','1',1,'Retail Sale Id 4362',1540.00,0.00,0.00,2.00,262.00,'2023-01-28 14:54:03','',''),(4328,'1','306','1',1,'Retail Sale Id 4364',2310.00,0.00,0.00,3.00,393.00,'2023-01-28 14:56:14','',''),(4329,'1','306','1',1,'Retail Sale Id 4366',5798.10,0.00,0.00,7.53,986.43,'2023-01-28 15:01:36','',''),(4330,'1','306','1',1,'Retail Sale Id 4367',7700.00,0.00,0.00,10.00,1310.00,'2023-01-28 15:04:46','',''),(4331,'1','306','1',1,'Retail Sale Id 4369',1601.60,0.00,0.00,2.08,272.48,'2023-01-28 15:10:51','',''),(4332,'1','306','1',1,'Retail Sale Id 4370',9632.70,0.00,0.00,12.51,1638.81,'2023-01-28 15:15:03','',''),(4333,'1','306','1',1,'Retail Sale Id 4371',4620.00,0.00,0.00,6.00,786.00,'2023-01-28 15:16:44','',''),(4334,'1','306','1',1,'Retail Sale Id 4371',9625.00,0.00,0.00,12.50,1637.50,'2023-01-28 15:16:44','',''),(4335,'1','306','1',1,'Retail Sale Id 4372',4650.80,0.00,0.00,6.04,791.24,'2023-01-28 15:18:23','',''),(4336,'1','306','1',1,'Retail Sale Id 4373',2310.00,0.00,0.00,3.00,393.00,'2023-01-28 15:21:09','',''),(4337,'1','306','1',1,'Retail Sale Id 4374',2802.80,0.00,0.00,3.64,476.84,'2023-01-28 15:25:11','',''),(4338,'1','306','1',1,'Retail Sale Id 4375',6930.00,0.00,0.00,9.00,1179.00,'2023-01-28 15:27:52','',''),(4339,'1','306','1',1,'Retail Sale Id 4376',4596.90,0.00,0.00,5.97,782.07,'2023-01-28 15:29:23','',''),(4340,'1','306','1',1,'Retail Sale Id 4377',2310.00,0.00,0.00,3.00,393.00,'2023-01-28 15:34:14','',''),(4341,'1','306','1',1,'Retail Sale Id 4378',1601.60,0.00,0.00,2.08,272.48,'2023-01-28 15:40:44','',''),(4342,'1','306','1',1,'Retail Sale Id 4379',2310.00,0.00,0.00,3.00,393.00,'2023-01-28 15:48:58','',''),(4343,'1','306','1',1,'Retail Sale Id 4379',4620.00,0.00,0.00,6.00,786.00,'2023-01-28 15:48:58','',''),(4344,'1','306','1',1,'Retail Sale Id 4380',1601.60,0.00,0.00,2.08,272.48,'2023-01-28 15:54:54','',''),(4345,'1','306','1',1,'Retail Sale Id 4382',800.80,0.00,0.00,1.04,136.24,'2023-01-28 15:59:20','',''),(4346,'1','306','1',1,'Retail Sale Id 4382',800.80,0.00,0.00,1.04,136.24,'2023-01-28 15:59:20','',''),(4347,'1','306','1',1,'Retail Sale Id 4383',1001.00,0.00,0.00,1.30,170.30,'2023-01-28 16:02:29','',''),(4348,'1','306','1',1,'Retail Sale Id 4384',43800.00,0.00,0.00,60.00,5460.00,'2023-01-28 16:06:26','',''),(4349,'1','306','1',1,'Retail Sale Id 4385',4596.90,0.00,0.00,5.97,782.07,'2023-01-28 16:07:27','',''),(4350,'1','306','1',1,'Retail Sale Id 4386',8030.00,0.00,0.00,11.00,1001.00,'2023-01-28 16:08:50','',''),(4351,'1','306','1',1,'Retail Sale Id 4387',1001.00,0.00,0.00,1.30,170.30,'2023-01-28 16:10:15','',''),(4352,'1','306','1',1,'Retail Sale Id 4388',800.80,0.00,0.00,1.04,136.24,'2023-01-28 16:11:40','',''),(4353,'1','306','1',1,'Retail Sale Id 4389',3850.00,0.00,0.00,5.00,655.00,'2023-01-28 16:13:40','',''),(4354,'1','306','1',1,'Retail Sale Id 4390',2310.00,0.00,0.00,3.00,393.00,'2023-01-28 16:19:55','',''),(4355,'1','306','1',1,'Retail Sale Id 4391',1501.50,0.00,0.00,1.95,255.45,'2023-01-28 16:27:35','',''),(4356,'1','306','1',1,'Retail Sale Id 4392',2310.00,0.00,0.00,3.00,393.00,'2023-01-28 16:30:12','',''),(4357,'1','306','1',1,'Retail Sale Id 4393',3996.30,0.00,0.00,5.19,679.89,'2023-01-28 16:34:23','',''),(4358,'1','306','1',1,'Retail Sale Id 4393',6999.30,0.00,0.00,9.09,1190.79,'2023-01-28 16:34:23','',''),(4359,'1','306','1',1,'Retail Sale Id 4394',3850.00,0.00,0.00,5.00,655.00,'2023-01-28 16:35:50','',''),(4360,'1','306','1',1,'Retail Sale Id 4395',3850.00,0.00,0.00,5.00,655.00,'2023-01-28 16:42:42','',''),(4361,'1','306','1',1,'Retail Sale Id 4396',2502.50,0.00,0.00,3.25,425.75,'2023-01-28 16:43:38','',''),(4362,'1','306','1',1,'Retail Sale Id 4397',2302.30,0.00,0.00,2.99,391.69,'2023-01-28 16:44:26','',''),(4363,'1','306','1',1,'Retail Sale Id 4398',9501.80,0.00,0.00,12.34,1616.54,'2023-01-28 16:46:58','',''),(4364,'1','306','1',1,'Retail Sale Id 4400',4596.90,0.00,0.00,5.97,782.07,'2023-01-28 16:49:00','',''),(4365,'1','306','1',1,'Retail Sale Id 4401',3850.00,0.00,0.00,5.00,655.00,'2023-01-28 16:49:47','',''),(4366,'1','306','1',1,'Retail Sale Id 4402',2310.00,0.00,0.00,3.00,393.00,'2023-01-28 16:50:57','',''),(4367,'1','306','1',1,'Retail Sale Id 4403',800.80,0.00,0.00,1.04,136.24,'2023-01-28 16:57:21','',''),(4368,'1','306','1',1,'Retail Sale Id 4404',3080.00,0.00,0.00,4.00,524.00,'2023-01-28 16:57:58','',''),(4369,'1','306','1',1,'Retail Sale Id 4405',2872.10,0.00,0.00,3.73,488.63,'2023-01-28 17:07:14','',''),(4370,'1','306','1',1,'Return of Retail Sale Id 4398',0.00,9501.80,12.34,0.00,-1616.54,'2023-01-28 17:11:06','',''),(4371,'1','306','1',1,'Retail Sale Id 4406',8423.80,0.00,0.00,10.94,1433.14,'2023-01-28 17:12:28','',''),(4372,'1','306','1',1,'Distributed to SOLO GAS for sales id:2',46148.58,0.00,0.00,72.22,0.00,'2023-01-28 17:20:22','',''),(4373,'1','306',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,3450600.00,5400.00,0.00,0.00,'2023-01-29 06:55:57','',''),(4374,'1','306',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,5400.00,0.00,'2023-01-29 06:57:06','',''),(4375,'1','306','1',1,'Received from bridging 12',0.00,0.00,5400.00,0.00,0.00,'2023-01-29 06:57:06','',''),(4376,'1','306','1',1,'Retail Sale Id 4417',4620.00,0.00,0.00,6.00,786.00,'2023-01-29 10:13:36','',''),(4377,'1','306','1',1,'Retail Sale Id 4418',770.00,0.00,0.00,1.00,131.00,'2023-01-29 10:15:06','',''),(4378,'1','306','1',1,'Return of Retail Sale Id 4418',0.00,770.00,1.00,0.00,-131.00,'2023-01-29 10:17:03','',''),(4379,'1','306','1',1,'Return of Retail Sale Id 4417',0.00,4620.00,6.00,0.00,-786.00,'2023-01-29 10:17:31','',''),(4380,'1','306','1',1,'Retail Sale Id 4419',1501.50,0.00,0.00,1.95,255.45,'2023-01-29 10:25:44','',''),(4381,'1','306','1',1,'Retail Sale Id 4420',2302.30,0.00,0.00,2.99,391.69,'2023-01-29 10:36:14','',''),(4382,'1','306','1',1,'Retail Sale Id 4421',2302.30,0.00,0.00,2.99,391.69,'2023-01-29 10:48:10','',''),(4383,'1','306','1',1,'Retail Sale Id 4422',9301.60,0.00,0.00,12.08,1582.48,'2023-01-29 10:49:33','',''),(4384,'1','306','1',1,'Retail Sale Id 4423',4596.90,0.00,0.00,5.97,782.07,'2023-01-29 10:57:17','',''),(4385,'1','306','1',1,'Retail Sale Id 4424',3850.00,0.00,0.00,5.00,655.00,'2023-01-29 10:59:20','',''),(4386,'1','306','1',1,'Retail Sale Id 4425',3850.00,0.00,0.00,5.00,655.00,'2023-01-29 11:10:07','',''),(4387,'1','306','1',1,'Retail Sale Id 4426',2002.00,0.00,0.00,2.60,340.60,'2023-01-29 11:19:11','',''),(4388,'1','306','1',1,'Retail Sale Id 4427',9247.70,0.00,0.00,12.01,1573.31,'2023-01-29 11:24:35','',''),(4389,'1','306','1',1,'Retail Sale Id 4428',3850.00,0.00,0.00,5.00,655.00,'2023-01-29 11:26:26','',''),(4390,'1','306','1',1,'Retail Sale Id 4429',2317.70,0.00,0.00,3.01,394.31,'2023-01-29 11:28:29','',''),(4391,'1','306','1',1,'Retail Sale Id 4431',1501.50,0.00,0.00,1.95,255.45,'2023-01-29 11:42:32','',''),(4392,'1','306','1',1,'Retail Sale Id 4432',770.00,0.00,0.00,1.00,131.00,'2023-01-29 11:52:36','',''),(4393,'1','306','1',1,'Retail Sale Id 4433',2302.30,0.00,0.00,2.99,391.69,'2023-01-29 11:58:55','',''),(4394,'1','306','1',1,'Retail Sale Id 4434',800.80,0.00,0.00,1.04,136.24,'2023-01-29 12:06:30','',''),(4395,'1','306','1',1,'Retail Sale Id 4435',1547.70,0.00,0.00,2.01,263.31,'2023-01-29 12:18:20','',''),(4396,'1','306','1',1,'Retail Sale Id 4436',1501.50,0.00,0.00,1.95,255.45,'2023-01-29 12:20:11','',''),(4397,'1','306','1',1,'Retail Sale Id 4437',1501.50,0.00,0.00,1.95,255.45,'2023-01-29 12:21:50','',''),(4398,'1','306','1',1,'Retail Sale Id 4438',1501.50,0.00,0.00,1.95,255.45,'2023-01-29 12:24:28','',''),(4399,'1','306','1',1,'Retail Sale Id 4439',3850.00,0.00,0.00,5.00,655.00,'2023-01-29 12:25:56','',''),(4400,'1','306','1',1,'Retail Sale Id 4440',1540.00,0.00,0.00,2.00,262.00,'2023-01-29 12:28:11','',''),(4401,'1','306','1',1,'Retail Sale Id 4441',1501.50,0.00,0.00,1.95,255.45,'2023-01-29 12:35:09','',''),(4402,'1','306','1',1,'Retail Sale Id 4442',20440.00,0.00,0.00,28.00,2548.00,'2023-01-29 12:52:55','',''),(4403,'1','306','1',1,'Retail Sale Id 4443',111696.20,0.00,0.00,145.06,19002.86,'2023-01-29 12:55:28','',''),(4404,'1','306','1',1,'Retail Sale Id 4444',2002.00,0.00,0.00,2.60,340.60,'2023-01-29 13:03:12','',''),(4405,'1','306','1',1,'Retail Sale Id 4445',9125.00,0.00,0.00,12.50,1137.50,'2023-01-29 13:14:34','',''),(4406,'1','306','1',1,'Retail Sale Id 4446',2310.00,0.00,0.00,3.00,393.00,'2023-01-29 13:17:10','',''),(4407,'1','306','1',1,'Retail Sale Id 4447',800.80,0.00,0.00,1.04,136.24,'2023-01-29 13:37:25','',''),(4408,'1','306','1',1,'Retail Sale Id 4448',4697.00,0.00,0.00,6.10,799.10,'2023-01-29 13:57:01','',''),(4409,'1','306','1',1,'Retail Sale Id 4450',29930.00,0.00,0.00,41.00,3731.00,'2023-01-29 14:00:18','',''),(4410,'1','306','1',1,'Retail Sale Id 4451',4596.90,0.00,0.00,5.97,782.07,'2023-01-29 14:06:54','',''),(4411,'1','306','1',1,'Retail Sale Id 4452',4620.00,0.00,0.00,6.00,786.00,'2023-01-29 14:34:04','',''),(4412,'1','306','1',1,'Retail Sale Id 4452',4620.00,0.00,0.00,6.00,786.00,'2023-01-29 14:34:04','',''),(4413,'1','306','1',1,'Retail Sale Id 4452',4620.00,0.00,0.00,6.00,786.00,'2023-01-29 14:34:04','',''),(4414,'1','306','1',1,'Retail Sale Id 4453',4596.90,0.00,0.00,5.97,782.07,'2023-01-29 14:36:20','',''),(4415,'1','306','1',1,'Retail Sale Id 4454',3850.00,0.00,0.00,5.00,655.00,'2023-01-29 14:43:06','',''),(4416,'1','306','1',1,'Retail Sale Id 4455',1540.00,0.00,0.00,2.00,262.00,'2023-01-29 14:54:20','',''),(4417,'1','306','1',1,'Retail Sale Id 4455',3850.00,0.00,0.00,5.00,655.00,'2023-01-29 14:54:20','',''),(4418,'1','306','1',1,'Retail Sale Id 4456',4620.00,0.00,0.00,6.00,786.00,'2023-01-29 15:01:39','',''),(4419,'1','306','1',1,'Retail Sale Id 4457',1501.50,0.00,0.00,1.95,255.45,'2023-01-29 15:04:29','',''),(4420,'1','306','1',1,'Retail Sale Id 4458',9001.30,0.00,0.00,11.69,1531.39,'2023-01-29 15:16:47','',''),(4421,'1','306','1',1,'Retail Sale Id 4459',2002.00,0.00,0.00,2.60,340.60,'2023-01-29 15:23:03','',''),(4422,'1','306','1',1,'Retail Sale Id 4460',2002.00,0.00,0.00,2.60,340.60,'2023-01-29 15:24:08','',''),(4423,'1','306','1',1,'Retail Sale Id 4461',9625.00,0.00,0.00,12.50,1637.50,'2023-01-29 15:37:55','',''),(4424,'1','306','1',1,'Retail Sale Id 4463',4596.90,0.00,0.00,5.97,782.07,'2023-01-29 15:41:14','',''),(4425,'1','306','1',1,'Retail Sale Id 4464',4596.90,0.00,0.00,5.97,782.07,'2023-01-29 15:42:34','',''),(4426,'1','306','1',1,'Retail Sale Id 4465',1540.00,0.00,0.00,2.00,262.00,'2023-01-29 15:45:59','',''),(4427,'1','306','1',1,'Retail Sale Id 4466',3850.00,0.00,0.00,5.00,655.00,'2023-01-29 15:50:29','',''),(4428,'1','306','1',1,'Retail Sale Id 4467',1701.70,0.00,0.00,2.21,289.51,'2023-01-29 15:52:32','',''),(4429,'1','306','1',1,'Retail Sale Id 4468',3003.00,0.00,0.00,3.90,510.90,'2023-01-29 16:05:14','',''),(4430,'1','306','1',1,'Retail Sale Id 4469',3850.00,0.00,0.00,5.00,655.00,'2023-01-29 16:07:10','',''),(4431,'1','306','1',1,'Retail Sale Id 4470',4620.00,0.00,0.00,6.00,786.00,'2023-01-29 16:13:14','',''),(4432,'1','306','1',1,'Retail Sale Id 4471',4620.00,0.00,0.00,6.00,786.00,'2023-01-29 16:16:57','',''),(4433,'1','306','1',1,'Retail Sale Id 4472',2348.50,0.00,0.00,3.05,399.55,'2023-01-29 16:20:51','',''),(4434,'1','306','1',1,'Retail Sale Id 4473',2310.00,0.00,0.00,3.00,393.00,'2023-01-29 16:23:51','',''),(4435,'1','306','1',1,'Retail Sale Id 4474',2310.00,0.00,0.00,3.00,393.00,'2023-01-29 16:29:38','',''),(4436,'1','306','1',1,'Retail Sale Id 4475',3850.00,0.00,0.00,5.00,655.00,'2023-01-29 16:35:58','',''),(4437,'1','306','1',1,'Retail Sale Id 4476',3850.00,0.00,0.00,5.00,655.00,'2023-01-29 16:36:48','',''),(4438,'1','306','1',1,'Retail Sale Id 4477',1501.50,0.00,0.00,1.95,255.45,'2023-01-29 16:41:58','',''),(4439,'1','306','1',1,'Retail Sale Id 4478',1501.50,0.00,0.00,1.95,255.45,'2023-01-29 16:43:15','',''),(4440,'1','306','1',1,'Retail Sale Id 4479',800.80,0.00,0.00,1.04,136.24,'2023-01-29 16:46:40','',''),(4441,'1','306','1',1,'Retail Sale Id 4480',3850.00,0.00,0.00,5.00,655.00,'2023-01-29 16:50:41','',''),(4442,'1','306','1',1,'Retail Sale Id 4481',1540.00,0.00,0.00,2.00,262.00,'2023-01-29 16:52:32','',''),(4443,'1','306','1',1,'Retail Sale Id 4482',2310.00,0.00,0.00,3.00,393.00,'2023-01-29 16:56:18','',''),(4444,'1','306','1',1,'Retail Sale Id 4483',3850.00,0.00,0.00,5.00,655.00,'2023-01-29 17:01:54','',''),(4445,'1','306','1',1,'Retail Sale Id 4484',800.80,0.00,0.00,1.04,136.24,'2023-01-29 17:04:34','',''),(4446,'1','306','1',1,'Retail Sale Id 4485',2302.30,0.00,0.00,2.99,391.69,'2023-01-29 17:30:16','',''),(4447,'1','306','1',1,'Retail Sale Id 4486',9648.10,0.00,0.00,12.53,1641.43,'2023-01-29 17:31:10','',''),(4448,'1','306','1',1,'Retail Sale Id 4487',3896.20,0.00,0.00,5.06,662.86,'2023-01-29 17:34:50','',''),(4449,'1','306','1',1,'Retail Sale Id 4488',9702.00,0.00,0.00,12.60,1650.60,'2023-01-29 17:47:06','',''),(4450,'1','306','1',1,'Retail Sale Id 4489',1547.70,0.00,0.00,2.01,263.31,'2023-01-29 17:48:04','',''),(4451,'1','306','1',1,'Retail Sale Id 4490',2310.00,0.00,0.00,3.00,393.00,'2023-01-29 17:53:47','',''),(4452,'1','306','1',1,'Retail Sale Id 4491',5390.00,0.00,0.00,7.00,917.00,'2023-01-29 18:28:36','',''),(4453,'1','306','1',1,'Retail Sale Id 4492',3996.30,0.00,0.00,5.19,679.89,'2023-01-29 18:30:35','',''),(4454,'1','306','1',1,'Retail Sale Id 4493',1001.00,0.00,0.00,1.30,170.30,'2023-01-30 07:30:59','',''),(4455,'1','306','1',1,'Retail Sale Id 4494',800.80,0.00,0.00,1.04,136.24,'2023-01-30 07:43:14','',''),(4456,'1','306','1',1,'Retail Sale Id 4495',2202.20,0.00,0.00,2.86,374.66,'2023-01-30 07:46:38','',''),(4457,'1','306','1',1,'Retail Sale Id 4496',3850.00,0.00,0.00,5.00,655.00,'2023-01-30 07:48:21','',''),(4458,'1','306','1',1,'Retail Sale Id 4497',2302.30,0.00,0.00,2.99,391.69,'2023-01-30 07:56:30','',''),(4459,'1','306','1',1,'Retail Sale Id 4498',2348.50,0.00,0.00,3.05,399.55,'2023-01-30 07:58:55','',''),(4460,'1','306','1',1,'Retail Sale Id 4499',4596.90,0.00,0.00,5.97,782.07,'2023-01-30 08:02:55','',''),(4461,'1','306','1',1,'Retail Sale Id 4501',4620.00,0.00,0.00,6.00,786.00,'2023-01-30 08:14:40','',''),(4462,'1','306','1',1,'Retail Sale Id 4502',3896.20,0.00,0.00,5.06,662.86,'2023-01-30 08:16:04','',''),(4463,'1','306','1',1,'Retail Sale Id 4503',3003.00,0.00,0.00,3.90,510.90,'2023-01-30 08:17:29','',''),(4464,'1','306','1',1,'Retail Sale Id 4504',1540.00,0.00,0.00,2.00,262.00,'2023-01-30 08:20:32','',''),(4465,'1','306','1',1,'Retail Sale Id 4505',1501.50,0.00,0.00,1.95,255.45,'2023-01-30 08:22:52','',''),(4466,'1','306','1',1,'Retail Sale Id 4506',746.90,0.00,0.00,0.97,127.07,'2023-01-30 08:24:19','',''),(4467,'1','306','1',1,'Retail Sale Id 4507',2002.00,0.00,0.00,2.60,340.60,'2023-01-30 08:25:04','',''),(4468,'1','306','1',1,'Retail Sale Id 4508',2002.00,0.00,0.00,2.60,340.60,'2023-01-30 08:27:37','',''),(4469,'1','306','1',1,'Retail Sale Id 4509',4620.00,0.00,0.00,6.00,786.00,'2023-01-30 08:29:27','',''),(4470,'1','306','1',1,'Retail Sale Id 4510',800.80,0.00,0.00,1.04,136.24,'2023-01-30 08:38:12','',''),(4471,'1','306','1',1,'Retail Sale Id 4511',3850.00,0.00,0.00,5.00,655.00,'2023-01-30 08:40:06','',''),(4472,'1','306','1',1,'Retail Sale Id 4512',1501.50,0.00,0.00,1.95,255.45,'2023-01-30 08:43:55','',''),(4473,'1','306','1',1,'Retail Sale Id 4513',4997.30,0.00,0.00,6.49,850.19,'2023-01-30 08:45:06','',''),(4474,'1','306','1',1,'Retail Sale Id 4514',4620.00,0.00,0.00,6.00,786.00,'2023-01-30 08:51:48','',''),(4475,'1','306','1',1,'Retail Sale Id 4515',3803.80,0.00,0.00,4.94,647.14,'2023-01-30 08:54:35','',''),(4476,'1','306','1',1,'Retail Sale Id 4516',3080.00,0.00,0.00,4.00,524.00,'2023-01-30 08:58:47','',''),(4477,'1','306','1',1,'Retail Sale Id 4517',2302.30,0.00,0.00,2.99,391.69,'2023-01-30 09:09:36','',''),(4478,'1','306','1',1,'Retail Sale Id 4518',800.80,0.00,0.00,1.04,136.24,'2023-01-30 09:13:56','',''),(4479,'1','306','1',1,'Retail Sale Id 4519',4496.80,0.00,0.00,5.84,765.04,'2023-01-30 09:17:11','',''),(4480,'1','306','1',1,'Retail Sale Id 4520',2502.50,0.00,0.00,3.25,425.75,'2023-01-30 09:18:06','',''),(4481,'1','306','1',1,'Retail Sale Id 4521',9501.80,0.00,0.00,12.34,1616.54,'2023-01-30 09:20:01','',''),(4482,'1','306','1',1,'Retail Sale Id 4522',6160.00,0.00,0.00,8.00,1048.00,'2023-01-30 09:21:55','',''),(4483,'1','306','1',1,'Retail Sale Id 4524',3103.10,0.00,0.00,4.03,527.93,'2023-01-30 09:28:56','',''),(4484,'1','306','1',1,'Retail Sale Id 4525',3003.00,0.00,0.00,3.90,510.90,'2023-01-30 09:32:00','',''),(4485,'1','306','1',1,'Retail Sale Id 4526',9625.00,0.00,0.00,12.50,1637.50,'2023-01-30 09:44:42','',''),(4486,'1','306','1',1,'Retail Sale Id 4527',4620.00,0.00,0.00,6.00,786.00,'2023-01-30 09:54:39','',''),(4487,'1','306','1',1,'Retail Sale Id 4528',800.80,0.00,0.00,1.04,136.24,'2023-01-30 09:58:52','',''),(4488,'1','306','1',1,'Retail Sale Id 4529',9625.00,0.00,0.00,12.50,1637.50,'2023-01-30 10:11:09','',''),(4489,'1','306','1',1,'Retail Sale Id 4530',18250.00,0.00,0.00,25.00,2275.00,'2023-01-30 10:40:20','',''),(4490,'1','306','1',1,'Retail Sale Id 4531',2310.00,0.00,0.00,3.00,393.00,'2023-01-30 10:40:48','',''),(4491,'1','306','1',1,'Retail Sale Id 4532',1547.70,0.00,0.00,2.01,263.31,'2023-01-30 10:53:18','',''),(4492,'1','306','1',1,'Retail Sale Id 4533',2202.20,0.00,0.00,2.86,374.66,'2023-01-30 10:54:41','',''),(4493,'1','306','1',1,'Retail Sale Id 4534',3996.30,0.00,0.00,5.19,679.89,'2023-01-30 10:58:53','',''),(4494,'1','306','1',1,'Retail Sale Id 4535',4496.80,0.00,0.00,5.84,765.04,'2023-01-30 11:02:08','',''),(4495,'1','306','1',1,'Retail Sale Id 4536',43800.00,0.00,0.00,60.00,5460.00,'2023-01-30 11:08:04','',''),(4496,'1','306','1',1,'Retail Sale Id 4537',4496.80,0.00,0.00,5.84,765.04,'2023-01-30 11:22:46','',''),(4497,'1','306','1',1,'Retail Sale Id 4538',4650.80,0.00,0.00,6.04,791.24,'2023-01-30 11:26:04','',''),(4498,'1','306','1',1,'Retail Sale Id 4539',2302.30,0.00,0.00,2.99,391.69,'2023-01-30 11:43:37','',''),(4499,'1','306','1',1,'Retail Sale Id 4540',3003.00,0.00,0.00,3.90,510.90,'2023-01-30 11:52:51','',''),(4500,'1','306','1',1,'Retail Sale Id 4541',17520.00,0.00,0.00,24.00,2184.00,'2023-01-30 11:57:26','',''),(4501,'1','306','1',1,'Retail Sale Id 4542',2502.50,0.00,0.00,3.25,425.75,'2023-01-30 11:59:22','',''),(4502,'1','306','1',1,'Retail Sale Id 4543',1001.00,0.00,0.00,1.30,170.30,'2023-01-30 12:08:39','',''),(4503,'1','306','1',1,'Retail Sale Id 4544',800.80,0.00,0.00,1.04,136.24,'2023-01-30 12:32:30','',''),(4504,'1','306','1',1,'Retail Sale Id 4545',4496.80,0.00,0.00,5.84,765.04,'2023-01-30 12:57:36','',''),(4505,'1','306','1',1,'Retail Sale Id 4546',4496.80,0.00,0.00,5.84,765.04,'2023-01-30 13:12:16','',''),(4506,'1','306','1',1,'Retail Sale Id 4547',2348.50,0.00,0.00,3.05,399.55,'2023-01-30 13:13:20','',''),(4507,'1','306','1',1,'Retail Sale Id 4548',2310.00,0.00,0.00,3.00,393.00,'2023-01-30 13:17:39','',''),(4508,'1','306','1',1,'Retail Sale Id 4549',800.80,0.00,0.00,1.04,136.24,'2023-01-30 13:18:39','',''),(4509,'1','306','1',1,'Retail Sale Id 4550',42340.00,0.00,0.00,58.00,5278.00,'2023-01-30 13:27:54','',''),(4510,'1','306','1',1,'Retail Sale Id 4551',2302.30,0.00,0.00,2.99,391.69,'2023-01-30 13:34:10','',''),(4511,'1','306','1',1,'Retail Sale Id 4552',3003.00,0.00,0.00,3.90,510.90,'2023-01-30 13:34:49','',''),(4512,'1','306','1',1,'Retail Sale Id 4553',2302.30,0.00,0.00,2.99,391.69,'2023-01-30 13:38:58','',''),(4513,'1','306','1',1,'Retail Sale Id 4554',3996.30,0.00,0.00,5.19,679.89,'2023-01-30 13:39:59','',''),(4514,'1','306','1',1,'Retail Sale Id 4555',2002.00,0.00,0.00,2.60,340.60,'2023-01-30 13:46:16','',''),(4515,'1','306','1',1,'Retail Sale Id 4556',4620.00,0.00,0.00,6.00,786.00,'2023-01-30 13:53:04','',''),(4516,'1','306','1',1,'Retail Sale Id 4557',4496.80,0.00,0.00,5.84,765.04,'2023-01-30 13:54:14','',''),(4517,'1','306','1',1,'Retail Sale Id 4558',3996.30,0.00,0.00,5.19,679.89,'2023-01-30 13:57:05','',''),(4518,'1','306','1',1,'Retail Sale Id 4559',2302.30,0.00,0.00,2.99,391.69,'2023-01-30 13:58:11','',''),(4519,'1','306','1',1,'Retail Sale Id 4560',3503.50,0.00,0.00,4.55,596.05,'2023-01-30 13:59:18','',''),(4520,'1','306','1',1,'Retail Sale Id 4561',1601.60,0.00,0.00,2.08,272.48,'2023-01-30 14:06:11','',''),(4521,'1','306','1',1,'Retail Sale Id 4562',1001.00,0.00,0.00,1.30,170.30,'2023-01-30 14:07:42','',''),(4522,'1','306','1',1,'Retail Sale Id 4563',3103.10,0.00,0.00,4.03,527.93,'2023-01-30 14:20:36','',''),(4523,'1','306','1',1,'Retail Sale Id 4564',1501.50,0.00,0.00,1.95,255.45,'2023-01-30 14:25:35','',''),(4524,'1','306','1',1,'Retail Sale Id 4565',3103.10,0.00,0.00,4.03,527.93,'2023-01-30 14:39:36','',''),(4525,'1','306','1',1,'Retail Sale Id 4566',1501.50,0.00,0.00,1.95,255.45,'2023-01-30 14:45:29','',''),(4526,'1','306','1',1,'Retail Sale Id 4567',800.80,0.00,0.00,1.04,136.24,'2023-01-30 14:52:31','',''),(4527,'1','306','1',1,'Retail Sale Id 4568',2002.00,0.00,0.00,2.60,340.60,'2023-01-30 14:58:15','',''),(4528,'1','306','1',1,'Retail Sale Id 4569',2348.50,0.00,0.00,3.05,399.55,'2023-01-30 15:05:10','',''),(4529,'1','306','1',1,'Retail Sale Id 4570',1001.00,0.00,0.00,1.30,170.30,'2023-01-30 15:26:45','',''),(4530,'1','306','1',1,'Retail Sale Id 4570',1001.00,0.00,0.00,1.30,170.30,'2023-01-30 15:26:45','',''),(4531,'1','306','1',1,'Retail Sale Id 4570',1001.00,0.00,0.00,1.30,170.30,'2023-01-30 15:26:45','',''),(4532,'1','306','1',1,'Retail Sale Id 4571',2002.00,0.00,0.00,2.60,340.60,'2023-01-30 15:27:52','',''),(4533,'1','306','1',1,'Retail Sale Id 4572',9125.00,0.00,0.00,12.50,1137.50,'2023-01-30 15:29:24','',''),(4534,'1','306','1',1,'Retail Sale Id 4573',2302.30,0.00,0.00,2.99,391.69,'2023-01-30 15:38:31','',''),(4535,'1','306','1',1,'Retail Sale Id 4574',2002.00,0.00,0.00,2.60,340.60,'2023-01-30 15:39:24','',''),(4536,'1','306','1',1,'Retail Sale Id 4575',1001.00,0.00,0.00,1.30,170.30,'2023-01-30 15:43:11','',''),(4537,'1','306','1',1,'Retail Sale Id 4576',2302.30,0.00,0.00,2.99,391.69,'2023-01-30 15:57:23','',''),(4538,'1','306','1',1,'Retail Sale Id 4577',3850.00,0.00,0.00,5.00,655.00,'2023-01-30 15:59:19','',''),(4539,'1','306','1',1,'Retail Sale Id 4578',4620.00,0.00,0.00,6.00,786.00,'2023-01-30 16:01:44','',''),(4540,'1','306','1',1,'Retail Sale Id 4579',3850.00,0.00,0.00,5.00,655.00,'2023-01-30 16:08:20','',''),(4541,'1','306','1',1,'Retail Sale Id 4580',1540.00,0.00,0.00,2.00,262.00,'2023-01-30 16:11:48','',''),(4542,'1','306','1',1,'Retail Sale Id 4581',3080.00,0.00,0.00,4.00,524.00,'2023-01-30 16:15:58','',''),(4543,'1','306','1',1,'Retail Sale Id 4582',3850.00,0.00,0.00,5.00,655.00,'2023-01-30 16:16:46','',''),(4544,'1','306','1',1,'Retail Sale Id 4583',4620.00,0.00,0.00,6.00,786.00,'2023-01-30 16:18:20','',''),(4545,'1','306','1',1,'Retail Sale Id 4584',1501.50,0.00,0.00,1.95,255.45,'2023-01-30 16:19:46','',''),(4546,'1','306','1',1,'Retail Sale Id 4585',9702.00,0.00,0.00,12.60,1650.60,'2023-01-30 16:20:59','',''),(4547,'1','306','1',1,'Retail Sale Id 4586',3996.30,0.00,0.00,5.19,679.89,'2023-01-30 16:22:07','',''),(4548,'1','306','1',1,'Retail Sale Id 4587',2302.30,0.00,0.00,2.99,391.69,'2023-01-30 16:26:36','',''),(4549,'1','306','1',1,'Retail Sale Id 4588',4496.80,0.00,0.00,5.84,765.04,'2023-01-30 16:31:43','',''),(4550,'1','306','1',1,'Retail Sale Id 4589',5998.30,0.00,0.00,7.79,1020.49,'2023-01-30 16:37:08','',''),(4551,'1','306','1',1,'Retail Sale Id 4590',2310.00,0.00,0.00,3.00,393.00,'2023-01-30 16:38:50','',''),(4552,'1','306','1',1,'Retail Sale Id 4591',7700.00,0.00,0.00,10.00,1310.00,'2023-01-30 16:40:56','',''),(4553,'1','306','1',1,'Retail Sale Id 4592',1540.00,0.00,0.00,2.00,262.00,'2023-01-30 16:42:01','',''),(4554,'1','306','1',1,'Retail Sale Id 4593',3080.00,0.00,0.00,4.00,524.00,'2023-01-30 16:43:24','',''),(4555,'1','306','1',1,'Retail Sale Id 4594',1540.00,0.00,0.00,2.00,262.00,'2023-01-30 16:47:45','',''),(4556,'1','306','1',1,'Retail Sale Id 4595',2310.00,0.00,0.00,3.00,393.00,'2023-01-30 16:50:48','',''),(4557,'1','306','1',1,'Retail Sale Id 4597',3080.00,0.00,0.00,4.00,524.00,'2023-01-30 16:52:52','',''),(4558,'1','306','1',1,'Retail Sale Id 4598',5390.00,0.00,0.00,7.00,917.00,'2023-01-30 16:53:57','',''),(4559,'1','306','1',1,'Return of Retail Sale Id 4595',0.00,2310.00,3.00,0.00,-393.00,'2023-01-30 16:54:18','',''),(4560,'1','306','1',1,'Retail Sale Id 4599',8901.20,0.00,0.00,11.56,1514.36,'2023-01-30 16:56:07','',''),(4561,'1','306','1',1,'Retail Sale Id 4600',800.80,0.00,0.00,1.04,136.24,'2023-01-30 16:57:05','',''),(4562,'1','306','1',1,'Retail Sale Id 4601',1001.00,0.00,0.00,1.30,170.30,'2023-01-30 16:57:53','',''),(4563,'1','306','1',1,'Retail Sale Id 4602',1540.00,0.00,0.00,2.00,262.00,'2023-01-30 16:59:30','',''),(4564,'1','306','1',1,'Retail Sale Id 4603',2310.00,0.00,0.00,3.00,393.00,'2023-01-30 17:01:28','',''),(4565,'1','306','1',1,'Retail Sale Id 4604',8000.30,0.00,0.00,10.39,1361.09,'2023-01-30 17:02:17','',''),(4566,'1','306','1',1,'Retail Sale Id 4606',4596.90,0.00,0.00,5.97,782.07,'2023-01-30 17:04:39','',''),(4567,'1','306','1',1,'Retail Sale Id 4607',3850.00,0.00,0.00,5.00,655.00,'2023-01-30 17:06:05','',''),(4568,'1','306','1',1,'Retail Sale Id 4608',2348.50,0.00,0.00,3.05,399.55,'2023-01-30 17:07:20','',''),(4569,'1','306','1',1,'Retail Sale Id 4609',800.80,0.00,0.00,1.04,136.24,'2023-01-30 17:08:33','',''),(4570,'1','306','1',1,'Retail Sale Id 4610',2302.30,0.00,0.00,2.99,391.69,'2023-01-30 17:09:22','',''),(4571,'1','306','1',1,'Retail Sale Id 4612',3850.00,0.00,0.00,5.00,655.00,'2023-01-30 17:10:56','',''),(4572,'1','306','1',1,'Return of Retail Sale Id 4604',0.00,8000.30,10.39,0.00,-1361.09,'2023-01-30 17:12:17','',''),(4573,'1','306','1',1,'Retail Sale Id 4613',4496.80,0.00,0.00,5.84,765.04,'2023-01-30 17:16:48','',''),(4574,'1','306','1',1,'Retail Sale Id 4614',2302.30,0.00,0.00,2.99,391.69,'2023-01-30 17:18:33','',''),(4575,'1','306','1',1,'Retail Sale Id 4615',3850.00,0.00,0.00,5.00,655.00,'2023-01-30 17:27:33','',''),(4576,'1','306','1',1,'Retail Sale Id 4616',5475.00,0.00,0.00,7.50,682.50,'2023-01-30 17:28:55','',''),(4577,'1','306','1',1,'Retail Sale Id 4617',3850.00,0.00,0.00,5.00,655.00,'2023-01-30 17:29:52','',''),(4578,'1','306','1',1,'Retail Sale Id 4618',9625.00,0.00,0.00,12.50,1637.50,'2023-01-30 17:34:14','',''),(4579,'1','306','1',1,'Retail Sale Id 4619',6198.50,0.00,0.00,8.05,1054.55,'2023-01-30 17:35:52','',''),(4580,'1','306','1',1,'Retail Sale Id 4620',1901.90,0.00,0.00,2.47,323.57,'2023-01-30 17:36:47','',''),(4581,'1','306','1',1,'Retail Sale Id 4621',4620.00,0.00,0.00,6.00,786.00,'2023-01-30 17:43:04','',''),(4582,'1','306','1',1,'Retail Sale Id 4622',3850.00,0.00,0.00,5.00,655.00,'2023-01-30 17:45:09','',''),(4583,'1','306','1',1,'Retail Sale Id 4623',1540.00,0.00,0.00,2.00,262.00,'2023-01-30 17:46:24','',''),(4584,'1','306','1',1,'Retail Sale Id 4624',3850.00,0.00,0.00,5.00,655.00,'2023-01-30 17:51:45','',''),(4585,'1','306','1',1,'Retail Sale Id 4625',2002.00,0.00,0.00,2.60,340.60,'2023-01-30 17:58:40','',''),(4586,'1','306','1',1,'Retail Sale Id 4626',3996.30,0.00,0.00,5.19,679.89,'2023-01-30 18:01:53','',''),(4587,'1','306','1',1,'Retail Sale Id 4627',800.80,0.00,0.00,1.04,136.24,'2023-01-30 18:03:46','',''),(4588,'1','306','1',1,'Retail Sale Id 4628',4620.00,0.00,0.00,6.00,786.00,'2023-01-30 18:10:13','',''),(4589,'1','306','1',1,'Retail Sale Id 4629',2302.30,0.00,0.00,2.99,391.69,'2023-01-30 18:11:30','',''),(4590,'1','306','1',1,'Retail Sale Id 4630',1547.70,0.00,0.00,2.01,263.31,'2023-01-30 18:12:49','',''),(4591,'1','306','1',1,'Retail Sale Id 4631',2302.30,0.00,0.00,2.99,391.69,'2023-01-30 18:18:07','',''),(4592,'1','306','1',1,'Retail Sale Id 4632',9240.00,0.00,0.00,12.00,1572.00,'2023-01-30 18:22:53','',''),(4593,'1','306','1',1,'Retail Sale Id 4633',2302.30,0.00,0.00,2.99,391.69,'2023-01-30 18:24:15','',''),(4594,'1','306','1',1,'Retail Sale Id 4634',9625.00,0.00,0.00,12.50,1637.50,'2023-01-30 18:33:15','',''),(4595,'1','306','1',1,'Return of Retail Sale Id 4627',0.00,800.80,1.04,0.00,-136.24,'2023-01-30 18:47:20','',''),(4596,'1','306','1',1,'Retail Sale Id 4635',816.20,0.00,0.00,1.06,138.86,'2023-01-30 18:48:45','',''),(4597,'1','306','1',1,'Retail Sale Id 4636',1547.70,0.00,0.00,2.01,263.31,'2023-01-31 07:18:33','',''),(4598,'1','306','1',1,'Retail Sale Id 4637',4496.80,0.00,0.00,5.84,765.04,'2023-01-31 07:22:39','',''),(4599,'1','306','1',1,'Retail Sale Id 4638',43800.00,0.00,0.00,60.00,5460.00,'2023-01-31 07:31:01','',''),(4600,'1','306','1',1,'Retail Sale Id 4639',9625.00,0.00,0.00,12.50,1637.50,'2023-01-31 07:55:39','',''),(4601,'1','306','1',1,'Retail Sale Id 4640',2002.00,0.00,0.00,2.60,340.60,'2023-01-31 08:02:49','',''),(4602,'1','306','1',1,'Retail Sale Id 4641',3850.00,0.00,0.00,5.00,655.00,'2023-01-31 08:06:50','',''),(4603,'1','306','1',1,'Retail Sale Id 4642',1540.00,0.00,0.00,2.00,262.00,'2023-01-31 08:08:42','',''),(4604,'1','306','1',1,'Retail Sale Id 4643',2002.00,0.00,0.00,2.60,340.60,'2023-01-31 08:12:59','',''),(4605,'1','306','1',1,'Retail Sale Id 4644',1501.50,0.00,0.00,1.95,255.45,'2023-01-31 08:17:34','',''),(4606,'1','306','1',1,'Retail Sale Id 4645',6999.30,0.00,0.00,9.09,1190.79,'2023-01-31 08:19:53','',''),(4607,'1','306','1',1,'Retail Sale Id 4646',14600.00,0.00,0.00,20.00,1820.00,'2023-01-31 08:22:33','',''),(4608,'1','306','1',1,'Retail Sale Id 4647',1547.70,0.00,0.00,2.01,263.31,'2023-01-31 08:25:38','',''),(4609,'1','306','1',1,'Retail Sale Id 4648',4596.90,0.00,0.00,5.97,782.07,'2023-01-31 08:27:02','',''),(4610,'1','306','1',1,'Retail Sale Id 4649',2302.30,0.00,0.00,2.99,391.69,'2023-01-31 08:35:58','',''),(4611,'1','306','1',1,'Retail Sale Id 4650',1001.00,0.00,0.00,1.30,170.30,'2023-01-31 08:43:57','',''),(4612,'1','306','1',1,'Retail Sale Id 4651',4496.80,0.00,0.00,5.84,765.04,'2023-01-31 08:51:51','',''),(4613,'1','306','1',1,'Retail Sale Id 4652',1547.70,0.00,0.00,2.01,263.31,'2023-01-31 08:52:35','',''),(4614,'1','306','1',1,'Retail Sale Id 4653',4620.00,0.00,0.00,6.00,786.00,'2023-01-31 08:57:06','',''),(4615,'1','306','1',1,'Retail Sale Id 4654',800.80,0.00,0.00,1.04,136.24,'2023-01-31 08:58:51','',''),(4616,'1','306','1',1,'Retail Sale Id 4655',2310.00,0.00,0.00,3.00,393.00,'2023-01-31 09:23:23','',''),(4617,'1','306','1',1,'Retail Sale Id 4656',4596.90,0.00,0.00,5.97,782.07,'2023-01-31 09:31:11','',''),(4618,'1','306','1',1,'Retail Sale Id 4657',4620.00,0.00,0.00,6.00,786.00,'2023-01-31 09:36:20','',''),(4619,'1','306','1',1,'Retail Sale Id 4658',2302.30,0.00,0.00,2.99,391.69,'2023-01-31 09:51:42','',''),(4620,'1','306','1',1,'Retail Sale Id 4659',3850.00,0.00,0.00,5.00,655.00,'2023-01-31 09:55:06','',''),(4621,'1','306','1',1,'Retail Sale Id 4661',1601.60,0.00,0.00,2.08,272.48,'2023-01-31 09:57:55','',''),(4622,'1','306','1',1,'Retail Sale Id 4662',2302.30,0.00,0.00,2.99,391.69,'2023-01-31 10:00:02','',''),(4623,'1','306','1',1,'Retail Sale Id 4663',3996.30,0.00,0.00,5.19,679.89,'2023-01-31 10:01:31','',''),(4624,'1','306','1',1,'Retail Sale Id 4664',9625.00,0.00,0.00,12.50,1637.50,'2023-01-31 10:17:06','',''),(4625,'1','306','1',1,'Retail Sale Id 4665',3103.10,0.00,0.00,4.03,527.93,'2023-01-31 10:21:26','',''),(4626,'1','306','1',1,'Retail Sale Id 4666',4620.00,0.00,0.00,6.00,786.00,'2023-01-31 10:26:57','',''),(4627,'1','306','1',1,'Retail Sale Id 4667',3103.10,0.00,0.00,4.03,527.93,'2023-01-31 10:27:55','',''),(4628,'1','306','1',1,'Retail Sale Id 4668',2302.30,0.00,0.00,2.99,391.69,'2023-01-31 10:42:49','',''),(4629,'1','306','1',1,'Retail Sale Id 4669',1547.70,0.00,0.00,2.01,263.31,'2023-01-31 10:48:03','',''),(4630,'1','306','1',1,'Retail Sale Id 4670',43800.00,0.00,0.00,60.00,5460.00,'2023-01-31 10:52:48','',''),(4631,'1','306','1',1,'Retail Sale Id 4671',1501.50,0.00,0.00,1.95,255.45,'2023-01-31 10:55:47','',''),(4632,'1','306','1',1,'Retail Sale Id 4672',2302.30,0.00,0.00,2.99,391.69,'2023-01-31 10:56:53','',''),(4633,'1','306','1',1,'Retail Sale Id 4673',3103.10,0.00,0.00,4.03,527.93,'2023-01-31 10:57:38','',''),(4634,'1','306','1',1,'Retail Sale Id 4674',146000.00,0.00,0.00,200.00,18200.00,'2023-01-31 11:04:57','',''),(4635,'1','306','1',1,'Retail Sale Id 4675',2310.00,0.00,0.00,3.00,393.00,'2023-01-31 11:06:48','',''),(4636,'1','306','1',1,'Retail Sale Id 4676',1501.50,0.00,0.00,1.95,255.45,'2023-01-31 11:10:26','',''),(4637,'1','306','1',1,'Retail Sale Id 4677',500.50,0.00,0.00,0.65,85.15,'2023-01-31 11:12:40','',''),(4638,'1','306','1',1,'Retail Sale Id 4678',2310.00,0.00,0.00,3.00,393.00,'2023-01-31 11:16:24','',''),(4639,'1','306','1',1,'Retail Sale Id 4679',1501.50,0.00,0.00,1.95,255.45,'2023-01-31 11:22:46','',''),(4640,'1','306','1',1,'Retail Sale Id 4680',4620.00,0.00,0.00,6.00,786.00,'2023-01-31 11:29:12','',''),(4641,'1','306','1',1,'Retail Sale Id 4681',3850.00,0.00,0.00,5.00,655.00,'2023-01-31 11:39:33','',''),(4642,'1','306','1',1,'Retail Sale Id 4682',9625.00,0.00,0.00,12.50,1637.50,'2023-01-31 11:42:40','',''),(4643,'1','306','1',1,'Retail Sale Id 4683',31755.00,0.00,0.00,43.50,3958.50,'2023-01-31 11:44:19','',''),(4644,'1','306','1',1,'Retail Sale Id 4684',1001.00,0.00,0.00,1.30,170.30,'2023-01-31 11:45:45','',''),(4645,'1','306','1',1,'Retail Sale Id 4685',9625.00,0.00,0.00,12.50,1637.50,'2023-01-31 11:51:26','',''),(4646,'1','306','1',1,'Retail Sale Id 4686',3103.10,0.00,0.00,4.03,527.93,'2023-01-31 11:52:27','',''),(4647,'1','306','1',1,'Retail Sale Id 4687',2310.00,0.00,0.00,3.00,393.00,'2023-01-31 11:53:56','',''),(4648,'1','306','1',1,'Retail Sale Id 4688',9702.00,0.00,0.00,12.60,1650.60,'2023-01-31 11:57:42','',''),(4649,'1','306','1',1,'Retail Sale Id 4689',3850.00,0.00,0.00,5.00,655.00,'2023-01-31 12:07:49','',''),(4650,'1','306','1',1,'Retail Sale Id 4690',1501.50,0.00,0.00,1.95,255.45,'2023-01-31 12:22:04','',''),(4651,'1','306','1',1,'Retail Sale Id 4691',1540.00,0.00,0.00,2.00,262.00,'2023-01-31 12:23:44','',''),(4652,'1','306','1',1,'Retail Sale Id 4692',3850.00,0.00,0.00,5.00,655.00,'2023-01-31 12:26:36','',''),(4653,'1','306','1',1,'Retail Sale Id 4693',2302.30,0.00,0.00,2.99,391.69,'2023-01-31 12:37:30','',''),(4654,'1','306','1',1,'Retail Sale Id 4694',2302.30,0.00,0.00,2.99,391.69,'2023-01-31 12:43:25','',''),(4655,'1','306','1',1,'Retail Sale Id 4696',1540.00,0.00,0.00,2.00,262.00,'2023-01-31 12:46:18','',''),(4656,'1','306','1',1,'Retail Sale Id 4697',9001.30,0.00,0.00,11.69,1531.39,'2023-01-31 12:58:55','',''),(4657,'1','306','1',1,'Retail Sale Id 4698',2002.00,0.00,0.00,2.60,340.60,'2023-01-31 13:02:32','',''),(4658,'1','306','1',1,'Retail Sale Id 4699',4620.00,0.00,0.00,6.00,786.00,'2023-01-31 13:04:44','',''),(4659,'1','306','1',1,'Retail Sale Id 4700',14600.00,0.00,0.00,20.00,1820.00,'2023-01-31 13:16:43','',''),(4660,'1','306','1',1,'Retail Sale Id 4701',2310.00,0.00,0.00,3.00,393.00,'2023-01-31 13:24:30','',''),(4661,'1','306','1',1,'Retail Sale Id 4702',800.80,0.00,0.00,1.04,136.24,'2023-01-31 13:26:44','',''),(4662,'1','306','1',1,'Retail Sale Id 4703',1601.60,0.00,0.00,2.08,272.48,'2023-01-31 13:30:36','',''),(4663,'1','306','1',1,'Retail Sale Id 4704',6930.00,0.00,0.00,9.00,1179.00,'2023-01-31 13:33:42','',''),(4664,'1','306','1',1,'Retail Sale Id 4706',800.80,0.00,0.00,1.04,136.24,'2023-01-31 13:35:16','',''),(4665,'1','306','1',1,'Retail Sale Id 4707',132130.00,0.00,0.00,181.00,16471.00,'2023-01-31 13:38:23','',''),(4666,'1','306','1',1,'Retail Sale Id 4708',4620.00,0.00,0.00,6.00,786.00,'2023-01-31 13:39:50','',''),(4667,'1','306','1',1,'Retail Sale Id 4709',2310.00,0.00,0.00,3.00,393.00,'2023-01-31 13:40:51','',''),(4668,'1','306','1',1,'Retail Sale Id 4710',2302.30,0.00,0.00,2.99,391.69,'2023-01-31 13:43:50','',''),(4669,'1','306','1',1,'Retail Sale Id 4711',9625.00,0.00,0.00,12.50,1637.50,'2023-01-31 13:45:39','',''),(4670,'1','306','1',1,'Retail Sale Id 4712',4620.00,0.00,0.00,6.00,786.00,'2023-01-31 13:52:51','',''),(4671,'1','306','1',1,'Retail Sale Id 4713',2302.30,0.00,0.00,2.99,391.69,'2023-01-31 13:55:29','',''),(4672,'1','306','1',1,'Retail Sale Id 4714',600.60,0.00,0.00,0.78,102.18,'2023-01-31 14:01:51','',''),(4673,'1','306','1',1,'Retail Sale Id 4715',2302.30,0.00,0.00,2.99,391.69,'2023-01-31 14:04:24','',''),(4674,'1','306','1',1,'Retail Sale Id 4716',770.00,0.00,0.00,1.00,131.00,'2023-01-31 14:05:42','',''),(4675,'1','306','1',1,'Retail Sale Id 4717',2002.00,0.00,0.00,2.60,340.60,'2023-01-31 14:09:12','',''),(4676,'1','306','1',1,'Retail Sale Id 4718',2310.00,0.00,0.00,3.00,393.00,'2023-01-31 14:11:51','',''),(4677,'1','306','1',1,'Retail Sale Id 4719',3003.00,0.00,0.00,3.90,510.90,'2023-01-31 14:21:37','',''),(4678,'1','306','1',1,'Retail Sale Id 4720',3850.00,0.00,0.00,5.00,655.00,'2023-01-31 14:23:07','',''),(4679,'1','306','1',1,'Retail Sale Id 4721',5390.00,0.00,0.00,7.00,917.00,'2023-01-31 14:40:47','',''),(4680,'1','306','1',1,'Retail Sale Id 4723',3996.30,0.00,0.00,5.19,679.89,'2023-01-31 14:58:00','',''),(4681,'1','306','1',1,'Retail Sale Id 4724',2302.30,0.00,0.00,2.99,391.69,'2023-01-31 15:01:48','',''),(4682,'1','306','1',1,'Retail Sale Id 4725',5390.00,0.00,0.00,7.00,917.00,'2023-01-31 15:09:51','',''),(4683,'1','306','1',1,'Retail Sale Id 4726',762.30,0.00,0.00,0.99,129.69,'2023-01-31 15:24:16','',''),(4684,'1','306','1',1,'Retail Sale Id 4727',2310.00,0.00,0.00,3.00,393.00,'2023-01-31 15:25:26','',''),(4685,'1','306','1',1,'Retail Sale Id 4728',2302.30,0.00,0.00,2.99,391.69,'2023-01-31 15:26:21','',''),(4686,'1','306','1',1,'Retail Sale Id 4729',4620.00,0.00,0.00,6.00,786.00,'2023-01-31 15:27:47','',''),(4687,'1','306','1',1,'Retail Sale Id 4730',9625.00,0.00,0.00,12.50,1637.50,'2023-01-31 15:29:52','',''),(4688,'1','306','1',1,'Retail Sale Id 4731',4620.00,0.00,0.00,6.00,786.00,'2023-01-31 15:34:15','',''),(4689,'1','306','1',1,'Retail Sale Id 4732',1001.00,0.00,0.00,1.30,170.30,'2023-01-31 15:35:15','',''),(4690,'1','306','1',1,'Retail Sale Id 4733',2310.00,0.00,0.00,3.00,393.00,'2023-01-31 15:36:44','',''),(4691,'1','306','1',1,'Retail Sale Id 4733',5390.00,0.00,0.00,7.00,917.00,'2023-01-31 15:36:44','',''),(4692,'1','306','1',1,'Retail Sale Id 4734',4496.80,0.00,0.00,5.84,765.04,'2023-01-31 15:46:03','',''),(4693,'1','306','1',1,'Retail Sale Id 4735',1801.80,0.00,0.00,2.34,306.54,'2023-01-31 15:48:22','',''),(4694,'1','306','1',1,'Retail Sale Id 4736',3080.00,0.00,0.00,4.00,524.00,'2023-01-31 15:50:09','',''),(4695,'1','306','1',1,'Retail Sale Id 4737',1540.00,0.00,0.00,2.00,262.00,'2023-01-31 15:52:24','',''),(4696,'1','306','1',1,'Retail Sale Id 4738',27010.00,0.00,0.00,37.00,3367.00,'2023-01-31 15:58:49','',''),(4697,'1','306','1',1,'Retail Sale Id 4739',1540.00,0.00,0.00,2.00,262.00,'2023-01-31 16:04:40','',''),(4698,'1','306','1',1,'Retail Sale Id 4740',7700.00,0.00,0.00,10.00,1310.00,'2023-01-31 16:11:41','',''),(4699,'1','306','1',1,'Retail Sale Id 4741',6198.50,0.00,0.00,8.05,1054.55,'2023-01-31 16:13:28','',''),(4700,'1','306','1',1,'Retail Sale Id 4742',3103.10,0.00,0.00,4.03,527.93,'2023-01-31 16:15:11','',''),(4701,'1','306','1',1,'Retail Sale Id 4743',9240.00,0.00,0.00,12.00,1572.00,'2023-01-31 16:16:46','',''),(4702,'1','306','1',1,'Retail Sale Id 4744',3203.20,0.00,0.00,4.16,544.96,'2023-01-31 16:21:07','',''),(4703,'1','306','1',1,'Retail Sale Id 4745',2310.00,0.00,0.00,3.00,393.00,'2023-01-31 16:29:55','',''),(4704,'1','306','1',1,'Retail Sale Id 4745',9625.00,0.00,0.00,12.50,1637.50,'2023-01-31 16:29:55','',''),(4705,'1','306','1',1,'Retail Sale Id 4746',3080.00,0.00,0.00,4.00,524.00,'2023-01-31 16:31:22','',''),(4706,'1','306','1',1,'Retail Sale Id 4747',5390.00,0.00,0.00,7.00,917.00,'2023-01-31 16:33:58','',''),(4707,'1','306','1',1,'Retail Sale Id 4749',1540.00,0.00,0.00,2.00,262.00,'2023-01-31 16:37:48','',''),(4708,'1','306','1',1,'Retail Sale Id 4751',7700.00,0.00,0.00,10.00,1310.00,'2023-01-31 16:54:59','',''),(4709,'1','306','1',1,'Retail Sale Id 4752',2302.30,0.00,0.00,2.99,391.69,'2023-01-31 16:55:51','',''),(4710,'1','306','1',1,'Retail Sale Id 4754',2302.30,0.00,0.00,2.99,391.69,'2023-01-31 16:57:38','',''),(4711,'1','306','1',1,'Retail Sale Id 4756',9625.00,0.00,0.00,12.50,1637.50,'2023-01-31 16:59:33','',''),(4712,'1','306','1',1,'Retail Sale Id 4757',1540.00,0.00,0.00,2.00,262.00,'2023-01-31 17:00:40','',''),(4713,'1','306','1',1,'Retail Sale Id 4758',1547.70,0.00,0.00,2.01,263.31,'2023-01-31 17:02:38','',''),(4714,'1','306','1',1,'Retail Sale Id 4759',2302.30,0.00,0.00,2.99,391.69,'2023-01-31 17:03:48','',''),(4715,'1','306','1',1,'Retail Sale Id 4760',9625.00,0.00,0.00,12.50,1637.50,'2023-01-31 17:07:28','',''),(4716,'1','306','1',1,'Retail Sale Id 4761',3850.00,0.00,0.00,5.00,655.00,'2023-01-31 17:10:17','',''),(4717,'1','306','1',1,'Retail Sale Id 4762',4496.80,0.00,0.00,5.84,765.04,'2023-01-31 17:18:25','',''),(4718,'1','306','1',1,'Retail Sale Id 4763',800.80,0.00,0.00,1.04,136.24,'2023-01-31 17:23:13','',''),(4719,'1','306','1',1,'Retail Sale Id 4765',2002.00,0.00,0.00,2.60,340.60,'2023-01-31 17:25:46','',''),(4720,'1','306','1',1,'Retail Sale Id 4766',3996.30,0.00,0.00,5.19,679.89,'2023-01-31 17:26:33','',''),(4721,'1','306','1',1,'Retail Sale Id 4767',2302.30,0.00,0.00,2.99,391.69,'2023-01-31 17:27:16','',''),(4722,'1','306','1',1,'Retail Sale Id 4768',1540.00,0.00,0.00,2.00,262.00,'2023-01-31 17:28:26','',''),(4723,'1','306','1',1,'Retail Sale Id 4769',4620.00,0.00,0.00,6.00,786.00,'2023-01-31 17:33:46','',''),(4724,'1','306','1',1,'Retail Sale Id 4770',1547.70,0.00,0.00,2.01,263.31,'2023-01-31 17:38:06','',''),(4725,'1','306','1',1,'Retail Sale Id 4771',3203.20,0.00,0.00,4.16,544.96,'2023-01-31 17:42:19','',''),(4726,'1','306','1',1,'Retail Sale Id 4772',1601.60,0.00,0.00,2.08,272.48,'2023-01-31 17:43:57','',''),(4727,'1','306','1',1,'Retail Sale Id 4773',3003.00,0.00,0.00,3.90,510.90,'2023-01-31 17:46:54','',''),(4728,'1','306','1',1,'Retail Sale Id 4775',2302.30,0.00,0.00,2.99,391.69,'2023-01-31 18:00:32','',''),(4729,'1','306','1',1,'Retail Sale Id 4776',4496.80,0.00,0.00,5.84,765.04,'2023-01-31 18:01:26','',''),(4730,'1','306','1',1,'Retail Sale Id 4777',2302.30,0.00,0.00,2.99,391.69,'2023-01-31 18:02:38','',''),(4731,'1','306','1',1,'Retail Sale Id 4778',2310.00,0.00,0.00,3.00,393.00,'2023-01-31 18:09:17','',''),(4732,'1','306','1',1,'Retail Sale Id 4779',4620.00,0.00,0.00,6.00,786.00,'2023-01-31 18:11:01','',''),(4733,'1','306','1',1,'Retail Sale Id 4780',2302.30,0.00,0.00,2.99,391.69,'2023-01-31 18:12:48','',''),(4734,'1','306','1',1,'Retail Sale Id 4781',3850.00,0.00,0.00,5.00,655.00,'2023-01-31 18:19:12','',''),(4735,'1','306','1',1,'Retail Sale Id 4782',2002.00,0.00,0.00,2.60,340.60,'2023-01-31 18:31:03','',''),(4736,'1','306','1',1,'Retail Sale Id 4783',1601.60,0.00,0.00,2.08,272.48,'2023-01-31 18:31:59','',''),(4737,'1','306','1',1,'Retail Sale Id 4784',2302.30,0.00,0.00,2.99,391.69,'2023-01-31 18:35:25','',''),(4738,'1','306','1',1,'Return of Retail Sale Id 4779',0.00,4620.00,6.00,0.00,-786.00,'2023-01-31 18:51:06','',''),(4739,'1','306','1',1,'Retail Sale Id 4785',2787.40,0.00,0.00,3.62,474.22,'2023-01-31 18:54:39','',''),(4740,'1','306','1',1,'Retail Sale Id 4786',7700.00,0.00,0.00,10.00,1310.00,'2023-02-01 07:29:46','',''),(4741,'1','306','1',1,'Retail Sale Id 4787',9625.00,0.00,0.00,12.50,1637.50,'2023-02-01 07:34:12','',''),(4742,'1','306','1',1,'Retail Sale Id 4788',800.80,0.00,0.00,1.04,136.24,'2023-02-01 07:48:53','',''),(4743,'1','306','1',1,'Retail Sale Id 4789',3996.30,0.00,0.00,5.19,679.89,'2023-02-01 07:51:57','',''),(4744,'1','306','1',1,'Retail Sale Id 4791',1540.00,0.00,0.00,2.00,262.00,'2023-02-01 08:04:36','',''),(4745,'1','306','1',1,'Retail Sale Id 4791',3080.00,0.00,0.00,4.00,524.00,'2023-02-01 08:04:36','',''),(4746,'1','306','1',1,'Retail Sale Id 4792',3850.00,0.00,0.00,5.00,655.00,'2023-02-01 08:06:38','',''),(4747,'1','306','1',1,'Retail Sale Id 4793',2310.00,0.00,0.00,3.00,393.00,'2023-02-01 08:08:11','',''),(4748,'1','306','1',1,'Retail Sale Id 4794',1501.50,0.00,0.00,1.95,255.45,'2023-02-01 08:09:11','',''),(4749,'1','306','1',1,'Retail Sale Id 4795',1501.50,0.00,0.00,1.95,255.45,'2023-02-01 08:10:25','',''),(4750,'1','306','1',1,'Retail Sale Id 4796',2302.30,0.00,0.00,2.99,391.69,'2023-02-01 08:18:29','',''),(4751,'1','306','1',1,'Retail Sale Id 4797',8085.00,0.00,0.00,10.50,1375.50,'2023-02-01 08:24:24','',''),(4752,'1','306','1',1,'Retail Sale Id 4798',4620.00,0.00,0.00,6.00,786.00,'2023-02-01 08:25:55','',''),(4753,'1','306','1',1,'Retail Sale Id 4799',800.80,0.00,0.00,1.04,136.24,'2023-02-01 08:32:56','',''),(4754,'1','306','1',1,'Retail Sale Id 4801',8500.80,0.00,0.00,11.04,1446.24,'2023-02-01 08:36:46','',''),(4755,'1','306','1',1,'Retail Sale Id 4802',4997.30,0.00,0.00,6.49,850.19,'2023-02-01 08:39:38','',''),(4756,'1','306','1',1,'Retail Sale Id 4803',4997.30,0.00,0.00,6.49,850.19,'2023-02-01 08:40:19','',''),(4757,'1','306','1',1,'Retail Sale Id 4804',1601.60,0.00,0.00,2.08,272.48,'2023-02-01 08:41:07','',''),(4758,'1','306','1',1,'Retail Sale Id 4805',4596.90,0.00,0.00,5.97,782.07,'2023-02-01 08:42:14','',''),(4759,'1','306','1',1,'Retail Sale Id 4807',1547.70,0.00,0.00,2.01,263.31,'2023-02-01 08:43:54','',''),(4760,'1','306','1',1,'Retail Sale Id 4808',4620.00,0.00,0.00,6.00,786.00,'2023-02-01 08:45:18','',''),(4761,'1','306','1',1,'Retail Sale Id 4810',9625.00,0.00,0.00,12.50,1637.50,'2023-02-01 08:49:13','',''),(4762,'1','306','1',1,'Retail Sale Id 4811',4596.90,0.00,0.00,5.97,782.07,'2023-02-01 08:51:53','',''),(4763,'1','306','1',1,'Retail Sale Id 4812',2302.30,0.00,0.00,2.99,391.69,'2023-02-01 08:53:09','',''),(4764,'1','306','1',1,'Retail Sale Id 4813',2302.30,0.00,0.00,2.99,391.69,'2023-02-01 08:59:51','',''),(4765,'1','306','1',1,'Retail Sale Id 4814',3103.10,0.00,0.00,4.03,527.93,'2023-02-01 09:08:57','',''),(4766,'1','306','1',1,'Retail Sale Id 4815',3103.10,0.00,0.00,4.03,527.93,'2023-02-01 09:10:44','',''),(4767,'1','306','1',1,'Retail Sale Id 4816',2302.30,0.00,0.00,2.99,391.69,'2023-02-01 09:19:38','',''),(4768,'1','306','1',1,'Retail Sale Id 4817',4620.00,0.00,0.00,6.00,786.00,'2023-02-01 09:28:59','',''),(4769,'1','306','1',1,'Retail Sale Id 4818',800.80,0.00,0.00,1.04,136.24,'2023-02-01 09:30:11','',''),(4770,'1','306','1',1,'Retail Sale Id 4819',1601.60,0.00,0.00,2.08,272.48,'2023-02-01 09:34:06','',''),(4771,'1','306','1',1,'Retail Sale Id 4820',9625.00,0.00,0.00,12.50,1637.50,'2023-02-01 09:38:34','',''),(4772,'1','306','1',1,'Retail Sale Id 4821',2302.30,0.00,0.00,2.99,391.69,'2023-02-01 09:42:18','',''),(4773,'1','306','1',1,'Retail Sale Id 4822',4596.90,0.00,0.00,5.97,782.07,'2023-02-01 09:44:47','',''),(4774,'1','306','1',1,'Retail Sale Id 4823',43800.00,0.00,0.00,60.00,5460.00,'2023-02-01 09:49:01','',''),(4775,'1','306','1',1,'Retail Sale Id 4824',33215.00,0.00,0.00,45.50,4140.50,'2023-02-01 09:52:00','',''),(4776,'1','306','1',1,'Retail Sale Id 4825',3080.00,0.00,0.00,4.00,524.00,'2023-02-01 09:56:06','',''),(4777,'1','306','1',1,'Retail Sale Id 4826',2002.00,0.00,0.00,2.60,340.60,'2023-02-01 09:59:18','',''),(4778,'1','306','1',1,'Retail Sale Id 4828',2310.00,0.00,0.00,3.00,393.00,'2023-02-01 10:04:05','',''),(4779,'1','306','1',1,'Retail Sale Id 4829',6198.50,0.00,0.00,8.05,1054.55,'2023-02-01 10:08:39','',''),(4780,'1','306','1',1,'Retail Sale Id 4831',1540.00,0.00,0.00,2.00,262.00,'2023-02-01 10:20:35','',''),(4781,'1','306','1',1,'Retail Sale Id 4832',8470.00,0.00,0.00,11.00,1441.00,'2023-02-01 10:21:50','',''),(4782,'1','306','1',1,'Retail Sale Id 4833',3850.00,0.00,0.00,5.00,655.00,'2023-02-01 10:23:57','',''),(4783,'1','306','1',1,'Retail Sale Id 4835',9625.00,0.00,0.00,12.50,1637.50,'2023-02-01 10:27:26','',''),(4784,'1','306','1',1,'Retail Sale Id 4836',5390.00,0.00,0.00,7.00,917.00,'2023-02-01 10:29:16','',''),(4785,'1','306','1',1,'Retail Sale Id 4837',5390.00,0.00,0.00,7.00,917.00,'2023-02-01 10:31:07','',''),(4786,'1','306','1',1,'Retail Sale Id 4839',2002.00,0.00,0.00,2.60,340.60,'2023-02-01 10:33:06','',''),(4787,'1','306','1',1,'Return of Retail Sale Id 4837',0.00,5390.00,7.00,0.00,-917.00,'2023-02-01 10:38:22','',''),(4788,'1','306','1',1,'Retail Sale Id 4841',2302.30,0.00,0.00,2.99,391.69,'2023-02-01 10:41:45','',''),(4789,'1','306','1',1,'Retail Sale Id 4842',800.80,0.00,0.00,1.04,136.24,'2023-02-01 10:43:56','',''),(4790,'1','306','1',1,'Retail Sale Id 4843',3850.00,0.00,0.00,5.00,655.00,'2023-02-01 10:45:50','',''),(4791,'1','306','1',1,'Retail Sale Id 4845',9625.00,0.00,0.00,12.50,1637.50,'2023-02-01 10:50:37','',''),(4792,'1','306','1',1,'Retail Sale Id 4847',1501.50,0.00,0.00,1.95,255.45,'2023-02-01 10:56:08','',''),(4793,'1','306','1',1,'Retail Sale Id 4848',2302.30,0.00,0.00,2.99,391.69,'2023-02-01 11:06:51','',''),(4794,'1','306','1',1,'Retail Sale Id 4849',746.90,0.00,0.00,0.97,127.07,'2023-02-01 11:18:41','',''),(4795,'1','306','1',1,'Retail Sale Id 4850',1540.00,0.00,0.00,2.00,262.00,'2023-02-01 11:24:50','',''),(4796,'1','306','1',1,'Retail Sale Id 4852',6160.00,0.00,0.00,8.00,1048.00,'2023-02-01 11:28:54','',''),(4797,'1','306','1',1,'Retail Sale Id 4853',2310.00,0.00,0.00,3.00,393.00,'2023-02-01 11:31:20','',''),(4798,'1','306','1',1,'Retail Sale Id 4853',9625.00,0.00,0.00,12.50,1637.50,'2023-02-01 11:31:20','',''),(4799,'1','306','1',1,'Retail Sale Id 4854',4620.00,0.00,0.00,6.00,786.00,'2023-02-01 11:34:02','',''),(4800,'1','306','1',1,'Retail Sale Id 4855',2302.30,0.00,0.00,2.99,391.69,'2023-02-01 11:35:59','',''),(4801,'1','306','1',1,'Retail Sale Id 4856',1547.70,0.00,0.00,2.01,263.31,'2023-02-01 11:39:07','',''),(4802,'1','306','1',1,'Retail Sale Id 4857',800.80,0.00,0.00,1.04,136.24,'2023-02-01 11:47:05','',''),(4803,'1','306','1',1,'Retail Sale Id 4858',5390.00,0.00,0.00,7.00,917.00,'2023-02-01 11:52:09','',''),(4804,'1','306','1',1,'Retail Sale Id 4859',3080.00,0.00,0.00,4.00,524.00,'2023-02-01 11:59:43','',''),(4805,'1','306','1',1,'Retail Sale Id 4860',2302.30,0.00,0.00,2.99,391.69,'2023-02-01 12:01:10','',''),(4806,'1','306','1',1,'Retail Sale Id 4861',2310.00,0.00,0.00,3.00,393.00,'2023-02-01 12:04:28','',''),(4807,'1','306','1',1,'Retail Sale Id 4862',9625.00,0.00,0.00,12.50,1637.50,'2023-02-01 12:14:41','',''),(4808,'1','306','1',1,'Retail Sale Id 4863',800.80,0.00,0.00,1.04,136.24,'2023-02-01 12:27:58','',''),(4809,'1','306','1',1,'Retail Sale Id 4864',1001.00,0.00,0.00,1.30,170.30,'2023-02-01 12:33:42','',''),(4810,'1','306','1',1,'Retail Sale Id 4866',2002.00,0.00,0.00,2.60,340.60,'2023-02-01 12:39:28','',''),(4811,'1','306','1',1,'Retail Sale Id 4867',3850.00,0.00,0.00,5.00,655.00,'2023-02-01 12:42:21','',''),(4812,'1','306','1',1,'Retail Sale Id 4868',2002.00,0.00,0.00,2.60,340.60,'2023-02-01 12:46:24','',''),(4813,'1','306','1',1,'Retail Sale Id 4869',10002.30,0.00,0.00,12.99,1701.69,'2023-02-01 12:58:05','',''),(4814,'1','306','1',1,'Retail Sale Id 4870',9240.00,0.00,0.00,12.00,1572.00,'2023-02-01 13:00:43','',''),(4815,'1','306','1',1,'Retail Sale Id 4871',3850.00,0.00,0.00,5.00,655.00,'2023-02-01 13:10:34','',''),(4816,'1','306','1',1,'Retail Sale Id 4873',800.80,0.00,0.00,1.04,136.24,'2023-02-01 13:24:59','',''),(4817,'1','306','1',1,'Retail Sale Id 4874',2310.00,0.00,0.00,3.00,393.00,'2023-02-01 13:51:21','',''),(4818,'1','306','1',1,'Retail Sale Id 4875',2002.00,0.00,0.00,2.60,340.60,'2023-02-01 13:52:29','',''),(4819,'1','306','1',1,'Retail Sale Id 4876',3080.00,0.00,0.00,4.00,524.00,'2023-02-01 14:04:38','',''),(4820,'1','306','1',1,'Retail Sale Id 4877',9625.00,0.00,0.00,12.50,1637.50,'2023-02-01 14:09:53','',''),(4821,'1','306','1',1,'Retail Sale Id 4879',9625.00,0.00,0.00,12.50,1637.50,'2023-02-01 14:14:04','',''),(4822,'1','306','1',1,'Retail Sale Id 4880',4380.00,0.00,0.00,6.00,546.00,'2023-02-01 14:15:06','',''),(4823,'1','306','1',1,'Retail Sale Id 4881',2310.00,0.00,0.00,3.00,393.00,'2023-02-01 14:16:41','',''),(4824,'1','306','1',1,'Retail Sale Id 4882',2302.30,0.00,0.00,2.99,391.69,'2023-02-01 14:18:41','',''),(4825,'1','306','1',1,'Retail Sale Id 4884',2302.30,0.00,0.00,2.99,391.69,'2023-02-01 14:36:54','',''),(4826,'1','306','1',1,'Retail Sale Id 4886',9301.60,0.00,0.00,12.08,1582.48,'2023-02-01 14:40:47','',''),(4827,'1','306','1',1,'Retail Sale Id 4888',3503.50,0.00,0.00,4.55,596.05,'2023-02-01 14:45:55','',''),(4828,'1','306','1',1,'Retail Sale Id 4889',2502.50,0.00,0.00,3.25,425.75,'2023-02-01 14:46:45','',''),(4829,'1','306','1',1,'Retail Sale Id 4890',3996.30,0.00,0.00,5.19,679.89,'2023-02-01 14:49:40','',''),(4830,'1','306','1',1,'Retail Sale Id 4891',6999.30,0.00,0.00,9.09,1190.79,'2023-02-01 14:55:32','',''),(4831,'1','306','1',1,'Retail Sale Id 4892',3203.20,0.00,0.00,4.16,544.96,'2023-02-01 14:56:35','',''),(4832,'1','306','1',1,'Retail Sale Id 4894',1501.50,0.00,0.00,1.95,255.45,'2023-02-01 14:59:32','',''),(4833,'1','306','1',1,'Retail Sale Id 4895',2302.30,0.00,0.00,2.99,391.69,'2023-02-01 15:16:57','',''),(4834,'1','306','1',1,'Retail Sale Id 4896',29930.00,0.00,0.00,41.00,3731.00,'2023-02-01 15:18:37','',''),(4835,'1','306','1',1,'Retail Sale Id 4897',2302.30,0.00,0.00,2.99,391.69,'2023-02-01 15:20:57','',''),(4836,'1','306','1',1,'Retail Sale Id 4898',2302.30,0.00,0.00,2.99,391.69,'2023-02-01 15:22:24','',''),(4837,'1','306','1',1,'Retail Sale Id 4900',3103.10,0.00,0.00,4.03,527.93,'2023-02-01 15:45:07','',''),(4838,'1','306','1',1,'Retail Sale Id 4902',3080.00,0.00,0.00,4.00,524.00,'2023-02-01 15:49:55','',''),(4839,'1','306','1',1,'Retail Sale Id 4903',3080.00,0.00,0.00,4.00,524.00,'2023-02-01 15:54:43','',''),(4840,'1','306','1',1,'Retail Sale Id 4905',2002.00,0.00,0.00,2.60,340.60,'2023-02-01 16:02:29','',''),(4841,'1','306','1',1,'Retail Sale Id 4906',24820.00,0.00,0.00,34.00,3094.00,'2023-02-01 16:05:04','',''),(4842,'1','306','1',1,'Retail Sale Id 4908',1501.50,0.00,0.00,1.95,255.45,'2023-02-01 16:09:00','',''),(4843,'1','306','1',1,'Retail Sale Id 4909',14600.00,0.00,0.00,20.00,1820.00,'2023-02-01 16:15:31','',''),(4844,'1','306','1',1,'Retail Sale Id 4910',3850.00,0.00,0.00,5.00,655.00,'2023-02-01 16:17:30','',''),(4845,'1','306','1',1,'Retail Sale Id 4911',3703.70,0.00,0.00,4.81,630.11,'2023-02-01 16:24:05','',''),(4846,'1','306','1',1,'Retail Sale Id 4912',4620.00,0.00,0.00,6.00,786.00,'2023-02-01 16:25:45','',''),(4847,'1','306','1',1,'Retail Sale Id 4913',2502.50,0.00,0.00,3.25,425.75,'2023-02-01 16:32:16','',''),(4848,'1','306','1',1,'Retail Sale Id 4914',800.80,0.00,0.00,1.04,136.24,'2023-02-01 16:33:51','',''),(4849,'1','306','1',1,'Retail Sale Id 4916',2502.50,0.00,0.00,3.25,425.75,'2023-02-01 16:45:02','',''),(4850,'1','306','1',1,'Retail Sale Id 4917',1501.50,0.00,0.00,1.95,255.45,'2023-02-01 16:45:35','',''),(4851,'1','306','1',1,'Retail Sale Id 4918',4620.00,0.00,0.00,6.00,786.00,'2023-02-01 16:50:09','',''),(4852,'1','306','1',1,'Retail Sale Id 4920',2310.00,0.00,0.00,3.00,393.00,'2023-02-01 16:52:37','',''),(4853,'1','306','1',1,'Retail Sale Id 4921',1540.00,0.00,0.00,2.00,262.00,'2023-02-01 16:54:52','',''),(4854,'1','306','1',1,'Retail Sale Id 4922',2302.30,0.00,0.00,2.99,391.69,'2023-02-01 16:56:19','',''),(4855,'1','306','1',1,'Retail Sale Id 4923',3003.00,0.00,0.00,3.90,510.90,'2023-02-01 16:57:27','',''),(4856,'1','306','1',1,'Retail Sale Id 4924',3080.00,0.00,0.00,4.00,524.00,'2023-02-01 17:00:44','',''),(4857,'1','306','1',1,'Retail Sale Id 4926',900.90,0.00,0.00,1.17,153.27,'2023-02-01 17:03:22','',''),(4858,'1','306','1',1,'Retail Sale Id 4927',3003.00,0.00,0.00,3.90,510.90,'2023-02-01 17:05:20','',''),(4859,'1','306','1',1,'Retail Sale Id 4928',1540.00,0.00,0.00,2.00,262.00,'2023-02-01 17:08:28','',''),(4860,'1','306','1',1,'Retail Sale Id 4928',6930.00,0.00,0.00,9.00,1179.00,'2023-02-01 17:08:28','',''),(4861,'1','306','1',1,'Retail Sale Id 4930',2202.20,0.00,0.00,2.86,374.66,'2023-02-01 17:14:37','',''),(4862,'1','306','1',1,'Retail Sale Id 4931',1540.00,0.00,0.00,2.00,262.00,'2023-02-01 17:16:00','',''),(4863,'1','306','1',1,'Retail Sale Id 4931',6930.00,0.00,0.00,9.00,1179.00,'2023-02-01 17:16:00','',''),(4864,'1','306','1',1,'Retail Sale Id 4933',1547.70,0.00,0.00,2.01,263.31,'2023-02-01 17:21:49','',''),(4865,'1','306','1',1,'Retail Sale Id 4934',1501.50,0.00,0.00,1.95,255.45,'2023-02-01 17:22:55','',''),(4866,'1','306','1',1,'Retail Sale Id 4935',1501.50,0.00,0.00,1.95,255.45,'2023-02-01 17:30:11','',''),(4867,'1','306','1',1,'Retail Sale Id 4936',3103.10,0.00,0.00,4.03,527.93,'2023-02-01 17:32:02','',''),(4868,'1','306','1',1,'Retail Sale Id 4937',1001.00,0.00,0.00,1.30,170.30,'2023-02-01 17:35:25','',''),(4869,'1','306','1',1,'Retail Sale Id 4939',4620.00,0.00,0.00,6.00,786.00,'2023-02-01 17:41:37','',''),(4870,'1','306','1',1,'Retail Sale Id 4940',1501.50,0.00,0.00,1.95,255.45,'2023-02-01 17:42:57','',''),(4871,'1','306','1',1,'Retail Sale Id 4942',2002.00,0.00,0.00,2.60,340.60,'2023-02-01 17:46:46','',''),(4872,'1','306','1',1,'Retail Sale Id 4942',4997.30,0.00,0.00,6.49,850.19,'2023-02-01 17:46:46','',''),(4873,'1','306','1',1,'Retail Sale Id 4943',4620.00,0.00,0.00,6.00,786.00,'2023-02-01 17:48:37','',''),(4874,'1','306','1',1,'Retail Sale Id 4944',2302.30,0.00,0.00,2.99,391.69,'2023-02-01 17:52:22','',''),(4875,'1','306','1',1,'Retail Sale Id 4945',1501.50,0.00,0.00,1.95,255.45,'2023-02-01 17:55:36','',''),(4876,'1','306','1',1,'Retail Sale Id 4946',3803.80,0.00,0.00,4.94,647.14,'2023-02-01 17:57:27','',''),(4877,'1','306','1',1,'Retail Sale Id 4947',4620.00,0.00,0.00,6.00,786.00,'2023-02-01 18:03:17','',''),(4878,'1','306','1',1,'Retail Sale Id 4949',4997.30,0.00,0.00,6.49,850.19,'2023-02-01 18:05:25','',''),(4879,'1','306','1',1,'Retail Sale Id 4951',3003.00,0.00,0.00,3.90,510.90,'2023-02-01 18:09:54','',''),(4880,'1','306','1',1,'Retail Sale Id 4952',2002.00,0.00,0.00,2.60,340.60,'2023-02-01 18:13:00','',''),(4881,'1','306','1',1,'Retail Sale Id 4953',4496.80,0.00,0.00,5.84,765.04,'2023-02-01 18:14:42','',''),(4882,'1','306','1',1,'Retail Sale Id 4954',2502.50,0.00,0.00,3.25,425.75,'2023-02-01 18:16:30','',''),(4883,'1','306','1',1,'Retail Sale Id 4956',1601.60,0.00,0.00,2.08,272.48,'2023-02-01 18:21:27','',''),(4884,'1','306','1',1,'Retail Sale Id 4957',4620.00,0.00,0.00,6.00,786.00,'2023-02-01 18:23:03','',''),(4885,'1','306','1',1,'Retail Sale Id 4960',1540.00,0.00,0.00,2.00,262.00,'2023-02-01 18:28:30','',''),(4886,'1','306','1',1,'Retail Sale Id 4961',4620.00,0.00,0.00,6.00,786.00,'2023-02-01 18:29:12','',''),(4887,'1','306','1',1,'Retail Sale Id 4962',2402.40,0.00,0.00,3.12,408.72,'2023-02-01 18:31:26','',''),(4888,'1','306','1',1,'Return of Retail Sale Id 4953',0.00,4496.80,5.84,0.00,-765.04,'2023-02-01 19:05:44','',''),(4889,'1','306','1',1,'Return of Retail Sale Id 4949',0.00,4997.30,6.49,0.00,-850.19,'2023-02-01 19:06:14','',''),(4890,'1','306','1',1,'Return of Retail Sale Id 4957',0.00,4620.00,6.00,0.00,-786.00,'2023-02-01 19:06:58','',''),(4891,'1','306','1',1,'Return of Retail Sale Id 4943',0.00,4620.00,6.00,0.00,-786.00,'2023-02-01 19:07:29','',''),(4892,'1','306','1',1,'Return of Retail Sale Id 4891',0.00,6999.30,9.09,0.00,-1190.79,'2023-02-01 19:08:14','',''),(4893,'1','306','1',1,'Retail Sale Id 4963',8816.50,0.00,0.00,11.45,1499.95,'2023-02-01 19:09:35','',''),(4894,'1','306','1',1,'Retail Sale Id 4964',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 07:31:21','',''),(4895,'1','306','1',1,'Retail Sale Id 4965',746.90,0.00,0.00,0.97,127.07,'2023-02-02 07:33:27','',''),(4896,'1','306','1',1,'Retail Sale Id 4966',6930.00,0.00,0.00,9.00,1179.00,'2023-02-02 07:35:38','',''),(4897,'1','306','1',1,'Retail Sale Id 4967',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 07:50:08','',''),(4898,'1','306','1',1,'Retail Sale Id 4968',4997.30,0.00,0.00,6.49,850.19,'2023-02-02 07:53:10','',''),(4899,'1','306','1',1,'Retail Sale Id 4969',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 07:54:35','',''),(4900,'1','306','1',1,'Retail Sale Id 4971',3996.30,0.00,0.00,5.19,679.89,'2023-02-02 08:01:55','',''),(4901,'1','306','1',1,'Retail Sale Id 4972',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 08:21:18','',''),(4902,'1','306','1',1,'Retail Sale Id 4973',4997.30,0.00,0.00,6.49,850.19,'2023-02-02 08:23:28','',''),(4903,'1','306','1',1,'Retail Sale Id 4974',2302.30,0.00,0.00,2.99,391.69,'2023-02-02 08:26:00','',''),(4904,'1','306','1',1,'Retail Sale Id 4975',4697.00,0.00,0.00,6.10,799.10,'2023-02-02 08:34:00','',''),(4905,'1','306','1',1,'Retail Sale Id 4976',1501.50,0.00,0.00,1.95,255.45,'2023-02-02 08:39:09','',''),(4906,'1','306','1',1,'Retail Sale Id 4977',2302.30,0.00,0.00,2.99,391.69,'2023-02-02 08:40:07','',''),(4907,'1','306','1',1,'Retail Sale Id 4978',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 08:44:33','',''),(4908,'1','306','1',1,'Retail Sale Id 4979',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 08:48:40','',''),(4909,'1','306','1',1,'Retail Sale Id 4980',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 08:50:19','',''),(4910,'1','306','1',1,'Retail Sale Id 4981',1601.60,0.00,0.00,2.08,272.48,'2023-02-02 08:51:22','',''),(4911,'1','306','1',1,'Retail Sale Id 4982',9625.00,0.00,0.00,12.50,1637.50,'2023-02-02 08:52:44','',''),(4912,'1','306','1',1,'Retail Sale Id 4983',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 08:53:58','',''),(4913,'1','306','1',1,'Retail Sale Id 4984',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 08:55:06','',''),(4914,'1','306','1',1,'Retail Sale Id 4985',9625.00,0.00,0.00,12.50,1637.50,'2023-02-02 08:56:20','',''),(4915,'1','306','1',1,'Retail Sale Id 4986',2302.30,0.00,0.00,2.99,391.69,'2023-02-02 08:58:21','',''),(4916,'1','306','1',1,'Retail Sale Id 4988',1540.00,0.00,0.00,2.00,262.00,'2023-02-02 09:02:22','',''),(4917,'1','306','1',1,'Retail Sale Id 4989',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 09:03:54','',''),(4918,'1','306','1',1,'Retail Sale Id 4990',2002.00,0.00,0.00,2.60,340.60,'2023-02-02 09:06:09','',''),(4919,'1','306','1',1,'Retail Sale Id 4991',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 09:07:40','',''),(4920,'1','306','1',1,'Retail Sale Id 4991',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 09:07:40','',''),(4921,'1','306','1',1,'Retail Sale Id 4992',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 09:10:56','',''),(4922,'1','306','1',1,'Retail Sale Id 4993',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 09:15:40','',''),(4923,'1','306','1',1,'Retail Sale Id 4993',3080.00,0.00,0.00,4.00,524.00,'2023-02-02 09:15:40','',''),(4924,'1','306','1',1,'Retail Sale Id 4994',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 09:17:08','',''),(4925,'1','306','1',1,'Retail Sale Id 4995',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 09:21:19','',''),(4926,'1','306','1',1,'Retail Sale Id 4996',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 09:24:21','',''),(4927,'1','306','1',1,'Retail Sale Id 4997',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 09:25:58','',''),(4928,'1','306','1',1,'Retail Sale Id 4997',9240.00,0.00,0.00,12.00,1572.00,'2023-02-02 09:25:58','',''),(4929,'1','306','1',1,'Retail Sale Id 4998',1540.00,0.00,0.00,2.00,262.00,'2023-02-02 09:27:05','',''),(4930,'1','306','1',1,'Retail Sale Id 4999',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 09:28:30','',''),(4931,'1','306','1',1,'Retail Sale Id 5000',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 09:29:22','',''),(4932,'1','306','1',1,'Retail Sale Id 5001',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 09:31:57','',''),(4933,'1','306','1',1,'Retail Sale Id 5002',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 09:33:17','',''),(4934,'1','306','1',1,'Retail Sale Id 5003',3996.30,0.00,0.00,5.19,679.89,'2023-02-02 09:34:17','',''),(4935,'1','306','1',1,'Retail Sale Id 5004',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 09:35:54','',''),(4936,'1','306','1',1,'Retail Sale Id 5005',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 09:38:13','',''),(4937,'1','306','1',1,'Retail Sale Id 5006',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 09:40:33','',''),(4938,'1','306','1',1,'Retail Sale Id 5007',1540.00,0.00,0.00,2.00,262.00,'2023-02-02 09:47:20','',''),(4939,'1','306','1',1,'Retail Sale Id 5007',3080.00,0.00,0.00,4.00,524.00,'2023-02-02 09:47:20','',''),(4940,'1','306','1',1,'Retail Sale Id 5008',1540.00,0.00,0.00,2.00,262.00,'2023-02-02 10:00:22','',''),(4941,'1','306','1',1,'Retail Sale Id 5009',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 10:04:34','',''),(4942,'1','306','1',1,'Retail Sale Id 5010',3080.00,0.00,0.00,4.00,524.00,'2023-02-02 10:08:28','',''),(4943,'1','306','1',1,'Retail Sale Id 5011',8470.00,0.00,0.00,11.00,1441.00,'2023-02-02 10:10:17','',''),(4944,'1','306','1',1,'Retail Sale Id 5012',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 10:18:55','',''),(4945,'1','306','1',1,'Retail Sale Id 5013',3080.00,0.00,0.00,4.00,524.00,'2023-02-02 10:25:42','',''),(4946,'1','306','1',1,'Retail Sale Id 5014',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 10:29:07','',''),(4947,'1','306','1',1,'Retail Sale Id 5016',3080.00,0.00,0.00,4.00,524.00,'2023-02-02 10:33:55','',''),(4948,'1','306','1',1,'Retail Sale Id 5017',539.00,0.00,0.00,0.70,91.70,'2023-02-02 10:39:01','',''),(4949,'1','306','1',1,'Retail Sale Id 5018',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 10:43:22','',''),(4950,'1','306','1',1,'Retail Sale Id 5019',128480.00,0.00,0.00,176.00,16016.00,'2023-02-02 10:45:32','',''),(4951,'1','306','1',1,'Retail Sale Id 5020',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 10:47:15','',''),(4952,'1','306','1',1,'Retail Sale Id 5021',1540.00,0.00,0.00,2.00,262.00,'2023-02-02 10:48:16','',''),(4953,'1','306','1',1,'Retail Sale Id 5022',2502.50,0.00,0.00,3.25,425.75,'2023-02-02 10:49:08','',''),(4954,'1','306','1',1,'Retail Sale Id 5023',3003.00,0.00,0.00,3.90,510.90,'2023-02-02 10:51:06','',''),(4955,'1','306','1',1,'Retail Sale Id 5023',4697.00,0.00,0.00,6.10,799.10,'2023-02-02 10:51:06','',''),(4956,'1','306','1',1,'Retail Sale Id 5024',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 10:53:45','',''),(4957,'1','306','1',1,'Retail Sale Id 5026',4650.80,0.00,0.00,6.04,791.24,'2023-02-02 10:55:39','',''),(4958,'1','306','1',1,'Retail Sale Id 5027',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 10:56:56','',''),(4959,'1','306','1',1,'Retail Sale Id 5028',3080.00,0.00,0.00,4.00,524.00,'2023-02-02 11:01:24','',''),(4960,'1','306','1',1,'Retail Sale Id 5029',1501.50,0.00,0.00,1.95,255.45,'2023-02-02 11:04:02','',''),(4961,'1','306','1',1,'Retail Sale Id 5030',1540.00,0.00,0.00,2.00,262.00,'2023-02-02 11:07:15','',''),(4962,'1','306','1',1,'Retail Sale Id 5031',800.80,0.00,0.00,1.04,136.24,'2023-02-02 11:08:02','',''),(4963,'1','306','1',1,'Retail Sale Id 5032',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 11:12:29','',''),(4964,'1','306','1',1,'Retail Sale Id 5033',3080.00,0.00,0.00,4.00,524.00,'2023-02-02 11:19:50','',''),(4965,'1','306','1',1,'Retail Sale Id 5034',9625.00,0.00,0.00,12.50,1637.50,'2023-02-02 11:21:26','',''),(4966,'1','306','1',1,'Retail Sale Id 5037',3080.00,0.00,0.00,4.00,524.00,'2023-02-02 11:23:12','',''),(4967,'1','306','1',1,'Retail Sale Id 5038',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 11:24:16','',''),(4968,'1','306','1',1,'Retail Sale Id 5039',17520.00,0.00,0.00,24.00,2184.00,'2023-02-02 11:26:03','',''),(4969,'1','306','1',1,'Retail Sale Id 5040',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 11:28:15','',''),(4970,'1','306','1',1,'Retail Sale Id 5041',9625.00,0.00,0.00,12.50,1637.50,'2023-02-02 11:31:05','',''),(4971,'1','306','1',1,'Retail Sale Id 5042',9625.00,0.00,0.00,12.50,1637.50,'2023-02-02 11:33:43','',''),(4972,'1','306','1',1,'Retail Sale Id 5043',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 11:35:15','',''),(4973,'1','306','1',1,'Retail Sale Id 5044',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 11:36:23','',''),(4974,'1','306','1',1,'Retail Sale Id 5045',9625.00,0.00,0.00,12.50,1637.50,'2023-02-02 11:37:27','',''),(4975,'1','306','1',1,'Retail Sale Id 5046',7700.00,0.00,0.00,10.00,1310.00,'2023-02-02 11:40:15','',''),(4976,'1','306','1',1,'Retail Sale Id 5047',43800.00,0.00,0.00,60.00,5460.00,'2023-02-02 11:43:17','',''),(4977,'1','306','1',1,'Retail Sale Id 5048',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 11:45:41','',''),(4978,'1','306','1',1,'Retail Sale Id 5049',800.80,0.00,0.00,1.04,136.24,'2023-02-02 11:47:09','',''),(4979,'1','306','1',1,'Retail Sale Id 5050',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 11:47:47','',''),(4980,'1','306','1',1,'Return of Retail Sale Id 5050',0.00,2310.00,3.00,0.00,-393.00,'2023-02-02 11:49:41','',''),(4981,'1','306','1',1,'Retail Sale Id 5051',1540.00,0.00,0.00,2.00,262.00,'2023-02-02 11:50:14','',''),(4982,'1','306','1',1,'Retail Sale Id 5052',4997.30,0.00,0.00,6.49,850.19,'2023-02-02 11:52:23','',''),(4983,'1','306','1',1,'Retail Sale Id 5053',21900.00,0.00,0.00,30.00,2730.00,'2023-02-02 11:55:18','',''),(4984,'1','306','1',1,'Retail Sale Id 5054',3080.00,0.00,0.00,4.00,524.00,'2023-02-02 11:57:52','',''),(4985,'1','306','1',1,'Retail Sale Id 5056',4997.30,0.00,0.00,6.49,850.19,'2023-02-02 12:01:54','',''),(4986,'1','306','1',1,'Retail Sale Id 5057',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 12:03:16','',''),(4987,'1','306','1',1,'Retail Sale Id 5059',2002.00,0.00,0.00,2.60,340.60,'2023-02-02 12:10:06','',''),(4988,'1','306','1',1,'Retail Sale Id 5060',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 12:13:07','',''),(4989,'1','306','1',1,'Retail Sale Id 5061',7700.00,0.00,0.00,10.00,1310.00,'2023-02-02 12:17:19','',''),(4990,'1','306','1',1,'Retail Sale Id 5062',2302.30,0.00,0.00,2.99,391.69,'2023-02-02 12:29:38','',''),(4991,'1','306','1',1,'Retail Sale Id 5063',9625.00,0.00,0.00,12.50,1637.50,'2023-02-02 12:30:33','',''),(4992,'1','306','1',1,'Retail Sale Id 5064',1501.50,0.00,0.00,1.95,255.45,'2023-02-02 12:34:41','',''),(4993,'1','306','1',1,'Return of Retail Sale Id 5064',0.00,1501.50,1.95,0.00,-255.45,'2023-02-02 12:36:51','',''),(4994,'1','306','1',1,'Retail Sale Id 5065',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 12:37:49','',''),(4995,'1','306','1',1,'Retail Sale Id 5066',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 12:40:05','',''),(4996,'1','306','1',1,'Retail Sale Id 5067',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 12:43:30','',''),(4997,'1','306','1',1,'Retail Sale Id 5068',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 12:50:12','',''),(4998,'1','306','1',1,'Retail Sale Id 5069',1301.30,0.00,0.00,1.69,221.39,'2023-02-02 12:51:16','',''),(4999,'1','306','1',1,'Retail Sale Id 5070',3080.00,0.00,0.00,4.00,524.00,'2023-02-02 13:23:48','',''),(5000,'1','306','1',1,'Retail Sale Id 5071',1601.60,0.00,0.00,2.08,272.48,'2023-02-02 13:25:18','',''),(5001,'1','306','1',1,'Retail Sale Id 5072',21900.00,0.00,0.00,30.00,2730.00,'2023-02-02 13:26:27','',''),(5002,'1','306','1',1,'Retail Sale Id 5074',1540.00,0.00,0.00,2.00,262.00,'2023-02-02 13:28:47','',''),(5003,'1','306','1',1,'Retail Sale Id 5074',1540.00,0.00,0.00,2.00,262.00,'2023-02-02 13:28:47','',''),(5004,'1','306','1',1,'Retail Sale Id 5075',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 13:30:23','',''),(5005,'1','306','1',1,'Retail Sale Id 5076',9625.00,0.00,0.00,12.50,1637.50,'2023-02-02 13:33:30','',''),(5006,'1','306','1',1,'Retail Sale Id 5077',5005.00,0.00,0.00,6.50,851.50,'2023-02-02 13:34:52','',''),(5007,'1','306','1',1,'Return of Retail Sale Id 5077',0.00,5005.00,6.50,0.00,-851.50,'2023-02-02 13:47:24','',''),(5008,'1','306','1',1,'Retail Sale Id 5078',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 13:48:23','',''),(5009,'1','306','1',1,'Retail Sale Id 5080',770.00,0.00,0.00,1.00,131.00,'2023-02-02 13:53:07','',''),(5010,'1','306','1',1,'Retail Sale Id 5081',38325.00,0.00,0.00,52.50,4777.50,'2023-02-02 14:12:44','',''),(5011,'1','306','1',1,'Retail Sale Id 5082',1547.70,0.00,0.00,2.01,263.31,'2023-02-02 14:14:23','',''),(5012,'1','306','1',1,'Retail Sale Id 5083',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 14:18:45','',''),(5013,'1','306','1',1,'Retail Sale Id 5084',1540.00,0.00,0.00,2.00,262.00,'2023-02-02 14:21:53','',''),(5014,'1','306','1',1,'Retail Sale Id 5085',1501.50,0.00,0.00,1.95,255.45,'2023-02-02 14:23:52','',''),(5015,'1','306','1',1,'Retail Sale Id 5086',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 14:25:37','',''),(5016,'1','306','1',1,'Retail Sale Id 5087',3080.00,0.00,0.00,4.00,524.00,'2023-02-02 14:27:34','',''),(5017,'1','306','1',1,'Retail Sale Id 5088',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 14:41:28','',''),(5018,'1','306','1',1,'Retail Sale Id 5089',5390.00,0.00,0.00,7.00,917.00,'2023-02-02 14:49:56','',''),(5019,'1','306','1',1,'Retail Sale Id 5090',4697.00,0.00,0.00,6.10,799.10,'2023-02-02 14:57:07','',''),(5020,'1','306','1',1,'Retail Sale Id 5091',2302.30,0.00,0.00,2.99,391.69,'2023-02-02 14:59:07','',''),(5021,'1','306','1',1,'Retail Sale Id 5092',3080.00,0.00,0.00,4.00,524.00,'2023-02-02 15:03:20','',''),(5022,'1','306','1',1,'Retail Sale Id 5093',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 15:05:59','',''),(5023,'1','306','1',1,'Retail Sale Id 5094',3080.00,0.00,0.00,4.00,524.00,'2023-02-02 15:06:48','',''),(5024,'1','306','1',1,'Retail Sale Id 5095',1540.00,0.00,0.00,2.00,262.00,'2023-02-02 15:08:20','',''),(5025,'1','306','1',1,'Retail Sale Id 5096',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 15:09:49','',''),(5026,'1','306','1',1,'Retail Sale Id 5096',7700.00,0.00,0.00,10.00,1310.00,'2023-02-02 15:09:49','',''),(5027,'1','306','1',1,'Retail Sale Id 5097',6160.00,0.00,0.00,8.00,1048.00,'2023-02-02 15:11:40','',''),(5028,'1','306','1',1,'Retail Sale Id 5098',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 15:12:30','',''),(5029,'1','306','1',1,'Retail Sale Id 5099',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 15:13:14','',''),(5030,'1','306','1',1,'Retail Sale Id 5100',770.00,0.00,0.00,1.00,131.00,'2023-02-02 15:14:12','',''),(5031,'1','306','1',1,'Retail Sale Id 5101',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 15:18:56','',''),(5032,'1','306','1',1,'Retail Sale Id 5102',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 15:19:59','',''),(5033,'1','306','1',1,'Retail Sale Id 5103',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 15:32:15','',''),(5034,'1','306','1',1,'Retail Sale Id 5104',1540.00,0.00,0.00,2.00,262.00,'2023-02-02 15:33:18','',''),(5035,'1','306','1',1,'Retail Sale Id 5105',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 15:37:40','',''),(5036,'1','306','1',1,'Retail Sale Id 5106',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 15:39:09','',''),(5037,'1','306','1',1,'Retail Sale Id 5107',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 15:40:58','',''),(5038,'1','306','1',1,'Retail Sale Id 5108',1501.50,0.00,0.00,1.95,255.45,'2023-02-02 15:43:11','',''),(5039,'1','306','1',1,'Retail Sale Id 5109',108040.00,0.00,0.00,148.00,13468.00,'2023-02-02 15:45:40','',''),(5040,'1','306','1',1,'Retail Sale Id 5110',800.80,0.00,0.00,1.04,136.24,'2023-02-02 15:57:52','',''),(5041,'1','306','1',1,'Retail Sale Id 5112',1501.50,0.00,0.00,1.95,255.45,'2023-02-02 16:13:02','',''),(5042,'1','306','1',1,'Retail Sale Id 5113',1540.00,0.00,0.00,2.00,262.00,'2023-02-02 16:14:49','',''),(5043,'1','306','1',1,'Retail Sale Id 5114',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 16:15:44','',''),(5044,'1','306','1',1,'Retail Sale Id 5115',3080.00,0.00,0.00,4.00,524.00,'2023-02-02 16:18:04','',''),(5045,'1','306','1',1,'Retail Sale Id 5116',3080.00,0.00,0.00,4.00,524.00,'2023-02-02 16:21:17','',''),(5046,'1','306','1',1,'Retail Sale Id 5117',770.00,0.00,0.00,1.00,131.00,'2023-02-02 16:24:26','',''),(5047,'1','306','1',1,'Retail Sale Id 5118',800.80,0.00,0.00,1.04,136.24,'2023-02-02 16:25:53','',''),(5048,'1','306','1',1,'Retail Sale Id 5119',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 16:27:12','',''),(5049,'1','306','1',1,'Retail Sale Id 5120',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 16:30:41','',''),(5050,'1','306','1',1,'Retail Sale Id 5121',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 16:32:51','',''),(5051,'1','306','1',1,'Retail Sale Id 5122',6999.30,0.00,0.00,9.09,1190.79,'2023-02-02 16:33:50','',''),(5052,'1','306','1',1,'Retail Sale Id 5123',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 16:36:21','',''),(5053,'1','306','1',1,'Retail Sale Id 5124',7700.00,0.00,0.00,10.00,1310.00,'2023-02-02 16:46:53','',''),(5054,'1','306','1',1,'Retail Sale Id 5125',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 16:48:33','',''),(5055,'1','306','1',1,'Retail Sale Id 5126',54750.00,0.00,0.00,75.00,6825.00,'2023-02-02 16:49:16','',''),(5056,'1','306','1',1,'Retail Sale Id 5127',9625.00,0.00,0.00,12.50,1637.50,'2023-02-02 16:51:01','',''),(5057,'1','306','1',1,'Retail Sale Id 5128',3080.00,0.00,0.00,4.00,524.00,'2023-02-02 16:51:45','',''),(5058,'1','306','1',1,'Retail Sale Id 5129',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 16:53:17','',''),(5059,'1','306','1',1,'Retail Sale Id 5130',800.80,0.00,0.00,1.04,136.24,'2023-02-02 16:53:53','',''),(5060,'1','306','1',1,'Retail Sale Id 5131',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 16:55:57','',''),(5061,'1','306','1',1,'Retail Sale Id 5132',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 16:58:26','',''),(5062,'1','306','1',1,'Retail Sale Id 5133',3080.00,0.00,0.00,4.00,524.00,'2023-02-02 16:59:33','',''),(5063,'1','306','1',1,'Retail Sale Id 5134',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 17:15:35','',''),(5064,'1','306','1',1,'Retail Sale Id 5135',2302.30,0.00,0.00,2.99,391.69,'2023-02-02 17:16:42','',''),(5065,'1','306','1',1,'Retail Sale Id 5137',3103.10,0.00,0.00,4.03,527.93,'2023-02-02 17:20:50','',''),(5066,'1','306','1',1,'Retail Sale Id 5138',9625.00,0.00,0.00,12.50,1637.50,'2023-02-02 17:22:02','',''),(5067,'1','306','1',1,'Retail Sale Id 5139',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 17:27:07','',''),(5068,'1','306','1',1,'Retail Sale Id 5140',3080.00,0.00,0.00,4.00,524.00,'2023-02-02 17:28:26','',''),(5069,'1','306','1',1,'Retail Sale Id 5142',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 17:34:18','',''),(5070,'1','306','1',1,'Retail Sale Id 5143',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 17:36:21','',''),(5071,'1','306','1',1,'Retail Sale Id 5144',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 17:37:56','',''),(5072,'1','306','1',1,'Retail Sale Id 5144',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 17:37:56','',''),(5073,'1','306','1',1,'Retail Sale Id 5145',2302.30,0.00,0.00,2.99,391.69,'2023-02-02 17:40:20','',''),(5074,'1','306','1',1,'Retail Sale Id 5146',3080.00,0.00,0.00,4.00,524.00,'2023-02-02 17:41:16','',''),(5075,'1','306','1',1,'Retail Sale Id 5147',1540.00,0.00,0.00,2.00,262.00,'2023-02-02 17:42:17','',''),(5076,'1','306','1',1,'Retail Sale Id 5148',3080.00,0.00,0.00,4.00,524.00,'2023-02-02 17:43:52','',''),(5077,'1','306','1',1,'Retail Sale Id 5149',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 17:45:06','',''),(5078,'1','306','1',1,'Retail Sale Id 5150',9625.00,0.00,0.00,12.50,1637.50,'2023-02-02 17:46:11','',''),(5079,'1','306','1',1,'Retail Sale Id 5151',2310.00,0.00,0.00,3.00,393.00,'2023-02-02 17:48:41','',''),(5080,'1','306','1',1,'Retail Sale Id 5152',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 17:52:43','',''),(5081,'1','306','1',1,'Retail Sale Id 5153',2502.50,0.00,0.00,3.25,425.75,'2023-02-02 17:59:06','',''),(5082,'1','306','1',1,'Retail Sale Id 5155',2502.50,0.00,0.00,3.25,425.75,'2023-02-02 18:02:07','',''),(5083,'1','306','1',1,'Retail Sale Id 5155',2502.50,0.00,0.00,3.25,425.75,'2023-02-02 18:02:07','',''),(5084,'1','306','1',1,'Retail Sale Id 5156',3996.30,0.00,0.00,5.19,679.89,'2023-02-02 18:03:17','',''),(5085,'1','306','1',1,'Retail Sale Id 5157',3996.30,0.00,0.00,5.19,679.89,'2023-02-02 18:04:57','',''),(5086,'1','306','1',1,'Retail Sale Id 5159',3996.30,0.00,0.00,5.19,679.89,'2023-02-02 18:08:08','',''),(5087,'1','306','1',1,'Retail Sale Id 5160',1001.00,0.00,0.00,1.30,170.30,'2023-02-02 18:09:18','',''),(5088,'1','306','1',1,'Retail Sale Id 5161',4697.00,0.00,0.00,6.10,799.10,'2023-02-02 18:13:36','',''),(5089,'1','306','1',1,'Retail Sale Id 5163',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 18:23:37','',''),(5090,'1','306','1',1,'Retail Sale Id 5164',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 18:28:11','',''),(5091,'1','306','1',1,'Retail Sale Id 5165',1540.00,0.00,0.00,2.00,262.00,'2023-02-02 18:29:33','',''),(5092,'1','306','1',1,'Retail Sale Id 5166',3850.00,0.00,0.00,5.00,655.00,'2023-02-02 18:31:45','',''),(5093,'1','306','1',1,'Retail Sale Id 5167',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 18:33:42','',''),(5094,'1','306','1',1,'Return of Retail Sale Id 5165',0.00,1540.00,2.00,0.00,-262.00,'2023-02-02 18:35:03','',''),(5095,'1','306','1',1,'Return of Retail Sale Id 5167',0.00,4620.00,6.00,0.00,-786.00,'2023-02-02 18:35:47','',''),(5096,'1','306','1',1,'Retail Sale Id 5168',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 18:37:09','',''),(5097,'1','306','1',1,'Retail Sale Id 5169',1540.00,0.00,0.00,2.00,262.00,'2023-02-02 18:41:59','',''),(5098,'1','306','1',1,'Retail Sale Id 5170',4620.00,0.00,0.00,6.00,786.00,'2023-02-02 18:45:36','',''),(5099,'1','306','1',1,'Retail Sale Id 5171',2002.00,0.00,0.00,2.60,340.60,'2023-02-02 18:47:22','',''),(5100,'1','306','1',1,'Return of Retail Sale Id 5019',0.00,128480.00,176.00,0.00,-16016.00,'2023-02-02 19:35:26','',''),(5101,'1','306','1',1,'Retail Sale Id 5172',20440.00,0.00,0.00,28.00,2548.00,'2023-02-02 19:36:53','',''),(5102,'1','306','1',1,'Retail Sale Id 5173',1216.60,0.00,0.00,1.58,206.98,'2023-02-02 19:37:36','',''),(5103,'1','306','1',1,'Retail Sale Id 5174',3996.30,0.00,0.00,5.19,679.89,'2023-02-03 07:32:01','',''),(5104,'1','306','1',1,'Retail Sale Id 5176',4620.00,0.00,0.00,6.00,786.00,'2023-02-03 07:35:05','',''),(5105,'1','306','1',1,'Retail Sale Id 5177',800.80,0.00,0.00,1.04,136.24,'2023-02-03 07:43:11','',''),(5106,'1','306','1',1,'Retail Sale Id 5178',9625.00,0.00,0.00,12.50,1637.50,'2023-02-03 07:58:17','',''),(5107,'1','306','1',1,'Retail Sale Id 5179',9240.00,0.00,0.00,12.00,1572.00,'2023-02-03 08:02:14','',''),(5108,'1','306','1',1,'Retail Sale Id 5180',2302.30,0.00,0.00,2.99,391.69,'2023-02-03 08:03:32','',''),(5109,'1','306','1',1,'Retail Sale Id 5181',800.80,0.00,0.00,1.04,136.24,'2023-02-03 08:12:36','',''),(5110,'1','306','1',1,'Retail Sale Id 5182',1540.00,0.00,0.00,2.00,262.00,'2023-02-03 08:13:35','',''),(5111,'1','306','1',1,'Retail Sale Id 5183',2310.00,0.00,0.00,3.00,393.00,'2023-02-03 08:18:34','',''),(5112,'1','306','1',1,'Retail Sale Id 5184',2002.00,0.00,0.00,2.60,340.60,'2023-02-03 08:21:54','',''),(5113,'1','306','1',1,'Return of Retail Sale Id 5184',0.00,2002.00,2.60,0.00,-340.60,'2023-02-03 08:24:44','',''),(5114,'1','306','1',1,'Retail Sale Id 5185',4620.00,0.00,0.00,6.00,786.00,'2023-02-03 08:25:58','',''),(5115,'1','306','1',1,'Retail Sale Id 5186',4620.00,0.00,0.00,6.00,786.00,'2023-02-03 08:27:07','',''),(5116,'1','306','1',1,'Retail Sale Id 5187',1801.80,0.00,0.00,2.34,306.54,'2023-02-03 08:30:14','',''),(5117,'1','306','1',1,'Retail Sale Id 5188',4596.90,0.00,0.00,5.97,782.07,'2023-02-03 08:31:23','',''),(5118,'1','306','1',1,'Retail Sale Id 5189',3080.00,0.00,0.00,4.00,524.00,'2023-02-03 08:35:47','',''),(5119,'1','306','1',1,'Retail Sale Id 5190',4620.00,0.00,0.00,6.00,786.00,'2023-02-03 08:38:17','',''),(5120,'1','306','1',1,'Retail Sale Id 5191',1540.00,0.00,0.00,2.00,262.00,'2023-02-03 08:40:24','',''),(5121,'1','306','1',1,'Retail Sale Id 5192',3080.00,0.00,0.00,4.00,524.00,'2023-02-03 08:41:36','',''),(5122,'1','306','1',1,'Retail Sale Id 5193',4997.30,0.00,0.00,6.49,850.19,'2023-02-03 08:42:47','',''),(5123,'1','306','1',1,'Retail Sale Id 5194',6160.00,0.00,0.00,8.00,1048.00,'2023-02-03 08:43:57','',''),(5124,'1','306','1',1,'Retail Sale Id 5195',3080.00,0.00,0.00,4.00,524.00,'2023-02-03 08:44:57','',''),(5125,'1','306','1',1,'Retail Sale Id 5196',3080.00,0.00,0.00,4.00,524.00,'2023-02-03 08:48:32','',''),(5126,'1','306','1',1,'Retail Sale Id 5197',3850.00,0.00,0.00,5.00,655.00,'2023-02-03 08:52:51','',''),(5127,'1','306','1',1,'Retail Sale Id 5198',9490.00,0.00,0.00,13.00,1183.00,'2023-02-03 08:54:09','',''),(5128,'1','306','1',1,'Retail Sale Id 5199',2310.00,0.00,0.00,3.00,393.00,'2023-02-03 08:55:39','',''),(5129,'1','306','1',1,'Retail Sale Id 5200',2302.30,0.00,0.00,2.99,391.69,'2023-02-03 08:59:37','',''),(5130,'1','306','1',1,'Retail Sale Id 5201',3850.00,0.00,0.00,5.00,655.00,'2023-02-03 09:02:14','',''),(5131,'1','306','1',1,'Retail Sale Id 5202',3080.00,0.00,0.00,4.00,524.00,'2023-02-03 09:07:42','',''),(5132,'1','306','1',1,'Retail Sale Id 5204',4596.90,0.00,0.00,5.97,782.07,'2023-02-03 09:09:35','',''),(5133,'1','306','1',1,'Retail Sale Id 5205',4620.00,0.00,0.00,6.00,786.00,'2023-02-03 09:21:16','',''),(5134,'1','306','1',1,'Retail Sale Id 5206',9625.00,0.00,0.00,12.50,1637.50,'2023-02-03 09:23:36','',''),(5135,'1','306','1',1,'Retail Sale Id 5207',4620.00,0.00,0.00,6.00,786.00,'2023-02-03 09:26:18','',''),(5136,'1','306','1',1,'Retail Sale Id 5208',8470.00,0.00,0.00,11.00,1441.00,'2023-02-03 09:27:17','',''),(5137,'1','306','1',1,'Retail Sale Id 5209',3850.00,0.00,0.00,5.00,655.00,'2023-02-03 09:28:44','',''),(5138,'1','306','1',1,'Retail Sale Id 5210',3850.00,0.00,0.00,5.00,655.00,'2023-02-03 09:29:53','',''),(5139,'1','306','1',1,'Retail Sale Id 5211',4620.00,0.00,0.00,6.00,786.00,'2023-02-03 09:31:02','',''),(5140,'1','306','1',1,'Retail Sale Id 5212',3850.00,0.00,0.00,5.00,655.00,'2023-02-03 09:32:09','',''),(5141,'1','306','1',1,'Retail Sale Id 5213',9625.00,0.00,0.00,12.50,1637.50,'2023-02-03 09:37:35','',''),(5142,'1','306','1',1,'Retail Sale Id 5214',2310.00,0.00,0.00,3.00,393.00,'2023-02-03 09:38:32','',''),(5143,'1','306','1',1,'Retail Sale Id 5215',2310.00,0.00,0.00,3.00,393.00,'2023-02-03 09:39:46','',''),(5144,'1','306','1',1,'Retail Sale Id 5216',2310.00,0.00,0.00,3.00,393.00,'2023-02-03 09:41:00','',''),(5145,'1','306','1',1,'Retail Sale Id 5217',5390.00,0.00,0.00,7.00,917.00,'2023-02-03 09:42:22','',''),(5146,'1','306','1',1,'Retail Sale Id 5218',3850.00,0.00,0.00,5.00,655.00,'2023-02-03 09:43:00','',''),(5147,'1','306','1',1,'Retail Sale Id 5219',4620.00,0.00,0.00,6.00,786.00,'2023-02-03 09:45:51','',''),(5148,'1','306','1',1,'Retail Sale Id 5220',1540.00,0.00,0.00,2.00,262.00,'2023-02-03 09:46:52','',''),(5149,'1','306','1',1,'Retail Sale Id 5222',3003.00,0.00,0.00,3.90,510.90,'2023-02-03 09:52:04','',''),(5150,'1','306','1',1,'Retail Sale Id 5223',2302.30,0.00,0.00,2.99,391.69,'2023-02-03 09:53:00','',''),(5151,'1','306','1',1,'Retail Sale Id 5224',3850.00,0.00,0.00,5.00,655.00,'2023-02-03 09:56:13','',''),(5152,'1','306','1',1,'Retail Sale Id 5225',3850.00,0.00,0.00,5.00,655.00,'2023-02-03 10:06:45','',''),(5153,'1','306','1',1,'Retail Sale Id 5226',3003.00,0.00,0.00,3.90,510.90,'2023-02-03 10:10:35','',''),(5154,'1','306','1',1,'Retail Sale Id 5227',3850.00,0.00,0.00,5.00,655.00,'2023-02-03 10:11:33','',''),(5155,'1','306','1',1,'Retail Sale Id 5228',1540.00,0.00,0.00,2.00,262.00,'2023-02-03 10:14:00','',''),(5156,'1','306','1',1,'Retail Sale Id 5229',2302.30,0.00,0.00,2.99,391.69,'2023-02-03 10:18:56','',''),(5157,'1','306','1',1,'Retail Sale Id 5230',2310.00,0.00,0.00,3.00,393.00,'2023-02-03 10:22:58','',''),(5158,'1','306','1',1,'Retail Sale Id 5230',3080.00,0.00,0.00,4.00,524.00,'2023-02-03 10:22:58','',''),(5159,'1','306','1',1,'Retail Sale Id 5231',13140.00,0.00,0.00,18.00,1638.00,'2023-02-03 10:24:21','',''),(5160,'1','306','1',1,'Retail Sale Id 5232',1601.60,0.00,0.00,2.08,272.48,'2023-02-03 10:25:24','',''),(5161,'1','306','1',1,'Retail Sale Id 5233',4620.00,0.00,0.00,6.00,786.00,'2023-02-03 10:28:45','',''),(5162,'1','306','1',1,'Retail Sale Id 5235',2348.50,0.00,0.00,3.05,399.55,'2023-02-03 10:30:03','',''),(5163,'1','306','1',1,'Retail Sale Id 5236',4620.00,0.00,0.00,6.00,786.00,'2023-02-03 10:37:43','',''),(5164,'1','306','1',1,'Retail Sale Id 5237',4620.00,0.00,0.00,6.00,786.00,'2023-02-03 10:40:34','',''),(5165,'1','306','1',1,'Retail Sale Id 5238',2310.00,0.00,0.00,3.00,393.00,'2023-02-03 10:46:39','',''),(5166,'1','306','1',1,'Retail Sale Id 5238',6160.00,0.00,0.00,8.00,1048.00,'2023-02-03 10:46:39','',''),(5167,'1','306','1',1,'Retail Sale Id 5240',3080.00,0.00,0.00,4.00,524.00,'2023-02-03 10:52:25','',''),(5168,'1','306','1',1,'Retail Sale Id 5241',3080.00,0.00,0.00,4.00,524.00,'2023-02-03 10:53:54','',''),(5169,'1','306','1',1,'Retail Sale Id 5242',2310.00,0.00,0.00,3.00,393.00,'2023-02-03 10:56:49','',''),(5170,'1','306','1',1,'Retail Sale Id 5243',9625.00,0.00,0.00,12.50,1637.50,'2023-02-03 10:59:41','',''),(5171,'1','306','1',1,'Retail Sale Id 5244',2402.40,0.00,0.00,3.12,408.72,'2023-02-03 11:03:32','',''),(5172,'1','306','1',1,'Retail Sale Id 5245',2310.00,0.00,0.00,3.00,393.00,'2023-02-03 11:04:40','',''),(5173,'1','306','1',1,'Retail Sale Id 5246',2402.40,0.00,0.00,3.12,408.72,'2023-02-03 11:11:13','',''),(5174,'1','306','1',1,'Retail Sale Id 5247',4620.00,0.00,0.00,6.00,786.00,'2023-02-03 11:18:02','',''),(5175,'1','306','1',1,'Retail Sale Id 5248',2310.00,0.00,0.00,3.00,393.00,'2023-02-03 11:19:06','',''),(5176,'1','306','1',1,'Retail Sale Id 5250',2302.30,0.00,0.00,2.99,391.69,'2023-02-03 11:28:16','',''),(5177,'1','306','1',1,'Retail Sale Id 5251',9625.00,0.00,0.00,12.50,1637.50,'2023-02-03 11:37:43','',''),(5178,'1','306','1',1,'Retail Sale Id 5253',1601.60,0.00,0.00,2.08,272.48,'2023-02-03 11:51:24','',''),(5179,'1','306','1',1,'Retail Sale Id 5254',800.80,0.00,0.00,1.04,136.24,'2023-02-03 11:56:43','',''),(5180,'1','306','1',1,'Retail Sale Id 5255',4620.00,0.00,0.00,6.00,786.00,'2023-02-03 12:14:37','',''),(5181,'1','306','1',1,'Retail Sale Id 5256',1501.50,0.00,0.00,1.95,255.45,'2023-02-03 12:15:26','',''),(5182,'1','306','1',1,'Retail Sale Id 5257',9625.00,0.00,0.00,12.50,1637.50,'2023-02-03 12:16:31','',''),(5183,'1','306','1',1,'Retail Sale Id 5258',3850.00,0.00,0.00,5.00,655.00,'2023-02-03 12:22:52','',''),(5184,'1','306','1',1,'Retail Sale Id 5259',9240.00,0.00,0.00,12.00,1572.00,'2023-02-03 12:25:08','',''),(5185,'1','306','1',1,'Retail Sale Id 5260',2310.00,0.00,0.00,3.00,393.00,'2023-02-03 12:25:46','',''),(5186,'1','306','1',1,'Retail Sale Id 5261',43800.00,0.00,0.00,60.00,5460.00,'2023-02-03 12:27:12','',''),(5187,'1','306','1',1,'Retail Sale Id 5262',3080.00,0.00,0.00,4.00,524.00,'2023-02-03 12:28:36','',''),(5188,'1','306','1',1,'Retail Sale Id 5263',4620.00,0.00,0.00,6.00,786.00,'2023-02-03 12:37:10','',''),(5189,'1','306','1',1,'Retail Sale Id 5264',2348.50,0.00,0.00,3.05,399.55,'2023-02-03 12:40:57','',''),(5190,'1','306','1',1,'Retail Sale Id 5265',4620.00,0.00,0.00,6.00,786.00,'2023-02-03 12:50:16','',''),(5191,'1','306','1',1,'Retail Sale Id 5266',2695.00,0.00,0.00,3.50,458.50,'2023-02-03 12:54:37','',''),(5192,'1','306','1',1,'Retail Sale Id 5267',3850.00,0.00,0.00,5.00,655.00,'2023-02-03 12:56:45','',''),(5193,'1','306','1',1,'Retail Sale Id 5268',3850.00,0.00,0.00,5.00,655.00,'2023-02-03 12:59:13','',''),(5194,'1','306','1',1,'Retail Sale Id 5269',1540.00,0.00,0.00,2.00,262.00,'2023-02-03 13:02:19','',''),(5195,'1','306','1',1,'Retail Sale Id 5270',2310.00,0.00,0.00,3.00,393.00,'2023-02-03 13:04:26','',''),(5196,'1','306','1',1,'Retail Sale Id 5272',3080.00,0.00,0.00,4.00,524.00,'2023-02-03 13:07:50','',''),(5197,'1','306','1',1,'Retail Sale Id 5273',1540.00,0.00,0.00,2.00,262.00,'2023-02-03 13:13:10','',''),(5198,'1','306','1',1,'Retail Sale Id 5274',5390.00,0.00,0.00,7.00,917.00,'2023-02-03 13:16:32','',''),(5199,'1','306','1',1,'Retail Sale Id 5275',1540.00,0.00,0.00,2.00,262.00,'2023-02-03 13:18:43','',''),(5200,'1','306','1',1,'Retail Sale Id 5276',3080.00,0.00,0.00,4.00,524.00,'2023-02-03 13:19:54','',''),(5201,'1','306','1',1,'Retail Sale Id 5277',2310.00,0.00,0.00,3.00,393.00,'2023-02-03 13:23:55','',''),(5202,'1','306','1',1,'Retail Sale Id 5277',2310.00,0.00,0.00,3.00,393.00,'2023-02-03 13:23:55','',''),(5203,'1','306','1',1,'Retail Sale Id 5278',2310.00,0.00,0.00,3.00,393.00,'2023-02-03 13:30:42','',''),(5204,'1','306','1',1,'Retail Sale Id 5279',1540.00,0.00,0.00,2.00,262.00,'2023-02-03 13:36:07','',''),(5205,'1','306','1',1,'Retail Sale Id 5280',4620.00,0.00,0.00,6.00,786.00,'2023-02-03 13:47:10','',''),(5206,'1','306','1',1,'Retail Sale Id 5281',3850.00,0.00,0.00,5.00,655.00,'2023-02-03 13:59:59','',''),(5207,'1','306','1',1,'Retail Sale Id 5282',1540.00,0.00,0.00,2.00,262.00,'2023-02-03 14:02:25','',''),(5208,'1','306','1',1,'Retail Sale Id 5283',3003.00,0.00,0.00,3.90,510.90,'2023-02-03 14:17:35','',''),(5209,'1','306','1',1,'Retail Sale Id 5284',2302.30,0.00,0.00,2.99,391.69,'2023-02-03 14:24:57','',''),(5210,'1','306','1',1,'Retail Sale Id 5285',3080.00,0.00,0.00,4.00,524.00,'2023-02-03 14:29:58','',''),(5211,'1','306','1',1,'Retail Sale Id 5286',7700.00,0.00,0.00,10.00,1310.00,'2023-02-03 14:32:54','',''),(5212,'1','306','1',1,'Retail Sale Id 5287',4620.00,0.00,0.00,6.00,786.00,'2023-02-03 14:38:31','',''),(5213,'1','306','1',1,'Retail Sale Id 5288',2317.70,0.00,0.00,3.01,394.31,'2023-02-03 14:44:22','',''),(5214,'1','306','1',1,'Retail Sale Id 5289',2310.00,0.00,0.00,3.00,393.00,'2023-02-03 14:45:20','',''),(5215,'1','306','1',1,'Retail Sale Id 5290',9625.00,0.00,0.00,12.50,1637.50,'2023-02-03 14:47:44','',''),(5216,'1','306','1',1,'Retail Sale Id 5291',4997.30,0.00,0.00,6.49,850.19,'2023-02-03 14:56:04','',''),(5217,'1','306','1',1,'Retail Sale Id 5292',2002.00,0.00,0.00,2.60,340.60,'2023-02-03 14:57:59','',''),(5218,'1','306','1',1,'Return of Retail Sale Id 5292',0.00,2002.00,2.60,0.00,-340.60,'2023-02-03 14:59:09','',''),(5219,'1','306','1',1,'Retail Sale Id 5293',2310.00,0.00,0.00,3.00,393.00,'2023-02-03 14:59:58','',''),(5220,'1','306','1',1,'Retail Sale Id 5294',2302.30,0.00,0.00,2.99,391.69,'2023-02-03 15:01:20','',''),(5221,'1','306','1',1,'Retail Sale Id 5295',3850.00,0.00,0.00,5.00,655.00,'2023-02-03 15:09:39','',''),(5222,'1','306','1',1,'Retail Sale Id 5296',4697.00,0.00,0.00,6.10,799.10,'2023-02-03 15:14:24','',''),(5223,'1','306','1',1,'Retail Sale Id 5297',1540.00,0.00,0.00,2.00,262.00,'2023-02-03 15:16:20','',''),(5224,'1','306','1',1,'Retail Sale Id 5298',3080.00,0.00,0.00,4.00,524.00,'2023-02-03 15:18:05','',''),(5225,'1','306','1',1,'Retail Sale Id 5299',3080.00,0.00,0.00,4.00,524.00,'2023-02-03 15:19:17','',''),(5226,'1','306','1',1,'Retail Sale Id 5300',9625.00,0.00,0.00,12.50,1637.50,'2023-02-03 15:20:37','',''),(5227,'1','306','1',1,'Retail Sale Id 5302',9702.00,0.00,0.00,12.60,1650.60,'2023-02-03 15:23:48','',''),(5228,'1','306','1',1,'Retail Sale Id 5303',1540.00,0.00,0.00,2.00,262.00,'2023-02-03 15:25:17','',''),(5229,'1','306','1',1,'Retail Sale Id 5304',2310.00,0.00,0.00,3.00,393.00,'2023-02-03 15:30:06','',''),(5230,'1','306','1',1,'Retail Sale Id 5305',7700.00,0.00,0.00,10.00,1310.00,'2023-02-03 15:42:09','',''),(5231,'1','306','1',1,'Retail Sale Id 5306',3080.00,0.00,0.00,4.00,524.00,'2023-02-03 15:53:46','',''),(5232,'1','306','1',1,'Retail Sale Id 5308',1540.00,0.00,0.00,2.00,262.00,'2023-02-03 16:00:13','',''),(5233,'1','306','1',1,'Retail Sale Id 5310',4650.80,0.00,0.00,6.04,791.24,'2023-02-03 16:05:39','',''),(5234,'1','306','1',1,'Retail Sale Id 5311',4620.00,0.00,0.00,6.00,786.00,'2023-02-03 16:11:03','',''),(5235,'1','306','1',1,'Retail Sale Id 5312',4620.00,0.00,0.00,6.00,786.00,'2023-02-03 16:46:03','',''),(5236,'1','306','1',1,'Return of Retail Sale Id 5290',0.00,9625.00,12.50,0.00,-1637.50,'2023-02-03 18:08:41','',''),(5237,'1','306','1',1,'Retail Sale Id 5314',23.10,0.00,0.00,0.03,3.93,'2023-02-03 18:15:07','',''),(5238,'1','306','1',1,'Distributed to SANI  GAS for sales id:3',18141.21,0.00,0.00,28.39,0.00,'2023-02-03 18:23:18','',''),(5239,'1','306',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,2466200.00,3800.00,0.00,0.00,'2023-02-03 20:44:32','',''),(5240,'1','306',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,3800.00,0.00,'2023-02-03 20:50:27','',''),(5241,'1','306','1',1,'Received from bridging 13',0.00,0.00,3800.00,0.00,0.00,'2023-02-03 20:50:27','',''),(5242,'1','306','1',1,'Retail Sale Id 5315',9625.00,0.00,0.00,12.50,1512.50,'2023-02-04 07:31:18','',''),(5243,'1','306','1',1,'Retail Sale Id 5316',3996.30,0.00,0.00,5.19,627.99,'2023-02-04 07:32:22','',''),(5244,'1','306','1',1,'Retail Sale Id 5317',4620.00,0.00,0.00,6.00,726.00,'2023-02-04 07:49:54','',''),(5245,'1','306','1',1,'Retail Sale Id 5318',2502.50,0.00,0.00,3.25,393.25,'2023-02-04 07:53:36','',''),(5246,'1','306','1',1,'Retail Sale Id 5319',4496.80,0.00,0.00,5.84,706.64,'2023-02-04 07:55:21','',''),(5247,'1','306','1',1,'Retail Sale Id 5321',4496.80,0.00,0.00,5.84,706.64,'2023-02-04 08:00:22','',''),(5248,'1','306','1',1,'Retail Sale Id 5322',4620.00,0.00,0.00,6.00,726.00,'2023-02-04 08:07:34','',''),(5249,'1','306','1',1,'Retail Sale Id 5323',3850.00,0.00,0.00,5.00,605.00,'2023-02-04 08:08:36','',''),(5250,'1','306','1',1,'Retail Sale Id 5324',2502.50,0.00,0.00,3.25,393.25,'2023-02-04 08:11:28','',''),(5251,'1','306','1',1,'Retail Sale Id 5325',3850.00,0.00,0.00,5.00,605.00,'2023-02-04 08:13:27','',''),(5252,'1','306','1',1,'Retail Sale Id 5326',4620.00,0.00,0.00,6.00,726.00,'2023-02-04 08:15:50','',''),(5253,'1','306','1',1,'Retail Sale Id 5327',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 08:17:12','',''),(5254,'1','306','1',1,'Retail Sale Id 5328',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 08:19:31','',''),(5255,'1','306','1',1,'Retail Sale Id 5329',9490.00,0.00,0.00,13.00,1053.00,'2023-02-04 08:20:44','',''),(5256,'1','306','1',1,'Retail Sale Id 5330',770.00,0.00,0.00,1.00,121.00,'2023-02-04 08:23:39','',''),(5257,'1','306','1',1,'Retail Sale Id 5331',3850.00,0.00,0.00,5.00,605.00,'2023-02-04 08:24:38','',''),(5258,'1','306','1',1,'Retail Sale Id 5332',2502.50,0.00,0.00,3.25,393.25,'2023-02-04 08:27:46','',''),(5259,'1','306','1',1,'Retail Sale Id 5333',4620.00,0.00,0.00,6.00,726.00,'2023-02-04 08:28:59','',''),(5260,'1','306','1',1,'Retail Sale Id 5334',4620.00,0.00,0.00,6.00,726.00,'2023-02-04 08:30:11','',''),(5261,'1','306','1',1,'Retail Sale Id 5334',4620.00,0.00,0.00,6.00,726.00,'2023-02-04 08:30:11','',''),(5262,'1','306','1',1,'Retail Sale Id 5335',2002.00,0.00,0.00,2.60,314.60,'2023-02-04 08:31:02','',''),(5263,'1','306','1',1,'Retail Sale Id 5337',9240.00,0.00,0.00,12.00,1452.00,'2023-02-04 08:31:58','',''),(5264,'1','306','1',1,'Retail Sale Id 5338',4235.00,0.00,0.00,5.50,665.50,'2023-02-04 08:32:37','',''),(5265,'1','306','1',1,'Retail Sale Id 5339',3850.00,0.00,0.00,5.00,605.00,'2023-02-04 08:34:34','',''),(5266,'1','306','1',1,'Retail Sale Id 5340',5390.00,0.00,0.00,7.00,847.00,'2023-02-04 08:36:46','',''),(5267,'1','306','1',1,'Retail Sale Id 5341',3850.00,0.00,0.00,5.00,605.00,'2023-02-04 08:37:46','',''),(5268,'1','306','1',1,'Retail Sale Id 5342',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 08:38:53','',''),(5269,'1','306','1',1,'Retail Sale Id 5343',4620.00,0.00,0.00,6.00,726.00,'2023-02-04 08:40:04','',''),(5270,'1','306','1',1,'Retail Sale Id 5344',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 08:41:07','',''),(5271,'1','306','1',1,'Retail Sale Id 5345',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 08:43:18','',''),(5272,'1','306','1',1,'Retail Sale Id 5346',2502.50,0.00,0.00,3.25,393.25,'2023-02-04 08:44:55','',''),(5273,'1','306','1',1,'Retail Sale Id 5347',2402.40,0.00,0.00,3.12,377.52,'2023-02-04 08:45:44','',''),(5274,'1','306','1',1,'Retail Sale Id 5349',4697.00,0.00,0.00,6.10,738.10,'2023-02-04 08:49:27','',''),(5275,'1','306','1',1,'Retail Sale Id 5350',2202.20,0.00,0.00,2.86,346.06,'2023-02-04 08:50:18','',''),(5276,'1','306','1',1,'Retail Sale Id 5351',2002.00,0.00,0.00,2.60,314.60,'2023-02-04 08:51:19','',''),(5277,'1','306','1',1,'Retail Sale Id 5355',3850.00,0.00,0.00,5.00,605.00,'2023-02-04 08:56:58','',''),(5278,'1','306','1',1,'Retail Sale Id 5356',4620.00,0.00,0.00,6.00,726.00,'2023-02-04 08:57:57','',''),(5279,'1','306','1',1,'Retail Sale Id 5357',2002.00,0.00,0.00,2.60,314.60,'2023-02-04 09:04:16','',''),(5280,'1','306','1',1,'Retail Sale Id 5358',3850.00,0.00,0.00,5.00,605.00,'2023-02-04 09:05:24','',''),(5281,'1','306','1',1,'Retail Sale Id 5359',1501.50,0.00,0.00,1.95,235.95,'2023-02-04 09:06:01','',''),(5282,'1','306','1',1,'Retail Sale Id 5360',4620.00,0.00,0.00,6.00,726.00,'2023-02-04 09:08:24','',''),(5283,'1','306','1',1,'Retail Sale Id 5361',4620.00,0.00,0.00,6.00,726.00,'2023-02-04 09:10:55','',''),(5284,'1','306','1',1,'Retail Sale Id 5362',9625.00,0.00,0.00,12.50,1512.50,'2023-02-04 09:12:40','',''),(5285,'1','306','1',1,'Retail Sale Id 5363',1001.00,0.00,0.00,1.30,157.30,'2023-02-04 09:16:07','',''),(5286,'1','306','1',1,'Retail Sale Id 5364',6398.70,0.00,0.00,8.31,1005.51,'2023-02-04 09:17:09','',''),(5287,'1','306','1',1,'Retail Sale Id 5365',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 09:18:01','',''),(5288,'1','306','1',1,'Retail Sale Id 5366',3080.00,0.00,0.00,4.00,484.00,'2023-02-04 09:19:14','',''),(5289,'1','306','1',1,'Retail Sale Id 5367',39420.00,0.00,0.00,54.00,4374.00,'2023-02-04 09:20:36','',''),(5290,'1','306','1',1,'Retail Sale Id 5368',9625.00,0.00,0.00,12.50,1512.50,'2023-02-04 09:21:48','',''),(5291,'1','306','1',1,'Retail Sale Id 5369',3850.00,0.00,0.00,5.00,605.00,'2023-02-04 09:23:24','',''),(5292,'1','306','1',1,'Retail Sale Id 5370',9625.00,0.00,0.00,12.50,1512.50,'2023-02-04 09:25:00','',''),(5293,'1','306','1',1,'Retail Sale Id 5371',9625.00,0.00,0.00,12.50,1512.50,'2023-02-04 09:26:38','',''),(5294,'1','306','1',1,'Retail Sale Id 5372',3850.00,0.00,0.00,5.00,605.00,'2023-02-04 09:27:43','',''),(5295,'1','306','1',1,'Retail Sale Id 5373',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 09:29:55','',''),(5296,'1','306','1',1,'Retail Sale Id 5374',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 09:33:13','',''),(5297,'1','306','1',1,'Retail Sale Id 5375',3850.00,0.00,0.00,5.00,605.00,'2023-02-04 09:39:57','',''),(5298,'1','306','1',1,'Retail Sale Id 5376',746.90,0.00,0.00,0.97,117.37,'2023-02-04 09:40:51','',''),(5299,'1','306','1',1,'Retail Sale Id 5377',800.80,0.00,0.00,1.04,125.84,'2023-02-04 09:44:08','',''),(5300,'1','306','1',1,'Retail Sale Id 5378',2302.30,0.00,0.00,2.99,361.79,'2023-02-04 09:46:40','',''),(5301,'1','306','1',1,'Retail Sale Id 5379',9625.00,0.00,0.00,12.50,1512.50,'2023-02-04 09:48:49','',''),(5302,'1','306','1',1,'Retail Sale Id 5380',4997.30,0.00,0.00,6.49,785.29,'2023-02-04 09:55:28','',''),(5303,'1','306','1',1,'Return of Retail Sale Id 5380',0.00,4997.30,6.49,0.00,-785.29,'2023-02-04 09:58:03','',''),(5304,'1','306','1',1,'Retail Sale Id 5381',731.50,0.00,0.00,0.95,114.95,'2023-02-04 09:58:48','',''),(5305,'1','306','1',1,'Retail Sale Id 5382',770.00,0.00,0.00,1.00,121.00,'2023-02-04 10:05:21','',''),(5306,'1','306','1',1,'Retail Sale Id 5383',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 10:07:39','',''),(5307,'1','306','1',1,'Retail Sale Id 5384',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 10:08:53','',''),(5308,'1','306','1',1,'Retail Sale Id 5385',4997.30,0.00,0.00,6.49,785.29,'2023-02-04 10:10:05','',''),(5309,'1','306','1',1,'Retail Sale Id 5386',1540.00,0.00,0.00,2.00,242.00,'2023-02-04 10:11:24','',''),(5310,'1','306','1',1,'Retail Sale Id 5387',2302.30,0.00,0.00,2.99,361.79,'2023-02-04 10:13:23','',''),(5311,'1','306','1',1,'Retail Sale Id 5388',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 10:15:02','',''),(5312,'1','306','1',1,'Retail Sale Id 5389',1540.00,0.00,0.00,2.00,242.00,'2023-02-04 10:16:10','',''),(5313,'1','306','1',1,'Retail Sale Id 5390',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 10:19:30','',''),(5314,'1','306','1',1,'Retail Sale Id 5391',2502.50,0.00,0.00,3.25,393.25,'2023-02-04 10:23:37','',''),(5315,'1','306','1',1,'Retail Sale Id 5392',9625.00,0.00,0.00,12.50,1512.50,'2023-02-04 10:29:18','',''),(5316,'1','306','1',1,'Retail Sale Id 5393',800.80,0.00,0.00,1.04,125.84,'2023-02-04 10:33:14','',''),(5317,'1','306','1',1,'Retail Sale Id 5394',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 10:38:21','',''),(5318,'1','306','1',1,'Retail Sale Id 5395',4620.00,0.00,0.00,6.00,726.00,'2023-02-04 10:39:46','',''),(5319,'1','306','1',1,'Retail Sale Id 5396',4620.00,0.00,0.00,6.00,726.00,'2023-02-04 10:44:34','',''),(5320,'1','306','1',1,'Retail Sale Id 5397',4620.00,0.00,0.00,6.00,726.00,'2023-02-04 10:46:42','',''),(5321,'1','306','1',1,'Retail Sale Id 5398',3080.00,0.00,0.00,4.00,484.00,'2023-02-04 10:53:17','',''),(5322,'1','306','1',1,'Retail Sale Id 5399',1001.00,0.00,0.00,1.30,157.30,'2023-02-04 10:57:23','',''),(5323,'1','306','1',1,'Retail Sale Id 5400',3080.00,0.00,0.00,4.00,484.00,'2023-02-04 11:05:16','',''),(5324,'1','306','1',1,'Retail Sale Id 5401',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 11:20:18','',''),(5325,'1','306','1',1,'Retail Sale Id 5402',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 11:23:16','',''),(5326,'1','306','1',1,'Retail Sale Id 5404',4620.00,0.00,0.00,6.00,726.00,'2023-02-04 11:29:10','',''),(5327,'1','306','1',1,'Return of Retail Sale Id 5404',0.00,4620.00,6.00,0.00,-726.00,'2023-02-04 11:31:32','',''),(5328,'1','306','1',1,'Retail Sale Id 5405',4620.00,0.00,0.00,6.00,726.00,'2023-02-04 11:37:45','',''),(5329,'1','306','1',1,'Retail Sale Id 5406',3850.00,0.00,0.00,5.00,605.00,'2023-02-04 11:38:57','',''),(5330,'1','306','1',1,'Retail Sale Id 5407',2502.50,0.00,0.00,3.25,393.25,'2023-02-04 11:40:08','',''),(5331,'1','306','1',1,'Retail Sale Id 5408',1501.50,0.00,0.00,1.95,235.95,'2023-02-04 11:41:56','',''),(5332,'1','306','1',1,'Retail Sale Id 5409',4620.00,0.00,0.00,6.00,726.00,'2023-02-04 11:43:15','',''),(5333,'1','306','1',1,'Retail Sale Id 5410',110960.00,0.00,0.00,152.00,12312.00,'2023-02-04 11:44:48','',''),(5334,'1','306','1',1,'Retail Sale Id 5411',4620.00,0.00,0.00,6.00,726.00,'2023-02-04 11:46:37','',''),(5335,'1','306','1',1,'Retail Sale Id 5412',3080.00,0.00,0.00,4.00,484.00,'2023-02-04 11:49:56','',''),(5336,'1','306','1',1,'Retail Sale Id 5413',1540.00,0.00,0.00,2.00,242.00,'2023-02-04 11:51:55','',''),(5337,'1','306','1',1,'Retail Sale Id 5413',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 11:51:55','',''),(5338,'1','306','1',1,'Retail Sale Id 5414',3080.00,0.00,0.00,4.00,484.00,'2023-02-04 11:53:44','',''),(5339,'1','306','1',1,'Retail Sale Id 5415',9625.00,0.00,0.00,12.50,1512.50,'2023-02-04 11:59:11','',''),(5340,'1','306','1',1,'Retail Sale Id 5416',4620.00,0.00,0.00,6.00,726.00,'2023-02-04 12:08:47','',''),(5341,'1','306','1',1,'Retail Sale Id 5417',3080.00,0.00,0.00,4.00,484.00,'2023-02-04 12:16:13','',''),(5342,'1','306','1',1,'Retail Sale Id 5418',1501.50,0.00,0.00,1.95,235.95,'2023-02-04 12:17:29','',''),(5343,'1','306','1',1,'Retail Sale Id 5419',43800.00,0.00,0.00,60.00,4860.00,'2023-02-04 12:26:45','',''),(5344,'1','306','1',1,'Retail Sale Id 5420',4620.00,0.00,0.00,6.00,726.00,'2023-02-04 12:31:19','',''),(5345,'1','306','1',1,'Retail Sale Id 5421',3850.00,0.00,0.00,5.00,605.00,'2023-02-04 12:33:23','',''),(5346,'1','306','1',1,'Retail Sale Id 5422',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 12:35:37','',''),(5347,'1','306','1',1,'Retail Sale Id 5424',2502.50,0.00,0.00,3.25,393.25,'2023-02-04 12:37:07','',''),(5348,'1','306','1',1,'Retail Sale Id 5425',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 12:43:34','',''),(5349,'1','306','1',1,'Retail Sale Id 5426',5497.80,0.00,0.00,7.14,863.94,'2023-02-04 12:45:19','',''),(5350,'1','306','1',1,'Retail Sale Id 5427',1501.50,0.00,0.00,1.95,235.95,'2023-02-04 12:56:45','',''),(5351,'1','306','1',1,'Retail Sale Id 5428',1540.00,0.00,0.00,2.00,242.00,'2023-02-04 13:01:36','',''),(5352,'1','306','1',1,'Retail Sale Id 5429',4620.00,0.00,0.00,6.00,726.00,'2023-02-04 13:07:01','',''),(5353,'1','306','1',1,'Retail Sale Id 5430',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 13:08:23','',''),(5354,'1','306','1',1,'Retail Sale Id 5431',3850.00,0.00,0.00,5.00,605.00,'2023-02-04 13:12:22','',''),(5355,'1','306','1',1,'Retail Sale Id 5432',2302.30,0.00,0.00,2.99,361.79,'2023-02-04 13:19:35','',''),(5356,'1','306','1',1,'Retail Sale Id 5433',43800.00,0.00,0.00,60.00,4860.00,'2023-02-04 13:24:40','',''),(5357,'1','306','1',1,'Retail Sale Id 5434',2302.30,0.00,0.00,2.99,361.79,'2023-02-04 13:26:41','',''),(5358,'1','306','1',1,'Retail Sale Id 5435',500.50,0.00,0.00,0.65,78.65,'2023-02-04 13:27:36','',''),(5359,'1','306','1',1,'Retail Sale Id 5436',3003.00,0.00,0.00,3.90,471.90,'2023-02-04 13:30:38','',''),(5360,'1','306','1',1,'Retail Sale Id 5437',88330.00,0.00,0.00,121.00,9801.00,'2023-02-04 13:33:51','',''),(5361,'1','306','1',1,'Retail Sale Id 5438',5390.00,0.00,0.00,7.00,847.00,'2023-02-04 13:36:40','',''),(5362,'1','306','1',1,'Retail Sale Id 5439',3080.00,0.00,0.00,4.00,484.00,'2023-02-04 13:38:17','',''),(5363,'1','306','1',1,'Retail Sale Id 5440',3850.00,0.00,0.00,5.00,605.00,'2023-02-04 13:39:22','',''),(5364,'1','306','1',1,'Retail Sale Id 5441',2502.50,0.00,0.00,3.25,393.25,'2023-02-04 13:40:48','',''),(5365,'1','306','1',1,'Retail Sale Id 5442',770.00,0.00,0.00,1.00,121.00,'2023-02-04 13:42:17','',''),(5366,'1','306','1',1,'Retail Sale Id 5443',3850.00,0.00,0.00,5.00,605.00,'2023-02-04 13:44:35','',''),(5367,'1','306','1',1,'Retail Sale Id 5443',9625.00,0.00,0.00,12.50,1512.50,'2023-02-04 13:44:35','',''),(5368,'1','306','1',1,'Retail Sale Id 5444',3003.00,0.00,0.00,3.90,471.90,'2023-02-04 13:48:00','',''),(5369,'1','306','1',1,'Retail Sale Id 5445',1001.00,0.00,0.00,1.30,157.30,'2023-02-04 13:48:39','',''),(5370,'1','306','1',1,'Retail Sale Id 5446',3080.00,0.00,0.00,4.00,484.00,'2023-02-04 13:50:59','',''),(5371,'1','306','1',1,'Retail Sale Id 5447',9625.00,0.00,0.00,12.50,1512.50,'2023-02-04 13:52:03','',''),(5372,'1','306','1',1,'Retail Sale Id 5448',3850.00,0.00,0.00,5.00,605.00,'2023-02-04 14:00:44','',''),(5373,'1','306','1',1,'Retail Sale Id 5449',1540.00,0.00,0.00,2.00,242.00,'2023-02-04 14:06:34','',''),(5374,'1','306','1',1,'Retail Sale Id 5450',2202.20,0.00,0.00,2.86,346.06,'2023-02-04 14:30:45','',''),(5375,'1','306','1',1,'Retail Sale Id 5451',5998.30,0.00,0.00,7.79,942.59,'2023-02-04 14:33:56','',''),(5376,'1','306','1',1,'Retail Sale Id 5452',3996.30,0.00,0.00,5.19,627.99,'2023-02-04 14:38:32','',''),(5377,'1','306','1',1,'Retail Sale Id 5453',3996.30,0.00,0.00,5.19,627.99,'2023-02-04 14:40:35','',''),(5378,'1','306','1',1,'Retail Sale Id 5454',3103.10,0.00,0.00,4.03,487.63,'2023-02-04 14:43:30','',''),(5379,'1','306','1',1,'Retail Sale Id 5455',14600.00,0.00,0.00,20.00,1620.00,'2023-02-04 14:51:26','',''),(5380,'1','306','1',1,'Retail Sale Id 5456',9625.00,0.00,0.00,12.50,1512.50,'2023-02-04 14:54:51','',''),(5381,'1','306','1',1,'Retail Sale Id 5457',3080.00,0.00,0.00,4.00,484.00,'2023-02-04 15:00:18','',''),(5382,'1','306','1',1,'Retail Sale Id 5458',770.00,0.00,0.00,1.00,121.00,'2023-02-04 15:04:43','',''),(5383,'1','306','1',1,'Retail Sale Id 5458',1540.00,0.00,0.00,2.00,242.00,'2023-02-04 15:04:43','',''),(5384,'1','306','1',1,'Retail Sale Id 5459',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 15:13:43','',''),(5385,'1','306','1',1,'Retail Sale Id 5460',3850.00,0.00,0.00,5.00,605.00,'2023-02-04 15:17:53','',''),(5386,'1','306','1',1,'Retail Sale Id 5461',7700.00,0.00,0.00,10.00,1210.00,'2023-02-04 15:22:19','',''),(5387,'1','306','1',1,'Retail Sale Id 5462',3003.00,0.00,0.00,3.90,471.90,'2023-02-04 15:25:10','',''),(5388,'1','306','1',1,'Retail Sale Id 5463',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 15:28:04','',''),(5389,'1','306','1',1,'Retail Sale Id 5464',9856.00,0.00,0.00,12.80,1548.80,'2023-02-04 15:31:31','',''),(5390,'1','306','1',1,'Retail Sale Id 5465',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 15:37:25','',''),(5391,'1','306','1',1,'Retail Sale Id 5466',3850.00,0.00,0.00,5.00,605.00,'2023-02-04 15:39:07','',''),(5392,'1','306','1',1,'Retail Sale Id 5467',800.80,0.00,0.00,1.04,125.84,'2023-02-04 15:40:57','',''),(5393,'1','306','1',1,'Retail Sale Id 5468',1001.00,0.00,0.00,1.30,157.30,'2023-02-04 15:46:31','',''),(5394,'1','306','1',1,'Retail Sale Id 5469',6160.00,0.00,0.00,8.00,968.00,'2023-02-04 15:47:57','',''),(5395,'1','306','1',1,'Retail Sale Id 5470',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 15:53:36','',''),(5396,'1','306','1',1,'Retail Sale Id 5471',3080.00,0.00,0.00,4.00,484.00,'2023-02-04 15:57:25','',''),(5397,'1','306','1',1,'Retail Sale Id 5472',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 16:00:23','',''),(5398,'1','306','1',1,'Retail Sale Id 5473',1547.70,0.00,0.00,2.01,243.21,'2023-02-04 16:02:38','',''),(5399,'1','306','1',1,'Retail Sale Id 5474',2302.30,0.00,0.00,2.99,361.79,'2023-02-04 16:05:09','',''),(5400,'1','306','1',1,'Retail Sale Id 5476',9702.00,0.00,0.00,12.60,1524.60,'2023-02-04 16:11:44','',''),(5401,'1','306','1',1,'Retail Sale Id 5477',9625.00,0.00,0.00,12.50,1512.50,'2023-02-04 16:13:11','',''),(5402,'1','306','1',1,'Retail Sale Id 5478',4620.00,0.00,0.00,6.00,726.00,'2023-02-04 16:15:39','',''),(5403,'1','306','1',1,'Retail Sale Id 5479',2502.50,0.00,0.00,3.25,393.25,'2023-02-04 16:17:55','',''),(5404,'1','306','1',1,'Retail Sale Id 5480',3003.00,0.00,0.00,3.90,471.90,'2023-02-04 16:19:08','',''),(5405,'1','306','1',1,'Retail Sale Id 5481',3080.00,0.00,0.00,4.00,484.00,'2023-02-04 16:20:25','',''),(5406,'1','306','1',1,'Retail Sale Id 5483',1547.70,0.00,0.00,2.01,243.21,'2023-02-04 16:23:47','',''),(5407,'1','306','1',1,'Retail Sale Id 5484',2348.50,0.00,0.00,3.05,369.05,'2023-02-04 16:24:55','',''),(5408,'1','306','1',1,'Retail Sale Id 5485',3080.00,0.00,0.00,4.00,484.00,'2023-02-04 16:26:41','',''),(5409,'1','306','1',1,'Retail Sale Id 5486',3080.00,0.00,0.00,4.00,484.00,'2023-02-04 16:28:37','',''),(5410,'1','306','1',1,'Retail Sale Id 5487',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 16:28:57','',''),(5411,'1','306','1',1,'Retail Sale Id 5488',1540.00,0.00,0.00,2.00,242.00,'2023-02-04 16:29:59','',''),(5412,'1','306','1',1,'Retail Sale Id 5489',9625.00,0.00,0.00,12.50,1512.50,'2023-02-04 16:30:49','',''),(5413,'1','306','1',1,'Retail Sale Id 5490',3850.00,0.00,0.00,5.00,605.00,'2023-02-04 16:31:57','',''),(5414,'1','306','1',1,'Retail Sale Id 5491',3996.30,0.00,0.00,5.19,627.99,'2023-02-04 16:39:05','',''),(5415,'1','306','1',1,'Retail Sale Id 5492',2502.50,0.00,0.00,3.25,393.25,'2023-02-04 16:43:10','',''),(5416,'1','306','1',1,'Retail Sale Id 5493',1540.00,0.00,0.00,2.00,242.00,'2023-02-04 16:43:55','',''),(5417,'1','306','1',1,'Retail Sale Id 5494',2302.30,0.00,0.00,2.99,361.79,'2023-02-04 16:44:40','',''),(5418,'1','306','1',1,'Retail Sale Id 5496',800.80,0.00,0.00,1.04,125.84,'2023-02-04 16:47:13','',''),(5419,'1','306','1',1,'Retail Sale Id 5498',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 16:50:07','',''),(5420,'1','306','1',1,'Retail Sale Id 5499',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 16:52:02','',''),(5421,'1','306','1',1,'Return of Retail Sale Id 5491',0.00,3996.30,5.19,0.00,-627.99,'2023-02-04 17:01:46','',''),(5422,'1','306','1',1,'Retail Sale Id 5500',2302.30,0.00,0.00,2.99,361.79,'2023-02-04 17:03:00','',''),(5423,'1','306','1',1,'Retail Sale Id 5501',2502.50,0.00,0.00,3.25,393.25,'2023-02-04 17:10:32','',''),(5424,'1','306','1',1,'Retail Sale Id 5502',4496.80,0.00,0.00,5.84,706.64,'2023-02-04 17:17:00','',''),(5425,'1','306','1',1,'Retail Sale Id 5503',1501.50,0.00,0.00,1.95,235.95,'2023-02-04 17:20:51','',''),(5426,'1','306','1',1,'Retail Sale Id 5505',2502.50,0.00,0.00,3.25,393.25,'2023-02-04 17:23:03','',''),(5427,'1','306','1',1,'Retail Sale Id 5506',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 17:26:16','',''),(5428,'1','306','1',1,'Retail Sale Id 5506',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 17:26:16','',''),(5429,'1','306','1',1,'Retail Sale Id 5507',5497.80,0.00,0.00,7.14,863.94,'2023-02-04 17:35:12','',''),(5430,'1','306','1',1,'Retail Sale Id 5508',1547.70,0.00,0.00,2.01,243.21,'2023-02-04 17:38:34','',''),(5431,'1','306','1',1,'Retail Sale Id 5509',9625.00,0.00,0.00,12.50,1512.50,'2023-02-04 17:42:15','',''),(5432,'1','306','1',1,'Retail Sale Id 5511',800.80,0.00,0.00,1.04,125.84,'2023-02-04 17:44:48','',''),(5433,'1','306','1',1,'Retail Sale Id 5512',9240.00,0.00,0.00,12.00,1452.00,'2023-02-04 17:47:07','',''),(5434,'1','306','1',1,'Retail Sale Id 5513',1501.50,0.00,0.00,1.95,235.95,'2023-02-04 17:48:48','',''),(5435,'1','306','1',1,'Retail Sale Id 5514',1540.00,0.00,0.00,2.00,242.00,'2023-02-04 17:54:39','',''),(5436,'1','306','1',1,'Retail Sale Id 5515',800.80,0.00,0.00,1.04,125.84,'2023-02-04 17:55:49','',''),(5437,'1','306','1',1,'Retail Sale Id 5516',2302.30,0.00,0.00,2.99,361.79,'2023-02-04 17:59:01','',''),(5438,'1','306','1',1,'Retail Sale Id 5517',2002.00,0.00,0.00,2.60,314.60,'2023-02-04 18:02:18','',''),(5439,'1','306','1',1,'Retail Sale Id 5518',1501.50,0.00,0.00,1.95,235.95,'2023-02-04 18:14:09','',''),(5440,'1','306','1',1,'Retail Sale Id 5519',2310.00,0.00,0.00,3.00,363.00,'2023-02-04 18:20:35','',''),(5441,'1','306','1',1,'Retail Sale Id 5520',700.70,0.00,0.00,0.91,110.11,'2023-02-04 18:23:06','',''),(5442,'1','306','1',1,'Retail Sale Id 5521',2002.00,0.00,0.00,2.60,314.60,'2023-02-04 18:25:42','',''),(5443,'1','306','1',1,'Retail Sale Id 5522',4697.00,0.00,0.00,6.10,738.10,'2023-02-04 18:31:51','',''),(5444,'1','306','1',1,'Retail Sale Id 5523',2302.30,0.00,0.00,2.99,361.79,'2023-02-04 18:33:27','',''),(5445,'1','306','1',1,'Retail Sale Id 5524',800.80,0.00,0.00,1.04,125.84,'2023-02-04 18:34:06','',''),(5446,'1','306','1',1,'Retail Sale Id 5525',5582.50,0.00,0.00,7.25,877.25,'2023-02-04 18:58:29','',''),(5447,'1','306','1',1,'Retail Sale Id 5526',2348.50,0.00,0.00,3.05,369.05,'2023-02-05 07:34:17','',''),(5448,'1','306','1',1,'Retail Sale Id 5528',4620.00,0.00,0.00,6.00,726.00,'2023-02-05 07:51:10','',''),(5449,'1','306','1',1,'Retail Sale Id 5529',2002.00,0.00,0.00,2.60,314.60,'2023-02-05 08:07:29','',''),(5450,'1','306','1',1,'Retail Sale Id 5530',4697.00,0.00,0.00,6.10,738.10,'2023-02-05 08:22:54','',''),(5451,'1','306','1',1,'Retail Sale Id 5531',2310.00,0.00,0.00,3.00,363.00,'2023-02-05 08:26:04','',''),(5452,'1','306','1',1,'Retail Sale Id 5532',1547.70,0.00,0.00,2.01,243.21,'2023-02-05 08:48:21','',''),(5453,'1','306','1',1,'Retail Sale Id 5533',3850.00,0.00,0.00,5.00,605.00,'2023-02-05 08:50:12','',''),(5454,'1','306','1',1,'Retail Sale Id 5534',9625.00,0.00,0.00,12.50,1512.50,'2023-02-05 08:55:39','',''),(5455,'1','306','1',1,'Retail Sale Id 5535',3080.00,0.00,0.00,4.00,484.00,'2023-02-05 08:57:32','',''),(5456,'1','306','1',1,'Retail Sale Id 5536',2310.00,0.00,0.00,3.00,363.00,'2023-02-05 09:01:27','',''),(5457,'1','306','1',1,'Retail Sale Id 5537',3850.00,0.00,0.00,5.00,605.00,'2023-02-05 09:24:25','',''),(5458,'1','306','1',1,'Retail Sale Id 5538',2002.00,0.00,0.00,2.60,314.60,'2023-02-05 09:26:37','',''),(5459,'1','306','1',1,'Retail Sale Id 5539',4620.00,0.00,0.00,6.00,726.00,'2023-02-05 09:29:18','',''),(5460,'1','306','1',1,'Retail Sale Id 5540',9625.00,0.00,0.00,12.50,1512.50,'2023-02-05 09:30:36','',''),(5461,'1','306','1',1,'Retail Sale Id 5541',3850.00,0.00,0.00,5.00,605.00,'2023-02-05 09:31:35','',''),(5462,'1','306','1',1,'Retail Sale Id 5542',1501.50,0.00,0.00,1.95,235.95,'2023-02-05 09:34:37','',''),(5463,'1','306','1',1,'Retail Sale Id 5543',2310.00,0.00,0.00,3.00,363.00,'2023-02-05 09:35:50','',''),(5464,'1','306','1',1,'Retail Sale Id 5544',3080.00,0.00,0.00,4.00,484.00,'2023-02-05 09:38:55','',''),(5465,'1','306','1',1,'Retail Sale Id 5545',3850.00,0.00,0.00,5.00,605.00,'2023-02-05 09:41:04','',''),(5466,'1','306','1',1,'Retail Sale Id 5546',3003.00,0.00,0.00,3.90,471.90,'2023-02-05 10:04:50','',''),(5467,'1','306','1',1,'Retail Sale Id 5547',9625.00,0.00,0.00,12.50,1512.50,'2023-02-05 10:05:56','',''),(5468,'1','306','1',1,'Retail Sale Id 5550',1540.00,0.00,0.00,2.00,242.00,'2023-02-05 10:07:32','',''),(5469,'1','306','1',1,'Retail Sale Id 5551',1501.50,0.00,0.00,1.95,235.95,'2023-02-05 10:12:42','',''),(5470,'1','306','1',1,'Retail Sale Id 5552',9625.00,0.00,0.00,12.50,1512.50,'2023-02-05 10:18:15','',''),(5471,'1','306','1',1,'Retail Sale Id 5554',4620.00,0.00,0.00,6.00,726.00,'2023-02-05 10:23:34','',''),(5472,'1','306','1',1,'Retail Sale Id 5555',6930.00,0.00,0.00,9.00,1089.00,'2023-02-05 10:28:23','',''),(5473,'1','306','1',1,'Retail Sale Id 5556',2310.00,0.00,0.00,3.00,363.00,'2023-02-05 10:29:37','',''),(5474,'1','306','1',1,'Retail Sale Id 5557',4697.00,0.00,0.00,6.10,738.10,'2023-02-05 10:32:35','',''),(5475,'1','306','1',1,'Retail Sale Id 5558',1001.00,0.00,0.00,1.30,157.30,'2023-02-05 10:46:23','',''),(5476,'1','306','1',1,'Retail Sale Id 5559',7700.00,0.00,0.00,10.00,1210.00,'2023-02-05 10:52:32','',''),(5477,'1','306','1',1,'Retail Sale Id 5560',1501.50,0.00,0.00,1.95,235.95,'2023-02-05 10:55:28','',''),(5478,'1','306','1',1,'Retail Sale Id 5561',4620.00,0.00,0.00,6.00,726.00,'2023-02-05 11:24:04','',''),(5479,'1','306','1',1,'Retail Sale Id 5562',9625.00,0.00,0.00,12.50,1512.50,'2023-02-05 11:38:02','',''),(5480,'1','306','1',1,'Retail Sale Id 5563',4620.00,0.00,0.00,6.00,726.00,'2023-02-05 11:41:57','',''),(5481,'1','306','1',1,'Retail Sale Id 5564',1540.00,0.00,0.00,2.00,242.00,'2023-02-05 11:43:01','',''),(5482,'1','306','1',1,'Retail Sale Id 5565',2310.00,0.00,0.00,3.00,363.00,'2023-02-05 11:44:12','',''),(5483,'1','306','1',1,'Retail Sale Id 5566',9625.00,0.00,0.00,12.50,1512.50,'2023-02-05 11:46:59','',''),(5484,'1','306','1',1,'Retail Sale Id 5568',3080.00,0.00,0.00,4.00,484.00,'2023-02-05 11:53:27','',''),(5485,'1','306','1',1,'Retail Sale Id 5569',2310.00,0.00,0.00,3.00,363.00,'2023-02-05 11:54:58','',''),(5486,'1','306','1',1,'Retail Sale Id 5570',9625.00,0.00,0.00,12.50,1512.50,'2023-02-05 11:58:07','',''),(5487,'1','306','1',1,'Retail Sale Id 5572',5005.00,0.00,0.00,6.50,786.50,'2023-02-05 12:07:43','',''),(5488,'1','306','1',1,'Retail Sale Id 5573',2310.00,0.00,0.00,3.00,363.00,'2023-02-05 12:10:37','',''),(5489,'1','306','1',1,'Retail Sale Id 5574',1001.00,0.00,0.00,1.30,157.30,'2023-02-05 12:14:17','',''),(5490,'1','306','1',1,'Retail Sale Id 5575',3080.00,0.00,0.00,4.00,484.00,'2023-02-05 12:24:37','',''),(5491,'1','306','1',1,'Retail Sale Id 5576',2348.50,0.00,0.00,3.05,369.05,'2023-02-05 12:30:01','',''),(5492,'1','306','1',1,'Retail Sale Id 5577',2310.00,0.00,0.00,3.00,363.00,'2023-02-05 12:31:47','',''),(5493,'1','306','1',1,'Retail Sale Id 5578',9625.00,0.00,0.00,12.50,1512.50,'2023-02-05 12:35:25','',''),(5494,'1','306','1',1,'Retail Sale Id 5579',2302.30,0.00,0.00,2.99,361.79,'2023-02-05 12:40:18','',''),(5495,'1','306','1',1,'Retail Sale Id 5580',1540.00,0.00,0.00,2.00,242.00,'2023-02-05 12:43:37','',''),(5496,'1','306','1',1,'Retail Sale Id 5580',2310.00,0.00,0.00,3.00,363.00,'2023-02-05 12:43:37','',''),(5497,'1','306','1',1,'Retail Sale Id 5581',770.00,0.00,0.00,1.00,121.00,'2023-02-05 12:47:36','',''),(5498,'1','306','1',1,'Retail Sale Id 5582',4620.00,0.00,0.00,6.00,726.00,'2023-02-05 12:48:33','',''),(5499,'1','306','1',1,'Retail Sale Id 5583',2002.00,0.00,0.00,2.60,314.60,'2023-02-05 12:53:44','',''),(5500,'1','306','1',1,'Retail Sale Id 5584',1601.60,0.00,0.00,2.08,251.68,'2023-02-05 12:54:37','',''),(5501,'1','306','1',1,'Retail Sale Id 5585',4620.00,0.00,0.00,6.00,726.00,'2023-02-05 12:55:47','',''),(5502,'1','306','1',1,'Retail Sale Id 5586',6999.30,0.00,0.00,9.09,1099.89,'2023-02-05 12:57:46','',''),(5503,'1','306','1',1,'Retail Sale Id 5587',1540.00,0.00,0.00,2.00,242.00,'2023-02-05 13:01:25','',''),(5504,'1','306','1',1,'Retail Sale Id 5588',9625.00,0.00,0.00,12.50,1512.50,'2023-02-05 13:03:25','',''),(5505,'1','306','1',1,'Retail Sale Id 5589',4620.00,0.00,0.00,6.00,726.00,'2023-02-05 13:04:31','',''),(5506,'1','306','1',1,'Retail Sale Id 5591',2310.00,0.00,0.00,3.00,363.00,'2023-02-05 13:08:03','',''),(5507,'1','306','1',1,'Retail Sale Id 5592',7700.00,0.00,0.00,10.00,1210.00,'2023-02-05 13:12:52','',''),(5508,'1','306','1',1,'Retail Sale Id 5593',9625.00,0.00,0.00,12.50,1512.50,'2023-02-05 13:16:09','',''),(5509,'1','306','1',1,'Retail Sale Id 5595',2348.50,0.00,0.00,3.05,369.05,'2023-02-05 13:21:53','',''),(5510,'1','306','1',1,'Retail Sale Id 5596',1501.50,0.00,0.00,1.95,235.95,'2023-02-05 13:22:57','',''),(5511,'1','306','1',1,'Retail Sale Id 5597',1547.70,0.00,0.00,2.01,243.21,'2023-02-05 13:23:57','',''),(5512,'1','306','1',1,'Retail Sale Id 5598',3080.00,0.00,0.00,4.00,484.00,'2023-02-05 13:26:08','',''),(5513,'1','306','1',1,'Retail Sale Id 5599',4620.00,0.00,0.00,6.00,726.00,'2023-02-05 13:32:55','',''),(5514,'1','306','1',1,'Retail Sale Id 5600',1501.50,0.00,0.00,1.95,235.95,'2023-02-05 13:34:04','',''),(5515,'1','306','1',1,'Retail Sale Id 5601',9625.00,0.00,0.00,12.50,1512.50,'2023-02-05 13:36:29','',''),(5516,'1','306','1',1,'Retail Sale Id 5602',1001.00,0.00,0.00,1.30,157.30,'2023-02-05 13:38:14','',''),(5517,'1','306','1',1,'Retail Sale Id 5603',2002.00,0.00,0.00,2.60,314.60,'2023-02-05 13:44:11','',''),(5518,'1','306','1',1,'Retail Sale Id 5604',4620.00,0.00,0.00,6.00,726.00,'2023-02-05 13:50:12','',''),(5519,'1','306','1',1,'Retail Sale Id 5605',4620.00,0.00,0.00,6.00,726.00,'2023-02-05 13:55:12','',''),(5520,'1','306','1',1,'Retail Sale Id 5606',9625.00,0.00,0.00,12.50,1512.50,'2023-02-05 13:56:07','',''),(5521,'1','306','1',1,'Retail Sale Id 5607',3080.00,0.00,0.00,4.00,484.00,'2023-02-05 13:57:01','',''),(5522,'1','306','1',1,'Retail Sale Id 5608',2302.30,0.00,0.00,2.99,361.79,'2023-02-05 13:58:18','',''),(5523,'1','306','1',1,'Retail Sale Id 5609',746.90,0.00,0.00,0.97,117.37,'2023-02-05 14:07:01','',''),(5524,'1','306','1',1,'Retail Sale Id 5610',1001.00,0.00,0.00,1.30,157.30,'2023-02-05 14:08:56','',''),(5525,'1','306','1',1,'Retail Sale Id 5611',9625.00,0.00,0.00,12.50,1512.50,'2023-02-05 14:14:35','',''),(5526,'1','306','1',1,'Retail Sale Id 5614',3850.00,0.00,0.00,5.00,605.00,'2023-02-05 14:21:12','',''),(5527,'1','306','1',1,'Retail Sale Id 5615',9625.00,0.00,0.00,12.50,1512.50,'2023-02-05 14:25:24','',''),(5528,'1','306','1',1,'Retail Sale Id 5616',3003.00,0.00,0.00,3.90,471.90,'2023-02-05 14:37:32','',''),(5529,'1','306','1',1,'Retail Sale Id 5618',10010.00,0.00,0.00,13.00,1573.00,'2023-02-05 14:53:02','',''),(5530,'1','306','1',1,'Retail Sale Id 5619',3850.00,0.00,0.00,5.00,605.00,'2023-02-05 14:57:44','',''),(5531,'1','306','1',1,'Retail Sale Id 5620',4650.80,0.00,0.00,6.04,730.84,'2023-02-05 14:58:24','',''),(5532,'1','306','1',1,'Retail Sale Id 5621',4620.00,0.00,0.00,6.00,726.00,'2023-02-05 15:02:12','',''),(5533,'1','306','1',1,'Retail Sale Id 5622',5390.00,0.00,0.00,7.00,847.00,'2023-02-05 15:03:48','',''),(5534,'1','306','1',1,'Retail Sale Id 5623',3080.00,0.00,0.00,4.00,484.00,'2023-02-05 15:15:32','',''),(5535,'1','306','1',1,'Retail Sale Id 5624',2310.00,0.00,0.00,3.00,363.00,'2023-02-05 15:21:14','',''),(5536,'1','306','1',1,'Retail Sale Id 5625',3080.00,0.00,0.00,4.00,484.00,'2023-02-05 15:41:24','',''),(5537,'1','306','1',1,'Retail Sale Id 5627',4620.00,0.00,0.00,6.00,726.00,'2023-02-05 17:37:23','',''),(5538,'1','306','1',1,'Retail Sale Id 5628',5390.00,0.00,0.00,7.00,847.00,'2023-02-05 17:41:18','',''),(5539,'1','306','1',1,'Retail Sale Id 5629',2310.00,0.00,0.00,3.00,363.00,'2023-02-05 17:45:40','',''),(5540,'1','306','1',1,'Retail Sale Id 5630',3850.00,0.00,0.00,5.00,605.00,'2023-02-05 17:47:29','',''),(5541,'1','306','1',1,'Retail Sale Id 5631',2310.00,0.00,0.00,3.00,363.00,'2023-02-05 17:52:54','',''),(5542,'1','306','1',1,'Retail Sale Id 5632',3003.00,0.00,0.00,3.90,471.90,'2023-02-05 18:05:28','',''),(5543,'1','306','1',1,'Retail Sale Id 5633',3850.00,0.00,0.00,5.00,605.00,'2023-02-05 18:20:41','',''),(5544,'1','306','1',1,'Retail Sale Id 5634',4620.00,0.00,0.00,6.00,726.00,'2023-02-05 18:22:31','',''),(5545,'1','306','1',1,'Return of Retail Sale Id 5625',0.00,3080.00,4.00,0.00,-484.00,'2023-02-05 18:33:15','',''),(5546,'1','306','1',1,'Return of Retail Sale Id 5631',0.00,2310.00,3.00,0.00,-363.00,'2023-02-05 19:02:08','',''),(5547,'1','306','1',1,'Retail Sale Id 5635',1771.00,0.00,0.00,2.30,278.30,'2023-02-05 19:02:35','',''),(5548,'1','306','1',1,'Retail Sale Id 5636',485.10,0.00,0.00,0.63,76.23,'2023-02-05 19:04:07','',''),(5549,'1','306','1',1,'Retail Sale Id 5637',9625.00,0.00,0.00,12.50,1512.50,'2023-02-06 07:48:09','',''),(5550,'1','306','1',1,'Retail Sale Id 5638',4620.00,0.00,0.00,6.00,726.00,'2023-02-06 08:08:32','',''),(5551,'1','306','1',1,'Retail Sale Id 5639',1601.60,0.00,0.00,2.08,251.68,'2023-02-06 10:17:05','',''),(5552,'1','306','1',1,'Retail Sale Id 5640',3080.00,0.00,0.00,4.00,484.00,'2023-02-06 10:18:12','',''),(5553,'1','306','1',1,'Retail Sale Id 5641',2310.00,0.00,0.00,3.00,363.00,'2023-02-06 10:19:55','',''),(5554,'1','306','1',1,'Retail Sale Id 5642',2310.00,0.00,0.00,3.00,363.00,'2023-02-06 10:21:05','',''),(5555,'1','306','1',1,'Retail Sale Id 5643',3503.50,0.00,0.00,4.55,550.55,'2023-02-06 10:22:21','',''),(5556,'1','306','1',1,'Retail Sale Id 5644',7700.00,0.00,0.00,10.00,1210.00,'2023-02-06 10:23:59','',''),(5557,'1','306','1',1,'Retail Sale Id 5645',6999.30,0.00,0.00,9.09,1099.89,'2023-02-06 10:25:43','',''),(5558,'1','306','1',1,'Retail Sale Id 5646',4620.00,0.00,0.00,6.00,726.00,'2023-02-06 10:28:37','',''),(5559,'1','306','1',1,'Retail Sale Id 5647',900.90,0.00,0.00,1.17,141.57,'2023-02-06 10:35:00','',''),(5560,'1','306','1',1,'Retail Sale Id 5649',3080.00,0.00,0.00,4.00,484.00,'2023-02-06 10:38:50','',''),(5561,'1','306','1',1,'Retail Sale Id 5649',9625.00,0.00,0.00,12.50,1512.50,'2023-02-06 10:38:50','',''),(5562,'1','306','1',1,'Retail Sale Id 5650',3850.00,0.00,0.00,5.00,605.00,'2023-02-06 10:43:21','',''),(5563,'1','306','1',1,'Retail Sale Id 5651',3850.00,0.00,0.00,5.00,605.00,'2023-02-06 10:53:28','',''),(5564,'1','306','1',1,'Retail Sale Id 5652',1540.00,0.00,0.00,2.00,242.00,'2023-02-06 10:54:55','',''),(5565,'1','306','1',1,'Retail Sale Id 5653',3003.00,0.00,0.00,3.90,471.90,'2023-02-06 10:56:50','',''),(5566,'1','306','1',1,'Retail Sale Id 5655',4596.90,0.00,0.00,5.97,722.37,'2023-02-06 10:58:45','',''),(5567,'1','306','1',1,'Retail Sale Id 5656',1501.50,0.00,0.00,1.95,235.95,'2023-02-06 10:59:50','',''),(5568,'1','306','1',1,'Retail Sale Id 5657',2310.00,0.00,0.00,3.00,363.00,'2023-02-06 11:01:20','',''),(5569,'1','306','1',1,'Retail Sale Id 5658',4620.00,0.00,0.00,6.00,726.00,'2023-02-06 11:02:31','',''),(5570,'1','306','1',1,'Retail Sale Id 5659',1501.50,0.00,0.00,1.95,235.95,'2023-02-06 11:04:40','',''),(5571,'1','306','1',1,'Retail Sale Id 5660',3003.00,0.00,0.00,3.90,471.90,'2023-02-06 11:07:00','',''),(5572,'1','306','1',1,'Retail Sale Id 5661',3850.00,0.00,0.00,5.00,605.00,'2023-02-06 11:11:08','',''),(5573,'1','306','1',1,'Retail Sale Id 5662',1540.00,0.00,0.00,2.00,242.00,'2023-02-06 11:12:02','',''),(5574,'1','306','1',1,'Retail Sale Id 5663',2310.00,0.00,0.00,3.00,363.00,'2023-02-06 11:12:57','',''),(5575,'1','306','1',1,'Retail Sale Id 5664',1540.00,0.00,0.00,2.00,242.00,'2023-02-06 11:21:45','',''),(5576,'1','306','1',1,'Retail Sale Id 5665',137605.00,0.00,0.00,188.50,15268.50,'2023-02-06 11:37:38','',''),(5577,'1','306','1',1,'Retail Sale Id 5666',16790.00,0.00,0.00,23.00,1863.00,'2023-02-06 11:40:42','',''),(5578,'1','306','1',1,'Retail Sale Id 5667',18250.00,0.00,0.00,25.00,2025.00,'2023-02-06 11:44:19','',''),(5579,'1','306','1',1,'Retail Sale Id 5668',9625.00,0.00,0.00,12.50,1512.50,'2023-02-06 11:50:51','',''),(5580,'1','306','1',1,'Retail Sale Id 5669',800.80,0.00,0.00,1.04,125.84,'2023-02-06 11:52:03','',''),(5581,'1','306','1',1,'Retail Sale Id 5670',9625.00,0.00,0.00,12.50,1512.50,'2023-02-06 12:00:22','',''),(5582,'1','306','1',1,'Retail Sale Id 5671',2310.00,0.00,0.00,3.00,363.00,'2023-02-06 12:06:36','',''),(5583,'1','306','1',1,'Retail Sale Id 5672',9625.00,0.00,0.00,12.50,1512.50,'2023-02-06 12:08:23','',''),(5584,'1','306','1',1,'Retail Sale Id 5673',7700.00,0.00,0.00,10.00,1210.00,'2023-02-06 12:10:01','',''),(5585,'1','306','1',1,'Retail Sale Id 5674',2202.20,0.00,0.00,2.86,346.06,'2023-02-06 12:11:42','',''),(5586,'1','306','1',1,'Retail Sale Id 5676',11550.00,0.00,0.00,15.00,1815.00,'2023-02-06 12:16:35','',''),(5587,'1','306','1',1,'Retail Sale Id 5677',2002.00,0.00,0.00,2.60,314.60,'2023-02-06 12:18:12','',''),(5588,'1','306','1',1,'Retail Sale Id 5678',800.80,0.00,0.00,1.04,125.84,'2023-02-06 12:19:04','',''),(5589,'1','306','1',1,'Retail Sale Id 5682',2002.00,0.00,0.00,2.60,314.60,'2023-02-06 12:24:26','',''),(5590,'1','306','1',1,'Retail Sale Id 5683',1501.50,0.00,0.00,1.95,235.95,'2023-02-06 12:27:44','',''),(5591,'1','306','1',1,'Retail Sale Id 5684',2310.00,0.00,0.00,3.00,363.00,'2023-02-06 12:35:48','',''),(5592,'1','306','1',1,'Retail Sale Id 5685',2302.30,0.00,0.00,2.99,361.79,'2023-02-06 12:37:55','',''),(5593,'1','306','1',1,'Retail Sale Id 5686',9625.00,0.00,0.00,12.50,1512.50,'2023-02-06 12:41:09','',''),(5594,'1','306','1',1,'Retail Sale Id 5687',3003.00,0.00,0.00,3.90,471.90,'2023-02-06 12:44:46','',''),(5595,'1','306','1',1,'Retail Sale Id 5689',3080.00,0.00,0.00,4.00,484.00,'2023-02-06 12:47:02','',''),(5596,'1','306','1',1,'Retail Sale Id 5690',2302.30,0.00,0.00,2.99,361.79,'2023-02-06 12:52:00','',''),(5597,'1','306','1',1,'Retail Sale Id 5691',4620.00,0.00,0.00,6.00,726.00,'2023-02-06 12:56:00','',''),(5598,'1','306','1',1,'Retail Sale Id 5693',4620.00,0.00,0.00,6.00,726.00,'2023-02-06 13:01:08','',''),(5599,'1','306','1',1,'Retail Sale Id 5694',3850.00,0.00,0.00,5.00,605.00,'2023-02-06 13:07:04','',''),(5600,'1','306','1',1,'Retail Sale Id 5695',3080.00,0.00,0.00,4.00,484.00,'2023-02-06 13:11:30','',''),(5601,'1','306','1',1,'Retail Sale Id 5696',800.80,0.00,0.00,1.04,125.84,'2023-02-06 13:14:27','',''),(5602,'1','306','1',1,'Retail Sale Id 5697',1501.50,0.00,0.00,1.95,235.95,'2023-02-06 13:16:05','',''),(5603,'1','306','1',1,'Retail Sale Id 5698',3850.00,0.00,0.00,5.00,605.00,'2023-02-06 13:17:38','',''),(5604,'1','306','1',1,'Retail Sale Id 5699',3080.00,0.00,0.00,4.00,484.00,'2023-02-06 13:29:55','',''),(5605,'1','306','1',1,'Retail Sale Id 5700',1001.00,0.00,0.00,1.30,157.30,'2023-02-06 13:35:41','',''),(5606,'1','306','1',1,'Retail Sale Id 5701',9625.00,0.00,0.00,12.50,1512.50,'2023-02-06 13:45:51','',''),(5607,'1','306','1',1,'Retail Sale Id 5702',2079.00,0.00,0.00,2.70,326.70,'2023-02-06 13:51:46','',''),(5608,'1','306','1',1,'Retail Sale Id 5702',4620.00,0.00,0.00,6.00,726.00,'2023-02-06 13:51:46','',''),(5609,'1','306','1',1,'Retail Sale Id 5702',8470.00,0.00,0.00,11.00,1331.00,'2023-02-06 13:51:46','',''),(5610,'1','306','1',1,'Retail Sale Id 5703',4596.90,0.00,0.00,5.97,722.37,'2023-02-06 13:53:40','',''),(5611,'1','306','1',1,'Retail Sale Id 5704',3080.00,0.00,0.00,4.00,484.00,'2023-02-06 13:56:22','',''),(5612,'1','306','1',1,'Retail Sale Id 5705',3850.00,0.00,0.00,5.00,605.00,'2023-02-06 13:57:53','',''),(5613,'1','306','1',1,'Retail Sale Id 5706',3080.00,0.00,0.00,4.00,484.00,'2023-02-06 14:02:58','',''),(5614,'1','306','1',1,'Retail Sale Id 5706',4620.00,0.00,0.00,6.00,726.00,'2023-02-06 14:02:58','',''),(5615,'1','306','1',1,'Retail Sale Id 5707',9625.00,0.00,0.00,12.50,1512.50,'2023-02-06 14:09:09','',''),(5616,'1','306','1',1,'Retail Sale Id 5708',1540.00,0.00,0.00,2.00,242.00,'2023-02-06 14:10:26','',''),(5617,'1','306','1',1,'Retail Sale Id 5709',4620.00,0.00,0.00,6.00,726.00,'2023-02-06 14:11:55','',''),(5618,'1','306','1',1,'Retail Sale Id 5710',1540.00,0.00,0.00,2.00,242.00,'2023-02-06 14:16:17','',''),(5619,'1','306','1',1,'Retail Sale Id 5711',3850.00,0.00,0.00,5.00,605.00,'2023-02-06 14:17:21','',''),(5620,'1','306','1',1,'Retail Sale Id 5712',2002.00,0.00,0.00,2.60,314.60,'2023-02-06 14:18:44','',''),(5621,'1','306','1',1,'Retail Sale Id 5713',6999.30,0.00,0.00,9.09,1099.89,'2023-02-06 14:24:21','',''),(5622,'1','306','1',1,'Retail Sale Id 5714',4620.00,0.00,0.00,6.00,726.00,'2023-02-06 14:29:22','',''),(5623,'1','306','1',1,'Retail Sale Id 5714',9240.00,0.00,0.00,12.00,1452.00,'2023-02-06 14:29:22','',''),(5624,'1','306','1',1,'Retail Sale Id 5715',2310.00,0.00,0.00,3.00,363.00,'2023-02-06 14:33:12','',''),(5625,'1','306','1',1,'Retail Sale Id 5717',4620.00,0.00,0.00,6.00,726.00,'2023-02-06 14:47:28','',''),(5626,'1','306','1',1,'Retail Sale Id 5720',3080.00,0.00,0.00,4.00,484.00,'2023-02-06 14:50:03','',''),(5627,'1','306','1',1,'Retail Sale Id 5721',2302.30,0.00,0.00,2.99,361.79,'2023-02-06 14:53:10','',''),(5628,'1','306','1',1,'Retail Sale Id 5722',1501.50,0.00,0.00,1.95,235.95,'2023-02-06 14:54:36','',''),(5629,'1','306','1',1,'Retail Sale Id 5724',6930.00,0.00,0.00,9.00,1089.00,'2023-02-06 15:03:29','',''),(5630,'1','306','1',1,'Retail Sale Id 5725',4620.00,0.00,0.00,6.00,726.00,'2023-02-06 15:04:14','',''),(5631,'1','306','1',1,'Retail Sale Id 5726',1501.50,0.00,0.00,1.95,235.95,'2023-02-06 15:06:35','',''),(5632,'1','306','1',1,'Retail Sale Id 5727',2302.30,0.00,0.00,2.99,361.79,'2023-02-06 15:07:28','',''),(5633,'1','306','1',1,'Retail Sale Id 5728',9625.00,0.00,0.00,12.50,1512.50,'2023-02-06 15:09:14','',''),(5634,'1','306','1',1,'Retail Sale Id 5729',1501.50,0.00,0.00,1.95,235.95,'2023-02-06 15:18:43','',''),(5635,'1','306','1',1,'Retail Sale Id 5730',7700.00,0.00,0.00,10.00,1210.00,'2023-02-06 15:19:41','',''),(5636,'1','306','1',1,'Retail Sale Id 5731',4620.00,0.00,0.00,6.00,726.00,'2023-02-06 15:45:48','',''),(5637,'1','306','1',1,'Retail Sale Id 5732',2302.30,0.00,0.00,2.99,361.79,'2023-02-06 15:47:35','',''),(5638,'1','306','1',1,'Retail Sale Id 5733',7700.00,0.00,0.00,10.00,1210.00,'2023-02-06 15:49:16','',''),(5639,'1','306','1',1,'Retail Sale Id 5734',3003.00,0.00,0.00,3.90,471.90,'2023-02-06 15:50:45','',''),(5640,'1','306','1',1,'Retail Sale Id 5735',800.80,0.00,0.00,1.04,125.84,'2023-02-06 15:55:07','',''),(5641,'1','306','1',1,'Retail Sale Id 5737',1501.50,0.00,0.00,1.95,235.95,'2023-02-06 16:00:06','',''),(5642,'1','306','1',1,'Retail Sale Id 5739',2302.30,0.00,0.00,2.99,361.79,'2023-02-06 16:04:56','',''),(5643,'1','306','1',1,'Retail Sale Id 5740',800.80,0.00,0.00,1.04,125.84,'2023-02-06 16:07:54','',''),(5644,'1','306','1',1,'Retail Sale Id 5741',1501.50,0.00,0.00,1.95,235.95,'2023-02-06 16:12:04','',''),(5645,'1','306','1',1,'Retail Sale Id 5742',2748.90,0.00,0.00,3.57,431.97,'2023-02-06 17:02:34','',''),(5646,'1','306','1',1,'Retail Sale Id 5743',39716.60,0.00,0.00,51.58,6241.18,'2023-02-07 14:15:31','',''),(5647,'1','306','1',1,'Retail Sale Id 5744',3003.00,0.00,0.00,3.90,471.90,'2023-02-07 14:21:22','',''),(5648,'1','306','1',1,'Retail Sale Id 5745',9625.00,0.00,0.00,12.50,1512.50,'2023-02-07 14:24:20','',''),(5649,'1','306','1',1,'Retail Sale Id 5746',4620.00,0.00,0.00,6.00,726.00,'2023-02-07 14:44:30','',''),(5650,'1','306','1',1,'Retail Sale Id 5747',1540.00,0.00,0.00,2.00,242.00,'2023-02-07 14:45:55','',''),(5651,'1','306','1',1,'Retail Sale Id 5749',2502.50,0.00,0.00,3.25,393.25,'2023-02-07 14:48:11','',''),(5652,'1','306','1',1,'Retail Sale Id 5750',2502.50,0.00,0.00,3.25,393.25,'2023-02-07 14:49:23','',''),(5653,'1','306','1',1,'Retail Sale Id 5752',800.80,0.00,0.00,1.04,125.84,'2023-02-07 15:05:32','',''),(5654,'1','306','1',1,'Retail Sale Id 5754',1601.60,0.00,0.00,2.08,251.68,'2023-02-07 15:23:04','',''),(5655,'1','306','1',1,'Retail Sale Id 5756',770.00,0.00,0.00,1.00,121.00,'2023-02-07 15:31:07','',''),(5656,'1','306','1',1,'Retail Sale Id 5757',9625.00,0.00,0.00,12.50,1512.50,'2023-02-07 15:32:50','',''),(5657,'1','306','1',1,'Retail Sale Id 5758',3103.10,0.00,0.00,4.03,487.63,'2023-02-07 15:33:49','',''),(5658,'1','306','1',1,'Retail Sale Id 5759',5390.00,0.00,0.00,7.00,847.00,'2023-02-07 15:35:48','',''),(5659,'1','306','1',1,'Retail Sale Id 5762',1501.50,0.00,0.00,1.95,235.95,'2023-02-07 15:59:37','',''),(5660,'1','306','1',1,'Retail Sale Id 5764',3850.00,0.00,0.00,5.00,605.00,'2023-02-07 16:07:50','',''),(5661,'1','306','1',1,'Retail Sale Id 5766',9625.00,0.00,0.00,12.50,1512.50,'2023-02-07 16:13:55','',''),(5662,'1','306','1',1,'Retail Sale Id 5767',3850.00,0.00,0.00,5.00,605.00,'2023-02-07 16:15:22','',''),(5663,'1','306','1',1,'Retail Sale Id 5768',2002.00,0.00,0.00,2.60,314.60,'2023-02-07 16:17:02','',''),(5664,'1','306','1',1,'Retail Sale Id 5769',9625.00,0.00,0.00,12.50,1512.50,'2023-02-07 16:23:16','',''),(5665,'1','306','1',1,'Retail Sale Id 5770',3003.00,0.00,0.00,3.90,471.90,'2023-02-07 16:27:15','',''),(5666,'1','306','1',1,'Retail Sale Id 5771',2310.00,0.00,0.00,3.00,363.00,'2023-02-07 16:28:44','',''),(5667,'1','306','1',1,'Retail Sale Id 5772',9301.60,0.00,0.00,12.08,1461.68,'2023-02-07 16:30:02','',''),(5668,'1','306','1',1,'Retail Sale Id 5773',1501.50,0.00,0.00,1.95,235.95,'2023-02-07 16:35:29','',''),(5669,'1','306','1',1,'Retail Sale Id 5774',3503.50,0.00,0.00,4.55,550.55,'2023-02-07 16:37:05','',''),(5670,'1','306','1',1,'Retail Sale Id 5775',1547.70,0.00,0.00,2.01,243.21,'2023-02-07 16:38:00','',''),(5671,'1','306','1',1,'Retail Sale Id 5776',7700.00,0.00,0.00,10.00,1210.00,'2023-02-07 16:42:39','',''),(5672,'1','306','1',1,'Retail Sale Id 5778',3850.00,0.00,0.00,5.00,605.00,'2023-02-07 16:47:31','',''),(5673,'1','306','1',1,'Retail Sale Id 5779',3003.00,0.00,0.00,3.90,471.90,'2023-02-07 16:52:18','',''),(5674,'1','306','1',1,'Retail Sale Id 5780',2302.30,0.00,0.00,2.99,361.79,'2023-02-07 16:53:19','',''),(5675,'1','306','1',1,'Retail Sale Id 5781',1501.50,0.00,0.00,1.95,235.95,'2023-02-07 16:54:12','',''),(5676,'1','306','1',1,'Retail Sale Id 5782',800.80,0.00,0.00,1.04,125.84,'2023-02-07 16:55:27','',''),(5677,'1','306','1',1,'Retail Sale Id 5783',2302.30,0.00,0.00,2.99,361.79,'2023-02-07 17:02:53','',''),(5678,'1','306','1',1,'Retail Sale Id 5784',3996.30,0.00,0.00,5.19,627.99,'2023-02-07 17:05:25','',''),(5679,'1','306','1',1,'Retail Sale Id 5785',1001.00,0.00,0.00,1.30,157.30,'2023-02-07 17:06:23','',''),(5680,'1','306','1',1,'Retail Sale Id 5786',2002.00,0.00,0.00,2.60,314.60,'2023-02-07 17:07:19','',''),(5681,'1','306','1',1,'Retail Sale Id 5787',1547.70,0.00,0.00,2.01,243.21,'2023-02-07 17:09:53','',''),(5682,'1','306','1',1,'Retail Sale Id 5788',1501.50,0.00,0.00,1.95,235.95,'2023-02-07 17:10:59','',''),(5683,'1','306','1',1,'Retail Sale Id 5789',3850.00,0.00,0.00,5.00,605.00,'2023-02-07 17:14:55','',''),(5684,'1','306','1',1,'Retail Sale Id 5790',2302.30,0.00,0.00,2.99,361.79,'2023-02-07 17:16:21','',''),(5685,'1','306','1',1,'Retail Sale Id 5791',2302.30,0.00,0.00,2.99,361.79,'2023-02-07 17:20:44','',''),(5686,'1','306','1',1,'Retail Sale Id 5792',9601.90,0.00,0.00,12.47,1508.87,'2023-02-07 17:21:40','',''),(5687,'1','306','1',1,'Retail Sale Id 5793',4697.00,0.00,0.00,6.10,738.10,'2023-02-07 17:23:38','',''),(5688,'1','306','1',1,'Retail Sale Id 5794',1501.50,0.00,0.00,1.95,235.95,'2023-02-07 17:24:53','',''),(5689,'1','306','1',1,'Retail Sale Id 5795',3203.20,0.00,0.00,4.16,503.36,'2023-02-07 17:26:27','',''),(5690,'1','306','1',1,'Retail Sale Id 5796',4620.00,0.00,0.00,6.00,726.00,'2023-02-07 17:31:59','',''),(5691,'1','306','1',1,'Retail Sale Id 5797',3003.00,0.00,0.00,3.90,471.90,'2023-02-07 17:34:56','',''),(5692,'1','306','1',1,'Retail Sale Id 5798',2502.50,0.00,0.00,3.25,393.25,'2023-02-07 17:35:42','',''),(5693,'1','306','1',1,'Retail Sale Id 5799',4620.00,0.00,0.00,6.00,726.00,'2023-02-07 17:40:11','',''),(5694,'1','306','1',1,'Retail Sale Id 5800',3103.10,0.00,0.00,4.03,487.63,'2023-02-07 17:47:43','',''),(5695,'1','306','1',1,'Retail Sale Id 5802',2302.30,0.00,0.00,2.99,361.79,'2023-02-07 17:56:03','',''),(5696,'1','306','1',1,'Retail Sale Id 5803',3850.00,0.00,0.00,5.00,605.00,'2023-02-07 17:58:31','',''),(5697,'1','306','1',1,'Retail Sale Id 5804',1501.50,0.00,0.00,1.95,235.95,'2023-02-07 17:59:27','',''),(5698,'1','306','1',1,'Retail Sale Id 5805',800.80,0.00,0.00,1.04,125.84,'2023-02-07 18:04:04','',''),(5699,'1','306','1',1,'Retail Sale Id 5806',3080.00,0.00,0.00,4.00,484.00,'2023-02-07 18:06:15','',''),(5700,'1','306','1',1,'Retail Sale Id 5807',2002.00,0.00,0.00,2.60,314.60,'2023-02-07 18:07:22','',''),(5701,'1','306','1',1,'Retail Sale Id 5808',1501.50,0.00,0.00,1.95,235.95,'2023-02-07 18:08:17','',''),(5702,'1','306','1',1,'Retail Sale Id 5809',9625.00,0.00,0.00,12.50,1512.50,'2023-02-07 18:12:35','',''),(5703,'1','306','1',1,'Retail Sale Id 5810',4620.00,0.00,0.00,6.00,726.00,'2023-02-07 18:30:05','',''),(5704,'1','306','1',1,'Retail Sale Id 5811',3103.10,0.00,0.00,4.03,487.63,'2023-02-07 18:35:15','',''),(5705,'1','306','1',1,'Return of Retail Sale Id 5805',0.00,800.80,1.04,0.00,-125.84,'2023-02-07 18:42:17','',''),(5706,'1','306','1',1,'Retail Sale Id 5812',808.50,0.00,0.00,1.05,127.05,'2023-02-07 18:43:41','',''),(5707,'1','306','1',1,'Retail Sale Id 5813',800.80,0.00,0.00,1.04,125.84,'2023-02-08 07:18:38','',''),(5708,'1','306','1',1,'Retail Sale Id 5814',1540.00,0.00,0.00,2.00,242.00,'2023-02-08 07:19:55','',''),(5709,'1','306','1',1,'Retail Sale Id 5815',4620.00,0.00,0.00,6.00,726.00,'2023-02-08 07:31:49','',''),(5710,'1','306','1',1,'Retail Sale Id 5816',3996.30,0.00,0.00,5.19,627.99,'2023-02-08 07:37:54','',''),(5711,'1','306','1',1,'Retail Sale Id 5817',2310.00,0.00,0.00,3.00,363.00,'2023-02-08 07:54:56','',''),(5712,'1','306','1',1,'Retail Sale Id 5817',7700.00,0.00,0.00,10.00,1210.00,'2023-02-08 07:54:56','',''),(5713,'1','306','1',1,'Retail Sale Id 5818',770.00,0.00,0.00,1.00,121.00,'2023-02-08 07:56:36','',''),(5714,'1','306','1',1,'Retail Sale Id 5819',3850.00,0.00,0.00,5.00,605.00,'2023-02-08 07:58:30','',''),(5715,'1','306','1',1,'Retail Sale Id 5820',3850.00,0.00,0.00,5.00,605.00,'2023-02-08 08:00:49','',''),(5716,'1','306','1',1,'Retail Sale Id 5821',4620.00,0.00,0.00,6.00,726.00,'2023-02-08 08:03:01','',''),(5717,'1','306','1',1,'Retail Sale Id 5822',4797.10,0.00,0.00,6.23,753.83,'2023-02-08 08:09:01','',''),(5718,'1','306','1',1,'Retail Sale Id 5823',3703.70,0.00,0.00,4.81,582.01,'2023-02-08 08:14:45','',''),(5719,'1','306','1',1,'Retail Sale Id 5824',3003.00,0.00,0.00,3.90,471.90,'2023-02-08 08:19:57','',''),(5720,'1','306','1',1,'Retail Sale Id 5825',2302.30,0.00,0.00,2.99,361.79,'2023-02-08 08:21:14','',''),(5721,'1','306','1',1,'Retail Sale Id 5826',3103.10,0.00,0.00,4.03,487.63,'2023-02-08 08:22:22','',''),(5722,'1','306','1',1,'Retail Sale Id 5827',800.80,0.00,0.00,1.04,125.84,'2023-02-08 08:27:09','',''),(5723,'1','306','1',1,'Retail Sale Id 5828',9625.00,0.00,0.00,12.50,1512.50,'2023-02-08 08:28:41','',''),(5724,'1','306','1',1,'Retail Sale Id 5829',4620.00,0.00,0.00,6.00,726.00,'2023-02-08 08:30:12','',''),(5725,'1','306','1',1,'Retail Sale Id 5830',2317.70,0.00,0.00,3.01,364.21,'2023-02-08 08:32:09','',''),(5726,'1','306','1',1,'Retail Sale Id 5831',9625.00,0.00,0.00,12.50,1512.50,'2023-02-08 08:34:01','',''),(5727,'1','306','1',1,'Retail Sale Id 5832',2302.30,0.00,0.00,2.99,361.79,'2023-02-08 08:42:01','',''),(5728,'1','306','1',1,'Retail Sale Id 5833',3080.00,0.00,0.00,4.00,484.00,'2023-02-08 08:45:55','',''),(5729,'1','306','1',1,'Retail Sale Id 5834',5390.00,0.00,0.00,7.00,847.00,'2023-02-08 08:48:24','',''),(5730,'1','306','1',1,'Retail Sale Id 5835',2310.00,0.00,0.00,3.00,363.00,'2023-02-08 08:49:48','',''),(5731,'1','306','1',1,'Retail Sale Id 5836',800.80,0.00,0.00,1.04,125.84,'2023-02-08 08:50:39','',''),(5732,'1','306','1',1,'Retail Sale Id 5837',2310.00,0.00,0.00,3.00,363.00,'2023-02-08 08:51:46','',''),(5733,'1','306','1',1,'Retail Sale Id 5838',2302.30,0.00,0.00,2.99,361.79,'2023-02-08 08:53:29','',''),(5734,'1','306','1',1,'Retail Sale Id 5839',34310.00,0.00,0.00,47.00,3807.00,'2023-02-08 08:55:16','',''),(5735,'1','306','1',1,'Retail Sale Id 5840',5390.00,0.00,0.00,7.00,847.00,'2023-02-08 09:01:33','',''),(5736,'1','306','1',1,'Retail Sale Id 5841',3850.00,0.00,0.00,5.00,605.00,'2023-02-08 09:04:20','',''),(5737,'1','306','1',1,'Retail Sale Id 5842',3850.00,0.00,0.00,5.00,605.00,'2023-02-08 09:06:31','',''),(5738,'1','306','1',1,'Retail Sale Id 5843',1501.50,0.00,0.00,1.95,235.95,'2023-02-08 09:08:07','',''),(5739,'1','306','1',1,'Retail Sale Id 5844',3850.00,0.00,0.00,5.00,605.00,'2023-02-08 09:10:37','',''),(5740,'1','306','1',1,'Retail Sale Id 5845',7700.00,0.00,0.00,10.00,1210.00,'2023-02-08 09:12:32','',''),(5741,'1','306','1',1,'Retail Sale Id 5846',1501.50,0.00,0.00,1.95,235.95,'2023-02-08 09:13:50','',''),(5742,'1','306','1',1,'Retail Sale Id 5847',3850.00,0.00,0.00,5.00,605.00,'2023-02-08 09:15:30','',''),(5743,'1','306','1',1,'Retail Sale Id 5848',8470.00,0.00,0.00,11.00,1331.00,'2023-02-08 09:19:41','',''),(5744,'1','306','1',1,'Retail Sale Id 5849',3003.00,0.00,0.00,3.90,471.90,'2023-02-08 09:21:31','',''),(5745,'1','306','1',1,'Retail Sale Id 5850',3850.00,0.00,0.00,5.00,605.00,'2023-02-08 09:24:20','',''),(5746,'1','306','1',1,'Retail Sale Id 5851',800.80,0.00,0.00,1.04,125.84,'2023-02-08 09:25:21','',''),(5747,'1','306','1',1,'Retail Sale Id 5852',9240.00,0.00,0.00,12.00,1452.00,'2023-02-08 09:26:50','',''),(5748,'1','306','1',1,'Retail Sale Id 5853',1547.70,0.00,0.00,2.01,243.21,'2023-02-08 09:30:59','',''),(5749,'1','306','1',1,'Retail Sale Id 5854',5497.80,0.00,0.00,7.14,863.94,'2023-02-08 09:32:38','',''),(5750,'1','306','1',1,'Retail Sale Id 5855',9501.80,0.00,0.00,12.34,1493.14,'2023-02-08 09:33:59','',''),(5751,'1','306','1',1,'Retail Sale Id 5856',9625.00,0.00,0.00,12.50,1512.50,'2023-02-08 09:35:56','',''),(5752,'1','306','1',1,'Retail Sale Id 5857',5390.00,0.00,0.00,7.00,847.00,'2023-02-08 09:37:54','',''),(5753,'1','306','1',1,'Retail Sale Id 5858',3003.00,0.00,0.00,3.90,471.90,'2023-02-08 09:39:17','',''),(5754,'1','306','1',1,'Retail Sale Id 5859',2310.00,0.00,0.00,3.00,363.00,'2023-02-08 09:41:04','',''),(5755,'1','306','1',1,'Retail Sale Id 5860',3850.00,0.00,0.00,5.00,605.00,'2023-02-08 09:41:45','',''),(5756,'1','306','1',1,'Retail Sale Id 5861',9625.00,0.00,0.00,12.50,1512.50,'2023-02-08 09:46:06','',''),(5757,'1','306','1',1,'Retail Sale Id 5862',4697.00,0.00,0.00,6.10,738.10,'2023-02-08 09:50:43','',''),(5758,'1','306','1',1,'Retail Sale Id 5863',3896.20,0.00,0.00,5.06,612.26,'2023-02-08 10:00:32','',''),(5759,'1','306','1',1,'Retail Sale Id 5864',3850.00,0.00,0.00,5.00,605.00,'2023-02-08 10:13:19','',''),(5760,'1','306','1',1,'Retail Sale Id 5865',3103.10,0.00,0.00,4.03,487.63,'2023-02-08 10:15:48','',''),(5761,'1','306','1',1,'Retail Sale Id 5866',5390.00,0.00,0.00,7.00,847.00,'2023-02-08 10:17:17','',''),(5762,'1','306','1',1,'Retail Sale Id 5867',3103.10,0.00,0.00,4.03,487.63,'2023-02-08 10:18:17','',''),(5763,'1','306','1',1,'Retail Sale Id 5868',2310.00,0.00,0.00,3.00,363.00,'2023-02-08 10:19:32','',''),(5764,'1','306','1',1,'Retail Sale Id 5869',2310.00,0.00,0.00,3.00,363.00,'2023-02-08 10:20:46','',''),(5765,'1','306','1',1,'Retail Sale Id 5870',1501.50,0.00,0.00,1.95,235.95,'2023-02-08 10:21:42','',''),(5766,'1','306','1',1,'Retail Sale Id 5871',3850.00,0.00,0.00,5.00,605.00,'2023-02-08 10:25:22','',''),(5767,'1','306','1',1,'Retail Sale Id 5872',3850.00,0.00,0.00,5.00,605.00,'2023-02-08 10:29:00','',''),(5768,'1','306','1',1,'Retail Sale Id 5873',11550.00,0.00,0.00,15.00,1815.00,'2023-02-08 10:33:44','',''),(5769,'1','306','1',1,'Retail Sale Id 5874',3850.00,0.00,0.00,5.00,605.00,'2023-02-08 10:46:58','',''),(5770,'1','306','1',1,'Retail Sale Id 5875',3850.00,0.00,0.00,5.00,605.00,'2023-02-08 10:48:54','',''),(5771,'1','306','1',1,'Retail Sale Id 5876',2002.00,0.00,0.00,2.60,314.60,'2023-02-08 10:51:53','',''),(5772,'1','306','1',1,'Retail Sale Id 5877',1540.00,0.00,0.00,2.00,242.00,'2023-02-08 10:59:43','',''),(5773,'1','306','1',1,'Retail Sale Id 5878',4496.80,0.00,0.00,5.84,706.64,'2023-02-08 11:07:05','',''),(5774,'1','306','1',1,'Retail Sale Id 5879',9240.00,0.00,0.00,12.00,1452.00,'2023-02-08 11:10:34','',''),(5775,'1','306','1',1,'Retail Sale Id 5880',4620.00,0.00,0.00,6.00,726.00,'2023-02-08 11:26:33','',''),(5776,'1','306','1',1,'Retail Sale Id 5881',2502.50,0.00,0.00,3.25,393.25,'2023-02-08 11:29:22','',''),(5777,'1','306','1',1,'Retail Sale Id 5882',9240.00,0.00,0.00,12.00,1452.00,'2023-02-08 11:31:37','',''),(5778,'1','306','1',1,'Retail Sale Id 5883',3850.00,0.00,0.00,5.00,605.00,'2023-02-08 11:50:22','',''),(5779,'1','306','1',1,'Retail Sale Id 5884',14600.00,0.00,0.00,20.00,1620.00,'2023-02-08 11:57:44','',''),(5780,'1','306','1',1,'Retail Sale Id 5885',5390.00,0.00,0.00,7.00,847.00,'2023-02-08 12:02:07','',''),(5781,'1','306','1',1,'Retail Sale Id 5887',2310.00,0.00,0.00,3.00,363.00,'2023-02-08 12:05:34','',''),(5782,'1','306','1',1,'Retail Sale Id 5888',4620.00,0.00,0.00,6.00,726.00,'2023-02-08 12:06:18','',''),(5783,'1','306','1',1,'Retail Sale Id 5889',3003.00,0.00,0.00,3.90,471.90,'2023-02-08 12:07:21','',''),(5784,'1','306','1',1,'Retail Sale Id 5890',2302.30,0.00,0.00,2.99,361.79,'2023-02-08 12:16:42','',''),(5785,'1','306','1',1,'Retail Sale Id 5891',3080.00,0.00,0.00,4.00,484.00,'2023-02-08 12:19:47','',''),(5786,'1','306','1',1,'Retail Sale Id 5892',3003.00,0.00,0.00,3.90,471.90,'2023-02-08 12:21:57','',''),(5787,'1','306','1',1,'Retail Sale Id 5894',4620.00,0.00,0.00,6.00,726.00,'2023-02-08 12:28:39','',''),(5788,'1','306','1',1,'Retail Sale Id 5895',2310.00,0.00,0.00,3.00,363.00,'2023-02-08 12:35:04','',''),(5789,'1','306','1',1,'Retail Sale Id 5896',4620.00,0.00,0.00,6.00,726.00,'2023-02-08 12:48:11','',''),(5790,'1','306','1',1,'Retail Sale Id 5897',7700.00,0.00,0.00,10.00,1210.00,'2023-02-08 12:53:49','',''),(5791,'1','306','1',1,'Retail Sale Id 5898',3080.00,0.00,0.00,4.00,484.00,'2023-02-08 12:55:03','',''),(5792,'1','306','1',1,'Retail Sale Id 5899',1001.00,0.00,0.00,1.30,157.30,'2023-02-08 12:59:36','',''),(5793,'1','306','1',1,'Retail Sale Id 5900',9625.00,0.00,0.00,12.50,1512.50,'2023-02-08 13:08:46','',''),(5794,'1','306','1',1,'Retail Sale Id 5901',3003.00,0.00,0.00,3.90,471.90,'2023-02-08 13:10:52','',''),(5795,'1','306','1',1,'Retail Sale Id 5902',3080.00,0.00,0.00,4.00,484.00,'2023-02-08 13:17:23','',''),(5796,'1','306','1',1,'Retail Sale Id 5904',6930.00,0.00,0.00,9.00,1089.00,'2023-02-08 13:28:39','',''),(5797,'1','306','1',1,'Retail Sale Id 5905',1501.50,0.00,0.00,1.95,235.95,'2023-02-08 13:32:30','',''),(5798,'1','306','1',1,'Retail Sale Id 5906',7700.00,0.00,0.00,10.00,1210.00,'2023-02-08 13:34:41','',''),(5799,'1','306','1',1,'Retail Sale Id 5907',9625.00,0.00,0.00,12.50,1512.50,'2023-02-08 13:37:29','',''),(5800,'1','306','1',1,'Retail Sale Id 5910',9301.60,0.00,0.00,12.08,1461.68,'2023-02-08 14:00:03','',''),(5801,'1','306','1',1,'Retail Sale Id 5911',4496.80,0.00,0.00,5.84,706.64,'2023-02-08 14:01:11','',''),(5802,'1','306','1',1,'Retail Sale Id 5912',9625.00,0.00,0.00,12.50,1512.50,'2023-02-08 14:03:55','',''),(5803,'1','306','1',1,'Retail Sale Id 5913',4620.00,0.00,0.00,6.00,726.00,'2023-02-08 14:05:04','',''),(5804,'1','306','1',1,'Retail Sale Id 5914',3080.00,0.00,0.00,4.00,484.00,'2023-02-08 14:06:44','',''),(5805,'1','306','1',1,'Retail Sale Id 5915',1501.50,0.00,0.00,1.95,235.95,'2023-02-08 14:07:29','',''),(5806,'1','306','1',1,'Retail Sale Id 5916',4620.00,0.00,0.00,6.00,726.00,'2023-02-08 14:20:20','',''),(5807,'1','306','1',1,'Retail Sale Id 5917',1547.70,0.00,0.00,2.01,243.21,'2023-02-08 14:22:48','',''),(5808,'1','306','1',1,'Retail Sale Id 5918',2317.70,0.00,0.00,3.01,364.21,'2023-02-08 14:24:23','',''),(5809,'1','306','1',1,'Retail Sale Id 5919',3203.20,0.00,0.00,4.16,503.36,'2023-02-08 14:38:06','',''),(5810,'1','306','1',1,'Retail Sale Id 5920',9625.00,0.00,0.00,12.50,1512.50,'2023-02-08 14:47:36','',''),(5811,'1','306','1',1,'Retail Sale Id 5922',2310.00,0.00,0.00,3.00,363.00,'2023-02-08 14:56:27','',''),(5812,'1','306','1',1,'Retail Sale Id 5923',1501.50,0.00,0.00,1.95,235.95,'2023-02-08 14:58:09','',''),(5813,'1','306','1',1,'Retail Sale Id 5924',2310.00,0.00,0.00,3.00,363.00,'2023-02-08 15:00:50','',''),(5814,'1','306','1',1,'Retail Sale Id 5925',700.70,0.00,0.00,0.91,110.11,'2023-02-08 15:05:53','',''),(5815,'1','306','1',1,'Retail Sale Id 5926',2695.00,0.00,0.00,3.50,423.50,'2023-02-08 15:09:03','',''),(5816,'1','306','1',1,'Retail Sale Id 5927',2310.00,0.00,0.00,3.00,363.00,'2023-02-08 15:23:17','',''),(5817,'1','306','1',1,'Retail Sale Id 5930',2695.00,0.00,0.00,3.50,423.50,'2023-02-08 15:29:34','',''),(5818,'1','306','1',1,'Retail Sale Id 5932',2502.50,0.00,0.00,3.25,393.25,'2023-02-08 15:33:51','',''),(5819,'1','306','1',1,'Retail Sale Id 5933',18250.00,0.00,0.00,25.00,2025.00,'2023-02-08 15:41:14','',''),(5820,'1','306','1',1,'Retail Sale Id 5934',1540.00,0.00,0.00,2.00,242.00,'2023-02-08 15:46:32','',''),(5821,'1','306','1',1,'Retail Sale Id 5935',4620.00,0.00,0.00,6.00,726.00,'2023-02-08 15:47:45','',''),(5822,'1','306','1',1,'Retail Sale Id 5936',4620.00,0.00,0.00,6.00,726.00,'2023-02-08 15:50:59','',''),(5823,'1','306','1',1,'Retail Sale Id 5937',3850.00,0.00,0.00,5.00,605.00,'2023-02-08 15:53:03','',''),(5824,'1','306','1',1,'Retail Sale Id 5939',1547.70,0.00,0.00,2.01,243.21,'2023-02-08 15:56:15','',''),(5825,'1','306','1',1,'Retail Sale Id 5940',3103.10,0.00,0.00,4.03,487.63,'2023-02-08 15:57:24','',''),(5826,'1','306','1',1,'Retail Sale Id 5941',2310.00,0.00,0.00,3.00,363.00,'2023-02-08 15:58:18','',''),(5827,'1','306','1',1,'Retail Sale Id 5942',800.80,0.00,0.00,1.04,125.84,'2023-02-08 15:59:00','',''),(5828,'1','306','1',1,'Retail Sale Id 5943',1501.50,0.00,0.00,1.95,235.95,'2023-02-08 16:00:00','',''),(5829,'1','306','1',1,'Retail Sale Id 5944',2310.00,0.00,0.00,3.00,363.00,'2023-02-08 16:06:38','',''),(5830,'1','306','1',1,'Retail Sale Id 5945',3850.00,0.00,0.00,5.00,605.00,'2023-02-08 16:09:12','',''),(5831,'1','306','1',1,'Retail Sale Id 5946',3850.00,0.00,0.00,5.00,605.00,'2023-02-08 16:15:57','',''),(5832,'1','306','1',1,'Return of Retail Sale Id 5940',0.00,3103.10,4.03,0.00,-487.63,'2023-02-08 16:17:30','',''),(5833,'1','306','1',1,'Retail Sale Id 5947',800.80,0.00,0.00,1.04,125.84,'2023-02-08 16:19:38','',''),(5834,'1','306','1',1,'Retail Sale Id 5948',2502.50,0.00,0.00,3.25,393.25,'2023-02-08 16:29:00','',''),(5835,'1','306','1',1,'Retail Sale Id 5949',1547.70,0.00,0.00,2.01,243.21,'2023-02-08 16:31:16','',''),(5836,'1','306','1',1,'Retail Sale Id 5950',3080.00,0.00,0.00,4.00,484.00,'2023-02-08 16:36:29','',''),(5837,'1','306','1',1,'Retail Sale Id 5951',4620.00,0.00,0.00,6.00,726.00,'2023-02-08 16:40:25','',''),(5838,'1','306','1',1,'Retail Sale Id 5952',3080.00,0.00,0.00,4.00,484.00,'2023-02-08 16:41:48','',''),(5839,'1','306','1',1,'Retail Sale Id 5953',3850.00,0.00,0.00,5.00,605.00,'2023-02-08 16:44:48','',''),(5840,'1','306','1',1,'Retail Sale Id 5954',770.00,0.00,0.00,1.00,121.00,'2023-02-08 16:46:22','',''),(5841,'1','306','1',1,'Retail Sale Id 5955',3080.00,0.00,0.00,4.00,484.00,'2023-02-08 16:48:49','',''),(5842,'1','306','1',1,'Retail Sale Id 5956',4620.00,0.00,0.00,6.00,726.00,'2023-02-08 16:51:03','',''),(5843,'1','306','1',1,'Retail Sale Id 5957',4620.00,0.00,0.00,6.00,726.00,'2023-02-08 16:53:20','',''),(5844,'1','306','1',1,'Retail Sale Id 5958',2310.00,0.00,0.00,3.00,363.00,'2023-02-08 16:55:57','',''),(5845,'1','306','1',1,'Return of Retail Sale Id 5958',0.00,2310.00,3.00,0.00,-363.00,'2023-02-08 17:21:29','',''),(5846,'1','306','1',1,'Retail Sale Id 5959',2864.40,0.00,0.00,3.72,450.12,'2023-02-08 17:23:19','',''),(5847,'1','306','1',1,'Distributed to SANI  GAS for sales id:4',71195.30,0.00,0.00,109.70,0.00,'2023-02-08 17:35:57','',''),(5848,'1','306',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,3115200.00,4800.00,0.00,0.00,'2023-02-08 19:01:33','',''),(5849,'1','306',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,4800.00,0.00,'2023-02-08 19:02:38','',''),(5850,'1','306','1',1,'Received from bridging 14',0.00,0.00,4800.00,0.00,0.00,'2023-02-08 19:02:38','',''),(5851,'1','306','1',1,'Retail Sale Id 5960',3997.60,0.00,0.00,5.26,583.86,'2023-02-09 07:28:20','',''),(5852,'1','306','1',1,'Retail Sale Id 5961',9500.00,0.00,0.00,12.50,1387.50,'2023-02-09 07:29:57','',''),(5853,'1','306','1',1,'Retail Sale Id 5964',3800.00,0.00,0.00,5.00,555.00,'2023-02-09 07:33:07','',''),(5854,'1','306','1',1,'Retail Sale Id 5965',7600.00,0.00,0.00,10.00,1110.00,'2023-02-09 07:35:34','',''),(5855,'1','306','1',1,'Retail Sale Id 5966',3040.00,0.00,0.00,4.00,444.00,'2023-02-09 07:36:47','',''),(5856,'1','306','1',1,'Retail Sale Id 5967',2280.00,0.00,0.00,3.00,333.00,'2023-02-09 07:43:19','',''),(5857,'1','306','1',1,'Retail Sale Id 5969',1003.20,0.00,0.00,1.32,146.52,'2023-02-09 07:47:18','',''),(5858,'1','306','1',1,'Retail Sale Id 5970',1497.20,0.00,0.00,1.97,218.67,'2023-02-09 07:50:00','',''),(5859,'1','306','1',1,'Retail Sale Id 5971',4560.00,0.00,0.00,6.00,666.00,'2023-02-09 07:59:38','',''),(5860,'1','306','1',1,'Retail Sale Id 5972',3040.00,0.00,0.00,4.00,444.00,'2023-02-09 08:00:52','',''),(5861,'1','306','1',1,'Retail Sale Id 5973',3040.00,0.00,0.00,4.00,444.00,'2023-02-09 08:06:01','',''),(5862,'1','306','1',1,'Retail Sale Id 5974',3002.00,0.00,0.00,3.95,438.45,'2023-02-09 08:11:55','',''),(5863,'1','306','1',1,'Retail Sale Id 5975',4560.00,0.00,0.00,6.00,666.00,'2023-02-09 08:16:30','',''),(5864,'1','306','1',1,'Retail Sale Id 5976',3420.00,0.00,0.00,4.50,499.50,'2023-02-09 08:20:39','',''),(5865,'1','306','1',1,'Retail Sale Id 5978',2302.80,0.00,0.00,3.03,336.33,'2023-02-09 08:23:55','',''),(5866,'1','306','1',1,'Retail Sale Id 5979',3800.00,0.00,0.00,5.00,555.00,'2023-02-09 08:27:40','',''),(5867,'1','306','1',1,'Retail Sale Id 5980',2280.00,0.00,0.00,3.00,333.00,'2023-02-09 08:29:36','',''),(5868,'1','306','1',1,'Retail Sale Id 5982',2500.40,0.00,0.00,3.29,365.19,'2023-02-09 08:32:03','',''),(5869,'1','306','1',1,'Retail Sale Id 5983',3800.00,0.00,0.00,5.00,555.00,'2023-02-09 08:33:35','',''),(5870,'1','306','1',1,'Retail Sale Id 5984',5000.80,0.00,0.00,6.58,730.38,'2023-02-09 08:35:12','',''),(5871,'1','306','1',1,'Retail Sale Id 5987',3040.00,0.00,0.00,4.00,444.00,'2023-02-09 08:46:39','',''),(5872,'1','306','1',1,'Retail Sale Id 5989',3800.00,0.00,0.00,5.00,555.00,'2023-02-09 08:49:50','',''),(5873,'1','306','1',1,'Retail Sale Id 5990',3800.00,0.00,0.00,5.00,555.00,'2023-02-09 08:55:16','',''),(5874,'1','306','1',1,'Retail Sale Id 5991',3503.60,0.00,0.00,4.61,511.71,'2023-02-09 08:58:08','',''),(5875,'1','306','1',1,'Retail Sale Id 5992',9500.00,0.00,0.00,12.50,1387.50,'2023-02-09 09:01:18','',''),(5876,'1','306','1',1,'Retail Sale Id 5993',14400.00,0.00,0.00,20.00,1420.00,'2023-02-09 09:02:46','',''),(5877,'1','306','1',1,'Retail Sale Id 5994',9500.00,0.00,0.00,12.50,1387.50,'2023-02-09 09:06:53','',''),(5878,'1','306','1',1,'Retail Sale Id 5995',2280.00,0.00,0.00,3.00,333.00,'2023-02-09 09:07:37','',''),(5879,'1','306','1',1,'Retail Sale Id 5997',1497.20,0.00,0.00,1.97,218.67,'2023-02-09 09:12:48','',''),(5880,'1','306','1',1,'Retail Sale Id 5998',11520.00,0.00,0.00,16.00,1136.00,'2023-02-09 09:14:29','',''),(5881,'1','306','1',1,'Retail Sale Id 5999',2280.00,0.00,0.00,3.00,333.00,'2023-02-09 09:16:19','',''),(5882,'1','306','1',1,'Retail Sale Id 6000',1520.00,0.00,0.00,2.00,222.00,'2023-02-09 09:17:05','',''),(5883,'1','306','1',1,'Retail Sale Id 6001',3040.00,0.00,0.00,4.00,444.00,'2023-02-09 09:19:31','',''),(5884,'1','306','1',1,'Retail Sale Id 6001',3040.00,0.00,0.00,4.00,444.00,'2023-02-09 09:19:31','',''),(5885,'1','306','1',1,'Retail Sale Id 6002',3040.00,0.00,0.00,4.00,444.00,'2023-02-09 09:21:40','',''),(5886,'1','306','1',1,'Retail Sale Id 6003',1527.60,0.00,0.00,2.01,223.11,'2023-02-09 09:25:46','',''),(5887,'1','306','1',1,'Retail Sale Id 6004',896.80,0.00,0.00,1.18,130.98,'2023-02-09 09:26:59','',''),(5888,'1','306','1',1,'Retail Sale Id 6005',4560.00,0.00,0.00,6.00,666.00,'2023-02-09 09:31:37','',''),(5889,'1','306','1',1,'Retail Sale Id 6006',2280.00,0.00,0.00,3.00,333.00,'2023-02-09 09:34:37','',''),(5890,'1','306','1',1,'Retail Sale Id 6007',3040.00,0.00,0.00,4.00,444.00,'2023-02-09 09:41:26','',''),(5891,'1','306','1',1,'Retail Sale Id 6008',4560.00,0.00,0.00,6.00,666.00,'2023-02-09 09:44:06','',''),(5892,'1','306','1',1,'Retail Sale Id 6009',9000.00,0.00,0.00,12.50,887.50,'2023-02-09 09:45:48','',''),(5893,'1','306','1',1,'Retail Sale Id 6010',165600.00,0.00,0.00,230.00,16330.00,'2023-02-09 09:47:01','',''),(5894,'1','306','1',1,'Retail Sale Id 6011',4560.00,0.00,0.00,6.00,666.00,'2023-02-09 09:48:14','',''),(5895,'1','306','1',1,'Retail Sale Id 6012',1003.20,0.00,0.00,1.32,146.52,'2023-02-09 09:49:37','',''),(5896,'1','306','1',1,'Retail Sale Id 6012',4560.00,0.00,0.00,6.00,666.00,'2023-02-09 09:49:37','',''),(5897,'1','306','1',1,'Retail Sale Id 6013',5320.00,0.00,0.00,7.00,777.00,'2023-02-09 09:58:24','',''),(5898,'1','306','1',1,'Retail Sale Id 6014',3040.00,0.00,0.00,4.00,444.00,'2023-02-09 10:00:02','',''),(5899,'1','306','1',1,'Retail Sale Id 6015',7600.00,0.00,0.00,10.00,1110.00,'2023-02-09 10:01:03','',''),(5900,'1','306','1',1,'Return of Retail Sale Id 6012',0.00,1003.20,1.32,0.00,-146.52,'2023-02-09 10:09:52','',''),(5901,'1','306','1',1,'Return of Retail Sale Id 6012',0.00,4560.00,6.00,0.00,-666.00,'2023-02-09 10:09:52','',''),(5902,'1','306','1',1,'Retail Sale Id 6016',9500.00,0.00,0.00,12.50,1387.50,'2023-02-09 10:17:14','',''),(5903,'1','306','1',1,'Retail Sale Id 6017',3351.60,0.00,0.00,4.41,489.51,'2023-02-09 10:19:10','',''),(5904,'1','306','1',1,'Retail Sale Id 6018',1497.20,0.00,0.00,1.97,218.67,'2023-02-09 10:21:02','',''),(5905,'1','306','1',1,'Retail Sale Id 6018',3800.00,0.00,0.00,5.00,555.00,'2023-02-09 10:21:02','',''),(5906,'1','306','1',1,'Retail Sale Id 6019',760.00,0.00,0.00,1.00,111.00,'2023-02-09 10:30:07','',''),(5907,'1','306','1',1,'Retail Sale Id 6020',4560.00,0.00,0.00,6.00,666.00,'2023-02-09 10:34:06','',''),(5908,'1','306','1',1,'Retail Sale Id 6021',9500.00,0.00,0.00,12.50,1387.50,'2023-02-09 10:40:30','',''),(5909,'1','306','1',1,'Retail Sale Id 6022',3040.00,0.00,0.00,4.00,444.00,'2023-02-09 10:43:16','',''),(5910,'1','306','1',1,'Retail Sale Id 6023',1550.40,0.00,0.00,2.04,226.44,'2023-02-09 10:45:00','',''),(5911,'1','306','1',1,'Retail Sale Id 6024',4560.00,0.00,0.00,6.00,666.00,'2023-02-09 10:47:48','',''),(5912,'1','306','1',1,'Retail Sale Id 6025',2280.00,0.00,0.00,3.00,333.00,'2023-02-09 10:49:02','',''),(5913,'1','306','1',1,'Retail Sale Id 6026',2280.00,0.00,0.00,3.00,333.00,'2023-02-09 11:02:15','',''),(5914,'1','306','1',1,'Retail Sale Id 6027',9500.00,0.00,0.00,12.50,1387.50,'2023-02-09 11:03:33','',''),(5915,'1','306','1',1,'Retail Sale Id 6028',3040.00,0.00,0.00,4.00,444.00,'2023-02-09 11:06:13','',''),(5916,'1','306','1',1,'Retail Sale Id 6029',18000.00,0.00,0.00,25.00,1775.00,'2023-02-09 11:09:15','',''),(5917,'1','306','1',1,'Retail Sale Id 6030',3800.00,0.00,0.00,5.00,555.00,'2023-02-09 11:10:30','',''),(5918,'1','306','1',1,'Retail Sale Id 6031',2280.00,0.00,0.00,3.00,333.00,'2023-02-09 11:11:04','',''),(5919,'1','306','1',1,'Retail Sale Id 6032',2280.00,0.00,0.00,3.00,333.00,'2023-02-09 11:15:07','',''),(5920,'1','306','1',1,'Retail Sale Id 6034',3800.00,0.00,0.00,5.00,555.00,'2023-02-09 11:20:18','',''),(5921,'1','306','1',1,'Retail Sale Id 6035',1520.00,0.00,0.00,2.00,222.00,'2023-02-09 11:29:23','',''),(5922,'1','306','1',1,'Retail Sale Id 6036',5320.00,0.00,0.00,7.00,777.00,'2023-02-09 11:31:05','',''),(5923,'1','306','1',1,'Retail Sale Id 6037',5000.80,0.00,0.00,6.58,730.38,'2023-02-09 11:35:40','',''),(5924,'1','306','1',1,'Retail Sale Id 6038',3040.00,0.00,0.00,4.00,444.00,'2023-02-09 11:38:36','',''),(5925,'1','306','1',1,'Retail Sale Id 6039',2903.20,0.00,0.00,3.82,424.02,'2023-02-09 14:58:18','',''),(5926,'1','306','1',1,'Retail Sale Id 6040',2280.00,0.00,0.00,3.00,333.00,'2023-02-09 16:22:01','',''),(5927,'1','306','1',1,'Retail Sale Id 6042',4598.00,0.00,0.00,6.05,671.55,'2023-02-09 16:23:28','',''),(5928,'1','306','1',1,'Retail Sale Id 6043',1520.00,0.00,0.00,2.00,222.00,'2023-02-09 16:24:35','',''),(5929,'1','306','1',1,'Retail Sale Id 6044',1550.40,0.00,0.00,2.04,226.44,'2023-02-09 16:25:29','',''),(5930,'1','306','1',1,'Retail Sale Id 6045',9500.00,0.00,0.00,12.50,1387.50,'2023-02-09 16:26:43','',''),(5931,'1','306','1',1,'Retail Sale Id 6046',3040.00,0.00,0.00,4.00,444.00,'2023-02-09 16:27:31','',''),(5932,'1','306','1',1,'Retail Sale Id 6047',9500.00,0.00,0.00,12.50,1387.50,'2023-02-09 16:29:35','',''),(5933,'1','306','1',1,'Retail Sale Id 6049',2302.80,0.00,0.00,3.03,336.33,'2023-02-09 16:31:58','',''),(5934,'1','306','1',1,'Retail Sale Id 6050',32400.00,0.00,0.00,45.00,3195.00,'2023-02-09 16:32:55','',''),(5935,'1','306','1',1,'Retail Sale Id 6051',7600.00,0.00,0.00,10.00,1110.00,'2023-02-09 16:35:57','',''),(5936,'1','306','1',1,'Retail Sale Id 6052',1520.00,0.00,0.00,2.00,222.00,'2023-02-09 16:37:33','',''),(5937,'1','306','1',1,'Retail Sale Id 6053',1998.80,0.00,0.00,2.63,291.93,'2023-02-09 16:39:04','',''),(5938,'1','306','1',1,'Retail Sale Id 6054',9500.00,0.00,0.00,12.50,1387.50,'2023-02-09 16:40:29','',''),(5939,'1','306','1',1,'Retail Sale Id 6055',1520.00,0.00,0.00,2.00,222.00,'2023-02-09 16:46:24','',''),(5940,'1','306','1',1,'Retail Sale Id 6057',18000.00,0.00,0.00,25.00,1775.00,'2023-02-09 16:50:53','',''),(5941,'1','306','1',1,'Retail Sale Id 6058',1398.40,0.00,0.00,1.84,204.24,'2023-02-09 16:52:01','',''),(5942,'1','306','1',1,'Retail Sale Id 6059',2280.00,0.00,0.00,3.00,333.00,'2023-02-09 16:53:18','',''),(5943,'1','306','1',1,'Retail Sale Id 6060',3800.00,0.00,0.00,5.00,555.00,'2023-02-09 16:57:29','',''),(5944,'1','306','1',1,'Retail Sale Id 6061',2280.00,0.00,0.00,3.00,333.00,'2023-02-09 16:59:11','',''),(5945,'1','306','1',1,'Retail Sale Id 6062',1497.20,0.00,0.00,1.97,218.67,'2023-02-09 17:02:14','',''),(5946,'1','306','1',1,'Retail Sale Id 6063',1550.40,0.00,0.00,2.04,226.44,'2023-02-09 17:03:14','',''),(5947,'1','306','1',1,'Retail Sale Id 6064',1998.80,0.00,0.00,2.63,291.93,'2023-02-09 17:04:40','',''),(5948,'1','306','1',1,'Retail Sale Id 6064',3002.00,0.00,0.00,3.95,438.45,'2023-02-09 17:04:40','',''),(5949,'1','306','1',1,'Retail Sale Id 6065',4560.00,0.00,0.00,6.00,666.00,'2023-02-09 17:10:17','',''),(5950,'1','306','1',1,'Return of Retail Sale Id 6050',0.00,32400.00,45.00,0.00,-3195.00,'2023-02-09 17:15:15','',''),(5951,'1','306','1',1,'Retail Sale Id 6066',3800.00,0.00,0.00,5.00,555.00,'2023-02-09 17:18:24','',''),(5952,'1','306','1',1,'Retail Sale Id 6067',1520.00,0.00,0.00,2.00,222.00,'2023-02-09 17:19:33','',''),(5953,'1','306','1',1,'Retail Sale Id 6069',4560.00,0.00,0.00,6.00,666.00,'2023-02-09 17:21:48','',''),(5954,'1','306','1',1,'Retail Sale Id 6070',2280.00,0.00,0.00,3.00,333.00,'2023-02-09 17:23:10','',''),(5955,'1','306','1',1,'Retail Sale Id 6071',2280.00,0.00,0.00,3.00,333.00,'2023-02-09 17:25:48','',''),(5956,'1','306','1',1,'Retail Sale Id 6073',2302.80,0.00,0.00,3.03,336.33,'2023-02-09 17:26:54','',''),(5957,'1','306','1',1,'Retail Sale Id 6075',1603.60,0.00,0.00,2.11,234.21,'2023-02-09 17:29:08','',''),(5958,'1','306','1',1,'Retail Sale Id 6076',3800.00,0.00,0.00,5.00,555.00,'2023-02-09 17:30:18','',''),(5959,'1','306','1',1,'Retail Sale Id 6077',798.00,0.00,0.00,1.05,116.55,'2023-02-09 17:31:18','',''),(5960,'1','306','1',1,'Retail Sale Id 6079',2302.80,0.00,0.00,3.03,336.33,'2023-02-09 17:32:23','',''),(5961,'1','306','1',1,'Retail Sale Id 6080',4560.00,0.00,0.00,6.00,666.00,'2023-02-09 17:33:24','',''),(5962,'1','306','1',1,'Retail Sale Id 6082',798.00,0.00,0.00,1.05,116.55,'2023-02-09 17:45:57','',''),(5963,'1','306','1',1,'Retail Sale Id 6083',3800.00,0.00,0.00,5.00,555.00,'2023-02-09 17:47:39','',''),(5964,'1','306','1',1,'Retail Sale Id 6084',1550.40,0.00,0.00,2.04,226.44,'2023-02-09 17:48:43','',''),(5965,'1','306','1',1,'Retail Sale Id 6085',4560.00,0.00,0.00,6.00,666.00,'2023-02-09 17:52:30','',''),(5966,'1','306','1',1,'Retail Sale Id 6086',3800.00,0.00,0.00,5.00,555.00,'2023-02-09 18:00:20','',''),(5967,'1','306','1',1,'Retail Sale Id 6087',3800.00,0.00,0.00,5.00,555.00,'2023-02-09 18:01:00','',''),(5968,'1','306','1',1,'Retail Sale Id 6088',2280.00,0.00,0.00,3.00,333.00,'2023-02-09 18:01:26','',''),(5969,'1','306','1',1,'Retail Sale Id 6089',1003.20,0.00,0.00,1.32,146.52,'2023-02-09 18:03:37','',''),(5970,'1','306','1',1,'Retail Sale Id 6090',2280.00,0.00,0.00,3.00,333.00,'2023-02-09 18:04:36','',''),(5971,'1','306','1',1,'Retail Sale Id 6091',798.00,0.00,0.00,1.05,116.55,'2023-02-09 18:08:21','',''),(5972,'1','306','1',1,'Retail Sale Id 6092',1998.80,0.00,0.00,2.63,291.93,'2023-02-09 18:11:02','',''),(5973,'1','306','1',1,'Retail Sale Id 6093',4560.00,0.00,0.00,6.00,666.00,'2023-02-09 18:14:04','',''),(5974,'1','306','1',1,'Retail Sale Id 6094',3800.00,0.00,0.00,5.00,555.00,'2023-02-09 18:18:09','',''),(5975,'1','306','1',1,'Retail Sale Id 6095',752.40,0.00,0.00,0.99,109.89,'2023-02-09 18:18:52','',''),(5976,'1','306','1',1,'Retail Sale Id 6097',3800.00,0.00,0.00,5.00,555.00,'2023-02-09 18:24:13','',''),(5977,'1','306','1',1,'Retail Sale Id 6098',2280.00,0.00,0.00,3.00,333.00,'2023-02-09 18:25:43','',''),(5978,'1','306','1',1,'Retail Sale Id 6099',3800.00,0.00,0.00,5.00,555.00,'2023-02-09 18:26:30','',''),(5979,'1','306','1',1,'Retail Sale Id 6100',2280.00,0.00,0.00,3.00,333.00,'2023-02-09 18:30:54','',''),(5980,'1','306','1',1,'Retail Sale Id 6101',9500.00,0.00,0.00,12.50,1387.50,'2023-02-09 18:35:26','',''),(5981,'1','306','1',1,'Retail Sale Id 6102',3040.00,0.00,0.00,4.00,444.00,'2023-02-09 18:39:03','',''),(5982,'1','306','1',1,'Retail Sale Id 6103',4560.00,0.00,0.00,6.00,666.00,'2023-02-09 18:40:36','',''),(5983,'1','306','1',1,'Retail Sale Id 6104',2280.00,0.00,0.00,3.00,333.00,'2023-02-09 18:41:53','',''),(5984,'1','306','1',1,'Retail Sale Id 6105',5000.80,0.00,0.00,6.58,730.38,'2023-02-09 18:45:08','',''),(5985,'1','306','1',1,'Return of Retail Sale Id 6009',0.00,9000.00,12.50,0.00,-887.50,'2023-02-09 18:58:17','',''),(5986,'1','306','1',1,'Retail Sale Id 6106',9007.20,0.00,0.00,12.51,888.21,'2023-02-09 18:59:38','',''),(5987,'1','306','1',1,'Retail Sale Id 6107',13307.60,0.00,0.00,17.51,1943.61,'2023-02-09 19:00:57','',''),(5988,'1','306','1',1,'Retail Sale Id 6108',1003.20,0.00,0.00,1.32,146.52,'2023-02-10 07:33:34','',''),(5989,'1','306','1',1,'Retail Sale Id 6110',4202.80,0.00,0.00,5.53,613.83,'2023-02-10 07:58:56','',''),(5990,'1','306','1',1,'Retail Sale Id 6111',9500.00,0.00,0.00,12.50,1387.50,'2023-02-10 08:00:33','',''),(5991,'1','306','1',1,'Retail Sale Id 6112',9500.00,0.00,0.00,12.50,1387.50,'2023-02-10 08:07:38','',''),(5992,'1','306','1',1,'Retail Sale Id 6113',6080.00,0.00,0.00,8.00,888.00,'2023-02-10 08:11:16','',''),(5993,'1','306','1',1,'Retail Sale Id 6114',7600.00,0.00,0.00,10.00,1110.00,'2023-02-10 08:16:16','',''),(5994,'1','306','1',1,'Retail Sale Id 6115',2196.40,0.00,0.00,2.89,320.79,'2023-02-10 08:18:02','',''),(5995,'1','306','1',1,'Retail Sale Id 6116',1497.20,0.00,0.00,1.97,218.67,'2023-02-10 08:24:52','',''),(5996,'1','306','1',1,'Retail Sale Id 6118',3800.00,0.00,0.00,5.00,555.00,'2023-02-10 08:26:57','',''),(5997,'1','306','1',1,'Retail Sale Id 6120',4560.00,0.00,0.00,6.00,666.00,'2023-02-10 08:35:44','',''),(5998,'1','306','1',1,'Retail Sale Id 6120',4560.00,0.00,0.00,6.00,666.00,'2023-02-10 08:35:44','',''),(5999,'1','306','1',1,'Retail Sale Id 6121',7600.00,0.00,0.00,10.00,1110.00,'2023-02-10 08:40:46','',''),(6000,'1','306','1',1,'Retail Sale Id 6122',1998.80,0.00,0.00,2.63,291.93,'2023-02-10 08:42:03','',''),(6001,'1','306','1',1,'Retail Sale Id 6123',9500.00,0.00,0.00,12.50,1387.50,'2023-02-10 08:43:26','',''),(6002,'1','306','1',1,'Retail Sale Id 6124',3800.00,0.00,0.00,5.00,555.00,'2023-02-10 08:45:13','',''),(6003,'1','306','1',1,'Retail Sale Id 6125',1520.00,0.00,0.00,2.00,222.00,'2023-02-10 08:53:50','',''),(6004,'1','306','1',1,'Retail Sale Id 6126',1003.20,0.00,0.00,1.32,146.52,'2023-02-10 08:54:46','',''),(6005,'1','306','1',1,'Retail Sale Id 6128',2880.40,0.00,0.00,3.79,420.69,'2023-02-10 08:56:25','',''),(6006,'1','306','1',1,'Retail Sale Id 6129',3800.00,0.00,0.00,5.00,555.00,'2023-02-10 08:57:35','',''),(6007,'1','306','1',1,'Retail Sale Id 6130',1497.20,0.00,0.00,1.97,218.67,'2023-02-10 08:58:57','',''),(6008,'1','306','1',1,'Retail Sale Id 6131',1003.20,0.00,0.00,1.32,146.52,'2023-02-10 09:00:30','',''),(6009,'1','306','1',1,'Retail Sale Id 6132',2500.40,0.00,0.00,3.29,365.19,'2023-02-10 09:02:39','',''),(6010,'1','306','1',1,'Retail Sale Id 6132',2500.40,0.00,0.00,3.29,365.19,'2023-02-10 09:02:39','',''),(6011,'1','306','1',1,'Retail Sale Id 6133',927.20,0.00,0.00,1.22,135.42,'2023-02-10 10:28:49','',''),(6012,'1','306','1',1,'Return of Retail Sale Id 6125',0.00,1520.00,2.00,0.00,-222.00,'2023-02-10 10:29:50','',''),(6013,'1','306','1',1,'Retail Sale Id 6134',1998.80,0.00,0.00,2.63,291.93,'2023-02-10 17:04:17','',''),(6014,'1','306','1',1,'Retail Sale Id 6135',4560.00,0.00,0.00,6.00,666.00,'2023-02-10 17:06:45','',''),(6015,'1','306','1',1,'Retail Sale Id 6136',3040.00,0.00,0.00,4.00,444.00,'2023-02-10 17:08:02','',''),(6016,'1','306','1',1,'Retail Sale Id 6137',3800.00,0.00,0.00,5.00,555.00,'2023-02-10 17:09:29','',''),(6017,'1','306','1',1,'Retail Sale Id 6137',4560.00,0.00,0.00,6.00,666.00,'2023-02-10 17:09:29','',''),(6018,'1','306','1',1,'Retail Sale Id 6138',3800.00,0.00,0.00,5.00,555.00,'2023-02-10 17:10:49','',''),(6019,'1','306','1',1,'Retail Sale Id 6139',1998.80,0.00,0.00,2.63,291.93,'2023-02-10 17:11:22','',''),(6020,'1','306','1',1,'Retail Sale Id 6141',2280.00,0.00,0.00,3.00,333.00,'2023-02-10 17:26:35','',''),(6021,'1','306','1',1,'Retail Sale Id 6142',4560.00,0.00,0.00,6.00,666.00,'2023-02-10 17:31:27','',''),(6022,'1','306','1',1,'Retail Sale Id 6143',2280.00,0.00,0.00,3.00,333.00,'2023-02-10 17:33:01','',''),(6023,'1','306','1',1,'Retail Sale Id 6144',1520.00,0.00,0.00,2.00,222.00,'2023-02-10 17:36:58','',''),(6024,'1','306','1',1,'Retail Sale Id 6146',3800.00,0.00,0.00,5.00,555.00,'2023-02-10 18:02:27','',''),(6025,'1','306','1',1,'Retail Sale Id 6147',1003.20,0.00,0.00,1.32,146.52,'2023-02-10 18:09:13','',''),(6026,'1','306','1',1,'Retail Sale Id 6148',1003.20,0.00,0.00,1.32,146.52,'2023-02-10 18:19:27','',''),(6027,'1','306','1',1,'Return of Retail Sale Id 6136',0.00,3040.00,4.00,0.00,-444.00,'2023-02-10 18:20:31','',''),(6028,'1','306','1',1,'Retail Sale Id 6149',3002.00,0.00,0.00,3.95,438.45,'2023-02-10 18:25:28','',''),(6029,'1','306','1',1,'Return of Retail Sale Id 6142',0.00,4560.00,6.00,0.00,-666.00,'2023-02-10 18:48:31','',''),(6030,'1','306','1',1,'Return of Retail Sale Id 6137',0.00,3800.00,5.00,0.00,-555.00,'2023-02-10 18:49:03','',''),(6031,'1','306','1',1,'Return of Retail Sale Id 6137',0.00,4560.00,6.00,0.00,-666.00,'2023-02-10 18:49:03','',''),(6032,'1','306','1',1,'Return of Retail Sale Id 6141',0.00,2280.00,3.00,0.00,-333.00,'2023-02-10 18:49:32','',''),(6033,'1','306','1',1,'Retail Sale Id 6150',2325.60,0.00,0.00,3.06,339.66,'2023-02-10 18:59:13','',''),(6034,'1','306','1',1,'Retail Sale Id 6151',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 07:34:45','',''),(6035,'1','306','1',1,'Retail Sale Id 6152',760.00,0.00,0.00,1.00,111.00,'2023-02-11 07:36:10','',''),(6036,'1','306','1',1,'Retail Sale Id 6153',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 07:37:44','',''),(6037,'1','306','1',1,'Retail Sale Id 6154',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 07:38:53','',''),(6038,'1','306','1',1,'Retail Sale Id 6155',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 07:43:53','',''),(6039,'1','306','1',1,'Retail Sale Id 6156',798.00,0.00,0.00,1.05,116.55,'2023-02-11 07:45:00','',''),(6040,'1','306','1',1,'Retail Sale Id 6157',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 07:48:06','',''),(6041,'1','306','1',1,'Retail Sale Id 6158',1497.20,0.00,0.00,1.97,218.67,'2023-02-11 07:49:13','',''),(6042,'1','306','1',1,'Retail Sale Id 6159',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 08:02:00','',''),(6043,'1','306','1',1,'Retail Sale Id 6160',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 08:14:54','',''),(6044,'1','306','1',1,'Retail Sale Id 6161',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 08:18:45','',''),(6045,'1','306','1',1,'Retail Sale Id 6162',1003.20,0.00,0.00,1.32,146.52,'2023-02-11 08:19:38','',''),(6046,'1','306','1',1,'Retail Sale Id 6163',1998.80,0.00,0.00,2.63,291.93,'2023-02-11 08:23:23','',''),(6047,'1','306','1',1,'Retail Sale Id 6164',1497.20,0.00,0.00,1.97,218.67,'2023-02-11 08:24:01','',''),(6048,'1','306','1',1,'Retail Sale Id 6165',7600.00,0.00,0.00,10.00,1110.00,'2023-02-11 08:25:30','',''),(6049,'1','306','1',1,'Retail Sale Id 6166',5320.00,0.00,0.00,7.00,777.00,'2023-02-11 08:31:09','',''),(6050,'1','306','1',1,'Retail Sale Id 6167',9500.00,0.00,0.00,12.50,1387.50,'2023-02-11 08:34:02','',''),(6051,'1','306','1',1,'Retail Sale Id 6169',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 08:35:54','',''),(6052,'1','306','1',1,'Retail Sale Id 6170',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 08:40:56','',''),(6053,'1','306','1',1,'Retail Sale Id 6172',9500.00,0.00,0.00,12.50,1387.50,'2023-02-11 08:48:05','',''),(6054,'1','306','1',1,'Retail Sale Id 6172',9500.00,0.00,0.00,12.50,1387.50,'2023-02-11 08:48:05','',''),(6055,'1','306','1',1,'Retail Sale Id 6174',2249.60,0.00,0.00,2.96,328.56,'2023-02-11 08:54:24','',''),(6056,'1','306','1',1,'Retail Sale Id 6175',9500.00,0.00,0.00,12.50,1387.50,'2023-02-11 09:04:32','',''),(6057,'1','306','1',1,'Retail Sale Id 6177',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 09:09:36','',''),(6058,'1','306','1',1,'Retail Sale Id 6179',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 09:14:11','',''),(6059,'1','306','1',1,'Retail Sale Id 6180',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 09:16:03','',''),(6060,'1','306','1',1,'Retail Sale Id 6183',1998.80,0.00,0.00,2.63,291.93,'2023-02-11 09:22:04','',''),(6061,'1','306','1',1,'Retail Sale Id 6184',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 09:25:17','',''),(6062,'1','306','1',1,'Retail Sale Id 6184',9500.00,0.00,0.00,12.50,1387.50,'2023-02-11 09:25:17','',''),(6063,'1','306','1',1,'Retail Sale Id 6185',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 09:26:07','',''),(6064,'1','306','1',1,'Retail Sale Id 6186',1520.00,0.00,0.00,2.00,222.00,'2023-02-11 09:27:48','',''),(6065,'1','306','1',1,'Retail Sale Id 6187',2500.40,0.00,0.00,3.29,365.19,'2023-02-11 09:28:41','',''),(6066,'1','306','1',1,'Retail Sale Id 6188',1520.00,0.00,0.00,2.00,222.00,'2023-02-11 09:32:09','',''),(6067,'1','306','1',1,'Retail Sale Id 6190',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 09:34:25','',''),(6068,'1','306','1',1,'Retail Sale Id 6192',1520.00,0.00,0.00,2.00,222.00,'2023-02-11 09:37:19','',''),(6069,'1','306','1',1,'Retail Sale Id 6193',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 09:39:45','',''),(6070,'1','306','1',1,'Retail Sale Id 6194',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 09:41:43','',''),(6071,'1','306','1',1,'Retail Sale Id 6195',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 09:43:00','',''),(6072,'1','306','1',1,'Retail Sale Id 6196',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 09:43:50','',''),(6073,'1','306','1',1,'Retail Sale Id 6197',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 09:44:44','',''),(6074,'1','306','1',1,'Retail Sale Id 6199',1520.00,0.00,0.00,2.00,222.00,'2023-02-11 09:46:33','',''),(6075,'1','306','1',1,'Retail Sale Id 6200',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 09:49:46','',''),(6076,'1','306','1',1,'Retail Sale Id 6201',798.00,0.00,0.00,1.05,116.55,'2023-02-11 09:51:13','',''),(6077,'1','306','1',1,'Retail Sale Id 6202',9500.00,0.00,0.00,12.50,1387.50,'2023-02-11 09:56:40','',''),(6078,'1','306','1',1,'Retail Sale Id 6203',10412.00,0.00,0.00,13.70,1520.70,'2023-02-11 09:59:34','',''),(6079,'1','306','1',1,'Retail Sale Id 6204',1520.00,0.00,0.00,2.00,222.00,'2023-02-11 10:02:16','',''),(6080,'1','306','1',1,'Retail Sale Id 6205',54000.00,0.00,0.00,75.00,5325.00,'2023-02-11 10:06:59','',''),(6081,'1','306','1',1,'Retail Sale Id 6206',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 10:07:40','',''),(6082,'1','306','1',1,'Retail Sale Id 6207',1520.00,0.00,0.00,2.00,222.00,'2023-02-11 10:09:46','',''),(6083,'1','306','1',1,'Retail Sale Id 6208',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 10:13:35','',''),(6084,'1','306','1',1,'Retail Sale Id 6209',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 10:16:36','',''),(6085,'1','306','1',1,'Retail Sale Id 6210',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 10:21:26','',''),(6086,'1','306','1',1,'Retail Sale Id 6211',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 10:23:44','',''),(6087,'1','306','1',1,'Retail Sale Id 6212',760.00,0.00,0.00,1.00,111.00,'2023-02-11 10:28:57','',''),(6088,'1','306','1',1,'Retail Sale Id 6213',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 10:29:49','',''),(6089,'1','306','1',1,'Retail Sale Id 6214',9500.00,0.00,0.00,12.50,1387.50,'2023-02-11 10:38:32','',''),(6090,'1','306','1',1,'Retail Sale Id 6215',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 10:39:57','',''),(6091,'1','306','1',1,'Retail Sale Id 6216',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 10:41:05','',''),(6092,'1','306','1',1,'Retail Sale Id 6217',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 10:42:21','',''),(6093,'1','306','1',1,'Retail Sale Id 6218',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 10:43:36','',''),(6094,'1','306','1',1,'Retail Sale Id 6219',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 10:44:55','',''),(6095,'1','306','1',1,'Retail Sale Id 6220',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 10:47:08','',''),(6096,'1','306','1',1,'Retail Sale Id 6221',14400.00,0.00,0.00,20.00,1420.00,'2023-02-11 10:48:20','',''),(6097,'1','306','1',1,'Retail Sale Id 6222',7600.00,0.00,0.00,10.00,1110.00,'2023-02-11 10:51:11','',''),(6098,'1','306','1',1,'Retail Sale Id 6223',1520.00,0.00,0.00,2.00,222.00,'2023-02-11 10:52:50','',''),(6099,'1','306','1',1,'Retail Sale Id 6224',6080.00,0.00,0.00,8.00,888.00,'2023-02-11 10:54:05','',''),(6100,'1','306','1',1,'Retail Sale Id 6225',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 10:55:42','',''),(6101,'1','306','1',1,'Retail Sale Id 6226',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 10:56:43','',''),(6102,'1','306','1',1,'Retail Sale Id 6227',3002.00,0.00,0.00,3.95,438.45,'2023-02-11 10:58:02','',''),(6103,'1','306','1',1,'Retail Sale Id 6228',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 10:59:47','',''),(6104,'1','306','1',1,'Retail Sale Id 6229',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 11:01:44','',''),(6105,'1','306','1',1,'Retail Sale Id 6230',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 11:04:36','',''),(6106,'1','306','1',1,'Retail Sale Id 6231',1520.00,0.00,0.00,2.00,222.00,'2023-02-11 11:06:59','',''),(6107,'1','306','1',1,'Retail Sale Id 6232',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 11:08:12','',''),(6108,'1','306','1',1,'Retail Sale Id 6234',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 11:09:21','',''),(6109,'1','306','1',1,'Retail Sale Id 6235',760.00,0.00,0.00,1.00,111.00,'2023-02-11 11:10:13','',''),(6110,'1','306','1',1,'Retail Sale Id 6236',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 11:11:11','',''),(6111,'1','306','1',1,'Retail Sale Id 6237',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 11:13:26','',''),(6112,'1','306','1',1,'Retail Sale Id 6238',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 11:16:43','',''),(6113,'1','306','1',1,'Retail Sale Id 6239',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 11:18:01','',''),(6114,'1','306','1',1,'Retail Sale Id 6240',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 11:19:16','',''),(6115,'1','306','1',1,'Retail Sale Id 6241',2302.80,0.00,0.00,3.03,336.33,'2023-02-11 11:20:17','',''),(6116,'1','306','1',1,'Retail Sale Id 6242',2302.80,0.00,0.00,3.03,336.33,'2023-02-11 11:21:55','',''),(6117,'1','306','1',1,'Retail Sale Id 6243',798.00,0.00,0.00,1.05,116.55,'2023-02-11 11:30:12','',''),(6118,'1','306','1',1,'Retail Sale Id 6244',6080.00,0.00,0.00,8.00,888.00,'2023-02-11 11:35:32','',''),(6119,'1','306','1',1,'Retail Sale Id 6245',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 11:38:57','',''),(6120,'1','306','1',1,'Retail Sale Id 6246',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 11:40:22','',''),(6121,'1','306','1',1,'Retail Sale Id 6247',9500.00,0.00,0.00,12.50,1387.50,'2023-02-11 11:41:31','',''),(6122,'1','306','1',1,'Retail Sale Id 6248',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 11:43:05','',''),(6123,'1','306','1',1,'Retail Sale Id 6249',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 11:44:44','',''),(6124,'1','306','1',1,'Retail Sale Id 6251',1520.00,0.00,0.00,2.00,222.00,'2023-02-11 11:46:35','',''),(6125,'1','306','1',1,'Retail Sale Id 6252',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 11:47:59','',''),(6126,'1','306','1',1,'Retail Sale Id 6253',6840.00,0.00,0.00,9.00,999.00,'2023-02-11 11:49:01','',''),(6127,'1','306','1',1,'Retail Sale Id 6254',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 11:49:58','',''),(6128,'1','306','1',1,'Retail Sale Id 6255',4940.00,0.00,0.00,6.50,721.50,'2023-02-11 11:51:34','',''),(6129,'1','306','1',1,'Retail Sale Id 6256',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 11:54:12','',''),(6130,'1','306','1',1,'Retail Sale Id 6257',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 11:55:27','',''),(6131,'1','306','1',1,'Retail Sale Id 6258',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 11:59:51','',''),(6132,'1','306','1',1,'Retail Sale Id 6259',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 12:04:31','',''),(6133,'1','306','1',1,'Retail Sale Id 6260',798.00,0.00,0.00,1.05,116.55,'2023-02-11 12:05:22','',''),(6134,'1','306','1',1,'Return of Retail Sale Id 6255',0.00,4940.00,6.50,0.00,-721.50,'2023-02-11 12:07:59','',''),(6135,'1','306','1',1,'Retail Sale Id 6262',2500.40,0.00,0.00,3.29,365.19,'2023-02-11 12:09:09','',''),(6136,'1','306','1',1,'Retail Sale Id 6264',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 12:12:33','',''),(6137,'1','306','1',1,'Retail Sale Id 6264',7600.00,0.00,0.00,10.00,1110.00,'2023-02-11 12:12:33','',''),(6138,'1','306','1',1,'Retail Sale Id 6265',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 12:13:47','',''),(6139,'1','306','1',1,'Retail Sale Id 6266',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 12:14:51','',''),(6140,'1','306','1',1,'Retail Sale Id 6267',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 12:16:05','',''),(6141,'1','306','1',1,'Retail Sale Id 6268',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 12:23:23','',''),(6142,'1','306','1',1,'Retail Sale Id 6268',9500.00,0.00,0.00,12.50,1387.50,'2023-02-11 12:23:23','',''),(6143,'1','306','1',1,'Retail Sale Id 6269',9120.00,0.00,0.00,12.00,1332.00,'2023-02-11 12:27:15','',''),(6144,'1','306','1',1,'Retail Sale Id 6270',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 12:35:21','',''),(6145,'1','306','1',1,'Retail Sale Id 6271',3199.60,0.00,0.00,4.21,467.31,'2023-02-11 12:37:43','',''),(6146,'1','306','1',1,'Retail Sale Id 6272',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 12:39:05','',''),(6147,'1','306','1',1,'Retail Sale Id 6273',1520.00,0.00,0.00,2.00,222.00,'2023-02-11 12:40:34','',''),(6148,'1','306','1',1,'Retail Sale Id 6274',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 12:41:53','',''),(6149,'1','306','1',1,'Retail Sale Id 6275',5320.00,0.00,0.00,7.00,777.00,'2023-02-11 12:43:31','',''),(6150,'1','306','1',1,'Retail Sale Id 6276',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 12:45:23','',''),(6151,'1','306','1',1,'Retail Sale Id 6277',1998.80,0.00,0.00,2.63,291.93,'2023-02-11 12:47:31','',''),(6152,'1','306','1',1,'Retail Sale Id 6278',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 12:48:37','',''),(6153,'1','306','1',1,'Retail Sale Id 6279',9500.00,0.00,0.00,12.50,1387.50,'2023-02-11 12:49:36','',''),(6154,'1','306','1',1,'Retail Sale Id 6280',4180.00,0.00,0.00,5.50,610.50,'2023-02-11 12:52:09','',''),(6155,'1','306','1',1,'Return of Retail Sale Id 6280',0.00,4180.00,5.50,0.00,-610.50,'2023-02-11 12:52:23','',''),(6156,'1','306','1',1,'Retail Sale Id 6281',3002.00,0.00,0.00,3.95,438.45,'2023-02-11 12:52:49','',''),(6157,'1','306','1',1,'Retail Sale Id 6282',9500.00,0.00,0.00,12.50,1387.50,'2023-02-11 12:53:32','',''),(6158,'1','306','1',1,'Retail Sale Id 6283',7600.00,0.00,0.00,10.00,1110.00,'2023-02-11 12:54:11','',''),(6159,'1','306','1',1,'Retail Sale Id 6285',4598.00,0.00,0.00,6.05,671.55,'2023-02-11 12:55:50','',''),(6160,'1','306','1',1,'Retail Sale Id 6287',2500.40,0.00,0.00,3.29,365.19,'2023-02-11 13:02:38','',''),(6161,'1','306','1',1,'Retail Sale Id 6288',4180.00,0.00,0.00,5.50,610.50,'2023-02-11 13:04:35','',''),(6162,'1','306','1',1,'Retail Sale Id 6289',1520.00,0.00,0.00,2.00,222.00,'2023-02-11 13:06:23','',''),(6163,'1','306','1',1,'Retail Sale Id 6290',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 13:14:42','',''),(6164,'1','306','1',1,'Retail Sale Id 6291',1497.20,0.00,0.00,1.97,218.67,'2023-02-11 13:15:57','',''),(6165,'1','306','1',1,'Retail Sale Id 6292',1998.80,0.00,0.00,2.63,291.93,'2023-02-11 13:16:54','',''),(6166,'1','306','1',1,'Retail Sale Id 6293',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 13:19:15','',''),(6167,'1','306','1',1,'Retail Sale Id 6294',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 13:20:42','',''),(6168,'1','306','1',1,'Retail Sale Id 6295',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 13:21:37','',''),(6169,'1','306','1',1,'Retail Sale Id 6296',1003.20,0.00,0.00,1.32,146.52,'2023-02-11 13:22:20','',''),(6170,'1','306','1',1,'Retail Sale Id 6297',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 13:23:27','',''),(6171,'1','306','1',1,'Retail Sale Id 6298',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 13:25:23','',''),(6172,'1','306','1',1,'Retail Sale Id 6299',760.00,0.00,0.00,1.00,111.00,'2023-02-11 13:27:13','',''),(6173,'1','306','1',1,'Retail Sale Id 6300',798.00,0.00,0.00,1.05,116.55,'2023-02-11 13:28:26','',''),(6174,'1','306','1',1,'Retail Sale Id 6301',798.00,0.00,0.00,1.05,116.55,'2023-02-11 13:30:06','',''),(6175,'1','306','1',1,'Retail Sale Id 6303',798.00,0.00,0.00,1.05,116.55,'2023-02-11 13:36:56','',''),(6176,'1','306','1',1,'Retail Sale Id 6304',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 13:38:57','',''),(6177,'1','306','1',1,'Retail Sale Id 6305',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 13:58:27','',''),(6178,'1','306','1',1,'Retail Sale Id 6306',1520.00,0.00,0.00,2.00,222.00,'2023-02-11 14:00:27','',''),(6179,'1','306','1',1,'Retail Sale Id 6307',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 14:03:55','',''),(6180,'1','306','1',1,'Retail Sale Id 6308',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 14:11:13','',''),(6181,'1','306','1',1,'Retail Sale Id 6309',1003.20,0.00,0.00,1.32,146.52,'2023-02-11 14:14:26','',''),(6182,'1','306','1',1,'Retail Sale Id 6310',9500.00,0.00,0.00,12.50,1387.50,'2023-02-11 14:17:57','',''),(6183,'1','306','1',1,'Retail Sale Id 6311',1998.80,0.00,0.00,2.63,291.93,'2023-02-11 14:19:08','',''),(6184,'1','306','1',1,'Retail Sale Id 6312',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 14:24:21','',''),(6185,'1','306','1',1,'Retail Sale Id 6313',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 14:27:42','',''),(6186,'1','306','1',1,'Retail Sale Id 6314',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 14:30:02','',''),(6187,'1','306','1',1,'Retail Sale Id 6315',9500.00,0.00,0.00,12.50,1387.50,'2023-02-11 14:32:20','',''),(6188,'1','306','1',1,'Retail Sale Id 6316',1998.80,0.00,0.00,2.63,291.93,'2023-02-11 14:33:53','',''),(6189,'1','306','1',1,'Retail Sale Id 6317',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 14:38:11','',''),(6190,'1','306','1',1,'Retail Sale Id 6317',9500.00,0.00,0.00,12.50,1387.50,'2023-02-11 14:38:11','',''),(6191,'1','306','1',1,'Retail Sale Id 6318',3997.60,0.00,0.00,5.26,583.86,'2023-02-11 14:39:50','',''),(6192,'1','306','1',1,'Retail Sale Id 6320',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 14:40:42','',''),(6193,'1','306','1',1,'Retail Sale Id 6321',1998.80,0.00,0.00,2.63,291.93,'2023-02-11 14:41:18','',''),(6194,'1','306','1',1,'Retail Sale Id 6322',1003.20,0.00,0.00,1.32,146.52,'2023-02-11 14:44:30','',''),(6195,'1','306','1',1,'Retail Sale Id 6323',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 14:45:48','',''),(6196,'1','306','1',1,'Retail Sale Id 6324',5000.80,0.00,0.00,6.58,730.38,'2023-02-11 14:47:30','',''),(6197,'1','306','1',1,'Retail Sale Id 6325',1497.20,0.00,0.00,1.97,218.67,'2023-02-11 14:48:42','',''),(6198,'1','306','1',1,'Retail Sale Id 6326',9500.00,0.00,0.00,12.50,1387.50,'2023-02-11 14:49:44','',''),(6199,'1','306','1',1,'Retail Sale Id 6327',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 15:00:09','',''),(6200,'1','306','1',1,'Retail Sale Id 6328',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 15:01:08','',''),(6201,'1','306','1',1,'Retail Sale Id 6328',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 15:01:08','',''),(6202,'1','306','1',1,'Retail Sale Id 6329',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 15:12:41','',''),(6203,'1','306','1',1,'Retail Sale Id 6330',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 15:15:40','',''),(6204,'1','306','1',1,'Retail Sale Id 6331',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 15:17:02','',''),(6205,'1','306','1',1,'Retail Sale Id 6332',1497.20,0.00,0.00,1.97,218.67,'2023-02-11 15:24:07','',''),(6206,'1','306','1',1,'Retail Sale Id 6333',798.00,0.00,0.00,1.05,116.55,'2023-02-11 15:29:22','',''),(6207,'1','306','1',1,'Retail Sale Id 6334',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 15:31:02','',''),(6208,'1','306','1',1,'Retail Sale Id 6336',86400.00,0.00,0.00,120.00,8520.00,'2023-02-11 16:45:38','',''),(6209,'1','306','1',1,'Retail Sale Id 6337',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 17:26:29','',''),(6210,'1','306','1',1,'Retail Sale Id 6338',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 17:27:17','',''),(6211,'1','306','1',1,'Retail Sale Id 6339',1520.00,0.00,0.00,2.00,222.00,'2023-02-11 17:29:59','',''),(6212,'1','306','1',1,'Retail Sale Id 6340',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 17:31:00','',''),(6213,'1','306','1',1,'Retail Sale Id 6341',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 17:32:05','',''),(6214,'1','306','1',1,'Retail Sale Id 6342',1520.00,0.00,0.00,2.00,222.00,'2023-02-11 17:34:09','',''),(6215,'1','306','1',1,'Retail Sale Id 6343',2302.80,0.00,0.00,3.03,336.33,'2023-02-11 17:35:08','',''),(6216,'1','306','1',1,'Retail Sale Id 6344',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 17:36:09','',''),(6217,'1','306','1',1,'Retail Sale Id 6345',3047.60,0.00,0.00,4.01,445.11,'2023-02-11 17:38:00','',''),(6218,'1','306','1',1,'Retail Sale Id 6346',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 17:40:02','',''),(6219,'1','306','1',1,'Retail Sale Id 6347',798.00,0.00,0.00,1.05,116.55,'2023-02-11 17:41:07','',''),(6220,'1','306','1',1,'Retail Sale Id 6348',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 17:42:19','',''),(6221,'1','306','1',1,'Retail Sale Id 6349',9120.00,0.00,0.00,12.00,1332.00,'2023-02-11 17:43:13','',''),(6222,'1','306','1',1,'Retail Sale Id 6350',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 17:44:05','',''),(6223,'1','306','1',1,'Retail Sale Id 6351',7698.80,0.00,0.00,10.13,1124.43,'2023-02-11 17:45:12','',''),(6224,'1','306','1',1,'Retail Sale Id 6352',9500.00,0.00,0.00,12.50,1387.50,'2023-02-11 17:46:09','',''),(6225,'1','306','1',1,'Retail Sale Id 6353',9500.00,0.00,0.00,12.50,1387.50,'2023-02-11 17:48:24','',''),(6226,'1','306','1',1,'Retail Sale Id 6354',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 17:49:01','',''),(6227,'1','306','1',1,'Retail Sale Id 6355',2302.80,0.00,0.00,3.03,336.33,'2023-02-11 17:49:53','',''),(6228,'1','306','1',1,'Retail Sale Id 6356',5320.00,0.00,0.00,7.00,777.00,'2023-02-11 17:51:13','',''),(6229,'1','306','1',1,'Retail Sale Id 6357',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 17:53:16','',''),(6230,'1','306','1',1,'Retail Sale Id 6357',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 17:53:16','',''),(6231,'1','306','1',1,'Retail Sale Id 6358',9500.00,0.00,0.00,12.50,1387.50,'2023-02-11 17:54:17','',''),(6232,'1','306','1',1,'Retail Sale Id 6359',2302.80,0.00,0.00,3.03,336.33,'2023-02-11 17:55:14','',''),(6233,'1','306','1',1,'Retail Sale Id 6360',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 17:56:06','',''),(6234,'1','306','1',1,'Retail Sale Id 6361',1003.20,0.00,0.00,1.32,146.52,'2023-02-11 17:57:56','',''),(6235,'1','306','1',1,'Retail Sale Id 6362',9500.00,0.00,0.00,12.50,1387.50,'2023-02-11 17:58:54','',''),(6236,'1','306','1',1,'Retail Sale Id 6364',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 18:00:57','',''),(6237,'1','306','1',1,'Retail Sale Id 6365',2500.40,0.00,0.00,3.29,365.19,'2023-02-11 18:02:00','',''),(6238,'1','306','1',1,'Retail Sale Id 6367',3100.80,0.00,0.00,4.08,452.88,'2023-02-11 18:03:56','',''),(6239,'1','306','1',1,'Retail Sale Id 6369',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 18:06:26','',''),(6240,'1','306','1',1,'Retail Sale Id 6370',4560.00,0.00,0.00,6.00,666.00,'2023-02-11 18:08:23','',''),(6241,'1','306','1',1,'Retail Sale Id 6371',1003.20,0.00,0.00,1.32,146.52,'2023-02-11 18:17:53','',''),(6242,'1','306','1',1,'Retail Sale Id 6372',2280.00,0.00,0.00,3.00,333.00,'2023-02-11 18:27:35','',''),(6243,'1','306','1',1,'Retail Sale Id 6374',3800.00,0.00,0.00,5.00,555.00,'2023-02-11 18:33:31','',''),(6244,'1','306','1',1,'Retail Sale Id 6376',1520.00,0.00,0.00,2.00,222.00,'2023-02-11 18:35:45','',''),(6245,'1','306','1',1,'Retail Sale Id 6377',3040.00,0.00,0.00,4.00,444.00,'2023-02-11 18:37:03','',''),(6246,'1','306','1',1,'Retail Sale Id 6378',7524.00,0.00,0.00,9.90,1098.90,'2023-02-11 18:47:43','',''),(6247,'1','306','1',1,'Retail Sale Id 6379',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 07:35:52','',''),(6248,'1','306','1',1,'Retail Sale Id 6380',1998.80,0.00,0.00,2.63,291.93,'2023-02-12 07:37:48','',''),(6249,'1','306','1',1,'Retail Sale Id 6381',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 07:38:29','',''),(6250,'1','306','1',1,'Retail Sale Id 6382',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 07:55:16','',''),(6251,'1','306','1',1,'Retail Sale Id 6383',4598.00,0.00,0.00,6.05,671.55,'2023-02-12 08:00:00','',''),(6252,'1','306','1',1,'Retail Sale Id 6384',12960.00,0.00,0.00,18.00,1278.00,'2023-02-12 08:12:20','',''),(6253,'1','306','1',1,'Retail Sale Id 6385',1003.20,0.00,0.00,1.32,146.52,'2023-02-12 08:12:55','',''),(6254,'1','306','1',1,'Retail Sale Id 6386',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 08:15:32','',''),(6255,'1','306','1',1,'Retail Sale Id 6388',1497.20,0.00,0.00,1.97,218.67,'2023-02-12 08:17:06','',''),(6256,'1','306','1',1,'Retail Sale Id 6389',3800.00,0.00,0.00,5.00,555.00,'2023-02-12 08:36:17','',''),(6257,'1','306','1',1,'Retail Sale Id 6390',2520.00,0.00,0.00,3.50,248.50,'2023-02-12 08:38:59','',''),(6258,'1','306','1',1,'Retail Sale Id 6391',38000.00,0.00,0.00,50.00,5550.00,'2023-02-12 08:48:45','',''),(6259,'1','306','1',1,'Retail Sale Id 6392',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 08:50:51','',''),(6260,'1','306','1',1,'Retail Sale Id 6393',1550.40,0.00,0.00,2.04,226.44,'2023-02-12 08:52:32','',''),(6261,'1','306','1',1,'Retail Sale Id 6395',5000.80,0.00,0.00,6.58,730.38,'2023-02-12 08:54:24','',''),(6262,'1','306','1',1,'Retail Sale Id 6396',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 08:58:12','',''),(6263,'1','306','1',1,'Retail Sale Id 6397',1003.20,0.00,0.00,1.32,146.52,'2023-02-12 08:59:14','',''),(6264,'1','306','1',1,'Retail Sale Id 6398',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 09:01:22','',''),(6265,'1','306','1',1,'Retail Sale Id 6399',9500.00,0.00,0.00,12.50,1387.50,'2023-02-12 09:04:05','',''),(6266,'1','306','1',1,'Retail Sale Id 6400',68184.00,0.00,0.00,94.70,6723.70,'2023-02-12 09:06:34','',''),(6267,'1','306','1',1,'Retail Sale Id 6401',3002.00,0.00,0.00,3.95,438.45,'2023-02-12 09:08:26','',''),(6268,'1','306','1',1,'Retail Sale Id 6402',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 09:09:24','',''),(6269,'1','306','1',1,'Retail Sale Id 6403',4499.20,0.00,0.00,5.92,657.12,'2023-02-12 09:10:53','',''),(6270,'1','306','1',1,'Retail Sale Id 6404',5320.00,0.00,0.00,7.00,777.00,'2023-02-12 09:14:43','',''),(6271,'1','306','1',1,'Retail Sale Id 6405',3853.20,0.00,0.00,5.07,562.77,'2023-02-12 09:15:58','',''),(6272,'1','306','1',1,'Retail Sale Id 6406',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 09:19:16','',''),(6273,'1','306','1',1,'Retail Sale Id 6407',1003.20,0.00,0.00,1.32,146.52,'2023-02-12 09:20:18','',''),(6274,'1','306','1',1,'Retail Sale Id 6408',2500.40,0.00,0.00,3.29,365.19,'2023-02-12 09:22:22','',''),(6275,'1','306','1',1,'Retail Sale Id 6409',3800.00,0.00,0.00,5.00,555.00,'2023-02-12 09:23:34','',''),(6276,'1','306','1',1,'Retail Sale Id 6410',3002.00,0.00,0.00,3.95,438.45,'2023-02-12 09:28:58','',''),(6277,'1','306','1',1,'Retail Sale Id 6411',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 09:34:19','',''),(6278,'1','306','1',1,'Retail Sale Id 6412',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 09:37:58','',''),(6279,'1','306','1',1,'Retail Sale Id 6413',1520.00,0.00,0.00,2.00,222.00,'2023-02-12 09:47:00','',''),(6280,'1','306','1',1,'Retail Sale Id 6414',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 09:48:02','',''),(6281,'1','306','1',1,'Retail Sale Id 6415',3800.00,0.00,0.00,5.00,555.00,'2023-02-12 09:49:01','',''),(6282,'1','306','1',1,'Retail Sale Id 6416',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 09:50:04','',''),(6283,'1','306','1',1,'Retail Sale Id 6417',3040.00,0.00,0.00,4.00,444.00,'2023-02-12 09:58:48','',''),(6284,'1','306','1',1,'Retail Sale Id 6418',3800.00,0.00,0.00,5.00,555.00,'2023-02-12 10:06:10','',''),(6285,'1','306','1',1,'Retail Sale Id 6419',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 10:10:32','',''),(6286,'1','306','1',1,'Retail Sale Id 6420',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 10:14:09','',''),(6287,'1','306','1',1,'Retail Sale Id 6421',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 10:19:24','',''),(6288,'1','306','1',1,'Retail Sale Id 6422',3002.00,0.00,0.00,3.95,438.45,'2023-02-12 10:20:33','',''),(6289,'1','306','1',1,'Retail Sale Id 6423',760.00,0.00,0.00,1.00,111.00,'2023-02-12 10:22:06','',''),(6290,'1','306','1',1,'Retail Sale Id 6424',1998.80,0.00,0.00,2.63,291.93,'2023-02-12 10:23:29','',''),(6291,'1','306','1',1,'Retail Sale Id 6425',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 10:28:48','',''),(6292,'1','306','1',1,'Retail Sale Id 6426',760.00,0.00,0.00,1.00,111.00,'2023-02-12 10:30:41','',''),(6293,'1','306','1',1,'Retail Sale Id 6427',1520.00,0.00,0.00,2.00,222.00,'2023-02-12 10:32:16','',''),(6294,'1','306','1',1,'Retail Sale Id 6428',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 10:35:08','',''),(6295,'1','306','1',1,'Retail Sale Id 6429',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 10:36:17','',''),(6296,'1','306','1',1,'Retail Sale Id 6430',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 10:39:44','',''),(6297,'1','306','1',1,'Retail Sale Id 6431',2500.40,0.00,0.00,3.29,365.19,'2023-02-12 10:53:54','',''),(6298,'1','306','1',1,'Retail Sale Id 6432',7600.00,0.00,0.00,10.00,1110.00,'2023-02-12 10:54:32','',''),(6299,'1','306','1',1,'Retail Sale Id 6433',3800.00,0.00,0.00,5.00,555.00,'2023-02-12 11:10:28','',''),(6300,'1','306','1',1,'Retail Sale Id 6434',1003.20,0.00,0.00,1.32,146.52,'2023-02-12 11:11:13','',''),(6301,'1','306','1',1,'Retail Sale Id 6435',1520.00,0.00,0.00,2.00,222.00,'2023-02-12 11:12:19','',''),(6302,'1','306','1',1,'Retail Sale Id 6436',3800.00,0.00,0.00,5.00,555.00,'2023-02-12 11:13:25','',''),(6303,'1','306','1',1,'Retail Sale Id 6437',2796.80,0.00,0.00,3.68,408.48,'2023-02-12 11:20:04','',''),(6304,'1','306','1',1,'Retail Sale Id 6438',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 11:20:58','',''),(6305,'1','306','1',1,'Retail Sale Id 6439',1520.00,0.00,0.00,2.00,222.00,'2023-02-12 11:29:00','',''),(6306,'1','306','1',1,'Retail Sale Id 6440',9500.00,0.00,0.00,12.50,1387.50,'2023-02-12 11:30:38','',''),(6307,'1','306','1',1,'Retail Sale Id 6440',9500.00,0.00,0.00,12.50,1387.50,'2023-02-12 11:30:38','',''),(6308,'1','306','1',1,'Retail Sale Id 6441',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 11:32:19','',''),(6309,'1','306','1',1,'Retail Sale Id 6442',3800.00,0.00,0.00,5.00,555.00,'2023-02-12 11:41:05','',''),(6310,'1','306','1',1,'Retail Sale Id 6443',9500.00,0.00,0.00,12.50,1387.50,'2023-02-12 11:46:24','',''),(6311,'1','306','1',1,'Retail Sale Id 6444',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 11:48:06','',''),(6312,'1','306','1',1,'Retail Sale Id 6445',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 11:49:38','',''),(6313,'1','306','1',1,'Retail Sale Id 6446',1998.80,0.00,0.00,2.63,291.93,'2023-02-12 11:50:00','',''),(6314,'1','306','1',1,'Retail Sale Id 6447',9500.00,0.00,0.00,12.50,1387.50,'2023-02-12 11:55:51','',''),(6315,'1','306','1',1,'Retail Sale Id 6448',9500.00,0.00,0.00,12.50,1387.50,'2023-02-12 11:58:47','',''),(6316,'1','306','1',1,'Retail Sale Id 6449',3800.00,0.00,0.00,5.00,555.00,'2023-02-12 12:06:49','',''),(6317,'1','306','1',1,'Retail Sale Id 6450',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 12:08:35','',''),(6318,'1','306','1',1,'Retail Sale Id 6451',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 12:10:05','',''),(6319,'1','306','1',1,'Retail Sale Id 6452',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 12:11:11','',''),(6320,'1','306','1',1,'Retail Sale Id 6453',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 12:12:12','',''),(6321,'1','306','1',1,'Retail Sale Id 6454',3800.00,0.00,0.00,5.00,555.00,'2023-02-12 12:13:08','',''),(6322,'1','306','1',1,'Retail Sale Id 6455',3800.00,0.00,0.00,5.00,555.00,'2023-02-12 12:18:43','',''),(6323,'1','306','1',1,'Retail Sale Id 6456',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 12:22:15','',''),(6324,'1','306','1',1,'Retail Sale Id 6457',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 12:24:28','',''),(6325,'1','306','1',1,'Retail Sale Id 6458',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 12:26:15','',''),(6326,'1','306','1',1,'Retail Sale Id 6459',501.60,0.00,0.00,0.66,73.26,'2023-02-12 12:27:16','',''),(6327,'1','306','1',1,'Retail Sale Id 6460',1998.80,0.00,0.00,2.63,291.93,'2023-02-12 12:29:02','',''),(6328,'1','306','1',1,'Retail Sale Id 6461',1520.00,0.00,0.00,2.00,222.00,'2023-02-12 12:30:28','',''),(6329,'1','306','1',1,'Retail Sale Id 6462',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 12:36:23','',''),(6330,'1','306','1',1,'Retail Sale Id 6463',1003.20,0.00,0.00,1.32,146.52,'2023-02-12 12:49:22','',''),(6331,'1','306','1',1,'Retail Sale Id 6464',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 12:52:05','',''),(6332,'1','306','1',1,'Retail Sale Id 6465',3040.00,0.00,0.00,4.00,444.00,'2023-02-12 12:53:40','',''),(6333,'1','306','1',1,'Retail Sale Id 6466',3040.00,0.00,0.00,4.00,444.00,'2023-02-12 12:55:14','',''),(6334,'1','306','1',1,'Retail Sale Id 6467',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 12:59:54','',''),(6335,'1','306','1',1,'Retail Sale Id 6468',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 13:01:51','',''),(6336,'1','306','1',1,'Retail Sale Id 6469',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 13:05:55','',''),(6337,'1','306','1',1,'Retail Sale Id 6470',9500.00,0.00,0.00,12.50,1387.50,'2023-02-12 13:11:31','',''),(6338,'1','306','1',1,'Retail Sale Id 6472',1550.40,0.00,0.00,2.04,226.44,'2023-02-12 13:16:32','',''),(6339,'1','306','1',1,'Retail Sale Id 6473',1520.00,0.00,0.00,2.00,222.00,'2023-02-12 13:22:24','',''),(6340,'1','306','1',1,'Retail Sale Id 6474',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 13:24:01','',''),(6341,'1','306','1',1,'Retail Sale Id 6474',9500.00,0.00,0.00,12.50,1387.50,'2023-02-12 13:24:01','',''),(6342,'1','306','1',1,'Retail Sale Id 6475',3002.00,0.00,0.00,3.95,438.45,'2023-02-12 13:25:29','',''),(6343,'1','306','1',1,'Retail Sale Id 6476',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 13:27:35','',''),(6344,'1','306','1',1,'Retail Sale Id 6477',7600.00,0.00,0.00,10.00,1110.00,'2023-02-12 13:28:53','',''),(6345,'1','306','1',1,'Retail Sale Id 6478',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 13:30:55','',''),(6346,'1','306','1',1,'Retail Sale Id 6479',3002.00,0.00,0.00,3.95,438.45,'2023-02-12 13:31:47','',''),(6347,'1','306','1',1,'Retail Sale Id 6480',1998.80,0.00,0.00,2.63,291.93,'2023-02-12 13:33:10','',''),(6348,'1','306','1',1,'Retail Sale Id 6481',3040.00,0.00,0.00,4.00,444.00,'2023-02-12 13:34:24','',''),(6349,'1','306','1',1,'Retail Sale Id 6482',1998.80,0.00,0.00,2.63,291.93,'2023-02-12 13:36:23','',''),(6350,'1','306','1',1,'Retail Sale Id 6483',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 13:37:45','',''),(6351,'1','306','1',1,'Retail Sale Id 6484',9500.00,0.00,0.00,12.50,1387.50,'2023-02-12 13:39:36','',''),(6352,'1','306','1',1,'Retail Sale Id 6485',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 13:54:30','',''),(6353,'1','306','1',1,'Retail Sale Id 6485',9500.00,0.00,0.00,12.50,1387.50,'2023-02-12 13:54:30','',''),(6354,'1','306','1',1,'Retail Sale Id 6486',1520.00,0.00,0.00,2.00,222.00,'2023-02-12 14:04:16','',''),(6355,'1','306','1',1,'Retail Sale Id 6487',9500.00,0.00,0.00,12.50,1387.50,'2023-02-12 14:08:33','',''),(6356,'1','306','1',1,'Retail Sale Id 6488',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 14:15:31','',''),(6357,'1','306','1',1,'Retail Sale Id 6489',866.40,0.00,0.00,1.14,126.54,'2023-02-12 14:22:32','',''),(6358,'1','306','1',1,'Retail Sale Id 6490',1003.20,0.00,0.00,1.32,146.52,'2023-02-12 14:27:25','',''),(6359,'1','306','1',1,'Retail Sale Id 6491',1497.20,0.00,0.00,1.97,218.67,'2023-02-12 14:36:40','',''),(6360,'1','306','1',1,'Retail Sale Id 6495',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 14:45:09','',''),(6361,'1','306','1',1,'Retail Sale Id 6496',7600.00,0.00,0.00,10.00,1110.00,'2023-02-12 14:46:56','',''),(6362,'1','306','1',1,'Retail Sale Id 6497',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 14:52:18','',''),(6363,'1','306','1',1,'Retail Sale Id 6498',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 14:53:20','',''),(6364,'1','306','1',1,'Retail Sale Id 6499',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 15:00:01','',''),(6365,'1','306','1',1,'Retail Sale Id 6500',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 15:02:58','',''),(6366,'1','306','1',1,'Retail Sale Id 6501',3040.00,0.00,0.00,4.00,444.00,'2023-02-12 15:13:15','',''),(6367,'1','306','1',1,'Retail Sale Id 6502',1998.80,0.00,0.00,2.63,291.93,'2023-02-12 15:22:33','',''),(6368,'1','306','1',1,'Retail Sale Id 6503',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 15:25:00','',''),(6369,'1','306','1',1,'Retail Sale Id 6504',3040.00,0.00,0.00,4.00,444.00,'2023-02-12 15:25:50','',''),(6370,'1','306','1',1,'Retail Sale Id 6505',7600.00,0.00,0.00,10.00,1110.00,'2023-02-12 15:26:57','',''),(6371,'1','306','1',1,'Retail Sale Id 6506',9500.00,0.00,0.00,12.50,1387.50,'2023-02-12 15:28:21','',''),(6372,'1','306','1',1,'Retail Sale Id 6507',3800.00,0.00,0.00,5.00,555.00,'2023-02-12 15:35:22','',''),(6373,'1','306','1',1,'Retail Sale Id 6508',1003.20,0.00,0.00,1.32,146.52,'2023-02-12 15:48:54','',''),(6374,'1','306','1',1,'Retail Sale Id 6509',1003.20,0.00,0.00,1.32,146.52,'2023-02-12 16:02:04','',''),(6375,'1','306','1',1,'Retail Sale Id 6510',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 16:03:18','',''),(6376,'1','306','1',1,'Retail Sale Id 6511',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 16:06:14','',''),(6377,'1','306','1',1,'Retail Sale Id 6511',3800.00,0.00,0.00,5.00,555.00,'2023-02-12 16:06:14','',''),(6378,'1','306','1',1,'Retail Sale Id 6512',1003.20,0.00,0.00,1.32,146.52,'2023-02-12 16:11:57','',''),(6379,'1','306','1',1,'Retail Sale Id 6513',1520.00,0.00,0.00,2.00,222.00,'2023-02-12 16:28:38','',''),(6380,'1','306','1',1,'Retail Sale Id 6514',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 16:37:12','',''),(6381,'1','306','1',1,'Retail Sale Id 6515',1998.80,0.00,0.00,2.63,291.93,'2023-02-12 16:38:28','',''),(6382,'1','306','1',1,'Retail Sale Id 6516',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 16:45:08','',''),(6383,'1','306','1',1,'Retail Sale Id 6517',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 16:49:25','',''),(6384,'1','306','1',1,'Retail Sale Id 6519',3002.00,0.00,0.00,3.95,438.45,'2023-02-12 16:53:45','',''),(6385,'1','306','1',1,'Retail Sale Id 6521',1398.40,0.00,0.00,1.84,204.24,'2023-02-12 16:58:19','',''),(6386,'1','306','1',1,'Retail Sale Id 6522',1520.00,0.00,0.00,2.00,222.00,'2023-02-12 17:06:33','',''),(6387,'1','306','1',1,'Retail Sale Id 6523',760.00,0.00,0.00,1.00,111.00,'2023-02-12 17:07:51','',''),(6388,'1','306','1',1,'Retail Sale Id 6524',9500.00,0.00,0.00,12.50,1387.50,'2023-02-12 17:09:14','',''),(6389,'1','306','1',1,'Retail Sale Id 6525',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 17:11:01','',''),(6390,'1','306','1',1,'Retail Sale Id 6526',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 17:12:40','',''),(6391,'1','306','1',1,'Retail Sale Id 6527',1520.00,0.00,0.00,2.00,222.00,'2023-02-12 17:16:51','',''),(6392,'1','306','1',1,'Retail Sale Id 6528',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 17:23:22','',''),(6393,'1','306','1',1,'Retail Sale Id 6529',798.00,0.00,0.00,1.05,116.55,'2023-02-12 17:26:33','',''),(6394,'1','306','1',1,'Retail Sale Id 6530',1497.20,0.00,0.00,1.97,218.67,'2023-02-12 17:29:14','',''),(6395,'1','306','1',1,'Retail Sale Id 6531',9500.00,0.00,0.00,12.50,1387.50,'2023-02-12 17:30:12','',''),(6396,'1','306','1',1,'Retail Sale Id 6532',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 17:33:07','',''),(6397,'1','306','1',1,'Retail Sale Id 6533',3040.00,0.00,0.00,4.00,444.00,'2023-02-12 17:34:07','',''),(6398,'1','306','1',1,'Retail Sale Id 6534',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 17:35:31','',''),(6399,'1','306','1',1,'Retail Sale Id 6535',4499.20,0.00,0.00,5.92,657.12,'2023-02-12 17:37:00','',''),(6400,'1','306','1',1,'Retail Sale Id 6536',3040.00,0.00,0.00,4.00,444.00,'2023-02-12 17:38:24','',''),(6401,'1','306','1',1,'Retail Sale Id 6537',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 17:39:13','',''),(6402,'1','306','1',1,'Retail Sale Id 6538',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 17:44:58','',''),(6403,'1','306','1',1,'Retail Sale Id 6539',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 17:48:38','',''),(6404,'1','306','1',1,'Retail Sale Id 6540',2280.00,0.00,0.00,3.00,333.00,'2023-02-12 17:49:46','',''),(6405,'1','306','1',1,'Retail Sale Id 6541',9500.00,0.00,0.00,12.50,1387.50,'2023-02-12 17:53:29','',''),(6406,'1','306','1',1,'Retail Sale Id 6542',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 17:54:26','',''),(6407,'1','306','1',1,'Retail Sale Id 6543',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 17:56:05','',''),(6408,'1','306','1',1,'Retail Sale Id 6544',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 17:58:05','',''),(6409,'1','306','1',1,'Retail Sale Id 6545',4560.00,0.00,0.00,6.00,666.00,'2023-02-12 18:02:52','',''),(6410,'1','306','1',1,'Retail Sale Id 6546',5000.80,0.00,0.00,6.58,730.38,'2023-02-12 18:08:43','',''),(6411,'1','306','1',1,'Retail Sale Id 6547',760.00,0.00,0.00,1.00,111.00,'2023-02-12 18:10:01','',''),(6412,'1','306','1',1,'Retail Sale Id 6547',760.00,0.00,0.00,1.00,111.00,'2023-02-12 18:10:01','',''),(6413,'1','306','1',1,'Retail Sale Id 6548',1520.00,0.00,0.00,2.00,222.00,'2023-02-12 18:20:50','',''),(6414,'1','306','1',1,'Retail Sale Id 6549',3040.00,0.00,0.00,4.00,444.00,'2023-02-12 18:23:49','',''),(6415,'1','306','1',1,'Retail Sale Id 6550',1003.20,0.00,0.00,1.32,146.52,'2023-02-12 18:28:01','',''),(6416,'1','306','1',1,'Retail Sale Id 6551',3040.00,0.00,0.00,4.00,444.00,'2023-02-13 07:03:08','',''),(6417,'1','306','1',1,'Retail Sale Id 6552',3002.00,0.00,0.00,3.95,438.45,'2023-02-13 07:29:48','',''),(6418,'1','306','1',1,'Retail Sale Id 6553',1497.20,0.00,0.00,1.97,218.67,'2023-02-13 07:44:49','',''),(6419,'1','306','1',1,'Retail Sale Id 6554',4560.00,0.00,0.00,6.00,666.00,'2023-02-13 07:47:47','',''),(6420,'1','306','1',1,'Retail Sale Id 6555',9500.00,0.00,0.00,12.50,1387.50,'2023-02-13 07:59:21','',''),(6421,'1','306','1',1,'Retail Sale Id 6556',3800.00,0.00,0.00,5.00,555.00,'2023-02-13 08:17:28','',''),(6422,'1','306','1',1,'Retail Sale Id 6557',4560.00,0.00,0.00,6.00,666.00,'2023-02-13 08:20:10','',''),(6423,'1','306','1',1,'Retail Sale Id 6558',3800.00,0.00,0.00,5.00,555.00,'2023-02-13 08:21:43','',''),(6424,'1','306','1',1,'Retail Sale Id 6559',4560.00,0.00,0.00,6.00,666.00,'2023-02-13 08:31:48','',''),(6425,'1','306','1',1,'Retail Sale Id 6560',2249.60,0.00,0.00,2.96,328.56,'2023-02-13 08:33:07','',''),(6426,'1','306','1',1,'Retail Sale Id 6561',11400.00,0.00,0.00,15.00,1665.00,'2023-02-13 08:43:37','',''),(6427,'1','306','1',1,'Retail Sale Id 6562',4560.00,0.00,0.00,6.00,666.00,'2023-02-13 08:48:10','',''),(6428,'1','306','1',1,'Retail Sale Id 6563',4560.00,0.00,0.00,6.00,666.00,'2023-02-13 08:53:06','',''),(6429,'1','306','1',1,'Retail Sale Id 6564',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 08:55:42','',''),(6430,'1','306','1',1,'Retail Sale Id 6566',8360.00,0.00,0.00,11.00,1221.00,'2023-02-13 08:58:39','',''),(6431,'1','306','1',1,'Retail Sale Id 6567',9500.00,0.00,0.00,12.50,1387.50,'2023-02-13 09:00:32','',''),(6432,'1','306','1',1,'Retail Sale Id 6569',600.40,0.00,0.00,0.79,87.69,'2023-02-13 09:06:01','',''),(6433,'1','306','1',1,'Retail Sale Id 6570',3002.00,0.00,0.00,3.95,438.45,'2023-02-13 09:11:09','',''),(6434,'1','306','1',1,'Retail Sale Id 6571',4560.00,0.00,0.00,6.00,666.00,'2023-02-13 09:13:50','',''),(6435,'1','306','1',1,'Retail Sale Id 6572',9120.00,0.00,0.00,12.00,1332.00,'2023-02-13 09:17:31','',''),(6436,'1','306','1',1,'Retail Sale Id 6574',1497.20,0.00,0.00,1.97,218.67,'2023-02-13 09:33:35','',''),(6437,'1','306','1',1,'Retail Sale Id 6575',1520.00,0.00,0.00,2.00,222.00,'2023-02-13 09:42:03','',''),(6438,'1','306','1',1,'Retail Sale Id 6575',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 09:42:03','',''),(6439,'1','306','1',1,'Retail Sale Id 6576',4560.00,0.00,0.00,6.00,666.00,'2023-02-13 09:47:02','',''),(6440,'1','306','1',1,'Retail Sale Id 6577',4560.00,0.00,0.00,6.00,666.00,'2023-02-13 10:02:40','',''),(6441,'1','306','1',1,'Retail Sale Id 6577',9500.00,0.00,0.00,12.50,1387.50,'2023-02-13 10:02:40','',''),(6442,'1','306','1',1,'Retail Sale Id 6579',760.00,0.00,0.00,1.00,111.00,'2023-02-13 10:14:36','',''),(6443,'1','306','1',1,'Retail Sale Id 6581',9500.00,0.00,0.00,12.50,1387.50,'2023-02-13 10:18:09','',''),(6444,'1','306','1',1,'Retail Sale Id 6582',3800.00,0.00,0.00,5.00,555.00,'2023-02-13 10:19:43','',''),(6445,'1','306','1',1,'Retail Sale Id 6583',18000.00,0.00,0.00,25.00,1775.00,'2023-02-13 10:21:31','',''),(6446,'1','306','1',1,'Retail Sale Id 6584',3040.00,0.00,0.00,4.00,444.00,'2023-02-13 10:22:54','',''),(6447,'1','306','1',1,'Retail Sale Id 6587',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 10:27:47','',''),(6448,'1','306','1',1,'Retail Sale Id 6588',1520.00,0.00,0.00,2.00,222.00,'2023-02-13 10:30:30','',''),(6449,'1','306','1',1,'Retail Sale Id 6588',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 10:30:30','',''),(6450,'1','306','1',1,'Retail Sale Id 6589',33840.00,0.00,0.00,47.00,3337.00,'2023-02-13 10:33:16','',''),(6451,'1','306','1',1,'Retail Sale Id 6590',3997.60,0.00,0.00,5.26,583.86,'2023-02-13 10:34:50','',''),(6452,'1','306','1',1,'Retail Sale Id 6591',5320.00,0.00,0.00,7.00,777.00,'2023-02-13 10:37:45','',''),(6453,'1','306','1',1,'Retail Sale Id 6593',760.00,0.00,0.00,1.00,111.00,'2023-02-13 10:40:27','',''),(6454,'1','306','1',1,'Retail Sale Id 6595',2302.80,0.00,0.00,3.03,336.33,'2023-02-13 10:42:22','',''),(6455,'1','306','1',1,'Retail Sale Id 6596',3800.00,0.00,0.00,5.00,555.00,'2023-02-13 10:47:09','',''),(6456,'1','306','1',1,'Retail Sale Id 6597',3800.00,0.00,0.00,5.00,555.00,'2023-02-13 10:54:19','',''),(6457,'1','306','1',1,'Retail Sale Id 6598',3800.00,0.00,0.00,5.00,555.00,'2023-02-13 10:55:58','',''),(6458,'1','306','1',1,'Retail Sale Id 6599',7600.00,0.00,0.00,10.00,1110.00,'2023-02-13 10:58:56','',''),(6459,'1','306','1',1,'Retail Sale Id 6600',760.00,0.00,0.00,1.00,111.00,'2023-02-13 11:01:03','',''),(6460,'1','306','1',1,'Retail Sale Id 6601',3040.00,0.00,0.00,4.00,444.00,'2023-02-13 11:13:21','',''),(6461,'1','306','1',1,'Retail Sale Id 6602',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 11:14:30','',''),(6462,'1','306','1',1,'Retail Sale Id 6603',6080.00,0.00,0.00,8.00,888.00,'2023-02-13 11:19:58','',''),(6463,'1','306','1',1,'Retail Sale Id 6604',3800.00,0.00,0.00,5.00,555.00,'2023-02-13 11:21:14','',''),(6464,'1','306','1',1,'Retail Sale Id 6605',4560.00,0.00,0.00,6.00,666.00,'2023-02-13 11:23:02','',''),(6465,'1','306','1',1,'Retail Sale Id 6606',3800.00,0.00,0.00,5.00,555.00,'2023-02-13 11:27:51','',''),(6466,'1','306','1',1,'Retail Sale Id 6607',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 11:34:29','',''),(6467,'1','306','1',1,'Retail Sale Id 6608',1520.00,0.00,0.00,2.00,222.00,'2023-02-13 11:39:19','',''),(6468,'1','306','1',1,'Retail Sale Id 6609',3040.00,0.00,0.00,4.00,444.00,'2023-02-13 11:40:39','',''),(6469,'1','306','1',1,'Retail Sale Id 6610',4499.20,0.00,0.00,5.92,657.12,'2023-02-13 11:42:40','',''),(6470,'1','306','1',1,'Retail Sale Id 6612',5320.00,0.00,0.00,7.00,777.00,'2023-02-13 11:46:23','',''),(6471,'1','306','1',1,'Retail Sale Id 6613',7600.00,0.00,0.00,10.00,1110.00,'2023-02-13 11:48:05','',''),(6472,'1','306','1',1,'Retail Sale Id 6614',9120.00,0.00,0.00,12.00,1332.00,'2023-02-13 11:50:00','',''),(6473,'1','306','1',1,'Retail Sale Id 6616',3800.00,0.00,0.00,5.00,555.00,'2023-02-13 11:56:10','',''),(6474,'1','306','1',1,'Retail Sale Id 6617',2196.40,0.00,0.00,2.89,320.79,'2023-02-13 11:59:03','',''),(6475,'1','306','1',1,'Retail Sale Id 6618',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 12:00:32','',''),(6476,'1','306','1',1,'Retail Sale Id 6620',2302.80,0.00,0.00,3.03,336.33,'2023-02-13 12:02:37','',''),(6477,'1','306','1',1,'Retail Sale Id 6621',9500.00,0.00,0.00,12.50,1387.50,'2023-02-13 12:14:34','',''),(6478,'1','306','1',1,'Retail Sale Id 6622',4560.00,0.00,0.00,6.00,666.00,'2023-02-13 12:17:06','',''),(6479,'1','306','1',1,'Retail Sale Id 6624',9120.00,0.00,0.00,12.00,1332.00,'2023-02-13 12:29:56','',''),(6480,'1','306','1',1,'Retail Sale Id 6625',4560.00,0.00,0.00,6.00,666.00,'2023-02-13 12:31:37','',''),(6481,'1','306','1',1,'Retail Sale Id 6627',3800.00,0.00,0.00,5.00,555.00,'2023-02-13 12:36:25','',''),(6482,'1','306','1',1,'Retail Sale Id 6629',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 12:38:47','',''),(6483,'1','306','1',1,'Retail Sale Id 6630',23040.00,0.00,0.00,32.00,2272.00,'2023-02-13 12:41:33','',''),(6484,'1','306','1',1,'Retail Sale Id 6631',7600.00,0.00,0.00,10.00,1110.00,'2023-02-13 12:44:03','',''),(6485,'1','306','1',1,'Retail Sale Id 6632',2302.80,0.00,0.00,3.03,336.33,'2023-02-13 12:44:51','',''),(6486,'1','306','1',1,'Retail Sale Id 6633',4560.00,0.00,0.00,6.00,666.00,'2023-02-13 12:46:35','',''),(6487,'1','306','1',1,'Retail Sale Id 6634',4560.00,0.00,0.00,6.00,666.00,'2023-02-13 12:48:22','',''),(6488,'1','306','1',1,'Retail Sale Id 6636',7200.00,0.00,0.00,10.00,710.00,'2023-02-13 12:50:36','',''),(6489,'1','306','1',1,'Retail Sale Id 6637',3800.00,0.00,0.00,5.00,555.00,'2023-02-13 12:52:07','',''),(6490,'1','306','1',1,'Retail Sale Id 6638',5320.00,0.00,0.00,7.00,777.00,'2023-02-13 12:53:55','',''),(6491,'1','306','1',1,'Retail Sale Id 6639',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 12:55:54','',''),(6492,'1','306','1',1,'Retail Sale Id 6640',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 13:01:04','',''),(6493,'1','306','1',1,'Retail Sale Id 6641',501.60,0.00,0.00,0.66,73.26,'2023-02-13 13:02:04','',''),(6494,'1','306','1',1,'Retail Sale Id 6642',3800.00,0.00,0.00,5.00,555.00,'2023-02-13 13:25:42','',''),(6495,'1','306','1',1,'Retail Sale Id 6643',8998.40,0.00,0.00,11.84,1314.24,'2023-02-13 13:28:07','',''),(6496,'1','306','1',1,'Retail Sale Id 6644',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 13:33:14','',''),(6497,'1','306','1',1,'Retail Sale Id 6645',1520.00,0.00,0.00,2.00,222.00,'2023-02-13 13:34:47','',''),(6498,'1','306','1',1,'Retail Sale Id 6645',1520.00,0.00,0.00,2.00,222.00,'2023-02-13 13:34:48','',''),(6499,'1','306','1',1,'Retail Sale Id 6646',3040.00,0.00,0.00,4.00,444.00,'2023-02-13 13:40:24','',''),(6500,'1','306','1',1,'Retail Sale Id 6647',4499.20,0.00,0.00,5.92,657.12,'2023-02-13 13:54:53','',''),(6501,'1','306','1',1,'Retail Sale Id 6648',2500.40,0.00,0.00,3.29,365.19,'2023-02-13 13:57:52','',''),(6502,'1','306','1',1,'Retail Sale Id 6649',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 14:05:12','',''),(6503,'1','306','1',1,'Retail Sale Id 6649',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 14:05:12','',''),(6504,'1','306','1',1,'Retail Sale Id 6650',3800.00,0.00,0.00,5.00,555.00,'2023-02-13 14:09:14','',''),(6505,'1','306','1',1,'Retail Sale Id 6651',6480.00,0.00,0.00,9.00,639.00,'2023-02-13 14:12:30','',''),(6506,'1','306','1',1,'Retail Sale Id 6653',9500.00,0.00,0.00,12.50,1387.50,'2023-02-13 14:19:46','',''),(6507,'1','306','1',1,'Retail Sale Id 6654',3800.00,0.00,0.00,5.00,555.00,'2023-02-13 14:22:46','',''),(6508,'1','306','1',1,'Retail Sale Id 6655',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 14:25:45','',''),(6509,'1','306','1',1,'Retail Sale Id 6656',9500.00,0.00,0.00,12.50,1387.50,'2023-02-13 14:28:57','',''),(6510,'1','306','1',1,'Retail Sale Id 6657',1520.00,0.00,0.00,2.00,222.00,'2023-02-13 14:30:41','',''),(6511,'1','306','1',1,'Retail Sale Id 6659',4598.00,0.00,0.00,6.05,671.55,'2023-02-13 14:32:54','',''),(6512,'1','306','1',1,'Retail Sale Id 6660',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 14:37:39','',''),(6513,'1','306','1',1,'Retail Sale Id 6661',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 14:42:09','',''),(6514,'1','306','1',1,'Retail Sale Id 6662',5320.00,0.00,0.00,7.00,777.00,'2023-02-13 14:45:21','',''),(6515,'1','306','1',1,'Retail Sale Id 6663',798.00,0.00,0.00,1.05,116.55,'2023-02-13 14:51:55','',''),(6516,'1','306','1',1,'Retail Sale Id 6664',4560.00,0.00,0.00,6.00,666.00,'2023-02-13 14:56:26','',''),(6517,'1','306','1',1,'Retail Sale Id 6665',1497.20,0.00,0.00,1.97,218.67,'2023-02-13 15:03:33','',''),(6518,'1','306','1',1,'Retail Sale Id 6666',1497.20,0.00,0.00,1.97,218.67,'2023-02-13 15:09:09','',''),(6519,'1','306','1',1,'Retail Sale Id 6667',798.00,0.00,0.00,1.05,116.55,'2023-02-13 15:10:13','',''),(6520,'1','306','1',1,'Retail Sale Id 6668',9500.00,0.00,0.00,12.50,1387.50,'2023-02-13 15:12:34','',''),(6521,'1','306','1',1,'Retail Sale Id 6669',4560.00,0.00,0.00,6.00,666.00,'2023-02-13 15:19:11','',''),(6522,'1','306','1',1,'Retail Sale Id 6670',2302.80,0.00,0.00,3.03,336.33,'2023-02-13 15:20:24','',''),(6523,'1','306','1',1,'Retail Sale Id 6671',1497.20,0.00,0.00,1.97,218.67,'2023-02-13 15:25:52','',''),(6524,'1','306','1',1,'Retail Sale Id 6672',1998.80,0.00,0.00,2.63,291.93,'2023-02-13 15:34:08','',''),(6525,'1','306','1',1,'Retail Sale Id 6673',2500.40,0.00,0.00,3.29,365.19,'2023-02-13 15:37:35','',''),(6526,'1','306','1',1,'Retail Sale Id 6674',2302.80,0.00,0.00,3.03,336.33,'2023-02-13 15:44:37','',''),(6527,'1','306','1',1,'Retail Sale Id 6675',3800.00,0.00,0.00,5.00,555.00,'2023-02-13 15:49:43','',''),(6528,'1','306','1',1,'Retail Sale Id 6676',1497.20,0.00,0.00,1.97,218.67,'2023-02-13 15:52:29','',''),(6529,'1','306','1',1,'Retail Sale Id 6677',3040.00,0.00,0.00,4.00,444.00,'2023-02-13 15:55:55','',''),(6530,'1','306','1',1,'Retail Sale Id 6678',9500.00,0.00,0.00,12.50,1387.50,'2023-02-13 16:05:39','',''),(6531,'1','306','1',1,'Retail Sale Id 6679',1497.20,0.00,0.00,1.97,218.67,'2023-02-13 16:06:53','',''),(6532,'1','306','1',1,'Retail Sale Id 6680',10800.00,0.00,0.00,15.00,1065.00,'2023-02-13 16:09:42','',''),(6533,'1','306','1',1,'Retail Sale Id 6681',4560.00,0.00,0.00,6.00,666.00,'2023-02-13 16:11:19','',''),(6534,'1','306','1',1,'Retail Sale Id 6682',798.00,0.00,0.00,1.05,116.55,'2023-02-13 16:13:05','',''),(6535,'1','306','1',1,'Retail Sale Id 6684',1603.60,0.00,0.00,2.11,234.21,'2023-02-13 16:19:13','',''),(6536,'1','306','1',1,'Retail Sale Id 6686',4560.00,0.00,0.00,6.00,666.00,'2023-02-13 16:26:38','',''),(6537,'1','306','1',1,'Retail Sale Id 6688',2302.80,0.00,0.00,3.03,336.33,'2023-02-13 16:29:15','',''),(6538,'1','306','1',1,'Retail Sale Id 6689',1520.00,0.00,0.00,2.00,222.00,'2023-02-13 16:30:09','',''),(6539,'1','306','1',1,'Retail Sale Id 6690',1520.00,0.00,0.00,2.00,222.00,'2023-02-13 16:33:35','',''),(6540,'1','306','1',1,'Retail Sale Id 6691',3800.00,0.00,0.00,5.00,555.00,'2023-02-13 16:36:37','',''),(6541,'1','306','1',1,'Retail Sale Id 6692',9500.00,0.00,0.00,12.50,1387.50,'2023-02-13 16:37:28','',''),(6542,'1','306','1',1,'Retail Sale Id 6694',4560.00,0.00,0.00,6.00,666.00,'2023-02-13 16:38:49','',''),(6543,'1','306','1',1,'Retail Sale Id 6695',1998.80,0.00,0.00,2.63,291.93,'2023-02-13 16:41:31','',''),(6544,'1','306','1',1,'Retail Sale Id 6696',2302.80,0.00,0.00,3.03,336.33,'2023-02-13 16:43:21','',''),(6545,'1','306','1',1,'Retail Sale Id 6697',5320.00,0.00,0.00,7.00,777.00,'2023-02-13 16:47:58','',''),(6546,'1','306','1',1,'Retail Sale Id 6698',18000.00,0.00,0.00,25.00,1775.00,'2023-02-13 16:50:35','',''),(6547,'1','306','1',1,'Retail Sale Id 6699',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 16:53:16','',''),(6548,'1','306','1',1,'Retail Sale Id 6700',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 16:55:59','',''),(6549,'1','306','1',1,'Retail Sale Id 6701',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 16:58:28','',''),(6550,'1','306','1',1,'Retail Sale Id 6702',3040.00,0.00,0.00,4.00,444.00,'2023-02-13 17:02:56','',''),(6551,'1','306','1',1,'Retail Sale Id 6703',1520.00,0.00,0.00,2.00,222.00,'2023-02-13 17:08:39','',''),(6552,'1','306','1',1,'Retail Sale Id 6706',1520.00,0.00,0.00,2.00,222.00,'2023-02-13 17:17:24','',''),(6553,'1','306','1',1,'Retail Sale Id 6706',1520.00,0.00,0.00,2.00,222.00,'2023-02-13 17:17:24','',''),(6554,'1','306','1',1,'Retail Sale Id 6708',3800.00,0.00,0.00,5.00,555.00,'2023-02-13 17:22:54','',''),(6555,'1','306','1',1,'Retail Sale Id 6710',3040.00,0.00,0.00,4.00,444.00,'2023-02-13 17:24:49','',''),(6556,'1','306','1',1,'Retail Sale Id 6711',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 17:26:04','',''),(6557,'1','306','1',1,'Retail Sale Id 6712',1497.20,0.00,0.00,1.97,218.67,'2023-02-13 17:29:24','',''),(6558,'1','306','1',1,'Retail Sale Id 6713',4499.20,0.00,0.00,5.92,657.12,'2023-02-13 17:30:20','',''),(6559,'1','306','1',1,'Retail Sale Id 6714',4560.00,0.00,0.00,6.00,666.00,'2023-02-13 17:35:08','',''),(6560,'1','306','1',1,'Retail Sale Id 6715',3002.00,0.00,0.00,3.95,438.45,'2023-02-13 17:36:37','',''),(6561,'1','306','1',1,'Retail Sale Id 6716',3800.00,0.00,0.00,5.00,555.00,'2023-02-13 17:37:29','',''),(6562,'1','306','1',1,'Retail Sale Id 6717',1003.20,0.00,0.00,1.32,146.52,'2023-02-13 17:38:09','',''),(6563,'1','306','1',1,'Retail Sale Id 6718',1497.20,0.00,0.00,1.97,218.67,'2023-02-13 17:40:05','',''),(6564,'1','306','1',1,'Retail Sale Id 6719',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 17:40:53','',''),(6565,'1','306','1',1,'Retail Sale Id 6720',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 17:41:56','',''),(6566,'1','306','1',1,'Retail Sale Id 6721',4560.00,0.00,0.00,6.00,666.00,'2023-02-13 17:46:28','',''),(6567,'1','306','1',1,'Retail Sale Id 6721',7600.00,0.00,0.00,10.00,1110.00,'2023-02-13 17:46:28','',''),(6568,'1','306','1',1,'Retail Sale Id 6721',9120.00,0.00,0.00,12.00,1332.00,'2023-02-13 17:46:28','',''),(6569,'1','306','1',1,'Retail Sale Id 6721',9500.00,0.00,0.00,12.50,1387.50,'2023-02-13 17:46:28','',''),(6570,'1','306','1',1,'Retail Sale Id 6722',4560.00,0.00,0.00,6.00,666.00,'2023-02-13 17:47:25','',''),(6571,'1','306','1',1,'Retail Sale Id 6723',1998.80,0.00,0.00,2.63,291.93,'2023-02-13 17:48:38','',''),(6572,'1','306','1',1,'Retail Sale Id 6724',9500.00,0.00,0.00,12.50,1387.50,'2023-02-13 17:50:11','',''),(6573,'1','306','1',1,'Retail Sale Id 6725',1520.00,0.00,0.00,2.00,222.00,'2023-02-13 17:52:17','',''),(6574,'1','306','1',1,'Retail Sale Id 6726',2280.00,0.00,0.00,3.00,333.00,'2023-02-13 17:56:10','',''),(6575,'1','306','1',1,'Retail Sale Id 6727',6080.00,0.00,0.00,8.00,888.00,'2023-02-13 17:58:46','',''),(6576,'1','306','1',1,'Retail Sale Id 6728',1998.80,0.00,0.00,2.63,291.93,'2023-02-13 18:01:44','',''),(6577,'1','306','1',1,'Retail Sale Id 6729',9500.00,0.00,0.00,12.50,1387.50,'2023-02-13 18:03:33','',''),(6578,'1','306','1',1,'Retail Sale Id 6730',2302.80,0.00,0.00,3.03,336.33,'2023-02-13 18:05:17','',''),(6579,'1','306','1',1,'Retail Sale Id 6731',1497.20,0.00,0.00,1.97,218.67,'2023-02-13 18:08:46','',''),(6580,'1','306','1',1,'Retail Sale Id 6732',1550.40,0.00,0.00,2.04,226.44,'2023-02-13 18:16:47','',''),(6581,'1','306','1',1,'Retail Sale Id 6733',1520.00,0.00,0.00,2.00,222.00,'2023-02-13 18:18:16','',''),(6582,'1','306','1',1,'Retail Sale Id 6734',3040.00,0.00,0.00,4.00,444.00,'2023-02-13 18:20:24','',''),(6583,'1','306','1',1,'Retail Sale Id 6735',1003.20,0.00,0.00,1.32,146.52,'2023-02-13 18:25:55','',''),(6584,'1','306','1',1,'Retail Sale Id 6736',1520.00,0.00,0.00,2.00,222.00,'2023-02-13 18:27:40','',''),(6585,'1','306','1',1,'Retail Sale Id 6737',1520.00,0.00,0.00,2.00,222.00,'2023-02-13 18:29:38','',''),(6586,'1','306','1',1,'Return of Retail Sale Id 6737',0.00,1520.00,2.00,0.00,-222.00,'2023-02-13 18:56:22','',''),(6587,'1','306','1',1,'Retail Sale Id 6738',1702.40,0.00,0.00,2.24,248.64,'2023-02-13 18:58:36','',''),(6588,'1','306','1',1,'Retail Sale Id 6739',4560.00,0.00,0.00,6.00,666.00,'2023-02-14 07:29:03','',''),(6589,'1','306','1',1,'Retail Sale Id 6740',9500.00,0.00,0.00,12.50,1387.50,'2023-02-14 07:36:15','',''),(6590,'1','306','1',1,'Retail Sale Id 6741',3800.00,0.00,0.00,5.00,555.00,'2023-02-14 07:37:42','',''),(6591,'1','306','1',1,'Retail Sale Id 6742',2280.00,0.00,0.00,3.00,333.00,'2023-02-14 07:39:22','',''),(6592,'1','306','1',1,'Retail Sale Id 6742',9500.00,0.00,0.00,12.50,1387.50,'2023-02-14 07:39:22','',''),(6593,'1','306','1',1,'Retail Sale Id 6743',9500.00,0.00,0.00,12.50,1387.50,'2023-02-14 07:40:56','',''),(6594,'1','306','1',1,'Retail Sale Id 6744',3997.60,0.00,0.00,5.26,583.86,'2023-02-14 07:42:03','',''),(6595,'1','306','1',1,'Retail Sale Id 6745',1497.20,0.00,0.00,1.97,218.67,'2023-02-14 07:49:56','',''),(6596,'1','306','1',1,'Retail Sale Id 6746',2280.00,0.00,0.00,3.00,333.00,'2023-02-14 07:53:35','',''),(6597,'1','306','1',1,'Retail Sale Id 6747',3701.20,0.00,0.00,4.87,540.57,'2023-02-14 08:03:52','',''),(6598,'1','306','1',1,'Retail Sale Id 6749',2302.80,0.00,0.00,3.03,336.33,'2023-02-14 08:10:21','',''),(6599,'1','306','1',1,'Retail Sale Id 6750',4560.00,0.00,0.00,6.00,666.00,'2023-02-14 08:12:19','',''),(6600,'1','306','1',1,'Retail Sale Id 6751',1003.20,0.00,0.00,1.32,146.52,'2023-02-14 08:13:12','',''),(6601,'1','306','1',1,'Retail Sale Id 6752',4560.00,0.00,0.00,6.00,666.00,'2023-02-14 08:15:12','',''),(6602,'1','306','1',1,'Retail Sale Id 6753',6840.00,0.00,0.00,9.00,999.00,'2023-02-14 08:16:30','',''),(6603,'1','306','1',1,'Retail Sale Id 6754',3040.00,0.00,0.00,4.00,444.00,'2023-02-14 08:17:19','',''),(6604,'1','306','1',1,'Retail Sale Id 6755',3997.60,0.00,0.00,5.26,583.86,'2023-02-14 08:18:20','',''),(6605,'1','306','1',1,'Retail Sale Id 6756',3800.00,0.00,0.00,5.00,555.00,'2023-02-14 08:19:35','',''),(6606,'1','306','1',1,'Retail Sale Id 6757',1497.20,0.00,0.00,1.97,218.67,'2023-02-14 08:20:24','',''),(6607,'1','306','1',1,'Retail Sale Id 6758',4560.00,0.00,0.00,6.00,666.00,'2023-02-14 08:23:17','',''),(6608,'1','306','1',1,'Retail Sale Id 6760',2500.40,0.00,0.00,3.29,365.19,'2023-02-14 08:26:04','',''),(6609,'1','306','1',1,'Retail Sale Id 6761',2280.00,0.00,0.00,3.00,333.00,'2023-02-14 08:28:54','',''),(6610,'1','306','1',1,'Retail Sale Id 6762',3800.00,0.00,0.00,5.00,555.00,'2023-02-14 08:30:49','',''),(6611,'1','306','1',1,'Retail Sale Id 6763',760.00,0.00,0.00,1.00,111.00,'2023-02-14 08:31:43','',''),(6612,'1','306','1',1,'Retail Sale Id 6764',3800.00,0.00,0.00,5.00,555.00,'2023-02-14 08:34:03','',''),(6613,'1','306','1',1,'Retail Sale Id 6765',760.00,0.00,0.00,1.00,111.00,'2023-02-14 08:35:57','',''),(6614,'1','306','1',1,'Retail Sale Id 6766',2302.80,0.00,0.00,3.03,336.33,'2023-02-14 08:37:55','',''),(6615,'1','306','1',1,'Retail Sale Id 6767',3997.60,0.00,0.00,5.26,583.86,'2023-02-14 08:42:23','',''),(6616,'1','306','1',1,'Retail Sale Id 6768',1497.20,0.00,0.00,1.97,218.67,'2023-02-14 08:43:07','',''),(6617,'1','306','1',1,'Retail Sale Id 6769',5320.00,0.00,0.00,7.00,777.00,'2023-02-14 08:44:51','',''),(6618,'1','306','1',1,'Retail Sale Id 6770',9500.00,0.00,0.00,12.50,1387.50,'2023-02-14 08:46:01','',''),(6619,'1','306','1',1,'Retail Sale Id 6771',4560.00,0.00,0.00,6.00,666.00,'2023-02-14 08:47:55','',''),(6620,'1','306','1',1,'Retail Sale Id 6772',4560.00,0.00,0.00,6.00,666.00,'2023-02-14 08:49:12','',''),(6621,'1','306','1',1,'Retail Sale Id 6773',5996.40,0.00,0.00,7.89,875.79,'2023-02-14 08:50:55','',''),(6622,'1','306','1',1,'Retail Sale Id 6774',2302.80,0.00,0.00,3.03,336.33,'2023-02-14 08:52:35','',''),(6623,'1','306','1',1,'Retail Sale Id 6775',2280.00,0.00,0.00,3.00,333.00,'2023-02-14 08:54:04','',''),(6624,'1','306','1',1,'Retail Sale Id 6776',4499.20,0.00,0.00,5.92,657.12,'2023-02-14 08:56:34','',''),(6625,'1','306','1',1,'Retail Sale Id 6777',4560.00,0.00,0.00,6.00,666.00,'2023-02-14 08:58:40','',''),(6626,'1','306','1',1,'Retail Sale Id 6778',2302.80,0.00,0.00,3.03,336.33,'2023-02-14 08:59:35','',''),(6627,'1','306','1',1,'Retail Sale Id 6779',1520.00,0.00,0.00,2.00,222.00,'2023-02-14 09:03:36','',''),(6628,'1','306','1',1,'Retail Sale Id 6780',4499.20,0.00,0.00,5.92,657.12,'2023-02-14 09:05:03','',''),(6629,'1','306','1',1,'Retail Sale Id 6781',1998.80,0.00,0.00,2.63,291.93,'2023-02-14 09:10:38','',''),(6630,'1','306','1',1,'Retail Sale Id 6782',3040.00,0.00,0.00,4.00,444.00,'2023-02-14 09:12:08','',''),(6631,'1','306','1',1,'Retail Sale Id 6783',3040.00,0.00,0.00,4.00,444.00,'2023-02-14 09:17:37','',''),(6632,'1','306','1',1,'Retail Sale Id 6784',9120.00,0.00,0.00,12.00,1332.00,'2023-02-14 09:19:59','',''),(6633,'1','306','1',1,'Retail Sale Id 6785',1497.20,0.00,0.00,1.97,218.67,'2023-02-14 09:30:02','',''),(6634,'1','306','1',1,'Retail Sale Id 6786',1998.80,0.00,0.00,2.63,291.93,'2023-02-14 09:34:06','',''),(6635,'1','306','1',1,'Retail Sale Id 6787',1520.00,0.00,0.00,2.00,222.00,'2023-02-14 09:37:06','',''),(6636,'1','306','1',1,'Retail Sale Id 6788',3040.00,0.00,0.00,4.00,444.00,'2023-02-14 09:38:55','',''),(6637,'1','306','1',1,'Retail Sale Id 6789',3800.00,0.00,0.00,5.00,555.00,'2023-02-14 09:40:07','',''),(6638,'1','306','1',1,'Retail Sale Id 6790',117000.00,0.00,0.00,162.50,11537.50,'2023-02-14 09:45:35','',''),(6639,'1','306','1',1,'Retail Sale Id 6791',3800.00,0.00,0.00,5.00,555.00,'2023-02-14 09:49:25','',''),(6640,'1','306','1',1,'Retail Sale Id 6792',1003.20,0.00,0.00,1.32,146.52,'2023-02-14 09:57:03','',''),(6641,'1','306','1',1,'Retail Sale Id 6793',3800.00,0.00,0.00,5.00,555.00,'2023-02-14 10:00:24','',''),(6642,'1','306','1',1,'Retail Sale Id 6794',1003.20,0.00,0.00,1.32,146.52,'2023-02-14 10:07:10','',''),(6643,'1','306','1',1,'Retail Sale Id 6795',7600.00,0.00,0.00,10.00,1110.00,'2023-02-14 10:14:04','',''),(6644,'1','306','1',1,'Retail Sale Id 6796',4560.00,0.00,0.00,6.00,666.00,'2023-02-14 10:16:01','',''),(6645,'1','306','1',1,'Retail Sale Id 6798',2280.00,0.00,0.00,3.00,333.00,'2023-02-14 10:21:01','',''),(6646,'1','306','1',1,'Retail Sale Id 6799',2280.00,0.00,0.00,3.00,333.00,'2023-02-14 10:32:23','',''),(6647,'1','306','1',1,'Retail Sale Id 6800',1702.40,0.00,0.00,2.24,248.64,'2023-02-14 10:34:09','',''),(6648,'1','306','1',1,'Retail Sale Id 6801',1003.20,0.00,0.00,1.32,146.52,'2023-02-14 10:35:08','',''),(6649,'1','306','1',1,'Retail Sale Id 6802',4499.20,0.00,0.00,5.92,657.12,'2023-02-14 10:36:25','',''),(6650,'1','306','1',1,'Retail Sale Id 6803',4560.00,0.00,0.00,6.00,666.00,'2023-02-14 10:39:55','',''),(6651,'1','306','1',1,'Retail Sale Id 6804',4552.40,0.00,0.00,5.99,664.89,'2023-02-14 10:41:18','',''),(6652,'1','306','1',1,'Retail Sale Id 6805',4560.00,0.00,0.00,6.00,666.00,'2023-02-14 10:44:49','',''),(6653,'1','306','1',1,'Retail Sale Id 6806',1497.20,0.00,0.00,1.97,218.67,'2023-02-14 10:46:51','',''),(6654,'1','306','1',1,'Retail Sale Id 6807',2280.00,0.00,0.00,3.00,333.00,'2023-02-14 10:52:42','',''),(6655,'1','306','1',1,'Retail Sale Id 6807',3040.00,0.00,0.00,4.00,444.00,'2023-02-14 10:52:42','',''),(6656,'1','306','1',1,'Retail Sale Id 6808',4560.00,0.00,0.00,6.00,666.00,'2023-02-14 10:57:53','',''),(6657,'1','306','1',1,'Retail Sale Id 6809',1998.80,0.00,0.00,2.63,291.93,'2023-02-14 10:58:48','',''),(6658,'1','306','1',1,'Retail Sale Id 6810',4560.00,0.00,0.00,6.00,666.00,'2023-02-14 11:03:37','',''),(6659,'1','306','1',1,'Retail Sale Id 6811',1497.20,0.00,0.00,1.97,218.67,'2023-02-14 11:05:06','',''),(6660,'1','306','1',1,'Retail Sale Id 6812',1520.00,0.00,0.00,2.00,222.00,'2023-02-14 11:07:32','',''),(6661,'1','306','1',1,'Retail Sale Id 6813',3997.60,0.00,0.00,5.26,583.86,'2023-02-14 11:10:36','',''),(6662,'1','306','1',1,'Retail Sale Id 6814',7600.00,0.00,0.00,10.00,1110.00,'2023-02-14 11:13:11','',''),(6663,'1','306','1',1,'Retail Sale Id 6815',4560.00,0.00,0.00,6.00,666.00,'2023-02-14 11:14:32','',''),(6664,'1','306','1',1,'Retail Sale Id 6816',6840.00,0.00,0.00,9.00,999.00,'2023-02-14 11:25:15','',''),(6665,'1','306','1',1,'Retail Sale Id 6817',2280.00,0.00,0.00,3.00,333.00,'2023-02-14 11:40:59','',''),(6666,'1','306','1',1,'Retail Sale Id 6818',1998.80,0.00,0.00,2.63,291.93,'2023-02-14 11:44:54','',''),(6667,'1','306','1',1,'Retail Sale Id 6819',3002.00,0.00,0.00,3.95,438.45,'2023-02-14 11:56:30','',''),(6668,'1','306','1',1,'Retail Sale Id 6820',1497.20,0.00,0.00,1.97,218.67,'2023-02-14 12:05:07','',''),(6669,'1','306','1',1,'Retail Sale Id 6821',2302.80,0.00,0.00,3.03,336.33,'2023-02-14 12:07:21','',''),(6670,'1','306','1',1,'Retail Sale Id 6822',9120.00,0.00,0.00,12.00,1332.00,'2023-02-14 12:13:43','',''),(6671,'1','306','1',1,'Retail Sale Id 6823',4560.00,0.00,0.00,6.00,666.00,'2023-02-14 12:31:17','',''),(6672,'1','306','1',1,'Retail Sale Id 6824',9500.00,0.00,0.00,12.50,1387.50,'2023-02-14 12:40:37','',''),(6673,'1','306','1',1,'Retail Sale Id 6826',1520.00,0.00,0.00,2.00,222.00,'2023-02-14 12:45:15','',''),(6674,'1','306','1',1,'Return of Retail Sale Id 6826',0.00,1520.00,2.00,0.00,-222.00,'2023-02-14 13:17:01','',''),(6675,'1','306','1',1,'Retail Sale Id 6827',1413.60,0.00,0.00,1.86,206.46,'2023-02-14 13:22:08','',''),(6676,'1','306','1',1,'Distributed to SAGIR GAS for sales id:5',2368.85,0.00,0.00,3.65,0.00,'2023-02-14 13:30:33','',''),(6677,'1','306',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,3091200.00,4800.00,0.00,0.00,'2023-02-14 14:16:27','',''),(6678,'1','306',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,4800.00,0.00,'2023-02-14 14:18:12','',''),(6679,'1','306','1',1,'Received from bridging 15',0.00,0.00,4800.00,0.00,0.00,'2023-02-14 14:18:12','',''),(6680,'1','306','1',1,'Retail Sale Id 6828',760.00,0.00,0.00,1.00,116.00,'2023-02-14 14:18:59','',''),(6681,'1','306','1',1,'Retail Sale Id 6831',752.40,0.00,0.00,0.99,114.84,'2023-02-14 14:20:16','',''),(6682,'1','306','1',1,'Retail Sale Id 6832',3100.80,0.00,0.00,4.08,473.28,'2023-02-14 14:22:25','',''),(6683,'1','306','1',1,'Retail Sale Id 6833',3800.00,0.00,0.00,5.00,580.00,'2023-02-14 14:26:28','',''),(6684,'1','306','1',1,'Retail Sale Id 6834',3040.00,0.00,0.00,4.00,464.00,'2023-02-14 14:30:12','',''),(6685,'1','306','1',1,'Retail Sale Id 6836',1497.20,0.00,0.00,1.97,228.52,'2023-02-14 14:31:35','',''),(6686,'1','306','1',1,'Retail Sale Id 6837',1003.20,0.00,0.00,1.32,153.12,'2023-02-14 14:33:30','',''),(6687,'1','306','1',1,'Retail Sale Id 6839',1497.20,0.00,0.00,1.97,228.52,'2023-02-14 14:37:54','',''),(6688,'1','306','1',1,'Retail Sale Id 6840',1497.20,0.00,0.00,1.97,228.52,'2023-02-14 14:38:43','',''),(6689,'1','306','1',1,'Retail Sale Id 6841',2302.80,0.00,0.00,3.03,351.48,'2023-02-14 14:52:41','',''),(6690,'1','306','1',1,'Retail Sale Id 6842',798.00,0.00,0.00,1.05,121.80,'2023-02-14 14:56:55','',''),(6691,'1','306','1',1,'Retail Sale Id 6843',2302.80,0.00,0.00,3.03,351.48,'2023-02-14 14:57:45','',''),(6692,'1','306','1',1,'Retail Sale Id 6844',4560.00,0.00,0.00,6.00,696.00,'2023-02-14 15:01:54','',''),(6693,'1','306','1',1,'Retail Sale Id 6845',3800.00,0.00,0.00,5.00,580.00,'2023-02-14 15:09:59','',''),(6694,'1','306','1',1,'Retail Sale Id 6846',3800.00,0.00,0.00,5.00,580.00,'2023-02-14 15:20:18','',''),(6695,'1','306','1',1,'Retail Sale Id 6847',4560.00,0.00,0.00,6.00,696.00,'2023-02-14 15:37:50','',''),(6696,'1','306','1',1,'Retail Sale Id 6848',2302.80,0.00,0.00,3.03,351.48,'2023-02-14 15:48:37','',''),(6697,'1','306','1',1,'Retail Sale Id 6849',5000.80,0.00,0.00,6.58,763.28,'2023-02-14 15:50:14','',''),(6698,'1','306','1',1,'Retail Sale Id 6850',798.00,0.00,0.00,1.05,121.80,'2023-02-14 15:57:58','',''),(6699,'1','306','1',1,'Retail Sale Id 6851',2302.80,0.00,0.00,3.03,351.48,'2023-02-14 15:59:02','',''),(6700,'1','306','1',1,'Retail Sale Id 6852',2302.80,0.00,0.00,3.03,351.48,'2023-02-14 15:59:59','',''),(6701,'1','306','1',1,'Retail Sale Id 6853',1497.20,0.00,0.00,1.97,228.52,'2023-02-14 16:04:12','',''),(6702,'1','306','1',1,'Retail Sale Id 6854',21599.20,0.00,0.00,28.42,3296.72,'2023-02-14 18:06:27','',''),(6703,'1','306','1',1,'Retail Sale Id 6855',2302.80,0.00,0.00,3.03,351.48,'2023-02-14 18:07:47','',''),(6704,'1','306','1',1,'Retail Sale Id 6856',5947.20,0.00,0.00,8.26,627.76,'2023-02-14 18:09:46','',''),(6705,'1','306','1',1,'Retail Sale Id 6858',3002.40,0.00,0.00,4.17,316.92,'2023-02-14 18:12:24','',''),(6706,'1','306','1',1,'Retail Sale Id 6860',7920.00,0.00,0.00,11.00,836.00,'2023-02-14 18:13:50','',''),(6707,'1','306','1',1,'Retail Sale Id 6861',2249.60,0.00,0.00,2.96,343.36,'2023-02-14 18:14:54','',''),(6708,'1','306','1',1,'Retail Sale Id 6862',1497.20,0.00,0.00,1.97,228.52,'2023-02-14 18:15:57','',''),(6709,'1','306','1',1,'Return of Retail Sale Id 6858',0.00,3002.40,4.17,0.00,-316.92,'2023-02-14 18:28:18','',''),(6710,'1','306','1',1,'Retail Sale Id 6863',2844.00,0.00,0.00,3.95,300.20,'2023-02-14 18:30:00','',''),(6711,'1','306','1',1,'Retail Sale Id 6864',5320.00,0.00,0.00,7.00,812.00,'2023-02-14 18:31:28','',''),(6712,'1','306','1',1,'Retail Sale Id 6865',2280.00,0.00,0.00,3.00,348.00,'2023-02-15 07:08:30','',''),(6713,'1','306','1',1,'Retail Sale Id 6866',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 07:26:44','',''),(6714,'1','306','1',1,'Retail Sale Id 6867',1520.00,0.00,0.00,2.00,232.00,'2023-02-15 07:52:09','',''),(6715,'1','306','1',1,'Retail Sale Id 6868',9500.00,0.00,0.00,12.50,1450.00,'2023-02-15 08:01:21','',''),(6716,'1','306','1',1,'Retail Sale Id 6869',9120.00,0.00,0.00,12.00,1392.00,'2023-02-15 08:05:26','',''),(6717,'1','306','1',1,'Retail Sale Id 6870',9500.00,0.00,0.00,12.50,1450.00,'2023-02-15 08:13:34','',''),(6718,'1','306','1',1,'Retail Sale Id 6872',2401.60,0.00,0.00,3.16,366.56,'2023-02-15 08:21:28','',''),(6719,'1','306','1',1,'Retail Sale Id 6873',798.00,0.00,0.00,1.05,121.80,'2023-02-15 08:25:35','',''),(6720,'1','306','1',1,'Retail Sale Id 6874',9500.00,0.00,0.00,12.50,1450.00,'2023-02-15 08:31:12','',''),(6721,'1','306','1',1,'Retail Sale Id 6876',5000.80,0.00,0.00,6.58,763.28,'2023-02-15 08:47:07','',''),(6722,'1','306','1',1,'Retail Sale Id 6877',3070.40,0.00,0.00,4.04,468.64,'2023-02-15 08:55:08','',''),(6723,'1','306','1',1,'Retail Sale Id 6878',3997.60,0.00,0.00,5.26,610.16,'2023-02-15 08:56:05','',''),(6724,'1','306','1',1,'Retail Sale Id 6879',3196.80,0.00,0.00,4.44,337.44,'2023-02-15 08:57:33','',''),(6725,'1','306','1',1,'Retail Sale Id 6880',5000.80,0.00,0.00,6.58,763.28,'2023-02-15 08:59:33','',''),(6726,'1','306','1',1,'Retail Sale Id 6882',1998.80,0.00,0.00,2.63,305.08,'2023-02-15 09:26:30','',''),(6727,'1','306','1',1,'Retail Sale Id 6883',6102.80,0.00,0.00,8.03,931.48,'2023-02-15 09:35:30','',''),(6728,'1','306','1',1,'Retail Sale Id 6884',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 09:43:57','',''),(6729,'1','306','1',1,'Retail Sale Id 6885',4499.20,0.00,0.00,5.92,686.72,'2023-02-15 09:46:49','',''),(6730,'1','306','1',1,'Retail Sale Id 6886',798.00,0.00,0.00,1.05,121.80,'2023-02-15 09:47:44','',''),(6731,'1','306','1',1,'Retail Sale Id 6887',2280.00,0.00,0.00,3.00,348.00,'2023-02-15 09:53:58','',''),(6732,'1','306','1',1,'Retail Sale Id 6888',532.00,0.00,0.00,0.70,81.20,'2023-02-15 10:01:53','',''),(6733,'1','306','1',1,'Retail Sale Id 6889',1003.20,0.00,0.00,1.32,153.12,'2023-02-15 10:03:26','',''),(6734,'1','306','1',1,'Retail Sale Id 6890',3997.60,0.00,0.00,5.26,610.16,'2023-02-15 10:25:30','',''),(6735,'1','306','1',1,'Retail Sale Id 6891',38000.00,0.00,0.00,50.00,5800.00,'2023-02-15 10:32:14','',''),(6736,'1','306','1',1,'Retail Sale Id 6892',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 10:33:44','',''),(6737,'1','306','1',1,'Retail Sale Id 6893',2302.80,0.00,0.00,3.03,351.48,'2023-02-15 10:43:09','',''),(6738,'1','306','1',1,'Retail Sale Id 6894',3997.60,0.00,0.00,5.26,610.16,'2023-02-15 10:44:08','',''),(6739,'1','306','1',1,'Retail Sale Id 6895',1497.20,0.00,0.00,1.97,228.52,'2023-02-15 10:46:51','',''),(6740,'1','306','1',1,'Retail Sale Id 6896',8360.00,0.00,0.00,11.00,1276.00,'2023-02-15 10:49:17','',''),(6741,'1','306','1',1,'Retail Sale Id 6898',3002.00,0.00,0.00,3.95,458.20,'2023-02-15 10:54:23','',''),(6742,'1','306','1',1,'Retail Sale Id 6899',5000.80,0.00,0.00,6.58,763.28,'2023-02-15 10:56:13','',''),(6743,'1','306','1',1,'Retail Sale Id 6900',2280.00,0.00,0.00,3.00,348.00,'2023-02-15 10:57:22','',''),(6744,'1','306','1',1,'Retail Sale Id 6901',798.00,0.00,0.00,1.05,121.80,'2023-02-15 10:58:09','',''),(6745,'1','306','1',1,'Retail Sale Id 6902',5000.80,0.00,0.00,6.58,763.28,'2023-02-15 11:01:04','',''),(6746,'1','306','1',1,'Retail Sale Id 6903',3800.00,0.00,0.00,5.00,580.00,'2023-02-15 11:07:27','',''),(6747,'1','306','1',1,'Retail Sale Id 6904',2500.40,0.00,0.00,3.29,381.64,'2023-02-15 11:11:37','',''),(6748,'1','306','1',1,'Retail Sale Id 6905',8002.80,0.00,0.00,10.53,1221.48,'2023-02-15 11:13:58','',''),(6749,'1','306','1',1,'Retail Sale Id 6906',2500.40,0.00,0.00,3.29,381.64,'2023-02-15 11:14:50','',''),(6750,'1','306','1',1,'Retail Sale Id 6907',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 11:16:48','',''),(6751,'1','306','1',1,'Retail Sale Id 6908',2280.00,0.00,0.00,3.00,348.00,'2023-02-15 11:20:22','',''),(6752,'1','306','1',1,'Retail Sale Id 6909',2280.00,0.00,0.00,3.00,348.00,'2023-02-15 11:25:28','',''),(6753,'1','306','1',1,'Retail Sale Id 6910',9120.00,0.00,0.00,12.00,1392.00,'2023-02-15 11:27:36','',''),(6754,'1','306','1',1,'Retail Sale Id 6911',4499.20,0.00,0.00,5.92,686.72,'2023-02-15 11:29:45','',''),(6755,'1','306','1',1,'Retail Sale Id 6913',1003.20,0.00,0.00,1.32,153.12,'2023-02-15 11:43:50','',''),(6756,'1','306','1',1,'Retail Sale Id 6914',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 11:45:15','',''),(6757,'1','306','1',1,'Retail Sale Id 6916',11520.00,0.00,0.00,16.00,1216.00,'2023-02-15 11:48:35','',''),(6758,'1','306','1',1,'Retail Sale Id 6917',9500.00,0.00,0.00,12.50,1450.00,'2023-02-15 11:50:09','',''),(6759,'1','306','1',1,'Retail Sale Id 6917',9500.00,0.00,0.00,12.50,1450.00,'2023-02-15 11:50:09','',''),(6760,'1','306','1',1,'Retail Sale Id 6918',3800.00,0.00,0.00,5.00,580.00,'2023-02-15 11:51:33','',''),(6761,'1','306','1',1,'Retail Sale Id 6919',2280.00,0.00,0.00,3.00,348.00,'2023-02-15 11:52:50','',''),(6762,'1','306','1',1,'Retail Sale Id 6920',2280.00,0.00,0.00,3.00,348.00,'2023-02-15 11:54:33','',''),(6763,'1','306','1',1,'Retail Sale Id 6921',9500.00,0.00,0.00,12.50,1450.00,'2023-02-15 11:55:29','',''),(6764,'1','306','1',1,'Retail Sale Id 6922',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 11:56:09','',''),(6765,'1','306','1',1,'Retail Sale Id 6923',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 11:57:02','',''),(6766,'1','306','1',1,'Retail Sale Id 6924',7980.00,0.00,0.00,10.50,1218.00,'2023-02-15 11:57:54','',''),(6767,'1','306','1',1,'Retail Sale Id 6925',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 11:59:13','',''),(6768,'1','306','1',1,'Retail Sale Id 6927',9500.00,0.00,0.00,12.50,1450.00,'2023-02-15 12:15:25','',''),(6769,'1','306','1',1,'Retail Sale Id 6928',9360.00,0.00,0.00,13.00,988.00,'2023-02-15 12:42:07','',''),(6770,'1','306','1',1,'Retail Sale Id 6930',10640.00,0.00,0.00,14.00,1624.00,'2023-02-15 12:44:47','',''),(6771,'1','306','1',1,'Retail Sale Id 6931',18720.00,0.00,0.00,26.00,1976.00,'2023-02-15 12:48:44','',''),(6772,'1','306','1',1,'Retail Sale Id 6932',3800.00,0.00,0.00,5.00,580.00,'2023-02-15 12:53:00','',''),(6773,'1','306','1',1,'Retail Sale Id 6933',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 13:09:30','',''),(6774,'1','306','1',1,'Retail Sale Id 6934',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 13:13:25','',''),(6775,'1','306','1',1,'Retail Sale Id 6935',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 13:14:21','',''),(6776,'1','306','1',1,'Retail Sale Id 6936',3040.00,0.00,0.00,4.00,464.00,'2023-02-15 13:19:53','',''),(6777,'1','306','1',1,'Retail Sale Id 6937',760.00,0.00,0.00,1.00,116.00,'2023-02-15 13:24:55','',''),(6778,'1','306','1',1,'Retail Sale Id 6938',23040.00,0.00,0.00,32.00,2432.00,'2023-02-15 13:33:39','',''),(6779,'1','306','1',1,'Retail Sale Id 6939',9500.00,0.00,0.00,12.50,1450.00,'2023-02-15 13:36:45','',''),(6780,'1','306','1',1,'Retail Sale Id 6940',3040.00,0.00,0.00,4.00,464.00,'2023-02-15 13:39:23','',''),(6781,'1','306','1',1,'Retail Sale Id 6941',3800.00,0.00,0.00,5.00,580.00,'2023-02-15 13:41:10','',''),(6782,'1','306','1',1,'Retail Sale Id 6941',9500.00,0.00,0.00,12.50,1450.00,'2023-02-15 13:41:10','',''),(6783,'1','306','1',1,'Retail Sale Id 6942',3040.00,0.00,0.00,4.00,464.00,'2023-02-15 13:43:04','',''),(6784,'1','306','1',1,'Retail Sale Id 6943',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 13:45:45','',''),(6785,'1','306','1',1,'Retail Sale Id 6944',2280.00,0.00,0.00,3.00,348.00,'2023-02-15 13:48:45','',''),(6786,'1','306','1',1,'Retail Sale Id 6945',3040.00,0.00,0.00,4.00,464.00,'2023-02-15 13:50:29','',''),(6787,'1','306','1',1,'Retail Sale Id 6946',9500.00,0.00,0.00,12.50,1450.00,'2023-02-15 13:52:33','',''),(6788,'1','306','1',1,'Retail Sale Id 6947',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 14:05:29','',''),(6789,'1','306','1',1,'Retail Sale Id 6948',10800.00,0.00,0.00,15.00,1140.00,'2023-02-15 14:07:23','',''),(6790,'1','306','1',1,'Retail Sale Id 6949',2302.80,0.00,0.00,3.03,351.48,'2023-02-15 14:14:28','',''),(6791,'1','306','1',1,'Retail Sale Id 6950',2280.00,0.00,0.00,3.00,348.00,'2023-02-15 14:20:48','',''),(6792,'1','306','1',1,'Retail Sale Id 6951',9500.00,0.00,0.00,12.50,1450.00,'2023-02-15 14:23:53','',''),(6793,'1','306','1',1,'Retail Sale Id 6952',1497.20,0.00,0.00,1.97,228.52,'2023-02-15 14:38:00','',''),(6794,'1','306','1',1,'Retail Sale Id 6953',7600.00,0.00,0.00,10.00,1160.00,'2023-02-15 14:40:48','',''),(6795,'1','306','1',1,'Retail Sale Id 6955',3040.00,0.00,0.00,4.00,464.00,'2023-02-15 14:43:05','',''),(6796,'1','306','1',1,'Retail Sale Id 6956',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 14:43:52','',''),(6797,'1','306','1',1,'Retail Sale Id 6957',9500.00,0.00,0.00,12.50,1450.00,'2023-02-15 14:51:58','',''),(6798,'1','306','1',1,'Retail Sale Id 6958',7600.00,0.00,0.00,10.00,1160.00,'2023-02-15 14:54:47','',''),(6799,'1','306','1',1,'Retail Sale Id 6960',2302.80,0.00,0.00,3.03,351.48,'2023-02-15 15:15:29','',''),(6800,'1','306','1',1,'Retail Sale Id 6961',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 15:22:34','',''),(6801,'1','306','1',1,'Retail Sale Id 6962',501.60,0.00,0.00,0.66,76.56,'2023-02-15 15:23:53','',''),(6802,'1','306','1',1,'Retail Sale Id 6963',1003.20,0.00,0.00,1.32,153.12,'2023-02-15 15:24:40','',''),(6803,'1','306','1',1,'Retail Sale Id 6964',9500.00,0.00,0.00,12.50,1450.00,'2023-02-15 15:26:51','',''),(6804,'1','306','1',1,'Retail Sale Id 6965',2280.00,0.00,0.00,3.00,348.00,'2023-02-15 15:28:16','',''),(6805,'1','306','1',1,'Retail Sale Id 6966',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 15:29:39','',''),(6806,'1','306','1',1,'Retail Sale Id 6967',1512.40,0.00,0.00,1.99,230.84,'2023-02-15 15:33:40','',''),(6807,'1','306','1',1,'Retail Sale Id 6968',3040.00,0.00,0.00,4.00,464.00,'2023-02-15 15:35:38','',''),(6808,'1','306','1',1,'Retail Sale Id 6969',5000.80,0.00,0.00,6.58,763.28,'2023-02-15 15:36:56','',''),(6809,'1','306','1',1,'Retail Sale Id 6970',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 15:39:37','',''),(6810,'1','306','1',1,'Retail Sale Id 6971',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 15:41:38','',''),(6811,'1','306','1',1,'Retail Sale Id 6972',2280.00,0.00,0.00,3.00,348.00,'2023-02-15 15:46:32','',''),(6812,'1','306','1',1,'Retail Sale Id 6973',1998.80,0.00,0.00,2.63,305.08,'2023-02-15 15:49:40','',''),(6813,'1','306','1',1,'Retail Sale Id 6974',2280.00,0.00,0.00,3.00,348.00,'2023-02-15 15:51:01','',''),(6814,'1','306','1',1,'Retail Sale Id 6976',1497.20,0.00,0.00,1.97,228.52,'2023-02-15 15:52:32','',''),(6815,'1','306','1',1,'Retail Sale Id 6977',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 16:07:51','',''),(6816,'1','306','1',1,'Retail Sale Id 6979',3503.60,0.00,0.00,4.61,534.76,'2023-02-15 16:12:19','',''),(6817,'1','306','1',1,'Retail Sale Id 6980',1003.20,0.00,0.00,1.32,153.12,'2023-02-15 16:15:26','',''),(6818,'1','306','1',1,'Retail Sale Id 6980',1003.20,0.00,0.00,1.32,153.12,'2023-02-15 16:15:26','',''),(6819,'1','306','1',1,'Retail Sale Id 6981',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 16:17:19','',''),(6820,'1','306','1',1,'Retail Sale Id 6982',1520.00,0.00,0.00,2.00,232.00,'2023-02-15 16:21:27','',''),(6821,'1','306','1',1,'Retail Sale Id 6984',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 16:36:34','',''),(6822,'1','306','1',1,'Retail Sale Id 6985',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 16:39:44','',''),(6823,'1','306','1',1,'Retail Sale Id 6986',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 16:42:22','',''),(6824,'1','306','1',1,'Retail Sale Id 6988',9500.00,0.00,0.00,12.50,1450.00,'2023-02-15 16:45:32','',''),(6825,'1','306','1',1,'Retail Sale Id 6989',3040.00,0.00,0.00,4.00,464.00,'2023-02-15 16:48:12','',''),(6826,'1','306','1',1,'Retail Sale Id 6990',3040.00,0.00,0.00,4.00,464.00,'2023-02-15 16:49:21','',''),(6827,'1','306','1',1,'Retail Sale Id 6991',798.00,0.00,0.00,1.05,121.80,'2023-02-15 16:50:33','',''),(6828,'1','306','1',1,'Retail Sale Id 6992',2280.00,0.00,0.00,3.00,348.00,'2023-02-15 16:52:02','',''),(6829,'1','306','1',1,'Retail Sale Id 6993',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 16:55:29','',''),(6830,'1','306','1',1,'Retail Sale Id 6994',9500.00,0.00,0.00,12.50,1450.00,'2023-02-15 16:57:23','',''),(6831,'1','306','1',1,'Retail Sale Id 6995',10640.00,0.00,0.00,14.00,1624.00,'2023-02-15 16:59:22','',''),(6832,'1','306','1',1,'Retail Sale Id 6996',20160.00,0.00,0.00,28.00,2128.00,'2023-02-15 17:03:45','',''),(6833,'1','306','1',1,'Retail Sale Id 6997',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 17:05:29','',''),(6834,'1','306','1',1,'Retail Sale Id 6998',1003.20,0.00,0.00,1.32,153.12,'2023-02-15 17:10:05','',''),(6835,'1','306','1',1,'Retail Sale Id 6999',6057.20,0.00,0.00,7.97,924.52,'2023-02-15 17:11:15','',''),(6836,'1','306','1',1,'Retail Sale Id 7000',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 17:12:29','',''),(6837,'1','306','1',1,'Retail Sale Id 7001',9500.00,0.00,0.00,12.50,1450.00,'2023-02-15 17:13:46','',''),(6838,'1','306','1',1,'Retail Sale Id 7003',2280.00,0.00,0.00,3.00,348.00,'2023-02-15 17:17:07','',''),(6839,'1','306','1',1,'Retail Sale Id 7004',5000.80,0.00,0.00,6.58,763.28,'2023-02-15 17:18:18','',''),(6840,'1','306','1',1,'Retail Sale Id 7005',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 17:19:32','',''),(6841,'1','306','1',1,'Retail Sale Id 7007',3100.80,0.00,0.00,4.08,473.28,'2023-02-15 17:23:19','',''),(6842,'1','306','1',1,'Retail Sale Id 7008',18720.00,0.00,0.00,26.00,1976.00,'2023-02-15 17:25:19','',''),(6843,'1','306','1',1,'Retail Sale Id 7009',1520.00,0.00,0.00,2.00,232.00,'2023-02-15 17:26:41','',''),(6844,'1','306','1',1,'Retail Sale Id 7011',3997.60,0.00,0.00,5.26,610.16,'2023-02-15 17:28:04','',''),(6845,'1','306','1',1,'Retail Sale Id 7013',2280.00,0.00,0.00,3.00,348.00,'2023-02-15 17:32:54','',''),(6846,'1','306','1',1,'Retail Sale Id 7015',5000.80,0.00,0.00,6.58,763.28,'2023-02-15 17:35:09','',''),(6847,'1','306','1',1,'Retail Sale Id 7016',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 17:38:04','',''),(6848,'1','306','1',1,'Retail Sale Id 7017',4552.40,0.00,0.00,5.99,694.84,'2023-02-15 17:39:51','',''),(6849,'1','306','1',1,'Retail Sale Id 7018',1520.00,0.00,0.00,2.00,232.00,'2023-02-15 17:42:02','',''),(6850,'1','306','1',1,'Retail Sale Id 7019',760.00,0.00,0.00,1.00,116.00,'2023-02-15 17:46:51','',''),(6851,'1','306','1',1,'Retail Sale Id 7020',2280.00,0.00,0.00,3.00,348.00,'2023-02-15 17:56:44','',''),(6852,'1','306','1',1,'Retail Sale Id 7021',5320.00,0.00,0.00,7.00,812.00,'2023-02-15 17:57:37','',''),(6853,'1','306','1',1,'Retail Sale Id 7022',1702.40,0.00,0.00,2.24,259.84,'2023-02-15 18:01:25','',''),(6854,'1','306','1',1,'Retail Sale Id 7023',2280.00,0.00,0.00,3.00,348.00,'2023-02-15 18:05:57','',''),(6855,'1','306','1',1,'Retail Sale Id 7024',9120.00,0.00,0.00,12.00,1392.00,'2023-02-15 18:07:39','',''),(6856,'1','306','1',1,'Retail Sale Id 7025',2196.40,0.00,0.00,2.89,335.24,'2023-02-15 18:08:35','',''),(6857,'1','306','1',1,'Retail Sale Id 7026',4560.00,0.00,0.00,6.00,696.00,'2023-02-15 18:16:15','',''),(6858,'1','306','1',1,'Retail Sale Id 7027',1497.20,0.00,0.00,1.97,228.52,'2023-02-15 18:19:35','',''),(6859,'1','306','1',1,'Return of Retail Sale Id 6948',0.00,10800.00,15.00,0.00,-1140.00,'2023-02-15 18:38:37','',''),(6860,'1','306','1',1,'Retail Sale Id 7028',6314.40,0.00,0.00,8.77,666.52,'2023-02-15 18:39:41','',''),(6861,'1','306','1',1,'Retail Sale Id 7029',4628.40,0.00,0.00,6.09,706.44,'2023-02-15 18:40:57','',''),(6862,'1','306','1',1,'Retail Sale Id 7030',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 07:26:01','',''),(6863,'1','306','1',1,'Retail Sale Id 7031',7600.00,0.00,0.00,10.00,1160.00,'2023-02-16 07:28:06','',''),(6864,'1','306','1',1,'Retail Sale Id 7032',1003.20,0.00,0.00,1.32,153.12,'2023-02-16 07:39:16','',''),(6865,'1','306','1',1,'Retail Sale Id 7033',3040.00,0.00,0.00,4.00,464.00,'2023-02-16 07:47:59','',''),(6866,'1','306','1',1,'Retail Sale Id 7034',1520.00,0.00,0.00,2.00,232.00,'2023-02-16 07:49:22','',''),(6867,'1','306','1',1,'Retail Sale Id 7035',9000.00,0.00,0.00,12.50,950.00,'2023-02-16 07:51:35','',''),(6868,'1','306','1',1,'Retail Sale Id 7036',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 08:10:09','',''),(6869,'1','306','1',1,'Retail Sale Id 7037',1520.00,0.00,0.00,2.00,232.00,'2023-02-16 08:14:59','',''),(6870,'1','306','1',1,'Retail Sale Id 7038',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 08:17:03','',''),(6871,'1','306','1',1,'Retail Sale Id 7039',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 08:18:18','',''),(6872,'1','306','1',1,'Retail Sale Id 7040',5000.80,0.00,0.00,6.58,763.28,'2023-02-16 08:24:40','',''),(6873,'1','306','1',1,'Retail Sale Id 7041',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 08:29:53','',''),(6874,'1','306','1',1,'Retail Sale Id 7042',9500.00,0.00,0.00,12.50,1450.00,'2023-02-16 08:31:14','',''),(6875,'1','306','1',1,'Retail Sale Id 7043',7600.00,0.00,0.00,10.00,1160.00,'2023-02-16 08:38:00','',''),(6876,'1','306','1',1,'Retail Sale Id 7044',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 08:39:10','',''),(6877,'1','306','1',1,'Retail Sale Id 7045',3040.00,0.00,0.00,4.00,464.00,'2023-02-16 08:40:28','',''),(6878,'1','306','1',1,'Retail Sale Id 7046',1520.00,0.00,0.00,2.00,232.00,'2023-02-16 08:41:27','',''),(6879,'1','306','1',1,'Retail Sale Id 7047',7600.00,0.00,0.00,10.00,1160.00,'2023-02-16 08:45:27','',''),(6880,'1','306','1',1,'Retail Sale Id 7048',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 08:48:15','',''),(6881,'1','306','1',1,'Retail Sale Id 7050',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 08:49:46','',''),(6882,'1','306','1',1,'Retail Sale Id 7050',9500.00,0.00,0.00,12.50,1450.00,'2023-02-16 08:49:46','',''),(6883,'1','306','1',1,'Retail Sale Id 7051',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 08:50:48','',''),(6884,'1','306','1',1,'Retail Sale Id 7052',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 08:52:11','',''),(6885,'1','306','1',1,'Retail Sale Id 7053',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 08:54:11','',''),(6886,'1','306','1',1,'Retail Sale Id 7053',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 08:54:11','',''),(6887,'1','306','1',1,'Retail Sale Id 7054',9500.00,0.00,0.00,12.50,1450.00,'2023-02-16 08:55:22','',''),(6888,'1','306','1',1,'Retail Sale Id 7055',3040.00,0.00,0.00,4.00,464.00,'2023-02-16 08:56:14','',''),(6889,'1','306','1',1,'Retail Sale Id 7056',1520.00,0.00,0.00,2.00,232.00,'2023-02-16 08:58:22','',''),(6890,'1','306','1',1,'Retail Sale Id 7057',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 08:59:20','',''),(6891,'1','306','1',1,'Retail Sale Id 7058',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 09:01:16','',''),(6892,'1','306','1',1,'Retail Sale Id 7059',3040.00,0.00,0.00,4.00,464.00,'2023-02-16 09:04:06','',''),(6893,'1','306','1',1,'Retail Sale Id 7060',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 09:06:31','',''),(6894,'1','306','1',1,'Retail Sale Id 7061',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 09:10:58','',''),(6895,'1','306','1',1,'Retail Sale Id 7062',7600.00,0.00,0.00,10.00,1160.00,'2023-02-16 09:12:36','',''),(6896,'1','306','1',1,'Retail Sale Id 7063',1998.80,0.00,0.00,2.63,305.08,'2023-02-16 09:13:48','',''),(6897,'1','306','1',1,'Retail Sale Id 7064',9500.00,0.00,0.00,12.50,1450.00,'2023-02-16 09:14:45','',''),(6898,'1','306','1',1,'Retail Sale Id 7065',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 09:16:12','',''),(6899,'1','306','1',1,'Retail Sale Id 7065',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 09:16:12','',''),(6900,'1','306','1',1,'Retail Sale Id 7066',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 09:20:00','',''),(6901,'1','306','1',1,'Retail Sale Id 7067',5320.00,0.00,0.00,7.00,812.00,'2023-02-16 09:20:59','',''),(6902,'1','306','1',1,'Retail Sale Id 7068',1520.00,0.00,0.00,2.00,232.00,'2023-02-16 09:22:00','',''),(6903,'1','306','1',1,'Retail Sale Id 7069',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 09:30:17','',''),(6904,'1','306','1',1,'Retail Sale Id 7070',798.00,0.00,0.00,1.05,121.80,'2023-02-16 09:31:09','',''),(6905,'1','306','1',1,'Retail Sale Id 7071',3002.00,0.00,0.00,3.95,458.20,'2023-02-16 09:31:58','',''),(6906,'1','306','1',1,'Retail Sale Id 7072',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 09:36:21','',''),(6907,'1','306','1',1,'Retail Sale Id 7073',896.80,0.00,0.00,1.18,136.88,'2023-02-16 09:39:50','',''),(6908,'1','306','1',1,'Retail Sale Id 7074',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 09:41:22','',''),(6909,'1','306','1',1,'Retail Sale Id 7075',9500.00,0.00,0.00,12.50,1450.00,'2023-02-16 09:42:44','',''),(6910,'1','306','1',1,'Retail Sale Id 7076',1520.00,0.00,0.00,2.00,232.00,'2023-02-16 09:43:29','',''),(6911,'1','306','1',1,'Retail Sale Id 7077',6080.00,0.00,0.00,8.00,928.00,'2023-02-16 09:44:26','',''),(6912,'1','306','1',1,'Retail Sale Id 7078',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 09:45:58','',''),(6913,'1','306','1',1,'Retail Sale Id 7080',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 09:48:11','',''),(6914,'1','306','1',1,'Retail Sale Id 7080',6840.00,0.00,0.00,9.00,1044.00,'2023-02-16 09:48:11','',''),(6915,'1','306','1',1,'Retail Sale Id 7081',8360.00,0.00,0.00,11.00,1276.00,'2023-02-16 09:56:42','',''),(6916,'1','306','1',1,'Retail Sale Id 7082',9500.00,0.00,0.00,12.50,1450.00,'2023-02-16 10:02:12','',''),(6917,'1','306','1',1,'Retail Sale Id 7083',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 10:05:54','',''),(6918,'1','306','1',1,'Retail Sale Id 7084',1520.00,0.00,0.00,2.00,232.00,'2023-02-16 10:08:16','',''),(6919,'1','306','1',1,'Retail Sale Id 7085',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 10:10:22','',''),(6920,'1','306','1',1,'Retail Sale Id 7086',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 10:11:12','',''),(6921,'1','306','1',1,'Retail Sale Id 7086',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 10:11:12','',''),(6922,'1','306','1',1,'Retail Sale Id 7088',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 10:16:03','',''),(6923,'1','306','1',1,'Retail Sale Id 7089',1003.20,0.00,0.00,1.32,153.12,'2023-02-16 10:22:54','',''),(6924,'1','306','1',1,'Retail Sale Id 7090',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 10:25:21','',''),(6925,'1','306','1',1,'Retail Sale Id 7091',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 10:26:11','',''),(6926,'1','306','1',1,'Retail Sale Id 7092',1520.00,0.00,0.00,2.00,232.00,'2023-02-16 10:27:58','',''),(6927,'1','306','1',1,'Retail Sale Id 7093',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 10:28:55','',''),(6928,'1','306','1',1,'Retail Sale Id 7094',9500.00,0.00,0.00,12.50,1450.00,'2023-02-16 10:32:20','',''),(6929,'1','306','1',1,'Retail Sale Id 7095',1520.00,0.00,0.00,2.00,232.00,'2023-02-16 10:33:07','',''),(6930,'1','306','1',1,'Retail Sale Id 7096',9500.00,0.00,0.00,12.50,1450.00,'2023-02-16 10:35:07','',''),(6931,'1','306','1',1,'Retail Sale Id 7097',9500.00,0.00,0.00,12.50,1450.00,'2023-02-16 10:53:08','',''),(6932,'1','306','1',1,'Retail Sale Id 7098',1520.00,0.00,0.00,2.00,232.00,'2023-02-16 10:55:22','',''),(6933,'1','306','1',1,'Retail Sale Id 7099',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 10:58:44','',''),(6934,'1','306','1',1,'Retail Sale Id 7101',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 11:04:18','',''),(6935,'1','306','1',1,'Retail Sale Id 7102',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 11:09:39','',''),(6936,'1','306','1',1,'Retail Sale Id 7103',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 11:10:34','',''),(6937,'1','306','1',1,'Retail Sale Id 7104',9500.00,0.00,0.00,12.50,1450.00,'2023-02-16 11:15:16','',''),(6938,'1','306','1',1,'Retail Sale Id 7105',275040.00,0.00,0.00,382.00,29032.00,'2023-02-16 11:24:49','',''),(6939,'1','306','1',1,'Retail Sale Id 7106',3040.00,0.00,0.00,4.00,464.00,'2023-02-16 11:37:01','',''),(6940,'1','306','1',1,'Retail Sale Id 7107',9500.00,0.00,0.00,12.50,1450.00,'2023-02-16 11:45:48','',''),(6941,'1','306','1',1,'Retail Sale Id 7108',1801.20,0.00,0.00,2.37,274.92,'2023-02-16 11:52:58','',''),(6942,'1','306','1',1,'Retail Sale Id 7109',9500.00,0.00,0.00,12.50,1450.00,'2023-02-16 11:54:57','',''),(6943,'1','306','1',1,'Retail Sale Id 7110',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 12:01:16','',''),(6944,'1','306','1',1,'Retail Sale Id 7112',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 12:02:21','',''),(6945,'1','306','1',1,'Retail Sale Id 7113',3040.00,0.00,0.00,4.00,464.00,'2023-02-16 12:07:15','',''),(6946,'1','306','1',1,'Retail Sale Id 7114',1520.00,0.00,0.00,2.00,232.00,'2023-02-16 12:11:55','',''),(6947,'1','306','1',1,'Retail Sale Id 7115',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 12:13:31','',''),(6948,'1','306','1',1,'Retail Sale Id 7116',1520.00,0.00,0.00,2.00,232.00,'2023-02-16 12:15:02','',''),(6949,'1','306','1',1,'Retail Sale Id 7117',798.00,0.00,0.00,1.05,121.80,'2023-02-16 12:20:44','',''),(6950,'1','306','1',1,'Retail Sale Id 7118',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 12:22:16','',''),(6951,'1','306','1',1,'Retail Sale Id 7119',14400.00,0.00,0.00,20.00,1520.00,'2023-02-16 12:27:06','',''),(6952,'1','306','1',1,'Retail Sale Id 7120',1900.00,0.00,0.00,2.50,290.00,'2023-02-16 12:29:21','',''),(6953,'1','306','1',1,'Retail Sale Id 7121',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 12:34:38','',''),(6954,'1','306','1',1,'Retail Sale Id 7122',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 12:44:10','',''),(6955,'1','306','1',1,'Retail Sale Id 7123',1520.00,0.00,0.00,2.00,232.00,'2023-02-16 12:53:34','',''),(6956,'1','306','1',1,'Retail Sale Id 7124',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 12:55:47','',''),(6957,'1','306','1',1,'Retail Sale Id 7124',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 12:55:47','',''),(6958,'1','306','1',1,'Retail Sale Id 7125',50400.00,0.00,0.00,70.00,5320.00,'2023-02-16 12:58:46','',''),(6959,'1','306','1',1,'Retail Sale Id 7126',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 13:01:17','',''),(6960,'1','306','1',1,'Retail Sale Id 7127',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 13:03:08','',''),(6961,'1','306','1',1,'Retail Sale Id 7128',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 13:04:50','',''),(6962,'1','306','1',1,'Retail Sale Id 7129',5320.00,0.00,0.00,7.00,812.00,'2023-02-16 13:05:55','',''),(6963,'1','306','1',1,'Retail Sale Id 7130',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 13:15:25','',''),(6964,'1','306','1',1,'Retail Sale Id 7131',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 13:30:14','',''),(6965,'1','306','1',1,'Retail Sale Id 7132',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 13:36:05','',''),(6966,'1','306','1',1,'Retail Sale Id 7133',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 13:42:35','',''),(6967,'1','306','1',1,'Retail Sale Id 7133',3040.00,0.00,0.00,4.00,464.00,'2023-02-16 13:42:35','',''),(6968,'1','306','1',1,'Retail Sale Id 7134',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 13:44:39','',''),(6969,'1','306','1',1,'Retail Sale Id 7135',1520.00,0.00,0.00,2.00,232.00,'2023-02-16 13:47:15','',''),(6970,'1','306','1',1,'Retail Sale Id 7136',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 13:48:09','',''),(6971,'1','306','1',1,'Retail Sale Id 7137',1520.00,0.00,0.00,2.00,232.00,'2023-02-16 13:49:26','',''),(6972,'1','306','1',1,'Retail Sale Id 7138',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 14:11:46','',''),(6973,'1','306','1',1,'Retail Sale Id 7139',3040.00,0.00,0.00,4.00,464.00,'2023-02-16 14:16:31','',''),(6974,'1','306','1',1,'Retail Sale Id 7140',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 14:18:41','',''),(6975,'1','306','1',1,'Retail Sale Id 7141',9500.00,0.00,0.00,12.50,1450.00,'2023-02-16 14:19:47','',''),(6976,'1','306','1',1,'Retail Sale Id 7142',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 14:23:54','',''),(6977,'1','306','1',1,'Retail Sale Id 7146',1998.80,0.00,0.00,2.63,305.08,'2023-02-16 14:27:59','',''),(6978,'1','306','1',1,'Retail Sale Id 7147',9500.00,0.00,0.00,12.50,1450.00,'2023-02-16 14:29:44','',''),(6979,'1','306','1',1,'Retail Sale Id 7148',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 14:32:12','',''),(6980,'1','306','1',1,'Retail Sale Id 7149',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 14:39:11','',''),(6981,'1','306','1',1,'Retail Sale Id 7150',760.00,0.00,0.00,1.00,116.00,'2023-02-16 14:42:44','',''),(6982,'1','306','1',1,'Retail Sale Id 7151',3040.00,0.00,0.00,4.00,464.00,'2023-02-16 14:45:37','',''),(6983,'1','306','1',1,'Retail Sale Id 7152',1900.00,0.00,0.00,2.50,290.00,'2023-02-16 14:54:09','',''),(6984,'1','306','1',1,'Retail Sale Id 7153',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 14:56:26','',''),(6985,'1','306','1',1,'Retail Sale Id 7154',1520.00,0.00,0.00,2.00,232.00,'2023-02-16 15:02:15','',''),(6986,'1','306','1',1,'Retail Sale Id 7155',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 15:12:38','',''),(6987,'1','306','1',1,'Retail Sale Id 7156',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 15:22:30','',''),(6988,'1','306','1',1,'Retail Sale Id 7157',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 15:28:00','',''),(6989,'1','306','1',1,'Retail Sale Id 7159',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 15:29:51','',''),(6990,'1','306','1',1,'Retail Sale Id 7160',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 15:31:45','',''),(6991,'1','306','1',1,'Retail Sale Id 7161',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 15:33:09','',''),(6992,'1','306','1',1,'Retail Sale Id 7162',1520.00,0.00,0.00,2.00,232.00,'2023-02-16 15:36:01','',''),(6993,'1','306','1',1,'Retail Sale Id 7163',9500.00,0.00,0.00,12.50,1450.00,'2023-02-16 15:37:57','',''),(6994,'1','306','1',1,'Retail Sale Id 7164',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 15:38:31','',''),(6995,'1','306','1',1,'Retail Sale Id 7165',9500.00,0.00,0.00,12.50,1450.00,'2023-02-16 15:39:32','',''),(6996,'1','306','1',1,'Retail Sale Id 7166',1998.80,0.00,0.00,2.63,305.08,'2023-02-16 15:41:09','',''),(6997,'1','306','1',1,'Retail Sale Id 7167',9500.00,0.00,0.00,12.50,1450.00,'2023-02-16 15:42:44','',''),(6998,'1','306','1',1,'Retail Sale Id 7168',3002.00,0.00,0.00,3.95,458.20,'2023-02-16 15:44:06','',''),(6999,'1','306','1',1,'Retail Sale Id 7169',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 15:54:35','',''),(7000,'1','306','1',1,'Retail Sale Id 7170',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 15:58:15','',''),(7001,'1','306','1',1,'Retail Sale Id 7171',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 15:59:15','',''),(7002,'1','306','1',1,'Retail Sale Id 7172',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 16:01:13','',''),(7003,'1','306','1',1,'Retail Sale Id 7173',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 16:07:03','',''),(7004,'1','306','1',1,'Retail Sale Id 7174',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 16:11:26','',''),(7005,'1','306','1',1,'Retail Sale Id 7175',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 16:16:18','',''),(7006,'1','306','1',1,'Retail Sale Id 7176',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 16:16:54','',''),(7007,'1','306','1',1,'Retail Sale Id 7177',8360.00,0.00,0.00,11.00,1276.00,'2023-02-16 16:18:54','',''),(7008,'1','306','1',1,'Retail Sale Id 7179',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 16:27:59','',''),(7009,'1','306','1',1,'Retail Sale Id 7180',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 16:37:28','',''),(7010,'1','306','1',1,'Retail Sale Id 7181',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 16:38:54','',''),(7011,'1','306','1',1,'Retail Sale Id 7182',9500.00,0.00,0.00,12.50,1450.00,'2023-02-16 16:43:06','',''),(7012,'1','306','1',1,'Retail Sale Id 7183',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 16:49:04','',''),(7013,'1','306','1',1,'Retail Sale Id 7184',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 16:49:59','',''),(7014,'1','306','1',1,'Retail Sale Id 7185',1520.00,0.00,0.00,2.00,232.00,'2023-02-16 16:51:39','',''),(7015,'1','306','1',1,'Retail Sale Id 7186',1998.80,0.00,0.00,2.63,305.08,'2023-02-16 16:58:14','',''),(7016,'1','306','1',1,'Retail Sale Id 7188',3040.00,0.00,0.00,4.00,464.00,'2023-02-16 17:07:09','',''),(7017,'1','306','1',1,'Retail Sale Id 7188',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 17:07:09','',''),(7018,'1','306','1',1,'Return of Retail Sale Id 7188',0.00,3040.00,4.00,0.00,-464.00,'2023-02-16 17:12:05','',''),(7019,'1','306','1',1,'Return of Retail Sale Id 7188',0.00,3800.00,5.00,0.00,-580.00,'2023-02-16 17:12:05','',''),(7020,'1','306','1',1,'Retail Sale Id 7189',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 17:16:18','',''),(7021,'1','306','1',1,'Retail Sale Id 7190',2500.40,0.00,0.00,3.29,381.64,'2023-02-16 17:17:26','',''),(7022,'1','306','1',1,'Retail Sale Id 7191',2280.00,0.00,0.00,3.00,348.00,'2023-02-16 17:28:39','',''),(7023,'1','306','1',1,'Retail Sale Id 7192',3040.00,0.00,0.00,4.00,464.00,'2023-02-16 17:30:16','',''),(7024,'1','306','1',1,'Retail Sale Id 7193',4560.00,0.00,0.00,6.00,696.00,'2023-02-16 17:32:04','',''),(7025,'1','306','1',1,'Retail Sale Id 7194',1520.00,0.00,0.00,2.00,232.00,'2023-02-16 17:35:47','',''),(7026,'1','306','1',1,'Retail Sale Id 7194',1520.00,0.00,0.00,2.00,232.00,'2023-02-16 17:35:47','',''),(7027,'1','306','1',1,'Retail Sale Id 7195',3040.00,0.00,0.00,4.00,464.00,'2023-02-16 17:38:51','',''),(7028,'1','306','1',1,'Retail Sale Id 7195',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 17:38:51','',''),(7029,'1','306','1',1,'Retail Sale Id 7196',3040.00,0.00,0.00,4.00,464.00,'2023-02-16 17:40:13','',''),(7030,'1','306','1',1,'Retail Sale Id 7197',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 18:04:45','',''),(7031,'1','306','1',1,'Retail Sale Id 7198',9500.00,0.00,0.00,12.50,1450.00,'2023-02-16 18:21:32','',''),(7032,'1','306','1',1,'Retail Sale Id 7199',1520.00,0.00,0.00,2.00,232.00,'2023-02-16 18:26:08','',''),(7033,'1','306','1',1,'Retail Sale Id 7200',1520.00,0.00,0.00,2.00,232.00,'2023-02-16 18:29:23','',''),(7034,'1','306','1',1,'Retail Sale Id 7201',3800.00,0.00,0.00,5.00,580.00,'2023-02-16 18:30:01','',''),(7035,'1','306','1',1,'Return of Retail Sale Id 7119',0.00,14400.00,20.00,0.00,-1520.00,'2023-02-16 18:39:46','',''),(7036,'1','306','1',1,'Retail Sale Id 7202',5400.00,0.00,0.00,7.50,570.00,'2023-02-16 18:42:40','',''),(7037,'1','306','1',1,'Retail Sale Id 7203',36784.00,0.00,0.00,48.40,5614.40,'2023-02-16 18:45:02','',''),(7038,'1','306','1',1,'Retail Sale Id 7204',4598.00,0.00,0.00,6.05,701.80,'2023-02-17 07:29:04','',''),(7039,'1','306','1',1,'Retail Sale Id 7205',896.80,0.00,0.00,1.18,136.88,'2023-02-17 07:30:03','',''),(7040,'1','306','1',1,'Retail Sale Id 7206',1520.00,0.00,0.00,2.00,232.00,'2023-02-17 07:36:35','',''),(7041,'1','306','1',1,'Retail Sale Id 7207',9500.00,0.00,0.00,12.50,1450.00,'2023-02-17 07:38:02','',''),(7042,'1','306','1',1,'Retail Sale Id 7208',1497.20,0.00,0.00,1.97,228.52,'2023-02-17 07:38:56','',''),(7043,'1','306','1',1,'Retail Sale Id 7209',9500.00,0.00,0.00,12.50,1450.00,'2023-02-17 07:46:04','',''),(7044,'1','306','1',1,'Retail Sale Id 7211',4598.00,0.00,0.00,6.05,701.80,'2023-02-17 07:54:26','',''),(7045,'1','306','1',1,'Retail Sale Id 7212',5320.00,0.00,0.00,7.00,812.00,'2023-02-17 08:02:09','',''),(7046,'1','306','1',1,'Retail Sale Id 7213',9500.00,0.00,0.00,12.50,1450.00,'2023-02-17 08:03:40','',''),(7047,'1','306','1',1,'Retail Sale Id 7214',1497.20,0.00,0.00,1.97,228.52,'2023-02-17 08:05:14','',''),(7048,'1','306','1',1,'Retail Sale Id 7215',3040.00,0.00,0.00,4.00,464.00,'2023-02-17 08:08:04','',''),(7049,'1','306','1',1,'Retail Sale Id 7216',1520.00,0.00,0.00,2.00,232.00,'2023-02-17 08:09:49','',''),(7050,'1','306','1',1,'Retail Sale Id 7218',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 08:13:07','',''),(7051,'1','306','1',1,'Retail Sale Id 7219',7600.00,0.00,0.00,10.00,1160.00,'2023-02-17 08:14:22','',''),(7052,'1','306','1',1,'Retail Sale Id 7222',4598.00,0.00,0.00,6.05,701.80,'2023-02-17 08:19:48','',''),(7053,'1','306','1',1,'Retail Sale Id 7223',4560.00,0.00,0.00,6.00,696.00,'2023-02-17 08:21:44','',''),(7054,'1','306','1',1,'Retail Sale Id 7224',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 08:23:37','',''),(7055,'1','306','1',1,'Retail Sale Id 7225',3002.00,0.00,0.00,3.95,458.20,'2023-02-17 08:24:34','',''),(7056,'1','306','1',1,'Retail Sale Id 7226',127440.00,0.00,0.00,177.00,13452.00,'2023-02-17 08:27:14','',''),(7057,'1','306','1',1,'Retail Sale Id 7227',3800.00,0.00,0.00,5.00,580.00,'2023-02-17 08:29:52','',''),(7058,'1','306','1',1,'Retail Sale Id 7228',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 08:31:28','',''),(7059,'1','306','1',1,'Retail Sale Id 7230',9500.00,0.00,0.00,12.50,1450.00,'2023-02-17 08:34:58','',''),(7060,'1','306','1',1,'Retail Sale Id 7231',3040.00,0.00,0.00,4.00,464.00,'2023-02-17 08:35:47','',''),(7061,'1','306','1',1,'Retail Sale Id 7232',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 08:37:09','',''),(7062,'1','306','1',1,'Retail Sale Id 7232',4560.00,0.00,0.00,6.00,696.00,'2023-02-17 08:37:09','',''),(7063,'1','306','1',1,'Retail Sale Id 7232',5320.00,0.00,0.00,7.00,812.00,'2023-02-17 08:37:09','',''),(7064,'1','306','1',1,'Retail Sale Id 7233',3800.00,0.00,0.00,5.00,580.00,'2023-02-17 08:37:56','',''),(7065,'1','306','1',1,'Retail Sale Id 7234',3800.00,0.00,0.00,5.00,580.00,'2023-02-17 08:38:45','',''),(7066,'1','306','1',1,'Retail Sale Id 7235',1520.00,0.00,0.00,2.00,232.00,'2023-02-17 08:39:51','',''),(7067,'1','306','1',1,'Retail Sale Id 7236',3898.80,0.00,0.00,5.13,595.08,'2023-02-17 08:42:39','',''),(7068,'1','306','1',1,'Retail Sale Id 7237',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 08:46:03','',''),(7069,'1','306','1',1,'Retail Sale Id 7238',3002.00,0.00,0.00,3.95,458.20,'2023-02-17 08:50:58','',''),(7070,'1','306','1',1,'Retail Sale Id 7239',4560.00,0.00,0.00,6.00,696.00,'2023-02-17 09:01:04','',''),(7071,'1','306','1',1,'Retail Sale Id 7240',9120.00,0.00,0.00,12.00,1392.00,'2023-02-17 09:03:20','',''),(7072,'1','306','1',1,'Retail Sale Id 7242',752.40,0.00,0.00,0.99,114.84,'2023-02-17 09:04:36','',''),(7073,'1','306','1',1,'Retail Sale Id 7243',5000.80,0.00,0.00,6.58,763.28,'2023-02-17 09:09:56','',''),(7074,'1','306','1',1,'Retail Sale Id 7244',2302.80,0.00,0.00,3.03,351.48,'2023-02-17 09:11:02','',''),(7075,'1','306','1',1,'Retail Sale Id 7245',1520.00,0.00,0.00,2.00,232.00,'2023-02-17 09:14:32','',''),(7076,'1','306','1',1,'Retail Sale Id 7246',798.00,0.00,0.00,1.05,121.80,'2023-02-17 09:15:34','',''),(7077,'1','306','1',1,'Retail Sale Id 7248',4499.20,0.00,0.00,5.92,686.72,'2023-02-17 09:18:57','',''),(7078,'1','306','1',1,'Retail Sale Id 7249',1497.20,0.00,0.00,1.97,228.52,'2023-02-17 09:20:26','',''),(7079,'1','306','1',1,'Retail Sale Id 7250',3800.00,0.00,0.00,5.00,580.00,'2023-02-17 09:21:38','',''),(7080,'1','306','1',1,'Retail Sale Id 7251',9500.00,0.00,0.00,12.50,1450.00,'2023-02-17 09:24:56','',''),(7081,'1','306','1',1,'Retail Sale Id 7252',3800.00,0.00,0.00,5.00,580.00,'2023-02-17 09:27:57','',''),(7082,'1','306','1',1,'Retail Sale Id 7253',5320.00,0.00,0.00,7.00,812.00,'2023-02-17 09:30:24','',''),(7083,'1','306','1',1,'Retail Sale Id 7254',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 09:34:22','',''),(7084,'1','306','1',1,'Retail Sale Id 7255',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 09:36:02','',''),(7085,'1','306','1',1,'Retail Sale Id 7256',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 09:47:15','',''),(7086,'1','306','1',1,'Retail Sale Id 7257',3002.00,0.00,0.00,3.95,458.20,'2023-02-17 09:48:09','',''),(7087,'1','306','1',1,'Retail Sale Id 7258',4560.00,0.00,0.00,6.00,696.00,'2023-02-17 09:52:11','',''),(7088,'1','306','1',1,'Retail Sale Id 7259',3040.00,0.00,0.00,4.00,464.00,'2023-02-17 09:53:44','',''),(7089,'1','306','1',1,'Retail Sale Id 7260',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 10:04:50','',''),(7090,'1','306','1',1,'Retail Sale Id 7261',7600.00,0.00,0.00,10.00,1160.00,'2023-02-17 10:08:03','',''),(7091,'1','306','1',1,'Retail Sale Id 7262',11400.00,0.00,0.00,15.00,1740.00,'2023-02-17 10:13:22','',''),(7092,'1','306','1',1,'Retail Sale Id 7263',3800.00,0.00,0.00,5.00,580.00,'2023-02-17 10:15:41','',''),(7093,'1','306','1',1,'Retail Sale Id 7264',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 10:18:33','',''),(7094,'1','306','1',1,'Retail Sale Id 7265',4560.00,0.00,0.00,6.00,696.00,'2023-02-17 10:20:19','',''),(7095,'1','306','1',1,'Retail Sale Id 7266',1998.80,0.00,0.00,2.63,305.08,'2023-02-17 10:22:04','',''),(7096,'1','306','1',1,'Retail Sale Id 7267',1520.00,0.00,0.00,2.00,232.00,'2023-02-17 10:24:18','',''),(7097,'1','306','1',1,'Retail Sale Id 7268',4560.00,0.00,0.00,6.00,696.00,'2023-02-17 10:25:59','',''),(7098,'1','306','1',1,'Retail Sale Id 7269',3800.00,0.00,0.00,5.00,580.00,'2023-02-17 10:28:18','',''),(7099,'1','306','1',1,'Retail Sale Id 7270',3997.60,0.00,0.00,5.26,610.16,'2023-02-17 10:31:18','',''),(7100,'1','306','1',1,'Retail Sale Id 7271',1998.80,0.00,0.00,2.63,305.08,'2023-02-17 10:34:12','',''),(7101,'1','306','1',1,'Retail Sale Id 7272',3040.00,0.00,0.00,4.00,464.00,'2023-02-17 10:35:44','',''),(7102,'1','306','1',1,'Retail Sale Id 7273',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 10:37:05','',''),(7103,'1','306','1',1,'Retail Sale Id 7274',10640.00,0.00,0.00,14.00,1624.00,'2023-02-17 10:39:38','',''),(7104,'1','306','1',1,'Retail Sale Id 7275',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 10:42:54','',''),(7105,'1','306','1',1,'Retail Sale Id 7276',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 10:43:22','',''),(7106,'1','306','1',1,'Retail Sale Id 7277',4560.00,0.00,0.00,6.00,696.00,'2023-02-17 10:44:05','',''),(7107,'1','306','1',1,'Retail Sale Id 7278',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 10:49:20','',''),(7108,'1','306','1',1,'Retail Sale Id 7279',2196.40,0.00,0.00,2.89,335.24,'2023-02-17 10:57:12','',''),(7109,'1','306','1',1,'Retail Sale Id 7280',4560.00,0.00,0.00,6.00,696.00,'2023-02-17 11:08:21','',''),(7110,'1','306','1',1,'Retail Sale Id 7281',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 11:12:09','',''),(7111,'1','306','1',1,'Retail Sale Id 7282',1520.00,0.00,0.00,2.00,232.00,'2023-02-17 11:13:36','',''),(7112,'1','306','1',1,'Retail Sale Id 7283',3997.60,0.00,0.00,5.26,610.16,'2023-02-17 11:15:53','',''),(7113,'1','306','1',1,'Retail Sale Id 7285',4560.00,0.00,0.00,6.00,696.00,'2023-02-17 11:22:00','',''),(7114,'1','306','1',1,'Retail Sale Id 7287',3002.00,0.00,0.00,3.95,458.20,'2023-02-17 11:33:15','',''),(7115,'1','306','1',1,'Retail Sale Id 7289',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 11:39:25','',''),(7116,'1','306','1',1,'Retail Sale Id 7290',9500.00,0.00,0.00,12.50,1450.00,'2023-02-17 11:42:53','',''),(7117,'1','306','1',1,'Retail Sale Id 7292',4560.00,0.00,0.00,6.00,696.00,'2023-02-17 11:53:08','',''),(7118,'1','306','1',1,'Retail Sale Id 7293',3800.00,0.00,0.00,5.00,580.00,'2023-02-17 11:55:33','',''),(7119,'1','306','1',1,'Retail Sale Id 7294',3800.00,0.00,0.00,5.00,580.00,'2023-02-17 11:58:05','',''),(7120,'1','306','1',1,'Retail Sale Id 7295',29520.00,0.00,0.00,41.00,3116.00,'2023-02-17 11:59:47','',''),(7121,'1','306','1',1,'Retail Sale Id 7296',3040.00,0.00,0.00,4.00,464.00,'2023-02-17 12:01:10','',''),(7122,'1','306','1',1,'Retail Sale Id 7297',3040.00,0.00,0.00,4.00,464.00,'2023-02-17 12:05:36','',''),(7123,'1','306','1',1,'Retail Sale Id 7298',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 12:07:15','',''),(7124,'1','306','1',1,'Retail Sale Id 7299',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 12:08:58','',''),(7125,'1','306','1',1,'Retail Sale Id 7300',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 12:23:44','',''),(7126,'1','306','1',1,'Retail Sale Id 7301',3800.00,0.00,0.00,5.00,580.00,'2023-02-17 12:24:27','',''),(7127,'1','306','1',1,'Retail Sale Id 7302',1998.80,0.00,0.00,2.63,305.08,'2023-02-17 12:28:46','',''),(7128,'1','306','1',1,'Retail Sale Id 7303',1520.00,0.00,0.00,2.00,232.00,'2023-02-17 12:29:38','',''),(7129,'1','306','1',1,'Retail Sale Id 7304',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 12:35:06','',''),(7130,'1','306','1',1,'Retail Sale Id 7305',7600.00,0.00,0.00,10.00,1160.00,'2023-02-17 12:37:25','',''),(7131,'1','306','1',1,'Retail Sale Id 7306',4560.00,0.00,0.00,6.00,696.00,'2023-02-17 12:38:45','',''),(7132,'1','306','1',1,'Retail Sale Id 7307',7600.00,0.00,0.00,10.00,1160.00,'2023-02-17 12:40:35','',''),(7133,'1','306','1',1,'Retail Sale Id 7308',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 12:42:06','',''),(7134,'1','306','1',1,'Retail Sale Id 7309',1497.20,0.00,0.00,1.97,228.52,'2023-02-17 12:43:24','',''),(7135,'1','306','1',1,'Retail Sale Id 7310',4560.00,0.00,0.00,6.00,696.00,'2023-02-17 12:44:05','',''),(7136,'1','306','1',1,'Retail Sale Id 7311',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 12:47:30','',''),(7137,'1','306','1',1,'Retail Sale Id 7312',3800.00,0.00,0.00,5.00,580.00,'2023-02-17 12:53:42','',''),(7138,'1','306','1',1,'Retail Sale Id 7313',43200.00,0.00,0.00,60.00,4560.00,'2023-02-17 12:56:50','',''),(7139,'1','306','1',1,'Retail Sale Id 7314',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 13:03:59','',''),(7140,'1','306','1',1,'Retail Sale Id 7315',1520.00,0.00,0.00,2.00,232.00,'2023-02-17 13:17:41','',''),(7141,'1','306','1',1,'Retail Sale Id 7316',4598.00,0.00,0.00,6.05,701.80,'2023-02-17 13:19:27','',''),(7142,'1','306','1',1,'Retail Sale Id 7317',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 13:20:54','',''),(7143,'1','306','1',1,'Retail Sale Id 7318',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 13:24:20','',''),(7144,'1','306','1',1,'Retail Sale Id 7319',7600.00,0.00,0.00,10.00,1160.00,'2023-02-17 13:28:34','',''),(7145,'1','306','1',1,'Retail Sale Id 7320',4560.00,0.00,0.00,6.00,696.00,'2023-02-17 13:39:03','',''),(7146,'1','306','1',1,'Retail Sale Id 7321',9500.00,0.00,0.00,12.50,1450.00,'2023-02-17 13:41:23','',''),(7147,'1','306','1',1,'Retail Sale Id 7322',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 13:43:30','',''),(7148,'1','306','1',1,'Retail Sale Id 7323',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 13:49:10','',''),(7149,'1','306','1',1,'Retail Sale Id 7324',3800.00,0.00,0.00,5.00,580.00,'2023-02-17 13:51:00','',''),(7150,'1','306','1',1,'Retail Sale Id 7327',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 13:59:15','',''),(7151,'1','306','1',1,'Retail Sale Id 7328',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 14:03:40','',''),(7152,'1','306','1',1,'Retail Sale Id 7330',1497.20,0.00,0.00,1.97,228.52,'2023-02-17 14:06:53','',''),(7153,'1','306','1',1,'Retail Sale Id 7331',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 14:11:48','',''),(7154,'1','306','1',1,'Retail Sale Id 7332',4560.00,0.00,0.00,6.00,696.00,'2023-02-17 14:15:05','',''),(7155,'1','306','1',1,'Retail Sale Id 7333',9500.00,0.00,0.00,12.50,1450.00,'2023-02-17 14:16:27','',''),(7156,'1','306','1',1,'Retail Sale Id 7334',2302.80,0.00,0.00,3.03,351.48,'2023-02-17 14:17:55','',''),(7157,'1','306','1',1,'Retail Sale Id 7335',18000.00,0.00,0.00,25.00,1900.00,'2023-02-17 14:21:08','',''),(7158,'1','306','1',1,'Retail Sale Id 7336',1497.20,0.00,0.00,1.97,228.52,'2023-02-17 14:22:17','',''),(7159,'1','306','1',1,'Retail Sale Id 7337',83520.00,0.00,0.00,116.00,8816.00,'2023-02-17 14:27:37','',''),(7160,'1','306','1',1,'Retail Sale Id 7339',2302.80,0.00,0.00,3.03,351.48,'2023-02-17 14:30:04','',''),(7161,'1','306','1',1,'Retail Sale Id 7340',9120.00,0.00,0.00,12.00,1392.00,'2023-02-17 14:47:59','',''),(7162,'1','306','1',1,'Retail Sale Id 7341',4560.00,0.00,0.00,6.00,696.00,'2023-02-17 14:52:02','',''),(7163,'1','306','1',1,'Retail Sale Id 7343',3800.00,0.00,0.00,5.00,580.00,'2023-02-17 14:57:59','',''),(7164,'1','306','1',1,'Return of Retail Sale Id 7340',0.00,9120.00,12.00,0.00,-1392.00,'2023-02-17 15:05:01','',''),(7165,'1','306','1',1,'Retail Sale Id 7344',6900.80,0.00,0.00,9.08,1053.28,'2023-02-17 15:28:17','',''),(7166,'1','306','1',1,'Retail Sale Id 7345',1003.20,0.00,0.00,1.32,153.12,'2023-02-17 15:34:42','',''),(7167,'1','306','1',1,'Retail Sale Id 7346',4560.00,0.00,0.00,6.00,696.00,'2023-02-17 15:36:23','',''),(7168,'1','306','1',1,'Retail Sale Id 7347',1520.00,0.00,0.00,2.00,232.00,'2023-02-17 15:44:03','',''),(7169,'1','306','1',1,'Retail Sale Id 7348',3002.00,0.00,0.00,3.95,458.20,'2023-02-17 15:49:30','',''),(7170,'1','306','1',1,'Retail Sale Id 7349',3002.00,0.00,0.00,3.95,458.20,'2023-02-17 15:52:57','',''),(7171,'1','306','1',1,'Retail Sale Id 7350',4560.00,0.00,0.00,6.00,696.00,'2023-02-17 16:19:44','',''),(7172,'1','306','1',1,'Retail Sale Id 7351',1497.20,0.00,0.00,1.97,228.52,'2023-02-17 16:26:37','',''),(7173,'1','306','1',1,'Retail Sale Id 7352',10800.00,0.00,0.00,15.00,1140.00,'2023-02-17 16:28:30','',''),(7174,'1','306','1',1,'Retail Sale Id 7353',1003.20,0.00,0.00,1.32,153.12,'2023-02-17 16:30:11','',''),(7175,'1','306','1',1,'Retail Sale Id 7354',3800.00,0.00,0.00,5.00,580.00,'2023-02-17 16:34:30','',''),(7176,'1','306','1',1,'Retail Sale Id 7355',4560.00,0.00,0.00,6.00,696.00,'2023-02-17 16:36:30','',''),(7177,'1','306','1',1,'Retail Sale Id 7356',1998.80,0.00,0.00,2.63,305.08,'2023-02-17 16:38:59','',''),(7178,'1','306','1',1,'Retail Sale Id 7357',1520.00,0.00,0.00,2.00,232.00,'2023-02-17 16:41:55','',''),(7179,'1','306','1',1,'Retail Sale Id 7357',1520.00,0.00,0.00,2.00,232.00,'2023-02-17 16:41:55','',''),(7180,'1','306','1',1,'Retail Sale Id 7358',1003.20,0.00,0.00,1.32,153.12,'2023-02-17 16:43:54','',''),(7181,'1','306','1',1,'Retail Sale Id 7359',2280.00,0.00,0.00,3.00,348.00,'2023-02-17 16:48:53','',''),(7182,'1','306','1',1,'Retail Sale Id 7360',798.00,0.00,0.00,1.05,121.80,'2023-02-17 16:55:16','',''),(7183,'1','306','1',1,'Retail Sale Id 7361',4499.20,0.00,0.00,5.92,686.72,'2023-02-17 17:03:20','',''),(7184,'1','306','1',1,'Retail Sale Id 7362',1520.00,0.00,0.00,2.00,232.00,'2023-02-17 17:05:33','',''),(7185,'1','306','1',1,'Retail Sale Id 7363',1998.80,0.00,0.00,2.63,305.08,'2023-02-17 17:07:56','',''),(7186,'1','306','1',1,'Retail Sale Id 7365',1998.80,0.00,0.00,2.63,305.08,'2023-02-17 17:23:12','',''),(7187,'1','306','1',1,'Retail Sale Id 7366',2302.80,0.00,0.00,3.03,351.48,'2023-02-17 17:31:12','',''),(7188,'1','306','1',1,'Retail Sale Id 7368',2302.80,0.00,0.00,3.03,351.48,'2023-02-17 17:36:10','',''),(7189,'1','306','1',1,'Retail Sale Id 7369',2302.80,0.00,0.00,3.03,351.48,'2023-02-17 17:39:19','',''),(7190,'1','306','1',1,'Retail Sale Id 7370',1998.80,0.00,0.00,2.63,305.08,'2023-02-17 17:40:36','',''),(7191,'1','306','1',1,'Retail Sale Id 7371',3040.00,0.00,0.00,4.00,464.00,'2023-02-17 17:41:22','',''),(7192,'1','306','1',1,'Retail Sale Id 7372',2660.00,0.00,0.00,3.50,406.00,'2023-02-17 17:43:33','',''),(7193,'1','306','1',1,'Retail Sale Id 7375',2500.40,0.00,0.00,3.29,381.64,'2023-02-17 17:50:28','',''),(7194,'1','306','1',1,'Retail Sale Id 7377',3040.00,0.00,0.00,4.00,464.00,'2023-02-17 17:53:55','',''),(7195,'1','306','1',1,'Retail Sale Id 7378',1998.80,0.00,0.00,2.63,305.08,'2023-02-17 18:02:55','',''),(7196,'1','306','1',1,'Retail Sale Id 7379',9500.00,0.00,0.00,12.50,1450.00,'2023-02-17 18:10:02','',''),(7197,'1','306','1',1,'Retail Sale Id 7381',1497.20,0.00,0.00,1.97,228.52,'2023-02-17 18:12:33','',''),(7198,'1','306','1',1,'Return of Retail Sale Id 7379',0.00,9500.00,12.50,0.00,-1450.00,'2023-02-17 18:41:24','',''),(7199,'1','306','1',1,'Return of Retail Sale Id 7352',0.00,10800.00,15.00,0.00,-1140.00,'2023-02-17 18:41:50','',''),(7200,'1','306','1',1,'Retail Sale Id 7382',10548.00,0.00,0.00,14.65,1113.40,'2023-02-17 18:43:10','',''),(7201,'1','306','1',1,'Retail Sale Id 7383',7212.40,0.00,0.00,9.49,1100.84,'2023-02-17 18:44:15','',''),(7202,'1','306','1',1,'Retail Sale Id 7384',4560.00,0.00,0.00,6.00,696.00,'2023-02-18 07:18:33','',''),(7203,'1','306','1',1,'Retail Sale Id 7385',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 07:26:25','',''),(7204,'1','306','1',1,'Retail Sale Id 7386',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 07:38:50','',''),(7205,'1','306','1',1,'Retail Sale Id 7387',3800.00,0.00,0.00,5.00,580.00,'2023-02-18 07:47:29','',''),(7206,'1','306','1',1,'Retail Sale Id 7388',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 07:59:45','',''),(7207,'1','306','1',1,'Retail Sale Id 7389',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 08:01:35','',''),(7208,'1','306','1',1,'Retail Sale Id 7390',3800.00,0.00,0.00,5.00,580.00,'2023-02-18 08:05:42','',''),(7209,'1','306','1',1,'Retail Sale Id 7391',4560.00,0.00,0.00,6.00,696.00,'2023-02-18 08:07:46','',''),(7210,'1','306','1',1,'Retail Sale Id 7392',699.20,0.00,0.00,0.92,106.72,'2023-02-18 08:10:20','',''),(7211,'1','306','1',1,'Retail Sale Id 7392',1497.20,0.00,0.00,1.97,228.52,'2023-02-18 08:10:20','',''),(7212,'1','306','1',1,'Retail Sale Id 7393',798.00,0.00,0.00,1.05,121.80,'2023-02-18 08:11:16','',''),(7213,'1','306','1',1,'Retail Sale Id 7394',3040.00,0.00,0.00,4.00,464.00,'2023-02-18 08:15:42','',''),(7214,'1','306','1',1,'Retail Sale Id 7395',4560.00,0.00,0.00,6.00,696.00,'2023-02-18 08:18:09','',''),(7215,'1','306','1',1,'Retail Sale Id 7396',1520.00,0.00,0.00,2.00,232.00,'2023-02-18 08:21:49','',''),(7216,'1','306','1',1,'Retail Sale Id 7397',4560.00,0.00,0.00,6.00,696.00,'2023-02-18 08:23:26','',''),(7217,'1','306','1',1,'Retail Sale Id 7398',3800.00,0.00,0.00,5.00,580.00,'2023-02-18 08:25:22','',''),(7218,'1','306','1',1,'Retail Sale Id 7399',6080.00,0.00,0.00,8.00,928.00,'2023-02-18 08:26:31','',''),(7219,'1','306','1',1,'Retail Sale Id 7399',8360.00,0.00,0.00,11.00,1276.00,'2023-02-18 08:26:31','',''),(7220,'1','306','1',1,'Retail Sale Id 7400',3997.60,0.00,0.00,5.26,610.16,'2023-02-18 08:27:43','',''),(7221,'1','306','1',1,'Retail Sale Id 7401',3800.00,0.00,0.00,5.00,580.00,'2023-02-18 08:29:16','',''),(7222,'1','306','1',1,'Retail Sale Id 7402',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 08:30:56','',''),(7223,'1','306','1',1,'Retail Sale Id 7403',9500.00,0.00,0.00,12.50,1450.00,'2023-02-18 08:32:05','',''),(7224,'1','306','1',1,'Retail Sale Id 7404',760.00,0.00,0.00,1.00,116.00,'2023-02-18 08:35:06','',''),(7225,'1','306','1',1,'Retail Sale Id 7405',1200.80,0.00,0.00,1.58,183.28,'2023-02-18 08:36:41','',''),(7226,'1','306','1',1,'Retail Sale Id 7406',3800.00,0.00,0.00,5.00,580.00,'2023-02-18 08:39:38','',''),(7227,'1','306','1',1,'Retail Sale Id 7407',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 08:42:42','',''),(7228,'1','306','1',1,'Retail Sale Id 7408',15840.00,0.00,0.00,22.00,1672.00,'2023-02-18 08:44:26','',''),(7229,'1','306','1',1,'Retail Sale Id 7409',1520.00,0.00,0.00,2.00,232.00,'2023-02-18 08:45:50','',''),(7230,'1','306','1',1,'Retail Sale Id 7410',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 08:46:54','',''),(7231,'1','306','1',1,'Retail Sale Id 7411',760.00,0.00,0.00,1.00,116.00,'2023-02-18 08:47:55','',''),(7232,'1','306','1',1,'Retail Sale Id 7412',4560.00,0.00,0.00,6.00,696.00,'2023-02-18 08:48:56','',''),(7233,'1','306','1',1,'Retail Sale Id 7413',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 08:52:37','',''),(7234,'1','306','1',1,'Retail Sale Id 7414',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 08:56:14','',''),(7235,'1','306','1',1,'Retail Sale Id 7415',3002.00,0.00,0.00,3.95,458.20,'2023-02-18 08:58:40','',''),(7236,'1','306','1',1,'Retail Sale Id 7416',3800.00,0.00,0.00,5.00,580.00,'2023-02-18 08:59:32','',''),(7237,'1','306','1',1,'Retail Sale Id 7417',1520.00,0.00,0.00,2.00,232.00,'2023-02-18 09:02:43','',''),(7238,'1','306','1',1,'Retail Sale Id 7418',3800.00,0.00,0.00,5.00,580.00,'2023-02-18 09:04:06','',''),(7239,'1','306','1',1,'Retail Sale Id 7419',9500.00,0.00,0.00,12.50,1450.00,'2023-02-18 09:06:33','',''),(7240,'1','306','1',1,'Retail Sale Id 7424',4598.00,0.00,0.00,6.05,701.80,'2023-02-18 09:17:28','',''),(7241,'1','306','1',1,'Retail Sale Id 7425',9500.00,0.00,0.00,12.50,1450.00,'2023-02-18 09:25:28','',''),(7242,'1','306','1',1,'Retail Sale Id 7426',3040.00,0.00,0.00,4.00,464.00,'2023-02-18 09:28:46','',''),(7243,'1','306','1',1,'Retail Sale Id 7427',3040.00,0.00,0.00,4.00,464.00,'2023-02-18 09:29:36','',''),(7244,'1','306','1',1,'Retail Sale Id 7429',501.60,0.00,0.00,0.66,76.56,'2023-02-18 09:38:00','',''),(7245,'1','306','1',1,'Retail Sale Id 7430',653.60,0.00,0.00,0.86,99.76,'2023-02-18 09:44:10','',''),(7246,'1','306','1',1,'Retail Sale Id 7431',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 09:46:23','',''),(7247,'1','306','1',1,'Retail Sale Id 7432',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 09:48:33','',''),(7248,'1','306','1',1,'Retail Sale Id 7433',2941.20,0.00,0.00,3.87,448.92,'2023-02-18 10:01:47','',''),(7249,'1','306','1',1,'Retail Sale Id 7434',501.60,0.00,0.00,0.66,76.56,'2023-02-18 10:08:58','',''),(7250,'1','306','1',1,'Retail Sale Id 7435',798.00,0.00,0.00,1.05,121.80,'2023-02-18 10:10:58','',''),(7251,'1','306','1',1,'Retail Sale Id 7436',4567.60,0.00,0.00,6.01,697.16,'2023-02-18 10:18:08','',''),(7252,'1','306','1',1,'Retail Sale Id 7437',5008.40,0.00,0.00,6.59,764.44,'2023-02-18 10:18:47','',''),(7253,'1','306','1',1,'Retail Sale Id 7438',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 10:25:46','',''),(7254,'1','306','1',1,'Retail Sale Id 7439',4560.00,0.00,0.00,6.00,696.00,'2023-02-18 10:29:32','',''),(7255,'1','306','1',1,'Retail Sale Id 7440',1603.60,0.00,0.00,2.11,244.76,'2023-02-18 10:36:45','',''),(7256,'1','306','1',1,'Retail Sale Id 7441',1200.80,0.00,0.00,1.58,183.28,'2023-02-18 10:39:09','',''),(7257,'1','306','1',1,'Retail Sale Id 7442',3169.20,0.00,0.00,4.17,483.72,'2023-02-18 10:45:46','',''),(7258,'1','306','1',1,'Retail Sale Id 7443',4560.00,0.00,0.00,6.00,696.00,'2023-02-18 10:52:56','',''),(7259,'1','306','1',1,'Retail Sale Id 7443',4560.00,0.00,0.00,6.00,696.00,'2023-02-18 10:52:56','',''),(7260,'1','306','1',1,'Retail Sale Id 7444',4560.00,0.00,0.00,6.00,696.00,'2023-02-18 11:04:53','',''),(7261,'1','306','1',1,'Retail Sale Id 7445',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 11:13:00','',''),(7262,'1','306','1',1,'Retail Sale Id 7446',1497.20,0.00,0.00,1.97,228.52,'2023-02-18 11:18:49','',''),(7263,'1','306','1',1,'Retail Sale Id 7447',798.00,0.00,0.00,1.05,121.80,'2023-02-18 11:23:32','',''),(7264,'1','306','1',1,'Retail Sale Id 7448',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 11:25:03','',''),(7265,'1','306','1',1,'Retail Sale Id 7449',4560.00,0.00,0.00,6.00,696.00,'2023-02-18 11:30:16','',''),(7266,'1','306','1',1,'Retail Sale Id 7450',3040.00,0.00,0.00,4.00,464.00,'2023-02-18 11:32:05','',''),(7267,'1','306','1',1,'Retail Sale Id 7451',3800.00,0.00,0.00,5.00,580.00,'2023-02-18 11:32:53','',''),(7268,'1','306','1',1,'Retail Sale Id 7453',1520.00,0.00,0.00,2.00,232.00,'2023-02-18 11:36:25','',''),(7269,'1','306','1',1,'Retail Sale Id 7454',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 11:39:26','',''),(7270,'1','306','1',1,'Retail Sale Id 7455',7600.00,0.00,0.00,10.00,1160.00,'2023-02-18 11:42:09','',''),(7271,'1','306','1',1,'Retail Sale Id 7455',9500.00,0.00,0.00,12.50,1450.00,'2023-02-18 11:42:09','',''),(7272,'1','306','1',1,'Retail Sale Id 7456',3040.00,0.00,0.00,4.00,464.00,'2023-02-18 11:43:09','',''),(7273,'1','306','1',1,'Retail Sale Id 7457',501.60,0.00,0.00,0.66,76.56,'2023-02-18 11:45:18','',''),(7274,'1','306','1',1,'Retail Sale Id 7458',43200.00,0.00,0.00,60.00,4560.00,'2023-02-18 11:46:36','',''),(7275,'1','306','1',1,'Retail Sale Id 7459',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 11:49:01','',''),(7276,'1','306','1',1,'Retail Sale Id 7460',3040.00,0.00,0.00,4.00,464.00,'2023-02-18 11:49:57','',''),(7277,'1','306','1',1,'Retail Sale Id 7461',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 11:51:21','',''),(7278,'1','306','1',1,'Retail Sale Id 7462',760.00,0.00,0.00,1.00,116.00,'2023-02-18 11:52:04','',''),(7279,'1','306','1',1,'Retail Sale Id 7463',1520.00,0.00,0.00,2.00,232.00,'2023-02-18 11:53:02','',''),(7280,'1','306','1',1,'Retail Sale Id 7464',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 11:54:23','',''),(7281,'1','306','1',1,'Retail Sale Id 7465',20880.00,0.00,0.00,29.00,2204.00,'2023-02-18 11:55:15','',''),(7282,'1','306','1',1,'Retail Sale Id 7466',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 11:56:07','',''),(7283,'1','306','1',1,'Retail Sale Id 7467',1520.00,0.00,0.00,2.00,232.00,'2023-02-18 11:56:50','',''),(7284,'1','306','1',1,'Retail Sale Id 7468',5000.80,0.00,0.00,6.58,763.28,'2023-02-18 11:59:22','',''),(7285,'1','306','1',1,'Retail Sale Id 7469',9500.00,0.00,0.00,12.50,1450.00,'2023-02-18 12:00:50','',''),(7286,'1','306','1',1,'Retail Sale Id 7470',4560.00,0.00,0.00,6.00,696.00,'2023-02-18 12:04:13','',''),(7287,'1','306','1',1,'Retail Sale Id 7471',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 12:09:47','',''),(7288,'1','306','1',1,'Retail Sale Id 7472',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 12:11:23','',''),(7289,'1','306','1',1,'Retail Sale Id 7474',4560.00,0.00,0.00,6.00,696.00,'2023-02-18 12:13:42','',''),(7290,'1','306','1',1,'Retail Sale Id 7475',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 12:27:17','',''),(7291,'1','306','1',1,'Retail Sale Id 7477',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 12:36:57','',''),(7292,'1','306','1',1,'Retail Sale Id 7478',1520.00,0.00,0.00,2.00,232.00,'2023-02-18 13:08:51','',''),(7293,'1','306','1',1,'Retail Sale Id 7479',3040.00,0.00,0.00,4.00,464.00,'2023-02-18 13:22:59','',''),(7294,'1','306','1',1,'Retail Sale Id 7480',760.00,0.00,0.00,1.00,116.00,'2023-02-18 13:41:22','',''),(7295,'1','306','1',1,'Retail Sale Id 7482',1520.00,0.00,0.00,2.00,232.00,'2023-02-18 13:44:24','',''),(7296,'1','306','1',1,'Retail Sale Id 7483',699.20,0.00,0.00,0.92,106.72,'2023-02-18 14:04:50','',''),(7297,'1','306','1',1,'Retail Sale Id 7484',3040.00,0.00,0.00,4.00,464.00,'2023-02-18 14:17:17','',''),(7298,'1','306','1',1,'Retail Sale Id 7485',1520.00,0.00,0.00,2.00,232.00,'2023-02-18 14:20:05','',''),(7299,'1','306','1',1,'Retail Sale Id 7486',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 14:26:12','',''),(7300,'1','306','1',1,'Retail Sale Id 7487',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 14:30:37','',''),(7301,'1','306','1',1,'Retail Sale Id 7488',1520.00,0.00,0.00,2.00,232.00,'2023-02-18 14:31:39','',''),(7302,'1','306','1',1,'Retail Sale Id 7489',3040.00,0.00,0.00,4.00,464.00,'2023-02-18 14:32:24','',''),(7303,'1','306','1',1,'Retail Sale Id 7490',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 14:33:26','',''),(7304,'1','306','1',1,'Retail Sale Id 7491',4560.00,0.00,0.00,6.00,696.00,'2023-02-18 14:34:13','',''),(7305,'1','306','1',1,'Retail Sale Id 7492',1520.00,0.00,0.00,2.00,232.00,'2023-02-18 14:34:57','',''),(7306,'1','306','1',1,'Retail Sale Id 7493',31680.00,0.00,0.00,44.00,3344.00,'2023-02-18 14:37:31','',''),(7307,'1','306','1',1,'Retail Sale Id 7494',3040.00,0.00,0.00,4.00,464.00,'2023-02-18 14:44:09','',''),(7308,'1','306','1',1,'Retail Sale Id 7495',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 14:46:15','',''),(7309,'1','306','1',1,'Retail Sale Id 7496',9500.00,0.00,0.00,12.50,1450.00,'2023-02-18 14:47:46','',''),(7310,'1','306','1',1,'Retail Sale Id 7497',1520.00,0.00,0.00,2.00,232.00,'2023-02-18 14:48:30','',''),(7311,'1','306','1',1,'Retail Sale Id 7498',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 14:50:38','',''),(7312,'1','306','1',1,'Retail Sale Id 7499',9500.00,0.00,0.00,12.50,1450.00,'2023-02-18 14:51:14','',''),(7313,'1','306','1',1,'Retail Sale Id 7500',6080.00,0.00,0.00,8.00,928.00,'2023-02-18 14:54:50','',''),(7314,'1','306','1',1,'Retail Sale Id 7501',3800.00,0.00,0.00,5.00,580.00,'2023-02-18 14:55:28','',''),(7315,'1','306','1',1,'Retail Sale Id 7502',4560.00,0.00,0.00,6.00,696.00,'2023-02-18 14:56:12','',''),(7316,'1','306','1',1,'Retail Sale Id 7503',3800.00,0.00,0.00,5.00,580.00,'2023-02-18 14:58:20','',''),(7317,'1','306','1',1,'Retail Sale Id 7504',3800.00,0.00,0.00,5.00,580.00,'2023-02-18 15:02:17','',''),(7318,'1','306','1',1,'Retail Sale Id 7505',3002.00,0.00,0.00,3.95,458.20,'2023-02-18 15:03:11','',''),(7319,'1','306','1',1,'Retail Sale Id 7507',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 15:10:54','',''),(7320,'1','306','1',1,'Retail Sale Id 7508',9500.00,0.00,0.00,12.50,1450.00,'2023-02-18 15:11:59','',''),(7321,'1','306','1',1,'Retail Sale Id 7509',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 15:13:02','',''),(7322,'1','306','1',1,'Retail Sale Id 7510',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 15:15:35','',''),(7323,'1','306','1',1,'Retail Sale Id 7510',9500.00,0.00,0.00,12.50,1450.00,'2023-02-18 15:15:35','',''),(7324,'1','306','1',1,'Retail Sale Id 7511',17480.00,0.00,0.00,23.00,2668.00,'2023-02-18 15:22:01','',''),(7325,'1','306','1',1,'Retail Sale Id 7512',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 15:23:40','',''),(7326,'1','306','1',1,'Retail Sale Id 7513',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 15:24:55','',''),(7327,'1','306','1',1,'Retail Sale Id 7514',4560.00,0.00,0.00,6.00,696.00,'2023-02-18 15:26:53','',''),(7328,'1','306','1',1,'Retail Sale Id 7515',3040.00,0.00,0.00,4.00,464.00,'2023-02-18 15:28:02','',''),(7329,'1','306','1',1,'Retail Sale Id 7516',3040.00,0.00,0.00,4.00,464.00,'2023-02-18 15:29:17','',''),(7330,'1','306','1',1,'Retail Sale Id 7517',6080.00,0.00,0.00,8.00,928.00,'2023-02-18 15:36:04','',''),(7331,'1','306','1',1,'Retail Sale Id 7517',9500.00,0.00,0.00,12.50,1450.00,'2023-02-18 15:36:04','',''),(7332,'1','306','1',1,'Retail Sale Id 7518',9500.00,0.00,0.00,12.50,1450.00,'2023-02-18 15:37:42','',''),(7333,'1','306','1',1,'Retail Sale Id 7520',9500.00,0.00,0.00,12.50,1450.00,'2023-02-18 15:42:23','',''),(7334,'1','306','1',1,'Retail Sale Id 7521',23040.00,0.00,0.00,32.00,2432.00,'2023-02-18 15:45:24','',''),(7335,'1','306','1',1,'Retail Sale Id 7522',3040.00,0.00,0.00,4.00,464.00,'2023-02-18 15:47:07','',''),(7336,'1','306','1',1,'Retail Sale Id 7523',4560.00,0.00,0.00,6.00,696.00,'2023-02-18 15:48:52','',''),(7337,'1','306','1',1,'Retail Sale Id 7525',798.00,0.00,0.00,1.05,121.80,'2023-02-18 16:05:16','',''),(7338,'1','306','1',1,'Retail Sale Id 7526',4560.00,0.00,0.00,6.00,696.00,'2023-02-18 16:20:37','',''),(7339,'1','306','1',1,'Retail Sale Id 7527',1003.20,0.00,0.00,1.32,153.12,'2023-02-18 16:31:07','',''),(7340,'1','306','1',1,'Retail Sale Id 7528',798.00,0.00,0.00,1.05,121.80,'2023-02-18 16:34:42','',''),(7341,'1','306','1',1,'Retail Sale Id 7529',2302.80,0.00,0.00,3.03,351.48,'2023-02-18 16:37:36','',''),(7342,'1','306','1',1,'Retail Sale Id 7530',1520.00,0.00,0.00,2.00,232.00,'2023-02-18 16:49:54','',''),(7343,'1','306','1',1,'Retail Sale Id 7531',1702.40,0.00,0.00,2.24,259.84,'2023-02-18 16:51:19','',''),(7344,'1','306','1',1,'Retail Sale Id 7532',1520.00,0.00,0.00,2.00,232.00,'2023-02-18 16:55:17','',''),(7345,'1','306','1',1,'Retail Sale Id 7533',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 17:06:28','',''),(7346,'1','306','1',1,'Retail Sale Id 7534',1140.00,0.00,0.00,1.50,174.00,'2023-02-18 17:11:07','',''),(7347,'1','306','1',1,'Retail Sale Id 7535',1003.20,0.00,0.00,1.32,153.12,'2023-02-18 17:13:43','',''),(7348,'1','306','1',1,'Retail Sale Id 7536',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 17:14:41','',''),(7349,'1','306','1',1,'Retail Sale Id 7537',5700.00,0.00,0.00,7.50,870.00,'2023-02-18 17:17:58','',''),(7350,'1','306','1',1,'Retail Sale Id 7537',9500.00,0.00,0.00,12.50,1450.00,'2023-02-18 17:17:58','',''),(7351,'1','306','1',1,'Retail Sale Id 7538',1520.00,0.00,0.00,2.00,232.00,'2023-02-18 17:23:58','',''),(7352,'1','306','1',1,'Retail Sale Id 7539',1003.20,0.00,0.00,1.32,153.12,'2023-02-18 17:31:24','',''),(7353,'1','306','1',1,'Retail Sale Id 7540',4560.00,0.00,0.00,6.00,696.00,'2023-02-18 17:39:07','',''),(7354,'1','306','1',1,'Retail Sale Id 7541',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 17:40:33','',''),(7355,'1','306','1',1,'Retail Sale Id 7542',4560.00,0.00,0.00,6.00,696.00,'2023-02-18 17:47:24','',''),(7356,'1','306','1',1,'Retail Sale Id 7543',43200.00,0.00,0.00,60.00,4560.00,'2023-02-18 17:52:37','',''),(7357,'1','306','1',1,'Retail Sale Id 7544',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 17:53:23','',''),(7358,'1','306','1',1,'Retail Sale Id 7545',1520.00,0.00,0.00,2.00,232.00,'2023-02-18 17:54:15','',''),(7359,'1','306','1',1,'Retail Sale Id 7546',4560.00,0.00,0.00,6.00,696.00,'2023-02-18 17:55:23','',''),(7360,'1','306','1',1,'Retail Sale Id 7548',3040.00,0.00,0.00,4.00,464.00,'2023-02-18 17:56:51','',''),(7361,'1','306','1',1,'Retail Sale Id 7549',7600.00,0.00,0.00,10.00,1160.00,'2023-02-18 17:57:56','',''),(7362,'1','306','1',1,'Retail Sale Id 7550',4560.00,0.00,0.00,6.00,696.00,'2023-02-18 17:58:53','',''),(7363,'1','306','1',1,'Retail Sale Id 7551',21600.00,0.00,0.00,30.00,2280.00,'2023-02-18 17:59:52','',''),(7364,'1','306','1',1,'Retail Sale Id 7552',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 18:01:37','',''),(7365,'1','306','1',1,'Retail Sale Id 7553',760.00,0.00,0.00,1.00,116.00,'2023-02-18 18:05:07','',''),(7366,'1','306','1',1,'Retail Sale Id 7554',3800.00,0.00,0.00,5.00,580.00,'2023-02-18 18:06:07','',''),(7367,'1','306','1',1,'Retail Sale Id 7555',1520.00,0.00,0.00,2.00,232.00,'2023-02-18 18:07:35','',''),(7368,'1','306','1',1,'Retail Sale Id 7555',1520.00,0.00,0.00,2.00,232.00,'2023-02-18 18:07:35','',''),(7369,'1','306','1',1,'Retail Sale Id 7556',1520.00,0.00,0.00,2.00,232.00,'2023-02-18 18:12:14','',''),(7370,'1','306','1',1,'Retail Sale Id 7556',3800.00,0.00,0.00,5.00,580.00,'2023-02-18 18:12:14','',''),(7371,'1','306','1',1,'Retail Sale Id 7557',4560.00,0.00,0.00,6.00,696.00,'2023-02-18 18:18:06','',''),(7372,'1','306','1',1,'Retail Sale Id 7558',2280.00,0.00,0.00,3.00,348.00,'2023-02-18 18:19:39','',''),(7373,'1','306','1',1,'Retail Sale Id 7559',3800.00,0.00,0.00,5.00,580.00,'2023-02-18 18:22:29','',''),(7374,'1','306','1',1,'Retail Sale Id 7560',1003.20,0.00,0.00,1.32,153.12,'2023-02-18 18:33:56','',''),(7375,'1','306','1',1,'Return of Retail Sale Id 7556',0.00,1520.00,2.00,0.00,-232.00,'2023-02-18 18:42:40','',''),(7376,'1','306','1',1,'Return of Retail Sale Id 7556',0.00,3800.00,5.00,0.00,-580.00,'2023-02-18 18:42:40','',''),(7377,'1','306','1',1,'Return of Retail Sale Id 7546',0.00,4560.00,6.00,0.00,-696.00,'2023-02-18 18:43:06','',''),(7378,'1','306','1',1,'Return of Retail Sale Id 7560',0.00,1003.20,1.32,0.00,-153.12,'2023-02-18 18:44:29','',''),(7379,'1','306','1',1,'Retail Sale Id 7561',1018.40,0.00,0.00,1.34,155.44,'2023-02-18 18:45:38','',''),(7380,'1','306','1',1,'Retail Sale Id 7562',3040.00,0.00,0.00,4.00,464.00,'2023-02-19 07:48:23','',''),(7381,'1','306','1',1,'Retail Sale Id 7563',3040.00,0.00,0.00,4.00,464.00,'2023-02-19 08:00:46','',''),(7382,'1','306','1',1,'Retail Sale Id 7564',9500.00,0.00,0.00,12.50,1450.00,'2023-02-19 08:04:25','',''),(7383,'1','306','1',1,'Retail Sale Id 7565',5000.80,0.00,0.00,6.58,763.28,'2023-02-19 08:06:05','',''),(7384,'1','306','1',1,'Retail Sale Id 7566',9500.00,0.00,0.00,12.50,1450.00,'2023-02-19 08:07:24','',''),(7385,'1','306','1',1,'Retail Sale Id 7567',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 08:09:04','',''),(7386,'1','306','1',1,'Retail Sale Id 7568',23040.00,0.00,0.00,32.00,2432.00,'2023-02-19 08:10:57','',''),(7387,'1','306','1',1,'Retail Sale Id 7569',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 08:19:45','',''),(7388,'1','306','1',1,'Retail Sale Id 7570',3503.60,0.00,0.00,4.61,534.76,'2023-02-19 08:30:04','',''),(7389,'1','306','1',1,'Retail Sale Id 7571',1998.80,0.00,0.00,2.63,305.08,'2023-02-19 08:34:29','',''),(7390,'1','306','1',1,'Retail Sale Id 7572',1520.00,0.00,0.00,2.00,232.00,'2023-02-19 08:38:03','',''),(7391,'1','306','1',1,'Retail Sale Id 7573',4560.00,0.00,0.00,6.00,696.00,'2023-02-19 08:41:46','',''),(7392,'1','306','1',1,'Retail Sale Id 7574',1520.00,0.00,0.00,2.00,232.00,'2023-02-19 08:51:27','',''),(7393,'1','306','1',1,'Retail Sale Id 7575',9500.00,0.00,0.00,12.50,1450.00,'2023-02-19 08:59:03','',''),(7394,'1','306','1',1,'Retail Sale Id 7576',760.00,0.00,0.00,1.00,116.00,'2023-02-19 09:13:06','',''),(7395,'1','306','1',1,'Retail Sale Id 7577',3002.00,0.00,0.00,3.95,458.20,'2023-02-19 09:15:45','',''),(7396,'1','306','1',1,'Retail Sale Id 7578',12821.20,0.00,0.00,16.87,1956.92,'2023-02-19 09:46:04','',''),(7397,'1','306','1',1,'Distributed to SAGIR GAS for sales id:6',12532.24,0.00,0.00,19.46,0.00,'2023-02-19 09:58:39','',''),(7398,'1','306',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,3091200.00,4800.00,0.00,0.00,'2023-02-19 11:42:07','',''),(7399,'1','306',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,4800.00,0.00,'2023-02-19 11:43:03','',''),(7400,'1','306','1',1,'Received from bridging 16',0.00,0.00,4800.00,0.00,0.00,'2023-02-19 11:43:03','',''),(7401,'1','306','1',1,'Retail Sale Id 7579',1520.00,0.00,0.00,2.00,232.00,'2023-02-19 11:43:32','',''),(7402,'1','306','1',1,'Retail Sale Id 7580',3952.00,0.00,0.00,5.20,603.20,'2023-02-19 11:44:09','',''),(7403,'1','306','1',1,'Retail Sale Id 7581',4560.00,0.00,0.00,6.00,696.00,'2023-02-19 11:45:35','',''),(7404,'1','306','1',1,'Retail Sale Id 7582',3800.00,0.00,0.00,5.00,580.00,'2023-02-19 11:46:42','',''),(7405,'1','306','1',1,'Retail Sale Id 7583',6080.00,0.00,0.00,8.00,928.00,'2023-02-19 11:49:46','',''),(7406,'1','306','1',1,'Retail Sale Id 7584',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 11:51:08','',''),(7407,'1','306','1',1,'Retail Sale Id 7584',4560.00,0.00,0.00,6.00,696.00,'2023-02-19 11:51:08','',''),(7408,'1','306','1',1,'Retail Sale Id 7585',3800.00,0.00,0.00,5.00,580.00,'2023-02-19 11:52:32','',''),(7409,'1','306','1',1,'Retail Sale Id 7586',9500.00,0.00,0.00,12.50,1450.00,'2023-02-19 11:53:46','',''),(7410,'1','306','1',1,'Retail Sale Id 7587',3800.00,0.00,0.00,5.00,580.00,'2023-02-19 11:54:41','',''),(7411,'1','306','1',1,'Retail Sale Id 7588',3800.00,0.00,0.00,5.00,580.00,'2023-02-19 11:55:40','',''),(7412,'1','306','1',1,'Retail Sale Id 7588',5320.00,0.00,0.00,7.00,812.00,'2023-02-19 11:55:40','',''),(7413,'1','306','1',1,'Retail Sale Id 7589',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 11:57:10','',''),(7414,'1','306','1',1,'Retail Sale Id 7590',4560.00,0.00,0.00,6.00,696.00,'2023-02-19 11:58:22','',''),(7415,'1','306','1',1,'Retail Sale Id 7591',8360.00,0.00,0.00,11.00,1276.00,'2023-02-19 11:59:21','',''),(7416,'1','306','1',1,'Retail Sale Id 7592',9500.00,0.00,0.00,12.50,1450.00,'2023-02-19 12:01:33','',''),(7417,'1','306','1',1,'Retail Sale Id 7593',3040.00,0.00,0.00,4.00,464.00,'2023-02-19 12:02:46','',''),(7418,'1','306','1',1,'Retail Sale Id 7594',3040.00,0.00,0.00,4.00,464.00,'2023-02-19 12:03:29','',''),(7419,'1','306','1',1,'Retail Sale Id 7595',9500.00,0.00,0.00,12.50,1450.00,'2023-02-19 12:05:30','',''),(7420,'1','306','1',1,'Retail Sale Id 7595',9500.00,0.00,0.00,12.50,1450.00,'2023-02-19 12:05:30','',''),(7421,'1','306','1',1,'Retail Sale Id 7596',3800.00,0.00,0.00,5.00,580.00,'2023-02-19 12:06:49','',''),(7422,'1','306','1',1,'Retail Sale Id 7597',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 12:10:30','',''),(7423,'1','306','1',1,'Retail Sale Id 7598',9500.00,0.00,0.00,12.50,1450.00,'2023-02-19 12:15:33','',''),(7424,'1','306','1',1,'Retail Sale Id 7599',1520.00,0.00,0.00,2.00,232.00,'2023-02-19 12:16:55','',''),(7425,'1','306','1',1,'Retail Sale Id 7600',7600.00,0.00,0.00,10.00,1160.00,'2023-02-19 12:18:10','',''),(7426,'1','306','1',1,'Retail Sale Id 7601',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 12:19:13','',''),(7427,'1','306','1',1,'Retail Sale Id 7602',4560.00,0.00,0.00,6.00,696.00,'2023-02-19 12:21:05','',''),(7428,'1','306','1',1,'Retail Sale Id 7603',1003.20,0.00,0.00,1.32,153.12,'2023-02-19 12:22:19','',''),(7429,'1','306','1',1,'Retail Sale Id 7604',3800.00,0.00,0.00,5.00,580.00,'2023-02-19 12:24:01','',''),(7430,'1','306','1',1,'Retail Sale Id 7605',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 12:24:50','',''),(7431,'1','306','1',1,'Retail Sale Id 7606',3040.00,0.00,0.00,4.00,464.00,'2023-02-19 12:26:10','',''),(7432,'1','306','1',1,'Retail Sale Id 7607',1003.20,0.00,0.00,1.32,153.12,'2023-02-19 12:27:07','',''),(7433,'1','306','1',1,'Retail Sale Id 7608',3800.00,0.00,0.00,5.00,580.00,'2023-02-19 12:30:22','',''),(7434,'1','306','1',1,'Retail Sale Id 7609',9500.00,0.00,0.00,12.50,1450.00,'2023-02-19 12:31:50','',''),(7435,'1','306','1',1,'Retail Sale Id 7610',2500.40,0.00,0.00,3.29,381.64,'2023-02-19 12:36:18','',''),(7436,'1','306','1',1,'Retail Sale Id 7611',4560.00,0.00,0.00,6.00,696.00,'2023-02-19 12:38:55','',''),(7437,'1','306','1',1,'Retail Sale Id 7612',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 12:43:03','',''),(7438,'1','306','1',1,'Retail Sale Id 7613',3800.00,0.00,0.00,5.00,580.00,'2023-02-19 12:44:29','',''),(7439,'1','306','1',1,'Retail Sale Id 7614',10001.60,0.00,0.00,13.16,1526.56,'2023-02-19 12:45:12','',''),(7440,'1','306','1',1,'Retail Sale Id 7615',7220.00,0.00,0.00,9.50,1102.00,'2023-02-19 12:46:28','',''),(7441,'1','306','1',1,'Retail Sale Id 7616',5000.80,0.00,0.00,6.58,763.28,'2023-02-19 12:48:33','',''),(7442,'1','306','1',1,'Retail Sale Id 7617',4560.00,0.00,0.00,6.00,696.00,'2023-02-19 12:52:19','',''),(7443,'1','306','1',1,'Retail Sale Id 7618',7600.00,0.00,0.00,10.00,1160.00,'2023-02-19 12:54:03','',''),(7444,'1','306','1',1,'Retail Sale Id 7619',798.00,0.00,0.00,1.05,121.80,'2023-02-19 12:55:24','',''),(7445,'1','306','1',1,'Retail Sale Id 7620',1497.20,0.00,0.00,1.97,228.52,'2023-02-19 12:58:18','',''),(7446,'1','306','1',1,'Retail Sale Id 7621',3800.00,0.00,0.00,5.00,580.00,'2023-02-19 12:59:08','',''),(7447,'1','306','1',1,'Retail Sale Id 7622',4560.00,0.00,0.00,6.00,696.00,'2023-02-19 13:02:00','',''),(7448,'1','306','1',1,'Retail Sale Id 7623',3800.00,0.00,0.00,5.00,580.00,'2023-02-19 13:06:36','',''),(7449,'1','306','1',1,'Retail Sale Id 7624',1003.20,0.00,0.00,1.32,153.12,'2023-02-19 13:20:46','',''),(7450,'1','306','1',1,'Retail Sale Id 7625',4560.00,0.00,0.00,6.00,696.00,'2023-02-19 13:24:14','',''),(7451,'1','306','1',1,'Retail Sale Id 7626',1520.00,0.00,0.00,2.00,232.00,'2023-02-19 13:37:09','',''),(7452,'1','306','1',1,'Retail Sale Id 7627',760.00,0.00,0.00,1.00,116.00,'2023-02-19 13:40:02','',''),(7453,'1','306','1',1,'Retail Sale Id 7628',9500.00,0.00,0.00,12.50,1450.00,'2023-02-19 13:41:17','',''),(7454,'1','306','1',1,'Retail Sale Id 7629',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 13:43:32','',''),(7455,'1','306','1',1,'Retail Sale Id 7630',7600.00,0.00,0.00,10.00,1160.00,'2023-02-19 13:47:10','',''),(7456,'1','306','1',1,'Retail Sale Id 7631',9120.00,0.00,0.00,12.00,1392.00,'2023-02-19 13:49:48','',''),(7457,'1','306','1',1,'Retail Sale Id 7632',1900.00,0.00,0.00,2.50,290.00,'2023-02-19 13:51:10','',''),(7458,'1','306','1',1,'Retail Sale Id 7633',1003.20,0.00,0.00,1.32,153.12,'2023-02-19 13:54:32','',''),(7459,'1','306','1',1,'Retail Sale Id 7634',760.00,0.00,0.00,1.00,116.00,'2023-02-19 13:55:52','',''),(7460,'1','306','1',1,'Retail Sale Id 7635',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 14:08:50','',''),(7461,'1','306','1',1,'Retail Sale Id 7636',699.20,0.00,0.00,0.92,106.72,'2023-02-19 14:14:06','',''),(7462,'1','306','1',1,'Retail Sale Id 7637',4560.00,0.00,0.00,6.00,696.00,'2023-02-19 14:22:15','',''),(7463,'1','306','1',1,'Retail Sale Id 7638',1520.00,0.00,0.00,2.00,232.00,'2023-02-19 14:24:46','',''),(7464,'1','306','1',1,'Retail Sale Id 7639',4560.00,0.00,0.00,6.00,696.00,'2023-02-19 14:28:58','',''),(7465,'1','306','1',1,'Retail Sale Id 7640',4560.00,0.00,0.00,6.00,696.00,'2023-02-19 14:35:25','',''),(7466,'1','306','1',1,'Retail Sale Id 7640',9500.00,0.00,0.00,12.50,1450.00,'2023-02-19 14:35:25','',''),(7467,'1','306','1',1,'Retail Sale Id 7641',1900.00,0.00,0.00,2.50,290.00,'2023-02-19 14:37:25','',''),(7468,'1','306','1',1,'Retail Sale Id 7642',1520.00,0.00,0.00,2.00,232.00,'2023-02-19 14:39:40','',''),(7469,'1','306','1',1,'Retail Sale Id 7643',760.00,0.00,0.00,1.00,116.00,'2023-02-19 14:40:21','',''),(7470,'1','306','1',1,'Retail Sale Id 7644',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 14:41:27','',''),(7471,'1','306','1',1,'Retail Sale Id 7647',760.00,0.00,0.00,1.00,116.00,'2023-02-19 14:59:37','',''),(7472,'1','306','1',1,'Retail Sale Id 7648',4560.00,0.00,0.00,6.00,696.00,'2023-02-19 15:09:51','',''),(7473,'1','306','1',1,'Retail Sale Id 7648',15200.00,0.00,0.00,20.00,2320.00,'2023-02-19 15:09:51','',''),(7474,'1','306','1',1,'Retail Sale Id 7649',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 15:11:02','',''),(7475,'1','306','1',1,'Retail Sale Id 7650',1998.80,0.00,0.00,2.63,305.08,'2023-02-19 15:13:24','',''),(7476,'1','306','1',1,'Retail Sale Id 7651',3040.00,0.00,0.00,4.00,464.00,'2023-02-19 15:16:06','',''),(7477,'1','306','1',1,'Retail Sale Id 7651',3040.00,0.00,0.00,4.00,464.00,'2023-02-19 15:16:06','',''),(7478,'1','306','1',1,'Retail Sale Id 7652',9500.00,0.00,0.00,12.50,1450.00,'2023-02-19 15:28:05','',''),(7479,'1','306','1',1,'Retail Sale Id 7653',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 15:29:26','',''),(7480,'1','306','1',1,'Retail Sale Id 7654',4560.00,0.00,0.00,6.00,696.00,'2023-02-19 15:30:12','',''),(7481,'1','306','1',1,'Retail Sale Id 7655',3040.00,0.00,0.00,4.00,464.00,'2023-02-19 15:31:46','',''),(7482,'1','306','1',1,'Retail Sale Id 7656',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 15:35:35','',''),(7483,'1','306','1',1,'Retail Sale Id 7657',7600.00,0.00,0.00,10.00,1160.00,'2023-02-19 15:36:34','',''),(7484,'1','306','1',1,'Retail Sale Id 7658',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 15:38:24','',''),(7485,'1','306','1',1,'Retail Sale Id 7659',3800.00,0.00,0.00,5.00,580.00,'2023-02-19 15:39:59','',''),(7486,'1','306','1',1,'Retail Sale Id 7660',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 15:44:05','',''),(7487,'1','306','1',1,'Retail Sale Id 7661',3800.00,0.00,0.00,5.00,580.00,'2023-02-19 15:45:09','',''),(7488,'1','306','1',1,'Retail Sale Id 7662',3040.00,0.00,0.00,4.00,464.00,'2023-02-19 15:47:07','',''),(7489,'1','306','1',1,'Retail Sale Id 7663',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 15:57:24','',''),(7490,'1','306','1',1,'Retail Sale Id 7664',9500.00,0.00,0.00,12.50,1450.00,'2023-02-19 15:58:16','',''),(7491,'1','306','1',1,'Retail Sale Id 7665',4560.00,0.00,0.00,6.00,696.00,'2023-02-19 16:00:33','',''),(7492,'1','306','1',1,'Retail Sale Id 7666',4560.00,0.00,0.00,6.00,696.00,'2023-02-19 16:04:15','',''),(7493,'1','306','1',1,'Retail Sale Id 7666',9500.00,0.00,0.00,12.50,1450.00,'2023-02-19 16:04:15','',''),(7494,'1','306','1',1,'Retail Sale Id 7667',4560.00,0.00,0.00,6.00,696.00,'2023-02-19 16:06:50','',''),(7495,'1','306','1',1,'Retail Sale Id 7668',1520.00,0.00,0.00,2.00,232.00,'2023-02-19 16:08:37','',''),(7496,'1','306','1',1,'Retail Sale Id 7669',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 16:11:30','',''),(7497,'1','306','1',1,'Retail Sale Id 7670',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 16:20:28','',''),(7498,'1','306','1',1,'Retail Sale Id 7671',4560.00,0.00,0.00,6.00,696.00,'2023-02-19 16:24:53','',''),(7499,'1','306','1',1,'Retail Sale Id 7672',1998.80,0.00,0.00,2.63,305.08,'2023-02-19 16:29:13','',''),(7500,'1','306','1',1,'Retail Sale Id 7673',760.00,0.00,0.00,1.00,116.00,'2023-02-19 16:30:01','',''),(7501,'1','306','1',1,'Retail Sale Id 7674',3040.00,0.00,0.00,4.00,464.00,'2023-02-19 16:37:06','',''),(7502,'1','306','1',1,'Retail Sale Id 7676',3800.00,0.00,0.00,5.00,580.00,'2023-02-19 16:45:29','',''),(7503,'1','306','1',1,'Retail Sale Id 7677',9500.00,0.00,0.00,12.50,1450.00,'2023-02-19 16:49:50','',''),(7504,'1','306','1',1,'Retail Sale Id 7678',19000.00,0.00,0.00,25.00,2900.00,'2023-02-19 16:51:50','',''),(7505,'1','306','1',1,'Retail Sale Id 7679',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 16:53:01','',''),(7506,'1','306','1',1,'Retail Sale Id 7680',2500.40,0.00,0.00,3.29,381.64,'2023-02-19 16:54:03','',''),(7507,'1','306','1',1,'Retail Sale Id 7681',1520.00,0.00,0.00,2.00,232.00,'2023-02-19 16:59:31','',''),(7508,'1','306','1',1,'Retail Sale Id 7682',4560.00,0.00,0.00,6.00,696.00,'2023-02-19 17:01:20','',''),(7509,'1','306','1',1,'Retail Sale Id 7683',1003.20,0.00,0.00,1.32,153.12,'2023-02-19 17:07:14','',''),(7510,'1','306','1',1,'Return of Retail Sale Id 7683',0.00,1003.20,1.32,0.00,-153.12,'2023-02-19 17:07:28','',''),(7511,'1','306','1',1,'Retail Sale Id 7684',1200.80,0.00,0.00,1.58,183.28,'2023-02-19 17:07:51','',''),(7512,'1','306','1',1,'Retail Sale Id 7685',4499.20,0.00,0.00,5.92,686.72,'2023-02-19 17:09:00','',''),(7513,'1','306','1',1,'Retail Sale Id 7686',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 17:11:43','',''),(7514,'1','306','1',1,'Retail Sale Id 7687',2500.40,0.00,0.00,3.29,381.64,'2023-02-19 17:22:17','',''),(7515,'1','306','1',1,'Retail Sale Id 7688',1520.00,0.00,0.00,2.00,232.00,'2023-02-19 17:23:43','',''),(7516,'1','306','1',1,'Retail Sale Id 7689',5320.00,0.00,0.00,7.00,812.00,'2023-02-19 17:24:41','',''),(7517,'1','306','1',1,'Retail Sale Id 7690',7600.00,0.00,0.00,10.00,1160.00,'2023-02-19 17:25:51','',''),(7518,'1','306','1',1,'Retail Sale Id 7691',6080.00,0.00,0.00,8.00,928.00,'2023-02-19 17:26:41','',''),(7519,'1','306','1',1,'Retail Sale Id 7692',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 17:27:45','',''),(7520,'1','306','1',1,'Retail Sale Id 7693',3800.00,0.00,0.00,5.00,580.00,'2023-02-19 17:28:36','',''),(7521,'1','306','1',1,'Retail Sale Id 7694',4560.00,0.00,0.00,6.00,696.00,'2023-02-19 17:29:21','',''),(7522,'1','306','1',1,'Retail Sale Id 7695',3800.00,0.00,0.00,5.00,580.00,'2023-02-19 17:31:34','',''),(7523,'1','306','1',1,'Retail Sale Id 7696',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 17:32:34','',''),(7524,'1','306','1',1,'Retail Sale Id 7696',5320.00,0.00,0.00,7.00,812.00,'2023-02-19 17:32:34','',''),(7525,'1','306','1',1,'Retail Sale Id 7697',3040.00,0.00,0.00,4.00,464.00,'2023-02-19 17:33:52','',''),(7526,'1','306','1',1,'Retail Sale Id 7698',1520.00,0.00,0.00,2.00,232.00,'2023-02-19 17:41:40','',''),(7527,'1','306','1',1,'Retail Sale Id 7698',3040.00,0.00,0.00,4.00,464.00,'2023-02-19 17:41:40','',''),(7528,'1','306','1',1,'Retail Sale Id 7699',3040.00,0.00,0.00,4.00,464.00,'2023-02-19 17:42:39','',''),(7529,'1','306','1',1,'Retail Sale Id 7700',1003.20,0.00,0.00,1.32,153.12,'2023-02-19 17:44:27','',''),(7530,'1','306','1',1,'Retail Sale Id 7701',1003.20,0.00,0.00,1.32,153.12,'2023-02-19 17:54:05','',''),(7531,'1','306','1',1,'Retail Sale Id 7702',2280.00,0.00,0.00,3.00,348.00,'2023-02-19 17:56:08','',''),(7532,'1','306','1',1,'Retail Sale Id 7703',4560.00,0.00,0.00,6.00,696.00,'2023-02-19 17:57:02','',''),(7533,'1','306','1',1,'Retail Sale Id 7704',3800.00,0.00,0.00,5.00,580.00,'2023-02-19 18:01:38','',''),(7534,'1','306','1',1,'Retail Sale Id 7705',4560.00,0.00,0.00,6.00,696.00,'2023-02-19 18:08:48','',''),(7535,'1','306','1',1,'Retail Sale Id 7707',798.00,0.00,0.00,1.05,121.80,'2023-02-19 18:19:10','',''),(7536,'1','306','1',1,'Retail Sale Id 7708',9910.40,0.00,0.00,13.04,1512.64,'2023-02-19 18:40:15','',''),(7537,'1','306','1',1,'Retail Sale Id 7709',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 07:28:47','',''),(7538,'1','306','1',1,'Retail Sale Id 7710',3800.00,0.00,0.00,5.00,580.00,'2023-02-20 07:30:24','',''),(7539,'1','306','1',1,'Retail Sale Id 7711',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 07:47:14','',''),(7540,'1','306','1',1,'Retail Sale Id 7712',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 07:48:53','',''),(7541,'1','306','1',1,'Retail Sale Id 7713',1003.20,0.00,0.00,1.32,153.12,'2023-02-20 08:00:44','',''),(7542,'1','306','1',1,'Retail Sale Id 7714',3800.00,0.00,0.00,5.00,580.00,'2023-02-20 08:02:07','',''),(7543,'1','306','1',1,'Retail Sale Id 7715',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 08:10:26','',''),(7544,'1','306','1',1,'Retail Sale Id 7716',2287.60,0.00,0.00,3.01,349.16,'2023-02-20 08:13:58','',''),(7545,'1','306','1',1,'Retail Sale Id 7717',1497.20,0.00,0.00,1.97,228.52,'2023-02-20 08:23:03','',''),(7546,'1','306','1',1,'Retail Sale Id 7718',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 08:30:49','',''),(7547,'1','306','1',1,'Retail Sale Id 7719',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 08:33:30','',''),(7548,'1','306','1',1,'Retail Sale Id 7719',3800.00,0.00,0.00,5.00,580.00,'2023-02-20 08:33:30','',''),(7549,'1','306','1',1,'Retail Sale Id 7720',9500.00,0.00,0.00,12.50,1450.00,'2023-02-20 08:37:33','',''),(7550,'1','306','1',1,'Retail Sale Id 7722',23760.00,0.00,0.00,33.00,2508.00,'2023-02-20 08:41:13','',''),(7551,'1','306','1',1,'Retail Sale Id 7723',1520.00,0.00,0.00,2.00,232.00,'2023-02-20 08:43:08','',''),(7552,'1','306','1',1,'Retail Sale Id 7724',9500.00,0.00,0.00,12.50,1450.00,'2023-02-20 08:48:42','',''),(7553,'1','306','1',1,'Retail Sale Id 7725',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 08:49:59','',''),(7554,'1','306','1',1,'Retail Sale Id 7726',1003.20,0.00,0.00,1.32,153.12,'2023-02-20 08:51:18','',''),(7555,'1','306','1',1,'Retail Sale Id 7727',3040.00,0.00,0.00,4.00,464.00,'2023-02-20 08:54:41','',''),(7556,'1','306','1',1,'Retail Sale Id 7728',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 09:03:55','',''),(7557,'1','306','1',1,'Retail Sale Id 7729',3800.00,0.00,0.00,5.00,580.00,'2023-02-20 09:07:35','',''),(7558,'1','306','1',1,'Retail Sale Id 7730',5320.00,0.00,0.00,7.00,812.00,'2023-02-20 09:15:41','',''),(7559,'1','306','1',1,'Retail Sale Id 7731',3800.00,0.00,0.00,5.00,580.00,'2023-02-20 09:17:07','',''),(7560,'1','306','1',1,'Retail Sale Id 7732',2660.00,0.00,0.00,3.50,406.00,'2023-02-20 09:22:08','',''),(7561,'1','306','1',1,'Retail Sale Id 7733',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 09:28:16','',''),(7562,'1','306','1',1,'Retail Sale Id 7734',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 09:30:22','',''),(7563,'1','306','1',1,'Retail Sale Id 7735',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 09:33:34','',''),(7564,'1','306','1',1,'Retail Sale Id 7736',1003.20,0.00,0.00,1.32,153.12,'2023-02-20 09:35:01','',''),(7565,'1','306','1',1,'Retail Sale Id 7738',6840.00,0.00,0.00,9.00,1044.00,'2023-02-20 09:44:10','',''),(7566,'1','306','1',1,'Retail Sale Id 7739',9500.00,0.00,0.00,12.50,1450.00,'2023-02-20 09:50:08','',''),(7567,'1','306','1',1,'Retail Sale Id 7745',1603.60,0.00,0.00,2.11,244.76,'2023-02-20 10:50:49','',''),(7568,'1','306','1',1,'Retail Sale Id 7746',1520.00,0.00,0.00,2.00,232.00,'2023-02-20 10:52:24','',''),(7569,'1','306','1',1,'Retail Sale Id 7747',1998.80,0.00,0.00,2.63,305.08,'2023-02-20 11:03:08','',''),(7570,'1','306','1',1,'Retail Sale Id 7748',1520.00,0.00,0.00,2.00,232.00,'2023-02-20 11:09:55','',''),(7571,'1','306','1',1,'Retail Sale Id 7750',2196.40,0.00,0.00,2.89,335.24,'2023-02-20 11:24:21','',''),(7572,'1','306','1',1,'Retail Sale Id 7751',3040.00,0.00,0.00,4.00,464.00,'2023-02-20 11:38:10','',''),(7573,'1','306','1',1,'Retail Sale Id 7751',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 11:38:10','',''),(7574,'1','306','1',1,'Retail Sale Id 7751',7600.00,0.00,0.00,10.00,1160.00,'2023-02-20 11:38:10','',''),(7575,'1','306','1',1,'Retail Sale Id 7752',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 11:52:23','',''),(7576,'1','306','1',1,'Retail Sale Id 7753',9500.00,0.00,0.00,12.50,1450.00,'2023-02-20 11:53:51','',''),(7577,'1','306','1',1,'Retail Sale Id 7754',9500.00,0.00,0.00,12.50,1450.00,'2023-02-20 11:55:17','',''),(7578,'1','306','1',1,'Retail Sale Id 7755',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 11:57:15','',''),(7579,'1','306','1',1,'Retail Sale Id 7756',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 11:58:04','',''),(7580,'1','306','1',1,'Retail Sale Id 7757',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 12:02:29','',''),(7581,'1','306','1',1,'Retail Sale Id 7758',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 12:04:16','',''),(7582,'1','306','1',1,'Retail Sale Id 7760',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 12:15:14','',''),(7583,'1','306','1',1,'Retail Sale Id 7761',760.00,0.00,0.00,1.00,116.00,'2023-02-20 12:21:35','',''),(7584,'1','306','1',1,'Retail Sale Id 7762',1520.00,0.00,0.00,2.00,232.00,'2023-02-20 12:23:43','',''),(7585,'1','306','1',1,'Retail Sale Id 7763',760.00,0.00,0.00,1.00,116.00,'2023-02-20 12:31:23','',''),(7586,'1','306','1',1,'Retail Sale Id 7764',1520.00,0.00,0.00,2.00,232.00,'2023-02-20 13:07:28','',''),(7587,'1','306','1',1,'Retail Sale Id 7765',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 13:13:01','',''),(7588,'1','306','1',1,'Retail Sale Id 7766',9500.00,0.00,0.00,12.50,1450.00,'2023-02-20 13:14:57','',''),(7589,'1','306','1',1,'Retail Sale Id 7767',3800.00,0.00,0.00,5.00,580.00,'2023-02-20 13:15:50','',''),(7590,'1','306','1',1,'Retail Sale Id 7770',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 13:19:47','',''),(7591,'1','306','1',1,'Retail Sale Id 7770',3800.00,0.00,0.00,5.00,580.00,'2023-02-20 13:19:47','',''),(7592,'1','306','1',1,'Retail Sale Id 7770',8740.00,0.00,0.00,11.50,1334.00,'2023-02-20 13:19:47','',''),(7593,'1','306','1',1,'Retail Sale Id 7771',1520.00,0.00,0.00,2.00,232.00,'2023-02-20 13:21:59','',''),(7594,'1','306','1',1,'Retail Sale Id 7772',760.00,0.00,0.00,1.00,116.00,'2023-02-20 13:23:20','',''),(7595,'1','306','1',1,'Retail Sale Id 7773',729.60,0.00,0.00,0.96,111.36,'2023-02-20 13:31:23','',''),(7596,'1','306','1',1,'Retail Sale Id 7774',4598.00,0.00,0.00,6.05,701.80,'2023-02-20 13:44:00','',''),(7597,'1','306','1',1,'Retail Sale Id 7775',3040.00,0.00,0.00,4.00,464.00,'2023-02-20 13:44:56','',''),(7598,'1','306','1',1,'Retail Sale Id 7776',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 13:49:26','',''),(7599,'1','306','1',1,'Retail Sale Id 7777',9500.00,0.00,0.00,12.50,1450.00,'2023-02-20 13:51:31','',''),(7600,'1','306','1',1,'Retail Sale Id 7778',3800.00,0.00,0.00,5.00,580.00,'2023-02-20 13:57:44','',''),(7601,'1','306','1',1,'Retail Sale Id 7780',3040.00,0.00,0.00,4.00,464.00,'2023-02-20 13:59:18','',''),(7602,'1','306','1',1,'Retail Sale Id 7781',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 14:01:09','',''),(7603,'1','306','1',1,'Retail Sale Id 7782',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 14:04:56','',''),(7604,'1','306','1',1,'Retail Sale Id 7783',3040.00,0.00,0.00,4.00,464.00,'2023-02-20 14:06:21','',''),(7605,'1','306','1',1,'Retail Sale Id 7784',798.00,0.00,0.00,1.05,121.80,'2023-02-20 14:08:25','',''),(7606,'1','306','1',1,'Retail Sale Id 7785',1520.00,0.00,0.00,2.00,232.00,'2023-02-20 14:26:53','',''),(7607,'1','306','1',1,'Retail Sale Id 7786',4499.20,0.00,0.00,5.92,686.72,'2023-02-20 14:29:00','',''),(7608,'1','306','1',1,'Retail Sale Id 7787',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 14:36:43','',''),(7609,'1','306','1',1,'Retail Sale Id 7788',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 14:37:51','',''),(7610,'1','306','1',1,'Retail Sale Id 7789',1003.20,0.00,0.00,1.32,153.12,'2023-02-20 14:40:17','',''),(7611,'1','306','1',1,'Retail Sale Id 7789',1003.20,0.00,0.00,1.32,153.12,'2023-02-20 14:40:17','',''),(7612,'1','306','1',1,'Retail Sale Id 7790',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 14:42:41','',''),(7613,'1','306','1',1,'Retail Sale Id 7791',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 14:43:27','',''),(7614,'1','306','1',1,'Retail Sale Id 7792',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 14:47:23','',''),(7615,'1','306','1',1,'Retail Sale Id 7793',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 14:51:11','',''),(7616,'1','306','1',1,'Retail Sale Id 7794',3800.00,0.00,0.00,5.00,580.00,'2023-02-20 14:57:20','',''),(7617,'1','306','1',1,'Retail Sale Id 7795',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 14:58:45','',''),(7618,'1','306','1',1,'Retail Sale Id 7796',760.00,0.00,0.00,1.00,116.00,'2023-02-20 14:59:20','',''),(7619,'1','306','1',1,'Retail Sale Id 7797',3002.00,0.00,0.00,3.95,458.20,'2023-02-20 15:00:51','',''),(7620,'1','306','1',1,'Retail Sale Id 7798',9500.00,0.00,0.00,12.50,1450.00,'2023-02-20 15:02:20','',''),(7621,'1','306','1',1,'Retail Sale Id 7799',3800.00,0.00,0.00,5.00,580.00,'2023-02-20 15:03:41','',''),(7622,'1','306','1',1,'Retail Sale Id 7800',3040.00,0.00,0.00,4.00,464.00,'2023-02-20 15:07:24','',''),(7623,'1','306','1',1,'Retail Sale Id 7801',1003.20,0.00,0.00,1.32,153.12,'2023-02-20 15:09:28','',''),(7624,'1','306','1',1,'Retail Sale Id 7802',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 15:12:14','',''),(7625,'1','306','1',1,'Retail Sale Id 7802',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 15:12:14','',''),(7626,'1','306','1',1,'Retail Sale Id 7803',5320.00,0.00,0.00,7.00,812.00,'2023-02-20 15:16:49','',''),(7627,'1','306','1',1,'Retail Sale Id 7804',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 15:19:39','',''),(7628,'1','306','1',1,'Retail Sale Id 7805',1497.20,0.00,0.00,1.97,228.52,'2023-02-20 15:21:20','',''),(7629,'1','306','1',1,'Retail Sale Id 7806',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 15:23:52','',''),(7630,'1','306','1',1,'Retail Sale Id 7807',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 15:27:00','',''),(7631,'1','306','1',1,'Retail Sale Id 7808',9500.00,0.00,0.00,12.50,1450.00,'2023-02-20 15:28:28','',''),(7632,'1','306','1',1,'Retail Sale Id 7809',1497.20,0.00,0.00,1.97,228.52,'2023-02-20 15:31:24','',''),(7633,'1','306','1',1,'Retail Sale Id 7810',3800.00,0.00,0.00,5.00,580.00,'2023-02-20 15:43:33','',''),(7634,'1','306','1',1,'Retail Sale Id 7811',1998.80,0.00,0.00,2.63,305.08,'2023-02-20 15:44:59','',''),(7635,'1','306','1',1,'Retail Sale Id 7812',2500.40,0.00,0.00,3.29,381.64,'2023-02-20 15:46:24','',''),(7636,'1','306','1',1,'Retail Sale Id 7813',3997.60,0.00,0.00,5.26,610.16,'2023-02-20 15:47:12','',''),(7637,'1','306','1',1,'Retail Sale Id 7814',9500.00,0.00,0.00,12.50,1450.00,'2023-02-20 15:49:17','',''),(7638,'1','306','1',1,'Retail Sale Id 7815',2302.80,0.00,0.00,3.03,351.48,'2023-02-20 15:50:20','',''),(7639,'1','306','1',1,'Retail Sale Id 7817',3040.00,0.00,0.00,4.00,464.00,'2023-02-20 15:55:56','',''),(7640,'1','306','1',1,'Retail Sale Id 7818',7600.00,0.00,0.00,10.00,1160.00,'2023-02-20 15:57:32','',''),(7641,'1','306','1',1,'Retail Sale Id 7819',3800.00,0.00,0.00,5.00,580.00,'2023-02-20 16:00:40','',''),(7642,'1','306','1',1,'Retail Sale Id 7820',1520.00,0.00,0.00,2.00,232.00,'2023-02-20 16:01:49','',''),(7643,'1','306','1',1,'Retail Sale Id 7821',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 16:03:13','',''),(7644,'1','306','1',1,'Retail Sale Id 7822',1520.00,0.00,0.00,2.00,232.00,'2023-02-20 16:04:42','',''),(7645,'1','306','1',1,'Retail Sale Id 7823',3800.00,0.00,0.00,5.00,580.00,'2023-02-20 16:07:01','',''),(7646,'1','306','1',1,'Retail Sale Id 7824',8360.00,0.00,0.00,11.00,1276.00,'2023-02-20 16:08:14','',''),(7647,'1','306','1',1,'Retail Sale Id 7825',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 16:10:51','',''),(7648,'1','306','1',1,'Retail Sale Id 7826',760.00,0.00,0.00,1.00,116.00,'2023-02-20 16:12:34','',''),(7649,'1','306','1',1,'Retail Sale Id 7828',8360.00,0.00,0.00,11.00,1276.00,'2023-02-20 16:14:23','',''),(7650,'1','306','1',1,'Retail Sale Id 7829',1520.00,0.00,0.00,2.00,232.00,'2023-02-20 16:25:14','',''),(7651,'1','306','1',1,'Retail Sale Id 7830',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 16:27:27','',''),(7652,'1','306','1',1,'Retail Sale Id 7831',29520.00,0.00,0.00,41.00,3116.00,'2023-02-20 16:53:34','',''),(7653,'1','306','1',1,'Retail Sale Id 7832',760.00,0.00,0.00,1.00,116.00,'2023-02-20 16:55:38','',''),(7654,'1','306','1',1,'Retail Sale Id 7832',9500.00,0.00,0.00,12.50,1450.00,'2023-02-20 16:55:38','',''),(7655,'1','306','1',1,'Retail Sale Id 7833',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 16:58:53','',''),(7656,'1','306','1',1,'Retail Sale Id 7834',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 16:59:34','',''),(7657,'1','306','1',1,'Retail Sale Id 7835',15200.00,0.00,0.00,20.00,2320.00,'2023-02-20 17:00:36','',''),(7658,'1','306','1',1,'Retail Sale Id 7836',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 17:01:45','',''),(7659,'1','306','1',1,'Retail Sale Id 7836',9500.00,0.00,0.00,12.50,1450.00,'2023-02-20 17:01:45','',''),(7660,'1','306','1',1,'Retail Sale Id 7837',3800.00,0.00,0.00,5.00,580.00,'2023-02-20 17:02:35','',''),(7661,'1','306','1',1,'Retail Sale Id 7839',798.00,0.00,0.00,1.05,121.80,'2023-02-20 17:07:22','',''),(7662,'1','306','1',1,'Retail Sale Id 7840',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 17:11:08','',''),(7663,'1','306','1',1,'Retail Sale Id 7843',3040.00,0.00,0.00,4.00,464.00,'2023-02-20 17:20:45','',''),(7664,'1','306','1',1,'Retail Sale Id 7844',6840.00,0.00,0.00,9.00,1044.00,'2023-02-20 17:25:15','',''),(7665,'1','306','1',1,'Retail Sale Id 7845',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 17:26:39','',''),(7666,'1','306','1',1,'Retail Sale Id 7846',57600.00,0.00,0.00,80.00,6080.00,'2023-02-20 17:28:16','',''),(7667,'1','306','1',1,'Retail Sale Id 7848',6080.00,0.00,0.00,8.00,928.00,'2023-02-20 17:30:09','',''),(7668,'1','306','1',1,'Retail Sale Id 7849',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 17:31:09','',''),(7669,'1','306','1',1,'Retail Sale Id 7850',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 17:32:38','',''),(7670,'1','306','1',1,'Retail Sale Id 7851',3800.00,0.00,0.00,5.00,580.00,'2023-02-20 17:33:27','',''),(7671,'1','306','1',1,'Retail Sale Id 7852',1200.80,0.00,0.00,1.58,183.28,'2023-02-20 17:34:50','',''),(7672,'1','306','1',1,'Retail Sale Id 7853',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 17:37:36','',''),(7673,'1','306','1',1,'Retail Sale Id 7854',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 17:39:15','',''),(7674,'1','306','1',1,'Retail Sale Id 7855',3800.00,0.00,0.00,5.00,580.00,'2023-02-20 17:40:31','',''),(7675,'1','306','1',1,'Retail Sale Id 7856',3800.00,0.00,0.00,5.00,580.00,'2023-02-20 17:41:19','',''),(7676,'1','306','1',1,'Retail Sale Id 7857',1520.00,0.00,0.00,2.00,232.00,'2023-02-20 17:45:11','',''),(7677,'1','306','1',1,'Retail Sale Id 7858',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 17:46:35','',''),(7678,'1','306','1',1,'Retail Sale Id 7859',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 18:00:42','',''),(7679,'1','306','1',1,'Retail Sale Id 7861',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 18:07:30','',''),(7680,'1','306','1',1,'Retail Sale Id 7862',2280.00,0.00,0.00,3.00,348.00,'2023-02-20 18:10:44','',''),(7681,'1','306','1',1,'Retail Sale Id 7862',9500.00,0.00,0.00,12.50,1450.00,'2023-02-20 18:10:44','',''),(7682,'1','306','1',1,'Retail Sale Id 7863',1520.00,0.00,0.00,2.00,232.00,'2023-02-20 18:13:14','',''),(7683,'1','306','1',1,'Retail Sale Id 7863',3040.00,0.00,0.00,4.00,464.00,'2023-02-20 18:13:14','',''),(7684,'1','306','1',1,'Retail Sale Id 7864',3503.60,0.00,0.00,4.61,534.76,'2023-02-20 18:15:26','',''),(7685,'1','306','1',1,'Retail Sale Id 7865',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 18:17:05','',''),(7686,'1','306','1',1,'Retail Sale Id 7866',1520.00,0.00,0.00,2.00,232.00,'2023-02-20 18:19:19','',''),(7687,'1','306','1',1,'Retail Sale Id 7867',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 18:24:37','',''),(7688,'1','306','1',1,'Retail Sale Id 7868',2302.80,0.00,0.00,3.03,351.48,'2023-02-20 18:27:26','',''),(7689,'1','306','1',1,'Retail Sale Id 7869',3040.00,0.00,0.00,4.00,464.00,'2023-02-20 18:31:53','',''),(7690,'1','306','1',1,'Retail Sale Id 7870',4560.00,0.00,0.00,6.00,696.00,'2023-02-20 18:33:35','',''),(7691,'1','306','1',1,'Retail Sale Id 7870',9500.00,0.00,0.00,12.50,1450.00,'2023-02-20 18:33:35','',''),(7692,'1','306','1',1,'Return of Retail Sale Id 7866',0.00,1520.00,2.00,0.00,-232.00,'2023-02-20 18:48:45','',''),(7693,'1','306','1',1,'Retail Sale Id 7871',1238.80,0.00,0.00,1.63,189.08,'2023-02-20 19:04:40','',''),(7694,'1','306','1',1,'Retail Sale Id 7872',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 07:23:56','',''),(7695,'1','306','1',1,'Retail Sale Id 7873',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 07:39:21','',''),(7696,'1','306','1',1,'Retail Sale Id 7874',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 07:47:29','',''),(7697,'1','306','1',1,'Retail Sale Id 7875',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 07:52:42','',''),(7698,'1','306','1',1,'Retail Sale Id 7876',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 07:53:44','',''),(7699,'1','306','1',1,'Retail Sale Id 7877',3002.00,0.00,0.00,3.95,458.20,'2023-02-21 07:55:07','',''),(7700,'1','306','1',1,'Retail Sale Id 7878',5320.00,0.00,0.00,7.00,812.00,'2023-02-21 07:56:26','',''),(7701,'1','306','1',1,'Retail Sale Id 7880',86400.00,0.00,0.00,120.00,9120.00,'2023-02-21 08:05:33','',''),(7702,'1','306','1',1,'Retail Sale Id 7881',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 08:06:51','',''),(7703,'1','306','1',1,'Retail Sale Id 7882',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 08:07:46','',''),(7704,'1','306','1',1,'Retail Sale Id 7883',1200.80,0.00,0.00,1.58,183.28,'2023-02-21 08:09:12','',''),(7705,'1','306','1',1,'Retail Sale Id 7884',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 08:11:41','',''),(7706,'1','306','1',1,'Retail Sale Id 7885',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 08:13:31','',''),(7707,'1','306','1',1,'Retail Sale Id 7886',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 08:22:47','',''),(7708,'1','306','1',1,'Retail Sale Id 7887',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 08:26:41','',''),(7709,'1','306','1',1,'Retail Sale Id 7888',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 08:31:18','',''),(7710,'1','306','1',1,'Retail Sale Id 7889',1003.20,0.00,0.00,1.32,153.12,'2023-02-21 08:33:06','',''),(7711,'1','306','1',1,'Retail Sale Id 7890',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 08:34:18','',''),(7712,'1','306','1',1,'Retail Sale Id 7891',15200.00,0.00,0.00,20.00,2320.00,'2023-02-21 08:37:02','',''),(7713,'1','306','1',1,'Retail Sale Id 7892',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 08:39:30','',''),(7714,'1','306','1',1,'Retail Sale Id 7893',1520.00,0.00,0.00,2.00,232.00,'2023-02-21 08:42:24','',''),(7715,'1','306','1',1,'Retail Sale Id 7894',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 08:43:13','',''),(7716,'1','306','1',1,'Retail Sale Id 7895',3040.00,0.00,0.00,4.00,464.00,'2023-02-21 08:44:37','',''),(7717,'1','306','1',1,'Retail Sale Id 7896',4499.20,0.00,0.00,5.92,686.72,'2023-02-21 08:46:29','',''),(7718,'1','306','1',1,'Retail Sale Id 7897',1520.00,0.00,0.00,2.00,232.00,'2023-02-21 08:48:08','',''),(7719,'1','306','1',1,'Retail Sale Id 7899',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 08:49:15','',''),(7720,'1','306','1',1,'Retail Sale Id 7900',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 08:49:59','',''),(7721,'1','306','1',1,'Retail Sale Id 7901',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 08:51:02','',''),(7722,'1','306','1',1,'Retail Sale Id 7902',6840.00,0.00,0.00,9.00,1044.00,'2023-02-21 08:52:07','',''),(7723,'1','306','1',1,'Retail Sale Id 7903',126000.00,0.00,0.00,175.00,13300.00,'2023-02-21 08:53:28','',''),(7724,'1','306','1',1,'Retail Sale Id 7904',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 08:54:20','',''),(7725,'1','306','1',1,'Retail Sale Id 7905',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 08:55:04','',''),(7726,'1','306','1',1,'Retail Sale Id 7906',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 08:57:15','',''),(7727,'1','306','1',1,'Retail Sale Id 7907',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 08:58:42','',''),(7728,'1','306','1',1,'Retail Sale Id 7908',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 09:04:58','',''),(7729,'1','306','1',1,'Retail Sale Id 7910',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 09:10:57','',''),(7730,'1','306','1',1,'Retail Sale Id 7911',5320.00,0.00,0.00,7.00,812.00,'2023-02-21 09:12:07','',''),(7731,'1','306','1',1,'Retail Sale Id 7912',33840.00,0.00,0.00,47.00,3572.00,'2023-02-21 09:13:56','',''),(7732,'1','306','1',1,'Retail Sale Id 7913',3503.60,0.00,0.00,4.61,534.76,'2023-02-21 09:15:22','',''),(7733,'1','306','1',1,'Retail Sale Id 7914',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 09:16:35','',''),(7734,'1','306','1',1,'Retail Sale Id 7915',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 09:19:17','',''),(7735,'1','306','1',1,'Retail Sale Id 7916',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 09:23:04','',''),(7736,'1','306','1',1,'Retail Sale Id 7917',1520.00,0.00,0.00,2.00,232.00,'2023-02-21 09:24:12','',''),(7737,'1','306','1',1,'Retail Sale Id 7918',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 09:25:44','',''),(7738,'1','306','1',1,'Retail Sale Id 7919',5320.00,0.00,0.00,7.00,812.00,'2023-02-21 09:29:21','',''),(7739,'1','306','1',1,'Retail Sale Id 7920',798.00,0.00,0.00,1.05,121.80,'2023-02-21 09:34:12','',''),(7740,'1','306','1',1,'Retail Sale Id 7921',1497.20,0.00,0.00,1.97,228.52,'2023-02-21 09:41:22','',''),(7741,'1','306','1',1,'Retail Sale Id 7922',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 09:45:24','',''),(7742,'1','306','1',1,'Retail Sale Id 7923',5000.80,0.00,0.00,6.58,763.28,'2023-02-21 09:49:15','',''),(7743,'1','306','1',1,'Retail Sale Id 7925',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 09:52:01','',''),(7744,'1','306','1',1,'Retail Sale Id 7926',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 09:56:14','',''),(7745,'1','306','1',1,'Retail Sale Id 7927',1497.20,0.00,0.00,1.97,228.52,'2023-02-21 09:58:02','',''),(7746,'1','306','1',1,'Retail Sale Id 7928',760.00,0.00,0.00,1.00,116.00,'2023-02-21 09:59:09','',''),(7747,'1','306','1',1,'Retail Sale Id 7929',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 09:59:56','',''),(7748,'1','306','1',1,'Retail Sale Id 7930',1520.00,0.00,0.00,2.00,232.00,'2023-02-21 10:00:52','',''),(7749,'1','306','1',1,'Retail Sale Id 7931',1520.00,0.00,0.00,2.00,232.00,'2023-02-21 10:09:27','',''),(7750,'1','306','1',1,'Retail Sale Id 7932',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 10:10:55','',''),(7751,'1','306','1',1,'Retail Sale Id 7933',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 10:13:41','',''),(7752,'1','306','1',1,'Retail Sale Id 7934',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 10:16:53','',''),(7753,'1','306','1',1,'Retail Sale Id 7935',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 10:18:05','',''),(7754,'1','306','1',1,'Retail Sale Id 7937',18000.00,0.00,0.00,25.00,1900.00,'2023-02-21 10:22:01','',''),(7755,'1','306','1',1,'Retail Sale Id 7938',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 10:25:35','',''),(7756,'1','306','1',1,'Retail Sale Id 7940',2302.80,0.00,0.00,3.03,351.48,'2023-02-21 10:27:27','',''),(7757,'1','306','1',1,'Retail Sale Id 7941',1520.00,0.00,0.00,2.00,232.00,'2023-02-21 10:34:34','',''),(7758,'1','306','1',1,'Retail Sale Id 7941',6840.00,0.00,0.00,9.00,1044.00,'2023-02-21 10:34:34','',''),(7759,'1','306','1',1,'Retail Sale Id 7943',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 10:39:19','',''),(7760,'1','306','1',1,'Retail Sale Id 7944',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 10:40:44','',''),(7761,'1','306','1',1,'Retail Sale Id 7945',8360.00,0.00,0.00,11.00,1276.00,'2023-02-21 10:45:55','',''),(7762,'1','306','1',1,'Retail Sale Id 7946',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 10:47:08','',''),(7763,'1','306','1',1,'Retail Sale Id 7949',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 10:54:52','',''),(7764,'1','306','1',1,'Retail Sale Id 7950',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 11:00:20','',''),(7765,'1','306','1',1,'Retail Sale Id 7951',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 11:04:26','',''),(7766,'1','306','1',1,'Retail Sale Id 7952',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 11:07:18','',''),(7767,'1','306','1',1,'Retail Sale Id 7953',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 11:08:28','',''),(7768,'1','306','1',1,'Retail Sale Id 7954',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 11:11:36','',''),(7769,'1','306','1',1,'Retail Sale Id 7955',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 11:15:59','',''),(7770,'1','306','1',1,'Retail Sale Id 7956',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 11:19:17','',''),(7771,'1','306','1',1,'Retail Sale Id 7957',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 11:24:21','',''),(7772,'1','306','1',1,'Retail Sale Id 7959',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 11:44:39','',''),(7773,'1','306','1',1,'Retail Sale Id 7960',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 11:47:27','',''),(7774,'1','306','1',1,'Retail Sale Id 7961',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 11:48:15','',''),(7775,'1','306','1',1,'Retail Sale Id 7962',1520.00,0.00,0.00,2.00,232.00,'2023-02-21 11:50:46','',''),(7776,'1','306','1',1,'Retail Sale Id 7963',1998.80,0.00,0.00,2.63,305.08,'2023-02-21 11:53:24','',''),(7777,'1','306','1',1,'Retail Sale Id 7964',3040.00,0.00,0.00,4.00,464.00,'2023-02-21 11:58:54','',''),(7778,'1','306','1',1,'Retail Sale Id 7965',38000.00,0.00,0.00,50.00,5800.00,'2023-02-21 11:59:41','',''),(7779,'1','306','1',1,'Retail Sale Id 7966',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 12:00:35','',''),(7780,'1','306','1',1,'Retail Sale Id 7967',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 12:02:29','',''),(7781,'1','306','1',1,'Retail Sale Id 7967',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 12:02:29','',''),(7782,'1','306','1',1,'Retail Sale Id 7969',4499.20,0.00,0.00,5.92,686.72,'2023-02-21 12:06:00','',''),(7783,'1','306','1',1,'Retail Sale Id 7970',7220.00,0.00,0.00,9.50,1102.00,'2023-02-21 12:11:32','',''),(7784,'1','306','1',1,'Retail Sale Id 7971',3040.00,0.00,0.00,4.00,464.00,'2023-02-21 12:12:43','',''),(7785,'1','306','1',1,'Retail Sale Id 7972',1497.20,0.00,0.00,1.97,228.52,'2023-02-21 12:13:28','',''),(7786,'1','306','1',1,'Retail Sale Id 7973',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 12:16:28','',''),(7787,'1','306','1',1,'Retail Sale Id 7974',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 12:20:02','',''),(7788,'1','306','1',1,'Retail Sale Id 7975',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 12:21:51','',''),(7789,'1','306','1',1,'Retail Sale Id 7976',1603.60,0.00,0.00,2.11,244.76,'2023-02-21 12:23:03','',''),(7790,'1','306','1',1,'Retail Sale Id 7977',1520.00,0.00,0.00,2.00,232.00,'2023-02-21 12:23:57','',''),(7791,'1','306','1',1,'Retail Sale Id 7978',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 12:27:55','',''),(7792,'1','306','1',1,'Retail Sale Id 7979',3040.00,0.00,0.00,4.00,464.00,'2023-02-21 12:31:23','',''),(7793,'1','306','1',1,'Retail Sale Id 7980',798.00,0.00,0.00,1.05,121.80,'2023-02-21 12:32:26','',''),(7794,'1','306','1',1,'Retail Sale Id 7981',1520.00,0.00,0.00,2.00,232.00,'2023-02-21 12:34:10','',''),(7795,'1','306','1',1,'Retail Sale Id 7982',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 12:38:21','',''),(7796,'1','306','1',1,'Retail Sale Id 7983',1520.00,0.00,0.00,2.00,232.00,'2023-02-21 12:39:54','',''),(7797,'1','306','1',1,'Retail Sale Id 7984',1520.00,0.00,0.00,2.00,232.00,'2023-02-21 12:41:50','',''),(7798,'1','306','1',1,'Retail Sale Id 7985',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 12:48:10','',''),(7799,'1','306','1',1,'Retail Sale Id 7986',501.60,0.00,0.00,0.66,76.56,'2023-02-21 12:49:21','',''),(7800,'1','306','1',1,'Retail Sale Id 7987',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 12:50:05','',''),(7801,'1','306','1',1,'Retail Sale Id 7988',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 12:53:18','',''),(7802,'1','306','1',1,'Retail Sale Id 7989',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 12:59:44','',''),(7803,'1','306','1',1,'Retail Sale Id 7990',1520.00,0.00,0.00,2.00,232.00,'2023-02-21 13:02:45','',''),(7804,'1','306','1',1,'Retail Sale Id 7991',1603.60,0.00,0.00,2.11,244.76,'2023-02-21 13:12:04','',''),(7805,'1','306','1',1,'Retail Sale Id 7992',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 13:14:49','',''),(7806,'1','306','1',1,'Retail Sale Id 7993',1003.20,0.00,0.00,1.32,153.12,'2023-02-21 13:16:01','',''),(7807,'1','306','1',1,'Retail Sale Id 7994',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 13:17:37','',''),(7808,'1','306','1',1,'Retail Sale Id 7995',3100.80,0.00,0.00,4.08,473.28,'2023-02-21 13:18:56','',''),(7809,'1','306','1',1,'Retail Sale Id 7996',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 13:20:58','',''),(7810,'1','306','1',1,'Retail Sale Id 7997',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 13:22:09','',''),(7811,'1','306','1',1,'Retail Sale Id 7998',6080.00,0.00,0.00,8.00,928.00,'2023-02-21 13:36:21','',''),(7812,'1','306','1',1,'Retail Sale Id 7999',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 13:40:16','',''),(7813,'1','306','1',1,'Retail Sale Id 8000',600.40,0.00,0.00,0.79,91.64,'2023-02-21 13:47:01','',''),(7814,'1','306','1',1,'Retail Sale Id 8001',798.00,0.00,0.00,1.05,121.80,'2023-02-21 13:47:52','',''),(7815,'1','306','1',1,'Return of Retail Sale Id 8000',0.00,600.40,0.79,0.00,-91.64,'2023-02-21 13:48:19','',''),(7816,'1','306','1',1,'Retail Sale Id 8002',1497.20,0.00,0.00,1.97,228.52,'2023-02-21 13:49:02','',''),(7817,'1','306','1',1,'Retail Sale Id 8003',1003.20,0.00,0.00,1.32,153.12,'2023-02-21 13:52:04','',''),(7818,'1','306','1',1,'Retail Sale Id 8004',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 13:57:03','',''),(7819,'1','306','1',1,'Retail Sale Id 8005',1603.60,0.00,0.00,2.11,244.76,'2023-02-21 14:04:59','',''),(7820,'1','306','1',1,'Retail Sale Id 8006',2302.80,0.00,0.00,3.03,351.48,'2023-02-21 14:07:53','',''),(7821,'1','306','1',1,'Retail Sale Id 8008',4320.00,0.00,0.00,6.00,456.00,'2023-02-21 14:10:35','',''),(7822,'1','306','1',1,'Retail Sale Id 8009',1520.00,0.00,0.00,2.00,232.00,'2023-02-21 14:11:36','',''),(7823,'1','306','1',1,'Retail Sale Id 8010',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 14:12:22','',''),(7824,'1','306','1',1,'Retail Sale Id 8011',3040.00,0.00,0.00,4.00,464.00,'2023-02-21 14:14:50','',''),(7825,'1','306','1',1,'Retail Sale Id 8013',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 14:16:49','',''),(7826,'1','306','1',1,'Retail Sale Id 8014',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 14:20:39','',''),(7827,'1','306','1',1,'Retail Sale Id 8015',1998.80,0.00,0.00,2.63,305.08,'2023-02-21 14:32:31','',''),(7828,'1','306','1',1,'Retail Sale Id 8016',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 14:34:26','',''),(7829,'1','306','1',1,'Retail Sale Id 8017',2660.00,0.00,0.00,3.50,406.00,'2023-02-21 14:39:00','',''),(7830,'1','306','1',1,'Retail Sale Id 8018',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 14:43:51','',''),(7831,'1','306','1',1,'Retail Sale Id 8019',8002.80,0.00,0.00,10.53,1221.48,'2023-02-21 14:45:25','',''),(7832,'1','306','1',1,'Retail Sale Id 8020',1520.00,0.00,0.00,2.00,232.00,'2023-02-21 14:50:27','',''),(7833,'1','306','1',1,'Retail Sale Id 8021',1003.20,0.00,0.00,1.32,153.12,'2023-02-21 14:52:30','',''),(7834,'1','306','1',1,'Retail Sale Id 8022',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 14:54:05','',''),(7835,'1','306','1',1,'Retail Sale Id 8023',3040.00,0.00,0.00,4.00,464.00,'2023-02-21 14:55:32','',''),(7836,'1','306','1',1,'Retail Sale Id 8024',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 14:56:58','',''),(7837,'1','306','1',1,'Retail Sale Id 8025',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 14:59:08','',''),(7838,'1','306','1',1,'Retail Sale Id 8026',1520.00,0.00,0.00,2.00,232.00,'2023-02-21 15:01:50','',''),(7839,'1','306','1',1,'Retail Sale Id 8027',3040.00,0.00,0.00,4.00,464.00,'2023-02-21 15:10:21','',''),(7840,'1','306','1',1,'Retail Sale Id 8030',1520.00,0.00,0.00,2.00,232.00,'2023-02-21 15:38:43','',''),(7841,'1','306','1',1,'Retail Sale Id 8031',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 15:40:19','',''),(7842,'1','306','1',1,'Retail Sale Id 8032',2302.80,0.00,0.00,3.03,351.48,'2023-02-21 15:41:25','',''),(7843,'1','306','1',1,'Retail Sale Id 8034',4499.20,0.00,0.00,5.92,686.72,'2023-02-21 15:56:11','',''),(7844,'1','306','1',1,'Retail Sale Id 8035',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 16:01:13','',''),(7845,'1','306','1',1,'Retail Sale Id 8036',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 16:04:33','',''),(7846,'1','306','1',1,'Retail Sale Id 8036',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 16:04:33','',''),(7847,'1','306','1',1,'Retail Sale Id 8037',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 16:11:01','',''),(7848,'1','306','1',1,'Retail Sale Id 8038',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 16:21:31','',''),(7849,'1','306','1',1,'Retail Sale Id 8039',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 16:23:08','',''),(7850,'1','306','1',1,'Retail Sale Id 8040',13300.00,0.00,0.00,17.50,2030.00,'2023-02-21 16:25:08','',''),(7851,'1','306','1',1,'Retail Sale Id 8041',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 16:26:29','',''),(7852,'1','306','1',1,'Retail Sale Id 8042',1520.00,0.00,0.00,2.00,232.00,'2023-02-21 16:27:47','',''),(7853,'1','306','1',1,'Retail Sale Id 8043',7600.00,0.00,0.00,10.00,1160.00,'2023-02-21 16:29:00','',''),(7854,'1','306','1',1,'Retail Sale Id 8044',1003.20,0.00,0.00,1.32,153.12,'2023-02-21 16:29:46','',''),(7855,'1','306','1',1,'Retail Sale Id 8045',6999.60,0.00,0.00,9.21,1068.36,'2023-02-21 16:31:18','',''),(7856,'1','306','1',1,'Retail Sale Id 8046',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 16:32:17','',''),(7857,'1','306','1',1,'Retail Sale Id 8047',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 16:34:15','',''),(7858,'1','306','1',1,'Retail Sale Id 8048',1003.20,0.00,0.00,1.32,153.12,'2023-02-21 16:41:57','',''),(7859,'1','306','1',1,'Retail Sale Id 8049',1003.20,0.00,0.00,1.32,153.12,'2023-02-21 16:50:24','',''),(7860,'1','306','1',1,'Retail Sale Id 8050',1550.40,0.00,0.00,2.04,236.64,'2023-02-21 17:00:15','',''),(7861,'1','306','1',1,'Retail Sale Id 8051',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 17:05:30','',''),(7862,'1','306','1',1,'Retail Sale Id 8053',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 17:13:04','',''),(7863,'1','306','1',1,'Retail Sale Id 8054',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 17:14:21','',''),(7864,'1','306','1',1,'Retail Sale Id 8055',3040.00,0.00,0.00,4.00,464.00,'2023-02-21 17:17:27','',''),(7865,'1','306','1',1,'Retail Sale Id 8056',1550.40,0.00,0.00,2.04,236.64,'2023-02-21 17:19:55','',''),(7866,'1','306','1',1,'Retail Sale Id 8057',2302.80,0.00,0.00,3.03,351.48,'2023-02-21 17:24:33','',''),(7867,'1','306','1',1,'Retail Sale Id 8058',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 17:25:20','',''),(7868,'1','306','1',1,'Retail Sale Id 8059',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 17:26:23','',''),(7869,'1','306','1',1,'Retail Sale Id 8060',3800.00,0.00,0.00,5.00,580.00,'2023-02-21 17:28:54','',''),(7870,'1','306','1',1,'Retail Sale Id 8061',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 17:30:01','',''),(7871,'1','306','1',1,'Retail Sale Id 8062',8496.80,0.00,0.00,11.18,1296.88,'2023-02-21 17:31:06','',''),(7872,'1','306','1',1,'Retail Sale Id 8063',3040.00,0.00,0.00,4.00,464.00,'2023-02-21 17:34:20','',''),(7873,'1','306','1',1,'Retail Sale Id 8064',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 17:35:03','',''),(7874,'1','306','1',1,'Retail Sale Id 8065',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 17:38:13','',''),(7875,'1','306','1',1,'Retail Sale Id 8066',3002.00,0.00,0.00,3.95,458.20,'2023-02-21 17:41:20','',''),(7876,'1','306','1',1,'Retail Sale Id 8067',2302.80,0.00,0.00,3.03,351.48,'2023-02-21 17:42:47','',''),(7877,'1','306','1',1,'Retail Sale Id 8068',3040.00,0.00,0.00,4.00,464.00,'2023-02-21 17:44:46','',''),(7878,'1','306','1',1,'Retail Sale Id 8069',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 17:45:39','',''),(7879,'1','306','1',1,'Retail Sale Id 8070',3997.60,0.00,0.00,5.26,610.16,'2023-02-21 17:46:52','',''),(7880,'1','306','1',1,'Retail Sale Id 8071',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 17:47:43','',''),(7881,'1','306','1',1,'Retail Sale Id 8072',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 17:49:00','',''),(7882,'1','306','1',1,'Retail Sale Id 8074',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 17:54:53','',''),(7883,'1','306','1',1,'Retail Sale Id 8075',6080.00,0.00,0.00,8.00,928.00,'2023-02-21 17:55:35','',''),(7884,'1','306','1',1,'Retail Sale Id 8076',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 17:56:27','',''),(7885,'1','306','1',1,'Retail Sale Id 8077',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 17:57:11','',''),(7886,'1','306','1',1,'Retail Sale Id 8078',760.00,0.00,0.00,1.00,116.00,'2023-02-21 17:59:23','',''),(7887,'1','306','1',1,'Retail Sale Id 8079',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 18:03:16','',''),(7888,'1','306','1',1,'Retail Sale Id 8080',4560.00,0.00,0.00,6.00,696.00,'2023-02-21 18:06:09','',''),(7889,'1','306','1',1,'Retail Sale Id 8081',9500.00,0.00,0.00,12.50,1450.00,'2023-02-21 18:13:13','',''),(7890,'1','306','1',1,'Retail Sale Id 8083',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 18:31:51','',''),(7891,'1','306','1',1,'Retail Sale Id 8084',8002.80,0.00,0.00,10.53,1221.48,'2023-02-21 18:32:44','',''),(7892,'1','306','1',1,'Retail Sale Id 8086',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 18:35:25','',''),(7893,'1','306','1',1,'Retail Sale Id 8087',2280.00,0.00,0.00,3.00,348.00,'2023-02-21 18:35:54','',''),(7894,'1','306','1',1,'Retail Sale Id 8088',1520.00,0.00,0.00,2.00,232.00,'2023-02-21 18:41:54','',''),(7895,'1','306','1',1,'Retail Sale Id 8089',1998.80,0.00,0.00,2.63,305.08,'2023-02-21 18:43:10','',''),(7896,'1','306','1',1,'Return of Retail Sale Id 8081',0.00,9500.00,12.50,0.00,-1450.00,'2023-02-21 19:00:26','',''),(7897,'1','306','1',1,'Retail Sale Id 8090',4712.00,0.00,0.00,6.20,719.20,'2023-02-21 19:01:32','',''),(7898,'1','306','1',1,'Retail Sale Id 8091',6080.00,0.00,0.00,8.00,928.00,'2023-02-22 07:23:09','',''),(7899,'1','306','1',1,'Retail Sale Id 8093',760.00,0.00,0.00,1.00,116.00,'2023-02-22 07:26:04','',''),(7900,'1','306','1',1,'Retail Sale Id 8094',3800.00,0.00,0.00,5.00,580.00,'2023-02-22 07:38:26','',''),(7901,'1','306','1',1,'Retail Sale Id 8094',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 07:38:26','',''),(7902,'1','306','1',1,'Retail Sale Id 8096',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 07:55:13','',''),(7903,'1','306','1',1,'Retail Sale Id 8097',3800.00,0.00,0.00,5.00,580.00,'2023-02-22 07:58:15','',''),(7904,'1','306','1',1,'Retail Sale Id 8098',3040.00,0.00,0.00,4.00,464.00,'2023-02-22 07:59:37','',''),(7905,'1','306','1',1,'Retail Sale Id 8098',9500.00,0.00,0.00,12.50,1450.00,'2023-02-22 07:59:37','',''),(7906,'1','306','1',1,'Retail Sale Id 8099',1520.00,0.00,0.00,2.00,232.00,'2023-02-22 08:03:31','',''),(7907,'1','306','1',1,'Retail Sale Id 8100',9500.00,0.00,0.00,12.50,1450.00,'2023-02-22 08:05:14','',''),(7908,'1','306','1',1,'Retail Sale Id 8102',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 08:09:18','',''),(7909,'1','306','1',1,'Retail Sale Id 8102',9500.00,0.00,0.00,12.50,1450.00,'2023-02-22 08:09:18','',''),(7910,'1','306','1',1,'Retail Sale Id 8102',9500.00,0.00,0.00,12.50,1450.00,'2023-02-22 08:09:18','',''),(7911,'1','306','1',1,'Retail Sale Id 8103',6840.00,0.00,0.00,9.00,1044.00,'2023-02-22 08:11:22','',''),(7912,'1','306','1',1,'Retail Sale Id 8104',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 08:21:13','',''),(7913,'1','306','1',1,'Retail Sale Id 8105',1801.20,0.00,0.00,2.37,274.92,'2023-02-22 08:25:01','',''),(7914,'1','306','1',1,'Retail Sale Id 8107',3040.00,0.00,0.00,4.00,464.00,'2023-02-22 08:28:48','',''),(7915,'1','306','1',1,'Retail Sale Id 8108',5000.80,0.00,0.00,6.58,763.28,'2023-02-22 08:32:24','',''),(7916,'1','306','1',1,'Retail Sale Id 8109',3040.00,0.00,0.00,4.00,464.00,'2023-02-22 08:33:16','',''),(7917,'1','306','1',1,'Retail Sale Id 8110',3800.00,0.00,0.00,5.00,580.00,'2023-02-22 08:33:59','',''),(7918,'1','306','1',1,'Retail Sale Id 8111',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 08:34:44','',''),(7919,'1','306','1',1,'Retail Sale Id 8112',896.80,0.00,0.00,1.18,136.88,'2023-02-22 08:35:38','',''),(7920,'1','306','1',1,'Retail Sale Id 8113',9500.00,0.00,0.00,12.50,1450.00,'2023-02-22 08:37:09','',''),(7921,'1','306','1',1,'Retail Sale Id 8114',9500.00,0.00,0.00,12.50,1450.00,'2023-02-22 08:38:38','',''),(7922,'1','306','1',1,'Retail Sale Id 8115',2196.40,0.00,0.00,2.89,335.24,'2023-02-22 08:39:49','',''),(7923,'1','306','1',1,'Retail Sale Id 8116',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 08:43:33','',''),(7924,'1','306','1',1,'Retail Sale Id 8117',3800.00,0.00,0.00,5.00,580.00,'2023-02-22 08:44:30','',''),(7925,'1','306','1',1,'Retail Sale Id 8119',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 08:46:02','',''),(7926,'1','306','1',1,'Retail Sale Id 8120',9500.00,0.00,0.00,12.50,1450.00,'2023-02-22 08:47:15','',''),(7927,'1','306','1',1,'Retail Sale Id 8121',1520.00,0.00,0.00,2.00,232.00,'2023-02-22 08:51:23','',''),(7928,'1','306','1',1,'Retail Sale Id 8122',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 08:56:04','',''),(7929,'1','306','1',1,'Retail Sale Id 8123',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 08:58:36','',''),(7930,'1','306','1',1,'Retail Sale Id 8124',1998.80,0.00,0.00,2.63,305.08,'2023-02-22 09:02:23','',''),(7931,'1','306','1',1,'Retail Sale Id 8124',8002.80,0.00,0.00,10.53,1221.48,'2023-02-22 09:02:23','',''),(7932,'1','306','1',1,'Retail Sale Id 8125',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 09:06:07','',''),(7933,'1','306','1',1,'Retail Sale Id 8126',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 09:11:26','',''),(7934,'1','306','1',1,'Retail Sale Id 8126',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 09:11:26','',''),(7935,'1','306','1',1,'Retail Sale Id 8127',6080.00,0.00,0.00,8.00,928.00,'2023-02-22 09:13:18','',''),(7936,'1','306','1',1,'Retail Sale Id 8128',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 09:18:06','',''),(7937,'1','306','1',1,'Retail Sale Id 8130',760.00,0.00,0.00,1.00,116.00,'2023-02-22 09:20:00','',''),(7938,'1','306','1',1,'Retail Sale Id 8132',3040.00,0.00,0.00,4.00,464.00,'2023-02-22 09:25:14','',''),(7939,'1','306','1',1,'Retail Sale Id 8134',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 09:27:17','',''),(7940,'1','306','1',1,'Retail Sale Id 8135',1520.00,0.00,0.00,2.00,232.00,'2023-02-22 09:28:31','',''),(7941,'1','306','1',1,'Retail Sale Id 8136',7600.00,0.00,0.00,10.00,1160.00,'2023-02-22 09:29:19','',''),(7942,'1','306','1',1,'Retail Sale Id 8137',3997.60,0.00,0.00,5.26,610.16,'2023-02-22 09:30:51','',''),(7943,'1','306','1',1,'Retail Sale Id 8140',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 09:33:55','',''),(7944,'1','306','1',1,'Retail Sale Id 8141',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 09:37:52','',''),(7945,'1','306','1',1,'Retail Sale Id 8142',760.00,0.00,0.00,1.00,116.00,'2023-02-22 09:39:58','',''),(7946,'1','306','1',1,'Retail Sale Id 8143',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 09:44:58','',''),(7947,'1','306','1',1,'Retail Sale Id 8144',3002.00,0.00,0.00,3.95,458.20,'2023-02-22 09:47:27','',''),(7948,'1','306','1',1,'Retail Sale Id 8145',3800.00,0.00,0.00,5.00,580.00,'2023-02-22 09:49:22','',''),(7949,'1','306','1',1,'Retail Sale Id 8145',3800.00,0.00,0.00,5.00,580.00,'2023-02-22 09:49:22','',''),(7950,'1','306','1',1,'Retail Sale Id 8146',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 09:51:12','',''),(7951,'1','306','1',1,'Retail Sale Id 8147',1520.00,0.00,0.00,2.00,232.00,'2023-02-22 09:52:43','',''),(7952,'1','306','1',1,'Retail Sale Id 8148',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 09:53:53','',''),(7953,'1','306','1',1,'Retail Sale Id 8149',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 09:55:25','',''),(7954,'1','306','1',1,'Retail Sale Id 8150',9500.00,0.00,0.00,12.50,1450.00,'2023-02-22 09:57:19','',''),(7955,'1','306','1',1,'Retail Sale Id 8152',5320.00,0.00,0.00,7.00,812.00,'2023-02-22 10:03:07','',''),(7956,'1','306','1',1,'Retail Sale Id 8155',6080.00,0.00,0.00,8.00,928.00,'2023-02-22 10:09:11','',''),(7957,'1','306','1',1,'Retail Sale Id 8156',3800.00,0.00,0.00,5.00,580.00,'2023-02-22 10:10:15','',''),(7958,'1','306','1',1,'Retail Sale Id 8157',43200.00,0.00,0.00,60.00,4560.00,'2023-02-22 10:11:28','',''),(7959,'1','306','1',1,'Retail Sale Id 8158',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 10:12:18','',''),(7960,'1','306','1',1,'Retail Sale Id 8159',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 10:13:24','',''),(7961,'1','306','1',1,'Retail Sale Id 8159',3800.00,0.00,0.00,5.00,580.00,'2023-02-22 10:13:24','',''),(7962,'1','306','1',1,'Retail Sale Id 8160',1520.00,0.00,0.00,2.00,232.00,'2023-02-22 10:14:30','',''),(7963,'1','306','1',1,'Retail Sale Id 8160',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 10:14:30','',''),(7964,'1','306','1',1,'Retail Sale Id 8161',3800.00,0.00,0.00,5.00,580.00,'2023-02-22 10:19:30','',''),(7965,'1','306','1',1,'Retail Sale Id 8163',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 10:23:35','',''),(7966,'1','306','1',1,'Retail Sale Id 8164',10640.00,0.00,0.00,14.00,1624.00,'2023-02-22 10:25:37','',''),(7967,'1','306','1',1,'Retail Sale Id 8165',7600.00,0.00,0.00,10.00,1160.00,'2023-02-22 10:27:21','',''),(7968,'1','306','1',1,'Retail Sale Id 8166',2500.40,0.00,0.00,3.29,381.64,'2023-02-22 10:31:20','',''),(7969,'1','306','1',1,'Retail Sale Id 8167',3800.00,0.00,0.00,5.00,580.00,'2023-02-22 10:35:51','',''),(7970,'1','306','1',1,'Retail Sale Id 8168',1998.80,0.00,0.00,2.63,305.08,'2023-02-22 10:45:54','',''),(7971,'1','306','1',1,'Retail Sale Id 8171',3040.00,0.00,0.00,4.00,464.00,'2023-02-22 10:57:10','',''),(7972,'1','306','1',1,'Retail Sale Id 8172',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 11:01:54','',''),(7973,'1','306','1',1,'Retail Sale Id 8173',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 11:03:13','',''),(7974,'1','306','1',1,'Retail Sale Id 8174',1520.00,0.00,0.00,2.00,232.00,'2023-02-22 11:05:24','',''),(7975,'1','306','1',1,'Retail Sale Id 8175',1900.00,0.00,0.00,2.50,290.00,'2023-02-22 11:06:53','',''),(7976,'1','306','1',1,'Retail Sale Id 8177',3040.00,0.00,0.00,4.00,464.00,'2023-02-22 11:10:36','',''),(7977,'1','306','1',1,'Retail Sale Id 8178',3040.00,0.00,0.00,4.00,464.00,'2023-02-22 11:12:02','',''),(7978,'1','306','1',1,'Retail Sale Id 8179',3040.00,0.00,0.00,4.00,464.00,'2023-02-22 11:12:43','',''),(7979,'1','306','1',1,'Retail Sale Id 8180',9500.00,0.00,0.00,12.50,1450.00,'2023-02-22 11:13:52','',''),(7980,'1','306','1',1,'Retail Sale Id 8181',2302.80,0.00,0.00,3.03,351.48,'2023-02-22 11:19:19','',''),(7981,'1','306','1',1,'Retail Sale Id 8182',1200.80,0.00,0.00,1.58,183.28,'2023-02-22 11:23:08','',''),(7982,'1','306','1',1,'Retail Sale Id 8183',1003.20,0.00,0.00,1.32,153.12,'2023-02-22 11:40:05','',''),(7983,'1','306','1',1,'Retail Sale Id 8184',760.00,0.00,0.00,1.00,116.00,'2023-02-22 11:41:09','',''),(7984,'1','306','1',1,'Retail Sale Id 8185',9500.00,0.00,0.00,12.50,1450.00,'2023-02-22 11:49:47','',''),(7985,'1','306','1',1,'Retail Sale Id 8186',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 11:50:45','',''),(7986,'1','306','1',1,'Retail Sale Id 8187',5320.00,0.00,0.00,7.00,812.00,'2023-02-22 11:51:53','',''),(7987,'1','306','1',1,'Retail Sale Id 8188',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 11:52:38','',''),(7988,'1','306','1',1,'Retail Sale Id 8189',760.00,0.00,0.00,1.00,116.00,'2023-02-22 11:54:58','',''),(7989,'1','306','1',1,'Retail Sale Id 8190',3040.00,0.00,0.00,4.00,464.00,'2023-02-22 11:59:32','',''),(7990,'1','306','1',1,'Retail Sale Id 8191',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 12:08:39','',''),(7991,'1','306','1',1,'Retail Sale Id 8192',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 12:10:27','',''),(7992,'1','306','1',1,'Retail Sale Id 8196',1520.00,0.00,0.00,2.00,232.00,'2023-02-22 12:26:53','',''),(7993,'1','306','1',1,'Retail Sale Id 8197',1003.20,0.00,0.00,1.32,153.12,'2023-02-22 12:32:17','',''),(7994,'1','306','1',1,'Retail Sale Id 8198',1003.20,0.00,0.00,1.32,153.12,'2023-02-22 12:38:31','',''),(7995,'1','306','1',1,'Retail Sale Id 8199',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 12:49:04','',''),(7996,'1','306','1',1,'Retail Sale Id 8200',1497.20,0.00,0.00,1.97,228.52,'2023-02-22 12:57:39','',''),(7997,'1','306','1',1,'Retail Sale Id 8201',3800.00,0.00,0.00,5.00,580.00,'2023-02-22 13:01:38','',''),(7998,'1','306','1',1,'Retail Sale Id 8202',18000.00,0.00,0.00,25.00,1900.00,'2023-02-22 13:04:00','',''),(7999,'1','306','1',1,'Retail Sale Id 8203',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 13:09:49','',''),(8000,'1','306','1',1,'Retail Sale Id 8204',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 13:11:08','',''),(8001,'1','306','1',1,'Retail Sale Id 8205',3800.00,0.00,0.00,5.00,580.00,'2023-02-22 13:13:54','',''),(8002,'1','306','1',1,'Retail Sale Id 8206',9880.00,0.00,0.00,13.00,1508.00,'2023-02-22 13:16:05','',''),(8003,'1','306','1',1,'Retail Sale Id 8207',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 13:18:35','',''),(8004,'1','306','1',1,'Retail Sale Id 8208',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 13:20:08','',''),(8005,'1','306','1',1,'Retail Sale Id 8209',3503.60,0.00,0.00,4.61,534.76,'2023-02-22 13:23:39','',''),(8006,'1','306','1',1,'Retail Sale Id 8210',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 13:24:54','',''),(8007,'1','306','1',1,'Retail Sale Id 8211',6999.60,0.00,0.00,9.21,1068.36,'2023-02-22 13:40:46','',''),(8008,'1','306','1',1,'Retail Sale Id 8212',1520.00,0.00,0.00,2.00,232.00,'2023-02-22 13:43:44','',''),(8009,'1','306','1',1,'Retail Sale Id 8213',1520.00,0.00,0.00,2.00,232.00,'2023-02-22 13:48:13','',''),(8010,'1','306','1',1,'Retail Sale Id 8214',3800.00,0.00,0.00,5.00,580.00,'2023-02-22 13:49:50','',''),(8011,'1','306','1',1,'Retail Sale Id 8215',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 13:52:00','',''),(8012,'1','306','1',1,'Retail Sale Id 8216',1520.00,0.00,0.00,2.00,232.00,'2023-02-22 13:55:30','',''),(8013,'1','306','1',1,'Retail Sale Id 8217',9500.00,0.00,0.00,12.50,1450.00,'2023-02-22 13:56:55','',''),(8014,'1','306','1',1,'Retail Sale Id 8218',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 13:58:22','',''),(8015,'1','306','1',1,'Retail Sale Id 8219',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 14:01:07','',''),(8016,'1','306','1',1,'Retail Sale Id 8220',3040.00,0.00,0.00,4.00,464.00,'2023-02-22 14:05:52','',''),(8017,'1','306','1',1,'Retail Sale Id 8221',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 14:09:37','',''),(8018,'1','306','1',1,'Retail Sale Id 8222',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 14:13:04','',''),(8019,'1','306','1',1,'Retail Sale Id 8223',2500.40,0.00,0.00,3.29,381.64,'2023-02-22 14:14:23','',''),(8020,'1','306','1',1,'Retail Sale Id 8224',9500.00,0.00,0.00,12.50,1450.00,'2023-02-22 14:15:59','',''),(8021,'1','306','1',1,'Retail Sale Id 8226',9500.00,0.00,0.00,12.50,1450.00,'2023-02-22 14:53:40','',''),(8022,'1','306','1',1,'Retail Sale Id 8227',3040.00,0.00,0.00,4.00,464.00,'2023-02-22 14:55:39','',''),(8023,'1','306','1',1,'Retail Sale Id 8229',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 14:58:46','',''),(8024,'1','306','1',1,'Retail Sale Id 8230',3997.60,0.00,0.00,5.26,610.16,'2023-02-22 15:01:57','',''),(8025,'1','306','1',1,'Retail Sale Id 8231',3800.00,0.00,0.00,5.00,580.00,'2023-02-22 15:03:19','',''),(8026,'1','306','1',1,'Retail Sale Id 8232',798.00,0.00,0.00,1.05,121.80,'2023-02-22 15:04:30','',''),(8027,'1','306','1',1,'Retail Sale Id 8233',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 15:05:21','',''),(8028,'1','306','1',1,'Retail Sale Id 8234',3002.00,0.00,0.00,3.95,458.20,'2023-02-22 15:06:02','',''),(8029,'1','306','1',1,'Retail Sale Id 8235',2302.80,0.00,0.00,3.03,351.48,'2023-02-22 15:06:45','',''),(8030,'1','306','1',1,'Retail Sale Id 8237',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 15:20:56','',''),(8031,'1','306','1',1,'Retail Sale Id 8237',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 15:20:56','',''),(8032,'1','306','1',1,'Retail Sale Id 8238',3800.00,0.00,0.00,5.00,580.00,'2023-02-22 15:23:00','',''),(8033,'1','306','1',1,'Retail Sale Id 8239',3040.00,0.00,0.00,4.00,464.00,'2023-02-22 15:24:36','',''),(8034,'1','306','1',1,'Retail Sale Id 8240',9500.00,0.00,0.00,12.50,1450.00,'2023-02-22 15:28:17','',''),(8035,'1','306','1',1,'Retail Sale Id 8243',2302.80,0.00,0.00,3.03,351.48,'2023-02-22 15:31:54','',''),(8036,'1','306','1',1,'Retail Sale Id 8244',798.00,0.00,0.00,1.05,121.80,'2023-02-22 15:43:16','',''),(8037,'1','306','1',1,'Retail Sale Id 8245',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 15:49:01','',''),(8038,'1','306','1',1,'Retail Sale Id 8245',9500.00,0.00,0.00,12.50,1450.00,'2023-02-22 15:49:01','',''),(8039,'1','306','1',1,'Retail Sale Id 8246',2090.00,0.00,0.00,2.75,319.00,'2023-02-22 16:04:36','',''),(8040,'1','306','1',1,'Retail Sale Id 8247',1520.00,0.00,0.00,2.00,232.00,'2023-02-22 16:20:24','',''),(8041,'1','306','1',1,'Retail Sale Id 8248',3800.00,0.00,0.00,5.00,580.00,'2023-02-22 16:21:26','',''),(8042,'1','306','1',1,'Retail Sale Id 8249',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 16:23:03','',''),(8043,'1','306','1',1,'Retail Sale Id 8250',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 16:23:50','',''),(8044,'1','306','1',1,'Retail Sale Id 8251',6840.00,0.00,0.00,9.00,1044.00,'2023-02-22 16:25:01','',''),(8045,'1','306','1',1,'Retail Sale Id 8252',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 16:29:47','',''),(8046,'1','306','1',1,'Retail Sale Id 8253',2302.80,0.00,0.00,3.03,351.48,'2023-02-22 16:38:06','',''),(8047,'1','306','1',1,'Retail Sale Id 8256',1497.20,0.00,0.00,1.97,228.52,'2023-02-22 16:47:42','',''),(8048,'1','306','1',1,'Retail Sale Id 8257',2302.80,0.00,0.00,3.03,351.48,'2023-02-22 17:03:48','',''),(8049,'1','306','1',1,'Retail Sale Id 8258',3800.00,0.00,0.00,5.00,580.00,'2023-02-22 17:08:45','',''),(8050,'1','306','1',1,'Retail Sale Id 8259',3040.00,0.00,0.00,4.00,464.00,'2023-02-22 17:10:10','',''),(8051,'1','306','1',1,'Retail Sale Id 8260',2302.80,0.00,0.00,3.03,351.48,'2023-02-22 17:21:04','',''),(8052,'1','306','1',1,'Retail Sale Id 8261',2302.80,0.00,0.00,3.03,351.48,'2023-02-22 17:25:37','',''),(8053,'1','306','1',1,'Retail Sale Id 8262',3100.80,0.00,0.00,4.08,473.28,'2023-02-22 17:26:42','',''),(8054,'1','306','1',1,'Retail Sale Id 8263',1497.20,0.00,0.00,1.97,228.52,'2023-02-22 17:29:58','',''),(8055,'1','306','1',1,'Retail Sale Id 8264',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 17:39:07','',''),(8056,'1','306','1',1,'Retail Sale Id 8265',2903.20,0.00,0.00,3.82,443.12,'2023-02-22 17:40:21','',''),(8057,'1','306','1',1,'Retail Sale Id 8266',1998.80,0.00,0.00,2.63,305.08,'2023-02-22 17:51:18','',''),(8058,'1','306','1',1,'Retail Sale Id 8267',1520.00,0.00,0.00,2.00,232.00,'2023-02-22 17:54:10','',''),(8059,'1','306','1',1,'Retail Sale Id 8268',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 17:57:20','',''),(8060,'1','306','1',1,'Retail Sale Id 8269',2599.20,0.00,0.00,3.42,396.72,'2023-02-22 18:00:51','',''),(8061,'1','306','1',1,'Retail Sale Id 8270',2302.80,0.00,0.00,3.03,351.48,'2023-02-22 18:12:59','',''),(8062,'1','306','1',1,'Retail Sale Id 8272',9500.00,0.00,0.00,12.50,1450.00,'2023-02-22 18:19:47','',''),(8063,'1','306','1',1,'Retail Sale Id 8273',1520.00,0.00,0.00,2.00,232.00,'2023-02-22 18:25:02','',''),(8064,'1','306','1',1,'Retail Sale Id 8274',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 18:26:49','',''),(8065,'1','306','1',1,'Retail Sale Id 8275',3040.00,0.00,0.00,4.00,464.00,'2023-02-22 18:28:07','',''),(8066,'1','306','1',1,'Retail Sale Id 8276',1520.00,0.00,0.00,2.00,232.00,'2023-02-22 18:32:28','',''),(8067,'1','306','1',1,'Retail Sale Id 8276',1520.00,0.00,0.00,2.00,232.00,'2023-02-22 18:32:28','',''),(8068,'1','306','1',1,'Retail Sale Id 8277',3040.00,0.00,0.00,4.00,464.00,'2023-02-22 18:37:43','',''),(8069,'1','306','1',1,'Retail Sale Id 8278',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 18:38:48','',''),(8070,'1','306','1',1,'Retail Sale Id 8279',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 18:40:07','',''),(8071,'1','306','1',1,'Retail Sale Id 8279',4560.00,0.00,0.00,6.00,696.00,'2023-02-22 18:40:07','',''),(8072,'1','306','1',1,'Retail Sale Id 8279',7600.00,0.00,0.00,10.00,1160.00,'2023-02-22 18:40:07','',''),(8073,'1','306','1',1,'Retail Sale Id 8280',2280.00,0.00,0.00,3.00,348.00,'2023-02-22 18:40:57','',''),(8074,'1','306','1',1,'Retail Sale Id 8281',3997.60,0.00,0.00,5.26,610.16,'2023-02-22 18:41:51','',''),(8075,'1','306','1',1,'Retail Sale Id 8282',3800.00,0.00,0.00,5.00,580.00,'2023-02-22 18:44:28','',''),(8076,'1','306','1',1,'Retail Sale Id 8283',1140.00,0.00,0.00,1.50,174.00,'2023-02-22 18:45:21','',''),(8077,'1','306','1',1,'Retail Sale Id 8284',1998.80,0.00,0.00,2.63,305.08,'2023-02-22 18:57:14','',''),(8078,'1','306','1',1,'Return of Retail Sale Id 8284',0.00,1998.80,2.63,0.00,-305.08,'2023-02-22 19:16:18','',''),(8079,'1','306','1',1,'Retail Sale Id 8285',2561.20,0.00,0.00,3.37,390.92,'2023-02-22 19:17:19','',''),(8080,'1','306','1',1,'Retail Sale Id 8286',2660.00,0.00,0.00,3.50,406.00,'2023-02-23 07:24:37','',''),(8081,'1','306','1',1,'Retail Sale Id 8288',9500.00,0.00,0.00,12.50,1450.00,'2023-02-23 07:27:27','',''),(8082,'1','306','1',1,'Retail Sale Id 8289',1520.00,0.00,0.00,2.00,232.00,'2023-02-23 07:28:08','',''),(8083,'1','306','1',1,'Retail Sale Id 8290',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 07:28:44','',''),(8084,'1','306','1',1,'Retail Sale Id 8291',2280.00,0.00,0.00,3.00,348.00,'2023-02-23 07:30:41','',''),(8085,'1','306','1',1,'Retail Sale Id 8292',3040.00,0.00,0.00,4.00,464.00,'2023-02-23 07:31:13','',''),(8086,'1','306','1',1,'Retail Sale Id 8293',2500.40,0.00,0.00,3.29,381.64,'2023-02-23 07:32:39','',''),(8087,'1','306','1',1,'Retail Sale Id 8294',3997.60,0.00,0.00,5.26,610.16,'2023-02-23 07:42:28','',''),(8088,'1','306','1',1,'Retail Sale Id 8295',760.00,0.00,0.00,1.00,116.00,'2023-02-23 07:50:26','',''),(8089,'1','306','1',1,'Retail Sale Id 8296',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 07:51:18','',''),(8090,'1','306','1',1,'Retail Sale Id 8297',3040.00,0.00,0.00,4.00,464.00,'2023-02-23 07:52:28','',''),(8091,'1','306','1',1,'Retail Sale Id 8298',3800.00,0.00,0.00,5.00,580.00,'2023-02-23 07:53:25','',''),(8092,'1','306','1',1,'Retail Sale Id 8299',5000.80,0.00,0.00,6.58,763.28,'2023-02-23 07:57:02','',''),(8093,'1','306','1',1,'Retail Sale Id 8300',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 08:03:25','',''),(8094,'1','306','1',1,'Retail Sale Id 8301',2280.00,0.00,0.00,3.00,348.00,'2023-02-23 08:04:56','',''),(8095,'1','306','1',1,'Retail Sale Id 8302',34560.00,0.00,0.00,48.00,3648.00,'2023-02-23 08:06:35','',''),(8096,'1','306','1',1,'Retail Sale Id 8303',37440.00,0.00,0.00,52.00,3952.00,'2023-02-23 08:07:58','',''),(8097,'1','306','1',1,'Retail Sale Id 8304',1520.00,0.00,0.00,2.00,232.00,'2023-02-23 08:14:34','',''),(8098,'1','306','1',1,'Retail Sale Id 8305',7200.00,0.00,0.00,10.00,760.00,'2023-02-23 08:17:28','',''),(8099,'1','306','1',1,'Retail Sale Id 8307',2160.00,0.00,0.00,3.00,228.00,'2023-02-23 08:19:09','',''),(8100,'1','306','1',1,'Retail Sale Id 8308',2280.00,0.00,0.00,3.00,348.00,'2023-02-23 08:20:10','',''),(8101,'1','306','1',1,'Retail Sale Id 8309',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 08:21:25','',''),(8102,'1','306','1',1,'Retail Sale Id 8310',2280.00,0.00,0.00,3.00,348.00,'2023-02-23 08:23:09','',''),(8103,'1','306','1',1,'Retail Sale Id 8311',7600.00,0.00,0.00,10.00,1160.00,'2023-02-23 08:24:00','',''),(8104,'1','306','1',1,'Retail Sale Id 8312',3040.00,0.00,0.00,4.00,464.00,'2023-02-23 08:25:16','',''),(8105,'1','306','1',1,'Retail Sale Id 8312',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 08:25:16','',''),(8106,'1','306','1',1,'Retail Sale Id 8313',2280.00,0.00,0.00,3.00,348.00,'2023-02-23 08:26:28','',''),(8107,'1','306','1',1,'Retail Sale Id 8314',2280.00,0.00,0.00,3.00,348.00,'2023-02-23 08:27:53','',''),(8108,'1','306','1',1,'Retail Sale Id 8314',9500.00,0.00,0.00,12.50,1450.00,'2023-02-23 08:27:53','',''),(8109,'1','306','1',1,'Retail Sale Id 8315',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 08:30:35','',''),(8110,'1','306','1',1,'Retail Sale Id 8315',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 08:30:35','',''),(8111,'1','306','1',1,'Retail Sale Id 8316',2280.00,0.00,0.00,3.00,348.00,'2023-02-23 08:31:31','',''),(8112,'1','306','1',1,'Retail Sale Id 8317',7600.00,0.00,0.00,10.00,1160.00,'2023-02-23 08:32:21','',''),(8113,'1','306','1',1,'Retail Sale Id 8318',3800.00,0.00,0.00,5.00,580.00,'2023-02-23 08:33:31','',''),(8114,'1','306','1',1,'Retail Sale Id 8318',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 08:33:31','',''),(8115,'1','306','1',1,'Retail Sale Id 8319',7600.00,0.00,0.00,10.00,1160.00,'2023-02-23 08:34:29','',''),(8116,'1','306','1',1,'Retail Sale Id 8320',3040.00,0.00,0.00,4.00,464.00,'2023-02-23 08:35:24','',''),(8117,'1','306','1',1,'Retail Sale Id 8321',5000.80,0.00,0.00,6.58,763.28,'2023-02-23 08:37:10','',''),(8118,'1','306','1',1,'Retail Sale Id 8322',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 08:37:49','',''),(8119,'1','306','1',1,'Retail Sale Id 8323',9500.00,0.00,0.00,12.50,1450.00,'2023-02-23 08:40:39','',''),(8120,'1','306','1',1,'Retail Sale Id 8324',3800.00,0.00,0.00,5.00,580.00,'2023-02-23 08:42:00','',''),(8121,'1','306','1',1,'Retail Sale Id 8325',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 08:44:45','',''),(8122,'1','306','1',1,'Retail Sale Id 8326',2280.00,0.00,0.00,3.00,348.00,'2023-02-23 08:46:10','',''),(8123,'1','306','1',1,'Retail Sale Id 8327',6840.00,0.00,0.00,9.00,1044.00,'2023-02-23 08:50:16','',''),(8124,'1','306','1',1,'Retail Sale Id 8328',2280.00,0.00,0.00,3.00,348.00,'2023-02-23 08:51:32','',''),(8125,'1','306','1',1,'Retail Sale Id 8329',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 08:52:30','',''),(8126,'1','306','1',1,'Retail Sale Id 8330',3040.00,0.00,0.00,4.00,464.00,'2023-02-23 08:53:39','',''),(8127,'1','306','1',1,'Retail Sale Id 8331',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 08:54:23','',''),(8128,'1','306','1',1,'Retail Sale Id 8331',9500.00,0.00,0.00,12.50,1450.00,'2023-02-23 08:54:23','',''),(8129,'1','306','1',1,'Retail Sale Id 8332',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 08:56:36','',''),(8130,'1','306','1',1,'Retail Sale Id 8333',1200.80,0.00,0.00,1.58,183.28,'2023-02-23 08:57:08','',''),(8131,'1','306','1',1,'Retail Sale Id 8334',3040.00,0.00,0.00,4.00,464.00,'2023-02-23 08:58:36','',''),(8132,'1','306','1',1,'Retail Sale Id 8335',43200.00,0.00,0.00,60.00,4560.00,'2023-02-23 09:01:34','',''),(8133,'1','306','1',1,'Retail Sale Id 8336',3040.00,0.00,0.00,4.00,464.00,'2023-02-23 09:03:13','',''),(8134,'1','306','1',1,'Retail Sale Id 8337',1520.00,0.00,0.00,2.00,232.00,'2023-02-23 09:05:48','',''),(8135,'1','306','1',1,'Retail Sale Id 8338',1998.80,0.00,0.00,2.63,305.08,'2023-02-23 09:06:27','',''),(8136,'1','306','1',1,'Retail Sale Id 8339',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 09:13:19','',''),(8137,'1','306','1',1,'Retail Sale Id 8341',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 09:57:06','',''),(8138,'1','306','1',1,'Retail Sale Id 8342',3800.00,0.00,0.00,5.00,580.00,'2023-02-23 09:59:06','',''),(8139,'1','306','1',1,'Retail Sale Id 8343',2280.00,0.00,0.00,3.00,348.00,'2023-02-23 10:01:56','',''),(8140,'1','306','1',1,'Retail Sale Id 8344',2280.00,0.00,0.00,3.00,348.00,'2023-02-23 10:06:06','',''),(8141,'1','306','1',1,'Retail Sale Id 8345',760.00,0.00,0.00,1.00,116.00,'2023-02-23 10:17:28','',''),(8142,'1','306','1',1,'Retail Sale Id 8346',9925.60,0.00,0.00,13.06,1514.96,'2023-02-23 10:31:13','',''),(8143,'1','306','1',1,'Distributed to J A GAS for sales id:7',161605.36,0.00,0.00,250.94,0.00,'2023-02-23 10:53:43','',''),(8144,'1','306',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,1674400.00,2600.00,0.00,0.00,'2023-02-23 12:43:14','',''),(8145,'1','306',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,2600.00,0.00,'2023-02-23 12:44:15','',''),(8146,'1','306','1',1,'Received from bridging 17',0.00,0.00,2600.00,0.00,0.00,'2023-02-23 12:44:15','',''),(8147,'1','306','1',1,'Retail Sale Id 8347',2280.00,0.00,0.00,3.00,348.00,'2023-02-23 12:45:08','',''),(8148,'1','306','1',1,'Retail Sale Id 8348',3040.00,0.00,0.00,4.00,464.00,'2023-02-23 12:46:13','',''),(8149,'1','306','1',1,'Retail Sale Id 8348',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 12:46:13','',''),(8150,'1','306','1',1,'Retail Sale Id 8349',1520.00,0.00,0.00,2.00,232.00,'2023-02-23 12:47:29','',''),(8151,'1','306','1',1,'Retail Sale Id 8350',9500.00,0.00,0.00,12.50,1450.00,'2023-02-23 12:50:47','',''),(8152,'1','306','1',1,'Retail Sale Id 8351',18000.00,0.00,0.00,25.00,1900.00,'2023-02-23 12:52:18','',''),(8153,'1','306','1',1,'Retail Sale Id 8352',1998.80,0.00,0.00,2.63,305.08,'2023-02-23 12:54:01','',''),(8154,'1','306','1',1,'Retail Sale Id 8353',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 12:54:52','',''),(8155,'1','306','1',1,'Retail Sale Id 8354',4180.00,0.00,0.00,5.50,638.00,'2023-02-23 12:55:31','',''),(8156,'1','306','1',1,'Retail Sale Id 8355',1497.20,0.00,0.00,1.97,228.52,'2023-02-23 12:56:55','',''),(8157,'1','306','1',1,'Retail Sale Id 8356',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 12:58:51','',''),(8158,'1','306','1',1,'Retail Sale Id 8357',2280.00,0.00,0.00,3.00,348.00,'2023-02-23 13:01:10','',''),(8159,'1','306','1',1,'Retail Sale Id 8358',3800.00,0.00,0.00,5.00,580.00,'2023-02-23 13:03:37','',''),(8160,'1','306','1',1,'Retail Sale Id 8359',9500.00,0.00,0.00,12.50,1450.00,'2023-02-23 13:04:14','',''),(8161,'1','306','1',1,'Retail Sale Id 8360',3040.00,0.00,0.00,4.00,464.00,'2023-02-23 13:07:17','',''),(8162,'1','306','1',1,'Retail Sale Id 8361',3503.60,0.00,0.00,4.61,534.76,'2023-02-23 13:09:15','',''),(8163,'1','306','1',1,'Retail Sale Id 8362',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 13:11:19','',''),(8164,'1','306','1',1,'Retail Sale Id 8363',2280.00,0.00,0.00,3.00,348.00,'2023-02-23 13:13:31','',''),(8165,'1','306','1',1,'Retail Sale Id 8364',3199.60,0.00,0.00,4.21,488.36,'2023-02-23 13:14:23','',''),(8166,'1','306','1',1,'Retail Sale Id 8365',3040.00,0.00,0.00,4.00,464.00,'2023-02-23 13:15:57','',''),(8167,'1','306','1',1,'Retail Sale Id 8366',9500.00,0.00,0.00,12.50,1450.00,'2023-02-23 13:17:06','',''),(8168,'1','306','1',1,'Retail Sale Id 8367',2280.00,0.00,0.00,3.00,348.00,'2023-02-23 13:19:23','',''),(8169,'1','306','1',1,'Retail Sale Id 8368',3800.00,0.00,0.00,5.00,580.00,'2023-02-23 13:20:39','',''),(8170,'1','306','1',1,'Retail Sale Id 8369',1998.80,0.00,0.00,2.63,305.08,'2023-02-23 13:22:16','',''),(8171,'1','306','1',1,'Retail Sale Id 8370',3040.00,0.00,0.00,4.00,464.00,'2023-02-23 13:24:14','',''),(8172,'1','306','1',1,'Retail Sale Id 8371',3997.60,0.00,0.00,5.26,610.16,'2023-02-23 13:25:58','',''),(8173,'1','306','1',1,'Retail Sale Id 8372',2280.00,0.00,0.00,3.00,348.00,'2023-02-23 13:27:17','',''),(8174,'1','306','1',1,'Retail Sale Id 8373',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 13:27:56','',''),(8175,'1','306','1',1,'Retail Sale Id 8374',3040.00,0.00,0.00,4.00,464.00,'2023-02-23 13:28:29','',''),(8176,'1','306','1',1,'Retail Sale Id 8375',4180.00,0.00,0.00,5.50,638.00,'2023-02-23 13:29:42','',''),(8177,'1','306','1',1,'Retail Sale Id 8376',3800.00,0.00,0.00,5.00,580.00,'2023-02-23 13:31:12','',''),(8178,'1','306','1',1,'Retail Sale Id 8377',1299.60,0.00,0.00,1.71,198.36,'2023-02-23 13:32:36','',''),(8179,'1','306','1',1,'Retail Sale Id 8378',2280.00,0.00,0.00,3.00,348.00,'2023-02-23 13:33:19','',''),(8180,'1','306','1',1,'Retail Sale Id 8379',2280.00,0.00,0.00,3.00,348.00,'2023-02-23 13:34:34','',''),(8181,'1','306','1',1,'Retail Sale Id 8380',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 13:37:30','',''),(8182,'1','306','1',1,'Retail Sale Id 8380',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 13:37:30','',''),(8183,'1','306','1',1,'Retail Sale Id 8381',6080.00,0.00,0.00,8.00,928.00,'2023-02-23 13:38:16','',''),(8184,'1','306','1',1,'Retail Sale Id 8382',1497.20,0.00,0.00,1.97,228.52,'2023-02-23 13:38:55','',''),(8185,'1','306','1',1,'Retail Sale Id 8383',2280.00,0.00,0.00,3.00,348.00,'2023-02-23 13:39:28','',''),(8186,'1','306','1',1,'Retail Sale Id 8384',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 13:40:49','',''),(8187,'1','306','1',1,'Retail Sale Id 8385',9500.00,0.00,0.00,12.50,1450.00,'2023-02-23 13:42:21','',''),(8188,'1','306','1',1,'Retail Sale Id 8386',1200.80,0.00,0.00,1.58,183.28,'2023-02-23 13:42:55','',''),(8189,'1','306','1',1,'Retail Sale Id 8387',2280.00,0.00,0.00,3.00,348.00,'2023-02-23 13:43:31','',''),(8190,'1','306','1',1,'Retail Sale Id 8388',3800.00,0.00,0.00,5.00,580.00,'2023-02-23 13:44:14','',''),(8191,'1','306','1',1,'Retail Sale Id 8390',3040.00,0.00,0.00,4.00,464.00,'2023-02-23 13:45:24','',''),(8192,'1','306','1',1,'Retail Sale Id 8391',4560.00,0.00,0.00,6.00,696.00,'2023-02-23 13:46:04','',''),(8193,'1','306','1',1,'Retail Sale Id 8392',3040.00,0.00,0.00,4.00,464.00,'2023-02-23 13:46:40','',''),(8194,'1','306','1',1,'Retail Sale Id 8393',1520.00,0.00,0.00,2.00,232.00,'2023-02-23 13:50:32','',''),(8195,'1','306','1',1,'Retail Sale Id 8394',1520.00,0.00,0.00,2.00,232.00,'2023-02-23 13:55:06','',''),(8196,'1','306','1',1,'Retail Sale Id 8395',1998.80,0.00,0.00,2.63,305.08,'2023-02-23 13:57:37','',''),(8197,'1','306','1',1,'Retail Sale Id 8396',58360.40,0.00,0.00,76.79,8907.64,'2023-02-23 18:31:24','',''),(8198,'1','306','1',1,'Retail Sale Id 8398',3040.00,0.00,0.00,4.00,464.00,'2023-02-24 17:25:16','',''),(8199,'1','306','1',1,'Retail Sale Id 8399',3100.80,0.00,0.00,4.08,473.28,'2023-02-24 17:28:15','',''),(8200,'1','306','1',1,'Retail Sale Id 8400',1520.00,0.00,0.00,2.00,232.00,'2023-02-24 17:29:05','',''),(8201,'1','306','1',1,'Retail Sale Id 8401',3040.00,0.00,0.00,4.00,464.00,'2023-02-24 17:30:42','',''),(8202,'1','306','1',1,'Retail Sale Id 8403',1550.40,0.00,0.00,2.04,236.64,'2023-02-24 17:36:31','',''),(8203,'1','306','1',1,'Retail Sale Id 8404',1998.80,0.00,0.00,2.63,305.08,'2023-02-24 17:41:31','',''),(8204,'1','306','1',1,'Retail Sale Id 8405',1003.20,0.00,0.00,1.32,153.12,'2023-02-24 17:43:25','',''),(8205,'1','306','1',1,'Retail Sale Id 8406',3800.00,0.00,0.00,5.00,580.00,'2023-02-24 17:45:00','',''),(8206,'1','306','1',1,'Retail Sale Id 8407',3800.00,0.00,0.00,5.00,580.00,'2023-02-24 17:47:40','',''),(8207,'1','306','1',1,'Retail Sale Id 8408',1520.00,0.00,0.00,2.00,232.00,'2023-02-24 17:51:47','',''),(8208,'1','306','1',1,'Retail Sale Id 8409',3800.00,0.00,0.00,5.00,580.00,'2023-02-24 17:52:47','',''),(8209,'1','306','1',1,'Retail Sale Id 8410',3800.00,0.00,0.00,5.00,580.00,'2023-02-24 17:54:23','',''),(8210,'1','306','1',1,'Retail Sale Id 8411',9500.00,0.00,0.00,12.50,1450.00,'2023-02-24 17:55:35','',''),(8211,'1','306','1',1,'Retail Sale Id 8412',14440.00,0.00,0.00,19.00,2204.00,'2023-02-24 17:56:26','',''),(8212,'1','306','1',1,'Retail Sale Id 8413',4560.00,0.00,0.00,6.00,696.00,'2023-02-24 17:57:21','',''),(8213,'1','306','1',1,'Retail Sale Id 8414',1520.00,0.00,0.00,2.00,232.00,'2023-02-24 17:58:43','',''),(8214,'1','306','1',1,'Retail Sale Id 8415',3040.00,0.00,0.00,4.00,464.00,'2023-02-24 17:59:49','',''),(8215,'1','306','1',1,'Retail Sale Id 8416',2280.00,0.00,0.00,3.00,348.00,'2023-02-24 18:02:06','',''),(8216,'1','306','1',1,'Retail Sale Id 8417',9500.00,0.00,0.00,12.50,1450.00,'2023-02-24 18:03:44','',''),(8217,'1','306','1',1,'Retail Sale Id 8418',2280.00,0.00,0.00,3.00,348.00,'2023-02-24 18:05:08','',''),(8218,'1','306','1',1,'Retail Sale Id 8419',1520.00,0.00,0.00,2.00,232.00,'2023-02-24 18:08:25','',''),(8219,'1','306','1',1,'Retail Sale Id 8419',3040.00,0.00,0.00,4.00,464.00,'2023-02-24 18:08:25','',''),(8220,'1','306','1',1,'Retail Sale Id 8420',7501.20,0.00,0.00,9.87,1144.92,'2023-02-24 18:12:48','',''),(8221,'1','306','1',1,'Retail Sale Id 8421',7600.00,0.00,0.00,10.00,1160.00,'2023-02-24 18:14:55','',''),(8222,'1','306','1',1,'Retail Sale Id 8423',2280.00,0.00,0.00,3.00,348.00,'2023-02-24 18:15:37','',''),(8223,'1','306','1',1,'Retail Sale Id 8424',4560.00,0.00,0.00,6.00,696.00,'2023-02-24 18:16:10','',''),(8224,'1','306','1',1,'Retail Sale Id 8425',16560.00,0.00,0.00,23.00,1748.00,'2023-02-24 18:19:47','',''),(8225,'1','306','1',1,'Retail Sale Id 8426',1998.80,0.00,0.00,2.63,305.08,'2023-02-24 18:20:28','',''),(8226,'1','306','1',1,'Retail Sale Id 8427',3800.00,0.00,0.00,5.00,580.00,'2023-02-24 18:22:02','',''),(8227,'1','306','1',1,'Retail Sale Id 8428',760.00,0.00,0.00,1.00,116.00,'2023-02-24 18:24:16','',''),(8228,'1','306','1',1,'Retail Sale Id 8429',6080.00,0.00,0.00,8.00,928.00,'2023-02-24 18:27:46','',''),(8229,'1','306','1',1,'Retail Sale Id 8430',2302.80,0.00,0.00,3.03,351.48,'2023-02-24 18:36:52','',''),(8230,'1','306','1',1,'Retail Sale Id 8431',9500.00,0.00,0.00,12.50,1450.00,'2023-02-24 18:40:30','',''),(8231,'1','306','1',1,'Retail Sale Id 8432',2280.00,0.00,0.00,3.00,348.00,'2023-02-24 18:42:31','',''),(8232,'1','306','1',1,'Retail Sale Id 8432',9120.00,0.00,0.00,12.00,1392.00,'2023-02-24 18:42:31','',''),(8233,'1','306','1',1,'Retail Sale Id 8434',3040.00,0.00,0.00,4.00,464.00,'2023-02-24 18:43:33','',''),(8234,'1','306','1',1,'Retail Sale Id 8435',3800.00,0.00,0.00,5.00,580.00,'2023-02-24 18:44:07','',''),(8235,'1','306','1',1,'Retail Sale Id 8436',5000.80,0.00,0.00,6.58,763.28,'2023-02-24 18:44:46','',''),(8236,'1','306','1',1,'Retail Sale Id 8437',3800.00,0.00,0.00,5.00,580.00,'2023-02-24 18:45:26','',''),(8237,'1','306','1',1,'Retail Sale Id 8438',2280.00,0.00,0.00,3.00,348.00,'2023-02-24 18:46:09','',''),(8238,'1','306','1',1,'Retail Sale Id 8439',10080.00,0.00,0.00,14.00,1064.00,'2023-02-24 18:47:41','',''),(8239,'1','306','1',1,'Retail Sale Id 8440',760.00,0.00,0.00,1.00,116.00,'2023-02-24 18:49:40','',''),(8240,'1','306','1',1,'Retail Sale Id 8441',3040.00,0.00,0.00,4.00,464.00,'2023-02-24 18:51:22','',''),(8241,'1','306','1',1,'Retail Sale Id 8442',1520.00,0.00,0.00,2.00,232.00,'2023-02-24 18:54:41','',''),(8242,'1','306','1',1,'Retail Sale Id 8443',2280.00,0.00,0.00,3.00,348.00,'2023-02-24 18:57:24','',''),(8243,'1','306','1',1,'Retail Sale Id 8444',2280.00,0.00,0.00,3.00,348.00,'2023-02-24 18:58:09','',''),(8244,'1','306','1',1,'Retail Sale Id 8445',3800.00,0.00,0.00,5.00,580.00,'2023-02-24 19:03:28','',''),(8245,'1','306','1',1,'Retail Sale Id 8446',2280.00,0.00,0.00,3.00,348.00,'2023-02-24 19:24:31','',''),(8246,'1','306','1',1,'Retail Sale Id 8447',9500.00,0.00,0.00,12.50,1450.00,'2023-02-24 19:32:40','',''),(8247,'1','306','1',1,'Retail Sale Id 8448',25194.00,0.00,0.00,33.15,3845.40,'2023-02-24 20:56:34','',''),(8248,'1','306','1',1,'Return of Retail Sale Id 8439',0.00,10080.00,14.00,0.00,-1064.00,'2023-02-24 20:59:38','',''),(8249,'1','306','1',1,'Retail Sale Id 8449',10404.00,0.00,0.00,14.45,1098.20,'2023-02-24 21:03:18','',''),(8250,'1','306','1',1,'Retail Sale Id 8450',3800.00,0.00,0.00,5.00,580.00,'2023-02-26 09:03:27','',''),(8251,'1','306','1',1,'Retail Sale Id 8451',4560.00,0.00,0.00,6.00,696.00,'2023-02-26 09:04:12','',''),(8252,'1','306','1',1,'Retail Sale Id 8452',760.00,0.00,0.00,1.00,116.00,'2023-02-26 09:10:26','',''),(8253,'1','306','1',1,'Retail Sale Id 8453',9500.00,0.00,0.00,12.50,1450.00,'2023-02-26 09:11:29','',''),(8254,'1','306','1',1,'Retail Sale Id 8454',1497.20,0.00,0.00,1.97,228.52,'2023-02-26 09:12:37','',''),(8255,'1','306','1',1,'Retail Sale Id 8455',18000.00,0.00,0.00,25.00,1900.00,'2023-02-26 09:18:26','',''),(8256,'1','306','1',1,'Retail Sale Id 8456',5320.00,0.00,0.00,7.00,812.00,'2023-02-26 09:30:10','',''),(8257,'1','306','1',1,'Retail Sale Id 8457',3040.00,0.00,0.00,4.00,464.00,'2023-02-26 09:36:23','',''),(8258,'1','306','1',1,'Retail Sale Id 8458',1003.20,0.00,0.00,1.32,153.12,'2023-02-26 09:38:12','',''),(8259,'1','306','1',1,'Retail Sale Id 8460',2280.00,0.00,0.00,3.00,348.00,'2023-02-26 09:45:52','',''),(8260,'1','306','1',1,'Retail Sale Id 8461',108000.00,0.00,0.00,150.00,11400.00,'2023-02-26 09:48:58','',''),(8261,'1','306','1',1,'Retail Sale Id 8462',54000.00,0.00,0.00,75.00,5700.00,'2023-02-26 09:51:38','',''),(8262,'1','306','1',1,'Retail Sale Id 8463',1520.00,0.00,0.00,2.00,232.00,'2023-02-26 10:22:47','',''),(8263,'1','306','1',1,'Retail Sale Id 8464',108000.00,0.00,0.00,150.00,11400.00,'2023-02-26 10:45:43','',''),(8264,'1','306','1',1,'Retail Sale Id 8465',7600.00,0.00,0.00,10.00,1160.00,'2023-02-26 11:09:10','',''),(8265,'1','306','1',1,'Retail Sale Id 8466',1998.80,0.00,0.00,2.63,305.08,'2023-02-26 11:12:46','',''),(8266,'1','306','1',1,'Retail Sale Id 8468',7220.00,0.00,0.00,9.50,1102.00,'2023-02-26 11:56:15','',''),(8267,'1','306','1',1,'Retail Sale Id 8469',5996.40,0.00,0.00,7.89,915.24,'2023-02-26 12:05:48','',''),(8268,'1','306','1',1,'Retail Sale Id 8470',3997.60,0.00,0.00,5.26,610.16,'2023-02-26 12:06:41','',''),(8269,'1','306','1',1,'Retail Sale Id 8471',1998.80,0.00,0.00,2.63,305.08,'2023-02-26 12:08:50','',''),(8270,'1','306','1',1,'Retail Sale Id 8472',4560.00,0.00,0.00,6.00,696.00,'2023-02-26 12:18:18','',''),(8271,'1','306','1',1,'Retail Sale Id 8472',4560.00,0.00,0.00,6.00,696.00,'2023-02-26 12:18:18','',''),(8272,'1','306','1',1,'Retail Sale Id 8473',798.00,0.00,0.00,1.05,121.80,'2023-02-26 12:19:42','',''),(8273,'1','306','1',1,'Retail Sale Id 8473',798.00,0.00,0.00,1.05,121.80,'2023-02-26 12:19:42','',''),(8274,'1','306','1',1,'Retail Sale Id 8474',3997.60,0.00,0.00,5.26,610.16,'2023-02-26 12:30:39','',''),(8275,'1','306','1',1,'Retail Sale Id 8475',1497.20,0.00,0.00,1.97,228.52,'2023-02-26 12:35:10','',''),(8276,'1','306','1',1,'Retail Sale Id 8476',1003.20,0.00,0.00,1.32,153.12,'2023-02-26 12:59:28','',''),(8277,'1','306','1',1,'Retail Sale Id 8477',9500.00,0.00,0.00,12.50,1450.00,'2023-02-26 13:06:36','',''),(8278,'1','306','1',1,'Retail Sale Id 8477',9500.00,0.00,0.00,12.50,1450.00,'2023-02-26 13:06:36','',''),(8279,'1','306','1',1,'Retail Sale Id 8478',760.00,0.00,0.00,1.00,116.00,'2023-02-26 13:19:09','',''),(8280,'1','306','1',1,'Retail Sale Id 8479',1497.20,0.00,0.00,1.97,228.52,'2023-02-26 13:28:58','',''),(8281,'1','306','1',1,'Retail Sale Id 8480',31160.00,0.00,0.00,41.00,4756.00,'2023-02-26 14:23:00','',''),(8282,'1','306','1',1,'Retail Sale Id 8481',38000.00,0.00,0.00,50.00,5800.00,'2023-02-26 15:17:26','',''),(8283,'1','306','1',1,'Retail Sale Id 8482',38000.00,0.00,0.00,50.00,5800.00,'2023-02-26 15:17:48','',''),(8284,'1','306','1',1,'Retail Sale Id 8483',38000.00,0.00,0.00,50.00,5800.00,'2023-02-26 15:18:38','',''),(8285,'1','306','1',1,'Retail Sale Id 8484',5320.00,0.00,0.00,7.00,812.00,'2023-02-26 16:11:56','',''),(8286,'1','306','1',1,'Retail Sale Id 8485',6840.00,0.00,0.00,9.00,1044.00,'2023-02-26 16:53:33','',''),(8287,'1','306','1',1,'Retail Sale Id 8486',1003.20,0.00,0.00,1.32,153.12,'2023-02-26 17:28:09','',''),(8288,'1','306','1',1,'Retail Sale Id 8487',3800.00,0.00,0.00,5.00,580.00,'2023-02-26 17:36:38','',''),(8289,'1','306','1',1,'Retail Sale Id 8488',2280.00,0.00,0.00,3.00,348.00,'2023-02-26 18:01:54','',''),(8290,'1','306','1',1,'Retail Sale Id 8489',455452.80,0.00,0.00,599.28,69516.48,'2023-02-26 18:17:41','',''),(8291,'1','306','1',1,'Retail Sale Id 8490',2280.00,0.00,0.00,3.00,348.00,'2023-02-27 07:37:26','',''),(8292,'1','306','1',1,'Retail Sale Id 8490',3040.00,0.00,0.00,4.00,464.00,'2023-02-27 07:37:26','',''),(8293,'1','306','1',1,'Retail Sale Id 8491',4560.00,0.00,0.00,6.00,696.00,'2023-02-27 07:39:05','',''),(8294,'1','306','1',1,'Retail Sale Id 8492',4560.00,0.00,0.00,6.00,696.00,'2023-02-27 07:43:30','',''),(8295,'1','306','1',1,'Retail Sale Id 8493',3800.00,0.00,0.00,5.00,580.00,'2023-02-27 07:44:48','',''),(8296,'1','306','1',1,'Retail Sale Id 8494',2280.00,0.00,0.00,3.00,348.00,'2023-02-27 07:48:41','',''),(8297,'1','306','1',1,'Retail Sale Id 8495',2280.00,0.00,0.00,3.00,348.00,'2023-02-27 07:56:21','',''),(8298,'1','306','1',1,'Retail Sale Id 8496',4560.00,0.00,0.00,6.00,696.00,'2023-02-27 08:02:34','',''),(8299,'1','306','1',1,'Retail Sale Id 8497',5320.00,0.00,0.00,7.00,812.00,'2023-02-27 08:04:37','',''),(8300,'1','306','1',1,'Retail Sale Id 8498',3800.00,0.00,0.00,5.00,580.00,'2023-02-27 08:05:53','',''),(8301,'1','306','1',1,'Retail Sale Id 8500',7600.00,0.00,0.00,10.00,1160.00,'2023-02-27 08:07:41','',''),(8302,'1','306','1',1,'Retail Sale Id 8501',9500.00,0.00,0.00,12.50,1450.00,'2023-02-27 08:09:07','',''),(8303,'1','306','1',1,'Retail Sale Id 8502',2280.00,0.00,0.00,3.00,348.00,'2023-02-27 08:10:17','',''),(8304,'1','306','1',1,'Retail Sale Id 8503',4560.00,0.00,0.00,6.00,696.00,'2023-02-27 08:11:53','',''),(8305,'1','306','1',1,'Retail Sale Id 8504',9500.00,0.00,0.00,12.50,1450.00,'2023-02-27 08:13:13','',''),(8306,'1','306','1',1,'Retail Sale Id 8505',4560.00,0.00,0.00,6.00,696.00,'2023-02-27 08:17:59','',''),(8307,'1','306','1',1,'Retail Sale Id 8506',760.00,0.00,0.00,1.00,116.00,'2023-02-27 08:19:57','',''),(8308,'1','306','1',1,'Retail Sale Id 8507',4560.00,0.00,0.00,6.00,696.00,'2023-02-27 08:21:09','',''),(8309,'1','306','1',1,'Retail Sale Id 8508',3800.00,0.00,0.00,5.00,580.00,'2023-02-27 08:22:16','',''),(8310,'1','306','1',1,'Retail Sale Id 8509',7600.00,0.00,0.00,10.00,1160.00,'2023-02-27 08:23:23','',''),(8311,'1','306','1',1,'Retail Sale Id 8510',2280.00,0.00,0.00,3.00,348.00,'2023-02-27 08:26:46','',''),(8312,'1','306','1',1,'Retail Sale Id 8510',9120.00,0.00,0.00,12.00,1392.00,'2023-02-27 08:26:46','',''),(8313,'1','306','1',1,'Retail Sale Id 8511',3040.00,0.00,0.00,4.00,464.00,'2023-02-27 08:27:27','',''),(8314,'1','306','1',1,'Retail Sale Id 8512',5320.00,0.00,0.00,7.00,812.00,'2023-02-27 08:29:04','',''),(8315,'1','306','1',1,'Retail Sale Id 8513',2280.00,0.00,0.00,3.00,348.00,'2023-02-27 08:30:46','',''),(8316,'1','306','1',1,'Retail Sale Id 8514',2280.00,0.00,0.00,3.00,348.00,'2023-02-27 08:32:11','',''),(8317,'1','306','1',1,'Retail Sale Id 8515',2280.00,0.00,0.00,3.00,348.00,'2023-02-27 08:33:30','',''),(8318,'1','306','1',1,'Retail Sale Id 8516',1520.00,0.00,0.00,2.00,232.00,'2023-02-27 08:35:23','',''),(8319,'1','306','1',1,'Retail Sale Id 8517',4560.00,0.00,0.00,6.00,696.00,'2023-02-27 08:38:15','',''),(8320,'1','306','1',1,'Retail Sale Id 8518',4560.00,0.00,0.00,6.00,696.00,'2023-02-27 08:40:23','',''),(8321,'1','306','1',1,'Retail Sale Id 8519',1520.00,0.00,0.00,2.00,232.00,'2023-02-27 08:42:20','',''),(8322,'1','306','1',1,'Retail Sale Id 8520',1998.80,0.00,0.00,2.63,305.08,'2023-02-27 08:43:29','',''),(8323,'1','306','1',1,'Retail Sale Id 8521',4560.00,0.00,0.00,6.00,696.00,'2023-02-27 08:44:41','',''),(8324,'1','306','1',1,'Retail Sale Id 8522',3002.00,0.00,0.00,3.95,458.20,'2023-02-27 08:47:49','',''),(8325,'1','306','1',1,'Retail Sale Id 8523',798.00,0.00,0.00,1.05,121.80,'2023-02-27 08:48:51','',''),(8326,'1','306','1',1,'Retail Sale Id 8524',48960.00,0.00,0.00,68.00,5168.00,'2023-02-27 08:52:03','',''),(8327,'1','306','1',1,'Retail Sale Id 8525',4560.00,0.00,0.00,6.00,696.00,'2023-02-27 08:53:41','',''),(8328,'1','306','1',1,'Retail Sale Id 8526',3800.00,0.00,0.00,5.00,580.00,'2023-02-27 08:54:48','',''),(8329,'1','306','1',1,'Retail Sale Id 8527',4560.00,0.00,0.00,6.00,696.00,'2023-02-27 08:56:27','',''),(8330,'1','306','1',1,'Retail Sale Id 8528',56880.00,0.00,0.00,79.00,6004.00,'2023-02-27 09:00:13','',''),(8331,'1','306','1',1,'Retail Sale Id 8529',3800.00,0.00,0.00,5.00,580.00,'2023-02-27 09:01:37','',''),(8332,'1','306','1',1,'Retail Sale Id 8530',1520.00,0.00,0.00,2.00,232.00,'2023-02-27 09:02:46','',''),(8333,'1','306','1',1,'Retail Sale Id 8531',28120.00,0.00,0.00,37.00,4292.00,'2023-02-27 09:06:28','',''),(8334,'1','306','1',1,'Retail Sale Id 8531',28500.00,0.00,0.00,37.50,4350.00,'2023-02-27 09:06:28','',''),(8335,'1','306','1',1,'Retail Sale Id 8532',4560.00,0.00,0.00,6.00,696.00,'2023-02-27 09:07:26','',''),(8336,'1','306','1',1,'Retail Sale Id 8533',4560.00,0.00,0.00,6.00,696.00,'2023-02-27 09:09:37','',''),(8337,'1','306','1',1,'Retail Sale Id 8534',9120.00,0.00,0.00,12.00,1392.00,'2023-02-27 09:11:12','',''),(8338,'1','306','1',1,'Retail Sale Id 8536',3800.00,0.00,0.00,5.00,580.00,'2023-02-27 09:16:17','',''),(8339,'1','306','1',1,'Retail Sale Id 8538',4560.00,0.00,0.00,6.00,696.00,'2023-02-27 09:23:18','',''),(8340,'1','306','1',1,'Retail Sale Id 8539',1520.00,0.00,0.00,2.00,232.00,'2023-02-27 09:24:48','',''),(8341,'1','306','1',1,'Retail Sale Id 8540',3800.00,0.00,0.00,5.00,580.00,'2023-02-27 09:26:06','',''),(8342,'1','306','1',1,'Retail Sale Id 8542',4560.00,0.00,0.00,6.00,696.00,'2023-02-27 09:27:53','',''),(8343,'1','306','1',1,'Retail Sale Id 8543',4560.00,0.00,0.00,6.00,696.00,'2023-02-27 09:29:32','',''),(8344,'1','306','1',1,'Retail Sale Id 8544',1497.20,0.00,0.00,1.97,228.52,'2023-02-27 09:30:51','',''),(8345,'1','306','1',1,'Retail Sale Id 8545',9500.00,0.00,0.00,12.50,1450.00,'2023-02-27 09:32:22','',''),(8346,'1','306','1',1,'Retail Sale Id 8547',3002.00,0.00,0.00,3.95,458.20,'2023-02-27 09:35:03','',''),(8347,'1','306','1',1,'Retail Sale Id 8548',1520.00,0.00,0.00,2.00,232.00,'2023-02-27 09:36:33','',''),(8348,'1','306','1',1,'Retail Sale Id 8549',1520.00,0.00,0.00,2.00,232.00,'2023-02-27 09:40:48','',''),(8349,'1','306','1',1,'Retail Sale Id 8550',4560.00,0.00,0.00,6.00,696.00,'2023-02-27 09:43:13','',''),(8350,'1','306','1',1,'Retail Sale Id 8551',6080.00,0.00,0.00,8.00,928.00,'2023-02-27 09:47:58','',''),(8351,'1','306','1',1,'Retail Sale Id 8552',4560.00,0.00,0.00,6.00,696.00,'2023-02-27 09:50:41','',''),(8352,'1','306','1',1,'Retail Sale Id 8553',4560.00,0.00,0.00,6.00,696.00,'2023-02-27 09:51:52','',''),(8353,'1','306','1',1,'Retail Sale Id 8554',2280.00,0.00,0.00,3.00,348.00,'2023-02-27 09:53:53','',''),(8354,'1','306','1',1,'Retail Sale Id 8555',3040.00,0.00,0.00,4.00,464.00,'2023-02-27 09:58:36','',''),(8355,'1','306','1',1,'Retail Sale Id 8557',1998.80,0.00,0.00,2.63,305.08,'2023-02-27 10:05:30','',''),(8356,'1','306','1',1,'Retail Sale Id 8559',1520.00,0.00,0.00,2.00,232.00,'2023-02-27 10:10:50','',''),(8357,'1','306','1',1,'Retail Sale Id 8560',5000.80,0.00,0.00,6.58,763.28,'2023-02-27 10:14:44','',''),(8358,'1','306','1',1,'Retail Sale Id 8561',4560.00,0.00,0.00,6.00,696.00,'2023-02-27 10:17:18','',''),(8359,'1','306','1',1,'Retail Sale Id 8562',9500.00,0.00,0.00,12.50,1450.00,'2023-02-27 10:19:05','',''),(8360,'1','306','1',1,'Retail Sale Id 8563',8002.80,0.00,0.00,10.53,1221.48,'2023-02-27 10:24:31','',''),(8361,'1','306','1',1,'Retail Sale Id 8564',5996.40,0.00,0.00,7.89,915.24,'2023-02-27 10:26:24','',''),(8362,'1','306','1',1,'Retail Sale Id 8565',1520.00,0.00,0.00,2.00,232.00,'2023-02-27 10:28:56','',''),(8363,'1','306','1',1,'Retail Sale Id 8567',3040.00,0.00,0.00,4.00,464.00,'2023-02-27 10:35:39','',''),(8364,'1','306','1',1,'Retail Sale Id 8569',2280.00,0.00,0.00,3.00,348.00,'2023-02-27 10:40:32','',''),(8365,'1','306','1',1,'Retail Sale Id 8569',4560.00,0.00,0.00,6.00,696.00,'2023-02-27 10:40:32','',''),(8366,'1','306','1',1,'Retail Sale Id 8570',478.80,0.00,0.00,0.63,73.08,'2023-02-27 11:57:35','',''),(8367,'1','306','1',1,'Return of Retail Sale Id 8528',0.00,56880.00,79.00,0.00,-6004.00,'2023-02-27 14:34:11','',''),(8368,'1','306','1',1,'Retail Sale Id 8571',48960.00,0.00,0.00,68.00,5168.00,'2023-02-27 14:36:35','',''),(8369,'1','306','1',1,'Retail Sale Id 8572',8360.00,0.00,0.00,11.00,1276.00,'2023-02-27 14:37:39','',''),(8370,'1','306',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,142826.32,221.78,0.00,0.00,'2023-02-27 14:40:50','',''),(8371,'1','306',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,221.78,0.00,'2023-02-27 14:41:56','',''),(8372,'1','306','1',1,'Received from bridging 18',0.00,0.00,221.78,0.00,0.00,'2023-02-27 14:41:56','',''),(8373,'1','306','1',1,'Retail Sale Id 8573',168552.80,0.00,0.00,221.78,25726.48,'2023-02-27 14:42:45','',''),(8374,'1','306',NULL,1,'Purchased from AA RANO NIGERIA LTD.',0.00,3091200.00,4800.00,0.00,0.00,'2023-02-28 07:04:58','',''),(8375,'1','306',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,4800.00,0.00,'2023-02-28 07:06:04','',''),(8376,'1','306','1',1,'Received from bridging 19',0.00,0.00,4800.00,0.00,0.00,'2023-02-28 07:06:04','',''),(8377,'1','306','1',1,'Retail Sale Id 8574',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 07:29:06','',''),(8378,'1','306','1',1,'Retail Sale Id 8575',760.00,0.00,0.00,1.00,116.00,'2023-02-28 07:38:27','',''),(8379,'1','306','1',1,'Retail Sale Id 8576',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 07:49:24','',''),(8380,'1','306','1',1,'Retail Sale Id 8577',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 07:51:40','',''),(8381,'1','306','1',1,'Retail Sale Id 8578',1520.00,0.00,0.00,2.00,232.00,'2023-02-28 07:54:45','',''),(8382,'1','306','1',1,'Retail Sale Id 8579',1702.40,0.00,0.00,2.24,259.84,'2023-02-28 07:59:01','',''),(8383,'1','306','1',1,'Retail Sale Id 8580',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 08:01:13','',''),(8384,'1','306','1',1,'Retail Sale Id 8581',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 08:01:58','',''),(8385,'1','306','1',1,'Retail Sale Id 8582',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 08:05:35','',''),(8386,'1','306','1',1,'Retail Sale Id 8583',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 08:10:40','',''),(8387,'1','306','1',1,'Retail Sale Id 8584',7600.00,0.00,0.00,10.00,1160.00,'2023-02-28 08:14:33','',''),(8388,'1','306','1',1,'Retail Sale Id 8585',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 08:15:53','',''),(8389,'1','306','1',1,'Retail Sale Id 8586',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 08:17:18','',''),(8390,'1','306','1',1,'Retail Sale Id 8587',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 08:18:43','',''),(8391,'1','306','1',1,'Retail Sale Id 8589',9120.00,0.00,0.00,12.00,1392.00,'2023-02-28 08:20:51','',''),(8392,'1','306','1',1,'Retail Sale Id 8590',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 08:22:02','',''),(8393,'1','306','1',1,'Retail Sale Id 8591',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 08:23:05','',''),(8394,'1','306','1',1,'Retail Sale Id 8592',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 08:24:40','',''),(8395,'1','306','1',1,'Retail Sale Id 8593',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 08:26:59','',''),(8396,'1','306','1',1,'Retail Sale Id 8594',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 08:28:05','',''),(8397,'1','306','1',1,'Retail Sale Id 8595',1520.00,0.00,0.00,2.00,232.00,'2023-02-28 08:30:00','',''),(8398,'1','306','1',1,'Retail Sale Id 8596',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 08:31:47','',''),(8399,'1','306','1',1,'Retail Sale Id 8597',3997.60,0.00,0.00,5.26,610.16,'2023-02-28 08:33:38','',''),(8400,'1','306','1',1,'Retail Sale Id 8598',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 08:34:48','',''),(8401,'1','306','1',1,'Retail Sale Id 8599',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 08:36:15','',''),(8402,'1','306','1',1,'Retail Sale Id 8600',3002.00,0.00,0.00,3.95,458.20,'2023-02-28 08:37:38','',''),(8403,'1','306','1',1,'Retail Sale Id 8602',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 08:41:04','',''),(8404,'1','306','1',1,'Retail Sale Id 8602',7600.00,0.00,0.00,10.00,1160.00,'2023-02-28 08:41:04','',''),(8405,'1','306','1',1,'Retail Sale Id 8603',7600.00,0.00,0.00,10.00,1160.00,'2023-02-28 08:43:29','',''),(8406,'1','306','1',1,'Retail Sale Id 8604',760.00,0.00,0.00,1.00,116.00,'2023-02-28 08:45:13','',''),(8407,'1','306','1',1,'Retail Sale Id 8605',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 08:46:29','',''),(8408,'1','306','1',1,'Retail Sale Id 8606',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 08:49:22','',''),(8409,'1','306','1',1,'Retail Sale Id 8607',2401.60,0.00,0.00,3.16,366.56,'2023-02-28 08:50:39','',''),(8410,'1','306','1',1,'Retail Sale Id 8608',1520.00,0.00,0.00,2.00,232.00,'2023-02-28 08:52:02','',''),(8411,'1','306','1',1,'Retail Sale Id 8609',1520.00,0.00,0.00,2.00,232.00,'2023-02-28 08:53:45','',''),(8412,'1','306','1',1,'Retail Sale Id 8610',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 08:54:56','',''),(8413,'1','306','1',1,'Retail Sale Id 8611',1520.00,0.00,0.00,2.00,232.00,'2023-02-28 08:56:30','',''),(8414,'1','306','1',1,'Retail Sale Id 8612',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 08:58:39','',''),(8415,'1','306','1',1,'Retail Sale Id 8613',2401.60,0.00,0.00,3.16,366.56,'2023-02-28 08:59:55','',''),(8416,'1','306','1',1,'Retail Sale Id 8614',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 09:01:04','',''),(8417,'1','306','1',1,'Retail Sale Id 8615',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 09:03:31','',''),(8418,'1','306','1',1,'Retail Sale Id 8616',7600.00,0.00,0.00,10.00,1160.00,'2023-02-28 09:04:42','',''),(8419,'1','306','1',1,'Retail Sale Id 8617',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 09:07:01','',''),(8420,'1','306','1',1,'Retail Sale Id 8618',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 09:08:43','',''),(8421,'1','306','1',1,'Retail Sale Id 8619',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 09:11:12','',''),(8422,'1','306','1',1,'Retail Sale Id 8620',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 09:12:25','',''),(8423,'1','306','1',1,'Retail Sale Id 8621',2302.80,0.00,0.00,3.03,351.48,'2023-02-28 09:14:01','',''),(8424,'1','306','1',1,'Retail Sale Id 8622',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 09:15:32','',''),(8425,'1','306','1',1,'Retail Sale Id 8622',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 09:15:32','',''),(8426,'1','306','1',1,'Retail Sale Id 8624',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 09:20:21','',''),(8427,'1','306','1',1,'Retail Sale Id 8625',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 09:22:31','',''),(8428,'1','306','1',1,'Retail Sale Id 8626',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 09:23:46','',''),(8429,'1','306','1',1,'Retail Sale Id 8627',5320.00,0.00,0.00,7.00,812.00,'2023-02-28 09:27:09','',''),(8430,'1','306','1',1,'Retail Sale Id 8628',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 09:29:38','',''),(8431,'1','306','1',1,'Retail Sale Id 8629',4598.00,0.00,0.00,6.05,701.80,'2023-02-28 09:35:52','',''),(8432,'1','306','1',1,'Retail Sale Id 8631',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 09:38:24','',''),(8433,'1','306','1',1,'Retail Sale Id 8632',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 09:40:29','',''),(8434,'1','306','1',1,'Retail Sale Id 8633',1520.00,0.00,0.00,2.00,232.00,'2023-02-28 09:41:27','',''),(8435,'1','306','1',1,'Retail Sale Id 8634',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 09:43:21','',''),(8436,'1','306','1',1,'Retail Sale Id 8635',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 09:44:25','',''),(8437,'1','306','1',1,'Retail Sale Id 8636',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 09:45:59','',''),(8438,'1','306','1',1,'Retail Sale Id 8637',7600.00,0.00,0.00,10.00,1160.00,'2023-02-28 09:47:06','',''),(8439,'1','306','1',1,'Retail Sale Id 8638',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 09:48:29','',''),(8440,'1','306','1',1,'Retail Sale Id 8639',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 09:49:15','',''),(8441,'1','306','1',1,'Retail Sale Id 8640',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 09:53:22','',''),(8442,'1','306','1',1,'Retail Sale Id 8641',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 09:55:33','',''),(8443,'1','306','1',1,'Retail Sale Id 8642',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 09:57:17','',''),(8444,'1','306','1',1,'Retail Sale Id 8643',1520.00,0.00,0.00,2.00,232.00,'2023-02-28 09:58:47','',''),(8445,'1','306','1',1,'Retail Sale Id 8644',7600.00,0.00,0.00,10.00,1160.00,'2023-02-28 09:59:58','',''),(8446,'1','306','1',1,'Retail Sale Id 8645',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 10:01:06','',''),(8447,'1','306','1',1,'Retail Sale Id 8646',7600.00,0.00,0.00,10.00,1160.00,'2023-02-28 10:03:42','',''),(8448,'1','306','1',1,'Retail Sale Id 8647',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 10:04:52','',''),(8449,'1','306','1',1,'Retail Sale Id 8648',6080.00,0.00,0.00,8.00,928.00,'2023-02-28 10:06:40','',''),(8450,'1','306','1',1,'Retail Sale Id 8649',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 10:09:15','',''),(8451,'1','306','1',1,'Retail Sale Id 8650',1520.00,0.00,0.00,2.00,232.00,'2023-02-28 10:14:02','',''),(8452,'1','306','1',1,'Retail Sale Id 8652',32400.00,0.00,0.00,45.00,3420.00,'2023-02-28 10:18:05','',''),(8453,'1','306','1',1,'Retail Sale Id 8653',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 10:19:51','',''),(8454,'1','306','1',1,'Retail Sale Id 8654',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 10:21:27','',''),(8455,'1','306','1',1,'Retail Sale Id 8657',7600.00,0.00,0.00,10.00,1160.00,'2023-02-28 10:25:06','',''),(8456,'1','306','1',1,'Retail Sale Id 8658',6999.60,0.00,0.00,9.21,1068.36,'2023-02-28 10:27:21','',''),(8457,'1','306','1',1,'Retail Sale Id 8659',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 10:28:28','',''),(8458,'1','306','1',1,'Retail Sale Id 8660',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 10:30:27','',''),(8459,'1','306','1',1,'Retail Sale Id 8661',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 10:33:02','',''),(8460,'1','306','1',1,'Retail Sale Id 8662',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 10:35:23','',''),(8461,'1','306','1',1,'Retail Sale Id 8663',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 10:36:26','',''),(8462,'1','306','1',1,'Retail Sale Id 8664',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 10:38:09','',''),(8463,'1','306','1',1,'Retail Sale Id 8665',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 10:40:35','',''),(8464,'1','306','1',1,'Retail Sale Id 8667',2302.80,0.00,0.00,3.03,351.48,'2023-02-28 10:43:33','',''),(8465,'1','306','1',1,'Retail Sale Id 8668',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 10:48:41','',''),(8466,'1','306','1',1,'Retail Sale Id 8669',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 10:50:36','',''),(8467,'1','306','1',1,'Retail Sale Id 8670',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 10:52:03','',''),(8468,'1','306','1',1,'Retail Sale Id 8671',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 10:53:39','',''),(8469,'1','306','1',1,'Retail Sale Id 8672',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 10:55:39','',''),(8470,'1','306','1',1,'Retail Sale Id 8673',1520.00,0.00,0.00,2.00,232.00,'2023-02-28 10:59:33','',''),(8471,'1','306','1',1,'Retail Sale Id 8673',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 10:59:33','',''),(8472,'1','306','1',1,'Retail Sale Id 8674',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 11:04:04','',''),(8473,'1','306','1',1,'Retail Sale Id 8675',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 11:06:37','',''),(8474,'1','306','1',1,'Retail Sale Id 8676',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 11:09:14','',''),(8475,'1','306','1',1,'Retail Sale Id 8677',1520.00,0.00,0.00,2.00,232.00,'2023-02-28 11:11:52','',''),(8476,'1','306','1',1,'Retail Sale Id 8678',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 11:14:07','',''),(8477,'1','306','1',1,'Retail Sale Id 8680',1497.20,0.00,0.00,1.97,228.52,'2023-02-28 11:16:49','',''),(8478,'1','306','1',1,'Retail Sale Id 8681',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 11:18:56','',''),(8479,'1','306','1',1,'Retail Sale Id 8683',30960.00,0.00,0.00,43.00,3268.00,'2023-02-28 11:23:16','',''),(8480,'1','306','1',1,'Retail Sale Id 8684',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 11:29:10','',''),(8481,'1','306','1',1,'Retail Sale Id 8685',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 11:30:40','',''),(8482,'1','306','1',1,'Retail Sale Id 8686',3002.00,0.00,0.00,3.95,458.20,'2023-02-28 11:34:24','',''),(8483,'1','306','1',1,'Retail Sale Id 8687',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 11:37:52','',''),(8484,'1','306','1',1,'Retail Sale Id 8688',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 11:44:06','',''),(8485,'1','306','1',1,'Retail Sale Id 8689',1497.20,0.00,0.00,1.97,228.52,'2023-02-28 11:49:52','',''),(8486,'1','306','1',1,'Retail Sale Id 8690',1497.20,0.00,0.00,1.97,228.52,'2023-02-28 11:50:41','',''),(8487,'1','306','1',1,'Retail Sale Id 8691',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 11:51:30','',''),(8488,'1','306','1',1,'Return of Retail Sale Id 8689',0.00,1497.20,1.97,0.00,-228.52,'2023-02-28 11:52:33','',''),(8489,'1','306','1',1,'Retail Sale Id 8692',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 11:53:10','',''),(8490,'1','306','1',1,'Retail Sale Id 8693',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 11:55:28','',''),(8491,'1','306','1',1,'Retail Sale Id 8694',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 11:56:51','',''),(8492,'1','306','1',1,'Retail Sale Id 8695',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 11:59:30','',''),(8493,'1','306','1',1,'Retail Sale Id 8696',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 12:01:18','',''),(8494,'1','306','1',1,'Retail Sale Id 8697',6080.00,0.00,0.00,8.00,928.00,'2023-02-28 12:03:23','',''),(8495,'1','306','1',1,'Retail Sale Id 8698',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 12:05:25','',''),(8496,'1','306','1',1,'Retail Sale Id 8700',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 12:08:49','',''),(8497,'1','306','1',1,'Retail Sale Id 8701',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 12:13:54','',''),(8498,'1','306','1',1,'Retail Sale Id 8701',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 12:13:54','',''),(8499,'1','306','1',1,'Retail Sale Id 8702',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 12:15:37','',''),(8500,'1','306','1',1,'Retail Sale Id 8703',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 12:17:44','',''),(8501,'1','306','1',1,'Retail Sale Id 8704',59040.00,0.00,0.00,82.00,6232.00,'2023-02-28 12:18:55','',''),(8502,'1','306','1',1,'Retail Sale Id 8705',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 12:20:07','',''),(8503,'1','306','1',1,'Retail Sale Id 8706',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 12:20:56','',''),(8504,'1','306','1',1,'Retail Sale Id 8707',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 12:22:26','',''),(8505,'1','306','1',1,'Retail Sale Id 8708',34200.00,0.00,0.00,45.00,5220.00,'2023-02-28 12:24:23','',''),(8506,'1','306','1',1,'Retail Sale Id 8709',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 12:27:28','',''),(8507,'1','306','1',1,'Retail Sale Id 8710',7600.00,0.00,0.00,10.00,1160.00,'2023-02-28 12:28:29','',''),(8508,'1','306','1',1,'Retail Sale Id 8711',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 12:30:54','',''),(8509,'1','306','1',1,'Retail Sale Id 8714',1003.20,0.00,0.00,1.32,153.12,'2023-02-28 12:38:37','',''),(8510,'1','306','1',1,'Retail Sale Id 8715',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 12:41:30','',''),(8511,'1','306','1',1,'Retail Sale Id 8716',7600.00,0.00,0.00,10.00,1160.00,'2023-02-28 12:42:52','',''),(8512,'1','306','1',1,'Retail Sale Id 8717',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 12:44:55','',''),(8513,'1','306','1',1,'Retail Sale Id 8718',1900.00,0.00,0.00,2.50,290.00,'2023-02-28 12:46:34','',''),(8514,'1','306','1',1,'Retail Sale Id 8719',1003.20,0.00,0.00,1.32,153.12,'2023-02-28 12:47:45','',''),(8515,'1','306','1',1,'Retail Sale Id 8720',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 12:50:09','',''),(8516,'1','306','1',1,'Retail Sale Id 8721',15200.00,0.00,0.00,20.00,2320.00,'2023-02-28 12:51:23','',''),(8517,'1','306','1',1,'Retail Sale Id 8722',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 12:54:54','',''),(8518,'1','306','1',1,'Retail Sale Id 8723',92880.00,0.00,0.00,129.00,9804.00,'2023-02-28 12:55:55','',''),(8519,'1','306','1',1,'Retail Sale Id 8724',1520.00,0.00,0.00,2.00,232.00,'2023-02-28 12:58:33','',''),(8520,'1','306','1',1,'Retail Sale Id 8725',760.00,0.00,0.00,1.00,116.00,'2023-02-28 12:59:33','',''),(8521,'1','306','1',1,'Retail Sale Id 8726',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 13:04:06','',''),(8522,'1','306','1',1,'Retail Sale Id 8727',9120.00,0.00,0.00,12.00,1392.00,'2023-02-28 13:07:17','',''),(8523,'1','306','1',1,'Retail Sale Id 8728',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 13:09:28','',''),(8524,'1','306','1',1,'Retail Sale Id 8730',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 13:15:02','',''),(8525,'1','306','1',1,'Retail Sale Id 8731',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 13:16:07','',''),(8526,'1','306','1',1,'Retail Sale Id 8732',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 13:17:34','',''),(8527,'1','306','1',1,'Retail Sale Id 8733',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 13:20:26','',''),(8528,'1','306','1',1,'Retail Sale Id 8735',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 13:30:49','',''),(8529,'1','306','1',1,'Retail Sale Id 8736',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 13:32:04','',''),(8530,'1','306','1',1,'Retail Sale Id 8737',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 13:34:20','',''),(8531,'1','306','1',1,'Retail Sale Id 8738',7600.00,0.00,0.00,10.00,1160.00,'2023-02-28 13:35:31','',''),(8532,'1','306','1',1,'Retail Sale Id 8739',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 13:37:17','',''),(8533,'1','306','1',1,'Retail Sale Id 8740',896.80,0.00,0.00,1.18,136.88,'2023-02-28 13:38:32','',''),(8534,'1','306','1',1,'Retail Sale Id 8741',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 13:39:52','',''),(8535,'1','306','1',1,'Retail Sale Id 8743',1003.20,0.00,0.00,1.32,153.12,'2023-02-28 13:42:10','',''),(8536,'1','306','1',1,'Retail Sale Id 8744',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 13:45:20','',''),(8537,'1','306','1',1,'Retail Sale Id 8745',3002.00,0.00,0.00,3.95,458.20,'2023-02-28 13:49:18','',''),(8538,'1','306','1',1,'Retail Sale Id 8747',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 13:52:53','',''),(8539,'1','306','1',1,'Retail Sale Id 8748',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 14:01:20','',''),(8540,'1','306','1',1,'Retail Sale Id 8749',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 14:04:09','',''),(8541,'1','306','1',1,'Retail Sale Id 8750',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 14:05:44','',''),(8542,'1','306','1',1,'Retail Sale Id 8751',760.00,0.00,0.00,1.00,116.00,'2023-02-28 14:07:47','',''),(8543,'1','306','1',1,'Retail Sale Id 8751',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 14:07:47','',''),(8544,'1','306','1',1,'Retail Sale Id 8752',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 14:12:21','',''),(8545,'1','306','1',1,'Retail Sale Id 8753',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 14:13:25','',''),(8546,'1','306','1',1,'Retail Sale Id 8754',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 14:28:47','',''),(8547,'1','306','1',1,'Retail Sale Id 8754',5320.00,0.00,0.00,7.00,812.00,'2023-02-28 14:28:47','',''),(8548,'1','306','1',1,'Retail Sale Id 8755',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 14:31:24','',''),(8549,'1','306','1',1,'Retail Sale Id 8756',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 14:33:22','',''),(8550,'1','306','1',1,'Retail Sale Id 8757',18000.00,0.00,0.00,25.00,1900.00,'2023-02-28 14:37:53','',''),(8551,'1','306','1',1,'Retail Sale Id 8758',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 14:39:38','',''),(8552,'1','306','1',1,'Retail Sale Id 8759',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 14:40:46','',''),(8553,'1','306','1',1,'Retail Sale Id 8760',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 14:42:08','',''),(8554,'1','306','1',1,'Retail Sale Id 8761',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 14:44:15','',''),(8555,'1','306','1',1,'Retail Sale Id 8763',1520.00,0.00,0.00,2.00,232.00,'2023-02-28 14:55:16','',''),(8556,'1','306','1',1,'Retail Sale Id 8763',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 14:55:16','',''),(8557,'1','306','1',1,'Retail Sale Id 8764',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 14:56:49','',''),(8558,'1','306','1',1,'Retail Sale Id 8765',6102.80,0.00,0.00,8.03,931.48,'2023-02-28 15:04:27','',''),(8559,'1','306','1',1,'Retail Sale Id 8766',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 15:09:47','',''),(8560,'1','306','1',1,'Retail Sale Id 8768',29997.20,0.00,0.00,39.47,4578.52,'2023-02-28 15:12:55','',''),(8561,'1','306','1',1,'Retail Sale Id 8769',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 15:14:08','',''),(8562,'1','306','1',1,'Retail Sale Id 8770',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 15:16:00','',''),(8563,'1','306','1',1,'Retail Sale Id 8771',72000.00,0.00,0.00,100.00,7600.00,'2023-02-28 15:18:09','',''),(8564,'1','306','1',1,'Retail Sale Id 8772',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 15:20:54','',''),(8565,'1','306','1',1,'Retail Sale Id 8773',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 15:24:44','',''),(8566,'1','306','1',1,'Retail Sale Id 8774',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 15:27:28','',''),(8567,'1','306','1',1,'Retail Sale Id 8775',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 15:30:39','',''),(8568,'1','306','1',1,'Retail Sale Id 8776',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 15:32:31','',''),(8569,'1','306','1',1,'Retail Sale Id 8777',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 15:39:22','',''),(8570,'1','306','1',1,'Retail Sale Id 8779',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 15:50:14','',''),(8571,'1','306','1',1,'Retail Sale Id 8779',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 15:50:14','',''),(8572,'1','306','1',1,'Retail Sale Id 8780',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 15:52:47','',''),(8573,'1','306','1',1,'Retail Sale Id 8781',760.00,0.00,0.00,1.00,116.00,'2023-02-28 15:55:33','',''),(8574,'1','306','1',1,'Retail Sale Id 8782',2401.60,0.00,0.00,3.16,366.56,'2023-02-28 16:01:46','',''),(8575,'1','306','1',1,'Retail Sale Id 8783',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 16:15:46','',''),(8576,'1','306','1',1,'Retail Sale Id 8784',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 16:17:38','',''),(8577,'1','306','1',1,'Retail Sale Id 8785',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 16:19:21','',''),(8578,'1','306','1',1,'Retail Sale Id 8786',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 16:22:28','',''),(8579,'1','306','1',1,'Retail Sale Id 8787',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 16:23:39','',''),(8580,'1','306','1',1,'Retail Sale Id 8788',6080.00,0.00,0.00,8.00,928.00,'2023-02-28 16:28:11','',''),(8581,'1','306','1',1,'Retail Sale Id 8789',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 16:29:59','',''),(8582,'1','306','1',1,'Retail Sale Id 8790',9120.00,0.00,0.00,12.00,1392.00,'2023-02-28 16:38:31','',''),(8583,'1','306','1',1,'Retail Sale Id 8791',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 16:39:42','',''),(8584,'1','306','1',1,'Retail Sale Id 8792',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 16:46:08','',''),(8585,'1','306','1',1,'Retail Sale Id 8792',7600.00,0.00,0.00,10.00,1160.00,'2023-02-28 16:46:08','',''),(8586,'1','306','1',1,'Retail Sale Id 8793',9120.00,0.00,0.00,12.00,1392.00,'2023-02-28 16:49:08','',''),(8587,'1','306','1',1,'Retail Sale Id 8794',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 16:53:51','',''),(8588,'1','306','1',1,'Retail Sale Id 8795',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 16:55:25','',''),(8589,'1','306','1',1,'Retail Sale Id 8796',1520.00,0.00,0.00,2.00,232.00,'2023-02-28 16:57:56','',''),(8590,'1','306','1',1,'Retail Sale Id 8797',3002.00,0.00,0.00,3.95,458.20,'2023-02-28 16:59:14','',''),(8591,'1','306','1',1,'Retail Sale Id 8798',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 17:01:09','',''),(8592,'1','306','1',1,'Retail Sale Id 8799',1520.00,0.00,0.00,2.00,232.00,'2023-02-28 17:03:48','',''),(8593,'1','306','1',1,'Retail Sale Id 8800',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 17:09:37','',''),(8594,'1','306','1',1,'Retail Sale Id 8801',30960.00,0.00,0.00,43.00,3268.00,'2023-02-28 17:15:27','',''),(8595,'1','306','1',1,'Retail Sale Id 8802',7600.00,0.00,0.00,10.00,1160.00,'2023-02-28 17:17:58','',''),(8596,'1','306','1',1,'Retail Sale Id 8803',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 17:23:02','',''),(8597,'1','306','1',1,'Retail Sale Id 8804',9120.00,0.00,0.00,12.00,1392.00,'2023-02-28 17:24:14','',''),(8598,'1','306','1',1,'Retail Sale Id 8805',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 17:29:10','',''),(8599,'1','306','1',1,'Retail Sale Id 8806',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 17:30:23','',''),(8600,'1','306','1',1,'Retail Sale Id 8807',3002.00,0.00,0.00,3.95,458.20,'2023-02-28 17:31:28','',''),(8601,'1','306','1',1,'Return of Retail Sale Id 8805',0.00,2280.00,3.00,0.00,-348.00,'2023-02-28 17:32:21','',''),(8602,'1','306','1',1,'Retail Sale Id 8809',798.00,0.00,0.00,1.05,121.80,'2023-02-28 17:35:06','',''),(8603,'1','306','1',1,'Retail Sale Id 8810',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 17:36:50','',''),(8604,'1','306','1',1,'Retail Sale Id 8811',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 17:40:58','',''),(8605,'1','306','1',1,'Retail Sale Id 8812',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 17:42:02','',''),(8606,'1','306','1',1,'Retail Sale Id 8814',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 17:49:53','',''),(8607,'1','306','1',1,'Retail Sale Id 8815',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 17:55:59','',''),(8608,'1','306','1',1,'Retail Sale Id 8816',9500.00,0.00,0.00,12.50,1450.00,'2023-02-28 17:57:55','',''),(8609,'1','306','1',1,'Retail Sale Id 8817',1520.00,0.00,0.00,2.00,232.00,'2023-02-28 18:02:06','',''),(8610,'1','306','1',1,'Retail Sale Id 8818',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 18:06:50','',''),(8611,'1','306','1',1,'Retail Sale Id 8819',1003.20,0.00,0.00,1.32,153.12,'2023-02-28 18:07:40','',''),(8612,'1','306','1',1,'Retail Sale Id 8820',1520.00,0.00,0.00,2.00,232.00,'2023-02-28 18:09:24','',''),(8613,'1','306','1',1,'Retail Sale Id 8821',2302.80,0.00,0.00,3.03,351.48,'2023-02-28 18:10:23','',''),(8614,'1','306','1',1,'Retail Sale Id 8822',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 18:11:56','',''),(8615,'1','306','1',1,'Retail Sale Id 8823',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 18:14:46','',''),(8616,'1','306','1',1,'Retail Sale Id 8824',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 18:16:27','',''),(8617,'1','306','1',1,'Retail Sale Id 8825',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 18:18:16','',''),(8618,'1','306','1',1,'Retail Sale Id 8826',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 18:19:26','',''),(8619,'1','306','1',1,'Retail Sale Id 8827',4499.20,0.00,0.00,5.92,686.72,'2023-02-28 18:22:20','',''),(8620,'1','306','1',1,'Retail Sale Id 8828',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 18:23:04','',''),(8621,'1','306','1',1,'Retail Sale Id 8829',1520.00,0.00,0.00,2.00,232.00,'2023-02-28 18:24:34','',''),(8622,'1','306','1',1,'Retail Sale Id 8830',7600.00,0.00,0.00,10.00,1160.00,'2023-02-28 18:25:24','',''),(8623,'1','306','1',1,'Retail Sale Id 8831',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 18:27:09','',''),(8624,'1','306','1',1,'Retail Sale Id 8833',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 18:29:10','',''),(8625,'1','306','1',1,'Retail Sale Id 8835',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 18:32:01','',''),(8626,'1','306','1',1,'Retail Sale Id 8836',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 18:33:28','',''),(8627,'1','306','1',1,'Retail Sale Id 8837',3040.00,0.00,0.00,4.00,464.00,'2023-02-28 18:36:14','',''),(8628,'1','306','1',1,'Retail Sale Id 8838',3800.00,0.00,0.00,5.00,580.00,'2023-02-28 18:37:43','',''),(8629,'1','306','1',1,'Retail Sale Id 8839',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 18:40:35','',''),(8630,'1','306','1',1,'Retail Sale Id 8840',4560.00,0.00,0.00,6.00,696.00,'2023-02-28 18:44:14','',''),(8631,'1','306','1',1,'Retail Sale Id 8841',2280.00,0.00,0.00,3.00,348.00,'2023-02-28 18:45:37','',''),(8632,'1','306','1',1,'Retail Sale Id 8842',1520.00,0.00,0.00,2.00,232.00,'2023-02-28 18:47:07','',''),(8633,'1','306','1',1,'Retail Sale Id 8843',9500.00,0.00,0.00,1