-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_303
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_303`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_303` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_303`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,4000,'',0,'22','1','303','PURCHASES','','2022-11-28 13:54:13',5,0.00,0.00,'','479','2022-11-28 13:54:13','479',0,0),(2,7000,'',0,'20','1','303','SALES','','2022-11-28 13:54:28',5,0.00,0.00,'','479','2022-11-28 13:54:28','479',0,0),(3,500,'',0,'6.1','1','303','CASH','','2022-11-28 13:54:41',5,0.00,0.00,'','479','2022-11-28 13:54:41','479',0,0),(4,8000,'',0,'24','1','303','SALARIES & WAGES','','2022-11-28 13:55:01',5,0.00,0.00,'','479','2022-11-28 13:55:01','479',0,0),(5,8001,'',0,'24','1','303','PURCHASES','','2022-11-28 13:55:23',5,0.00,0.00,'','479','2022-11-28 13:55:23','479',0,0),(6,2500,'',0,'2','1','303','ZB(LPG)1014471475','','2022-11-28 13:55:36',5,0.00,0.00,'','479','2022-11-28 13:55:36','479',0,0),(7,2501,'',0,'2','1','303','ZNB E-BILL COLLECTION :1014717','','2022-11-28 13:55:50',5,0.00,0.00,'','479','2022-11-28 13:55:50','479',0,0),(8,2502,'',0,'2','1','303','ZNB-:POS 1015965368','','2022-11-28 13:57:25',5,0.00,0.00,'','479','2022-11-28 13:57:25','479',0,0),(9,2503,'',0,'2','1','303','FID POS COLLECTION-5620141491','','2022-11-28 13:57:51',5,0.00,0.00,'','479','2022-11-28 13:57:51','479',0,0),(10,2504,'',0,'2','1','303','FB(IBAL)2023855223','','2022-11-28 13:58:01',5,0.00,0.00,'','479','2022-11-28 13:58:01','479',0,0),(11,2505,'',0,'2','1','303','E-BILLS 1015372548','','2022-11-28 13:58:18',5,0.00,0.00,'','479','2022-11-28 13:58:18','479',0,0),(12,2506,'',0,'2','1','303','E-BILLS  IBAL 1015372548','','2022-11-28 13:58:28',5,0.00,0.00,'','479','2022-11-28 13:58:28','479',0,0),(13,2507,'',0,'2','1','303','UNITY BANK-0024061656','','2022-11-28 13:58:50',5,0.00,0.00,'','479','2022-11-28 13:58:50','479',0,0),(14,2508,'',0,'2','1','303','UBA-0039769388','','2022-11-28 13:58:59',5,0.00,0.00,'','479','2022-11-28 13:58:59','479',0,0),(15,2509,'',0,'2','1','303','UBA YOLA-1021398099','','2022-11-28 13:59:12',5,0.00,0.00,'','479','2022-11-28 13:59:12','479',0,0),(16,2510,'',0,'2','1','303','UBA-1019882661','','2022-11-28 13:59:20',5,0.00,0.00,'','479','2022-11-28 13:59:20','479',0,0),(17,2511,'',0,'2','1','303','DANKANO-EBILLS:ZNB1014717618','','2022-11-28 13:59:31',5,0.00,0.00,'','479','2022-11-28 13:59:31','479',0,0),(18,2512,'',0,'2','1','303','TAJJ BANK CITY GATE:0001875361','','2022-11-28 13:59:49',5,0.00,0.00,'','479','2022-11-28 13:59:49','479',0,0),(19,2513,'',0,'2','1','303','POLARIS BANK KEBBI:4091417377','','2022-11-28 14:00:32',5,0.00,0.00,'','479','2022-11-28 14:00:32','479',0,0),(20,2514,'',0,'2','1','303','ZNB POS COLL ACCT:-1015965368','POS COLLECTION ACCOUNT','2023-01-19 17:29:53',5,0.00,0.00,'','792','2023-01-19 17:29:53','792',0,0),(21,2515,'',0,'2','1','303','UBA LPG COLL ACCT:-1020811140','LPG COLLECTION ACCOUNT','2023-01-19 17:30:56',5,0.00,0.00,'','792','2023-01-19 17:30:56','792',0,0),(22,2516,'',0,'2','1','303','ZNB AA RANO NIG LTD:-101471761','ZNB AA RANO NIG LTD','2023-01-19 17:32:14',5,0.00,0.00,'','792','2023-01-19 17:32:14','792',0,0),(23,2517,'',0,'2','1','303','FID POS COLL ACCT:-5620141491','FID POS COLLECTION ACCOUNT','2023-01-19 17:33:16',5,0.00,0.00,'','792','2023-01-19 17:33:16','792',0,0),(24,2518,'',0,'2','1','303','ZNB HADEJIA:-1227960119','ZNB HADEJIA','2023-02-13 15:01:52',5,0.00,0.00,'','792','2023-02-13 15:01:52','792',0,0),(25,2519,'',0,'2','1','303','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 15:35:36',5,0.00,0.00,'','792','2023-02-20 15:35:36','792',0,0),(26,2520,'',0,'2','1','303','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:56:07',5,0.00,0.00,'2023-03-15','792','2023-03-17 14:15:02','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','303','WIDI GAS','WIDI','08033011796','lordkercy@gmail.com','JIGAWA','JIGAWA','YANLEMAN ','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-15 09:39:41',5,'1020','2023-01-15 09:39:41','1020'),(2,'','1','303','RDT STORE','Muhammad Musa','08062643238','lordkercy@gmail.com','HADEJIA','JIGAWA','No; 62B MATA ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-18 16:08:10',5,'1020','2023-01-18 16:08:10','1020'),(3,'','1','303','SAHAM GAS','MUHAMMAD SANI','08133509424','lordkercy@gmail.com','HADEJIA','JIGAWA','COURT ROAD OPPOSITE CAR WASH','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-25 10:29:29',5,'1020','2023-01-25 10:29:29','1020'),(4,'','1','303','NAGARTA GAS','PASTOR JOHN BABA','08113891820','lordkercy@gmail.com','KAFIN HAUSA','JIGAWA','KAFIN HAUSA BEHIND UNITY BANK','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-28 12:46:59',5,'1020','2023-01-28 12:46:59','1020'),(5,'','1','303','AIS GAS','AMINU IBRAHIM SULEMAN','08034267044','aminualhajiibrahim34@gmail.com','HADEJIA','JIGAWA','No1 maje road','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-30 15:08:57',5,'1020','2023-01-30 15:08:57','1020'),(6,'','1','303','VICTORIOUS GAS','VITORIA ONUZE','07043287711','victoriachinazo2019@gmail.com','GUMEL','JIGAWA','GUMEL','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-30 18:00:46',5,'1020','2023-01-30 18:00:46','1020'),(7,'','1','303','MD GAS','MUHAMMAD DAUDA','08038340674','mda04750@gmail.com','HADEJIA','JIGAWA','opposite police station mallamudori road','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-31 08:49:50',5,'1020','2023-01-31 08:49:50','1020'),(8,'','1','303','SAHAM2 GAS','BELLO USMAN','09137441112','bellousman4h@gmail','HADEJIA','JIGAWA','GAUNA QUARTERS','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-31 10:05:26',5,'1020','2023-01-31 10:05:26','1020'),(9,'','1','303','M Y GAS','SANI MUAZU YAKUBU','07037095121','sanimuazugbs@gmail.com','HADEJIA','JIGAWA','GARIN GABARS','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-31 14:19:31',5,'1020','2023-02-01 12:04:50','1020'),(10,'','1','303','RUWAN ZUMA GAS','ABDULLAHI MUHAMMAD','09022626299','lordkercy@gmail.com','KAFIN HAUSA','JIGAWA','KAFIN HAUSA, KANDAHAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-01 09:31:48',5,'1020','2023-02-01 09:31:48','1020'),(11,'','1','303','DADIN KOWA','AHMAD YUSUF','07047272545','lordkercy@gmail.com','HADEJIA','JIGAWA','KANO ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-02 13:53:44',5,'1020','2023-02-02 13:53:44','1020'),(12,'','1','303','MATA\'UL YAHAT ','AHMAD YAN LEMAN ','08033673819','aabaros3367@gmail.com ','HADEJIA','JIGAWA','YAN LEMAN ','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-03 10:42:49',5,'1020','2023-02-03 10:42:49','1020'),(13,'','1','303','GODIYA GAS','MUSA ISA','07065685204','hassanu11id1030@gmail.com','JIGAWA','JIGAWA','HADEJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-06 08:59:48',5,'1020','2023-02-06 08:59:48','1020'),(14,'','1','303','SAUKI GAS ','RABI\'U ISA ','08167769332','rabiuisa3003@gmail.com','HADEJIA','JIGAWA','HADEJA ILALLA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-06 13:10:26',5,'1020','2023-02-06 13:10:26','1020'),(15,'','1','303','BELLO BAFFAH MAI GARI ','IBRAHIM BAFFAH ','09079684847','mda04750@gmail.com','HADEJIA','JIGAWA','MALAN MADORI ','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-09 09:44:54',5,'1020','2023-02-09 09:44:54','1020'),(16,'','1','303','LAWAN G GAS ','BASHIR ISYAKU ','08131995678','bashirisyaku2011@gmail.com','HADEJIA','JIGAWA','GAWUNA QUATERS ','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-09 14:46:07',5,'1020','2023-02-09 14:46:07','1020'),(17,'','1','303','BBY MULTI PURPOSE ','BABAN YAYA ','07063638713','hassanu11id1030@gmail.com','YOBE','YOBE','YOBE','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-10 11:46:53',5,'1020','2023-02-10 11:46:53','1020'),(18,'','1','303','EASIER GAS','RABIU ISA','08167769332','hassanu11id1030@gmail.com','JIGAWA','JIGAWA','HADEJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-11 15:12:33',5,'1020','2023-02-11 15:12:33','1020'),(19,'','1','303','AMIRA GAS ','BASIRU ADO ','08067262635','basiruado@gmail.com ','JIGAWA','JIGAWA','INEC ROAD SHAGARI QUATERS HADEJA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-12 16:49:12',5,'1020','2023-02-12 16:49:12','1020'),(20,'','1','303','DAYA COOKING GAS ','DAHIRU YAHUZA IBRAHIM','08036985886','hassanu11id1030@gmail.com','YOBE','JIGAWA','NGURU','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-19 14:57:18',5,'1020','2023-02-19 14:57:18','1020'),(21,'','1','303','ALL LIMITED GAS','ISAH ALIYU','09023538304','isahaliyuauyo1@.com','AUYO','JIGAWA','GADAN BULO AUYO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-20 11:15:35',5,'1020','2023-02-20 11:15:35','1020'),(22,'','1','303','obi gas','obi','08037984913','basiruado@gmail.com ','YOBE','YOBE','nguru yobe','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-20 12:32:48',5,'1020','2023-02-20 12:32:48','1020'),(23,'','1','303','A.A RANO LPG','A.A RANO','08039159048','aarano@gmail.com','RANO','KANO','RANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-20 14:45:53',5,'1020','2023-02-20 14:45:53','1020'),(24,'','1','303','JAZZ CLIMATIC COOKING GAS','SULEIMAN LAWAN','08069479978','suleimanjakusko@gmail.com','JAHUN','JIGAWA','OLD SECRETARIAT JAHUN','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-23 13:47:58',5,'1020','2023-02-23 13:47:58','1020'),(25,'','1','303','SUNNA GAS','ADAMU ABDUJANAR','08062935969','adamuabdujanar69@gmail.com','GAMAWA','BAUCHI','BAKIN KASUWA KUSA DA GIDAN SARKIN HAUSAWA, GAMAWA.','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-23 14:23:38',5,'1020','2023-02-23 14:23:38','1020'),(26,'','1','303','A.A.COOKIN GAS ','USMAN DAHIRU USMAN ','07066926311','usmandahiruusman@gmail.com','HADEJIA','JIGAWA','INGURU ','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-27 12:07:07',5,'1020','2023-02-27 12:07:07','1020'),(27,'','1','303','MUHAMMAD COOKING GAS ','MUHAMMAD ALHAJI ALLE ','09067369013','muhammadaalle8000@gmail.com','YOBE','YOBE','LAWAN FANNAMI ','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-08 14:21:10',5,'1020','2023-03-08 14:21:10','1020'),(28,'','1','303','usman','gas','07066926311','hassanu11id1030@gmail.com','YOBE','YOBE','yobe','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-08 18:48:34',5,'1020','2023-03-08 18:48:34','1020'),(29,'','1','303','BILYAMINU COOKING GAS ','BILYAMINU IBRAHIM ','09036536059','bilyaminuibrahimkgm@gmail.com','HADEJIA','JIGAWA','KAUGAMA BAKIN KASUWA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-10 17:31:54',5,'1020','2023-03-10 17:31:54','1020'),(30,'','1','303','MABUDI COOKING GAS ','AMINU IBRAHIM ','08124284903','aminualhajiibrahim34@gmail.com','HADEJIA','JIGAWA','MAJE ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-12 11:05:14',5,'1020','2023-03-12 11:05:14','1020'),(31,'','1','303','ARAB  GAS','IBRAHIM','07065685204','basiruado@gmail.com ','HADEJA','JIGAWA','MAJE  ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-12 13:19:21',5,'1020','2023-03-12 13:19:21','1020'),(32,'','1','303','M.A GAS','MUHAMMAD','07065685204','hassanu11id1030@gmail.com','YOBE','YOBE','yobe','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-13 11:43:26',5,'1020','2023-03-13 11:43:26','1020'),(33,'','1','303','lamco','BAFFA  SANI','08030575811','hassanu11id1030@gmail.com','JIGAWA','JIGAWA','K/HAUSA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-13 15:42:49',5,'1020','2023-03-13 15:42:49','1020'),(34,'','1','303','DUNIYAR GAS ','SURAJA','08067433924','hassanu11id1030@gmail.com','BIRNIWA','JIGAWA','ABARI BIRNIWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-14 09:02:30',5,'1020','2023-03-14 09:02:30','1020'),(35,'','1','303','MUHAMMAD HALLAI','MUHAMMDD','09067369013','hassanu11id1030@gmail.com','YOBE','YOBE','GASHUWA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-17 12:48:18',5,'1020','2023-03-17 12:48:18','1020'),(36,'','1','303','OPERATIONAL LOSS','A.A RANO','09126710136','victoriachinazo2019@gmail.com','KANO','KANO','AA RANO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-20 10:09:30',5,'1020','2023-03-20 10:09:30','1020');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','303','1',1,'5','LPG NOZZLE 1',13732.00,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','303','1',2,'5','LPG NOZZLE 2',8758.53,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','303','1',3,'5','LPG NOZZLE 3',1650.00,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','303','1',4,'5','LPG NOZZLE 4',2860.95,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','303','1',5,'5','LPG NOZZLE 5',22650.01,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','303','1',6,'5','LPG NOZZLE 6',1347.02,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','303',1,'NEW SHIFT','2023-01-15','2023-01-15 09:29:59','2023-01-16 09:29:59','1020',0.00,0.00,'1020','2023-01-15 19:00:04','1020','2023-01-15 19:01:27',10,0),('1','303',2,'DAILY SHIFT','2023-01-16','2023-01-16 07:42:07','2023-01-17 07:42:07','1020',0.00,0.00,'1020','2023-01-16 19:02:35','1020','2023-01-16 19:03:04',10,0),('1','303',3,'DAILY SHIFT','2023-01-17','2023-01-17 07:36:29','2023-01-18 07:36:29','1020',0.00,0.00,'1020','2023-01-17 18:43:20','1020','2023-01-17 18:43:49',10,0),('1','303',4,'DAILY SHIFT','2023-01-18','2023-01-18 09:07:02','2023-01-19 09:07:02','1020',0.00,0.00,'1020','2023-01-18 19:03:19','1020','2023-01-18 19:03:51',10,0),('1','303',5,'DAILY SHIFT','2023-01-19','2023-01-19 07:40:47','2023-01-20 07:40:47','1020',0.00,0.00,'1020','2023-01-19 18:34:53','1020','2023-01-19 18:35:30',10,0),('1','303',6,'DAILY SHIFT','2023-01-20','2023-01-20 08:15:03','2023-01-21 08:15:03','1020',0.00,0.00,'1020','2023-01-20 18:18:35','1020','2023-01-20 18:39:52',10,0),('1','303',7,'DAILY SHIFT','2023-01-21','2023-01-21 08:15:05','2023-01-22 08:15:05','1020',0.00,0.00,'1020','2023-01-21 18:53:44','1020','2023-01-21 18:54:05',10,0),('1','303',8,'DAILY SHIFT','2023-01-22','2023-01-22 07:39:06','2023-01-23 07:39:06','1020',0.00,0.00,'1020','2023-01-22 18:50:04','1020','2023-01-22 18:50:34',10,0),('1','303',9,'DAILY SHIFT','2023-01-23','2023-01-23 08:10:12','2023-01-24 08:10:12','1020',0.00,0.00,'1020','2023-01-23 18:51:34','1020','2023-01-23 18:51:53',10,0),('1','303',10,'DAILY SHIFT','2023-01-24','2023-01-24 08:11:48','2023-01-25 08:11:48','1020',0.00,0.00,'1020','2023-01-24 18:40:43','1020','2023-01-24 18:44:18',10,0),('1','303',11,'DAILY SHIFT','2023-01-25','2023-01-25 07:00:06','2023-01-26 07:00:06','1020',0.00,0.00,'1020','2023-01-25 18:44:19','1020','2023-01-25 18:44:39',10,0),('1','303',12,'DAILY SHIFT','2023-01-26','2023-01-26 07:33:12','2023-01-27 07:33:12','1020',0.00,0.00,'1020','2023-01-26 18:15:14','1020','2023-01-26 18:16:53',10,0),('1','303',13,'DAILY SHIFT','2023-01-27','2023-01-27 06:49:21','2023-01-28 06:49:21','1020',0.00,0.00,'1020','2023-01-27 19:27:02','1020','2023-01-27 19:27:28',10,0),('1','303',14,'DAILY SHIFT','2023-01-28','2023-01-28 07:07:30','2023-01-29 07:07:30','1020',0.00,0.00,'1020','2023-01-28 19:17:00','1020','2023-01-28 19:17:27',10,0),('1','303',15,'DAILY SHIFT','2023-01-29','2023-01-29 07:11:44','2023-01-30 07:11:44','1020',0.00,0.00,'1020','2023-01-29 18:37:07','1020','2023-01-29 18:37:33',10,0),('1','303',16,'DAILY SHIFT','2023-01-30','2023-01-30 07:12:14','2023-01-31 07:12:14','1020',0.00,0.00,'1020','2023-01-30 20:03:14','1020','2023-01-30 20:03:51',10,0),('1','303',17,'DAILY SHIFT','2023-01-31','2023-01-31 07:24:17','2023-02-01 07:24:17','1020',0.00,0.00,'1020','2023-01-31 18:42:17','1020','2023-01-31 18:42:40',10,0),('1','303',18,'DAILY SHIFT','2023-02-01','2023-02-01 07:25:58','2023-02-02 07:25:58','1020',0.00,0.00,'1020','2023-02-01 18:43:01','1020','2023-02-01 18:43:32',10,0),('1','303',19,'DAILY SHIFT','2023-02-02','2023-02-02 07:33:26','2023-02-03 07:33:26','1020',0.00,0.00,'1020','2023-02-02 22:29:23','1020','2023-02-02 22:29:50',10,0),('1','303',20,'DAILY SHIFT','2023-02-03','2023-02-03 08:53:27','2023-02-04 08:53:27','1020',0.00,0.00,'1020','2023-02-03 19:00:40','1020','2023-02-03 19:01:53',10,0),('1','303',21,'DAILY SHIFT','2023-02-04','2023-02-04 08:16:38','2023-02-05 08:16:38','1020',0.00,0.00,'1020','2023-02-04 18:57:29','1020','2023-02-04 18:57:55',10,0),('1','303',22,'DAILY SHIFT','2023-02-05','2023-02-05 07:48:40','2023-02-06 07:48:40','1020',0.00,0.00,'1020','2023-02-05 18:54:26','1020','2023-02-05 18:54:59',10,0),('1','303',23,'DAILY SHIFT','2023-02-06','2023-02-06 07:34:18','2023-02-07 07:34:18','1020',0.00,0.00,'1020','2023-02-06 18:49:10','1020','2023-02-06 18:49:39',10,0),('1','303',24,'DAILY SHIFT','2023-02-07','2023-02-07 07:35:04','2023-02-08 07:35:04','1020',0.00,0.00,'1020','2023-02-07 18:55:14','1020','2023-02-07 18:55:48',10,0),('1','303',25,'DAILY SHIFT','2023-02-08','2023-02-08 08:09:15','2023-02-09 08:09:15','1020',0.00,0.00,'1020','2023-02-08 18:56:46','1020','2023-02-08 18:57:10',10,0),('1','303',26,'DAILY SHIFT','2023-02-09','2023-02-09 07:07:36','2023-02-10 07:07:36','1020',0.00,0.00,'1020','2023-02-09 18:36:04','1020','2023-02-09 18:36:24',10,0),('1','303',27,'DAILY SHIFT','2023-02-10','2023-02-10 07:35:38','2023-02-11 07:35:38','1020',0.00,0.00,'1020','2023-02-10 19:39:08','1020','2023-02-10 19:39:31',10,0),('1','303',28,'DAILY SHIFT','2023-02-11','2023-02-11 07:27:03','2023-02-12 07:27:03','1020',0.00,0.00,'1020','2023-02-11 18:47:53','1020','2023-02-11 18:48:11',10,0),('1','303',29,'DAILY SHIFT','2023-02-12','2023-02-12 07:23:50','2023-02-13 07:23:50','1020',0.00,0.00,'1020','2023-02-12 20:05:19','1020','2023-02-12 20:05:44',10,0),('1','303',30,'DAILY SHIFT','2023-02-13','2023-02-13 08:10:58','2023-02-14 08:10:58','1020',0.00,0.00,'1020','2023-02-13 19:27:19','1020','2023-02-13 19:27:53',10,0),('1','303',31,'DAILY SHIFT','2023-02-14','2023-02-14 07:30:27','2023-02-15 07:30:27','1020',0.00,0.00,'1020','2023-02-14 19:22:21','1020','2023-02-14 19:22:44',10,0),('1','303',32,'DAILY SHIFT','2023-02-15','2023-02-15 07:51:51','2023-02-16 07:51:51','1020',0.00,0.00,'1020','2023-02-15 18:42:35','1020','2023-02-15 18:43:02',10,0),('1','303',33,'DAILY SHIFT','2023-02-16','2023-02-16 08:00:02','2023-02-17 08:00:02','1020',0.00,0.00,'1020','2023-02-16 18:57:33','1020','2023-02-16 18:57:52',10,0),('1','303',34,'DAILY SHIFT','2023-02-17','2023-02-17 08:17:24','2023-02-18 08:17:24','1020',0.00,0.00,'1020','2023-02-17 19:18:22','1020','2023-02-17 19:18:45',10,0),('1','303',35,'DAILY SHIFT','2023-02-18','2023-02-18 07:59:58','2023-02-19 07:59:58','1020',0.00,0.00,'1020','2023-02-18 18:47:43','1020','2023-02-18 18:48:31',10,0),('1','303',36,'DAILY SHIFT','2023-02-19','2023-02-19 07:49:38','2023-02-20 07:49:38','1020',0.00,0.00,'1020','2023-02-19 19:18:04','1020','2023-02-19 19:18:28',10,0),('1','303',37,'DAILY SHIFT','2023-02-20','2023-02-20 07:57:31','2023-02-21 07:57:31','1020',0.00,0.00,'1020','2023-02-20 14:42:09','1020','2023-02-20 14:42:28',10,0),('1','303',38,'DAILY SHIFT','2023-02-20','2023-02-20 14:42:54','2023-02-21 14:42:54','1020',0.00,0.00,'1020','2023-02-20 14:57:09','1020','2023-02-20 14:57:32',10,0),('1','303',39,'DAYLY SHIFT','2023-02-20','2023-02-20 17:02:30','2023-02-21 17:02:30','1020',0.00,0.00,'1020','2023-02-20 19:42:36','1020','2023-02-20 19:42:55',10,0),('1','303',40,'DAILY SHIFT','2023-02-21','2023-02-21 08:05:35','2023-02-22 08:05:35','1020',0.00,0.00,'1020','2023-02-21 18:49:35','1020','2023-02-21 18:51:08',10,0),('1','303',41,'DAILY SHIFT','2023-02-22','2023-02-22 08:57:22','2023-02-23 08:57:22','1020',0.00,0.00,'1020','2023-02-22 19:16:29','1020','2023-02-22 19:16:48',10,0),('1','303',42,'DAILY SHIFT','2023-02-23','2023-02-23 08:01:06','2023-02-24 08:01:06','1020',0.00,0.00,'1020','2023-02-23 19:17:36','1020','2023-02-23 19:17:55',10,0),('1','303',43,'DAILY SHIFT','2023-02-24','2023-02-24 08:00:51','2023-02-25 08:00:51','1020',0.00,0.00,'1020','2023-02-24 20:05:05','1020','2023-02-24 20:05:21',10,0),('1','303',44,'DAILY SHIFT','2023-02-26','2023-02-26 12:04:16','2023-02-27 12:04:16','1020',0.00,0.00,'1020','2023-02-26 19:52:06','1020','2023-02-26 19:52:25',10,0),('1','303',45,'DAILY SHIFT','2023-02-27','2023-02-27 07:27:06','2023-02-28 07:27:06','1020',0.00,0.00,'1020','2023-02-27 19:45:45','1020','2023-02-27 19:46:08',10,0),('1','303',46,'DAILY SHIFT','2023-02-28','2023-02-28 07:40:16','2023-03-01 07:40:16','1020',0.00,0.00,'1020','2023-02-28 18:58:14','1020','2023-02-28 18:58:36',10,0),('1','303',47,'DAILY SHIFT','2023-03-02','2023-03-02 07:52:22','2023-03-03 07:52:22','1020',0.00,0.00,'1020','2023-03-02 19:03:16','1020','2023-03-02 19:03:37',10,0),('1','303',48,'DAILY SHIFT','2023-03-03','2023-03-03 07:41:53','2023-03-04 07:41:53','1020',0.00,0.00,'1020','2023-03-03 20:10:47','1020','2023-03-03 20:11:22',10,0),('1','303',49,'DAILY SHIFT','2023-03-04','2023-03-04 07:40:31','2023-03-05 07:40:31','1020',0.00,0.00,'1020','2023-03-04 18:36:48','1020','2023-03-04 18:37:16',10,0),('1','303',50,'DAILY SHIFT','2023-03-05','2023-03-05 07:45:28','2023-03-06 07:45:28','1020',0.00,0.00,'1020','2023-03-05 18:49:36','1020','2023-03-05 18:49:52',10,0),('1','303',51,'DAILY SHIFT','2023-03-06','2023-03-06 08:41:51','2023-03-07 08:41:51','1020',0.00,0.00,'1020','2023-03-06 18:50:52','1020','2023-03-06 18:51:21',10,0),('1','303',52,'DAILY SHIFT','2023-03-07','2023-03-07 07:53:12','2023-03-08 07:53:12','1020',0.00,0.00,'1020','2023-03-07 18:56:08','1020','2023-03-07 18:56:25',10,0),('1','303',53,'DAILY SHIFT','2023-03-08','2023-03-08 08:12:50','2023-03-09 08:12:50','1020',0.00,0.00,'1020','2023-03-08 19:52:31','1020','2023-03-08 19:52:49',10,0),('1','303',54,'DAILY SHIFT','2023-03-09','2023-03-09 08:19:38','2023-03-10 08:19:38','1020',0.00,0.00,'1020','2023-03-09 18:57:14','1020','2023-03-09 18:57:52',10,0),('1','303',55,'DAILY SHIFT','2023-03-10','2023-03-10 07:42:13','2023-03-11 07:42:13','1020',0.00,0.00,'1020','2023-03-10 18:55:12','1020','2023-03-10 18:55:31',10,0),('1','303',56,'DAILY SHIFT','2023-03-11','2023-03-11 07:48:14','2023-03-12 07:48:14','1020',0.00,0.00,'1020','2023-03-11 20:35:28','1020','2023-03-11 20:35:47',10,0),('1','303',57,'DAILY SHIFT','2023-03-12','2023-03-12 07:26:28','2023-03-13 07:26:28','1020',0.00,0.00,'1020','2023-03-12 18:54:00','1020','2023-03-12 18:54:17',10,0),('1','303',58,'DAILY SHIFT','2023-03-13','2023-03-13 07:27:47','2023-03-14 07:27:47','1020',0.00,0.00,'1020','2023-03-13 19:24:57','1020','2023-03-13 19:25:17',10,0),('1','303',59,'DAILY SHIFT','2023-03-14','2023-03-14 07:20:29','2023-03-15 07:20:29','1020',0.00,0.00,'1020','2023-03-14 19:24:03','1020','2023-03-14 19:24:22',10,0),('1','303',60,'DAILY SHIFT','2023-03-15','2023-03-15 07:29:07','2023-03-16 07:29:07','1020',0.00,0.00,'1020','2023-03-15 19:05:40','1020','2023-03-15 19:06:04',10,0),('1','303',61,'DAILY SHIFT','2023-03-16','2023-03-16 07:47:15','2023-03-17 07:47:15','1020',0.00,0.00,'1020','2023-03-16 19:56:36','1020','2023-03-16 19:56:52',10,0),('1','303',62,'DAILY SHIFT','2023-03-17','2023-03-17 07:44:09','2023-03-18 07:44:09','1020',0.00,0.00,'1020','2023-03-17 19:38:25','1020','2023-03-17 19:38:43',10,0),('1','303',63,'DAILY SHIFT','2023-03-19','2023-03-19 08:05:45','2023-03-20 08:05:45','1020',0.00,0.00,'1020','2023-03-19 18:51:50','1020','2023-03-20 08:52:49',10,0),('1','303',64,'OPERATIONAL LOSS','2023-03-20','2023-03-20 10:05:19','2023-03-21 10:05:19','1020',0.00,0.00,'1020','2023-03-20 10:16:13','1020','2023-03-20 10:16:54',10,0),('1','303',65,'DAILY SHIFT','2023-03-20','2023-03-20 10:35:33','2023-03-21 10:35:33','1020',0.00,0.00,'1020','2023-03-20 19:29:19','1020','2023-03-20 19:29:47',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=391 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','303','1','1',1,'1','1',0.00,106.50,0.00,0.00,106.50,80088.00,0.00,0.00,0.00),('1','303','1','1',2,'2','1',0.00,6.00,0.00,0.00,6.00,4512.00,0.00,0.00,0.00),('1','303','1','1',3,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','1',4,'4','1',0.00,459.75,0.00,0.00,459.75,326422.50,0.00,0.00,0.00),('1','303','1','1',5,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','1',6,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','2',7,'1','1',106.50,193.78,0.00,0.00,87.28,65634.56,0.00,0.00,0.00),('1','303','1','2',8,'2','1',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','2',9,'3','1',0.00,300.00,0.00,0.00,300.00,213000.00,0.00,0.00,0.00),('1','303','1','2',10,'4','1',459.75,459.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','2',11,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','2',12,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','3',13,'1','1',193.78,232.66,0.00,0.00,38.88,29237.76,0.00,0.00,0.00),('1','303','1','3',14,'2','1',6.00,12.05,0.00,0.00,6.05,4549.60,0.00,0.00,0.00),('1','303','1','3',15,'3','1',300.00,300.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','3',16,'4','1',459.75,459.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','3',17,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','3',18,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','4',19,'1','1',232.66,515.89,0.00,0.00,283.23,203925.60,0.00,0.00,0.00),('1','303','1','4',20,'2','1',12.05,40.33,0.00,0.00,28.28,20361.60,0.00,0.00,0.00),('1','303','1','4',21,'3','1',300.00,300.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','4',22,'4','1',459.75,1609.75,0.00,0.00,1150.00,793500.00,0.00,0.00,0.00),('1','303','1','4',23,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','4',24,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','5',25,'1','1',515.89,794.54,0.00,0.00,278.65,200628.00,0.00,0.00,0.00),('1','303','1','5',26,'2','1',40.33,43.33,0.00,0.00,3.00,2160.00,0.00,0.00,0.00),('1','303','1','5',27,'3','1',300.00,300.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','5',28,'4','1',1609.75,1609.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','5',29,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','5',30,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','6',31,'1','1',794.54,999.08,0.00,0.00,204.54,147268.80,0.00,0.00,0.00),('1','303','1','6',32,'2','1',43.33,99.47,0.00,0.00,56.14,40420.80,0.00,0.00,0.00),('1','303','1','6',33,'3','1',300.00,300.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','6',34,'4','1',1609.75,1609.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','6',35,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','6',36,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','7',37,'1','1',999.08,1203.79,0.00,0.00,204.71,147391.20,0.00,0.00,0.00),('1','303','1','7',38,'2','1',99.47,150.42,0.00,0.00,50.95,36684.00,0.00,0.00,0.00),('1','303','1','7',39,'3','1',300.00,300.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','7',40,'4','1',1609.75,1609.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','7',41,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','7',42,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','8',43,'1','1',1203.79,1572.85,0.00,0.00,369.06,265723.20,0.00,0.00,0.00),('1','303','1','8',44,'2','1',150.42,170.42,0.00,0.00,20.00,14400.00,0.00,0.00,0.00),('1','303','1','8',45,'3','1',300.00,300.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','8',46,'4','1',1609.75,1609.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','8',47,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','8',48,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','9',49,'1','1',1572.85,1918.33,0.00,0.00,345.48,248745.60,0.00,0.00,0.00),('1','303','1','9',50,'2','1',170.42,228.16,0.00,0.00,57.74,41572.80,0.00,0.00,0.00),('1','303','1','9',51,'3','1',300.00,300.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','9',52,'4','1',1609.75,1609.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','9',53,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','9',54,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','10',55,'1','1',1918.33,2232.11,0.00,0.00,313.78,225921.60,0.00,0.00,0.00),('1','303','1','10',56,'2','1',228.16,254.76,0.00,0.00,26.60,19152.00,0.00,0.00,0.00),('1','303','1','10',57,'3','1',300.00,1400.00,0.00,0.00,1100.00,759000.00,0.00,0.00,0.00),('1','303','1','10',58,'4','1',1609.75,1609.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','10',59,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','10',60,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','11',61,'1','1',2232.11,2558.10,0.00,0.00,325.99,234712.80,0.00,0.00,0.00),('1','303','1','11',62,'2','1',254.76,285.65,0.00,0.00,30.89,22240.80,0.00,0.00,0.00),('1','303','1','11',63,'3','1',1400.00,1600.00,0.00,0.00,200.00,138000.00,0.00,0.00,0.00),('1','303','1','11',64,'4','1',1609.75,1609.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','11',65,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','11',66,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','12',67,'1','1',2558.10,3063.13,0.00,0.00,505.03,363621.60,0.00,0.00,0.00),('1','303','1','12',68,'2','1',285.65,316.65,0.00,0.00,31.00,22320.00,0.00,0.00,0.00),('1','303','1','12',69,'3','1',1600.00,1600.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','12',70,'4','1',1609.75,1609.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','12',71,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','12',72,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','13',73,'1','1',3063.13,3388.40,0.00,0.00,325.27,234194.40,0.00,0.00,0.00),('1','303','1','13',74,'2','1',316.65,409.66,0.00,0.00,93.01,66967.20,0.00,0.00,0.00),('1','303','1','13',75,'3','1',1600.00,1600.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','13',76,'4','1',1609.75,1609.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','13',77,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','13',78,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','14',79,'1','1',3388.40,3648.72,0.00,0.00,260.32,187430.40,0.00,0.00,0.00),('1','303','1','14',80,'2','1',409.66,511.44,0.00,0.00,101.78,73281.60,0.00,0.00,0.00),('1','303','1','14',81,'3','1',1600.00,1600.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','14',82,'4','1',1609.75,2459.79,0.00,0.00,850.04,586527.60,0.00,0.00,0.00),('1','303','1','14',83,'5','1',0.00,350.00,0.00,0.00,350.00,241500.00,0.00,0.00,0.00),('1','303','1','14',84,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','15',85,'1','1',3648.72,3929.92,0.00,0.00,281.20,202464.00,0.00,0.00,0.00),('1','303','1','15',86,'2','1',511.44,702.05,0.00,0.00,190.61,137239.20,0.00,0.00,0.00),('1','303','1','15',87,'3','1',1600.00,1600.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','15',88,'4','1',2459.79,2509.79,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','303','1','15',89,'5','1',350.00,350.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','15',90,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','16',91,'1','1',3929.92,4142.31,0.00,0.00,212.39,152920.80,0.00,0.00,0.00),('1','303','1','16',92,'2','1',702.05,890.00,0.00,0.00,187.95,135324.00,0.00,0.00,0.00),('1','303','1','16',93,'3','1',1600.00,1600.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','16',94,'4','1',2509.79,2559.79,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','303','1','16',95,'5','1',350.00,450.00,0.00,0.00,100.00,69000.00,0.00,0.00,0.00),('1','303','1','16',96,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','17',97,'1','1',4142.31,4263.79,0.00,0.00,121.48,87465.60,0.00,0.00,0.00),('1','303','1','17',98,'2','1',890.00,995.69,0.00,0.00,105.69,76096.80,0.00,0.00,0.00),('1','303','1','17',99,'3','1',1600.00,1600.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','17',100,'4','1',2559.79,2559.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','17',101,'5','1',450.00,790.00,0.00,0.00,340.00,234600.00,0.00,0.00,0.00),('1','303','1','17',102,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','18',103,'1','1',4263.79,4401.43,0.00,0.00,137.64,99100.80,0.00,0.00,0.00),('1','303','1','18',104,'2','1',995.69,1105.83,0.00,0.00,110.14,79300.80,0.00,0.00,0.00),('1','303','1','18',105,'3','1',1600.00,1650.00,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','303','1','18',106,'4','1',2559.79,2609.79,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','303','1','18',107,'5','1',790.00,1026.23,0.00,0.00,236.23,162998.70,0.00,0.00,0.00),('1','303','1','18',108,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','19',109,'1','1',4401.43,4550.82,0.00,0.00,149.39,107560.80,0.00,0.00,0.00),('1','303','1','19',110,'2','1',1105.83,1236.88,0.00,0.00,131.05,94356.00,0.00,0.00,0.00),('1','303','1','19',111,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','19',112,'4','1',2609.79,2609.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','19',113,'5','1',1026.23,2226.23,0.00,0.00,1200.00,828000.00,0.00,0.00,0.00),('1','303','1','19',114,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','20',115,'1','1',4550.82,4705.30,0.00,0.00,154.48,111225.60,0.00,0.00,0.00),('1','303','1','20',116,'2','1',1236.88,1368.63,0.00,0.00,131.75,94860.00,0.00,0.00,0.00),('1','303','1','20',117,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','20',118,'4','1',2609.79,2609.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','20',119,'5','1',2226.23,3090.12,0.00,0.00,863.89,596084.10,0.00,0.00,0.00),('1','303','1','20',120,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','21',121,'1','1',4705.30,4831.50,0.00,0.00,126.20,90864.00,0.00,0.00,0.00),('1','303','1','21',122,'2','1',1368.63,1498.36,0.00,0.00,129.73,93405.60,0.00,0.00,0.00),('1','303','1','21',123,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','21',124,'4','1',2609.79,2659.79,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','303','1','21',125,'5','1',3090.12,3140.65,0.00,0.00,50.53,34865.70,0.00,0.00,0.00),('1','303','1','21',126,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','22',127,'1','1',4831.50,5053.27,0.00,0.00,221.77,159674.40,0.00,0.00,0.00),('1','303','1','22',128,'2','1',1498.36,1654.37,0.00,0.00,156.01,112327.20,0.00,0.00,0.00),('1','303','1','22',129,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','22',130,'4','1',2659.79,2659.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','22',131,'5','1',3140.65,3190.65,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','303','1','22',132,'6','1',0.00,340.00,0.00,0.00,340.00,234600.00,0.00,0.00,0.00),('1','303','1','23',133,'1','1',5053.27,5219.78,0.00,0.00,166.51,119887.20,0.00,0.00,0.00),('1','303','1','23',134,'2','1',1654.37,1867.77,0.00,0.00,213.40,153648.00,0.00,0.00,0.00),('1','303','1','23',135,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','23',136,'4','1',2659.79,2759.79,0.00,0.00,100.00,69000.00,0.00,0.00,0.00),('1','303','1','23',137,'5','1',3190.65,3240.65,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','303','1','23',138,'6','1',340.00,340.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','24',139,'1','1',5219.78,5387.99,0.00,0.00,168.21,121111.20,0.00,0.00,0.00),('1','303','1','24',140,'2','1',1867.77,2050.14,0.00,0.00,182.37,131306.40,0.00,0.00,0.00),('1','303','1','24',141,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','24',142,'4','1',2759.79,2759.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','24',143,'5','1',3240.65,3240.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','24',144,'6','1',340.00,340.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','25',145,'1','1',5387.99,5578.77,0.00,0.00,190.78,137361.60,0.00,0.00,0.00),('1','303','1','25',146,'2','1',2050.14,2175.57,0.00,0.00,125.43,90309.60,0.00,0.00,0.00),('1','303','1','25',147,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','25',148,'4','1',2759.79,2759.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','25',149,'5','1',3240.65,3390.65,0.00,0.00,150.00,103500.00,0.00,0.00,0.00),('1','303','1','25',150,'6','1',340.00,340.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','26',151,'1','1',5578.77,5743.40,0.00,0.00,164.63,118533.60,0.00,0.00,0.00),('1','303','1','26',152,'2','1',2175.57,2328.60,0.00,0.00,153.03,110181.60,0.00,0.00,0.00),('1','303','1','26',153,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','26',154,'4','1',2759.79,2759.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','26',155,'5','1',3390.65,4290.65,0.00,0.00,900.00,621000.00,0.00,0.00,0.00),('1','303','1','26',156,'6','1',340.00,490.00,0.00,0.00,150.00,103500.00,0.00,0.00,0.00),('1','303','1','27',157,'1','1',5743.40,5884.15,0.00,0.00,140.75,101340.00,0.00,0.00,0.00),('1','303','1','27',158,'2','1',2328.60,2396.08,0.00,0.00,67.48,48585.60,0.00,0.00,0.00),('1','303','1','27',159,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','27',160,'4','1',2759.79,2759.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','27',161,'5','1',4290.65,4458.61,0.00,0.00,167.96,115892.40,0.00,0.00,0.00),('1','303','1','27',162,'6','1',490.00,789.02,0.00,0.00,299.02,206323.80,0.00,0.00,0.00),('1','303','1','28',163,'1','1',5884.15,6059.39,0.00,0.00,175.24,126172.80,0.00,0.00,0.00),('1','303','1','28',164,'2','1',2396.08,2521.25,0.00,0.00,125.17,90122.40,0.00,0.00,0.00),('1','303','1','28',165,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','28',166,'4','1',2759.79,2759.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','28',167,'5','1',4458.61,4716.61,0.00,0.00,258.00,178020.00,0.00,0.00,0.00),('1','303','1','28',168,'6','1',789.02,939.02,0.00,0.00,150.00,103500.00,0.00,0.00,0.00),('1','303','1','29',169,'1','1',6059.39,6321.49,0.00,0.00,262.10,188712.00,0.00,0.00,0.00),('1','303','1','29',170,'2','1',2521.25,2639.25,0.00,0.00,118.00,84960.00,0.00,0.00,0.00),('1','303','1','29',171,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','29',172,'4','1',2759.79,2759.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','29',173,'5','1',4716.61,5424.61,0.00,0.00,708.00,488520.00,0.00,0.00,0.00),('1','303','1','29',174,'6','1',939.02,939.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','30',175,'1','1',6321.49,6537.26,0.00,0.00,215.77,155354.40,0.00,0.00,0.00),('1','303','1','30',176,'2','1',2639.25,2781.88,0.00,0.00,142.63,102693.60,0.00,0.00,0.00),('1','303','1','30',177,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','30',178,'4','1',2759.79,2759.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','30',179,'5','1',5424.61,5670.61,0.00,0.00,246.00,169740.00,0.00,0.00,0.00),('1','303','1','30',180,'6','1',939.02,1092.02,0.00,0.00,153.00,105570.00,0.00,0.00,0.00),('1','303','1','31',181,'1','1',6537.26,6663.42,0.00,0.00,126.16,90835.20,0.00,0.00,0.00),('1','303','1','31',182,'2','1',2781.88,2893.67,0.00,0.00,111.79,80488.80,0.00,0.00,0.00),('1','303','1','31',183,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','31',184,'4','1',2759.79,2759.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','31',185,'5','1',5670.61,5770.61,0.00,0.00,100.00,69000.00,0.00,0.00,0.00),('1','303','1','31',186,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','32',187,'1','1',6663.42,6835.20,0.00,0.00,171.78,123681.60,0.00,0.00,0.00),('1','303','1','32',188,'2','1',2893.67,2999.58,0.00,0.00,105.91,76255.20,0.00,0.00,0.00),('1','303','1','32',189,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','32',190,'4','1',2759.79,2759.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','32',191,'5','1',5770.61,5970.61,0.00,0.00,200.00,138000.00,0.00,0.00,0.00),('1','303','1','32',192,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','33',193,'1','1',6835.20,7024.75,0.00,0.00,189.55,136476.00,0.00,0.00,0.00),('1','303','1','33',194,'2','1',2999.58,3163.32,0.00,0.00,163.74,117892.80,0.00,0.00,0.00),('1','303','1','33',195,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','33',196,'4','1',2759.79,2809.79,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','303','1','33',197,'5','1',5970.61,6070.61,0.00,0.00,100.00,69000.00,0.00,0.00,0.00),('1','303','1','33',198,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','34',199,'1','1',7024.75,7194.85,0.00,0.00,170.10,122472.00,0.00,0.00,0.00),('1','303','1','34',200,'2','1',3163.32,3339.55,0.00,0.00,176.23,126885.60,0.00,0.00,0.00),('1','303','1','34',201,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','34',202,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','34',203,'5','1',6070.61,6770.61,0.00,0.00,700.00,483000.00,0.00,0.00,0.00),('1','303','1','34',204,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','35',205,'1','1',7194.85,7377.54,0.00,0.00,182.69,131536.80,0.00,0.00,0.00),('1','303','1','35',206,'2','1',3339.55,3528.40,0.00,0.00,188.85,135972.00,0.00,0.00,0.00),('1','303','1','35',207,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','35',208,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','35',209,'5','1',6770.61,6770.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','35',210,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','36',211,'1','1',7377.54,7551.75,0.00,0.00,174.21,125431.20,0.00,0.00,0.00),('1','303','1','36',212,'2','1',3528.40,3657.27,0.00,0.00,128.87,92786.40,0.00,0.00,0.00),('1','303','1','36',213,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','36',214,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','36',215,'5','1',6770.61,6870.61,0.00,0.00,100.00,69000.00,0.00,0.00,0.00),('1','303','1','36',216,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','37',217,'1','1',7551.75,7610.19,0.00,0.00,58.44,42076.80,0.00,0.00,0.00),('1','303','1','37',218,'2','1',3657.27,3733.38,0.00,0.00,76.11,54799.20,0.00,0.00,0.00),('1','303','1','37',219,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','37',220,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','37',221,'5','1',6870.61,7117.50,0.00,0.00,246.89,170354.10,0.00,0.00,0.00),('1','303','1','37',222,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','38',223,'1','1',7610.19,7610.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','38',224,'2','1',3733.38,3733.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','38',225,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','38',226,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','38',227,'5','1',7117.50,7117.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','38',228,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','39',229,'1','1',7610.19,7660.42,0.00,0.00,50.23,36165.60,0.00,0.00,0.00),('1','303','1','39',230,'2','1',3733.38,3802.88,0.00,0.00,69.50,50040.00,0.00,0.00,0.00),('1','303','1','39',231,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','39',232,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','39',233,'5','1',7117.50,7270.41,0.00,0.00,152.91,105507.90,0.00,0.00,0.00),('1','303','1','39',234,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','40',235,'1','1',7660.42,7876.46,0.00,0.00,216.04,155548.80,0.00,0.00,0.00),('1','303','1','40',236,'2','1',3802.88,3932.79,0.00,0.00,129.91,93535.20,0.00,0.00,0.00),('1','303','1','40',237,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','40',238,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','40',239,'5','1',7270.41,7370.41,0.00,0.00,100.00,69000.00,0.00,0.00,0.00),('1','303','1','40',240,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','41',241,'1','1',7876.46,8043.10,0.00,0.00,166.64,119980.80,0.00,0.00,0.00),('1','303','1','41',242,'2','1',3932.79,4105.27,0.00,0.00,172.48,124185.60,0.00,0.00,0.00),('1','303','1','41',243,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','41',244,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','41',245,'5','1',7370.41,7520.41,0.00,0.00,150.00,103500.00,0.00,0.00,0.00),('1','303','1','41',246,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','42',247,'1','1',8043.10,8266.14,0.00,0.00,223.04,160588.80,0.00,0.00,0.00),('1','303','1','42',248,'2','1',4105.27,4279.36,0.00,0.00,174.09,125344.80,0.00,0.00,0.00),('1','303','1','42',249,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','42',250,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','42',251,'5','1',7520.41,8875.91,0.00,0.00,1355.50,935295.00,0.00,0.00,0.00),('1','303','1','42',252,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','43',253,'1','1',8266.14,8576.49,0.00,0.00,310.35,223452.00,0.00,0.00,0.00),('1','303','1','43',254,'2','1',4279.36,4443.00,0.00,0.00,163.64,117820.80,0.00,0.00,0.00),('1','303','1','43',255,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','43',256,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','43',257,'5','1',8875.91,9833.91,0.00,0.00,958.00,661020.00,0.00,0.00,0.00),('1','303','1','43',258,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','44',259,'1','1',8576.49,8630.46,0.00,0.00,53.97,38858.40,0.00,0.00,0.00),('1','303','1','44',260,'2','1',4443.00,4501.29,0.00,0.00,58.29,41968.80,0.00,0.00,0.00),('1','303','1','44',261,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','44',262,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','44',263,'5','1',9833.91,9841.91,0.00,0.00,8.00,5520.00,0.00,0.00,0.00),('1','303','1','44',264,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','45',265,'1','1',8630.46,8932.29,0.00,0.00,301.83,217317.60,0.00,0.00,0.00),('1','303','1','45',266,'2','1',4501.29,4787.04,0.00,0.00,285.75,205740.00,0.00,0.00,0.00),('1','303','1','45',267,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','45',268,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','45',269,'5','1',9841.91,10545.81,0.00,0.00,703.90,485691.00,0.00,0.00,0.00),('1','303','1','45',270,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','46',271,'1','1',8932.29,9205.00,0.00,0.00,272.71,196351.20,0.00,0.00,0.00),('1','303','1','46',272,'2','1',4787.04,5035.49,0.00,0.00,248.45,178884.00,0.00,0.00,0.00),('1','303','1','46',273,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','46',274,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','46',275,'5','1',10545.81,10695.81,0.00,0.00,150.00,103500.00,0.00,0.00,0.00),('1','303','1','46',276,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','47',277,'1','1',9205.00,9637.13,0.00,0.00,432.13,311133.60,0.00,0.00,0.00),('1','303','1','47',278,'2','1',5035.49,5276.67,0.00,0.00,241.18,173649.60,0.00,0.00,0.00),('1','303','1','47',279,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','47',280,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','47',281,'5','1',10695.81,11769.00,0.00,0.00,1073.19,740501.10,0.00,0.00,0.00),('1','303','1','47',282,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','48',283,'1','1',9637.13,9842.14,0.00,0.00,205.01,147607.20,0.00,0.00,0.00),('1','303','1','48',284,'2','1',5276.67,5479.88,0.00,0.00,203.21,146311.20,0.00,0.00,0.00),('1','303','1','48',285,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','48',286,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','48',287,'5','1',11769.00,11869.00,0.00,0.00,100.00,69000.00,0.00,0.00,0.00),('1','303','1','48',288,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','49',289,'1','1',9842.14,10145.15,0.00,0.00,303.01,218167.20,0.00,0.00,0.00),('1','303','1','49',290,'2','1',5479.88,5599.24,0.00,0.00,119.36,85939.20,0.00,0.00,0.00),('1','303','1','49',291,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','49',292,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','49',293,'5','1',11869.00,11919.00,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','303','1','49',294,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','50',295,'1','1',10145.15,10465.14,0.00,0.00,319.99,230392.80,0.00,0.00,0.00),('1','303','1','50',296,'2','1',5599.24,5697.21,0.00,0.00,97.97,70538.40,0.00,0.00,0.00),('1','303','1','50',297,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','50',298,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','50',299,'5','1',11919.00,12019.00,0.00,0.00,100.00,69000.00,0.00,0.00,0.00),('1','303','1','50',300,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','51',301,'1','1',10465.14,10663.53,0.00,0.00,198.39,142840.80,0.00,0.00,0.00),('1','303','1','51',302,'2','1',5697.21,5819.86,0.00,0.00,122.65,88308.00,0.00,0.00,0.00),('1','303','1','51',303,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','51',304,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','51',305,'5','1',12019.00,12019.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','51',306,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','52',307,'1','1',10663.53,10906.97,0.00,0.00,243.44,175276.80,0.00,0.00,0.00),('1','303','1','52',308,'2','1',5819.86,5993.00,0.00,0.00,173.14,124660.80,0.00,0.00,0.00),('1','303','1','52',309,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','52',310,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','52',311,'5','1',12019.00,12269.00,0.00,0.00,250.00,172500.00,0.00,0.00,0.00),('1','303','1','52',312,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','53',313,'1','1',10906.97,11100.79,0.00,0.00,193.82,139550.40,0.00,0.00,0.00),('1','303','1','53',314,'2','1',5993.00,6156.70,0.00,0.00,163.70,117864.00,0.00,0.00,0.00),('1','303','1','53',315,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','53',316,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','53',317,'5','1',12269.00,13121.00,0.00,0.00,852.00,587880.00,0.00,0.00,0.00),('1','303','1','53',318,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','54',319,'1','1',11100.79,11302.43,0.00,0.00,201.64,145180.80,0.00,0.00,0.00),('1','303','1','54',320,'2','1',6156.70,6296.62,0.00,0.00,139.92,100742.40,0.00,0.00,0.00),('1','303','1','54',321,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','54',322,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','54',323,'5','1',13121.00,13471.00,0.00,0.00,350.00,241500.00,0.00,0.00,0.00),('1','303','1','54',324,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','55',325,'1','1',11302.43,11443.59,0.00,0.00,141.16,101635.20,0.00,0.00,0.00),('1','303','1','55',326,'2','1',6296.62,6512.67,0.00,0.00,216.05,155556.00,0.00,0.00,0.00),('1','303','1','55',327,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','55',328,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','55',329,'5','1',13471.00,13579.00,0.00,0.00,108.00,74520.00,0.00,0.00,0.00),('1','303','1','55',330,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','56',331,'1','1',11443.59,11586.26,0.00,0.00,142.67,102722.40,0.00,0.00,0.00),('1','303','1','56',332,'2','1',6512.67,6841.27,0.00,0.00,328.60,236592.00,0.00,0.00,0.00),('1','303','1','56',333,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','56',334,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','56',335,'5','1',13579.00,15287.00,0.00,0.00,1708.00,1178520.00,0.00,0.00,0.00),('1','303','1','56',336,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','57',337,'1','1',11586.26,11751.75,0.00,0.00,165.49,119152.80,0.00,0.00,0.00),('1','303','1','57',338,'2','1',6841.27,7085.03,0.00,0.00,243.76,175507.20,0.00,0.00,0.00),('1','303','1','57',339,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','57',340,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','57',341,'5','1',15287.00,16127.00,0.00,0.00,840.00,579600.00,0.00,0.00,0.00),('1','303','1','57',342,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','58',343,'1','1',11751.75,11968.92,0.00,0.00,217.17,156362.40,0.00,0.00,0.00),('1','303','1','58',344,'2','1',7085.03,7337.78,0.00,0.00,252.75,181980.00,0.00,0.00,0.00),('1','303','1','58',345,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','58',346,'4','1',2809.79,2809.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','58',347,'5','1',16127.00,17375.00,0.00,0.00,1248.00,861120.00,0.00,0.00,0.00),('1','303','1','58',348,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','59',349,'1','1',11968.92,12136.04,0.00,0.00,167.12,120326.40,0.00,0.00,0.00),('1','303','1','59',350,'2','1',7337.78,7532.98,0.00,0.00,195.20,140544.00,0.00,0.00,0.00),('1','303','1','59',351,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','59',352,'4','1',2809.79,2859.79,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','303','1','59',353,'5','1',17375.00,17783.00,0.00,0.00,408.00,281520.00,0.00,0.00,0.00),('1','303','1','59',354,'6','1',1092.02,1092.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','60',355,'1','1',12136.04,12393.12,0.00,0.00,257.08,185097.60,0.00,0.00,0.00),('1','303','1','60',356,'2','1',7532.98,7784.69,0.00,0.00,251.71,180481.20,0.00,0.00,0.00),('1','303','1','60',357,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','60',358,'4','1',2859.79,2859.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','60',359,'5','1',17783.00,18418.00,0.00,0.00,635.00,438150.00,0.00,0.00,0.00),('1','303','1','60',360,'6','1',1092.02,1142.02,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','303','1','61',361,'1','1',12393.12,12629.38,0.00,0.00,236.26,170107.20,0.00,0.00,0.00),('1','303','1','61',362,'2','1',7784.69,7944.44,0.00,0.00,159.75,115020.00,0.00,0.00,0.00),('1','303','1','61',363,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','61',364,'4','1',2859.79,2859.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','61',365,'5','1',18418.00,19653.00,0.00,0.00,1235.00,852150.00,0.00,0.00,0.00),('1','303','1','61',366,'6','1',1142.02,1292.02,0.00,0.00,150.00,103500.00,0.00,0.00,0.00),('1','303','1','62',367,'1','1',12629.38,12895.09,0.00,0.00,265.71,191311.20,0.00,0.00,0.00),('1','303','1','62',368,'2','1',7944.44,8175.91,0.00,0.00,231.47,166658.40,0.00,0.00,0.00),('1','303','1','62',369,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','62',370,'4','1',2859.79,2859.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','62',371,'5','1',19653.00,20056.00,0.00,0.00,403.00,278070.00,0.00,0.00,0.00),('1','303','1','62',372,'6','1',1292.02,1292.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','63',373,'1','1',12895.09,13197.11,0.00,0.00,302.02,217454.40,0.00,0.00,0.00),('1','303','1','63',374,'2','1',8175.91,8396.78,0.00,0.00,220.87,159026.40,0.00,0.00,0.00),('1','303','1','63',375,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','63',376,'4','1',2859.79,2859.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','63',377,'5','1',20056.00,21440.01,0.00,0.00,1384.01,954966.90,0.00,0.00,0.00),('1','303','1','63',378,'6','1',1292.02,1292.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','64',379,'1','1',13197.11,13197.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','64',380,'2','1',8396.78,8396.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','64',381,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','64',382,'4','1',2859.79,2859.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','64',383,'5','1',21440.01,21440.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','64',384,'6','1',1292.02,1292.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','65',385,'1','1',13197.11,13732.00,0.00,0.00,534.89,385120.80,0.00,0.00,0.00),('1','303','1','65',386,'2','1',8396.78,8758.53,0.00,0.00,361.75,260460.00,0.00,0.00,0.00),('1','303','1','65',387,'3','1',1650.00,1650.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','303','1','65',388,'4','1',2859.79,2860.95,0.00,0.00,1.16,800.40,0.00,0.00,0.00),('1','303','1','65',389,'5','1',21440.01,22650.01,0.00,0.00,1210.00,834900.00,0.00,0.00,0.00),('1','303','1','65',390,'6','1',1292.02,1347.02,0.00,0.00,55.00,37950.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','303','1','1',670.00,752.00,0.00,572.25,383407.50,411022.50,27615.00,1),('1','303','2','1',670.00,752.00,0.00,387.28,259477.60,278634.56,19156.96,2),('1','303','3','1',670.00,752.00,0.00,44.93,30103.10,33787.36,3684.26,3),('1','303','4','1',670.00,720.00,0.00,1461.51,979211.70,1017787.20,38575.50,4),('1','303','5','1',670.00,720.00,0.00,281.65,188705.50,202788.00,14082.50,5),('1','303','6','1',670.00,720.00,0.00,260.68,174655.60,187689.60,13034.00,6),('1','303','7','1',670.00,720.00,0.00,255.66,171292.20,184075.20,12783.00,7),('1','303','8','1',670.00,720.00,0.00,389.06,260670.20,280123.20,19453.00,8),('1','303','9','1',670.00,720.00,0.00,403.22,270157.40,290318.40,20161.00,9),('1','303','10','1',670.00,720.00,0.00,1440.38,965054.60,1004073.60,39019.00,10),('1','303','11','1',670.00,720.00,0.00,556.88,373109.60,394953.60,21844.00,11),('1','303','12','1',670.00,720.00,0.00,536.03,359140.10,385941.60,26801.50,12),('1','303','13','1',670.00,720.00,0.00,418.28,280247.60,301161.60,20914.00,13),('1','303','14','1',670.00,720.00,0.00,1562.14,1046633.80,1088739.60,42105.80,14),('1','303','15','1',670.00,720.00,0.00,521.81,349612.70,374203.20,24590.50,15),('1','303','16','1',670.00,720.00,0.00,550.34,368727.80,391744.80,23017.00,16),('1','303','17','1',670.00,720.00,0.00,567.17,380003.90,398162.40,18158.50,17),('1','303','18','1',670.00,720.00,0.00,584.01,391286.70,410400.30,19113.60,18),('1','303','19','1',670.00,720.00,0.00,1480.44,991894.80,1029916.80,38022.00,19),('1','303','20','1',670.00,720.00,0.00,1150.12,770580.40,802169.70,31589.30,20),('1','303','21','1',670.00,720.00,0.00,356.46,238828.20,253635.30,14807.10,21),('1','303','22','1',670.00,720.00,0.00,767.78,514412.60,541101.60,26689.00,22),('1','303','23','1',670.00,720.00,0.00,529.91,355039.70,377035.20,21995.50,23),('1','303','24','1',670.00,720.00,0.00,350.58,234888.60,252417.60,17529.00,24),('1','303','25','1',670.00,720.00,0.00,466.21,312360.70,331171.20,18810.50,25),('1','303','26','1',670.00,720.00,0.00,1367.66,916332.20,953215.20,36883.00,26),('1','303','27','1',670.00,720.00,0.00,675.21,452390.70,472141.80,19751.10,27),('1','303','28','1',670.00,720.00,0.00,708.41,474634.70,497815.20,23180.50,28),('1','303','29','1',670.00,720.00,0.00,1088.10,729027.00,762192.00,33165.00,29),('1','303','30','1',670.00,720.00,0.00,757.40,507458.00,533358.00,25900.00,30),('1','303','31','1',670.00,720.00,0.00,337.95,226426.50,240324.00,13897.50,31),('1','303','32','1',670.00,720.00,0.00,477.69,320052.30,337936.80,17884.50,32),('1','303','33','1',670.00,720.00,0.00,503.29,337204.30,357868.80,20664.50,33),('1','303','34','1',670.00,720.00,0.00,1046.33,701041.10,732357.60,31316.50,34),('1','303','35','1',670.00,720.00,0.00,371.54,248931.80,267508.80,18577.00,35),('1','303','36','1',670.00,720.00,0.00,403.08,270063.60,287217.60,17154.00,36),('1','303','37','1',670.00,720.00,0.00,381.44,255564.80,267230.10,11665.30,37),('1','303','38','1',670.00,720.00,0.00,0.00,0.00,0.00,0.00,38),('1','303','39','1',650.00,720.00,0.00,272.64,177216.00,191713.50,14497.50,39),('1','303','40','1',650.00,720.00,0.00,445.95,289867.50,318084.00,28216.50,40),('1','303','41','1',650.00,720.00,0.00,489.12,317928.00,347666.40,29738.40,41),('1','303','42','1',650.00,720.00,0.00,1752.63,1139209.50,1221228.60,82019.10,42),('1','303','43','1',650.00,720.00,0.00,1431.99,930793.50,1002292.80,71499.30,43),('1','303','44','1',650.00,720.00,0.00,120.26,78169.00,86347.20,8178.20,44),('1','303','45','1',650.00,720.00,0.00,1291.48,839462.00,908748.60,69286.60,45),('1','303','46','1',650.00,720.00,0.00,671.16,436254.00,478735.20,42481.20,46),('1','303','47','1',650.00,720.00,0.00,1746.50,1135225.00,1225284.30,90059.30,47),('1','303','48','1',650.00,720.00,0.00,508.22,330343.00,362918.40,32575.40,48),('1','303','49','1',650.00,720.00,0.00,472.37,307040.50,338606.40,31565.90,49),('1','303','50','1',650.00,720.00,0.00,517.96,336674.00,369931.20,33257.20,50),('1','303','51','1',650.00,720.00,0.00,321.04,208676.00,231148.80,22472.80,51),('1','303','52','1',650.00,720.00,0.00,666.58,433277.00,472437.60,39160.60,52),('1','303','53','1',650.00,720.00,0.00,1209.52,786188.00,845294.40,59106.40,53),('1','303','54','1',650.00,720.00,0.00,691.56,449514.00,487423.20,37909.20,54),('1','303','55','1',650.00,720.00,0.00,465.21,302386.50,331711.20,29324.70,55),('1','303','56','1',650.00,720.00,0.00,2179.27,1416525.50,1517834.40,101308.90,56),('1','303','57','1',650.00,720.00,0.00,1249.25,812012.50,874260.00,62247.50,57),('1','303','58','1',650.00,720.00,0.00,1717.92,1116648.00,1199462.40,82814.40,58),('1','303','59','1',650.00,720.00,0.00,820.32,533208.00,576890.40,43682.40,59),('1','303','60','1',650.00,720.00,0.00,1193.79,775963.50,838228.80,62265.30,60),('1','303','61','1',650.00,720.00,0.00,1781.01,1157656.50,1240777.20,83120.70,61),('1','303','62','1',650.00,720.00,0.00,900.18,585117.00,636039.60,50922.60,62),('1','303','63','1',650.00,720.00,0.00,1906.90,1239485.00,1331447.70,91962.70,63),('1','303','64','1',650.00,720.00,0.00,0.00,0.00,0.00,0.00,64),('1','303','65','1',640.00,720.00,0.00,2162.80,1384192.00,1519231.20,135039.20,65);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',1,'303','LPG PRODUCT.','LPG Tanks.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','303','1',1,1,'1','LPG TANK ',25000.00,0.00,NULL,'TANK CONTAINING LPG.','479','2022-11-28 13:48:59','2022-11-28 13:48:59','479',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','303',1,22837.20,'2023-03-20 19:27:38');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=4589 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'1','303',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,16723200.00,24960.00,0.00,0.00,'2023-01-14 15:46:12','',''),(2,'1','303',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,24960.00,0.00,'2023-01-14 15:49:36','',''),(3,'1','303','1',1,'Received from bridging 1',0.00,0.00,24960.00,0.00,0.00,'2023-01-14 15:49:36','',''),(4,'1','303','1',1,'Retail Sale Id 1',326422.50,0.00,0.00,459.75,18390.00,'2023-01-15 09:50:07','',''),(5,'1','303','1',1,'Retail Sale Id 2',2496.64,0.00,0.00,3.32,272.24,'2023-01-15 09:51:57','',''),(6,'1','303','1',1,'Retail Sale Id 3',4512.00,0.00,0.00,6.00,492.00,'2023-01-15 09:53:12','',''),(7,'1','303','1',1,'Retail Sale Id 5',1000.16,0.00,0.00,1.33,109.06,'2023-01-15 09:55:54','',''),(8,'1','303','1',1,'Retail Sale Id 5',1000.16,0.00,0.00,1.33,109.06,'2023-01-15 09:55:54','',''),(9,'1','303','1',1,'Retail Sale Id 6',2496.64,0.00,0.00,3.32,272.24,'2023-01-15 10:42:03','',''),(10,'1','303','1',1,'Retail Sale Id 7',1203.20,0.00,0.00,1.60,131.20,'2023-01-15 12:59:41','',''),(11,'1','303','1',1,'Retail Sale Id 8',2263.52,0.00,0.00,3.01,246.82,'2023-01-15 13:59:06','',''),(12,'1','303','1',1,'Retail Sale Id 9',3760.00,0.00,0.00,5.00,410.00,'2023-01-15 14:09:12','',''),(13,'1','303','1',1,'Retail Sale Id 9',9400.00,0.00,0.00,12.50,1025.00,'2023-01-15 14:09:12','',''),(14,'1','303','1',1,'Retail Sale Id 10',9497.76,0.00,0.00,12.63,1035.66,'2023-01-15 14:38:25','',''),(15,'1','303','1',1,'Retail Sale Id 13',2256.00,0.00,0.00,3.00,246.00,'2023-01-15 14:51:16','',''),(16,'1','303','1',1,'Retail Sale Id 13',4542.08,0.00,0.00,6.04,495.28,'2023-01-15 14:51:16','',''),(17,'1','303','1',1,'Retail Sale Id 14',4000.64,0.00,0.00,5.32,436.24,'2023-01-15 14:53:02','',''),(18,'1','303','1',1,'Retail Sale Id 15',4000.64,0.00,0.00,5.32,436.24,'2023-01-15 14:54:35','',''),(19,'1','303','1',1,'Retail Sale Id 17',4496.96,0.00,0.00,5.98,490.36,'2023-01-15 14:56:51','',''),(20,'1','303','1',1,'Retail Sale Id 18',9497.76,0.00,0.00,12.63,1035.66,'2023-01-15 15:06:25','',''),(21,'1','303','1',1,'Retail Sale Id 19',9196.96,0.00,0.00,12.23,1002.86,'2023-01-15 16:30:10','',''),(22,'1','303','1',1,'Retail Sale Id 20',4496.96,0.00,0.00,5.98,490.36,'2023-01-15 16:43:44','',''),(23,'1','303','1',1,'Retail Sale Id 21',1496.48,0.00,0.00,1.99,163.18,'2023-01-15 17:26:50','',''),(24,'1','303','1',1,'Retail Sale Id 22',2000.32,0.00,0.00,2.66,218.12,'2023-01-15 17:38:06','',''),(25,'1','303','1',1,'Retail Sale Id 23',1000.16,0.00,0.00,1.33,109.06,'2023-01-15 18:06:55','',''),(26,'1','303','1',1,'Return of Retail Sale Id 23',0.00,1000.16,1.33,0.00,-109.06,'2023-01-15 18:53:46','',''),(27,'1','303','1',1,'Retail Sale Id 24',985.12,0.00,0.00,1.31,107.42,'2023-01-15 18:54:41','',''),(28,'1','303','1',1,'Retail Sale Id 25',2301.12,0.00,0.00,3.06,250.92,'2023-01-16 08:01:52','',''),(29,'1','303','1',1,'Retail Sale Id 26',3000.48,0.00,0.00,3.99,327.18,'2023-01-16 09:41:53','',''),(30,'1','303','1',1,'Retail Sale Id 27',2248.48,0.00,0.00,2.99,245.18,'2023-01-16 10:13:48','',''),(31,'1','303','1',1,'Retail Sale Id 29',3752.48,0.00,0.00,4.99,409.18,'2023-01-16 10:26:36','',''),(32,'1','303','1',1,'Retail Sale Id 30',7520.00,0.00,0.00,10.00,820.00,'2023-01-16 11:14:40','',''),(33,'1','303','1',1,'Retail Sale Id 31',9400.00,0.00,0.00,12.50,1025.00,'2023-01-16 11:21:02','',''),(34,'1','303','1',1,'Retail Sale Id 32',4496.96,0.00,0.00,5.98,490.36,'2023-01-16 11:25:33','',''),(35,'1','303','1',1,'Retail Sale Id 33',213000.00,0.00,0.00,300.00,12000.00,'2023-01-16 11:27:31','',''),(36,'1','303','1',1,'Retail Sale Id 34',9400.00,0.00,0.00,12.50,1025.00,'2023-01-16 12:56:10','',''),(37,'1','303','1',1,'Retail Sale Id 35',752.00,0.00,0.00,1.00,82.00,'2023-01-16 12:57:36','',''),(38,'1','303','1',1,'Retail Sale Id 36',8678.08,0.00,0.00,11.54,946.28,'2023-01-16 12:59:56','',''),(39,'1','303','1',1,'Retail Sale Id 37',2301.12,0.00,0.00,3.06,250.92,'2023-01-16 13:03:45','',''),(40,'1','303','1',1,'Return of Retail Sale Id 36',0.00,8678.08,11.54,0.00,-946.28,'2023-01-16 13:06:17','',''),(41,'1','303','1',1,'Return of Retail Sale Id 35',0.00,752.00,1.00,0.00,-82.00,'2023-01-16 13:07:25','',''),(42,'1','303','1',1,'Retail Sale Id 38',9400.00,0.00,0.00,12.50,1025.00,'2023-01-16 13:08:23','',''),(43,'1','303','1',1,'Retail Sale Id 39',4512.00,0.00,0.00,6.00,492.00,'2023-01-16 13:49:14','',''),(44,'1','303','1',1,'Retail Sale Id 40',3053.12,0.00,0.00,4.06,332.92,'2023-01-16 16:15:02','',''),(45,'1','303','1',1,'Retail Sale Id 41',2301.12,0.00,0.00,3.06,250.92,'2023-01-16 16:19:43','',''),(46,'1','303','1',1,'Retail Sale Id 42',1947.68,0.00,0.00,2.59,212.38,'2023-01-16 19:01:48','',''),(47,'1','303','1',1,'Retail Sale Id 43',3000.48,0.00,0.00,3.99,327.18,'2023-01-17 09:17:43','',''),(48,'1','303','1',1,'Retail Sale Id 44',2248.48,0.00,0.00,2.99,245.18,'2023-01-17 09:31:45','',''),(49,'1','303','1',1,'Return of Retail Sale Id 43',0.00,3000.48,3.99,0.00,-327.18,'2023-01-17 10:44:11','',''),(50,'1','303','1',1,'Return of Retail Sale Id 44',0.00,2248.48,2.99,0.00,-245.18,'2023-01-17 10:46:41','',''),(51,'1','303','1',1,'Retail Sale Id 45',669.28,0.00,0.00,0.89,72.98,'2023-01-17 10:49:42','',''),(52,'1','303','1',1,'Retail Sale Id 46',4549.60,0.00,0.00,6.05,496.10,'2023-01-17 15:03:47','',''),(53,'1','303','1',1,'Retail Sale Id 47',4496.96,0.00,0.00,5.98,490.36,'2023-01-17 15:07:52','',''),(54,'1','303','1',1,'Retail Sale Id 48',2263.52,0.00,0.00,3.01,246.82,'2023-01-17 15:10:32','',''),(55,'1','303','1',1,'Retail Sale Id 49',9400.00,0.00,0.00,12.50,1025.00,'2023-01-17 16:03:48','',''),(56,'1','303','1',1,'Retail Sale Id 51',3760.00,0.00,0.00,5.00,410.00,'2023-01-17 16:25:35','',''),(57,'1','303','1',1,'Retail Sale Id 52',1496.48,0.00,0.00,1.99,163.18,'2023-01-17 17:24:57','',''),(58,'1','303','1',1,'Retail Sale Id 53',3760.00,0.00,0.00,5.00,410.00,'2023-01-17 17:53:50','',''),(59,'1','303','1',1,'Retail Sale Id 54',3782.56,0.00,0.00,5.03,412.46,'2023-01-17 18:16:32','',''),(60,'1','303','1',1,'Return of Retail Sale Id 52',0.00,1496.48,1.99,0.00,-163.18,'2023-01-17 18:40:22','',''),(61,'1','303','1',1,'Retail Sale Id 55',1105.44,0.00,0.00,1.47,120.54,'2023-01-17 18:41:42','',''),(62,'1','303','1',1,'Retail Sale Id 56',7200.00,0.00,0.00,10.00,500.00,'2023-01-18 09:09:24','',''),(63,'1','303','1',1,'Retail Sale Id 57',1000.80,0.00,0.00,1.39,69.50,'2023-01-18 09:20:47','',''),(64,'1','303','1',1,'Retail Sale Id 58',2001.60,0.00,0.00,2.78,139.00,'2023-01-18 12:21:11','',''),(65,'1','303','1',1,'Retail Sale Id 59',1497.60,0.00,0.00,2.08,104.00,'2023-01-18 12:22:46','',''),(66,'1','303','1',1,'Retail Sale Id 60',2160.00,0.00,0.00,3.00,150.00,'2023-01-18 12:24:24','',''),(67,'1','303','1',1,'Retail Sale Id 61',2160.00,0.00,0.00,3.00,150.00,'2023-01-18 12:32:07','',''),(68,'1','303','1',1,'Retail Sale Id 62',9000.00,0.00,0.00,12.50,625.00,'2023-01-18 12:52:29','',''),(69,'1','303','1',1,'Retail Sale Id 63',9000.00,0.00,0.00,12.50,625.00,'2023-01-18 13:00:07','',''),(70,'1','303','1',1,'Retail Sale Id 64',2160.00,0.00,0.00,3.00,150.00,'2023-01-18 13:02:08','',''),(71,'1','303','1',1,'Retail Sale Id 65',2160.00,0.00,0.00,3.00,150.00,'2023-01-18 13:09:53','',''),(72,'1','303','1',1,'Retail Sale Id 66',1497.60,0.00,0.00,2.08,104.00,'2023-01-18 13:13:00','',''),(73,'1','303','1',1,'Retail Sale Id 67',9000.00,0.00,0.00,12.50,625.00,'2023-01-18 13:17:25','',''),(74,'1','303','1',1,'Retail Sale Id 68',2160.00,0.00,0.00,3.00,150.00,'2023-01-18 13:18:59','',''),(75,'1','303','1',1,'Retail Sale Id 68',9000.00,0.00,0.00,12.50,625.00,'2023-01-18 13:18:59','',''),(76,'1','303','1',1,'Retail Sale Id 69',9000.00,0.00,0.00,12.50,625.00,'2023-01-18 13:21:17','',''),(77,'1','303','1',1,'Retail Sale Id 70',2160.00,0.00,0.00,3.00,150.00,'2023-01-18 13:26:10','',''),(78,'1','303','1',1,'Retail Sale Id 71',5997.60,0.00,0.00,8.33,416.50,'2023-01-18 13:27:39','',''),(79,'1','303','1',1,'Return of Retail Sale Id 69',0.00,9000.00,12.50,0.00,-625.00,'2023-01-18 13:28:22','',''),(80,'1','303','1',1,'Retail Sale Id 72',4500.00,0.00,0.00,6.25,312.50,'2023-01-18 13:33:31','',''),(81,'1','303','1',1,'Retail Sale Id 73',4320.00,0.00,0.00,6.00,300.00,'2023-01-18 13:46:25','',''),(82,'1','303','1',1,'Retail Sale Id 74',1317.60,0.00,0.00,1.83,91.50,'2023-01-18 13:56:55','',''),(83,'1','303','1',1,'Retail Sale Id 75',4320.00,0.00,0.00,6.00,300.00,'2023-01-18 13:59:53','',''),(84,'1','303','1',1,'Retail Sale Id 76',5040.00,0.00,0.00,7.00,350.00,'2023-01-18 14:01:28','',''),(85,'1','303','1',1,'Retail Sale Id 78',4320.00,0.00,0.00,6.00,300.00,'2023-01-18 14:05:54','',''),(86,'1','303','1',1,'Retail Sale Id 78',7200.00,0.00,0.00,10.00,500.00,'2023-01-18 14:05:54','',''),(87,'1','303','1',1,'Retail Sale Id 79',9000.00,0.00,0.00,12.50,625.00,'2023-01-18 14:08:36','',''),(88,'1','303','1',1,'Retail Sale Id 80',2160.00,0.00,0.00,3.00,150.00,'2023-01-18 14:13:34','',''),(89,'1','303','1',1,'Retail Sale Id 81',3196.80,0.00,0.00,4.44,222.00,'2023-01-18 14:17:15','',''),(90,'1','303','1',1,'Retail Sale Id 82',2160.00,0.00,0.00,3.00,150.00,'2023-01-18 14:29:20','',''),(91,'1','303','1',1,'Retail Sale Id 83',4298.40,0.00,0.00,5.97,298.50,'2023-01-18 14:35:47','',''),(92,'1','303','1',1,'Retail Sale Id 84',1000.80,0.00,0.00,1.39,69.50,'2023-01-18 14:39:35','',''),(93,'1','303','1',1,'Retail Sale Id 85',9000.00,0.00,0.00,12.50,625.00,'2023-01-18 14:49:44','',''),(94,'1','303','1',1,'Retail Sale Id 86',7200.00,0.00,0.00,10.00,500.00,'2023-01-18 14:55:50','',''),(95,'1','303','1',1,'Retail Sale Id 87',1202.40,0.00,0.00,1.67,83.50,'2023-01-18 14:59:35','',''),(96,'1','303','1',1,'Retail Sale Id 88',1202.40,0.00,0.00,1.67,83.50,'2023-01-18 15:00:29','',''),(97,'1','303','1',1,'Retail Sale Id 89',2160.00,0.00,0.00,3.00,150.00,'2023-01-18 15:04:10','',''),(98,'1','303','1',1,'Retail Sale Id 90',2160.00,0.00,0.00,3.00,150.00,'2023-01-18 15:23:25','',''),(99,'1','303','1',1,'Retail Sale Id 91',1440.00,0.00,0.00,2.00,100.00,'2023-01-18 15:26:32','',''),(100,'1','303','1',1,'Retail Sale Id 92',2160.00,0.00,0.00,3.00,150.00,'2023-01-18 15:40:43','',''),(101,'1','303','1',1,'Retail Sale Id 93',9000.00,0.00,0.00,12.50,625.00,'2023-01-18 15:44:30','',''),(102,'1','303','1',1,'Retail Sale Id 94',2160.00,0.00,0.00,3.00,150.00,'2023-01-18 15:49:09','',''),(103,'1','303','1',1,'Retail Sale Id 95',7200.00,0.00,0.00,10.00,500.00,'2023-01-18 15:55:08','',''),(104,'1','303','1',1,'Retail Sale Id 96',1497.60,0.00,0.00,2.08,104.00,'2023-01-18 16:21:38','',''),(105,'1','303','1',1,'Retail Sale Id 97',2203.20,0.00,0.00,3.06,153.00,'2023-01-18 16:23:28','',''),(106,'1','303','1',1,'Retail Sale Id 98',4298.40,0.00,0.00,5.97,298.50,'2023-01-18 16:32:06','',''),(107,'1','303','1',1,'Retail Sale Id 99',4320.00,0.00,0.00,6.00,300.00,'2023-01-18 16:49:08','',''),(108,'1','303','1',1,'Retail Sale Id 100',3600.00,0.00,0.00,5.00,250.00,'2023-01-18 16:51:51','',''),(109,'1','303','1',1,'Retail Sale Id 101',2001.60,0.00,0.00,2.78,139.00,'2023-01-18 16:58:50','',''),(110,'1','303','1',1,'Retail Sale Id 102',2203.20,0.00,0.00,3.06,153.00,'2023-01-18 17:17:30','',''),(111,'1','303','1',1,'Retail Sale Id 103',4996.80,0.00,0.00,6.94,347.00,'2023-01-18 17:18:42','',''),(112,'1','303','1',1,'Retail Sale Id 104',1483500.00,0.00,0.00,2150.00,43000.00,'2023-01-18 17:22:41','',''),(113,'1','303','1',1,'Return of Retail Sale Id 104',0.00,1483500.00,2150.00,0.00,-43000.00,'2023-01-18 17:24:44','',''),(114,'1','303','1',1,'Retail Sale Id 105',4348.80,0.00,0.00,6.04,302.00,'2023-01-18 17:29:32','',''),(115,'1','303','1',1,'Retail Sale Id 106',1000.80,0.00,0.00,1.39,69.50,'2023-01-18 17:34:34','',''),(116,'1','303','1',1,'Retail Sale Id 107',4003.20,0.00,0.00,5.56,278.00,'2023-01-18 17:37:09','',''),(117,'1','303','1',1,'Retail Sale Id 108',2160.00,0.00,0.00,3.00,150.00,'2023-01-18 17:47:33','',''),(118,'1','303','1',1,'Retail Sale Id 109',2160.00,0.00,0.00,3.00,150.00,'2023-01-18 18:02:12','',''),(119,'1','303','1',1,'Retail Sale Id 110',4298.40,0.00,0.00,5.97,298.50,'2023-01-18 18:04:49','',''),(120,'1','303','1',1,'Retail Sale Id 110',9000.00,0.00,0.00,12.50,625.00,'2023-01-18 18:04:49','',''),(121,'1','303','1',1,'Retail Sale Id 111',4320.00,0.00,0.00,6.00,300.00,'2023-01-18 18:06:39','',''),(122,'1','303','1',1,'Retail Sale Id 112',1352227.50,0.00,0.00,1959.75,39195.00,'2023-01-18 18:10:24','',''),(123,'1','303','1',1,'Return of Retail Sale Id 112',0.00,1352227.50,1959.75,0.00,-39195.00,'2023-01-18 18:17:35','',''),(124,'1','303','1',1,'Retail Sale Id 113',2001.60,0.00,0.00,2.78,139.00,'2023-01-18 18:19:41','',''),(125,'1','303','1',1,'Retail Sale Id 114',793500.00,0.00,0.00,1150.00,23000.00,'2023-01-18 18:22:01','',''),(126,'1','303','1',1,'Retail Sale Id 115',4500.00,0.00,0.00,6.25,312.50,'2023-01-19 08:55:06','',''),(127,'1','303','1',1,'Retail Sale Id 116',3600.00,0.00,0.00,5.00,250.00,'2023-01-19 09:00:52','',''),(128,'1','303','1',1,'Retail Sale Id 117',7200.00,0.00,0.00,10.00,500.00,'2023-01-19 09:21:27','',''),(129,'1','303','1',1,'Retail Sale Id 118',4320.00,0.00,0.00,6.00,300.00,'2023-01-19 10:03:18','',''),(130,'1','303','1',1,'Retail Sale Id 119',9000.00,0.00,0.00,12.50,625.00,'2023-01-19 10:16:37','',''),(131,'1','303','1',1,'Retail Sale Id 121',4327.20,0.00,0.00,6.01,300.50,'2023-01-19 10:29:30','',''),(132,'1','303','1',1,'Retail Sale Id 122',2160.00,0.00,0.00,3.00,150.00,'2023-01-19 10:30:39','',''),(133,'1','303','1',1,'Retail Sale Id 124',4348.80,0.00,0.00,6.04,302.00,'2023-01-19 10:47:08','',''),(134,'1','303','1',1,'Retail Sale Id 126',2203.20,0.00,0.00,3.06,153.00,'2023-01-19 10:54:30','',''),(135,'1','303','1',1,'Retail Sale Id 127',799.20,0.00,0.00,1.11,55.50,'2023-01-19 10:55:58','',''),(136,'1','303','1',1,'Retail Sale Id 128',4348.80,0.00,0.00,6.04,302.00,'2023-01-19 10:57:59','',''),(137,'1','303','1',1,'Retail Sale Id 129',4348.80,0.00,0.00,6.04,302.00,'2023-01-19 11:19:53','',''),(138,'1','303','1',1,'Retail Sale Id 130',7200.00,0.00,0.00,10.00,500.00,'2023-01-19 11:21:07','',''),(139,'1','303','1',1,'Retail Sale Id 131',4348.80,0.00,0.00,6.04,302.00,'2023-01-19 11:31:46','',''),(140,'1','303','1',1,'Retail Sale Id 132',4348.80,0.00,0.00,6.04,302.00,'2023-01-19 11:37:40','',''),(141,'1','303','1',1,'Retail Sale Id 133',7200.00,0.00,0.00,10.00,500.00,'2023-01-19 11:55:06','',''),(142,'1','303','1',1,'Retail Sale Id 134',2901.60,0.00,0.00,4.03,201.50,'2023-01-19 12:12:18','',''),(143,'1','303','1',1,'Retail Sale Id 135',9000.00,0.00,0.00,12.50,625.00,'2023-01-19 12:21:49','',''),(144,'1','303','1',1,'Retail Sale Id 136',9000.00,0.00,0.00,12.50,625.00,'2023-01-19 12:25:33','',''),(145,'1','303','1',1,'Retail Sale Id 137',9000.00,0.00,0.00,12.50,625.00,'2023-01-19 12:44:52','',''),(146,'1','303','1',1,'Retail Sale Id 139',4348.80,0.00,0.00,6.04,302.00,'2023-01-19 12:56:13','',''),(147,'1','303','1',1,'Retail Sale Id 140',2001.60,0.00,0.00,2.78,139.00,'2023-01-19 13:22:45','',''),(148,'1','303','1',1,'Retail Sale Id 141',2160.00,0.00,0.00,3.00,150.00,'2023-01-19 14:02:09','',''),(149,'1','303','1',1,'Retail Sale Id 141',2160.00,0.00,0.00,3.00,150.00,'2023-01-19 14:02:09','',''),(150,'1','303','1',1,'Retail Sale Id 142',2160.00,0.00,0.00,3.00,150.00,'2023-01-19 14:22:58','',''),(151,'1','303','1',1,'Retail Sale Id 143',2160.00,0.00,0.00,3.00,150.00,'2023-01-19 14:54:13','',''),(152,'1','303','1',1,'Retail Sale Id 143',4320.00,0.00,0.00,6.00,300.00,'2023-01-19 14:54:13','',''),(153,'1','303','1',1,'Retail Sale Id 144',1000.80,0.00,0.00,1.39,69.50,'2023-01-19 14:55:48','',''),(154,'1','303','1',1,'Retail Sale Id 145',4996.80,0.00,0.00,6.94,347.00,'2023-01-19 15:01:00','',''),(155,'1','303','1',1,'Retail Sale Id 146',9000.00,0.00,0.00,12.50,625.00,'2023-01-19 15:05:10','',''),(156,'1','303','1',1,'Retail Sale Id 147',2160.00,0.00,0.00,3.00,150.00,'2023-01-19 15:07:17','',''),(157,'1','303','1',1,'Retail Sale Id 148',3600.00,0.00,0.00,5.00,250.00,'2023-01-19 15:13:47','',''),(158,'1','303','1',1,'Retail Sale Id 149',2181.60,0.00,0.00,3.03,151.50,'2023-01-19 15:23:08','',''),(159,'1','303','1',1,'Retail Sale Id 150',2160.00,0.00,0.00,3.00,150.00,'2023-01-19 15:24:54','',''),(160,'1','303','1',1,'Retail Sale Id 152',4341.60,0.00,0.00,6.03,301.50,'2023-01-19 15:28:25','',''),(161,'1','303','1',1,'Retail Sale Id 153',2203.20,0.00,0.00,3.06,153.00,'2023-01-19 15:30:07','',''),(162,'1','303','1',1,'Retail Sale Id 154',1000.80,0.00,0.00,1.39,69.50,'2023-01-19 15:34:53','',''),(163,'1','303','1',1,'Retail Sale Id 155',4348.80,0.00,0.00,6.04,302.00,'2023-01-19 15:58:09','',''),(164,'1','303','1',1,'Retail Sale Id 156',2203.20,0.00,0.00,3.06,153.00,'2023-01-19 16:02:29','',''),(165,'1','303','1',1,'Retail Sale Id 157',7999.20,0.00,0.00,11.11,555.50,'2023-01-19 16:04:23','',''),(166,'1','303','1',1,'Retail Sale Id 158',3002.40,0.00,0.00,4.17,208.50,'2023-01-19 16:09:18','',''),(167,'1','303','1',1,'Retail Sale Id 159',9000.00,0.00,0.00,12.50,625.00,'2023-01-19 16:41:31','',''),(168,'1','303','1',1,'Retail Sale Id 160',4320.00,0.00,0.00,6.00,300.00,'2023-01-19 16:48:26','',''),(169,'1','303','1',1,'Retail Sale Id 161',799.20,0.00,0.00,1.11,55.50,'2023-01-19 16:53:28','',''),(170,'1','303','1',1,'Retail Sale Id 162',2160.00,0.00,0.00,3.00,150.00,'2023-01-19 17:24:26','',''),(171,'1','303','1',1,'Retail Sale Id 163',4320.00,0.00,0.00,6.00,300.00,'2023-01-19 17:31:11','',''),(172,'1','303','1',1,'Retail Sale Id 164',9000.00,0.00,0.00,12.50,625.00,'2023-01-19 17:50:10','',''),(173,'1','303','1',1,'Return of Retail Sale Id 162',0.00,2160.00,3.00,0.00,-150.00,'2023-01-19 18:05:57','',''),(174,'1','303','1',1,'Retail Sale Id 165',1159.20,0.00,0.00,1.61,80.50,'2023-01-19 18:07:51','',''),(175,'1','303','1',1,'Retail Sale Id 166',525.60,0.00,0.00,0.73,36.50,'2023-01-19 18:29:49','',''),(176,'1','303','1',1,'Retail Sale Id 167',4298.40,0.00,0.00,5.97,298.50,'2023-01-20 08:16:30','',''),(177,'1','303','1',1,'Retail Sale Id 168',9000.00,0.00,0.00,12.50,625.00,'2023-01-20 08:39:25','',''),(178,'1','303','1',1,'Retail Sale Id 169',432.00,0.00,0.00,0.60,30.00,'2023-01-20 08:56:38','',''),(179,'1','303','1',1,'Retail Sale Id 170',4348.80,0.00,0.00,6.04,302.00,'2023-01-20 08:58:43','',''),(180,'1','303','1',1,'Retail Sale Id 171',1000.80,0.00,0.00,1.39,69.50,'2023-01-20 09:02:18','',''),(181,'1','303','1',1,'Retail Sale Id 172',4320.00,0.00,0.00,6.00,300.00,'2023-01-20 09:15:03','',''),(182,'1','303','1',1,'Retail Sale Id 173',4320.00,0.00,0.00,6.00,300.00,'2023-01-20 10:07:28','',''),(183,'1','303','1',1,'Return of Retail Sale Id 169',0.00,432.00,0.60,0.00,-30.00,'2023-01-20 10:12:36','',''),(184,'1','303','1',1,'Retail Sale Id 174',4320.00,0.00,0.00,6.00,300.00,'2023-01-20 10:22:43','',''),(185,'1','303','1',1,'Retail Sale Id 175',4320.00,0.00,0.00,6.00,300.00,'2023-01-20 10:33:21','',''),(186,'1','303','1',1,'Retail Sale Id 176',3600.00,0.00,0.00,5.00,250.00,'2023-01-20 10:38:05','',''),(187,'1','303','1',1,'Retail Sale Id 178',3600.00,0.00,0.00,5.00,250.00,'2023-01-20 11:06:03','',''),(188,'1','303','1',1,'Retail Sale Id 178',3600.00,0.00,0.00,5.00,250.00,'2023-01-20 11:06:03','',''),(189,'1','303','1',1,'Retail Sale Id 179',7920.00,0.00,0.00,11.00,550.00,'2023-01-20 11:08:18','',''),(190,'1','303','1',1,'Retail Sale Id 180',2880.00,0.00,0.00,4.00,200.00,'2023-01-20 11:32:03','',''),(191,'1','303','1',1,'Retail Sale Id 180',5760.00,0.00,0.00,8.00,400.00,'2023-01-20 11:32:03','',''),(192,'1','303','1',1,'Retail Sale Id 181',2160.00,0.00,0.00,3.00,150.00,'2023-01-20 11:34:30','',''),(193,'1','303','1',1,'Retail Sale Id 182',3600.00,0.00,0.00,5.00,250.00,'2023-01-20 11:35:57','',''),(194,'1','303','1',1,'Retail Sale Id 183',2203.20,0.00,0.00,3.06,153.00,'2023-01-20 11:37:18','',''),(195,'1','303','1',1,'Retail Sale Id 184',1497.60,0.00,0.00,2.08,104.00,'2023-01-20 11:43:40','',''),(196,'1','303','1',1,'Retail Sale Id 185',4320.00,0.00,0.00,6.00,300.00,'2023-01-20 11:46:44','',''),(197,'1','303','1',1,'Retail Sale Id 186',4320.00,0.00,0.00,6.00,300.00,'2023-01-20 11:49:05','',''),(198,'1','303','1',1,'Retail Sale Id 187',4348.80,0.00,0.00,6.04,302.00,'2023-01-20 12:28:21','',''),(199,'1','303','1',1,'Retail Sale Id 188',1497.60,0.00,0.00,2.08,104.00,'2023-01-20 13:33:33','',''),(200,'1','303','1',1,'Retail Sale Id 189',4320.00,0.00,0.00,6.00,300.00,'2023-01-20 14:23:38','',''),(201,'1','303','1',1,'Retail Sale Id 190',9000.00,0.00,0.00,12.50,625.00,'2023-01-20 14:48:11','',''),(202,'1','303','1',1,'Retail Sale Id 191',1497.60,0.00,0.00,2.08,104.00,'2023-01-20 15:07:54','',''),(203,'1','303','1',1,'Retail Sale Id 192',1497.60,0.00,0.00,2.08,104.00,'2023-01-20 15:12:46','',''),(204,'1','303','1',1,'Retail Sale Id 193',1497.60,0.00,0.00,2.08,104.00,'2023-01-20 15:14:14','',''),(205,'1','303','1',1,'Retail Sale Id 194',4348.80,0.00,0.00,6.04,302.00,'2023-01-20 15:15:37','',''),(206,'1','303','1',1,'Retail Sale Id 195',3600.00,0.00,0.00,5.00,250.00,'2023-01-20 15:17:58','',''),(207,'1','303','1',1,'Retail Sale Id 196',4320.00,0.00,0.00,6.00,300.00,'2023-01-20 15:29:17','',''),(208,'1','303','1',1,'Retail Sale Id 197',4348.80,0.00,0.00,6.04,302.00,'2023-01-20 15:32:34','',''),(209,'1','303','1',1,'Retail Sale Id 198',1497.60,0.00,0.00,2.08,104.00,'2023-01-20 15:35:00','',''),(210,'1','303','1',1,'Retail Sale Id 199',2203.20,0.00,0.00,3.06,153.00,'2023-01-20 15:45:30','',''),(211,'1','303','1',1,'Retail Sale Id 200',4320.00,0.00,0.00,6.00,300.00,'2023-01-20 16:14:33','',''),(212,'1','303','1',1,'Retail Sale Id 201',1000.80,0.00,0.00,1.39,69.50,'2023-01-20 16:17:10','',''),(213,'1','303','1',1,'Retail Sale Id 202',4500.00,0.00,0.00,6.25,312.50,'2023-01-20 16:19:44','',''),(214,'1','303','1',1,'Retail Sale Id 203',4320.00,0.00,0.00,6.00,300.00,'2023-01-20 16:38:32','',''),(215,'1','303','1',1,'Retail Sale Id 204',2160.00,0.00,0.00,3.00,150.00,'2023-01-20 16:41:38','',''),(216,'1','303','1',1,'Retail Sale Id 204',4320.00,0.00,0.00,6.00,300.00,'2023-01-20 16:41:38','',''),(217,'1','303','1',1,'Retail Sale Id 205',9000.00,0.00,0.00,12.50,625.00,'2023-01-20 16:43:52','',''),(218,'1','303','1',1,'Retail Sale Id 206',3002.40,0.00,0.00,4.17,208.50,'2023-01-20 16:45:45','',''),(219,'1','303','1',1,'Retail Sale Id 207',2296.80,0.00,0.00,3.19,159.50,'2023-01-20 16:47:51','',''),(220,'1','303','1',1,'Retail Sale Id 208',4348.80,0.00,0.00,6.04,302.00,'2023-01-20 16:55:35','',''),(221,'1','303','1',1,'Retail Sale Id 209',2160.00,0.00,0.00,3.00,150.00,'2023-01-20 16:59:35','',''),(222,'1','303','1',1,'Retail Sale Id 210',2160.00,0.00,0.00,3.00,150.00,'2023-01-20 17:08:21','',''),(223,'1','303','1',1,'Retail Sale Id 211',4320.00,0.00,0.00,6.00,300.00,'2023-01-20 17:17:24','',''),(224,'1','303','1',1,'Retail Sale Id 211',9000.00,0.00,0.00,12.50,625.00,'2023-01-20 17:17:24','',''),(225,'1','303','1',1,'Retail Sale Id 212',2160.00,0.00,0.00,3.00,150.00,'2023-01-20 17:19:57','',''),(226,'1','303','1',1,'Retail Sale Id 213',2160.00,0.00,0.00,3.00,150.00,'2023-01-20 17:25:02','',''),(227,'1','303','1',1,'Retail Sale Id 214',2160.00,0.00,0.00,3.00,150.00,'2023-01-20 17:30:04','',''),(228,'1','303','1',1,'Retail Sale Id 215',2203.20,0.00,0.00,3.06,153.00,'2023-01-20 17:56:35','',''),(229,'1','303','1',1,'Return of Retail Sale Id 208',0.00,4348.80,6.04,0.00,-302.00,'2023-01-20 18:13:37','',''),(230,'1','303','1',1,'Retail Sale Id 216',1080.00,0.00,0.00,1.50,75.00,'2023-01-20 18:15:40','',''),(231,'1','303','1',1,'Retail Sale Id 217',2203.20,0.00,0.00,3.06,153.00,'2023-01-21 08:17:32','',''),(232,'1','303','1',1,'Retail Sale Id 218',1800.00,0.00,0.00,2.50,125.00,'2023-01-21 08:37:22','',''),(233,'1','303','1',1,'Retail Sale Id 219',2203.20,0.00,0.00,3.06,153.00,'2023-01-21 08:56:43','',''),(234,'1','303','1',1,'Retail Sale Id 220',2203.20,0.00,0.00,3.06,153.00,'2023-01-21 09:41:06','',''),(235,'1','303','1',1,'Retail Sale Id 221',7300.80,0.00,0.00,10.14,507.00,'2023-01-21 09:48:27','',''),(236,'1','303','1',1,'Retail Sale Id 222',4320.00,0.00,0.00,6.00,300.00,'2023-01-21 10:04:55','',''),(237,'1','303','1',1,'Retail Sale Id 223',3600.00,0.00,0.00,5.00,250.00,'2023-01-21 10:07:28','',''),(238,'1','303','1',1,'Retail Sale Id 224',3002.40,0.00,0.00,4.17,208.50,'2023-01-21 10:09:12','',''),(239,'1','303','1',1,'Retail Sale Id 225',2160.00,0.00,0.00,3.00,150.00,'2023-01-21 10:11:09','',''),(240,'1','303','1',1,'Retail Sale Id 226',4320.00,0.00,0.00,6.00,300.00,'2023-01-21 10:38:49','',''),(241,'1','303','1',1,'Retail Sale Id 227',7999.20,0.00,0.00,11.11,555.50,'2023-01-21 10:40:45','',''),(242,'1','303','1',1,'Retail Sale Id 228',1447.20,0.00,0.00,2.01,100.50,'2023-01-21 10:45:24','',''),(243,'1','303','1',1,'Retail Sale Id 229',2160.00,0.00,0.00,3.00,150.00,'2023-01-21 10:48:04','',''),(244,'1','303','1',1,'Retail Sale Id 230',4348.80,0.00,0.00,6.04,302.00,'2023-01-21 10:57:03','',''),(245,'1','303','1',1,'Retail Sale Id 231',2203.20,0.00,0.00,3.06,153.00,'2023-01-21 11:05:53','',''),(246,'1','303','1',1,'Retail Sale Id 232',2203.20,0.00,0.00,3.06,153.00,'2023-01-21 11:07:50','',''),(247,'1','303','1',1,'Retail Sale Id 233',3002.40,0.00,0.00,4.17,208.50,'2023-01-21 11:15:12','',''),(248,'1','303','1',1,'Retail Sale Id 234',4348.80,0.00,0.00,6.04,302.00,'2023-01-21 11:17:47','',''),(249,'1','303','1',1,'Retail Sale Id 235',2296.80,0.00,0.00,3.19,159.50,'2023-01-21 11:24:45','',''),(250,'1','303','1',1,'Retail Sale Id 236',2160.00,0.00,0.00,3.00,150.00,'2023-01-21 11:27:05','',''),(251,'1','303','1',1,'Retail Sale Id 237',2160.00,0.00,0.00,3.00,150.00,'2023-01-21 11:33:33','',''),(252,'1','303','1',1,'Retail Sale Id 237',3600.00,0.00,0.00,5.00,250.00,'2023-01-21 11:33:33','',''),(253,'1','303','1',1,'Retail Sale Id 238',2203.20,0.00,0.00,3.06,153.00,'2023-01-21 11:51:03','',''),(254,'1','303','1',1,'Retail Sale Id 239',4348.80,0.00,0.00,6.04,302.00,'2023-01-21 11:59:07','',''),(255,'1','303','1',1,'Retail Sale Id 240',2203.20,0.00,0.00,3.06,153.00,'2023-01-21 12:10:49','',''),(256,'1','303','1',1,'Retail Sale Id 241',2901.60,0.00,0.00,4.03,201.50,'2023-01-21 12:19:23','',''),(257,'1','303','1',1,'Retail Sale Id 242',9000.00,0.00,0.00,12.50,625.00,'2023-01-21 12:29:27','',''),(258,'1','303','1',1,'Retail Sale Id 243',3600.00,0.00,0.00,5.00,250.00,'2023-01-21 13:13:33','',''),(259,'1','303','1',1,'Retail Sale Id 244',3002.40,0.00,0.00,4.17,208.50,'2023-01-21 13:52:30','',''),(260,'1','303','1',1,'Retail Sale Id 245',2001.60,0.00,0.00,2.78,139.00,'2023-01-21 14:30:11','',''),(261,'1','303','1',1,'Retail Sale Id 246',3600.00,0.00,0.00,5.00,250.00,'2023-01-21 14:40:06','',''),(262,'1','303','1',1,'Retail Sale Id 247',1447.20,0.00,0.00,2.01,100.50,'2023-01-21 14:46:57','',''),(263,'1','303','1',1,'Retail Sale Id 248',2203.20,0.00,0.00,3.06,153.00,'2023-01-21 14:53:48','',''),(264,'1','303','1',1,'Retail Sale Id 249',9000.00,0.00,0.00,12.50,625.00,'2023-01-21 14:57:55','',''),(265,'1','303','1',1,'Retail Sale Id 250',4348.80,0.00,0.00,6.04,302.00,'2023-01-21 15:10:58','',''),(266,'1','303','1',1,'Retail Sale Id 251',4500.00,0.00,0.00,6.25,312.50,'2023-01-21 15:23:30','',''),(267,'1','303','1',1,'Retail Sale Id 252',4320.00,0.00,0.00,6.00,300.00,'2023-01-21 15:27:14','',''),(268,'1','303','1',1,'Retail Sale Id 253',3600.00,0.00,0.00,5.00,250.00,'2023-01-21 15:37:03','',''),(269,'1','303','1',1,'Retail Sale Id 254',3600.00,0.00,0.00,5.00,250.00,'2023-01-21 15:39:45','',''),(270,'1','303','1',1,'Retail Sale Id 255',2203.20,0.00,0.00,3.06,153.00,'2023-01-21 15:42:07','',''),(271,'1','303','1',1,'Retail Sale Id 256',2203.20,0.00,0.00,3.06,153.00,'2023-01-21 16:24:06','',''),(272,'1','303','1',1,'Retail Sale Id 257',720.00,0.00,0.00,1.00,50.00,'2023-01-21 16:26:30','',''),(273,'1','303','1',1,'Retail Sale Id 258',4320.00,0.00,0.00,6.00,300.00,'2023-01-21 16:29:17','',''),(274,'1','303','1',1,'Retail Sale Id 259',2880.00,0.00,0.00,4.00,200.00,'2023-01-21 16:30:43','',''),(275,'1','303','1',1,'Retail Sale Id 260',2203.20,0.00,0.00,3.06,153.00,'2023-01-21 16:35:33','',''),(276,'1','303','1',1,'Retail Sale Id 261',4298.40,0.00,0.00,5.97,298.50,'2023-01-21 16:38:14','',''),(277,'1','303','1',1,'Retail Sale Id 262',2160.00,0.00,0.00,3.00,150.00,'2023-01-21 16:42:38','',''),(278,'1','303','1',1,'Retail Sale Id 263',4348.80,0.00,0.00,6.04,302.00,'2023-01-21 16:53:12','',''),(279,'1','303','1',1,'Retail Sale Id 264',4320.00,0.00,0.00,6.00,300.00,'2023-01-21 17:02:11','',''),(280,'1','303','1',1,'Retail Sale Id 265',1000.80,0.00,0.00,1.39,69.50,'2023-01-21 17:04:21','',''),(281,'1','303','1',1,'Retail Sale Id 267',2203.20,0.00,0.00,3.06,153.00,'2023-01-21 17:07:15','',''),(282,'1','303','1',1,'Retail Sale Id 268',2160.00,0.00,0.00,3.00,150.00,'2023-01-21 17:33:36','',''),(283,'1','303','1',1,'Retail Sale Id 269',2880.00,0.00,0.00,4.00,200.00,'2023-01-21 17:41:09','',''),(284,'1','303','1',1,'Retail Sale Id 270',1447.20,0.00,0.00,2.01,100.50,'2023-01-21 17:49:03','',''),(285,'1','303','1',1,'Retail Sale Id 271',4500.00,0.00,0.00,6.25,312.50,'2023-01-21 18:03:30','',''),(286,'1','303','1',1,'Retail Sale Id 272',2203.20,0.00,0.00,3.06,153.00,'2023-01-21 18:05:26','',''),(287,'1','303','1',1,'Retail Sale Id 273',4348.80,0.00,0.00,6.04,302.00,'2023-01-21 18:07:04','',''),(288,'1','303','1',1,'Retail Sale Id 274',1396.80,0.00,0.00,1.94,97.00,'2023-01-21 18:12:28','',''),(289,'1','303','1',1,'Return of Retail Sale Id 264',0.00,4320.00,6.00,0.00,-300.00,'2023-01-21 18:46:14','',''),(290,'1','303','1',1,'Retail Sale Id 275',1072.80,0.00,0.00,1.49,74.50,'2023-01-21 18:49:00','',''),(291,'1','303','1',1,'Return of Retail Sale Id 274',0.00,1396.80,1.94,0.00,-97.00,'2023-01-21 18:50:27','',''),(292,'1','303','1',1,'Retail Sale Id 276',9000.00,0.00,0.00,12.50,625.00,'2023-01-22 08:47:56','',''),(293,'1','303','1',1,'Retail Sale Id 277',9000.00,0.00,0.00,12.50,625.00,'2023-01-22 08:53:10','',''),(294,'1','303','1',1,'Retail Sale Id 279',2203.20,0.00,0.00,3.06,153.00,'2023-01-22 08:56:14','',''),(295,'1','303','1',1,'Retail Sale Id 281',4320.00,0.00,0.00,6.00,300.00,'2023-01-22 09:00:47','',''),(296,'1','303','1',1,'Retail Sale Id 282',2001.60,0.00,0.00,2.78,139.00,'2023-01-22 09:06:35','',''),(297,'1','303','1',1,'Retail Sale Id 283',4500.00,0.00,0.00,6.25,312.50,'2023-01-22 09:26:47','',''),(298,'1','303','1',1,'Retail Sale Id 284',2203.20,0.00,0.00,3.06,153.00,'2023-01-22 09:43:32','',''),(299,'1','303','1',1,'Retail Sale Id 285',2203.20,0.00,0.00,3.06,153.00,'2023-01-22 09:48:55','',''),(300,'1','303','1',1,'Retail Sale Id 286',9000.00,0.00,0.00,12.50,625.00,'2023-01-22 09:53:02','',''),(301,'1','303','1',1,'Retail Sale Id 287',4348.80,0.00,0.00,6.04,302.00,'2023-01-22 10:00:57','',''),(302,'1','303','1',1,'Retail Sale Id 288',2203.20,0.00,0.00,3.06,153.00,'2023-01-22 10:18:59','',''),(303,'1','303','1',1,'Retail Sale Id 289',3600.00,0.00,0.00,5.00,250.00,'2023-01-22 10:43:07','',''),(304,'1','303','1',1,'Retail Sale Id 290',4298.40,0.00,0.00,5.97,298.50,'2023-01-22 10:44:30','',''),(305,'1','303','1',1,'Retail Sale Id 291',9000.00,0.00,0.00,12.50,625.00,'2023-01-22 10:50:11','',''),(306,'1','303','1',1,'Retail Sale Id 292',2203.20,0.00,0.00,3.06,153.00,'2023-01-22 10:55:06','',''),(307,'1','303','1',1,'Retail Sale Id 293',9000.00,0.00,0.00,12.50,625.00,'2023-01-22 10:57:19','',''),(308,'1','303','1',1,'Retail Sale Id 294',1000.80,0.00,0.00,1.39,69.50,'2023-01-22 11:13:16','',''),(309,'1','303','1',1,'Retail Sale Id 295',7999.20,0.00,0.00,11.11,555.50,'2023-01-22 11:21:12','',''),(310,'1','303','1',1,'Retail Sale Id 296',4500.00,0.00,0.00,6.25,312.50,'2023-01-22 11:27:24','',''),(311,'1','303','1',1,'Retail Sale Id 297',4399.20,0.00,0.00,6.11,305.50,'2023-01-22 11:29:29','',''),(312,'1','303','1',1,'Retail Sale Id 298',2203.20,0.00,0.00,3.06,153.00,'2023-01-22 11:31:52','',''),(313,'1','303','1',1,'Retail Sale Id 299',4320.00,0.00,0.00,6.00,300.00,'2023-01-22 11:33:43','',''),(314,'1','303','1',1,'Retail Sale Id 300',2203.20,0.00,0.00,3.06,153.00,'2023-01-22 11:35:45','',''),(315,'1','303','1',1,'Retail Sale Id 301',4298.40,0.00,0.00,5.97,298.50,'2023-01-22 11:47:00','',''),(316,'1','303','1',1,'Retail Sale Id 302',9000.00,0.00,0.00,12.50,625.00,'2023-01-22 12:12:32','',''),(317,'1','303','1',1,'Retail Sale Id 303',3600.00,0.00,0.00,5.00,250.00,'2023-01-22 12:13:56','',''),(318,'1','303','1',1,'Retail Sale Id 304',3600.00,0.00,0.00,5.00,250.00,'2023-01-22 12:16:29','',''),(319,'1','303','1',1,'Retail Sale Id 305',9000.00,0.00,0.00,12.50,625.00,'2023-01-22 12:19:47','',''),(320,'1','303','1',1,'Retail Sale Id 306',4320.00,0.00,0.00,6.00,300.00,'2023-01-22 12:25:52','',''),(321,'1','303','1',1,'Retail Sale Id 307',9000.00,0.00,0.00,12.50,625.00,'2023-01-22 12:31:00','',''),(322,'1','303','1',1,'Retail Sale Id 308',2296.80,0.00,0.00,3.19,159.50,'2023-01-22 12:32:01','',''),(323,'1','303','1',1,'Retail Sale Id 309',2001.60,0.00,0.00,2.78,139.00,'2023-01-22 12:34:17','',''),(324,'1','303','1',1,'Retail Sale Id 310',1440.00,0.00,0.00,2.00,100.00,'2023-01-22 12:36:00','',''),(325,'1','303','1',1,'Retail Sale Id 311',3600.00,0.00,0.00,5.00,250.00,'2023-01-22 12:37:20','',''),(326,'1','303','1',1,'Retail Sale Id 312',2102.40,0.00,0.00,2.92,146.00,'2023-01-22 12:39:23','',''),(327,'1','303','1',1,'Retail Sale Id 313',2160.00,0.00,0.00,3.00,150.00,'2023-01-22 12:48:34','',''),(328,'1','303','1',1,'Retail Sale Id 314',7200.00,0.00,0.00,10.00,500.00,'2023-01-22 13:02:07','',''),(329,'1','303','1',1,'Retail Sale Id 315',9000.00,0.00,0.00,12.50,625.00,'2023-01-22 13:03:18','',''),(330,'1','303','1',1,'Retail Sale Id 316',2001.60,0.00,0.00,2.78,139.00,'2023-01-22 13:05:57','',''),(331,'1','303','1',1,'Retail Sale Id 317',1000.80,0.00,0.00,1.39,69.50,'2023-01-22 13:21:01','',''),(332,'1','303','1',1,'Retail Sale Id 318',3499.20,0.00,0.00,4.86,243.00,'2023-01-22 13:25:43','',''),(333,'1','303','1',1,'Retail Sale Id 319',1440.00,0.00,0.00,2.00,100.00,'2023-01-22 13:28:15','',''),(334,'1','303','1',1,'Retail Sale Id 320',2203.20,0.00,0.00,3.06,153.00,'2023-01-22 13:33:38','',''),(335,'1','303','1',1,'Retail Sale Id 322',4348.80,0.00,0.00,6.04,302.00,'2023-01-22 14:17:50','',''),(336,'1','303','1',1,'Retail Sale Id 323',3600.00,0.00,0.00,5.00,250.00,'2023-01-22 14:21:28','',''),(337,'1','303','1',1,'Retail Sale Id 324',9000.00,0.00,0.00,12.50,625.00,'2023-01-22 14:38:35','',''),(338,'1','303','1',1,'Retail Sale Id 326',4348.80,0.00,0.00,6.04,302.00,'2023-01-22 14:45:01','',''),(339,'1','303','1',1,'Retail Sale Id 327',2203.20,0.00,0.00,3.06,153.00,'2023-01-22 14:49:40','',''),(340,'1','303','1',1,'Retail Sale Id 328',7999.20,0.00,0.00,11.11,555.50,'2023-01-22 14:51:06','',''),(341,'1','303','1',1,'Retail Sale Id 329',2203.20,0.00,0.00,3.06,153.00,'2023-01-22 14:58:04','',''),(342,'1','303','1',1,'Retail Sale Id 330',1497.60,0.00,0.00,2.08,104.00,'2023-01-22 15:18:21','',''),(343,'1','303','1',1,'Retail Sale Id 331',4003.20,0.00,0.00,5.56,278.00,'2023-01-22 15:22:10','',''),(344,'1','303','1',1,'Retail Sale Id 332',2001.60,0.00,0.00,2.78,139.00,'2023-01-22 15:46:36','',''),(345,'1','303','1',1,'Retail Sale Id 333',7898.40,0.00,0.00,10.97,548.50,'2023-01-22 16:00:25','',''),(346,'1','303','1',1,'Retail Sale Id 334',9000.00,0.00,0.00,12.50,625.00,'2023-01-22 16:22:18','',''),(347,'1','303','1',1,'Retail Sale Id 335',2880.00,0.00,0.00,4.00,200.00,'2023-01-22 16:25:13','',''),(348,'1','303','1',1,'Retail Sale Id 336',4320.00,0.00,0.00,6.00,300.00,'2023-01-22 16:31:40','',''),(349,'1','303','1',1,'Retail Sale Id 337',1497.60,0.00,0.00,2.08,104.00,'2023-01-22 16:40:20','',''),(350,'1','303','1',1,'Retail Sale Id 338',2203.20,0.00,0.00,3.06,153.00,'2023-01-22 16:59:19','',''),(351,'1','303','1',1,'Retail Sale Id 339',4320.00,0.00,0.00,6.00,300.00,'2023-01-22 17:02:35','',''),(352,'1','303','1',1,'Retail Sale Id 340',2203.20,0.00,0.00,3.06,153.00,'2023-01-22 17:16:44','',''),(353,'1','303','1',1,'Retail Sale Id 341',2203.20,0.00,0.00,3.06,153.00,'2023-01-22 17:30:46','',''),(354,'1','303','1',1,'Retail Sale Id 342',1447.20,0.00,0.00,2.01,100.50,'2023-01-22 17:34:48','',''),(355,'1','303','1',1,'Retail Sale Id 343',2203.20,0.00,0.00,3.06,153.00,'2023-01-22 17:39:18','',''),(356,'1','303','1',1,'Return of Retail Sale Id 342',0.00,1447.20,2.01,0.00,-100.50,'2023-01-22 17:44:02','',''),(357,'1','303','1',1,'Retail Sale Id 345',2160.00,0.00,0.00,3.00,150.00,'2023-01-22 17:57:34','',''),(358,'1','303','1',1,'Retail Sale Id 345',2160.00,0.00,0.00,3.00,150.00,'2023-01-22 17:57:34','',''),(359,'1','303','1',1,'Retail Sale Id 347',2901.60,0.00,0.00,4.03,201.50,'2023-01-22 18:00:05','',''),(360,'1','303','1',1,'Retail Sale Id 348',3600.00,0.00,0.00,5.00,250.00,'2023-01-22 18:01:45','',''),(361,'1','303','1',1,'Retail Sale Id 349',799.20,0.00,0.00,1.11,55.50,'2023-01-22 18:03:18','',''),(362,'1','303','1',1,'Retail Sale Id 350',93.60,0.00,0.00,0.13,6.50,'2023-01-22 18:33:12','',''),(363,'1','303','1',1,'Retail Sale Id 351',4298.40,0.00,0.00,5.97,298.50,'2023-01-23 09:03:55','',''),(364,'1','303','1',1,'Retail Sale Id 352',4298.40,0.00,0.00,5.97,298.50,'2023-01-23 09:05:32','',''),(365,'1','303','1',1,'Retail Sale Id 353',4320.00,0.00,0.00,6.00,300.00,'2023-01-23 09:23:00','',''),(366,'1','303','1',1,'Retail Sale Id 354',4298.40,0.00,0.00,5.97,298.50,'2023-01-23 09:40:08','',''),(367,'1','303','1',1,'Retail Sale Id 355',2880.00,0.00,0.00,4.00,200.00,'2023-01-23 09:46:48','',''),(368,'1','303','1',1,'Retail Sale Id 356',3002.40,0.00,0.00,4.17,208.50,'2023-01-23 09:48:44','',''),(369,'1','303','1',1,'Retail Sale Id 357',4298.40,0.00,0.00,5.97,298.50,'2023-01-23 09:49:42','',''),(370,'1','303','1',1,'Retail Sale Id 358',2203.20,0.00,0.00,3.06,153.00,'2023-01-23 09:51:07','',''),(371,'1','303','1',1,'Retail Sale Id 359',2880.00,0.00,0.00,4.00,200.00,'2023-01-23 09:53:20','',''),(372,'1','303','1',1,'Retail Sale Id 360',4320.00,0.00,0.00,6.00,300.00,'2023-01-23 10:09:14','',''),(373,'1','303','1',1,'Retail Sale Id 362',1000.80,0.00,0.00,1.39,69.50,'2023-01-23 10:26:01','',''),(374,'1','303','1',1,'Retail Sale Id 363',3002.40,0.00,0.00,4.17,208.50,'2023-01-23 10:31:27','',''),(375,'1','303','1',1,'Retail Sale Id 364',4298.40,0.00,0.00,5.97,298.50,'2023-01-23 10:34:28','',''),(376,'1','303','1',1,'Return of Retail Sale Id 363',0.00,3002.40,4.17,0.00,-208.50,'2023-01-23 10:40:08','',''),(377,'1','303','1',1,'Retail Sale Id 365',4298.40,0.00,0.00,5.97,298.50,'2023-01-23 10:54:05','',''),(378,'1','303','1',1,'Retail Sale Id 366',1000.80,0.00,0.00,1.39,69.50,'2023-01-23 11:02:42','',''),(379,'1','303','1',1,'Retail Sale Id 367',3600.00,0.00,0.00,5.00,250.00,'2023-01-23 11:27:12','',''),(380,'1','303','1',1,'Retail Sale Id 368',1440.00,0.00,0.00,2.00,100.00,'2023-01-23 11:29:25','',''),(381,'1','303','1',1,'Retail Sale Id 369',2160.00,0.00,0.00,3.00,150.00,'2023-01-23 11:30:43','',''),(382,'1','303','1',1,'Retail Sale Id 370',7200.00,0.00,0.00,10.00,500.00,'2023-01-23 11:31:53','',''),(383,'1','303','1',1,'Retail Sale Id 371',1000.80,0.00,0.00,1.39,69.50,'2023-01-23 11:33:43','',''),(384,'1','303','1',1,'Retail Sale Id 372',4320.00,0.00,0.00,6.00,300.00,'2023-01-23 11:34:42','',''),(385,'1','303','1',1,'Retail Sale Id 373',720.00,0.00,0.00,1.00,50.00,'2023-01-23 11:36:30','',''),(386,'1','303','1',1,'Retail Sale Id 374',4320.00,0.00,0.00,6.00,300.00,'2023-01-23 11:42:50','',''),(387,'1','303','1',1,'Retail Sale Id 375',748.80,0.00,0.00,1.04,52.00,'2023-01-23 11:45:34','',''),(388,'1','303','1',1,'Retail Sale Id 376',1497.60,0.00,0.00,2.08,104.00,'2023-01-23 11:53:57','',''),(389,'1','303','1',1,'Retail Sale Id 377',1000.80,0.00,0.00,1.39,69.50,'2023-01-23 11:55:08','',''),(390,'1','303','1',1,'Retail Sale Id 378',2880.00,0.00,0.00,4.00,200.00,'2023-01-23 11:59:40','',''),(391,'1','303','1',1,'Retail Sale Id 379',4298.40,0.00,0.00,5.97,298.50,'2023-01-23 12:28:31','',''),(392,'1','303','1',1,'Retail Sale Id 380',7898.40,0.00,0.00,10.97,548.50,'2023-01-23 12:49:37','',''),(393,'1','303','1',1,'Retail Sale Id 381',4298.40,0.00,0.00,5.97,298.50,'2023-01-23 12:51:35','',''),(394,'1','303','1',1,'Retail Sale Id 382',4320.00,0.00,0.00,6.00,300.00,'2023-01-23 12:52:54','',''),(395,'1','303','1',1,'Retail Sale Id 383',4320.00,0.00,0.00,6.00,300.00,'2023-01-23 12:54:53','',''),(396,'1','303','1',1,'Retail Sale Id 383',4320.00,0.00,0.00,6.00,300.00,'2023-01-23 12:54:53','',''),(397,'1','303','1',1,'Retail Sale Id 384',1497.60,0.00,0.00,2.08,104.00,'2023-01-23 12:56:44','',''),(398,'1','303','1',1,'Retail Sale Id 385',9000.00,0.00,0.00,12.50,625.00,'2023-01-23 13:02:45','',''),(399,'1','303','1',1,'Retail Sale Id 387',4320.00,0.00,0.00,6.00,300.00,'2023-01-23 13:05:11','',''),(400,'1','303','1',1,'Retail Sale Id 388',1396.80,0.00,0.00,1.94,97.00,'2023-01-23 13:13:27','',''),(401,'1','303','1',1,'Retail Sale Id 389',4320.00,0.00,0.00,6.00,300.00,'2023-01-23 13:18:18','',''),(402,'1','303','1',1,'Retail Sale Id 390',2203.20,0.00,0.00,3.06,153.00,'2023-01-23 13:20:03','',''),(403,'1','303','1',1,'Retail Sale Id 391',2203.20,0.00,0.00,3.06,153.00,'2023-01-23 13:21:20','',''),(404,'1','303','1',1,'Retail Sale Id 392',2160.00,0.00,0.00,3.00,150.00,'2023-01-23 13:22:45','',''),(405,'1','303','1',1,'Retail Sale Id 393',7920.00,0.00,0.00,11.00,550.00,'2023-01-23 13:24:26','',''),(406,'1','303','1',1,'Retail Sale Id 394',3600.00,0.00,0.00,5.00,250.00,'2023-01-23 13:40:40','',''),(407,'1','303','1',1,'Retail Sale Id 394',9000.00,0.00,0.00,12.50,625.00,'2023-01-23 13:40:40','',''),(408,'1','303','1',1,'Retail Sale Id 395',4298.40,0.00,0.00,5.97,298.50,'2023-01-23 13:42:22','',''),(409,'1','303','1',1,'Retail Sale Id 396',2203.20,0.00,0.00,3.06,153.00,'2023-01-23 13:44:08','',''),(410,'1','303','1',1,'Retail Sale Id 397',4320.00,0.00,0.00,6.00,300.00,'2023-01-23 13:49:37','',''),(411,'1','303','1',1,'Retail Sale Id 398',4320.00,0.00,0.00,6.00,300.00,'2023-01-23 13:51:05','',''),(412,'1','303','1',1,'Retail Sale Id 399',2203.20,0.00,0.00,3.06,153.00,'2023-01-23 14:17:06','',''),(413,'1','303','1',1,'Retail Sale Id 400',1000.80,0.00,0.00,1.39,69.50,'2023-01-23 14:19:46','',''),(414,'1','303','1',1,'Retail Sale Id 401',9000.00,0.00,0.00,12.50,625.00,'2023-01-23 14:21:07','',''),(415,'1','303','1',1,'Retail Sale Id 402',2001.60,0.00,0.00,2.78,139.00,'2023-01-23 14:31:44','',''),(416,'1','303','1',1,'Retail Sale Id 403',2001.60,0.00,0.00,2.78,139.00,'2023-01-23 14:32:32','',''),(417,'1','303','1',1,'Retail Sale Id 404',2160.00,0.00,0.00,3.00,150.00,'2023-01-23 14:54:04','',''),(418,'1','303','1',1,'Retail Sale Id 405',9000.00,0.00,0.00,12.50,625.00,'2023-01-23 14:59:23','',''),(419,'1','303','1',1,'Retail Sale Id 406',4320.00,0.00,0.00,6.00,300.00,'2023-01-23 15:01:06','',''),(420,'1','303','1',1,'Retail Sale Id 407',2203.20,0.00,0.00,3.06,153.00,'2023-01-23 15:13:02','',''),(421,'1','303','1',1,'Retail Sale Id 408',4320.00,0.00,0.00,6.00,300.00,'2023-01-23 15:16:36','',''),(422,'1','303','1',1,'Retail Sale Id 409',2160.00,0.00,0.00,3.00,150.00,'2023-01-23 15:17:42','',''),(423,'1','303','1',1,'Retail Sale Id 410',9000.00,0.00,0.00,12.50,625.00,'2023-01-23 15:20:05','',''),(424,'1','303','1',1,'Retail Sale Id 411',9000.00,0.00,0.00,12.50,625.00,'2023-01-23 15:27:08','',''),(425,'1','303','1',1,'Retail Sale Id 412',4320.00,0.00,0.00,6.00,300.00,'2023-01-23 15:27:55','',''),(426,'1','303','1',1,'Retail Sale Id 413',1447.20,0.00,0.00,2.01,100.50,'2023-01-23 15:41:32','',''),(427,'1','303','1',1,'Retail Sale Id 414',2203.20,0.00,0.00,3.06,153.00,'2023-01-23 15:43:28','',''),(428,'1','303','1',1,'Retail Sale Id 416',2901.60,0.00,0.00,4.03,201.50,'2023-01-23 15:49:52','',''),(429,'1','303','1',1,'Retail Sale Id 417',1432.80,0.00,0.00,1.99,99.50,'2023-01-23 15:53:10','',''),(430,'1','303','1',1,'Retail Sale Id 418',1000.80,0.00,0.00,1.39,69.50,'2023-01-23 15:54:50','',''),(431,'1','303','1',1,'Retail Sale Id 419',9000.00,0.00,0.00,12.50,625.00,'2023-01-23 16:11:55','',''),(432,'1','303','1',1,'Retail Sale Id 420',1447.20,0.00,0.00,2.01,100.50,'2023-01-23 16:37:14','',''),(433,'1','303','1',1,'Retail Sale Id 421',4320.00,0.00,0.00,6.00,300.00,'2023-01-23 16:38:43','',''),(434,'1','303','1',1,'Retail Sale Id 422',2203.20,0.00,0.00,3.06,153.00,'2023-01-23 16:40:23','',''),(435,'1','303','1',1,'Retail Sale Id 423',950.40,0.00,0.00,1.32,66.00,'2023-01-23 16:54:06','',''),(436,'1','303','1',1,'Retail Sale Id 424',4348.80,0.00,0.00,6.04,302.00,'2023-01-23 17:07:29','',''),(437,'1','303','1',1,'Retail Sale Id 425',4348.80,0.00,0.00,6.04,302.00,'2023-01-23 17:13:45','',''),(438,'1','303','1',1,'Retail Sale Id 426',4500.00,0.00,0.00,6.25,312.50,'2023-01-23 17:37:22','',''),(439,'1','303','1',1,'Retail Sale Id 427',1440.00,0.00,0.00,2.00,100.00,'2023-01-23 17:42:55','',''),(440,'1','303','1',1,'Retail Sale Id 428',2167.20,0.00,0.00,3.01,150.50,'2023-01-23 17:48:29','',''),(441,'1','303','1',1,'Retail Sale Id 429',2160.00,0.00,0.00,3.00,150.00,'2023-01-23 17:50:04','',''),(442,'1','303','1',1,'Retail Sale Id 429',3600.00,0.00,0.00,5.00,250.00,'2023-01-23 17:50:04','',''),(443,'1','303','1',1,'Retail Sale Id 430',1440.00,0.00,0.00,2.00,100.00,'2023-01-23 17:50:52','',''),(444,'1','303','1',1,'Retail Sale Id 431',2160.00,0.00,0.00,3.00,150.00,'2023-01-23 17:54:28','',''),(445,'1','303','1',1,'Retail Sale Id 432',1000.80,0.00,0.00,1.39,69.50,'2023-01-23 18:03:12','',''),(446,'1','303','1',1,'Retail Sale Id 433',3002.40,0.00,0.00,4.17,208.50,'2023-01-23 18:12:34','',''),(447,'1','303','1',1,'Retail Sale Id 434',50.40,0.00,0.00,0.07,3.50,'2023-01-23 18:46:46','',''),(448,'1','303','1',1,'Retail Sale Id 435',2160.00,0.00,0.00,3.00,150.00,'2023-01-24 08:55:50','',''),(449,'1','303','1',1,'Retail Sale Id 435',9000.00,0.00,0.00,12.50,625.00,'2023-01-24 08:55:50','',''),(450,'1','303','1',1,'Retail Sale Id 436',1000.80,0.00,0.00,1.39,69.50,'2023-01-24 08:57:39','',''),(451,'1','303','1',1,'Retail Sale Id 437',1497.60,0.00,0.00,2.08,104.00,'2023-01-24 09:02:08','',''),(452,'1','303','1',1,'Retail Sale Id 438',1440.00,0.00,0.00,2.00,100.00,'2023-01-24 09:17:29','',''),(453,'1','303','1',1,'Retail Sale Id 440',4320.00,0.00,0.00,6.00,300.00,'2023-01-24 09:25:24','',''),(454,'1','303','1',1,'Retail Sale Id 441',7502.40,0.00,0.00,10.42,521.00,'2023-01-24 09:27:03','',''),(455,'1','303','1',1,'Retail Sale Id 442',2203.20,0.00,0.00,3.06,153.00,'2023-01-24 10:02:10','',''),(456,'1','303','1',1,'Retail Sale Id 443',5760.00,0.00,0.00,8.00,400.00,'2023-01-24 10:10:10','',''),(457,'1','303','1',1,'Retail Sale Id 444',3600.00,0.00,0.00,5.00,250.00,'2023-01-24 10:21:10','',''),(458,'1','303','1',1,'Retail Sale Id 445',3600.00,0.00,0.00,5.00,250.00,'2023-01-24 10:38:54','',''),(459,'1','303','1',1,'Retail Sale Id 446',3002.40,0.00,0.00,4.17,208.50,'2023-01-24 10:44:49','',''),(460,'1','303','1',1,'Retail Sale Id 447',4298.40,0.00,0.00,5.97,298.50,'2023-01-24 11:01:49','',''),(461,'1','303','1',1,'Retail Sale Id 448',4320.00,0.00,0.00,6.00,300.00,'2023-01-24 11:28:54','',''),(462,'1','303','1',1,'Retail Sale Id 449',2203.20,0.00,0.00,3.06,153.00,'2023-01-24 11:34:28','',''),(463,'1','303','1',1,'Retail Sale Id 450',2001.60,0.00,0.00,2.78,139.00,'2023-01-24 11:40:40','',''),(464,'1','303','1',1,'Retail Sale Id 451',4320.00,0.00,0.00,6.00,300.00,'2023-01-24 11:57:33','',''),(465,'1','303','1',1,'Retail Sale Id 452',9000.00,0.00,0.00,12.50,625.00,'2023-01-24 11:59:22','',''),(466,'1','303','1',1,'Retail Sale Id 453',2203.20,0.00,0.00,3.06,153.00,'2023-01-24 12:00:52','',''),(467,'1','303','1',1,'Retail Sale Id 454',4348.80,0.00,0.00,6.04,302.00,'2023-01-24 12:02:34','',''),(468,'1','303','1',1,'Retail Sale Id 455',7898.40,0.00,0.00,10.97,548.50,'2023-01-24 12:20:29','',''),(469,'1','303','1',1,'Retail Sale Id 456',1497.60,0.00,0.00,2.08,104.00,'2023-01-24 12:22:47','',''),(470,'1','303','1',1,'Retail Sale Id 457',9000.00,0.00,0.00,12.50,625.00,'2023-01-24 12:23:53','',''),(471,'1','303','1',1,'Retail Sale Id 458',1497.60,0.00,0.00,2.08,104.00,'2023-01-24 12:25:24','',''),(472,'1','303','1',1,'Retail Sale Id 459',4298.40,0.00,0.00,5.97,298.50,'2023-01-24 12:29:54','',''),(473,'1','303','1',1,'Retail Sale Id 460',2001.60,0.00,0.00,2.78,139.00,'2023-01-24 12:44:07','',''),(474,'1','303','1',1,'Retail Sale Id 461',2160.00,0.00,0.00,3.00,150.00,'2023-01-24 13:05:45','',''),(475,'1','303','1',1,'Retail Sale Id 462',2160.00,0.00,0.00,3.00,150.00,'2023-01-24 13:23:55','',''),(476,'1','303','1',1,'Retail Sale Id 463',4320.00,0.00,0.00,6.00,300.00,'2023-01-24 13:25:29','',''),(477,'1','303','1',1,'Retail Sale Id 464',3600.00,0.00,0.00,5.00,250.00,'2023-01-24 13:27:02','',''),(478,'1','303','1',1,'Retail Sale Id 465',4320.00,0.00,0.00,6.00,300.00,'2023-01-24 13:39:58','',''),(479,'1','303','1',1,'Retail Sale Id 466',4348.80,0.00,0.00,6.04,302.00,'2023-01-24 13:47:15','',''),(480,'1','303','1',1,'Retail Sale Id 467',2160.00,0.00,0.00,3.00,150.00,'2023-01-24 13:53:26','',''),(481,'1','303','1',1,'Retail Sale Id 467',4320.00,0.00,0.00,6.00,300.00,'2023-01-24 13:53:26','',''),(482,'1','303','1',1,'Retail Sale Id 468',4003.20,0.00,0.00,5.56,278.00,'2023-01-24 14:04:19','',''),(483,'1','303','1',1,'Retail Sale Id 469',2160.00,0.00,0.00,3.00,150.00,'2023-01-24 14:33:42','',''),(484,'1','303','1',1,'Retail Sale Id 469',9000.00,0.00,0.00,12.50,625.00,'2023-01-24 14:33:42','',''),(485,'1','303','1',1,'Retail Sale Id 470',3600.00,0.00,0.00,5.00,250.00,'2023-01-24 14:43:33','',''),(486,'1','303','1',1,'Retail Sale Id 471',4320.00,0.00,0.00,6.00,300.00,'2023-01-24 14:55:47','',''),(487,'1','303','1',1,'Retail Sale Id 472',2203.20,0.00,0.00,3.06,153.00,'2023-01-24 15:11:35','',''),(488,'1','303','1',1,'Retail Sale Id 473',4320.00,0.00,0.00,6.00,300.00,'2023-01-24 15:29:18','',''),(489,'1','303','1',1,'Retail Sale Id 474',1440.00,0.00,0.00,2.00,100.00,'2023-01-24 15:31:47','',''),(490,'1','303','1',1,'Retail Sale Id 475',7999.20,0.00,0.00,11.11,555.50,'2023-01-24 16:05:37','',''),(491,'1','303','1',1,'Retail Sale Id 477',2160.00,0.00,0.00,3.00,150.00,'2023-01-24 16:37:37','',''),(492,'1','303','1',1,'Retail Sale Id 478',2203.20,0.00,0.00,3.06,153.00,'2023-01-24 16:38:52','',''),(493,'1','303','1',1,'Retail Sale Id 479',6998.40,0.00,0.00,9.72,486.00,'2023-01-24 16:39:34','',''),(494,'1','303','1',1,'Retail Sale Id 480',2160.00,0.00,0.00,3.00,150.00,'2023-01-24 16:45:38','',''),(495,'1','303','1',1,'Retail Sale Id 481',3600.00,0.00,0.00,5.00,250.00,'2023-01-24 16:53:25','',''),(496,'1','303','1',1,'Retail Sale Id 482',4320.00,0.00,0.00,6.00,300.00,'2023-01-24 16:59:39','',''),(497,'1','303','1',1,'Retail Sale Id 483',2203.20,0.00,0.00,3.06,153.00,'2023-01-24 17:01:17','',''),(498,'1','303','1',1,'Retail Sale Id 484',9000.00,0.00,0.00,12.50,625.00,'2023-01-24 17:05:08','',''),(499,'1','303','1',1,'Retail Sale Id 485',9000.00,0.00,0.00,12.50,625.00,'2023-01-24 17:06:56','',''),(500,'1','303','1',1,'Retail Sale Id 486',4320.00,0.00,0.00,6.00,300.00,'2023-01-24 17:10:49','',''),(501,'1','303','1',1,'Retail Sale Id 486',4320.00,0.00,0.00,6.00,300.00,'2023-01-24 17:10:49','',''),(502,'1','303','1',1,'Retail Sale Id 487',3600.00,0.00,0.00,5.00,250.00,'2023-01-24 17:13:29','',''),(503,'1','303','1',1,'Retail Sale Id 488',4348.80,0.00,0.00,6.04,302.00,'2023-01-24 17:21:03','',''),(504,'1','303','1',1,'Retail Sale Id 489',759000.00,0.00,0.00,1100.00,22000.00,'2023-01-24 17:23:20','',''),(505,'1','303','1',1,'Retail Sale Id 490',9000.00,0.00,0.00,12.50,625.00,'2023-01-24 17:31:19','',''),(506,'1','303','1',1,'Retail Sale Id 491',4320.00,0.00,0.00,6.00,300.00,'2023-01-24 17:38:29','',''),(507,'1','303','1',1,'Retail Sale Id 493',4320.00,0.00,0.00,6.00,300.00,'2023-01-24 17:42:16','',''),(508,'1','303','1',1,'Return of Retail Sale Id 483',0.00,2203.20,3.06,0.00,-153.00,'2023-01-24 18:27:42','',''),(509,'1','303','1',1,'Retail Sale Id 494',993.60,0.00,0.00,1.38,69.00,'2023-01-24 18:28:31','',''),(510,'1','303','1',1,'Retail Sale Id 496',1035.00,0.00,0.00,1.50,30.00,'2023-01-24 18:36:01','',''),(511,'1','303','1',1,'Return of Retail Sale Id 496',0.00,1035.00,1.50,0.00,-30.00,'2023-01-24 18:37:12','',''),(512,'1','303','1',1,'Retail Sale Id 497',4320.00,0.00,0.00,6.00,300.00,'2023-01-25 07:48:22','',''),(513,'1','303','1',1,'Retail Sale Id 498',4320.00,0.00,0.00,6.00,300.00,'2023-01-25 08:07:46','',''),(514,'1','303','1',1,'Retail Sale Id 499',2152.80,0.00,0.00,2.99,149.50,'2023-01-25 08:09:04','',''),(515,'1','303','1',1,'Retail Sale Id 500',2160.00,0.00,0.00,3.00,150.00,'2023-01-25 08:10:35','',''),(516,'1','303','1',1,'Retail Sale Id 501',3600.00,0.00,0.00,5.00,250.00,'2023-01-25 08:11:57','',''),(517,'1','303','1',1,'Retail Sale Id 502',1000.80,0.00,0.00,1.39,69.50,'2023-01-25 08:13:27','',''),(518,'1','303','1',1,'Retail Sale Id 503',2001.60,0.00,0.00,2.78,139.00,'2023-01-25 08:26:51','',''),(519,'1','303','1',1,'Retail Sale Id 504',7200.00,0.00,0.00,10.00,500.00,'2023-01-25 09:04:53','',''),(520,'1','303','1',1,'Retail Sale Id 506',4348.80,0.00,0.00,6.04,302.00,'2023-01-25 09:42:08','',''),(521,'1','303','1',1,'Retail Sale Id 507',9000.00,0.00,0.00,12.50,625.00,'2023-01-25 10:04:22','',''),(522,'1','303','1',1,'Retail Sale Id 508',3600.00,0.00,0.00,5.00,250.00,'2023-01-25 10:05:40','',''),(523,'1','303','1',1,'Retail Sale Id 509',4320.00,0.00,0.00,6.00,300.00,'2023-01-25 10:06:34','',''),(524,'1','303','1',1,'Retail Sale Id 510',1497.60,0.00,0.00,2.08,104.00,'2023-01-25 10:08:41','',''),(525,'1','303','1',1,'Retail Sale Id 511',2160.00,0.00,0.00,3.00,150.00,'2023-01-25 10:15:30','',''),(526,'1','303','1',1,'Retail Sale Id 512',4320.00,0.00,0.00,6.00,300.00,'2023-01-25 10:17:48','',''),(527,'1','303','1',1,'Retail Sale Id 513',2001.60,0.00,0.00,2.78,139.00,'2023-01-25 10:24:42','',''),(528,'1','303','1',1,'Retail Sale Id 514',69000.00,0.00,0.00,100.00,2000.00,'2023-01-25 10:42:25','',''),(529,'1','303','1',1,'Retail Sale Id 515',2203.20,0.00,0.00,3.06,153.00,'2023-01-25 10:46:34','',''),(530,'1','303','1',1,'Retail Sale Id 516',7200.00,0.00,0.00,10.00,500.00,'2023-01-25 11:15:53','',''),(531,'1','303','1',1,'Retail Sale Id 517',1000.80,0.00,0.00,1.39,69.50,'2023-01-25 11:17:11','',''),(532,'1','303','1',1,'Retail Sale Id 518',4348.80,0.00,0.00,6.04,302.00,'2023-01-25 11:29:12','',''),(533,'1','303','1',1,'Retail Sale Id 519',2001.60,0.00,0.00,2.78,139.00,'2023-01-25 11:32:17','',''),(534,'1','303','1',1,'Retail Sale Id 520',4348.80,0.00,0.00,6.04,302.00,'2023-01-25 11:44:45','',''),(535,'1','303','1',1,'Retail Sale Id 521',3600.00,0.00,0.00,5.00,250.00,'2023-01-25 11:47:14','',''),(536,'1','303','1',1,'Retail Sale Id 522',34500.00,0.00,0.00,50.00,1000.00,'2023-01-25 12:03:12','',''),(537,'1','303','1',1,'Retail Sale Id 523',1440.00,0.00,0.00,2.00,100.00,'2023-01-25 12:04:46','',''),(538,'1','303','1',1,'Retail Sale Id 524',9000.00,0.00,0.00,12.50,625.00,'2023-01-25 12:06:06','',''),(539,'1','303','1',1,'Retail Sale Id 525',34500.00,0.00,0.00,50.00,1000.00,'2023-01-25 12:07:27','',''),(540,'1','303','1',1,'Retail Sale Id 526',4320.00,0.00,0.00,6.00,300.00,'2023-01-25 12:09:28','',''),(541,'1','303','1',1,'Retail Sale Id 527',2160.00,0.00,0.00,3.00,150.00,'2023-01-25 12:14:33','',''),(542,'1','303','1',1,'Retail Sale Id 528',2001.60,0.00,0.00,2.78,139.00,'2023-01-25 12:16:18','',''),(543,'1','303','1',1,'Retail Sale Id 529',3600.00,0.00,0.00,5.00,250.00,'2023-01-25 12:20:52','',''),(544,'1','303','1',1,'Retail Sale Id 530',7200.00,0.00,0.00,10.00,500.00,'2023-01-25 12:22:58','',''),(545,'1','303','1',1,'Retail Sale Id 532',2001.60,0.00,0.00,2.78,139.00,'2023-01-25 12:28:49','',''),(546,'1','303','1',1,'Retail Sale Id 533',5997.60,0.00,0.00,8.33,416.50,'2023-01-25 12:43:35','',''),(547,'1','303','1',1,'Retail Sale Id 534',6480.00,0.00,0.00,9.00,450.00,'2023-01-25 12:49:39','',''),(548,'1','303','1',1,'Retail Sale Id 535',2160.00,0.00,0.00,3.00,150.00,'2023-01-25 12:58:37','',''),(549,'1','303','1',1,'Retail Sale Id 536',7920.00,0.00,0.00,11.00,550.00,'2023-01-25 13:12:35','',''),(550,'1','303','1',1,'Retail Sale Id 537',2160.00,0.00,0.00,3.00,150.00,'2023-01-25 13:16:39','',''),(551,'1','303','1',1,'Retail Sale Id 538',9000.00,0.00,0.00,12.50,625.00,'2023-01-25 13:34:09','',''),(552,'1','303','1',1,'Retail Sale Id 539',1497.60,0.00,0.00,2.08,104.00,'2023-01-25 13:39:02','',''),(553,'1','303','1',1,'Retail Sale Id 540',1598.40,0.00,0.00,2.22,111.00,'2023-01-25 13:48:48','',''),(554,'1','303','1',1,'Retail Sale Id 541',4320.00,0.00,0.00,6.00,300.00,'2023-01-25 13:51:46','',''),(555,'1','303','1',1,'Retail Sale Id 542',4320.00,0.00,0.00,6.00,300.00,'2023-01-25 14:04:36','',''),(556,'1','303','1',1,'Retail Sale Id 543',4320.00,0.00,0.00,6.00,300.00,'2023-01-25 14:30:48','',''),(557,'1','303','1',1,'Retail Sale Id 544',2203.20,0.00,0.00,3.06,153.00,'2023-01-25 14:32:29','',''),(558,'1','303','1',1,'Retail Sale Id 545',4320.00,0.00,0.00,6.00,300.00,'2023-01-25 14:38:44','',''),(559,'1','303','1',1,'Retail Sale Id 546',4320.00,0.00,0.00,6.00,300.00,'2023-01-25 14:48:33','',''),(560,'1','303','1',1,'Retail Sale Id 547',2203.20,0.00,0.00,3.06,153.00,'2023-01-25 15:01:36','',''),(561,'1','303','1',1,'Retail Sale Id 548',2203.20,0.00,0.00,3.06,153.00,'2023-01-25 15:08:17','',''),(562,'1','303','1',1,'Retail Sale Id 549',5040.00,0.00,0.00,7.00,350.00,'2023-01-25 15:18:20','',''),(563,'1','303','1',1,'Retail Sale Id 550',1000.80,0.00,0.00,1.39,69.50,'2023-01-25 15:27:21','',''),(564,'1','303','1',1,'Retail Sale Id 551',4320.00,0.00,0.00,6.00,300.00,'2023-01-25 15:28:16','',''),(565,'1','303','1',1,'Retail Sale Id 552',2203.20,0.00,0.00,3.06,153.00,'2023-01-25 15:29:22','',''),(566,'1','303','1',1,'Retail Sale Id 553',4320.00,0.00,0.00,6.00,300.00,'2023-01-25 15:47:37','',''),(567,'1','303','1',1,'Retail Sale Id 554',2498.40,0.00,0.00,3.47,173.50,'2023-01-25 15:52:46','',''),(568,'1','303','1',1,'Retail Sale Id 555',2160.00,0.00,0.00,3.00,150.00,'2023-01-25 16:11:30','',''),(569,'1','303','1',1,'Retail Sale Id 556',2203.20,0.00,0.00,3.06,153.00,'2023-01-25 16:21:42','',''),(570,'1','303','1',1,'Retail Sale Id 557',2203.20,0.00,0.00,3.06,153.00,'2023-01-25 16:22:23','',''),(571,'1','303','1',1,'Retail Sale Id 558',5040.00,0.00,0.00,7.00,350.00,'2023-01-25 16:28:03','',''),(572,'1','303','1',1,'Retail Sale Id 560',2160.00,0.00,0.00,3.00,150.00,'2023-01-25 16:31:00','',''),(573,'1','303','1',1,'Retail Sale Id 562',2160.00,0.00,0.00,3.00,150.00,'2023-01-25 16:33:29','',''),(574,'1','303','1',1,'Retail Sale Id 563',9000.00,0.00,0.00,12.50,625.00,'2023-01-25 16:46:18','',''),(575,'1','303','1',1,'Retail Sale Id 564',2203.20,0.00,0.00,3.06,153.00,'2023-01-25 16:47:08','',''),(576,'1','303','1',1,'Retail Sale Id 565',3600.00,0.00,0.00,5.00,250.00,'2023-01-25 16:48:07','',''),(577,'1','303','1',1,'Retail Sale Id 566',9000.00,0.00,0.00,12.50,625.00,'2023-01-25 17:06:36','',''),(578,'1','303','1',1,'Retail Sale Id 567',4320.00,0.00,0.00,6.00,300.00,'2023-01-25 17:18:26','',''),(579,'1','303','1',1,'Retail Sale Id 568',4320.00,0.00,0.00,6.00,300.00,'2023-01-25 17:22:15','',''),(580,'1','303','1',1,'Retail Sale Id 570',3600.00,0.00,0.00,5.00,250.00,'2023-01-25 17:34:51','',''),(581,'1','303','1',1,'Retail Sale Id 571',2001.60,0.00,0.00,2.78,139.00,'2023-01-25 17:36:32','',''),(582,'1','303','1',1,'Retail Sale Id 572',2001.60,0.00,0.00,2.78,139.00,'2023-01-25 17:47:35','',''),(583,'1','303','1',1,'Retail Sale Id 574',2145.60,0.00,0.00,2.98,149.00,'2023-01-25 18:38:39','',''),(584,'1','303','1',1,'Retail Sale Id 575',4320.00,0.00,0.00,6.00,300.00,'2023-01-26 08:07:48','',''),(585,'1','303','1',1,'Retail Sale Id 576',4320.00,0.00,0.00,6.00,300.00,'2023-01-26 08:33:33','',''),(586,'1','303','1',1,'Retail Sale Id 577',720.00,0.00,0.00,1.00,50.00,'2023-01-26 08:40:17','',''),(587,'1','303','1',1,'Retail Sale Id 577',7200.00,0.00,0.00,10.00,500.00,'2023-01-26 08:40:17','',''),(588,'1','303','1',1,'Retail Sale Id 578',4500.00,0.00,0.00,6.25,312.50,'2023-01-26 08:54:14','',''),(589,'1','303','1',1,'Retail Sale Id 579',2001.60,0.00,0.00,2.78,139.00,'2023-01-26 08:59:10','',''),(590,'1','303','1',1,'Retail Sale Id 580',9000.00,0.00,0.00,12.50,625.00,'2023-01-26 09:06:06','',''),(591,'1','303','1',1,'Retail Sale Id 581',2901.60,0.00,0.00,4.03,201.50,'2023-01-26 09:08:11','',''),(592,'1','303','1',1,'Retail Sale Id 582',4320.00,0.00,0.00,6.00,300.00,'2023-01-26 09:13:38','',''),(593,'1','303','1',1,'Retail Sale Id 582',9000.00,0.00,0.00,12.50,625.00,'2023-01-26 09:13:38','',''),(594,'1','303','1',1,'Retail Sale Id 582',9000.00,0.00,0.00,12.50,625.00,'2023-01-26 09:13:38','',''),(595,'1','303','1',1,'Retail Sale Id 583',720.00,0.00,0.00,1.00,50.00,'2023-01-26 09:15:02','',''),(596,'1','303','1',1,'Retail Sale Id 584',4320.00,0.00,0.00,6.00,300.00,'2023-01-26 09:28:33','',''),(597,'1','303','1',1,'Retail Sale Id 585',2160.00,0.00,0.00,3.00,150.00,'2023-01-26 09:31:02','',''),(598,'1','303','1',1,'Retail Sale Id 586',4348.80,0.00,0.00,6.04,302.00,'2023-01-26 09:32:15','',''),(599,'1','303','1',1,'Retail Sale Id 587',9000.00,0.00,0.00,12.50,625.00,'2023-01-26 09:34:06','',''),(600,'1','303','1',1,'Retail Sale Id 588',4320.00,0.00,0.00,6.00,300.00,'2023-01-26 09:37:53','',''),(601,'1','303','1',1,'Retail Sale Id 589',2203.20,0.00,0.00,3.06,153.00,'2023-01-26 09:40:59','',''),(602,'1','303','1',1,'Retail Sale Id 590',4003.20,0.00,0.00,5.56,278.00,'2023-01-26 09:48:37','',''),(603,'1','303','1',1,'Retail Sale Id 591',4320.00,0.00,0.00,6.00,300.00,'2023-01-26 09:51:45','',''),(604,'1','303','1',1,'Retail Sale Id 592',4320.00,0.00,0.00,6.00,300.00,'2023-01-26 09:52:49','',''),(605,'1','303','1',1,'Retail Sale Id 593',1497.60,0.00,0.00,2.08,104.00,'2023-01-26 09:55:02','',''),(606,'1','303','1',1,'Retail Sale Id 594',3600.00,0.00,0.00,5.00,250.00,'2023-01-26 10:02:05','',''),(607,'1','303','1',1,'Retail Sale Id 595',4348.80,0.00,0.00,6.04,302.00,'2023-01-26 10:08:48','',''),(608,'1','303','1',1,'Retail Sale Id 596',2203.20,0.00,0.00,3.06,153.00,'2023-01-26 10:10:58','',''),(609,'1','303','1',1,'Retail Sale Id 597',9000.00,0.00,0.00,12.50,625.00,'2023-01-26 10:26:09','',''),(610,'1','303','1',1,'Retail Sale Id 599',4348.80,0.00,0.00,6.04,302.00,'2023-01-26 10:29:25','',''),(611,'1','303','1',1,'Retail Sale Id 600',1303.20,0.00,0.00,1.81,90.50,'2023-01-26 10:34:42','',''),(612,'1','303','1',1,'Retail Sale Id 601',2498.40,0.00,0.00,3.47,173.50,'2023-01-26 10:35:56','',''),(613,'1','303','1',1,'Retail Sale Id 602',3002.40,0.00,0.00,4.17,208.50,'2023-01-26 10:46:06','',''),(614,'1','303','1',1,'Retail Sale Id 603',3600.00,0.00,0.00,5.00,250.00,'2023-01-26 10:51:44','',''),(615,'1','303','1',1,'Retail Sale Id 604',3600.00,0.00,0.00,5.00,250.00,'2023-01-26 10:57:08','',''),(616,'1','303','1',1,'Retail Sale Id 605',4320.00,0.00,0.00,6.00,300.00,'2023-01-26 10:59:31','',''),(617,'1','303','1',1,'Retail Sale Id 607',4320.00,0.00,0.00,6.00,300.00,'2023-01-26 11:08:52','',''),(618,'1','303','1',1,'Retail Sale Id 607',4320.00,0.00,0.00,6.00,300.00,'2023-01-26 11:08:52','',''),(619,'1','303','1',1,'Retail Sale Id 608',3600.00,0.00,0.00,5.00,250.00,'2023-01-26 11:12:12','',''),(620,'1','303','1',1,'Retail Sale Id 609',2160.00,0.00,0.00,3.00,150.00,'2023-01-26 11:23:48','',''),(621,'1','303','1',1,'Retail Sale Id 610',4320.00,0.00,0.00,6.00,300.00,'2023-01-26 11:29:06','',''),(622,'1','303','1',1,'Retail Sale Id 611',4320.00,0.00,0.00,6.00,300.00,'2023-01-26 11:33:57','',''),(623,'1','303','1',1,'Retail Sale Id 612',2160.00,0.00,0.00,3.00,150.00,'2023-01-26 11:41:54','',''),(624,'1','303','1',1,'Retail Sale Id 613',4348.80,0.00,0.00,6.04,302.00,'2023-01-26 11:48:20','',''),(625,'1','303','1',1,'Retail Sale Id 614',3002.40,0.00,0.00,4.17,208.50,'2023-01-26 11:50:57','',''),(626,'1','303','1',1,'Retail Sale Id 615',4003.20,0.00,0.00,5.56,278.00,'2023-01-26 11:56:25','',''),(627,'1','303','1',1,'Retail Sale Id 616',799.20,0.00,0.00,1.11,55.50,'2023-01-26 12:08:27','',''),(628,'1','303','1',1,'Retail Sale Id 617',4320.00,0.00,0.00,6.00,300.00,'2023-01-26 12:23:29','',''),(629,'1','303','1',1,'Retail Sale Id 619',9000.00,0.00,0.00,12.50,625.00,'2023-01-26 12:25:23','',''),(630,'1','303','1',1,'Retail Sale Id 620',9000.00,0.00,0.00,12.50,625.00,'2023-01-26 12:50:14','',''),(631,'1','303','1',1,'Retail Sale Id 621',1000.80,0.00,0.00,1.39,69.50,'2023-01-26 13:03:32','',''),(632,'1','303','1',1,'Retail Sale Id 622',1497.60,0.00,0.00,2.08,104.00,'2023-01-26 13:05:42','',''),(633,'1','303','1',1,'Retail Sale Id 623',1497.60,0.00,0.00,2.08,104.00,'2023-01-26 13:07:27','',''),(634,'1','303','1',1,'Retail Sale Id 626',5760.00,0.00,0.00,8.00,400.00,'2023-01-26 13:22:35','',''),(635,'1','303','1',1,'Retail Sale Id 627',4320.00,0.00,0.00,6.00,300.00,'2023-01-26 13:40:01','',''),(636,'1','303','1',1,'Retail Sale Id 628',4320.00,0.00,0.00,6.00,300.00,'2023-01-26 13:41:26','',''),(637,'1','303','1',1,'Retail Sale Id 629',4320.00,0.00,0.00,6.00,300.00,'2023-01-26 13:43:45','',''),(638,'1','303','1',1,'Retail Sale Id 630',9000.00,0.00,0.00,12.50,625.00,'2023-01-26 13:47:38','',''),(639,'1','303','1',1,'Retail Sale Id 630',9000.00,0.00,0.00,12.50,625.00,'2023-01-26 13:47:38','',''),(640,'1','303','1',1,'Retail Sale Id 631',2160.00,0.00,0.00,3.00,150.00,'2023-01-26 13:58:45','',''),(641,'1','303','1',1,'Retail Sale Id 632',2160.00,0.00,0.00,3.00,150.00,'2023-01-26 14:05:13','',''),(642,'1','303','1',1,'Retail Sale Id 633',4320.00,0.00,0.00,6.00,300.00,'2023-01-26 14:13:51','',''),(643,'1','303','1',1,'Retail Sale Id 633',9000.00,0.00,0.00,12.50,625.00,'2023-01-26 14:13:51','',''),(644,'1','303','1',1,'Retail Sale Id 633',9000.00,0.00,0.00,12.50,625.00,'2023-01-26 14:13:51','',''),(645,'1','303','1',1,'Retail Sale Id 634',5040.00,0.00,0.00,7.00,350.00,'2023-01-26 14:32:55','',''),(646,'1','303','1',1,'Retail Sale Id 635',2160.00,0.00,0.00,3.00,150.00,'2023-01-26 14:35:03','',''),(647,'1','303','1',1,'Retail Sale Id 636',4320.00,0.00,0.00,6.00,300.00,'2023-01-26 14:40:56','',''),(648,'1','303','1',1,'Retail Sale Id 637',2160.00,0.00,0.00,3.00,150.00,'2023-01-26 14:42:56','',''),(649,'1','303','1',1,'Retail Sale Id 638',720.00,0.00,0.00,1.00,50.00,'2023-01-26 14:46:07','',''),(650,'1','303','1',1,'Retail Sale Id 639',9000.00,0.00,0.00,12.50,625.00,'2023-01-26 14:48:58','',''),(651,'1','303','1',1,'Retail Sale Id 640',9000.00,0.00,0.00,12.50,625.00,'2023-01-26 14:50:03','',''),(652,'1','303','1',1,'Retail Sale Id 641',1000.80,0.00,0.00,1.39,69.50,'2023-01-26 14:51:01','',''),(653,'1','303','1',1,'Retail Sale Id 642',720.00,0.00,0.00,1.00,50.00,'2023-01-26 15:05:01','',''),(654,'1','303','1',1,'Retail Sale Id 643',3600.00,0.00,0.00,5.00,250.00,'2023-01-26 15:13:09','',''),(655,'1','303','1',1,'Retail Sale Id 644',3600.00,0.00,0.00,5.00,250.00,'2023-01-26 15:23:47','',''),(656,'1','303','1',1,'Retail Sale Id 645',3600.00,0.00,0.00,5.00,250.00,'2023-01-26 15:25:14','',''),(657,'1','303','1',1,'Retail Sale Id 646',3600.00,0.00,0.00,5.00,250.00,'2023-01-26 15:37:02','',''),(658,'1','303','1',1,'Retail Sale Id 647',2160.00,0.00,0.00,3.00,150.00,'2023-01-26 15:42:31','',''),(659,'1','303','1',1,'Retail Sale Id 648',2160.00,0.00,0.00,3.00,150.00,'2023-01-26 15:46:21','',''),(660,'1','303','1',1,'Retail Sale Id 648',2160.00,0.00,0.00,3.00,150.00,'2023-01-26 15:46:21','',''),(661,'1','303','1',1,'Retail Sale Id 649',3600.00,0.00,0.00,5.00,250.00,'2023-01-26 16:18:21','',''),(662,'1','303','1',1,'Retail Sale Id 650',4320.00,0.00,0.00,6.00,300.00,'2023-01-26 16:37:38','',''),(663,'1','303','1',1,'Retail Sale Id 651',2203.20,0.00,0.00,3.06,153.00,'2023-01-26 16:44:36','',''),(664,'1','303','1',1,'Retail Sale Id 652',9000.00,0.00,0.00,12.50,625.00,'2023-01-26 16:46:12','',''),(665,'1','303','1',1,'Retail Sale Id 653',3002.40,0.00,0.00,4.17,208.50,'2023-01-26 16:49:59','',''),(666,'1','303','1',1,'Retail Sale Id 654',2160.00,0.00,0.00,3.00,150.00,'2023-01-26 16:56:30','',''),(667,'1','303','1',1,'Retail Sale Id 655',2160.00,0.00,0.00,3.00,150.00,'2023-01-26 17:09:29','',''),(668,'1','303','1',1,'Retail Sale Id 656',4320.00,0.00,0.00,6.00,300.00,'2023-01-26 17:14:17','',''),(669,'1','303','1',1,'Retail Sale Id 657',4348.80,0.00,0.00,6.04,302.00,'2023-01-26 17:16:31','',''),(670,'1','303','1',1,'Retail Sale Id 658',4320.00,0.00,0.00,6.00,300.00,'2023-01-26 17:20:21','',''),(671,'1','303','1',1,'Retail Sale Id 659',1000.80,0.00,0.00,1.39,69.50,'2023-01-26 17:21:48','',''),(672,'1','303','1',1,'Retail Sale Id 660',4320.00,0.00,0.00,6.00,300.00,'2023-01-26 17:27:50','',''),(673,'1','303','1',1,'Retail Sale Id 661',3600.00,0.00,0.00,5.00,250.00,'2023-01-26 17:31:53','',''),(674,'1','303','1',1,'Retail Sale Id 662',2160.00,0.00,0.00,3.00,150.00,'2023-01-26 17:33:37','',''),(675,'1','303','1',1,'Retail Sale Id 663',4298.40,0.00,0.00,5.97,298.50,'2023-01-26 17:35:21','',''),(676,'1','303','1',1,'Retail Sale Id 665',3600.00,0.00,0.00,5.00,250.00,'2023-01-26 17:39:43','',''),(677,'1','303','1',1,'Retail Sale Id 666',2160.00,0.00,0.00,3.00,150.00,'2023-01-26 17:45:45','',''),(678,'1','303','1',1,'Retail Sale Id 667',3600.00,0.00,0.00,5.00,250.00,'2023-01-26 17:59:23','',''),(679,'1','303','1',1,'Return of Retail Sale Id 659',0.00,1000.80,1.39,0.00,-69.50,'2023-01-26 18:11:16','',''),(680,'1','303','1',1,'Retail Sale Id 668',417.60,0.00,0.00,0.58,29.00,'2023-01-26 18:14:29','',''),(681,'1','303','1',1,'Retail Sale Id 669',4320.00,0.00,0.00,6.00,300.00,'2023-01-27 08:24:50','',''),(682,'1','303','1',1,'Retail Sale Id 670',3002.40,0.00,0.00,4.17,208.50,'2023-01-27 08:25:58','',''),(683,'1','303','1',1,'Retail Sale Id 671',2160.00,0.00,0.00,3.00,150.00,'2023-01-27 08:39:21','',''),(684,'1','303','1',1,'Retail Sale Id 671',9000.00,0.00,0.00,12.50,625.00,'2023-01-27 08:39:21','',''),(685,'1','303','1',1,'Retail Sale Id 672',2901.60,0.00,0.00,4.03,201.50,'2023-01-27 08:40:34','',''),(686,'1','303','1',1,'Retail Sale Id 674',3002.40,0.00,0.00,4.17,208.50,'2023-01-27 08:55:58','',''),(687,'1','303','1',1,'Retail Sale Id 675',9000.00,0.00,0.00,12.50,625.00,'2023-01-27 08:57:06','',''),(688,'1','303','1',1,'Retail Sale Id 678',1202.40,0.00,0.00,1.67,83.50,'2023-01-27 09:19:28','',''),(689,'1','303','1',1,'Retail Sale Id 678',9000.00,0.00,0.00,12.50,625.00,'2023-01-27 09:19:28','',''),(690,'1','303','1',1,'Retail Sale Id 679',3600.00,0.00,0.00,5.00,250.00,'2023-01-27 09:36:40','',''),(691,'1','303','1',1,'Retail Sale Id 680',9000.00,0.00,0.00,12.50,625.00,'2023-01-27 09:38:55','',''),(692,'1','303','1',1,'Retail Sale Id 681',4320.00,0.00,0.00,6.00,300.00,'2023-01-27 09:39:59','',''),(693,'1','303','1',1,'Retail Sale Id 682',4320.00,0.00,0.00,6.00,300.00,'2023-01-27 09:40:57','',''),(694,'1','303','1',1,'Retail Sale Id 683',9000.00,0.00,0.00,12.50,625.00,'2023-01-27 09:42:05','',''),(695,'1','303','1',1,'Retail Sale Id 685',3600.00,0.00,0.00,5.00,250.00,'2023-01-27 09:43:54','',''),(696,'1','303','1',1,'Retail Sale Id 686',9000.00,0.00,0.00,12.50,625.00,'2023-01-27 09:44:54','',''),(697,'1','303','1',1,'Retail Sale Id 687',2203.20,0.00,0.00,3.06,153.00,'2023-01-27 09:45:52','',''),(698,'1','303','1',1,'Retail Sale Id 689',2160.00,0.00,0.00,3.00,150.00,'2023-01-27 09:50:32','',''),(699,'1','303','1',1,'Retail Sale Id 689',4320.00,0.00,0.00,6.00,300.00,'2023-01-27 09:50:32','',''),(700,'1','303','1',1,'Retail Sale Id 690',3002.40,0.00,0.00,4.17,208.50,'2023-01-27 09:54:08','',''),(701,'1','303','1',1,'Retail Sale Id 691',2203.20,0.00,0.00,3.06,153.00,'2023-01-27 10:03:43','',''),(702,'1','303','1',1,'Retail Sale Id 693',7920.00,0.00,0.00,11.00,550.00,'2023-01-27 10:08:00','',''),(703,'1','303','1',1,'Retail Sale Id 694',9000.00,0.00,0.00,12.50,625.00,'2023-01-27 10:19:02','',''),(704,'1','303','1',1,'Retail Sale Id 695',1440.00,0.00,0.00,2.00,100.00,'2023-01-27 10:23:58','',''),(705,'1','303','1',1,'Retail Sale Id 696',4320.00,0.00,0.00,6.00,300.00,'2023-01-27 10:40:30','',''),(706,'1','303','1',1,'Retail Sale Id 697',9000.00,0.00,0.00,12.50,625.00,'2023-01-27 10:51:06','',''),(707,'1','303','1',1,'Retail Sale Id 698',3600.00,0.00,0.00,5.00,250.00,'2023-01-27 10:52:06','',''),(708,'1','303','1',1,'Retail Sale Id 699',2901.60,0.00,0.00,4.03,201.50,'2023-01-27 10:56:17','',''),(709,'1','303','1',1,'Retail Sale Id 700',3600.00,0.00,0.00,5.00,250.00,'2023-01-27 10:57:27','',''),(710,'1','303','1',1,'Retail Sale Id 701',2160.00,0.00,0.00,3.00,150.00,'2023-01-27 11:05:09','',''),(711,'1','303','1',1,'Retail Sale Id 702',2160.00,0.00,0.00,3.00,150.00,'2023-01-27 11:27:53','',''),(712,'1','303','1',1,'Retail Sale Id 703',2160.00,0.00,0.00,3.00,150.00,'2023-01-27 11:35:46','',''),(713,'1','303','1',1,'Retail Sale Id 704',1497.60,0.00,0.00,2.08,104.00,'2023-01-27 11:45:41','',''),(714,'1','303','1',1,'Retail Sale Id 705',4320.00,0.00,0.00,6.00,300.00,'2023-01-27 11:51:58','',''),(715,'1','303','1',1,'Retail Sale Id 706',2160.00,0.00,0.00,3.00,150.00,'2023-01-27 11:55:56','',''),(716,'1','303','1',1,'Retail Sale Id 707',4320.00,0.00,0.00,6.00,300.00,'2023-01-27 11:58:14','',''),(717,'1','303','1',1,'Retail Sale Id 708',9000.00,0.00,0.00,12.50,625.00,'2023-01-27 12:31:46','',''),(718,'1','303','1',1,'Retail Sale Id 709',2160.00,0.00,0.00,3.00,150.00,'2023-01-27 12:34:19','',''),(719,'1','303','1',1,'Retail Sale Id 710',5040.00,0.00,0.00,7.00,350.00,'2023-01-27 13:09:54','',''),(720,'1','303','1',1,'Retail Sale Id 711',1440.00,0.00,0.00,2.00,100.00,'2023-01-27 13:20:42','',''),(721,'1','303','1',1,'Retail Sale Id 711',1440.00,0.00,0.00,2.00,100.00,'2023-01-27 13:20:42','',''),(722,'1','303','1',1,'Retail Sale Id 712',2160.00,0.00,0.00,3.00,150.00,'2023-01-27 13:22:11','',''),(723,'1','303','1',1,'Retail Sale Id 713',3002.40,0.00,0.00,4.17,208.50,'2023-01-27 14:24:02','',''),(724,'1','303','1',1,'Retail Sale Id 714',1000.80,0.00,0.00,1.39,69.50,'2023-01-27 14:35:18','',''),(725,'1','303','1',1,'Retail Sale Id 715',4320.00,0.00,0.00,6.00,300.00,'2023-01-27 14:50:31','',''),(726,'1','303','1',1,'Retail Sale Id 716',9000.00,0.00,0.00,12.50,625.00,'2023-01-27 14:53:22','',''),(727,'1','303','1',1,'Retail Sale Id 717',698.40,0.00,0.00,0.97,48.50,'2023-01-27 14:54:25','',''),(728,'1','303','1',1,'Retail Sale Id 718',4298.40,0.00,0.00,5.97,298.50,'2023-01-27 14:55:50','',''),(729,'1','303','1',1,'Retail Sale Id 719',4320.00,0.00,0.00,6.00,300.00,'2023-01-27 14:58:14','',''),(730,'1','303','1',1,'Retail Sale Id 720',2203.20,0.00,0.00,3.06,153.00,'2023-01-27 14:59:24','',''),(731,'1','303','1',1,'Retail Sale Id 721',5760.00,0.00,0.00,8.00,400.00,'2023-01-27 15:18:15','',''),(732,'1','303','1',1,'Retail Sale Id 722',9000.00,0.00,0.00,12.50,625.00,'2023-01-27 15:24:58','',''),(733,'1','303','1',1,'Retail Sale Id 723',4320.00,0.00,0.00,6.00,300.00,'2023-01-27 15:27:20','',''),(734,'1','303','1',1,'Retail Sale Id 724',4320.00,0.00,0.00,6.00,300.00,'2023-01-27 15:29:44','',''),(735,'1','303','1',1,'Retail Sale Id 724',4320.00,0.00,0.00,6.00,300.00,'2023-01-27 15:29:44','',''),(736,'1','303','1',1,'Retail Sale Id 725',3600.00,0.00,0.00,5.00,250.00,'2023-01-27 15:42:44','',''),(737,'1','303','1',1,'Retail Sale Id 726',4320.00,0.00,0.00,6.00,300.00,'2023-01-27 16:10:07','',''),(738,'1','303','1',1,'Retail Sale Id 727',4320.00,0.00,0.00,6.00,300.00,'2023-01-27 16:13:32','',''),(739,'1','303','1',1,'Retail Sale Id 728',2160.00,0.00,0.00,3.00,150.00,'2023-01-27 16:17:30','',''),(740,'1','303','1',1,'Retail Sale Id 728',9000.00,0.00,0.00,12.50,625.00,'2023-01-27 16:17:30','',''),(741,'1','303','1',1,'Retail Sale Id 729',5997.60,0.00,0.00,8.33,416.50,'2023-01-27 17:06:11','',''),(742,'1','303','1',1,'Retail Sale Id 730',1080.00,0.00,0.00,1.50,75.00,'2023-01-27 17:14:06','',''),(743,'1','303','1',1,'Retail Sale Id 731',3600.00,0.00,0.00,5.00,250.00,'2023-01-27 17:19:30','',''),(744,'1','303','1',1,'Retail Sale Id 732',2203.20,0.00,0.00,3.06,153.00,'2023-01-27 17:25:36','',''),(745,'1','303','1',1,'Retail Sale Id 733',4320.00,0.00,0.00,6.00,300.00,'2023-01-27 17:27:51','',''),(746,'1','303','1',1,'Retail Sale Id 733',4320.00,0.00,0.00,6.00,300.00,'2023-01-27 17:27:51','',''),(747,'1','303','1',1,'Retail Sale Id 734',7999.20,0.00,0.00,11.11,555.50,'2023-01-27 17:31:33','',''),(748,'1','303','1',1,'Retail Sale Id 735',1447.20,0.00,0.00,2.01,100.50,'2023-01-27 17:32:49','',''),(749,'1','303','1',1,'Retail Sale Id 736',3600.00,0.00,0.00,5.00,250.00,'2023-01-27 18:01:44','',''),(750,'1','303','1',1,'Retail Sale Id 737',2160.00,0.00,0.00,3.00,150.00,'2023-01-27 18:03:33','',''),(751,'1','303','1',1,'Retail Sale Id 737',2160.00,0.00,0.00,3.00,150.00,'2023-01-27 18:03:33','',''),(752,'1','303','1',1,'Retail Sale Id 738',194.40,0.00,0.00,0.27,13.50,'2023-01-27 19:24:36','',''),(753,'1','303','1',1,'Retail Sale Id 739',4298.40,0.00,0.00,5.97,298.50,'2023-01-28 07:10:45','',''),(754,'1','303','1',1,'Retail Sale Id 740',900.00,0.00,0.00,1.25,62.50,'2023-01-28 08:32:35','',''),(755,'1','303','1',1,'Retail Sale Id 741',7200.00,0.00,0.00,10.00,500.00,'2023-01-28 08:44:20','',''),(756,'1','303','1',1,'Retail Sale Id 742',2001.60,0.00,0.00,2.78,139.00,'2023-01-28 08:53:51','',''),(757,'1','303','1',1,'Retail Sale Id 743',2102.40,0.00,0.00,2.92,146.00,'2023-01-28 09:10:08','',''),(758,'1','303','1',1,'Retail Sale Id 744',4298.40,0.00,0.00,5.97,298.50,'2023-01-28 09:40:45','',''),(759,'1','303','1',1,'Retail Sale Id 746',2901.60,0.00,0.00,4.03,201.50,'2023-01-28 09:47:35','',''),(760,'1','303','1',1,'Retail Sale Id 747',2498.40,0.00,0.00,3.47,173.50,'2023-01-28 09:55:16','',''),(761,'1','303','1',1,'Retail Sale Id 748',4320.00,0.00,0.00,6.00,300.00,'2023-01-28 10:02:25','',''),(762,'1','303','1',1,'Retail Sale Id 749',2901.60,0.00,0.00,4.03,201.50,'2023-01-28 10:13:25','',''),(763,'1','303','1',1,'Retail Sale Id 750',4320.00,0.00,0.00,6.00,300.00,'2023-01-28 10:47:05','',''),(764,'1','303','1',1,'Retail Sale Id 751',3600.00,0.00,0.00,5.00,250.00,'2023-01-28 10:56:26','',''),(765,'1','303','1',1,'Retail Sale Id 752',2001.60,0.00,0.00,2.78,139.00,'2023-01-28 10:57:59','',''),(766,'1','303','1',1,'Retail Sale Id 753',3002.40,0.00,0.00,4.17,208.50,'2023-01-28 10:59:49','',''),(767,'1','303','1',1,'Retail Sale Id 754',1440.00,0.00,0.00,2.00,100.00,'2023-01-28 11:08:57','',''),(768,'1','303','1',1,'Retail Sale Id 755',7200.00,0.00,0.00,10.00,500.00,'2023-01-28 11:24:55','',''),(769,'1','303','1',1,'Retail Sale Id 756',90000.00,0.00,0.00,125.00,6250.00,'2023-01-28 11:26:57','',''),(770,'1','303','1',1,'Retail Sale Id 757',9000.00,0.00,0.00,12.50,625.00,'2023-01-28 11:29:52','',''),(771,'1','303','1',1,'Retail Sale Id 758',4320.00,0.00,0.00,6.00,300.00,'2023-01-28 11:31:49','',''),(772,'1','303','1',1,'Retail Sale Id 759',3600.00,0.00,0.00,5.00,250.00,'2023-01-28 11:33:08','',''),(773,'1','303','1',1,'Return of Retail Sale Id 756',0.00,90000.00,125.00,0.00,-6250.00,'2023-01-28 11:36:21','',''),(774,'1','303','1',1,'Retail Sale Id 760',1497.60,0.00,0.00,2.08,104.00,'2023-01-28 11:39:49','',''),(775,'1','303','1',1,'Retail Sale Id 761',4320.00,0.00,0.00,6.00,300.00,'2023-01-28 11:50:29','',''),(776,'1','303','1',1,'Retail Sale Id 761',7200.00,0.00,0.00,10.00,500.00,'2023-01-28 11:50:29','',''),(777,'1','303','1',1,'Retail Sale Id 762',4320.00,0.00,0.00,6.00,300.00,'2023-01-28 11:59:35','',''),(778,'1','303','1',1,'Retail Sale Id 763',2203.20,0.00,0.00,3.06,153.00,'2023-01-28 12:01:23','',''),(779,'1','303','1',1,'Retail Sale Id 764',4320.00,0.00,0.00,6.00,300.00,'2023-01-28 12:06:08','',''),(780,'1','303','1',1,'Retail Sale Id 765',2203.20,0.00,0.00,3.06,153.00,'2023-01-28 12:09:26','',''),(781,'1','303','1',1,'Retail Sale Id 766',9000.00,0.00,0.00,12.50,625.00,'2023-01-28 12:11:22','',''),(782,'1','303','1',1,'Retail Sale Id 767',2203.20,0.00,0.00,3.06,153.00,'2023-01-28 12:20:06','',''),(783,'1','303','1',1,'Retail Sale Id 768',1497.60,0.00,0.00,2.08,104.00,'2023-01-28 12:24:35','',''),(784,'1','303','1',1,'Retail Sale Id 769',4320.00,0.00,0.00,6.00,300.00,'2023-01-28 12:30:02','',''),(785,'1','303','1',1,'Retail Sale Id 770',3600.00,0.00,0.00,5.00,250.00,'2023-01-28 12:45:43','',''),(786,'1','303','1',1,'Retail Sale Id 771',7200.00,0.00,0.00,10.00,500.00,'2023-01-28 12:54:00','',''),(787,'1','303','1',1,'Retail Sale Id 773',1440.00,0.00,0.00,2.00,100.00,'2023-01-28 13:01:16','',''),(788,'1','303','1',1,'Retail Sale Id 774',9000.00,0.00,0.00,12.50,625.00,'2023-01-28 13:38:29','',''),(789,'1','303','1',1,'Retail Sale Id 775',4348.80,0.00,0.00,6.04,302.00,'2023-01-28 13:40:17','',''),(790,'1','303','1',1,'Retail Sale Id 776',2203.20,0.00,0.00,3.06,153.00,'2023-01-28 13:41:37','',''),(791,'1','303','1',1,'Retail Sale Id 777',2001.60,0.00,0.00,2.78,139.00,'2023-01-28 13:43:43','',''),(792,'1','303','1',1,'Retail Sale Id 778',3600.00,0.00,0.00,5.00,250.00,'2023-01-28 13:44:40','',''),(793,'1','303','1',1,'Retail Sale Id 779',586527.60,0.00,0.00,850.04,17000.80,'2023-01-28 13:48:35','',''),(794,'1','303','1',1,'Retail Sale Id 780',2001.60,0.00,0.00,2.78,139.00,'2023-01-28 13:55:00','',''),(795,'1','303','1',1,'Retail Sale Id 781',2203.20,0.00,0.00,3.06,153.00,'2023-01-28 13:58:37','',''),(796,'1','303','1',1,'Retail Sale Id 782',4320.00,0.00,0.00,6.00,300.00,'2023-01-28 14:11:26','',''),(797,'1','303','1',1,'Retail Sale Id 783',2160.00,0.00,0.00,3.00,150.00,'2023-01-28 14:23:02','',''),(798,'1','303','1',1,'Retail Sale Id 784',5997.60,0.00,0.00,8.33,416.50,'2023-01-28 14:51:51','',''),(799,'1','303','1',1,'Retail Sale Id 785',4298.40,0.00,0.00,5.97,298.50,'2023-01-28 14:58:21','',''),(800,'1','303','1',1,'Retail Sale Id 786',4996.80,0.00,0.00,6.94,347.00,'2023-01-28 15:06:45','',''),(801,'1','303','1',1,'Retail Sale Id 787',9000.00,0.00,0.00,12.50,625.00,'2023-01-28 15:08:00','',''),(802,'1','303','1',1,'Retail Sale Id 788',4298.40,0.00,0.00,5.97,298.50,'2023-01-28 15:16:21','',''),(803,'1','303','1',1,'Retail Sale Id 789',4298.40,0.00,0.00,5.97,298.50,'2023-01-28 15:18:02','',''),(804,'1','303','1',1,'Retail Sale Id 790',9000.00,0.00,0.00,12.50,625.00,'2023-01-28 15:23:23','',''),(805,'1','303','1',1,'Retail Sale Id 791',2203.20,0.00,0.00,3.06,153.00,'2023-01-28 15:45:05','',''),(806,'1','303','1',1,'Retail Sale Id 792',9000.00,0.00,0.00,12.50,625.00,'2023-01-28 15:56:25','',''),(807,'1','303','1',1,'Retail Sale Id 793',2203.20,0.00,0.00,3.06,153.00,'2023-01-28 16:03:19','',''),(808,'1','303','1',1,'Retail Sale Id 794',2160.00,0.00,0.00,3.00,150.00,'2023-01-28 16:06:19','',''),(809,'1','303','1',1,'Retail Sale Id 794',4320.00,0.00,0.00,6.00,300.00,'2023-01-28 16:06:19','',''),(810,'1','303','1',1,'Retail Sale Id 795',241500.00,0.00,0.00,350.00,7000.00,'2023-01-28 16:15:35','',''),(811,'1','303','1',1,'Retail Sale Id 796',2160.00,0.00,0.00,3.00,150.00,'2023-01-28 16:20:17','',''),(812,'1','303','1',1,'Retail Sale Id 796',2160.00,0.00,0.00,3.00,150.00,'2023-01-28 16:20:17','',''),(813,'1','303','1',1,'Retail Sale Id 797',2203.20,0.00,0.00,3.06,153.00,'2023-01-28 16:27:53','',''),(814,'1','303','1',1,'Retail Sale Id 798',2001.60,0.00,0.00,2.78,139.00,'2023-01-28 16:47:51','',''),(815,'1','303','1',1,'Retail Sale Id 799',2203.20,0.00,0.00,3.06,153.00,'2023-01-28 16:56:58','',''),(816,'1','303','1',1,'Retail Sale Id 800',4320.00,0.00,0.00,6.00,300.00,'2023-01-28 16:58:44','',''),(817,'1','303','1',1,'Retail Sale Id 801',2203.20,0.00,0.00,3.06,153.00,'2023-01-28 17:05:03','',''),(818,'1','303','1',1,'Retail Sale Id 802',2203.20,0.00,0.00,3.06,153.00,'2023-01-28 17:30:18','',''),(819,'1','303','1',1,'Retail Sale Id 803',4320.00,0.00,0.00,6.00,300.00,'2023-01-28 17:31:58','',''),(820,'1','303','1',1,'Retail Sale Id 804',4320.00,0.00,0.00,6.00,300.00,'2023-01-28 17:33:19','',''),(821,'1','303','1',1,'Retail Sale Id 804',7200.00,0.00,0.00,10.00,500.00,'2023-01-28 17:33:19','',''),(822,'1','303','1',1,'Retail Sale Id 805',9000.00,0.00,0.00,12.50,625.00,'2023-01-28 17:49:42','',''),(823,'1','303','1',1,'Return of Retail Sale Id 805',0.00,9000.00,12.50,0.00,-625.00,'2023-01-28 18:54:52','',''),(824,'1','303','1',1,'Retail Sale Id 806',4572.00,0.00,0.00,6.35,317.50,'2023-01-28 18:55:53','',''),(825,'1','303','1',1,'Retail Sale Id 807',0.00,0.00,0.00,0.00,0.00,'2023-01-28 18:58:41','',''),(826,'1','303','1',1,'Retail Sale Id 808',1000.80,0.00,0.00,1.39,69.50,'2023-01-28 19:00:17','',''),(827,'1','303','1',1,'Return of Retail Sale Id 807',0.00,0.00,0.00,0.00,0.00,'2023-01-28 19:02:13','',''),(828,'1','303','1',1,'Return of Retail Sale Id 801',0.00,2203.20,3.06,0.00,-153.00,'2023-01-28 19:04:25','',''),(829,'1','303','1',1,'Retail Sale Id 809',1202.40,0.00,0.00,1.67,83.50,'2023-01-28 19:05:30','',''),(830,'1','303','1',1,'Retail Sale Id 810',10350.00,0.00,0.00,15.00,300.00,'2023-01-28 19:10:57','',''),(831,'1','303','1',1,'Return of Retail Sale Id 810',0.00,10350.00,15.00,0.00,-300.00,'2023-01-28 19:15:52','',''),(832,'1','303','1',1,'Retail Sale Id 811',4500.00,0.00,0.00,6.25,312.50,'2023-01-29 08:01:28','',''),(833,'1','303','1',1,'Retail Sale Id 812',4298.40,0.00,0.00,5.97,298.50,'2023-01-29 08:58:10','',''),(834,'1','303','1',1,'Retail Sale Id 813',4298.40,0.00,0.00,5.97,298.50,'2023-01-29 08:59:12','',''),(835,'1','303','1',1,'Retail Sale Id 814',4996.80,0.00,0.00,6.94,347.00,'2023-01-29 09:06:58','',''),(836,'1','303','1',1,'Retail Sale Id 815',4500.00,0.00,0.00,6.25,312.50,'2023-01-29 09:08:20','',''),(837,'1','303','1',1,'Retail Sale Id 816',2203.20,0.00,0.00,3.06,153.00,'2023-01-29 09:14:43','',''),(838,'1','303','1',1,'Retail Sale Id 817',3002.40,0.00,0.00,4.17,208.50,'2023-01-29 09:18:18','',''),(839,'1','303','1',1,'Retail Sale Id 818',9000.00,0.00,0.00,12.50,625.00,'2023-01-29 09:28:08','',''),(840,'1','303','1',1,'Retail Sale Id 819',2203.20,0.00,0.00,3.06,153.00,'2023-01-29 09:38:44','',''),(841,'1','303','1',1,'Retail Sale Id 820',4320.00,0.00,0.00,6.00,300.00,'2023-01-29 09:41:06','',''),(842,'1','303','1',1,'Retail Sale Id 821',4320.00,0.00,0.00,6.00,300.00,'2023-01-29 09:50:59','',''),(843,'1','303','1',1,'Retail Sale Id 822',2203.20,0.00,0.00,3.06,153.00,'2023-01-29 10:16:32','',''),(844,'1','303','1',1,'Retail Sale Id 823',4298.40,0.00,0.00,5.97,298.50,'2023-01-29 10:18:41','',''),(845,'1','303','1',1,'Retail Sale Id 824',4320.00,0.00,0.00,6.00,300.00,'2023-01-29 10:22:14','',''),(846,'1','303','1',1,'Retail Sale Id 825',9000.00,0.00,0.00,12.50,625.00,'2023-01-29 10:23:47','',''),(847,'1','303','1',1,'Retail Sale Id 827',9000.00,0.00,0.00,12.50,625.00,'2023-01-29 10:27:29','',''),(848,'1','303','1',1,'Retail Sale Id 828',4298.40,0.00,0.00,5.97,298.50,'2023-01-29 10:31:37','',''),(849,'1','303','1',1,'Retail Sale Id 829',4298.40,0.00,0.00,5.97,298.50,'2023-01-29 10:33:59','',''),(850,'1','303','1',1,'Retail Sale Id 830',2160.00,0.00,0.00,3.00,150.00,'2023-01-29 10:41:51','',''),(851,'1','303','1',1,'Retail Sale Id 831',3600.00,0.00,0.00,5.00,250.00,'2023-01-29 10:52:33','',''),(852,'1','303','1',1,'Retail Sale Id 832',2160.00,0.00,0.00,3.00,150.00,'2023-01-29 10:57:39','',''),(853,'1','303','1',1,'Retail Sale Id 833',1000.80,0.00,0.00,1.39,69.50,'2023-01-29 10:59:55','',''),(854,'1','303','1',1,'Retail Sale Id 834',4298.40,0.00,0.00,5.97,298.50,'2023-01-29 11:13:37','',''),(855,'1','303','1',1,'Retail Sale Id 835',4399.20,0.00,0.00,6.11,305.50,'2023-01-29 11:30:32','',''),(856,'1','303','1',1,'Retail Sale Id 836',2001.60,0.00,0.00,2.78,139.00,'2023-01-29 11:38:38','',''),(857,'1','303','1',1,'Retail Sale Id 837',4320.00,0.00,0.00,6.00,300.00,'2023-01-29 11:40:32','',''),(858,'1','303','1',1,'Retail Sale Id 838',7200.00,0.00,0.00,10.00,500.00,'2023-01-29 11:48:12','',''),(859,'1','303','1',1,'Retail Sale Id 839',34500.00,0.00,0.00,50.00,1000.00,'2023-01-29 11:50:01','',''),(860,'1','303','1',1,'Retail Sale Id 841',2001.60,0.00,0.00,2.78,139.00,'2023-01-29 11:55:21','',''),(861,'1','303','1',1,'Retail Sale Id 842',2203.20,0.00,0.00,3.06,153.00,'2023-01-29 12:07:32','',''),(862,'1','303','1',1,'Retail Sale Id 843',8640.00,0.00,0.00,12.00,600.00,'2023-01-29 12:18:15','',''),(863,'1','303','1',1,'Retail Sale Id 844',4298.40,0.00,0.00,5.97,298.50,'2023-01-29 12:25:37','',''),(864,'1','303','1',1,'Retail Sale Id 846',698.40,0.00,0.00,0.97,48.50,'2023-01-29 12:28:58','',''),(865,'1','303','1',1,'Retail Sale Id 847',3600.00,0.00,0.00,5.00,250.00,'2023-01-29 12:33:34','',''),(866,'1','303','1',1,'Retail Sale Id 847',8640.00,0.00,0.00,12.00,600.00,'2023-01-29 12:33:34','',''),(867,'1','303','1',1,'Retail Sale Id 847',8640.00,0.00,0.00,12.00,600.00,'2023-01-29 12:33:34','',''),(868,'1','303','1',1,'Retail Sale Id 848',8640.00,0.00,0.00,12.00,600.00,'2023-01-29 12:34:59','',''),(869,'1','303','1',1,'Retail Sale Id 849',2203.20,0.00,0.00,3.06,153.00,'2023-01-29 12:39:37','',''),(870,'1','303','1',1,'Retail Sale Id 850',9000.00,0.00,0.00,12.50,625.00,'2023-01-29 12:49:52','',''),(871,'1','303','1',1,'Retail Sale Id 851',1447.20,0.00,0.00,2.01,100.50,'2023-01-29 12:51:04','',''),(872,'1','303','1',1,'Retail Sale Id 852',9000.00,0.00,0.00,12.50,625.00,'2023-01-29 13:11:59','',''),(873,'1','303','1',1,'Retail Sale Id 853',4298.40,0.00,0.00,5.97,298.50,'2023-01-29 13:20:19','',''),(874,'1','303','1',1,'Retail Sale Id 854',1000.80,0.00,0.00,1.39,69.50,'2023-01-29 13:56:27','',''),(875,'1','303','1',1,'Retail Sale Id 855',2203.20,0.00,0.00,3.06,153.00,'2023-01-29 13:58:14','',''),(876,'1','303','1',1,'Retail Sale Id 856',2203.20,0.00,0.00,3.06,153.00,'2023-01-29 14:04:50','',''),(877,'1','303','1',1,'Retail Sale Id 857',2160.00,0.00,0.00,3.00,150.00,'2023-01-29 14:07:04','',''),(878,'1','303','1',1,'Retail Sale Id 858',2203.20,0.00,0.00,3.06,153.00,'2023-01-29 14:14:53','',''),(879,'1','303','1',1,'Retail Sale Id 859',9000.00,0.00,0.00,12.50,625.00,'2023-01-29 14:24:06','',''),(880,'1','303','1',1,'Retail Sale Id 860',1497.60,0.00,0.00,2.08,104.00,'2023-01-29 14:25:37','',''),(881,'1','303','1',1,'Retail Sale Id 861',2203.20,0.00,0.00,3.06,153.00,'2023-01-29 14:38:33','',''),(882,'1','303','1',1,'Retail Sale Id 862',2160.00,0.00,0.00,3.00,150.00,'2023-01-29 14:43:06','',''),(883,'1','303','1',1,'Retail Sale Id 862',4320.00,0.00,0.00,6.00,300.00,'2023-01-29 14:43:06','',''),(884,'1','303','1',1,'Retail Sale Id 863',1000.80,0.00,0.00,1.39,69.50,'2023-01-29 14:44:11','',''),(885,'1','303','1',1,'Retail Sale Id 864',3600.00,0.00,0.00,5.00,250.00,'2023-01-29 14:55:55','',''),(886,'1','303','1',1,'Retail Sale Id 865',2001.60,0.00,0.00,2.78,139.00,'2023-01-29 14:57:40','',''),(887,'1','303','1',1,'Retail Sale Id 866',4197.60,0.00,0.00,5.83,291.50,'2023-01-29 15:25:26','',''),(888,'1','303','1',1,'Retail Sale Id 867',3600.00,0.00,0.00,5.00,250.00,'2023-01-29 15:29:40','',''),(889,'1','303','1',1,'Retail Sale Id 869',4298.40,0.00,0.00,5.97,298.50,'2023-01-29 15:32:01','',''),(890,'1','303','1',1,'Retail Sale Id 870',3002.40,0.00,0.00,4.17,208.50,'2023-01-29 15:35:30','',''),(891,'1','303','1',1,'Retail Sale Id 871',1000.80,0.00,0.00,1.39,69.50,'2023-01-29 15:43:40','',''),(892,'1','303','1',1,'Retail Sale Id 872',1497.60,0.00,0.00,2.08,104.00,'2023-01-29 15:45:10','',''),(893,'1','303','1',1,'Retail Sale Id 873',4298.40,0.00,0.00,5.97,298.50,'2023-01-29 16:07:52','',''),(894,'1','303','1',1,'Retail Sale Id 874',4298.40,0.00,0.00,5.97,298.50,'2023-01-29 16:11:26','',''),(895,'1','303','1',1,'Retail Sale Id 875',2160.00,0.00,0.00,3.00,150.00,'2023-01-29 16:15:40','',''),(896,'1','303','1',1,'Retail Sale Id 875',2160.00,0.00,0.00,3.00,150.00,'2023-01-29 16:15:40','',''),(897,'1','303','1',1,'Retail Sale Id 875',2160.00,0.00,0.00,3.00,150.00,'2023-01-29 16:15:40','',''),(898,'1','303','1',1,'Retail Sale Id 875',4320.00,0.00,0.00,6.00,300.00,'2023-01-29 16:15:40','',''),(899,'1','303','1',1,'Retail Sale Id 876',2001.60,0.00,0.00,2.78,139.00,'2023-01-29 16:16:59','',''),(900,'1','303','1',1,'Retail Sale Id 877',2001.60,0.00,0.00,2.78,139.00,'2023-01-29 16:18:09','',''),(901,'1','303','1',1,'Retail Sale Id 878',2901.60,0.00,0.00,4.03,201.50,'2023-01-29 16:21:06','',''),(902,'1','303','1',1,'Retail Sale Id 879',3600.00,0.00,0.00,5.00,250.00,'2023-01-29 16:24:05','',''),(903,'1','303','1',1,'Retail Sale Id 880',2001.60,0.00,0.00,2.78,139.00,'2023-01-29 16:44:18','',''),(904,'1','303','1',1,'Retail Sale Id 881',4298.40,0.00,0.00,5.97,298.50,'2023-01-29 16:45:53','',''),(905,'1','303','1',1,'Retail Sale Id 882',2001.60,0.00,0.00,2.78,139.00,'2023-01-29 16:47:25','',''),(906,'1','303','1',1,'Retail Sale Id 883',4298.40,0.00,0.00,5.97,298.50,'2023-01-29 16:58:57','',''),(907,'1','303','1',1,'Retail Sale Id 884',9000.00,0.00,0.00,12.50,625.00,'2023-01-29 17:04:21','',''),(908,'1','303','1',1,'Retail Sale Id 885',4003.20,0.00,0.00,5.56,278.00,'2023-01-29 17:06:45','',''),(909,'1','303','1',1,'Retail Sale Id 886',2160.00,0.00,0.00,3.00,150.00,'2023-01-29 17:15:58','',''),(910,'1','303','1',1,'Retail Sale Id 886',4320.00,0.00,0.00,6.00,300.00,'2023-01-29 17:15:58','',''),(911,'1','303','1',1,'Retail Sale Id 887',4802.40,0.00,0.00,6.67,333.50,'2023-01-29 17:32:29','',''),(912,'1','303','1',1,'Retail Sale Id 888',3002.40,0.00,0.00,4.17,208.50,'2023-01-29 17:34:12','',''),(913,'1','303','1',1,'Retail Sale Id 889',1000.80,0.00,0.00,1.39,69.50,'2023-01-29 17:35:37','',''),(914,'1','303','1',1,'Retail Sale Id 890',2599.20,0.00,0.00,3.61,180.50,'2023-01-29 17:54:30','',''),(915,'1','303','1',1,'Retail Sale Id 891',1497.60,0.00,0.00,2.08,104.00,'2023-01-29 17:56:50','',''),(916,'1','303','1',1,'Retail Sale Id 892',6998.40,0.00,0.00,9.72,486.00,'2023-01-29 17:59:16','',''),(917,'1','303','1',1,'Retail Sale Id 893',4500.00,0.00,0.00,6.25,312.50,'2023-01-29 18:00:48','',''),(918,'1','303','1',1,'Retail Sale Id 894',1000.80,0.00,0.00,1.39,69.50,'2023-01-29 18:06:23','',''),(919,'1','303','1',1,'Retail Sale Id 895',9000.00,0.00,0.00,12.50,625.00,'2023-01-29 18:28:30','',''),(920,'1','303','1',1,'Retail Sale Id 896',655.20,0.00,0.00,0.91,45.50,'2023-01-29 18:33:54','',''),(921,'1','303','1',1,'Retail Sale Id 897',3600.00,0.00,0.00,5.00,250.00,'2023-01-30 08:12:50','',''),(922,'1','303','1',1,'Retail Sale Id 898',9000.00,0.00,0.00,12.50,625.00,'2023-01-30 08:19:47','',''),(923,'1','303','1',1,'Retail Sale Id 899',2203.20,0.00,0.00,3.06,153.00,'2023-01-30 08:30:34','',''),(924,'1','303','1',1,'Retail Sale Id 900',3002.40,0.00,0.00,4.17,208.50,'2023-01-30 08:48:46','',''),(925,'1','303','1',1,'Retail Sale Id 901',3600.00,0.00,0.00,5.00,250.00,'2023-01-30 08:49:45','',''),(926,'1','303','1',1,'Retail Sale Id 902',3600.00,0.00,0.00,5.00,250.00,'2023-01-30 09:19:58','',''),(927,'1','303','1',1,'Retail Sale Id 903',9000.00,0.00,0.00,12.50,625.00,'2023-01-30 09:30:50','',''),(928,'1','303','1',1,'Retail Sale Id 904',2160.00,0.00,0.00,3.00,150.00,'2023-01-30 09:36:15','',''),(929,'1','303','1',1,'Retail Sale Id 905',7200.00,0.00,0.00,10.00,500.00,'2023-01-30 09:38:52','',''),(930,'1','303','1',1,'Retail Sale Id 907',1000.80,0.00,0.00,1.39,69.50,'2023-01-30 09:52:52','',''),(931,'1','303','1',1,'Retail Sale Id 907',1000.80,0.00,0.00,1.39,69.50,'2023-01-30 09:52:52','',''),(932,'1','303','1',1,'Retail Sale Id 908',2203.20,0.00,0.00,3.06,153.00,'2023-01-30 09:54:10','',''),(933,'1','303','1',1,'Retail Sale Id 909',2203.20,0.00,0.00,3.06,153.00,'2023-01-30 09:55:15','',''),(934,'1','303','1',1,'Retail Sale Id 910',4298.40,0.00,0.00,5.97,298.50,'2023-01-30 10:19:17','',''),(935,'1','303','1',1,'Retail Sale Id 911',4298.40,0.00,0.00,5.97,298.50,'2023-01-30 10:20:40','',''),(936,'1','303','1',1,'Retail Sale Id 912',2203.20,0.00,0.00,3.06,153.00,'2023-01-30 10:28:43','',''),(937,'1','303','1',1,'Retail Sale Id 913',9000.00,0.00,0.00,12.50,625.00,'2023-01-30 13:22:26','',''),(938,'1','303','1',1,'Retail Sale Id 914',3600.00,0.00,0.00,5.00,250.00,'2023-01-30 13:23:08','',''),(939,'1','303','1',1,'Retail Sale Id 915',5040.00,0.00,0.00,7.00,350.00,'2023-01-30 13:23:51','',''),(940,'1','303','1',1,'Retail Sale Id 916',3002.40,0.00,0.00,4.17,208.50,'2023-01-30 13:24:35','',''),(941,'1','303','1',1,'Retail Sale Id 917',2203.20,0.00,0.00,3.06,153.00,'2023-01-30 13:25:18','',''),(942,'1','303','1',1,'Retail Sale Id 918',4298.40,0.00,0.00,5.97,298.50,'2023-01-30 13:26:21','',''),(943,'1','303','1',1,'Retail Sale Id 919',2203.20,0.00,0.00,3.06,153.00,'2023-01-30 13:27:27','',''),(944,'1','303','1',1,'Retail Sale Id 920',9000.00,0.00,0.00,12.50,625.00,'2023-01-30 13:28:05','',''),(945,'1','303','1',1,'Retail Sale Id 921',1000.80,0.00,0.00,1.39,69.50,'2023-01-30 13:28:55','',''),(946,'1','303','1',1,'Retail Sale Id 922',2498.40,0.00,0.00,3.47,173.50,'2023-01-30 13:29:56','',''),(947,'1','303','1',1,'Retail Sale Id 923',1497.60,0.00,0.00,2.08,104.00,'2023-01-30 13:30:31','',''),(948,'1','303','1',1,'Retail Sale Id 924',4298.40,0.00,0.00,5.97,298.50,'2023-01-30 13:31:23','',''),(949,'1','303','1',1,'Retail Sale Id 925',4320.00,0.00,0.00,6.00,300.00,'2023-01-30 13:32:00','',''),(950,'1','303','1',1,'Retail Sale Id 926',1497.60,0.00,0.00,2.08,104.00,'2023-01-30 13:32:35','',''),(951,'1','303','1',1,'Retail Sale Id 927',1000.80,0.00,0.00,1.39,69.50,'2023-01-30 13:33:20','',''),(952,'1','303','1',1,'Retail Sale Id 928',2203.20,0.00,0.00,3.06,153.00,'2023-01-30 13:33:53','',''),(953,'1','303','1',1,'Retail Sale Id 929',2203.20,0.00,0.00,3.06,153.00,'2023-01-30 13:34:27','',''),(954,'1','303','1',1,'Retail Sale Id 930',2203.20,0.00,0.00,3.06,153.00,'2023-01-30 13:35:02','',''),(955,'1','303','1',1,'Retail Sale Id 931',4298.40,0.00,0.00,5.97,298.50,'2023-01-30 13:35:34','',''),(956,'1','303','1',1,'Retail Sale Id 932',4320.00,0.00,0.00,6.00,300.00,'2023-01-30 13:36:09','',''),(957,'1','303','1',1,'Retail Sale Id 933',34500.00,0.00,0.00,50.00,1000.00,'2023-01-30 15:11:10','',''),(958,'1','303','1',1,'Retail Sale Id 934',69000.00,0.00,0.00,100.00,2000.00,'2023-01-30 15:53:51','',''),(959,'1','303','1',1,'Retail Sale Id 935',1497.60,0.00,0.00,2.08,104.00,'2023-01-30 15:55:00','',''),(960,'1','303','1',1,'Retail Sale Id 936',1000.80,0.00,0.00,1.39,69.50,'2023-01-30 15:57:51','',''),(961,'1','303','1',1,'Retail Sale Id 937',9000.00,0.00,0.00,12.50,625.00,'2023-01-30 15:58:32','',''),(962,'1','303','1',1,'Retail Sale Id 938',1497.60,0.00,0.00,2.08,104.00,'2023-01-30 15:59:23','',''),(963,'1','303','1',1,'Retail Sale Id 939',4320.00,0.00,0.00,6.00,300.00,'2023-01-30 16:38:54','',''),(964,'1','303','1',1,'Retail Sale Id 941',2001.60,0.00,0.00,2.78,139.00,'2023-01-30 16:43:30','',''),(965,'1','303','1',1,'Retail Sale Id 942',9000.00,0.00,0.00,12.50,625.00,'2023-01-30 16:44:13','',''),(966,'1','303','1',1,'Retail Sale Id 943',8640.00,0.00,0.00,12.00,600.00,'2023-01-30 16:45:08','',''),(967,'1','303','1',1,'Retail Sale Id 944',2203.20,0.00,0.00,3.06,153.00,'2023-01-30 16:47:47','',''),(968,'1','303','1',1,'Retail Sale Id 945',9000.00,0.00,0.00,12.50,625.00,'2023-01-30 16:48:58','',''),(969,'1','303','1',1,'Retail Sale Id 946',4320.00,0.00,0.00,6.00,300.00,'2023-01-30 16:49:44','',''),(970,'1','303','1',1,'Retail Sale Id 947',1440.00,0.00,0.00,2.00,100.00,'2023-01-30 16:50:27','',''),(971,'1','303','1',1,'Retail Sale Id 948',4320.00,0.00,0.00,6.00,300.00,'2023-01-30 16:51:36','',''),(972,'1','303','1',1,'Retail Sale Id 949',2160.00,0.00,0.00,3.00,150.00,'2023-01-30 16:52:21','',''),(973,'1','303','1',1,'Retail Sale Id 950',1000.80,0.00,0.00,1.39,69.50,'2023-01-30 16:53:07','',''),(974,'1','303','1',1,'Retail Sale Id 951',2160.00,0.00,0.00,3.00,150.00,'2023-01-30 16:54:09','',''),(975,'1','303','1',1,'Retail Sale Id 952',2160.00,0.00,0.00,3.00,150.00,'2023-01-30 16:55:17','',''),(976,'1','303','1',1,'Retail Sale Id 953',9000.00,0.00,0.00,12.50,625.00,'2023-01-30 16:56:19','',''),(977,'1','303','1',1,'Retail Sale Id 954',7200.00,0.00,0.00,10.00,500.00,'2023-01-30 16:56:57','',''),(978,'1','303','1',1,'Retail Sale Id 955',4320.00,0.00,0.00,6.00,300.00,'2023-01-30 16:57:58','',''),(979,'1','303','1',1,'Retail Sale Id 956',9000.00,0.00,0.00,12.50,625.00,'2023-01-30 16:59:59','',''),(980,'1','303','1',1,'Retail Sale Id 957',9000.00,0.00,0.00,12.50,625.00,'2023-01-30 17:00:48','',''),(981,'1','303','1',1,'Retail Sale Id 958',4003.20,0.00,0.00,5.56,278.00,'2023-01-30 17:01:35','',''),(982,'1','303','1',1,'Retail Sale Id 959',4996.80,0.00,0.00,6.94,347.00,'2023-01-30 17:02:26','',''),(983,'1','303','1',1,'Retail Sale Id 961',2001.60,0.00,0.00,2.78,139.00,'2023-01-30 17:03:11','',''),(984,'1','303','1',1,'Retail Sale Id 962',4298.40,0.00,0.00,5.97,298.50,'2023-01-30 17:06:29','',''),(985,'1','303','1',1,'Retail Sale Id 963',3002.40,0.00,0.00,4.17,208.50,'2023-01-30 17:07:37','',''),(986,'1','303','1',1,'Retail Sale Id 964',2203.20,0.00,0.00,3.06,153.00,'2023-01-30 17:12:36','',''),(987,'1','303','1',1,'Retail Sale Id 965',3600.00,0.00,0.00,5.00,250.00,'2023-01-30 17:13:58','',''),(988,'1','303','1',1,'Retail Sale Id 966',1497.60,0.00,0.00,2.08,104.00,'2023-01-30 17:15:19','',''),(989,'1','303','1',1,'Retail Sale Id 967',4039.20,0.00,0.00,5.61,280.50,'2023-01-30 17:30:11','',''),(990,'1','303','1',1,'Retail Sale Id 968',1000.80,0.00,0.00,1.39,69.50,'2023-01-30 17:31:16','',''),(991,'1','303','1',1,'Retail Sale Id 969',4320.00,0.00,0.00,6.00,300.00,'2023-01-30 17:33:39','',''),(992,'1','303','1',1,'Retail Sale Id 970',4320.00,0.00,0.00,6.00,300.00,'2023-01-30 17:37:52','',''),(993,'1','303','1',1,'Retail Sale Id 971',2160.00,0.00,0.00,3.00,150.00,'2023-01-30 17:49:02','',''),(994,'1','303','1',1,'Retail Sale Id 972',4320.00,0.00,0.00,6.00,300.00,'2023-01-30 17:53:18','',''),(995,'1','303','1',1,'Retail Sale Id 973',2203.20,0.00,0.00,3.06,153.00,'2023-01-30 17:58:49','',''),(996,'1','303','1',1,'Retail Sale Id 974',4320.00,0.00,0.00,6.00,300.00,'2023-01-30 18:00:04','',''),(997,'1','303','1',1,'Retail Sale Id 977',9000.00,0.00,0.00,12.50,625.00,'2023-01-30 18:29:35','',''),(998,'1','303','1',1,'Retail Sale Id 979',4320.00,0.00,0.00,6.00,300.00,'2023-01-30 18:39:48','',''),(999,'1','303','1',1,'Retail Sale Id 980',2001.60,0.00,0.00,2.78,139.00,'2023-01-30 18:40:58','',''),(1000,'1','303','1',1,'Return of Retail Sale Id 977',0.00,9000.00,12.50,0.00,-625.00,'2023-01-30 19:44:08','',''),(1001,'1','303','1',1,'Return of Retail Sale Id 959',0.00,4996.80,6.94,0.00,-347.00,'2023-01-30 19:55:24','',''),(1002,'1','303','1',1,'Retail Sale Id 982',129.60,0.00,0.00,0.18,9.00,'2023-01-30 20:00:02','',''),(1003,'1','303','1',1,'Retail Sale Id 983',1440.00,0.00,0.00,2.00,100.00,'2023-01-31 08:43:08','',''),(1004,'1','303','1',1,'Retail Sale Id 984',2160.00,0.00,0.00,3.00,150.00,'2023-01-31 08:51:59','',''),(1005,'1','303','1',1,'Retail Sale Id 985',2102.40,0.00,0.00,2.92,146.00,'2023-01-31 08:53:32','',''),(1006,'1','303','1',1,'Retail Sale Id 986',2203.20,0.00,0.00,3.06,153.00,'2023-01-31 08:57:25','',''),(1007,'1','303','1',1,'Retail Sale Id 987',2160.00,0.00,0.00,3.00,150.00,'2023-01-31 09:16:26','',''),(1008,'1','303','1',1,'Retail Sale Id 988',4399.20,0.00,0.00,6.11,305.50,'2023-01-31 09:36:28','',''),(1009,'1','303','1',1,'Retail Sale Id 989',3600.00,0.00,0.00,5.00,250.00,'2023-01-31 09:52:25','',''),(1010,'1','303','1',1,'Retail Sale Id 990',2001.60,0.00,0.00,2.78,139.00,'2023-01-31 10:21:30','',''),(1011,'1','303','1',1,'Retail Sale Id 991',3499.20,0.00,0.00,4.86,243.00,'2023-01-31 10:26:33','',''),(1012,'1','303','1',1,'Retail Sale Id 992',34500.00,0.00,0.00,50.00,1000.00,'2023-01-31 10:54:03','',''),(1013,'1','303','1',1,'Retail Sale Id 993',200100.00,0.00,0.00,290.00,5800.00,'2023-01-31 10:57:47','',''),(1014,'1','303','1',1,'Retail Sale Id 994',2160.00,0.00,0.00,3.00,150.00,'2023-01-31 11:02:18','',''),(1015,'1','303','1',1,'Retail Sale Id 995',2160.00,0.00,0.00,3.00,150.00,'2023-01-31 11:04:47','',''),(1016,'1','303','1',1,'Retail Sale Id 996',1440.00,0.00,0.00,2.00,100.00,'2023-01-31 11:13:55','',''),(1017,'1','303','1',1,'Retail Sale Id 997',7999.20,0.00,0.00,11.11,555.50,'2023-01-31 11:22:26','',''),(1018,'1','303','1',1,'Retail Sale Id 998',2152.80,0.00,0.00,2.99,149.50,'2023-01-31 11:27:05','',''),(1019,'1','303','1',1,'Retail Sale Id 999',4320.00,0.00,0.00,6.00,300.00,'2023-01-31 11:28:42','',''),(1020,'1','303','1',1,'Retail Sale Id 1000',4298.40,0.00,0.00,5.97,298.50,'2023-01-31 11:32:44','',''),(1021,'1','303','1',1,'Retail Sale Id 1001',4320.00,0.00,0.00,6.00,300.00,'2023-01-31 11:38:52','',''),(1022,'1','303','1',1,'Retail Sale Id 1002',7200.00,0.00,0.00,10.00,500.00,'2023-01-31 11:40:18','',''),(1023,'1','303','1',1,'Retail Sale Id 1003',2203.20,0.00,0.00,3.06,153.00,'2023-01-31 12:34:21','',''),(1024,'1','303','1',1,'Retail Sale Id 1004',9000.00,0.00,0.00,12.50,625.00,'2023-01-31 13:07:14','',''),(1025,'1','303','1',1,'Retail Sale Id 1005',9000.00,0.00,0.00,12.50,625.00,'2023-01-31 13:17:59','',''),(1026,'1','303','1',1,'Retail Sale Id 1006',1497.60,0.00,0.00,2.08,104.00,'2023-01-31 13:36:15','',''),(1027,'1','303','1',1,'Retail Sale Id 1007',5040.00,0.00,0.00,7.00,350.00,'2023-01-31 13:51:39','',''),(1028,'1','303','1',1,'Retail Sale Id 1008',4320.00,0.00,0.00,6.00,300.00,'2023-01-31 14:07:43','',''),(1029,'1','303','1',1,'Retail Sale Id 1009',3600.00,0.00,0.00,5.00,250.00,'2023-01-31 14:15:23','',''),(1030,'1','303','1',1,'Retail Sale Id 1010',4320.00,0.00,0.00,6.00,300.00,'2023-01-31 14:42:57','',''),(1031,'1','303','1',1,'Retail Sale Id 1011',9000.00,0.00,0.00,12.50,625.00,'2023-01-31 15:10:04','',''),(1032,'1','303','1',1,'Retail Sale Id 1012',2203.20,0.00,0.00,3.06,153.00,'2023-01-31 15:51:42','',''),(1033,'1','303','1',1,'Retail Sale Id 1013',2160.00,0.00,0.00,3.00,150.00,'2023-01-31 15:53:19','',''),(1034,'1','303','1',1,'Retail Sale Id 1014',4320.00,0.00,0.00,6.00,300.00,'2023-01-31 15:56:19','',''),(1035,'1','303','1',1,'Retail Sale Id 1016',2203.20,0.00,0.00,3.06,153.00,'2023-01-31 16:07:16','',''),(1036,'1','303','1',1,'Retail Sale Id 1017',9000.00,0.00,0.00,12.50,625.00,'2023-01-31 16:24:45','',''),(1037,'1','303','1',1,'Retail Sale Id 1018',2203.20,0.00,0.00,3.06,153.00,'2023-01-31 16:28:17','',''),(1038,'1','303','1',1,'Retail Sale Id 1020',4320.00,0.00,0.00,6.00,300.00,'2023-01-31 16:46:41','',''),(1039,'1','303','1',1,'Retail Sale Id 1021',1497.60,0.00,0.00,2.08,104.00,'2023-01-31 16:51:13','',''),(1040,'1','303','1',1,'Retail Sale Id 1022',4320.00,0.00,0.00,6.00,300.00,'2023-01-31 16:53:18','',''),(1041,'1','303','1',1,'Retail Sale Id 1023',1497.60,0.00,0.00,2.08,104.00,'2023-01-31 16:58:40','',''),(1042,'1','303','1',1,'Retail Sale Id 1024',2001.60,0.00,0.00,2.78,139.00,'2023-01-31 17:03:22','',''),(1043,'1','303','1',1,'Retail Sale Id 1025',3600.00,0.00,0.00,5.00,250.00,'2023-01-31 17:14:19','',''),(1044,'1','303','1',1,'Retail Sale Id 1026',1440.00,0.00,0.00,2.00,100.00,'2023-01-31 17:16:45','',''),(1045,'1','303','1',1,'Retail Sale Id 1026',4320.00,0.00,0.00,6.00,300.00,'2023-01-31 17:16:45','',''),(1046,'1','303','1',1,'Retail Sale Id 1027',4320.00,0.00,0.00,6.00,300.00,'2023-01-31 17:23:51','',''),(1047,'1','303','1',1,'Retail Sale Id 1028',1000.80,0.00,0.00,1.39,69.50,'2023-01-31 17:48:09','',''),(1048,'1','303','1',1,'Retail Sale Id 1029',4197.60,0.00,0.00,5.83,291.50,'2023-01-31 17:57:58','',''),(1049,'1','303','1',1,'Retail Sale Id 1030',2160.00,0.00,0.00,3.00,150.00,'2023-01-31 18:05:17','',''),(1050,'1','303','1',1,'Retail Sale Id 1030',2160.00,0.00,0.00,3.00,150.00,'2023-01-31 18:05:17','',''),(1051,'1','303','1',1,'Return of Retail Sale Id 1027',0.00,4320.00,6.00,0.00,-300.00,'2023-01-31 18:36:38','',''),(1052,'1','303','1',1,'Retail Sale Id 1031',1360.80,0.00,0.00,1.89,94.50,'2023-01-31 18:38:09','',''),(1053,'1','303','1',1,'Retail Sale Id 1032',4320.00,0.00,0.00,6.00,300.00,'2023-02-01 08:04:41','',''),(1054,'1','303','1',1,'Retail Sale Id 1033',9000.00,0.00,0.00,12.50,625.00,'2023-02-01 08:37:45','',''),(1055,'1','303','1',1,'Retail Sale Id 1034',2203.20,0.00,0.00,3.06,153.00,'2023-02-01 09:20:16','',''),(1056,'1','303','1',1,'Retail Sale Id 1035',2203.20,0.00,0.00,3.06,153.00,'2023-02-01 09:37:17','',''),(1057,'1','303','1',1,'Retail Sale Id 1036',34500.00,0.00,0.00,50.00,1000.00,'2023-02-01 09:49:52','',''),(1058,'1','303','1',1,'Retail Sale Id 1038',1440.00,0.00,0.00,2.00,100.00,'2023-02-01 10:04:14','',''),(1059,'1','303','1',1,'Retail Sale Id 1039',34500.00,0.00,0.00,50.00,1000.00,'2023-02-01 10:07:59','',''),(1060,'1','303','1',1,'Retail Sale Id 1042',2160.00,0.00,0.00,3.00,150.00,'2023-02-01 10:53:50','',''),(1061,'1','303','1',1,'Retail Sale Id 1043',2001.60,0.00,0.00,2.78,139.00,'2023-02-01 10:55:11','',''),(1062,'1','303','1',1,'Retail Sale Id 1044',1497.60,0.00,0.00,2.08,104.00,'2023-02-01 11:06:19','',''),(1063,'1','303','1',1,'Retail Sale Id 1045',24998.70,0.00,0.00,36.23,724.60,'2023-02-01 11:09:08','',''),(1064,'1','303','1',1,'Retail Sale Id 1046',34500.00,0.00,0.00,50.00,1000.00,'2023-02-01 11:13:04','',''),(1065,'1','303','1',1,'Retail Sale Id 1047',9000.00,0.00,0.00,12.50,625.00,'2023-02-01 11:14:47','',''),(1066,'1','303','1',1,'Retail Sale Id 1048',4320.00,0.00,0.00,6.00,300.00,'2023-02-01 11:18:07','',''),(1067,'1','303','1',1,'Retail Sale Id 1049',2001.60,0.00,0.00,2.78,139.00,'2023-02-01 11:23:41','',''),(1068,'1','303','1',1,'Retail Sale Id 1050',4320.00,0.00,0.00,6.00,300.00,'2023-02-01 11:25:03','',''),(1069,'1','303','1',1,'Retail Sale Id 1051',9000.00,0.00,0.00,12.50,625.00,'2023-02-01 11:49:44','',''),(1070,'1','303','1',1,'Retail Sale Id 1052',4320.00,0.00,0.00,6.00,300.00,'2023-02-01 11:53:58','',''),(1071,'1','303','1',1,'Retail Sale Id 1053',2160.00,0.00,0.00,3.00,150.00,'2023-02-01 11:58:23','',''),(1072,'1','303','1',1,'Retail Sale Id 1053',4320.00,0.00,0.00,6.00,300.00,'2023-02-01 11:58:23','',''),(1073,'1','303','1',1,'Retail Sale Id 1054',3600.00,0.00,0.00,5.00,250.00,'2023-02-01 12:02:15','',''),(1074,'1','303','1',1,'Retail Sale Id 1055',34500.00,0.00,0.00,50.00,1000.00,'2023-02-01 12:08:51','',''),(1075,'1','303','1',1,'Retail Sale Id 1056',4320.00,0.00,0.00,6.00,300.00,'2023-02-01 12:44:34','',''),(1076,'1','303','1',1,'Retail Sale Id 1057',2160.00,0.00,0.00,3.00,150.00,'2023-02-01 12:50:51','',''),(1077,'1','303','1',1,'Retail Sale Id 1058',4003.20,0.00,0.00,5.56,278.00,'2023-02-01 12:53:01','',''),(1078,'1','303','1',1,'Retail Sale Id 1059',2160.00,0.00,0.00,3.00,150.00,'2023-02-01 13:01:06','',''),(1079,'1','303','1',1,'Retail Sale Id 1060',3600.00,0.00,0.00,5.00,250.00,'2023-02-01 13:03:26','',''),(1080,'1','303','1',1,'Retail Sale Id 1061',4320.00,0.00,0.00,6.00,300.00,'2023-02-01 13:08:43','',''),(1081,'1','303','1',1,'Retail Sale Id 1062',2880.00,0.00,0.00,4.00,200.00,'2023-02-01 13:10:39','',''),(1082,'1','303','1',1,'Retail Sale Id 1063',69000.00,0.00,0.00,100.00,2000.00,'2023-02-01 13:14:50','',''),(1083,'1','303','1',1,'Retail Sale Id 1064',2160.00,0.00,0.00,3.00,150.00,'2023-02-01 13:54:38','',''),(1084,'1','303','1',1,'Retail Sale Id 1065',2160.00,0.00,0.00,3.00,150.00,'2023-02-01 14:03:13','',''),(1085,'1','303','1',1,'Retail Sale Id 1066',2880.00,0.00,0.00,4.00,200.00,'2023-02-01 14:13:16','',''),(1086,'1','303','1',1,'Retail Sale Id 1067',2160.00,0.00,0.00,3.00,150.00,'2023-02-01 14:23:11','',''),(1087,'1','303','1',1,'Retail Sale Id 1068',4298.40,0.00,0.00,5.97,298.50,'2023-02-01 14:31:15','',''),(1088,'1','303','1',1,'Retail Sale Id 1069',4320.00,0.00,0.00,6.00,300.00,'2023-02-01 14:55:04','',''),(1089,'1','303','1',1,'Retail Sale Id 1070',9000.00,0.00,0.00,12.50,625.00,'2023-02-01 15:15:23','',''),(1090,'1','303','1',1,'Retail Sale Id 1071',2160.00,0.00,0.00,3.00,150.00,'2023-02-01 15:19:08','',''),(1091,'1','303','1',1,'Retail Sale Id 1072',3600.00,0.00,0.00,5.00,250.00,'2023-02-01 15:21:42','',''),(1092,'1','303','1',1,'Retail Sale Id 1074',2160.00,0.00,0.00,3.00,150.00,'2023-02-01 15:36:51','',''),(1093,'1','303','1',1,'Retail Sale Id 1075',2001.60,0.00,0.00,2.78,139.00,'2023-02-01 15:38:13','',''),(1094,'1','303','1',1,'Retail Sale Id 1076',4320.00,0.00,0.00,6.00,300.00,'2023-02-01 15:43:15','',''),(1095,'1','303','1',1,'Retail Sale Id 1077',1440.00,0.00,0.00,2.00,100.00,'2023-02-01 16:05:20','',''),(1096,'1','303','1',1,'Retail Sale Id 1078',7200.00,0.00,0.00,10.00,500.00,'2023-02-01 16:06:46','',''),(1097,'1','303','1',1,'Retail Sale Id 1079',1497.60,0.00,0.00,2.08,104.00,'2023-02-01 16:07:53','',''),(1098,'1','303','1',1,'Retail Sale Id 1080',4320.00,0.00,0.00,6.00,300.00,'2023-02-01 16:11:37','',''),(1099,'1','303','1',1,'Retail Sale Id 1081',4320.00,0.00,0.00,6.00,300.00,'2023-02-01 16:21:46','',''),(1100,'1','303','1',1,'Retail Sale Id 1082',4320.00,0.00,0.00,6.00,300.00,'2023-02-01 16:23:40','',''),(1101,'1','303','1',1,'Retail Sale Id 1083',2160.00,0.00,0.00,3.00,150.00,'2023-02-01 16:40:02','',''),(1102,'1','303','1',1,'Retail Sale Id 1084',1000.80,0.00,0.00,1.39,69.50,'2023-02-01 16:59:54','',''),(1103,'1','303','1',1,'Retail Sale Id 1085',9000.00,0.00,0.00,12.50,625.00,'2023-02-01 17:04:11','',''),(1104,'1','303','1',1,'Retail Sale Id 1086',2880.00,0.00,0.00,4.00,200.00,'2023-02-01 17:34:03','',''),(1105,'1','303','1',1,'Retail Sale Id 1087',2160.00,0.00,0.00,3.00,150.00,'2023-02-01 18:02:50','',''),(1106,'1','303','1',1,'Retail Sale Id 1088',4320.00,0.00,0.00,6.00,300.00,'2023-02-01 18:13:48','',''),(1107,'1','303','1',1,'Retail Sale Id 1089',1252.80,0.00,0.00,1.74,87.00,'2023-02-01 18:40:05','',''),(1108,'1','303','1',1,'Retail Sale Id 1090',9000.00,0.00,0.00,12.50,625.00,'2023-02-02 09:37:42','',''),(1109,'1','303','1',1,'Retail Sale Id 1091',34500.00,0.00,0.00,50.00,1000.00,'2023-02-02 09:41:49','',''),(1110,'1','303','1',1,'Retail Sale Id 1092',4320.00,0.00,0.00,6.00,300.00,'2023-02-02 09:48:27','',''),(1111,'1','303','1',1,'Retail Sale Id 1093',2498.40,0.00,0.00,3.47,173.50,'2023-02-02 09:54:50','',''),(1112,'1','303','1',1,'Retail Sale Id 1094',4320.00,0.00,0.00,6.00,300.00,'2023-02-02 09:57:02','',''),(1113,'1','303','1',1,'Retail Sale Id 1095',698.40,0.00,0.00,0.97,48.50,'2023-02-02 09:58:55','',''),(1114,'1','303','1',1,'Retail Sale Id 1096',9000.00,0.00,0.00,12.50,625.00,'2023-02-02 10:03:49','',''),(1115,'1','303','1',1,'Retail Sale Id 1097',1202.40,0.00,0.00,1.67,83.50,'2023-02-02 10:06:11','',''),(1116,'1','303','1',1,'Retail Sale Id 1098',2160.00,0.00,0.00,3.00,150.00,'2023-02-02 10:16:02','',''),(1117,'1','303','1',1,'Retail Sale Id 1099',1699.20,0.00,0.00,2.36,118.00,'2023-02-02 10:46:37','',''),(1118,'1','303','1',1,'Retail Sale Id 1100',4320.00,0.00,0.00,6.00,300.00,'2023-02-02 10:57:22','',''),(1119,'1','303','1',1,'Retail Sale Id 1101',2001.60,0.00,0.00,2.78,139.00,'2023-02-02 11:33:03','',''),(1120,'1','303','1',1,'Retail Sale Id 1102',2160.00,0.00,0.00,3.00,150.00,'2023-02-02 11:53:07','',''),(1121,'1','303','1',1,'Retail Sale Id 1103',7200.00,0.00,0.00,10.00,500.00,'2023-02-02 12:01:50','',''),(1122,'1','303','1',1,'Retail Sale Id 1104',2160.00,0.00,0.00,3.00,150.00,'2023-02-02 12:04:13','',''),(1123,'1','303','1',1,'Retail Sale Id 1105',3600.00,0.00,0.00,5.00,250.00,'2023-02-02 12:14:57','',''),(1124,'1','303','1',1,'Retail Sale Id 1107',2160.00,0.00,0.00,3.00,150.00,'2023-02-02 12:23:18','',''),(1125,'1','303','1',1,'Retail Sale Id 1107',5040.00,0.00,0.00,7.00,350.00,'2023-02-02 12:23:18','',''),(1126,'1','303','1',1,'Retail Sale Id 1108',1497.60,0.00,0.00,2.08,104.00,'2023-02-02 12:25:33','',''),(1127,'1','303','1',1,'Retail Sale Id 1109',4320.00,0.00,0.00,6.00,300.00,'2023-02-02 12:44:43','',''),(1128,'1','303','1',1,'Retail Sale Id 1110',1497.60,0.00,0.00,2.08,104.00,'2023-02-02 12:49:16','',''),(1129,'1','303','1',1,'Retail Sale Id 1111',4320.00,0.00,0.00,6.00,300.00,'2023-02-02 13:16:12','',''),(1130,'1','303','1',1,'Retail Sale Id 1112',4320.00,0.00,0.00,6.00,300.00,'2023-02-02 13:25:05','',''),(1131,'1','303','1',1,'Retail Sale Id 1113',4320.00,0.00,0.00,6.00,300.00,'2023-02-02 13:34:30','',''),(1132,'1','303','1',1,'Retail Sale Id 1114',4320.00,0.00,0.00,6.00,300.00,'2023-02-02 13:38:50','',''),(1133,'1','303','1',1,'Retail Sale Id 1116',9000.00,0.00,0.00,12.50,625.00,'2023-02-02 13:45:04','',''),(1134,'1','303','1',1,'Retail Sale Id 1117',2160.00,0.00,0.00,3.00,150.00,'2023-02-02 13:47:04','',''),(1135,'1','303','1',1,'Retail Sale Id 1118',103500.00,0.00,0.00,150.00,3000.00,'2023-02-02 13:55:40','',''),(1136,'1','303','1',1,'Retail Sale Id 1119',2880.00,0.00,0.00,4.00,200.00,'2023-02-02 14:06:16','',''),(1137,'1','303','1',1,'Retail Sale Id 1120',6120.00,0.00,0.00,8.50,425.00,'2023-02-02 14:15:44','',''),(1138,'1','303','1',1,'Retail Sale Id 1121',4320.00,0.00,0.00,6.00,300.00,'2023-02-02 14:20:22','',''),(1139,'1','303','1',1,'Retail Sale Id 1122',4320.00,0.00,0.00,6.00,300.00,'2023-02-02 14:24:41','',''),(1140,'1','303','1',1,'Retail Sale Id 1123',1000.80,0.00,0.00,1.39,69.50,'2023-02-02 14:29:44','',''),(1141,'1','303','1',1,'Retail Sale Id 1124',9000.00,0.00,0.00,12.50,625.00,'2023-02-02 14:42:52','',''),(1142,'1','303','1',1,'Retail Sale Id 1125',9000.00,0.00,0.00,12.50,625.00,'2023-02-02 14:50:45','',''),(1143,'1','303','1',1,'Retail Sale Id 1126',4320.00,0.00,0.00,6.00,300.00,'2023-02-02 15:32:49','',''),(1144,'1','303','1',1,'Retail Sale Id 1127',3600.00,0.00,0.00,5.00,250.00,'2023-02-02 15:37:04','',''),(1145,'1','303','1',1,'Retail Sale Id 1128',4320.00,0.00,0.00,6.00,300.00,'2023-02-02 15:38:19','',''),(1146,'1','303','1',1,'Retail Sale Id 1129',2160.00,0.00,0.00,3.00,150.00,'2023-02-02 15:40:35','',''),(1147,'1','303','1',1,'Retail Sale Id 1130',720.00,0.00,0.00,1.00,50.00,'2023-02-02 15:42:03','',''),(1148,'1','303','1',1,'Retail Sale Id 1132',3600.00,0.00,0.00,5.00,250.00,'2023-02-02 16:02:45','',''),(1149,'1','303','1',1,'Retail Sale Id 1133',3600.00,0.00,0.00,5.00,250.00,'2023-02-02 16:07:45','',''),(1150,'1','303','1',1,'Retail Sale Id 1134',793500.00,0.00,0.00,1150.00,23000.00,'2023-02-02 16:09:48','',''),(1151,'1','303','1',1,'Retail Sale Id 1135',2160.00,0.00,0.00,3.00,150.00,'2023-02-02 16:13:22','',''),(1152,'1','303','1',1,'Retail Sale Id 1136',2160.00,0.00,0.00,3.00,150.00,'2023-02-02 16:15:38','',''),(1153,'1','303','1',1,'Retail Sale Id 1137',3600.00,0.00,0.00,5.00,250.00,'2023-02-02 16:21:42','',''),(1154,'1','303','1',1,'Retail Sale Id 1138',2160.00,0.00,0.00,3.00,150.00,'2023-02-02 16:26:30','',''),(1155,'1','303','1',1,'Retail Sale Id 1139',720.00,0.00,0.00,1.00,50.00,'2023-02-02 16:34:18','',''),(1156,'1','303','1',1,'Retail Sale Id 1140',3002.40,0.00,0.00,4.17,208.50,'2023-02-02 16:40:37','',''),(1157,'1','303','1',1,'Retail Sale Id 1141',496.80,0.00,0.00,0.69,34.50,'2023-02-02 16:42:30','',''),(1158,'1','303','1',1,'Retail Sale Id 1142',2160.00,0.00,0.00,3.00,150.00,'2023-02-02 16:43:57','',''),(1159,'1','303','1',1,'Retail Sale Id 1143',4320.00,0.00,0.00,6.00,300.00,'2023-02-02 16:45:34','',''),(1160,'1','303','1',1,'Retail Sale Id 1144',1497.60,0.00,0.00,2.08,104.00,'2023-02-02 16:59:25','',''),(1161,'1','303','1',1,'Retail Sale Id 1145',4320.00,0.00,0.00,6.00,300.00,'2023-02-02 17:13:18','',''),(1162,'1','303','1',1,'Retail Sale Id 1146',3600.00,0.00,0.00,5.00,250.00,'2023-02-02 17:15:21','',''),(1163,'1','303','1',1,'Retail Sale Id 1147',4320.00,0.00,0.00,6.00,300.00,'2023-02-02 17:22:34','',''),(1164,'1','303','1',1,'Retail Sale Id 1148',4320.00,0.00,0.00,6.00,300.00,'2023-02-02 17:52:08','',''),(1165,'1','303','1',1,'Retail Sale Id 1149',2901.60,0.00,0.00,4.03,201.50,'2023-02-02 18:02:30','',''),(1166,'1','303','1',1,'Retail Sale Id 1150',4320.00,0.00,0.00,6.00,300.00,'2023-02-02 18:10:54','',''),(1167,'1','303','1',1,'Return of Retail Sale Id 1118',0.00,103500.00,150.00,0.00,-3000.00,'2023-02-02 22:25:41','',''),(1168,'1','303','1',1,'Return of Retail Sale Id 1149',0.00,2901.60,4.03,0.00,-201.50,'2023-02-02 22:27:00','',''),(1169,'1','303','1',1,'Retail Sale Id 1151',504.00,0.00,0.00,0.70,35.00,'2023-02-02 22:28:53','',''),(1170,'1','303','1',1,'Retail Sale Id 1152',1000.80,0.00,0.00,1.39,69.50,'2023-02-03 08:56:48','',''),(1171,'1','303','1',1,'Retail Sale Id 1153',5040.00,0.00,0.00,7.00,350.00,'2023-02-03 08:59:06','',''),(1172,'1','303','1',1,'Retail Sale Id 1154',3297.60,0.00,0.00,4.58,229.00,'2023-02-03 09:01:22','',''),(1173,'1','303','1',1,'Retail Sale Id 1155',9000.00,0.00,0.00,12.50,625.00,'2023-02-03 09:08:36','',''),(1174,'1','303','1',1,'Retail Sale Id 1156',2160.00,0.00,0.00,3.00,150.00,'2023-02-03 09:16:09','',''),(1175,'1','303','1',1,'Retail Sale Id 1157',4320.00,0.00,0.00,6.00,300.00,'2023-02-03 09:28:37','',''),(1176,'1','303','1',1,'Retail Sale Id 1158',1440.00,0.00,0.00,2.00,100.00,'2023-02-03 09:41:28','',''),(1177,'1','303','1',1,'Retail Sale Id 1159',4320.00,0.00,0.00,6.00,300.00,'2023-02-03 09:47:29','',''),(1178,'1','303','1',1,'Retail Sale Id 1160',4320.00,0.00,0.00,6.00,300.00,'2023-02-03 09:48:32','',''),(1179,'1','303','1',1,'Retail Sale Id 1161',4320.00,0.00,0.00,6.00,300.00,'2023-02-03 10:01:54','',''),(1180,'1','303','1',1,'Retail Sale Id 1161',9000.00,0.00,0.00,12.50,625.00,'2023-02-03 10:01:54','',''),(1181,'1','303','1',1,'Retail Sale Id 1162',1202.40,0.00,0.00,1.67,83.50,'2023-02-03 10:04:29','',''),(1182,'1','303','1',1,'Retail Sale Id 1163',4320.00,0.00,0.00,6.00,300.00,'2023-02-03 10:05:44','',''),(1183,'1','303','1',1,'Retail Sale Id 1164',3600.00,0.00,0.00,5.00,250.00,'2023-02-03 10:08:38','',''),(1184,'1','303','1',1,'Retail Sale Id 1165',2160.00,0.00,0.00,3.00,150.00,'2023-02-03 10:10:29','',''),(1185,'1','303','1',1,'Retail Sale Id 1166',2160.00,0.00,0.00,3.00,150.00,'2023-02-03 10:12:31','',''),(1186,'1','303','1',1,'Retail Sale Id 1167',2160.00,0.00,0.00,3.00,150.00,'2023-02-03 10:22:44','',''),(1187,'1','303','1',1,'Retail Sale Id 1168',34500.00,0.00,0.00,50.00,1000.00,'2023-02-03 10:26:56','',''),(1188,'1','303','1',1,'Retail Sale Id 1169',34500.00,0.00,0.00,50.00,1000.00,'2023-02-03 10:43:49','',''),(1189,'1','303','1',1,'Retail Sale Id 1170',4320.00,0.00,0.00,6.00,300.00,'2023-02-03 10:55:43','',''),(1190,'1','303','1',1,'Retail Sale Id 1171',69000.00,0.00,0.00,100.00,2000.00,'2023-02-03 11:00:50','',''),(1191,'1','303','1',1,'Retail Sale Id 1172',4320.00,0.00,0.00,6.00,300.00,'2023-02-03 11:05:21','',''),(1192,'1','303','1',1,'Retail Sale Id 1173',4320.00,0.00,0.00,6.00,300.00,'2023-02-03 11:11:25','',''),(1193,'1','303','1',1,'Retail Sale Id 1173',9000.00,0.00,0.00,12.50,625.00,'2023-02-03 11:11:25','',''),(1194,'1','303','1',1,'Retail Sale Id 1174',4320.00,0.00,0.00,6.00,300.00,'2023-02-03 11:30:16','',''),(1195,'1','303','1',1,'Retail Sale Id 1175',4320.00,0.00,0.00,6.00,300.00,'2023-02-03 11:44:33','',''),(1196,'1','303','1',1,'Retail Sale Id 1176',4320.00,0.00,0.00,6.00,300.00,'2023-02-03 12:37:16','',''),(1197,'1','303','1',1,'Retail Sale Id 1177',4003.20,0.00,0.00,5.56,278.00,'2023-02-03 12:52:41','',''),(1198,'1','303','1',1,'Retail Sale Id 1178',69000.00,0.00,0.00,100.00,2000.00,'2023-02-03 13:00:40','',''),(1199,'1','303','1',1,'Retail Sale Id 1179',720.00,0.00,0.00,1.00,50.00,'2023-02-03 13:19:46','',''),(1200,'1','303','1',1,'Retail Sale Id 1180',1497.60,0.00,0.00,2.08,104.00,'2023-02-03 13:21:23','',''),(1201,'1','303','1',1,'Retail Sale Id 1181',4320.00,0.00,0.00,6.00,300.00,'2023-02-03 14:04:36','',''),(1202,'1','303','1',1,'Retail Sale Id 1181',4320.00,0.00,0.00,6.00,300.00,'2023-02-03 14:04:36','',''),(1203,'1','303','1',1,'Retail Sale Id 1182',4320.00,0.00,0.00,6.00,300.00,'2023-02-03 14:18:54','',''),(1204,'1','303','1',1,'Retail Sale Id 1183',720.00,0.00,0.00,1.00,50.00,'2023-02-03 14:28:33','',''),(1205,'1','303','1',1,'Retail Sale Id 1184',4003.20,0.00,0.00,5.56,278.00,'2023-02-03 14:51:38','',''),(1206,'1','303','1',1,'Retail Sale Id 1185',1497.60,0.00,0.00,2.08,104.00,'2023-02-03 14:54:45','',''),(1207,'1','303','1',1,'Retail Sale Id 1186',4320.00,0.00,0.00,6.00,300.00,'2023-02-03 15:06:25','',''),(1208,'1','303','1',1,'Retail Sale Id 1187',496.80,0.00,0.00,0.69,34.50,'2023-02-03 15:09:51','',''),(1209,'1','303','1',1,'Retail Sale Id 1188',2203.20,0.00,0.00,3.06,153.00,'2023-02-03 15:30:22','',''),(1210,'1','303','1',1,'Retail Sale Id 1189',2160.00,0.00,0.00,3.00,150.00,'2023-02-03 15:34:30','',''),(1211,'1','303','1',1,'Retail Sale Id 1190',1497.60,0.00,0.00,2.08,104.00,'2023-02-03 15:38:29','',''),(1212,'1','303','1',1,'Retail Sale Id 1191',4320.00,0.00,0.00,6.00,300.00,'2023-02-03 16:11:32','',''),(1213,'1','303','1',1,'Retail Sale Id 1193',4320.00,0.00,0.00,6.00,300.00,'2023-02-03 16:13:52','',''),(1214,'1','303','1',1,'Retail Sale Id 1194',9000.00,0.00,0.00,12.50,625.00,'2023-02-03 16:23:33','',''),(1215,'1','303','1',1,'Retail Sale Id 1194',9000.00,0.00,0.00,12.50,625.00,'2023-02-03 16:23:33','',''),(1216,'1','303','1',1,'Retail Sale Id 1195',2160.00,0.00,0.00,3.00,150.00,'2023-02-03 16:26:13','',''),(1217,'1','303','1',1,'Retail Sale Id 1196',9000.00,0.00,0.00,12.50,625.00,'2023-02-03 16:35:02','',''),(1218,'1','303','1',1,'Retail Sale Id 1196',9000.00,0.00,0.00,12.50,625.00,'2023-02-03 16:35:02','',''),(1219,'1','303','1',1,'Retail Sale Id 1197',9000.00,0.00,0.00,12.50,625.00,'2023-02-03 16:43:02','',''),(1220,'1','303','1',1,'Retail Sale Id 1198',1000.80,0.00,0.00,1.39,69.50,'2023-02-03 16:51:26','',''),(1221,'1','303','1',1,'Retail Sale Id 1200',2498.40,0.00,0.00,3.47,173.50,'2023-02-03 17:06:12','',''),(1222,'1','303','1',1,'Retail Sale Id 1201',3002.40,0.00,0.00,4.17,208.50,'2023-02-03 17:08:48','',''),(1223,'1','303','1',1,'Retail Sale Id 1202',9000.00,0.00,0.00,12.50,625.00,'2023-02-03 17:24:09','',''),(1224,'1','303','1',1,'Retail Sale Id 1203',10000.80,0.00,0.00,13.89,694.50,'2023-02-03 17:54:24','',''),(1225,'1','303','1',1,'Return of Retail Sale Id 1196',0.00,9000.00,12.50,0.00,-625.00,'2023-02-03 18:48:28','',''),(1226,'1','303','1',1,'Return of Retail Sale Id 1196',0.00,9000.00,12.50,0.00,-625.00,'2023-02-03 18:48:28','',''),(1227,'1','303','1',1,'Retail Sale Id 1204',7963.20,0.00,0.00,11.06,553.00,'2023-02-03 18:51:17','',''),(1228,'1','303','1',1,'Retail Sale Id 1205',1829983.50,0.00,0.00,2652.15,53043.00,'2023-02-03 18:55:39','',''),(1229,'1','303','1',1,'Return of Retail Sale Id 1205',0.00,1829983.50,2652.15,0.00,-53043.00,'2023-02-03 18:57:33','',''),(1230,'1','303','1',1,'Retail Sale Id 1206',389084.10,0.00,0.00,563.89,11277.80,'2023-02-03 18:59:43','',''),(1231,'1','303','1',1,'Retail Sale Id 1207',4320.00,0.00,0.00,6.00,300.00,'2023-02-04 08:22:18','',''),(1232,'1','303','1',1,'Retail Sale Id 1208',2160.00,0.00,0.00,3.00,150.00,'2023-02-04 08:33:09','',''),(1233,'1','303','1',1,'Retail Sale Id 1209',4320.00,0.00,0.00,6.00,300.00,'2023-02-04 08:51:32','',''),(1234,'1','303','1',1,'Retail Sale Id 1210',1497.60,0.00,0.00,2.08,104.00,'2023-02-04 09:13:38','',''),(1235,'1','303','1',1,'Retail Sale Id 1211',9000.00,0.00,0.00,12.50,625.00,'2023-02-04 09:15:46','',''),(1236,'1','303','1',1,'Retail Sale Id 1212',3002.40,0.00,0.00,4.17,208.50,'2023-02-04 09:19:08','',''),(1237,'1','303','1',1,'Retail Sale Id 1213',4320.00,0.00,0.00,6.00,300.00,'2023-02-04 09:37:16','',''),(1238,'1','303','1',1,'Retail Sale Id 1214',4399.20,0.00,0.00,6.11,305.50,'2023-02-04 09:41:24','',''),(1239,'1','303','1',1,'Retail Sale Id 1215',2822.40,0.00,0.00,3.92,196.00,'2023-02-04 09:46:27','',''),(1240,'1','303','1',1,'Retail Sale Id 1216',2160.00,0.00,0.00,3.00,150.00,'2023-02-04 09:52:18','',''),(1241,'1','303','1',1,'Retail Sale Id 1217',9000.00,0.00,0.00,12.50,625.00,'2023-02-04 10:19:32','',''),(1242,'1','303','1',1,'Retail Sale Id 1218',9000.00,0.00,0.00,12.50,625.00,'2023-02-04 10:41:12','',''),(1243,'1','303','1',1,'Retail Sale Id 1219',7200.00,0.00,0.00,10.00,500.00,'2023-02-04 10:47:24','',''),(1244,'1','303','1',1,'Retail Sale Id 1220',9000.00,0.00,0.00,12.50,625.00,'2023-02-04 10:53:30','',''),(1245,'1','303','1',1,'Retail Sale Id 1221',2160.00,0.00,0.00,3.00,150.00,'2023-02-04 10:56:04','',''),(1246,'1','303','1',1,'Retail Sale Id 1222',4320.00,0.00,0.00,6.00,300.00,'2023-02-04 10:58:57','',''),(1247,'1','303','1',1,'Retail Sale Id 1223',1000.80,0.00,0.00,1.39,69.50,'2023-02-04 11:27:19','',''),(1248,'1','303','1',1,'Retail Sale Id 1224',4320.00,0.00,0.00,6.00,300.00,'2023-02-04 11:39:23','',''),(1249,'1','303','1',1,'Retail Sale Id 1225',9000.00,0.00,0.00,12.50,625.00,'2023-02-04 12:08:26','',''),(1250,'1','303','1',1,'Retail Sale Id 1226',2160.00,0.00,0.00,3.00,150.00,'2023-02-04 12:15:55','',''),(1251,'1','303','1',1,'Retail Sale Id 1227',720.00,0.00,0.00,1.00,50.00,'2023-02-04 12:18:11','',''),(1252,'1','303','1',1,'Retail Sale Id 1228',4320.00,0.00,0.00,6.00,300.00,'2023-02-04 12:19:54','',''),(1253,'1','303','1',1,'Retail Sale Id 1229',4320.00,0.00,0.00,6.00,300.00,'2023-02-04 12:22:28','',''),(1254,'1','303','1',1,'Retail Sale Id 1230',4320.00,0.00,0.00,6.00,300.00,'2023-02-04 12:24:37','',''),(1255,'1','303','1',1,'Retail Sale Id 1231',4320.00,0.00,0.00,6.00,300.00,'2023-02-04 12:26:46','',''),(1256,'1','303','1',1,'Retail Sale Id 1232',34500.00,0.00,0.00,50.00,1000.00,'2023-02-04 12:47:10','',''),(1257,'1','303','1',1,'Retail Sale Id 1233',2160.00,0.00,0.00,3.00,150.00,'2023-02-04 12:54:15','',''),(1258,'1','303','1',1,'Retail Sale Id 1234',4320.00,0.00,0.00,6.00,300.00,'2023-02-04 13:06:50','',''),(1259,'1','303','1',1,'Retail Sale Id 1235',2160.00,0.00,0.00,3.00,150.00,'2023-02-04 13:08:39','',''),(1260,'1','303','1',1,'Retail Sale Id 1236',1303.20,0.00,0.00,1.81,90.50,'2023-02-04 13:09:42','',''),(1261,'1','303','1',1,'Retail Sale Id 1237',720.00,0.00,0.00,1.00,50.00,'2023-02-04 13:12:58','',''),(1262,'1','303','1',1,'Retail Sale Id 1238',34500.00,0.00,0.00,50.00,1000.00,'2023-02-04 13:19:46','',''),(1263,'1','303','1',1,'Retail Sale Id 1239',9000.00,0.00,0.00,12.50,625.00,'2023-02-04 13:57:44','',''),(1264,'1','303','1',1,'Retail Sale Id 1240',1000.80,0.00,0.00,1.39,69.50,'2023-02-04 14:13:03','',''),(1265,'1','303','1',1,'Retail Sale Id 1241',2160.00,0.00,0.00,3.00,150.00,'2023-02-04 14:13:53','',''),(1266,'1','303','1',1,'Retail Sale Id 1242',4320.00,0.00,0.00,6.00,300.00,'2023-02-04 14:34:11','',''),(1267,'1','303','1',1,'Retail Sale Id 1243',1303.20,0.00,0.00,1.81,90.50,'2023-02-04 14:40:58','',''),(1268,'1','303','1',1,'Retail Sale Id 1244',2001.60,0.00,0.00,2.78,139.00,'2023-02-04 14:51:50','',''),(1269,'1','303','1',1,'Retail Sale Id 1245',5040.00,0.00,0.00,7.00,350.00,'2023-02-04 15:14:39','',''),(1270,'1','303','1',1,'Retail Sale Id 1246',4320.00,0.00,0.00,6.00,300.00,'2023-02-04 15:23:23','',''),(1271,'1','303','1',1,'Retail Sale Id 1247',1000.80,0.00,0.00,1.39,69.50,'2023-02-04 16:16:55','',''),(1272,'1','303','1',1,'Retail Sale Id 1248',2203.20,0.00,0.00,3.06,153.00,'2023-02-04 16:19:08','',''),(1273,'1','303','1',1,'Retail Sale Id 1249',3600.00,0.00,0.00,5.00,250.00,'2023-02-04 16:27:45','',''),(1274,'1','303','1',1,'Retail Sale Id 1250',2880.00,0.00,0.00,4.00,200.00,'2023-02-04 16:42:09','',''),(1275,'1','303','1',1,'Retail Sale Id 1251',4320.00,0.00,0.00,6.00,300.00,'2023-02-04 16:49:23','',''),(1276,'1','303','1',1,'Retail Sale Id 1252',4320.00,0.00,0.00,6.00,300.00,'2023-02-04 16:56:36','',''),(1277,'1','303','1',1,'Retail Sale Id 1253',799.20,0.00,0.00,1.11,55.50,'2023-02-04 16:59:04','',''),(1278,'1','303','1',1,'Retail Sale Id 1254',1497.60,0.00,0.00,2.08,104.00,'2023-02-04 17:01:40','',''),(1279,'1','303','1',1,'Retail Sale Id 1255',720.00,0.00,0.00,1.00,50.00,'2023-02-04 17:29:41','',''),(1280,'1','303','1',1,'Retail Sale Id 1256',2001.60,0.00,0.00,2.78,139.00,'2023-02-04 17:31:19','',''),(1281,'1','303','1',1,'Retail Sale Id 1257',1497.60,0.00,0.00,2.08,104.00,'2023-02-04 17:34:20','',''),(1282,'1','303','1',1,'Retail Sale Id 1258',2001.60,0.00,0.00,2.78,139.00,'2023-02-04 17:47:02','',''),(1283,'1','303','1',1,'Retail Sale Id 1259',2001.60,0.00,0.00,2.78,139.00,'2023-02-04 17:48:34','',''),(1284,'1','303','1',1,'Retail Sale Id 1260',1000.80,0.00,0.00,1.39,69.50,'2023-02-04 18:01:38','',''),(1285,'1','303','1',1,'Retail Sale Id 1261',2160.00,0.00,0.00,3.00,150.00,'2023-02-04 18:05:56','',''),(1286,'1','303','1',1,'Retail Sale Id 1262',3600.00,0.00,0.00,5.00,250.00,'2023-02-04 18:06:51','',''),(1287,'1','303','1',1,'Return of Retail Sale Id 1260',0.00,1000.80,1.39,0.00,-69.50,'2023-02-04 18:49:15','',''),(1288,'1','303','1',1,'Return of Retail Sale Id 1262',0.00,3600.00,5.00,0.00,-250.00,'2023-02-04 18:51:52','',''),(1289,'1','303','1',1,'Retail Sale Id 1263',295.20,0.00,0.00,0.41,20.50,'2023-02-04 18:52:42','',''),(1290,'1','303','1',1,'Return of Retail Sale Id 1238',0.00,34500.00,50.00,0.00,-1000.00,'2023-02-04 18:54:54','',''),(1291,'1','303','1',1,'Retail Sale Id 1264',34865.70,0.00,0.00,50.53,1010.60,'2023-02-04 18:56:31','',''),(1292,'1','303','1',1,'Retail Sale Id 1265',4320.00,0.00,0.00,6.00,300.00,'2023-02-05 08:14:19','',''),(1293,'1','303','1',1,'Retail Sale Id 1266',2001.60,0.00,0.00,2.78,139.00,'2023-02-05 08:23:36','',''),(1294,'1','303','1',1,'Retail Sale Id 1267',4320.00,0.00,0.00,6.00,300.00,'2023-02-05 08:42:20','',''),(1295,'1','303','1',1,'Retail Sale Id 1268',9000.00,0.00,0.00,12.50,625.00,'2023-02-05 08:57:32','',''),(1296,'1','303','1',1,'Retail Sale Id 1269',7200.00,0.00,0.00,10.00,500.00,'2023-02-05 08:59:17','',''),(1297,'1','303','1',1,'Retail Sale Id 1270',2880.00,0.00,0.00,4.00,200.00,'2023-02-05 09:06:51','',''),(1298,'1','303','1',1,'Retail Sale Id 1271',4320.00,0.00,0.00,6.00,300.00,'2023-02-05 09:24:43','',''),(1299,'1','303','1',1,'Retail Sale Id 1272',2880.00,0.00,0.00,4.00,200.00,'2023-02-05 09:48:06','',''),(1300,'1','303','1',1,'Retail Sale Id 1273',3002.40,0.00,0.00,4.17,208.50,'2023-02-05 09:49:58','',''),(1301,'1','303','1',1,'Retail Sale Id 1274',34500.00,0.00,0.00,50.00,1000.00,'2023-02-05 09:55:35','',''),(1302,'1','303','1',1,'Retail Sale Id 1275',34500.00,0.00,0.00,50.00,1000.00,'2023-02-05 09:56:54','',''),(1303,'1','303','1',1,'Retail Sale Id 1276',1000.80,0.00,0.00,1.39,69.50,'2023-02-05 09:58:15','',''),(1304,'1','303','1',1,'Retail Sale Id 1277',2160.00,0.00,0.00,3.00,150.00,'2023-02-05 10:09:03','',''),(1305,'1','303','1',1,'Retail Sale Id 1277',3600.00,0.00,0.00,5.00,250.00,'2023-02-05 10:09:04','',''),(1306,'1','303','1',1,'Retail Sale Id 1278',9000.00,0.00,0.00,12.50,625.00,'2023-02-05 10:11:03','',''),(1307,'1','303','1',1,'Retail Sale Id 1279',2160.00,0.00,0.00,3.00,150.00,'2023-02-05 10:28:40','',''),(1308,'1','303','1',1,'Retail Sale Id 1280',4320.00,0.00,0.00,6.00,300.00,'2023-02-05 10:51:15','',''),(1309,'1','303','1',1,'Retail Sale Id 1281',2160.00,0.00,0.00,3.00,150.00,'2023-02-05 10:54:48','',''),(1310,'1','303','1',1,'Retail Sale Id 1282',2160.00,0.00,0.00,3.00,150.00,'2023-02-05 10:56:00','',''),(1311,'1','303','1',1,'Retail Sale Id 1283',2001.60,0.00,0.00,2.78,139.00,'2023-02-05 11:07:42','',''),(1312,'1','303','1',1,'Retail Sale Id 1284',4003.20,0.00,0.00,5.56,278.00,'2023-02-05 11:09:28','',''),(1313,'1','303','1',1,'Retail Sale Id 1285',5040.00,0.00,0.00,7.00,350.00,'2023-02-05 11:13:24','',''),(1314,'1','303','1',1,'Retail Sale Id 1286',9000.00,0.00,0.00,12.50,625.00,'2023-02-05 11:17:02','',''),(1315,'1','303','1',1,'Retail Sale Id 1287',2160.00,0.00,0.00,3.00,150.00,'2023-02-05 11:24:55','',''),(1316,'1','303','1',1,'Retail Sale Id 1288',2160.00,0.00,0.00,3.00,150.00,'2023-02-05 11:45:25','',''),(1317,'1','303','1',1,'Retail Sale Id 1289',720.00,0.00,0.00,1.00,50.00,'2023-02-05 11:53:22','',''),(1318,'1','303','1',1,'Retail Sale Id 1291',4320.00,0.00,0.00,6.00,300.00,'2023-02-05 11:58:40','',''),(1319,'1','303','1',1,'Retail Sale Id 1292',2160.00,0.00,0.00,3.00,150.00,'2023-02-05 12:03:00','',''),(1320,'1','303','1',1,'Retail Sale Id 1293',4298.40,0.00,0.00,5.97,298.50,'2023-02-05 12:09:20','',''),(1321,'1','303','1',1,'Retail Sale Id 1294',720.00,0.00,0.00,1.00,50.00,'2023-02-05 12:12:23','',''),(1322,'1','303','1',1,'Retail Sale Id 1295',9000.00,0.00,0.00,12.50,625.00,'2023-02-05 12:18:19','',''),(1323,'1','303','1',1,'Retail Sale Id 1296',9000.00,0.00,0.00,12.50,625.00,'2023-02-05 12:22:35','',''),(1324,'1','303','1',1,'Retail Sale Id 1297',34500.00,0.00,0.00,50.00,1000.00,'2023-02-05 12:44:08','',''),(1325,'1','303','1',1,'Retail Sale Id 1298',4320.00,0.00,0.00,6.00,300.00,'2023-02-05 12:45:39','',''),(1326,'1','303','1',1,'Retail Sale Id 1299',4320.00,0.00,0.00,6.00,300.00,'2023-02-05 13:01:51','',''),(1327,'1','303','1',1,'Retail Sale Id 1300',2880.00,0.00,0.00,4.00,200.00,'2023-02-05 13:03:47','',''),(1328,'1','303','1',1,'Retail Sale Id 1301',69000.00,0.00,0.00,100.00,2000.00,'2023-02-05 13:06:20','',''),(1329,'1','303','1',1,'Retail Sale Id 1302',3002.40,0.00,0.00,4.17,208.50,'2023-02-05 13:08:15','',''),(1330,'1','303','1',1,'Retail Sale Id 1303',34500.00,0.00,0.00,50.00,1000.00,'2023-02-05 13:12:33','',''),(1331,'1','303','1',1,'Retail Sale Id 1304',34500.00,0.00,0.00,50.00,1000.00,'2023-02-05 13:17:47','',''),(1332,'1','303','1',1,'Retail Sale Id 1305',1440.00,0.00,0.00,2.00,100.00,'2023-02-05 13:32:54','',''),(1333,'1','303','1',1,'Retail Sale Id 1306',4320.00,0.00,0.00,6.00,300.00,'2023-02-05 13:34:46','',''),(1334,'1','303','1',1,'Retail Sale Id 1307',27600.00,0.00,0.00,40.00,800.00,'2023-02-05 13:41:30','',''),(1335,'1','303','1',1,'Retail Sale Id 1308',2880.00,0.00,0.00,4.00,200.00,'2023-02-05 13:43:19','',''),(1336,'1','303','1',1,'Retail Sale Id 1311',1497.60,0.00,0.00,2.08,104.00,'2023-02-05 13:58:58','',''),(1337,'1','303','1',1,'Retail Sale Id 1311',2001.60,0.00,0.00,2.78,139.00,'2023-02-05 13:58:58','',''),(1338,'1','303','1',1,'Retail Sale Id 1312',4320.00,0.00,0.00,6.00,300.00,'2023-02-05 14:00:48','',''),(1339,'1','303','1',1,'Retail Sale Id 1313',2160.00,0.00,0.00,3.00,150.00,'2023-02-05 14:01:50','',''),(1340,'1','303','1',1,'Retail Sale Id 1314',4320.00,0.00,0.00,6.00,300.00,'2023-02-05 14:29:04','',''),(1341,'1','303','1',1,'Retail Sale Id 1315',1000.80,0.00,0.00,1.39,69.50,'2023-02-05 14:30:23','',''),(1342,'1','303','1',1,'Retail Sale Id 1316',9000.00,0.00,0.00,12.50,625.00,'2023-02-05 14:32:00','',''),(1343,'1','303','1',1,'Retail Sale Id 1317',4320.00,0.00,0.00,6.00,300.00,'2023-02-05 14:34:28','',''),(1344,'1','303','1',1,'Retail Sale Id 1318',1000.80,0.00,0.00,1.39,69.50,'2023-02-05 14:47:35','',''),(1345,'1','303','1',1,'Retail Sale Id 1319',1800.00,0.00,0.00,2.50,125.00,'2023-02-05 15:10:25','',''),(1346,'1','303','1',1,'Retail Sale Id 1320',2160.00,0.00,0.00,3.00,150.00,'2023-02-05 15:17:41','',''),(1347,'1','303','1',1,'Retail Sale Id 1321',4320.00,0.00,0.00,6.00,300.00,'2023-02-05 15:27:31','',''),(1348,'1','303','1',1,'Retail Sale Id 1322',4320.00,0.00,0.00,6.00,300.00,'2023-02-05 15:40:52','',''),(1349,'1','303','1',1,'Retail Sale Id 1323',1440.00,0.00,0.00,2.00,100.00,'2023-02-05 15:46:04','',''),(1350,'1','303','1',1,'Retail Sale Id 1324',2880.00,0.00,0.00,4.00,200.00,'2023-02-05 15:48:41','',''),(1351,'1','303','1',1,'Retail Sale Id 1325',720.00,0.00,0.00,1.00,50.00,'2023-02-05 15:51:52','',''),(1352,'1','303','1',1,'Retail Sale Id 1326',4320.00,0.00,0.00,6.00,300.00,'2023-02-05 16:14:17','',''),(1353,'1','303','1',1,'Retail Sale Id 1327',9000.00,0.00,0.00,12.50,625.00,'2023-02-05 16:20:02','',''),(1354,'1','303','1',1,'Retail Sale Id 1328',3600.00,0.00,0.00,5.00,250.00,'2023-02-05 16:30:00','',''),(1355,'1','303','1',1,'Retail Sale Id 1329',4320.00,0.00,0.00,6.00,300.00,'2023-02-05 16:37:03','',''),(1356,'1','303','1',1,'Retail Sale Id 1330',9000.00,0.00,0.00,12.50,625.00,'2023-02-05 16:53:34','',''),(1357,'1','303','1',1,'Retail Sale Id 1331',2001.60,0.00,0.00,2.78,139.00,'2023-02-05 16:55:35','',''),(1358,'1','303','1',1,'Retail Sale Id 1332',2160.00,0.00,0.00,3.00,150.00,'2023-02-05 17:04:00','',''),(1359,'1','303','1',1,'Retail Sale Id 1333',4320.00,0.00,0.00,6.00,300.00,'2023-02-05 17:06:08','',''),(1360,'1','303','1',1,'Retail Sale Id 1334',2160.00,0.00,0.00,3.00,150.00,'2023-02-05 17:08:02','',''),(1361,'1','303','1',1,'Retail Sale Id 1335',9000.00,0.00,0.00,12.50,625.00,'2023-02-05 17:09:31','',''),(1362,'1','303','1',1,'Retail Sale Id 1336',2160.00,0.00,0.00,3.00,150.00,'2023-02-05 17:14:26','',''),(1363,'1','303','1',1,'Retail Sale Id 1337',2901.60,0.00,0.00,4.03,201.50,'2023-02-05 17:16:30','',''),(1364,'1','303','1',1,'Retail Sale Id 1338',2160.00,0.00,0.00,3.00,150.00,'2023-02-05 17:32:08','',''),(1365,'1','303','1',1,'Retail Sale Id 1339',2880.00,0.00,0.00,4.00,200.00,'2023-02-05 17:34:20','',''),(1366,'1','303','1',1,'Retail Sale Id 1340',2160.00,0.00,0.00,3.00,150.00,'2023-02-05 17:37:35','',''),(1367,'1','303','1',1,'Retail Sale Id 1341',4320.00,0.00,0.00,6.00,300.00,'2023-02-05 17:41:46','',''),(1368,'1','303','1',1,'Retail Sale Id 1342',4320.00,0.00,0.00,6.00,300.00,'2023-02-05 17:47:24','',''),(1369,'1','303','1',1,'Retail Sale Id 1343',9000.00,0.00,0.00,12.50,625.00,'2023-02-05 17:49:54','',''),(1370,'1','303','1',1,'Retail Sale Id 1344',720.00,0.00,0.00,1.00,50.00,'2023-02-05 17:52:12','',''),(1371,'1','303','1',1,'Retail Sale Id 1345',7.20,0.00,0.00,0.01,0.50,'2023-02-05 18:53:26','',''),(1372,'1','303','1',1,'Retail Sale Id 1346',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 08:12:37','',''),(1373,'1','303','1',1,'Retail Sale Id 1347',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 08:17:23','',''),(1374,'1','303','1',1,'Retail Sale Id 1348',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 08:23:34','',''),(1375,'1','303','1',1,'Retail Sale Id 1349',2160.00,0.00,0.00,3.00,150.00,'2023-02-06 08:25:17','',''),(1376,'1','303','1',1,'Retail Sale Id 1350',2203.20,0.00,0.00,3.06,153.00,'2023-02-06 08:53:58','',''),(1377,'1','303','1',1,'Retail Sale Id 1351',2160.00,0.00,0.00,3.00,150.00,'2023-02-06 09:07:27','',''),(1378,'1','303','1',1,'Retail Sale Id 1352',2203.20,0.00,0.00,3.06,153.00,'2023-02-06 09:11:10','',''),(1379,'1','303','1',1,'Retail Sale Id 1353',720.00,0.00,0.00,1.00,50.00,'2023-02-06 09:16:16','',''),(1380,'1','303','1',1,'Retail Sale Id 1354',2160.00,0.00,0.00,3.00,150.00,'2023-02-06 09:18:16','',''),(1381,'1','303','1',1,'Retail Sale Id 1355',2160.00,0.00,0.00,3.00,150.00,'2023-02-06 09:23:30','',''),(1382,'1','303','1',1,'Retail Sale Id 1356',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 09:26:42','',''),(1383,'1','303','1',1,'Retail Sale Id 1358',3002.40,0.00,0.00,4.17,208.50,'2023-02-06 09:28:35','',''),(1384,'1','303','1',1,'Retail Sale Id 1359',2001.60,0.00,0.00,2.78,139.00,'2023-02-06 09:36:50','',''),(1385,'1','303','1',1,'Retail Sale Id 1360',69000.00,0.00,0.00,100.00,2000.00,'2023-02-06 09:47:05','',''),(1386,'1','303','1',1,'Retail Sale Id 1361',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 09:48:54','',''),(1387,'1','303','1',1,'Retail Sale Id 1362',3600.00,0.00,0.00,5.00,250.00,'2023-02-06 09:50:52','',''),(1388,'1','303','1',1,'Retail Sale Id 1363',4500.00,0.00,0.00,6.25,312.50,'2023-02-06 09:59:23','',''),(1389,'1','303','1',1,'Retail Sale Id 1364',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 10:16:39','',''),(1390,'1','303','1',1,'Retail Sale Id 1365',9000.00,0.00,0.00,12.50,625.00,'2023-02-06 10:19:24','',''),(1391,'1','303','1',1,'Retail Sale Id 1366',2160.00,0.00,0.00,3.00,150.00,'2023-02-06 10:32:34','',''),(1392,'1','303','1',1,'Retail Sale Id 1367',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 10:34:51','',''),(1393,'1','303','1',1,'Retail Sale Id 1368',799.20,0.00,0.00,1.11,55.50,'2023-02-06 10:40:53','',''),(1394,'1','303','1',1,'Retail Sale Id 1369',9000.00,0.00,0.00,12.50,625.00,'2023-02-06 10:43:10','',''),(1395,'1','303','1',1,'Retail Sale Id 1370',1497.60,0.00,0.00,2.08,104.00,'2023-02-06 10:46:10','',''),(1396,'1','303','1',1,'Retail Sale Id 1371',2160.00,0.00,0.00,3.00,150.00,'2023-02-06 11:12:04','',''),(1397,'1','303','1',1,'Retail Sale Id 1371',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 11:12:04','',''),(1398,'1','303','1',1,'Retail Sale Id 1372',2160.00,0.00,0.00,3.00,150.00,'2023-02-06 11:21:00','',''),(1399,'1','303','1',1,'Retail Sale Id 1373',2160.00,0.00,0.00,3.00,150.00,'2023-02-06 11:28:18','',''),(1400,'1','303','1',1,'Retail Sale Id 1374',720.00,0.00,0.00,1.00,50.00,'2023-02-06 11:32:45','',''),(1401,'1','303','1',1,'Retail Sale Id 1375',9000.00,0.00,0.00,12.50,625.00,'2023-02-06 11:50:26','',''),(1402,'1','303','1',1,'Retail Sale Id 1376',2160.00,0.00,0.00,3.00,150.00,'2023-02-06 11:58:11','',''),(1403,'1','303','1',1,'Retail Sale Id 1376',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 11:58:11','',''),(1404,'1','303','1',1,'Retail Sale Id 1377',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 12:16:49','',''),(1405,'1','303','1',1,'Retail Sale Id 1378',5040.00,0.00,0.00,7.00,350.00,'2023-02-06 12:23:51','',''),(1406,'1','303','1',1,'Retail Sale Id 1379',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 12:26:11','',''),(1407,'1','303','1',1,'Retail Sale Id 1380',2203.20,0.00,0.00,3.06,153.00,'2023-02-06 12:39:22','',''),(1408,'1','303','1',1,'Retail Sale Id 1381',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 12:55:38','',''),(1409,'1','303','1',1,'Retail Sale Id 1382',1497.60,0.00,0.00,2.08,104.00,'2023-02-06 13:04:48','',''),(1410,'1','303','1',1,'Retail Sale Id 1383',34500.00,0.00,0.00,50.00,1000.00,'2023-02-06 13:11:43','',''),(1411,'1','303','1',1,'Retail Sale Id 1384',7200.00,0.00,0.00,10.00,500.00,'2023-02-06 13:19:21','',''),(1412,'1','303','1',1,'Retail Sale Id 1385',2160.00,0.00,0.00,3.00,150.00,'2023-02-06 13:20:31','',''),(1413,'1','303','1',1,'Retail Sale Id 1386',1000.80,0.00,0.00,1.39,69.50,'2023-02-06 13:23:32','',''),(1414,'1','303','1',1,'Retail Sale Id 1387',2160.00,0.00,0.00,3.00,150.00,'2023-02-06 13:29:07','',''),(1415,'1','303','1',1,'Retail Sale Id 1388',2880.00,0.00,0.00,4.00,200.00,'2023-02-06 13:38:27','',''),(1416,'1','303','1',1,'Retail Sale Id 1389',2160.00,0.00,0.00,3.00,150.00,'2023-02-06 13:42:09','',''),(1417,'1','303','1',1,'Retail Sale Id 1390',1497.60,0.00,0.00,2.08,104.00,'2023-02-06 13:44:09','',''),(1418,'1','303','1',1,'Retail Sale Id 1391',2001.60,0.00,0.00,2.78,139.00,'2023-02-06 13:45:17','',''),(1419,'1','303','1',1,'Retail Sale Id 1392',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 13:47:06','',''),(1420,'1','303','1',1,'Retail Sale Id 1393',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 13:48:56','',''),(1421,'1','303','1',1,'Retail Sale Id 1394',1497.60,0.00,0.00,2.08,104.00,'2023-02-06 14:05:29','',''),(1422,'1','303','1',1,'Retail Sale Id 1395',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 14:11:35','',''),(1423,'1','303','1',1,'Retail Sale Id 1396',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 14:43:25','',''),(1424,'1','303','1',1,'Retail Sale Id 1397',8640.00,0.00,0.00,12.00,600.00,'2023-02-06 14:47:13','',''),(1425,'1','303','1',1,'Retail Sale Id 1398',9000.00,0.00,0.00,12.50,625.00,'2023-02-06 14:53:28','',''),(1426,'1','303','1',1,'Retail Sale Id 1399',9000.00,0.00,0.00,12.50,625.00,'2023-02-06 14:55:02','',''),(1427,'1','303','1',1,'Retail Sale Id 1400',1497.60,0.00,0.00,2.08,104.00,'2023-02-06 15:16:29','',''),(1428,'1','303','1',1,'Retail Sale Id 1401',2203.20,0.00,0.00,3.06,153.00,'2023-02-06 15:22:59','',''),(1429,'1','303','1',1,'Retail Sale Id 1402',9000.00,0.00,0.00,12.50,625.00,'2023-02-06 15:29:43','',''),(1430,'1','303','1',1,'Retail Sale Id 1403',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 15:32:08','',''),(1431,'1','303','1',1,'Retail Sale Id 1404',2160.00,0.00,0.00,3.00,150.00,'2023-02-06 16:20:10','',''),(1432,'1','303','1',1,'Retail Sale Id 1405',2160.00,0.00,0.00,3.00,150.00,'2023-02-06 16:26:08','',''),(1433,'1','303','1',1,'Retail Sale Id 1406',2001.60,0.00,0.00,2.78,139.00,'2023-02-06 16:33:22','',''),(1434,'1','303','1',1,'Retail Sale Id 1407',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 16:36:30','',''),(1435,'1','303','1',1,'Retail Sale Id 1408',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 16:38:24','',''),(1436,'1','303','1',1,'Retail Sale Id 1409',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 16:41:48','',''),(1437,'1','303','1',1,'Retail Sale Id 1410',9000.00,0.00,0.00,12.50,625.00,'2023-02-06 16:43:59','',''),(1438,'1','303','1',1,'Retail Sale Id 1411',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 16:45:49','',''),(1439,'1','303','1',1,'Retail Sale Id 1412',2203.20,0.00,0.00,3.06,153.00,'2023-02-06 16:53:07','',''),(1440,'1','303','1',1,'Retail Sale Id 1413',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 16:57:40','',''),(1441,'1','303','1',1,'Return of Retail Sale Id 1388',0.00,2880.00,4.00,0.00,-200.00,'2023-02-06 17:05:24','',''),(1442,'1','303','1',1,'Retail Sale Id 1415',1497.60,0.00,0.00,2.08,104.00,'2023-02-06 17:07:21','',''),(1443,'1','303','1',1,'Retail Sale Id 1416',1000.80,0.00,0.00,1.39,69.50,'2023-02-06 17:23:10','',''),(1444,'1','303','1',1,'Retail Sale Id 1417',2160.00,0.00,0.00,3.00,150.00,'2023-02-06 17:27:04','',''),(1445,'1','303','1',1,'Retail Sale Id 1418',1440.00,0.00,0.00,2.00,100.00,'2023-02-06 17:41:23','',''),(1446,'1','303','1',1,'Retail Sale Id 1418',2160.00,0.00,0.00,3.00,150.00,'2023-02-06 17:41:23','',''),(1447,'1','303','1',1,'Retail Sale Id 1418',2160.00,0.00,0.00,3.00,150.00,'2023-02-06 17:41:23','',''),(1448,'1','303','1',1,'Retail Sale Id 1419',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 17:42:50','',''),(1449,'1','303','1',1,'Retail Sale Id 1420',2160.00,0.00,0.00,3.00,150.00,'2023-02-06 17:49:36','',''),(1450,'1','303','1',1,'Retail Sale Id 1421',4320.00,0.00,0.00,6.00,300.00,'2023-02-06 17:58:07','',''),(1451,'1','303','1',1,'Retail Sale Id 1422',4298.40,0.00,0.00,5.97,298.50,'2023-02-06 18:03:47','',''),(1452,'1','303','1',1,'Retail Sale Id 1423',7.20,0.00,0.00,0.01,0.50,'2023-02-06 18:48:08','',''),(1453,'1','303','1',1,'Retail Sale Id 1424',9000.00,0.00,0.00,12.50,625.00,'2023-02-07 07:36:22','',''),(1454,'1','303','1',1,'Retail Sale Id 1425',9000.00,0.00,0.00,12.50,625.00,'2023-02-07 07:59:19','',''),(1455,'1','303','1',1,'Retail Sale Id 1426',2160.00,0.00,0.00,3.00,150.00,'2023-02-07 08:42:38','',''),(1456,'1','303','1',1,'Retail Sale Id 1427',4320.00,0.00,0.00,6.00,300.00,'2023-02-07 09:23:50','',''),(1457,'1','303','1',1,'Retail Sale Id 1428',4320.00,0.00,0.00,6.00,300.00,'2023-02-07 09:31:30','',''),(1458,'1','303','1',1,'Retail Sale Id 1428',4320.00,0.00,0.00,6.00,300.00,'2023-02-07 09:31:30','',''),(1459,'1','303','1',1,'Retail Sale Id 1429',4320.00,0.00,0.00,6.00,300.00,'2023-02-07 09:57:20','',''),(1460,'1','303','1',1,'Retail Sale Id 1430',4320.00,0.00,0.00,6.00,300.00,'2023-02-07 10:00:45','',''),(1461,'1','303','1',1,'Retail Sale Id 1431',4320.00,0.00,0.00,6.00,300.00,'2023-02-07 10:06:01','',''),(1462,'1','303','1',1,'Retail Sale Id 1432',4003.20,0.00,0.00,5.56,278.00,'2023-02-07 10:08:14','',''),(1463,'1','303','1',1,'Retail Sale Id 1433',7200.00,0.00,0.00,10.00,500.00,'2023-02-07 10:19:51','',''),(1464,'1','303','1',1,'Retail Sale Id 1434',2160.00,0.00,0.00,3.00,150.00,'2023-02-07 10:24:51','',''),(1465,'1','303','1',1,'Retail Sale Id 1435',1440.00,0.00,0.00,2.00,100.00,'2023-02-07 10:44:36','',''),(1466,'1','303','1',1,'Retail Sale Id 1436',4320.00,0.00,0.00,6.00,300.00,'2023-02-07 10:48:29','',''),(1467,'1','303','1',1,'Retail Sale Id 1436',7200.00,0.00,0.00,10.00,500.00,'2023-02-07 10:48:29','',''),(1468,'1','303','1',1,'Retail Sale Id 1437',2498.40,0.00,0.00,3.47,173.50,'2023-02-07 10:50:21','',''),(1469,'1','303','1',1,'Retail Sale Id 1438',1396.80,0.00,0.00,1.94,97.00,'2023-02-07 11:00:52','',''),(1470,'1','303','1',1,'Retail Sale Id 1439',9000.00,0.00,0.00,12.50,625.00,'2023-02-07 11:13:30','',''),(1471,'1','303','1',1,'Retail Sale Id 1440',4320.00,0.00,0.00,6.00,300.00,'2023-02-07 11:14:45','',''),(1472,'1','303','1',1,'Retail Sale Id 1441',4320.00,0.00,0.00,6.00,300.00,'2023-02-07 11:16:01','',''),(1473,'1','303','1',1,'Retail Sale Id 1442',720.00,0.00,0.00,1.00,50.00,'2023-02-07 11:30:19','',''),(1474,'1','303','1',1,'Retail Sale Id 1443',2001.60,0.00,0.00,2.78,139.00,'2023-02-07 11:37:22','',''),(1475,'1','303','1',1,'Retail Sale Id 1444',1000.80,0.00,0.00,1.39,69.50,'2023-02-07 11:40:59','',''),(1476,'1','303','1',1,'Retail Sale Id 1445',4320.00,0.00,0.00,6.00,300.00,'2023-02-07 12:22:42','',''),(1477,'1','303','1',1,'Retail Sale Id 1446',4320.00,0.00,0.00,6.00,300.00,'2023-02-07 12:37:46','',''),(1478,'1','303','1',1,'Retail Sale Id 1447',2203.20,0.00,0.00,3.06,153.00,'2023-02-07 12:43:34','',''),(1479,'1','303','1',1,'Retail Sale Id 1448',4320.00,0.00,0.00,6.00,300.00,'2023-02-07 12:55:02','',''),(1480,'1','303','1',1,'Retail Sale Id 1449',1440.00,0.00,0.00,2.00,100.00,'2023-02-07 13:04:20','',''),(1481,'1','303','1',1,'Retail Sale Id 1450',3600.00,0.00,0.00,5.00,250.00,'2023-02-07 13:19:15','',''),(1482,'1','303','1',1,'Retail Sale Id 1451',2160.00,0.00,0.00,3.00,150.00,'2023-02-07 13:37:09','',''),(1483,'1','303','1',1,'Retail Sale Id 1452',4399.20,0.00,0.00,6.11,305.50,'2023-02-07 13:39:16','',''),(1484,'1','303','1',1,'Retail Sale Id 1453',2203.20,0.00,0.00,3.06,153.00,'2023-02-07 13:42:53','',''),(1485,'1','303','1',1,'Retail Sale Id 1454',2001.60,0.00,0.00,2.78,139.00,'2023-02-07 13:51:31','',''),(1486,'1','303','1',1,'Retail Sale Id 1455',9000.00,0.00,0.00,12.50,625.00,'2023-02-07 13:55:46','',''),(1487,'1','303','1',1,'Retail Sale Id 1455',9000.00,0.00,0.00,12.50,625.00,'2023-02-07 13:55:46','',''),(1488,'1','303','1',1,'Retail Sale Id 1456',9000.00,0.00,0.00,12.50,625.00,'2023-02-07 13:57:26','',''),(1489,'1','303','1',1,'Retail Sale Id 1456',9000.00,0.00,0.00,12.50,625.00,'2023-02-07 13:57:26','',''),(1490,'1','303','1',1,'Retail Sale Id 1457',2498.40,0.00,0.00,3.47,173.50,'2023-02-07 14:03:15','',''),(1491,'1','303','1',1,'Retail Sale Id 1458',4298.40,0.00,0.00,5.97,298.50,'2023-02-07 14:05:59','',''),(1492,'1','303','1',1,'Retail Sale Id 1459',5040.00,0.00,0.00,7.00,350.00,'2023-02-07 14:25:12','',''),(1493,'1','303','1',1,'Retail Sale Id 1460',4320.00,0.00,0.00,6.00,300.00,'2023-02-07 14:45:18','',''),(1494,'1','303','1',1,'Retail Sale Id 1462',4320.00,0.00,0.00,6.00,300.00,'2023-02-07 14:51:24','',''),(1495,'1','303','1',1,'Retail Sale Id 1463',3600.00,0.00,0.00,5.00,250.00,'2023-02-07 14:52:38','',''),(1496,'1','303','1',1,'Retail Sale Id 1464',2001.60,0.00,0.00,2.78,139.00,'2023-02-07 14:53:45','',''),(1497,'1','303','1',1,'Retail Sale Id 1465',2160.00,0.00,0.00,3.00,150.00,'2023-02-07 15:02:03','',''),(1498,'1','303','1',1,'Retail Sale Id 1466',2160.00,0.00,0.00,3.00,150.00,'2023-02-07 15:06:50','',''),(1499,'1','303','1',1,'Retail Sale Id 1467',4320.00,0.00,0.00,6.00,300.00,'2023-02-07 15:10:14','',''),(1500,'1','303','1',1,'Retail Sale Id 1468',3600.00,0.00,0.00,5.00,250.00,'2023-02-07 15:17:40','',''),(1501,'1','303','1',1,'Retail Sale Id 1469',9000.00,0.00,0.00,12.50,625.00,'2023-02-07 15:44:53','',''),(1502,'1','303','1',1,'Retail Sale Id 1470',2001.60,0.00,0.00,2.78,139.00,'2023-02-07 16:20:01','',''),(1503,'1','303','1',1,'Retail Sale Id 1471',4320.00,0.00,0.00,6.00,300.00,'2023-02-07 16:26:18','',''),(1504,'1','303','1',1,'Retail Sale Id 1472',1000.80,0.00,0.00,1.39,69.50,'2023-02-07 16:33:59','',''),(1505,'1','303','1',1,'Retail Sale Id 1473',2203.20,0.00,0.00,3.06,153.00,'2023-02-07 16:45:33','',''),(1506,'1','303','1',1,'Retail Sale Id 1474',2160.00,0.00,0.00,3.00,150.00,'2023-02-07 16:48:11','',''),(1507,'1','303','1',1,'Retail Sale Id 1476',3600.00,0.00,0.00,5.00,250.00,'2023-02-07 16:54:35','',''),(1508,'1','303','1',1,'Retail Sale Id 1477',1440.00,0.00,0.00,2.00,100.00,'2023-02-07 16:55:36','',''),(1509,'1','303','1',1,'Retail Sale Id 1478',2001.60,0.00,0.00,2.78,139.00,'2023-02-07 17:00:10','',''),(1510,'1','303','1',1,'Retail Sale Id 1479',2160.00,0.00,0.00,3.00,150.00,'2023-02-07 17:03:06','',''),(1511,'1','303','1',1,'Retail Sale Id 1480',2203.20,0.00,0.00,3.06,153.00,'2023-02-07 17:13:40','',''),(1512,'1','303','1',1,'Retail Sale Id 1481',4320.00,0.00,0.00,6.00,300.00,'2023-02-07 17:29:03','',''),(1513,'1','303','1',1,'Retail Sale Id 1482',2001.60,0.00,0.00,2.78,139.00,'2023-02-07 17:39:31','',''),(1514,'1','303','1',1,'Retail Sale Id 1483',2318.40,0.00,0.00,3.22,161.00,'2023-02-07 17:41:41','',''),(1515,'1','303','1',1,'Retail Sale Id 1484',2160.00,0.00,0.00,3.00,150.00,'2023-02-07 17:45:35','',''),(1516,'1','303','1',1,'Retail Sale Id 1486',3002.40,0.00,0.00,4.17,208.50,'2023-02-07 17:55:20','',''),(1517,'1','303','1',1,'Retail Sale Id 1486',4003.20,0.00,0.00,5.56,278.00,'2023-02-07 17:55:20','',''),(1518,'1','303','1',1,'Return of Retail Sale Id 1444',0.00,1000.80,1.39,0.00,-69.50,'2023-02-07 18:53:29','',''),(1519,'1','303','1',1,'Retail Sale Id 1487',576.00,0.00,0.00,0.80,40.00,'2023-02-07 18:54:32','',''),(1520,'1','303','1',1,'Retail Sale Id 1488',4320.00,0.00,0.00,6.00,300.00,'2023-02-08 08:11:09','',''),(1521,'1','303','1',1,'Retail Sale Id 1489',9000.00,0.00,0.00,12.50,625.00,'2023-02-08 08:40:13','',''),(1522,'1','303','1',1,'Retail Sale Id 1491',4320.00,0.00,0.00,6.00,300.00,'2023-02-08 08:42:19','',''),(1523,'1','303','1',1,'Retail Sale Id 1492',1440.00,0.00,0.00,2.00,100.00,'2023-02-08 09:09:46','',''),(1524,'1','303','1',1,'Retail Sale Id 1493',4320.00,0.00,0.00,6.00,300.00,'2023-02-08 09:19:07','',''),(1525,'1','303','1',1,'Retail Sale Id 1494',2160.00,0.00,0.00,3.00,150.00,'2023-02-08 09:29:44','',''),(1526,'1','303','1',1,'Retail Sale Id 1495',3002.40,0.00,0.00,4.17,208.50,'2023-02-08 09:30:51','',''),(1527,'1','303','1',1,'Retail Sale Id 1496',4320.00,0.00,0.00,6.00,300.00,'2023-02-08 09:38:13','',''),(1528,'1','303','1',1,'Retail Sale Id 1497',4320.00,0.00,0.00,6.00,300.00,'2023-02-08 09:45:39','',''),(1529,'1','303','1',1,'Retail Sale Id 1498',2498.40,0.00,0.00,3.47,173.50,'2023-02-08 09:52:19','',''),(1530,'1','303','1',1,'Retail Sale Id 1499',2880.00,0.00,0.00,4.00,200.00,'2023-02-08 10:28:14','',''),(1531,'1','303','1',1,'Retail Sale Id 1500',2001.60,0.00,0.00,2.78,139.00,'2023-02-08 10:29:24','',''),(1532,'1','303','1',1,'Retail Sale Id 1501',4320.00,0.00,0.00,6.00,300.00,'2023-02-08 10:41:37','',''),(1533,'1','303','1',1,'Retail Sale Id 1502',2160.00,0.00,0.00,3.00,150.00,'2023-02-08 10:50:42','',''),(1534,'1','303','1',1,'Retail Sale Id 1503',9000.00,0.00,0.00,12.50,625.00,'2023-02-08 10:54:57','',''),(1535,'1','303','1',1,'Retail Sale Id 1504',4320.00,0.00,0.00,6.00,300.00,'2023-02-08 11:11:25','',''),(1536,'1','303','1',1,'Retail Sale Id 1505',4320.00,0.00,0.00,6.00,300.00,'2023-02-08 11:25:02','',''),(1537,'1','303','1',1,'Retail Sale Id 1506',3002.40,0.00,0.00,4.17,208.50,'2023-02-08 11:33:57','',''),(1538,'1','303','1',1,'Retail Sale Id 1508',9000.00,0.00,0.00,12.50,625.00,'2023-02-08 15:28:08','',''),(1539,'1','303','1',1,'Retail Sale Id 1509',4320.00,0.00,0.00,6.00,300.00,'2023-02-08 15:29:08','',''),(1540,'1','303','1',1,'Retail Sale Id 1510',1497.60,0.00,0.00,2.08,104.00,'2023-02-08 15:29:54','',''),(1541,'1','303','1',1,'Retail Sale Id 1511',2160.00,0.00,0.00,3.00,150.00,'2023-02-08 15:33:32','',''),(1542,'1','303','1',1,'Retail Sale Id 1512',3600.00,0.00,0.00,5.00,250.00,'2023-02-08 15:35:12','',''),(1543,'1','303','1',1,'Retail Sale Id 1513',2160.00,0.00,0.00,3.00,150.00,'2023-02-08 15:36:06','',''),(1544,'1','303','1',1,'Retail Sale Id 1514',2880.00,0.00,0.00,4.00,200.00,'2023-02-08 15:36:59','',''),(1545,'1','303','1',1,'Retail Sale Id 1515',4320.00,0.00,0.00,6.00,300.00,'2023-02-08 15:38:22','',''),(1546,'1','303','1',1,'Retail Sale Id 1516',2160.00,0.00,0.00,3.00,150.00,'2023-02-08 15:39:48','',''),(1547,'1','303','1',1,'Retail Sale Id 1517',4320.00,0.00,0.00,6.00,300.00,'2023-02-08 15:41:36','',''),(1548,'1','303','1',1,'Retail Sale Id 1518',3002.40,0.00,0.00,4.17,208.50,'2023-02-08 15:42:27','',''),(1549,'1','303','1',1,'Retail Sale Id 1519',2203.20,0.00,0.00,3.06,153.00,'2023-02-08 15:44:37','',''),(1550,'1','303','1',1,'Retail Sale Id 1520',9000.00,0.00,0.00,12.50,625.00,'2023-02-08 15:45:59','',''),(1551,'1','303','1',1,'Retail Sale Id 1521',4320.00,0.00,0.00,6.00,300.00,'2023-02-08 15:58:21','',''),(1552,'1','303','1',1,'Retail Sale Id 1522',34500.00,0.00,0.00,50.00,1000.00,'2023-02-08 15:59:45','',''),(1553,'1','303','1',1,'Retail Sale Id 1523',4320.00,0.00,0.00,6.00,300.00,'2023-02-08 16:06:18','',''),(1554,'1','303','1',1,'Retail Sale Id 1524',7999.20,0.00,0.00,11.11,555.50,'2023-02-08 16:11:06','',''),(1555,'1','303','1',1,'Retail Sale Id 1525',1000.80,0.00,0.00,1.39,69.50,'2023-02-08 16:19:29','',''),(1556,'1','303','1',1,'Retail Sale Id 1526',9000.00,0.00,0.00,12.50,625.00,'2023-02-08 16:25:38','',''),(1557,'1','303','1',1,'Retail Sale Id 1527',34500.00,0.00,0.00,50.00,1000.00,'2023-02-08 16:28:35','',''),(1558,'1','303','1',1,'Retail Sale Id 1528',2203.20,0.00,0.00,3.06,153.00,'2023-02-08 16:30:18','',''),(1559,'1','303','1',1,'Retail Sale Id 1529',9000.00,0.00,0.00,12.50,625.00,'2023-02-08 16:32:50','',''),(1560,'1','303','1',1,'Retail Sale Id 1530',4320.00,0.00,0.00,6.00,300.00,'2023-02-08 16:36:29','',''),(1561,'1','303','1',1,'Retail Sale Id 1531',3600.00,0.00,0.00,5.00,250.00,'2023-02-08 16:37:55','',''),(1562,'1','303','1',1,'Retail Sale Id 1532',4320.00,0.00,0.00,6.00,300.00,'2023-02-08 16:44:57','',''),(1563,'1','303','1',1,'Retail Sale Id 1533',2001.60,0.00,0.00,2.78,139.00,'2023-02-08 16:48:26','',''),(1564,'1','303','1',1,'Retail Sale Id 1534',4298.40,0.00,0.00,5.97,298.50,'2023-02-08 16:51:50','',''),(1565,'1','303','1',1,'Retail Sale Id 1535',7200.00,0.00,0.00,10.00,500.00,'2023-02-08 17:04:26','',''),(1566,'1','303','1',1,'Retail Sale Id 1536',2001.60,0.00,0.00,2.78,139.00,'2023-02-08 17:05:50','',''),(1567,'1','303','1',1,'Retail Sale Id 1537',2001.60,0.00,0.00,2.78,139.00,'2023-02-08 17:11:42','',''),(1568,'1','303','1',1,'Retail Sale Id 1538',4320.00,0.00,0.00,6.00,300.00,'2023-02-08 17:15:19','',''),(1569,'1','303','1',1,'Retail Sale Id 1539',9000.00,0.00,0.00,12.50,625.00,'2023-02-08 17:16:31','',''),(1570,'1','303','1',1,'Retail Sale Id 1540',34500.00,0.00,0.00,50.00,1000.00,'2023-02-08 17:29:57','',''),(1571,'1','303','1',1,'Retail Sale Id 1541',3600.00,0.00,0.00,5.00,250.00,'2023-02-08 17:36:52','',''),(1572,'1','303','1',1,'Retail Sale Id 1542',4320.00,0.00,0.00,6.00,300.00,'2023-02-08 17:38:02','',''),(1573,'1','303','1',1,'Retail Sale Id 1543',4003.20,0.00,0.00,5.56,278.00,'2023-02-08 17:39:33','',''),(1574,'1','303','1',1,'Retail Sale Id 1544',3499.20,0.00,0.00,4.86,243.00,'2023-02-08 17:41:30','',''),(1575,'1','303','1',1,'Retail Sale Id 1545',9014.40,0.00,0.00,12.52,626.00,'2023-02-08 18:55:20','',''),(1576,'1','303','1',1,'Retail Sale Id 1546',1440.00,0.00,0.00,2.00,100.00,'2023-02-09 07:41:16','',''),(1577,'1','303','1',1,'Retail Sale Id 1547',3002.40,0.00,0.00,4.17,208.50,'2023-02-09 08:37:40','',''),(1578,'1','303','1',1,'Retail Sale Id 1548',3600.00,0.00,0.00,5.00,250.00,'2023-02-09 09:01:44','',''),(1579,'1','303','1',1,'Retail Sale Id 1549',9000.00,0.00,0.00,12.50,625.00,'2023-02-09 09:23:37','',''),(1580,'1','303','1',1,'Retail Sale Id 1550',9000.00,0.00,0.00,12.50,625.00,'2023-02-09 09:26:31','',''),(1581,'1','303','1',1,'Retail Sale Id 1551',2160.00,0.00,0.00,3.00,150.00,'2023-02-09 09:35:12','',''),(1582,'1','303','1',1,'Retail Sale Id 1552',2203.20,0.00,0.00,3.06,153.00,'2023-02-09 09:38:02','',''),(1583,'1','303','1',1,'Retail Sale Id 1553',69000.00,0.00,0.00,100.00,2000.00,'2023-02-09 09:54:06','',''),(1584,'1','303','1',1,'Retail Sale Id 1554',4320.00,0.00,0.00,6.00,300.00,'2023-02-09 10:36:41','',''),(1585,'1','303','1',1,'Retail Sale Id 1555',2203.20,0.00,0.00,3.06,153.00,'2023-02-09 10:37:58','',''),(1586,'1','303','1',1,'Retail Sale Id 1556',1497.60,0.00,0.00,2.08,104.00,'2023-02-09 10:45:01','',''),(1587,'1','303','1',1,'Retail Sale Id 1557',1202.40,0.00,0.00,1.67,83.50,'2023-02-09 10:52:23','',''),(1588,'1','303','1',1,'Retail Sale Id 1558',3002.40,0.00,0.00,4.17,208.50,'2023-02-09 10:55:53','',''),(1589,'1','303','1',1,'Retail Sale Id 1559',2160.00,0.00,0.00,3.00,150.00,'2023-02-09 11:04:51','',''),(1590,'1','303','1',1,'Retail Sale Id 1560',4298.40,0.00,0.00,5.97,298.50,'2023-02-09 11:36:04','',''),(1591,'1','303','1',1,'Retail Sale Id 1561',1497.60,0.00,0.00,2.08,104.00,'2023-02-09 11:52:22','',''),(1592,'1','303','1',1,'Retail Sale Id 1562',4298.40,0.00,0.00,5.97,298.50,'2023-02-09 11:55:38','',''),(1593,'1','303','1',1,'Retail Sale Id 1563',9000.00,0.00,0.00,12.50,625.00,'2023-02-09 11:58:00','',''),(1594,'1','303','1',1,'Return of Retail Sale Id 1563',0.00,9000.00,12.50,0.00,-625.00,'2023-02-09 12:12:38','',''),(1595,'1','303','1',1,'Retail Sale Id 1564',8229.60,0.00,0.00,11.43,571.50,'2023-02-09 12:13:35','',''),(1596,'1','303','1',1,'Retail Sale Id 1565',4320.00,0.00,0.00,6.00,300.00,'2023-02-09 12:18:04','',''),(1597,'1','303','1',1,'Retail Sale Id 1566',7200.00,0.00,0.00,10.00,500.00,'2023-02-09 12:19:30','',''),(1598,'1','303','1',1,'Retail Sale Id 1567',1497.60,0.00,0.00,2.08,104.00,'2023-02-09 12:28:38','',''),(1599,'1','303','1',1,'Retail Sale Id 1568',4320.00,0.00,0.00,6.00,300.00,'2023-02-09 12:43:30','',''),(1600,'1','303','1',1,'Retail Sale Id 1569',2160.00,0.00,0.00,3.00,150.00,'2023-02-09 12:50:10','',''),(1601,'1','303','1',1,'Retail Sale Id 1569',2880.00,0.00,0.00,4.00,200.00,'2023-02-09 12:50:10','',''),(1602,'1','303','1',1,'Retail Sale Id 1570',2001.60,0.00,0.00,2.78,139.00,'2023-02-09 12:56:32','',''),(1603,'1','303','1',1,'Retail Sale Id 1571',4320.00,0.00,0.00,6.00,300.00,'2023-02-09 13:28:32','',''),(1604,'1','303','1',1,'Retail Sale Id 1573',4320.00,0.00,0.00,6.00,300.00,'2023-02-09 13:33:59','',''),(1605,'1','303','1',1,'Retail Sale Id 1574',4320.00,0.00,0.00,6.00,300.00,'2023-02-09 13:55:58','',''),(1606,'1','303','1',1,'Retail Sale Id 1575',4320.00,0.00,0.00,6.00,300.00,'2023-02-09 14:07:57','',''),(1607,'1','303','1',1,'Retail Sale Id 1576',4320.00,0.00,0.00,6.00,300.00,'2023-02-09 14:16:41','',''),(1608,'1','303','1',1,'Retail Sale Id 1576',7200.00,0.00,0.00,10.00,500.00,'2023-02-09 14:16:41','',''),(1609,'1','303','1',1,'Retail Sale Id 1577',4320.00,0.00,0.00,6.00,300.00,'2023-02-09 14:26:38','',''),(1610,'1','303','1',1,'Retail Sale Id 1578',1000.80,0.00,0.00,1.39,69.50,'2023-02-09 14:34:35','',''),(1611,'1','303','1',1,'Retail Sale Id 1579',9000.00,0.00,0.00,12.50,625.00,'2023-02-09 14:39:46','',''),(1612,'1','303','1',1,'Retail Sale Id 1580',2203.20,0.00,0.00,3.06,153.00,'2023-02-09 14:49:38','',''),(1613,'1','303','1',1,'Retail Sale Id 1581',3002.40,0.00,0.00,4.17,208.50,'2023-02-09 14:54:09','',''),(1614,'1','303','1',1,'Retail Sale Id 1582',34500.00,0.00,0.00,50.00,1000.00,'2023-02-09 14:57:03','',''),(1615,'1','303','1',1,'Retail Sale Id 1583',1000.80,0.00,0.00,1.39,69.50,'2023-02-09 15:10:18','',''),(1616,'1','303','1',1,'Retail Sale Id 1584',4320.00,0.00,0.00,6.00,300.00,'2023-02-09 15:23:23','',''),(1617,'1','303','1',1,'Retail Sale Id 1585',4320.00,0.00,0.00,6.00,300.00,'2023-02-09 15:28:26','',''),(1618,'1','303','1',1,'Retail Sale Id 1586',2160.00,0.00,0.00,3.00,150.00,'2023-02-09 16:19:41','',''),(1619,'1','303','1',1,'Retail Sale Id 1587',2001.60,0.00,0.00,2.78,139.00,'2023-02-09 16:21:55','',''),(1620,'1','303','1',1,'Retail Sale Id 1588',2160.00,0.00,0.00,3.00,150.00,'2023-02-09 16:23:58','',''),(1621,'1','303','1',1,'Retail Sale Id 1589',4320.00,0.00,0.00,6.00,300.00,'2023-02-09 16:29:51','',''),(1622,'1','303','1',1,'Retail Sale Id 1590',4320.00,0.00,0.00,6.00,300.00,'2023-02-09 16:31:13','',''),(1623,'1','303','1',1,'Retail Sale Id 1591',34500.00,0.00,0.00,50.00,1000.00,'2023-02-09 16:43:20','',''),(1624,'1','303','1',1,'Retail Sale Id 1592',9000.00,0.00,0.00,12.50,625.00,'2023-02-09 16:49:26','',''),(1625,'1','303','1',1,'Retail Sale Id 1593',9000.00,0.00,0.00,12.50,625.00,'2023-02-09 16:50:17','',''),(1626,'1','303','1',1,'Retail Sale Id 1594',9000.00,0.00,0.00,12.50,625.00,'2023-02-09 16:51:15','',''),(1627,'1','303','1',1,'Retail Sale Id 1595',2880.00,0.00,0.00,4.00,200.00,'2023-02-09 16:53:44','',''),(1628,'1','303','1',1,'Retail Sale Id 1596',1000.80,0.00,0.00,1.39,69.50,'2023-02-09 16:58:07','',''),(1629,'1','303','1',1,'Retail Sale Id 1597',4996.80,0.00,0.00,6.94,347.00,'2023-02-09 16:59:12','',''),(1630,'1','303','1',1,'Retail Sale Id 1598',4320.00,0.00,0.00,6.00,300.00,'2023-02-09 17:02:49','',''),(1631,'1','303','1',1,'Retail Sale Id 1599',7200.00,0.00,0.00,10.00,500.00,'2023-02-09 17:05:44','',''),(1632,'1','303','1',1,'Retail Sale Id 1600',1440.00,0.00,0.00,2.00,100.00,'2023-02-09 17:12:34','',''),(1633,'1','303','1',1,'Retail Sale Id 1601',4320.00,0.00,0.00,6.00,300.00,'2023-02-09 17:16:17','',''),(1634,'1','303','1',1,'Retail Sale Id 1602',5040.00,0.00,0.00,7.00,350.00,'2023-02-09 17:39:34','',''),(1635,'1','303','1',1,'Retail Sale Id 1603',2160.00,0.00,0.00,3.00,150.00,'2023-02-09 17:50:00','',''),(1636,'1','303','1',1,'Retail Sale Id 1604',3600.00,0.00,0.00,5.00,250.00,'2023-02-09 17:51:24','',''),(1637,'1','303','1',1,'Retail Sale Id 1605',4320.00,0.00,0.00,6.00,300.00,'2023-02-09 17:55:21','',''),(1638,'1','303','1',1,'Retail Sale Id 1606',586500.00,0.00,0.00,850.00,17000.00,'2023-02-09 18:04:34','',''),(1639,'1','303','1',1,'Retail Sale Id 1607',14.40,0.00,0.00,0.02,1.00,'2023-02-09 18:35:23','',''),(1640,'1','303','1',1,'Retail Sale Id 1608',40020.00,0.00,0.00,58.00,1160.00,'2023-02-10 08:50:45','',''),(1641,'1','303','1',1,'Retail Sale Id 1609',2160.00,0.00,0.00,3.00,150.00,'2023-02-10 09:22:35','',''),(1642,'1','303','1',1,'Retail Sale Id 1610',4320.00,0.00,0.00,6.00,300.00,'2023-02-10 09:40:52','',''),(1643,'1','303','1',1,'Retail Sale Id 1611',2160.00,0.00,0.00,3.00,150.00,'2023-02-10 10:00:15','',''),(1644,'1','303','1',1,'Retail Sale Id 1612',4320.00,0.00,0.00,6.00,300.00,'2023-02-10 10:01:44','',''),(1645,'1','303','1',1,'Retail Sale Id 1613',34500.00,0.00,0.00,50.00,1000.00,'2023-02-10 10:12:44','',''),(1646,'1','303','1',1,'Retail Sale Id 1614',1202.40,0.00,0.00,1.67,83.50,'2023-02-10 10:20:26','',''),(1647,'1','303','1',1,'Retail Sale Id 1615',4003.20,0.00,0.00,5.56,278.00,'2023-02-10 10:21:21','',''),(1648,'1','303','1',1,'Retail Sale Id 1616',9000.00,0.00,0.00,12.50,625.00,'2023-02-10 10:27:01','',''),(1649,'1','303','1',1,'Retail Sale Id 1617',2160.00,0.00,0.00,3.00,150.00,'2023-02-10 10:32:56','',''),(1650,'1','303','1',1,'Retail Sale Id 1618',4500.00,0.00,0.00,6.25,312.50,'2023-02-10 10:38:01','',''),(1651,'1','303','1',1,'Retail Sale Id 1619',3600.00,0.00,0.00,5.00,250.00,'2023-02-10 10:53:03','',''),(1652,'1','303','1',1,'Retail Sale Id 1620',1000.80,0.00,0.00,1.39,69.50,'2023-02-10 11:03:29','',''),(1653,'1','303','1',1,'Retail Sale Id 1621',9000.00,0.00,0.00,12.50,625.00,'2023-02-10 11:08:33','',''),(1654,'1','303','1',1,'Retail Sale Id 1622',4320.00,0.00,0.00,6.00,300.00,'2023-02-10 11:11:19','',''),(1655,'1','303','1',1,'Retail Sale Id 1623',2160.00,0.00,0.00,3.00,150.00,'2023-02-10 11:28:43','',''),(1656,'1','303','1',1,'Retail Sale Id 1624',4298.40,0.00,0.00,5.97,298.50,'2023-02-10 11:31:50','',''),(1657,'1','303','1',1,'Retail Sale Id 1625',2160.00,0.00,0.00,3.00,150.00,'2023-02-10 11:51:21','',''),(1658,'1','303','1',1,'Retail Sale Id 1626',2001.60,0.00,0.00,2.78,139.00,'2023-02-10 11:52:20','',''),(1659,'1','303','1',1,'Retail Sale Id 1627',40020.00,0.00,0.00,58.00,1160.00,'2023-02-10 12:00:13','',''),(1660,'1','303','1',1,'Retail Sale Id 1628',2498.40,0.00,0.00,3.47,173.50,'2023-02-10 12:02:17','',''),(1661,'1','303','1',1,'Retail Sale Id 1629',4320.00,0.00,0.00,6.00,300.00,'2023-02-10 12:04:14','',''),(1662,'1','303','1',1,'Retail Sale Id 1630',2001.60,0.00,0.00,2.78,139.00,'2023-02-10 12:05:46','',''),(1663,'1','303','1',1,'Retail Sale Id 1631',172500.00,0.00,0.00,250.00,5000.00,'2023-02-10 12:08:26','',''),(1664,'1','303','1',1,'Retail Sale Id 1632',4320.00,0.00,0.00,6.00,300.00,'2023-02-10 12:11:15','',''),(1665,'1','303','1',1,'Retail Sale Id 1633',2001.60,0.00,0.00,2.78,139.00,'2023-02-10 12:13:44','',''),(1666,'1','303','1',1,'Retail Sale Id 1634',34500.00,0.00,0.00,50.00,1000.00,'2023-02-10 13:02:43','',''),(1667,'1','303','1',1,'Retail Sale Id 1635',720.00,0.00,0.00,1.00,50.00,'2023-02-10 13:07:53','',''),(1668,'1','303','1',1,'Retail Sale Id 1637',2203.20,0.00,0.00,3.06,153.00,'2023-02-10 13:22:42','',''),(1669,'1','303','1',1,'Retail Sale Id 1638',4320.00,0.00,0.00,6.00,300.00,'2023-02-10 13:40:56','',''),(1670,'1','303','1',1,'Retail Sale Id 1639',9000.00,0.00,0.00,12.50,625.00,'2023-02-10 14:44:04','',''),(1671,'1','303','1',1,'Retail Sale Id 1640',2160.00,0.00,0.00,3.00,150.00,'2023-02-10 15:12:37','',''),(1672,'1','303','1',1,'Retail Sale Id 1641',2160.00,0.00,0.00,3.00,150.00,'2023-02-10 15:15:16','',''),(1673,'1','303','1',1,'Retail Sale Id 1642',4320.00,0.00,0.00,6.00,300.00,'2023-02-10 15:58:47','',''),(1674,'1','303','1',1,'Retail Sale Id 1643',4017.60,0.00,0.00,5.58,279.00,'2023-02-10 16:20:29','',''),(1675,'1','303','1',1,'Retail Sale Id 1644',3002.40,0.00,0.00,4.17,208.50,'2023-02-10 16:23:27','',''),(1676,'1','303','1',1,'Retail Sale Id 1645',2160.00,0.00,0.00,3.00,150.00,'2023-02-10 16:39:38','',''),(1677,'1','303','1',1,'Retail Sale Id 1646',9000.00,0.00,0.00,12.50,625.00,'2023-02-10 16:40:59','',''),(1678,'1','303','1',1,'Retail Sale Id 1647',5760.00,0.00,0.00,8.00,400.00,'2023-02-10 16:55:59','',''),(1679,'1','303','1',1,'Retail Sale Id 1648',4320.00,0.00,0.00,6.00,300.00,'2023-02-10 17:15:00','',''),(1680,'1','303','1',1,'Retail Sale Id 1649',4320.00,0.00,0.00,6.00,300.00,'2023-02-10 17:37:17','',''),(1681,'1','303','1',1,'Retail Sale Id 1650',2203.20,0.00,0.00,3.06,153.00,'2023-02-10 17:39:21','',''),(1682,'1','303','1',1,'Retail Sale Id 1651',9000.00,0.00,0.00,12.50,625.00,'2023-02-10 18:06:43','',''),(1683,'1','303','1',1,'Retail Sale Id 1652',4320.00,0.00,0.00,6.00,300.00,'2023-02-10 18:22:42','',''),(1684,'1','303','1',1,'Return of Retail Sale Id 1645',0.00,2160.00,3.00,0.00,-150.00,'2023-02-10 19:33:03','',''),(1685,'1','303','1',1,'Retail Sale Id 1653',1591.20,0.00,0.00,2.21,110.50,'2023-02-10 19:33:40','',''),(1686,'1','303','1',1,'Return of Retail Sale Id 1634',0.00,34500.00,50.00,0.00,-1000.00,'2023-02-10 19:34:57','',''),(1687,'1','303','1',1,'Retail Sale Id 1654',33823.80,0.00,0.00,49.02,980.40,'2023-02-10 19:36:22','',''),(1688,'1','303','1',1,'Retail Sale Id 1656',1352.40,0.00,0.00,1.96,39.20,'2023-02-10 19:38:38','',''),(1689,'1','303','1',1,'Retail Sale Id 1657',34500.00,0.00,0.00,50.00,1000.00,'2023-02-11 08:52:31','',''),(1690,'1','303','1',1,'Retail Sale Id 1658',2001.60,0.00,0.00,2.78,139.00,'2023-02-11 09:01:43','',''),(1691,'1','303','1',1,'Retail Sale Id 1659',9000.00,0.00,0.00,12.50,625.00,'2023-02-11 09:14:00','',''),(1692,'1','303','1',1,'Retail Sale Id 1660',4320.00,0.00,0.00,6.00,300.00,'2023-02-11 09:34:14','',''),(1693,'1','303','1',1,'Retail Sale Id 1661',4320.00,0.00,0.00,6.00,300.00,'2023-02-11 09:57:04','',''),(1694,'1','303','1',1,'Retail Sale Id 1662',2160.00,0.00,0.00,3.00,150.00,'2023-02-11 10:05:39','',''),(1695,'1','303','1',1,'Retail Sale Id 1663',4320.00,0.00,0.00,6.00,300.00,'2023-02-11 10:18:02','',''),(1696,'1','303','1',1,'Retail Sale Id 1664',900.00,0.00,0.00,1.25,62.50,'2023-02-11 10:25:47','',''),(1697,'1','303','1',1,'Retail Sale Id 1665',4320.00,0.00,0.00,6.00,300.00,'2023-02-11 10:32:48','',''),(1698,'1','303','1',1,'Retail Sale Id 1666',4320.00,0.00,0.00,6.00,300.00,'2023-02-11 10:41:48','',''),(1699,'1','303','1',1,'Retail Sale Id 1667',7999.20,0.00,0.00,11.11,555.50,'2023-02-11 10:44:04','',''),(1700,'1','303','1',1,'Retail Sale Id 1668',1440.00,0.00,0.00,2.00,100.00,'2023-02-11 10:45:52','',''),(1701,'1','303','1',1,'Retail Sale Id 1669',4320.00,0.00,0.00,6.00,300.00,'2023-02-11 10:51:45','',''),(1702,'1','303','1',1,'Retail Sale Id 1670',4320.00,0.00,0.00,6.00,300.00,'2023-02-11 10:59:06','',''),(1703,'1','303','1',1,'Retail Sale Id 1671',2160.00,0.00,0.00,3.00,150.00,'2023-02-11 11:06:27','',''),(1704,'1','303','1',1,'Retail Sale Id 1672',7200.00,0.00,0.00,10.00,500.00,'2023-02-11 11:25:02','',''),(1705,'1','303','1',1,'Retail Sale Id 1673',4320.00,0.00,0.00,6.00,300.00,'2023-02-11 11:26:13','',''),(1706,'1','303','1',1,'Retail Sale Id 1674',4320.00,0.00,0.00,6.00,300.00,'2023-02-11 11:29:12','',''),(1707,'1','303','1',1,'Retail Sale Id 1675',1497.60,0.00,0.00,2.08,104.00,'2023-02-11 11:36:23','',''),(1708,'1','303','1',1,'Retail Sale Id 1676',4320.00,0.00,0.00,6.00,300.00,'2023-02-11 11:41:10','',''),(1709,'1','303','1',1,'Retail Sale Id 1677',40020.00,0.00,0.00,58.00,1160.00,'2023-02-11 11:44:10','',''),(1710,'1','303','1',1,'Retail Sale Id 1678',3600.00,0.00,0.00,5.00,250.00,'2023-02-11 11:46:14','',''),(1711,'1','303','1',1,'Retail Sale Id 1679',3600.00,0.00,0.00,5.00,250.00,'2023-02-11 11:47:55','',''),(1712,'1','303','1',1,'Retail Sale Id 1680',4320.00,0.00,0.00,6.00,300.00,'2023-02-11 11:49:40','',''),(1713,'1','303','1',1,'Retail Sale Id 1681',3600.00,0.00,0.00,5.00,250.00,'2023-02-11 11:51:35','',''),(1714,'1','303','1',1,'Retail Sale Id 1682',4320.00,0.00,0.00,6.00,300.00,'2023-02-11 11:53:49','',''),(1715,'1','303','1',1,'Retail Sale Id 1683',9000.00,0.00,0.00,12.50,625.00,'2023-02-11 12:25:59','',''),(1716,'1','303','1',1,'Retail Sale Id 1684',69000.00,0.00,0.00,100.00,2000.00,'2023-02-11 12:28:46','',''),(1717,'1','303','1',1,'Retail Sale Id 1685',3600.00,0.00,0.00,5.00,250.00,'2023-02-11 12:32:51','',''),(1718,'1','303','1',1,'Retail Sale Id 1685',4320.00,0.00,0.00,6.00,300.00,'2023-02-11 12:32:51','',''),(1719,'1','303','1',1,'Retail Sale Id 1686',9000.00,0.00,0.00,12.50,625.00,'2023-02-11 12:34:34','',''),(1720,'1','303','1',1,'Retail Sale Id 1687',34500.00,0.00,0.00,50.00,1000.00,'2023-02-11 12:36:24','',''),(1721,'1','303','1',1,'Retail Sale Id 1688',3600.00,0.00,0.00,5.00,250.00,'2023-02-11 13:06:00','',''),(1722,'1','303','1',1,'Retail Sale Id 1689',2001.60,0.00,0.00,2.78,139.00,'2023-02-11 13:06:54','',''),(1723,'1','303','1',1,'Retail Sale Id 1690',4320.00,0.00,0.00,6.00,300.00,'2023-02-11 13:18:11','',''),(1724,'1','303','1',1,'Retail Sale Id 1691',3002.40,0.00,0.00,4.17,208.50,'2023-02-11 13:43:26','',''),(1725,'1','303','1',1,'Retail Sale Id 1692',2001.60,0.00,0.00,2.78,139.00,'2023-02-11 14:27:22','',''),(1726,'1','303','1',1,'Retail Sale Id 1693',1440.00,0.00,0.00,2.00,100.00,'2023-02-11 14:49:14','',''),(1727,'1','303','1',1,'Retail Sale Id 1694',4320.00,0.00,0.00,6.00,300.00,'2023-02-11 14:57:21','',''),(1728,'1','303','1',1,'Retail Sale Id 1695',720.00,0.00,0.00,1.00,50.00,'2023-02-11 15:04:16','',''),(1729,'1','303','1',1,'Retail Sale Id 1696',2160.00,0.00,0.00,3.00,150.00,'2023-02-11 15:08:08','',''),(1730,'1','303','1',1,'Retail Sale Id 1697',103500.00,0.00,0.00,150.00,3000.00,'2023-02-11 15:13:12','',''),(1731,'1','303','1',1,'Retail Sale Id 1698',2160.00,0.00,0.00,3.00,150.00,'2023-02-11 15:21:00','',''),(1732,'1','303','1',1,'Retail Sale Id 1698',4320.00,0.00,0.00,6.00,300.00,'2023-02-11 15:21:00','',''),(1733,'1','303','1',1,'Retail Sale Id 1699',4320.00,0.00,0.00,6.00,300.00,'2023-02-11 15:28:35','',''),(1734,'1','303','1',1,'Retail Sale Id 1700',9000.00,0.00,0.00,12.50,625.00,'2023-02-11 15:35:20','',''),(1735,'1','303','1',1,'Retail Sale Id 1701',2001.60,0.00,0.00,2.78,139.00,'2023-02-11 15:56:56','',''),(1736,'1','303','1',1,'Retail Sale Id 1702',3600.00,0.00,0.00,5.00,250.00,'2023-02-11 15:58:37','',''),(1737,'1','303','1',1,'Retail Sale Id 1703',1101.60,0.00,0.00,1.53,76.50,'2023-02-11 16:21:52','',''),(1738,'1','303','1',1,'Retail Sale Id 1704',3600.00,0.00,0.00,5.00,250.00,'2023-02-11 16:27:09','',''),(1739,'1','303','1',1,'Retail Sale Id 1705',3499.20,0.00,0.00,4.86,243.00,'2023-02-11 16:27:55','',''),(1740,'1','303','1',1,'Retail Sale Id 1706',2001.60,0.00,0.00,2.78,139.00,'2023-02-11 16:29:32','',''),(1741,'1','303','1',1,'Retail Sale Id 1707',2160.00,0.00,0.00,3.00,150.00,'2023-02-11 16:37:01','',''),(1742,'1','303','1',1,'Retail Sale Id 1708',720.00,0.00,0.00,1.00,50.00,'2023-02-11 16:38:28','',''),(1743,'1','303','1',1,'Retail Sale Id 1709',9000.00,0.00,0.00,12.50,625.00,'2023-02-11 16:53:11','',''),(1744,'1','303','1',1,'Retail Sale Id 1710',2160.00,0.00,0.00,3.00,150.00,'2023-02-11 16:59:43','',''),(1745,'1','303','1',1,'Retail Sale Id 1711',2160.00,0.00,0.00,3.00,150.00,'2023-02-11 17:30:56','',''),(1746,'1','303','1',1,'Retail Sale Id 1712',2160.00,0.00,0.00,3.00,150.00,'2023-02-11 17:32:14','',''),(1747,'1','303','1',1,'Retail Sale Id 1713',1440.00,0.00,0.00,2.00,100.00,'2023-02-11 17:33:32','',''),(1748,'1','303','1',1,'Retail Sale Id 1714',4320.00,0.00,0.00,6.00,300.00,'2023-02-11 17:43:20','',''),(1749,'1','303','1',1,'Retail Sale Id 1715',3600.00,0.00,0.00,5.00,250.00,'2023-02-11 17:52:59','',''),(1750,'1','303','1',1,'Retail Sale Id 1716',9000.00,0.00,0.00,12.50,625.00,'2023-02-11 17:57:12','',''),(1751,'1','303','1',1,'Retail Sale Id 1717',1080.00,0.00,0.00,1.50,75.00,'2023-02-11 18:01:28','',''),(1752,'1','303','1',1,'Return of Retail Sale Id 1714',0.00,4320.00,6.00,0.00,-300.00,'2023-02-11 18:46:49','',''),(1753,'1','303','1',1,'Retail Sale Id 1718',727.20,0.00,0.00,1.01,50.50,'2023-02-11 18:47:20','',''),(1754,'1','303','1',1,'Retail Sale Id 1719',1440.00,0.00,0.00,2.00,100.00,'2023-02-12 08:39:01','',''),(1755,'1','303','1',1,'Retail Sale Id 1722',4320.00,0.00,0.00,6.00,300.00,'2023-02-12 08:52:04','',''),(1756,'1','303','1',1,'Retail Sale Id 1723',5040.00,0.00,0.00,7.00,350.00,'2023-02-12 09:01:54','',''),(1757,'1','303','1',1,'Retail Sale Id 1724',2160.00,0.00,0.00,3.00,150.00,'2023-02-12 09:04:56','',''),(1758,'1','303','1',1,'Retail Sale Id 1725',7200.00,0.00,0.00,10.00,500.00,'2023-02-12 09:10:42','',''),(1759,'1','303','1',1,'Retail Sale Id 1726',4320.00,0.00,0.00,6.00,300.00,'2023-02-12 09:17:53','',''),(1760,'1','303','1',1,'Retail Sale Id 1727',40020.00,0.00,0.00,58.00,1160.00,'2023-02-12 09:27:23','',''),(1761,'1','303','1',1,'Retail Sale Id 1728',3600.00,0.00,0.00,5.00,250.00,'2023-02-12 09:43:04','',''),(1762,'1','303','1',1,'Retail Sale Id 1728',3600.00,0.00,0.00,5.00,250.00,'2023-02-12 09:43:04','',''),(1763,'1','303','1',1,'Retail Sale Id 1729',2160.00,0.00,0.00,3.00,150.00,'2023-02-12 09:44:56','',''),(1764,'1','303','1',1,'Retail Sale Id 1730',2160.00,0.00,0.00,3.00,150.00,'2023-02-12 10:09:29','',''),(1765,'1','303','1',1,'Retail Sale Id 1731',4500.00,0.00,0.00,6.25,312.50,'2023-02-12 10:14:42','',''),(1766,'1','303','1',1,'Retail Sale Id 1732',4320.00,0.00,0.00,6.00,300.00,'2023-02-12 10:24:15','',''),(1767,'1','303','1',1,'Retail Sale Id 1733',4320.00,0.00,0.00,6.00,300.00,'2023-02-12 10:42:14','',''),(1768,'1','303','1',1,'Retail Sale Id 1734',4320.00,0.00,0.00,6.00,300.00,'2023-02-12 10:43:20','',''),(1769,'1','303','1',1,'Retail Sale Id 1735',5040.00,0.00,0.00,7.00,350.00,'2023-02-12 10:48:27','',''),(1770,'1','303','1',1,'Retail Sale Id 1736',1000.80,0.00,0.00,1.39,69.50,'2023-02-12 11:10:39','',''),(1771,'1','303','1',1,'Retail Sale Id 1737',4320.00,0.00,0.00,6.00,300.00,'2023-02-12 11:20:26','',''),(1772,'1','303','1',1,'Retail Sale Id 1738',3600.00,0.00,0.00,5.00,250.00,'2023-02-12 11:21:47','',''),(1773,'1','303','1',1,'Retail Sale Id 1739',2160.00,0.00,0.00,3.00,150.00,'2023-02-12 11:29:40','',''),(1774,'1','303','1',1,'Retail Sale Id 1740',34500.00,0.00,0.00,50.00,1000.00,'2023-02-12 11:43:14','',''),(1775,'1','303','1',1,'Retail Sale Id 1741',1497.60,0.00,0.00,2.08,104.00,'2023-02-12 11:44:33','',''),(1776,'1','303','1',1,'Retail Sale Id 1742',2001.60,0.00,0.00,2.78,139.00,'2023-02-12 11:46:01','',''),(1777,'1','303','1',1,'Retail Sale Id 1743',1000.80,0.00,0.00,1.39,69.50,'2023-02-12 11:52:42','',''),(1778,'1','303','1',1,'Retail Sale Id 1744',2160.00,0.00,0.00,3.00,150.00,'2023-02-12 11:55:40','',''),(1779,'1','303','1',1,'Retail Sale Id 1745',4320.00,0.00,0.00,6.00,300.00,'2023-02-12 12:00:21','',''),(1780,'1','303','1',1,'Retail Sale Id 1746',4500.00,0.00,0.00,6.25,312.50,'2023-02-12 12:05:58','',''),(1781,'1','303','1',1,'Retail Sale Id 1747',9000.00,0.00,0.00,12.50,625.00,'2023-02-12 12:08:34','',''),(1782,'1','303','1',1,'Retail Sale Id 1748',5702.40,0.00,0.00,7.92,396.00,'2023-02-12 12:13:21','',''),(1783,'1','303','1',1,'Retail Sale Id 1749',4500.00,0.00,0.00,6.25,312.50,'2023-02-12 12:17:52','',''),(1784,'1','303','1',1,'Retail Sale Id 1751',3600.00,0.00,0.00,5.00,250.00,'2023-02-12 12:51:57','',''),(1785,'1','303','1',1,'Retail Sale Id 1752',9000.00,0.00,0.00,12.50,625.00,'2023-02-12 12:52:48','',''),(1786,'1','303','1',1,'Retail Sale Id 1753',4320.00,0.00,0.00,6.00,300.00,'2023-02-12 12:56:25','',''),(1787,'1','303','1',1,'Retail Sale Id 1754',31320.00,0.00,0.00,43.50,2175.00,'2023-02-12 13:00:36','',''),(1788,'1','303','1',1,'Retail Sale Id 1755',1497.60,0.00,0.00,2.08,104.00,'2023-02-12 13:12:04','',''),(1789,'1','303','1',1,'Retail Sale Id 1755',1497.60,0.00,0.00,2.08,104.00,'2023-02-12 13:12:04','',''),(1790,'1','303','1',1,'Retail Sale Id 1756',9000.00,0.00,0.00,12.50,625.00,'2023-02-12 13:13:31','',''),(1791,'1','303','1',1,'Retail Sale Id 1757',2001.60,0.00,0.00,2.78,139.00,'2023-02-12 13:23:03','',''),(1792,'1','303','1',1,'Retail Sale Id 1758',3600.00,0.00,0.00,5.00,250.00,'2023-02-12 14:03:16','',''),(1793,'1','303','1',1,'Retail Sale Id 1759',4320.00,0.00,0.00,6.00,300.00,'2023-02-12 14:05:43','',''),(1794,'1','303','1',1,'Retail Sale Id 1760',7200.00,0.00,0.00,10.00,500.00,'2023-02-12 14:21:24','',''),(1795,'1','303','1',1,'Retail Sale Id 1761',1000.80,0.00,0.00,1.39,69.50,'2023-02-12 14:55:34','',''),(1796,'1','303','1',1,'Retail Sale Id 1762',2160.00,0.00,0.00,3.00,150.00,'2023-02-12 14:58:34','',''),(1797,'1','303','1',1,'Retail Sale Id 1763',3002.40,0.00,0.00,4.17,208.50,'2023-02-12 15:00:04','',''),(1798,'1','303','1',1,'Retail Sale Id 1764',1000.80,0.00,0.00,1.39,69.50,'2023-02-12 15:07:16','',''),(1799,'1','303','1',1,'Retail Sale Id 1765',2152.80,0.00,0.00,2.99,149.50,'2023-02-12 15:09:51','',''),(1800,'1','303','1',1,'Retail Sale Id 1766',5040.00,0.00,0.00,7.00,350.00,'2023-02-12 15:12:17','',''),(1801,'1','303','1',1,'Retail Sale Id 1767',34500.00,0.00,0.00,50.00,1000.00,'2023-02-12 15:19:29','',''),(1802,'1','303','1',1,'Retail Sale Id 1768',7200.00,0.00,0.00,10.00,500.00,'2023-02-12 15:20:55','',''),(1803,'1','303','1',1,'Retail Sale Id 1769',9000.00,0.00,0.00,12.50,625.00,'2023-02-12 15:36:19','',''),(1804,'1','303','1',1,'Retail Sale Id 1770',2880.00,0.00,0.00,4.00,200.00,'2023-02-12 16:12:01','',''),(1805,'1','303','1',1,'Retail Sale Id 1771',2001.60,0.00,0.00,2.78,139.00,'2023-02-12 16:13:46','',''),(1806,'1','303','1',1,'Retail Sale Id 1772',2160.00,0.00,0.00,3.00,150.00,'2023-02-12 16:15:51','',''),(1807,'1','303','1',1,'Retail Sale Id 1773',3600.00,0.00,0.00,5.00,250.00,'2023-02-12 16:23:05','',''),(1808,'1','303','1',1,'Return of Retail Sale Id 1748',0.00,5702.40,7.92,0.00,-396.00,'2023-02-12 16:33:53','',''),(1809,'1','303','1',1,'Retail Sale Id 1774',3002.40,0.00,0.00,4.17,208.50,'2023-02-12 16:37:46','',''),(1810,'1','303','1',1,'Retail Sale Id 1775',103500.00,0.00,0.00,150.00,3000.00,'2023-02-12 16:53:14','',''),(1811,'1','303','1',1,'Retail Sale Id 1776',2160.00,0.00,0.00,3.00,150.00,'2023-02-12 17:03:40','',''),(1812,'1','303','1',1,'Retail Sale Id 1776',4320.00,0.00,0.00,6.00,300.00,'2023-02-12 17:03:40','',''),(1813,'1','303','1',1,'Retail Sale Id 1777',9000.00,0.00,0.00,12.50,625.00,'2023-02-12 17:06:07','',''),(1814,'1','303','1',1,'Retail Sale Id 1778',4320.00,0.00,0.00,6.00,300.00,'2023-02-12 17:07:10','',''),(1815,'1','303','1',1,'Retail Sale Id 1779',2160.00,0.00,0.00,3.00,150.00,'2023-02-12 17:08:26','',''),(1816,'1','303','1',1,'Retail Sale Id 1780',3600.00,0.00,0.00,5.00,250.00,'2023-02-12 17:27:43','',''),(1817,'1','303','1',1,'Retail Sale Id 1781',2001.60,0.00,0.00,2.78,139.00,'2023-02-12 17:37:36','',''),(1818,'1','303','1',1,'Retail Sale Id 1782',2160.00,0.00,0.00,3.00,150.00,'2023-02-12 17:40:59','',''),(1819,'1','303','1',1,'Retail Sale Id 1783',2001.60,0.00,0.00,2.78,139.00,'2023-02-12 17:45:09','',''),(1820,'1','303','1',1,'Retail Sale Id 1784',4320.00,0.00,0.00,6.00,300.00,'2023-02-12 17:48:15','',''),(1821,'1','303','1',1,'Retail Sale Id 1785',4320.00,0.00,0.00,6.00,300.00,'2023-02-12 17:55:24','',''),(1822,'1','303','1',1,'Retail Sale Id 1786',2160.00,0.00,0.00,3.00,150.00,'2023-02-12 17:57:22','',''),(1823,'1','303','1',1,'Retail Sale Id 1787',4320.00,0.00,0.00,6.00,300.00,'2023-02-12 17:59:00','',''),(1824,'1','303','1',1,'Retail Sale Id 1788',3600.00,0.00,0.00,5.00,250.00,'2023-02-12 18:01:52','',''),(1825,'1','303','1',1,'Retail Sale Id 1789',3600.00,0.00,0.00,5.00,250.00,'2023-02-12 18:08:54','',''),(1826,'1','303','1',1,'Return of Retail Sale Id 1764',0.00,1000.80,1.39,0.00,-69.50,'2023-02-12 19:38:27','',''),(1827,'1','303','1',1,'Retail Sale Id 1790',482.40,0.00,0.00,0.67,33.50,'2023-02-12 19:39:24','',''),(1828,'1','303','1',1,'Retail Sale Id 1791',28.80,0.00,0.00,0.04,2.00,'2023-02-12 19:41:56','',''),(1829,'1','303','1',1,'Retail Sale Id 1792',276000.00,0.00,0.00,400.00,8000.00,'2023-02-12 19:57:06','',''),(1830,'1','303','1',1,'Retail Sale Id 1794',2160.00,0.00,0.00,3.00,150.00,'2023-02-13 08:13:28','',''),(1831,'1','303','1',1,'Retail Sale Id 1795',4320.00,0.00,0.00,6.00,300.00,'2023-02-13 08:14:17','',''),(1832,'1','303','1',1,'Retail Sale Id 1796',2160.00,0.00,0.00,3.00,150.00,'2023-02-13 08:26:51','',''),(1833,'1','303','1',1,'Retail Sale Id 1798',4320.00,0.00,0.00,6.00,300.00,'2023-02-13 08:30:30','',''),(1834,'1','303','1',1,'Retail Sale Id 1799',2498.40,0.00,0.00,3.47,173.50,'2023-02-13 08:36:25','',''),(1835,'1','303','1',1,'Retail Sale Id 1800',4320.00,0.00,0.00,6.00,300.00,'2023-02-13 10:39:33','',''),(1836,'1','303','1',1,'Retail Sale Id 1801',4320.00,0.00,0.00,6.00,300.00,'2023-02-13 10:40:25','',''),(1837,'1','303','1',1,'Retail Sale Id 1802',1497.60,0.00,0.00,2.08,104.00,'2023-02-13 10:41:09','',''),(1838,'1','303','1',1,'Retail Sale Id 1803',4320.00,0.00,0.00,6.00,300.00,'2023-02-13 10:41:48','',''),(1839,'1','303','1',1,'Retail Sale Id 1804',2880.00,0.00,0.00,4.00,200.00,'2023-02-13 10:42:21','',''),(1840,'1','303','1',1,'Retail Sale Id 1805',4320.00,0.00,0.00,6.00,300.00,'2023-02-13 10:42:55','',''),(1841,'1','303','1',1,'Retail Sale Id 1806',4320.00,0.00,0.00,6.00,300.00,'2023-02-13 10:43:35','',''),(1842,'1','303','1',1,'Retail Sale Id 1808',2160.00,0.00,0.00,3.00,150.00,'2023-02-13 10:44:47','',''),(1843,'1','303','1',1,'Retail Sale Id 1809',9000.00,0.00,0.00,12.50,625.00,'2023-02-13 10:45:40','',''),(1844,'1','303','1',1,'Retail Sale Id 1810',4320.00,0.00,0.00,6.00,300.00,'2023-02-13 10:46:28','',''),(1845,'1','303','1',1,'Retail Sale Id 1811',2160.00,0.00,0.00,3.00,150.00,'2023-02-13 10:47:19','',''),(1846,'1','303','1',1,'Retail Sale Id 1812',2001.60,0.00,0.00,2.78,139.00,'2023-02-13 10:47:55','',''),(1847,'1','303','1',1,'Retail Sale Id 1813',2001.60,0.00,0.00,2.78,139.00,'2023-02-13 10:48:36','',''),(1848,'1','303','1',1,'Retail Sale Id 1814',2160.00,0.00,0.00,3.00,150.00,'2023-02-13 10:49:27','',''),(1849,'1','303','1',1,'Retail Sale Id 1815',2001.60,0.00,0.00,2.78,139.00,'2023-02-13 10:50:07','',''),(1850,'1','303','1',1,'Retail Sale Id 1816',4320.00,0.00,0.00,6.00,300.00,'2023-02-13 10:54:24','',''),(1851,'1','303','1',1,'Retail Sale Id 1817',4320.00,0.00,0.00,6.00,300.00,'2023-02-13 11:08:02','',''),(1852,'1','303','1',1,'Retail Sale Id 1818',34500.00,0.00,0.00,50.00,1000.00,'2023-02-13 11:28:17','',''),(1853,'1','303','1',1,'Retail Sale Id 1819',1202.40,0.00,0.00,1.67,83.50,'2023-02-13 11:30:33','',''),(1854,'1','303','1',1,'Retail Sale Id 1821',3002.40,0.00,0.00,4.17,208.50,'2023-02-13 11:35:00','',''),(1855,'1','303','1',1,'Retail Sale Id 1822',2160.00,0.00,0.00,3.00,150.00,'2023-02-13 11:48:28','',''),(1856,'1','303','1',1,'Retail Sale Id 1823',40020.00,0.00,0.00,58.00,1160.00,'2023-02-13 11:51:03','',''),(1857,'1','303','1',1,'Retail Sale Id 1824',2160.00,0.00,0.00,3.00,150.00,'2023-02-13 11:51:47','',''),(1858,'1','303','1',1,'Retail Sale Id 1825',4348.80,0.00,0.00,6.04,302.00,'2023-02-13 11:56:14','',''),(1859,'1','303','1',1,'Retail Sale Id 1826',4348.80,0.00,0.00,6.04,302.00,'2023-02-13 12:03:37','',''),(1860,'1','303','1',1,'Retail Sale Id 1827',7200.00,0.00,0.00,10.00,500.00,'2023-02-13 12:09:24','',''),(1861,'1','303','1',1,'Retail Sale Id 1828',2160.00,0.00,0.00,3.00,150.00,'2023-02-13 12:13:53','',''),(1862,'1','303','1',1,'Retail Sale Id 1829',2160.00,0.00,0.00,3.00,150.00,'2023-02-13 12:27:47','',''),(1863,'1','303','1',1,'Retail Sale Id 1830',3002.40,0.00,0.00,4.17,208.50,'2023-02-13 12:32:12','',''),(1864,'1','303','1',1,'Retail Sale Id 1831',2160.00,0.00,0.00,3.00,150.00,'2023-02-13 12:39:03','',''),(1865,'1','303','1',1,'Retail Sale Id 1832',1000.80,0.00,0.00,1.39,69.50,'2023-02-13 12:44:08','',''),(1866,'1','303','1',1,'Retail Sale Id 1833',9000.00,0.00,0.00,12.50,625.00,'2023-02-13 12:46:45','',''),(1867,'1','303','1',1,'Retail Sale Id 1834',2880.00,0.00,0.00,4.00,200.00,'2023-02-13 12:48:56','',''),(1868,'1','303','1',1,'Retail Sale Id 1835',7200.00,0.00,0.00,10.00,500.00,'2023-02-13 12:54:33','',''),(1869,'1','303','1',1,'Retail Sale Id 1836',2001.60,0.00,0.00,2.78,139.00,'2023-02-13 12:55:49','',''),(1870,'1','303','1',1,'Retail Sale Id 1837',3002.40,0.00,0.00,4.17,208.50,'2023-02-13 12:56:51','',''),(1871,'1','303','1',1,'Retail Sale Id 1838',4320.00,0.00,0.00,6.00,300.00,'2023-02-13 12:58:38','',''),(1872,'1','303','1',1,'Retail Sale Id 1839',2880.00,0.00,0.00,4.00,200.00,'2023-02-13 13:01:20','',''),(1873,'1','303','1',1,'Retail Sale Id 1840',4500.00,0.00,0.00,6.25,312.50,'2023-02-13 13:02:40','',''),(1874,'1','303','1',1,'Retail Sale Id 1841',2160.00,0.00,0.00,3.00,150.00,'2023-02-13 13:09:10','',''),(1875,'1','303','1',1,'Retail Sale Id 1842',9000.00,0.00,0.00,12.50,625.00,'2023-02-13 13:33:11','',''),(1876,'1','303','1',1,'Retail Sale Id 1843',4320.00,0.00,0.00,6.00,300.00,'2023-02-13 13:40:01','',''),(1877,'1','303','1',1,'Retail Sale Id 1844',34500.00,0.00,0.00,50.00,1000.00,'2023-02-13 13:47:39','',''),(1878,'1','303','1',1,'Retail Sale Id 1845',3600.00,0.00,0.00,5.00,250.00,'2023-02-13 14:15:49','',''),(1879,'1','303','1',1,'Retail Sale Id 1846',71070.00,0.00,0.00,103.00,2060.00,'2023-02-13 14:19:40','',''),(1880,'1','303','1',1,'Retail Sale Id 1847',1497.60,0.00,0.00,2.08,104.00,'2023-02-13 14:20:19','',''),(1881,'1','303','1',1,'Retail Sale Id 1848',2001.60,0.00,0.00,2.78,139.00,'2023-02-13 14:37:37','',''),(1882,'1','303','1',1,'Retail Sale Id 1849',1440.00,0.00,0.00,2.00,100.00,'2023-02-13 15:35:29','',''),(1883,'1','303','1',1,'Retail Sale Id 1851',4320.00,0.00,0.00,6.00,300.00,'2023-02-13 16:08:45','',''),(1884,'1','303','1',1,'Retail Sale Id 1852',3600.00,0.00,0.00,5.00,250.00,'2023-02-13 16:09:58','',''),(1885,'1','303','1',1,'Retail Sale Id 1853',1000.80,0.00,0.00,1.39,69.50,'2023-02-13 16:10:55','',''),(1886,'1','303','1',1,'Retail Sale Id 1854',26220.00,0.00,0.00,38.00,760.00,'2023-02-13 16:16:53','',''),(1887,'1','303','1',1,'Retail Sale Id 1855',9000.00,0.00,0.00,12.50,625.00,'2023-02-13 16:20:14','',''),(1888,'1','303','1',1,'Retail Sale Id 1857',2203.20,0.00,0.00,3.06,153.00,'2023-02-13 16:31:51','',''),(1889,'1','303','1',1,'Retail Sale Id 1858',3600.00,0.00,0.00,5.00,250.00,'2023-02-13 16:33:28','',''),(1890,'1','303','1',1,'Retail Sale Id 1859',2160.00,0.00,0.00,3.00,150.00,'2023-02-13 16:34:28','',''),(1891,'1','303','1',1,'Retail Sale Id 1860',4320.00,0.00,0.00,6.00,300.00,'2023-02-13 16:39:07','',''),(1892,'1','303','1',1,'Retail Sale Id 1861',9000.00,0.00,0.00,12.50,625.00,'2023-02-13 16:41:06','',''),(1893,'1','303','1',1,'Retail Sale Id 1862',9000.00,0.00,0.00,12.50,625.00,'2023-02-13 16:42:44','',''),(1894,'1','303','1',1,'Retail Sale Id 1863',4320.00,0.00,0.00,6.00,300.00,'2023-02-13 16:47:21','',''),(1895,'1','303','1',1,'Retail Sale Id 1864',1000.80,0.00,0.00,1.39,69.50,'2023-02-13 16:49:55','',''),(1896,'1','303','1',1,'Retail Sale Id 1865',2880.00,0.00,0.00,4.00,200.00,'2023-02-13 17:06:36','',''),(1897,'1','303','1',1,'Retail Sale Id 1866',2001.60,0.00,0.00,2.78,139.00,'2023-02-13 17:10:19','',''),(1898,'1','303','1',1,'Retail Sale Id 1867',69000.00,0.00,0.00,100.00,2000.00,'2023-02-13 17:15:17','',''),(1899,'1','303','1',1,'Retail Sale Id 1868',4320.00,0.00,0.00,6.00,300.00,'2023-02-13 17:22:22','',''),(1900,'1','303','1',1,'Retail Sale Id 1869',2160.00,0.00,0.00,3.00,150.00,'2023-02-13 17:34:08','',''),(1901,'1','303','1',1,'Retail Sale Id 1870',3600.00,0.00,0.00,5.00,250.00,'2023-02-13 17:36:31','',''),(1902,'1','303','1',1,'Retail Sale Id 1871',1440.00,0.00,0.00,2.00,100.00,'2023-02-13 17:38:22','',''),(1903,'1','303','1',1,'Retail Sale Id 1872',4320.00,0.00,0.00,6.00,300.00,'2023-02-13 17:45:18','',''),(1904,'1','303','1',1,'Retail Sale Id 1873',7200.00,0.00,0.00,10.00,500.00,'2023-02-13 18:05:03','',''),(1905,'1','303','1',1,'Retail Sale Id 1874',4996.80,0.00,0.00,6.94,347.00,'2023-02-13 18:09:04','',''),(1906,'1','303','1',1,'Retail Sale Id 1875',1000.80,0.00,0.00,1.39,69.50,'2023-02-13 18:10:35','',''),(1907,'1','303','1',1,'Retail Sale Id 1876',14.40,0.00,0.00,0.02,1.00,'2023-02-13 19:26:27','',''),(1908,'1','303','1',1,'Retail Sale Id 1877',3600.00,0.00,0.00,5.00,250.00,'2023-02-14 08:16:32','',''),(1909,'1','303','1',1,'Retail Sale Id 1878',4320.00,0.00,0.00,6.00,300.00,'2023-02-14 08:20:47','',''),(1910,'1','303','1',1,'Retail Sale Id 1879',10000.80,0.00,0.00,13.89,694.50,'2023-02-14 08:23:33','',''),(1911,'1','303','1',1,'Retail Sale Id 1880',69000.00,0.00,0.00,100.00,2000.00,'2023-02-14 09:12:20','',''),(1912,'1','303','1',1,'Retail Sale Id 1881',4996.80,0.00,0.00,6.94,347.00,'2023-02-14 09:30:54','',''),(1913,'1','303','1',1,'Retail Sale Id 1881',4996.80,0.00,0.00,6.94,347.00,'2023-02-14 09:30:54','',''),(1914,'1','303','1',1,'Retail Sale Id 1883',4320.00,0.00,0.00,6.00,300.00,'2023-02-14 09:48:14','',''),(1915,'1','303','1',1,'Retail Sale Id 1883',9000.00,0.00,0.00,12.50,625.00,'2023-02-14 09:48:14','',''),(1916,'1','303','1',1,'Retail Sale Id 1884',1202.40,0.00,0.00,1.67,83.50,'2023-02-14 09:51:34','',''),(1917,'1','303','1',1,'Retail Sale Id 1885',4320.00,0.00,0.00,6.00,300.00,'2023-02-14 10:03:14','',''),(1918,'1','303','1',1,'Retail Sale Id 1887',2001.60,0.00,0.00,2.78,139.00,'2023-02-14 10:37:27','',''),(1919,'1','303','1',1,'Retail Sale Id 1888',4320.00,0.00,0.00,6.00,300.00,'2023-02-14 11:53:49','',''),(1920,'1','303','1',1,'Retail Sale Id 1889',1000.80,0.00,0.00,1.39,69.50,'2023-02-14 11:55:05','',''),(1921,'1','303','1',1,'Retail Sale Id 1890',4320.00,0.00,0.00,6.00,300.00,'2023-02-14 12:02:10','',''),(1922,'1','303','1',1,'Retail Sale Id 1891',4320.00,0.00,0.00,6.00,300.00,'2023-02-14 12:17:30','',''),(1923,'1','303','1',1,'Retail Sale Id 1892',1497.60,0.00,0.00,2.08,104.00,'2023-02-14 12:25:45','',''),(1924,'1','303','1',1,'Retail Sale Id 1893',4320.00,0.00,0.00,6.00,300.00,'2023-02-14 12:35:30','',''),(1925,'1','303','1',1,'Retail Sale Id 1894',4320.00,0.00,0.00,6.00,300.00,'2023-02-14 12:47:28','',''),(1926,'1','303','1',1,'Retail Sale Id 1894',7200.00,0.00,0.00,10.00,500.00,'2023-02-14 12:47:28','',''),(1927,'1','303','1',1,'Retail Sale Id 1895',1000.80,0.00,0.00,1.39,69.50,'2023-02-14 12:58:43','',''),(1928,'1','303','1',1,'Retail Sale Id 1896',4320.00,0.00,0.00,6.00,300.00,'2023-02-14 13:29:06','',''),(1929,'1','303','1',1,'Retail Sale Id 1897',4320.00,0.00,0.00,6.00,300.00,'2023-02-14 13:39:39','',''),(1930,'1','303','1',1,'Retail Sale Id 1898',2160.00,0.00,0.00,3.00,150.00,'2023-02-14 13:42:06','',''),(1931,'1','303','1',1,'Retail Sale Id 1899',3600.00,0.00,0.00,5.00,250.00,'2023-02-14 13:43:49','',''),(1932,'1','303','1',1,'Retail Sale Id 1900',2160.00,0.00,0.00,3.00,150.00,'2023-02-14 14:23:54','',''),(1933,'1','303','1',1,'Retail Sale Id 1901',4320.00,0.00,0.00,6.00,300.00,'2023-02-14 14:28:18','',''),(1934,'1','303','1',1,'Retail Sale Id 1902',2498.40,0.00,0.00,3.47,173.50,'2023-02-14 14:29:21','',''),(1935,'1','303','1',1,'Retail Sale Id 1903',1000.80,0.00,0.00,1.39,69.50,'2023-02-14 14:32:24','',''),(1936,'1','303','1',1,'Retail Sale Id 1903',4320.00,0.00,0.00,6.00,300.00,'2023-02-14 14:32:24','',''),(1937,'1','303','1',1,'Retail Sale Id 1904',3600.00,0.00,0.00,5.00,250.00,'2023-02-14 14:35:48','',''),(1938,'1','303','1',1,'Retail Sale Id 1905',4320.00,0.00,0.00,6.00,300.00,'2023-02-14 14:59:13','',''),(1939,'1','303','1',1,'Retail Sale Id 1906',4320.00,0.00,0.00,6.00,300.00,'2023-02-14 15:18:18','',''),(1940,'1','303','1',1,'Retail Sale Id 1907',4003.20,0.00,0.00,5.56,278.00,'2023-02-14 15:19:21','',''),(1941,'1','303','1',1,'Retail Sale Id 1908',4320.00,0.00,0.00,6.00,300.00,'2023-02-14 15:25:42','',''),(1942,'1','303','1',1,'Retail Sale Id 1909',9000.00,0.00,0.00,12.50,625.00,'2023-02-14 15:35:17','',''),(1943,'1','303','1',1,'Retail Sale Id 1910',2160.00,0.00,0.00,3.00,150.00,'2023-02-14 16:08:24','',''),(1944,'1','303','1',1,'Retail Sale Id 1911',2001.60,0.00,0.00,2.78,139.00,'2023-02-14 16:58:10','',''),(1945,'1','303','1',1,'Retail Sale Id 1912',3002.40,0.00,0.00,4.17,208.50,'2023-02-14 17:02:31','',''),(1946,'1','303','1',1,'Retail Sale Id 1913',2160.00,0.00,0.00,3.00,150.00,'2023-02-14 17:13:42','',''),(1947,'1','303','1',1,'Retail Sale Id 1914',1440.00,0.00,0.00,2.00,100.00,'2023-02-14 17:18:28','',''),(1948,'1','303','1',1,'Retail Sale Id 1915',1202.40,0.00,0.00,1.67,83.50,'2023-02-14 17:21:16','',''),(1949,'1','303','1',1,'Retail Sale Id 1917',2001.60,0.00,0.00,2.78,139.00,'2023-02-14 17:26:40','',''),(1950,'1','303','1',1,'Retail Sale Id 1918',3002.40,0.00,0.00,4.17,208.50,'2023-02-14 17:29:32','',''),(1951,'1','303','1',1,'Retail Sale Id 1919',1000.80,0.00,0.00,1.39,69.50,'2023-02-14 17:34:53','',''),(1952,'1','303','1',1,'Retail Sale Id 1921',698.40,0.00,0.00,0.97,48.50,'2023-02-14 17:38:45','',''),(1953,'1','303','1',1,'Retail Sale Id 1922',2160.00,0.00,0.00,3.00,150.00,'2023-02-14 17:45:56','',''),(1954,'1','303','1',1,'Retail Sale Id 1922',4320.00,0.00,0.00,6.00,300.00,'2023-02-14 17:45:56','',''),(1955,'1','303','1',1,'Retail Sale Id 1922',9000.00,0.00,0.00,12.50,625.00,'2023-02-14 17:45:56','',''),(1956,'1','303','1',1,'Retail Sale Id 1923',2203.20,0.00,0.00,3.06,153.00,'2023-02-14 18:15:40','',''),(1957,'1','303','1',1,'Return of Retail Sale Id 1918',0.00,3002.40,4.17,0.00,-208.50,'2023-02-14 19:13:34','',''),(1958,'1','303','1',1,'Return of Retail Sale Id 1919',0.00,1000.80,1.39,0.00,-69.50,'2023-02-14 19:15:11','',''),(1959,'1','303','1',1,'Return of Retail Sale Id 1921',0.00,698.40,0.97,0.00,-48.50,'2023-02-14 19:20:14','',''),(1960,'1','303','1',1,'Retail Sale Id 1924',352.80,0.00,0.00,0.49,24.50,'2023-02-14 19:21:25','',''),(1961,'1','303','1',1,'Retail Sale Id 1925',2001.60,0.00,0.00,2.78,139.00,'2023-02-15 08:12:27','',''),(1962,'1','303','1',1,'Retail Sale Id 1926',3600.00,0.00,0.00,5.00,250.00,'2023-02-15 08:47:59','',''),(1963,'1','303','1',1,'Retail Sale Id 1927',9000.00,0.00,0.00,12.50,625.00,'2023-02-15 08:49:43','',''),(1964,'1','303','1',1,'Retail Sale Id 1928',4320.00,0.00,0.00,6.00,300.00,'2023-02-15 08:51:52','',''),(1965,'1','303','1',1,'Retail Sale Id 1929',3002.40,0.00,0.00,4.17,208.50,'2023-02-15 09:00:48','',''),(1966,'1','303','1',1,'Retail Sale Id 1930',4320.00,0.00,0.00,6.00,300.00,'2023-02-15 09:22:50','',''),(1967,'1','303','1',1,'Retail Sale Id 1931',4320.00,0.00,0.00,6.00,300.00,'2023-02-15 09:25:09','',''),(1968,'1','303','1',1,'Retail Sale Id 1932',4320.00,0.00,0.00,6.00,300.00,'2023-02-15 09:38:40','',''),(1969,'1','303','1',1,'Retail Sale Id 1933',1000.80,0.00,0.00,1.39,69.50,'2023-02-15 09:52:22','',''),(1970,'1','303','1',1,'Retail Sale Id 1934',9000.00,0.00,0.00,12.50,625.00,'2023-02-15 09:55:38','',''),(1971,'1','303','1',1,'Retail Sale Id 1935',34500.00,0.00,0.00,50.00,1000.00,'2023-02-15 10:00:35','',''),(1972,'1','303','1',1,'Retail Sale Id 1936',4320.00,0.00,0.00,6.00,300.00,'2023-02-15 10:15:23','',''),(1973,'1','303','1',1,'Retail Sale Id 1937',2160.00,0.00,0.00,3.00,150.00,'2023-02-15 10:17:49','',''),(1974,'1','303','1',1,'Retail Sale Id 1938',4320.00,0.00,0.00,6.00,300.00,'2023-02-15 10:20:08','',''),(1975,'1','303','1',1,'Retail Sale Id 1939',2160.00,0.00,0.00,3.00,150.00,'2023-02-15 11:01:15','',''),(1976,'1','303','1',1,'Retail Sale Id 1940',2160.00,0.00,0.00,3.00,150.00,'2023-02-15 11:06:32','',''),(1977,'1','303','1',1,'Retail Sale Id 1941',1000.80,0.00,0.00,1.39,69.50,'2023-02-15 11:13:18','',''),(1978,'1','303','1',1,'Retail Sale Id 1942',9000.00,0.00,0.00,12.50,625.00,'2023-02-15 11:20:44','',''),(1979,'1','303','1',1,'Retail Sale Id 1943',4320.00,0.00,0.00,6.00,300.00,'2023-02-15 11:22:27','',''),(1980,'1','303','1',1,'Retail Sale Id 1944',1000.80,0.00,0.00,1.39,69.50,'2023-02-15 11:26:54','',''),(1981,'1','303','1',1,'Retail Sale Id 1945',69000.00,0.00,0.00,100.00,2000.00,'2023-02-15 11:32:28','',''),(1982,'1','303','1',1,'Retail Sale Id 1946',1497.60,0.00,0.00,2.08,104.00,'2023-02-15 11:52:13','',''),(1983,'1','303','1',1,'Retail Sale Id 1947',4320.00,0.00,0.00,6.00,300.00,'2023-02-15 11:56:10','',''),(1984,'1','303','1',1,'Retail Sale Id 1948',4320.00,0.00,0.00,6.00,300.00,'2023-02-15 12:14:41','',''),(1985,'1','303','1',1,'Retail Sale Id 1949',4996.80,0.00,0.00,6.94,347.00,'2023-02-15 12:18:57','',''),(1986,'1','303','1',1,'Retail Sale Id 1950',4996.80,0.00,0.00,6.94,347.00,'2023-02-15 12:20:16','',''),(1987,'1','303','1',1,'Retail Sale Id 1951',3600.00,0.00,0.00,5.00,250.00,'2023-02-15 12:30:41','',''),(1988,'1','303','1',1,'Retail Sale Id 1952',34500.00,0.00,0.00,50.00,1000.00,'2023-02-15 12:46:02','',''),(1989,'1','303','1',1,'Retail Sale Id 1953',4320.00,0.00,0.00,6.00,300.00,'2023-02-15 13:27:42','',''),(1990,'1','303','1',1,'Retail Sale Id 1954',9000.00,0.00,0.00,12.50,625.00,'2023-02-15 13:31:03','',''),(1991,'1','303','1',1,'Retail Sale Id 1955',1000.80,0.00,0.00,1.39,69.50,'2023-02-15 13:49:38','',''),(1992,'1','303','1',1,'Retail Sale Id 1956',2160.00,0.00,0.00,3.00,150.00,'2023-02-15 13:53:26','',''),(1993,'1','303','1',1,'Retail Sale Id 1956',4320.00,0.00,0.00,6.00,300.00,'2023-02-15 13:53:26','',''),(1994,'1','303','1',1,'Retail Sale Id 1957',4320.00,0.00,0.00,6.00,300.00,'2023-02-15 13:55:17','',''),(1995,'1','303','1',1,'Retail Sale Id 1958',1497.60,0.00,0.00,2.08,104.00,'2023-02-15 14:20:53','',''),(1996,'1','303','1',1,'Retail Sale Id 1959',1497.60,0.00,0.00,2.08,104.00,'2023-02-15 14:35:01','',''),(1997,'1','303','1',1,'Retail Sale Id 1960',4320.00,0.00,0.00,6.00,300.00,'2023-02-15 14:48:46','',''),(1998,'1','303','1',1,'Retail Sale Id 1961',2001.60,0.00,0.00,2.78,139.00,'2023-02-15 14:52:48','',''),(1999,'1','303','1',1,'Retail Sale Id 1962',4320.00,0.00,0.00,6.00,300.00,'2023-02-15 14:54:13','',''),(2000,'1','303','1',1,'Retail Sale Id 1964',9000.00,0.00,0.00,12.50,625.00,'2023-02-15 15:11:58','',''),(2001,'1','303','1',1,'Retail Sale Id 1965',8640.00,0.00,0.00,12.00,600.00,'2023-02-15 15:22:31','',''),(2002,'1','303','1',1,'Retail Sale Id 1966',7200.00,0.00,0.00,10.00,500.00,'2023-02-15 15:24:39','',''),(2003,'1','303','1',1,'Retail Sale Id 1967',720.00,0.00,0.00,1.00,50.00,'2023-02-15 15:58:37','',''),(2004,'1','303','1',1,'Retail Sale Id 1968',9000.00,0.00,0.00,12.50,625.00,'2023-02-15 16:14:06','',''),(2005,'1','303','1',1,'Retail Sale Id 1969',1800.00,0.00,0.00,2.50,125.00,'2023-02-15 16:27:06','',''),(2006,'1','303','1',1,'Retail Sale Id 1970',2203.20,0.00,0.00,3.06,153.00,'2023-02-15 16:31:20','',''),(2007,'1','303','1',1,'Retail Sale Id 1971',9000.00,0.00,0.00,12.50,625.00,'2023-02-15 16:32:23','',''),(2008,'1','303','1',1,'Retail Sale Id 1972',720.00,0.00,0.00,1.00,50.00,'2023-02-15 16:36:35','',''),(2009,'1','303','1',1,'Retail Sale Id 1973',3600.00,0.00,0.00,5.00,250.00,'2023-02-15 16:48:04','',''),(2010,'1','303','1',1,'Retail Sale Id 1974',1497.60,0.00,0.00,2.08,104.00,'2023-02-15 17:22:00','',''),(2011,'1','303','1',1,'Retail Sale Id 1975',1497.60,0.00,0.00,2.08,104.00,'2023-02-15 17:24:26','',''),(2012,'1','303','1',1,'Retail Sale Id 1976',2880.00,0.00,0.00,4.00,200.00,'2023-02-15 17:25:39','',''),(2013,'1','303','1',1,'Retail Sale Id 1977',2203.20,0.00,0.00,3.06,153.00,'2023-02-15 17:31:52','',''),(2014,'1','303','1',1,'Retail Sale Id 1978',2160.00,0.00,0.00,3.00,150.00,'2023-02-15 17:48:35','',''),(2015,'1','303','1',1,'Retail Sale Id 1979',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 08:33:13','',''),(2016,'1','303','1',1,'Retail Sale Id 1980',69000.00,0.00,0.00,100.00,2000.00,'2023-02-16 08:38:20','',''),(2017,'1','303','1',1,'Retail Sale Id 1981',3600.00,0.00,0.00,5.00,250.00,'2023-02-16 08:40:05','',''),(2018,'1','303','1',1,'Retail Sale Id 1982',1000.80,0.00,0.00,1.39,69.50,'2023-02-16 09:16:26','',''),(2019,'1','303','1',1,'Retail Sale Id 1983',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 09:39:41','',''),(2020,'1','303','1',1,'Retail Sale Id 1984',2160.00,0.00,0.00,3.00,150.00,'2023-02-16 09:42:09','',''),(2021,'1','303','1',1,'Retail Sale Id 1985',2167.20,0.00,0.00,3.01,150.50,'2023-02-16 10:00:52','',''),(2022,'1','303','1',1,'Retail Sale Id 1986',3600.00,0.00,0.00,5.00,250.00,'2023-02-16 10:23:42','',''),(2023,'1','303','1',1,'Retail Sale Id 1987',799.20,0.00,0.00,1.11,55.50,'2023-02-16 10:36:25','',''),(2024,'1','303','1',1,'Retail Sale Id 1988',9000.00,0.00,0.00,12.50,625.00,'2023-02-16 10:53:37','',''),(2025,'1','303','1',1,'Retail Sale Id 1989',2160.00,0.00,0.00,3.00,150.00,'2023-02-16 11:06:41','',''),(2026,'1','303','1',1,'Retail Sale Id 1990',2160.00,0.00,0.00,3.00,150.00,'2023-02-16 11:18:26','',''),(2027,'1','303','1',1,'Retail Sale Id 1991',2160.00,0.00,0.00,3.00,150.00,'2023-02-16 11:27:30','',''),(2028,'1','303','1',1,'Retail Sale Id 1992',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 11:36:13','',''),(2029,'1','303','1',1,'Retail Sale Id 1993',18000.00,0.00,0.00,25.00,1250.00,'2023-02-16 11:39:53','',''),(2030,'1','303','1',1,'Retail Sale Id 1994',1440.00,0.00,0.00,2.00,100.00,'2023-02-16 11:42:44','',''),(2031,'1','303','1',1,'Retail Sale Id 1995',9000.00,0.00,0.00,12.50,625.00,'2023-02-16 11:48:51','',''),(2032,'1','303','1',1,'Retail Sale Id 1996',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 12:00:44','',''),(2033,'1','303','1',1,'Retail Sale Id 1997',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 12:13:26','',''),(2034,'1','303','1',1,'Retail Sale Id 1998',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 12:14:51','',''),(2035,'1','303','1',1,'Retail Sale Id 1999',9000.00,0.00,0.00,12.50,625.00,'2023-02-16 12:22:19','',''),(2036,'1','303','1',1,'Retail Sale Id 2000',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 12:39:04','',''),(2037,'1','303','1',1,'Retail Sale Id 2001',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 12:42:41','',''),(2038,'1','303','1',1,'Retail Sale Id 2002',4996.80,0.00,0.00,6.94,347.00,'2023-02-16 13:01:07','',''),(2039,'1','303','1',1,'Retail Sale Id 2003',1497.60,0.00,0.00,2.08,104.00,'2023-02-16 13:06:15','',''),(2040,'1','303','1',1,'Retail Sale Id 2004',7200.00,0.00,0.00,10.00,500.00,'2023-02-16 13:18:56','',''),(2041,'1','303','1',1,'Retail Sale Id 2005',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 13:24:58','',''),(2042,'1','303','1',1,'Retail Sale Id 2006',9000.00,0.00,0.00,12.50,625.00,'2023-02-16 13:38:18','',''),(2043,'1','303','1',1,'Retail Sale Id 2007',2160.00,0.00,0.00,3.00,150.00,'2023-02-16 13:41:45','',''),(2044,'1','303','1',1,'Retail Sale Id 2008',2160.00,0.00,0.00,3.00,150.00,'2023-02-16 13:43:42','',''),(2045,'1','303','1',1,'Retail Sale Id 2009',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 13:45:03','',''),(2046,'1','303','1',1,'Retail Sale Id 2010',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 13:46:57','',''),(2047,'1','303','1',1,'Retail Sale Id 2011',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 13:49:31','',''),(2048,'1','303','1',1,'Retail Sale Id 2012',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 14:05:46','',''),(2049,'1','303','1',1,'Retail Sale Id 2013',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 14:06:26','',''),(2050,'1','303','1',1,'Retail Sale Id 2014',9000.00,0.00,0.00,12.50,625.00,'2023-02-16 14:26:36','',''),(2051,'1','303','1',1,'Retail Sale Id 2015',3600.00,0.00,0.00,5.00,250.00,'2023-02-16 14:32:50','',''),(2052,'1','303','1',1,'Retail Sale Id 2016',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 14:39:18','',''),(2053,'1','303','1',1,'Retail Sale Id 2017',2160.00,0.00,0.00,3.00,150.00,'2023-02-16 14:40:49','',''),(2054,'1','303','1',1,'Retail Sale Id 2018',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 14:44:35','',''),(2055,'1','303','1',1,'Retail Sale Id 2019',2160.00,0.00,0.00,3.00,150.00,'2023-02-16 14:49:40','',''),(2056,'1','303','1',1,'Return of Retail Sale Id 2019',0.00,2160.00,3.00,0.00,-150.00,'2023-02-16 14:57:59','',''),(2057,'1','303','1',1,'Retail Sale Id 2020',1440.00,0.00,0.00,2.00,100.00,'2023-02-16 14:59:10','',''),(2058,'1','303','1',1,'Retail Sale Id 2021',2001.60,0.00,0.00,2.78,139.00,'2023-02-16 15:00:14','',''),(2059,'1','303','1',1,'Retail Sale Id 2022',1497.60,0.00,0.00,2.08,104.00,'2023-02-16 15:26:34','',''),(2060,'1','303','1',1,'Retail Sale Id 2023',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 15:29:02','',''),(2061,'1','303','1',1,'Retail Sale Id 2024',9000.00,0.00,0.00,12.50,625.00,'2023-02-16 15:30:27','',''),(2062,'1','303','1',1,'Retail Sale Id 2025',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 15:37:25','',''),(2063,'1','303','1',1,'Retail Sale Id 2026',2001.60,0.00,0.00,2.78,139.00,'2023-02-16 15:42:46','',''),(2064,'1','303','1',1,'Retail Sale Id 2027',3002.40,0.00,0.00,4.17,208.50,'2023-02-16 16:02:33','',''),(2065,'1','303','1',1,'Retail Sale Id 2028',3002.40,0.00,0.00,4.17,208.50,'2023-02-16 16:17:29','',''),(2066,'1','303','1',1,'Retail Sale Id 2029',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 16:37:06','',''),(2067,'1','303','1',1,'Retail Sale Id 2030',2001.60,0.00,0.00,2.78,139.00,'2023-02-16 16:40:35','',''),(2068,'1','303','1',1,'Retail Sale Id 2031',2160.00,0.00,0.00,3.00,150.00,'2023-02-16 16:46:01','',''),(2069,'1','303','1',1,'Retail Sale Id 2034',9000.00,0.00,0.00,12.50,625.00,'2023-02-16 16:51:01','',''),(2070,'1','303','1',1,'Retail Sale Id 2035',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 16:53:32','',''),(2071,'1','303','1',1,'Retail Sale Id 2035',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 16:53:32','',''),(2072,'1','303','1',1,'Retail Sale Id 2036',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 16:56:02','',''),(2073,'1','303','1',1,'Retail Sale Id 2037',4320.00,0.00,0.00,6.00,300.00,'2023-02-16 17:05:32','',''),(2074,'1','303','1',1,'Retail Sale Id 2038',2880.00,0.00,0.00,4.00,200.00,'2023-02-16 17:25:24','',''),(2075,'1','303','1',1,'Retail Sale Id 2039',9000.00,0.00,0.00,12.50,625.00,'2023-02-16 17:59:34','',''),(2076,'1','303','1',1,'Retail Sale Id 2041',34500.00,0.00,0.00,50.00,1000.00,'2023-02-16 18:09:53','',''),(2077,'1','303','1',1,'Retail Sale Id 2042',9000.00,0.00,0.00,12.50,625.00,'2023-02-17 08:20:20','',''),(2078,'1','303','1',1,'Retail Sale Id 2043',2160.00,0.00,0.00,3.00,150.00,'2023-02-17 08:56:15','',''),(2079,'1','303','1',1,'Retail Sale Id 2044',1440.00,0.00,0.00,2.00,100.00,'2023-02-17 09:18:18','',''),(2080,'1','303','1',1,'Retail Sale Id 2045',3600.00,0.00,0.00,5.00,250.00,'2023-02-17 09:47:16','',''),(2081,'1','303','1',1,'Retail Sale Id 2046',2160.00,0.00,0.00,3.00,150.00,'2023-02-17 09:48:07','',''),(2082,'1','303','1',1,'Retail Sale Id 2047',3600.00,0.00,0.00,5.00,250.00,'2023-02-17 09:55:21','',''),(2083,'1','303','1',1,'Retail Sale Id 2048',2160.00,0.00,0.00,3.00,150.00,'2023-02-17 10:36:48','',''),(2084,'1','303','1',1,'Retail Sale Id 2049',103500.00,0.00,0.00,150.00,3000.00,'2023-02-17 10:48:16','',''),(2085,'1','303','1',1,'Retail Sale Id 2050',4320.00,0.00,0.00,6.00,300.00,'2023-02-17 10:49:30','',''),(2086,'1','303','1',1,'Retail Sale Id 2051',2203.20,0.00,0.00,3.06,153.00,'2023-02-17 10:50:42','',''),(2087,'1','303','1',1,'Retail Sale Id 2052',4320.00,0.00,0.00,6.00,300.00,'2023-02-17 11:01:53','',''),(2088,'1','303','1',1,'Retail Sale Id 2053',4298.40,0.00,0.00,5.97,298.50,'2023-02-17 11:32:06','',''),(2089,'1','303','1',1,'Retail Sale Id 2054',1497.60,0.00,0.00,2.08,104.00,'2023-02-17 11:51:39','',''),(2090,'1','303','1',1,'Retail Sale Id 2055',9000.00,0.00,0.00,12.50,625.00,'2023-02-17 11:55:31','',''),(2091,'1','303','1',1,'Retail Sale Id 2056',4320.00,0.00,0.00,6.00,300.00,'2023-02-17 11:57:58','',''),(2092,'1','303','1',1,'Retail Sale Id 2057',2160.00,0.00,0.00,3.00,150.00,'2023-02-17 12:16:48','',''),(2093,'1','303','1',1,'Retail Sale Id 2058',2160.00,0.00,0.00,3.00,150.00,'2023-02-17 12:17:45','',''),(2094,'1','303','1',1,'Retail Sale Id 2059',1000.80,0.00,0.00,1.39,69.50,'2023-02-17 12:25:36','',''),(2095,'1','303','1',1,'Retail Sale Id 2060',1497.60,0.00,0.00,2.08,104.00,'2023-02-17 12:27:43','',''),(2096,'1','303','1',1,'Retail Sale Id 2061',2203.20,0.00,0.00,3.06,153.00,'2023-02-17 12:31:01','',''),(2097,'1','303','1',1,'Retail Sale Id 2062',2296.80,0.00,0.00,3.19,159.50,'2023-02-17 12:38:52','',''),(2098,'1','303','1',1,'Retail Sale Id 2063',2160.00,0.00,0.00,3.00,150.00,'2023-02-17 15:22:40','',''),(2099,'1','303','1',1,'Retail Sale Id 2064',5040.00,0.00,0.00,7.00,350.00,'2023-02-17 15:25:16','',''),(2100,'1','303','1',1,'Retail Sale Id 2065',2001.60,0.00,0.00,2.78,139.00,'2023-02-17 15:29:28','',''),(2101,'1','303','1',1,'Retail Sale Id 2066',4320.00,0.00,0.00,6.00,300.00,'2023-02-17 15:32:13','',''),(2102,'1','303','1',1,'Retail Sale Id 2067',2001.60,0.00,0.00,2.78,139.00,'2023-02-17 15:33:41','',''),(2103,'1','303','1',1,'Retail Sale Id 2068',4320.00,0.00,0.00,6.00,300.00,'2023-02-17 15:34:54','',''),(2104,'1','303','1',1,'Retail Sale Id 2070',9000.00,0.00,0.00,12.50,625.00,'2023-02-17 15:38:22','',''),(2105,'1','303','1',1,'Retail Sale Id 2071',3002.40,0.00,0.00,4.17,208.50,'2023-02-17 15:40:34','',''),(2106,'1','303','1',1,'Retail Sale Id 2072',597.60,0.00,0.00,0.83,41.50,'2023-02-17 15:41:28','',''),(2107,'1','303','1',1,'Retail Sale Id 2073',9000.00,0.00,0.00,12.50,625.00,'2023-02-17 15:44:44','',''),(2108,'1','303','1',1,'Retail Sale Id 2074',4320.00,0.00,0.00,6.00,300.00,'2023-02-17 15:45:35','',''),(2109,'1','303','1',1,'Retail Sale Id 2075',4320.00,0.00,0.00,6.00,300.00,'2023-02-17 15:46:56','',''),(2110,'1','303','1',1,'Retail Sale Id 2076',3002.40,0.00,0.00,4.17,208.50,'2023-02-17 15:51:51','',''),(2111,'1','303','1',1,'Retail Sale Id 2076',3002.40,0.00,0.00,4.17,208.50,'2023-02-17 15:51:52','',''),(2112,'1','303','1',1,'Retail Sale Id 2077',4320.00,0.00,0.00,6.00,300.00,'2023-02-17 16:04:47','',''),(2113,'1','303','1',1,'Retail Sale Id 2078',2160.00,0.00,0.00,3.00,150.00,'2023-02-17 16:06:52','',''),(2114,'1','303','1',1,'Retail Sale Id 2079',4320.00,0.00,0.00,6.00,300.00,'2023-02-17 16:26:26','',''),(2115,'1','303','1',1,'Retail Sale Id 2080',4320.00,0.00,0.00,6.00,300.00,'2023-02-17 16:31:46','',''),(2116,'1','303','1',1,'Retail Sale Id 2081',3600.00,0.00,0.00,5.00,250.00,'2023-02-17 16:33:40','',''),(2117,'1','303','1',1,'Retail Sale Id 2082',7200.00,0.00,0.00,10.00,500.00,'2023-02-17 16:35:41','',''),(2118,'1','303','1',1,'Retail Sale Id 2083',4320.00,0.00,0.00,6.00,300.00,'2023-02-17 16:36:40','',''),(2119,'1','303','1',1,'Retail Sale Id 2084',720.00,0.00,0.00,1.00,50.00,'2023-02-17 16:37:37','',''),(2120,'1','303','1',1,'Retail Sale Id 2085',4320.00,0.00,0.00,6.00,300.00,'2023-02-17 16:40:18','',''),(2121,'1','303','1',1,'Retail Sale Id 2086',8640.00,0.00,0.00,12.00,600.00,'2023-02-17 16:42:01','',''),(2122,'1','303','1',1,'Retail Sale Id 2087',15480.00,0.00,0.00,21.50,1075.00,'2023-02-17 16:44:10','',''),(2123,'1','303','1',1,'Retail Sale Id 2088',4320.00,0.00,0.00,6.00,300.00,'2023-02-17 16:46:27','',''),(2124,'1','303','1',1,'Retail Sale Id 2089',2001.60,0.00,0.00,2.78,139.00,'2023-02-17 16:50:32','',''),(2125,'1','303','1',1,'Retail Sale Id 2090',4320.00,0.00,0.00,6.00,300.00,'2023-02-17 16:51:46','',''),(2126,'1','303','1',1,'Retail Sale Id 2091',4320.00,0.00,0.00,6.00,300.00,'2023-02-17 16:52:42','',''),(2127,'1','303','1',1,'Retail Sale Id 2092',4320.00,0.00,0.00,6.00,300.00,'2023-02-17 16:57:08','',''),(2128,'1','303','1',1,'Retail Sale Id 2093',3600.00,0.00,0.00,5.00,250.00,'2023-02-17 16:58:46','',''),(2129,'1','303','1',1,'Retail Sale Id 2094',4996.80,0.00,0.00,6.94,347.00,'2023-02-17 17:10:29','',''),(2130,'1','303','1',1,'Retail Sale Id 2095',4320.00,0.00,0.00,6.00,300.00,'2023-02-17 17:14:33','',''),(2131,'1','303','1',1,'Retail Sale Id 2096',2160.00,0.00,0.00,3.00,150.00,'2023-02-17 17:18:07','',''),(2132,'1','303','1',1,'Retail Sale Id 2097',9000.00,0.00,0.00,12.50,625.00,'2023-02-17 17:35:07','',''),(2133,'1','303','1',1,'Retail Sale Id 2098',379500.00,0.00,0.00,550.00,11000.00,'2023-02-17 17:37:14','',''),(2134,'1','303','1',1,'Retail Sale Id 2099',20008.80,0.00,0.00,27.79,1389.50,'2023-02-17 17:44:25','',''),(2135,'1','303','1',1,'Retail Sale Id 2100',4320.00,0.00,0.00,6.00,300.00,'2023-02-17 18:03:16','',''),(2136,'1','303','1',1,'Retail Sale Id 2101',784.80,0.00,0.00,1.09,54.50,'2023-02-17 19:16:46','',''),(2137,'1','303','1',1,'Retail Sale Id 2102',9000.00,0.00,0.00,12.50,625.00,'2023-02-18 08:14:14','',''),(2138,'1','303','1',1,'Retail Sale Id 2103',1497.60,0.00,0.00,2.08,104.00,'2023-02-18 09:25:39','',''),(2139,'1','303','1',1,'Retail Sale Id 2104',4320.00,0.00,0.00,6.00,300.00,'2023-02-18 09:41:22','',''),(2140,'1','303','1',1,'Retail Sale Id 2105',3600.00,0.00,0.00,5.00,250.00,'2023-02-18 09:42:49','',''),(2141,'1','303','1',1,'Retail Sale Id 2106',1497.60,0.00,0.00,2.08,104.00,'2023-02-18 09:57:07','',''),(2142,'1','303','1',1,'Retail Sale Id 2107',2001.60,0.00,0.00,2.78,139.00,'2023-02-18 10:12:28','',''),(2143,'1','303','1',1,'Retail Sale Id 2108',1000.80,0.00,0.00,1.39,69.50,'2023-02-18 10:15:16','',''),(2144,'1','303','1',1,'Retail Sale Id 2109',2203.20,0.00,0.00,3.06,153.00,'2023-02-18 10:18:45','',''),(2145,'1','303','1',1,'Retail Sale Id 2110',1497.60,0.00,0.00,2.08,104.00,'2023-02-18 10:41:33','',''),(2146,'1','303','1',1,'Retail Sale Id 2111',2152.80,0.00,0.00,2.99,149.50,'2023-02-18 10:43:31','',''),(2147,'1','303','1',1,'Retail Sale Id 2113',4320.00,0.00,0.00,6.00,300.00,'2023-02-18 10:49:51','',''),(2148,'1','303','1',1,'Retail Sale Id 2114',4320.00,0.00,0.00,6.00,300.00,'2023-02-18 11:03:08','',''),(2149,'1','303','1',1,'Retail Sale Id 2115',4320.00,0.00,0.00,6.00,300.00,'2023-02-18 11:16:13','',''),(2150,'1','303','1',1,'Retail Sale Id 2116',4996.80,0.00,0.00,6.94,347.00,'2023-02-18 11:22:10','',''),(2151,'1','303','1',1,'Retail Sale Id 2117',4320.00,0.00,0.00,6.00,300.00,'2023-02-18 11:26:33','',''),(2152,'1','303','1',1,'Retail Sale Id 2118',4320.00,0.00,0.00,6.00,300.00,'2023-02-18 11:37:24','',''),(2153,'1','303','1',1,'Retail Sale Id 2119',2901.60,0.00,0.00,4.03,201.50,'2023-02-18 11:42:44','',''),(2154,'1','303','1',1,'Retail Sale Id 2120',2880.00,0.00,0.00,4.00,200.00,'2023-02-18 11:44:29','',''),(2155,'1','303','1',1,'Retail Sale Id 2121',4348.80,0.00,0.00,6.04,302.00,'2023-02-18 11:54:23','',''),(2156,'1','303','1',1,'Retail Sale Id 2122',7999.20,0.00,0.00,11.11,555.50,'2023-02-18 11:58:40','',''),(2157,'1','303','1',1,'Retail Sale Id 2123',9000.00,0.00,0.00,12.50,625.00,'2023-02-18 12:11:41','',''),(2158,'1','303','1',1,'Retail Sale Id 2124',1000.80,0.00,0.00,1.39,69.50,'2023-02-18 12:15:20','',''),(2159,'1','303','1',1,'Retail Sale Id 2125',1497.60,0.00,0.00,2.08,104.00,'2023-02-18 12:16:13','',''),(2160,'1','303','1',1,'Retail Sale Id 2126',2160.00,0.00,0.00,3.00,150.00,'2023-02-18 12:20:30','',''),(2161,'1','303','1',1,'Retail Sale Id 2126',4320.00,0.00,0.00,6.00,300.00,'2023-02-18 12:20:30','',''),(2162,'1','303','1',1,'Retail Sale Id 2126',7200.00,0.00,0.00,10.00,500.00,'2023-02-18 12:20:30','',''),(2163,'1','303','1',1,'Retail Sale Id 2127',9000.00,0.00,0.00,12.50,625.00,'2023-02-18 12:26:23','',''),(2164,'1','303','1',1,'Retail Sale Id 2128',4320.00,0.00,0.00,6.00,300.00,'2023-02-18 12:32:23','',''),(2165,'1','303','1',1,'Retail Sale Id 2129',9000.00,0.00,0.00,12.50,625.00,'2023-02-18 12:34:12','',''),(2166,'1','303','1',1,'Retail Sale Id 2130',7920.00,0.00,0.00,11.00,550.00,'2023-02-18 12:49:12','',''),(2167,'1','303','1',1,'Retail Sale Id 2130',9000.00,0.00,0.00,12.50,625.00,'2023-02-18 12:49:12','',''),(2168,'1','303','1',1,'Retail Sale Id 2131',9000.00,0.00,0.00,12.50,625.00,'2023-02-18 12:50:31','',''),(2169,'1','303','1',1,'Retail Sale Id 2132',9000.00,0.00,0.00,12.50,625.00,'2023-02-18 12:53:00','',''),(2170,'1','303','1',1,'Retail Sale Id 2133',4320.00,0.00,0.00,6.00,300.00,'2023-02-18 13:08:54','',''),(2171,'1','303','1',1,'Retail Sale Id 2134',2102.40,0.00,0.00,2.92,146.00,'2023-02-18 13:16:37','',''),(2172,'1','303','1',1,'Retail Sale Id 2135',1440.00,0.00,0.00,2.00,100.00,'2023-02-18 13:32:03','',''),(2173,'1','303','1',1,'Retail Sale Id 2136',6480.00,0.00,0.00,9.00,450.00,'2023-02-18 13:49:18','',''),(2174,'1','303','1',1,'Retail Sale Id 2137',4320.00,0.00,0.00,6.00,300.00,'2023-02-18 13:53:45','',''),(2175,'1','303','1',1,'Retail Sale Id 2138',1202.40,0.00,0.00,1.67,83.50,'2023-02-18 13:55:40','',''),(2176,'1','303','1',1,'Retail Sale Id 2139',4320.00,0.00,0.00,6.00,300.00,'2023-02-18 14:32:48','',''),(2177,'1','303','1',1,'Retail Sale Id 2140',2152.80,0.00,0.00,2.99,149.50,'2023-02-18 15:11:48','',''),(2178,'1','303','1',1,'Retail Sale Id 2141',1497.60,0.00,0.00,2.08,104.00,'2023-02-18 15:24:54','',''),(2179,'1','303','1',1,'Retail Sale Id 2142',4320.00,0.00,0.00,6.00,300.00,'2023-02-18 15:32:09','',''),(2180,'1','303','1',1,'Retail Sale Id 2143',9000.00,0.00,0.00,12.50,625.00,'2023-02-18 15:33:08','',''),(2181,'1','303','1',1,'Retail Sale Id 2144',1000.80,0.00,0.00,1.39,69.50,'2023-02-18 15:51:37','',''),(2182,'1','303','1',1,'Retail Sale Id 2145',9000.00,0.00,0.00,12.50,625.00,'2023-02-18 15:54:21','',''),(2183,'1','303','1',1,'Retail Sale Id 2146',4500.00,0.00,0.00,6.25,312.50,'2023-02-18 16:00:35','',''),(2184,'1','303','1',1,'Retail Sale Id 2147',4320.00,0.00,0.00,6.00,300.00,'2023-02-18 16:06:22','',''),(2185,'1','303','1',1,'Retail Sale Id 2148',4320.00,0.00,0.00,6.00,300.00,'2023-02-18 16:15:06','',''),(2186,'1','303','1',1,'Retail Sale Id 2149',2160.00,0.00,0.00,3.00,150.00,'2023-02-18 16:16:59','',''),(2187,'1','303','1',1,'Retail Sale Id 2150',2160.00,0.00,0.00,3.00,150.00,'2023-02-18 16:21:40','',''),(2188,'1','303','1',1,'Retail Sale Id 2150',2160.00,0.00,0.00,3.00,150.00,'2023-02-18 16:21:40','',''),(2189,'1','303','1',1,'Return of Retail Sale Id 2150',0.00,2160.00,3.00,0.00,-150.00,'2023-02-18 16:33:13','',''),(2190,'1','303','1',1,'Return of Retail Sale Id 2150',0.00,2160.00,3.00,0.00,-150.00,'2023-02-18 16:33:13','',''),(2191,'1','303','1',1,'Retail Sale Id 2151',3600.00,0.00,0.00,5.00,250.00,'2023-02-18 16:54:12','',''),(2192,'1','303','1',1,'Retail Sale Id 2152',4320.00,0.00,0.00,6.00,300.00,'2023-02-18 17:00:23','',''),(2193,'1','303','1',1,'Retail Sale Id 2153',2160.00,0.00,0.00,3.00,150.00,'2023-02-18 17:12:58','',''),(2194,'1','303','1',1,'Retail Sale Id 2154',3600.00,0.00,0.00,5.00,250.00,'2023-02-18 17:14:03','',''),(2195,'1','303','1',1,'Retail Sale Id 2155',1497.60,0.00,0.00,2.08,104.00,'2023-02-18 17:15:04','',''),(2196,'1','303','1',1,'Retail Sale Id 2156',7920.00,0.00,0.00,11.00,550.00,'2023-02-18 17:16:32','',''),(2197,'1','303','1',1,'Retail Sale Id 2157',4320.00,0.00,0.00,6.00,300.00,'2023-02-18 17:25:05','',''),(2198,'1','303','1',1,'Retail Sale Id 2158',4320.00,0.00,0.00,6.00,300.00,'2023-02-18 17:39:33','',''),(2199,'1','303','1',1,'Retail Sale Id 2159',9000.00,0.00,0.00,12.50,625.00,'2023-02-18 17:54:50','',''),(2200,'1','303','1',1,'Retail Sale Id 2160',4399.20,0.00,0.00,6.11,305.50,'2023-02-18 17:58:00','',''),(2201,'1','303','1',1,'Retail Sale Id 2161',1497.60,0.00,0.00,2.08,104.00,'2023-02-19 08:04:16','',''),(2202,'1','303','1',1,'Retail Sale Id 2162',4320.00,0.00,0.00,6.00,300.00,'2023-02-19 08:12:00','',''),(2203,'1','303','1',1,'Retail Sale Id 2163',3600.00,0.00,0.00,5.00,250.00,'2023-02-19 08:35:19','',''),(2204,'1','303','1',1,'Retail Sale Id 2164',4320.00,0.00,0.00,6.00,300.00,'2023-02-19 08:55:15','',''),(2205,'1','303','1',1,'Retail Sale Id 2165',1598.40,0.00,0.00,2.22,111.00,'2023-02-19 09:03:47','',''),(2206,'1','303','1',1,'Retail Sale Id 2166',9000.00,0.00,0.00,12.50,625.00,'2023-02-19 09:50:23','',''),(2207,'1','303','1',1,'Retail Sale Id 2168',4298.40,0.00,0.00,5.97,298.50,'2023-02-19 10:03:48','',''),(2208,'1','303','1',1,'Retail Sale Id 2169',4348.80,0.00,0.00,6.04,302.00,'2023-02-19 10:05:16','',''),(2209,'1','303','1',1,'Retail Sale Id 2170',9000.00,0.00,0.00,12.50,625.00,'2023-02-19 10:32:04','',''),(2210,'1','303','1',1,'Retail Sale Id 2171',4320.00,0.00,0.00,6.00,300.00,'2023-02-19 10:33:06','',''),(2211,'1','303','1',1,'Retail Sale Id 2172',3600.00,0.00,0.00,5.00,250.00,'2023-02-19 10:44:47','',''),(2212,'1','303','1',1,'Retail Sale Id 2173',3600.00,0.00,0.00,5.00,250.00,'2023-02-19 10:45:56','',''),(2213,'1','303','1',1,'Retail Sale Id 2174',14400.00,0.00,0.00,20.00,1000.00,'2023-02-19 11:04:02','',''),(2214,'1','303','1',1,'Retail Sale Id 2175',9000.00,0.00,0.00,12.50,625.00,'2023-02-19 11:08:39','',''),(2215,'1','303','1',1,'Retail Sale Id 2176',2160.00,0.00,0.00,3.00,150.00,'2023-02-19 11:20:35','',''),(2216,'1','303','1',1,'Retail Sale Id 2177',3600.00,0.00,0.00,5.00,250.00,'2023-02-19 11:22:10','',''),(2217,'1','303','1',1,'Retail Sale Id 2179',2160.00,0.00,0.00,3.00,150.00,'2023-02-19 11:32:48','',''),(2218,'1','303','1',1,'Retail Sale Id 2179',3600.00,0.00,0.00,5.00,250.00,'2023-02-19 11:32:48','',''),(2219,'1','303','1',1,'Retail Sale Id 2180',1440.00,0.00,0.00,2.00,100.00,'2023-02-19 11:36:03','',''),(2220,'1','303','1',1,'Retail Sale Id 2180',5760.00,0.00,0.00,8.00,400.00,'2023-02-19 11:36:03','',''),(2221,'1','303','1',1,'Retail Sale Id 2181',2160.00,0.00,0.00,3.00,150.00,'2023-02-19 11:38:25','',''),(2222,'1','303','1',1,'Retail Sale Id 2181',3600.00,0.00,0.00,5.00,250.00,'2023-02-19 11:38:26','',''),(2223,'1','303','1',1,'Retail Sale Id 2182',4320.00,0.00,0.00,6.00,300.00,'2023-02-19 11:51:47','',''),(2224,'1','303','1',1,'Retail Sale Id 2183',4320.00,0.00,0.00,6.00,300.00,'2023-02-19 11:54:43','',''),(2225,'1','303','1',1,'Retail Sale Id 2184',1000.80,0.00,0.00,1.39,69.50,'2023-02-19 12:07:07','',''),(2226,'1','303','1',1,'Retail Sale Id 2185',3600.00,0.00,0.00,5.00,250.00,'2023-02-19 12:09:38','',''),(2227,'1','303','1',1,'Retail Sale Id 2186',1303.20,0.00,0.00,1.81,90.50,'2023-02-19 12:11:17','',''),(2228,'1','303','1',1,'Retail Sale Id 2187',1598.40,0.00,0.00,2.22,111.00,'2023-02-19 12:12:27','',''),(2229,'1','303','1',1,'Return of Retail Sale Id 2186',0.00,1303.20,1.81,0.00,-90.50,'2023-02-19 12:13:56','',''),(2230,'1','303','1',1,'Retail Sale Id 2188',6998.40,0.00,0.00,9.72,486.00,'2023-02-19 12:26:45','',''),(2231,'1','303','1',1,'Retail Sale Id 2189',4320.00,0.00,0.00,6.00,300.00,'2023-02-19 12:31:20','',''),(2232,'1','303','1',1,'Retail Sale Id 2190',2160.00,0.00,0.00,3.00,150.00,'2023-02-19 12:34:41','',''),(2233,'1','303','1',1,'Retail Sale Id 2191',2160.00,0.00,0.00,3.00,150.00,'2023-02-19 12:51:34','',''),(2234,'1','303','1',1,'Retail Sale Id 2192',2160.00,0.00,0.00,3.00,150.00,'2023-02-19 12:58:38','',''),(2235,'1','303','1',1,'Retail Sale Id 2193',2160.00,0.00,0.00,3.00,150.00,'2023-02-19 13:17:38','',''),(2236,'1','303','1',1,'Retail Sale Id 2194',2203.20,0.00,0.00,3.06,153.00,'2023-02-19 13:29:47','',''),(2237,'1','303','1',1,'Retail Sale Id 2195',9000.00,0.00,0.00,12.50,625.00,'2023-02-19 13:34:48','',''),(2238,'1','303','1',1,'Retail Sale Id 2196',1497.60,0.00,0.00,2.08,104.00,'2023-02-19 13:36:27','',''),(2239,'1','303','1',1,'Retail Sale Id 2197',3600.00,0.00,0.00,5.00,250.00,'2023-02-19 13:48:09','',''),(2240,'1','303','1',1,'Retail Sale Id 2198',4320.00,0.00,0.00,6.00,300.00,'2023-02-19 13:55:00','',''),(2241,'1','303','1',1,'Retail Sale Id 2199',720.00,0.00,0.00,1.00,50.00,'2023-02-19 14:13:53','',''),(2242,'1','303','1',1,'Retail Sale Id 2200',2152.80,0.00,0.00,2.99,149.50,'2023-02-19 14:18:56','',''),(2243,'1','303','1',1,'Retail Sale Id 2201',4320.00,0.00,0.00,6.00,300.00,'2023-02-19 14:22:39','',''),(2244,'1','303','1',1,'Retail Sale Id 2201',4320.00,0.00,0.00,6.00,300.00,'2023-02-19 14:22:39','',''),(2245,'1','303','1',1,'Retail Sale Id 2202',3600.00,0.00,0.00,5.00,250.00,'2023-02-19 14:24:01','',''),(2246,'1','303','1',1,'Retail Sale Id 2203',1800.00,0.00,0.00,2.50,125.00,'2023-02-19 14:25:16','',''),(2247,'1','303','1',1,'Retail Sale Id 2204',4320.00,0.00,0.00,6.00,300.00,'2023-02-19 14:35:31','',''),(2248,'1','303','1',1,'Retail Sale Id 2205',1800.00,0.00,0.00,2.50,125.00,'2023-02-19 14:37:38','',''),(2249,'1','303','1',1,'Retail Sale Id 2206',8640.00,0.00,0.00,12.00,600.00,'2023-02-19 14:42:28','',''),(2250,'1','303','1',1,'Retail Sale Id 2207',4348.80,0.00,0.00,6.04,302.00,'2023-02-19 14:43:31','',''),(2251,'1','303','1',1,'Retail Sale Id 2208',69000.00,0.00,0.00,100.00,2000.00,'2023-02-19 14:58:12','',''),(2252,'1','303','1',1,'Retail Sale Id 2209',1000.80,0.00,0.00,1.39,69.50,'2023-02-19 15:02:42','',''),(2253,'1','303','1',1,'Retail Sale Id 2210',1497.60,0.00,0.00,2.08,104.00,'2023-02-19 15:08:03','',''),(2254,'1','303','1',1,'Retail Sale Id 2211',698.40,0.00,0.00,0.97,48.50,'2023-02-19 16:00:12','',''),(2255,'1','303','1',1,'Retail Sale Id 2212',2160.00,0.00,0.00,3.00,150.00,'2023-02-19 16:18:21','',''),(2256,'1','303','1',1,'Retail Sale Id 2213',2001.60,0.00,0.00,2.78,139.00,'2023-02-19 16:21:21','',''),(2257,'1','303','1',1,'Retail Sale Id 2214',2160.00,0.00,0.00,3.00,150.00,'2023-02-19 16:44:59','',''),(2258,'1','303','1',1,'Retail Sale Id 2215',4320.00,0.00,0.00,6.00,300.00,'2023-02-19 16:50:07','',''),(2259,'1','303','1',1,'Retail Sale Id 2216',4320.00,0.00,0.00,6.00,300.00,'2023-02-19 16:51:36','',''),(2260,'1','303','1',1,'Retail Sale Id 2217',2880.00,0.00,0.00,4.00,200.00,'2023-02-19 16:55:12','',''),(2261,'1','303','1',1,'Retail Sale Id 2218',2160.00,0.00,0.00,3.00,150.00,'2023-02-19 17:52:19','',''),(2262,'1','303','1',1,'Retail Sale Id 2219',2001.60,0.00,0.00,2.78,139.00,'2023-02-19 18:03:28','',''),(2263,'1','303','1',1,'Retail Sale Id 2220',2001.60,0.00,0.00,2.78,139.00,'2023-02-19 18:05:35','',''),(2264,'1','303','1',1,'Return of Retail Sale Id 2209',0.00,1000.80,1.39,0.00,-69.50,'2023-02-19 19:11:56','',''),(2265,'1','303','1',1,'Retail Sale Id 2221',820.80,0.00,0.00,1.14,57.00,'2023-02-19 19:12:46','',''),(2266,'1','303','1',1,'Return of Retail Sale Id 2221',0.00,820.80,1.14,0.00,-57.00,'2023-02-19 19:14:08','',''),(2267,'1','303','1',1,'Return of Retail Sale Id 2203',0.00,1800.00,2.50,0.00,-125.00,'2023-02-19 19:16:27','',''),(2268,'1','303','1',1,'Retail Sale Id 2222',993.60,0.00,0.00,1.38,69.00,'2023-02-19 19:17:20','',''),(2269,'1','303','1',1,'Retail Sale Id 2223',4320.00,0.00,0.00,6.00,300.00,'2023-02-20 09:25:42','',''),(2270,'1','303','1',1,'Retail Sale Id 2224',4320.00,0.00,0.00,6.00,300.00,'2023-02-20 09:26:46','',''),(2271,'1','303','1',1,'Retail Sale Id 2225',4320.00,0.00,0.00,6.00,300.00,'2023-02-20 09:28:23','',''),(2272,'1','303','1',1,'Return of Retail Sale Id 2225',0.00,4320.00,6.00,0.00,-300.00,'2023-02-20 09:31:24','',''),(2273,'1','303','1',1,'Retail Sale Id 2226',2160.00,0.00,0.00,3.00,150.00,'2023-02-20 09:32:01','',''),(2274,'1','303','1',1,'Retail Sale Id 2227',4996.80,0.00,0.00,6.94,347.00,'2023-02-20 09:33:26','',''),(2275,'1','303','1',1,'Retail Sale Id 2228',9000.00,0.00,0.00,12.50,625.00,'2023-02-20 09:35:07','',''),(2276,'1','303','1',1,'Retail Sale Id 2229',4320.00,0.00,0.00,6.00,300.00,'2023-02-20 10:09:31','',''),(2277,'1','303','1',1,'Retail Sale Id 2230',4320.00,0.00,0.00,6.00,300.00,'2023-02-20 10:26:30','',''),(2278,'1','303','1',1,'Retail Sale Id 2231',4320.00,0.00,0.00,6.00,300.00,'2023-02-20 10:37:48','',''),(2279,'1','303','1',1,'Retail Sale Id 2232',2160.00,0.00,0.00,3.00,150.00,'2023-02-20 10:49:24','',''),(2280,'1','303','1',1,'Retail Sale Id 2233',2001.60,0.00,0.00,2.78,139.00,'2023-02-20 10:50:30','',''),(2281,'1','303','1',1,'Retail Sale Id 2234',4320.00,0.00,0.00,6.00,300.00,'2023-02-20 10:54:50','',''),(2282,'1','303','1',1,'Retail Sale Id 2235',4320.00,0.00,0.00,6.00,300.00,'2023-02-20 10:59:51','',''),(2283,'1','303','1',1,'Retail Sale Id 2236',3002.40,0.00,0.00,4.17,208.50,'2023-02-20 11:22:49','',''),(2284,'1','303','1',1,'Retail Sale Id 2237',9000.00,0.00,0.00,12.50,625.00,'2023-02-20 11:29:34','',''),(2285,'1','303','1',1,'Retail Sale Id 2238',2160.00,0.00,0.00,3.00,150.00,'2023-02-20 11:41:51','',''),(2286,'1','303','1',1,'Retail Sale Id 2239',1440.00,0.00,0.00,2.00,100.00,'2023-02-20 11:42:43','',''),(2287,'1','303','1',1,'Retail Sale Id 2240',4320.00,0.00,0.00,6.00,300.00,'2023-02-20 11:54:45','',''),(2288,'1','303','1',1,'Retail Sale Id 2241',9000.00,0.00,0.00,12.50,625.00,'2023-02-20 11:58:34','',''),(2289,'1','303','1',1,'Retail Sale Id 2242',138000.00,0.00,0.00,200.00,4000.00,'2023-02-20 12:04:13','',''),(2290,'1','303','1',1,'Retail Sale Id 2243',4320.00,0.00,0.00,6.00,300.00,'2023-02-20 12:10:45','',''),(2291,'1','303','1',1,'Retail Sale Id 2244',4500.00,0.00,0.00,6.25,312.50,'2023-02-20 12:14:27','',''),(2292,'1','303','1',1,'Retail Sale Id 2245',138000.00,0.00,0.00,200.00,4000.00,'2023-02-20 12:33:52','',''),(2293,'1','303','1',1,'Retail Sale Id 2246',2160.00,0.00,0.00,3.00,150.00,'2023-02-20 12:36:36','',''),(2294,'1','303','1',1,'Retail Sale Id 2247',7200.00,0.00,0.00,10.00,500.00,'2023-02-20 12:37:29','',''),(2295,'1','303','1',1,'Retail Sale Id 2248',4996.80,0.00,0.00,6.94,347.00,'2023-02-20 12:38:55','',''),(2296,'1','303','1',1,'Retail Sale Id 2249',3600.00,0.00,0.00,5.00,250.00,'2023-02-20 12:42:10','',''),(2297,'1','303','1',1,'Retail Sale Id 2250',1000.80,0.00,0.00,1.39,69.50,'2023-02-20 12:46:26','',''),(2298,'1','303','1',1,'Return of Retail Sale Id 2250',0.00,1000.80,1.39,0.00,-69.50,'2023-02-20 13:44:09','',''),(2299,'1','303','1',1,'Return of Retail Sale Id 2245',0.00,138000.00,200.00,0.00,-4000.00,'2023-02-20 13:56:36','',''),(2300,'1','303','1',1,'Retail Sale Id 2251',34500.00,0.00,0.00,50.00,1000.00,'2023-02-20 13:57:38','',''),(2301,'1','303','1',1,'Return of Retail Sale Id 2241',0.00,9000.00,12.50,0.00,-625.00,'2023-02-20 14:35:28','',''),(2302,'1','303','1',1,'Return of Retail Sale Id 2239',0.00,1440.00,2.00,0.00,-100.00,'2023-02-20 14:36:43','',''),(2303,'1','303','1',1,'Retail Sale Id 2252',1058.40,0.00,0.00,1.47,73.50,'2023-02-20 14:37:28','',''),(2304,'1','303','1',1,'Return of Retail Sale Id 2251',0.00,34500.00,50.00,0.00,-1000.00,'2023-02-20 14:39:34','',''),(2305,'1','303','1',1,'Retail Sale Id 2253',32354.10,0.00,0.00,46.89,937.80,'2023-02-20 14:41:21','',''),(2306,'1','303','1',1,'Distributed to A.A RANO LPG for sales id:2',623756.60,0.00,0.00,930.98,0.00,'2023-02-20 14:51:38','',''),(2307,'1','303','1',1,'Distributed to A.A RANO LPG for sales id:3',10813.80,0.00,0.00,16.14,0.00,'2023-02-20 14:55:29','',''),(2308,'1','303',NULL,1,'Purchased from AA RANO NIGERIA LTD',0.00,16250000.00,25000.00,0.00,0.00,'2023-02-20 16:57:21','',''),(2309,'1','303',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,25000.00,0.00,'2023-02-20 17:00:29','',''),(2310,'1','303','1',1,'Received from bridging 2',0.00,0.00,25000.00,0.00,0.00,'2023-02-20 17:00:29','',''),(2311,'1','303','1',1,'Retail Sale Id 2254',9000.00,0.00,0.00,12.50,875.00,'2023-02-20 17:05:06','',''),(2312,'1','303','1',1,'Retail Sale Id 2255',4500.00,0.00,0.00,6.25,437.50,'2023-02-20 17:07:09','',''),(2313,'1','303','1',1,'Retail Sale Id 2257',4320.00,0.00,0.00,6.00,420.00,'2023-02-20 17:09:15','',''),(2314,'1','303','1',1,'Retail Sale Id 2259',4320.00,0.00,0.00,6.00,420.00,'2023-02-20 17:16:52','',''),(2315,'1','303','1',1,'Retail Sale Id 2260',2160.00,0.00,0.00,3.00,210.00,'2023-02-20 17:17:51','',''),(2316,'1','303','1',1,'Retail Sale Id 2261',3600.00,0.00,0.00,5.00,350.00,'2023-02-20 17:25:39','',''),(2317,'1','303','1',1,'Retail Sale Id 2262',2001.60,0.00,0.00,2.78,194.60,'2023-02-20 17:28:33','',''),(2318,'1','303','1',1,'Retail Sale Id 2263',4320.00,0.00,0.00,6.00,420.00,'2023-02-20 17:30:48','',''),(2319,'1','303','1',1,'Retail Sale Id 2264',3002.40,0.00,0.00,4.17,291.90,'2023-02-20 17:34:11','',''),(2320,'1','303','1',1,'Retail Sale Id 2265',103500.00,0.00,0.00,150.00,6000.00,'2023-02-20 17:36:59','',''),(2321,'1','303','1',1,'Retail Sale Id 2267',1000.80,0.00,0.00,1.39,97.30,'2023-02-20 17:39:39','',''),(2322,'1','303','1',1,'Retail Sale Id 2267',1000.80,0.00,0.00,1.39,97.30,'2023-02-20 17:39:39','',''),(2323,'1','303','1',1,'Retail Sale Id 2269',4320.00,0.00,0.00,6.00,420.00,'2023-02-20 17:42:10','',''),(2324,'1','303','1',1,'Retail Sale Id 2269',9000.00,0.00,0.00,12.50,875.00,'2023-02-20 17:42:10','',''),(2325,'1','303','1',1,'Retail Sale Id 2270',4320.00,0.00,0.00,6.00,420.00,'2023-02-20 17:43:22','',''),(2326,'1','303','1',1,'Retail Sale Id 2271',3600.00,0.00,0.00,5.00,350.00,'2023-02-20 17:54:13','',''),(2327,'1','303','1',1,'Retail Sale Id 2273',2160.00,0.00,0.00,3.00,210.00,'2023-02-20 18:04:05','',''),(2328,'1','303','1',1,'Retail Sale Id 2274',4320.00,0.00,0.00,6.00,420.00,'2023-02-20 18:04:56','',''),(2329,'1','303','1',1,'Retail Sale Id 2275',5040.00,0.00,0.00,7.00,490.00,'2023-02-20 18:08:24','',''),(2330,'1','303','1',1,'Retail Sale Id 2276',4320.00,0.00,0.00,6.00,420.00,'2023-02-20 18:10:25','',''),(2331,'1','303','1',1,'Retail Sale Id 2277',4320.00,0.00,0.00,6.00,420.00,'2023-02-20 18:11:49','',''),(2332,'1','303','1',1,'Retail Sale Id 2278',1202.40,0.00,0.00,1.67,116.90,'2023-02-20 18:14:11','',''),(2333,'1','303','1',1,'Retail Sale Id 2278',2203.20,0.00,0.00,3.06,214.20,'2023-02-20 18:14:11','',''),(2334,'1','303','1',1,'Retail Sale Id 2279',2160.00,0.00,0.00,3.00,210.00,'2023-02-20 18:15:56','',''),(2335,'1','303','1',1,'Retail Sale Id 2280',14.40,0.00,0.00,0.02,1.40,'2023-02-20 19:33:39','',''),(2336,'1','303','1',1,'Retail Sale Id 2281',2007.90,0.00,0.00,2.91,116.40,'2023-02-20 19:41:39','',''),(2337,'1','303','1',1,'Retail Sale Id 2282',9000.00,0.00,0.00,12.50,875.00,'2023-02-21 08:16:28','',''),(2338,'1','303','1',1,'Retail Sale Id 2283',2880.00,0.00,0.00,4.00,280.00,'2023-02-21 08:35:03','',''),(2339,'1','303','1',1,'Retail Sale Id 2283',2880.00,0.00,0.00,4.00,280.00,'2023-02-21 08:35:03','',''),(2340,'1','303','1',1,'Retail Sale Id 2284',9000.00,0.00,0.00,12.50,875.00,'2023-02-21 09:09:43','',''),(2341,'1','303','1',1,'Retail Sale Id 2285',2160.00,0.00,0.00,3.00,210.00,'2023-02-21 09:25:39','',''),(2342,'1','303','1',1,'Retail Sale Id 2286',1000.80,0.00,0.00,1.39,97.30,'2023-02-21 09:30:16','',''),(2343,'1','303','1',1,'Retail Sale Id 2286',2001.60,0.00,0.00,2.78,194.60,'2023-02-21 09:30:16','',''),(2344,'1','303','1',1,'Retail Sale Id 2287',9000.00,0.00,0.00,12.50,875.00,'2023-02-21 09:34:31','',''),(2345,'1','303','1',1,'Retail Sale Id 2288',2160.00,0.00,0.00,3.00,210.00,'2023-02-21 09:40:55','',''),(2346,'1','303','1',1,'Retail Sale Id 2289',139996.80,0.00,0.00,194.44,13610.80,'2023-02-21 09:50:10','',''),(2347,'1','303','1',1,'Retail Sale Id 2290',13996.80,0.00,0.00,19.44,1360.80,'2023-02-21 09:51:07','',''),(2348,'1','303','1',1,'Return of Retail Sale Id 2289',0.00,139996.80,194.44,0.00,-13610.80,'2023-02-21 09:53:02','',''),(2349,'1','303','1',1,'Retail Sale Id 2291',4320.00,0.00,0.00,6.00,420.00,'2023-02-21 09:56:48','',''),(2350,'1','303','1',1,'Retail Sale Id 2292',9000.00,0.00,0.00,12.50,875.00,'2023-02-21 10:17:19','',''),(2351,'1','303','1',1,'Retail Sale Id 2293',3002.40,0.00,0.00,4.17,291.90,'2023-02-21 10:25:01','',''),(2352,'1','303','1',1,'Retail Sale Id 2294',3600.00,0.00,0.00,5.00,350.00,'2023-02-21 10:41:31','',''),(2353,'1','303','1',1,'Retail Sale Id 2295',4320.00,0.00,0.00,6.00,420.00,'2023-02-21 10:46:16','',''),(2354,'1','303','1',1,'Retail Sale Id 2296',597.60,0.00,0.00,0.83,58.10,'2023-02-21 10:53:41','',''),(2355,'1','303','1',1,'Retail Sale Id 2297',4320.00,0.00,0.00,6.00,420.00,'2023-02-21 11:07:56','',''),(2356,'1','303','1',1,'Retail Sale Id 2298',4320.00,0.00,0.00,6.00,420.00,'2023-02-21 11:09:26','',''),(2357,'1','303','1',1,'Retail Sale Id 2299',4320.00,0.00,0.00,6.00,420.00,'2023-02-21 11:11:21','',''),(2358,'1','303','1',1,'Retail Sale Id 2300',4320.00,0.00,0.00,6.00,420.00,'2023-02-21 11:44:04','',''),(2359,'1','303','1',1,'Retail Sale Id 2301',13320.00,0.00,0.00,18.50,1295.00,'2023-02-21 11:51:20','',''),(2360,'1','303','1',1,'Retail Sale Id 2302',34500.00,0.00,0.00,50.00,2000.00,'2023-02-21 11:54:38','',''),(2361,'1','303','1',1,'Retail Sale Id 2303',2160.00,0.00,0.00,3.00,210.00,'2023-02-21 12:20:20','',''),(2362,'1','303','1',1,'Retail Sale Id 2304',4500.00,0.00,0.00,6.25,437.50,'2023-02-21 12:46:23','',''),(2363,'1','303','1',1,'Retail Sale Id 2305',9000.00,0.00,0.00,12.50,875.00,'2023-02-21 13:00:43','',''),(2364,'1','303','1',1,'Retail Sale Id 2306',4003.20,0.00,0.00,5.56,389.20,'2023-02-21 13:02:12','',''),(2365,'1','303','1',1,'Retail Sale Id 2307',4320.00,0.00,0.00,6.00,420.00,'2023-02-21 13:30:40','',''),(2366,'1','303','1',1,'Retail Sale Id 2308',1000.80,0.00,0.00,1.39,97.30,'2023-02-21 13:32:12','',''),(2367,'1','303','1',1,'Retail Sale Id 2309',5040.00,0.00,0.00,7.00,490.00,'2023-02-21 13:42:47','',''),(2368,'1','303','1',1,'Retail Sale Id 2310',4320.00,0.00,0.00,6.00,420.00,'2023-02-21 13:48:40','',''),(2369,'1','303','1',1,'Retail Sale Id 2311',4320.00,0.00,0.00,6.00,420.00,'2023-02-21 13:50:01','',''),(2370,'1','303','1',1,'Retail Sale Id 2312',34500.00,0.00,0.00,50.00,2000.00,'2023-02-21 13:51:11','',''),(2371,'1','303','1',1,'Retail Sale Id 2313',3600.00,0.00,0.00,5.00,350.00,'2023-02-21 13:52:23','',''),(2372,'1','303','1',1,'Retail Sale Id 2314',4320.00,0.00,0.00,6.00,420.00,'2023-02-21 13:56:18','',''),(2373,'1','303','1',1,'Retail Sale Id 2315',1440.00,0.00,0.00,2.00,140.00,'2023-02-21 14:06:51','',''),(2374,'1','303','1',1,'Retail Sale Id 2316',9000.00,0.00,0.00,12.50,875.00,'2023-02-21 14:13:06','',''),(2375,'1','303','1',1,'Retail Sale Id 2317',2880.00,0.00,0.00,4.00,280.00,'2023-02-21 14:29:47','',''),(2376,'1','303','1',1,'Retail Sale Id 2318',2160.00,0.00,0.00,3.00,210.00,'2023-02-21 14:31:29','',''),(2377,'1','303','1',1,'Retail Sale Id 2319',2160.00,0.00,0.00,3.00,210.00,'2023-02-21 14:52:34','',''),(2378,'1','303','1',1,'Retail Sale Id 2320',2001.60,0.00,0.00,2.78,194.60,'2023-02-21 15:33:11','',''),(2379,'1','303','1',1,'Retail Sale Id 2321',2160.00,0.00,0.00,3.00,210.00,'2023-02-21 15:36:46','',''),(2380,'1','303','1',1,'Retail Sale Id 2322',2001.60,0.00,0.00,2.78,194.60,'2023-02-21 15:58:18','',''),(2381,'1','303','1',1,'Retail Sale Id 2323',3002.40,0.00,0.00,4.17,291.90,'2023-02-21 15:59:09','',''),(2382,'1','303','1',1,'Retail Sale Id 2324',2203.20,0.00,0.00,3.06,214.20,'2023-02-21 16:03:33','',''),(2383,'1','303','1',1,'Retail Sale Id 2325',2001.60,0.00,0.00,2.78,194.60,'2023-02-21 16:09:35','',''),(2384,'1','303','1',1,'Retail Sale Id 2326',2160.00,0.00,0.00,3.00,210.00,'2023-02-21 16:16:23','',''),(2385,'1','303','1',1,'Retail Sale Id 2327',8640.00,0.00,0.00,12.00,840.00,'2023-02-21 16:20:54','',''),(2386,'1','303','1',1,'Retail Sale Id 2328',2160.00,0.00,0.00,3.00,210.00,'2023-02-21 16:27:00','',''),(2387,'1','303','1',1,'Retail Sale Id 2329',3196.80,0.00,0.00,4.44,310.80,'2023-02-21 16:31:35','',''),(2388,'1','303','1',1,'Retail Sale Id 2330',4320.00,0.00,0.00,6.00,420.00,'2023-02-21 16:33:01','',''),(2389,'1','303','1',1,'Retail Sale Id 2331',4320.00,0.00,0.00,6.00,420.00,'2023-02-21 16:33:52','',''),(2390,'1','303','1',1,'Retail Sale Id 2332',4320.00,0.00,0.00,6.00,420.00,'2023-02-21 16:39:44','',''),(2391,'1','303','1',1,'Retail Sale Id 2333',8640.00,0.00,0.00,12.00,840.00,'2023-02-21 16:41:15','',''),(2392,'1','303','1',1,'Retail Sale Id 2334',1440.00,0.00,0.00,2.00,140.00,'2023-02-21 16:45:26','',''),(2393,'1','303','1',1,'Retail Sale Id 2335',2160.00,0.00,0.00,3.00,210.00,'2023-02-21 16:55:32','',''),(2394,'1','303','1',1,'Retail Sale Id 2336',2160.00,0.00,0.00,3.00,210.00,'2023-02-21 17:10:00','',''),(2395,'1','303','1',1,'Retail Sale Id 2337',1396.80,0.00,0.00,1.94,135.80,'2023-02-21 17:14:41','',''),(2396,'1','303','1',1,'Retail Sale Id 2338',4320.00,0.00,0.00,6.00,420.00,'2023-02-21 17:17:54','',''),(2397,'1','303','1',1,'Retail Sale Id 2339',2160.00,0.00,0.00,3.00,210.00,'2023-02-21 17:27:00','',''),(2398,'1','303','1',1,'Retail Sale Id 2340',496.80,0.00,0.00,0.69,48.30,'2023-02-21 17:33:29','',''),(2399,'1','303','1',1,'Retail Sale Id 2341',2160.00,0.00,0.00,3.00,210.00,'2023-02-21 17:36:52','',''),(2400,'1','303','1',1,'Retail Sale Id 2342',1440.00,0.00,0.00,2.00,140.00,'2023-02-21 17:46:25','',''),(2401,'1','303','1',1,'Retail Sale Id 2343',2160.00,0.00,0.00,3.00,210.00,'2023-02-21 17:54:41','',''),(2402,'1','303','1',1,'Retail Sale Id 2345',4320.00,0.00,0.00,6.00,420.00,'2023-02-21 17:59:24','',''),(2403,'1','303','1',1,'Retail Sale Id 2346',4320.00,0.00,0.00,6.00,420.00,'2023-02-22 08:59:54','',''),(2404,'1','303','1',1,'Retail Sale Id 2347',4320.00,0.00,0.00,6.00,420.00,'2023-02-22 09:01:45','',''),(2405,'1','303','1',1,'Retail Sale Id 2348',2160.00,0.00,0.00,3.00,210.00,'2023-02-22 09:27:50','',''),(2406,'1','303','1',1,'Retail Sale Id 2349',2160.00,0.00,0.00,3.00,210.00,'2023-02-22 10:00:33','',''),(2407,'1','303','1',1,'Retail Sale Id 2350',4320.00,0.00,0.00,6.00,420.00,'2023-02-22 10:18:38','',''),(2408,'1','303','1',1,'Retail Sale Id 2351',2001.60,0.00,0.00,2.78,194.60,'2023-02-22 10:20:17','',''),(2409,'1','303','1',1,'Retail Sale Id 2352',2800.80,0.00,0.00,3.89,272.30,'2023-02-22 10:27:19','',''),(2410,'1','303','1',1,'Retail Sale Id 2353',4320.00,0.00,0.00,6.00,420.00,'2023-02-22 10:39:13','',''),(2411,'1','303','1',1,'Retail Sale Id 2354',9000.00,0.00,0.00,12.50,875.00,'2023-02-22 10:51:19','',''),(2412,'1','303','1',1,'Retail Sale Id 2355',4320.00,0.00,0.00,6.00,420.00,'2023-02-22 10:52:34','',''),(2413,'1','303','1',1,'Retail Sale Id 2356',2160.00,0.00,0.00,3.00,210.00,'2023-02-22 10:59:14','',''),(2414,'1','303','1',1,'Retail Sale Id 2357',4320.00,0.00,0.00,6.00,420.00,'2023-02-22 11:02:49','',''),(2415,'1','303','1',1,'Retail Sale Id 2358',2001.60,0.00,0.00,2.78,194.60,'2023-02-22 11:07:28','',''),(2416,'1','303','1',1,'Retail Sale Id 2359',496.80,0.00,0.00,0.69,48.30,'2023-02-22 11:15:32','',''),(2417,'1','303','1',1,'Retail Sale Id 2360',2160.00,0.00,0.00,3.00,210.00,'2023-02-22 11:24:50','',''),(2418,'1','303','1',1,'Retail Sale Id 2361',9000.00,0.00,0.00,12.50,875.00,'2023-02-22 11:28:18','',''),(2419,'1','303','1',1,'Retail Sale Id 2362',103500.00,0.00,0.00,150.00,6000.00,'2023-02-22 11:47:06','',''),(2420,'1','303','1',1,'Retail Sale Id 2363',1000.80,0.00,0.00,1.39,97.30,'2023-02-22 12:02:20','',''),(2421,'1','303','1',1,'Retail Sale Id 2364',3600.00,0.00,0.00,5.00,350.00,'2023-02-22 12:06:04','',''),(2422,'1','303','1',1,'Retail Sale Id 2365',4399.20,0.00,0.00,6.11,427.70,'2023-02-22 12:25:31','',''),(2423,'1','303','1',1,'Retail Sale Id 2366',9000.00,0.00,0.00,12.50,875.00,'2023-02-22 12:30:35','',''),(2424,'1','303','1',1,'Retail Sale Id 2367',1000.80,0.00,0.00,1.39,97.30,'2023-02-22 12:35:08','',''),(2425,'1','303','1',1,'Retail Sale Id 2367',1497.60,0.00,0.00,2.08,145.60,'2023-02-22 12:35:08','',''),(2426,'1','303','1',1,'Retail Sale Id 2368',3002.40,0.00,0.00,4.17,291.90,'2023-02-22 12:58:51','',''),(2427,'1','303','1',1,'Retail Sale Id 2369',3600.00,0.00,0.00,5.00,350.00,'2023-02-22 13:01:07','',''),(2428,'1','303','1',1,'Retail Sale Id 2369',3600.00,0.00,0.00,5.00,350.00,'2023-02-22 13:01:07','',''),(2429,'1','303','1',1,'Retail Sale Id 2370',2160.00,0.00,0.00,3.00,210.00,'2023-02-22 13:03:04','',''),(2430,'1','303','1',1,'Retail Sale Id 2371',1000.80,0.00,0.00,1.39,97.30,'2023-02-22 13:21:19','',''),(2431,'1','303','1',1,'Retail Sale Id 2372',4320.00,0.00,0.00,6.00,420.00,'2023-02-22 13:23:03','',''),(2432,'1','303','1',1,'Retail Sale Id 2373',1497.60,0.00,0.00,2.08,145.60,'2023-02-22 13:26:30','',''),(2433,'1','303','1',1,'Retail Sale Id 2374',4320.00,0.00,0.00,6.00,420.00,'2023-02-22 13:41:13','',''),(2434,'1','303','1',1,'Retail Sale Id 2375',9000.00,0.00,0.00,12.50,875.00,'2023-02-22 13:52:52','',''),(2435,'1','303','1',1,'Retail Sale Id 2376',2160.00,0.00,0.00,3.00,210.00,'2023-02-22 13:54:50','',''),(2436,'1','303','1',1,'Retail Sale Id 2377',7200.00,0.00,0.00,10.00,700.00,'2023-02-22 13:59:52','',''),(2437,'1','303','1',1,'Retail Sale Id 2378',4320.00,0.00,0.00,6.00,420.00,'2023-02-22 14:05:20','',''),(2438,'1','303','1',1,'Retail Sale Id 2379',2160.00,0.00,0.00,3.00,210.00,'2023-02-22 14:07:47','',''),(2439,'1','303','1',1,'Retail Sale Id 2380',5760.00,0.00,0.00,8.00,560.00,'2023-02-22 14:10:09','',''),(2440,'1','303','1',1,'Retail Sale Id 2381',2001.60,0.00,0.00,2.78,194.60,'2023-02-22 14:12:16','',''),(2441,'1','303','1',1,'Retail Sale Id 2383',4320.00,0.00,0.00,6.00,420.00,'2023-02-22 14:14:57','',''),(2442,'1','303','1',1,'Retail Sale Id 2384',720.00,0.00,0.00,1.00,70.00,'2023-02-22 14:16:12','',''),(2443,'1','303','1',1,'Retail Sale Id 2385',2001.60,0.00,0.00,2.78,194.60,'2023-02-22 14:47:20','',''),(2444,'1','303','1',1,'Retail Sale Id 2386',3002.40,0.00,0.00,4.17,291.90,'2023-02-22 15:00:33','',''),(2445,'1','303','1',1,'Retail Sale Id 2387',2160.00,0.00,0.00,3.00,210.00,'2023-02-22 15:13:37','',''),(2446,'1','303','1',1,'Retail Sale Id 2388',7200.00,0.00,0.00,10.00,700.00,'2023-02-22 15:23:33','',''),(2447,'1','303','1',1,'Retail Sale Id 2389',4320.00,0.00,0.00,6.00,420.00,'2023-02-22 15:26:58','',''),(2448,'1','303','1',1,'Retail Sale Id 2390',2160.00,0.00,0.00,3.00,210.00,'2023-02-22 15:47:01','',''),(2449,'1','303','1',1,'Retail Sale Id 2391',3600.00,0.00,0.00,5.00,350.00,'2023-02-22 15:59:45','',''),(2450,'1','303','1',1,'Retail Sale Id 2392',2160.00,0.00,0.00,3.00,210.00,'2023-02-22 16:02:19','',''),(2451,'1','303','1',1,'Retail Sale Id 2393',4298.40,0.00,0.00,5.97,417.90,'2023-02-22 16:10:53','',''),(2452,'1','303','1',1,'Retail Sale Id 2394',7200.00,0.00,0.00,10.00,700.00,'2023-02-22 16:27:46','',''),(2453,'1','303','1',1,'Retail Sale Id 2395',720.00,0.00,0.00,1.00,70.00,'2023-02-22 16:29:24','',''),(2454,'1','303','1',1,'Return of Retail Sale Id 2394',0.00,7200.00,10.00,0.00,-700.00,'2023-02-22 16:33:50','',''),(2455,'1','303','1',1,'Retail Sale Id 2396',720.00,0.00,0.00,1.00,70.00,'2023-02-22 16:40:48','',''),(2456,'1','303','1',1,'Retail Sale Id 2397',9000.00,0.00,0.00,12.50,875.00,'2023-02-22 16:42:41','',''),(2457,'1','303','1',1,'Retail Sale Id 2398',2160.00,0.00,0.00,3.00,210.00,'2023-02-22 16:43:49','',''),(2458,'1','303','1',1,'Retail Sale Id 2399',2160.00,0.00,0.00,3.00,210.00,'2023-02-22 16:47:26','',''),(2459,'1','303','1',1,'Retail Sale Id 2400',4348.80,0.00,0.00,6.04,422.80,'2023-02-22 17:00:15','',''),(2460,'1','303','1',1,'Retail Sale Id 2401',1440.00,0.00,0.00,2.00,140.00,'2023-02-22 17:08:27','',''),(2461,'1','303','1',1,'Retail Sale Id 2401',3600.00,0.00,0.00,5.00,350.00,'2023-02-22 17:08:27','',''),(2462,'1','303','1',1,'Retail Sale Id 2403',5760.00,0.00,0.00,8.00,560.00,'2023-02-22 17:13:58','',''),(2463,'1','303','1',1,'Retail Sale Id 2404',720.00,0.00,0.00,1.00,70.00,'2023-02-22 17:19:48','',''),(2464,'1','303','1',1,'Retail Sale Id 2404',6480.00,0.00,0.00,9.00,630.00,'2023-02-22 17:19:48','',''),(2465,'1','303','1',1,'Retail Sale Id 2405',4320.00,0.00,0.00,6.00,420.00,'2023-02-22 17:25:00','',''),(2466,'1','303','1',1,'Retail Sale Id 2407',9000.00,0.00,0.00,12.50,875.00,'2023-02-22 17:32:17','',''),(2467,'1','303','1',1,'Retail Sale Id 2408',1000.80,0.00,0.00,1.39,97.30,'2023-02-22 17:33:58','',''),(2468,'1','303','1',1,'Retail Sale Id 2409',3600.00,0.00,0.00,5.00,350.00,'2023-02-22 17:44:10','',''),(2469,'1','303','1',1,'Retail Sale Id 2410',4197.60,0.00,0.00,5.83,408.10,'2023-02-22 17:49:26','',''),(2470,'1','303','1',1,'Retail Sale Id 2411',1396.80,0.00,0.00,1.94,135.80,'2023-02-22 17:55:14','',''),(2471,'1','303','1',1,'Retail Sale Id 2412',1497.60,0.00,0.00,2.08,145.60,'2023-02-22 17:58:08','',''),(2472,'1','303','1',1,'Retail Sale Id 2413',1000.80,0.00,0.00,1.39,97.30,'2023-02-22 18:17:50','',''),(2473,'1','303','1',1,'Retail Sale Id 2414',4320.00,0.00,0.00,6.00,420.00,'2023-02-22 18:23:47','',''),(2474,'1','303','1',1,'Retail Sale Id 2415',4320.00,0.00,0.00,6.00,420.00,'2023-02-22 18:27:16','',''),(2475,'1','303','1',1,'Retail Sale Id 2416',3600.00,0.00,0.00,5.00,350.00,'2023-02-23 08:19:56','',''),(2476,'1','303','1',1,'Retail Sale Id 2417',4320.00,0.00,0.00,6.00,420.00,'2023-02-23 08:32:43','',''),(2477,'1','303','1',1,'Retail Sale Id 2418',5040.00,0.00,0.00,7.00,490.00,'2023-02-23 08:34:48','',''),(2478,'1','303','1',1,'Retail Sale Id 2419',4320.00,0.00,0.00,6.00,420.00,'2023-02-23 08:46:09','',''),(2479,'1','303','1',1,'Retail Sale Id 2419',7200.00,0.00,0.00,10.00,700.00,'2023-02-23 08:46:09','',''),(2480,'1','303','1',1,'Retail Sale Id 2420',4320.00,0.00,0.00,6.00,420.00,'2023-02-23 09:15:20','',''),(2481,'1','303','1',1,'Retail Sale Id 2420',7200.00,0.00,0.00,10.00,700.00,'2023-02-23 09:15:20','',''),(2482,'1','303','1',1,'Retail Sale Id 2421',7200.00,0.00,0.00,10.00,700.00,'2023-02-23 09:38:42','',''),(2483,'1','303','1',1,'Retail Sale Id 2422',1440.00,0.00,0.00,2.00,140.00,'2023-02-23 09:54:43','',''),(2484,'1','303','1',1,'Retail Sale Id 2423',1303.20,0.00,0.00,1.81,126.70,'2023-02-23 09:56:57','',''),(2485,'1','303','1',1,'Retail Sale Id 2424',2001.60,0.00,0.00,2.78,194.60,'2023-02-23 10:06:53','',''),(2486,'1','303','1',1,'Retail Sale Id 2425',2160.00,0.00,0.00,3.00,210.00,'2023-02-23 10:23:20','',''),(2487,'1','303','1',1,'Retail Sale Id 2427',4320.00,0.00,0.00,6.00,420.00,'2023-02-23 10:59:20','',''),(2488,'1','303','1',1,'Retail Sale Id 2428',9000.00,0.00,0.00,12.50,875.00,'2023-02-23 11:02:01','',''),(2489,'1','303','1',1,'Retail Sale Id 2429',3600.00,0.00,0.00,5.00,350.00,'2023-02-23 11:07:59','',''),(2490,'1','303','1',1,'Retail Sale Id 2430',2160.00,0.00,0.00,3.00,210.00,'2023-02-23 11:13:21','',''),(2491,'1','303','1',1,'Retail Sale Id 2431',1440.00,0.00,0.00,2.00,140.00,'2023-02-23 11:14:49','',''),(2492,'1','303','1',1,'Retail Sale Id 2432',4320.00,0.00,0.00,6.00,420.00,'2023-02-23 11:17:31','',''),(2493,'1','303','1',1,'Retail Sale Id 2433',2160.00,0.00,0.00,3.00,210.00,'2023-02-23 11:26:21','',''),(2494,'1','303','1',1,'Retail Sale Id 2434',2160.00,0.00,0.00,3.00,210.00,'2023-02-23 11:33:18','',''),(2495,'1','303','1',1,'Retail Sale Id 2436',1497.60,0.00,0.00,2.08,145.60,'2023-02-23 11:45:32','',''),(2496,'1','303','1',1,'Retail Sale Id 2437',4500.00,0.00,0.00,6.25,437.50,'2023-02-23 11:51:18','',''),(2497,'1','303','1',1,'Retail Sale Id 2438',9000.00,0.00,0.00,12.50,875.00,'2023-02-23 12:07:48','',''),(2498,'1','303','1',1,'Retail Sale Id 2439',3600.00,0.00,0.00,5.00,350.00,'2023-02-23 12:15:48','',''),(2499,'1','303','1',1,'Retail Sale Id 2440',3600.00,0.00,0.00,5.00,350.00,'2023-02-23 13:14:52','',''),(2500,'1','303','1',1,'Retail Sale Id 2441',9000.00,0.00,0.00,12.50,875.00,'2023-02-23 13:16:20','',''),(2501,'1','303','1',1,'Retail Sale Id 2442',4320.00,0.00,0.00,6.00,420.00,'2023-02-23 13:32:51','',''),(2502,'1','303','1',1,'Retail Sale Id 2443',9000.00,0.00,0.00,12.50,875.00,'2023-02-23 13:37:33','',''),(2503,'1','303','1',1,'Retail Sale Id 2444',4320.00,0.00,0.00,6.00,420.00,'2023-02-23 13:42:40','',''),(2504,'1','303','1',1,'Retail Sale Id 2445',90000.00,0.00,0.00,125.00,8750.00,'2023-02-23 14:00:29','',''),(2505,'1','303','1',1,'Retail Sale Id 2446',9000.00,0.00,0.00,12.50,875.00,'2023-02-23 14:01:31','',''),(2506,'1','303','1',1,'Return of Retail Sale Id 2445',0.00,90000.00,125.00,0.00,-8750.00,'2023-02-23 14:03:03','',''),(2507,'1','303','1',1,'Retail Sale Id 2447',7200.00,0.00,0.00,10.00,700.00,'2023-02-23 14:10:58','',''),(2508,'1','303','1',1,'Retail Sale Id 2448',2203.20,0.00,0.00,3.06,214.20,'2023-02-23 14:13:04','',''),(2509,'1','303','1',1,'Retail Sale Id 2449',207000.00,0.00,0.00,300.00,12000.00,'2023-02-23 14:28:19','',''),(2510,'1','303','1',1,'Retail Sale Id 2450',586500.00,0.00,0.00,850.00,34000.00,'2023-02-23 14:31:37','',''),(2511,'1','303','1',1,'Retail Sale Id 2451',4320.00,0.00,0.00,6.00,420.00,'2023-02-23 14:33:43','',''),(2512,'1','303','1',1,'Retail Sale Id 2452',9000.00,0.00,0.00,12.50,875.00,'2023-02-23 14:36:16','',''),(2513,'1','303','1',1,'Retail Sale Id 2453',2880.00,0.00,0.00,4.00,280.00,'2023-02-23 14:42:36','',''),(2514,'1','303','1',1,'Retail Sale Id 2454',3600.00,0.00,0.00,5.00,350.00,'2023-02-23 14:50:59','',''),(2515,'1','303','1',1,'Retail Sale Id 2454',4320.00,0.00,0.00,6.00,420.00,'2023-02-23 14:50:59','',''),(2516,'1','303','1',1,'Retail Sale Id 2455',4320.00,0.00,0.00,6.00,420.00,'2023-02-23 14:54:17','',''),(2517,'1','303','1',1,'Retail Sale Id 2455',4320.00,0.00,0.00,6.00,420.00,'2023-02-23 14:54:17','',''),(2518,'1','303','1',1,'Retail Sale Id 2456',9000.00,0.00,0.00,12.50,875.00,'2023-02-23 15:07:15','',''),(2519,'1','303','1',1,'Retail Sale Id 2457',2001.60,0.00,0.00,2.78,194.60,'2023-02-23 15:10:37','',''),(2520,'1','303','1',1,'Retail Sale Id 2458',2160.00,0.00,0.00,3.00,210.00,'2023-02-23 15:16:33','',''),(2521,'1','303','1',1,'Retail Sale Id 2458',4320.00,0.00,0.00,6.00,420.00,'2023-02-23 15:16:33','',''),(2522,'1','303','1',1,'Retail Sale Id 2459',1440.00,0.00,0.00,2.00,140.00,'2023-02-23 15:20:09','',''),(2523,'1','303','1',1,'Retail Sale Id 2460',4320.00,0.00,0.00,6.00,420.00,'2023-02-23 15:49:37','',''),(2524,'1','303','1',1,'Retail Sale Id 2461',103500.00,0.00,0.00,150.00,6000.00,'2023-02-23 15:53:39','',''),(2525,'1','303','1',1,'Retail Sale Id 2462',3795.00,0.00,0.00,5.50,220.00,'2023-02-23 16:02:28','',''),(2526,'1','303','1',1,'Retail Sale Id 2463',2160.00,0.00,0.00,3.00,210.00,'2023-02-23 16:18:21','',''),(2527,'1','303','1',1,'Retail Sale Id 2464',9000.00,0.00,0.00,12.50,875.00,'2023-02-23 16:25:27','',''),(2528,'1','303','1',1,'Retail Sale Id 2465',34500.00,0.00,0.00,50.00,2000.00,'2023-02-23 16:38:31','',''),(2529,'1','303','1',1,'Retail Sale Id 2466',4320.00,0.00,0.00,6.00,420.00,'2023-02-23 16:40:32','',''),(2530,'1','303','1',1,'Retail Sale Id 2467',9000.00,0.00,0.00,12.50,875.00,'2023-02-23 16:51:41','',''),(2531,'1','303','1',1,'Retail Sale Id 2468',4320.00,0.00,0.00,6.00,420.00,'2023-02-23 16:54:06','',''),(2532,'1','303','1',1,'Retail Sale Id 2469',2160.00,0.00,0.00,3.00,210.00,'2023-02-23 17:00:48','',''),(2533,'1','303','1',1,'Retail Sale Id 2469',4320.00,0.00,0.00,6.00,420.00,'2023-02-23 17:00:48','',''),(2534,'1','303','1',1,'Retail Sale Id 2470',2160.00,0.00,0.00,3.00,210.00,'2023-02-23 17:11:08','',''),(2535,'1','303','1',1,'Retail Sale Id 2470',4320.00,0.00,0.00,6.00,420.00,'2023-02-23 17:11:08','',''),(2536,'1','303','1',1,'Retail Sale Id 2471',1800.00,0.00,0.00,2.50,175.00,'2023-02-23 17:12:33','',''),(2537,'1','303','1',1,'Retail Sale Id 2472',4320.00,0.00,0.00,6.00,420.00,'2023-02-23 17:19:35','',''),(2538,'1','303','1',1,'Retail Sale Id 2473',2160.00,0.00,0.00,3.00,210.00,'2023-02-23 17:21:38','',''),(2539,'1','303','1',1,'Retail Sale Id 2474',3600.00,0.00,0.00,5.00,350.00,'2023-02-23 17:34:06','',''),(2540,'1','303','1',1,'Retail Sale Id 2475',4320.00,0.00,0.00,6.00,420.00,'2023-02-23 17:38:53','',''),(2541,'1','303','1',1,'Retail Sale Id 2476',3600.00,0.00,0.00,5.00,350.00,'2023-02-23 17:42:59','',''),(2542,'1','303','1',1,'Retail Sale Id 2477',4320.00,0.00,0.00,6.00,420.00,'2023-02-23 17:45:11','',''),(2543,'1','303','1',1,'Retail Sale Id 2478',4320.00,0.00,0.00,6.00,420.00,'2023-02-23 17:47:49','',''),(2544,'1','303','1',1,'Retail Sale Id 2479',4500.00,0.00,0.00,6.25,437.50,'2023-02-23 17:55:27','',''),(2545,'1','303','1',1,'Retail Sale Id 2480',2001.60,0.00,0.00,2.78,194.60,'2023-02-23 18:03:15','',''),(2546,'1','303','1',1,'Retail Sale Id 2481',720.00,0.00,0.00,1.00,70.00,'2023-02-23 18:06:43','',''),(2547,'1','303','1',1,'Retail Sale Id 2482',4003.20,0.00,0.00,5.56,389.20,'2023-02-23 18:11:21','',''),(2548,'1','303','1',1,'Retail Sale Id 2483',2001.60,0.00,0.00,2.78,194.60,'2023-02-23 19:16:32','',''),(2549,'1','303','1',1,'Retail Sale Id 2484',5040.00,0.00,0.00,7.00,490.00,'2023-02-24 08:02:12','',''),(2550,'1','303','1',1,'Retail Sale Id 2485',4320.00,0.00,0.00,6.00,420.00,'2023-02-24 08:03:12','',''),(2551,'1','303','1',1,'Retail Sale Id 2487',40020.00,0.00,0.00,58.00,2320.00,'2023-02-24 08:28:15','',''),(2552,'1','303','1',1,'Retail Sale Id 2488',2160.00,0.00,0.00,3.00,210.00,'2023-02-24 08:42:09','',''),(2553,'1','303','1',1,'Retail Sale Id 2489',3002.40,0.00,0.00,4.17,291.90,'2023-02-24 09:04:16','',''),(2554,'1','303','1',1,'Retail Sale Id 2490',2160.00,0.00,0.00,3.00,210.00,'2023-02-24 09:16:39','',''),(2555,'1','303','1',1,'Retail Sale Id 2491',1497.60,0.00,0.00,2.08,145.60,'2023-02-24 09:34:02','',''),(2556,'1','303','1',1,'Retail Sale Id 2492',4320.00,0.00,0.00,6.00,420.00,'2023-02-24 09:35:00','',''),(2557,'1','303','1',1,'Retail Sale Id 2493',4320.00,0.00,0.00,6.00,420.00,'2023-02-24 09:36:03','',''),(2558,'1','303','1',1,'Retail Sale Id 2494',4320.00,0.00,0.00,6.00,420.00,'2023-02-24 09:45:24','',''),(2559,'1','303','1',1,'Retail Sale Id 2495',5040.00,0.00,0.00,7.00,490.00,'2023-02-24 09:51:23','',''),(2560,'1','303','1',1,'Retail Sale Id 2496',1101.60,0.00,0.00,1.53,107.10,'2023-02-24 09:56:49','',''),(2561,'1','303','1',1,'Retail Sale Id 2497',2880.00,0.00,0.00,4.00,280.00,'2023-02-24 10:00:23','',''),(2562,'1','303','1',1,'Retail Sale Id 2498',2498.40,0.00,0.00,3.47,242.90,'2023-02-24 10:11:32','',''),(2563,'1','303','1',1,'Retail Sale Id 2499',1000.80,0.00,0.00,1.39,97.30,'2023-02-24 10:23:32','',''),(2564,'1','303','1',1,'Retail Sale Id 2500',2160.00,0.00,0.00,3.00,210.00,'2023-02-24 10:49:41','',''),(2565,'1','303','1',1,'Retail Sale Id 2501',2160.00,0.00,0.00,3.00,210.00,'2023-02-24 10:53:22','',''),(2566,'1','303','1',1,'Retail Sale Id 2502',4320.00,0.00,0.00,6.00,420.00,'2023-02-24 10:58:55','',''),(2567,'1','303','1',1,'Retail Sale Id 2503',9000.00,0.00,0.00,12.50,875.00,'2023-02-24 11:10:53','',''),(2568,'1','303','1',1,'Retail Sale Id 2504',7200.00,0.00,0.00,10.00,700.00,'2023-02-24 11:13:27','',''),(2569,'1','303','1',1,'Retail Sale Id 2505',2160.00,0.00,0.00,3.00,210.00,'2023-02-24 11:18:50','',''),(2570,'1','303','1',1,'Retail Sale Id 2506',4320.00,0.00,0.00,6.00,420.00,'2023-02-24 11:31:42','',''),(2571,'1','303','1',1,'Retail Sale Id 2507',4320.00,0.00,0.00,6.00,420.00,'2023-02-24 11:34:59','',''),(2572,'1','303','1',1,'Retail Sale Id 2508',4320.00,0.00,0.00,6.00,420.00,'2023-02-24 11:37:16','',''),(2573,'1','303','1',1,'Retail Sale Id 2509',2160.00,0.00,0.00,3.00,210.00,'2023-02-24 11:39:46','',''),(2574,'1','303','1',1,'Retail Sale Id 2510',2160.00,0.00,0.00,3.00,210.00,'2023-02-24 11:54:28','',''),(2575,'1','303','1',1,'Retail Sale Id 2511',4320.00,0.00,0.00,6.00,420.00,'2023-02-24 11:59:18','',''),(2576,'1','303','1',1,'Retail Sale Id 2512',2160.00,0.00,0.00,3.00,210.00,'2023-02-24 12:21:08','',''),(2577,'1','303','1',1,'Retail Sale Id 2513',7560.00,0.00,0.00,10.50,735.00,'2023-02-24 12:33:07','',''),(2578,'1','303','1',1,'Retail Sale Id 2514',6998.40,0.00,0.00,9.72,680.40,'2023-02-24 12:45:20','',''),(2579,'1','303','1',1,'Retail Sale Id 2514',6998.40,0.00,0.00,9.72,680.40,'2023-02-24 12:45:20','',''),(2580,'1','303','1',1,'Retail Sale Id 2514',6998.40,0.00,0.00,9.72,680.40,'2023-02-24 12:45:20','',''),(2581,'1','303','1',1,'Retail Sale Id 2515',4996.80,0.00,0.00,6.94,485.80,'2023-02-24 13:00:56','',''),(2582,'1','303','1',1,'Retail Sale Id 2516',2001.60,0.00,0.00,2.78,194.60,'2023-02-24 13:10:14','',''),(2583,'1','303','1',1,'Retail Sale Id 2517',2160.00,0.00,0.00,3.00,210.00,'2023-02-24 13:39:39','',''),(2584,'1','303','1',1,'Retail Sale Id 2518',27000.00,0.00,0.00,37.50,2625.00,'2023-02-24 13:44:37','',''),(2585,'1','303','1',1,'Retail Sale Id 2519',9000.00,0.00,0.00,12.50,875.00,'2023-02-24 13:56:22','',''),(2586,'1','303','1',1,'Retail Sale Id 2520',5400.00,0.00,0.00,7.50,525.00,'2023-02-24 14:14:46','',''),(2587,'1','303','1',1,'Retail Sale Id 2521',4320.00,0.00,0.00,6.00,420.00,'2023-02-24 14:16:32','',''),(2588,'1','303','1',1,'Retail Sale Id 2522',2160.00,0.00,0.00,3.00,210.00,'2023-02-24 14:18:34','',''),(2589,'1','303','1',1,'Retail Sale Id 2523',3600.00,0.00,0.00,5.00,350.00,'2023-02-24 14:25:35','',''),(2590,'1','303','1',1,'Retail Sale Id 2524',2160.00,0.00,0.00,3.00,210.00,'2023-02-24 14:27:58','',''),(2591,'1','303','1',1,'Retail Sale Id 2525',2160.00,0.00,0.00,3.00,210.00,'2023-02-24 14:44:10','',''),(2592,'1','303','1',1,'Retail Sale Id 2526',2160.00,0.00,0.00,3.00,210.00,'2023-02-24 14:54:25','',''),(2593,'1','303','1',1,'Retail Sale Id 2527',4320.00,0.00,0.00,6.00,420.00,'2023-02-24 15:09:05','',''),(2594,'1','303','1',1,'Retail Sale Id 2528',1000.80,0.00,0.00,1.39,97.30,'2023-02-24 15:14:02','',''),(2595,'1','303','1',1,'Retail Sale Id 2529',4320.00,0.00,0.00,6.00,420.00,'2023-02-24 15:17:24','',''),(2596,'1','303','1',1,'Retail Sale Id 2530',4320.00,0.00,0.00,6.00,420.00,'2023-02-24 15:18:30','',''),(2597,'1','303','1',1,'Retail Sale Id 2531',2160.00,0.00,0.00,3.00,210.00,'2023-02-24 15:20:32','',''),(2598,'1','303','1',1,'Retail Sale Id 2532',34500.00,0.00,0.00,50.00,2000.00,'2023-02-24 15:28:28','',''),(2599,'1','303','1',1,'Retail Sale Id 2533',2498.40,0.00,0.00,3.47,242.90,'2023-02-24 15:29:32','',''),(2600,'1','303','1',1,'Retail Sale Id 2534',3600.00,0.00,0.00,5.00,350.00,'2023-02-24 15:31:15','',''),(2601,'1','303','1',1,'Retail Sale Id 2535',9000.00,0.00,0.00,12.50,875.00,'2023-02-24 15:32:23','',''),(2602,'1','303','1',1,'Retail Sale Id 2536',2160.00,0.00,0.00,3.00,210.00,'2023-02-24 15:34:29','',''),(2603,'1','303','1',1,'Retail Sale Id 2536',2880.00,0.00,0.00,4.00,280.00,'2023-02-24 15:34:29','',''),(2604,'1','303','1',1,'Retail Sale Id 2537',1497.60,0.00,0.00,2.08,145.60,'2023-02-24 15:36:27','',''),(2605,'1','303','1',1,'Retail Sale Id 2538',2160.00,0.00,0.00,3.00,210.00,'2023-02-24 15:38:50','',''),(2606,'1','303','1',1,'Retail Sale Id 2539',5997.60,0.00,0.00,8.33,583.10,'2023-02-24 15:42:00','',''),(2607,'1','303','1',1,'Retail Sale Id 2540',4320.00,0.00,0.00,6.00,420.00,'2023-02-24 15:43:31','',''),(2608,'1','303','1',1,'Retail Sale Id 2541',9000.00,0.00,0.00,12.50,875.00,'2023-02-24 15:45:11','',''),(2609,'1','303','1',1,'Retail Sale Id 2542',4320.00,0.00,0.00,6.00,420.00,'2023-02-24 15:50:35','',''),(2610,'1','303','1',1,'Retail Sale Id 2543',9000.00,0.00,0.00,12.50,875.00,'2023-02-24 16:20:11','',''),(2611,'1','303','1',1,'Retail Sale Id 2544',4320.00,0.00,0.00,6.00,420.00,'2023-02-24 16:33:03','',''),(2612,'1','303','1',1,'Retail Sale Id 2545',4003.20,0.00,0.00,5.56,389.20,'2023-02-24 16:41:54','',''),(2613,'1','303','1',1,'Retail Sale Id 2546',4320.00,0.00,0.00,6.00,420.00,'2023-02-24 16:42:53','',''),(2614,'1','303','1',1,'Retail Sale Id 2547',4320.00,0.00,0.00,6.00,420.00,'2023-02-24 16:50:16','',''),(2615,'1','303','1',1,'Retail Sale Id 2548',4003.20,0.00,0.00,5.56,389.20,'2023-02-24 16:53:04','',''),(2616,'1','303','1',1,'Retail Sale Id 2549',9000.00,0.00,0.00,12.50,875.00,'2023-02-24 16:55:28','',''),(2617,'1','303','1',1,'Retail Sale Id 2550',4320.00,0.00,0.00,6.00,420.00,'2023-02-24 17:21:35','',''),(2618,'1','303','1',1,'Retail Sale Id 2551',1000.80,0.00,0.00,1.39,97.30,'2023-02-24 17:22:39','',''),(2619,'1','303','1',1,'Retail Sale Id 2552',3002.40,0.00,0.00,4.17,291.90,'2023-02-24 17:32:40','',''),(2620,'1','303','1',1,'Retail Sale Id 2553',9000.00,0.00,0.00,12.50,875.00,'2023-02-24 17:36:45','',''),(2621,'1','303','1',1,'Retail Sale Id 2554',4320.00,0.00,0.00,6.00,420.00,'2023-02-24 17:58:25','',''),(2622,'1','303','1',1,'Retail Sale Id 2555',7920.00,0.00,0.00,11.00,770.00,'2023-02-24 18:02:47','',''),(2623,'1','303','1',1,'Retail Sale Id 2556',4320.00,0.00,0.00,6.00,420.00,'2023-02-24 18:04:00','',''),(2624,'1','303','1',1,'Retail Sale Id 2557',4320.00,0.00,0.00,6.00,420.00,'2023-02-24 18:07:02','',''),(2625,'1','303','1',1,'Retail Sale Id 2558',1000.80,0.00,0.00,1.39,97.30,'2023-02-24 18:08:26','',''),(2626,'1','303','1',1,'Retail Sale Id 2559',2160.00,0.00,0.00,3.00,210.00,'2023-02-24 18:09:25','',''),(2627,'1','303','1',1,'Retail Sale Id 2560',2001.60,0.00,0.00,2.78,194.60,'2023-02-24 18:16:10','',''),(2628,'1','303','1',1,'Retail Sale Id 2561',2001.60,0.00,0.00,2.78,194.60,'2023-02-24 18:17:35','',''),(2629,'1','303','1',1,'Retail Sale Id 2562',3600.00,0.00,0.00,5.00,350.00,'2023-02-24 18:18:33','',''),(2630,'1','303','1',1,'Retail Sale Id 2563',586500.00,0.00,0.00,850.00,34000.00,'2023-02-24 19:03:25','',''),(2631,'1','303','1',1,'Return of Retail Sale Id 2558',0.00,1000.80,1.39,0.00,-97.30,'2023-02-24 19:34:58','',''),(2632,'1','303','1',1,'Retail Sale Id 2564',691.20,0.00,0.00,0.96,67.20,'2023-02-24 19:35:46','',''),(2633,'1','303','1',1,'Retail Sale Id 2565',690.00,0.00,0.00,1.00,40.00,'2023-02-24 19:52:16','',''),(2634,'1','303','1',1,'Return of Retail Sale Id 2565',0.00,690.00,1.00,0.00,-40.00,'2023-02-24 20:04:33','',''),(2635,'1','303','1',1,'Retail Sale Id 2566',9000.00,0.00,0.00,12.50,875.00,'2023-02-26 12:06:29','',''),(2636,'1','303','1',1,'Retail Sale Id 2567',9000.00,0.00,0.00,12.50,875.00,'2023-02-26 12:08:02','',''),(2637,'1','303','1',1,'Retail Sale Id 2568',2498.40,0.00,0.00,3.47,242.90,'2023-02-26 12:09:38','',''),(2638,'1','303','1',1,'Retail Sale Id 2569',3600.00,0.00,0.00,5.00,350.00,'2023-02-26 12:18:14','',''),(2639,'1','303','1',1,'Retail Sale Id 2570',9000.00,0.00,0.00,12.50,875.00,'2023-02-26 12:19:18','',''),(2640,'1','303','1',1,'Retail Sale Id 2571',720.00,0.00,0.00,1.00,70.00,'2023-02-26 12:20:54','',''),(2641,'1','303','1',1,'Retail Sale Id 2572',3600.00,0.00,0.00,5.00,350.00,'2023-02-26 12:22:22','',''),(2642,'1','303','1',1,'Retail Sale Id 2572',4320.00,0.00,0.00,6.00,420.00,'2023-02-26 12:22:22','',''),(2643,'1','303','1',1,'Retail Sale Id 2573',7920.00,0.00,0.00,11.00,770.00,'2023-02-26 12:23:48','',''),(2644,'1','303','1',1,'Retail Sale Id 2574',4320.00,0.00,0.00,6.00,420.00,'2023-02-26 12:25:13','',''),(2645,'1','303','1',1,'Retail Sale Id 2575',5520.00,0.00,0.00,8.00,320.00,'2023-02-26 12:27:24','',''),(2646,'1','303','1',1,'Retail Sale Id 2576',698.40,0.00,0.00,0.97,67.90,'2023-02-26 12:33:12','',''),(2647,'1','303','1',1,'Retail Sale Id 2577',2160.00,0.00,0.00,3.00,210.00,'2023-02-26 12:34:16','',''),(2648,'1','303','1',1,'Retail Sale Id 2578',1000.80,0.00,0.00,1.39,97.30,'2023-02-26 12:35:27','',''),(2649,'1','303','1',1,'Retail Sale Id 2579',6480.00,0.00,0.00,9.00,630.00,'2023-02-26 12:38:11','',''),(2650,'1','303','1',1,'Retail Sale Id 2580',3600.00,0.00,0.00,5.00,350.00,'2023-02-26 12:40:02','',''),(2651,'1','303','1',1,'Retail Sale Id 2581',2160.00,0.00,0.00,3.00,210.00,'2023-02-26 12:41:22','',''),(2652,'1','303','1',1,'Retail Sale Id 2582',4320.00,0.00,0.00,6.00,420.00,'2023-02-26 12:44:45','',''),(2653,'1','303','1',1,'Retail Sale Id 2582',4320.00,0.00,0.00,6.00,420.00,'2023-02-26 12:44:45','',''),(2654,'1','303','1',1,'Retail Sale Id 2583',2160.00,0.00,0.00,3.00,210.00,'2023-02-26 12:45:56','',''),(2655,'1','303','1',1,'Retail Sale Id 2584',2498.40,0.00,0.00,3.47,242.90,'2023-02-26 12:49:19','',''),(2656,'1','303','1',1,'Retail Sale Id 2585',2966.40,0.00,0.00,4.12,288.40,'2023-02-26 19:44:24','',''),(2657,'1','303','1',1,'Return of Retail Sale Id 2585',0.00,2966.40,4.12,0.00,-288.40,'2023-02-26 19:48:09','',''),(2658,'1','303','1',1,'Return of Retail Sale Id 2584',0.00,2498.40,3.47,0.00,-242.90,'2023-02-26 19:49:44','',''),(2659,'1','303','1',1,'Return of Retail Sale Id 2578',0.00,1000.80,1.39,0.00,-97.30,'2023-02-26 19:50:52','',''),(2660,'1','303','1',1,'Retail Sale Id 2586',950.40,0.00,0.00,1.32,92.40,'2023-02-26 19:51:28','',''),(2661,'1','303','1',1,'Retail Sale Id 2587',4996.80,0.00,0.00,6.94,485.80,'2023-02-27 08:17:43','',''),(2662,'1','303','1',1,'Retail Sale Id 2588',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 08:33:54','',''),(2663,'1','303','1',1,'Retail Sale Id 2589',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 08:51:56','',''),(2664,'1','303','1',1,'Retail Sale Id 2590',3600.00,0.00,0.00,5.00,350.00,'2023-02-27 09:06:23','',''),(2665,'1','303','1',1,'Retail Sale Id 2591',1000.80,0.00,0.00,1.39,97.30,'2023-02-27 09:08:50','',''),(2666,'1','303','1',1,'Retail Sale Id 2592',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 09:11:00','',''),(2667,'1','303','1',1,'Retail Sale Id 2593',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 09:13:23','',''),(2668,'1','303','1',1,'Retail Sale Id 2593',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 09:13:23','',''),(2669,'1','303','1',1,'Retail Sale Id 2594',3600.00,0.00,0.00,5.00,350.00,'2023-02-27 09:19:41','',''),(2670,'1','303','1',1,'Retail Sale Id 2595',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 09:22:09','',''),(2671,'1','303','1',1,'Retail Sale Id 2596',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 09:41:10','',''),(2672,'1','303','1',1,'Retail Sale Id 2597',698.40,0.00,0.00,0.97,67.90,'2023-02-27 09:53:19','',''),(2673,'1','303','1',1,'Retail Sale Id 2598',2001.60,0.00,0.00,2.78,194.60,'2023-02-27 09:57:46','',''),(2674,'1','303','1',1,'Retail Sale Id 2599',7920.00,0.00,0.00,11.00,770.00,'2023-02-27 09:59:50','',''),(2675,'1','303','1',1,'Retail Sale Id 2599',9000.00,0.00,0.00,12.50,875.00,'2023-02-27 09:59:50','',''),(2676,'1','303','1',1,'Retail Sale Id 2600',1440.00,0.00,0.00,2.00,140.00,'2023-02-27 10:02:01','',''),(2677,'1','303','1',1,'Retail Sale Id 2601',3600.00,0.00,0.00,5.00,350.00,'2023-02-27 10:09:20','',''),(2678,'1','303','1',1,'Retail Sale Id 2602',2001.60,0.00,0.00,2.78,194.60,'2023-02-27 10:16:43','',''),(2679,'1','303','1',1,'Retail Sale Id 2603',2152.80,0.00,0.00,2.99,209.30,'2023-02-27 10:18:24','',''),(2680,'1','303','1',1,'Retail Sale Id 2604',3600.00,0.00,0.00,5.00,350.00,'2023-02-27 10:20:39','',''),(2681,'1','303','1',1,'Retail Sale Id 2605',720.00,0.00,0.00,1.00,70.00,'2023-02-27 10:23:08','',''),(2682,'1','303','1',1,'Retail Sale Id 2606',69000.00,0.00,0.00,100.00,4000.00,'2023-02-27 10:27:48','',''),(2683,'1','303','1',1,'Retail Sale Id 2607',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 10:29:30','',''),(2684,'1','303','1',1,'Retail Sale Id 2608',7200.00,0.00,0.00,10.00,700.00,'2023-02-27 10:31:14','',''),(2685,'1','303','1',1,'Retail Sale Id 2609',2880.00,0.00,0.00,4.00,280.00,'2023-02-27 10:32:23','',''),(2686,'1','303','1',1,'Retail Sale Id 2610',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 10:33:37','',''),(2687,'1','303','1',1,'Retail Sale Id 2611',34500.00,0.00,0.00,50.00,2000.00,'2023-02-27 10:37:04','',''),(2688,'1','303','1',1,'Retail Sale Id 2612',2001.60,0.00,0.00,2.78,194.60,'2023-02-27 10:49:14','',''),(2689,'1','303','1',1,'Retail Sale Id 2613',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 11:02:23','',''),(2690,'1','303','1',1,'Retail Sale Id 2614',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 11:09:29','',''),(2691,'1','303','1',1,'Retail Sale Id 2615',3600.00,0.00,0.00,5.00,350.00,'2023-02-27 11:14:53','',''),(2692,'1','303','1',1,'Retail Sale Id 2616',3600.00,0.00,0.00,5.00,350.00,'2023-02-27 11:19:45','',''),(2693,'1','303','1',1,'Retail Sale Id 2618',1440.00,0.00,0.00,2.00,140.00,'2023-02-27 11:21:50','',''),(2694,'1','303','1',1,'Retail Sale Id 2619',7200.00,0.00,0.00,10.00,700.00,'2023-02-27 11:24:29','',''),(2695,'1','303','1',1,'Retail Sale Id 2620',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 11:25:56','',''),(2696,'1','303','1',1,'Retail Sale Id 2621',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 11:27:04','',''),(2697,'1','303','1',1,'Retail Sale Id 2622',9000.00,0.00,0.00,12.50,875.00,'2023-02-27 11:28:13','',''),(2698,'1','303','1',1,'Retail Sale Id 2623',3600.00,0.00,0.00,5.00,350.00,'2023-02-27 11:29:46','',''),(2699,'1','303','1',1,'Retail Sale Id 2624',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 11:31:14','',''),(2700,'1','303','1',1,'Retail Sale Id 2625',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 11:35:51','',''),(2701,'1','303','1',1,'Retail Sale Id 2626',2203.20,0.00,0.00,3.06,214.20,'2023-02-27 11:40:13','',''),(2702,'1','303','1',1,'Retail Sale Id 2627',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 11:42:40','',''),(2703,'1','303','1',1,'Retail Sale Id 2628',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 11:47:43','',''),(2704,'1','303','1',1,'Retail Sale Id 2628',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 11:47:43','',''),(2705,'1','303','1',1,'Retail Sale Id 2629',172500.00,0.00,0.00,250.00,10000.00,'2023-02-27 11:55:37','',''),(2706,'1','303','1',1,'Retail Sale Id 2630',138000.00,0.00,0.00,200.00,8000.00,'2023-02-27 12:01:19','',''),(2707,'1','303','1',1,'Retail Sale Id 2631',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 12:02:50','',''),(2708,'1','303','1',1,'Retail Sale Id 2632',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 12:04:19','',''),(2709,'1','303','1',1,'Retail Sale Id 2633',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 12:05:55','',''),(2710,'1','303','1',1,'Retail Sale Id 2634',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 12:07:53','',''),(2711,'1','303','1',1,'Retail Sale Id 2635',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 12:10:45','',''),(2712,'1','303','1',1,'Retail Sale Id 2636',9000.00,0.00,0.00,12.50,875.00,'2023-02-27 12:12:20','',''),(2713,'1','303','1',1,'Retail Sale Id 2637',69000.00,0.00,0.00,100.00,4000.00,'2023-02-27 12:13:36','',''),(2714,'1','303','1',1,'Retail Sale Id 2638',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 12:20:02','',''),(2715,'1','303','1',1,'Retail Sale Id 2639',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 12:27:32','',''),(2716,'1','303','1',1,'Retail Sale Id 2640',3002.40,0.00,0.00,4.17,291.90,'2023-02-27 12:35:28','',''),(2717,'1','303','1',1,'Retail Sale Id 2641',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 12:52:22','',''),(2718,'1','303','1',1,'Retail Sale Id 2641',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 12:52:22','',''),(2719,'1','303','1',1,'Retail Sale Id 2641',3600.00,0.00,0.00,5.00,350.00,'2023-02-27 12:52:22','',''),(2720,'1','303','1',1,'Retail Sale Id 2641',5760.00,0.00,0.00,8.00,560.00,'2023-02-27 12:52:22','',''),(2721,'1','303','1',1,'Retail Sale Id 2642',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 12:55:30','',''),(2722,'1','303','1',1,'Retail Sale Id 2643',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 12:58:36','',''),(2723,'1','303','1',1,'Retail Sale Id 2644',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 13:00:15','',''),(2724,'1','303','1',1,'Retail Sale Id 2645',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 13:01:36','',''),(2725,'1','303','1',1,'Retail Sale Id 2646',2001.60,0.00,0.00,2.78,194.60,'2023-02-27 13:14:52','',''),(2726,'1','303','1',1,'Retail Sale Id 2647',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 13:25:49','',''),(2727,'1','303','1',1,'Retail Sale Id 2648',2880.00,0.00,0.00,4.00,280.00,'2023-02-27 13:29:30','',''),(2728,'1','303','1',1,'Retail Sale Id 2648',9000.00,0.00,0.00,12.50,875.00,'2023-02-27 13:29:30','',''),(2729,'1','303','1',1,'Retail Sale Id 2649',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 13:37:30','',''),(2730,'1','303','1',1,'Retail Sale Id 2650',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 13:39:33','',''),(2731,'1','303','1',1,'Retail Sale Id 2651',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 13:41:10','',''),(2732,'1','303','1',1,'Return of Retail Sale Id 2649',0.00,4320.00,6.00,0.00,-420.00,'2023-02-27 13:42:47','',''),(2733,'1','303','1',1,'Retail Sale Id 2652',4500.00,0.00,0.00,6.25,437.50,'2023-02-27 13:47:28','',''),(2734,'1','303','1',1,'Retail Sale Id 2653',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 14:02:05','',''),(2735,'1','303','1',1,'Retail Sale Id 2654',9000.00,0.00,0.00,12.50,875.00,'2023-02-27 14:08:12','',''),(2736,'1','303','1',1,'Retail Sale Id 2655',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 14:12:52','',''),(2737,'1','303','1',1,'Retail Sale Id 2656',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 14:15:42','',''),(2738,'1','303','1',1,'Retail Sale Id 2657',2001.60,0.00,0.00,2.78,194.60,'2023-02-27 14:18:59','',''),(2739,'1','303','1',1,'Retail Sale Id 2658',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 14:20:31','',''),(2740,'1','303','1',1,'Retail Sale Id 2659',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 14:23:17','',''),(2741,'1','303','1',1,'Retail Sale Id 2660',1497.60,0.00,0.00,2.08,145.60,'2023-02-27 14:45:29','',''),(2742,'1','303','1',1,'Retail Sale Id 2661',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 14:49:16','',''),(2743,'1','303','1',1,'Retail Sale Id 2662',1497.60,0.00,0.00,2.08,145.60,'2023-02-27 14:58:43','',''),(2744,'1','303','1',1,'Retail Sale Id 2663',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 15:10:30','',''),(2745,'1','303','1',1,'Retail Sale Id 2664',2102.40,0.00,0.00,2.92,204.40,'2023-02-27 15:24:35','',''),(2746,'1','303','1',1,'Retail Sale Id 2665',3600.00,0.00,0.00,5.00,350.00,'2023-02-27 15:31:24','',''),(2747,'1','303','1',1,'Retail Sale Id 2666',1497.60,0.00,0.00,2.08,145.60,'2023-02-27 15:59:27','',''),(2748,'1','303','1',1,'Retail Sale Id 2667',1000.80,0.00,0.00,1.39,97.30,'2023-02-27 16:00:23','',''),(2749,'1','303','1',1,'Retail Sale Id 2668',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 16:02:39','',''),(2750,'1','303','1',1,'Retail Sale Id 2669',9000.00,0.00,0.00,12.50,875.00,'2023-02-27 16:03:34','',''),(2751,'1','303','1',1,'Retail Sale Id 2670',7200.00,0.00,0.00,10.00,700.00,'2023-02-27 16:06:24','',''),(2752,'1','303','1',1,'Retail Sale Id 2671',9000.00,0.00,0.00,12.50,875.00,'2023-02-27 16:08:03','',''),(2753,'1','303','1',1,'Retail Sale Id 2672',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 16:10:52','',''),(2754,'1','303','1',1,'Retail Sale Id 2673',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 16:19:06','',''),(2755,'1','303','1',1,'Retail Sale Id 2674',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 16:20:28','',''),(2756,'1','303','1',1,'Retail Sale Id 2675',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 16:30:00','',''),(2757,'1','303','1',1,'Retail Sale Id 2676',2901.60,0.00,0.00,4.03,282.10,'2023-02-27 16:31:11','',''),(2758,'1','303','1',1,'Retail Sale Id 2677',2203.20,0.00,0.00,3.06,214.20,'2023-02-27 16:32:03','',''),(2759,'1','303','1',1,'Retail Sale Id 2679',2001.60,0.00,0.00,2.78,194.60,'2023-02-27 16:34:10','',''),(2760,'1','303','1',1,'Retail Sale Id 2680',3600.00,0.00,0.00,5.00,350.00,'2023-02-27 16:35:03','',''),(2761,'1','303','1',1,'Retail Sale Id 2681',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 16:40:30','',''),(2762,'1','303','1',1,'Retail Sale Id 2682',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 16:42:07','',''),(2763,'1','303','1',1,'Retail Sale Id 2683',1202.40,0.00,0.00,1.67,116.90,'2023-02-27 16:44:28','',''),(2764,'1','303','1',1,'Retail Sale Id 2684',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 16:56:19','',''),(2765,'1','303','1',1,'Retail Sale Id 2685',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 17:05:23','',''),(2766,'1','303','1',1,'Retail Sale Id 2686',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 17:06:49','',''),(2767,'1','303','1',1,'Retail Sale Id 2687',5760.00,0.00,0.00,8.00,560.00,'2023-02-27 17:08:35','',''),(2768,'1','303','1',1,'Retail Sale Id 2688',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 17:19:07','',''),(2769,'1','303','1',1,'Retail Sale Id 2689',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 17:20:59','',''),(2770,'1','303','1',1,'Retail Sale Id 2690',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 17:22:44','',''),(2771,'1','303','1',1,'Retail Sale Id 2691',3600.00,0.00,0.00,5.00,350.00,'2023-02-27 17:27:17','',''),(2772,'1','303','1',1,'Retail Sale Id 2692',1440.00,0.00,0.00,2.00,140.00,'2023-02-27 17:28:56','',''),(2773,'1','303','1',1,'Retail Sale Id 2693',2880.00,0.00,0.00,4.00,280.00,'2023-02-27 17:32:10','',''),(2774,'1','303','1',1,'Retail Sale Id 2694',5040.00,0.00,0.00,7.00,490.00,'2023-02-27 17:34:11','',''),(2775,'1','303','1',1,'Retail Sale Id 2695',3600.00,0.00,0.00,5.00,350.00,'2023-02-27 17:36:06','',''),(2776,'1','303','1',1,'Retail Sale Id 2696',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 17:53:54','',''),(2777,'1','303','1',1,'Retail Sale Id 2697',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 17:59:33','',''),(2778,'1','303','1',1,'Retail Sale Id 2698',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 18:01:19','',''),(2779,'1','303','1',1,'Retail Sale Id 2699',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 18:04:42','',''),(2780,'1','303','1',1,'Retail Sale Id 2700',2160.00,0.00,0.00,3.00,210.00,'2023-02-27 18:07:29','',''),(2781,'1','303','1',1,'Retail Sale Id 2701',3600.00,0.00,0.00,5.00,350.00,'2023-02-27 18:14:38','',''),(2782,'1','303','1',1,'Retail Sale Id 2701',7200.00,0.00,0.00,10.00,700.00,'2023-02-27 18:14:38','',''),(2783,'1','303','1',1,'Retail Sale Id 2702',4320.00,0.00,0.00,6.00,420.00,'2023-02-27 18:29:33','',''),(2784,'1','303','1',1,'Retail Sale Id 2703',3600.00,0.00,0.00,5.00,350.00,'2023-02-27 18:31:46','',''),(2785,'1','303','1',1,'Retail Sale Id 2704',1670.40,0.00,0.00,2.32,162.40,'2023-02-27 19:16:23','',''),(2786,'1','303','1',1,'Retail Sale Id 2706',4852839.00,0.00,0.00,7033.10,281324.00,'2023-02-27 19:33:57','',''),(2787,'1','303','1',1,'Return of Retail Sale Id 2706',0.00,4852839.00,7033.10,0.00,-281324.00,'2023-02-27 19:34:31','',''),(2788,'1','303','1',1,'Retail Sale Id 2708',2001.00,0.00,0.00,2.90,116.00,'2023-02-27 19:42:43','',''),(2789,'1','303','1',1,'Retail Sale Id 2709',690.00,0.00,0.00,1.00,40.00,'2023-02-27 19:44:35','',''),(2790,'1','303','1',1,'Retail Sale Id 2710',4298.40,0.00,0.00,5.97,417.90,'2023-02-28 07:44:25','',''),(2791,'1','303','1',1,'Retail Sale Id 2711',3600.00,0.00,0.00,5.00,350.00,'2023-02-28 07:46:19','',''),(2792,'1','303','1',1,'Retail Sale Id 2712',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 08:05:56','',''),(2793,'1','303','1',1,'Retail Sale Id 2713',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 08:22:18','',''),(2794,'1','303','1',1,'Retail Sale Id 2714',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 08:23:56','',''),(2795,'1','303','1',1,'Retail Sale Id 2715',3600.00,0.00,0.00,5.00,350.00,'2023-02-28 08:41:27','',''),(2796,'1','303','1',1,'Retail Sale Id 2716',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 09:02:39','',''),(2797,'1','303','1',1,'Retail Sale Id 2717',103500.00,0.00,0.00,150.00,6000.00,'2023-02-28 09:13:10','',''),(2798,'1','303','1',1,'Retail Sale Id 2718',3600.00,0.00,0.00,5.00,350.00,'2023-02-28 09:15:24','',''),(2799,'1','303','1',1,'Retail Sale Id 2719',3600.00,0.00,0.00,5.00,350.00,'2023-02-28 09:17:16','',''),(2800,'1','303','1',1,'Retail Sale Id 2720',3600.00,0.00,0.00,5.00,350.00,'2023-02-28 09:18:38','',''),(2801,'1','303','1',1,'Retail Sale Id 2721',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 09:19:56','',''),(2802,'1','303','1',1,'Retail Sale Id 2722',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 09:32:07','',''),(2803,'1','303','1',1,'Retail Sale Id 2723',7920.00,0.00,0.00,11.00,770.00,'2023-02-28 09:41:46','',''),(2804,'1','303','1',1,'Retail Sale Id 2724',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 09:43:23','',''),(2805,'1','303','1',1,'Retail Sale Id 2725',4996.80,0.00,0.00,6.94,485.80,'2023-02-28 09:48:34','',''),(2806,'1','303','1',1,'Retail Sale Id 2726',3600.00,0.00,0.00,5.00,350.00,'2023-02-28 10:08:00','',''),(2807,'1','303','1',1,'Retail Sale Id 2727',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 10:17:43','',''),(2808,'1','303','1',1,'Retail Sale Id 2728',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 10:31:59','',''),(2809,'1','303','1',1,'Retail Sale Id 2729',2001.60,0.00,0.00,2.78,194.60,'2023-02-28 10:34:42','',''),(2810,'1','303','1',1,'Retail Sale Id 2730',2160.00,0.00,0.00,3.00,210.00,'2023-02-28 10:35:39','',''),(2811,'1','303','1',1,'Retail Sale Id 2731',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 10:41:05','',''),(2812,'1','303','1',1,'Retail Sale Id 2732',2160.00,0.00,0.00,3.00,210.00,'2023-02-28 10:57:44','',''),(2813,'1','303','1',1,'Retail Sale Id 2733',2160.00,0.00,0.00,3.00,210.00,'2023-02-28 11:06:47','',''),(2814,'1','303','1',1,'Retail Sale Id 2734',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 11:10:36','',''),(2815,'1','303','1',1,'Retail Sale Id 2735',9000.00,0.00,0.00,12.50,875.00,'2023-02-28 11:26:26','',''),(2816,'1','303','1',1,'Retail Sale Id 2736',8503.20,0.00,0.00,11.81,826.70,'2023-02-28 11:48:07','',''),(2817,'1','303','1',1,'Retail Sale Id 2737',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 12:03:19','',''),(2818,'1','303','1',1,'Retail Sale Id 2738',2160.00,0.00,0.00,3.00,210.00,'2023-02-28 12:05:40','',''),(2819,'1','303','1',1,'Retail Sale Id 2739',972.00,0.00,0.00,1.35,94.50,'2023-02-28 12:16:56','',''),(2820,'1','303','1',1,'Retail Sale Id 2740',7200.00,0.00,0.00,10.00,700.00,'2023-02-28 12:22:06','',''),(2821,'1','303','1',1,'Retail Sale Id 2741',5040.00,0.00,0.00,7.00,490.00,'2023-02-28 12:37:54','',''),(2822,'1','303','1',1,'Retail Sale Id 2742',1000.80,0.00,0.00,1.39,97.30,'2023-02-28 12:39:25','',''),(2823,'1','303','1',1,'Retail Sale Id 2743',3600.00,0.00,0.00,5.00,350.00,'2023-02-28 12:42:41','',''),(2824,'1','303','1',1,'Retail Sale Id 2744',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 12:51:29','',''),(2825,'1','303','1',1,'Retail Sale Id 2745',3600.00,0.00,0.00,5.00,350.00,'2023-02-28 12:53:43','',''),(2826,'1','303','1',1,'Retail Sale Id 2746',3600.00,0.00,0.00,5.00,350.00,'2023-02-28 13:02:10','',''),(2827,'1','303','1',1,'Retail Sale Id 2747',2160.00,0.00,0.00,3.00,210.00,'2023-02-28 13:03:36','',''),(2828,'1','303','1',1,'Retail Sale Id 2748',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 13:26:07','',''),(2829,'1','303','1',1,'Retail Sale Id 2750',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 13:29:17','',''),(2830,'1','303','1',1,'Retail Sale Id 2751',2160.00,0.00,0.00,3.00,210.00,'2023-02-28 13:30:32','',''),(2831,'1','303','1',1,'Retail Sale Id 2752',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 13:31:58','',''),(2832,'1','303','1',1,'Retail Sale Id 2753',9000.00,0.00,0.00,12.50,875.00,'2023-02-28 13:47:50','',''),(2833,'1','303','1',1,'Retail Sale Id 2754',1000.80,0.00,0.00,1.39,97.30,'2023-02-28 13:50:45','',''),(2834,'1','303','1',1,'Retail Sale Id 2755',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 13:55:28','',''),(2835,'1','303','1',1,'Retail Sale Id 2756',2160.00,0.00,0.00,3.00,210.00,'2023-02-28 13:57:37','',''),(2836,'1','303','1',1,'Retail Sale Id 2757',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 13:59:34','',''),(2837,'1','303','1',1,'Retail Sale Id 2758',9000.00,0.00,0.00,12.50,875.00,'2023-02-28 14:02:39','',''),(2838,'1','303','1',1,'Retail Sale Id 2759',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 14:04:49','',''),(2839,'1','303','1',1,'Retail Sale Id 2760',3002.40,0.00,0.00,4.17,291.90,'2023-02-28 14:07:17','',''),(2840,'1','303','1',1,'Retail Sale Id 2761',1000.80,0.00,0.00,1.39,97.30,'2023-02-28 14:09:46','',''),(2841,'1','303','1',1,'Retail Sale Id 2762',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 14:18:57','',''),(2842,'1','303','1',1,'Retail Sale Id 2763',9000.00,0.00,0.00,12.50,875.00,'2023-02-28 14:22:19','',''),(2843,'1','303','1',1,'Retail Sale Id 2764',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 14:24:44','',''),(2844,'1','303','1',1,'Retail Sale Id 2765',2160.00,0.00,0.00,3.00,210.00,'2023-02-28 14:26:20','',''),(2845,'1','303','1',1,'Retail Sale Id 2766',3600.00,0.00,0.00,5.00,350.00,'2023-02-28 15:08:40','',''),(2846,'1','303','1',1,'Retail Sale Id 2767',6480.00,0.00,0.00,9.00,630.00,'2023-02-28 15:11:11','',''),(2847,'1','303','1',1,'Retail Sale Id 2768',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 15:14:16','',''),(2848,'1','303','1',1,'Retail Sale Id 2769',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 15:16:17','',''),(2849,'1','303','1',1,'Retail Sale Id 2770',3499.20,0.00,0.00,4.86,340.20,'2023-02-28 15:49:45','',''),(2850,'1','303','1',1,'Retail Sale Id 2771',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 15:56:45','',''),(2851,'1','303','1',1,'Retail Sale Id 2772',720.00,0.00,0.00,1.00,70.00,'2023-02-28 16:07:58','',''),(2852,'1','303','1',1,'Retail Sale Id 2773',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 16:13:35','',''),(2853,'1','303','1',1,'Retail Sale Id 2774',1440.00,0.00,0.00,2.00,140.00,'2023-02-28 16:25:54','',''),(2854,'1','303','1',1,'Retail Sale Id 2775',9000.00,0.00,0.00,12.50,875.00,'2023-02-28 16:36:53','',''),(2855,'1','303','1',1,'Retail Sale Id 2776',2203.20,0.00,0.00,3.06,214.20,'2023-02-28 16:48:20','',''),(2856,'1','303','1',1,'Retail Sale Id 2777',1000.80,0.00,0.00,1.39,97.30,'2023-02-28 16:49:22','',''),(2857,'1','303','1',1,'Retail Sale Id 2778',3600.00,0.00,0.00,5.00,350.00,'2023-02-28 17:00:37','',''),(2858,'1','303','1',1,'Retail Sale Id 2779',3600.00,0.00,0.00,5.00,350.00,'2023-02-28 17:03:42','',''),(2859,'1','303','1',1,'Retail Sale Id 2780',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 17:05:35','',''),(2860,'1','303','1',1,'Retail Sale Id 2781',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 17:07:14','',''),(2861,'1','303','1',1,'Retail Sale Id 2782',2160.00,0.00,0.00,3.00,210.00,'2023-02-28 17:11:09','',''),(2862,'1','303','1',1,'Retail Sale Id 2783',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 17:18:17','',''),(2863,'1','303','1',1,'Retail Sale Id 2784',4298.40,0.00,0.00,5.97,417.90,'2023-02-28 17:19:39','',''),(2864,'1','303','1',1,'Retail Sale Id 2785',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 17:23:27','',''),(2865,'1','303','1',1,'Retail Sale Id 2786',2160.00,0.00,0.00,3.00,210.00,'2023-02-28 17:24:17','',''),(2866,'1','303','1',1,'Retail Sale Id 2787',2880.00,0.00,0.00,4.00,280.00,'2023-02-28 17:25:59','',''),(2867,'1','303','1',1,'Retail Sale Id 2788',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 17:28:11','',''),(2868,'1','303','1',1,'Retail Sale Id 2789',7920.00,0.00,0.00,11.00,770.00,'2023-02-28 17:30:20','',''),(2869,'1','303','1',1,'Retail Sale Id 2790',11160.00,0.00,0.00,15.50,1085.00,'2023-02-28 17:33:09','',''),(2870,'1','303','1',1,'Retail Sale Id 2791',9000.00,0.00,0.00,12.50,875.00,'2023-02-28 17:35:43','',''),(2871,'1','303','1',1,'Retail Sale Id 2792',2160.00,0.00,0.00,3.00,210.00,'2023-02-28 17:37:40','',''),(2872,'1','303','1',1,'Retail Sale Id 2793',2880.00,0.00,0.00,4.00,280.00,'2023-02-28 17:39:29','',''),(2873,'1','303','1',1,'Retail Sale Id 2794',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 17:44:49','',''),(2874,'1','303','1',1,'Retail Sale Id 2795',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 17:51:03','',''),(2875,'1','303','1',1,'Retail Sale Id 2796',4320.00,0.00,0.00,6.00,420.00,'2023-02-28 18:05:42','',''),(2876,'1','303','1',1,'Retail Sale Id 2797',9000.00,0.00,0.00,12.50,875.00,'2023-02-28 18:07:46','',''),(2877,'1','303','1',1,'Retail Sale Id 2798',799.20,0.00,0.00,1.11,77.70,'2023-02-28 18:14:11','',''),(2878,'1','303','1',1,'Retail Sale Id 2799',9000.00,0.00,0.00,12.50,875.00,'2023-02-28 18:16:21','',''),(2879,'1','303','1',1,'Retail Sale Id 2800',1497.60,0.00,0.00,2.08,145.60,'2023-02-28 18:17:38','',''),(2880,'1','303','1',1,'Retail Sale Id 2801',1440.00,0.00,0.00,2.00,140.00,'2023-03-02 07:54:22','',''),(2881,'1','303','1',1,'Retail Sale Id 2802',9000.00,0.00,0.00,12.50,875.00,'2023-03-02 08:18:26','',''),(2882,'1','303','1',1,'Retail Sale Id 2803',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 08:20:33','',''),(2883,'1','303','1',1,'Retail Sale Id 2804',5040.00,0.00,0.00,7.00,490.00,'2023-03-02 08:44:14','',''),(2884,'1','303','1',1,'Retail Sale Id 2805',1440.00,0.00,0.00,2.00,140.00,'2023-03-02 08:48:35','',''),(2885,'1','303','1',1,'Retail Sale Id 2806',3002.40,0.00,0.00,4.17,291.90,'2023-03-02 08:49:52','',''),(2886,'1','303','1',1,'Retail Sale Id 2807',2160.00,0.00,0.00,3.00,210.00,'2023-03-02 08:50:40','',''),(2887,'1','303','1',1,'Retail Sale Id 2808',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 08:56:58','',''),(2888,'1','303','1',1,'Retail Sale Id 2809',2001.60,0.00,0.00,2.78,194.60,'2023-03-02 09:13:27','',''),(2889,'1','303','1',1,'Retail Sale Id 2810',9000.00,0.00,0.00,12.50,875.00,'2023-03-02 09:17:00','',''),(2890,'1','303','1',1,'Retail Sale Id 2811',5760.00,0.00,0.00,8.00,560.00,'2023-03-02 09:28:12','',''),(2891,'1','303','1',1,'Retail Sale Id 2812',2001.60,0.00,0.00,2.78,194.60,'2023-03-02 09:34:13','',''),(2892,'1','303','1',1,'Retail Sale Id 2813',2001.60,0.00,0.00,2.78,194.60,'2023-03-02 09:40:07','',''),(2893,'1','303','1',1,'Retail Sale Id 2814',2160.00,0.00,0.00,3.00,210.00,'2023-03-02 09:46:45','',''),(2894,'1','303','1',1,'Retail Sale Id 2815',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 09:47:37','',''),(2895,'1','303','1',1,'Retail Sale Id 2816',103500.00,0.00,0.00,150.00,6000.00,'2023-03-02 09:49:25','',''),(2896,'1','303','1',1,'Retail Sale Id 2817',3240.00,0.00,0.00,4.50,315.00,'2023-03-02 09:52:56','',''),(2897,'1','303','1',1,'Retail Sale Id 2818',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 09:54:28','',''),(2898,'1','303','1',1,'Retail Sale Id 2819',5040.00,0.00,0.00,7.00,490.00,'2023-03-02 09:58:50','',''),(2899,'1','303','1',1,'Retail Sale Id 2820',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 10:07:13','',''),(2900,'1','303','1',1,'Retail Sale Id 2821',5760.00,0.00,0.00,8.00,560.00,'2023-03-02 10:12:31','',''),(2901,'1','303','1',1,'Retail Sale Id 2822',34500.00,0.00,0.00,50.00,2000.00,'2023-03-02 10:14:28','',''),(2902,'1','303','1',1,'Retail Sale Id 2823',2880.00,0.00,0.00,4.00,280.00,'2023-03-02 10:17:27','',''),(2903,'1','303','1',1,'Retail Sale Id 2824',3600.00,0.00,0.00,5.00,350.00,'2023-03-02 10:21:15','',''),(2904,'1','303','1',1,'Retail Sale Id 2824',3600.00,0.00,0.00,5.00,350.00,'2023-03-02 10:21:15','',''),(2905,'1','303','1',1,'Retail Sale Id 2825',2203.20,0.00,0.00,3.06,214.20,'2023-03-02 10:37:41','',''),(2906,'1','303','1',1,'Retail Sale Id 2826',4003.20,0.00,0.00,5.56,389.20,'2023-03-02 10:41:40','',''),(2907,'1','303','1',1,'Retail Sale Id 2827',69000.00,0.00,0.00,100.00,4000.00,'2023-03-02 10:44:26','',''),(2908,'1','303','1',1,'Retail Sale Id 2828',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 10:46:27','',''),(2909,'1','303','1',1,'Retail Sale Id 2829',1000.80,0.00,0.00,1.39,97.30,'2023-03-02 10:49:34','',''),(2910,'1','303','1',1,'Retail Sale Id 2830',2160.00,0.00,0.00,3.00,210.00,'2023-03-02 10:53:37','',''),(2911,'1','303','1',1,'Retail Sale Id 2831',9000.00,0.00,0.00,12.50,875.00,'2023-03-02 10:57:16','',''),(2912,'1','303','1',1,'Retail Sale Id 2832',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 10:59:31','',''),(2913,'1','303','1',1,'Retail Sale Id 2833',2880.00,0.00,0.00,4.00,280.00,'2023-03-02 11:14:05','',''),(2914,'1','303','1',1,'Retail Sale Id 2834',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 11:15:13','',''),(2915,'1','303','1',1,'Retail Sale Id 2835',4003.20,0.00,0.00,5.56,389.20,'2023-03-02 11:16:59','',''),(2916,'1','303','1',1,'Retail Sale Id 2836',9000.00,0.00,0.00,12.50,875.00,'2023-03-02 11:19:36','',''),(2917,'1','303','1',1,'Retail Sale Id 2837',2160.00,0.00,0.00,3.00,210.00,'2023-03-02 11:30:49','',''),(2918,'1','303','1',1,'Retail Sale Id 2838',1440.00,0.00,0.00,2.00,140.00,'2023-03-02 11:41:38','',''),(2919,'1','303','1',1,'Retail Sale Id 2840',9000.00,0.00,0.00,12.50,875.00,'2023-03-02 11:46:56','',''),(2920,'1','303','1',1,'Retail Sale Id 2841',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 11:48:21','',''),(2921,'1','303','1',1,'Retail Sale Id 2842',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 11:54:31','',''),(2922,'1','303','1',1,'Retail Sale Id 2843',2160.00,0.00,0.00,3.00,210.00,'2023-03-02 12:00:42','',''),(2923,'1','303','1',1,'Retail Sale Id 2844',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 12:02:18','',''),(2924,'1','303','1',1,'Retail Sale Id 2845',4298.40,0.00,0.00,5.97,417.90,'2023-03-02 12:03:36','',''),(2925,'1','303','1',1,'Retail Sale Id 2846',2160.00,0.00,0.00,3.00,210.00,'2023-03-02 12:06:39','',''),(2926,'1','303','1',1,'Retail Sale Id 2846',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 12:06:39','',''),(2927,'1','303','1',1,'Retail Sale Id 2847',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 12:12:32','',''),(2928,'1','303','1',1,'Retail Sale Id 2848',9000.00,0.00,0.00,12.50,875.00,'2023-03-02 12:14:26','',''),(2929,'1','303','1',1,'Retail Sale Id 2849',9000.00,0.00,0.00,12.50,875.00,'2023-03-02 12:16:39','',''),(2930,'1','303','1',1,'Retail Sale Id 2850',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 12:21:02','',''),(2931,'1','303','1',1,'Retail Sale Id 2851',9000.00,0.00,0.00,12.50,875.00,'2023-03-02 12:28:07','',''),(2932,'1','303','1',1,'Retail Sale Id 2852',34500.00,0.00,0.00,50.00,2000.00,'2023-03-02 12:30:17','',''),(2933,'1','303','1',1,'Retail Sale Id 2853',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 12:32:11','',''),(2934,'1','303','1',1,'Retail Sale Id 2854',3600.00,0.00,0.00,5.00,350.00,'2023-03-02 12:41:22','',''),(2935,'1','303','1',1,'Retail Sale Id 2855',2160.00,0.00,0.00,3.00,210.00,'2023-03-02 12:45:09','',''),(2936,'1','303','1',1,'Retail Sale Id 2856',496.80,0.00,0.00,0.69,48.30,'2023-03-02 12:46:13','',''),(2937,'1','303','1',1,'Retail Sale Id 2857',2203.20,0.00,0.00,3.06,214.20,'2023-03-02 12:48:00','',''),(2938,'1','303','1',1,'Retail Sale Id 2858',2160.00,0.00,0.00,3.00,210.00,'2023-03-02 12:56:36','',''),(2939,'1','303','1',1,'Retail Sale Id 2859',3002.40,0.00,0.00,4.17,291.90,'2023-03-02 13:15:49','',''),(2940,'1','303','1',1,'Retail Sale Id 2860',3600.00,0.00,0.00,5.00,350.00,'2023-03-02 13:20:35','',''),(2941,'1','303','1',1,'Retail Sale Id 2860',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 13:20:35','',''),(2942,'1','303','1',1,'Retail Sale Id 2861',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 13:23:54','',''),(2943,'1','303','1',1,'Retail Sale Id 2861',9000.00,0.00,0.00,12.50,875.00,'2023-03-02 13:23:54','',''),(2944,'1','303','1',1,'Retail Sale Id 2862',2160.00,0.00,0.00,3.00,210.00,'2023-03-02 13:26:05','',''),(2945,'1','303','1',1,'Retail Sale Id 2863',34500.00,0.00,0.00,50.00,2000.00,'2023-03-02 13:28:14','',''),(2946,'1','303','1',1,'Retail Sale Id 2864',34500.00,0.00,0.00,50.00,2000.00,'2023-03-02 13:30:26','',''),(2947,'1','303','1',1,'Retail Sale Id 2865',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 13:32:14','',''),(2948,'1','303','1',1,'Retail Sale Id 2866',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 13:41:20','',''),(2949,'1','303','1',1,'Retail Sale Id 2867',2160.00,0.00,0.00,3.00,210.00,'2023-03-02 13:43:18','',''),(2950,'1','303','1',1,'Retail Sale Id 2869',2160.00,0.00,0.00,3.00,210.00,'2023-03-02 14:13:04','',''),(2951,'1','303','1',1,'Retail Sale Id 2871',2160.00,0.00,0.00,3.00,210.00,'2023-03-02 14:42:41','',''),(2952,'1','303','1',1,'Retail Sale Id 2872',16001.10,0.00,0.00,23.19,927.60,'2023-03-02 14:44:26','',''),(2953,'1','303','1',1,'Retail Sale Id 2873',1000.80,0.00,0.00,1.39,97.30,'2023-03-02 14:55:48','',''),(2954,'1','303','1',1,'Retail Sale Id 2874',2160.00,0.00,0.00,3.00,210.00,'2023-03-02 15:18:19','',''),(2955,'1','303','1',1,'Retail Sale Id 2875',3600.00,0.00,0.00,5.00,350.00,'2023-03-02 15:40:36','',''),(2956,'1','303','1',1,'Retail Sale Id 2876',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 15:43:37','',''),(2957,'1','303','1',1,'Retail Sale Id 2877',9000.00,0.00,0.00,12.50,875.00,'2023-03-02 15:47:04','',''),(2958,'1','303','1',1,'Retail Sale Id 2877',9000.00,0.00,0.00,12.50,875.00,'2023-03-02 15:47:04','',''),(2959,'1','303','1',1,'Retail Sale Id 2878',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 15:53:40','',''),(2960,'1','303','1',1,'Retail Sale Id 2880',9000.00,0.00,0.00,12.50,875.00,'2023-03-02 15:57:46','',''),(2961,'1','303','1',1,'Retail Sale Id 2881',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 15:59:47','',''),(2962,'1','303','1',1,'Retail Sale Id 2882',2160.00,0.00,0.00,3.00,210.00,'2023-03-02 16:02:16','',''),(2963,'1','303','1',1,'Retail Sale Id 2882',3600.00,0.00,0.00,5.00,350.00,'2023-03-02 16:02:16','',''),(2964,'1','303','1',1,'Retail Sale Id 2883',6480.00,0.00,0.00,9.00,630.00,'2023-03-02 16:06:56','',''),(2965,'1','303','1',1,'Retail Sale Id 2884',1000.80,0.00,0.00,1.39,97.30,'2023-03-02 16:18:15','',''),(2966,'1','303','1',1,'Retail Sale Id 2885',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 16:31:43','',''),(2967,'1','303','1',1,'Retail Sale Id 2886',1000.80,0.00,0.00,1.39,97.30,'2023-03-02 16:34:08','',''),(2968,'1','303','1',1,'Retail Sale Id 2887',9000.00,0.00,0.00,12.50,875.00,'2023-03-02 16:35:53','',''),(2969,'1','303','1',1,'Retail Sale Id 2888',414000.00,0.00,0.00,600.00,24000.00,'2023-03-02 16:39:44','',''),(2970,'1','303','1',1,'Retail Sale Id 2890',3600.00,0.00,0.00,5.00,350.00,'2023-03-02 16:42:10','',''),(2971,'1','303','1',1,'Retail Sale Id 2891',2203.20,0.00,0.00,3.06,214.20,'2023-03-02 16:43:29','',''),(2972,'1','303','1',1,'Retail Sale Id 2892',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 16:44:36','',''),(2973,'1','303','1',1,'Retail Sale Id 2893',3600.00,0.00,0.00,5.00,350.00,'2023-03-02 16:46:47','',''),(2974,'1','303','1',1,'Retail Sale Id 2893',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 16:46:47','',''),(2975,'1','303','1',1,'Retail Sale Id 2894',2160.00,0.00,0.00,3.00,210.00,'2023-03-02 16:50:13','',''),(2976,'1','303','1',1,'Retail Sale Id 2894',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 16:50:13','',''),(2977,'1','303','1',1,'Retail Sale Id 2895',2001.60,0.00,0.00,2.78,194.60,'2023-03-02 16:51:14','',''),(2978,'1','303','1',1,'Retail Sale Id 2896',3600.00,0.00,0.00,5.00,350.00,'2023-03-02 16:52:11','',''),(2979,'1','303','1',1,'Retail Sale Id 2897',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 16:53:08','',''),(2980,'1','303','1',1,'Retail Sale Id 2898',9000.00,0.00,0.00,12.50,875.00,'2023-03-02 16:56:19','',''),(2981,'1','303','1',1,'Retail Sale Id 2899',1497.60,0.00,0.00,2.08,145.60,'2023-03-02 16:58:01','',''),(2982,'1','303','1',1,'Retail Sale Id 2900',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 17:06:41','',''),(2983,'1','303','1',1,'Retail Sale Id 2901',2880.00,0.00,0.00,4.00,280.00,'2023-03-02 17:08:56','',''),(2984,'1','303','1',1,'Retail Sale Id 2902',1000.80,0.00,0.00,1.39,97.30,'2023-03-02 17:10:58','',''),(2985,'1','303','1',1,'Retail Sale Id 2903',2001.60,0.00,0.00,2.78,194.60,'2023-03-02 17:15:41','',''),(2986,'1','303','1',1,'Retail Sale Id 2904',2160.00,0.00,0.00,3.00,210.00,'2023-03-02 17:19:17','',''),(2987,'1','303','1',1,'Retail Sale Id 2905',3002.40,0.00,0.00,4.17,291.90,'2023-03-02 17:22:13','',''),(2988,'1','303','1',1,'Retail Sale Id 2906',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 17:23:00','',''),(2989,'1','303','1',1,'Retail Sale Id 2907',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 17:25:53','',''),(2990,'1','303','1',1,'Retail Sale Id 2908',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 17:28:02','',''),(2991,'1','303','1',1,'Retail Sale Id 2908',9000.00,0.00,0.00,12.50,875.00,'2023-03-02 17:28:02','',''),(2992,'1','303','1',1,'Retail Sale Id 2909',2160.00,0.00,0.00,3.00,210.00,'2023-03-02 17:30:12','',''),(2993,'1','303','1',1,'Retail Sale Id 2910',4320.00,0.00,0.00,6.00,420.00,'2023-03-02 17:32:17','',''),(2994,'1','303','1',1,'Return of Retail Sale Id 2910',0.00,4320.00,6.00,0.00,-420.00,'2023-03-02 17:33:52','',''),(2995,'1','303','1',1,'Retail Sale Id 2911',1440.00,0.00,0.00,2.00,140.00,'2023-03-02 17:34:52','',''),(2996,'1','303','1',1,'Retail Sale Id 2911',2001.60,0.00,0.00,2.78,194.60,'2023-03-02 17:34:52','',''),(2997,'1','303','1',1,'Retail Sale Id 2912',2160.00,0.00,0.00,3.00,210.00,'2023-03-02 17:39:22','',''),(2998,'1','303','1',1,'Retail Sale Id 2913',2397.60,0.00,0.00,3.33,233.10,'2023-03-02 17:45:17','',''),(2999,'1','303','1',1,'Retail Sale Id 2914',1497.60,0.00,0.00,2.08,145.60,'2023-03-02 17:52:20','',''),(3000,'1','303','1',1,'Retail Sale Id 2915',2160.00,0.00,0.00,3.00,210.00,'2023-03-02 17:54:28','',''),(3001,'1','303','1',1,'Retail Sale Id 2916',2203.20,0.00,0.00,3.06,214.20,'2023-03-02 17:56:55','',''),(3002,'1','303','1',1,'Retail Sale Id 2917',3002.40,0.00,0.00,4.17,291.90,'2023-03-02 17:58:29','',''),(3003,'1','303','1',1,'Retail Sale Id 2918',3600.00,0.00,0.00,5.00,350.00,'2023-03-02 17:59:38','',''),(3004,'1','303','1',1,'Retail Sale Id 2919',799.20,0.00,0.00,1.11,77.70,'2023-03-02 18:01:49','',''),(3005,'1','303','1',1,'Retail Sale Id 2920',13320.00,0.00,0.00,18.50,1295.00,'2023-03-02 18:02:56','',''),(3006,'1','303','1',1,'Retail Sale Id 2921',9000.00,0.00,0.00,12.50,875.00,'2023-03-02 18:05:25','',''),(3007,'1','303','1',1,'Retail Sale Id 2922',9000.00,0.00,0.00,12.50,875.00,'2023-03-02 18:08:17','',''),(3008,'1','303','1',1,'Retail Sale Id 2923',1000.80,0.00,0.00,1.39,97.30,'2023-03-02 18:09:11','',''),(3009,'1','303','1',1,'Retail Sale Id 2924',2160.00,0.00,0.00,3.00,210.00,'2023-03-02 18:12:32','',''),(3010,'1','303','1',1,'Retail Sale Id 2925',2160.00,0.00,0.00,3.00,210.00,'2023-03-02 18:18:28','',''),(3011,'1','303','1',1,'Retail Sale Id 2926',698.40,0.00,0.00,0.97,67.90,'2023-03-02 18:20:42','',''),(3012,'1','303','1',1,'Return of Retail Sale Id 2926',0.00,698.40,0.97,0.00,-67.90,'2023-03-02 18:46:40','',''),(3013,'1','303','1',1,'Return of Retail Sale Id 2923',0.00,1000.80,1.39,0.00,-97.30,'2023-03-02 18:59:40','',''),(3014,'1','303','1',1,'Retail Sale Id 2927',633.60,0.00,0.00,0.88,61.60,'2023-03-02 19:00:37','',''),(3015,'1','303','1',1,'Retail Sale Id 2928',9000.00,0.00,0.00,12.50,875.00,'2023-03-03 07:47:03','',''),(3016,'1','303','1',1,'Retail Sale Id 2929',2160.00,0.00,0.00,3.00,210.00,'2023-03-03 07:49:02','',''),(3017,'1','303','1',1,'Retail Sale Id 2929',4320.00,0.00,0.00,6.00,420.00,'2023-03-03 07:49:02','',''),(3018,'1','303','1',1,'Retail Sale Id 2930',1000.80,0.00,0.00,1.39,97.30,'2023-03-03 08:12:26','',''),(3019,'1','303','1',1,'Retail Sale Id 2931',2001.60,0.00,0.00,2.78,194.60,'2023-03-03 08:17:57','',''),(3020,'1','303','1',1,'Retail Sale Id 2932',3002.40,0.00,0.00,4.17,291.90,'2023-03-03 08:19:36','',''),(3021,'1','303','1',1,'Retail Sale Id 2933',4320.00,0.00,0.00,6.00,420.00,'2023-03-03 08:42:03','',''),(3022,'1','303','1',1,'Retail Sale Id 2934',3600.00,0.00,0.00,5.00,350.00,'2023-03-03 08:48:41','',''),(3023,'1','303','1',1,'Retail Sale Id 2935',2001.60,0.00,0.00,2.78,194.60,'2023-03-03 08:53:09','',''),(3024,'1','303','1',1,'Retail Sale Id 2936',2160.00,0.00,0.00,3.00,210.00,'2023-03-03 08:57:59','',''),(3025,'1','303','1',1,'Retail Sale Id 2936',3600.00,0.00,0.00,5.00,350.00,'2023-03-03 08:57:59','',''),(3026,'1','303','1',1,'Retail Sale Id 2937',4320.00,0.00,0.00,6.00,420.00,'2023-03-03 09:00:06','',''),(3027,'1','303','1',1,'Retail Sale Id 2938',2203.20,0.00,0.00,3.06,214.20,'2023-03-03 09:12:13','',''),(3028,'1','303','1',1,'Retail Sale Id 2939',2001.60,0.00,0.00,2.78,194.60,'2023-03-03 09:40:43','',''),(3029,'1','303','1',1,'Retail Sale Id 2940',2160.00,0.00,0.00,3.00,210.00,'2023-03-03 09:45:37','',''),(3030,'1','303','1',1,'Retail Sale Id 2941',4320.00,0.00,0.00,6.00,420.00,'2023-03-03 09:48:31','',''),(3031,'1','303','1',1,'Retail Sale Id 2942',2160.00,0.00,0.00,3.00,210.00,'2023-03-03 09:49:55','',''),(3032,'1','303','1',1,'Retail Sale Id 2943',4320.00,0.00,0.00,6.00,420.00,'2023-03-03 10:01:11','',''),(3033,'1','303','1',1,'Retail Sale Id 2944',9000.00,0.00,0.00,12.50,875.00,'2023-03-03 10:14:37','',''),(3034,'1','303','1',1,'Retail Sale Id 2945',2160.00,0.00,0.00,3.00,210.00,'2023-03-03 10:17:26','',''),(3035,'1','303','1',1,'Retail Sale Id 2946',1000.80,0.00,0.00,1.39,97.30,'2023-03-03 10:29:41','',''),(3036,'1','303','1',1,'Retail Sale Id 2947',34500.00,0.00,0.00,50.00,2000.00,'2023-03-03 10:38:12','',''),(3037,'1','303','1',1,'Retail Sale Id 2948',7999.20,0.00,0.00,11.11,777.70,'2023-03-03 10:46:58','',''),(3038,'1','303','1',1,'Retail Sale Id 2949',1000.80,0.00,0.00,1.39,97.30,'2023-03-03 10:48:24','',''),(3039,'1','303','1',1,'Retail Sale Id 2950',4320.00,0.00,0.00,6.00,420.00,'2023-03-03 10:53:41','',''),(3040,'1','303','1',1,'Retail Sale Id 2951',4320.00,0.00,0.00,6.00,420.00,'2023-03-03 11:04:46','',''),(3041,'1','303','1',1,'Retail Sale Id 2952',2498.40,0.00,0.00,3.47,242.90,'2023-03-03 12:14:20','',''),(3042,'1','303','1',1,'Retail Sale Id 2954',1497.60,0.00,0.00,2.08,145.60,'2023-03-03 13:26:39','',''),(3043,'1','303','1',1,'Retail Sale Id 2955',4320.00,0.00,0.00,6.00,420.00,'2023-03-03 13:28:05','',''),(3044,'1','303','1',1,'Retail Sale Id 2956',1000.80,0.00,0.00,1.39,97.30,'2023-03-03 13:28:52','',''),(3045,'1','303','1',1,'Retail Sale Id 2957',34500.00,0.00,0.00,50.00,2000.00,'2023-03-03 13:30:07','',''),(3046,'1','303','1',1,'Retail Sale Id 2958',2880.00,0.00,0.00,4.00,280.00,'2023-03-03 13:31:10','',''),(3047,'1','303','1',1,'Retail Sale Id 2959',4003.20,0.00,0.00,5.56,389.20,'2023-03-03 13:32:06','',''),(3048,'1','303','1',1,'Retail Sale Id 2960',4320.00,0.00,0.00,6.00,420.00,'2023-03-03 13:33:04','',''),(3049,'1','303','1',1,'Retail Sale Id 2961',2001.60,0.00,0.00,2.78,194.60,'2023-03-03 13:33:55','',''),(3050,'1','303','1',1,'Retail Sale Id 2962',9000.00,0.00,0.00,12.50,875.00,'2023-03-03 13:35:04','',''),(3051,'1','303','1',1,'Retail Sale Id 2963',3600.00,0.00,0.00,5.00,350.00,'2023-03-03 13:37:02','',''),(3052,'1','303','1',1,'Retail Sale Id 2963',7200.00,0.00,0.00,10.00,700.00,'2023-03-03 13:37:02','',''),(3053,'1','303','1',1,'Retail Sale Id 2964',4320.00,0.00,0.00,6.00,420.00,'2023-03-03 13:37:56','',''),(3054,'1','303','1',1,'Retail Sale Id 2965',4320.00,0.00,0.00,6.00,420.00,'2023-03-03 13:38:43','',''),(3055,'1','303','1',1,'Retail Sale Id 2966',9000.00,0.00,0.00,12.50,875.00,'2023-03-03 13:39:37','',''),(3056,'1','303','1',1,'Retail Sale Id 2967',4320.00,0.00,0.00,6.00,420.00,'2023-03-03 13:40:45','',''),(3057,'1','303','1',1,'Retail Sale Id 2968',2203.20,0.00,0.00,3.06,214.20,'2023-03-03 17:09:28','',''),(3058,'1','303','1',1,'Retail Sale Id 2969',2001.60,0.00,0.00,2.78,194.60,'2023-03-03 17:10:52','',''),(3059,'1','303','1',1,'Retail Sale Id 2971',3600.00,0.00,0.00,5.00,350.00,'2023-03-03 17:12:51','',''),(3060,'1','303','1',1,'Retail Sale Id 2971',4320.00,0.00,0.00,6.00,420.00,'2023-03-03 17:12:51','',''),(3061,'1','303','1',1,'Retail Sale Id 2972',9000.00,0.00,0.00,12.50,875.00,'2023-03-03 17:13:56','',''),(3062,'1','303','1',1,'Retail Sale Id 2973',1000.80,0.00,0.00,1.39,97.30,'2023-03-03 17:15:00','',''),(3063,'1','303','1',1,'Retail Sale Id 2974',2160.00,0.00,0.00,3.00,210.00,'2023-03-03 17:16:25','',''),(3064,'1','303','1',1,'Retail Sale Id 2975',2160.00,0.00,0.00,3.00,210.00,'2023-03-03 17:21:49','',''),(3065,'1','303','1',1,'Retail Sale Id 2976',1440.00,0.00,0.00,2.00,140.00,'2023-03-03 17:24:57','',''),(3066,'1','303','1',1,'Retail Sale Id 2977',2160.00,0.00,0.00,3.00,210.00,'2023-03-03 18:50:46','',''),(3067,'1','303','1',1,'Retail Sale Id 2978',4320.00,0.00,0.00,6.00,420.00,'2023-03-03 18:52:03','',''),(3068,'1','303','1',1,'Retail Sale Id 2979',4320.00,0.00,0.00,6.00,420.00,'2023-03-03 18:53:01','',''),(3069,'1','303','1',1,'Retail Sale Id 2980',2160.00,0.00,0.00,3.00,210.00,'2023-03-03 18:53:52','',''),(3070,'1','303','1',1,'Retail Sale Id 2981',2160.00,0.00,0.00,3.00,210.00,'2023-03-03 18:54:48','',''),(3071,'1','303','1',1,'Retail Sale Id 2982',3002.40,0.00,0.00,4.17,291.90,'2023-03-03 18:55:49','',''),(3072,'1','303','1',1,'Retail Sale Id 2983',3002.40,0.00,0.00,4.17,291.90,'2023-03-03 18:56:44','',''),(3073,'1','303','1',1,'Retail Sale Id 2984',2160.00,0.00,0.00,3.00,210.00,'2023-03-03 18:58:02','',''),(3074,'1','303','1',1,'Retail Sale Id 2984',3600.00,0.00,0.00,5.00,350.00,'2023-03-03 18:58:02','',''),(3075,'1','303','1',1,'Retail Sale Id 2985',4320.00,0.00,0.00,6.00,420.00,'2023-03-03 18:58:58','',''),(3076,'1','303','1',1,'Retail Sale Id 2986',4320.00,0.00,0.00,6.00,420.00,'2023-03-03 19:00:11','',''),(3077,'1','303','1',1,'Retail Sale Id 2987',9000.00,0.00,0.00,12.50,875.00,'2023-03-03 19:01:07','',''),(3078,'1','303','1',1,'Retail Sale Id 2988',4320.00,0.00,0.00,6.00,420.00,'2023-03-03 19:02:16','',''),(3079,'1','303','1',1,'Retail Sale Id 2989',4320.00,0.00,0.00,6.00,420.00,'2023-03-03 19:03:00','',''),(3080,'1','303','1',1,'Retail Sale Id 2990',4320.00,0.00,0.00,6.00,420.00,'2023-03-03 19:04:01','',''),(3081,'1','303','1',1,'Retail Sale Id 2991',9000.00,0.00,0.00,12.50,875.00,'2023-03-03 19:05:04','',''),(3082,'1','303','1',1,'Retail Sale Id 2992',9000.00,0.00,0.00,12.50,875.00,'2023-03-03 19:06:08','',''),(3083,'1','303','1',1,'Retail Sale Id 2993',9000.00,0.00,0.00,12.50,875.00,'2023-03-03 19:06:59','',''),(3084,'1','303','1',1,'Retail Sale Id 2995',4320.00,0.00,0.00,6.00,420.00,'2023-03-03 19:10:57','',''),(3085,'1','303','1',1,'Retail Sale Id 2995',7200.00,0.00,0.00,10.00,700.00,'2023-03-03 19:10:57','',''),(3086,'1','303','1',1,'Retail Sale Id 2996',2498.40,0.00,0.00,3.47,242.90,'2023-03-03 19:11:52','',''),(3087,'1','303','1',1,'Retail Sale Id 2997',14796.00,0.00,0.00,20.55,1438.50,'2023-03-03 19:55:56','',''),(3088,'1','303','1',1,'Retail Sale Id 2998',4320.00,0.00,0.00,6.00,420.00,'2023-03-04 07:55:16','',''),(3089,'1','303','1',1,'Retail Sale Id 2999',4320.00,0.00,0.00,6.00,420.00,'2023-03-04 08:12:43','',''),(3090,'1','303','1',1,'Retail Sale Id 3000',7200.00,0.00,0.00,10.00,700.00,'2023-03-04 09:05:57','',''),(3091,'1','303','1',1,'Retail Sale Id 3001',4320.00,0.00,0.00,6.00,420.00,'2023-03-04 09:24:51','',''),(3092,'1','303','1',1,'Retail Sale Id 3002',3002.40,0.00,0.00,4.17,291.90,'2023-03-04 09:26:49','',''),(3093,'1','303','1',1,'Retail Sale Id 3003',720.00,0.00,0.00,1.00,70.00,'2023-03-04 09:28:52','',''),(3094,'1','303','1',1,'Retail Sale Id 3004',2160.00,0.00,0.00,3.00,210.00,'2023-03-04 09:30:44','',''),(3095,'1','303','1',1,'Retail Sale Id 3005',9000.00,0.00,0.00,12.50,875.00,'2023-03-04 09:32:18','',''),(3096,'1','303','1',1,'Retail Sale Id 3006',3002.40,0.00,0.00,4.17,291.90,'2023-03-04 09:35:15','',''),(3097,'1','303','1',1,'Retail Sale Id 3007',4320.00,0.00,0.00,6.00,420.00,'2023-03-04 09:46:24','',''),(3098,'1','303','1',1,'Retail Sale Id 3008',1497.60,0.00,0.00,2.08,145.60,'2023-03-04 09:50:04','',''),(3099,'1','303','1',1,'Retail Sale Id 3010',2203.20,0.00,0.00,3.06,214.20,'2023-03-04 09:54:00','',''),(3100,'1','303','1',1,'Retail Sale Id 3011',2880.00,0.00,0.00,4.00,280.00,'2023-03-04 10:06:30','',''),(3101,'1','303','1',1,'Retail Sale Id 3012',4320.00,0.00,0.00,6.00,420.00,'2023-03-04 10:08:51','',''),(3102,'1','303','1',1,'Retail Sale Id 3013',1497.60,0.00,0.00,2.08,145.60,'2023-03-04 10:19:02','',''),(3103,'1','303','1',1,'Retail Sale Id 3014',4320.00,0.00,0.00,6.00,420.00,'2023-03-04 10:24:14','',''),(3104,'1','303','1',1,'Retail Sale Id 3015',9000.00,0.00,0.00,12.50,875.00,'2023-03-04 10:25:58','',''),(3105,'1','303','1',1,'Retail Sale Id 3016',2498.40,0.00,0.00,3.47,242.90,'2023-03-04 10:28:02','',''),(3106,'1','303','1',1,'Retail Sale Id 3017',1000.80,0.00,0.00,1.39,97.30,'2023-03-04 10:30:16','',''),(3107,'1','303','1',1,'Retail Sale Id 3018',2880.00,0.00,0.00,4.00,280.00,'2023-03-04 10:32:21','',''),(3108,'1','303','1',1,'Retail Sale Id 3019',4320.00,0.00,0.00,6.00,420.00,'2023-03-04 10:36:54','',''),(3109,'1','303','1',1,'Retail Sale Id 3020',3600.00,0.00,0.00,5.00,350.00,'2023-03-04 10:54:45','',''),(3110,'1','303','1',1,'Retail Sale Id 3021',2203.20,0.00,0.00,3.06,214.20,'2023-03-04 10:58:14','',''),(3111,'1','303','1',1,'Retail Sale Id 3022',7920.00,0.00,0.00,11.00,770.00,'2023-03-04 11:18:03','',''),(3112,'1','303','1',1,'Retail Sale Id 3023',2160.00,0.00,0.00,3.00,210.00,'2023-03-04 11:23:02','',''),(3113,'1','303','1',1,'Retail Sale Id 3024',4320.00,0.00,0.00,6.00,420.00,'2023-03-04 11:42:37','',''),(3114,'1','303','1',1,'Retail Sale Id 3025',4320.00,0.00,0.00,6.00,420.00,'2023-03-04 11:49:36','',''),(3115,'1','303','1',1,'Retail Sale Id 3026',2880.00,0.00,0.00,4.00,280.00,'2023-03-04 11:51:18','',''),(3116,'1','303','1',1,'Retail Sale Id 3027',2880.00,0.00,0.00,4.00,280.00,'2023-03-04 11:53:13','',''),(3117,'1','303','1',1,'Retail Sale Id 3028',9000.00,0.00,0.00,12.50,875.00,'2023-03-04 11:54:59','',''),(3118,'1','303','1',1,'Retail Sale Id 3029',9000.00,0.00,0.00,12.50,875.00,'2023-03-04 12:09:50','',''),(3119,'1','303','1',1,'Retail Sale Id 3030',5040.00,0.00,0.00,7.00,490.00,'2023-03-04 12:22:21','',''),(3120,'1','303','1',1,'Retail Sale Id 3031',7200.00,0.00,0.00,10.00,700.00,'2023-03-04 12:25:42','',''),(3121,'1','303','1',1,'Retail Sale Id 3032',4320.00,0.00,0.00,6.00,420.00,'2023-03-04 12:28:08','',''),(3122,'1','303','1',1,'Retail Sale Id 3033',9000.00,0.00,0.00,12.50,875.00,'2023-03-04 12:47:30','',''),(3123,'1','303','1',1,'Retail Sale Id 3034',9000.00,0.00,0.00,12.50,875.00,'2023-03-04 12:54:13','',''),(3124,'1','303','1',1,'Retail Sale Id 3036',2160.00,0.00,0.00,3.00,210.00,'2023-03-04 13:10:02','',''),(3125,'1','303','1',1,'Retail Sale Id 3036',2160.00,0.00,0.00,3.00,210.00,'2023-03-04 13:10:02','',''),(3126,'1','303','1',1,'Retail Sale Id 3036',4320.00,0.00,0.00,6.00,420.00,'2023-03-04 13:10:02','',''),(3127,'1','303','1',1,'Retail Sale Id 3037',2160.00,0.00,0.00,3.00,210.00,'2023-03-04 13:11:34','',''),(3128,'1','303','1',1,'Retail Sale Id 3038',34500.00,0.00,0.00,50.00,2000.00,'2023-03-04 13:22:42','',''),(3129,'1','303','1',1,'Retail Sale Id 3039',3600.00,0.00,0.00,5.00,350.00,'2023-03-04 13:24:03','',''),(3130,'1','303','1',1,'Retail Sale Id 3040',4320.00,0.00,0.00,6.00,420.00,'2023-03-04 13:25:32','',''),(3131,'1','303','1',1,'Retail Sale Id 3040',4320.00,0.00,0.00,6.00,420.00,'2023-03-04 13:25:32','',''),(3132,'1','303','1',1,'Retail Sale Id 3041',4996.80,0.00,0.00,6.94,485.80,'2023-03-04 13:49:11','',''),(3133,'1','303','1',1,'Retail Sale Id 3042',4320.00,0.00,0.00,6.00,420.00,'2023-03-04 13:50:05','',''),(3134,'1','303','1',1,'Retail Sale Id 3043',2160.00,0.00,0.00,3.00,210.00,'2023-03-04 13:52:35','',''),(3135,'1','303','1',1,'Retail Sale Id 3044',4320.00,0.00,0.00,6.00,420.00,'2023-03-04 13:54:14','',''),(3136,'1','303','1',1,'Retail Sale Id 3045',799.20,0.00,0.00,1.11,77.70,'2023-03-04 13:55:33','',''),(3137,'1','303','1',1,'Retail Sale Id 3046',2160.00,0.00,0.00,3.00,210.00,'2023-03-04 13:58:57','',''),(3138,'1','303','1',1,'Retail Sale Id 3047',9000.00,0.00,0.00,12.50,875.00,'2023-03-04 14:00:12','',''),(3139,'1','303','1',1,'Retail Sale Id 3048',2160.00,0.00,0.00,3.00,210.00,'2023-03-04 14:10:52','',''),(3140,'1','303','1',1,'Retail Sale Id 3049',7200.00,0.00,0.00,10.00,700.00,'2023-03-04 14:21:48','',''),(3141,'1','303','1',1,'Retail Sale Id 3050',6998.40,0.00,0.00,9.72,680.40,'2023-03-04 15:15:36','',''),(3142,'1','303','1',1,'Retail Sale Id 3051',3600.00,0.00,0.00,5.00,350.00,'2023-03-04 15:37:00','',''),(3143,'1','303','1',1,'Retail Sale Id 3052',1000.80,0.00,0.00,1.39,97.30,'2023-03-04 16:02:14','',''),(3144,'1','303','1',1,'Retail Sale Id 3053',4320.00,0.00,0.00,6.00,420.00,'2023-03-04 16:17:46','',''),(3145,'1','303','1',1,'Retail Sale Id 3053',9000.00,0.00,0.00,12.50,875.00,'2023-03-04 16:17:46','',''),(3146,'1','303','1',1,'Retail Sale Id 3054',1497.60,0.00,0.00,2.08,145.60,'2023-03-04 16:29:13','',''),(3147,'1','303','1',1,'Retail Sale Id 3055',4320.00,0.00,0.00,6.00,420.00,'2023-03-04 16:39:06','',''),(3148,'1','303','1',1,'Retail Sale Id 3056',4003.20,0.00,0.00,5.56,389.20,'2023-03-04 16:40:20','',''),(3149,'1','303','1',1,'Retail Sale Id 3057',3002.40,0.00,0.00,4.17,291.90,'2023-03-04 16:42:14','',''),(3150,'1','303','1',1,'Retail Sale Id 3058',1497.60,0.00,0.00,2.08,145.60,'2023-03-04 16:48:23','',''),(3151,'1','303','1',1,'Retail Sale Id 3059',3600.00,0.00,0.00,5.00,350.00,'2023-03-04 16:50:56','',''),(3152,'1','303','1',1,'Retail Sale Id 3060',1000.80,0.00,0.00,1.39,97.30,'2023-03-04 16:56:23','',''),(3153,'1','303','1',1,'Retail Sale Id 3061',720.00,0.00,0.00,1.00,70.00,'2023-03-04 17:13:28','',''),(3154,'1','303','1',1,'Retail Sale Id 3062',4320.00,0.00,0.00,6.00,420.00,'2023-03-04 17:14:30','',''),(3155,'1','303','1',1,'Retail Sale Id 3063',9000.00,0.00,0.00,12.50,875.00,'2023-03-04 17:30:09','',''),(3156,'1','303','1',1,'Retail Sale Id 3064',2160.00,0.00,0.00,3.00,210.00,'2023-03-04 17:35:15','',''),(3157,'1','303','1',1,'Retail Sale Id 3065',4320.00,0.00,0.00,6.00,420.00,'2023-03-04 17:36:39','',''),(3158,'1','303','1',1,'Retail Sale Id 3066',9000.00,0.00,0.00,12.50,875.00,'2023-03-04 17:43:27','',''),(3159,'1','303','1',1,'Retail Sale Id 3067',4320.00,0.00,0.00,6.00,420.00,'2023-03-04 17:54:59','',''),(3160,'1','303','1',1,'Retail Sale Id 3068',4320.00,0.00,0.00,6.00,420.00,'2023-03-04 17:56:19','',''),(3161,'1','303','1',1,'Retail Sale Id 3069',324.00,0.00,0.00,0.45,31.50,'2023-03-04 18:36:02','',''),(3162,'1','303','1',1,'Retail Sale Id 3070',4320.00,0.00,0.00,6.00,420.00,'2023-03-05 07:46:51','',''),(3163,'1','303','1',1,'Retail Sale Id 3071',4320.00,0.00,0.00,6.00,420.00,'2023-03-05 07:59:57','',''),(3164,'1','303','1',1,'Retail Sale Id 3072',4320.00,0.00,0.00,6.00,420.00,'2023-03-05 08:25:44','',''),(3165,'1','303','1',1,'Retail Sale Id 3073',3002.40,0.00,0.00,4.17,291.90,'2023-03-05 08:43:36','',''),(3166,'1','303','1',1,'Retail Sale Id 3074',3600.00,0.00,0.00,5.00,350.00,'2023-03-05 08:53:37','',''),(3167,'1','303','1',1,'Retail Sale Id 3075',4320.00,0.00,0.00,6.00,420.00,'2023-03-05 08:56:01','',''),(3168,'1','303','1',1,'Retail Sale Id 3076',9000.00,0.00,0.00,12.50,875.00,'2023-03-05 09:04:54','',''),(3169,'1','303','1',1,'Retail Sale Id 3077',2160.00,0.00,0.00,3.00,210.00,'2023-03-05 09:37:03','',''),(3170,'1','303','1',1,'Retail Sale Id 3078',2160.00,0.00,0.00,3.00,210.00,'2023-03-05 09:42:18','',''),(3171,'1','303','1',1,'Retail Sale Id 3079',3002.40,0.00,0.00,4.17,291.90,'2023-03-05 10:13:35','',''),(3172,'1','303','1',1,'Retail Sale Id 3080',4320.00,0.00,0.00,6.00,420.00,'2023-03-05 10:22:16','',''),(3173,'1','303','1',1,'Retail Sale Id 3080',9000.00,0.00,0.00,12.50,875.00,'2023-03-05 10:22:16','',''),(3174,'1','303','1',1,'Retail Sale Id 3081',4320.00,0.00,0.00,6.00,420.00,'2023-03-05 10:29:22','',''),(3175,'1','303','1',1,'Retail Sale Id 3082',2203.20,0.00,0.00,3.06,214.20,'2023-03-05 10:32:42','',''),(3176,'1','303','1',1,'Retail Sale Id 3083',1497.60,0.00,0.00,2.08,145.60,'2023-03-05 10:34:50','',''),(3177,'1','303','1',1,'Retail Sale Id 3084',1000.80,0.00,0.00,1.39,97.30,'2023-03-05 10:42:08','',''),(3178,'1','303','1',1,'Retail Sale Id 3085',1000.80,0.00,0.00,1.39,97.30,'2023-03-05 10:44:59','',''),(3179,'1','303','1',1,'Retail Sale Id 3086',2160.00,0.00,0.00,3.00,210.00,'2023-03-05 10:47:35','',''),(3180,'1','303','1',1,'Retail Sale Id 3087',4320.00,0.00,0.00,6.00,420.00,'2023-03-05 10:52:18','',''),(3181,'1','303','1',1,'Retail Sale Id 3088',4320.00,0.00,0.00,6.00,420.00,'2023-03-05 11:02:41','',''),(3182,'1','303','1',1,'Retail Sale Id 3089',5760.00,0.00,0.00,8.00,560.00,'2023-03-05 11:04:47','',''),(3183,'1','303','1',1,'Retail Sale Id 3090',9000.00,0.00,0.00,12.50,875.00,'2023-03-05 11:06:12','',''),(3184,'1','303','1',1,'Retail Sale Id 3091',9000.00,0.00,0.00,12.50,875.00,'2023-03-05 11:08:26','',''),(3185,'1','303','1',1,'Retail Sale Id 3092',4320.00,0.00,0.00,6.00,420.00,'2023-03-05 11:10:24','',''),(3186,'1','303','1',1,'Retail Sale Id 3093',3600.00,0.00,0.00,5.00,350.00,'2023-03-05 11:11:56','',''),(3187,'1','303','1',1,'Retail Sale Id 3094',4320.00,0.00,0.00,6.00,420.00,'2023-03-05 11:16:36','',''),(3188,'1','303','1',1,'Retail Sale Id 3095',7200.00,0.00,0.00,10.00,700.00,'2023-03-05 11:29:35','',''),(3189,'1','303','1',1,'Retail Sale Id 3096',3600.00,0.00,0.00,5.00,350.00,'2023-03-05 11:31:50','',''),(3190,'1','303','1',1,'Retail Sale Id 3097',9000.00,0.00,0.00,12.50,875.00,'2023-03-05 11:33:37','',''),(3191,'1','303','1',1,'Retail Sale Id 3098',3600.00,0.00,0.00,5.00,350.00,'2023-03-05 11:35:17','',''),(3192,'1','303','1',1,'Retail Sale Id 3099',69000.00,0.00,0.00,100.00,4000.00,'2023-03-05 11:39:26','',''),(3193,'1','303','1',1,'Retail Sale Id 3100',9000.00,0.00,0.00,12.50,875.00,'2023-03-05 12:11:37','',''),(3194,'1','303','1',1,'Retail Sale Id 3101',2160.00,0.00,0.00,3.00,210.00,'2023-03-05 12:14:11','',''),(3195,'1','303','1',1,'Retail Sale Id 3102',4320.00,0.00,0.00,6.00,420.00,'2023-03-05 12:23:10','',''),(3196,'1','303','1',1,'Retail Sale Id 3103',1440.00,0.00,0.00,2.00,140.00,'2023-03-05 12:25:45','',''),(3197,'1','303','1',1,'Retail Sale Id 3104',9000.00,0.00,0.00,12.50,875.00,'2023-03-05 12:30:00','',''),(3198,'1','303','1',1,'Retail Sale Id 3105',2001.60,0.00,0.00,2.78,194.60,'2023-03-05 12:31:25','',''),(3199,'1','303','1',1,'Retail Sale Id 3106',2203.20,0.00,0.00,3.06,214.20,'2023-03-05 12:34:19','',''),(3200,'1','303','1',1,'Retail Sale Id 3107',720.00,0.00,0.00,1.00,70.00,'2023-03-05 12:38:25','',''),(3201,'1','303','1',1,'Retail Sale Id 3108',1440.00,0.00,0.00,2.00,140.00,'2023-03-05 12:40:41','',''),(3202,'1','303','1',1,'Retail Sale Id 3109',9000.00,0.00,0.00,12.50,875.00,'2023-03-05 12:43:40','',''),(3203,'1','303','1',1,'Retail Sale Id 3110',2160.00,0.00,0.00,3.00,210.00,'2023-03-05 12:57:52','',''),(3204,'1','303','1',1,'Retail Sale Id 3111',2160.00,0.00,0.00,3.00,210.00,'2023-03-05 13:21:23','',''),(3205,'1','303','1',1,'Retail Sale Id 3112',9000.00,0.00,0.00,12.50,875.00,'2023-03-05 13:22:17','',''),(3206,'1','303','1',1,'Retail Sale Id 3113',7920.00,0.00,0.00,11.00,770.00,'2023-03-05 13:25:29','',''),(3207,'1','303','1',1,'Retail Sale Id 3114',9000.00,0.00,0.00,12.50,875.00,'2023-03-05 13:42:28','',''),(3208,'1','303','1',1,'Return of Retail Sale Id 3110',0.00,2160.00,3.00,0.00,-210.00,'2023-03-05 13:45:06','',''),(3209,'1','303','1',1,'Retail Sale Id 3115',9000.00,0.00,0.00,12.50,875.00,'2023-03-05 13:52:38','',''),(3210,'1','303','1',1,'Retail Sale Id 3116',9000.00,0.00,0.00,12.50,875.00,'2023-03-05 13:58:11','',''),(3211,'1','303','1',1,'Retail Sale Id 3117',2160.00,0.00,0.00,3.00,210.00,'2023-03-05 14:21:33','',''),(3212,'1','303','1',1,'Retail Sale Id 3118',9000.00,0.00,0.00,12.50,875.00,'2023-03-05 14:27:32','',''),(3213,'1','303','1',1,'Retail Sale Id 3119',4320.00,0.00,0.00,6.00,420.00,'2023-03-05 14:40:41','',''),(3214,'1','303','1',1,'Retail Sale Id 3120',9000.00,0.00,0.00,12.50,875.00,'2023-03-05 14:49:37','',''),(3215,'1','303','1',1,'Retail Sale Id 3121',2160.00,0.00,0.00,3.00,210.00,'2023-03-05 15:03:25','',''),(3216,'1','303','1',1,'Retail Sale Id 3122',2160.00,0.00,0.00,3.00,210.00,'2023-03-05 15:37:05','',''),(3217,'1','303','1',1,'Retail Sale Id 3123',1000.80,0.00,0.00,1.39,97.30,'2023-03-05 15:50:57','',''),(3218,'1','303','1',1,'Retail Sale Id 3124',2203.20,0.00,0.00,3.06,214.20,'2023-03-05 15:56:44','',''),(3219,'1','303','1',1,'Retail Sale Id 3125',9000.00,0.00,0.00,12.50,875.00,'2023-03-05 16:02:24','',''),(3220,'1','303','1',1,'Retail Sale Id 3126',4320.00,0.00,0.00,6.00,420.00,'2023-03-05 16:25:14','',''),(3221,'1','303','1',1,'Retail Sale Id 3127',4320.00,0.00,0.00,6.00,420.00,'2023-03-05 16:31:51','',''),(3222,'1','303','1',1,'Retail Sale Id 3128',9000.00,0.00,0.00,12.50,875.00,'2023-03-05 16:48:35','',''),(3223,'1','303','1',1,'Retail Sale Id 3129',1000.80,0.00,0.00,1.39,97.30,'2023-03-05 16:50:16','',''),(3224,'1','303','1',1,'Retail Sale Id 3130',4320.00,0.00,0.00,6.00,420.00,'2023-03-05 17:00:36','',''),(3225,'1','303','1',1,'Retail Sale Id 3131',1000.80,0.00,0.00,1.39,97.30,'2023-03-05 17:16:08','',''),(3226,'1','303','1',1,'Retail Sale Id 3132',4320.00,0.00,0.00,6.00,420.00,'2023-03-05 17:27:07','',''),(3227,'1','303','1',1,'Retail Sale Id 3133',4320.00,0.00,0.00,6.00,420.00,'2023-03-05 17:42:38','',''),(3228,'1','303','1',1,'Retail Sale Id 3134',3600.00,0.00,0.00,5.00,350.00,'2023-03-05 17:45:30','',''),(3229,'1','303','1',1,'Retail Sale Id 3135',3600.00,0.00,0.00,5.00,350.00,'2023-03-05 18:02:01','',''),(3230,'1','303','1',1,'Return of Retail Sale Id 3131',0.00,1000.80,1.39,0.00,-97.30,'2023-03-05 18:48:01','',''),(3231,'1','303','1',1,'Retail Sale Id 3136',14.40,0.00,0.00,0.02,1.40,'2023-03-05 18:48:58','',''),(3232,'1','303','1',1,'Retail Sale Id 3137',2880.00,0.00,0.00,4.00,280.00,'2023-03-06 09:06:39','',''),(3233,'1','303','1',1,'Retail Sale Id 3138',3600.00,0.00,0.00,5.00,350.00,'2023-03-06 09:07:25','',''),(3234,'1','303','1',1,'Retail Sale Id 3139',2160.00,0.00,0.00,3.00,210.00,'2023-03-06 09:10:15','',''),(3235,'1','303','1',1,'Retail Sale Id 3140',2160.00,0.00,0.00,3.00,210.00,'2023-03-06 09:43:59','',''),(3236,'1','303','1',1,'Retail Sale Id 3141',1497.60,0.00,0.00,2.08,145.60,'2023-03-06 09:54:32','',''),(3237,'1','303','1',1,'Retail Sale Id 3142',2160.00,0.00,0.00,3.00,210.00,'2023-03-06 10:05:57','',''),(3238,'1','303','1',1,'Retail Sale Id 3142',2160.00,0.00,0.00,3.00,210.00,'2023-03-06 10:05:57','',''),(3239,'1','303','1',1,'Retail Sale Id 3143',2160.00,0.00,0.00,3.00,210.00,'2023-03-06 10:25:51','',''),(3240,'1','303','1',1,'Retail Sale Id 3143',2160.00,0.00,0.00,3.00,210.00,'2023-03-06 10:25:51','',''),(3241,'1','303','1',1,'Retail Sale Id 3145',2203.20,0.00,0.00,3.06,214.20,'2023-03-06 10:53:16','',''),(3242,'1','303','1',1,'Retail Sale Id 3146',9000.00,0.00,0.00,12.50,875.00,'2023-03-06 11:23:26','',''),(3243,'1','303','1',1,'Retail Sale Id 3147',1440.00,0.00,0.00,2.00,140.00,'2023-03-06 11:37:24','',''),(3244,'1','303','1',1,'Retail Sale Id 3148',4320.00,0.00,0.00,6.00,420.00,'2023-03-06 11:38:19','',''),(3245,'1','303','1',1,'Retail Sale Id 3149',3600.00,0.00,0.00,5.00,350.00,'2023-03-06 11:40:05','',''),(3246,'1','303','1',1,'Retail Sale Id 3150',4320.00,0.00,0.00,6.00,420.00,'2023-03-06 11:41:49','',''),(3247,'1','303','1',1,'Retail Sale Id 3151',9000.00,0.00,0.00,12.50,875.00,'2023-03-06 11:58:34','',''),(3248,'1','303','1',1,'Retail Sale Id 3152',3002.40,0.00,0.00,4.17,291.90,'2023-03-06 12:20:54','',''),(3249,'1','303','1',1,'Retail Sale Id 3153',4320.00,0.00,0.00,6.00,420.00,'2023-03-06 12:25:27','',''),(3250,'1','303','1',1,'Retail Sale Id 3154',4320.00,0.00,0.00,6.00,420.00,'2023-03-06 12:30:54','',''),(3251,'1','303','1',1,'Retail Sale Id 3155',2160.00,0.00,0.00,3.00,210.00,'2023-03-06 12:45:39','',''),(3252,'1','303','1',1,'Retail Sale Id 3155',7920.00,0.00,0.00,11.00,770.00,'2023-03-06 12:45:39','',''),(3253,'1','303','1',1,'Retail Sale Id 3157',2880.00,0.00,0.00,4.00,280.00,'2023-03-06 12:50:52','',''),(3254,'1','303','1',1,'Retail Sale Id 3159',8798.40,0.00,0.00,12.22,855.40,'2023-03-06 12:53:28','',''),(3255,'1','303','1',1,'Retail Sale Id 3160',4320.00,0.00,0.00,6.00,420.00,'2023-03-06 12:55:27','',''),(3256,'1','303','1',1,'Retail Sale Id 3161',1497.60,0.00,0.00,2.08,145.60,'2023-03-06 13:04:17','',''),(3257,'1','303','1',1,'Retail Sale Id 3162',4320.00,0.00,0.00,6.00,420.00,'2023-03-06 13:07:11','',''),(3258,'1','303','1',1,'Retail Sale Id 3163',2160.00,0.00,0.00,3.00,210.00,'2023-03-06 13:15:46','',''),(3259,'1','303','1',1,'Retail Sale Id 3164',2160.00,0.00,0.00,3.00,210.00,'2023-03-06 13:25:35','',''),(3260,'1','303','1',1,'Retail Sale Id 3165',1000.80,0.00,0.00,1.39,97.30,'2023-03-06 13:42:14','',''),(3261,'1','303','1',1,'Retail Sale Id 3166',4320.00,0.00,0.00,6.00,420.00,'2023-03-06 13:43:47','',''),(3262,'1','303','1',1,'Retail Sale Id 3167',2160.00,0.00,0.00,3.00,210.00,'2023-03-06 13:58:18','',''),(3263,'1','303','1',1,'Retail Sale Id 3168',2880.00,0.00,0.00,4.00,280.00,'2023-03-06 14:08:02','',''),(3264,'1','303','1',1,'Retail Sale Id 3169',2800.80,0.00,0.00,3.89,272.30,'2023-03-06 14:21:39','',''),(3265,'1','303','1',1,'Retail Sale Id 3170',4320.00,0.00,0.00,6.00,420.00,'2023-03-06 14:23:53','',''),(3266,'1','303','1',1,'Retail Sale Id 3171',4320.00,0.00,0.00,6.00,420.00,'2023-03-06 14:25:48','',''),(3267,'1','303','1',1,'Retail Sale Id 3172',2880.00,0.00,0.00,4.00,280.00,'2023-03-06 14:33:44','',''),(3268,'1','303','1',1,'Retail Sale Id 3173',2160.00,0.00,0.00,3.00,210.00,'2023-03-06 14:35:34','',''),(3269,'1','303','1',1,'Retail Sale Id 3174',9000.00,0.00,0.00,12.50,875.00,'2023-03-06 15:01:19','',''),(3270,'1','303','1',1,'Retail Sale Id 3175',9000.00,0.00,0.00,12.50,875.00,'2023-03-06 15:32:50','',''),(3271,'1','303','1',1,'Retail Sale Id 3176',2160.00,0.00,0.00,3.00,210.00,'2023-03-06 15:38:18','',''),(3272,'1','303','1',1,'Retail Sale Id 3177',1497.60,0.00,0.00,2.08,145.60,'2023-03-06 15:40:50','',''),(3273,'1','303','1',1,'Retail Sale Id 3178',4003.20,0.00,0.00,5.56,389.20,'2023-03-06 15:59:11','',''),(3274,'1','303','1',1,'Retail Sale Id 3179',2160.00,0.00,0.00,3.00,210.00,'2023-03-06 16:24:12','',''),(3275,'1','303','1',1,'Retail Sale Id 3180',2160.00,0.00,0.00,3.00,210.00,'2023-03-06 16:25:49','',''),(3276,'1','303','1',1,'Retail Sale Id 3181',2160.00,0.00,0.00,3.00,210.00,'2023-03-06 16:35:28','',''),(3277,'1','303','1',1,'Retail Sale Id 3182',3002.40,0.00,0.00,4.17,291.90,'2023-03-06 16:55:57','',''),(3278,'1','303','1',1,'Retail Sale Id 3183',2160.00,0.00,0.00,3.00,210.00,'2023-03-06 17:00:05','',''),(3279,'1','303','1',1,'Retail Sale Id 3184',9000.00,0.00,0.00,12.50,875.00,'2023-03-06 17:05:09','',''),(3280,'1','303','1',1,'Retail Sale Id 3185',4996.80,0.00,0.00,6.94,485.80,'2023-03-06 17:12:57','',''),(3281,'1','303','1',1,'Retail Sale Id 3186',2160.00,0.00,0.00,3.00,210.00,'2023-03-06 17:15:14','',''),(3282,'1','303','1',1,'Retail Sale Id 3187',2160.00,0.00,0.00,3.00,210.00,'2023-03-06 17:18:14','',''),(3283,'1','303','1',1,'Retail Sale Id 3188',2203.20,0.00,0.00,3.06,214.20,'2023-03-06 17:28:24','',''),(3284,'1','303','1',1,'Retail Sale Id 3189',2160.00,0.00,0.00,3.00,210.00,'2023-03-06 17:29:23','',''),(3285,'1','303','1',1,'Retail Sale Id 3190',4320.00,0.00,0.00,6.00,420.00,'2023-03-06 17:35:22','',''),(3286,'1','303','1',1,'Retail Sale Id 3191',2160.00,0.00,0.00,3.00,210.00,'2023-03-06 17:49:59','',''),(3287,'1','303','1',1,'Retail Sale Id 3192',2880.00,0.00,0.00,4.00,280.00,'2023-03-06 17:51:14','',''),(3288,'1','303','1',1,'Retail Sale Id 3193',7200.00,0.00,0.00,10.00,700.00,'2023-03-06 17:56:19','',''),(3289,'1','303','1',1,'Retail Sale Id 3194',2160.00,0.00,0.00,3.00,210.00,'2023-03-06 17:58:06','',''),(3290,'1','303','1',1,'Retail Sale Id 3195',4320.00,0.00,0.00,6.00,420.00,'2023-03-06 18:05:23','',''),(3291,'1','303','1',1,'Retail Sale Id 3196',720.00,0.00,0.00,1.00,70.00,'2023-03-06 18:09:50','',''),(3292,'1','303','1',1,'Retail Sale Id 3196',9000.00,0.00,0.00,12.50,875.00,'2023-03-06 18:09:50','',''),(3293,'1','303','1',1,'Retail Sale Id 3196',9000.00,0.00,0.00,12.50,875.00,'2023-03-06 18:09:50','',''),(3294,'1','303','1',1,'Return of Retail Sale Id 3177',0.00,1497.60,2.08,0.00,-145.60,'2023-03-06 18:44:41','',''),(3295,'1','303','1',1,'Retail Sale Id 3197',1382.40,0.00,0.00,1.92,134.40,'2023-03-06 18:45:37','',''),(3296,'1','303','1',1,'Retail Sale Id 3198',3600.00,0.00,0.00,5.00,350.00,'2023-03-07 07:59:36','',''),(3297,'1','303','1',1,'Retail Sale Id 3198',3600.00,0.00,0.00,5.00,350.00,'2023-03-07 07:59:36','',''),(3298,'1','303','1',1,'Retail Sale Id 3199',3600.00,0.00,0.00,5.00,350.00,'2023-03-07 08:11:53','',''),(3299,'1','303','1',1,'Retail Sale Id 3200',2160.00,0.00,0.00,3.00,210.00,'2023-03-07 08:35:23','',''),(3300,'1','303','1',1,'Retail Sale Id 3201',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 08:53:16','',''),(3301,'1','303','1',1,'Retail Sale Id 3202',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 08:57:15','',''),(3302,'1','303','1',1,'Retail Sale Id 3203',2160.00,0.00,0.00,3.00,210.00,'2023-03-07 08:58:15','',''),(3303,'1','303','1',1,'Retail Sale Id 3204',9000.00,0.00,0.00,12.50,875.00,'2023-03-07 09:02:55','',''),(3304,'1','303','1',1,'Retail Sale Id 3205',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 09:08:29','',''),(3305,'1','303','1',1,'Retail Sale Id 3206',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 09:10:19','',''),(3306,'1','303','1',1,'Retail Sale Id 3207',2880.00,0.00,0.00,4.00,280.00,'2023-03-07 09:15:50','',''),(3307,'1','303','1',1,'Retail Sale Id 3208',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 09:17:07','',''),(3308,'1','303','1',1,'Retail Sale Id 3209',103500.00,0.00,0.00,150.00,6000.00,'2023-03-07 09:20:43','',''),(3309,'1','303','1',1,'Retail Sale Id 3210',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 09:37:30','',''),(3310,'1','303','1',1,'Retail Sale Id 3211',3600.00,0.00,0.00,5.00,350.00,'2023-03-07 09:39:09','',''),(3311,'1','303','1',1,'Retail Sale Id 3212',9000.00,0.00,0.00,12.50,875.00,'2023-03-07 09:42:44','',''),(3312,'1','303','1',1,'Retail Sale Id 3213',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 10:02:55','',''),(3313,'1','303','1',1,'Retail Sale Id 3214',2160.00,0.00,0.00,3.00,210.00,'2023-03-07 10:11:24','',''),(3314,'1','303','1',1,'Retail Sale Id 3215',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 10:14:55','',''),(3315,'1','303','1',1,'Retail Sale Id 3216',2160.00,0.00,0.00,3.00,210.00,'2023-03-07 10:19:07','',''),(3316,'1','303','1',1,'Retail Sale Id 3217',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 10:20:36','',''),(3317,'1','303','1',1,'Retail Sale Id 3218',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 10:38:23','',''),(3318,'1','303','1',1,'Retail Sale Id 3219',69000.00,0.00,0.00,100.00,4000.00,'2023-03-07 10:42:22','',''),(3319,'1','303','1',1,'Retail Sale Id 3220',2160.00,0.00,0.00,3.00,210.00,'2023-03-07 10:53:05','',''),(3320,'1','303','1',1,'Retail Sale Id 3220',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 10:53:05','',''),(3321,'1','303','1',1,'Retail Sale Id 3221',9000.00,0.00,0.00,12.50,875.00,'2023-03-07 11:06:51','',''),(3322,'1','303','1',1,'Retail Sale Id 3222',2160.00,0.00,0.00,3.00,210.00,'2023-03-07 11:17:00','',''),(3323,'1','303','1',1,'Retail Sale Id 3223',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 11:25:49','',''),(3324,'1','303','1',1,'Retail Sale Id 3224',9000.00,0.00,0.00,12.50,875.00,'2023-03-07 11:34:49','',''),(3325,'1','303','1',1,'Retail Sale Id 3225',3600.00,0.00,0.00,5.00,350.00,'2023-03-07 11:36:25','',''),(3326,'1','303','1',1,'Retail Sale Id 3226',1440.00,0.00,0.00,2.00,140.00,'2023-03-07 11:39:15','',''),(3327,'1','303','1',1,'Retail Sale Id 3227',9000.00,0.00,0.00,12.50,875.00,'2023-03-07 11:49:10','',''),(3328,'1','303','1',1,'Retail Sale Id 3228',9000.00,0.00,0.00,12.50,875.00,'2023-03-07 12:01:08','',''),(3329,'1','303','1',1,'Retail Sale Id 3229',3600.00,0.00,0.00,5.00,350.00,'2023-03-07 12:12:36','',''),(3330,'1','303','1',1,'Retail Sale Id 3230',4003.20,0.00,0.00,5.56,389.20,'2023-03-07 12:19:34','',''),(3331,'1','303','1',1,'Retail Sale Id 3231',7999.20,0.00,0.00,11.11,777.70,'2023-03-07 12:32:20','',''),(3332,'1','303','1',1,'Retail Sale Id 3232',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 12:39:00','',''),(3333,'1','303','1',1,'Retail Sale Id 3233',3600.00,0.00,0.00,5.00,350.00,'2023-03-07 12:40:40','',''),(3334,'1','303','1',1,'Retail Sale Id 3234',7200.00,0.00,0.00,10.00,700.00,'2023-03-07 13:05:30','',''),(3335,'1','303','1',1,'Retail Sale Id 3235',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 13:09:34','',''),(3336,'1','303','1',1,'Retail Sale Id 3236',1800.00,0.00,0.00,2.50,175.00,'2023-03-07 13:35:01','',''),(3337,'1','303','1',1,'Retail Sale Id 3237',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 13:38:46','',''),(3338,'1','303','1',1,'Retail Sale Id 3238',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 13:40:31','',''),(3339,'1','303','1',1,'Retail Sale Id 3239',2160.00,0.00,0.00,3.00,210.00,'2023-03-07 13:44:05','',''),(3340,'1','303','1',1,'Retail Sale Id 3239',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 13:44:05','',''),(3341,'1','303','1',1,'Retail Sale Id 3240',2160.00,0.00,0.00,3.00,210.00,'2023-03-07 13:59:25','',''),(3342,'1','303','1',1,'Retail Sale Id 3241',5040.00,0.00,0.00,7.00,490.00,'2023-03-07 14:08:19','',''),(3343,'1','303','1',1,'Retail Sale Id 3242',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 14:14:25','',''),(3344,'1','303','1',1,'Retail Sale Id 3243',5040.00,0.00,0.00,7.00,490.00,'2023-03-07 14:17:49','',''),(3345,'1','303','1',1,'Retail Sale Id 3244',2160.00,0.00,0.00,3.00,210.00,'2023-03-07 14:19:12','',''),(3346,'1','303','1',1,'Retail Sale Id 3245',3600.00,0.00,0.00,5.00,350.00,'2023-03-07 14:41:47','',''),(3347,'1','303','1',1,'Retail Sale Id 3246',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 14:45:32','',''),(3348,'1','303','1',1,'Retail Sale Id 3247',1396.80,0.00,0.00,1.94,135.80,'2023-03-07 15:14:00','',''),(3349,'1','303','1',1,'Retail Sale Id 3248',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 15:30:23','',''),(3350,'1','303','1',1,'Retail Sale Id 3249',2160.00,0.00,0.00,3.00,210.00,'2023-03-07 15:32:33','',''),(3351,'1','303','1',1,'Retail Sale Id 3250',1497.60,0.00,0.00,2.08,145.60,'2023-03-07 16:11:22','',''),(3352,'1','303','1',1,'Retail Sale Id 3252',9000.00,0.00,0.00,12.50,875.00,'2023-03-07 16:18:55','',''),(3353,'1','303','1',1,'Retail Sale Id 3253',2160.00,0.00,0.00,3.00,210.00,'2023-03-07 16:19:59','',''),(3354,'1','303','1',1,'Retail Sale Id 3254',2160.00,0.00,0.00,3.00,210.00,'2023-03-07 16:21:38','',''),(3355,'1','303','1',1,'Retail Sale Id 3255',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 16:34:11','',''),(3356,'1','303','1',1,'Retail Sale Id 3256',9000.00,0.00,0.00,12.50,875.00,'2023-03-07 16:41:51','',''),(3357,'1','303','1',1,'Retail Sale Id 3257',720.00,0.00,0.00,1.00,70.00,'2023-03-07 17:08:24','',''),(3358,'1','303','1',1,'Retail Sale Id 3258',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 17:12:12','',''),(3359,'1','303','1',1,'Retail Sale Id 3259',2160.00,0.00,0.00,3.00,210.00,'2023-03-07 17:22:55','',''),(3360,'1','303','1',1,'Retail Sale Id 3260',2160.00,0.00,0.00,3.00,210.00,'2023-03-07 17:25:18','',''),(3361,'1','303','1',1,'Retail Sale Id 3260',2880.00,0.00,0.00,4.00,280.00,'2023-03-07 17:25:18','',''),(3362,'1','303','1',1,'Retail Sale Id 3261',3600.00,0.00,0.00,5.00,350.00,'2023-03-07 17:30:13','',''),(3363,'1','303','1',1,'Retail Sale Id 3262',2160.00,0.00,0.00,3.00,210.00,'2023-03-07 17:37:37','',''),(3364,'1','303','1',1,'Retail Sale Id 3263',3600.00,0.00,0.00,5.00,350.00,'2023-03-07 17:39:10','',''),(3365,'1','303','1',1,'Retail Sale Id 3264',9000.00,0.00,0.00,12.50,875.00,'2023-03-07 17:56:06','',''),(3366,'1','303','1',1,'Retail Sale Id 3265',1800.00,0.00,0.00,2.50,175.00,'2023-03-07 18:00:43','',''),(3367,'1','303','1',1,'Retail Sale Id 3266',1000.80,0.00,0.00,1.39,97.30,'2023-03-07 18:12:14','',''),(3368,'1','303','1',1,'Retail Sale Id 3267',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 18:15:01','',''),(3369,'1','303','1',1,'Retail Sale Id 3267',4320.00,0.00,0.00,6.00,420.00,'2023-03-07 18:15:01','',''),(3370,'1','303','1',1,'Retail Sale Id 3268',2160.00,0.00,0.00,3.00,210.00,'2023-03-07 18:15:59','',''),(3371,'1','303','1',1,'Retail Sale Id 3269',1000.80,0.00,0.00,1.39,97.30,'2023-03-08 08:13:56','',''),(3372,'1','303','1',1,'Retail Sale Id 3270',2880.00,0.00,0.00,4.00,280.00,'2023-03-08 08:59:17','',''),(3373,'1','303','1',1,'Retail Sale Id 3271',1202.40,0.00,0.00,1.67,116.90,'2023-03-08 09:04:20','',''),(3374,'1','303','1',1,'Retail Sale Id 3272',3600.00,0.00,0.00,5.00,350.00,'2023-03-08 09:28:03','',''),(3375,'1','303','1',1,'Retail Sale Id 3273',80040.00,0.00,0.00,116.00,4640.00,'2023-03-08 09:34:13','',''),(3376,'1','303','1',1,'Retail Sale Id 3274',2001.60,0.00,0.00,2.78,194.60,'2023-03-08 09:44:16','',''),(3377,'1','303','1',1,'Retail Sale Id 3275',34500.00,0.00,0.00,50.00,2000.00,'2023-03-08 10:03:40','',''),(3378,'1','303','1',1,'Retail Sale Id 3276',2880.00,0.00,0.00,4.00,280.00,'2023-03-08 10:05:49','',''),(3379,'1','303','1',1,'Retail Sale Id 3277',4320.00,0.00,0.00,6.00,420.00,'2023-03-08 10:11:24','',''),(3380,'1','303','1',1,'Retail Sale Id 3278',2160.00,0.00,0.00,3.00,210.00,'2023-03-08 10:12:44','',''),(3381,'1','303','1',1,'Retail Sale Id 3279',4320.00,0.00,0.00,6.00,420.00,'2023-03-08 10:15:45','',''),(3382,'1','303','1',1,'Retail Sale Id 3280',2160.00,0.00,0.00,3.00,210.00,'2023-03-08 10:23:50','',''),(3383,'1','303','1',1,'Retail Sale Id 3281',2203.20,0.00,0.00,3.06,214.20,'2023-03-08 10:34:27','',''),(3384,'1','303','1',1,'Retail Sale Id 3282',3600.00,0.00,0.00,5.00,350.00,'2023-03-08 10:44:20','',''),(3385,'1','303','1',1,'Retail Sale Id 3283',9000.00,0.00,0.00,12.50,875.00,'2023-03-08 10:49:53','',''),(3386,'1','303','1',1,'Retail Sale Id 3284',2203.20,0.00,0.00,3.06,214.20,'2023-03-08 10:55:24','',''),(3387,'1','303','1',1,'Retail Sale Id 3285',9000.00,0.00,0.00,12.50,875.00,'2023-03-08 11:00:19','',''),(3388,'1','303','1',1,'Retail Sale Id 3286',2160.00,0.00,0.00,3.00,210.00,'2023-03-08 11:21:02','',''),(3389,'1','303','1',1,'Retail Sale Id 3287',4320.00,0.00,0.00,6.00,420.00,'2023-03-08 11:23:48','',''),(3390,'1','303','1',1,'Retail Sale Id 3288',1000.80,0.00,0.00,1.39,97.30,'2023-03-08 11:28:55','',''),(3391,'1','303','1',1,'Retail Sale Id 3289',4320.00,0.00,0.00,6.00,420.00,'2023-03-08 11:43:13','',''),(3392,'1','303','1',1,'Retail Sale Id 3290',2160.00,0.00,0.00,3.00,210.00,'2023-03-08 11:50:27','',''),(3393,'1','303','1',1,'Retail Sale Id 3290',2160.00,0.00,0.00,3.00,210.00,'2023-03-08 11:50:27','',''),(3394,'1','303','1',1,'Retail Sale Id 3290',4320.00,0.00,0.00,6.00,420.00,'2023-03-08 11:50:27','',''),(3395,'1','303','1',1,'Retail Sale Id 3291',69000.00,0.00,0.00,100.00,4000.00,'2023-03-08 12:07:12','',''),(3396,'1','303','1',1,'Retail Sale Id 3292',2160.00,0.00,0.00,3.00,210.00,'2023-03-08 12:08:50','',''),(3397,'1','303','1',1,'Retail Sale Id 3293',9000.00,0.00,0.00,12.50,875.00,'2023-03-08 12:11:38','',''),(3398,'1','303','1',1,'Retail Sale Id 3294',9000.00,0.00,0.00,12.50,875.00,'2023-03-08 12:13:56','',''),(3399,'1','303','1',1,'Retail Sale Id 3295',4320.00,0.00,0.00,6.00,420.00,'2023-03-08 12:18:52','',''),(3400,'1','303','1',1,'Retail Sale Id 3296',4320.00,0.00,0.00,6.00,420.00,'2023-03-08 12:23:48','',''),(3401,'1','303','1',1,'Retail Sale Id 3298',21672.00,0.00,0.00,30.10,2107.00,'2023-03-08 12:35:19','',''),(3402,'1','303','1',1,'Retail Sale Id 3299',2160.00,0.00,0.00,3.00,210.00,'2023-03-08 12:36:54','',''),(3403,'1','303','1',1,'Retail Sale Id 3300',4320.00,0.00,0.00,6.00,420.00,'2023-03-08 12:45:01','',''),(3404,'1','303','1',1,'Return of Retail Sale Id 3298',0.00,21672.00,30.10,0.00,-2107.00,'2023-03-08 12:48:19','',''),(3405,'1','303','1',1,'Retail Sale Id 3301',4320.00,0.00,0.00,6.00,420.00,'2023-03-08 13:02:16','',''),(3406,'1','303','1',1,'Retail Sale Id 3302',1000.80,0.00,0.00,1.39,97.30,'2023-03-08 13:09:02','',''),(3407,'1','303','1',1,'Retail Sale Id 3303',4320.00,0.00,0.00,6.00,420.00,'2023-03-08 13:10:27','',''),(3408,'1','303','1',1,'Retail Sale Id 3304',3600.00,0.00,0.00,5.00,350.00,'2023-03-08 13:13:31','',''),(3409,'1','303','1',1,'Retail Sale Id 3305',4320.00,0.00,0.00,6.00,420.00,'2023-03-08 13:29:58','',''),(3410,'1','303','1',1,'Retail Sale Id 3305',9000.00,0.00,0.00,12.50,875.00,'2023-03-08 13:29:58','',''),(3411,'1','303','1',1,'Retail Sale Id 3306',6480.00,0.00,0.00,9.00,630.00,'2023-03-08 13:38:01','',''),(3412,'1','303','1',1,'Retail Sale Id 3308',1440.00,0.00,0.00,2.00,140.00,'2023-03-08 13:44:03','',''),(3413,'1','303','1',1,'Retail Sale Id 3309',3002.40,0.00,0.00,4.17,291.90,'2023-03-08 14:00:20','',''),(3414,'1','303','1',1,'Retail Sale Id 3310',2160.00,0.00,0.00,3.00,210.00,'2023-03-08 14:15:15','',''),(3415,'1','303','1',1,'Retail Sale Id 3311',2001.60,0.00,0.00,2.78,194.60,'2023-03-08 14:27:31','',''),(3416,'1','303','1',1,'Retail Sale Id 3312',2160.00,0.00,0.00,3.00,210.00,'2023-03-08 14:29:18','',''),(3417,'1','303','1',1,'Retail Sale Id 3313',300840.00,0.00,0.00,436.00,17440.00,'2023-03-08 14:43:09','',''),(3418,'1','303','1',1,'Retail Sale Id 3314',2160.00,0.00,0.00,3.00,210.00,'2023-03-08 14:48:17','',''),(3419,'1','303','1',1,'Retail Sale Id 3315',9000.00,0.00,0.00,12.50,875.00,'2023-03-08 15:08:24','',''),(3420,'1','303','1',1,'Retail Sale Id 3316',3600.00,0.00,0.00,5.00,350.00,'2023-03-08 15:22:17','',''),(3421,'1','303','1',1,'Retail Sale Id 3317',9000.00,0.00,0.00,12.50,875.00,'2023-03-08 15:23:55','',''),(3422,'1','303','1',1,'Retail Sale Id 3318',4320.00,0.00,0.00,6.00,420.00,'2023-03-08 15:38:06','',''),(3423,'1','303','1',1,'Retail Sale Id 3319',4320.00,0.00,0.00,6.00,420.00,'2023-03-08 15:46:52','',''),(3424,'1','303','1',1,'Retail Sale Id 3320',7200.00,0.00,0.00,10.00,700.00,'2023-03-08 15:48:55','',''),(3425,'1','303','1',1,'Retail Sale Id 3321',2160.00,0.00,0.00,3.00,210.00,'2023-03-08 16:15:15','',''),(3426,'1','303','1',1,'Retail Sale Id 3322',2160.00,0.00,0.00,3.00,210.00,'2023-03-08 16:27:29','',''),(3427,'1','303','1',1,'Retail Sale Id 3323',1497.60,0.00,0.00,2.08,145.60,'2023-03-08 16:36:19','',''),(3428,'1','303','1',1,'Retail Sale Id 3324',1440.00,0.00,0.00,2.00,140.00,'2023-03-08 16:47:11','',''),(3429,'1','303','1',1,'Retail Sale Id 3325',2167.20,0.00,0.00,3.01,210.70,'2023-03-08 16:50:00','',''),(3430,'1','303','1',1,'Retail Sale Id 3326',4996.80,0.00,0.00,6.94,485.80,'2023-03-08 17:01:23','',''),(3431,'1','303','1',1,'Retail Sale Id 3327',9000.00,0.00,0.00,12.50,875.00,'2023-03-08 17:13:09','',''),(3432,'1','303','1',1,'Retail Sale Id 3328',1000.80,0.00,0.00,1.39,97.30,'2023-03-08 17:20:34','',''),(3433,'1','303','1',1,'Retail Sale Id 3329',2203.20,0.00,0.00,3.06,214.20,'2023-03-08 17:31:32','',''),(3434,'1','303','1',1,'Retail Sale Id 3330',4320.00,0.00,0.00,6.00,420.00,'2023-03-08 17:41:38','',''),(3435,'1','303','1',1,'Retail Sale Id 3331',4320.00,0.00,0.00,6.00,420.00,'2023-03-08 17:46:47','',''),(3436,'1','303','1',1,'Retail Sale Id 3332',3600.00,0.00,0.00,5.00,350.00,'2023-03-08 17:49:17','',''),(3437,'1','303','1',1,'Retail Sale Id 3333',4320.00,0.00,0.00,6.00,420.00,'2023-03-08 18:00:13','',''),(3438,'1','303','1',1,'Retail Sale Id 3334',6480.00,0.00,0.00,9.00,630.00,'2023-03-08 18:04:14','',''),(3439,'1','303','1',1,'Retail Sale Id 3335',3600.00,0.00,0.00,5.00,350.00,'2023-03-08 18:08:28','',''),(3440,'1','303','1',1,'Retail Sale Id 3336',720.00,0.00,0.00,1.00,70.00,'2023-03-08 18:11:43','',''),(3441,'1','303','1',1,'Retail Sale Id 3337',2880.00,0.00,0.00,4.00,280.00,'2023-03-08 18:21:00','',''),(3442,'1','303','1',1,'Retail Sale Id 3338',6998.40,0.00,0.00,9.72,680.40,'2023-03-08 18:34:14','',''),(3443,'1','303','1',1,'Retail Sale Id 3339',103500.00,0.00,0.00,150.00,6000.00,'2023-03-08 18:49:50','',''),(3444,'1','303','1',1,'Retail Sale Id 3340',2152.80,0.00,0.00,2.99,209.30,'2023-03-08 19:06:25','',''),(3445,'1','303','1',1,'Return of Retail Sale Id 3336',0.00,720.00,1.00,0.00,-70.00,'2023-03-08 19:33:11','',''),(3446,'1','303','1',1,'Retail Sale Id 3341',460.80,0.00,0.00,0.64,44.80,'2023-03-08 19:33:49','',''),(3447,'1','303','1',1,'Retail Sale Id 3342',9000.00,0.00,0.00,12.50,875.00,'2023-03-09 08:23:46','',''),(3448,'1','303','1',1,'Retail Sale Id 3343',9000.00,0.00,0.00,12.50,875.00,'2023-03-09 09:02:21','',''),(3449,'1','303','1',1,'Retail Sale Id 3344',4320.00,0.00,0.00,6.00,420.00,'2023-03-09 09:06:09','',''),(3450,'1','303','1',1,'Retail Sale Id 3345',1000.80,0.00,0.00,1.39,97.30,'2023-03-09 09:30:43','',''),(3451,'1','303','1',1,'Retail Sale Id 3346',3002.40,0.00,0.00,4.17,291.90,'2023-03-09 09:41:22','',''),(3452,'1','303','1',1,'Retail Sale Id 3347',9000.00,0.00,0.00,12.50,875.00,'2023-03-09 09:42:36','',''),(3453,'1','303','1',1,'Retail Sale Id 3348',4320.00,0.00,0.00,6.00,420.00,'2023-03-09 09:44:06','',''),(3454,'1','303','1',1,'Retail Sale Id 3349',4320.00,0.00,0.00,6.00,420.00,'2023-03-09 09:46:45','',''),(3455,'1','303','1',1,'Retail Sale Id 3350',2160.00,0.00,0.00,3.00,210.00,'2023-03-09 10:12:06','',''),(3456,'1','303','1',1,'Retail Sale Id 3351',34500.00,0.00,0.00,50.00,2000.00,'2023-03-09 10:17:30','',''),(3457,'1','303','1',1,'Retail Sale Id 3352',9000.00,0.00,0.00,12.50,875.00,'2023-03-09 10:21:25','',''),(3458,'1','303','1',1,'Retail Sale Id 3353',4320.00,0.00,0.00,6.00,420.00,'2023-03-09 10:26:12','',''),(3459,'1','303','1',1,'Retail Sale Id 3354',9000.00,0.00,0.00,12.50,875.00,'2023-03-09 10:59:48','',''),(3460,'1','303','1',1,'Retail Sale Id 3355',2001.60,0.00,0.00,2.78,194.60,'2023-03-09 11:31:57','',''),(3461,'1','303','1',1,'Retail Sale Id 3356',3002.40,0.00,0.00,4.17,291.90,'2023-03-09 11:39:26','',''),(3462,'1','303','1',1,'Retail Sale Id 3357',4320.00,0.00,0.00,6.00,420.00,'2023-03-09 11:49:49','',''),(3463,'1','303','1',1,'Retail Sale Id 3358',4320.00,0.00,0.00,6.00,420.00,'2023-03-09 12:00:23','',''),(3464,'1','303','1',1,'Retail Sale Id 3359',2160.00,0.00,0.00,3.00,210.00,'2023-03-09 12:01:48','',''),(3465,'1','303','1',1,'Retail Sale Id 3360',6480.00,0.00,0.00,9.00,630.00,'2023-03-09 12:10:00','',''),(3466,'1','303','1',1,'Retail Sale Id 3361',9000.00,0.00,0.00,12.50,875.00,'2023-03-09 12:15:41','',''),(3467,'1','303','1',1,'Retail Sale Id 3362',7200.00,0.00,0.00,10.00,700.00,'2023-03-09 12:17:05','',''),(3468,'1','303','1',1,'Retail Sale Id 3363',2498.40,0.00,0.00,3.47,242.90,'2023-03-09 12:23:58','',''),(3469,'1','303','1',1,'Retail Sale Id 3364',172500.00,0.00,0.00,250.00,10000.00,'2023-03-09 12:25:28','',''),(3470,'1','303','1',1,'Retail Sale Id 3365',1000.80,0.00,0.00,1.39,97.30,'2023-03-09 12:35:19','',''),(3471,'1','303','1',1,'Retail Sale Id 3366',2160.00,0.00,0.00,3.00,210.00,'2023-03-09 12:41:46','',''),(3472,'1','303','1',1,'Retail Sale Id 3367',2498.40,0.00,0.00,3.47,242.90,'2023-03-09 12:58:21','',''),(3473,'1','303','1',1,'Retail Sale Id 3368',4320.00,0.00,0.00,6.00,420.00,'2023-03-09 13:06:07','',''),(3474,'1','303','1',1,'Retail Sale Id 3369',34500.00,0.00,0.00,50.00,2000.00,'2023-03-09 13:28:35','',''),(3475,'1','303','1',1,'Retail Sale Id 3370',2160.00,0.00,0.00,3.00,210.00,'2023-03-09 13:48:35','',''),(3476,'1','303','1',1,'Retail Sale Id 3371',4320.00,0.00,0.00,6.00,420.00,'2023-03-09 13:57:12','',''),(3477,'1','303','1',1,'Retail Sale Id 3373',4320.00,0.00,0.00,6.00,420.00,'2023-03-09 14:00:25','',''),(3478,'1','303','1',1,'Retail Sale Id 3374',4320.00,0.00,0.00,6.00,420.00,'2023-03-09 14:06:00','',''),(3479,'1','303','1',1,'Retail Sale Id 3375',4320.00,0.00,0.00,6.00,420.00,'2023-03-09 14:10:14','',''),(3480,'1','303','1',1,'Retail Sale Id 3377',4320.00,0.00,0.00,6.00,420.00,'2023-03-09 14:13:04','',''),(3481,'1','303','1',1,'Retail Sale Id 3378',4320.00,0.00,0.00,6.00,420.00,'2023-03-09 14:18:11','',''),(3482,'1','303','1',1,'Retail Sale Id 3379',3600.00,0.00,0.00,5.00,350.00,'2023-03-09 14:20:40','',''),(3483,'1','303','1',1,'Retail Sale Id 3380',2880.00,0.00,0.00,4.00,280.00,'2023-03-09 14:24:06','',''),(3484,'1','303','1',1,'Retail Sale Id 3381',2160.00,0.00,0.00,3.00,210.00,'2023-03-09 14:25:00','',''),(3485,'1','303','1',1,'Retail Sale Id 3382',9000.00,0.00,0.00,12.50,875.00,'2023-03-09 14:33:32','',''),(3486,'1','303','1',1,'Retail Sale Id 3383',2880.00,0.00,0.00,4.00,280.00,'2023-03-09 14:45:51','',''),(3487,'1','303','1',1,'Retail Sale Id 3384',4320.00,0.00,0.00,6.00,420.00,'2023-03-09 14:53:12','',''),(3488,'1','303','1',1,'Retail Sale Id 3385',2160.00,0.00,0.00,3.00,210.00,'2023-03-09 14:55:52','',''),(3489,'1','303','1',1,'Retail Sale Id 3386',1000.80,0.00,0.00,1.39,97.30,'2023-03-09 15:08:58','',''),(3490,'1','303','1',1,'Retail Sale Id 3387',4320.00,0.00,0.00,6.00,420.00,'2023-03-09 15:45:38','',''),(3491,'1','303','1',1,'Retail Sale Id 3388',6480.00,0.00,0.00,9.00,630.00,'2023-03-09 16:03:53','',''),(3492,'1','303','1',1,'Retail Sale Id 3389',9000.00,0.00,0.00,12.50,875.00,'2023-03-09 16:04:57','',''),(3493,'1','303','1',1,'Retail Sale Id 3390',2160.00,0.00,0.00,3.00,210.00,'2023-03-09 16:20:06','',''),(3494,'1','303','1',1,'Retail Sale Id 3390',9000.00,0.00,0.00,12.50,875.00,'2023-03-09 16:20:06','',''),(3495,'1','303','1',1,'Retail Sale Id 3391',90000.00,0.00,0.00,125.00,8750.00,'2023-03-09 16:37:13','',''),(3496,'1','303','1',1,'Retail Sale Id 3392',2160.00,0.00,0.00,3.00,210.00,'2023-03-09 16:57:51','',''),(3497,'1','303','1',1,'Retail Sale Id 3393',9000.00,0.00,0.00,12.50,875.00,'2023-03-09 17:20:23','',''),(3498,'1','303','1',1,'Retail Sale Id 3394',4320.00,0.00,0.00,6.00,420.00,'2023-03-09 17:25:36','',''),(3499,'1','303','1',1,'Retail Sale Id 3395',4320.00,0.00,0.00,6.00,420.00,'2023-03-09 17:39:22','',''),(3500,'1','303','1',1,'Retail Sale Id 3396',4197.60,0.00,0.00,5.83,408.10,'2023-03-09 17:51:20','',''),(3501,'1','303','1',1,'Retail Sale Id 3397',4320.00,0.00,0.00,6.00,420.00,'2023-03-09 18:02:19','',''),(3502,'1','303','1',1,'Retail Sale Id 3398',2160.00,0.00,0.00,3.00,210.00,'2023-03-09 18:07:10','',''),(3503,'1','303','1',1,'Return of Retail Sale Id 3391',0.00,90000.00,125.00,0.00,-8750.00,'2023-03-09 18:24:29','',''),(3504,'1','303','1',1,'Retail Sale Id 3399',9000.00,0.00,0.00,12.50,875.00,'2023-03-09 18:25:09','',''),(3505,'1','303','1',1,'Retail Sale Id 3400',1000.80,0.00,0.00,1.39,97.30,'2023-03-10 07:46:53','',''),(3506,'1','303','1',1,'Retail Sale Id 3401',2160.00,0.00,0.00,3.00,210.00,'2023-03-10 08:13:17','',''),(3507,'1','303','1',1,'Retail Sale Id 3402',3600.00,0.00,0.00,5.00,350.00,'2023-03-10 08:28:18','',''),(3508,'1','303','1',1,'Retail Sale Id 3403',1497.60,0.00,0.00,2.08,145.60,'2023-03-10 08:31:59','',''),(3509,'1','303','1',1,'Retail Sale Id 3404',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 08:49:04','',''),(3510,'1','303','1',1,'Retail Sale Id 3405',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 08:58:38','',''),(3511,'1','303','1',1,'Retail Sale Id 3406',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 09:10:23','',''),(3512,'1','303','1',1,'Retail Sale Id 3407',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 09:16:00','',''),(3513,'1','303','1',1,'Retail Sale Id 3408',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 09:17:23','',''),(3514,'1','303','1',1,'Retail Sale Id 3409',3600.00,0.00,0.00,5.00,350.00,'2023-03-10 09:18:51','',''),(3515,'1','303','1',1,'Retail Sale Id 3410',9000.00,0.00,0.00,12.50,875.00,'2023-03-10 09:40:51','',''),(3516,'1','303','1',1,'Retail Sale Id 3410',9000.00,0.00,0.00,12.50,875.00,'2023-03-10 09:40:51','',''),(3517,'1','303','1',1,'Retail Sale Id 3411',2160.00,0.00,0.00,3.00,210.00,'2023-03-10 10:00:25','',''),(3518,'1','303','1',1,'Retail Sale Id 3412',2001.60,0.00,0.00,2.78,194.60,'2023-03-10 10:16:27','',''),(3519,'1','303','1',1,'Retail Sale Id 3413',2160.00,0.00,0.00,3.00,210.00,'2023-03-10 10:24:31','',''),(3520,'1','303','1',1,'Retail Sale Id 3413',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 10:24:31','',''),(3521,'1','303','1',1,'Retail Sale Id 3414',9000.00,0.00,0.00,12.50,875.00,'2023-03-10 10:34:06','',''),(3522,'1','303','1',1,'Retail Sale Id 3415',2160.00,0.00,0.00,3.00,210.00,'2023-03-10 10:53:37','',''),(3523,'1','303','1',1,'Retail Sale Id 3416',9000.00,0.00,0.00,12.50,875.00,'2023-03-10 11:07:07','',''),(3524,'1','303','1',1,'Retail Sale Id 3417',2160.00,0.00,0.00,3.00,210.00,'2023-03-10 11:09:28','',''),(3525,'1','303','1',1,'Retail Sale Id 3418',1000.80,0.00,0.00,1.39,97.30,'2023-03-10 11:19:18','',''),(3526,'1','303','1',1,'Retail Sale Id 3419',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 11:21:58','',''),(3527,'1','303','1',1,'Retail Sale Id 3420',1497.60,0.00,0.00,2.08,145.60,'2023-03-10 11:36:14','',''),(3528,'1','303','1',1,'Retail Sale Id 3421',2160.00,0.00,0.00,3.00,210.00,'2023-03-10 11:54:27','',''),(3529,'1','303','1',1,'Retail Sale Id 3422',2160.00,0.00,0.00,3.00,210.00,'2023-03-10 12:07:07','',''),(3530,'1','303','1',1,'Retail Sale Id 3423',2160.00,0.00,0.00,3.00,210.00,'2023-03-10 12:15:13','',''),(3531,'1','303','1',1,'Retail Sale Id 3424',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 12:27:43','',''),(3532,'1','303','1',1,'Retail Sale Id 3425',40020.00,0.00,0.00,58.00,2320.00,'2023-03-10 12:33:59','',''),(3533,'1','303','1',1,'Retail Sale Id 3426',1440.00,0.00,0.00,2.00,140.00,'2023-03-10 13:05:33','',''),(3534,'1','303','1',1,'Retail Sale Id 3426',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 13:05:33','',''),(3535,'1','303','1',1,'Retail Sale Id 3427',1497.60,0.00,0.00,2.08,145.60,'2023-03-10 13:14:04','',''),(3536,'1','303','1',1,'Retail Sale Id 3428',2160.00,0.00,0.00,3.00,210.00,'2023-03-10 13:15:53','',''),(3537,'1','303','1',1,'Retail Sale Id 3429',3600.00,0.00,0.00,5.00,350.00,'2023-03-10 14:02:47','',''),(3538,'1','303','1',1,'Retail Sale Id 3430',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 14:09:31','',''),(3539,'1','303','1',1,'Retail Sale Id 3431',9000.00,0.00,0.00,12.50,875.00,'2023-03-10 14:52:42','',''),(3540,'1','303','1',1,'Retail Sale Id 3432',9000.00,0.00,0.00,12.50,875.00,'2023-03-10 14:54:18','',''),(3541,'1','303','1',1,'Retail Sale Id 3433',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 15:01:13','',''),(3542,'1','303','1',1,'Retail Sale Id 3434',2160.00,0.00,0.00,3.00,210.00,'2023-03-10 15:02:32','',''),(3543,'1','303','1',1,'Retail Sale Id 3435',9000.00,0.00,0.00,12.50,875.00,'2023-03-10 15:31:41','',''),(3544,'1','303','1',1,'Retail Sale Id 3436',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 15:33:29','',''),(3545,'1','303','1',1,'Retail Sale Id 3437',2160.00,0.00,0.00,3.00,210.00,'2023-03-10 15:57:42','',''),(3546,'1','303','1',1,'Retail Sale Id 3438',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 15:59:18','',''),(3547,'1','303','1',1,'Retail Sale Id 3439',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 16:02:02','',''),(3548,'1','303','1',1,'Retail Sale Id 3440',34500.00,0.00,0.00,50.00,2000.00,'2023-03-10 16:18:28','',''),(3549,'1','303','1',1,'Retail Sale Id 3441',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 16:24:11','',''),(3550,'1','303','1',1,'Retail Sale Id 3442',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 16:26:06','',''),(3551,'1','303','1',1,'Retail Sale Id 3443',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 16:38:09','',''),(3552,'1','303','1',1,'Retail Sale Id 3444',2160.00,0.00,0.00,3.00,210.00,'2023-03-10 16:42:00','',''),(3553,'1','303','1',1,'Retail Sale Id 3444',2160.00,0.00,0.00,3.00,210.00,'2023-03-10 16:42:00','',''),(3554,'1','303','1',1,'Retail Sale Id 3445',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 16:54:20','',''),(3555,'1','303','1',1,'Retail Sale Id 3446',3600.00,0.00,0.00,5.00,350.00,'2023-03-10 17:03:57','',''),(3556,'1','303','1',1,'Retail Sale Id 3447',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 17:06:31','',''),(3557,'1','303','1',1,'Retail Sale Id 3448',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 17:10:50','',''),(3558,'1','303','1',1,'Retail Sale Id 3449',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 17:15:13','',''),(3559,'1','303','1',1,'Retail Sale Id 3450',3600.00,0.00,0.00,5.00,350.00,'2023-03-10 17:30:28','',''),(3560,'1','303','1',1,'Retail Sale Id 3450',7200.00,0.00,0.00,10.00,700.00,'2023-03-10 17:30:28','',''),(3561,'1','303','1',1,'Retail Sale Id 3451',6480.00,0.00,0.00,9.00,630.00,'2023-03-10 17:39:22','',''),(3562,'1','303','1',1,'Retail Sale Id 3452',3600.00,0.00,0.00,5.00,350.00,'2023-03-10 17:47:25','',''),(3563,'1','303','1',1,'Retail Sale Id 3453',2160.00,0.00,0.00,3.00,210.00,'2023-03-10 17:54:36','',''),(3564,'1','303','1',1,'Retail Sale Id 3454',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 17:59:47','',''),(3565,'1','303','1',1,'Retail Sale Id 3455',9000.00,0.00,0.00,12.50,875.00,'2023-03-10 18:05:31','',''),(3566,'1','303','1',1,'Retail Sale Id 3456',4320.00,0.00,0.00,6.00,420.00,'2023-03-10 18:14:30','',''),(3567,'1','303','1',1,'Retail Sale Id 3457',720.00,0.00,0.00,1.00,70.00,'2023-03-10 18:25:49','',''),(3568,'1','303','1',1,'Retail Sale Id 3458',9655.20,0.00,0.00,13.41,938.70,'2023-03-10 18:53:46','',''),(3569,'1','303','1',1,'Retail Sale Id 3459',3600.00,0.00,0.00,5.00,350.00,'2023-03-11 07:49:43','',''),(3570,'1','303','1',1,'Retail Sale Id 3460',4320.00,0.00,0.00,6.00,420.00,'2023-03-11 08:11:54','',''),(3571,'1','303','1',1,'Retail Sale Id 3461',3002.40,0.00,0.00,4.17,291.90,'2023-03-11 08:46:33','',''),(3572,'1','303','1',1,'Retail Sale Id 3462',4996.80,0.00,0.00,6.94,485.80,'2023-03-11 09:07:00','',''),(3573,'1','303','1',1,'Retail Sale Id 3463',4996.80,0.00,0.00,6.94,485.80,'2023-03-11 09:07:50','',''),(3574,'1','303','1',1,'Retail Sale Id 3464',4320.00,0.00,0.00,6.00,420.00,'2023-03-11 09:23:12','',''),(3575,'1','303','1',1,'Retail Sale Id 3465',2800.80,0.00,0.00,3.89,272.30,'2023-03-11 09:40:57','',''),(3576,'1','303','1',1,'Retail Sale Id 3466',4298.40,0.00,0.00,5.97,417.90,'2023-03-11 09:54:03','',''),(3577,'1','303','1',1,'Retail Sale Id 3467',4320.00,0.00,0.00,6.00,420.00,'2023-03-11 10:06:21','',''),(3578,'1','303','1',1,'Retail Sale Id 3468',2160.00,0.00,0.00,3.00,210.00,'2023-03-11 10:21:11','',''),(3579,'1','303','1',1,'Retail Sale Id 3469',3600.00,0.00,0.00,5.00,350.00,'2023-03-11 10:41:48','',''),(3580,'1','303','1',1,'Retail Sale Id 3470',4320.00,0.00,0.00,6.00,420.00,'2023-03-11 10:46:56','',''),(3581,'1','303','1',1,'Retail Sale Id 3471',69000.00,0.00,0.00,100.00,4000.00,'2023-03-11 10:49:23','',''),(3582,'1','303','1',1,'Retail Sale Id 3472',2160.00,0.00,0.00,3.00,210.00,'2023-03-11 10:53:56','',''),(3583,'1','303','1',1,'Retail Sale Id 3473',2160.00,0.00,0.00,3.00,210.00,'2023-03-11 10:57:00','',''),(3584,'1','303','1',1,'Retail Sale Id 3474',4320.00,0.00,0.00,6.00,420.00,'2023-03-11 11:02:44','',''),(3585,'1','303','1',1,'Retail Sale Id 3475',9000.00,0.00,0.00,12.50,875.00,'2023-03-11 11:04:15','',''),(3586,'1','303','1',1,'Retail Sale Id 3476',2160.00,0.00,0.00,3.00,210.00,'2023-03-11 11:07:00','',''),(3587,'1','303','1',1,'Retail Sale Id 3477',9000.00,0.00,0.00,12.50,875.00,'2023-03-11 11:17:14','',''),(3588,'1','303','1',1,'Retail Sale Id 3478',9000.00,0.00,0.00,12.50,875.00,'2023-03-11 11:25:54','',''),(3589,'1','303','1',1,'Retail Sale Id 3479',4320.00,0.00,0.00,6.00,420.00,'2023-03-11 11:31:45','',''),(3590,'1','303','1',1,'Retail Sale Id 3481',40020.00,0.00,0.00,58.00,2320.00,'2023-03-11 11:38:38','',''),(3591,'1','303','1',1,'Retail Sale Id 3482',2160.00,0.00,0.00,3.00,210.00,'2023-03-11 11:39:34','',''),(3592,'1','303','1',1,'Retail Sale Id 3483',4320.00,0.00,0.00,6.00,420.00,'2023-03-11 11:42:26','',''),(3593,'1','303','1',1,'Retail Sale Id 3484',4320.00,0.00,0.00,6.00,420.00,'2023-03-11 11:43:48','',''),(3594,'1','303','1',1,'Retail Sale Id 3485',6480.00,0.00,0.00,9.00,630.00,'2023-03-11 11:52:12','',''),(3595,'1','303','1',1,'Retail Sale Id 3486',4320.00,0.00,0.00,6.00,420.00,'2023-03-11 11:57:34','',''),(3596,'1','303','1',1,'Retail Sale Id 3486',7200.00,0.00,0.00,10.00,700.00,'2023-03-11 11:57:34','',''),(3597,'1','303','1',1,'Retail Sale Id 3487',34500.00,0.00,0.00,50.00,2000.00,'2023-03-11 12:05:23','',''),(3598,'1','303','1',1,'Retail Sale Id 3488',2001.60,0.00,0.00,2.78,194.60,'2023-03-11 12:09:21','',''),(3599,'1','303','1',1,'Retail Sale Id 3489',4320.00,0.00,0.00,6.00,420.00,'2023-03-11 12:13:47','',''),(3600,'1','303','1',1,'Retail Sale Id 3490',4320.00,0.00,0.00,6.00,420.00,'2023-03-11 12:23:42','',''),(3601,'1','303','1',1,'Retail Sale Id 3491',9000.00,0.00,0.00,12.50,875.00,'2023-03-11 12:25:41','',''),(3602,'1','303','1',1,'Retail Sale Id 3492',4320.00,0.00,0.00,6.00,420.00,'2023-03-11 12:49:00','',''),(3603,'1','303','1',1,'Retail Sale Id 3493',1000.80,0.00,0.00,1.39,97.30,'2023-03-11 12:53:03','',''),(3604,'1','303','1',1,'Retail Sale Id 3494',18000.00,0.00,0.00,25.00,1750.00,'2023-03-11 12:57:08','',''),(3605,'1','303','1',1,'Retail Sale Id 3495',3002.40,0.00,0.00,4.17,291.90,'2023-03-11 13:22:25','',''),(3606,'1','303','1',1,'Retail Sale Id 3496',4320.00,0.00,0.00,6.00,420.00,'2023-03-11 13:25:04','',''),(3607,'1','303','1',1,'Retail Sale Id 3497',1440.00,0.00,0.00,2.00,140.00,'2023-03-11 13:31:43','',''),(3608,'1','303','1',1,'Retail Sale Id 3498',720.00,0.00,0.00,1.00,70.00,'2023-03-11 13:38:13','',''),(3609,'1','303','1',1,'Retail Sale Id 3499',4320.00,0.00,0.00,6.00,420.00,'2023-03-11 13:40:58','',''),(3610,'1','303','1',1,'Retail Sale Id 3500',34500.00,0.00,0.00,50.00,2000.00,'2023-03-11 13:43:07','',''),(3611,'1','303','1',1,'Retail Sale Id 3501',9000.00,0.00,0.00,12.50,875.00,'2023-03-11 13:44:55','',''),(3612,'1','303','1',1,'Retail Sale Id 3502',4320.00,0.00,0.00,6.00,420.00,'2023-03-11 13:56:54','',''),(3613,'1','303','1',1,'Retail Sale Id 3503',4320.00,0.00,0.00,6.00,420.00,'2023-03-11 13:59:10','',''),(3614,'1','303','1',1,'Retail Sale Id 3504',1440.00,0.00,0.00,2.00,140.00,'2023-03-11 14:00:29','',''),(3615,'1','303','1',1,'Retail Sale Id 3505',69000.00,0.00,0.00,100.00,4000.00,'2023-03-11 14:01:45','',''),(3616,'1','303','1',1,'Retail Sale Id 3506',3600.00,0.00,0.00,5.00,350.00,'2023-03-11 14:03:27','',''),(3617,'1','303','1',1,'Retail Sale Id 3507',9000.00,0.00,0.00,12.50,875.00,'2023-03-11 14:18:00','',''),(3618,'1','303','1',1,'Retail Sale Id 3508',6480.00,0.00,0.00,9.00,630.00,'2023-03-11 14:18:52','',''),(3619,'1','303','1',1,'Retail Sale Id 3509',2001.60,0.00,0.00,2.78,194.60,'2023-03-11 14:29:12','',''),(3620,'1','303','1',1,'Retail Sale Id 3510',9000.00,0.00,0.00,12.50,875.00,'2023-03-11 14:43:44','',''),(3621,'1','303','1',1,'Retail Sale Id 3511',4320.00,0.00,0.00,6.00,420.00,'2023-03-11 14:50:33','',''),(3622,'1','303','1',1,'Retail Sale Id 3512',4320.00,0.00,0.00,6.00,420.00,'2023-03-11 14:55:07','',''),(3623,'1','303','1',1,'Retail Sale Id 3513',9000.00,0.00,0.00,12.50,875.00,'2023-03-11 15:01:37','',''),(3624,'1','303','1',1,'Retail Sale Id 3514',1440.00,0.00,0.00,2.00,140.00,'2023-03-11 15:13:45','',''),(3625,'1','303','1',1,'Retail Sale Id 3515',207000.00,0.00,0.00,300.00,12000.00,'2023-03-11 15:28:08','',''),(3626,'1','303','1',1,'Retail Sale Id 3516',2160.00,0.00,0.00,3.00,210.00,'2023-03-11 15:38:08','',''),(3627,'1','303','1',1,'Retail Sale Id 3517',720.00,0.00,0.00,1.00,70.00,'2023-03-11 15:43:01','',''),(3628,'1','303','1',1,'Retail Sale Id 3518',1000.80,0.00,0.00,1.39,97.30,'2023-03-11 16:11:41','',''),(3629,'1','303','1',1,'Retail Sale Id 3519',34500.00,0.00,0.00,50.00,2000.00,'2023-03-11 16:13:04','',''),(3630,'1','303','1',1,'Retail Sale Id 3520',3600.00,0.00,0.00,5.00,350.00,'2023-03-11 16:13:56','',''),(3631,'1','303','1',1,'Retail Sale Id 3521',2880.00,0.00,0.00,4.00,280.00,'2023-03-11 16:16:11','',''),(3632,'1','303','1',1,'Retail Sale Id 3522',1000.80,0.00,0.00,1.39,97.30,'2023-03-11 16:21:04','',''),(3633,'1','303','1',1,'Retail Sale Id 3523',4320.00,0.00,0.00,6.00,420.00,'2023-03-11 16:24:32','',''),(3634,'1','303','1',1,'Retail Sale Id 3524',2160.00,0.00,0.00,3.00,210.00,'2023-03-11 16:26:30','',''),(3635,'1','303','1',1,'Retail Sale Id 3525',4320.00,0.00,0.00,6.00,420.00,'2023-03-11 16:29:12','',''),(3636,'1','303','1',1,'Retail Sale Id 3526',1440.00,0.00,0.00,2.00,140.00,'2023-03-11 16:30:46','',''),(3637,'1','303','1',1,'Retail Sale Id 3527',2160.00,0.00,0.00,3.00,210.00,'2023-03-11 16:34:04','',''),(3638,'1','303','1',1,'Retail Sale Id 3528',2160.00,0.00,0.00,3.00,210.00,'2023-03-11 16:36:13','',''),(3639,'1','303','1',1,'Retail Sale Id 3528',9000.00,0.00,0.00,12.50,875.00,'2023-03-11 16:36:13','',''),(3640,'1','303','1',1,'Retail Sale Id 3529',2880.00,0.00,0.00,4.00,280.00,'2023-03-11 16:38:12','',''),(3641,'1','303','1',1,'Retail Sale Id 3530',1497.60,0.00,0.00,2.08,145.60,'2023-03-11 16:48:28','',''),(3642,'1','303','1',1,'Retail Sale Id 3531',4500.00,0.00,0.00,6.25,437.50,'2023-03-11 16:52:18','',''),(3643,'1','303','1',1,'Retail Sale Id 3532',1497.60,0.00,0.00,2.08,145.60,'2023-03-11 16:55:27','',''),(3644,'1','303','1',1,'Retail Sale Id 3533',9000.00,0.00,0.00,12.50,875.00,'2023-03-11 16:57:16','',''),(3645,'1','303','1',1,'Retail Sale Id 3534',2160.00,0.00,0.00,3.00,210.00,'2023-03-11 17:00:26','',''),(3646,'1','303','1',1,'Retail Sale Id 3535',2160.00,0.00,0.00,3.00,210.00,'2023-03-11 17:06:50','',''),(3647,'1','303','1',1,'Retail Sale Id 3536',12960.00,0.00,0.00,18.00,1260.00,'2023-03-11 17:08:43','',''),(3648,'1','303','1',1,'Retail Sale Id 3537',4320.00,0.00,0.00,6.00,420.00,'2023-03-11 17:11:48','',''),(3649,'1','303','1',1,'Retail Sale Id 3538',4320.00,0.00,0.00,6.00,420.00,'2023-03-11 17:18:07','',''),(3650,'1','303','1',1,'Retail Sale Id 3539',2880.00,0.00,0.00,4.00,280.00,'2023-03-11 17:24:50','',''),(3651,'1','303','1',1,'Retail Sale Id 3540',2160.00,0.00,0.00,3.00,210.00,'2023-03-11 17:32:48','',''),(3652,'1','303','1',1,'Retail Sale Id 3541',2160.00,0.00,0.00,3.00,210.00,'2023-03-11 17:40:39','',''),(3653,'1','303','1',1,'Retail Sale Id 3542',2160.00,0.00,0.00,3.00,210.00,'2023-03-11 17:46:32','',''),(3654,'1','303','1',1,'Retail Sale Id 3543',2160.00,0.00,0.00,3.00,210.00,'2023-03-11 17:49:17','',''),(3655,'1','303','1',1,'Retail Sale Id 3544',2880.00,0.00,0.00,4.00,280.00,'2023-03-11 17:50:27','',''),(3656,'1','303','1',1,'Retail Sale Id 3545',690000.00,0.00,0.00,1000.00,40000.00,'2023-03-11 18:33:26','',''),(3657,'1','303','1',1,'Retail Sale Id 3546',249919.20,0.00,0.00,347.11,24297.70,'2023-03-11 19:21:39','',''),(3658,'1','303','1',1,'Return of Retail Sale Id 3546',0.00,249919.20,347.11,0.00,-24297.70,'2023-03-11 19:23:41','',''),(3659,'1','303','1',1,'Return of Retail Sale Id 3536',0.00,12960.00,18.00,0.00,-1260.00,'2023-03-11 19:33:48','',''),(3660,'1','303','1',1,'Return of Retail Sale Id 3528',0.00,2160.00,3.00,0.00,-210.00,'2023-03-11 19:36:41','',''),(3661,'1','303','1',1,'Return of Retail Sale Id 3528',0.00,9000.00,12.50,0.00,-875.00,'2023-03-11 19:36:41','',''),(3662,'1','303','1',1,'Return of Retail Sale Id 3544',0.00,2880.00,4.00,0.00,-280.00,'2023-03-11 19:37:53','',''),(3663,'1','303','1',1,'Return of Retail Sale Id 3542',0.00,2160.00,3.00,0.00,-210.00,'2023-03-11 19:39:55','',''),(3664,'1','303','1',1,'Return of Retail Sale Id 3529',0.00,2880.00,4.00,0.00,-280.00,'2023-03-11 19:40:36','',''),(3665,'1','303','1',1,'Return of Retail Sale Id 3538',0.00,4320.00,6.00,0.00,-420.00,'2023-03-11 19:41:50','',''),(3666,'1','303','1',1,'Return of Retail Sale Id 3541',0.00,2160.00,3.00,0.00,-210.00,'2023-03-11 19:43:14','',''),(3667,'1','303','1',1,'Return of Retail Sale Id 3537',0.00,4320.00,6.00,0.00,-420.00,'2023-03-11 19:43:58','',''),(3668,'1','303','1',1,'Return of Retail Sale Id 3531',0.00,4500.00,6.25,0.00,-437.50,'2023-03-11 19:45:39','',''),(3669,'1','303','1',1,'Return of Retail Sale Id 3533',0.00,9000.00,12.50,0.00,-875.00,'2023-03-11 19:46:39','',''),(3670,'1','303','1',1,'Return of Retail Sale Id 3522',0.00,1000.80,1.39,0.00,-97.30,'2023-03-11 19:47:34','',''),(3671,'1','303','1',1,'Return of Retail Sale Id 3494',0.00,18000.00,25.00,0.00,-1750.00,'2023-03-11 19:48:48','',''),(3672,'1','303','1',1,'Return of Retail Sale Id 3501',0.00,9000.00,12.50,0.00,-875.00,'2023-03-11 19:49:50','',''),(3673,'1','303','1',1,'Return of Retail Sale Id 3508',0.00,6480.00,9.00,0.00,-630.00,'2023-03-11 19:51:12','',''),(3674,'1','303','1',1,'Return of Retail Sale Id 3525',0.00,4320.00,6.00,0.00,-420.00,'2023-03-11 20:04:52','',''),(3675,'1','303','1',1,'Return of Retail Sale Id 3478',0.00,9000.00,12.50,0.00,-875.00,'2023-03-11 20:05:45','',''),(3676,'1','303','1',1,'Return of Retail Sale Id 3477',0.00,9000.00,12.50,0.00,-875.00,'2023-03-11 20:06:27','',''),(3677,'1','303','1',1,'Return of Retail Sale Id 3475',0.00,9000.00,12.50,0.00,-875.00,'2023-03-11 20:07:38','',''),(3678,'1','303','1',1,'Return of Retail Sale Id 3496',0.00,4320.00,6.00,0.00,-420.00,'2023-03-11 20:08:32','',''),(3679,'1','303','1',1,'Return of Retail Sale Id 3535',0.00,2160.00,3.00,0.00,-210.00,'2023-03-11 20:09:23','',''),(3680,'1','303','1',1,'Return of Retail Sale Id 3474',0.00,4320.00,6.00,0.00,-420.00,'2023-03-11 20:10:09','',''),(3681,'1','303','1',1,'Return of Retail Sale Id 3502',0.00,4320.00,6.00,0.00,-420.00,'2023-03-11 20:11:20','',''),(3682,'1','303','1',1,'Return of Retail Sale Id 3495',0.00,3002.40,4.17,0.00,-291.90,'2023-03-11 20:12:15','',''),(3683,'1','303','1',1,'Return of Retail Sale Id 3486',0.00,4320.00,6.00,0.00,-420.00,'2023-03-11 20:13:24','',''),(3684,'1','303','1',1,'Return of Retail Sale Id 3486',0.00,7200.00,10.00,0.00,-700.00,'2023-03-11 20:13:24','',''),(3685,'1','303','1',1,'Return of Retail Sale Id 3492',0.00,4320.00,6.00,0.00,-420.00,'2023-03-11 20:15:33','',''),(3686,'1','303','1',1,'Return of Retail Sale Id 3532',0.00,1497.60,2.08,0.00,-145.60,'2023-03-11 20:16:53','',''),(3687,'1','303','1',1,'Return of Retail Sale Id 3485',0.00,6480.00,9.00,0.00,-630.00,'2023-03-11 20:18:19','',''),(3688,'1','303','1',1,'Retail Sale Id 3547',164116.80,0.00,0.00,227.94,15955.80,'2023-03-11 20:26:48','',''),(3689,'1','303','1',1,'Retail Sale Id 3548',4320.00,0.00,0.00,6.00,420.00,'2023-03-12 08:04:28','',''),(3690,'1','303','1',1,'Retail Sale Id 3549',4320.00,0.00,0.00,6.00,420.00,'2023-03-12 08:23:17','',''),(3691,'1','303','1',1,'Retail Sale Id 3550',3600.00,0.00,0.00,5.00,350.00,'2023-03-12 08:41:53','',''),(3692,'1','303','1',1,'Retail Sale Id 3551',4320.00,0.00,0.00,6.00,420.00,'2023-03-12 08:43:09','',''),(3693,'1','303','1',1,'Retail Sale Id 3552',3600.00,0.00,0.00,5.00,350.00,'2023-03-12 09:01:04','',''),(3694,'1','303','1',1,'Retail Sale Id 3553',7200.00,0.00,0.00,10.00,700.00,'2023-03-12 09:09:56','',''),(3695,'1','303','1',1,'Retail Sale Id 3554',18000.00,0.00,0.00,25.00,1750.00,'2023-03-12 09:17:29','',''),(3696,'1','303','1',1,'Retail Sale Id 3555',3600.00,0.00,0.00,5.00,350.00,'2023-03-12 09:25:32','',''),(3697,'1','303','1',1,'Retail Sale Id 3556',9000.00,0.00,0.00,12.50,875.00,'2023-03-12 09:27:42','',''),(3698,'1','303','1',1,'Retail Sale Id 3557',2001.60,0.00,0.00,2.78,194.60,'2023-03-12 09:28:31','',''),(3699,'1','303','1',1,'Retail Sale Id 3558',69000.00,0.00,0.00,100.00,4000.00,'2023-03-12 10:12:14','',''),(3700,'1','303','1',1,'Retail Sale Id 3559',3600.00,0.00,0.00,5.00,350.00,'2023-03-12 10:16:05','',''),(3701,'1','303','1',1,'Retail Sale Id 3560',4320.00,0.00,0.00,6.00,420.00,'2023-03-12 10:27:16','',''),(3702,'1','303','1',1,'Retail Sale Id 3561',131100.00,0.00,0.00,190.00,7600.00,'2023-03-12 10:30:52','',''),(3703,'1','303','1',1,'Retail Sale Id 3562',2160.00,0.00,0.00,3.00,210.00,'2023-03-12 10:39:15','',''),(3704,'1','303','1',1,'Retail Sale Id 3563',1000.80,0.00,0.00,1.39,97.30,'2023-03-12 10:40:49','',''),(3705,'1','303','1',1,'Retail Sale Id 3564',3600.00,0.00,0.00,5.00,350.00,'2023-03-12 10:51:42','',''),(3706,'1','303','1',1,'Retail Sale Id 3565',3600.00,0.00,0.00,5.00,350.00,'2023-03-12 10:58:56','',''),(3707,'1','303','1',1,'Retail Sale Id 3565',3600.00,0.00,0.00,5.00,350.00,'2023-03-12 10:58:56','',''),(3708,'1','303','1',1,'Retail Sale Id 3565',3600.00,0.00,0.00,5.00,350.00,'2023-03-12 10:58:56','',''),(3709,'1','303','1',1,'Retail Sale Id 3566',2160.00,0.00,0.00,3.00,210.00,'2023-03-12 11:01:21','',''),(3710,'1','303','1',1,'Retail Sale Id 3567',4320.00,0.00,0.00,6.00,420.00,'2023-03-12 11:04:07','',''),(3711,'1','303','1',1,'Retail Sale Id 3567',7200.00,0.00,0.00,10.00,700.00,'2023-03-12 11:04:07','',''),(3712,'1','303','1',1,'Retail Sale Id 3568',4320.00,0.00,0.00,6.00,420.00,'2023-03-12 11:06:14','',''),(3713,'1','303','1',1,'Retail Sale Id 3569',18000.00,0.00,0.00,25.00,1750.00,'2023-03-12 11:07:25','',''),(3714,'1','303','1',1,'Retail Sale Id 3570',138000.00,0.00,0.00,200.00,8000.00,'2023-03-12 11:12:06','',''),(3715,'1','303','1',1,'Retail Sale Id 3571',7999.20,0.00,0.00,11.11,777.70,'2023-03-12 11:27:16','',''),(3716,'1','303','1',1,'Retail Sale Id 3572',2001.60,0.00,0.00,2.78,194.60,'2023-03-12 11:32:03','',''),(3717,'1','303','1',1,'Retail Sale Id 3573',2160.00,0.00,0.00,3.00,210.00,'2023-03-12 11:33:52','',''),(3718,'1','303','1',1,'Retail Sale Id 3574',1000.80,0.00,0.00,1.39,97.30,'2023-03-12 11:43:01','',''),(3719,'1','303','1',1,'Retail Sale Id 3575',69000.00,0.00,0.00,100.00,4000.00,'2023-03-12 11:49:07','',''),(3720,'1','303','1',1,'Retail Sale Id 3576',2203.20,0.00,0.00,3.06,214.20,'2023-03-12 12:08:13','',''),(3721,'1','303','1',1,'Retail Sale Id 3577',4320.00,0.00,0.00,6.00,420.00,'2023-03-12 12:21:12','',''),(3722,'1','303','1',1,'Retail Sale Id 3578',3600.00,0.00,0.00,5.00,350.00,'2023-03-12 12:24:29','',''),(3723,'1','303','1',1,'Retail Sale Id 3579',4320.00,0.00,0.00,6.00,420.00,'2023-03-12 12:26:46','',''),(3724,'1','303','1',1,'Retail Sale Id 3580',1440.00,0.00,0.00,2.00,140.00,'2023-03-12 12:31:20','',''),(3725,'1','303','1',1,'Retail Sale Id 3580',2160.00,0.00,0.00,3.00,210.00,'2023-03-12 12:31:20','',''),(3726,'1','303','1',1,'Retail Sale Id 3581',2160.00,0.00,0.00,3.00,210.00,'2023-03-12 12:33:20','',''),(3727,'1','303','1',1,'Retail Sale Id 3582',9000.00,0.00,0.00,12.50,875.00,'2023-03-12 12:34:39','',''),(3728,'1','303','1',1,'Retail Sale Id 3583',4003.20,0.00,0.00,5.56,389.20,'2023-03-12 12:36:44','',''),(3729,'1','303','1',1,'Retail Sale Id 3584',9000.00,0.00,0.00,12.50,875.00,'2023-03-12 12:40:09','',''),(3730,'1','303','1',1,'Retail Sale Id 3585',3600.00,0.00,0.00,5.00,350.00,'2023-03-12 12:50:34','',''),(3731,'1','303','1',1,'Retail Sale Id 3586',9000.00,0.00,0.00,12.50,875.00,'2023-03-12 12:52:48','',''),(3732,'1','303','1',1,'Retail Sale Id 3587',4320.00,0.00,0.00,6.00,420.00,'2023-03-12 12:56:27','',''),(3733,'1','303','1',1,'Retail Sale Id 3588',69000.00,0.00,0.00,100.00,4000.00,'2023-03-12 13:21:13','',''),(3734,'1','303','1',1,'Retail Sale Id 3589',4320.00,0.00,0.00,6.00,420.00,'2023-03-12 13:29:04','',''),(3735,'1','303','1',1,'Retail Sale Id 3590',4320.00,0.00,0.00,6.00,420.00,'2023-03-12 13:39:22','',''),(3736,'1','303','1',1,'Retail Sale Id 3591',34500.00,0.00,0.00,50.00,2000.00,'2023-03-12 13:42:49','',''),(3737,'1','303','1',1,'Retail Sale Id 3592',34500.00,0.00,0.00,50.00,2000.00,'2023-03-12 13:44:13','',''),(3738,'1','303','1',1,'Retail Sale Id 3593',4320.00,0.00,0.00,6.00,420.00,'2023-03-12 13:58:51','',''),(3739,'1','303','1',1,'Retail Sale Id 3594',1440.00,0.00,0.00,2.00,140.00,'2023-03-12 14:12:36','',''),(3740,'1','303','1',1,'Retail Sale Id 3595',3600.00,0.00,0.00,5.00,350.00,'2023-03-12 14:46:57','',''),(3741,'1','303','1',1,'Retail Sale Id 3595',4399.20,0.00,0.00,6.11,427.70,'2023-03-12 14:46:57','',''),(3742,'1','303','1',1,'Retail Sale Id 3596',4320.00,0.00,0.00,6.00,420.00,'2023-03-12 14:48:45','',''),(3743,'1','303','1',1,'Retail Sale Id 3597',4320.00,0.00,0.00,6.00,420.00,'2023-03-12 14:53:24','',''),(3744,'1','303','1',1,'Retail Sale Id 3597',4320.00,0.00,0.00,6.00,420.00,'2023-03-12 14:53:24','',''),(3745,'1','303','1',1,'Retail Sale Id 3598',5040.00,0.00,0.00,7.00,490.00,'2023-03-12 14:56:21','',''),(3746,'1','303','1',1,'Retail Sale Id 3599',1000.80,0.00,0.00,1.39,97.30,'2023-03-12 15:07:51','',''),(3747,'1','303','1',1,'Retail Sale Id 3600',4320.00,0.00,0.00,6.00,420.00,'2023-03-12 15:16:46','',''),(3748,'1','303','1',1,'Retail Sale Id 3601',34500.00,0.00,0.00,50.00,2000.00,'2023-03-12 15:28:20','',''),(3749,'1','303','1',1,'Retail Sale Id 3602',2001.60,0.00,0.00,2.78,194.60,'2023-03-12 15:32:11','',''),(3750,'1','303','1',1,'Retail Sale Id 3603',1440.00,0.00,0.00,2.00,140.00,'2023-03-12 15:34:51','',''),(3751,'1','303','1',1,'Retail Sale Id 3604',799.20,0.00,0.00,1.11,77.70,'2023-03-12 15:38:36','',''),(3752,'1','303','1',1,'Retail Sale Id 3605',2498.40,0.00,0.00,3.47,242.90,'2023-03-12 15:42:52','',''),(3753,'1','303','1',1,'Retail Sale Id 3606',1000.80,0.00,0.00,1.39,97.30,'2023-03-12 16:12:14','',''),(3754,'1','303','1',1,'Retail Sale Id 3607',2160.00,0.00,0.00,3.00,210.00,'2023-03-12 16:24:22','',''),(3755,'1','303','1',1,'Retail Sale Id 3608',4320.00,0.00,0.00,6.00,420.00,'2023-03-12 16:32:29','',''),(3756,'1','303','1',1,'Retail Sale Id 3609',4320.00,0.00,0.00,6.00,420.00,'2023-03-12 16:42:48','',''),(3757,'1','303','1',1,'Retail Sale Id 3610',4320.00,0.00,0.00,6.00,420.00,'2023-03-12 16:45:29','',''),(3758,'1','303','1',1,'Retail Sale Id 3611',1396.80,0.00,0.00,1.94,135.80,'2023-03-12 16:52:51','',''),(3759,'1','303','1',1,'Retail Sale Id 3612',1000.80,0.00,0.00,1.39,97.30,'2023-03-12 16:58:21','',''),(3760,'1','303','1',1,'Retail Sale Id 3613',3002.40,0.00,0.00,4.17,291.90,'2023-03-12 17:00:28','',''),(3761,'1','303','1',1,'Retail Sale Id 3614',4320.00,0.00,0.00,6.00,420.00,'2023-03-12 17:10:02','',''),(3762,'1','303','1',1,'Retail Sale Id 3615',2160.00,0.00,0.00,3.00,210.00,'2023-03-12 17:11:58','',''),(3763,'1','303','1',1,'Retail Sale Id 3616',9000.00,0.00,0.00,12.50,875.00,'2023-03-12 17:19:08','',''),(3764,'1','303','1',1,'Retail Sale Id 3617',2160.00,0.00,0.00,3.00,210.00,'2023-03-12 17:21:30','',''),(3765,'1','303','1',1,'Retail Sale Id 3618',4320.00,0.00,0.00,6.00,420.00,'2023-03-12 17:29:57','',''),(3766,'1','303','1',1,'Retail Sale Id 3619',2160.00,0.00,0.00,3.00,210.00,'2023-03-12 17:35:27','',''),(3767,'1','303','1',1,'Retail Sale Id 3620',2880.00,0.00,0.00,4.00,280.00,'2023-03-12 18:01:56','',''),(3768,'1','303','1',1,'Return of Retail Sale Id 3612',0.00,1000.80,1.39,0.00,-97.30,'2023-03-12 18:47:50','',''),(3769,'1','303','1',1,'Retail Sale Id 3621',950.40,0.00,0.00,1.32,92.40,'2023-03-12 18:48:44','',''),(3770,'1','303','1',1,'Retail Sale Id 3622',4320.00,0.00,0.00,6.00,420.00,'2023-03-13 08:13:07','',''),(3771,'1','303','1',1,'Retail Sale Id 3623',9000.00,0.00,0.00,12.50,875.00,'2023-03-13 08:21:00','',''),(3772,'1','303','1',1,'Retail Sale Id 3624',3002.40,0.00,0.00,4.17,291.90,'2023-03-13 08:22:42','',''),(3773,'1','303','1',1,'Retail Sale Id 3625',4320.00,0.00,0.00,6.00,420.00,'2023-03-13 08:23:47','',''),(3774,'1','303','1',1,'Retail Sale Id 3626',3600.00,0.00,0.00,5.00,350.00,'2023-03-13 08:55:01','',''),(3775,'1','303','1',1,'Retail Sale Id 3627',2001.60,0.00,0.00,2.78,194.60,'2023-03-13 08:59:26','',''),(3776,'1','303','1',1,'Retail Sale Id 3628',2160.00,0.00,0.00,3.00,210.00,'2023-03-13 09:01:01','',''),(3777,'1','303','1',1,'Retail Sale Id 3629',4320.00,0.00,0.00,6.00,420.00,'2023-03-13 09:05:14','',''),(3778,'1','303','1',1,'Retail Sale Id 3630',6480.00,0.00,0.00,9.00,630.00,'2023-03-13 09:09:23','',''),(3779,'1','303','1',1,'Retail Sale Id 3631',4320.00,0.00,0.00,6.00,420.00,'2023-03-13 09:13:58','',''),(3780,'1','303','1',1,'Retail Sale Id 3632',7920.00,0.00,0.00,11.00,770.00,'2023-03-13 09:37:22','',''),(3781,'1','303','1',1,'Retail Sale Id 3633',2160.00,0.00,0.00,3.00,210.00,'2023-03-13 09:43:55','',''),(3782,'1','303','1',1,'Retail Sale Id 3634',1497.60,0.00,0.00,2.08,145.60,'2023-03-13 09:47:01','',''),(3783,'1','303','1',1,'Retail Sale Id 3635',27600.00,0.00,0.00,40.00,1600.00,'2023-03-13 09:52:37','',''),(3784,'1','303','1',1,'Retail Sale Id 3636',34500.00,0.00,0.00,50.00,2000.00,'2023-03-13 10:04:36','',''),(3785,'1','303','1',1,'Retail Sale Id 3637',2160.00,0.00,0.00,3.00,210.00,'2023-03-13 10:07:14','',''),(3786,'1','303','1',1,'Retail Sale Id 3638',2001.60,0.00,0.00,2.78,194.60,'2023-03-13 10:08:47','',''),(3787,'1','303','1',1,'Retail Sale Id 3639',1000.80,0.00,0.00,1.39,97.30,'2023-03-13 10:11:39','',''),(3788,'1','303','1',1,'Retail Sale Id 3640',34500.00,0.00,0.00,50.00,2000.00,'2023-03-13 10:17:02','',''),(3789,'1','303','1',1,'Retail Sale Id 3641',3600.00,0.00,0.00,5.00,350.00,'2023-03-13 10:26:49','',''),(3790,'1','303','1',1,'Retail Sale Id 3642',4320.00,0.00,0.00,6.00,420.00,'2023-03-13 10:38:09','',''),(3791,'1','303','1',1,'Retail Sale Id 3643',4320.00,0.00,0.00,6.00,420.00,'2023-03-13 10:40:56','',''),(3792,'1','303','1',1,'Retail Sale Id 3644',172500.00,0.00,0.00,250.00,10000.00,'2023-03-13 10:47:03','',''),(3793,'1','303','1',1,'Retail Sale Id 3645',40020.00,0.00,0.00,58.00,2320.00,'2023-03-13 10:50:04','',''),(3794,'1','303','1',1,'Retail Sale Id 3646',34500.00,0.00,0.00,50.00,2000.00,'2023-03-13 10:51:42','',''),(3795,'1','303','1',1,'Retail Sale Id 3647',1000.80,0.00,0.00,1.39,97.30,'2023-03-13 10:53:04','',''),(3796,'1','303','1',1,'Retail Sale Id 3648',2160.00,0.00,0.00,3.00,210.00,'2023-03-13 10:58:18','',''),(3797,'1','303','1',1,'Retail Sale Id 3649',698.40,0.00,0.00,0.97,67.90,'2023-03-13 11:00:27','',''),(3798,'1','303','1',1,'Retail Sale Id 3650',7920.00,0.00,0.00,11.00,770.00,'2023-03-13 11:12:59','',''),(3799,'1','303','1',1,'Retail Sale Id 3651',2160.00,0.00,0.00,3.00,210.00,'2023-03-13 11:16:44','',''),(3800,'1','303','1',1,'Retail Sale Id 3653',3600.00,0.00,0.00,5.00,350.00,'2023-03-13 11:25:04','',''),(3801,'1','303','1',1,'Retail Sale Id 3653',4320.00,0.00,0.00,6.00,420.00,'2023-03-13 11:25:04','',''),(3802,'1','303','1',1,'Retail Sale Id 3653',9000.00,0.00,0.00,12.50,875.00,'2023-03-13 11:25:04','',''),(3803,'1','303','1',1,'Retail Sale Id 3653',9000.00,0.00,0.00,12.50,875.00,'2023-03-13 11:25:04','',''),(3804,'1','303','1',1,'Retail Sale Id 3653',9000.00,0.00,0.00,12.50,875.00,'2023-03-13 11:25:04','',''),(3805,'1','303','1',1,'Retail Sale Id 3654',4320.00,0.00,0.00,6.00,420.00,'2023-03-13 11:30:56','',''),(3806,'1','303','1',1,'Retail Sale Id 3656',9000.00,0.00,0.00,12.50,875.00,'2023-03-13 11:35:43','',''),(3807,'1','303','1',1,'Retail Sale Id 3657',3600.00,0.00,0.00,5.00,350.00,'2023-03-13 11:37:43','',''),(3808,'1','303','1',1,'Retail Sale Id 3658',2160.00,0.00,0.00,3.00,210.00,'2023-03-13 11:39:27','',''),(3809,'1','303','1',1,'Retail Sale Id 3659',138000.00,0.00,0.00,200.00,8000.00,'2023-03-13 11:44:17','',''),(3810,'1','303','1',1,'Retail Sale Id 3660',2001.60,0.00,0.00,2.78,194.60,'2023-03-13 11:46:23','',''),(3811,'1','303','1',1,'Retail Sale Id 3661',69000.00,0.00,0.00,100.00,4000.00,'2023-03-13 11:49:28','',''),(3812,'1','303','1',1,'Retail Sale Id 3662',3600.00,0.00,0.00,5.00,350.00,'2023-03-13 11:58:07','',''),(3813,'1','303','1',1,'Retail Sale Id 3663',2160.00,0.00,0.00,3.00,210.00,'2023-03-13 12:02:42','',''),(3814,'1','303','1',1,'Retail Sale Id 3663',2160.00,0.00,0.00,3.00,210.00,'2023-03-13 12:02:42','',''),(3815,'1','303','1',1,'Retail Sale Id 3664',2160.00,0.00,0.00,3.00,210.00,'2023-03-13 12:08:35','',''),(3816,'1','303','1',1,'Retail Sale Id 3665',2203.20,0.00,0.00,3.06,214.20,'2023-03-13 12:21:51','',''),(3817,'1','303','1',1,'Retail Sale Id 3666',3600.00,0.00,0.00,5.00,350.00,'2023-03-13 12:25:34','',''),(3818,'1','303','1',1,'Retail Sale Id 3667',2001.60,0.00,0.00,2.78,194.60,'2023-03-13 12:27:14','',''),(3819,'1','303','1',1,'Retail Sale Id 3668',7200.00,0.00,0.00,10.00,700.00,'2023-03-13 12:28:43','',''),(3820,'1','303','1',1,'Retail Sale Id 3669',1497.60,0.00,0.00,2.08,145.60,'2023-03-13 12:35:03','',''),(3821,'1','303','1',1,'Retail Sale Id 3670',2152.80,0.00,0.00,2.99,209.30,'2023-03-13 12:52:09','',''),(3822,'1','303','1',1,'Retail Sale Id 3671',3600.00,0.00,0.00,5.00,350.00,'2023-03-13 13:02:03','',''),(3823,'1','303','1',1,'Retail Sale Id 3672',4320.00,0.00,0.00,6.00,420.00,'2023-03-13 13:04:09','',''),(3824,'1','303','1',1,'Retail Sale Id 3673',2160.00,0.00,0.00,3.00,210.00,'2023-03-13 13:08:03','',''),(3825,'1','303','1',1,'Retail Sale Id 3674',1440.00,0.00,0.00,2.00,140.00,'2023-03-13 13:25:27','',''),(3826,'1','303','1',1,'Retail Sale Id 3675',2160.00,0.00,0.00,3.00,210.00,'2023-03-13 13:32:44','',''),(3827,'1','303','1',1,'Retail Sale Id 3676',2880.00,0.00,0.00,4.00,280.00,'2023-03-13 13:38:20','',''),(3828,'1','303','1',1,'Retail Sale Id 3677',1440.00,0.00,0.00,2.00,140.00,'2023-03-13 13:46:35','',''),(3829,'1','303','1',1,'Retail Sale Id 3678',1497.60,0.00,0.00,2.08,145.60,'2023-03-13 13:51:00','',''),(3830,'1','303','1',1,'Retail Sale Id 3678',1497.60,0.00,0.00,2.08,145.60,'2023-03-13 13:51:00','',''),(3831,'1','303','1',1,'Retail Sale Id 3679',720.00,0.00,0.00,1.00,70.00,'2023-03-13 13:56:24','',''),(3832,'1','303','1',1,'Retail Sale Id 3680',3600.00,0.00,0.00,5.00,350.00,'2023-03-13 13:57:26','',''),(3833,'1','303','1',1,'Retail Sale Id 3681',3600.00,0.00,0.00,5.00,350.00,'2023-03-13 14:05:54','',''),(3834,'1','303','1',1,'Retail Sale Id 3682',2880.00,0.00,0.00,4.00,280.00,'2023-03-13 14:14:19','',''),(3835,'1','303','1',1,'Retail Sale Id 3684',3600.00,0.00,0.00,5.00,350.00,'2023-03-13 14:20:58','',''),(3836,'1','303','1',1,'Retail Sale Id 3685',7920.00,0.00,0.00,11.00,770.00,'2023-03-13 14:29:17','',''),(3837,'1','303','1',1,'Retail Sale Id 3686',4320.00,0.00,0.00,6.00,420.00,'2023-03-13 14:39:00','',''),(3838,'1','303','1',1,'Retail Sale Id 3687',1000.80,0.00,0.00,1.39,97.30,'2023-03-13 14:42:36','',''),(3839,'1','303','1',1,'Retail Sale Id 3688',1000.80,0.00,0.00,1.39,97.30,'2023-03-13 14:46:59','',''),(3840,'1','303','1',1,'Retail Sale Id 3689',2160.00,0.00,0.00,3.00,210.00,'2023-03-13 15:28:01','',''),(3841,'1','303','1',1,'Retail Sale Id 3690',207000.00,0.00,0.00,300.00,12000.00,'2023-03-13 15:31:11','',''),(3842,'1','303','1',1,'Retail Sale Id 3691',2160.00,0.00,0.00,3.00,210.00,'2023-03-13 15:32:23','',''),(3843,'1','303','1',1,'Retail Sale Id 3692',4320.00,0.00,0.00,6.00,420.00,'2023-03-13 15:33:34','',''),(3844,'1','303','1',1,'Retail Sale Id 3693',2160.00,0.00,0.00,3.00,210.00,'2023-03-13 15:34:25','',''),(3845,'1','303','1',1,'Retail Sale Id 3694',34500.00,0.00,0.00,50.00,2000.00,'2023-03-13 15:43:36','',''),(3846,'1','303','1',1,'Retail Sale Id 3695',4320.00,0.00,0.00,6.00,420.00,'2023-03-13 15:45:07','',''),(3847,'1','303','1',1,'Retail Sale Id 3695',6480.00,0.00,0.00,9.00,630.00,'2023-03-13 15:45:07','',''),(3848,'1','303','1',1,'Retail Sale Id 3695',9000.00,0.00,0.00,12.50,875.00,'2023-03-13 15:45:07','',''),(3849,'1','303','1',1,'Retail Sale Id 3696',2160.00,0.00,0.00,3.00,210.00,'2023-03-13 15:46:41','',''),(3850,'1','303','1',1,'Retail Sale Id 3697',1440.00,0.00,0.00,2.00,140.00,'2023-03-13 15:56:35','',''),(3851,'1','303','1',1,'Retail Sale Id 3698',9000.00,0.00,0.00,12.50,875.00,'2023-03-13 16:02:01','',''),(3852,'1','303','1',1,'Retail Sale Id 3699',4320.00,0.00,0.00,6.00,420.00,'2023-03-13 16:05:09','',''),(3853,'1','303','1',1,'Retail Sale Id 3700',4500.00,0.00,0.00,6.25,437.50,'2023-03-13 16:06:53','',''),(3854,'1','303','1',1,'Retail Sale Id 3701',4320.00,0.00,0.00,6.00,420.00,'2023-03-13 16:16:36','',''),(3855,'1','303','1',1,'Retail Sale Id 3702',9000.00,0.00,0.00,12.50,875.00,'2023-03-13 16:27:45','',''),(3856,'1','303','1',1,'Retail Sale Id 3703',2160.00,0.00,0.00,3.00,210.00,'2023-03-13 16:29:01','',''),(3857,'1','303','1',1,'Retail Sale Id 3704',4320.00,0.00,0.00,6.00,420.00,'2023-03-13 16:31:24','',''),(3858,'1','303','1',1,'Retail Sale Id 3705',1000.80,0.00,0.00,1.39,97.30,'2023-03-13 16:36:40','',''),(3859,'1','303','1',1,'Retail Sale Id 3706',4320.00,0.00,0.00,6.00,420.00,'2023-03-13 16:44:38','',''),(3860,'1','303','1',1,'Retail Sale Id 3707',1497.60,0.00,0.00,2.08,145.60,'2023-03-13 16:47:14','',''),(3861,'1','303','1',1,'Retail Sale Id 3709',2160.00,0.00,0.00,3.00,210.00,'2023-03-13 16:56:12','',''),(3862,'1','303','1',1,'Retail Sale Id 3709',9000.00,0.00,0.00,12.50,875.00,'2023-03-13 16:56:12','',''),(3863,'1','303','1',1,'Retail Sale Id 3710',3600.00,0.00,0.00,5.00,350.00,'2023-03-13 17:00:50','',''),(3864,'1','303','1',1,'Retail Sale Id 3711',2160.00,0.00,0.00,3.00,210.00,'2023-03-13 17:02:05','',''),(3865,'1','303','1',1,'Retail Sale Id 3712',1000.80,0.00,0.00,1.39,97.30,'2023-03-13 17:09:22','',''),(3866,'1','303','1',1,'Retail Sale Id 3713',2203.20,0.00,0.00,3.06,214.20,'2023-03-13 17:42:07','',''),(3867,'1','303','1',1,'Retail Sale Id 3714',2160.00,0.00,0.00,3.00,210.00,'2023-03-13 17:44:51','',''),(3868,'1','303','1',1,'Retail Sale Id 3715',4320.00,0.00,0.00,6.00,420.00,'2023-03-13 17:48:59','',''),(3869,'1','303','1',1,'Retail Sale Id 3716',4348.80,0.00,0.00,6.04,422.80,'2023-03-13 17:51:42','',''),(3870,'1','303','1',1,'Retail Sale Id 3717',2160.00,0.00,0.00,3.00,210.00,'2023-03-13 17:54:08','',''),(3871,'1','303','1',1,'Retail Sale Id 3718',3002.40,0.00,0.00,4.17,291.90,'2023-03-13 17:58:39','',''),(3872,'1','303','1',1,'Retail Sale Id 3719',2001.60,0.00,0.00,2.78,194.60,'2023-03-13 18:05:13','',''),(3873,'1','303','1',1,'Retail Sale Id 3720',1202.40,0.00,0.00,1.67,116.90,'2023-03-13 18:07:57','',''),(3874,'1','303','1',1,'Retail Sale Id 3721',1202.40,0.00,0.00,1.67,116.90,'2023-03-13 18:12:00','',''),(3875,'1','303','1',1,'Retail Sale Id 3722',69000.00,0.00,0.00,100.00,4000.00,'2023-03-13 18:13:08','',''),(3876,'1','303','1',1,'Retail Sale Id 3723',1000.80,0.00,0.00,1.39,97.30,'2023-03-13 18:32:36','',''),(3877,'1','303','1',1,'Retail Sale Id 3724',720.00,0.00,0.00,1.00,70.00,'2023-03-13 18:43:11','',''),(3878,'1','303','1',1,'Return of Retail Sale Id 3718',0.00,3002.40,4.17,0.00,-291.90,'2023-03-13 19:15:33','',''),(3879,'1','303','1',1,'Retail Sale Id 3725',712.80,0.00,0.00,0.99,69.30,'2023-03-13 19:16:24','',''),(3880,'1','303','1',1,'Return of Retail Sale Id 3720',0.00,1202.40,1.67,0.00,-116.90,'2023-03-13 19:20:02','',''),(3881,'1','303','1',1,'Retail Sale Id 3726',136.80,0.00,0.00,0.19,13.30,'2023-03-13 19:20:52','',''),(3882,'1','303','1',1,'Retail Sale Id 3727',9000.00,0.00,0.00,12.50,875.00,'2023-03-14 08:24:37','',''),(3883,'1','303','1',1,'Retail Sale Id 3728',2649.60,0.00,0.00,3.68,257.60,'2023-03-14 08:32:34','',''),(3884,'1','303','1',1,'Retail Sale Id 3729',34500.00,0.00,0.00,50.00,2000.00,'2023-03-14 09:03:31','',''),(3885,'1','303','1',1,'Retail Sale Id 3730',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 09:05:34','',''),(3886,'1','303','1',1,'Retail Sale Id 3731',8640.00,0.00,0.00,12.00,840.00,'2023-03-14 09:15:03','',''),(3887,'1','303','1',1,'Retail Sale Id 3732',2160.00,0.00,0.00,3.00,210.00,'2023-03-14 09:31:23','',''),(3888,'1','303','1',1,'Retail Sale Id 3733',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 09:36:27','',''),(3889,'1','303','1',1,'Retail Sale Id 3734',1000.80,0.00,0.00,1.39,97.30,'2023-03-14 09:52:11','',''),(3890,'1','303','1',1,'Retail Sale Id 3735',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 10:01:08','',''),(3891,'1','303','1',1,'Retail Sale Id 3736',2160.00,0.00,0.00,3.00,210.00,'2023-03-14 10:03:21','',''),(3892,'1','303','1',1,'Retail Sale Id 3737',69000.00,0.00,0.00,100.00,4000.00,'2023-03-14 10:08:58','',''),(3893,'1','303','1',1,'Retail Sale Id 3738',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 10:10:43','',''),(3894,'1','303','1',1,'Retail Sale Id 3739',7200.00,0.00,0.00,10.00,700.00,'2023-03-14 10:12:40','',''),(3895,'1','303','1',1,'Retail Sale Id 3740',2160.00,0.00,0.00,3.00,210.00,'2023-03-14 10:18:40','',''),(3896,'1','303','1',1,'Retail Sale Id 3741',34500.00,0.00,0.00,50.00,2000.00,'2023-03-14 10:45:34','',''),(3897,'1','303','1',1,'Retail Sale Id 3742',2160.00,0.00,0.00,3.00,210.00,'2023-03-14 10:46:34','',''),(3898,'1','303','1',1,'Retail Sale Id 3743',34500.00,0.00,0.00,50.00,2000.00,'2023-03-14 11:11:33','',''),(3899,'1','303','1',1,'Retail Sale Id 3744',2160.00,0.00,0.00,3.00,210.00,'2023-03-14 11:15:55','',''),(3900,'1','303','1',1,'Retail Sale Id 3744',2160.00,0.00,0.00,3.00,210.00,'2023-03-14 11:15:55','',''),(3901,'1','303','1',1,'Retail Sale Id 3744',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 11:15:55','',''),(3902,'1','303','1',1,'Retail Sale Id 3745',2001.60,0.00,0.00,2.78,194.60,'2023-03-14 11:29:15','',''),(3903,'1','303','1',1,'Retail Sale Id 3746',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 11:31:03','',''),(3904,'1','303','1',1,'Retail Sale Id 3747',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 11:35:46','',''),(3905,'1','303','1',1,'Retail Sale Id 3747',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 11:35:46','',''),(3906,'1','303','1',1,'Retail Sale Id 3748',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 11:39:36','',''),(3907,'1','303','1',1,'Retail Sale Id 3749',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 11:41:28','',''),(3908,'1','303','1',1,'Retail Sale Id 3750',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 11:50:37','',''),(3909,'1','303','1',1,'Retail Sale Id 3751',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 12:01:32','',''),(3910,'1','303','1',1,'Retail Sale Id 3752',9000.00,0.00,0.00,12.50,875.00,'2023-03-14 12:07:38','',''),(3911,'1','303','1',1,'Retail Sale Id 3753',34500.00,0.00,0.00,50.00,2000.00,'2023-03-14 12:10:52','',''),(3912,'1','303','1',1,'Retail Sale Id 3754',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 12:23:02','',''),(3913,'1','303','1',1,'Retail Sale Id 3755',1000.80,0.00,0.00,1.39,97.30,'2023-03-14 12:34:31','',''),(3914,'1','303','1',1,'Retail Sale Id 3756',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 12:36:13','',''),(3915,'1','303','1',1,'Retail Sale Id 3757',496.80,0.00,0.00,0.69,48.30,'2023-03-14 12:40:54','',''),(3916,'1','303','1',1,'Retail Sale Id 3758',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 12:47:03','',''),(3917,'1','303','1',1,'Retail Sale Id 3759',34500.00,0.00,0.00,50.00,2000.00,'2023-03-14 13:04:16','',''),(3918,'1','303','1',1,'Retail Sale Id 3760',2160.00,0.00,0.00,3.00,210.00,'2023-03-14 13:05:58','',''),(3919,'1','303','1',1,'Retail Sale Id 3761',2001.60,0.00,0.00,2.78,194.60,'2023-03-14 13:13:49','',''),(3920,'1','303','1',1,'Retail Sale Id 3762',720.00,0.00,0.00,1.00,70.00,'2023-03-14 13:30:20','',''),(3921,'1','303','1',1,'Retail Sale Id 3762',3600.00,0.00,0.00,5.00,350.00,'2023-03-14 13:30:20','',''),(3922,'1','303','1',1,'Retail Sale Id 3763',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 13:36:19','',''),(3923,'1','303','1',1,'Retail Sale Id 3764',2160.00,0.00,0.00,3.00,210.00,'2023-03-14 13:38:49','',''),(3924,'1','303','1',1,'Retail Sale Id 3765',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 13:53:59','',''),(3925,'1','303','1',1,'Retail Sale Id 3766',40020.00,0.00,0.00,58.00,2320.00,'2023-03-14 14:03:04','',''),(3926,'1','303','1',1,'Retail Sale Id 3767',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 14:22:49','',''),(3927,'1','303','1',1,'Retail Sale Id 3768',3499.20,0.00,0.00,4.86,340.20,'2023-03-14 14:25:37','',''),(3928,'1','303','1',1,'Retail Sale Id 3769',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 14:38:59','',''),(3929,'1','303','1',1,'Retail Sale Id 3770',2160.00,0.00,0.00,3.00,210.00,'2023-03-14 14:44:04','',''),(3930,'1','303','1',1,'Retail Sale Id 3770',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 14:44:04','',''),(3931,'1','303','1',1,'Retail Sale Id 3771',1000.80,0.00,0.00,1.39,97.30,'2023-03-14 14:52:02','',''),(3932,'1','303','1',1,'Retail Sale Id 3772',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 15:02:36','',''),(3933,'1','303','1',1,'Retail Sale Id 3773',9000.00,0.00,0.00,12.50,875.00,'2023-03-14 15:09:06','',''),(3934,'1','303','1',1,'Retail Sale Id 3774',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 15:12:22','',''),(3935,'1','303','1',1,'Retail Sale Id 3775',2160.00,0.00,0.00,3.00,210.00,'2023-03-14 15:14:51','',''),(3936,'1','303','1',1,'Retail Sale Id 3776',1000.80,0.00,0.00,1.39,97.30,'2023-03-14 15:24:55','',''),(3937,'1','303','1',1,'Retail Sale Id 3777',9000.00,0.00,0.00,12.50,875.00,'2023-03-14 15:26:14','',''),(3938,'1','303','1',1,'Retail Sale Id 3778',2160.00,0.00,0.00,3.00,210.00,'2023-03-14 15:41:24','',''),(3939,'1','303','1',1,'Retail Sale Id 3779',3002.40,0.00,0.00,4.17,291.90,'2023-03-14 15:44:58','',''),(3940,'1','303','1',1,'Retail Sale Id 3780',2160.00,0.00,0.00,3.00,210.00,'2023-03-14 16:02:37','',''),(3941,'1','303','1',1,'Retail Sale Id 3781',2001.60,0.00,0.00,2.78,194.60,'2023-03-14 16:14:06','',''),(3942,'1','303','1',1,'Retail Sale Id 3782',3002.40,0.00,0.00,4.17,291.90,'2023-03-14 16:16:08','',''),(3943,'1','303','1',1,'Retail Sale Id 3783',1440.00,0.00,0.00,2.00,140.00,'2023-03-14 16:19:46','',''),(3944,'1','303','1',1,'Retail Sale Id 3784',2160.00,0.00,0.00,3.00,210.00,'2023-03-14 16:23:34','',''),(3945,'1','303','1',1,'Retail Sale Id 3785',2160.00,0.00,0.00,3.00,210.00,'2023-03-14 16:28:48','',''),(3946,'1','303','1',1,'Retail Sale Id 3786',9000.00,0.00,0.00,12.50,875.00,'2023-03-14 16:32:11','',''),(3947,'1','303','1',1,'Retail Sale Id 3786',9000.00,0.00,0.00,12.50,875.00,'2023-03-14 16:32:11','',''),(3948,'1','303','1',1,'Retail Sale Id 3787',2160.00,0.00,0.00,3.00,210.00,'2023-03-14 16:51:50','',''),(3949,'1','303','1',1,'Retail Sale Id 3788',9000.00,0.00,0.00,12.50,875.00,'2023-03-14 16:54:59','',''),(3950,'1','303','1',1,'Retail Sale Id 3789',7999.20,0.00,0.00,11.11,777.70,'2023-03-14 17:04:54','',''),(3951,'1','303','1',1,'Retail Sale Id 3790',1440.00,0.00,0.00,2.00,140.00,'2023-03-14 17:20:56','',''),(3952,'1','303','1',1,'Retail Sale Id 3791',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 17:29:18','',''),(3953,'1','303','1',1,'Retail Sale Id 3792',2880.00,0.00,0.00,4.00,280.00,'2023-03-14 17:31:56','',''),(3954,'1','303','1',1,'Retail Sale Id 3793',34500.00,0.00,0.00,50.00,2000.00,'2023-03-14 17:36:22','',''),(3955,'1','303','1',1,'Retail Sale Id 3794',4320.00,0.00,0.00,6.00,420.00,'2023-03-14 17:37:30','',''),(3956,'1','303','1',1,'Retail Sale Id 3795',2160.00,0.00,0.00,3.00,210.00,'2023-03-14 17:40:27','',''),(3957,'1','303','1',1,'Retail Sale Id 3795',2160.00,0.00,0.00,3.00,210.00,'2023-03-14 17:40:27','',''),(3958,'1','303','1',1,'Retail Sale Id 3796',892.80,0.00,0.00,1.24,86.80,'2023-03-14 19:23:28','',''),(3959,'1','303','1',1,'Retail Sale Id 3797',24840.00,0.00,0.00,36.00,1440.00,'2023-03-15 07:34:06','',''),(3960,'1','303','1',1,'Retail Sale Id 3798',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 07:43:15','',''),(3961,'1','303','1',1,'Retail Sale Id 3799',2160.00,0.00,0.00,3.00,210.00,'2023-03-15 07:46:13','',''),(3962,'1','303','1',1,'Retail Sale Id 3800',3002.40,0.00,0.00,4.17,291.90,'2023-03-15 07:52:22','',''),(3963,'1','303','1',1,'Retail Sale Id 3801',3600.00,0.00,0.00,5.00,350.00,'2023-03-15 07:54:44','',''),(3964,'1','303','1',1,'Retail Sale Id 3802',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 08:22:54','',''),(3965,'1','303','1',1,'Retail Sale Id 3803',2203.20,0.00,0.00,3.06,214.20,'2023-03-15 08:35:29','',''),(3966,'1','303','1',1,'Retail Sale Id 3804',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 08:37:55','',''),(3967,'1','303','1',1,'Retail Sale Id 3805',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 08:56:24','',''),(3968,'1','303','1',1,'Retail Sale Id 3806',9000.00,0.00,0.00,12.50,875.00,'2023-03-15 08:59:38','',''),(3969,'1','303','1',1,'Retail Sale Id 3807',2160.00,0.00,0.00,3.00,210.00,'2023-03-15 09:04:08','',''),(3970,'1','303','1',1,'Retail Sale Id 3808',2160.00,0.00,0.00,3.00,210.00,'2023-03-15 09:07:30','',''),(3971,'1','303','1',1,'Retail Sale Id 3809',69000.00,0.00,0.00,100.00,4000.00,'2023-03-15 09:10:02','',''),(3972,'1','303','1',1,'Retail Sale Id 3810',2160.00,0.00,0.00,3.00,210.00,'2023-03-15 09:11:39','',''),(3973,'1','303','1',1,'Retail Sale Id 3811',3600.00,0.00,0.00,5.00,350.00,'2023-03-15 09:16:02','',''),(3974,'1','303','1',1,'Retail Sale Id 3814',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 09:19:55','',''),(3975,'1','303','1',1,'Retail Sale Id 3815',9000.00,0.00,0.00,12.50,875.00,'2023-03-15 09:29:26','',''),(3976,'1','303','1',1,'Retail Sale Id 3816',3002.40,0.00,0.00,4.17,291.90,'2023-03-15 09:30:48','',''),(3977,'1','303','1',1,'Retail Sale Id 3817',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 09:42:48','',''),(3978,'1','303','1',1,'Retail Sale Id 3818',9000.00,0.00,0.00,12.50,875.00,'2023-03-15 09:46:03','',''),(3979,'1','303','1',1,'Retail Sale Id 3820',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 09:50:08','',''),(3980,'1','303','1',1,'Retail Sale Id 3822',96600.00,0.00,0.00,140.00,5600.00,'2023-03-15 09:59:18','',''),(3981,'1','303','1',1,'Retail Sale Id 3823',69000.00,0.00,0.00,100.00,4000.00,'2023-03-15 10:02:06','',''),(3982,'1','303','1',1,'Retail Sale Id 3824',9000.00,0.00,0.00,12.50,875.00,'2023-03-15 10:11:25','',''),(3983,'1','303','1',1,'Retail Sale Id 3825',2160.00,0.00,0.00,3.00,210.00,'2023-03-15 10:16:45','',''),(3984,'1','303','1',1,'Retail Sale Id 3825',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 10:16:45','',''),(3985,'1','303','1',1,'Retail Sale Id 3826',2880.00,0.00,0.00,4.00,280.00,'2023-03-15 10:18:11','',''),(3986,'1','303','1',1,'Retail Sale Id 3827',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 10:22:23','',''),(3987,'1','303','1',1,'Retail Sale Id 3828',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 10:48:22','',''),(3988,'1','303','1',1,'Retail Sale Id 3829',34500.00,0.00,0.00,50.00,2000.00,'2023-03-15 10:56:27','',''),(3989,'1','303','1',1,'Retail Sale Id 3830',7200.00,0.00,0.00,10.00,700.00,'2023-03-15 10:58:03','',''),(3990,'1','303','1',1,'Retail Sale Id 3831',2880.00,0.00,0.00,4.00,280.00,'2023-03-15 11:06:45','',''),(3991,'1','303','1',1,'Retail Sale Id 3832',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 11:27:44','',''),(3992,'1','303','1',1,'Retail Sale Id 3833',9000.00,0.00,0.00,12.50,875.00,'2023-03-15 11:35:03','',''),(3993,'1','303','1',1,'Retail Sale Id 3835',4348.80,0.00,0.00,6.04,422.80,'2023-03-15 11:40:42','',''),(3994,'1','303','1',1,'Retail Sale Id 3836',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 11:47:05','',''),(3995,'1','303','1',1,'Retail Sale Id 3837',1000.80,0.00,0.00,1.39,97.30,'2023-03-15 11:57:04','',''),(3996,'1','303','1',1,'Retail Sale Id 3838',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 12:04:29','',''),(3997,'1','303','1',1,'Retail Sale Id 3839',1000.80,0.00,0.00,1.39,97.30,'2023-03-15 12:05:27','',''),(3998,'1','303','1',1,'Retail Sale Id 3840',2160.00,0.00,0.00,3.00,210.00,'2023-03-15 12:06:52','',''),(3999,'1','303','1',1,'Retail Sale Id 3841',2001.60,0.00,0.00,2.78,194.60,'2023-03-15 12:17:23','',''),(4000,'1','303','1',1,'Retail Sale Id 3842',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 12:22:57','',''),(4001,'1','303','1',1,'Retail Sale Id 3843',2160.00,0.00,0.00,3.00,210.00,'2023-03-15 12:23:50','',''),(4002,'1','303','1',1,'Retail Sale Id 3844',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 12:29:27','',''),(4003,'1','303','1',1,'Retail Sale Id 3845',9000.00,0.00,0.00,12.50,875.00,'2023-03-15 12:41:59','',''),(4004,'1','303','1',1,'Retail Sale Id 3846',2160.00,0.00,0.00,3.00,210.00,'2023-03-15 12:47:18','',''),(4005,'1','303','1',1,'Retail Sale Id 3846',7920.00,0.00,0.00,11.00,770.00,'2023-03-15 12:47:18','',''),(4006,'1','303','1',1,'Retail Sale Id 3847',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 13:15:21','',''),(4007,'1','303','1',1,'Retail Sale Id 3848',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 13:17:01','',''),(4008,'1','303','1',1,'Retail Sale Id 3849',3600.00,0.00,0.00,5.00,350.00,'2023-03-15 13:33:45','',''),(4009,'1','303','1',1,'Retail Sale Id 3850',2160.00,0.00,0.00,3.00,210.00,'2023-03-15 13:43:23','',''),(4010,'1','303','1',1,'Retail Sale Id 3851',2160.00,0.00,0.00,3.00,210.00,'2023-03-15 13:44:22','',''),(4011,'1','303','1',1,'Retail Sale Id 3852',2160.00,0.00,0.00,3.00,210.00,'2023-03-15 13:50:08','',''),(4012,'1','303','1',1,'Retail Sale Id 3853',720.00,0.00,0.00,1.00,70.00,'2023-03-15 13:50:59','',''),(4013,'1','303','1',1,'Retail Sale Id 3854',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 13:53:48','',''),(4014,'1','303','1',1,'Retail Sale Id 3855',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 13:56:07','',''),(4015,'1','303','1',1,'Retail Sale Id 3856',9000.00,0.00,0.00,12.50,875.00,'2023-03-15 14:01:05','',''),(4016,'1','303','1',1,'Retail Sale Id 3857',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 14:16:58','',''),(4017,'1','303','1',1,'Retail Sale Id 3858',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 14:19:18','',''),(4018,'1','303','1',1,'Retail Sale Id 3859',2160.00,0.00,0.00,3.00,210.00,'2023-03-15 14:29:59','',''),(4019,'1','303','1',1,'Retail Sale Id 3860',4298.40,0.00,0.00,5.97,417.90,'2023-03-15 14:34:57','',''),(4020,'1','303','1',1,'Retail Sale Id 3861',9000.00,0.00,0.00,12.50,875.00,'2023-03-15 14:36:39','',''),(4021,'1','303','1',1,'Retail Sale Id 3862',9000.00,0.00,0.00,12.50,875.00,'2023-03-15 14:38:47','',''),(4022,'1','303','1',1,'Retail Sale Id 3863',1440.00,0.00,0.00,2.00,140.00,'2023-03-15 14:42:05','',''),(4023,'1','303','1',1,'Retail Sale Id 3864',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 14:44:42','',''),(4024,'1','303','1',1,'Retail Sale Id 3865',2160.00,0.00,0.00,3.00,210.00,'2023-03-15 14:52:16','',''),(4025,'1','303','1',1,'Retail Sale Id 3866',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 14:53:16','',''),(4026,'1','303','1',1,'Retail Sale Id 3867',9000.00,0.00,0.00,12.50,875.00,'2023-03-15 15:05:08','',''),(4027,'1','303','1',1,'Retail Sale Id 3868',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 15:05:59','',''),(4028,'1','303','1',1,'Retail Sale Id 3869',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 15:22:49','',''),(4029,'1','303','1',1,'Retail Sale Id 3870',17250.00,0.00,0.00,25.00,1000.00,'2023-03-15 15:29:02','',''),(4030,'1','303','1',1,'Retail Sale Id 3871',40020.00,0.00,0.00,58.00,2320.00,'2023-03-15 15:48:04','',''),(4031,'1','303','1',1,'Retail Sale Id 3872',3600.00,0.00,0.00,5.00,350.00,'2023-03-15 15:51:08','',''),(4032,'1','303','1',1,'Retail Sale Id 3873',2160.00,0.00,0.00,3.00,210.00,'2023-03-15 15:54:08','',''),(4033,'1','303','1',1,'Retail Sale Id 3874',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 16:06:03','',''),(4034,'1','303','1',1,'Retail Sale Id 3875',2001.60,0.00,0.00,2.78,194.60,'2023-03-15 16:07:27','',''),(4035,'1','303','1',1,'Retail Sale Id 3876',2160.00,0.00,0.00,3.00,210.00,'2023-03-15 16:10:03','',''),(4036,'1','303','1',1,'Retail Sale Id 3877',34500.00,0.00,0.00,50.00,2000.00,'2023-03-15 16:14:53','',''),(4037,'1','303','1',1,'Retail Sale Id 3878',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 16:17:16','',''),(4038,'1','303','1',1,'Retail Sale Id 3879',2203.20,0.00,0.00,3.06,214.20,'2023-03-15 16:21:04','',''),(4039,'1','303','1',1,'Retail Sale Id 3880',2160.00,0.00,0.00,3.00,210.00,'2023-03-15 17:01:02','',''),(4040,'1','303','1',1,'Retail Sale Id 3881',2160.00,0.00,0.00,3.00,210.00,'2023-03-15 17:10:02','',''),(4041,'1','303','1',1,'Retail Sale Id 3883',2160.00,0.00,0.00,3.00,210.00,'2023-03-15 17:12:54','',''),(4042,'1','303','1',1,'Retail Sale Id 3884',69000.00,0.00,0.00,100.00,4000.00,'2023-03-15 17:14:33','',''),(4043,'1','303','1',1,'Retail Sale Id 3885',496.80,0.00,0.00,0.69,48.30,'2023-03-15 17:15:34','',''),(4044,'1','303','1',1,'Retail Sale Id 3886',7200.00,0.00,0.00,10.00,700.00,'2023-03-15 17:17:15','',''),(4045,'1','303','1',1,'Retail Sale Id 3887',2102.40,0.00,0.00,2.92,204.40,'2023-03-15 17:22:52','',''),(4046,'1','303','1',1,'Retail Sale Id 3888',3600.00,0.00,0.00,5.00,350.00,'2023-03-15 17:25:27','',''),(4047,'1','303','1',1,'Retail Sale Id 3889',720.00,0.00,0.00,1.00,70.00,'2023-03-15 17:26:34','',''),(4048,'1','303','1',1,'Retail Sale Id 3890',2001.60,0.00,0.00,2.78,194.60,'2023-03-15 17:27:47','',''),(4049,'1','303','1',1,'Retail Sale Id 3891',34500.00,0.00,0.00,50.00,2000.00,'2023-03-15 17:28:39','',''),(4050,'1','303','1',1,'Retail Sale Id 3892',1440.00,0.00,0.00,2.00,140.00,'2023-03-15 17:32:53','',''),(4051,'1','303','1',1,'Retail Sale Id 3893',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 17:35:18','',''),(4052,'1','303','1',1,'Retail Sale Id 3894',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 17:37:26','',''),(4053,'1','303','1',1,'Return of Retail Sale Id 3889',0.00,720.00,1.00,0.00,-70.00,'2023-03-15 17:47:55','',''),(4054,'1','303','1',1,'Retail Sale Id 3896',9000.00,0.00,0.00,12.50,875.00,'2023-03-15 17:52:45','',''),(4055,'1','303','1',1,'Retail Sale Id 3897',4320.00,0.00,0.00,6.00,420.00,'2023-03-15 18:08:01','',''),(4056,'1','303','1',1,'Retail Sale Id 3898',2160.00,0.00,0.00,3.00,210.00,'2023-03-15 18:18:40','',''),(4057,'1','303','1',1,'Retail Sale Id 3899',1000.80,0.00,0.00,1.39,97.30,'2023-03-15 18:29:05','',''),(4058,'1','303','1',1,'Return of Retail Sale Id 3899',0.00,1000.80,1.39,0.00,-97.30,'2023-03-15 18:42:55','',''),(4059,'1','303','1',1,'Return of Retail Sale Id 3892',0.00,1440.00,2.00,0.00,-140.00,'2023-03-15 18:56:13','',''),(4060,'1','303','1',1,'Retail Sale Id 3901',784.80,0.00,0.00,1.09,76.30,'2023-03-15 18:57:02','',''),(4061,'1','303','1',1,'Retail Sale Id 3904',690.00,0.00,0.00,1.00,40.00,'2023-03-15 19:01:58','',''),(4062,'1','303','1',1,'Retail Sale Id 3905',2160.00,0.00,0.00,3.00,210.00,'2023-03-16 08:13:17','',''),(4063,'1','303','1',1,'Retail Sale Id 3906',2160.00,0.00,0.00,3.00,210.00,'2023-03-16 08:52:11','',''),(4064,'1','303','1',1,'Retail Sale Id 3907',4320.00,0.00,0.00,6.00,420.00,'2023-03-16 09:38:03','',''),(4065,'1','303','1',1,'Retail Sale Id 3908',2203.20,0.00,0.00,3.06,214.20,'2023-03-16 09:44:55','',''),(4066,'1','303','1',1,'Retail Sale Id 3909',1699.20,0.00,0.00,2.36,165.20,'2023-03-16 09:46:31','',''),(4067,'1','303','1',1,'Retail Sale Id 3910',138000.00,0.00,0.00,200.00,8000.00,'2023-03-16 09:58:06','',''),(4068,'1','303','1',1,'Retail Sale Id 3911',2160.00,0.00,0.00,3.00,210.00,'2023-03-16 10:01:58','',''),(4069,'1','303','1',1,'Retail Sale Id 3912',1497.60,0.00,0.00,2.08,145.60,'2023-03-16 10:10:45','',''),(4070,'1','303','1',1,'Retail Sale Id 3913',1497.60,0.00,0.00,2.08,145.60,'2023-03-16 10:35:53','',''),(4071,'1','303','1',1,'Retail Sale Id 3914',2160.00,0.00,0.00,3.00,210.00,'2023-03-16 10:44:28','',''),(4072,'1','303','1',1,'Retail Sale Id 3915',2160.00,0.00,0.00,3.00,210.00,'2023-03-16 10:49:51','',''),(4073,'1','303','1',1,'Retail Sale Id 3915',2160.00,0.00,0.00,3.00,210.00,'2023-03-16 10:49:51','',''),(4074,'1','303','1',1,'Retail Sale Id 3916',69000.00,0.00,0.00,100.00,4000.00,'2023-03-16 10:51:34','',''),(4075,'1','303','1',1,'Retail Sale Id 3917',4320.00,0.00,0.00,6.00,420.00,'2023-03-16 11:00:44','',''),(4076,'1','303','1',1,'Retail Sale Id 3918',2160.00,0.00,0.00,3.00,210.00,'2023-03-16 11:03:09','',''),(4077,'1','303','1',1,'Retail Sale Id 3919',4320.00,0.00,0.00,6.00,420.00,'2023-03-16 11:04:30','',''),(4078,'1','303','1',1,'Retail Sale Id 3920',265650.00,0.00,0.00,385.00,15400.00,'2023-03-16 11:10:14','',''),(4079,'1','303','1',1,'Retail Sale Id 3921',4348.80,0.00,0.00,6.04,422.80,'2023-03-16 11:28:05','',''),(4080,'1','303','1',1,'Retail Sale Id 3922',34500.00,0.00,0.00,50.00,2000.00,'2023-03-16 11:31:28','',''),(4081,'1','303','1',1,'Retail Sale Id 3923',3600.00,0.00,0.00,5.00,350.00,'2023-03-16 11:33:46','',''),(4082,'1','303','1',1,'Retail Sale Id 3924',2160.00,0.00,0.00,3.00,210.00,'2023-03-16 11:45:58','',''),(4083,'1','303','1',1,'Retail Sale Id 3925',7200.00,0.00,0.00,10.00,700.00,'2023-03-16 11:59:29','',''),(4084,'1','303','1',1,'Retail Sale Id 3926',276000.00,0.00,0.00,400.00,16000.00,'2023-03-16 12:06:59','',''),(4085,'1','303','1',1,'Retail Sale Id 3927',4320.00,0.00,0.00,6.00,420.00,'2023-03-16 12:08:47','',''),(4086,'1','303','1',1,'Retail Sale Id 3928',2160.00,0.00,0.00,3.00,210.00,'2023-03-16 12:12:52','',''),(4087,'1','303','1',1,'Retail Sale Id 3929',2880.00,0.00,0.00,4.00,280.00,'2023-03-16 12:16:19','',''),(4088,'1','303','1',1,'Retail Sale Id 3930',6998.40,0.00,0.00,9.72,680.40,'2023-03-16 12:18:19','',''),(4089,'1','303','1',1,'Retail Sale Id 3931',7200.00,0.00,0.00,10.00,700.00,'2023-03-16 12:19:54','',''),(4090,'1','303','1',1,'Retail Sale Id 3932',103500.00,0.00,0.00,150.00,6000.00,'2023-03-16 12:22:22','',''),(4091,'1','303','1',1,'Retail Sale Id 3933',9000.00,0.00,0.00,12.50,875.00,'2023-03-16 12:24:34','',''),(4092,'1','303','1',1,'Retail Sale Id 3934',3002.40,0.00,0.00,4.17,291.90,'2023-03-16 12:28:47','',''),(4093,'1','303','1',1,'Retail Sale Id 3935',4996.80,0.00,0.00,6.94,485.80,'2023-03-16 12:32:58','',''),(4094,'1','303','1',1,'Retail Sale Id 3936',3002.40,0.00,0.00,4.17,291.90,'2023-03-16 12:34:18','',''),(4095,'1','303','1',1,'Retail Sale Id 3937',69000.00,0.00,0.00,100.00,4000.00,'2023-03-16 12:48:29','',''),(4096,'1','303','1',1,'Retail Sale Id 3938',9000.00,0.00,0.00,12.50,875.00,'2023-03-16 12:50:54','',''),(4097,'1','303','1',1,'Retail Sale Id 3939',3600.00,0.00,0.00,5.00,350.00,'2023-03-16 13:00:31','',''),(4098,'1','303','1',1,'Retail Sale Id 3940',3600.00,0.00,0.00,5.00,350.00,'2023-03-16 13:05:21','',''),(4099,'1','303','1',1,'Retail Sale Id 3941',4320.00,0.00,0.00,6.00,420.00,'2023-03-16 13:07:11','',''),(4100,'1','303','1',1,'Retail Sale Id 3942',3600.00,0.00,0.00,5.00,350.00,'2023-03-16 13:09:46','',''),(4101,'1','303','1',1,'Retail Sale Id 3943',2001.60,0.00,0.00,2.78,194.60,'2023-03-16 13:19:08','',''),(4102,'1','303','1',1,'Retail Sale Id 3944',2160.00,0.00,0.00,3.00,210.00,'2023-03-16 13:26:23','',''),(4103,'1','303','1',1,'Retail Sale Id 3945',2160.00,0.00,0.00,3.00,210.00,'2023-03-16 13:30:18','',''),(4104,'1','303','1',1,'Retail Sale Id 3946',2001.60,0.00,0.00,2.78,194.60,'2023-03-16 13:46:00','',''),(4105,'1','303','1',1,'Retail Sale Id 3947',2001.60,0.00,0.00,2.78,194.60,'2023-03-16 14:00:03','',''),(4106,'1','303','1',1,'Retail Sale Id 3948',4320.00,0.00,0.00,6.00,420.00,'2023-03-16 14:09:24','',''),(4107,'1','303','1',1,'Retail Sale Id 3948',7200.00,0.00,0.00,10.00,700.00,'2023-03-16 14:09:24','',''),(4108,'1','303','1',1,'Retail Sale Id 3948',9000.00,0.00,0.00,12.50,875.00,'2023-03-16 14:09:24','',''),(4109,'1','303','1',1,'Retail Sale Id 3949',3600.00,0.00,0.00,5.00,350.00,'2023-03-16 14:15:18','',''),(4110,'1','303','1',1,'Retail Sale Id 3950',720.00,0.00,0.00,1.00,70.00,'2023-03-16 14:23:13','',''),(4111,'1','303','1',1,'Retail Sale Id 3951',7200.00,0.00,0.00,10.00,700.00,'2023-03-16 14:28:15','',''),(4112,'1','303','1',1,'Retail Sale Id 3952',4320.00,0.00,0.00,6.00,420.00,'2023-03-16 14:29:46','',''),(4113,'1','303','1',1,'Retail Sale Id 3953',9000.00,0.00,0.00,12.50,875.00,'2023-03-16 14:34:37','',''),(4114,'1','303','1',1,'Retail Sale Id 3954',9000.00,0.00,0.00,12.50,875.00,'2023-03-16 14:37:12','',''),(4115,'1','303','1',1,'Retail Sale Id 3955',2160.00,0.00,0.00,3.00,210.00,'2023-03-16 14:38:26','',''),(4116,'1','303','1',1,'Retail Sale Id 3956',9000.00,0.00,0.00,12.50,875.00,'2023-03-16 15:30:30','',''),(4117,'1','303','1',1,'Retail Sale Id 3957',4320.00,0.00,0.00,6.00,420.00,'2023-03-16 16:03:47','',''),(4118,'1','303','1',1,'Retail Sale Id 3958',2160.00,0.00,0.00,3.00,210.00,'2023-03-16 16:07:22','',''),(4119,'1','303','1',1,'Retail Sale Id 3959',720.00,0.00,0.00,1.00,70.00,'2023-03-16 16:14:42','',''),(4120,'1','303','1',1,'Retail Sale Id 3960',9000.00,0.00,0.00,12.50,875.00,'2023-03-16 16:17:41','',''),(4121,'1','303','1',1,'Retail Sale Id 3961',2001.60,0.00,0.00,2.78,194.60,'2023-03-16 16:19:27','',''),(4122,'1','303','1',1,'Retail Sale Id 3962',4320.00,0.00,0.00,6.00,420.00,'2023-03-16 16:23:31','',''),(4123,'1','303','1',1,'Retail Sale Id 3963',2160.00,0.00,0.00,3.00,210.00,'2023-03-16 16:32:52','',''),(4124,'1','303','1',1,'Retail Sale Id 3964',1800.00,0.00,0.00,2.50,175.00,'2023-03-16 16:34:34','',''),(4125,'1','303','1',1,'Retail Sale Id 3965',4320.00,0.00,0.00,6.00,420.00,'2023-03-16 16:40:04','',''),(4126,'1','303','1',1,'Retail Sale Id 3966',3002.40,0.00,0.00,4.17,291.90,'2023-03-16 16:53:28','',''),(4127,'1','303','1',1,'Retail Sale Id 3967',4320.00,0.00,0.00,6.00,420.00,'2023-03-16 16:57:46','',''),(4128,'1','303','1',1,'Retail Sale Id 3968',1440.00,0.00,0.00,2.00,140.00,'2023-03-16 17:16:03','',''),(4129,'1','303','1',1,'Retail Sale Id 3969',2160.00,0.00,0.00,3.00,210.00,'2023-03-16 17:20:58','',''),(4130,'1','303','1',1,'Retail Sale Id 3970',2160.00,0.00,0.00,3.00,210.00,'2023-03-16 17:22:25','',''),(4131,'1','303','1',1,'Retail Sale Id 3971',4320.00,0.00,0.00,6.00,420.00,'2023-03-16 17:23:57','',''),(4132,'1','303','1',1,'Retail Sale Id 3972',1497.60,0.00,0.00,2.08,145.60,'2023-03-16 17:28:54','',''),(4133,'1','303','1',1,'Retail Sale Id 3973',2160.00,0.00,0.00,3.00,210.00,'2023-03-16 17:59:43','',''),(4134,'1','303','1',1,'Retail Sale Id 3974',1000.80,0.00,0.00,1.39,97.30,'2023-03-16 18:01:23','',''),(4135,'1','303','1',1,'Retail Sale Id 3975',4320.00,0.00,0.00,6.00,420.00,'2023-03-16 18:02:12','',''),(4136,'1','303','1',1,'Retail Sale Id 3976',4320.00,0.00,0.00,6.00,420.00,'2023-03-16 18:04:08','',''),(4137,'1','303','1',1,'Retail Sale Id 3977',1440.00,0.00,0.00,2.00,140.00,'2023-03-16 18:05:35','',''),(4138,'1','303','1',1,'Retail Sale Id 3978',9000.00,0.00,0.00,12.50,875.00,'2023-03-16 18:06:53','',''),(4139,'1','303','1',1,'Retail Sale Id 3979',4320.00,0.00,0.00,6.00,420.00,'2023-03-16 18:08:29','',''),(4140,'1','303','1',1,'Retail Sale Id 3980',4320.00,0.00,0.00,6.00,420.00,'2023-03-16 18:14:18','',''),(4141,'1','303','1',1,'Retail Sale Id 3981',2160.00,0.00,0.00,3.00,210.00,'2023-03-16 18:21:14','',''),(4142,'1','303','1',1,'Retail Sale Id 3982',4320.00,0.00,0.00,6.00,420.00,'2023-03-16 18:22:38','',''),(4143,'1','303','1',1,'Retail Sale Id 3983',2160.00,0.00,0.00,3.00,210.00,'2023-03-16 18:25:28','',''),(4144,'1','303','1',1,'Retail Sale Id 3984',93.60,0.00,0.00,0.13,9.10,'2023-03-16 19:34:00','',''),(4145,'1','303','1',1,'Retail Sale Id 3985',9360.00,0.00,0.00,13.00,910.00,'2023-03-17 08:12:40','',''),(4146,'1','303','1',1,'Retail Sale Id 3986',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 08:14:12','',''),(4147,'1','303','1',1,'Retail Sale Id 3987',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 08:17:11','',''),(4148,'1','303','1',1,'Retail Sale Id 3988',69000.00,0.00,0.00,100.00,4000.00,'2023-03-17 08:22:02','',''),(4149,'1','303','1',1,'Retail Sale Id 3989',1497.60,0.00,0.00,2.08,145.60,'2023-03-17 08:24:28','',''),(4150,'1','303','1',1,'Retail Sale Id 3990',4500.00,0.00,0.00,6.25,437.50,'2023-03-17 08:27:50','',''),(4151,'1','303','1',1,'Retail Sale Id 3991',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 08:32:39','',''),(4152,'1','303','1',1,'Retail Sale Id 3992',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 08:59:05','',''),(4153,'1','303','1',1,'Retail Sale Id 3993',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 09:00:42','',''),(4154,'1','303','1',1,'Retail Sale Id 3994',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 09:02:19','',''),(4155,'1','303','1',1,'Retail Sale Id 3995',9000.00,0.00,0.00,12.50,875.00,'2023-03-17 09:11:37','',''),(4156,'1','303','1',1,'Retail Sale Id 3996',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 09:23:38','',''),(4157,'1','303','1',1,'Retail Sale Id 3997',9000.00,0.00,0.00,12.50,875.00,'2023-03-17 09:30:11','',''),(4158,'1','303','1',1,'Retail Sale Id 3998',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 09:47:54','',''),(4159,'1','303','1',1,'Retail Sale Id 3999',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 09:49:02','',''),(4160,'1','303','1',1,'Retail Sale Id 4000',3600.00,0.00,0.00,5.00,350.00,'2023-03-17 09:50:21','',''),(4161,'1','303','1',1,'Retail Sale Id 4001',2296.80,0.00,0.00,3.19,223.30,'2023-03-17 10:15:46','',''),(4162,'1','303','1',1,'Retail Sale Id 4002',9000.00,0.00,0.00,12.50,875.00,'2023-03-17 10:18:58','',''),(4163,'1','303','1',1,'Retail Sale Id 4003',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 10:21:02','',''),(4164,'1','303','1',1,'Retail Sale Id 4004',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 10:33:17','',''),(4165,'1','303','1',1,'Retail Sale Id 4005',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 10:40:36','',''),(4166,'1','303','1',1,'Retail Sale Id 4006',1000.80,0.00,0.00,1.39,97.30,'2023-03-17 10:41:48','',''),(4167,'1','303','1',1,'Retail Sale Id 4007',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 10:44:25','',''),(4168,'1','303','1',1,'Retail Sale Id 4008',3002.40,0.00,0.00,4.17,291.90,'2023-03-17 10:52:37','',''),(4169,'1','303','1',1,'Retail Sale Id 4010',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 11:00:55','',''),(4170,'1','303','1',1,'Retail Sale Id 4011',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 11:02:20','',''),(4171,'1','303','1',1,'Retail Sale Id 4012',2001.60,0.00,0.00,2.78,194.60,'2023-03-17 11:03:26','',''),(4172,'1','303','1',1,'Retail Sale Id 4013',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 11:04:52','',''),(4173,'1','303','1',1,'Retail Sale Id 4014',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 11:06:28','',''),(4174,'1','303','1',1,'Retail Sale Id 4015',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 11:07:23','',''),(4175,'1','303','1',1,'Retail Sale Id 4016',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 11:09:14','',''),(4176,'1','303','1',1,'Retail Sale Id 4017',2001.60,0.00,0.00,2.78,194.60,'2023-03-17 11:18:05','',''),(4177,'1','303','1',1,'Retail Sale Id 4018',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 11:20:30','',''),(4178,'1','303','1',1,'Retail Sale Id 4019',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 11:27:30','',''),(4179,'1','303','1',1,'Retail Sale Id 4020',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 11:29:19','',''),(4180,'1','303','1',1,'Retail Sale Id 4021',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 11:30:57','',''),(4181,'1','303','1',1,'Retail Sale Id 4023',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 11:38:16','',''),(4182,'1','303','1',1,'Retail Sale Id 4024',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 11:40:42','',''),(4183,'1','303','1',1,'Retail Sale Id 4025',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 12:02:31','',''),(4184,'1','303','1',1,'Retail Sale Id 4026',9000.00,0.00,0.00,12.50,875.00,'2023-03-17 12:28:39','',''),(4185,'1','303','1',1,'Retail Sale Id 4027',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 12:33:48','',''),(4186,'1','303','1',1,'Retail Sale Id 4029',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 12:38:32','',''),(4187,'1','303','1',1,'Retail Sale Id 4031',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 12:43:44','',''),(4188,'1','303','1',1,'Retail Sale Id 4032',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 12:44:44','',''),(4189,'1','303','1',1,'Retail Sale Id 4033',138000.00,0.00,0.00,200.00,8000.00,'2023-03-17 12:49:12','',''),(4190,'1','303','1',1,'Retail Sale Id 4034',1000.80,0.00,0.00,1.39,97.30,'2023-03-17 12:51:26','',''),(4191,'1','303','1',1,'Retail Sale Id 4035',2203.20,0.00,0.00,3.06,214.20,'2023-03-17 13:25:24','',''),(4192,'1','303','1',1,'Retail Sale Id 4036',4399.20,0.00,0.00,6.11,427.70,'2023-03-17 13:29:02','',''),(4193,'1','303','1',1,'Retail Sale Id 4037',9000.00,0.00,0.00,12.50,875.00,'2023-03-17 13:44:09','',''),(4194,'1','303','1',1,'Retail Sale Id 4038',2001.60,0.00,0.00,2.78,194.60,'2023-03-17 14:11:02','',''),(4195,'1','303','1',1,'Retail Sale Id 4039',4996.80,0.00,0.00,6.94,485.80,'2023-03-17 14:23:43','',''),(4196,'1','303','1',1,'Retail Sale Id 4041',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 14:39:49','',''),(4197,'1','303','1',1,'Retail Sale Id 4042',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 14:43:41','',''),(4198,'1','303','1',1,'Retail Sale Id 4043',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 14:45:02','',''),(4199,'1','303','1',1,'Retail Sale Id 4044',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 14:54:42','',''),(4200,'1','303','1',1,'Retail Sale Id 4045',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 15:16:24','',''),(4201,'1','303','1',1,'Retail Sale Id 4046',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 15:25:46','',''),(4202,'1','303','1',1,'Retail Sale Id 4047',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 15:31:29','',''),(4203,'1','303','1',1,'Retail Sale Id 4048',3600.00,0.00,0.00,5.00,350.00,'2023-03-17 15:39:22','',''),(4204,'1','303','1',1,'Retail Sale Id 4049',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 15:47:35','',''),(4205,'1','303','1',1,'Retail Sale Id 4050',1000.80,0.00,0.00,1.39,97.30,'2023-03-17 15:54:25','',''),(4206,'1','303','1',1,'Retail Sale Id 4051',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 15:57:02','',''),(4207,'1','303','1',1,'Retail Sale Id 4052',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 15:58:22','',''),(4208,'1','303','1',1,'Retail Sale Id 4053',27600.00,0.00,0.00,40.00,1600.00,'2023-03-17 16:20:54','',''),(4209,'1','303','1',1,'Retail Sale Id 4054',9000.00,0.00,0.00,12.50,875.00,'2023-03-17 16:23:34','',''),(4210,'1','303','1',1,'Retail Sale Id 4055',1497.60,0.00,0.00,2.08,145.60,'2023-03-17 16:28:50','',''),(4211,'1','303','1',1,'Retail Sale Id 4056',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 16:40:29','',''),(4212,'1','303','1',1,'Retail Sale Id 4056',9000.00,0.00,0.00,12.50,875.00,'2023-03-17 16:40:29','',''),(4213,'1','303','1',1,'Retail Sale Id 4057',9000.00,0.00,0.00,12.50,875.00,'2023-03-17 16:43:04','',''),(4214,'1','303','1',1,'Retail Sale Id 4058',5760.00,0.00,0.00,8.00,560.00,'2023-03-17 16:51:02','',''),(4215,'1','303','1',1,'Retail Sale Id 4059',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 16:53:49','',''),(4216,'1','303','1',1,'Retail Sale Id 4059',9000.00,0.00,0.00,12.50,875.00,'2023-03-17 16:53:49','',''),(4217,'1','303','1',1,'Retail Sale Id 4060',6998.40,0.00,0.00,9.72,680.40,'2023-03-17 16:59:59','',''),(4218,'1','303','1',1,'Retail Sale Id 4061',2001.60,0.00,0.00,2.78,194.60,'2023-03-17 17:02:13','',''),(4219,'1','303','1',1,'Retail Sale Id 4062',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 17:03:54','',''),(4220,'1','303','1',1,'Retail Sale Id 4063',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 17:05:34','',''),(4221,'1','303','1',1,'Retail Sale Id 4064',2001.60,0.00,0.00,2.78,194.60,'2023-03-17 17:08:36','',''),(4222,'1','303','1',1,'Retail Sale Id 4065',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 17:10:13','',''),(4223,'1','303','1',1,'Retail Sale Id 4066',1440.00,0.00,0.00,2.00,140.00,'2023-03-17 17:13:37','',''),(4224,'1','303','1',1,'Retail Sale Id 4067',4500.00,0.00,0.00,6.25,437.50,'2023-03-17 17:19:12','',''),(4225,'1','303','1',1,'Retail Sale Id 4068',3600.00,0.00,0.00,5.00,350.00,'2023-03-17 17:25:09','',''),(4226,'1','303','1',1,'Retail Sale Id 4069',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 17:34:59','',''),(4227,'1','303','1',1,'Retail Sale Id 4070',1000.80,0.00,0.00,1.39,97.30,'2023-03-17 17:45:24','',''),(4228,'1','303','1',1,'Retail Sale Id 4072',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 17:48:53','',''),(4229,'1','303','1',1,'Retail Sale Id 4072',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 17:48:53','',''),(4230,'1','303','1',1,'Retail Sale Id 4073',4320.00,0.00,0.00,6.00,420.00,'2023-03-17 17:57:39','',''),(4231,'1','303','1',1,'Retail Sale Id 4074',9000.00,0.00,0.00,12.50,875.00,'2023-03-17 18:04:01','',''),(4232,'1','303','1',1,'Retail Sale Id 4075',3600.00,0.00,0.00,5.00,350.00,'2023-03-17 18:11:57','',''),(4233,'1','303','1',1,'Retail Sale Id 4075',9000.00,0.00,0.00,12.50,875.00,'2023-03-17 18:11:57','',''),(4234,'1','303','1',1,'Retail Sale Id 4076',40020.00,0.00,0.00,58.00,2320.00,'2023-03-17 18:15:21','',''),(4235,'1','303','1',1,'Retail Sale Id 4077',3450.00,0.00,0.00,5.00,200.00,'2023-03-17 18:17:06','',''),(4236,'1','303','1',1,'Retail Sale Id 4078',1000.80,0.00,0.00,1.39,97.30,'2023-03-17 18:18:37','',''),(4237,'1','303','1',1,'Retail Sale Id 4080',1396.80,0.00,0.00,1.94,135.80,'2023-03-17 18:21:15','',''),(4238,'1','303','1',1,'Retail Sale Id 4081',2160.00,0.00,0.00,3.00,210.00,'2023-03-17 18:39:42','',''),(4239,'1','303','1',1,'Retail Sale Id 4082',9000.00,0.00,0.00,12.50,875.00,'2023-03-17 18:40:55','',''),(4240,'1','303','1',1,'Retail Sale Id 4083',4708.80,0.00,0.00,6.54,457.80,'2023-03-17 19:36:39','',''),(4241,'1','303','1',1,'Retail Sale Id 4084',4320.00,0.00,0.00,6.00,420.00,'2023-03-19 08:07:23','',''),(4242,'1','303','1',1,'Retail Sale Id 4086',7200.00,0.00,0.00,10.00,700.00,'2023-03-19 08:09:01','',''),(4243,'1','303','1',1,'Retail Sale Id 4087',9000.00,0.00,0.00,12.50,875.00,'2023-03-19 08:11:28','',''),(4244,'1','303','1',1,'Retail Sale Id 4089',2203.20,0.00,0.00,3.06,214.20,'2023-03-19 08:36:31','',''),(4245,'1','303','1',1,'Retail Sale Id 4090',2001.60,0.00,0.00,2.78,194.60,'2023-03-19 08:51:59','',''),(4246,'1','303','1',1,'Retail Sale Id 4091',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 08:59:13','',''),(4247,'1','303','1',1,'Retail Sale Id 4091',4320.00,0.00,0.00,6.00,420.00,'2023-03-19 08:59:13','',''),(4248,'1','303','1',1,'Retail Sale Id 4092',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 09:12:08','',''),(4249,'1','303','1',1,'Retail Sale Id 4093',2203.20,0.00,0.00,3.06,214.20,'2023-03-19 09:13:25','',''),(4250,'1','303','1',1,'Retail Sale Id 4094',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 09:14:43','',''),(4251,'1','303','1',1,'Retail Sale Id 4095',4320.00,0.00,0.00,6.00,420.00,'2023-03-19 09:15:52','',''),(4252,'1','303','1',1,'Retail Sale Id 4096',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 09:17:07','',''),(4253,'1','303','1',1,'Retail Sale Id 4097',34500.00,0.00,0.00,50.00,2000.00,'2023-03-19 09:26:13','',''),(4254,'1','303','1',1,'Retail Sale Id 4098',4320.00,0.00,0.00,6.00,420.00,'2023-03-19 09:28:07','',''),(4255,'1','303','1',1,'Retail Sale Id 4099',1000.80,0.00,0.00,1.39,97.30,'2023-03-19 09:32:37','',''),(4256,'1','303','1',1,'Retail Sale Id 4100',2203.20,0.00,0.00,3.06,214.20,'2023-03-19 09:37:34','',''),(4257,'1','303','1',1,'Retail Sale Id 4101',2001.60,0.00,0.00,2.78,194.60,'2023-03-19 09:42:17','',''),(4258,'1','303','1',1,'Retail Sale Id 4102',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 09:45:36','',''),(4259,'1','303','1',1,'Retail Sale Id 4102',3600.00,0.00,0.00,5.00,350.00,'2023-03-19 09:45:36','',''),(4260,'1','303','1',1,'Retail Sale Id 4103',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 09:57:42','',''),(4261,'1','303','1',1,'Retail Sale Id 4104',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 10:01:20','',''),(4262,'1','303','1',1,'Retail Sale Id 4105',9000.00,0.00,0.00,12.50,875.00,'2023-03-19 10:03:13','',''),(4263,'1','303','1',1,'Retail Sale Id 4106',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 10:04:28','',''),(4264,'1','303','1',1,'Retail Sale Id 4107',2001.60,0.00,0.00,2.78,194.60,'2023-03-19 10:05:42','',''),(4265,'1','303','1',1,'Retail Sale Id 4108',7200.00,0.00,0.00,10.00,700.00,'2023-03-19 10:07:53','',''),(4266,'1','303','1',1,'Retail Sale Id 4109',2001.60,0.00,0.00,2.78,194.60,'2023-03-19 10:09:10','',''),(4267,'1','303','1',1,'Retail Sale Id 4110',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 10:11:03','',''),(4268,'1','303','1',1,'Retail Sale Id 4111',3600.00,0.00,0.00,5.00,350.00,'2023-03-19 10:13:44','',''),(4269,'1','303','1',1,'Retail Sale Id 4112',4320.00,0.00,0.00,6.00,420.00,'2023-03-19 10:19:41','',''),(4270,'1','303','1',1,'Retail Sale Id 4113',30002.40,0.00,0.00,41.67,2916.90,'2023-03-19 10:22:06','',''),(4271,'1','303','1',1,'Retail Sale Id 4114',4320.00,0.00,0.00,6.00,420.00,'2023-03-19 10:26:22','',''),(4272,'1','303','1',1,'Retail Sale Id 4115',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 10:27:44','',''),(4273,'1','303','1',1,'Retail Sale Id 4116',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 10:29:26','',''),(4274,'1','303','1',1,'Retail Sale Id 4117',1440.00,0.00,0.00,2.00,140.00,'2023-03-19 10:31:14','',''),(4275,'1','303','1',1,'Retail Sale Id 4118',2203.20,0.00,0.00,3.06,214.20,'2023-03-19 10:32:53','',''),(4276,'1','303','1',1,'Retail Sale Id 4119',1440.00,0.00,0.00,2.00,140.00,'2023-03-19 10:34:06','',''),(4277,'1','303','1',1,'Retail Sale Id 4120',34500.00,0.00,0.00,50.00,2000.00,'2023-03-19 10:37:33','',''),(4278,'1','303','1',1,'Retail Sale Id 4121',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 10:38:49','',''),(4279,'1','303','1',1,'Retail Sale Id 4122',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 10:40:13','',''),(4280,'1','303','1',1,'Retail Sale Id 4123',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 10:44:43','',''),(4281,'1','303','1',1,'Retail Sale Id 4123',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 10:44:43','',''),(4282,'1','303','1',1,'Retail Sale Id 4123',4320.00,0.00,0.00,6.00,420.00,'2023-03-19 10:44:43','',''),(4283,'1','303','1',1,'Retail Sale Id 4124',1000.80,0.00,0.00,1.39,97.30,'2023-03-19 10:46:12','',''),(4284,'1','303','1',1,'Retail Sale Id 4125',2167.20,0.00,0.00,3.01,210.70,'2023-03-19 11:01:25','',''),(4285,'1','303','1',1,'Retail Sale Id 4126',4320.00,0.00,0.00,6.00,420.00,'2023-03-19 11:02:42','',''),(4286,'1','303','1',1,'Retail Sale Id 4127',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 11:05:17','',''),(4287,'1','303','1',1,'Retail Sale Id 4128',2880.00,0.00,0.00,4.00,280.00,'2023-03-19 11:07:32','',''),(4288,'1','303','1',1,'Retail Sale Id 4129',3002.40,0.00,0.00,4.17,291.90,'2023-03-19 11:09:02','',''),(4289,'1','303','1',1,'Retail Sale Id 4130',2001.60,0.00,0.00,2.78,194.60,'2023-03-19 11:11:43','',''),(4290,'1','303','1',1,'Retail Sale Id 4131',1440.00,0.00,0.00,2.00,140.00,'2023-03-19 11:23:50','',''),(4291,'1','303','1',1,'Retail Sale Id 4131',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 11:23:50','',''),(4292,'1','303','1',1,'Retail Sale Id 4132',172500.00,0.00,0.00,250.00,10000.00,'2023-03-19 11:26:53','',''),(4293,'1','303','1',1,'Retail Sale Id 4133',1497.60,0.00,0.00,2.08,145.60,'2023-03-19 11:32:12','',''),(4294,'1','303','1',1,'Retail Sale Id 4134',9000.00,0.00,0.00,12.50,875.00,'2023-03-19 11:37:37','',''),(4295,'1','303','1',1,'Retail Sale Id 4135',720.00,0.00,0.00,1.00,70.00,'2023-03-19 11:41:51','',''),(4296,'1','303','1',1,'Retail Sale Id 4136',4320.00,0.00,0.00,6.00,420.00,'2023-03-19 11:44:52','',''),(4297,'1','303','1',1,'Retail Sale Id 4138',2203.20,0.00,0.00,3.06,214.20,'2023-03-19 11:48:44','',''),(4298,'1','303','1',1,'Retail Sale Id 4139',4320.00,0.00,0.00,6.00,420.00,'2023-03-19 11:50:01','',''),(4299,'1','303','1',1,'Retail Sale Id 4140',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 11:52:42','',''),(4300,'1','303','1',1,'Retail Sale Id 4141',4320.00,0.00,0.00,6.00,420.00,'2023-03-19 11:55:12','',''),(4301,'1','303','1',1,'Retail Sale Id 4142',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 11:57:27','',''),(4302,'1','303','1',1,'Retail Sale Id 4142',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 11:57:27','',''),(4303,'1','303','1',1,'Retail Sale Id 4143',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 12:03:18','',''),(4304,'1','303','1',1,'Retail Sale Id 4145',720.00,0.00,0.00,1.00,70.00,'2023-03-19 12:09:45','',''),(4305,'1','303','1',1,'Retail Sale Id 4146',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 12:16:59','',''),(4306,'1','303','1',1,'Retail Sale Id 4147',9000.00,0.00,0.00,12.50,875.00,'2023-03-19 12:18:48','',''),(4307,'1','303','1',1,'Retail Sale Id 4148',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 12:21:13','',''),(4308,'1','303','1',1,'Retail Sale Id 4149',1497.60,0.00,0.00,2.08,145.60,'2023-03-19 12:23:52','',''),(4309,'1','303','1',1,'Retail Sale Id 4150',1440.00,0.00,0.00,2.00,140.00,'2023-03-19 12:33:05','',''),(4310,'1','303','1',1,'Retail Sale Id 4150',4320.00,0.00,0.00,6.00,420.00,'2023-03-19 12:33:05','',''),(4311,'1','303','1',1,'Retail Sale Id 4151',4320.00,0.00,0.00,6.00,420.00,'2023-03-19 12:38:36','',''),(4312,'1','303','1',1,'Retail Sale Id 4152',1440.00,0.00,0.00,2.00,140.00,'2023-03-19 12:40:10','',''),(4313,'1','303','1',1,'Retail Sale Id 4153',2001.60,0.00,0.00,2.78,194.60,'2023-03-19 12:42:27','',''),(4314,'1','303','1',1,'Retail Sale Id 4154',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 12:43:49','',''),(4315,'1','303','1',1,'Retail Sale Id 4155',4320.00,0.00,0.00,6.00,420.00,'2023-03-19 12:50:52','',''),(4316,'1','303','1',1,'Retail Sale Id 4155',9000.00,0.00,0.00,12.50,875.00,'2023-03-19 12:50:52','',''),(4317,'1','303','1',1,'Retail Sale Id 4156',1497.60,0.00,0.00,2.08,145.60,'2023-03-19 13:01:26','',''),(4318,'1','303','1',1,'Retail Sale Id 4158',1080.00,0.00,0.00,1.50,105.00,'2023-03-19 13:04:34','',''),(4319,'1','303','1',1,'Retail Sale Id 4159',9000.00,0.00,0.00,12.50,875.00,'2023-03-19 13:09:21','',''),(4320,'1','303','1',1,'Retail Sale Id 4160',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 13:12:53','',''),(4321,'1','303','1',1,'Retail Sale Id 4160',7920.00,0.00,0.00,11.00,770.00,'2023-03-19 13:12:53','',''),(4322,'1','303','1',1,'Retail Sale Id 4161',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 13:15:06','',''),(4323,'1','303','1',1,'Retail Sale Id 4162',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 13:22:01','',''),(4324,'1','303','1',1,'Retail Sale Id 4163',4320.00,0.00,0.00,6.00,420.00,'2023-03-19 13:24:43','',''),(4325,'1','303','1',1,'Retail Sale Id 4164',4320.00,0.00,0.00,6.00,420.00,'2023-03-19 13:26:36','',''),(4326,'1','303','1',1,'Retail Sale Id 4165',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 13:28:22','',''),(4327,'1','303','1',1,'Retail Sale Id 4166',4320.00,0.00,0.00,6.00,420.00,'2023-03-19 13:31:44','',''),(4328,'1','303','1',1,'Retail Sale Id 4167',2001.60,0.00,0.00,2.78,194.60,'2023-03-19 13:33:35','',''),(4329,'1','303','1',1,'Retail Sale Id 4169',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 13:38:25','',''),(4330,'1','303','1',1,'Retail Sale Id 4170',4320.00,0.00,0.00,6.00,420.00,'2023-03-19 13:42:09','',''),(4331,'1','303','1',1,'Retail Sale Id 4170',9000.00,0.00,0.00,12.50,875.00,'2023-03-19 13:42:09','',''),(4332,'1','303','1',1,'Retail Sale Id 4171',3002.40,0.00,0.00,4.17,291.90,'2023-03-19 13:45:53','',''),(4333,'1','303','1',1,'Retail Sale Id 4172',1497.60,0.00,0.00,2.08,145.60,'2023-03-19 13:49:35','',''),(4334,'1','303','1',1,'Retail Sale Id 4173',8640.00,0.00,0.00,12.00,840.00,'2023-03-19 13:53:10','',''),(4335,'1','303','1',1,'Retail Sale Id 4174',9000.00,0.00,0.00,12.50,875.00,'2023-03-19 13:56:06','',''),(4336,'1','303','1',1,'Retail Sale Id 4176',3600.00,0.00,0.00,5.00,350.00,'2023-03-19 14:01:22','',''),(4337,'1','303','1',1,'Retail Sale Id 4177',1440.00,0.00,0.00,2.00,140.00,'2023-03-19 14:02:49','',''),(4338,'1','303','1',1,'Retail Sale Id 4178',1000.80,0.00,0.00,1.39,97.30,'2023-03-19 14:04:04','',''),(4339,'1','303','1',1,'Retail Sale Id 4179',3002.40,0.00,0.00,4.17,291.90,'2023-03-19 14:06:19','',''),(4340,'1','303','1',1,'Retail Sale Id 4180',4320.00,0.00,0.00,6.00,420.00,'2023-03-19 14:08:58','',''),(4341,'1','303','1',1,'Retail Sale Id 4181',496.80,0.00,0.00,0.69,48.30,'2023-03-19 14:10:33','',''),(4342,'1','303','1',1,'Retail Sale Id 4182',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 14:11:50','',''),(4343,'1','303','1',1,'Retail Sale Id 4183',2203.20,0.00,0.00,3.06,214.20,'2023-03-19 14:13:49','',''),(4344,'1','303','1',1,'Retail Sale Id 4184',2203.20,0.00,0.00,3.06,214.20,'2023-03-19 14:14:54','',''),(4345,'1','303','1',1,'Retail Sale Id 4185',1440.00,0.00,0.00,2.00,140.00,'2023-03-19 14:18:08','',''),(4346,'1','303','1',1,'Retail Sale Id 4187',3002.40,0.00,0.00,4.17,291.90,'2023-03-19 14:23:30','',''),(4347,'1','303','1',1,'Retail Sale Id 4188',69000.00,0.00,0.00,100.00,4000.00,'2023-03-19 14:30:47','',''),(4348,'1','303','1',1,'Retail Sale Id 4189',1000.80,0.00,0.00,1.39,97.30,'2023-03-19 14:45:17','',''),(4349,'1','303','1',1,'Retail Sale Id 4190',1497.60,0.00,0.00,2.08,145.60,'2023-03-19 14:46:24','',''),(4350,'1','303','1',1,'Retail Sale Id 4191',2152.80,0.00,0.00,2.99,209.30,'2023-03-19 14:54:10','',''),(4351,'1','303','1',1,'Retail Sale Id 4192',4348.80,0.00,0.00,6.04,422.80,'2023-03-19 15:13:02','',''),(4352,'1','303','1',1,'Retail Sale Id 4193',4320.00,0.00,0.00,6.00,420.00,'2023-03-19 15:14:53','',''),(4353,'1','303','1',1,'Retail Sale Id 4194',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 15:25:39','',''),(4354,'1','303','1',1,'Retail Sale Id 4195',2181.60,0.00,0.00,3.03,212.10,'2023-03-19 15:29:17','',''),(4355,'1','303','1',1,'Retail Sale Id 4196',724500.00,0.00,0.00,1050.00,42000.00,'2023-03-19 15:52:35','',''),(4356,'1','303','1',1,'Retail Sale Id 4197',597.60,0.00,0.00,0.83,58.10,'2023-03-19 15:54:27','',''),(4357,'1','303','1',1,'Retail Sale Id 4198',7920.00,0.00,0.00,11.00,770.00,'2023-03-19 16:03:31','',''),(4358,'1','303','1',1,'Retail Sale Id 4199',4320.00,0.00,0.00,6.00,420.00,'2023-03-19 16:05:36','',''),(4359,'1','303','1',1,'Retail Sale Id 4200',2001.60,0.00,0.00,2.78,194.60,'2023-03-19 16:10:21','',''),(4360,'1','303','1',1,'Retail Sale Id 4201',2001.60,0.00,0.00,2.78,194.60,'2023-03-19 16:16:47','',''),(4361,'1','303','1',1,'Retail Sale Id 4203',7200.00,0.00,0.00,10.00,700.00,'2023-03-19 16:20:01','',''),(4362,'1','303','1',1,'Retail Sale Id 4205',2160.00,0.00,0.00,3.00,210.00,'2023-03-19 16:28:02','',''),(4363,'1','303','1',1,'Retail Sale Id 4206',4320.00,0.00,0.00,6.00,420.00,'2023-03-19 16:29:33','',''),(4364,'1','303','1',1,'Return of Retail Sale Id 4196',0.00,724500.00,1050.00,0.00,-42000.00,'2023-03-19 18:08:12','',''),(4365,'1','303','1',1,'Retail Sale Id 4207',647916.90,0.00,0.00,939.01,37560.40,'2023-03-19 18:12:37','',''),(4366,'1','303','1',1,'Return of Retail Sale Id 4113',0.00,30002.40,41.67,0.00,-2916.90,'2023-03-19 18:17:09','',''),(4367,'1','303','1',1,'Return of Retail Sale Id 4189',0.00,1000.80,1.39,0.00,-97.30,'2023-03-19 18:20:21','',''),(4368,'1','303','1',1,'Retail Sale Id 4208',928.80,0.00,0.00,1.29,90.30,'2023-03-19 18:21:05','',''),(4369,'1','303','1',1,'Return of Retail Sale Id 4200',0.00,2001.60,2.78,0.00,-194.60,'2023-03-19 18:22:57','',''),(4370,'1','303','1',1,'Retail Sale Id 4209',1152.00,0.00,0.00,1.60,112.00,'2023-03-19 18:25:19','',''),(4371,'1','303','1',1,'Return of Retail Sale Id 4097',0.00,34500.00,50.00,0.00,-2000.00,'2023-03-19 18:28:03','',''),(4372,'1','303','1',1,'Retail Sale Id 4210',33120.00,0.00,0.00,48.00,1920.00,'2023-03-19 18:36:43','',''),(4373,'1','303','1',1,'Return of Retail Sale Id 4210',0.00,33120.00,48.00,0.00,-1920.00,'2023-03-19 18:40:10','',''),(4374,'1','303','1',1,'Retail Sale Id 4211',32430.00,0.00,0.00,47.00,1880.00,'2023-03-19 18:42:58','',''),(4375,'1','303','1',1,'Return of Retail Sale Id 4211',0.00,32430.00,47.00,0.00,-1880.00,'2023-03-19 18:46:07','',''),(4376,'1','303','1',1,'Retail Sale Id 4212',31050.00,0.00,0.00,45.00,1800.00,'2023-03-19 18:47:39','',''),(4377,'1','303','1',1,'Distributed to OPERATIONAL LOSS for sales id:4',115160.50,0.00,0.00,177.17,0.00,'2023-03-20 10:15:38','',''),(4378,'1','303',NULL,1,'Purchased from STOCKGAP',0.00,16000000.00,25000.00,0.00,0.00,'2023-03-20 10:29:51','',''),(4379,'1','303',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,25000.00,0.00,'2023-03-20 10:33:40','',''),(4380,'1','303','1',1,'Received from bridging 3',0.00,0.00,25000.00,0.00,0.00,'2023-03-20 10:33:40','',''),(4381,'1','303','1',1,'Retail Sale Id 4213',9000.00,0.00,0.00,12.50,1000.00,'2023-03-20 10:41:52','',''),(4382,'1','303','1',1,'Retail Sale Id 4214',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 10:43:06','',''),(4383,'1','303','1',1,'Retail Sale Id 4214',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 10:43:06','',''),(4384,'1','303','1',1,'Retail Sale Id 4215',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 10:44:25','',''),(4385,'1','303','1',1,'Retail Sale Id 4216',69000.00,0.00,0.00,100.00,5000.00,'2023-03-20 10:45:34','',''),(4386,'1','303','1',1,'Retail Sale Id 4217',69000.00,0.00,0.00,100.00,5000.00,'2023-03-20 10:47:35','',''),(4387,'1','303','1',1,'Return of Retail Sale Id 4217',0.00,69000.00,100.00,0.00,-5000.00,'2023-03-20 10:48:50','',''),(4388,'1','303','1',1,'Retail Sale Id 4218',2203.20,0.00,0.00,3.06,244.80,'2023-03-20 10:50:43','',''),(4389,'1','303','1',1,'Retail Sale Id 4219',1440.00,0.00,0.00,2.00,160.00,'2023-03-20 10:54:26','',''),(4390,'1','303','1',1,'Retail Sale Id 4220',34500.00,0.00,0.00,50.00,2500.00,'2023-03-20 10:58:13','',''),(4391,'1','303','1',1,'Retail Sale Id 4221',1101.60,0.00,0.00,1.53,122.40,'2023-03-20 10:59:58','',''),(4392,'1','303','1',1,'Retail Sale Id 4222',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 11:07:49','',''),(4393,'1','303','1',1,'Retail Sale Id 4223',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 11:11:42','',''),(4394,'1','303','1',1,'Retail Sale Id 4224',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 11:18:45','',''),(4395,'1','303','1',1,'Retail Sale Id 4225',1440.00,0.00,0.00,2.00,160.00,'2023-03-20 11:19:38','',''),(4396,'1','303','1',1,'Retail Sale Id 4226',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 11:20:43','',''),(4397,'1','303','1',1,'Retail Sale Id 4227',37950.00,0.00,0.00,55.00,2750.00,'2023-03-20 11:21:53','',''),(4398,'1','303','1',1,'Retail Sale Id 4228',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 11:23:25','',''),(4399,'1','303','1',1,'Retail Sale Id 4229',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 11:24:45','',''),(4400,'1','303','1',1,'Retail Sale Id 4230',9000.00,0.00,0.00,12.50,1000.00,'2023-03-20 11:26:12','',''),(4401,'1','303','1',1,'Retail Sale Id 4231',9000.00,0.00,0.00,12.50,1000.00,'2023-03-20 11:28:06','',''),(4402,'1','303','1',1,'Retail Sale Id 4232',2001.60,0.00,0.00,2.78,222.40,'2023-03-20 11:29:27','',''),(4403,'1','303','1',1,'Retail Sale Id 4233',15120.00,0.00,0.00,21.00,1680.00,'2023-03-20 11:30:36','',''),(4404,'1','303','1',1,'Retail Sale Id 4234',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 11:31:21','',''),(4405,'1','303','1',1,'Retail Sale Id 4235',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 11:32:29','',''),(4406,'1','303','1',1,'Retail Sale Id 4236',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 11:34:13','',''),(4407,'1','303','1',1,'Retail Sale Id 4237',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 11:35:28','',''),(4408,'1','303','1',1,'Retail Sale Id 4238',13996.80,0.00,0.00,19.44,1555.20,'2023-03-20 11:36:53','',''),(4409,'1','303','1',1,'Retail Sale Id 4238',13996.80,0.00,0.00,19.44,1555.20,'2023-03-20 11:36:53','',''),(4410,'1','303','1',1,'Retail Sale Id 4239',7999.20,0.00,0.00,11.11,888.80,'2023-03-20 11:38:48','',''),(4411,'1','303','1',1,'Retail Sale Id 4240',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 11:39:49','',''),(4412,'1','303','1',1,'Retail Sale Id 4241',3499.20,0.00,0.00,4.86,388.80,'2023-03-20 11:42:44','',''),(4413,'1','303','1',1,'Retail Sale Id 4242',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 11:44:08','',''),(4414,'1','303','1',1,'Retail Sale Id 4243',1440.00,0.00,0.00,2.00,160.00,'2023-03-20 11:45:50','',''),(4415,'1','303','1',1,'Retail Sale Id 4244',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 11:46:52','',''),(4416,'1','303','1',1,'Retail Sale Id 4244',7200.00,0.00,0.00,10.00,800.00,'2023-03-20 11:46:52','',''),(4417,'1','303','1',1,'Retail Sale Id 4245',9000.00,0.00,0.00,12.50,1000.00,'2023-03-20 11:48:03','',''),(4418,'1','303','1',1,'Retail Sale Id 4246',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 11:49:03','',''),(4419,'1','303','1',1,'Retail Sale Id 4247',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 11:51:37','',''),(4420,'1','303','1',1,'Retail Sale Id 4248',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 11:56:07','',''),(4421,'1','303','1',1,'Retail Sale Id 4249',2203.20,0.00,0.00,3.06,244.80,'2023-03-20 11:57:22','',''),(4422,'1','303','1',1,'Retail Sale Id 4250',1497.60,0.00,0.00,2.08,166.40,'2023-03-20 11:58:17','',''),(4423,'1','303','1',1,'Retail Sale Id 4251',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 11:59:20','',''),(4424,'1','303','1',1,'Retail Sale Id 4252',2001.60,0.00,0.00,2.78,222.40,'2023-03-20 12:00:13','',''),(4425,'1','303','1',1,'Retail Sale Id 4253',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 12:01:30','',''),(4426,'1','303','1',1,'Retail Sale Id 4254',9000.00,0.00,0.00,12.50,1000.00,'2023-03-20 12:02:30','',''),(4427,'1','303','1',1,'Retail Sale Id 4255',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 12:03:41','',''),(4428,'1','303','1',1,'Retail Sale Id 4255',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 12:03:41','',''),(4429,'1','303','1',1,'Retail Sale Id 4256',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 12:05:17','',''),(4430,'1','303','1',1,'Retail Sale Id 4257',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 12:06:35','',''),(4431,'1','303','1',1,'Retail Sale Id 4258',2001.60,0.00,0.00,2.78,222.40,'2023-03-20 12:07:46','',''),(4432,'1','303','1',1,'Retail Sale Id 4259',2001.60,0.00,0.00,2.78,222.40,'2023-03-20 12:08:57','',''),(4433,'1','303','1',1,'Retail Sale Id 4260',9000.00,0.00,0.00,12.50,1000.00,'2023-03-20 12:10:08','',''),(4434,'1','303','1',1,'Retail Sale Id 4261',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 12:11:00','',''),(4435,'1','303','1',1,'Retail Sale Id 4262',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 12:12:47','',''),(4436,'1','303','1',1,'Retail Sale Id 4263',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 12:14:05','',''),(4437,'1','303','1',1,'Retail Sale Id 4264',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 12:15:00','',''),(4438,'1','303','1',1,'Retail Sale Id 4265',1800.00,0.00,0.00,2.50,200.00,'2023-03-20 12:16:09','',''),(4439,'1','303','1',1,'Retail Sale Id 4266',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 12:16:56','',''),(4440,'1','303','1',1,'Retail Sale Id 4267',2001.60,0.00,0.00,2.78,222.40,'2023-03-20 12:17:37','',''),(4441,'1','303','1',1,'Retail Sale Id 4268',2203.20,0.00,0.00,3.06,244.80,'2023-03-20 12:19:32','',''),(4442,'1','303','1',1,'Retail Sale Id 4269',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 12:20:24','',''),(4443,'1','303','1',1,'Retail Sale Id 4270',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 12:21:39','',''),(4444,'1','303','1',1,'Retail Sale Id 4271',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 12:23:14','',''),(4445,'1','303','1',1,'Retail Sale Id 4272',2203.20,0.00,0.00,3.06,244.80,'2023-03-20 12:24:21','',''),(4446,'1','303','1',1,'Retail Sale Id 4273',1699.20,0.00,0.00,2.36,188.80,'2023-03-20 12:25:07','',''),(4447,'1','303','1',1,'Retail Sale Id 4274',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 12:26:25','',''),(4448,'1','303','1',1,'Retail Sale Id 4275',2203.20,0.00,0.00,3.06,244.80,'2023-03-20 12:27:26','',''),(4449,'1','303','1',1,'Retail Sale Id 4277',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 12:29:25','',''),(4450,'1','303','1',1,'Retail Sale Id 4277',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 12:29:26','',''),(4451,'1','303','1',1,'Retail Sale Id 4278',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 12:30:41','',''),(4452,'1','303','1',1,'Retail Sale Id 4278',9000.00,0.00,0.00,12.50,1000.00,'2023-03-20 12:30:41','',''),(4453,'1','303','1',1,'Retail Sale Id 4279',720.00,0.00,0.00,1.00,80.00,'2023-03-20 12:31:50','',''),(4454,'1','303','1',1,'Retail Sale Id 4280',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 12:32:46','',''),(4455,'1','303','1',1,'Retail Sale Id 4281',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 12:33:48','',''),(4456,'1','303','1',1,'Retail Sale Id 4282',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 12:34:33','',''),(4457,'1','303','1',1,'Retail Sale Id 4283',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 12:36:49','',''),(4458,'1','303','1',1,'Retail Sale Id 4284',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 12:37:54','',''),(4459,'1','303','1',1,'Retail Sale Id 4284',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 12:37:54','',''),(4460,'1','303','1',1,'Retail Sale Id 4285',138000.00,0.00,0.00,200.00,10000.00,'2023-03-20 12:39:15','',''),(4461,'1','303','1',1,'Retail Sale Id 4286',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 12:40:17','',''),(4462,'1','303','1',1,'Retail Sale Id 4287',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 12:42:27','',''),(4463,'1','303','1',1,'Retail Sale Id 4288',9000.00,0.00,0.00,12.50,1000.00,'2023-03-20 12:43:37','',''),(4464,'1','303','1',1,'Retail Sale Id 4289',2203.20,0.00,0.00,3.06,244.80,'2023-03-20 12:45:12','',''),(4465,'1','303','1',1,'Retail Sale Id 4290',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 12:46:48','',''),(4466,'1','303','1',1,'Retail Sale Id 4291',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 12:47:44','',''),(4467,'1','303','1',1,'Retail Sale Id 4292',2880.00,0.00,0.00,4.00,320.00,'2023-03-20 12:48:36','',''),(4468,'1','303','1',1,'Retail Sale Id 4293',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 12:49:56','',''),(4469,'1','303','1',1,'Retail Sale Id 4294',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 12:50:53','',''),(4470,'1','303','1',1,'Retail Sale Id 4295',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 12:52:13','',''),(4471,'1','303','1',1,'Retail Sale Id 4296',2203.20,0.00,0.00,3.06,244.80,'2023-03-20 12:58:26','',''),(4472,'1','303','1',1,'Retail Sale Id 4297',27600.00,0.00,0.00,40.00,2000.00,'2023-03-20 13:01:22','',''),(4473,'1','303','1',1,'Retail Sale Id 4298',3600.00,0.00,0.00,5.00,400.00,'2023-03-20 13:02:15','',''),(4474,'1','303','1',1,'Retail Sale Id 4299',2203.20,0.00,0.00,3.06,244.80,'2023-03-20 13:04:36','',''),(4475,'1','303','1',1,'Retail Sale Id 4300',720.00,0.00,0.00,1.00,80.00,'2023-03-20 13:05:50','',''),(4476,'1','303','1',1,'Retail Sale Id 4301',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 13:07:09','',''),(4477,'1','303','1',1,'Retail Sale Id 4302',1440.00,0.00,0.00,2.00,160.00,'2023-03-20 13:08:33','',''),(4478,'1','303','1',1,'Retail Sale Id 4303',1000.80,0.00,0.00,1.39,111.20,'2023-03-20 13:09:36','',''),(4479,'1','303','1',1,'Retail Sale Id 4304',2001.60,0.00,0.00,2.78,222.40,'2023-03-20 13:10:55','',''),(4480,'1','303','1',1,'Retail Sale Id 4305',2001.60,0.00,0.00,2.78,222.40,'2023-03-20 13:19:46','',''),(4481,'1','303','1',1,'Retail Sale Id 4306',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 13:21:11','',''),(4482,'1','303','1',1,'Retail Sale Id 4307',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 13:22:35','',''),(4483,'1','303','1',1,'Retail Sale Id 4308',5997.60,0.00,0.00,8.33,666.40,'2023-03-20 13:24:04','',''),(4484,'1','303','1',1,'Retail Sale Id 4309',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 13:29:04','',''),(4485,'1','303','1',1,'Retail Sale Id 4310',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 13:30:31','',''),(4486,'1','303','1',1,'Retail Sale Id 4311',2001.60,0.00,0.00,2.78,222.40,'2023-03-20 13:39:40','',''),(4487,'1','303','1',1,'Retail Sale Id 4312',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 13:41:52','',''),(4488,'1','303','1',1,'Retail Sale Id 4313',69000.00,0.00,0.00,100.00,5000.00,'2023-03-20 13:46:06','',''),(4489,'1','303','1',1,'Retail Sale Id 4314',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 13:48:33','',''),(4490,'1','303','1',1,'Retail Sale Id 4314',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 13:48:33','',''),(4491,'1','303','1',1,'Retail Sale Id 4315',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 13:50:18','',''),(4492,'1','303','1',1,'Retail Sale Id 4316',1497.60,0.00,0.00,2.08,166.40,'2023-03-20 13:56:04','',''),(4493,'1','303','1',1,'Retail Sale Id 4317',3600.00,0.00,0.00,5.00,400.00,'2023-03-20 13:59:40','',''),(4494,'1','303','1',1,'Retail Sale Id 4318',9000.00,0.00,0.00,12.50,1000.00,'2023-03-20 14:05:39','',''),(4495,'1','303','1',1,'Retail Sale Id 4319',1440.00,0.00,0.00,2.00,160.00,'2023-03-20 14:07:29','',''),(4496,'1','303','1',1,'Retail Sale Id 4320',2001.60,0.00,0.00,2.78,222.40,'2023-03-20 14:12:51','',''),(4497,'1','303','1',1,'Retail Sale Id 4320',2001.60,0.00,0.00,2.78,222.40,'2023-03-20 14:12:51','',''),(4498,'1','303','1',1,'Retail Sale Id 4321',1440.00,0.00,0.00,2.00,160.00,'2023-03-20 14:13:36','',''),(4499,'1','303','1',1,'Retail Sale Id 4322',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 14:21:36','',''),(4500,'1','303','1',1,'Retail Sale Id 4323',1497.60,0.00,0.00,2.08,166.40,'2023-03-20 14:22:54','',''),(4501,'1','303','1',1,'Retail Sale Id 4324',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 14:27:12','',''),(4502,'1','303','1',1,'Retail Sale Id 4325',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 14:35:43','',''),(4503,'1','303','1',1,'Retail Sale Id 4326',1598.40,0.00,0.00,2.22,177.60,'2023-03-20 14:37:13','',''),(4504,'1','303','1',1,'Retail Sale Id 4327',2203.20,0.00,0.00,3.06,244.80,'2023-03-20 14:47:30','',''),(4505,'1','303','1',1,'Retail Sale Id 4328',1497.60,0.00,0.00,2.08,166.40,'2023-03-20 14:49:16','',''),(4506,'1','303','1',1,'Retail Sale Id 4330',2001.60,0.00,0.00,2.78,222.40,'2023-03-20 14:51:29','',''),(4507,'1','303','1',1,'Retail Sale Id 4331',1000.80,0.00,0.00,1.39,111.20,'2023-03-20 14:52:55','',''),(4508,'1','303','1',1,'Retail Sale Id 4332',5040.00,0.00,0.00,7.00,560.00,'2023-03-20 14:53:47','',''),(4509,'1','303','1',1,'Retail Sale Id 4333',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 14:55:34','',''),(4510,'1','303','1',1,'Retail Sale Id 4334',2203.20,0.00,0.00,3.06,244.80,'2023-03-20 14:56:51','',''),(4511,'1','303','1',1,'Retail Sale Id 4335',496.80,0.00,0.00,0.69,55.20,'2023-03-20 14:57:50','',''),(4512,'1','303','1',1,'Retail Sale Id 4336',8640.00,0.00,0.00,12.00,960.00,'2023-03-20 15:01:47','',''),(4513,'1','303','1',1,'Retail Sale Id 4337',2001.60,0.00,0.00,2.78,222.40,'2023-03-20 15:10:52','',''),(4514,'1','303','1',1,'Retail Sale Id 4337',2001.60,0.00,0.00,2.78,222.40,'2023-03-20 15:10:52','',''),(4515,'1','303','1',1,'Retail Sale Id 4338',6998.40,0.00,0.00,9.72,777.60,'2023-03-20 15:17:54','',''),(4516,'1','303','1',1,'Retail Sale Id 4339',1440.00,0.00,0.00,2.00,160.00,'2023-03-20 15:24:32','',''),(4517,'1','303','1',1,'Retail Sale Id 4340',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 15:30:59','',''),(4518,'1','303','1',1,'Retail Sale Id 4341',3002.40,0.00,0.00,4.17,333.60,'2023-03-20 15:33:34','',''),(4519,'1','303','1',1,'Retail Sale Id 4342',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 15:37:48','',''),(4520,'1','303','1',1,'Retail Sale Id 4343',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 15:43:21','',''),(4521,'1','303','1',1,'Retail Sale Id 4344',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 15:44:59','',''),(4522,'1','303','1',1,'Retail Sale Id 4345',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 16:01:02','',''),(4523,'1','303','1',1,'Retail Sale Id 4346',1497.60,0.00,0.00,2.08,166.40,'2023-03-20 16:09:36','',''),(4524,'1','303','1',1,'Retail Sale Id 4347',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 16:11:05','',''),(4525,'1','303','1',1,'Retail Sale Id 4348',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 16:13:59','',''),(4526,'1','303','1',1,'Retail Sale Id 4349',3002.40,0.00,0.00,4.17,333.60,'2023-03-20 16:18:04','',''),(4527,'1','303','1',1,'Retail Sale Id 4350',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 16:28:41','',''),(4528,'1','303','1',1,'Retail Sale Id 4351',2152.80,0.00,0.00,2.99,239.20,'2023-03-20 16:30:01','',''),(4529,'1','303','1',1,'Retail Sale Id 4352',1000.80,0.00,0.00,1.39,111.20,'2023-03-20 16:31:16','',''),(4530,'1','303','1',1,'Retail Sale Id 4353',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 16:32:31','',''),(4531,'1','303','1',1,'Retail Sale Id 4354',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 16:35:18','',''),(4532,'1','303','1',1,'Retail Sale Id 4354',7200.00,0.00,0.00,10.00,800.00,'2023-03-20 16:35:18','',''),(4533,'1','303','1',1,'Retail Sale Id 4355',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 16:36:03','',''),(4534,'1','303','1',1,'Retail Sale Id 4356',1440.00,0.00,0.00,2.00,160.00,'2023-03-20 16:38:18','',''),(4535,'1','303','1',1,'Retail Sale Id 4357',5040.00,0.00,0.00,7.00,560.00,'2023-03-20 16:43:00','',''),(4536,'1','303','1',1,'Retail Sale Id 4358',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 16:44:28','',''),(4537,'1','303','1',1,'Retail Sale Id 4359',1497.60,0.00,0.00,2.08,166.40,'2023-03-20 16:45:17','',''),(4538,'1','303','1',1,'Retail Sale Id 4360',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 16:48:31','',''),(4539,'1','303','1',1,'Retail Sale Id 4361',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 16:49:54','',''),(4540,'1','303','1',1,'Retail Sale Id 4362',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 16:51:38','',''),(4541,'1','303','1',1,'Retail Sale Id 4363',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 16:53:33','',''),(4542,'1','303','1',1,'Retail Sale Id 4363',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 16:53:33','',''),(4543,'1','303','1',1,'Retail Sale Id 4364',9000.00,0.00,0.00,12.50,1000.00,'2023-03-20 16:54:42','',''),(4544,'1','303','1',1,'Retail Sale Id 4365',1440.00,0.00,0.00,2.00,160.00,'2023-03-20 16:56:53','',''),(4545,'1','303','1',1,'Retail Sale Id 4366',2880.00,0.00,0.00,4.00,320.00,'2023-03-20 16:58:14','',''),(4546,'1','303','1',1,'Retail Sale Id 4367',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 17:00:07','',''),(4547,'1','303','1',1,'Retail Sale Id 4367',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 17:00:07','',''),(4548,'1','303','1',1,'Retail Sale Id 4368',1497.60,0.00,0.00,2.08,166.40,'2023-03-20 17:01:54','',''),(4549,'1','303','1',1,'Retail Sale Id 4369',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 17:03:20','',''),(4550,'1','303','1',1,'Retail Sale Id 4370',1440.00,0.00,0.00,2.00,160.00,'2023-03-20 17:06:08','',''),(4551,'1','303','1',1,'Retail Sale Id 4371',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 17:08:14','',''),(4552,'1','303','1',1,'Retail Sale Id 4371',9000.00,0.00,0.00,12.50,1000.00,'2023-03-20 17:08:14','',''),(4553,'1','303','1',1,'Retail Sale Id 4372',9000.00,0.00,0.00,12.50,1000.00,'2023-03-20 17:09:31','',''),(4554,'1','303','1',1,'Retail Sale Id 4373',720.00,0.00,0.00,1.00,80.00,'2023-03-20 17:11:19','',''),(4555,'1','303','1',1,'Retail Sale Id 4374',9000.00,0.00,0.00,12.50,1000.00,'2023-03-20 17:12:11','',''),(4556,'1','303','1',1,'Retail Sale Id 4375',2102.40,0.00,0.00,2.92,233.60,'2023-03-20 17:15:09','',''),(4557,'1','303','1',1,'Retail Sale Id 4376',1440.00,0.00,0.00,2.00,160.00,'2023-03-20 17:18:43','',''),(4558,'1','303','1',1,'Retail Sale Id 4376',4680.00,0.00,0.00,6.50,520.00,'2023-03-20 17:18:43','',''),(4559,'1','303','1',1,'Retail Sale Id 4377',2001.60,0.00,0.00,2.78,222.40,'2023-03-20 17:20:12','',''),(4560,'1','303','1',1,'Retail Sale Id 4378',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 17:21:59','',''),(4561,'1','303','1',1,'Retail Sale Id 4379',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 17:23:44','',''),(4562,'1','303','1',1,'Retail Sale Id 4380',3600.00,0.00,0.00,5.00,400.00,'2023-03-20 17:24:55','',''),(4563,'1','303','1',1,'Retail Sale Id 4381',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 17:28:58','',''),(4564,'1','303','1',1,'Retail Sale Id 4382',3600.00,0.00,0.00,5.00,400.00,'2023-03-20 17:31:21','',''),(4565,'1','303','1',1,'Retail Sale Id 4383',189750.00,0.00,0.00,275.00,13750.00,'2023-03-20 17:32:45','',''),(4566,'1','303','1',1,'Retail Sale Id 4384',1000.80,0.00,0.00,1.39,111.20,'2023-03-20 17:33:44','',''),(4567,'1','303','1',1,'Retail Sale Id 4385',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 17:35:15','',''),(4568,'1','303','1',1,'Retail Sale Id 4386',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 17:36:51','',''),(4569,'1','303','1',1,'Retail Sale Id 4387',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 17:38:20','',''),(4570,'1','303','1',1,'Retail Sale Id 4388',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 17:39:42','',''),(4571,'1','303','1',1,'Retail Sale Id 4389',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 17:44:59','',''),(4572,'1','303','1',1,'Return of Retail Sale Id 4300',0.00,720.00,1.00,0.00,-80.00,'2023-03-20 17:47:31','',''),(4573,'1','303','1',1,'Retail Sale Id 4390',1440.00,0.00,0.00,2.00,160.00,'2023-03-20 17:48:32','',''),(4574,'1','303','1',1,'Retail Sale Id 4391',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 17:49:26','',''),(4575,'1','303','1',1,'Retail Sale Id 4392',27600.00,0.00,0.00,40.00,2000.00,'2023-03-20 17:52:54','',''),(4576,'1','303','1',1,'Retail Sale Id 4393',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 17:56:55','',''),(4577,'1','303','1',1,'Retail Sale Id 4394',1000.80,0.00,0.00,1.39,111.20,'2023-03-20 18:04:07','',''),(4578,'1','303','1',1,'Retail Sale Id 4395',2160.00,0.00,0.00,3.00,240.00,'2023-03-20 18:05:23','',''),(4579,'1','303','1',1,'Retail Sale Id 4396',1440.00,0.00,0.00,2.00,160.00,'2023-03-20 18:25:03','',''),(4580,'1','303','1',1,'Retail Sale Id 4397',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 18:27:42','',''),(4581,'1','303','1',1,'Retail Sale Id 4398',4320.00,0.00,0.00,6.00,480.00,'2023-03-20 18:29:17','',''),(4582,'1','303','1',1,'Retail Sale Id 4399',34500.00,0.00,0.00,50.00,2500.00,'2023-03-20 18:58:55','',''),(4583,'1','303','1',1,'Retail Sale Id 4400',69000.00,0.00,0.00,100.00,5000.00,'2023-03-20 18:59:53','',''),(4584,'1','303','1',1,'Retail Sale Id 4401',69000.00,0.00,0.00,100.00,5000.00,'2023-03-20 19:00:56','',''),(4585,'1','303','1',1,'Retail Sale Id 4402',69000.00,0.00,0.00,100.00,5000.00,'2023-03-20 19:02:15','',''),(4586,'1','303','1',1,'Retail Sale Id 4403',37950.00,0.00,0.00,55.00,2750.00,'2023-03-20 19:03:16','',''),(4587,'1','303','1',1,'Retail Sale Id 4404',115.20,0.00,0.00,0.16,12.80,'2023-03-20 19:25:23','',''),(4588,'1','303','1',1,'Retail Sale Id 4405',800.40,0.00,0.00,1.16,58.00,'2023-03-20 19:27:38','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'1','303',1,22837.20,'2023-03-20 19:27:38');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4581 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'1','303',1,'Retail Sale Id 1',0.00,308032.50,710.00,326422.50,18390.00,'2023-01-15 09:50:07'),(2,'1','303',1,'Retail Sale Id 2',0.00,2224.40,752.00,2496.64,272.24,'2023-01-15 09:51:57'),(3,'1','303',1,'Retail Sale Id 3',0.00,4020.00,752.00,4512.00,492.00,'2023-01-15 09:53:12'),(4,'1','303',1,'Retail Sale Id 5',0.00,891.10,752.00,1000.16,109.06,'2023-01-15 09:55:54'),(5,'1','303',1,'Retail Sale Id 5',0.00,891.10,752.00,1000.16,109.06,'2023-01-15 09:55:54'),(6,'1','303',1,'Retail Sale Id 6',0.00,2224.40,752.00,2496.64,272.24,'2023-01-15 10:42:03'),(7,'1','303',1,'Retail Sale Id 7',0.00,1072.00,752.00,1203.20,131.20,'2023-01-15 12:59:41'),(8,'1','303',1,'Retail Sale Id 8',0.00,2016.70,752.00,2263.52,246.82,'2023-01-15 13:59:06'),(9,'1','303',1,'Retail Sale Id 9',0.00,3350.00,752.00,3760.00,410.00,'2023-01-15 14:09:12'),(10,'1','303',1,'Retail Sale Id 9',0.00,8375.00,752.00,9400.00,1025.00,'2023-01-15 14:09:12'),(11,'1','303',1,'Retail Sale Id 10',0.00,8462.10,752.00,9497.76,1035.66,'2023-01-15 14:38:25'),(12,'1','303',1,'Retail Sale Id 13',0.00,2010.00,752.00,2256.00,246.00,'2023-01-15 14:51:16'),(13,'1','303',1,'Retail Sale Id 13',0.00,4046.80,752.00,4542.08,495.28,'2023-01-15 14:51:16'),(14,'1','303',1,'Retail Sale Id 14',0.00,3564.40,752.00,4000.64,436.24,'2023-01-15 14:53:02'),(15,'1','303',1,'Retail Sale Id 15',0.00,3564.40,752.00,4000.64,436.24,'2023-01-15 14:54:35'),(16,'1','303',1,'Retail Sale Id 17',0.00,4006.60,752.00,4496.96,490.36,'2023-01-15 14:56:51'),(17,'1','303',1,'Retail Sale Id 18',0.00,8462.10,752.00,9497.76,1035.66,'2023-01-15 15:06:25'),(18,'1','303',1,'Retail Sale Id 19',0.00,8194.10,752.00,9196.96,1002.86,'2023-01-15 16:30:10'),(19,'1','303',1,'Retail Sale Id 20',0.00,4006.60,752.00,4496.96,490.36,'2023-01-15 16:43:44'),(20,'1','303',1,'Retail Sale Id 21',0.00,1333.30,752.00,1496.48,163.18,'2023-01-15 17:26:50'),(21,'1','303',1,'Retail Sale Id 22',0.00,1782.20,752.00,2000.32,218.12,'2023-01-15 17:38:06'),(22,'1','303',1,'Retail Sale Id 23',0.00,891.10,752.00,1000.16,109.06,'2023-01-15 18:06:55'),(23,'1','303',1,'Return of Retail Sale Id 23',891.10,0.00,752.00,-1000.16,-109.06,'2023-01-15 18:53:46'),(24,'1','303',1,'Retail Sale Id 24',0.00,877.70,752.00,985.12,107.42,'2023-01-15 18:54:41'),(25,'1','303',1,'Retail Sale Id 25',0.00,2050.20,752.00,2301.12,250.92,'2023-01-16 08:01:52'),(26,'1','303',1,'Retail Sale Id 26',0.00,2673.30,752.00,3000.48,327.18,'2023-01-16 09:41:53'),(27,'1','303',1,'Retail Sale Id 27',0.00,2003.30,752.00,2248.48,245.18,'2023-01-16 10:13:48'),(28,'1','303',1,'Retail Sale Id 29',0.00,3343.30,752.00,3752.48,409.18,'2023-01-16 10:26:36'),(29,'1','303',1,'Retail Sale Id 30',0.00,6700.00,752.00,7520.00,820.00,'2023-01-16 11:14:40'),(30,'1','303',1,'Retail Sale Id 31',0.00,8375.00,752.00,9400.00,1025.00,'2023-01-16 11:21:02'),(31,'1','303',1,'Retail Sale Id 32',0.00,4006.60,752.00,4496.96,490.36,'2023-01-16 11:25:33'),(32,'1','303',1,'Retail Sale Id 33',0.00,201000.00,710.00,213000.00,12000.00,'2023-01-16 11:27:31'),(33,'1','303',1,'Retail Sale Id 34',0.00,8375.00,752.00,9400.00,1025.00,'2023-01-16 12:56:10'),(34,'1','303',1,'Retail Sale Id 35',0.00,670.00,752.00,752.00,82.00,'2023-01-16 12:57:36'),(35,'1','303',1,'Retail Sale Id 36',0.00,7731.80,752.00,8678.08,946.28,'2023-01-16 12:59:56'),(36,'1','303',1,'Retail Sale Id 37',0.00,2050.20,752.00,2301.12,250.92,'2023-01-16 13:03:45'),(37,'1','303',1,'Return of Retail Sale Id 36',7731.80,0.00,752.00,-8678.08,-946.28,'2023-01-16 13:06:17'),(38,'1','303',1,'Return of Retail Sale Id 35',670.00,0.00,752.00,-752.00,-82.00,'2023-01-16 13:07:25'),(39,'1','303',1,'Retail Sale Id 38',0.00,8375.00,752.00,9400.00,1025.00,'2023-01-16 13:08:23'),(40,'1','303',1,'Retail Sale Id 39',0.00,4020.00,752.00,4512.00,492.00,'2023-01-16 13:49:14'),(41,'1','303',1,'Retail Sale Id 40',0.00,2720.20,752.00,3053.12,332.92,'2023-01-16 16:15:02'),(42,'1','303',1,'Retail Sale Id 41',0.00,2050.20,752.00,2301.12,250.92,'2023-01-16 16:19:43'),(43,'1','303',1,'Retail Sale Id 42',0.00,1735.30,752.00,1947.68,212.38,'2023-01-16 19:01:48'),(44,'1','303',1,'Retail Sale Id 43',0.00,2673.30,752.00,3000.48,327.18,'2023-01-17 09:17:43'),(45,'1','303',1,'Retail Sale Id 44',0.00,2003.30,752.00,2248.48,245.18,'2023-01-17 09:31:45'),(46,'1','303',1,'Return of Retail Sale Id 43',2673.30,0.00,752.00,-3000.48,-327.18,'2023-01-17 10:44:11'),(47,'1','303',1,'Return of Retail Sale Id 44',2003.30,0.00,752.00,-2248.48,-245.18,'2023-01-17 10:46:41'),(48,'1','303',1,'Retail Sale Id 45',0.00,596.30,752.00,669.28,72.98,'2023-01-17 10:49:42'),(49,'1','303',1,'Retail Sale Id 46',0.00,4053.50,752.00,4549.60,496.10,'2023-01-17 15:03:47'),(50,'1','303',1,'Retail Sale Id 47',0.00,4006.60,752.00,4496.96,490.36,'2023-01-17 15:07:52'),(51,'1','303',1,'Retail Sale Id 48',0.00,2016.70,752.00,2263.52,246.82,'2023-01-17 15:10:32'),(52,'1','303',1,'Retail Sale Id 49',0.00,8375.00,752.00,9400.00,1025.00,'2023-01-17 16:03:48'),(53,'1','303',1,'Retail Sale Id 51',0.00,3350.00,752.00,3760.00,410.00,'2023-01-17 16:25:35'),(54,'1','303',1,'Retail Sale Id 52',0.00,1333.30,752.00,1496.48,163.18,'2023-01-17 17:24:57'),(55,'1','303',1,'Retail Sale Id 53',0.00,3350.00,752.00,3760.00,410.00,'2023-01-17 17:53:50'),(56,'1','303',1,'Retail Sale Id 54',0.00,3370.10,752.00,3782.56,412.46,'2023-01-17 18:16:32'),(57,'1','303',1,'Return of Retail Sale Id 52',1333.30,0.00,752.00,-1496.48,-163.18,'2023-01-17 18:40:22'),(58,'1','303',1,'Retail Sale Id 55',0.00,984.90,752.00,1105.44,120.54,'2023-01-17 18:41:42'),(59,'1','303',1,'Retail Sale Id 56',0.00,6700.00,720.00,7200.00,500.00,'2023-01-18 09:09:24'),(60,'1','303',1,'Retail Sale Id 57',0.00,931.30,720.00,1000.80,69.50,'2023-01-18 09:20:47'),(61,'1','303',1,'Retail Sale Id 58',0.00,1862.60,720.00,2001.60,139.00,'2023-01-18 12:21:11'),(62,'1','303',1,'Retail Sale Id 59',0.00,1393.60,720.00,1497.60,104.00,'2023-01-18 12:22:46'),(63,'1','303',1,'Retail Sale Id 60',0.00,2010.00,720.00,2160.00,150.00,'2023-01-18 12:24:24'),(64,'1','303',1,'Retail Sale Id 61',0.00,2010.00,720.00,2160.00,150.00,'2023-01-18 12:32:07'),(65,'1','303',1,'Retail Sale Id 62',0.00,8375.00,720.00,9000.00,625.00,'2023-01-18 12:52:29'),(66,'1','303',1,'Retail Sale Id 63',0.00,8375.00,720.00,9000.00,625.00,'2023-01-18 13:00:07'),(67,'1','303',1,'Retail Sale Id 64',0.00,2010.00,720.00,2160.00,150.00,'2023-01-18 13:02:08'),(68,'1','303',1,'Retail Sale Id 65',0.00,2010.00,720.00,2160.00,150.00,'2023-01-18 13:09:53'),(69,'1','303',1,'Retail Sale Id 66',0.00,1393.60,720.00,1497.60,104.00,'2023-01-18 13:13:00'),(70,'1','303',1,'Retail Sale Id 67',0.00,8375.00,720.00,9000.00,625.00,'2023-01-18 13:17:25'),(71,'1','303',1,'Retail Sale Id 68',0.00,2010.00,720.00,2160.00,150.00,'2023-01-18 13:18:59'),(72,'1','303',1,'Retail Sale Id 68',0.00,8375.00,720.00,9000.00,625.00,'2023-01-18 13:18:59'),(73,'1','303',1,'Retail Sale Id 69',0.00,8375.00,720.00,9000.00,625.00,'2023-01-18 13:21:17'),(74,'1','303',1,'Retail Sale Id 70',0.00,2010.00,720.00,2160.00,150.00,'2023-01-18 13:26:10'),(75,'1','303',1,'Retail Sale Id 71',0.00,5581.10,720.00,5997.60,416.50,'2023-01-18 13:27:39'),(76,'1','303',1,'Return of Retail Sale Id 69',8375.00,0.00,720.00,-9000.00,-625.00,'2023-01-18 13:28:22'),(77,'1','303',1,'Retail Sale Id 72',0.00,4187.50,720.00,4500.00,312.50,'2023-01-18 13:33:31'),(78,'1','303',1,'Retail Sale Id 73',0.00,4020.00,720.00,4320.00,300.00,'2023-01-18 13:46:25'),(79,'1','303',1,'Retail Sale Id 74',0.00,1226.10,720.00,1317.60,91.50,'2023-01-18 13:56:55'),(80,'1','303',1,'Retail Sale Id 75',0.00,4020.00,720.00,4320.00,300.00,'2023-01-18 13:59:53'),(81,'1','303',1,'Retail Sale Id 76',0.00,4690.00,720.00,5040.00,350.00,'2023-01-18 14:01:28'),(82,'1','303',1,'Retail Sale Id 78',0.00,4020.00,720.00,4320.00,300.00,'2023-01-18 14:05:54'),(83,'1','303',1,'Retail Sale Id 78',0.00,6700.00,720.00,7200.00,500.00,'2023-01-18 14:05:54'),(84,'1','303',1,'Retail Sale Id 79',0.00,8375.00,720.00,9000.00,625.00,'2023-01-18 14:08:36'),(85,'1','303',1,'Retail Sale Id 80',0.00,2010.00,720.00,2160.00,150.00,'2023-01-18 14:13:34'),(86,'1','303',1,'Retail Sale Id 81',0.00,2974.80,720.00,3196.80,222.00,'2023-01-18 14:17:15'),(87,'1','303',1,'Retail Sale Id 82',0.00,2010.00,720.00,2160.00,150.00,'2023-01-18 14:29:20'),(88,'1','303',1,'Retail Sale Id 83',0.00,3999.90,720.00,4298.40,298.50,'2023-01-18 14:35:47'),(89,'1','303',1,'Retail Sale Id 84',0.00,931.30,720.00,1000.80,69.50,'2023-01-18 14:39:35'),(90,'1','303',1,'Retail Sale Id 85',0.00,8375.00,720.00,9000.00,625.00,'2023-01-18 14:49:44'),(91,'1','303',1,'Retail Sale Id 86',0.00,6700.00,720.00,7200.00,500.00,'2023-01-18 14:55:50'),(92,'1','303',1,'Retail Sale Id 87',0.00,1118.90,720.00,1202.40,83.50,'2023-01-18 14:59:35'),(93,'1','303',1,'Retail Sale Id 88',0.00,1118.90,720.00,1202.40,83.50,'2023-01-18 15:00:29'),(94,'1','303',1,'Retail Sale Id 89',0.00,2010.00,720.00,2160.00,150.00,'2023-01-18 15:04:10'),(95,'1','303',1,'Retail Sale Id 90',0.00,2010.00,720.00,2160.00,150.00,'2023-01-18 15:23:25'),(96,'1','303',1,'Retail Sale Id 91',0.00,1340.00,720.00,1440.00,100.00,'2023-01-18 15:26:32'),(97,'1','303',1,'Retail Sale Id 92',0.00,2010.00,720.00,2160.00,150.00,'2023-01-18 15:40:43'),(98,'1','303',1,'Retail Sale Id 93',0.00,8375.00,720.00,9000.00,625.00,'2023-01-18 15:44:30'),(99,'1','303',1,'Retail Sale Id 94',0.00,2010.00,720.00,2160.00,150.00,'2023-01-18 15:49:09'),(100,'1','303',1,'Retail Sale Id 95',0.00,6700.00,720.00,7200.00,500.00,'2023-01-18 15:55:08'),(101,'1','303',1,'Retail Sale Id 96',0.00,1393.60,720.00,1497.60,104.00,'2023-01-18 16:21:38'),(102,'1','303',1,'Retail Sale Id 97',0.00,2050.20,720.00,2203.20,153.00,'2023-01-18 16:23:28'),(103,'1','303',1,'Retail Sale Id 98',0.00,3999.90,720.00,4298.40,298.50,'2023-01-18 16:32:06'),(104,'1','303',1,'Retail Sale Id 99',0.00,4020.00,720.00,4320.00,300.00,'2023-01-18 16:49:08'),(105,'1','303',1,'Retail Sale Id 100',0.00,3350.00,720.00,3600.00,250.00,'2023-01-18 16:51:51'),(106,'1','303',1,'Retail Sale Id 101',0.00,1862.60,720.00,2001.60,139.00,'2023-01-18 16:58:50'),(107,'1','303',1,'Retail Sale Id 102',0.00,2050.20,720.00,2203.20,153.00,'2023-01-18 17:17:30'),(108,'1','303',1,'Retail Sale Id 103',0.00,4649.80,720.00,4996.80,347.00,'2023-01-18 17:18:42'),(109,'1','303',1,'Retail Sale Id 104',0.00,1440500.00,690.00,1483500.00,43000.00,'2023-01-18 17:22:41'),(110,'1','303',1,'Return of Retail Sale Id 104',1440500.00,0.00,690.00,-1483500.00,-43000.00,'2023-01-18 17:24:44'),(111,'1','303',1,'Retail Sale Id 105',0.00,4046.80,720.00,4348.80,302.00,'2023-01-18 17:29:32'),(112,'1','303',1,'Retail Sale Id 106',0.00,931.30,720.00,1000.80,69.50,'2023-01-18 17:34:34'),(113,'1','303',1,'Retail Sale Id 107',0.00,3725.20,720.00,4003.20,278.00,'2023-01-18 17:37:09'),(114,'1','303',1,'Retail Sale Id 108',0.00,2010.00,720.00,2160.00,150.00,'2023-01-18 17:47:33'),(115,'1','303',1,'Retail Sale Id 109',0.00,2010.00,720.00,2160.00,150.00,'2023-01-18 18:02:12'),(116,'1','303',1,'Retail Sale Id 110',0.00,3999.90,720.00,4298.40,298.50,'2023-01-18 18:04:49'),(117,'1','303',1,'Retail Sale Id 110',0.00,8375.00,720.00,9000.00,625.00,'2023-01-18 18:04:49'),(118,'1','303',1,'Retail Sale Id 111',0.00,4020.00,720.00,4320.00,300.00,'2023-01-18 18:06:39'),(119,'1','303',1,'Retail Sale Id 112',0.00,1313032.50,690.00,1352227.50,39195.00,'2023-01-18 18:10:24'),(120,'1','303',1,'Return of Retail Sale Id 112',1313032.50,0.00,690.00,-1352227.50,-39195.00,'2023-01-18 18:17:35'),(121,'1','303',1,'Retail Sale Id 113',0.00,1862.60,720.00,2001.60,139.00,'2023-01-18 18:19:41'),(122,'1','303',1,'Retail Sale Id 114',0.00,770500.00,690.00,793500.00,23000.00,'2023-01-18 18:22:01'),(123,'1','303',1,'Retail Sale Id 115',0.00,4187.50,720.00,4500.00,312.50,'2023-01-19 08:55:06'),(124,'1','303',1,'Retail Sale Id 116',0.00,3350.00,720.00,3600.00,250.00,'2023-01-19 09:00:52'),(125,'1','303',1,'Retail Sale Id 117',0.00,6700.00,720.00,7200.00,500.00,'2023-01-19 09:21:27'),(126,'1','303',1,'Retail Sale Id 118',0.00,4020.00,720.00,4320.00,300.00,'2023-01-19 10:03:18'),(127,'1','303',1,'Retail Sale Id 119',0.00,8375.00,720.00,9000.00,625.00,'2023-01-19 10:16:37'),(128,'1','303',1,'Retail Sale Id 121',0.00,4026.70,720.00,4327.20,300.50,'2023-01-19 10:29:30'),(129,'1','303',1,'Retail Sale Id 122',0.00,2010.00,720.00,2160.00,150.00,'2023-01-19 10:30:39'),(130,'1','303',1,'Retail Sale Id 124',0.00,4046.80,720.00,4348.80,302.00,'2023-01-19 10:47:08'),(131,'1','303',1,'Retail Sale Id 126',0.00,2050.20,720.00,2203.20,153.00,'2023-01-19 10:54:30'),(132,'1','303',1,'Retail Sale Id 127',0.00,743.70,720.00,799.20,55.50,'2023-01-19 10:55:58'),(133,'1','303',1,'Retail Sale Id 128',0.00,4046.80,720.00,4348.80,302.00,'2023-01-19 10:57:59'),(134,'1','303',1,'Retail Sale Id 129',0.00,4046.80,720.00,4348.80,302.00,'2023-01-19 11:19:53'),(135,'1','303',1,'Retail Sale Id 130',0.00,6700.00,720.00,7200.00,500.00,'2023-01-19 11:21:07'),(136,'1','303',1,'Retail Sale Id 131',0.00,4046.80,720.00,4348.80,302.00,'2023-01-19 11:31:46'),(137,'1','303',1,'Retail Sale Id 132',0.00,4046.80,720.00,4348.80,302.00,'2023-01-19 11:37:40'),(138,'1','303',1,'Retail Sale Id 133',0.00,6700.00,720.00,7200.00,500.00,'2023-01-19 11:55:06'),(139,'1','303',1,'Retail Sale Id 134',0.00,2700.10,720.00,2901.60,201.50,'2023-01-19 12:12:18'),(140,'1','303',1,'Retail Sale Id 135',0.00,8375.00,720.00,9000.00,625.00,'2023-01-19 12:21:49'),(141,'1','303',1,'Retail Sale Id 136',0.00,8375.00,720.00,9000.00,625.00,'2023-01-19 12:25:33'),(142,'1','303',1,'Retail Sale Id 137',0.00,8375.00,720.00,9000.00,625.00,'2023-01-19 12:44:52'),(143,'1','303',1,'Retail Sale Id 139',0.00,4046.80,720.00,4348.80,302.00,'2023-01-19 12:56:13'),(144,'1','303',1,'Retail Sale Id 140',0.00,1862.60,720.00,2001.60,139.00,'2023-01-19 13:22:45'),(145,'1','303',1,'Retail Sale Id 141',0.00,2010.00,720.00,2160.00,150.00,'2023-01-19 14:02:09'),(146,'1','303',1,'Retail Sale Id 141',0.00,2010.00,720.00,2160.00,150.00,'2023-01-19 14:02:09'),(147,'1','303',1,'Retail Sale Id 142',0.00,2010.00,720.00,2160.00,150.00,'2023-01-19 14:22:58'),(148,'1','303',1,'Retail Sale Id 143',0.00,2010.00,720.00,2160.00,150.00,'2023-01-19 14:54:13'),(149,'1','303',1,'Retail Sale Id 143',0.00,4020.00,720.00,4320.00,300.00,'2023-01-19 14:54:13'),(150,'1','303',1,'Retail Sale Id 144',0.00,931.30,720.00,1000.80,69.50,'2023-01-19 14:55:48'),(151,'1','303',1,'Retail Sale Id 145',0.00,4649.80,720.00,4996.80,347.00,'2023-01-19 15:01:00'),(152,'1','303',1,'Retail Sale Id 146',0.00,8375.00,720.00,9000.00,625.00,'2023-01-19 15:05:10'),(153,'1','303',1,'Retail Sale Id 147',0.00,2010.00,720.00,2160.00,150.00,'2023-01-19 15:07:17'),(154,'1','303',1,'Retail Sale Id 148',0.00,3350.00,720.00,3600.00,250.00,'2023-01-19 15:13:47'),(155,'1','303',1,'Retail Sale Id 149',0.00,2030.10,720.00,2181.60,151.50,'2023-01-19 15:23:08'),(156,'1','303',1,'Retail Sale Id 150',0.00,2010.00,720.00,2160.00,150.00,'2023-01-19 15:24:54'),(157,'1','303',1,'Retail Sale Id 152',0.00,4040.10,720.00,4341.60,301.50,'2023-01-19 15:28:25'),(158,'1','303',1,'Retail Sale Id 153',0.00,2050.20,720.00,2203.20,153.00,'2023-01-19 15:30:07'),(159,'1','303',1,'Retail Sale Id 154',0.00,931.30,720.00,1000.80,69.50,'2023-01-19 15:34:53'),(160,'1','303',1,'Retail Sale Id 155',0.00,4046.80,720.00,4348.80,302.00,'2023-01-19 15:58:09'),(161,'1','303',1,'Retail Sale Id 156',0.00,2050.20,720.00,2203.20,153.00,'2023-01-19 16:02:29'),(162,'1','303',1,'Retail Sale Id 157',0.00,7443.70,720.00,7999.20,555.50,'2023-01-19 16:04:23'),(163,'1','303',1,'Retail Sale Id 158',0.00,2793.90,720.00,3002.40,208.50,'2023-01-19 16:09:18'),(164,'1','303',1,'Retail Sale Id 159',0.00,8375.00,720.00,9000.00,625.00,'2023-01-19 16:41:31'),(165,'1','303',1,'Retail Sale Id 160',0.00,4020.00,720.00,4320.00,300.00,'2023-01-19 16:48:26'),(166,'1','303',1,'Retail Sale Id 161',0.00,743.70,720.00,799.20,55.50,'2023-01-19 16:53:28'),(167,'1','303',1,'Retail Sale Id 162',0.00,2010.00,720.00,2160.00,150.00,'2023-01-19 17:24:26'),(168,'1','303',1,'Retail Sale Id 163',0.00,4020.00,720.00,4320.00,300.00,'2023-01-19 17:31:11'),(169,'1','303',1,'Retail Sale Id 164',0.00,8375.00,720.00,9000.00,625.00,'2023-01-19 17:50:10'),(170,'1','303',1,'Return of Retail Sale Id 162',2010.00,0.00,720.00,-2160.00,-150.00,'2023-01-19 18:05:57'),(171,'1','303',1,'Retail Sale Id 165',0.00,1078.70,720.00,1159.20,80.50,'2023-01-19 18:07:51'),(172,'1','303',1,'Retail Sale Id 166',0.00,489.10,720.00,525.60,36.50,'2023-01-19 18:29:49'),(173,'1','303',1,'Retail Sale Id 167',0.00,3999.90,720.00,4298.40,298.50,'2023-01-20 08:16:30'),(174,'1','303',1,'Retail Sale Id 168',0.00,8375.00,720.00,9000.00,625.00,'2023-01-20 08:39:25'),(175,'1','303',1,'Retail Sale Id 169',0.00,402.00,720.00,432.00,30.00,'2023-01-20 08:56:38'),(176,'1','303',1,'Retail Sale Id 170',0.00,4046.80,720.00,4348.80,302.00,'2023-01-20 08:58:43'),(177,'1','303',1,'Retail Sale Id 171',0.00,931.30,720.00,1000.80,69.50,'2023-01-20 09:02:18'),(178,'1','303',1,'Retail Sale Id 172',0.00,4020.00,720.00,4320.00,300.00,'2023-01-20 09:15:03'),(179,'1','303',1,'Retail Sale Id 173',0.00,4020.00,720.00,4320.00,300.00,'2023-01-20 10:07:28'),(180,'1','303',1,'Return of Retail Sale Id 169',402.00,0.00,720.00,-432.00,-30.00,'2023-01-20 10:12:36'),(181,'1','303',1,'Retail Sale Id 174',0.00,4020.00,720.00,4320.00,300.00,'2023-01-20 10:22:43'),(182,'1','303',1,'Retail Sale Id 175',0.00,4020.00,720.00,4320.00,300.00,'2023-01-20 10:33:21'),(183,'1','303',1,'Retail Sale Id 176',0.00,3350.00,720.00,3600.00,250.00,'2023-01-20 10:38:05'),(184,'1','303',1,'Retail Sale Id 178',0.00,3350.00,720.00,3600.00,250.00,'2023-01-20 11:06:03'),(185,'1','303',1,'Retail Sale Id 178',0.00,3350.00,720.00,3600.00,250.00,'2023-01-20 11:06:03'),(186,'1','303',1,'Retail Sale Id 179',0.00,7370.00,720.00,7920.00,550.00,'2023-01-20 11:08:18'),(187,'1','303',1,'Retail Sale Id 180',0.00,2680.00,720.00,2880.00,200.00,'2023-01-20 11:32:03'),(188,'1','303',1,'Retail Sale Id 180',0.00,5360.00,720.00,5760.00,400.00,'2023-01-20 11:32:03'),(189,'1','303',1,'Retail Sale Id 181',0.00,2010.00,720.00,2160.00,150.00,'2023-01-20 11:34:30'),(190,'1','303',1,'Retail Sale Id 182',0.00,3350.00,720.00,3600.00,250.00,'2023-01-20 11:35:57'),(191,'1','303',1,'Retail Sale Id 183',0.00,2050.20,720.00,2203.20,153.00,'2023-01-20 11:37:18'),(192,'1','303',1,'Retail Sale Id 184',0.00,1393.60,720.00,1497.60,104.00,'2023-01-20 11:43:40'),(193,'1','303',1,'Retail Sale Id 185',0.00,4020.00,720.00,4320.00,300.00,'2023-01-20 11:46:44'),(194,'1','303',1,'Retail Sale Id 186',0.00,4020.00,720.00,4320.00,300.00,'2023-01-20 11:49:05'),(195,'1','303',1,'Retail Sale Id 187',0.00,4046.80,720.00,4348.80,302.00,'2023-01-20 12:28:21'),(196,'1','303',1,'Retail Sale Id 188',0.00,1393.60,720.00,1497.60,104.00,'2023-01-20 13:33:33'),(197,'1','303',1,'Retail Sale Id 189',0.00,4020.00,720.00,4320.00,300.00,'2023-01-20 14:23:38'),(198,'1','303',1,'Retail Sale Id 190',0.00,8375.00,720.00,9000.00,625.00,'2023-01-20 14:48:11'),(199,'1','303',1,'Retail Sale Id 191',0.00,1393.60,720.00,1497.60,104.00,'2023-01-20 15:07:54'),(200,'1','303',1,'Retail Sale Id 192',0.00,1393.60,720.00,1497.60,104.00,'2023-01-20 15:12:46'),(201,'1','303',1,'Retail Sale Id 193',0.00,1393.60,720.00,1497.60,104.00,'2023-01-20 15:14:14'),(202,'1','303',1,'Retail Sale Id 194',0.00,4046.80,720.00,4348.80,302.00,'2023-01-20 15:15:37'),(203,'1','303',1,'Retail Sale Id 195',0.00,3350.00,720.00,3600.00,250.00,'2023-01-20 15:17:58'),(204,'1','303',1,'Retail Sale Id 196',0.00,4020.00,720.00,4320.00,300.00,'2023-01-20 15:29:17'),(205,'1','303',1,'Retail Sale Id 197',0.00,4046.80,720.00,4348.80,302.00,'2023-01-20 15:32:34'),(206,'1','303',1,'Retail Sale Id 198',0.00,1393.60,720.00,1497.60,104.00,'2023-01-20 15:35:00'),(207,'1','303',1,'Retail Sale Id 199',0.00,2050.20,720.00,2203.20,153.00,'2023-01-20 15:45:30'),(208,'1','303',1,'Retail Sale Id 200',0.00,4020.00,720.00,4320.00,300.00,'2023-01-20 16:14:33'),(209,'1','303',1,'Retail Sale Id 201',0.00,931.30,720.00,1000.80,69.50,'2023-01-20 16:17:10'),(210,'1','303',1,'Retail Sale Id 202',0.00,4187.50,720.00,4500.00,312.50,'2023-01-20 16:19:44'),(211,'1','303',1,'Retail Sale Id 203',0.00,4020.00,720.00,4320.00,300.00,'2023-01-20 16:38:32'),(212,'1','303',1,'Retail Sale Id 204',0.00,2010.00,720.00,2160.00,150.00,'2023-01-20 16:41:38'),(213,'1','303',1,'Retail Sale Id 204',0.00,4020.00,720.00,4320.00,300.00,'2023-01-20 16:41:38'),(214,'1','303',1,'Retail Sale Id 205',0.00,8375.00,720.00,9000.00,625.00,'2023-01-20 16:43:52'),(215,'1','303',1,'Retail Sale Id 206',0.00,2793.90,720.00,3002.40,208.50,'2023-01-20 16:45:45'),(216,'1','303',1,'Retail Sale Id 207',0.00,2137.30,720.00,2296.80,159.50,'2023-01-20 16:47:51'),(217,'1','303',1,'Retail Sale Id 208',0.00,4046.80,720.00,4348.80,302.00,'2023-01-20 16:55:35'),(218,'1','303',1,'Retail Sale Id 209',0.00,2010.00,720.00,2160.00,150.00,'2023-01-20 16:59:35'),(219,'1','303',1,'Retail Sale Id 210',0.00,2010.00,720.00,2160.00,150.00,'2023-01-20 17:08:21'),(220,'1','303',1,'Retail Sale Id 211',0.00,4020.00,720.00,4320.00,300.00,'2023-01-20 17:17:24'),(221,'1','303',1,'Retail Sale Id 211',0.00,8375.00,720.00,9000.00,625.00,'2023-01-20 17:17:24'),(222,'1','303',1,'Retail Sale Id 212',0.00,2010.00,720.00,2160.00,150.00,'2023-01-20 17:19:57'),(223,'1','303',1,'Retail Sale Id 213',0.00,2010.00,720.00,2160.00,150.00,'2023-01-20 17:25:02'),(224,'1','303',1,'Retail Sale Id 214',0.00,2010.00,720.00,2160.00,150.00,'2023-01-20 17:30:04'),(225,'1','303',1,'Retail Sale Id 215',0.00,2050.20,720.00,2203.20,153.00,'2023-01-20 17:56:35'),(226,'1','303',1,'Return of Retail Sale Id 208',4046.80,0.00,720.00,-4348.80,-302.00,'2023-01-20 18:13:37'),(227,'1','303',1,'Retail Sale Id 216',0.00,1005.00,720.00,1080.00,75.00,'2023-01-20 18:15:40'),(228,'1','303',1,'Retail Sale Id 217',0.00,2050.20,720.00,2203.20,153.00,'2023-01-21 08:17:32'),(229,'1','303',1,'Retail Sale Id 218',0.00,1675.00,720.00,1800.00,125.00,'2023-01-21 08:37:22'),(230,'1','303',1,'Retail Sale Id 219',0.00,2050.20,720.00,2203.20,153.00,'2023-01-21 08:56:43'),(231,'1','303',1,'Retail Sale Id 220',0.00,2050.20,720.00,2203.20,153.00,'2023-01-21 09:41:06'),(232,'1','303',1,'Retail Sale Id 221',0.00,6793.80,720.00,7300.80,507.00,'2023-01-21 09:48:27'),(233,'1','303',1,'Retail Sale Id 222',0.00,4020.00,720.00,4320.00,300.00,'2023-01-21 10:04:55'),(234,'1','303',1,'Retail Sale Id 223',0.00,3350.00,720.00,3600.00,250.00,'2023-01-21 10:07:28'),(235,'1','303',1,'Retail Sale Id 224',0.00,2793.90,720.00,3002.40,208.50,'2023-01-21 10:09:12'),(236,'1','303',1,'Retail Sale Id 225',0.00,2010.00,720.00,2160.00,150.00,'2023-01-21 10:11:09'),(237,'1','303',1,'Retail Sale Id 226',0.00,4020.00,720.00,4320.00,300.00,'2023-01-21 10:38:49'),(238,'1','303',1,'Retail Sale Id 227',0.00,7443.70,720.00,7999.20,555.50,'2023-01-21 10:40:45'),(239,'1','303',1,'Retail Sale Id 228',0.00,1346.70,720.00,1447.20,100.50,'2023-01-21 10:45:24'),(240,'1','303',1,'Retail Sale Id 229',0.00,2010.00,720.00,2160.00,150.00,'2023-01-21 10:48:04'),(241,'1','303',1,'Retail Sale Id 230',0.00,4046.80,720.00,4348.80,302.00,'2023-01-21 10:57:03'),(242,'1','303',1,'Retail Sale Id 231',0.00,2050.20,720.00,2203.20,153.00,'2023-01-21 11:05:53'),(243,'1','303',1,'Retail Sale Id 232',0.00,2050.20,720.00,2203.20,153.00,'2023-01-21 11:07:50'),(244,'1','303',1,'Retail Sale Id 233',0.00,2793.90,720.00,3002.40,208.50,'2023-01-21 11:15:12'),(245,'1','303',1,'Retail Sale Id 234',0.00,4046.80,720.00,4348.80,302.00,'2023-01-21 11:17:47'),(246,'1','303',1,'Retail Sale Id 235',0.00,2137.30,720.00,2296.80,159.50,'2023-01-21 11:24:45'),(247,'1','303',1,'Retail Sale Id 236',0.00,2010.00,720.00,2160.00,150.00,'2023-01-21 11:27:05'),(248,'1','303',1,'Retail Sale Id 237',0.00,2010.00,720.00,2160.00,150.00,'2023-01-21 11:33:33'),(249,'1','303',1,'Retail Sale Id 237',0.00,3350.00,720.00,3600.00,250.00,'2023-01-21 11:33:33'),(250,'1','303',1,'Retail Sale Id 238',0.00,2050.20,720.00,2203.20,153.00,'2023-01-21 11:51:03'),(251,'1','303',1,'Retail Sale Id 239',0.00,4046.80,720.00,4348.80,302.00,'2023-01-21 11:59:07'),(252,'1','303',1,'Retail Sale Id 240',0.00,2050.20,720.00,2203.20,153.00,'2023-01-21 12:10:49'),(253,'1','303',1,'Retail Sale Id 241',0.00,2700.10,720.00,2901.60,201.50,'2023-01-21 12:19:23'),(254,'1','303',1,'Retail Sale Id 242',0.00,8375.00,720.00,9000.00,625.00,'2023-01-21 12:29:27'),(255,'1','303',1,'Retail Sale Id 243',0.00,3350.00,720.00,3600.00,250.00,'2023-01-21 13:13:33'),(256,'1','303',1,'Retail Sale Id 244',0.00,2793.90,720.00,3002.40,208.50,'2023-01-21 13:52:30'),(257,'1','303',1,'Retail Sale Id 245',0.00,1862.60,720.00,2001.60,139.00,'2023-01-21 14:30:11'),(258,'1','303',1,'Retail Sale Id 246',0.00,3350.00,720.00,3600.00,250.00,'2023-01-21 14:40:06'),(259,'1','303',1,'Retail Sale Id 247',0.00,1346.70,720.00,1447.20,100.50,'2023-01-21 14:46:57'),(260,'1','303',1,'Retail Sale Id 248',0.00,2050.20,720.00,2203.20,153.00,'2023-01-21 14:53:48'),(261,'1','303',1,'Retail Sale Id 249',0.00,8375.00,720.00,9000.00,625.00,'2023-01-21 14:57:55'),(262,'1','303',1,'Retail Sale Id 250',0.00,4046.80,720.00,4348.80,302.00,'2023-01-21 15:10:58'),(263,'1','303',1,'Retail Sale Id 251',0.00,4187.50,720.00,4500.00,312.50,'2023-01-21 15:23:30'),(264,'1','303',1,'Retail Sale Id 252',0.00,4020.00,720.00,4320.00,300.00,'2023-01-21 15:27:14'),(265,'1','303',1,'Retail Sale Id 253',0.00,3350.00,720.00,3600.00,250.00,'2023-01-21 15:37:03'),(266,'1','303',1,'Retail Sale Id 254',0.00,3350.00,720.00,3600.00,250.00,'2023-01-21 15:39:45'),(267,'1','303',1,'Retail Sale Id 255',0.00,2050.20,720.00,2203.20,153.00,'2023-01-21 15:42:07'),(268,'1','303',1,'Retail Sale Id 256',0.00,2050.20,720.00,2203.20,153.00,'2023-01-21 16:24:06'),(269,'1','303',1,'Retail Sale Id 257',0.00,670.00,720.00,720.00,50.00,'2023-01-21 16:26:30'),(270,'1','303',1,'Retail Sale Id 258',0.00,4020.00,720.00,4320.00,300.00,'2023-01-21 16:29:17'),(271,'1','303',1,'Retail Sale Id 259',0.00,2680.00,720.00,2880.00,200.00,'2023-01-21 16:30:43'),(272,'1','303',1,'Retail Sale Id 260',0.00,2050.20,720.00,2203.20,153.00,'2023-01-21 16:35:33'),(273,'1','303',1,'Retail Sale Id 261',0.00,3999.90,720.00,4298.40,298.50,'2023-01-21 16:38:14'),(274,'1','303',1,'Retail Sale Id 262',0.00,2010.00,720.00,2160.00,150.00,'2023-01-21 16:42:38'),(275,'1','303',1,'Retail Sale Id 263',0.00,4046.80,720.00,4348.80,302.00,'2023-01-21 16:53:12'),(276,'1','303',1,'Retail Sale Id 264',0.00,4020.00,720.00,4320.00,300.00,'2023-01-21 17:02:11'),(277,'1','303',1,'Retail Sale Id 265',0.00,931.30,720.00,1000.80,69.50,'2023-01-21 17:04:21'),(278,'1','303',1,'Retail Sale Id 267',0.00,2050.20,720.00,2203.20,153.00,'2023-01-21 17:07:15'),(279,'1','303',1,'Retail Sale Id 268',0.00,2010.00,720.00,2160.00,150.00,'2023-01-21 17:33:36'),(280,'1','303',1,'Retail Sale Id 269',0.00,2680.00,720.00,2880.00,200.00,'2023-01-21 17:41:09'),(281,'1','303',1,'Retail Sale Id 270',0.00,1346.70,720.00,1447.20,100.50,'2023-01-21 17:49:03'),(282,'1','303',1,'Retail Sale Id 271',0.00,4187.50,720.00,4500.00,312.50,'2023-01-21 18:03:30'),(283,'1','303',1,'Retail Sale Id 272',0.00,2050.20,720.00,2203.20,153.00,'2023-01-21 18:05:26'),(284,'1','303',1,'Retail Sale Id 273',0.00,4046.80,720.00,4348.80,302.00,'2023-01-21 18:07:04'),(285,'1','303',1,'Retail Sale Id 274',0.00,1299.80,720.00,1396.80,97.00,'2023-01-21 18:12:28'),(286,'1','303',1,'Return of Retail Sale Id 264',4020.00,0.00,720.00,-4320.00,-300.00,'2023-01-21 18:46:14'),(287,'1','303',1,'Retail Sale Id 275',0.00,998.30,720.00,1072.80,74.50,'2023-01-21 18:49:00'),(288,'1','303',1,'Return of Retail Sale Id 274',1299.80,0.00,720.00,-1396.80,-97.00,'2023-01-21 18:50:27'),(289,'1','303',1,'Retail Sale Id 276',0.00,8375.00,720.00,9000.00,625.00,'2023-01-22 08:47:56'),(290,'1','303',1,'Retail Sale Id 277',0.00,8375.00,720.00,9000.00,625.00,'2023-01-22 08:53:10'),(291,'1','303',1,'Retail Sale Id 279',0.00,2050.20,720.00,2203.20,153.00,'2023-01-22 08:56:14'),(292,'1','303',1,'Retail Sale Id 281',0.00,4020.00,720.00,4320.00,300.00,'2023-01-22 09:00:47'),(293,'1','303',1,'Retail Sale Id 282',0.00,1862.60,720.00,2001.60,139.00,'2023-01-22 09:06:35'),(294,'1','303',1,'Retail Sale Id 283',0.00,4187.50,720.00,4500.00,312.50,'2023-01-22 09:26:47'),(295,'1','303',1,'Retail Sale Id 284',0.00,2050.20,720.00,2203.20,153.00,'2023-01-22 09:43:32'),(296,'1','303',1,'Retail Sale Id 285',0.00,2050.20,720.00,2203.20,153.00,'2023-01-22 09:48:55'),(297,'1','303',1,'Retail Sale Id 286',0.00,8375.00,720.00,9000.00,625.00,'2023-01-22 09:53:02'),(298,'1','303',1,'Retail Sale Id 287',0.00,4046.80,720.00,4348.80,302.00,'2023-01-22 10:00:57'),(299,'1','303',1,'Retail Sale Id 288',0.00,2050.20,720.00,2203.20,153.00,'2023-01-22 10:18:59'),(300,'1','303',1,'Retail Sale Id 289',0.00,3350.00,720.00,3600.00,250.00,'2023-01-22 10:43:07'),(301,'1','303',1,'Retail Sale Id 290',0.00,3999.90,720.00,4298.40,298.50,'2023-01-22 10:44:30'),(302,'1','303',1,'Retail Sale Id 291',0.00,8375.00,720.00,9000.00,625.00,'2023-01-22 10:50:11'),(303,'1','303',1,'Retail Sale Id 292',0.00,2050.20,720.00,2203.20,153.00,'2023-01-22 10:55:06'),(304,'1','303',1,'Retail Sale Id 293',0.00,8375.00,720.00,9000.00,625.00,'2023-01-22 10:57:19'),(305,'1','303',1,'Retail Sale Id 294',0.00,931.30,720.00,1000.80,69.50,'2023-01-22 11:13:16'),(306,'1','303',1,'Retail Sale Id 295',0.00,7443.70,720.00,7999.20,555.50,'2023-01-22 11:21:12'),(307,'1','303',1,'Retail Sale Id 296',0.00,4187.50,720.00,4500.00,312.50,'2023-01-22 11:27:24'),(308,'1','303',1,'Retail Sale Id 297',0.00,4093.70,720.00,4399.20,305.50,'2023-01-22 11:29:29'),(309,'1','303',1,'Retail Sale Id 298',0.00,2050.20,720.00,2203.20,153.00,'2023-01-22 11:31:52'),(310,'1','303',1,'Retail Sale Id 299',0.00,4020.00,720.00,4320.00,300.00,'2023-01-22 11:33:43'),(311,'1','303',1,'Retail Sale Id 300',0.00,2050.20,720.00,2203.20,153.00,'2023-01-22 11:35:45'),(312,'1','303',1,'Retail Sale Id 301',0.00,3999.90,720.00,4298.40,298.50,'2023-01-22 11:47:00'),(313,'1','303',1,'Retail Sale Id 302',0.00,8375.00,720.00,9000.00,625.00,'2023-01-22 12:12:32'),(314,'1','303',1,'Retail Sale Id 303',0.00,3350.00,720.00,3600.00,250.00,'2023-01-22 12:13:56'),(315,'1','303',1,'Retail Sale Id 304',0.00,3350.00,720.00,3600.00,250.00,'2023-01-22 12:16:29'),(316,'1','303',1,'Retail Sale Id 305',0.00,8375.00,720.00,9000.00,625.00,'2023-01-22 12:19:47'),(317,'1','303',1,'Retail Sale Id 306',0.00,4020.00,720.00,4320.00,300.00,'2023-01-22 12:25:52'),(318,'1','303',1,'Retail Sale Id 307',0.00,8375.00,720.00,9000.00,625.00,'2023-01-22 12:31:00'),(319,'1','303',1,'Retail Sale Id 308',0.00,2137.30,720.00,2296.80,159.50,'2023-01-22 12:32:01'),(320,'1','303',1,'Retail Sale Id 309',0.00,1862.60,720.00,2001.60,139.00,'2023-01-22 12:34:17'),(321,'1','303',1,'Retail Sale Id 310',0.00,1340.00,720.00,1440.00,100.00,'2023-01-22 12:36:00'),(322,'1','303',1,'Retail Sale Id 311',0.00,3350.00,720.00,3600.00,250.00,'2023-01-22 12:37:20'),(323,'1','303',1,'Retail Sale Id 312',0.00,1956.40,720.00,2102.40,146.00,'2023-01-22 12:39:23'),(324,'1','303',1,'Retail Sale Id 313',0.00,2010.00,720.00,2160.00,150.00,'2023-01-22 12:48:34'),(325,'1','303',1,'Retail Sale Id 314',0.00,6700.00,720.00,7200.00,500.00,'2023-01-22 13:02:07'),(326,'1','303',1,'Retail Sale Id 315',0.00,8375.00,720.00,9000.00,625.00,'2023-01-22 13:03:18'),(327,'1','303',1,'Retail Sale Id 316',0.00,1862.60,720.00,2001.60,139.00,'2023-01-22 13:05:57'),(328,'1','303',1,'Retail Sale Id 317',0.00,931.30,720.00,1000.80,69.50,'2023-01-22 13:21:01'),(329,'1','303',1,'Retail Sale Id 318',0.00,3256.20,720.00,3499.20,243.00,'2023-01-22 13:25:43'),(330,'1','303',1,'Retail Sale Id 319',0.00,1340.00,720.00,1440.00,100.00,'2023-01-22 13:28:15'),(331,'1','303',1,'Retail Sale Id 320',0.00,2050.20,720.00,2203.20,153.00,'2023-01-22 13:33:38'),(332,'1','303',1,'Retail Sale Id 322',0.00,4046.80,720.00,4348.80,302.00,'2023-01-22 14:17:50'),(333,'1','303',1,'Retail Sale Id 323',0.00,3350.00,720.00,3600.00,250.00,'2023-01-22 14:21:28'),(334,'1','303',1,'Retail Sale Id 324',0.00,8375.00,720.00,9000.00,625.00,'2023-01-22 14:38:35'),(335,'1','303',1,'Retail Sale Id 326',0.00,4046.80,720.00,4348.80,302.00,'2023-01-22 14:45:01'),(336,'1','303',1,'Retail Sale Id 327',0.00,2050.20,720.00,2203.20,153.00,'2023-01-22 14:49:40'),(337,'1','303',1,'Retail Sale Id 328',0.00,7443.70,720.00,7999.20,555.50,'2023-01-22 14:51:06'),(338,'1','303',1,'Retail Sale Id 329',0.00,2050.20,720.00,2203.20,153.00,'2023-01-22 14:58:04'),(339,'1','303',1,'Retail Sale Id 330',0.00,1393.60,720.00,1497.60,104.00,'2023-01-22 15:18:21'),(340,'1','303',1,'Retail Sale Id 331',0.00,3725.20,720.00,4003.20,278.00,'2023-01-22 15:22:10'),(341,'1','303',1,'Retail Sale Id 332',0.00,1862.60,720.00,2001.60,139.00,'2023-01-22 15:46:36'),(342,'1','303',1,'Retail Sale Id 333',0.00,7349.90,720.00,7898.40,548.50,'2023-01-22 16:00:25'),(343,'1','303',1,'Retail Sale Id 334',0.00,8375.00,720.00,9000.00,625.00,'2023-01-22 16:22:18'),(344,'1','303',1,'Retail Sale Id 335',0.00,2680.00,720.00,2880.00,200.00,'2023-01-22 16:25:13'),(345,'1','303',1,'Retail Sale Id 336',0.00,4020.00,720.00,4320.00,300.00,'2023-01-22 16:31:40'),(346,'1','303',1,'Retail Sale Id 337',0.00,1393.60,720.00,1497.60,104.00,'2023-01-22 16:40:20'),(347,'1','303',1,'Retail Sale Id 338',0.00,2050.20,720.00,2203.20,153.00,'2023-01-22 16:59:19'),(348,'1','303',1,'Retail Sale Id 339',0.00,4020.00,720.00,4320.00,300.00,'2023-01-22 17:02:35'),(349,'1','303',1,'Retail Sale Id 340',0.00,2050.20,720.00,2203.20,153.00,'2023-01-22 17:16:44'),(350,'1','303',1,'Retail Sale Id 341',0.00,2050.20,720.00,2203.20,153.00,'2023-01-22 17:30:46'),(351,'1','303',1,'Retail Sale Id 342',0.00,1346.70,720.00,1447.20,100.50,'2023-01-22 17:34:48'),(352,'1','303',1,'Retail Sale Id 343',0.00,2050.20,720.00,2203.20,153.00,'2023-01-22 17:39:18'),(353,'1','303',1,'Return of Retail Sale Id 342',1346.70,0.00,720.00,-1447.20,-100.50,'2023-01-22 17:44:02'),(354,'1','303',1,'Retail Sale Id 345',0.00,2010.00,720.00,2160.00,150.00,'2023-01-22 17:57:34'),(355,'1','303',1,'Retail Sale Id 345',0.00,2010.00,720.00,2160.00,150.00,'2023-01-22 17:57:34'),(356,'1','303',1,'Retail Sale Id 347',0.00,2700.10,720.00,2901.60,201.50,'2023-01-22 18:00:05'),(357,'1','303',1,'Retail Sale Id 348',0.00,3350.00,720.00,3600.00,250.00,'2023-01-22 18:01:45'),(358,'1','303',1,'Retail Sale Id 349',0.00,743.70,720.00,799.20,55.50,'2023-01-22 18:03:18'),(359,'1','303',1,'Retail Sale Id 350',0.00,87.10,720.00,93.60,6.50,'2023-01-22 18:33:12'),(360,'1','303',1,'Retail Sale Id 351',0.00,3999.90,720.00,4298.40,298.50,'2023-01-23 09:03:55'),(361,'1','303',1,'Retail Sale Id 352',0.00,3999.90,720.00,4298.40,298.50,'2023-01-23 09:05:32'),(362,'1','303',1,'Retail Sale Id 353',0.00,4020.00,720.00,4320.00,300.00,'2023-01-23 09:23:00'),(363,'1','303',1,'Retail Sale Id 354',0.00,3999.90,720.00,4298.40,298.50,'2023-01-23 09:40:08'),(364,'1','303',1,'Retail Sale Id 355',0.00,2680.00,720.00,2880.00,200.00,'2023-01-23 09:46:48'),(365,'1','303',1,'Retail Sale Id 356',0.00,2793.90,720.00,3002.40,208.50,'2023-01-23 09:48:44'),(366,'1','303',1,'Retail Sale Id 357',0.00,3999.90,720.00,4298.40,298.50,'2023-01-23 09:49:42'),(367,'1','303',1,'Retail Sale Id 358',0.00,2050.20,720.00,2203.20,153.00,'2023-01-23 09:51:07'),(368,'1','303',1,'Retail Sale Id 359',0.00,2680.00,720.00,2880.00,200.00,'2023-01-23 09:53:20'),(369,'1','303',1,'Retail Sale Id 360',0.00,4020.00,720.00,4320.00,300.00,'2023-01-23 10:09:14'),(370,'1','303',1,'Retail Sale Id 362',0.00,931.30,720.00,1000.80,69.50,'2023-01-23 10:26:01'),(371,'1','303',1,'Retail Sale Id 363',0.00,2793.90,720.00,3002.40,208.50,'2023-01-23 10:31:27'),(372,'1','303',1,'Retail Sale Id 364',0.00,3999.90,720.00,4298.40,298.50,'2023-01-23 10:34:28'),(373,'1','303',1,'Return of Retail Sale Id 363',2793.90,0.00,720.00,-3002.40,-208.50,'2023-01-23 10:40:08'),(374,'1','303',1,'Retail Sale Id 365',0.00,3999.90,720.00,4298.40,298.50,'2023-01-23 10:54:05'),(375,'1','303',1,'Retail Sale Id 366',0.00,931.30,720.00,1000.80,69.50,'2023-01-23 11:02:42'),(376,'1','303',1,'Retail Sale Id 367',0.00,3350.00,720.00,3600.00,250.00,'2023-01-23 11:27:12'),(377,'1','303',1,'Retail Sale Id 368',0.00,1340.00,720.00,1440.00,100.00,'2023-01-23 11:29:25'),(378,'1','303',1,'Retail Sale Id 369',0.00,2010.00,720.00,2160.00,150.00,'2023-01-23 11:30:43'),(379,'1','303',1,'Retail Sale Id 370',0.00,6700.00,720.00,7200.00,500.00,'2023-01-23 11:31:53'),(380,'1','303',1,'Retail Sale Id 371',0.00,931.30,720.00,1000.80,69.50,'2023-01-23 11:33:43'),(381,'1','303',1,'Retail Sale Id 372',0.00,4020.00,720.00,4320.00,300.00,'2023-01-23 11:34:42'),(382,'1','303',1,'Retail Sale Id 373',0.00,670.00,720.00,720.00,50.00,'2023-01-23 11:36:30'),(383,'1','303',1,'Retail Sale Id 374',0.00,4020.00,720.00,4320.00,300.00,'2023-01-23 11:42:50'),(384,'1','303',1,'Retail Sale Id 375',0.00,696.80,720.00,748.80,52.00,'2023-01-23 11:45:34'),(385,'1','303',1,'Retail Sale Id 376',0.00,1393.60,720.00,1497.60,104.00,'2023-01-23 11:53:57'),(386,'1','303',1,'Retail Sale Id 377',0.00,931.30,720.00,1000.80,69.50,'2023-01-23 11:55:08'),(387,'1','303',1,'Retail Sale Id 378',0.00,2680.00,720.00,2880.00,200.00,'2023-01-23 11:59:40'),(388,'1','303',1,'Retail Sale Id 379',0.00,3999.90,720.00,4298.40,298.50,'2023-01-23 12:28:31'),(389,'1','303',1,'Retail Sale Id 380',0.00,7349.90,720.00,7898.40,548.50,'2023-01-23 12:49:37'),(390,'1','303',1,'Retail Sale Id 381',0.00,3999.90,720.00,4298.40,298.50,'2023-01-23 12:51:35'),(391,'1','303',1,'Retail Sale Id 382',0.00,4020.00,720.00,4320.00,300.00,'2023-01-23 12:52:54'),(392,'1','303',1,'Retail Sale Id 383',0.00,4020.00,720.00,4320.00,300.00,'2023-01-23 12:54:53'),(393,'1','303',1,'Retail Sale Id 383',0.00,4020.00,720.00,4320.00,300.00,'2023-01-23 12:54:53'),(394,'1','303',1,'Retail Sale Id 384',0.00,1393.60,720.00,1497.60,104.00,'2023-01-23 12:56:44'),(395,'1','303',1,'Retail Sale Id 385',0.00,8375.00,720.00,9000.00,625.00,'2023-01-23 13:02:45'),(396,'1','303',1,'Retail Sale Id 387',0.00,4020.00,720.00,4320.00,300.00,'2023-01-23 13:05:11'),(397,'1','303',1,'Retail Sale Id 388',0.00,1299.80,720.00,1396.80,97.00,'2023-01-23 13:13:27'),(398,'1','303',1,'Retail Sale Id 389',0.00,4020.00,720.00,4320.00,300.00,'2023-01-23 13:18:18'),(399,'1','303',1,'Retail Sale Id 390',0.00,2050.20,720.00,2203.20,153.00,'2023-01-23 13:20:03'),(400,'1','303',1,'Retail Sale Id 391',0.00,2050.20,720.00,2203.20,153.00,'2023-01-23 13:21:20'),(401,'1','303',1,'Retail Sale Id 392',0.00,2010.00,720.00,2160.00,150.00,'2023-01-23 13:22:45'),(402,'1','303',1,'Retail Sale Id 393',0.00,7370.00,720.00,7920.00,550.00,'2023-01-23 13:24:26'),(403,'1','303',1,'Retail Sale Id 394',0.00,3350.00,720.00,3600.00,250.00,'2023-01-23 13:40:40'),(404,'1','303',1,'Retail Sale Id 394',0.00,8375.00,720.00,9000.00,625.00,'2023-01-23 13:40:40'),(405,'1','303',1,'Retail Sale Id 395',0.00,3999.90,720.00,4298.40,298.50,'2023-01-23 13:42:22'),(406,'1','303',1,'Retail Sale Id 396',0.00,2050.20,720.00,2203.20,153.00,'2023-01-23 13:44:08'),(407,'1','303',1,'Retail Sale Id 397',0.00,4020.00,720.00,4320.00,300.00,'2023-01-23 13:49:37'),(408,'1','303',1,'Retail Sale Id 398',0.00,4020.00,720.00,4320.00,300.00,'2023-01-23 13:51:05'),(409,'1','303',1,'Retail Sale Id 399',0.00,2050.20,720.00,2203.20,153.00,'2023-01-23 14:17:06'),(410,'1','303',1,'Retail Sale Id 400',0.00,931.30,720.00,1000.80,69.50,'2023-01-23 14:19:46'),(411,'1','303',1,'Retail Sale Id 401',0.00,8375.00,720.00,9000.00,625.00,'2023-01-23 14:21:07'),(412,'1','303',1,'Retail Sale Id 402',0.00,1862.60,720.00,2001.60,139.00,'2023-01-23 14:31:44'),(413,'1','303',1,'Retail Sale Id 403',0.00,1862.60,720.00,2001.60,139.00,'2023-01-23 14:32:32'),(414,'1','303',1,'Retail Sale Id 404',0.00,2010.00,720.00,2160.00,150.00,'2023-01-23 14:54:04'),(415,'1','303',1,'Retail Sale Id 405',0.00,8375.00,720.00,9000.00,625.00,'2023-01-23 14:59:23'),(416,'1','303',1,'Retail Sale Id 406',0.00,4020.00,720.00,4320.00,300.00,'2023-01-23 15:01:06'),(417,'1','303',1,'Retail Sale Id 407',0.00,2050.20,720.00,2203.20,153.00,'2023-01-23 15:13:02'),(418,'1','303',1,'Retail Sale Id 408',0.00,4020.00,720.00,4320.00,300.00,'2023-01-23 15:16:36'),(419,'1','303',1,'Retail Sale Id 409',0.00,2010.00,720.00,2160.00,150.00,'2023-01-23 15:17:42'),(420,'1','303',1,'Retail Sale Id 410',0.00,8375.00,720.00,9000.00,625.00,'2023-01-23 15:20:05'),(421,'1','303',1,'Retail Sale Id 411',0.00,8375.00,720.00,9000.00,625.00,'2023-01-23 15:27:08'),(422,'1','303',1,'Retail Sale Id 412',0.00,4020.00,720.00,4320.00,300.00,'2023-01-23 15:27:55'),(423,'1','303',1,'Retail Sale Id 413',0.00,1346.70,720.00,1447.20,100.50,'2023-01-23 15:41:32'),(424,'1','303',1,'Retail Sale Id 414',0.00,2050.20,720.00,2203.20,153.00,'2023-01-23 15:43:28'),(425,'1','303',1,'Retail Sale Id 416',0.00,2700.10,720.00,2901.60,201.50,'2023-01-23 15:49:52'),(426,'1','303',1,'Retail Sale Id 417',0.00,1333.30,720.00,1432.80,99.50,'2023-01-23 15:53:10'),(427,'1','303',1,'Retail Sale Id 418',0.00,931.30,720.00,1000.80,69.50,'2023-01-23 15:54:50'),(428,'1','303',1,'Retail Sale Id 419',0.00,8375.00,720.00,9000.00,625.00,'2023-01-23 16:11:55'),(429,'1','303',1,'Retail Sale Id 420',0.00,1346.70,720.00,1447.20,100.50,'2023-01-23 16:37:14'),(430,'1','303',1,'Retail Sale Id 421',0.00,4020.00,720.00,4320.00,300.00,'2023-01-23 16:38:43'),(431,'1','303',1,'Retail Sale Id 422',0.00,2050.20,720.00,2203.20,153.00,'2023-01-23 16:40:23'),(432,'1','303',1,'Retail Sale Id 423',0.00,884.40,720.00,950.40,66.00,'2023-01-23 16:54:06'),(433,'1','303',1,'Retail Sale Id 424',0.00,4046.80,720.00,4348.80,302.00,'2023-01-23 17:07:29'),(434,'1','303',1,'Retail Sale Id 425',0.00,4046.80,720.00,4348.80,302.00,'2023-01-23 17:13:45'),(435,'1','303',1,'Retail Sale Id 426',0.00,4187.50,720.00,4500.00,312.50,'2023-01-23 17:37:22'),(436,'1','303',1,'Retail Sale Id 427',0.00,1340.00,720.00,1440.00,100.00,'2023-01-23 17:42:55'),(437,'1','303',1,'Retail Sale Id 428',0.00,2016.70,720.00,2167.20,150.50,'2023-01-23 17:48:29'),(438,'1','303',1,'Retail Sale Id 429',0.00,2010.00,720.00,2160.00,150.00,'2023-01-23 17:50:04'),(439,'1','303',1,'Retail Sale Id 429',0.00,3350.00,720.00,3600.00,250.00,'2023-01-23 17:50:04'),(440,'1','303',1,'Retail Sale Id 430',0.00,1340.00,720.00,1440.00,100.00,'2023-01-23 17:50:52'),(441,'1','303',1,'Retail Sale Id 431',0.00,2010.00,720.00,2160.00,150.00,'2023-01-23 17:54:28'),(442,'1','303',1,'Retail Sale Id 432',0.00,931.30,720.00,1000.80,69.50,'2023-01-23 18:03:12'),(443,'1','303',1,'Retail Sale Id 433',0.00,2793.90,720.00,3002.40,208.50,'2023-01-23 18:12:34'),(444,'1','303',1,'Retail Sale Id 434',0.00,46.90,720.00,50.40,3.50,'2023-01-23 18:46:46'),(445,'1','303',1,'Retail Sale Id 435',0.00,2010.00,720.00,2160.00,150.00,'2023-01-24 08:55:50'),(446,'1','303',1,'Retail Sale Id 435',0.00,8375.00,720.00,9000.00,625.00,'2023-01-24 08:55:50'),(447,'1','303',1,'Retail Sale Id 436',0.00,931.30,720.00,1000.80,69.50,'2023-01-24 08:57:39'),(448,'1','303',1,'Retail Sale Id 437',0.00,1393.60,720.00,1497.60,104.00,'2023-01-24 09:02:08'),(449,'1','303',1,'Retail Sale Id 438',0.00,1340.00,720.00,1440.00,100.00,'2023-01-24 09:17:29'),(450,'1','303',1,'Retail Sale Id 440',0.00,4020.00,720.00,4320.00,300.00,'2023-01-24 09:25:24'),(451,'1','303',1,'Retail Sale Id 441',0.00,6981.40,720.00,7502.40,521.00,'2023-01-24 09:27:03'),(452,'1','303',1,'Retail Sale Id 442',0.00,2050.20,720.00,2203.20,153.00,'2023-01-24 10:02:10'),(453,'1','303',1,'Retail Sale Id 443',0.00,5360.00,720.00,5760.00,400.00,'2023-01-24 10:10:10'),(454,'1','303',1,'Retail Sale Id 444',0.00,3350.00,720.00,3600.00,250.00,'2023-01-24 10:21:10'),(455,'1','303',1,'Retail Sale Id 445',0.00,3350.00,720.00,3600.00,250.00,'2023-01-24 10:38:54'),(456,'1','303',1,'Retail Sale Id 446',0.00,2793.90,720.00,3002.40,208.50,'2023-01-24 10:44:49'),(457,'1','303',1,'Retail Sale Id 447',0.00,3999.90,720.00,4298.40,298.50,'2023-01-24 11:01:49'),(458,'1','303',1,'Retail Sale Id 448',0.00,4020.00,720.00,4320.00,300.00,'2023-01-24 11:28:54'),(459,'1','303',1,'Retail Sale Id 449',0.00,2050.20,720.00,2203.20,153.00,'2023-01-24 11:34:28'),(460,'1','303',1,'Retail Sale Id 450',0.00,1862.60,720.00,2001.60,139.00,'2023-01-24 11:40:40'),(461,'1','303',1,'Retail Sale Id 451',0.00,4020.00,720.00,4320.00,300.00,'2023-01-24 11:57:33'),(462,'1','303',1,'Retail Sale Id 452',0.00,8375.00,720.00,9000.00,625.00,'2023-01-24 11:59:22'),(463,'1','303',1,'Retail Sale Id 453',0.00,2050.20,720.00,2203.20,153.00,'2023-01-24 12:00:52'),(464,'1','303',1,'Retail Sale Id 454',0.00,4046.80,720.00,4348.80,302.00,'2023-01-24 12:02:34'),(465,'1','303',1,'Retail Sale Id 455',0.00,7349.90,720.00,7898.40,548.50,'2023-01-24 12:20:29'),(466,'1','303',1,'Retail Sale Id 456',0.00,1393.60,720.00,1497.60,104.00,'2023-01-24 12:22:47'),(467,'1','303',1,'Retail Sale Id 457',0.00,8375.00,720.00,9000.00,625.00,'2023-01-24 12:23:53'),(468,'1','303',1,'Retail Sale Id 458',0.00,1393.60,720.00,1497.60,104.00,'2023-01-24 12:25:24'),(469,'1','303',1,'Retail Sale Id 459',0.00,3999.90,720.00,4298.40,298.50,'2023-01-24 12:29:54'),(470,'1','303',1,'Retail Sale Id 460',0.00,1862.60,720.00,2001.60,139.00,'2023-01-24 12:44:07'),(471,'1','303',1,'Retail Sale Id 461',0.00,2010.00,720.00,2160.00,150.00,'2023-01-24 13:05:45'),(472,'1','303',1,'Retail Sale Id 462',0.00,2010.00,720.00,2160.00,150.00,'2023-01-24 13:23:55'),(473,'1','303',1,'Retail Sale Id 463',0.00,4020.00,720.00,4320.00,300.00,'2023-01-24 13:25:29'),(474,'1','303',1,'Retail Sale Id 464',0.00,3350.00,720.00,3600.00,250.00,'2023-01-24 13:27:02'),(475,'1','303',1,'Retail Sale Id 465',0.00,4020.00,720.00,4320.00,300.00,'2023-01-24 13:39:58'),(476,'1','303',1,'Retail Sale Id 466',0.00,4046.80,720.00,4348.80,302.00,'2023-01-24 13:47:15'),(477,'1','303',1,'Retail Sale Id 467',0.00,2010.00,720.00,2160.00,150.00,'2023-01-24 13:53:26'),(478,'1','303',1,'Retail Sale Id 467',0.00,4020.00,720.00,4320.00,300.00,'2023-01-24 13:53:26'),(479,'1','303',1,'Retail Sale Id 468',0.00,3725.20,720.00,4003.20,278.00,'2023-01-24 14:04:19'),(480,'1','303',1,'Retail Sale Id 469',0.00,2010.00,720.00,2160.00,150.00,'2023-01-24 14:33:42'),(481,'1','303',1,'Retail Sale Id 469',0.00,8375.00,720.00,9000.00,625.00,'2023-01-24 14:33:42'),(482,'1','303',1,'Retail Sale Id 470',0.00,3350.00,720.00,3600.00,250.00,'2023-01-24 14:43:33'),(483,'1','303',1,'Retail Sale Id 471',0.00,4020.00,720.00,4320.00,300.00,'2023-01-24 14:55:47'),(484,'1','303',1,'Retail Sale Id 472',0.00,2050.20,720.00,2203.20,153.00,'2023-01-24 15:11:35'),(485,'1','303',1,'Retail Sale Id 473',0.00,4020.00,720.00,4320.00,300.00,'2023-01-24 15:29:18'),(486,'1','303',1,'Retail Sale Id 474',0.00,1340.00,720.00,1440.00,100.00,'2023-01-24 15:31:47'),(487,'1','303',1,'Retail Sale Id 475',0.00,7443.70,720.00,7999.20,555.50,'2023-01-24 16:05:37'),(488,'1','303',1,'Retail Sale Id 477',0.00,2010.00,720.00,2160.00,150.00,'2023-01-24 16:37:37'),(489,'1','303',1,'Retail Sale Id 478',0.00,2050.20,720.00,2203.20,153.00,'2023-01-24 16:38:52'),(490,'1','303',1,'Retail Sale Id 479',0.00,6512.40,720.00,6998.40,486.00,'2023-01-24 16:39:34'),(491,'1','303',1,'Retail Sale Id 480',0.00,2010.00,720.00,2160.00,150.00,'2023-01-24 16:45:38'),(492,'1','303',1,'Retail Sale Id 481',0.00,3350.00,720.00,3600.00,250.00,'2023-01-24 16:53:25'),(493,'1','303',1,'Retail Sale Id 482',0.00,4020.00,720.00,4320.00,300.00,'2023-01-24 16:59:39'),(494,'1','303',1,'Retail Sale Id 483',0.00,2050.20,720.00,2203.20,153.00,'2023-01-24 17:01:17'),(495,'1','303',1,'Retail Sale Id 484',0.00,8375.00,720.00,9000.00,625.00,'2023-01-24 17:05:08'),(496,'1','303',1,'Retail Sale Id 485',0.00,8375.00,720.00,9000.00,625.00,'2023-01-24 17:06:56'),(497,'1','303',1,'Retail Sale Id 486',0.00,4020.00,720.00,4320.00,300.00,'2023-01-24 17:10:49'),(498,'1','303',1,'Retail Sale Id 486',0.00,4020.00,720.00,4320.00,300.00,'2023-01-24 17:10:49'),(499,'1','303',1,'Retail Sale Id 487',0.00,3350.00,720.00,3600.00,250.00,'2023-01-24 17:13:29'),(500,'1','303',1,'Retail Sale Id 488',0.00,4046.80,720.00,4348.80,302.00,'2023-01-24 17:21:03'),(501,'1','303',1,'Retail Sale Id 489',0.00,737000.00,690.00,759000.00,22000.00,'2023-01-24 17:23:20'),(502,'1','303',1,'Retail Sale Id 490',0.00,8375.00,720.00,9000.00,625.00,'2023-01-24 17:31:19'),(503,'1','303',1,'Retail Sale Id 491',0.00,4020.00,720.00,4320.00,300.00,'2023-01-24 17:38:29'),(504,'1','303',1,'Retail Sale Id 493',0.00,4020.00,720.00,4320.00,300.00,'2023-01-24 17:42:16'),(505,'1','303',1,'Return of Retail Sale Id 483',2050.20,0.00,720.00,-2203.20,-153.00,'2023-01-24 18:27:42'),(506,'1','303',1,'Retail Sale Id 494',0.00,924.60,720.00,993.60,69.00,'2023-01-24 18:28:31'),(507,'1','303',1,'Retail Sale Id 496',0.00,1005.00,690.00,1035.00,30.00,'2023-01-24 18:36:01'),(508,'1','303',1,'Return of Retail Sale Id 496',1005.00,0.00,690.00,-1035.00,-30.00,'2023-01-24 18:37:12'),(509,'1','303',1,'Retail Sale Id 497',0.00,4020.00,720.00,4320.00,300.00,'2023-01-25 07:48:22'),(510,'1','303',1,'Retail Sale Id 498',0.00,4020.00,720.00,4320.00,300.00,'2023-01-25 08:07:46'),(511,'1','303',1,'Retail Sale Id 499',0.00,2003.30,720.00,2152.80,149.50,'2023-01-25 08:09:04'),(512,'1','303',1,'Retail Sale Id 500',0.00,2010.00,720.00,2160.00,150.00,'2023-01-25 08:10:35'),(513,'1','303',1,'Retail Sale Id 501',0.00,3350.00,720.00,3600.00,250.00,'2023-01-25 08:11:57'),(514,'1','303',1,'Retail Sale Id 502',0.00,931.30,720.00,1000.80,69.50,'2023-01-25 08:13:27'),(515,'1','303',1,'Retail Sale Id 503',0.00,1862.60,720.00,2001.60,139.00,'2023-01-25 08:26:51'),(516,'1','303',1,'Retail Sale Id 504',0.00,6700.00,720.00,7200.00,500.00,'2023-01-25 09:04:53'),(517,'1','303',1,'Retail Sale Id 506',0.00,4046.80,720.00,4348.80,302.00,'2023-01-25 09:42:08'),(518,'1','303',1,'Retail Sale Id 507',0.00,8375.00,720.00,9000.00,625.00,'2023-01-25 10:04:22'),(519,'1','303',1,'Retail Sale Id 508',0.00,3350.00,720.00,3600.00,250.00,'2023-01-25 10:05:40'),(520,'1','303',1,'Retail Sale Id 509',0.00,4020.00,720.00,4320.00,300.00,'2023-01-25 10:06:34'),(521,'1','303',1,'Retail Sale Id 510',0.00,1393.60,720.00,1497.60,104.00,'2023-01-25 10:08:41'),(522,'1','303',1,'Retail Sale Id 511',0.00,2010.00,720.00,2160.00,150.00,'2023-01-25 10:15:30'),(523,'1','303',1,'Retail Sale Id 512',0.00,4020.00,720.00,4320.00,300.00,'2023-01-25 10:17:48'),(524,'1','303',1,'Retail Sale Id 513',0.00,1862.60,720.00,2001.60,139.00,'2023-01-25 10:24:42'),(525,'1','303',1,'Retail Sale Id 514',0.00,67000.00,690.00,69000.00,2000.00,'2023-01-25 10:42:25'),(526,'1','303',1,'Retail Sale Id 515',0.00,2050.20,720.00,2203.20,153.00,'2023-01-25 10:46:34'),(527,'1','303',1,'Retail Sale Id 516',0.00,6700.00,720.00,7200.00,500.00,'2023-01-25 11:15:53'),(528,'1','303',1,'Retail Sale Id 517',0.00,931.30,720.00,1000.80,69.50,'2023-01-25 11:17:11'),(529,'1','303',1,'Retail Sale Id 518',0.00,4046.80,720.00,4348.80,302.00,'2023-01-25 11:29:12'),(530,'1','303',1,'Retail Sale Id 519',0.00,1862.60,720.00,2001.60,139.00,'2023-01-25 11:32:17'),(531,'1','303',1,'Retail Sale Id 520',0.00,4046.80,720.00,4348.80,302.00,'2023-01-25 11:44:45'),(532,'1','303',1,'Retail Sale Id 521',0.00,3350.00,720.00,3600.00,250.00,'2023-01-25 11:47:14'),(533,'1','303',1,'Retail Sale Id 522',0.00,33500.00,690.00,34500.00,1000.00,'2023-01-25 12:03:12'),(534,'1','303',1,'Retail Sale Id 523',0.00,1340.00,720.00,1440.00,100.00,'2023-01-25 12:04:46'),(535,'1','303',1,'Retail Sale Id 524',0.00,8375.00,720.00,9000.00,625.00,'2023-01-25 12:06:06'),(536,'1','303',1,'Retail Sale Id 525',0.00,33500.00,690.00,34500.00,1000.00,'2023-01-25 12:07:27'),(537,'1','303',1,'Retail Sale Id 526',0.00,4020.00,720.00,4320.00,300.00,'2023-01-25 12:09:28'),(538,'1','303',1,'Retail Sale Id 527',0.00,2010.00,720.00,2160.00,150.00,'2023-01-25 12:14:33'),(539,'1','303',1,'Retail Sale Id 528',0.00,1862.60,720.00,2001.60,139.00,'2023-01-25 12:16:18'),(540,'1','303',1,'Retail Sale Id 529',0.00,3350.00,720.00,3600.00,250.00,'2023-01-25 12:20:52'),(541,'1','303',1,'Retail Sale Id 530',0.00,6700.00,720.00,7200.00,500.00,'2023-01-25 12:22:58'),(542,'1','303',1,'Retail Sale Id 532',0.00,1862.60,720.00,2001.60,139.00,'2023-01-25 12:28:49'),(543,'1','303',1,'Retail Sale Id 533',0.00,5581.10,720.00,5997.60,416.50,'2023-01-25 12:43:35'),(544,'1','303',1,'Retail Sale Id 534',0.00,6030.00,720.00,6480.00,450.00,'2023-01-25 12:49:39'),(545,'1','303',1,'Retail Sale Id 535',0.00,2010.00,720.00,2160.00,150.00,'2023-01-25 12:58:37'),(546,'1','303',1,'Retail Sale Id 536',0.00,7370.00,720.00,7920.00,550.00,'2023-01-25 13:12:35'),(547,'1','303',1,'Retail Sale Id 537',0.00,2010.00,720.00,2160.00,150.00,'2023-01-25 13:16:39'),(548,'1','303',1,'Retail Sale Id 538',0.00,8375.00,720.00,9000.00,625.00,'2023-01-25 13:34:09'),(549,'1','303',1,'Retail Sale Id 539',0.00,1393.60,720.00,1497.60,104.00,'2023-01-25 13:39:02'),(550,'1','303',1,'Retail Sale Id 540',0.00,1487.40,720.00,1598.40,111.00,'2023-01-25 13:48:48'),(551,'1','303',1,'Retail Sale Id 541',0.00,4020.00,720.00,4320.00,300.00,'2023-01-25 13:51:46'),(552,'1','303',1,'Retail Sale Id 542',0.00,4020.00,720.00,4320.00,300.00,'2023-01-25 14:04:36'),(553,'1','303',1,'Retail Sale Id 543',0.00,4020.00,720.00,4320.00,300.00,'2023-01-25 14:30:48'),(554,'1','303',1,'Retail Sale Id 544',0.00,2050.20,720.00,2203.20,153.00,'2023-01-25 14:32:29'),(555,'1','303',1,'Retail Sale Id 545',0.00,4020.00,720.00,4320.00,300.00,'2023-01-25 14:38:44'),(556,'1','303',1,'Retail Sale Id 546',0.00,4020.00,720.00,4320.00,300.00,'2023-01-25 14:48:33'),(557,'1','303',1,'Retail Sale Id 547',0.00,2050.20,720.00,2203.20,153.00,'2023-01-25 15:01:36'),(558,'1','303',1,'Retail Sale Id 548',0.00,2050.20,720.00,2203.20,153.00,'2023-01-25 15:08:17'),(559,'1','303',1,'Retail Sale Id 549',0.00,4690.00,720.00,5040.00,350.00,'2023-01-25 15:18:20'),(560,'1','303',1,'Retail Sale Id 550',0.00,931.30,720.00,1000.80,69.50,'2023-01-25 15:27:21'),(561,'1','303',1,'Retail Sale Id 551',0.00,4020.00,720.00,4320.00,300.00,'2023-01-25 15:28:16'),(562,'1','303',1,'Retail Sale Id 552',0.00,2050.20,720.00,2203.20,153.00,'2023-01-25 15:29:22'),(563,'1','303',1,'Retail Sale Id 553',0.00,4020.00,720.00,4320.00,300.00,'2023-01-25 15:47:37'),(564,'1','303',1,'Retail Sale Id 554',0.00,2324.90,720.00,2498.40,173.50,'2023-01-25 15:52:46'),(565,'1','303',1,'Retail Sale Id 555',0.00,2010.00,720.00,2160.00,150.00,'2023-01-25 16:11:30'),(566,'1','303',1,'Retail Sale Id 556',0.00,2050.20,720.00,2203.20,153.00,'2023-01-25 16:21:42'),(567,'1','303',1,'Retail Sale Id 557',0.00,2050.20,720.00,2203.20,153.00,'2023-01-25 16:22:23'),(568,'1','303',1,'Retail Sale Id 558',0.00,4690.00,720.00,5040.00,350.00,'2023-01-25 16:28:03'),(569,'1','303',1,'Retail Sale Id 560',0.00,2010.00,720.00,2160.00,150.00,'2023-01-25 16:31:00'),(570,'1','303',1,'Retail Sale Id 562',0.00,2010.00,720.00,2160.00,150.00,'2023-01-25 16:33:29'),(571,'1','303',1,'Retail Sale Id 563',0.00,8375.00,720.00,9000.00,625.00,'2023-01-25 16:46:18'),(572,'1','303',1,'Retail Sale Id 564',0.00,2050.20,720.00,2203.20,153.00,'2023-01-25 16:47:08'),(573,'1','303',1,'Retail Sale Id 565',0.00,3350.00,720.00,3600.00,250.00,'2023-01-25 16:48:07'),(574,'1','303',1,'Retail Sale Id 566',0.00,8375.00,720.00,9000.00,625.00,'2023-01-25 17:06:36'),(575,'1','303',1,'Retail Sale Id 567',0.00,4020.00,720.00,4320.00,300.00,'2023-01-25 17:18:26'),(576,'1','303',1,'Retail Sale Id 568',0.00,4020.00,720.00,4320.00,300.00,'2023-01-25 17:22:15'),(577,'1','303',1,'Retail Sale Id 570',0.00,3350.00,720.00,3600.00,250.00,'2023-01-25 17:34:51'),(578,'1','303',1,'Retail Sale Id 571',0.00,1862.60,720.00,2001.60,139.00,'2023-01-25 17:36:32'),(579,'1','303',1,'Retail Sale Id 572',0.00,1862.60,720.00,2001.60,139.00,'2023-01-25 17:47:35'),(580,'1','303',1,'Retail Sale Id 574',0.00,1996.60,720.00,2145.60,149.00,'2023-01-25 18:38:39'),(581,'1','303',1,'Retail Sale Id 575',0.00,4020.00,720.00,4320.00,300.00,'2023-01-26 08:07:48'),(582,'1','303',1,'Retail Sale Id 576',0.00,4020.00,720.00,4320.00,300.00,'2023-01-26 08:33:33'),(583,'1','303',1,'Retail Sale Id 577',0.00,670.00,720.00,720.00,50.00,'2023-01-26 08:40:17'),(584,'1','303',1,'Retail Sale Id 577',0.00,6700.00,720.00,7200.00,500.00,'2023-01-26 08:40:17'),(585,'1','303',1,'Retail Sale Id 578',0.00,4187.50,720.00,4500.00,312.50,'2023-01-26 08:54:14'),(586,'1','303',1,'Retail Sale Id 579',0.00,1862.60,720.00,2001.60,139.00,'2023-01-26 08:59:10'),(587,'1','303',1,'Retail Sale Id 580',0.00,8375.00,720.00,9000.00,625.00,'2023-01-26 09:06:06'),(588,'1','303',1,'Retail Sale Id 581',0.00,2700.10,720.00,2901.60,201.50,'2023-01-26 09:08:11'),(589,'1','303',1,'Retail Sale Id 582',0.00,4020.00,720.00,4320.00,300.00,'2023-01-26 09:13:38'),(590,'1','303',1,'Retail Sale Id 582',0.00,8375.00,720.00,9000.00,625.00,'2023-01-26 09:13:38'),(591,'1','303',1,'Retail Sale Id 582',0.00,8375.00,720.00,9000.00,625.00,'2023-01-26 09:13:38'),(592,'1','303',1,'Retail Sale Id 583',0.00,670.00,720.00,720.00,50.00,'2023-01-26 09:15:02'),(593,'1','303',1,'Retail Sale Id 584',0.00,4020.00,720.00,4320.00,300.00,'2023-01-26 09:28:33'),(594,'1','303',1,'Retail Sale Id 585',0.00,2010.00,720.00,2160.00,150.00,'2023-01-26 09:31:02'),(595,'1','303',1,'Retail Sale Id 586',0.00,4046.80,720.00,4348.80,302.00,'2023-01-26 09:32:15'),(596,'1','303',1,'Retail Sale Id 587',0.00,8375.00,720.00,9000.00,625.00,'2023-01-26 09:34:06'),(597,'1','303',1,'Retail Sale Id 588',0.00,4020.00,720.00,4320.00,300.00,'2023-01-26 09:37:53'),(598,'1','303',1,'Retail Sale Id 589',0.00,2050.20,720.00,2203.20,153.00,'2023-01-26 09:40:59'),(599,'1','303',1,'Retail Sale Id 590',0.00,3725.20,720.00,4003.20,278.00,'2023-01-26 09:48:37'),(600,'1','303',1,'Retail Sale Id 591',0.00,4020.00,720.00,4320.00,300.00,'2023-01-26 09:51:45'),(601,'1','303',1,'Retail Sale Id 592',0.00,4020.00,720.00,4320.00,300.00,'2023-01-26 09:52:49'),(602,'1','303',1,'Retail Sale Id 593',0.00,1393.60,720.00,1497.60,104.00,'2023-01-26 09:55:02'),(603,'1','303',1,'Retail Sale Id 594',0.00,3350.00,720.00,3600.00,250.00,'2023-01-26 10:02:05'),(604,'1','303',1,'Retail Sale Id 595',0.00,4046.80,720.00,4348.80,302.00,'2023-01-26 10:08:48'),(605,'1','303',1,'Retail Sale Id 596',0.00,2050.20,720.00,2203.20,153.00,'2023-01-26 10:10:57'),(606,'1','303',1,'Retail Sale Id 597',0.00,8375.00,720.00,9000.00,625.00,'2023-01-26 10:26:09'),(607,'1','303',1,'Retail Sale Id 599',0.00,4046.80,720.00,4348.80,302.00,'2023-01-26 10:29:25'),(608,'1','303',1,'Retail Sale Id 600',0.00,1212.70,720.00,1303.20,90.50,'2023-01-26 10:34:42'),(609,'1','303',1,'Retail Sale Id 601',0.00,2324.90,720.00,2498.40,173.50,'2023-01-26 10:35:56'),(610,'1','303',1,'Retail Sale Id 602',0.00,2793.90,720.00,3002.40,208.50,'2023-01-26 10:46:06'),(611,'1','303',1,'Retail Sale Id 603',0.00,3350.00,720.00,3600.00,250.00,'2023-01-26 10:51:44'),(612,'1','303',1,'Retail Sale Id 604',0.00,3350.00,720.00,3600.00,250.00,'2023-01-26 10:57:08'),(613,'1','303',1,'Retail Sale Id 605',0.00,4020.00,720.00,4320.00,300.00,'2023-01-26 10:59:31'),(614,'1','303',1,'Retail Sale Id 607',0.00,4020.00,720.00,4320.00,300.00,'2023-01-26 11:08:52'),(615,'1','303',1,'Retail Sale Id 607',0.00,4020.00,720.00,4320.00,300.00,'2023-01-26 11:08:52'),(616,'1','303',1,'Retail Sale Id 608',0.00,3350.00,720.00,3600.00,250.00,'2023-01-26 11:12:12'),(617,'1','303',1,'Retail Sale Id 609',0.00,2010.00,720.00,2160.00,150.00,'2023-01-26 11:23:48'),(618,'1','303',1,'Retail Sale Id 610',0.00,4020.00,720.00,4320.00,300.00,'2023-01-26 11:29:06'),(619,'1','303',1,'Retail Sale Id 611',0.00,4020.00,720.00,4320.00,300.00,'2023-01-26 11:33:57'),(620,'1','303',1,'Retail Sale Id 612',0.00,2010.00,720.00,2160.00,150.00,'2023-01-26 11:41:54'),(621,'1','303',1,'Retail Sale Id 613',0.00,4046.80,720.00,4348.80,302.00,'2023-01-26 11:48:20'),(622,'1','303',1,'Retail Sale Id 614',0.00,2793.90,720.00,3002.40,208.50,'2023-01-26 11:50:57'),(623,'1','303',1,'Retail Sale Id 615',0.00,3725.20,720.00,4003.20,278.00,'2023-01-26 11:56:25'),(624,'1','303',1,'Retail Sale Id 616',0.00,743.70,720.00,799.20,55.50,'2023-01-26 12:08:27'),(625,'1','303',1,'Retail Sale Id 617',0.00,4020.00,720.00,4320.00,300.00,'2023-01-26 12:23:29'),(626,'1','303',1,'Retail Sale Id 619',0.00,8375.00,720.00,9000.00,625.00,'2023-01-26 12:25:23'),(627,'1','303',1,'Retail Sale Id 620',0.00,8375.00,720.00,9000.00,625.00,'2023-01-26 12:50:14'),(628,'1','303',1,'Retail Sale Id 621',0.00,931.30,720.00,1000.80,69.50,'2023-01-26 13:03:32'),(629,'1','303',1,'Retail Sale Id 622',0.00,1393.60,720.00,1497.60,104.00,'2023-01-26 13:05:42'),(630,'1','303',1,'Retail Sale Id 623',0.00,1393.60,720.00,1497.60,104.00,'2023-01-26 13:07:27'),(631,'1','303',1,'Retail Sale Id 626',0.00,5360.00,720.00,5760.00,400.00,'2023-01-26 13:22:35'),(632,'1','303',1,'Retail Sale Id 627',0.00,4020.00,720.00,4320.00,300.00,'2023-01-26 13:40:01'),(633,'1','303',1,'Retail Sale Id 628',0.00,4020.00,720.00,4320.00,300.00,'2023-01-26 13:41:26'),(634,'1','303',1,'Retail Sale Id 629',0.00,4020.00,720.00,4320.00,300.00,'2023-01-26 13:43:45'),(635,'1','303',1,'Retail Sale Id 630',0.00,8375.00,720.00,9000.00,625.00,'2023-01-26 13:47:38'),(636,'1','303',1,'Retail Sale Id 630',0.00,8375.00,720.00,9000.00,625.00,'2023-01-26 13:47:38'),(637,'1','303',1,'Retail Sale Id 631',0.00,2010.00,720.00,2160.00,150.00,'2023-01-26 13:58:45'),(638,'1','303',1,'Retail Sale Id 632',0.00,2010.00,720.00,2160.00,150.00,'2023-01-26 14:05:13'),(639,'1','303',1,'Retail Sale Id 633',0.00,4020.00,720.00,4320.00,300.00,'2023-01-26 14:13:51'),(640,'1','303',1,'Retail Sale Id 633',0.00,8375.00,720.00,9000.00,625.00,'2023-01-26 14:13:51'),(641,'1','303',1,'Retail Sale Id 633',0.00,8375.00,720.00,9000.00,625.00,'2023-01-26 14:13:51'),(642,'1','303',1,'Retail Sale Id 634',0.00,4690.00,720.00,5040.00,350.00,'2023-01-26 14:32:55'),(643,'1','303',1,'Retail Sale Id 635',0.00,2010.00,720.00,2160.00,150.00,'2023-01-26 14:35:03'),(644,'1','303',1,'Retail Sale Id 636',0.00,4020.00,720.00,4320.00,300.00,'2023-01-26 14:40:56'),(645,'1','303',1,'Retail Sale Id 637',0.00,2010.00,720.00,2160.00,150.00,'2023-01-26 14:42:56'),(646,'1','303',1,'Retail Sale Id 638',0.00,670.00,720.00,720.00,50.00,'2023-01-26 14:46:07'),(647,'1','303',1,'Retail Sale Id 639',0.00,8375.00,720.00,9000.00,625.00,'2023-01-26 14:48:58'),(648,'1','303',1,'Retail Sale Id 640',0.00,8375.00,720.00,9000.00,625.00,'2023-01-26 14:50:03'),(649,'1','303',1,'Retail Sale Id 641',0.00,931.30,720.00,1000.80,69.50,'2023-01-26 14:51:01'),(650,'1','303',1,'Retail Sale Id 642',0.00,670.00,720.00,720.00,50.00,'2023-01-26 15:05:01'),(651,'1','303',1,'Retail Sale Id 643',0.00,3350.00,720.00,3600.00,250.00,'2023-01-26 15:13:09'),(652,'1','303',1,'Retail Sale Id 644',0.00,3350.00,720.00,3600.00,250.00,'2023-01-26 15:23:47'),(653,'1','303',1,'Retail Sale Id 645',0.00,3350.00,720.00,3600.00,250.00,'2023-01-26 15:25:14'),(654,'1','303',1,'Retail Sale Id 646',0.00,3350.00,720.00,3600.00,250.00,'2023-01-26 15:37:02'),(655,'1','303',1,'Retail Sale Id 647',0.00,2010.00,720.00,2160.00,150.00,'2023-01-26 15:42:31'),(656,'1','303',1,'Retail Sale Id 648',0.00,2010.00,720.00,2160.00,150.00,'2023-01-26 15:46:21'),(657,'1','303',1,'Retail Sale Id 648',0.00,2010.00,720.00,2160.00,150.00,'2023-01-26 15:46:21'),(658,'1','303',1,'Retail Sale Id 649',0.00,3350.00,720.00,3600.00,250.00,'2023-01-26 16:18:21'),(659,'1','303',1,'Retail Sale Id 650',0.00,4020.00,720.00,4320.00,300.00,'2023-01-26 16:37:38'),(660,'1','303',1,'Retail Sale Id 651',0.00,2050.20,720.00,2203.20,153.00,'2023-01-26 16:44:36'),(661,'1','303',1,'Retail Sale Id 652',0.00,8375.00,720.00,9000.00,625.00,'2023-01-26 16:46:12'),(662,'1','303',1,'Retail Sale Id 653',0.00,2793.90,720.00,3002.40,208.50,'2023-01-26 16:49:59'),(663,'1','303',1,'Retail Sale Id 654',0.00,2010.00,720.00,2160.00,150.00,'2023-01-26 16:56:30'),(664,'1','303',1,'Retail Sale Id 655',0.00,2010.00,720.00,2160.00,150.00,'2023-01-26 17:09:29'),(665,'1','303',1,'Retail Sale Id 656',0.00,4020.00,720.00,4320.00,300.00,'2023-01-26 17:14:17'),(666,'1','303',1,'Retail Sale Id 657',0.00,4046.80,720.00,4348.80,302.00,'2023-01-26 17:16:31'),(667,'1','303',1,'Retail Sale Id 658',0.00,4020.00,720.00,4320.00,300.00,'2023-01-26 17:20:21'),(668,'1','303',1,'Retail Sale Id 659',0.00,931.30,720.00,1000.80,69.50,'2023-01-26 17:21:48'),(669,'1','303',1,'Retail Sale Id 660',0.00,4020.00,720.00,4320.00,300.00,'2023-01-26 17:27:50'),(670,'1','303',1,'Retail Sale Id 661',0.00,3350.00,720.00,3600.00,250.00,'2023-01-26 17:31:53'),(671,'1','303',1,'Retail Sale Id 662',0.00,2010.00,720.00,2160.00,150.00,'2023-01-26 17:33:37'),(672,'1','303',1,'Retail Sale Id 663',0.00,3999.90,720.00,4298.40,298.50,'2023-01-26 17:35:21'),(673,'1','303',1,'Retail Sale Id 665',0.00,3350.00,720.00,3600.00,250.00,'2023-01-26 17:39:43'),(674,'1','303',1,'Retail Sale Id 666',0.00,2010.00,720.00,2160.00,150.00,'2023-01-26 17:45:45'),(675,'1','303',1,'Retail Sale Id 667',0.00,3350.00,720.00,3600.00,250.00,'2023-01-26 17:59:23'),(676,'1','303',1,'Return of Retail Sale Id 659',931.30,0.00,720.00,-1000.80,-69.50,'2023-01-26 18:11:16'),(677,'1','303',1,'Retail Sale Id 668',0.00,388.60,720.00,417.60,29.00,'2023-01-26 18:14:29'),(678,'1','303',1,'Retail Sale Id 669',0.00,4020.00,720.00,4320.00,300.00,'2023-01-27 08:24:50'),(679,'1','303',1,'Retail Sale Id 670',0.00,2793.90,720.00,3002.40,208.50,'2023-01-27 08:25:58'),(680,'1','303',1,'Retail Sale Id 671',0.00,2010.00,720.00,2160.00,150.00,'2023-01-27 08:39:21'),(681,'1','303',1,'Retail Sale Id 671',0.00,8375.00,720.00,9000.00,625.00,'2023-01-27 08:39:21'),(682,'1','303',1,'Retail Sale Id 672',0.00,2700.10,720.00,2901.60,201.50,'2023-01-27 08:40:34'),(683,'1','303',1,'Retail Sale Id 674',0.00,2793.90,720.00,3002.40,208.50,'2023-01-27 08:55:58'),(684,'1','303',1,'Retail Sale Id 675',0.00,8375.00,720.00,9000.00,625.00,'2023-01-27 08:57:06'),(685,'1','303',1,'Retail Sale Id 678',0.00,1118.90,720.00,1202.40,83.50,'2023-01-27 09:19:28'),(686,'1','303',1,'Retail Sale Id 678',0.00,8375.00,720.00,9000.00,625.00,'2023-01-27 09:19:28'),(687,'1','303',1,'Retail Sale Id 679',0.00,3350.00,720.00,3600.00,250.00,'2023-01-27 09:36:40'),(688,'1','303',1,'Retail Sale Id 680',0.00,8375.00,720.00,9000.00,625.00,'2023-01-27 09:38:55'),(689,'1','303',1,'Retail Sale Id 681',0.00,4020.00,720.00,4320.00,300.00,'2023-01-27 09:39:59'),(690,'1','303',1,'Retail Sale Id 682',0.00,4020.00,720.00,4320.00,300.00,'2023-01-27 09:40:57'),(691,'1','303',1,'Retail Sale Id 683',0.00,8375.00,720.00,9000.00,625.00,'2023-01-27 09:42:05'),(692,'1','303',1,'Retail Sale Id 685',0.00,3350.00,720.00,3600.00,250.00,'2023-01-27 09:43:54'),(693,'1','303',1,'Retail Sale Id 686',0.00,8375.00,720.00,9000.00,625.00,'2023-01-27 09:44:54'),(694,'1','303',1,'Retail Sale Id 687',0.00,2050.20,720.00,2203.20,153.00,'2023-01-27 09:45:52'),(695,'1','303',1,'Retail Sale Id 689',0.00,2010.00,720.00,2160.00,150.00,'2023-01-27 09:50:32'),(696,'1','303',1,'Retail Sale Id 689',0.00,4020.00,720.00,4320.00,300.00,'2023-01-27 09:50:32'),(697,'1','303',1,'Retail Sale Id 690',0.00,2793.90,720.00,3002.40,208.50,'2023-01-27 09:54:08'),(698,'1','303',1,'Retail Sale Id 691',0.00,2050.20,720.00,2203.20,153.00,'2023-01-27 10:03:43'),(699,'1','303',1,'Retail Sale Id 693',0.00,7370.00,720.00,7920.00,550.00,'2023-01-27 10:08:00'),(700,'1','303',1,'Retail Sale Id 694',0.00,8375.00,720.00,9000.00,625.00,'2023-01-27 10:19:02'),(701,'1','303',1,'Retail Sale Id 695',0.00,1340.00,720.00,1440.00,100.00,'2023-01-27 10:23:58'),(702,'1','303',1,'Retail Sale Id 696',0.00,4020.00,720.00,4320.00,300.00,'2023-01-27 10:40:30'),(703,'1','303',1,'Retail Sale Id 697',0.00,8375.00,720.00,9000.00,625.00,'2023-01-27 10:51:06'),(704,'1','303',1,'Retail Sale Id 698',0.00,3350.00,720.00,3600.00,250.00,'2023-01-27 10:52:06'),(705,'1','303',1,'Retail Sale Id 699',0.00,2700.10,720.00,2901.60,201.50,'2023-01-27 10:56:17'),(706,'1','303',1,'Retail Sale Id 700',0.00,3350.00,720.00,3600.00,250.00,'2023-01-27 10:57:27'),(707,'1','303',1,'Retail Sale Id 701',0.00,2010.00,720.00,2160.00,150.00,'2023-01-27 11:05:09'),(708,'1','303',1,'Retail Sale Id 702',0.00,2010.00,720.00,2160.00,150.00,'2023-01-27 11:27:53'),(709,'1','303',1,'Retail Sale Id 703',0.00,2010.00,720.00,2160.00,150.00,'2023-01-27 11:35:46'),(710,'1','303',1,'Retail Sale Id 704',0.00,1393.60,720.00,1497.60,104.00,'2023-01-27 11:45:41'),(711,'1','303',1,'Retail Sale Id 705',0.00,4020.00,720.00,4320.00,300.00,'2023-01-27 11:51:58'),(712,'1','303',1,'Retail Sale Id 706',0.00,2010.00,720.00,2160.00,150.00,'2023-01-27 11:55:56'),(713,'1','303',1,'Retail Sale Id 707',0.00,4020.00,720.00,4320.00,300.00,'2023-01-27 11:58:14'),(714,'1','303',1,'Retail Sale Id 708',0.00,8375.00,720.00,9000.00,625.00,'2023-01-27 12:31:46'),(715,'1','303',1,'Retail Sale Id 709',0.00,2010.00,720.00,2160.00,150.00,'2023-01-27 12:34:19'),(716,'1','303',1,'Retail Sale Id 710',0.00,4690.00,720.00,5040.00,350.00,'2023-01-27 13:09:54'),(717,'1','303',1,'Retail Sale Id 711',0.00,1340.00,720.00,1440.00,100.00,'2023-01-27 13:20:42'),(718,'1','303',1,'Retail Sale Id 711',0.00,1340.00,720.00,1440.00,100.00,'2023-01-27 13:20:42'),(719,'1','303',1,'Retail Sale Id 712',0.00,2010.00,720.00,2160.00,150.00,'2023-01-27 13:22:11'),(720,'1','303',1,'Retail Sale Id 713',0.00,2793.90,720.00,3002.40,208.50,'2023-01-27 14:24:02'),(721,'1','303',1,'Retail Sale Id 714',0.00,931.30,720.00,1000.80,69.50,'2023-01-27 14:35:18'),(722,'1','303',1,'Retail Sale Id 715',0.00,4020.00,720.00,4320.00,300.00,'2023-01-27 14:50:31'),(723,'1','303',1,'Retail Sale Id 716',0.00,8375.00,720.00,9000.00,625.00,'2023-01-27 14:53:22'),(724,'1','303',1,'Retail Sale Id 717',0.00,649.90,720.00,698.40,48.50,'2023-01-27 14:54:25'),(725,'1','303',1,'Retail Sale Id 718',0.00,3999.90,720.00,4298.40,298.50,'2023-01-27 14:55:50'),(726,'1','303',1,'Retail Sale Id 719',0.00,4020.00,720.00,4320.00,300.00,'2023-01-27 14:58:14'),(727,'1','303',1,'Retail Sale Id 720',0.00,2050.20,720.00,2203.20,153.00,'2023-01-27 14:59:24'),(728,'1','303',1,'Retail Sale Id 721',0.00,5360.00,720.00,5760.00,400.00,'2023-01-27 15:18:15'),(729,'1','303',1,'Retail Sale Id 722',0.00,8375.00,720.00,9000.00,625.00,'2023-01-27 15:24:58'),(730,'1','303',1,'Retail Sale Id 723',0.00,4020.00,720.00,4320.00,300.00,'2023-01-27 15:27:20'),(731,'1','303',1,'Retail Sale Id 724',0.00,4020.00,720.00,4320.00,300.00,'2023-01-27 15:29:44'),(732,'1','303',1,'Retail Sale Id 724',0.00,4020.00,720.00,4320.00,300.00,'2023-01-27 15:29:44'),(733,'1','303',1,'Retail Sale Id 725',0.00,3350.00,720.00,3600.00,250.00,'2023-01-27 15:42:44'),(734,'1','303',1,'Retail Sale Id 726',0.00,4020.00,720.00,4320.00,300.00,'2023-01-27 16:10:07'),(735,'1','303',1,'Retail Sale Id 727',0.00,4020.00,720.00,4320.00,300.00,'2023-01-27 16:13:32'),(736,'1','303',1,'Retail Sale Id 728',0.00,2010.00,720.00,2160.00,150.00,'2023-01-27 16:17:30'),(737,'1','303',1,'Retail Sale Id 728',0.00,8375.00,720.00,9000.00,625.00,'2023-01-27 16:17:30'),(738,'1','303',1,'Retail Sale Id 729',0.00,5581.10,720.00,5997.60,416.50,'2023-01-27 17:06:11'),(739,'1','303',1,'Retail Sale Id 730',0.00,1005.00,720.00,1080.00,75.00,'2023-01-27 17:14:06'),(740,'1','303',1,'Retail Sale Id 731',0.00,3350.00,720.00,3600.00,250.00,'2023-01-27 17:19:30'),(741,'1','303',1,'Retail Sale Id 732',0.00,2050.20,720.00,2203.20,153.00,'2023-01-27 17:25:36'),(742,'1','303',1,'Retail Sale Id 733',0.00,4020.00,720.00,4320.00,300.00,'2023-01-27 17:27:51'),(743,'1','303',1,'Retail Sale Id 733',0.00,4020.00,720.00,4320.00,300.00,'2023-01-27 17:27:51'),(744,'1','303',1,'Retail Sale Id 734',0.00,7443.70,720.00,7999.20,555.50,'2023-01-27 17:31:33'),(745,'1','303',1,'Retail Sale Id 735',0.00,1346.70,720.00,1447.20,100.50,'2023-01-27 17:32:49'),(746,'1','303',1,'Retail Sale Id 736',0.00,3350.00,720.00,3600.00,250.00,'2023-01-27 18:01:44'),(747,'1','303',1,'Retail Sale Id 737',0.00,2010.00,720.00,2160.00,150.00,'2023-01-27 18:03:33'),(748,'1','303',1,'Retail Sale Id 737',0.00,2010.00,720.00,2160.00,150.00,'2023-01-27 18:03:33'),(749,'1','303',1,'Retail Sale Id 738',0.00,180.90,720.00,194.40,13.50,'2023-01-27 19:24:36'),(750,'1','303',1,'Retail Sale Id 739',0.00,3999.90,720.00,4298.40,298.50,'2023-01-28 07:10:45'),(751,'1','303',1,'Retail Sale Id 740',0.00,837.50,720.00,900.00,62.50,'2023-01-28 08:32:35'),(752,'1','303',1,'Retail Sale Id 741',0.00,6700.00,720.00,7200.00,500.00,'2023-01-28 08:44:20'),(753,'1','303',1,'Retail Sale Id 742',0.00,1862.60,720.00,2001.60,139.00,'2023-01-28 08:53:51'),(754,'1','303',1,'Retail Sale Id 743',0.00,1956.40,720.00,2102.40,146.00,'2023-01-28 09:10:08'),(755,'1','303',1,'Retail Sale Id 744',0.00,3999.90,720.00,4298.40,298.50,'2023-01-28 09:40:45'),(756,'1','303',1,'Retail Sale Id 746',0.00,2700.10,720.00,2901.60,201.50,'2023-01-28 09:47:35'),(757,'1','303',1,'Retail Sale Id 747',0.00,2324.90,720.00,2498.40,173.50,'2023-01-28 09:55:16'),(758,'1','303',1,'Retail Sale Id 748',0.00,4020.00,720.00,4320.00,300.00,'2023-01-28 10:02:25'),(759,'1','303',1,'Retail Sale Id 749',0.00,2700.10,720.00,2901.60,201.50,'2023-01-28 10:13:25'),(760,'1','303',1,'Retail Sale Id 750',0.00,4020.00,720.00,4320.00,300.00,'2023-01-28 10:47:05'),(761,'1','303',1,'Retail Sale Id 751',0.00,3350.00,720.00,3600.00,250.00,'2023-01-28 10:56:26'),(762,'1','303',1,'Retail Sale Id 752',0.00,1862.60,720.00,2001.60,139.00,'2023-01-28 10:57:59'),(763,'1','303',1,'Retail Sale Id 753',0.00,2793.90,720.00,3002.40,208.50,'2023-01-28 10:59:49'),(764,'1','303',1,'Retail Sale Id 754',0.00,1340.00,720.00,1440.00,100.00,'2023-01-28 11:08:57'),(765,'1','303',1,'Retail Sale Id 755',0.00,6700.00,720.00,7200.00,500.00,'2023-01-28 11:24:55'),(766,'1','303',1,'Retail Sale Id 756',0.00,83750.00,720.00,90000.00,6250.00,'2023-01-28 11:26:57'),(767,'1','303',1,'Retail Sale Id 757',0.00,8375.00,720.00,9000.00,625.00,'2023-01-28 11:29:52'),(768,'1','303',1,'Retail Sale Id 758',0.00,4020.00,720.00,4320.00,300.00,'2023-01-28 11:31:49'),(769,'1','303',1,'Retail Sale Id 759',0.00,3350.00,720.00,3600.00,250.00,'2023-01-28 11:33:08'),(770,'1','303',1,'Return of Retail Sale Id 756',83750.00,0.00,720.00,-90000.00,-6250.00,'2023-01-28 11:36:21'),(771,'1','303',1,'Retail Sale Id 760',0.00,1393.60,720.00,1497.60,104.00,'2023-01-28 11:39:49'),(772,'1','303',1,'Retail Sale Id 761',0.00,4020.00,720.00,4320.00,300.00,'2023-01-28 11:50:29'),(773,'1','303',1,'Retail Sale Id 761',0.00,6700.00,720.00,7200.00,500.00,'2023-01-28 11:50:29'),(774,'1','303',1,'Retail Sale Id 762',0.00,4020.00,720.00,4320.00,300.00,'2023-01-28 11:59:35'),(775,'1','303',1,'Retail Sale Id 763',0.00,2050.20,720.00,2203.20,153.00,'2023-01-28 12:01:23'),(776,'1','303',1,'Retail Sale Id 764',0.00,4020.00,720.00,4320.00,300.00,'2023-01-28 12:06:08'),(777,'1','303',1,'Retail Sale Id 765',0.00,2050.20,720.00,2203.20,153.00,'2023-01-28 12:09:26'),(778,'1','303',1,'Retail Sale Id 766',0.00,8375.00,720.00,9000.00,625.00,'2023-01-28 12:11:22'),(779,'1','303',1,'Retail Sale Id 767',0.00,2050.20,720.00,2203.20,153.00,'2023-01-28 12:20:06'),(780,'1','303',1,'Retail Sale Id 768',0.00,1393.60,720.00,1497.60,104.00,'2023-01-28 12:24:35'),(781,'1','303',1,'Retail Sale Id 769',0.00,4020.00,720.00,4320.00,300.00,'2023-01-28 12:30:02'),(782,'1','303',1,'Retail Sale Id 770',0.00,3350.00,720.00,3600.00,250.00,'2023-01-28 12:45:43'),(783,'1','303',1,'Retail Sale Id 771',0.00,6700.00,720.00,7200.00,500.00,'2023-01-28 12:54:00'),(784,'1','303',1,'Retail Sale Id 773',0.00,1340.00,720.00,1440.00,100.00,'2023-01-28 13:01:16'),(785,'1','303',1,'Retail Sale Id 774',0.00,8375.00,720.00,9000.00,625.00,'2023-01-28 13:38:29'),(786,'1','303',1,'Retail Sale Id 775',0.00,4046.80,720.00,4348.80,302.00,'2023-01-28 13:40:17'),(787,'1','303',1,'Retail Sale Id 776',0.00,2050.20,720.00,2203.20,153.00,'2023-01-28 13:41:37'),(788,'1','303',1,'Retail Sale Id 777',0.00,1862.60,720.00,2001.60,139.00,'2023-01-28 13:43:43'),(789,'1','303',1,'Retail Sale Id 778',0.00,3350.00,720.00,3600.00,250.00,'2023-01-28 13:44:40'),(790,'1','303',1,'Retail Sale Id 779',0.00,569526.80,690.00,586527.60,17000.80,'2023-01-28 13:48:35'),(791,'1','303',1,'Retail Sale Id 780',0.00,1862.60,720.00,2001.60,139.00,'2023-01-28 13:55:00'),(792,'1','303',1,'Retail Sale Id 781',0.00,2050.20,720.00,2203.20,153.00,'2023-01-28 13:58:37'),(793,'1','303',1,'Retail Sale Id 782',0.00,4020.00,720.00,4320.00,300.00,'2023-01-28 14:11:26'),(794,'1','303',1,'Retail Sale Id 783',0.00,2010.00,720.00,2160.00,150.00,'2023-01-28 14:23:02'),(795,'1','303',1,'Retail Sale Id 784',0.00,5581.10,720.00,5997.60,416.50,'2023-01-28 14:51:51'),(796,'1','303',1,'Retail Sale Id 785',0.00,3999.90,720.00,4298.40,298.50,'2023-01-28 14:58:21'),(797,'1','303',1,'Retail Sale Id 786',0.00,4649.80,720.00,4996.80,347.00,'2023-01-28 15:06:45'),(798,'1','303',1,'Retail Sale Id 787',0.00,8375.00,720.00,9000.00,625.00,'2023-01-28 15:08:00'),(799,'1','303',1,'Retail Sale Id 788',0.00,3999.90,720.00,4298.40,298.50,'2023-01-28 15:16:21'),(800,'1','303',1,'Retail Sale Id 789',0.00,3999.90,720.00,4298.40,298.50,'2023-01-28 15:18:01'),(801,'1','303',1,'Retail Sale Id 790',0.00,8375.00,720.00,9000.00,625.00,'2023-01-28 15:23:23'),(802,'1','303',1,'Retail Sale Id 791',0.00,2050.20,720.00,2203.20,153.00,'2023-01-28 15:45:05'),(803,'1','303',1,'Retail Sale Id 792',0.00,8375.00,720.00,9000.00,625.00,'2023-01-28 15:56:25'),(804,'1','303',1,'Retail Sale Id 793',0.00,2050.20,720.00,2203.20,153.00,'2023-01-28 16:03:19'),(805,'1','303',1,'Retail Sale Id 794',0.00,2010.00,720.00,2160.00,150.00,'2023-01-28 16:06:19'),(806,'1','303',1,'Retail Sale Id 794',0.00,4020.00,720.00,4320.00,300.00,'2023-01-28 16:06:19'),(807,'1','303',1,'Retail Sale Id 795',0.00,234500.00,690.00,241500.00,7000.00,'2023-01-28 16:15:35'),(808,'1','303',1,'Retail Sale Id 796',0.00,2010.00,720.00,2160.00,150.00,'2023-01-28 16:20:17'),(809,'1','303',1,'Retail Sale Id 796',0.00,2010.00,720.00,2160.00,150.00,'2023-01-28 16:20:17'),(810,'1','303',1,'Retail Sale Id 797',0.00,2050.20,720.00,2203.20,153.00,'2023-01-28 16:27:53'),(811,'1','303',1,'Retail Sale Id 798',0.00,1862.60,720.00,2001.60,139.00,'2023-01-28 16:47:51'),(812,'1','303',1,'Retail Sale Id 799',0.00,2050.20,720.00,2203.20,153.00,'2023-01-28 16:56:58'),(813,'1','303',1,'Retail Sale Id 800',0.00,4020.00,720.00,4320.00,300.00,'2023-01-28 16:58:44'),(814,'1','303',1,'Retail Sale Id 801',0.00,2050.20,720.00,2203.20,153.00,'2023-01-28 17:05:03'),(815,'1','303',1,'Retail Sale Id 802',0.00,2050.20,720.00,2203.20,153.00,'2023-01-28 17:30:18'),(816,'1','303',1,'Retail Sale Id 803',0.00,4020.00,720.00,4320.00,300.00,'2023-01-28 17:31:58'),(817,'1','303',1,'Retail Sale Id 804',0.00,4020.00,720.00,4320.00,300.00,'2023-01-28 17:33:19'),(818,'1','303',1,'Retail Sale Id 804',0.00,6700.00,720.00,7200.00,500.00,'2023-01-28 17:33:19'),(819,'1','303',1,'Retail Sale Id 805',0.00,8375.00,720.00,9000.00,625.00,'2023-01-28 17:49:42'),(820,'1','303',1,'Return of Retail Sale Id 805',8375.00,0.00,720.00,-9000.00,-625.00,'2023-01-28 18:54:52'),(821,'1','303',1,'Retail Sale Id 806',0.00,4254.50,720.00,4572.00,317.50,'2023-01-28 18:55:53'),(822,'1','303',1,'Retail Sale Id 807',0.00,0.00,720.00,0.00,0.00,'2023-01-28 18:58:41'),(823,'1','303',1,'Retail Sale Id 808',0.00,931.30,720.00,1000.80,69.50,'2023-01-28 19:00:17'),(824,'1','303',1,'Return of Retail Sale Id 807',0.00,0.00,720.00,0.00,0.00,'2023-01-28 19:02:13'),(825,'1','303',1,'Return of Retail Sale Id 801',2050.20,0.00,720.00,-2203.20,-153.00,'2023-01-28 19:04:25'),(826,'1','303',1,'Retail Sale Id 809',0.00,1118.90,720.00,1202.40,83.50,'2023-01-28 19:05:30'),(827,'1','303',1,'Retail Sale Id 810',0.00,10050.00,690.00,10350.00,300.00,'2023-01-28 19:10:57'),(828,'1','303',1,'Return of Retail Sale Id 810',10050.00,0.00,690.00,-10350.00,-300.00,'2023-01-28 19:15:52'),(829,'1','303',1,'Retail Sale Id 811',0.00,4187.50,720.00,4500.00,312.50,'2023-01-29 08:01:28'),(830,'1','303',1,'Retail Sale Id 812',0.00,3999.90,720.00,4298.40,298.50,'2023-01-29 08:58:10'),(831,'1','303',1,'Retail Sale Id 813',0.00,3999.90,720.00,4298.40,298.50,'2023-01-29 08:59:12'),(832,'1','303',1,'Retail Sale Id 814',0.00,4649.80,720.00,4996.80,347.00,'2023-01-29 09:06:57'),(833,'1','303',1,'Retail Sale Id 815',0.00,4187.50,720.00,4500.00,312.50,'2023-01-29 09:08:20'),(834,'1','303',1,'Retail Sale Id 816',0.00,2050.20,720.00,2203.20,153.00,'2023-01-29 09:14:43'),(835,'1','303',1,'Retail Sale Id 817',0.00,2793.90,720.00,3002.40,208.50,'2023-01-29 09:18:18'),(836,'1','303',1,'Retail Sale Id 818',0.00,8375.00,720.00,9000.00,625.00,'2023-01-29 09:28:08'),(837,'1','303',1,'Retail Sale Id 819',0.00,2050.20,720.00,2203.20,153.00,'2023-01-29 09:38:44'),(838,'1','303',1,'Retail Sale Id 820',0.00,4020.00,720.00,4320.00,300.00,'2023-01-29 09:41:06'),(839,'1','303',1,'Retail Sale Id 821',0.00,4020.00,720.00,4320.00,300.00,'2023-01-29 09:50:59'),(840,'1','303',1,'Retail Sale Id 822',0.00,2050.20,720.00,2203.20,153.00,'2023-01-29 10:16:32'),(841,'1','303',1,'Retail Sale Id 823',0.00,3999.90,720.00,4298.40,298.50,'2023-01-29 10:18:41'),(842,'1','303',1,'Retail Sale Id 824',0.00,4020.00,720.00,4320.00,300.00,'2023-01-29 10:22:14'),(843,'1','303',1,'Retail Sale Id 825',0.00,8375.00,720.00,9000.00,625.00,'2023-01-29 10:23:47'),(844,'1','303',1,'Retail Sale Id 827',0.00,8375.00,720.00,9000.00,625.00,'2023-01-29 10:27:29'),(845,'1','303',1,'Retail Sale Id 828',0.00,3999.90,720.00,4298.40,298.50,'2023-01-29 10:31:37'),(846,'1','303',1,'Retail Sale Id 829',0.00,3999.90,720.00,4298.40,298.50,'2023-01-29 10:33:59'),(847,'1','303',1,'Retail Sale Id 830',0.00,2010.00,720.00,2160.00,150.00,'2023-01-29 10:41:51'),(848,'1','303',1,'Retail Sale Id 831',0.00,3350.00,720.00,3600.00,250.00,'2023-01-29 10:52:33'),(849,'1','303',1,'Retail Sale Id 832',0.00,2010.00,720.00,2160.00,150.00,'2023-01-29 10:57:39'),(850,'1','303',1,'Retail Sale Id 833',0.00,931.30,720.00,1000.80,69.50,'2023-01-29 10:59:55'),(851,'1','303',1,'Retail Sale Id 834',0.00,3999.90,720.00,4298.40,298.50,'2023-01-29 11:13:37'),(852,'1','303',1,'Retail Sale Id 835',0.00,4093.70,720.00,4399.20,305.50,'2023-01-29 11:30:32'),(853,'1','303',1,'Retail Sale Id 836',0.00,1862.60,720.00,2001.60,139.00,'2023-01-29 11:38:38'),(854,'1','303',1,'Retail Sale Id 837',0.00,4020.00,720.00,4320.00,300.00,'2023-01-29 11:40:32'),(855,'1','303',1,'Retail Sale Id 838',0.00,6700.00,720.00,7200.00,500.00,'2023-01-29 11:48:12'),(856,'1','303',1,'Retail Sale Id 839',0.00,33500.00,690.00,34500.00,1000.00,'2023-01-29 11:50:01'),(857,'1','303',1,'Retail Sale Id 841',0.00,1862.60,720.00,2001.60,139.00,'2023-01-29 11:55:21'),(858,'1','303',1,'Retail Sale Id 842',0.00,2050.20,720.00,2203.20,153.00,'2023-01-29 12:07:32'),(859,'1','303',1,'Retail Sale Id 843',0.00,8040.00,720.00,8640.00,600.00,'2023-01-29 12:18:15'),(860,'1','303',1,'Retail Sale Id 844',0.00,3999.90,720.00,4298.40,298.50,'2023-01-29 12:25:37'),(861,'1','303',1,'Retail Sale Id 846',0.00,649.90,720.00,698.40,48.50,'2023-01-29 12:28:58'),(862,'1','303',1,'Retail Sale Id 847',0.00,3350.00,720.00,3600.00,250.00,'2023-01-29 12:33:34'),(863,'1','303',1,'Retail Sale Id 847',0.00,8040.00,720.00,8640.00,600.00,'2023-01-29 12:33:34'),(864,'1','303',1,'Retail Sale Id 847',0.00,8040.00,720.00,8640.00,600.00,'2023-01-29 12:33:34'),(865,'1','303',1,'Retail Sale Id 848',0.00,8040.00,720.00,8640.00,600.00,'2023-01-29 12:34:59'),(866,'1','303',1,'Retail Sale Id 849',0.00,2050.20,720.00,2203.20,153.00,'2023-01-29 12:39:37'),(867,'1','303',1,'Retail Sale Id 850',0.00,8375.00,720.00,9000.00,625.00,'2023-01-29 12:49:52'),(868,'1','303',1,'Retail Sale Id 851',0.00,1346.70,720.00,1447.20,100.50,'2023-01-29 12:51:04'),(869,'1','303',1,'Retail Sale Id 852',0.00,8375.00,720.00,9000.00,625.00,'2023-01-29 13:11:59'),(870,'1','303',1,'Retail Sale Id 853',0.00,3999.90,720.00,4298.40,298.50,'2023-01-29 13:20:19'),(871,'1','303',1,'Retail Sale Id 854',0.00,931.30,720.00,1000.80,69.50,'2023-01-29 13:56:27'),(872,'1','303',1,'Retail Sale Id 855',0.00,2050.20,720.00,2203.20,153.00,'2023-01-29 13:58:14'),(873,'1','303',1,'Retail Sale Id 856',0.00,2050.20,720.00,2203.20,153.00,'2023-01-29 14:04:50'),(874,'1','303',1,'Retail Sale Id 857',0.00,2010.00,720.00,2160.00,150.00,'2023-01-29 14:07:04'),(875,'1','303',1,'Retail Sale Id 858',0.00,2050.20,720.00,2203.20,153.00,'2023-01-29 14:14:53'),(876,'1','303',1,'Retail Sale Id 859',0.00,8375.00,720.00,9000.00,625.00,'2023-01-29 14:24:06'),(877,'1','303',1,'Retail Sale Id 860',0.00,1393.60,720.00,1497.60,104.00,'2023-01-29 14:25:37'),(878,'1','303',1,'Retail Sale Id 861',0.00,2050.20,720.00,2203.20,153.00,'2023-01-29 14:38:33'),(879,'1','303',1,'Retail Sale Id 862',0.00,2010.00,720.00,2160.00,150.00,'2023-01-29 14:43:06'),(880,'1','303',1,'Retail Sale Id 862',0.00,4020.00,720.00,4320.00,300.00,'2023-01-29 14:43:06'),(881,'1','303',1,'Retail Sale Id 863',0.00,931.30,720.00,1000.80,69.50,'2023-01-29 14:44:11'),(882,'1','303',1,'Retail Sale Id 864',0.00,3350.00,720.00,3600.00,250.00,'2023-01-29 14:55:55'),(883,'1','303',1,'Retail Sale Id 865',0.00,1862.60,720.00,2001.60,139.00,'2023-01-29 14:57:40'),(884,'1','303',1,'Retail Sale Id 866',0.00,3906.10,720.00,4197.60,291.50,'2023-01-29 15:25:26'),(885,'1','303',1,'Retail Sale Id 867',0.00,3350.00,720.00,3600.00,250.00,'2023-01-29 15:29:40'),(886,'1','303',1,'Retail Sale Id 869',0.00,3999.90,720.00,4298.40,298.50,'2023-01-29 15:32:01'),(887,'1','303',1,'Retail Sale Id 870',0.00,2793.90,720.00,3002.40,208.50,'2023-01-29 15:35:30'),(888,'1','303',1,'Retail Sale Id 871',0.00,931.30,720.00,1000.80,69.50,'2023-01-29 15:43:40'),(889,'1','303',1,'Retail Sale Id 872',0.00,1393.60,720.00,1497.60,104.00,'2023-01-29 15:45:10'),(890,'1','303',1,'Retail Sale Id 873',0.00,3999.90,720.00,4298.40,298.50,'2023-01-29 16:07:52'),(891,'1','303',1,'Retail Sale Id 874',0.00,3999.90,720.00,4298.40,298.50,'2023-01-29 16:11:26'),(892,'1','303',1,'Retail Sale Id 875',0.00,2010.00,720.00,2160.00,150.00,'2023-01-29 16:15:40'),(893,'1','303',1,'Retail Sale Id 875',0.00,2010.00,720.00,2160.00,150.00,'2023-01-29 16:15:40'),(894,'1','303',1,'Retail Sale Id 875',0.00,2010.00,720.00,2160.00,150.00,'2023-01-29 16:15:40'),(895,'1','303',1,'Retail Sale Id 875',0.00,4020.00,720.00,4320.00,300.00,'2023-01-29 16:15:40'),(896,'1','303',1,'Retail Sale Id 876',0.00,1862.60,720.00,2001.60,139.00,'2023-01-29 16:16:59'),(897,'1','303',1,'Retail Sale Id 877',0.00,1862.60,720.00,2001.60,139.00,'2023-01-29 16:18:09'),(898,'1','303',1,'Retail Sale Id 878',0.00,2700.10,720.00,2901.60,201.50,'2023-01-29 16:21:06'),(899,'1','303',1,'Retail Sale Id 879',0.00,3350.00,720.00,3600.00,250.00,'2023-01-29 16:24:05'),(900,'1','303',1,'Retail Sale Id 880',0.00,1862.60,720.00,2001.60,139.00,'2023-01-29 16:44:18'),(901,'1','303',1,'Retail Sale Id 881',0.00,3999.90,720.00,4298.40,298.50,'2023-01-29 16:45:53'),(902,'1','303',1,'Retail Sale Id 882',0.00,1862.60,720.00,2001.60,139.00,'2023-01-29 16:47:25'),(903,'1','303',1,'Retail Sale Id 883',0.00,3999.90,720.00,4298.40,298.50,'2023-01-29 16:58:56'),(904,'1','303',1,'Retail Sale Id 884',0.00,8375.00,720.00,9000.00,625.00,'2023-01-29 17:04:21'),(905,'1','303',1,'Retail Sale Id 885',0.00,3725.20,720.00,4003.20,278.00,'2023-01-29 17:06:45'),(906,'1','303',1,'Retail Sale Id 886',0.00,2010.00,720.00,2160.00,150.00,'2023-01-29 17:15:58'),(907,'1','303',1,'Retail Sale Id 886',0.00,4020.00,720.00,4320.00,300.00,'2023-01-29 17:15:58'),(908,'1','303',1,'Retail Sale Id 887',0.00,4468.90,720.00,4802.40,333.50,'2023-01-29 17:32:29'),(909,'1','303',1,'Retail Sale Id 888',0.00,2793.90,720.00,3002.40,208.50,'2023-01-29 17:34:12'),(910,'1','303',1,'Retail Sale Id 889',0.00,931.30,720.00,1000.80,69.50,'2023-01-29 17:35:37'),(911,'1','303',1,'Retail Sale Id 890',0.00,2418.70,720.00,2599.20,180.50,'2023-01-29 17:54:30'),(912,'1','303',1,'Retail Sale Id 891',0.00,1393.60,720.00,1497.60,104.00,'2023-01-29 17:56:50'),(913,'1','303',1,'Retail Sale Id 892',0.00,6512.40,720.00,6998.40,486.00,'2023-01-29 17:59:16'),(914,'1','303',1,'Retail Sale Id 893',0.00,4187.50,720.00,4500.00,312.50,'2023-01-29 18:00:48'),(915,'1','303',1,'Retail Sale Id 894',0.00,931.30,720.00,1000.80,69.50,'2023-01-29 18:06:23'),(916,'1','303',1,'Retail Sale Id 895',0.00,8375.00,720.00,9000.00,625.00,'2023-01-29 18:28:30'),(917,'1','303',1,'Retail Sale Id 896',0.00,609.70,720.00,655.20,45.50,'2023-01-29 18:33:54'),(918,'1','303',1,'Retail Sale Id 897',0.00,3350.00,720.00,3600.00,250.00,'2023-01-30 08:12:50'),(919,'1','303',1,'Retail Sale Id 898',0.00,8375.00,720.00,9000.00,625.00,'2023-01-30 08:19:47'),(920,'1','303',1,'Retail Sale Id 899',0.00,2050.20,720.00,2203.20,153.00,'2023-01-30 08:30:34'),(921,'1','303',1,'Retail Sale Id 900',0.00,2793.90,720.00,3002.40,208.50,'2023-01-30 08:48:46'),(922,'1','303',1,'Retail Sale Id 901',0.00,3350.00,720.00,3600.00,250.00,'2023-01-30 08:49:45'),(923,'1','303',1,'Retail Sale Id 902',0.00,3350.00,720.00,3600.00,250.00,'2023-01-30 09:19:58'),(924,'1','303',1,'Retail Sale Id 903',0.00,8375.00,720.00,9000.00,625.00,'2023-01-30 09:30:50'),(925,'1','303',1,'Retail Sale Id 904',0.00,2010.00,720.00,2160.00,150.00,'2023-01-30 09:36:15'),(926,'1','303',1,'Retail Sale Id 905',0.00,6700.00,720.00,7200.00,500.00,'2023-01-30 09:38:52'),(927,'1','303',1,'Retail Sale Id 907',0.00,931.30,720.00,1000.80,69.50,'2023-01-30 09:52:52'),(928,'1','303',1,'Retail Sale Id 907',0.00,931.30,720.00,1000.80,69.50,'2023-01-30 09:52:52'),(929,'1','303',1,'Retail Sale Id 908',0.00,2050.20,720.00,2203.20,153.00,'2023-01-30 09:54:10'),(930,'1','303',1,'Retail Sale Id 909',0.00,2050.20,720.00,2203.20,153.00,'2023-01-30 09:55:15'),(931,'1','303',1,'Retail Sale Id 910',0.00,3999.90,720.00,4298.40,298.50,'2023-01-30 10:19:17'),(932,'1','303',1,'Retail Sale Id 911',0.00,3999.90,720.00,4298.40,298.50,'2023-01-30 10:20:40'),(933,'1','303',1,'Retail Sale Id 912',0.00,2050.20,720.00,2203.20,153.00,'2023-01-30 10:28:43'),(934,'1','303',1,'Retail Sale Id 913',0.00,8375.00,720.00,9000.00,625.00,'2023-01-30 13:22:26'),(935,'1','303',1,'Retail Sale Id 914',0.00,3350.00,720.00,3600.00,250.00,'2023-01-30 13:23:08'),(936,'1','303',1,'Retail Sale Id 915',0.00,4690.00,720.00,5040.00,350.00,'2023-01-30 13:23:51'),(937,'1','303',1,'Retail Sale Id 916',0.00,2793.90,720.00,3002.40,208.50,'2023-01-30 13:24:35'),(938,'1','303',1,'Retail Sale Id 917',0.00,2050.20,720.00,2203.20,153.00,'2023-01-30 13:25:18'),(939,'1','303',1,'Retail Sale Id 918',0.00,3999.90,720.00,4298.40,298.50,'2023-01-30 13:26:21'),(940,'1','303',1,'Retail Sale Id 919',0.00,2050.20,720.00,2203.20,153.00,'2023-01-30 13:27:27'),(941,'1','303',1,'Retail Sale Id 920',0.00,8375.00,720.00,9000.00,625.00,'2023-01-30 13:28:05'),(942,'1','303',1,'Retail Sale Id 921',0.00,931.30,720.00,1000.80,69.50,'2023-01-30 13:28:55'),(943,'1','303',1,'Retail Sale Id 922',0.00,2324.90,720.00,2498.40,173.50,'2023-01-30 13:29:56'),(944,'1','303',1,'Retail Sale Id 923',0.00,1393.60,720.00,1497.60,104.00,'2023-01-30 13:30:31'),(945,'1','303',1,'Retail Sale Id 924',0.00,3999.90,720.00,4298.40,298.50,'2023-01-30 13:31:23'),(946,'1','303',1,'Retail Sale Id 925',0.00,4020.00,720.00,4320.00,300.00,'2023-01-30 13:32:00'),(947,'1','303',1,'Retail Sale Id 926',0.00,1393.60,720.00,1497.60,104.00,'2023-01-30 13:32:35'),(948,'1','303',1,'Retail Sale Id 927',0.00,931.30,720.00,1000.80,69.50,'2023-01-30 13:33:20'),(949,'1','303',1,'Retail Sale Id 928',0.00,2050.20,720.00,2203.20,153.00,'2023-01-30 13:33:53'),(950,'1','303',1,'Retail Sale Id 929',0.00,2050.20,720.00,2203.20,153.00,'2023-01-30 13:34:27'),(951,'1','303',1,'Retail Sale Id 930',0.00,2050.20,720.00,2203.20,153.00,'2023-01-30 13:35:02'),(952,'1','303',1,'Retail Sale Id 931',0.00,3999.90,720.00,4298.40,298.50,'2023-01-30 13:35:34'),(953,'1','303',1,'Retail Sale Id 932',0.00,4020.00,720.00,4320.00,300.00,'2023-01-30 13:36:09'),(954,'1','303',1,'Retail Sale Id 933',0.00,33500.00,690.00,34500.00,1000.00,'2023-01-30 15:11:10'),(955,'1','303',1,'Retail Sale Id 934',0.00,67000.00,690.00,69000.00,2000.00,'2023-01-30 15:53:51'),(956,'1','303',1,'Retail Sale Id 935',0.00,1393.60,720.00,1497.60,104.00,'2023-01-30 15:55:00'),(957,'1','303',1,'Retail Sale Id 936',0.00,931.30,720.00,1000.80,69.50,'2023-01-30 15:57:51'),(958,'1','303',1,'Retail Sale Id 937',0.00,8375.00,720.00,9000.00,625.00,'2023-01-30 15:58:32'),(959,'1','303',1,'Retail Sale Id 938',0.00,1393.60,720.00,1497.60,104.00,'2023-01-30 15:59:23'),(960,'1','303',1,'Retail Sale Id 939',0.00,4020.00,720.00,4320.00,300.00,'2023-01-30 16:38:54'),(961,'1','303',1,'Retail Sale Id 941',0.00,1862.60,720.00,2001.60,139.00,'2023-01-30 16:43:30'),(962,'1','303',1,'Retail Sale Id 942',0.00,8375.00,720.00,9000.00,625.00,'2023-01-30 16:44:13'),(963,'1','303',1,'Retail Sale Id 943',0.00,8040.00,720.00,8640.00,600.00,'2023-01-30 16:45:08'),(964,'1','303',1,'Retail Sale Id 944',0.00,2050.20,720.00,2203.20,153.00,'2023-01-30 16:47:47'),(965,'1','303',1,'Retail Sale Id 945',0.00,8375.00,720.00,9000.00,625.00,'2023-01-30 16:48:58'),(966,'1','303',1,'Retail Sale Id 946',0.00,4020.00,720.00,4320.00,300.00,'2023-01-30 16:49:44'),(967,'1','303',1,'Retail Sale Id 947',0.00,1340.00,720.00,1440.00,100.00,'2023-01-30 16:50:27'),(968,'1','303',1,'Retail Sale Id 948',0.00,4020.00,720.00,4320.00,300.00,'2023-01-30 16:51:36'),(969,'1','303',1,'Retail Sale Id 949',0.00,2010.00,720.00,2160.00,150.00,'2023-01-30 16:52:21'),(970,'1','303',1,'Retail Sale Id 950',0.00,931.30,720.00,1000.80,69.50,'2023-01-30 16:53:07'),(971,'1','303',1,'Retail Sale Id 951',0.00,2010.00,720.00,2160.00,150.00,'2023-01-30 16:54:09'),(972,'1','303',1,'Retail Sale Id 952',0.00,2010.00,720.00,2160.00,150.00,'2023-01-30 16:55:17'),(973,'1','303',1,'Retail Sale Id 953',0.00,8375.00,720.00,9000.00,625.00,'2023-01-30 16:56:19'),(974,'1','303',1,'Retail Sale Id 954',0.00,6700.00,720.00,7200.00,500.00,'2023-01-30 16:56:57'),(975,'1','303',1,'Retail Sale Id 955',0.00,4020.00,720.00,4320.00,300.00,'2023-01-30 16:57:58'),(976,'1','303',1,'Retail Sale Id 956',0.00,8375.00,720.00,9000.00,625.00,'2023-01-30 16:59:59'),(977,'1','303',1,'Retail Sale Id 957',0.00,8375.00,720.00,9000.00,625.00,'2023-01-30 17:00:48'),(978,'1','303',1,'Retail Sale Id 958',0.00,3725.20,720.00,4003.20,278.00,'2023-01-30 17:01:35'),(979,'1','303',1,'Retail Sale Id 959',0.00,4649.80,720.00,4996.80,347.00,'2023-01-30 17:02:26'),(980,'1','303',1,'Retail Sale Id 961',0.00,1862.60,720.00,2001.60,139.00,'2023-01-30 17:03:11'),(981,'1','303',1,'Retail Sale Id 962',0.00,3999.90,720.00,4298.40,298.50,'2023-01-30 17:06:29'),(982,'1','303',1,'Retail Sale Id 963',0.00,2793.90,720.00,3002.40,208.50,'2023-01-30 17:07:37'),(983,'1','303',1,'Retail Sale Id 964',0.00,2050.20,720.00,2203.20,153.00,'2023-01-30 17:12:36'),(984,'1','303',1,'Retail Sale Id 965',0.00,3350.00,720.00,3600.00,250.00,'2023-01-30 17:13:58'),(985,'1','303',1,'Retail Sale Id 966',0.00,1393.60,720.00,1497.60,104.00,'2023-01-30 17:15:19'),(986,'1','303',1,'Retail Sale Id 967',0.00,3758.70,720.00,4039.20,280.50,'2023-01-30 17:30:11'),(987,'1','303',1,'Retail Sale Id 968',0.00,931.30,720.00,1000.80,69.50,'2023-01-30 17:31:16'),(988,'1','303',1,'Retail Sale Id 969',0.00,4020.00,720.00,4320.00,300.00,'2023-01-30 17:33:39'),(989,'1','303',1,'Retail Sale Id 970',0.00,4020.00,720.00,4320.00,300.00,'2023-01-30 17:37:52'),(990,'1','303',1,'Retail Sale Id 971',0.00,2010.00,720.00,2160.00,150.00,'2023-01-30 17:49:02'),(991,'1','303',1,'Retail Sale Id 972',0.00,4020.00,720.00,4320.00,300.00,'2023-01-30 17:53:18'),(992,'1','303',1,'Retail Sale Id 973',0.00,2050.20,720.00,2203.20,153.00,'2023-01-30 17:58:49'),(993,'1','303',1,'Retail Sale Id 974',0.00,4020.00,720.00,4320.00,300.00,'2023-01-30 18:00:04'),(994,'1','303',1,'Retail Sale Id 977',0.00,8375.00,720.00,9000.00,625.00,'2023-01-30 18:29:35'),(995,'1','303',1,'Retail Sale Id 979',0.00,4020.00,720.00,4320.00,300.00,'2023-01-30 18:39:48'),(996,'1','303',1,'Retail Sale Id 980',0.00,1862.60,720.00,2001.60,139.00,'2023-01-30 18:40:58'),(997,'1','303',1,'Return of Retail Sale Id 977',8375.00,0.00,720.00,-9000.00,-625.00,'2023-01-30 19:44:08'),(998,'1','303',1,'Return of Retail Sale Id 959',4649.80,0.00,720.00,-4996.80,-347.00,'2023-01-30 19:55:24'),(999,'1','303',1,'Retail Sale Id 982',0.00,120.60,720.00,129.60,9.00,'2023-01-30 20:00:02'),(1000,'1','303',1,'Retail Sale Id 983',0.00,1340.00,720.00,1440.00,100.00,'2023-01-31 08:43:08'),(1001,'1','303',1,'Retail Sale Id 984',0.00,2010.00,720.00,2160.00,150.00,'2023-01-31 08:51:59'),(1002,'1','303',1,'Retail Sale Id 985',0.00,1956.40,720.00,2102.40,146.00,'2023-01-31 08:53:32'),(1003,'1','303',1,'Retail Sale Id 986',0.00,2050.20,720.00,2203.20,153.00,'2023-01-31 08:57:25'),(1004,'1','303',1,'Retail Sale Id 987',0.00,2010.00,720.00,2160.00,150.00,'2023-01-31 09:16:26'),(1005,'1','303',1,'Retail Sale Id 988',0.00,4093.70,720.00,4399.20,305.50,'2023-01-31 09:36:28'),(1006,'1','303',1,'Retail Sale Id 989',0.00,3350.00,720.00,3600.00,250.00,'2023-01-31 09:52:25'),(1007,'1','303',1,'Retail Sale Id 990',0.00,1862.60,720.00,2001.60,139.00,'2023-01-31 10:21:30'),(1008,'1','303',1,'Retail Sale Id 991',0.00,3256.20,720.00,3499.20,243.00,'2023-01-31 10:26:33'),(1009,'1','303',1,'Retail Sale Id 992',0.00,33500.00,690.00,34500.00,1000.00,'2023-01-31 10:54:03'),(1010,'1','303',1,'Retail Sale Id 993',0.00,194300.00,690.00,200100.00,5800.00,'2023-01-31 10:57:47'),(1011,'1','303',1,'Retail Sale Id 994',0.00,2010.00,720.00,2160.00,150.00,'2023-01-31 11:02:18'),(1012,'1','303',1,'Retail Sale Id 995',0.00,2010.00,720.00,2160.00,150.00,'2023-01-31 11:04:47'),(1013,'1','303',1,'Retail Sale Id 996',0.00,1340.00,720.00,1440.00,100.00,'2023-01-31 11:13:54'),(1014,'1','303',1,'Retail Sale Id 997',0.00,7443.70,720.00,7999.20,555.50,'2023-01-31 11:22:26'),(1015,'1','303',1,'Retail Sale Id 998',0.00,2003.30,720.00,2152.80,149.50,'2023-01-31 11:27:05'),(1016,'1','303',1,'Retail Sale Id 999',0.00,4020.00,720.00,4320.00,300.00,'2023-01-31 11:28:42'),(1017,'1','303',1,'Retail Sale Id 1000',0.00,3999.90,720.00,4298.40,298.50,'2023-01-31 11:32:44'),(1018,'1','303',1,'Retail Sale Id 1001',0.00,4020.00,720.00,4320.00,300.00,'2023-01-31 11:38:52'),(1019,'1','303',1,'Retail Sale Id 1002',0.00,6700.00,720.00,7200.00,500.00,'2023-01-31 11:40:18'),(1020,'1','303',1,'Retail Sale Id 1003',0.00,2050.20,720.00,2203.20,153.00,'2023-01-31 12:34:21'),(1021,'1','303',1,'Retail Sale Id 1004',0.00,8375.00,720.00,9000.00,625.00,'2023-01-31 13:07:14'),(1022,'1','303',1,'Retail Sale Id 1005',0.00,8375.00,720.00,9000.00,625.00,'2023-01-31 13:17:59'),(1023,'1','303',1,'Retail Sale Id 1006',0.00,1393.60,720.00,1497.60,104.00,'2023-01-31 13:36:15'),(1024,'1','303',1,'Retail Sale Id 1007',0.00,4690.00,720.00,5040.00,350.00,'2023-01-31 13:51:39'),(1025,'1','303',1,'Retail Sale Id 1008',0.00,4020.00,720.00,4320.00,300.00,'2023-01-31 14:07:43'),(1026,'1','303',1,'Retail Sale Id 1009',0.00,3350.00,720.00,3600.00,250.00,'2023-01-31 14:15:23'),(1027,'1','303',1,'Retail Sale Id 1010',0.00,4020.00,720.00,4320.00,300.00,'2023-01-31 14:42:57'),(1028,'1','303',1,'Retail Sale Id 1011',0.00,8375.00,720.00,9000.00,625.00,'2023-01-31 15:10:04'),(1029,'1','303',1,'Retail Sale Id 1012',0.00,2050.20,720.00,2203.20,153.00,'2023-01-31 15:51:42'),(1030,'1','303',1,'Retail Sale Id 1013',0.00,2010.00,720.00,2160.00,150.00,'2023-01-31 15:53:19'),(1031,'1','303',1,'Retail Sale Id 1014',0.00,4020.00,720.00,4320.00,300.00,'2023-01-31 15:56:19'),(1032,'1','303',1,'Retail Sale Id 1016',0.00,2050.20,720.00,2203.20,153.00,'2023-01-31 16:07:16'),(1033,'1','303',1,'Retail Sale Id 1017',0.00,8375.00,720.00,9000.00,625.00,'2023-01-31 16:24:45'),(1034,'1','303',1,'Retail Sale Id 1018',0.00,2050.20,720.00,2203.20,153.00,'2023-01-31 16:28:17'),(1035,'1','303',1,'Retail Sale Id 1020',0.00,4020.00,720.00,4320.00,300.00,'2023-01-31 16:46:41'),(1036,'1','303',1,'Retail Sale Id 1021',0.00,1393.60,720.00,1497.60,104.00,'2023-01-31 16:51:13'),(1037,'1','303',1,'Retail Sale Id 1022',0.00,4020.00,720.00,4320.00,300.00,'2023-01-31 16:53:18'),(1038,'1','303',1,'Retail Sale Id 1023',0.00,1393.60,720.00,1497.60,104.00,'2023-01-31 16:58:40'),(1039,'1','303',1,'Retail Sale Id 1024',0.00,1862.60,720.00,2001.60,139.00,'2023-01-31 17:03:22'),(1040,'1','303',1,'Retail Sale Id 1025',0.00,3350.00,720.00,3600.00,250.00,'2023-01-31 17:14:19'),(1041,'1','303',1,'Retail Sale Id 1026',0.00,1340.00,720.00,1440.00,100.00,'2023-01-31 17:16:45'),(1042,'1','303',1,'Retail Sale Id 1026',0.00,4020.00,720.00,4320.00,300.00,'2023-01-31 17:16:45'),(1043,'1','303',1,'Retail Sale Id 1027',0.00,4020.00,720.00,4320.00,300.00,'2023-01-31 17:23:51'),(1044,'1','303',1,'Retail Sale Id 1028',0.00,931.30,720.00,1000.80,69.50,'2023-01-31 17:48:09'),(1045,'1','303',1,'Retail Sale Id 1029',0.00,3906.10,720.00,4197.60,291.50,'2023-01-31 17:57:58'),(1046,'1','303',1,'Retail Sale Id 1030',0.00,2010.00,720.00,2160.00,150.00,'2023-01-31 18:05:17'),(1047,'1','303',1,'Retail Sale Id 1030',0.00,2010.00,720.00,2160.00,150.00,'2023-01-31 18:05:17'),(1048,'1','303',1,'Return of Retail Sale Id 1027',4020.00,0.00,720.00,-4320.00,-300.00,'2023-01-31 18:36:38'),(1049,'1','303',1,'Retail Sale Id 1031',0.00,1266.30,720.00,1360.80,94.50,'2023-01-31 18:38:09'),(1050,'1','303',1,'Retail Sale Id 1032',0.00,4020.00,720.00,4320.00,300.00,'2023-02-01 08:04:41'),(1051,'1','303',1,'Retail Sale Id 1033',0.00,8375.00,720.00,9000.00,625.00,'2023-02-01 08:37:45'),(1052,'1','303',1,'Retail Sale Id 1034',0.00,2050.20,720.00,2203.20,153.00,'2023-02-01 09:20:16'),(1053,'1','303',1,'Retail Sale Id 1035',0.00,2050.20,720.00,2203.20,153.00,'2023-02-01 09:37:17'),(1054,'1','303',1,'Retail Sale Id 1036',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-01 09:49:52'),(1055,'1','303',1,'Retail Sale Id 1038',0.00,1340.00,720.00,1440.00,100.00,'2023-02-01 10:04:14'),(1056,'1','303',1,'Retail Sale Id 1039',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-01 10:07:59'),(1057,'1','303',1,'Retail Sale Id 1042',0.00,2010.00,720.00,2160.00,150.00,'2023-02-01 10:53:50'),(1058,'1','303',1,'Retail Sale Id 1043',0.00,1862.60,720.00,2001.60,139.00,'2023-02-01 10:55:11'),(1059,'1','303',1,'Retail Sale Id 1044',0.00,1393.60,720.00,1497.60,104.00,'2023-02-01 11:06:19'),(1060,'1','303',1,'Retail Sale Id 1045',0.00,24274.10,690.00,24998.70,724.60,'2023-02-01 11:09:08'),(1061,'1','303',1,'Retail Sale Id 1046',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-01 11:13:04'),(1062,'1','303',1,'Retail Sale Id 1047',0.00,8375.00,720.00,9000.00,625.00,'2023-02-01 11:14:47'),(1063,'1','303',1,'Retail Sale Id 1048',0.00,4020.00,720.00,4320.00,300.00,'2023-02-01 11:18:07'),(1064,'1','303',1,'Retail Sale Id 1049',0.00,1862.60,720.00,2001.60,139.00,'2023-02-01 11:23:41'),(1065,'1','303',1,'Retail Sale Id 1050',0.00,4020.00,720.00,4320.00,300.00,'2023-02-01 11:25:03'),(1066,'1','303',1,'Retail Sale Id 1051',0.00,8375.00,720.00,9000.00,625.00,'2023-02-01 11:49:44'),(1067,'1','303',1,'Retail Sale Id 1052',0.00,4020.00,720.00,4320.00,300.00,'2023-02-01 11:53:58'),(1068,'1','303',1,'Retail Sale Id 1053',0.00,2010.00,720.00,2160.00,150.00,'2023-02-01 11:58:23'),(1069,'1','303',1,'Retail Sale Id 1053',0.00,4020.00,720.00,4320.00,300.00,'2023-02-01 11:58:23'),(1070,'1','303',1,'Retail Sale Id 1054',0.00,3350.00,720.00,3600.00,250.00,'2023-02-01 12:02:15'),(1071,'1','303',1,'Retail Sale Id 1055',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-01 12:08:51'),(1072,'1','303',1,'Retail Sale Id 1056',0.00,4020.00,720.00,4320.00,300.00,'2023-02-01 12:44:34'),(1073,'1','303',1,'Retail Sale Id 1057',0.00,2010.00,720.00,2160.00,150.00,'2023-02-01 12:50:51'),(1074,'1','303',1,'Retail Sale Id 1058',0.00,3725.20,720.00,4003.20,278.00,'2023-02-01 12:53:01'),(1075,'1','303',1,'Retail Sale Id 1059',0.00,2010.00,720.00,2160.00,150.00,'2023-02-01 13:01:06'),(1076,'1','303',1,'Retail Sale Id 1060',0.00,3350.00,720.00,3600.00,250.00,'2023-02-01 13:03:26'),(1077,'1','303',1,'Retail Sale Id 1061',0.00,4020.00,720.00,4320.00,300.00,'2023-02-01 13:08:43'),(1078,'1','303',1,'Retail Sale Id 1062',0.00,2680.00,720.00,2880.00,200.00,'2023-02-01 13:10:39'),(1079,'1','303',1,'Retail Sale Id 1063',0.00,67000.00,690.00,69000.00,2000.00,'2023-02-01 13:14:50'),(1080,'1','303',1,'Retail Sale Id 1064',0.00,2010.00,720.00,2160.00,150.00,'2023-02-01 13:54:38'),(1081,'1','303',1,'Retail Sale Id 1065',0.00,2010.00,720.00,2160.00,150.00,'2023-02-01 14:03:13'),(1082,'1','303',1,'Retail Sale Id 1066',0.00,2680.00,720.00,2880.00,200.00,'2023-02-01 14:13:16'),(1083,'1','303',1,'Retail Sale Id 1067',0.00,2010.00,720.00,2160.00,150.00,'2023-02-01 14:23:11'),(1084,'1','303',1,'Retail Sale Id 1068',0.00,3999.90,720.00,4298.40,298.50,'2023-02-01 14:31:15'),(1085,'1','303',1,'Retail Sale Id 1069',0.00,4020.00,720.00,4320.00,300.00,'2023-02-01 14:55:04'),(1086,'1','303',1,'Retail Sale Id 1070',0.00,8375.00,720.00,9000.00,625.00,'2023-02-01 15:15:23'),(1087,'1','303',1,'Retail Sale Id 1071',0.00,2010.00,720.00,2160.00,150.00,'2023-02-01 15:19:08'),(1088,'1','303',1,'Retail Sale Id 1072',0.00,3350.00,720.00,3600.00,250.00,'2023-02-01 15:21:42'),(1089,'1','303',1,'Retail Sale Id 1074',0.00,2010.00,720.00,2160.00,150.00,'2023-02-01 15:36:51'),(1090,'1','303',1,'Retail Sale Id 1075',0.00,1862.60,720.00,2001.60,139.00,'2023-02-01 15:38:13'),(1091,'1','303',1,'Retail Sale Id 1076',0.00,4020.00,720.00,4320.00,300.00,'2023-02-01 15:43:15'),(1092,'1','303',1,'Retail Sale Id 1077',0.00,1340.00,720.00,1440.00,100.00,'2023-02-01 16:05:20'),(1093,'1','303',1,'Retail Sale Id 1078',0.00,6700.00,720.00,7200.00,500.00,'2023-02-01 16:06:46'),(1094,'1','303',1,'Retail Sale Id 1079',0.00,1393.60,720.00,1497.60,104.00,'2023-02-01 16:07:53'),(1095,'1','303',1,'Retail Sale Id 1080',0.00,4020.00,720.00,4320.00,300.00,'2023-02-01 16:11:37'),(1096,'1','303',1,'Retail Sale Id 1081',0.00,4020.00,720.00,4320.00,300.00,'2023-02-01 16:21:46'),(1097,'1','303',1,'Retail Sale Id 1082',0.00,4020.00,720.00,4320.00,300.00,'2023-02-01 16:23:40'),(1098,'1','303',1,'Retail Sale Id 1083',0.00,2010.00,720.00,2160.00,150.00,'2023-02-01 16:40:02'),(1099,'1','303',1,'Retail Sale Id 1084',0.00,931.30,720.00,1000.80,69.50,'2023-02-01 16:59:54'),(1100,'1','303',1,'Retail Sale Id 1085',0.00,8375.00,720.00,9000.00,625.00,'2023-02-01 17:04:11'),(1101,'1','303',1,'Retail Sale Id 1086',0.00,2680.00,720.00,2880.00,200.00,'2023-02-01 17:34:03'),(1102,'1','303',1,'Retail Sale Id 1087',0.00,2010.00,720.00,2160.00,150.00,'2023-02-01 18:02:50'),(1103,'1','303',1,'Retail Sale Id 1088',0.00,4020.00,720.00,4320.00,300.00,'2023-02-01 18:13:48'),(1104,'1','303',1,'Retail Sale Id 1089',0.00,1165.80,720.00,1252.80,87.00,'2023-02-01 18:40:05'),(1105,'1','303',1,'Retail Sale Id 1090',0.00,8375.00,720.00,9000.00,625.00,'2023-02-02 09:37:42'),(1106,'1','303',1,'Retail Sale Id 1091',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-02 09:41:49'),(1107,'1','303',1,'Retail Sale Id 1092',0.00,4020.00,720.00,4320.00,300.00,'2023-02-02 09:48:27'),(1108,'1','303',1,'Retail Sale Id 1093',0.00,2324.90,720.00,2498.40,173.50,'2023-02-02 09:54:50'),(1109,'1','303',1,'Retail Sale Id 1094',0.00,4020.00,720.00,4320.00,300.00,'2023-02-02 09:57:02'),(1110,'1','303',1,'Retail Sale Id 1095',0.00,649.90,720.00,698.40,48.50,'2023-02-02 09:58:55'),(1111,'1','303',1,'Retail Sale Id 1096',0.00,8375.00,720.00,9000.00,625.00,'2023-02-02 10:03:49'),(1112,'1','303',1,'Retail Sale Id 1097',0.00,1118.90,720.00,1202.40,83.50,'2023-02-02 10:06:11'),(1113,'1','303',1,'Retail Sale Id 1098',0.00,2010.00,720.00,2160.00,150.00,'2023-02-02 10:16:02'),(1114,'1','303',1,'Retail Sale Id 1099',0.00,1581.20,720.00,1699.20,118.00,'2023-02-02 10:46:37'),(1115,'1','303',1,'Retail Sale Id 1100',0.00,4020.00,720.00,4320.00,300.00,'2023-02-02 10:57:22'),(1116,'1','303',1,'Retail Sale Id 1101',0.00,1862.60,720.00,2001.60,139.00,'2023-02-02 11:33:03'),(1117,'1','303',1,'Retail Sale Id 1102',0.00,2010.00,720.00,2160.00,150.00,'2023-02-02 11:53:07'),(1118,'1','303',1,'Retail Sale Id 1103',0.00,6700.00,720.00,7200.00,500.00,'2023-02-02 12:01:50'),(1119,'1','303',1,'Retail Sale Id 1104',0.00,2010.00,720.00,2160.00,150.00,'2023-02-02 12:04:13'),(1120,'1','303',1,'Retail Sale Id 1105',0.00,3350.00,720.00,3600.00,250.00,'2023-02-02 12:14:57'),(1121,'1','303',1,'Retail Sale Id 1107',0.00,2010.00,720.00,2160.00,150.00,'2023-02-02 12:23:17'),(1122,'1','303',1,'Retail Sale Id 1107',0.00,4690.00,720.00,5040.00,350.00,'2023-02-02 12:23:18'),(1123,'1','303',1,'Retail Sale Id 1108',0.00,1393.60,720.00,1497.60,104.00,'2023-02-02 12:25:33'),(1124,'1','303',1,'Retail Sale Id 1109',0.00,4020.00,720.00,4320.00,300.00,'2023-02-02 12:44:43'),(1125,'1','303',1,'Retail Sale Id 1110',0.00,1393.60,720.00,1497.60,104.00,'2023-02-02 12:49:16'),(1126,'1','303',1,'Retail Sale Id 1111',0.00,4020.00,720.00,4320.00,300.00,'2023-02-02 13:16:12'),(1127,'1','303',1,'Retail Sale Id 1112',0.00,4020.00,720.00,4320.00,300.00,'2023-02-02 13:25:05'),(1128,'1','303',1,'Retail Sale Id 1113',0.00,4020.00,720.00,4320.00,300.00,'2023-02-02 13:34:30'),(1129,'1','303',1,'Retail Sale Id 1114',0.00,4020.00,720.00,4320.00,300.00,'2023-02-02 13:38:50'),(1130,'1','303',1,'Retail Sale Id 1116',0.00,8375.00,720.00,9000.00,625.00,'2023-02-02 13:45:04'),(1131,'1','303',1,'Retail Sale Id 1117',0.00,2010.00,720.00,2160.00,150.00,'2023-02-02 13:47:04'),(1132,'1','303',1,'Retail Sale Id 1118',0.00,100500.00,690.00,103500.00,3000.00,'2023-02-02 13:55:40'),(1133,'1','303',1,'Retail Sale Id 1119',0.00,2680.00,720.00,2880.00,200.00,'2023-02-02 14:06:16'),(1134,'1','303',1,'Retail Sale Id 1120',0.00,5695.00,720.00,6120.00,425.00,'2023-02-02 14:15:44'),(1135,'1','303',1,'Retail Sale Id 1121',0.00,4020.00,720.00,4320.00,300.00,'2023-02-02 14:20:22'),(1136,'1','303',1,'Retail Sale Id 1122',0.00,4020.00,720.00,4320.00,300.00,'2023-02-02 14:24:41'),(1137,'1','303',1,'Retail Sale Id 1123',0.00,931.30,720.00,1000.80,69.50,'2023-02-02 14:29:44'),(1138,'1','303',1,'Retail Sale Id 1124',0.00,8375.00,720.00,9000.00,625.00,'2023-02-02 14:42:52'),(1139,'1','303',1,'Retail Sale Id 1125',0.00,8375.00,720.00,9000.00,625.00,'2023-02-02 14:50:45'),(1140,'1','303',1,'Retail Sale Id 1126',0.00,4020.00,720.00,4320.00,300.00,'2023-02-02 15:32:49'),(1141,'1','303',1,'Retail Sale Id 1127',0.00,3350.00,720.00,3600.00,250.00,'2023-02-02 15:37:04'),(1142,'1','303',1,'Retail Sale Id 1128',0.00,4020.00,720.00,4320.00,300.00,'2023-02-02 15:38:19'),(1143,'1','303',1,'Retail Sale Id 1129',0.00,2010.00,720.00,2160.00,150.00,'2023-02-02 15:40:35'),(1144,'1','303',1,'Retail Sale Id 1130',0.00,670.00,720.00,720.00,50.00,'2023-02-02 15:42:03'),(1145,'1','303',1,'Retail Sale Id 1132',0.00,3350.00,720.00,3600.00,250.00,'2023-02-02 16:02:45'),(1146,'1','303',1,'Retail Sale Id 1133',0.00,3350.00,720.00,3600.00,250.00,'2023-02-02 16:07:45'),(1147,'1','303',1,'Retail Sale Id 1134',0.00,770500.00,690.00,793500.00,23000.00,'2023-02-02 16:09:48'),(1148,'1','303',1,'Retail Sale Id 1135',0.00,2010.00,720.00,2160.00,150.00,'2023-02-02 16:13:22'),(1149,'1','303',1,'Retail Sale Id 1136',0.00,2010.00,720.00,2160.00,150.00,'2023-02-02 16:15:38'),(1150,'1','303',1,'Retail Sale Id 1137',0.00,3350.00,720.00,3600.00,250.00,'2023-02-02 16:21:42'),(1151,'1','303',1,'Retail Sale Id 1138',0.00,2010.00,720.00,2160.00,150.00,'2023-02-02 16:26:30'),(1152,'1','303',1,'Retail Sale Id 1139',0.00,670.00,720.00,720.00,50.00,'2023-02-02 16:34:18'),(1153,'1','303',1,'Retail Sale Id 1140',0.00,2793.90,720.00,3002.40,208.50,'2023-02-02 16:40:37'),(1154,'1','303',1,'Retail Sale Id 1141',0.00,462.30,720.00,496.80,34.50,'2023-02-02 16:42:30'),(1155,'1','303',1,'Retail Sale Id 1142',0.00,2010.00,720.00,2160.00,150.00,'2023-02-02 16:43:57'),(1156,'1','303',1,'Retail Sale Id 1143',0.00,4020.00,720.00,4320.00,300.00,'2023-02-02 16:45:34'),(1157,'1','303',1,'Retail Sale Id 1144',0.00,1393.60,720.00,1497.60,104.00,'2023-02-02 16:59:25'),(1158,'1','303',1,'Retail Sale Id 1145',0.00,4020.00,720.00,4320.00,300.00,'2023-02-02 17:13:18'),(1159,'1','303',1,'Retail Sale Id 1146',0.00,3350.00,720.00,3600.00,250.00,'2023-02-02 17:15:21'),(1160,'1','303',1,'Retail Sale Id 1147',0.00,4020.00,720.00,4320.00,300.00,'2023-02-02 17:22:34'),(1161,'1','303',1,'Retail Sale Id 1148',0.00,4020.00,720.00,4320.00,300.00,'2023-02-02 17:52:08'),(1162,'1','303',1,'Retail Sale Id 1149',0.00,2700.10,720.00,2901.60,201.50,'2023-02-02 18:02:30'),(1163,'1','303',1,'Retail Sale Id 1150',0.00,4020.00,720.00,4320.00,300.00,'2023-02-02 18:10:54'),(1164,'1','303',1,'Return of Retail Sale Id 1118',100500.00,0.00,690.00,-103500.00,-3000.00,'2023-02-02 22:25:41'),(1165,'1','303',1,'Return of Retail Sale Id 1149',2700.10,0.00,720.00,-2901.60,-201.50,'2023-02-02 22:27:00'),(1166,'1','303',1,'Retail Sale Id 1151',0.00,469.00,720.00,504.00,35.00,'2023-02-02 22:28:53'),(1167,'1','303',1,'Retail Sale Id 1152',0.00,931.30,720.00,1000.80,69.50,'2023-02-03 08:56:48'),(1168,'1','303',1,'Retail Sale Id 1153',0.00,4690.00,720.00,5040.00,350.00,'2023-02-03 08:59:06'),(1169,'1','303',1,'Retail Sale Id 1154',0.00,3068.60,720.00,3297.60,229.00,'2023-02-03 09:01:22'),(1170,'1','303',1,'Retail Sale Id 1155',0.00,8375.00,720.00,9000.00,625.00,'2023-02-03 09:08:36'),(1171,'1','303',1,'Retail Sale Id 1156',0.00,2010.00,720.00,2160.00,150.00,'2023-02-03 09:16:09'),(1172,'1','303',1,'Retail Sale Id 1157',0.00,4020.00,720.00,4320.00,300.00,'2023-02-03 09:28:37'),(1173,'1','303',1,'Retail Sale Id 1158',0.00,1340.00,720.00,1440.00,100.00,'2023-02-03 09:41:28'),(1174,'1','303',1,'Retail Sale Id 1159',0.00,4020.00,720.00,4320.00,300.00,'2023-02-03 09:47:29'),(1175,'1','303',1,'Retail Sale Id 1160',0.00,4020.00,720.00,4320.00,300.00,'2023-02-03 09:48:32'),(1176,'1','303',1,'Retail Sale Id 1161',0.00,4020.00,720.00,4320.00,300.00,'2023-02-03 10:01:54'),(1177,'1','303',1,'Retail Sale Id 1161',0.00,8375.00,720.00,9000.00,625.00,'2023-02-03 10:01:54'),(1178,'1','303',1,'Retail Sale Id 1162',0.00,1118.90,720.00,1202.40,83.50,'2023-02-03 10:04:29'),(1179,'1','303',1,'Retail Sale Id 1163',0.00,4020.00,720.00,4320.00,300.00,'2023-02-03 10:05:44'),(1180,'1','303',1,'Retail Sale Id 1164',0.00,3350.00,720.00,3600.00,250.00,'2023-02-03 10:08:38'),(1181,'1','303',1,'Retail Sale Id 1165',0.00,2010.00,720.00,2160.00,150.00,'2023-02-03 10:10:29'),(1182,'1','303',1,'Retail Sale Id 1166',0.00,2010.00,720.00,2160.00,150.00,'2023-02-03 10:12:31'),(1183,'1','303',1,'Retail Sale Id 1167',0.00,2010.00,720.00,2160.00,150.00,'2023-02-03 10:22:44'),(1184,'1','303',1,'Retail Sale Id 1168',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-03 10:26:56'),(1185,'1','303',1,'Retail Sale Id 1169',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-03 10:43:49'),(1186,'1','303',1,'Retail Sale Id 1170',0.00,4020.00,720.00,4320.00,300.00,'2023-02-03 10:55:43'),(1187,'1','303',1,'Retail Sale Id 1171',0.00,67000.00,690.00,69000.00,2000.00,'2023-02-03 11:00:50'),(1188,'1','303',1,'Retail Sale Id 1172',0.00,4020.00,720.00,4320.00,300.00,'2023-02-03 11:05:21'),(1189,'1','303',1,'Retail Sale Id 1173',0.00,4020.00,720.00,4320.00,300.00,'2023-02-03 11:11:25'),(1190,'1','303',1,'Retail Sale Id 1173',0.00,8375.00,720.00,9000.00,625.00,'2023-02-03 11:11:25'),(1191,'1','303',1,'Retail Sale Id 1174',0.00,4020.00,720.00,4320.00,300.00,'2023-02-03 11:30:16'),(1192,'1','303',1,'Retail Sale Id 1175',0.00,4020.00,720.00,4320.00,300.00,'2023-02-03 11:44:33'),(1193,'1','303',1,'Retail Sale Id 1176',0.00,4020.00,720.00,4320.00,300.00,'2023-02-03 12:37:16'),(1194,'1','303',1,'Retail Sale Id 1177',0.00,3725.20,720.00,4003.20,278.00,'2023-02-03 12:52:41'),(1195,'1','303',1,'Retail Sale Id 1178',0.00,67000.00,690.00,69000.00,2000.00,'2023-02-03 13:00:40'),(1196,'1','303',1,'Retail Sale Id 1179',0.00,670.00,720.00,720.00,50.00,'2023-02-03 13:19:46'),(1197,'1','303',1,'Retail Sale Id 1180',0.00,1393.60,720.00,1497.60,104.00,'2023-02-03 13:21:23'),(1198,'1','303',1,'Retail Sale Id 1181',0.00,4020.00,720.00,4320.00,300.00,'2023-02-03 14:04:36'),(1199,'1','303',1,'Retail Sale Id 1181',0.00,4020.00,720.00,4320.00,300.00,'2023-02-03 14:04:36'),(1200,'1','303',1,'Retail Sale Id 1182',0.00,4020.00,720.00,4320.00,300.00,'2023-02-03 14:18:54'),(1201,'1','303',1,'Retail Sale Id 1183',0.00,670.00,720.00,720.00,50.00,'2023-02-03 14:28:32'),(1202,'1','303',1,'Retail Sale Id 1184',0.00,3725.20,720.00,4003.20,278.00,'2023-02-03 14:51:38'),(1203,'1','303',1,'Retail Sale Id 1185',0.00,1393.60,720.00,1497.60,104.00,'2023-02-03 14:54:45'),(1204,'1','303',1,'Retail Sale Id 1186',0.00,4020.00,720.00,4320.00,300.00,'2023-02-03 15:06:25'),(1205,'1','303',1,'Retail Sale Id 1187',0.00,462.30,720.00,496.80,34.50,'2023-02-03 15:09:51'),(1206,'1','303',1,'Retail Sale Id 1188',0.00,2050.20,720.00,2203.20,153.00,'2023-02-03 15:30:22'),(1207,'1','303',1,'Retail Sale Id 1189',0.00,2010.00,720.00,2160.00,150.00,'2023-02-03 15:34:30'),(1208,'1','303',1,'Retail Sale Id 1190',0.00,1393.60,720.00,1497.60,104.00,'2023-02-03 15:38:29'),(1209,'1','303',1,'Retail Sale Id 1191',0.00,4020.00,720.00,4320.00,300.00,'2023-02-03 16:11:32'),(1210,'1','303',1,'Retail Sale Id 1193',0.00,4020.00,720.00,4320.00,300.00,'2023-02-03 16:13:52'),(1211,'1','303',1,'Retail Sale Id 1194',0.00,8375.00,720.00,9000.00,625.00,'2023-02-03 16:23:33'),(1212,'1','303',1,'Retail Sale Id 1194',0.00,8375.00,720.00,9000.00,625.00,'2023-02-03 16:23:33'),(1213,'1','303',1,'Retail Sale Id 1195',0.00,2010.00,720.00,2160.00,150.00,'2023-02-03 16:26:13'),(1214,'1','303',1,'Retail Sale Id 1196',0.00,8375.00,720.00,9000.00,625.00,'2023-02-03 16:35:02'),(1215,'1','303',1,'Retail Sale Id 1196',0.00,8375.00,720.00,9000.00,625.00,'2023-02-03 16:35:02'),(1216,'1','303',1,'Retail Sale Id 1197',0.00,8375.00,720.00,9000.00,625.00,'2023-02-03 16:43:02'),(1217,'1','303',1,'Retail Sale Id 1198',0.00,931.30,720.00,1000.80,69.50,'2023-02-03 16:51:26'),(1218,'1','303',1,'Retail Sale Id 1200',0.00,2324.90,720.00,2498.40,173.50,'2023-02-03 17:06:12'),(1219,'1','303',1,'Retail Sale Id 1201',0.00,2793.90,720.00,3002.40,208.50,'2023-02-03 17:08:48'),(1220,'1','303',1,'Retail Sale Id 1202',0.00,8375.00,720.00,9000.00,625.00,'2023-02-03 17:24:09'),(1221,'1','303',1,'Retail Sale Id 1203',0.00,9306.30,720.00,10000.80,694.50,'2023-02-03 17:54:24'),(1222,'1','303',1,'Return of Retail Sale Id 1196',8375.00,0.00,720.00,-9000.00,-625.00,'2023-02-03 18:48:28'),(1223,'1','303',1,'Return of Retail Sale Id 1196',8375.00,0.00,720.00,-9000.00,-625.00,'2023-02-03 18:48:28'),(1224,'1','303',1,'Retail Sale Id 1204',0.00,7410.20,720.00,7963.20,553.00,'2023-02-03 18:51:17'),(1225,'1','303',1,'Retail Sale Id 1205',0.00,1776940.50,690.00,1829983.50,53043.00,'2023-02-03 18:55:39'),(1226,'1','303',1,'Return of Retail Sale Id 1205',1776940.50,0.00,690.00,-1829983.50,-53043.00,'2023-02-03 18:57:33'),(1227,'1','303',1,'Retail Sale Id 1206',0.00,377806.30,690.00,389084.10,11277.80,'2023-02-03 18:59:43'),(1228,'1','303',1,'Retail Sale Id 1207',0.00,4020.00,720.00,4320.00,300.00,'2023-02-04 08:22:18'),(1229,'1','303',1,'Retail Sale Id 1208',0.00,2010.00,720.00,2160.00,150.00,'2023-02-04 08:33:09'),(1230,'1','303',1,'Retail Sale Id 1209',0.00,4020.00,720.00,4320.00,300.00,'2023-02-04 08:51:32'),(1231,'1','303',1,'Retail Sale Id 1210',0.00,1393.60,720.00,1497.60,104.00,'2023-02-04 09:13:38'),(1232,'1','303',1,'Retail Sale Id 1211',0.00,8375.00,720.00,9000.00,625.00,'2023-02-04 09:15:46'),(1233,'1','303',1,'Retail Sale Id 1212',0.00,2793.90,720.00,3002.40,208.50,'2023-02-04 09:19:08'),(1234,'1','303',1,'Retail Sale Id 1213',0.00,4020.00,720.00,4320.00,300.00,'2023-02-04 09:37:16'),(1235,'1','303',1,'Retail Sale Id 1214',0.00,4093.70,720.00,4399.20,305.50,'2023-02-04 09:41:24'),(1236,'1','303',1,'Retail Sale Id 1215',0.00,2626.40,720.00,2822.40,196.00,'2023-02-04 09:46:27'),(1237,'1','303',1,'Retail Sale Id 1216',0.00,2010.00,720.00,2160.00,150.00,'2023-02-04 09:52:18'),(1238,'1','303',1,'Retail Sale Id 1217',0.00,8375.00,720.00,9000.00,625.00,'2023-02-04 10:19:32'),(1239,'1','303',1,'Retail Sale Id 1218',0.00,8375.00,720.00,9000.00,625.00,'2023-02-04 10:41:12'),(1240,'1','303',1,'Retail Sale Id 1219',0.00,6700.00,720.00,7200.00,500.00,'2023-02-04 10:47:24'),(1241,'1','303',1,'Retail Sale Id 1220',0.00,8375.00,720.00,9000.00,625.00,'2023-02-04 10:53:30'),(1242,'1','303',1,'Retail Sale Id 1221',0.00,2010.00,720.00,2160.00,150.00,'2023-02-04 10:56:04'),(1243,'1','303',1,'Retail Sale Id 1222',0.00,4020.00,720.00,4320.00,300.00,'2023-02-04 10:58:57'),(1244,'1','303',1,'Retail Sale Id 1223',0.00,931.30,720.00,1000.80,69.50,'2023-02-04 11:27:19'),(1245,'1','303',1,'Retail Sale Id 1224',0.00,4020.00,720.00,4320.00,300.00,'2023-02-04 11:39:23'),(1246,'1','303',1,'Retail Sale Id 1225',0.00,8375.00,720.00,9000.00,625.00,'2023-02-04 12:08:26'),(1247,'1','303',1,'Retail Sale Id 1226',0.00,2010.00,720.00,2160.00,150.00,'2023-02-04 12:15:55'),(1248,'1','303',1,'Retail Sale Id 1227',0.00,670.00,720.00,720.00,50.00,'2023-02-04 12:18:11'),(1249,'1','303',1,'Retail Sale Id 1228',0.00,4020.00,720.00,4320.00,300.00,'2023-02-04 12:19:54'),(1250,'1','303',1,'Retail Sale Id 1229',0.00,4020.00,720.00,4320.00,300.00,'2023-02-04 12:22:28'),(1251,'1','303',1,'Retail Sale Id 1230',0.00,4020.00,720.00,4320.00,300.00,'2023-02-04 12:24:37'),(1252,'1','303',1,'Retail Sale Id 1231',0.00,4020.00,720.00,4320.00,300.00,'2023-02-04 12:26:46'),(1253,'1','303',1,'Retail Sale Id 1232',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-04 12:47:10'),(1254,'1','303',1,'Retail Sale Id 1233',0.00,2010.00,720.00,2160.00,150.00,'2023-02-04 12:54:15'),(1255,'1','303',1,'Retail Sale Id 1234',0.00,4020.00,720.00,4320.00,300.00,'2023-02-04 13:06:50'),(1256,'1','303',1,'Retail Sale Id 1235',0.00,2010.00,720.00,2160.00,150.00,'2023-02-04 13:08:39'),(1257,'1','303',1,'Retail Sale Id 1236',0.00,1212.70,720.00,1303.20,90.50,'2023-02-04 13:09:42'),(1258,'1','303',1,'Retail Sale Id 1237',0.00,670.00,720.00,720.00,50.00,'2023-02-04 13:12:58'),(1259,'1','303',1,'Retail Sale Id 1238',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-04 13:19:46'),(1260,'1','303',1,'Retail Sale Id 1239',0.00,8375.00,720.00,9000.00,625.00,'2023-02-04 13:57:44'),(1261,'1','303',1,'Retail Sale Id 1240',0.00,931.30,720.00,1000.80,69.50,'2023-02-04 14:13:03'),(1262,'1','303',1,'Retail Sale Id 1241',0.00,2010.00,720.00,2160.00,150.00,'2023-02-04 14:13:53'),(1263,'1','303',1,'Retail Sale Id 1242',0.00,4020.00,720.00,4320.00,300.00,'2023-02-04 14:34:11'),(1264,'1','303',1,'Retail Sale Id 1243',0.00,1212.70,720.00,1303.20,90.50,'2023-02-04 14:40:58'),(1265,'1','303',1,'Retail Sale Id 1244',0.00,1862.60,720.00,2001.60,139.00,'2023-02-04 14:51:50'),(1266,'1','303',1,'Retail Sale Id 1245',0.00,4690.00,720.00,5040.00,350.00,'2023-02-04 15:14:39'),(1267,'1','303',1,'Retail Sale Id 1246',0.00,4020.00,720.00,4320.00,300.00,'2023-02-04 15:23:23'),(1268,'1','303',1,'Retail Sale Id 1247',0.00,931.30,720.00,1000.80,69.50,'2023-02-04 16:16:55'),(1269,'1','303',1,'Retail Sale Id 1248',0.00,2050.20,720.00,2203.20,153.00,'2023-02-04 16:19:08'),(1270,'1','303',1,'Retail Sale Id 1249',0.00,3350.00,720.00,3600.00,250.00,'2023-02-04 16:27:45'),(1271,'1','303',1,'Retail Sale Id 1250',0.00,2680.00,720.00,2880.00,200.00,'2023-02-04 16:42:09'),(1272,'1','303',1,'Retail Sale Id 1251',0.00,4020.00,720.00,4320.00,300.00,'2023-02-04 16:49:23'),(1273,'1','303',1,'Retail Sale Id 1252',0.00,4020.00,720.00,4320.00,300.00,'2023-02-04 16:56:36'),(1274,'1','303',1,'Retail Sale Id 1253',0.00,743.70,720.00,799.20,55.50,'2023-02-04 16:59:04'),(1275,'1','303',1,'Retail Sale Id 1254',0.00,1393.60,720.00,1497.60,104.00,'2023-02-04 17:01:40'),(1276,'1','303',1,'Retail Sale Id 1255',0.00,670.00,720.00,720.00,50.00,'2023-02-04 17:29:41'),(1277,'1','303',1,'Retail Sale Id 1256',0.00,1862.60,720.00,2001.60,139.00,'2023-02-04 17:31:19'),(1278,'1','303',1,'Retail Sale Id 1257',0.00,1393.60,720.00,1497.60,104.00,'2023-02-04 17:34:20'),(1279,'1','303',1,'Retail Sale Id 1258',0.00,1862.60,720.00,2001.60,139.00,'2023-02-04 17:47:02'),(1280,'1','303',1,'Retail Sale Id 1259',0.00,1862.60,720.00,2001.60,139.00,'2023-02-04 17:48:34'),(1281,'1','303',1,'Retail Sale Id 1260',0.00,931.30,720.00,1000.80,69.50,'2023-02-04 18:01:38'),(1282,'1','303',1,'Retail Sale Id 1261',0.00,2010.00,720.00,2160.00,150.00,'2023-02-04 18:05:56'),(1283,'1','303',1,'Retail Sale Id 1262',0.00,3350.00,720.00,3600.00,250.00,'2023-02-04 18:06:51'),(1284,'1','303',1,'Return of Retail Sale Id 1260',931.30,0.00,720.00,-1000.80,-69.50,'2023-02-04 18:49:15'),(1285,'1','303',1,'Return of Retail Sale Id 1262',3350.00,0.00,720.00,-3600.00,-250.00,'2023-02-04 18:51:52'),(1286,'1','303',1,'Retail Sale Id 1263',0.00,274.70,720.00,295.20,20.50,'2023-02-04 18:52:42'),(1287,'1','303',1,'Return of Retail Sale Id 1238',33500.00,0.00,690.00,-34500.00,-1000.00,'2023-02-04 18:54:54'),(1288,'1','303',1,'Retail Sale Id 1264',0.00,33855.10,690.00,34865.70,1010.60,'2023-02-04 18:56:31'),(1289,'1','303',1,'Retail Sale Id 1265',0.00,4020.00,720.00,4320.00,300.00,'2023-02-05 08:14:19'),(1290,'1','303',1,'Retail Sale Id 1266',0.00,1862.60,720.00,2001.60,139.00,'2023-02-05 08:23:36'),(1291,'1','303',1,'Retail Sale Id 1267',0.00,4020.00,720.00,4320.00,300.00,'2023-02-05 08:42:20'),(1292,'1','303',1,'Retail Sale Id 1268',0.00,8375.00,720.00,9000.00,625.00,'2023-02-05 08:57:32'),(1293,'1','303',1,'Retail Sale Id 1269',0.00,6700.00,720.00,7200.00,500.00,'2023-02-05 08:59:17'),(1294,'1','303',1,'Retail Sale Id 1270',0.00,2680.00,720.00,2880.00,200.00,'2023-02-05 09:06:51'),(1295,'1','303',1,'Retail Sale Id 1271',0.00,4020.00,720.00,4320.00,300.00,'2023-02-05 09:24:43'),(1296,'1','303',1,'Retail Sale Id 1272',0.00,2680.00,720.00,2880.00,200.00,'2023-02-05 09:48:06'),(1297,'1','303',1,'Retail Sale Id 1273',0.00,2793.90,720.00,3002.40,208.50,'2023-02-05 09:49:58'),(1298,'1','303',1,'Retail Sale Id 1274',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-05 09:55:35'),(1299,'1','303',1,'Retail Sale Id 1275',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-05 09:56:54'),(1300,'1','303',1,'Retail Sale Id 1276',0.00,931.30,720.00,1000.80,69.50,'2023-02-05 09:58:15'),(1301,'1','303',1,'Retail Sale Id 1277',0.00,2010.00,720.00,2160.00,150.00,'2023-02-05 10:09:03'),(1302,'1','303',1,'Retail Sale Id 1277',0.00,3350.00,720.00,3600.00,250.00,'2023-02-05 10:09:04'),(1303,'1','303',1,'Retail Sale Id 1278',0.00,8375.00,720.00,9000.00,625.00,'2023-02-05 10:11:03'),(1304,'1','303',1,'Retail Sale Id 1279',0.00,2010.00,720.00,2160.00,150.00,'2023-02-05 10:28:40'),(1305,'1','303',1,'Retail Sale Id 1280',0.00,4020.00,720.00,4320.00,300.00,'2023-02-05 10:51:15'),(1306,'1','303',1,'Retail Sale Id 1281',0.00,2010.00,720.00,2160.00,150.00,'2023-02-05 10:54:48'),(1307,'1','303',1,'Retail Sale Id 1282',0.00,2010.00,720.00,2160.00,150.00,'2023-02-05 10:56:00'),(1308,'1','303',1,'Retail Sale Id 1283',0.00,1862.60,720.00,2001.60,139.00,'2023-02-05 11:07:42'),(1309,'1','303',1,'Retail Sale Id 1284',0.00,3725.20,720.00,4003.20,278.00,'2023-02-05 11:09:28'),(1310,'1','303',1,'Retail Sale Id 1285',0.00,4690.00,720.00,5040.00,350.00,'2023-02-05 11:13:24'),(1311,'1','303',1,'Retail Sale Id 1286',0.00,8375.00,720.00,9000.00,625.00,'2023-02-05 11:17:02'),(1312,'1','303',1,'Retail Sale Id 1287',0.00,2010.00,720.00,2160.00,150.00,'2023-02-05 11:24:55'),(1313,'1','303',1,'Retail Sale Id 1288',0.00,2010.00,720.00,2160.00,150.00,'2023-02-05 11:45:25'),(1314,'1','303',1,'Retail Sale Id 1289',0.00,670.00,720.00,720.00,50.00,'2023-02-05 11:53:22'),(1315,'1','303',1,'Retail Sale Id 1291',0.00,4020.00,720.00,4320.00,300.00,'2023-02-05 11:58:40'),(1316,'1','303',1,'Retail Sale Id 1292',0.00,2010.00,720.00,2160.00,150.00,'2023-02-05 12:03:00'),(1317,'1','303',1,'Retail Sale Id 1293',0.00,3999.90,720.00,4298.40,298.50,'2023-02-05 12:09:20'),(1318,'1','303',1,'Retail Sale Id 1294',0.00,670.00,720.00,720.00,50.00,'2023-02-05 12:12:23'),(1319,'1','303',1,'Retail Sale Id 1295',0.00,8375.00,720.00,9000.00,625.00,'2023-02-05 12:18:19'),(1320,'1','303',1,'Retail Sale Id 1296',0.00,8375.00,720.00,9000.00,625.00,'2023-02-05 12:22:35'),(1321,'1','303',1,'Retail Sale Id 1297',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-05 12:44:07'),(1322,'1','303',1,'Retail Sale Id 1298',0.00,4020.00,720.00,4320.00,300.00,'2023-02-05 12:45:39'),(1323,'1','303',1,'Retail Sale Id 1299',0.00,4020.00,720.00,4320.00,300.00,'2023-02-05 13:01:51'),(1324,'1','303',1,'Retail Sale Id 1300',0.00,2680.00,720.00,2880.00,200.00,'2023-02-05 13:03:47'),(1325,'1','303',1,'Retail Sale Id 1301',0.00,67000.00,690.00,69000.00,2000.00,'2023-02-05 13:06:20'),(1326,'1','303',1,'Retail Sale Id 1302',0.00,2793.90,720.00,3002.40,208.50,'2023-02-05 13:08:15'),(1327,'1','303',1,'Retail Sale Id 1303',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-05 13:12:33'),(1328,'1','303',1,'Retail Sale Id 1304',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-05 13:17:47'),(1329,'1','303',1,'Retail Sale Id 1305',0.00,1340.00,720.00,1440.00,100.00,'2023-02-05 13:32:53'),(1330,'1','303',1,'Retail Sale Id 1306',0.00,4020.00,720.00,4320.00,300.00,'2023-02-05 13:34:46'),(1331,'1','303',1,'Retail Sale Id 1307',0.00,26800.00,690.00,27600.00,800.00,'2023-02-05 13:41:30'),(1332,'1','303',1,'Retail Sale Id 1308',0.00,2680.00,720.00,2880.00,200.00,'2023-02-05 13:43:19'),(1333,'1','303',1,'Retail Sale Id 1311',0.00,1393.60,720.00,1497.60,104.00,'2023-02-05 13:58:58'),(1334,'1','303',1,'Retail Sale Id 1311',0.00,1862.60,720.00,2001.60,139.00,'2023-02-05 13:58:58'),(1335,'1','303',1,'Retail Sale Id 1312',0.00,4020.00,720.00,4320.00,300.00,'2023-02-05 14:00:48'),(1336,'1','303',1,'Retail Sale Id 1313',0.00,2010.00,720.00,2160.00,150.00,'2023-02-05 14:01:50'),(1337,'1','303',1,'Retail Sale Id 1314',0.00,4020.00,720.00,4320.00,300.00,'2023-02-05 14:29:04'),(1338,'1','303',1,'Retail Sale Id 1315',0.00,931.30,720.00,1000.80,69.50,'2023-02-05 14:30:23'),(1339,'1','303',1,'Retail Sale Id 1316',0.00,8375.00,720.00,9000.00,625.00,'2023-02-05 14:32:00'),(1340,'1','303',1,'Retail Sale Id 1317',0.00,4020.00,720.00,4320.00,300.00,'2023-02-05 14:34:28'),(1341,'1','303',1,'Retail Sale Id 1318',0.00,931.30,720.00,1000.80,69.50,'2023-02-05 14:47:35'),(1342,'1','303',1,'Retail Sale Id 1319',0.00,1675.00,720.00,1800.00,125.00,'2023-02-05 15:10:25'),(1343,'1','303',1,'Retail Sale Id 1320',0.00,2010.00,720.00,2160.00,150.00,'2023-02-05 15:17:41'),(1344,'1','303',1,'Retail Sale Id 1321',0.00,4020.00,720.00,4320.00,300.00,'2023-02-05 15:27:31'),(1345,'1','303',1,'Retail Sale Id 1322',0.00,4020.00,720.00,4320.00,300.00,'2023-02-05 15:40:52'),(1346,'1','303',1,'Retail Sale Id 1323',0.00,1340.00,720.00,1440.00,100.00,'2023-02-05 15:46:04'),(1347,'1','303',1,'Retail Sale Id 1324',0.00,2680.00,720.00,2880.00,200.00,'2023-02-05 15:48:41'),(1348,'1','303',1,'Retail Sale Id 1325',0.00,670.00,720.00,720.00,50.00,'2023-02-05 15:51:52'),(1349,'1','303',1,'Retail Sale Id 1326',0.00,4020.00,720.00,4320.00,300.00,'2023-02-05 16:14:17'),(1350,'1','303',1,'Retail Sale Id 1327',0.00,8375.00,720.00,9000.00,625.00,'2023-02-05 16:20:02'),(1351,'1','303',1,'Retail Sale Id 1328',0.00,3350.00,720.00,3600.00,250.00,'2023-02-05 16:30:00'),(1352,'1','303',1,'Retail Sale Id 1329',0.00,4020.00,720.00,4320.00,300.00,'2023-02-05 16:37:03'),(1353,'1','303',1,'Retail Sale Id 1330',0.00,8375.00,720.00,9000.00,625.00,'2023-02-05 16:53:34'),(1354,'1','303',1,'Retail Sale Id 1331',0.00,1862.60,720.00,2001.60,139.00,'2023-02-05 16:55:35'),(1355,'1','303',1,'Retail Sale Id 1332',0.00,2010.00,720.00,2160.00,150.00,'2023-02-05 17:04:00'),(1356,'1','303',1,'Retail Sale Id 1333',0.00,4020.00,720.00,4320.00,300.00,'2023-02-05 17:06:08'),(1357,'1','303',1,'Retail Sale Id 1334',0.00,2010.00,720.00,2160.00,150.00,'2023-02-05 17:08:02'),(1358,'1','303',1,'Retail Sale Id 1335',0.00,8375.00,720.00,9000.00,625.00,'2023-02-05 17:09:31'),(1359,'1','303',1,'Retail Sale Id 1336',0.00,2010.00,720.00,2160.00,150.00,'2023-02-05 17:14:26'),(1360,'1','303',1,'Retail Sale Id 1337',0.00,2700.10,720.00,2901.60,201.50,'2023-02-05 17:16:30'),(1361,'1','303',1,'Retail Sale Id 1338',0.00,2010.00,720.00,2160.00,150.00,'2023-02-05 17:32:08'),(1362,'1','303',1,'Retail Sale Id 1339',0.00,2680.00,720.00,2880.00,200.00,'2023-02-05 17:34:20'),(1363,'1','303',1,'Retail Sale Id 1340',0.00,2010.00,720.00,2160.00,150.00,'2023-02-05 17:37:35'),(1364,'1','303',1,'Retail Sale Id 1341',0.00,4020.00,720.00,4320.00,300.00,'2023-02-05 17:41:46'),(1365,'1','303',1,'Retail Sale Id 1342',0.00,4020.00,720.00,4320.00,300.00,'2023-02-05 17:47:24'),(1366,'1','303',1,'Retail Sale Id 1343',0.00,8375.00,720.00,9000.00,625.00,'2023-02-05 17:49:54'),(1367,'1','303',1,'Retail Sale Id 1344',0.00,670.00,720.00,720.00,50.00,'2023-02-05 17:52:12'),(1368,'1','303',1,'Retail Sale Id 1345',0.00,6.70,720.00,7.20,0.50,'2023-02-05 18:53:26'),(1369,'1','303',1,'Retail Sale Id 1346',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 08:12:37'),(1370,'1','303',1,'Retail Sale Id 1347',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 08:17:23'),(1371,'1','303',1,'Retail Sale Id 1348',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 08:23:34'),(1372,'1','303',1,'Retail Sale Id 1349',0.00,2010.00,720.00,2160.00,150.00,'2023-02-06 08:25:17'),(1373,'1','303',1,'Retail Sale Id 1350',0.00,2050.20,720.00,2203.20,153.00,'2023-02-06 08:53:58'),(1374,'1','303',1,'Retail Sale Id 1351',0.00,2010.00,720.00,2160.00,150.00,'2023-02-06 09:07:27'),(1375,'1','303',1,'Retail Sale Id 1352',0.00,2050.20,720.00,2203.20,153.00,'2023-02-06 09:11:10'),(1376,'1','303',1,'Retail Sale Id 1353',0.00,670.00,720.00,720.00,50.00,'2023-02-06 09:16:16'),(1377,'1','303',1,'Retail Sale Id 1354',0.00,2010.00,720.00,2160.00,150.00,'2023-02-06 09:18:16'),(1378,'1','303',1,'Retail Sale Id 1355',0.00,2010.00,720.00,2160.00,150.00,'2023-02-06 09:23:30'),(1379,'1','303',1,'Retail Sale Id 1356',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 09:26:42'),(1380,'1','303',1,'Retail Sale Id 1358',0.00,2793.90,720.00,3002.40,208.50,'2023-02-06 09:28:35'),(1381,'1','303',1,'Retail Sale Id 1359',0.00,1862.60,720.00,2001.60,139.00,'2023-02-06 09:36:50'),(1382,'1','303',1,'Retail Sale Id 1360',0.00,67000.00,690.00,69000.00,2000.00,'2023-02-06 09:47:05'),(1383,'1','303',1,'Retail Sale Id 1361',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 09:48:54'),(1384,'1','303',1,'Retail Sale Id 1362',0.00,3350.00,720.00,3600.00,250.00,'2023-02-06 09:50:52'),(1385,'1','303',1,'Retail Sale Id 1363',0.00,4187.50,720.00,4500.00,312.50,'2023-02-06 09:59:23'),(1386,'1','303',1,'Retail Sale Id 1364',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 10:16:39'),(1387,'1','303',1,'Retail Sale Id 1365',0.00,8375.00,720.00,9000.00,625.00,'2023-02-06 10:19:24'),(1388,'1','303',1,'Retail Sale Id 1366',0.00,2010.00,720.00,2160.00,150.00,'2023-02-06 10:32:34'),(1389,'1','303',1,'Retail Sale Id 1367',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 10:34:51'),(1390,'1','303',1,'Retail Sale Id 1368',0.00,743.70,720.00,799.20,55.50,'2023-02-06 10:40:53'),(1391,'1','303',1,'Retail Sale Id 1369',0.00,8375.00,720.00,9000.00,625.00,'2023-02-06 10:43:10'),(1392,'1','303',1,'Retail Sale Id 1370',0.00,1393.60,720.00,1497.60,104.00,'2023-02-06 10:46:10'),(1393,'1','303',1,'Retail Sale Id 1371',0.00,2010.00,720.00,2160.00,150.00,'2023-02-06 11:12:04'),(1394,'1','303',1,'Retail Sale Id 1371',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 11:12:04'),(1395,'1','303',1,'Retail Sale Id 1372',0.00,2010.00,720.00,2160.00,150.00,'2023-02-06 11:21:00'),(1396,'1','303',1,'Retail Sale Id 1373',0.00,2010.00,720.00,2160.00,150.00,'2023-02-06 11:28:18'),(1397,'1','303',1,'Retail Sale Id 1374',0.00,670.00,720.00,720.00,50.00,'2023-02-06 11:32:45'),(1398,'1','303',1,'Retail Sale Id 1375',0.00,8375.00,720.00,9000.00,625.00,'2023-02-06 11:50:26'),(1399,'1','303',1,'Retail Sale Id 1376',0.00,2010.00,720.00,2160.00,150.00,'2023-02-06 11:58:11'),(1400,'1','303',1,'Retail Sale Id 1376',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 11:58:11'),(1401,'1','303',1,'Retail Sale Id 1377',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 12:16:49'),(1402,'1','303',1,'Retail Sale Id 1378',0.00,4690.00,720.00,5040.00,350.00,'2023-02-06 12:23:51'),(1403,'1','303',1,'Retail Sale Id 1379',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 12:26:11'),(1404,'1','303',1,'Retail Sale Id 1380',0.00,2050.20,720.00,2203.20,153.00,'2023-02-06 12:39:22'),(1405,'1','303',1,'Retail Sale Id 1381',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 12:55:38'),(1406,'1','303',1,'Retail Sale Id 1382',0.00,1393.60,720.00,1497.60,104.00,'2023-02-06 13:04:48'),(1407,'1','303',1,'Retail Sale Id 1383',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-06 13:11:43'),(1408,'1','303',1,'Retail Sale Id 1384',0.00,6700.00,720.00,7200.00,500.00,'2023-02-06 13:19:21'),(1409,'1','303',1,'Retail Sale Id 1385',0.00,2010.00,720.00,2160.00,150.00,'2023-02-06 13:20:31'),(1410,'1','303',1,'Retail Sale Id 1386',0.00,931.30,720.00,1000.80,69.50,'2023-02-06 13:23:32'),(1411,'1','303',1,'Retail Sale Id 1387',0.00,2010.00,720.00,2160.00,150.00,'2023-02-06 13:29:07'),(1412,'1','303',1,'Retail Sale Id 1388',0.00,2680.00,720.00,2880.00,200.00,'2023-02-06 13:38:27'),(1413,'1','303',1,'Retail Sale Id 1389',0.00,2010.00,720.00,2160.00,150.00,'2023-02-06 13:42:09'),(1414,'1','303',1,'Retail Sale Id 1390',0.00,1393.60,720.00,1497.60,104.00,'2023-02-06 13:44:08'),(1415,'1','303',1,'Retail Sale Id 1391',0.00,1862.60,720.00,2001.60,139.00,'2023-02-06 13:45:17'),(1416,'1','303',1,'Retail Sale Id 1392',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 13:47:06'),(1417,'1','303',1,'Retail Sale Id 1393',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 13:48:56'),(1418,'1','303',1,'Retail Sale Id 1394',0.00,1393.60,720.00,1497.60,104.00,'2023-02-06 14:05:29'),(1419,'1','303',1,'Retail Sale Id 1395',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 14:11:35'),(1420,'1','303',1,'Retail Sale Id 1396',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 14:43:25'),(1421,'1','303',1,'Retail Sale Id 1397',0.00,8040.00,720.00,8640.00,600.00,'2023-02-06 14:47:13'),(1422,'1','303',1,'Retail Sale Id 1398',0.00,8375.00,720.00,9000.00,625.00,'2023-02-06 14:53:28'),(1423,'1','303',1,'Retail Sale Id 1399',0.00,8375.00,720.00,9000.00,625.00,'2023-02-06 14:55:02'),(1424,'1','303',1,'Retail Sale Id 1400',0.00,1393.60,720.00,1497.60,104.00,'2023-02-06 15:16:29'),(1425,'1','303',1,'Retail Sale Id 1401',0.00,2050.20,720.00,2203.20,153.00,'2023-02-06 15:22:59'),(1426,'1','303',1,'Retail Sale Id 1402',0.00,8375.00,720.00,9000.00,625.00,'2023-02-06 15:29:43'),(1427,'1','303',1,'Retail Sale Id 1403',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 15:32:08'),(1428,'1','303',1,'Retail Sale Id 1404',0.00,2010.00,720.00,2160.00,150.00,'2023-02-06 16:20:10'),(1429,'1','303',1,'Retail Sale Id 1405',0.00,2010.00,720.00,2160.00,150.00,'2023-02-06 16:26:08'),(1430,'1','303',1,'Retail Sale Id 1406',0.00,1862.60,720.00,2001.60,139.00,'2023-02-06 16:33:22'),(1431,'1','303',1,'Retail Sale Id 1407',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 16:36:30'),(1432,'1','303',1,'Retail Sale Id 1408',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 16:38:24'),(1433,'1','303',1,'Retail Sale Id 1409',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 16:41:48'),(1434,'1','303',1,'Retail Sale Id 1410',0.00,8375.00,720.00,9000.00,625.00,'2023-02-06 16:43:59'),(1435,'1','303',1,'Retail Sale Id 1411',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 16:45:49'),(1436,'1','303',1,'Retail Sale Id 1412',0.00,2050.20,720.00,2203.20,153.00,'2023-02-06 16:53:07'),(1437,'1','303',1,'Retail Sale Id 1413',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 16:57:40'),(1438,'1','303',1,'Return of Retail Sale Id 1388',2680.00,0.00,720.00,-2880.00,-200.00,'2023-02-06 17:05:24'),(1439,'1','303',1,'Retail Sale Id 1415',0.00,1393.60,720.00,1497.60,104.00,'2023-02-06 17:07:21'),(1440,'1','303',1,'Retail Sale Id 1416',0.00,931.30,720.00,1000.80,69.50,'2023-02-06 17:23:10'),(1441,'1','303',1,'Retail Sale Id 1417',0.00,2010.00,720.00,2160.00,150.00,'2023-02-06 17:27:04'),(1442,'1','303',1,'Retail Sale Id 1418',0.00,1340.00,720.00,1440.00,100.00,'2023-02-06 17:41:23'),(1443,'1','303',1,'Retail Sale Id 1418',0.00,2010.00,720.00,2160.00,150.00,'2023-02-06 17:41:23'),(1444,'1','303',1,'Retail Sale Id 1418',0.00,2010.00,720.00,2160.00,150.00,'2023-02-06 17:41:23'),(1445,'1','303',1,'Retail Sale Id 1419',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 17:42:50'),(1446,'1','303',1,'Retail Sale Id 1420',0.00,2010.00,720.00,2160.00,150.00,'2023-02-06 17:49:36'),(1447,'1','303',1,'Retail Sale Id 1421',0.00,4020.00,720.00,4320.00,300.00,'2023-02-06 17:58:07'),(1448,'1','303',1,'Retail Sale Id 1422',0.00,3999.90,720.00,4298.40,298.50,'2023-02-06 18:03:47'),(1449,'1','303',1,'Retail Sale Id 1423',0.00,6.70,720.00,7.20,0.50,'2023-02-06 18:48:08'),(1450,'1','303',1,'Retail Sale Id 1424',0.00,8375.00,720.00,9000.00,625.00,'2023-02-07 07:36:22'),(1451,'1','303',1,'Retail Sale Id 1425',0.00,8375.00,720.00,9000.00,625.00,'2023-02-07 07:59:19'),(1452,'1','303',1,'Retail Sale Id 1426',0.00,2010.00,720.00,2160.00,150.00,'2023-02-07 08:42:38'),(1453,'1','303',1,'Retail Sale Id 1427',0.00,4020.00,720.00,4320.00,300.00,'2023-02-07 09:23:50'),(1454,'1','303',1,'Retail Sale Id 1428',0.00,4020.00,720.00,4320.00,300.00,'2023-02-07 09:31:30'),(1455,'1','303',1,'Retail Sale Id 1428',0.00,4020.00,720.00,4320.00,300.00,'2023-02-07 09:31:30'),(1456,'1','303',1,'Retail Sale Id 1429',0.00,4020.00,720.00,4320.00,300.00,'2023-02-07 09:57:20'),(1457,'1','303',1,'Retail Sale Id 1430',0.00,4020.00,720.00,4320.00,300.00,'2023-02-07 10:00:45'),(1458,'1','303',1,'Retail Sale Id 1431',0.00,4020.00,720.00,4320.00,300.00,'2023-02-07 10:06:01'),(1459,'1','303',1,'Retail Sale Id 1432',0.00,3725.20,720.00,4003.20,278.00,'2023-02-07 10:08:14'),(1460,'1','303',1,'Retail Sale Id 1433',0.00,6700.00,720.00,7200.00,500.00,'2023-02-07 10:19:51'),(1461,'1','303',1,'Retail Sale Id 1434',0.00,2010.00,720.00,2160.00,150.00,'2023-02-07 10:24:51'),(1462,'1','303',1,'Retail Sale Id 1435',0.00,1340.00,720.00,1440.00,100.00,'2023-02-07 10:44:36'),(1463,'1','303',1,'Retail Sale Id 1436',0.00,4020.00,720.00,4320.00,300.00,'2023-02-07 10:48:29'),(1464,'1','303',1,'Retail Sale Id 1436',0.00,6700.00,720.00,7200.00,500.00,'2023-02-07 10:48:29'),(1465,'1','303',1,'Retail Sale Id 1437',0.00,2324.90,720.00,2498.40,173.50,'2023-02-07 10:50:21'),(1466,'1','303',1,'Retail Sale Id 1438',0.00,1299.80,720.00,1396.80,97.00,'2023-02-07 11:00:52'),(1467,'1','303',1,'Retail Sale Id 1439',0.00,8375.00,720.00,9000.00,625.00,'2023-02-07 11:13:30'),(1468,'1','303',1,'Retail Sale Id 1440',0.00,4020.00,720.00,4320.00,300.00,'2023-02-07 11:14:45'),(1469,'1','303',1,'Retail Sale Id 1441',0.00,4020.00,720.00,4320.00,300.00,'2023-02-07 11:16:01'),(1470,'1','303',1,'Retail Sale Id 1442',0.00,670.00,720.00,720.00,50.00,'2023-02-07 11:30:19'),(1471,'1','303',1,'Retail Sale Id 1443',0.00,1862.60,720.00,2001.60,139.00,'2023-02-07 11:37:22'),(1472,'1','303',1,'Retail Sale Id 1444',0.00,931.30,720.00,1000.80,69.50,'2023-02-07 11:40:59'),(1473,'1','303',1,'Retail Sale Id 1445',0.00,4020.00,720.00,4320.00,300.00,'2023-02-07 12:22:42'),(1474,'1','303',1,'Retail Sale Id 1446',0.00,4020.00,720.00,4320.00,300.00,'2023-02-07 12:37:46'),(1475,'1','303',1,'Retail Sale Id 1447',0.00,2050.20,720.00,2203.20,153.00,'2023-02-07 12:43:34'),(1476,'1','303',1,'Retail Sale Id 1448',0.00,4020.00,720.00,4320.00,300.00,'2023-02-07 12:55:02'),(1477,'1','303',1,'Retail Sale Id 1449',0.00,1340.00,720.00,1440.00,100.00,'2023-02-07 13:04:20'),(1478,'1','303',1,'Retail Sale Id 1450',0.00,3350.00,720.00,3600.00,250.00,'2023-02-07 13:19:15'),(1479,'1','303',1,'Retail Sale Id 1451',0.00,2010.00,720.00,2160.00,150.00,'2023-02-07 13:37:09'),(1480,'1','303',1,'Retail Sale Id 1452',0.00,4093.70,720.00,4399.20,305.50,'2023-02-07 13:39:16'),(1481,'1','303',1,'Retail Sale Id 1453',0.00,2050.20,720.00,2203.20,153.00,'2023-02-07 13:42:53'),(1482,'1','303',1,'Retail Sale Id 1454',0.00,1862.60,720.00,2001.60,139.00,'2023-02-07 13:51:31'),(1483,'1','303',1,'Retail Sale Id 1455',0.00,8375.00,720.00,9000.00,625.00,'2023-02-07 13:55:46'),(1484,'1','303',1,'Retail Sale Id 1455',0.00,8375.00,720.00,9000.00,625.00,'2023-02-07 13:55:46'),(1485,'1','303',1,'Retail Sale Id 1456',0.00,8375.00,720.00,9000.00,625.00,'2023-02-07 13:57:26'),(1486,'1','303',1,'Retail Sale Id 1456',0.00,8375.00,720.00,9000.00,625.00,'2023-02-07 13:57:26'),(1487,'1','303',1,'Retail Sale Id 1457',0.00,2324.90,720.00,2498.40,173.50,'2023-02-07 14:03:15'),(1488,'1','303',1,'Retail Sale Id 1458',0.00,3999.90,720.00,4298.40,298.50,'2023-02-07 14:05:59'),(1489,'1','303',1,'Retail Sale Id 1459',0.00,4690.00,720.00,5040.00,350.00,'2023-02-07 14:25:12'),(1490,'1','303',1,'Retail Sale Id 1460',0.00,4020.00,720.00,4320.00,300.00,'2023-02-07 14:45:18'),(1491,'1','303',1,'Retail Sale Id 1462',0.00,4020.00,720.00,4320.00,300.00,'2023-02-07 14:51:24'),(1492,'1','303',1,'Retail Sale Id 1463',0.00,3350.00,720.00,3600.00,250.00,'2023-02-07 14:52:38'),(1493,'1','303',1,'Retail Sale Id 1464',0.00,1862.60,720.00,2001.60,139.00,'2023-02-07 14:53:45'),(1494,'1','303',1,'Retail Sale Id 1465',0.00,2010.00,720.00,2160.00,150.00,'2023-02-07 15:02:03'),(1495,'1','303',1,'Retail Sale Id 1466',0.00,2010.00,720.00,2160.00,150.00,'2023-02-07 15:06:50'),(1496,'1','303',1,'Retail Sale Id 1467',0.00,4020.00,720.00,4320.00,300.00,'2023-02-07 15:10:14'),(1497,'1','303',1,'Retail Sale Id 1468',0.00,3350.00,720.00,3600.00,250.00,'2023-02-07 15:17:40'),(1498,'1','303',1,'Retail Sale Id 1469',0.00,8375.00,720.00,9000.00,625.00,'2023-02-07 15:44:53'),(1499,'1','303',1,'Retail Sale Id 1470',0.00,1862.60,720.00,2001.60,139.00,'2023-02-07 16:20:01'),(1500,'1','303',1,'Retail Sale Id 1471',0.00,4020.00,720.00,4320.00,300.00,'2023-02-07 16:26:18'),(1501,'1','303',1,'Retail Sale Id 1472',0.00,931.30,720.00,1000.80,69.50,'2023-02-07 16:33:59'),(1502,'1','303',1,'Retail Sale Id 1473',0.00,2050.20,720.00,2203.20,153.00,'2023-02-07 16:45:33'),(1503,'1','303',1,'Retail Sale Id 1474',0.00,2010.00,720.00,2160.00,150.00,'2023-02-07 16:48:11'),(1504,'1','303',1,'Retail Sale Id 1476',0.00,3350.00,720.00,3600.00,250.00,'2023-02-07 16:54:35'),(1505,'1','303',1,'Retail Sale Id 1477',0.00,1340.00,720.00,1440.00,100.00,'2023-02-07 16:55:36'),(1506,'1','303',1,'Retail Sale Id 1478',0.00,1862.60,720.00,2001.60,139.00,'2023-02-07 17:00:10'),(1507,'1','303',1,'Retail Sale Id 1479',0.00,2010.00,720.00,2160.00,150.00,'2023-02-07 17:03:06'),(1508,'1','303',1,'Retail Sale Id 1480',0.00,2050.20,720.00,2203.20,153.00,'2023-02-07 17:13:40'),(1509,'1','303',1,'Retail Sale Id 1481',0.00,4020.00,720.00,4320.00,300.00,'2023-02-07 17:29:03'),(1510,'1','303',1,'Retail Sale Id 1482',0.00,1862.60,720.00,2001.60,139.00,'2023-02-07 17:39:31'),(1511,'1','303',1,'Retail Sale Id 1483',0.00,2157.40,720.00,2318.40,161.00,'2023-02-07 17:41:41'),(1512,'1','303',1,'Retail Sale Id 1484',0.00,2010.00,720.00,2160.00,150.00,'2023-02-07 17:45:35'),(1513,'1','303',1,'Retail Sale Id 1486',0.00,2793.90,720.00,3002.40,208.50,'2023-02-07 17:55:20'),(1514,'1','303',1,'Retail Sale Id 1486',0.00,3725.20,720.00,4003.20,278.00,'2023-02-07 17:55:20'),(1515,'1','303',1,'Return of Retail Sale Id 1444',931.30,0.00,720.00,-1000.80,-69.50,'2023-02-07 18:53:29'),(1516,'1','303',1,'Retail Sale Id 1487',0.00,536.00,720.00,576.00,40.00,'2023-02-07 18:54:32'),(1517,'1','303',1,'Retail Sale Id 1488',0.00,4020.00,720.00,4320.00,300.00,'2023-02-08 08:11:09'),(1518,'1','303',1,'Retail Sale Id 1489',0.00,8375.00,720.00,9000.00,625.00,'2023-02-08 08:40:13'),(1519,'1','303',1,'Retail Sale Id 1491',0.00,4020.00,720.00,4320.00,300.00,'2023-02-08 08:42:19'),(1520,'1','303',1,'Retail Sale Id 1492',0.00,1340.00,720.00,1440.00,100.00,'2023-02-08 09:09:46'),(1521,'1','303',1,'Retail Sale Id 1493',0.00,4020.00,720.00,4320.00,300.00,'2023-02-08 09:19:07'),(1522,'1','303',1,'Retail Sale Id 1494',0.00,2010.00,720.00,2160.00,150.00,'2023-02-08 09:29:44'),(1523,'1','303',1,'Retail Sale Id 1495',0.00,2793.90,720.00,3002.40,208.50,'2023-02-08 09:30:51'),(1524,'1','303',1,'Retail Sale Id 1496',0.00,4020.00,720.00,4320.00,300.00,'2023-02-08 09:38:13'),(1525,'1','303',1,'Retail Sale Id 1497',0.00,4020.00,720.00,4320.00,300.00,'2023-02-08 09:45:39'),(1526,'1','303',1,'Retail Sale Id 1498',0.00,2324.90,720.00,2498.40,173.50,'2023-02-08 09:52:19'),(1527,'1','303',1,'Retail Sale Id 1499',0.00,2680.00,720.00,2880.00,200.00,'2023-02-08 10:28:14'),(1528,'1','303',1,'Retail Sale Id 1500',0.00,1862.60,720.00,2001.60,139.00,'2023-02-08 10:29:24'),(1529,'1','303',1,'Retail Sale Id 1501',0.00,4020.00,720.00,4320.00,300.00,'2023-02-08 10:41:37'),(1530,'1','303',1,'Retail Sale Id 1502',0.00,2010.00,720.00,2160.00,150.00,'2023-02-08 10:50:42'),(1531,'1','303',1,'Retail Sale Id 1503',0.00,8375.00,720.00,9000.00,625.00,'2023-02-08 10:54:57'),(1532,'1','303',1,'Retail Sale Id 1504',0.00,4020.00,720.00,4320.00,300.00,'2023-02-08 11:11:25'),(1533,'1','303',1,'Retail Sale Id 1505',0.00,4020.00,720.00,4320.00,300.00,'2023-02-08 11:25:02'),(1534,'1','303',1,'Retail Sale Id 1506',0.00,2793.90,720.00,3002.40,208.50,'2023-02-08 11:33:57'),(1535,'1','303',1,'Retail Sale Id 1508',0.00,8375.00,720.00,9000.00,625.00,'2023-02-08 15:28:07'),(1536,'1','303',1,'Retail Sale Id 1509',0.00,4020.00,720.00,4320.00,300.00,'2023-02-08 15:29:08'),(1537,'1','303',1,'Retail Sale Id 1510',0.00,1393.60,720.00,1497.60,104.00,'2023-02-08 15:29:54'),(1538,'1','303',1,'Retail Sale Id 1511',0.00,2010.00,720.00,2160.00,150.00,'2023-02-08 15:33:32'),(1539,'1','303',1,'Retail Sale Id 1512',0.00,3350.00,720.00,3600.00,250.00,'2023-02-08 15:35:12'),(1540,'1','303',1,'Retail Sale Id 1513',0.00,2010.00,720.00,2160.00,150.00,'2023-02-08 15:36:06'),(1541,'1','303',1,'Retail Sale Id 1514',0.00,2680.00,720.00,2880.00,200.00,'2023-02-08 15:36:59'),(1542,'1','303',1,'Retail Sale Id 1515',0.00,4020.00,720.00,4320.00,300.00,'2023-02-08 15:38:22'),(1543,'1','303',1,'Retail Sale Id 1516',0.00,2010.00,720.00,2160.00,150.00,'2023-02-08 15:39:48'),(1544,'1','303',1,'Retail Sale Id 1517',0.00,4020.00,720.00,4320.00,300.00,'2023-02-08 15:41:36'),(1545,'1','303',1,'Retail Sale Id 1518',0.00,2793.90,720.00,3002.40,208.50,'2023-02-08 15:42:27'),(1546,'1','303',1,'Retail Sale Id 1519',0.00,2050.20,720.00,2203.20,153.00,'2023-02-08 15:44:37'),(1547,'1','303',1,'Retail Sale Id 1520',0.00,8375.00,720.00,9000.00,625.00,'2023-02-08 15:45:59'),(1548,'1','303',1,'Retail Sale Id 1521',0.00,4020.00,720.00,4320.00,300.00,'2023-02-08 15:58:21'),(1549,'1','303',1,'Retail Sale Id 1522',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-08 15:59:45'),(1550,'1','303',1,'Retail Sale Id 1523',0.00,4020.00,720.00,4320.00,300.00,'2023-02-08 16:06:18'),(1551,'1','303',1,'Retail Sale Id 1524',0.00,7443.70,720.00,7999.20,555.50,'2023-02-08 16:11:06'),(1552,'1','303',1,'Retail Sale Id 1525',0.00,931.30,720.00,1000.80,69.50,'2023-02-08 16:19:29'),(1553,'1','303',1,'Retail Sale Id 1526',0.00,8375.00,720.00,9000.00,625.00,'2023-02-08 16:25:38'),(1554,'1','303',1,'Retail Sale Id 1527',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-08 16:28:35'),(1555,'1','303',1,'Retail Sale Id 1528',0.00,2050.20,720.00,2203.20,153.00,'2023-02-08 16:30:18'),(1556,'1','303',1,'Retail Sale Id 1529',0.00,8375.00,720.00,9000.00,625.00,'2023-02-08 16:32:50'),(1557,'1','303',1,'Retail Sale Id 1530',0.00,4020.00,720.00,4320.00,300.00,'2023-02-08 16:36:29'),(1558,'1','303',1,'Retail Sale Id 1531',0.00,3350.00,720.00,3600.00,250.00,'2023-02-08 16:37:55'),(1559,'1','303',1,'Retail Sale Id 1532',0.00,4020.00,720.00,4320.00,300.00,'2023-02-08 16:44:57'),(1560,'1','303',1,'Retail Sale Id 1533',0.00,1862.60,720.00,2001.60,139.00,'2023-02-08 16:48:26'),(1561,'1','303',1,'Retail Sale Id 1534',0.00,3999.90,720.00,4298.40,298.50,'2023-02-08 16:51:50'),(1562,'1','303',1,'Retail Sale Id 1535',0.00,6700.00,720.00,7200.00,500.00,'2023-02-08 17:04:26'),(1563,'1','303',1,'Retail Sale Id 1536',0.00,1862.60,720.00,2001.60,139.00,'2023-02-08 17:05:50'),(1564,'1','303',1,'Retail Sale Id 1537',0.00,1862.60,720.00,2001.60,139.00,'2023-02-08 17:11:42'),(1565,'1','303',1,'Retail Sale Id 1538',0.00,4020.00,720.00,4320.00,300.00,'2023-02-08 17:15:19'),(1566,'1','303',1,'Retail Sale Id 1539',0.00,8375.00,720.00,9000.00,625.00,'2023-02-08 17:16:31'),(1567,'1','303',1,'Retail Sale Id 1540',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-08 17:29:57'),(1568,'1','303',1,'Retail Sale Id 1541',0.00,3350.00,720.00,3600.00,250.00,'2023-02-08 17:36:52'),(1569,'1','303',1,'Retail Sale Id 1542',0.00,4020.00,720.00,4320.00,300.00,'2023-02-08 17:38:02'),(1570,'1','303',1,'Retail Sale Id 1543',0.00,3725.20,720.00,4003.20,278.00,'2023-02-08 17:39:32'),(1571,'1','303',1,'Retail Sale Id 1544',0.00,3256.20,720.00,3499.20,243.00,'2023-02-08 17:41:30'),(1572,'1','303',1,'Retail Sale Id 1545',0.00,8388.40,720.00,9014.40,626.00,'2023-02-08 18:55:20'),(1573,'1','303',1,'Retail Sale Id 1546',0.00,1340.00,720.00,1440.00,100.00,'2023-02-09 07:41:16'),(1574,'1','303',1,'Retail Sale Id 1547',0.00,2793.90,720.00,3002.40,208.50,'2023-02-09 08:37:40'),(1575,'1','303',1,'Retail Sale Id 1548',0.00,3350.00,720.00,3600.00,250.00,'2023-02-09 09:01:44'),(1576,'1','303',1,'Retail Sale Id 1549',0.00,8375.00,720.00,9000.00,625.00,'2023-02-09 09:23:37'),(1577,'1','303',1,'Retail Sale Id 1550',0.00,8375.00,720.00,9000.00,625.00,'2023-02-09 09:26:31'),(1578,'1','303',1,'Retail Sale Id 1551',0.00,2010.00,720.00,2160.00,150.00,'2023-02-09 09:35:12'),(1579,'1','303',1,'Retail Sale Id 1552',0.00,2050.20,720.00,2203.20,153.00,'2023-02-09 09:38:02'),(1580,'1','303',1,'Retail Sale Id 1553',0.00,67000.00,690.00,69000.00,2000.00,'2023-02-09 09:54:06'),(1581,'1','303',1,'Retail Sale Id 1554',0.00,4020.00,720.00,4320.00,300.00,'2023-02-09 10:36:41'),(1582,'1','303',1,'Retail Sale Id 1555',0.00,2050.20,720.00,2203.20,153.00,'2023-02-09 10:37:58'),(1583,'1','303',1,'Retail Sale Id 1556',0.00,1393.60,720.00,1497.60,104.00,'2023-02-09 10:45:01'),(1584,'1','303',1,'Retail Sale Id 1557',0.00,1118.90,720.00,1202.40,83.50,'2023-02-09 10:52:23'),(1585,'1','303',1,'Retail Sale Id 1558',0.00,2793.90,720.00,3002.40,208.50,'2023-02-09 10:55:53'),(1586,'1','303',1,'Retail Sale Id 1559',0.00,2010.00,720.00,2160.00,150.00,'2023-02-09 11:04:51'),(1587,'1','303',1,'Retail Sale Id 1560',0.00,3999.90,720.00,4298.40,298.50,'2023-02-09 11:36:04'),(1588,'1','303',1,'Retail Sale Id 1561',0.00,1393.60,720.00,1497.60,104.00,'2023-02-09 11:52:21'),(1589,'1','303',1,'Retail Sale Id 1562',0.00,3999.90,720.00,4298.40,298.50,'2023-02-09 11:55:38'),(1590,'1','303',1,'Retail Sale Id 1563',0.00,8375.00,720.00,9000.00,625.00,'2023-02-09 11:58:00'),(1591,'1','303',1,'Return of Retail Sale Id 1563',8375.00,0.00,720.00,-9000.00,-625.00,'2023-02-09 12:12:38'),(1592,'1','303',1,'Retail Sale Id 1564',0.00,7658.10,720.00,8229.60,571.50,'2023-02-09 12:13:35'),(1593,'1','303',1,'Retail Sale Id 1565',0.00,4020.00,720.00,4320.00,300.00,'2023-02-09 12:18:03'),(1594,'1','303',1,'Retail Sale Id 1566',0.00,6700.00,720.00,7200.00,500.00,'2023-02-09 12:19:30'),(1595,'1','303',1,'Retail Sale Id 1567',0.00,1393.60,720.00,1497.60,104.00,'2023-02-09 12:28:38'),(1596,'1','303',1,'Retail Sale Id 1568',0.00,4020.00,720.00,4320.00,300.00,'2023-02-09 12:43:30'),(1597,'1','303',1,'Retail Sale Id 1569',0.00,2010.00,720.00,2160.00,150.00,'2023-02-09 12:50:10'),(1598,'1','303',1,'Retail Sale Id 1569',0.00,2680.00,720.00,2880.00,200.00,'2023-02-09 12:50:10'),(1599,'1','303',1,'Retail Sale Id 1570',0.00,1862.60,720.00,2001.60,139.00,'2023-02-09 12:56:32'),(1600,'1','303',1,'Retail Sale Id 1571',0.00,4020.00,720.00,4320.00,300.00,'2023-02-09 13:28:32'),(1601,'1','303',1,'Retail Sale Id 1573',0.00,4020.00,720.00,4320.00,300.00,'2023-02-09 13:33:59'),(1602,'1','303',1,'Retail Sale Id 1574',0.00,4020.00,720.00,4320.00,300.00,'2023-02-09 13:55:57'),(1603,'1','303',1,'Retail Sale Id 1575',0.00,4020.00,720.00,4320.00,300.00,'2023-02-09 14:07:57'),(1604,'1','303',1,'Retail Sale Id 1576',0.00,4020.00,720.00,4320.00,300.00,'2023-02-09 14:16:41'),(1605,'1','303',1,'Retail Sale Id 1576',0.00,6700.00,720.00,7200.00,500.00,'2023-02-09 14:16:41'),(1606,'1','303',1,'Retail Sale Id 1577',0.00,4020.00,720.00,4320.00,300.00,'2023-02-09 14:26:38'),(1607,'1','303',1,'Retail Sale Id 1578',0.00,931.30,720.00,1000.80,69.50,'2023-02-09 14:34:35'),(1608,'1','303',1,'Retail Sale Id 1579',0.00,8375.00,720.00,9000.00,625.00,'2023-02-09 14:39:46'),(1609,'1','303',1,'Retail Sale Id 1580',0.00,2050.20,720.00,2203.20,153.00,'2023-02-09 14:49:38'),(1610,'1','303',1,'Retail Sale Id 1581',0.00,2793.90,720.00,3002.40,208.50,'2023-02-09 14:54:09'),(1611,'1','303',1,'Retail Sale Id 1582',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-09 14:57:03'),(1612,'1','303',1,'Retail Sale Id 1583',0.00,931.30,720.00,1000.80,69.50,'2023-02-09 15:10:18'),(1613,'1','303',1,'Retail Sale Id 1584',0.00,4020.00,720.00,4320.00,300.00,'2023-02-09 15:23:23'),(1614,'1','303',1,'Retail Sale Id 1585',0.00,4020.00,720.00,4320.00,300.00,'2023-02-09 15:28:26'),(1615,'1','303',1,'Retail Sale Id 1586',0.00,2010.00,720.00,2160.00,150.00,'2023-02-09 16:19:41'),(1616,'1','303',1,'Retail Sale Id 1587',0.00,1862.60,720.00,2001.60,139.00,'2023-02-09 16:21:55'),(1617,'1','303',1,'Retail Sale Id 1588',0.00,2010.00,720.00,2160.00,150.00,'2023-02-09 16:23:58'),(1618,'1','303',1,'Retail Sale Id 1589',0.00,4020.00,720.00,4320.00,300.00,'2023-02-09 16:29:51'),(1619,'1','303',1,'Retail Sale Id 1590',0.00,4020.00,720.00,4320.00,300.00,'2023-02-09 16:31:13'),(1620,'1','303',1,'Retail Sale Id 1591',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-09 16:43:20'),(1621,'1','303',1,'Retail Sale Id 1592',0.00,8375.00,720.00,9000.00,625.00,'2023-02-09 16:49:26'),(1622,'1','303',1,'Retail Sale Id 1593',0.00,8375.00,720.00,9000.00,625.00,'2023-02-09 16:50:17'),(1623,'1','303',1,'Retail Sale Id 1594',0.00,8375.00,720.00,9000.00,625.00,'2023-02-09 16:51:15'),(1624,'1','303',1,'Retail Sale Id 1595',0.00,2680.00,720.00,2880.00,200.00,'2023-02-09 16:53:44'),(1625,'1','303',1,'Retail Sale Id 1596',0.00,931.30,720.00,1000.80,69.50,'2023-02-09 16:58:07'),(1626,'1','303',1,'Retail Sale Id 1597',0.00,4649.80,720.00,4996.80,347.00,'2023-02-09 16:59:12'),(1627,'1','303',1,'Retail Sale Id 1598',0.00,4020.00,720.00,4320.00,300.00,'2023-02-09 17:02:49'),(1628,'1','303',1,'Retail Sale Id 1599',0.00,6700.00,720.00,7200.00,500.00,'2023-02-09 17:05:44'),(1629,'1','303',1,'Retail Sale Id 1600',0.00,1340.00,720.00,1440.00,100.00,'2023-02-09 17:12:34'),(1630,'1','303',1,'Retail Sale Id 1601',0.00,4020.00,720.00,4320.00,300.00,'2023-02-09 17:16:17'),(1631,'1','303',1,'Retail Sale Id 1602',0.00,4690.00,720.00,5040.00,350.00,'2023-02-09 17:39:33'),(1632,'1','303',1,'Retail Sale Id 1603',0.00,2010.00,720.00,2160.00,150.00,'2023-02-09 17:50:00'),(1633,'1','303',1,'Retail Sale Id 1604',0.00,3350.00,720.00,3600.00,250.00,'2023-02-09 17:51:24'),(1634,'1','303',1,'Retail Sale Id 1605',0.00,4020.00,720.00,4320.00,300.00,'2023-02-09 17:55:21'),(1635,'1','303',1,'Retail Sale Id 1606',0.00,569500.00,690.00,586500.00,17000.00,'2023-02-09 18:04:34'),(1636,'1','303',1,'Retail Sale Id 1607',0.00,13.40,720.00,14.40,1.00,'2023-02-09 18:35:23'),(1637,'1','303',1,'Retail Sale Id 1608',0.00,38860.00,690.00,40020.00,1160.00,'2023-02-10 08:50:45'),(1638,'1','303',1,'Retail Sale Id 1609',0.00,2010.00,720.00,2160.00,150.00,'2023-02-10 09:22:35'),(1639,'1','303',1,'Retail Sale Id 1610',0.00,4020.00,720.00,4320.00,300.00,'2023-02-10 09:40:52'),(1640,'1','303',1,'Retail Sale Id 1611',0.00,2010.00,720.00,2160.00,150.00,'2023-02-10 10:00:15'),(1641,'1','303',1,'Retail Sale Id 1612',0.00,4020.00,720.00,4320.00,300.00,'2023-02-10 10:01:44'),(1642,'1','303',1,'Retail Sale Id 1613',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-10 10:12:44'),(1643,'1','303',1,'Retail Sale Id 1614',0.00,1118.90,720.00,1202.40,83.50,'2023-02-10 10:20:26'),(1644,'1','303',1,'Retail Sale Id 1615',0.00,3725.20,720.00,4003.20,278.00,'2023-02-10 10:21:21'),(1645,'1','303',1,'Retail Sale Id 1616',0.00,8375.00,720.00,9000.00,625.00,'2023-02-10 10:27:01'),(1646,'1','303',1,'Retail Sale Id 1617',0.00,2010.00,720.00,2160.00,150.00,'2023-02-10 10:32:56'),(1647,'1','303',1,'Retail Sale Id 1618',0.00,4187.50,720.00,4500.00,312.50,'2023-02-10 10:38:01'),(1648,'1','303',1,'Retail Sale Id 1619',0.00,3350.00,720.00,3600.00,250.00,'2023-02-10 10:53:03'),(1649,'1','303',1,'Retail Sale Id 1620',0.00,931.30,720.00,1000.80,69.50,'2023-02-10 11:03:29'),(1650,'1','303',1,'Retail Sale Id 1621',0.00,8375.00,720.00,9000.00,625.00,'2023-02-10 11:08:33'),(1651,'1','303',1,'Retail Sale Id 1622',0.00,4020.00,720.00,4320.00,300.00,'2023-02-10 11:11:19'),(1652,'1','303',1,'Retail Sale Id 1623',0.00,2010.00,720.00,2160.00,150.00,'2023-02-10 11:28:43'),(1653,'1','303',1,'Retail Sale Id 1624',0.00,3999.90,720.00,4298.40,298.50,'2023-02-10 11:31:50'),(1654,'1','303',1,'Retail Sale Id 1625',0.00,2010.00,720.00,2160.00,150.00,'2023-02-10 11:51:21'),(1655,'1','303',1,'Retail Sale Id 1626',0.00,1862.60,720.00,2001.60,139.00,'2023-02-10 11:52:20'),(1656,'1','303',1,'Retail Sale Id 1627',0.00,38860.00,690.00,40020.00,1160.00,'2023-02-10 12:00:13'),(1657,'1','303',1,'Retail Sale Id 1628',0.00,2324.90,720.00,2498.40,173.50,'2023-02-10 12:02:17'),(1658,'1','303',1,'Retail Sale Id 1629',0.00,4020.00,720.00,4320.00,300.00,'2023-02-10 12:04:14'),(1659,'1','303',1,'Retail Sale Id 1630',0.00,1862.60,720.00,2001.60,139.00,'2023-02-10 12:05:46'),(1660,'1','303',1,'Retail Sale Id 1631',0.00,167500.00,690.00,172500.00,5000.00,'2023-02-10 12:08:26'),(1661,'1','303',1,'Retail Sale Id 1632',0.00,4020.00,720.00,4320.00,300.00,'2023-02-10 12:11:15'),(1662,'1','303',1,'Retail Sale Id 1633',0.00,1862.60,720.00,2001.60,139.00,'2023-02-10 12:13:44'),(1663,'1','303',1,'Retail Sale Id 1634',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-10 13:02:43'),(1664,'1','303',1,'Retail Sale Id 1635',0.00,670.00,720.00,720.00,50.00,'2023-02-10 13:07:53'),(1665,'1','303',1,'Retail Sale Id 1637',0.00,2050.20,720.00,2203.20,153.00,'2023-02-10 13:22:42'),(1666,'1','303',1,'Retail Sale Id 1638',0.00,4020.00,720.00,4320.00,300.00,'2023-02-10 13:40:55'),(1667,'1','303',1,'Retail Sale Id 1639',0.00,8375.00,720.00,9000.00,625.00,'2023-02-10 14:44:04'),(1668,'1','303',1,'Retail Sale Id 1640',0.00,2010.00,720.00,2160.00,150.00,'2023-02-10 15:12:37'),(1669,'1','303',1,'Retail Sale Id 1641',0.00,2010.00,720.00,2160.00,150.00,'2023-02-10 15:15:16'),(1670,'1','303',1,'Retail Sale Id 1642',0.00,4020.00,720.00,4320.00,300.00,'2023-02-10 15:58:47'),(1671,'1','303',1,'Retail Sale Id 1643',0.00,3738.60,720.00,4017.60,279.00,'2023-02-10 16:20:29'),(1672,'1','303',1,'Retail Sale Id 1644',0.00,2793.90,720.00,3002.40,208.50,'2023-02-10 16:23:27'),(1673,'1','303',1,'Retail Sale Id 1645',0.00,2010.00,720.00,2160.00,150.00,'2023-02-10 16:39:38'),(1674,'1','303',1,'Retail Sale Id 1646',0.00,8375.00,720.00,9000.00,625.00,'2023-02-10 16:40:59'),(1675,'1','303',1,'Retail Sale Id 1647',0.00,5360.00,720.00,5760.00,400.00,'2023-02-10 16:55:59'),(1676,'1','303',1,'Retail Sale Id 1648',0.00,4020.00,720.00,4320.00,300.00,'2023-02-10 17:15:00'),(1677,'1','303',1,'Retail Sale Id 1649',0.00,4020.00,720.00,4320.00,300.00,'2023-02-10 17:37:17'),(1678,'1','303',1,'Retail Sale Id 1650',0.00,2050.20,720.00,2203.20,153.00,'2023-02-10 17:39:21'),(1679,'1','303',1,'Retail Sale Id 1651',0.00,8375.00,720.00,9000.00,625.00,'2023-02-10 18:06:43'),(1680,'1','303',1,'Retail Sale Id 1652',0.00,4020.00,720.00,4320.00,300.00,'2023-02-10 18:22:42'),(1681,'1','303',1,'Return of Retail Sale Id 1645',2010.00,0.00,720.00,-2160.00,-150.00,'2023-02-10 19:33:03'),(1682,'1','303',1,'Retail Sale Id 1653',0.00,1480.70,720.00,1591.20,110.50,'2023-02-10 19:33:40'),(1683,'1','303',1,'Return of Retail Sale Id 1634',33500.00,0.00,690.00,-34500.00,-1000.00,'2023-02-10 19:34:57'),(1684,'1','303',1,'Retail Sale Id 1654',0.00,32843.40,690.00,33823.80,980.40,'2023-02-10 19:36:22'),(1685,'1','303',1,'Retail Sale Id 1656',0.00,1313.20,690.00,1352.40,39.20,'2023-02-10 19:38:38'),(1686,'1','303',1,'Retail Sale Id 1657',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-11 08:52:31'),(1687,'1','303',1,'Retail Sale Id 1658',0.00,1862.60,720.00,2001.60,139.00,'2023-02-11 09:01:43'),(1688,'1','303',1,'Retail Sale Id 1659',0.00,8375.00,720.00,9000.00,625.00,'2023-02-11 09:14:00'),(1689,'1','303',1,'Retail Sale Id 1660',0.00,4020.00,720.00,4320.00,300.00,'2023-02-11 09:34:14'),(1690,'1','303',1,'Retail Sale Id 1661',0.00,4020.00,720.00,4320.00,300.00,'2023-02-11 09:57:04'),(1691,'1','303',1,'Retail Sale Id 1662',0.00,2010.00,720.00,2160.00,150.00,'2023-02-11 10:05:39'),(1692,'1','303',1,'Retail Sale Id 1663',0.00,4020.00,720.00,4320.00,300.00,'2023-02-11 10:18:02'),(1693,'1','303',1,'Retail Sale Id 1664',0.00,837.50,720.00,900.00,62.50,'2023-02-11 10:25:47'),(1694,'1','303',1,'Retail Sale Id 1665',0.00,4020.00,720.00,4320.00,300.00,'2023-02-11 10:32:48'),(1695,'1','303',1,'Retail Sale Id 1666',0.00,4020.00,720.00,4320.00,300.00,'2023-02-11 10:41:48'),(1696,'1','303',1,'Retail Sale Id 1667',0.00,7443.70,720.00,7999.20,555.50,'2023-02-11 10:44:04'),(1697,'1','303',1,'Retail Sale Id 1668',0.00,1340.00,720.00,1440.00,100.00,'2023-02-11 10:45:52'),(1698,'1','303',1,'Retail Sale Id 1669',0.00,4020.00,720.00,4320.00,300.00,'2023-02-11 10:51:45'),(1699,'1','303',1,'Retail Sale Id 1670',0.00,4020.00,720.00,4320.00,300.00,'2023-02-11 10:59:06'),(1700,'1','303',1,'Retail Sale Id 1671',0.00,2010.00,720.00,2160.00,150.00,'2023-02-11 11:06:27'),(1701,'1','303',1,'Retail Sale Id 1672',0.00,6700.00,720.00,7200.00,500.00,'2023-02-11 11:25:02'),(1702,'1','303',1,'Retail Sale Id 1673',0.00,4020.00,720.00,4320.00,300.00,'2023-02-11 11:26:13'),(1703,'1','303',1,'Retail Sale Id 1674',0.00,4020.00,720.00,4320.00,300.00,'2023-02-11 11:29:12'),(1704,'1','303',1,'Retail Sale Id 1675',0.00,1393.60,720.00,1497.60,104.00,'2023-02-11 11:36:23'),(1705,'1','303',1,'Retail Sale Id 1676',0.00,4020.00,720.00,4320.00,300.00,'2023-02-11 11:41:10'),(1706,'1','303',1,'Retail Sale Id 1677',0.00,38860.00,690.00,40020.00,1160.00,'2023-02-11 11:44:10'),(1707,'1','303',1,'Retail Sale Id 1678',0.00,3350.00,720.00,3600.00,250.00,'2023-02-11 11:46:14'),(1708,'1','303',1,'Retail Sale Id 1679',0.00,3350.00,720.00,3600.00,250.00,'2023-02-11 11:47:55'),(1709,'1','303',1,'Retail Sale Id 1680',0.00,4020.00,720.00,4320.00,300.00,'2023-02-11 11:49:40'),(1710,'1','303',1,'Retail Sale Id 1681',0.00,3350.00,720.00,3600.00,250.00,'2023-02-11 11:51:35'),(1711,'1','303',1,'Retail Sale Id 1682',0.00,4020.00,720.00,4320.00,300.00,'2023-02-11 11:53:49'),(1712,'1','303',1,'Retail Sale Id 1683',0.00,8375.00,720.00,9000.00,625.00,'2023-02-11 12:25:59'),(1713,'1','303',1,'Retail Sale Id 1684',0.00,67000.00,690.00,69000.00,2000.00,'2023-02-11 12:28:46'),(1714,'1','303',1,'Retail Sale Id 1685',0.00,3350.00,720.00,3600.00,250.00,'2023-02-11 12:32:51'),(1715,'1','303',1,'Retail Sale Id 1685',0.00,4020.00,720.00,4320.00,300.00,'2023-02-11 12:32:51'),(1716,'1','303',1,'Retail Sale Id 1686',0.00,8375.00,720.00,9000.00,625.00,'2023-02-11 12:34:34'),(1717,'1','303',1,'Retail Sale Id 1687',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-11 12:36:24'),(1718,'1','303',1,'Retail Sale Id 1688',0.00,3350.00,720.00,3600.00,250.00,'2023-02-11 13:06:00'),(1719,'1','303',1,'Retail Sale Id 1689',0.00,1862.60,720.00,2001.60,139.00,'2023-02-11 13:06:54'),(1720,'1','303',1,'Retail Sale Id 1690',0.00,4020.00,720.00,4320.00,300.00,'2023-02-11 13:18:11'),(1721,'1','303',1,'Retail Sale Id 1691',0.00,2793.90,720.00,3002.40,208.50,'2023-02-11 13:43:26'),(1722,'1','303',1,'Retail Sale Id 1692',0.00,1862.60,720.00,2001.60,139.00,'2023-02-11 14:27:22'),(1723,'1','303',1,'Retail Sale Id 1693',0.00,1340.00,720.00,1440.00,100.00,'2023-02-11 14:49:14'),(1724,'1','303',1,'Retail Sale Id 1694',0.00,4020.00,720.00,4320.00,300.00,'2023-02-11 14:57:21'),(1725,'1','303',1,'Retail Sale Id 1695',0.00,670.00,720.00,720.00,50.00,'2023-02-11 15:04:16'),(1726,'1','303',1,'Retail Sale Id 1696',0.00,2010.00,720.00,2160.00,150.00,'2023-02-11 15:08:08'),(1727,'1','303',1,'Retail Sale Id 1697',0.00,100500.00,690.00,103500.00,3000.00,'2023-02-11 15:13:12'),(1728,'1','303',1,'Retail Sale Id 1698',0.00,2010.00,720.00,2160.00,150.00,'2023-02-11 15:21:00'),(1729,'1','303',1,'Retail Sale Id 1698',0.00,4020.00,720.00,4320.00,300.00,'2023-02-11 15:21:00'),(1730,'1','303',1,'Retail Sale Id 1699',0.00,4020.00,720.00,4320.00,300.00,'2023-02-11 15:28:35'),(1731,'1','303',1,'Retail Sale Id 1700',0.00,8375.00,720.00,9000.00,625.00,'2023-02-11 15:35:20'),(1732,'1','303',1,'Retail Sale Id 1701',0.00,1862.60,720.00,2001.60,139.00,'2023-02-11 15:56:56'),(1733,'1','303',1,'Retail Sale Id 1702',0.00,3350.00,720.00,3600.00,250.00,'2023-02-11 15:58:37'),(1734,'1','303',1,'Retail Sale Id 1703',0.00,1025.10,720.00,1101.60,76.50,'2023-02-11 16:21:52'),(1735,'1','303',1,'Retail Sale Id 1704',0.00,3350.00,720.00,3600.00,250.00,'2023-02-11 16:27:09'),(1736,'1','303',1,'Retail Sale Id 1705',0.00,3256.20,720.00,3499.20,243.00,'2023-02-11 16:27:55'),(1737,'1','303',1,'Retail Sale Id 1706',0.00,1862.60,720.00,2001.60,139.00,'2023-02-11 16:29:32'),(1738,'1','303',1,'Retail Sale Id 1707',0.00,2010.00,720.00,2160.00,150.00,'2023-02-11 16:37:01'),(1739,'1','303',1,'Retail Sale Id 1708',0.00,670.00,720.00,720.00,50.00,'2023-02-11 16:38:28'),(1740,'1','303',1,'Retail Sale Id 1709',0.00,8375.00,720.00,9000.00,625.00,'2023-02-11 16:53:11'),(1741,'1','303',1,'Retail Sale Id 1710',0.00,2010.00,720.00,2160.00,150.00,'2023-02-11 16:59:43'),(1742,'1','303',1,'Retail Sale Id 1711',0.00,2010.00,720.00,2160.00,150.00,'2023-02-11 17:30:56'),(1743,'1','303',1,'Retail Sale Id 1712',0.00,2010.00,720.00,2160.00,150.00,'2023-02-11 17:32:14'),(1744,'1','303',1,'Retail Sale Id 1713',0.00,1340.00,720.00,1440.00,100.00,'2023-02-11 17:33:32'),(1745,'1','303',1,'Retail Sale Id 1714',0.00,4020.00,720.00,4320.00,300.00,'2023-02-11 17:43:20'),(1746,'1','303',1,'Retail Sale Id 1715',0.00,3350.00,720.00,3600.00,250.00,'2023-02-11 17:52:59'),(1747,'1','303',1,'Retail Sale Id 1716',0.00,8375.00,720.00,9000.00,625.00,'2023-02-11 17:57:12'),(1748,'1','303',1,'Retail Sale Id 1717',0.00,1005.00,720.00,1080.00,75.00,'2023-02-11 18:01:28'),(1749,'1','303',1,'Return of Retail Sale Id 1714',4020.00,0.00,720.00,-4320.00,-300.00,'2023-02-11 18:46:49'),(1750,'1','303',1,'Retail Sale Id 1718',0.00,676.70,720.00,727.20,50.50,'2023-02-11 18:47:20'),(1751,'1','303',1,'Retail Sale Id 1719',0.00,1340.00,720.00,1440.00,100.00,'2023-02-12 08:39:01'),(1752,'1','303',1,'Retail Sale Id 1722',0.00,4020.00,720.00,4320.00,300.00,'2023-02-12 08:52:04'),(1753,'1','303',1,'Retail Sale Id 1723',0.00,4690.00,720.00,5040.00,350.00,'2023-02-12 09:01:54'),(1754,'1','303',1,'Retail Sale Id 1724',0.00,2010.00,720.00,2160.00,150.00,'2023-02-12 09:04:56'),(1755,'1','303',1,'Retail Sale Id 1725',0.00,6700.00,720.00,7200.00,500.00,'2023-02-12 09:10:42'),(1756,'1','303',1,'Retail Sale Id 1726',0.00,4020.00,720.00,4320.00,300.00,'2023-02-12 09:17:53'),(1757,'1','303',1,'Retail Sale Id 1727',0.00,38860.00,690.00,40020.00,1160.00,'2023-02-12 09:27:23'),(1758,'1','303',1,'Retail Sale Id 1728',0.00,3350.00,720.00,3600.00,250.00,'2023-02-12 09:43:04'),(1759,'1','303',1,'Retail Sale Id 1728',0.00,3350.00,720.00,3600.00,250.00,'2023-02-12 09:43:04'),(1760,'1','303',1,'Retail Sale Id 1729',0.00,2010.00,720.00,2160.00,150.00,'2023-02-12 09:44:56'),(1761,'1','303',1,'Retail Sale Id 1730',0.00,2010.00,720.00,2160.00,150.00,'2023-02-12 10:09:29'),(1762,'1','303',1,'Retail Sale Id 1731',0.00,4187.50,720.00,4500.00,312.50,'2023-02-12 10:14:42'),(1763,'1','303',1,'Retail Sale Id 1732',0.00,4020.00,720.00,4320.00,300.00,'2023-02-12 10:24:15'),(1764,'1','303',1,'Retail Sale Id 1733',0.00,4020.00,720.00,4320.00,300.00,'2023-02-12 10:42:14'),(1765,'1','303',1,'Retail Sale Id 1734',0.00,4020.00,720.00,4320.00,300.00,'2023-02-12 10:43:20'),(1766,'1','303',1,'Retail Sale Id 1735',0.00,4690.00,720.00,5040.00,350.00,'2023-02-12 10:48:27'),(1767,'1','303',1,'Retail Sale Id 1736',0.00,931.30,720.00,1000.80,69.50,'2023-02-12 11:10:39'),(1768,'1','303',1,'Retail Sale Id 1737',0.00,4020.00,720.00,4320.00,300.00,'2023-02-12 11:20:26'),(1769,'1','303',1,'Retail Sale Id 1738',0.00,3350.00,720.00,3600.00,250.00,'2023-02-12 11:21:47'),(1770,'1','303',1,'Retail Sale Id 1739',0.00,2010.00,720.00,2160.00,150.00,'2023-02-12 11:29:40'),(1771,'1','303',1,'Retail Sale Id 1740',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-12 11:43:14'),(1772,'1','303',1,'Retail Sale Id 1741',0.00,1393.60,720.00,1497.60,104.00,'2023-02-12 11:44:33'),(1773,'1','303',1,'Retail Sale Id 1742',0.00,1862.60,720.00,2001.60,139.00,'2023-02-12 11:46:01'),(1774,'1','303',1,'Retail Sale Id 1743',0.00,931.30,720.00,1000.80,69.50,'2023-02-12 11:52:42'),(1775,'1','303',1,'Retail Sale Id 1744',0.00,2010.00,720.00,2160.00,150.00,'2023-02-12 11:55:40'),(1776,'1','303',1,'Retail Sale Id 1745',0.00,4020.00,720.00,4320.00,300.00,'2023-02-12 12:00:21'),(1777,'1','303',1,'Retail Sale Id 1746',0.00,4187.50,720.00,4500.00,312.50,'2023-02-12 12:05:58'),(1778,'1','303',1,'Retail Sale Id 1747',0.00,8375.00,720.00,9000.00,625.00,'2023-02-12 12:08:34'),(1779,'1','303',1,'Retail Sale Id 1748',0.00,5306.40,720.00,5702.40,396.00,'2023-02-12 12:13:21'),(1780,'1','303',1,'Retail Sale Id 1749',0.00,4187.50,720.00,4500.00,312.50,'2023-02-12 12:17:52'),(1781,'1','303',1,'Retail Sale Id 1751',0.00,3350.00,720.00,3600.00,250.00,'2023-02-12 12:51:57'),(1782,'1','303',1,'Retail Sale Id 1752',0.00,8375.00,720.00,9000.00,625.00,'2023-02-12 12:52:48'),(1783,'1','303',1,'Retail Sale Id 1753',0.00,4020.00,720.00,4320.00,300.00,'2023-02-12 12:56:25'),(1784,'1','303',1,'Retail Sale Id 1754',0.00,29145.00,720.00,31320.00,2175.00,'2023-02-12 13:00:36'),(1785,'1','303',1,'Retail Sale Id 1755',0.00,1393.60,720.00,1497.60,104.00,'2023-02-12 13:12:04'),(1786,'1','303',1,'Retail Sale Id 1755',0.00,1393.60,720.00,1497.60,104.00,'2023-02-12 13:12:04'),(1787,'1','303',1,'Retail Sale Id 1756',0.00,8375.00,720.00,9000.00,625.00,'2023-02-12 13:13:31'),(1788,'1','303',1,'Retail Sale Id 1757',0.00,1862.60,720.00,2001.60,139.00,'2023-02-12 13:23:03'),(1789,'1','303',1,'Retail Sale Id 1758',0.00,3350.00,720.00,3600.00,250.00,'2023-02-12 14:03:16'),(1790,'1','303',1,'Retail Sale Id 1759',0.00,4020.00,720.00,4320.00,300.00,'2023-02-12 14:05:43'),(1791,'1','303',1,'Retail Sale Id 1760',0.00,6700.00,720.00,7200.00,500.00,'2023-02-12 14:21:24'),(1792,'1','303',1,'Retail Sale Id 1761',0.00,931.30,720.00,1000.80,69.50,'2023-02-12 14:55:34'),(1793,'1','303',1,'Retail Sale Id 1762',0.00,2010.00,720.00,2160.00,150.00,'2023-02-12 14:58:34'),(1794,'1','303',1,'Retail Sale Id 1763',0.00,2793.90,720.00,3002.40,208.50,'2023-02-12 15:00:04'),(1795,'1','303',1,'Retail Sale Id 1764',0.00,931.30,720.00,1000.80,69.50,'2023-02-12 15:07:16'),(1796,'1','303',1,'Retail Sale Id 1765',0.00,2003.30,720.00,2152.80,149.50,'2023-02-12 15:09:51'),(1797,'1','303',1,'Retail Sale Id 1766',0.00,4690.00,720.00,5040.00,350.00,'2023-02-12 15:12:17'),(1798,'1','303',1,'Retail Sale Id 1767',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-12 15:19:29'),(1799,'1','303',1,'Retail Sale Id 1768',0.00,6700.00,720.00,7200.00,500.00,'2023-02-12 15:20:55'),(1800,'1','303',1,'Retail Sale Id 1769',0.00,8375.00,720.00,9000.00,625.00,'2023-02-12 15:36:19'),(1801,'1','303',1,'Retail Sale Id 1770',0.00,2680.00,720.00,2880.00,200.00,'2023-02-12 16:12:01'),(1802,'1','303',1,'Retail Sale Id 1771',0.00,1862.60,720.00,2001.60,139.00,'2023-02-12 16:13:46'),(1803,'1','303',1,'Retail Sale Id 1772',0.00,2010.00,720.00,2160.00,150.00,'2023-02-12 16:15:51'),(1804,'1','303',1,'Retail Sale Id 1773',0.00,3350.00,720.00,3600.00,250.00,'2023-02-12 16:23:05'),(1805,'1','303',1,'Return of Retail Sale Id 1748',5306.40,0.00,720.00,-5702.40,-396.00,'2023-02-12 16:33:53'),(1806,'1','303',1,'Retail Sale Id 1774',0.00,2793.90,720.00,3002.40,208.50,'2023-02-12 16:37:46'),(1807,'1','303',1,'Retail Sale Id 1775',0.00,100500.00,690.00,103500.00,3000.00,'2023-02-12 16:53:14'),(1808,'1','303',1,'Retail Sale Id 1776',0.00,2010.00,720.00,2160.00,150.00,'2023-02-12 17:03:40'),(1809,'1','303',1,'Retail Sale Id 1776',0.00,4020.00,720.00,4320.00,300.00,'2023-02-12 17:03:40'),(1810,'1','303',1,'Retail Sale Id 1777',0.00,8375.00,720.00,9000.00,625.00,'2023-02-12 17:06:07'),(1811,'1','303',1,'Retail Sale Id 1778',0.00,4020.00,720.00,4320.00,300.00,'2023-02-12 17:07:10'),(1812,'1','303',1,'Retail Sale Id 1779',0.00,2010.00,720.00,2160.00,150.00,'2023-02-12 17:08:26'),(1813,'1','303',1,'Retail Sale Id 1780',0.00,3350.00,720.00,3600.00,250.00,'2023-02-12 17:27:43'),(1814,'1','303',1,'Retail Sale Id 1781',0.00,1862.60,720.00,2001.60,139.00,'2023-02-12 17:37:36'),(1815,'1','303',1,'Retail Sale Id 1782',0.00,2010.00,720.00,2160.00,150.00,'2023-02-12 17:40:59'),(1816,'1','303',1,'Retail Sale Id 1783',0.00,1862.60,720.00,2001.60,139.00,'2023-02-12 17:45:09'),(1817,'1','303',1,'Retail Sale Id 1784',0.00,4020.00,720.00,4320.00,300.00,'2023-02-12 17:48:15'),(1818,'1','303',1,'Retail Sale Id 1785',0.00,4020.00,720.00,4320.00,300.00,'2023-02-12 17:55:24'),(1819,'1','303',1,'Retail Sale Id 1786',0.00,2010.00,720.00,2160.00,150.00,'2023-02-12 17:57:22'),(1820,'1','303',1,'Retail Sale Id 1787',0.00,4020.00,720.00,4320.00,300.00,'2023-02-12 17:59:00'),(1821,'1','303',1,'Retail Sale Id 1788',0.00,3350.00,720.00,3600.00,250.00,'2023-02-12 18:01:52'),(1822,'1','303',1,'Retail Sale Id 1789',0.00,3350.00,720.00,3600.00,250.00,'2023-02-12 18:08:54'),(1823,'1','303',1,'Return of Retail Sale Id 1764',931.30,0.00,720.00,-1000.80,-69.50,'2023-02-12 19:38:27'),(1824,'1','303',1,'Retail Sale Id 1790',0.00,448.90,720.00,482.40,33.50,'2023-02-12 19:39:24'),(1825,'1','303',1,'Retail Sale Id 1791',0.00,26.80,720.00,28.80,2.00,'2023-02-12 19:41:56'),(1826,'1','303',1,'Retail Sale Id 1792',0.00,268000.00,690.00,276000.00,8000.00,'2023-02-12 19:57:06'),(1827,'1','303',1,'Retail Sale Id 1794',0.00,2010.00,720.00,2160.00,150.00,'2023-02-13 08:13:28'),(1828,'1','303',1,'Retail Sale Id 1795',0.00,4020.00,720.00,4320.00,300.00,'2023-02-13 08:14:17'),(1829,'1','303',1,'Retail Sale Id 1796',0.00,2010.00,720.00,2160.00,150.00,'2023-02-13 08:26:51'),(1830,'1','303',1,'Retail Sale Id 1798',0.00,4020.00,720.00,4320.00,300.00,'2023-02-13 08:30:30'),(1831,'1','303',1,'Retail Sale Id 1799',0.00,2324.90,720.00,2498.40,173.50,'2023-02-13 08:36:25'),(1832,'1','303',1,'Retail Sale Id 1800',0.00,4020.00,720.00,4320.00,300.00,'2023-02-13 10:39:33'),(1833,'1','303',1,'Retail Sale Id 1801',0.00,4020.00,720.00,4320.00,300.00,'2023-02-13 10:40:25'),(1834,'1','303',1,'Retail Sale Id 1802',0.00,1393.60,720.00,1497.60,104.00,'2023-02-13 10:41:09'),(1835,'1','303',1,'Retail Sale Id 1803',0.00,4020.00,720.00,4320.00,300.00,'2023-02-13 10:41:48'),(1836,'1','303',1,'Retail Sale Id 1804',0.00,2680.00,720.00,2880.00,200.00,'2023-02-13 10:42:21'),(1837,'1','303',1,'Retail Sale Id 1805',0.00,4020.00,720.00,4320.00,300.00,'2023-02-13 10:42:55'),(1838,'1','303',1,'Retail Sale Id 1806',0.00,4020.00,720.00,4320.00,300.00,'2023-02-13 10:43:35'),(1839,'1','303',1,'Retail Sale Id 1808',0.00,2010.00,720.00,2160.00,150.00,'2023-02-13 10:44:47'),(1840,'1','303',1,'Retail Sale Id 1809',0.00,8375.00,720.00,9000.00,625.00,'2023-02-13 10:45:40'),(1841,'1','303',1,'Retail Sale Id 1810',0.00,4020.00,720.00,4320.00,300.00,'2023-02-13 10:46:28'),(1842,'1','303',1,'Retail Sale Id 1811',0.00,2010.00,720.00,2160.00,150.00,'2023-02-13 10:47:19'),(1843,'1','303',1,'Retail Sale Id 1812',0.00,1862.60,720.00,2001.60,139.00,'2023-02-13 10:47:55'),(1844,'1','303',1,'Retail Sale Id 1813',0.00,1862.60,720.00,2001.60,139.00,'2023-02-13 10:48:36'),(1845,'1','303',1,'Retail Sale Id 1814',0.00,2010.00,720.00,2160.00,150.00,'2023-02-13 10:49:27'),(1846,'1','303',1,'Retail Sale Id 1815',0.00,1862.60,720.00,2001.60,139.00,'2023-02-13 10:50:07'),(1847,'1','303',1,'Retail Sale Id 1816',0.00,4020.00,720.00,4320.00,300.00,'2023-02-13 10:54:24'),(1848,'1','303',1,'Retail Sale Id 1817',0.00,4020.00,720.00,4320.00,300.00,'2023-02-13 11:08:02'),(1849,'1','303',1,'Retail Sale Id 1818',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-13 11:28:17'),(1850,'1','303',1,'Retail Sale Id 1819',0.00,1118.90,720.00,1202.40,83.50,'2023-02-13 11:30:33'),(1851,'1','303',1,'Retail Sale Id 1821',0.00,2793.90,720.00,3002.40,208.50,'2023-02-13 11:35:00'),(1852,'1','303',1,'Retail Sale Id 1822',0.00,2010.00,720.00,2160.00,150.00,'2023-02-13 11:48:28'),(1853,'1','303',1,'Retail Sale Id 1823',0.00,38860.00,690.00,40020.00,1160.00,'2023-02-13 11:51:03'),(1854,'1','303',1,'Retail Sale Id 1824',0.00,2010.00,720.00,2160.00,150.00,'2023-02-13 11:51:47'),(1855,'1','303',1,'Retail Sale Id 1825',0.00,4046.80,720.00,4348.80,302.00,'2023-02-13 11:56:14'),(1856,'1','303',1,'Retail Sale Id 1826',0.00,4046.80,720.00,4348.80,302.00,'2023-02-13 12:03:37'),(1857,'1','303',1,'Retail Sale Id 1827',0.00,6700.00,720.00,7200.00,500.00,'2023-02-13 12:09:24'),(1858,'1','303',1,'Retail Sale Id 1828',0.00,2010.00,720.00,2160.00,150.00,'2023-02-13 12:13:53'),(1859,'1','303',1,'Retail Sale Id 1829',0.00,2010.00,720.00,2160.00,150.00,'2023-02-13 12:27:47'),(1860,'1','303',1,'Retail Sale Id 1830',0.00,2793.90,720.00,3002.40,208.50,'2023-02-13 12:32:12'),(1861,'1','303',1,'Retail Sale Id 1831',0.00,2010.00,720.00,2160.00,150.00,'2023-02-13 12:39:03'),(1862,'1','303',1,'Retail Sale Id 1832',0.00,931.30,720.00,1000.80,69.50,'2023-02-13 12:44:08'),(1863,'1','303',1,'Retail Sale Id 1833',0.00,8375.00,720.00,9000.00,625.00,'2023-02-13 12:46:45'),(1864,'1','303',1,'Retail Sale Id 1834',0.00,2680.00,720.00,2880.00,200.00,'2023-02-13 12:48:56'),(1865,'1','303',1,'Retail Sale Id 1835',0.00,6700.00,720.00,7200.00,500.00,'2023-02-13 12:54:33'),(1866,'1','303',1,'Retail Sale Id 1836',0.00,1862.60,720.00,2001.60,139.00,'2023-02-13 12:55:49'),(1867,'1','303',1,'Retail Sale Id 1837',0.00,2793.90,720.00,3002.40,208.50,'2023-02-13 12:56:51'),(1868,'1','303',1,'Retail Sale Id 1838',0.00,4020.00,720.00,4320.00,300.00,'2023-02-13 12:58:38'),(1869,'1','303',1,'Retail Sale Id 1839',0.00,2680.00,720.00,2880.00,200.00,'2023-02-13 13:01:20'),(1870,'1','303',1,'Retail Sale Id 1840',0.00,4187.50,720.00,4500.00,312.50,'2023-02-13 13:02:40'),(1871,'1','303',1,'Retail Sale Id 1841',0.00,2010.00,720.00,2160.00,150.00,'2023-02-13 13:09:10'),(1872,'1','303',1,'Retail Sale Id 1842',0.00,8375.00,720.00,9000.00,625.00,'2023-02-13 13:33:11'),(1873,'1','303',1,'Retail Sale Id 1843',0.00,4020.00,720.00,4320.00,300.00,'2023-02-13 13:40:01'),(1874,'1','303',1,'Retail Sale Id 1844',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-13 13:47:39'),(1875,'1','303',1,'Retail Sale Id 1845',0.00,3350.00,720.00,3600.00,250.00,'2023-02-13 14:15:49'),(1876,'1','303',1,'Retail Sale Id 1846',0.00,69010.00,690.00,71070.00,2060.00,'2023-02-13 14:19:40'),(1877,'1','303',1,'Retail Sale Id 1847',0.00,1393.60,720.00,1497.60,104.00,'2023-02-13 14:20:19'),(1878,'1','303',1,'Retail Sale Id 1848',0.00,1862.60,720.00,2001.60,139.00,'2023-02-13 14:37:37'),(1879,'1','303',1,'Retail Sale Id 1849',0.00,1340.00,720.00,1440.00,100.00,'2023-02-13 15:35:29'),(1880,'1','303',1,'Retail Sale Id 1851',0.00,4020.00,720.00,4320.00,300.00,'2023-02-13 16:08:45'),(1881,'1','303',1,'Retail Sale Id 1852',0.00,3350.00,720.00,3600.00,250.00,'2023-02-13 16:09:58'),(1882,'1','303',1,'Retail Sale Id 1853',0.00,931.30,720.00,1000.80,69.50,'2023-02-13 16:10:55'),(1883,'1','303',1,'Retail Sale Id 1854',0.00,25460.00,690.00,26220.00,760.00,'2023-02-13 16:16:53'),(1884,'1','303',1,'Retail Sale Id 1855',0.00,8375.00,720.00,9000.00,625.00,'2023-02-13 16:20:14'),(1885,'1','303',1,'Retail Sale Id 1857',0.00,2050.20,720.00,2203.20,153.00,'2023-02-13 16:31:51'),(1886,'1','303',1,'Retail Sale Id 1858',0.00,3350.00,720.00,3600.00,250.00,'2023-02-13 16:33:28'),(1887,'1','303',1,'Retail Sale Id 1859',0.00,2010.00,720.00,2160.00,150.00,'2023-02-13 16:34:28'),(1888,'1','303',1,'Retail Sale Id 1860',0.00,4020.00,720.00,4320.00,300.00,'2023-02-13 16:39:07'),(1889,'1','303',1,'Retail Sale Id 1861',0.00,8375.00,720.00,9000.00,625.00,'2023-02-13 16:41:06'),(1890,'1','303',1,'Retail Sale Id 1862',0.00,8375.00,720.00,9000.00,625.00,'2023-02-13 16:42:44'),(1891,'1','303',1,'Retail Sale Id 1863',0.00,4020.00,720.00,4320.00,300.00,'2023-02-13 16:47:21'),(1892,'1','303',1,'Retail Sale Id 1864',0.00,931.30,720.00,1000.80,69.50,'2023-02-13 16:49:55'),(1893,'1','303',1,'Retail Sale Id 1865',0.00,2680.00,720.00,2880.00,200.00,'2023-02-13 17:06:36'),(1894,'1','303',1,'Retail Sale Id 1866',0.00,1862.60,720.00,2001.60,139.00,'2023-02-13 17:10:19'),(1895,'1','303',1,'Retail Sale Id 1867',0.00,67000.00,690.00,69000.00,2000.00,'2023-02-13 17:15:17'),(1896,'1','303',1,'Retail Sale Id 1868',0.00,4020.00,720.00,4320.00,300.00,'2023-02-13 17:22:22'),(1897,'1','303',1,'Retail Sale Id 1869',0.00,2010.00,720.00,2160.00,150.00,'2023-02-13 17:34:08'),(1898,'1','303',1,'Retail Sale Id 1870',0.00,3350.00,720.00,3600.00,250.00,'2023-02-13 17:36:31'),(1899,'1','303',1,'Retail Sale Id 1871',0.00,1340.00,720.00,1440.00,100.00,'2023-02-13 17:38:22'),(1900,'1','303',1,'Retail Sale Id 1872',0.00,4020.00,720.00,4320.00,300.00,'2023-02-13 17:45:18'),(1901,'1','303',1,'Retail Sale Id 1873',0.00,6700.00,720.00,7200.00,500.00,'2023-02-13 18:05:03'),(1902,'1','303',1,'Retail Sale Id 1874',0.00,4649.80,720.00,4996.80,347.00,'2023-02-13 18:09:04'),(1903,'1','303',1,'Retail Sale Id 1875',0.00,931.30,720.00,1000.80,69.50,'2023-02-13 18:10:35'),(1904,'1','303',1,'Retail Sale Id 1876',0.00,13.40,720.00,14.40,1.00,'2023-02-13 19:26:27'),(1905,'1','303',1,'Retail Sale Id 1877',0.00,3350.00,720.00,3600.00,250.00,'2023-02-14 08:16:32'),(1906,'1','303',1,'Retail Sale Id 1878',0.00,4020.00,720.00,4320.00,300.00,'2023-02-14 08:20:47'),(1907,'1','303',1,'Retail Sale Id 1879',0.00,9306.30,720.00,10000.80,694.50,'2023-02-14 08:23:33'),(1908,'1','303',1,'Retail Sale Id 1880',0.00,67000.00,690.00,69000.00,2000.00,'2023-02-14 09:12:20'),(1909,'1','303',1,'Retail Sale Id 1881',0.00,4649.80,720.00,4996.80,347.00,'2023-02-14 09:30:54'),(1910,'1','303',1,'Retail Sale Id 1881',0.00,4649.80,720.00,4996.80,347.00,'2023-02-14 09:30:54'),(1911,'1','303',1,'Retail Sale Id 1883',0.00,4020.00,720.00,4320.00,300.00,'2023-02-14 09:48:14'),(1912,'1','303',1,'Retail Sale Id 1883',0.00,8375.00,720.00,9000.00,625.00,'2023-02-14 09:48:14'),(1913,'1','303',1,'Retail Sale Id 1884',0.00,1118.90,720.00,1202.40,83.50,'2023-02-14 09:51:34'),(1914,'1','303',1,'Retail Sale Id 1885',0.00,4020.00,720.00,4320.00,300.00,'2023-02-14 10:03:14'),(1915,'1','303',1,'Retail Sale Id 1887',0.00,1862.60,720.00,2001.60,139.00,'2023-02-14 10:37:27'),(1916,'1','303',1,'Retail Sale Id 1888',0.00,4020.00,720.00,4320.00,300.00,'2023-02-14 11:53:49'),(1917,'1','303',1,'Retail Sale Id 1889',0.00,931.30,720.00,1000.80,69.50,'2023-02-14 11:55:05'),(1918,'1','303',1,'Retail Sale Id 1890',0.00,4020.00,720.00,4320.00,300.00,'2023-02-14 12:02:10'),(1919,'1','303',1,'Retail Sale Id 1891',0.00,4020.00,720.00,4320.00,300.00,'2023-02-14 12:17:30'),(1920,'1','303',1,'Retail Sale Id 1892',0.00,1393.60,720.00,1497.60,104.00,'2023-02-14 12:25:45'),(1921,'1','303',1,'Retail Sale Id 1893',0.00,4020.00,720.00,4320.00,300.00,'2023-02-14 12:35:30'),(1922,'1','303',1,'Retail Sale Id 1894',0.00,4020.00,720.00,4320.00,300.00,'2023-02-14 12:47:28'),(1923,'1','303',1,'Retail Sale Id 1894',0.00,6700.00,720.00,7200.00,500.00,'2023-02-14 12:47:28'),(1924,'1','303',1,'Retail Sale Id 1895',0.00,931.30,720.00,1000.80,69.50,'2023-02-14 12:58:43'),(1925,'1','303',1,'Retail Sale Id 1896',0.00,4020.00,720.00,4320.00,300.00,'2023-02-14 13:29:06'),(1926,'1','303',1,'Retail Sale Id 1897',0.00,4020.00,720.00,4320.00,300.00,'2023-02-14 13:39:39'),(1927,'1','303',1,'Retail Sale Id 1898',0.00,2010.00,720.00,2160.00,150.00,'2023-02-14 13:42:06'),(1928,'1','303',1,'Retail Sale Id 1899',0.00,3350.00,720.00,3600.00,250.00,'2023-02-14 13:43:49'),(1929,'1','303',1,'Retail Sale Id 1900',0.00,2010.00,720.00,2160.00,150.00,'2023-02-14 14:23:54'),(1930,'1','303',1,'Retail Sale Id 1901',0.00,4020.00,720.00,4320.00,300.00,'2023-02-14 14:28:18'),(1931,'1','303',1,'Retail Sale Id 1902',0.00,2324.90,720.00,2498.40,173.50,'2023-02-14 14:29:20'),(1932,'1','303',1,'Retail Sale Id 1903',0.00,931.30,720.00,1000.80,69.50,'2023-02-14 14:32:24'),(1933,'1','303',1,'Retail Sale Id 1903',0.00,4020.00,720.00,4320.00,300.00,'2023-02-14 14:32:24'),(1934,'1','303',1,'Retail Sale Id 1904',0.00,3350.00,720.00,3600.00,250.00,'2023-02-14 14:35:48'),(1935,'1','303',1,'Retail Sale Id 1905',0.00,4020.00,720.00,4320.00,300.00,'2023-02-14 14:59:13'),(1936,'1','303',1,'Retail Sale Id 1906',0.00,4020.00,720.00,4320.00,300.00,'2023-02-14 15:18:18'),(1937,'1','303',1,'Retail Sale Id 1907',0.00,3725.20,720.00,4003.20,278.00,'2023-02-14 15:19:21'),(1938,'1','303',1,'Retail Sale Id 1908',0.00,4020.00,720.00,4320.00,300.00,'2023-02-14 15:25:42'),(1939,'1','303',1,'Retail Sale Id 1909',0.00,8375.00,720.00,9000.00,625.00,'2023-02-14 15:35:17'),(1940,'1','303',1,'Retail Sale Id 1910',0.00,2010.00,720.00,2160.00,150.00,'2023-02-14 16:08:24'),(1941,'1','303',1,'Retail Sale Id 1911',0.00,1862.60,720.00,2001.60,139.00,'2023-02-14 16:58:10'),(1942,'1','303',1,'Retail Sale Id 1912',0.00,2793.90,720.00,3002.40,208.50,'2023-02-14 17:02:31'),(1943,'1','303',1,'Retail Sale Id 1913',0.00,2010.00,720.00,2160.00,150.00,'2023-02-14 17:13:42'),(1944,'1','303',1,'Retail Sale Id 1914',0.00,1340.00,720.00,1440.00,100.00,'2023-02-14 17:18:28'),(1945,'1','303',1,'Retail Sale Id 1915',0.00,1118.90,720.00,1202.40,83.50,'2023-02-14 17:21:16'),(1946,'1','303',1,'Retail Sale Id 1917',0.00,1862.60,720.00,2001.60,139.00,'2023-02-14 17:26:40'),(1947,'1','303',1,'Retail Sale Id 1918',0.00,2793.90,720.00,3002.40,208.50,'2023-02-14 17:29:32'),(1948,'1','303',1,'Retail Sale Id 1919',0.00,931.30,720.00,1000.80,69.50,'2023-02-14 17:34:53'),(1949,'1','303',1,'Retail Sale Id 1921',0.00,649.90,720.00,698.40,48.50,'2023-02-14 17:38:45'),(1950,'1','303',1,'Retail Sale Id 1922',0.00,2010.00,720.00,2160.00,150.00,'2023-02-14 17:45:56'),(1951,'1','303',1,'Retail Sale Id 1922',0.00,4020.00,720.00,4320.00,300.00,'2023-02-14 17:45:56'),(1952,'1','303',1,'Retail Sale Id 1922',0.00,8375.00,720.00,9000.00,625.00,'2023-02-14 17:45:56'),(1953,'1','303',1,'Retail Sale Id 1923',0.00,2050.20,720.00,2203.20,153.00,'2023-02-14 18:15:40'),(1954,'1','303',1,'Return of Retail Sale Id 1918',2793.90,0.00,720.00,-3002.40,-208.50,'2023-02-14 19:13:34'),(1955,'1','303',1,'Return of Retail Sale Id 1919',931.30,0.00,720.00,-1000.80,-69.50,'2023-02-14 19:15:11'),(1956,'1','303',1,'Return of Retail Sale Id 1921',649.90,0.00,720.00,-698.40,-48.50,'2023-02-14 19:20:14'),(1957,'1','303',1,'Retail Sale Id 1924',0.00,328.30,720.00,352.80,24.50,'2023-02-14 19:21:25'),(1958,'1','303',1,'Retail Sale Id 1925',0.00,1862.60,720.00,2001.60,139.00,'2023-02-15 08:12:27'),(1959,'1','303',1,'Retail Sale Id 1926',0.00,3350.00,720.00,3600.00,250.00,'2023-02-15 08:47:59'),(1960,'1','303',1,'Retail Sale Id 1927',0.00,8375.00,720.00,9000.00,625.00,'2023-02-15 08:49:43'),(1961,'1','303',1,'Retail Sale Id 1928',0.00,4020.00,720.00,4320.00,300.00,'2023-02-15 08:51:52'),(1962,'1','303',1,'Retail Sale Id 1929',0.00,2793.90,720.00,3002.40,208.50,'2023-02-15 09:00:48'),(1963,'1','303',1,'Retail Sale Id 1930',0.00,4020.00,720.00,4320.00,300.00,'2023-02-15 09:22:50'),(1964,'1','303',1,'Retail Sale Id 1931',0.00,4020.00,720.00,4320.00,300.00,'2023-02-15 09:25:09'),(1965,'1','303',1,'Retail Sale Id 1932',0.00,4020.00,720.00,4320.00,300.00,'2023-02-15 09:38:40'),(1966,'1','303',1,'Retail Sale Id 1933',0.00,931.30,720.00,1000.80,69.50,'2023-02-15 09:52:22'),(1967,'1','303',1,'Retail Sale Id 1934',0.00,8375.00,720.00,9000.00,625.00,'2023-02-15 09:55:38'),(1968,'1','303',1,'Retail Sale Id 1935',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-15 10:00:35'),(1969,'1','303',1,'Retail Sale Id 1936',0.00,4020.00,720.00,4320.00,300.00,'2023-02-15 10:15:23'),(1970,'1','303',1,'Retail Sale Id 1937',0.00,2010.00,720.00,2160.00,150.00,'2023-02-15 10:17:49'),(1971,'1','303',1,'Retail Sale Id 1938',0.00,4020.00,720.00,4320.00,300.00,'2023-02-15 10:20:08'),(1972,'1','303',1,'Retail Sale Id 1939',0.00,2010.00,720.00,2160.00,150.00,'2023-02-15 11:01:15'),(1973,'1','303',1,'Retail Sale Id 1940',0.00,2010.00,720.00,2160.00,150.00,'2023-02-15 11:06:32'),(1974,'1','303',1,'Retail Sale Id 1941',0.00,931.30,720.00,1000.80,69.50,'2023-02-15 11:13:18'),(1975,'1','303',1,'Retail Sale Id 1942',0.00,8375.00,720.00,9000.00,625.00,'2023-02-15 11:20:44'),(1976,'1','303',1,'Retail Sale Id 1943',0.00,4020.00,720.00,4320.00,300.00,'2023-02-15 11:22:27'),(1977,'1','303',1,'Retail Sale Id 1944',0.00,931.30,720.00,1000.80,69.50,'2023-02-15 11:26:54'),(1978,'1','303',1,'Retail Sale Id 1945',0.00,67000.00,690.00,69000.00,2000.00,'2023-02-15 11:32:28'),(1979,'1','303',1,'Retail Sale Id 1946',0.00,1393.60,720.00,1497.60,104.00,'2023-02-15 11:52:13'),(1980,'1','303',1,'Retail Sale Id 1947',0.00,4020.00,720.00,4320.00,300.00,'2023-02-15 11:56:10'),(1981,'1','303',1,'Retail Sale Id 1948',0.00,4020.00,720.00,4320.00,300.00,'2023-02-15 12:14:41'),(1982,'1','303',1,'Retail Sale Id 1949',0.00,4649.80,720.00,4996.80,347.00,'2023-02-15 12:18:57'),(1983,'1','303',1,'Retail Sale Id 1950',0.00,4649.80,720.00,4996.80,347.00,'2023-02-15 12:20:16'),(1984,'1','303',1,'Retail Sale Id 1951',0.00,3350.00,720.00,3600.00,250.00,'2023-02-15 12:30:41'),(1985,'1','303',1,'Retail Sale Id 1952',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-15 12:46:02'),(1986,'1','303',1,'Retail Sale Id 1953',0.00,4020.00,720.00,4320.00,300.00,'2023-02-15 13:27:42'),(1987,'1','303',1,'Retail Sale Id 1954',0.00,8375.00,720.00,9000.00,625.00,'2023-02-15 13:31:03'),(1988,'1','303',1,'Retail Sale Id 1955',0.00,931.30,720.00,1000.80,69.50,'2023-02-15 13:49:38'),(1989,'1','303',1,'Retail Sale Id 1956',0.00,2010.00,720.00,2160.00,150.00,'2023-02-15 13:53:26'),(1990,'1','303',1,'Retail Sale Id 1956',0.00,4020.00,720.00,4320.00,300.00,'2023-02-15 13:53:26'),(1991,'1','303',1,'Retail Sale Id 1957',0.00,4020.00,720.00,4320.00,300.00,'2023-02-15 13:55:17'),(1992,'1','303',1,'Retail Sale Id 1958',0.00,1393.60,720.00,1497.60,104.00,'2023-02-15 14:20:53'),(1993,'1','303',1,'Retail Sale Id 1959',0.00,1393.60,720.00,1497.60,104.00,'2023-02-15 14:35:01'),(1994,'1','303',1,'Retail Sale Id 1960',0.00,4020.00,720.00,4320.00,300.00,'2023-02-15 14:48:46'),(1995,'1','303',1,'Retail Sale Id 1961',0.00,1862.60,720.00,2001.60,139.00,'2023-02-15 14:52:48'),(1996,'1','303',1,'Retail Sale Id 1962',0.00,4020.00,720.00,4320.00,300.00,'2023-02-15 14:54:13'),(1997,'1','303',1,'Retail Sale Id 1964',0.00,8375.00,720.00,9000.00,625.00,'2023-02-15 15:11:58'),(1998,'1','303',1,'Retail Sale Id 1965',0.00,8040.00,720.00,8640.00,600.00,'2023-02-15 15:22:31'),(1999,'1','303',1,'Retail Sale Id 1966',0.00,6700.00,720.00,7200.00,500.00,'2023-02-15 15:24:39'),(2000,'1','303',1,'Retail Sale Id 1967',0.00,670.00,720.00,720.00,50.00,'2023-02-15 15:58:37'),(2001,'1','303',1,'Retail Sale Id 1968',0.00,8375.00,720.00,9000.00,625.00,'2023-02-15 16:14:06'),(2002,'1','303',1,'Retail Sale Id 1969',0.00,1675.00,720.00,1800.00,125.00,'2023-02-15 16:27:06'),(2003,'1','303',1,'Retail Sale Id 1970',0.00,2050.20,720.00,2203.20,153.00,'2023-02-15 16:31:20'),(2004,'1','303',1,'Retail Sale Id 1971',0.00,8375.00,720.00,9000.00,625.00,'2023-02-15 16:32:23'),(2005,'1','303',1,'Retail Sale Id 1972',0.00,670.00,720.00,720.00,50.00,'2023-02-15 16:36:35'),(2006,'1','303',1,'Retail Sale Id 1973',0.00,3350.00,720.00,3600.00,250.00,'2023-02-15 16:48:04'),(2007,'1','303',1,'Retail Sale Id 1974',0.00,1393.60,720.00,1497.60,104.00,'2023-02-15 17:22:00'),(2008,'1','303',1,'Retail Sale Id 1975',0.00,1393.60,720.00,1497.60,104.00,'2023-02-15 17:24:26'),(2009,'1','303',1,'Retail Sale Id 1976',0.00,2680.00,720.00,2880.00,200.00,'2023-02-15 17:25:39'),(2010,'1','303',1,'Retail Sale Id 1977',0.00,2050.20,720.00,2203.20,153.00,'2023-02-15 17:31:51'),(2011,'1','303',1,'Retail Sale Id 1978',0.00,2010.00,720.00,2160.00,150.00,'2023-02-15 17:48:35'),(2012,'1','303',1,'Retail Sale Id 1979',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 08:33:13'),(2013,'1','303',1,'Retail Sale Id 1980',0.00,67000.00,690.00,69000.00,2000.00,'2023-02-16 08:38:20'),(2014,'1','303',1,'Retail Sale Id 1981',0.00,3350.00,720.00,3600.00,250.00,'2023-02-16 08:40:05'),(2015,'1','303',1,'Retail Sale Id 1982',0.00,931.30,720.00,1000.80,69.50,'2023-02-16 09:16:26'),(2016,'1','303',1,'Retail Sale Id 1983',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 09:39:41'),(2017,'1','303',1,'Retail Sale Id 1984',0.00,2010.00,720.00,2160.00,150.00,'2023-02-16 09:42:09'),(2018,'1','303',1,'Retail Sale Id 1985',0.00,2016.70,720.00,2167.20,150.50,'2023-02-16 10:00:52'),(2019,'1','303',1,'Retail Sale Id 1986',0.00,3350.00,720.00,3600.00,250.00,'2023-02-16 10:23:42'),(2020,'1','303',1,'Retail Sale Id 1987',0.00,743.70,720.00,799.20,55.50,'2023-02-16 10:36:25'),(2021,'1','303',1,'Retail Sale Id 1988',0.00,8375.00,720.00,9000.00,625.00,'2023-02-16 10:53:37'),(2022,'1','303',1,'Retail Sale Id 1989',0.00,2010.00,720.00,2160.00,150.00,'2023-02-16 11:06:41'),(2023,'1','303',1,'Retail Sale Id 1990',0.00,2010.00,720.00,2160.00,150.00,'2023-02-16 11:18:26'),(2024,'1','303',1,'Retail Sale Id 1991',0.00,2010.00,720.00,2160.00,150.00,'2023-02-16 11:27:30'),(2025,'1','303',1,'Retail Sale Id 1992',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 11:36:13'),(2026,'1','303',1,'Retail Sale Id 1993',0.00,16750.00,720.00,18000.00,1250.00,'2023-02-16 11:39:53'),(2027,'1','303',1,'Retail Sale Id 1994',0.00,1340.00,720.00,1440.00,100.00,'2023-02-16 11:42:44'),(2028,'1','303',1,'Retail Sale Id 1995',0.00,8375.00,720.00,9000.00,625.00,'2023-02-16 11:48:51'),(2029,'1','303',1,'Retail Sale Id 1996',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 12:00:44'),(2030,'1','303',1,'Retail Sale Id 1997',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 12:13:26'),(2031,'1','303',1,'Retail Sale Id 1998',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 12:14:51'),(2032,'1','303',1,'Retail Sale Id 1999',0.00,8375.00,720.00,9000.00,625.00,'2023-02-16 12:22:19'),(2033,'1','303',1,'Retail Sale Id 2000',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 12:39:04'),(2034,'1','303',1,'Retail Sale Id 2001',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 12:42:41'),(2035,'1','303',1,'Retail Sale Id 2002',0.00,4649.80,720.00,4996.80,347.00,'2023-02-16 13:01:07'),(2036,'1','303',1,'Retail Sale Id 2003',0.00,1393.60,720.00,1497.60,104.00,'2023-02-16 13:06:15'),(2037,'1','303',1,'Retail Sale Id 2004',0.00,6700.00,720.00,7200.00,500.00,'2023-02-16 13:18:56'),(2038,'1','303',1,'Retail Sale Id 2005',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 13:24:58'),(2039,'1','303',1,'Retail Sale Id 2006',0.00,8375.00,720.00,9000.00,625.00,'2023-02-16 13:38:18'),(2040,'1','303',1,'Retail Sale Id 2007',0.00,2010.00,720.00,2160.00,150.00,'2023-02-16 13:41:45'),(2041,'1','303',1,'Retail Sale Id 2008',0.00,2010.00,720.00,2160.00,150.00,'2023-02-16 13:43:42'),(2042,'1','303',1,'Retail Sale Id 2009',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 13:45:03'),(2043,'1','303',1,'Retail Sale Id 2010',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 13:46:57'),(2044,'1','303',1,'Retail Sale Id 2011',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 13:49:31'),(2045,'1','303',1,'Retail Sale Id 2012',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 14:05:46'),(2046,'1','303',1,'Retail Sale Id 2013',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 14:06:26'),(2047,'1','303',1,'Retail Sale Id 2014',0.00,8375.00,720.00,9000.00,625.00,'2023-02-16 14:26:36'),(2048,'1','303',1,'Retail Sale Id 2015',0.00,3350.00,720.00,3600.00,250.00,'2023-02-16 14:32:50'),(2049,'1','303',1,'Retail Sale Id 2016',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 14:39:18'),(2050,'1','303',1,'Retail Sale Id 2017',0.00,2010.00,720.00,2160.00,150.00,'2023-02-16 14:40:49'),(2051,'1','303',1,'Retail Sale Id 2018',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 14:44:35'),(2052,'1','303',1,'Retail Sale Id 2019',0.00,2010.00,720.00,2160.00,150.00,'2023-02-16 14:49:40'),(2053,'1','303',1,'Return of Retail Sale Id 2019',2010.00,0.00,720.00,-2160.00,-150.00,'2023-02-16 14:57:59'),(2054,'1','303',1,'Retail Sale Id 2020',0.00,1340.00,720.00,1440.00,100.00,'2023-02-16 14:59:10'),(2055,'1','303',1,'Retail Sale Id 2021',0.00,1862.60,720.00,2001.60,139.00,'2023-02-16 15:00:14'),(2056,'1','303',1,'Retail Sale Id 2022',0.00,1393.60,720.00,1497.60,104.00,'2023-02-16 15:26:34'),(2057,'1','303',1,'Retail Sale Id 2023',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 15:29:02'),(2058,'1','303',1,'Retail Sale Id 2024',0.00,8375.00,720.00,9000.00,625.00,'2023-02-16 15:30:27'),(2059,'1','303',1,'Retail Sale Id 2025',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 15:37:25'),(2060,'1','303',1,'Retail Sale Id 2026',0.00,1862.60,720.00,2001.60,139.00,'2023-02-16 15:42:46'),(2061,'1','303',1,'Retail Sale Id 2027',0.00,2793.90,720.00,3002.40,208.50,'2023-02-16 16:02:33'),(2062,'1','303',1,'Retail Sale Id 2028',0.00,2793.90,720.00,3002.40,208.50,'2023-02-16 16:17:29'),(2063,'1','303',1,'Retail Sale Id 2029',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 16:37:06'),(2064,'1','303',1,'Retail Sale Id 2030',0.00,1862.60,720.00,2001.60,139.00,'2023-02-16 16:40:35'),(2065,'1','303',1,'Retail Sale Id 2031',0.00,2010.00,720.00,2160.00,150.00,'2023-02-16 16:46:01'),(2066,'1','303',1,'Retail Sale Id 2034',0.00,8375.00,720.00,9000.00,625.00,'2023-02-16 16:51:01'),(2067,'1','303',1,'Retail Sale Id 2035',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 16:53:32'),(2068,'1','303',1,'Retail Sale Id 2035',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 16:53:32'),(2069,'1','303',1,'Retail Sale Id 2036',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 16:56:02'),(2070,'1','303',1,'Retail Sale Id 2037',0.00,4020.00,720.00,4320.00,300.00,'2023-02-16 17:05:32'),(2071,'1','303',1,'Retail Sale Id 2038',0.00,2680.00,720.00,2880.00,200.00,'2023-02-16 17:25:24'),(2072,'1','303',1,'Retail Sale Id 2039',0.00,8375.00,720.00,9000.00,625.00,'2023-02-16 17:59:34'),(2073,'1','303',1,'Retail Sale Id 2041',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-16 18:09:53'),(2074,'1','303',1,'Retail Sale Id 2042',0.00,8375.00,720.00,9000.00,625.00,'2023-02-17 08:20:20'),(2075,'1','303',1,'Retail Sale Id 2043',0.00,2010.00,720.00,2160.00,150.00,'2023-02-17 08:56:15'),(2076,'1','303',1,'Retail Sale Id 2044',0.00,1340.00,720.00,1440.00,100.00,'2023-02-17 09:18:18'),(2077,'1','303',1,'Retail Sale Id 2045',0.00,3350.00,720.00,3600.00,250.00,'2023-02-17 09:47:16'),(2078,'1','303',1,'Retail Sale Id 2046',0.00,2010.00,720.00,2160.00,150.00,'2023-02-17 09:48:07'),(2079,'1','303',1,'Retail Sale Id 2047',0.00,3350.00,720.00,3600.00,250.00,'2023-02-17 09:55:21'),(2080,'1','303',1,'Retail Sale Id 2048',0.00,2010.00,720.00,2160.00,150.00,'2023-02-17 10:36:48'),(2081,'1','303',1,'Retail Sale Id 2049',0.00,100500.00,690.00,103500.00,3000.00,'2023-02-17 10:48:16'),(2082,'1','303',1,'Retail Sale Id 2050',0.00,4020.00,720.00,4320.00,300.00,'2023-02-17 10:49:30'),(2083,'1','303',1,'Retail Sale Id 2051',0.00,2050.20,720.00,2203.20,153.00,'2023-02-17 10:50:42'),(2084,'1','303',1,'Retail Sale Id 2052',0.00,4020.00,720.00,4320.00,300.00,'2023-02-17 11:01:53'),(2085,'1','303',1,'Retail Sale Id 2053',0.00,3999.90,720.00,4298.40,298.50,'2023-02-17 11:32:06'),(2086,'1','303',1,'Retail Sale Id 2054',0.00,1393.60,720.00,1497.60,104.00,'2023-02-17 11:51:39'),(2087,'1','303',1,'Retail Sale Id 2055',0.00,8375.00,720.00,9000.00,625.00,'2023-02-17 11:55:31'),(2088,'1','303',1,'Retail Sale Id 2056',0.00,4020.00,720.00,4320.00,300.00,'2023-02-17 11:57:58'),(2089,'1','303',1,'Retail Sale Id 2057',0.00,2010.00,720.00,2160.00,150.00,'2023-02-17 12:16:48'),(2090,'1','303',1,'Retail Sale Id 2058',0.00,2010.00,720.00,2160.00,150.00,'2023-02-17 12:17:45'),(2091,'1','303',1,'Retail Sale Id 2059',0.00,931.30,720.00,1000.80,69.50,'2023-02-17 12:25:36'),(2092,'1','303',1,'Retail Sale Id 2060',0.00,1393.60,720.00,1497.60,104.00,'2023-02-17 12:27:43'),(2093,'1','303',1,'Retail Sale Id 2061',0.00,2050.20,720.00,2203.20,153.00,'2023-02-17 12:31:01'),(2094,'1','303',1,'Retail Sale Id 2062',0.00,2137.30,720.00,2296.80,159.50,'2023-02-17 12:38:52'),(2095,'1','303',1,'Retail Sale Id 2063',0.00,2010.00,720.00,2160.00,150.00,'2023-02-17 15:22:40'),(2096,'1','303',1,'Retail Sale Id 2064',0.00,4690.00,720.00,5040.00,350.00,'2023-02-17 15:25:16'),(2097,'1','303',1,'Retail Sale Id 2065',0.00,1862.60,720.00,2001.60,139.00,'2023-02-17 15:29:28'),(2098,'1','303',1,'Retail Sale Id 2066',0.00,4020.00,720.00,4320.00,300.00,'2023-02-17 15:32:13'),(2099,'1','303',1,'Retail Sale Id 2067',0.00,1862.60,720.00,2001.60,139.00,'2023-02-17 15:33:41'),(2100,'1','303',1,'Retail Sale Id 2068',0.00,4020.00,720.00,4320.00,300.00,'2023-02-17 15:34:54'),(2101,'1','303',1,'Retail Sale Id 2070',0.00,8375.00,720.00,9000.00,625.00,'2023-02-17 15:38:22'),(2102,'1','303',1,'Retail Sale Id 2071',0.00,2793.90,720.00,3002.40,208.50,'2023-02-17 15:40:34'),(2103,'1','303',1,'Retail Sale Id 2072',0.00,556.10,720.00,597.60,41.50,'2023-02-17 15:41:28'),(2104,'1','303',1,'Retail Sale Id 2073',0.00,8375.00,720.00,9000.00,625.00,'2023-02-17 15:44:44'),(2105,'1','303',1,'Retail Sale Id 2074',0.00,4020.00,720.00,4320.00,300.00,'2023-02-17 15:45:35'),(2106,'1','303',1,'Retail Sale Id 2075',0.00,4020.00,720.00,4320.00,300.00,'2023-02-17 15:46:56'),(2107,'1','303',1,'Retail Sale Id 2076',0.00,2793.90,720.00,3002.40,208.50,'2023-02-17 15:51:51'),(2108,'1','303',1,'Retail Sale Id 2076',0.00,2793.90,720.00,3002.40,208.50,'2023-02-17 15:51:52'),(2109,'1','303',1,'Retail Sale Id 2077',0.00,4020.00,720.00,4320.00,300.00,'2023-02-17 16:04:47'),(2110,'1','303',1,'Retail Sale Id 2078',0.00,2010.00,720.00,2160.00,150.00,'2023-02-17 16:06:52'),(2111,'1','303',1,'Retail Sale Id 2079',0.00,4020.00,720.00,4320.00,300.00,'2023-02-17 16:26:26'),(2112,'1','303',1,'Retail Sale Id 2080',0.00,4020.00,720.00,4320.00,300.00,'2023-02-17 16:31:46'),(2113,'1','303',1,'Retail Sale Id 2081',0.00,3350.00,720.00,3600.00,250.00,'2023-02-17 16:33:40'),(2114,'1','303',1,'Retail Sale Id 2082',0.00,6700.00,720.00,7200.00,500.00,'2023-02-17 16:35:41'),(2115,'1','303',1,'Retail Sale Id 2083',0.00,4020.00,720.00,4320.00,300.00,'2023-02-17 16:36:40'),(2116,'1','303',1,'Retail Sale Id 2084',0.00,670.00,720.00,720.00,50.00,'2023-02-17 16:37:37'),(2117,'1','303',1,'Retail Sale Id 2085',0.00,4020.00,720.00,4320.00,300.00,'2023-02-17 16:40:18'),(2118,'1','303',1,'Retail Sale Id 2086',0.00,8040.00,720.00,8640.00,600.00,'2023-02-17 16:42:01'),(2119,'1','303',1,'Retail Sale Id 2087',0.00,14405.00,720.00,15480.00,1075.00,'2023-02-17 16:44:10'),(2120,'1','303',1,'Retail Sale Id 2088',0.00,4020.00,720.00,4320.00,300.00,'2023-02-17 16:46:27'),(2121,'1','303',1,'Retail Sale Id 2089',0.00,1862.60,720.00,2001.60,139.00,'2023-02-17 16:50:32'),(2122,'1','303',1,'Retail Sale Id 2090',0.00,4020.00,720.00,4320.00,300.00,'2023-02-17 16:51:46'),(2123,'1','303',1,'Retail Sale Id 2091',0.00,4020.00,720.00,4320.00,300.00,'2023-02-17 16:52:42'),(2124,'1','303',1,'Retail Sale Id 2092',0.00,4020.00,720.00,4320.00,300.00,'2023-02-17 16:57:08'),(2125,'1','303',1,'Retail Sale Id 2093',0.00,3350.00,720.00,3600.00,250.00,'2023-02-17 16:58:46'),(2126,'1','303',1,'Retail Sale Id 2094',0.00,4649.80,720.00,4996.80,347.00,'2023-02-17 17:10:28'),(2127,'1','303',1,'Retail Sale Id 2095',0.00,4020.00,720.00,4320.00,300.00,'2023-02-17 17:14:33'),(2128,'1','303',1,'Retail Sale Id 2096',0.00,2010.00,720.00,2160.00,150.00,'2023-02-17 17:18:07'),(2129,'1','303',1,'Retail Sale Id 2097',0.00,8375.00,720.00,9000.00,625.00,'2023-02-17 17:35:07'),(2130,'1','303',1,'Retail Sale Id 2098',0.00,368500.00,690.00,379500.00,11000.00,'2023-02-17 17:37:14'),(2131,'1','303',1,'Retail Sale Id 2099',0.00,18619.30,720.00,20008.80,1389.50,'2023-02-17 17:44:25'),(2132,'1','303',1,'Retail Sale Id 2100',0.00,4020.00,720.00,4320.00,300.00,'2023-02-17 18:03:16'),(2133,'1','303',1,'Retail Sale Id 2101',0.00,730.30,720.00,784.80,54.50,'2023-02-17 19:16:46'),(2134,'1','303',1,'Retail Sale Id 2102',0.00,8375.00,720.00,9000.00,625.00,'2023-02-18 08:14:14'),(2135,'1','303',1,'Retail Sale Id 2103',0.00,1393.60,720.00,1497.60,104.00,'2023-02-18 09:25:39'),(2136,'1','303',1,'Retail Sale Id 2104',0.00,4020.00,720.00,4320.00,300.00,'2023-02-18 09:41:22'),(2137,'1','303',1,'Retail Sale Id 2105',0.00,3350.00,720.00,3600.00,250.00,'2023-02-18 09:42:49'),(2138,'1','303',1,'Retail Sale Id 2106',0.00,1393.60,720.00,1497.60,104.00,'2023-02-18 09:57:07'),(2139,'1','303',1,'Retail Sale Id 2107',0.00,1862.60,720.00,2001.60,139.00,'2023-02-18 10:12:28'),(2140,'1','303',1,'Retail Sale Id 2108',0.00,931.30,720.00,1000.80,69.50,'2023-02-18 10:15:16'),(2141,'1','303',1,'Retail Sale Id 2109',0.00,2050.20,720.00,2203.20,153.00,'2023-02-18 10:18:45'),(2142,'1','303',1,'Retail Sale Id 2110',0.00,1393.60,720.00,1497.60,104.00,'2023-02-18 10:41:33'),(2143,'1','303',1,'Retail Sale Id 2111',0.00,2003.30,720.00,2152.80,149.50,'2023-02-18 10:43:31'),(2144,'1','303',1,'Retail Sale Id 2113',0.00,4020.00,720.00,4320.00,300.00,'2023-02-18 10:49:51'),(2145,'1','303',1,'Retail Sale Id 2114',0.00,4020.00,720.00,4320.00,300.00,'2023-02-18 11:03:08'),(2146,'1','303',1,'Retail Sale Id 2115',0.00,4020.00,720.00,4320.00,300.00,'2023-02-18 11:16:13'),(2147,'1','303',1,'Retail Sale Id 2116',0.00,4649.80,720.00,4996.80,347.00,'2023-02-18 11:22:10'),(2148,'1','303',1,'Retail Sale Id 2117',0.00,4020.00,720.00,4320.00,300.00,'2023-02-18 11:26:33'),(2149,'1','303',1,'Retail Sale Id 2118',0.00,4020.00,720.00,4320.00,300.00,'2023-02-18 11:37:24'),(2150,'1','303',1,'Retail Sale Id 2119',0.00,2700.10,720.00,2901.60,201.50,'2023-02-18 11:42:44'),(2151,'1','303',1,'Retail Sale Id 2120',0.00,2680.00,720.00,2880.00,200.00,'2023-02-18 11:44:29'),(2152,'1','303',1,'Retail Sale Id 2121',0.00,4046.80,720.00,4348.80,302.00,'2023-02-18 11:54:23'),(2153,'1','303',1,'Retail Sale Id 2122',0.00,7443.70,720.00,7999.20,555.50,'2023-02-18 11:58:40'),(2154,'1','303',1,'Retail Sale Id 2123',0.00,8375.00,720.00,9000.00,625.00,'2023-02-18 12:11:41'),(2155,'1','303',1,'Retail Sale Id 2124',0.00,931.30,720.00,1000.80,69.50,'2023-02-18 12:15:20'),(2156,'1','303',1,'Retail Sale Id 2125',0.00,1393.60,720.00,1497.60,104.00,'2023-02-18 12:16:13'),(2157,'1','303',1,'Retail Sale Id 2126',0.00,2010.00,720.00,2160.00,150.00,'2023-02-18 12:20:30'),(2158,'1','303',1,'Retail Sale Id 2126',0.00,4020.00,720.00,4320.00,300.00,'2023-02-18 12:20:30'),(2159,'1','303',1,'Retail Sale Id 2126',0.00,6700.00,720.00,7200.00,500.00,'2023-02-18 12:20:30'),(2160,'1','303',1,'Retail Sale Id 2127',0.00,8375.00,720.00,9000.00,625.00,'2023-02-18 12:26:23'),(2161,'1','303',1,'Retail Sale Id 2128',0.00,4020.00,720.00,4320.00,300.00,'2023-02-18 12:32:23'),(2162,'1','303',1,'Retail Sale Id 2129',0.00,8375.00,720.00,9000.00,625.00,'2023-02-18 12:34:12'),(2163,'1','303',1,'Retail Sale Id 2130',0.00,7370.00,720.00,7920.00,550.00,'2023-02-18 12:49:12'),(2164,'1','303',1,'Retail Sale Id 2130',0.00,8375.00,720.00,9000.00,625.00,'2023-02-18 12:49:12'),(2165,'1','303',1,'Retail Sale Id 2131',0.00,8375.00,720.00,9000.00,625.00,'2023-02-18 12:50:31'),(2166,'1','303',1,'Retail Sale Id 2132',0.00,8375.00,720.00,9000.00,625.00,'2023-02-18 12:53:00'),(2167,'1','303',1,'Retail Sale Id 2133',0.00,4020.00,720.00,4320.00,300.00,'2023-02-18 13:08:54'),(2168,'1','303',1,'Retail Sale Id 2134',0.00,1956.40,720.00,2102.40,146.00,'2023-02-18 13:16:37'),(2169,'1','303',1,'Retail Sale Id 2135',0.00,1340.00,720.00,1440.00,100.00,'2023-02-18 13:32:03'),(2170,'1','303',1,'Retail Sale Id 2136',0.00,6030.00,720.00,6480.00,450.00,'2023-02-18 13:49:18'),(2171,'1','303',1,'Retail Sale Id 2137',0.00,4020.00,720.00,4320.00,300.00,'2023-02-18 13:53:45'),(2172,'1','303',1,'Retail Sale Id 2138',0.00,1118.90,720.00,1202.40,83.50,'2023-02-18 13:55:40'),(2173,'1','303',1,'Retail Sale Id 2139',0.00,4020.00,720.00,4320.00,300.00,'2023-02-18 14:32:48'),(2174,'1','303',1,'Retail Sale Id 2140',0.00,2003.30,720.00,2152.80,149.50,'2023-02-18 15:11:48'),(2175,'1','303',1,'Retail Sale Id 2141',0.00,1393.60,720.00,1497.60,104.00,'2023-02-18 15:24:54'),(2176,'1','303',1,'Retail Sale Id 2142',0.00,4020.00,720.00,4320.00,300.00,'2023-02-18 15:32:09'),(2177,'1','303',1,'Retail Sale Id 2143',0.00,8375.00,720.00,9000.00,625.00,'2023-02-18 15:33:08'),(2178,'1','303',1,'Retail Sale Id 2144',0.00,931.30,720.00,1000.80,69.50,'2023-02-18 15:51:37'),(2179,'1','303',1,'Retail Sale Id 2145',0.00,8375.00,720.00,9000.00,625.00,'2023-02-18 15:54:21'),(2180,'1','303',1,'Retail Sale Id 2146',0.00,4187.50,720.00,4500.00,312.50,'2023-02-18 16:00:35'),(2181,'1','303',1,'Retail Sale Id 2147',0.00,4020.00,720.00,4320.00,300.00,'2023-02-18 16:06:22'),(2182,'1','303',1,'Retail Sale Id 2148',0.00,4020.00,720.00,4320.00,300.00,'2023-02-18 16:15:06'),(2183,'1','303',1,'Retail Sale Id 2149',0.00,2010.00,720.00,2160.00,150.00,'2023-02-18 16:16:59'),(2184,'1','303',1,'Retail Sale Id 2150',0.00,2010.00,720.00,2160.00,150.00,'2023-02-18 16:21:40'),(2185,'1','303',1,'Retail Sale Id 2150',0.00,2010.00,720.00,2160.00,150.00,'2023-02-18 16:21:40'),(2186,'1','303',1,'Return of Retail Sale Id 2150',2010.00,0.00,720.00,-2160.00,-150.00,'2023-02-18 16:33:13'),(2187,'1','303',1,'Return of Retail Sale Id 2150',2010.00,0.00,720.00,-2160.00,-150.00,'2023-02-18 16:33:13'),(2188,'1','303',1,'Retail Sale Id 2151',0.00,3350.00,720.00,3600.00,250.00,'2023-02-18 16:54:12'),(2189,'1','303',1,'Retail Sale Id 2152',0.00,4020.00,720.00,4320.00,300.00,'2023-02-18 17:00:23'),(2190,'1','303',1,'Retail Sale Id 2153',0.00,2010.00,720.00,2160.00,150.00,'2023-02-18 17:12:58'),(2191,'1','303',1,'Retail Sale Id 2154',0.00,3350.00,720.00,3600.00,250.00,'2023-02-18 17:14:03'),(2192,'1','303',1,'Retail Sale Id 2155',0.00,1393.60,720.00,1497.60,104.00,'2023-02-18 17:15:04'),(2193,'1','303',1,'Retail Sale Id 2156',0.00,7370.00,720.00,7920.00,550.00,'2023-02-18 17:16:32'),(2194,'1','303',1,'Retail Sale Id 2157',0.00,4020.00,720.00,4320.00,300.00,'2023-02-18 17:25:05'),(2195,'1','303',1,'Retail Sale Id 2158',0.00,4020.00,720.00,4320.00,300.00,'2023-02-18 17:39:33'),(2196,'1','303',1,'Retail Sale Id 2159',0.00,8375.00,720.00,9000.00,625.00,'2023-02-18 17:54:50'),(2197,'1','303',1,'Retail Sale Id 2160',0.00,4093.70,720.00,4399.20,305.50,'2023-02-18 17:58:00'),(2198,'1','303',1,'Retail Sale Id 2161',0.00,1393.60,720.00,1497.60,104.00,'2023-02-19 08:04:16'),(2199,'1','303',1,'Retail Sale Id 2162',0.00,4020.00,720.00,4320.00,300.00,'2023-02-19 08:12:00'),(2200,'1','303',1,'Retail Sale Id 2163',0.00,3350.00,720.00,3600.00,250.00,'2023-02-19 08:35:19'),(2201,'1','303',1,'Retail Sale Id 2164',0.00,4020.00,720.00,4320.00,300.00,'2023-02-19 08:55:15'),(2202,'1','303',1,'Retail Sale Id 2165',0.00,1487.40,720.00,1598.40,111.00,'2023-02-19 09:03:47'),(2203,'1','303',1,'Retail Sale Id 2166',0.00,8375.00,720.00,9000.00,625.00,'2023-02-19 09:50:23'),(2204,'1','303',1,'Retail Sale Id 2168',0.00,3999.90,720.00,4298.40,298.50,'2023-02-19 10:03:48'),(2205,'1','303',1,'Retail Sale Id 2169',0.00,4046.80,720.00,4348.80,302.00,'2023-02-19 10:05:16'),(2206,'1','303',1,'Retail Sale Id 2170',0.00,8375.00,720.00,9000.00,625.00,'2023-02-19 10:32:03'),(2207,'1','303',1,'Retail Sale Id 2171',0.00,4020.00,720.00,4320.00,300.00,'2023-02-19 10:33:06'),(2208,'1','303',1,'Retail Sale Id 2172',0.00,3350.00,720.00,3600.00,250.00,'2023-02-19 10:44:47'),(2209,'1','303',1,'Retail Sale Id 2173',0.00,3350.00,720.00,3600.00,250.00,'2023-02-19 10:45:56'),(2210,'1','303',1,'Retail Sale Id 2174',0.00,13400.00,720.00,14400.00,1000.00,'2023-02-19 11:04:02'),(2211,'1','303',1,'Retail Sale Id 2175',0.00,8375.00,720.00,9000.00,625.00,'2023-02-19 11:08:39'),(2212,'1','303',1,'Retail Sale Id 2176',0.00,2010.00,720.00,2160.00,150.00,'2023-02-19 11:20:35'),(2213,'1','303',1,'Retail Sale Id 2177',0.00,3350.00,720.00,3600.00,250.00,'2023-02-19 11:22:10'),(2214,'1','303',1,'Retail Sale Id 2179',0.00,2010.00,720.00,2160.00,150.00,'2023-02-19 11:32:48'),(2215,'1','303',1,'Retail Sale Id 2179',0.00,3350.00,720.00,3600.00,250.00,'2023-02-19 11:32:48'),(2216,'1','303',1,'Retail Sale Id 2180',0.00,1340.00,720.00,1440.00,100.00,'2023-02-19 11:36:03'),(2217,'1','303',1,'Retail Sale Id 2180',0.00,5360.00,720.00,5760.00,400.00,'2023-02-19 11:36:03'),(2218,'1','303',1,'Retail Sale Id 2181',0.00,2010.00,720.00,2160.00,150.00,'2023-02-19 11:38:25'),(2219,'1','303',1,'Retail Sale Id 2181',0.00,3350.00,720.00,3600.00,250.00,'2023-02-19 11:38:26'),(2220,'1','303',1,'Retail Sale Id 2182',0.00,4020.00,720.00,4320.00,300.00,'2023-02-19 11:51:47'),(2221,'1','303',1,'Retail Sale Id 2183',0.00,4020.00,720.00,4320.00,300.00,'2023-02-19 11:54:43'),(2222,'1','303',1,'Retail Sale Id 2184',0.00,931.30,720.00,1000.80,69.50,'2023-02-19 12:07:07'),(2223,'1','303',1,'Retail Sale Id 2185',0.00,3350.00,720.00,3600.00,250.00,'2023-02-19 12:09:38'),(2224,'1','303',1,'Retail Sale Id 2186',0.00,1212.70,720.00,1303.20,90.50,'2023-02-19 12:11:17'),(2225,'1','303',1,'Retail Sale Id 2187',0.00,1487.40,720.00,1598.40,111.00,'2023-02-19 12:12:27'),(2226,'1','303',1,'Return of Retail Sale Id 2186',1212.70,0.00,720.00,-1303.20,-90.50,'2023-02-19 12:13:56'),(2227,'1','303',1,'Retail Sale Id 2188',0.00,6512.40,720.00,6998.40,486.00,'2023-02-19 12:26:45'),(2228,'1','303',1,'Retail Sale Id 2189',0.00,4020.00,720.00,4320.00,300.00,'2023-02-19 12:31:20'),(2229,'1','303',1,'Retail Sale Id 2190',0.00,2010.00,720.00,2160.00,150.00,'2023-02-19 12:34:41'),(2230,'1','303',1,'Retail Sale Id 2191',0.00,2010.00,720.00,2160.00,150.00,'2023-02-19 12:51:34'),(2231,'1','303',1,'Retail Sale Id 2192',0.00,2010.00,720.00,2160.00,150.00,'2023-02-19 12:58:38'),(2232,'1','303',1,'Retail Sale Id 2193',0.00,2010.00,720.00,2160.00,150.00,'2023-02-19 13:17:38'),(2233,'1','303',1,'Retail Sale Id 2194',0.00,2050.20,720.00,2203.20,153.00,'2023-02-19 13:29:47'),(2234,'1','303',1,'Retail Sale Id 2195',0.00,8375.00,720.00,9000.00,625.00,'2023-02-19 13:34:48'),(2235,'1','303',1,'Retail Sale Id 2196',0.00,1393.60,720.00,1497.60,104.00,'2023-02-19 13:36:27'),(2236,'1','303',1,'Retail Sale Id 2197',0.00,3350.00,720.00,3600.00,250.00,'2023-02-19 13:48:09'),(2237,'1','303',1,'Retail Sale Id 2198',0.00,4020.00,720.00,4320.00,300.00,'2023-02-19 13:55:00'),(2238,'1','303',1,'Retail Sale Id 2199',0.00,670.00,720.00,720.00,50.00,'2023-02-19 14:13:53'),(2239,'1','303',1,'Retail Sale Id 2200',0.00,2003.30,720.00,2152.80,149.50,'2023-02-19 14:18:56'),(2240,'1','303',1,'Retail Sale Id 2201',0.00,4020.00,720.00,4320.00,300.00,'2023-02-19 14:22:39'),(2241,'1','303',1,'Retail Sale Id 2201',0.00,4020.00,720.00,4320.00,300.00,'2023-02-19 14:22:39'),(2242,'1','303',1,'Retail Sale Id 2202',0.00,3350.00,720.00,3600.00,250.00,'2023-02-19 14:24:01'),(2243,'1','303',1,'Retail Sale Id 2203',0.00,1675.00,720.00,1800.00,125.00,'2023-02-19 14:25:16'),(2244,'1','303',1,'Retail Sale Id 2204',0.00,4020.00,720.00,4320.00,300.00,'2023-02-19 14:35:31'),(2245,'1','303',1,'Retail Sale Id 2205',0.00,1675.00,720.00,1800.00,125.00,'2023-02-19 14:37:38'),(2246,'1','303',1,'Retail Sale Id 2206',0.00,8040.00,720.00,8640.00,600.00,'2023-02-19 14:42:28'),(2247,'1','303',1,'Retail Sale Id 2207',0.00,4046.80,720.00,4348.80,302.00,'2023-02-19 14:43:31'),(2248,'1','303',1,'Retail Sale Id 2208',0.00,67000.00,690.00,69000.00,2000.00,'2023-02-19 14:58:12'),(2249,'1','303',1,'Retail Sale Id 2209',0.00,931.30,720.00,1000.80,69.50,'2023-02-19 15:02:42'),(2250,'1','303',1,'Retail Sale Id 2210',0.00,1393.60,720.00,1497.60,104.00,'2023-02-19 15:08:03'),(2251,'1','303',1,'Retail Sale Id 2211',0.00,649.90,720.00,698.40,48.50,'2023-02-19 16:00:12'),(2252,'1','303',1,'Retail Sale Id 2212',0.00,2010.00,720.00,2160.00,150.00,'2023-02-19 16:18:21'),(2253,'1','303',1,'Retail Sale Id 2213',0.00,1862.60,720.00,2001.60,139.00,'2023-02-19 16:21:21'),(2254,'1','303',1,'Retail Sale Id 2214',0.00,2010.00,720.00,2160.00,150.00,'2023-02-19 16:44:59'),(2255,'1','303',1,'Retail Sale Id 2215',0.00,4020.00,720.00,4320.00,300.00,'2023-02-19 16:50:07'),(2256,'1','303',1,'Retail Sale Id 2216',0.00,4020.00,720.00,4320.00,300.00,'2023-02-19 16:51:36'),(2257,'1','303',1,'Retail Sale Id 2217',0.00,2680.00,720.00,2880.00,200.00,'2023-02-19 16:55:12'),(2258,'1','303',1,'Retail Sale Id 2218',0.00,2010.00,720.00,2160.00,150.00,'2023-02-19 17:52:19'),(2259,'1','303',1,'Retail Sale Id 2219',0.00,1862.60,720.00,2001.60,139.00,'2023-02-19 18:03:28'),(2260,'1','303',1,'Retail Sale Id 2220',0.00,1862.60,720.00,2001.60,139.00,'2023-02-19 18:05:35'),(2261,'1','303',1,'Return of Retail Sale Id 2209',931.30,0.00,720.00,-1000.80,-69.50,'2023-02-19 19:11:56'),(2262,'1','303',1,'Retail Sale Id 2221',0.00,763.80,720.00,820.80,57.00,'2023-02-19 19:12:46'),(2263,'1','303',1,'Return of Retail Sale Id 2221',763.80,0.00,720.00,-820.80,-57.00,'2023-02-19 19:14:08'),(2264,'1','303',1,'Return of Retail Sale Id 2203',1675.00,0.00,720.00,-1800.00,-125.00,'2023-02-19 19:16:27'),(2265,'1','303',1,'Retail Sale Id 2222',0.00,924.60,720.00,993.60,69.00,'2023-02-19 19:17:20'),(2266,'1','303',1,'Retail Sale Id 2223',0.00,4020.00,720.00,4320.00,300.00,'2023-02-20 09:25:42'),(2267,'1','303',1,'Retail Sale Id 2224',0.00,4020.00,720.00,4320.00,300.00,'2023-02-20 09:26:46'),(2268,'1','303',1,'Retail Sale Id 2225',0.00,4020.00,720.00,4320.00,300.00,'2023-02-20 09:28:23'),(2269,'1','303',1,'Return of Retail Sale Id 2225',4020.00,0.00,720.00,-4320.00,-300.00,'2023-02-20 09:31:24'),(2270,'1','303',1,'Retail Sale Id 2226',0.00,2010.00,720.00,2160.00,150.00,'2023-02-20 09:32:01'),(2271,'1','303',1,'Retail Sale Id 2227',0.00,4649.80,720.00,4996.80,347.00,'2023-02-20 09:33:26'),(2272,'1','303',1,'Retail Sale Id 2228',0.00,8375.00,720.00,9000.00,625.00,'2023-02-20 09:35:07'),(2273,'1','303',1,'Retail Sale Id 2229',0.00,4020.00,720.00,4320.00,300.00,'2023-02-20 10:09:31'),(2274,'1','303',1,'Retail Sale Id 2230',0.00,4020.00,720.00,4320.00,300.00,'2023-02-20 10:26:30'),(2275,'1','303',1,'Retail Sale Id 2231',0.00,4020.00,720.00,4320.00,300.00,'2023-02-20 10:37:48'),(2276,'1','303',1,'Retail Sale Id 2232',0.00,2010.00,720.00,2160.00,150.00,'2023-02-20 10:49:24'),(2277,'1','303',1,'Retail Sale Id 2233',0.00,1862.60,720.00,2001.60,139.00,'2023-02-20 10:50:30'),(2278,'1','303',1,'Retail Sale Id 2234',0.00,4020.00,720.00,4320.00,300.00,'2023-02-20 10:54:50'),(2279,'1','303',1,'Retail Sale Id 2235',0.00,4020.00,720.00,4320.00,300.00,'2023-02-20 10:59:51'),(2280,'1','303',1,'Retail Sale Id 2236',0.00,2793.90,720.00,3002.40,208.50,'2023-02-20 11:22:49'),(2281,'1','303',1,'Retail Sale Id 2237',0.00,8375.00,720.00,9000.00,625.00,'2023-02-20 11:29:34'),(2282,'1','303',1,'Retail Sale Id 2238',0.00,2010.00,720.00,2160.00,150.00,'2023-02-20 11:41:51'),(2283,'1','303',1,'Retail Sale Id 2239',0.00,1340.00,720.00,1440.00,100.00,'2023-02-20 11:42:43'),(2284,'1','303',1,'Retail Sale Id 2240',0.00,4020.00,720.00,4320.00,300.00,'2023-02-20 11:54:45'),(2285,'1','303',1,'Retail Sale Id 2241',0.00,8375.00,720.00,9000.00,625.00,'2023-02-20 11:58:34'),(2286,'1','303',1,'Retail Sale Id 2242',0.00,134000.00,690.00,138000.00,4000.00,'2023-02-20 12:04:13'),(2287,'1','303',1,'Retail Sale Id 2243',0.00,4020.00,720.00,4320.00,300.00,'2023-02-20 12:10:45'),(2288,'1','303',1,'Retail Sale Id 2244',0.00,4187.50,720.00,4500.00,312.50,'2023-02-20 12:14:27'),(2289,'1','303',1,'Retail Sale Id 2245',0.00,134000.00,690.00,138000.00,4000.00,'2023-02-20 12:33:52'),(2290,'1','303',1,'Retail Sale Id 2246',0.00,2010.00,720.00,2160.00,150.00,'2023-02-20 12:36:36'),(2291,'1','303',1,'Retail Sale Id 2247',0.00,6700.00,720.00,7200.00,500.00,'2023-02-20 12:37:29'),(2292,'1','303',1,'Retail Sale Id 2248',0.00,4649.80,720.00,4996.80,347.00,'2023-02-20 12:38:55'),(2293,'1','303',1,'Retail Sale Id 2249',0.00,3350.00,720.00,3600.00,250.00,'2023-02-20 12:42:10'),(2294,'1','303',1,'Retail Sale Id 2250',0.00,931.30,720.00,1000.80,69.50,'2023-02-20 12:46:26'),(2295,'1','303',1,'Return of Retail Sale Id 2250',931.30,0.00,720.00,-1000.80,-69.50,'2023-02-20 13:44:09'),(2296,'1','303',1,'Return of Retail Sale Id 2245',134000.00,0.00,690.00,-138000.00,-4000.00,'2023-02-20 13:56:36'),(2297,'1','303',1,'Sale Id 1',0.00,523256.60,0.00,0.00,-523256.60,'2023-02-20 13:57:28'),(2298,'1','303',1,'Retail Sale Id 2251',0.00,33500.00,690.00,34500.00,1000.00,'2023-02-20 13:57:38'),(2299,'1','303',1,'Return of Retail Sale Id 2241',8375.00,0.00,720.00,-9000.00,-625.00,'2023-02-20 14:35:28'),(2300,'1','303',1,'Return of Retail Sale Id 2239',1340.00,0.00,720.00,-1440.00,-100.00,'2023-02-20 14:36:43'),(2301,'1','303',1,'Retail Sale Id 2252',0.00,984.90,720.00,1058.40,73.50,'2023-02-20 14:37:28'),(2302,'1','303',1,'Return of Retail Sale Id 2251',33500.00,0.00,690.00,-34500.00,-1000.00,'2023-02-20 14:39:34'),(2303,'1','303',1,'Retail Sale Id 2253',0.00,31416.30,690.00,32354.10,937.80,'2023-02-20 14:41:21'),(2304,'1','303',1,'Sale Id 2',0.00,623756.60,0.00,0.00,-623756.60,'2023-02-20 14:48:53'),(2305,'1','303',1,'Sale Id 3',0.00,10813.80,0.00,0.00,-10813.80,'2023-02-20 14:54:20'),(2306,'1','303',1,'Retail Sale Id 2254',0.00,8125.00,720.00,9000.00,875.00,'2023-02-20 17:05:06'),(2307,'1','303',1,'Retail Sale Id 2255',0.00,4062.50,720.00,4500.00,437.50,'2023-02-20 17:07:09'),(2308,'1','303',1,'Retail Sale Id 2257',0.00,3900.00,720.00,4320.00,420.00,'2023-02-20 17:09:15'),(2309,'1','303',1,'Retail Sale Id 2259',0.00,3900.00,720.00,4320.00,420.00,'2023-02-20 17:16:52'),(2310,'1','303',1,'Retail Sale Id 2260',0.00,1950.00,720.00,2160.00,210.00,'2023-02-20 17:17:51'),(2311,'1','303',1,'Retail Sale Id 2261',0.00,3250.00,720.00,3600.00,350.00,'2023-02-20 17:25:39'),(2312,'1','303',1,'Retail Sale Id 2262',0.00,1807.00,720.00,2001.60,194.60,'2023-02-20 17:28:33'),(2313,'1','303',1,'Retail Sale Id 2263',0.00,3900.00,720.00,4320.00,420.00,'2023-02-20 17:30:48'),(2314,'1','303',1,'Retail Sale Id 2264',0.00,2710.50,720.00,3002.40,291.90,'2023-02-20 17:34:11'),(2315,'1','303',1,'Retail Sale Id 2265',0.00,97500.00,690.00,103500.00,6000.00,'2023-02-20 17:36:59'),(2316,'1','303',1,'Retail Sale Id 2267',0.00,903.50,720.00,1000.80,97.30,'2023-02-20 17:39:39'),(2317,'1','303',1,'Retail Sale Id 2267',0.00,903.50,720.00,1000.80,97.30,'2023-02-20 17:39:39'),(2318,'1','303',1,'Retail Sale Id 2269',0.00,3900.00,720.00,4320.00,420.00,'2023-02-20 17:42:10'),(2319,'1','303',1,'Retail Sale Id 2269',0.00,8125.00,720.00,9000.00,875.00,'2023-02-20 17:42:10'),(2320,'1','303',1,'Retail Sale Id 2270',0.00,3900.00,720.00,4320.00,420.00,'2023-02-20 17:43:22'),(2321,'1','303',1,'Retail Sale Id 2271',0.00,3250.00,720.00,3600.00,350.00,'2023-02-20 17:54:13'),(2322,'1','303',1,'Retail Sale Id 2273',0.00,1950.00,720.00,2160.00,210.00,'2023-02-20 18:04:05'),(2323,'1','303',1,'Retail Sale Id 2274',0.00,3900.00,720.00,4320.00,420.00,'2023-02-20 18:04:56'),(2324,'1','303',1,'Retail Sale Id 2275',0.00,4550.00,720.00,5040.00,490.00,'2023-02-20 18:08:24'),(2325,'1','303',1,'Retail Sale Id 2276',0.00,3900.00,720.00,4320.00,420.00,'2023-02-20 18:10:25'),(2326,'1','303',1,'Retail Sale Id 2277',0.00,3900.00,720.00,4320.00,420.00,'2023-02-20 18:11:49'),(2327,'1','303',1,'Retail Sale Id 2278',0.00,1085.50,720.00,1202.40,116.90,'2023-02-20 18:14:11'),(2328,'1','303',1,'Retail Sale Id 2278',0.00,1989.00,720.00,2203.20,214.20,'2023-02-20 18:14:11'),(2329,'1','303',1,'Retail Sale Id 2279',0.00,1950.00,720.00,2160.00,210.00,'2023-02-20 18:15:56'),(2330,'1','303',1,'Retail Sale Id 2280',0.00,13.00,720.00,14.40,1.40,'2023-02-20 19:33:39'),(2331,'1','303',1,'Retail Sale Id 2281',0.00,1891.50,690.00,2007.90,116.40,'2023-02-20 19:41:39'),(2332,'1','303',1,'Retail Sale Id 2282',0.00,8125.00,720.00,9000.00,875.00,'2023-02-21 08:16:28'),(2333,'1','303',1,'Retail Sale Id 2283',0.00,2600.00,720.00,2880.00,280.00,'2023-02-21 08:35:03'),(2334,'1','303',1,'Retail Sale Id 2283',0.00,2600.00,720.00,2880.00,280.00,'2023-02-21 08:35:03'),(2335,'1','303',1,'Retail Sale Id 2284',0.00,8125.00,720.00,9000.00,875.00,'2023-02-21 09:09:43'),(2336,'1','303',1,'Retail Sale Id 2285',0.00,1950.00,720.00,2160.00,210.00,'2023-02-21 09:25:39'),(2337,'1','303',1,'Retail Sale Id 2286',0.00,903.50,720.00,1000.80,97.30,'2023-02-21 09:30:16'),(2338,'1','303',1,'Retail Sale Id 2286',0.00,1807.00,720.00,2001.60,194.60,'2023-02-21 09:30:16'),(2339,'1','303',1,'Retail Sale Id 2287',0.00,8125.00,720.00,9000.00,875.00,'2023-02-21 09:34:31'),(2340,'1','303',1,'Retail Sale Id 2288',0.00,1950.00,720.00,2160.00,210.00,'2023-02-21 09:40:55'),(2341,'1','303',1,'Retail Sale Id 2289',0.00,126386.00,720.00,139996.80,13610.80,'2023-02-21 09:50:10'),(2342,'1','303',1,'Retail Sale Id 2290',0.00,12636.00,720.00,13996.80,1360.80,'2023-02-21 09:51:07'),(2343,'1','303',1,'Return of Retail Sale Id 2289',126386.00,0.00,720.00,-139996.80,-13610.80,'2023-02-21 09:53:02'),(2344,'1','303',1,'Retail Sale Id 2291',0.00,3900.00,720.00,4320.00,420.00,'2023-02-21 09:56:48'),(2345,'1','303',1,'Retail Sale Id 2292',0.00,8125.00,720.00,9000.00,875.00,'2023-02-21 10:17:19'),(2346,'1','303',1,'Retail Sale Id 2293',0.00,2710.50,720.00,3002.40,291.90,'2023-02-21 10:25:01'),(2347,'1','303',1,'Retail Sale Id 2294',0.00,3250.00,720.00,3600.00,350.00,'2023-02-21 10:41:31'),(2348,'1','303',1,'Retail Sale Id 2295',0.00,3900.00,720.00,4320.00,420.00,'2023-02-21 10:46:16'),(2349,'1','303',1,'Retail Sale Id 2296',0.00,539.50,720.00,597.60,58.10,'2023-02-21 10:53:41'),(2350,'1','303',1,'Retail Sale Id 2297',0.00,3900.00,720.00,4320.00,420.00,'2023-02-21 11:07:56'),(2351,'1','303',1,'Retail Sale Id 2298',0.00,3900.00,720.00,4320.00,420.00,'2023-02-21 11:09:26'),(2352,'1','303',1,'Retail Sale Id 2299',0.00,3900.00,720.00,4320.00,420.00,'2023-02-21 11:11:21'),(2353,'1','303',1,'Retail Sale Id 2300',0.00,3900.00,720.00,4320.00,420.00,'2023-02-21 11:44:04'),(2354,'1','303',1,'Retail Sale Id 2301',0.00,12025.00,720.00,13320.00,1295.00,'2023-02-21 11:51:20'),(2355,'1','303',1,'Retail Sale Id 2302',0.00,32500.00,690.00,34500.00,2000.00,'2023-02-21 11:54:38'),(2356,'1','303',1,'Retail Sale Id 2303',0.00,1950.00,720.00,2160.00,210.00,'2023-02-21 12:20:20'),(2357,'1','303',1,'Retail Sale Id 2304',0.00,4062.50,720.00,4500.00,437.50,'2023-02-21 12:46:23'),(2358,'1','303',1,'Retail Sale Id 2305',0.00,8125.00,720.00,9000.00,875.00,'2023-02-21 13:00:43'),(2359,'1','303',1,'Retail Sale Id 2306',0.00,3614.00,720.00,4003.20,389.20,'2023-02-21 13:02:12'),(2360,'1','303',1,'Retail Sale Id 2307',0.00,3900.00,720.00,4320.00,420.00,'2023-02-21 13:30:40'),(2361,'1','303',1,'Retail Sale Id 2308',0.00,903.50,720.00,1000.80,97.30,'2023-02-21 13:32:12'),(2362,'1','303',1,'Retail Sale Id 2309',0.00,4550.00,720.00,5040.00,490.00,'2023-02-21 13:42:47'),(2363,'1','303',1,'Retail Sale Id 2310',0.00,3900.00,720.00,4320.00,420.00,'2023-02-21 13:48:40'),(2364,'1','303',1,'Retail Sale Id 2311',0.00,3900.00,720.00,4320.00,420.00,'2023-02-21 13:50:01'),(2365,'1','303',1,'Retail Sale Id 2312',0.00,32500.00,690.00,34500.00,2000.00,'2023-02-21 13:51:11'),(2366,'1','303',1,'Retail Sale Id 2313',0.00,3250.00,720.00,3600.00,350.00,'2023-02-21 13:52:23'),(2367,'1','303',1,'Retail Sale Id 2314',0.00,3900.00,720.00,4320.00,420.00,'2023-02-21 13:56:18'),(2368,'1','303',1,'Retail Sale Id 2315',0.00,1300.00,720.00,1440.00,140.00,'2023-02-21 14:06:51'),(2369,'1','303',1,'Retail Sale Id 2316',0.00,8125.00,720.00,9000.00,875.00,'2023-02-21 14:13:06'),(2370,'1','303',1,'Retail Sale Id 2317',0.00,2600.00,720.00,2880.00,280.00,'2023-02-21 14:29:47'),(2371,'1','303',1,'Retail Sale Id 2318',0.00,1950.00,720.00,2160.00,210.00,'2023-02-21 14:31:29'),(2372,'1','303',1,'Retail Sale Id 2319',0.00,1950.00,720.00,2160.00,210.00,'2023-02-21 14:52:34'),(2373,'1','303',1,'Retail Sale Id 2320',0.00,1807.00,720.00,2001.60,194.60,'2023-02-21 15:33:11'),(2374,'1','303',1,'Retail Sale Id 2321',0.00,1950.00,720.00,2160.00,210.00,'2023-02-21 15:36:46'),(2375,'1','303',1,'Retail Sale Id 2322',0.00,1807.00,720.00,2001.60,194.60,'2023-02-21 15:58:18'),(2376,'1','303',1,'Retail Sale Id 2323',0.00,2710.50,720.00,3002.40,291.90,'2023-02-21 15:59:09'),(2377,'1','303',1,'Retail Sale Id 2324',0.00,1989.00,720.00,2203.20,214.20,'2023-02-21 16:03:33'),(2378,'1','303',1,'Retail Sale Id 2325',0.00,1807.00,720.00,2001.60,194.60,'2023-02-21 16:09:35'),(2379,'1','303',1,'Retail Sale Id 2326',0.00,1950.00,720.00,2160.00,210.00,'2023-02-21 16:16:23'),(2380,'1','303',1,'Retail Sale Id 2327',0.00,7800.00,720.00,8640.00,840.00,'2023-02-21 16:20:53'),(2381,'1','303',1,'Retail Sale Id 2328',0.00,1950.00,720.00,2160.00,210.00,'2023-02-21 16:27:00'),(2382,'1','303',1,'Retail Sale Id 2329',0.00,2886.00,720.00,3196.80,310.80,'2023-02-21 16:31:34'),(2383,'1','303',1,'Retail Sale Id 2330',0.00,3900.00,720.00,4320.00,420.00,'2023-02-21 16:33:01'),(2384,'1','303',1,'Retail Sale Id 2331',0.00,3900.00,720.00,4320.00,420.00,'2023-02-21 16:33:52'),(2385,'1','303',1,'Retail Sale Id 2332',0.00,3900.00,720.00,4320.00,420.00,'2023-02-21 16:39:44'),(2386,'1','303',1,'Retail Sale Id 2333',0.00,7800.00,720.00,8640.00,840.00,'2023-02-21 16:41:15'),(2387,'1','303',1,'Retail Sale Id 2334',0.00,1300.00,720.00,1440.00,140.00,'2023-02-21 16:45:26'),(2388,'1','303',1,'Retail Sale Id 2335',0.00,1950.00,720.00,2160.00,210.00,'2023-02-21 16:55:32'),(2389,'1','303',1,'Retail Sale Id 2336',0.00,1950.00,720.00,2160.00,210.00,'2023-02-21 17:10:00'),(2390,'1','303',1,'Retail Sale Id 2337',0.00,1261.00,720.00,1396.80,135.80,'2023-02-21 17:14:41'),(2391,'1','303',1,'Retail Sale Id 2338',0.00,3900.00,720.00,4320.00,420.00,'2023-02-21 17:17:54'),(2392,'1','303',1,'Retail Sale Id 2339',0.00,1950.00,720.00,2160.00,210.00,'2023-02-21 17:27:00'),(2393,'1','303',1,'Retail Sale Id 2340',0.00,448.50,720.00,496.80,48.30,'2023-02-21 17:33:29'),(2394,'1','303',1,'Retail Sale Id 2341',0.00,1950.00,720.00,2160.00,210.00,'2023-02-21 17:36:52'),(2395,'1','303',1,'Retail Sale Id 2342',0.00,1300.00,720.00,1440.00,140.00,'2023-02-21 17:46:25'),(2396,'1','303',1,'Retail Sale Id 2343',0.00,1950.00,720.00,2160.00,210.00,'2023-02-21 17:54:41'),(2397,'1','303',1,'Retail Sale Id 2345',0.00,3900.00,720.00,4320.00,420.00,'2023-02-21 17:59:24'),(2398,'1','303',1,'Retail Sale Id 2346',0.00,3900.00,720.00,4320.00,420.00,'2023-02-22 08:59:54'),(2399,'1','303',1,'Retail Sale Id 2347',0.00,3900.00,720.00,4320.00,420.00,'2023-02-22 09:01:45'),(2400,'1','303',1,'Retail Sale Id 2348',0.00,1950.00,720.00,2160.00,210.00,'2023-02-22 09:27:50'),(2401,'1','303',1,'Retail Sale Id 2349',0.00,1950.00,720.00,2160.00,210.00,'2023-02-22 10:00:33'),(2402,'1','303',1,'Retail Sale Id 2350',0.00,3900.00,720.00,4320.00,420.00,'2023-02-22 10:18:38'),(2403,'1','303',1,'Retail Sale Id 2351',0.00,1807.00,720.00,2001.60,194.60,'2023-02-22 10:20:17'),(2404,'1','303',1,'Retail Sale Id 2352',0.00,2528.50,720.00,2800.80,272.30,'2023-02-22 10:27:19'),(2405,'1','303',1,'Retail Sale Id 2353',0.00,3900.00,720.00,4320.00,420.00,'2023-02-22 10:39:13'),(2406,'1','303',1,'Retail Sale Id 2354',0.00,8125.00,720.00,9000.00,875.00,'2023-02-22 10:51:19'),(2407,'1','303',1,'Retail Sale Id 2355',0.00,3900.00,720.00,4320.00,420.00,'2023-02-22 10:52:34'),(2408,'1','303',1,'Retail Sale Id 2356',0.00,1950.00,720.00,2160.00,210.00,'2023-02-22 10:59:14'),(2409,'1','303',1,'Retail Sale Id 2357',0.00,3900.00,720.00,4320.00,420.00,'2023-02-22 11:02:49'),(2410,'1','303',1,'Retail Sale Id 2358',0.00,1807.00,720.00,2001.60,194.60,'2023-02-22 11:07:28'),(2411,'1','303',1,'Retail Sale Id 2359',0.00,448.50,720.00,496.80,48.30,'2023-02-22 11:15:32'),(2412,'1','303',1,'Retail Sale Id 2360',0.00,1950.00,720.00,2160.00,210.00,'2023-02-22 11:24:50'),(2413,'1','303',1,'Retail Sale Id 2361',0.00,8125.00,720.00,9000.00,875.00,'2023-02-22 11:28:18'),(2414,'1','303',1,'Retail Sale Id 2362',0.00,97500.00,690.00,103500.00,6000.00,'2023-02-22 11:47:06'),(2415,'1','303',1,'Retail Sale Id 2363',0.00,903.50,720.00,1000.80,97.30,'2023-02-22 12:02:20'),(2416,'1','303',1,'Retail Sale Id 2364',0.00,3250.00,720.00,3600.00,350.00,'2023-02-22 12:06:04'),(2417,'1','303',1,'Retail Sale Id 2365',0.00,3971.50,720.00,4399.20,427.70,'2023-02-22 12:25:31'),(2418,'1','303',1,'Retail Sale Id 2366',0.00,8125.00,720.00,9000.00,875.00,'2023-02-22 12:30:35'),(2419,'1','303',1,'Retail Sale Id 2367',0.00,903.50,720.00,1000.80,97.30,'2023-02-22 12:35:08'),(2420,'1','303',1,'Retail Sale Id 2367',0.00,1352.00,720.00,1497.60,145.60,'2023-02-22 12:35:08'),(2421,'1','303',1,'Retail Sale Id 2368',0.00,2710.50,720.00,3002.40,291.90,'2023-02-22 12:58:50'),(2422,'1','303',1,'Retail Sale Id 2369',0.00,3250.00,720.00,3600.00,350.00,'2023-02-22 13:01:07'),(2423,'1','303',1,'Retail Sale Id 2369',0.00,3250.00,720.00,3600.00,350.00,'2023-02-22 13:01:07'),(2424,'1','303',1,'Retail Sale Id 2370',0.00,1950.00,720.00,2160.00,210.00,'2023-02-22 13:03:04'),(2425,'1','303',1,'Retail Sale Id 2371',0.00,903.50,720.00,1000.80,97.30,'2023-02-22 13:21:19'),(2426,'1','303',1,'Retail Sale Id 2372',0.00,3900.00,720.00,4320.00,420.00,'2023-02-22 13:23:03'),(2427,'1','303',1,'Retail Sale Id 2373',0.00,1352.00,720.00,1497.60,145.60,'2023-02-22 13:26:30'),(2428,'1','303',1,'Retail Sale Id 2374',0.00,3900.00,720.00,4320.00,420.00,'2023-02-22 13:41:13'),(2429,'1','303',1,'Retail Sale Id 2375',0.00,8125.00,720.00,9000.00,875.00,'2023-02-22 13:52:52'),(2430,'1','303',1,'Retail Sale Id 2376',0.00,1950.00,720.00,2160.00,210.00,'2023-02-22 13:54:50'),(2431,'1','303',1,'Retail Sale Id 2377',0.00,6500.00,720.00,7200.00,700.00,'2023-02-22 13:59:52'),(2432,'1','303',1,'Retail Sale Id 2378',0.00,3900.00,720.00,4320.00,420.00,'2023-02-22 14:05:20'),(2433,'1','303',1,'Retail Sale Id 2379',0.00,1950.00,720.00,2160.00,210.00,'2023-02-22 14:07:47'),(2434,'1','303',1,'Retail Sale Id 2380',0.00,5200.00,720.00,5760.00,560.00,'2023-02-22 14:10:09'),(2435,'1','303',1,'Retail Sale Id 2381',0.00,1807.00,720.00,2001.60,194.60,'2023-02-22 14:12:16'),(2436,'1','303',1,'Retail Sale Id 2383',0.00,3900.00,720.00,4320.00,420.00,'2023-02-22 14:14:57'),(2437,'1','303',1,'Retail Sale Id 2384',0.00,650.00,720.00,720.00,70.00,'2023-02-22 14:16:12'),(2438,'1','303',1,'Retail Sale Id 2385',0.00,1807.00,720.00,2001.60,194.60,'2023-02-22 14:47:20'),(2439,'1','303',1,'Retail Sale Id 2386',0.00,2710.50,720.00,3002.40,291.90,'2023-02-22 15:00:33'),(2440,'1','303',1,'Retail Sale Id 2387',0.00,1950.00,720.00,2160.00,210.00,'2023-02-22 15:13:37'),(2441,'1','303',1,'Retail Sale Id 2388',0.00,6500.00,720.00,7200.00,700.00,'2023-02-22 15:23:33'),(2442,'1','303',1,'Retail Sale Id 2389',0.00,3900.00,720.00,4320.00,420.00,'2023-02-22 15:26:58'),(2443,'1','303',1,'Retail Sale Id 2390',0.00,1950.00,720.00,2160.00,210.00,'2023-02-22 15:47:01'),(2444,'1','303',1,'Retail Sale Id 2391',0.00,3250.00,720.00,3600.00,350.00,'2023-02-22 15:59:45'),(2445,'1','303',1,'Retail Sale Id 2392',0.00,1950.00,720.00,2160.00,210.00,'2023-02-22 16:02:19'),(2446,'1','303',1,'Retail Sale Id 2393',0.00,3880.50,720.00,4298.40,417.90,'2023-02-22 16:10:53'),(2447,'1','303',1,'Retail Sale Id 2394',0.00,6500.00,720.00,7200.00,700.00,'2023-02-22 16:27:46'),(2448,'1','303',1,'Retail Sale Id 2395',0.00,650.00,720.00,720.00,70.00,'2023-02-22 16:29:24'),(2449,'1','303',1,'Return of Retail Sale Id 2394',6500.00,0.00,720.00,-7200.00,-700.00,'2023-02-22 16:33:50'),(2450,'1','303',1,'Retail Sale Id 2396',0.00,650.00,720.00,720.00,70.00,'2023-02-22 16:40:48'),(2451,'1','303',1,'Retail Sale Id 2397',0.00,8125.00,720.00,9000.00,875.00,'2023-02-22 16:42:41'),(2452,'1','303',1,'Retail Sale Id 2398',0.00,1950.00,720.00,2160.00,210.00,'2023-02-22 16:43:49'),(2453,'1','303',1,'Retail Sale Id 2399',0.00,1950.00,720.00,2160.00,210.00,'2023-02-22 16:47:26'),(2454,'1','303',1,'Retail Sale Id 2400',0.00,3926.00,720.00,4348.80,422.80,'2023-02-22 17:00:15'),(2455,'1','303',1,'Retail Sale Id 2401',0.00,1300.00,720.00,1440.00,140.00,'2023-02-22 17:08:27'),(2456,'1','303',1,'Retail Sale Id 2401',0.00,3250.00,720.00,3600.00,350.00,'2023-02-22 17:08:27'),(2457,'1','303',1,'Retail Sale Id 2403',0.00,5200.00,720.00,5760.00,560.00,'2023-02-22 17:13:58'),(2458,'1','303',1,'Retail Sale Id 2404',0.00,650.00,720.00,720.00,70.00,'2023-02-22 17:19:48'),(2459,'1','303',1,'Retail Sale Id 2404',0.00,5850.00,720.00,6480.00,630.00,'2023-02-22 17:19:48'),(2460,'1','303',1,'Retail Sale Id 2405',0.00,3900.00,720.00,4320.00,420.00,'2023-02-22 17:25:00'),(2461,'1','303',1,'Retail Sale Id 2407',0.00,8125.00,720.00,9000.00,875.00,'2023-02-22 17:32:17'),(2462,'1','303',1,'Retail Sale Id 2408',0.00,903.50,720.00,1000.80,97.30,'2023-02-22 17:33:58'),(2463,'1','303',1,'Retail Sale Id 2409',0.00,3250.00,720.00,3600.00,350.00,'2023-02-22 17:44:10'),(2464,'1','303',1,'Retail Sale Id 2410',0.00,3789.50,720.00,4197.60,408.10,'2023-02-22 17:49:26'),(2465,'1','303',1,'Retail Sale Id 2411',0.00,1261.00,720.00,1396.80,135.80,'2023-02-22 17:55:14'),(2466,'1','303',1,'Retail Sale Id 2412',0.00,1352.00,720.00,1497.60,145.60,'2023-02-22 17:58:08'),(2467,'1','303',1,'Retail Sale Id 2413',0.00,903.50,720.00,1000.80,97.30,'2023-02-22 18:17:50'),(2468,'1','303',1,'Retail Sale Id 2414',0.00,3900.00,720.00,4320.00,420.00,'2023-02-22 18:23:47'),(2469,'1','303',1,'Retail Sale Id 2415',0.00,3900.00,720.00,4320.00,420.00,'2023-02-22 18:27:16'),(2470,'1','303',1,'Retail Sale Id 2416',0.00,3250.00,720.00,3600.00,350.00,'2023-02-23 08:19:56'),(2471,'1','303',1,'Retail Sale Id 2417',0.00,3900.00,720.00,4320.00,420.00,'2023-02-23 08:32:43'),(2472,'1','303',1,'Retail Sale Id 2418',0.00,4550.00,720.00,5040.00,490.00,'2023-02-23 08:34:48'),(2473,'1','303',1,'Retail Sale Id 2419',0.00,3900.00,720.00,4320.00,420.00,'2023-02-23 08:46:09'),(2474,'1','303',1,'Retail Sale Id 2419',0.00,6500.00,720.00,7200.00,700.00,'2023-02-23 08:46:09'),(2475,'1','303',1,'Retail Sale Id 2420',0.00,3900.00,720.00,4320.00,420.00,'2023-02-23 09:15:20'),(2476,'1','303',1,'Retail Sale Id 2420',0.00,6500.00,720.00,7200.00,700.00,'2023-02-23 09:15:20'),(2477,'1','303',1,'Retail Sale Id 2421',0.00,6500.00,720.00,7200.00,700.00,'2023-02-23 09:38:42'),(2478,'1','303',1,'Retail Sale Id 2422',0.00,1300.00,720.00,1440.00,140.00,'2023-02-23 09:54:43'),(2479,'1','303',1,'Retail Sale Id 2423',0.00,1176.50,720.00,1303.20,126.70,'2023-02-23 09:56:57'),(2480,'1','303',1,'Retail Sale Id 2424',0.00,1807.00,720.00,2001.60,194.60,'2023-02-23 10:06:53'),(2481,'1','303',1,'Retail Sale Id 2425',0.00,1950.00,720.00,2160.00,210.00,'2023-02-23 10:23:20'),(2482,'1','303',1,'Retail Sale Id 2427',0.00,3900.00,720.00,4320.00,420.00,'2023-02-23 10:59:20'),(2483,'1','303',1,'Retail Sale Id 2428',0.00,8125.00,720.00,9000.00,875.00,'2023-02-23 11:02:01'),(2484,'1','303',1,'Retail Sale Id 2429',0.00,3250.00,720.00,3600.00,350.00,'2023-02-23 11:07:59'),(2485,'1','303',1,'Retail Sale Id 2430',0.00,1950.00,720.00,2160.00,210.00,'2023-02-23 11:13:21'),(2486,'1','303',1,'Retail Sale Id 2431',0.00,1300.00,720.00,1440.00,140.00,'2023-02-23 11:14:49'),(2487,'1','303',1,'Retail Sale Id 2432',0.00,3900.00,720.00,4320.00,420.00,'2023-02-23 11:17:31'),(2488,'1','303',1,'Retail Sale Id 2433',0.00,1950.00,720.00,2160.00,210.00,'2023-02-23 11:26:21'),(2489,'1','303',1,'Retail Sale Id 2434',0.00,1950.00,720.00,2160.00,210.00,'2023-02-23 11:33:18'),(2490,'1','303',1,'Retail Sale Id 2436',0.00,1352.00,720.00,1497.60,145.60,'2023-02-23 11:45:32'),(2491,'1','303',1,'Retail Sale Id 2437',0.00,4062.50,720.00,4500.00,437.50,'2023-02-23 11:51:18'),(2492,'1','303',1,'Retail Sale Id 2438',0.00,8125.00,720.00,9000.00,875.00,'2023-02-23 12:07:48'),(2493,'1','303',1,'Retail Sale Id 2439',0.00,3250.00,720.00,3600.00,350.00,'2023-02-23 12:15:48'),(2494,'1','303',1,'Retail Sale Id 2440',0.00,3250.00,720.00,3600.00,350.00,'2023-02-23 13:14:52'),(2495,'1','303',1,'Retail Sale Id 2441',0.00,8125.00,720.00,9000.00,875.00,'2023-02-23 13:16:20'),(2496,'1','303',1,'Retail Sale Id 2442',0.00,3900.00,720.00,4320.00,420.00,'2023-02-23 13:32:51'),(2497,'1','303',1,'Retail Sale Id 2443',0.00,8125.00,720.00,9000.00,875.00,'2023-02-23 13:37:33'),(2498,'1','303',1,'Retail Sale Id 2444',0.00,3900.00,720.00,4320.00,420.00,'2023-02-23 13:42:40'),(2499,'1','303',1,'Retail Sale Id 2445',0.00,81250.00,720.00,90000.00,8750.00,'2023-02-23 14:00:29'),(2500,'1','303',1,'Retail Sale Id 2446',0.00,8125.00,720.00,9000.00,875.00,'2023-02-23 14:01:31'),(2501,'1','303',1,'Return of Retail Sale Id 2445',81250.00,0.00,720.00,-90000.00,-8750.00,'2023-02-23 14:03:03'),(2502,'1','303',1,'Retail Sale Id 2447',0.00,6500.00,720.00,7200.00,700.00,'2023-02-23 14:10:58'),(2503,'1','303',1,'Retail Sale Id 2448',0.00,1989.00,720.00,2203.20,214.20,'2023-02-23 14:13:04'),(2504,'1','303',1,'Retail Sale Id 2449',0.00,195000.00,690.00,207000.00,12000.00,'2023-02-23 14:28:19'),(2505,'1','303',1,'Retail Sale Id 2450',0.00,552500.00,690.00,586500.00,34000.00,'2023-02-23 14:31:37'),(2506,'1','303',1,'Retail Sale Id 2451',0.00,3900.00,720.00,4320.00,420.00,'2023-02-23 14:33:43'),(2507,'1','303',1,'Retail Sale Id 2452',0.00,8125.00,720.00,9000.00,875.00,'2023-02-23 14:36:16'),(2508,'1','303',1,'Retail Sale Id 2453',0.00,2600.00,720.00,2880.00,280.00,'2023-02-23 14:42:36'),(2509,'1','303',1,'Retail Sale Id 2454',0.00,3250.00,720.00,3600.00,350.00,'2023-02-23 14:50:59'),(2510,'1','303',1,'Retail Sale Id 2454',0.00,3900.00,720.00,4320.00,420.00,'2023-02-23 14:50:59'),(2511,'1','303',1,'Retail Sale Id 2455',0.00,3900.00,720.00,4320.00,420.00,'2023-02-23 14:54:17'),(2512,'1','303',1,'Retail Sale Id 2455',0.00,3900.00,720.00,4320.00,420.00,'2023-02-23 14:54:17'),(2513,'1','303',1,'Retail Sale Id 2456',0.00,8125.00,720.00,9000.00,875.00,'2023-02-23 15:07:15'),(2514,'1','303',1,'Retail Sale Id 2457',0.00,1807.00,720.00,2001.60,194.60,'2023-02-23 15:10:37'),(2515,'1','303',1,'Retail Sale Id 2458',0.00,1950.00,720.00,2160.00,210.00,'2023-02-23 15:16:33'),(2516,'1','303',1,'Retail Sale Id 2458',0.00,3900.00,720.00,4320.00,420.00,'2023-02-23 15:16:33'),(2517,'1','303',1,'Retail Sale Id 2459',0.00,1300.00,720.00,1440.00,140.00,'2023-02-23 15:20:09'),(2518,'1','303',1,'Retail Sale Id 2460',0.00,3900.00,720.00,4320.00,420.00,'2023-02-23 15:49:36'),(2519,'1','303',1,'Retail Sale Id 2461',0.00,97500.00,690.00,103500.00,6000.00,'2023-02-23 15:53:39'),(2520,'1','303',1,'Retail Sale Id 2462',0.00,3575.00,690.00,3795.00,220.00,'2023-02-23 16:02:28'),(2521,'1','303',1,'Retail Sale Id 2463',0.00,1950.00,720.00,2160.00,210.00,'2023-02-23 16:18:21'),(2522,'1','303',1,'Retail Sale Id 2464',0.00,8125.00,720.00,9000.00,875.00,'2023-02-23 16:25:27'),(2523,'1','303',1,'Retail Sale Id 2465',0.00,32500.00,690.00,34500.00,2000.00,'2023-02-23 16:38:31'),(2524,'1','303',1,'Retail Sale Id 2466',0.00,3900.00,720.00,4320.00,420.00,'2023-02-23 16:40:32'),(2525,'1','303',1,'Retail Sale Id 2467',0.00,8125.00,720.00,9000.00,875.00,'2023-02-23 16:51:41'),(2526,'1','303',1,'Retail Sale Id 2468',0.00,3900.00,720.00,4320.00,420.00,'2023-02-23 16:54:06'),(2527,'1','303',1,'Retail Sale Id 2469',0.00,1950.00,720.00,2160.00,210.00,'2023-02-23 17:00:48'),(2528,'1','303',1,'Retail Sale Id 2469',0.00,3900.00,720.00,4320.00,420.00,'2023-02-23 17:00:48'),(2529,'1','303',1,'Retail Sale Id 2470',0.00,1950.00,720.00,2160.00,210.00,'2023-02-23 17:11:08'),(2530,'1','303',1,'Retail Sale Id 2470',0.00,3900.00,720.00,4320.00,420.00,'2023-02-23 17:11:08'),(2531,'1','303',1,'Retail Sale Id 2471',0.00,1625.00,720.00,1800.00,175.00,'2023-02-23 17:12:33'),(2532,'1','303',1,'Retail Sale Id 2472',0.00,3900.00,720.00,4320.00,420.00,'2023-02-23 17:19:35'),(2533,'1','303',1,'Retail Sale Id 2473',0.00,1950.00,720.00,2160.00,210.00,'2023-02-23 17:21:38'),(2534,'1','303',1,'Retail Sale Id 2474',0.00,3250.00,720.00,3600.00,350.00,'2023-02-23 17:34:06'),(2535,'1','303',1,'Retail Sale Id 2475',0.00,3900.00,720.00,4320.00,420.00,'2023-02-23 17:38:53'),(2536,'1','303',1,'Retail Sale Id 2476',0.00,3250.00,720.00,3600.00,350.00,'2023-02-23 17:42:59'),(2537,'1','303',1,'Retail Sale Id 2477',0.00,3900.00,720.00,4320.00,420.00,'2023-02-23 17:45:11'),(2538,'1','303',1,'Retail Sale Id 2478',0.00,3900.00,720.00,4320.00,420.00,'2023-02-23 17:47:49'),(2539,'1','303',1,'Retail Sale Id 2479',0.00,4062.50,720.00,4500.00,437.50,'2023-02-23 17:55:27'),(2540,'1','303',1,'Retail Sale Id 2480',0.00,1807.00,720.00,2001.60,194.60,'2023-02-23 18:03:15'),(2541,'1','303',1,'Retail Sale Id 2481',0.00,650.00,720.00,720.00,70.00,'2023-02-23 18:06:43'),(2542,'1','303',1,'Retail Sale Id 2482',0.00,3614.00,720.00,4003.20,389.20,'2023-02-23 18:11:21'),(2543,'1','303',1,'Retail Sale Id 2483',0.00,1807.00,720.00,2001.60,194.60,'2023-02-23 19:16:32'),(2544,'1','303',1,'Retail Sale Id 2484',0.00,4550.00,720.00,5040.00,490.00,'2023-02-24 08:02:12'),(2545,'1','303',1,'Retail Sale Id 2485',0.00,3900.00,720.00,4320.00,420.00,'2023-02-24 08:03:12'),(2546,'1','303',1,'Retail Sale Id 2487',0.00,37700.00,690.00,40020.00,2320.00,'2023-02-24 08:28:15'),(2547,'1','303',1,'Retail Sale Id 2488',0.00,1950.00,720.00,2160.00,210.00,'2023-02-24 08:42:09'),(2548,'1','303',1,'Retail Sale Id 2489',0.00,2710.50,720.00,3002.40,291.90,'2023-02-24 09:04:16'),(2549,'1','303',1,'Retail Sale Id 2490',0.00,1950.00,720.00,2160.00,210.00,'2023-02-24 09:16:39'),(2550,'1','303',1,'Retail Sale Id 2491',0.00,1352.00,720.00,1497.60,145.60,'2023-02-24 09:34:02'),(2551,'1','303',1,'Retail Sale Id 2492',0.00,3900.00,720.00,4320.00,420.00,'2023-02-24 09:35:00'),(2552,'1','303',1,'Retail Sale Id 2493',0.00,3900.00,720.00,4320.00,420.00,'2023-02-24 09:36:03'),(2553,'1','303',1,'Retail Sale Id 2494',0.00,3900.00,720.00,4320.00,420.00,'2023-02-24 09:45:24'),(2554,'1','303',1,'Retail Sale Id 2495',0.00,4550.00,720.00,5040.00,490.00,'2023-02-24 09:51:23'),(2555,'1','303',1,'Retail Sale Id 2496',0.00,994.50,720.00,1101.60,107.10,'2023-02-24 09:56:49'),(2556,'1','303',1,'Retail Sale Id 2497',0.00,2600.00,720.00,2880.00,280.00,'2023-02-24 10:00:23'),(2557,'1','303',1,'Retail Sale Id 2498',0.00,2255.50,720.00,2498.40,242.90,'2023-02-24 10:11:32'),(2558,'1','303',1,'Retail Sale Id 2499',0.00,903.50,720.00,1000.80,97.30,'2023-02-24 10:23:32'),(2559,'1','303',1,'Retail Sale Id 2500',0.00,1950.00,720.00,2160.00,210.00,'2023-02-24 10:49:41'),(2560,'1','303',1,'Retail Sale Id 2501',0.00,1950.00,720.00,2160.00,210.00,'2023-02-24 10:53:21'),(2561,'1','303',1,'Retail Sale Id 2502',0.00,3900.00,720.00,4320.00,420.00,'2023-02-24 10:58:55'),(2562,'1','303',1,'Retail Sale Id 2503',0.00,8125.00,720.00,9000.00,875.00,'2023-02-24 11:10:53'),(2563,'1','303',1,'Retail Sale Id 2504',0.00,6500.00,720.00,7200.00,700.00,'2023-02-24 11:13:27'),(2564,'1','303',1,'Retail Sale Id 2505',0.00,1950.00,720.00,2160.00,210.00,'2023-02-24 11:18:50'),(2565,'1','303',1,'Retail Sale Id 2506',0.00,3900.00,720.00,4320.00,420.00,'2023-02-24 11:31:42'),(2566,'1','303',1,'Retail Sale Id 2507',0.00,3900.00,720.00,4320.00,420.00,'2023-02-24 11:34:59'),(2567,'1','303',1,'Retail Sale Id 2508',0.00,3900.00,720.00,4320.00,420.00,'2023-02-24 11:37:16'),(2568,'1','303',1,'Retail Sale Id 2509',0.00,1950.00,720.00,2160.00,210.00,'2023-02-24 11:39:46'),(2569,'1','303',1,'Retail Sale Id 2510',0.00,1950.00,720.00,2160.00,210.00,'2023-02-24 11:54:28'),(2570,'1','303',1,'Retail Sale Id 2511',0.00,3900.00,720.00,4320.00,420.00,'2023-02-24 11:59:18'),(2571,'1','303',1,'Retail Sale Id 2512',0.00,1950.00,720.00,2160.00,210.00,'2023-02-24 12:21:08'),(2572,'1','303',1,'Retail Sale Id 2513',0.00,6825.00,720.00,7560.00,735.00,'2023-02-24 12:33:07'),(2573,'1','303',1,'Retail Sale Id 2514',0.00,6318.00,720.00,6998.40,680.40,'2023-02-24 12:45:20'),(2574,'1','303',1,'Retail Sale Id 2514',0.00,6318.00,720.00,6998.40,680.40,'2023-02-24 12:45:20'),(2575,'1','303',1,'Retail Sale Id 2514',0.00,6318.00,720.00,6998.40,680.40,'2023-02-24 12:45:20'),(2576,'1','303',1,'Retail Sale Id 2515',0.00,4511.00,720.00,4996.80,485.80,'2023-02-24 13:00:56'),(2577,'1','303',1,'Retail Sale Id 2516',0.00,1807.00,720.00,2001.60,194.60,'2023-02-24 13:10:14'),(2578,'1','303',1,'Retail Sale Id 2517',0.00,1950.00,720.00,2160.00,210.00,'2023-02-24 13:39:39'),(2579,'1','303',1,'Retail Sale Id 2518',0.00,24375.00,720.00,27000.00,2625.00,'2023-02-24 13:44:37'),(2580,'1','303',1,'Retail Sale Id 2519',0.00,8125.00,720.00,9000.00,875.00,'2023-02-24 13:56:22'),(2581,'1','303',1,'Retail Sale Id 2520',0.00,4875.00,720.00,5400.00,525.00,'2023-02-24 14:14:46'),(2582,'1','303',1,'Retail Sale Id 2521',0.00,3900.00,720.00,4320.00,420.00,'2023-02-24 14:16:32'),(2583,'1','303',1,'Retail Sale Id 2522',0.00,1950.00,720.00,2160.00,210.00,'2023-02-24 14:18:34'),(2584,'1','303',1,'Retail Sale Id 2523',0.00,3250.00,720.00,3600.00,350.00,'2023-02-24 14:25:35'),(2585,'1','303',1,'Retail Sale Id 2524',0.00,1950.00,720.00,2160.00,210.00,'2023-02-24 14:27:58'),(2586,'1','303',1,'Retail Sale Id 2525',0.00,1950.00,720.00,2160.00,210.00,'2023-02-24 14:44:10'),(2587,'1','303',1,'Retail Sale Id 2526',0.00,1950.00,720.00,2160.00,210.00,'2023-02-24 14:54:25'),(2588,'1','303',1,'Retail Sale Id 2527',0.00,3900.00,720.00,4320.00,420.00,'2023-02-24 15:09:05'),(2589,'1','303',1,'Retail Sale Id 2528',0.00,903.50,720.00,1000.80,97.30,'2023-02-24 15:14:02'),(2590,'1','303',1,'Retail Sale Id 2529',0.00,3900.00,720.00,4320.00,420.00,'2023-02-24 15:17:24'),(2591,'1','303',1,'Retail Sale Id 2530',0.00,3900.00,720.00,4320.00,420.00,'2023-02-24 15:18:30'),(2592,'1','303',1,'Retail Sale Id 2531',0.00,1950.00,720.00,2160.00,210.00,'2023-02-24 15:20:32'),(2593,'1','303',1,'Retail Sale Id 2532',0.00,32500.00,690.00,34500.00,2000.00,'2023-02-24 15:28:28'),(2594,'1','303',1,'Retail Sale Id 2533',0.00,2255.50,720.00,2498.40,242.90,'2023-02-24 15:29:32'),(2595,'1','303',1,'Retail Sale Id 2534',0.00,3250.00,720.00,3600.00,350.00,'2023-02-24 15:31:15'),(2596,'1','303',1,'Retail Sale Id 2535',0.00,8125.00,720.00,9000.00,875.00,'2023-02-24 15:32:23'),(2597,'1','303',1,'Retail Sale Id 2536',0.00,1950.00,720.00,2160.00,210.00,'2023-02-24 15:34:29'),(2598,'1','303',1,'Retail Sale Id 2536',0.00,2600.00,720.00,2880.00,280.00,'2023-02-24 15:34:29'),(2599,'1','303',1,'Retail Sale Id 2537',0.00,1352.00,720.00,1497.60,145.60,'2023-02-24 15:36:27'),(2600,'1','303',1,'Retail Sale Id 2538',0.00,1950.00,720.00,2160.00,210.00,'2023-02-24 15:38:50'),(2601,'1','303',1,'Retail Sale Id 2539',0.00,5414.50,720.00,5997.60,583.10,'2023-02-24 15:42:00'),(2602,'1','303',1,'Retail Sale Id 2540',0.00,3900.00,720.00,4320.00,420.00,'2023-02-24 15:43:31'),(2603,'1','303',1,'Retail Sale Id 2541',0.00,8125.00,720.00,9000.00,875.00,'2023-02-24 15:45:11'),(2604,'1','303',1,'Retail Sale Id 2542',0.00,3900.00,720.00,4320.00,420.00,'2023-02-24 15:50:35'),(2605,'1','303',1,'Retail Sale Id 2543',0.00,8125.00,720.00,9000.00,875.00,'2023-02-24 16:20:11'),(2606,'1','303',1,'Retail Sale Id 2544',0.00,3900.00,720.00,4320.00,420.00,'2023-02-24 16:33:03'),(2607,'1','303',1,'Retail Sale Id 2545',0.00,3614.00,720.00,4003.20,389.20,'2023-02-24 16:41:54'),(2608,'1','303',1,'Retail Sale Id 2546',0.00,3900.00,720.00,4320.00,420.00,'2023-02-24 16:42:53'),(2609,'1','303',1,'Retail Sale Id 2547',0.00,3900.00,720.00,4320.00,420.00,'2023-02-24 16:50:16'),(2610,'1','303',1,'Retail Sale Id 2548',0.00,3614.00,720.00,4003.20,389.20,'2023-02-24 16:53:04'),(2611,'1','303',1,'Retail Sale Id 2549',0.00,8125.00,720.00,9000.00,875.00,'2023-02-24 16:55:28'),(2612,'1','303',1,'Retail Sale Id 2550',0.00,3900.00,720.00,4320.00,420.00,'2023-02-24 17:21:35'),(2613,'1','303',1,'Retail Sale Id 2551',0.00,903.50,720.00,1000.80,97.30,'2023-02-24 17:22:39'),(2614,'1','303',1,'Retail Sale Id 2552',0.00,2710.50,720.00,3002.40,291.90,'2023-02-24 17:32:40'),(2615,'1','303',1,'Retail Sale Id 2553',0.00,8125.00,720.00,9000.00,875.00,'2023-02-24 17:36:45'),(2616,'1','303',1,'Retail Sale Id 2554',0.00,3900.00,720.00,4320.00,420.00,'2023-02-24 17:58:25'),(2617,'1','303',1,'Retail Sale Id 2555',0.00,7150.00,720.00,7920.00,770.00,'2023-02-24 18:02:47'),(2618,'1','303',1,'Retail Sale Id 2556',0.00,3900.00,720.00,4320.00,420.00,'2023-02-24 18:04:00'),(2619,'1','303',1,'Retail Sale Id 2557',0.00,3900.00,720.00,4320.00,420.00,'2023-02-24 18:07:02'),(2620,'1','303',1,'Retail Sale Id 2558',0.00,903.50,720.00,1000.80,97.30,'2023-02-24 18:08:26'),(2621,'1','303',1,'Retail Sale Id 2559',0.00,1950.00,720.00,2160.00,210.00,'2023-02-24 18:09:25'),(2622,'1','303',1,'Retail Sale Id 2560',0.00,1807.00,720.00,2001.60,194.60,'2023-02-24 18:16:10'),(2623,'1','303',1,'Retail Sale Id 2561',0.00,1807.00,720.00,2001.60,194.60,'2023-02-24 18:17:35'),(2624,'1','303',1,'Retail Sale Id 2562',0.00,3250.00,720.00,3600.00,350.00,'2023-02-24 18:18:33'),(2625,'1','303',1,'Retail Sale Id 2563',0.00,552500.00,690.00,586500.00,34000.00,'2023-02-24 19:03:25'),(2626,'1','303',1,'Return of Retail Sale Id 2558',903.50,0.00,720.00,-1000.80,-97.30,'2023-02-24 19:34:58'),(2627,'1','303',1,'Retail Sale Id 2564',0.00,624.00,720.00,691.20,67.20,'2023-02-24 19:35:46'),(2628,'1','303',1,'Retail Sale Id 2565',0.00,650.00,690.00,690.00,40.00,'2023-02-24 19:52:16'),(2629,'1','303',1,'Return of Retail Sale Id 2565',650.00,0.00,690.00,-690.00,-40.00,'2023-02-24 20:04:33'),(2630,'1','303',1,'Retail Sale Id 2566',0.00,8125.00,720.00,9000.00,875.00,'2023-02-26 12:06:29'),(2631,'1','303',1,'Retail Sale Id 2567',0.00,8125.00,720.00,9000.00,875.00,'2023-02-26 12:08:02'),(2632,'1','303',1,'Retail Sale Id 2568',0.00,2255.50,720.00,2498.40,242.90,'2023-02-26 12:09:38'),(2633,'1','303',1,'Retail Sale Id 2569',0.00,3250.00,720.00,3600.00,350.00,'2023-02-26 12:18:14'),(2634,'1','303',1,'Retail Sale Id 2570',0.00,8125.00,720.00,9000.00,875.00,'2023-02-26 12:19:18'),(2635,'1','303',1,'Retail Sale Id 2571',0.00,650.00,720.00,720.00,70.00,'2023-02-26 12:20:54'),(2636,'1','303',1,'Retail Sale Id 2572',0.00,3250.00,720.00,3600.00,350.00,'2023-02-26 12:22:22'),(2637,'1','303',1,'Retail Sale Id 2572',0.00,3900.00,720.00,4320.00,420.00,'2023-02-26 12:22:22'),(2638,'1','303',1,'Retail Sale Id 2573',0.00,7150.00,720.00,7920.00,770.00,'2023-02-26 12:23:48'),(2639,'1','303',1,'Retail Sale Id 2574',0.00,3900.00,720.00,4320.00,420.00,'2023-02-26 12:25:13'),(2640,'1','303',1,'Retail Sale Id 2575',0.00,5200.00,690.00,5520.00,320.00,'2023-02-26 12:27:24'),(2641,'1','303',1,'Retail Sale Id 2576',0.00,630.50,720.00,698.40,67.90,'2023-02-26 12:33:12'),(2642,'1','303',1,'Retail Sale Id 2577',0.00,1950.00,720.00,2160.00,210.00,'2023-02-26 12:34:16'),(2643,'1','303',1,'Retail Sale Id 2578',0.00,903.50,720.00,1000.80,97.30,'2023-02-26 12:35:27'),(2644,'1','303',1,'Retail Sale Id 2579',0.00,5850.00,720.00,6480.00,630.00,'2023-02-26 12:38:11'),(2645,'1','303',1,'Retail Sale Id 2580',0.00,3250.00,720.00,3600.00,350.00,'2023-02-26 12:40:02'),(2646,'1','303',1,'Retail Sale Id 2581',0.00,1950.00,720.00,2160.00,210.00,'2023-02-26 12:41:22'),(2647,'1','303',1,'Retail Sale Id 2582',0.00,3900.00,720.00,4320.00,420.00,'2023-02-26 12:44:45'),(2648,'1','303',1,'Retail Sale Id 2582',0.00,3900.00,720.00,4320.00,420.00,'2023-02-26 12:44:45'),(2649,'1','303',1,'Retail Sale Id 2583',0.00,1950.00,720.00,2160.00,210.00,'2023-02-26 12:45:56'),(2650,'1','303',1,'Retail Sale Id 2584',0.00,2255.50,720.00,2498.40,242.90,'2023-02-26 12:49:19'),(2651,'1','303',1,'Retail Sale Id 2585',0.00,2678.00,720.00,2966.40,288.40,'2023-02-26 19:44:24'),(2652,'1','303',1,'Return of Retail Sale Id 2585',2678.00,0.00,720.00,-2966.40,-288.40,'2023-02-26 19:48:09'),(2653,'1','303',1,'Return of Retail Sale Id 2584',2255.50,0.00,720.00,-2498.40,-242.90,'2023-02-26 19:49:44'),(2654,'1','303',1,'Return of Retail Sale Id 2578',903.50,0.00,720.00,-1000.80,-97.30,'2023-02-26 19:50:52'),(2655,'1','303',1,'Retail Sale Id 2586',0.00,858.00,720.00,950.40,92.40,'2023-02-26 19:51:28'),(2656,'1','303',1,'Retail Sale Id 2587',0.00,4511.00,720.00,4996.80,485.80,'2023-02-27 08:17:43'),(2657,'1','303',1,'Retail Sale Id 2588',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 08:33:54'),(2658,'1','303',1,'Retail Sale Id 2589',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 08:51:56'),(2659,'1','303',1,'Retail Sale Id 2590',0.00,3250.00,720.00,3600.00,350.00,'2023-02-27 09:06:23'),(2660,'1','303',1,'Retail Sale Id 2591',0.00,903.50,720.00,1000.80,97.30,'2023-02-27 09:08:50'),(2661,'1','303',1,'Retail Sale Id 2592',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 09:11:00'),(2662,'1','303',1,'Retail Sale Id 2593',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 09:13:23'),(2663,'1','303',1,'Retail Sale Id 2593',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 09:13:23'),(2664,'1','303',1,'Retail Sale Id 2594',0.00,3250.00,720.00,3600.00,350.00,'2023-02-27 09:19:41'),(2665,'1','303',1,'Retail Sale Id 2595',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 09:22:09'),(2666,'1','303',1,'Retail Sale Id 2596',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 09:41:10'),(2667,'1','303',1,'Retail Sale Id 2597',0.00,630.50,720.00,698.40,67.90,'2023-02-27 09:53:19'),(2668,'1','303',1,'Retail Sale Id 2598',0.00,1807.00,720.00,2001.60,194.60,'2023-02-27 09:57:46'),(2669,'1','303',1,'Retail Sale Id 2599',0.00,7150.00,720.00,7920.00,770.00,'2023-02-27 09:59:50'),(2670,'1','303',1,'Retail Sale Id 2599',0.00,8125.00,720.00,9000.00,875.00,'2023-02-27 09:59:50'),(2671,'1','303',1,'Retail Sale Id 2600',0.00,1300.00,720.00,1440.00,140.00,'2023-02-27 10:02:01'),(2672,'1','303',1,'Retail Sale Id 2601',0.00,3250.00,720.00,3600.00,350.00,'2023-02-27 10:09:20'),(2673,'1','303',1,'Retail Sale Id 2602',0.00,1807.00,720.00,2001.60,194.60,'2023-02-27 10:16:43'),(2674,'1','303',1,'Retail Sale Id 2603',0.00,1943.50,720.00,2152.80,209.30,'2023-02-27 10:18:24'),(2675,'1','303',1,'Retail Sale Id 2604',0.00,3250.00,720.00,3600.00,350.00,'2023-02-27 10:20:39'),(2676,'1','303',1,'Retail Sale Id 2605',0.00,650.00,720.00,720.00,70.00,'2023-02-27 10:23:08'),(2677,'1','303',1,'Retail Sale Id 2606',0.00,65000.00,690.00,69000.00,4000.00,'2023-02-27 10:27:48'),(2678,'1','303',1,'Retail Sale Id 2607',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 10:29:30'),(2679,'1','303',1,'Retail Sale Id 2608',0.00,6500.00,720.00,7200.00,700.00,'2023-02-27 10:31:14'),(2680,'1','303',1,'Retail Sale Id 2609',0.00,2600.00,720.00,2880.00,280.00,'2023-02-27 10:32:23'),(2681,'1','303',1,'Retail Sale Id 2610',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 10:33:37'),(2682,'1','303',1,'Retail Sale Id 2611',0.00,32500.00,690.00,34500.00,2000.00,'2023-02-27 10:37:04'),(2683,'1','303',1,'Retail Sale Id 2612',0.00,1807.00,720.00,2001.60,194.60,'2023-02-27 10:49:14'),(2684,'1','303',1,'Retail Sale Id 2613',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 11:02:23'),(2685,'1','303',1,'Retail Sale Id 2614',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 11:09:28'),(2686,'1','303',1,'Retail Sale Id 2615',0.00,3250.00,720.00,3600.00,350.00,'2023-02-27 11:14:53'),(2687,'1','303',1,'Retail Sale Id 2616',0.00,3250.00,720.00,3600.00,350.00,'2023-02-27 11:19:45'),(2688,'1','303',1,'Retail Sale Id 2618',0.00,1300.00,720.00,1440.00,140.00,'2023-02-27 11:21:50'),(2689,'1','303',1,'Retail Sale Id 2619',0.00,6500.00,720.00,7200.00,700.00,'2023-02-27 11:24:29'),(2690,'1','303',1,'Retail Sale Id 2620',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 11:25:56'),(2691,'1','303',1,'Retail Sale Id 2621',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 11:27:04'),(2692,'1','303',1,'Retail Sale Id 2622',0.00,8125.00,720.00,9000.00,875.00,'2023-02-27 11:28:13'),(2693,'1','303',1,'Retail Sale Id 2623',0.00,3250.00,720.00,3600.00,350.00,'2023-02-27 11:29:46'),(2694,'1','303',1,'Retail Sale Id 2624',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 11:31:14'),(2695,'1','303',1,'Retail Sale Id 2625',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 11:35:51'),(2696,'1','303',1,'Retail Sale Id 2626',0.00,1989.00,720.00,2203.20,214.20,'2023-02-27 11:40:13'),(2697,'1','303',1,'Retail Sale Id 2627',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 11:42:40'),(2698,'1','303',1,'Retail Sale Id 2628',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 11:47:43'),(2699,'1','303',1,'Retail Sale Id 2628',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 11:47:43'),(2700,'1','303',1,'Retail Sale Id 2629',0.00,162500.00,690.00,172500.00,10000.00,'2023-02-27 11:55:37'),(2701,'1','303',1,'Retail Sale Id 2630',0.00,130000.00,690.00,138000.00,8000.00,'2023-02-27 12:01:19'),(2702,'1','303',1,'Retail Sale Id 2631',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 12:02:50'),(2703,'1','303',1,'Retail Sale Id 2632',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 12:04:19'),(2704,'1','303',1,'Retail Sale Id 2633',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 12:05:55'),(2705,'1','303',1,'Retail Sale Id 2634',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 12:07:53'),(2706,'1','303',1,'Retail Sale Id 2635',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 12:10:45'),(2707,'1','303',1,'Retail Sale Id 2636',0.00,8125.00,720.00,9000.00,875.00,'2023-02-27 12:12:20'),(2708,'1','303',1,'Retail Sale Id 2637',0.00,65000.00,690.00,69000.00,4000.00,'2023-02-27 12:13:36'),(2709,'1','303',1,'Retail Sale Id 2638',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 12:20:02'),(2710,'1','303',1,'Retail Sale Id 2639',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 12:27:32'),(2711,'1','303',1,'Retail Sale Id 2640',0.00,2710.50,720.00,3002.40,291.90,'2023-02-27 12:35:28'),(2712,'1','303',1,'Retail Sale Id 2641',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 12:52:22'),(2713,'1','303',1,'Retail Sale Id 2641',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 12:52:22'),(2714,'1','303',1,'Retail Sale Id 2641',0.00,3250.00,720.00,3600.00,350.00,'2023-02-27 12:52:22'),(2715,'1','303',1,'Retail Sale Id 2641',0.00,5200.00,720.00,5760.00,560.00,'2023-02-27 12:52:22'),(2716,'1','303',1,'Retail Sale Id 2642',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 12:55:30'),(2717,'1','303',1,'Retail Sale Id 2643',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 12:58:36'),(2718,'1','303',1,'Retail Sale Id 2644',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 13:00:15'),(2719,'1','303',1,'Retail Sale Id 2645',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 13:01:36'),(2720,'1','303',1,'Retail Sale Id 2646',0.00,1807.00,720.00,2001.60,194.60,'2023-02-27 13:14:52'),(2721,'1','303',1,'Retail Sale Id 2647',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 13:25:49'),(2722,'1','303',1,'Retail Sale Id 2648',0.00,2600.00,720.00,2880.00,280.00,'2023-02-27 13:29:30'),(2723,'1','303',1,'Retail Sale Id 2648',0.00,8125.00,720.00,9000.00,875.00,'2023-02-27 13:29:30'),(2724,'1','303',1,'Retail Sale Id 2649',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 13:37:30'),(2725,'1','303',1,'Retail Sale Id 2650',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 13:39:33'),(2726,'1','303',1,'Retail Sale Id 2651',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 13:41:10'),(2727,'1','303',1,'Return of Retail Sale Id 2649',3900.00,0.00,720.00,-4320.00,-420.00,'2023-02-27 13:42:47'),(2728,'1','303',1,'Retail Sale Id 2652',0.00,4062.50,720.00,4500.00,437.50,'2023-02-27 13:47:28'),(2729,'1','303',1,'Retail Sale Id 2653',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 14:02:05'),(2730,'1','303',1,'Retail Sale Id 2654',0.00,8125.00,720.00,9000.00,875.00,'2023-02-27 14:08:12'),(2731,'1','303',1,'Retail Sale Id 2655',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 14:12:52'),(2732,'1','303',1,'Retail Sale Id 2656',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 14:15:42'),(2733,'1','303',1,'Retail Sale Id 2657',0.00,1807.00,720.00,2001.60,194.60,'2023-02-27 14:18:59'),(2734,'1','303',1,'Retail Sale Id 2658',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 14:20:31'),(2735,'1','303',1,'Retail Sale Id 2659',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 14:23:17'),(2736,'1','303',1,'Retail Sale Id 2660',0.00,1352.00,720.00,1497.60,145.60,'2023-02-27 14:45:29'),(2737,'1','303',1,'Retail Sale Id 2661',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 14:49:16'),(2738,'1','303',1,'Retail Sale Id 2662',0.00,1352.00,720.00,1497.60,145.60,'2023-02-27 14:58:43'),(2739,'1','303',1,'Retail Sale Id 2663',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 15:10:30'),(2740,'1','303',1,'Retail Sale Id 2664',0.00,1898.00,720.00,2102.40,204.40,'2023-02-27 15:24:35'),(2741,'1','303',1,'Retail Sale Id 2665',0.00,3250.00,720.00,3600.00,350.00,'2023-02-27 15:31:24'),(2742,'1','303',1,'Retail Sale Id 2666',0.00,1352.00,720.00,1497.60,145.60,'2023-02-27 15:59:27'),(2743,'1','303',1,'Retail Sale Id 2667',0.00,903.50,720.00,1000.80,97.30,'2023-02-27 16:00:23'),(2744,'1','303',1,'Retail Sale Id 2668',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 16:02:39'),(2745,'1','303',1,'Retail Sale Id 2669',0.00,8125.00,720.00,9000.00,875.00,'2023-02-27 16:03:34'),(2746,'1','303',1,'Retail Sale Id 2670',0.00,6500.00,720.00,7200.00,700.00,'2023-02-27 16:06:24'),(2747,'1','303',1,'Retail Sale Id 2671',0.00,8125.00,720.00,9000.00,875.00,'2023-02-27 16:08:03'),(2748,'1','303',1,'Retail Sale Id 2672',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 16:10:52'),(2749,'1','303',1,'Retail Sale Id 2673',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 16:19:06'),(2750,'1','303',1,'Retail Sale Id 2674',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 16:20:28'),(2751,'1','303',1,'Retail Sale Id 2675',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 16:30:00'),(2752,'1','303',1,'Retail Sale Id 2676',0.00,2619.50,720.00,2901.60,282.10,'2023-02-27 16:31:11'),(2753,'1','303',1,'Retail Sale Id 2677',0.00,1989.00,720.00,2203.20,214.20,'2023-02-27 16:32:03'),(2754,'1','303',1,'Retail Sale Id 2679',0.00,1807.00,720.00,2001.60,194.60,'2023-02-27 16:34:10'),(2755,'1','303',1,'Retail Sale Id 2680',0.00,3250.00,720.00,3600.00,350.00,'2023-02-27 16:35:03'),(2756,'1','303',1,'Retail Sale Id 2681',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 16:40:30'),(2757,'1','303',1,'Retail Sale Id 2682',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 16:42:07'),(2758,'1','303',1,'Retail Sale Id 2683',0.00,1085.50,720.00,1202.40,116.90,'2023-02-27 16:44:28'),(2759,'1','303',1,'Retail Sale Id 2684',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 16:56:19'),(2760,'1','303',1,'Retail Sale Id 2685',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 17:05:23'),(2761,'1','303',1,'Retail Sale Id 2686',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 17:06:49'),(2762,'1','303',1,'Retail Sale Id 2687',0.00,5200.00,720.00,5760.00,560.00,'2023-02-27 17:08:35'),(2763,'1','303',1,'Retail Sale Id 2688',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 17:19:07'),(2764,'1','303',1,'Retail Sale Id 2689',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 17:20:59'),(2765,'1','303',1,'Retail Sale Id 2690',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 17:22:44'),(2766,'1','303',1,'Retail Sale Id 2691',0.00,3250.00,720.00,3600.00,350.00,'2023-02-27 17:27:17'),(2767,'1','303',1,'Retail Sale Id 2692',0.00,1300.00,720.00,1440.00,140.00,'2023-02-27 17:28:56'),(2768,'1','303',1,'Retail Sale Id 2693',0.00,2600.00,720.00,2880.00,280.00,'2023-02-27 17:32:10'),(2769,'1','303',1,'Retail Sale Id 2694',0.00,4550.00,720.00,5040.00,490.00,'2023-02-27 17:34:11'),(2770,'1','303',1,'Retail Sale Id 2695',0.00,3250.00,720.00,3600.00,350.00,'2023-02-27 17:36:06'),(2771,'1','303',1,'Retail Sale Id 2696',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 17:53:54'),(2772,'1','303',1,'Retail Sale Id 2697',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 17:59:33'),(2773,'1','303',1,'Retail Sale Id 2698',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 18:01:19'),(2774,'1','303',1,'Retail Sale Id 2699',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 18:04:42'),(2775,'1','303',1,'Retail Sale Id 2700',0.00,1950.00,720.00,2160.00,210.00,'2023-02-27 18:07:29'),(2776,'1','303',1,'Retail Sale Id 2701',0.00,3250.00,720.00,3600.00,350.00,'2023-02-27 18:14:38'),(2777,'1','303',1,'Retail Sale Id 2701',0.00,6500.00,720.00,7200.00,700.00,'2023-02-27 18:14:38'),(2778,'1','303',1,'Retail Sale Id 2702',0.00,3900.00,720.00,4320.00,420.00,'2023-02-27 18:29:33'),(2779,'1','303',1,'Retail Sale Id 2703',0.00,3250.00,720.00,3600.00,350.00,'2023-02-27 18:31:46'),(2780,'1','303',1,'Retail Sale Id 2704',0.00,1508.00,720.00,1670.40,162.40,'2023-02-27 19:16:23'),(2781,'1','303',1,'Retail Sale Id 2706',0.00,4571515.00,690.00,4852839.00,281324.00,'2023-02-27 19:33:57'),(2782,'1','303',1,'Return of Retail Sale Id 2706',4571515.00,0.00,690.00,-4852839.00,-281324.00,'2023-02-27 19:34:31'),(2783,'1','303',1,'Retail Sale Id 2708',0.00,1885.00,690.00,2001.00,116.00,'2023-02-27 19:42:43'),(2784,'1','303',1,'Retail Sale Id 2709',0.00,650.00,690.00,690.00,40.00,'2023-02-27 19:44:35'),(2785,'1','303',1,'Retail Sale Id 2710',0.00,3880.50,720.00,4298.40,417.90,'2023-02-28 07:44:25'),(2786,'1','303',1,'Retail Sale Id 2711',0.00,3250.00,720.00,3600.00,350.00,'2023-02-28 07:46:19'),(2787,'1','303',1,'Retail Sale Id 2712',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 08:05:56'),(2788,'1','303',1,'Retail Sale Id 2713',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 08:22:18'),(2789,'1','303',1,'Retail Sale Id 2714',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 08:23:56'),(2790,'1','303',1,'Retail Sale Id 2715',0.00,3250.00,720.00,3600.00,350.00,'2023-02-28 08:41:27'),(2791,'1','303',1,'Retail Sale Id 2716',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 09:02:39'),(2792,'1','303',1,'Retail Sale Id 2717',0.00,97500.00,690.00,103500.00,6000.00,'2023-02-28 09:13:10'),(2793,'1','303',1,'Retail Sale Id 2718',0.00,3250.00,720.00,3600.00,350.00,'2023-02-28 09:15:24'),(2794,'1','303',1,'Retail Sale Id 2719',0.00,3250.00,720.00,3600.00,350.00,'2023-02-28 09:17:16'),(2795,'1','303',1,'Retail Sale Id 2720',0.00,3250.00,720.00,3600.00,350.00,'2023-02-28 09:18:38'),(2796,'1','303',1,'Retail Sale Id 2721',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 09:19:56'),(2797,'1','303',1,'Retail Sale Id 2722',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 09:32:07'),(2798,'1','303',1,'Retail Sale Id 2723',0.00,7150.00,720.00,7920.00,770.00,'2023-02-28 09:41:46'),(2799,'1','303',1,'Retail Sale Id 2724',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 09:43:23'),(2800,'1','303',1,'Retail Sale Id 2725',0.00,4511.00,720.00,4996.80,485.80,'2023-02-28 09:48:34'),(2801,'1','303',1,'Retail Sale Id 2726',0.00,3250.00,720.00,3600.00,350.00,'2023-02-28 10:08:00'),(2802,'1','303',1,'Retail Sale Id 2727',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 10:17:43'),(2803,'1','303',1,'Retail Sale Id 2728',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 10:31:59'),(2804,'1','303',1,'Retail Sale Id 2729',0.00,1807.00,720.00,2001.60,194.60,'2023-02-28 10:34:42'),(2805,'1','303',1,'Retail Sale Id 2730',0.00,1950.00,720.00,2160.00,210.00,'2023-02-28 10:35:39'),(2806,'1','303',1,'Retail Sale Id 2731',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 10:41:05'),(2807,'1','303',1,'Retail Sale Id 2732',0.00,1950.00,720.00,2160.00,210.00,'2023-02-28 10:57:44'),(2808,'1','303',1,'Retail Sale Id 2733',0.00,1950.00,720.00,2160.00,210.00,'2023-02-28 11:06:47'),(2809,'1','303',1,'Retail Sale Id 2734',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 11:10:36'),(2810,'1','303',1,'Retail Sale Id 2735',0.00,8125.00,720.00,9000.00,875.00,'2023-02-28 11:26:26'),(2811,'1','303',1,'Retail Sale Id 2736',0.00,7676.50,720.00,8503.20,826.70,'2023-02-28 11:48:07'),(2812,'1','303',1,'Retail Sale Id 2737',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 12:03:19'),(2813,'1','303',1,'Retail Sale Id 2738',0.00,1950.00,720.00,2160.00,210.00,'2023-02-28 12:05:40'),(2814,'1','303',1,'Retail Sale Id 2739',0.00,877.50,720.00,972.00,94.50,'2023-02-28 12:16:56'),(2815,'1','303',1,'Retail Sale Id 2740',0.00,6500.00,720.00,7200.00,700.00,'2023-02-28 12:22:06'),(2816,'1','303',1,'Retail Sale Id 2741',0.00,4550.00,720.00,5040.00,490.00,'2023-02-28 12:37:54'),(2817,'1','303',1,'Retail Sale Id 2742',0.00,903.50,720.00,1000.80,97.30,'2023-02-28 12:39:25'),(2818,'1','303',1,'Retail Sale Id 2743',0.00,3250.00,720.00,3600.00,350.00,'2023-02-28 12:42:41'),(2819,'1','303',1,'Retail Sale Id 2744',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 12:51:29'),(2820,'1','303',1,'Retail Sale Id 2745',0.00,3250.00,720.00,3600.00,350.00,'2023-02-28 12:53:43'),(2821,'1','303',1,'Retail Sale Id 2746',0.00,3250.00,720.00,3600.00,350.00,'2023-02-28 13:02:10'),(2822,'1','303',1,'Retail Sale Id 2747',0.00,1950.00,720.00,2160.00,210.00,'2023-02-28 13:03:36'),(2823,'1','303',1,'Retail Sale Id 2748',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 13:26:07'),(2824,'1','303',1,'Retail Sale Id 2750',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 13:29:17'),(2825,'1','303',1,'Retail Sale Id 2751',0.00,1950.00,720.00,2160.00,210.00,'2023-02-28 13:30:32'),(2826,'1','303',1,'Retail Sale Id 2752',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 13:31:58'),(2827,'1','303',1,'Retail Sale Id 2753',0.00,8125.00,720.00,9000.00,875.00,'2023-02-28 13:47:50'),(2828,'1','303',1,'Retail Sale Id 2754',0.00,903.50,720.00,1000.80,97.30,'2023-02-28 13:50:45'),(2829,'1','303',1,'Retail Sale Id 2755',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 13:55:28'),(2830,'1','303',1,'Retail Sale Id 2756',0.00,1950.00,720.00,2160.00,210.00,'2023-02-28 13:57:37'),(2831,'1','303',1,'Retail Sale Id 2757',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 13:59:34'),(2832,'1','303',1,'Retail Sale Id 2758',0.00,8125.00,720.00,9000.00,875.00,'2023-02-28 14:02:39'),(2833,'1','303',1,'Retail Sale Id 2759',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 14:04:49'),(2834,'1','303',1,'Retail Sale Id 2760',0.00,2710.50,720.00,3002.40,291.90,'2023-02-28 14:07:17'),(2835,'1','303',1,'Retail Sale Id 2761',0.00,903.50,720.00,1000.80,97.30,'2023-02-28 14:09:46'),(2836,'1','303',1,'Retail Sale Id 2762',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 14:18:57'),(2837,'1','303',1,'Retail Sale Id 2763',0.00,8125.00,720.00,9000.00,875.00,'2023-02-28 14:22:19'),(2838,'1','303',1,'Retail Sale Id 2764',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 14:24:44'),(2839,'1','303',1,'Retail Sale Id 2765',0.00,1950.00,720.00,2160.00,210.00,'2023-02-28 14:26:20'),(2840,'1','303',1,'Retail Sale Id 2766',0.00,3250.00,720.00,3600.00,350.00,'2023-02-28 15:08:40'),(2841,'1','303',1,'Retail Sale Id 2767',0.00,5850.00,720.00,6480.00,630.00,'2023-02-28 15:11:11'),(2842,'1','303',1,'Retail Sale Id 2768',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 15:14:16'),(2843,'1','303',1,'Retail Sale Id 2769',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 15:16:17'),(2844,'1','303',1,'Retail Sale Id 2770',0.00,3159.00,720.00,3499.20,340.20,'2023-02-28 15:49:45'),(2845,'1','303',1,'Retail Sale Id 2771',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 15:56:45'),(2846,'1','303',1,'Retail Sale Id 2772',0.00,650.00,720.00,720.00,70.00,'2023-02-28 16:07:58'),(2847,'1','303',1,'Retail Sale Id 2773',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 16:13:35'),(2848,'1','303',1,'Retail Sale Id 2774',0.00,1300.00,720.00,1440.00,140.00,'2023-02-28 16:25:54'),(2849,'1','303',1,'Retail Sale Id 2775',0.00,8125.00,720.00,9000.00,875.00,'2023-02-28 16:36:53'),(2850,'1','303',1,'Retail Sale Id 2776',0.00,1989.00,720.00,2203.20,214.20,'2023-02-28 16:48:20'),(2851,'1','303',1,'Retail Sale Id 2777',0.00,903.50,720.00,1000.80,97.30,'2023-02-28 16:49:22'),(2852,'1','303',1,'Retail Sale Id 2778',0.00,3250.00,720.00,3600.00,350.00,'2023-02-28 17:00:37'),(2853,'1','303',1,'Retail Sale Id 2779',0.00,3250.00,720.00,3600.00,350.00,'2023-02-28 17:03:42'),(2854,'1','303',1,'Retail Sale Id 2780',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 17:05:35'),(2855,'1','303',1,'Retail Sale Id 2781',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 17:07:14'),(2856,'1','303',1,'Retail Sale Id 2782',0.00,1950.00,720.00,2160.00,210.00,'2023-02-28 17:11:09'),(2857,'1','303',1,'Retail Sale Id 2783',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 17:18:17'),(2858,'1','303',1,'Retail Sale Id 2784',0.00,3880.50,720.00,4298.40,417.90,'2023-02-28 17:19:39'),(2859,'1','303',1,'Retail Sale Id 2785',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 17:23:27'),(2860,'1','303',1,'Retail Sale Id 2786',0.00,1950.00,720.00,2160.00,210.00,'2023-02-28 17:24:17'),(2861,'1','303',1,'Retail Sale Id 2787',0.00,2600.00,720.00,2880.00,280.00,'2023-02-28 17:25:59'),(2862,'1','303',1,'Retail Sale Id 2788',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 17:28:11'),(2863,'1','303',1,'Retail Sale Id 2789',0.00,7150.00,720.00,7920.00,770.00,'2023-02-28 17:30:20'),(2864,'1','303',1,'Retail Sale Id 2790',0.00,10075.00,720.00,11160.00,1085.00,'2023-02-28 17:33:09'),(2865,'1','303',1,'Retail Sale Id 2791',0.00,8125.00,720.00,9000.00,875.00,'2023-02-28 17:35:43'),(2866,'1','303',1,'Retail Sale Id 2792',0.00,1950.00,720.00,2160.00,210.00,'2023-02-28 17:37:40'),(2867,'1','303',1,'Retail Sale Id 2793',0.00,2600.00,720.00,2880.00,280.00,'2023-02-28 17:39:29'),(2868,'1','303',1,'Retail Sale Id 2794',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 17:44:49'),(2869,'1','303',1,'Retail Sale Id 2795',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 17:51:03'),(2870,'1','303',1,'Retail Sale Id 2796',0.00,3900.00,720.00,4320.00,420.00,'2023-02-28 18:05:42'),(2871,'1','303',1,'Retail Sale Id 2797',0.00,8125.00,720.00,9000.00,875.00,'2023-02-28 18:07:46'),(2872,'1','303',1,'Retail Sale Id 2798',0.00,721.50,720.00,799.20,77.70,'2023-02-28 18:14:11'),(2873,'1','303',1,'Retail Sale Id 2799',0.00,8125.00,720.00,9000.00,875.00,'2023-02-28 18:16:21'),(2874,'1','303',1,'Retail Sale Id 2800',0.00,1352.00,720.00,1497.60,145.60,'2023-02-28 18:17:38'),(2875,'1','303',1,'Retail Sale Id 2801',0.00,1300.00,720.00,1440.00,140.00,'2023-03-02 07:54:22'),(2876,'1','303',1,'Retail Sale Id 2802',0.00,8125.00,720.00,9000.00,875.00,'2023-03-02 08:18:26'),(2877,'1','303',1,'Retail Sale Id 2803',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 08:20:33'),(2878,'1','303',1,'Retail Sale Id 2804',0.00,4550.00,720.00,5040.00,490.00,'2023-03-02 08:44:14'),(2879,'1','303',1,'Retail Sale Id 2805',0.00,1300.00,720.00,1440.00,140.00,'2023-03-02 08:48:35'),(2880,'1','303',1,'Retail Sale Id 2806',0.00,2710.50,720.00,3002.40,291.90,'2023-03-02 08:49:52'),(2881,'1','303',1,'Retail Sale Id 2807',0.00,1950.00,720.00,2160.00,210.00,'2023-03-02 08:50:40'),(2882,'1','303',1,'Retail Sale Id 2808',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 08:56:58'),(2883,'1','303',1,'Retail Sale Id 2809',0.00,1807.00,720.00,2001.60,194.60,'2023-03-02 09:13:27'),(2884,'1','303',1,'Retail Sale Id 2810',0.00,8125.00,720.00,9000.00,875.00,'2023-03-02 09:17:00'),(2885,'1','303',1,'Retail Sale Id 2811',0.00,5200.00,720.00,5760.00,560.00,'2023-03-02 09:28:12'),(2886,'1','303',1,'Retail Sale Id 2812',0.00,1807.00,720.00,2001.60,194.60,'2023-03-02 09:34:13'),(2887,'1','303',1,'Retail Sale Id 2813',0.00,1807.00,720.00,2001.60,194.60,'2023-03-02 09:40:07'),(2888,'1','303',1,'Retail Sale Id 2814',0.00,1950.00,720.00,2160.00,210.00,'2023-03-02 09:46:45'),(2889,'1','303',1,'Retail Sale Id 2815',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 09:47:37'),(2890,'1','303',1,'Retail Sale Id 2816',0.00,97500.00,690.00,103500.00,6000.00,'2023-03-02 09:49:25'),(2891,'1','303',1,'Retail Sale Id 2817',0.00,2925.00,720.00,3240.00,315.00,'2023-03-02 09:52:56'),(2892,'1','303',1,'Retail Sale Id 2818',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 09:54:28'),(2893,'1','303',1,'Retail Sale Id 2819',0.00,4550.00,720.00,5040.00,490.00,'2023-03-02 09:58:50'),(2894,'1','303',1,'Retail Sale Id 2820',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 10:07:13'),(2895,'1','303',1,'Retail Sale Id 2821',0.00,5200.00,720.00,5760.00,560.00,'2023-03-02 10:12:31'),(2896,'1','303',1,'Retail Sale Id 2822',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-02 10:14:28'),(2897,'1','303',1,'Retail Sale Id 2823',0.00,2600.00,720.00,2880.00,280.00,'2023-03-02 10:17:27'),(2898,'1','303',1,'Retail Sale Id 2824',0.00,3250.00,720.00,3600.00,350.00,'2023-03-02 10:21:15'),(2899,'1','303',1,'Retail Sale Id 2824',0.00,3250.00,720.00,3600.00,350.00,'2023-03-02 10:21:15'),(2900,'1','303',1,'Retail Sale Id 2825',0.00,1989.00,720.00,2203.20,214.20,'2023-03-02 10:37:41'),(2901,'1','303',1,'Retail Sale Id 2826',0.00,3614.00,720.00,4003.20,389.20,'2023-03-02 10:41:40'),(2902,'1','303',1,'Retail Sale Id 2827',0.00,65000.00,690.00,69000.00,4000.00,'2023-03-02 10:44:26'),(2903,'1','303',1,'Retail Sale Id 2828',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 10:46:27'),(2904,'1','303',1,'Retail Sale Id 2829',0.00,903.50,720.00,1000.80,97.30,'2023-03-02 10:49:34'),(2905,'1','303',1,'Retail Sale Id 2830',0.00,1950.00,720.00,2160.00,210.00,'2023-03-02 10:53:37'),(2906,'1','303',1,'Retail Sale Id 2831',0.00,8125.00,720.00,9000.00,875.00,'2023-03-02 10:57:16'),(2907,'1','303',1,'Retail Sale Id 2832',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 10:59:31'),(2908,'1','303',1,'Retail Sale Id 2833',0.00,2600.00,720.00,2880.00,280.00,'2023-03-02 11:14:05'),(2909,'1','303',1,'Retail Sale Id 2834',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 11:15:13'),(2910,'1','303',1,'Retail Sale Id 2835',0.00,3614.00,720.00,4003.20,389.20,'2023-03-02 11:16:59'),(2911,'1','303',1,'Retail Sale Id 2836',0.00,8125.00,720.00,9000.00,875.00,'2023-03-02 11:19:36'),(2912,'1','303',1,'Retail Sale Id 2837',0.00,1950.00,720.00,2160.00,210.00,'2023-03-02 11:30:49'),(2913,'1','303',1,'Retail Sale Id 2838',0.00,1300.00,720.00,1440.00,140.00,'2023-03-02 11:41:38'),(2914,'1','303',1,'Retail Sale Id 2840',0.00,8125.00,720.00,9000.00,875.00,'2023-03-02 11:46:56'),(2915,'1','303',1,'Retail Sale Id 2841',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 11:48:21'),(2916,'1','303',1,'Retail Sale Id 2842',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 11:54:31'),(2917,'1','303',1,'Retail Sale Id 2843',0.00,1950.00,720.00,2160.00,210.00,'2023-03-02 12:00:42'),(2918,'1','303',1,'Retail Sale Id 2844',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 12:02:18'),(2919,'1','303',1,'Retail Sale Id 2845',0.00,3880.50,720.00,4298.40,417.90,'2023-03-02 12:03:36'),(2920,'1','303',1,'Retail Sale Id 2846',0.00,1950.00,720.00,2160.00,210.00,'2023-03-02 12:06:39'),(2921,'1','303',1,'Retail Sale Id 2846',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 12:06:39'),(2922,'1','303',1,'Retail Sale Id 2847',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 12:12:32'),(2923,'1','303',1,'Retail Sale Id 2848',0.00,8125.00,720.00,9000.00,875.00,'2023-03-02 12:14:26'),(2924,'1','303',1,'Retail Sale Id 2849',0.00,8125.00,720.00,9000.00,875.00,'2023-03-02 12:16:39'),(2925,'1','303',1,'Retail Sale Id 2850',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 12:21:02'),(2926,'1','303',1,'Retail Sale Id 2851',0.00,8125.00,720.00,9000.00,875.00,'2023-03-02 12:28:07'),(2927,'1','303',1,'Retail Sale Id 2852',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-02 12:30:17'),(2928,'1','303',1,'Retail Sale Id 2853',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 12:32:11'),(2929,'1','303',1,'Retail Sale Id 2854',0.00,3250.00,720.00,3600.00,350.00,'2023-03-02 12:41:22'),(2930,'1','303',1,'Retail Sale Id 2855',0.00,1950.00,720.00,2160.00,210.00,'2023-03-02 12:45:09'),(2931,'1','303',1,'Retail Sale Id 2856',0.00,448.50,720.00,496.80,48.30,'2023-03-02 12:46:13'),(2932,'1','303',1,'Retail Sale Id 2857',0.00,1989.00,720.00,2203.20,214.20,'2023-03-02 12:48:00'),(2933,'1','303',1,'Retail Sale Id 2858',0.00,1950.00,720.00,2160.00,210.00,'2023-03-02 12:56:36'),(2934,'1','303',1,'Retail Sale Id 2859',0.00,2710.50,720.00,3002.40,291.90,'2023-03-02 13:15:49'),(2935,'1','303',1,'Retail Sale Id 2860',0.00,3250.00,720.00,3600.00,350.00,'2023-03-02 13:20:35'),(2936,'1','303',1,'Retail Sale Id 2860',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 13:20:35'),(2937,'1','303',1,'Retail Sale Id 2861',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 13:23:54'),(2938,'1','303',1,'Retail Sale Id 2861',0.00,8125.00,720.00,9000.00,875.00,'2023-03-02 13:23:54'),(2939,'1','303',1,'Retail Sale Id 2862',0.00,1950.00,720.00,2160.00,210.00,'2023-03-02 13:26:05'),(2940,'1','303',1,'Retail Sale Id 2863',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-02 13:28:14'),(2941,'1','303',1,'Retail Sale Id 2864',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-02 13:30:26'),(2942,'1','303',1,'Retail Sale Id 2865',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 13:32:14'),(2943,'1','303',1,'Retail Sale Id 2866',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 13:41:20'),(2944,'1','303',1,'Retail Sale Id 2867',0.00,1950.00,720.00,2160.00,210.00,'2023-03-02 13:43:18'),(2945,'1','303',1,'Retail Sale Id 2869',0.00,1950.00,720.00,2160.00,210.00,'2023-03-02 14:13:04'),(2946,'1','303',1,'Retail Sale Id 2871',0.00,1950.00,720.00,2160.00,210.00,'2023-03-02 14:42:41'),(2947,'1','303',1,'Retail Sale Id 2872',0.00,15073.50,690.00,16001.10,927.60,'2023-03-02 14:44:26'),(2948,'1','303',1,'Retail Sale Id 2873',0.00,903.50,720.00,1000.80,97.30,'2023-03-02 14:55:48'),(2949,'1','303',1,'Retail Sale Id 2874',0.00,1950.00,720.00,2160.00,210.00,'2023-03-02 15:18:19'),(2950,'1','303',1,'Retail Sale Id 2875',0.00,3250.00,720.00,3600.00,350.00,'2023-03-02 15:40:36'),(2951,'1','303',1,'Retail Sale Id 2876',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 15:43:37'),(2952,'1','303',1,'Retail Sale Id 2877',0.00,8125.00,720.00,9000.00,875.00,'2023-03-02 15:47:04'),(2953,'1','303',1,'Retail Sale Id 2877',0.00,8125.00,720.00,9000.00,875.00,'2023-03-02 15:47:04'),(2954,'1','303',1,'Retail Sale Id 2878',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 15:53:40'),(2955,'1','303',1,'Retail Sale Id 2880',0.00,8125.00,720.00,9000.00,875.00,'2023-03-02 15:57:46'),(2956,'1','303',1,'Retail Sale Id 2881',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 15:59:47'),(2957,'1','303',1,'Retail Sale Id 2882',0.00,1950.00,720.00,2160.00,210.00,'2023-03-02 16:02:16'),(2958,'1','303',1,'Retail Sale Id 2882',0.00,3250.00,720.00,3600.00,350.00,'2023-03-02 16:02:16'),(2959,'1','303',1,'Retail Sale Id 2883',0.00,5850.00,720.00,6480.00,630.00,'2023-03-02 16:06:56'),(2960,'1','303',1,'Retail Sale Id 2884',0.00,903.50,720.00,1000.80,97.30,'2023-03-02 16:18:15'),(2961,'1','303',1,'Retail Sale Id 2885',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 16:31:43'),(2962,'1','303',1,'Retail Sale Id 2886',0.00,903.50,720.00,1000.80,97.30,'2023-03-02 16:34:08'),(2963,'1','303',1,'Retail Sale Id 2887',0.00,8125.00,720.00,9000.00,875.00,'2023-03-02 16:35:53'),(2964,'1','303',1,'Retail Sale Id 2888',0.00,390000.00,690.00,414000.00,24000.00,'2023-03-02 16:39:44'),(2965,'1','303',1,'Retail Sale Id 2890',0.00,3250.00,720.00,3600.00,350.00,'2023-03-02 16:42:10'),(2966,'1','303',1,'Retail Sale Id 2891',0.00,1989.00,720.00,2203.20,214.20,'2023-03-02 16:43:29'),(2967,'1','303',1,'Retail Sale Id 2892',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 16:44:36'),(2968,'1','303',1,'Retail Sale Id 2893',0.00,3250.00,720.00,3600.00,350.00,'2023-03-02 16:46:47'),(2969,'1','303',1,'Retail Sale Id 2893',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 16:46:47'),(2970,'1','303',1,'Retail Sale Id 2894',0.00,1950.00,720.00,2160.00,210.00,'2023-03-02 16:50:13'),(2971,'1','303',1,'Retail Sale Id 2894',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 16:50:13'),(2972,'1','303',1,'Retail Sale Id 2895',0.00,1807.00,720.00,2001.60,194.60,'2023-03-02 16:51:14'),(2973,'1','303',1,'Retail Sale Id 2896',0.00,3250.00,720.00,3600.00,350.00,'2023-03-02 16:52:11'),(2974,'1','303',1,'Retail Sale Id 2897',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 16:53:08'),(2975,'1','303',1,'Retail Sale Id 2898',0.00,8125.00,720.00,9000.00,875.00,'2023-03-02 16:56:19'),(2976,'1','303',1,'Retail Sale Id 2899',0.00,1352.00,720.00,1497.60,145.60,'2023-03-02 16:58:01'),(2977,'1','303',1,'Retail Sale Id 2900',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 17:06:41'),(2978,'1','303',1,'Retail Sale Id 2901',0.00,2600.00,720.00,2880.00,280.00,'2023-03-02 17:08:56'),(2979,'1','303',1,'Retail Sale Id 2902',0.00,903.50,720.00,1000.80,97.30,'2023-03-02 17:10:58'),(2980,'1','303',1,'Retail Sale Id 2903',0.00,1807.00,720.00,2001.60,194.60,'2023-03-02 17:15:41'),(2981,'1','303',1,'Retail Sale Id 2904',0.00,1950.00,720.00,2160.00,210.00,'2023-03-02 17:19:17'),(2982,'1','303',1,'Retail Sale Id 2905',0.00,2710.50,720.00,3002.40,291.90,'2023-03-02 17:22:13'),(2983,'1','303',1,'Retail Sale Id 2906',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 17:23:00'),(2984,'1','303',1,'Retail Sale Id 2907',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 17:25:53'),(2985,'1','303',1,'Retail Sale Id 2908',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 17:28:02'),(2986,'1','303',1,'Retail Sale Id 2908',0.00,8125.00,720.00,9000.00,875.00,'2023-03-02 17:28:02'),(2987,'1','303',1,'Retail Sale Id 2909',0.00,1950.00,720.00,2160.00,210.00,'2023-03-02 17:30:12'),(2988,'1','303',1,'Retail Sale Id 2910',0.00,3900.00,720.00,4320.00,420.00,'2023-03-02 17:32:17'),(2989,'1','303',1,'Return of Retail Sale Id 2910',3900.00,0.00,720.00,-4320.00,-420.00,'2023-03-02 17:33:52'),(2990,'1','303',1,'Retail Sale Id 2911',0.00,1300.00,720.00,1440.00,140.00,'2023-03-02 17:34:52'),(2991,'1','303',1,'Retail Sale Id 2911',0.00,1807.00,720.00,2001.60,194.60,'2023-03-02 17:34:52'),(2992,'1','303',1,'Retail Sale Id 2912',0.00,1950.00,720.00,2160.00,210.00,'2023-03-02 17:39:22'),(2993,'1','303',1,'Retail Sale Id 2913',0.00,2164.50,720.00,2397.60,233.10,'2023-03-02 17:45:17'),(2994,'1','303',1,'Retail Sale Id 2914',0.00,1352.00,720.00,1497.60,145.60,'2023-03-02 17:52:20'),(2995,'1','303',1,'Retail Sale Id 2915',0.00,1950.00,720.00,2160.00,210.00,'2023-03-02 17:54:28'),(2996,'1','303',1,'Retail Sale Id 2916',0.00,1989.00,720.00,2203.20,214.20,'2023-03-02 17:56:55'),(2997,'1','303',1,'Retail Sale Id 2917',0.00,2710.50,720.00,3002.40,291.90,'2023-03-02 17:58:29'),(2998,'1','303',1,'Retail Sale Id 2918',0.00,3250.00,720.00,3600.00,350.00,'2023-03-02 17:59:38'),(2999,'1','303',1,'Retail Sale Id 2919',0.00,721.50,720.00,799.20,77.70,'2023-03-02 18:01:49'),(3000,'1','303',1,'Retail Sale Id 2920',0.00,12025.00,720.00,13320.00,1295.00,'2023-03-02 18:02:56'),(3001,'1','303',1,'Retail Sale Id 2921',0.00,8125.00,720.00,9000.00,875.00,'2023-03-02 18:05:25'),(3002,'1','303',1,'Retail Sale Id 2922',0.00,8125.00,720.00,9000.00,875.00,'2023-03-02 18:08:17'),(3003,'1','303',1,'Retail Sale Id 2923',0.00,903.50,720.00,1000.80,97.30,'2023-03-02 18:09:11'),(3004,'1','303',1,'Retail Sale Id 2924',0.00,1950.00,720.00,2160.00,210.00,'2023-03-02 18:12:32'),(3005,'1','303',1,'Retail Sale Id 2925',0.00,1950.00,720.00,2160.00,210.00,'2023-03-02 18:18:28'),(3006,'1','303',1,'Retail Sale Id 2926',0.00,630.50,720.00,698.40,67.90,'2023-03-02 18:20:42'),(3007,'1','303',1,'Return of Retail Sale Id 2926',630.50,0.00,720.00,-698.40,-67.90,'2023-03-02 18:46:40'),(3008,'1','303',1,'Return of Retail Sale Id 2923',903.50,0.00,720.00,-1000.80,-97.30,'2023-03-02 18:59:40'),(3009,'1','303',1,'Retail Sale Id 2927',0.00,572.00,720.00,633.60,61.60,'2023-03-02 19:00:37'),(3010,'1','303',1,'Retail Sale Id 2928',0.00,8125.00,720.00,9000.00,875.00,'2023-03-03 07:47:03'),(3011,'1','303',1,'Retail Sale Id 2929',0.00,1950.00,720.00,2160.00,210.00,'2023-03-03 07:49:02'),(3012,'1','303',1,'Retail Sale Id 2929',0.00,3900.00,720.00,4320.00,420.00,'2023-03-03 07:49:02'),(3013,'1','303',1,'Retail Sale Id 2930',0.00,903.50,720.00,1000.80,97.30,'2023-03-03 08:12:26'),(3014,'1','303',1,'Retail Sale Id 2931',0.00,1807.00,720.00,2001.60,194.60,'2023-03-03 08:17:57'),(3015,'1','303',1,'Retail Sale Id 2932',0.00,2710.50,720.00,3002.40,291.90,'2023-03-03 08:19:36'),(3016,'1','303',1,'Retail Sale Id 2933',0.00,3900.00,720.00,4320.00,420.00,'2023-03-03 08:42:03'),(3017,'1','303',1,'Retail Sale Id 2934',0.00,3250.00,720.00,3600.00,350.00,'2023-03-03 08:48:41'),(3018,'1','303',1,'Retail Sale Id 2935',0.00,1807.00,720.00,2001.60,194.60,'2023-03-03 08:53:09'),(3019,'1','303',1,'Retail Sale Id 2936',0.00,1950.00,720.00,2160.00,210.00,'2023-03-03 08:57:59'),(3020,'1','303',1,'Retail Sale Id 2936',0.00,3250.00,720.00,3600.00,350.00,'2023-03-03 08:57:59'),(3021,'1','303',1,'Retail Sale Id 2937',0.00,3900.00,720.00,4320.00,420.00,'2023-03-03 09:00:06'),(3022,'1','303',1,'Retail Sale Id 2938',0.00,1989.00,720.00,2203.20,214.20,'2023-03-03 09:12:13'),(3023,'1','303',1,'Retail Sale Id 2939',0.00,1807.00,720.00,2001.60,194.60,'2023-03-03 09:40:43'),(3024,'1','303',1,'Retail Sale Id 2940',0.00,1950.00,720.00,2160.00,210.00,'2023-03-03 09:45:37'),(3025,'1','303',1,'Retail Sale Id 2941',0.00,3900.00,720.00,4320.00,420.00,'2023-03-03 09:48:31'),(3026,'1','303',1,'Retail Sale Id 2942',0.00,1950.00,720.00,2160.00,210.00,'2023-03-03 09:49:55'),(3027,'1','303',1,'Retail Sale Id 2943',0.00,3900.00,720.00,4320.00,420.00,'2023-03-03 10:01:11'),(3028,'1','303',1,'Retail Sale Id 2944',0.00,8125.00,720.00,9000.00,875.00,'2023-03-03 10:14:37'),(3029,'1','303',1,'Retail Sale Id 2945',0.00,1950.00,720.00,2160.00,210.00,'2023-03-03 10:17:26'),(3030,'1','303',1,'Retail Sale Id 2946',0.00,903.50,720.00,1000.80,97.30,'2023-03-03 10:29:41'),(3031,'1','303',1,'Retail Sale Id 2947',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-03 10:38:12'),(3032,'1','303',1,'Retail Sale Id 2948',0.00,7221.50,720.00,7999.20,777.70,'2023-03-03 10:46:58'),(3033,'1','303',1,'Retail Sale Id 2949',0.00,903.50,720.00,1000.80,97.30,'2023-03-03 10:48:24'),(3034,'1','303',1,'Retail Sale Id 2950',0.00,3900.00,720.00,4320.00,420.00,'2023-03-03 10:53:41'),(3035,'1','303',1,'Retail Sale Id 2951',0.00,3900.00,720.00,4320.00,420.00,'2023-03-03 11:04:46'),(3036,'1','303',1,'Retail Sale Id 2952',0.00,2255.50,720.00,2498.40,242.90,'2023-03-03 12:14:20'),(3037,'1','303',1,'Retail Sale Id 2954',0.00,1352.00,720.00,1497.60,145.60,'2023-03-03 13:26:39'),(3038,'1','303',1,'Retail Sale Id 2955',0.00,3900.00,720.00,4320.00,420.00,'2023-03-03 13:28:05'),(3039,'1','303',1,'Retail Sale Id 2956',0.00,903.50,720.00,1000.80,97.30,'2023-03-03 13:28:52'),(3040,'1','303',1,'Retail Sale Id 2957',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-03 13:30:06'),(3041,'1','303',1,'Retail Sale Id 2958',0.00,2600.00,720.00,2880.00,280.00,'2023-03-03 13:31:10'),(3042,'1','303',1,'Retail Sale Id 2959',0.00,3614.00,720.00,4003.20,389.20,'2023-03-03 13:32:06'),(3043,'1','303',1,'Retail Sale Id 2960',0.00,3900.00,720.00,4320.00,420.00,'2023-03-03 13:33:04'),(3044,'1','303',1,'Retail Sale Id 2961',0.00,1807.00,720.00,2001.60,194.60,'2023-03-03 13:33:55'),(3045,'1','303',1,'Retail Sale Id 2962',0.00,8125.00,720.00,9000.00,875.00,'2023-03-03 13:35:04'),(3046,'1','303',1,'Retail Sale Id 2963',0.00,3250.00,720.00,3600.00,350.00,'2023-03-03 13:37:02'),(3047,'1','303',1,'Retail Sale Id 2963',0.00,6500.00,720.00,7200.00,700.00,'2023-03-03 13:37:02'),(3048,'1','303',1,'Retail Sale Id 2964',0.00,3900.00,720.00,4320.00,420.00,'2023-03-03 13:37:56'),(3049,'1','303',1,'Retail Sale Id 2965',0.00,3900.00,720.00,4320.00,420.00,'2023-03-03 13:38:43'),(3050,'1','303',1,'Retail Sale Id 2966',0.00,8125.00,720.00,9000.00,875.00,'2023-03-03 13:39:37'),(3051,'1','303',1,'Retail Sale Id 2967',0.00,3900.00,720.00,4320.00,420.00,'2023-03-03 13:40:45'),(3052,'1','303',1,'Retail Sale Id 2968',0.00,1989.00,720.00,2203.20,214.20,'2023-03-03 17:09:28'),(3053,'1','303',1,'Retail Sale Id 2969',0.00,1807.00,720.00,2001.60,194.60,'2023-03-03 17:10:52'),(3054,'1','303',1,'Retail Sale Id 2971',0.00,3250.00,720.00,3600.00,350.00,'2023-03-03 17:12:51'),(3055,'1','303',1,'Retail Sale Id 2971',0.00,3900.00,720.00,4320.00,420.00,'2023-03-03 17:12:51'),(3056,'1','303',1,'Retail Sale Id 2972',0.00,8125.00,720.00,9000.00,875.00,'2023-03-03 17:13:56'),(3057,'1','303',1,'Retail Sale Id 2973',0.00,903.50,720.00,1000.80,97.30,'2023-03-03 17:15:00'),(3058,'1','303',1,'Retail Sale Id 2974',0.00,1950.00,720.00,2160.00,210.00,'2023-03-03 17:16:25'),(3059,'1','303',1,'Retail Sale Id 2975',0.00,1950.00,720.00,2160.00,210.00,'2023-03-03 17:21:49'),(3060,'1','303',1,'Retail Sale Id 2976',0.00,1300.00,720.00,1440.00,140.00,'2023-03-03 17:24:57'),(3061,'1','303',1,'Retail Sale Id 2977',0.00,1950.00,720.00,2160.00,210.00,'2023-03-03 18:50:46'),(3062,'1','303',1,'Retail Sale Id 2978',0.00,3900.00,720.00,4320.00,420.00,'2023-03-03 18:52:03'),(3063,'1','303',1,'Retail Sale Id 2979',0.00,3900.00,720.00,4320.00,420.00,'2023-03-03 18:53:01'),(3064,'1','303',1,'Retail Sale Id 2980',0.00,1950.00,720.00,2160.00,210.00,'2023-03-03 18:53:52'),(3065,'1','303',1,'Retail Sale Id 2981',0.00,1950.00,720.00,2160.00,210.00,'2023-03-03 18:54:48'),(3066,'1','303',1,'Retail Sale Id 2982',0.00,2710.50,720.00,3002.40,291.90,'2023-03-03 18:55:49'),(3067,'1','303',1,'Retail Sale Id 2983',0.00,2710.50,720.00,3002.40,291.90,'2023-03-03 18:56:44'),(3068,'1','303',1,'Retail Sale Id 2984',0.00,1950.00,720.00,2160.00,210.00,'2023-03-03 18:58:02'),(3069,'1','303',1,'Retail Sale Id 2984',0.00,3250.00,720.00,3600.00,350.00,'2023-03-03 18:58:02'),(3070,'1','303',1,'Retail Sale Id 2985',0.00,3900.00,720.00,4320.00,420.00,'2023-03-03 18:58:58'),(3071,'1','303',1,'Retail Sale Id 2986',0.00,3900.00,720.00,4320.00,420.00,'2023-03-03 19:00:11'),(3072,'1','303',1,'Retail Sale Id 2987',0.00,8125.00,720.00,9000.00,875.00,'2023-03-03 19:01:07'),(3073,'1','303',1,'Retail Sale Id 2988',0.00,3900.00,720.00,4320.00,420.00,'2023-03-03 19:02:16'),(3074,'1','303',1,'Retail Sale Id 2989',0.00,3900.00,720.00,4320.00,420.00,'2023-03-03 19:03:00'),(3075,'1','303',1,'Retail Sale Id 2990',0.00,3900.00,720.00,4320.00,420.00,'2023-03-03 19:04:01'),(3076,'1','303',1,'Retail Sale Id 2991',0.00,8125.00,720.00,9000.00,875.00,'2023-03-03 19:05:04'),(3077,'1','303',1,'Retail Sale Id 2992',0.00,8125.00,720.00,9000.00,875.00,'2023-03-03 19:06:08'),(3078,'1','303',1,'Retail Sale Id 2993',0.00,8125.00,720.00,9000.00,875.00,'2023-03-03 19:06:59'),(3079,'1','303',1,'Retail Sale Id 2995',0.00,3900.00,720.00,4320.00,420.00,'2023-03-03 19:10:57'),(3080,'1','303',1,'Retail Sale Id 2995',0.00,6500.00,720.00,7200.00,700.00,'2023-03-03 19:10:57'),(3081,'1','303',1,'Retail Sale Id 2996',0.00,2255.50,720.00,2498.40,242.90,'2023-03-03 19:11:52'),(3082,'1','303',1,'Retail Sale Id 2997',0.00,13357.50,720.00,14796.00,1438.50,'2023-03-03 19:55:56'),(3083,'1','303',1,'Retail Sale Id 2998',0.00,3900.00,720.00,4320.00,420.00,'2023-03-04 07:55:16'),(3084,'1','303',1,'Retail Sale Id 2999',0.00,3900.00,720.00,4320.00,420.00,'2023-03-04 08:12:43'),(3085,'1','303',1,'Retail Sale Id 3000',0.00,6500.00,720.00,7200.00,700.00,'2023-03-04 09:05:57'),(3086,'1','303',1,'Retail Sale Id 3001',0.00,3900.00,720.00,4320.00,420.00,'2023-03-04 09:24:51'),(3087,'1','303',1,'Retail Sale Id 3002',0.00,2710.50,720.00,3002.40,291.90,'2023-03-04 09:26:49'),(3088,'1','303',1,'Retail Sale Id 3003',0.00,650.00,720.00,720.00,70.00,'2023-03-04 09:28:52'),(3089,'1','303',1,'Retail Sale Id 3004',0.00,1950.00,720.00,2160.00,210.00,'2023-03-04 09:30:44'),(3090,'1','303',1,'Retail Sale Id 3005',0.00,8125.00,720.00,9000.00,875.00,'2023-03-04 09:32:18'),(3091,'1','303',1,'Retail Sale Id 3006',0.00,2710.50,720.00,3002.40,291.90,'2023-03-04 09:35:15'),(3092,'1','303',1,'Retail Sale Id 3007',0.00,3900.00,720.00,4320.00,420.00,'2023-03-04 09:46:24'),(3093,'1','303',1,'Retail Sale Id 3008',0.00,1352.00,720.00,1497.60,145.60,'2023-03-04 09:50:04'),(3094,'1','303',1,'Retail Sale Id 3010',0.00,1989.00,720.00,2203.20,214.20,'2023-03-04 09:54:00'),(3095,'1','303',1,'Retail Sale Id 3011',0.00,2600.00,720.00,2880.00,280.00,'2023-03-04 10:06:30'),(3096,'1','303',1,'Retail Sale Id 3012',0.00,3900.00,720.00,4320.00,420.00,'2023-03-04 10:08:51'),(3097,'1','303',1,'Retail Sale Id 3013',0.00,1352.00,720.00,1497.60,145.60,'2023-03-04 10:19:02'),(3098,'1','303',1,'Retail Sale Id 3014',0.00,3900.00,720.00,4320.00,420.00,'2023-03-04 10:24:14'),(3099,'1','303',1,'Retail Sale Id 3015',0.00,8125.00,720.00,9000.00,875.00,'2023-03-04 10:25:58'),(3100,'1','303',1,'Retail Sale Id 3016',0.00,2255.50,720.00,2498.40,242.90,'2023-03-04 10:28:02'),(3101,'1','303',1,'Retail Sale Id 3017',0.00,903.50,720.00,1000.80,97.30,'2023-03-04 10:30:16'),(3102,'1','303',1,'Retail Sale Id 3018',0.00,2600.00,720.00,2880.00,280.00,'2023-03-04 10:32:21'),(3103,'1','303',1,'Retail Sale Id 3019',0.00,3900.00,720.00,4320.00,420.00,'2023-03-04 10:36:54'),(3104,'1','303',1,'Retail Sale Id 3020',0.00,3250.00,720.00,3600.00,350.00,'2023-03-04 10:54:45'),(3105,'1','303',1,'Retail Sale Id 3021',0.00,1989.00,720.00,2203.20,214.20,'2023-03-04 10:58:14'),(3106,'1','303',1,'Retail Sale Id 3022',0.00,7150.00,720.00,7920.00,770.00,'2023-03-04 11:18:03'),(3107,'1','303',1,'Retail Sale Id 3023',0.00,1950.00,720.00,2160.00,210.00,'2023-03-04 11:23:02'),(3108,'1','303',1,'Retail Sale Id 3024',0.00,3900.00,720.00,4320.00,420.00,'2023-03-04 11:42:37'),(3109,'1','303',1,'Retail Sale Id 3025',0.00,3900.00,720.00,4320.00,420.00,'2023-03-04 11:49:36'),(3110,'1','303',1,'Retail Sale Id 3026',0.00,2600.00,720.00,2880.00,280.00,'2023-03-04 11:51:18'),(3111,'1','303',1,'Retail Sale Id 3027',0.00,2600.00,720.00,2880.00,280.00,'2023-03-04 11:53:13'),(3112,'1','303',1,'Retail Sale Id 3028',0.00,8125.00,720.00,9000.00,875.00,'2023-03-04 11:54:59'),(3113,'1','303',1,'Retail Sale Id 3029',0.00,8125.00,720.00,9000.00,875.00,'2023-03-04 12:09:50'),(3114,'1','303',1,'Retail Sale Id 3030',0.00,4550.00,720.00,5040.00,490.00,'2023-03-04 12:22:21'),(3115,'1','303',1,'Retail Sale Id 3031',0.00,6500.00,720.00,7200.00,700.00,'2023-03-04 12:25:42'),(3116,'1','303',1,'Retail Sale Id 3032',0.00,3900.00,720.00,4320.00,420.00,'2023-03-04 12:28:08'),(3117,'1','303',1,'Retail Sale Id 3033',0.00,8125.00,720.00,9000.00,875.00,'2023-03-04 12:47:30'),(3118,'1','303',1,'Retail Sale Id 3034',0.00,8125.00,720.00,9000.00,875.00,'2023-03-04 12:54:13'),(3119,'1','303',1,'Retail Sale Id 3036',0.00,1950.00,720.00,2160.00,210.00,'2023-03-04 13:10:02'),(3120,'1','303',1,'Retail Sale Id 3036',0.00,1950.00,720.00,2160.00,210.00,'2023-03-04 13:10:02'),(3121,'1','303',1,'Retail Sale Id 3036',0.00,3900.00,720.00,4320.00,420.00,'2023-03-04 13:10:02'),(3122,'1','303',1,'Retail Sale Id 3037',0.00,1950.00,720.00,2160.00,210.00,'2023-03-04 13:11:34'),(3123,'1','303',1,'Retail Sale Id 3038',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-04 13:22:42'),(3124,'1','303',1,'Retail Sale Id 3039',0.00,3250.00,720.00,3600.00,350.00,'2023-03-04 13:24:03'),(3125,'1','303',1,'Retail Sale Id 3040',0.00,3900.00,720.00,4320.00,420.00,'2023-03-04 13:25:32'),(3126,'1','303',1,'Retail Sale Id 3040',0.00,3900.00,720.00,4320.00,420.00,'2023-03-04 13:25:32'),(3127,'1','303',1,'Retail Sale Id 3041',0.00,4511.00,720.00,4996.80,485.80,'2023-03-04 13:49:11'),(3128,'1','303',1,'Retail Sale Id 3042',0.00,3900.00,720.00,4320.00,420.00,'2023-03-04 13:50:05'),(3129,'1','303',1,'Retail Sale Id 3043',0.00,1950.00,720.00,2160.00,210.00,'2023-03-04 13:52:35'),(3130,'1','303',1,'Retail Sale Id 3044',0.00,3900.00,720.00,4320.00,420.00,'2023-03-04 13:54:14'),(3131,'1','303',1,'Retail Sale Id 3045',0.00,721.50,720.00,799.20,77.70,'2023-03-04 13:55:33'),(3132,'1','303',1,'Retail Sale Id 3046',0.00,1950.00,720.00,2160.00,210.00,'2023-03-04 13:58:57'),(3133,'1','303',1,'Retail Sale Id 3047',0.00,8125.00,720.00,9000.00,875.00,'2023-03-04 14:00:12'),(3134,'1','303',1,'Retail Sale Id 3048',0.00,1950.00,720.00,2160.00,210.00,'2023-03-04 14:10:52'),(3135,'1','303',1,'Retail Sale Id 3049',0.00,6500.00,720.00,7200.00,700.00,'2023-03-04 14:21:48'),(3136,'1','303',1,'Retail Sale Id 3050',0.00,6318.00,720.00,6998.40,680.40,'2023-03-04 15:15:36'),(3137,'1','303',1,'Retail Sale Id 3051',0.00,3250.00,720.00,3600.00,350.00,'2023-03-04 15:37:00'),(3138,'1','303',1,'Retail Sale Id 3052',0.00,903.50,720.00,1000.80,97.30,'2023-03-04 16:02:14'),(3139,'1','303',1,'Retail Sale Id 3053',0.00,3900.00,720.00,4320.00,420.00,'2023-03-04 16:17:46'),(3140,'1','303',1,'Retail Sale Id 3053',0.00,8125.00,720.00,9000.00,875.00,'2023-03-04 16:17:46'),(3141,'1','303',1,'Retail Sale Id 3054',0.00,1352.00,720.00,1497.60,145.60,'2023-03-04 16:29:13'),(3142,'1','303',1,'Retail Sale Id 3055',0.00,3900.00,720.00,4320.00,420.00,'2023-03-04 16:39:06'),(3143,'1','303',1,'Retail Sale Id 3056',0.00,3614.00,720.00,4003.20,389.20,'2023-03-04 16:40:20'),(3144,'1','303',1,'Retail Sale Id 3057',0.00,2710.50,720.00,3002.40,291.90,'2023-03-04 16:42:14'),(3145,'1','303',1,'Retail Sale Id 3058',0.00,1352.00,720.00,1497.60,145.60,'2023-03-04 16:48:23'),(3146,'1','303',1,'Retail Sale Id 3059',0.00,3250.00,720.00,3600.00,350.00,'2023-03-04 16:50:56'),(3147,'1','303',1,'Retail Sale Id 3060',0.00,903.50,720.00,1000.80,97.30,'2023-03-04 16:56:23'),(3148,'1','303',1,'Retail Sale Id 3061',0.00,650.00,720.00,720.00,70.00,'2023-03-04 17:13:28'),(3149,'1','303',1,'Retail Sale Id 3062',0.00,3900.00,720.00,4320.00,420.00,'2023-03-04 17:14:30'),(3150,'1','303',1,'Retail Sale Id 3063',0.00,8125.00,720.00,9000.00,875.00,'2023-03-04 17:30:09'),(3151,'1','303',1,'Retail Sale Id 3064',0.00,1950.00,720.00,2160.00,210.00,'2023-03-04 17:35:15'),(3152,'1','303',1,'Retail Sale Id 3065',0.00,3900.00,720.00,4320.00,420.00,'2023-03-04 17:36:39'),(3153,'1','303',1,'Retail Sale Id 3066',0.00,8125.00,720.00,9000.00,875.00,'2023-03-04 17:43:27'),(3154,'1','303',1,'Retail Sale Id 3067',0.00,3900.00,720.00,4320.00,420.00,'2023-03-04 17:54:59'),(3155,'1','303',1,'Retail Sale Id 3068',0.00,3900.00,720.00,4320.00,420.00,'2023-03-04 17:56:19'),(3156,'1','303',1,'Retail Sale Id 3069',0.00,292.50,720.00,324.00,31.50,'2023-03-04 18:36:02'),(3157,'1','303',1,'Retail Sale Id 3070',0.00,3900.00,720.00,4320.00,420.00,'2023-03-05 07:46:51'),(3158,'1','303',1,'Retail Sale Id 3071',0.00,3900.00,720.00,4320.00,420.00,'2023-03-05 07:59:57'),(3159,'1','303',1,'Retail Sale Id 3072',0.00,3900.00,720.00,4320.00,420.00,'2023-03-05 08:25:44'),(3160,'1','303',1,'Retail Sale Id 3073',0.00,2710.50,720.00,3002.40,291.90,'2023-03-05 08:43:36'),(3161,'1','303',1,'Retail Sale Id 3074',0.00,3250.00,720.00,3600.00,350.00,'2023-03-05 08:53:37'),(3162,'1','303',1,'Retail Sale Id 3075',0.00,3900.00,720.00,4320.00,420.00,'2023-03-05 08:56:01'),(3163,'1','303',1,'Retail Sale Id 3076',0.00,8125.00,720.00,9000.00,875.00,'2023-03-05 09:04:54'),(3164,'1','303',1,'Retail Sale Id 3077',0.00,1950.00,720.00,2160.00,210.00,'2023-03-05 09:37:03'),(3165,'1','303',1,'Retail Sale Id 3078',0.00,1950.00,720.00,2160.00,210.00,'2023-03-05 09:42:18'),(3166,'1','303',1,'Retail Sale Id 3079',0.00,2710.50,720.00,3002.40,291.90,'2023-03-05 10:13:35'),(3167,'1','303',1,'Retail Sale Id 3080',0.00,3900.00,720.00,4320.00,420.00,'2023-03-05 10:22:16'),(3168,'1','303',1,'Retail Sale Id 3080',0.00,8125.00,720.00,9000.00,875.00,'2023-03-05 10:22:16'),(3169,'1','303',1,'Retail Sale Id 3081',0.00,3900.00,720.00,4320.00,420.00,'2023-03-05 10:29:22'),(3170,'1','303',1,'Retail Sale Id 3082',0.00,1989.00,720.00,2203.20,214.20,'2023-03-05 10:32:42'),(3171,'1','303',1,'Retail Sale Id 3083',0.00,1352.00,720.00,1497.60,145.60,'2023-03-05 10:34:50'),(3172,'1','303',1,'Retail Sale Id 3084',0.00,903.50,720.00,1000.80,97.30,'2023-03-05 10:42:08'),(3173,'1','303',1,'Retail Sale Id 3085',0.00,903.50,720.00,1000.80,97.30,'2023-03-05 10:44:58'),(3174,'1','303',1,'Retail Sale Id 3086',0.00,1950.00,720.00,2160.00,210.00,'2023-03-05 10:47:35'),(3175,'1','303',1,'Retail Sale Id 3087',0.00,3900.00,720.00,4320.00,420.00,'2023-03-05 10:52:18'),(3176,'1','303',1,'Retail Sale Id 3088',0.00,3900.00,720.00,4320.00,420.00,'2023-03-05 11:02:41'),(3177,'1','303',1,'Retail Sale Id 3089',0.00,5200.00,720.00,5760.00,560.00,'2023-03-05 11:04:47'),(3178,'1','303',1,'Retail Sale Id 3090',0.00,8125.00,720.00,9000.00,875.00,'2023-03-05 11:06:12'),(3179,'1','303',1,'Retail Sale Id 3091',0.00,8125.00,720.00,9000.00,875.00,'2023-03-05 11:08:26'),(3180,'1','303',1,'Retail Sale Id 3092',0.00,3900.00,720.00,4320.00,420.00,'2023-03-05 11:10:24'),(3181,'1','303',1,'Retail Sale Id 3093',0.00,3250.00,720.00,3600.00,350.00,'2023-03-05 11:11:56'),(3182,'1','303',1,'Retail Sale Id 3094',0.00,3900.00,720.00,4320.00,420.00,'2023-03-05 11:16:36'),(3183,'1','303',1,'Retail Sale Id 3095',0.00,6500.00,720.00,7200.00,700.00,'2023-03-05 11:29:35'),(3184,'1','303',1,'Retail Sale Id 3096',0.00,3250.00,720.00,3600.00,350.00,'2023-03-05 11:31:50'),(3185,'1','303',1,'Retail Sale Id 3097',0.00,8125.00,720.00,9000.00,875.00,'2023-03-05 11:33:37'),(3186,'1','303',1,'Retail Sale Id 3098',0.00,3250.00,720.00,3600.00,350.00,'2023-03-05 11:35:17'),(3187,'1','303',1,'Retail Sale Id 3099',0.00,65000.00,690.00,69000.00,4000.00,'2023-03-05 11:39:26'),(3188,'1','303',1,'Retail Sale Id 3100',0.00,8125.00,720.00,9000.00,875.00,'2023-03-05 12:11:37'),(3189,'1','303',1,'Retail Sale Id 3101',0.00,1950.00,720.00,2160.00,210.00,'2023-03-05 12:14:11'),(3190,'1','303',1,'Retail Sale Id 3102',0.00,3900.00,720.00,4320.00,420.00,'2023-03-05 12:23:10'),(3191,'1','303',1,'Retail Sale Id 3103',0.00,1300.00,720.00,1440.00,140.00,'2023-03-05 12:25:45'),(3192,'1','303',1,'Retail Sale Id 3104',0.00,8125.00,720.00,9000.00,875.00,'2023-03-05 12:30:00'),(3193,'1','303',1,'Retail Sale Id 3105',0.00,1807.00,720.00,2001.60,194.60,'2023-03-05 12:31:25'),(3194,'1','303',1,'Retail Sale Id 3106',0.00,1989.00,720.00,2203.20,214.20,'2023-03-05 12:34:19'),(3195,'1','303',1,'Retail Sale Id 3107',0.00,650.00,720.00,720.00,70.00,'2023-03-05 12:38:25'),(3196,'1','303',1,'Retail Sale Id 3108',0.00,1300.00,720.00,1440.00,140.00,'2023-03-05 12:40:41'),(3197,'1','303',1,'Retail Sale Id 3109',0.00,8125.00,720.00,9000.00,875.00,'2023-03-05 12:43:40'),(3198,'1','303',1,'Retail Sale Id 3110',0.00,1950.00,720.00,2160.00,210.00,'2023-03-05 12:57:52'),(3199,'1','303',1,'Retail Sale Id 3111',0.00,1950.00,720.00,2160.00,210.00,'2023-03-05 13:21:23'),(3200,'1','303',1,'Retail Sale Id 3112',0.00,8125.00,720.00,9000.00,875.00,'2023-03-05 13:22:17'),(3201,'1','303',1,'Retail Sale Id 3113',0.00,7150.00,720.00,7920.00,770.00,'2023-03-05 13:25:29'),(3202,'1','303',1,'Retail Sale Id 3114',0.00,8125.00,720.00,9000.00,875.00,'2023-03-05 13:42:28'),(3203,'1','303',1,'Return of Retail Sale Id 3110',1950.00,0.00,720.00,-2160.00,-210.00,'2023-03-05 13:45:06'),(3204,'1','303',1,'Retail Sale Id 3115',0.00,8125.00,720.00,9000.00,875.00,'2023-03-05 13:52:38'),(3205,'1','303',1,'Retail Sale Id 3116',0.00,8125.00,720.00,9000.00,875.00,'2023-03-05 13:58:11'),(3206,'1','303',1,'Retail Sale Id 3117',0.00,1950.00,720.00,2160.00,210.00,'2023-03-05 14:21:33'),(3207,'1','303',1,'Retail Sale Id 3118',0.00,8125.00,720.00,9000.00,875.00,'2023-03-05 14:27:32'),(3208,'1','303',1,'Retail Sale Id 3119',0.00,3900.00,720.00,4320.00,420.00,'2023-03-05 14:40:41'),(3209,'1','303',1,'Retail Sale Id 3120',0.00,8125.00,720.00,9000.00,875.00,'2023-03-05 14:49:37'),(3210,'1','303',1,'Retail Sale Id 3121',0.00,1950.00,720.00,2160.00,210.00,'2023-03-05 15:03:25'),(3211,'1','303',1,'Retail Sale Id 3122',0.00,1950.00,720.00,2160.00,210.00,'2023-03-05 15:37:05'),(3212,'1','303',1,'Retail Sale Id 3123',0.00,903.50,720.00,1000.80,97.30,'2023-03-05 15:50:57'),(3213,'1','303',1,'Retail Sale Id 3124',0.00,1989.00,720.00,2203.20,214.20,'2023-03-05 15:56:44'),(3214,'1','303',1,'Retail Sale Id 3125',0.00,8125.00,720.00,9000.00,875.00,'2023-03-05 16:02:24'),(3215,'1','303',1,'Retail Sale Id 3126',0.00,3900.00,720.00,4320.00,420.00,'2023-03-05 16:25:14'),(3216,'1','303',1,'Retail Sale Id 3127',0.00,3900.00,720.00,4320.00,420.00,'2023-03-05 16:31:51'),(3217,'1','303',1,'Retail Sale Id 3128',0.00,8125.00,720.00,9000.00,875.00,'2023-03-05 16:48:35'),(3218,'1','303',1,'Retail Sale Id 3129',0.00,903.50,720.00,1000.80,97.30,'2023-03-05 16:50:15'),(3219,'1','303',1,'Retail Sale Id 3130',0.00,3900.00,720.00,4320.00,420.00,'2023-03-05 17:00:36'),(3220,'1','303',1,'Retail Sale Id 3131',0.00,903.50,720.00,1000.80,97.30,'2023-03-05 17:16:08'),(3221,'1','303',1,'Retail Sale Id 3132',0.00,3900.00,720.00,4320.00,420.00,'2023-03-05 17:27:06'),(3222,'1','303',1,'Retail Sale Id 3133',0.00,3900.00,720.00,4320.00,420.00,'2023-03-05 17:42:38'),(3223,'1','303',1,'Retail Sale Id 3134',0.00,3250.00,720.00,3600.00,350.00,'2023-03-05 17:45:30'),(3224,'1','303',1,'Retail Sale Id 3135',0.00,3250.00,720.00,3600.00,350.00,'2023-03-05 18:02:01'),(3225,'1','303',1,'Return of Retail Sale Id 3131',903.50,0.00,720.00,-1000.80,-97.30,'2023-03-05 18:48:01'),(3226,'1','303',1,'Retail Sale Id 3136',0.00,13.00,720.00,14.40,1.40,'2023-03-05 18:48:58'),(3227,'1','303',1,'Retail Sale Id 3137',0.00,2600.00,720.00,2880.00,280.00,'2023-03-06 09:06:39'),(3228,'1','303',1,'Retail Sale Id 3138',0.00,3250.00,720.00,3600.00,350.00,'2023-03-06 09:07:25'),(3229,'1','303',1,'Retail Sale Id 3139',0.00,1950.00,720.00,2160.00,210.00,'2023-03-06 09:10:15'),(3230,'1','303',1,'Retail Sale Id 3140',0.00,1950.00,720.00,2160.00,210.00,'2023-03-06 09:43:59'),(3231,'1','303',1,'Retail Sale Id 3141',0.00,1352.00,720.00,1497.60,145.60,'2023-03-06 09:54:32'),(3232,'1','303',1,'Retail Sale Id 3142',0.00,1950.00,720.00,2160.00,210.00,'2023-03-06 10:05:57'),(3233,'1','303',1,'Retail Sale Id 3142',0.00,1950.00,720.00,2160.00,210.00,'2023-03-06 10:05:57'),(3234,'1','303',1,'Retail Sale Id 3143',0.00,1950.00,720.00,2160.00,210.00,'2023-03-06 10:25:51'),(3235,'1','303',1,'Retail Sale Id 3143',0.00,1950.00,720.00,2160.00,210.00,'2023-03-06 10:25:51'),(3236,'1','303',1,'Retail Sale Id 3145',0.00,1989.00,720.00,2203.20,214.20,'2023-03-06 10:53:16'),(3237,'1','303',1,'Retail Sale Id 3146',0.00,8125.00,720.00,9000.00,875.00,'2023-03-06 11:23:26'),(3238,'1','303',1,'Retail Sale Id 3147',0.00,1300.00,720.00,1440.00,140.00,'2023-03-06 11:37:24'),(3239,'1','303',1,'Retail Sale Id 3148',0.00,3900.00,720.00,4320.00,420.00,'2023-03-06 11:38:19'),(3240,'1','303',1,'Retail Sale Id 3149',0.00,3250.00,720.00,3600.00,350.00,'2023-03-06 11:40:05'),(3241,'1','303',1,'Retail Sale Id 3150',0.00,3900.00,720.00,4320.00,420.00,'2023-03-06 11:41:49'),(3242,'1','303',1,'Retail Sale Id 3151',0.00,8125.00,720.00,9000.00,875.00,'2023-03-06 11:58:34'),(3243,'1','303',1,'Retail Sale Id 3152',0.00,2710.50,720.00,3002.40,291.90,'2023-03-06 12:20:54'),(3244,'1','303',1,'Retail Sale Id 3153',0.00,3900.00,720.00,4320.00,420.00,'2023-03-06 12:25:27'),(3245,'1','303',1,'Retail Sale Id 3154',0.00,3900.00,720.00,4320.00,420.00,'2023-03-06 12:30:54'),(3246,'1','303',1,'Retail Sale Id 3155',0.00,1950.00,720.00,2160.00,210.00,'2023-03-06 12:45:39'),(3247,'1','303',1,'Retail Sale Id 3155',0.00,7150.00,720.00,7920.00,770.00,'2023-03-06 12:45:39'),(3248,'1','303',1,'Retail Sale Id 3157',0.00,2600.00,720.00,2880.00,280.00,'2023-03-06 12:50:52'),(3249,'1','303',1,'Retail Sale Id 3159',0.00,7943.00,720.00,8798.40,855.40,'2023-03-06 12:53:28'),(3250,'1','303',1,'Retail Sale Id 3160',0.00,3900.00,720.00,4320.00,420.00,'2023-03-06 12:55:27'),(3251,'1','303',1,'Retail Sale Id 3161',0.00,1352.00,720.00,1497.60,145.60,'2023-03-06 13:04:17'),(3252,'1','303',1,'Retail Sale Id 3162',0.00,3900.00,720.00,4320.00,420.00,'2023-03-06 13:07:11'),(3253,'1','303',1,'Retail Sale Id 3163',0.00,1950.00,720.00,2160.00,210.00,'2023-03-06 13:15:46'),(3254,'1','303',1,'Retail Sale Id 3164',0.00,1950.00,720.00,2160.00,210.00,'2023-03-06 13:25:35'),(3255,'1','303',1,'Retail Sale Id 3165',0.00,903.50,720.00,1000.80,97.30,'2023-03-06 13:42:14'),(3256,'1','303',1,'Retail Sale Id 3166',0.00,3900.00,720.00,4320.00,420.00,'2023-03-06 13:43:47'),(3257,'1','303',1,'Retail Sale Id 3167',0.00,1950.00,720.00,2160.00,210.00,'2023-03-06 13:58:18'),(3258,'1','303',1,'Retail Sale Id 3168',0.00,2600.00,720.00,2880.00,280.00,'2023-03-06 14:08:02'),(3259,'1','303',1,'Retail Sale Id 3169',0.00,2528.50,720.00,2800.80,272.30,'2023-03-06 14:21:39'),(3260,'1','303',1,'Retail Sale Id 3170',0.00,3900.00,720.00,4320.00,420.00,'2023-03-06 14:23:53'),(3261,'1','303',1,'Retail Sale Id 3171',0.00,3900.00,720.00,4320.00,420.00,'2023-03-06 14:25:48'),(3262,'1','303',1,'Retail Sale Id 3172',0.00,2600.00,720.00,2880.00,280.00,'2023-03-06 14:33:44'),(3263,'1','303',1,'Retail Sale Id 3173',0.00,1950.00,720.00,2160.00,210.00,'2023-03-06 14:35:34'),(3264,'1','303',1,'Retail Sale Id 3174',0.00,8125.00,720.00,9000.00,875.00,'2023-03-06 15:01:19'),(3265,'1','303',1,'Retail Sale Id 3175',0.00,8125.00,720.00,9000.00,875.00,'2023-03-06 15:32:50'),(3266,'1','303',1,'Retail Sale Id 3176',0.00,1950.00,720.00,2160.00,210.00,'2023-03-06 15:38:18'),(3267,'1','303',1,'Retail Sale Id 3177',0.00,1352.00,720.00,1497.60,145.60,'2023-03-06 15:40:50'),(3268,'1','303',1,'Retail Sale Id 3178',0.00,3614.00,720.00,4003.20,389.20,'2023-03-06 15:59:11'),(3269,'1','303',1,'Retail Sale Id 3179',0.00,1950.00,720.00,2160.00,210.00,'2023-03-06 16:24:12'),(3270,'1','303',1,'Retail Sale Id 3180',0.00,1950.00,720.00,2160.00,210.00,'2023-03-06 16:25:49'),(3271,'1','303',1,'Retail Sale Id 3181',0.00,1950.00,720.00,2160.00,210.00,'2023-03-06 16:35:28'),(3272,'1','303',1,'Retail Sale Id 3182',0.00,2710.50,720.00,3002.40,291.90,'2023-03-06 16:55:57'),(3273,'1','303',1,'Retail Sale Id 3183',0.00,1950.00,720.00,2160.00,210.00,'2023-03-06 17:00:05'),(3274,'1','303',1,'Retail Sale Id 3184',0.00,8125.00,720.00,9000.00,875.00,'2023-03-06 17:05:09'),(3275,'1','303',1,'Retail Sale Id 3185',0.00,4511.00,720.00,4996.80,485.80,'2023-03-06 17:12:57'),(3276,'1','303',1,'Retail Sale Id 3186',0.00,1950.00,720.00,2160.00,210.00,'2023-03-06 17:15:14'),(3277,'1','303',1,'Retail Sale Id 3187',0.00,1950.00,720.00,2160.00,210.00,'2023-03-06 17:18:14'),(3278,'1','303',1,'Retail Sale Id 3188',0.00,1989.00,720.00,2203.20,214.20,'2023-03-06 17:28:24'),(3279,'1','303',1,'Retail Sale Id 3189',0.00,1950.00,720.00,2160.00,210.00,'2023-03-06 17:29:23'),(3280,'1','303',1,'Retail Sale Id 3190',0.00,3900.00,720.00,4320.00,420.00,'2023-03-06 17:35:22'),(3281,'1','303',1,'Retail Sale Id 3191',0.00,1950.00,720.00,2160.00,210.00,'2023-03-06 17:49:59'),(3282,'1','303',1,'Retail Sale Id 3192',0.00,2600.00,720.00,2880.00,280.00,'2023-03-06 17:51:14'),(3283,'1','303',1,'Retail Sale Id 3193',0.00,6500.00,720.00,7200.00,700.00,'2023-03-06 17:56:19'),(3284,'1','303',1,'Retail Sale Id 3194',0.00,1950.00,720.00,2160.00,210.00,'2023-03-06 17:58:06'),(3285,'1','303',1,'Retail Sale Id 3195',0.00,3900.00,720.00,4320.00,420.00,'2023-03-06 18:05:23'),(3286,'1','303',1,'Retail Sale Id 3196',0.00,650.00,720.00,720.00,70.00,'2023-03-06 18:09:49'),(3287,'1','303',1,'Retail Sale Id 3196',0.00,8125.00,720.00,9000.00,875.00,'2023-03-06 18:09:50'),(3288,'1','303',1,'Retail Sale Id 3196',0.00,8125.00,720.00,9000.00,875.00,'2023-03-06 18:09:50'),(3289,'1','303',1,'Return of Retail Sale Id 3177',1352.00,0.00,720.00,-1497.60,-145.60,'2023-03-06 18:44:41'),(3290,'1','303',1,'Retail Sale Id 3197',0.00,1248.00,720.00,1382.40,134.40,'2023-03-06 18:45:37'),(3291,'1','303',1,'Retail Sale Id 3198',0.00,3250.00,720.00,3600.00,350.00,'2023-03-07 07:59:36'),(3292,'1','303',1,'Retail Sale Id 3198',0.00,3250.00,720.00,3600.00,350.00,'2023-03-07 07:59:36'),(3293,'1','303',1,'Retail Sale Id 3199',0.00,3250.00,720.00,3600.00,350.00,'2023-03-07 08:11:53'),(3294,'1','303',1,'Retail Sale Id 3200',0.00,1950.00,720.00,2160.00,210.00,'2023-03-07 08:35:23'),(3295,'1','303',1,'Retail Sale Id 3201',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 08:53:16'),(3296,'1','303',1,'Retail Sale Id 3202',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 08:57:15'),(3297,'1','303',1,'Retail Sale Id 3203',0.00,1950.00,720.00,2160.00,210.00,'2023-03-07 08:58:15'),(3298,'1','303',1,'Retail Sale Id 3204',0.00,8125.00,720.00,9000.00,875.00,'2023-03-07 09:02:55'),(3299,'1','303',1,'Retail Sale Id 3205',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 09:08:29'),(3300,'1','303',1,'Retail Sale Id 3206',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 09:10:19'),(3301,'1','303',1,'Retail Sale Id 3207',0.00,2600.00,720.00,2880.00,280.00,'2023-03-07 09:15:50'),(3302,'1','303',1,'Retail Sale Id 3208',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 09:17:07'),(3303,'1','303',1,'Retail Sale Id 3209',0.00,97500.00,690.00,103500.00,6000.00,'2023-03-07 09:20:43'),(3304,'1','303',1,'Retail Sale Id 3210',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 09:37:30'),(3305,'1','303',1,'Retail Sale Id 3211',0.00,3250.00,720.00,3600.00,350.00,'2023-03-07 09:39:09'),(3306,'1','303',1,'Retail Sale Id 3212',0.00,8125.00,720.00,9000.00,875.00,'2023-03-07 09:42:44'),(3307,'1','303',1,'Retail Sale Id 3213',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 10:02:55'),(3308,'1','303',1,'Retail Sale Id 3214',0.00,1950.00,720.00,2160.00,210.00,'2023-03-07 10:11:24'),(3309,'1','303',1,'Retail Sale Id 3215',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 10:14:55'),(3310,'1','303',1,'Retail Sale Id 3216',0.00,1950.00,720.00,2160.00,210.00,'2023-03-07 10:19:07'),(3311,'1','303',1,'Retail Sale Id 3217',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 10:20:36'),(3312,'1','303',1,'Retail Sale Id 3218',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 10:38:23'),(3313,'1','303',1,'Retail Sale Id 3219',0.00,65000.00,690.00,69000.00,4000.00,'2023-03-07 10:42:22'),(3314,'1','303',1,'Retail Sale Id 3220',0.00,1950.00,720.00,2160.00,210.00,'2023-03-07 10:53:05'),(3315,'1','303',1,'Retail Sale Id 3220',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 10:53:05'),(3316,'1','303',1,'Retail Sale Id 3221',0.00,8125.00,720.00,9000.00,875.00,'2023-03-07 11:06:51'),(3317,'1','303',1,'Retail Sale Id 3222',0.00,1950.00,720.00,2160.00,210.00,'2023-03-07 11:17:00'),(3318,'1','303',1,'Retail Sale Id 3223',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 11:25:49'),(3319,'1','303',1,'Retail Sale Id 3224',0.00,8125.00,720.00,9000.00,875.00,'2023-03-07 11:34:49'),(3320,'1','303',1,'Retail Sale Id 3225',0.00,3250.00,720.00,3600.00,350.00,'2023-03-07 11:36:25'),(3321,'1','303',1,'Retail Sale Id 3226',0.00,1300.00,720.00,1440.00,140.00,'2023-03-07 11:39:15'),(3322,'1','303',1,'Retail Sale Id 3227',0.00,8125.00,720.00,9000.00,875.00,'2023-03-07 11:49:10'),(3323,'1','303',1,'Retail Sale Id 3228',0.00,8125.00,720.00,9000.00,875.00,'2023-03-07 12:01:08'),(3324,'1','303',1,'Retail Sale Id 3229',0.00,3250.00,720.00,3600.00,350.00,'2023-03-07 12:12:36'),(3325,'1','303',1,'Retail Sale Id 3230',0.00,3614.00,720.00,4003.20,389.20,'2023-03-07 12:19:34'),(3326,'1','303',1,'Retail Sale Id 3231',0.00,7221.50,720.00,7999.20,777.70,'2023-03-07 12:32:20'),(3327,'1','303',1,'Retail Sale Id 3232',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 12:39:00'),(3328,'1','303',1,'Retail Sale Id 3233',0.00,3250.00,720.00,3600.00,350.00,'2023-03-07 12:40:40'),(3329,'1','303',1,'Retail Sale Id 3234',0.00,6500.00,720.00,7200.00,700.00,'2023-03-07 13:05:30'),(3330,'1','303',1,'Retail Sale Id 3235',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 13:09:34'),(3331,'1','303',1,'Retail Sale Id 3236',0.00,1625.00,720.00,1800.00,175.00,'2023-03-07 13:35:01'),(3332,'1','303',1,'Retail Sale Id 3237',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 13:38:46'),(3333,'1','303',1,'Retail Sale Id 3238',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 13:40:31'),(3334,'1','303',1,'Retail Sale Id 3239',0.00,1950.00,720.00,2160.00,210.00,'2023-03-07 13:44:05'),(3335,'1','303',1,'Retail Sale Id 3239',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 13:44:05'),(3336,'1','303',1,'Retail Sale Id 3240',0.00,1950.00,720.00,2160.00,210.00,'2023-03-07 13:59:25'),(3337,'1','303',1,'Retail Sale Id 3241',0.00,4550.00,720.00,5040.00,490.00,'2023-03-07 14:08:19'),(3338,'1','303',1,'Retail Sale Id 3242',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 14:14:25'),(3339,'1','303',1,'Retail Sale Id 3243',0.00,4550.00,720.00,5040.00,490.00,'2023-03-07 14:17:49'),(3340,'1','303',1,'Retail Sale Id 3244',0.00,1950.00,720.00,2160.00,210.00,'2023-03-07 14:19:12'),(3341,'1','303',1,'Retail Sale Id 3245',0.00,3250.00,720.00,3600.00,350.00,'2023-03-07 14:41:47'),(3342,'1','303',1,'Retail Sale Id 3246',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 14:45:32'),(3343,'1','303',1,'Retail Sale Id 3247',0.00,1261.00,720.00,1396.80,135.80,'2023-03-07 15:14:00'),(3344,'1','303',1,'Retail Sale Id 3248',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 15:30:23'),(3345,'1','303',1,'Retail Sale Id 3249',0.00,1950.00,720.00,2160.00,210.00,'2023-03-07 15:32:33'),(3346,'1','303',1,'Retail Sale Id 3250',0.00,1352.00,720.00,1497.60,145.60,'2023-03-07 16:11:22'),(3347,'1','303',1,'Retail Sale Id 3252',0.00,8125.00,720.00,9000.00,875.00,'2023-03-07 16:18:55'),(3348,'1','303',1,'Retail Sale Id 3253',0.00,1950.00,720.00,2160.00,210.00,'2023-03-07 16:19:59'),(3349,'1','303',1,'Retail Sale Id 3254',0.00,1950.00,720.00,2160.00,210.00,'2023-03-07 16:21:38'),(3350,'1','303',1,'Retail Sale Id 3255',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 16:34:11'),(3351,'1','303',1,'Retail Sale Id 3256',0.00,8125.00,720.00,9000.00,875.00,'2023-03-07 16:41:51'),(3352,'1','303',1,'Retail Sale Id 3257',0.00,650.00,720.00,720.00,70.00,'2023-03-07 17:08:24'),(3353,'1','303',1,'Retail Sale Id 3258',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 17:12:12'),(3354,'1','303',1,'Retail Sale Id 3259',0.00,1950.00,720.00,2160.00,210.00,'2023-03-07 17:22:55'),(3355,'1','303',1,'Retail Sale Id 3260',0.00,1950.00,720.00,2160.00,210.00,'2023-03-07 17:25:18'),(3356,'1','303',1,'Retail Sale Id 3260',0.00,2600.00,720.00,2880.00,280.00,'2023-03-07 17:25:18'),(3357,'1','303',1,'Retail Sale Id 3261',0.00,3250.00,720.00,3600.00,350.00,'2023-03-07 17:30:13'),(3358,'1','303',1,'Retail Sale Id 3262',0.00,1950.00,720.00,2160.00,210.00,'2023-03-07 17:37:37'),(3359,'1','303',1,'Retail Sale Id 3263',0.00,3250.00,720.00,3600.00,350.00,'2023-03-07 17:39:10'),(3360,'1','303',1,'Retail Sale Id 3264',0.00,8125.00,720.00,9000.00,875.00,'2023-03-07 17:56:06'),(3361,'1','303',1,'Retail Sale Id 3265',0.00,1625.00,720.00,1800.00,175.00,'2023-03-07 18:00:43'),(3362,'1','303',1,'Retail Sale Id 3266',0.00,903.50,720.00,1000.80,97.30,'2023-03-07 18:12:14'),(3363,'1','303',1,'Retail Sale Id 3267',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 18:15:01'),(3364,'1','303',1,'Retail Sale Id 3267',0.00,3900.00,720.00,4320.00,420.00,'2023-03-07 18:15:01'),(3365,'1','303',1,'Retail Sale Id 3268',0.00,1950.00,720.00,2160.00,210.00,'2023-03-07 18:15:59'),(3366,'1','303',1,'Retail Sale Id 3269',0.00,903.50,720.00,1000.80,97.30,'2023-03-08 08:13:56'),(3367,'1','303',1,'Retail Sale Id 3270',0.00,2600.00,720.00,2880.00,280.00,'2023-03-08 08:59:17'),(3368,'1','303',1,'Retail Sale Id 3271',0.00,1085.50,720.00,1202.40,116.90,'2023-03-08 09:04:20'),(3369,'1','303',1,'Retail Sale Id 3272',0.00,3250.00,720.00,3600.00,350.00,'2023-03-08 09:28:03'),(3370,'1','303',1,'Retail Sale Id 3273',0.00,75400.00,690.00,80040.00,4640.00,'2023-03-08 09:34:13'),(3371,'1','303',1,'Retail Sale Id 3274',0.00,1807.00,720.00,2001.60,194.60,'2023-03-08 09:44:15'),(3372,'1','303',1,'Retail Sale Id 3275',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-08 10:03:40'),(3373,'1','303',1,'Retail Sale Id 3276',0.00,2600.00,720.00,2880.00,280.00,'2023-03-08 10:05:49'),(3374,'1','303',1,'Retail Sale Id 3277',0.00,3900.00,720.00,4320.00,420.00,'2023-03-08 10:11:24'),(3375,'1','303',1,'Retail Sale Id 3278',0.00,1950.00,720.00,2160.00,210.00,'2023-03-08 10:12:44'),(3376,'1','303',1,'Retail Sale Id 3279',0.00,3900.00,720.00,4320.00,420.00,'2023-03-08 10:15:45'),(3377,'1','303',1,'Retail Sale Id 3280',0.00,1950.00,720.00,2160.00,210.00,'2023-03-08 10:23:50'),(3378,'1','303',1,'Retail Sale Id 3281',0.00,1989.00,720.00,2203.20,214.20,'2023-03-08 10:34:27'),(3379,'1','303',1,'Retail Sale Id 3282',0.00,3250.00,720.00,3600.00,350.00,'2023-03-08 10:44:20'),(3380,'1','303',1,'Retail Sale Id 3283',0.00,8125.00,720.00,9000.00,875.00,'2023-03-08 10:49:53'),(3381,'1','303',1,'Retail Sale Id 3284',0.00,1989.00,720.00,2203.20,214.20,'2023-03-08 10:55:24'),(3382,'1','303',1,'Retail Sale Id 3285',0.00,8125.00,720.00,9000.00,875.00,'2023-03-08 11:00:19'),(3383,'1','303',1,'Retail Sale Id 3286',0.00,1950.00,720.00,2160.00,210.00,'2023-03-08 11:21:02'),(3384,'1','303',1,'Retail Sale Id 3287',0.00,3900.00,720.00,4320.00,420.00,'2023-03-08 11:23:48'),(3385,'1','303',1,'Retail Sale Id 3288',0.00,903.50,720.00,1000.80,97.30,'2023-03-08 11:28:55'),(3386,'1','303',1,'Retail Sale Id 3289',0.00,3900.00,720.00,4320.00,420.00,'2023-03-08 11:43:13'),(3387,'1','303',1,'Retail Sale Id 3290',0.00,1950.00,720.00,2160.00,210.00,'2023-03-08 11:50:27'),(3388,'1','303',1,'Retail Sale Id 3290',0.00,1950.00,720.00,2160.00,210.00,'2023-03-08 11:50:27'),(3389,'1','303',1,'Retail Sale Id 3290',0.00,3900.00,720.00,4320.00,420.00,'2023-03-08 11:50:27'),(3390,'1','303',1,'Retail Sale Id 3291',0.00,65000.00,690.00,69000.00,4000.00,'2023-03-08 12:07:12'),(3391,'1','303',1,'Retail Sale Id 3292',0.00,1950.00,720.00,2160.00,210.00,'2023-03-08 12:08:50'),(3392,'1','303',1,'Retail Sale Id 3293',0.00,8125.00,720.00,9000.00,875.00,'2023-03-08 12:11:38'),(3393,'1','303',1,'Retail Sale Id 3294',0.00,8125.00,720.00,9000.00,875.00,'2023-03-08 12:13:56'),(3394,'1','303',1,'Retail Sale Id 3295',0.00,3900.00,720.00,4320.00,420.00,'2023-03-08 12:18:52'),(3395,'1','303',1,'Retail Sale Id 3296',0.00,3900.00,720.00,4320.00,420.00,'2023-03-08 12:23:48'),(3396,'1','303',1,'Retail Sale Id 3298',0.00,19565.00,720.00,21672.00,2107.00,'2023-03-08 12:35:19'),(3397,'1','303',1,'Retail Sale Id 3299',0.00,1950.00,720.00,2160.00,210.00,'2023-03-08 12:36:54'),(3398,'1','303',1,'Retail Sale Id 3300',0.00,3900.00,720.00,4320.00,420.00,'2023-03-08 12:45:01'),(3399,'1','303',1,'Return of Retail Sale Id 3298',19565.00,0.00,720.00,-21672.00,-2107.00,'2023-03-08 12:48:19'),(3400,'1','303',1,'Retail Sale Id 3301',0.00,3900.00,720.00,4320.00,420.00,'2023-03-08 13:02:16'),(3401,'1','303',1,'Retail Sale Id 3302',0.00,903.50,720.00,1000.80,97.30,'2023-03-08 13:09:02'),(3402,'1','303',1,'Retail Sale Id 3303',0.00,3900.00,720.00,4320.00,420.00,'2023-03-08 13:10:27'),(3403,'1','303',1,'Retail Sale Id 3304',0.00,3250.00,720.00,3600.00,350.00,'2023-03-08 13:13:31'),(3404,'1','303',1,'Retail Sale Id 3305',0.00,3900.00,720.00,4320.00,420.00,'2023-03-08 13:29:58'),(3405,'1','303',1,'Retail Sale Id 3305',0.00,8125.00,720.00,9000.00,875.00,'2023-03-08 13:29:58'),(3406,'1','303',1,'Retail Sale Id 3306',0.00,5850.00,720.00,6480.00,630.00,'2023-03-08 13:38:01'),(3407,'1','303',1,'Retail Sale Id 3308',0.00,1300.00,720.00,1440.00,140.00,'2023-03-08 13:44:03'),(3408,'1','303',1,'Retail Sale Id 3309',0.00,2710.50,720.00,3002.40,291.90,'2023-03-08 14:00:20'),(3409,'1','303',1,'Retail Sale Id 3310',0.00,1950.00,720.00,2160.00,210.00,'2023-03-08 14:15:15'),(3410,'1','303',1,'Retail Sale Id 3311',0.00,1807.00,720.00,2001.60,194.60,'2023-03-08 14:27:31'),(3411,'1','303',1,'Retail Sale Id 3312',0.00,1950.00,720.00,2160.00,210.00,'2023-03-08 14:29:18'),(3412,'1','303',1,'Retail Sale Id 3313',0.00,283400.00,690.00,300840.00,17440.00,'2023-03-08 14:43:09'),(3413,'1','303',1,'Retail Sale Id 3314',0.00,1950.00,720.00,2160.00,210.00,'2023-03-08 14:48:17'),(3414,'1','303',1,'Retail Sale Id 3315',0.00,8125.00,720.00,9000.00,875.00,'2023-03-08 15:08:24'),(3415,'1','303',1,'Retail Sale Id 3316',0.00,3250.00,720.00,3600.00,350.00,'2023-03-08 15:22:17'),(3416,'1','303',1,'Retail Sale Id 3317',0.00,8125.00,720.00,9000.00,875.00,'2023-03-08 15:23:55'),(3417,'1','303',1,'Retail Sale Id 3318',0.00,3900.00,720.00,4320.00,420.00,'2023-03-08 15:38:06'),(3418,'1','303',1,'Retail Sale Id 3319',0.00,3900.00,720.00,4320.00,420.00,'2023-03-08 15:46:52'),(3419,'1','303',1,'Retail Sale Id 3320',0.00,6500.00,720.00,7200.00,700.00,'2023-03-08 15:48:55'),(3420,'1','303',1,'Retail Sale Id 3321',0.00,1950.00,720.00,2160.00,210.00,'2023-03-08 16:15:15'),(3421,'1','303',1,'Retail Sale Id 3322',0.00,1950.00,720.00,2160.00,210.00,'2023-03-08 16:27:29'),(3422,'1','303',1,'Retail Sale Id 3323',0.00,1352.00,720.00,1497.60,145.60,'2023-03-08 16:36:19'),(3423,'1','303',1,'Retail Sale Id 3324',0.00,1300.00,720.00,1440.00,140.00,'2023-03-08 16:47:11'),(3424,'1','303',1,'Retail Sale Id 3325',0.00,1956.50,720.00,2167.20,210.70,'2023-03-08 16:50:00'),(3425,'1','303',1,'Retail Sale Id 3326',0.00,4511.00,720.00,4996.80,485.80,'2023-03-08 17:01:23'),(3426,'1','303',1,'Retail Sale Id 3327',0.00,8125.00,720.00,9000.00,875.00,'2023-03-08 17:13:09'),(3427,'1','303',1,'Retail Sale Id 3328',0.00,903.50,720.00,1000.80,97.30,'2023-03-08 17:20:34'),(3428,'1','303',1,'Retail Sale Id 3329',0.00,1989.00,720.00,2203.20,214.20,'2023-03-08 17:31:32'),(3429,'1','303',1,'Retail Sale Id 3330',0.00,3900.00,720.00,4320.00,420.00,'2023-03-08 17:41:38'),(3430,'1','303',1,'Retail Sale Id 3331',0.00,3900.00,720.00,4320.00,420.00,'2023-03-08 17:46:47'),(3431,'1','303',1,'Retail Sale Id 3332',0.00,3250.00,720.00,3600.00,350.00,'2023-03-08 17:49:17'),(3432,'1','303',1,'Retail Sale Id 3333',0.00,3900.00,720.00,4320.00,420.00,'2023-03-08 18:00:13'),(3433,'1','303',1,'Retail Sale Id 3334',0.00,5850.00,720.00,6480.00,630.00,'2023-03-08 18:04:14'),(3434,'1','303',1,'Retail Sale Id 3335',0.00,3250.00,720.00,3600.00,350.00,'2023-03-08 18:08:28'),(3435,'1','303',1,'Retail Sale Id 3336',0.00,650.00,720.00,720.00,70.00,'2023-03-08 18:11:43'),(3436,'1','303',1,'Retail Sale Id 3337',0.00,2600.00,720.00,2880.00,280.00,'2023-03-08 18:21:00'),(3437,'1','303',1,'Retail Sale Id 3338',0.00,6318.00,720.00,6998.40,680.40,'2023-03-08 18:34:14'),(3438,'1','303',1,'Retail Sale Id 3339',0.00,97500.00,690.00,103500.00,6000.00,'2023-03-08 18:49:50'),(3439,'1','303',1,'Retail Sale Id 3340',0.00,1943.50,720.00,2152.80,209.30,'2023-03-08 19:06:25'),(3440,'1','303',1,'Return of Retail Sale Id 3336',650.00,0.00,720.00,-720.00,-70.00,'2023-03-08 19:33:11'),(3441,'1','303',1,'Retail Sale Id 3341',0.00,416.00,720.00,460.80,44.80,'2023-03-08 19:33:49'),(3442,'1','303',1,'Retail Sale Id 3342',0.00,8125.00,720.00,9000.00,875.00,'2023-03-09 08:23:46'),(3443,'1','303',1,'Retail Sale Id 3343',0.00,8125.00,720.00,9000.00,875.00,'2023-03-09 09:02:21'),(3444,'1','303',1,'Retail Sale Id 3344',0.00,3900.00,720.00,4320.00,420.00,'2023-03-09 09:06:09'),(3445,'1','303',1,'Retail Sale Id 3345',0.00,903.50,720.00,1000.80,97.30,'2023-03-09 09:30:43'),(3446,'1','303',1,'Retail Sale Id 3346',0.00,2710.50,720.00,3002.40,291.90,'2023-03-09 09:41:22'),(3447,'1','303',1,'Retail Sale Id 3347',0.00,8125.00,720.00,9000.00,875.00,'2023-03-09 09:42:36'),(3448,'1','303',1,'Retail Sale Id 3348',0.00,3900.00,720.00,4320.00,420.00,'2023-03-09 09:44:06'),(3449,'1','303',1,'Retail Sale Id 3349',0.00,3900.00,720.00,4320.00,420.00,'2023-03-09 09:46:45'),(3450,'1','303',1,'Retail Sale Id 3350',0.00,1950.00,720.00,2160.00,210.00,'2023-03-09 10:12:06'),(3451,'1','303',1,'Retail Sale Id 3351',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-09 10:17:30'),(3452,'1','303',1,'Retail Sale Id 3352',0.00,8125.00,720.00,9000.00,875.00,'2023-03-09 10:21:25'),(3453,'1','303',1,'Retail Sale Id 3353',0.00,3900.00,720.00,4320.00,420.00,'2023-03-09 10:26:12'),(3454,'1','303',1,'Retail Sale Id 3354',0.00,8125.00,720.00,9000.00,875.00,'2023-03-09 10:59:48'),(3455,'1','303',1,'Retail Sale Id 3355',0.00,1807.00,720.00,2001.60,194.60,'2023-03-09 11:31:57'),(3456,'1','303',1,'Retail Sale Id 3356',0.00,2710.50,720.00,3002.40,291.90,'2023-03-09 11:39:26'),(3457,'1','303',1,'Retail Sale Id 3357',0.00,3900.00,720.00,4320.00,420.00,'2023-03-09 11:49:49'),(3458,'1','303',1,'Retail Sale Id 3358',0.00,3900.00,720.00,4320.00,420.00,'2023-03-09 12:00:23'),(3459,'1','303',1,'Retail Sale Id 3359',0.00,1950.00,720.00,2160.00,210.00,'2023-03-09 12:01:48'),(3460,'1','303',1,'Retail Sale Id 3360',0.00,5850.00,720.00,6480.00,630.00,'2023-03-09 12:10:00'),(3461,'1','303',1,'Retail Sale Id 3361',0.00,8125.00,720.00,9000.00,875.00,'2023-03-09 12:15:41'),(3462,'1','303',1,'Retail Sale Id 3362',0.00,6500.00,720.00,7200.00,700.00,'2023-03-09 12:17:05'),(3463,'1','303',1,'Retail Sale Id 3363',0.00,2255.50,720.00,2498.40,242.90,'2023-03-09 12:23:58'),(3464,'1','303',1,'Retail Sale Id 3364',0.00,162500.00,690.00,172500.00,10000.00,'2023-03-09 12:25:28'),(3465,'1','303',1,'Retail Sale Id 3365',0.00,903.50,720.00,1000.80,97.30,'2023-03-09 12:35:19'),(3466,'1','303',1,'Retail Sale Id 3366',0.00,1950.00,720.00,2160.00,210.00,'2023-03-09 12:41:46'),(3467,'1','303',1,'Retail Sale Id 3367',0.00,2255.50,720.00,2498.40,242.90,'2023-03-09 12:58:21'),(3468,'1','303',1,'Retail Sale Id 3368',0.00,3900.00,720.00,4320.00,420.00,'2023-03-09 13:06:07'),(3469,'1','303',1,'Retail Sale Id 3369',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-09 13:28:35'),(3470,'1','303',1,'Retail Sale Id 3370',0.00,1950.00,720.00,2160.00,210.00,'2023-03-09 13:48:35'),(3471,'1','303',1,'Retail Sale Id 3371',0.00,3900.00,720.00,4320.00,420.00,'2023-03-09 13:57:12'),(3472,'1','303',1,'Retail Sale Id 3373',0.00,3900.00,720.00,4320.00,420.00,'2023-03-09 14:00:25'),(3473,'1','303',1,'Retail Sale Id 3374',0.00,3900.00,720.00,4320.00,420.00,'2023-03-09 14:06:00'),(3474,'1','303',1,'Retail Sale Id 3375',0.00,3900.00,720.00,4320.00,420.00,'2023-03-09 14:10:14'),(3475,'1','303',1,'Retail Sale Id 3377',0.00,3900.00,720.00,4320.00,420.00,'2023-03-09 14:13:04'),(3476,'1','303',1,'Retail Sale Id 3378',0.00,3900.00,720.00,4320.00,420.00,'2023-03-09 14:18:11'),(3477,'1','303',1,'Retail Sale Id 3379',0.00,3250.00,720.00,3600.00,350.00,'2023-03-09 14:20:40'),(3478,'1','303',1,'Retail Sale Id 3380',0.00,2600.00,720.00,2880.00,280.00,'2023-03-09 14:24:06'),(3479,'1','303',1,'Retail Sale Id 3381',0.00,1950.00,720.00,2160.00,210.00,'2023-03-09 14:25:00'),(3480,'1','303',1,'Retail Sale Id 3382',0.00,8125.00,720.00,9000.00,875.00,'2023-03-09 14:33:32'),(3481,'1','303',1,'Retail Sale Id 3383',0.00,2600.00,720.00,2880.00,280.00,'2023-03-09 14:45:51'),(3482,'1','303',1,'Retail Sale Id 3384',0.00,3900.00,720.00,4320.00,420.00,'2023-03-09 14:53:12'),(3483,'1','303',1,'Retail Sale Id 3385',0.00,1950.00,720.00,2160.00,210.00,'2023-03-09 14:55:52'),(3484,'1','303',1,'Retail Sale Id 3386',0.00,903.50,720.00,1000.80,97.30,'2023-03-09 15:08:58'),(3485,'1','303',1,'Retail Sale Id 3387',0.00,3900.00,720.00,4320.00,420.00,'2023-03-09 15:45:38'),(3486,'1','303',1,'Retail Sale Id 3388',0.00,5850.00,720.00,6480.00,630.00,'2023-03-09 16:03:53'),(3487,'1','303',1,'Retail Sale Id 3389',0.00,8125.00,720.00,9000.00,875.00,'2023-03-09 16:04:57'),(3488,'1','303',1,'Retail Sale Id 3390',0.00,1950.00,720.00,2160.00,210.00,'2023-03-09 16:20:06'),(3489,'1','303',1,'Retail Sale Id 3390',0.00,8125.00,720.00,9000.00,875.00,'2023-03-09 16:20:06'),(3490,'1','303',1,'Retail Sale Id 3391',0.00,81250.00,720.00,90000.00,8750.00,'2023-03-09 16:37:13'),(3491,'1','303',1,'Retail Sale Id 3392',0.00,1950.00,720.00,2160.00,210.00,'2023-03-09 16:57:51'),(3492,'1','303',1,'Retail Sale Id 3393',0.00,8125.00,720.00,9000.00,875.00,'2023-03-09 17:20:23'),(3493,'1','303',1,'Retail Sale Id 3394',0.00,3900.00,720.00,4320.00,420.00,'2023-03-09 17:25:36'),(3494,'1','303',1,'Retail Sale Id 3395',0.00,3900.00,720.00,4320.00,420.00,'2023-03-09 17:39:21'),(3495,'1','303',1,'Retail Sale Id 3396',0.00,3789.50,720.00,4197.60,408.10,'2023-03-09 17:51:20'),(3496,'1','303',1,'Retail Sale Id 3397',0.00,3900.00,720.00,4320.00,420.00,'2023-03-09 18:02:19'),(3497,'1','303',1,'Retail Sale Id 3398',0.00,1950.00,720.00,2160.00,210.00,'2023-03-09 18:07:10'),(3498,'1','303',1,'Return of Retail Sale Id 3391',81250.00,0.00,720.00,-90000.00,-8750.00,'2023-03-09 18:24:29'),(3499,'1','303',1,'Retail Sale Id 3399',0.00,8125.00,720.00,9000.00,875.00,'2023-03-09 18:25:09'),(3500,'1','303',1,'Retail Sale Id 3400',0.00,903.50,720.00,1000.80,97.30,'2023-03-10 07:46:53'),(3501,'1','303',1,'Retail Sale Id 3401',0.00,1950.00,720.00,2160.00,210.00,'2023-03-10 08:13:17'),(3502,'1','303',1,'Retail Sale Id 3402',0.00,3250.00,720.00,3600.00,350.00,'2023-03-10 08:28:18'),(3503,'1','303',1,'Retail Sale Id 3403',0.00,1352.00,720.00,1497.60,145.60,'2023-03-10 08:31:59'),(3504,'1','303',1,'Retail Sale Id 3404',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 08:49:04'),(3505,'1','303',1,'Retail Sale Id 3405',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 08:58:38'),(3506,'1','303',1,'Retail Sale Id 3406',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 09:10:23'),(3507,'1','303',1,'Retail Sale Id 3407',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 09:16:00'),(3508,'1','303',1,'Retail Sale Id 3408',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 09:17:23'),(3509,'1','303',1,'Retail Sale Id 3409',0.00,3250.00,720.00,3600.00,350.00,'2023-03-10 09:18:51'),(3510,'1','303',1,'Retail Sale Id 3410',0.00,8125.00,720.00,9000.00,875.00,'2023-03-10 09:40:51'),(3511,'1','303',1,'Retail Sale Id 3410',0.00,8125.00,720.00,9000.00,875.00,'2023-03-10 09:40:51'),(3512,'1','303',1,'Retail Sale Id 3411',0.00,1950.00,720.00,2160.00,210.00,'2023-03-10 10:00:25'),(3513,'1','303',1,'Retail Sale Id 3412',0.00,1807.00,720.00,2001.60,194.60,'2023-03-10 10:16:27'),(3514,'1','303',1,'Retail Sale Id 3413',0.00,1950.00,720.00,2160.00,210.00,'2023-03-10 10:24:31'),(3515,'1','303',1,'Retail Sale Id 3413',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 10:24:31'),(3516,'1','303',1,'Retail Sale Id 3414',0.00,8125.00,720.00,9000.00,875.00,'2023-03-10 10:34:05'),(3517,'1','303',1,'Retail Sale Id 3415',0.00,1950.00,720.00,2160.00,210.00,'2023-03-10 10:53:37'),(3518,'1','303',1,'Retail Sale Id 3416',0.00,8125.00,720.00,9000.00,875.00,'2023-03-10 11:07:07'),(3519,'1','303',1,'Retail Sale Id 3417',0.00,1950.00,720.00,2160.00,210.00,'2023-03-10 11:09:28'),(3520,'1','303',1,'Retail Sale Id 3418',0.00,903.50,720.00,1000.80,97.30,'2023-03-10 11:19:18'),(3521,'1','303',1,'Retail Sale Id 3419',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 11:21:58'),(3522,'1','303',1,'Retail Sale Id 3420',0.00,1352.00,720.00,1497.60,145.60,'2023-03-10 11:36:14'),(3523,'1','303',1,'Retail Sale Id 3421',0.00,1950.00,720.00,2160.00,210.00,'2023-03-10 11:54:27'),(3524,'1','303',1,'Retail Sale Id 3422',0.00,1950.00,720.00,2160.00,210.00,'2023-03-10 12:07:07'),(3525,'1','303',1,'Retail Sale Id 3423',0.00,1950.00,720.00,2160.00,210.00,'2023-03-10 12:15:13'),(3526,'1','303',1,'Retail Sale Id 3424',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 12:27:43'),(3527,'1','303',1,'Retail Sale Id 3425',0.00,37700.00,690.00,40020.00,2320.00,'2023-03-10 12:33:59'),(3528,'1','303',1,'Retail Sale Id 3426',0.00,1300.00,720.00,1440.00,140.00,'2023-03-10 13:05:33'),(3529,'1','303',1,'Retail Sale Id 3426',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 13:05:33'),(3530,'1','303',1,'Retail Sale Id 3427',0.00,1352.00,720.00,1497.60,145.60,'2023-03-10 13:14:04'),(3531,'1','303',1,'Retail Sale Id 3428',0.00,1950.00,720.00,2160.00,210.00,'2023-03-10 13:15:53'),(3532,'1','303',1,'Retail Sale Id 3429',0.00,3250.00,720.00,3600.00,350.00,'2023-03-10 14:02:47'),(3533,'1','303',1,'Retail Sale Id 3430',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 14:09:31'),(3534,'1','303',1,'Retail Sale Id 3431',0.00,8125.00,720.00,9000.00,875.00,'2023-03-10 14:52:42'),(3535,'1','303',1,'Retail Sale Id 3432',0.00,8125.00,720.00,9000.00,875.00,'2023-03-10 14:54:18'),(3536,'1','303',1,'Retail Sale Id 3433',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 15:01:13'),(3537,'1','303',1,'Retail Sale Id 3434',0.00,1950.00,720.00,2160.00,210.00,'2023-03-10 15:02:32'),(3538,'1','303',1,'Retail Sale Id 3435',0.00,8125.00,720.00,9000.00,875.00,'2023-03-10 15:31:41'),(3539,'1','303',1,'Retail Sale Id 3436',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 15:33:29'),(3540,'1','303',1,'Retail Sale Id 3437',0.00,1950.00,720.00,2160.00,210.00,'2023-03-10 15:57:42'),(3541,'1','303',1,'Retail Sale Id 3438',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 15:59:18'),(3542,'1','303',1,'Retail Sale Id 3439',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 16:02:02'),(3543,'1','303',1,'Retail Sale Id 3440',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-10 16:18:28'),(3544,'1','303',1,'Retail Sale Id 3441',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 16:24:11'),(3545,'1','303',1,'Retail Sale Id 3442',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 16:26:06'),(3546,'1','303',1,'Retail Sale Id 3443',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 16:38:09'),(3547,'1','303',1,'Retail Sale Id 3444',0.00,1950.00,720.00,2160.00,210.00,'2023-03-10 16:42:00'),(3548,'1','303',1,'Retail Sale Id 3444',0.00,1950.00,720.00,2160.00,210.00,'2023-03-10 16:42:00'),(3549,'1','303',1,'Retail Sale Id 3445',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 16:54:20'),(3550,'1','303',1,'Retail Sale Id 3446',0.00,3250.00,720.00,3600.00,350.00,'2023-03-10 17:03:57'),(3551,'1','303',1,'Retail Sale Id 3447',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 17:06:31'),(3552,'1','303',1,'Retail Sale Id 3448',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 17:10:50'),(3553,'1','303',1,'Retail Sale Id 3449',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 17:15:13'),(3554,'1','303',1,'Retail Sale Id 3450',0.00,3250.00,720.00,3600.00,350.00,'2023-03-10 17:30:28'),(3555,'1','303',1,'Retail Sale Id 3450',0.00,6500.00,720.00,7200.00,700.00,'2023-03-10 17:30:28'),(3556,'1','303',1,'Retail Sale Id 3451',0.00,5850.00,720.00,6480.00,630.00,'2023-03-10 17:39:22'),(3557,'1','303',1,'Retail Sale Id 3452',0.00,3250.00,720.00,3600.00,350.00,'2023-03-10 17:47:25'),(3558,'1','303',1,'Retail Sale Id 3453',0.00,1950.00,720.00,2160.00,210.00,'2023-03-10 17:54:36'),(3559,'1','303',1,'Retail Sale Id 3454',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 17:59:47'),(3560,'1','303',1,'Retail Sale Id 3455',0.00,8125.00,720.00,9000.00,875.00,'2023-03-10 18:05:31'),(3561,'1','303',1,'Retail Sale Id 3456',0.00,3900.00,720.00,4320.00,420.00,'2023-03-10 18:14:30'),(3562,'1','303',1,'Retail Sale Id 3457',0.00,650.00,720.00,720.00,70.00,'2023-03-10 18:25:49'),(3563,'1','303',1,'Retail Sale Id 3458',0.00,8716.50,720.00,9655.20,938.70,'2023-03-10 18:53:46'),(3564,'1','303',1,'Retail Sale Id 3459',0.00,3250.00,720.00,3600.00,350.00,'2023-03-11 07:49:43'),(3565,'1','303',1,'Retail Sale Id 3460',0.00,3900.00,720.00,4320.00,420.00,'2023-03-11 08:11:54'),(3566,'1','303',1,'Retail Sale Id 3461',0.00,2710.50,720.00,3002.40,291.90,'2023-03-11 08:46:33'),(3567,'1','303',1,'Retail Sale Id 3462',0.00,4511.00,720.00,4996.80,485.80,'2023-03-11 09:07:00'),(3568,'1','303',1,'Retail Sale Id 3463',0.00,4511.00,720.00,4996.80,485.80,'2023-03-11 09:07:50'),(3569,'1','303',1,'Retail Sale Id 3464',0.00,3900.00,720.00,4320.00,420.00,'2023-03-11 09:23:12'),(3570,'1','303',1,'Retail Sale Id 3465',0.00,2528.50,720.00,2800.80,272.30,'2023-03-11 09:40:57'),(3571,'1','303',1,'Retail Sale Id 3466',0.00,3880.50,720.00,4298.40,417.90,'2023-03-11 09:54:03'),(3572,'1','303',1,'Retail Sale Id 3467',0.00,3900.00,720.00,4320.00,420.00,'2023-03-11 10:06:21'),(3573,'1','303',1,'Retail Sale Id 3468',0.00,1950.00,720.00,2160.00,210.00,'2023-03-11 10:21:11'),(3574,'1','303',1,'Retail Sale Id 3469',0.00,3250.00,720.00,3600.00,350.00,'2023-03-11 10:41:48'),(3575,'1','303',1,'Retail Sale Id 3470',0.00,3900.00,720.00,4320.00,420.00,'2023-03-11 10:46:56'),(3576,'1','303',1,'Retail Sale Id 3471',0.00,65000.00,690.00,69000.00,4000.00,'2023-03-11 10:49:23'),(3577,'1','303',1,'Retail Sale Id 3472',0.00,1950.00,720.00,2160.00,210.00,'2023-03-11 10:53:56'),(3578,'1','303',1,'Retail Sale Id 3473',0.00,1950.00,720.00,2160.00,210.00,'2023-03-11 10:57:00'),(3579,'1','303',1,'Retail Sale Id 3474',0.00,3900.00,720.00,4320.00,420.00,'2023-03-11 11:02:44'),(3580,'1','303',1,'Retail Sale Id 3475',0.00,8125.00,720.00,9000.00,875.00,'2023-03-11 11:04:15'),(3581,'1','303',1,'Retail Sale Id 3476',0.00,1950.00,720.00,2160.00,210.00,'2023-03-11 11:07:00'),(3582,'1','303',1,'Retail Sale Id 3477',0.00,8125.00,720.00,9000.00,875.00,'2023-03-11 11:17:14'),(3583,'1','303',1,'Retail Sale Id 3478',0.00,8125.00,720.00,9000.00,875.00,'2023-03-11 11:25:54'),(3584,'1','303',1,'Retail Sale Id 3479',0.00,3900.00,720.00,4320.00,420.00,'2023-03-11 11:31:45'),(3585,'1','303',1,'Retail Sale Id 3481',0.00,37700.00,690.00,40020.00,2320.00,'2023-03-11 11:38:38'),(3586,'1','303',1,'Retail Sale Id 3482',0.00,1950.00,720.00,2160.00,210.00,'2023-03-11 11:39:34'),(3587,'1','303',1,'Retail Sale Id 3483',0.00,3900.00,720.00,4320.00,420.00,'2023-03-11 11:42:26'),(3588,'1','303',1,'Retail Sale Id 3484',0.00,3900.00,720.00,4320.00,420.00,'2023-03-11 11:43:48'),(3589,'1','303',1,'Retail Sale Id 3485',0.00,5850.00,720.00,6480.00,630.00,'2023-03-11 11:52:12'),(3590,'1','303',1,'Retail Sale Id 3486',0.00,3900.00,720.00,4320.00,420.00,'2023-03-11 11:57:34'),(3591,'1','303',1,'Retail Sale Id 3486',0.00,6500.00,720.00,7200.00,700.00,'2023-03-11 11:57:34'),(3592,'1','303',1,'Retail Sale Id 3487',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-11 12:05:23'),(3593,'1','303',1,'Retail Sale Id 3488',0.00,1807.00,720.00,2001.60,194.60,'2023-03-11 12:09:21'),(3594,'1','303',1,'Retail Sale Id 3489',0.00,3900.00,720.00,4320.00,420.00,'2023-03-11 12:13:47'),(3595,'1','303',1,'Retail Sale Id 3490',0.00,3900.00,720.00,4320.00,420.00,'2023-03-11 12:23:42'),(3596,'1','303',1,'Retail Sale Id 3491',0.00,8125.00,720.00,9000.00,875.00,'2023-03-11 12:25:41'),(3597,'1','303',1,'Retail Sale Id 3492',0.00,3900.00,720.00,4320.00,420.00,'2023-03-11 12:49:00'),(3598,'1','303',1,'Retail Sale Id 3493',0.00,903.50,720.00,1000.80,97.30,'2023-03-11 12:53:03'),(3599,'1','303',1,'Retail Sale Id 3494',0.00,16250.00,720.00,18000.00,1750.00,'2023-03-11 12:57:08'),(3600,'1','303',1,'Retail Sale Id 3495',0.00,2710.50,720.00,3002.40,291.90,'2023-03-11 13:22:25'),(3601,'1','303',1,'Retail Sale Id 3496',0.00,3900.00,720.00,4320.00,420.00,'2023-03-11 13:25:04'),(3602,'1','303',1,'Retail Sale Id 3497',0.00,1300.00,720.00,1440.00,140.00,'2023-03-11 13:31:43'),(3603,'1','303',1,'Retail Sale Id 3498',0.00,650.00,720.00,720.00,70.00,'2023-03-11 13:38:13'),(3604,'1','303',1,'Retail Sale Id 3499',0.00,3900.00,720.00,4320.00,420.00,'2023-03-11 13:40:58'),(3605,'1','303',1,'Retail Sale Id 3500',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-11 13:43:07'),(3606,'1','303',1,'Retail Sale Id 3501',0.00,8125.00,720.00,9000.00,875.00,'2023-03-11 13:44:55'),(3607,'1','303',1,'Retail Sale Id 3502',0.00,3900.00,720.00,4320.00,420.00,'2023-03-11 13:56:54'),(3608,'1','303',1,'Retail Sale Id 3503',0.00,3900.00,720.00,4320.00,420.00,'2023-03-11 13:59:10'),(3609,'1','303',1,'Retail Sale Id 3504',0.00,1300.00,720.00,1440.00,140.00,'2023-03-11 14:00:29'),(3610,'1','303',1,'Retail Sale Id 3505',0.00,65000.00,690.00,69000.00,4000.00,'2023-03-11 14:01:45'),(3611,'1','303',1,'Retail Sale Id 3506',0.00,3250.00,720.00,3600.00,350.00,'2023-03-11 14:03:26'),(3612,'1','303',1,'Retail Sale Id 3507',0.00,8125.00,720.00,9000.00,875.00,'2023-03-11 14:18:00'),(3613,'1','303',1,'Retail Sale Id 3508',0.00,5850.00,720.00,6480.00,630.00,'2023-03-11 14:18:52'),(3614,'1','303',1,'Retail Sale Id 3509',0.00,1807.00,720.00,2001.60,194.60,'2023-03-11 14:29:12'),(3615,'1','303',1,'Retail Sale Id 3510',0.00,8125.00,720.00,9000.00,875.00,'2023-03-11 14:43:44'),(3616,'1','303',1,'Retail Sale Id 3511',0.00,3900.00,720.00,4320.00,420.00,'2023-03-11 14:50:33'),(3617,'1','303',1,'Retail Sale Id 3512',0.00,3900.00,720.00,4320.00,420.00,'2023-03-11 14:55:07'),(3618,'1','303',1,'Retail Sale Id 3513',0.00,8125.00,720.00,9000.00,875.00,'2023-03-11 15:01:37'),(3619,'1','303',1,'Retail Sale Id 3514',0.00,1300.00,720.00,1440.00,140.00,'2023-03-11 15:13:45'),(3620,'1','303',1,'Retail Sale Id 3515',0.00,195000.00,690.00,207000.00,12000.00,'2023-03-11 15:28:08'),(3621,'1','303',1,'Retail Sale Id 3516',0.00,1950.00,720.00,2160.00,210.00,'2023-03-11 15:38:08'),(3622,'1','303',1,'Retail Sale Id 3517',0.00,650.00,720.00,720.00,70.00,'2023-03-11 15:43:01'),(3623,'1','303',1,'Retail Sale Id 3518',0.00,903.50,720.00,1000.80,97.30,'2023-03-11 16:11:41'),(3624,'1','303',1,'Retail Sale Id 3519',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-11 16:13:04'),(3625,'1','303',1,'Retail Sale Id 3520',0.00,3250.00,720.00,3600.00,350.00,'2023-03-11 16:13:56'),(3626,'1','303',1,'Retail Sale Id 3521',0.00,2600.00,720.00,2880.00,280.00,'2023-03-11 16:16:11'),(3627,'1','303',1,'Retail Sale Id 3522',0.00,903.50,720.00,1000.80,97.30,'2023-03-11 16:21:04'),(3628,'1','303',1,'Retail Sale Id 3523',0.00,3900.00,720.00,4320.00,420.00,'2023-03-11 16:24:32'),(3629,'1','303',1,'Retail Sale Id 3524',0.00,1950.00,720.00,2160.00,210.00,'2023-03-11 16:26:30'),(3630,'1','303',1,'Retail Sale Id 3525',0.00,3900.00,720.00,4320.00,420.00,'2023-03-11 16:29:12'),(3631,'1','303',1,'Retail Sale Id 3526',0.00,1300.00,720.00,1440.00,140.00,'2023-03-11 16:30:46'),(3632,'1','303',1,'Retail Sale Id 3527',0.00,1950.00,720.00,2160.00,210.00,'2023-03-11 16:34:04'),(3633,'1','303',1,'Retail Sale Id 3528',0.00,1950.00,720.00,2160.00,210.00,'2023-03-11 16:36:13'),(3634,'1','303',1,'Retail Sale Id 3528',0.00,8125.00,720.00,9000.00,875.00,'2023-03-11 16:36:13'),(3635,'1','303',1,'Retail Sale Id 3529',0.00,2600.00,720.00,2880.00,280.00,'2023-03-11 16:38:12'),(3636,'1','303',1,'Retail Sale Id 3530',0.00,1352.00,720.00,1497.60,145.60,'2023-03-11 16:48:28'),(3637,'1','303',1,'Retail Sale Id 3531',0.00,4062.50,720.00,4500.00,437.50,'2023-03-11 16:52:18'),(3638,'1','303',1,'Retail Sale Id 3532',0.00,1352.00,720.00,1497.60,145.60,'2023-03-11 16:55:27'),(3639,'1','303',1,'Retail Sale Id 3533',0.00,8125.00,720.00,9000.00,875.00,'2023-03-11 16:57:16'),(3640,'1','303',1,'Retail Sale Id 3534',0.00,1950.00,720.00,2160.00,210.00,'2023-03-11 17:00:26'),(3641,'1','303',1,'Retail Sale Id 3535',0.00,1950.00,720.00,2160.00,210.00,'2023-03-11 17:06:50'),(3642,'1','303',1,'Retail Sale Id 3536',0.00,11700.00,720.00,12960.00,1260.00,'2023-03-11 17:08:43'),(3643,'1','303',1,'Retail Sale Id 3537',0.00,3900.00,720.00,4320.00,420.00,'2023-03-11 17:11:48'),(3644,'1','303',1,'Retail Sale Id 3538',0.00,3900.00,720.00,4320.00,420.00,'2023-03-11 17:18:07'),(3645,'1','303',1,'Retail Sale Id 3539',0.00,2600.00,720.00,2880.00,280.00,'2023-03-11 17:24:50'),(3646,'1','303',1,'Retail Sale Id 3540',0.00,1950.00,720.00,2160.00,210.00,'2023-03-11 17:32:48'),(3647,'1','303',1,'Retail Sale Id 3541',0.00,1950.00,720.00,2160.00,210.00,'2023-03-11 17:40:39'),(3648,'1','303',1,'Retail Sale Id 3542',0.00,1950.00,720.00,2160.00,210.00,'2023-03-11 17:46:32'),(3649,'1','303',1,'Retail Sale Id 3543',0.00,1950.00,720.00,2160.00,210.00,'2023-03-11 17:49:16'),(3650,'1','303',1,'Retail Sale Id 3544',0.00,2600.00,720.00,2880.00,280.00,'2023-03-11 17:50:27'),(3651,'1','303',1,'Retail Sale Id 3545',0.00,650000.00,690.00,690000.00,40000.00,'2023-03-11 18:33:26'),(3652,'1','303',1,'Retail Sale Id 3546',0.00,225621.50,720.00,249919.20,24297.70,'2023-03-11 19:21:39'),(3653,'1','303',1,'Return of Retail Sale Id 3546',225621.50,0.00,720.00,-249919.20,-24297.70,'2023-03-11 19:23:41'),(3654,'1','303',1,'Return of Retail Sale Id 3536',11700.00,0.00,720.00,-12960.00,-1260.00,'2023-03-11 19:33:48'),(3655,'1','303',1,'Return of Retail Sale Id 3528',1950.00,0.00,720.00,-2160.00,-210.00,'2023-03-11 19:36:41'),(3656,'1','303',1,'Return of Retail Sale Id 3528',8125.00,0.00,720.00,-9000.00,-875.00,'2023-03-11 19:36:41'),(3657,'1','303',1,'Return of Retail Sale Id 3544',2600.00,0.00,720.00,-2880.00,-280.00,'2023-03-11 19:37:53'),(3658,'1','303',1,'Return of Retail Sale Id 3542',1950.00,0.00,720.00,-2160.00,-210.00,'2023-03-11 19:39:55'),(3659,'1','303',1,'Return of Retail Sale Id 3529',2600.00,0.00,720.00,-2880.00,-280.00,'2023-03-11 19:40:36'),(3660,'1','303',1,'Return of Retail Sale Id 3538',3900.00,0.00,720.00,-4320.00,-420.00,'2023-03-11 19:41:50'),(3661,'1','303',1,'Return of Retail Sale Id 3541',1950.00,0.00,720.00,-2160.00,-210.00,'2023-03-11 19:43:14'),(3662,'1','303',1,'Return of Retail Sale Id 3537',3900.00,0.00,720.00,-4320.00,-420.00,'2023-03-11 19:43:58'),(3663,'1','303',1,'Return of Retail Sale Id 3531',4062.50,0.00,720.00,-4500.00,-437.50,'2023-03-11 19:45:39'),(3664,'1','303',1,'Return of Retail Sale Id 3533',8125.00,0.00,720.00,-9000.00,-875.00,'2023-03-11 19:46:39'),(3665,'1','303',1,'Return of Retail Sale Id 3522',903.50,0.00,720.00,-1000.80,-97.30,'2023-03-11 19:47:34'),(3666,'1','303',1,'Return of Retail Sale Id 3494',16250.00,0.00,720.00,-18000.00,-1750.00,'2023-03-11 19:48:48'),(3667,'1','303',1,'Return of Retail Sale Id 3501',8125.00,0.00,720.00,-9000.00,-875.00,'2023-03-11 19:49:50'),(3668,'1','303',1,'Return of Retail Sale Id 3508',5850.00,0.00,720.00,-6480.00,-630.00,'2023-03-11 19:51:12'),(3669,'1','303',1,'Return of Retail Sale Id 3525',3900.00,0.00,720.00,-4320.00,-420.00,'2023-03-11 20:04:52'),(3670,'1','303',1,'Return of Retail Sale Id 3478',8125.00,0.00,720.00,-9000.00,-875.00,'2023-03-11 20:05:45'),(3671,'1','303',1,'Return of Retail Sale Id 3477',8125.00,0.00,720.00,-9000.00,-875.00,'2023-03-11 20:06:27'),(3672,'1','303',1,'Return of Retail Sale Id 3475',8125.00,0.00,720.00,-9000.00,-875.00,'2023-03-11 20:07:38'),(3673,'1','303',1,'Return of Retail Sale Id 3496',3900.00,0.00,720.00,-4320.00,-420.00,'2023-03-11 20:08:32'),(3674,'1','303',1,'Return of Retail Sale Id 3535',1950.00,0.00,720.00,-2160.00,-210.00,'2023-03-11 20:09:23'),(3675,'1','303',1,'Return of Retail Sale Id 3474',3900.00,0.00,720.00,-4320.00,-420.00,'2023-03-11 20:10:09'),(3676,'1','303',1,'Return of Retail Sale Id 3502',3900.00,0.00,720.00,-4320.00,-420.00,'2023-03-11 20:11:20'),(3677,'1','303',1,'Return of Retail Sale Id 3495',2710.50,0.00,720.00,-3002.40,-291.90,'2023-03-11 20:12:15'),(3678,'1','303',1,'Return of Retail Sale Id 3486',3900.00,0.00,720.00,-4320.00,-420.00,'2023-03-11 20:13:24'),(3679,'1','303',1,'Return of Retail Sale Id 3486',6500.00,0.00,720.00,-7200.00,-700.00,'2023-03-11 20:13:24'),(3680,'1','303',1,'Return of Retail Sale Id 3492',3900.00,0.00,720.00,-4320.00,-420.00,'2023-03-11 20:15:33'),(3681,'1','303',1,'Return of Retail Sale Id 3532',1352.00,0.00,720.00,-1497.60,-145.60,'2023-03-11 20:16:53'),(3682,'1','303',1,'Return of Retail Sale Id 3485',5850.00,0.00,720.00,-6480.00,-630.00,'2023-03-11 20:18:19'),(3683,'1','303',1,'Retail Sale Id 3547',0.00,148161.00,720.00,164116.80,15955.80,'2023-03-11 20:26:48'),(3684,'1','303',1,'Retail Sale Id 3548',0.00,3900.00,720.00,4320.00,420.00,'2023-03-12 08:04:28'),(3685,'1','303',1,'Retail Sale Id 3549',0.00,3900.00,720.00,4320.00,420.00,'2023-03-12 08:23:17'),(3686,'1','303',1,'Retail Sale Id 3550',0.00,3250.00,720.00,3600.00,350.00,'2023-03-12 08:41:53'),(3687,'1','303',1,'Retail Sale Id 3551',0.00,3900.00,720.00,4320.00,420.00,'2023-03-12 08:43:09'),(3688,'1','303',1,'Retail Sale Id 3552',0.00,3250.00,720.00,3600.00,350.00,'2023-03-12 09:01:04'),(3689,'1','303',1,'Retail Sale Id 3553',0.00,6500.00,720.00,7200.00,700.00,'2023-03-12 09:09:56'),(3690,'1','303',1,'Retail Sale Id 3554',0.00,16250.00,720.00,18000.00,1750.00,'2023-03-12 09:17:29'),(3691,'1','303',1,'Retail Sale Id 3555',0.00,3250.00,720.00,3600.00,350.00,'2023-03-12 09:25:32'),(3692,'1','303',1,'Retail Sale Id 3556',0.00,8125.00,720.00,9000.00,875.00,'2023-03-12 09:27:42'),(3693,'1','303',1,'Retail Sale Id 3557',0.00,1807.00,720.00,2001.60,194.60,'2023-03-12 09:28:30'),(3694,'1','303',1,'Retail Sale Id 3558',0.00,65000.00,690.00,69000.00,4000.00,'2023-03-12 10:12:14'),(3695,'1','303',1,'Retail Sale Id 3559',0.00,3250.00,720.00,3600.00,350.00,'2023-03-12 10:16:05'),(3696,'1','303',1,'Retail Sale Id 3560',0.00,3900.00,720.00,4320.00,420.00,'2023-03-12 10:27:16'),(3697,'1','303',1,'Retail Sale Id 3561',0.00,123500.00,690.00,131100.00,7600.00,'2023-03-12 10:30:51'),(3698,'1','303',1,'Retail Sale Id 3562',0.00,1950.00,720.00,2160.00,210.00,'2023-03-12 10:39:15'),(3699,'1','303',1,'Retail Sale Id 3563',0.00,903.50,720.00,1000.80,97.30,'2023-03-12 10:40:49'),(3700,'1','303',1,'Retail Sale Id 3564',0.00,3250.00,720.00,3600.00,350.00,'2023-03-12 10:51:42'),(3701,'1','303',1,'Retail Sale Id 3565',0.00,3250.00,720.00,3600.00,350.00,'2023-03-12 10:58:56'),(3702,'1','303',1,'Retail Sale Id 3565',0.00,3250.00,720.00,3600.00,350.00,'2023-03-12 10:58:56'),(3703,'1','303',1,'Retail Sale Id 3565',0.00,3250.00,720.00,3600.00,350.00,'2023-03-12 10:58:56'),(3704,'1','303',1,'Retail Sale Id 3566',0.00,1950.00,720.00,2160.00,210.00,'2023-03-12 11:01:21'),(3705,'1','303',1,'Retail Sale Id 3567',0.00,3900.00,720.00,4320.00,420.00,'2023-03-12 11:04:07'),(3706,'1','303',1,'Retail Sale Id 3567',0.00,6500.00,720.00,7200.00,700.00,'2023-03-12 11:04:07'),(3707,'1','303',1,'Retail Sale Id 3568',0.00,3900.00,720.00,4320.00,420.00,'2023-03-12 11:06:14'),(3708,'1','303',1,'Retail Sale Id 3569',0.00,16250.00,720.00,18000.00,1750.00,'2023-03-12 11:07:25'),(3709,'1','303',1,'Retail Sale Id 3570',0.00,130000.00,690.00,138000.00,8000.00,'2023-03-12 11:12:06'),(3710,'1','303',1,'Retail Sale Id 3571',0.00,7221.50,720.00,7999.20,777.70,'2023-03-12 11:27:16'),(3711,'1','303',1,'Retail Sale Id 3572',0.00,1807.00,720.00,2001.60,194.60,'2023-03-12 11:32:03'),(3712,'1','303',1,'Retail Sale Id 3573',0.00,1950.00,720.00,2160.00,210.00,'2023-03-12 11:33:52'),(3713,'1','303',1,'Retail Sale Id 3574',0.00,903.50,720.00,1000.80,97.30,'2023-03-12 11:43:01'),(3714,'1','303',1,'Retail Sale Id 3575',0.00,65000.00,690.00,69000.00,4000.00,'2023-03-12 11:49:07'),(3715,'1','303',1,'Retail Sale Id 3576',0.00,1989.00,720.00,2203.20,214.20,'2023-03-12 12:08:13'),(3716,'1','303',1,'Retail Sale Id 3577',0.00,3900.00,720.00,4320.00,420.00,'2023-03-12 12:21:12'),(3717,'1','303',1,'Retail Sale Id 3578',0.00,3250.00,720.00,3600.00,350.00,'2023-03-12 12:24:29'),(3718,'1','303',1,'Retail Sale Id 3579',0.00,3900.00,720.00,4320.00,420.00,'2023-03-12 12:26:46'),(3719,'1','303',1,'Retail Sale Id 3580',0.00,1300.00,720.00,1440.00,140.00,'2023-03-12 12:31:20'),(3720,'1','303',1,'Retail Sale Id 3580',0.00,1950.00,720.00,2160.00,210.00,'2023-03-12 12:31:20'),(3721,'1','303',1,'Retail Sale Id 3581',0.00,1950.00,720.00,2160.00,210.00,'2023-03-12 12:33:20'),(3722,'1','303',1,'Retail Sale Id 3582',0.00,8125.00,720.00,9000.00,875.00,'2023-03-12 12:34:39'),(3723,'1','303',1,'Retail Sale Id 3583',0.00,3614.00,720.00,4003.20,389.20,'2023-03-12 12:36:44'),(3724,'1','303',1,'Retail Sale Id 3584',0.00,8125.00,720.00,9000.00,875.00,'2023-03-12 12:40:09'),(3725,'1','303',1,'Retail Sale Id 3585',0.00,3250.00,720.00,3600.00,350.00,'2023-03-12 12:50:34'),(3726,'1','303',1,'Retail Sale Id 3586',0.00,8125.00,720.00,9000.00,875.00,'2023-03-12 12:52:48'),(3727,'1','303',1,'Retail Sale Id 3587',0.00,3900.00,720.00,4320.00,420.00,'2023-03-12 12:56:27'),(3728,'1','303',1,'Retail Sale Id 3588',0.00,65000.00,690.00,69000.00,4000.00,'2023-03-12 13:21:13'),(3729,'1','303',1,'Retail Sale Id 3589',0.00,3900.00,720.00,4320.00,420.00,'2023-03-12 13:29:04'),(3730,'1','303',1,'Retail Sale Id 3590',0.00,3900.00,720.00,4320.00,420.00,'2023-03-12 13:39:22'),(3731,'1','303',1,'Retail Sale Id 3591',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-12 13:42:49'),(3732,'1','303',1,'Retail Sale Id 3592',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-12 13:44:13'),(3733,'1','303',1,'Retail Sale Id 3593',0.00,3900.00,720.00,4320.00,420.00,'2023-03-12 13:58:51'),(3734,'1','303',1,'Retail Sale Id 3594',0.00,1300.00,720.00,1440.00,140.00,'2023-03-12 14:12:36'),(3735,'1','303',1,'Retail Sale Id 3595',0.00,3250.00,720.00,3600.00,350.00,'2023-03-12 14:46:57'),(3736,'1','303',1,'Retail Sale Id 3595',0.00,3971.50,720.00,4399.20,427.70,'2023-03-12 14:46:57'),(3737,'1','303',1,'Retail Sale Id 3596',0.00,3900.00,720.00,4320.00,420.00,'2023-03-12 14:48:45'),(3738,'1','303',1,'Retail Sale Id 3597',0.00,3900.00,720.00,4320.00,420.00,'2023-03-12 14:53:24'),(3739,'1','303',1,'Retail Sale Id 3597',0.00,3900.00,720.00,4320.00,420.00,'2023-03-12 14:53:24'),(3740,'1','303',1,'Retail Sale Id 3598',0.00,4550.00,720.00,5040.00,490.00,'2023-03-12 14:56:21'),(3741,'1','303',1,'Retail Sale Id 3599',0.00,903.50,720.00,1000.80,97.30,'2023-03-12 15:07:51'),(3742,'1','303',1,'Retail Sale Id 3600',0.00,3900.00,720.00,4320.00,420.00,'2023-03-12 15:16:46'),(3743,'1','303',1,'Retail Sale Id 3601',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-12 15:28:20'),(3744,'1','303',1,'Retail Sale Id 3602',0.00,1807.00,720.00,2001.60,194.60,'2023-03-12 15:32:11'),(3745,'1','303',1,'Retail Sale Id 3603',0.00,1300.00,720.00,1440.00,140.00,'2023-03-12 15:34:51'),(3746,'1','303',1,'Retail Sale Id 3604',0.00,721.50,720.00,799.20,77.70,'2023-03-12 15:38:36'),(3747,'1','303',1,'Retail Sale Id 3605',0.00,2255.50,720.00,2498.40,242.90,'2023-03-12 15:42:52'),(3748,'1','303',1,'Retail Sale Id 3606',0.00,903.50,720.00,1000.80,97.30,'2023-03-12 16:12:14'),(3749,'1','303',1,'Retail Sale Id 3607',0.00,1950.00,720.00,2160.00,210.00,'2023-03-12 16:24:22'),(3750,'1','303',1,'Retail Sale Id 3608',0.00,3900.00,720.00,4320.00,420.00,'2023-03-12 16:32:29'),(3751,'1','303',1,'Retail Sale Id 3609',0.00,3900.00,720.00,4320.00,420.00,'2023-03-12 16:42:48'),(3752,'1','303',1,'Retail Sale Id 3610',0.00,3900.00,720.00,4320.00,420.00,'2023-03-12 16:45:29'),(3753,'1','303',1,'Retail Sale Id 3611',0.00,1261.00,720.00,1396.80,135.80,'2023-03-12 16:52:51'),(3754,'1','303',1,'Retail Sale Id 3612',0.00,903.50,720.00,1000.80,97.30,'2023-03-12 16:58:21'),(3755,'1','303',1,'Retail Sale Id 3613',0.00,2710.50,720.00,3002.40,291.90,'2023-03-12 17:00:28'),(3756,'1','303',1,'Retail Sale Id 3614',0.00,3900.00,720.00,4320.00,420.00,'2023-03-12 17:10:02'),(3757,'1','303',1,'Retail Sale Id 3615',0.00,1950.00,720.00,2160.00,210.00,'2023-03-12 17:11:58'),(3758,'1','303',1,'Retail Sale Id 3616',0.00,8125.00,720.00,9000.00,875.00,'2023-03-12 17:19:08'),(3759,'1','303',1,'Retail Sale Id 3617',0.00,1950.00,720.00,2160.00,210.00,'2023-03-12 17:21:30'),(3760,'1','303',1,'Retail Sale Id 3618',0.00,3900.00,720.00,4320.00,420.00,'2023-03-12 17:29:57'),(3761,'1','303',1,'Retail Sale Id 3619',0.00,1950.00,720.00,2160.00,210.00,'2023-03-12 17:35:27'),(3762,'1','303',1,'Retail Sale Id 3620',0.00,2600.00,720.00,2880.00,280.00,'2023-03-12 18:01:56'),(3763,'1','303',1,'Return of Retail Sale Id 3612',903.50,0.00,720.00,-1000.80,-97.30,'2023-03-12 18:47:50'),(3764,'1','303',1,'Retail Sale Id 3621',0.00,858.00,720.00,950.40,92.40,'2023-03-12 18:48:44'),(3765,'1','303',1,'Retail Sale Id 3622',0.00,3900.00,720.00,4320.00,420.00,'2023-03-13 08:13:07'),(3766,'1','303',1,'Retail Sale Id 3623',0.00,8125.00,720.00,9000.00,875.00,'2023-03-13 08:21:00'),(3767,'1','303',1,'Retail Sale Id 3624',0.00,2710.50,720.00,3002.40,291.90,'2023-03-13 08:22:42'),(3768,'1','303',1,'Retail Sale Id 3625',0.00,3900.00,720.00,4320.00,420.00,'2023-03-13 08:23:47'),(3769,'1','303',1,'Retail Sale Id 3626',0.00,3250.00,720.00,3600.00,350.00,'2023-03-13 08:55:01'),(3770,'1','303',1,'Retail Sale Id 3627',0.00,1807.00,720.00,2001.60,194.60,'2023-03-13 08:59:26'),(3771,'1','303',1,'Retail Sale Id 3628',0.00,1950.00,720.00,2160.00,210.00,'2023-03-13 09:01:01'),(3772,'1','303',1,'Retail Sale Id 3629',0.00,3900.00,720.00,4320.00,420.00,'2023-03-13 09:05:14'),(3773,'1','303',1,'Retail Sale Id 3630',0.00,5850.00,720.00,6480.00,630.00,'2023-03-13 09:09:23'),(3774,'1','303',1,'Retail Sale Id 3631',0.00,3900.00,720.00,4320.00,420.00,'2023-03-13 09:13:58'),(3775,'1','303',1,'Retail Sale Id 3632',0.00,7150.00,720.00,7920.00,770.00,'2023-03-13 09:37:22'),(3776,'1','303',1,'Retail Sale Id 3633',0.00,1950.00,720.00,2160.00,210.00,'2023-03-13 09:43:55'),(3777,'1','303',1,'Retail Sale Id 3634',0.00,1352.00,720.00,1497.60,145.60,'2023-03-13 09:47:01'),(3778,'1','303',1,'Retail Sale Id 3635',0.00,26000.00,690.00,27600.00,1600.00,'2023-03-13 09:52:37'),(3779,'1','303',1,'Retail Sale Id 3636',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-13 10:04:36'),(3780,'1','303',1,'Retail Sale Id 3637',0.00,1950.00,720.00,2160.00,210.00,'2023-03-13 10:07:14'),(3781,'1','303',1,'Retail Sale Id 3638',0.00,1807.00,720.00,2001.60,194.60,'2023-03-13 10:08:47'),(3782,'1','303',1,'Retail Sale Id 3639',0.00,903.50,720.00,1000.80,97.30,'2023-03-13 10:11:39'),(3783,'1','303',1,'Retail Sale Id 3640',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-13 10:17:02'),(3784,'1','303',1,'Retail Sale Id 3641',0.00,3250.00,720.00,3600.00,350.00,'2023-03-13 10:26:49'),(3785,'1','303',1,'Retail Sale Id 3642',0.00,3900.00,720.00,4320.00,420.00,'2023-03-13 10:38:09'),(3786,'1','303',1,'Retail Sale Id 3643',0.00,3900.00,720.00,4320.00,420.00,'2023-03-13 10:40:56'),(3787,'1','303',1,'Retail Sale Id 3644',0.00,162500.00,690.00,172500.00,10000.00,'2023-03-13 10:47:03'),(3788,'1','303',1,'Retail Sale Id 3645',0.00,37700.00,690.00,40020.00,2320.00,'2023-03-13 10:50:04'),(3789,'1','303',1,'Retail Sale Id 3646',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-13 10:51:42'),(3790,'1','303',1,'Retail Sale Id 3647',0.00,903.50,720.00,1000.80,97.30,'2023-03-13 10:53:04'),(3791,'1','303',1,'Retail Sale Id 3648',0.00,1950.00,720.00,2160.00,210.00,'2023-03-13 10:58:18'),(3792,'1','303',1,'Retail Sale Id 3649',0.00,630.50,720.00,698.40,67.90,'2023-03-13 11:00:27'),(3793,'1','303',1,'Retail Sale Id 3650',0.00,7150.00,720.00,7920.00,770.00,'2023-03-13 11:12:59'),(3794,'1','303',1,'Retail Sale Id 3651',0.00,1950.00,720.00,2160.00,210.00,'2023-03-13 11:16:44'),(3795,'1','303',1,'Retail Sale Id 3653',0.00,3250.00,720.00,3600.00,350.00,'2023-03-13 11:25:04'),(3796,'1','303',1,'Retail Sale Id 3653',0.00,3900.00,720.00,4320.00,420.00,'2023-03-13 11:25:04'),(3797,'1','303',1,'Retail Sale Id 3653',0.00,8125.00,720.00,9000.00,875.00,'2023-03-13 11:25:04'),(3798,'1','303',1,'Retail Sale Id 3653',0.00,8125.00,720.00,9000.00,875.00,'2023-03-13 11:25:04'),(3799,'1','303',1,'Retail Sale Id 3653',0.00,8125.00,720.00,9000.00,875.00,'2023-03-13 11:25:04'),(3800,'1','303',1,'Retail Sale Id 3654',0.00,3900.00,720.00,4320.00,420.00,'2023-03-13 11:30:56'),(3801,'1','303',1,'Retail Sale Id 3656',0.00,8125.00,720.00,9000.00,875.00,'2023-03-13 11:35:43'),(3802,'1','303',1,'Retail Sale Id 3657',0.00,3250.00,720.00,3600.00,350.00,'2023-03-13 11:37:43'),(3803,'1','303',1,'Retail Sale Id 3658',0.00,1950.00,720.00,2160.00,210.00,'2023-03-13 11:39:27'),(3804,'1','303',1,'Retail Sale Id 3659',0.00,130000.00,690.00,138000.00,8000.00,'2023-03-13 11:44:17'),(3805,'1','303',1,'Retail Sale Id 3660',0.00,1807.00,720.00,2001.60,194.60,'2023-03-13 11:46:23'),(3806,'1','303',1,'Retail Sale Id 3661',0.00,65000.00,690.00,69000.00,4000.00,'2023-03-13 11:49:28'),(3807,'1','303',1,'Retail Sale Id 3662',0.00,3250.00,720.00,3600.00,350.00,'2023-03-13 11:58:07'),(3808,'1','303',1,'Retail Sale Id 3663',0.00,1950.00,720.00,2160.00,210.00,'2023-03-13 12:02:42'),(3809,'1','303',1,'Retail Sale Id 3663',0.00,1950.00,720.00,2160.00,210.00,'2023-03-13 12:02:42'),(3810,'1','303',1,'Retail Sale Id 3664',0.00,1950.00,720.00,2160.00,210.00,'2023-03-13 12:08:35'),(3811,'1','303',1,'Retail Sale Id 3665',0.00,1989.00,720.00,2203.20,214.20,'2023-03-13 12:21:51'),(3812,'1','303',1,'Retail Sale Id 3666',0.00,3250.00,720.00,3600.00,350.00,'2023-03-13 12:25:34'),(3813,'1','303',1,'Retail Sale Id 3667',0.00,1807.00,720.00,2001.60,194.60,'2023-03-13 12:27:14'),(3814,'1','303',1,'Retail Sale Id 3668',0.00,6500.00,720.00,7200.00,700.00,'2023-03-13 12:28:43'),(3815,'1','303',1,'Retail Sale Id 3669',0.00,1352.00,720.00,1497.60,145.60,'2023-03-13 12:35:03'),(3816,'1','303',1,'Retail Sale Id 3670',0.00,1943.50,720.00,2152.80,209.30,'2023-03-13 12:52:09'),(3817,'1','303',1,'Retail Sale Id 3671',0.00,3250.00,720.00,3600.00,350.00,'2023-03-13 13:02:03'),(3818,'1','303',1,'Retail Sale Id 3672',0.00,3900.00,720.00,4320.00,420.00,'2023-03-13 13:04:09'),(3819,'1','303',1,'Retail Sale Id 3673',0.00,1950.00,720.00,2160.00,210.00,'2023-03-13 13:08:03'),(3820,'1','303',1,'Retail Sale Id 3674',0.00,1300.00,720.00,1440.00,140.00,'2023-03-13 13:25:27'),(3821,'1','303',1,'Retail Sale Id 3675',0.00,1950.00,720.00,2160.00,210.00,'2023-03-13 13:32:44'),(3822,'1','303',1,'Retail Sale Id 3676',0.00,2600.00,720.00,2880.00,280.00,'2023-03-13 13:38:20'),(3823,'1','303',1,'Retail Sale Id 3677',0.00,1300.00,720.00,1440.00,140.00,'2023-03-13 13:46:35'),(3824,'1','303',1,'Retail Sale Id 3678',0.00,1352.00,720.00,1497.60,145.60,'2023-03-13 13:51:00'),(3825,'1','303',1,'Retail Sale Id 3678',0.00,1352.00,720.00,1497.60,145.60,'2023-03-13 13:51:00'),(3826,'1','303',1,'Retail Sale Id 3679',0.00,650.00,720.00,720.00,70.00,'2023-03-13 13:56:24'),(3827,'1','303',1,'Retail Sale Id 3680',0.00,3250.00,720.00,3600.00,350.00,'2023-03-13 13:57:26'),(3828,'1','303',1,'Retail Sale Id 3681',0.00,3250.00,720.00,3600.00,350.00,'2023-03-13 14:05:54'),(3829,'1','303',1,'Retail Sale Id 3682',0.00,2600.00,720.00,2880.00,280.00,'2023-03-13 14:14:19'),(3830,'1','303',1,'Retail Sale Id 3684',0.00,3250.00,720.00,3600.00,350.00,'2023-03-13 14:20:58'),(3831,'1','303',1,'Retail Sale Id 3685',0.00,7150.00,720.00,7920.00,770.00,'2023-03-13 14:29:17'),(3832,'1','303',1,'Retail Sale Id 3686',0.00,3900.00,720.00,4320.00,420.00,'2023-03-13 14:39:00'),(3833,'1','303',1,'Retail Sale Id 3687',0.00,903.50,720.00,1000.80,97.30,'2023-03-13 14:42:36'),(3834,'1','303',1,'Retail Sale Id 3688',0.00,903.50,720.00,1000.80,97.30,'2023-03-13 14:46:59'),(3835,'1','303',1,'Retail Sale Id 3689',0.00,1950.00,720.00,2160.00,210.00,'2023-03-13 15:28:01'),(3836,'1','303',1,'Retail Sale Id 3690',0.00,195000.00,690.00,207000.00,12000.00,'2023-03-13 15:31:11'),(3837,'1','303',1,'Retail Sale Id 3691',0.00,1950.00,720.00,2160.00,210.00,'2023-03-13 15:32:23'),(3838,'1','303',1,'Retail Sale Id 3692',0.00,3900.00,720.00,4320.00,420.00,'2023-03-13 15:33:34'),(3839,'1','303',1,'Retail Sale Id 3693',0.00,1950.00,720.00,2160.00,210.00,'2023-03-13 15:34:25'),(3840,'1','303',1,'Retail Sale Id 3694',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-13 15:43:36'),(3841,'1','303',1,'Retail Sale Id 3695',0.00,3900.00,720.00,4320.00,420.00,'2023-03-13 15:45:07'),(3842,'1','303',1,'Retail Sale Id 3695',0.00,5850.00,720.00,6480.00,630.00,'2023-03-13 15:45:07'),(3843,'1','303',1,'Retail Sale Id 3695',0.00,8125.00,720.00,9000.00,875.00,'2023-03-13 15:45:07'),(3844,'1','303',1,'Retail Sale Id 3696',0.00,1950.00,720.00,2160.00,210.00,'2023-03-13 15:46:41'),(3845,'1','303',1,'Retail Sale Id 3697',0.00,1300.00,720.00,1440.00,140.00,'2023-03-13 15:56:35'),(3846,'1','303',1,'Retail Sale Id 3698',0.00,8125.00,720.00,9000.00,875.00,'2023-03-13 16:02:01'),(3847,'1','303',1,'Retail Sale Id 3699',0.00,3900.00,720.00,4320.00,420.00,'2023-03-13 16:05:09'),(3848,'1','303',1,'Retail Sale Id 3700',0.00,4062.50,720.00,4500.00,437.50,'2023-03-13 16:06:53'),(3849,'1','303',1,'Retail Sale Id 3701',0.00,3900.00,720.00,4320.00,420.00,'2023-03-13 16:16:36'),(3850,'1','303',1,'Retail Sale Id 3702',0.00,8125.00,720.00,9000.00,875.00,'2023-03-13 16:27:45'),(3851,'1','303',1,'Retail Sale Id 3703',0.00,1950.00,720.00,2160.00,210.00,'2023-03-13 16:29:01'),(3852,'1','303',1,'Retail Sale Id 3704',0.00,3900.00,720.00,4320.00,420.00,'2023-03-13 16:31:24'),(3853,'1','303',1,'Retail Sale Id 3705',0.00,903.50,720.00,1000.80,97.30,'2023-03-13 16:36:40'),(3854,'1','303',1,'Retail Sale Id 3706',0.00,3900.00,720.00,4320.00,420.00,'2023-03-13 16:44:38'),(3855,'1','303',1,'Retail Sale Id 3707',0.00,1352.00,720.00,1497.60,145.60,'2023-03-13 16:47:14'),(3856,'1','303',1,'Retail Sale Id 3709',0.00,1950.00,720.00,2160.00,210.00,'2023-03-13 16:56:12'),(3857,'1','303',1,'Retail Sale Id 3709',0.00,8125.00,720.00,9000.00,875.00,'2023-03-13 16:56:12'),(3858,'1','303',1,'Retail Sale Id 3710',0.00,3250.00,720.00,3600.00,350.00,'2023-03-13 17:00:50'),(3859,'1','303',1,'Retail Sale Id 3711',0.00,1950.00,720.00,2160.00,210.00,'2023-03-13 17:02:05'),(3860,'1','303',1,'Retail Sale Id 3712',0.00,903.50,720.00,1000.80,97.30,'2023-03-13 17:09:22'),(3861,'1','303',1,'Retail Sale Id 3713',0.00,1989.00,720.00,2203.20,214.20,'2023-03-13 17:42:07'),(3862,'1','303',1,'Retail Sale Id 3714',0.00,1950.00,720.00,2160.00,210.00,'2023-03-13 17:44:51'),(3863,'1','303',1,'Retail Sale Id 3715',0.00,3900.00,720.00,4320.00,420.00,'2023-03-13 17:48:59'),(3864,'1','303',1,'Retail Sale Id 3716',0.00,3926.00,720.00,4348.80,422.80,'2023-03-13 17:51:42'),(3865,'1','303',1,'Retail Sale Id 3717',0.00,1950.00,720.00,2160.00,210.00,'2023-03-13 17:54:08'),(3866,'1','303',1,'Retail Sale Id 3718',0.00,2710.50,720.00,3002.40,291.90,'2023-03-13 17:58:39'),(3867,'1','303',1,'Retail Sale Id 3719',0.00,1807.00,720.00,2001.60,194.60,'2023-03-13 18:05:13'),(3868,'1','303',1,'Retail Sale Id 3720',0.00,1085.50,720.00,1202.40,116.90,'2023-03-13 18:07:57'),(3869,'1','303',1,'Retail Sale Id 3721',0.00,1085.50,720.00,1202.40,116.90,'2023-03-13 18:12:00'),(3870,'1','303',1,'Retail Sale Id 3722',0.00,65000.00,690.00,69000.00,4000.00,'2023-03-13 18:13:08'),(3871,'1','303',1,'Retail Sale Id 3723',0.00,903.50,720.00,1000.80,97.30,'2023-03-13 18:32:36'),(3872,'1','303',1,'Retail Sale Id 3724',0.00,650.00,720.00,720.00,70.00,'2023-03-13 18:43:11'),(3873,'1','303',1,'Return of Retail Sale Id 3718',2710.50,0.00,720.00,-3002.40,-291.90,'2023-03-13 19:15:32'),(3874,'1','303',1,'Retail Sale Id 3725',0.00,643.50,720.00,712.80,69.30,'2023-03-13 19:16:24'),(3875,'1','303',1,'Return of Retail Sale Id 3720',1085.50,0.00,720.00,-1202.40,-116.90,'2023-03-13 19:20:02'),(3876,'1','303',1,'Retail Sale Id 3726',0.00,123.50,720.00,136.80,13.30,'2023-03-13 19:20:52'),(3877,'1','303',1,'Retail Sale Id 3727',0.00,8125.00,720.00,9000.00,875.00,'2023-03-14 08:24:37'),(3878,'1','303',1,'Retail Sale Id 3728',0.00,2392.00,720.00,2649.60,257.60,'2023-03-14 08:32:34'),(3879,'1','303',1,'Retail Sale Id 3729',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-14 09:03:31'),(3880,'1','303',1,'Retail Sale Id 3730',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 09:05:34'),(3881,'1','303',1,'Retail Sale Id 3731',0.00,7800.00,720.00,8640.00,840.00,'2023-03-14 09:15:03'),(3882,'1','303',1,'Retail Sale Id 3732',0.00,1950.00,720.00,2160.00,210.00,'2023-03-14 09:31:23'),(3883,'1','303',1,'Retail Sale Id 3733',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 09:36:27'),(3884,'1','303',1,'Retail Sale Id 3734',0.00,903.50,720.00,1000.80,97.30,'2023-03-14 09:52:11'),(3885,'1','303',1,'Retail Sale Id 3735',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 10:01:08'),(3886,'1','303',1,'Retail Sale Id 3736',0.00,1950.00,720.00,2160.00,210.00,'2023-03-14 10:03:21'),(3887,'1','303',1,'Retail Sale Id 3737',0.00,65000.00,690.00,69000.00,4000.00,'2023-03-14 10:08:58'),(3888,'1','303',1,'Retail Sale Id 3738',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 10:10:43'),(3889,'1','303',1,'Retail Sale Id 3739',0.00,6500.00,720.00,7200.00,700.00,'2023-03-14 10:12:40'),(3890,'1','303',1,'Retail Sale Id 3740',0.00,1950.00,720.00,2160.00,210.00,'2023-03-14 10:18:40'),(3891,'1','303',1,'Retail Sale Id 3741',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-14 10:45:34'),(3892,'1','303',1,'Retail Sale Id 3742',0.00,1950.00,720.00,2160.00,210.00,'2023-03-14 10:46:34'),(3893,'1','303',1,'Retail Sale Id 3743',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-14 11:11:33'),(3894,'1','303',1,'Retail Sale Id 3744',0.00,1950.00,720.00,2160.00,210.00,'2023-03-14 11:15:55'),(3895,'1','303',1,'Retail Sale Id 3744',0.00,1950.00,720.00,2160.00,210.00,'2023-03-14 11:15:55'),(3896,'1','303',1,'Retail Sale Id 3744',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 11:15:55'),(3897,'1','303',1,'Retail Sale Id 3745',0.00,1807.00,720.00,2001.60,194.60,'2023-03-14 11:29:15'),(3898,'1','303',1,'Retail Sale Id 3746',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 11:31:03'),(3899,'1','303',1,'Retail Sale Id 3747',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 11:35:46'),(3900,'1','303',1,'Retail Sale Id 3747',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 11:35:46'),(3901,'1','303',1,'Retail Sale Id 3748',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 11:39:36'),(3902,'1','303',1,'Retail Sale Id 3749',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 11:41:28'),(3903,'1','303',1,'Retail Sale Id 3750',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 11:50:37'),(3904,'1','303',1,'Retail Sale Id 3751',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 12:01:32'),(3905,'1','303',1,'Retail Sale Id 3752',0.00,8125.00,720.00,9000.00,875.00,'2023-03-14 12:07:38'),(3906,'1','303',1,'Retail Sale Id 3753',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-14 12:10:52'),(3907,'1','303',1,'Retail Sale Id 3754',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 12:23:02'),(3908,'1','303',1,'Retail Sale Id 3755',0.00,903.50,720.00,1000.80,97.30,'2023-03-14 12:34:31'),(3909,'1','303',1,'Retail Sale Id 3756',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 12:36:13'),(3910,'1','303',1,'Retail Sale Id 3757',0.00,448.50,720.00,496.80,48.30,'2023-03-14 12:40:54'),(3911,'1','303',1,'Retail Sale Id 3758',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 12:47:03'),(3912,'1','303',1,'Retail Sale Id 3759',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-14 13:04:16'),(3913,'1','303',1,'Retail Sale Id 3760',0.00,1950.00,720.00,2160.00,210.00,'2023-03-14 13:05:58'),(3914,'1','303',1,'Retail Sale Id 3761',0.00,1807.00,720.00,2001.60,194.60,'2023-03-14 13:13:49'),(3915,'1','303',1,'Retail Sale Id 3762',0.00,650.00,720.00,720.00,70.00,'2023-03-14 13:30:20'),(3916,'1','303',1,'Retail Sale Id 3762',0.00,3250.00,720.00,3600.00,350.00,'2023-03-14 13:30:20'),(3917,'1','303',1,'Retail Sale Id 3763',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 13:36:19'),(3918,'1','303',1,'Retail Sale Id 3764',0.00,1950.00,720.00,2160.00,210.00,'2023-03-14 13:38:49'),(3919,'1','303',1,'Retail Sale Id 3765',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 13:53:59'),(3920,'1','303',1,'Retail Sale Id 3766',0.00,37700.00,690.00,40020.00,2320.00,'2023-03-14 14:03:04'),(3921,'1','303',1,'Retail Sale Id 3767',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 14:22:49'),(3922,'1','303',1,'Retail Sale Id 3768',0.00,3159.00,720.00,3499.20,340.20,'2023-03-14 14:25:37'),(3923,'1','303',1,'Retail Sale Id 3769',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 14:38:59'),(3924,'1','303',1,'Retail Sale Id 3770',0.00,1950.00,720.00,2160.00,210.00,'2023-03-14 14:44:04'),(3925,'1','303',1,'Retail Sale Id 3770',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 14:44:04'),(3926,'1','303',1,'Retail Sale Id 3771',0.00,903.50,720.00,1000.80,97.30,'2023-03-14 14:52:02'),(3927,'1','303',1,'Retail Sale Id 3772',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 15:02:36'),(3928,'1','303',1,'Retail Sale Id 3773',0.00,8125.00,720.00,9000.00,875.00,'2023-03-14 15:09:06'),(3929,'1','303',1,'Retail Sale Id 3774',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 15:12:22'),(3930,'1','303',1,'Retail Sale Id 3775',0.00,1950.00,720.00,2160.00,210.00,'2023-03-14 15:14:51'),(3931,'1','303',1,'Retail Sale Id 3776',0.00,903.50,720.00,1000.80,97.30,'2023-03-14 15:24:55'),(3932,'1','303',1,'Retail Sale Id 3777',0.00,8125.00,720.00,9000.00,875.00,'2023-03-14 15:26:14'),(3933,'1','303',1,'Retail Sale Id 3778',0.00,1950.00,720.00,2160.00,210.00,'2023-03-14 15:41:24'),(3934,'1','303',1,'Retail Sale Id 3779',0.00,2710.50,720.00,3002.40,291.90,'2023-03-14 15:44:58'),(3935,'1','303',1,'Retail Sale Id 3780',0.00,1950.00,720.00,2160.00,210.00,'2023-03-14 16:02:37'),(3936,'1','303',1,'Retail Sale Id 3781',0.00,1807.00,720.00,2001.60,194.60,'2023-03-14 16:14:06'),(3937,'1','303',1,'Retail Sale Id 3782',0.00,2710.50,720.00,3002.40,291.90,'2023-03-14 16:16:08'),(3938,'1','303',1,'Retail Sale Id 3783',0.00,1300.00,720.00,1440.00,140.00,'2023-03-14 16:19:46'),(3939,'1','303',1,'Retail Sale Id 3784',0.00,1950.00,720.00,2160.00,210.00,'2023-03-14 16:23:34'),(3940,'1','303',1,'Retail Sale Id 3785',0.00,1950.00,720.00,2160.00,210.00,'2023-03-14 16:28:48'),(3941,'1','303',1,'Retail Sale Id 3786',0.00,8125.00,720.00,9000.00,875.00,'2023-03-14 16:32:11'),(3942,'1','303',1,'Retail Sale Id 3786',0.00,8125.00,720.00,9000.00,875.00,'2023-03-14 16:32:11'),(3943,'1','303',1,'Retail Sale Id 3787',0.00,1950.00,720.00,2160.00,210.00,'2023-03-14 16:51:50'),(3944,'1','303',1,'Retail Sale Id 3788',0.00,8125.00,720.00,9000.00,875.00,'2023-03-14 16:54:59'),(3945,'1','303',1,'Retail Sale Id 3789',0.00,7221.50,720.00,7999.20,777.70,'2023-03-14 17:04:54'),(3946,'1','303',1,'Retail Sale Id 3790',0.00,1300.00,720.00,1440.00,140.00,'2023-03-14 17:20:56'),(3947,'1','303',1,'Retail Sale Id 3791',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 17:29:18'),(3948,'1','303',1,'Retail Sale Id 3792',0.00,2600.00,720.00,2880.00,280.00,'2023-03-14 17:31:56'),(3949,'1','303',1,'Retail Sale Id 3793',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-14 17:36:22'),(3950,'1','303',1,'Retail Sale Id 3794',0.00,3900.00,720.00,4320.00,420.00,'2023-03-14 17:37:30'),(3951,'1','303',1,'Retail Sale Id 3795',0.00,1950.00,720.00,2160.00,210.00,'2023-03-14 17:40:27'),(3952,'1','303',1,'Retail Sale Id 3795',0.00,1950.00,720.00,2160.00,210.00,'2023-03-14 17:40:27'),(3953,'1','303',1,'Retail Sale Id 3796',0.00,806.00,720.00,892.80,86.80,'2023-03-14 19:23:28'),(3954,'1','303',1,'Retail Sale Id 3797',0.00,23400.00,690.00,24840.00,1440.00,'2023-03-15 07:34:06'),(3955,'1','303',1,'Retail Sale Id 3798',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 07:43:15'),(3956,'1','303',1,'Retail Sale Id 3799',0.00,1950.00,720.00,2160.00,210.00,'2023-03-15 07:46:13'),(3957,'1','303',1,'Retail Sale Id 3800',0.00,2710.50,720.00,3002.40,291.90,'2023-03-15 07:52:22'),(3958,'1','303',1,'Retail Sale Id 3801',0.00,3250.00,720.00,3600.00,350.00,'2023-03-15 07:54:44'),(3959,'1','303',1,'Retail Sale Id 3802',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 08:22:54'),(3960,'1','303',1,'Retail Sale Id 3803',0.00,1989.00,720.00,2203.20,214.20,'2023-03-15 08:35:29'),(3961,'1','303',1,'Retail Sale Id 3804',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 08:37:55'),(3962,'1','303',1,'Retail Sale Id 3805',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 08:56:24'),(3963,'1','303',1,'Retail Sale Id 3806',0.00,8125.00,720.00,9000.00,875.00,'2023-03-15 08:59:38'),(3964,'1','303',1,'Retail Sale Id 3807',0.00,1950.00,720.00,2160.00,210.00,'2023-03-15 09:04:08'),(3965,'1','303',1,'Retail Sale Id 3808',0.00,1950.00,720.00,2160.00,210.00,'2023-03-15 09:07:30'),(3966,'1','303',1,'Retail Sale Id 3809',0.00,65000.00,690.00,69000.00,4000.00,'2023-03-15 09:10:02'),(3967,'1','303',1,'Retail Sale Id 3810',0.00,1950.00,720.00,2160.00,210.00,'2023-03-15 09:11:39'),(3968,'1','303',1,'Retail Sale Id 3811',0.00,3250.00,720.00,3600.00,350.00,'2023-03-15 09:16:02'),(3969,'1','303',1,'Retail Sale Id 3814',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 09:19:55'),(3970,'1','303',1,'Retail Sale Id 3815',0.00,8125.00,720.00,9000.00,875.00,'2023-03-15 09:29:26'),(3971,'1','303',1,'Retail Sale Id 3816',0.00,2710.50,720.00,3002.40,291.90,'2023-03-15 09:30:48'),(3972,'1','303',1,'Retail Sale Id 3817',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 09:42:48'),(3973,'1','303',1,'Retail Sale Id 3818',0.00,8125.00,720.00,9000.00,875.00,'2023-03-15 09:46:03'),(3974,'1','303',1,'Retail Sale Id 3820',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 09:50:08'),(3975,'1','303',1,'Retail Sale Id 3822',0.00,91000.00,690.00,96600.00,5600.00,'2023-03-15 09:59:18'),(3976,'1','303',1,'Retail Sale Id 3823',0.00,65000.00,690.00,69000.00,4000.00,'2023-03-15 10:02:06'),(3977,'1','303',1,'Retail Sale Id 3824',0.00,8125.00,720.00,9000.00,875.00,'2023-03-15 10:11:25'),(3978,'1','303',1,'Retail Sale Id 3825',0.00,1950.00,720.00,2160.00,210.00,'2023-03-15 10:16:45'),(3979,'1','303',1,'Retail Sale Id 3825',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 10:16:45'),(3980,'1','303',1,'Retail Sale Id 3826',0.00,2600.00,720.00,2880.00,280.00,'2023-03-15 10:18:11'),(3981,'1','303',1,'Retail Sale Id 3827',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 10:22:23'),(3982,'1','303',1,'Retail Sale Id 3828',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 10:48:22'),(3983,'1','303',1,'Retail Sale Id 3829',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-15 10:56:27'),(3984,'1','303',1,'Retail Sale Id 3830',0.00,6500.00,720.00,7200.00,700.00,'2023-03-15 10:58:03'),(3985,'1','303',1,'Retail Sale Id 3831',0.00,2600.00,720.00,2880.00,280.00,'2023-03-15 11:06:45'),(3986,'1','303',1,'Retail Sale Id 3832',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 11:27:44'),(3987,'1','303',1,'Retail Sale Id 3833',0.00,8125.00,720.00,9000.00,875.00,'2023-03-15 11:35:03'),(3988,'1','303',1,'Retail Sale Id 3835',0.00,3926.00,720.00,4348.80,422.80,'2023-03-15 11:40:42'),(3989,'1','303',1,'Retail Sale Id 3836',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 11:47:05'),(3990,'1','303',1,'Retail Sale Id 3837',0.00,903.50,720.00,1000.80,97.30,'2023-03-15 11:57:04'),(3991,'1','303',1,'Retail Sale Id 3838',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 12:04:29'),(3992,'1','303',1,'Retail Sale Id 3839',0.00,903.50,720.00,1000.80,97.30,'2023-03-15 12:05:27'),(3993,'1','303',1,'Retail Sale Id 3840',0.00,1950.00,720.00,2160.00,210.00,'2023-03-15 12:06:52'),(3994,'1','303',1,'Retail Sale Id 3841',0.00,1807.00,720.00,2001.60,194.60,'2023-03-15 12:17:23'),(3995,'1','303',1,'Retail Sale Id 3842',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 12:22:57'),(3996,'1','303',1,'Retail Sale Id 3843',0.00,1950.00,720.00,2160.00,210.00,'2023-03-15 12:23:50'),(3997,'1','303',1,'Retail Sale Id 3844',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 12:29:27'),(3998,'1','303',1,'Retail Sale Id 3845',0.00,8125.00,720.00,9000.00,875.00,'2023-03-15 12:41:59'),(3999,'1','303',1,'Retail Sale Id 3846',0.00,1950.00,720.00,2160.00,210.00,'2023-03-15 12:47:18'),(4000,'1','303',1,'Retail Sale Id 3846',0.00,7150.00,720.00,7920.00,770.00,'2023-03-15 12:47:18'),(4001,'1','303',1,'Retail Sale Id 3847',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 13:15:21'),(4002,'1','303',1,'Retail Sale Id 3848',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 13:17:01'),(4003,'1','303',1,'Retail Sale Id 3849',0.00,3250.00,720.00,3600.00,350.00,'2023-03-15 13:33:45'),(4004,'1','303',1,'Retail Sale Id 3850',0.00,1950.00,720.00,2160.00,210.00,'2023-03-15 13:43:23'),(4005,'1','303',1,'Retail Sale Id 3851',0.00,1950.00,720.00,2160.00,210.00,'2023-03-15 13:44:22'),(4006,'1','303',1,'Retail Sale Id 3852',0.00,1950.00,720.00,2160.00,210.00,'2023-03-15 13:50:08'),(4007,'1','303',1,'Retail Sale Id 3853',0.00,650.00,720.00,720.00,70.00,'2023-03-15 13:50:59'),(4008,'1','303',1,'Retail Sale Id 3854',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 13:53:48'),(4009,'1','303',1,'Retail Sale Id 3855',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 13:56:07'),(4010,'1','303',1,'Retail Sale Id 3856',0.00,8125.00,720.00,9000.00,875.00,'2023-03-15 14:01:05'),(4011,'1','303',1,'Retail Sale Id 3857',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 14:16:58'),(4012,'1','303',1,'Retail Sale Id 3858',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 14:19:18'),(4013,'1','303',1,'Retail Sale Id 3859',0.00,1950.00,720.00,2160.00,210.00,'2023-03-15 14:29:59'),(4014,'1','303',1,'Retail Sale Id 3860',0.00,3880.50,720.00,4298.40,417.90,'2023-03-15 14:34:57'),(4015,'1','303',1,'Retail Sale Id 3861',0.00,8125.00,720.00,9000.00,875.00,'2023-03-15 14:36:39'),(4016,'1','303',1,'Retail Sale Id 3862',0.00,8125.00,720.00,9000.00,875.00,'2023-03-15 14:38:47'),(4017,'1','303',1,'Retail Sale Id 3863',0.00,1300.00,720.00,1440.00,140.00,'2023-03-15 14:42:05'),(4018,'1','303',1,'Retail Sale Id 3864',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 14:44:42'),(4019,'1','303',1,'Retail Sale Id 3865',0.00,1950.00,720.00,2160.00,210.00,'2023-03-15 14:52:16'),(4020,'1','303',1,'Retail Sale Id 3866',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 14:53:16'),(4021,'1','303',1,'Retail Sale Id 3867',0.00,8125.00,720.00,9000.00,875.00,'2023-03-15 15:05:08'),(4022,'1','303',1,'Retail Sale Id 3868',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 15:05:59'),(4023,'1','303',1,'Retail Sale Id 3869',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 15:22:49'),(4024,'1','303',1,'Retail Sale Id 3870',0.00,16250.00,690.00,17250.00,1000.00,'2023-03-15 15:29:02'),(4025,'1','303',1,'Retail Sale Id 3871',0.00,37700.00,690.00,40020.00,2320.00,'2023-03-15 15:48:04'),(4026,'1','303',1,'Retail Sale Id 3872',0.00,3250.00,720.00,3600.00,350.00,'2023-03-15 15:51:08'),(4027,'1','303',1,'Retail Sale Id 3873',0.00,1950.00,720.00,2160.00,210.00,'2023-03-15 15:54:08'),(4028,'1','303',1,'Retail Sale Id 3874',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 16:06:03'),(4029,'1','303',1,'Retail Sale Id 3875',0.00,1807.00,720.00,2001.60,194.60,'2023-03-15 16:07:27'),(4030,'1','303',1,'Retail Sale Id 3876',0.00,1950.00,720.00,2160.00,210.00,'2023-03-15 16:10:03'),(4031,'1','303',1,'Retail Sale Id 3877',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-15 16:14:53'),(4032,'1','303',1,'Retail Sale Id 3878',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 16:17:16'),(4033,'1','303',1,'Retail Sale Id 3879',0.00,1989.00,720.00,2203.20,214.20,'2023-03-15 16:21:04'),(4034,'1','303',1,'Retail Sale Id 3880',0.00,1950.00,720.00,2160.00,210.00,'2023-03-15 17:01:02'),(4035,'1','303',1,'Retail Sale Id 3881',0.00,1950.00,720.00,2160.00,210.00,'2023-03-15 17:10:02'),(4036,'1','303',1,'Retail Sale Id 3883',0.00,1950.00,720.00,2160.00,210.00,'2023-03-15 17:12:54'),(4037,'1','303',1,'Retail Sale Id 3884',0.00,65000.00,690.00,69000.00,4000.00,'2023-03-15 17:14:33'),(4038,'1','303',1,'Retail Sale Id 3885',0.00,448.50,720.00,496.80,48.30,'2023-03-15 17:15:34'),(4039,'1','303',1,'Retail Sale Id 3886',0.00,6500.00,720.00,7200.00,700.00,'2023-03-15 17:17:15'),(4040,'1','303',1,'Retail Sale Id 3887',0.00,1898.00,720.00,2102.40,204.40,'2023-03-15 17:22:52'),(4041,'1','303',1,'Retail Sale Id 3888',0.00,3250.00,720.00,3600.00,350.00,'2023-03-15 17:25:27'),(4042,'1','303',1,'Retail Sale Id 3889',0.00,650.00,720.00,720.00,70.00,'2023-03-15 17:26:34'),(4043,'1','303',1,'Retail Sale Id 3890',0.00,1807.00,720.00,2001.60,194.60,'2023-03-15 17:27:47'),(4044,'1','303',1,'Retail Sale Id 3891',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-15 17:28:39'),(4045,'1','303',1,'Retail Sale Id 3892',0.00,1300.00,720.00,1440.00,140.00,'2023-03-15 17:32:53'),(4046,'1','303',1,'Retail Sale Id 3893',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 17:35:18'),(4047,'1','303',1,'Retail Sale Id 3894',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 17:37:26'),(4048,'1','303',1,'Return of Retail Sale Id 3889',650.00,0.00,720.00,-720.00,-70.00,'2023-03-15 17:47:55'),(4049,'1','303',1,'Retail Sale Id 3896',0.00,8125.00,720.00,9000.00,875.00,'2023-03-15 17:52:45'),(4050,'1','303',1,'Retail Sale Id 3897',0.00,3900.00,720.00,4320.00,420.00,'2023-03-15 18:08:01'),(4051,'1','303',1,'Retail Sale Id 3898',0.00,1950.00,720.00,2160.00,210.00,'2023-03-15 18:18:40'),(4052,'1','303',1,'Retail Sale Id 3899',0.00,903.50,720.00,1000.80,97.30,'2023-03-15 18:29:05'),(4053,'1','303',1,'Return of Retail Sale Id 3899',903.50,0.00,720.00,-1000.80,-97.30,'2023-03-15 18:42:55'),(4054,'1','303',1,'Return of Retail Sale Id 3892',1300.00,0.00,720.00,-1440.00,-140.00,'2023-03-15 18:56:13'),(4055,'1','303',1,'Retail Sale Id 3901',0.00,708.50,720.00,784.80,76.30,'2023-03-15 18:57:02'),(4056,'1','303',1,'Retail Sale Id 3904',0.00,650.00,690.00,690.00,40.00,'2023-03-15 19:01:58'),(4057,'1','303',1,'Retail Sale Id 3905',0.00,1950.00,720.00,2160.00,210.00,'2023-03-16 08:13:17'),(4058,'1','303',1,'Retail Sale Id 3906',0.00,1950.00,720.00,2160.00,210.00,'2023-03-16 08:52:11'),(4059,'1','303',1,'Retail Sale Id 3907',0.00,3900.00,720.00,4320.00,420.00,'2023-03-16 09:38:03'),(4060,'1','303',1,'Retail Sale Id 3908',0.00,1989.00,720.00,2203.20,214.20,'2023-03-16 09:44:55'),(4061,'1','303',1,'Retail Sale Id 3909',0.00,1534.00,720.00,1699.20,165.20,'2023-03-16 09:46:31'),(4062,'1','303',1,'Retail Sale Id 3910',0.00,130000.00,690.00,138000.00,8000.00,'2023-03-16 09:58:06'),(4063,'1','303',1,'Retail Sale Id 3911',0.00,1950.00,720.00,2160.00,210.00,'2023-03-16 10:01:58'),(4064,'1','303',1,'Retail Sale Id 3912',0.00,1352.00,720.00,1497.60,145.60,'2023-03-16 10:10:45'),(4065,'1','303',1,'Retail Sale Id 3913',0.00,1352.00,720.00,1497.60,145.60,'2023-03-16 10:35:53'),(4066,'1','303',1,'Retail Sale Id 3914',0.00,1950.00,720.00,2160.00,210.00,'2023-03-16 10:44:28'),(4067,'1','303',1,'Retail Sale Id 3915',0.00,1950.00,720.00,2160.00,210.00,'2023-03-16 10:49:51'),(4068,'1','303',1,'Retail Sale Id 3915',0.00,1950.00,720.00,2160.00,210.00,'2023-03-16 10:49:51'),(4069,'1','303',1,'Retail Sale Id 3916',0.00,65000.00,690.00,69000.00,4000.00,'2023-03-16 10:51:34'),(4070,'1','303',1,'Retail Sale Id 3917',0.00,3900.00,720.00,4320.00,420.00,'2023-03-16 11:00:44'),(4071,'1','303',1,'Retail Sale Id 3918',0.00,1950.00,720.00,2160.00,210.00,'2023-03-16 11:03:09'),(4072,'1','303',1,'Retail Sale Id 3919',0.00,3900.00,720.00,4320.00,420.00,'2023-03-16 11:04:30'),(4073,'1','303',1,'Retail Sale Id 3920',0.00,250250.00,690.00,265650.00,15400.00,'2023-03-16 11:10:14'),(4074,'1','303',1,'Retail Sale Id 3921',0.00,3926.00,720.00,4348.80,422.80,'2023-03-16 11:28:05'),(4075,'1','303',1,'Retail Sale Id 3922',0.00,32500.00,690.00,34500.00,2000.00,'2023-03-16 11:31:28'),(4076,'1','303',1,'Retail Sale Id 3923',0.00,3250.00,720.00,3600.00,350.00,'2023-03-16 11:33:46'),(4077,'1','303',1,'Retail Sale Id 3924',0.00,1950.00,720.00,2160.00,210.00,'2023-03-16 11:45:58'),(4078,'1','303',1,'Retail Sale Id 3925',0.00,6500.00,720.00,7200.00,700.00,'2023-03-16 11:59:29'),(4079,'1','303',1,'Retail Sale Id 3926',0.00,260000.00,690.00,276000.00,16000.00,'2023-03-16 12:06:59'),(4080,'1','303',1,'Retail Sale Id 3927',0.00,3900.00,720.00,4320.00,420.00,'2023-03-16 12:08:47'),(4081,'1','303',1,'Retail Sale Id 3928',0.00,1950.00,720.00,2160.00,210.00,'2023-03-16 12:12:52'),(4082,'1','303',1,'Retail Sale Id 3929',0.00,2600.00,720.00,2880.00,280.00,'2023-03-16 12:16:19'),(4083,'1','303',1,'Retail Sale Id 3930',0.00,6318.00,720.00,6998.40,680.40,'2023-03-16 12:18:19'),(4084,'1','303',1,'Retail Sale Id 3931',0.00,6500.00,720.00,7200.00,700.00,'2023-03-16 12:19:54'),(4085,'1','303',1,'Retail Sale Id 3932',0.00,97500.00,690.00,103500.00,6000.00,'2023-03-16 12:22:22'),(4086,'1','303',1,'Retail Sale Id 3933',0.00,8125.00,720.00,9000.00,875.00,'2023-03-16 12:24:34'),(4087,'1','303',1,'Retail Sale Id 3934',0.00,2710.50,720.00,3002.40,291.90,'2023-03-16 12:28:47'),(4088,'1','303',1,'Retail Sale Id 3935',0.00,4511.00,720.00,4996.80,485.80,'2023-03-16 12:32:58'),(4089,'1','303',1,'Retail Sale Id 3936',0.00,2710.50,720.00,3002.40,291.90,'2023-03-16 12:34:18'),(4090,'1','303',1,'Retail Sale Id 3937',0.00,65000.00,690.00,69000.00,4000.00,'2023-03-16 12:48:29'),(4091,'1','303',1,'Retail Sale Id 3938',0.00,8125.00,720.00,9000.00,875.00,'2023-03-16 12:50:54'),(4092,'1','303',1,'Retail Sale Id 3939',0.00,3250.00,720.00,3600.00,350.00,'2023-03-16 13:00:31'),(4093,'1','303',1,'Retail Sale Id 3940',0.00,3250.00,720.00,3600.00,350.00,'2023-03-16 13:05:21'),(4094,'1','303',1,'Retail Sale Id 3941',0.00,3900.00,720.00,4320.00,420.00,'2023-03-16 13:07:11'),(4095,'1','303',1,'Retail Sale Id 3942',0.00,3250.00,720.00,3600.00,350.00,'2023-03-16 13:09:46'),(4096,'1','303',1,'Retail Sale Id 3943',0.00,1807.00,720.00,2001.60,194.60,'2023-03-16 13:19:08'),(4097,'1','303',1,'Retail Sale Id 3944',0.00,1950.00,720.00,2160.00,210.00,'2023-03-16 13:26:23'),(4098,'1','303',1,'Retail Sale Id 3945',0.00,1950.00,720.00,2160.00,210.00,'2023-03-16 13:30:18'),(4099,'1','303',1,'Retail Sale Id 3946',0.00,1807.00,720.00,2001.60,194.60,'2023-03-16 13:46:00'),(4100,'1','303',1,'Retail Sale Id 3947',0.00,1807.00,720.00,2001.60,194.60,'2023-03-16 14:00:03'),(4101,'1','303',1,'Retail Sale Id 3948',0.00,3900.00,720.00,4320.00,420.00,'2023-03-16 14:09:24'),(4102,'1','303',1,'Retail Sale Id 3948',0.00,6500.00,720.00,7200.00,700.00,'2023-03-16 14:09:24'),(4103,'1','303',1,'Retail Sale Id 3948',0.00,8125.00,720.00,9000.00,875.00,'2023-03-16 14:09:24'),(4104,'1','303',1,'Retail Sale Id 3949',0.00,3250.00,720.00,3600.00,350.00,'2023-03-16 14:15:18'),(4105,'1','303',1,'Retail Sale Id 3950',0.00,650.00,720.00,720.00,70.00,'2023-03-16 14:23:13'),(4106,'1','303',1,'Retail Sale Id 3951',0.00,6500.00,720.00,7200.00,700.00,'2023-03-16 14:28:15'),(4107,'1','303',1,'Retail Sale Id 3952',0.00,3900.00,720.00,4320.00,420.00,'2023-03-16 14:29:46'),(4108,'1','303',1,'Retail Sale Id 3953',0.00,8125.00,720.00,9000.00,875.00,'2023-03-16 14:34:37'),(4109,'1','303',1,'Retail Sale Id 3954',0.00,8125.00,720.00,9000.00,875.00,'2023-03-16 14:37:12'),(4110,'1','303',1,'Retail Sale Id 3955',0.00,1950.00,720.00,2160.00,210.00,'2023-03-16 14:38:26'),(4111,'1','303',1,'Retail Sale Id 3956',0.00,8125.00,720.00,9000.00,875.00,'2023-03-16 15:30:30'),(4112,'1','303',1,'Retail Sale Id 3957',0.00,3900.00,720.00,4320.00,420.00,'2023-03-16 16:03:47'),(4113,'1','303',1,'Retail Sale Id 3958',0.00,1950.00,720.00,2160.00,210.00,'2023-03-16 16:07:22'),(4114,'1','303',1,'Retail Sale Id 3959',0.00,650.00,720.00,720.00,70.00,'2023-03-16 16:14:42'),(4115,'1','303',1,'Retail Sale Id 3960',0.00,8125.00,720.00,9000.00,875.00,'2023-03-16 16:17:41'),(4116,'1','303',1,'Retail Sale Id 3961',0.00,1807.00,720.00,2001.60,194.60,'2023-03-16 16:19:27'),(4117,'1','303',1,'Retail Sale Id 3962',0.00,3900.00,720.00,4320.00,420.00,'2023-03-16 16:23:31'),(4118,'1','303',1,'Retail Sale Id 3963',0.00,1950.00,720.00,2160.00,210.00,'2023-03-16 16:32:52'),(4119,'1','303',1,'Retail Sale Id 3964',0.00,1625.00,720.00,1800.00,175.00,'2023-03-16 16:34:34'),(4120,'1','303',1,'Retail Sale Id 3965',0.00,3900.00,720.00,4320.00,420.00,'2023-03-16 16:40:04'),(4121,'1','303',1,'Retail Sale Id 3966',0.00,2710.50,720.00,3002.40,291.90,'2023-03-16 16:53:28'),(4122,'1','303',1,'Retail Sale Id 3967',0.00,3900.00,720.00,4320.00,420.00,'2023-03-16 16:57:46'),(4123,'1','303',1,'Retail Sale Id 3968',0.00,1300.00,720.00,1440.00,140.00,'2023-03-16 17:16:03'),(4124,'1','303',1,'Retail Sale Id 3969',0.00,1950.00,720.00,2160.00,210.00,'2023-03-16 17:20:58'),(4125,'1','303',1,'Retail Sale Id 3970',0.00,1950.00,720.00,2160.00,210.00,'2023-03-16 17:22:25'),(4126,'1','303',1,'Retail Sale Id 3971',0.00,3900.00,720.00,4320.00,420.00,'2023-03-16 17:23:57'),(4127,'1','303',1,'Retail Sale Id 3972',0.00,1352.00,720.00,1497.60,145.60,'2023-03-16 17:28:54'),(4128,'1','303',1,'Retail Sale Id 3973',0.00,1950.00,720.00,2160.00,210.00,'2023-03-16 17:59:43'),(4129,'1','303',1,'Retail Sale Id 3974',0.00,903.50,720.00,1000.80,97.30,'2023-03-16 18:01:23'),(4130,'1','303',1,'Retail Sale Id 3975',0.00,3900.00,720.00,4320.00,420.00,'2023-03-16 18:02:12'),(4131,'1','303',1,'Retail Sale Id 3976',0.00,3900.00,720.00,4320.00,420.00,'2023-03-16 18:04:08'),(4132,'1','303',1,'Retail Sale Id 3977',0.00,1300.00,720.00,1440.00,140.00,'2023-03-16 18:05:35'),(4133,'1','303',1,'Retail Sale Id 3978',0.00,8125.00,720.00,9000.00,875.00,'2023-03-16 18:06:53'),(4134,'1','303',1,'Retail Sale Id 3979',0.00,3900.00,720.00,4320.00,420.00,'2023-03-16 18:08:29'),(4135,'1','303',1,'Retail Sale Id 3980',0.00,3900.00,720.00,4320.00,420.00,'2023-03-16 18:14:18'),(4136,'1','303',1,'Retail Sale Id 3981',0.00,1950.00,720.00,2160.00,210.00,'2023-03-16 18:21:14'),(4137,'1','303',1,'Retail Sale Id 3982',0.00,3900.00,720.00,4320.00,420.00,'2023-03-16 18:22:38'),(4138,'1','303',1,'Retail Sale Id 3983',0.00,1950.00,720.00,2160.00,210.00,'2023-03-16 18:25:28'),(4139,'1','303',1,'Retail Sale Id 3984',0.00,84.50,720.00,93.60,9.10,'2023-03-16 19:34:00'),(4140,'1','303',1,'Retail Sale Id 3985',0.00,8450.00,720.00,9360.00,910.00,'2023-03-17 08:12:40'),(4141,'1','303',1,'Retail Sale Id 3986',0.00,3900.00,720.00,4320.00,420.00,'2023-03-17 08:14:12'),(4142,'1','303',1,'Retail Sale Id 3987',0.00,3900.00,720.00,4320.00,420.00,'2023-03-17 08:17:11'),(4143,'1','303',1,'Retail Sale Id 3988',0.00,65000.00,690.00,69000.00,4000.00,'2023-03-17 08:22:02'),(4144,'1','303',1,'Retail Sale Id 3989',0.00,1352.00,720.00,1497.60,145.60,'2023-03-17 08:24:28'),(4145,'1','303',1,'Retail Sale Id 3990',0.00,4062.50,720.00,4500.00,437.50,'2023-03-17 08:27:50'),(4146,'1','303',1,'Retail Sale Id 3991',0.00,3900.00,720.00,4320.00,420.00,'2023-03-17 08:32:39'),(4147,'1','303',1,'Retail Sale Id 3992',0.00,1950.00,720.00,2160.00,210.00,'2023-03-17 08:59:05'),(4148,'1','303',1,'Retail Sale Id 3993',0.00,1950.00,720.00,2160.00,210.00,'2023-03-17 09:00:42'),(4149,'1','303',1,'Retail Sale Id 3994',0.00,1950.00,720.00,2160.00,210.00,'2023-03-17 09:02:19'),(4150,'1','303',1,'Retail Sale Id 3995',0.00,8125.00,720.00,9000.00,875.00,'2023-03-17 09:11:37'),(4151,'1','303',1,'Retail Sale Id 3996',0.00,1950.00,720.00,2160.00,210.00,'2023-03-17 09:23:38'),(4152,'1','303',1,'Retail Sale Id 3997',0.00,8125.00,720.00,9000.00,875.00,'2023-03-17 09:30:11'),(4153,'1','303',1,'Retail Sale Id 3998',0.00,3900.00,720.00,4320.00,420.00,'2023-03-17 09:47:54'),(4154,'1','303',1,'Retail Sale Id 3999',0.00,1950.00,720.00,2160.00,210.00,'2023-03-17 09:49:02'),(4155,'1','303',1,'Retail Sale Id 4000',0.00,3250.00,720.00,3600.00,350.00,'2023-03-17 09:50:21'),(4156,'1','303',1,'Retail Sale Id 4001',0.00,2073.50,720.00,2296.80,223.30,'2023-03-17 10:15:46'),(4157,'1','303',1,'Retail Sale Id 4002',0.00,8125.00,720.00,9000.00,875.00,'2023-03-17 10:18:58'),(4158,'1','303',1,'Retail Sale Id 4003',0.00,1950.00,720.00,2160.00,210.00,'2023-03-17 10:21:02'),(4159,'1','303',1,'Retail Sale Id 4004',0.00,1950.00,720.00,2160.00,210.00,'2023-03-17 10:33:17'),(4160,'1','303',1,'Retail Sale Id 4005',0.00,3900.00,720.00,4320.00,420.00,'2023-03-17 10:40:36'),(4161,'1','303',1,'Retail Sale Id 4006',0.00,903.50,720.00,1000.80,97.30,'2023-03-17 10:41:48'),(4162,'1','303',1,'Retail Sale Id 4007',0.00,1950.00,720.00,2160.00,210.00,'2023-03-17 10:44:25'),(4163,'1','303',1,'Retail Sale Id 4008',0.00,2710.50,720.00,3002.40,291.90,'2023-03-17 10:52:37'),(4164,'1','303',1,'Retail Sale Id 4010',0.00,3900.00,720.00,4320.00,420.00,'2023-03-17 11:00:55'),(4165,'1','303',1,'Retail Sale Id 4011',0.00,1950.00,720.00,2160.00,210.00,'2023-03-17 11:02:20'),(4166,'1','303',1,'Retail Sale Id 4012',0.00,1807.00,720.00,2001.60,194.60,'2023-03-17 11:03:26'),(4167,'1','303',1,'Retail Sale Id 4013',0.00,1950.00,720.00,2160.00,210.00,'2023-03-17 11:04:52'),(4168,'1','303',1,'Retail Sale Id 4014',0.00,3900.00,720.00,4320.00,420.00,'2023-03-17 11:06:28'),(4169,'1','303',1,'Retail Sale Id 4015',0.00,3900.00,720.00,4320.00,420.00,'2023-03-17 11:07:23'),(4170,'1','303',1,'Retail Sale Id 4016',0.00,3900.00,720.00,4320.00,420.00,'2023-03-17 11:09:14'),(4171,'1','303',1,'Retail Sale Id 4017',0.00,1807.00,720.00,2001.60,194.60,'2023-03-17 11:18:05'),(4172,'1','303',1,'Retail Sale Id 4018',0.00,1950.00,720.00,2160.00,210.00,'2023-03-17 11:20:30'),(4173,'1','303',1,'Retail Sale Id 4019',0.00,3900.00,720.00,4320.00,420.00,'2023-03-17 11:27:30'),(4174,'1','303',1,'Retail Sale Id 4020',0.00,1950.00,720.00,2160.00,210.00,'2023-03-17 11:29:19'),(4175,'1','303',1,'Retail Sale Id 4021',0.00,3900.00,720.00,4320.00,420.00,'2023-03-17 11:30:57'),(4176,'1','303',1,'Retail Sale Id 4023',0.00,3900.00,720.00,4320.00,420.00,'2023-03-17 11:38:16'),(4177,'1','303',1,'Retail Sale Id 4024',0.00,3900.00,720.00,4320.00,420.00,'2023-03-17 11:40:42'),(4178,'1','303',1,'Retail Sale Id 4025',0.00,1950.00,720.00,2160.00,210.00,'2023-03-17 12:02:31'),(4179,'1','303',1,'Retail Sale Id 4026',0.00,8125.00,720.00,9000.00,875.00,'2023-03-17 12:28:39'),(4180,'1','303',1,'Retail Sale Id 4027',0.00,3900.00,720.00,4320.00,420.00,'2023-03-17 12:33:48'),(4181,'1','303',1,'Retail Sale Id 4029',0.00,1950.00,720.00,2160.00,210.00,'2023-03-17 12:38:32'),(4182,'1','303',1,'Retail Sale Id 4031',0.00,3900.00,720.00,4320.00,